#include "communication.h"

using namespace roo_display;

// Image file ic_sharp_18_communication_3p 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_sharp_18_communication_3p_data[] PROGMEM = {
  0x18, 0x09, 0x23, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xD8, 0x2D, 0x11, 0xDD,
  0x00, 0x3D, 0x0B, 0x20, 0xBD, 0x00, 0x3E, 0x00, 0x7E, 0x00, 0x3D, 0x82, 0xB7, 0x7B, 0xD0, 0x03,
  0xC0, 0x44, 0x04, 0xC0, 0x03, 0xC8, 0x44, 0x33, 0x33, 0x4C, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00,
  0x3A, 0x09, 0x80, 0x77, 0x82, 0x13, 0xF7, 0x76, 0x03, 0x07, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_3p() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_3p_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_add_ic_call 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_18_communication_add_ic_call_data[] PROGMEM = {
  0x83, 0x8B, 0xBB, 0x55, 0x0B, 0x05, 0x20, 0xAB, 0x08, 0x59, 0x07, 0x20, 0x9B, 0x0A, 0x28, 0x61,
  0x77, 0xFB, 0x75, 0x7B, 0x0C, 0x20, 0x3D, 0x0B, 0x02, 0xB0, 0x85, 0x90, 0x73, 0x81, 0xDF, 0x86,
  0x90, 0x73, 0x81, 0x6F, 0x36, 0x03, 0x01, 0x40, 0xD0, 0xC7, 0x58, 0x14, 0xFA, 0x75, 0x81, 0x6F,
  0xA3, 0x83, 0x8C, 0xA8, 0x54, 0x83, 0x6F, 0xC3, 0x8C, 0x0B, 0x50, 0x40, 0xDE, 0x0B, 0x70, 0x60,
  0xDC, 0x0B, 0x72, 0x83, 0x27, 0x99, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_add_ic_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_add_ic_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_alternate_email 18x18, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_sharp_18_communication_alternate_email_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x93, 0x28, 0x33, 0x9F,
  0xD2, 0x38, 0x21, 0xDE, 0x36, 0x82, 0x3E, 0xD1, 0x28, 0x19, 0xF3, 0x28, 0x25, 0xAA, 0x52, 0x81,
  0x3F, 0x92, 0x90, 0x92, 0x84, 0xAF, 0xDD, 0xFA, 0x28, 0x90, 0x9F, 0x05, 0xF3, 0x05, 0xF6, 0x28,
  0x66, 0xF5, 0x03, 0xF5, 0x69, 0x20, 0xA0, 0xD4, 0x0D, 0x0A, 0x29, 0x00, 0x69, 0x20, 0xA0, 0xD4,
  0x0D, 0x0B, 0x29, 0x86, 0x75, 0xF3, 0x05, 0xF6, 0x28, 0x90, 0x6F, 0xD0, 0x2F, 0x60, 0xF9, 0x28,
  0x95, 0xAF, 0xDD, 0xFD, 0xFD, 0xEE, 0x10, 0x9F, 0x32, 0x87, 0x5A, 0xA5, 0x05, 0xA9, 0x22, 0x82,
  0x1D, 0xE3, 0x76, 0x83, 0x2D, 0xF9, 0x37, 0x50, 0x10, 0x9E, 0x0B, 0x73, 0x84, 0x57, 0x77, 0x75,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_alternate_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_alternate_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_app_registration 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_sharp_18_communication_app_registration_data[] PROGMEM = {
  0x89, 0x42, 0x66, 0x12, 0x66, 0x21, 0x66, 0x20, 0x6A, 0x04, 0x05, 0xA0, 0x50, 0x4A, 0x81, 0x60,
  0x6A, 0x04, 0x05, 0xA0, 0x50, 0x4A, 0x8A, 0x56, 0x01, 0x44, 0x11, 0x44, 0x11, 0x44, 0x10, 0x25,
  0x51, 0x25, 0x52, 0x28, 0x25, 0x90, 0x6A, 0x04, 0x05, 0xA8, 0x55, 0x02, 0x5F, 0x36, 0xA8, 0xA0,
  0x45, 0xFB, 0x05, 0xF5, 0x10, 0x25, 0x51, 0x25, 0x05, 0xA0, 0x52, 0x82, 0x14, 0x41, 0x20, 0x5A,
  0x05, 0x30, 0x6A, 0x81, 0x40, 0x5A, 0x05, 0x40, 0x6A, 0x83, 0x40, 0xDF, 0x55, 0x85, 0x26, 0x61,
  0x05, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_app_registration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_app_registration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_business 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_sharp_18_communication_business_data[] PROGMEM = {
  0x05, 0x80, 0x3B, 0x71, 0x85, 0x7F, 0xBD, 0xFB, 0xD9, 0x71, 0x85, 0x7F, 0x07, 0xF0, 0x79, 0x71,
  0x85, 0x7F, 0xBD, 0xFB, 0xD9, 0x80, 0x3B, 0x86, 0x57, 0xFB, 0xDF, 0xBD, 0x98, 0x02, 0xB9, 0x86,
  0x77, 0xF0, 0x7F, 0x07, 0x96, 0x98, 0xC6, 0x77, 0xFB, 0xDF, 0xBD, 0xFB, 0x50, 0xB5, 0x0F, 0x77,
  0xFB, 0xDF, 0xBD, 0xFB, 0x50, 0xB5, 0x0F, 0x77, 0xF0, 0x7F, 0x07, 0x96, 0x98, 0xC6, 0x77, 0xFB,
  0xDF, 0xBD, 0xFB, 0x50, 0xB5, 0x0F, 0x77, 0xFB, 0xDF, 0xBD, 0xFB, 0x50, 0xB5, 0x0F, 0x77, 0xF0,
  0x7F, 0x07, 0x96, 0x98, 0x67, 0x7F, 0xBD, 0xFB, 0xD9, 0x80, 0x2B, 0x90, 0x70, 0x58, 0x09, 0x2B,
  0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_call_end 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_sharp_18_communication_call_end_data[] PROGMEM = {
  0x58, 0x62, 0x79, 0xAA, 0x97, 0x27, 0x10, 0x50, 0xDA, 0x82, 0xCB, 0xBC, 0xA0, 0xD0, 0x54, 0x02,
  0x0C, 0xA0, 0xB6, 0x0B, 0xA8, 0x3C, 0x20, 0x3E, 0xB0, 0xA6, 0x0A, 0xB8, 0x1E, 0x3A, 0xC0, 0xA6,
  0x0A, 0xC8, 0x1A, 0x0B, 0xA0, 0xA7, 0x10, 0xAA, 0x0B, 0x30, 0xB0, 0x77, 0x30, 0x70, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_call_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 5, 17, 11), Box(0, 0, 17, 17),
      ic_sharp_18_communication_call_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_call_made 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_sharp_18_communication_call_made_data[] PROGMEM = {
  0x30, 0x18, 0x03, 0x30, 0x13, 0x03, 0xF0, 0x33, 0x84, 0x13, 0x33, 0x3B, 0xA0, 0x37, 0x83, 0x8F,
  0xBF, 0x36, 0x84, 0x8F, 0x83, 0xF3, 0x58, 0x58, 0xF8, 0x03, 0xF3, 0x48, 0x18, 0xF8, 0x28, 0x13,
  0xF3, 0x38, 0x18, 0xF8, 0x38, 0x13, 0xF3, 0x28, 0x18, 0xF8, 0x48, 0x51, 0x31, 0x08, 0xF8, 0x71,
  0x81, 0x8F, 0x87, 0x20, 0x60, 0x87, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_call_made() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_call_made_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_call_merge 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_sharp_18_communication_call_merge_data[] PROGMEM = {
  0x40, 0x01, 0x78, 0x21, 0xCC, 0x15, 0x01, 0x0C, 0xA0, 0xC0, 0x13, 0x01, 0x0C, 0xC0, 0xC0, 0x15,
  0x00, 0xB7, 0x10, 0x0B, 0x71, 0x00, 0xB7, 0x10, 0x0B, 0x78, 0x12, 0xEB, 0x68, 0x42, 0xDD, 0x20,
  0x13, 0x89, 0x32, 0xDD, 0x20, 0x7D, 0x20, 0x2D, 0xD2, 0x28, 0x52, 0xDD, 0x27, 0xD2, 0x48, 0x32,
  0xD7, 0x01, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_call_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_call_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_call_missed_outgoing 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_sharp_18_communication_call_missed_outgoing_data[] PROGMEM = {
  0x01, 0x07, 0x50, 0x28, 0x01, 0xB8, 0x28, 0x7F, 0x84, 0x02, 0x0F, 0xBA, 0x83, 0xB0, 0x8F, 0x86,
  0x08, 0xA0, 0xB2, 0x81, 0x8F, 0x84, 0x83, 0x8F, 0x8B, 0xB3, 0x81, 0x8F, 0x82, 0x84, 0x8F, 0x80,
  0xBB, 0x48, 0x48, 0xF8, 0x8F, 0x82, 0x00, 0xB5, 0x08, 0xA0, 0x83, 0x00, 0x26, 0x00, 0x86,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_call_missed_outgoing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_sharp_18_communication_call_missed_outgoing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_call_missed 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_sharp_18_communication_call_missed_data[] PROGMEM = {
  0x08, 0x80, 0x1B, 0x02, 0x58, 0x17, 0x1B, 0xA0, 0xFB, 0x02, 0x48, 0x28, 0xF7, 0xBA, 0x08, 0x68,
  0x78, 0xF8, 0x0B, 0xB8, 0xF8, 0x48, 0x18, 0xF8, 0x28, 0x4B, 0xB0, 0x8F, 0x82, 0x81, 0x8F, 0x83,
  0x00, 0xB2, 0x84, 0x8F, 0x88, 0xF8, 0x40, 0x02, 0x30, 0x8A, 0x08, 0x74, 0x00, 0x86,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_call_missed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_sharp_18_communication_call_missed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_call 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_18_communication_call_data[] PROGMEM = {
  0x83, 0x8B, 0xBB, 0x57, 0x20, 0xAB, 0x08, 0x72, 0x09, 0xB0, 0xA7, 0x20, 0x7B, 0x0C, 0x72, 0x02,
  0xB0, 0x87, 0x38, 0x1D, 0xF8, 0x74, 0x81, 0x6F, 0x37, 0x50, 0xD0, 0xC7, 0x58, 0x14, 0xFA, 0x75,
  0x81, 0x6F, 0xA3, 0x83, 0x8C, 0xA8, 0x54, 0x83, 0x6F, 0xC3, 0x8C, 0x0B, 0x50, 0x40, 0xDE, 0x0B,
  0x70, 0x60, 0xDC, 0x0B, 0x72, 0x83, 0x27, 0x99, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_call_received 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_sharp_18_communication_call_received_data[] PROGMEM = {
  0x73, 0x08, 0x06, 0x72, 0x81, 0x8F, 0x87, 0x18, 0x58, 0xF8, 0x01, 0x31, 0x48, 0x18, 0xF8, 0x28,
  0x13, 0xF3, 0x38, 0x18, 0xF8, 0x38, 0x13, 0xF3, 0x28, 0x18, 0xF8, 0x48, 0x53, 0xF3, 0x08, 0xF8,
  0x58, 0x43, 0xF3, 0x8F, 0x86, 0x83, 0x3F, 0xBF, 0x87, 0x03, 0xA8, 0x4B, 0x33, 0x33, 0x13, 0x03,
  0xF0, 0x33, 0x01, 0x80, 0x33, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_call_received() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_call_received_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_call_split 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_sharp_18_communication_call_split_data[] PROGMEM = {
  0xB0, 0xD0, 0x12, 0x01, 0x0D, 0xD0, 0xE0, 0x14, 0x01, 0x0E, 0xB8, 0x1E, 0xF8, 0x48, 0x78, 0xFE,
  0xFD, 0x18, 0xF8, 0x28, 0x48, 0xF8, 0x1D, 0x12, 0x84, 0x8F, 0x80, 0x58, 0x20, 0x14, 0x81, 0x8F,
  0x77, 0x30, 0xC0, 0xB7, 0x30, 0x0B, 0x73, 0x00, 0xB7, 0x30, 0x0B, 0x73, 0x00, 0xB7, 0x30, 0x0B,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_call_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_call_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_cancel_presentation 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_sharp_18_communication_cancel_presentation_data[] PROGMEM = {
  0x02, 0x80, 0x94, 0xB8, 0x22, 0x3F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x30, 0x60, 0x82, 0x08, 0x06, 0x38, 0x43, 0xF3, 0x3F,
  0x33, 0x84, 0x8F, 0x88, 0xF8, 0x38, 0x43, 0xF3, 0x3F, 0x34, 0x08, 0xA0, 0x84, 0x84, 0x3F, 0x33,
  0xF3, 0x40, 0x8A, 0x08, 0x48, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x8F, 0x88, 0xF8, 0x38, 0x43, 0xF3,
  0x3F, 0x33, 0x06, 0x08, 0x20, 0x80, 0x63, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3,
  0x75, 0x84, 0x3F, 0x33, 0xFC, 0x80, 0x90, 0xB8, 0x2C, 0xF3, 0x28, 0x09, 0x4B, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_cancel_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_cancel_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_cell_tower 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_sharp_18_communication_cell_tower_data[] PROGMEM = {
  0x20, 0x60, 0x47, 0x10, 0x40, 0x63, 0x81, 0x2F, 0x77, 0x18, 0x17, 0xF2, 0x28, 0x3A, 0xC0, 0x74,
  0x48, 0x34, 0x70, 0xCA, 0x28, 0xA4, 0xE6, 0x1F, 0x70, 0x77, 0x07, 0xF1, 0x6E, 0x02, 0xF3, 0x5F,
  0x09, 0xA8, 0x94, 0x90, 0xF5, 0x3F, 0x22, 0xF2, 0x6E, 0x0B, 0xA8, 0x94, 0xB0, 0xE6, 0x2F, 0x20,
  0xF5, 0x3F, 0x34, 0xA8, 0x34, 0x3F, 0x35, 0x92, 0x89, 0x4C, 0xA0, 0xC8, 0x6E, 0xF4, 0x8C, 0x0A,
  0xC2, 0x89, 0x45, 0xF3, 0x10, 0xB9, 0xB9, 0x01, 0x3F, 0x53, 0x86, 0xB9, 0x01, 0xF4, 0x7D, 0x20,
  0x90, 0xB7, 0x84, 0x6E, 0x03, 0xF2, 0x73, 0x84, 0xBD, 0x77, 0xF6, 0x72, 0x85, 0x1F, 0xDD, 0xDE,
  0xA7, 0x20, 0x50, 0xE3, 0x06, 0x0E, 0x72, 0x02, 0x03, 0x40, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_cell_tower() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_cell_tower_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_cell_wifi 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_18_communication_cell_wifi_data[] PROGMEM = {
  0x48, 0x12, 0x33, 0x71, 0x81, 0x19, 0xEB, 0x81, 0xE9, 0x14, 0x89, 0x13, 0xED, 0x72, 0x12, 0x6D,
  0xE4, 0x38, 0x94, 0x39, 0x01, 0x69, 0x72, 0x09, 0x40, 0x11, 0x28, 0x55, 0xEE, 0xCE, 0xF6, 0x28,
  0x11, 0xC3, 0x20, 0x20, 0x83, 0x85, 0x72, 0x01, 0xCF, 0x34, 0x81, 0x5D, 0x72, 0x83, 0x1C, 0xEF,
  0x34, 0x89, 0x01, 0xA1, 0x01, 0xCD, 0x4F, 0x37, 0x85, 0x1C, 0xF7, 0x2F, 0x36, 0x01, 0x0C, 0xA8,
  0x27, 0x2F, 0x35, 0x01, 0x0C, 0xB8, 0x27, 0x2F, 0x34, 0x01, 0x0C, 0xC8, 0x27, 0x2F, 0x33, 0x01,
  0x0C, 0xD8, 0x28, 0x3F, 0x32, 0x01, 0x0C, 0xFA, 0x03, 0x20, 0x28, 0x06, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_cell_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_cell_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_chat_bubble_outline 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_18_communication_chat_bubble_outline_data[] PROGMEM = {
  0x03, 0x80, 0x92, 0x70, 0x30, 0x7F, 0xF0, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97,
  0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00,
  0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x83, 0x77, 0xF1, 0xDF, 0xC8, 0x37, 0x7F, 0xD9, 0x80, 0x77,
  0x82, 0x37, 0xF7, 0x76, 0x00, 0x77, 0x70, 0x17, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_chat_bubble_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_chat_bubble_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_chat_bubble 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_sharp_18_communication_chat_bubble_data[] PROGMEM = {
  0x03, 0x80, 0x92, 0x70, 0x30, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x07, 0xA0, 0x98, 0x07, 0x78, 0x23, 0x7F, 0x77, 0x60, 0x07, 0x77, 0x01, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_chat_bubble() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_chat_bubble_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_chat 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_18_communication_chat_data[] PROGMEM = {
  0x03, 0x80, 0x92, 0x70, 0x30, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7A, 0x0B, 0x80, 0x47, 0x0B, 0xA0,
  0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x0D, 0x80, 0x4B, 0x0D, 0xA0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x0D, 0x80, 0x4B, 0x0D, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xA0, 0xB8,
  0x01, 0x70, 0xBD, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7A, 0x09, 0x80, 0x77, 0x82, 0x37, 0xF7,
  0x76, 0x00, 0x77, 0x70, 0x17, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_clear_all 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_sharp_18_communication_clear_all_data[] PROGMEM = {
  0x30, 0x88, 0x05, 0xB0, 0x83, 0x08, 0x80, 0x5B, 0x08, 0x77, 0x10, 0x28, 0x06, 0xB0, 0x22, 0x02,
  0x80, 0x6B, 0x02, 0x77, 0x10, 0x88, 0x05, 0xB0, 0x83, 0x08, 0x80, 0x5B, 0x08, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_clear_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_sharp_18_communication_clear_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_comment 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_sharp_18_communication_comment_data[] PROGMEM = {
  0x03, 0x80, 0x92, 0x70, 0x30, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7A, 0x0B, 0x80, 0x47, 0x0B, 0xA0,
  0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x0D, 0x80, 0x4B, 0x0D, 0xA0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x0D, 0x80, 0x4B, 0x0D, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x0B,
  0x80, 0x47, 0x0B, 0xA0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70, 0x38, 0x07, 0x70, 0x9A, 0x07, 0x76,
  0x81, 0x7F, 0x77, 0x70, 0x07, 0x77, 0x10, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_comments_disabled 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_sharp_18_communication_comments_disabled_data[] PROGMEM = {
  0x38, 0x09, 0x03, 0x18, 0x27, 0x70, 0x9F, 0xC8, 0x43, 0x6F, 0x70, 0x9F, 0xB0, 0x03, 0xA8, 0x17,
  0x06, 0x80, 0x27, 0x0B, 0xA0, 0x03, 0xB0, 0x72, 0x80, 0x11, 0x08, 0xA0, 0x03, 0xC8, 0x17, 0x09,
  0xF0, 0x03, 0xA8, 0x27, 0x6F, 0x75, 0x07, 0xA0, 0x03, 0xA8, 0x90, 0xC9, 0xDF, 0x70, 0x39, 0x9C,
  0xA0, 0x03, 0xD8, 0x5A, 0xF7, 0x06, 0x7B, 0xA0, 0x03, 0xD8, 0x26, 0xAF, 0x72, 0x09, 0xA0, 0x03,
  0xFA, 0x81, 0x70, 0x9A, 0x00, 0x3F, 0xB8, 0x47, 0x09, 0xF3, 0x18, 0x05, 0x78, 0x49, 0xF7, 0x09,
  0x37, 0x48, 0x16, 0xF7, 0x77, 0x81, 0x6F, 0x77, 0x70, 0x60, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_comments_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_comments_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_contact_emergency 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_sharp_18_communication_contact_emergency_data[] PROGMEM = {
  0x80, 0x96, 0x38, 0x0D, 0x5F, 0x06, 0xF9, 0x82, 0xE7, 0x5B, 0xB8, 0x39, 0x81, 0x89, 0xE0, 0x53,
  0x0B, 0xA8, 0x3E, 0x30, 0x3E, 0xE0, 0x13, 0x07, 0xA8, 0x38, 0x30, 0x38, 0xE0, 0x43, 0x0B, 0xC0,
  0x3F, 0x98, 0x2E, 0x64, 0x9F, 0xF8, 0x2E, 0xCB, 0xDF, 0xD0, 0xE0, 0x64, 0x02, 0x09, 0xFA, 0x0D,
  0x01, 0x70, 0x5F, 0xFF, 0xC8, 0x09, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_contact_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_contact_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_contact_mail 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_18_communication_contact_mail_data[] PROGMEM = {
  0x80, 0x96, 0xBF, 0xFF, 0x98, 0x2E, 0x99, 0xEA, 0x0B, 0x80, 0x17, 0x0B, 0xD0, 0x32, 0x03, 0xA0,
  0x70, 0x53, 0x05, 0x07, 0xC0, 0xC4, 0x87, 0xCF, 0x72, 0xA6, 0xA2, 0x7C, 0x0E, 0x48, 0x1E, 0xF7,
  0x20, 0x52, 0x07, 0xD8, 0x29, 0x11, 0x9A, 0x07, 0x50, 0x7F, 0xFF, 0x98, 0x4E, 0x97, 0x79, 0xEF,
  0xC0, 0x66, 0x06, 0xFA, 0x09, 0x71, 0x09, 0xF9, 0x0B, 0x80, 0x47, 0x0B, 0xFF, 0xFC, 0x80, 0x96,
  0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_contact_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_contact_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_contact_phone 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_sharp_18_communication_contact_phone_data[] PROGMEM = {
  0x80, 0x96, 0xBF, 0xFF, 0x98, 0x2E, 0x99, 0xED, 0x0E, 0x0C, 0xF0, 0x32, 0x03, 0xD8, 0x14, 0x0B,
  0xD0, 0xC4, 0x0C, 0xB0, 0x92, 0x09, 0xD0, 0xE4, 0x0E, 0xB8, 0x13, 0x59, 0xF8, 0x29, 0x11, 0x9C,
  0x01, 0x0C, 0xFF, 0xA0, 0x10, 0xCF, 0x84, 0xE9, 0x77, 0x9E, 0xB8, 0x13, 0x59, 0xD0, 0x66, 0x06,
  0xA0, 0x92, 0x09, 0xB0, 0x97, 0x10, 0x9A, 0x81, 0x40, 0xBB, 0x0B, 0x80, 0x47, 0x0B, 0xA0, 0xE0,
  0xCF, 0xFF, 0x80, 0x96, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_contact_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_contact_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_contacts 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_sharp_18_communication_contacts_data[] PROGMEM = {
  0x2F, 0xD4, 0x80, 0x90, 0x77, 0x74, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xD8, 0x2C, 0x33, 0xCD,
  0x00, 0x7D, 0x05, 0x20, 0x5D, 0x00, 0x7D, 0x08, 0x20, 0x8D, 0x00, 0x7E, 0x00, 0xAE, 0x00, 0x7D,
  0x82, 0xEC, 0xCE, 0xD0, 0x07, 0xB0, 0xD0, 0x54, 0x05, 0x0D, 0xB0, 0x07, 0xB0, 0x56, 0x04, 0xB0,
  0x07, 0xB0, 0x68, 0x02, 0x30, 0x6B, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x07, 0x77, 0x48, 0x09, 0x07,
  0x4F, 0xD2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_co_present 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_18_communication_co_present_data[] PROGMEM = {
  0x18, 0x09, 0x43, 0x10, 0x1F, 0xFA, 0x82, 0x11, 0xF3, 0x75, 0x84, 0x3F, 0x11, 0xF3, 0x28, 0x16,
  0x83, 0x78, 0x63, 0xF1, 0x1F, 0x30, 0xCB, 0x06, 0x68, 0x53, 0xF1, 0x1F, 0x34, 0xC0, 0xD6, 0x85,
  0x3F, 0x11, 0xF3, 0x4C, 0x0E, 0x68, 0x63, 0xF1, 0x1F, 0x30, 0xDB, 0x08, 0x68, 0x91, 0x3F, 0x11,
  0xB2, 0x02, 0x9B, 0x77, 0x81, 0x3F, 0x14, 0x01, 0x0F, 0x37, 0x81, 0x3F, 0x12, 0x06, 0x0C, 0xD0,
  0xA0, 0x34, 0x83, 0x3F, 0x10, 0xBF, 0xA0, 0x53, 0x82, 0x3F, 0x11, 0xFB, 0x0A, 0x38, 0x23, 0xF1,
  0x1F, 0xB0, 0xA3, 0x01, 0x03, 0x28, 0x06, 0x30, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_co_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_co_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_desktop_access_disabled 18x18, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_sharp_18_communication_desktop_access_disabled_data[] PROGMEM = {
  0x82, 0x34, 0x02, 0x80, 0x91, 0x78, 0x41, 0xBF, 0x40, 0x9F, 0xD0, 0x03, 0xA0, 0x47, 0x48, 0x63,
  0xF3, 0x3F, 0xEF, 0x47, 0x38, 0x73, 0xF3, 0x3F, 0x4B, 0xF4, 0x72, 0x89, 0x03, 0xF3, 0x3F, 0x30,
  0xBF, 0x47, 0x18, 0x43, 0xF3, 0x3F, 0x32, 0x81, 0xBF, 0x47, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x1B,
  0xF4, 0x68, 0x43, 0xF3, 0x3F, 0x34, 0x81, 0xBF, 0x45, 0x84, 0x3F, 0x33, 0xF3, 0x58, 0x1B, 0xF4,
  0x48, 0x43, 0xF3, 0x3F, 0x36, 0x81, 0xBF, 0x43, 0x82, 0x3F, 0x33, 0xFC, 0x81, 0x40, 0x9A, 0x03,
  0x01, 0x80, 0x27, 0x0B, 0xA8, 0x6B, 0xCF, 0x40, 0x67, 0x17, 0x07, 0xA8, 0x37, 0x0B, 0xF4, 0x72,
  0xE1, 0x81, 0xBF, 0x47, 0x18, 0x02, 0x72, 0x81, 0xBF, 0x47, 0x72, 0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_desktop_access_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_desktop_access_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_dialer_sip 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_18_communication_dialer_sip_data[] PROGMEM = {
  0x83, 0x8B, 0xBB, 0x52, 0x86, 0xBB, 0x28, 0x5B, 0x8A, 0xB0, 0x82, 0x86, 0xC3, 0x1B, 0x76, 0xB9,
  0xB0, 0xA2, 0x86, 0x7B, 0x3B, 0x79, 0x57, 0xB0, 0xC2, 0x86, 0xBD, 0x3B, 0x73, 0x02, 0xB0, 0x87,
  0x38, 0x1D, 0xF8, 0x74, 0x81, 0x6F, 0x37, 0x50, 0xD0, 0xC7, 0x58, 0x14, 0xFA, 0x75, 0x81, 0x6F,
  0xA3, 0x83, 0x8C, 0xA8, 0x54, 0x83, 0x6F, 0xC3, 0x8C, 0x0B, 0x50, 0x40, 0xDE, 0x0B, 0x70, 0x60,
  0xDC, 0x0B, 0x72, 0x83, 0x27, 0x99, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_dialer_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_dialer_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_dialpad 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_sharp_18_communication_dialpad_data[] PROGMEM = {
  0x10, 0x33, 0x00, 0x13, 0x85, 0x30, 0xBF, 0xB0, 0x3A, 0x89, 0x03, 0x0B, 0xFB, 0xEF, 0xE0, 0x6A,
  0x86, 0x60, 0xEF, 0xE4, 0xA4, 0x20, 0x09, 0x28, 0x14, 0xA4, 0x75, 0x81, 0x4A, 0x42, 0x00, 0x92,
  0x86, 0x4A, 0x4E, 0xFE, 0x06, 0xA8, 0x90, 0x60, 0xEF, 0xEB, 0xFB, 0x03, 0xA8, 0x53, 0x0B, 0xFB,
  0x03, 0x30, 0x01, 0x30, 0x32, 0x03, 0x30, 0x01, 0x38, 0x53, 0x0B, 0xFB, 0x03, 0xA8, 0x90, 0x30,
  0xBF, 0xBE, 0xFE, 0x06, 0xA8, 0x66, 0x0E, 0xFE, 0x4A, 0x42, 0x00, 0x92, 0x81, 0x4A, 0x47, 0x73,
  0x00, 0x97, 0x20, 0x6A, 0x06, 0x71, 0x03, 0xA0, 0x37, 0x20, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_dialpad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_dialpad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_document_scanner 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_sharp_18_communication_document_scanner_data[] PROGMEM = {
  0x10, 0xF1, 0x71, 0x0F, 0x11, 0x03, 0xB0, 0x66, 0x06, 0xB8, 0x43, 0x3F, 0x53, 0x16, 0x87, 0x13,
  0x5F, 0x33, 0xF2, 0x28, 0x04, 0x58, 0x62, 0x2F, 0x31, 0x71, 0x7F, 0x98, 0x27, 0x17, 0x13, 0x07,
  0xF9, 0x07, 0x60, 0x7A, 0x82, 0x63, 0x36, 0xA0, 0x76, 0x07, 0xA8, 0x27, 0x55, 0x7A, 0x07, 0x60,
  0x7A, 0x82, 0x75, 0x57, 0xA0, 0x76, 0x07, 0xA8, 0x27, 0x55, 0x7A, 0x07, 0x60, 0x7A, 0x82, 0x75,
  0x57, 0xA0, 0x76, 0x07, 0xA8, 0x26, 0x33, 0x6A, 0x07, 0x60, 0x7F, 0x90, 0x73, 0x82, 0x17, 0x17,
  0xF9, 0x86, 0x71, 0x71, 0x3F, 0x22, 0x80, 0x45, 0x87, 0x22, 0xF3, 0x3F, 0x53, 0x16, 0x84, 0x13,
  0x5F, 0x33, 0xB0, 0x66, 0x06, 0xB0, 0x31, 0x0F, 0x17, 0x10, 0xF1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_document_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_document_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_domain_disabled 18x18, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_sharp_18_communication_domain_disabled_data[] PROGMEM = {
  0x03, 0x04, 0x77, 0x18, 0x3B, 0xF4, 0x05, 0x80, 0x0B, 0x72, 0x85, 0xCF, 0x40, 0x9B, 0xD9, 0x72,
  0x07, 0xA0, 0x42, 0x07, 0x97, 0x20, 0x7B, 0x81, 0x40, 0x79, 0x80, 0x3B, 0x89, 0x05, 0x07, 0xFB,
  0xDF, 0x40, 0x98, 0x02, 0xB9, 0x84, 0x70, 0x7F, 0x07, 0xA0, 0x47, 0x98, 0x47, 0x07, 0xFB, 0xDB,
  0x04, 0x38, 0x95, 0xB5, 0x0F, 0x70, 0x7F, 0xBD, 0xFB, 0xDF, 0x42, 0x89, 0x3B, 0x50, 0xF7, 0x07,
  0xF0, 0x7F, 0x07, 0xA0, 0x44, 0x98, 0x77, 0x07, 0xFB, 0xDF, 0xBD, 0xB0, 0x43, 0x98, 0x94, 0x70,
  0x7F, 0xBD, 0xFB, 0xDF, 0xBD, 0xF4, 0x29, 0x87, 0x70, 0x7F, 0x07, 0xF0, 0x79, 0x28, 0xA0, 0xBF,
  0x40, 0x97, 0x07, 0xFB, 0xDF, 0xBD, 0xFB, 0xBC, 0xA8, 0x34, 0x02, 0x05, 0x80, 0x7B, 0x81, 0xDF,
  0x47, 0x71, 0x81, 0xBF, 0x47, 0x71, 0x0B, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_domain_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_domain_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_domain_verification 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_18_communication_domain_verification_data[] PROGMEM = {
  0x02, 0x80, 0x65, 0x02, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x69, 0x80, 0x43, 0x82, 0x96, 0x67,
  0x68, 0x41, 0x07, 0x66, 0x75, 0x87, 0x98, 0x07, 0x66, 0x70, 0x22, 0x09, 0x0A, 0x28, 0x77, 0x66,
  0x70, 0x8A, 0x9A, 0x38, 0x27, 0x66, 0x72, 0x08, 0x0A, 0x48, 0x27, 0x66, 0x77, 0x18, 0x27, 0x66,
  0xB8, 0x04, 0x78, 0x1B, 0x62, 0x80, 0x65, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_domain_verification() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_domain_verification_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_duo 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_sharp_18_communication_duo_data[] PROGMEM = {
  0x60, 0x58, 0x03, 0x70, 0x54, 0x01, 0x09, 0xFB, 0x05, 0x20, 0x20, 0xDF, 0xC0, 0x72, 0x0D, 0xFD,
  0x81, 0x70, 0x8F, 0xE8, 0x17, 0x0E, 0xA8, 0x6C, 0xBB, 0xBB, 0xDF, 0xEB, 0x07, 0x04, 0xB0, 0x34,
  0x81, 0x79, 0x4B, 0x07, 0x06, 0xB0, 0x36, 0x03, 0xB0, 0x07, 0xB0, 0x36, 0x03, 0xB0, 0x60, 0x5B,
  0x03, 0x48, 0x17, 0x94, 0xB0, 0x50, 0x1B, 0x86, 0xCB, 0xBB, 0xBD, 0xFE, 0xB2, 0x09, 0xFD, 0x09,
  0x20, 0x10, 0xDF, 0xB0, 0xD0, 0x13, 0x03, 0x0D, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0x9D, 0x0E, 0x08,
  0x72, 0x83, 0x15, 0x76, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_duo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_duo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_email 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_18_communication_email_data[] PROGMEM = {
  0x07, 0xFF, 0x82, 0x77, 0xFC, 0xFB, 0x86, 0xCF, 0x77, 0xF0, 0x6E, 0xE8, 0x91, 0xE6, 0x0F, 0x77,
  0xFA, 0x11, 0xAC, 0x85, 0xA1, 0x1A, 0xF7, 0x7A, 0x89, 0x0E, 0x60, 0x4D, 0xD4, 0x06, 0xEA, 0x00,
  0x7C, 0x0C, 0x03, 0x20, 0x30, 0xCC, 0x00, 0x7E, 0x00, 0x8E, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00,
  0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_forum 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_communication_forum_data[] PROGMEM = {
  0x03, 0x80, 0x67, 0x05, 0x40, 0x7F, 0xB0, 0xB4, 0x07, 0xFB, 0x0B, 0x40, 0x7F, 0xB8, 0x4B, 0x05,
  0x73, 0x7F, 0xB8, 0x4B, 0x0B, 0xF7, 0x7F, 0xB8, 0x4B, 0x0B, 0xF7, 0x7F, 0xB8, 0x4B, 0x0B, 0xF7,
  0x7F, 0xB8, 0x4B, 0x0B, 0xF7, 0x7A, 0x0D, 0x80, 0x3B, 0x86, 0x80, 0xBF, 0x77, 0xFB, 0x73, 0x85,
  0xBF, 0x77, 0xB0, 0x58, 0x05, 0xB8, 0x2E, 0xF7, 0x32, 0x07, 0xFC, 0x07, 0x30, 0x38, 0x04, 0x70,
  0x9A, 0x07, 0x76, 0x81, 0x7F, 0x77, 0x70, 0x07, 0x77, 0x10, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_forum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_forum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_forward_to_inbox 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_18_communication_forward_to_inbox_data[] PROGMEM = {
  0x01, 0x80, 0x90, 0x58, 0x21, 0x4E, 0x88, 0x04, 0x78, 0x58, 0xE4, 0x4D, 0xD4, 0x68, 0x90, 0x4D,
  0xD4, 0x49, 0x2B, 0xA1, 0x28, 0x61, 0xAB, 0x29, 0x44, 0x92, 0x84, 0x6D, 0x55, 0xD6, 0x28, 0x29,
  0x44, 0x93, 0x82, 0x1A, 0xA1, 0x38, 0x29, 0x44, 0x97, 0x38, 0x29, 0x44, 0x97, 0x38, 0x27, 0x34,
  0x97, 0x20, 0x32, 0x04, 0x09, 0x72, 0x83, 0x7B, 0x04, 0xC8, 0x01, 0x78, 0x66, 0x17, 0x7B, 0xFB,
  0x18, 0x03, 0x58, 0x41, 0x55, 0xAF, 0x97, 0x40, 0x70, 0x97, 0x50, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_forward_to_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_forward_to_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_hourglass_bottom 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_sharp_18_communication_hourglass_bottom_data[] PROGMEM = {
  0x02, 0x80, 0x23, 0x89, 0x12, 0x9B, 0x99, 0x99, 0xB9, 0x94, 0x48, 0x24, 0x99, 0x44, 0x83, 0x49,
  0x5C, 0x12, 0x89, 0x01, 0xC5, 0x06, 0xC1, 0x1C, 0x63, 0x82, 0x6C, 0xC6, 0x40, 0x6A, 0x06, 0x30,
  0x6C, 0x81, 0x60, 0x5E, 0x05, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x90, 0x28, 0x02, 0x30, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_hourglass_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 12, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_hourglass_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_hourglass_top 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_sharp_18_communication_hourglass_top_data[] PROGMEM = {
  0x02, 0x80, 0x23, 0x02, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x90, 0x5E, 0x81, 0x50, 0x6C, 0x06,
  0x30, 0x6A, 0x06, 0x48, 0x26, 0xCC, 0x63, 0x89, 0x06, 0xC1, 0x1C, 0x60, 0x5C, 0x12, 0x83, 0x1C,
  0x59, 0x44, 0x82, 0x49, 0x94, 0x48, 0x91, 0x49, 0x9B, 0x99, 0x99, 0xB9, 0x28, 0x02, 0x30, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_hourglass_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 12, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_hourglass_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_hub 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_sharp_18_communication_hub_data[] PROGMEM = {
  0x78, 0x25, 0xDD, 0x57, 0x60, 0x1C, 0x01, 0x75, 0x03, 0xC0, 0x37, 0x60, 0xCA, 0x0C, 0x77, 0x10,
  0x09, 0x71, 0x82, 0x3D, 0xF9, 0x40, 0x07, 0x48, 0x39, 0xFD, 0x3C, 0xB8, 0x25, 0x01, 0xBA, 0x82,
  0xB2, 0x05, 0xB0, 0xC0, 0xEB, 0x81, 0xB4, 0xDC, 0x81, 0xD4, 0xBB, 0x0E, 0x08, 0xA8, 0x1E, 0x6B,
  0xE8, 0x1B, 0x6E, 0xA8, 0x57, 0x04, 0x61, 0x04, 0xE8, 0x34, 0x01, 0x64, 0x60, 0x1E, 0x01, 0x74,
  0x09, 0xC0, 0x97, 0x28, 0x92, 0x25, 0x5D, 0x48, 0x84, 0xD5, 0x52, 0x50, 0x3B, 0x06, 0x40, 0x6B,
  0x03, 0x40, 0xAB, 0x0A, 0x40, 0xAB, 0x0A, 0x40, 0x9B, 0x09, 0x40, 0x9B, 0x09, 0x48, 0x31, 0xCF,
  0xC1, 0x48, 0x31, 0xCF, 0xC1, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_import_contacts 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_18_communication_import_contacts_data[] PROGMEM = {
  0x28, 0x44, 0x79, 0x86, 0x32, 0x84, 0x36, 0x89, 0x74, 0x20, 0x20, 0xDE, 0x00, 0xCA, 0x0E, 0x0D,
  0xA8, 0x1D, 0x23, 0xF9, 0x81, 0xB5, 0x13, 0x82, 0x5F, 0x33, 0xF9, 0x68, 0x23, 0xF3, 0x3F, 0x96,
  0x82, 0x3F, 0x33, 0xF9, 0x68, 0x23, 0xF3, 0x3F, 0x96, 0x82, 0x3F, 0x33, 0xF9, 0x68, 0x23, 0xF3,
  0x3F, 0x96, 0x82, 0x3F, 0x33, 0xF9, 0x68, 0x23, 0xF3, 0x3F, 0x92, 0x86, 0x47, 0x75, 0x6F, 0x33,
  0xF9, 0x09, 0xF8, 0xA1, 0x33, 0xA5, 0x20, 0x12, 0x6C, 0xC6, 0x21, 0x02, 0x5B, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_import_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_import_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_import_export 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_sharp_18_communication_import_export_data[] PROGMEM = {
  0x20, 0x60, 0x17, 0x82, 0x7F, 0xD1, 0x50, 0x7B, 0x0D, 0x01, 0x48, 0x43, 0x3F, 0x93, 0x26, 0x90,
  0x77, 0x19, 0x07, 0x20, 0x30, 0x74, 0x90, 0x72, 0x07, 0x94, 0x90, 0x72, 0x07, 0x94, 0x07, 0x03,
  0x20, 0x79, 0x71, 0x07, 0x96, 0x84, 0x23, 0x9F, 0x33, 0x40, 0x10, 0xDB, 0x07, 0x58, 0x21, 0xDF,
  0x77, 0x01, 0x06, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_import_export() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_import_export_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_invert_colors_off 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_sharp_18_communication_invert_colors_off_data[] PROGMEM = {
  0x10, 0x25, 0x00, 0xA6, 0x81, 0x1E, 0x73, 0x82, 0xAE, 0xFA, 0x68, 0x56, 0xF7, 0x05, 0xE4, 0xA0,
  0xA6, 0x83, 0x6F, 0x70, 0x21, 0xB0, 0x96, 0x81, 0xAF, 0x72, 0xC0, 0x84, 0x85, 0x1E, 0xBF, 0x70,
  0x9C, 0x02, 0x38, 0x66, 0xE0, 0x6F, 0x70, 0x9B, 0x07, 0x30, 0x80, 0xB2, 0x83, 0x6F, 0x70, 0x9A,
  0x09, 0x30, 0x80, 0xD3, 0x85, 0x6F, 0x70, 0x9F, 0x83, 0x81, 0x4F, 0x23, 0xA8, 0x27, 0x09, 0x44,
  0x0D, 0x0C, 0x3B, 0x07, 0x68, 0x32, 0xED, 0x52, 0xC0, 0x76, 0x02, 0x0A, 0xC8, 0x29, 0x7F, 0x77,
  0x81, 0x13, 0x33, 0x81, 0x6E, 0x27, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_invert_colors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_invert_colors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_key_off 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_sharp_18_communication_key_off_data[] PROGMEM = {
  0x10, 0x27, 0x78, 0x11, 0xE7, 0x77, 0x81, 0x6F, 0x77, 0x60, 0x6A, 0x07, 0x74, 0x04, 0xA8, 0x1E,
  0xF7, 0x73, 0x87, 0xCF, 0xB0, 0x6F, 0x70, 0x18, 0x02, 0x51, 0xA0, 0x32, 0x83, 0x6F, 0x70, 0x9D,
  0x09, 0xA0, 0x33, 0x83, 0x9F, 0x70, 0x9C, 0x82, 0x9C, 0xFB, 0x20, 0x10, 0xDA, 0x86, 0x70, 0x7B,
  0xF9, 0x03, 0xA8, 0x6E, 0xCE, 0xFE, 0x8F, 0x72, 0x06, 0x30, 0x50, 0xEB, 0x84, 0xD3, 0x06, 0xF7,
  0x68, 0x21, 0x47, 0x54, 0x81, 0x6F, 0x77, 0x78, 0x16, 0xF7, 0x77, 0x81, 0x6E, 0x27, 0x70, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_key 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_18_communication_key_data[] PROGMEM = {
  0x28, 0x21, 0x47, 0x47, 0x40, 0x50, 0xEB, 0x0D, 0x03, 0x71, 0x03, 0xA8, 0x4E, 0xCE, 0xFE, 0x17,
  0x81, 0xCF, 0xB2, 0x82, 0x1D, 0xFA, 0x80, 0x25, 0x1A, 0x03, 0x30, 0x7F, 0x90, 0x9A, 0x03, 0x30,
  0x7F, 0x98, 0x29, 0xCF, 0xB2, 0x89, 0x21, 0xDF, 0xA8, 0xFC, 0xBF, 0x90, 0x3A, 0x89, 0x1E, 0xCE,
  0xFE, 0x10, 0x61, 0x06, 0x30, 0x50, 0xEB, 0x0D, 0x03, 0x73, 0x82, 0x14, 0x74, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_sharp_18_communication_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_list_alt 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_18_communication_list_alt_data[] PROGMEM = {
  0x08, 0x80, 0x90, 0xB8, 0x18, 0xBE, 0x80, 0x6B, 0x0E, 0x0F, 0xB7, 0x38, 0x00, 0xB1, 0x8A, 0x48,
  0x80, 0x8B, 0xBB, 0x80, 0xBB, 0xBB, 0x08, 0x80, 0x8B, 0xBB, 0x81, 0x80, 0x0B, 0x73, 0x80, 0x0B,
  0x18, 0xA4, 0x88, 0x08, 0xBB, 0xB8, 0x0B, 0xBB, 0xB0, 0x88, 0x08, 0xBB, 0xB8, 0x18, 0x00, 0xB7,
  0x38, 0x00, 0xB1, 0x8A, 0x48, 0x80, 0x8B, 0xBB, 0x80, 0xBB, 0xBB, 0x08, 0x80, 0x8B, 0xBB, 0x81,
  0x80, 0x0B, 0x73, 0x0F, 0xB0, 0xE8, 0x06, 0xB8, 0x1E, 0xB8, 0x80, 0x90, 0xB0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_list_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_list_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_live_help 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_sharp_18_communication_live_help_data[] PROGMEM = {
  0x05, 0x80, 0x90, 0x70, 0x50, 0xBF, 0xD0, 0x0B, 0xC8, 0x27, 0x11, 0x7C, 0x00, 0xBB, 0x84, 0x70,
  0x55, 0x07, 0xB0, 0x0B, 0xB0, 0x10, 0x5A, 0x05, 0x01, 0xB0, 0x0B, 0xF0, 0x50, 0x1B, 0x00, 0xBE,
  0x81, 0x90, 0x9B, 0x00, 0xBD, 0x81, 0xC0, 0x6C, 0x00, 0xBD, 0x05, 0x01, 0xD0, 0x0B, 0xD0, 0x09,
  0xD0, 0x0B, 0xFD, 0x00, 0xBD, 0x00, 0x3D, 0x00, 0xBD, 0x00, 0x9D, 0x00, 0xBF, 0xD0, 0xB5, 0x0B,
  0xA0, 0xB7, 0x40, 0x0B, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_live_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_live_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_location_off 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_sharp_18_communication_location_off_data[] PROGMEM = {
  0x68, 0x23, 0x77, 0x35, 0x83, 0x91, 0x02, 0xCC, 0x0C, 0x02, 0x28, 0x43, 0xEC, 0x11, 0xDD, 0x0E,
  0x02, 0x28, 0x63, 0xEC, 0x11, 0xDE, 0xEB, 0x0B, 0x38, 0x34, 0xFC, 0x11, 0x20, 0xAB, 0x01, 0x20,
  0x3A, 0x0C, 0x01, 0x20, 0x2B, 0x03, 0x20, 0x2B, 0x82, 0xC1, 0x05, 0xB0, 0x13, 0x0E, 0xB8, 0x4C,
  0x11, 0xDF, 0xE4, 0x09, 0xC8, 0x3C, 0x11, 0xD8, 0x40, 0x2D, 0x82, 0xC1, 0x12, 0x50, 0x9D, 0x0C,
  0x01, 0x60, 0x10, 0xED, 0x0C, 0x01, 0x60, 0x5C, 0x82, 0x8E, 0xC1, 0x60, 0x9A, 0x83, 0x90, 0x3E,
  0xC7, 0x00, 0xC3, 0x03, 0x04, 0x70, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_location_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 14, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_location_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_location_on 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_sharp_18_communication_location_on_data[] PROGMEM = {
  0x48, 0x23, 0x77, 0x36, 0x02, 0x0C, 0xC0, 0xC0, 0x23, 0x02, 0x0E, 0xE0, 0xE0, 0x22, 0x0B, 0xB0,
  0x0E, 0xB8, 0x1B, 0x01, 0xB0, 0xA2, 0x0A, 0xB0, 0x10, 0x3B, 0x02, 0x20, 0x2B, 0x03, 0x02, 0xB0,
  0x52, 0x05, 0xB8, 0x12, 0x0E, 0xA8, 0x2E, 0x77, 0xEA, 0x0E, 0x20, 0x9F, 0x90, 0x92, 0x02, 0xF9,
  0x02, 0x30, 0x9E, 0x09, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x50, 0x5C, 0x05, 0x70, 0x9A, 0x09, 0x72,
  0x00, 0xC7, 0x30, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_location_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_location_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_mail_lock 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_communication_mail_lock_data[] PROGMEM = {
  0x01, 0x80, 0x92, 0x58, 0x11, 0x03, 0xFF, 0x84, 0x30, 0x3F, 0x4B, 0xF9, 0x89, 0x1B, 0x4F, 0x30,
  0x3F, 0x50, 0x4D, 0xC8, 0x6D, 0x40, 0x5F, 0x30, 0x3A, 0x89, 0x5A, 0x20, 0x6E, 0xE6, 0x02, 0xAC,
  0x91, 0x03, 0xC8, 0x93, 0x80, 0x11, 0x08, 0xE4, 0x05, 0x20, 0x3D, 0x89, 0x2E, 0x55, 0xEF, 0x70,
  0x76, 0xB0, 0x3F, 0xB8, 0x53, 0x1A, 0x4A, 0x53, 0xFB, 0x02, 0x07, 0xC0, 0x3F, 0xB0, 0x20, 0x7C,
  0x03, 0xFB, 0x02, 0x07, 0xC0, 0x18, 0x06, 0x51, 0x02, 0x80, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_mail_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_mail_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_mail_outline 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_18_communication_mail_outline_data[] PROGMEM = {
  0x07, 0xFF, 0x82, 0x77, 0xFA, 0x80, 0x67, 0x82, 0xAF, 0x77, 0xA0, 0x87, 0x10, 0x8A, 0x85, 0x77,
  0xF4, 0xDD, 0x44, 0x85, 0x4D, 0xD4, 0xF7, 0x79, 0x28, 0x68, 0xFA, 0x11, 0xAF, 0x82, 0x90, 0x07,
  0x93, 0x84, 0x3C, 0xEE, 0xC3, 0x39, 0x00, 0x79, 0x50, 0x06, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07,
  0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x98, 0x09, 0x07, 0x90, 0x07, 0xFF, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_mail_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_mail_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_mark_chat_read 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_sharp_18_communication_mark_chat_read_data[] PROGMEM = {
  0x01, 0x80, 0x90, 0x30, 0x10, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F,
  0x98, 0x4B, 0x63, 0x52, 0x4F, 0x06, 0x50, 0x4E, 0x0A, 0x48, 0x11, 0xA4, 0xE0, 0x33, 0x82, 0x1C,
  0x64, 0xE1, 0x85, 0x4A, 0x1C, 0x60, 0x4A, 0x0A, 0x0F, 0x92, 0x81, 0x9E, 0x62, 0x81, 0x4F, 0x77,
  0x03, 0x30, 0x40, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_mark_chat_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_mark_chat_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_mark_chat_unread 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_sharp_18_communication_mark_chat_unread_data[] PROGMEM = {
  0x74, 0x02, 0x20, 0x18, 0x04, 0x31, 0x83, 0xCF, 0xC0, 0x4F, 0x0D, 0x03, 0xB0, 0x30, 0x4F, 0x85,
  0xE1, 0xEF, 0xE1, 0x4F, 0x98, 0x4A, 0x25, 0x21, 0x4F, 0xA8, 0x3E, 0xBE, 0x44, 0xFD, 0x00, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4A, 0x0A, 0x80, 0x59, 0x82, 0x24, 0xF7,
  0x74, 0x04, 0x07, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_mark_chat_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_mark_chat_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_mark_email_read 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_sharp_18_communication_mark_email_read_data[] PROGMEM = {
  0x01, 0x80, 0x90, 0x58, 0x21, 0x4D, 0xEF, 0x98, 0x5E, 0xD4, 0x4B, 0x2B, 0xE8, 0x90, 0xB2, 0xB4,
  0x4F, 0xD3, 0x5E, 0xA8, 0x5E, 0x53, 0xDF, 0x44, 0xB8, 0x49, 0x19, 0x91, 0x9B, 0x00, 0x4C, 0x82,
  0xD4, 0x4D, 0xC0, 0x04, 0xF9, 0x84, 0x83, 0x02, 0x14, 0xF0, 0x35, 0x04, 0xE0, 0x84, 0x81, 0x2C,
  0x4E, 0x03, 0x38, 0x22, 0xD3, 0x4E, 0x18, 0x54, 0xC3, 0xD3, 0x01, 0x80, 0x25, 0x28, 0x16, 0xE3,
  0x75, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_mark_email_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_mark_email_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_mark_email_unread 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_sharp_18_communication_mark_email_unread_data[] PROGMEM = {
  0x74, 0x03, 0x20, 0x18, 0x04, 0x51, 0x85, 0xDF, 0xD0, 0x4D, 0xED, 0x0D, 0x03, 0xB8, 0x33, 0x4B,
  0x2B, 0xD8, 0x91, 0x2D, 0xFD, 0x04, 0xFD, 0x35, 0xEA, 0x85, 0xE3, 0x13, 0x11, 0x4B, 0x89, 0x19,
  0x19, 0x91, 0x9F, 0xDF, 0x44, 0xC8, 0x2D, 0x44, 0xDC, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x18, 0x09, 0x05, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_mark_email_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_mark_email_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_mark_unread_chat_alt 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_sharp_18_communication_mark_unread_chat_alt_data[] PROGMEM = {
  0x74, 0x82, 0x3A, 0xA2, 0x28, 0x04, 0x38, 0x11, 0x1E, 0xA8, 0x1D, 0x03, 0xF9, 0x05, 0x03, 0xC0,
  0x20, 0x3F, 0x98, 0x18, 0x1E, 0xA8, 0x1D, 0x03, 0xA0, 0xB8, 0x01, 0x78, 0x66, 0x02, 0x99, 0x20,
  0x3A, 0x08, 0x80, 0x41, 0x28, 0x15, 0x23, 0xFF, 0x00, 0x3A, 0x07, 0x71, 0x07, 0xA0, 0x03, 0xA0,
  0xC8, 0x04, 0x90, 0xCA, 0x00, 0x3A, 0x0B, 0x80, 0x17, 0x09, 0xD0, 0x03, 0xA0, 0x98, 0x01, 0x30,
  0x6D, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3A, 0x09, 0x80, 0x77, 0x82, 0x13, 0xF7, 0x76, 0x03,
  0x07, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_mark_unread_chat_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_mark_unread_chat_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_message 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_18_communication_message_data[] PROGMEM = {
  0x03, 0x80, 0x92, 0x70, 0x30, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7A, 0x0B, 0x80, 0x47, 0x0B, 0xA0,
  0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x0D, 0x80, 0x4B, 0x0D, 0xA0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x0D, 0x80, 0x4B, 0x0D, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x0B,
  0x80, 0x47, 0x0B, 0xA0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xA0, 0x98, 0x07, 0x78, 0x23, 0x7F,
  0x77, 0x60, 0x07, 0x77, 0x01, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_message() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_message_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_mobile_screen_share 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_sharp_18_communication_mobile_screen_share_data[] PROGMEM = {
  0x18, 0x06, 0x30, 0x10, 0x3F, 0xB0, 0x03, 0xFB, 0x82, 0x33, 0xFC, 0x80, 0x2B, 0x84, 0xCF, 0x33,
  0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x33, 0x8A,
  0x56, 0x60, 0x3F, 0x33, 0xF3, 0x01, 0x9E, 0xF7, 0x3F, 0x33, 0xF3, 0x1E, 0xB8, 0xA2, 0x73, 0xF3,
  0x3F, 0x38, 0x50, 0x66, 0x03, 0xF3, 0x3F, 0x31, 0x58, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33,
  0xF3, 0x68, 0x43, 0xF3, 0x3F, 0xC8, 0x02, 0xB8, 0x2C, 0xF3, 0x3F, 0xB0, 0x03, 0xFB, 0x03, 0x18,
  0x06, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_mobile_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_mobile_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_more_time 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_sharp_18_communication_more_time_data[] PROGMEM = {
  0x73, 0x00, 0x26, 0x82, 0x36, 0x63, 0x20, 0x60, 0x74, 0x89, 0x62, 0xCB, 0x86, 0x81, 0x9B, 0xC9,
  0x20, 0x2D, 0x55, 0x86, 0x38, 0x93, 0x10, 0xA6, 0x20, 0x40, 0x63, 0x06, 0x07, 0x20, 0x10, 0xD3,
  0x05, 0x08, 0x40, 0x12, 0x04, 0x0A, 0x30, 0x50, 0x83, 0x06, 0x07, 0x20, 0x30, 0xB3, 0x81, 0x5B,
  0x12, 0x08, 0x06, 0x30, 0xD4, 0x84, 0x5D, 0x60, 0xB3, 0x30, 0x90, 0x85, 0x81, 0x45, 0xC5, 0x0C,
  0x08, 0x48, 0x16, 0xD2, 0x68, 0x59, 0xDB, 0xAD, 0xA2, 0x72, 0x81, 0x33, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_more_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_more_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_nat 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_18_communication_nat_data[] PROGMEM = {
  0x30, 0x10, 0x37, 0x68, 0x24, 0xBD, 0x77, 0x78, 0x18, 0xC1, 0x76, 0x06, 0x0A, 0x77, 0x0B, 0x03,
  0x68, 0x15, 0xB7, 0x40, 0x50, 0x92, 0x8C, 0x34, 0x20, 0x1D, 0x3B, 0x97, 0x77, 0x2D, 0x77, 0xBF,
  0x71, 0xD3, 0xB9, 0x77, 0x72, 0xD7, 0x7B, 0xF7, 0x05, 0xB7, 0x40, 0x50, 0x92, 0x04, 0x02, 0x72,
  0x0B, 0x03, 0x75, 0x06, 0x0A, 0x75, 0x81, 0x8C, 0x17, 0x28, 0x24, 0xBD, 0x77, 0x40, 0x10, 0x37,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_nat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_nat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_no_sim 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_18_communication_no_sim_data[] PROGMEM = {
  0x50, 0x98, 0x02, 0xB8, 0x22, 0x0C, 0x82, 0x0A, 0xF8, 0x53, 0x08, 0xF8, 0x05, 0xF0, 0x32, 0x83,
  0x9F, 0x80, 0x5E, 0x03, 0x20, 0x3A, 0x81, 0x80, 0x5D, 0x03, 0x20, 0x3B, 0x81, 0x80, 0x5C, 0x03,
  0x20, 0x3C, 0x81, 0x80, 0x5B, 0x03, 0x20, 0x3D, 0x81, 0x80, 0x5A, 0x03, 0x20, 0x3E, 0x83, 0x80,
  0x5F, 0x32, 0x03, 0xF8, 0x28, 0x05, 0x32, 0x03, 0xF9, 0x08, 0x40, 0x3F, 0xA0, 0x83, 0x03, 0xFB,
  0x08, 0x20, 0x28, 0x05, 0xB8, 0x1C, 0xF8, 0x75, 0x08, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_pause_presentation 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_sharp_18_communication_pause_presentation_data[] PROGMEM = {
  0x02, 0x80, 0x94, 0xB8, 0x22, 0x3F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F, 0x33, 0xF3,
  0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F,
  0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33,
  0x84, 0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xFC, 0x80, 0x90, 0xB8, 0x2C, 0xF3, 0x28, 0x09, 0x4B, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_pause_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_pause_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_person_add_disabled 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_18_communication_person_add_disabled_data[] PROGMEM = {
  0x03, 0x04, 0x77, 0x28, 0x1B, 0xF4, 0x77, 0x28, 0x1C, 0xF4, 0x58, 0x35, 0xDE, 0xA1, 0x68, 0x1C,
  0xF4, 0x30, 0x4C, 0x0C, 0x7A, 0x04, 0x20, 0xAD, 0x02, 0x6B, 0x81, 0x40, 0x8D, 0x02, 0x38, 0x31,
  0x77, 0xFC, 0xA8, 0x14, 0x09, 0xB0, 0xC4, 0x03, 0xF8, 0x44, 0x09, 0xEA, 0x17, 0x90, 0x72, 0x81,
  0xCF, 0x47, 0x49, 0x07, 0x38, 0x4C, 0xF4, 0x01, 0x27, 0x83, 0x31, 0x03, 0xBB, 0x83, 0x40, 0x9D,
  0x77, 0x04, 0xE8, 0x34, 0x09, 0xFB, 0x60, 0xBF, 0x83, 0x40, 0x9F, 0x35, 0x0B, 0xF9, 0x82, 0x40,
  0x93, 0x76, 0x81, 0xCF, 0x47, 0x72, 0x81, 0xCF, 0x47, 0x72, 0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_person_add_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_person_add_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_person_search 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_18_communication_person_search_data[] PROGMEM = {
  0x48, 0x15, 0x61, 0x71, 0x0A, 0xA0, 0xD7, 0x01, 0xC0, 0x47, 0x0E, 0xB0, 0x27, 0x82, 0x4D, 0xE6,
  0x72, 0x00, 0x17, 0x04, 0x0B, 0xA8, 0x39, 0x3D, 0xDA, 0x20, 0x3C, 0x86, 0x3D, 0x20, 0x95, 0x06,
  0xC0, 0x20, 0xD2, 0x89, 0x47, 0x60, 0x37, 0x77, 0x72, 0x7C, 0x8E, 0x57, 0x18, 0x33, 0x53, 0xD3,
  0x73, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_person_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_person_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_phone_disabled 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_18_communication_phone_disabled_data[] PROGMEM = {
  0x04, 0x07, 0x71, 0x86, 0x5B, 0xBB, 0x89, 0xF7, 0x70, 0x8B, 0x83, 0xA0, 0x9F, 0x76, 0x0A, 0xB0,
  0x92, 0x81, 0x9F, 0x75, 0x0C, 0xB0, 0x73, 0x81, 0x9F, 0x74, 0x08, 0xB0, 0x34, 0x81, 0x9F, 0x74,
  0x81, 0x8F, 0xD6, 0x81, 0x9F, 0x73, 0x81, 0x3F, 0x77, 0x81, 0x9F, 0x72, 0x0C, 0x0D, 0x72, 0x84,
  0x9F, 0x70, 0x64, 0x38, 0x35, 0x8A, 0xC8, 0x28, 0x19, 0xF7, 0x50, 0xBC, 0x81, 0x83, 0xCA, 0x07,
  0x40, 0xBE, 0x83, 0xD4, 0x9F, 0x73, 0x0B, 0xC0, 0xD0, 0x73, 0x81, 0x9F, 0x72, 0x83, 0x8A, 0x96,
  0x36, 0x81, 0x9F, 0x77, 0x60, 0x90, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_phone_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_phone_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_phone_enabled 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_sharp_18_communication_phone_enabled_data[] PROGMEM = {
  0x72, 0x83, 0x5B, 0xBB, 0x87, 0x20, 0x8B, 0x0A, 0x72, 0x0A, 0xB0, 0x97, 0x20, 0xCB, 0x07, 0x72,
  0x08, 0xB0, 0x27, 0x38, 0x18, 0xFD, 0x74, 0x81, 0x3F, 0x67, 0x40, 0xC0, 0xD7, 0x48, 0x1A, 0xF4,
  0x28, 0x35, 0x8A, 0xC8, 0x38, 0x1A, 0xF6, 0x30, 0xBC, 0x83, 0x83, 0xCF, 0x64, 0x0B, 0xE0, 0xD0,
  0x45, 0x0B, 0xC0, 0xD0, 0x67, 0x83, 0x89, 0x97, 0x27, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_phone_enabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_phone_enabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_phonelink_erase 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_sharp_18_communication_phonelink_erase_data[] PROGMEM = {
  0x30, 0x28, 0x05, 0x30, 0x23, 0x0B, 0xFA, 0x0B, 0x30, 0xBF, 0xA0, 0xB3, 0x00, 0xB7, 0x00, 0xB3,
  0x00, 0x57, 0x82, 0xBB, 0x22, 0x40, 0x02, 0x48, 0x3B, 0xB5, 0xE2, 0x28, 0x12, 0xE5, 0x48, 0x7B,
  0xB0, 0x6E, 0x22, 0xE6, 0x50, 0x0B, 0x28, 0x26, 0xEE, 0x66, 0x00, 0xB2, 0x82, 0x2E, 0xE2, 0x68,
  0x7B, 0xB0, 0x2E, 0x66, 0xE2, 0x58, 0x3B, 0xB2, 0xE6, 0x28, 0x16, 0xE2, 0x48, 0x2B, 0xB5, 0x64,
  0x06, 0x05, 0x40, 0x0B, 0x30, 0x05, 0x70, 0x0B, 0x30, 0x0B, 0x70, 0x0B, 0x30, 0xBF, 0xA0, 0xB3,
  0x0B, 0xFA, 0x0B, 0x30, 0x28, 0x05, 0x30, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_phonelink_erase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_phonelink_erase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_phonelink_lock 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_18_communication_phonelink_lock_data[] PROGMEM = {
  0x20, 0x28, 0x05, 0x30, 0x22, 0x0B, 0xFA, 0x0B, 0x20, 0xBF, 0xA0, 0xB2, 0x00, 0xB7, 0x00, 0xB2,
  0x00, 0x57, 0x85, 0xBB, 0x02, 0xAA, 0x26, 0x85, 0xBB, 0x0D, 0x55, 0xD6, 0x82, 0xBB, 0x1D, 0x20,
  0xD0, 0x15, 0x0F, 0xB9, 0x82, 0xBB, 0xFB, 0x50, 0x0B, 0xE5, 0x00, 0xBE, 0x50, 0x0B, 0xE5, 0x80,
  0x4B, 0x50, 0x0B, 0x20, 0x05, 0x70, 0x0B, 0x20, 0x0B, 0x70, 0x0B, 0x20, 0xBF, 0xA0, 0xB2, 0x0B,
  0xFA, 0x0B, 0x20, 0x28, 0x05, 0x30, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_phonelink_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 15, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_phonelink_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_phonelink_ring 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_sharp_18_communication_phonelink_ring_data[] PROGMEM = {
  0x01, 0x80, 0x63, 0x50, 0x7F, 0xB5, 0x07, 0xFB, 0x50, 0x79, 0x70, 0x79, 0x50, 0x79, 0x70, 0x79,
  0x50, 0x79, 0x70, 0x79, 0x50, 0x79, 0x70, 0x79, 0x28, 0x27, 0xA0, 0x79, 0x78, 0x67, 0xF0, 0x51,
  0xE2, 0x79, 0x78, 0x67, 0xF1, 0xF1, 0xB5, 0x79, 0x78, 0x67, 0xF1, 0xF1, 0xB5, 0x79, 0x78, 0x67,
  0xF0, 0x42, 0xE2, 0x79, 0x70, 0x79, 0x28, 0x26, 0x80, 0x79, 0x70, 0x79, 0x50, 0x79, 0x70, 0x79,
  0x50, 0x79, 0x70, 0x79, 0x50, 0x7F, 0xB5, 0x07, 0xFB, 0x50, 0x18, 0x06, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_phonelink_ring() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_phonelink_ring_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_phonelink_setup 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_18_communication_phonelink_setup_data[] PROGMEM = {
  0x30, 0x28, 0x05, 0x30, 0x23, 0x0B, 0xFA, 0x0B, 0x30, 0xBF, 0xA0, 0xB3, 0x00, 0xB7, 0x00, 0xB3,
  0x00, 0x57, 0x00, 0xB3, 0x00, 0xB7, 0x83, 0xBB, 0x08, 0x7A, 0x07, 0x08, 0x58, 0x1B, 0xB7, 0xA0,
  0x09, 0xA0, 0x74, 0x83, 0xBB, 0x2E, 0x92, 0x81, 0x9E, 0x24, 0x83, 0xBB, 0x2E, 0x92, 0x81, 0x9E,
  0x24, 0x81, 0xBB, 0x7A, 0x00, 0x9A, 0x07, 0x48, 0x3B, 0xB0, 0x87, 0xA0, 0x70, 0x85, 0x00, 0xB3,
  0x00, 0xB7, 0x00, 0xB3, 0x00, 0x57, 0x00, 0xB3, 0x00, 0xB7, 0x00, 0xB3, 0x0B, 0xFA, 0x0B, 0x30,
  0xBF, 0xA0, 0xB3, 0x02, 0x80, 0x53, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_phonelink_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_phonelink_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_phone 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_18_communication_phone_data[] PROGMEM = {
  0x83, 0x8B, 0xBB, 0x57, 0x20, 0xAB, 0x08, 0x72, 0x09, 0xB0, 0xA7, 0x20, 0x7B, 0x0C, 0x72, 0x02,
  0xB0, 0x87, 0x38, 0x1D, 0xF8, 0x74, 0x81, 0x6F, 0x37, 0x50, 0xD0, 0xC7, 0x58, 0x14, 0xFA, 0x75,
  0x81, 0x6F, 0xA3, 0x83, 0x8C, 0xA8, 0x54, 0x83, 0x6F, 0xC3, 0x8C, 0x0B, 0x50, 0x40, 0xDE, 0x0B,
  0x70, 0x60, 0xDC, 0x0B, 0x72, 0x83, 0x27, 0x99, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_portable_wifi_off 18x18, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_sharp_18_communication_portable_wifi_off_data[] PROGMEM = {
  0x68, 0x24, 0x67, 0x56, 0x84, 0x2E, 0x40, 0x4E, 0xD0, 0x90, 0x14, 0x84, 0xBF, 0x40, 0x63, 0x28,
  0x33, 0x8F, 0xD2, 0x30, 0x1A, 0x89, 0x14, 0x01, 0x66, 0x20, 0x2D, 0xD1, 0x28, 0x59, 0xFC, 0xF4,
  0x09, 0xA8, 0xB4, 0x90, 0x2F, 0x90, 0x1F, 0x90, 0xEF, 0x40, 0x17, 0xF9, 0x08, 0xF0, 0x5F, 0x33,
  0xFE, 0xF4, 0x28, 0xB3, 0x7F, 0x23, 0xF5, 0x7F, 0x16, 0xF1, 0xCF, 0x40, 0x1F, 0x60, 0xF6, 0x6F,
  0x16, 0xF1, 0x5A, 0x8B, 0x44, 0x09, 0x60, 0xF6, 0x4F, 0x33, 0xF7, 0x05, 0xCF, 0x40, 0x13, 0xF4,
  0x1E, 0x90, 0xAF, 0x32, 0x84, 0xBF, 0x40, 0x6E, 0x28, 0x39, 0xF3, 0x09, 0x48, 0x3B, 0xF4, 0x04,
  0x38, 0x1D, 0xD3, 0x68, 0x1B, 0xF4, 0x48, 0x12, 0xDC, 0x78, 0x1B, 0xF4, 0x50, 0x27, 0x10, 0xB0,
  0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_portable_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_portable_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_present_to_all 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_sharp_18_communication_present_to_all_data[] PROGMEM = {
  0x02, 0x80, 0x94, 0xB8, 0x22, 0x3F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x50, 0x07, 0x58, 0x43, 0xF3, 0x3F, 0x34, 0x07, 0xA0,
  0x74, 0x84, 0x3F, 0x33, 0xF3, 0x30, 0x7C, 0x07, 0x38, 0x43, 0xF3, 0x3F, 0x34, 0x07, 0xA0, 0x74,
  0x84, 0x3F, 0x33, 0xF3, 0x40, 0x7A, 0x07, 0x48, 0x43, 0xF3, 0x3F, 0x34, 0x07, 0xA0, 0x74, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xFC, 0x80, 0x90, 0xB8,
  0x2C, 0xF3, 0x28, 0x09, 0x4B, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_present_to_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_present_to_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_print_disabled 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_sharp_18_communication_print_disabled_data[] PROGMEM = {
  0x04, 0x05, 0x77, 0x18, 0x3A, 0xF5, 0x04, 0x80, 0x4B, 0x05, 0x48, 0x3B, 0xF5, 0x08, 0xF0, 0x75,
  0x83, 0xBF, 0x50, 0x7E, 0x07, 0x68, 0x1B, 0xF5, 0x18, 0x02, 0x30, 0x15, 0x08, 0x0E, 0xA8, 0x15,
  0x07, 0xD0, 0xE0, 0x82, 0x04, 0xD8, 0x15, 0x07, 0xB8, 0x4D, 0xAF, 0x40, 0x7E, 0x81, 0x50, 0x7A,
  0x84, 0xA2, 0xF7, 0x07, 0xF8, 0x15, 0x07, 0xC8, 0x17, 0x07, 0xF9, 0x81, 0x50, 0x7B, 0x81, 0x70,
  0x7C, 0x0F, 0x38, 0x3B, 0xF5, 0x07, 0xA8, 0x47, 0x05, 0xBB, 0xD9, 0x48, 0x5B, 0xF5, 0x07, 0xB5,
  0x40, 0x79, 0x58, 0x1B, 0xF5, 0x70, 0x79, 0x80, 0x1B, 0x0C, 0xA0, 0x56, 0x05, 0x80, 0x4B, 0x81,
  0xDF, 0x57, 0x71, 0x81, 0xBF, 0x57, 0x71, 0x0A, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_print_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_print_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_qr_code_2 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_sharp_18_communication_qr_code_2_data[] PROGMEM = {
  0x83, 0x8B, 0xBB, 0x82, 0x8B, 0x1B, 0x58, 0xBB, 0xB8, 0xB9, 0x79, 0xB1, 0x3B, 0x5B, 0x97, 0x9B,
  0xB6, 0xF6, 0xB7, 0x92, 0x8C, 0x7B, 0x6F, 0x6B, 0xB9, 0x59, 0xB7, 0xFB, 0x5B, 0x95, 0x9B, 0x8B,
  0xBB, 0x85, 0xBB, 0x58, 0xBB, 0xB8, 0x55, 0x05, 0x77, 0x75, 0x28, 0x61, 0x71, 0x0B, 0xB0, 0xBB,
  0x0B, 0x28, 0x13, 0xF3, 0x28, 0x53, 0xF3, 0x3F, 0x33, 0xA8, 0x7B, 0x0B, 0xB0, 0x17, 0x11, 0x80,
  0x17, 0x89, 0x25, 0x0B, 0xB8, 0xBB, 0xB8, 0x0B, 0xB4, 0x0F, 0xB8, 0x79, 0x79, 0xB0, 0xBB, 0x0B,
  0xA8, 0xC1, 0x30, 0xB6, 0xF6, 0xB0, 0xBB, 0x05, 0x9F, 0x30, 0xB9, 0x59, 0xB0, 0x25, 0xB2, 0x3F,
  0xC8, 0x8B, 0xBB, 0x82, 0x85, 0x2B, 0x22, 0xBB, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_qr_code_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_qr_code_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_qr_code 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_sharp_18_communication_qr_code_data[] PROGMEM = {
  0x02, 0x80, 0x05, 0x28, 0x00, 0x58, 0x92, 0x26, 0xB7, 0x7D, 0x11, 0xD7, 0x7B, 0x0F, 0x62, 0x82,
  0xB1, 0x1B, 0x28, 0x00, 0x62, 0x82, 0xB1, 0x1B, 0x20, 0xF6, 0x89, 0x1D, 0xBB, 0xE1, 0x1E, 0xBB,
  0xD6, 0x18, 0x00, 0x12, 0x80, 0x01, 0x28, 0x00, 0x12, 0x01, 0x48, 0x94, 0x6D, 0xBB, 0xE1, 0x1A,
  0x58, 0x74, 0x66, 0x28, 0x90, 0xB1, 0x05, 0x86, 0x61, 0x66, 0x28, 0xA3, 0xB1, 0x08, 0x67, 0x63,
  0x6B, 0x77, 0xD1, 0x07, 0x66, 0x63, 0x28, 0x00, 0x52, 0x83, 0x41, 0x33, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_qr_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_qr_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_qr_code_scanner 18x18, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_sharp_18_communication_qr_code_scanner_data[] PROGMEM = {
  0x83, 0x37, 0x77, 0x16, 0x84, 0x17, 0x77, 0x37, 0xB0, 0x36, 0x03, 0xB8, 0xC3, 0x77, 0xF1, 0x33,
  0x33, 0x11, 0x33, 0x33, 0x1F, 0x77, 0xF3, 0xFD, 0xDF, 0x33, 0xFD, 0xDF, 0x3F, 0x71, 0x33, 0xD2,
  0x82, 0xD3, 0x3D, 0x28, 0x2D, 0x33, 0x12, 0x03, 0x0D, 0x28, 0x2D, 0x33, 0xD2, 0x0D, 0x03, 0x48,
  0x92, 0x3F, 0xDD, 0xF3, 0x3F, 0xDD, 0xF3, 0x48, 0x92, 0x13, 0x33, 0x31, 0x13, 0x33, 0x31, 0x48,
  0x90, 0x13, 0x33, 0x31, 0x13, 0x03, 0x68, 0x91, 0x3F, 0xDD, 0xF3, 0x3C, 0x1D, 0x35, 0x03, 0x0D,
  0x28, 0x6D, 0x30, 0x1F, 0x0D, 0x32, 0x82, 0x13, 0x3D, 0x28, 0xC0, 0xD3, 0x3D, 0x0F, 0x10, 0x31,
  0x7F, 0x3F, 0xDD, 0xF3, 0x03, 0xD1, 0xC3, 0xF7, 0x7F, 0x13, 0x33, 0x31, 0x28, 0x53, 0x03, 0x1F,
  0x77, 0xB0, 0x36, 0x03, 0xB8, 0x47, 0x37, 0x77, 0x16, 0x83, 0x17, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_qr_code_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_qr_code_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_read_more 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_sharp_18_communication_read_more_data[] PROGMEM = {
  0x58, 0x13, 0x01, 0x80, 0x1A, 0x03, 0x50, 0xC0, 0x61, 0x80, 0x13, 0x18, 0xB2, 0x27, 0x77, 0x7D,
  0xF6, 0x02, 0x77, 0x72, 0x27, 0x77, 0x7D, 0xF6, 0x02, 0x77, 0x72, 0x50, 0xC0, 0x61, 0x80, 0x13,
  0x68, 0x13, 0x01, 0x80, 0x1A, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_read_more() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 15, 11), Box(0, 0, 17, 17),
      ic_sharp_18_communication_read_more_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_ring_volume 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_18_communication_ring_volume_data[] PROGMEM = {
  0x71, 0x00, 0x57, 0x72, 0x00, 0xB7, 0x40, 0x14, 0x00, 0xB4, 0x01, 0x58, 0x19, 0xE2, 0x30, 0x0B,
  0x38, 0x12, 0xD9, 0x48, 0x22, 0xDE, 0x22, 0x00, 0x22, 0x82, 0x2D, 0xD2, 0x58, 0x12, 0xD8, 0x68,
  0x18, 0xD2, 0x70, 0x17, 0x10, 0x17, 0x77, 0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x68, 0x94,
  0x19, 0xFE, 0xB8, 0x77, 0x8B, 0xEF, 0x91, 0x30, 0x50, 0xEA, 0x0A, 0x60, 0xAA, 0x82, 0xE5, 0x06,
  0xC0, 0xA6, 0x0A, 0xC0, 0x60, 0x8C, 0x08, 0x60, 0x8C, 0x81, 0x80, 0x8A, 0x06, 0x71, 0x06, 0xA0,
  0x83, 0x07, 0x03, 0x73, 0x03, 0x07, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_ring_volume() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_ring_volume_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_rss_feed 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_18_communication_rss_feed_data[] PROGMEM = {
  0x82, 0x97, 0x51, 0x71, 0xC0, 0xB0, 0x36, 0x81, 0x79, 0xCB, 0x0A, 0x71, 0x02, 0x09, 0xA0, 0xC0,
  0x13, 0x05, 0x03, 0x38, 0x23, 0xEF, 0xC3, 0xA0, 0xE0, 0x72, 0x82, 0x2E, 0xFA, 0x20, 0xB0, 0xEA,
  0x82, 0xC1, 0x03, 0xA0, 0x33, 0x82, 0x5E, 0xFC, 0x28, 0x19, 0xFB, 0x28, 0x63, 0x02, 0xEF, 0x70,
  0x2A, 0x86, 0x1A, 0xFD, 0x05, 0xFE, 0x28, 0x2C, 0xF5, 0xEA, 0x89, 0x23, 0x0E, 0xF3, 0x09, 0xF8,
  0x7E, 0xA2, 0x85, 0xBF, 0x50, 0x7F, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_rss_feed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_rss_feed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_rtt 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_18_communication_rtt_data[] PROGMEM = {
  0x68, 0x05, 0x36, 0x0E, 0xF9, 0x28, 0x93, 0x57, 0x73, 0xFC, 0x7D, 0xF7, 0x7F, 0xD2, 0x89, 0x3A,
  0xDD, 0x6F, 0x70, 0xED, 0x01, 0xFA, 0x58, 0xB4, 0x7F, 0x41, 0xFA, 0x04, 0xF7, 0x01, 0xBB, 0x92,
  0x30, 0x4F, 0x80, 0x13, 0x10, 0x17, 0x75, 0x38, 0x17, 0xF5, 0x58, 0x01, 0x12, 0x81, 0x9F, 0x25,
  0x09, 0xC8, 0x21, 0x0C, 0xE6, 0x02, 0x80, 0x03, 0x29, 0x0C, 0x68, 0x00, 0x58, 0x34, 0x02, 0xF9,
  0x50, 0x1C, 0x84, 0x94, 0xAF, 0xB7, 0x73, 0x0A, 0xB0, 0xD7, 0x38, 0x00, 0x30, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_rtt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_rtt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_screen_share 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_sharp_18_communication_screen_share_data[] PROGMEM = {
  0x10, 0x7F, 0xF0, 0x72, 0x07, 0xFF, 0x07, 0x20, 0x7F, 0x00, 0xDD, 0x07, 0x20, 0x7F, 0x81, 0xA1,
  0xCC, 0x07, 0x20, 0x7D, 0x0A, 0x02, 0x20, 0x10, 0xBB, 0x07, 0x20, 0x7C, 0x08, 0x50, 0xAB, 0x07,
  0x20, 0x7B, 0x85, 0xD1, 0x6A, 0x80, 0xBC, 0x07, 0x20, 0x7B, 0x09, 0x0D, 0xA0, 0x0C, 0xD0, 0x72,
  0x07, 0xFF, 0x07, 0x20, 0x10, 0xDF, 0xD8, 0x4D, 0x10, 0x77, 0x9F, 0xD8, 0x19, 0x77, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_send_time_extension 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_18_communication_send_time_extension_data[] PROGMEM = {
  0x58, 0x24, 0xEE, 0x46, 0x84, 0x13, 0x33, 0x3C, 0xA8, 0x6C, 0x33, 0x33, 0x10, 0x4F, 0xD8, 0x14,
  0x04, 0xFD, 0x81, 0x40, 0x4F, 0xD8, 0x14, 0x04, 0xFD, 0x82, 0x40, 0x16, 0xC8, 0x18, 0x4C, 0xC0,
  0xC0, 0x42, 0x09, 0xB0, 0x82, 0x04, 0x0C, 0xB0, 0xE2, 0x09, 0xB8, 0x91, 0x81, 0xA3, 0x04, 0xCF,
  0xE1, 0x6C, 0x08, 0x01, 0xA8, 0x4A, 0x30, 0x43, 0x4D, 0x81, 0x81, 0xDB, 0x82, 0xA3, 0x04, 0xD0,
  0x82, 0x04, 0x0D, 0xB0, 0x80, 0x4D, 0x81, 0x50, 0xAB, 0x82, 0xD6, 0x04, 0xC8, 0x16, 0x01, 0xA0,
  0xD0, 0x63, 0x01, 0x80, 0x03, 0x28, 0x11, 0xD6, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_send_time_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_send_time_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_sentiment_satisfied_alt 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_sharp_18_communication_sentiment_satisfied_alt_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x28, 0x19, 0xF2, 0x71, 0x89, 0x12, 0xF9, 0x01,
  0xF8, 0x07, 0xE3, 0x28, 0x94, 0x3E, 0x70, 0x8F, 0x05, 0xF3, 0x09, 0xF5, 0x28, 0x65, 0xF9, 0x03,
  0xF5, 0x69, 0x30, 0x34, 0x03, 0x39, 0x00, 0x69, 0x75, 0x98, 0x56, 0x5F, 0x30, 0x54, 0x48, 0xA2,
  0x45, 0x03, 0xF5, 0x1F, 0x80, 0x3E, 0x71, 0x17, 0xE3, 0x08, 0x92, 0x84, 0x9F, 0x20, 0x3C, 0xA8,
  0x4C, 0x30, 0x2F, 0x92, 0x82, 0x1D, 0xD2, 0x68, 0x22, 0xDD, 0x13, 0x83, 0x2D, 0xF8, 0x32, 0x83,
  0x38, 0xFD, 0x25, 0x01, 0x09, 0xE0, 0x90, 0x17, 0x28, 0x25, 0x77, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_sentiment_satisfied_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_sentiment_satisfied_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_sip 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_sharp_18_communication_sip_data[] PROGMEM = {
  0x01, 0x80, 0x92, 0x50, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xA8, 0x90, 0x93,
  0x3D, 0xAA, 0xD3, 0x39, 0xA0, 0x03, 0xA8, 0x90, 0x73, 0x5D, 0x88, 0xC4, 0x87, 0xA0, 0x03, 0xA8,
  0x90, 0xA5, 0x1C, 0x88, 0xC0, 0x18, 0xA0, 0x03, 0xA8, 0x69, 0x33, 0xDA, 0xAD, 0x7C, 0x00, 0x3F,
  0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x30, 0x18, 0x09, 0x25, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_speaker_phone 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_18_communication_speaker_phone_data[] PROGMEM = {
  0x48, 0x21, 0x33, 0x16, 0x06, 0x0C, 0xC0, 0xC0, 0x62, 0x89, 0x52, 0xDF, 0xB6, 0x44, 0x6B, 0xFD,
  0x26, 0xD4, 0x20, 0x03, 0x28, 0x14, 0xD6, 0x30, 0x90, 0xEA, 0x0E, 0x09, 0x58, 0x67, 0xF9, 0x55,
  0x9F, 0x75, 0x02, 0x40, 0x26, 0x80, 0x27, 0x6E, 0x60, 0xB4, 0x0B, 0x60, 0xB4, 0x0B, 0x60, 0xB4,
  0x0B, 0x60, 0xB4, 0x0B, 0x60, 0xB4, 0x0B, 0x60, 0xB4, 0x0B, 0x6E, 0x68, 0x02, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_speaker_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_speaker_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_spoke 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_sharp_18_communication_spoke_data[] PROGMEM = {
  0x60, 0x03, 0x74, 0x0B, 0xA0, 0xB7, 0x20, 0x7C, 0x07, 0x71, 0x0A, 0xC0, 0xA7, 0x10, 0x6C, 0x06,
  0x72, 0x09, 0xA0, 0x97, 0x77, 0x76, 0x83, 0x4D, 0xFC, 0x22, 0x86, 0x2C, 0xFD, 0x40, 0x1E, 0xB0,
  0xC2, 0x0C, 0xB8, 0x1E, 0x13, 0xD2, 0xD0, 0x30, 0x1C, 0x0D, 0x20, 0xDC, 0x81, 0x10, 0x6A, 0x0E,
  0x04, 0x20, 0x40, 0xEA, 0x06, 0x30, 0x10, 0x36, 0x03, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_spoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_communication_spoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_stay_current_landscape 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_18_communication_stay_current_landscape_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x30, 0x10, 0x3F, 0xFA, 0x00, 0x3A, 0x0C, 0x80, 0x63, 0x0C, 0xA0, 0x03, 0xA0,
  0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A,
  0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03,
  0xA0, 0xC8, 0x06, 0x30, 0xCA, 0x00, 0x3F, 0xFA, 0x03, 0x01, 0x80, 0x94, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_stay_current_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_stay_current_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_stay_current_portrait 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_communication_stay_current_portrait_data[] PROGMEM = {
  0x18, 0x06, 0x30, 0x10, 0x3F, 0xB0, 0x03, 0xFB, 0x82, 0x33, 0xFC, 0x80, 0x2B, 0x84, 0xCF, 0x33,
  0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84,
  0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F,
  0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xFC, 0x80, 0x2B,
  0x82, 0xCF, 0x33, 0xFB, 0x00, 0x3F, 0xB0, 0x31, 0x80, 0x63, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_stay_current_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_stay_current_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_stay_primary_landscape 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_18_communication_stay_primary_landscape_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x30, 0x10, 0x3F, 0xFA, 0x00, 0x3A, 0x0C, 0x80, 0x63, 0x0C, 0xA0, 0x03, 0xA0,
  0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A,
  0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03,
  0xA0, 0xC8, 0x06, 0x30, 0xCA, 0x00, 0x3F, 0xFA, 0x03, 0x01, 0x80, 0x94, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_stay_primary_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_stay_primary_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_stay_primary_portrait 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_communication_stay_primary_portrait_data[] PROGMEM = {
  0x18, 0x06, 0x30, 0x10, 0x3F, 0xB0, 0x03, 0xFB, 0x82, 0x33, 0xFC, 0x80, 0x2B, 0x84, 0xCF, 0x33,
  0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84,
  0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F,
  0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xFC, 0x80, 0x2B,
  0x82, 0xCF, 0x33, 0xFB, 0x00, 0x3F, 0xB0, 0x31, 0x80, 0x63, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_stay_primary_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_communication_stay_primary_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_stop_screen_share 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_sharp_18_communication_stop_screen_share_data[] PROGMEM = {
  0x10, 0x60, 0x37, 0x72, 0x81, 0xCE, 0x37, 0x71, 0x84, 0x7F, 0xE3, 0x0A, 0xFA, 0x07, 0x20, 0x7A,
  0x82, 0xE3, 0x0A, 0xF9, 0x07, 0x20, 0x7B, 0x84, 0xE3, 0x0A, 0xDD, 0xD0, 0x72, 0x07, 0xC8, 0x4E,
  0x30, 0x61, 0xCC, 0x07, 0x20, 0x7D, 0x0E, 0x03, 0x20, 0x10, 0xCB, 0x07, 0x20, 0x7C, 0x82, 0xAC,
  0xE3, 0x20, 0xAB, 0x07, 0x20, 0x7B, 0x86, 0xD1, 0x7F, 0xE3, 0x09, 0xB0, 0x72, 0x07, 0xB0, 0xA0,
  0xDB, 0x82, 0xE3, 0x09, 0xA0, 0x72, 0x07, 0xFA, 0x84, 0xE3, 0x09, 0xF7, 0x20, 0x20, 0xDF, 0xA8,
  0x7E, 0x30, 0x81, 0x07, 0x79, 0xFB, 0x83, 0xE3, 0x03, 0x7F, 0xF8, 0x2E, 0x30, 0x97, 0x68, 0x21,
  0xCE, 0x37, 0x71, 0x81, 0x1B, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_stop_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_stop_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_swap_calls 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_sharp_18_communication_swap_calls_data[] PROGMEM = {
  0x38, 0x31, 0xAE, 0xD5, 0x38, 0x11, 0xB1, 0x58, 0x92, 0xCE, 0x8B, 0xF4, 0x01, 0xDF, 0xD1, 0x38,
  0x12, 0xF6, 0x28, 0x2D, 0xA1, 0xDB, 0x0D, 0x01, 0x28, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3,
  0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3, 0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3,
  0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3, 0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3,
  0x28, 0x71, 0xBC, 0xFC, 0xB1, 0xAC, 0x28, 0x14, 0xF3, 0x30, 0x4B, 0x86, 0x40, 0x6F, 0x84, 0xDD,
  0x58, 0x14, 0xE4, 0x30, 0x9A, 0x0D, 0x03, 0x60, 0x15, 0x01, 0x03, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_swap_calls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_swap_calls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_textsms 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_18_communication_textsms_data[] PROGMEM = {
  0x03, 0x80, 0x92, 0x70, 0x30, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7B,
  0x86, 0xCC, 0xFC, 0xCF, 0xCC, 0xB0, 0x07, 0xB8, 0x63, 0x3F, 0x33, 0xF3, 0x3B, 0x00, 0x7B, 0x86,
  0xCC, 0xFC, 0xCF, 0xCC, 0xB0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07,
  0xA0, 0x98, 0x07, 0x78, 0x23, 0x7F, 0x77, 0x60, 0x07, 0x77, 0x01, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_textsms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_textsms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_unsubscribe 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_18_communication_unsubscribe_data[] PROGMEM = {
  0x08, 0x80, 0x90, 0xB8, 0x28, 0x0B, 0xEF, 0xB8, 0x5E, 0xB0, 0xBB, 0x29, 0xE8, 0x91, 0x92, 0xBB,
  0x0B, 0xE5, 0x02, 0x9A, 0x86, 0x92, 0x05, 0xEB, 0x0B, 0xA8, 0x6D, 0x50, 0x22, 0x05, 0xDA, 0x81,
  0xB0, 0xBC, 0x82, 0xD5, 0x5D, 0xC8, 0x1B, 0x0B, 0xFA, 0x84, 0xEA, 0xBB, 0x0B, 0xF9, 0x82, 0x80,
  0x21, 0x20, 0xBF, 0x81, 0xA1, 0xCA, 0x81, 0x90, 0xBF, 0x04, 0x08, 0xC0, 0x40, 0x88, 0x03, 0xB8,
  0x51, 0xA8, 0x33, 0xB6, 0x72, 0x06, 0xC0, 0x37, 0x38, 0x28, 0xED, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_unsubscribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_unsubscribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_voicemail 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_communication_voicemail_data[] PROGMEM = {
  0x28, 0x22, 0x56, 0x36, 0x82, 0x36, 0x52, 0x30, 0x7C, 0x0A, 0x40, 0xAC, 0x89, 0x07, 0x05, 0xF9,
  0x11, 0x7F, 0x82, 0x89, 0x08, 0xF7, 0x11, 0x9F, 0x5B, 0xC4, 0x08, 0x92, 0x90, 0x84, 0x82, 0xCB,
  0xE8, 0x48, 0x44, 0xF3, 0x3F, 0x44, 0x82, 0x8E, 0xCA, 0x48, 0x47, 0xF1, 0x1F, 0x74, 0x83, 0xAC,
  0x7F, 0x62, 0x81, 0x3E, 0xB2, 0x81, 0xBE, 0x32, 0x86, 0x6F, 0x70, 0xBF, 0xDC, 0xA8, 0x2D, 0xBB,
  0xDA, 0x82, 0xCD, 0xFB, 0x30, 0x50, 0x98, 0x06, 0xB0, 0x90, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_voicemail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 17, 12), Box(0, 0, 17, 17),
      ic_sharp_18_communication_voicemail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_vpn_key_off 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_sharp_18_communication_vpn_key_off_data[] PROGMEM = {
  0x10, 0x27, 0x71, 0x81, 0x1E, 0x77, 0x71, 0x81, 0x6F, 0x77, 0x70, 0x6A, 0x07, 0x75, 0x04, 0xC0,
  0x77, 0x40, 0xCA, 0x84, 0x77, 0xF7, 0x01, 0x80, 0x35, 0x1A, 0x0B, 0x28, 0x36, 0xF7, 0x09, 0xE0,
  0x1A, 0x0B, 0x38, 0x3E, 0xF7, 0x09, 0xD0, 0x10, 0xCA, 0x81, 0x73, 0x9B, 0x81, 0x70, 0x9A, 0x82,
  0x85, 0x03, 0xE8, 0x6E, 0x7F, 0x70, 0x9F, 0x43, 0x05, 0x0E, 0xB8, 0x7D, 0x30, 0x6F, 0x70, 0x94,
  0x48, 0x21, 0x47, 0x54, 0x83, 0x6F, 0x70, 0x17, 0x68, 0x16, 0xF7, 0x77, 0x18, 0x16, 0xE2, 0x77,
  0x10, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_vpn_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 17, 16), Box(0, 0, 17, 17),
      ic_sharp_18_communication_vpn_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_vpn_key 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_sharp_18_communication_vpn_key_data[] PROGMEM = {
  0x38, 0x21, 0x57, 0x47, 0x60, 0x7C, 0x0C, 0x02, 0x73, 0x06, 0xE0, 0xD7, 0x30, 0xEA, 0x81, 0xB8,
  0xEA, 0x0A, 0x80, 0x37, 0x01, 0x02, 0xA0, 0xD2, 0x06, 0xFB, 0x03, 0x02, 0xA0, 0xD2, 0x06, 0xFB,
  0x81, 0x30, 0xEA, 0x81, 0xB8, 0xEA, 0x82, 0xA7, 0x79, 0xA8, 0x3D, 0x71, 0x06, 0xE0, 0xD3, 0x03,
  0xA0, 0xB4, 0x07, 0xC0, 0xC0, 0x23, 0x03, 0xA0, 0xB5, 0x82, 0x15, 0x74, 0x58, 0x21, 0x77, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_vpn_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 17, 13), Box(0, 0, 17, 17),
      ic_sharp_18_communication_vpn_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_communication_wifi_calling 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_sharp_18_communication_wifi_calling_data[] PROGMEM = {
  0x01, 0x0F, 0x54, 0x84, 0x35, 0x41, 0x03, 0xB8, 0x21, 0x03, 0xDC, 0x08, 0x02, 0xB8, 0x23, 0x01,
  0xEC, 0x81, 0x60, 0xEA, 0x05, 0x20, 0x4B, 0x0A, 0x28, 0x1B, 0xF9, 0x48, 0x17, 0xFC, 0x38, 0x14,
  0xF1, 0x50, 0x90, 0x24, 0x0C, 0x0A, 0x74, 0x81, 0x2E, 0x83, 0x03, 0x02, 0x68, 0x33, 0xE9, 0x17,
  0xB0, 0x75, 0x81, 0x2C, 0xEC, 0x07, 0x70, 0x50, 0xCB, 0x07, 0x72, 0x82, 0x13, 0x52, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_communication_wifi_calling() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 14), Box(0, 0, 17, 17),
      ic_sharp_18_communication_wifi_calling_data, Alpha4(color::Black));
  return value;
}
