#include "hardware.h"

using namespace roo_display;

// Image file ic_round_36_hardware_adf_scanner 36x36, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_36_hardware_adf_scanner_data[] PROGMEM = {
  0x70, 0x80, 0xDF, 0xD0, 0xD0, 0x87, 0x60, 0x8F, 0xFA, 0x08, 0x75, 0x0D, 0xFF, 0xA0, 0xD7, 0x5B,
  0x75, 0xB7, 0x5B, 0x75, 0xB7, 0x5B, 0x75, 0xB7, 0x5B, 0x75, 0xB7, 0x5B, 0x75, 0xB7, 0x5B, 0x75,
  0xB7, 0x5B, 0x75, 0xB7, 0x5B, 0x75, 0xB7, 0x5B, 0x75, 0xB7, 0x10, 0x70, 0xCF, 0xFF, 0x90, 0xC0,
  0x73, 0x0B, 0xFF, 0xFD, 0x81, 0xB0, 0x7F, 0xFF, 0xF0, 0x70, 0xCF, 0xFF, 0xF0, 0xCF, 0xFF, 0xA0,
  0x09, 0xFF, 0xFE, 0x09, 0x20, 0x9F, 0xFF, 0xD0, 0x92, 0x09, 0xFF, 0xFE, 0x00, 0x9F, 0xFF, 0xFF,
  0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_adf_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_adf_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_browser_not_supported 36x36, 4-bit Alpha,  RLE, 219 bytes.
static const unsigned char ic_round_36_hardware_browser_not_supported_data[] PROGMEM = {
  0x10, 0x50, 0x37, 0x77, 0x50, 0x6A, 0x05, 0x30, 0xBF, 0xFC, 0x82, 0xB3, 0x04, 0xB0, 0x53, 0x0B,
  0xFF, 0xC8, 0x2E, 0x10, 0x9B, 0x05, 0x30, 0xBF, 0xFC, 0x81, 0x60, 0x7C, 0x05, 0x77, 0x40, 0x7A,
  0x81, 0x70, 0x7D, 0x05, 0x77, 0x30, 0x7A, 0x81, 0x70, 0x7A, 0x0D, 0xB0, 0x57, 0x72, 0x07, 0xA8,
  0x17, 0x07, 0xA0, 0x07, 0xB0, 0x57, 0x71, 0x07, 0xA8, 0x17, 0x07, 0xA8, 0x17, 0x07, 0xB0, 0x57,
  0x70, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x20, 0x7B, 0x05, 0x76, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x73,
  0x07, 0xB0, 0x57, 0x50, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x40, 0x7B, 0x05, 0x74, 0x07, 0xA8, 0x17,
  0x07, 0xA0, 0x75, 0x07, 0xB0, 0x57, 0x30, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x60, 0x7B, 0x05, 0x72,
  0x07, 0xA8, 0x17, 0x07, 0xA0, 0x77, 0x07, 0xB0, 0x57, 0x10, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x71,
  0x07, 0xB0, 0x57, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x77, 0x20, 0x7B, 0x05, 0x60, 0x7A, 0x81, 0x70,
  0x7A, 0x07, 0x73, 0x07, 0xB0, 0x55, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x77, 0x40, 0x7B, 0x05, 0x40,
  0x7A, 0x81, 0x70, 0x7A, 0x07, 0x75, 0x07, 0xB0, 0x53, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x77, 0x60,
  0x7B, 0x05, 0x38, 0x3B, 0xF7, 0x07, 0xA0, 0x77, 0x70, 0x7B, 0x05, 0x38, 0x2B, 0x70, 0x6F, 0xFF,
  0x90, 0x53, 0x82, 0x30, 0x1E, 0xFF, 0xF9, 0x05, 0x50, 0x30, 0xBF, 0xFF, 0x90, 0x57, 0x77, 0x40,
  0x7B, 0x03, 0x77, 0x74, 0x07, 0xA0, 0x57, 0x77, 0x50, 0x40, 0x62,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_browser_not_supported() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 31, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_browser_not_supported_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_browser_updated 36x36, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_round_36_hardware_browser_updated_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x07, 0x70, 0x23, 0x81, 0x27, 0x27, 0x20, 0x30, 0xEF, 0xD0, 0xD3, 0x81, 0xDF,
  0xD7, 0x20, 0xBF, 0xE0, 0xD3, 0xB7, 0x2B, 0x80, 0x77, 0x02, 0x3B, 0x72, 0xB7, 0x71, 0xB7, 0x2B,
  0x77, 0x1B, 0x72, 0xB7, 0x71, 0xB7, 0x2B, 0x77, 0x1B, 0x72, 0xB7, 0x71, 0xB7, 0x2B, 0x77, 0x1B,
  0x72, 0xB7, 0x71, 0xB7, 0x2B, 0x74, 0x06, 0x0E, 0xF0, 0xE0, 0x65, 0xB7, 0x40, 0xCF, 0xA0, 0xC5,
  0xB7, 0x40, 0x6F, 0xA0, 0x65, 0xB7, 0x50, 0x7F, 0x07, 0x6B, 0x76, 0x07, 0xD0, 0x74, 0x81, 0x27,
  0x2B, 0x77, 0x07, 0xB0, 0x75, 0x81, 0xDF, 0xDB, 0x77, 0x18, 0x16, 0xD7, 0x6E, 0x77, 0x73, 0xE7,
  0x77, 0x3B, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x70, 0x8D, 0xFF, 0xFB, 0x0D, 0x08,
  0x70, 0x10, 0xDF, 0xF0, 0xD0, 0x17, 0x50, 0xBF, 0xFA, 0x0B, 0x75, 0x0E, 0xFF, 0xA0, 0xE7, 0x50,
  0x9F, 0xFA, 0x09, 0x76, 0x05, 0x80, 0x92, 0x70, 0x57,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_browser_updated() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_browser_updated_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_cast_connected 36x36, 4-bit Alpha,  RLE, 287 bytes.
static const unsigned char ic_round_36_hardware_cast_connected_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x73, 0x05, 0x80, 0x96, 0x70, 0x53, 0x07, 0xA8, 0x37, 0x2D, 0xD2,
  0x20, 0x5F, 0xFE, 0x05, 0x20, 0x7A, 0x07, 0x60, 0x7F, 0xFE, 0x07, 0x20, 0x7A, 0x07, 0x70, 0x50,
  0xBF, 0xFC, 0x07, 0x20, 0x7A, 0x07, 0x72, 0x03, 0x0C, 0xFF, 0xA0, 0x72, 0x07, 0xA8, 0x57, 0x1C,
  0xDA, 0x73, 0x50, 0x6F, 0xF9, 0x07, 0x20, 0x7A, 0x07, 0x06, 0xD0, 0xC0, 0x64, 0x02, 0x0D, 0xFE,
  0x07, 0x20, 0x7A, 0x81, 0x72, 0xEE, 0x0D, 0x04, 0x30, 0x10, 0xDF, 0xD0, 0x72, 0x07, 0xA0, 0x72,
  0x82, 0x25, 0x9E, 0xC0, 0x93, 0x01, 0x0D, 0xFC, 0x07, 0x20, 0x7A, 0x07, 0x60, 0x60, 0xEB, 0x0B,
  0x30, 0x2F, 0xC0, 0x72, 0x07, 0xA0, 0x77, 0x01, 0x0A, 0xB0, 0xB3, 0x06, 0xFB, 0x07, 0x20, 0x7A,
  0x84, 0x71, 0xBC, 0x82, 0x40, 0x7B, 0x09, 0x30, 0xCF, 0xA0, 0x72, 0x07, 0xA0, 0x70, 0x6C, 0x0B,
  0x02, 0x30, 0x7B, 0x04, 0x20, 0x3F, 0xA0, 0x72, 0x07, 0xA8, 0x17, 0x3E, 0xC0, 0xE0, 0x43, 0x0A,
  0xA0, 0xD3, 0x0B, 0xF9, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x50, 0xAC, 0x04, 0x20, 0x10, 0xEA, 0x06,
  0x20, 0x5F, 0x90, 0x52, 0x07, 0xA0, 0x74, 0x03, 0x0D, 0xA0, 0xE0, 0x22, 0x06, 0xA0, 0xC3, 0x80,
  0x37, 0x05, 0x30, 0x7A, 0x07, 0x50, 0x10, 0xDA, 0x0B, 0x30, 0xEA, 0x03, 0x76, 0x07, 0xA8, 0x27,
  0x7D, 0x73, 0x03, 0xB0, 0x22, 0x09, 0xA0, 0x77, 0x60, 0x9A, 0x00, 0x7A, 0x0C, 0x30, 0xAA, 0x08,
  0x20, 0x5A, 0x0A, 0x30, 0x28, 0x04, 0x70, 0x9B, 0x00, 0x7B, 0x07, 0x20, 0x5A, 0x0C, 0x20, 0x2A,
  0x0D, 0x30, 0xDF, 0xD0, 0x40, 0x7B, 0x0D, 0x38, 0x1E, 0xFB, 0x38, 0x1E, 0xFC, 0x30, 0xDF, 0xC8,
  0x19, 0x03, 0x80, 0x07, 0x38, 0x12, 0x71, 0x38, 0x12, 0x61, 0x30, 0x28, 0x06, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_cast_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_cast_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_cast_for_education 36x36, 4-bit Alpha,  RLE, 299 bytes.
static const unsigned char ic_round_36_hardware_cast_for_education_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x18, 0x25, 0xA8, 0x17, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x60, 0x30, 0xBB, 0x0E, 0x07, 0x60, 0x7A,
  0x83, 0x72, 0xDD, 0x27, 0x40, 0x20, 0xAF, 0x0E, 0x06, 0x40, 0x7A, 0x07, 0x76, 0x01, 0x09, 0xFC,
  0x0D, 0x04, 0x20, 0x7A, 0x07, 0x76, 0x09, 0xFF, 0x81, 0x10, 0x7A, 0x07, 0x76, 0x01, 0x09, 0xFC,
  0x0D, 0x04, 0x20, 0x7A, 0x85, 0x71, 0xCD, 0xA7, 0x37, 0x20, 0x20, 0xAF, 0x0E, 0x06, 0x40, 0x7A,
  0x07, 0x06, 0xD0, 0xC0, 0x67, 0x82, 0x10, 0x3B, 0xB8, 0x2E, 0x70, 0x14, 0x07, 0xA8, 0x17, 0x2E,
  0xE0, 0xD0, 0x45, 0x89, 0x07, 0xC4, 0x05, 0xA8, 0x11, 0x89, 0x40, 0x7A, 0x07, 0x28, 0x22, 0x59,
  0xEC, 0x09, 0x40, 0x7A, 0x0B, 0x02, 0x20, 0x70, 0xEA, 0x40, 0x7A, 0x07, 0x60, 0x60, 0xEB, 0x0B,
  0x30, 0x3C, 0x0C, 0x0E, 0xB0, 0xA4, 0x07, 0xA0, 0x77, 0x01, 0x0A, 0xB0, 0xB3, 0x03, 0x0B, 0xD0,
  0xE0, 0x75, 0x07, 0xA8, 0x47, 0x1B, 0xC8, 0x24, 0x07, 0xB0, 0x94, 0x04, 0x0C, 0xA0, 0x80, 0x16,
  0x07, 0xA0, 0x70, 0x6C, 0x0B, 0x02, 0x30, 0x7B, 0x04, 0x50, 0x30, 0x17, 0x10, 0x7A, 0x81, 0x73,
  0xEC, 0x0E, 0x04, 0x30, 0xAA, 0x0D, 0x77, 0x10, 0x7A, 0x07, 0x20, 0x50, 0xAC, 0x04, 0x20, 0x10,
  0xEA, 0x06, 0x77, 0x07, 0xA0, 0x74, 0x03, 0x0D, 0xA0, 0xE0, 0x22, 0x06, 0xA0, 0xC7, 0x70, 0x7A,
  0x07, 0x50, 0x10, 0xDA, 0x0B, 0x30, 0xEA, 0x03, 0x76, 0x07, 0xA8, 0x27, 0x7C, 0x73, 0x03, 0xB0,
  0x22, 0x09, 0xA0, 0x77, 0x60, 0x9A, 0x00, 0x7A, 0x0B, 0x30, 0xAA, 0x08, 0x20, 0x5A, 0x0A, 0x30,
  0x28, 0x04, 0x70, 0x9B, 0x00, 0x7B, 0x07, 0x20, 0x5A, 0x0C, 0x20, 0x2A, 0x0D, 0x30, 0xDF, 0xD0,
  0x40, 0x7B, 0x0C, 0x38, 0x1E, 0xFB, 0x38, 0x1E, 0xFC, 0x30, 0xDF, 0xC8, 0x19, 0x03, 0x80, 0x07,
  0x38, 0x12, 0x71, 0x38, 0x12, 0x61, 0x30, 0x28, 0x06, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_cast_for_education() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_cast_for_education_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_cast 36x36, 4-bit Alpha,  RLE, 242 bytes.
static const unsigned char ic_round_36_hardware_cast_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x83, 0x72, 0xDD, 0x27, 0x77, 0x50, 0x7A,
  0x07, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x77, 0x20, 0x7A, 0x85,
  0x71, 0xCD, 0xA7, 0x37, 0x77, 0x30, 0x7A, 0x07, 0x06, 0xD0, 0xC0, 0x67, 0x77, 0x10, 0x7A, 0x81,
  0x72, 0xEE, 0x0D, 0x04, 0x77, 0x60, 0x7A, 0x07, 0x28, 0x22, 0x59, 0xEC, 0x09, 0x77, 0x50, 0x7A,
  0x07, 0x60, 0x60, 0xEB, 0x0B, 0x77, 0x40, 0x7A, 0x07, 0x70, 0x10, 0xAB, 0x0B, 0x77, 0x30, 0x7A,
  0x84, 0x71, 0xBC, 0x82, 0x40, 0x7B, 0x09, 0x77, 0x20, 0x7A, 0x07, 0x06, 0xC0, 0xB0, 0x23, 0x07,
  0xB0, 0x47, 0x71, 0x07, 0xA8, 0x17, 0x3E, 0xC0, 0xE0, 0x43, 0x0A, 0xA0, 0xD7, 0x71, 0x07, 0xA0,
  0x72, 0x05, 0x0A, 0xC0, 0x42, 0x01, 0x0E, 0xA0, 0x67, 0x70, 0x7A, 0x07, 0x40, 0x30, 0xDA, 0x0E,
  0x02, 0x20, 0x6A, 0x0C, 0x77, 0x07, 0xA0, 0x75, 0x01, 0x0D, 0xA0, 0xB3, 0x0E, 0xA0, 0x37, 0x60,
  0x7A, 0x82, 0x77, 0xC7, 0x30, 0x3B, 0x02, 0x20, 0x9A, 0x07, 0x76, 0x09, 0xA0, 0x07, 0xA0, 0xB3,
  0x0A, 0xA0, 0x82, 0x05, 0xA0, 0xA3, 0x02, 0x80, 0x47, 0x09, 0xB0, 0x07, 0xB0, 0x72, 0x05, 0xA0,
  0xC2, 0x02, 0xA0, 0xD3, 0x0D, 0xFD, 0x04, 0x07, 0xB0, 0xC3, 0x81, 0xEF, 0xB3, 0x81, 0xEF, 0xC3,
  0x0D, 0xFC, 0x81, 0x90, 0x38, 0x00, 0x73, 0x81, 0x27, 0x13, 0x81, 0x26, 0x13, 0x02, 0x80, 0x67,
  0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_cast() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_cast_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_computer 36x36, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_36_hardware_computer_data[] PROGMEM = {
  0x40, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x87, 0x08, 0xFF, 0xFF, 0x08, 0x60, 0xDF, 0xFF, 0xF0, 0xD6,
  0xB0, 0x77, 0x77, 0x10, 0x7B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6,
  0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77,
  0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B,
  0x77, 0x73, 0xB6, 0xB0, 0x77, 0x77, 0x10, 0x7B, 0x60, 0xDF, 0xFF, 0xF0, 0xD6, 0x08, 0xFF, 0xFF,
  0x08, 0x70, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x84, 0x08, 0xFF, 0xFF, 0xE0, 0x80, 0xEF, 0xFF, 0xFE,
  0x0E, 0x08, 0xFF, 0xFF, 0xE0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_computer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_computer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_connected_tv 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_round_36_hardware_connected_tv_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0A, 0x47, 0x83, 0x61, 0x03, 0xEF, 0xFF, 0xD8, 0x1E, 0x3B, 0xFF, 0xFF, 0x0B,
  0xB8, 0x0A, 0x47, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE1, 0x83, 0x3D,
  0xC9, 0x47, 0x74, 0xE1, 0x05, 0xC0, 0xD0, 0x57, 0x72, 0xE2, 0x81, 0x47, 0xBB, 0x0B, 0x77, 0x1E,
  0x50, 0x20, 0xAA, 0x0C, 0x01, 0x76, 0xE2, 0x05, 0x02, 0x30, 0x5A, 0x0C, 0x76, 0xE1, 0x06, 0xA0,
  0xC0, 0x42, 0x04, 0xA0, 0x87, 0x5E, 0x10, 0x20, 0xCB, 0x07, 0x20, 0x7A, 0x02, 0x74, 0xE3, 0x03,
  0x0B, 0xA0, 0x62, 0x81, 0xDF, 0x97, 0x4E, 0x58, 0x69, 0xFE, 0x10, 0x6F, 0xE7, 0x4E, 0x18, 0x17,
  0xB3, 0x28, 0x3D, 0xF7, 0x01, 0xA0, 0x37, 0x3E, 0x18, 0x67, 0xFE, 0x10, 0x8F, 0xC2, 0x81, 0xDF,
  0x57, 0x3E, 0x10, 0x7A, 0x83, 0x60, 0x1D, 0x92, 0x81, 0x7E, 0x37, 0x3E, 0x77, 0x73, 0xE8, 0x0A,
  0x47, 0xA0, 0xE0, 0xBF, 0xFF, 0xF8, 0x1B, 0x3E, 0xFF, 0xFD, 0x83, 0xE3, 0x01, 0x68, 0x02, 0x7F,
  0xD8, 0x02, 0x70, 0x60, 0x17, 0x3F, 0xD7, 0x74, 0x0D, 0xFB, 0x0D, 0x77, 0x40, 0x28, 0x06, 0x70,
  0x27, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_connected_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_connected_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_desktop_mac 36x36, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_round_36_hardware_desktop_mac_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0xF8, 0x3B, 0x30, 0x1E, 0xFF, 0xFF, 0xA8, 0x1E, 0x16, 0xFF, 0xFF, 0xC0,
  0x60, 0x7A, 0x0D, 0x02, 0x77, 0x73, 0x02, 0x0D, 0xA0, 0x07, 0xA0, 0x87, 0x77, 0x50, 0x8A, 0x00,
  0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x75, 0x07, 0xA0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0,
  0x70, 0x6F, 0xFF, 0xFC, 0x81, 0x61, 0xEF, 0xFF, 0xFA, 0x83, 0xE1, 0x03, 0xBF, 0xFF, 0xF0, 0xB0,
  0x37, 0x70, 0x5E, 0x05, 0x77, 0x74, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x77, 0x30, 0xAF, 0x90, 0xA7,
  0x77, 0x20, 0x4F, 0xB0, 0x47, 0x77, 0x10, 0x9F, 0xB0, 0x97, 0x77, 0x10, 0x40, 0xEF, 0x90, 0xE0,
  0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_desktop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 34, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_desktop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_desktop_windows 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_round_36_hardware_desktop_windows_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0xF8, 0x3B, 0x30, 0x1E, 0xFF, 0xFF, 0xA8, 0x1E, 0x16, 0xFF, 0xFF, 0xC0,
  0x60, 0x7A, 0x0D, 0x02, 0x77, 0x73, 0x02, 0x0D, 0xA0, 0x07, 0xA0, 0x87, 0x77, 0x50, 0x8A, 0x00,
  0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x08, 0x77, 0x75, 0x08,
  0xA0, 0x07, 0xA0, 0xD0, 0x27, 0x77, 0x30, 0x20, 0xDA, 0x07, 0x06, 0xFF, 0xFF, 0xC8, 0x16, 0x1E,
  0xFF, 0xFF, 0xA8, 0x3E, 0x10, 0x3B, 0xFF, 0xFF, 0x0B, 0x03, 0x77, 0x1E, 0x77, 0x77, 0xE7, 0x77,
  0x7E, 0x77, 0x74, 0x08, 0xFB, 0x08, 0x77, 0x71, 0x0E, 0xFB, 0x0E, 0x77, 0x71, 0x08, 0xFB, 0x08,
  0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_desktop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 34, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_desktop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_developer_board_off 36x36, 4-bit Alpha,  RLE, 236 bytes.
static const unsigned char ic_round_36_hardware_developer_board_off_data[] PROGMEM = {
  0x10, 0x10, 0x27, 0x77, 0x71, 0x82, 0x1E, 0xF7, 0x48, 0x09, 0x67, 0x06, 0x01, 0x40, 0x4B, 0x07,
  0x30, 0x4F, 0xFC, 0x0E, 0x03, 0x40, 0xBB, 0x07, 0x30, 0x4F, 0xFC, 0x0B, 0x5C, 0x07, 0x30, 0x38,
  0x09, 0x37, 0xB5, 0xD0, 0x77, 0x74, 0xB5, 0xE0, 0x77, 0x73, 0xB5, 0xB0, 0xBB, 0x07, 0x40, 0x52,
  0x84, 0x27, 0x77, 0x72, 0x3B, 0x81, 0x77, 0x22, 0xB1, 0x0B, 0xB0, 0x73, 0x82, 0x45, 0x0D, 0xC0,
  0xD3, 0xD0, 0xD2, 0xB2, 0x0B, 0xB0, 0x75, 0xE3, 0xD0, 0xD2, 0xB3, 0xC0, 0x74, 0x0E, 0xD3, 0xB8,
  0x17, 0x72, 0x2B, 0x3D, 0x07, 0x30, 0x4C, 0x08, 0x3B, 0x5B, 0x3E, 0x07, 0x74, 0xB5, 0xB3, 0xF0,
  0x74, 0x81, 0x77, 0x23, 0xB8, 0x17, 0x72, 0x2B, 0x30, 0x8F, 0x07, 0x38, 0x14, 0xFD, 0x3D, 0x0D,
  0x2B, 0x71, 0x0B, 0xB0, 0x73, 0x04, 0x93, 0xD0, 0xD2, 0xB3, 0x84, 0x27, 0x77, 0x78, 0xC0, 0x73,
  0x04, 0x3B, 0x81, 0x77, 0x22, 0xB3, 0x0D, 0xE0, 0xEB, 0x07, 0x6B, 0x5B, 0x3F, 0x08, 0x0B, 0xB0,
  0x75, 0xB5, 0xB3, 0xF0, 0x71, 0xC0, 0x74, 0xB8, 0x17, 0x72, 0x2B, 0x3F, 0x07, 0x1D, 0x07, 0x30,
  0x4C, 0x0D, 0x2B, 0x30, 0xDE, 0x81, 0x50, 0xDD, 0x07, 0x30, 0x4B, 0x0D, 0x2B, 0x30, 0x28, 0x01,
  0x70, 0x52, 0x82, 0x27, 0x7B, 0xB0, 0x73, 0x82, 0x37, 0x72, 0x2B, 0x77, 0x20, 0xAB, 0x07, 0x71,
  0xB7, 0x73, 0x0A, 0xB0, 0x77, 0xB8, 0x09, 0x57, 0x08, 0x0E, 0xB0, 0x76, 0x0B, 0xFF, 0xFC, 0x07,
  0x50, 0x30, 0xEF, 0xFF, 0xC0, 0x75, 0x01, 0x06, 0x80, 0xA1, 0x70, 0xBB, 0x07, 0x77, 0x77, 0x0B,
  0xB0, 0x17, 0x77, 0x78, 0x2B, 0xFE, 0x17, 0x77, 0x71, 0x04, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_developer_board_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 32, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_developer_board_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_developer_board 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_round_36_hardware_developer_board_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0A, 0x17, 0x06, 0x01, 0x40, 0x30, 0xEF, 0xFF, 0xA0, 0xE0, 0x33, 0x0B, 0xFF,
  0xFC, 0x0B, 0x3B, 0x0D, 0x08, 0x80, 0x95, 0x70, 0x80, 0xDB, 0x3B, 0x02, 0x77, 0x50, 0x2B, 0x3B,
  0x77, 0x7B, 0x3B, 0x30, 0x58, 0x02, 0x78, 0x61, 0x05, 0x77, 0x77, 0x53, 0xB8, 0x17, 0x72, 0xB3,
  0xF0, 0x71, 0xE3, 0xD0, 0xDB, 0x3F, 0x07, 0x1E, 0x3D, 0x0D, 0xB3, 0xF0, 0x71, 0xE3, 0xB8, 0x17,
  0x72, 0xB3, 0xF8, 0x17, 0x0C, 0xC0, 0xC3, 0xB3, 0xB3, 0xF0, 0x77, 0x3B, 0x3B, 0x3F, 0x86, 0x70,
  0x57, 0x77, 0x75, 0x3B, 0x81, 0x77, 0x2B, 0x30, 0xCE, 0x05, 0x1E, 0x3D, 0x0D, 0xB7, 0x5E, 0x3D,
  0x0D, 0xB3, 0x05, 0x80, 0x27, 0x01, 0x1E, 0x3B, 0x81, 0x77, 0x2B, 0x3F, 0x07, 0x1E, 0x3B, 0x3B,
  0x3F, 0x07, 0x1E, 0x3B, 0x3B, 0x3F, 0x07, 0x1E, 0x3B, 0x81, 0x77, 0x2B, 0x3F, 0x07, 0x1E, 0x3D,
  0x0D, 0xB3, 0xF0, 0x71, 0xE3, 0xD0, 0xDB, 0x30, 0x58, 0x02, 0x78, 0x61, 0x05, 0x77, 0x77, 0x53,
  0xB8, 0x17, 0x72, 0xB7, 0x77, 0xB3, 0xB0, 0x27, 0x75, 0x02, 0xB3, 0xB0, 0xD0, 0x88, 0x09, 0x57,
  0x08, 0x0D, 0xB3, 0x0B, 0xFF, 0xFC, 0x0B, 0x30, 0x30, 0xEF, 0xFF, 0xA0, 0xE0, 0x34, 0x01, 0x06,
  0x80, 0xA1, 0x70, 0x60, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_developer_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_developer_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_device_hub 36x36, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_round_36_hardware_device_hub_data[] PROGMEM = {
  0x75, 0x82, 0x37, 0x73, 0x77, 0x72, 0x0B, 0xC0, 0xA7, 0x77, 0x0A, 0xE0, 0xA7, 0x75, 0x03, 0xF9,
  0x02, 0x77, 0x40, 0x6F, 0x90, 0x67, 0x74, 0x06, 0xF9, 0x06, 0x77, 0x40, 0x3F, 0x90, 0x27, 0x75,
  0x0A, 0xE0, 0xA7, 0x77, 0x0A, 0xC0, 0xA7, 0x77, 0x20, 0x8A, 0x08, 0x77, 0x73, 0x07, 0xA0, 0x77,
  0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x72, 0x01,
  0x0D, 0xA0, 0xD0, 0x17, 0x77, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x75, 0x01, 0x0D, 0xA0, 0x0E, 0xA0,
  0xD0, 0x17, 0x73, 0x01, 0x0D, 0xA8, 0x2E, 0x33, 0xEA, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xDA, 0x0E,
  0x03, 0x20, 0x30, 0xEA, 0x0D, 0x01, 0x76, 0x01, 0x0D, 0xB0, 0x44, 0x04, 0xB0, 0xD0, 0x16, 0x02,
  0x0D, 0xF9, 0x05, 0x60, 0x5F, 0x98, 0x1D, 0x27, 0xF9, 0x05, 0x71, 0x05, 0xF9, 0x00, 0x7F, 0x06,
  0x73, 0x06, 0xF0, 0x07, 0xF7, 0x5F, 0x00, 0x7F, 0x75, 0xF0, 0x07, 0xF7, 0x5F, 0x07, 0x05, 0xE0,
  0xD7, 0x50, 0xDE, 0x81, 0x50, 0x58, 0x01, 0x70, 0x27, 0x50, 0x28, 0x01, 0x70, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_device_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_device_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_devices_other 36x36, 4-bit Alpha,  RLE, 238 bytes.
static const unsigned char ic_round_36_hardware_devices_other_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0xD0, 0xD0, 0x23, 0x01, 0x0E, 0xFF, 0xFF, 0x06, 0x30, 0x6F, 0xFF, 0xF0,
  0xD0, 0x23, 0x07, 0xA0, 0xD0, 0x27, 0x77, 0x71, 0x07, 0xA0, 0x87, 0x77, 0x72, 0x07, 0xA0, 0x77,
  0x77, 0x72, 0x07, 0xA0, 0x77, 0x73, 0x01, 0x0C, 0xFA, 0x81, 0xC1, 0x7A, 0x07, 0x77, 0x30, 0x7F,
  0xC0, 0x07, 0xA0, 0x77, 0x73, 0x07, 0xFC, 0x00, 0x7A, 0x07, 0x77, 0x30, 0x7A, 0x07, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x30, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x30, 0x7A, 0x07,
  0x50, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x02, 0x0D, 0xB0, 0xD0, 0x22, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x10, 0x7D, 0x07, 0x20, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x08,
  0xD0, 0x82, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x03, 0xA8, 0x1E, 0xCE, 0xA8, 0x13,
  0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x89, 0x1B, 0xFC, 0x10, 0x1C, 0xFB, 0x07, 0xA0,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x81, 0xEF, 0x53, 0x83, 0x5F, 0xE0, 0x7A, 0x07, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x78, 0x1E, 0xF5, 0x38, 0x35, 0xFE, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0,
  0x87, 0x89, 0x1B, 0xFC, 0x10, 0x1C, 0xFB, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0xD0, 0x26,
  0x03, 0xA8, 0x1E, 0xCE, 0xA8, 0x13, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x70, 0x6F, 0x0D, 0x02, 0x20,
  0x8D, 0x08, 0x20, 0x7F, 0xC8, 0x17, 0x1E, 0xF0, 0x62, 0x07, 0xD0, 0x72, 0x07, 0xFC, 0x82, 0x70,
  0x3B, 0xD0, 0xD0, 0x22, 0x02, 0x0D, 0xB0, 0xD0, 0x22, 0x01, 0x0C, 0xFA, 0x0C, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_devices_other() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 34, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_devices_other_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_device_unknown 36x36, 4-bit Alpha,  RLE, 221 bytes.
static const unsigned char ic_round_36_hardware_device_unknown_data[] PROGMEM = {
  0x20, 0x48, 0x09, 0x47, 0x04, 0x30, 0x9F, 0xFC, 0x81, 0x90, 0x4F, 0xFE, 0x04, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xA0, 0xB8, 0x09, 0x27, 0x0B, 0xA0, 0x07, 0xA0, 0x77,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x84, 0x39, 0xDD, 0x94, 0x40,
  0x7A, 0x00, 0x7A, 0x07, 0x30, 0x7E, 0x08, 0x30, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x5B, 0x00, 0xBB,
  0x05, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x28, 0x2D, 0xFE, 0x32, 0x82, 0x3E, 0xFD, 0x20, 0x7A, 0x00,
  0x7A, 0x07, 0x28, 0x1D, 0xF7, 0x40, 0x8A, 0x81, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x10, 0x35,
  0x06, 0xA8, 0x13, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x20, 0xCA, 0x81, 0x10, 0x7A, 0x00, 0x7A, 0x07,
  0x71, 0x0A, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x76, 0x01, 0x0C, 0xA0, 0x93, 0x07, 0xA0, 0x07,
  0xA0, 0x76, 0x0A, 0xA0, 0x84, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x01, 0xA0, 0xC5, 0x07, 0xA0, 0x07,
  0xA0, 0x75, 0x04, 0xA0, 0x65, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77,
  0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x0B, 0x80, 0x92, 0x70, 0xBA, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x07,
  0x04, 0xFF, 0xE8, 0x14, 0x09, 0xFF, 0xC0, 0x93, 0x04, 0x80, 0x94, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_device_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_device_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_dock 36x36, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_36_hardware_dock_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x09, 0x07, 0x83, 0x51, 0x03, 0xEF, 0xF8, 0x1E, 0x3B, 0xFF, 0xA0, 0xB8, 0x0E,
  0x5F, 0x80, 0x90, 0x7E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E,
  0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x80, 0x90, 0x78, 0x0E, 0x5F, 0x0B, 0xFF,
  0xA8, 0x1B, 0x3E, 0xFF, 0x83, 0xE3, 0x01, 0x68, 0x09, 0x07, 0x06, 0x01, 0x80, 0xC4, 0x00, 0x28,
  0x06, 0x70, 0x26, 0x0D, 0xFB, 0x0D, 0x60, 0xDF, 0xB0, 0xD6, 0x02, 0x80, 0x67, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_dock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 1, 26, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_dock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_earbuds_battery 36x36, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_round_36_hardware_earbuds_battery_data[] PROGMEM = {
  0x18, 0x28, 0xDD, 0x85, 0x84, 0x5B, 0xEE, 0xB4, 0x71, 0x81, 0xCF, 0xC3, 0x08, 0xC0, 0x83, 0x09,
  0xE0, 0x74, 0x81, 0x27, 0x7B, 0x82, 0x77, 0x2D, 0xC0, 0xD2, 0x06, 0xA8, 0x2B, 0x55, 0xBA, 0x04,
  0x30, 0xDF, 0x0D, 0xD0, 0xD2, 0x81, 0xDF, 0xA4, 0x81, 0xBF, 0xB3, 0xFF, 0x81, 0x80, 0x1A, 0x03,
  0x48, 0x15, 0xFE, 0x3F, 0xC8, 0x1E, 0xD8, 0x20, 0x1A, 0x02, 0x40, 0x3A, 0x3F, 0xC0, 0x34, 0x01,
  0xA0, 0x24, 0x03, 0xA3, 0xFC, 0x03, 0x40, 0x1A, 0x02, 0x40, 0x3A, 0x3F, 0xC0, 0x34, 0x01, 0xA0,
  0x24, 0x03, 0xA3, 0xFC, 0x03, 0x40, 0x1A, 0x02, 0x40, 0x3A, 0x3F, 0xC0, 0x34, 0x01, 0xA0, 0x24,
  0x03, 0xA3, 0xFC, 0x03, 0x40, 0x1A, 0x02, 0x40, 0x3A, 0x3F, 0xC0, 0x34, 0x01, 0xA0, 0x22, 0x81,
  0x8D, 0xEA, 0x3F, 0xA8, 0x1E, 0xF5, 0x40, 0x3A, 0x81, 0x10, 0x8D, 0x3F, 0xA8, 0x1B, 0xFB, 0x48,
  0x1A, 0xFD, 0x20, 0xDD, 0x3F, 0xA0, 0x4A, 0x82, 0xB5, 0x4A, 0xA0, 0x62, 0x0D, 0xC0, 0xD3, 0xFA,
  0x10, 0x7E, 0x09, 0x30, 0x8C, 0x08, 0x3F, 0xA2, 0x84, 0x4B, 0xEE, 0xB5, 0x58, 0x28, 0xDD, 0x84,
  0x08, 0xF0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_earbuds_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 9, 32, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_earbuds_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_earbuds 36x36, 4-bit Alpha,  RLE, 259 bytes.
static const unsigned char ic_round_36_hardware_earbuds_data[] PROGMEM = {
  0x38, 0x22, 0x76, 0x27, 0x48, 0x25, 0x77, 0x57, 0x10, 0x9C, 0x0A, 0x70, 0x10, 0x9E, 0x09, 0x01,
  0x40, 0x9E, 0x0A, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x22, 0x02, 0xF9, 0x03, 0x30, 0x10, 0xDB, 0x82,
  0xC9, 0x9C, 0xB8, 0x2D, 0x10, 0x6F, 0x90, 0x63, 0x09, 0xA0, 0xE0, 0x54, 0x05, 0x0E, 0xA8, 0x19,
  0x07, 0xF9, 0x06, 0x3B, 0x05, 0x60, 0x5B, 0x10, 0x7F, 0x90, 0x22, 0x05, 0xA0, 0xC7, 0x10, 0xCA,
  0x05, 0x07, 0xF0, 0x93, 0x06, 0xA0, 0x97, 0x10, 0x9A, 0x06, 0x07, 0xE0, 0x94, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x00, 0x7A, 0x82, 0xB7, 0x52, 0x50, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07,
  0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x58, 0x22, 0x57, 0xBA, 0x00,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x74, 0x09, 0xE0, 0x70, 0x6A, 0x09, 0x71, 0x09, 0xA0, 0x63, 0x09,
  0xF0, 0x70, 0x5A, 0x0C, 0x71, 0x0C, 0xA0, 0x52, 0x02, 0xF9, 0x07, 0x1B, 0x05, 0x60, 0x5B, 0x30,
  0x6F, 0x98, 0x17, 0x09, 0xA0, 0xE0, 0x54, 0x05, 0x0E, 0xA0, 0x93, 0x06, 0xF9, 0x82, 0x60, 0x1D,
  0xB8, 0x2C, 0x99, 0xCB, 0x0D, 0x01, 0x30, 0x3F, 0x90, 0x22, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x50,
  0xAE, 0x09, 0x40, 0x10, 0x9E, 0x09, 0x01, 0x70, 0xAC, 0x09, 0x71, 0x82, 0x57, 0x75, 0x74, 0x82,
  0x26, 0x73, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_earbuds() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_earbuds_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_gamepad 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_round_36_hardware_gamepad_data[] PROGMEM = {
  0x73, 0x02, 0x0D, 0xE0, 0xD0, 0x27, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76,
  0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90,
  0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x30, 0xEF, 0x03, 0x77, 0x70, 0x40, 0xED, 0x04, 0x74,
  0x02, 0x80, 0x37, 0x03, 0x30, 0x40, 0xEB, 0x04, 0x30, 0x38, 0x03, 0x70, 0x20, 0xDF, 0x90, 0x43,
  0x82, 0x4E, 0xF4, 0x30, 0x4F, 0x90, 0xDF, 0xB0, 0x43, 0x02, 0x03, 0x30, 0x4F, 0xFF, 0x04, 0x60,
  0x4F, 0xFF, 0xA0, 0x34, 0x03, 0xFF, 0xFA, 0x0E, 0x02, 0x40, 0x3F, 0xFF, 0x90, 0xE0, 0x46, 0x04,
  0xFF, 0xE0, 0xE0, 0x43, 0x03, 0x02, 0x30, 0x4F, 0xB0, 0xDF, 0x0E, 0x04, 0x38, 0x24, 0xFE, 0x43,
  0x04, 0xF9, 0x0D, 0x02, 0x80, 0x37, 0x03, 0x30, 0x4B, 0x0E, 0x04, 0x30, 0x38, 0x03, 0x70, 0x27,
  0x40, 0x4D, 0x0E, 0x04, 0x77, 0x70, 0x3F, 0x0E, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07,
  0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77,
  0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x02, 0x0D, 0xE0, 0xD0, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_gamepad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_gamepad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_headphones_battery 36x36, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_round_36_hardware_headphones_battery_data[] PROGMEM = {
  0x58, 0x64, 0x9D, 0xEE, 0xD9, 0x47, 0x48, 0x1C, 0xFC, 0x60, 0x20, 0xBF, 0x90, 0xB0, 0x26, 0x81,
  0x27, 0x7B, 0x81, 0x77, 0x22, 0x03, 0x0E, 0xA8, 0x4B, 0x64, 0x46, 0xBA, 0x0E, 0x03, 0x50, 0xDF,
  0x85, 0xD0, 0x2E, 0xFD, 0x46, 0x83, 0x4D, 0xFE, 0x24, 0xFA, 0x18, 0x2B, 0xFD, 0x17, 0x18, 0x21,
  0xDF, 0xB4, 0xFA, 0x04, 0xA0, 0x47, 0x30, 0x4A, 0x04, 0x3F, 0xA8, 0x19, 0xFB, 0x75, 0x81, 0xBF,
  0x93, 0xFA, 0x81, 0xDF, 0x67, 0x58, 0x16, 0xFD, 0x3F, 0xA8, 0x1E, 0xF4, 0x75, 0x81, 0x4F, 0xE3,
  0xFC, 0x03, 0x75, 0x03, 0xA3, 0xFC, 0x81, 0x96, 0x17, 0x18, 0x11, 0x69, 0xA3, 0xFE, 0x0E, 0x03,
  0x60, 0x30, 0xEC, 0x3F, 0xF0, 0xB6, 0x0B, 0xD3, 0xFF, 0x96, 0xE3, 0xFF, 0x96, 0xE3, 0xFA, 0x0D,
  0xC0, 0xD6, 0x0D, 0xC0, 0xD3, 0xFA, 0x08, 0xC0, 0x86, 0x08, 0xC0, 0x83, 0xFA, 0x18, 0x28, 0xDD,
  0x87, 0x18, 0x28, 0xDD, 0x84, 0x08, 0xF0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_headphones_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 9, 32, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_headphones_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_headphones 36x36, 4-bit Alpha,  RLE, 196 bytes.
static const unsigned char ic_round_36_hardware_headphones_data[] PROGMEM = {
  0x74, 0x84, 0x35, 0x77, 0x53, 0x77, 0x58, 0x14, 0xAE, 0xE8, 0x1E, 0xA4, 0x77, 0x03, 0x0B, 0xFD,
  0x0B, 0x03, 0x74, 0x06, 0xD8, 0x4D, 0x98, 0x89, 0xDD, 0x06, 0x72, 0x08, 0xC0, 0x80, 0x26, 0x02,
  0x08, 0xC0, 0x87, 0x06, 0xB0, 0xC0, 0x17, 0x30, 0x10, 0xCB, 0x06, 0x50, 0x3B, 0x0A, 0x77, 0x0A,
  0xB0, 0x34, 0x0B, 0xA0, 0xC7, 0x72, 0x0C, 0xA0, 0xB3, 0x04, 0xB0, 0x17, 0x72, 0x01, 0xB0, 0x42,
  0x0A, 0xA0, 0x87, 0x74, 0x08, 0xA0, 0xA2, 0x0E, 0xA0, 0x27, 0x74, 0x02, 0xA8, 0x1E, 0x03, 0xA0,
  0xC7, 0x76, 0x0C, 0xA0, 0x30, 0x5A, 0x0A, 0x77, 0x60, 0xAA, 0x05, 0x06, 0xA0, 0x87, 0x76, 0x08,
  0xA0, 0x60, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x00, 0x7A, 0x83, 0xB7, 0x77, 0x47, 0x58, 0x34, 0x77,
  0x7B, 0xA0, 0x07, 0xF0, 0x97, 0x30, 0x9F, 0x00, 0x7F, 0x90, 0x47, 0x10, 0x4F, 0x90, 0x07, 0xF9,
  0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07,
  0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F,
  0x90, 0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x07, 0x04, 0xF9, 0x04, 0x71,
  0x04, 0xF9, 0x81, 0x40, 0x9E, 0x09, 0x73, 0x09, 0xE0, 0x93, 0x84, 0x47, 0x77, 0x74, 0x75, 0x84,
  0x47, 0x77, 0x74, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_headphones() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_headphones_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_headset_mic 36x36, 4-bit Alpha,  RLE, 233 bytes.
static const unsigned char ic_round_36_hardware_headset_mic_data[] PROGMEM = {
  0x74, 0x84, 0x35, 0x75, 0x53, 0x77, 0x50, 0x30, 0xAF, 0x81, 0xEA, 0x47, 0x70, 0x20, 0xBF, 0xD0,
  0xB0, 0x37, 0x40, 0x50, 0xEC, 0x84, 0xCA, 0x88, 0x9D, 0xD0, 0x67, 0x20, 0x6C, 0x09, 0x02, 0x60,
  0x20, 0x8C, 0x08, 0x70, 0x4B, 0x0C, 0x02, 0x73, 0x01, 0x0C, 0xB0, 0x65, 0x01, 0x0E, 0xA0, 0xC0,
  0x17, 0x60, 0xAB, 0x03, 0x40, 0x9A, 0x0D, 0x01, 0x77, 0x10, 0xCA, 0x0B, 0x30, 0x2B, 0x03, 0x77,
  0x20, 0x1B, 0x04, 0x20, 0x9A, 0x0A, 0x77, 0x40, 0x8A, 0x0A, 0x20, 0xDA, 0x03, 0x77, 0x40, 0x2A,
  0x81, 0xE0, 0x2A, 0x0E, 0x77, 0x60, 0xCA, 0x03, 0x04, 0xA0, 0xA7, 0x76, 0x0A, 0xA0, 0x50, 0x6A,
  0x09, 0x77, 0x60, 0x8A, 0x06, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xE0, 0xB0, 0x37, 0x30, 0x30, 0xBE, 0x00, 0x7F,
  0x0E, 0x01, 0x71, 0x01, 0x0E, 0xF0, 0x07, 0xF9, 0x06, 0x71, 0x06, 0xF9, 0x00, 0x7F, 0x90, 0x77,
  0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90,
  0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x70, 0x4F, 0x90,
  0x77, 0x10, 0x7F, 0x98, 0x17, 0x0E, 0xF0, 0x67, 0x10, 0x6F, 0x98, 0x17, 0x04, 0xE0, 0xE0, 0x17,
  0x10, 0x10, 0xEF, 0x07, 0x28, 0x12, 0xAD, 0xA0, 0xB0, 0x37, 0x30, 0x30, 0xBE, 0x07, 0x77, 0x73,
  0x07, 0xA0, 0x67, 0x70, 0x28, 0x05, 0x70, 0xBA, 0x02, 0x77, 0x0D, 0xFC, 0x09, 0x77, 0x10, 0xDF,
  0xB0, 0xA7, 0x72, 0x02, 0x80, 0x47, 0x06, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_headset_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_headset_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_headset_off 36x36, 4-bit Alpha,  RLE, 281 bytes.
static const unsigned char ic_round_36_hardware_headset_off_data[] PROGMEM = {
  0x10, 0x10, 0x27, 0x28, 0x90, 0x37, 0xBD, 0xFE, 0xDB, 0x72, 0x73, 0x82, 0x1E, 0xF7, 0x60, 0x40,
  0xCF, 0xB0, 0xC0, 0x47, 0x10, 0x4B, 0x07, 0x40, 0x9F, 0xF0, 0xA7, 0x10, 0xBB, 0x07, 0x30, 0x4A,
  0x82, 0xE9, 0x52, 0x28, 0x22, 0x59, 0xEB, 0x0D, 0x02, 0x70, 0xBB, 0x07, 0x38, 0x14, 0x91, 0x71,
  0x01, 0x09, 0xB0, 0xD0, 0x17, 0x0B, 0xB0, 0x77, 0x71, 0x04, 0x0E, 0xA0, 0xC7, 0x10, 0xBB, 0x07,
  0x77, 0x10, 0x3B, 0x07, 0x70, 0x1C, 0x07, 0x77, 0x10, 0x6A, 0x0E, 0x01, 0x60, 0x8D, 0x07, 0x77,
  0x10, 0xCA, 0x07, 0x60, 0xDA, 0x0D, 0xB0, 0x77, 0x70, 0x4A, 0x0C, 0x50, 0x2A, 0x81, 0xE0, 0xBB,
  0x07, 0x77, 0x0E, 0xA0, 0x24, 0x05, 0xA0, 0xB2, 0x0B, 0xB0, 0x77, 0x60, 0xBA, 0x04, 0x40, 0x6A,
  0x09, 0x30, 0xBB, 0x07, 0x75, 0x09, 0xA0, 0x64, 0x07, 0xA0, 0x74, 0x0B, 0xB0, 0x77, 0x40, 0x7A,
  0x07, 0x40, 0x7A, 0x07, 0x50, 0xBB, 0x07, 0x73, 0x07, 0xA0, 0x74, 0x07, 0xE8, 0x2B, 0x30, 0xBB,
  0x07, 0x40, 0x20, 0xBE, 0x07, 0x40, 0x7F, 0x82, 0xE1, 0x0B, 0xB0, 0x73, 0x04, 0xF0, 0x74, 0x07,
  0xF9, 0x06, 0x20, 0xBB, 0x07, 0x30, 0x4E, 0x07, 0x40, 0x7F, 0x90, 0x73, 0x0B, 0xB0, 0x73, 0x04,
  0xD0, 0x74, 0x07, 0xF9, 0x07, 0x40, 0xBB, 0x07, 0x30, 0x4C, 0x07, 0x40, 0x7F, 0x90, 0x75, 0x0B,
  0xB0, 0x73, 0x04, 0xB0, 0x74, 0x07, 0xF9, 0x07, 0x60, 0xBB, 0x07, 0x30, 0x4A, 0x07, 0x40, 0x7F,
  0x90, 0x77, 0x0B, 0xB0, 0x73, 0x81, 0x4F, 0x74, 0x07, 0xF9, 0x07, 0x71, 0x0B, 0xB0, 0x73, 0x04,
  0x07, 0x40, 0x6F, 0x90, 0x67, 0x10, 0x6C, 0x07, 0x71, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x10, 0x10,
  0xEC, 0x07, 0x71, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x30, 0x30, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xB0,
  0x77, 0x75, 0x02, 0x80, 0x37, 0x08, 0xC0, 0x77, 0x74, 0x0D, 0xFE, 0x02, 0x77, 0x30, 0xDF, 0xD0,
  0xE0, 0x17, 0x73, 0x02, 0x80, 0x67, 0x81, 0x43, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_headset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 32, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_headset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_headset 36x36, 4-bit Alpha,  RLE, 208 bytes.
static const unsigned char ic_round_36_hardware_headset_data[] PROGMEM = {
  0x74, 0x84, 0x35, 0x75, 0x53, 0x77, 0x50, 0x30, 0xAF, 0x81, 0xEA, 0x47, 0x70, 0x20, 0xBF, 0xD0,
  0xB0, 0x37, 0x40, 0x50, 0xEC, 0x84, 0xCA, 0x88, 0x9D, 0xD0, 0x67, 0x20, 0x6C, 0x09, 0x02, 0x60,
  0x20, 0x8C, 0x08, 0x70, 0x4B, 0x0C, 0x02, 0x73, 0x01, 0x0C, 0xB0, 0x65, 0x01, 0x0E, 0xA0, 0xC0,
  0x17, 0x60, 0xAB, 0x03, 0x40, 0x9A, 0x0D, 0x01, 0x77, 0x10, 0xCA, 0x0B, 0x30, 0x2B, 0x03, 0x77,
  0x20, 0x1B, 0x04, 0x20, 0x9A, 0x0A, 0x77, 0x40, 0x8A, 0x0A, 0x20, 0xDA, 0x03, 0x77, 0x40, 0x2A,
  0x81, 0xE0, 0x2A, 0x0E, 0x77, 0x60, 0xCA, 0x03, 0x04, 0xA0, 0xA7, 0x76, 0x0A, 0xA0, 0x50, 0x6A,
  0x09, 0x77, 0x60, 0x8A, 0x06, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xE0, 0xB0, 0x37, 0x30, 0x30, 0xBE, 0x00, 0x7F,
  0x0E, 0x01, 0x71, 0x01, 0x0E, 0xF0, 0x07, 0xF9, 0x06, 0x71, 0x06, 0xF9, 0x00, 0x7F, 0x90, 0x77,
  0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90,
  0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x70, 0x4F, 0x90,
  0x77, 0x10, 0x7F, 0x98, 0x14, 0x0E, 0xF0, 0x67, 0x10, 0x6F, 0x0E, 0x20, 0x4E, 0x0E, 0x01, 0x71,
  0x01, 0x0E, 0xE0, 0x43, 0x81, 0x2A, 0xDA, 0x0B, 0x03, 0x73, 0x03, 0x0B, 0xA8, 0x1D, 0xA2, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_headset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_headset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_home_max 36x36, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_round_36_hardware_home_max_data[] PROGMEM = {
  0x40, 0x20, 0x58, 0x0A, 0x27, 0x05, 0x02, 0x60, 0x10, 0xAF, 0xFF, 0xD0, 0xA0, 0x13, 0x01, 0x0D,
  0xFF, 0xFF, 0x0D, 0x01, 0x20, 0xAB, 0x0B, 0x08, 0x80, 0xA0, 0x70, 0x80, 0xBB, 0x81, 0xA0, 0x2B,
  0x05, 0x77, 0x73, 0x05, 0xB0, 0x20, 0x6A, 0x0B, 0x77, 0x75, 0x0B, 0xA0, 0x60, 0x7A, 0x08, 0x77,
  0x75, 0x08, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x07, 0x06, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x06, 0x04, 0xA0, 0xD0, 0x17, 0x77, 0x30, 0x10, 0xDA,
  0x81, 0x40, 0xDA, 0x0C, 0x03, 0x77, 0x71, 0x03, 0x0C, 0xA0, 0xD2, 0x05, 0xFF, 0xFF, 0xA0, 0x53,
  0x06, 0xFF, 0xFF, 0x06, 0x58, 0x12, 0x9D, 0xFF, 0xF9, 0x81, 0xD9, 0x27, 0x50, 0x5F, 0xF0, 0x57,
  0x75, 0x05, 0x80, 0x90, 0x70, 0x57, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_home_max() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 28), Box(0, 0, 35, 35),
      ic_round_36_hardware_home_max_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_home_mini 36x36, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_round_36_hardware_home_mini_data[] PROGMEM = {
  0x73, 0x89, 0x01, 0x35, 0x77, 0x76, 0x54, 0x17, 0x73, 0x81, 0x49, 0xDF, 0xB8, 0x1E, 0xA4, 0x75,
  0x05, 0x0D, 0xFF, 0xA0, 0xD0, 0x67, 0x10, 0x10, 0xBD, 0x89, 0x0E, 0xB9, 0x87, 0x78, 0x9B, 0xED,
  0x0C, 0x01, 0x50, 0x10, 0xDB, 0x81, 0xD7, 0x27, 0x38, 0x12, 0x7D, 0xB0, 0xD0, 0x23, 0x01, 0x0C,
  0xB0, 0x77, 0x72, 0x07, 0xB0, 0xD3, 0x09, 0xA0, 0xE0, 0x47, 0x74, 0x04, 0x0E, 0xA8, 0x18, 0x02,
  0xB0, 0x47, 0x76, 0x05, 0xB0, 0x10, 0x8A, 0x0A, 0x77, 0x71, 0x0B, 0xA0, 0x70, 0xCA, 0x04, 0x77,
  0x71, 0x04, 0xA0, 0xC0, 0xEA, 0x77, 0x73, 0xA0, 0x0E, 0xFF, 0xFF, 0x90, 0xDF, 0xFF, 0xF0, 0xD0,
  0xAF, 0xFF, 0xF0, 0xB0, 0x5A, 0x0D, 0x01, 0x77, 0x70, 0xDA, 0x81, 0x50, 0xEA, 0x09, 0x77, 0x60,
  0x9A, 0x0E, 0x20, 0x6B, 0x08, 0x77, 0x40, 0x8B, 0x06, 0x30, 0xAB, 0x0B, 0x04, 0x77, 0x04, 0x0B,
  0xB0, 0xB5, 0x0B, 0xC8, 0x1D, 0xA8, 0x80, 0x47, 0x81, 0x8A, 0xDC, 0x0B, 0x70, 0x9F, 0xFE, 0x08,
  0x72, 0x02, 0x0A, 0xFF, 0x98, 0x1E, 0x92, 0x76, 0x04, 0x06, 0x80, 0x67, 0x06, 0x03, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_home_mini() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 32, 28), Box(0, 0, 35, 35),
      ic_round_36_hardware_home_mini_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_alt 36x36, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_round_36_hardware_keyboard_alt_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0xF8, 0x3B, 0x30, 0x1E, 0xFF, 0xFF, 0xA8, 0x1E, 0x16, 0xFF, 0xFF, 0xC0,
  0x60, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7D, 0x07, 0x20,
  0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x00, 0x7D, 0x07, 0x20, 0x7A, 0x07,
  0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x00, 0x7D, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A,
  0x07, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F,
  0xFF, 0xFC, 0x00, 0x7D, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7D,
  0x00, 0x7D, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x00, 0x7D,
  0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x00, 0x7F, 0xFF, 0xFC,
  0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xB0, 0x27, 0x30, 0x2F, 0xB0, 0x07,
  0xFB, 0x0A, 0x80, 0x67, 0x0A, 0xFB, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F,
  0xFF, 0xFC, 0x07, 0x04, 0xFF, 0xFF, 0xC8, 0x14, 0x09, 0xFF, 0xFF, 0xA0, 0x93, 0x04, 0x80, 0xB0,
  0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_arrow_down 36x36, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_36_hardware_keyboard_arrow_down_data[] PROGMEM = {
  0x10, 0x40, 0x67, 0x58, 0x26, 0x40, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xB0, 0xB7, 0x10, 0xBB,
  0x81, 0x30, 0x7B, 0x0B, 0x60, 0xBB, 0x07, 0x30, 0x7B, 0x0B, 0x40, 0xBB, 0x07, 0x50, 0x7B, 0x0B,
  0x20, 0xBB, 0x07, 0x70, 0x7B, 0x00, 0xBB, 0x07, 0x72, 0x07, 0xE0, 0x77, 0x40, 0x7C, 0x07, 0x76,
  0x07, 0xA0, 0x77, 0x71, 0x00, 0x37, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 13, 26, 23), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_arrow_left 36x36, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_36_hardware_keyboard_arrow_left_data[] PROGMEM = {
  0x71, 0x00, 0x37, 0x10, 0x7A, 0x04, 0x60, 0x7B, 0x06, 0x50, 0x7B, 0x0B, 0x50, 0x7B, 0x0B, 0x50,
  0x7B, 0x0B, 0x50, 0x7B, 0x0B, 0x50, 0x7B, 0x0B, 0x50, 0x3B, 0x0B, 0x60, 0x3B, 0x0B, 0x70, 0x7B,
  0x0B, 0x70, 0x7B, 0x0B, 0x70, 0x7B, 0x0B, 0x70, 0x7B, 0x0B, 0x70, 0x7B, 0x0B, 0x70, 0x7B, 0x06,
  0x70, 0x7A, 0x04, 0x71, 0x00, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 9, 22, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_arrow_right 36x36, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_36_hardware_keyboard_arrow_right_data[] PROGMEM = {
  0x10, 0x03, 0x71, 0x04, 0xA0, 0x77, 0x06, 0xB0, 0x77, 0x0B, 0xB0, 0x77, 0x0B, 0xB0, 0x77, 0x0B,
  0xB0, 0x77, 0x0B, 0xB0, 0x77, 0x0B, 0xB0, 0x77, 0x0B, 0xB0, 0x36, 0x0B, 0xB0, 0x35, 0x0B, 0xB0,
  0x75, 0x0B, 0xB0, 0x75, 0x0B, 0xB0, 0x75, 0x0B, 0xB0, 0x75, 0x0B, 0xB0, 0x75, 0x06, 0xB0, 0x76,
  0x04, 0xA0, 0x77, 0x10, 0x03, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(13, 9, 23, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_arrow_up 36x36, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_36_hardware_keyboard_arrow_up_data[] PROGMEM = {
  0x71, 0x00, 0x37, 0x71, 0x07, 0xA0, 0x77, 0x60, 0x7C, 0x07, 0x74, 0x07, 0xE0, 0x77, 0x20, 0x7B,
  0x00, 0xBB, 0x07, 0x70, 0x7B, 0x0B, 0x20, 0xBB, 0x07, 0x50, 0x7B, 0x0B, 0x40, 0xBB, 0x07, 0x30,
  0x7B, 0x0B, 0x60, 0xBB, 0x81, 0x70, 0x3B, 0x0B, 0x71, 0x0B, 0xB0, 0x03, 0xA0, 0xB7, 0x30, 0xBA,
  0x82, 0x30, 0x46, 0x75, 0x06, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 12, 26, 22), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_backspace 36x36, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_36_hardware_keyboard_backspace_data[] PROGMEM = {
  0x78, 0x11, 0x51, 0x77, 0x72, 0x82, 0x1D, 0xFC, 0x77, 0x71, 0x01, 0x0D, 0xA0, 0xD7, 0x77, 0x01,
  0x0D, 0xB0, 0x47, 0x76, 0x01, 0x0D, 0xB0, 0x47, 0x76, 0x01, 0x0D, 0xB0, 0x47, 0x76, 0x01, 0x0D,
  0xB0, 0x47, 0x76, 0x01, 0x0D, 0xB0, 0xB8, 0x09, 0x77, 0x81, 0x50, 0xBF, 0xFF, 0xC0, 0x50, 0xBF,
  0xFF, 0xC8, 0x15, 0x1D, 0xB0, 0xB8, 0x09, 0x77, 0x05, 0x20, 0x10, 0xDA, 0x0E, 0x04, 0x77, 0x71,
  0x01, 0x0D, 0xA0, 0xE0, 0x47, 0x77, 0x10, 0x10, 0xDA, 0x0E, 0x04, 0x77, 0x71, 0x01, 0x0D, 0xA0,
  0xE0, 0x47, 0x77, 0x10, 0x10, 0xDA, 0x0D, 0x77, 0x72, 0x82, 0x1D, 0xFC, 0x77, 0x73, 0x81, 0x15,
  0x17, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_backspace() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 9, 31, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_backspace_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_capslock 36x36, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_36_hardware_keyboard_capslock_data[] PROGMEM = {
  0x78, 0x22, 0xDD, 0x27, 0x60, 0x20, 0xEA, 0x0E, 0x02, 0x74, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x20,
  0x20, 0xEA, 0x00, 0xEA, 0x0E, 0x02, 0x70, 0x20, 0xEA, 0x82, 0xE2, 0x2E, 0xA0, 0xE0, 0x25, 0x02,
  0x0E, 0xA0, 0xE0, 0x22, 0x02, 0x0E, 0xA0, 0xE0, 0x23, 0x02, 0x0E, 0xA0, 0xE0, 0x24, 0x02, 0x0E,
  0xA8, 0x3E, 0x20, 0x1E, 0xA0, 0xE0, 0x26, 0x02, 0x0E, 0xA8, 0x1E, 0x15, 0xA0, 0xE0, 0x27, 0x10,
  0x20, 0xEA, 0x83, 0x50, 0xAC, 0x27, 0x38, 0x12, 0xCA, 0x80, 0x9A, 0x70, 0x08, 0xFF, 0xA0, 0x80,
  0xEF, 0xFA, 0x0E, 0x08, 0xFF, 0xA0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_capslock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 9, 26, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_capslock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_command_key 36x36, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_36_hardware_keyboard_command_key_data[] PROGMEM = {
  0x48, 0x24, 0x76, 0x27, 0x58, 0x22, 0x67, 0x46, 0x05, 0x0E, 0xC0, 0xA0, 0x17, 0x10, 0x10, 0xAC,
  0x0E, 0x05, 0x30, 0x5F, 0x0C, 0x71, 0x0C, 0xF0, 0x52, 0x0E, 0xA8, 0x1D, 0x8A, 0xB0, 0x76, 0x07,
  0xB8, 0x1A, 0x8D, 0xA8, 0x1E, 0x05, 0xA0, 0xD3, 0x06, 0xA0, 0xC6, 0x0C, 0xA0, 0x63, 0x0D, 0xA0,
  0x50, 0x7A, 0x08, 0x4B, 0x6B, 0x40, 0x8A, 0x07, 0x06, 0xA0, 0xA4, 0xB6, 0xB4, 0x0A, 0xA0, 0x60,
  0x2B, 0x06, 0x3B, 0x6B, 0x30, 0x6B, 0x81, 0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x01, 0x0C, 0xFF, 0xF9,
  0x0C, 0x01, 0x40, 0x70, 0xCF, 0xFC, 0x0C, 0x07, 0x74, 0xB6, 0xB7, 0x72, 0xB6, 0xB7, 0x72, 0xB6,
  0xB7, 0x72, 0xB6, 0xB7, 0x72, 0xB6, 0xB7, 0x72, 0xB6, 0xB7, 0x40, 0x70, 0xCF, 0xFC, 0x0C, 0x07,
  0x40, 0x10, 0xCF, 0xFF, 0x90, 0xC0, 0x12, 0x0A, 0xFF, 0xFB, 0x81, 0xA0, 0x2B, 0x06, 0x3B, 0x6B,
  0x30, 0x6B, 0x02, 0x06, 0xA0, 0xA4, 0xB6, 0xB4, 0x0A, 0xA0, 0x60, 0x7A, 0x08, 0x4B, 0x6B, 0x40,
  0x8A, 0x07, 0x05, 0xA0, 0xD3, 0x06, 0xA0, 0xC6, 0x0C, 0xA0, 0x63, 0x0D, 0xA8, 0x15, 0x0E, 0xA8,
  0x1D, 0x8A, 0xB0, 0x76, 0x07, 0xB8, 0x1A, 0x8D, 0xA0, 0xE2, 0x05, 0xF0, 0xC7, 0x10, 0xCF, 0x05,
  0x30, 0x50, 0xEC, 0x0A, 0x01, 0x71, 0x01, 0x0A, 0xC0, 0xE0, 0x56, 0x82, 0x47, 0x62, 0x75, 0x82,
  0x26, 0x74, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_command_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_command_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_control_key 36x36, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_36_hardware_keyboard_control_key_data[] PROGMEM = {
  0x71, 0x82, 0x1B, 0xB1, 0x77, 0x10, 0x10, 0xDA, 0x0D, 0x01, 0x76, 0x01, 0x0D, 0xC0, 0xD0, 0x17,
  0x40, 0x10, 0xDE, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xB0, 0x04, 0xB0, 0xD0, 0x17, 0x01, 0x0D, 0xB0,
  0x42, 0x04, 0xB0, 0xD0, 0x15, 0x01, 0x0D, 0xB0, 0x44, 0x04, 0xB0, 0xD0, 0x13, 0x01, 0x0D, 0xB0,
  0x46, 0x04, 0xB8, 0x3D, 0x10, 0x1D, 0xB0, 0x47, 0x10, 0x4B, 0x81, 0xD1, 0xBB, 0x04, 0x73, 0x04,
  0xB0, 0x0B, 0xA0, 0x47, 0x50, 0x4A, 0x82, 0xB1, 0x72, 0x77, 0x81, 0x27, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_control_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 27, 19), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_control_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_double_arrow_down 36x36, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_36_hardware_keyboard_double_arrow_down_data[] PROGMEM = {
  0x18, 0x1A, 0xC2, 0x73, 0x83, 0x2C, 0xA0, 0x5A, 0x0E, 0x02, 0x71, 0x02, 0x0E, 0xA8, 0x15, 0x1E,
  0xA0, 0xE0, 0x36, 0x03, 0x0E, 0xA8, 0x3E, 0x10, 0x2E, 0xA0, 0xE0, 0x34, 0x03, 0x0E, 0xA0, 0xE0,
  0x23, 0x02, 0x0E, 0xA0, 0xE0, 0x32, 0x03, 0x0E, 0xA0, 0xE0, 0x25, 0x02, 0x0E, 0xA8, 0x2E, 0x33,
  0xEA, 0x0E, 0x02, 0x70, 0x20, 0xEA, 0x00, 0xEA, 0x0E, 0x02, 0x72, 0x02, 0x0E, 0xC0, 0xE0, 0x27,
  0x40, 0x20, 0xEA, 0x0E, 0x02, 0x76, 0x82, 0x2D, 0xD2, 0x78, 0x21, 0xCE, 0x47, 0x38, 0x34, 0xDC,
  0x15, 0xB0, 0x47, 0x10, 0x40, 0xEA, 0x81, 0x51, 0xDB, 0x04, 0x60, 0x40, 0xEA, 0x83, 0xD1, 0x01,
  0xDB, 0x04, 0x40, 0x40, 0xEA, 0x0D, 0x01, 0x30, 0x10, 0xDB, 0x04, 0x20, 0x40, 0xEA, 0x0D, 0x01,
  0x50, 0x10, 0xDB, 0x81, 0x44, 0xEA, 0x0D, 0x01, 0x70, 0x10, 0xDE, 0x0D, 0x01, 0x72, 0x01, 0x0D,
  0xC0, 0xD0, 0x17, 0x40, 0x10, 0xDA, 0x0D, 0x01, 0x76, 0x82, 0x1B, 0xB1, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_double_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 8, 26, 27), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_double_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_double_arrow_left 36x36, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_round_36_hardware_keyboard_double_arrow_left_data[] PROGMEM = {
  0x78, 0x11, 0x51, 0x70, 0x10, 0x57, 0x82, 0x1D, 0xFC, 0x68, 0x22, 0xEF, 0xA5, 0x01, 0x0D, 0xA0,
  0xD5, 0x02, 0x0E, 0xA0, 0xC4, 0x01, 0x0D, 0xB0, 0x44, 0x02, 0x0E, 0xA0, 0xE0, 0x33, 0x01, 0x0D,
  0xB0, 0x44, 0x02, 0x0E, 0xA0, 0xE0, 0x33, 0x01, 0x0D, 0xB0, 0x44, 0x02, 0x0E, 0xA0, 0xE0, 0x33,
  0x01, 0x0D, 0xB0, 0x44, 0x02, 0x0E, 0xA0, 0xE0, 0x33, 0x01, 0x0D, 0xB0, 0x44, 0x02, 0x0E, 0xA0,
  0xE0, 0x34, 0x0B, 0xB0, 0x45, 0x0D, 0xA0, 0xE0, 0x35, 0x0B, 0xB0, 0x45, 0x0D, 0xA0, 0xE0, 0x35,
  0x01, 0x0D, 0xA0, 0xE0, 0x44, 0x02, 0x0E, 0xA0, 0xE0, 0x35, 0x01, 0x0D, 0xA0, 0xE0, 0x44, 0x02,
  0x0E, 0xA0, 0xE0, 0x35, 0x01, 0x0D, 0xA0, 0xE0, 0x44, 0x02, 0x0E, 0xA0, 0xE0, 0x35, 0x01, 0x0D,
  0xA0, 0xE0, 0x44, 0x02, 0x0E, 0xA0, 0xE0, 0x25, 0x01, 0x0D, 0xA0, 0xE0, 0x44, 0x02, 0x0E, 0xA0,
  0xE0, 0x25, 0x01, 0x0D, 0xA0, 0xD5, 0x02, 0x0E, 0xA0, 0xB6, 0x82, 0x1D, 0xFC, 0x68, 0x22, 0xEF,
  0xA7, 0x81, 0x15, 0x17, 0x01, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_double_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 9, 27, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_double_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_double_arrow_right 36x36, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_round_36_hardware_keyboard_double_arrow_right_data[] PROGMEM = {
  0x10, 0x50, 0x17, 0x81, 0x15, 0x17, 0x82, 0xAF, 0xE2, 0x68, 0x2C, 0xFD, 0x16, 0x0C, 0xA0, 0xE0,
  0x25, 0x0D, 0xA0, 0xD0, 0x15, 0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x04, 0xB0, 0xD0, 0x15, 0x03, 0x0E,
  0xA0, 0xE0, 0x24, 0x04, 0xB0, 0xD0, 0x15, 0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x04, 0xB0, 0xD0, 0x15,
  0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x04, 0xB0, 0xD0, 0x15, 0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x04, 0xB0,
  0xD0, 0x15, 0x03, 0x0E, 0xA0, 0xD5, 0x04, 0xB0, 0xB5, 0x03, 0x0E, 0xA0, 0xD5, 0x04, 0xB0, 0xB4,
  0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x04, 0xB0, 0xD0, 0x13, 0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x04, 0xB0,
  0xD0, 0x13, 0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x04, 0xB0, 0xD0, 0x13, 0x03, 0x0E, 0xA0, 0xE0, 0x24,
  0x04, 0xB0, 0xD0, 0x13, 0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x04, 0xB0, 0xD0, 0x14, 0x0C, 0xA0, 0xE0,
  0x25, 0x0D, 0xA0, 0xD0, 0x15, 0x82, 0xAF, 0xE2, 0x68, 0x2C, 0xFD, 0x17, 0x05, 0x01, 0x78, 0x11,
  0x51, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_double_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 9, 27, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_double_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_double_arrow_up 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_round_36_hardware_keyboard_double_arrow_up_data[] PROGMEM = {
  0x78, 0x21, 0xBB, 0x17, 0x60, 0x10, 0xDA, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x20,
  0x20, 0xDA, 0x0E, 0xB0, 0xD0, 0x17, 0x02, 0x0D, 0xA8, 0x1E, 0x44, 0xB0, 0xD0, 0x15, 0x02, 0x0D,
  0xA0, 0xE0, 0x42, 0x04, 0xB0, 0xD0, 0x13, 0x02, 0x0D, 0xA0, 0xE0, 0x44, 0x04, 0xB8, 0x3D, 0x10,
  0x1D, 0xA0, 0xE0, 0x46, 0x04, 0xB8, 0x1D, 0x15, 0xA0, 0xE0, 0x47, 0x10, 0x4B, 0x83, 0x51, 0xCD,
  0x37, 0x38, 0x24, 0xEC, 0x17, 0x82, 0x2D, 0xD2, 0x76, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x40, 0x30,
  0xEC, 0x0E, 0x02, 0x72, 0x03, 0x0E, 0xA0, 0x0E, 0xA0, 0xE0, 0x27, 0x03, 0x0E, 0xA8, 0x2E, 0x33,
  0xEA, 0x0E, 0x02, 0x50, 0x30, 0xEA, 0x0E, 0x03, 0x20, 0x30, 0xEA, 0x0E, 0x02, 0x30, 0x30, 0xEA,
  0x0E, 0x02, 0x40, 0x30, 0xEA, 0x83, 0xE2, 0x01, 0xEA, 0x0E, 0x02, 0x60, 0x30, 0xEA, 0x81, 0xE1,
  0x5A, 0x0E, 0x02, 0x71, 0x03, 0x0E, 0xA8, 0x35, 0x0A, 0xB2, 0x73, 0x81, 0x2C, 0xA1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_double_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 8, 26, 27), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_double_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_hide 36x36, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_round_36_hardware_keyboard_hide_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0A, 0x47, 0x83, 0x61, 0x03, 0xEF, 0xFF, 0xD8, 0x1E, 0x3B, 0xFF, 0xFF, 0x0B,
  0x0E, 0x80, 0xF3, 0xF0, 0x72, 0x07, 0x93, 0x90, 0x72, 0x07, 0x93, 0x90, 0x72, 0x07, 0xF9, 0x07,
  0x20, 0x79, 0x39, 0x07, 0x20, 0x79, 0x39, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0x93, 0x90, 0x72,
  0x07, 0x93, 0x90, 0x72, 0x07, 0x80, 0xC2, 0xF8, 0xA4, 0xB7, 0x7B, 0xF7, 0x77, 0xFB, 0x77, 0xBF,
  0x77, 0x7F, 0xB7, 0x7B, 0xF9, 0x07, 0x20, 0x79, 0x39, 0x07, 0x20, 0x79, 0x39, 0x07, 0x20, 0x7F,
  0x90, 0x72, 0x07, 0x93, 0x90, 0x72, 0x07, 0x93, 0x90, 0x72, 0x07, 0xF9, 0x8A, 0x4B, 0x77, 0xBF,
  0x77, 0x7F, 0xB7, 0x7B, 0xF7, 0x77, 0xFB, 0x77, 0xB8, 0x09, 0x85, 0xF0, 0xD0, 0x88, 0x04, 0x70,
  0x80, 0xDF, 0xFC, 0x02, 0x73, 0x02, 0xFF, 0xC0, 0x27, 0x30, 0x2F, 0xFC, 0x0D, 0x08, 0x80, 0x47,
  0x08, 0x0D, 0xFA, 0x0B, 0xFF, 0xFF, 0x81, 0xB3, 0xEF, 0xFF, 0xD8, 0x3E, 0x30, 0x16, 0x80, 0xA4,
  0x70, 0x60, 0x18, 0x09, 0x83, 0x00, 0x58, 0x04, 0x70, 0x47, 0x76, 0x0C, 0xF9, 0x0C, 0x77, 0x60,
  0x10, 0xDE, 0x0D, 0x01, 0x77, 0x70, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xA0, 0xD0,
  0x17, 0x77, 0x48, 0x21, 0xDD, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_hide() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 33), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_hide_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_option_key 36x36, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_round_36_hardware_keyboard_option_key_data[] PROGMEM = {
  0x10, 0x58, 0x02, 0x70, 0x57, 0x30, 0x58, 0x02, 0x78, 0x15, 0x05, 0xF9, 0x0D, 0x01, 0x70, 0x5F,
  0x90, 0x05, 0xFA, 0x0A, 0x70, 0x5F, 0x98, 0x15, 0x05, 0x80, 0x17, 0x08, 0xB0, 0x37, 0x05, 0x80,
  0x27, 0x05, 0x72, 0x0A, 0xA0, 0xC7, 0x77, 0x30, 0x10, 0xEA, 0x06, 0x77, 0x73, 0x07, 0xA0, 0xE7,
  0x77, 0x40, 0xDA, 0x08, 0x77, 0x73, 0x05, 0xB0, 0x27, 0x77, 0x30, 0xBA, 0x0A, 0x77, 0x73, 0x03,
  0xB0, 0x47, 0x77, 0x30, 0x9A, 0x0C, 0x77, 0x73, 0x01, 0x0E, 0xA0, 0x67, 0x77, 0x30, 0x7A, 0x0E,
  0x01, 0x77, 0x73, 0x0D, 0xA0, 0x97, 0x77, 0x30, 0x4B, 0x02, 0x77, 0x73, 0x0B, 0xA0, 0xB7, 0x77,
  0x30, 0x2B, 0x04, 0x77, 0x73, 0x08, 0xA0, 0xD8, 0x02, 0x70, 0x57, 0x73, 0x01, 0x0E, 0xFA, 0x05,
  0x77, 0x30, 0x4F, 0xA0, 0x57, 0x74, 0x02, 0x06, 0x80, 0x27, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_option_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 31, 28), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_option_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard 36x36, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_36_hardware_keyboard_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0A, 0x47, 0x83, 0x61, 0x03, 0xEF, 0xFF, 0xD8, 0x1E, 0x3B, 0xFF, 0xFF, 0x0B,
  0x0E, 0x80, 0xF3, 0xF0, 0x72, 0x07, 0x93, 0x90, 0x72, 0x07, 0x93, 0x90, 0x72, 0x07, 0xF9, 0x07,
  0x20, 0x79, 0x39, 0x07, 0x20, 0x79, 0x39, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0x93, 0x90, 0x72,
  0x07, 0x93, 0x90, 0x72, 0x07, 0x80, 0xC2, 0xF8, 0xA4, 0xB7, 0x7B, 0xF7, 0x77, 0xFB, 0x77, 0xBF,
  0x77, 0x7F, 0xB7, 0x7B, 0xF9, 0x07, 0x20, 0x79, 0x39, 0x07, 0x20, 0x79, 0x39, 0x07, 0x20, 0x7F,
  0x90, 0x72, 0x07, 0x93, 0x90, 0x72, 0x07, 0x93, 0x90, 0x72, 0x07, 0xF9, 0x8A, 0x4B, 0x77, 0xBF,
  0x77, 0x7F, 0xB7, 0x7B, 0xF7, 0x77, 0xFB, 0x77, 0xB8, 0x09, 0x85, 0xF0, 0xD0, 0x88, 0x04, 0x70,
  0x80, 0xDF, 0xFC, 0x02, 0x73, 0x02, 0xFF, 0xC0, 0x27, 0x30, 0x2F, 0xFC, 0x0D, 0x08, 0x80, 0x47,
  0x08, 0x0D, 0xFA, 0x0B, 0xFF, 0xFF, 0x81, 0xB3, 0xEF, 0xFF, 0xD8, 0x3E, 0x30, 0x16, 0x80, 0xA4,
  0x70, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 32, 28), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_return 36x36, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_36_hardware_keyboard_return_data[] PROGMEM = {
  0x71, 0x00, 0x37, 0x77, 0x50, 0x7A, 0x04, 0x77, 0x10, 0x05, 0x70, 0x7B, 0x06, 0x77, 0x05, 0xA0,
  0x55, 0x07, 0xB0, 0xB7, 0x71, 0x07, 0xA0, 0x74, 0x07, 0xB0, 0xB7, 0x72, 0x07, 0xA0, 0x73, 0x07,
  0xB0, 0xB7, 0x73, 0x07, 0xA0, 0x72, 0x07, 0xB0, 0xB7, 0x74, 0x07, 0xA8, 0x17, 0x07, 0xC0, 0x88,
  0x09, 0x67, 0x0B, 0xA0, 0x70, 0x3F, 0xFF, 0xE0, 0x70, 0x3F, 0xFF, 0xE8, 0x15, 0x07, 0xC0, 0x88,
  0x0A, 0x07, 0x05, 0x30, 0x7B, 0x0B, 0x77, 0x74, 0x07, 0xB0, 0xB7, 0x77, 0x40, 0x7B, 0x0A, 0x77,
  0x74, 0x07, 0xB0, 0xA7, 0x77, 0x40, 0x7B, 0x06, 0x77, 0x74, 0x07, 0xA0, 0x47, 0x77, 0x50, 0x03,
  0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_return() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 9, 31, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_return_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_tab 36x36, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_36_hardware_keyboard_tab_data[] PROGMEM = {
  0x77, 0x38, 0x11, 0x51, 0x72, 0x81, 0x8E, 0x87, 0x73, 0x82, 0xCF, 0xD1, 0x71, 0xB7, 0x73, 0x0D,
  0xA0, 0xD0, 0x17, 0xB7, 0x73, 0x04, 0xB0, 0xD0, 0x16, 0xB7, 0x74, 0x04, 0xB0, 0xD0, 0x15, 0xB7,
  0x75, 0x04, 0xB0, 0xD0, 0x14, 0xB7, 0x76, 0x04, 0xB0, 0xD0, 0x13, 0xB1, 0x05, 0x80, 0x97, 0x70,
  0xBB, 0x0D, 0x01, 0x2B, 0x05, 0xFF, 0xFC, 0x0B, 0x2B, 0x05, 0xFF, 0xFC, 0x0B, 0x2B, 0x10, 0x58,
  0x09, 0x77, 0x0B, 0xB0, 0xD0, 0x12, 0xB7, 0x76, 0x04, 0xB0, 0xD0, 0x13, 0xB7, 0x75, 0x04, 0xB0,
  0xD0, 0x14, 0xB7, 0x74, 0x04, 0xB0, 0xD0, 0x15, 0xB7, 0x73, 0x04, 0xB0, 0xD0, 0x16, 0xB7, 0x73,
  0x0D, 0xA0, 0xD0, 0x17, 0xB7, 0x73, 0x82, 0xCF, 0xD1, 0x71, 0xB7, 0x73, 0x81, 0x15, 0x17, 0x28,
  0x18, 0xE8,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_tab() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 9, 32, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_tab_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_keyboard_voice 36x36, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_round_36_hardware_keyboard_voice_data[] PROGMEM = {
  0x72, 0x82, 0x26, 0x62, 0x77, 0x30, 0xAC, 0x0A, 0x77, 0x10, 0x9E, 0x09, 0x76, 0x02, 0xF9, 0x02,
  0x75, 0x06, 0xF9, 0x06, 0x75, 0x07, 0xF9, 0x07, 0x75, 0x07, 0xF9, 0x07, 0x75, 0x07, 0xF9, 0x07,
  0x75, 0x07, 0xF9, 0x07, 0x75, 0x07, 0xF9, 0x07, 0x75, 0x07, 0xF9, 0x07, 0x75, 0x07, 0xF9, 0x07,
  0x75, 0x07, 0xF9, 0x07, 0x75, 0x07, 0xF9, 0x07, 0x68, 0x12, 0xDB, 0x30, 0x6F, 0x90, 0x53, 0x82,
  0xBD, 0x25, 0xA0, 0x32, 0x02, 0xF9, 0x02, 0x20, 0x3A, 0x05, 0x02, 0xA0, 0x73, 0x09, 0xE0, 0x93,
  0x07, 0xA8, 0x32, 0x0C, 0xFE, 0x40, 0xAC, 0x09, 0x48, 0x1E, 0xFC, 0x20, 0x5A, 0x09, 0x48, 0x22,
  0x66, 0x24, 0x09, 0xA0, 0x53, 0x0B, 0xA0, 0x77, 0x30, 0x7A, 0x0B, 0x40, 0x10, 0xDA, 0x0B, 0x02,
  0x60, 0x20, 0xBA, 0x0D, 0x01, 0x50, 0x20, 0xCB, 0x84, 0xB8, 0x55, 0x8B, 0xB0, 0xD0, 0x27, 0x10,
  0x9F, 0xB0, 0x97, 0x48, 0x12, 0x8D, 0xC8, 0x1D, 0x82, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x40, 0x7A,
  0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x48, 0x22, 0xDD, 0x27, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_keyboard_voice() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 28, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_keyboard_voice_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_laptop_chromebook 36x36, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_round_36_hardware_laptop_chromebook_data[] PROGMEM = {
  0x40, 0x10, 0x68, 0x0A, 0x47, 0x06, 0x01, 0x70, 0x30, 0xEF, 0xFF, 0xD0, 0xE0, 0x36, 0x0B, 0xFF,
  0xFF, 0x0B, 0x6B, 0x0D, 0x08, 0x80, 0xA0, 0x70, 0x80, 0xDB, 0x6B, 0x02, 0x77, 0x71, 0x02, 0xB6,
  0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77,
  0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B,
  0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x80, 0xA4,
  0x7B, 0x6F, 0xFF, 0xFA, 0x6F, 0xFF, 0xFA, 0x6F, 0xD8, 0x4A, 0x77, 0x77, 0xAF, 0xD6, 0xFD, 0x02,
  0x40, 0x2F, 0xD3, 0x08, 0xFF, 0xFF, 0xE0, 0x80, 0xEF, 0xFF, 0xFE, 0x0E, 0x08, 0xFF, 0xFF, 0xE0,
  0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_laptop_chromebook() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_laptop_chromebook_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_laptop_mac 36x36, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_round_36_hardware_laptop_mac_data[] PROGMEM = {
  0x40, 0x10, 0x68, 0x0A, 0x47, 0x06, 0x01, 0x70, 0x30, 0xEF, 0xFF, 0xD0, 0xE0, 0x36, 0x0B, 0xFF,
  0xFF, 0x0B, 0x6B, 0x0D, 0x08, 0x80, 0xA0, 0x70, 0x80, 0xDB, 0x6B, 0x02, 0x77, 0x71, 0x02, 0xB6,
  0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77,
  0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B,
  0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73,
  0xB6, 0xB0, 0x77, 0x77, 0x10, 0x7B, 0x60, 0xDF, 0xFF, 0xF0, 0xD6, 0x08, 0xFE, 0x00, 0x9F, 0xE0,
  0x87, 0x08, 0x0D, 0xFB, 0x09, 0x20, 0x9F, 0xB0, 0xD0, 0x84, 0x0D, 0xFF, 0x90, 0x92, 0x09, 0xFF,
  0x90, 0xD0, 0x8F, 0xFA, 0x00, 0x9F, 0xFA, 0x82, 0x80, 0x8D, 0xFF, 0xFF, 0xA0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_laptop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_laptop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_laptop 36x36, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_36_hardware_laptop_data[] PROGMEM = {
  0x40, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x87, 0x08, 0xFF, 0xFF, 0x08, 0x60, 0xDF, 0xFF, 0xF0, 0xD6,
  0xB0, 0x77, 0x77, 0x10, 0x7B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6,
  0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77,
  0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B,
  0x77, 0x73, 0xB6, 0xB0, 0x77, 0x77, 0x10, 0x7B, 0x60, 0xDF, 0xFF, 0xF0, 0xD6, 0x08, 0xFF, 0xFF,
  0x08, 0x70, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x84, 0x08, 0xFF, 0xFF, 0xE0, 0x80, 0xEF, 0xFF, 0xFE,
  0x0E, 0x08, 0xFF, 0xFF, 0xE0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_laptop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_laptop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_laptop_windows 36x36, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_round_36_hardware_laptop_windows_data[] PROGMEM = {
  0x40, 0x10, 0x68, 0x0A, 0x47, 0x06, 0x01, 0x70, 0x30, 0xEF, 0xFF, 0xD0, 0xE0, 0x36, 0x0B, 0xFF,
  0xFF, 0x0B, 0x6B, 0x0D, 0x08, 0x80, 0xA0, 0x70, 0x80, 0xDB, 0x6B, 0x02, 0x77, 0x71, 0x02, 0xB6,
  0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77,
  0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B,
  0x77, 0x73, 0xB6, 0xB7, 0x77, 0x3B, 0x6B, 0x77, 0x73, 0xB6, 0xB0, 0x27, 0x77, 0x10, 0x2B, 0x6B,
  0x0D, 0x08, 0x80, 0xA0, 0x70, 0x80, 0xDA, 0x0E, 0x60, 0xBF, 0xFF, 0xF0, 0xB6, 0x03, 0x0E, 0xFF,
  0xFD, 0x0E, 0x03, 0x70, 0x10, 0x6F, 0xFF, 0xB0, 0x60, 0x17, 0x3F, 0xFF, 0xB6, 0x08, 0xFF, 0xFF,
  0xE0, 0x80, 0xEF, 0xFF, 0xFE, 0x0E, 0x08, 0xFF, 0xFF, 0xE0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_laptop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_laptop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_memory 36x36, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_round_36_hardware_memory_data[] PROGMEM = {
  0x73, 0x00, 0x54, 0x00, 0x57, 0x75, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x57, 0x74, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x77, 0x78, 0x34, 0x77, 0x7B, 0xA8, 0x2B, 0x77, 0xBA, 0x83, 0xB7, 0x77, 0x47, 0x20,
  0x9F, 0xFC, 0x09, 0x70, 0x4F, 0xFE, 0x04, 0x60, 0x7B, 0x09, 0x80, 0x90, 0x70, 0x9B, 0x07, 0x60,
  0x7A, 0x09, 0x77, 0x09, 0xA0, 0x76, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x48, 0x15, 0x7B, 0xA0,
  0x73, 0x05, 0x80, 0x27, 0x05, 0x30, 0x7A, 0x83, 0xB7, 0x50, 0x5D, 0x07, 0x20, 0x5F, 0x90, 0x52,
  0x07, 0xD0, 0x05, 0xD0, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7D, 0x83, 0x50, 0x57, 0xBA, 0x07, 0x20,
  0x7A, 0x82, 0xB7, 0x7B, 0xA0, 0x72, 0x07, 0xA8, 0x1B, 0x75, 0x40, 0x7A, 0x07, 0x20, 0x7A, 0x07,
  0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20,
  0x7A, 0x07, 0x48, 0x15, 0x7B, 0xA0, 0x72, 0x07, 0xA8, 0x2B, 0x77, 0xBA, 0x07, 0x20, 0x7A, 0x83,
  0xB7, 0x50, 0x5D, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xD0, 0x05, 0xD0, 0x72, 0x05, 0xF9, 0x05,
  0x20, 0x7D, 0x83, 0x50, 0x57, 0xBA, 0x07, 0x30, 0x58, 0x02, 0x70, 0x53, 0x07, 0xA8, 0x1B, 0x75,
  0x40, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x97, 0x70, 0x9A, 0x07, 0x60, 0x7B, 0x09,
  0x80, 0x90, 0x70, 0x9B, 0x07, 0x60, 0x4F, 0xFE, 0x04, 0x70, 0x9F, 0xFC, 0x09, 0x72, 0x83, 0x47,
  0x77, 0xBA, 0x82, 0xB7, 0x7B, 0xA8, 0x3B, 0x77, 0x74, 0x77, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77,
  0x74, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x57, 0x75, 0x00, 0x54, 0x00, 0x57, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_memory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_memory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_monitor 36x36, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_36_hardware_monitor_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0A, 0x47, 0x83, 0x61, 0x03, 0xEF, 0xFF, 0xD8, 0x1E, 0x3B, 0xFF, 0xFF, 0x0B,
  0xB8, 0x0A, 0x47, 0xA0, 0xEB, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77,
  0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73,
  0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3B, 0x0D, 0xFF, 0xFF,
  0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x70, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x70, 0x10, 0xDF, 0xF0, 0xD0,
  0x17, 0x50, 0xBF, 0xFA, 0x0B, 0x75, 0x0E, 0xFF, 0xA0, 0xE7, 0x50, 0x9F, 0xFA, 0x09, 0x76, 0x05,
  0x80, 0x92, 0x70, 0x57,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_mouse 36x36, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_round_36_hardware_mouse_data[] PROGMEM = {
  0x72, 0x00, 0x22, 0x00, 0x27, 0x71, 0x83, 0x28, 0xEF, 0x72, 0x83, 0x7F, 0xE8, 0x27, 0x40, 0x8C,
  0x07, 0x20, 0x7C, 0x08, 0x71, 0x01, 0x0C, 0xD0, 0x72, 0x07, 0xD0, 0xC0, 0x15, 0x01, 0x0C, 0xE0,
  0x72, 0x07, 0xE0, 0xC0, 0x14, 0x0A, 0xF0, 0x72, 0x07, 0xF0, 0xA3, 0x05, 0xF9, 0x07, 0x20, 0x7F,
  0x90, 0x52, 0x0D, 0xF9, 0x07, 0x20, 0x7F, 0x98, 0x1D, 0x04, 0xFA, 0x07, 0x20, 0x7F, 0xA0, 0x40,
  0x8F, 0xA0, 0x72, 0x07, 0xFA, 0x08, 0x0C, 0xFA, 0x07, 0x20, 0x7F, 0xA0, 0xC0, 0xEF, 0xA0, 0x72,
  0x07, 0xFA, 0x0E, 0x80, 0x67, 0x03, 0x20, 0x38, 0x06, 0x78, 0x0D, 0x40, 0x80, 0xA4, 0x78, 0x0A,
  0x94, 0xF0, 0xDF, 0xFF, 0x90, 0xD0, 0xCF, 0xFF, 0x90, 0xC0, 0x8F, 0xFF, 0x90, 0x80, 0x4F, 0xFF,
  0x98, 0x14, 0x0D, 0xFF, 0xE0, 0xD2, 0x05, 0xFF, 0xE0, 0x53, 0x0A, 0xFF, 0xC0, 0xA5, 0x0C, 0xFF,
  0xA0, 0xC6, 0x01, 0x0B, 0xFF, 0x0B, 0x01, 0x71, 0x08, 0xFD, 0x08, 0x74, 0x81, 0x29, 0xEE, 0x81,
  0xE9, 0x27, 0x71, 0x84, 0x35, 0x77, 0x53, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_mouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 29, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_mouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_phone_android 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_round_36_hardware_phone_android_data[] PROGMEM = {
  0x30, 0x20, 0x68, 0x09, 0x07, 0x06, 0x02, 0x50, 0xAF, 0xFA, 0x0A, 0x30, 0x9F, 0xFC, 0x81, 0x90,
  0x2F, 0xFE, 0x02, 0x06, 0xFF, 0xE0, 0x60, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A,
  0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x70, 0x6F, 0x02, 0x40, 0x2F, 0x06, 0x02, 0xF8, 0x4A, 0x77, 0x77, 0xAF, 0x81,
  0x20, 0x9F, 0xFC, 0x09, 0x30, 0xAF, 0xFA, 0x0A, 0x50, 0x20, 0x68, 0x09, 0x07, 0x06, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_phone_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_phone_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_phone_iphone 36x36, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_round_36_hardware_phone_iphone_data[] PROGMEM = {
  0x20, 0x10, 0x58, 0x09, 0x07, 0x06, 0x03, 0x30, 0x40, 0xEF, 0xF9, 0x82, 0xA0, 0x1E, 0xFF, 0xB0,
  0x70, 0x5F, 0xFC, 0x0D, 0x07, 0xFF, 0xD0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A,
  0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A,
  0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A,
  0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A,
  0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A,
  0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7A, 0x07, 0x76, 0xB0, 0x7F, 0xFD, 0x07, 0xF9, 0x81,
  0xA8, 0xDF, 0x90, 0x7F, 0x06, 0x30, 0xDF, 0x07, 0xF0, 0x13, 0x08, 0xF0, 0x5F, 0x02, 0x30, 0xAE,
  0x81, 0xD1, 0xEE, 0x82, 0xC2, 0x06, 0xF8, 0x27, 0x04, 0xEF, 0xF9, 0x0A, 0x30, 0x10, 0x58, 0x09,
  0x07, 0x06, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_phone_iphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 26, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_phone_iphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_phonelink_off 36x36, 4-bit Alpha,  RLE, 207 bytes.
static const unsigned char ic_round_36_hardware_phonelink_off_data[] PROGMEM = {
  0x18, 0x21, 0xEE, 0x57, 0x77, 0x74, 0x05, 0xB0, 0x57, 0x77, 0x74, 0x0C, 0xB0, 0x57, 0x77, 0x73,
  0x01, 0x0C, 0xB0, 0x53, 0x06, 0xFF, 0xE0, 0x86, 0x08, 0xC0, 0x53, 0x06, 0xFF, 0xD0, 0xE6, 0x0E,
  0xD0, 0x53, 0x06, 0xFF, 0xC0, 0x86, 0xB0, 0xCB, 0x05, 0x77, 0x77, 0xB0, 0x10, 0xCB, 0x05, 0x77,
  0x76, 0xB1, 0x01, 0x0C, 0xB0, 0x57, 0x77, 0x5B, 0x20, 0x10, 0xCB, 0x05, 0x73, 0x08, 0xFB, 0x08,
  0x3B, 0x30, 0x10, 0xCB, 0x05, 0x72, 0xFD, 0x3B, 0x40, 0x10, 0xCB, 0x05, 0x71, 0xFD, 0x3B, 0x50,
  0x10, 0xCB, 0x05, 0x7B, 0x6B, 0x3B, 0x60, 0x10, 0xCB, 0x05, 0x6B, 0x6B, 0x3B, 0x70, 0x10, 0xCB,
  0x05, 0x5B, 0x6B, 0x3B, 0x71, 0x01, 0x0C, 0xB0, 0x54, 0xB6, 0xB3, 0xB7, 0x20, 0x10, 0xCB, 0x05,
  0x30, 0x6A, 0x6B, 0x3B, 0x73, 0x01, 0x0C, 0xB0, 0x53, 0x06, 0x96, 0xB3, 0xB7, 0x40, 0x10, 0xCB,
  0x05, 0x30, 0x66, 0xB3, 0xB7, 0x50, 0x10, 0xCB, 0x05, 0x72, 0xB3, 0xB7, 0x60, 0x10, 0xCB, 0x05,
  0x71, 0xB3, 0xB7, 0x70, 0x10, 0xCB, 0x05, 0x7B, 0x10, 0x40, 0x7B, 0x80, 0x93, 0x70, 0x9C, 0x05,
  0x38, 0x11, 0x77, 0xB0, 0x8F, 0xFF, 0xD0, 0x53, 0x06, 0xC0, 0xEF, 0xFF, 0xE0, 0x53, 0x06, 0xB0,
  0xCF, 0xFF, 0xF0, 0x53, 0x83, 0x6F, 0xE3, 0xCF, 0xFF, 0xF0, 0x53, 0x06, 0x07, 0x77, 0x75, 0x01,
  0x0C, 0xB0, 0x47, 0x77, 0x73, 0x01, 0x0C, 0xA0, 0x87, 0x77, 0x74, 0x82, 0x1B, 0xC2, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_phonelink_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 35, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_phonelink_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_phonelink 36x36, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_round_36_hardware_phonelink_data[] PROGMEM = {
  0x40, 0x80, 0xDF, 0xFF, 0xD0, 0x86, 0x08, 0xFF, 0xFF, 0x0E, 0x60, 0xDF, 0xFF, 0xF0, 0x86, 0xB0,
  0x77, 0x77, 0x74, 0xB7, 0x77, 0x75, 0xB7, 0x77, 0x75, 0xB7, 0x74, 0x08, 0xFB, 0x08, 0x3B, 0x77,
  0x4F, 0xD3, 0xB7, 0x74, 0xFD, 0x3B, 0x77, 0x4B, 0x6B, 0x3B, 0x77, 0x4B, 0x6B, 0x3B, 0x77, 0x4B,
  0x6B, 0x3B, 0x77, 0x4B, 0x6B, 0x3B, 0x77, 0x4B, 0x6B, 0x3B, 0x77, 0x4B, 0x6B, 0x3B, 0x77, 0x4B,
  0x6B, 0x3B, 0x77, 0x4B, 0x6B, 0x3B, 0x77, 0x4B, 0x6B, 0x3B, 0x77, 0x4B, 0x6B, 0x10, 0x40, 0x7B,
  0x80, 0x91, 0x70, 0x44, 0xB8, 0x02, 0x7B, 0x08, 0xFF, 0xD0, 0x83, 0xFD, 0x0E, 0xFF, 0xD0, 0xE3,
  0xFD, 0x0C, 0xFF, 0xD0, 0xC3, 0xFD, 0x03, 0x0C, 0xFF, 0xB0, 0xC0, 0x33, 0x08, 0xFB, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_phonelink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_phonelink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_point_of_sale 36x36, 4-bit Alpha,  RLE, 187 bytes.
static const unsigned char ic_round_36_hardware_point_of_sale_data[] PROGMEM = {
  0x50, 0x30, 0xBF, 0xFA, 0x0B, 0x03, 0x72, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x17, 0x10, 0x6F, 0xFE,
  0x06, 0x71, 0x07, 0xA0, 0xA7, 0x70, 0xAA, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0xA7, 0x70, 0xAA, 0x07, 0x71, 0x06, 0xFF, 0xE0, 0x67, 0x10, 0x10, 0xEF, 0xFC, 0x0E,
  0x01, 0x72, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x38, 0x0C, 0x50, 0x01, 0x06, 0x80, 0x92, 0x70, 0x60,
  0x17, 0x40, 0x40, 0xEF, 0xFA, 0x0E, 0x04, 0x73, 0x0D, 0xFF, 0xC0, 0xD7, 0x20, 0x5C, 0x89, 0x2A,
  0x7A, 0xFD, 0x77, 0xDF, 0xA7, 0xAC, 0x05, 0x71, 0x0C, 0xC8, 0x32, 0x02, 0xFA, 0x28, 0x3A, 0xF2,
  0x02, 0xC0, 0xC7, 0x03, 0xFF, 0xF9, 0x03, 0x60, 0xAD, 0x89, 0x2A, 0x7A, 0xFD, 0x77, 0xDF, 0xA7,
  0xAD, 0x0A, 0x50, 0x1E, 0x83, 0x20, 0x2F, 0xA2, 0x83, 0xAF, 0x20, 0x2E, 0x01, 0x40, 0x8F, 0xFF,
  0xB0, 0x84, 0x0E, 0xE8, 0x92, 0xA7, 0xAF, 0xD7, 0x7D, 0xFA, 0x7A, 0xE0, 0xE3, 0x06, 0xF8, 0x32,
  0x02, 0xFA, 0x28, 0x3A, 0xF2, 0x02, 0xF0, 0x62, 0x0D, 0xFF, 0xFD, 0x81, 0xD0, 0x5F, 0xFF, 0xF0,
  0x50, 0xCF, 0xFF, 0xF0, 0xC7, 0x77, 0x72, 0x80, 0xB2, 0x7F, 0xFF, 0xFA, 0x0D, 0xFF, 0xFF, 0x0D,
  0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_point_of_sale() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_point_of_sale_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_power_input 36x36, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_36_hardware_power_input_data[] PROGMEM = {
  0x02, 0x80, 0xA6, 0x78, 0x15, 0x0D, 0xFF, 0xFE, 0x05, 0x0D, 0xFF, 0xFE, 0x05, 0x02, 0x80, 0xA6,
  0x70, 0x58, 0x0E, 0x70, 0x02, 0x80, 0x17, 0x05, 0x40, 0x58, 0x01, 0x70, 0x23, 0x02, 0x80, 0x17,
  0x81, 0x50, 0xDE, 0x05, 0x20, 0x5E, 0x0D, 0x30, 0xDE, 0x05, 0x0D, 0xE0, 0x52, 0x05, 0xE0, 0xD3,
  0x0D, 0xE0, 0x50, 0x28, 0x01, 0x70, 0x54, 0x05, 0x80, 0x17, 0x02, 0x30, 0x28, 0x01, 0x70, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_power_input() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 13, 31, 22), Box(0, 0, 35, 35),
      ic_round_36_hardware_power_input_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_router 36x36, 4-bit Alpha,  RLE, 156 bytes.
static const unsigned char ic_round_36_hardware_router_data[] PROGMEM = {
  0x77, 0x38, 0x42, 0x57, 0x75, 0x27, 0x76, 0x06, 0x0D, 0xE0, 0xD0, 0x67, 0x72, 0x03, 0x0D, 0xA8,
  0x4A, 0x65, 0x56, 0xAA, 0x0D, 0x03, 0x77, 0xA0, 0x80, 0x16, 0x01, 0x08, 0xA7, 0x78, 0x46, 0x30,
  0x18, 0xDA, 0x84, 0xD8, 0x10, 0x36, 0x77, 0x28, 0x90, 0x3E, 0xFE, 0xCC, 0xEF, 0xE3, 0x77, 0x48,
  0x15, 0xD6, 0x48, 0x16, 0xC5, 0x80, 0x99, 0x20, 0x00, 0x57, 0x77, 0x40, 0x5A, 0x05, 0x77, 0x73,
  0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07,
  0x71, 0x04, 0x80, 0x93, 0x70, 0xBA, 0x83, 0xB7, 0x77, 0x43, 0x09, 0xFF, 0xFB, 0x81, 0x90, 0x4F,
  0xFF, 0xD0, 0x40, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7C, 0x3A, 0x03, 0x28, 0x1B, 0xF7,
  0x20, 0x7F, 0x90, 0x07, 0xC3, 0xA0, 0x32, 0x81, 0xBF, 0x72, 0x07, 0xF9, 0x00, 0x7C, 0x3A, 0x03,
  0x28, 0x1B, 0xF7, 0x20, 0x7F, 0x90, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF,
  0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_router() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_router_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_scanner 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_round_36_hardware_scanner_data[] PROGMEM = {
  0x28, 0x2C, 0xFA, 0x57, 0x77, 0x20, 0x4C, 0x81, 0xE9, 0x37, 0x77, 0x0B, 0xE8, 0x1D, 0x72, 0x77,
  0x58, 0x12, 0x8D, 0xE8, 0x1B, 0x61, 0x77, 0x58, 0x13, 0x9E, 0xE0, 0xA0, 0x47, 0x76, 0x05, 0x0A,
  0xE8, 0x1E, 0x93, 0x77, 0x58, 0x11, 0x6C, 0xE8, 0x1D, 0x71, 0x77, 0x58, 0x12, 0x7D, 0xE0, 0xB0,
  0x57, 0x76, 0x81, 0x39, 0xED, 0x0E, 0x06, 0x77, 0x70, 0x40, 0xAD, 0x82, 0x30, 0x3B, 0xFF, 0xFB,
  0x81, 0x71, 0xEF, 0xFF, 0xC0, 0x70, 0x6F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7A, 0x82, 0xB7,
  0x7B, 0xB0, 0x98, 0x09, 0x07, 0x09, 0xB0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x97, 0x70, 0x9A, 0x00,
  0x7A, 0x07, 0x20, 0x7A, 0x09, 0x77, 0x09, 0xA0, 0x07, 0xA8, 0x2B, 0x77, 0xBB, 0x09, 0x80, 0x90,
  0x70, 0x9B, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x6F, 0xFF, 0xD8, 0x16, 0x1E, 0xFF, 0xFB, 0x83, 0xE1,
  0x03, 0xBF, 0xFF, 0x90, 0xB0, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 31, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_security 36x36, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_round_36_hardware_security_data[] PROGMEM = {
  0x76, 0x00, 0x17, 0x77, 0x30, 0x60, 0xCA, 0x0C, 0x06, 0x77, 0x58, 0x11, 0x7E, 0xE8, 0x1E, 0x71,
  0x77, 0x02, 0x09, 0xD0, 0xEE, 0x09, 0x02, 0x73, 0x04, 0x0B, 0xD0, 0xD0, 0x61, 0xF9, 0x0B, 0x04,
  0x60, 0x50, 0xCD, 0x0C, 0x05, 0x3F, 0xB0, 0xC0, 0x53, 0x0B, 0xD0, 0xA0, 0x35, 0xFD, 0x81, 0xB0,
  0x4B, 0x81, 0xE8, 0x17, 0xFE, 0x04, 0x07, 0xA0, 0xA7, 0x3F, 0xE0, 0x07, 0xA0, 0x77, 0x3F, 0xE0,
  0x07, 0xA0, 0x77, 0x3F, 0xE0, 0x07, 0xA0, 0x77, 0x3F, 0xE0, 0x07, 0xA0, 0x77, 0x3F, 0xE0, 0x07,
  0xA0, 0x77, 0x3F, 0xE0, 0x07, 0xA0, 0x77, 0x3F, 0xE0, 0x07, 0xA0, 0x77, 0x3F, 0xE0, 0x70, 0x6A,
  0x07, 0x73, 0xFE, 0x06, 0x05, 0xFE, 0x73, 0x09, 0xA0, 0x50, 0x3F, 0xE7, 0x30, 0xCA, 0x03, 0x1F,
  0xE7, 0x3B, 0x20, 0xBF, 0xD7, 0x20, 0x5A, 0x0B, 0x20, 0x7F, 0xD7, 0x20, 0xBA, 0x07, 0x20, 0x1F,
  0xD7, 0x10, 0x3B, 0x01, 0x30, 0x9F, 0xC7, 0x10, 0xBA, 0x09, 0x40, 0x2F, 0xC7, 0x05, 0xB0, 0x25,
  0x08, 0xFB, 0x60, 0x20, 0xEA, 0x08, 0x70, 0xDF, 0xA5, 0x01, 0x0D, 0xA0, 0xD7, 0x10, 0x20, 0xEF,
  0x94, 0x02, 0x0D, 0xA0, 0xE0, 0x27, 0x20, 0x4F, 0x93, 0x05, 0x0E, 0xB0, 0x47, 0x40, 0x40, 0xEE,
  0x10, 0x30, 0xBB, 0x0E, 0x04, 0x76, 0x02, 0x0D, 0xD0, 0xCC, 0x0D, 0x02, 0x77, 0x10, 0x10, 0x8F,
  0x90, 0x80, 0x17, 0x74, 0x81, 0x29, 0xEA, 0x81, 0xE9, 0x27, 0x77, 0x20, 0x05, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_security() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_security_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_sim_card 36x36, 4-bit Alpha,  RLE, 149 bytes.
static const unsigned char ic_round_36_hardware_sim_card_data[] PROGMEM = {
  0x71, 0x05, 0x0D, 0xFC, 0x0D, 0x08, 0x71, 0x07, 0xFF, 0x90, 0x86, 0x07, 0xFF, 0xA0, 0xD5, 0x07,
  0xFF, 0xC4, 0x07, 0xFF, 0xD3, 0x07, 0xFF, 0xE2, 0x07, 0xFF, 0xF1, 0x07, 0xFF, 0xF9, 0x05, 0xFF,
  0xFA, 0x0D, 0x80, 0x9C, 0x0F, 0x00, 0x9C, 0x00, 0x9C, 0x00, 0x9F, 0xA0, 0x92, 0x09, 0xA0, 0x92,
  0x09, 0xA0, 0x92, 0x09, 0xF9, 0x07, 0x20, 0x7A, 0x09, 0x20, 0x9A, 0x07, 0x20, 0x7F, 0x90, 0x72,
  0x07, 0xB0, 0x09, 0xB0, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x09, 0x20,
  0x9F, 0x90, 0x92, 0x09, 0xFA, 0x00, 0x9C, 0x00, 0x9C, 0x00, 0x9F, 0xF9, 0x09, 0x20, 0x9F, 0xFE,
  0x07, 0x20, 0x7F, 0xF9, 0x00, 0x9B, 0x07, 0x20, 0x7B, 0x00, 0x9F, 0xA0, 0x92, 0x09, 0xA0, 0x72,
  0x07, 0xA0, 0x92, 0x09, 0xF9, 0x09, 0x20, 0x9A, 0x09, 0x20, 0x9A, 0x09, 0x20, 0x9F, 0xA0, 0x09,
  0xC0, 0x09, 0xC0, 0x09, 0xFF, 0xFF, 0x90, 0xDF, 0xFF, 0x90, 0xD0, 0x8F, 0xFF, 0x98, 0x28, 0x08,
  0xDF, 0xFC, 0x0E, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_sim_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_sim_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_smart_display 36x36, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_36_hardware_smart_display_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xC1, 0xF8, 0x1E, 0x8B, 0xFF, 0xFE, 0x06, 0x20, 0x50, 0xEF, 0xFF, 0xC0, 0x33, 0x01, 0x09, 0xFF,
  0xFB, 0x03, 0x50, 0x40, 0xDF, 0xFF, 0x90, 0x37, 0x08, 0xFF, 0xF0, 0x37, 0x10, 0xAF, 0xFE, 0x03,
  0x71, 0x0A, 0xFF, 0xE0, 0x37, 0x08, 0xFF, 0xF0, 0x35, 0x04, 0x0D, 0xFF, 0xF9, 0x03, 0x30, 0x10,
  0x9F, 0xFF, 0xB0, 0x62, 0x05, 0x0E, 0xFF, 0xFC, 0x81, 0xE8, 0xB8, 0x09, 0xC6, 0xF0, 0xDF, 0xFF,
  0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28, 0x08, 0xDF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_smart_display() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_smart_display_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_smartphone 36x36, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_round_36_hardware_smartphone_data[] PROGMEM = {
  0x20, 0x48, 0x09, 0x47, 0x03, 0x30, 0x9F, 0xFC, 0x81, 0x90, 0x4F, 0xFE, 0x04, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xA0, 0xB8, 0x09, 0x27, 0x0B, 0xA0, 0x07, 0xA0, 0x77,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A,
  0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x09, 0x27,
  0x0B, 0xA0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x70, 0x4F, 0xFE, 0x81, 0x40,
  0x9F, 0xFC, 0x09, 0x30, 0x48, 0x09, 0x47, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_smartphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_smartphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_smart_screen 36x36, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_round_36_hardware_smart_screen_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xF8, 0x09, 0x67, 0xF0, 0x07, 0xF7, 0x74, 0xF0, 0x07, 0xF7, 0x74, 0xF0, 0x07, 0xF7, 0x74, 0xF0,
  0x07, 0xF7, 0x74, 0xF0, 0x07, 0xF7, 0x74, 0xF0, 0x07, 0xF3, 0x01, 0x73, 0x01, 0x3F, 0x00, 0x7F,
  0x28, 0x94, 0x8F, 0x40, 0xCE, 0x11, 0xEC, 0x04, 0xF8, 0x2F, 0x00, 0x7F, 0x28, 0x94, 0x8F, 0x40,
  0xCE, 0x11, 0xEC, 0x04, 0xF8, 0x2F, 0x00, 0x7F, 0x30, 0x17, 0x30, 0x13, 0xF0, 0x07, 0xF7, 0x74,
  0xF0, 0x07, 0xF7, 0x74, 0xF0, 0x07, 0xF7, 0x74, 0xF0, 0x07, 0xF7, 0x74, 0xF0, 0x07, 0xF7, 0x74,
  0xF0, 0x07, 0xF8, 0x09, 0x67, 0xF0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09,
  0x30, 0x48, 0x0B, 0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_smart_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 28), Box(0, 0, 35, 35),
      ic_round_36_hardware_smart_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_smart_toy 36x36, 4-bit Alpha,  RLE, 180 bytes.
static const unsigned char ic_round_36_hardware_smart_toy_data[] PROGMEM = {
  0x77, 0x84, 0x2A, 0xDD, 0xA2, 0x77, 0x76, 0x04, 0xE0, 0x47, 0x77, 0x50, 0xEE, 0x0E, 0x77, 0x74,
  0x04, 0xF9, 0x04, 0x77, 0x48, 0x51, 0x67, 0x77, 0x7B, 0xF9, 0x85, 0xB7, 0x77, 0x76, 0x17, 0x40,
  0x30, 0xEF, 0xFE, 0x0E, 0x03, 0x73, 0x0B, 0xFF, 0xF9, 0x0B, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB,
  0x73, 0xFF, 0xFB, 0x71, 0x02, 0x06, 0xFF, 0xFB, 0x06, 0x02, 0x50, 0xAF, 0xFF, 0xF0, 0xA3, 0x09,
  0xF9, 0x83, 0xE4, 0x04, 0xEC, 0x83, 0xE4, 0x04, 0xEF, 0x98, 0x19, 0x02, 0xFA, 0x06, 0x30, 0x6C,
  0x06, 0x30, 0x6F, 0xA0, 0x20, 0x6F, 0xA0, 0x43, 0x04, 0xC0, 0x43, 0x04, 0xFA, 0x00, 0x6F, 0xA0,
  0xA3, 0x0A, 0xC0, 0xA3, 0x0A, 0xFA, 0x06, 0x02, 0xFB, 0x81, 0xC8, 0xCE, 0x81, 0xC8, 0xCF, 0xB8,
  0x12, 0x09, 0xFF, 0xFF, 0xA0, 0x93, 0x0A, 0xFF, 0xFF, 0x0A, 0x50, 0x20, 0x6E, 0x0D, 0x08, 0x80,
  0x47, 0x08, 0x0D, 0xE0, 0x60, 0x27, 0x1E, 0x02, 0x73, 0x02, 0xE7, 0x3E, 0x02, 0x73, 0x02, 0xE7,
  0x3E, 0x0D, 0x08, 0x80, 0x47, 0x08, 0x0D, 0xE7, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF,
  0xB7, 0x30, 0xBF, 0xFF, 0x90, 0xB7, 0x30, 0x30, 0xEF, 0xFE, 0x0E, 0x03, 0x74, 0x01, 0x06, 0x80,
  0x96, 0x70, 0x60, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_smart_toy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_smart_toy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_speaker_group 36x36, 4-bit Alpha,  RLE, 180 bytes.
static const unsigned char ic_round_36_hardware_speaker_group_data[] PROGMEM = {
  0x70, 0x28, 0x09, 0x27, 0x02, 0x70, 0x5F, 0xFA, 0x05, 0x60, 0xDF, 0xFA, 0x0D, 0x6F, 0x82, 0xE9,
  0x9E, 0xF6, 0xE0, 0xC0, 0x12, 0x01, 0x0C, 0xE6, 0xE0, 0x34, 0x03, 0xE8, 0x12, 0x72, 0x3E, 0x6E,
  0x81, 0xDF, 0xD3, 0xE0, 0x34, 0x03, 0xFA, 0x3E, 0x0C, 0x01, 0x20, 0x10, 0xCF, 0xA3, 0xF8, 0x2E,
  0x99, 0xEF, 0xB3, 0xFF, 0xF3, 0xF8, 0x2E, 0xCC, 0xEF, 0xB3, 0xD0, 0xD0, 0x54, 0x05, 0x0D, 0xF9,
  0x3C, 0x0B, 0x71, 0x0B, 0xF3, 0xB8, 0x92, 0xE1, 0x01, 0x9D, 0xD9, 0x10, 0x1E, 0xE3, 0xB0, 0x72,
  0x0D, 0xC0, 0xD2, 0x07, 0xE3, 0xB8, 0x12, 0x07, 0xE8, 0x17, 0x02, 0xE3, 0xB2, 0x0A, 0xE0, 0xA2,
  0xE3, 0xB8, 0x11, 0x09, 0xE8, 0x19, 0x01, 0xE3, 0xB8, 0x14, 0x03, 0xE8, 0x13, 0x04, 0xE3, 0xB0,
  0xA2, 0x07, 0xC0, 0x72, 0x0A, 0xE3, 0xC0, 0x52, 0x82, 0x26, 0x62, 0x20, 0x5F, 0x3D, 0x06, 0x60,
  0x6F, 0x93, 0xE8, 0x4C, 0x74, 0x47, 0xCF, 0xA3, 0xFF, 0xF3, 0x0D, 0xFF, 0xA0, 0xDB, 0x30, 0x5F,
  0xFA, 0x05, 0xB4, 0x02, 0x06, 0x80, 0x91, 0x70, 0x21, 0xB7, 0x77, 0xB0, 0x27, 0x76, 0xB0, 0xD0,
  0x88, 0x09, 0x07, 0x02, 0x60, 0xBF, 0xFA, 0x0D, 0x60, 0x30, 0xEF, 0xF9, 0x0D, 0x70, 0x10, 0x68,
  0x09, 0x27, 0x02, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_speaker_group() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 29, 34), Box(0, 0, 35, 35),
      ic_round_36_hardware_speaker_group_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_speaker 36x36, 4-bit Alpha,  RLE, 186 bytes.
static const unsigned char ic_round_36_hardware_speaker_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFA, 0x83, 0xB3, 0x01, 0xEF, 0xFC, 0x81, 0xE1, 0x6F, 0xFE, 0x06, 0x07, 0xF9,
  0x82, 0x71, 0x17, 0xF9, 0x00, 0x7F, 0x07, 0x40, 0x7F, 0x00, 0x7F, 0x01, 0x40, 0x1F, 0x00, 0x7F,
  0x01, 0x40, 0x1F, 0x00, 0x7F, 0x07, 0x40, 0x7F, 0x00, 0x7F, 0x98, 0x27, 0x11, 0x7F, 0x90, 0x07,
  0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xE8, 0x1D, 0x72, 0x28, 0x12, 0x7D, 0xE0,
  0x07, 0xD0, 0x87, 0x10, 0x8D, 0x00, 0x7C, 0x07, 0x73, 0x07, 0xC0, 0x07, 0xB0, 0xA3, 0x84, 0x2A,
  0xDD, 0xA2, 0x30, 0xAB, 0x00, 0x7B, 0x02, 0x20, 0x4E, 0x04, 0x20, 0x2B, 0x00, 0x7A, 0x0C, 0x30,
  0xEE, 0x0E, 0x30, 0xCA, 0x00, 0x7A, 0x09, 0x20, 0x4F, 0x90, 0x42, 0x09, 0xA0, 0x07, 0xA0, 0x82,
  0x06, 0xF9, 0x06, 0x20, 0x8A, 0x00, 0x7A, 0x09, 0x20, 0x4F, 0x90, 0x42, 0x09, 0xA0, 0x07, 0xA0,
  0xC3, 0x0E, 0xE0, 0xE3, 0x0C, 0xA0, 0x07, 0xB0, 0x22, 0x04, 0xE0, 0x42, 0x02, 0xB0, 0x07, 0xB0,
  0xA3, 0x84, 0x2A, 0xDD, 0xA2, 0x30, 0xAB, 0x00, 0x7C, 0x07, 0x73, 0x07, 0xC0, 0x07, 0xD0, 0x87,
  0x10, 0x8D, 0x00, 0x7E, 0x81, 0xD7, 0x22, 0x81, 0x27, 0xDE, 0x07, 0x06, 0xFF, 0xE8, 0x16, 0x1E,
  0xFF, 0xC8, 0x4E, 0x10, 0x3B, 0xEF, 0xF9, 0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_speaker() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_round_36_hardware_speaker_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_start 36x36, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_36_hardware_start_data[] PROGMEM = {
  0x81, 0x8E, 0x87, 0x73, 0x00, 0x37, 0x1B, 0x77, 0x20, 0x4A, 0x07, 0x7B, 0x77, 0x20, 0x6B, 0x07,
  0x6B, 0x77, 0x30, 0xBB, 0x07, 0x5B, 0x77, 0x40, 0xBB, 0x07, 0x4B, 0x77, 0x50, 0xBB, 0x07, 0x3B,
  0x77, 0x60, 0xBB, 0x07, 0x2B, 0x30, 0x28, 0x09, 0x47, 0x08, 0xC0, 0x71, 0xB3, 0x0D, 0xFF, 0xF9,
  0x03, 0xB3, 0x0D, 0xFF, 0xF9, 0x03, 0xB3, 0x02, 0x80, 0x94, 0x70, 0x8C, 0x07, 0x1B, 0x77, 0x60,
  0xBB, 0x07, 0x2B, 0x77, 0x50, 0xBB, 0x07, 0x3B, 0x77, 0x40, 0xBB, 0x07, 0x4B, 0x77, 0x30, 0xBB,
  0x07, 0x5B, 0x77, 0x20, 0x6B, 0x07, 0x6B, 0x77, 0x20, 0x4A, 0x07, 0x78, 0x18, 0xE8, 0x77, 0x30,
  0x03, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_start() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 9, 32, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_start_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_tablet_android 36x36, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_round_36_hardware_tablet_android_data[] PROGMEM = {
  0x28, 0x12, 0xAD, 0xFF, 0xC8, 0x1D, 0xA2, 0x30, 0x4F, 0xFF, 0xB0, 0x42, 0x0E, 0xFF, 0xFB, 0x81,
  0xE0, 0x4F, 0xFF, 0xD0, 0x40, 0x7A, 0x08, 0x80, 0xA0, 0x70, 0x8A, 0x00, 0x7A, 0x01, 0x77, 0x60,
  0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01,
  0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00,
  0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60,
  0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01,
  0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00,
  0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60,
  0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01,
  0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00,
  0x7A, 0x01, 0x77, 0x60, 0x1A, 0x00, 0x7A, 0x08, 0x80, 0xA0, 0x70, 0x8A, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xB8, 0x4A, 0x77, 0x77, 0xAF, 0xB0, 0x70, 0x4F, 0xB0, 0x24, 0x02,
  0xFB, 0x81, 0x40, 0xEF, 0xFF, 0xB0, 0xE2, 0x04, 0xFF, 0xFB, 0x04, 0x38, 0x12, 0xAD, 0xFF, 0xC8,
  0x1D, 0xA2, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_tablet_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 31, 35), Box(0, 0, 35, 35),
      ic_round_36_hardware_tablet_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_tablet_mac 36x36, 4-bit Alpha,  RLE, 186 bytes.
static const unsigned char ic_round_36_hardware_tablet_mac_data[] PROGMEM = {
  0x18, 0x13, 0xBE, 0xFF, 0xF0, 0xD0, 0x72, 0x03, 0xFF, 0xFD, 0x81, 0xA0, 0xBF, 0xFF, 0xE0, 0x30,
  0xEF, 0xFF, 0xE0, 0x6B, 0x80, 0xA2, 0x70, 0xBA, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77,
  0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10,
  0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A,
  0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07,
  0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7,
  0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77,
  0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10,
  0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB7, 0x77, 0x10, 0x7A, 0x07, 0xB8, 0x0A, 0x27, 0x0B,
  0xA0, 0x7F, 0xFF, 0xF0, 0x7F, 0xD8, 0x2C, 0x20, 0x6F, 0xD0, 0x7F, 0xD0, 0x23, 0x0A, 0xFC, 0x07,
  0x0E, 0xFC, 0x01, 0x30, 0x8F, 0xC0, 0x60, 0xBF, 0xC0, 0x63, 0x0D, 0xFC, 0x00, 0x3F, 0xD8, 0x1A,
  0x8D, 0xFC, 0x0A, 0x28, 0x13, 0xBE, 0xFF, 0xF0, 0xD0, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_tablet_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 31, 35), Box(0, 0, 35, 35),
      ic_round_36_hardware_tablet_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_tablet 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_round_36_hardware_tablet_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0xF8, 0x3B, 0x30, 0x1E, 0xFF, 0xFF, 0xA8, 0x1E, 0x16, 0xFF, 0xFF, 0xC0,
  0x60, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77,
  0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D,
  0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D,
  0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77,
  0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D,
  0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D,
  0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x07, 0x06, 0xFF, 0xFF,
  0xC8, 0x15, 0x1E, 0xFF, 0xFF, 0xA8, 0x3E, 0x10, 0x3B, 0xFF, 0xFF, 0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_tablet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 34, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_tablet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_toys 36x36, 4-bit Alpha,  RLE, 186 bytes.
static const unsigned char ic_round_36_hardware_toys_data[] PROGMEM = {
  0x73, 0x81, 0x29, 0xDF, 0x98, 0x1D, 0x92, 0x75, 0x00, 0x53, 0x03, 0x0E, 0xFD, 0x0E, 0x03, 0x73,
  0x09, 0xA0, 0x52, 0x0C, 0xFF, 0x0C, 0x72, 0x09, 0xB8, 0x15, 0x03, 0xA0, 0xE0, 0x32, 0x07, 0xA0,
  0x72, 0x03, 0x0E, 0xA0, 0x37, 0x09, 0xB0, 0xD2, 0x08, 0xA0, 0x83, 0x07, 0xA0, 0x73, 0x08, 0xA0,
  0x86, 0x05, 0xD8, 0x19, 0x0D, 0xA0, 0x33, 0x07, 0xA0, 0x73, 0x03, 0xA0, 0xD6, 0x05, 0xA0, 0xDB,
  0x0B, 0xA0, 0xD4, 0x07, 0xA0, 0x74, 0x0D, 0xA0, 0x36, 0x82, 0x55, 0x09, 0xD0, 0x84, 0x07, 0xA0,
  0x74, 0x09, 0xA0, 0x97, 0x30, 0x9C, 0x03, 0x40, 0x7A, 0x07, 0x40, 0x3A, 0x0E, 0x73, 0x05, 0xFF,
  0xF0, 0xB0, 0x56, 0x01, 0x0C, 0xFF, 0xFB, 0x0B, 0x01, 0x40, 0xCF, 0xFF, 0xD0, 0xC3, 0x05, 0xFF,
  0xFF, 0x05, 0x20, 0xBF, 0xFF, 0xF0, 0xB2, 0x0E, 0xFF, 0xFF, 0x0E, 0x20, 0xEF, 0xFF, 0xF0, 0xE2,
  0x0B, 0xFF, 0xFF, 0x0B, 0x20, 0x6F, 0xFF, 0xF0, 0x63, 0x0C, 0xC8, 0x17, 0x07, 0xFD, 0x81, 0x70,
  0x7C, 0x0C, 0x40, 0x10, 0xBB, 0x3F, 0xD3, 0xB0, 0xC0, 0x16, 0x0C, 0xA8, 0x17, 0x07, 0xFD, 0x81,
  0x70, 0x7A, 0x0D, 0x71, 0x07, 0xF0, 0x76, 0x06, 0xF0, 0x77, 0x20, 0xBD, 0x0B, 0x71, 0x0B, 0xD0,
  0xB7, 0x48, 0x37, 0xCE, 0xC7, 0x73, 0x83, 0x7C, 0xEC, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_toys() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_hardware_toys_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_tv 36x36, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_round_36_hardware_tv_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0,
  0x97, 0x77, 0x50, 0x9A, 0x00, 0x7B, 0x09, 0x80, 0xA4, 0x70, 0x9B, 0x07, 0x04, 0xFF, 0xFF, 0xC8,
  0x13, 0x09, 0xFF, 0xFF, 0xA0, 0x93, 0x04, 0x80, 0x47, 0xFD, 0x80, 0x47, 0x04, 0x76, 0xFD, 0x77,
  0x71, 0x0D, 0xFB, 0x0D, 0x77, 0x71, 0x02, 0x80, 0x67, 0x02, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_hardware_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_videogame_asset_off 36x36, 4-bit Alpha,  RLE, 193 bytes.
static const unsigned char ic_round_36_hardware_videogame_asset_off_data[] PROGMEM = {
  0x20, 0x17, 0x77, 0x78, 0x21, 0xDF, 0x77, 0x77, 0x60, 0x3B, 0x07, 0x77, 0x76, 0x0A, 0xB0, 0x77,
  0x77, 0x60, 0xAB, 0x07, 0x77, 0x75, 0x09, 0xC0, 0x73, 0x04, 0xFF, 0xA0, 0xD0, 0x82, 0x08, 0xE0,
  0x73, 0x04, 0xFF, 0xB8, 0x18, 0x0E, 0xF0, 0x73, 0x04, 0xFF, 0xA0, 0xD1, 0xFA, 0x07, 0x30, 0x4F,
  0xFA, 0x1F, 0xB0, 0x73, 0x04, 0xF8, 0x1A, 0x8D, 0xD1, 0xFC, 0x07, 0x30, 0x4D, 0x06, 0x30, 0xDC,
  0x1F, 0x08, 0x0B, 0xB0, 0x73, 0x04, 0xC0, 0x13, 0x08, 0xC1, 0xD8, 0x39, 0x73, 0x0B, 0xB0, 0x73,
  0x04, 0xB0, 0x23, 0x0A, 0xC1, 0xC0, 0x95, 0x0B, 0xB0, 0x73, 0x04, 0xA8, 0x2C, 0x20, 0x6D, 0x1C,
  0x09, 0x60, 0xBB, 0x07, 0x30, 0x4F, 0xB1, 0xD8, 0x19, 0x73, 0x20, 0x30, 0x8C, 0x07, 0x30, 0x4F,
  0xA1, 0xF0, 0x72, 0x07, 0xE0, 0x73, 0x04, 0xF9, 0x1F, 0x09, 0x20, 0x9F, 0x07, 0x30, 0x4F, 0x1F,
  0x90, 0x09, 0xFA, 0x07, 0x30, 0x4E, 0x1F, 0xFE, 0x07, 0x30, 0x4D, 0x10, 0xDF, 0xFE, 0x07, 0x30,
  0x4B, 0x81, 0xE0, 0x8F, 0xFF, 0x07, 0x30, 0x4A, 0x08, 0x20, 0x80, 0xDF, 0xFE, 0x07, 0x30, 0x40,
  0x87, 0x77, 0x10, 0xBB, 0x07, 0x77, 0x76, 0x0B, 0xB0, 0x77, 0x77, 0x60, 0xBB, 0x07, 0x77, 0x76,
  0x0B, 0xB0, 0x77, 0x77, 0x60, 0xBB, 0x01, 0x77, 0x76, 0x81, 0xBF, 0xD7, 0x77, 0x71, 0x03, 0x01,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_videogame_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 32, 33), Box(0, 0, 35, 35),
      ic_round_36_hardware_videogame_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_videogame_asset 36x36, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_36_hardware_videogame_asset_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0xF8, 0x3B, 0x30, 0x1E, 0xFF, 0xFF, 0xA8, 0x1E, 0x16, 0xFF, 0xFF, 0xC0,
  0x60, 0x7F, 0x81, 0x70, 0x7F, 0xFF, 0x90, 0x07, 0xF3, 0xFF, 0xA8, 0x1A, 0x8D, 0xB0, 0x07, 0xF3,
  0xFF, 0x90, 0x63, 0x0D, 0xA0, 0x07, 0xF3, 0xFF, 0x90, 0x13, 0x08, 0xA0, 0x07, 0xB0, 0x90, 0xF7,
  0x30, 0xF7, 0x09, 0xFC, 0x02, 0x30, 0xAA, 0x00, 0x7A, 0x09, 0x74, 0x09, 0xFB, 0x82, 0xC2, 0x06,
  0xB0, 0x07, 0xA0, 0x97, 0x40, 0x9C, 0x82, 0xC2, 0x06, 0xFA, 0x00, 0x7B, 0x09, 0x0F, 0x73, 0x0F,
  0x70, 0x9D, 0x02, 0x30, 0xAF, 0x90, 0x07, 0xF3, 0xFA, 0x01, 0x30, 0x8F, 0x90, 0x07, 0xF3, 0xFA,
  0x06, 0x30, 0xDF, 0x90, 0x07, 0xF3, 0xFB, 0x81, 0xA8, 0xDF, 0xA0, 0x07, 0xF8, 0x17, 0x07, 0xFF,
  0xF9, 0x07, 0x06, 0xFF, 0xFF, 0xC8, 0x16, 0x1E, 0xFF, 0xFF, 0xA8, 0x3E, 0x10, 0x3B, 0xFF, 0xFF,
  0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_videogame_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 9, 34, 26), Box(0, 0, 35, 35),
      ic_round_36_hardware_videogame_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_watch_off 36x36, 4-bit Alpha,  RLE, 241 bytes.
static const unsigned char ic_round_36_hardware_watch_off_data[] PROGMEM = {
  0x74, 0x81, 0x1A, 0xEC, 0x81, 0xEA, 0x17, 0x40, 0x17, 0x10, 0xCF, 0x90, 0xC7, 0x28, 0x21, 0xDF,
  0x76, 0x03, 0xFB, 0x03, 0x71, 0x03, 0xB0, 0x75, 0x08, 0xFB, 0x08, 0x72, 0x0A, 0xB0, 0x74, 0x0C,
  0xFB, 0x0D, 0x73, 0x0A, 0xB0, 0x73, 0x04, 0xFC, 0x02, 0x73, 0x0A, 0xB0, 0x73, 0x04, 0xFB, 0x07,
  0x74, 0x0A, 0xB0, 0x73, 0x85, 0x4E, 0xA8, 0x8A, 0xEC, 0x04, 0x74, 0x0A, 0xB0, 0x77, 0x20, 0x60,
  0xEB, 0x03, 0x74, 0x0A, 0xB0, 0x77, 0x20, 0x10, 0xCA, 0x0D, 0x74, 0x07, 0xC0, 0x77, 0x20, 0x10,
  0xEA, 0x07, 0x73, 0x0D, 0xD0, 0x77, 0x20, 0x6A, 0x0C, 0x72, 0x02, 0xA0, 0xE0, 0xBB, 0x07, 0x72,
  0x0E, 0xA0, 0x27, 0x10, 0x5A, 0x81, 0xA0, 0xBB, 0x07, 0x71, 0x0A, 0xA0, 0x57, 0x10, 0x7A, 0x08,
  0x20, 0xBB, 0x07, 0x70, 0x8A, 0x06, 0x71, 0x06, 0xA0, 0x83, 0x0B, 0xB0, 0x76, 0x08, 0xA0, 0x77,
  0x10, 0x5A, 0x0A, 0x40, 0xBB, 0x07, 0x50, 0xAA, 0x05, 0x71, 0x02, 0xA0, 0xE5, 0x0B, 0xB0, 0x74,
  0x0E, 0xA0, 0x27, 0x20, 0xCA, 0x06, 0x50, 0xBB, 0x07, 0x38, 0x14, 0xFD, 0x73, 0x07, 0xA0, 0xE0,
  0x15, 0x0B, 0xB0, 0x73, 0x04, 0x06, 0x74, 0x0D, 0xA0, 0xC0, 0x15, 0x0B, 0xB0, 0x77, 0x71, 0x03,
  0xB0, 0xE0, 0x65, 0x0B, 0xB0, 0x77, 0x71, 0x04, 0xC8, 0x4E, 0xA8, 0x8A, 0xEC, 0x07, 0x77, 0x10,
  0x7F, 0xF0, 0x77, 0x70, 0x2F, 0xF9, 0x07, 0x77, 0x0D, 0xFB, 0x0D, 0x0B, 0xB0, 0x77, 0x60, 0x8F,
  0xB8, 0x18, 0x0B, 0xB0, 0x77, 0x50, 0x3F, 0xB0, 0x32, 0x0B, 0xB0, 0x77, 0x50, 0xCF, 0x90, 0xC4,
  0x0B, 0xB0, 0x17, 0x48, 0x11, 0xAE, 0xC8, 0x1E, 0xA1, 0x58, 0x1B, 0xFD, 0x77, 0x77, 0x03, 0x01,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_watch_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 31, 33), Box(0, 0, 35, 35),
      ic_round_36_hardware_watch_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_hardware_watch 36x36, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_round_36_hardware_watch_data[] PROGMEM = {
  0x60, 0x30, 0xBF, 0x90, 0xB0, 0x37, 0x40, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x30, 0x6F, 0xD0, 0x67,
  0x30, 0x9F, 0xD0, 0x97, 0x30, 0xBF, 0xD0, 0xB7, 0x30, 0xEF, 0xD0, 0xE7, 0x20, 0x1F, 0xF0, 0x17,
  0x10, 0x3F, 0xF0, 0x37, 0x10, 0x7F, 0xF0, 0x77, 0x05, 0xC8, 0x1B, 0x62, 0x28, 0x12, 0x6B, 0xC0,
  0x55, 0x05, 0xB0, 0xD0, 0x37, 0x10, 0x30, 0xDB, 0x05, 0x30, 0x10, 0xEA, 0x0B, 0x01, 0x73, 0x01,
  0x0B, 0xA0, 0xE0, 0x12, 0x09, 0xA0, 0xD0, 0x17, 0x50, 0x10, 0xDA, 0x81, 0x90, 0x1B, 0x03, 0x77,
  0x03, 0xB0, 0x10, 0x6A, 0x0B, 0x77, 0x20, 0xBA, 0x06, 0x0A, 0xA0, 0x67, 0x72, 0x06, 0xA0, 0xA0,
  0xCA, 0x02, 0x77, 0x20, 0x2A, 0x0C, 0x0E, 0xA7, 0x74, 0xA0, 0x0E, 0xA7, 0x74, 0xA0, 0xE0, 0xCA,
  0x02, 0x77, 0x20, 0x2A, 0x0C, 0x0A, 0xA0, 0x67, 0x72, 0x06, 0xA0, 0xA0, 0x6A, 0x0B, 0x77, 0x20,
  0xBA, 0x06, 0x01, 0xB0, 0x37, 0x70, 0x3B, 0x81, 0x10, 0x9A, 0x0D, 0x01, 0x75, 0x01, 0x0D, 0xA0,
  0x92, 0x01, 0x0E, 0xA0, 0xB0, 0x17, 0x30, 0x10, 0xBA, 0x0E, 0x01, 0x30, 0x5B, 0x0D, 0x03, 0x71,
  0x03, 0x0D, 0xB0, 0x55, 0x05, 0xC8, 0x1B, 0x62, 0x28, 0x12, 0x6B, 0xC0, 0x57, 0x07, 0xFF, 0x07,
  0x71, 0x03, 0xFF, 0x03, 0x71, 0x01, 0xFF, 0x01, 0x72, 0x0E, 0xFD, 0x0E, 0x73, 0x0B, 0xFD, 0x0B,
  0x73, 0x09, 0xFD, 0x09, 0x73, 0x06, 0xFD, 0x06, 0x73, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x74, 0x03,
  0x0B, 0xF9, 0x0B, 0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_hardware_watch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 29, 35), Box(0, 0, 35, 35),
      ic_round_36_hardware_watch_data, Alpha4(color::Black));
  return value;
}
