#include "communication.h"

using namespace roo_display;

// Image file ic_round_36_communication_3p 36x36, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_36_communication_3p_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x7F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xC3, 0xF8, 0x27, 0x11, 0x7F, 0xFF, 0xC0, 0x74, 0x07, 0xFF, 0xFB, 0x01, 0x40, 0x1F, 0xFF, 0xB0,
  0x14, 0x01, 0xFF, 0xFB, 0x07, 0x40, 0x7F, 0xFF, 0xC8, 0x27, 0x11, 0x78, 0x0E, 0x3F, 0x84, 0xDA,
  0x88, 0xAD, 0xFF, 0xF9, 0x09, 0x02, 0x60, 0x20, 0x9F, 0xFD, 0x08, 0x73, 0x08, 0xFF, 0xC0, 0x17,
  0x30, 0x1F, 0xFC, 0x75, 0x80, 0x9F, 0x4F, 0x0D, 0xFF, 0xFF, 0x90, 0x8F, 0xFF, 0xE0, 0xD0, 0x81,
  0xD0, 0x77, 0x77, 0x3C, 0x07, 0x77, 0x74, 0x0E, 0xA0, 0x77, 0x77, 0x58, 0x16, 0xC6, 0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_3p() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 30), Box(0, 0, 35, 35),
      ic_round_36_communication_3p_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_add_ic_call 36x36, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_round_36_communication_add_ic_call_data[] PROGMEM = {
  0x28, 0x43, 0x77, 0x76, 0x17, 0x58, 0x12, 0x72, 0x60, 0x9D, 0x0E, 0x04, 0x74, 0x81, 0xDF, 0xD5,
  0x03, 0xF0, 0xD7, 0x4B, 0x50, 0x6F, 0x90, 0x17, 0x3B, 0x50, 0x5F, 0x90, 0x37, 0x3B, 0x50, 0x4F,
  0x90, 0x55, 0x02, 0x0D, 0xFA, 0x81, 0xD2, 0x1F, 0x90, 0x75, 0x06, 0xFC, 0x81, 0x60, 0xDF, 0x07,
  0x50, 0x20, 0xDF, 0xA8, 0x2D, 0x20, 0xAF, 0x04, 0x73, 0xB6, 0x05, 0xE0, 0x97, 0x4B, 0x60, 0x1D,
  0x09, 0x75, 0xB7, 0x0A, 0xB0, 0x97, 0x68, 0x1D, 0xFD, 0x70, 0x3B, 0x02, 0x76, 0x81, 0x27, 0x27,
  0x10, 0xBA, 0x0A, 0x77, 0x73, 0x03, 0xB0, 0x47, 0x77, 0x30, 0x9A, 0x0D, 0x01, 0x77, 0x72, 0x01,
  0x0E, 0xA0, 0xC7, 0x77, 0x30, 0x4B, 0x0A, 0x77, 0x73, 0x07, 0xB0, 0xA7, 0x18, 0x43, 0x77, 0x53,
  0x17, 0x30, 0x8B, 0x0C, 0x01, 0x50, 0x9E, 0x0D, 0x04, 0x72, 0x08, 0xB0, 0xD0, 0x43, 0x09, 0xF9,
  0x0E, 0x01, 0x72, 0x07, 0xC8, 0x1A, 0x29, 0xFB, 0x06, 0x73, 0x03, 0x0E, 0xFF, 0x90, 0x77, 0x40,
  0x10, 0x9F, 0xF0, 0x77, 0x60, 0x30, 0xBF, 0xD0, 0x67, 0x71, 0x03, 0x0A, 0xFB, 0x03, 0x77, 0x38,
  0x21, 0x5A, 0xDD, 0x09, 0x77, 0x71, 0x83, 0x13, 0x56, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_add_ic_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_add_ic_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_alternate_email 36x36, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_round_36_communication_alternate_email_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x7B, 0xDD, 0xED, 0xA8, 0x37, 0x74, 0x06, 0x0E, 0xFB, 0x0D, 0x07, 0x77, 0x04,
  0x0D, 0xFF, 0x0D, 0x03, 0x74, 0x07, 0xC8, 0x2E, 0x84, 0x12, 0x82, 0x24, 0x9E, 0xC0, 0x67, 0x20,
  0xAB, 0x0E, 0x06, 0x73, 0x06, 0x0E, 0xB0, 0x77, 0x07, 0xB0, 0xB0, 0x17, 0x50, 0x10, 0xBB, 0x06,
  0x50, 0x4B, 0x09, 0x77, 0x20, 0xAA, 0x0E, 0x02, 0x40, 0xDA, 0x0B, 0x68, 0x41, 0x47, 0x54, 0x16,
  0x0C, 0xA0, 0xC3, 0x06, 0xA0, 0xE0, 0x14, 0x01, 0x08, 0xE0, 0x95, 0x02, 0x0E, 0xA0, 0x42, 0x0D,
  0xA0, 0x64, 0x02, 0x0D, 0xF9, 0x0D, 0x01, 0x40, 0x7A, 0x81, 0xC0, 0x3A, 0x0E, 0x40, 0x10, 0xDB,
  0x82, 0xC9, 0x9C, 0xB0, 0xD4, 0x01, 0xB0, 0x20, 0x7A, 0x08, 0x40, 0x9A, 0x0E, 0x05, 0x40, 0x50,
  0xEA, 0x08, 0x40, 0xAA, 0x06, 0x0B, 0xA0, 0x43, 0x01, 0x0E, 0xA0, 0x56, 0x05, 0xA0, 0xE4, 0x06,
  0xA0, 0xA0, 0xDA, 0x01, 0x30, 0x4A, 0x0C, 0x71, 0x0C, 0xA0, 0x43, 0x02, 0xA0, 0xC0, 0xDA, 0x40,
  0x7A, 0x09, 0x71, 0x09, 0xA0, 0x63, 0x01, 0xA0, 0x0E, 0xA4, 0x06, 0xA0, 0x97, 0x10, 0x9A, 0x07,
  0x4B, 0x0D, 0xA0, 0x13, 0x05, 0xA0, 0xC7, 0x10, 0xCA, 0x07, 0x4B, 0x0B, 0xA0, 0x44, 0x0E, 0xA0,
  0x56, 0x05, 0xB0, 0x83, 0x01, 0xA0, 0xE0, 0x8A, 0x08, 0x40, 0x9A, 0x0E, 0x05, 0x40, 0x50, 0xEB,
  0x0E, 0x01, 0x20, 0x8A, 0x0C, 0x03, 0xA0, 0xE5, 0x0D, 0xB8, 0x2C, 0x99, 0xCE, 0x81, 0xE8, 0xBB,
  0x81, 0x60, 0xDA, 0x06, 0x40, 0x20, 0xDF, 0x90, 0xD0, 0x9F, 0x0C, 0x20, 0x7A, 0x0E, 0x01, 0x48,
  0x11, 0x9E, 0xD8, 0x39, 0x10, 0x6E, 0xC0, 0xA0, 0x13, 0x0D, 0xA0, 0xB7, 0x83, 0x56, 0x74, 0x15,
  0x82, 0x47, 0x62, 0x50, 0x3B, 0x0A, 0x77, 0x75, 0x06, 0xB0, 0xB0, 0x27, 0x77, 0x40, 0x7B, 0x81,
  0xE7, 0x17, 0x77, 0x30, 0x60, 0xEC, 0x82, 0xA6, 0x21, 0x77, 0x70, 0x20, 0xCF, 0xE0, 0xD0, 0x27,
  0x71, 0x04, 0x0C, 0xFD, 0x06, 0x77, 0x38, 0x32, 0x6A, 0xCD, 0xE0, 0xD0, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_alternate_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_alternate_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_app_registration 36x36, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_round_36_communication_app_registration_data[] PROGMEM = {
  0x18, 0x28, 0xDD, 0x85, 0x82, 0x8D, 0xD8, 0x58, 0x28, 0xDD, 0x83, 0x08, 0xC0, 0x83, 0x08, 0xC0,
  0x83, 0x08, 0xC0, 0x82, 0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0xD2, 0x0D, 0xC0, 0xD3,
  0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0xD2, 0x08, 0xC0, 0x83, 0x08, 0xC0, 0x83, 0x08, 0xC0, 0x83, 0x82,
  0x8D, 0xD8, 0x58, 0x28, 0xDD, 0x85, 0x82, 0x8D, 0xD8, 0x80, 0x99, 0x60, 0x82, 0x8D, 0xD8, 0x58,
  0x28, 0xDD, 0x87, 0x81, 0x3D, 0x62, 0x08, 0xC0, 0x83, 0x08, 0xC0, 0x85, 0x03, 0x0E, 0xA8, 0x16,
  0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0xD6, 0x0B, 0xB0, 0x40, 0xDC, 0x0D, 0x30, 0xDC, 0x08, 0x38, 0x73,
  0xD2, 0x0B, 0xFE, 0x28, 0xC0, 0x83, 0x08, 0xB0, 0x83, 0x86, 0x3E, 0xFE, 0x20, 0xB3, 0x28, 0x28,
  0xDD, 0x85, 0x81, 0x8D, 0x83, 0x03, 0x0E, 0xB0, 0xE0, 0x27, 0x74, 0x03, 0x0E, 0xC0, 0xE0, 0x37,
  0x73, 0x03, 0x0E, 0xC0, 0xE0, 0x37, 0x73, 0x03, 0x0E, 0xC0, 0xE0, 0x36, 0x82, 0x8D, 0xD8, 0x70,
  0x30, 0xEC, 0x0E, 0x03, 0x60, 0x8C, 0x08, 0x50, 0x30, 0xEC, 0x0E, 0x03, 0x70, 0xDC, 0x0D, 0x40,
  0x30, 0xEC, 0x0E, 0x03, 0x71, 0x0D, 0xC0, 0xD4, 0x07, 0xC0, 0xE0, 0x37, 0x20, 0x8C, 0x08, 0x40,
  0x7B, 0x0E, 0x03, 0x74, 0x82, 0x8D, 0xD8, 0x50, 0x5A, 0x0E, 0x03, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_app_registration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 31, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_app_registration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_business 36x36, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_round_36_communication_business_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x05, 0x70, 0x60, 0x17, 0x72, 0x03, 0x0E, 0xFC, 0x0E, 0x03, 0x77, 0x10, 0xBF,
  0xE0, 0xB7, 0x71, 0xB0, 0xF7, 0xB0, 0xF7, 0xB7, 0x71, 0xB3, 0xB3, 0xB7, 0x71, 0xB3, 0xB3, 0xB7,
  0x71, 0xB0, 0xF7, 0xB0, 0xF7, 0xB8, 0x09, 0x07, 0x06, 0x01, 0x1F, 0xFF, 0xF0, 0xE0, 0x3F, 0xFF,
  0xF9, 0x0B, 0xB0, 0xF7, 0xB0, 0xF7, 0xB8, 0x06, 0x70, 0x80, 0xDE, 0x3B, 0x3B, 0x74, 0x02, 0xE3,
  0xB3, 0xB7, 0x5E, 0x0F, 0x7B, 0x0F, 0x7B, 0x0F, 0x73, 0x0F, 0x73, 0xFF, 0xF3, 0xB3, 0xFF, 0xF3,
  0xB3, 0xE0, 0xF7, 0xB0, 0xF7, 0xB0, 0xF7, 0x30, 0xF7, 0x3E, 0x3B, 0x3B, 0x75, 0xE3, 0xB3, 0xB7,
  0x5E, 0x0F, 0x7B, 0x0F, 0x7B, 0x0F, 0x73, 0x0F, 0x73, 0xFF, 0xF3, 0xB3, 0xFF, 0xF3, 0xB3, 0xE0,
  0xF7, 0xB0, 0xF7, 0xB0, 0xF7, 0x30, 0xF7, 0x3E, 0x3B, 0x3B, 0x75, 0xE3, 0xB3, 0xB7, 0x40, 0x2E,
  0x0F, 0x7B, 0x0F, 0x7B, 0x80, 0x67, 0x08, 0x0D, 0xB0, 0xBF, 0xFF, 0xF8, 0x1B, 0x3E, 0xFF, 0xFD,
  0x83, 0xE3, 0x01, 0x68, 0x0A, 0x47, 0x06, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_call_end 36x36, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_round_36_communication_call_end_data[] PROGMEM = {
  0x76, 0x89, 0x01, 0x45, 0x77, 0x77, 0x53, 0x17, 0x77, 0x18, 0x21, 0x6A, 0xEF, 0xB8, 0x1D, 0x95,
  0x77, 0x30, 0x40, 0xBF, 0xFC, 0x09, 0x03, 0x75, 0x04, 0x0C, 0xE8, 0x7E, 0xB9, 0x97, 0x79, 0xAC,
  0xF0, 0xB0, 0x27, 0x10, 0x10, 0xAD, 0x81, 0xE6, 0x37, 0x30, 0x30, 0x8E, 0x08, 0x60, 0x50, 0xEE,
  0x0E, 0x76, 0x01, 0xF0, 0xD0, 0x33, 0x08, 0xF9, 0x0E, 0x76, 0x01, 0xF9, 0x82, 0xE5, 0x06, 0xFA,
  0x0E, 0x76, 0x01, 0xFB, 0x03, 0x0C, 0xFA, 0x0D, 0x76, 0x01, 0xFB, 0x09, 0x0C, 0xFA, 0x0A, 0x77,
  0x0D, 0xFA, 0x09, 0x07, 0xF9, 0x0E, 0x02, 0x77, 0x04, 0xFA, 0x81, 0x40, 0xAE, 0x0C, 0x01, 0x77,
  0x20, 0x30, 0xEE, 0x07, 0x30, 0xAC, 0x09, 0x77, 0x50, 0x10, 0xCC, 0x07, 0x58, 0x27, 0xCB, 0x57,
  0x77, 0x18, 0x27, 0xCB, 0x53,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_call_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 10, 35, 23), Box(0, 0, 35, 35),
      ic_round_36_communication_call_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_call_made 36x36, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_round_36_communication_call_made_data[] PROGMEM = {
  0x71, 0x05, 0x80, 0x90, 0x70, 0x57, 0x10, 0x5F, 0xF0, 0x57, 0x05, 0xFF, 0x07, 0x71, 0x05, 0x80,
  0x47, 0x0E, 0xC0, 0x77, 0x72, 0x09, 0xD0, 0x77, 0x71, 0x09, 0xB0, 0xEA, 0x07, 0x77, 0x09, 0xB0,
  0x90, 0x7A, 0x07, 0x76, 0x09, 0xB8, 0x19, 0x07, 0xA0, 0x77, 0x50, 0x9B, 0x09, 0x20, 0x7A, 0x07,
  0x74, 0x09, 0xB0, 0x93, 0x07, 0xA0, 0x77, 0x30, 0x9B, 0x09, 0x40, 0x7A, 0x07, 0x72, 0x09, 0xB0,
  0x95, 0x07, 0xA0, 0x77, 0x10, 0x9B, 0x09, 0x60, 0x7A, 0x07, 0x70, 0x9B, 0x09, 0x70, 0x7A, 0x07,
  0x60, 0x9B, 0x09, 0x71, 0x05, 0xA0, 0x55, 0x09, 0xB0, 0x97, 0x30, 0x05, 0x50, 0x9B, 0x09, 0x77,
  0x30, 0x9B, 0x09, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x30, 0x4B, 0x09, 0x77,
  0x40, 0x3A, 0x09, 0x77, 0x60, 0x30, 0x47, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_call_made() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 7, 28, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_call_made_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_call_merge 36x36, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_round_36_communication_call_merge_data[] PROGMEM = {
  0x71, 0x03, 0x02, 0x77, 0x18, 0x24, 0xFE, 0x47, 0x60, 0x4B, 0x0E, 0x04, 0x74, 0x04, 0xD0, 0xE0,
  0x47, 0x20, 0x4F, 0x0E, 0x04, 0x70, 0x4F, 0xA0, 0xE0, 0x36, 0x08, 0xFB, 0x08, 0x73, 0x07, 0xA0,
  0x77, 0x70, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x77, 0x0A, 0xA0, 0x77, 0x60, 0x9B, 0x06,
  0x75, 0x09, 0xB0, 0x97, 0x50, 0x9B, 0x09, 0x40, 0x57, 0x09, 0xB0, 0x94, 0x81, 0x9F, 0x95, 0x09,
  0xB0, 0x94, 0x05, 0xB0, 0x93, 0x09, 0xB0, 0x96, 0x09, 0xB8, 0x19, 0x08, 0xB0, 0x97, 0x10, 0x9B,
  0x08, 0x0E, 0xA0, 0x97, 0x30, 0x9A, 0x82, 0xE8, 0xE8, 0x75, 0x81, 0x8E, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_call_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 5, 26, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_call_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_call_missed_outgoing 36x36, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_36_communication_call_missed_outgoing_data[] PROGMEM = {
  0x77, 0x10, 0x58, 0x05, 0x78, 0x35, 0x05, 0xD8, 0x74, 0x05, 0xFC, 0x05, 0x0C, 0xA0, 0x97, 0x30,
  0x5F, 0xC0, 0x70, 0x8B, 0x09, 0x73, 0x05, 0x80, 0x17, 0x0E, 0xC8, 0x17, 0x09, 0xB0, 0x97, 0x70,
  0x9D, 0x07, 0x20, 0x9B, 0x09, 0x75, 0x09, 0xB0, 0xEA, 0x07, 0x30, 0x9B, 0x09, 0x73, 0x09, 0xB0,
  0x90, 0x7A, 0x07, 0x40, 0x9B, 0x09, 0x71, 0x09, 0xB8, 0x19, 0x07, 0xA0, 0x75, 0x09, 0xB0, 0x96,
  0x09, 0xB0, 0x92, 0x07, 0xA0, 0x76, 0x09, 0xB0, 0x94, 0x09, 0xB0, 0x93, 0x07, 0xA0, 0x77, 0x09,
  0xB0, 0x92, 0x09, 0xB0, 0x94, 0x07, 0xA0, 0x77, 0x10, 0x9B, 0x00, 0x9B, 0x09, 0x50, 0x5A, 0x05,
  0x72, 0x09, 0xE0, 0x97, 0x00, 0x57, 0x40, 0x9C, 0x09, 0x77, 0x71, 0x09, 0xA0, 0x97, 0x77, 0x30,
  0x05, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_call_missed_outgoing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 10, 31, 25), Box(0, 0, 35, 35),
      ic_round_36_communication_call_missed_outgoing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_call_missed 36x36, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_36_communication_call_missed_data[] PROGMEM = {
  0x10, 0x58, 0x05, 0x70, 0x57, 0x71, 0x05, 0xFC, 0x05, 0x74, 0x82, 0x8C, 0x57, 0xFC, 0x05, 0x73,
  0x09, 0xA0, 0xC0, 0x7C, 0x0E, 0x80, 0x17, 0x05, 0x73, 0x09, 0xB0, 0x80, 0x7D, 0x09, 0x77, 0x09,
  0xB8, 0x19, 0x07, 0xA0, 0xEB, 0x09, 0x75, 0x09, 0xB0, 0x92, 0x07, 0xA0, 0x70, 0x9B, 0x09, 0x73,
  0x09, 0xB0, 0x93, 0x07, 0xA8, 0x17, 0x09, 0xB0, 0x97, 0x10, 0x9B, 0x09, 0x40, 0x7A, 0x07, 0x20,
  0x9B, 0x09, 0x60, 0x9B, 0x09, 0x50, 0x7A, 0x07, 0x30, 0x9B, 0x09, 0x40, 0x9B, 0x09, 0x60, 0x7A,
  0x07, 0x40, 0x9B, 0x09, 0x20, 0x9B, 0x09, 0x70, 0x5A, 0x05, 0x50, 0x9B, 0x00, 0x9B, 0x09, 0x72,
  0x00, 0x57, 0x09, 0xE0, 0x97, 0x76, 0x09, 0xC0, 0x97, 0x77, 0x10, 0x9A, 0x09, 0x77, 0x73, 0x00,
  0x57, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_call_missed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 30, 25), Box(0, 0, 35, 35),
      ic_round_36_communication_call_missed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_call 36x36, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_round_36_communication_call_data[] PROGMEM = {
  0x28, 0x43, 0x77, 0x76, 0x27, 0x77, 0x09, 0xE0, 0x47, 0x75, 0x03, 0xF0, 0xE7, 0x75, 0x06, 0xF9,
  0x02, 0x77, 0x40, 0x5F, 0x90, 0x47, 0x74, 0x03, 0xF9, 0x06, 0x77, 0x40, 0x1F, 0x90, 0x77, 0x75,
  0x0D, 0xF0, 0x77, 0x75, 0x0A, 0xF0, 0x47, 0x75, 0x05, 0xE0, 0x97, 0x76, 0x01, 0xD0, 0x97, 0x77,
  0x10, 0xAB, 0x09, 0x77, 0x72, 0x03, 0xB0, 0x27, 0x77, 0x30, 0xBA, 0x0B, 0x77, 0x73, 0x03, 0xB0,
  0x57, 0x77, 0x30, 0x9A, 0x0E, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xA0, 0xC7, 0x77, 0x30, 0x3B, 0x0B,
  0x77, 0x73, 0x06, 0xB0, 0xB7, 0x18, 0x43, 0x77, 0x54, 0x27, 0x30, 0x8B, 0x0C, 0x01, 0x50, 0x9E,
  0x0D, 0x04, 0x72, 0x08, 0xB0, 0xE0, 0x53, 0x09, 0xFA, 0x02, 0x72, 0x06, 0xC8, 0x1B, 0x29, 0xFB,
  0x06, 0x73, 0x03, 0x0D, 0xFF, 0x90, 0x77, 0x40, 0x10, 0x9F, 0xF0, 0x77, 0x60, 0x30, 0xBF, 0xD0,
  0x77, 0x71, 0x03, 0x0A, 0xFB, 0x03, 0x77, 0x38, 0x21, 0x5A, 0xDD, 0x09, 0x77, 0x71, 0x83, 0x13,
  0x56, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_call_received 36x36, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_round_36_communication_call_received_data[] PROGMEM = {
  0x77, 0x60, 0x40, 0x37, 0x76, 0x09, 0xA0, 0x37, 0x74, 0x09, 0xB0, 0x47, 0x73, 0x09, 0xB0, 0x97,
  0x73, 0x09, 0xB0, 0x97, 0x73, 0x09, 0xB0, 0x97, 0x73, 0x09, 0xB0, 0x95, 0x00, 0x57, 0x30, 0x9B,
  0x09, 0x50, 0x5A, 0x05, 0x71, 0x09, 0xB0, 0x96, 0x07, 0xA0, 0x77, 0x09, 0xB0, 0x97, 0x07, 0xA0,
  0x76, 0x09, 0xB0, 0x97, 0x10, 0x7A, 0x07, 0x50, 0x9B, 0x09, 0x72, 0x07, 0xA0, 0x74, 0x09, 0xB0,
  0x97, 0x30, 0x7A, 0x07, 0x30, 0x9B, 0x09, 0x74, 0x07, 0xA0, 0x72, 0x09, 0xB0, 0x97, 0x50, 0x7A,
  0x81, 0x70, 0x9B, 0x09, 0x76, 0x07, 0xA0, 0x70, 0x9B, 0x09, 0x77, 0x07, 0xA0, 0xEB, 0x09, 0x77,
  0x10, 0x7D, 0x09, 0x77, 0x20, 0x7C, 0x0E, 0x80, 0x47, 0x05, 0x71, 0x07, 0xFF, 0x05, 0x70, 0x5F,
  0xF0, 0x57, 0x10, 0x58, 0x09, 0x07, 0x05, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_call_received() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 6, 29, 28), Box(0, 0, 35, 35),
      ic_round_36_communication_call_received_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_call_split 36x36, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_round_36_communication_call_split_data[] PROGMEM = {
  0x0C, 0xE0, 0xC7, 0x10, 0xCE, 0x0C, 0xF0, 0x77, 0x10, 0x7F, 0xE0, 0x77, 0x30, 0x7F, 0xC0, 0xC7,
  0x50, 0xCF, 0xC0, 0x97, 0x30, 0x9F, 0xA0, 0xCB, 0x09, 0x71, 0x09, 0xB0, 0xCD, 0x81, 0x70, 0x9B,
  0x09, 0x60, 0x9B, 0x81, 0x90, 0x7A, 0x0B, 0x07, 0x30, 0x9B, 0x09, 0x40, 0x8B, 0x09, 0x30, 0x70,
  0xB6, 0x09, 0xB0, 0x93, 0x82, 0x3E, 0xF9, 0x76, 0x09, 0xB0, 0x93, 0x03, 0x08, 0x77, 0x10, 0x9B,
  0x09, 0x77, 0x60, 0x9B, 0x05, 0x77, 0x60, 0xAA, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x60, 0x7A,
  0x07, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x60, 0x7A,
  0x07, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x60, 0x7A,
  0x07, 0x77, 0x68, 0x22, 0xDD, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_call_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 29, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_call_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_cancel_presentation 36x36, 4-bit Alpha,  RLE, 221 bytes.
static const unsigned char ic_round_36_communication_cancel_presentation_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x10, 0x30, 0x46, 0x04, 0x03, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x03, 0xA0,
  0x94, 0x09, 0xA0, 0x37, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x04, 0xB0, 0x92, 0x09, 0xB0, 0x47, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x10, 0x9B, 0x00, 0x9B, 0x09, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x20,
  0x9E, 0x09, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x30, 0x9C, 0x09, 0x73, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x30, 0x9C, 0x09, 0x73, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x20, 0x9E, 0x09, 0x72, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x10, 0x9B, 0x00, 0x9B, 0x09, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x04, 0xB0,
  0x92, 0x09, 0xB0, 0x47, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x03, 0xA0, 0x94, 0x09, 0xA0, 0x37, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x10, 0x30, 0x46, 0x04, 0x03, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77,
  0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00,
  0x7A, 0x09, 0x77, 0x75, 0x09, 0xA0, 0x07, 0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x70, 0x4F, 0xFF,
  0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x30, 0x48, 0x0B, 0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_cancel_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_cancel_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_cell_tower 36x36, 4-bit Alpha,  RLE, 304 bytes.
static const unsigned char ic_round_36_communication_cell_tower_data[] PROGMEM = {
  0x38, 0x19, 0xF6, 0x77, 0x48, 0x16, 0xF9, 0x50, 0x4A, 0x08, 0x77, 0x40, 0x8A, 0x04, 0x38, 0x31,
  0xEF, 0xE1, 0x77, 0x48, 0x31, 0xEF, 0xE1, 0x20, 0x7A, 0x05, 0x20, 0x40, 0x57, 0x50, 0x50, 0x42,
  0x05, 0xA0, 0x72, 0x81, 0xDF, 0xC2, 0x04, 0xA0, 0x27, 0x30, 0x2A, 0x04, 0x28, 0x3D, 0xFD, 0x04,
  0xA0, 0x62, 0x82, 0xDF, 0xE1, 0x73, 0x82, 0x1E, 0xFD, 0x20, 0x6A, 0x04, 0x08, 0xA8, 0x11, 0x05,
  0xA0, 0x64, 0x82, 0x6A, 0xA6, 0x40, 0x7A, 0x81, 0x40, 0x1A, 0x82, 0x8B, 0xFC, 0x28, 0x1A, 0xFE,
  0x40, 0xBC, 0x0B, 0x48, 0x1E, 0xF9, 0x28, 0x4C, 0xFB, 0xDF, 0xA2, 0x81, 0xEF, 0xA3, 0x06, 0xE0,
  0x63, 0x81, 0xAF, 0xD2, 0x84, 0xAF, 0xDE, 0xF9, 0x2A, 0x08, 0x30, 0xAE, 0x0A, 0x30, 0x8A, 0x28,
  0x49, 0xFE, 0xEF, 0x92, 0xA0, 0x83, 0x0A, 0xE0, 0xA3, 0x08, 0xA2, 0x84, 0x9F, 0xED, 0xFA, 0x28,
  0x1E, 0xFA, 0x30, 0x5E, 0x06, 0x38, 0x1A, 0xFE, 0x28, 0x4A, 0xFD, 0xBF, 0xC2, 0x81, 0xAF, 0xE4,
  0x0B, 0xC0, 0xB4, 0x81, 0xEF, 0xA2, 0x82, 0xCF, 0xC8, 0xA8, 0x11, 0x05, 0xA0, 0x73, 0x0A, 0xC0,
  0xA3, 0x06, 0xA8, 0x15, 0x01, 0xA0, 0x80, 0x4A, 0x06, 0x28, 0x2D, 0xFE, 0x12, 0x84, 0xEF, 0xEE,
  0xFE, 0x28, 0x21, 0xEF, 0xD2, 0x06, 0xA8, 0x34, 0x0D, 0xFC, 0x20, 0x4A, 0x81, 0x30, 0x5A, 0x00,
  0xAA, 0x81, 0x50, 0x2A, 0x04, 0x28, 0x1C, 0xFE, 0x20, 0x7A, 0x05, 0x20, 0x40, 0x52, 0x0A, 0xA0,
  0x05, 0xA0, 0xA2, 0x00, 0x42, 0x05, 0xA0, 0x82, 0x83, 0x1E, 0xFE, 0x15, 0x81, 0xEF, 0xE2, 0x81,
  0xEF, 0xE5, 0x83, 0x1E, 0xFE, 0x13, 0x04, 0xA0, 0x84, 0x05, 0xA0, 0xA2, 0x0A, 0xA0, 0x54, 0x09,
  0xA0, 0x55, 0x81, 0x9F, 0x64, 0x0A, 0xA0, 0x52, 0x05, 0xA0, 0xA4, 0x81, 0x6F, 0x97, 0x68, 0x1E,
  0xFE, 0x48, 0x1E, 0xFE, 0x77, 0x50, 0x5A, 0x0A, 0x40, 0xAA, 0x05, 0x77, 0x40, 0xAF, 0xB0, 0xA7,
  0x74, 0x0E, 0xFB, 0x0E, 0x77, 0x30, 0x5F, 0xD0, 0x57, 0x72, 0x0A, 0xA0, 0x56, 0x05, 0xA0, 0xA7,
  0x72, 0x81, 0xDF, 0xE7, 0x18, 0x1E, 0xFD, 0x77, 0x28, 0x17, 0xE6, 0x71, 0x81, 0x6E, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_cell_tower() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_cell_tower_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_cell_wifi 36x36, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_round_36_communication_cell_wifi_data[] PROGMEM = {
  0x78, 0x52, 0x56, 0x76, 0x52, 0x77, 0x38, 0x12, 0x9D, 0xF8, 0x1E, 0xA3, 0x75, 0x02, 0x0A, 0xFE,
  0x0C, 0x03, 0x72, 0x06, 0x0E, 0xB8, 0x7E, 0xA6, 0x53, 0x56, 0x9D, 0xC0, 0x77, 0x04, 0xB0, 0xD0,
  0x67, 0x20, 0x40, 0xCB, 0x07, 0x60, 0x3A, 0x08, 0x76, 0x82, 0x6E, 0xF6, 0x70, 0x30, 0x23, 0x82,
  0x17, 0xCE, 0xA8, 0x1C, 0x82, 0x30, 0x10, 0x37, 0x50, 0x8F, 0xA0, 0x90, 0x17, 0x81, 0x7D, 0x64,
  0x06, 0xC8, 0x1D, 0xBC, 0xC0, 0x96, 0x08, 0xA0, 0xE4, 0x83, 0x4F, 0xE7, 0x14, 0x82, 0x6D, 0xF6,
  0x50, 0x8C, 0x50, 0x17, 0x20, 0x15, 0x08, 0xD7, 0x18, 0x31, 0x68, 0x71, 0x70, 0x8E, 0x71, 0x0C,
  0xB0, 0xE6, 0x08, 0xB0, 0xAB, 0x71, 0x06, 0xB0, 0x85, 0x08, 0xB0, 0xA1, 0xB7, 0x28, 0x16, 0xC7,
  0x50, 0x8B, 0x0A, 0x2B, 0x77, 0x20, 0x8C, 0x3B, 0x77, 0x10, 0x8D, 0x3B, 0x77, 0x08, 0xE3, 0xB7,
  0x60, 0x8F, 0x3B, 0x75, 0x08, 0xF9, 0x3B, 0x74, 0x08, 0xFA, 0x3B, 0x73, 0x08, 0xFB, 0x3B, 0x72,
  0x08, 0xFC, 0x3B, 0x71, 0x08, 0xFD, 0x3B, 0x70, 0x8F, 0xE3, 0xB6, 0x07, 0xFF, 0x3B, 0x50, 0x6F,
  0xFF, 0x50, 0xCF, 0xFF, 0x50, 0x60, 0xEF, 0xFD, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_cell_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_cell_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_chat_bubble_outline 36x36, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_36_communication_chat_bubble_outline_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDB, 0x77,
  0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73,
  0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7,
  0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x10, 0xBF, 0xFF, 0xB0,
  0xDB, 0x0B, 0xFF, 0xFC, 0x08, 0xFF, 0xFE, 0x0D, 0x08, 0x1D, 0x07, 0x77, 0x73, 0xC0, 0x77, 0x77,
  0x40, 0xEA, 0x07, 0x77, 0x75, 0x81, 0x6C, 0x67, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_chat_bubble_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 30), Box(0, 0, 35, 35),
      ic_round_36_communication_chat_bubble_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_chat_bubble 36x36, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_36_communication_chat_bubble_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0x8E, 0x5F, 0x0D, 0xFF, 0xFF, 0x90, 0x8F, 0xFF, 0xE0, 0xD0, 0x81, 0xD0, 0x77, 0x77, 0x3C, 0x07,
  0x77, 0x74, 0xB0, 0x77, 0x77, 0x5A, 0x07, 0x77, 0x76, 0x90, 0x77, 0x77, 0x70, 0x77, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_chat_bubble() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_chat_bubble_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_chat 36x36, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_36_communication_chat_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xB4, 0xF0, 0x77, 0x72, 0x07, 0xFD, 0x77, 0x4F, 0xD0, 0x77, 0x72, 0x07, 0x80, 0xC6, 0xF0, 0xD0,
  0x88, 0x09, 0x27, 0x08, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x2F, 0xD0, 0x27, 0x72, 0x02, 0xFD, 0x0D,
  0x08, 0x80, 0x92, 0x70, 0x80, 0xD8, 0x0C, 0x6F, 0x07, 0x73, 0x07, 0xFF, 0xC7, 0x5F, 0xFC, 0x07,
  0x73, 0x07, 0x80, 0x9F, 0x7F, 0x0D, 0xFF, 0xFF, 0x90, 0x8F, 0xFF, 0xE0, 0xD0, 0x81, 0xD0, 0x77,
  0x77, 0x3C, 0x07, 0x77, 0x74, 0xB0, 0x77, 0x77, 0x5A, 0x07, 0x77, 0x76, 0x90, 0x77, 0x77, 0x70,
  0x77, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_clear_all 36x36, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_36_communication_clear_all_data[] PROGMEM = {
  0x70, 0x58, 0x09, 0x67, 0x05, 0x70, 0x5F, 0xFE, 0x05, 0x60, 0x5F, 0xFE, 0x05, 0x70, 0x58, 0x09,
  0x67, 0x05, 0x80, 0xF1, 0x00, 0x58, 0x09, 0x67, 0x05, 0x70, 0x5F, 0xFE, 0x05, 0x60, 0x5F, 0xFE,
  0x05, 0x70, 0x58, 0x09, 0x67, 0x05, 0x80, 0xF1, 0x00, 0x58, 0x09, 0x67, 0x05, 0x70, 0x5F, 0xFE,
  0x05, 0x60, 0x5F, 0xFE, 0x05, 0x70, 0x58, 0x09, 0x67, 0x05, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_clear_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 31, 25), Box(0, 0, 35, 35),
      ic_round_36_communication_clear_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_comment 36x36, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_36_communication_comment_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xB4, 0xF0, 0x77, 0x72, 0x07, 0xFD, 0x77, 0x4F, 0xD0, 0x77, 0x72, 0x07, 0x80, 0xC6, 0xF0, 0xD0,
  0x88, 0x09, 0x27, 0x08, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x2F, 0xD0, 0x27, 0x72, 0x02, 0xFD, 0x0D,
  0x08, 0x80, 0x92, 0x70, 0x80, 0xD8, 0x0C, 0x6F, 0x07, 0x77, 0x20, 0x7F, 0xD7, 0x74, 0xFD, 0x07,
  0x77, 0x20, 0x78, 0x09, 0xB4, 0xF0, 0xDF, 0xFF, 0xF9, 0x08, 0xFF, 0xFF, 0x91, 0x08, 0x0D, 0xFF,
  0xFE, 0x77, 0x73, 0x07, 0xD7, 0x77, 0x40, 0x7C, 0x77, 0x75, 0x07, 0xB7, 0x77, 0x60, 0x7A, 0x77,
  0x77, 0x07, 0x97, 0x77, 0x71, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_comments_disabled 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_round_36_communication_comments_disabled_data[] PROGMEM = {
  0x10, 0x10, 0x23, 0x04, 0xFF, 0xF9, 0x85, 0xD8, 0x01, 0xEF, 0x73, 0x04, 0xFF, 0xFA, 0x08, 0x04,
  0xB0, 0x73, 0x04, 0xFF, 0xF9, 0x81, 0xD0, 0xBB, 0x07, 0x30, 0x4F, 0xFF, 0x92, 0xC0, 0x73, 0x04,
  0xFF, 0xF2, 0xD0, 0x73, 0x04, 0xFF, 0xE2, 0xE0, 0x77, 0x72, 0x07, 0xE2, 0xF0, 0x77, 0x72, 0xE2,
  0xF9, 0x07, 0x77, 0x07, 0xE2, 0xFA, 0x07, 0x30, 0x4F, 0xFA, 0x2F, 0xB0, 0x73, 0x03, 0x80, 0x37,
  0x08, 0x0D, 0xE2, 0xE0, 0x20, 0xBB, 0x07, 0x74, 0x02, 0xE2, 0xE8, 0x12, 0x0B, 0xB0, 0x77, 0x30,
  0x2E, 0x2E, 0x81, 0xD8, 0x8C, 0x07, 0x48, 0x00, 0x70, 0x80, 0xDE, 0x2F, 0xF0, 0x73, 0x04, 0xFC,
  0x2E, 0x07, 0x40, 0xBB, 0x07, 0x70, 0x7E, 0x2E, 0x60, 0xBB, 0x07, 0x7E, 0x2E, 0x07, 0x60, 0xBB,
  0x07, 0x50, 0x7E, 0x2F, 0xFC, 0x07, 0x30, 0x4F, 0x2F, 0xFD, 0x07, 0x30, 0x4E, 0x2F, 0xFE, 0x07,
  0x30, 0x4D, 0x20, 0xDF, 0xFE, 0x07, 0x30, 0x4C, 0x20, 0x8F, 0xFF, 0x07, 0x30, 0x4B, 0x30, 0x80,
  0xDF, 0xFE, 0x07, 0x30, 0x4A, 0x77, 0x71, 0x0B, 0xB0, 0x73, 0x04, 0x97, 0x77, 0x20, 0xBB, 0x07,
  0x30, 0x47, 0x77, 0x30, 0xBB, 0x07, 0x77, 0x77, 0x0B, 0xB0, 0x77, 0x77, 0x70, 0xBB, 0x07, 0x77,
  0x77, 0x0B, 0xB0, 0x27, 0x77, 0x78, 0x2B, 0xFE, 0x17, 0x77, 0x71, 0x04, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_comments_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 32, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_comments_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_contact_emergency 36x36, 4-bit Alpha,  RLE, 156 bytes.
static const unsigned char ic_round_36_communication_contact_emergency_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0B, 0x27, 0x83, 0x61, 0x03, 0xEF, 0xFF, 0xFC, 0x81, 0xE3, 0xBF, 0xFF, 0xFE,
  0x0B, 0x80, 0x9B, 0x6F, 0x00, 0x3F, 0xFF, 0xFB, 0x0F, 0xD2, 0x81, 0xDC, 0xDF, 0xFF, 0xF8, 0x11,
  0x04, 0x28, 0x13, 0x01, 0xFF, 0xA8, 0x38, 0x30, 0x38, 0xF0, 0x46, 0x04, 0xFF, 0x90, 0x35, 0x03,
  0xF0, 0x54, 0x05, 0xFF, 0x90, 0x87, 0x08, 0xD0, 0x56, 0x04, 0xFF, 0x03, 0x70, 0x3D, 0x81, 0x10,
  0x32, 0x81, 0x40, 0x1F, 0xF7, 0x2D, 0x81, 0xDC, 0xD2, 0x0F, 0xDF, 0xF0, 0x37, 0x03, 0xF9, 0x00,
  0x3F, 0xFB, 0x08, 0x70, 0x8F, 0xFF, 0xF0, 0x35, 0x03, 0xFF, 0xFF, 0xA8, 0x38, 0x30, 0x38, 0x80,
  0xF6, 0xF8, 0x5D, 0xA8, 0x78, 0xAD, 0xFF, 0xFE, 0x09, 0x03, 0x70, 0x30, 0x9F, 0xFF, 0xA0, 0xB0,
  0x27, 0x40, 0x20, 0xBF, 0xFE, 0x09, 0x77, 0x10, 0x9F, 0xFC, 0x09, 0x77, 0x30, 0x9F, 0xFA, 0x0C,
  0x77, 0x50, 0xCF, 0xF9, 0x09, 0x80, 0x97, 0x70, 0x9F, 0xC0, 0xE0, 0xBF, 0xFF, 0xFE, 0x81, 0xB3,
  0xEF, 0xFF, 0xFC, 0x83, 0xE3, 0x01, 0x68, 0x0B, 0x27, 0x06, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_contact_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 35, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_contact_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_contact_mail 36x36, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_round_36_communication_contact_mail_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0B, 0x27, 0x83, 0x61, 0x03, 0xEF, 0xFF, 0xFC, 0x81, 0xE3, 0xBF, 0xFF, 0xFE,
  0x0B, 0x80, 0x99, 0x5F, 0x84, 0xC5, 0x11, 0x5C, 0xE0, 0x27, 0x30, 0x2F, 0xC0, 0xA6, 0x0A, 0xD1,
  0x02, 0x71, 0x02, 0x1F, 0xB0, 0xE0, 0x16, 0x01, 0x0E, 0xC1, 0x81, 0x7C, 0x24, 0x81, 0x2C, 0x71,
  0xFB, 0x0A, 0x71, 0x0A, 0xC1, 0x82, 0x1A, 0xF7, 0x28, 0x27, 0xFA, 0x11, 0xFB, 0x08, 0x71, 0x08,
  0xC3, 0x84, 0x5E, 0xCC, 0xE5, 0x3F, 0xB0, 0xA7, 0x10, 0xAC, 0x48, 0x21, 0x99, 0x14, 0xFB, 0x0E,
  0x01, 0x60, 0x10, 0xEC, 0x75, 0xFC, 0x0A, 0x60, 0xAD, 0x75, 0xFD, 0x84, 0xC5, 0x11, 0x5C, 0xE0,
  0x27, 0x30, 0x28, 0x09, 0xA1, 0xF8, 0x1E, 0xDD, 0xFF, 0xFF, 0xA8, 0x1B, 0x62, 0x48, 0x22, 0x5A,
  0xEF, 0xFF, 0x90, 0xE0, 0x77, 0x50, 0x70, 0xEF, 0xFD, 0x0D, 0x02, 0x77, 0x02, 0x0D, 0xFF, 0xC0,
  0x47, 0x72, 0x04, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x74, 0x80, 0x9A, 0x2F, 0x0E, 0x0B, 0xFF, 0xFF,
  0xE8, 0x1B, 0x3E, 0xFF, 0xFF, 0xC8, 0x3E, 0x30, 0x16, 0x80, 0xB2, 0x70, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_contact_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 35, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_contact_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_contact_phone 36x36, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_round_36_communication_contact_phone_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0B, 0x27, 0x83, 0x61, 0x03, 0xEF, 0xFF, 0xFC, 0x81, 0xE3, 0xBF, 0xFF, 0xFE,
  0x0B, 0x80, 0x99, 0x5F, 0x84, 0xC5, 0x11, 0x5C, 0xFD, 0x81, 0xC5, 0xDF, 0xF0, 0xA6, 0x0A, 0xFB,
  0x83, 0xD1, 0x01, 0xDF, 0xD0, 0xE0, 0x16, 0x01, 0x0E, 0xF9, 0x0E, 0x02, 0x30, 0x10, 0xEF, 0xC0,
  0xA7, 0x10, 0xAF, 0x90, 0x75, 0x0D, 0xFC, 0x08, 0x71, 0x08, 0xF0, 0xE5, 0x09, 0xFD, 0x0A, 0x71,
  0x0A, 0xF0, 0x94, 0x06, 0xFE, 0x0E, 0x01, 0x60, 0x10, 0xEF, 0x81, 0x40, 0x5F, 0xFB, 0x0A, 0x60,
  0xAF, 0x98, 0x11, 0x09, 0xFF, 0xC8, 0x4C, 0x51, 0x15, 0xCF, 0xA2, 0x0A, 0xFF, 0xFF, 0xD2, 0x0A,
  0xFF, 0xFF, 0xD8, 0x11, 0x09, 0xFF, 0xD8, 0x1E, 0xDD, 0xFC, 0x81, 0x40, 0x5F, 0xFA, 0x81, 0xB6,
  0x24, 0x82, 0x25, 0xAE, 0xE0, 0x94, 0x06, 0xFB, 0x0E, 0x07, 0x75, 0x07, 0x0E, 0xC0, 0xE5, 0x09,
  0xF9, 0x0D, 0x02, 0x77, 0x02, 0x0D, 0xC0, 0x75, 0x0D, 0xF0, 0x47, 0x72, 0x04, 0xC0, 0xE0, 0x23,
  0x02, 0x0E, 0xF7, 0x74, 0xD8, 0x3D, 0x10, 0x2D, 0xF9, 0x77, 0x4E, 0x81, 0xD5, 0xD8, 0x09, 0x91,
  0xF0, 0xE0, 0xBF, 0xFF, 0xFE, 0x81, 0xB3, 0xEF, 0xFF, 0xFC, 0x83, 0xE3, 0x01, 0x68, 0x0B, 0x27,
  0x06, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_contact_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 35, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_contact_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_contacts 36x36, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_round_36_communication_contacts_data[] PROGMEM = {
  0x30, 0x8F, 0xFF, 0x90, 0x86, 0x0E, 0xFF, 0xF9, 0x0E, 0x60, 0x8F, 0xFF, 0x90, 0x88, 0x09, 0xB2,
  0x00, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x0C,
  0x7F, 0x82, 0x83, 0x38, 0xFF, 0xFC, 0x05, 0x40, 0x5F, 0xFF, 0xA0, 0xC6, 0x0C, 0xFF, 0xF9, 0x0A,
  0x60, 0xAF, 0xFF, 0x90, 0xC6, 0x0C, 0xFF, 0xFA, 0x05, 0x40, 0x5F, 0xFF, 0xC8, 0x28, 0x33, 0x88,
  0x09, 0xA1, 0xF8, 0x4C, 0x97, 0x8A, 0xCF, 0xFF, 0x81, 0xC5, 0x16, 0x81, 0x15, 0xCF, 0xFB, 0x07,
  0x75, 0x07, 0xFF, 0x90, 0xB7, 0x70, 0xBF, 0xF0, 0x77, 0x70, 0x7F, 0xF0, 0x77, 0x70, 0x7F, 0xF0,
  0xB8, 0x09, 0x27, 0x0B, 0x80, 0xC1, 0xF0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28, 0x08,
  0xDF, 0xFF, 0xB0, 0xD0, 0x88, 0x09, 0xB2, 0x00, 0x8F, 0xFF, 0x90, 0x86, 0x0E, 0xFF, 0xF9, 0x0E,
  0x60, 0x8F, 0xFF, 0x90, 0x83,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 32, 35), Box(0, 0, 35, 35),
      ic_round_36_communication_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_co_present 36x36, 4-bit Alpha,  RLE, 227 bytes.
static const unsigned char ic_round_36_communication_co_present_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xA0, 0xB8, 0x0A, 0x67, 0x0B, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x58,
  0x52, 0x9D, 0xFD, 0x92, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x06, 0xF0, 0x67, 0x60, 0x7A, 0x00,
  0x7A, 0x07, 0x30, 0x5F, 0xA0, 0x57, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x30, 0xDF, 0xA0, 0xD7, 0x50,
  0x7A, 0x00, 0x7A, 0x07, 0x20, 0x4F, 0xC0, 0x47, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x6F, 0xC0,
  0x67, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x6F, 0xC0, 0x67, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x20,
  0x4F, 0xC0, 0x47, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x30, 0xDF, 0xA0, 0xD7, 0x50, 0x7A, 0x00, 0x7A,
  0x07, 0x30, 0x5F, 0xA0, 0x57, 0x50, 0x7A, 0x83, 0x73, 0x77, 0x34, 0x06, 0xF0, 0x67, 0x60, 0x7A,
  0x07, 0x72, 0x85, 0x29, 0xDF, 0xD9, 0x27, 0x70, 0x7A, 0x07, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x71,
  0x87, 0x14, 0x56, 0x76, 0x54, 0x17, 0x60, 0x7A, 0x07, 0x58, 0x13, 0x8D, 0xFA, 0x81, 0xD8, 0x37,
  0x30, 0x7A, 0x07, 0x30, 0x60, 0xDF, 0xF9, 0x0D, 0x06, 0x71, 0x07, 0xA8, 0x27, 0x01, 0xCF, 0xFD,
  0x0C, 0x01, 0x60, 0x7A, 0x81, 0x70, 0xCF, 0xFF, 0x0C, 0x60, 0x7A, 0x07, 0x04, 0xFF, 0xFA, 0x04,
  0x50, 0x7A, 0x00, 0x7F, 0xFF, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xFF, 0xFA, 0x07, 0x50, 0x7A, 0x04,
  0x07, 0xFF, 0xFA, 0x07, 0x58, 0x37, 0xF9, 0x07, 0xFF, 0xFA, 0x07, 0x50, 0x30, 0x42, 0x07, 0xFF,
  0xFA, 0x07, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_co_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_co_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_desktop_access_disabled 36x36, 4-bit Alpha,  RLE, 328 bytes.
static const unsigned char ic_round_36_communication_desktop_access_disabled_data[] PROGMEM = {
  0x81, 0x15, 0x17, 0x77, 0x74, 0x82, 0xCF, 0xE2, 0x30, 0xAF, 0xFF, 0xB8, 0x2B, 0x30, 0xDA, 0x0E,
  0x02, 0x30, 0xAF, 0xFF, 0xB8, 0x2E, 0x13, 0xEA, 0x0E, 0x02, 0x30, 0xAF, 0xFF, 0xB8, 0x15, 0x07,
  0xB0, 0xE0, 0x27, 0x77, 0x20, 0x20, 0xDA, 0x81, 0x70, 0x7C, 0x0E, 0x02, 0x77, 0x72, 0x08, 0xA8,
  0x17, 0x07, 0xD0, 0xE0, 0x27, 0x77, 0x10, 0x7A, 0x81, 0x70, 0x7A, 0x0A, 0x0E, 0xA0, 0xE0, 0x27,
  0x77, 0x07, 0xA8, 0x17, 0x07, 0xA8, 0x17, 0x3E, 0xA0, 0xE0, 0x27, 0x76, 0x07, 0xA8, 0x17, 0x07,
  0xA8, 0x27, 0x03, 0xEA, 0x0E, 0x02, 0x77, 0x50, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x20, 0x30, 0xEA,
  0x0E, 0x02, 0x77, 0x40, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x30, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x30,
  0x7A, 0x81, 0x70, 0x7A, 0x07, 0x40, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x20, 0x7A, 0x81, 0x70, 0x7A,
  0x07, 0x50, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x10, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x60, 0x30, 0xEA,
  0x0E, 0x02, 0x77, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x77, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x60, 0x7A,
  0x81, 0x70, 0x7A, 0x07, 0x71, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x50, 0x7A, 0x81, 0x70, 0x7A, 0x07,
  0x72, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x40, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x73, 0x03, 0x0E, 0xA0,
  0xE0, 0x27, 0x30, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x74, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x20, 0x7A,
  0x81, 0x70, 0x7A, 0x07, 0x75, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x10, 0x8A, 0x81, 0x70, 0x7A, 0x0D,
  0x02, 0x75, 0x03, 0x0E, 0xA0, 0xE0, 0x26, 0x02, 0x0D, 0xA8, 0x17, 0x06, 0xFF, 0xF0, 0xE0, 0x23,
  0x0A, 0xD8, 0x25, 0x01, 0xEF, 0xFF, 0x0E, 0x02, 0x30, 0xAB, 0x0E, 0x01, 0x20, 0x30, 0xBF, 0xFF,
  0x0E, 0x02, 0x38, 0x2A, 0xFB, 0x37, 0x72, 0xE1, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x77, 0x1E, 0x20,
  0x30, 0xEA, 0x0E, 0x02, 0x77, 0x7E, 0x30, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x30, 0x8F, 0xB8, 0x28,
  0x03, 0xEA, 0x0E, 0x02, 0x77, 0x20, 0xEF, 0xB0, 0xE2, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x71, 0x08,
  0xFB, 0x08, 0x30, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x77, 0x20, 0x30, 0xEA, 0x0B, 0x77, 0x77, 0x38,
  0x23, 0xEF, 0x97, 0x77, 0x74, 0x01, 0x05, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_desktop_access_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 34, 35), Box(0, 0, 35, 35),
      ic_round_36_communication_desktop_access_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_dialer_sip 36x36, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_36_communication_dialer_sip_data[] PROGMEM = {
  0x28, 0x43, 0x77, 0x76, 0x16, 0x89, 0x65, 0x77, 0x71, 0x05, 0x10, 0x47, 0x77, 0x10, 0x9D, 0x0E,
  0x04, 0x5C, 0x82, 0x50, 0xF7, 0x1C, 0x07, 0x03, 0xF0, 0xD5, 0x90, 0x74, 0x98, 0x67, 0x0F, 0x70,
  0xF7, 0x6F, 0x90, 0x14, 0x98, 0x94, 0xB7, 0x71, 0x0F, 0x70, 0xFB, 0x7F, 0x75, 0xF9, 0x03, 0x40,
  0xCB, 0x82, 0x70, 0xF7, 0x1C, 0x05, 0x04, 0xF9, 0x05, 0x79, 0x85, 0x70, 0xF7, 0x0F, 0x73, 0x01,
  0xF9, 0x07, 0x48, 0x91, 0x57, 0x7F, 0x70, 0xF7, 0x0F, 0x74, 0x0D, 0xF0, 0x74, 0x0C, 0xB8, 0x55,
  0x0C, 0x50, 0xC5, 0x40, 0xAF, 0x04, 0x77, 0x50, 0x5E, 0x09, 0x77, 0x60, 0x1D, 0x09, 0x77, 0x71,
  0x0A, 0xB0, 0x97, 0x77, 0x20, 0x3B, 0x02, 0x77, 0x73, 0x0B, 0xA0, 0xA7, 0x77, 0x30, 0x3B, 0x04,
  0x77, 0x73, 0x09, 0xA0, 0xD0, 0x17, 0x77, 0x20, 0x10, 0xEA, 0x0C, 0x77, 0x73, 0x04, 0xB0, 0xA7,
  0x77, 0x30, 0x7B, 0x0A, 0x71, 0x84, 0x37, 0x75, 0x31, 0x73, 0x08, 0xB0, 0xC0, 0x15, 0x09, 0xE0,
  0xD0, 0x47, 0x20, 0x8B, 0x0D, 0x04, 0x30, 0x9F, 0x90, 0xE0, 0x17, 0x20, 0x7C, 0x81, 0xA2, 0x9F,
  0xB0, 0x67, 0x30, 0x30, 0xEF, 0xF9, 0x07, 0x74, 0x01, 0x09, 0xFF, 0x07, 0x76, 0x03, 0x0B, 0xFD,
  0x06, 0x77, 0x10, 0x30, 0xAF, 0xB0, 0x37, 0x73, 0x82, 0x15, 0xAD, 0xD0, 0x97, 0x77, 0x18, 0x31,
  0x35, 0x63, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_dialer_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_dialer_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_dialpad 36x36, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_round_36_communication_dialpad_data[] PROGMEM = {
  0x18, 0x21, 0x66, 0x15, 0x82, 0x16, 0x61, 0x58, 0x51, 0x66, 0x10, 0x3E, 0xA0, 0xE0, 0x33, 0x03,
  0x0E, 0xA0, 0xE0, 0x33, 0x03, 0x0E, 0xA8, 0x1E, 0x3B, 0xC0, 0xB3, 0x0B, 0xC0, 0xB3, 0x0B, 0xC0,
  0xB0, 0xEC, 0x0E, 0x30, 0xEC, 0x0E, 0x30, 0xEC, 0x0E, 0x0B, 0xC0, 0xB3, 0x0B, 0xC0, 0xB3, 0x0B,
  0xC8, 0x1B, 0x3E, 0xA0, 0xE0, 0x33, 0x03, 0x0E, 0xA0, 0xE0, 0x33, 0x03, 0x0E, 0xA8, 0x5E, 0x30,
  0x16, 0x61, 0x58, 0x21, 0x66, 0x15, 0x82, 0x16, 0x61, 0x80, 0xD6, 0x08, 0x21, 0x66, 0x15, 0x82,
  0x16, 0x61, 0x58, 0x51, 0x66, 0x10, 0x3E, 0xA0, 0xE0, 0x33, 0x03, 0x0E, 0xA0, 0xE0, 0x33, 0x03,
  0x0E, 0xA8, 0x1E, 0x3B, 0xC0, 0xB3, 0x0B, 0xC0, 0xB3, 0x0B, 0xC0, 0xB0, 0xEC, 0x0E, 0x30, 0xEC,
  0x0E, 0x30, 0xEC, 0x0E, 0x0B, 0xC0, 0xB3, 0x0B, 0xC0, 0xB3, 0x0B, 0xC8, 0x1B, 0x3E, 0xA0, 0xE0,
  0x33, 0x03, 0x0E, 0xA0, 0xE0, 0x33, 0x03, 0x0E, 0xA8, 0x5E, 0x30, 0x16, 0x61, 0x58, 0x21, 0x66,
  0x15, 0x82, 0x16, 0x61, 0x80, 0xD6, 0x08, 0x21, 0x66, 0x15, 0x82, 0x16, 0x61, 0x58, 0x51, 0x66,
  0x10, 0x3E, 0xA0, 0xE0, 0x33, 0x03, 0x0E, 0xA0, 0xE0, 0x33, 0x03, 0x0E, 0xA8, 0x1E, 0x3B, 0xC0,
  0xB3, 0x0B, 0xC0, 0xB3, 0x0B, 0xC0, 0xB0, 0xEC, 0x0E, 0x30, 0xEC, 0x0E, 0x30, 0xEC, 0x0E, 0x0B,
  0xC0, 0xB3, 0x0B, 0xC0, 0xB3, 0x0B, 0xC8, 0x1B, 0x3E, 0xA0, 0xE0, 0x33, 0x03, 0x0E, 0xA0, 0xE0,
  0x33, 0x03, 0x0E, 0xA8, 0x5E, 0x30, 0x16, 0x61, 0x58, 0x21, 0x66, 0x15, 0x82, 0x16, 0x61, 0x80,
  0xE7, 0x08, 0x21, 0x66, 0x17, 0x75, 0x03, 0x0E, 0xA0, 0xE0, 0x37, 0x74, 0x0B, 0xC0, 0xB7, 0x74,
  0x0E, 0xC0, 0xE7, 0x74, 0x0B, 0xC0, 0xB7, 0x74, 0x03, 0x0E, 0xA0, 0xE0, 0x37, 0x75, 0x82, 0x16,
  0x61, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_dialpad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 29, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_dialpad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_document_scanner 36x36, 4-bit Alpha,  RLE, 218 bytes.
static const unsigned char ic_round_36_communication_document_scanner_data[] PROGMEM = {
  0x02, 0x80, 0x17, 0x05, 0x77, 0x20, 0x58, 0x01, 0x70, 0x20, 0xDE, 0x05, 0x77, 0x05, 0xE0, 0xDF,
  0x05, 0x77, 0x05, 0xFB, 0x0F, 0x70, 0x57, 0x72, 0x05, 0x0F, 0x7E, 0x77, 0x73, 0xE2, 0x03, 0x0B,
  0xFF, 0xA0, 0xB0, 0x32, 0xE1, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x11, 0xB8, 0x38, 0xE8, 0x06, 0xFF,
  0xE8, 0x36, 0x08, 0xE8, 0x40, 0x7F, 0xFE, 0x07, 0x71, 0x07, 0xFF, 0xE0, 0x77, 0x10, 0x7F, 0xFE,
  0x07, 0x71, 0x07, 0xD0, 0xD0, 0x26, 0x02, 0x0D, 0xD0, 0x77, 0x10, 0x7D, 0x08, 0x71, 0x08, 0xD0,
  0x77, 0x10, 0x7D, 0x0D, 0x02, 0x60, 0x20, 0xDD, 0x07, 0x71, 0x07, 0xFF, 0xE0, 0x77, 0x10, 0x7E,
  0x09, 0x80, 0x27, 0x09, 0xE0, 0x77, 0x10, 0x7D, 0x09, 0x71, 0x09, 0xD0, 0x77, 0x10, 0x7D, 0x09,
  0x71, 0x09, 0xD0, 0x77, 0x10, 0x7E, 0x09, 0x80, 0x27, 0x09, 0xE0, 0x77, 0x10, 0x7F, 0xFE, 0x07,
  0x71, 0x07, 0xD0, 0xD0, 0x26, 0x02, 0x0D, 0xD0, 0x77, 0x10, 0x7D, 0x08, 0x71, 0x08, 0xD0, 0x77,
  0x10, 0x7D, 0x0D, 0x02, 0x60, 0x20, 0xDD, 0x07, 0x71, 0x07, 0xFF, 0xE0, 0x77, 0x10, 0x7F, 0xFE,
  0x07, 0x71, 0x07, 0xFF, 0xE0, 0x74, 0x83, 0x8E, 0x80, 0x6F, 0xFE, 0x83, 0x60, 0x8E, 0x8B, 0x10,
  0x10, 0xEF, 0xFC, 0x0E, 0x01, 0x1E, 0x20, 0x30, 0xBF, 0xFA, 0x0B, 0x03, 0x2E, 0x77, 0x73, 0xE0,
  0xF7, 0x05, 0x77, 0x20, 0x50, 0xF7, 0xFB, 0x05, 0x77, 0x05, 0xF0, 0xDE, 0x05, 0x77, 0x05, 0xE0,
  0xD0, 0x28, 0x01, 0x70, 0x57, 0x72, 0x05, 0x80, 0x17, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_document_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_document_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_domain_disabled 36x36, 4-bit Alpha,  RLE, 247 bytes.
static const unsigned char ic_round_36_communication_domain_disabled_data[] PROGMEM = {
  0x18, 0x1A, 0xB2, 0x77, 0x77, 0x10, 0x4A, 0x0E, 0x02, 0x30, 0x38, 0x02, 0x70, 0x60, 0x17, 0x72,
  0x01, 0x0E, 0xA0, 0xE0, 0x23, 0x0A, 0xE0, 0xE0, 0x37, 0x72, 0x03, 0x0E, 0xA0, 0xE0, 0x23, 0x0A,
  0xE0, 0xB7, 0x73, 0x03, 0xB0, 0xE0, 0x23, 0x0A, 0x0F, 0x7B, 0x77, 0x4C, 0x0E, 0x02, 0x6B, 0x77,
  0x4D, 0x0E, 0x02, 0x5B, 0x77, 0x4E, 0x0E, 0x02, 0x30, 0x3B, 0x80, 0x90, 0x70, 0x60, 0x14, 0xF0,
  0xE0, 0x23, 0x0A, 0xFF, 0x90, 0xE0, 0x33, 0xF9, 0x0E, 0x02, 0x30, 0xAF, 0xF9, 0x0B, 0x3B, 0x0F,
  0x7B, 0x0E, 0x02, 0x30, 0xA8, 0x06, 0x70, 0x80, 0xDB, 0x3B, 0x3C, 0x0E, 0x02, 0x77, 0x02, 0xB3,
  0xB3, 0xD0, 0xE0, 0x27, 0x7B, 0x3B, 0x0F, 0x7E, 0x0E, 0x02, 0x70, 0xF7, 0x3B, 0x3F, 0xE0, 0xE0,
  0x26, 0xB3, 0xB3, 0xFF, 0x0E, 0x02, 0x5B, 0x3B, 0x3B, 0x0F, 0x7B, 0x0F, 0x7B, 0x0E, 0x02, 0x40,
  0xF7, 0x3B, 0x3B, 0x3B, 0x3C, 0x0E, 0x02, 0x72, 0xB3, 0xB3, 0xB3, 0xD0, 0xE0, 0x27, 0x1B, 0x3B,
  0x0F, 0x7B, 0x0F, 0x7E, 0x0E, 0x02, 0x7B, 0x3F, 0xFD, 0x0E, 0x02, 0x6B, 0x3F, 0xFE, 0x0E, 0x02,
  0x5B, 0x3B, 0x0F, 0x7B, 0x0F, 0x7B, 0x0F, 0x70, 0xEA, 0x0E, 0x02, 0x4B, 0x3B, 0x3B, 0x3B, 0x30,
  0x30, 0xEA, 0x0E, 0x02, 0x30, 0xAA, 0x3B, 0x3B, 0x3B, 0x40, 0x30, 0xEA, 0x0E, 0x02, 0x30, 0xA9,
  0x3B, 0x0F, 0x7B, 0x0F, 0x7B, 0x80, 0x17, 0x0A, 0xB0, 0xE0, 0x23, 0x0A, 0x30, 0xBF, 0xFF, 0xB0,
  0xE0, 0x26, 0x03, 0x0E, 0xFF, 0xFB, 0x0E, 0x02, 0x60, 0x10, 0x68, 0x0A, 0x17, 0x0E, 0xA0, 0xE0,
  0x27, 0x77, 0x70, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x77, 0x03, 0x0E, 0xA0, 0xB7, 0x77, 0x71, 0x82,
  0x3E, 0xF9, 0x77, 0x77, 0x20, 0x10, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_domain_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 32, 35), Box(0, 0, 35, 35),
      ic_round_36_communication_domain_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_domain_verification 36x36, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_round_36_communication_domain_verification_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0x98, 0x3B, 0x30, 0x1E, 0xFF, 0xFB, 0x81, 0xE1, 0x6F, 0xFF, 0xD0, 0x60,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x15, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x68, 0x18, 0xFD, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x75, 0x08, 0xB0, 0x33, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x40, 0x8B, 0x0A, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x48, 0x1B, 0xE5, 0x30, 0x8B, 0x0A, 0x50,
  0x7A, 0x00, 0x7A, 0x07, 0x30, 0x3B, 0x81, 0x50, 0x8B, 0x0A, 0x60, 0x7A, 0x00, 0x7A, 0x07, 0x40,
  0xCB, 0x0B, 0xB0, 0xA7, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x01, 0x0C, 0xD0, 0xA7, 0x10, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x10, 0xCB, 0x0A, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x76, 0x82, 0x1C, 0xFA, 0x73,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x17, 0x40, 0x7A, 0x00, 0x7A, 0x08, 0x77, 0x60, 0x8A, 0x00,
  0x7A, 0x0D, 0x02, 0x77, 0x40, 0x20, 0xDA, 0x07, 0x06, 0xFF, 0xFD, 0x81, 0x61, 0xEF, 0xFF, 0xB8,
  0x3E, 0x10, 0x3B, 0xFF, 0xF9, 0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_domain_verification() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_domain_verification_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_duo 36x36, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_round_36_communication_duo_data[] PROGMEM = {
  0x73, 0x83, 0x38, 0xBD, 0xEF, 0xD0, 0xD0, 0x87, 0x20, 0x60, 0xDF, 0xFD, 0x08, 0x60, 0x40, 0xDF,
  0xFF, 0x0D, 0x50, 0x6F, 0xFF, 0xB4, 0x08, 0xFF, 0xFC, 0x30, 0x6F, 0xFF, 0xD2, 0x03, 0xFF, 0xFE,
  0x20, 0xCF, 0xFF, 0xE1, 0x05, 0xFF, 0xFF, 0x10, 0xCF, 0xFF, 0xF0, 0x2E, 0x0B, 0x80, 0x67, 0xC0,
  0xCF, 0x07, 0xE0, 0x77, 0x3A, 0x81, 0xC2, 0x7F, 0x0A, 0xE0, 0x77, 0x39, 0x07, 0x20, 0x7F, 0x0C,
  0xE0, 0x77, 0x30, 0x23, 0x07, 0xF0, 0xEE, 0x07, 0x77, 0x07, 0xFF, 0x07, 0x77, 0x07, 0xE0, 0xE0,
  0xDE, 0x07, 0x73, 0x02, 0x30, 0x7E, 0x0D, 0x0C, 0xE0, 0x77, 0x39, 0x07, 0x20, 0x7E, 0x0B, 0x09,
  0xE0, 0x77, 0x3A, 0x81, 0xC2, 0x7E, 0x08, 0x04, 0xE0, 0xB8, 0x06, 0x7C, 0x0C, 0xE8, 0x13, 0x0E,
  0xFF, 0xFD, 0x0D, 0x20, 0x8F, 0xFF, 0xD0, 0x72, 0x01, 0x0E, 0xFF, 0xFB, 0x0D, 0x40, 0x6F, 0xFF,
  0xB0, 0x45, 0x09, 0xFF, 0xF9, 0x07, 0x70, 0xBF, 0xFE, 0x09, 0x72, 0x09, 0xFF, 0xC0, 0x67, 0x40,
  0x60, 0xEF, 0xF0, 0xC0, 0x37, 0x68, 0x11, 0x8E, 0xFB, 0x0D, 0x05, 0x77, 0x48, 0x90, 0x49, 0xBD,
  0xFD, 0xCB, 0x72, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_duo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_duo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_email 36x36, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_round_36_communication_email_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDF, 0xFF,
  0xFD, 0x81, 0x61, 0x8F, 0xFC, 0x81, 0x81, 0x6E, 0x01, 0x20, 0x30, 0xCF, 0xF0, 0xC0, 0x32, 0x01,
  0xE0, 0xB0, 0x13, 0x06, 0x0E, 0xFB, 0x0E, 0x06, 0x30, 0x10, 0xBF, 0x0E, 0x06, 0x30, 0x10, 0xAF,
  0x90, 0xA0, 0x13, 0x06, 0x0E, 0xFB, 0x0C, 0x03, 0x30, 0x40, 0xDC, 0x0D, 0x04, 0x30, 0x30, 0xCF,
  0xF0, 0x84, 0x08, 0xA0, 0x84, 0x08, 0xFF, 0xB0, 0xD0, 0x43, 0x00, 0x33, 0x04, 0x0D, 0xFF, 0xE0,
  0xA0, 0x14, 0x01, 0x0A, 0xFF, 0xFA, 0x0E, 0x06, 0x20, 0x60, 0xEF, 0xFF, 0xD0, 0x0E, 0x80, 0xBB,
  0x4F, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_forum 36x36, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_36_communication_forum_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFB, 0x0B, 0x03, 0x71, 0x08, 0xFF, 0xE0, 0xE0, 0x17, 0x0D, 0xFF, 0xF0, 0x67,
  0xFF, 0xF9, 0x07, 0x7F, 0xFF, 0x90, 0x77, 0xFF, 0xF9, 0x07, 0x7F, 0xFF, 0x90, 0x72, 0x82, 0x7F,
  0xD8, 0x1F, 0xFF, 0x90, 0x72, 0x07, 0xB0, 0x8F, 0xFF, 0x90, 0x72, 0x07, 0xB0, 0xDF, 0xFF, 0x90,
  0x72, 0x07, 0xFF, 0xFD, 0x07, 0x20, 0x7F, 0xFF, 0xD0, 0x72, 0x07, 0xFF, 0xFD, 0x07, 0x20, 0x7F,
  0xFF, 0xD0, 0x72, 0x07, 0xFF, 0xFD, 0x04, 0x20, 0x7F, 0xFF, 0xC0, 0x93, 0x07, 0xFA, 0x0D, 0x80,
  0x92, 0x70, 0x44, 0x07, 0xF9, 0x0D, 0x01, 0x77, 0x50, 0x7F, 0x0D, 0x01, 0x77, 0x60, 0x9E, 0x0D,
  0x01, 0x28, 0x09, 0x67, 0x09, 0xE0, 0xD0, 0x13, 0xFF, 0xFB, 0x0D, 0x01, 0x40, 0xDF, 0xFF, 0xA0,
  0x15, 0x08, 0xFF, 0xFA, 0x70, 0x80, 0xDF, 0xFF, 0x77, 0x73, 0x07, 0xD7, 0x77, 0x40, 0x7C, 0x77,
  0x75, 0x07, 0xB7, 0x77, 0x60, 0x7A, 0x77, 0x77, 0x07, 0x97, 0x77, 0x71, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_forum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_forum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_forward_to_inbox 36x36, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_round_36_communication_forward_to_inbox_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x83, 0x08, 0xFF, 0xFF, 0x08, 0x20, 0xDF, 0xFF, 0xF0, 0xD2,
  0xB0, 0xA0, 0x17, 0x76, 0x01, 0x0A, 0xB2, 0xC0, 0xE0, 0x67, 0x74, 0x06, 0x0E, 0xC2, 0xE0, 0xC0,
  0x37, 0x70, 0x30, 0xCE, 0x2B, 0x04, 0x0D, 0xB0, 0x87, 0x50, 0x8B, 0x0D, 0x04, 0xB2, 0xB2, 0x08,
  0xB0, 0xD0, 0x47, 0x10, 0x40, 0xDB, 0x08, 0x2B, 0x2B, 0x30, 0x30, 0xCB, 0x0A, 0x01, 0x40, 0x10,
  0xAB, 0x0C, 0x03, 0x3B, 0x2B, 0x50, 0x60, 0xEA, 0x0E, 0x06, 0x20, 0x60, 0xEA, 0x0E, 0x06, 0x5B,
  0x2B, 0x60, 0x10, 0xAB, 0x00, 0xCB, 0x0A, 0x01, 0x6B, 0x2B, 0x71, 0x04, 0x0D, 0xC0, 0xD0, 0x47,
  0x1B, 0x2B, 0x73, 0x82, 0x8D, 0xD8, 0x73, 0xB2, 0xB7, 0x77, 0x30, 0xF7, 0x2B, 0x77, 0x77, 0x1B,
  0x77, 0x77, 0x1B, 0x77, 0x77, 0x1B, 0x77, 0x71, 0x01, 0x04, 0x5B, 0x77, 0x71, 0x81, 0x7F, 0x74,
  0xB7, 0x77, 0x10, 0x7A, 0x07, 0x3B, 0x77, 0x71, 0x07, 0xB0, 0x72, 0x0D, 0xFF, 0x90, 0x72, 0x02,
  0x0D, 0xFA, 0x81, 0x70, 0x8F, 0xF9, 0x07, 0x20, 0x6F, 0xC8, 0x21, 0x08, 0xDF, 0xE0, 0x72, 0x02,
  0x0D, 0xFA, 0x07, 0x77, 0x75, 0x07, 0xB0, 0x77, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x77, 0x81, 0x7F,
  0x77, 0x77, 0x71, 0x01, 0x04, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_forward_to_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 34, 33), Box(0, 0, 35, 35),
      ic_round_36_communication_forward_to_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_hourglass_bottom 36x36, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_36_communication_hourglass_bottom_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xD8, 0x2D, 0x80, 0x8F, 0xFA, 0x08, 0x0D, 0xFF, 0xA0, 0xDB, 0x07, 0x73, 0x07,
  0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xB0, 0xDA, 0x05, 0x73, 0x05, 0xA0, 0xC0, 0x5B, 0x04, 0x71,
  0x04, 0x0E, 0xA8, 0x15, 0x07, 0xB0, 0x46, 0x04, 0x0E, 0xA0, 0x73, 0x07, 0xB0, 0x44, 0x04, 0x0E,
  0xA0, 0x75, 0x07, 0xB0, 0x42, 0x04, 0x0E, 0xA0, 0x77, 0x07, 0xB0, 0x04, 0xB0, 0x77, 0x20, 0x7E,
  0x07, 0x73, 0x07, 0xE0, 0x77, 0x20, 0x7F, 0x90, 0x77, 0x07, 0xFB, 0x07, 0x50, 0x7F, 0xD0, 0x73,
  0x07, 0xFF, 0x81, 0x70, 0x5F, 0xFA, 0x05, 0x0D, 0xFF, 0xA0, 0xD8, 0x09, 0xA6, 0xF0, 0xDF, 0xFA,
  0x0D, 0x08, 0xFF, 0xA8, 0x28, 0x08, 0xDF, 0xD0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_hourglass_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 3, 26, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_hourglass_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_hourglass_top 36x36, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_36_communication_hourglass_top_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xD8, 0x2D, 0x80, 0x8F, 0xFA, 0x08, 0x0D, 0xFF, 0xA0, 0xD8, 0x09, 0xA6, 0xF0,
  0xDF, 0xFA, 0x0D, 0x05, 0xFF, 0xA8, 0x15, 0x07, 0xFF, 0x07, 0x30, 0x7F, 0xD0, 0x75, 0x07, 0xFB,
  0x07, 0x70, 0x7F, 0x90, 0x77, 0x20, 0x7E, 0x07, 0x73, 0x07, 0xE0, 0x77, 0x20, 0x7B, 0x00, 0x4B,
  0x07, 0x70, 0x7A, 0x0E, 0x04, 0x20, 0x4B, 0x07, 0x50, 0x7A, 0x0E, 0x04, 0x40, 0x4B, 0x07, 0x30,
  0x7A, 0x0E, 0x04, 0x60, 0x4B, 0x81, 0x70, 0x5A, 0x0E, 0x04, 0x71, 0x04, 0xB0, 0x50, 0xCA, 0x05,
  0x73, 0x05, 0xA0, 0xDB, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x07, 0x73, 0x07, 0xB0, 0xDF, 0xFA,
  0x0D, 0x08, 0xFF, 0xA8, 0x28, 0x08, 0xDF, 0xD0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_hourglass_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 3, 26, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_hourglass_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_hub 36x36, 4-bit Alpha,  RLE, 266 bytes.
static const unsigned char ic_round_36_communication_hub_data[] PROGMEM = {
  0x77, 0x18, 0x42, 0xAD, 0xDA, 0x27, 0x77, 0x71, 0x04, 0xE0, 0x47, 0x77, 0x70, 0xEE, 0x0E, 0x77,
  0x76, 0x04, 0xF9, 0x04, 0x77, 0x75, 0x07, 0xF9, 0x07, 0x77, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x76,
  0x0E, 0xE0, 0xE7, 0x77, 0x70, 0x4E, 0x04, 0x77, 0x77, 0x10, 0x30, 0xBA, 0x0B, 0x03, 0x77, 0x50,
  0x37, 0x40, 0x2A, 0x01, 0x74, 0x03, 0x50, 0x10, 0xBB, 0x0B, 0x01, 0x71, 0x02, 0xA0, 0x17, 0x10,
  0x10, 0xBB, 0x83, 0xB1, 0x01, 0xDD, 0x0D, 0x01, 0x70, 0x2A, 0x01, 0x70, 0x10, 0xDD, 0x81, 0xD1,
  0x9F, 0x09, 0x60, 0x70, 0xCA, 0x0C, 0x07, 0x60, 0x9F, 0x09, 0x0D, 0xF0, 0xD4, 0x03, 0x0E, 0xE0,
  0xE0, 0x34, 0x0D, 0xF0, 0xD0, 0xEF, 0x90, 0x42, 0x03, 0xFB, 0x03, 0x20, 0x4F, 0x90, 0xE0, 0xBF,
  0xA8, 0x1E, 0x9D, 0xFB, 0x81, 0xD9, 0xEF, 0xA0, 0xB0, 0x4F, 0x0C, 0xFF, 0xC0, 0xCF, 0x81, 0x40,
  0x8D, 0x83, 0x80, 0x16, 0xDF, 0xD8, 0x3D, 0x61, 0x08, 0xD0, 0x83, 0x83, 0x38, 0xB9, 0x34, 0x0B,
  0xFD, 0x0B, 0x48, 0x33, 0x9B, 0x83, 0x76, 0x0A, 0xFD, 0x0A, 0x77, 0x71, 0x07, 0xFD, 0x07, 0x77,
  0x71, 0x02, 0xFD, 0x02, 0x77, 0x72, 0x08, 0xFB, 0x08, 0x77, 0x73, 0x04, 0xFB, 0x04, 0x77, 0x72,
  0x83, 0x1E, 0xFD, 0xEC, 0x83, 0xED, 0xFE, 0x17, 0x74, 0x8A, 0x42, 0x67, 0x3C, 0xFE, 0x10, 0x46,
  0x64, 0x01, 0xEF, 0xC3, 0x66, 0x27, 0x60, 0xAE, 0x03, 0x71, 0x03, 0xE0, 0xA7, 0x40, 0x9E, 0x0B,
  0x73, 0x0B, 0xE0, 0x97, 0x20, 0x2F, 0x90, 0x37, 0x10, 0x3F, 0x90, 0x27, 0x10, 0x6F, 0x90, 0x67,
  0x10, 0x6F, 0x90, 0x67, 0x10, 0x6F, 0x90, 0x67, 0x10, 0x6F, 0x90, 0x67, 0x10, 0x2F, 0x90, 0x27,
  0x10, 0x2F, 0x90, 0x27, 0x20, 0x9E, 0x09, 0x73, 0x09, 0xE0, 0x97, 0x40, 0xAC, 0x0A, 0x75, 0x0A,
  0xC0, 0xA7, 0x68, 0x22, 0x66, 0x27, 0x78, 0x22, 0x66, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 35, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_import_contacts 36x36, 4-bit Alpha,  RLE, 185 bytes.
static const unsigned char ic_round_36_communication_import_contacts_data[] PROGMEM = {
  0x68, 0x31, 0x13, 0x31, 0x75, 0x83, 0x13, 0x31, 0x17, 0x18, 0x21, 0x7B, 0xEE, 0x81, 0xD9, 0x44,
  0x81, 0x49, 0xDE, 0x82, 0xEB, 0x71, 0x30, 0x7F, 0xE8, 0x2D, 0x44, 0xDF, 0xE8, 0x16, 0x03, 0xFF,
  0xF9, 0x83, 0xDC, 0xBC, 0xDD, 0x03, 0x07, 0xFF, 0xC8, 0x2D, 0x84, 0x16, 0x04, 0x0E, 0xA0, 0x60,
  0x7F, 0xFA, 0x0B, 0x04, 0x74, 0x08, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x76,
  0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x76, 0x07, 0xA0, 0x07, 0xFF, 0xA7,
  0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x76, 0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA,
  0x76, 0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x76, 0x07, 0xA0, 0x07, 0xFF,
  0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x76, 0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F,
  0xFA, 0x76, 0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0xBA, 0x00, 0x7F, 0xFA, 0x38, 0x90, 0x37, 0xAD,
  0xEF, 0xDC, 0xBC, 0xB0, 0x70, 0x4F, 0xFA, 0x10, 0x70, 0xDF, 0xE8, 0x14, 0x0B, 0xFF, 0x90, 0xEF,
  0xF0, 0xB3, 0x89, 0x35, 0x77, 0x42, 0x10, 0x12, 0x35, 0x9E, 0xC8, 0x93, 0xE9, 0x53, 0x21, 0x01,
  0x24, 0x78, 0x67, 0x73, 0x82, 0x59, 0x95, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_import_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_import_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_import_export 36x36, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_36_communication_import_export_data[] PROGMEM = {
  0x50, 0x17, 0x74, 0x81, 0x7F, 0x77, 0x72, 0x07, 0xB0, 0x77, 0x70, 0x7D, 0x07, 0x75, 0x07, 0xF0,
  0x77, 0x30, 0x4F, 0xA0, 0x47, 0x20, 0x10, 0xF7, 0xB0, 0xF7, 0x01, 0x76, 0xB7, 0x73, 0xB7, 0x73,
  0xB7, 0x73, 0xB7, 0x73, 0xB6, 0x81, 0x8E, 0x87, 0x1B, 0x6B, 0x71, 0xB6, 0xB7, 0x1B, 0x6B, 0x71,
  0xB6, 0xB7, 0x18, 0x18, 0xE8, 0x6B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x76, 0x01,
  0x0F, 0x7B, 0x0F, 0x70, 0x17, 0x20, 0x4F, 0xA0, 0x57, 0x30, 0x7F, 0x07, 0x75, 0x07, 0xD0, 0x77,
  0x70, 0x7B, 0x07, 0x77, 0x28, 0x17, 0xF7, 0x77, 0x40, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_import_export() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 27, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_import_export_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_invert_colors_off 36x36, 4-bit Alpha,  RLE, 227 bytes.
static const unsigned char ic_round_36_communication_invert_colors_off_data[] PROGMEM = {
  0x77, 0x10, 0x40, 0x37, 0x71, 0x01, 0x74, 0x08, 0xA0, 0x77, 0x58, 0x21, 0xDF, 0x77, 0x20, 0x8C,
  0x08, 0x74, 0x03, 0xB0, 0x77, 0x08, 0xE0, 0x87, 0x40, 0xAB, 0x07, 0x50, 0x8B, 0x0A, 0xC0, 0x87,
  0x40, 0xAB, 0x07, 0x30, 0x2B, 0x0A, 0x1D, 0x08, 0x74, 0x0A, 0xB0, 0x73, 0x81, 0x4F, 0xA2, 0xE0,
  0x97, 0x40, 0xAB, 0x07, 0x30, 0x33, 0xF0, 0x97, 0x40, 0xAB, 0x07, 0x6F, 0x90, 0x97, 0x40, 0xCB,
  0x07, 0x5F, 0xA0, 0x67, 0x20, 0x2D, 0x07, 0x4F, 0xB0, 0x27, 0x10, 0xBA, 0x0E, 0xB0, 0x73, 0x04,
  0xFA, 0x0B, 0x70, 0x2B, 0x02, 0x0B, 0xB0, 0x73, 0x04, 0xFA, 0x02, 0x60, 0x7A, 0x09, 0x20, 0xBB,
  0x07, 0x30, 0x4F, 0x90, 0x76, 0x0B, 0xA0, 0x43, 0x0B, 0xB0, 0x73, 0x04, 0xF0, 0xB6, 0x0D, 0xA0,
  0x14, 0x0B, 0xB0, 0x73, 0x04, 0xE0, 0xD6, 0xB6, 0x0B, 0xB0, 0x73, 0x04, 0xE6, 0x0E, 0xA0, 0x16,
  0x0B, 0xB0, 0x73, 0x04, 0xC0, 0xE6, 0x0C, 0xA0, 0x37, 0x0B, 0xB0, 0x73, 0x04, 0xB0, 0xC6, 0x09,
  0xA0, 0x77, 0x1C, 0x07, 0x30, 0x4A, 0x09, 0x60, 0x4A, 0x0D, 0x71, 0xD0, 0x73, 0x81, 0x4F, 0x47,
  0x0D, 0xA0, 0x77, 0xE0, 0x73, 0x04, 0x71, 0x06, 0xB0, 0x46, 0xF0, 0x77, 0x50, 0xBB, 0x05, 0x5F,
  0x90, 0x77, 0x40, 0x10, 0xDB, 0x0B, 0x03, 0x3F, 0xA0, 0x77, 0x40, 0x10, 0xCC, 0x81, 0xD9, 0x8F,
  0xB0, 0x77, 0x50, 0x9F, 0xD0, 0x80, 0xBB, 0x07, 0x75, 0x81, 0x29, 0xEE, 0x81, 0xE9, 0x22, 0x0B,
  0xB0, 0x77, 0x78, 0x43, 0x57, 0x75, 0x36, 0x0B, 0xB0, 0x17, 0x77, 0x58, 0x1B, 0xFD, 0x77, 0x77,
  0x03, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_invert_colors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 31, 33), Box(0, 0, 35, 35),
      ic_round_36_communication_invert_colors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_key_off 36x36, 4-bit Alpha,  RLE, 208 bytes.
static const unsigned char ic_round_36_communication_key_off_data[] PROGMEM = {
  0x30, 0x17, 0x77, 0x72, 0x82, 0x1D, 0xF7, 0x77, 0x77, 0x10, 0x3B, 0x07, 0x77, 0x77, 0x10, 0xAB,
  0x07, 0x77, 0x77, 0x10, 0xAB, 0x07, 0x77, 0x77, 0x10, 0xAB, 0x07, 0x77, 0x77, 0x07, 0xC0, 0x77,
  0x77, 0x50, 0xAE, 0x07, 0x77, 0x73, 0x08, 0xF9, 0x07, 0x77, 0x71, 0x04, 0xD0, 0xE0, 0xCB, 0x07,
  0x77, 0x70, 0xBC, 0x82, 0xB1, 0x0B, 0xB0, 0x77, 0x75, 0x01, 0xC0, 0xC4, 0x0B, 0xB0, 0x73, 0x04,
  0xFC, 0x82, 0xC2, 0x04, 0xC0, 0x45, 0x0B, 0xB0, 0x73, 0x04, 0xFC, 0x81, 0xD2, 0x6C, 0x01, 0x60,
  0xBB, 0x07, 0x30, 0x4F, 0xC0, 0xB0, 0x6C, 0x01, 0x70, 0xBB, 0x07, 0x30, 0x4F, 0xB0, 0xB0, 0x5C,
  0x04, 0x70, 0x4C, 0x07, 0x30, 0x4F, 0x98, 0x1D, 0x11, 0xC0, 0xC7, 0x0C, 0xD0, 0x73, 0x04, 0xE0,
  0xD0, 0x12, 0x0B, 0xC0, 0xB0, 0x13, 0x01, 0x0A, 0xF0, 0x73, 0x02, 0x0D, 0xB0, 0xD0, 0x13, 0x03,
  0xD8, 0x3E, 0xA8, 0xAE, 0xD0, 0xCB, 0x07, 0x38, 0x31, 0xDF, 0xD1, 0x50, 0x8F, 0xE8, 0x18, 0x0B,
  0xB0, 0x73, 0x81, 0x15, 0x17, 0x0A, 0xFC, 0x09, 0x30, 0xBB, 0x07, 0x76, 0x06, 0x0E, 0xF0, 0xE0,
  0x65, 0x0B, 0xB0, 0x77, 0x68, 0x61, 0x6B, 0xDF, 0xDB, 0x67, 0x10, 0xBB, 0x07, 0x77, 0x77, 0x10,
  0xBB, 0x07, 0x77, 0x77, 0x10, 0xBB, 0x07, 0x77, 0x77, 0x10, 0xBB, 0x07, 0x77, 0x77, 0x10, 0xBB,
  0x07, 0x77, 0x77, 0x10, 0xBB, 0x01, 0x77, 0x77, 0x18, 0x1B, 0xFD, 0x77, 0x77, 0x30, 0x30, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 33, 33), Box(0, 0, 35, 35),
      ic_round_36_communication_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_key 36x36, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_round_36_communication_key_data[] PROGMEM = {
  0x58, 0x71, 0x7B, 0xDF, 0xDB, 0x71, 0x77, 0x72, 0x07, 0xF9, 0x0E, 0x06, 0x77, 0x70, 0xAF, 0xC0,
  0xA7, 0x75, 0x09, 0xFE, 0x08, 0x77, 0x30, 0x4D, 0x83, 0xEA, 0x8A, 0xED, 0x03, 0x77, 0x20, 0xCC,
  0x0B, 0x01, 0x30, 0x10, 0xBC, 0x0B, 0x77, 0x10, 0x2C, 0x0C, 0x70, 0xCF, 0xFA, 0x82, 0xC2, 0x05,
  0xC0, 0x47, 0x04, 0xFF, 0xB8, 0x1D, 0x26, 0xC0, 0x17, 0x01, 0xFF, 0xC0, 0xB0, 0x7C, 0x01, 0x70,
  0x1F, 0xFC, 0x0B, 0x04, 0xC0, 0x47, 0x04, 0xFF, 0xB8, 0x1D, 0x11, 0xC0, 0xC7, 0x0C, 0xFF, 0xA0,
  0xD0, 0x12, 0x0B, 0xC0, 0xB0, 0x13, 0x01, 0x0B, 0xC8, 0x1B, 0x1D, 0xB8, 0x1D, 0x3D, 0xB0, 0xD0,
  0x13, 0x03, 0xD8, 0x3E, 0xA8, 0xAE, 0xD8, 0x93, 0x40, 0x1D, 0xFD, 0x10, 0x1D, 0xFD, 0x15, 0x09,
  0xFE, 0x09, 0x38, 0x11, 0x51, 0x38, 0x11, 0x51, 0x70, 0x9F, 0xC0, 0xA7, 0x77, 0x06, 0x0E, 0xF0,
  0xE0, 0x77, 0x77, 0x28, 0x71, 0x6B, 0xDF, 0xEB, 0x71, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 9, 33, 26), Box(0, 0, 35, 35),
      ic_round_36_communication_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_list_alt 36x36, 4-bit Alpha,  RLE, 236 bytes.
static const unsigned char ic_round_36_communication_list_alt_data[] PROGMEM = {
  0x10, 0x58, 0x0A, 0x47, 0x81, 0x50, 0x5F, 0xFF, 0xD0, 0x50, 0x7F, 0xFF, 0xD0, 0x07, 0xA0, 0xB8,
  0x0A, 0x07, 0x0B, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0,
  0x07, 0xA0, 0x72, 0x82, 0x37, 0x73, 0x30, 0x58, 0x02, 0x70, 0x53, 0x07, 0xA0, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x72, 0x05, 0xF9, 0x05, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x5F,
  0x90, 0x52, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x82, 0x37, 0x73, 0x30, 0x58, 0x02, 0x70, 0x53, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x72,
  0x82, 0x37, 0x73, 0x30, 0x58, 0x02, 0x70, 0x53, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x05, 0xF9, 0x05, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x5F, 0x90, 0x52, 0x07,
  0xA0, 0x07, 0xA0, 0x72, 0x82, 0x37, 0x73, 0x30, 0x58, 0x02, 0x70, 0x53, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x82, 0x37, 0x73,
  0x30, 0x58, 0x02, 0x70, 0x53, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x05, 0xF9, 0x05,
  0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x5F, 0x90, 0x52, 0x07, 0xA0, 0x07, 0xA0,
  0x72, 0x82, 0x37, 0x73, 0x30, 0x58, 0x02, 0x70, 0x53, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x0A, 0x07, 0x0B, 0xA0, 0x07, 0xFF,
  0xFD, 0x07, 0x05, 0xFF, 0xFD, 0x81, 0x50, 0x58, 0x0A, 0x47, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_list_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_list_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_live_help 36x36, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_round_36_communication_live_help_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0x98, 0x3B, 0x30, 0x1E, 0xFF, 0xFB, 0x81, 0xE1, 0x6F, 0xFF, 0xD0, 0x60,
  0x7F, 0xB8, 0x49, 0x31, 0x03, 0x8F, 0xB0, 0x07, 0xF9, 0x0E, 0x03, 0x60, 0x20, 0xDF, 0x90, 0x07,
  0xF9, 0x03, 0x71, 0x02, 0xF9, 0x00, 0x7F, 0x09, 0x38, 0x28, 0xED, 0x83, 0x08, 0xF0, 0x07, 0xF0,
  0x32, 0x08, 0xC0, 0x82, 0x03, 0xF0, 0x07, 0xF8, 0x18, 0x04, 0xD0, 0xD3, 0xF0, 0x07, 0xFF, 0x90,
  0xD3, 0xF0, 0x07, 0xFF, 0x90, 0x82, 0x04, 0xF0, 0x07, 0xFF, 0x0B, 0x30, 0xBF, 0x00, 0x7F, 0xE0,
  0xB3, 0x08, 0xF9, 0x00, 0x7F, 0xD0, 0xC3, 0x07, 0xFA, 0x00, 0x7F, 0xD0, 0x32, 0x05, 0xFB, 0x00,
  0x7F, 0xC0, 0xC2, 0x01, 0x0E, 0xFB, 0x00, 0x7F, 0xC0, 0x92, 0x05, 0xFC, 0x00, 0x7F, 0xC8, 0x2D,
  0x11, 0xBF, 0xC0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xC0,
  0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07,
  0x06, 0xFF, 0xFD, 0x81, 0x61, 0xEF, 0xFF, 0xB8, 0x3E, 0x10, 0x3B, 0xFF, 0xF9, 0x0B, 0x03, 0x73,
  0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x75, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x77, 0x01, 0x0D, 0xA0, 0xD0,
  0x17, 0x77, 0x28, 0x21, 0xBB, 0x17, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_live_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 33), Box(0, 0, 35, 35),
      ic_round_36_communication_live_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_location_off 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_round_36_communication_location_off_data[] PROGMEM = {
  0x74, 0x86, 0x5A, 0xDE, 0xED, 0xA5, 0x77, 0x30, 0x60, 0xEF, 0x90, 0xE0, 0x66, 0x82, 0x1D, 0xE5,
  0x40, 0xAF, 0xD0, 0xA5, 0x05, 0xB0, 0x53, 0x06, 0xFE, 0x0B, 0x50, 0xCB, 0x05, 0x30, 0x6F, 0xE0,
  0x94, 0x01, 0x0C, 0xB0, 0x53, 0x06, 0xFE, 0x02, 0x40, 0x10, 0xCB, 0x05, 0x30, 0x6A, 0x0C, 0x0D,
  0xF9, 0x0A, 0x50, 0x10, 0xCB, 0x05, 0x30, 0x50, 0x22, 0x01, 0x0B, 0xF6, 0x04, 0xC0, 0x57, 0x10,
  0xDE, 0x04, 0x50, 0x5D, 0x05, 0x70, 0x7E, 0x06, 0x50, 0x7E, 0x05, 0x60, 0x4E, 0x07, 0x50, 0x5F,
  0x05, 0x50, 0x6E, 0x06, 0x50, 0x4F, 0x90, 0x54, 0x0D, 0xE0, 0x46, 0xFA, 0x05, 0x30, 0x6E, 0x70,
  0xBF, 0xA0, 0x53, 0x06, 0xC0, 0xB7, 0x06, 0xFB, 0x05, 0x30, 0x6B, 0x06, 0x71, 0x0E, 0xFB, 0x05,
  0x38, 0x16, 0xFE, 0x72, 0x08, 0xFC, 0x05, 0x30, 0x60, 0x87, 0x20, 0x10, 0xEF, 0xC0, 0x57, 0x70,
  0x7F, 0xD0, 0x57, 0x70, 0xDF, 0xD0, 0x57, 0x60, 0x5F, 0xE0, 0x57, 0x60, 0xAF, 0xE0, 0x57, 0x50,
  0x10, 0xEF, 0x90, 0xE0, 0xCB, 0x05, 0x75, 0x05, 0xF9, 0x81, 0x51, 0xCB, 0x05, 0x75, 0x09, 0xE0,
  0x92, 0x01, 0x0C, 0xB0, 0x37, 0x50, 0xCC, 0x0C, 0x40, 0x10, 0xCA, 0x08, 0x75, 0x02, 0x0E, 0xA0,
  0xE0, 0x25, 0x82, 0x1B, 0xC2, 0x76, 0x82, 0x4F, 0xE4, 0x77, 0x73, 0x00, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_location_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 29, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_location_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_location_on 36x36, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_round_36_communication_location_on_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x75, 0x02, 0x09, 0xFB, 0x09, 0x02, 0x72, 0x05, 0x0E,
  0xFD, 0x0E, 0x05, 0x70, 0x7F, 0xFA, 0x07, 0x50, 0x5F, 0xFC, 0x05, 0x30, 0x10, 0xEF, 0xFC, 0x0E,
  0x01, 0x20, 0x9F, 0xFE, 0x81, 0x90, 0x1F, 0xFF, 0x90, 0x10, 0x6F, 0xFF, 0x90, 0x60, 0xAF, 0xA8,
  0x27, 0x11, 0x7F, 0xA0, 0xA0, 0xCF, 0x90, 0x74, 0x07, 0xF9, 0x0C, 0x0E, 0xF9, 0x01, 0x40, 0x1F,
  0x90, 0xEF, 0xA0, 0x14, 0x01, 0xFA, 0x0D, 0xF9, 0x07, 0x40, 0x7F, 0x90, 0xD0, 0xBF, 0xA8, 0x27,
  0x11, 0x7F, 0xA0, 0xB0, 0x7F, 0xFF, 0x90, 0x70, 0x1F, 0xFF, 0x98, 0x11, 0x0A, 0xFF, 0xE0, 0xA2,
  0x02, 0xFF, 0xE0, 0x23, 0x09, 0xFF, 0xC0, 0x94, 0x01, 0x0D, 0xFF, 0xA0, 0xD0, 0x15, 0x03, 0xFF,
  0xA0, 0x37, 0x07, 0xFF, 0x07, 0x72, 0x09, 0xFD, 0x09, 0x74, 0x0B, 0xFB, 0x0B, 0x76, 0x0B, 0xF9,
  0x0B, 0x77, 0x10, 0xBE, 0x0C, 0x77, 0x30, 0xBC, 0x0B, 0x77, 0x50, 0xAA, 0x0A, 0x77, 0x70, 0x50,
  0x67, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_location_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_location_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_mail_lock 36x36, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_round_36_communication_mail_lock_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x84, 0x08, 0xFF, 0xFF, 0x08, 0x30, 0xDF, 0xFF, 0xF0, 0xD3,
  0xFF, 0xFF, 0xA3, 0xB8, 0x16, 0x18, 0xFF, 0xC8, 0x18, 0x16, 0xB3, 0xB0, 0x12, 0x03, 0x0C, 0xFF,
  0x0C, 0x03, 0x20, 0x1B, 0x3B, 0x0B, 0x01, 0x30, 0x60, 0xEF, 0xB0, 0xE0, 0x63, 0x01, 0x0B, 0xB3,
  0xC0, 0xE0, 0x63, 0x01, 0x0A, 0xF9, 0x0A, 0x01, 0x30, 0x60, 0xEC, 0x3E, 0x0C, 0x03, 0x30, 0x40,
  0xDC, 0x0D, 0x04, 0x30, 0x30, 0xCE, 0x3F, 0x90, 0x84, 0x08, 0xA0, 0x84, 0x08, 0xB0, 0x90, 0x36,
  0xFA, 0x0D, 0x04, 0x30, 0x03, 0x30, 0x40, 0xDA, 0x0D, 0x02, 0x71, 0xFC, 0x0A, 0x01, 0x40, 0x10,
  0xAB, 0x0D, 0x01, 0x72, 0xFD, 0x84, 0xE7, 0x11, 0x7E, 0xC0, 0x23, 0x83, 0x3B, 0xEB, 0x32, 0xFF,
  0xF0, 0x93, 0x85, 0x1E, 0xD8, 0xDE, 0x11, 0xFF, 0xF0, 0x43, 0x85, 0x6F, 0x20, 0x2F, 0x61, 0xFF,
  0xF0, 0x13, 0x07, 0x93, 0x90, 0x71, 0xFF, 0xF3, 0x87, 0x2B, 0xF7, 0x77, 0xFB, 0x2F, 0xFF, 0x30,
  0xDF, 0x0D, 0xFF, 0xF3, 0xFF, 0xFF, 0xA3, 0xFF, 0xFF, 0xA3, 0xFA, 0x0D, 0xFF, 0xE3, 0xFA, 0x08,
  0xFF, 0xE3, 0xFA, 0x10, 0x80, 0xDF, 0xFC, 0x30, 0x8F, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_mail_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_mail_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_mail_outline 36x36, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_36_communication_mail_outline_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDB, 0x0A,
  0x01, 0x77, 0x60, 0x10, 0xAF, 0x0E, 0x06, 0x77, 0x40, 0x60, 0xEF, 0xB0, 0xC0, 0x37, 0x70, 0x30,
  0xCF, 0xA0, 0x40, 0xDB, 0x08, 0x75, 0x08, 0xB0, 0xD0, 0x4E, 0x20, 0x8B, 0x0D, 0x04, 0x71, 0x04,
  0x0D, 0xB0, 0x82, 0xE3, 0x03, 0x0C, 0xB0, 0xA0, 0x14, 0x01, 0x0A, 0xB0, 0xC0, 0x33, 0xE5, 0x06,
  0x0E, 0xA0, 0xE0, 0x62, 0x06, 0x0E, 0xA0, 0xE0, 0x65, 0xE6, 0x01, 0x0A, 0xB0, 0x0C, 0xB0, 0xA0,
  0x16, 0xE7, 0x10, 0x40, 0xDC, 0x0D, 0x04, 0x71, 0xE7, 0x38, 0x28, 0xDD, 0x87, 0x3E, 0x77, 0x73,
  0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE0,
  0x77, 0x77, 0x10, 0x7B, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB,
  0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_mail_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_mail_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_mark_chat_read 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_round_36_communication_mark_chat_read_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x82, 0x08, 0xFF, 0xFF, 0x81, 0x80, 0xDF, 0xFF, 0xF0, 0xD1,
  0xFF, 0xFF, 0xA1, 0xFF, 0xFF, 0xA1, 0xFF, 0xFF, 0xA1, 0xFF, 0xFF, 0xA1, 0xFF, 0xFF, 0xA1, 0xFF,
  0xFF, 0xA1, 0xFF, 0xFF, 0xA1, 0xFF, 0xFF, 0xA1, 0xFF, 0xFF, 0xA1, 0xFF, 0xF8, 0x7C, 0x73, 0x10,
  0x13, 0x7D, 0x1F, 0xFD, 0x0D, 0x04, 0x73, 0xFF, 0xC0, 0xB7, 0x5F, 0xFB, 0x0B, 0x76, 0xFF, 0xA0,
  0xD7, 0x7F, 0xFA, 0x04, 0x74, 0x81, 0x9E, 0x6F, 0xF9, 0x0C, 0x74, 0x0A, 0xA0, 0xCF, 0xF9, 0x07,
  0x73, 0x0A, 0xB0, 0x6F, 0xF9, 0x03, 0x28, 0x12, 0xA9, 0x40, 0xAB, 0x07, 0x1F, 0xF9, 0x01, 0x20,
  0x9A, 0x0B, 0x20, 0xAB, 0x07, 0x2F, 0xF9, 0x30, 0x5B, 0x0B, 0x0A, 0xB0, 0x73, 0xFF, 0x94, 0x07,
  0xE0, 0x74, 0xD0, 0x77, 0x70, 0x7C, 0x07, 0x5C, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x6B, 0x07, 0x77,
  0x40, 0x03, 0x7A, 0x07, 0x77, 0x77, 0x90, 0x77, 0x77, 0x71, 0x07, 0x77, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_mark_chat_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 33, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_mark_chat_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_mark_chat_unread 36x36, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_36_communication_mark_chat_unread_data[] PROGMEM = {
  0x77, 0x72, 0x83, 0x7C, 0xEC, 0x77, 0x77, 0x30, 0xBD, 0x0B, 0x77, 0x71, 0x07, 0xF8, 0x27, 0x08,
  0xDF, 0xF9, 0x01, 0x20, 0xCF, 0x0C, 0x08, 0xFF, 0xB3, 0x0E, 0xF0, 0xE0, 0xDF, 0xFB, 0x01, 0x20,
  0xCF, 0x0C, 0xFF, 0xC0, 0x42, 0x07, 0xF0, 0x7F, 0xFC, 0x0A, 0x30, 0xBD, 0x0B, 0x1F, 0xFD, 0x03,
  0x38, 0x37, 0xCE, 0xC7, 0x2F, 0xFD, 0x0D, 0x01, 0x72, 0xFF, 0xE0, 0xD0, 0x37, 0x03, 0xFF, 0xF9,
  0x85, 0xA4, 0x10, 0x14, 0xA8, 0x0E, 0x82, 0xF0, 0xDF, 0xFF, 0xF9, 0x08, 0xFF, 0xFE, 0x0D, 0x08,
  0x1D, 0x07, 0x77, 0x73, 0xC0, 0x77, 0x77, 0x4B, 0x07, 0x77, 0x75, 0xA0, 0x77, 0x77, 0x69, 0x07,
  0x77, 0x77, 0x07, 0x77, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_mark_chat_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_mark_chat_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_mark_email_read 36x36, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_round_36_communication_mark_email_read_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x82, 0x08, 0xFF, 0xFF, 0x81, 0x80, 0xDF, 0xFF, 0xF0, 0xD1,
  0xFF, 0xFF, 0xA1, 0xB8, 0x16, 0x18, 0xFF, 0xC8, 0x18, 0x16, 0xB1, 0xB0, 0x12, 0x03, 0x0C, 0xFF,
  0x0C, 0x03, 0x20, 0x1B, 0x1B, 0x0B, 0x01, 0x30, 0x60, 0xEF, 0xB0, 0xE0, 0x63, 0x01, 0x0B, 0xB1,
  0xC0, 0xE0, 0x63, 0x01, 0x0A, 0xF9, 0x0A, 0x01, 0x30, 0x60, 0xEC, 0x1E, 0x0C, 0x03, 0x30, 0x40,
  0xDC, 0x0D, 0x04, 0x30, 0x30, 0xCE, 0x1F, 0x90, 0x84, 0x08, 0xA0, 0x84, 0x08, 0xF9, 0x1F, 0xA0,
  0xD0, 0x43, 0x00, 0x33, 0x04, 0x0D, 0xFA, 0x1F, 0xC0, 0xA0, 0x14, 0x01, 0x0A, 0xFC, 0x1F, 0xD0,
  0xE0, 0x62, 0x06, 0x0E, 0xB8, 0x7C, 0x73, 0x10, 0x13, 0x7D, 0x1F, 0xF0, 0x0E, 0xB0, 0xD0, 0x47,
  0x3F, 0xFC, 0x0B, 0x75, 0xFF, 0xB0, 0xB7, 0x6F, 0xFA, 0x0D, 0x77, 0xFF, 0xA0, 0x47, 0x48, 0x19,
  0xE6, 0xFF, 0x90, 0xC7, 0x40, 0xAA, 0x0C, 0xFF, 0x90, 0x77, 0x30, 0xAB, 0x06, 0xFF, 0x90, 0x32,
  0x81, 0x2A, 0x94, 0x0A, 0xB8, 0x17, 0x0D, 0xFF, 0x01, 0x20, 0x9A, 0x0B, 0x20, 0xAB, 0x07, 0x20,
  0x8F, 0xF3, 0x05, 0xB0, 0xB0, 0xAB, 0x07, 0x40, 0x80, 0xDF, 0xD0, 0x13, 0x07, 0xE0, 0x77, 0x77,
  0x30, 0x7C, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x70, 0x03, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_mark_email_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 33, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_mark_email_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_mark_email_unread 36x36, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_round_36_communication_mark_email_unread_data[] PROGMEM = {
  0x77, 0x72, 0x83, 0x7C, 0xEC, 0x77, 0x77, 0x30, 0xBD, 0x0B, 0x77, 0x71, 0x07, 0xF8, 0x27, 0x08,
  0xDF, 0xF9, 0x01, 0x20, 0xCF, 0x0C, 0x08, 0xFF, 0xB3, 0x0E, 0xF0, 0xE0, 0xDF, 0xFB, 0x01, 0x20,
  0xCF, 0x0C, 0xFF, 0xC0, 0x42, 0x07, 0xF0, 0x7B, 0x81, 0x61, 0x8F, 0xD0, 0xA3, 0x0B, 0xD0, 0xB1,
  0xB0, 0x12, 0x03, 0x0C, 0xFC, 0x03, 0x38, 0x37, 0xCE, 0xC7, 0x2B, 0x0B, 0x01, 0x30, 0x60, 0xEF,
  0xA0, 0xD0, 0x17, 0x2C, 0x0E, 0x06, 0x30, 0x10, 0xAF, 0x90, 0xA0, 0x17, 0x10, 0x3E, 0x0C, 0x03,
  0x30, 0x40, 0xDC, 0x0D, 0x04, 0x38, 0x53, 0x41, 0x01, 0x4A, 0xFA, 0x08, 0x40, 0x8A, 0x08, 0x40,
  0x8F, 0xFB, 0x0D, 0x04, 0x30, 0x03, 0x30, 0x40, 0xDF, 0xFE, 0x0A, 0x01, 0x40, 0x10, 0xAF, 0xFF,
  0xA0, 0xE0, 0x62, 0x06, 0x0E, 0xFF, 0xFD, 0x00, 0xE8, 0x0B, 0xB4, 0xF0, 0xDF, 0xFF, 0xF0, 0xD0,
  0x8F, 0xFF, 0xF8, 0x28, 0x08, 0xDF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_mark_email_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_mark_email_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_mark_unread_chat_alt 36x36, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_36_communication_mark_unread_chat_alt_data[] PROGMEM = {
  0x77, 0x72, 0x83, 0x7C, 0xEC, 0x77, 0x77, 0x30, 0xBD, 0x0B, 0x77, 0x71, 0x07, 0xF8, 0x27, 0x08,
  0xDF, 0xF9, 0x01, 0x20, 0xCF, 0x0C, 0x08, 0xFF, 0xB3, 0x0E, 0xF0, 0xE0, 0xDF, 0xFB, 0x01, 0x20,
  0xCF, 0x0C, 0xFF, 0xC0, 0x52, 0x07, 0xF0, 0x7F, 0xFC, 0x0A, 0x30, 0xBD, 0x0B, 0x1F, 0xFD, 0x04,
  0x38, 0x37, 0xCE, 0xC7, 0x2E, 0x07, 0x77, 0x72, 0xE7, 0x77, 0x20, 0x3E, 0x07, 0x77, 0x58, 0x11,
  0x4A, 0x80, 0xC1, 0xF0, 0xD0, 0x88, 0x09, 0x27, 0x08, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x2F, 0xD0,
  0x27, 0x72, 0x02, 0xFD, 0x0D, 0x08, 0x80, 0x92, 0x70, 0x80, 0xD8, 0x0C, 0x6F, 0x07, 0x73, 0x07,
  0xFF, 0xC7, 0x5F, 0xFC, 0x07, 0x73, 0x07, 0x80, 0x9F, 0x7F, 0x0D, 0xFF, 0xFF, 0x90, 0x8F, 0xFF,
  0xE0, 0xD0, 0x81, 0xD0, 0x77, 0x77, 0x3C, 0x07, 0x77, 0x74, 0x0E, 0xA0, 0x77, 0x77, 0x58, 0x16,
  0xC6, 0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_mark_unread_chat_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 32, 30), Box(0, 0, 35, 35),
      ic_round_36_communication_mark_unread_chat_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_message 36x36, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_36_communication_message_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xB4, 0xF0, 0x77, 0x72, 0x07, 0xFD, 0x77, 0x4F, 0xD0, 0x77, 0x72, 0x07, 0x80, 0xC6, 0xF0, 0xD0,
  0x88, 0x09, 0x27, 0x08, 0x0D, 0xFD, 0x02, 0x77, 0x20, 0x2F, 0xD0, 0x27, 0x72, 0x02, 0xFD, 0x0D,
  0x08, 0x80, 0x92, 0x70, 0x80, 0xD8, 0x0C, 0x6F, 0x07, 0x77, 0x20, 0x7F, 0xD7, 0x74, 0xFD, 0x07,
  0x77, 0x20, 0x78, 0x09, 0xF1, 0xF0, 0xDF, 0xFF, 0xF9, 0x08, 0xFF, 0xFE, 0x0D, 0x08, 0x1D, 0x07,
  0x77, 0x73, 0xC0, 0x77, 0x77, 0x4B, 0x07, 0x77, 0x75, 0xA0, 0x77, 0x77, 0x69, 0x07, 0x77, 0x77,
  0x07, 0x77, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_message() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_message_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_mobile_screen_share 36x36, 4-bit Alpha,  RLE, 202 bytes.
static const unsigned char ic_round_36_communication_mobile_screen_share_data[] PROGMEM = {
  0x20, 0x48, 0x09, 0x47, 0x04, 0x30, 0x9F, 0xFC, 0x81, 0x90, 0x3F, 0xFE, 0x04, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xA0, 0xB8, 0x09, 0x27, 0x0B, 0xA0, 0x07, 0xA0, 0x77,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x02, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x71, 0x0B, 0x04, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x81, 0xCF, 0x53, 0x07, 0xA0,
  0x07, 0xA0, 0x75, 0x81, 0x28, 0xCB, 0x06, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x40, 0x8F, 0x81, 0x50,
  0x7A, 0x00, 0x7A, 0x07, 0x30, 0xBF, 0x98, 0x15, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x08, 0xC0, 0xDB,
  0x05, 0x20, 0x7A, 0x00, 0x7A, 0x85, 0x70, 0x2F, 0xD7, 0x22, 0x81, 0xCF, 0x53, 0x07, 0xA0, 0x07,
  0xA8, 0x27, 0x07, 0x95, 0x0B, 0x04, 0x40, 0x7A, 0x00, 0x7A, 0x81, 0x70, 0x56, 0x01, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x09,
  0x27, 0x0B, 0xA0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x70, 0x3F, 0xFE, 0x81,
  0x40, 0x9F, 0xFC, 0x09, 0x30, 0x48, 0x09, 0x47, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_mobile_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_mobile_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_more_time 36x36, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_round_36_communication_more_time_data[] PROGMEM = {
  0x77, 0x73, 0x81, 0x8E, 0x87, 0x77, 0x71, 0xB7, 0x77, 0x71, 0xB7, 0x78, 0x65, 0x9C, 0xDF, 0xEC,
  0x57, 0xB7, 0x40, 0x10, 0x8F, 0x90, 0x73, 0x05, 0x0F, 0x7B, 0x0F, 0x70, 0x56, 0x05, 0x0E, 0xFA,
  0x07, 0x20, 0x5F, 0xC0, 0x54, 0x08, 0xC8, 0x6C, 0x73, 0x10, 0x13, 0x22, 0x05, 0xFC, 0x05, 0x30,
  0x8B, 0x0D, 0x04, 0x74, 0x05, 0x0F, 0x7B, 0x0F, 0x70, 0x53, 0x05, 0xB0, 0xA7, 0x73, 0xB6, 0x01,
  0x0E, 0xA0, 0xA6, 0x81, 0xAD, 0x17, 0x2B, 0x60, 0x8A, 0x0D, 0x7A, 0x03, 0x72, 0xB6, 0xB0, 0x47,
  0xA0, 0x37, 0x28, 0x18, 0xE8, 0x50, 0x5A, 0x0C, 0x71, 0xA0, 0x37, 0x73, 0x09, 0xA0, 0x77, 0x1A,
  0x03, 0x77, 0x30, 0xCA, 0x03, 0x71, 0xA0, 0x37, 0x73, 0x0D, 0xA0, 0x17, 0x1A, 0x03, 0x71, 0x01,
  0xA0, 0xE5, 0xB7, 0x2A, 0x03, 0x72, 0xB5, 0x0D, 0xA0, 0x17, 0x18, 0x2E, 0xFD, 0x47, 0x01, 0xA0,
  0xD5, 0x0C, 0xA0, 0x37, 0x10, 0x30, 0xDA, 0x0A, 0x02, 0x50, 0x3A, 0x0C, 0x50, 0x9A, 0x07, 0x73,
  0x08, 0xB0, 0x74, 0x07, 0xA0, 0x95, 0x05, 0xA0, 0xC7, 0x40, 0x20, 0xBA, 0x09, 0x30, 0xCA, 0x05,
  0x6B, 0x04, 0x75, 0x81, 0x5D, 0x72, 0x04, 0xB7, 0x08, 0xA0, 0xD7, 0x73, 0x0D, 0xA0, 0x87, 0x01,
  0x0E, 0xA0, 0xA7, 0x71, 0x0A, 0xA0, 0xE0, 0x17, 0x10, 0x5B, 0x0A, 0x76, 0x0A, 0xB0, 0x57, 0x30,
  0x8B, 0x0D, 0x04, 0x72, 0x04, 0x0D, 0xB0, 0x87, 0x50, 0x8C, 0x87, 0xC7, 0x31, 0x01, 0x37, 0xCC,
  0x08, 0x77, 0x05, 0x0E, 0xFE, 0x0E, 0x05, 0x77, 0x20, 0x10, 0x8F, 0xC0, 0x80, 0x17, 0x76, 0x87,
  0x59, 0xCD, 0xFD, 0xC9, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_more_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 34, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_more_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_nat 36x36, 4-bit Alpha,  RLE, 221 bytes.
static const unsigned char ic_round_36_communication_nat_data[] PROGMEM = {
  0x68, 0x41, 0xBC, 0xA6, 0x17, 0x77, 0x60, 0x6D, 0x0B, 0x03, 0x77, 0x74, 0x02, 0x0E, 0xE0, 0x90,
  0x17, 0x77, 0x48, 0x13, 0x6B, 0xC0, 0xD0, 0x27, 0x77, 0x60, 0x20, 0xAB, 0x0E, 0x03, 0x77, 0x77,
  0x04, 0x0E, 0xA0, 0xE0, 0x17, 0x77, 0x70, 0x20, 0xEA, 0x0C, 0x77, 0x77, 0x10, 0x3B, 0x06, 0x77,
  0x77, 0x10, 0x6A, 0x0E, 0x77, 0x77, 0x20, 0xDA, 0x06, 0x77, 0x18, 0x22, 0x66, 0x37, 0x30, 0x6A,
  0x0C, 0x60, 0x27, 0x0A, 0xC0, 0xA7, 0x20, 0x1B, 0x68, 0x17, 0xB1, 0x40, 0x9E, 0x0A, 0x72, 0x0C,
  0xA0, 0x35, 0x82, 0x7F, 0xE4, 0x20, 0x2B, 0x00, 0x9B, 0x08, 0x80, 0x17, 0x03, 0x20, 0x9A, 0x0A,
  0x80, 0x17, 0x0B, 0xB8, 0x17, 0x06, 0xA0, 0x92, 0x09, 0xF9, 0x07, 0x20, 0x8F, 0xE0, 0xB0, 0x6A,
  0x09, 0x20, 0x9F, 0x90, 0x72, 0x08, 0xFE, 0x0B, 0x02, 0xB0, 0x09, 0xB0, 0x88, 0x01, 0x70, 0x32,
  0x09, 0xA0, 0xA8, 0x01, 0x70, 0xBB, 0x07, 0x20, 0x9E, 0x0A, 0x72, 0x0C, 0xA0, 0x35, 0x82, 0x7F,
  0xE4, 0x40, 0xAC, 0x0A, 0x72, 0x01, 0xB6, 0x81, 0x7B, 0x16, 0x82, 0x26, 0x63, 0x73, 0x06, 0xA0,
  0xB6, 0x02, 0x77, 0x71, 0x0D, 0xA0, 0x67, 0x77, 0x70, 0x6A, 0x0E, 0x77, 0x77, 0x03, 0xB0, 0x67,
  0x77, 0x60, 0x20, 0xEA, 0x0C, 0x77, 0x76, 0x04, 0x0E, 0xA0, 0xE0, 0x17, 0x77, 0x40, 0x20, 0xAB,
  0x0E, 0x03, 0x77, 0x72, 0x81, 0x36, 0xBC, 0x0D, 0x02, 0x77, 0x71, 0x02, 0x0E, 0xE0, 0x90, 0x17,
  0x77, 0x20, 0x6D, 0x0A, 0x03, 0x77, 0x74, 0x84, 0x1C, 0xCA, 0x61, 0x77, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_nat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 33, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_nat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_no_sim 36x36, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_round_36_communication_no_sim_data[] PROGMEM = {
  0x73, 0x01, 0x80, 0x77, 0x04, 0x77, 0x01, 0x0D, 0xFD, 0x09, 0x48, 0x13, 0xB7, 0x50, 0x10, 0xDF,
  0xF0, 0x43, 0x0B, 0xA0, 0x94, 0x0C, 0xFF, 0x90, 0x73, 0x08, 0xB0, 0x93, 0x03, 0x0E, 0xFF, 0x07,
  0x40, 0x9B, 0x09, 0x30, 0x30, 0xEF, 0xE0, 0x75, 0x09, 0xB0, 0x93, 0x03, 0x0E, 0xFD, 0x07, 0x60,
  0xAB, 0x09, 0x30, 0x30, 0xEF, 0xC0, 0x76, 0x07, 0xC0, 0x93, 0x03, 0x0E, 0xFB, 0x07, 0x60, 0x7D,
  0x09, 0x30, 0x30, 0xEF, 0xA0, 0x76, 0x07, 0xE0, 0x93, 0x03, 0x0E, 0xF9, 0x07, 0x60, 0x7F, 0x09,
  0x30, 0x30, 0xEF, 0x07, 0x60, 0x7F, 0x90, 0x93, 0x03, 0x0E, 0xE0, 0x76, 0x07, 0xFA, 0x09, 0x30,
  0x30, 0xED, 0x07, 0x60, 0x7F, 0xB0, 0x93, 0x03, 0x0E, 0xC0, 0x76, 0x07, 0xFC, 0x09, 0x30, 0x30,
  0xEB, 0x07, 0x60, 0x7F, 0xD0, 0x93, 0x03, 0x0E, 0xA0, 0x76, 0x07, 0xFE, 0x09, 0x38, 0x23, 0xEF,
  0x76, 0x07, 0xFF, 0x08, 0x38, 0x13, 0xE7, 0x60, 0x7F, 0xF9, 0x08, 0x30, 0x30, 0x66, 0x07, 0xFF,
  0xA0, 0x87, 0x30, 0x7F, 0xFB, 0x08, 0x72, 0x07, 0xFF, 0xC0, 0x87, 0x10, 0x7F, 0xFD, 0x08, 0x70,
  0x7F, 0xFE, 0x08, 0x60, 0x4F, 0xFF, 0x08, 0x60, 0x9F, 0xFF, 0x08, 0x60, 0x48, 0x09, 0x47, 0x04,
  0x09, 0xB0, 0x27, 0x77, 0x38, 0x29, 0xFE, 0x17, 0x77, 0x40, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 33), Box(0, 0, 35, 35),
      ic_round_36_communication_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_pause_presentation 36x36, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_round_36_communication_pause_presentation_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x18, 0x22, 0xDD, 0x22, 0x82, 0x2D, 0xD2, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x20,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x71, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x20,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x71, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x20,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x18, 0x22, 0xDD, 0x22, 0x82, 0x2D, 0xD2, 0x71,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x09, 0x77, 0x75, 0x09, 0xA0, 0x07, 0xB0, 0x98, 0x0A,
  0x47, 0x09, 0xB0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x30, 0x48, 0x0B,
  0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_pause_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_pause_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_person_add_disabled 36x36, 4-bit Alpha,  RLE, 269 bytes.
static const unsigned char ic_round_36_communication_person_add_disabled_data[] PROGMEM = {
  0x18, 0x19, 0xA2, 0x77, 0x77, 0x30, 0x4A, 0x0D, 0x02, 0x77, 0x77, 0x20, 0x10, 0xEA, 0x0D, 0x02,
  0x77, 0x77, 0x20, 0x30, 0xEA, 0x0D, 0x02, 0x75, 0x85, 0x29, 0xDF, 0xD9, 0x27, 0x40, 0x30, 0xEA,
  0x0D, 0x02, 0x73, 0x06, 0xF0, 0x67, 0x40, 0x30, 0xEA, 0x0D, 0x02, 0x71, 0x05, 0xFA, 0x05, 0x74,
  0x03, 0x0E, 0xA0, 0xD0, 0x27, 0x0D, 0xFA, 0x0D, 0x75, 0x03, 0xB0, 0xD0, 0x25, 0x04, 0xFC, 0x04,
  0x75, 0xC0, 0xD0, 0x24, 0x06, 0xFC, 0x06, 0x75, 0xD0, 0xD0, 0x23, 0x06, 0xFC, 0x06, 0x75, 0xB0,
  0xEA, 0x0D, 0x02, 0x30, 0xAF, 0xB0, 0x47, 0x5B, 0x03, 0x0E, 0xA0, 0xD0, 0x23, 0x0A, 0xF9, 0x0D,
  0x71, 0x02, 0x0D, 0xFC, 0x0D, 0x02, 0x30, 0xAF, 0x05, 0x71, 0x06, 0xFE, 0x0D, 0x02, 0x30, 0xAD,
  0x06, 0x72, 0x02, 0x0D, 0xFE, 0x0D, 0x02, 0x38, 0x3A, 0xFD, 0x92, 0x77, 0x1B, 0x40, 0x30, 0xEA,
  0x0D, 0x02, 0x77, 0x71, 0xB5, 0x03, 0x0E, 0xA0, 0xD0, 0x27, 0x77, 0xB6, 0x03, 0x0E, 0xA0, 0xD0,
  0x27, 0x76, 0x81, 0xDF, 0xD7, 0x04, 0xB0, 0xD0, 0x23, 0x81, 0x57, 0x47, 0x68, 0x12, 0x72, 0x50,
  0x40, 0xAD, 0x0D, 0x02, 0x38, 0x3A, 0xFE, 0xA4, 0x77, 0x20, 0x30, 0xBF, 0x90, 0xD0, 0x23, 0x0A,
  0xB0, 0xB0, 0x27, 0x60, 0x4F, 0xC0, 0xD0, 0x23, 0x0A, 0xB0, 0xE0, 0x47, 0x40, 0x10, 0xEF, 0xD0,
  0xD0, 0x23, 0x0A, 0xB0, 0xE0, 0x17, 0x30, 0x6F, 0xF0, 0xD0, 0x23, 0x0A, 0xB0, 0x67, 0x30, 0x7F,
  0xF9, 0x0D, 0x02, 0x30, 0xAA, 0x07, 0x73, 0x07, 0xFF, 0xA0, 0xD0, 0x23, 0x81, 0xAF, 0x77, 0x30,
  0x20, 0xDF, 0xFA, 0x0D, 0x02, 0x30, 0x90, 0x17, 0x77, 0x40, 0x30, 0xEA, 0x0D, 0x02, 0x77, 0x77,
  0x20, 0x30, 0xEA, 0x0D, 0x02, 0x77, 0x77, 0x20, 0x30, 0xEA, 0x0D, 0x02, 0x77, 0x77, 0x20, 0x30,
  0xEA, 0x0B, 0x77, 0x77, 0x38, 0x23, 0xEF, 0x97, 0x77, 0x74, 0x01, 0x05, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_person_add_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 34, 35), Box(0, 0, 35, 35),
      ic_round_36_communication_person_add_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_person_search 36x36, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_round_36_communication_person_search_data[] PROGMEM = {
  0x72, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x71, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x76, 0x0C, 0xF9, 0x0C,
  0x77, 0x50, 0x6F, 0xB0, 0x67, 0x74, 0x0C, 0xFB, 0x0C, 0x77, 0x40, 0xEF, 0xB0, 0xE7, 0x74, 0x0E,
  0xFB, 0x0E, 0x77, 0x40, 0xCF, 0xB0, 0xC7, 0x74, 0x06, 0xFB, 0x06, 0x77, 0x50, 0xCF, 0x90, 0xC7,
  0x76, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x18, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x75, 0x06, 0x0B,
  0xA0, 0xB0, 0x67, 0x77, 0x10, 0x10, 0xCE, 0x0B, 0x01, 0x77, 0x60, 0xCF, 0x90, 0xB7, 0x38, 0x52,
  0x69, 0xBD, 0xF5, 0x20, 0x6B, 0x82, 0x71, 0x17, 0xB0, 0x56, 0x81, 0x17, 0xCE, 0x02, 0x20, 0xCA,
  0x07, 0x40, 0x7A, 0x0B, 0x50, 0x70, 0xEF, 0x93, 0x0E, 0xA0, 0x14, 0x01, 0xA0, 0xE4, 0x0B, 0xFB,
  0x30, 0xEA, 0x01, 0x40, 0x1A, 0x0E, 0x30, 0x8F, 0xC0, 0x22, 0x0B, 0xA0, 0x74, 0x07, 0xA0, 0xB3,
  0x0D, 0xFC, 0x05, 0x20, 0x6B, 0x82, 0x71, 0x17, 0xB0, 0x63, 0xFD, 0x0B, 0x30, 0xCF, 0xA0, 0x93,
  0xFE, 0x03, 0x20, 0x10, 0xBF, 0xA0, 0x92, 0x08, 0xFD, 0x0D, 0x01, 0x38, 0x56, 0xBE, 0xEB, 0x69,
  0xB0, 0x97, 0x77, 0x50, 0x9B, 0x03, 0x77, 0x75, 0x09, 0xA0, 0x27, 0x77, 0x60, 0x40, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_person_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_person_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_phone_disabled 36x36, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_round_36_communication_phone_disabled_data[] PROGMEM = {
  0x20, 0x17, 0x75, 0x84, 0x16, 0x77, 0x73, 0x28, 0x21, 0xDF, 0x77, 0x73, 0x04, 0x0E, 0xD8, 0x19,
  0x03, 0xB0, 0x77, 0x72, 0x0D, 0xF8, 0x13, 0x0B, 0xB0, 0x77, 0x70, 0x2F, 0x90, 0x62, 0x0B, 0xB0,
  0x77, 0x60, 0x4F, 0x90, 0x53, 0x0B, 0xB0, 0x77, 0x50, 0x5F, 0x90, 0x34, 0x0B, 0xB0, 0x77, 0x40,
  0x7F, 0x90, 0x15, 0x0B, 0xB0, 0x77, 0x30, 0x7F, 0x0E, 0x70, 0xBB, 0x07, 0x72, 0x04, 0xF0, 0x97,
  0x10, 0xBB, 0x07, 0x72, 0x09, 0xE0, 0x57, 0x20, 0xBB, 0x07, 0x72, 0x09, 0xD7, 0x40, 0xBB, 0x07,
  0x72, 0x09, 0xB0, 0xA7, 0x50, 0xBB, 0x07, 0x71, 0x01, 0xB0, 0x37, 0x60, 0xBB, 0x07, 0x70, 0xAA,
  0x0B, 0x77, 0x10, 0xBB, 0x07, 0x50, 0x4B, 0x03, 0x77, 0x20, 0xBB, 0x07, 0x40, 0xDA, 0x09, 0x77,
  0x40, 0xBB, 0x07, 0x38, 0x14, 0xFD, 0x77, 0x60, 0xBB, 0x07, 0x30, 0x04, 0x73, 0x84, 0x13, 0x57,
  0x73, 0x50, 0xBB, 0x07, 0x75, 0x04, 0x0D, 0xE0, 0x85, 0x0B, 0xB0, 0x77, 0x30, 0x10, 0xEF, 0x90,
  0x93, 0x04, 0x0D, 0xC0, 0x77, 0x20, 0x6F, 0xB8, 0x19, 0x1A, 0xF0, 0x77, 0x10, 0x7F, 0xF9, 0x81,
  0xD4, 0xBB, 0x07, 0x70, 0x7F, 0xF0, 0x93, 0x0B, 0xB0, 0x76, 0x06, 0xFD, 0x0B, 0x03, 0x50, 0xBB,
  0x07, 0x50, 0x3F, 0xB0, 0xA0, 0x37, 0x10, 0xBB, 0x07, 0x50, 0x9D, 0x81, 0xE9, 0x57, 0x50, 0xBB,
  0x07, 0x58, 0x33, 0x65, 0x31, 0x77, 0x20, 0xBB, 0x01, 0x77, 0x75, 0x81, 0xBF, 0xD7, 0x77, 0x70,
  0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_phone_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 31, 33), Box(0, 0, 35, 35),
      ic_round_36_communication_phone_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_phone_enabled 36x36, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_36_communication_phone_enabled_data[] PROGMEM = {
  0x77, 0x68, 0x41, 0x67, 0x77, 0x37, 0x77, 0x04, 0x0E, 0xD0, 0x97, 0x76, 0x0D, 0xF0, 0x37, 0x74,
  0x02, 0xF9, 0x06, 0x77, 0x40, 0x4F, 0x90, 0x57, 0x74, 0x05, 0xF9, 0x04, 0x77, 0x40, 0x7F, 0x90,
  0x17, 0x74, 0x07, 0xF0, 0xE7, 0x75, 0x04, 0xF0, 0xA7, 0x76, 0x09, 0xE0, 0x57, 0x77, 0x09, 0xD0,
  0x17, 0x77, 0x10, 0x9B, 0x0A, 0x77, 0x72, 0x02, 0xB0, 0x47, 0x77, 0x20, 0xBA, 0x0B, 0x77, 0x72,
  0x05, 0xB0, 0x37, 0x77, 0x10, 0x10, 0xDA, 0x0A, 0x77, 0x72, 0x0C, 0xA0, 0xE0, 0x17, 0x77, 0x10,
  0xAB, 0x04, 0x71, 0x84, 0x13, 0x57, 0x73, 0x71, 0x0A, 0xB0, 0x77, 0x04, 0x0D, 0xE0, 0x85, 0x01,
  0x0C, 0xB0, 0x87, 0x01, 0x0E, 0xF9, 0x09, 0x30, 0x50, 0xDB, 0x08, 0x71, 0x06, 0xFB, 0x81, 0x92,
  0xBC, 0x07, 0x72, 0x07, 0xFF, 0x90, 0xE0, 0x47, 0x30, 0x7F, 0xF0, 0xA0, 0x17, 0x40, 0x6F, 0xD0,
  0xB0, 0x37, 0x60, 0x3F, 0xB0, 0xA0, 0x47, 0x72, 0x09, 0xD8, 0x2E, 0xA5, 0x17, 0x75, 0x83, 0x36,
  0x54, 0x17, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_phone_enabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_phone_enabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_phonelink_erase 36x36, 4-bit Alpha,  RLE, 223 bytes.
static const unsigned char ic_round_36_communication_phonelink_erase_data[] PROGMEM = {
  0x70, 0x48, 0x09, 0x47, 0x04, 0x71, 0x09, 0xFF, 0xC0, 0x96, 0x04, 0xFF, 0xE0, 0x45, 0x07, 0xFF,
  0xE0, 0x75, 0x07, 0xFF, 0xE0, 0x75, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x77,
  0x07, 0xA0, 0x75, 0x82, 0x2D, 0xD2, 0x77, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x72,
  0x07, 0xA8, 0x17, 0x88, 0x73, 0x00, 0x87, 0x20, 0x7A, 0x82, 0x7E, 0xFA, 0x71, 0x81, 0xAF, 0xE7,
  0x20, 0x7A, 0x07, 0x04, 0xA0, 0xA6, 0x0A, 0xA0, 0x47, 0x20, 0x7A, 0x81, 0x70, 0x4A, 0x0A, 0x40,
  0xAA, 0x04, 0x73, 0x07, 0xA0, 0x72, 0x04, 0xA0, 0xA2, 0x0A, 0xA0, 0x47, 0x40, 0x7A, 0x07, 0x30,
  0x4A, 0x00, 0xAA, 0x04, 0x75, 0x07, 0xA0, 0x74, 0x04, 0xC0, 0x47, 0x60, 0x7A, 0x07, 0x50, 0xBA,
  0x0B, 0x77, 0x07, 0xA0, 0x74, 0x0A, 0xC0, 0xA7, 0x60, 0x7A, 0x07, 0x30, 0xAA, 0x00, 0x4A, 0x0A,
  0x75, 0x07, 0xA0, 0x72, 0x0A, 0xA0, 0x42, 0x04, 0xA0, 0xA7, 0x40, 0x7A, 0x81, 0x70, 0xAA, 0x04,
  0x40, 0x4A, 0x0A, 0x73, 0x07, 0xA0, 0x70, 0xAA, 0x04, 0x60, 0x4A, 0x0A, 0x72, 0x07, 0xA8, 0x27,
  0xEF, 0x47, 0x18, 0x14, 0xFE, 0x72, 0x07, 0xA8, 0x17, 0x33, 0x73, 0x00, 0x37, 0x20, 0x7A, 0x07,
  0x77, 0x72, 0x07, 0xA0, 0x75, 0x82, 0x2D, 0xD2, 0x77, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x75, 0x07, 0xFF, 0xE0, 0x75, 0x07, 0xFF, 0xE0,
  0x75, 0x04, 0xFF, 0xE0, 0x46, 0x09, 0xFF, 0xC0, 0x97, 0x10, 0x48, 0x09, 0x47, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_phonelink_erase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 31, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_phonelink_erase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_phonelink_lock 36x36, 4-bit Alpha,  RLE, 186 bytes.
static const unsigned char ic_round_36_communication_phonelink_lock_data[] PROGMEM = {
  0x20, 0x38, 0x09, 0x47, 0x04, 0x60, 0x9F, 0xFC, 0x09, 0x40, 0x4F, 0xFE, 0x04, 0x30, 0x7F, 0xFE,
  0x07, 0x30, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFE,
  0x07, 0x30, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x73, 0x07, 0xA0, 0x77, 0x78, 0x23, 0x77, 0x33, 0x07,
  0xA0, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x78, 0x28, 0xDD, 0x83, 0x07, 0xA0, 0x77, 0x68, 0x48, 0xF9,
  0x9F, 0x82, 0x07, 0xA0, 0x77, 0x60, 0xD0, 0x92, 0x09, 0x0D, 0x20, 0x7A, 0x07, 0x76, 0x90, 0x72,
  0x07, 0x92, 0x07, 0xA0, 0x77, 0x58, 0x90, 0x5F, 0xB7, 0x7B, 0xF5, 0x07, 0xA0, 0x77, 0x40, 0x5F,
  0x90, 0x50, 0x7A, 0x07, 0x74, 0x07, 0xF9, 0x00, 0x7A, 0x07, 0x74, 0x07, 0xF9, 0x00, 0x7A, 0x07,
  0x74, 0x07, 0xF9, 0x00, 0x7A, 0x07, 0x74, 0x07, 0xF9, 0x00, 0x7A, 0x07, 0x74, 0x07, 0xF9, 0x00,
  0x7A, 0x07, 0x74, 0x02, 0x0D, 0xE8, 0x1D, 0x27, 0xA0, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x78, 0x23,
  0x77, 0x33, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x30, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFE, 0x07,
  0x30, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFE, 0x07, 0x30, 0x4F, 0xFE, 0x04,
  0x40, 0x9F, 0xFC, 0x09, 0x60, 0x48, 0x09, 0x47, 0x04, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_phonelink_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 31, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_phonelink_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_phonelink_ring 36x36, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_round_36_communication_phonelink_ring_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x09, 0x37, 0x06, 0x01, 0x73, 0x03, 0x0E, 0xFF, 0xB0, 0xE0, 0x37, 0x20, 0xBF,
  0xFD, 0x0B, 0x72, 0xFF, 0xF7, 0x2F, 0xFF, 0x72, 0xB7, 0x71, 0xB7, 0x2B, 0x77, 0x1B, 0x72, 0xB7,
  0x71, 0xB7, 0x2B, 0x77, 0x1B, 0x72, 0xB7, 0x71, 0xB7, 0x2B, 0x77, 0x1B, 0x72, 0xB7, 0x71, 0xB5,
  0x81, 0xAD, 0x11, 0xB7, 0x71, 0xB5, 0x81, 0xCF, 0xA1, 0xB7, 0x71, 0xB5, 0x05, 0xA0, 0x3B, 0x77,
  0x1B, 0x20, 0x90, 0x62, 0x81, 0xCF, 0x8B, 0x77, 0x1B, 0x10, 0x3A, 0x83, 0x10, 0x8F, 0xCB, 0x77,
  0x1B, 0x2A, 0x83, 0x40, 0x6F, 0xEB, 0x77, 0x1B, 0x10, 0x1A, 0x83, 0x40, 0x6F, 0xEB, 0x77, 0x1B,
  0x18, 0x63, 0xFE, 0x10, 0x9F, 0xCB, 0x77, 0x1B, 0x20, 0x70, 0x52, 0x81, 0xDF, 0x8B, 0x77, 0x1B,
  0x50, 0x6A, 0x02, 0xB7, 0x71, 0xB5, 0x81, 0xDF, 0x91, 0xB7, 0x71, 0xB5, 0x08, 0x0B, 0x2B, 0x77,
  0x1B, 0x72, 0xB7, 0x71, 0xB7, 0x2B, 0x77, 0x1B, 0x72, 0xB7, 0x71, 0xB7, 0x2B, 0x77, 0x1B, 0x72,
  0xB7, 0x71, 0xB7, 0x2F, 0xFF, 0x72, 0xFF, 0xF7, 0x20, 0xBF, 0xFD, 0x0B, 0x72, 0x03, 0x0E, 0xFF,
  0xB0, 0xE0, 0x37, 0x30, 0x10, 0x68, 0x09, 0x37, 0x06, 0x01, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_phonelink_ring() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_phonelink_ring_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_phonelink_setup 36x36, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_round_36_communication_phonelink_setup_data[] PROGMEM = {
  0x71, 0x04, 0x80, 0x94, 0x70, 0x47, 0x20, 0x9F, 0xFC, 0x09, 0x70, 0x4F, 0xFE, 0x04, 0x60, 0x7F,
  0xFE, 0x07, 0x60, 0x7F, 0xFE, 0x07, 0x60, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x77,
  0x70, 0x7A, 0x07, 0x68, 0x22, 0xDD, 0x27, 0x70, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x76, 0x82,
  0x57, 0x75, 0x77, 0x07, 0xA0, 0x76, 0xC7, 0x70, 0x7A, 0x07, 0x20, 0x12, 0x03, 0xC0, 0x42, 0x02,
  0x73, 0x07, 0xA8, 0x47, 0x01, 0xEE, 0xAE, 0x82, 0xAE, 0xE1, 0x72, 0x07, 0xA8, 0x17, 0x09, 0xFD,
  0x09, 0x72, 0x07, 0xA0, 0x70, 0x1D, 0x82, 0x71, 0x17, 0xD0, 0x17, 0x10, 0x7A, 0x81, 0x70, 0xAB,
  0x07, 0x40, 0x7B, 0x09, 0x72, 0x07, 0xA0, 0x72, 0x0B, 0xA0, 0x14, 0x01, 0xA0, 0xB7, 0x30, 0x7A,
  0x07, 0x20, 0xBA, 0x01, 0x40, 0x1A, 0x0B, 0x73, 0x07, 0xA8, 0x17, 0x0A, 0xB0, 0x74, 0x07, 0xB0,
  0xA7, 0x20, 0x7A, 0x07, 0x01, 0xD8, 0x27, 0x11, 0x7D, 0x01, 0x71, 0x07, 0xA8, 0x17, 0x09, 0xFD,
  0x09, 0x72, 0x07, 0xA8, 0x47, 0x01, 0xEE, 0xAE, 0x82, 0xAE, 0xE1, 0x72, 0x07, 0xA0, 0x72, 0x01,
  0x20, 0x3C, 0x03, 0x20, 0x17, 0x30, 0x7A, 0x07, 0x6C, 0x77, 0x07, 0xA0, 0x76, 0x82, 0x57, 0x75,
  0x77, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x68, 0x22, 0xDD, 0x27, 0x70, 0x7A, 0x07, 0x60,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x60, 0x7F, 0xFE, 0x07,
  0x60, 0x7F, 0xFE, 0x07, 0x60, 0x4F, 0xFE, 0x04, 0x70, 0x9F, 0xFC, 0x09, 0x72, 0x04, 0x80, 0x94,
  0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_phonelink_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_phonelink_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_phone 36x36, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_round_36_communication_phone_data[] PROGMEM = {
  0x28, 0x43, 0x77, 0x76, 0x27, 0x77, 0x09, 0xE0, 0x47, 0x75, 0x03, 0xF0, 0xE7, 0x75, 0x06, 0xF9,
  0x02, 0x77, 0x40, 0x5F, 0x90, 0x47, 0x74, 0x03, 0xF9, 0x06, 0x77, 0x40, 0x1F, 0x90, 0x77, 0x75,
  0x0D, 0xF0, 0x77, 0x75, 0x0A, 0xF0, 0x47, 0x75, 0x05, 0xE0, 0x97, 0x76, 0x01, 0xD0, 0x97, 0x77,
  0x10, 0xAB, 0x09, 0x77, 0x72, 0x03, 0xB0, 0x27, 0x77, 0x30, 0xBA, 0x0B, 0x77, 0x73, 0x03, 0xB0,
  0x57, 0x77, 0x30, 0x9A, 0x0E, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xA0, 0xC7, 0x77, 0x30, 0x3B, 0x0B,
  0x77, 0x73, 0x06, 0xB0, 0xB7, 0x18, 0x43, 0x77, 0x54, 0x27, 0x30, 0x8B, 0x0C, 0x01, 0x50, 0x9E,
  0x0D, 0x04, 0x72, 0x08, 0xB0, 0xE0, 0x53, 0x09, 0xFA, 0x02, 0x72, 0x06, 0xC8, 0x1B, 0x29, 0xFB,
  0x06, 0x73, 0x03, 0x0D, 0xFF, 0x90, 0x77, 0x40, 0x10, 0x9F, 0xF0, 0x77, 0x60, 0x30, 0xBF, 0xD0,
  0x77, 0x71, 0x03, 0x0A, 0xFB, 0x03, 0x77, 0x38, 0x21, 0x5A, 0xDD, 0x09, 0x77, 0x71, 0x83, 0x13,
  0x56, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_portable_wifi_off 36x36, 4-bit Alpha,  RLE, 331 bytes.
static const unsigned char ic_round_36_communication_portable_wifi_off_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDF, 0xED, 0xB8, 0x37, 0x48, 0x19, 0xB2, 0x40, 0x60, 0xDF, 0xB0, 0xE0,
  0x77, 0x10, 0x4A, 0x0E, 0x02, 0x30, 0xAF, 0xE0, 0xD0, 0x56, 0x01, 0x0E, 0xA0, 0xE0, 0x23, 0x83,
  0xAE, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x76, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x60, 0x60, 0xDB,
  0x0A, 0x60, 0x3B, 0x0E, 0x02, 0x77, 0x0A, 0xB0, 0x85, 0x04, 0xC0, 0xE0, 0x23, 0x85, 0x5C, 0xFE,
  0xD9, 0x44, 0x08, 0xB0, 0x54, 0x0D, 0xD0, 0xE0, 0x23, 0x0A, 0xD0, 0xB0, 0x23, 0x0A, 0xA0, 0xD3,
  0x07, 0xA8, 0x1D, 0x4E, 0xA0, 0xE0, 0x23, 0x0A, 0xD0, 0xE0, 0x33, 0x0D, 0xA0, 0x72, 0x0D, 0xA8,
  0x25, 0x03, 0xEA, 0x0E, 0x02, 0x40, 0x30, 0x8B, 0x0E, 0x02, 0x20, 0x6A, 0x81, 0xE0, 0x4A, 0x0D,
  0x30, 0xCB, 0x0E, 0x02, 0x50, 0x20, 0xDA, 0x0B, 0x30, 0xDA, 0x03, 0x08, 0xA0, 0x82, 0x04, 0xD0,
  0xE0, 0x25, 0x02, 0xB0, 0x42, 0x08, 0xA0, 0x80, 0xBA, 0x04, 0x20, 0x9A, 0x0B, 0x0E, 0xA0, 0xE0,
  0x25, 0x08, 0xA0, 0x92, 0x04, 0xA0, 0xB0, 0xDA, 0x01, 0x20, 0xDA, 0x81, 0x33, 0xEA, 0x0E, 0x02,
  0x40, 0x3A, 0x0D, 0x20, 0x2A, 0x0D, 0x0E, 0xA3, 0x0E, 0xA8, 0x11, 0x03, 0xB0, 0xE0, 0x24, 0xA0,
  0xE3, 0xA0, 0xEB, 0x30, 0xEA, 0x30, 0xDB, 0x0E, 0x02, 0x38, 0x1A, 0xFE, 0x3A, 0x00, 0xEA, 0x02,
  0x20, 0xCA, 0x03, 0x20, 0x8C, 0x0E, 0x02, 0x30, 0xA0, 0xD2, 0x02, 0xA0, 0xD0, 0xBA, 0x04, 0x20,
  0x9A, 0x09, 0x30, 0x80, 0xDB, 0x0E, 0x02, 0x30, 0x42, 0x04, 0xA0, 0xB0, 0x8A, 0x09, 0x20, 0x3B,
  0x03, 0x40, 0x30, 0xEA, 0x0E, 0x02, 0x50, 0x9A, 0x08, 0x04, 0xA0, 0xE3, 0x0B, 0xA0, 0xE0, 0x14,
  0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x0E, 0xA8, 0x14, 0x0E, 0xA0, 0x52, 0x02, 0x0E, 0xA0, 0x75, 0x03,
  0x0E, 0xA0, 0xE0, 0x23, 0x81, 0xAF, 0xD2, 0x07, 0xA0, 0xE0, 0x12, 0x82, 0x3E, 0xE3, 0x60, 0x30,
  0xEA, 0x0E, 0x02, 0x30, 0xA0, 0x63, 0x0E, 0xA0, 0xA7, 0x60, 0x30, 0xEA, 0x0E, 0x02, 0x70, 0x5B,
  0x09, 0x76, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x08, 0xB0, 0xA7, 0x60, 0x30, 0xEA, 0x0E, 0x02, 0x70,
  0xAB, 0x06, 0x76, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x08, 0xA0, 0x47, 0x70, 0x30, 0xEA, 0x0D, 0x71,
  0x00, 0x37, 0x72, 0x82, 0x3E, 0xFE, 0x77, 0x76, 0x81, 0x28, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_portable_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_portable_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_present_to_all 36x36, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_round_36_communication_present_to_all_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0xAF, 0xFF, 0xFA, 0x81, 0xA0, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x50, 0x06, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x07, 0x74, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x30, 0x7C, 0x07, 0x73, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x20, 0x7E, 0x07,
  0x72, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7F, 0x90, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x70,
  0x7F, 0xB0, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x3E, 0x73, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x3E,
  0x73, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x3E, 0x73, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x3E, 0x73, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x3E, 0x73, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x3E, 0x73, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77,
  0x50, 0x7A, 0x00, 0x7A, 0x09, 0x77, 0x75, 0x09, 0xA0, 0x07, 0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0,
  0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0xAF, 0xFF, 0xFA, 0x0A, 0x30, 0x48, 0x0B, 0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_present_to_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_present_to_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_print_disabled 36x36, 4-bit Alpha,  RLE, 269 bytes.
static const unsigned char ic_round_36_communication_print_disabled_data[] PROGMEM = {
  0x18, 0x1B, 0xD3, 0x77, 0x77, 0x10, 0x5A, 0x0E, 0x03, 0x40, 0x18, 0x09, 0x47, 0x02, 0x60, 0x10,
  0xDA, 0x0E, 0x03, 0x30, 0x7F, 0xFA, 0x0D, 0x70, 0x20, 0xDA, 0x0E, 0x03, 0x30, 0x8F, 0xFA, 0x71,
  0x02, 0x0D, 0xA0, 0xE0, 0x33, 0x08, 0xFF, 0x97, 0x20, 0x20, 0xDA, 0x0E, 0x03, 0x30, 0x8F, 0xF7,
  0x30, 0x20, 0xDA, 0x0E, 0x03, 0x30, 0x8F, 0xD0, 0xD7, 0x40, 0x20, 0xDA, 0x0E, 0x03, 0x30, 0x68,
  0x07, 0x70, 0x27, 0x50, 0x20, 0xDA, 0x0E, 0x03, 0x77, 0x75, 0x07, 0x0C, 0xC0, 0xE0, 0x33, 0x08,
  0xFD, 0x0C, 0x07, 0x60, 0xBF, 0x0E, 0x03, 0x30, 0x8F, 0xE0, 0xB4, 0x07, 0xFA, 0x0E, 0x03, 0x30,
  0x8F, 0xE0, 0x73, 0x0C, 0xFB, 0x0E, 0x03, 0x30, 0x8F, 0x81, 0x70, 0x7A, 0x0C, 0x3F, 0xD0, 0xE0,
  0x33, 0x08, 0xE3, 0xB3, 0xFE, 0x0E, 0x03, 0x30, 0x8D, 0x81, 0x70, 0x7B, 0x3F, 0xF0, 0xE0, 0x33,
  0x08, 0xFB, 0x3F, 0xF9, 0x0E, 0x03, 0x30, 0x8F, 0xA3, 0xFF, 0xA0, 0xE0, 0x33, 0x08, 0xF9, 0x3F,
  0xA4, 0x02, 0x0D, 0xA0, 0xE0, 0x33, 0x08, 0xF3, 0xFA, 0x50, 0x20, 0xDA, 0x0E, 0x03, 0x30, 0x8E,
  0x30, 0xBF, 0x96, 0x02, 0x0D, 0xA0, 0xE0, 0x33, 0x08, 0xC0, 0xB3, 0x03, 0x0E, 0xF7, 0x02, 0x0D,
  0xA0, 0xE0, 0x33, 0x08, 0xA0, 0xE0, 0x34, 0x01, 0x06, 0x0F, 0x7B, 0x71, 0x02, 0x0D, 0xA0, 0xE0,
  0x33, 0x81, 0x66, 0x17, 0x3B, 0x72, 0x02, 0x0D, 0xA0, 0xE0, 0x37, 0x71, 0xB0, 0x27, 0x20, 0x20,
  0xDA, 0x0E, 0x03, 0x77, 0xB0, 0xD0, 0x88, 0x04, 0x70, 0x80, 0xDB, 0x0E, 0x03, 0x76, 0x0B, 0xFF,
  0xC0, 0xE0, 0x37, 0x50, 0x30, 0xEF, 0xF0, 0xE0, 0xDA, 0x0E, 0x03, 0x75, 0x01, 0x06, 0x80, 0x90,
  0x78, 0x26, 0x12, 0xDA, 0x0E, 0x03, 0x77, 0x77, 0x02, 0x0D, 0xA0, 0xE0, 0x37, 0x77, 0x70, 0x20,
  0xDA, 0x0C, 0x77, 0x77, 0x18, 0x22, 0xDF, 0xA7, 0x77, 0x72, 0x01, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_print_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 32, 35), Box(0, 0, 35, 35),
      ic_round_36_communication_print_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_qr_code_2 36x36, 4-bit Alpha,  RLE, 316 bytes.
static const unsigned char ic_round_36_communication_qr_code_2_data[] PROGMEM = {
  0x10, 0x58, 0x02, 0x70, 0x55, 0x0F, 0x72, 0x05, 0x80, 0x27, 0x81, 0x50, 0x5F, 0x90, 0x54, 0xB1,
  0x05, 0xF9, 0x89, 0x15, 0x7F, 0xEB, 0xBB, 0xBE, 0xF7, 0x4B, 0x18, 0xA2, 0x7F, 0xEB, 0xBB, 0xBE,
  0xF7, 0x7F, 0xB0, 0x11, 0x0B, 0xF7, 0x18, 0x02, 0x71, 0x89, 0x47, 0xFB, 0x01, 0x10, 0xBF, 0x77,
  0xFB, 0x1A, 0x82, 0x1B, 0xF7, 0x1B, 0x48, 0x27, 0xFB, 0x1A, 0x86, 0x1B, 0xF7, 0x7F, 0xB1, 0xA8,
  0x21, 0xBF, 0x71, 0xB4, 0x82, 0x7F, 0xB1, 0xA8, 0x94, 0x1B, 0xF7, 0x7F, 0xB0, 0x11, 0x0B, 0xF7,
  0x1B, 0x0F, 0x71, 0x8A, 0x27, 0xFB, 0x01, 0x10, 0xBF, 0x77, 0xFE, 0xBB, 0xBB, 0xEF, 0x71, 0xE1,
  0x89, 0x17, 0xFE, 0xBB, 0xBB, 0xEF, 0x75, 0xF9, 0x05, 0x1E, 0x10, 0x5F, 0x98, 0x15, 0x05, 0x80,
  0x27, 0x05, 0x28, 0x02, 0x72, 0x05, 0x80, 0x27, 0x05, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x20, 0x7F,
  0x90, 0x75, 0x07, 0xA0, 0x73, 0x07, 0xA0, 0x72, 0x07, 0xF9, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x7A,
  0x07, 0x20, 0x7F, 0x90, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xD0,
  0x72, 0x07, 0xA0, 0x73, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xD0, 0x72, 0x07, 0xA0, 0x73,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xD0, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x07, 0x71,
  0x07, 0xA8, 0x17, 0x05, 0x80, 0x27, 0x05, 0x30, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x70, 0x5F, 0x90,
  0x52, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x89, 0x17, 0x7F, 0xEB, 0xBB, 0xBE, 0xF7, 0x20, 0x7A, 0x07,
  0x20, 0x7D, 0x07, 0x38, 0x90, 0x7F, 0xB0, 0x11, 0x0B, 0xF7, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x07,
  0x38, 0x27, 0xFB, 0x1A, 0x82, 0x1B, 0xF7, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x07, 0x38, 0x27, 0xFB,
  0x1A, 0x82, 0x1B, 0xF7, 0x20, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x38, 0x90, 0x7F, 0xB0, 0x11, 0x0B,
  0xF7, 0x20, 0x38, 0x01, 0x70, 0x32, 0x07, 0xA8, 0x94, 0xB7, 0x73, 0x7F, 0xEB, 0xBB, 0xBE, 0xF7,
  0x50, 0x7A, 0x07, 0x20, 0x7D, 0x07, 0x05, 0xF9, 0x05, 0x50, 0x7A, 0x07, 0x20, 0x7D, 0x81, 0x70,
  0x58, 0x02, 0x70, 0x56, 0x82, 0x37, 0x73, 0x20, 0x38, 0x01, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_qr_code_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_qr_code_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_qr_code 36x36, 4-bit Alpha,  RLE, 282 bytes.
static const unsigned char ic_round_36_communication_qr_code_data[] PROGMEM = {
  0x20, 0x48, 0x03, 0x70, 0x46, 0x04, 0x80, 0x37, 0x04, 0x30, 0x9F, 0xA0, 0x94, 0x09, 0xFA, 0x81,
  0x90, 0x4F, 0xC0, 0x42, 0x04, 0xFC, 0x04, 0x07, 0xA0, 0xB8, 0x01, 0x70, 0xBA, 0x07, 0x20, 0x7A,
  0x0B, 0x80, 0x17, 0x0B, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x75, 0x07,
  0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x01,
  0x70, 0xBA, 0x07, 0x20, 0x7A, 0x0B, 0x80, 0x17, 0x0B, 0xA0, 0x70, 0x4F, 0xC0, 0x42, 0x04, 0xFC,
  0x81, 0x40, 0x9F, 0xA0, 0x94, 0x09, 0xFA, 0x09, 0x30, 0x48, 0x03, 0x70, 0x46, 0x04, 0x80, 0x37,
  0x04, 0x80, 0xF0, 0x00, 0x48, 0x03, 0x70, 0x44, 0x82, 0x17, 0x71, 0x28, 0x21, 0x77, 0x14, 0x09,
  0xFA, 0x09, 0x30, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x30, 0x4F, 0xC0, 0x42, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x73, 0x07, 0xA0, 0xB8, 0x01, 0x70, 0xBA, 0x07, 0x28, 0x94, 0x17, 0x73, 0x77, 0x37, 0x73,
  0x77, 0x17, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07,
  0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x89, 0x41, 0x77,
  0x37, 0x73, 0x77, 0x37, 0x71, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07,
  0x30, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x30, 0x7A, 0x0B, 0x80,
  0x17, 0x0B, 0xA0, 0x72, 0x89, 0x41, 0x77, 0x37, 0x73, 0x77, 0x37, 0x71, 0x4F, 0xC0, 0x45, 0x07,
  0xA0, 0x72, 0x07, 0xA8, 0x17, 0x09, 0xFA, 0x09, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x48,
  0x03, 0x70, 0x47, 0x82, 0x17, 0x71, 0x28, 0x21, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_qr_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_qr_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_qr_code_scanner 36x36, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_round_36_communication_qr_code_scanner_data[] PROGMEM = {
  0x08, 0xD0, 0xD0, 0x27, 0x70, 0x20, 0xDD, 0x08, 0xF0, 0x67, 0x70, 0x6F, 0xE0, 0xD0, 0x27, 0x70,
  0x20, 0xDF, 0xA7, 0x77, 0x3E, 0x10, 0x38, 0x04, 0x70, 0x32, 0x03, 0x80, 0x47, 0x03, 0x1E, 0x10,
  0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07, 0x1B, 0x89, 0x4D, 0xFD, 0x07, 0xFE, 0xBB, 0xBB, 0xEF, 0x72,
  0x8A, 0x37, 0xFE, 0xBB, 0xBB, 0xEF, 0x70, 0xDF, 0xD2, 0x72, 0x07, 0xFB, 0x48, 0x1B, 0xF7, 0x28,
  0x17, 0xFB, 0x48, 0x5B, 0xF7, 0x02, 0x72, 0x48, 0x17, 0xFB, 0x48, 0x1B, 0xF7, 0x28, 0x17, 0xFB,
  0x48, 0x1B, 0xF7, 0x71, 0x81, 0x7F, 0xB4, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB4, 0x81, 0xBF, 0x77,
  0x18, 0x17, 0xFB, 0x48, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0x48, 0x1B, 0xF7, 0x71, 0x89, 0x07, 0xFE,
  0xBB, 0xBB, 0xEF, 0x72, 0x89, 0x07, 0xFE, 0xBB, 0xBB, 0xEF, 0x77, 0x10, 0x7F, 0x90, 0x72, 0x07,
  0xF9, 0x07, 0x71, 0x03, 0x80, 0x47, 0x03, 0x20, 0x38, 0x04, 0x70, 0x38, 0x09, 0x80, 0x00, 0x38,
  0x04, 0x70, 0x32, 0x81, 0x37, 0x52, 0x81, 0x77, 0x17, 0x30, 0x7F, 0x90, 0x72, 0x81, 0x7F, 0xB2,
  0xA0, 0x37, 0x38, 0x90, 0x7F, 0xEB, 0xBB, 0xBE, 0xF7, 0x28, 0x90, 0x5B, 0x93, 0x3B, 0xB5, 0x31,
  0x71, 0x81, 0x7F, 0xB4, 0x81, 0xBF, 0x74, 0x03, 0xA2, 0x81, 0xBF, 0x77, 0x18, 0x17, 0xFB, 0x48,
  0x1B, 0xF7, 0x40, 0x3A, 0x28, 0x1B, 0xF7, 0x71, 0x81, 0x7F, 0xB4, 0x81, 0xBF, 0x72, 0x81, 0x7F,
  0xB2, 0xA0, 0x36, 0x85, 0x27, 0x20, 0x7F, 0xB4, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB2, 0xA0, 0x33,
  0x89, 0x72, 0x72, 0xDF, 0xD0, 0x7F, 0xEB, 0xBB, 0xBE, 0xF7, 0x28, 0x94, 0x13, 0x5B, 0xB3, 0x39,
  0xB5, 0x0D, 0xFD, 0xB1, 0x07, 0xF9, 0x07, 0x40, 0x3A, 0x28, 0x1B, 0xF7, 0x1E, 0x10, 0x38, 0x04,
  0x70, 0x34, 0x81, 0x17, 0x72, 0x81, 0x57, 0x31, 0xE7, 0x77, 0x3F, 0xA0, 0xD0, 0x27, 0x70, 0x20,
  0xDF, 0xE0, 0x67, 0x70, 0x6F, 0x08, 0xD0, 0xD0, 0x27, 0x70, 0x20, 0xDD, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_qr_code_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_qr_code_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_read_more 36x36, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_36_communication_read_more_data[] PROGMEM = {
  0x77, 0x30, 0x58, 0x07, 0x70, 0x27, 0x20, 0x40, 0x15, 0x05, 0xFD, 0x0D, 0x72, 0x90, 0xD0, 0x14,
  0x05, 0xFD, 0x0D, 0x72, 0xA0, 0xD0, 0x14, 0x05, 0x80, 0x77, 0x02, 0x72, 0xB0, 0xD0, 0x17, 0x77,
  0x4C, 0x0D, 0x01, 0x77, 0x10, 0x28, 0x04, 0x7D, 0x0D, 0x01, 0x50, 0x28, 0x03, 0x70, 0x20, 0xDF,
  0xF0, 0xD5, 0x0D, 0xF0, 0x0D, 0xFF, 0x0D, 0x50, 0xDF, 0x0D, 0x02, 0x80, 0x47, 0xD0, 0xD0, 0x15,
  0x02, 0x80, 0x37, 0x02, 0x72, 0xC0, 0xD0, 0x17, 0x77, 0x3B, 0x0D, 0x01, 0x77, 0x74, 0xA0, 0xD0,
  0x14, 0x05, 0x80, 0x77, 0x02, 0x72, 0x90, 0xD0, 0x14, 0x05, 0xFD, 0x0D, 0x72, 0x04, 0x01, 0x50,
  0x5F, 0xD0, 0xD7, 0x73, 0x05, 0x80, 0x77, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_read_more() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 10, 32, 25), Box(0, 0, 35, 35),
      ic_round_36_communication_read_more_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_ring_volume 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_round_36_communication_ring_volume_data[] PROGMEM = {
  0x77, 0x28, 0x22, 0xDD, 0x27, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x77,
  0x74, 0x07, 0xA0, 0x77, 0x77, 0x10, 0x17, 0x20, 0x7A, 0x07, 0x77, 0x78, 0x1B, 0xF9, 0x71, 0x07,
  0xA0, 0x77, 0x18, 0x18, 0xFB, 0x73, 0xB0, 0x97, 0x05, 0xA0, 0x57, 0x09, 0xB7, 0x30, 0x8B, 0x09,
  0x70, 0x05, 0x70, 0x9B, 0x08, 0x74, 0x08, 0xB0, 0x87, 0x70, 0x9B, 0x09, 0x76, 0x08, 0xB7, 0x7B,
  0x09, 0x77, 0x18, 0x18, 0xFA, 0x77, 0x81, 0xAF, 0x98, 0x0A, 0xB7, 0x08, 0x32, 0x59, 0xBD, 0xC8,
  0x3D, 0xB9, 0x62, 0x77, 0x58, 0x12, 0x8D, 0xFF, 0x81, 0xD9, 0x37, 0x70, 0x30, 0xBF, 0xFE, 0x0C,
  0x04, 0x73, 0x02, 0x0A, 0xD8, 0x4E, 0xB7, 0x42, 0x12, 0x84, 0x12, 0x47, 0xAE, 0xD0, 0xB0, 0x37,
  0x06, 0x0E, 0xE0, 0x17, 0x60, 0xEE, 0x08, 0x50, 0xAF, 0x90, 0x17, 0x60, 0xEF, 0x0C, 0x01, 0x20,
  0xCF, 0xA0, 0x17, 0x60, 0xEF, 0x98, 0x1D, 0x17, 0xFB, 0x01, 0x76, 0x0E, 0xFA, 0x00, 0xAF, 0xA0,
  0xE7, 0x70, 0xCF, 0xA0, 0xD0, 0x8F, 0xA0, 0x97, 0x70, 0x6F, 0xA8, 0x1A, 0x1D, 0xF0, 0xA7, 0x72,
  0x08, 0xF8, 0x3E, 0x20, 0x2D, 0xD0, 0x77, 0x74, 0x05, 0x0E, 0xC0, 0xE0, 0x33, 0x02, 0x0C, 0xA0,
  0xE0, 0x47, 0x76, 0x03, 0x0D, 0xA0, 0xD0, 0x36, 0x00, 0x47, 0x77, 0x30, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_ring_volume() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 35, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_ring_volume_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_rss_feed 36x36, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_round_36_communication_rss_feed_data[] PROGMEM = {
  0x10, 0x10, 0x27, 0x77, 0x06, 0xB8, 0x1C, 0x96, 0x77, 0x30, 0xEE, 0x81, 0xEA, 0x47, 0x70, 0xDF,
  0xA0, 0xC0, 0x37, 0x50, 0x30, 0xDF, 0xB0, 0x90, 0x17, 0x58, 0x21, 0x47, 0xBF, 0x0E, 0x03, 0x77,
  0x18, 0x11, 0x7D, 0xE0, 0x57, 0x73, 0x07, 0xE0, 0x77, 0x73, 0x02, 0x0C, 0xD0, 0x56, 0x83, 0x18,
  0x95, 0x27, 0x0A, 0xD0, 0x35, 0x0B, 0xC0, 0xB0, 0x56, 0x08, 0xC0, 0xE0, 0x14, 0x0E, 0xE0, 0xB0,
  0x25, 0x0A, 0xC0, 0x94, 0x0A, 0xF9, 0x05, 0x50, 0xCC, 0x03, 0x48, 0x16, 0xBE, 0xE0, 0x74, 0x02,
  0xC0, 0xC7, 0x06, 0x0D, 0xD0, 0x54, 0x08, 0xC0, 0x47, 0x10, 0x9D, 0x02, 0x40, 0xDB, 0x0A, 0x72,
  0x08, 0xC0, 0xC4, 0x07, 0xB0, 0xE4, 0x81, 0x57, 0x33, 0x09, 0xC0, 0x53, 0x01, 0xC8, 0x26, 0x02,
  0xDB, 0x08, 0x30, 0xDB, 0x0B, 0x40, 0xBB, 0x81, 0x90, 0xAD, 0x03, 0x20, 0x6C, 0x02, 0x30, 0x7B,
  0x81, 0xC0, 0xED, 0x07, 0x30, 0xEB, 0x06, 0x30, 0x4C, 0x10, 0xDD, 0x05, 0x30, 0xBB, 0x09, 0x30,
  0x1C, 0x02, 0x06, 0xC0, 0xD4, 0x06, 0xB0, 0x84, 0x0D, 0xB8, 0x51, 0x06, 0xCE, 0xA2, 0x58, 0x2A,
  0xEB, 0x14, 0x82, 0x4D, 0xE6, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_rss_feed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 29, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_rss_feed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_rtt 36x36, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_round_36_communication_rtt_data[] PROGMEM = {
  0x74, 0x01, 0x06, 0x80, 0x92, 0x70, 0x47, 0x50, 0x20, 0xEF, 0xFA, 0x09, 0x74, 0x0A, 0xFF, 0xC0,
  0x43, 0x03, 0x80, 0x17, 0x10, 0xEF, 0xFC, 0x06, 0x20, 0x1D, 0x0D, 0x01, 0xB8, 0x3D, 0x55, 0x58,
  0xB8, 0x3A, 0x55, 0x5B, 0xB0, 0x52, 0x01, 0xD0, 0xA0, 0x3B, 0x0A, 0x30, 0x7B, 0x05, 0x30, 0xBB,
  0x03, 0x38, 0x53, 0x77, 0x77, 0x46, 0xB0, 0x83, 0x09, 0xB0, 0x33, 0x0E, 0xB0, 0x17, 0x20, 0x8B,
  0x05, 0x30, 0xBB, 0x01, 0x20, 0x1B, 0x0E, 0x73, 0x0B, 0xB0, 0x33, 0x0E, 0xA0, 0xE3, 0x03, 0xB0,
  0xB3, 0x02, 0x80, 0x17, 0x10, 0xBB, 0x30, 0x1B, 0x0B, 0x30, 0x3B, 0x08, 0x30, 0xEC, 0x84, 0xE0,
  0x3E, 0xF7, 0x30, 0x3B, 0x09, 0x48, 0x2A, 0xFD, 0x23, 0x0E, 0xC0, 0xB7, 0x10, 0x6B, 0x06, 0x74,
  0x84, 0x27, 0x77, 0x75, 0x71, 0x08, 0xB0, 0x47, 0x77, 0x40, 0xAB, 0x02, 0x77, 0x74, 0x0D, 0xB7,
  0x40, 0x18, 0x04, 0x70, 0x25, 0xB0, 0xC7, 0x40, 0xAF, 0x90, 0x34, 0x02, 0xB0, 0xA7, 0x40, 0xAF,
  0x90, 0x14, 0x05, 0xB0, 0x77, 0x40, 0x10, 0x68, 0x03, 0x75, 0x07, 0xB0, 0x57, 0x77, 0x40, 0xAB,
  0x03, 0x77, 0x74, 0x0C, 0xB7, 0x50, 0x68, 0x03, 0x70, 0x35, 0x0E, 0xA0, 0xD7, 0x40, 0x9F, 0x90,
  0x44, 0x01, 0xB0, 0xB7, 0x40, 0x9F, 0x90, 0x22, 0x81, 0x45, 0x8B, 0x81, 0xB5, 0x27, 0x30, 0x68,
  0x03, 0x72, 0x0A, 0xFA, 0x05, 0x77, 0x5F, 0xB0, 0xA7, 0x75, 0x0C, 0xFA, 0x07, 0x77, 0x60, 0x68,
  0x03, 0x70, 0x57, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_rtt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_rtt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_screen_share 36x36, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_round_36_communication_screen_share_data[] PROGMEM = {
  0x40, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x87, 0x08, 0xFF, 0xFF, 0x08, 0x60, 0xDF, 0xFF, 0xF0, 0xD6,
  0xFF, 0xFF, 0xA6, 0xFF, 0xA0, 0xDF, 0xE6, 0xFF, 0xA0, 0x70, 0x6F, 0xD6, 0xFF, 0xA8, 0x17, 0x05,
  0xFC, 0x6F, 0xF9, 0x0E, 0x05, 0x20, 0x4F, 0xB6, 0xFD, 0x81, 0xE8, 0x25, 0x03, 0x0E, 0xF9, 0x6F,
  0xC0, 0xA0, 0x17, 0x10, 0x3F, 0x96, 0xFB, 0x08, 0x73, 0x01, 0x0E, 0xF6, 0xFA, 0x0A, 0x73, 0x02,
  0x0D, 0xF9, 0x6F, 0x90, 0xE0, 0x13, 0x82, 0x46, 0x74, 0x20, 0x20, 0xDF, 0xA6, 0xF9, 0x83, 0x70,
  0x2A, 0xEB, 0x82, 0x70, 0x3E, 0xFB, 0x6F, 0x90, 0x10, 0x7E, 0x81, 0x74, 0xEF, 0xC6, 0xF0, 0xB0,
  0x8F, 0x0B, 0xFE, 0x6F, 0x0E, 0xFF, 0xF9, 0x6F, 0xFF, 0xFA, 0x60, 0xDF, 0xFF, 0xF0, 0xD6, 0x08,
  0xFF, 0xFF, 0x08, 0x70, 0x80, 0xDF, 0xFF, 0xB0, 0xD0, 0x84, 0x08, 0xFF, 0xFF, 0xE0, 0x80, 0xEF,
  0xFF, 0xFE, 0x0E, 0x08, 0xFF, 0xFF, 0xE0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_send_time_extension 36x36, 4-bit Alpha,  RLE, 214 bytes.
static const unsigned char ic_round_36_communication_send_time_extension_data[] PROGMEM = {
  0x74, 0x82, 0x39, 0xA7, 0x77, 0x75, 0x07, 0xC0, 0xD0, 0x17, 0x77, 0x20, 0x2E, 0x09, 0x77, 0x72,
  0x06, 0xE0, 0xD7, 0x71, 0x03, 0x0B, 0xFF, 0xE0, 0xD0, 0x86, 0x01, 0x0E, 0xFF, 0xFA, 0x08, 0x50,
  0x5F, 0xFF, 0xB0, 0xD5, 0x07, 0xFF, 0xFC, 0x50, 0x7F, 0xFF, 0xC5, 0x07, 0xFF, 0xFC, 0x50, 0x7F,
  0xFF, 0xC5, 0x07, 0xFC, 0x00, 0x9F, 0xD5, 0x05, 0x0C, 0xFB, 0x82, 0x70, 0x29, 0xFB, 0x70, 0x10,
  0x9F, 0x90, 0x73, 0x02, 0x09, 0xF9, 0x72, 0x0B, 0xF0, 0x75, 0x02, 0x09, 0xE7, 0x20, 0x4F, 0x07,
  0x70, 0x20, 0x9C, 0x73, 0xF0, 0x72, 0x81, 0x67, 0x14, 0x02, 0x09, 0xA7, 0x20, 0x1F, 0x07, 0x28,
  0x37, 0xFE, 0x71, 0x40, 0x20, 0x97, 0x20, 0x7F, 0x07, 0x20, 0x7B, 0x81, 0xE7, 0x17, 0x50, 0x20,
  0xEF, 0x07, 0x20, 0x7D, 0x81, 0xE7, 0x17, 0x82, 0x14, 0x8E, 0xF9, 0x07, 0x20, 0x7F, 0x81, 0xE7,
  0x15, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xA8, 0x1E, 0x71, 0x30, 0x7F, 0xC0, 0x73, 0x81, 0x37, 0xBF,
  0x98, 0x3E, 0x71, 0x07, 0xFC, 0x07, 0x68, 0x11, 0x7E, 0xF8, 0x1D, 0x17, 0xFC, 0x07, 0x38, 0x13,
  0x7B, 0xF9, 0x83, 0xE7, 0x10, 0x7F, 0xA8, 0x1E, 0x61, 0x20, 0x7F, 0xA8, 0x1E, 0x71, 0x30, 0x7F,
  0x90, 0xE0, 0x24, 0x07, 0xF8, 0x1E, 0x71, 0x50, 0x4F, 0x90, 0x85, 0x07, 0xD8, 0x1E, 0x71, 0x71,
  0x09, 0xF0, 0x45, 0x07, 0xB8, 0x1E, 0x71, 0x74, 0x04, 0x80, 0x27, 0x01, 0x58, 0x37, 0xFE, 0x71,
  0x77, 0x75, 0x81, 0x67, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_send_time_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 34, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_send_time_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_sentiment_satisfied_alt 36x36, 4-bit Alpha,  RLE, 272 bytes.
static const unsigned char ic_round_36_communication_sentiment_satisfied_alt_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x08, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x20,
  0xAB, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xB0, 0xA7, 0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x07, 0x50, 0x5B,
  0x08, 0x77, 0x20, 0x8B, 0x05, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xAA, 0x0D, 0x30, 0x7A, 0x0D, 0x77,
  0x60, 0xDA, 0x07, 0x20, 0xEA, 0x06, 0x38, 0x28, 0xEC, 0x36, 0x82, 0x3C, 0xE8, 0x30, 0x6A, 0x81,
  0xE0, 0x3A, 0x0D, 0x30, 0x4B, 0x0C, 0x60, 0xCB, 0x04, 0x30, 0xDA, 0x03, 0x08, 0xA0, 0x83, 0x06,
  0xB0, 0xE6, 0x0E, 0xB0, 0x63, 0x08, 0xA0, 0x80, 0xBA, 0x04, 0x30, 0x10, 0xEA, 0x08, 0x60, 0x8A,
  0x0E, 0x01, 0x30, 0x4A, 0x0B, 0x0D, 0xA0, 0x24, 0x81, 0x16, 0x47, 0x18, 0x14, 0x61, 0x40, 0x2A,
  0x0D, 0x0E, 0xA7, 0x77, 0x3A, 0x00, 0xEA, 0x77, 0x73, 0xA0, 0xE0, 0xDA, 0x02, 0x77, 0x71, 0x02,
  0xA0, 0xD0, 0xBA, 0x04, 0x40, 0x02, 0x73, 0x00, 0x24, 0x04, 0xA0, 0xB0, 0x8A, 0x08, 0x4A, 0x03,
  0x71, 0x03, 0x0E, 0x94, 0x08, 0xA0, 0x80, 0x3A, 0x0D, 0x48, 0x2C, 0xFE, 0x36, 0x82, 0x3D, 0xFC,
  0x40, 0xDA, 0x81, 0x30, 0xEA, 0x06, 0x30, 0x10, 0xEA, 0x84, 0x93, 0x11, 0x39, 0xA0, 0xE0, 0x23,
  0x06, 0xA0, 0xE2, 0x07, 0xA0, 0xD4, 0x02, 0x0C, 0xF9, 0x0C, 0x02, 0x40, 0xDA, 0x07, 0x30, 0xDA,
  0x0A, 0x50, 0x60, 0xCC, 0x0C, 0x06, 0x50, 0xAA, 0x0D, 0x40, 0x5B, 0x08, 0x70, 0x02, 0x70, 0x8B,
  0x05, 0x50, 0x8B, 0x0A, 0x77, 0x0A, 0xB0, 0x77, 0x0A, 0xB0, 0xD0, 0x67, 0x30, 0x60, 0xDB, 0x0A,
  0x72, 0x08, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0,
  0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_sentiment_satisfied_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_sentiment_satisfied_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_sip 36x36, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_round_36_communication_sip_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xF1, 0xF0, 0x98, 0x01, 0x70, 0xBA, 0x00, 0x9A, 0x85, 0xD8, 0x77, 0x77, 0x9F, 0xA0, 0x97, 0x90,
  0x92, 0x81, 0x9F, 0x26, 0x09, 0xF9, 0x89, 0x07, 0x01, 0x33, 0x33, 0x8F, 0x72, 0x07, 0x92, 0x81,
  0x23, 0x32, 0x07, 0xF9, 0x81, 0x70, 0x38, 0x00, 0xDA, 0x07, 0x20, 0x79, 0x20, 0xBA, 0x81, 0x30,
  0x7F, 0x90, 0x76, 0x81, 0x5F, 0x72, 0x07, 0x92, 0x81, 0x23, 0x32, 0x07, 0xF9, 0x0C, 0x79, 0x07,
  0x20, 0x79, 0x70, 0x9F, 0xA8, 0x3E, 0xDD, 0xDA, 0x29, 0x07, 0x20, 0x79, 0x28, 0x35, 0x77, 0x79,
  0xFA, 0x84, 0xD4, 0x33, 0x32, 0x29, 0x07, 0x20, 0x79, 0x20, 0xBF, 0xE0, 0x86, 0x81, 0x2F, 0x92,
  0x09, 0x92, 0x0C, 0xFE, 0x86, 0xE8, 0x77, 0x77, 0x8D, 0xA0, 0x09, 0xA0, 0xB0, 0x98, 0x09, 0xF6,
  0xF0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28, 0x08, 0xDF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_speaker_phone 36x36, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_round_36_communication_speaker_phone_data[] PROGMEM = {
  0x78, 0x61, 0x45, 0x77, 0x54, 0x17, 0x48, 0x11, 0x8C, 0xF9, 0x81, 0xC8, 0x16, 0x02, 0x09, 0xFF,
  0x09, 0x02, 0x30, 0x60, 0xED, 0x84, 0xB9, 0x88, 0x9B, 0xD8, 0x2E, 0x60, 0x9C, 0x0B, 0x04, 0x71,
  0x04, 0x0B, 0xC0, 0x90, 0xDA, 0x0C, 0x03, 0x75, 0x03, 0x0C, 0xA8, 0x2D, 0x5D, 0x75, 0x84, 0x25,
  0x77, 0x52, 0x58, 0x17, 0xD5, 0x60, 0x70, 0xDE, 0x0D, 0x07, 0x73, 0x03, 0x0D, 0xFB, 0x0D, 0x03,
  0x71, 0x0B, 0xB8, 0x4E, 0xA8, 0x8A, 0xEB, 0x0B, 0x71, 0x82, 0x7F, 0xE6, 0x68, 0x26, 0xEF, 0x77,
  0x20, 0x27, 0x30, 0x28, 0x0E, 0x20, 0x08, 0xFB, 0x08, 0x73, 0xFD, 0x73, 0xFD, 0x73, 0x90, 0x77,
  0x10, 0x79, 0x73, 0x90, 0x77, 0x10, 0x79, 0x73, 0x90, 0x77, 0x10, 0x79, 0x73, 0x90, 0x77, 0x10,
  0x79, 0x73, 0x90, 0x77, 0x10, 0x79, 0x73, 0x90, 0x77, 0x10, 0x79, 0x73, 0x90, 0x77, 0x10, 0x79,
  0x73, 0x90, 0x77, 0x10, 0x79, 0x73, 0x90, 0x77, 0x10, 0x79, 0x73, 0x90, 0x77, 0x10, 0x79, 0x73,
  0x90, 0x77, 0x10, 0x79, 0x73, 0x90, 0x77, 0x10, 0x79, 0x73, 0xFD, 0x73, 0xFC, 0x0E, 0x73, 0x08,
  0xFB, 0x07, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_speaker_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_speaker_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_spoke 36x36, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_round_36_communication_spoke_data[] PROGMEM = {
  0x75, 0x82, 0x47, 0x74, 0x77, 0x71, 0x05, 0x0D, 0xC0, 0xD0, 0x57, 0x75, 0x06, 0xF9, 0x06, 0x77,
  0x30, 0x2F, 0xB0, 0x27, 0x72, 0x09, 0xFB, 0x09, 0x77, 0x20, 0xDF, 0xB0, 0xD7, 0x72, 0xFD, 0x77,
  0x20, 0xDF, 0xB0, 0xD7, 0x72, 0x09, 0xFB, 0x09, 0x77, 0x20, 0x2F, 0xB0, 0x27, 0x73, 0x06, 0xF9,
  0x06, 0x77, 0x50, 0x50, 0xDC, 0x0D, 0x05, 0x77, 0x71, 0x82, 0x47, 0x74, 0x80, 0x98, 0x40, 0x83,
  0x25, 0x75, 0x27, 0x38, 0x32, 0x57, 0x52, 0x60, 0x10, 0xAD, 0x0A, 0x01, 0x60, 0x10, 0xAD, 0x0A,
  0x01, 0x30, 0x10, 0xDF, 0x0D, 0x01, 0x40, 0x10, 0xDF, 0x0D, 0x01, 0x20, 0xAF, 0xA0, 0xA4, 0x0A,
  0xFA, 0x81, 0xA0, 0x2F, 0xC0, 0x22, 0x02, 0xFC, 0x02, 0x06, 0xFC, 0x06, 0x20, 0x6F, 0xC0, 0x60,
  0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07, 0x06, 0xFC, 0x06, 0x20, 0x6F, 0xC0, 0x60, 0x2F, 0xC0, 0x22,
  0x02, 0xFC, 0x81, 0x20, 0xAF, 0xA0, 0xA4, 0x0A, 0xFA, 0x0A, 0x20, 0x10, 0xDF, 0x0D, 0x01, 0x40,
  0x10, 0xDF, 0x0D, 0x01, 0x30, 0x10, 0xAD, 0x0A, 0x01, 0x60, 0x10, 0xAD, 0x0A, 0x01, 0x68, 0x32,
  0x57, 0x52, 0x73, 0x83, 0x25, 0x75, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_spoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_spoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_stay_current_landscape 36x36, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_round_36_communication_stay_current_landscape_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x3F, 0xFF, 0xFC, 0x04, 0x07,
  0xD0, 0xB8, 0x0A, 0x07, 0x0B, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76,
  0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0,
  0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0,
  0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76,
  0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0,
  0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0xB8, 0x0A, 0x07, 0x0B,
  0xD0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x30, 0x48, 0x0B, 0x07, 0x04,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_stay_current_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 28), Box(0, 0, 35, 35),
      ic_round_36_communication_stay_current_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_stay_current_portrait 36x36, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_round_36_communication_stay_current_portrait_data[] PROGMEM = {
  0x20, 0x48, 0x09, 0x47, 0x03, 0x30, 0x9F, 0xFC, 0x81, 0x90, 0x3F, 0xFE, 0x04, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xA0, 0xB8, 0x09, 0x27, 0x0B, 0xA0, 0x07, 0xA0, 0x77,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A,
  0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x09, 0x27,
  0x0B, 0xA0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x70, 0x3F, 0xFE, 0x81, 0x40,
  0x9F, 0xFC, 0x09, 0x30, 0x48, 0x09, 0x47, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_stay_current_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_stay_current_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_stay_primary_landscape 36x36, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_round_36_communication_stay_primary_landscape_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x3F, 0xFF, 0xFC, 0x04, 0x07,
  0xD0, 0xB8, 0x0A, 0x07, 0x0B, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76,
  0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0,
  0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0,
  0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76,
  0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0,
  0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0xB8, 0x0A, 0x07, 0x0B,
  0xD0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x30, 0x48, 0x0B, 0x07, 0x04,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_stay_primary_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 28), Box(0, 0, 35, 35),
      ic_round_36_communication_stay_primary_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_stay_primary_portrait 36x36, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_round_36_communication_stay_primary_portrait_data[] PROGMEM = {
  0x20, 0x48, 0x09, 0x47, 0x03, 0x30, 0x9F, 0xFC, 0x81, 0x90, 0x3F, 0xFE, 0x04, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xA0, 0xB8, 0x09, 0x27, 0x0B, 0xA0, 0x07, 0xA0, 0x77,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A,
  0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x09, 0x27,
  0x0B, 0xA0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x70, 0x3F, 0xFE, 0x81, 0x40,
  0x9F, 0xFC, 0x09, 0x30, 0x48, 0x09, 0x47, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_stay_primary_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_round_36_communication_stay_primary_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_stop_screen_share 36x36, 4-bit Alpha,  RLE, 223 bytes.
static const unsigned char ic_round_36_communication_stop_screen_share_data[] PROGMEM = {
  0x28, 0x24, 0xEC, 0x17, 0x77, 0x74, 0x0A, 0xA0, 0xC0, 0x17, 0x77, 0x73, 0x04, 0xB0, 0xC0, 0x17,
  0x77, 0x73, 0x05, 0xB0, 0xC0, 0x13, 0x0B, 0xFF, 0xB0, 0xD0, 0x77, 0x08, 0xC0, 0xC0, 0x13, 0x0B,
  0xFF, 0xC0, 0x86, 0x0E, 0xD0, 0xC0, 0x13, 0x0B, 0xFF, 0xB0, 0xD6, 0xF0, 0xC0, 0x13, 0x0B, 0xFF,
  0xB6, 0xF9, 0x0C, 0x01, 0x30, 0xBF, 0xFA, 0x6F, 0xA0, 0xC0, 0x13, 0x82, 0xBF, 0xD9, 0xFD, 0x6F,
  0xB0, 0xC0, 0x13, 0x82, 0xB7, 0x05, 0xFC, 0x6F, 0xC0, 0xC0, 0x13, 0x04, 0x20, 0x4F, 0xB6, 0xFD,
  0x0C, 0x01, 0x60, 0x40, 0xEF, 0x96, 0xFE, 0x0C, 0x01, 0x60, 0x3F, 0x96, 0xFB, 0x0B, 0xB0, 0xC0,
  0x15, 0x01, 0x0E, 0xF6, 0xFA, 0x81, 0xA0, 0x5B, 0x0C, 0x01, 0x30, 0x10, 0xDF, 0x96, 0xF9, 0x0E,
  0x01, 0x20, 0x5B, 0x0C, 0x01, 0x30, 0xBF, 0x96, 0xF9, 0x82, 0x70, 0x2A, 0xD0, 0xC0, 0x13, 0x0B,
  0xF6, 0xF9, 0x01, 0x07, 0xF9, 0x0C, 0x01, 0x30, 0xBE, 0x6F, 0x0B, 0x09, 0xFB, 0x0C, 0x01, 0x30,
  0xBD, 0x6F, 0x0E, 0xFD, 0x0C, 0x01, 0x30, 0xBC, 0x6F, 0xFF, 0x0C, 0x01, 0x30, 0xBB, 0x60, 0xDF,
  0xFF, 0x0C, 0x01, 0x38, 0x1B, 0xFD, 0x60, 0x8F, 0xFF, 0x90, 0xC0, 0x13, 0x0B, 0x08, 0x70, 0x80,
  0xEF, 0xFF, 0x0C, 0x01, 0x70, 0x8F, 0xFF, 0xE0, 0xC0, 0x13, 0x82, 0xBF, 0x8E, 0xFF, 0xFF, 0x0C,
  0x01, 0x38, 0x1B, 0xE8, 0xFF, 0xFF, 0x90, 0xC0, 0x13, 0x05, 0x77, 0x76, 0x05, 0xB0, 0xC0, 0x17,
  0x77, 0x73, 0x05, 0xB0, 0x97, 0x77, 0x74, 0x05, 0xA0, 0x97, 0x77, 0x75, 0x03, 0x05, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_stop_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 35, 33), Box(0, 0, 35, 35),
      ic_round_36_communication_stop_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_swap_calls 36x36, 4-bit Alpha,  RLE, 209 bytes.
static const unsigned char ic_round_36_communication_swap_calls_data[] PROGMEM = {
  0x68, 0x52, 0x9D, 0xFD, 0x92, 0x72, 0x00, 0x67, 0x20, 0x6F, 0x05, 0x70, 0x7A, 0x07, 0x70, 0x5F,
  0xA0, 0x45, 0x07, 0xC0, 0x76, 0x0D, 0xA8, 0x3C, 0x31, 0x3C, 0xA0, 0xD4, 0x07, 0xE0, 0x74, 0x04,
  0xA0, 0xE0, 0x13, 0x01, 0x0D, 0xA0, 0x32, 0x07, 0xF9, 0x07, 0x30, 0x6A, 0x09, 0x50, 0x9A, 0x06,
  0x20, 0xCF, 0x90, 0xC3, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07,
  0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07,
  0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x73, 0x82, 0x57,
  0x7B, 0xA8, 0x2B, 0x77, 0x52, 0x07, 0xA0, 0x85, 0x08, 0xA0, 0x73, 0x0C, 0xF9, 0x0C, 0x20, 0x5A,
  0x0B, 0x50, 0xBA, 0x06, 0x30, 0x10, 0xDE, 0x0D, 0x01, 0x20, 0x1B, 0x05, 0x30, 0x5B, 0x01, 0x40,
  0x10, 0xDC, 0x0D, 0x01, 0x40, 0x9B, 0x81, 0xB9, 0xBB, 0x0A, 0x60, 0x10, 0xDA, 0x0D, 0x01, 0x60,
  0xCF, 0x0D, 0x01, 0x78, 0x21, 0xDD, 0x17, 0x10, 0x9D, 0x0A, 0x01, 0x77, 0x78, 0x31, 0x67, 0x62,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_swap_calls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 28), Box(0, 0, 35, 35),
      ic_round_36_communication_swap_calls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_textsms 36x36, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_36_communication_textsms_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x0B,
  0xA5, 0xF8, 0x2B, 0x77, 0xBA, 0x82, 0xB7, 0x7B, 0xA8, 0x2B, 0x77, 0xBF, 0xF0, 0x72, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xFF, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xF8,
  0x2B, 0x77, 0xBA, 0x82, 0xB7, 0x7B, 0xA8, 0x2B, 0x77, 0xB8, 0x0B, 0xE2, 0xF0, 0xDF, 0xFF, 0xF9,
  0x08, 0xFF, 0xFE, 0x0D, 0x08, 0x1D, 0x07, 0x77, 0x73, 0xC0, 0x77, 0x77, 0x4B, 0x07, 0x77, 0x75,
  0xA0, 0x77, 0x77, 0x69, 0x07, 0x77, 0x77, 0x07, 0x77, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_textsms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_communication_textsms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_unsubscribe 36x36, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_36_communication_unsubscribe_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x40, 0x9F, 0xFF, 0xB0, 0x92, 0x04, 0xFF, 0xFD, 0x81, 0x30, 0x7F,
  0xFF, 0xD8, 0x17, 0x07, 0xA8, 0x2E, 0x68, 0xEF, 0xF8, 0x2E, 0x86, 0xEA, 0x81, 0x70, 0x7A, 0x08,
  0x28, 0x11, 0x7E, 0xFB, 0x81, 0xE7, 0x12, 0x08, 0xA8, 0x17, 0x07, 0xA0, 0xC0, 0x13, 0x81, 0x17,
  0xEE, 0x81, 0xE7, 0x13, 0x01, 0x0C, 0xA8, 0x17, 0x07, 0xB0, 0xE0, 0x74, 0x81, 0x17, 0xEA, 0x81,
  0xE7, 0x14, 0x07, 0x0E, 0xB8, 0x17, 0x07, 0xD0, 0xE0, 0x74, 0x82, 0x17, 0x71, 0x38, 0x11, 0x7E,
  0xD8, 0x17, 0x07, 0xF0, 0xE0, 0x77, 0x81, 0x17, 0xEF, 0x81, 0x70, 0x7F, 0xA8, 0x1E, 0x71, 0x28,
  0x11, 0x7E, 0xFA, 0x81, 0x70, 0x7F, 0xC8, 0x2E, 0xBB, 0xEF, 0xC8, 0x17, 0x07, 0xFF, 0xFD, 0x81,
  0x70, 0x7F, 0xFD, 0x89, 0x0E, 0x96, 0x45, 0x7D, 0x70, 0x7F, 0xFC, 0x09, 0x01, 0x68, 0x11, 0x07,
  0xFF, 0xB0, 0x63, 0x82, 0x47, 0x62, 0x30, 0x7F, 0xFA, 0x09, 0x20, 0x50, 0xEC, 0x82, 0xA1, 0x07,
  0xFF, 0x98, 0x2E, 0x10, 0x5F, 0x81, 0xC0, 0x7F, 0xF9, 0x09, 0x20, 0xEF, 0x90, 0x70, 0x4F, 0xF9,
  0x81, 0x50, 0x5F, 0xA8, 0x1C, 0x09, 0xFF, 0x83, 0x40, 0x7F, 0xD5, 0x06, 0xA2, 0x04, 0x80, 0x91,
  0x78, 0x12, 0x06, 0xA8, 0x68, 0x77, 0x77, 0xBF, 0xE7, 0x74, 0x02, 0xFA, 0x0A, 0x77, 0x50, 0xAF,
  0x90, 0x37, 0x75, 0x01, 0x0C, 0xE0, 0x57, 0x77, 0x18, 0x47, 0xCF, 0xEA, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_unsubscribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_communication_unsubscribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_voicemail 36x36, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_36_communication_voicemail_data[] PROGMEM = {
  0x48, 0x61, 0x7C, 0xEF, 0xD9, 0x47, 0x58, 0x64, 0x9D, 0xFE, 0xC7, 0x17, 0x07, 0x0E, 0xF0, 0xC0,
  0x27, 0x10, 0x20, 0xCF, 0x0E, 0x07, 0x50, 0x9F, 0xB0, 0xE0, 0x36, 0x03, 0x0E, 0xFB, 0x09, 0x30,
  0x7B, 0x84, 0xC5, 0x10, 0x28, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB8, 0x48, 0x20, 0x15, 0xCB, 0x82,
  0x70, 0x1E, 0xA0, 0x96, 0x03, 0x0E, 0xA0, 0x84, 0x08, 0xA0, 0xE0, 0x36, 0x09, 0xA8, 0x1E, 0x17,
  0xA0, 0xC7, 0x10, 0x4A, 0x0E, 0x40, 0xEA, 0x04, 0x71, 0x0C, 0xA0, 0x70, 0xCA, 0x05, 0x72, 0x0C,
  0xA0, 0x42, 0x04, 0xA0, 0xC7, 0x20, 0x5A, 0x0C, 0x0E, 0xA0, 0x17, 0x20, 0x9A, 0x06, 0x20, 0x6A,
  0x09, 0x72, 0x01, 0xA0, 0xEB, 0x73, 0x08, 0xA0, 0x72, 0x07, 0xA0, 0x87, 0x3B, 0x0D, 0xA0, 0x27,
  0x20, 0xAA, 0x05, 0x20, 0x5A, 0x0A, 0x72, 0x02, 0xA0, 0xD0, 0xAA, 0x08, 0x71, 0x01, 0x0E, 0xA0,
  0x22, 0x02, 0xA0, 0xE0, 0x17, 0x10, 0x8A, 0x0A, 0x04, 0xA0, 0xE0, 0x37, 0x0A, 0xA0, 0xC4, 0x0C,
  0xA0, 0xA7, 0x03, 0x0E, 0xA8, 0x14, 0x0C, 0xA0, 0xE0, 0x44, 0x01, 0x0A, 0xB0, 0x44, 0x04, 0xB0,
  0xA0, 0x14, 0x04, 0x0E, 0xA0, 0xC2, 0x02, 0x0E, 0xB8, 0x3C, 0x87, 0xAE, 0xB0, 0xD8, 0x02, 0x70,
  0xDB, 0x83, 0xEA, 0x78, 0xCB, 0x0E, 0x02, 0x30, 0x30, 0xDF, 0xFF, 0xF0, 0xD0, 0x35, 0x81, 0x18,
  0xEF, 0xFF, 0xB8, 0x1E, 0x81, 0x72, 0x04, 0x06, 0x80, 0xA0, 0x70, 0x60, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_voicemail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 9, 35, 25), Box(0, 0, 35, 35),
      ic_round_36_communication_voicemail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_vpn_key_off 36x36, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_round_36_communication_vpn_key_off_data[] PROGMEM = {
  0x30, 0x17, 0x77, 0x73, 0x82, 0x1D, 0xF7, 0x77, 0x77, 0x20, 0x3B, 0x07, 0x77, 0x77, 0x20, 0xAB,
  0x07, 0x77, 0x77, 0x20, 0xAB, 0x07, 0x77, 0x77, 0x20, 0xBB, 0x07, 0x77, 0x77, 0x10, 0x7C, 0x07,
  0x77, 0x76, 0x09, 0xE0, 0x77, 0x77, 0x40, 0x8F, 0x90, 0x77, 0x77, 0x20, 0x3F, 0xB0, 0x77, 0x77,
  0x10, 0xBF, 0xC0, 0x77, 0x76, 0x01, 0xE8, 0x2C, 0x30, 0xBB, 0x07, 0x30, 0x4F, 0xD8, 0x2B, 0x30,
  0x4D, 0x0D, 0x01, 0x30, 0xBB, 0x07, 0x30, 0x4F, 0xD8, 0x1E, 0x16, 0xD0, 0x95, 0x0B, 0xB0, 0x73,
  0x04, 0xFD, 0x00, 0x6D, 0x09, 0x50, 0x9C, 0x07, 0x30, 0x4F, 0xC0, 0x60, 0x5D, 0x0D, 0x01, 0x30,
  0x10, 0xDD, 0x07, 0x30, 0x4F, 0xA8, 0x1E, 0x11, 0xE8, 0x3C, 0x30, 0x3C, 0xF0, 0x73, 0x04, 0xF0,
  0xB0, 0x32, 0x0B, 0xFF, 0xC0, 0x73, 0x04, 0xD0, 0x74, 0x03, 0xFF, 0x90, 0xCB, 0x07, 0x30, 0x4C,
  0x07, 0x50, 0x8F, 0xE8, 0x18, 0x0B, 0xB0, 0x73, 0x04, 0xB0, 0x76, 0x0A, 0xFC, 0x09, 0x30, 0xBB,
  0x07, 0x30, 0x4A, 0x06, 0x70, 0x60, 0xEF, 0x0E, 0x06, 0x50, 0xBB, 0x07, 0x38, 0x14, 0xD1, 0x71,
  0x86, 0x16, 0xBD, 0xFD, 0xB6, 0x71, 0x0B, 0xB0, 0x77, 0x77, 0x72, 0x0B, 0xB0, 0x77, 0x77, 0x72,
  0x0B, 0xB0, 0x77, 0x77, 0x72, 0x0B, 0xB0, 0x77, 0x77, 0x72, 0x0B, 0xB0, 0x77, 0x77, 0x72, 0x0B,
  0xB0, 0x17, 0x77, 0x72, 0x81, 0xBF, 0xD7, 0x77, 0x74, 0x03, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_vpn_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 33), Box(0, 0, 35, 35),
      ic_round_36_communication_vpn_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_vpn_key 36x36, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_36_communication_vpn_key_data[] PROGMEM = {
  0x58, 0x71, 0x7B, 0xDF, 0xDB, 0x71, 0x77, 0x73, 0x07, 0xF9, 0x0E, 0x06, 0x77, 0x71, 0x0A, 0xFC,
  0x0A, 0x77, 0x60, 0x9F, 0xE0, 0x97, 0x74, 0x04, 0xFF, 0x90, 0x47, 0x73, 0x0C, 0xFF, 0x90, 0xB7,
  0x72, 0x02, 0xE8, 0x3C, 0x30, 0x3C, 0xFF, 0xD8, 0x2B, 0x30, 0x5D, 0x0D, 0x01, 0x30, 0x10, 0xDF,
  0xFD, 0x81, 0xE1, 0x6D, 0x09, 0x50, 0x9F, 0xFE, 0x06, 0x07, 0xD0, 0x95, 0x09, 0xFF, 0xE0, 0x60,
  0x4D, 0x0D, 0x01, 0x30, 0x10, 0xDF, 0xFD, 0x81, 0xE1, 0x1E, 0x83, 0xC3, 0x03, 0xCF, 0xFD, 0x0B,
  0x03, 0x20, 0xBF, 0xF9, 0x0B, 0x60, 0x7D, 0x07, 0x40, 0x3F, 0xF9, 0x04, 0x60, 0x7D, 0x07, 0x50,
  0x8F, 0xE0, 0x97, 0x07, 0xD0, 0x76, 0x09, 0xFC, 0x0A, 0x71, 0x06, 0xD0, 0x67, 0x06, 0x0E, 0xF0,
  0xE0, 0x77, 0x20, 0x10, 0xEB, 0x0E, 0x01, 0x71, 0x87, 0x16, 0xBD, 0xFE, 0xB7, 0x17, 0x48, 0x33,
  0xBE, 0xB3, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_vpn_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 9, 34, 26), Box(0, 0, 35, 35),
      ic_round_36_communication_vpn_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_communication_wifi_calling 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_round_36_communication_wifi_calling_data[] PROGMEM = {
  0x28, 0x43, 0x67, 0x75, 0x17, 0x28, 0x51, 0x46, 0x77, 0x52, 0x60, 0x9D, 0x0E, 0x04, 0x60, 0x50,
  0xBF, 0x81, 0xE8, 0x22, 0x04, 0xF0, 0xD4, 0x04, 0x0D, 0xFD, 0x81, 0x91, 0x7F, 0x90, 0x12, 0x04,
  0xFF, 0x90, 0xB0, 0x6F, 0x90, 0x33, 0x0A, 0xFE, 0x81, 0xE3, 0x4F, 0x90, 0x54, 0x0C, 0xFD, 0x81,
  0x50, 0x2F, 0x90, 0x74, 0x02, 0x0E, 0xFB, 0x09, 0x30, 0xEF, 0x07, 0x50, 0x5F, 0xA0, 0xC4, 0x0B,
  0xF0, 0x46, 0x08, 0xF0, 0xE0, 0x14, 0x06, 0xE0, 0x97, 0x10, 0xBE, 0x04, 0x50, 0x1D, 0x09, 0x72,
  0x01, 0x0D, 0xC0, 0x77, 0x0B, 0xB0, 0x97, 0x40, 0x3B, 0x0A, 0x71, 0x04, 0xB0, 0x17, 0x58, 0x16,
  0xFD, 0x73, 0x0C, 0xA0, 0xA7, 0x60, 0x90, 0x27, 0x30, 0x4B, 0x04, 0x77, 0x74, 0x0A, 0xA0, 0xD0,
  0x17, 0x77, 0x30, 0x10, 0xEA, 0x0C, 0x77, 0x74, 0x04, 0xB0, 0xA7, 0x77, 0x40, 0x7B, 0x0A, 0x71,
  0x84, 0x37, 0x75, 0x31, 0x74, 0x09, 0xB0, 0xC0, 0x15, 0x09, 0xE0, 0xD0, 0x37, 0x30, 0x9B, 0x0D,
  0x04, 0x30, 0x9F, 0x90, 0xE0, 0x17, 0x30, 0x7C, 0x81, 0xA1, 0x9F, 0xB0, 0x57, 0x40, 0x40, 0xEF,
  0xF9, 0x07, 0x75, 0x01, 0x0A, 0xFF, 0x07, 0x77, 0x04, 0x0C, 0xFD, 0x06, 0x77, 0x20, 0x40, 0xBF,
  0xB0, 0x37, 0x74, 0x82, 0x16, 0xBE, 0xD0, 0x97, 0x77, 0x28, 0x32, 0x46, 0x74, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_communication_wifi_calling() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 32, 31), Box(0, 0, 35, 35),
      ic_round_36_communication_wifi_calling_data, Alpha4(color::Black));
  return value;
}
