#include "editor.h"

using namespace roo_display;

// Image file ic_round_24_editor_add_chart 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_24_editor_add_chart_data[] PROGMEM = {
  0x04, 0x0D, 0xF9, 0x0B, 0x30, 0x0B, 0x20, 0xDF, 0xA0, 0xB3, 0xA2, 0xA7, 0x30, 0xBC, 0x0B, 0xA7,
  0x30, 0xBC, 0x0B, 0xA6, 0x00, 0xB4, 0xA2, 0xA6, 0xA4, 0x00, 0xB2, 0xA6, 0xA7, 0x1A, 0x20, 0x0B,
  0x2A, 0x60, 0x0B, 0xA2, 0xA2, 0xA6, 0xC2, 0xA2, 0xA6, 0xC2, 0xA2, 0xA2, 0x00, 0xB2, 0xC2, 0xA2,
  0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0x00, 0xB2, 0x00, 0xB2, 0x00, 0xB2, 0xC7, 0x7C, 0x77,
  0xA0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_add_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_add_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_add_comment 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_24_editor_add_comment_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDF, 0xFF, 0xF9, 0x00, 0x3F, 0xFC, 0x2F, 0xFC,
  0x2F, 0xFC, 0x2F, 0xF0, 0x37, 0x10, 0x3F, 0xB0, 0x37, 0x10, 0x3F, 0xF2, 0xFF, 0xC2, 0xFF, 0xC2,
  0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0x90, 0xDF, 0xFD, 0x04, 0x0D, 0xFF, 0xC7, 0x72, 0x07, 0xB7, 0x73,
  0x07, 0xA7, 0x74, 0x07, 0x97, 0x75, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_add_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_add_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_align_horizontal_center 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_editor_align_horizontal_center_data[] PROGMEM = {
  0x71, 0x00, 0xB7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x10, 0x8F, 0xFA, 0x08, 0x0E,
  0xFF, 0xA0, 0xE0, 0x8F, 0xFA, 0x08, 0x71, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x40, 0x8F,
  0xB0, 0x86, 0x0E, 0xFB, 0x0E, 0x60, 0x8F, 0xB0, 0x87, 0x4A, 0x77, 0x2A, 0x77, 0x2A, 0x77, 0x2A,
  0x77, 0x20, 0x0B, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_align_horizontal_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_align_horizontal_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_align_horizontal_left 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_editor_align_horizontal_left_data[] PROGMEM = {
  0x00, 0xB7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA2, 0x08, 0xFF, 0x08, 0xA2,
  0x0E, 0xFF, 0x0E, 0xA2, 0x08, 0xFF, 0x08, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA2,
  0x08, 0xF9, 0x08, 0x6A, 0x20, 0xEF, 0x90, 0xE6, 0xA2, 0x08, 0xF9, 0x08, 0x6A, 0x77, 0x4A, 0x77,
  0x4A, 0x77, 0x4A, 0x77, 0x40, 0x0B, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_align_horizontal_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_align_horizontal_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_align_horizontal_right 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_editor_align_horizontal_right_data[] PROGMEM = {
  0x77, 0x40, 0x0B, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x08, 0xFF, 0x08, 0x2A, 0x0E,
  0xFF, 0x0E, 0x2A, 0x08, 0xFF, 0x08, 0x2A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x60,
  0x8F, 0x90, 0x82, 0xA6, 0x0E, 0xF9, 0x0E, 0x2A, 0x60, 0x8F, 0x90, 0x82, 0xA7, 0x74, 0xA7, 0x74,
  0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0x00, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_align_horizontal_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_align_horizontal_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_align_vertical_bottom 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_24_editor_align_vertical_bottom_data[] PROGMEM = {
  0x58, 0x18, 0xE8, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x48,
  0x18, 0xE8, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B,
  0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0x81, 0x8E, 0x84, 0x81, 0x8E, 0x88, 0x0D, 0x10, 0x0B,
  0xFF, 0xC0, 0x0B, 0xFF, 0xC0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_align_vertical_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_align_vertical_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_align_vertical_center 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_editor_align_vertical_center_data[] PROGMEM = {
  0x58, 0x18, 0xE8, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x48, 0x18, 0xE8, 0x73, 0xB4, 0xB7, 0x3B,
  0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x50, 0xDF, 0xFC, 0x0B, 0x0D, 0xFF, 0xC0, 0xB5, 0xB4, 0xB7,
  0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0x81, 0x8E, 0x87, 0x3B, 0x77, 0x3B, 0x77,
  0x38, 0x18, 0xE8, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_align_vertical_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_align_vertical_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_align_vertical_top 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_24_editor_align_vertical_top_data[] PROGMEM = {
  0x0B, 0xFF, 0xC0, 0x0B, 0xFF, 0xC0, 0xB8, 0x0D, 0x10, 0x81, 0x8E, 0x84, 0x81, 0x8E, 0x87, 0x3B,
  0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B,
  0x73, 0xB4, 0xB7, 0x3B, 0x48, 0x18, 0xE8, 0x73, 0xB7, 0x73, 0xB7, 0x73, 0xB7, 0x73, 0xB7, 0x73,
  0xB7, 0x73, 0x81, 0x8E, 0x87, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_align_vertical_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_align_vertical_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_area_chart 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_24_editor_area_chart_data[] PROGMEM = {
  0x71, 0x03, 0x06, 0x77, 0x18, 0x32, 0xEF, 0xB1, 0x76, 0x0B, 0xB0, 0xD0, 0x37, 0x40, 0x7E, 0x06,
  0x40, 0x84, 0x03, 0xFC, 0x82, 0xBF, 0xC2, 0x20, 0xDF, 0xF8, 0x1E, 0x59, 0xB8, 0x19, 0x9E, 0xFF,
  0x04, 0x20, 0x20, 0xDE, 0x01, 0x0A, 0xC0, 0x85, 0x0A, 0xD2, 0x06, 0xA0, 0xC2, 0x81, 0xAE, 0x52,
  0x07, 0xC0, 0x72, 0x83, 0x3D, 0x20, 0x7B, 0x08, 0x20, 0x30, 0xEB, 0x0B, 0x01, 0x30, 0x3D, 0x83,
  0xB1, 0x01, 0xCB, 0x0D, 0x03, 0x20, 0xDE, 0x0D, 0x03, 0x20, 0x9C, 0x06, 0x09, 0xFA, 0x06, 0x2F,
  0xFA, 0x0A, 0x1F, 0xFB, 0x0D, 0x0B, 0xFF, 0xA0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_area_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_area_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_attach_file 24x24, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_round_24_editor_attach_file_data[] PROGMEM = {
  0x18, 0x41, 0x9D, 0xE9, 0x14, 0x86, 0x1E, 0xE9, 0x9E, 0xD1, 0x38, 0x19, 0xE2, 0x28, 0x12, 0xE9,
  0x30, 0xD0, 0x94, 0x09, 0x0D, 0x39, 0x07, 0x40, 0x79, 0x39, 0x8A, 0x27, 0x0C, 0x50, 0x7F, 0x05,
  0xCF, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07,
  0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70,
  0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A,
  0x87, 0x70, 0xE8, 0x08, 0xF0, 0x7A, 0x8A, 0x57, 0x0A, 0xE8, 0xEB, 0x07, 0xFE, 0x80, 0x1B, 0xEB,
  0x10, 0x8F, 0xCB, 0x78, 0x3B, 0xD8, 0xE2, 0x58, 0x52, 0xF9, 0x1E, 0xC2, 0x38, 0x94, 0x2D, 0xE1,
  0x03, 0xEF, 0xA8, 0xBE, 0xE4, 0x38, 0x51, 0x9D, 0xFD, 0x92, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_attach_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 17, 22), Box(0, 0, 23, 23),
      ic_round_24_editor_attach_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_attach_money 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_24_editor_attach_money_data[] PROGMEM = {
  0x48, 0x18, 0xE8, 0x71, 0xB6, 0x03, 0x0A, 0xB0, 0x90, 0x23, 0x07, 0xB0, 0xEA, 0x82, 0xE3, 0x03,
  0xA0, 0x72, 0x86, 0x19, 0xFC, 0x06, 0xFD, 0x48, 0x61, 0xDC, 0x05, 0xFE, 0x27, 0x84, 0x1D, 0xFE,
  0x83, 0x60, 0x20, 0xCB, 0x81, 0xD8, 0x15, 0x81, 0x5A, 0xEA, 0x0E, 0x04, 0x78, 0x35, 0xDF, 0xE1,
  0x78, 0x51, 0xEF, 0x64, 0xE7, 0x58, 0x2D, 0xF6, 0x4A, 0x06, 0x30, 0x7A, 0x81, 0x30, 0x8B, 0x0D,
  0xB0, 0x93, 0x04, 0x0A, 0xB0, 0xA0, 0x46, 0xB7, 0x18, 0x18, 0xE8, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_attach_money() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 16, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_attach_money_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_auto_graph 24x24, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_round_24_editor_auto_graph_data[] PROGMEM = {
  0x70, 0x27, 0x76, 0x81, 0x2F, 0x27, 0x74, 0x83, 0x2B, 0xFB, 0x27, 0x72, 0x02, 0xD0, 0x27, 0x72,
  0x83, 0x2B, 0xFB, 0x23, 0x00, 0x17, 0x68, 0x12, 0xF2, 0x40, 0x0A, 0x72, 0x00, 0x13, 0x02, 0x30,
  0x10, 0xAA, 0x0A, 0x01, 0x28, 0x14, 0xE6, 0x20, 0x0A, 0x70, 0x10, 0xAA, 0x87, 0xA1, 0x03, 0xEF,
  0x61, 0xAA, 0x0A, 0x01, 0x70, 0x0A, 0x28, 0x52, 0xEF, 0x90, 0x1A, 0xA0, 0xA0, 0x17, 0x85, 0x11,
  0x01, 0xDF, 0xA4, 0x00, 0xA4, 0x81, 0x7F, 0x75, 0x81, 0xCF, 0xC5, 0x00, 0x13, 0x07, 0xB0, 0x73,
  0x82, 0xBF, 0xD1, 0x72, 0x07, 0xA0, 0xBA, 0x84, 0x70, 0x9F, 0xE2, 0x72, 0x07, 0xA8, 0x17, 0x07,
  0xA8, 0x2B, 0xFE, 0x37, 0x20, 0x7A, 0x07, 0x30, 0x7B, 0x04, 0x72, 0x07, 0xA0, 0x75, 0x81, 0x7F,
  0x57, 0x20, 0x5A, 0x07, 0x77, 0x48, 0x15, 0xF7, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_auto_graph() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_auto_graph_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_bar_chart 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_24_editor_bar_chart_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x50, 0xDA, 0x0D, 0x75, 0xC7, 0x5C, 0x75, 0xC6, 0x82, 0x4D, 0xD4, 0x2C,
  0x60, 0xDA, 0x0D, 0x2C, 0x6C, 0x2C, 0x6C, 0x2C, 0x6C, 0x2C, 0x28, 0x24, 0xDD, 0x4C, 0x2C, 0x20,
  0xDA, 0x0D, 0xC2, 0xC2, 0xF9, 0x2C, 0x2F, 0x92, 0xC2, 0xC0, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20,
  0xDA, 0x83, 0xD4, 0xDD, 0x42, 0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_bar_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_bar_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_all 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_editor_border_all_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0xA0, 0x35, 0xA5, 0x03, 0xC6, 0xA6, 0xC6, 0xA6,
  0xC6, 0xA6, 0xC6, 0xA6, 0xC5, 0x03, 0xA0, 0x35, 0x80, 0xC4, 0xF5, 0x03, 0xA0, 0x35, 0xC6, 0xA6,
  0xC6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0xC0, 0x35, 0xA5, 0x03, 0xA0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF,
  0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_bottom 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_editor_border_bottom_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8,
  0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6,
  0xA6, 0xA8, 0x0C, 0x00, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_clear 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_24_editor_border_clear_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8,
  0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6,
  0xA6, 0xA8, 0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_color 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_24_editor_border_color_data[] PROGMEM = {
  0x76, 0x81, 0x4D, 0x87, 0x72, 0x04, 0xB0, 0x87, 0x71, 0x07, 0xC0, 0x87, 0x58, 0x24, 0x50, 0x7B,
  0x0D, 0x74, 0x04, 0xA8, 0x15, 0x07, 0xA0, 0x47, 0x30, 0x4C, 0x82, 0x50, 0x74, 0x73, 0x04, 0xE0,
  0x57, 0x40, 0x4F, 0x04, 0x73, 0x04, 0xF0, 0x47, 0x30, 0x4F, 0x04, 0x73, 0x04, 0xF0, 0x47, 0x30,
  0x4F, 0x04, 0x74, 0x0E, 0xE0, 0x47, 0x5E, 0x04, 0x76, 0xD0, 0x47, 0x70, 0xBA, 0x0E, 0x04, 0x80,
  0xE1, 0x00, 0x40, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xFC, 0x00, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_color() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 23), Box(0, 0, 23, 23),
      ic_round_24_editor_border_color_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_horizontal 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_editor_border_horizontal_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8,
  0x0C, 0x00, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8,
  0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_horizontal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_horizontal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_inner 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_24_editor_border_inner_data[] PROGMEM = {
  0xA2, 0xA2, 0x00, 0xB2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA6, 0xA6,
  0xC6, 0xA6, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB7, 0x1A, 0x77,
  0x2A, 0x71, 0xA6, 0xA6, 0xC6, 0xA6, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2,
  0xA2, 0x00, 0xB2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_inner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_inner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_left 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_editor_border_left_data[] PROGMEM = {
  0x00, 0xB2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC7, 0x72, 0xA7, 0x72, 0xA6, 0xA6, 0xC6,
  0xA6, 0xC7, 0x72, 0xA7, 0x72, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC7, 0x72, 0xA7,
  0x72, 0xA6, 0xA6, 0xC6, 0xA6, 0xC7, 0x72, 0xA7, 0x72, 0xA2, 0xA2, 0xA2, 0xA2, 0xA0, 0x0B, 0x2A,
  0x2A, 0x2A, 0x2A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_outer 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_24_editor_border_outer_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0xA0, 0x37, 0x50, 0x3C, 0x77, 0xC6, 0xA6, 0xC6,
  0xA6, 0xC7, 0x7C, 0x77, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC7, 0x7C, 0x77, 0xC6,
  0xA6, 0xC6, 0xA6, 0xC7, 0x7C, 0x03, 0x75, 0x03, 0xA0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_outer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_outer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_right 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_editor_border_right_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0x00, 0xBA, 0x2A, 0x2A, 0x2A, 0x2A, 0x77, 0x2A, 0x77, 0x2C, 0x6A, 0x6C,
  0x6A, 0x6A, 0x77, 0x2A, 0x77, 0x2C, 0x2A, 0x2A, 0x2A, 0x2C, 0x2A, 0x2A, 0x2A, 0x2A, 0x77, 0x2A,
  0x77, 0x2C, 0x6A, 0x6C, 0x6A, 0x6A, 0x77, 0x2A, 0x77, 0x2C, 0x2A, 0x2A, 0x2A, 0x2C, 0x2A, 0x2A,
  0x2A, 0x20, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_style 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_24_editor_border_style_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x90, 0xB0, 0xDF, 0xFA, 0x0B, 0xA0, 0x37, 0x71, 0xA7, 0x72, 0xA7, 0x7C, 0x77,
  0xC7, 0x72, 0xA7, 0x72, 0xA7, 0x7C, 0x77, 0xC7, 0x72, 0xA7, 0x72, 0xA7, 0x7C, 0x77, 0xC7, 0x72,
  0xA7, 0x72, 0xA2, 0xA2, 0xA2, 0xA2, 0xA0, 0x0B, 0x2A, 0x2A, 0x2A, 0x2A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_style() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_style_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_top 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_editor_border_top_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8, 0x0C, 0x00,
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8,
  0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_border_vertical 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_24_editor_border_vertical_data[] PROGMEM = {
  0xA2, 0xA2, 0x00, 0xB2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA6, 0xA6,
  0xC6, 0xA6, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA7,
  0x1A, 0x77, 0x2A, 0x71, 0xA6, 0xA6, 0xC6, 0xA6, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA2, 0xA2, 0xA2,
  0xA2, 0xC2, 0xA2, 0x00, 0xB2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_border_vertical() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_border_vertical_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_bubble_chart 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_24_editor_bubble_chart_data[] PROGMEM = {
  0x71, 0x84, 0x19, 0xDE, 0xB5, 0x72, 0x03, 0x0E, 0xD0, 0x97, 0x10, 0xDF, 0x05, 0x60, 0x5F, 0x90,
  0xB6, 0x08, 0xF9, 0x0E, 0x60, 0x7F, 0x90, 0xD6, 0x03, 0xF9, 0x84, 0x90, 0x3A, 0xB7, 0x20, 0xAE,
  0x81, 0xE1, 0x4C, 0x82, 0xA0, 0x1A, 0xC8, 0x2D, 0x30, 0xCD, 0x03, 0x28, 0x23, 0x78, 0x53, 0x0E,
  0xD0, 0x57, 0x20, 0xBD, 0x02, 0x72, 0x02, 0x0E, 0xB0, 0x83, 0x82, 0x6E, 0xC2, 0x48, 0x21, 0x78,
  0x33, 0x01, 0xB0, 0xA7, 0x40, 0x1B, 0x0A, 0x75, 0x82, 0x6E, 0xC2, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_bubble_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_bubble_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_candlestick_chart 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_24_editor_candlestick_chart_data[] PROGMEM = {
  0x20, 0x0B, 0x60, 0x0B, 0x4A, 0x6A, 0x20, 0xBC, 0x0B, 0x4A, 0x2E, 0x4A, 0x2E, 0x20, 0xBC, 0x0B,
  0xE2, 0xFD, 0x2F, 0xD2, 0xFD, 0x2F, 0xD2, 0xFD, 0x20, 0xBC, 0x0B, 0xE4, 0xA2, 0xE4, 0xA2, 0x0B,
  0xC0, 0xB4, 0xA4, 0xA6, 0xA4, 0x00, 0xB6, 0x00, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_candlestick_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 18, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_candlestick_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_checklist 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_24_editor_checklist_data[] PROGMEM = {
  0x70, 0x80, 0x37, 0x73, 0x81, 0xBF, 0xA7, 0x40, 0x10, 0x63, 0x82, 0xBF, 0xD2, 0x74, 0x86, 0x7F,
  0xC1, 0xBF, 0xD2, 0x30, 0xBF, 0x81, 0xB1, 0xDB, 0x0D, 0x02, 0x40, 0xBF, 0x85, 0xB0, 0x1D, 0xFD,
  0x27, 0x72, 0x81, 0x17, 0x18, 0x0C, 0x60, 0x08, 0x03, 0x77, 0x38, 0x1B, 0xFA, 0x74, 0x01, 0x06,
  0x38, 0x2B, 0xFD, 0x27, 0x48, 0x67, 0xFC, 0x1B, 0xFD, 0x23, 0x0B, 0xF8, 0x1B, 0x1D, 0xB0, 0xD0,
  0x24, 0x0B, 0xF8, 0x5B, 0x01, 0xDF, 0xD2, 0x77, 0x28, 0x11, 0x72, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_checklist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_checklist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_checklist_rtl 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_24_editor_checklist_rtl_data[] PROGMEM = {
  0x77, 0x38, 0x11, 0x82, 0x77, 0x28, 0x21, 0xDF, 0x77, 0x40, 0x20, 0x62, 0x84, 0x1D, 0xFC, 0x0B,
  0xF0, 0xB2, 0x85, 0xAF, 0xA2, 0xDF, 0xC2, 0x0B, 0xF0, 0xB2, 0x03, 0x0E, 0xB0, 0xC7, 0x71, 0x82,
  0x3E, 0xFC, 0x77, 0x30, 0x20, 0x78, 0x0C, 0x60, 0x81, 0x18, 0x27, 0x72, 0x82, 0x1D, 0xF7, 0x74,
  0x02, 0x06, 0x28, 0x41, 0xDF, 0xC0, 0xBF, 0x0B, 0x28, 0x5A, 0xFA, 0x2D, 0xFC, 0x20, 0xBF, 0x0B,
  0x20, 0x30, 0xEB, 0x0C, 0x77, 0x18, 0x23, 0xEF, 0xC7, 0x73, 0x02, 0x07, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_checklist_rtl() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_checklist_rtl_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_data_array 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_24_editor_data_array_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xB6, 0x0B, 0xA8, 0x1D, 0x4D, 0xB0, 0xB6, 0x0B, 0xB0, 0xDA, 0x75, 0xC7, 0x5C,
  0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5A, 0x0D,
  0xB0, 0xB6, 0x0B, 0xB8, 0x1D, 0x4D, 0xA0, 0xB6, 0x0B, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_data_array() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_data_array_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_data_object 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_24_editor_data_object_data[] PROGMEM = {
  0x30, 0x80, 0xDA, 0x0B, 0x40, 0xBA, 0x0D, 0x08, 0x50, 0x8C, 0x0B, 0x40, 0xBC, 0x08, 0x48, 0x1D,
  0xF3, 0x73, 0x81, 0x3F, 0xD4, 0xA7, 0x5A, 0x4A, 0x75, 0xA3, 0x81, 0x3F, 0xE7, 0x58, 0x3E, 0xF3,
  0x0B, 0xA0, 0x87, 0x50, 0x8A, 0x0B, 0xA0, 0x87, 0x70, 0x8C, 0x08, 0x77, 0x08, 0xA0, 0xBA, 0x08,
  0x75, 0x08, 0xA8, 0x3B, 0x03, 0xFE, 0x75, 0x81, 0xEF, 0x33, 0xA7, 0x5A, 0x4A, 0x75, 0xA4, 0x81,
  0xDF, 0x37, 0x38, 0x13, 0xFD, 0x40, 0x8C, 0x0B, 0x40, 0xBC, 0x08, 0x50, 0x80, 0xDA, 0x0B, 0x40,
  0xBA, 0x0D, 0x08, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_data_object() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_data_object_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_drag_handle 24x24, 4-bit Alpha,  RLE, 14 bytes.
static const unsigned char ic_round_24_editor_drag_handle_data[] PROGMEM = {
  0x0B, 0xFF, 0x00, 0xBF, 0xF0, 0xB7, 0x77, 0x74, 0x0B, 0xFF, 0x00, 0xBF, 0xF0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_drag_handle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 19, 14), Box(0, 0, 23, 23),
      ic_round_24_editor_drag_handle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_draw 24x24, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_round_24_editor_draw_data[] PROGMEM = {
  0x18, 0x44, 0xBE, 0xEB, 0x47, 0x40, 0x5E, 0x06, 0x50, 0x50, 0x63, 0x81, 0x5D, 0x62, 0x81, 0x6F,
  0xD4, 0x0A, 0xA0, 0xC0, 0x16, 0x81, 0x6F, 0xD3, 0x01, 0x0D, 0xB0, 0xC4, 0x05, 0x0C, 0xA0, 0x62,
  0x82, 0x20, 0x2D, 0xB8, 0x26, 0x04, 0xDA, 0x0D, 0x05, 0x28, 0x4B, 0xE3, 0x02, 0xDA, 0x00, 0x5A,
  0x0D, 0x06, 0x30, 0xBA, 0x89, 0x0E, 0x30, 0x2D, 0xB0, 0xDF, 0x74, 0x0B, 0xC8, 0x2E, 0x30, 0x12,
  0x81, 0xEF, 0x73, 0x0B, 0xE0, 0xE0, 0x23, 0x81, 0x6F, 0x62, 0x0B, 0xF0, 0xB5, 0x02, 0x20, 0xBF,
  0x0B, 0x71, 0x0B, 0xF0, 0xB7, 0x10, 0xBF, 0x0B, 0x28, 0x16, 0xE2, 0x30, 0xAF, 0x0B, 0x38, 0x1B,
  0xFC, 0x3F, 0x0B, 0x48, 0x11, 0xFE, 0x3E, 0x0B, 0x48, 0x23, 0xBF, 0xB3, 0xD0, 0xB3, 0x0B, 0xB0,
  0xE0, 0x23, 0x0E, 0xB0, 0xA4, 0x83, 0xBE, 0xC7, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_draw() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_draw_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_edit_note 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_24_editor_edit_note_data[] PROGMEM = {
  0x0B, 0xFA, 0x0B, 0x70, 0xBF, 0xA0, 0xB8, 0x0C, 0x70, 0x0B, 0xFA, 0x0B, 0x70, 0xBF, 0xA0, 0xB7,
  0x77, 0x18, 0x19, 0xF7, 0x77, 0x02, 0x05, 0xA0, 0xBD, 0x0B, 0x68, 0x49, 0xE4, 0x59, 0xBD, 0x0B,
  0x50, 0x9A, 0x0E, 0x02, 0x75, 0x09, 0xB0, 0x97, 0x50, 0x9B, 0x09, 0x75, 0x09, 0xB0, 0x97, 0x6B,
  0x09, 0x77, 0x81, 0xEF, 0x96,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_edit_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_edit_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_align_center 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_24_editor_format_align_center_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x40, 0x0B, 0xF9, 0x0B, 0x71, 0x0B, 0xF9, 0x0B,
  0x80, 0xC4, 0x00, 0xBF, 0xFA, 0x00, 0xBF, 0xFA, 0x0B, 0x80, 0xC4, 0x00, 0xBF, 0x90, 0xB7, 0x10,
  0xBF, 0x90, 0xB8, 0x0C, 0x40, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_align_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_align_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_align_justify 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_editor_format_align_justify_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x00, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8,
  0x0C, 0x00, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x00, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF,
  0xA0, 0xB8, 0x0C, 0x00, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_align_justify() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_align_justify_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_align_left 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_editor_format_align_left_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x00, 0x0B, 0xFB, 0x0B, 0x60, 0xBF, 0xB0, 0xB8,
  0x0C, 0x60, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x00, 0x0B, 0xFB, 0x0B, 0x60, 0xBF,
  0xB0, 0xB8, 0x0C, 0x60, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_align_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_align_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_align_right 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_editor_format_align_right_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x60, 0x0B, 0xFB, 0x0B, 0x60, 0xBF, 0xB0, 0xB8,
  0x0C, 0x00, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0C, 0x60, 0x0B, 0xFB, 0x0B, 0x60, 0xBF,
  0xB0, 0xB8, 0x0C, 0x00, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_align_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_align_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_bold 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_24_editor_format_bold_data[] PROGMEM = {
  0x0B, 0xD8, 0x1E, 0xB3, 0x2F, 0xA0, 0x51, 0xB0, 0xF7, 0x09, 0xA0, 0xE1, 0xB4, 0x09, 0xA0, 0x2B,
  0x40, 0x9A, 0x02, 0xB0, 0xF7, 0x09, 0xA0, 0xB1, 0xF9, 0x0D, 0x01, 0x1F, 0xA0, 0x81, 0xB0, 0xF7,
  0x08, 0x0D, 0xA0, 0x4B, 0x40, 0x2A, 0x0A, 0xB4, 0x02, 0xA0, 0xAB, 0x0F, 0x70, 0x80, 0xDA, 0x06,
  0xFA, 0x81, 0xC0, 0xBE, 0x0D, 0x08, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_bold() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 17, 17), Box(0, 0, 23, 23),
      ic_round_24_editor_format_bold_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_clear 24x24, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_24_editor_format_clear_data[] PROGMEM = {
  0x84, 0x29, 0x20, 0x2E, 0xFC, 0x86, 0x87, 0xFD, 0x20, 0x2E, 0xFB, 0x87, 0xE0, 0xBF, 0xD2, 0x02,
  0xEF, 0xA0, 0x82, 0x82, 0xBF, 0xD2, 0x38, 0x1E, 0xFE, 0x72, 0x87, 0xBF, 0xD2, 0x02, 0xEF, 0x87,
  0x38, 0x6B, 0xFD, 0x20, 0x2E, 0x27, 0x48, 0x4B, 0xFD, 0x20, 0x17, 0x68, 0x2B, 0xFD, 0x27, 0x70,
  0x2A, 0x0D, 0x02, 0x76, 0x08, 0xB0, 0xD0, 0x27, 0x58, 0x5E, 0xFE, 0xBF, 0xD2, 0x73, 0x06, 0xA8,
  0x48, 0x0B, 0xFD, 0x27, 0x20, 0xBA, 0x02, 0x28, 0x2B, 0xFD, 0x27, 0x18, 0x15, 0xE8, 0x48, 0x2B,
  0xFD, 0x27, 0x71, 0x81, 0xBF, 0x97, 0x72, 0x06, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_color_fill 24x24, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_round_24_editor_format_color_fill_data[] PROGMEM = {
  0x50, 0x70, 0x27, 0x73, 0x82, 0x4F, 0xE3, 0x77, 0x38, 0x2A, 0xFE, 0x37, 0x73, 0x82, 0xBF, 0xE3,
  0x77, 0x10, 0x30, 0xEA, 0x0E, 0x03, 0x76, 0x86, 0x3E, 0xFA, 0xAF, 0xE3, 0x74, 0x82, 0x3E, 0xFA,
  0x28, 0x2A, 0xFE, 0x37, 0x28, 0x23, 0xEF, 0xA4, 0x82, 0xAF, 0xE3, 0x78, 0x23, 0xEF, 0xA6, 0x82,
  0xAF, 0xE3, 0x68, 0x1D, 0xFA, 0x71, 0x81, 0xAF, 0xD6, 0x0D, 0xFD, 0x0D, 0x60, 0x30, 0xEF, 0xB8,
  0x3E, 0x30, 0x11, 0x40, 0x30, 0xEF, 0x90, 0xE0, 0x32, 0x00, 0xC5, 0x03, 0x0E, 0xE0, 0xE0, 0x32,
  0x07, 0xA0, 0x65, 0x03, 0x0E, 0xC0, 0xE0, 0x33, 0x0D, 0xA0, 0xD6, 0x03, 0x0E, 0xA0, 0xE0, 0x34,
  0x0D, 0xA0, 0xD7, 0x82, 0x3D, 0xD3, 0x58, 0x24, 0xDD, 0x48, 0x0F, 0x10, 0x04, 0x0D, 0xFF, 0xA8,
  0x1D, 0x4D, 0xFF, 0xC0, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_color_fill() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 23), Box(0, 0, 23, 23),
      ic_round_24_editor_format_color_fill_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_color_reset 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_24_editor_format_color_reset_data[] PROGMEM = {
  0x70, 0x01, 0x76, 0x82, 0x2E, 0xE2, 0x60, 0x10, 0x54, 0x0C, 0xA0, 0xC6, 0x81, 0x7F, 0xB2, 0x04,
  0xC0, 0x85, 0x82, 0x1D, 0xFB, 0x20, 0x6C, 0x03, 0x58, 0x22, 0xDF, 0xB2, 0x06, 0xB0, 0xD6, 0x82,
  0x2E, 0xFB, 0x20, 0x6B, 0x06, 0x60, 0xEA, 0x0B, 0x20, 0x6A, 0x0D, 0x50, 0x6C, 0x0B, 0x20, 0x6A,
  0x06, 0x40, 0xBD, 0x0B, 0x28, 0x16, 0xFB, 0x40, 0xEE, 0x0B, 0x20, 0x60, 0xE4, 0x0E, 0xF0, 0xB2,
  0x05, 0x40, 0xCF, 0x90, 0xB6, 0x06, 0xFA, 0x0B, 0x60, 0xCF, 0xA0, 0xB5, 0x01, 0x0C, 0xE8, 0x2C,
  0xDF, 0xB6, 0x89, 0x16, 0xCE, 0xEC, 0x60, 0x2D, 0xF7, 0x76, 0x81, 0x29, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_color_reset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_color_reset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_color_text 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_24_editor_format_color_text_data[] PROGMEM = {
  0x71, 0x82, 0x3D, 0xD3, 0x77, 0x20, 0xCA, 0x0C, 0x77, 0x18, 0x42, 0xFE, 0xEF, 0x27, 0x78, 0x48,
  0xF9, 0x9F, 0x87, 0x78, 0x4E, 0xF4, 0x4F, 0xE7, 0x68, 0x14, 0xFE, 0x28, 0x1E, 0xF4, 0x75, 0x81,
  0xAF, 0x82, 0x81, 0x8F, 0xA7, 0x40, 0x1A, 0x03, 0x20, 0x3A, 0x01, 0x73, 0x06, 0xA8, 0x00, 0x9A,
  0x06, 0x73, 0x0C, 0xF9, 0x0C, 0x72, 0x03, 0xA8, 0x46, 0x55, 0x55, 0x6A, 0x03, 0x71, 0x81, 0x8F,
  0xC6, 0x81, 0xCF, 0x87, 0x18, 0x1E, 0xF6, 0x68, 0x16, 0xFE, 0x71, 0x81, 0xAD, 0x16, 0x81, 0x1D,
  0xB8, 0x0F, 0x40, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D,
  0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_color_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 23), Box(0, 0, 23, 23),
      ic_round_24_editor_format_color_text_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_indent_decrease 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_24_editor_format_indent_decrease_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0D, 0x00, 0x0B, 0xF9, 0x0B, 0x30, 0x24, 0x0B, 0xF9,
  0x0B, 0x20, 0x79, 0x77, 0x10, 0x7A, 0x77, 0x07, 0xB4, 0x0B, 0xF9, 0x0B, 0x07, 0xB4, 0x0B, 0xF9,
  0x81, 0xB0, 0x7A, 0x77, 0x20, 0x79, 0x77, 0x30, 0x24, 0x0B, 0xF9, 0x0B, 0x71, 0x0B, 0xF9, 0x0B,
  0x80, 0xC0, 0x00, 0xBF, 0xFA, 0x00, 0xBF, 0xFA, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_indent_decrease() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_indent_decrease_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_indent_increase 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_editor_format_indent_increase_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xB8, 0x0D, 0x00, 0x0B, 0xF9, 0x0B, 0x02, 0x70, 0xBF, 0x98,
  0x1B, 0xF7, 0x77, 0x2A, 0x07, 0x77, 0x1B, 0x07, 0x40, 0xBF, 0x90, 0xBB, 0x07, 0x40, 0xBF, 0x90,
  0xBA, 0x07, 0x77, 0x19, 0x07, 0x77, 0x20, 0x27, 0x0B, 0xF9, 0x0B, 0x71, 0x0B, 0xF9, 0x0B, 0x80,
  0xC0, 0x00, 0xBF, 0xFA, 0x00, 0xBF, 0xFA, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_indent_increase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_indent_increase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_italic 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_24_editor_format_italic_data[] PROGMEM = {
  0x40, 0x8E, 0x08, 0x40, 0xEE, 0x0E, 0x40, 0x8E, 0x08, 0x68, 0x1E, 0xFE, 0x71, 0x06, 0xA0, 0x87,
  0x10, 0xDA, 0x02, 0x70, 0x4A, 0x0B, 0x71, 0x0B, 0xA0, 0x47, 0x02, 0xA0, 0xD7, 0x10, 0x8A, 0x06,
  0x71, 0x81, 0xEF, 0xE6, 0x08, 0xE0, 0x84, 0x0E, 0xE0, 0xE4, 0x08, 0xE0, 0x84,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_italic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 17, 17), Box(0, 0, 23, 23),
      ic_round_24_editor_format_italic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_line_spacing 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_editor_format_line_spacing_data[] PROGMEM = {
  0x20, 0x01, 0x77, 0x38, 0x21, 0xDD, 0x17, 0x71, 0x01, 0x0D, 0xA0, 0xD0, 0x12, 0x0B, 0xFB, 0x0B,
  0x0A, 0xC0, 0xA2, 0x0B, 0xFB, 0x0B, 0x2A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x40,
  0xBF, 0xB0, 0xB2, 0xA4, 0x0B, 0xFB, 0x0B, 0x2A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x20,
  0xAC, 0x0A, 0x20, 0xBF, 0xB8, 0x1B, 0x1D, 0xA0, 0xD0, 0x12, 0x0B, 0xFB, 0x84, 0xB0, 0x1D, 0xD1,
  0x77, 0x30, 0x01, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_line_spacing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_line_spacing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_list_bulleted 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_24_editor_format_list_bulleted_data[] PROGMEM = {
  0x10, 0x05, 0x77, 0x20, 0x5A, 0x81, 0x50, 0xBF, 0xD0, 0xB0, 0x5A, 0x81, 0x50, 0xBF, 0xD8, 0x2B,
  0x05, 0x58, 0x0E, 0x30, 0x00, 0x57, 0x72, 0x05, 0xA8, 0x15, 0x0B, 0xFD, 0x0B, 0x05, 0xA8, 0x15,
  0x0B, 0xFD, 0x82, 0xB0, 0x55, 0x80, 0xE3, 0x00, 0x05, 0x77, 0x20, 0x5A, 0x81, 0x50, 0xBF, 0xD0,
  0xB0, 0x5A, 0x81, 0x50, 0xBF, 0xD8, 0x2B, 0x05, 0x57, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_list_bulleted() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_format_list_bulleted_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_list_numbered 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_24_editor_format_list_numbered_data[] PROGMEM = {
  0x0D, 0x0E, 0x77, 0x49, 0x30, 0xBF, 0xD0, 0xB1, 0x93, 0x0B, 0xFD, 0x81, 0xB0, 0xD8, 0x0E, 0x30,
  0x81, 0xDF, 0xE7, 0x73, 0x09, 0x07, 0x20, 0xBF, 0xD8, 0x1B, 0x79, 0x30, 0xBF, 0xD8, 0x2B, 0xEF,
  0xD8, 0x0E, 0x20, 0x81, 0xDF, 0xE7, 0x73, 0x06, 0x92, 0x0B, 0xFD, 0x81, 0xB0, 0x69, 0x20, 0xBF,
  0xD8, 0x2B, 0xDF, 0xE7, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_list_numbered() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_format_list_numbered_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_list_numbered_rtl 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_editor_format_list_numbered_rtl_data[] PROGMEM = {
  0x77, 0x28, 0x2D, 0xE0, 0xBF, 0xD0, 0xB3, 0x91, 0x0B, 0xFD, 0x0B, 0x39, 0x77, 0x40, 0xD8, 0x0E,
  0x30, 0x82, 0xDF, 0xEB, 0xFD, 0x0B, 0x38, 0x19, 0x7B, 0xFD, 0x0B, 0x20, 0x70, 0x97, 0x73, 0x81,
  0xEF, 0xD8, 0x0E, 0x20, 0x82, 0xDF, 0xEB, 0xFD, 0x0B, 0x38, 0x16, 0xFB, 0xFD, 0x0B, 0x30, 0x69,
  0x77, 0x28, 0x1D, 0xFE,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_list_numbered_rtl() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_format_list_numbered_rtl_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_paint 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_24_editor_format_paint_data[] PROGMEM = {
  0x0B, 0xFD, 0x0B, 0x3F, 0xF3, 0xFF, 0xA0, 0xBF, 0xFF, 0xFB, 0x1A, 0x0B, 0xFD, 0x0B, 0x1A, 0x77,
  0x1A, 0x77, 0x1A, 0x50, 0xBF, 0xC5, 0xFC, 0x0B, 0x5C, 0x76, 0xC7, 0x6C, 0x76, 0xC7, 0x6C, 0x76,
  0xC7, 0x6C, 0x76, 0xC7, 0x6C, 0x76, 0x0B, 0xA0, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_paint() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_format_paint_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_quote 24x24, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_round_24_editor_format_quote_data[] PROGMEM = {
  0x0B, 0xC0, 0xB4, 0x0B, 0xC0, 0xBE, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xE0, 0xBD, 0x40, 0xBD, 0x20,
  0x3A, 0x0B, 0x60, 0x3A, 0x0B, 0x20, 0xBA, 0x03, 0x60, 0xBA, 0x81, 0x30, 0x1A, 0x0B, 0x60, 0x1A,
  0x0B, 0x38, 0x1B, 0xD2, 0x78, 0x1B, 0xD2, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_quote() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 19, 16), Box(0, 0, 23, 23),
      ic_round_24_editor_format_quote_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_shapes 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_24_editor_format_shapes_data[] PROGMEM = {
  0x0B, 0xC0, 0xB7, 0x30, 0xBC, 0x0B, 0xE7, 0x3F, 0x92, 0xFF, 0x2C, 0x2F, 0xF2, 0xF9, 0x73, 0xE0,
  0xBC, 0x0B, 0x73, 0x0B, 0xC0, 0xB2, 0xA6, 0x00, 0xB6, 0xA4, 0xA5, 0x04, 0xA0, 0x45, 0xA4, 0xA5,
  0x82, 0xAC, 0xC9, 0x5A, 0x4A, 0x58, 0x2E, 0x77, 0xE5, 0xA4, 0xA4, 0x84, 0x6F, 0x11, 0xF6, 0x4A,
  0x4A, 0x48, 0x4C, 0xD3, 0x3D, 0xC4, 0xA4, 0xA3, 0x02, 0xE0, 0x23, 0xA4, 0xA3, 0x81, 0x8F, 0x12,
  0x81, 0x1F, 0x83, 0xA4, 0xA3, 0x00, 0x94, 0x00, 0x93, 0xA4, 0xA7, 0x7A, 0x20, 0xBC, 0x0B, 0x73,
  0x0B, 0xC0, 0xBE, 0x73, 0xF9, 0x2F, 0xF2, 0xC2, 0xFF, 0x2F, 0x97, 0x3E, 0x0B, 0xC0, 0xB7, 0x30,
  0xBC, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_shapes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_editor_format_shapes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_size 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_24_editor_format_size_data[] PROGMEM = {
  0x60, 0x8F, 0xC0, 0x86, 0x0E, 0xFC, 0x0E, 0x60, 0x8F, 0xC0, 0x87, 0x4B, 0x77, 0x2B, 0x50, 0x8F,
  0x08, 0x2B, 0x50, 0xEF, 0x0E, 0x2B, 0x50, 0x8F, 0x08, 0x2B, 0x71, 0xB5, 0xB7, 0x1B, 0x5B, 0x71,
  0xB5, 0xB7, 0x1B, 0x5B, 0x71, 0xB5, 0xB7, 0x1B, 0x5B, 0x71, 0x81, 0x8E, 0x85, 0x81, 0x8E, 0x85,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_size() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 21, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_format_size_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_strikethrough 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_24_editor_format_strikethrough_data[] PROGMEM = {
  0x20, 0x8F, 0xD0, 0x84, 0x0E, 0xFD, 0x0E, 0x40, 0x8F, 0xD0, 0x87, 0x2C, 0x77, 0xC7, 0x7C, 0x80,
  0xC7, 0x00, 0xBF, 0xFA, 0x00, 0xBF, 0xFA, 0x0B, 0x80, 0xC7, 0x0C, 0x77, 0x0D, 0xA0, 0xD7, 0x78,
  0x24, 0xDD, 0x47,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_strikethrough() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_format_strikethrough_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_textdirection_l_to_r 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_24_editor_format_textdirection_l_to_r_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0xF0, 0xB4, 0x01, 0x0D, 0xFA, 0x0B, 0x40, 0x9D, 0x2A, 0x60, 0xED, 0x2A, 0x60,
  0xDD, 0x2A, 0x60, 0x9D, 0x2A, 0x60, 0x10, 0xEC, 0x2A, 0x78, 0x11, 0x9D, 0xA2, 0xA7, 0x3A, 0x2A,
  0x73, 0xA2, 0xA7, 0x3A, 0x2A, 0x73, 0xA2, 0xA7, 0x30, 0x0B, 0x20, 0x0B, 0x20, 0x27, 0x71, 0x90,
  0x77, 0x7A, 0x81, 0x70, 0xBF, 0xF0, 0x70, 0xBF, 0xF0, 0x77, 0x5A, 0x07, 0x76, 0x90, 0x77, 0x70,
  0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_textdirection_l_to_r() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_format_textdirection_l_to_r_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_textdirection_r_to_l 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_24_editor_format_textdirection_r_to_l_data[] PROGMEM = {
  0x38, 0x11, 0x9D, 0xF0, 0xB4, 0x01, 0x0D, 0xFA, 0x0B, 0x40, 0x9D, 0x2A, 0x60, 0xED, 0x2A, 0x60,
  0xDD, 0x2A, 0x60, 0x9D, 0x2A, 0x60, 0x10, 0xEC, 0x2A, 0x78, 0x11, 0x9D, 0xA2, 0xA7, 0x3A, 0x2A,
  0x73, 0xA2, 0xA7, 0x3A, 0x2A, 0x73, 0xA2, 0xA7, 0x02, 0x20, 0x0B, 0x20, 0x0B, 0x60, 0x79, 0x76,
  0x07, 0xA7, 0x50, 0x7F, 0xF0, 0xB0, 0x7F, 0xF8, 0x1B, 0x07, 0xA7, 0x70, 0x79, 0x77, 0x10, 0x27,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_textdirection_r_to_l() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_format_textdirection_r_to_l_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_format_underlined 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_24_editor_format_underlined_data[] PROGMEM = {
  0x18, 0x19, 0xE3, 0x68, 0x13, 0xE9, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07,
  0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07,
  0x60, 0x7A, 0x28, 0x1E, 0xF9, 0x68, 0x19, 0xFE, 0x28, 0x1C, 0xFD, 0x68, 0x1D, 0xFB, 0x20, 0x6A,
  0x09, 0x40, 0x9A, 0x05, 0x30, 0xCA, 0x82, 0xD9, 0x9D, 0xA0, 0xB4, 0x01, 0x0C, 0xE0, 0xC0, 0x16,
  0x06, 0x0C, 0xA0, 0xC0, 0x67, 0x77, 0x74, 0x0B, 0xFD, 0x00, 0xBF, 0xD0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_format_underlined() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_format_underlined_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_functions 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_24_editor_functions_data[] PROGMEM = {
  0x07, 0xFB, 0x08, 0x0E, 0xFB, 0x0E, 0x06, 0xFB, 0x81, 0x80, 0x6B, 0x07, 0x71, 0x05, 0xB0, 0x77,
  0x10, 0x40, 0xEA, 0x07, 0x71, 0x03, 0x0E, 0xA0, 0x77, 0x10, 0x20, 0xDA, 0x01, 0x70, 0x20, 0xDA,
  0x01, 0x60, 0x30, 0xEA, 0x07, 0x60, 0x40, 0xEA, 0x07, 0x60, 0x5B, 0x07, 0x60, 0x6B, 0x07, 0x60,
  0x6F, 0xB0, 0x80, 0xEF, 0xB0, 0xE0, 0x7F, 0xB0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_functions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 17, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_functions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_height 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_round_24_editor_height_data[] PROGMEM = {
  0x30, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x7C, 0x81, 0x70, 0x2E, 0x02, 0x3A, 0x6A, 0x6A, 0x6A, 0x6A,
  0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x30, 0x2E, 0x81, 0x20, 0x7C, 0x07, 0x30, 0x7A, 0x07, 0x50, 0x07,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_height() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 3, 15, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_height_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_hexagon 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_24_editor_hexagon_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x60, 0x9F, 0xD0, 0x95, 0x03,
  0xFF, 0x03, 0x40, 0xCF, 0xF0, 0xC3, 0x05, 0xFF, 0xA0, 0x52, 0x0D, 0xFF, 0xA8, 0x1D, 0x08, 0xFF,
  0xC0, 0x80, 0xEF, 0xFC, 0x00, 0xEF, 0xFC, 0x0E, 0x08, 0xFF, 0xC8, 0x18, 0x0D, 0xFF, 0xA0, 0xD2,
  0x05, 0xFF, 0xA0, 0x53, 0x0C, 0xFF, 0x0C, 0x40, 0x3F, 0xF0, 0x35, 0x09, 0xFD, 0x09, 0x60, 0x10,
  0xEF, 0xB0, 0xE0, 0x17, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_hexagon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_hexagon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_highlight 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_24_editor_highlight_data[] PROGMEM = {
  0x70, 0x0B, 0x77, 0xA7, 0x70, 0x0B, 0x78, 0x1D, 0xC1, 0x73, 0x84, 0x1C, 0xDB, 0xF8, 0x73, 0x84,
  0x7F, 0xB0, 0x72, 0x73, 0x81, 0x27, 0x17, 0x74, 0x0B, 0xFB, 0x0B, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4,
  0x0E, 0xFC, 0x40, 0x7F, 0xB0, 0x75, 0x07, 0xF9, 0x07, 0x70, 0x7E, 0x07, 0x72, 0xE7, 0x3E, 0x73,
  0xE7, 0x3E, 0x73, 0x0B, 0xC0, 0xB5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_highlight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_highlight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_horizontal_distribute 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_editor_horizontal_distribute_data[] PROGMEM = {
  0x00, 0xB7, 0x72, 0x00, 0xBA, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x68, 0x22, 0xDD,
  0x26, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0,
  0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0,
  0x76, 0xC6, 0x82, 0x2D, 0xD2, 0x6C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2A, 0x00, 0xB7,
  0x72, 0x00, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_horizontal_distribute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_horizontal_distribute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_horizontal_rule 24x24, 4-bit Alpha,  RLE, 6 bytes.
static const unsigned char ic_round_24_editor_horizontal_rule_data[] PROGMEM = {
  0x0B, 0xFF, 0x00, 0xBF, 0xF0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_horizontal_rule() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 11, 19, 12), Box(0, 0, 23, 23),
      ic_round_24_editor_horizontal_rule_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_chart_outlined 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_editor_insert_chart_outlined_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0xA0, 0x37, 0x50, 0x3C, 0x77, 0xC6, 0x00, 0xB6,
  0xC6, 0xA6, 0xC6, 0xA6, 0xC2, 0x00, 0xB2, 0xA6, 0xC2, 0xA2, 0xA6, 0xC2, 0xA2, 0xA6, 0xC2, 0xA2,
  0xA2, 0x00, 0xB2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0x00, 0xB2, 0x00, 0xB2,
  0x00, 0xB2, 0xC7, 0x7C, 0x03, 0x75, 0x03, 0xA0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_chart_outlined() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_chart_outlined_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_chart 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_24_editor_insert_chart_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xD0, 0xF0, 0x03, 0xFF, 0xA2, 0xFF, 0xA2,
  0xFD, 0x00, 0x3A, 0x2F, 0xD2, 0xA2, 0xFD, 0x2A, 0x2F, 0xD2, 0xA2, 0xA0, 0x03, 0xF9, 0x2A, 0x2A,
  0x2F, 0x92, 0xA2, 0xA2, 0xF9, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x38, 0x0C, 0x4F, 0x0D, 0xFF, 0xA8,
  0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_comment 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_editor_insert_comment_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x0F, 0x03, 0x73, 0x03, 0xF9, 0x03,
  0x73, 0x03, 0xFF, 0xFF, 0x03, 0x73, 0x03, 0xF9, 0x03, 0x73, 0x03, 0xFF, 0xFF, 0x03, 0x73, 0x03,
  0xF9, 0x03, 0x73, 0x03, 0x80, 0xD0, 0xF0, 0xDF, 0xFD, 0x04, 0x0D, 0xFF, 0xC7, 0x72, 0x07, 0xB7,
  0x73, 0x07, 0xA7, 0x74, 0x07, 0x97, 0x75, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_drive_file 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_24_editor_insert_drive_file_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xE0, 0x65, 0x0D, 0xF9, 0x81, 0xDF, 0x74, 0xFA, 0x82, 0x1D, 0xF7, 0x3F, 0xA1,
  0x82, 0x1D, 0xF7, 0x2F, 0xA2, 0x82, 0x1D, 0xF7, 0x1F, 0xA3, 0x82, 0x1D, 0xF6, 0xFA, 0x03, 0x38,
  0x11, 0xDE, 0x80, 0xAD, 0x4F, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_drive_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_drive_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_emoticon 24x24, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_24_editor_insert_emoticon_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xC8, 0x17, 0x07, 0xC8,
  0x17, 0x07, 0xC0, 0x50, 0xAC, 0x3C, 0x3C, 0x09, 0x0D, 0xC8, 0x17, 0x07, 0xC8, 0x17, 0x07, 0xC0,
  0xD0, 0xEF, 0xFC, 0x00, 0xEF, 0xFC, 0x0E, 0x0D, 0xFF, 0xC0, 0xD0, 0xAC, 0x05, 0x71, 0x05, 0xC0,
  0x90, 0x5C, 0x0C, 0x71, 0x0C, 0xC8, 0x15, 0x0D, 0xC0, 0xC0, 0x24, 0x02, 0x0C, 0xC0, 0xD2, 0x04,
  0xE8, 0x2B, 0x88, 0xBE, 0x04, 0x30, 0x8F, 0xF0, 0x85, 0x08, 0xFD, 0x08, 0x70, 0x50, 0xDF, 0x90,
  0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_emoticon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_emoticon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_invitation 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_editor_insert_invitation_data[] PROGMEM = {
  0x30, 0x0B, 0x71, 0x00, 0xB6, 0xA7, 0x1A, 0x30, 0x40, 0xDF, 0xF8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD8,
  0x0E, 0x4F, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x70, 0xBB, 0x0B, 0x2C, 0x7D, 0x2C, 0x7D, 0x2C,
  0x7D, 0x2C, 0x70, 0xBB, 0x0B, 0x2C, 0x77, 0xC0, 0x37, 0x50, 0x3A, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D,
  0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_invitation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_invitation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_link 24x24, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_24_editor_insert_link_data[] PROGMEM = {
  0x28, 0x12, 0xAD, 0xB0, 0xB2, 0x0B, 0xB8, 0x1D, 0xA2, 0x30, 0x6B, 0x0F, 0xD0, 0x92, 0x09, 0x0F,
  0xDB, 0x84, 0x60, 0x3F, 0xE5, 0x75, 0x85, 0x5E, 0xF3, 0xBF, 0x57, 0x78, 0x25, 0xFA, 0xE9, 0x40,
  0xBE, 0x0B, 0x49, 0x00, 0xE9, 0x40, 0xBE, 0x0B, 0x49, 0x82, 0xEB, 0xF5, 0x77, 0x85, 0x5F, 0xB4,
  0xFE, 0x57, 0x58, 0x45, 0xEF, 0x40, 0x8B, 0x0F, 0xD0, 0x92, 0x09, 0x0F, 0xDB, 0x08, 0x38, 0x14,
  0xBE, 0xB0, 0xB2, 0x0B, 0xB8, 0x1E, 0xB4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_link() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 16), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_link_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_page_break 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_24_editor_insert_page_break_data[] PROGMEM = {
  0x30, 0x40, 0xDF, 0x0E, 0x06, 0x74, 0x0D, 0xF9, 0x81, 0xDF, 0x77, 0x3F, 0xA8, 0x21, 0xDF, 0x77,
  0x2F, 0xA1, 0x82, 0x1D, 0xF7, 0x71, 0xFA, 0x28, 0x21, 0xDF, 0x77, 0xFA, 0x38, 0x21, 0xDF, 0x66,
  0xFA, 0x03, 0x38, 0x11, 0xDE, 0x6F, 0xFA, 0x6F, 0xFA, 0x80, 0xD3, 0x00, 0xBC, 0x0B, 0x20, 0xBC,
  0x0B, 0x20, 0xBC, 0x00, 0xBC, 0x0B, 0x20, 0xBC, 0x0B, 0x20, 0xBC, 0x0B, 0x80, 0xD3, 0x0F, 0xFA,
  0x6F, 0xFA, 0x6F, 0xFA, 0x60, 0xDF, 0xF0, 0xD6, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_page_break() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_page_break_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_insert_photo 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_editor_insert_photo_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xA8, 0x4F, 0x81, 0xE7, 0xEF, 0xB0, 0xEC,
  0x81, 0x50, 0x5F, 0xA8, 0x1B, 0x0A, 0xA0, 0x83, 0x09, 0xF0, 0xD0, 0x12, 0x0C, 0x0B, 0x50, 0xCE,
  0x03, 0x30, 0x01, 0x50, 0x20, 0xEC, 0x0A, 0x75, 0x09, 0xFF, 0xE0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF,
  0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_insert_photo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_insert_photo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_linear_scale 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_editor_linear_scale_data[] PROGMEM = {
  0x75, 0x84, 0x3B, 0xEE, 0xB4, 0x76, 0x07, 0xE0, 0x82, 0x81, 0x37, 0x36, 0x04, 0xA8, 0x27, 0x11,
  0x7A, 0x04, 0x06, 0xB0, 0x65, 0x81, 0xAF, 0x74, 0x82, 0x7F, 0xBD, 0xFC, 0x01, 0x48, 0x21, 0xFE,
  0xDF, 0xC0, 0x14, 0x82, 0x1F, 0xE6, 0xB0, 0x65, 0x81, 0xAF, 0x74, 0x85, 0x7F, 0xB0, 0x37, 0x36,
  0x04, 0xA8, 0x27, 0x11, 0x7A, 0x04, 0x74, 0x07, 0xE0, 0x87, 0x68, 0x43, 0xBE, 0xEB, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_linear_scale() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 16), Box(0, 0, 23, 23),
      ic_round_24_editor_linear_scale_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_line_axis 24x24, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_round_24_editor_line_axis_data[] PROGMEM = {
  0x70, 0x27, 0x73, 0x83, 0x1D, 0xFD, 0x37, 0x70, 0x10, 0xDB, 0x0E, 0x03, 0x70, 0x70, 0x13, 0x87,
  0x1D, 0xFD, 0x2A, 0xFE, 0x45, 0x81, 0xBF, 0x82, 0x83, 0x1D, 0xFD, 0x12, 0x09, 0xA0, 0x53, 0x89,
  0x09, 0xFE, 0x20, 0x1D, 0xFD, 0x14, 0x07, 0xA8, 0x92, 0x60, 0x7F, 0xE3, 0x01, 0xDF, 0xD2, 0x20,
  0x13, 0x06, 0xA0, 0xAA, 0x04, 0x28, 0x90, 0x7F, 0xD2, 0x01, 0xCF, 0xC1, 0x20, 0x5B, 0x06, 0x38,
  0x41, 0x71, 0x01, 0xDB, 0x83, 0xD1, 0x03, 0xEA, 0x0A, 0x68, 0x95, 0x1D, 0xFD, 0x3D, 0xFD, 0x4E,
  0xFA, 0xEF, 0xB4, 0x86, 0x1D, 0xFD, 0x20, 0x1D, 0xB8, 0x4B, 0x03, 0xEF, 0xB2, 0x83, 0x1D, 0xFD,
  0x23, 0x82, 0x1C, 0xFA, 0x38, 0x72, 0xDF, 0x71, 0xDF, 0xD2, 0x75, 0x85, 0x18, 0x17, 0xFD, 0x27,
  0x72, 0x81, 0x17, 0x17, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_line_axis() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_line_axis_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_margin 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_24_editor_margin_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xC4, 0xF0, 0x03, 0xA0, 0x03, 0xA0, 0x03,
  0xF9, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x38, 0x0D, 0x0F, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3F, 0x90,
  0x03, 0xA0, 0x03, 0xA0, 0x03, 0x80, 0x9D, 0x4F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_margin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_margin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_merge_type 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_24_editor_merge_type_data[] PROGMEM = {
  0x50, 0x01, 0x72, 0x82, 0x1D, 0xD1, 0x70, 0x10, 0xDA, 0x0D, 0x01, 0x50, 0x10, 0xDC, 0x0D, 0x01,
  0x40, 0xAE, 0x0A, 0x7A, 0x73, 0xA7, 0x3A, 0x73, 0xA7, 0x3A, 0x72, 0x01, 0xA7, 0x18, 0x21, 0xCF,
  0xB7, 0x86, 0x1C, 0xFC, 0x10, 0x11, 0x38, 0x96, 0x1C, 0xFC, 0x10, 0x1C, 0xC1, 0x01, 0xCF, 0xC1,
  0x28, 0x71, 0xCF, 0xC1, 0xBF, 0xC1, 0x48, 0x51, 0xCF, 0xBA, 0xB1, 0x68, 0x11, 0xBA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_merge_type() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 17, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_merge_type_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_mode_comment 24x24, 4-bit Alpha,  RLE, 29 bytes.
static const unsigned char ic_round_24_editor_mode_comment_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0B, 0xD4, 0xF0, 0xDF, 0xFD, 0x04, 0x0D,
  0xFF, 0xC7, 0x72, 0x07, 0xB7, 0x73, 0x07, 0xA7, 0x74, 0x07, 0x97, 0x75, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_mode_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_mode_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_mode_edit_outline 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_24_editor_mode_edit_outline_data[] PROGMEM = {
  0x76, 0x81, 0x4D, 0x87, 0x70, 0x4B, 0x08, 0x76, 0x07, 0xC0, 0x87, 0x38, 0x24, 0x50, 0x7B, 0x0D,
  0x72, 0x04, 0xA8, 0x15, 0x07, 0xA0, 0x47, 0x10, 0x4C, 0x82, 0x50, 0x74, 0x71, 0x04, 0xE0, 0x57,
  0x20, 0x4F, 0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4F, 0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4F,
  0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4E, 0x0E, 0x04, 0x72, 0x0E, 0xD0, 0xE0, 0x47, 0x3D, 0x0E,
  0x04, 0x74, 0xC0, 0xE0, 0x47, 0x50, 0xEA, 0x0E, 0x04, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_mode_edit_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_mode_edit_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_mode_edit 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_24_editor_mode_edit_data[] PROGMEM = {
  0x76, 0x81, 0x4D, 0x87, 0x70, 0x4B, 0x08, 0x76, 0x07, 0xC0, 0x87, 0x38, 0x24, 0x50, 0x7B, 0x0D,
  0x72, 0x04, 0xA8, 0x15, 0x07, 0xA0, 0x47, 0x10, 0x4C, 0x82, 0x50, 0x74, 0x71, 0x04, 0xE0, 0x57,
  0x20, 0x4F, 0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4F, 0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4F,
  0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4E, 0x0E, 0x04, 0x72, 0x0E, 0xD0, 0xE0, 0x47, 0x3D, 0x0E,
  0x04, 0x74, 0xC0, 0xE0, 0x47, 0x50, 0xEA, 0x0E, 0x04, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_mode_edit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_mode_edit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_mode 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_24_editor_mode_data[] PROGMEM = {
  0x76, 0x81, 0x4D, 0x87, 0x70, 0x4B, 0x08, 0x76, 0x07, 0xC0, 0x87, 0x38, 0x24, 0x50, 0x7B, 0x0D,
  0x72, 0x04, 0xA8, 0x15, 0x07, 0xA0, 0x47, 0x10, 0x4C, 0x82, 0x50, 0x74, 0x71, 0x04, 0xE0, 0x57,
  0x20, 0x4F, 0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4F, 0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4F,
  0x04, 0x71, 0x04, 0xF0, 0x47, 0x10, 0x4E, 0x0E, 0x04, 0x72, 0x0E, 0xD0, 0xE0, 0x47, 0x3D, 0x0E,
  0x04, 0x74, 0xC0, 0xE0, 0x47, 0x50, 0xEA, 0x0E, 0x04, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_monetization_on 24x24, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_round_24_editor_monetization_on_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xC8, 0x2E, 0x31,
  0xDC, 0x08, 0x50, 0x8D, 0x0B, 0x20, 0x9D, 0x08, 0x30, 0x4C, 0x0E, 0x06, 0x40, 0x60, 0xEC, 0x04,
  0x20, 0xDC, 0x86, 0x30, 0x27, 0x72, 0x05, 0xC8, 0x1D, 0x05, 0xC8, 0x2B, 0x02, 0xEB, 0x81, 0x20,
  0xEC, 0x05, 0x09, 0xC8, 0x1A, 0x03, 0xC0, 0xD0, 0xBD, 0x09, 0x0D, 0xC8, 0x3E, 0x10, 0x4B, 0xFA,
  0x0D, 0x0E, 0xD0, 0xB0, 0x12, 0x81, 0x15, 0xCE, 0x00, 0xEE, 0x81, 0xE9, 0x43, 0x07, 0xD0, 0xE0,
  0xDF, 0xA0, 0xE0, 0x82, 0x0C, 0xC0, 0xD0, 0x9D, 0x0B, 0x0E, 0xC8, 0x15, 0x07, 0xC0, 0x90, 0x5C,
  0x81, 0xB0, 0x4C, 0x81, 0x40, 0x8C, 0x81, 0x50, 0xDC, 0x87, 0x20, 0x37, 0x73, 0x01, 0xDB, 0x0D,
  0x20, 0x4C, 0x0E, 0x05, 0x40, 0x40, 0xCC, 0x04, 0x30, 0x8D, 0x0B, 0x20, 0x9D, 0x08, 0x50, 0x8C,
  0x82, 0xE3, 0x1D, 0xC0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_monetization_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_monetization_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_money_off_csred 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_24_editor_money_off_csred_data[] PROGMEM = {
  0x78, 0x18, 0xE8, 0x68, 0x11, 0x82, 0x4B, 0x68, 0x26, 0xFD, 0x22, 0x09, 0xB0, 0x90, 0x25, 0x86,
  0xBF, 0xD2, 0x03, 0xEE, 0xA0, 0xE0, 0x35, 0x82, 0xBF, 0xD2, 0x38, 0x21, 0x9F, 0xC6, 0x82, 0xBF,
  0xD2, 0x38, 0x11, 0xDB, 0x60, 0x5A, 0x0D, 0x02, 0x74, 0x01, 0x0D, 0xA0, 0xD0, 0x27, 0x40, 0x20,
  0xCA, 0x0D, 0x02, 0x75, 0x83, 0x5C, 0xFD, 0x27, 0x68, 0x2B, 0xFD, 0x27, 0x68, 0x2B, 0xFD, 0x26,
  0x81, 0x3E, 0x74, 0x82, 0xBF, 0xD2, 0x50, 0x3A, 0x06, 0x30, 0x7A, 0x0D, 0x02, 0x50, 0x8B, 0x0D,
  0xB8, 0x2E, 0xFD, 0x25, 0x04, 0x0A, 0xB8, 0x4A, 0x50, 0xBF, 0x87, 0x0E, 0xA4, 0x06, 0x02, 0x78,
  0x17, 0xE8, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_money_off_csred() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_money_off_csred_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_money_off 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_24_editor_money_off_data[] PROGMEM = {
  0x78, 0x18, 0xE8, 0x68, 0x11, 0x82, 0x4B, 0x68, 0x26, 0xFD, 0x22, 0x09, 0xB0, 0x90, 0x25, 0x86,
  0xBF, 0xD2, 0x03, 0xEE, 0xA0, 0xE0, 0x35, 0x82, 0xBF, 0xD2, 0x38, 0x21, 0x9F, 0xC6, 0x82, 0xBF,
  0xD2, 0x38, 0x11, 0xDB, 0x60, 0x5A, 0x0D, 0x02, 0x74, 0x01, 0x0D, 0xA0, 0xD0, 0x27, 0x40, 0x20,
  0xCA, 0x0D, 0x02, 0x75, 0x83, 0x5C, 0xFD, 0x27, 0x68, 0x2B, 0xFD, 0x27, 0x68, 0x2B, 0xFD, 0x26,
  0x81, 0x3E, 0x74, 0x82, 0xBF, 0xD2, 0x50, 0x3A, 0x06, 0x30, 0x7A, 0x0D, 0x02, 0x50, 0x8B, 0x0D,
  0xB8, 0x2E, 0xFD, 0x25, 0x04, 0x0A, 0xB8, 0x4A, 0x50, 0xBF, 0x87, 0x0E, 0xA4, 0x06, 0x02, 0x78,
  0x17, 0xE8, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_money_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_money_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_move_down 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_24_editor_move_down_data[] PROGMEM = {
  0x48, 0x16, 0xBE, 0xA0, 0xB2, 0x04, 0x0D, 0xD0, 0xD0, 0x42, 0x04, 0x0D, 0xD0, 0xB2, 0x0D, 0xF8,
  0x1D, 0x04, 0xA8, 0x1C, 0x52, 0x5A, 0x5A, 0x82, 0x1E, 0xF8, 0x71, 0xA5, 0xA8, 0x17, 0xFB, 0x72,
  0xA5, 0xA8, 0x1C, 0xF4, 0x72, 0x0D, 0xF0, 0xD0, 0xE9, 0x73, 0x04, 0x0D, 0xD8, 0x3D, 0x4E, 0xF1,
  0x77, 0x48, 0x1C, 0xF4, 0x77, 0x48, 0x17, 0xFB, 0x20, 0x05, 0x50, 0x40, 0xDD, 0x89, 0x0D, 0x41,
  0xEF, 0x80, 0xDF, 0x74, 0x0D, 0xF8, 0x1D, 0x05, 0xA0, 0xB0, 0xAA, 0x07, 0x3F, 0xA2, 0x05, 0x0E,
  0xD0, 0x52, 0xFA, 0x38, 0x11, 0x7C, 0xB0, 0x52, 0xFA, 0x50, 0x5A, 0x07, 0x30, 0xDF, 0x0D, 0x58,
  0x1D, 0xF7, 0x40, 0x40, 0xDD, 0x0D, 0x04, 0x50, 0x05, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_move_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_move_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_move_up 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_24_editor_move_up_data[] PROGMEM = {
  0x50, 0x05, 0x77, 0x58, 0x1D, 0xF7, 0x40, 0x40, 0xDD, 0x0D, 0x04, 0x50, 0x5A, 0x07, 0x30, 0xDF,
  0x0D, 0x38, 0x11, 0x7C, 0xB0, 0x52, 0xFA, 0x20, 0x50, 0xED, 0x05, 0x2F, 0xA1, 0x05, 0xA0, 0xB0,
  0xAA, 0x07, 0x3F, 0xA8, 0x61, 0xEF, 0x80, 0xDF, 0x74, 0x0D, 0xF8, 0x2D, 0x7F, 0xB2, 0x00, 0x55,
  0x04, 0x0D, 0xD8, 0x3D, 0x4C, 0xF4, 0x77, 0x48, 0x1E, 0xF1, 0x77, 0x40, 0xE9, 0x73, 0x04, 0x0D,
  0xD8, 0x3D, 0x4C, 0xF4, 0x72, 0x0D, 0xF8, 0x2D, 0x7F, 0xB7, 0x2A, 0x5A, 0x82, 0x1E, 0xF8, 0x71,
  0xA5, 0xA1, 0x04, 0xA8, 0x1C, 0x52, 0x5A, 0x5A, 0x20, 0x40, 0xDD, 0x0B, 0x20, 0xDF, 0x0D, 0x48,
  0x16, 0xBE, 0xA0, 0xB2, 0x04, 0x0D, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_move_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_move_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_multiline_chart 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_24_editor_multiline_chart_data[] PROGMEM = {
  0x38, 0x72, 0x7B, 0xDF, 0xDC, 0x83, 0x72, 0x02, 0x0A, 0xFA, 0x0B, 0x02, 0x38, 0x95, 0x4E, 0x64,
  0xEF, 0xE9, 0x41, 0x01, 0x38, 0xEA, 0x89, 0x06, 0x03, 0xEF, 0x65, 0xF9, 0x17, 0x10, 0x9A, 0x82,
  0x8E, 0xF9, 0x77, 0x06, 0xB0, 0xA7, 0x18, 0x17, 0xF7, 0x50, 0xDA, 0x01, 0x70, 0x7B, 0x08, 0x30,
  0xBB, 0x08, 0x60, 0x7A, 0x0B, 0xA8, 0x78, 0x09, 0xFE, 0x5F, 0xE1, 0x40, 0x7A, 0x81, 0x70, 0x7A,
  0x86, 0xCF, 0xE3, 0x0B, 0xF5, 0x30, 0x7A, 0x07, 0x30, 0x7B, 0x04, 0x28, 0x16, 0xF9, 0x20, 0x7A,
  0x07, 0x58, 0x17, 0xF5, 0x38, 0x32, 0xFC, 0x05, 0xA0, 0x77, 0x68, 0x45, 0x30, 0x5F, 0x77, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_multiline_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 17), Box(0, 0, 23, 23),
      ic_round_24_editor_multiline_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_notes 24x24, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_round_24_editor_notes_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0xB0, 0xCF, 0xFA, 0x0C, 0x80, 0xE2, 0x00, 0xBF, 0xFA, 0x00, 0xBF, 0xFA, 0x0B,
  0x80, 0xE2, 0x00, 0xBF, 0xB0, 0xB6, 0x0B, 0xFB, 0x0B, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_notes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 17), Box(0, 0, 23, 23),
      ic_round_24_editor_notes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_numbers 24x24, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_24_editor_numbers_data[] PROGMEM = {
  0x68, 0x11, 0xD7, 0x38, 0x11, 0xD7, 0x72, 0x81, 0x5F, 0x93, 0x81, 0x5F, 0x97, 0x28, 0x19, 0xF5,
  0x38, 0x19, 0xF5, 0x72, 0x81, 0xDF, 0x13, 0x81, 0xDF, 0x14, 0x01, 0x0D, 0xFF, 0x82, 0x70, 0x1E,
  0xFF, 0x07, 0x58, 0x19, 0xF5, 0x38, 0x19, 0xF5, 0x72, 0x81, 0xDF, 0x13, 0x81, 0xDF, 0x17, 0x18,
  0x11, 0xFD, 0x38, 0x11, 0xFD, 0x72, 0x81, 0x5F, 0x93, 0x81, 0x5F, 0x95, 0x07, 0xFF, 0x82, 0xD1,
  0x07, 0xFF, 0x0D, 0x01, 0x48, 0x11, 0xFD, 0x38, 0x11, 0xFD, 0x72, 0x81, 0x5F, 0x93, 0x81, 0x5F,
  0x97, 0x28, 0x19, 0xF5, 0x38, 0x19, 0xF5, 0x72, 0x81, 0x7D, 0x13, 0x81, 0x7D, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_numbers() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_numbers_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_padding 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_round_24_editor_padding_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xC4, 0xF0, 0x03, 0xA0, 0x03, 0xA0, 0x03,
  0xF9, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x38, 0x0A, 0xE4, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0,
  0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_padding() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_padding_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_pentagon 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_24_editor_pentagon_data[] PROGMEM = {
  0x72, 0x81, 0x66, 0x17, 0x71, 0x03, 0x0D, 0xA0, 0xD0, 0x47, 0x60, 0x8E, 0x08, 0x73, 0x02, 0x0C,
  0xF9, 0x0C, 0x02, 0x70, 0x7F, 0xD0, 0x74, 0x01, 0x0B, 0xFF, 0x83, 0xB1, 0x02, 0xEF, 0xFA, 0x81,
  0xE2, 0x8F, 0xFC, 0x08, 0x07, 0xFF, 0xC0, 0x70, 0x2F, 0xFC, 0x81, 0x20, 0xCF, 0xFA, 0x0C, 0x20,
  0x7F, 0xFA, 0x07, 0x20, 0x2F, 0xFA, 0x02, 0x30, 0xDF, 0xF0, 0xC4, 0x07, 0xFF, 0x07, 0x40, 0x2F,
  0xF0, 0x25, 0x0D, 0xFD, 0x0C, 0x60, 0x7F, 0xD0, 0x77, 0x0A, 0xFB, 0x0A, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_pentagon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_pentagon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_pie_chart_outline 24x24, 4-bit Alpha,  RLE, 126 bytes.
static const unsigned char ic_round_24_editor_pie_chart_outline_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0xA8, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x63, 0xA3, 0x06, 0xA0, 0x83, 0x04, 0xA0, 0x44, 0xA4,
  0x04, 0xA0, 0x42, 0x81, 0xDF, 0x65, 0xA5, 0x85, 0x6F, 0xD0, 0x5F, 0xD6, 0xA6, 0x84, 0xCF, 0x59,
  0xF6, 0x6A, 0x68, 0x46, 0xF9, 0xDF, 0x26, 0xA0, 0x35, 0x82, 0x2F, 0xDE, 0x97, 0xFB, 0x00, 0xE9,
  0x7F, 0xB8, 0x2E, 0xDF, 0x26, 0xA0, 0x35, 0x84, 0x2F, 0xD9, 0xF6, 0x6A, 0x68, 0x46, 0xF9, 0x5F,
  0xD6, 0xA6, 0x85, 0xCF, 0x50, 0xDF, 0x65, 0xA5, 0x81, 0x6F, 0xD2, 0x04, 0xA0, 0x44, 0xA4, 0x04,
  0xA0, 0x43, 0x08, 0xA0, 0x63, 0xA3, 0x06, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0xA8, 0x12, 0x6C,
  0xA0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_pie_chart_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_pie_chart_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_pie_chart 24x24, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_24_editor_pie_chart_data[] PROGMEM = {
  0x68, 0x16, 0xA8, 0x28, 0x18, 0xA6, 0x73, 0x05, 0x0E, 0xB2, 0x0E, 0xA0, 0xE0, 0x67, 0x09, 0xD2,
  0xD0, 0x95, 0x09, 0xE2, 0xE0, 0x93, 0x05, 0xF2, 0xF0, 0x52, 0x0D, 0xF2, 0xF8, 0x1E, 0x05, 0xF9,
  0x2F, 0x90, 0x60, 0xAF, 0x92, 0xF9, 0x0B, 0x0D, 0xF9, 0x20, 0xBF, 0x08, 0x0E, 0xF9, 0x74, 0x0E,
  0xF9, 0x74, 0x0D, 0xF9, 0x20, 0xBF, 0x09, 0x0A, 0xF9, 0x2F, 0x90, 0xB0, 0x5F, 0x92, 0xF9, 0x81,
  0x60, 0xDF, 0x2F, 0x0E, 0x20, 0x5F, 0x2F, 0x06, 0x30, 0x9E, 0x2E, 0x09, 0x50, 0x9D, 0x2D, 0x09,
  0x70, 0x50, 0xEB, 0x20, 0xEA, 0x0E, 0x06, 0x73, 0x81, 0x6A, 0x82, 0x81, 0x8A, 0x66,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_pie_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_pie_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_polyline 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_24_editor_polyline_data[] PROGMEM = {
  0x70, 0x8C, 0x08, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x74, 0x08, 0xD0, 0x87, 0x30, 0x6A, 0x04,
  0x76, 0x04, 0xA0, 0x67, 0x30, 0x8D, 0x08, 0x74, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x07, 0x74, 0x08,
  0xE0, 0xE0, 0x77, 0x70, 0x30, 0xBA, 0x82, 0xE7, 0x08, 0xC0, 0x87, 0x03, 0x0B, 0xA0, 0xEE, 0x72,
  0x03, 0x0B, 0xF7, 0x40, 0x3E, 0x75, 0xE7, 0x50, 0x8C, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_polyline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_polyline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_post_add 24x24, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_24_editor_post_add_data[] PROGMEM = {
  0x77, 0x00, 0xC7, 0x73, 0xA7, 0x73, 0xA3, 0x04, 0x0D, 0xE0, 0xB2, 0x0B, 0xE0, 0xC0, 0xDF, 0x0B,
  0x20, 0xCE, 0x0C, 0xA0, 0x37, 0x4A, 0x3A, 0x75, 0xA3, 0xA2, 0x0B, 0xE0, 0xB2, 0x00, 0xB3, 0xA2,
  0x0B, 0xE0, 0xB7, 0xA7, 0x73, 0xA2, 0x0B, 0xE0, 0xB2, 0x00, 0xB3, 0xA2, 0x0B, 0xE0, 0xB2, 0xA3,
  0xA7, 0x5A, 0x3A, 0x20, 0xBE, 0x0B, 0x2A, 0x3A, 0x20, 0xBE, 0x0B, 0x2A, 0x3A, 0x75, 0xA3, 0xA0,
  0x17, 0x30, 0x1A, 0x38, 0x1D, 0xFE, 0x80, 0x6B, 0x81, 0xEF, 0xD3, 0x04, 0x0D, 0xFD, 0x0D, 0x04,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_post_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_post_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_publish 24x24, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_round_24_editor_publish_data[] PROGMEM = {
  0x0B, 0xFD, 0x00, 0xBF, 0xD0, 0xB7, 0x76, 0x00, 0x57, 0x40, 0x7A, 0x07, 0x72, 0x07, 0xC0, 0x77,
  0x07, 0xE0, 0x75, 0x07, 0xF9, 0x07, 0x30, 0x5F, 0xB0, 0x52, 0x05, 0xFB, 0x05, 0x5E, 0x71, 0xE7,
  0x1E, 0x71, 0xE7, 0x1E, 0x71, 0x0B, 0xC0, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_publish() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 18, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_publish_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_query_stats 24x24, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_24_editor_query_stats_data[] PROGMEM = {
  0x77, 0x60, 0x70, 0x27, 0x75, 0x81, 0x8F, 0x87, 0x74, 0x03, 0xA0, 0x27, 0x74, 0x81, 0xCF, 0x87,
  0x74, 0x81, 0x7F, 0xD7, 0x68, 0x1D, 0xD1, 0x28, 0x22, 0xEF, 0x47, 0x50, 0x8A, 0x0A, 0x28, 0x1B,
  0xF9, 0x70, 0x10, 0x23, 0x02, 0xA8, 0x5E, 0xF5, 0x5F, 0xE1, 0x78, 0x1D, 0xF4, 0x28, 0x7B, 0xF8,
  0x44, 0x11, 0x54, 0x70, 0x8A, 0x83, 0xE2, 0x5F, 0xD2, 0x82, 0x15, 0x51, 0x70, 0x3A, 0x86, 0xBF,
  0xDE, 0xF5, 0x08, 0xC0, 0x96, 0x83, 0xCF, 0x80, 0xBA, 0x81, 0xB0, 0x8A, 0x83, 0xAA, 0xEF, 0xA4,
  0x81, 0x6F, 0xD2, 0x83, 0x1C, 0xE2, 0x1A, 0x03, 0x28, 0x22, 0xEF, 0x32, 0x82, 0x1E, 0xF4, 0x48,
  0x31, 0x05, 0xFA, 0x48, 0x18, 0xF7, 0x28, 0x18, 0xFA, 0x78, 0x15, 0xFA, 0x48, 0x17, 0xF7, 0x28,
  0x13, 0x91, 0x78, 0x21, 0xFE, 0x23, 0x81, 0xDF, 0x47, 0x68, 0x49, 0xFE, 0x87, 0xDA, 0x01, 0x77,
  0x0A, 0xE0, 0xC0, 0x17, 0x78, 0x73, 0x78, 0x41, 0xCF, 0xC1, 0x77, 0x48, 0x21, 0xCF, 0x77, 0x75,
  0x81, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_query_stats() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_editor_query_stats_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_rectangle 24x24, 4-bit Alpha,  RLE, 20 bytes.
static const unsigned char ic_round_24_editor_rectangle_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0B, 0xD4, 0xF0, 0xDF, 0xFC, 0x81, 0xD4,
  0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_rectangle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_rectangle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_scatter_plot 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_editor_scatter_plot_data[] PROGMEM = {
  0x58, 0x28, 0xDD, 0x87, 0x40, 0x8C, 0x08, 0x73, 0x0D, 0xC0, 0xD7, 0x30, 0xDC, 0x0D, 0x73, 0x08,
  0xC0, 0x87, 0x48, 0x28, 0xDD, 0x88, 0x0C, 0x40, 0x82, 0x8D, 0xD8, 0x74, 0x08, 0xC0, 0x87, 0x30,
  0xDC, 0x0D, 0x73, 0x0D, 0xC0, 0xD5, 0x81, 0x25, 0x32, 0x08, 0xC0, 0x84, 0x07, 0xB0, 0x92, 0x82,
  0x8D, 0xD8, 0x40, 0x2D, 0x05, 0x72, 0x05, 0xD0, 0x87, 0x20, 0x3D, 0x06, 0x73, 0x09, 0xB0, 0xC7,
  0x58, 0x15, 0x86, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_scatter_plot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_scatter_plot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_schema 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_editor_schema_data[] PROGMEM = {
  0x08, 0xD0, 0x87, 0x3F, 0x73, 0xF7, 0x3F, 0x73, 0xF7, 0x30, 0x8D, 0x08, 0x75, 0x81, 0x7F, 0x77,
  0x78, 0x17, 0xF7, 0x75, 0x08, 0xD0, 0x83, 0x08, 0xD0, 0x8F, 0x38, 0x0D, 0x4F, 0x3F, 0x08, 0xD0,
  0x83, 0x08, 0xD0, 0x82, 0x81, 0x7F, 0x77, 0x78, 0x17, 0xF7, 0x75, 0x08, 0xD0, 0x87, 0x3F, 0x73,
  0xF7, 0x3F, 0x73, 0xF7, 0x30, 0x8D, 0x08, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_schema() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_editor_schema_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_score 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_24_editor_score_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0xC0, 0x22, 0x85, 0x3F, 0x2A, 0xF3, 0x8F, 0x98,
  0x90, 0xA7, 0x30, 0xF0, 0x77, 0x0C, 0xF9, 0x87, 0x73, 0x10, 0xF0, 0x40, 0x7F, 0xA1, 0x86, 0x13,
  0x7F, 0x04, 0x07, 0xFA, 0x18, 0x73, 0x7A, 0xF0, 0x77, 0x0C, 0xF9, 0x03, 0x28, 0x52, 0xF2, 0xAF,
  0x38, 0xFF, 0xC0, 0xE0, 0xDF, 0xF9, 0x81, 0xD1, 0x1E, 0x82, 0xD2, 0x2D, 0xC8, 0x2D, 0x10, 0x8D,
  0x0D, 0x02, 0x20, 0x20, 0xDA, 0x82, 0xD1, 0x07, 0xD8, 0x92, 0xD2, 0x07, 0x70, 0x2D, 0xD1, 0x07,
  0xE8, 0x12, 0x07, 0xA8, 0x47, 0x01, 0x10, 0x7F, 0x06, 0x08, 0xC0, 0x72, 0x07, 0xFF, 0x90, 0x0A,
  0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_shape_line 24x24, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_24_editor_shape_line_data[] PROGMEM = {
  0x28, 0x44, 0xBE, 0xEB, 0x47, 0x71, 0x08, 0xE0, 0x87, 0x82, 0x8D, 0xD8, 0x20, 0x4F, 0x90, 0x45,
  0x08, 0xC8, 0x18, 0x0B, 0xF9, 0x0B, 0x50, 0xDC, 0x81, 0xD0, 0xEF, 0x90, 0xE5, 0x0D, 0xC8, 0x1D,
  0x0E, 0xF9, 0x0E, 0x40, 0x10, 0xDC, 0x81, 0x80, 0xBF, 0x90, 0xB3, 0x85, 0x1C, 0xFD, 0xDD, 0x82,
  0x04, 0xF9, 0x04, 0x28, 0x31, 0xCF, 0xC1, 0x60, 0x8E, 0x08, 0x28, 0x31, 0xCF, 0xC1, 0x71, 0x84,
  0x4B, 0xEE, 0xB4, 0x28, 0x31, 0xCF, 0xC1, 0x77, 0x28, 0x31, 0xCF, 0xC1, 0x77, 0x28, 0x31, 0xCF,
  0xC1, 0x77, 0x28, 0x31, 0xCF, 0xC1, 0x77, 0x28, 0x31, 0xCF, 0xC1, 0x20, 0x40, 0xDD, 0x0D, 0x04,
  0x58, 0x31, 0xCF, 0xC1, 0x30, 0xDF, 0x0D, 0x28, 0x58, 0xDD, 0xDF, 0xC1, 0x4F, 0xA1, 0x08, 0xC0,
  0xD0, 0x15, 0xFA, 0x10, 0xDC, 0x0D, 0x6F, 0xA1, 0x0D, 0xC0, 0xD6, 0xFA, 0x10, 0x8C, 0x08, 0x6F,
  0xA2, 0x82, 0x8D, 0xD8, 0x70, 0xDF, 0x0D, 0x76, 0x04, 0x0D, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_shape_line() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_editor_shape_line_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_short_text 24x24, 4-bit Alpha,  RLE, 15 bytes.
static const unsigned char ic_round_24_editor_short_text_data[] PROGMEM = {
  0x0B, 0xFF, 0x00, 0xBF, 0xF0, 0xB7, 0x77, 0x74, 0x0B, 0xF9, 0x0B, 0x60, 0xBF, 0x90, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_short_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 19, 14), Box(0, 0, 23, 23),
      ic_round_24_editor_short_text_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_show_chart 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_editor_show_chart_data[] PROGMEM = {
  0x77, 0x38, 0x14, 0xF6, 0x77, 0x28, 0x23, 0xEF, 0x57, 0x71, 0x82, 0x2E, 0xF9, 0x77, 0x18, 0x21,
  0xDF, 0xA7, 0x18, 0x18, 0xF7, 0x58, 0x1C, 0xFB, 0x71, 0x08, 0xB0, 0x83, 0x82, 0xBF, 0xD1, 0x70,
  0x8A, 0x0B, 0xA8, 0x48, 0x09, 0xFE, 0x17, 0x08, 0xA8, 0x17, 0x07, 0xA8, 0x2C, 0xFE, 0x37, 0x08,
  0xA0, 0x73, 0x07, 0xB0, 0x47, 0x08, 0xA0, 0x75, 0x81, 0x7F, 0x57, 0x05, 0xA0, 0x77, 0x72, 0x81,
  0x5E, 0x77, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_show_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 21, 17), Box(0, 0, 23, 23),
      ic_round_24_editor_show_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_space_bar 24x24, 4-bit Alpha,  RLE, 13 bytes.
static const unsigned char ic_round_24_editor_space_bar_data[] PROGMEM = {
  0x00, 0xB7, 0x50, 0x0B, 0xA7, 0x5C, 0x75, 0xC7, 0x5F, 0xFC, 0x0B, 0xFF, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_space_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 19, 14), Box(0, 0, 23, 23),
      ic_round_24_editor_space_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_square 24x24, 4-bit Alpha,  RLE, 19 bytes.
static const unsigned char ic_round_24_editor_square_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xBF, 0x0F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D,
  0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_square() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_square_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_stacked_line_chart 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_round_24_editor_stacked_line_chart_data[] PROGMEM = {
  0x77, 0x38, 0x14, 0xF6, 0x77, 0x28, 0x23, 0xEF, 0x57, 0x71, 0x82, 0x2E, 0xF9, 0x77, 0x18, 0x21,
  0xDF, 0xA7, 0x18, 0x18, 0xF7, 0x58, 0x1C, 0xFB, 0x71, 0x08, 0xB0, 0x83, 0x82, 0xBF, 0xD1, 0x70,
  0x8A, 0x0B, 0xA8, 0x90, 0x80, 0x9F, 0xE1, 0x04, 0xF6, 0x30, 0x8A, 0x81, 0x70, 0x7A, 0x87, 0xCF,
  0xE3, 0x03, 0xEF, 0x52, 0x08, 0xA0, 0x73, 0x07, 0xB8, 0x44, 0x02, 0xEF, 0x92, 0x08, 0xA0, 0x75,
  0x86, 0x7F, 0x50, 0x1D, 0xFA, 0x20, 0x5A, 0x07, 0x28, 0x18, 0xF7, 0x58, 0x1C, 0xFB, 0x38, 0x15,
  0xE7, 0x20, 0x8B, 0x08, 0x38, 0x2B, 0xFD, 0x17, 0x08, 0xA0, 0xBA, 0x84, 0x80, 0x9F, 0xE1, 0x70,
  0x8A, 0x81, 0x70, 0x7A, 0x82, 0xCF, 0xE3, 0x70, 0x8A, 0x07, 0x30, 0x7B, 0x04, 0x70, 0x8A, 0x07,
  0x58, 0x17, 0xF5, 0x70, 0x5A, 0x07, 0x77, 0x28, 0x15, 0xE7, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_stacked_line_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_stacked_line_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_strikethrough_s 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_24_editor_strikethrough_s_data[] PROGMEM = {
  0x68, 0x57, 0xCE, 0xFD, 0x92, 0x72, 0x02, 0x0D, 0xF0, 0x57, 0x10, 0xBA, 0x82, 0xD7, 0x6A, 0xA0,
  0xE0, 0x16, 0x01, 0xA0, 0xE0, 0x13, 0x0A, 0xA0, 0x76, 0x01, 0xA0, 0xE4, 0x82, 0x37, 0x74, 0x70,
  0xDA, 0x0C, 0x03, 0x77, 0x76, 0x0B, 0xFF, 0xA0, 0x0B, 0xFF, 0xA0, 0xC7, 0x30, 0x60, 0xEA, 0x05,
  0x68, 0x27, 0xDD, 0x54, 0x08, 0xA0, 0x86, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0x87, 0x0D, 0xA8, 0x2C,
  0x65, 0x9B, 0x04, 0x70, 0x20, 0xDF, 0x09, 0x73, 0x85, 0x7B, 0xEF, 0xEA, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_strikethrough_s() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 17), Box(0, 0, 23, 23),
      ic_round_24_editor_strikethrough_s_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_subscript 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_24_editor_subscript_data[] PROGMEM = {
  0x18, 0x18, 0xD2, 0x48, 0x12, 0xE8, 0x78, 0x1B, 0xFB, 0x48, 0x1C, 0xFB, 0x70, 0x3A, 0x06, 0x20,
  0x6A, 0x03, 0x71, 0x86, 0x8F, 0xE1, 0x1E, 0xF8, 0x73, 0x84, 0xDF, 0x99, 0xFD, 0x74, 0x04, 0xC0,
  0x47, 0x50, 0xAA, 0x0A, 0x75, 0x01, 0x0E, 0xA0, 0xD0, 0x17, 0x48, 0x49, 0xFE, 0xEF, 0x97, 0x30,
  0x3A, 0x00, 0x5A, 0x03, 0x72, 0x81, 0xDF, 0xB2, 0x81, 0xBF, 0xD7, 0x10, 0x8A, 0x02, 0x20, 0x2A,
  0x08, 0x20, 0xDA, 0x0B, 0x01, 0xA0, 0x74, 0x07, 0xA0, 0x14, 0x91, 0x0D, 0x0B, 0x60, 0xB0, 0xD2,
  0x0B, 0xA0, 0xB7, 0x69, 0x77, 0x20, 0xBA, 0x0D,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_subscript() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_subscript_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_superscript 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_24_editor_superscript_data[] PROGMEM = {
  0x76, 0x0D, 0xA0, 0xB7, 0x72, 0x91, 0x81, 0x8D, 0x24, 0x81, 0x2E, 0x82, 0x0B, 0xA8, 0x3B, 0x0B,
  0xFB, 0x48, 0x1C, 0xFB, 0x29, 0x40, 0x3A, 0x06, 0x20, 0x6A, 0x03, 0x20, 0xBA, 0x0D, 0x28, 0x68,
  0xFE, 0x11, 0xEF, 0x87, 0x38, 0x4D, 0xF9, 0x9F, 0xD7, 0x40, 0x4C, 0x03, 0x75, 0x0A, 0xA0, 0xA7,
  0x50, 0x10, 0xEA, 0x0D, 0x75, 0x84, 0x9F, 0xEE, 0xF9, 0x73, 0x03, 0xA0, 0x05, 0xA0, 0x37, 0x28,
  0x1D, 0xFB, 0x28, 0x1B, 0xFD, 0x71, 0x08, 0xA0, 0x22, 0x02, 0xA0, 0x86, 0x01, 0xA0, 0x74, 0x07,
  0xA0, 0x16, 0x0D, 0x0B, 0x60, 0xB0, 0xD6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_superscript() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_superscript_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_table_chart 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_24_editor_table_chart_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x98, 0x1D, 0x4D, 0xFF, 0xB0, 0xD8, 0x0E, 0x5F, 0x80, 0xC2, 0x0D, 0x2D, 0x2F,
  0xB2, 0xD2, 0xFB, 0x2D, 0x2F, 0xB2, 0xD2, 0xFB, 0x2D, 0x2F, 0xB2, 0xD2, 0xFB, 0x2D, 0x2F, 0xB2,
  0xD2, 0xFB, 0x2D, 0x2D, 0x0D, 0xC2, 0xD2, 0xC8, 0x1D, 0x4D, 0xB2, 0xD2, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_table_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_table_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_table_rows 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_editor_table_rows_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x00, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x48,
  0x0C, 0x00, 0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x00, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0,
  0xD0, 0x48, 0x0C, 0x00, 0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x00, 0xDF, 0xFA, 0x81, 0xD4,
  0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_table_rows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_editor_table_rows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_text_decrease 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_24_editor_text_decrease_data[] PROGMEM = {
  0x58, 0x19, 0xF9, 0x77, 0x40, 0x4B, 0x04, 0x77, 0x38, 0x3A, 0xFD, 0xFA, 0x77, 0x20, 0x1A, 0x03,
  0xA0, 0x17, 0x71, 0x85, 0x6F, 0xB0, 0xBF, 0x67, 0x71, 0x85, 0xCF, 0x60, 0x6F, 0xC7, 0x70, 0x3A,
  0x81, 0x10, 0x1A, 0x03, 0x30, 0xBE, 0x0B, 0x28, 0x18, 0xFB, 0x38, 0x1B, 0xF8, 0x30, 0xBE, 0x0B,
  0x28, 0x7E, 0xFC, 0x99, 0x9C, 0xFE, 0x75, 0x04, 0xFA, 0x04, 0x74, 0x81, 0xAF, 0xB8, 0x01, 0x58,
  0x1B, 0xFA, 0x73, 0x01, 0xA0, 0x45, 0x04, 0xA0, 0x17, 0x28, 0x16, 0xFE, 0x78, 0x1E, 0xF6, 0x72,
  0x81, 0x3E, 0x67, 0x81, 0x6E, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_text_decrease() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_text_decrease_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_text_fields 24x24, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_24_editor_text_fields_data[] PROGMEM = {
  0x02, 0x0D, 0xFB, 0x0D, 0x02, 0x60, 0x6F, 0xD0, 0x66, 0x02, 0x0D, 0xFB, 0x0D, 0x02, 0x74, 0x07,
  0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA8, 0x27, 0x02, 0xDE, 0x0D, 0x02, 0x50, 0x7A,
  0x81, 0x70, 0x6F, 0x90, 0x65, 0x07, 0xA8, 0x27, 0x02, 0xDE, 0x0D, 0x02, 0x50, 0x7A, 0x07, 0x40,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x74, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x40, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x74, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x40, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x74,
  0x07, 0xA0, 0x77, 0x18, 0x22, 0xDD, 0x24, 0x82, 0x2D, 0xD2, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_text_fields() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_text_fields_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_text_increase 24x24, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_24_editor_text_increase_data[] PROGMEM = {
  0x58, 0x19, 0xF9, 0x77, 0x40, 0x4B, 0x04, 0x77, 0x38, 0x3A, 0xFD, 0xFA, 0x77, 0x20, 0x1A, 0x03,
  0xA0, 0x17, 0x00, 0xB6, 0x85, 0x6F, 0xB0, 0xBF, 0x67, 0xA6, 0x85, 0xCF, 0x60, 0x6F, 0xC7, 0xA5,
  0x03, 0xA8, 0x11, 0x01, 0xA0, 0x33, 0x0B, 0xE0, 0xB2, 0x81, 0x8F, 0xB3, 0x81, 0xBF, 0x83, 0x0B,
  0xE0, 0xB2, 0x87, 0xEF, 0xC9, 0x99, 0xCF, 0xE6, 0xA4, 0x04, 0xFA, 0x04, 0x5A, 0x48, 0x1A, 0xFB,
  0x80, 0x15, 0x81, 0xBF, 0xA5, 0x00, 0xB3, 0x01, 0xA0, 0x45, 0x04, 0xA0, 0x17, 0x28, 0x16, 0xFE,
  0x78, 0x1E, 0xF6, 0x72, 0x81, 0x3E, 0x67, 0x81, 0x6E, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_text_increase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_text_increase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_title 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_editor_title_data[] PROGMEM = {
  0x08, 0xFD, 0x08, 0x0E, 0xFD, 0x0E, 0x08, 0xFD, 0x08, 0x50, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77,
  0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A,
  0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73,
  0x82, 0x2D, 0xD2, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_title() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 18, 18), Box(0, 0, 23, 23),
      ic_round_24_editor_title_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_type_specimen 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_24_editor_type_specimen_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x4F, 0x00, 0xAF, 0x00, 0xB2,
  0xE0, 0xC2, 0x0C, 0xF9, 0x2E, 0x82, 0x62, 0x26, 0xF9, 0x2E, 0x82, 0x17, 0x71, 0xF9, 0x2D, 0x84,
  0xA0, 0xDD, 0x0A, 0xF2, 0xD8, 0x44, 0x2D, 0xD2, 0x4F, 0x2C, 0x0E, 0x60, 0xEE, 0x2C, 0x86, 0x80,
  0xAB, 0xBB, 0x08, 0xE2, 0xC0, 0x30, 0x4C, 0x04, 0x03, 0xE2, 0xC0, 0xA0, 0xDC, 0x0D, 0x0A, 0xE2,
  0xFF, 0xC2, 0x0D, 0xFF, 0x0D, 0xA2, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xA7, 0x74, 0xA7, 0x74, 0x0D,
  0xFF, 0x0B, 0x40, 0x40, 0xDF, 0xE0, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_type_specimen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_type_specimen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_vertical_align_bottom 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_24_editor_vertical_align_bottom_data[] PROGMEM = {
  0x70, 0x0B, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7,
  0x40, 0x2E, 0x02, 0x72, 0x07, 0xC0, 0x77, 0x40, 0x7A, 0x07, 0x76, 0x00, 0x78, 0x0C, 0x30, 0x0B,
  0xFF, 0x00, 0xBF, 0xF0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_vertical_align_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_vertical_align_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_vertical_align_center 24x24, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_24_editor_vertical_align_center_data[] PROGMEM = {
  0x70, 0x0B, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x40, 0x2E, 0x02, 0x72, 0x07, 0xC0, 0x77, 0x40, 0x7A,
  0x07, 0x76, 0x00, 0x78, 0x0C, 0x30, 0x0B, 0xFF, 0x00, 0xBF, 0xF0, 0xB8, 0x0C, 0x30, 0x00, 0x77,
  0x60, 0x7A, 0x07, 0x74, 0x07, 0xC0, 0x77, 0x20, 0x2E, 0x02, 0x74, 0xA7, 0x7A, 0x77, 0xA7, 0x70,
  0x0B, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_vertical_align_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_round_24_editor_vertical_align_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_vertical_align_top 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_24_editor_vertical_align_top_data[] PROGMEM = {
  0x0B, 0xFF, 0x00, 0xBF, 0xF0, 0xB8, 0x0C, 0x30, 0x00, 0x77, 0x60, 0x7A, 0x07, 0x74, 0x07, 0xC0,
  0x77, 0x20, 0x2E, 0x02, 0x74, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A,
  0x77, 0xA7, 0x70, 0x0B, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_vertical_align_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_vertical_align_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_vertical_distribute 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_round_24_editor_vertical_distribute_data[] PROGMEM = {
  0x0B, 0xFF, 0xC0, 0x0B, 0xFF, 0xC0, 0xB8, 0x09, 0xF1, 0x00, 0x28, 0x04, 0x70, 0x27, 0x30, 0xDF,
  0x90, 0xD7, 0x30, 0xDF, 0x90, 0xD7, 0x30, 0x28, 0x04, 0x70, 0x28, 0x09, 0xF1, 0x00, 0xBF, 0xFC,
  0x00, 0xBF, 0xFC, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_vertical_distribute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_editor_vertical_distribute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_editor_wrap_text 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_24_editor_wrap_text_data[] PROGMEM = {
  0x0B, 0xFF, 0x81, 0xB0, 0xBF, 0xF0, 0xB8, 0x09, 0x81, 0x00, 0xBF, 0xD8, 0x3D, 0x91, 0x0B, 0xFF,
  0x0D, 0x01, 0x76, 0x82, 0x18, 0xF9, 0x77, 0x10, 0xD0, 0xE7, 0x30, 0x24, 0x00, 0xD7, 0x20, 0x79,
  0x38, 0x28, 0xF9, 0xBC, 0x0B, 0x20, 0x7E, 0x81, 0xE1, 0xBC, 0x0B, 0x20, 0x7C, 0x81, 0xD9, 0x17,
  0x30, 0x79, 0x77, 0x20, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_editor_wrap_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_editor_wrap_text_data, Alpha4(color::Black));
  return value;
}
