#include "av.h"

using namespace roo_display;

// Image file ic_round_24_av_10k 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_24_av_10k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x5F, 0x0A, 0x20, 0x0A, 0x38, 0x53,
  0xF2, 0xAC, 0x1C, 0xB8, 0x95, 0xD7, 0x07, 0x70, 0x73, 0x0F, 0x06, 0x22, 0xED, 0x18, 0x37, 0x70,
  0xF7, 0x19, 0x30, 0xCE, 0x18, 0x37, 0x70, 0xF7, 0x19, 0x30, 0xCE, 0x18, 0x92, 0x77, 0x07, 0x30,
  0xF0, 0x62, 0x2E, 0xD8, 0x12, 0xAA, 0x38, 0x53, 0xF2, 0xAC, 0x1C, 0x80, 0x98, 0x6F, 0x0D, 0xFF,
  0xA8, 0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_10k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_10k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_1k_plus 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_24_av_1k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x87, 0x20, 0x3F, 0x92, 0xF6,
  0x5F, 0xA8, 0x92, 0xA3, 0x0F, 0x70, 0x90, 0x9F, 0x88, 0xF8, 0x27, 0x0F, 0x72, 0x84, 0x5F, 0x83,
  0x38, 0xE8, 0x27, 0x0F, 0x72, 0x84, 0x5F, 0x83, 0x38, 0xE8, 0x91, 0x70, 0xF7, 0x09, 0x09, 0xF8,
  0x8F, 0x86, 0xA2, 0xF9, 0x2F, 0x65, 0x80, 0x99, 0x2F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_1k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_1k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_1k 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_24_av_1k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x99, 0x0F, 0x81, 0x20, 0x3A, 0x83, 0x2A,
  0xC1, 0xCF, 0x90, 0xA0, 0x31, 0xA1, 0x82, 0x62, 0x2E, 0xFA, 0x07, 0x1A, 0x30, 0xCF, 0xB0, 0x71,
  0xA3, 0x0C, 0xFB, 0x07, 0x1A, 0x18, 0x26, 0x22, 0xEF, 0xA0, 0xA0, 0x2A, 0x83, 0x2A, 0xC1, 0xC8,
  0x09, 0x90, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_1k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_1k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_2k_plus 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_av_2k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x02, 0x28, 0x53, 0xF2, 0xAC,
  0x1C, 0xF9, 0x89, 0x2A, 0x73, 0x0F, 0x06, 0x22, 0xE8, 0x8E, 0x81, 0xA7, 0x31, 0x93, 0x83, 0xC8,
  0x33, 0x8D, 0x18, 0x13, 0x7A, 0x93, 0x83, 0xC8, 0x33, 0x8D, 0x18, 0x91, 0x37, 0xAF, 0x06, 0x22,
  0xE8, 0x8E, 0x03, 0x28, 0x52, 0xF2, 0xAC, 0x1C, 0x80, 0x99, 0x1F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D,
  0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_2k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_2k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_2k 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_av_2k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x0A, 0x30, 0x3A, 0x83, 0x29,
  0xC1, 0xCE, 0x82, 0xD7, 0x73, 0x1A, 0x18, 0x26, 0x22, 0xEE, 0x82, 0xE8, 0x73, 0x1A, 0x30, 0xCF,
  0x83, 0x80, 0x77, 0xAA, 0x30, 0xCF, 0x83, 0x70, 0x77, 0xAA, 0x18, 0x26, 0x22, 0xEE, 0x0A, 0x30,
  0x2A, 0x83, 0x29, 0xC1, 0xC8, 0x09, 0x87, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_2k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_2k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_3k_plus 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_av_3k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x6F, 0x0A, 0x38, 0x53, 0xF2, 0xAC,
  0x1C, 0xF8, 0x93, 0xD7, 0x73, 0x0F, 0x07, 0x22, 0xE8, 0x8E, 0x81, 0xC7, 0x31, 0x93, 0x83, 0xC8,
  0x33, 0x8D, 0x81, 0xC7, 0x31, 0x93, 0x83, 0xC8, 0x33, 0x8C, 0x89, 0x3D, 0x77, 0x30, 0xF0, 0x62,
  0x2E, 0x88, 0xD0, 0xA3, 0x85, 0x3F, 0x2A, 0xC1, 0xC8, 0x09, 0x91, 0xF0, 0xDF, 0xFA, 0x81, 0xD4,
  0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_3k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_3k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_3k 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_av_3k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x0A, 0x30, 0x3A, 0x83, 0x2A,
  0xC1, 0xCE, 0x82, 0xD7, 0x73, 0x1A, 0x18, 0x26, 0x22, 0xEF, 0x81, 0xC7, 0x31, 0xA3, 0x0C, 0xF9,
  0x81, 0xC7, 0x31, 0xA3, 0x0C, 0xF8, 0x2D, 0x77, 0x31, 0xA1, 0x82, 0x62, 0x2E, 0xE0, 0xA3, 0x03,
  0xA8, 0x32, 0xAC, 0x1C, 0x80, 0x98, 0x7F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_3k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_3k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_4k_plus 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_av_4k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x6F, 0x89, 0x1A, 0x2F, 0xA2, 0xF9,
  0x2F, 0x65, 0xF8, 0x93, 0x70, 0xF7, 0x0F, 0x70, 0x90, 0x98, 0x8D, 0x85, 0x70, 0xF7, 0x0F, 0x72,
  0x83, 0x58, 0x33, 0x8C, 0x08, 0x40, 0x20, 0x72, 0x83, 0x58, 0x33, 0x8C, 0x89, 0x3E, 0x87, 0x30,
  0xA7, 0x09, 0x09, 0x88, 0xF9, 0x86, 0xA2, 0xF9, 0x2F, 0x65, 0x80, 0x99, 0x1F, 0x0D, 0xFF, 0xA8,
  0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_4k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_4k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_4k 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_av_4k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x83, 0xA2, 0xFA, 0x2A, 0x83,
  0x2A, 0xF3, 0x8E, 0x82, 0x70, 0xF7, 0x1A, 0x18, 0x27, 0x70, 0xCE, 0x82, 0x70, 0xF7, 0x1A, 0x18,
  0x14, 0x07, 0xF0, 0x84, 0x84, 0x2F, 0x04, 0x07, 0xF8, 0x92, 0xE8, 0x73, 0x09, 0xF0, 0x77, 0x0C,
  0xFA, 0x0A, 0x02, 0xA8, 0x32, 0xAF, 0x38, 0x80, 0x98, 0x7F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_4k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_4k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_5g 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_24_av_5g_data[] PROGMEM = {
  0x0B, 0xD0, 0xB2, 0x04, 0x0D, 0xE0, 0xBE, 0x0B, 0x20, 0xDF, 0x0B, 0xA7, 0xA7, 0xA7, 0xA7, 0xD0,
  0xD0, 0x42, 0xA3, 0x0B, 0xA0, 0x0B, 0xD0, 0xD2, 0xA3, 0x0B, 0xB5, 0xA2, 0xA5, 0xA5, 0xA2, 0xA5,
  0xA0, 0xBD, 0x0D, 0x20, 0xDF, 0x0D, 0x0B, 0xC0, 0xD0, 0x42, 0x04, 0x0D, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_5g() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 16), Box(0, 0, 23, 23),
      ic_round_24_av_5g_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_5k_plus 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_av_5k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x03, 0x28, 0x52, 0xF2, 0xAC,
  0x1C, 0xF9, 0x18, 0x91, 0x37, 0xAF, 0x06, 0x22, 0xE8, 0x8E, 0x18, 0x13, 0x7A, 0x93, 0x83, 0xC8,
  0x33, 0x8D, 0x81, 0xA7, 0x31, 0x93, 0x83, 0xC8, 0x33, 0x8D, 0x89, 0x2A, 0x73, 0x0F, 0x06, 0x22,
  0xE8, 0x8E, 0x02, 0x28, 0x53, 0xF2, 0xAC, 0x1C, 0x80, 0x99, 0x1F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D,
  0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_5k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_5k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_5k 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_av_5k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x0A, 0x30, 0x2A, 0x83, 0x29,
  0xC1, 0xCE, 0x83, 0x70, 0x77, 0xAA, 0x18, 0x26, 0x22, 0xEE, 0x83, 0x70, 0x77, 0xAA, 0x30, 0xCF,
  0x82, 0xD7, 0x73, 0x1A, 0x30, 0xCF, 0x82, 0xD7, 0x73, 0x1A, 0x18, 0x26, 0x22, 0xEE, 0x0A, 0x30,
  0x3A, 0x83, 0x29, 0xC1, 0xC8, 0x09, 0x87, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_5k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_5k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_6k_plus 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_av_6k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x03, 0x28, 0x52, 0xF2, 0x9C,
  0x1C, 0xF9, 0x18, 0x91, 0x37, 0xAF, 0x06, 0x22, 0xE8, 0x8E, 0x18, 0x13, 0x7A, 0x93, 0x83, 0xC8,
  0x33, 0x8D, 0x10, 0x03, 0x19, 0x38, 0x3C, 0x83, 0x38, 0xD1, 0x89, 0x17, 0x70, 0xF0, 0x62, 0x2E,
  0x88, 0xE0, 0x32, 0x85, 0x3F, 0x29, 0xC1, 0xC8, 0x09, 0x91, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF,
  0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_6k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_6k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_6k 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_av_6k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x0A, 0x30, 0x2A, 0x83, 0x29,
  0xC1, 0xCE, 0x83, 0x70, 0x77, 0xAA, 0x18, 0x26, 0x22, 0xEE, 0x83, 0x70, 0x77, 0xAA, 0x30, 0xCF,
  0x82, 0x70, 0x73, 0x1A, 0x30, 0xCF, 0x82, 0x70, 0xF7, 0x1A, 0x18, 0x26, 0x22, 0xEE, 0x0A, 0x30,
  0x3A, 0x83, 0x29, 0xC1, 0xC8, 0x09, 0x87, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_6k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_6k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_7k_plus 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_24_av_7k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x6F, 0x0A, 0x38, 0x53, 0xF2, 0x9C,
  0x1C, 0xF8, 0x93, 0xD7, 0x70, 0x1F, 0x06, 0x22, 0xE8, 0x8F, 0x81, 0xC0, 0x69, 0x38, 0x3C, 0x83,
  0x38, 0xE8, 0x17, 0x0B, 0x93, 0x83, 0xC8, 0x33, 0x8E, 0x03, 0x1A, 0x18, 0x46, 0x22, 0xE8, 0x8F,
  0x02, 0x06, 0xA8, 0x32, 0x9C, 0x1C, 0x80, 0x99, 0x1F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_7k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_7k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_7k 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_24_av_7k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x0A, 0x30, 0x3A, 0x83, 0x29,
  0xC1, 0xCE, 0x83, 0xD7, 0x70, 0x1A, 0x18, 0x26, 0x22, 0xEF, 0x98, 0x1C, 0x06, 0xA3, 0x0C, 0xFA,
  0x81, 0x70, 0xBA, 0x30, 0xCF, 0xA0, 0x31, 0xB1, 0x82, 0x62, 0x2E, 0xF9, 0x02, 0x06, 0xB8, 0x32,
  0x9C, 0x1C, 0x80, 0x98, 0x7F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_7k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_7k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_8k_plus 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_av_8k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x03, 0x28, 0x53, 0xF2, 0x9C,
  0x1C, 0xF9, 0x18, 0x91, 0x77, 0x0F, 0x06, 0x22, 0xE7, 0x7E, 0x10, 0x03, 0x19, 0x38, 0x3C, 0x73,
  0x37, 0xD1, 0x00, 0x31, 0x93, 0x83, 0xC7, 0x33, 0x7D, 0x18, 0x91, 0x77, 0x0F, 0x06, 0x22, 0xE7,
  0x7E, 0x03, 0x28, 0x53, 0xF2, 0x9C, 0x1C, 0x80, 0x99, 0x1F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_8k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_8k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_8k 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_av_8k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x0A, 0x30, 0x3A, 0x83, 0x29,
  0xC1, 0xCE, 0x82, 0x70, 0xF7, 0x1A, 0x18, 0x26, 0x22, 0xEE, 0x82, 0x70, 0x73, 0x1A, 0x30, 0xCF,
  0x82, 0x70, 0x73, 0x1A, 0x30, 0xCF, 0x82, 0x70, 0xF7, 0x1A, 0x18, 0x26, 0x22, 0xEE, 0x0A, 0x30,
  0x3A, 0x83, 0x29, 0xC1, 0xC8, 0x09, 0x87, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_8k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_8k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_9k_plus 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_av_9k_plus_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x03, 0x28, 0x53, 0xF2, 0x9C,
  0x1C, 0xF9, 0x18, 0x91, 0x77, 0x0F, 0x06, 0x22, 0xE8, 0x8E, 0x10, 0x03, 0x19, 0x38, 0x3C, 0x83,
  0x38, 0xD8, 0x1A, 0x73, 0x19, 0x38, 0x3C, 0x83, 0x38, 0xD8, 0x92, 0xA7, 0x30, 0xF0, 0x62, 0x2E,
  0x88, 0xE0, 0x22, 0x85, 0x3F, 0x29, 0xC1, 0xC8, 0x09, 0x91, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF,
  0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_9k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_9k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_9k 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_av_9k_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x0A, 0x30, 0x3A, 0x83, 0x29,
  0xC1, 0xCE, 0x82, 0x70, 0xF7, 0x1A, 0x18, 0x26, 0x22, 0xEE, 0x82, 0x80, 0x73, 0x1A, 0x30, 0xCF,
  0x82, 0xE8, 0x73, 0x1A, 0x30, 0xCF, 0x82, 0xD7, 0x73, 0x1A, 0x18, 0x26, 0x22, 0xEE, 0x0A, 0x30,
  0x3A, 0x83, 0x29, 0xC1, 0xC8, 0x09, 0x87, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_9k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_9k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_add_to_queue 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_av_add_to_queue_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x71,
  0x00, 0xB7, 0x1C, 0x71, 0xA7, 0x1C, 0x71, 0xA7, 0x1C, 0x50, 0xBE, 0x0B, 0x5C, 0x50, 0xBE, 0x0B,
  0x5C, 0x71, 0xA7, 0x1C, 0x71, 0xA7, 0x1C, 0x71, 0x00, 0xB7, 0x1C, 0x77, 0x4C, 0x03, 0x77, 0x20,
  0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x47, 0xF9, 0x77, 0x0B, 0xE0, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_add_to_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_av_add_to_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_airplay 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_av_airplay_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77,
  0x4C, 0x03, 0x70, 0x05, 0x70, 0x3A, 0x0D, 0xC0, 0xB3, 0x07, 0xA0, 0x73, 0x0B, 0xC8, 0x1D, 0x4D,
  0xB0, 0xB2, 0x07, 0xC0, 0x72, 0x0B, 0xB0, 0xD0, 0x47, 0x07, 0xE0, 0x77, 0x60, 0x5F, 0x90, 0x57,
  0x50, 0x5F, 0x90, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_airplay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_av_airplay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_album 24x24, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_round_24_av_album_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xE8, 0x2C, 0x99, 0xCE, 0x81, 0xD0, 0x5D, 0x0E,
  0x05, 0x40, 0x50, 0xED, 0x05, 0x09, 0xD0, 0x56, 0x05, 0xD0, 0x90, 0xDC, 0x0C, 0x71, 0x0C, 0xC0,
  0xD0, 0xEC, 0x09, 0x30, 0x0B, 0x30, 0x9C, 0x00, 0xEC, 0x09, 0x30, 0x0B, 0x30, 0x9C, 0x0E, 0x0D,
  0xC0, 0xC7, 0x10, 0xCC, 0x0D, 0x09, 0xD0, 0x56, 0x05, 0xD0, 0x90, 0x5D, 0x0E, 0x05, 0x40, 0x50,
  0xED, 0x81, 0x50, 0xDE, 0x82, 0xC9, 0x9C, 0xE0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08,
  0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_album() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_album_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_art_track 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_av_art_track_data[] PROGMEM = {
  0x04, 0x0D, 0xE0, 0xD0, 0x42, 0x0B, 0xE0, 0xB0, 0xDF, 0x90, 0xD2, 0x0B, 0xE0, 0xBF, 0xB7, 0x3F,
  0xB7, 0x3F, 0xB2, 0x0B, 0xE0, 0xBD, 0x0C, 0x08, 0xB2, 0x0B, 0xE0, 0xBA, 0x84, 0xA3, 0xD2, 0x09,
  0xA7, 0x3A, 0x02, 0x40, 0x1A, 0x73, 0x0D, 0xF9, 0x0D, 0x20, 0xBE, 0x81, 0xB4, 0xDE, 0x0D, 0x04,
  0x20, 0xBE, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_art_track() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 16), Box(0, 0, 23, 23),
      ic_round_24_av_art_track_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_audio_file 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_av_audio_file_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xE0, 0x65, 0x0D, 0xF9, 0x81, 0xDF, 0x74, 0xFA, 0x82, 0x1D, 0xF7, 0x3F, 0xA1,
  0x82, 0x1D, 0xF7, 0x2F, 0xA2, 0x82, 0x1D, 0xF7, 0x1F, 0xA3, 0x82, 0x1D, 0xF6, 0xFA, 0x03, 0x38,
  0x11, 0xDE, 0x80, 0xC4, 0xF0, 0x32, 0x03, 0xFD, 0x30, 0x3F, 0xD1, 0xFD, 0x81, 0xD8, 0xA1, 0xFC,
  0x0D, 0x4F, 0xC0, 0x84, 0xFC, 0x0A, 0x30, 0x3F, 0xD8, 0x27, 0x03, 0xCF, 0xFF, 0xA0, 0xDF, 0xF8,
  0x1D, 0x4D, 0xFD, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_audio_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_av_audio_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_av_timer 24x24, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_round_24_av_av_timer_data[] PROGMEM = {
  0x71, 0x83, 0xBE, 0xD9, 0x47, 0x6D, 0x0B, 0x02, 0x58, 0x13, 0xB4, 0x3A, 0x84, 0x37, 0xEF, 0xE3,
  0x30, 0x20, 0xEA, 0x04, 0x20, 0x0B, 0x28, 0x31, 0xAF, 0xE2, 0x28, 0x1B, 0xFD, 0xA0, 0x57, 0x87,
  0xAF, 0xB0, 0x4F, 0xE0, 0x7A, 0x05, 0x78, 0x4E, 0xF4, 0x9F, 0x72, 0x07, 0xA0, 0x56, 0x84, 0x7F,
  0x9D, 0xF2, 0x30, 0x7A, 0x05, 0x58, 0x62, 0xFD, 0xEF, 0x0B, 0xB2, 0x81, 0x7F, 0xD3, 0x89, 0x0B,
  0xB0, 0xFE, 0xEF, 0x0B, 0xB3, 0x00, 0x53, 0x86, 0xBB, 0x0F, 0xED, 0xF2, 0x75, 0x84, 0x3F, 0xC9,
  0xF7, 0x75, 0x84, 0x7F, 0x94, 0xFE, 0x74, 0x86, 0x1E, 0xF3, 0x0B, 0xFA, 0x40, 0x0B, 0x48, 0x1B,
  0xFB, 0x28, 0x22, 0xEF, 0xA3, 0x00, 0xB2, 0x83, 0x1B, 0xFE, 0x13, 0x84, 0x3E, 0xFE, 0x72, 0x28,
  0x42, 0x7E, 0xFE, 0x35, 0x02, 0x0B, 0xF9, 0x0B, 0x01, 0x71, 0x86, 0x49, 0xDE, 0xED, 0x93, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_av_timer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_av_timer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_branding_watermark 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_24_av_branding_watermark_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xD8, 0x0A, 0xE7, 0xF0, 0x37, 0x03, 0xFE, 0x72,
  0xFE, 0x72, 0xFE, 0x72, 0xFE, 0x72, 0xFE, 0x03, 0x70, 0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF,
  0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_branding_watermark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_av_branding_watermark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_call_to_action 24x24, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_round_24_av_call_to_action_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xD8, 0x0B, 0xE0, 0xF0, 0x37, 0x72, 0x03, 0xC7,
  0x74, 0xC0, 0x37, 0x72, 0x03, 0xA0, 0xDF, 0xFE, 0x81, 0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_call_to_action() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_av_call_to_action_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_closed_caption_disabled 24x24, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_24_av_closed_caption_disabled_data[] PROGMEM = {
  0x10, 0x90, 0x67, 0x73, 0x01, 0xA0, 0x72, 0x0A, 0xFC, 0x82, 0xD4, 0x05, 0xA0, 0x72, 0x0A, 0xFC,
  0x0D, 0x2B, 0x07, 0x20, 0xAF, 0xC2, 0xC0, 0x72, 0x0A, 0xFB, 0x2D, 0x07, 0x20, 0xAF, 0xA2, 0xB0,
  0x7A, 0x07, 0x20, 0xA0, 0x33, 0x03, 0xB2, 0xB1, 0x08, 0xA0, 0x73, 0x82, 0x37, 0x51, 0xB2, 0xB1,
  0x07, 0xB0, 0x72, 0x06, 0xE2, 0xB1, 0x07, 0xC0, 0x72, 0x0A, 0xD2, 0xB1, 0x82, 0x37, 0x55, 0xA0,
  0x72, 0x04, 0x01, 0xB2, 0xB0, 0x33, 0x03, 0xB0, 0x72, 0x02, 0xB2, 0xFD, 0x07, 0x20, 0xAA, 0x2F,
  0xE0, 0x72, 0x0A, 0x92, 0xFF, 0x07, 0x20, 0xA2, 0x0D, 0xFF, 0x07, 0x40, 0x40, 0xDF, 0xF0, 0x77,
  0x73, 0x05, 0xA0, 0x67, 0x73, 0x81, 0x5F, 0x97, 0x74, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_closed_caption_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_av_closed_caption_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_closed_caption_off 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_24_av_closed_caption_off_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xE5, 0xF0, 0x33, 0x03, 0xA0, 0x33, 0x03,
  0xE1, 0x82, 0x37, 0x51, 0xA1, 0x82, 0x37, 0x51, 0xE1, 0x07, 0xD1, 0x07, 0xFA, 0x10, 0x7D, 0x10,
  0x7F, 0xA1, 0x82, 0x37, 0x51, 0xA1, 0x82, 0x37, 0x51, 0xE0, 0x33, 0x03, 0xA0, 0x33, 0x03, 0x80,
  0xE5, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_closed_caption_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_av_closed_caption_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_closed_caption 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_24_av_closed_caption_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xE5, 0xF0, 0x33, 0x03, 0xA0, 0x33, 0x03,
  0xE1, 0x82, 0x37, 0x51, 0xA1, 0x82, 0x37, 0x51, 0xE1, 0x07, 0xD1, 0x07, 0xFA, 0x10, 0x7D, 0x10,
  0x7F, 0xA1, 0x82, 0x37, 0x51, 0xA1, 0x82, 0x37, 0x51, 0xE0, 0x33, 0x03, 0xA0, 0x33, 0x03, 0x80,
  0xE5, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_closed_caption() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_av_closed_caption_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_control_camera 24x24, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_round_24_av_control_camera_data[] PROGMEM = {
  0x72, 0x00, 0x57, 0x73, 0x07, 0xA0, 0x77, 0x71, 0x07, 0xC0, 0x77, 0x78, 0x4E, 0xFD, 0xDF, 0xE7,
  0x78, 0x47, 0xA2, 0x2A, 0x78, 0x0D, 0x50, 0x81, 0x7F, 0x73, 0x82, 0x8D, 0xD8, 0x38, 0x17, 0xF7,
  0x30, 0x7A, 0x0A, 0x20, 0x8C, 0x08, 0x20, 0xAA, 0x81, 0x70, 0x5A, 0x0D, 0x02, 0x20, 0xDC, 0x0D,
  0x20, 0x20, 0xDA, 0x00, 0x5A, 0x0D, 0x02, 0x20, 0xDC, 0x0D, 0x20, 0x20, 0xDA, 0x81, 0x50, 0x7A,
  0x0A, 0x20, 0x8C, 0x08, 0x20, 0xAA, 0x07, 0x38, 0x17, 0xF7, 0x38, 0x28, 0xDD, 0x83, 0x81, 0x7F,
  0x78, 0x0D, 0x50, 0x84, 0x7A, 0x22, 0xA7, 0x77, 0x82, 0xEF, 0xDD, 0xA7, 0x70, 0x7C, 0x07, 0x77,
  0x10, 0x7A, 0x07, 0x77, 0x30, 0x05, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_control_camera() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_control_camera_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_equalizer 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_24_av_equalizer_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x50, 0xDA, 0x0D, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x28, 0x24, 0xDD,
  0x46, 0xC2, 0x0D, 0xA0, 0xD6, 0xC2, 0xC8, 0x24, 0xDD, 0x42, 0xC2, 0xC0, 0xDA, 0x0D, 0x2C, 0x2F,
  0x92, 0xC2, 0xF9, 0x2C, 0x2F, 0x92, 0xC2, 0xF9, 0x2C, 0x2C, 0x0D, 0xA0, 0xD2, 0x0D, 0xA0, 0xD2,
  0x0D, 0xA8, 0x3D, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x42, 0x82, 0x4D, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_equalizer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_round_24_av_equalizer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_explicit 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_24_av_explicit_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xC6, 0xF0, 0x34, 0x03, 0xFD, 0x50, 0x3F,
  0xD2, 0xFF, 0xA2, 0xFF, 0xA5, 0x03, 0xFD, 0x50, 0x3F, 0xD2, 0xFF, 0xA2, 0xFF, 0xA5, 0x03, 0xFD,
  0x03, 0x40, 0x38, 0x0C, 0x6F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_explicit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_explicit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_fast_forward 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_av_fast_forward_data[] PROGMEM = {
  0x81, 0xCD, 0x36, 0x81, 0xCD, 0x35, 0xB0, 0x85, 0xB0, 0x84, 0xC0, 0xC0, 0x23, 0xC0, 0xC0, 0x22,
  0xD0, 0xE0, 0x62, 0xD0, 0xE0, 0x61, 0xF0, 0x81, 0xF0, 0x8F, 0x08, 0x1F, 0x08, 0xD0, 0xE0, 0x62,
  0xD0, 0xE0, 0x61, 0xC0, 0xC0, 0x23, 0xC0, 0xC0, 0x22, 0xB0, 0x85, 0xB0, 0x84, 0x81, 0xCD, 0x36,
  0x81, 0xCD, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_fast_forward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 20, 16), Box(0, 0, 23, 23),
      ic_round_24_av_fast_forward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_fast_rewind 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_av_fast_rewind_data[] PROGMEM = {
  0x58, 0x13, 0xDC, 0x68, 0x13, 0xDC, 0x40, 0x8B, 0x50, 0x8B, 0x20, 0x20, 0xCC, 0x30, 0x20, 0xCC,
  0x10, 0x60, 0xED, 0x20, 0x60, 0xED, 0x08, 0xF1, 0x08, 0xF0, 0x8F, 0x10, 0x8F, 0x10, 0x60, 0xED,
  0x20, 0x60, 0xED, 0x20, 0x20, 0xCC, 0x30, 0x20, 0xCC, 0x40, 0x8B, 0x50, 0x8B, 0x58, 0x13, 0xDC,
  0x68, 0x13, 0xDC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_fast_rewind() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 19, 16), Box(0, 0, 23, 23),
      ic_round_24_av_fast_rewind_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_featured_play_list 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_24_av_featured_play_list_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x70, 0x3F, 0xE0, 0x37, 0x03, 0x80,
  0xE5, 0xF0, 0x37, 0x03, 0xFE, 0x03, 0x70, 0x38, 0x0A, 0xE7, 0xF0, 0xDF, 0xFE, 0x81, 0xD4, 0xDF,
  0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_featured_play_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_av_featured_play_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_featured_video 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_24_av_featured_video_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x70, 0x3F, 0xE7, 0x2F, 0xE7, 0x2F,
  0xE7, 0x2F, 0xE7, 0x2F, 0xE7, 0x2F, 0xE0, 0x37, 0x03, 0x80, 0xAC, 0x1F, 0x0D, 0xFF, 0xE8, 0x1D,
  0x4D, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_featured_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_av_featured_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_fiber_dvr 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_24_av_fiber_dvr_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xD8, 0x09, 0xA6, 0xF0, 0x13, 0x89, 0x07, 0xFB,
  0x2E, 0xB1, 0xEF, 0x13, 0x07, 0xC1, 0x89, 0x03, 0x73, 0x0F, 0xC0, 0xA6, 0x1A, 0x18, 0x13, 0x73,
  0x1C, 0x18, 0x17, 0xF7, 0x1A, 0x82, 0x16, 0x25, 0xA1, 0x81, 0x37, 0x31, 0xC1, 0x81, 0x7F, 0x71,
  0xA0, 0x62, 0x0A, 0xA4, 0x07, 0xC1, 0x81, 0x37, 0x31, 0xA0, 0xA2, 0x0E, 0xA1, 0x82, 0x7D, 0x09,
  0xC0, 0x13, 0x07, 0xA8, 0x1E, 0x25, 0xB8, 0x32, 0x9F, 0x44, 0xFF, 0xE0, 0xE0, 0xC8, 0x09, 0x80,
  0xF0, 0xDF, 0xFE, 0x81, 0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_fiber_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_av_fiber_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_fiber_manual_record 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_24_av_fiber_manual_record_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x50, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x81,
  0x90, 0x2F, 0xF0, 0x20, 0x8F, 0xF0, 0x80, 0xCF, 0xF0, 0xC0, 0xEF, 0xF0, 0x0E, 0xFF, 0x0E, 0x0C,
  0xFF, 0x0C, 0x08, 0xFF, 0x08, 0x02, 0xFF, 0x81, 0x20, 0x9F, 0xD0, 0x93, 0x0B, 0xFB, 0x0B, 0x50,
  0x9F, 0x90, 0x97, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_fiber_manual_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_round_24_av_fiber_manual_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_fiber_new 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_24_av_fiber_new_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0F, 0x1F, 0x85, 0xA1, 0xDF, 0x59, 0xA3,
  0x81, 0x99, 0x5B, 0x05, 0x09, 0xA8, 0xA0, 0x70, 0x3F, 0x37, 0x70, 0xBB, 0xE7, 0x4E, 0x1E, 0x38,
  0xA8, 0xA0, 0x71, 0x07, 0x37, 0x70, 0x55, 0xC7, 0x4D, 0x0D, 0x38, 0xA8, 0xA0, 0x73, 0x70, 0x17,
  0x70, 0x55, 0xC7, 0x4D, 0x0D, 0x38, 0xA8, 0xA0, 0x73, 0xF3, 0x07, 0x70, 0xBB, 0xE7, 0x26, 0x06,
  0x18, 0xA8, 0x59, 0x5F, 0xD1, 0xAA, 0x30, 0x0A, 0x50, 0xA8, 0x0F, 0x1F, 0x0D, 0xFF, 0xC8, 0x1D,
  0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_fiber_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_fiber_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_fiber_pin 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_24_av_fiber_pin_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0F, 0x2F, 0x03, 0x30, 0x7A, 0x02, 0x0A,
  0xA8, 0x33, 0x6F, 0xC2, 0xC1, 0x81, 0x37, 0x31, 0xA1, 0x07, 0xA2, 0x0A, 0x0B, 0x1C, 0x18, 0x13,
  0x73, 0x1A, 0x10, 0x7A, 0x18, 0x11, 0x19, 0x1C, 0x40, 0x7A, 0x10, 0x7A, 0x18, 0x19, 0x11, 0x1C,
  0x10, 0x7D, 0x10, 0x7A, 0x10, 0x0B, 0x2C, 0x02, 0x0A, 0xD0, 0x20, 0xAA, 0x83, 0x2C, 0xF7, 0x28,
  0x0F, 0x2F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_fiber_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_fiber_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_fiber_smart_record 24x24, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_24_av_fiber_smart_record_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x24, 0x03, 0x02, 0x70, 0x9F, 0x90, 0x93, 0x81, 0xEF, 0x75, 0x0B,
  0xFB, 0x0B, 0x20, 0x7A, 0x0A, 0x30, 0x9F, 0xD0, 0x92, 0x84, 0x3E, 0xF8, 0x02, 0xFF, 0x02, 0x20,
  0x3A, 0x01, 0x08, 0xFF, 0x08, 0x38, 0x29, 0xF8, 0xCF, 0xF0, 0xC3, 0x82, 0x3F, 0xCE, 0xFF, 0x0E,
  0x38, 0x21, 0xFE, 0xEF, 0xF0, 0xE3, 0x82, 0x1F, 0xEC, 0xFF, 0x0C, 0x38, 0x23, 0xFC, 0x8F, 0xF0,
  0x83, 0x82, 0x9F, 0x82, 0xFF, 0x02, 0x20, 0x3A, 0x81, 0x10, 0x9F, 0xD0, 0x92, 0x82, 0x3E, 0xF8,
  0x30, 0xBF, 0xB0, 0xB2, 0x07, 0xA0, 0xA5, 0x09, 0xF9, 0x09, 0x38, 0x1E, 0xF7, 0x78, 0x62, 0x8C,
  0xEE, 0xC8, 0x24, 0x03, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_fiber_smart_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_av_fiber_smart_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_forward_10 24x24, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_round_24_av_forward_10_data[] PROGMEM = {
  0x71, 0x02, 0x77, 0x19, 0x07, 0x77, 0xA0, 0x77, 0x6B, 0x07, 0x71, 0x82, 0x28, 0xCE, 0xC0, 0x76,
  0x08, 0xF9, 0x07, 0x50, 0xBA, 0x08, 0x03, 0x1B, 0x07, 0x58, 0x28, 0xFE, 0x23, 0xA0, 0x75, 0x02,
  0xA0, 0x24, 0x90, 0x76, 0x81, 0x8F, 0x85, 0x02, 0x78, 0x1C, 0xF3, 0x30, 0x12, 0x03, 0x01, 0x50,
  0xE9, 0x38, 0x4A, 0xD0, 0x78, 0xC5, 0x0E, 0x94, 0x84, 0xD0, 0xA2, 0xA2, 0x28, 0x3C, 0xAC, 0xF3,
  0x38, 0x93, 0xD0, 0xA2, 0xA2, 0x03, 0xFC, 0x8F, 0x83, 0x83, 0xD0, 0x4B, 0xB2, 0x82, 0x8F, 0x82,
  0xA0, 0x27, 0x10, 0x2A, 0x84, 0x20, 0x8F, 0xD2, 0x68, 0x22, 0xDF, 0x83, 0x83, 0xCF, 0xE9, 0x32,
  0x03, 0x08, 0xA0, 0xB5, 0x09, 0xF9, 0x08, 0x78, 0x62, 0x8C, 0xEE, 0xC8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_forward_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_av_forward_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_forward_30 24x24, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_round_24_av_forward_30_data[] PROGMEM = {
  0x71, 0x02, 0x77, 0x19, 0x07, 0x77, 0xA0, 0x77, 0x6B, 0x07, 0x71, 0x82, 0x28, 0xCE, 0xC0, 0x76,
  0x08, 0xF9, 0x07, 0x50, 0xBA, 0x08, 0x03, 0x1B, 0x07, 0x58, 0x28, 0xFE, 0x23, 0xA0, 0x75, 0x02,
  0xA0, 0x24, 0x90, 0x76, 0x81, 0x8F, 0x85, 0x02, 0x78, 0x1C, 0xF3, 0x20, 0x20, 0x32, 0x03, 0x02,
  0x50, 0xE9, 0x28, 0x63, 0xAA, 0x55, 0x9C, 0x14, 0x0E, 0x93, 0x85, 0x3B, 0x38, 0x48, 0x42, 0x83,
  0xCA, 0xCF, 0x32, 0x8A, 0x41, 0x76, 0x84, 0x84, 0x03, 0xFC, 0x8F, 0x80, 0x2C, 0xB4, 0x3B, 0xC2,
  0x82, 0x8F, 0x82, 0xA0, 0x27, 0x10, 0x2A, 0x84, 0x20, 0x8F, 0xD2, 0x68, 0x22, 0xDF, 0x83, 0x83,
  0xCF, 0xE9, 0x32, 0x03, 0x08, 0xA0, 0xB5, 0x09, 0xF9, 0x08, 0x78, 0x62, 0x8C, 0xEE, 0xC8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_forward_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_av_forward_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_forward_5 24x24, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_round_24_av_forward_5_data[] PROGMEM = {
  0x71, 0x02, 0x77, 0x19, 0x06, 0x77, 0xA0, 0x67, 0x6B, 0x06, 0x71, 0x82, 0x38, 0xDE, 0xC0, 0x66,
  0x09, 0xF9, 0x06, 0x50, 0xBA, 0x81, 0x83, 0x1B, 0x06, 0x58, 0x29, 0xFD, 0x23, 0xA0, 0x65, 0x82,
  0x3F, 0xE2, 0x49, 0x06, 0x68, 0x19, 0xF8, 0x50, 0x27, 0x81, 0xDF, 0x24, 0x81, 0x33, 0x16, 0xA4,
  0x82, 0x2C, 0x72, 0x6A, 0x48, 0x24, 0xCA, 0x14, 0x83, 0xC9, 0xDF, 0x24, 0x81, 0x17, 0x53, 0x84,
  0x4F, 0xB9, 0xF8, 0x38, 0x23, 0xCC, 0x23, 0x85, 0x9F, 0x83, 0xFE, 0x27, 0x10, 0x3A, 0x84, 0x10,
  0x9F, 0xD2, 0x68, 0x23, 0xEF, 0x83, 0x83, 0xCF, 0xE8, 0x32, 0x03, 0x09, 0xA0, 0xA5, 0x09, 0xF9,
  0x08, 0x78, 0x62, 0x8D, 0xEE, 0xC8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_forward_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_av_forward_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_games 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_24_av_games_data[] PROGMEM = {
  0x70, 0xBC, 0x0B, 0x77, 0xE7, 0x7E, 0x77, 0xE7, 0x7E, 0x77, 0x0D, 0xC0, 0xD7, 0x70, 0x10, 0xDA,
  0x0D, 0x01, 0x70, 0xBC, 0x89, 0x0D, 0x10, 0x1D, 0xD1, 0x01, 0xDC, 0x0B, 0xE8, 0x6D, 0x10, 0x11,
  0x01, 0xDF, 0xE0, 0xD0, 0x12, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x20, 0x10, 0xDF, 0xE8, 0x6D, 0x10,
  0x11, 0x02, 0xDE, 0x0B, 0xC8, 0x90, 0xD1, 0x01, 0xDD, 0x10, 0x2D, 0xC0, 0xC7, 0x01, 0x0D, 0xA0,
  0xD0, 0x17, 0x70, 0xDC, 0x0D, 0x77, 0xE7, 0x7E, 0x77, 0xE7, 0x7E, 0x77, 0x0B, 0xC0, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_games() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_games_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_hd 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_24_av_hd_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0x98, 0x7F, 0x83, 0x2A, 0xFA, 0x2A, 0x01,
  0x30, 0x3E, 0x18, 0x17, 0xF7, 0x1A, 0x18, 0x13, 0x73, 0x1E, 0x18, 0x13, 0x73, 0x1A, 0x18, 0x17,
  0xF7, 0x1E, 0x5A, 0x18, 0x17, 0xF7, 0x1E, 0x18, 0x17, 0xF7, 0x1A, 0x18, 0x13, 0x73, 0x1E, 0x83,
  0x2A, 0xFA, 0x2A, 0x01, 0x30, 0x38, 0x09, 0x87, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_hd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_hd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_hearing_disabled 24x24, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_round_24_av_hearing_disabled_data[] PROGMEM = {
  0x77, 0x20, 0x30, 0x17, 0x86, 0x18, 0xCF, 0xEC, 0x81, 0x28, 0x12, 0xFC, 0x30, 0x90, 0x62, 0x09,
  0xE0, 0xE0, 0x52, 0x83, 0xDF, 0x70, 0x1A, 0x07, 0x28, 0x47, 0x31, 0x03, 0xAA, 0x83, 0x50, 0x3F,
  0xE2, 0x05, 0xA0, 0x77, 0x86, 0x6F, 0xE1, 0x0B, 0xF6, 0x20, 0x9A, 0x07, 0x20, 0x30, 0x63, 0x85,
  0xAF, 0x80, 0x5F, 0xA2, 0x0C, 0xB0, 0x72, 0x0A, 0x0D, 0x28, 0x53, 0xFC, 0x02, 0xFD, 0x28, 0x1A,
  0xC5, 0xA0, 0x72, 0x0A, 0x06, 0x29, 0x0E, 0x29, 0x0E, 0x50, 0x5A, 0x07, 0x28, 0x32, 0x01, 0xFE,
  0x29, 0x0E, 0x60, 0x5A, 0x07, 0x38, 0x54, 0xFC, 0x02, 0xFD, 0x70, 0x5A, 0x07, 0x28, 0x57, 0xF7,
  0x05, 0xFA, 0x71, 0x05, 0xA0, 0x72, 0x84, 0x91, 0x0B, 0xF6, 0x72, 0x05, 0xA0, 0x73, 0x81, 0x3F,
  0xE7, 0x40, 0x8A, 0x07, 0x28, 0x18, 0xF7, 0x73, 0x04, 0xC0, 0x72, 0x07, 0x73, 0x83, 0x1E, 0xF8,
  0x5A, 0x07, 0x75, 0x81, 0x8F, 0xA2, 0x05, 0xA0, 0x75, 0x81, 0x9D, 0x13, 0x81, 0xEF, 0x33, 0x05,
  0xA0, 0x74, 0x86, 0xAF, 0xA1, 0x1B, 0xFB, 0x50, 0x5A, 0x07, 0x30, 0x20, 0xEC, 0x0E, 0x02, 0x60,
  0x5A, 0x06, 0x38, 0x42, 0xAE, 0xEA, 0x27, 0x18, 0x15, 0xF9, 0x77, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_hearing_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_av_hearing_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_hearing 24x24, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_round_24_av_hearing_data[] PROGMEM = {
  0x20, 0x10, 0x37, 0x72, 0x81, 0xCF, 0x22, 0x86, 0x18, 0xCE, 0xEC, 0x81, 0x48, 0x17, 0xFD, 0x20,
  0x50, 0xEE, 0x0E, 0x05, 0x38, 0x3E, 0xF3, 0x05, 0xA8, 0x4A, 0x30, 0x14, 0xBA, 0x89, 0x05, 0x06,
  0xFB, 0x01, 0xEF, 0x66, 0x89, 0x17, 0xFE, 0x1A, 0xF5, 0x08, 0xFA, 0x30, 0x06, 0x38, 0x90, 0xBF,
  0x8D, 0xF2, 0x0C, 0xF3, 0x20, 0xDA, 0x0D, 0x28, 0x24, 0xFC, 0xE9, 0x20, 0xE9, 0x20, 0x6C, 0x06,
  0x28, 0x1D, 0xBE, 0x92, 0x83, 0xEF, 0x10, 0x6C, 0x06, 0x48, 0x5D, 0xF2, 0x0C, 0xF3, 0x20, 0xDA,
  0x0D, 0x58, 0x5A, 0xF5, 0x07, 0xF9, 0x30, 0x06, 0x68, 0x36, 0xFB, 0x01, 0xA0, 0x37, 0x48, 0x6E,
  0xF3, 0x08, 0xFD, 0x27, 0x38, 0x17, 0xFD, 0x28, 0x2B, 0xFE, 0x37, 0x38, 0x1C, 0xF2, 0x20, 0xAA,
  0x04, 0x72, 0x01, 0x03, 0x48, 0x28, 0xFE, 0x17, 0x71, 0x81, 0xAF, 0x87, 0x71, 0x81, 0x3F, 0xE3,
  0x81, 0x1D, 0xB7, 0x38, 0x6B, 0xFA, 0x11, 0xAF, 0xA7, 0x30, 0x20, 0xEC, 0x0E, 0x02, 0x74, 0x84,
  0x2A, 0xEE, 0xA2, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_hearing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_av_hearing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_high_quality 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_av_high_quality_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xE5, 0xF8, 0x32, 0xAF, 0xA2, 0xA0, 0x33,
  0x03, 0xE1, 0x81, 0x7F, 0x71, 0xA1, 0x81, 0x37, 0x31, 0xE1, 0x81, 0x37, 0x31, 0xA1, 0x81, 0x7F,
  0x71, 0xE5, 0xA1, 0x81, 0x7F, 0x71, 0xE1, 0x81, 0x7F, 0x71, 0xA1, 0x81, 0x37, 0x31, 0xE8, 0x32,
  0xAF, 0xA2, 0xA0, 0x33, 0x03, 0xFF, 0x81, 0xB0, 0xBF, 0xFA, 0x09, 0xFF, 0xFA, 0x0D, 0xFF, 0xA8,
  0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_high_quality() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_av_high_quality_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_interpreter_mode 24x24, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_round_24_av_interpreter_mode_data[] PROGMEM = {
  0x58, 0x92, 0x1A, 0xDD, 0x10, 0x1A, 0xDD, 0xA1, 0x73, 0x01, 0x0E, 0xA8, 0x28, 0x01, 0xEC, 0x0E,
  0x01, 0x72, 0x0A, 0xB8, 0x13, 0x0A, 0xE0, 0xA7, 0x20, 0xDB, 0x20, 0xDE, 0x0D, 0x72, 0x0D, 0xB2,
  0x0D, 0xE0, 0xD7, 0x20, 0xAB, 0x81, 0x30, 0xAE, 0x0A, 0x72, 0x01, 0x0E, 0xA8, 0x28, 0x01, 0xEC,
  0x0E, 0x01, 0x73, 0x89, 0x61, 0xAD, 0xD1, 0x01, 0xAD, 0xDA, 0x10, 0x8E, 0x87, 0x76, 0xB5, 0x81,
  0x37, 0x63, 0x84, 0x38, 0xBD, 0xFE, 0x3B, 0x38, 0x25, 0xCF, 0xC2, 0x05, 0x0C, 0xD0, 0x93, 0xB2,
  0x06, 0xB8, 0x15, 0x06, 0xF8, 0x90, 0x80, 0xC1, 0xDF, 0xD1, 0xCD, 0xB8, 0x11, 0x0D, 0xF8, 0x79,
  0x09, 0x82, 0x72, 0x89, 0xC2, 0xF9, 0x87, 0xE0, 0x1C, 0xB8, 0xBC, 0x1C, 0x2F, 0xA0, 0x82, 0x81,
  0x4F, 0x42, 0xC2, 0xFB, 0x08, 0x20, 0xD3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_interpreter_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_av_interpreter_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_library_add_check 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_24_av_library_add_check_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x4F, 0xFA, 0x00, 0xB2, 0xFB,
  0x81, 0xE8, 0xDD, 0x2F, 0xA8, 0x2E, 0x20, 0x8D, 0x2F, 0x98, 0x3E, 0x20, 0x2E, 0xD2, 0xB8, 0x7E,
  0x9E, 0xFE, 0x20, 0x2E, 0xE2, 0xB8, 0x67, 0x03, 0xD3, 0x02, 0xEF, 0x2B, 0x0D, 0x01, 0x30, 0x20,
  0xEF, 0x92, 0xC8, 0x3D, 0x10, 0x2E, 0xFA, 0x2D, 0x81, 0xD7, 0xEF, 0xB2, 0xFF, 0xC2, 0xFF, 0xC2,
  0x0D, 0xFF, 0x0D, 0xA2, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xA7, 0x74, 0xA0, 0x37, 0x73, 0x0D, 0xFF,
  0x0B, 0x40, 0x40, 0xDF, 0xE0, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_library_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_library_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_library_add 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_av_library_add_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x4F, 0x00, 0x3F, 0x00, 0xB2,
  0xF2, 0xFA, 0x2F, 0x2F, 0xA2, 0xF2, 0xFA, 0x2B, 0x03, 0x71, 0x03, 0xD2, 0xB0, 0x37, 0x10, 0x3D,
  0x2F, 0x2F, 0xA2, 0xF2, 0xFA, 0x2F, 0x2F, 0xA2, 0xF0, 0x03, 0xFA, 0x2F, 0xFC, 0x20, 0xDF, 0xF0,
  0xDA, 0x20, 0x40, 0xDF, 0xD0, 0xD0, 0x4A, 0x77, 0x4A, 0x03, 0x77, 0x30, 0xDF, 0xF0, 0xB4, 0x04,
  0x0D, 0xFE, 0x0B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_library_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_library_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_library_books 24x24, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_24_av_library_books_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x4B, 0x03, 0x71, 0x03, 0xB0,
  0x0B, 0x2B, 0x03, 0x71, 0x03, 0xD2, 0xFF, 0xC2, 0xFF, 0xC2, 0xB0, 0x37, 0x10, 0x3D, 0x2B, 0x03,
  0x71, 0x03, 0xD2, 0xFF, 0xC2, 0xFF, 0xC2, 0xB0, 0x34, 0x03, 0xFA, 0x2B, 0x03, 0x40, 0x3F, 0xA2,
  0xFF, 0xC2, 0x0D, 0xFF, 0x0D, 0xA2, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xA7, 0x74, 0xA0, 0x37, 0x73,
  0x0D, 0xFF, 0x0B, 0x40, 0x40, 0xDF, 0xE0, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_library_books() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_library_books_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_library_music 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_24_av_library_music_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x4F, 0x90, 0x32, 0x03, 0xC0,
  0x0B, 0x2F, 0x93, 0x03, 0xE2, 0xF9, 0x1F, 0xA2, 0xF9, 0x1F, 0xA2, 0xF9, 0x1F, 0xA2, 0xC8, 0x2D,
  0x30, 0x41, 0xFA, 0x2C, 0x03, 0x4F, 0xA2, 0xC0, 0x14, 0xFA, 0x2C, 0x04, 0x30, 0x4F, 0xA2, 0xC8,
  0x3D, 0x41, 0x4D, 0xFA, 0x2F, 0xFC, 0x20, 0xDF, 0xF0, 0xDA, 0x20, 0x40, 0xDF, 0xD0, 0xD0, 0x4A,
  0x77, 0x4A, 0x03, 0x77, 0x30, 0xDF, 0xF0, 0xB4, 0x04, 0x0D, 0xFE, 0x0B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_library_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_library_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_loop 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_24_av_loop_data[] PROGMEM = {
  0x70, 0x27, 0x70, 0x79, 0x76, 0x07, 0xA7, 0x50, 0x7B, 0x82, 0xEC, 0x82, 0x71, 0x07, 0xF0, 0x97,
  0x10, 0x7A, 0x10, 0x30, 0x8A, 0x0B, 0x71, 0x07, 0x93, 0x86, 0x2D, 0xF9, 0x01, 0x71, 0x40, 0x24,
  0x02, 0xA8, 0x22, 0x8F, 0x67, 0x38, 0x48, 0xF8, 0xCF, 0x37, 0x38, 0x23, 0xFC, 0xE9, 0x75, 0x90,
  0x0E, 0x97, 0x59, 0x82, 0xEC, 0xF3, 0x73, 0x84, 0x3F, 0xC8, 0xF8, 0x73, 0x82, 0x6F, 0x82, 0xA0,
  0x24, 0x02, 0x48, 0x61, 0x71, 0x09, 0xFD, 0x23, 0x90, 0x77, 0x10, 0xBA, 0x08, 0x03, 0x1A, 0x07,
  0x71, 0x09, 0xF0, 0x77, 0x18, 0x22, 0x8C, 0xEB, 0x07, 0x75, 0xA0, 0x77, 0x69, 0x07, 0x77, 0x02,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_loop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_round_24_av_loop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_lyrics 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_24_av_lyrics_data[] PROGMEM = {
  0x77, 0x4C, 0x04, 0x0D, 0xFC, 0x0D, 0x04, 0x3C, 0x0D, 0xFE, 0x0D, 0x3A, 0x2F, 0xF0, 0xB3, 0xA2,
  0xFE, 0x08, 0x4A, 0x2C, 0x79, 0x0B, 0x28, 0x18, 0xDE, 0xA2, 0xC7, 0x98, 0x14, 0x08, 0xD2, 0xFD,
  0x81, 0x10, 0xDD, 0x2C, 0x79, 0x81, 0x10, 0xDC, 0x0D, 0x2C, 0x79, 0x81, 0x40, 0x8C, 0x08, 0x2F,
  0xD0, 0xB2, 0x82, 0x8D, 0xD8, 0x3C, 0x4D, 0x07, 0x71, 0xC4, 0xE0, 0xB7, 0xFF, 0x97, 0xFF, 0x97,
  0xFF, 0x0D, 0x7F, 0xE0, 0xD0, 0x47, 0xB0, 0x77, 0x74, 0xA0, 0x77, 0x75, 0x90, 0x77, 0x76, 0x07,
  0x77, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_lyrics() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 23, 21), Box(0, 0, 23, 23),
      ic_round_24_av_lyrics_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_mic_none 24x24, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_24_av_mic_none_data[] PROGMEM = {
  0x58, 0x28, 0xDD, 0x87, 0x20, 0x8C, 0x08, 0x71, 0x84, 0xDF, 0x33, 0xFD, 0x71, 0xA2, 0xA7, 0x1A,
  0x2A, 0x71, 0xA2, 0xA7, 0x1A, 0x2A, 0x71, 0xA2, 0xA7, 0x1A, 0x2A, 0x40, 0xA0, 0xC2, 0x84, 0xDF,
  0x33, 0xFD, 0x28, 0x5C, 0xAC, 0xF4, 0x08, 0xC8, 0x68, 0x04, 0xFC, 0x7F, 0xB2, 0x82, 0x8D, 0xD8,
  0x28, 0x5B, 0xF7, 0x1E, 0xF8, 0x68, 0x48, 0xFE, 0x10, 0x4A, 0x84, 0xB4, 0x11, 0x4B, 0xA0, 0x43,
  0x04, 0x0E, 0xE0, 0xE0, 0x45, 0x81, 0x17, 0xBA, 0x81, 0xB7, 0x17, 0x2A, 0x75, 0xA7, 0x50, 0x0B,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_mic_none() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 20), Box(0, 0, 23, 23),
      ic_round_24_av_mic_none_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_mic_off 24x24, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_round_24_av_mic_off_data[] PROGMEM = {
  0x78, 0x28, 0xED, 0x87, 0x81, 0x29, 0x23, 0x08, 0xC0, 0x86, 0x82, 0x7F, 0xD2, 0x20, 0xCC, 0x0D,
  0x78, 0x5B, 0xFD, 0x20, 0x2E, 0xC7, 0x18, 0x5B, 0xFD, 0x20, 0x2E, 0xB7, 0x28, 0x5B, 0xFD, 0x20,
  0x2E, 0xA7, 0x38, 0x5B, 0xFD, 0x20, 0x2E, 0x97, 0x48, 0x5B, 0xFD, 0x20, 0x2E, 0x75, 0xA8, 0x2D,
  0x20, 0x27, 0x10, 0xB0, 0x82, 0x0D, 0xA0, 0xD0, 0x23, 0x08, 0x0B, 0x40, 0xB0, 0xE2, 0x07, 0xB0,
  0xD0, 0x22, 0x0D, 0x0C, 0x48, 0x16, 0xF6, 0x28, 0x77, 0xDE, 0xFD, 0x20, 0x26, 0x58, 0x1D, 0xF3,
  0x48, 0x2B, 0xFD, 0x27, 0x83, 0x2E, 0xF9, 0x22, 0x83, 0x2E, 0xFD, 0x27, 0x01, 0x0B, 0xB0, 0xEA,
  0x82, 0xEF, 0xD2, 0x71, 0x03, 0x08, 0xA8, 0x59, 0x40, 0xBF, 0xD2, 0x72, 0xA4, 0x82, 0xBF, 0xD2,
  0x71, 0xA5, 0x81, 0xBF, 0x97, 0x10, 0x0B, 0x60, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_mic_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_mic_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_mic 24x24, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_24_av_mic_data[] PROGMEM = {
  0x58, 0x28, 0xDD, 0x87, 0x20, 0x8C, 0x08, 0x71, 0x0D, 0xC0, 0xD7, 0x1E, 0x71, 0xE7, 0x1E, 0x71,
  0xE7, 0x1E, 0x71, 0xE4, 0x0A, 0x0C, 0x20, 0xDC, 0x0D, 0x28, 0x5C, 0xAC, 0xF4, 0x08, 0xC8, 0x68,
  0x04, 0xFC, 0x7F, 0xB2, 0x82, 0x8D, 0xD8, 0x28, 0x5B, 0xF7, 0x1E, 0xF8, 0x68, 0x48, 0xFE, 0x10,
  0x4A, 0x84, 0xB4, 0x11, 0x4B, 0xA0, 0x43, 0x04, 0x0E, 0xE0, 0xE0, 0x45, 0x81, 0x17, 0xBA, 0x81,
  0xB7, 0x17, 0x2A, 0x75, 0xA7, 0x50, 0x0B, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 20), Box(0, 0, 23, 23),
      ic_round_24_av_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_missed_video_call 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_24_av_missed_video_call_data[] PROGMEM = {
  0x0B, 0xFD, 0x0B, 0x4F, 0xF4, 0xFF, 0x18, 0x12, 0xDC, 0xA8, 0x34, 0x33, 0x3A, 0xB0, 0xD0, 0x8A,
  0x01, 0x0D, 0xC2, 0x81, 0x79, 0xCA, 0x81, 0xD1, 0x7A, 0x0D, 0xD1, 0x81, 0x61, 0xDA, 0x81, 0xD1,
  0x7F, 0xA1, 0x85, 0xD7, 0x1D, 0xD1, 0x7F, 0xB8, 0x55, 0xEF, 0x71, 0x17, 0xD0, 0xDF, 0xA0, 0x0A,
  0xE0, 0x10, 0xDF, 0xFA, 0x18, 0x11, 0xDC, 0xFF, 0x40, 0xBF, 0xD0, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_missed_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 17), Box(0, 0, 23, 23),
      ic_round_24_av_missed_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_movie 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_av_movie_data[] PROGMEM = {
  0x82, 0x4D, 0xF3, 0x28, 0x1B, 0xF3, 0x28, 0x1B, 0xF3, 0x20, 0xBA, 0x0B, 0x0D, 0xA0, 0xB2, 0x81,
  0x3F, 0xB2, 0x81, 0x3F, 0xB2, 0x03, 0xF0, 0x32, 0x81, 0xBF, 0x32, 0x81, 0xBF, 0x32, 0x0B, 0xE0,
  0xC2, 0x81, 0x4F, 0xC2, 0x81, 0x4F, 0xC2, 0x04, 0x80, 0xB8, 0x6F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D,
  0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_movie() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_movie_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_music_video 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_24_av_music_video_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x77, 0x2C, 0x71, 0x0B, 0xA0, 0xB4, 0xC7,
  0x1B, 0x0B, 0x4C, 0x71, 0x97, 0xC7, 0x19, 0x7C, 0x71, 0x97, 0xC4, 0x82, 0x1B, 0xFB, 0x97, 0xC4,
  0x0B, 0xC7, 0xC4, 0x0E, 0xB0, 0xE7, 0xC4, 0x0B, 0xB0, 0xB7, 0xC4, 0x83, 0x1B, 0xEB, 0x17, 0xC7,
  0x72, 0xA0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_music_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_music_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_new_releases 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_24_av_new_releases_data[] PROGMEM = {
  0x71, 0x01, 0x40, 0x17, 0x71, 0x87, 0xDF, 0x93, 0x3A, 0xFD, 0x17, 0x50, 0x8F, 0x90, 0x87, 0x40,
  0x4F, 0xB0, 0x47, 0x04, 0x0C, 0xFF, 0x0C, 0x04, 0x40, 0xCF, 0xFA, 0x0C, 0x40, 0xBF, 0x00, 0x3F,
  0x0B, 0x40, 0x9F, 0x2F, 0x09, 0x40, 0xCF, 0x2F, 0x0C, 0x30, 0xAF, 0x92, 0xF9, 0x81, 0xA0, 0x7F,
  0xA2, 0xFA, 0x00, 0x7F, 0xA0, 0x03, 0xFA, 0x81, 0x60, 0xAF, 0xFC, 0x0A, 0x30, 0xCF, 0xFA, 0x0C,
  0x40, 0x9F, 0x2F, 0x09, 0x40, 0xBF, 0x2F, 0x0B, 0x40, 0xCF, 0xFA, 0x0B, 0x40, 0x40, 0xCF, 0xE8,
  0x1E, 0xB4, 0x70, 0x4F, 0xB0, 0x47, 0x40, 0x8F, 0x90, 0x87, 0x58, 0x71, 0xDF, 0xA3, 0x39, 0xFD,
  0x77, 0x10, 0x14, 0x01, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_new_releases() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_av_new_releases_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_note 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_24_av_note_data[] PROGMEM = {
  0x04, 0x0D, 0xFC, 0x0E, 0x06, 0x50, 0xDF, 0xD8, 0x1D, 0xF7, 0x4F, 0xE8, 0x21, 0xDF, 0x73, 0xFE,
  0x18, 0x21, 0xDF, 0x72, 0xFE, 0x28, 0x21, 0xDF, 0x71, 0xFE, 0x38, 0x21, 0xDF, 0x6F, 0xE0, 0x33,
  0x81, 0x1D, 0xE8, 0x0A, 0x90, 0xF0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_not_interested 24x24, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_round_24_av_not_interested_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x77, 0x10, 0x6A, 0x08, 0x30, 0x4B, 0x0C, 0x01, 0x71,
  0x04, 0xA0, 0x42, 0x85, 0xDF, 0x7C, 0xFC, 0x17, 0x18, 0x93, 0x6F, 0xD0, 0x5F, 0xC0, 0x1C, 0xFC,
  0x17, 0x18, 0x4C, 0xF5, 0x9F, 0x62, 0x83, 0x1C, 0xFC, 0x17, 0x84, 0x6F, 0x9D, 0xF2, 0x38, 0x31,
  0xCF, 0xC1, 0x68, 0x22, 0xFD, 0xE9, 0x58, 0x31, 0xCF, 0xC1, 0x69, 0x00, 0xE9, 0x68, 0x31, 0xCF,
  0xC1, 0x59, 0x82, 0xED, 0xF2, 0x68, 0x31, 0xCF, 0xC1, 0x38, 0x42, 0xFD, 0x9F, 0x67, 0x83, 0x1C,
  0xFC, 0x12, 0x84, 0x6F, 0x95, 0xFC, 0x71, 0x89, 0x31, 0xCF, 0xC1, 0x0C, 0xF5, 0x0D, 0xF6, 0x71,
  0x85, 0x1C, 0xFC, 0x7F, 0xD2, 0x04, 0xA0, 0x47, 0x10, 0x10, 0xCB, 0x04, 0x30, 0x8A, 0x06, 0x71,
  0x07, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9, 0x0D,
  0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_not_interested() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_not_interested_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_pause_circle_filled 24x24, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_24_av_pause_circle_filled_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xE0, 0x03, 0xA0, 0x03,
  0xE0, 0x50, 0x9E, 0x2A, 0x2E, 0x09, 0x0D, 0xE2, 0xA2, 0xE0, 0xD0, 0xEE, 0x2A, 0x2E, 0x00, 0xEE,
  0x2A, 0x2E, 0x0E, 0x0D, 0xE2, 0xA2, 0xE0, 0xD0, 0x9E, 0x2A, 0x2E, 0x09, 0x05, 0xE0, 0x03, 0xA0,
  0x03, 0xE8, 0x15, 0x0D, 0xFF, 0xA0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F,
  0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_pause_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_pause_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_pause_circle_outline 24x24, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_round_24_av_pause_circle_outline_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x67, 0x58, 0x56, 0xFD, 0x05, 0xFC, 0x40, 0x0B, 0x20, 0x0B, 0x48, 0x4C,
  0xF5, 0x9F, 0x64, 0xA2, 0xA4, 0x84, 0x6F, 0x9D, 0xF2, 0x4A, 0x2A, 0x48, 0x22, 0xFD, 0xE9, 0x5A,
  0x2A, 0x59, 0x00, 0xE9, 0x5A, 0x2A, 0x59, 0x82, 0xED, 0xF2, 0x4A, 0x2A, 0x48, 0x42, 0xFD, 0x9F,
  0x64, 0xA2, 0xA4, 0x84, 0x6F, 0x95, 0xFC, 0x40, 0x0B, 0x20, 0x0B, 0x48, 0x5C, 0xF5, 0x0D, 0xF6,
  0x75, 0x81, 0x6F, 0xD2, 0x04, 0xA0, 0x47, 0x30, 0x4A, 0x04, 0x30, 0x8A, 0x06, 0x71, 0x06, 0xA0,
  0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73,
  0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_pause_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_pause_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_pause_circle 24x24, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_24_av_pause_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xE0, 0x03, 0xA0, 0x03,
  0xE0, 0x50, 0x9E, 0x2A, 0x2E, 0x09, 0x0D, 0xE2, 0xA2, 0xE0, 0xD0, 0xEE, 0x2A, 0x2E, 0x00, 0xEE,
  0x2A, 0x2E, 0x0E, 0x0D, 0xE2, 0xA2, 0xE0, 0xD0, 0x9E, 0x2A, 0x2E, 0x09, 0x05, 0xE0, 0x03, 0xA0,
  0x03, 0xE8, 0x15, 0x0D, 0xFF, 0xA0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F,
  0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_pause_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_pause_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_pause 24x24, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_24_av_pause_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x48, 0x34, 0xDD, 0x4D, 0xA0, 0xD4, 0x0D, 0xA0, 0xDC, 0x4F, 0x94, 0xF9, 0x4F,
  0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xC0, 0xDA, 0x0D, 0x40, 0xDA, 0x83,
  0xD4, 0xDD, 0x44, 0x82, 0x4D, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_pause() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 5, 17, 18), Box(0, 0, 23, 23),
      ic_round_24_av_pause_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_play_arrow 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_round_24_av_play_arrow_data[] PROGMEM = {
  0x81, 0xDE, 0x67, 0xB0, 0xB0, 0x25, 0xD0, 0x74, 0xE0, 0xD0, 0x32, 0xF9, 0x09, 0x1F, 0xA0, 0xDF,
  0xA0, 0xDF, 0x90, 0x91, 0xE0, 0xD0, 0x32, 0xD0, 0x74, 0xB0, 0xB0, 0x25, 0x81, 0xDE, 0x67,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_play_arrow() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 17, 17), Box(0, 0, 23, 23),
      ic_round_24_av_play_arrow_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_play_circle_filled 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_24_av_play_circle_filled_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xF0, 0x20, 0x9F, 0xA0,
  0x50, 0x9F, 0x20, 0x50, 0xEF, 0x09, 0x0D, 0xF3, 0x02, 0x0C, 0xE0, 0xD0, 0xEF, 0x50, 0xAD, 0x00,
  0xEF, 0x50, 0xAD, 0x0E, 0x0D, 0xF3, 0x02, 0x0C, 0xE0, 0xD0, 0x9F, 0x20, 0x50, 0xEF, 0x09, 0x05,
  0xF0, 0x20, 0x9F, 0xA8, 0x15, 0x0D, 0xFF, 0xA0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08,
  0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_play_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_play_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_play_circle_outline 24x24, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_round_24_av_play_circle_outline_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x67, 0x58, 0x56, 0xFD, 0x05, 0xFC, 0x50, 0xC0, 0x57, 0x84, 0xCF, 0x59,
  0xF6, 0x5A, 0x09, 0x68, 0x46, 0xF9, 0xDF, 0x25, 0xB0, 0xC0, 0x24, 0x82, 0x2F, 0xDE, 0x96, 0xC0,
  0xE0, 0x44, 0x90, 0x0E, 0x96, 0xC0, 0xE0, 0x44, 0x98, 0x2E, 0xDF, 0x25, 0xB0, 0xC0, 0x24, 0x84,
  0x2F, 0xD9, 0xF6, 0x5A, 0x09, 0x68, 0x46, 0xF9, 0x5F, 0xC5, 0x0D, 0x05, 0x78, 0x5C, 0xF5, 0x0D,
  0xF6, 0x75, 0x81, 0x6F, 0xD2, 0x04, 0xA0, 0x47, 0x30, 0x4A, 0x04, 0x30, 0x8A, 0x06, 0x71, 0x06,
  0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
  0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_play_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_play_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_play_circle 24x24, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_round_24_av_play_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xE8, 0x1D, 0x6C, 0xFA,
  0x05, 0x09, 0xE0, 0x72, 0x06, 0x0E, 0xF0, 0x90, 0xDE, 0x07, 0x30, 0x10, 0xBE, 0x0D, 0x0E, 0xE0,
  0x75, 0x08, 0xD0, 0x0E, 0xE0, 0x75, 0x08, 0xD0, 0xE0, 0xDE, 0x07, 0x30, 0x10, 0xBE, 0x0D, 0x09,
  0xE0, 0x72, 0x06, 0x0E, 0xF0, 0x90, 0x5E, 0x81, 0xD6, 0xCF, 0xA8, 0x15, 0x0D, 0xFF, 0xA0, 0xD2,
  0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
  0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_play_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_play_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_play_disabled 24x24, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_24_av_play_disabled_data[] PROGMEM = {
  0x10, 0x90, 0x67, 0x73, 0x01, 0xA0, 0x77, 0x73, 0x05, 0xA0, 0x77, 0x73, 0x05, 0xA0, 0x72, 0x09,
  0x06, 0x76, 0x05, 0xA0, 0x72, 0x81, 0xAB, 0x27, 0x50, 0x5A, 0x07, 0x28, 0x1A, 0xF7, 0x75, 0x05,
  0xA0, 0x72, 0x82, 0xAF, 0xD3, 0x74, 0x05, 0xA0, 0x72, 0x0A, 0xA0, 0x97, 0x4B, 0x07, 0x20, 0xAA,
  0x0D, 0x73, 0xC0, 0x72, 0x81, 0xAF, 0xD7, 0x3D, 0x07, 0x20, 0x67, 0x4E, 0x07, 0x76, 0xF0, 0x77,
  0x5B, 0x81, 0xB2, 0x5A, 0x07, 0x74, 0x81, 0xDE, 0x63, 0x05, 0xA0, 0x77, 0x73, 0x05, 0xA0, 0x77,
  0x73, 0x05, 0xA0, 0x77, 0x73, 0x05, 0xA0, 0x67, 0x73, 0x81, 0x5F, 0x97, 0x74, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_play_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_av_play_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_playlist_add_check_circle 24x24, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_round_24_av_playlist_add_check_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xB0, 0x35, 0x03, 0xE8, 0x1D, 0x05, 0xC0, 0x35,
  0x03, 0xF0, 0x50, 0x9F, 0xFC, 0x09, 0x0D, 0xC0, 0x35, 0x03, 0xF0, 0xD0, 0xEC, 0x03, 0x50, 0x3F,
  0x00, 0xEF, 0xE8, 0x1E, 0x8D, 0xA0, 0xE0, 0xDC, 0x81, 0x30, 0x3D, 0x82, 0xE2, 0x08, 0xA0, 0xD0,
  0x9C, 0x81, 0x30, 0x3A, 0x85, 0xAE, 0xE2, 0x02, 0xEA, 0x09, 0x05, 0xF9, 0x85, 0xB0, 0x12, 0x02,
  0xEB, 0x81, 0x50, 0xDF, 0x90, 0x32, 0x02, 0x0E, 0xB0, 0xD2, 0x04, 0xF9, 0x82, 0xE4, 0x3E, 0xC0,
  0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59,
  0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_playlist_add_check_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_playlist_add_check_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_playlist_add_check 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_24_av_playlist_add_check_data[] PROGMEM = {
  0x0B, 0xFB, 0x0B, 0x72, 0x0B, 0xFB, 0x0B, 0x80, 0xD7, 0x00, 0xBF, 0xB0, 0xB7, 0x20, 0xBF, 0xB0,
  0xB7, 0x77, 0x68, 0x17, 0xE5, 0x77, 0x30, 0x7A, 0x05, 0x0B, 0xE0, 0xB2, 0x00, 0x54, 0x07, 0xA8,
  0x17, 0x0B, 0xE0, 0xB2, 0x81, 0xEF, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77,
  0x07, 0xC0, 0x77, 0x72, 0x07, 0xA0, 0x87, 0x74, 0x00, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_playlist_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_av_playlist_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_playlist_add_circle 24x24, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_24_av_playlist_add_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xB0, 0x35, 0x03, 0xE8, 0x1D, 0x05, 0xC0, 0x35,
  0x03, 0xF0, 0x50, 0x9F, 0xFC, 0x09, 0x0D, 0xC0, 0x35, 0x03, 0xF0, 0xD0, 0xEC, 0x03, 0x58, 0x23,
  0xF3, 0x3C, 0x00, 0xEF, 0xD2, 0xC0, 0xE0, 0xDC, 0x81, 0x30, 0x3B, 0x03, 0x40, 0x3A, 0x0D, 0x09,
  0xC8, 0x13, 0x03, 0xB0, 0x34, 0x03, 0xA0, 0x90, 0x5F, 0xD2, 0xC8, 0x15, 0x0D, 0xFC, 0x00, 0x3B,
  0x0D, 0x20, 0x4F, 0xFA, 0x04, 0x30, 0x8F, 0xF0, 0x85, 0x08, 0xFD, 0x08, 0x70, 0x40, 0xDF, 0x90,
  0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_playlist_add_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_playlist_add_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_playlist_add 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_24_av_playlist_add_data[] PROGMEM = {
  0x0B, 0xFB, 0x0B, 0x71, 0x0B, 0xFB, 0x0B, 0x80, 0xD4, 0x00, 0xBF, 0xB0, 0xB2, 0x00, 0xB4, 0x0B,
  0xFB, 0x0B, 0x2A, 0x77, 0x4A, 0x77, 0x4A, 0x40, 0xBE, 0x0B, 0x20, 0xBF, 0x90, 0x0B, 0xE0, 0xB2,
  0x0B, 0xF9, 0x0B, 0x77, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0x00, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_playlist_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_playlist_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_playlist_play 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_24_av_playlist_play_data[] PROGMEM = {
  0x0B, 0xFB, 0x0B, 0x30, 0xBF, 0xB0, 0xB7, 0x77, 0x75, 0x0B, 0xFB, 0x0B, 0x30, 0xBF, 0xB0, 0xB7,
  0x77, 0x75, 0x0B, 0xE0, 0xB2, 0x07, 0x02, 0x30, 0xBE, 0x0B, 0x2A, 0x07, 0x75, 0xB0, 0xD0, 0x37,
  0x3B, 0x0D, 0x03, 0x73, 0x90, 0xE0, 0x77, 0x50, 0x60, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_playlist_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 18, 19), Box(0, 0, 23, 23),
      ic_round_24_av_playlist_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_playlist_remove 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_24_av_playlist_remove_data[] PROGMEM = {
  0x0B, 0xFA, 0x0B, 0x70, 0xBF, 0xA0, 0xB8, 0x0C, 0x70, 0x0B, 0xFA, 0x0B, 0x70, 0xBF, 0xA0, 0xB8,
  0x0C, 0x70, 0x0B, 0xD0, 0xB3, 0x81, 0x17, 0x12, 0x82, 0x17, 0x1B, 0xD0, 0xB3, 0x86, 0x7F, 0xC1,
  0x1C, 0xF7, 0x73, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x74, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x50, 0x10,
  0xCA, 0x0C, 0x01, 0x74, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x73, 0x86, 0x7F, 0xC1, 0x1C, 0xF7, 0x73,
  0x81, 0x17, 0x12, 0x81, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_playlist_remove() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_av_playlist_remove_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_queue_music 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_24_av_queue_music_data[] PROGMEM = {
  0x0B, 0xFB, 0x0B, 0x20, 0x40, 0xDA, 0x00, 0xBF, 0xB0, 0xB2, 0x0D, 0xB0, 0xB7, 0x7A, 0x77, 0x3A,
  0x30, 0xBF, 0xB0, 0xB2, 0xA3, 0x0B, 0xFB, 0x0B, 0x2A, 0x77, 0x3A, 0x77, 0x3A, 0x30, 0xBE, 0x0B,
  0x38, 0x18, 0xDE, 0xA3, 0x0B, 0xE0, 0xB2, 0x08, 0xD7, 0x60, 0xDD, 0x76, 0x0E, 0xC0, 0xD7, 0x60,
  0x8C, 0x08, 0x77, 0x82, 0x8E, 0xD8, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_queue_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_queue_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_queue_play_next 24x24, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_24_av_queue_play_next_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x2D, 0x40, 0xDF, 0xFE, 0x0D, 0x1A, 0x03, 0x77, 0x20, 0x3A, 0x1A, 0x77,
  0x4A, 0x1A, 0x71, 0x00, 0xB7, 0x1A, 0x1A, 0x71, 0xA7, 0x1A, 0x1A, 0x71, 0xA7, 0x1A, 0x1A, 0x50,
  0xBE, 0x0B, 0x5A, 0x1A, 0x50, 0xBE, 0x0B, 0x5A, 0x1A, 0x71, 0xA7, 0x10, 0x0B, 0x1A, 0x71, 0xA7,
  0x4A, 0x71, 0x00, 0xB5, 0x81, 0x5F, 0x73, 0xA7, 0x71, 0x05, 0xA0, 0x72, 0xA0, 0x37, 0x71, 0x07,
  0xA8, 0x17, 0x0D, 0xFF, 0x90, 0xB2, 0x07, 0xA8, 0x15, 0x4D, 0xFF, 0x0B, 0x20, 0x7A, 0x05, 0x7F,
  0x93, 0x07, 0xA0, 0x77, 0x10, 0xBE, 0x0B, 0x20, 0x5A, 0x07, 0x77, 0x58, 0x15, 0xF7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_queue_play_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 23, 21), Box(0, 0, 23, 23),
      ic_round_24_av_queue_play_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_queue 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_av_queue_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x4F, 0x00, 0x3F, 0x00, 0xB2,
  0xF2, 0xFA, 0x2F, 0x2F, 0xA2, 0xF2, 0xFA, 0x2B, 0x03, 0x71, 0x03, 0xD2, 0xB0, 0x37, 0x10, 0x3D,
  0x2F, 0x2F, 0xA2, 0xF2, 0xFA, 0x2F, 0x2F, 0xA2, 0xF0, 0x03, 0xFA, 0x2F, 0xFC, 0x20, 0xDF, 0xF0,
  0xDA, 0x20, 0x40, 0xDF, 0xD0, 0xD0, 0x4A, 0x77, 0x4A, 0x03, 0x77, 0x30, 0xDF, 0xF0, 0xB4, 0x04,
  0x0D, 0xFE, 0x0B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_radio 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_24_av_radio_data[] PROGMEM = {
  0x74, 0x82, 0x16, 0x91, 0x77, 0x84, 0x39, 0xEF, 0xE2, 0x75, 0x06, 0x0C, 0xA8, 0x1D, 0x71, 0x73,
  0x81, 0x29, 0xEA, 0x0A, 0x04, 0x74, 0x05, 0x0B, 0xA8, 0x1D, 0x81, 0x74, 0x04, 0x0E, 0xFF, 0xA8,
  0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x03, 0x77, 0x03, 0xC7, 0x72, 0xC7, 0x50, 0x0B, 0x2C, 0x75, 0xA2,
  0x80, 0xD1, 0xF8, 0x27, 0x11, 0x7F, 0xF9, 0x07, 0x40, 0x7F, 0xF0, 0x14, 0x01, 0xFF, 0x01, 0x40,
  0x1F, 0xF0, 0x74, 0x07, 0xFF, 0x98, 0x27, 0x11, 0x7F, 0xE0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_radio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_radio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_recent_actors 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_24_av_recent_actors_data[] PROGMEM = {
  0x0B, 0xFD, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0xFF, 0x2A, 0x2F, 0x90, 0x0D, 0xE2, 0xA2, 0xF0, 0x62,
  0x06, 0xD2, 0xA2, 0xE0, 0xD4, 0x0D, 0xC2, 0xA2, 0xE0, 0xD4, 0x0D, 0xC2, 0xA2, 0xF0, 0x62, 0x06,
  0xD2, 0xA2, 0xF9, 0x00, 0xDE, 0x2A, 0x2F, 0xFA, 0x2A, 0x2D, 0x81, 0xE7, 0x32, 0x81, 0x37, 0xEB,
  0x2A, 0x2C, 0x0D, 0x71, 0x0C, 0xA2, 0xA2, 0xC0, 0x77, 0x10, 0x7A, 0x2A, 0x2F, 0xFA, 0x2A, 0x2A,
  0x0B, 0xFD, 0x0B, 0x20, 0x0B, 0x20, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_recent_actors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_round_24_av_recent_actors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_remove_from_queue 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_24_av_remove_from_queue_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x50, 0xBE, 0x0B, 0x5C, 0x50, 0xBE, 0x0B, 0x5C, 0x77, 0x4C, 0x77,
  0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x03, 0x77, 0x20, 0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD0, 0x47, 0xF9, 0x77, 0x0B, 0xE0, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_remove_from_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_av_remove_from_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_repeat_one_on 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_24_av_repeat_one_on_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0x90, 0xCC, 0x0D, 0xFF, 0xA1, 0x07, 0xFF, 0xE2, 0x07,
  0xF0, 0x37, 0x70, 0x8E, 0x77, 0x10, 0x8E, 0x2F, 0xB2, 0x07, 0xF2, 0xFB, 0x10, 0x7F, 0x92, 0xB8,
  0x12, 0x02, 0xC0, 0xDF, 0xA0, 0x03, 0xB0, 0xA0, 0x31, 0xFF, 0xE0, 0x71, 0xFF, 0xE0, 0x71, 0xFF,
  0xE0, 0x71, 0xC0, 0x03, 0xFA, 0x0D, 0xC0, 0xA0, 0x2C, 0x2F, 0x90, 0x71, 0xFB, 0x2F, 0x07, 0x2F,
  0xB2, 0xE0, 0x87, 0x71, 0xE0, 0x87, 0x70, 0x3F, 0x07, 0x2F, 0xFE, 0x07, 0x1F, 0xFA, 0x0D, 0xC0,
  0xCF, 0xF9, 0x81, 0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_repeat_one_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_av_repeat_one_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_repeat_one 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_av_repeat_one_data[] PROGMEM = {
  0x77, 0x02, 0x77, 0x39, 0x07, 0x77, 0x2A, 0x07, 0x30, 0xBF, 0xF0, 0x72, 0xFF, 0x90, 0x72, 0xA7,
  0x3A, 0x07, 0x3A, 0x73, 0x90, 0x74, 0xA3, 0x81, 0x3B, 0xC4, 0x02, 0x50, 0x0B, 0x30, 0xDA, 0x77,
  0x20, 0x79, 0x77, 0x20, 0x79, 0x77, 0x20, 0x79, 0x40, 0x0B, 0x50, 0x24, 0x05, 0x0C, 0x4A, 0x40,
  0x79, 0x73, 0xA3, 0x07, 0xA7, 0x3A, 0x20, 0x7F, 0xF9, 0x20, 0x7F, 0xF0, 0xB3, 0x07, 0xA7, 0x72,
  0x07, 0x97, 0x73, 0x02, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_repeat_one() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_av_repeat_one_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_repeat_on 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_24_av_repeat_on_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0x90, 0xCC, 0x0D, 0xFF, 0xA1, 0x07, 0xFF, 0xE2, 0x07,
  0xF0, 0x37, 0x70, 0x8E, 0x77, 0x10, 0x8E, 0x2F, 0xB2, 0x07, 0xF2, 0xFB, 0x10, 0x7F, 0x92, 0xFB,
  0x0D, 0xFA, 0x00, 0x38, 0x09, 0x90, 0xF0, 0x03, 0xFA, 0x0D, 0xFB, 0x2F, 0x90, 0x71, 0xFB, 0x2F,
  0x07, 0x2F, 0xB2, 0xE0, 0x87, 0x71, 0xE0, 0x87, 0x70, 0x3F, 0x07, 0x2F, 0xFE, 0x07, 0x1F, 0xFA,
  0x0D, 0xC0, 0xCF, 0xF9, 0x81, 0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_repeat_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_av_repeat_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_repeat 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_av_repeat_data[] PROGMEM = {
  0x77, 0x02, 0x77, 0x39, 0x07, 0x77, 0x2A, 0x07, 0x30, 0xBF, 0xF0, 0x72, 0xFF, 0x90, 0x72, 0xA7,
  0x3A, 0x07, 0x3A, 0x73, 0x90, 0x74, 0xA7, 0x30, 0x25, 0x00, 0xB8, 0x0F, 0x40, 0x00, 0xB5, 0x02,
  0x73, 0xA4, 0x07, 0x97, 0x3A, 0x30, 0x7A, 0x73, 0xA2, 0x07, 0xFF, 0x92, 0x07, 0xFF, 0x0B, 0x30,
  0x7A, 0x77, 0x20, 0x79, 0x77, 0x30, 0x27, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_repeat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_av_repeat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_replay_10 24x24, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_round_24_av_replay_10_data[] PROGMEM = {
  0x70, 0x27, 0x70, 0x79, 0x76, 0x07, 0xA7, 0x50, 0x7B, 0x74, 0x07, 0xC8, 0x2E, 0xC8, 0x27, 0x07,
  0xF9, 0x08, 0x70, 0x7B, 0x10, 0x30, 0x9A, 0x0B, 0x70, 0x7A, 0x38, 0x23, 0xEF, 0x87, 0x07, 0x94,
  0x03, 0xA0, 0x27, 0x02, 0x58, 0x19, 0xF8, 0x60, 0x12, 0x03, 0x01, 0x28, 0x13, 0xFC, 0x58, 0x4A,
  0xD0, 0x78, 0xC2, 0x83, 0x1F, 0xEA, 0xC4, 0x89, 0x3D, 0x0A, 0x1A, 0x20, 0x1F, 0xEC, 0xF3, 0x38,
  0x93, 0xD0, 0xA2, 0xB2, 0x03, 0xFC, 0x9F, 0x83, 0x83, 0xD0, 0x5B, 0xB2, 0x82, 0x9F, 0x82, 0xA0,
  0x27, 0x10, 0x3A, 0x84, 0x20, 0x9F, 0xD2, 0x68, 0x23, 0xDF, 0x83, 0x0B, 0xA0, 0x80, 0x32, 0x03,
  0x09, 0xA0, 0xB5, 0x09, 0xF9, 0x08, 0x78, 0x62, 0x8D, 0xEE, 0xC8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_replay_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_av_replay_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_replay_30 24x24, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_round_24_av_replay_30_data[] PROGMEM = {
  0x70, 0x27, 0x70, 0x79, 0x76, 0x07, 0xA7, 0x50, 0x7B, 0x74, 0x07, 0xC8, 0x2E, 0xC8, 0x27, 0x07,
  0xF9, 0x08, 0x70, 0x7B, 0x10, 0x30, 0x8A, 0x0B, 0x70, 0x7A, 0x38, 0x22, 0xEF, 0x87, 0x07, 0x94,
  0x02, 0xA0, 0x27, 0x02, 0x58, 0x18, 0xF8, 0x50, 0x20, 0x32, 0x03, 0x02, 0x28, 0x13, 0xFC, 0x48,
  0x62, 0xAA, 0x55, 0x9C, 0x12, 0x98, 0x1E, 0xAC, 0x38, 0x94, 0x3B, 0x38, 0x38, 0x40, 0x1F, 0xEC,
  0xF3, 0x28, 0xA4, 0x17, 0x68, 0x49, 0x40, 0x3F, 0xC8, 0xF9, 0x02, 0xCB, 0x43, 0xBC, 0x28, 0x29,
  0xF8, 0x2A, 0x03, 0x71, 0x03, 0xA8, 0x42, 0x08, 0xFD, 0x36, 0x82, 0x3D, 0xF8, 0x30, 0xBA, 0x09,
  0x03, 0x20, 0x30, 0x9A, 0x0B, 0x50, 0x9F, 0x90, 0x87, 0x86, 0x28, 0xDE, 0xED, 0x82, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_replay_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_av_replay_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_replay_5 24x24, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_24_av_replay_5_data[] PROGMEM = {
  0x70, 0x27, 0x70, 0x79, 0x76, 0x07, 0xA7, 0x50, 0x7B, 0x74, 0x07, 0xC8, 0x2E, 0xC8, 0x27, 0x07,
  0xF9, 0x08, 0x70, 0x7B, 0x10, 0x30, 0x8A, 0x0B, 0x70, 0x7A, 0x38, 0x22, 0xEF, 0x87, 0x07, 0x94,
  0x02, 0xA0, 0x27, 0x02, 0x58, 0x18, 0xF8, 0x78, 0x13, 0x31, 0x38, 0x13, 0xFC, 0x68, 0x22, 0xC7,
  0x24, 0x98, 0x1E, 0xAC, 0x48, 0x23, 0xCA, 0x13, 0x84, 0x1F, 0xEC, 0xF3, 0x38, 0x21, 0x16, 0x63,
  0x84, 0x3F, 0xC8, 0xF8, 0x38, 0x22, 0xCC, 0x23, 0x82, 0x8F, 0x82, 0xA0, 0x27, 0x10, 0x2A, 0x84,
  0x20, 0x8F, 0xD2, 0x68, 0x22, 0xDF, 0x83, 0x0B, 0xA0, 0x80, 0x32, 0x83, 0x39, 0xEF, 0xC5, 0x09,
  0xF9, 0x09, 0x78, 0x62, 0x8D, 0xEE, 0xD8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_replay_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_av_replay_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_replay_circle_filled 24x24, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_24_av_replay_circle_filled_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xC0, 0xD0, 0x5E,
  0x08, 0x50, 0x8C, 0x0D, 0x01, 0x1F, 0x08, 0x30, 0x4C, 0x0D, 0x01, 0x20, 0x80, 0xBE, 0x04, 0x20,
  0xDC, 0x04, 0x50, 0x10, 0xAC, 0x81, 0xD0, 0x5D, 0x0D, 0x01, 0x20, 0x60, 0x22, 0x08, 0xC0, 0x50,
  0x9E, 0x0D, 0x02, 0x1A, 0x08, 0x20, 0xCB, 0x09, 0x0D, 0xF0, 0xD0, 0x5B, 0x81, 0x60, 0x5B, 0x0D,
  0x0E, 0xFD, 0x81, 0xD0, 0x1B, 0x00, 0xEB, 0x0B, 0x0A, 0xF9, 0x2B, 0x0E, 0x0D, 0xB8, 0x12, 0x0C,
  0xE8, 0x1C, 0x01, 0xB0, 0xD0, 0x9B, 0x81, 0x50, 0x6E, 0x81, 0x60, 0x5B, 0x09, 0x05, 0xB0, 0xC2,
  0x08, 0xC0, 0x82, 0x0C, 0xB8, 0x15, 0x0D, 0xB0, 0x82, 0x82, 0x25, 0x52, 0x20, 0x9B, 0x0D, 0x20,
  0x4C, 0x0A, 0x01, 0x40, 0x10, 0xAC, 0x04, 0x30, 0x8D, 0x82, 0xA7, 0x8B, 0xD0, 0x85, 0x08, 0xFD,
  0x08, 0x70, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_replay_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_replay_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_replay 24x24, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_24_av_replay_data[] PROGMEM = {
  0x70, 0x27, 0x70, 0x79, 0x76, 0x07, 0xA7, 0x50, 0x7B, 0x74, 0x07, 0xC8, 0x2E, 0xC8, 0x27, 0x07,
  0xF9, 0x08, 0x70, 0x7B, 0x10, 0x30, 0x8A, 0x0B, 0x70, 0x7A, 0x38, 0x22, 0xEF, 0x87, 0x07, 0x94,
  0x02, 0xA0, 0x27, 0x02, 0x58, 0x18, 0xF8, 0x76, 0x81, 0x3F, 0xC7, 0x79, 0x81, 0xEA, 0xC7, 0x48,
  0x41, 0xFE, 0xCF, 0x37, 0x38, 0x43, 0xFC, 0x8F, 0x97, 0x38, 0x29, 0xF8, 0x2A, 0x03, 0x71, 0x03,
  0xA8, 0x42, 0x08, 0xFD, 0x36, 0x82, 0x3D, 0xF8, 0x30, 0xBA, 0x09, 0x03, 0x20, 0x30, 0x9A, 0x0B,
  0x50, 0x9F, 0x90, 0x87, 0x86, 0x28, 0xDE, 0xED, 0x82, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_replay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_av_replay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_sd 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_av_sd_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0F, 0x4F, 0x03, 0x30, 0x3A, 0x40, 0x3F,
  0x91, 0x81, 0x37, 0x31, 0xA1, 0x81, 0x37, 0x31, 0xF9, 0x18, 0x23, 0x77, 0xAA, 0x18, 0x17, 0xF7,
  0x1F, 0x98, 0x2A, 0x77, 0x31, 0xA1, 0x81, 0x7F, 0x71, 0xF9, 0x18, 0x13, 0x73, 0x1A, 0x18, 0x13,
  0x73, 0x1F, 0x90, 0x33, 0x03, 0xA4, 0x03, 0x80, 0xF4, 0xF0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_sd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_sd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_shuffle_on 24x24, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_round_24_av_shuffle_on_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDF, 0xFF, 0xC0, 0xA0, 0x9F, 0x90, 0xE4, 0x07,
  0xE8, 0x11, 0x07, 0xF9, 0x09, 0x30, 0x6E, 0x0A, 0x20, 0x7F, 0x0A, 0x30, 0x6F, 0x0A, 0x20, 0x7D,
  0x0A, 0x28, 0x14, 0x06, 0xF9, 0x0A, 0x20, 0x7B, 0x0A, 0x28, 0x27, 0xF9, 0x9F, 0xA8, 0x4A, 0x03,
  0xEF, 0xA2, 0x07, 0xFF, 0x82, 0xBE, 0xFA, 0x20, 0x7F, 0xFB, 0x0A, 0x20, 0x7F, 0xFB, 0x0A, 0x20,
  0x7F, 0xFB, 0x0A, 0x20, 0x7A, 0x0A, 0xFF, 0x0A, 0x20, 0x7A, 0x81, 0x50, 0x7F, 0xD0, 0xA2, 0x07,
  0xB0, 0xA2, 0x82, 0x7F, 0x99, 0xF0, 0xA2, 0x07, 0xD0, 0xA2, 0x81, 0x40, 0x6E, 0x0A, 0x20, 0x7F,
  0x0A, 0x30, 0x6E, 0x81, 0x10, 0x7F, 0x90, 0x93, 0x06, 0xE0, 0x0A, 0xF9, 0x0D, 0x40, 0x7F, 0xFF,
  0xC0, 0xDF, 0xFE, 0x81, 0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_shuffle_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_av_shuffle_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_shuffle 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_24_av_shuffle_data[] PROGMEM = {
  0x81, 0x17, 0x17, 0x10, 0xAB, 0x83, 0xE7, 0xFC, 0x17, 0x01, 0x0D, 0xB8, 0x31, 0xCF, 0xC1, 0x60,
  0x10, 0xCB, 0x18, 0x31, 0xCF, 0xC1, 0x48, 0x31, 0xCF, 0xCD, 0x92, 0x83, 0x1C, 0xFC, 0x12, 0x85,
  0x1C, 0xFC, 0x11, 0xA3, 0x89, 0x01, 0xCF, 0x40, 0x1C, 0xFC, 0x17, 0x86, 0x13, 0x01, 0xCF, 0xC1,
  0x73, 0x83, 0x1C, 0xFC, 0x17, 0x38, 0x31, 0xCF, 0xC1, 0x73, 0x86, 0x1C, 0xFC, 0x10, 0x41, 0x78,
  0x90, 0x1C, 0xFC, 0x10, 0x4F, 0xC1, 0x58, 0x31, 0xCF, 0xC1, 0x28, 0x93, 0x1C, 0xFC, 0x11, 0xA0,
  0x1C, 0xFC, 0x14, 0x89, 0x11, 0xCF, 0xCD, 0xF1, 0xCF, 0xC1, 0x60, 0x10, 0xCB, 0x82, 0x7F, 0xC1,
  0x70, 0x10, 0xDB, 0x81, 0x17, 0x17, 0x10, 0xAB, 0x0E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_shuffle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_round_24_av_shuffle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_skip_next 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_round_24_av_skip_next_data[] PROGMEM = {
  0x73, 0x83, 0xBB, 0xCD, 0x37, 0xD0, 0x86, 0xE0, 0xC0, 0x24, 0xF0, 0xE0, 0x63, 0xFA, 0x08, 0x2F,
  0xA0, 0x82, 0xF0, 0xE0, 0x63, 0xE0, 0xC0, 0x24, 0xD0, 0x86, 0xA8, 0x1C, 0xD3, 0x7A, 0x73, 0x00,
  0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_skip_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 17, 17), Box(0, 0, 23, 23),
      ic_round_24_av_skip_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_skip_previous 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_round_24_av_skip_previous_data[] PROGMEM = {
  0x00, 0xB7, 0x3A, 0x78, 0x13, 0xDC, 0xA6, 0x08, 0xD4, 0x02, 0x0C, 0xE3, 0x06, 0x0E, 0xF2, 0x08,
  0xFA, 0x20, 0x8F, 0xA3, 0x06, 0x0E, 0xF4, 0x02, 0x0C, 0xE6, 0x08, 0xD7, 0x83, 0x3D, 0xCB, 0xB7,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_skip_previous() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 17, 17), Box(0, 0, 23, 23),
      ic_round_24_av_skip_previous_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_slow_motion_video 24x24, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_round_24_av_slow_motion_video_data[] PROGMEM = {
  0x68, 0x15, 0xA8, 0x28, 0x17, 0xA5, 0x73, 0x04, 0x0D, 0xA0, 0xD2, 0x0C, 0xA0, 0xD0, 0x57, 0x18,
  0x3B, 0xFC, 0x61, 0x28, 0x11, 0x6C, 0xA0, 0x87, 0x01, 0x04, 0x71, 0x06, 0xA0, 0x83, 0x81, 0x4B,
  0x17, 0x40, 0x4A, 0x04, 0x28, 0x1D, 0xF4, 0x75, 0x85, 0x6F, 0xD0, 0x5F, 0xC5, 0x0C, 0x05, 0x78,
  0x4C, 0xF5, 0xAF, 0x65, 0xA0, 0x96, 0x84, 0x6F, 0xA8, 0xD1, 0x5B, 0x0C, 0x02, 0x48, 0x12, 0xFD,
  0x71, 0xC0, 0xE0, 0x44, 0x90, 0xE7, 0x1C, 0x0E, 0x04, 0x49, 0x82, 0xE8, 0xD1, 0x5B, 0x0C, 0x02,
  0x48, 0x42, 0xFD, 0xAF, 0x65, 0xA0, 0x96, 0x84, 0x6F, 0xA5, 0xFC, 0x50, 0xD0, 0x57, 0x85, 0xCF,
  0x50, 0xDF, 0x47, 0x58, 0x16, 0xFD, 0x28, 0x14, 0xB1, 0x74, 0x04, 0xA0, 0x45, 0x01, 0x04, 0x71,
  0x06, 0xA0, 0x86, 0x83, 0xBF, 0xC6, 0x12, 0x81, 0x16, 0xCA, 0x08, 0x70, 0x40, 0xDA, 0x0D, 0x20,
  0xCA, 0x0D, 0x05, 0x73, 0x81, 0x5A, 0x82, 0x81, 0x7A, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_slow_motion_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_slow_motion_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_snooze 24x24, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_round_24_av_snooze_data[] PROGMEM = {
  0x38, 0x13, 0xA2, 0x71, 0x81, 0x2A, 0x35, 0x05, 0xA0, 0x67, 0x10, 0x6A, 0x06, 0x30, 0x8A, 0x89,
  0x28, 0x04, 0x9D, 0xEE, 0xD9, 0x40, 0x8A, 0x81, 0x80, 0x6A, 0x81, 0x52, 0xBF, 0x98, 0x1B, 0x26,
  0xA8, 0x90, 0x62, 0xA3, 0x3E, 0xFE, 0x72, 0x28, 0x72, 0x7E, 0xFE, 0x33, 0xA2, 0x28, 0x22, 0xEF,
  0xA7, 0x18, 0x2A, 0xFE, 0x24, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x38, 0x14, 0xFE, 0x30, 0xBC,
  0x0E, 0x02, 0x28, 0x1E, 0xF4, 0x28, 0x19, 0xF7, 0x30, 0xBD, 0x02, 0x28, 0x17, 0xF9, 0x28, 0x1D,
  0xF2, 0x68, 0x1B, 0xF5, 0x38, 0x12, 0xFD, 0x20, 0xE9, 0x68, 0x1A, 0xF7, 0x59, 0x0E, 0x20, 0xE9,
  0x58, 0x17, 0xFA, 0x69, 0x0E, 0x28, 0x1D, 0xF2, 0x38, 0x15, 0xFB, 0x68, 0x12, 0xFD, 0x28, 0x19,
  0xF7, 0x20, 0x2D, 0x0B, 0x38, 0x17, 0xF9, 0x28, 0x14, 0xFE, 0x20, 0x20, 0xEC, 0x0B, 0x38, 0x1E,
  0xF4, 0x38, 0x1B, 0xFA, 0x73, 0x81, 0xAF, 0xB4, 0x82, 0x2E, 0xFA, 0x71, 0x82, 0xAF, 0xE2, 0x58,
  0x43, 0xEF, 0xE7, 0x22, 0x84, 0x27, 0xEF, 0xE3, 0x70, 0x20, 0xBF, 0x90, 0xB0, 0x27, 0x38, 0x64,
  0x9D, 0xEE, 0xD9, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_snooze() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_snooze_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_sort_by_alpha 24x24, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_round_24_av_sort_by_alpha_data[] PROGMEM = {
  0x73, 0x05, 0x77, 0x48, 0x19, 0xFB, 0x77, 0x28, 0x34, 0x99, 0x95, 0x77, 0x77, 0x30, 0x80, 0x75,
  0x04, 0x80, 0x3B, 0x03, 0x30, 0x5A, 0x03, 0x40, 0x68, 0x01, 0xDA, 0x08, 0x38, 0x2C, 0xEF, 0x97,
  0x28, 0x23, 0xFE, 0x12, 0x83, 0x2F, 0x8A, 0xE7, 0x28, 0x1D, 0xF4, 0x38, 0x48, 0xF2, 0x5F, 0x67,
  0x81, 0x8F, 0x94, 0x0E, 0x0B, 0x20, 0xE0, 0xC6, 0x81, 0x4F, 0xD4, 0x81, 0x5F, 0x62, 0x81, 0x8F,
  0x24, 0x82, 0x1D, 0xF3, 0x48, 0x6B, 0xF6, 0x55, 0x8F, 0x84, 0x81, 0xAF, 0x84, 0x02, 0xF0, 0xE3,
  0x81, 0x5F, 0xC5, 0x89, 0x58, 0xF6, 0x33, 0x33, 0x8F, 0x50, 0x1E, 0xF2, 0x50, 0x0D, 0x58, 0x31,
  0xFB, 0x09, 0xA8, 0x01, 0xD8, 0x18, 0x85, 0x68, 0x27, 0x60, 0x48, 0x03, 0xB0, 0x67, 0x77, 0x78,
  0x34, 0x99, 0x95, 0x77, 0x28, 0x19, 0xFB, 0x77, 0x40, 0x57, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_sort_by_alpha() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_sort_by_alpha_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_speed 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_24_av_speed_data[] PROGMEM = {
  0x68, 0x15, 0xAD, 0xA8, 0x1C, 0x84, 0x73, 0x05, 0x0D, 0xF9, 0x07, 0x71, 0x09, 0xA8, 0x7C, 0x72,
  0x11, 0x37, 0xA2, 0x78, 0x29, 0xFE, 0x67, 0x20, 0x10, 0x54, 0x05, 0xA0, 0x47, 0x28, 0x15, 0xD1,
  0x48, 0x1D, 0xF6, 0x71, 0x89, 0x11, 0xAF, 0x50, 0x15, 0x05, 0xFC, 0x71, 0x82, 0x5E, 0xFA, 0x28,
  0x49, 0xF5, 0xAF, 0x66, 0x01, 0x0A, 0xA0, 0xE0, 0x12, 0x84, 0x7F, 0x9D, 0xF2, 0x50, 0x40, 0xEB,
  0x05, 0x38, 0x22, 0xFD, 0xE9, 0x60, 0xDB, 0x0A, 0x48, 0x11, 0xFE, 0xA6, 0x0D, 0xA0, 0xE0, 0x14,
  0x84, 0x1F, 0xED, 0xF2, 0x58, 0x24, 0xDD, 0x45, 0x84, 0x2F, 0xCA, 0xF6, 0x77, 0x84, 0x7F, 0x95,
  0xFC, 0x77, 0x85, 0xCF, 0x40, 0xDF, 0xE8, 0x09, 0x0D, 0x81, 0xEF, 0xD2, 0x03, 0x0D, 0xFF, 0x0D,
  0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_speed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_speed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_stop_circle 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_24_av_stop_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xD0, 0x36, 0x03, 0xD0,
  0x50, 0x9D, 0x71, 0xD0, 0x90, 0xDD, 0x71, 0xD0, 0xD0, 0xED, 0x71, 0xD0, 0x0E, 0xD7, 0x1D, 0x0E,
  0x0D, 0xD7, 0x1D, 0x0D, 0x09, 0xD7, 0x1D, 0x09, 0x05, 0xD0, 0x36, 0x03, 0xD8, 0x15, 0x0D, 0xFF,
  0xA0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9,
  0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_stop_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_stop_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_stop 24x24, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_round_24_av_stop_data[] PROGMEM = {
  0x04, 0x0D, 0xF9, 0x81, 0xD4, 0xDF, 0xB0, 0xD8, 0x09, 0xB4, 0xF0, 0xDF, 0xB8, 0x1D, 0x4D, 0xF9,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 17, 17), Box(0, 0, 23, 23),
      ic_round_24_av_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_subscriptions 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_av_subscriptions_data[] PROGMEM = {
  0x40, 0xBF, 0xB0, 0xB7, 0x10, 0xBF, 0xB0, 0xB8, 0x0D, 0x20, 0x0B, 0xFF, 0x0B, 0x40, 0xBF, 0xF0,
  0xB8, 0x0C, 0x60, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDF, 0x90, 0xEF, 0xFD, 0x01,
  0x08, 0xFF, 0xC2, 0x01, 0x09, 0xFF, 0xA4, 0x02, 0x0D, 0xFF, 0x40, 0x20, 0xDF, 0xF2, 0x01, 0x09,
  0xFF, 0xA0, 0x10, 0x8F, 0xFC, 0x0E, 0xFC, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_subscriptions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_subscriptions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_subtitles 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_24_av_subtitles_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x09, 0xE6, 0xF0, 0x32, 0x03, 0xA0, 0x37,
  0x10, 0x3C, 0x03, 0x20, 0x3A, 0x03, 0x71, 0x03, 0x80, 0xD0, 0xF0, 0x37, 0x10, 0x3A, 0x03, 0x20,
  0x3C, 0x03, 0x71, 0x03, 0xA0, 0x32, 0x03, 0xA0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_subtitles() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_subtitles_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_surround_sound 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_24_av_surround_sound_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDC, 0x0D, 0xFB, 0x0D, 0xF8, 0x16, 0x0B, 0xF9,
  0x81, 0xB0, 0x6D, 0x0C, 0x28, 0x90, 0xDF, 0xD5, 0x11, 0x5D, 0xFD, 0x20, 0xCC, 0x84, 0x60, 0x6F,
  0xD1, 0x48, 0x41, 0xDF, 0x50, 0x6C, 0x89, 0x62, 0x0B, 0xF5, 0x04, 0xDD, 0x40, 0x5F, 0xB0, 0x2C,
  0x28, 0x3E, 0xF1, 0x0D, 0xA8, 0x3D, 0x01, 0xFE, 0x2C, 0x28, 0x3E, 0xF1, 0x0D, 0xA8, 0x3D, 0x01,
  0xFE, 0x2C, 0x89, 0x62, 0x0B, 0xF5, 0x04, 0xDD, 0x40, 0x5F, 0xB0, 0x2C, 0x84, 0x60, 0x5F, 0xD1,
  0x48, 0x41, 0xDF, 0x60, 0x6C, 0x0C, 0x28, 0x90, 0xDF, 0xD5, 0x11, 0x5D, 0xFD, 0x20, 0xCD, 0x81,
  0x60, 0xBF, 0x98, 0x1B, 0x06, 0xF0, 0xDF, 0xB0, 0xDC, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0,
  0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_surround_sound() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_surround_sound_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_video_call 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_24_av_video_call_data[] PROGMEM = {
  0x0B, 0xFD, 0x0B, 0x4F, 0xF4, 0xE0, 0x03, 0xE1, 0x81, 0x2D, 0xCE, 0x2E, 0x01, 0x0D, 0xF9, 0x2E,
  0x0D, 0xE0, 0x36, 0x03, 0xFB, 0x03, 0x60, 0x3F, 0xE2, 0xE0, 0xDF, 0xA2, 0xE0, 0x10, 0xDF, 0x90,
  0x03, 0xE1, 0x81, 0x1D, 0xCF, 0xF4, 0x0B, 0xFD, 0x0B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 17), Box(0, 0, 23, 23),
      ic_round_24_av_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_videocam_off 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_24_av_videocam_off_data[] PROGMEM = {
  0x81, 0x29, 0x27, 0x72, 0x82, 0x7F, 0xD2, 0x77, 0x28, 0x2B, 0xFD, 0x27, 0x72, 0x82, 0xBF, 0xD2,
  0x77, 0x0B, 0xB8, 0x3D, 0x20, 0x2E, 0xC0, 0xB5, 0xD8, 0x3D, 0x20, 0x2E, 0xC5, 0xE8, 0x3D, 0x20,
  0x2E, 0xB1, 0x81, 0x2D, 0xC1, 0xF8, 0x3D, 0x20, 0x2E, 0xA0, 0x10, 0xDA, 0x1F, 0x98, 0x5D, 0x20,
  0x2E, 0xFD, 0xB1, 0xFA, 0x83, 0xD2, 0x02, 0xEC, 0x1F, 0xB8, 0x3D, 0x20, 0x2E, 0xB1, 0xFC, 0x83,
  0xD2, 0x02, 0xEA, 0x1F, 0xD8, 0x4D, 0x20, 0x2E, 0xD1, 0xFE, 0x0D, 0x02, 0x4F, 0xF0, 0xD0, 0x23,
  0x0B, 0xFD, 0x82, 0xEF, 0xD2, 0x77, 0x28, 0x2B, 0xFD, 0x27, 0x72, 0x81, 0xBF, 0x97, 0x73, 0x07,
  0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_videocam_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_videocam_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_videocam 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_round_24_av_videocam_data[] PROGMEM = {
  0x0B, 0xFD, 0x0B, 0x4F, 0xF4, 0xFF, 0x18, 0x12, 0xDC, 0xFF, 0x01, 0x0D, 0xFF, 0xA0, 0xD8, 0x0E,
  0x1F, 0x0D, 0xFF, 0xB0, 0x10, 0xDF, 0xFA, 0x18, 0x11, 0xDC, 0xFF, 0x40, 0xBF, 0xD0, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_videocam() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 17), Box(0, 0, 23, 23),
      ic_round_24_av_videocam_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_video_file 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_av_video_file_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xE0, 0x65, 0x0D, 0xF9, 0x81, 0xDF, 0x74, 0xFA, 0x82, 0x1D, 0xF7, 0x3F, 0xA1,
  0x82, 0x1D, 0xF7, 0x2F, 0xA2, 0x82, 0x1D, 0xF7, 0x1F, 0xA3, 0x82, 0x1D, 0xF6, 0xFA, 0x03, 0x38,
  0x11, 0xDE, 0x80, 0xE0, 0xF0, 0x34, 0x03, 0xFB, 0x60, 0xB0, 0x6F, 0x97, 0x1F, 0x97, 0x1F, 0x96,
  0x0B, 0x06, 0xF9, 0x03, 0x40, 0x38, 0x0C, 0x2F, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_video_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_av_video_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_video_label 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_24_av_video_label_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77,
  0x48, 0x09, 0x80, 0xF0, 0xDF, 0xFE, 0x81, 0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_video_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_av_video_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_video_library 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_24_av_video_library_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x4E, 0x0C, 0xFA, 0x00, 0xB2,
  0xE1, 0x09, 0xFB, 0x2E, 0x20, 0x50, 0xEF, 0x92, 0xE3, 0x02, 0x0C, 0xF2, 0xE5, 0x0A, 0xE2, 0xE5,
  0x0A, 0xE2, 0xE3, 0x02, 0x0C, 0xF2, 0xE2, 0x05, 0x0E, 0xF9, 0x2E, 0x10, 0x9F, 0xB2, 0xE0, 0xCF,
  0xC2, 0xFF, 0xC2, 0x0D, 0xFF, 0x0D, 0xA2, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xA7, 0x74, 0xA0, 0x37,
  0x73, 0x0D, 0xFF, 0x0B, 0x40, 0x40, 0xDF, 0xE0, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_video_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_av_video_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_video_settings 24x24, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_round_24_av_video_settings_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x2D, 0x40, 0xDF, 0xFE, 0x0D, 0x1A, 0x03, 0x77, 0x20, 0x3A, 0x1A, 0x77,
  0x4A, 0x1A, 0x60, 0xA0, 0x17, 0x3A, 0x1A, 0x69, 0x0E, 0x05, 0x72, 0xA1, 0xA6, 0xB0, 0xA0, 0x17,
  0xA1, 0xA6, 0xC0, 0xE0, 0x57, 0x2A, 0x6C, 0x0E, 0x05, 0x72, 0xA6, 0xB0, 0xA0, 0x13, 0x04, 0xA0,
  0x43, 0xA6, 0x90, 0xE0, 0x53, 0x81, 0x62, 0x9A, 0x81, 0x91, 0x61, 0xA6, 0x0A, 0x01, 0x30, 0x5F,
  0x90, 0x5A, 0x74, 0x0B, 0xB0, 0x09, 0xB0, 0xBA, 0x03, 0x73, 0x82, 0x1D, 0xF9, 0x28, 0x39, 0xFD,
  0x1D, 0xFB, 0x28, 0x21, 0xDF, 0x92, 0x84, 0x9F, 0xD1, 0x4D, 0xFA, 0x20, 0xBB, 0x00, 0x9B, 0x0B,
  0x76, 0x05, 0xF9, 0x04, 0x77, 0x81, 0x61, 0x9A, 0x81, 0x92, 0x57, 0x73, 0x04, 0xA0, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_video_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 23, 22), Box(0, 0, 23, 23),
      ic_round_24_av_video_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_volume_down 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_av_volume_down_data[] PROGMEM = {
  0x70, 0x05, 0x74, 0x07, 0xA7, 0x30, 0x7B, 0x72, 0x07, 0xC2, 0x0A, 0x20, 0xBF, 0x92, 0x90, 0xA1,
  0xFA, 0x2A, 0x03, 0xFA, 0x2A, 0x06, 0xFA, 0x2A, 0x06, 0xFA, 0x2A, 0x03, 0x0B, 0xF9, 0x29, 0x0A,
  0x50, 0x7C, 0x20, 0xA7, 0x07, 0xB7, 0x40, 0x7A, 0x75, 0x00, 0x55,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_volume_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 18, 18), Box(0, 0, 23, 23),
      ic_round_24_av_volume_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_volume_mute 24x24, 4-bit Alpha,  RLE, 22 bytes.
static const unsigned char ic_round_24_av_volume_mute_data[] PROGMEM = {
  0x70, 0x05, 0x60, 0x7A, 0x50, 0x7B, 0x40, 0x7C, 0x0B, 0x80, 0xD0, 0xF0, 0xBF, 0x94, 0x07, 0xC5,
  0x07, 0xB6, 0x07, 0xA7, 0x00, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_volume_mute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 5, 15, 18), Box(0, 0, 23, 23),
      ic_round_24_av_volume_mute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_volume_off 24x24, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_round_24_av_volume_off_data[] PROGMEM = {
  0x81, 0x38, 0x17, 0x10, 0x40, 0x35, 0x82, 0x8F, 0xC1, 0x78, 0x2E, 0xFB, 0x23, 0x83, 0x1C, 0xFC,
  0x12, 0x00, 0x52, 0x83, 0x6E, 0xFE, 0x33, 0x86, 0x1C, 0xFC, 0x10, 0x4E, 0x38, 0x31, 0xAF, 0xE2,
  0x38, 0x51, 0xCF, 0xC1, 0x04, 0x58, 0x1B, 0xFB, 0x48, 0x31, 0xEF, 0xC1, 0x30, 0xA2, 0x83, 0x1E,
  0xF4, 0xBE, 0x0C, 0x01, 0x29, 0x0A, 0x28, 0x18, 0xF9, 0xF9, 0x89, 0x0C, 0x10, 0x4F, 0x30, 0x3F,
  0xDF, 0xA8, 0x7C, 0x10, 0x46, 0x01, 0xFE, 0xFB, 0x0C, 0x01, 0x49, 0x0E, 0xFA, 0x82, 0xCF, 0xC1,
  0x28, 0x22, 0xFC, 0xBF, 0x98, 0x71, 0xCF, 0xC1, 0x03, 0xF9, 0x40, 0x7C, 0x18, 0x61, 0xCF, 0xC1,
  0x04, 0x35, 0x07, 0xB2, 0x83, 0x1C, 0xFC, 0x17, 0x10, 0x7A, 0x30, 0x2A, 0x0C, 0x01, 0x71, 0x00,
  0x52, 0x06, 0x0E, 0xB0, 0xC0, 0x17, 0x48, 0x5E, 0xFB, 0x3C, 0xF8, 0x74, 0x00, 0x32, 0x81, 0x18,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_volume_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_volume_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_volume_up 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_24_av_volume_up_data[] PROGMEM = {
  0x74, 0x04, 0x03, 0x77, 0x28, 0x2E, 0xFB, 0x27, 0x30, 0x05, 0x28, 0x36, 0xEF, 0xE3, 0x71, 0x07,
  0xA3, 0x83, 0x1A, 0xFE, 0x26, 0x07, 0xB5, 0x81, 0xBF, 0xB5, 0x07, 0xC2, 0x0A, 0x28, 0x31, 0xEF,
  0x4B, 0xF9, 0x29, 0x0A, 0x28, 0x18, 0xF9, 0xFA, 0x2A, 0x83, 0x30, 0x3F, 0xDF, 0xA2, 0xA8, 0x36,
  0x01, 0xFE, 0xFA, 0x2A, 0x83, 0x60, 0x1F, 0xEF, 0xA2, 0xA8, 0x43, 0x03, 0xFD, 0xBF, 0x92, 0x90,
  0xA2, 0x81, 0x8F, 0x94, 0x07, 0xC2, 0x0A, 0x28, 0x21, 0xEF, 0x45, 0x07, 0xB5, 0x81, 0xBF, 0xB7,
  0x07, 0xA3, 0x83, 0x1A, 0xFE, 0x27, 0x10, 0x05, 0x28, 0x36, 0xEF, 0xE3, 0x76, 0x82, 0xEF, 0xB2,
  0x77, 0x04, 0x03, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_volume_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_av_volume_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_web_asset_off 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_24_av_web_asset_off_data[] PROGMEM = {
  0x03, 0x04, 0x77, 0x58, 0x1C, 0xF7, 0x77, 0x40, 0x5A, 0x07, 0x20, 0xAF, 0xD8, 0x2D, 0x40, 0xDA,
  0x07, 0x20, 0xAF, 0xD0, 0xD1, 0xC0, 0x72, 0x0A, 0xFD, 0x1D, 0x07, 0x20, 0xAF, 0xC1, 0xA1, 0x05,
  0xA0, 0x77, 0x4A, 0x1A, 0x20, 0x5A, 0x07, 0x73, 0xA1, 0xA3, 0x05, 0xA0, 0x77, 0x2A, 0x1A, 0x40,
  0x5A, 0x07, 0x71, 0xA1, 0xA5, 0x05, 0xA0, 0x77, 0xA1, 0xA6, 0x05, 0xA0, 0x76, 0xA1, 0xA7, 0x05,
  0xA0, 0x75, 0xA1, 0xA7, 0x10, 0x5A, 0x07, 0x4A, 0x1A, 0x72, 0x05, 0xA0, 0x73, 0xA1, 0xA7, 0x30,
  0x5A, 0x07, 0x28, 0x2A, 0xF0, 0xDF, 0xF9, 0x07, 0x28, 0x28, 0x04, 0xDF, 0xF9, 0x07, 0x77, 0x40,
  0x5A, 0x07, 0x77, 0x40, 0x5A, 0x04, 0x77, 0x48, 0x15, 0xC2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_web_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_av_web_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_web_asset 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_round_24_av_web_asset_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xC2, 0xF7, 0x7C, 0x77, 0xC7, 0x7C, 0x77,
  0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x03, 0x75, 0x03, 0xA0, 0xDF, 0xFA, 0x81, 0xD4,
  0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_web_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_av_web_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_av_web 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_av_web_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0F, 0x2F, 0x73, 0x81, 0x7F, 0x73, 0xC7,
  0x38, 0x17, 0xF7, 0x3C, 0x73, 0x81, 0x7F, 0x73, 0xC8, 0x06, 0x78, 0x1B, 0xF7, 0x3F, 0xFA, 0x07,
  0x3C, 0x80, 0x67, 0x81, 0xBF, 0x73, 0xC7, 0x38, 0x17, 0xF7, 0x3C, 0x73, 0x81, 0x7F, 0x73, 0xC0,
  0x37, 0x28, 0x17, 0xF7, 0x20, 0x3A, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_av_web() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_av_web_data, Alpha4(color::Black));
  return value;
}
