#include "places.h"

using namespace roo_display;

// Image file ic_round_18_places_ac_unit 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_places_ac_unit_data[] PROGMEM = {
  0x30, 0x12, 0x00, 0x92, 0x01, 0x68, 0x6A, 0xD1, 0xAA, 0x1D, 0x96, 0x86, 0x1D, 0xDB, 0xBD, 0xD1,
  0x38, 0x41, 0x91, 0x01, 0xDA, 0x8A, 0x1D, 0x10, 0x1A, 0x10, 0xDD, 0x10, 0x1D, 0xD1, 0x01, 0xDD,
  0x28, 0xE4, 0x1D, 0xD1, 0x0A, 0xA0, 0x1D, 0xD1, 0x09, 0x9B, 0xFD, 0x9D, 0xD9, 0xDF, 0xB9, 0x99,
  0x9B, 0xFD, 0x9D, 0xD9, 0xDF, 0xB9, 0x90, 0x1D, 0xD1, 0x0A, 0xA0, 0x1D, 0xD1, 0x28, 0xA1, 0xDD,
  0x10, 0x1D, 0xD1, 0x01, 0xDD, 0x01, 0xA1, 0x01, 0xDA, 0x84, 0xD1, 0x01, 0xA1, 0x38, 0x61, 0xDD,
  0xBB, 0xDD, 0x16, 0x86, 0xAD, 0x1A, 0xA1, 0xDA, 0x60, 0x12, 0x00, 0x92, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_ac_unit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_ac_unit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_airport_shuttle 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_places_airport_shuttle_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x50, 0x46, 0x0E, 0xFC, 0x07, 0x48, 0x11, 0xF3, 0x29, 0x04, 0x29, 0x83, 0x50,
  0x6F, 0x73, 0x81, 0x1F, 0x32, 0x90, 0x42, 0x90, 0x52, 0x81, 0x6F, 0x72, 0x8A, 0x11, 0xFC, 0xBB,
  0xFC, 0xBB, 0xFC, 0xBB, 0xBE, 0xF7, 0x01, 0xFF, 0xA1, 0x01, 0xFF, 0xA0, 0x11, 0xB0, 0x0E, 0xE0,
  0x0E, 0xB2, 0x89, 0x66, 0xCF, 0x24, 0xFC, 0xBB, 0xCF, 0x42, 0xFC, 0x63, 0x83, 0x1F, 0xAB, 0xE4,
  0x83, 0xEB, 0xAF, 0x15, 0x82, 0x5D, 0xC4, 0x48, 0x24, 0xCD, 0x53,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_airport_shuttle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 13), Box(0, 0, 17, 17),
      ic_round_18_places_airport_shuttle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_all_inclusive 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_places_all_inclusive_data[] PROGMEM = {
  0x18, 0x41, 0xAE, 0xEA, 0x24, 0x89, 0x52, 0xAE, 0xEA, 0x10, 0x1E, 0xC6, 0x5C, 0xE3, 0x28, 0x90,
  0x4E, 0xC5, 0x6C, 0xE1, 0xAD, 0x48, 0x49, 0x60, 0x5F, 0xA4, 0x82, 0xCA, 0xD7, 0x68, 0x17, 0xF8,
  0x58, 0x26, 0xDD, 0x75, 0x81, 0x8F, 0x76, 0x82, 0x6D, 0xAD, 0x48, 0x4A, 0xF5, 0x06, 0x94, 0x89,
  0x0C, 0xA1, 0xEC, 0x65, 0xCE, 0x42, 0x89, 0x53, 0xEC, 0x56, 0xCE, 0x10, 0x1A, 0xEE, 0xA2, 0x48,
  0x42, 0xBE, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_all_inclusive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 5, 17, 12), Box(0, 0, 17, 17),
      ic_round_18_places_all_inclusive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_apartment 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_places_apartment_data[] PROGMEM = {
  0x40, 0x18, 0x01, 0x50, 0x17, 0x0A, 0xD0, 0x87, 0x85, 0xAF, 0x6E, 0x7F, 0x94, 0x89, 0x09, 0xBB,
  0xEF, 0xBF, 0xCF, 0x93, 0x04, 0xD8, 0x35, 0xE6, 0xF9, 0x38, 0x24, 0xF8, 0xAA, 0x89, 0x2D, 0xFD,
  0xFE, 0xDC, 0x14, 0xFE, 0xEA, 0x89, 0x23, 0xE4, 0xFE, 0xEF, 0x44, 0xF9, 0xAE, 0x86, 0xA9, 0xF4,
  0x4F, 0xDD, 0xB0, 0xBA, 0x86, 0xDD, 0xF4, 0x4F, 0xAB, 0xB0, 0x1A, 0x83, 0xBA, 0xF4, 0x3E, 0x01,
  0xD8, 0x13, 0x04, 0x80, 0x15, 0x18, 0x00, 0x50, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_apartment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_places_apartment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_baby_changing_station 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_places_baby_changing_station_data[] PROGMEM = {
  0x30, 0x01, 0x74, 0x03, 0xA0, 0x37, 0x30, 0x6A, 0x06, 0x74, 0x00, 0x97, 0x40, 0x60, 0x57, 0x40,
  0x7A, 0x81, 0xD7, 0x17, 0x10, 0xDA, 0x0C, 0xB0, 0x55, 0x03, 0xA8, 0x4E, 0x02, 0x77, 0x15, 0x08,
  0xA8, 0x69, 0x1A, 0xB6, 0x06, 0x63, 0x0B, 0xA8, 0x92, 0x41, 0xAE, 0xC3, 0xCB, 0x03, 0x0B, 0xA0,
  0x32, 0x0B, 0xB8, 0x3B, 0x5F, 0x9B, 0xA0, 0x32, 0x87, 0x4E, 0xFE, 0x43, 0xE7, 0xBA, 0x03, 0x18,
  0x04, 0x30, 0x10, 0xBA, 0x03, 0x02, 0xF9, 0x09, 0x0B, 0xA0, 0x31, 0x80, 0x43, 0x01, 0x0B, 0xA0,
  0x37, 0x38, 0x13, 0x76, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_baby_changing_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_places_baby_changing_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_backpack 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_places_backpack_data[] PROGMEM = {
  0x20, 0x20, 0x64, 0x06, 0x02, 0x48, 0x1A, 0xF7, 0x28, 0x17, 0xFA, 0x30, 0x80, 0xEE, 0x82, 0xE8,
  0x08, 0xFB, 0x08, 0x0E, 0xFB, 0x0E, 0x80, 0xC1, 0xF0, 0xA7, 0x10, 0xAA, 0x0D, 0x80, 0x37, 0x10,
  0x7F, 0xB0, 0x20, 0xA8, 0x0C, 0x1F, 0x0D, 0xFB, 0x0D, 0x02, 0x80, 0x67, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_backpack() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_places_backpack_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_balcony 18x18, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_round_18_places_balcony_data[] PROGMEM = {
  0x60, 0x20, 0x17, 0x30, 0x80, 0xEA, 0x0E, 0x08, 0x78, 0x7B, 0xE7, 0xBB, 0x7E, 0xC1, 0x48, 0x90,
  0x8E, 0x20, 0xAA, 0x02, 0xEA, 0x38, 0x11, 0xF5, 0x20, 0x0A, 0x28, 0x15, 0xF1, 0x28, 0x14, 0xF1,
  0x20, 0x0A, 0x28, 0x11, 0xF5, 0x28, 0x92, 0x6E, 0x02, 0x1A, 0xA1, 0x20, 0xE6, 0x28, 0x92, 0x6E,
  0x08, 0x7A, 0xA7, 0x80, 0xE6, 0x20, 0x60, 0xE3, 0x00, 0xA3, 0x0E, 0x06, 0x28, 0x95, 0x6E, 0x33,
  0x3B, 0xB3, 0x33, 0xE6, 0x01, 0xEF, 0xB8, 0xD4, 0xE1, 0x4F, 0x28, 0xD1, 0xBB, 0x1D, 0x82, 0xF4,
  0x4F, 0x07, 0xD0, 0xAA, 0x0D, 0x70, 0xF4, 0x4F, 0x28, 0xD1, 0xBB, 0x1D, 0x82, 0xF4, 0x1E, 0xFB,
  0x82, 0xE1, 0x01, 0x80, 0x63, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_balcony() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_places_balcony_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_bathtub 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_places_bathtub_data[] PROGMEM = {
  0x73, 0x03, 0x74, 0x83, 0x2D, 0xAD, 0x14, 0x06, 0x04, 0x28, 0x46, 0xF3, 0x08, 0x53, 0x06, 0xA0,
  0x12, 0x06, 0x20, 0x70, 0x63, 0x81, 0x4F, 0xE6, 0x07, 0x06, 0x40, 0x17, 0x07, 0x06, 0x38, 0x12,
  0xCA, 0x60, 0x70, 0x62, 0x01, 0x08, 0xA8, 0x90, 0xB2, 0x11, 0x11, 0x87, 0x04, 0xFD, 0x00, 0x4F,
  0xD0, 0x04, 0xFD, 0x04, 0x03, 0xFD, 0x81, 0x30, 0x8F, 0xB0, 0x82, 0x01, 0x80, 0x63, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_bathtub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_bathtub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_beach_access 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_places_beach_access_data[] PROGMEM = {
  0x68, 0x21, 0x33, 0x17, 0x01, 0x0A, 0xC0, 0xB0, 0x47, 0x02, 0x08, 0xC0, 0x33, 0x85, 0xDF, 0xC6,
  0x02, 0xBA, 0x81, 0x20, 0x11, 0xC8, 0x3D, 0x50, 0x74, 0x28, 0x1A, 0x0C, 0xD0, 0x93, 0x82, 0x1F,
  0x26, 0xD0, 0x43, 0x83, 0x3F, 0x80, 0xDB, 0x04, 0x40, 0x3A, 0x02, 0x04, 0xA8, 0x14, 0x67, 0x30,
  0x1A, 0x86, 0xB0, 0x84, 0x07, 0xF7, 0x30, 0xBA, 0x07, 0x48, 0x17, 0xF7, 0x20, 0x4A, 0x04, 0x58,
  0x17, 0xF6, 0x20, 0x02, 0x70, 0x70, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_beach_access() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_places_beach_access_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_bento 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_places_bento_data[] PROGMEM = {
  0x10, 0x18, 0x03, 0x38, 0x61, 0x03, 0x33, 0x10, 0x3F, 0x90, 0x71, 0xC0, 0x30, 0x7F, 0x90, 0x71,
  0xC0, 0x07, 0xF9, 0x07, 0x1C, 0x00, 0x7B, 0x00, 0xEB, 0x07, 0x1C, 0x00, 0x7A, 0x82, 0xE1, 0x1E,
  0xA8, 0x67, 0x03, 0x33, 0x31, 0x7A, 0x82, 0xE1, 0x1E, 0xA8, 0x67, 0x03, 0x33, 0x31, 0x7B, 0x00,
  0xEB, 0x07, 0x1C, 0x00, 0x7F, 0x90, 0x71, 0xC0, 0x07, 0xF9, 0x07, 0x1C, 0x07, 0x03, 0xF9, 0x07,
  0x1C, 0x81, 0x30, 0x18, 0x03, 0x38, 0x41, 0x03, 0x33, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_bento() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_places_bento_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_bungalow 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_places_bungalow_data[] PROGMEM = {
  0x40, 0x05, 0x70, 0x2A, 0x02, 0x60, 0xBA, 0x0B, 0x50, 0x5C, 0x05, 0x30, 0x10, 0xEC, 0x0E, 0x01,
  0x20, 0x9E, 0x81, 0x90, 0x3B, 0x00, 0x7B, 0x03, 0x0D, 0xB0, 0x0D, 0xB8, 0x1D, 0xAB, 0xA0, 0x0D,
  0xA8, 0x2B, 0xA0, 0x9A, 0x00, 0x5A, 0x09, 0x20, 0x9A, 0x00, 0x5A, 0x09, 0x20, 0x8A, 0x00, 0x5A,
  0x08, 0x38, 0x43, 0x31, 0x13, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_bungalow() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_places_bungalow_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_business_center 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_places_business_center_data[] PROGMEM = {
  0x58, 0x42, 0x33, 0x33, 0x27, 0x20, 0x5E, 0x05, 0x71, 0x86, 0x9C, 0x11, 0x11, 0xC9, 0x58, 0x96,
  0x47, 0x7C, 0xD7, 0x77, 0x7D, 0xC7, 0x74, 0x01, 0xFF, 0x01, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03,
  0xC8, 0x4E, 0x31, 0x13, 0xEC, 0x89, 0x73, 0x19, 0x99, 0x97, 0x07, 0x70, 0x79, 0x99, 0x91, 0x70,
  0x0D, 0x70, 0x3C, 0x84, 0xB0, 0x33, 0x0B, 0xC0, 0x03, 0xD8, 0x27, 0x55, 0x7D, 0x00, 0x3F, 0xF8,
  0x13, 0x1E, 0xFD, 0x82, 0xE1, 0x01, 0x80, 0x90, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_business_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_places_business_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_cabin 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_places_cabin_data[] PROGMEM = {
  0x40, 0x70, 0x37, 0x38, 0x29, 0xEF, 0x37, 0x28, 0x51, 0xE6, 0x20, 0x66, 0x73, 0x01, 0x0A, 0xA0,
  0xA6, 0x89, 0x04, 0xD3, 0xDE, 0x55, 0xED, 0x34, 0x06, 0xFA, 0x06, 0x38, 0x1A, 0xF8, 0x80, 0x23,
  0x83, 0x8F, 0x90, 0xCA, 0x80, 0x47, 0xA8, 0x1C, 0x88, 0x98, 0x04, 0xD9, 0x83, 0x88, 0x06, 0xE7,
  0x10, 0xE0, 0x62, 0x06, 0x98, 0x04, 0xB9, 0x06, 0x20, 0x69, 0x80, 0x49, 0x90, 0x62, 0x06, 0x0E,
  0x71, 0x0E, 0x06, 0x20, 0x5F, 0xB0, 0x53, 0x80, 0x63, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_cabin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_cabin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_carpenter 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_places_carpenter_data[] PROGMEM = {
  0x20, 0x20, 0x67, 0x48, 0x23, 0xEF, 0x97, 0x20, 0x20, 0xEB, 0x09, 0x71, 0x04, 0xD0, 0x97, 0x10,
  0xAD, 0x09, 0x70, 0x10, 0xDD, 0x09, 0x70, 0x4E, 0x09, 0x70, 0x8E, 0x09, 0x70, 0xCE, 0x09, 0x60,
  0x3D, 0x81, 0xDF, 0x96, 0x07, 0xB8, 0x3C, 0x08, 0xF2, 0x68, 0x5C, 0xFC, 0x02, 0xDD, 0x78, 0x5E,
  0xC0, 0x2D, 0xE2, 0x78, 0x4C, 0xE5, 0xDE, 0x27, 0x18, 0x31, 0xDF, 0xE2, 0x73, 0x81, 0x15, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_carpenter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_places_carpenter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_casino 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_places_casino_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xA0, 0xC0, 0xEC, 0x0E, 0x0C, 0xA8, 0x44,
  0x4F, 0xC0, 0x2C, 0x89, 0x02, 0x0C, 0xF4, 0x4F, 0xE2, 0x5C, 0x84, 0x52, 0xEF, 0x44, 0xD0, 0x0E,
  0xD0, 0x04, 0xC8, 0x2E, 0x11, 0xEC, 0x00, 0x4C, 0x82, 0xE1, 0x1E, 0xC0, 0x04, 0xD0, 0x0E, 0xD8,
  0x44, 0x4F, 0xE2, 0x5C, 0x89, 0x05, 0x2E, 0xF4, 0x4F, 0xC0, 0x2C, 0x84, 0x20, 0xCF, 0x44, 0xA0,
  0xC0, 0xEC, 0x0E, 0x0C, 0xA0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_casino() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_casino_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_chalet 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_places_chalet_data[] PROGMEM = {
  0x74, 0x01, 0x75, 0x81, 0x69, 0x37, 0x38, 0x34, 0x2A, 0x04, 0x71, 0x84, 0x4C, 0x8B, 0xB8, 0x48,
  0x13, 0xA2, 0x28, 0x37, 0x08, 0x25, 0x38, 0x34, 0xEF, 0xE2, 0x28, 0x17, 0xB4, 0x30, 0x40, 0xEB,
  0x0E, 0x02, 0x20, 0x33, 0x04, 0x0E, 0xD0, 0xE0, 0x24, 0x03, 0x0E, 0xB0, 0xEB, 0x0E, 0x01, 0x30,
  0x30, 0x8A, 0x85, 0xC0, 0xEF, 0xD9, 0x15, 0xA8, 0x3B, 0x0D, 0xFC, 0x78, 0x5E, 0xFB, 0x0D, 0xFB,
  0x78, 0x53, 0x54, 0x05, 0x52, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_chalet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_places_chalet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_charging_station 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_places_charging_station_data[] PROGMEM = {
  0x28, 0x04, 0x32, 0x01, 0x0E, 0xF9, 0x81, 0xE1, 0x3F, 0xB0, 0x03, 0xFB, 0x82, 0x33, 0xF9, 0x80,
  0x27, 0x84, 0x9F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x32, 0x00, 0x22, 0x84, 0x3F, 0x33, 0xF3,
  0x20, 0xB0, 0x52, 0x8B, 0x43, 0xF3, 0x3F, 0x30, 0x3F, 0xD6, 0x03, 0xF3, 0x3F, 0x30, 0x6D, 0xF3,
  0x03, 0xF3, 0x3F, 0x32, 0x05, 0x0B, 0x28, 0x43, 0xF3, 0x3F, 0x32, 0x00, 0x22, 0x84, 0x3F, 0x33,
  0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x98, 0x02, 0x78, 0x29, 0xF3, 0x3F, 0xB0, 0x03, 0xFB, 0x81, 0x31,
  0xEF, 0x90, 0xE0, 0x12, 0x80, 0x43, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_charging_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_places_charging_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_checkroom 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_places_checkroom_data[] PROGMEM = {
  0x68, 0x27, 0xEE, 0x77, 0x48, 0x44, 0xFA, 0xAF, 0x57, 0x30, 0x20, 0x72, 0x0E, 0x08, 0x75, 0x82,
  0x16, 0xF6, 0x75, 0x81, 0xAF, 0xA7, 0x60, 0xB0, 0xC7, 0x60, 0x9A, 0x09, 0x73, 0x86, 0x2C, 0xF7,
  0x7F, 0xC2, 0x78, 0x25, 0xEE, 0x42, 0x82, 0x4E, 0xE5, 0x58, 0x29, 0xFB, 0x14, 0x82, 0x1B, 0xF9,
  0x28, 0x21, 0xCF, 0xE8, 0x04, 0x78, 0x3E, 0xFC, 0x15, 0xFF, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_checkroom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_places_checkroom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_child_care 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_places_child_care_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x58, 0x90, 0x5F, 0xCB, 0x71, 0x4B, 0xF5,
  0x38, 0x92, 0x3F, 0x90, 0x4D, 0xC1, 0x08, 0xF3, 0x20, 0xB0, 0xC3, 0x00, 0x23, 0x87, 0xBB, 0x01,
  0xF5, 0x05, 0x92, 0x89, 0x29, 0x50, 0x4F, 0x13, 0xF2, 0x07, 0xC2, 0x87, 0xC7, 0x01, 0xF3, 0x3F,
  0x17, 0x18, 0x51, 0xF3, 0x1F, 0x41, 0x80, 0x29, 0x87, 0x14, 0xF1, 0x0B, 0xB0, 0x8C, 0x82, 0x80,
  0xBB, 0x28, 0x92, 0x3F, 0x80, 0x38, 0x83, 0x08, 0xF3, 0x38, 0x90, 0x5F, 0xB4, 0x11, 0x4B, 0xF5,
  0x50, 0x30, 0xBC, 0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_child_care() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_child_care_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_child_friendly 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_places_child_friendly_data[] PROGMEM = {
  0x20, 0x24, 0x81, 0x12, 0x14, 0x85, 0x4E, 0xFE, 0x40, 0xBB, 0x0B, 0x01, 0x28, 0x6E, 0xA3, 0xBE,
  0x22, 0xEA, 0x0A, 0x30, 0x52, 0x85, 0x9F, 0xD1, 0x4F, 0xA7, 0x09, 0xA8, 0x1B, 0x04, 0x71, 0x09,
  0xB0, 0x97, 0x20, 0x9C, 0x06, 0x71, 0x09, 0xD0, 0x47, 0x09, 0xD0, 0xE0, 0x26, 0x07, 0xE0, 0xD0,
  0x15, 0x02, 0xF0, 0xB6, 0x06, 0xF0, 0x46, 0x02, 0x06, 0x80, 0x17, 0x58, 0x15, 0xF6, 0x58, 0x1A,
  0xE1, 0x38, 0x17, 0xF7, 0x58, 0x1C, 0xF2, 0x40, 0x27, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_child_friendly() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_places_child_friendly_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_corporate_fare 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_18_places_corporate_fare_data[] PROGMEM = {
  0x10, 0x98, 0x01, 0xB0, 0x47, 0x18, 0x66, 0xFB, 0xBB, 0xBD, 0xE7, 0x10, 0x79, 0x40, 0x79, 0x71,
  0x85, 0x7F, 0xBB, 0xBB, 0xD9, 0x80, 0x2B, 0x87, 0x90, 0x7F, 0xBB, 0xBB, 0xD9, 0x80, 0x2B, 0x90,
  0x60, 0x79, 0x40, 0x79, 0x69, 0x8C, 0x07, 0x7F, 0xBB, 0xBB, 0xDF, 0x05, 0xBB, 0x50, 0xF7, 0x7F,
  0xBB, 0xBB, 0xDF, 0x05, 0xBB, 0x50, 0xF7, 0x79, 0x40, 0x79, 0x69, 0x8C, 0x07, 0x7F, 0xBB, 0xBB,
  0xDF, 0x05, 0xBB, 0x50, 0xF7, 0x7F, 0xBB, 0xBB, 0xDF, 0x05, 0xBB, 0x50, 0xF7, 0x79, 0x40, 0x79,
  0x69, 0x86, 0x76, 0xFB, 0xBB, 0xBD, 0x98, 0x02, 0xB9, 0x81, 0x60, 0x98, 0x09, 0x0B, 0x09, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_corporate_fare() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_places_corporate_fare_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_cottage 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_places_cottage_data[] PROGMEM = {
  0x40, 0x70, 0x37, 0x38, 0x29, 0xEF, 0x37, 0x28, 0x51, 0xE6, 0x20, 0x66, 0x73, 0x01, 0x0A, 0xA0,
  0xA6, 0x82, 0x4D, 0x3D, 0xC0, 0xD0, 0x34, 0x06, 0xFA, 0x06, 0x30, 0xAF, 0xB8, 0x19, 0x0C, 0xFD,
  0x81, 0xC8, 0x8F, 0xB8, 0x28, 0x80, 0x6F, 0xB0, 0x62, 0x06, 0xC0, 0x09, 0xC0, 0x62, 0x06, 0xC0,
  0x05, 0xC0, 0x62, 0x06, 0xC0, 0x05, 0xC0, 0x62, 0x05, 0xC0, 0x05, 0xC0, 0x53, 0x80, 0x03, 0x00,
  0x18, 0x00, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_cottage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_cottage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_countertops 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_places_countertops_data[] PROGMEM = {
  0x20, 0xCB, 0x84, 0x50, 0x3D, 0xE8, 0x6C, 0x85, 0x70, 0xBD, 0xAF, 0x45, 0xC8, 0x57, 0x01, 0x10,
  0xF7, 0x50, 0xDB, 0x05, 0x49, 0x07, 0x38, 0x11, 0x79, 0xA0, 0xD8, 0x01, 0x79, 0x83, 0xB7, 0x71,
  0x5F, 0xF0, 0x52, 0xD0, 0x03, 0xD4, 0xD0, 0x03, 0xD4, 0xD0, 0x03, 0xD4, 0xD0, 0x03, 0xD4, 0xD0,
  0x09, 0xD4, 0x0C, 0xFB, 0x0C, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_countertops() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_places_countertops_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_crib 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_places_crib_data[] PROGMEM = {
  0x28, 0x23, 0x55, 0x17, 0x09, 0xB0, 0xD6, 0x03, 0xD6, 0x06, 0xD6, 0x06, 0xD8, 0x00, 0xB8, 0x1A,
  0x06, 0xFB, 0x05, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x2E, 0xF9, 0x0E, 0x02, 0x28, 0x61, 0xBA,
  0x11, 0xAB, 0x13, 0x82, 0x54, 0xAA, 0x28, 0x2A, 0xB4, 0x52, 0x07, 0xA8, 0x2B, 0x33, 0xBA, 0x07,
  0x30, 0x40, 0xBC, 0x0B, 0x04, 0x70, 0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_crib() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_places_crib_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_desk 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_places_desk_data[] PROGMEM = {
  0x10, 0x68, 0x09, 0x07, 0x81, 0x60, 0x29, 0x80, 0x4D, 0x90, 0xFD, 0x98, 0x22, 0x3F, 0x26, 0x89,
  0x03, 0xF2, 0x02, 0xF3, 0x3F, 0x26, 0x89, 0x03, 0xF7, 0x57, 0xF3, 0x3F, 0x26, 0x03, 0xD8, 0x23,
  0x3F, 0x26, 0x89, 0x03, 0xF2, 0x02, 0xF3, 0x3F, 0x26, 0x89, 0x03, 0xF5, 0x35, 0xF3, 0x3F, 0x26,
  0x03, 0xD8, 0x23, 0x3F, 0x26, 0x87, 0x3F, 0x31, 0x3F, 0x30, 0x67, 0x10, 0x63, 0x06, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_desk() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_places_desk_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_do_not_step 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_places_do_not_step_data[] PROGMEM = {
  0x10, 0x30, 0x56, 0x81, 0x8D, 0x56, 0x81, 0x7F, 0x74, 0x0A, 0xB0, 0x56, 0x81, 0x9F, 0x72, 0x0A,
  0xD0, 0x56, 0x83, 0x9F, 0x70, 0x5E, 0x05, 0x68, 0x39, 0xF7, 0x05, 0xE0, 0x56, 0x83, 0x9F, 0x70,
  0x5C, 0x81, 0xD3, 0x35, 0x84, 0x49, 0xF7, 0x05, 0xA8, 0x2D, 0x3D, 0x84, 0x81, 0x1C, 0x7A, 0x86,
  0x70, 0x5D, 0x3D, 0xE2, 0x38, 0x11, 0xC5, 0xC0, 0x72, 0x81, 0xDE, 0x32, 0x82, 0x3B, 0xC5, 0xE8,
  0x27, 0x05, 0x32, 0x01, 0xFA, 0x81, 0xBF, 0x74, 0x03, 0xF9, 0x83, 0x50, 0x9F, 0x74, 0x0B, 0xD0,
  0xE0, 0x53, 0x81, 0x9F, 0x77, 0x71, 0x81, 0x9F, 0x57, 0x71, 0x07, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_do_not_step() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_do_not_step_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_do_not_touch 18x18, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_18_places_do_not_touch_data[] PROGMEM = {
  0x70, 0x17, 0x79, 0x81, 0xA1, 0x64, 0x03, 0x05, 0x28, 0x64, 0x91, 0xFB, 0x7F, 0x53, 0x89, 0x47,
  0xF7, 0x05, 0xF3, 0xFB, 0x7F, 0x5A, 0xB2, 0x89, 0x29, 0xF7, 0x05, 0x3F, 0xB7, 0xF5, 0xD9, 0x38,
  0x91, 0x9F, 0x70, 0x1F, 0xB7, 0xF5, 0xD9, 0x48, 0x90, 0x9F, 0x70, 0x5B, 0x7F, 0x5D, 0x95, 0x87,
  0xCF, 0x70, 0x37, 0xF5, 0xD9, 0x50, 0xBA, 0x83, 0x70, 0x4F, 0xDA, 0x28, 0x26, 0x50, 0xBB, 0x81,
  0x70, 0x5B, 0x10, 0x3A, 0x0C, 0x0D, 0xC8, 0x17, 0x05, 0xA2, 0x07, 0xF9, 0x81, 0x70, 0x59, 0x30,
  0x8F, 0x98, 0x17, 0x05, 0x40, 0x8F, 0x90, 0x76, 0x09, 0xF9, 0x07, 0x60, 0xAF, 0x90, 0x56, 0x05,
  0x80, 0x17, 0x81, 0x57, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_do_not_touch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_places_do_not_touch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_dry 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_places_dry_data[] PROGMEM = {
  0x73, 0x06, 0x20, 0x67, 0x58, 0x42, 0xF2, 0x2F, 0x37, 0x58, 0x3E, 0x90, 0xE9, 0x78, 0x11, 0xB7,
  0x28, 0x44, 0xF4, 0x4F, 0x45, 0x82, 0x2D, 0xFB, 0x38, 0x3B, 0x90, 0xB9, 0x40, 0x20, 0xDA, 0x03,
  0x38, 0x35, 0x60, 0x56, 0x30, 0x30, 0xEA, 0x0D, 0x80, 0x37, 0x04, 0x30, 0x30, 0xEF, 0xC0, 0xE3,
  0x0E, 0xF8, 0x46, 0x55, 0x55, 0x22, 0x03, 0xF9, 0x80, 0x3D, 0x00, 0x3F, 0xF8, 0x1E, 0x43, 0xF9,
  0x05, 0x80, 0x13, 0x20, 0x3F, 0xF8, 0x1A, 0x03, 0xF9, 0x0A, 0x80, 0x19, 0x81, 0x30, 0x2F, 0x98,
  0x3A, 0x99, 0x98, 0x40, 0x9F, 0xD0, 0x24, 0x02, 0x80, 0x63, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_dry() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_places_dry_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_elevator 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_places_elevator_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD0, 0xA0, 0xBA, 0x0E, 0x09, 0xF9, 0x00, 0xBA, 0x81,
  0x80, 0xCB, 0x0B, 0xB0, 0x0B, 0xA0, 0xE0, 0xBB, 0x81, 0xC0, 0x9A, 0x85, 0xBB, 0xFE, 0x41, 0x6A,
  0x03, 0x28, 0x4E, 0xFB, 0xBF, 0x83, 0x83, 0xCF, 0xCB, 0xBA, 0x82, 0xBB, 0xF7, 0x38, 0x3B, 0xFC,
  0xBB, 0xA8, 0x5B, 0xBF, 0xD2, 0x04, 0xA8, 0x53, 0x01, 0xEF, 0xBB, 0xA8, 0x13, 0x07, 0xA8, 0x1C,
  0x09, 0xA0, 0x0B, 0xA8, 0x14, 0x07, 0xB0, 0xBB, 0x00, 0xBA, 0x81, 0xC7, 0xDF, 0x0B, 0x0A, 0xFD,
  0x81, 0xA2, 0xA8, 0x06, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_elevator() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_elevator_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_escalator 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_places_escalator_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD0, 0xA0, 0xBF, 0x85, 0x97, 0x7C, 0xFB, 0xBE, 0x0B,
  0x38, 0x22, 0xFB, 0xBE, 0x86, 0x20, 0x23, 0x9F, 0xBB, 0xD0, 0x92, 0x0D, 0xB0, 0x0B, 0xC8, 0x2E,
  0x10, 0x7C, 0x00, 0xBC, 0x82, 0x70, 0x1E, 0xC0, 0x0B, 0xB0, 0xD2, 0x09, 0xD8, 0x6B, 0xBF, 0x93,
  0x20, 0x2E, 0x82, 0xBB, 0xF2, 0x30, 0xBE, 0x85, 0xBB, 0xFC, 0x77, 0x9F, 0x0B, 0x0A, 0xFD, 0x81,
  0xA2, 0xA8, 0x06, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_escalator() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_escalator_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_escalator_warning 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_places_escalator_warning_data[] PROGMEM = {
  0x20, 0x60, 0x47, 0x30, 0x7A, 0x03, 0x72, 0x07, 0xA0, 0x37, 0x30, 0x60, 0x47, 0x28, 0x32, 0xAB,
  0xB9, 0x71, 0x0A, 0xC0, 0x83, 0x83, 0x2E, 0x90, 0xBD, 0x02, 0x28, 0x33, 0xFB, 0x0B, 0xD0, 0xB3,
  0x02, 0x20, 0xBC, 0x83, 0x8F, 0x43, 0xEA, 0x00, 0xAC, 0x82, 0x2C, 0xDD, 0xC0, 0x10, 0xBB, 0x83,
  0x13, 0xFD, 0xDB, 0x10, 0x9B, 0x01, 0x30, 0xBA, 0x81, 0xA0, 0x9B, 0x01, 0x30, 0xBA, 0x81, 0x30,
  0x9B, 0x01, 0x30, 0xBA, 0x81, 0x30, 0x9B, 0x01, 0x30, 0xBA, 0x84, 0x30, 0x27, 0x76, 0x48, 0x13,
  0x76, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_escalator_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_places_escalator_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_family_restroom 18x18, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_round_18_places_family_restroom_data[] PROGMEM = {
  0x20, 0x40, 0x67, 0x81, 0x27, 0x23, 0x03, 0xA0, 0x76, 0x81, 0xDF, 0xD3, 0x03, 0xA0, 0x76, 0x81,
  0xDF, 0xD4, 0x04, 0x06, 0x78, 0x12, 0x72, 0x38, 0x39, 0xBB, 0xA2, 0x58, 0x14, 0xA5, 0x20, 0x6C,
  0x85, 0xA0, 0x38, 0x11, 0xEA, 0x81, 0x10, 0x7C, 0x84, 0xB0, 0xAF, 0x65, 0xB8, 0x15, 0x07, 0xC8,
  0x5B, 0x03, 0x81, 0x4E, 0xA8, 0x1B, 0x07, 0xC8, 0x5B, 0x19, 0x97, 0x07, 0xB0, 0x10, 0x6C, 0x0A,
  0x07, 0xB0, 0x30, 0x4B, 0x81, 0x50, 0x8A, 0x81, 0xB1, 0x7B, 0x00, 0x3B, 0x81, 0x60, 0x5A, 0x81,
  0x90, 0x7B, 0x00, 0x3A, 0x30, 0x5A, 0x86, 0x90, 0x1D, 0xFA, 0x03, 0xA3, 0x05, 0xA0, 0x92, 0x83,
  0xBF, 0x70, 0x3A, 0x30, 0x5A, 0x09, 0x28, 0x3B, 0xF7, 0x03, 0xA3, 0x82, 0x17, 0x72, 0x28, 0x53,
  0x71, 0x01, 0x75, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_family_restroom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_family_restroom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_fence 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_places_fence_data[] PROGMEM = {
  0x38, 0x66, 0x60, 0x66, 0x06, 0x65, 0x07, 0xA0, 0xBA, 0x0B, 0xA0, 0x73, 0x89, 0x23, 0xF9, 0x9F,
  0x99, 0xF9, 0x9F, 0x32, 0x8B, 0x23, 0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x30, 0x39, 0xF9, 0x9F, 0x99,
  0xF9, 0x9F, 0x93, 0x8F, 0xD8, 0xB4, 0x80, 0x3F, 0x33, 0xF3, 0x3F, 0x33, 0xF3, 0x03, 0x9F, 0x99,
  0xF9, 0x9F, 0x99, 0xF9, 0x38, 0xFD, 0x89, 0x48, 0x03, 0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x32, 0x89,
  0x23, 0xF9, 0x9F, 0x99, 0xF9, 0x9F, 0x32, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_fence() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_places_fence_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_fire_extinguisher 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_places_fire_extinguisher_data[] PROGMEM = {
  0x48, 0x42, 0xAA, 0x57, 0x42, 0x03, 0x06, 0x0F, 0xEA, 0x0B, 0x02, 0xC0, 0x05, 0xA0, 0xB2, 0x03,
  0x06, 0x0F, 0xEA, 0x0B, 0x30, 0x10, 0xBA, 0x81, 0xE8, 0x42, 0x01, 0x0D, 0xC0, 0xD0, 0x12, 0x07,
  0xE0, 0x72, 0x02, 0x80, 0x23, 0x02, 0x20, 0xBE, 0x0B, 0x20, 0xBE, 0x0B, 0x20, 0xBE, 0x0B, 0x20,
  0x58, 0x02, 0x70, 0x52, 0x08, 0x80, 0x2B, 0x08, 0x20, 0x9E, 0x09, 0x38, 0x46, 0x77, 0x77, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_fire_extinguisher() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 12, 16), Box(0, 0, 17, 17),
      ic_round_18_places_fire_extinguisher_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_fitness_center 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_places_fitness_center_data[] PROGMEM = {
  0x85, 0x15, 0x07, 0xA9, 0x77, 0x81, 0x4F, 0xBB, 0x04, 0x71, 0x0B, 0xB0, 0x47, 0x10, 0x7B, 0x09,
  0x72, 0x0A, 0xA8, 0x19, 0xF7, 0x71, 0x85, 0x9F, 0x40, 0x7F, 0x77, 0x07, 0x04, 0x38, 0x17, 0xF7,
  0x75, 0x81, 0x7F, 0x73, 0x04, 0x07, 0x78, 0x57, 0xF7, 0x04, 0xF9, 0x71, 0x81, 0x7F, 0x9A, 0x0A,
  0x72, 0x09, 0xB0, 0x77, 0x10, 0x4B, 0x0B, 0x71, 0x04, 0xB8, 0x1B, 0xF4, 0x78, 0x57, 0x99, 0x70,
  0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_fitness_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_fitness_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_food_bank 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_places_food_bank_data[] PROGMEM = {
  0x50, 0x03, 0x72, 0x09, 0xA0, 0x96, 0x02, 0x0C, 0xC0, 0xC0, 0x23, 0x05, 0x0E, 0xE8, 0x2E, 0x50,
  0x8F, 0xB0, 0x8B, 0x84, 0x78, 0x8B, 0x6C, 0xE0, 0xF5, 0x81, 0x60, 0xBE, 0x84, 0x62, 0x26, 0x0B,
  0xE8, 0x4E, 0x47, 0xC1, 0xBF, 0x83, 0x7B, 0xF7, 0xBF, 0x83, 0x7B, 0xF7, 0xBF, 0x83, 0xCE, 0xFC,
  0xEB, 0x0E, 0xFB, 0x0E, 0x04, 0x80, 0x6B, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_food_bank() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_places_food_bank_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_foundation 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_places_foundation_data[] PROGMEM = {
  0x60, 0x03, 0x74, 0x06, 0xA0, 0x67, 0x20, 0x7C, 0x07, 0x78, 0x69, 0xF9, 0xBB, 0x9F, 0x95, 0x89,
  0x0A, 0xF8, 0x0B, 0xB0, 0x8F, 0xA2, 0x82, 0x1B, 0xF7, 0x20, 0x0B, 0x28, 0x37, 0xFB, 0x1A, 0xA0,
  0x32, 0x00, 0xB2, 0x03, 0xA8, 0x3B, 0x03, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3, 0x28, 0x13, 0xF3,
  0x20, 0x0B, 0x28, 0xC2, 0x3F, 0x30, 0x6C, 0xFC, 0xBB, 0xEE, 0xBB, 0xCF, 0xC6, 0x6C, 0xFC, 0xBB,
  0xEE, 0xBB, 0xCF, 0xC6, 0x03, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3, 0x28, 0x12, 0xD2, 0x20, 0x09,
  0x28, 0x12, 0xD2, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_foundation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_places_foundation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_free_breakfast 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_places_free_breakfast_data[] PROGMEM = {
  0x10, 0x28, 0x07, 0x38, 0x11, 0x02, 0xFD, 0x81, 0xE1, 0x4F, 0xB8, 0x37, 0x2F, 0x34, 0xFB, 0x83,
  0x72, 0xF3, 0x4F, 0xB8, 0x39, 0x5F, 0x34, 0xFD, 0x81, 0xD0, 0x4F, 0xB0, 0x80, 0x12, 0x04, 0xFB,
  0x07, 0x30, 0x4F, 0xB0, 0x73, 0x02, 0xFB, 0x05, 0x40, 0x9F, 0x90, 0xC6, 0x04, 0x80, 0x27, 0x05,
  0x68, 0x07, 0x13, 0x03, 0xFC, 0x04, 0x38, 0x07, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_free_breakfast() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_free_breakfast_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_gite 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_places_gite_data[] PROGMEM = {
  0x40, 0x10, 0x27, 0x70, 0x90, 0xB7, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x23, 0x02, 0x0D, 0xFA, 0x81,
  0xDD, 0x22, 0x0D, 0xFA, 0x84, 0x61, 0xCD, 0x03, 0xFA, 0x0B, 0x28, 0x42, 0xF3, 0x3F, 0x26, 0x00,
  0xA2, 0x84, 0x2F, 0x33, 0xF2, 0x60, 0x0A, 0x28, 0x42, 0xF3, 0x3F, 0x26, 0x00, 0xA2, 0x82, 0x2F,
  0x31, 0x98, 0x03, 0xD8, 0x7E, 0xED, 0xDD, 0xF1, 0x04, 0x80, 0x90, 0x70, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_gite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_places_gite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_golf_course 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_places_golf_course_data[] PROGMEM = {
  0x48, 0x15, 0xA3, 0x74, 0x07, 0xA0, 0xB0, 0x37, 0x20, 0x7C, 0x08, 0x71, 0x07, 0xB0, 0xA0, 0x27,
  0x18, 0x27, 0xFA, 0x27, 0x30, 0x70, 0xD7, 0x50, 0x70, 0xD7, 0x50, 0x70, 0xD7, 0x50, 0x70, 0xD7,
  0x50, 0x70, 0xD7, 0x50, 0x70, 0xD7, 0x28, 0x63, 0x92, 0x7F, 0xDA, 0x62, 0x82, 0x9C, 0x12, 0xA0,
  0x60, 0xAC, 0x86, 0x80, 0xDF, 0x30, 0x7D, 0xC8, 0x4E, 0xA2, 0x01, 0x24, 0x82, 0x11, 0x21, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_golf_course() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_places_golf_course_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_grass 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_places_grass_data[] PROGMEM = {
  0x50, 0x17, 0x78, 0x11, 0xE3, 0x50, 0x27, 0x10, 0xA0, 0xD3, 0x81, 0x4D, 0x77, 0x18, 0x56, 0xF6,
  0x05, 0xFB, 0x72, 0x82, 0x4F, 0x22, 0xA0, 0x27, 0x28, 0x42, 0xB0, 0x9E, 0x56, 0x82, 0x3E, 0xC6,
  0x38, 0x5A, 0x10, 0x6C, 0xE3, 0x38, 0x92, 0x2E, 0xFC, 0x10, 0x11, 0xCF, 0xE3, 0x50, 0x2A, 0x0C,
  0x20, 0xCA, 0x03, 0x70, 0x8A, 0x83, 0x60, 0xEF, 0x94, 0x83, 0x17, 0x77, 0x9A, 0x89, 0x0C, 0x0A,
  0xF9, 0x77, 0x71, 0x5E, 0x81, 0xE0, 0x8D, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_grass() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_places_grass_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_holiday_village 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_places_holiday_village_data[] PROGMEM = {
  0x70, 0x30, 0x12, 0x04, 0x58, 0x90, 0x8E, 0x30, 0xAD, 0x20, 0xDC, 0x30, 0x9A, 0x89, 0x1E, 0x31,
  0xCD, 0x22, 0xE9, 0x09, 0xC8, 0x7E, 0x31, 0xCD, 0x09, 0xB7, 0xE8, 0x6E, 0x24, 0xF0, 0x9B, 0xBA,
  0x0D, 0x07, 0xB8, 0x55, 0x4F, 0x09, 0xBB, 0xA0, 0xD0, 0x7B, 0x85, 0x54, 0xF0, 0x9B, 0xBF, 0x85,
  0x54, 0xF0, 0x9B, 0xBA, 0x0B, 0x03, 0xB8, 0x55, 0x4F, 0x09, 0xBB, 0xA0, 0x91, 0xB8, 0x55, 0x4F,
  0x09, 0xBA, 0xA0, 0x91, 0xB8, 0x90, 0x44, 0xF0, 0x9B, 0x15, 0x53, 0x10, 0xF5, 0x28, 0x24, 0x01,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_holiday_village() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_places_holiday_village_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_hot_tub 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_18_places_hot_tub_data[] PROGMEM = {
  0x71, 0x02, 0x20, 0x27, 0x10, 0x13, 0x83, 0xE5, 0x3F, 0x16, 0x81, 0xCF, 0x92, 0x83, 0xAC, 0x1E,
  0x75, 0x01, 0xA0, 0xE2, 0x84, 0x1E, 0x65, 0xF2, 0x58, 0x19, 0xE6, 0x38, 0x3B, 0xA0, 0xF5, 0x60,
  0x14, 0x83, 0x45, 0x07, 0x25, 0x82, 0x7F, 0xC2, 0x74, 0x01, 0x0E, 0xA0, 0xE0, 0x38, 0x02, 0x12,
  0x01, 0x0E, 0xFD, 0x81, 0xE1, 0x3A, 0x89, 0x06, 0xCF, 0x5E, 0xE5, 0xFC, 0x6A, 0x00, 0x3A, 0x18,
  0x69, 0xD0, 0xBB, 0x0D, 0x91, 0xA0, 0x03, 0xA1, 0x86, 0x9D, 0x0B, 0xB0, 0xD9, 0x1A, 0x00, 0x3A,
  0x89, 0x05, 0xCF, 0x4D, 0xD4, 0xFC, 0x5A, 0x81, 0x30, 0xEF, 0xD0, 0xE3, 0x80, 0x90, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_hot_tub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_hot_tub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_houseboat 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_places_houseboat_data[] PROGMEM = {
  0x70, 0x09, 0x75, 0x03, 0x0D, 0xA0, 0xD0, 0x37, 0x20, 0x7E, 0x07, 0x70, 0xBF, 0x90, 0xB6, 0x09,
  0x0B, 0xE0, 0xB0, 0x97, 0x09, 0xA0, 0x08, 0xA0, 0x95, 0x82, 0x9B, 0x2A, 0xA0, 0x06, 0xA8, 0x2A,
  0x2B, 0x92, 0x03, 0x0D, 0xFB, 0x0D, 0x03, 0x48, 0x06, 0x34, 0x8A, 0x13, 0xBC, 0x70, 0x5B, 0xB5,
  0x06, 0xCB, 0x30, 0x1F, 0xC9, 0xB0, 0x0A, 0xB8, 0x49, 0xBF, 0x10, 0x32, 0x81, 0x25, 0x32, 0x81,
  0x35, 0x12, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_houseboat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_places_houseboat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_house 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_places_house_data[] PROGMEM = {
  0x50, 0x01, 0x72, 0x85, 0x2D, 0xD2, 0x17, 0x34, 0x04, 0x0E, 0xA8, 0x2E, 0x8F, 0x73, 0x06, 0xF0,
  0x72, 0x08, 0xB0, 0x08, 0xB8, 0x1A, 0x0A, 0xC0, 0x0D, 0xC8, 0x1A, 0x07, 0xF9, 0x07, 0x20, 0x7B,
  0x00, 0xBB, 0x07, 0x20, 0x7B, 0x00, 0x1B, 0x07, 0x20, 0x7B, 0x00, 0x1B, 0x07, 0x20, 0x7B, 0x00,
  0x1B, 0x07, 0x20, 0x20, 0xF5, 0x20, 0xF5, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_house() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_places_house_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_house_siding 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_places_house_siding_data[] PROGMEM = {
  0x60, 0x03, 0x74, 0x06, 0xA0, 0x67, 0x28, 0x47, 0xFA, 0xAF, 0x77, 0x81, 0x9F, 0x92, 0x81, 0x9F,
  0x95, 0x0A, 0xF9, 0x0A, 0x28, 0x21, 0xBF, 0x98, 0x02, 0x78, 0x39, 0xFB, 0x1A, 0xA0, 0x36, 0x03,
  0xA8, 0x1B, 0x03, 0xFB, 0x03, 0x28, 0x13, 0xF9, 0x80, 0x27, 0x81, 0x9F, 0x32, 0x81, 0x3F, 0x36,
  0x81, 0x3F, 0x32, 0x03, 0xFB, 0x03, 0x28, 0x13, 0xF9, 0x80, 0x27, 0x81, 0x9F, 0x32, 0x81, 0x2D,
  0x26, 0x81, 0x2D, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_house_siding() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_places_house_siding_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_iron 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_places_iron_data[] PROGMEM = {
  0x58, 0x91, 0x59, 0x99, 0x96, 0x01, 0xCF, 0x14, 0x89, 0x14, 0xFB, 0xBB, 0xBF, 0x66, 0xE3, 0x60,
  0x14, 0x82, 0xB9, 0x7D, 0x30, 0x10, 0xA8, 0x03, 0xD9, 0x81, 0x97, 0xD3, 0x0C, 0xFA, 0x81, 0x97,
  0xD2, 0x02, 0xFB, 0x81, 0xDD, 0xA2, 0x03, 0xFB, 0x81, 0xD9, 0x12, 0x01, 0x0E, 0xFA, 0x06, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_iron() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_places_iron_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_kitchen 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_places_kitchen_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x38, 0x11, 0x02, 0xFB, 0x81, 0x26, 0xE8, 0x04, 0x18, 0x5E, 0x66, 0xE0, 0x87,
  0x58, 0x5E, 0x66, 0xE0, 0xA9, 0x58, 0x5E, 0x66, 0xE0, 0x11, 0x58, 0x1E, 0x66, 0x98, 0x04, 0xB9,
  0x00, 0x69, 0x80, 0x47, 0x98, 0x46, 0x6E, 0x03, 0x35, 0x85, 0xE6, 0x6E, 0x0A, 0x95, 0x85, 0xE6,
  0x6E, 0x0A, 0xA5, 0x85, 0xE6, 0x6E, 0x04, 0x35, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x80,
  0x41, 0x81, 0xE6, 0x2F, 0xB8, 0x12, 0x01, 0x80, 0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_kitchen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_places_kitchen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_meeting_room 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_places_meeting_room_data[] PROGMEM = {
  0x20, 0x18, 0x01, 0x30, 0x17, 0x0D, 0xD8, 0x2C, 0x55, 0x14, 0x0E, 0xF9, 0x0C, 0x40, 0xED, 0x82,
  0xC0, 0x6E, 0x40, 0xED, 0x82, 0xC0, 0x6E, 0x40, 0xED, 0x82, 0xC0, 0x6E, 0x40, 0xEA, 0x85, 0xB9,
  0xFC, 0x06, 0xE4, 0x0E, 0xA8, 0x5B, 0x9F, 0xC0, 0x6E, 0x40, 0xED, 0x82, 0xC0, 0x6E, 0x40, 0xED,
  0x82, 0xC0, 0x6E, 0x40, 0xED, 0x82, 0xC0, 0x6E, 0x40, 0xED, 0x82, 0xC0, 0x6E, 0x20, 0x2F, 0x81,
  0xB0, 0x6A, 0x02, 0x18, 0x03, 0x38, 0x31, 0x01, 0x33, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_meeting_room() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_meeting_room_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_microwave 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_places_microwave_data[] PROGMEM = {
  0x02, 0x0D, 0xFD, 0x81, 0xD2, 0x79, 0x80, 0x37, 0x0B, 0xD0, 0x07, 0x97, 0x8B, 0x77, 0xFC, 0x3C,
  0xF7, 0x7F, 0x05, 0xEC, 0x54, 0x07, 0xFC, 0x3C, 0xF7, 0x7F, 0x04, 0x8C, 0xFE, 0x07, 0xD0, 0x07,
  0x94, 0x89, 0x13, 0x10, 0x7F, 0xE5, 0xEF, 0x77, 0x92, 0x03, 0x01, 0x38, 0x91, 0x7F, 0xE5, 0xEF,
  0x77, 0xF0, 0x7A, 0x82, 0x98, 0x07, 0xD8, 0xA0, 0x77, 0xF0, 0x25, 0x9E, 0xC0, 0x7F, 0xE5, 0xEF,
  0x77, 0x97, 0x86, 0x7F, 0xE5, 0xEF, 0x77, 0x98, 0x03, 0x70, 0xBD, 0x81, 0x72, 0xDF, 0xD0, 0xD0,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_microwave() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_places_microwave_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_night_shelter 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_places_night_shelter_data[] PROGMEM = {
  0x50, 0x03, 0x72, 0x09, 0xA0, 0x96, 0x02, 0x0C, 0xC0, 0xC0, 0x23, 0x05, 0x0E, 0xE8, 0x2E, 0x50,
  0x8F, 0xB0, 0x8F, 0xF0, 0x8F, 0xC8, 0x23, 0xC7, 0xA2, 0x01, 0x0A, 0xC8, 0x23, 0x70, 0x73, 0x04,
  0xC8, 0x23, 0x97, 0x63, 0x03, 0xC0, 0x38, 0x02, 0x90, 0x3C, 0x0A, 0xE0, 0xAA, 0x0E, 0xFB, 0x0E,
  0x04, 0x80, 0x6B, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_night_shelter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_places_night_shelter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_no_backpack 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_places_no_backpack_data[] PROGMEM = {
  0x40, 0x20, 0x64, 0x06, 0x02, 0x30, 0x30, 0x52, 0x81, 0xAF, 0x72, 0x81, 0x7F, 0xA3, 0x83, 0x7F,
  0x70, 0x5E, 0x0E, 0x08, 0x38, 0x39, 0xF7, 0x05, 0xF0, 0x83, 0x83, 0xEF, 0x70, 0x5E, 0x0E, 0x3B,
  0x81, 0x70, 0x5E, 0x3C, 0x81, 0x70, 0x5D, 0x3D, 0x81, 0x70, 0x5C, 0x39, 0x0A, 0x28, 0x19, 0xF7,
  0x30, 0xA9, 0x39, 0x85, 0xD7, 0x77, 0xEF, 0x72, 0x07, 0x93, 0xF9, 0x81, 0x70, 0x49, 0x3F, 0xA8,
  0x17, 0x05, 0x3F, 0xB0, 0x74, 0xFC, 0x07, 0x30, 0xDF, 0xC0, 0x52, 0x02, 0x80, 0x77, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_no_backpack() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_places_no_backpack_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_no_cell 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_18_places_no_cell_data[] PROGMEM = {
  0x48, 0x04, 0x36, 0x0D, 0xF9, 0x85, 0xE1, 0x03, 0x50, 0x5F, 0xA8, 0x53, 0x07, 0xF7, 0x05, 0xF9,
  0x03, 0x28, 0x39, 0xF7, 0x04, 0x80, 0x17, 0x81, 0x9F, 0x33, 0x81, 0x9F, 0x76, 0x81, 0x3F, 0x33,
  0x03, 0xA0, 0x75, 0x81, 0x3F, 0x33, 0x83, 0x3F, 0xCF, 0x74, 0x81, 0x3F, 0x33, 0x84, 0x3F, 0x39,
  0xF7, 0x38, 0x13, 0xF3, 0x38, 0x53, 0xF3, 0x09, 0xF7, 0x28, 0x13, 0xF3, 0x38, 0x13, 0xF3, 0x28,
  0x59, 0xF7, 0x02, 0xF3, 0x38, 0x13, 0xF3, 0x38, 0x49, 0xF7, 0x05, 0x33, 0x81, 0x3F, 0x34, 0x81,
  0x9F, 0x75, 0x81, 0x3F, 0x98, 0x01, 0x78, 0x1E, 0xF7, 0x40, 0x3F, 0xB0, 0x73, 0x03, 0xFC, 0x05,
  0x20, 0x10, 0xEF, 0x98, 0x1D, 0x73, 0x48, 0x04, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_no_cell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 15, 17), Box(0, 0, 17, 17),
      ic_round_18_places_no_cell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_no_drinks 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_places_no_drinks_data[] PROGMEM = {
  0x82, 0x35, 0x03, 0x80, 0x6B, 0x84, 0x47, 0xF7, 0x05, 0x80, 0x3B, 0x85, 0xCF, 0xA0, 0x9F, 0x77,
  0x82, 0x1C, 0xE2, 0x28, 0x92, 0x9F, 0x70, 0x3B, 0xBB, 0xBD, 0xE3, 0x48, 0x39, 0xF7, 0x05, 0xC0,
  0x46, 0x83, 0x9F, 0x70, 0x5A, 0x06, 0x71, 0x84, 0x9F, 0x70, 0x58, 0x73, 0x81, 0x9F, 0x77, 0x68,
  0x1D, 0xF7, 0x75, 0x0B, 0xA0, 0x77, 0x48, 0x3B, 0xB9, 0xF7, 0x73, 0x84, 0xBB, 0x09, 0xF7, 0x58,
  0x63, 0xBB, 0xBE, 0xEB, 0xBA, 0x07, 0x40, 0x38, 0x04, 0xB8, 0x1A, 0xF5, 0x76, 0x07, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_no_drinks() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_places_no_drinks_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_no_flash 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_18_places_no_flash_data[] PROGMEM = {
  0x75, 0x84, 0x37, 0x71, 0x97, 0x73, 0x07, 0xA8, 0x21, 0x8F, 0x77, 0x28, 0x17, 0xF9, 0x28, 0x19,
  0xF7, 0x71, 0x82, 0x7F, 0xC1, 0x28, 0x19, 0xF7, 0x78, 0x11, 0xCC, 0x48, 0x59, 0xF7, 0x05, 0xB1,
  0x38, 0x3B, 0x30, 0x3D, 0xC8, 0x17, 0x05, 0xA8, 0x1D, 0x36, 0x20, 0x7E, 0x81, 0x70, 0x5A, 0x07,
  0x30, 0x7B, 0x87, 0xC3, 0x9F, 0x70, 0x5F, 0x73, 0x07, 0xA8, 0x2D, 0x08, 0xDA, 0x82, 0x70, 0x57,
  0x30, 0x7A, 0x09, 0x03, 0xB8, 0x3D, 0xF7, 0x01, 0x30, 0x7A, 0x09, 0x03, 0xB8, 0x24, 0xBF, 0x74,
  0x07, 0xA8, 0x5D, 0x18, 0xC8, 0x1D, 0xA0, 0x73, 0x07, 0xB8, 0x3C, 0x30, 0x3C, 0xC0, 0x72, 0x06,
  0xFC, 0x81, 0xDF, 0x72, 0x06, 0x80, 0x57, 0x82, 0x60, 0x89, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_no_flash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_no_flash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_no_food 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_round_18_places_no_food_data[] PROGMEM = {
  0x75, 0x01, 0x77, 0x30, 0xE0, 0x64, 0x81, 0x1F, 0x77, 0x29, 0x07, 0x58, 0x19, 0xF7, 0x50, 0xF3,
  0x98, 0x29, 0x33, 0x23, 0x81, 0x9F, 0x73, 0x09, 0xF9, 0x01, 0x38, 0x19, 0xF7, 0x20, 0x9F, 0x90,
  0x14, 0x83, 0x9F, 0x70, 0x4F, 0x93, 0x81, 0x1A, 0xEA, 0x81, 0x70, 0x5E, 0x0D, 0x20, 0x30, 0xED,
  0x81, 0x70, 0x5D, 0x0B, 0x20, 0xCF, 0x81, 0x70, 0x5C, 0x81, 0xA0, 0x1F, 0xA8, 0x17, 0x05, 0xB0,
  0x82, 0x02, 0x80, 0x33, 0x83, 0x9F, 0x70, 0x5A, 0x07, 0x28, 0x05, 0x38, 0x7C, 0xF7, 0x05, 0xF5,
  0x02, 0xFD, 0x82, 0x70, 0x54, 0x28, 0x06, 0x38, 0x22, 0x9F, 0x74, 0x80, 0x63, 0x83, 0x20, 0x9F,
  0x72, 0x02, 0xFB, 0x0D, 0x20, 0x99, 0x38, 0x06, 0x30, 0x23, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_no_food() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_places_no_food_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_no_meeting_room 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_places_no_meeting_room_data[] PROGMEM = {
  0x38, 0x01, 0x30, 0x14, 0x82, 0xE7, 0x09, 0xC8, 0x90, 0xC5, 0x51, 0x06, 0xF7, 0x09, 0xE0, 0xC2,
  0x83, 0x6F, 0x70, 0x9A, 0x82, 0xC0, 0x6E, 0x38, 0x90, 0xEF, 0x70, 0x9F, 0xC0, 0x6E, 0x30, 0xEA,
  0x85, 0x70, 0x9C, 0x06, 0xE3, 0x0E, 0xB8, 0x47, 0x06, 0x06, 0xE3, 0x0E, 0xC0, 0x72, 0x06, 0x0E,
  0x30, 0xED, 0x82, 0x70, 0x5E, 0x30, 0xEE, 0x81, 0x70, 0x83, 0x0E, 0xD8, 0x1E, 0xF7, 0x40, 0xED,
  0x84, 0xC6, 0xF7, 0x02, 0xF8, 0x3B, 0x06, 0xF7, 0x18, 0x03, 0x30, 0x12, 0x06, 0x0E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_no_meeting_room() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_places_no_meeting_room_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_no_photography 18x18, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_round_18_places_no_photography_data[] PROGMEM = {
  0x81, 0x1F, 0x73, 0x84, 0x5B, 0xBB, 0xB5, 0x68, 0x39, 0xF7, 0x02, 0xE8, 0x27, 0x33, 0x12, 0x03,
  0xA8, 0x17, 0x06, 0xFA, 0x81, 0x30, 0x7B, 0x81, 0x70, 0x6F, 0x98, 0x17, 0x07, 0xC0, 0x72, 0x81,
  0x15, 0xEC, 0x81, 0x70, 0x7D, 0x07, 0x30, 0x20, 0xEB, 0x81, 0x70, 0x7B, 0x82, 0x79, 0xF7, 0x30,
  0x8B, 0x81, 0x70, 0x7B, 0x04, 0x02, 0xA0, 0x72, 0x04, 0xB8, 0x17, 0x07, 0xB0, 0x60, 0x1B, 0x81,
  0x70, 0x3B, 0x81, 0x70, 0x7B, 0x87, 0xB0, 0x5D, 0xEF, 0x70, 0x6A, 0x81, 0x70, 0x7C, 0x08, 0x38,
  0x79, 0xF7, 0x06, 0xF7, 0x07, 0xD8, 0x2D, 0x98, 0xDA, 0x84, 0x70, 0x67, 0x06, 0xFD, 0x81, 0x70,
  0x12, 0x09, 0x80, 0x6B, 0x81, 0xCF, 0x77, 0x71, 0x09, 0x97, 0x72, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_no_photography() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_places_no_photography_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_no_stroller 18x18, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_18_places_no_stroller_data[] PROGMEM = {
  0x03, 0x05, 0x28, 0x36, 0x9B, 0x96, 0x28, 0x90, 0x3A, 0xA3, 0x07, 0xF7, 0x05, 0xC8, 0x93, 0x53,
  0xEE, 0xEE, 0x10, 0x9F, 0x70, 0x5A, 0x86, 0x71, 0xDD, 0x11, 0xF6, 0x28, 0x90, 0x9F, 0x70, 0x5A,
  0x0C, 0xFB, 0x20, 0x24, 0x81, 0x9F, 0x72, 0x0A, 0xA0, 0xB7, 0x18, 0x39, 0xF7, 0x05, 0xA0, 0xB7,
  0x28, 0x59, 0xF7, 0x05, 0xFB, 0x72, 0x04, 0xA8, 0x27, 0x05, 0xB7, 0x10, 0x20, 0xEB, 0x81, 0x70,
  0x37, 0x10, 0xDD, 0x07, 0x72, 0x86, 0xAB, 0xBB, 0xBC, 0xF7, 0x68, 0x12, 0x72, 0x58, 0x1C, 0xF7,
  0x58, 0x1D, 0xFD, 0x40, 0x5B, 0x07, 0x48, 0x1D, 0xFD, 0x40, 0x5A, 0x81, 0xCF, 0x53, 0x81, 0x27,
  0x25, 0x83, 0x55, 0x07, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_no_stroller() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_no_stroller_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_other_houses 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_places_other_houses_data[] PROGMEM = {
  0x60, 0x06, 0x73, 0x01, 0x0A, 0xA0, 0xA7, 0x10, 0x30, 0xDC, 0x0D, 0x03, 0x50, 0x6F, 0x90, 0x63,
  0x09, 0xFB, 0x81, 0x90, 0xCF, 0xD8, 0x1C, 0x88, 0xFB, 0x89, 0x58, 0x80, 0x6F, 0xB2, 0xF6, 0x6F,
  0x2B, 0xF6, 0x20, 0x6A, 0x84, 0xDF, 0xEE, 0xFD, 0xA0, 0x62, 0x06, 0xFB, 0x06, 0x20, 0x6F, 0xB0,
  0x62, 0x05, 0xFB, 0x05, 0x38, 0x06, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_other_houses() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_other_houses_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_pool 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_18_places_pool_data[] PROGMEM = {
  0x30, 0x20, 0x15, 0x02, 0x03, 0x78, 0x2E, 0xFC, 0x22, 0x04, 0xA0, 0x86, 0x05, 0x0B, 0xA8, 0x14,
  0x09, 0xA0, 0xD7, 0x18, 0x35, 0xEF, 0x44, 0xA0, 0x87, 0x20, 0xAA, 0x81, 0x42, 0x37, 0x20, 0x9C,
  0x04, 0x72, 0x08, 0xA0, 0x0B, 0xA0, 0x47, 0x18, 0x11, 0x52, 0x28, 0x12, 0x51, 0x68, 0x92, 0x56,
  0x20, 0x16, 0x61, 0x02, 0x65, 0x28, 0xA5, 0x1D, 0xFE, 0xFC, 0xEE, 0xEE, 0xCF, 0xEF, 0xD1, 0x06,
  0x10, 0x58, 0x62, 0x84, 0x68, 0x50, 0x16, 0x28, 0xA1, 0x3A, 0xB6, 0x15, 0xAA, 0x51, 0x6B, 0xA3,
  0x01, 0xFC, 0xAB, 0x00, 0xBB, 0x84, 0xAC, 0xF1, 0x01, 0x28, 0x11, 0x32, 0x28, 0x12, 0x31, 0x20,
  0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_pool() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_places_pool_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_rice_bowl 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_places_rice_bowl_data[] PROGMEM = {
  0x68, 0x24, 0x67, 0x57, 0x30, 0x70, 0xED, 0x09, 0x01, 0x50, 0x10, 0xBA, 0x82, 0x81, 0x18, 0xA0,
  0xD0, 0x24, 0x83, 0xBD, 0x3F, 0x72, 0x84, 0x7F, 0x3D, 0xD1, 0x28, 0x47, 0xF3, 0x0F, 0x72, 0x84,
  0x7F, 0x03, 0xF9, 0x20, 0xE0, 0x92, 0x90, 0x72, 0x07, 0x92, 0x84, 0x9F, 0x14, 0xF3, 0x29, 0x07,
  0x20, 0x79, 0x28, 0x43, 0xF5, 0x7F, 0x12, 0x90, 0x72, 0x07, 0x92, 0x82, 0x1F, 0x66, 0xFF, 0x06,
  0x04, 0xFF, 0x81, 0x30, 0xDF, 0xD0, 0xD2, 0x05, 0xFD, 0x05, 0x30, 0x8F, 0xB0, 0x75, 0x05, 0x0D,
  0xE0, 0xD0, 0x57, 0x10, 0xEC, 0x0E, 0x73, 0x84, 0x37, 0x77, 0x73, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_rice_bowl() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_rice_bowl_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_roofing 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_places_roofing_data[] PROGMEM = {
  0x60, 0x03, 0x74, 0x06, 0xA8, 0x36, 0x0C, 0xE2, 0x58, 0x47, 0xFA, 0xAF, 0x7A, 0x03, 0x48, 0x19,
  0xF9, 0x20, 0x9B, 0x03, 0x38, 0x1A, 0xF8, 0x40, 0x8A, 0x84, 0x30, 0x1B, 0xF6, 0x68, 0x56, 0xFB,
  0x1A, 0xE5, 0x71, 0x81, 0x5E, 0xA7, 0x75, 0x82, 0x67, 0x76, 0x72, 0x03, 0xC0, 0x37, 0x18, 0x43,
  0xF3, 0x3F, 0x37, 0x18, 0x43, 0xF9, 0x9F, 0x37, 0x10, 0x20, 0xEA, 0x0E, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_roofing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_places_roofing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_room_preferences 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_places_room_preferences_data[] PROGMEM = {
  0x10, 0x10, 0xA8, 0x01, 0xB0, 0x37, 0x03, 0xFA, 0x0E, 0x02, 0x30, 0x3E, 0x83, 0xB7, 0x9F, 0x33,
  0x03, 0xE8, 0x37, 0x03, 0xF3, 0x30, 0x3E, 0x83, 0x70, 0x3F, 0x33, 0x03, 0xE8, 0x37, 0x01, 0x71,
  0x30, 0x3B, 0x82, 0xC6, 0xF5, 0x70, 0x3B, 0x81, 0xC6, 0x62, 0x81, 0x4F, 0x53, 0x03, 0xC8, 0x91,
  0xC0, 0x67, 0xDF, 0xD7, 0x60, 0x3C, 0x89, 0x16, 0x0D, 0xFA, 0x4A, 0xFD, 0x03, 0xC8, 0x91, 0x40,
  0x4F, 0x10, 0x1F, 0x50, 0x3C, 0x89, 0x15, 0x08, 0xF4, 0x04, 0xF9, 0x6C, 0xC8, 0x19, 0x0C, 0xA0,
  0xCA, 0x0C, 0x06, 0x80, 0x2B, 0x38, 0x18, 0xF8, 0x75, 0x81, 0x17, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_room_preferences() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_room_preferences_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_room_service 18x18, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_18_places_room_service_data[] PROGMEM = {
  0x70, 0x0A, 0x76, 0x07, 0xA0, 0x77, 0x30, 0x50, 0xDC, 0x0D, 0x05, 0x70, 0x7F, 0x90, 0x75, 0x04,
  0xFB, 0x04, 0x40, 0xCF, 0xB0, 0xC3, 0x01, 0xFD, 0x01, 0x20, 0x3F, 0xD0, 0x32, 0x03, 0x80, 0x90,
  0xB8, 0x13, 0x01, 0x80, 0x92, 0x60, 0x10, 0x28, 0x09, 0x2E, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_room_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_places_room_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_rv_hookup 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_places_rv_hookup_data[] PROGMEM = {
  0x01, 0x80, 0x57, 0x01, 0x48, 0x91, 0x2D, 0xDD, 0xDF, 0xDD, 0xDE, 0x97, 0x18, 0x12, 0xF3, 0x20,
  0x0A, 0x71, 0x81, 0x2F, 0x32, 0x00, 0xA4, 0x89, 0x12, 0xDD, 0xDD, 0xFD, 0xDD, 0xEA, 0x40, 0x3F,
  0xA0, 0xA4, 0x03, 0xFA, 0x0A, 0x40, 0x3F, 0xA0, 0xA2, 0x81, 0x60, 0x1C, 0x04, 0x0A, 0xB8, 0x92,
  0xC5, 0x6F, 0x60, 0x7E, 0xFE, 0x39, 0xF0, 0xD3, 0x01, 0x0D, 0xA0, 0x65, 0x0D, 0x01, 0x50, 0x30,
  0x26, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_rv_hookup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_rv_hookup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_smoke_free 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_places_smoke_free_data[] PROGMEM = {
  0x73, 0x01, 0x76, 0x84, 0x4D, 0x60, 0x62, 0x30, 0xE0, 0x75, 0x83, 0xD1, 0x06, 0xD4, 0x81, 0x6F,
  0x74, 0x84, 0xD1, 0x06, 0xC9, 0x48, 0x16, 0xF7, 0x38, 0x56, 0xC9, 0x82, 0x98, 0x48, 0x16, 0xF7,
  0x38, 0x41, 0x36, 0xD1, 0xD5, 0x81, 0x6F, 0x75, 0x82, 0x85, 0xB2, 0x58, 0x16, 0xF7, 0x48, 0x26,
  0x59, 0x22, 0x80, 0x01, 0x81, 0x8F, 0x72, 0x85, 0x11, 0x01, 0x01, 0xEF, 0x87, 0x70, 0x37, 0x6A,
  0x30, 0x98, 0x03, 0xB9, 0x84, 0x70, 0x54, 0x72, 0x72, 0x81, 0x6F, 0x77, 0x78, 0x16, 0xF7, 0x77,
  0x81, 0x6F, 0x77, 0x70, 0x60, 0xE2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_smoke_free() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_places_smoke_free_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_smoking_rooms 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_places_smoking_rooms_data[] PROGMEM = {
  0x74, 0x00, 0xA7, 0x58, 0x32, 0x30, 0xB4, 0x73, 0x84, 0x7C, 0x40, 0xA4, 0x73, 0x0D, 0x20, 0x90,
  0xD7, 0x48, 0x5C, 0x20, 0x39, 0xC1, 0x72, 0x85, 0x3D, 0xCB, 0x46, 0xA7, 0x48, 0x31, 0x3D, 0x2D,
  0x76, 0x82, 0x85, 0xB2, 0x75, 0x84, 0x54, 0x71, 0x02, 0x80, 0x53, 0x84, 0x22, 0x13, 0x01, 0xFB,
  0x85, 0x97, 0x6A, 0x30, 0x68, 0x05, 0x78, 0x34, 0x33, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_smoking_rooms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_places_smoking_rooms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_soap 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_places_soap_data[] PROGMEM = {
  0x75, 0x03, 0x77, 0x18, 0x19, 0xF5, 0x77, 0x81, 0x7E, 0x37, 0x58, 0x62, 0x85, 0x02, 0xDD, 0x25,
  0x89, 0x21, 0xB7, 0x0D, 0xAE, 0x36, 0xCC, 0x64, 0x89, 0x32, 0xDF, 0xB0, 0xD8, 0xE4, 0x2D, 0xD2,
  0x30, 0x20, 0xDA, 0x83, 0x30, 0x3A, 0x77, 0x03, 0x0E, 0xA0, 0xD8, 0x03, 0x70, 0x43, 0x03, 0x0E,
  0xFC, 0x0E, 0x30, 0xEF, 0x84, 0x65, 0x55, 0x52, 0x20, 0x3F, 0x98, 0x03, 0xD0, 0x03, 0xFF, 0x81,
  0xE4, 0x3F, 0x90, 0x58, 0x01, 0x32, 0x03, 0xFF, 0x81, 0xA0, 0x3F, 0x90, 0xA8, 0x01, 0x98, 0x13,
  0x02, 0xF9, 0x83, 0xA9, 0x99, 0x84, 0x09, 0xFD, 0x02, 0x40, 0x28, 0x06, 0x30, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_soap() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_places_soap_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_spa 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_places_spa_data[] PROGMEM = {
  0x70, 0x05, 0x76, 0x03, 0xA0, 0x37, 0x50, 0xBA, 0x0B, 0x74, 0x02, 0xC0, 0x27, 0x30, 0x7C, 0x07,
  0x60, 0x02, 0x20, 0x6C, 0x06, 0x28, 0x21, 0x20, 0x1A, 0x89, 0x0D, 0x60, 0x2D, 0xD2, 0x06, 0xDA,
  0x01, 0x1C, 0x84, 0xD2, 0x22, 0x2C, 0xC2, 0x0C, 0xC8, 0x2E, 0x10, 0xDC, 0x0C, 0x20, 0x6D, 0x81,
  0xB0, 0xBC, 0x07, 0x30, 0xDD, 0x03, 0x05, 0xB0, 0xD4, 0x03, 0x0E, 0xC0, 0x80, 0x1A, 0x0E, 0x03,
  0x50, 0x30, 0xDB, 0x83, 0xB0, 0xDD, 0x27, 0x18, 0x46, 0xCF, 0xB0, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_spa() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_places_spa_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_sports_bar 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_places_sports_bar_data[] PROGMEM = {
  0x50, 0x27, 0x40, 0x50, 0xEA, 0x81, 0x87, 0x26, 0x87, 0x4F, 0x83, 0x7F, 0xDF, 0x54, 0x81, 0x7F,
  0xC5, 0x08, 0x0E, 0x38, 0x11, 0xF7, 0x38, 0x43, 0x89, 0xBF, 0x12, 0x81, 0x3F, 0x12, 0x07, 0xC8,
  0x7E, 0x41, 0x01, 0xE9, 0x28, 0xF8, 0x3E, 0x20, 0x5E, 0xF8, 0x2A, 0x2F, 0x42, 0x01, 0xF8, 0x29,
  0x0F, 0x43, 0xF8, 0x29, 0x0F, 0x43, 0xF8, 0x29, 0x0F, 0x43, 0xF8, 0x2B, 0x6F, 0x43, 0xFA, 0x0B,
  0x40, 0xDE, 0x06, 0x60, 0x18, 0x02, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_sports_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_sports_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_stairs 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_places_stairs_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD0, 0xA0, 0xBF, 0x85, 0x97, 0x7D, 0xFB, 0xBF, 0x02,
  0x28, 0x2A, 0xFB, 0xBF, 0x02, 0x04, 0xB0, 0x0B, 0xD0, 0x32, 0x04, 0xB0, 0x0B, 0xD8, 0x23, 0x17,
  0xAB, 0x00, 0xBB, 0x82, 0xA7, 0x13, 0xD0, 0x0B, 0xB0, 0x42, 0x03, 0xD0, 0x0B, 0xB0, 0x40, 0x2F,
  0x82, 0xBB, 0xFA, 0x20, 0x2F, 0x85, 0xBB, 0xFD, 0x77, 0x9F, 0x0B, 0x0A, 0xFD, 0x81, 0xA2, 0xA8,
  0x06, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_stairs() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_stairs_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_storefront 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_places_storefront_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0x7F, 0xD0, 0x72, 0x8D, 0x7D, 0x80, 0xC9, 0x0B, 0xB0, 0x9C, 0x08, 0xD0,
  0x2F, 0x30, 0xE7, 0x0B, 0xB0, 0x7E, 0x03, 0xF2, 0x1F, 0x97, 0xFC, 0x5E, 0xE5, 0xCF, 0x79, 0xF1,
  0x07, 0xFD, 0x07, 0x20, 0x4F, 0xD0, 0x42, 0x04, 0xFD, 0x04, 0x20, 0x4F, 0xD0, 0x42, 0x04, 0xFD,
  0x04, 0x20, 0x4F, 0xD0, 0x42, 0x04, 0xFD, 0x04, 0x20, 0x2F, 0xD0, 0x23, 0x02, 0x80, 0x63, 0x02,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_storefront() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_places_storefront_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_stroller 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_places_stroller_data[] PROGMEM = {
  0x28, 0x36, 0x9B, 0x96, 0x28, 0x23, 0xAA, 0x32, 0x0E, 0xD8, 0x75, 0x3E, 0xEE, 0xE1, 0x07, 0xC8,
  0x67, 0x1D, 0xD1, 0x1F, 0x52, 0x07, 0xA8, 0x3A, 0x0C, 0xFB, 0x20, 0x24, 0x82, 0x7B, 0x0B, 0xA0,
  0xB7, 0x20, 0x8B, 0x0B, 0x71, 0x06, 0xC0, 0xB7, 0x04, 0xD0, 0xB6, 0x02, 0x0E, 0xD0, 0xB6, 0x0D,
  0xE0, 0xA6, 0x0A, 0x80, 0x1B, 0x0A, 0x02, 0x48, 0x12, 0x72, 0x50, 0x05, 0x48, 0x1D, 0xFD, 0x40,
  0x5A, 0x05, 0x38, 0x1D, 0xFD, 0x40, 0x5A, 0x05, 0x38, 0x12, 0x72, 0x50, 0x05, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_stroller() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_stroller_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_tapas 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_18_places_tapas_data[] PROGMEM = {
  0x40, 0x15, 0x80, 0x13, 0x40, 0x60, 0xE4, 0x06, 0xD8, 0xA0, 0x61, 0x9B, 0xDF, 0xBB, 0x60, 0x7F,
  0x33, 0x3F, 0x7B, 0xF0, 0x30, 0x79, 0x39, 0x07, 0x0C, 0xF8, 0x90, 0x47, 0xF7, 0x77, 0xF7, 0x3D,
  0xD8, 0x19, 0x07, 0xD8, 0x67, 0x01, 0x39, 0xF3, 0x32, 0x07, 0xD0, 0x70, 0x6E, 0x81, 0xD0, 0x7D,
  0x07, 0x0C, 0xF0, 0x50, 0x4D, 0x04, 0x09, 0xF8, 0x12, 0x0A, 0xB0, 0xA2, 0x85, 0x57, 0xBF, 0x77,
  0x23, 0x81, 0x6F, 0x65, 0x07, 0x96, 0x81, 0x3F, 0x35, 0x07, 0x96, 0x81, 0x3F, 0x35, 0x07, 0x96,
  0x81, 0x3F, 0x35, 0x07, 0x96, 0x81, 0x3F, 0x35, 0x07, 0x95, 0x83, 0x16, 0xF6, 0x14, 0x06, 0x0E,
  0x50, 0x9B, 0x09, 0x50, 0x15, 0x83, 0x13, 0x33, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_tapas() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_places_tapas_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_tty 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_places_tty_data[] PROGMEM = {
  0x83, 0x3B, 0xBB, 0xA7, 0x40, 0x6C, 0x89, 0x23, 0x08, 0x85, 0xC1, 0xD1, 0xC5, 0x4C, 0x89, 0x27,
  0x03, 0x31, 0x50, 0x60, 0x51, 0x1C, 0x09, 0x28, 0x51, 0xA1, 0x83, 0x66, 0x20, 0xCB, 0x04, 0x28,
  0x51, 0xA1, 0x83, 0x66, 0x20, 0x6A, 0x04, 0x28, 0x73, 0x31, 0x50, 0x60, 0x51, 0x20, 0xD0, 0xC3,
  0x87, 0x88, 0x5C, 0x1D, 0x1C, 0x52, 0x81, 0x5F, 0x77, 0x78, 0x19, 0xF5, 0x40, 0x50, 0x37, 0x18,
  0x1B, 0xF6, 0x20, 0xBB, 0x0B, 0x78, 0x2A, 0xFA, 0xBD, 0x71, 0x06, 0x0E, 0xE7, 0x28, 0x11, 0x8E,
  0xC7, 0x58, 0x24, 0x79, 0x82,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_tty() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_places_tty_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_umbrella 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_places_umbrella_data[] PROGMEM = {
  0x50, 0x10, 0x27, 0x05, 0xA0, 0x96, 0x82, 0xBC, 0x8C, 0x60, 0x0B, 0x58, 0x93, 0x30, 0x2D, 0xD2,
  0x03, 0x02, 0xFE, 0xEA, 0x89, 0x3E, 0xEF, 0x20, 0xDE, 0xAC, 0xCA, 0xED, 0x28, 0x68, 0xF1, 0xBB,
  0x1F, 0x82, 0x86, 0x3F, 0x6B, 0xB6, 0xF3, 0x38, 0x4D, 0xBB, 0xBB, 0xD4, 0x84, 0x8F, 0xCC, 0xF8,
  0x40, 0x3C, 0x03, 0x50, 0xDA, 0x0D, 0x60, 0x8A, 0x08, 0x60, 0x3A, 0x03, 0x70, 0x0D, 0x71, 0x00,
  0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_umbrella() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 13, 16), Box(0, 0, 17, 17),
      ic_round_18_places_umbrella_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_vape_free 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_places_vape_free_data[] PROGMEM = {
  0x74, 0x09, 0x0A, 0x40, 0xE0, 0x76, 0x83, 0x33, 0x0B, 0x43, 0x81, 0x6F, 0x74, 0x84, 0x7C, 0x40,
  0xA4, 0x48, 0x16, 0xF7, 0x30, 0xD2, 0x08, 0x0D, 0x68, 0x16, 0xF7, 0x28, 0x5D, 0x20, 0x3A, 0xC1,
  0x58, 0x91, 0x6F, 0x70, 0x3D, 0xBB, 0x47, 0xA6, 0x81, 0x6F, 0x72, 0x83, 0x13, 0xD2, 0xD7, 0x81,
  0x6F, 0x73, 0x82, 0x85, 0xB2, 0x78, 0x16, 0xF7, 0x28, 0x95, 0x54, 0x71, 0x01, 0x13, 0x12, 0x33,
  0xAF, 0x72, 0x82, 0x32, 0x01, 0xB8, 0x26, 0xAE, 0xCB, 0x8A, 0x27, 0x09, 0xF1, 0x03, 0x56, 0x35,
  0x77, 0x77, 0x9F, 0x70, 0x57, 0x58, 0x16, 0xF7, 0x77, 0x06, 0x0E, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_vape_free() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_places_vape_free_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_vaping_rooms 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_places_vaping_rooms_data[] PROGMEM = {
  0x74, 0x09, 0x0A, 0x75, 0x83, 0x33, 0x0B, 0x47, 0x38, 0x47, 0xC4, 0x0A, 0x47, 0x30, 0xD2, 0x08,
  0x0D, 0x74, 0x85, 0xD2, 0x03, 0xAC, 0x17, 0x28, 0x53, 0xDB, 0xB4, 0x7A, 0x74, 0x83, 0x13, 0xD2,
  0xD7, 0x68, 0x28, 0x5B, 0x27, 0x58, 0x90, 0x54, 0x71, 0x01, 0x13, 0x12, 0x80, 0x43, 0x81, 0x20,
  0x1B, 0x82, 0x6A, 0xEC, 0xF8, 0x51, 0x03, 0x56, 0x35, 0x80, 0x47, 0x06, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_vaping_rooms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_places_vaping_rooms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_villa 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_places_villa_data[] PROGMEM = {
  0x68, 0x21, 0x6C, 0x67, 0x10, 0x40, 0xAB, 0x0A, 0x58, 0x11, 0x7D, 0xD0, 0xA4, 0x02, 0xF9, 0x0A,
  0x40, 0x4A, 0x89, 0x2E, 0xA9, 0x99, 0x96, 0x03, 0x20, 0x4A, 0x07, 0x60, 0x3A, 0x02, 0x04, 0xA8,
  0x16, 0x1E, 0xF0, 0x04, 0xA0, 0x60, 0x3F, 0x90, 0x04, 0xA0, 0x60, 0x3B, 0x0E, 0x0D, 0xB0, 0x04,
  0xA0, 0x60, 0x3B, 0x00, 0x5B, 0x00, 0x4A, 0x06, 0x03, 0xB0, 0x50, 0x4B, 0x04, 0x03, 0xA0, 0x50,
  0x2B, 0x05, 0x04, 0xB8, 0x23, 0x03, 0x32, 0x0F, 0x30, 0x01, 0x0F, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_villa() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_places_villa_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_wash 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_places_wash_data[] PROGMEM = {
  0x76, 0x0A, 0x07, 0x77, 0x05, 0xA0, 0x27, 0x60, 0xDA, 0x09, 0x68, 0x61, 0xB7, 0x06, 0xA0, 0xEA,
  0x0A, 0x58, 0x92, 0x2D, 0xFB, 0x0E, 0xF2, 0x5E, 0xC2, 0x40, 0x20, 0xDA, 0x82, 0x30, 0x79, 0x71,
  0x03, 0x0E, 0xA0, 0xD8, 0x03, 0x70, 0x43, 0x03, 0x0E, 0xFC, 0x0E, 0x30, 0xEF, 0x84, 0x65, 0x55,
  0x52, 0x20, 0x3F, 0x98, 0x03, 0xD0, 0x03, 0xFF, 0x81, 0xE4, 0x3F, 0x90, 0x58, 0x01, 0x32, 0x03,
  0xFF, 0x81, 0xA0, 0x3F, 0x90, 0xA8, 0x01, 0x98, 0x13, 0x02, 0xF9, 0x83, 0xA9, 0x99, 0x84, 0x09,
  0xFD, 0x02, 0x40, 0x28, 0x06, 0x30, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_wash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_places_wash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_water_damage 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_places_water_damage_data[] PROGMEM = {
  0x60, 0x03, 0x74, 0x06, 0xA0, 0x67, 0x20, 0x7C, 0x07, 0x70, 0x9E, 0x09, 0x50, 0xAF, 0x90, 0xA2,
  0x01, 0x0B, 0xFB, 0x81, 0xB1, 0xAD, 0x00, 0x5D, 0x81, 0xB0, 0x3B, 0x0C, 0x20, 0xCB, 0x03, 0x20,
  0x3B, 0x08, 0x20, 0x8B, 0x03, 0x20, 0x3B, 0x82, 0xD2, 0x2D, 0xB0, 0x32, 0x03, 0xFB, 0x03, 0x20,
  0x3F, 0xB0, 0x32, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_water_damage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_places_water_damage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_places_wheelchair_pickup 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_places_wheelchair_pickup_data[] PROGMEM = {
  0x20, 0x60, 0x47, 0x50, 0x7A, 0x03, 0x74, 0x07, 0xA0, 0x37, 0x50, 0x60, 0x47, 0x48, 0x32, 0xAB,
  0xB9, 0x73, 0x0A, 0xC8, 0x36, 0x02, 0xD2, 0x50, 0xBC, 0x83, 0x70, 0x3F, 0x35, 0x0B, 0xB8, 0x4D,
  0x30, 0x3F, 0x35, 0x0B, 0xA8, 0x5E, 0x20, 0x83, 0xF3, 0x50, 0xAA, 0x89, 0x06, 0x0C, 0xF3, 0xF9,
  0x77, 0x52, 0x87, 0x16, 0xF1, 0x5F, 0x42, 0xEC, 0x05, 0x28, 0x33, 0xE0, 0x8E, 0x48, 0x92, 0x23,
  0xCE, 0x10, 0x3E, 0x07, 0xF1, 0x38, 0xB1, 0xCB, 0x2F, 0x80, 0x3F, 0x32, 0xFB, 0x21, 0x8F, 0x50,
  0x42, 0x03, 0xFA, 0x05, 0xEB, 0x08, 0x68, 0x66, 0x71, 0x01, 0x56, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_places_wheelchair_pickup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_places_wheelchair_pickup_data, Alpha4(color::Black));
  return value;
}
