#include "maps.h"

using namespace roo_display;

// Image file ic_round_18_maps_360 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_maps_360_data[] PROGMEM = {
  0x48, 0x61, 0x57, 0x99, 0x75, 0x16, 0x04, 0x0C, 0xA8, 0x2D, 0xCC, 0xDA, 0x0C, 0x04, 0x38, 0x27,
  0xFA, 0x46, 0x86, 0x4A, 0xF7, 0x01, 0xF7, 0x73, 0x84, 0x6F, 0x10, 0xF7, 0x73, 0x89, 0x16, 0xF1,
  0x06, 0xFA, 0x40, 0xC7, 0x38, 0x24, 0xAF, 0x73, 0x04, 0x0B, 0xC8, 0x46, 0x03, 0xFB, 0x46, 0x83,
  0x15, 0xDF, 0x57, 0x60, 0xB0, 0x57, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_360() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_maps_360_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_add_business 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_add_business_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x50, 0x24, 0x02, 0x80, 0x47, 0x03, 0x40, 0x38, 0x04, 0x90, 0x54, 0x0A, 0xF9,
  0x0D, 0x40, 0xEF, 0xA0, 0x22, 0x02, 0xFB, 0x05, 0x28, 0x92, 0x4E, 0xED, 0xDD, 0xFD, 0xDE, 0xE7,
  0x30, 0x60, 0x73, 0x0D, 0x20, 0x40, 0x94, 0x06, 0x07, 0x30, 0xD2, 0x82, 0x49, 0x11, 0x20, 0x60,
  0x73, 0x0D, 0x28, 0x22, 0x57, 0x62, 0x84, 0x6B, 0x77, 0x7E, 0x28, 0x51, 0x7B, 0xA7, 0x01, 0x80,
  0x15, 0x28, 0x31, 0x5A, 0x95, 0x74, 0x07, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_add_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_add_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_add_location_alt 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_maps_add_location_alt_data[] PROGMEM = {
  0x73, 0x05, 0x0B, 0x70, 0x02, 0x30, 0x70, 0xD4, 0x81, 0x19, 0xEA, 0x89, 0x07, 0x6B, 0xDE, 0xBA,
  0x02, 0xDC, 0x87, 0x84, 0x9C, 0xE9, 0x80, 0xDE, 0x82, 0x94, 0x7D, 0x20, 0x6F, 0x98, 0x1A, 0x49,
  0x20, 0xBC, 0x00, 0x7B, 0x07, 0x03, 0x20, 0xCB, 0x0A, 0x20, 0xAB, 0x0C, 0x20, 0x9B, 0x82, 0xE2,
  0x2E, 0xB0, 0xB2, 0x05, 0xFB, 0x06, 0x30, 0xDF, 0x90, 0xD4, 0x05, 0xF9, 0x05, 0x50, 0x9E, 0x09,
  0x70, 0xBC, 0x0B, 0x71, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x30, 0x0A, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_add_location_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_add_location_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_add_location 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_add_location_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x20, 0xDF, 0x98,
  0x1D, 0x06, 0xC0, 0x06, 0xC0, 0x60, 0xBC, 0x00, 0x5C, 0x0B, 0x0C, 0xA0, 0x64, 0x06, 0xA0, 0xC0,
  0x9A, 0x84, 0xD9, 0x33, 0x9D, 0xA0, 0xB0, 0x5C, 0x00, 0x5C, 0x81, 0x60, 0xDB, 0x00, 0xDB, 0x0D,
  0x20, 0x5F, 0x90, 0x53, 0x09, 0xE0, 0x95, 0x0B, 0xC0, 0xB6, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x10,
  0x0A, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_add_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_add_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_add_road 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_maps_add_road_data[] PROGMEM = {
  0x01, 0x02, 0x30, 0x01, 0x38, 0x32, 0x10, 0x67, 0x30, 0x06, 0x38, 0x37, 0x60, 0x67, 0x30, 0x01,
  0x38, 0x37, 0x60, 0x67, 0x71, 0x83, 0x76, 0x06, 0x77, 0x18, 0x37, 0x60, 0x67, 0x30, 0x05, 0x38,
  0x37, 0x60, 0x67, 0x30, 0x05, 0x38, 0x36, 0x40, 0x67, 0x74, 0x06, 0x07, 0x71, 0x83, 0x11, 0x06,
  0x73, 0x00, 0x13, 0x83, 0x76, 0x06, 0x73, 0x89, 0x06, 0x60, 0x17, 0xBA, 0x71, 0x23, 0x86, 0x11,
  0x01, 0x5A, 0x95, 0x73, 0x07, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_add_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_add_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_agriculture 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_maps_agriculture_data[] PROGMEM = {
  0x71, 0x02, 0x03, 0x76, 0x02, 0x0C, 0x77, 0x85, 0xA7, 0xA9, 0x99, 0x83, 0x83, 0x2B, 0xBB, 0x92,
  0x01, 0xD0, 0x43, 0x80, 0x03, 0x20, 0x1D, 0x04, 0x38, 0x25, 0xCB, 0x52, 0x05, 0xD0, 0x42, 0x85,
  0x99, 0x11, 0xA7, 0x6A, 0x0E, 0x06, 0x0F, 0x12, 0x0B, 0x40, 0xB0, 0x1A, 0x86, 0x57, 0xDD, 0x60,
  0x2B, 0x48, 0x4D, 0x0B, 0xA2, 0xC2, 0x83, 0xD1, 0x0B, 0x22, 0x03, 0x09, 0x30, 0x30, 0xA2, 0x87,
  0xC1, 0x03, 0xC8, 0x8C, 0x24, 0x82, 0xB9, 0xAA, 0x40, 0x04, 0x70, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_agriculture() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_agriculture_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_airlines 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_maps_airlines_data[] PROGMEM = {
  0x71, 0x83, 0x45, 0x55, 0x47, 0x10, 0xCD, 0x05, 0x60, 0x9E, 0x06, 0x50, 0x5F, 0x03, 0x48, 0x41,
  0xEF, 0xB4, 0x7B, 0x50, 0xAA, 0x01, 0x28, 0x1B, 0xFC, 0x40, 0x5B, 0x02, 0x28, 0x1C, 0xF9, 0x30,
  0x10, 0xEB, 0x81, 0xD7, 0xAA, 0x07, 0x30, 0xBF, 0xA0, 0x42, 0x06, 0xFB, 0x81, 0x10, 0x2F, 0xB0,
  0xD2, 0x03, 0x80, 0x65, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_airlines() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_airlines_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_airline_stops 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_maps_airline_stops_data[] PROGMEM = {
  0x73, 0x0D, 0xB8, 0x33, 0x07, 0x52, 0x60, 0x30, 0xEA, 0x85, 0x41, 0xBE, 0xFA, 0x24, 0x05, 0x0E,
  0xA0, 0x43, 0x82, 0x4C, 0xE4, 0x28, 0x46, 0xF9, 0x4E, 0x45, 0x84, 0x9F, 0x34, 0xF8, 0x20, 0x20,
  0x16, 0x82, 0xAD, 0xDB, 0x74, 0x02, 0xA0, 0x27, 0x50, 0x0C, 0x75, 0x82, 0x4C, 0xC4, 0x74, 0x0C,
  0xA0, 0xC5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_airline_stops() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_maps_airline_stops_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_alt_route 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_maps_alt_route_data[] PROGMEM = {
  0x20, 0x16, 0x01, 0x38, 0x11, 0xD9, 0x48, 0x49, 0xD1, 0x01, 0xDA, 0x09, 0x20, 0x9A, 0x89, 0x4D,
  0x13, 0x5B, 0x95, 0x11, 0x59, 0xB5, 0x32, 0x03, 0x01, 0x40, 0x70, 0x65, 0x0A, 0x40, 0xD0, 0x15,
  0x08, 0x04, 0x20, 0x90, 0x87, 0x82, 0x37, 0x8A, 0x72, 0x00, 0xC7, 0x30, 0x07, 0x73, 0x00, 0x67,
  0x30, 0x06, 0x73, 0x00, 0x67, 0x30, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_alt_route() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_alt_route_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_atm 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_round_18_maps_atm_data[] PROGMEM = {
  0x8E, 0x22, 0xBB, 0x47, 0xBB, 0x91, 0xBB, 0xBB, 0x24, 0xA8, 0x60, 0x69, 0x13, 0xB7, 0x8A, 0x44,
  0xEE, 0x60, 0x58, 0x03, 0xA4, 0x69, 0x42, 0x65, 0x40, 0x35, 0x01, 0x72, 0x06, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_atm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 15, 10), Box(0, 0, 17, 17),
      ic_round_18_maps_atm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_attractions 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_18_maps_attractions_data[] PROGMEM = {
  0x60, 0x01, 0x74, 0x04, 0xA0, 0x47, 0x10, 0x30, 0xAC, 0x0A, 0x03, 0x48, 0x94, 0x27, 0xFB, 0x5C,
  0xC5, 0xBF, 0x72, 0x03, 0xA0, 0xA6, 0x0A, 0xA0, 0x30, 0x5A, 0x86, 0x90, 0x39, 0x93, 0x09, 0xA8,
  0x45, 0x1F, 0xB1, 0x3C, 0x89, 0x03, 0x1B, 0xF1, 0x3F, 0x10, 0x9C, 0x89, 0x09, 0x01, 0xF3, 0x3F,
  0x10, 0x9C, 0x89, 0x09, 0x01, 0xF3, 0x1F, 0xB1, 0x3C, 0x84, 0x31, 0xBF, 0x15, 0xA8, 0x69, 0x4F,
  0x99, 0xF5, 0x9A, 0x05, 0x03, 0xA8, 0x1A, 0xCA, 0x28, 0x1A, 0xCA, 0xA8, 0x23, 0x02, 0x7A, 0x82,
  0x8C, 0xC8, 0xA0, 0x70, 0x24, 0x0B, 0x0E, 0xC0, 0xE0, 0xB6, 0x90, 0x04, 0xA0, 0x04, 0x96, 0x01,
  0x20, 0x01, 0x20, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_attractions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_attractions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_badge 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_maps_badge_data[] PROGMEM = {
  0x70, 0x02, 0x76, 0x08, 0xA0, 0x87, 0x58, 0x2C, 0x99, 0xC7, 0x58, 0x2C, 0x88, 0xC7, 0x89, 0x65,
  0x99, 0x99, 0xE8, 0x8E, 0x99, 0x99, 0x50, 0x2E, 0x00, 0xAE, 0x02, 0x03, 0xFF, 0x00, 0x3F, 0xF0,
  0x03, 0xB8, 0x1D, 0x16, 0xA0, 0xE2, 0x0A, 0xA0, 0x03, 0xB8, 0x1B, 0x03, 0xB8, 0x1A, 0x9E, 0xA0,
  0x03, 0xB8, 0x1E, 0x8B, 0xA8, 0x2E, 0x43, 0xBA, 0x00, 0x3A, 0x0B, 0x38, 0x43, 0xFE, 0x65, 0xCA,
  0x00, 0x3A, 0x0B, 0x80, 0x07, 0xF0, 0x03, 0xFF, 0x81, 0x30, 0xEF, 0xD0, 0xE3, 0x80, 0x90, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_badge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_badge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_bakery_dining 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_bakery_dining_data[] PROGMEM = {
  0x68, 0x26, 0x77, 0x67, 0x30, 0x01, 0xC0, 0x01, 0x68, 0x23, 0xCF, 0x1C, 0x82, 0x1F, 0xC3, 0x40,
  0xAA, 0x02, 0x0E, 0xA0, 0xE0, 0x1A, 0x0A, 0x40, 0x5A, 0x03, 0x0D, 0xA0, 0xD0, 0x3A, 0x06, 0x38,
  0x42, 0x1E, 0xF4, 0xBA, 0x84, 0xB4, 0xFE, 0x12, 0x28, 0x4A, 0x78, 0xF6, 0xAA, 0x89, 0x4A, 0x6F,
  0x87, 0xA0, 0x2F, 0xD2, 0xF7, 0x9A, 0x86, 0x97, 0xF2, 0xDF, 0x25, 0xA8, 0x90, 0x37, 0x54, 0x99,
  0x45, 0x83, 0xA8, 0x25, 0x06, 0x37, 0x30, 0x30, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_bakery_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_maps_bakery_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_beenhere 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_maps_beenhere_data[] PROGMEM = {
  0x18, 0x06, 0x31, 0x09, 0xFB, 0x09, 0x0D, 0xFB, 0x00, 0xDF, 0xB0, 0x0D, 0xFB, 0x00, 0xDE, 0x09,
  0x01, 0xA0, 0x0D, 0xA8, 0x4B, 0xEF, 0x90, 0x7A, 0x00, 0xDA, 0x83, 0x13, 0x80, 0x7B, 0x00, 0xDA,
  0x82, 0xC1, 0x07, 0xC0, 0x0D, 0xB0, 0xD0, 0xBD, 0x00, 0xDF, 0xB0, 0xD0, 0xAF, 0xB8, 0x1A, 0x09,
  0xF9, 0x09, 0x30, 0x6E, 0x06, 0x50, 0x30, 0xDA, 0x0D, 0x03, 0x78, 0x21, 0x88, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_beenhere() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_beenhere_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_bike_scooter 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_maps_bike_scooter_data[] PROGMEM = {
  0x72, 0x81, 0x33, 0x27, 0x78, 0x18, 0x9D, 0x71, 0x82, 0x27, 0x75, 0x40, 0x90, 0x57, 0x83, 0x15,
  0x5D, 0x13, 0x03, 0x0B, 0x73, 0x09, 0x05, 0x40, 0xD0, 0x17, 0x28, 0x90, 0x58, 0x5B, 0xBB, 0xEC,
  0xA5, 0x78, 0x91, 0x2C, 0x01, 0x1A, 0xBD, 0x3B, 0x67, 0x89, 0x0D, 0x01, 0x2D, 0x0C, 0x20, 0xD5,
  0x89, 0x21, 0xAE, 0x29, 0xCB, 0x05, 0x40, 0xD5, 0x82, 0xC6, 0x23, 0x20, 0xD0, 0x12, 0x02, 0x0D,
  0x48, 0x94, 0x4A, 0x5D, 0xC8, 0x04, 0xD7, 0x7D, 0x31, 0xC8, 0x36, 0xA4, 0x1D, 0x28, 0x21, 0x66,
  0x17, 0x82, 0x5D, 0xC8, 0x77, 0x02, 0x03, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_bike_scooter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_bike_scooter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_breakfast_dining 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_maps_breakfast_dining_data[] PROGMEM = {
  0x20, 0x18, 0x06, 0x30, 0x13, 0x05, 0x0E, 0xFB, 0x0E, 0x05, 0x20, 0xEF, 0xD8, 0x1E, 0x02, 0xFF,
  0x81, 0x20, 0xDF, 0xD0, 0xD2, 0x03, 0x0D, 0xC0, 0x07, 0xC0, 0xD0, 0x33, 0x06, 0xB0, 0x52, 0x05,
  0xB0, 0x64, 0x06, 0xA0, 0x74, 0x07, 0xA0, 0x64, 0x06, 0xA0, 0x94, 0x09, 0xA0, 0x64, 0x06, 0xB0,
  0x82, 0x08, 0xB0, 0x64, 0x06, 0xC0, 0xA0, 0x9C, 0x06, 0x40, 0x6F, 0xB0, 0x64, 0x03, 0xFB, 0x03,
  0x50, 0x28, 0x04, 0x30, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_breakfast_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_breakfast_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_brunch_dining 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_maps_brunch_dining_data[] PROGMEM = {
  0x74, 0x82, 0x23, 0x31, 0x74, 0x03, 0xC0, 0x17, 0x38, 0x44, 0xF2, 0x3F, 0x37, 0x38, 0x44, 0xF0,
  0x2F, 0x37, 0x38, 0x44, 0xF0, 0x2F, 0x37, 0x38, 0x44, 0xFB, 0xCF, 0x37, 0x30, 0x4C, 0x03, 0x73,
  0x04, 0xC0, 0x37, 0x30, 0x2C, 0x01, 0x48, 0x12, 0x33, 0x40, 0xBA, 0x0A, 0x50, 0x9A, 0x01, 0x38,
  0x11, 0xDC, 0x28, 0x31, 0xDD, 0xDE, 0xA0, 0xFD, 0x82, 0x80, 0xB9, 0x20, 0x18, 0x05, 0x78, 0x25,
  0x0B, 0x93, 0x80, 0x61, 0x18, 0x3B, 0xA1, 0x02, 0xFA, 0x81, 0xA0, 0x9A, 0x01, 0x18, 0x05, 0x30,
  0x12, 0x03, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_brunch_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_brunch_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_bus_alert 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_maps_bus_alert_data[] PROGMEM = {
  0x74, 0x02, 0x71, 0x0F, 0x38, 0x21, 0x06, 0xEA, 0x09, 0x30, 0x30, 0xCC, 0x01, 0x05, 0xA0, 0xBA,
  0x09, 0x20, 0xEC, 0x81, 0xC0, 0xCA, 0x02, 0x0E, 0xA1, 0x02, 0xD8, 0x1A, 0x0E, 0xA0, 0xBB, 0x89,
  0x02, 0x3F, 0x53, 0x33, 0x20, 0xBA, 0x08, 0xA8, 0x3E, 0x03, 0xF2, 0x50, 0x3A, 0x0E, 0xA8, 0x16,
  0x03, 0x98, 0x01, 0xD8, 0x5B, 0x03, 0xBE, 0xC5, 0x20, 0x3F, 0x0B, 0x02, 0x60, 0x3A, 0x00, 0xEB,
  0x82, 0xEF, 0xC6, 0x40, 0x3A, 0x02, 0x04, 0xA8, 0x3A, 0x0B, 0xF9, 0x40, 0x1A, 0x0A, 0x0B, 0xA8,
  0x3E, 0x7E, 0xF8, 0x50, 0xBF, 0xA0, 0x25, 0x81, 0x4F, 0xE8, 0x01, 0xD9, 0x0A, 0x68, 0x13, 0xF6,
  0x50, 0xE0, 0x97, 0x01, 0x60, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_bus_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_bus_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_car_crash 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_maps_car_crash_data[] PROGMEM = {
  0x72, 0x83, 0x6D, 0xFD, 0x67, 0x20, 0x6A, 0x0D, 0xA0, 0x62, 0x85, 0x15, 0x55, 0x30, 0xDA, 0x01,
  0xA0, 0xD2, 0x0C, 0xB0, 0x81, 0xB0, 0xAB, 0x18, 0x14, 0xF3, 0x40, 0xDA, 0x09, 0xA8, 0x2D, 0x0A,
  0xC5, 0x06, 0xA0, 0xDA, 0x89, 0x76, 0x1F, 0xDB, 0xBB, 0xB8, 0x06, 0xDF, 0xD6, 0x04, 0xF0, 0x96,
  0x04, 0xA0, 0x60, 0xAC, 0x85, 0x91, 0x9A, 0x40, 0x4A, 0x02, 0x07, 0xC0, 0x70, 0x2A, 0x81, 0x40,
  0x4F, 0xD8, 0x14, 0x04, 0xFD, 0x83, 0x40, 0x3F, 0x67, 0x18, 0x16, 0xF3, 0x20, 0x47, 0x30, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_car_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_car_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_car_rental 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_maps_car_rental_data[] PROGMEM = {
  0x82, 0x3D, 0xFA, 0x68, 0xA3, 0xCB, 0x5F, 0xA7, 0x77, 0x72, 0xD9, 0x1E, 0xED, 0xDF, 0xE4, 0x6A,
  0x0E, 0x01, 0x20, 0xB0, 0x92, 0x81, 0x25, 0x13, 0x02, 0x01, 0x75, 0x02, 0x80, 0x2B, 0x03, 0x28,
  0x69, 0xD7, 0x77, 0x7D, 0xA2, 0x89, 0x0E, 0x81, 0x11, 0x17, 0xE0, 0x5F, 0x98, 0x35, 0x7F, 0xBC,
  0xA8, 0x6C, 0xBF, 0x77, 0xF8, 0x9A, 0x83, 0x98, 0xF7, 0x7F, 0x98, 0x17, 0x7D, 0x80, 0x25, 0x82,
  0xD7, 0x02, 0x60, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_car_rental() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_car_rental_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_car_repair 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_maps_car_repair_data[] PROGMEM = {
  0x38, 0x02, 0x35, 0x06, 0xE0, 0x74, 0x0C, 0x09, 0x40, 0x90, 0xD3, 0x89, 0x03, 0xFB, 0x99, 0x99,
  0xBF, 0x32, 0x07, 0xF9, 0x07, 0x28, 0x27, 0xF6, 0x7A, 0x82, 0x76, 0xF7, 0x28, 0x27, 0xFD, 0xDA,
  0x82, 0xDD, 0xF7, 0x20, 0x79, 0x80, 0x2D, 0x90, 0x72, 0x04, 0x08, 0x60, 0x80, 0x42, 0x80, 0x63,
  0x10, 0x4F, 0xB0, 0x45, 0x00, 0xA7, 0x30, 0x09, 0x73, 0x00, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_car_repair() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_car_repair_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_castle 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_maps_castle_data[] PROGMEM = {
  0x40, 0x12, 0x01, 0x20, 0x12, 0x01, 0x78, 0x92, 0x5D, 0x03, 0xF1, 0x1F, 0x30, 0xD5, 0x68, 0x92,
  0x6F, 0x58, 0xF6, 0x6F, 0x85, 0xF6, 0x60, 0x6F, 0xB0, 0x66, 0x06, 0xFB, 0x06, 0x48, 0x18, 0x16,
  0xA8, 0x4C, 0x3E, 0xE3, 0xCA, 0x86, 0x61, 0x80, 0x1F, 0x36, 0xA8, 0x4B, 0x0D, 0xD0, 0xBA, 0x86,
  0x63, 0xF1, 0x1F, 0xEE, 0xA8, 0x4B, 0x0D, 0xD0, 0xBA, 0x83, 0xEE, 0xF1, 0x1F, 0xFA, 0x00, 0x1F,
  0xFA, 0x00, 0x1F, 0x00, 0xCF, 0x00, 0x1E, 0x08, 0x20, 0x8E, 0x00, 0x1E, 0x03, 0x20, 0x3E, 0x81,
  0x10, 0xDD, 0x03, 0x20, 0x3D, 0x0D, 0x20, 0x18, 0x01, 0x34, 0x80, 0x13, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_castle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_castle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_category 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_maps_category_data[] PROGMEM = {
  0x60, 0x02, 0x75, 0x82, 0x1E, 0xE1, 0x74, 0x09, 0xA0, 0x97, 0x30, 0x3C, 0x03, 0x72, 0x0C, 0xC0,
  0xC7, 0x20, 0xEC, 0x0E, 0x73, 0x80, 0x01, 0x77, 0x71, 0x83, 0x89, 0x99, 0x73, 0x09, 0xA8, 0x2A,
  0x10, 0x4D, 0x81, 0x10, 0x9C, 0x81, 0xB0, 0x4D, 0x01, 0x1E, 0x01, 0x04, 0xD0, 0x11, 0xE0, 0x10,
  0x4D, 0x81, 0x10, 0xAC, 0x86, 0xC0, 0x1A, 0xBB, 0xB9, 0x20, 0x10, 0xBA, 0x0C, 0x01, 0x74, 0x00,
  0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_category() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_category_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_celebration 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_maps_celebration_data[] PROGMEM = {
  0x71, 0x0B, 0x02, 0x73, 0x83, 0x2B, 0x04, 0xD7, 0x48, 0x7A, 0x40, 0xC2, 0x1B, 0xEB, 0x58, 0x90,
  0x1D, 0x26, 0xB1, 0xC6, 0x05, 0x38, 0x74, 0x21, 0x46, 0xC1, 0xC6, 0x58, 0x91, 0x1F, 0xE2, 0x09,
  0x1C, 0x61, 0x34, 0x07, 0xA8, 0x7E, 0x20, 0x96, 0x5D, 0xBA, 0x30, 0xCB, 0x89, 0x1E, 0x20, 0x3C,
  0x10, 0x86, 0x02, 0xD8, 0x2E, 0x21, 0x15, 0x08, 0xE0, 0xE0, 0x26, 0x0D, 0xF0, 0x35, 0x03, 0xD8,
  0x1C, 0x71, 0x60, 0x8A, 0x81, 0xD8, 0x27, 0x28, 0x13, 0x83, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_celebration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_celebration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_church 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_maps_church_data[] PROGMEM = {
  0x70, 0x09, 0x76, 0x82, 0x7C, 0xC7, 0x74, 0x84, 0x1C, 0xEE, 0xC1, 0x75, 0x00, 0xA7, 0x50, 0x10,
  0x9A, 0x09, 0x01, 0x72, 0x06, 0x0E, 0xC0, 0xE0, 0x67, 0x05, 0xB0, 0x0E, 0xB0, 0x56, 0x07, 0xA8,
  0x2E, 0x11, 0xEA, 0x07, 0x60, 0x7A, 0x82, 0xE1, 0x1E, 0xA0, 0x74, 0x05, 0x0B, 0xC0, 0x0E, 0xC8,
  0x2B, 0x50, 0x1F, 0xF0, 0x10, 0x3E, 0x00, 0xBE, 0x00, 0x3D, 0x08, 0x20, 0x7D, 0x00, 0x3D, 0x03,
  0x20, 0x3D, 0x81, 0x30, 0xEC, 0x03, 0x20, 0x3C, 0x0E, 0x38, 0x00, 0x34, 0x80, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_church() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_church_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_cleaning_services 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_cleaning_services_data[] PROGMEM = {
  0x50, 0x02, 0x72, 0x06, 0xA0, 0x67, 0x10, 0xBA, 0x0B, 0x71, 0x0C, 0xA0, 0xC7, 0x10, 0xCA, 0x0C,
  0x71, 0x0C, 0xA0, 0xC5, 0x81, 0x3B, 0xDC, 0x85, 0xDB, 0x30, 0x1D, 0x36, 0x83, 0x3D, 0x15, 0x87,
  0x18, 0x28, 0x56, 0x77, 0x18, 0xC4, 0x76, 0x67, 0x03, 0x01, 0x10, 0x30, 0x76, 0x67, 0x0A, 0x36,
  0x63, 0xA0, 0x76, 0x5C, 0x9D, 0xAC, 0xCA, 0xD9, 0xC5, 0x18, 0x06, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_cleaning_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_cleaning_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_compass_calibration 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_maps_compass_calibration_data[] PROGMEM = {
  0x58, 0x22, 0x33, 0x27, 0x81, 0x29, 0xEC, 0x81, 0xE9, 0x23, 0x09, 0xFB, 0x81, 0x90, 0xAF, 0xD0,
  0xA0, 0x7F, 0xD8, 0x16, 0x07, 0xA8, 0x4C, 0x63, 0x36, 0xCA, 0x07, 0x30, 0x06, 0x60, 0x06, 0x77,
  0x70, 0x9A, 0x09, 0x72, 0x06, 0xC0, 0x67, 0x10, 0xAC, 0x0A, 0x71, 0x07, 0xC0, 0x77, 0x20, 0xBA,
  0x0B, 0x74, 0x00, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_compass_calibration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_compass_calibration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_connecting_airports 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_maps_connecting_airports_data[] PROGMEM = {
  0x30, 0x87, 0x40, 0xA0, 0x77, 0x84, 0x13, 0x05, 0xF2, 0x68, 0x61, 0xD9, 0xAF, 0xC9, 0x84, 0x87,
  0x1E, 0xBC, 0xFD, 0xBB, 0x13, 0x84, 0x24, 0x04, 0xF3, 0x72, 0x00, 0x92, 0x01, 0x0A, 0x60, 0xA0,
  0x12, 0x00, 0x97, 0x28, 0x43, 0xF4, 0x04, 0x23, 0x87, 0x1B, 0xBD, 0xFC, 0xBE, 0x14, 0x86, 0x89,
  0xCF, 0xA9, 0xD1, 0x68, 0x42, 0xF5, 0x03, 0x17, 0x07, 0x0A, 0x74, 0x08, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_connecting_airports() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_connecting_airports_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_crisis_alert 18x18, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_round_18_maps_crisis_alert_data[] PROGMEM = {
  0x68, 0x23, 0xDD, 0x37, 0x50, 0xBA, 0x0B, 0x73, 0x81, 0x30, 0xBA, 0x81, 0xA0, 0x37, 0x82, 0x8F,
  0x17, 0xA8, 0x27, 0x1F, 0x85, 0x83, 0x8F, 0x50, 0x3A, 0x83, 0x30, 0x5F, 0x83, 0x89, 0x43, 0xF5,
  0x06, 0x0E, 0xE0, 0x50, 0x5F, 0x32, 0x89, 0x4A, 0xB0, 0xAD, 0x03, 0x30, 0xDA, 0x0B, 0xA2, 0x98,
  0xA3, 0x53, 0xF4, 0x06, 0x60, 0x4F, 0x35, 0xF0, 0x1F, 0x36, 0xE0, 0x6A, 0x89, 0x46, 0x0E, 0x63,
  0xF1, 0x2F, 0x36, 0xE0, 0x6A, 0x8A, 0x36, 0x0E, 0x63, 0xF2, 0x0F, 0x52, 0xF4, 0x06, 0x60, 0x4F,
  0x25, 0x92, 0x84, 0xBB, 0x09, 0xE4, 0x28, 0x44, 0xE9, 0x0B, 0xB2, 0x89, 0x43, 0xF5, 0x09, 0xFE,
  0xEF, 0x90, 0x5F, 0x33, 0x89, 0x29, 0xE5, 0x02, 0x66, 0x20, 0x5E, 0x95, 0x89, 0x09, 0xFB, 0x53,
  0x35, 0xBF, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_crisis_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_crisis_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_delivery_dining 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_maps_delivery_dining_data[] PROGMEM = {
  0x72, 0x82, 0x37, 0x72, 0x50, 0x4B, 0x01, 0x28, 0x26, 0xDE, 0xD6, 0x0F, 0x35, 0x06, 0x0E, 0x58,
  0x28, 0xBB, 0xA5, 0x0B, 0x0D, 0x40, 0xBC, 0x03, 0x38, 0x18, 0xF3, 0x30, 0x1D, 0x03, 0x28, 0x36,
  0xF6, 0x76, 0x20, 0x3D, 0x87, 0xA9, 0x9F, 0x8D, 0xEE, 0xC2, 0x89, 0x59, 0xED, 0xBE, 0xDB, 0xB7,
  0x3F, 0x24, 0xF2, 0x28, 0x39, 0xD7, 0xE6, 0x38, 0x31, 0xFA, 0xBE, 0x38, 0x21, 0xAD, 0x95, 0x82,
  0x5D, 0xC4, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_delivery_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_maps_delivery_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_departure_board 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_maps_departure_board_data[] PROGMEM = {
  0x74, 0x02, 0x71, 0x0F, 0x38, 0x21, 0x06, 0xEA, 0x09, 0x30, 0x30, 0xCC, 0x01, 0x05, 0xA0, 0xBA,
  0x09, 0x20, 0xEC, 0x81, 0xC0, 0xCA, 0x02, 0x0E, 0xA1, 0x02, 0xD8, 0x1A, 0x0E, 0xA0, 0x30, 0x9A,
  0x89, 0x02, 0x3F, 0x53, 0x33, 0x20, 0xBA, 0x86, 0xE4, 0xFE, 0x03, 0xF2, 0x50, 0x3D, 0x81, 0x60,
  0x39, 0x80, 0x1D, 0x85, 0xB0, 0x3B, 0xEC, 0x52, 0x03, 0xF0, 0xB0, 0x26, 0x03, 0xA0, 0x0E, 0xB8,
  0x2E, 0xFC, 0x64, 0x03, 0xA0, 0x20, 0x4A, 0x83, 0xA0, 0xBF, 0x94, 0x01, 0xA0, 0xA0, 0xBA, 0x83,
  0xE7, 0xEF, 0x85, 0x0B, 0xFA, 0x02, 0x58, 0x14, 0xFE, 0x80, 0x1D, 0x90, 0xA6, 0x81, 0x3F, 0x65,
  0x0E, 0x09, 0x70, 0x16, 0x01, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_departure_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_departure_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_design_services 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_design_services_data[] PROGMEM = {
  0x20, 0x46, 0x01, 0x30, 0xFB, 0x48, 0x74, 0xF7, 0x04, 0xB1, 0xEB, 0x30, 0x8A, 0x89, 0x21, 0x0B,
  0x80, 0x9B, 0x5E, 0x38, 0x43, 0x82, 0xB8, 0x4B, 0xA0, 0xE6, 0x0B, 0x0A, 0xB0, 0x56, 0x05, 0xB0,
  0x0B, 0x50, 0x4B, 0x82, 0xA4, 0x9B, 0x30, 0x4B, 0x86, 0x5B, 0x80, 0xDB, 0x03, 0xB0, 0x42, 0x84,
  0xB8, 0x1B, 0x46, 0xA0, 0x44, 0x0F, 0xB1, 0x81, 0x15, 0x36, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_design_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_design_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_diamond 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_maps_diamond_data[] PROGMEM = {
  0x28, 0x00, 0x32, 0x80, 0x03, 0x30, 0xAB, 0x82, 0x95, 0x3C, 0xB8, 0x1A, 0x02, 0xC8, 0x22, 0xDB,
  0x3C, 0x02, 0x08, 0xB0, 0x90, 0x5A, 0x04, 0x0A, 0xB8, 0x96, 0x8A, 0xBB, 0xB2, 0x9B, 0xB8, 0x2B,
  0xBB, 0xA3, 0x80, 0x15, 0x00, 0x38, 0x01, 0x58, 0x13, 0x2E, 0xC0, 0x08, 0xC8, 0x3E, 0x20, 0x3E,
  0xB0, 0x08, 0xB0, 0xE0, 0x33, 0x04, 0xB0, 0x08, 0xB0, 0x45, 0x05, 0xA0, 0x08, 0xA0, 0x57, 0x84,
  0x7F, 0x88, 0xF7, 0x72, 0x82, 0x98, 0x89, 0x74, 0x00, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_diamond() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_diamond_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_dinner_dining 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_dinner_dining_data[] PROGMEM = {
  0x18, 0x01, 0x37, 0x18, 0x51, 0xBC, 0xDB, 0xB9, 0x78, 0x41, 0xAB, 0xCA, 0xA9, 0x80, 0x27, 0x86,
  0x11, 0x9A, 0xB8, 0x9E, 0x80, 0x25, 0x86, 0x12, 0xCD, 0xDC, 0xC8, 0x71, 0x83, 0x89, 0xA7, 0x27,
  0x28, 0x26, 0x79, 0x47, 0x38, 0x26, 0x79, 0x42, 0x83, 0x8D, 0xEB, 0x33, 0x84, 0x67, 0x94, 0x0C,
  0xD0, 0x52, 0x83, 0x6C, 0xD9, 0x7E, 0x0E, 0x20, 0xDF, 0xC0, 0x27, 0x70, 0x6F, 0xD0, 0x61, 0x80,
  0x90, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_dinner_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_dinner_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_bike 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_18_maps_directions_bike_data[] PROGMEM = {
  0x73, 0x82, 0x4E, 0xE2, 0x77, 0x09, 0xA0, 0x67, 0x58, 0x46, 0x63, 0xED, 0x27, 0x40, 0xAA, 0x09,
  0x76, 0x0A, 0xA8, 0x1E, 0xF8, 0x74, 0x07, 0xA8, 0x4E, 0x35, 0xFC, 0x67, 0x28, 0x26, 0xFE, 0x32,
  0x82, 0x3B, 0xE4, 0x72, 0x81, 0x9F, 0x47, 0x38, 0x73, 0xBE, 0xC5, 0x09, 0xF3, 0x28, 0xB0, 0x5C,
  0xEB, 0x30, 0x3F, 0xA6, 0x9F, 0x60, 0xBA, 0x06, 0xF9, 0x6A, 0xF3, 0xBA, 0x38, 0x67, 0xE0, 0xAA,
  0x0E, 0x73, 0x82, 0xAB, 0xE6, 0x38, 0x63, 0xF2, 0xAA, 0x2F, 0x33, 0x82, 0x6E, 0xC9, 0x38, 0x66,
  0xF0, 0xAA, 0x0F, 0x63, 0x8A, 0x59, 0xC5, 0xF7, 0x36, 0xE9, 0x02, 0x20, 0x9E, 0x63, 0x7F, 0x50,
  0x6E, 0xA0, 0x96, 0x09, 0xA0, 0xE0, 0x64, 0x02, 0x73, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_boat_filled 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_18_maps_directions_boat_filled_data[] PROGMEM = {
  0x70, 0x01, 0x76, 0x09, 0xA0, 0x97, 0x28, 0x22, 0x33, 0xDA, 0x82, 0xD3, 0x32, 0x50, 0x3F, 0xB0,
  0x34, 0x06, 0x0E, 0x71, 0x0E, 0x06, 0x40, 0x60, 0xE3, 0x00, 0x13, 0x0E, 0x06, 0x48, 0x36, 0xE1,
  0x6C, 0xA8, 0x3C, 0x61, 0xE6, 0x40, 0x8F, 0xB0, 0x83, 0x0D, 0xFD, 0x81, 0xD0, 0x2F, 0xF8, 0x12,
  0x0D, 0xFD, 0x0D, 0x20, 0x9F, 0xD0, 0x92, 0x05, 0xFD, 0x05, 0x28, 0x31, 0xFE, 0x89, 0xC8, 0x3A,
  0x8E, 0xF1, 0x30, 0x43, 0x82, 0x15, 0x51, 0x30, 0x43, 0x89, 0x63, 0x58, 0xEC, 0x74, 0x47, 0xDE,
  0x84, 0x30, 0x1A, 0x82, 0xC7, 0x9E, 0xA8, 0x2E, 0x97, 0xCA, 0x81, 0x10, 0x17, 0x50, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_boat_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_boat_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_boat 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_18_maps_directions_boat_data[] PROGMEM = {
  0x70, 0x01, 0x76, 0x09, 0xA0, 0x97, 0x28, 0x22, 0x33, 0xDA, 0x82, 0xD3, 0x32, 0x50, 0x3F, 0xB0,
  0x34, 0x06, 0x0E, 0x71, 0x0E, 0x06, 0x40, 0x60, 0xE3, 0x00, 0x13, 0x0E, 0x06, 0x48, 0x36, 0xE1,
  0x6C, 0xA8, 0x3C, 0x61, 0xE6, 0x40, 0x8F, 0xB0, 0x83, 0x0D, 0xFD, 0x81, 0xD0, 0x2F, 0xF8, 0x12,
  0x0D, 0xFD, 0x0D, 0x20, 0x9F, 0xD0, 0x92, 0x05, 0xFD, 0x05, 0x28, 0x31, 0xFE, 0x89, 0xC8, 0x3A,
  0x8E, 0xF1, 0x30, 0x43, 0x82, 0x15, 0x51, 0x30, 0x43, 0x89, 0x63, 0x58, 0xEC, 0x74, 0x47, 0xDE,
  0x84, 0x30, 0x1A, 0x82, 0xC7, 0x9E, 0xA8, 0x2E, 0x97, 0xCA, 0x81, 0x10, 0x17, 0x50, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_boat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_boat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_bus_filled 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_maps_directions_bus_filled_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB0, 0x50, 0x69,
  0x80, 0x45, 0x98, 0x16, 0x6E, 0x71, 0x81, 0xE6, 0x69, 0x80, 0x4B, 0x90, 0x06, 0xFB, 0x00, 0x6F,
  0xB8, 0x46, 0x6F, 0xE1, 0x7A, 0x84, 0x71, 0xEF, 0x65, 0xA0, 0x60, 0xBA, 0x0B, 0x06, 0xA8, 0x15,
  0x1E, 0xF9, 0x82, 0xE1, 0x08, 0xF9, 0x08, 0x28, 0x16, 0xF3, 0x48, 0x13, 0xF6, 0x30, 0x26, 0x02,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_bus_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_bus_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_bus 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_maps_directions_bus_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB0, 0x50, 0x69,
  0x80, 0x45, 0x98, 0x16, 0x6E, 0x71, 0x81, 0xE6, 0x69, 0x80, 0x4B, 0x90, 0x06, 0xFB, 0x00, 0x6F,
  0xB8, 0x46, 0x6F, 0xE1, 0x7A, 0x84, 0x71, 0xEF, 0x65, 0xA0, 0x60, 0xBA, 0x0B, 0x06, 0xA8, 0x15,
  0x1E, 0xF9, 0x82, 0xE1, 0x08, 0xF9, 0x08, 0x28, 0x16, 0xF3, 0x48, 0x13, 0xF6, 0x30, 0x26, 0x02,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_bus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_bus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_car_filled 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_directions_car_filled_data[] PROGMEM = {
  0x20, 0x28, 0x04, 0x70, 0x24, 0x0D, 0x0E, 0x80, 0x2D, 0x0E, 0x0D, 0x38, 0x14, 0xF2, 0x68, 0x12,
  0xF4, 0x20, 0xA0, 0xB7, 0x18, 0x4B, 0xA0, 0x1F, 0xE8, 0x04, 0xD8, 0x2E, 0xF1, 0x4F, 0xD0, 0x04,
  0xA0, 0x40, 0x9C, 0x09, 0x04, 0xA0, 0x04, 0xA0, 0x40, 0x8C, 0x08, 0x04, 0xA0, 0x04, 0xFD, 0x00,
  0x4F, 0xD8, 0x24, 0x3F, 0x67, 0x18, 0x36, 0xF3, 0x02, 0x73, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_car_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_car_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_car 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_directions_car_data[] PROGMEM = {
  0x20, 0x28, 0x04, 0x70, 0x24, 0x0D, 0x0E, 0x80, 0x2D, 0x0E, 0x0D, 0x38, 0x14, 0xF2, 0x68, 0x12,
  0xF4, 0x20, 0xA0, 0xB7, 0x18, 0x4B, 0xA0, 0x1F, 0xE8, 0x04, 0xD8, 0x2E, 0xF1, 0x4F, 0xD0, 0x04,
  0xA0, 0x40, 0x9C, 0x09, 0x04, 0xA0, 0x04, 0xA0, 0x40, 0x8C, 0x08, 0x04, 0xA0, 0x04, 0xFD, 0x00,
  0x4F, 0xD8, 0x24, 0x3F, 0x67, 0x18, 0x36, 0xF3, 0x02, 0x73, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_car() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_car_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_maps_directions_data[] PROGMEM = {
  0x70, 0x01, 0x76, 0x82, 0x4E, 0xE4, 0x74, 0x04, 0xC0, 0x47, 0x20, 0x4E, 0x04, 0x70, 0x4F, 0x90,
  0x45, 0x04, 0xE0, 0xDB, 0x04, 0x30, 0x4B, 0x84, 0xE9, 0x98, 0x0A, 0xB8, 0x24, 0x01, 0xEB, 0x05,
  0x40, 0x2B, 0x82, 0xE1, 0x1E, 0xB8, 0x44, 0x5F, 0xE3, 0xDB, 0x82, 0xE1, 0x04, 0xB0, 0x80, 0x9F,
  0x04, 0x30, 0x4F, 0xB0, 0x45, 0x04, 0xF9, 0x04, 0x70, 0x4E, 0x04, 0x72, 0x04, 0xC0, 0x47, 0x48,
  0x24, 0xEE, 0x47, 0x60, 0x01, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_railway_filled 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_directions_railway_filled_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB0, 0x50, 0x69,
  0x80, 0x45, 0x98, 0x16, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x81, 0xE6, 0x69, 0x80, 0x4D, 0x90,
  0x06, 0xFB, 0x00, 0x6C, 0x00, 0x4C, 0x06, 0x05, 0xC0, 0x09, 0xC8, 0x15, 0x1E, 0xF9, 0x83, 0xE1,
  0x03, 0xCE, 0x0C, 0x03, 0x30, 0x9E, 0x09, 0x40, 0x28, 0x02, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_railway_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_railway_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_railway 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_directions_railway_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB0, 0x50, 0x69,
  0x80, 0x45, 0x98, 0x16, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x81, 0xE6, 0x69, 0x80, 0x4D, 0x90,
  0x06, 0xFB, 0x00, 0x6C, 0x00, 0x4C, 0x06, 0x05, 0xC0, 0x09, 0xC8, 0x15, 0x1E, 0xF9, 0x83, 0xE1,
  0x03, 0xCE, 0x0C, 0x03, 0x30, 0x9E, 0x09, 0x40, 0x28, 0x02, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_railway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_railway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_run 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_directions_run_data[] PROGMEM = {
  0x70, 0x17, 0x38, 0x26, 0xFE, 0x17, 0x10, 0xBA, 0x05, 0x71, 0x81, 0x4D, 0xB7, 0x18, 0x14, 0x84,
  0x70, 0x70, 0xDB, 0x03, 0x58, 0x28, 0xE9, 0xDA, 0x0D, 0x01, 0x40, 0x90, 0xB1, 0xA8, 0x3C, 0xBE,
  0x91, 0x28, 0x16, 0x83, 0xA8, 0x38, 0x06, 0xB3, 0x40, 0x6A, 0x09, 0x58, 0x64, 0x20, 0x9C, 0x5F,
  0x73, 0x02, 0xA8, 0x4E, 0xE9, 0x0A, 0xB5, 0x85, 0x36, 0x92, 0x09, 0xB7, 0x30, 0x90, 0xB7, 0x30,
  0x90, 0xA3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_run() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_run_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_subway_filled 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_directions_subway_filled_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB8, 0x95, 0x56,
  0xF5, 0x55, 0xCC, 0x55, 0x5F, 0x66, 0xE3, 0x00, 0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x95,
  0xE6, 0x6F, 0xDD, 0xDE, 0xED, 0xDD, 0xF6, 0x6F, 0xB8, 0x46, 0x6F, 0xE1, 0x7A, 0x84, 0x71, 0xEF,
  0x65, 0xA0, 0x60, 0xBA, 0x0B, 0x06, 0xA8, 0x15, 0x1E, 0xF9, 0x83, 0xE1, 0x03, 0xCE, 0x0C, 0x03,
  0x30, 0x9E, 0x09, 0x40, 0x28, 0x02, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_subway_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_subway_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_subway 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_directions_subway_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB8, 0x95, 0x56,
  0xF5, 0x55, 0xCC, 0x55, 0x5F, 0x66, 0xE3, 0x00, 0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x95,
  0xE6, 0x6F, 0xDD, 0xDE, 0xED, 0xDD, 0xF6, 0x6F, 0xB8, 0x46, 0x6F, 0xE1, 0x7A, 0x84, 0x71, 0xEF,
  0x65, 0xA0, 0x60, 0xBA, 0x0B, 0x06, 0xA8, 0x15, 0x1E, 0xF9, 0x83, 0xE1, 0x03, 0xCE, 0x0C, 0x03,
  0x30, 0x9E, 0x09, 0x40, 0x28, 0x02, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_subway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_subway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_transit_filled 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_directions_transit_filled_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB8, 0x95, 0x56,
  0xF5, 0x55, 0xCC, 0x55, 0x5F, 0x66, 0xE3, 0x00, 0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x95,
  0xE6, 0x6F, 0xDD, 0xDE, 0xED, 0xDD, 0xF6, 0x6F, 0xB8, 0x46, 0x6F, 0xE1, 0x7A, 0x84, 0x71, 0xEF,
  0x65, 0xA0, 0x60, 0xBA, 0x0B, 0x06, 0xA8, 0x15, 0x1E, 0xF9, 0x83, 0xE1, 0x03, 0xCE, 0x0C, 0x03,
  0x30, 0x9E, 0x09, 0x40, 0x28, 0x02, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_transit_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_transit_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_transit 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_directions_transit_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB8, 0x95, 0x56,
  0xF5, 0x55, 0xCC, 0x55, 0x5F, 0x66, 0xE3, 0x00, 0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x95,
  0xE6, 0x6F, 0xDD, 0xDE, 0xED, 0xDD, 0xF6, 0x6F, 0xB8, 0x46, 0x6F, 0xE1, 0x7A, 0x84, 0x71, 0xEF,
  0x65, 0xA0, 0x60, 0xBA, 0x0B, 0x06, 0xA8, 0x15, 0x1E, 0xF9, 0x83, 0xE1, 0x03, 0xCE, 0x0C, 0x03,
  0x30, 0x9E, 0x09, 0x40, 0x28, 0x02, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_transit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_transit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_directions_walk 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_maps_directions_walk_data[] PROGMEM = {
  0x50, 0x01, 0x78, 0x25, 0xFE, 0x26, 0x09, 0xA0, 0x66, 0x82, 0x3D, 0xB1, 0x58, 0x13, 0x75, 0x50,
  0x60, 0xCB, 0x05, 0x38, 0x26, 0xF9, 0xCA, 0x0E, 0x02, 0x28, 0x93, 0x7D, 0x0D, 0xFD, 0xAE, 0x91,
  0x59, 0x1A, 0x83, 0x90, 0x6B, 0x42, 0x04, 0xA0, 0xA6, 0x83, 0x7D, 0x4F, 0x85, 0x83, 0xAA, 0x09,
  0xC5, 0x83, 0xD7, 0x08, 0xC4, 0x84, 0x1F, 0x40, 0x8C, 0x48, 0x42, 0xF1, 0x07, 0xB5, 0x01, 0x30,
  0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_directions_walk() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_directions_walk_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_dry_cleaning 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_maps_dry_cleaning_data[] PROGMEM = {
  0x60, 0x01, 0x74, 0x08, 0xA0, 0x87, 0x28, 0x32, 0xF7, 0x6E, 0x72, 0x81, 0x2F, 0x57, 0x58, 0x19,
  0xF8, 0x74, 0x82, 0x1C, 0xC1, 0x71, 0x86, 0x39, 0xFE, 0xEF, 0x93, 0x48, 0x34, 0xCF, 0xC6, 0x28,
  0x90, 0x6C, 0xFC, 0x40, 0x2F, 0xB4, 0x80, 0x21, 0x86, 0x4B, 0xF2, 0x2F, 0xAB, 0xE8, 0x6B, 0xAF,
  0x20, 0x6B, 0xDE, 0x81, 0xDB, 0x64, 0x09, 0xE0, 0x96, 0x09, 0xE0, 0x96, 0x09, 0xE0, 0x96, 0x07,
  0xE0, 0x77, 0x80, 0x23, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_dry_cleaning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_dry_cleaning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_edit_attributes 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_maps_edit_attributes_data[] PROGMEM = {
  0x20, 0x10, 0x68, 0x04, 0x90, 0x60, 0x13, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x20, 0xCC, 0x0C, 0x0D,
  0xE8, 0x1C, 0x01, 0xB8, 0x2B, 0xB0, 0xBF, 0x00, 0x1B, 0x81, 0x10, 0xAF, 0x98, 0x11, 0x0C, 0xA0,
  0xE0, 0xDF, 0x90, 0xC2, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x30, 0x10, 0x68, 0x04, 0x90, 0x60, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_edit_attributes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_maps_edit_attributes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_edit_location_alt 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_maps_edit_location_alt_data[] PROGMEM = {
  0x50, 0x02, 0x40, 0x13, 0x81, 0x19, 0xEA, 0x87, 0xE2, 0x07, 0xE1, 0x02, 0xDC, 0x83, 0x60, 0x82,
  0x92, 0x0D, 0xC8, 0x36, 0x0A, 0xF9, 0x20, 0x6C, 0x84, 0x60, 0xAF, 0xC1, 0x20, 0xBB, 0x89, 0x06,
  0x0A, 0xFC, 0x14, 0xA0, 0xCA, 0x89, 0x1C, 0x09, 0xFC, 0x14, 0xEC, 0x0A, 0xA8, 0x91, 0xB0, 0xDC,
  0x14, 0xEF, 0xA0, 0x6A, 0x0C, 0x30, 0x40, 0xEA, 0x06, 0x20, 0xEA, 0x81, 0xB9, 0xAB, 0x0E, 0x30,
  0x5F, 0x90, 0x54, 0x0A, 0xE0, 0xA6, 0x0B, 0xC0, 0xB7, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x20, 0x0B,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_edit_location_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_edit_location_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_edit_location 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_maps_edit_location_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x20, 0xDF, 0x98,
  0x1D, 0x06, 0xD8, 0x1D, 0x3E, 0xA0, 0x60, 0xBC, 0x81, 0xB6, 0xBB, 0x0B, 0x0C, 0xB8, 0x1B, 0x05,
  0xC0, 0xC0, 0x9A, 0x81, 0xB0, 0x5D, 0x0B, 0x05, 0xA0, 0x60, 0x5E, 0x81, 0x60, 0xDF, 0x90, 0xD2,
  0x05, 0xF9, 0x05, 0x30, 0x9E, 0x09, 0x50, 0xBC, 0x0B, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x71, 0x00,
  0xA5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_edit_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_edit_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_edit_road 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_maps_edit_road_data[] PROGMEM = {
  0x01, 0x02, 0x20, 0x10, 0x22, 0x01, 0x02, 0x40, 0x60, 0x72, 0x05, 0x08, 0x20, 0x40, 0x94, 0x06,
  0x07, 0x20, 0x10, 0x22, 0x04, 0x09, 0x40, 0x60, 0x76, 0x04, 0x09, 0x40, 0x60, 0x76, 0x82, 0x49,
  0x01, 0x20, 0x60, 0x72, 0x04, 0x06, 0x28, 0x64, 0x72, 0xEE, 0x26, 0x72, 0x04, 0x06, 0x28, 0x11,
  0x2E, 0xA8, 0x16, 0x67, 0x68, 0x62, 0xD3, 0xDA, 0x06, 0x75, 0x83, 0x2D, 0x38, 0xA2, 0x06, 0x07,
  0x28, 0x51, 0x20, 0xD3, 0x8A, 0x30, 0x60, 0x72, 0x84, 0x58, 0x1D, 0xAA, 0x40, 0x10, 0x22, 0x83,
  0x12, 0x05, 0x55,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_edit_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_edit_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_egg_alt 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_maps_egg_alt_data[] PROGMEM = {
  0x58, 0x11, 0x21, 0x74, 0x04, 0x0C, 0xB0, 0xD0, 0x67, 0x10, 0x6F, 0x09, 0x60, 0x3F, 0xA0, 0x55,
  0x0A, 0xFA, 0x0E, 0x01, 0x40, 0xED, 0x00, 0xDB, 0x0C, 0x30, 0x1D, 0x06, 0x20, 0x6B, 0x0A, 0x20,
  0x2C, 0x0D, 0x40, 0xDB, 0x81, 0x70, 0x1C, 0x0D, 0x40, 0xDB, 0x0E, 0x20, 0xDC, 0x06, 0x20, 0x6D,
  0x81, 0x20, 0x6D, 0x00, 0xDE, 0x02, 0x20, 0x9F, 0xD4, 0x06, 0x0E, 0xFA, 0x0A, 0x68, 0x14, 0x6B,
  0xD0, 0xE0, 0x17, 0x20, 0x8B, 0x0B, 0x01, 0x75, 0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_egg_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_egg_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_egg 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_maps_egg_data[] PROGMEM = {
  0x40, 0x02, 0x60, 0x10, 0xBA, 0x0B, 0x01, 0x40, 0xCC, 0x0C, 0x30, 0x7E, 0x07, 0x20, 0xEE, 0x81,
  0xE0, 0x6F, 0x90, 0x60, 0xAF, 0x98, 0x39, 0xDF, 0x67, 0xD8, 0x3C, 0xEF, 0x63, 0xD8, 0x5E, 0xCF,
  0xC0, 0x6C, 0xB0, 0xC0, 0x6A, 0x81, 0x91, 0x3B, 0x81, 0x60, 0xBE, 0x0B, 0x30, 0x9C, 0x09, 0x60,
  0x03, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_egg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_egg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_electrical_services 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_maps_electrical_services_data[] PROGMEM = {
  0x18, 0x22, 0x55, 0x37, 0x18, 0x33, 0x77, 0xC7, 0x74, 0x0D, 0x73, 0x02, 0x0D, 0x78, 0x33, 0xAB,
  0xD3, 0x68, 0x21, 0xD4, 0x17, 0x10, 0x50, 0x83, 0x0A, 0xA8, 0x49, 0x01, 0x03, 0xC2, 0x02, 0x0E,
  0xA8, 0x7A, 0x4B, 0x30, 0x7D, 0x3C, 0xB0, 0xA7, 0x06, 0x0E, 0xA8, 0x2A, 0x25, 0x15, 0x0D, 0xA8,
  0x2A, 0x37, 0x25, 0x82, 0x25, 0x53, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_electrical_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_electrical_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_electric_bike 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_maps_electric_bike_data[] PROGMEM = {
  0x71, 0x81, 0x23, 0x17, 0x68, 0x1A, 0xBD, 0x77, 0x10, 0x90, 0x47, 0x18, 0x23, 0x77, 0x62, 0x04,
  0x0A, 0x71, 0x82, 0x28, 0xC5, 0x30, 0xD0, 0x14, 0x8B, 0x73, 0x99, 0x40, 0xEB, 0xBB, 0xBE, 0xC8,
  0x30, 0x5C, 0x54, 0xB7, 0x97, 0x33, 0xAC, 0xD4, 0xC5, 0xD1, 0x38, 0x1D, 0x4A, 0x28, 0xA6, 0xD0,
  0xC2, 0x1D, 0xD0, 0x3D, 0xDF, 0xDD, 0xDD, 0xB0, 0x65, 0x0D, 0xD2, 0x20, 0x10, 0xD4, 0x0D, 0x01,
  0x28, 0x62, 0xD4, 0xD6, 0x5C, 0x54, 0x89, 0x15, 0xC6, 0x6D, 0x40, 0x27, 0x83, 0x68, 0x23, 0x77,
  0x27, 0x10, 0x27, 0x68, 0x32, 0x9C, 0xE5, 0x75, 0x83, 0x1A, 0x93, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_electric_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_electric_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_electric_car 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_maps_electric_car_data[] PROGMEM = {
  0x20, 0x28, 0x02, 0x30, 0x23, 0x01, 0x0D, 0x80, 0x29, 0x0D, 0x01, 0x20, 0x07, 0x68, 0x47, 0x70,
  0x1D, 0x16, 0x83, 0x1D, 0x15, 0xE8, 0x04, 0xB8, 0x4E, 0x56, 0xC4, 0xEC, 0x86, 0xE4, 0xC6, 0x6A,
  0x1D, 0xC8, 0x3D, 0x1A, 0x66, 0xFB, 0x82, 0x66, 0xFD, 0x80, 0x2B, 0x84, 0xDF, 0x61, 0x91, 0x68,
  0x11, 0x91, 0x50, 0x17, 0x28, 0x32, 0x7B, 0xD4, 0x71, 0x83, 0x3B, 0xA5, 0x17, 0x20, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_electric_car() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_electric_car_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_electric_moped 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_maps_electric_moped_data[] PROGMEM = {
  0x20, 0x20, 0xF5, 0x30, 0x50, 0x45, 0x03, 0x0F, 0x73, 0x81, 0x7B, 0x54, 0x06, 0x0F, 0x94, 0x06,
  0x07, 0x30, 0xAC, 0x01, 0x30, 0xB0, 0x52, 0x02, 0xD0, 0x12, 0x0B, 0x07, 0x30, 0x4D, 0x8A, 0x41,
  0x0B, 0x78, 0xD8, 0x04, 0xDE, 0xED, 0xFD, 0xD7, 0x3C, 0x1C, 0x32, 0x82, 0x5B, 0x5D, 0x38, 0x32,
  0xD4, 0xD2, 0x38, 0x17, 0x93, 0x48, 0x15, 0x95, 0x70, 0x17, 0x48, 0x32, 0x7B, 0xD4, 0x73, 0x83,
  0x3B, 0xA5, 0x17, 0x40, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_electric_moped() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_electric_moped_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_electric_rickshaw 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_18_maps_electric_rickshaw_data[] PROGMEM = {
  0x10, 0x18, 0x05, 0x30, 0x26, 0x89, 0x2E, 0xBB, 0xBB, 0xEC, 0xBB, 0xCF, 0x44, 0x01, 0x0C, 0x40,
  0xA0, 0x32, 0x82, 0x3C, 0xD2, 0x30, 0x10, 0xC4, 0x0A, 0x03, 0x28, 0x23, 0xA4, 0xC3, 0x01, 0x0C,
  0x40, 0xA0, 0x32, 0x83, 0x3A, 0x07, 0xA2, 0x8A, 0x01, 0xEB, 0xBB, 0xBE, 0xCA, 0x03, 0xEB, 0xBF,
  0x30, 0x1E, 0x82, 0x62, 0x03, 0xC8, 0x14, 0x01, 0xE0, 0x32, 0x03, 0xC8, 0x1C, 0x21, 0xA8, 0x6D,
  0x22, 0xE4, 0x11, 0x4A, 0x86, 0xC1, 0x3D, 0x09, 0xCA, 0x28, 0x6B, 0xCB, 0xBB, 0xBC, 0x82, 0x0D,
  0x38, 0x2D, 0x67, 0xC5, 0x83, 0x1D, 0x68, 0xB3, 0x82, 0x17, 0x71, 0x68, 0x12, 0x86, 0x72, 0x02,
  0x77, 0x83, 0x29, 0xCE, 0x57, 0x68, 0x31, 0xA9, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_electric_rickshaw() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_electric_rickshaw_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_electric_scooter 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_maps_electric_scooter_data[] PROGMEM = {
  0x70, 0xF3, 0x74, 0x82, 0x89, 0xA9, 0x76, 0x0D, 0x76, 0x0C, 0x01, 0x75, 0x09, 0x05, 0x74, 0x81,
  0x2B, 0x87, 0x38, 0x23, 0xD5, 0x13, 0x81, 0x9E, 0x94, 0x8C, 0x4C, 0x39, 0xE9, 0x03, 0xB0, 0xBA,
  0x99, 0x9D, 0x3B, 0x0B, 0x31, 0xD6, 0xD4, 0x33, 0x33, 0x1D, 0x6D, 0x10, 0x38, 0x32, 0x01, 0x38,
  0x13, 0x83, 0x58, 0x32, 0x7B, 0xD4, 0x73, 0x83, 0x3B, 0xA5, 0x17, 0x40, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_electric_scooter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_electric_scooter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_emergency 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_maps_emergency_data[] PROGMEM = {
  0x50, 0x03, 0x72, 0x04, 0xA0, 0x47, 0x10, 0x5A, 0x05, 0x48, 0x33, 0xD9, 0x15, 0xA8, 0x45, 0x19,
  0xD3, 0xAA, 0x0E, 0x0A, 0xA0, 0xA0, 0xEA, 0x81, 0xA4, 0xEF, 0x90, 0xE0, 0x42, 0x08, 0xE0, 0x84,
  0x08, 0xE0, 0x82, 0x04, 0x0E, 0xF9, 0x81, 0xE4, 0xAA, 0x0E, 0x0A, 0xA0, 0xA0, 0xEA, 0x84, 0xA3,
  0xD9, 0x15, 0xA8, 0x35, 0x19, 0xD3, 0x40, 0x5A, 0x05, 0x71, 0x04, 0xA0, 0x47, 0x20, 0x03, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_emergency_recording 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_emergency_recording_data[] PROGMEM = {
  0x10, 0x38, 0x04, 0x50, 0x44, 0x02, 0xFB, 0x05, 0x30, 0x4C, 0x0D, 0x0C, 0xC0, 0x73, 0x04, 0xC0,
  0x60, 0x3C, 0x83, 0x71, 0xC2, 0x4A, 0x89, 0x31, 0x44, 0x26, 0x0D, 0xF8, 0xCF, 0x34, 0xA0, 0xB0,
  0x22, 0x01, 0x09, 0xD0, 0x30, 0x4A, 0x0B, 0x02, 0x20, 0x10, 0x9D, 0x03, 0x04, 0xA8, 0x93, 0x14,
  0x42, 0x60, 0xDF, 0x8C, 0xF3, 0x4C, 0x06, 0x03, 0xC8, 0x37, 0x1B, 0x24, 0xC0, 0xD0, 0xCC, 0x07,
  0x30, 0x2F, 0xB0, 0x54, 0x03, 0x80, 0x45, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_emergency_recording() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_emergency_recording_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_emergency_share 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_maps_emergency_share_data[] PROGMEM = {
  0x28, 0x63, 0x9C, 0xFE, 0xC8, 0x23, 0x89, 0x49, 0xFC, 0x85, 0x58, 0xDF, 0x80, 0x4E, 0x56, 0x81,
  0x6E, 0x43, 0x84, 0x29, 0xCB, 0x81, 0x58, 0x51, 0xFD, 0x89, 0xDE, 0x60, 0x34, 0x03, 0x78, 0x26,
  0x99, 0x66, 0x02, 0x0D, 0xC0, 0xD0, 0x24, 0x0D, 0xE0, 0xD3, 0x06, 0xF9, 0x06, 0x20, 0xAA, 0x82,
  0xE1, 0x1E, 0xA0, 0x92, 0x0A, 0xA8, 0x2E, 0x11, 0xEA, 0x09, 0x20, 0x7B, 0x00, 0xEB, 0x06, 0x30,
  0xDE, 0x0D, 0x40, 0x5E, 0x04, 0x50, 0x8C, 0x08, 0x70, 0x9A, 0x09, 0x72, 0x00, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_emergency_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_maps_emergency_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_ev_station 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_maps_ev_station_data[] PROGMEM = {
  0x10, 0x28, 0x01, 0x36, 0x03, 0xE8, 0x29, 0x0C, 0x42, 0x06, 0xE8, 0x5C, 0x04, 0xE4, 0x06, 0xB0,
  0xEA, 0x85, 0xC1, 0xD7, 0xD1, 0x6B, 0x07, 0xA8, 0x5C, 0x3B, 0x0B, 0x46, 0xA0, 0x90, 0x5A, 0x85,
  0xC0, 0xBE, 0xF4, 0x6A, 0x83, 0x10, 0x5F, 0xC3, 0x86, 0x94, 0x6F, 0xA1, 0x0A, 0xA8, 0x4D, 0x50,
  0x94, 0x6A, 0x0B, 0x03, 0xA8, 0x5C, 0x49, 0x09, 0x46, 0xA0, 0xB0, 0xAA, 0x85, 0xC4, 0x90, 0x94,
  0x6A, 0x0E, 0xB8, 0x5C, 0x49, 0x09, 0x46, 0xE8, 0x5C, 0x49, 0x0A, 0x45, 0xE8, 0x3B, 0x0C, 0xAD,
  0x28, 0x02, 0x30, 0x12, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_ev_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_ev_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_factory 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_maps_factory_data[] PROGMEM = {
  0x75, 0x01, 0x03, 0x77, 0x81, 0x9F, 0x67, 0x68, 0x1B, 0xF8, 0x76, 0x81, 0xEF, 0xB5, 0x01, 0x02,
  0x20, 0x32, 0x01, 0xA0, 0xD3, 0x89, 0x02, 0x8E, 0xB5, 0xCF, 0x50, 0x20, 0xFB, 0x20, 0x9F, 0x09,
  0x80, 0x15, 0x01, 0x02, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xB8, 0x6B, 0xAF, 0xAA, 0xFA, 0xBB, 0x00,
  0x3B, 0x86, 0x63, 0xF5, 0x5F, 0x36, 0xB0, 0x03, 0xB8, 0x66, 0x3F, 0x55, 0xF3, 0x6B, 0x00, 0x3B,
  0x86, 0xCB, 0xFC, 0xCF, 0xBC, 0xB0, 0x03, 0xFF, 0x81, 0x30, 0xEF, 0xD0, 0xE3, 0x80, 0x90, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_factory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_factory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_fastfood 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_maps_fastfood_data[] PROGMEM = {
  0x74, 0x0E, 0x03, 0x76, 0x81, 0x1F, 0x47, 0x38, 0x72, 0x55, 0x6F, 0x85, 0x53, 0x70, 0xBF, 0x0E,
  0x70, 0xBF, 0x0E, 0x78, 0x12, 0x9E, 0xD0, 0xC2, 0x87, 0x28, 0xAB, 0xA5, 0x02, 0xDC, 0x81, 0xA0,
  0x7E, 0x82, 0xD2, 0x1E, 0xB0, 0x90, 0x6F, 0x98, 0x1E, 0x06, 0xB0, 0x70, 0xDF, 0xA0, 0x70, 0x1B,
  0x06, 0x07, 0x80, 0x5B, 0x03, 0x1B, 0x04, 0x75, 0x0E, 0xA0, 0x30, 0xDF, 0xA8, 0x17, 0x0E, 0xA0,
  0x10, 0x48, 0x05, 0x58, 0x12, 0x0E, 0xA1, 0x02, 0x80, 0x53, 0x85, 0x10, 0xEF, 0xD0, 0xEF, 0xA8,
  0x39, 0x0E, 0xF8, 0x18, 0x06, 0x12, 0x00, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_fastfood() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_maps_fastfood_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_festival 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_maps_festival_data[] PROGMEM = {
  0x70, 0x08, 0x75, 0x84, 0x1C, 0xEE, 0xC1, 0x72, 0x86, 0x5E, 0xD2, 0x2C, 0xE5, 0x68, 0x22, 0xAF,
  0x94, 0x82, 0x9F, 0xA2, 0x20, 0x30, 0xBA, 0x07, 0x80, 0x23, 0x07, 0xA8, 0x1B, 0x3E, 0xFF, 0x8A,
  0x6E, 0xF7, 0x19, 0xF3, 0x1D, 0xD1, 0x3F, 0x91, 0x7F, 0x9F, 0xBF, 0xED, 0xCA, 0x8A, 0x4C, 0xDE,
  0xFB, 0xF9, 0x09, 0xF5, 0x1E, 0xB2, 0x2B, 0xE1, 0x5F, 0x92, 0x07, 0x0D, 0x29, 0x05, 0x20, 0x59,
  0x20, 0xD0, 0x62, 0x08, 0x0C, 0x29, 0x04, 0x28, 0x44, 0xF1, 0x0C, 0x72, 0x84, 0x9B, 0x02, 0xF3,
  0x28, 0x42, 0xF2, 0x0B, 0x92, 0x89, 0x4B, 0xA1, 0x5F, 0x31, 0x13, 0xF5, 0x1A, 0xB2, 0x08, 0xFD,
  0x08, 0x30, 0x28, 0x06, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_festival() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_festival_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_fire_hydrant_alt 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_maps_fire_hydrant_alt_data[] PROGMEM = {
  0x60, 0x01, 0x73, 0x05, 0x0D, 0xA0, 0xD0, 0x57, 0x06, 0xE0, 0x65, 0x01, 0x0E, 0xE0, 0xE0, 0x13,
  0x04, 0xFB, 0x04, 0x30, 0x9F, 0x90, 0x94, 0x07, 0xB0, 0x0E, 0xB0, 0x73, 0x0B, 0x0E, 0xA0, 0x72,
  0x07, 0xA8, 0x2E, 0xB0, 0x4B, 0x84, 0xB0, 0x99, 0x0B, 0xB0, 0x04, 0xB0, 0x90, 0x1A, 0x01, 0x09,
  0xB0, 0x40, 0x3B, 0x84, 0xD0, 0x44, 0x0D, 0xB8, 0x23, 0x06, 0xCA, 0x82, 0xB4, 0x4B, 0xA0, 0xC0,
  0x63, 0x07, 0xF9, 0x07, 0x40, 0x8F, 0x90, 0x83, 0x04, 0xFB, 0x04, 0x38, 0x06, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_fire_hydrant_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_fire_hydrant_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_fire_truck 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_maps_fire_truck_data[] PROGMEM = {
  0x75, 0x00, 0x37, 0x71, 0x81, 0x4F, 0xE5, 0x80, 0x37, 0x18, 0x12, 0x7A, 0xA0, 0x70, 0x13, 0x89,
  0x57, 0xC5, 0xE5, 0xC7, 0x0D, 0xED, 0xDD, 0xEC, 0x38, 0x90, 0x5B, 0x3E, 0x3B, 0x50, 0xF5, 0x38,
  0x13, 0xF4, 0x28, 0x03, 0x91, 0x90, 0x54, 0x0B, 0x0C, 0x20, 0x28, 0x03, 0x79, 0x89, 0x0A, 0x77,
  0x77, 0xAF, 0x10, 0xEF, 0xF9, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x81, 0x10, 0xEA, 0x06, 0x07,
  0xE0, 0x70, 0x6A, 0x0E, 0x28, 0x96, 0x38, 0xF5, 0x6F, 0x87, 0x78, 0xF6, 0x5F, 0x83, 0x40, 0xAA,
  0x09, 0x40, 0x9A, 0x0A, 0x70, 0x30, 0x26, 0x02, 0x03, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_fire_truck() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_fire_truck_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_flight_class 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_18_maps_flight_class_data[] PROGMEM = {
  0x01, 0x03, 0x38, 0x51, 0x55, 0x20, 0x7C, 0x30, 0xDA, 0x82, 0xE0, 0x7D, 0x3C, 0x10, 0x60, 0xE3,
  0xC1, 0x81, 0x2F, 0x32, 0xC2, 0x0C, 0x08, 0x20, 0xEB, 0x20, 0x80, 0xD2, 0x82, 0x49, 0x95, 0x28,
  0x13, 0xF2, 0x71, 0x0D, 0x09, 0x80, 0x13, 0x30, 0x6E, 0x05, 0x75, 0x02, 0xE0, 0x53, 0x80, 0x23,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_flight_class() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_flight_class_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_flight 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_flight_data[] PROGMEM = {
  0x70, 0xE0, 0xD7, 0x60, 0x1A, 0x01, 0x75, 0x01, 0xA0, 0x17, 0x50, 0x1A, 0x01, 0x75, 0x02, 0xA0,
  0x27, 0x40, 0x50, 0xDA, 0x0D, 0x05, 0x71, 0x03, 0x0B, 0xE0, 0xB0, 0x34, 0x01, 0x09, 0xFB, 0x89,
  0x09, 0x10, 0x1E, 0xFE, 0xA5, 0x3A, 0x89, 0x03, 0x59, 0xEF, 0xE1, 0x05, 0x33, 0x01, 0xA0, 0x13,
  0x03, 0x05, 0x70, 0x1A, 0x01, 0x75, 0x01, 0xA0, 0x17, 0x50, 0x9A, 0x09, 0x74, 0x84, 0x8C, 0x77,
  0xC8, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_flight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_flight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_forest 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_maps_forest_data[] PROGMEM = {
  0x50, 0x30, 0x82, 0x08, 0x03, 0x73, 0x84, 0xDF, 0x43, 0xFD, 0x72, 0x07, 0xA8, 0x3D, 0x2E, 0xF7,
  0x70, 0x2C, 0x07, 0x06, 0xA0, 0x26, 0x0B, 0xD8, 0x22, 0xCF, 0xB5, 0x05, 0xE0, 0xB0, 0x3A, 0x05,
  0x40, 0xCF, 0x82, 0x3D, 0xFC, 0x40, 0x8E, 0x83, 0xD1, 0xDF, 0x83, 0x03, 0xF9, 0x09, 0x05, 0xA0,
  0x32, 0x0C, 0xFA, 0x84, 0x3A, 0xFC, 0x07, 0xFB, 0x0D, 0x02, 0xA8, 0x47, 0x47, 0x77, 0x8A, 0x87,
  0xB7, 0x77, 0x70, 0x77, 0x44, 0x02, 0xA8, 0x38, 0x59, 0x91, 0x72, 0x84, 0xDF, 0x44, 0xFD, 0x74,
  0x01, 0x20, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_forest() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_forest_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_fork_left 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_maps_fork_left_data[] PROGMEM = {
  0x58, 0x13, 0xC5, 0x50, 0x40, 0xEA, 0x05, 0x48, 0x3B, 0xBF, 0xBD, 0x58, 0x11, 0xF3, 0x20, 0x10,
  0x52, 0x85, 0x1F, 0x30, 0x2D, 0xC2, 0x8A, 0x01, 0xF3, 0x0D, 0xFD, 0xC9, 0x3F, 0x30, 0xAF, 0xA8,
  0xDA, 0x03, 0x20, 0xB0, 0xD2, 0x81, 0xBF, 0x33, 0x02, 0x28, 0x13, 0xF3, 0x68, 0x11, 0xF3, 0x68,
  0x11, 0xF3, 0x70, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_fork_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_fork_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_fork_right 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_maps_fork_right_data[] PROGMEM = {
  0x18, 0x15, 0xC3, 0x50, 0x5A, 0x0E, 0x03, 0x48, 0x3D, 0xBF, 0xBB, 0x58, 0x13, 0xF1, 0x68, 0x13,
  0xF1, 0x20, 0x50, 0x12, 0x81, 0x3F, 0x12, 0x89, 0x4C, 0xD2, 0x03, 0xF3, 0x9C, 0xDF, 0xD0, 0x3A,
  0x87, 0xD8, 0xAF, 0xA0, 0x3F, 0xB2, 0x0D, 0x0B, 0x28, 0x13, 0xF3, 0x20, 0x23, 0x81, 0x3F, 0x16,
  0x81, 0x3F, 0x17, 0x02, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_fork_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_fork_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_fort 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_maps_fort_data[] PROGMEM = {
  0x10, 0x22, 0x02, 0x20, 0x22, 0x02, 0x20, 0x22, 0x8A, 0x32, 0x01, 0xF3, 0x2F, 0x23, 0xF1, 0x1F,
  0x32, 0xF2, 0x3F, 0x11, 0xF0, 0x01, 0xF8, 0x11, 0x0D, 0xD0, 0xD2, 0x0D, 0xD0, 0xD2, 0x01, 0x0D,
  0xB0, 0xD0, 0x12, 0x01, 0x0D, 0xB0, 0xD0, 0x13, 0x04, 0xB0, 0x44, 0x04, 0xB0, 0x44, 0x04, 0xB8,
  0x4E, 0xDD, 0xDD, 0xEB, 0x04, 0x40, 0x4F, 0xD0, 0x44, 0x04, 0xFD, 0x04, 0x30, 0x10, 0xDD, 0x00,
  0xCD, 0x0D, 0x01, 0x20, 0xDD, 0x09, 0x20, 0x8D, 0x81, 0xD0, 0x1E, 0x03, 0x20, 0x3E, 0x01, 0x1E,
  0x03, 0x20, 0x3E, 0x20, 0x28, 0x01, 0x34, 0x80, 0x13, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_fort() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_fort_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_hail 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_maps_hail_data[] PROGMEM = {
  0x48, 0x22, 0xDD, 0x22, 0x02, 0x50, 0x8A, 0x83, 0x80, 0x1F, 0x44, 0x03, 0xA8, 0x23, 0x07, 0xE6,
  0x84, 0x11, 0x06, 0xF7, 0x48, 0x53, 0x8A, 0xBD, 0xF8, 0x40, 0x8D, 0x05, 0x48, 0x17, 0xF8, 0xC0,
  0x34, 0x81, 0xE6, 0x3C, 0x03, 0x38, 0x24, 0xF1, 0x3C, 0x03, 0x48, 0x62, 0x03, 0xFB, 0xBF, 0x33,
  0x87, 0x15, 0x13, 0xF1, 0x1F, 0x33, 0x87, 0x6F, 0x63, 0xF1, 0x1F, 0x33, 0x87, 0x6F, 0x63, 0xF1,
  0x1F, 0x33, 0x87, 0x5F, 0x53, 0xF1, 0x1F, 0x34, 0x03, 0x20, 0x12, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_hail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_hail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_handyman 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_maps_handyman_data[] PROGMEM = {
  0x71, 0x00, 0x16, 0x0A, 0x06, 0x38, 0x11, 0xD6, 0x50, 0xAA, 0x06, 0x28, 0x3C, 0xFE, 0xD1, 0x30,
  0x6A, 0x0C, 0x20, 0x30, 0xCA, 0x0D, 0x01, 0x38, 0x26, 0xDD, 0x32, 0x09, 0xB0, 0xA5, 0x87, 0x3D,
  0x33, 0xD9, 0xA9, 0xC6, 0x82, 0x3D, 0xD3, 0x30, 0x26, 0x82, 0x3D, 0x31, 0x71, 0x06, 0xA0, 0x30,
  0x2A, 0x06, 0x50, 0x6A, 0x0E, 0x2B, 0x06, 0x30, 0x6B, 0x06, 0x20, 0x6B, 0x81, 0x60, 0x2B, 0x06,
  0x40, 0x6B, 0x83, 0x20, 0xDF, 0x66, 0x81, 0x6F, 0xD3, 0x02, 0x71, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_handyman() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_handyman_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_hardware 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_maps_hardware_data[] PROGMEM = {
  0x30, 0x20, 0xF3, 0x30, 0x32, 0x02, 0x0C, 0xC8, 0x59, 0x0B, 0xF4, 0x0C, 0xD0, 0xC0, 0xBA, 0x06,
  0x03, 0xFB, 0x83, 0x61, 0x33, 0x6B, 0x0C, 0x08, 0xA0, 0x63, 0x03, 0xB8, 0x3C, 0x08, 0xF3, 0x38,
  0x31, 0x55, 0x54, 0x78, 0x31, 0x55, 0x54, 0x70, 0x3B, 0x0C, 0x70, 0x3B, 0x0C, 0x70, 0x3B, 0x0C,
  0x70, 0x3B, 0x0C, 0x70, 0x2B, 0x0B, 0x71, 0x0F, 0x30, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_hardware() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_hardware_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_home_repair_service 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_maps_home_repair_service_data[] PROGMEM = {
  0x48, 0x41, 0x55, 0x55, 0x17, 0x18, 0x4A, 0x97, 0x79, 0xA7, 0x10, 0xA0, 0x32, 0x03, 0x0A, 0x58,
  0x94, 0x9B, 0xBE, 0xCB, 0xBC, 0xEB, 0xB9, 0x04, 0xFD, 0x00, 0x4F, 0xD8, 0xB4, 0x44, 0xDD, 0x6A,
  0xDD, 0xDD, 0xA6, 0xDD, 0x41, 0x33, 0x12, 0x33, 0x33, 0x21, 0x33, 0x14, 0xA0, 0x90, 0xDC, 0x0D,
  0x09, 0xA0, 0x04, 0xFD, 0x04, 0x03, 0xFD, 0x81, 0x30, 0x48, 0x06, 0x50, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_home_repair_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_home_repair_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_hotel 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_hotel_data[] PROGMEM = {
  0x10, 0x47, 0x72, 0x81, 0x1F, 0x35, 0x02, 0x80, 0x27, 0x03, 0x28, 0x71, 0xF3, 0x06, 0x82, 0x0C,
  0xF8, 0x46, 0x01, 0xF3, 0xAA, 0x81, 0xE1, 0xDF, 0x83, 0xE0, 0x1F, 0x4C, 0x05, 0x0D, 0xF9, 0x83,
  0x11, 0xF3, 0xDB, 0x03, 0x0D, 0xF9, 0x89, 0x01, 0x1F, 0x32, 0xBC, 0x60, 0xDF, 0x98, 0x21, 0x1F,
  0x68, 0x01, 0x30, 0xEF, 0x90, 0x01, 0xFF, 0xA8, 0x21, 0x1F, 0x58, 0x09, 0x01, 0x84, 0x5F, 0x11,
  0xF3, 0x75, 0x83, 0x3F, 0x10, 0x47, 0x70, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_hotel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_hotel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_hvac 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_maps_hvac_data[] PROGMEM = {
  0x18, 0x06, 0x51, 0x05, 0xFB, 0x05, 0x06, 0xB8, 0x2C, 0x77, 0xCB, 0x00, 0x6A, 0x84, 0x73, 0x99,
  0x37, 0xA8, 0xE0, 0x66, 0xFC, 0x27, 0x88, 0x72, 0xCF, 0x66, 0xF7, 0x6B, 0xBB, 0xB6, 0x7F, 0x66,
  0xF7, 0x6B, 0xBB, 0xB6, 0x7F, 0x66, 0xFC, 0x27, 0x88, 0x72, 0xCF, 0x66, 0xA8, 0x47, 0x39, 0x93,
  0x7A, 0x00, 0x6B, 0x82, 0xC7, 0x7C, 0xB0, 0x60, 0x5F, 0xB0, 0x51, 0x80, 0x65, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_hvac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_hvac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_icecream 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_maps_icecream_data[] PROGMEM = {
  0x40, 0x40, 0xCA, 0x0C, 0x04, 0x70, 0x5E, 0x05, 0x60, 0xEE, 0x0E, 0x50, 0x7F, 0x90, 0x73, 0x09,
  0xFB, 0x81, 0x90, 0x2F, 0xD0, 0x20, 0x3F, 0xD8, 0x13, 0x0D, 0xFB, 0x0D, 0x28, 0x92, 0x2A, 0xEE,
  0x9D, 0xD9, 0xEE, 0xA2, 0x48, 0x14, 0xF3, 0x28, 0x13, 0xF4, 0x70, 0x0B, 0x20, 0x0B, 0x71, 0x84,
  0x4F, 0x33, 0xF4, 0x72, 0x82, 0xCB, 0xBC, 0x73, 0x04, 0xA0, 0x47, 0x40, 0x0A, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_icecream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_icecream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_kebab_dining 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_18_maps_kebab_dining_data[] PROGMEM = {
  0x28, 0x13, 0xD2, 0x48, 0x12, 0xD3, 0x30, 0xCB, 0x09, 0x20, 0x9B, 0x81, 0xC0, 0x3D, 0x2D, 0x81,
  0x31, 0xEB, 0x0C, 0x20, 0xCB, 0x85, 0xE1, 0x01, 0x6E, 0x54, 0x89, 0x15, 0xE6, 0x10, 0x2B, 0xBE,
  0xBA, 0x28, 0x5A, 0xBE, 0xBB, 0x24, 0xD0, 0x01, 0xD0, 0x04, 0xD0, 0x01, 0xD8, 0x54, 0x3D, 0xDF,
  0xDD, 0x28, 0x4D, 0xDF, 0xDD, 0x32, 0x81, 0x3D, 0x24, 0x81, 0x2D, 0x33, 0x0C, 0xB0, 0x92, 0x09,
  0xB8, 0x1C, 0x03, 0xD2, 0xD8, 0x13, 0x1E, 0xB0, 0xC2, 0x0C, 0xB8, 0x5E, 0x10, 0x16, 0xE5, 0x48,
  0x25, 0xE6, 0x14, 0x0D, 0x60, 0xD6, 0x0C, 0x60, 0xC3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_kebab_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_kebab_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_layers_clear 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_maps_layers_clear_data[] PROGMEM = {
  0x06, 0x01, 0x38, 0x21, 0xAA, 0x14, 0x84, 0xCD, 0x10, 0x3E, 0xA0, 0xE0, 0x33, 0x84, 0x1D, 0xD1,
  0x3E, 0xC0, 0x73, 0x84, 0x1F, 0xD1, 0x3E, 0xC0, 0xA2, 0x05, 0xA8, 0x2D, 0x13, 0xEC, 0x82, 0x50,
  0x3E, 0xA8, 0x2D, 0x13, 0xEA, 0x0E, 0x03, 0x20, 0x30, 0xDA, 0x84, 0xD1, 0x3E, 0xD3, 0x28, 0x22,
  0x11, 0xBA, 0x89, 0x2D, 0x12, 0x11, 0x20, 0xBD, 0x30, 0x8A, 0x8A, 0x0D, 0x10, 0xCB, 0x01, 0xBF,
  0x50, 0x23, 0xDD, 0x12, 0x13, 0x81, 0x8F, 0x92, 0x82, 0x9F, 0xD1, 0x58, 0x75, 0xEC, 0xCE, 0x6D,
  0xD1, 0x58, 0x62, 0xBB, 0x20, 0x1D, 0xD7, 0x40, 0x10, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_layers_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_layers_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_layers 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_maps_layers_data[] PROGMEM = {
  0x48, 0x21, 0xAA, 0x17, 0x03, 0x0E, 0xA0, 0xE0, 0x35, 0x06, 0xE0, 0x73, 0x0A, 0xF9, 0x81, 0xA0,
  0x5F, 0xB8, 0x15, 0x3E, 0xF9, 0x83, 0xE2, 0x03, 0xDE, 0x85, 0xD3, 0x02, 0x11, 0xBC, 0x87, 0xB1,
  0x12, 0xBD, 0x30, 0x8A, 0x89, 0x77, 0x03, 0xDB, 0x1B, 0xF5, 0x02, 0x20, 0x5F, 0xB1, 0x28, 0x18,
  0xF9, 0x28, 0x19, 0xF8, 0x58, 0x45, 0xEC, 0xCE, 0x57, 0x82, 0x2B, 0xB2, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_layers() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_layers_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_liquor 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_18_maps_liquor_data[] PROGMEM = {
  0x72, 0x00, 0x37, 0x50, 0x8A, 0x0D, 0x74, 0x82, 0xAB, 0x7E, 0x48, 0x26, 0x77, 0x63, 0x0A, 0xA0,
  0xE3, 0x84, 0x4F, 0xDD, 0xF2, 0x28, 0x1A, 0xC9, 0x93, 0x8A, 0x64, 0xF0, 0x2F, 0x30, 0x6F, 0x62,
  0xF9, 0x10, 0x4F, 0x02, 0xF3, 0xAF, 0x82, 0x89, 0x25, 0xEE, 0x04, 0xFD, 0xDF, 0x3D, 0x74, 0x82,
  0x2F, 0x34, 0xC0, 0x30, 0xDF, 0x03, 0x04, 0xC0, 0x20, 0xDF, 0x81, 0x30, 0xDA, 0x81, 0xC0, 0xDF,
  0x86, 0x30, 0x1D, 0xB1, 0x0D, 0xF0, 0x32, 0x0B, 0x09, 0x28, 0xA7, 0xDB, 0x77, 0x77, 0x8F, 0x30,
  0x1B, 0xA1, 0x0D, 0x81, 0x11, 0x13, 0xF3, 0x3C, 0x01, 0x0A, 0xE0, 0xE2, 0x0F, 0x30, 0x22, 0x80,
  0x23, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_liquor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_liquor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_activity 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_maps_local_activity_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x05, 0x81, 0x20, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xE0, 0x0E, 0xE8, 0x13,
  0x1D, 0xD0, 0x06, 0xD0, 0xD0, 0x12, 0x0E, 0xA0, 0xC0, 0x12, 0x01, 0x0C, 0xA0, 0xE4, 0x0E, 0xB0,
  0x72, 0x07, 0xB0, 0xE2, 0x01, 0x0D, 0xC8, 0x28, 0x11, 0x8C, 0x81, 0xD1, 0x3D, 0x82, 0xDE, 0xED,
  0xD0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x28, 0x09, 0x05, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_activity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_local_activity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_airport 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_maps_local_airport_data[] PROGMEM = {
  0x60, 0x01, 0x75, 0x00, 0xC7, 0x50, 0x0D, 0x75, 0x00, 0xD7, 0x50, 0x0D, 0x74, 0x06, 0xA0, 0x67,
  0x10, 0x10, 0xBC, 0x0B, 0x01, 0x50, 0x60, 0xEE, 0x0E, 0x06, 0x28, 0x97, 0x1B, 0xFB, 0x61, 0xDD,
  0x16, 0xBF, 0xB1, 0x16, 0x13, 0x00, 0xD3, 0x81, 0x16, 0x16, 0x00, 0xD7, 0x48, 0x22, 0xEE, 0x27,
  0x28, 0x41, 0xEE, 0xEE, 0x17, 0x20, 0x12, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_airport() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_airport_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_atm 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_maps_local_atm_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xD8, 0x2E, 0x66, 0xDD,
  0x00, 0x3D, 0x82, 0x45, 0x58, 0xD0, 0x03, 0xD8, 0x23, 0x67, 0xCD, 0x00, 0x3D, 0x82, 0xC7, 0x63,
  0xD0, 0x03, 0xD8, 0x28, 0x55, 0x4D, 0x00, 0x3D, 0x82, 0xD6, 0x6E, 0xD0, 0x03, 0xFF, 0x03, 0x01,
  0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_atm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_local_atm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_bar 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_maps_local_bar_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x82, 0x22, 0xF7, 0x71, 0x85, 0x7F, 0x20, 0x6F, 0xA8,
  0x02, 0x98, 0x1A, 0xF6, 0x30, 0x8F, 0x90, 0x85, 0x0A, 0xE0, 0xA7, 0x0B, 0xC0, 0xB7, 0x10, 0x10,
  0xDA, 0x0D, 0x01, 0x72, 0x82, 0x2E, 0xE2, 0x74, 0x00, 0xA7, 0x50, 0x0A, 0x75, 0x00, 0xA7, 0x10,
  0x5F, 0x90, 0x55, 0x80, 0x43, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_cafe 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_maps_local_cafe_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x11, 0x03, 0xFC, 0x81, 0xE1, 0x6F, 0xA8, 0x37, 0x2F, 0x36, 0xFA, 0x83,
  0x72, 0xF3, 0x6F, 0xA8, 0x39, 0x5F, 0x36, 0xFC, 0x81, 0xD0, 0x6F, 0xA0, 0x80, 0x12, 0x06, 0xFA,
  0x07, 0x30, 0x4F, 0xA0, 0x54, 0x0C, 0xF0, 0xD6, 0x06, 0x80, 0x19, 0x06, 0x77, 0x50, 0x4F, 0xB0,
  0x43, 0x80, 0x63, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_cafe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_cafe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_car_wash 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_maps_local_car_wash_data[] PROGMEM = {
  0x20, 0x10, 0xA2, 0x00, 0x62, 0x0A, 0x01, 0x48, 0x90, 0x6F, 0x30, 0xCC, 0x03, 0xF6, 0x40, 0x10,
  0x72, 0x00, 0x52, 0x07, 0x01, 0x77, 0x40, 0x38, 0x04, 0x90, 0x34, 0x0E, 0x0D, 0x80, 0x2B, 0x0D,
  0x0E, 0x38, 0x15, 0xF1, 0x68, 0x11, 0xF5, 0x20, 0x0B, 0x71, 0x82, 0xBB, 0x02, 0xFD, 0x02, 0x04,
  0xFD, 0x00, 0x4A, 0x03, 0x07, 0xC0, 0x70, 0x3A, 0x00, 0x4A, 0x05, 0x09, 0xC0, 0x90, 0x5A, 0x00,
  0x4F, 0xD8, 0x24, 0x4F, 0xE8, 0x04, 0xD8, 0x4E, 0xF4, 0x3F, 0x67, 0x18, 0x36, 0xF3, 0x01, 0x73,
  0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_car_wash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_car_wash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_convenience_store 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_18_maps_local_convenience_store_data[] PROGMEM = {
  0x20, 0x18, 0x06, 0x30, 0x13, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x28, 0x94, 0x8D, 0x0A, 0xC0, 0xBB,
  0x0C, 0xA0, 0xD8, 0x28, 0xC4, 0xD8, 0x0C, 0xA0, 0xBB, 0x0A, 0xC0, 0x8D, 0x02, 0xF3, 0x0F, 0x70,
  0xBB, 0x07, 0xF0, 0x3F, 0x20, 0xEA, 0x9F, 0xD7, 0xA8, 0x47, 0xDF, 0x9A, 0xE2, 0x06, 0xFD, 0x06,
  0x20, 0x4B, 0x0D, 0x0E, 0xF0, 0x42, 0x04, 0xA8, 0x69, 0x30, 0xEE, 0x3B, 0x6A, 0x04, 0x20, 0x4A,
  0x86, 0x93, 0x0E, 0xD2, 0x86, 0xA0, 0x42, 0x04, 0xA8, 0x16, 0x58, 0xA8, 0x16, 0x46, 0xA0, 0x42,
  0x04, 0xA8, 0x1B, 0x78, 0xB0, 0xE0, 0xBA, 0x04, 0x20, 0x2F, 0xD0, 0x23, 0x02, 0x80, 0x63, 0x02,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_convenience_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_convenience_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_dining 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_maps_local_dining_data[] PROGMEM = {
  0x73, 0x02, 0x03, 0x30, 0xA0, 0x66, 0x09, 0xA8, 0x1C, 0x03, 0xA0, 0x64, 0x09, 0xC0, 0x03, 0xB0,
  0x63, 0xD8, 0x12, 0x0C, 0xB0, 0x62, 0xC0, 0x92, 0x02, 0x0E, 0xA8, 0x19, 0x07, 0xB0, 0x94, 0x85,
  0x2E, 0x90, 0x7F, 0x77, 0x18, 0x11, 0x07, 0xA0, 0x77, 0x28, 0x47, 0xF7, 0x7F, 0x77, 0x81, 0x7F,
  0x72, 0x81, 0x7F, 0x75, 0x81, 0x7F, 0x74, 0x81, 0x7F, 0x73, 0x81, 0x6F, 0x76, 0x81, 0x7F, 0x62,
  0x0D, 0x07, 0x71, 0x07, 0x0D, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_local_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_drink 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_maps_local_drink_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x01, 0xFD, 0x82, 0x11, 0xF5, 0x80, 0x41, 0x84, 0x5F, 0x10, 0xE6,
  0x71, 0x06, 0x0E, 0x20, 0xC0, 0x87, 0x10, 0x80, 0xC2, 0x0B, 0x0D, 0x80, 0x4B, 0x0D, 0x0B, 0x20,
  0x9F, 0xB0, 0x92, 0x07, 0xC0, 0x09, 0xC0, 0x72, 0x05, 0xB0, 0xC2, 0x0C, 0xB0, 0x52, 0x03, 0xB0,
  0x42, 0x04, 0xB0, 0x32, 0x01, 0xB4, 0xB0, 0x13, 0x0E, 0xA0, 0x42, 0x04, 0xA0, 0xE4, 0x0C, 0xB0,
  0x09, 0xB0, 0xC4, 0x0A, 0xF9, 0x0B, 0x40, 0x6F, 0x90, 0x65, 0x02, 0x80, 0x23, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_drink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_drink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_fire_department 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_maps_local_fire_department_data[] PROGMEM = {
  0x40, 0x10, 0x87, 0x20, 0x20, 0xE9, 0x71, 0x01, 0x0D, 0xA8, 0x12, 0x02, 0x50, 0xCB, 0x82, 0xEA,
  0xFB, 0x30, 0x7F, 0x90, 0x72, 0x0E, 0xB0, 0x0E, 0xB8, 0x1E, 0x03, 0xB8, 0x2E, 0x23, 0xEB, 0x03,
  0x05, 0xB8, 0x24, 0x11, 0x4B, 0x05, 0x04, 0xA8, 0x46, 0x0C, 0xC0, 0x6A, 0x84, 0x41, 0xFD, 0x09,
  0xA8, 0x69, 0x0D, 0xF1, 0x0A, 0xA1, 0xC1, 0x00, 0xA2, 0x82, 0x1A, 0x0B, 0xA8, 0x2B, 0x0A, 0x13,
  0x86, 0x10, 0x18, 0x81, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_fire_department() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_local_fire_department_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_florist 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_maps_local_florist_data[] PROGMEM = {
  0x58, 0x24, 0xEE, 0x47, 0x18, 0x14, 0x7C, 0xA8, 0x1C, 0x74, 0x50, 0x4F, 0x90, 0x44, 0x07, 0xA8,
  0x2C, 0x22, 0xCA, 0x07, 0x48, 0x21, 0xDF, 0x42, 0x82, 0x4F, 0xD1, 0x40, 0x3A, 0x05, 0x20, 0x5A,
  0x03, 0x40, 0x7A, 0x82, 0xE7, 0x7E, 0xA0, 0x74, 0x02, 0x0E, 0xE0, 0xE0, 0x26, 0x02, 0x0A, 0xA0,
  0xA0, 0x24, 0x89, 0x51, 0xEC, 0x60, 0x1A, 0xA1, 0x06, 0xCE, 0x11, 0xB0, 0xB0, 0x12, 0x01, 0x0B,
  0xB8, 0x11, 0x0B, 0xB0, 0xB2, 0x0B, 0xB0, 0xB2, 0x02, 0xC0, 0x05, 0xC0, 0x23, 0x04, 0x0E, 0xA0,
  0x0B, 0xA0, 0xE0, 0x45, 0x86, 0x2A, 0xEE, 0xEE, 0xA2, 0x72, 0x00, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_florist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_florist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_gas_station 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_maps_local_gas_station_data[] PROGMEM = {
  0x10, 0x28, 0x01, 0x36, 0x03, 0xE8, 0x29, 0x0C, 0x42, 0x06, 0x0E, 0x48, 0x78, 0xC0, 0x4E, 0x40,
  0x6E, 0x48, 0x78, 0xC1, 0xD7, 0xD1, 0x6E, 0x48, 0xA3, 0x8C, 0x3B, 0x0B, 0x46, 0xF5, 0x55, 0x5B,
  0xC0, 0xBE, 0xF4, 0x6E, 0x0C, 0x38, 0x19, 0x46, 0xF8, 0x4D, 0x50, 0x94, 0x6E, 0x85, 0xC4, 0x90,
  0x94, 0x6E, 0x85, 0xC4, 0x90, 0x94, 0x6E, 0x85, 0xC4, 0x90, 0x94, 0x6E, 0x85, 0xC4, 0x90, 0xA4,
  0x5E, 0x83, 0xB0, 0xCA, 0xD2, 0x80, 0x23, 0x01, 0x20, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_gas_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_gas_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_grocery_store 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_maps_local_grocery_store_data[] PROGMEM = {
  0x02, 0x03, 0x76, 0xA0, 0xA7, 0x58, 0x21, 0x6F, 0x68, 0x06, 0x53, 0x0D, 0xFC, 0x02, 0x20, 0x7F,
  0xB0, 0xB3, 0x01, 0xFB, 0x04, 0x40, 0x9F, 0x90, 0xD5, 0x03, 0xF9, 0x06, 0x50, 0x59, 0x80, 0x2D,
  0x0A, 0x60, 0xE0, 0x97, 0x58, 0x11, 0xFC, 0x80, 0x4B, 0x02, 0x40, 0x58, 0x05, 0x90, 0x14, 0x00,
  0x56, 0x00, 0x54, 0x04, 0xA0, 0x34, 0x03, 0xA0, 0x43, 0x82, 0x2F, 0xE1, 0x48, 0x21, 0xEF, 0x24,
  0x00, 0x16, 0x00, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_grocery_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_grocery_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_hospital 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_maps_local_hospital_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4D, 0x00, 0xAD, 0x00, 0x4D,
  0x00, 0x1D, 0x00, 0x4D, 0x00, 0x1D, 0x00, 0x4A, 0x81, 0xA2, 0x12, 0x81, 0x12, 0xAA, 0x00, 0x4A,
  0x81, 0xA2, 0x12, 0x81, 0x12, 0xAA, 0x00, 0x4D, 0x00, 0x1D, 0x00, 0x4D, 0x00, 0x1D, 0x00, 0x4D,
  0x00, 0xAD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_hospital() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_hospital_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_hotel 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_local_hotel_data[] PROGMEM = {
  0x10, 0x47, 0x72, 0x81, 0x1F, 0x35, 0x02, 0x80, 0x27, 0x03, 0x28, 0x71, 0xF3, 0x06, 0x82, 0x0C,
  0xF8, 0x46, 0x01, 0xF3, 0xAA, 0x81, 0xE1, 0xDF, 0x83, 0xE0, 0x1F, 0x4C, 0x05, 0x0D, 0xF9, 0x83,
  0x11, 0xF3, 0xDB, 0x03, 0x0D, 0xF9, 0x89, 0x01, 0x1F, 0x32, 0xBC, 0x60, 0xDF, 0x98, 0x21, 0x1F,
  0x68, 0x01, 0x30, 0xEF, 0x90, 0x01, 0xFF, 0xA8, 0x21, 0x1F, 0x58, 0x09, 0x01, 0x84, 0x5F, 0x11,
  0xF3, 0x75, 0x83, 0x3F, 0x10, 0x47, 0x70, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_hotel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_local_hotel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_laundry_service 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_maps_local_laundry_service_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x38, 0x11, 0x02, 0xFB, 0x02, 0x06, 0xFB, 0x86, 0x66, 0xFE, 0x2E, 0x4B, 0xC0,
  0x06, 0xA8, 0x2A, 0xFB, 0xEC, 0x00, 0x6F, 0xB0, 0x06, 0xB8, 0x29, 0x44, 0x9B, 0x00, 0x6A, 0x08,
  0x40, 0x8A, 0x00, 0x6A, 0x30, 0x30, 0x71, 0xA8, 0x26, 0x6F, 0xE2, 0x86, 0x3E, 0xB0, 0xEF, 0x66,
  0xA8, 0x41, 0x0E, 0xF5, 0x1A, 0x00, 0x6A, 0x0B, 0x40, 0xBA, 0x00, 0x6B, 0x82, 0xD9, 0x9D, 0xB0,
  0x06, 0xFB, 0x06, 0x02, 0xFB, 0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_laundry_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_laundry_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_library 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_maps_local_library_data[] PROGMEM = {
  0x40, 0x10, 0xAA, 0x0A, 0x01, 0x71, 0x0A, 0xC0, 0xA7, 0x1E, 0x70, 0x1E, 0x01, 0x70, 0xBC, 0x0B,
  0x58, 0x35, 0x72, 0x1B, 0xA8, 0x5B, 0x12, 0x75, 0x03, 0xB8, 0x4B, 0x21, 0x12, 0xBB, 0x03, 0x04,
  0xD0, 0x06, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x04, 0x03, 0xFD, 0x83, 0x30, 0x6B,
  0xEE, 0x81, 0xEB, 0x65, 0x07, 0x0E, 0xA8, 0x1E, 0x71, 0x71, 0x82, 0x19, 0x91, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_mall 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_maps_local_mall_data[] PROGMEM = {
  0x40, 0x10, 0xBA, 0x0B, 0x01, 0x71, 0x84, 0xDC, 0x55, 0xCD, 0x78, 0x16, 0xE1, 0x28, 0x11, 0xE6,
  0x48, 0x94, 0x57, 0xBD, 0x77, 0x77, 0xDB, 0x75, 0x03, 0xFD, 0x03, 0x04, 0xFD, 0x00, 0x4A, 0x0B,
  0x07, 0xC0, 0x70, 0xBA, 0x00, 0x4A, 0x81, 0xA0, 0xBA, 0x81, 0xB0, 0xAA, 0x00, 0x4B, 0x84, 0x40,
  0x55, 0x04, 0xB0, 0x04, 0xC8, 0x28, 0x44, 0x8C, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x81, 0x41, 0xEF, 0xB8, 0x2E, 0x10, 0x18, 0x06, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_mall() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_mall_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_movies 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_maps_local_movies_data[] PROGMEM = {
  0x10, 0x22, 0x80, 0x03, 0x28, 0x42, 0x05, 0xE0, 0x9C, 0x83, 0x90, 0xE5, 0x6F, 0xB8, 0x36, 0x6F,
  0x5C, 0xC8, 0x6C, 0x5F, 0x66, 0xE1, 0xBC, 0x83, 0xB1, 0xE6, 0x6F, 0xB8, 0x36, 0x6E, 0x3B, 0xC8,
  0x6B, 0x3E, 0x66, 0xE3, 0xBC, 0x83, 0xB3, 0xE6, 0x6F, 0xB8, 0x36, 0x6E, 0x1B, 0xC8, 0x6B, 0x1E,
  0x66, 0xF5, 0xCC, 0x83, 0xC5, 0xF6, 0x6F, 0xB8, 0x36, 0x5E, 0x09, 0xC8, 0x49, 0x0E, 0x50, 0x22,
  0x80, 0x03, 0x20, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_movies() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_movies_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_offer 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_local_offer_data[] PROGMEM = {
  0x28, 0x01, 0x30, 0x27, 0x20, 0xEE, 0x0A, 0x70, 0x3A, 0x00, 0xEC, 0x0A, 0x68, 0x33, 0xFE, 0x01,
  0xD0, 0xA5, 0x83, 0x3F, 0xE1, 0x2E, 0x0A, 0x40, 0x3F, 0xC0, 0xA3, 0x03, 0xFD, 0x0A, 0x20, 0x2F,
  0xE0, 0xA2, 0x0A, 0xFE, 0x02, 0x20, 0xAF, 0xC0, 0xB4, 0x0A, 0xFA, 0x0C, 0x60, 0xAF, 0x0C, 0x71,
  0x0A, 0xD0, 0xC7, 0x30, 0xAB, 0x0C, 0x75, 0x81, 0xAF, 0xB7, 0x70, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_offer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_offer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_parking 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_maps_local_parking_data[] PROGMEM = {
  0x18, 0x01, 0x34, 0x06, 0xE0, 0x82, 0x09, 0xF8, 0x19, 0x09, 0xA8, 0x26, 0x56, 0xDA, 0x01, 0x09,
  0xA0, 0x12, 0x05, 0xA0, 0x50, 0x9A, 0x01, 0x20, 0x9A, 0x03, 0x09, 0xA8, 0x1D, 0xDE, 0xA8, 0x1D,
  0x09, 0xE8, 0x2E, 0x40, 0x9A, 0x0F, 0xB0, 0x80, 0x22, 0x09, 0xA0, 0x16, 0x09, 0xA0, 0x16, 0x09,
  0xA0, 0x16, 0x81, 0x6F, 0xD7, 0x10, 0x30, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_parking() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_parking_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_pharmacy 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_local_pharmacy_data[] PROGMEM = {
  0x73, 0x0D, 0x02, 0x74, 0x81, 0x6F, 0x13, 0x04, 0x80, 0x37, 0x84, 0xCD, 0x74, 0x01, 0xFD, 0x00,
  0x1F, 0xD8, 0x11, 0x0B, 0xC0, 0x07, 0xC0, 0xB2, 0x06, 0xC0, 0x05, 0xC0, 0x62, 0x01, 0xA8, 0x47,
  0x31, 0x13, 0x7A, 0x01, 0x20, 0x2A, 0x84, 0x85, 0x11, 0x58, 0xA0, 0x22, 0x07, 0xC0, 0x05, 0xC0,
  0x72, 0x0C, 0xC0, 0x08, 0xC8, 0x1C, 0x01, 0xFD, 0x81, 0x11, 0xEF, 0xB8, 0x2E, 0x10, 0x18, 0x06,
  0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_pharmacy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_pharmacy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_phone 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_maps_local_phone_data[] PROGMEM = {
  0x10, 0xF3, 0x02, 0x72, 0x03, 0xB0, 0xE7, 0x20, 0x2C, 0x04, 0x72, 0xC0, 0x67, 0x20, 0xBA, 0x0D,
  0x01, 0x72, 0x82, 0x5F, 0xD1, 0x74, 0x0D, 0x0A, 0x75, 0x81, 0x4F, 0x57, 0x58, 0x18, 0xE3, 0x38,
  0x11, 0x64, 0x68, 0x4A, 0xE5, 0x01, 0xDA, 0x0E, 0x02, 0x58, 0x28, 0xFA, 0xDC, 0x04, 0x60, 0x40,
  0xDD, 0x04, 0x71, 0x05, 0x0B, 0xB0, 0x37, 0x40, 0x20, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_pizza 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_maps_local_pizza_data[] PROGMEM = {
  0x58, 0x22, 0x33, 0x27, 0x81, 0x4A, 0xEC, 0x81, 0xEA, 0x42, 0x02, 0x0B, 0xFB, 0x81, 0xB2, 0xAC,
  0x0E, 0xF0, 0xA0, 0x6B, 0x06, 0x01, 0xF8, 0x16, 0x0C, 0xA0, 0xB0, 0x7E, 0x0C, 0x20, 0x2F, 0xB0,
  0x23, 0x07, 0xB0, 0x05, 0xB0, 0x75, 0x0C, 0xA0, 0x08, 0xA0, 0xC6, 0x02, 0xE0, 0x27, 0x07, 0xC0,
  0x77, 0x20, 0xCA, 0x0C, 0x73, 0x82, 0x2E, 0xE2, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_pizza() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_local_pizza_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_play 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_maps_local_play_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x05, 0x81, 0x20, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xE0, 0x0E, 0xE8, 0x13,
  0x1D, 0xD0, 0x06, 0xD0, 0xD0, 0x12, 0x0E, 0xA0, 0xC0, 0x12, 0x01, 0x0C, 0xA0, 0xE4, 0x0E, 0xB0,
  0x72, 0x07, 0xB0, 0xE2, 0x01, 0x0D, 0xC8, 0x28, 0x11, 0x8C, 0x81, 0xD1, 0x3D, 0x82, 0xDE, 0xED,
  0xD0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x28, 0x09, 0x05, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_local_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_police 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_local_police_data[] PROGMEM = {
  0x38, 0x43, 0x9E, 0xE9, 0x34, 0x07, 0x0D, 0xE8, 0x2D, 0x70, 0xAF, 0xB0, 0xA0, 0xDF, 0xB0, 0x0D,
  0xC0, 0x0C, 0xC0, 0x0D, 0xB8, 0x2B, 0x44, 0xBB, 0x0D, 0x0C, 0xA0, 0xD0, 0x12, 0x01, 0x0D, 0xA0,
  0xC0, 0xBB, 0x0A, 0x20, 0xAB, 0x0B, 0x08, 0xB8, 0x28, 0x66, 0x8B, 0x08, 0x02, 0xFB, 0x81, 0x20,
  0xAF, 0x90, 0xA2, 0x01, 0x0E, 0xE0, 0xE0, 0x13, 0x02, 0x0D, 0xC0, 0xD0, 0x25, 0x01, 0x09, 0xA0,
  0x90, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_police() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_police_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_post_office 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_maps_local_post_office_data[] PROGMEM = {
  0x70, 0x10, 0xF3, 0x73, 0x05, 0x0D, 0xD0, 0xB0, 0x26, 0x89, 0x16, 0xF9, 0x31, 0x12, 0x4C, 0xE2,
  0x48, 0x11, 0xE7, 0x70, 0xC0, 0xB4, 0x05, 0x97, 0x10, 0x49, 0x40, 0x70, 0xD2, 0x87, 0x7B, 0xBB,
  0x40, 0x2F, 0x23, 0x07, 0x0D, 0x28, 0x76, 0x99, 0x94, 0x02, 0xF3, 0x30, 0x70, 0xD7, 0x18, 0x32,
  0xF3, 0x1D, 0xF9, 0x07, 0x28, 0x42, 0xF3, 0x3F, 0xED, 0x81, 0xEF, 0xA2, 0x89, 0x42, 0xF3, 0x3F,
  0x42, 0xAF, 0xD5, 0x0C, 0xA2, 0x82, 0x2F, 0x33, 0xA8, 0x68, 0x12, 0x04, 0xCF, 0xA2, 0x82, 0x2F,
  0x33, 0xB8, 0x1E, 0x8B, 0xF9, 0x00, 0x3F, 0xA8, 0x5C, 0x55, 0x7F, 0x31, 0xFA, 0x09, 0x28, 0x31,
  0xF2, 0x01, 0x80, 0x43, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_post_office() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_post_office_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_printshop 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_maps_local_printshop_data[] PROGMEM = {
  0x48, 0x04, 0x37, 0x05, 0xF9, 0x05, 0x60, 0x7F, 0x90, 0x76, 0x02, 0x80, 0x45, 0x02, 0x40, 0x40,
  0xA8, 0x06, 0xB8, 0x2A, 0x40, 0x1F, 0xF0, 0x10, 0x3F, 0xB0, 0xB0, 0x4A, 0x00, 0x3F, 0xB0, 0xE0,
  0xBA, 0x00, 0x3F, 0xF0, 0x30, 0x2B, 0x0D, 0x80, 0x23, 0x0D, 0xB8, 0x42, 0x07, 0x9C, 0xD6, 0x82,
  0xDC, 0x97, 0x40, 0x70, 0xD6, 0x0D, 0x07, 0x60, 0x5F, 0x90, 0x57, 0x80, 0x43, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_printshop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_printshop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_see 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_round_18_maps_local_see_data[] PROGMEM = {
  0x73, 0x83, 0x5C, 0xEC, 0x77, 0x40, 0x9D, 0x0C, 0x72, 0x04, 0xB0, 0xCB, 0x07, 0x58, 0x71, 0x50,
  0x9F, 0xED, 0x3E, 0xA0, 0xC5, 0x89, 0x7D, 0xE0, 0xBF, 0xD3, 0x01, 0xBF, 0xE0, 0x59, 0x9C, 0xA0,
  0x10, 0x7A, 0x81, 0x91, 0x5A, 0x0C, 0x02, 0xE0, 0x60, 0x2A, 0x81, 0xBF, 0xBA, 0x05, 0x03, 0xE8,
  0x19, 0x07, 0xD8, 0x1B, 0x03, 0xC0, 0xC0, 0x23, 0x0A, 0xB8, 0x2D, 0x10, 0x3C, 0x89, 0x03, 0x3D,
  0xD3, 0x0B, 0xFD, 0x22, 0x03, 0xB8, 0x1E, 0x0B, 0xA0, 0xB2, 0x84, 0x61, 0x22, 0x03, 0xB8, 0x1E,
  0x09, 0xA8, 0x79, 0x05, 0x03, 0xE3, 0x03, 0xC8, 0x65, 0x07, 0x70, 0x6F, 0xCA, 0x81, 0x30, 0x3D,
  0x82, 0x72, 0x27, 0xD8, 0x13, 0x03, 0xFF, 0x03, 0x20, 0xEF, 0xD0, 0xE4, 0x80, 0x90, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_see() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_local_see_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_shipping 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_local_shipping_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x57, 0x0E, 0xFB, 0x07, 0x50, 0x1F, 0xC0, 0x95, 0x01, 0xFC, 0x82, 0xDB, 0xA1,
  0x20, 0x1F, 0xC8, 0x2D, 0x9D, 0xA2, 0x01, 0xFC, 0x85, 0x90, 0x3F, 0x60, 0x1F, 0xC8, 0x5A, 0x11,
  0x9E, 0x01, 0xFF, 0xA0, 0x11, 0xB0, 0xCF, 0x90, 0xCB, 0x8A, 0x01, 0x04, 0xDA, 0x0A, 0xD9, 0x99,
  0x9D, 0xA0, 0xAD, 0x63, 0x83, 0x7E, 0x9E, 0x74, 0x83, 0x7E, 0x9E, 0x75, 0x81, 0x8C, 0x86, 0x81,
  0x8C, 0x83,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_shipping() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_local_shipping_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_local_taxi 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_local_taxi_data[] PROGMEM = {
  0x58, 0x29, 0xDD, 0x97, 0x82, 0x27, 0x7D, 0xA8, 0x2D, 0x77, 0x24, 0x0D, 0x0E, 0x80, 0x2D, 0x0E,
  0x0D, 0x38, 0x14, 0xF2, 0x68, 0x12, 0xF4, 0x20, 0xA0, 0xB7, 0x18, 0x4B, 0xA0, 0x1F, 0xE8, 0x04,
  0xD8, 0x2E, 0xF1, 0x4F, 0xD0, 0x04, 0xA0, 0x40, 0x9C, 0x09, 0x04, 0xA0, 0x04, 0xA0, 0x40, 0x8C,
  0x08, 0x04, 0xA0, 0x04, 0xFD, 0x00, 0x4F, 0xD8, 0x24, 0x3F, 0x67, 0x18, 0x36, 0xF3, 0x02, 0x73,
  0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_local_taxi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_local_taxi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_lunch_dining 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_maps_lunch_dining_data[] PROGMEM = {
  0x68, 0x22, 0x33, 0x27, 0x20, 0x40, 0xAE, 0x0A, 0x05, 0x40, 0x10, 0xAF, 0xB0, 0xA0, 0x12, 0x0A,
  0xFD, 0x0A, 0x20, 0xEF, 0xD0, 0xE2, 0x01, 0x80, 0x90, 0x30, 0x12, 0x8B, 0x71, 0x89, 0x40, 0x29,
  0x92, 0x04, 0x98, 0x10, 0x1E, 0xDB, 0xFD, 0xFC, 0xCF, 0xDF, 0xCD, 0xE1, 0x05, 0x28, 0x14, 0x75,
  0x28, 0x15, 0x74, 0x20, 0x52, 0x01, 0x80, 0x90, 0x38, 0x21, 0x01, 0xEF, 0xD8, 0x1E, 0x13, 0xFF,
  0x81, 0x31, 0xEF, 0xD8, 0x2E, 0x10, 0x18, 0x09, 0x03, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_lunch_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_lunch_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_map 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_maps_map_data[] PROGMEM = {
  0x40, 0x01, 0x72, 0x81, 0x38, 0xDA, 0x87, 0xB7, 0x20, 0x5A, 0xD2, 0x3B, 0x82, 0xC5, 0x9E, 0xD0,
  0x04, 0xB0, 0xB3, 0x03, 0x0D, 0xB0, 0x04, 0xB0, 0xB4, 0x0B, 0xB0, 0x04, 0xB0, 0xB4, 0x0B, 0xB0,
  0x04, 0xB0, 0xB4, 0x0B, 0xB0, 0x04, 0xB0, 0xB4, 0x0B, 0xB0, 0x04, 0xB0, 0xB4, 0x0B, 0xB0, 0x04,
  0xB0, 0xB4, 0x0B, 0xB0, 0x04, 0xB0, 0xD0, 0x33, 0x0B, 0xB0, 0x04, 0xD8, 0x2E, 0x95, 0xCB, 0x87,
  0x32, 0xDA, 0x50, 0x27, 0xBA, 0x81, 0xD8, 0x37, 0x20, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_map_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_maps_ugc 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_maps_maps_ugc_data[] PROGMEM = {
  0x70, 0x01, 0x74, 0x81, 0x3A, 0xEB, 0x0B, 0x03, 0x70, 0x8F, 0x90, 0x85, 0x08, 0xFB, 0x08, 0x30,
  0x3F, 0xD0, 0x32, 0x0A, 0xD0, 0x0A, 0xD0, 0xB2, 0xE0, 0x05, 0xE1, 0x02, 0xC8, 0x4A, 0x51, 0x15,
  0xAC, 0x00, 0x2C, 0x84, 0xA5, 0x11, 0x5A, 0xC0, 0x21, 0xE0, 0x05, 0xE2, 0x0B, 0xD0, 0x0A, 0xD0,
  0xA2, 0x0B, 0xFD, 0x03, 0x2F, 0xD0, 0x82, 0x05, 0xFC, 0x08, 0x30, 0x9B, 0x00, 0xBC, 0x0A, 0x03,
  0x48, 0x14, 0x95, 0x40, 0x01, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_maps_ugc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_maps_ugc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_medical_information 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_maps_medical_information_data[] PROGMEM = {
  0x70, 0x03, 0x76, 0x0C, 0xA0, 0xC7, 0x59, 0x00, 0x69, 0x75, 0x90, 0x05, 0x97, 0x89, 0x65, 0x99,
  0x99, 0xF5, 0x5F, 0x99, 0x99, 0x50, 0x2E, 0x00, 0x7E, 0x02, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03,
  0xB0, 0x80, 0x5B, 0x80, 0x0D, 0xA0, 0x03, 0xA8, 0x97, 0xA3, 0x29, 0xEC, 0x33, 0x33, 0xEF, 0x33,
  0xFE, 0x22, 0x02, 0x0C, 0xF0, 0x03, 0xB0, 0x60, 0x3A, 0x82, 0xC2, 0x19, 0xB0, 0x03, 0xB0, 0xC0,
  0xBF, 0xA0, 0x03, 0xFF, 0x81, 0x30, 0xEF, 0xD0, 0xE3, 0x80, 0x90, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_medical_information() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_medical_information_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_medical_services 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_medical_services_data[] PROGMEM = {
  0x58, 0x00, 0x37, 0x28, 0x49, 0xA9, 0x9A, 0x97, 0x10, 0xA0, 0x32, 0x03, 0x0A, 0x58, 0x94, 0x89,
  0x9D, 0xA9, 0x9A, 0xD9, 0x98, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xD0, 0x0A, 0xD0, 0x04, 0xC8,
  0x2D, 0x77, 0xDC, 0x00, 0x4B, 0x84, 0xD3, 0x22, 0x3D, 0xB0, 0x04, 0xD0, 0x08, 0xD0, 0x04, 0xD0,
  0x0C, 0xD0, 0x04, 0xFD, 0x04, 0x03, 0xFD, 0x03, 0x18, 0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_medical_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_medical_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_menu_book 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_maps_menu_book_data[] PROGMEM = {
  0x38, 0x22, 0x33, 0x24, 0x82, 0x23, 0x32, 0x40, 0x80, 0xEC, 0x82, 0xD7, 0x7D, 0xC8, 0x2E, 0x80,
  0x1F, 0x98, 0x90, 0xE8, 0x31, 0x13, 0x9F, 0x11, 0xF9, 0x18, 0x71, 0x68, 0x95, 0x3F, 0x11, 0xF9,
  0x18, 0x73, 0xDB, 0xB8, 0x3F, 0x11, 0xF9, 0x28, 0x63, 0x55, 0x33, 0xF1, 0x1F, 0x91, 0x04, 0xA8,
  0x4E, 0xA3, 0xF1, 0x1F, 0x92, 0x86, 0x12, 0x20, 0x3F, 0x11, 0xF9, 0x10, 0x4B, 0x83, 0xB3, 0xF1,
  0x1F, 0x92, 0x86, 0x43, 0x21, 0x3F, 0x11, 0xF9, 0x28, 0x63, 0x55, 0x34, 0xF1, 0x1F, 0x90, 0x70,
  0xEE, 0x83, 0x10, 0x76, 0x12, 0x84, 0x38, 0xEE, 0x83, 0x28, 0x11, 0x67, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_menu_book() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_menu_book_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_merge 18x18, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_round_18_maps_merge_data[] PROGMEM = {
  0x40, 0x0A, 0x70, 0xBA, 0x0B, 0x58, 0x44, 0xEC, 0xCE, 0x46, 0x00, 0xA7, 0x10, 0x0A, 0x71, 0x00,
  0xA7, 0x10, 0x0B, 0x71, 0x00, 0xE7, 0x0A, 0xA0, 0xA5, 0x84, 0x9F, 0x44, 0xF9, 0x38, 0x19, 0xF4,
  0x28, 0x54, 0xF9, 0x01, 0xE4, 0x48, 0x14, 0xE1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_minor_crash 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_maps_minor_crash_data[] PROGMEM = {
  0x60, 0x09, 0x71, 0x03, 0x05, 0x20, 0x0A, 0x20, 0x50, 0x34, 0x89, 0x05, 0xF7, 0x09, 0x90, 0x7F,
  0x55, 0x86, 0x6A, 0x01, 0x10, 0xA6, 0x77, 0x50, 0x40, 0xA8, 0x02, 0xB0, 0xA0, 0x44, 0x0E, 0x0B,
  0x80, 0x29, 0x0B, 0x0E, 0x38, 0x15, 0xF1, 0x68, 0x11, 0xF5, 0x20, 0xC0, 0xB8, 0x04, 0x18, 0x2B,
  0xC0, 0x2F, 0xD0, 0x20, 0x4F, 0xD0, 0x04, 0xA0, 0x20, 0x6C, 0x06, 0x02, 0xA0, 0x04, 0xA0, 0x70,
  0xAC, 0x0A, 0x07, 0xA0, 0x04, 0xFD, 0x82, 0x44, 0xFD, 0x80, 0x4B, 0x84, 0xDF, 0x42, 0xF5, 0x71,
  0x81, 0x5F, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_minor_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_minor_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_miscellaneous_services 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_maps_miscellaneous_services_data[] PROGMEM = {
  0x40, 0x03, 0x73, 0x02, 0xA0, 0x47, 0x81, 0x8A, 0xBA, 0x81, 0xC9, 0xA4, 0x02, 0xB0, 0x0E, 0xB0,
  0x44, 0x86, 0x9F, 0xE1, 0x0C, 0xFB, 0x58, 0x15, 0xFC, 0x28, 0x1A, 0xF7, 0x40, 0x2B, 0x09, 0x08,
  0xB0, 0x44, 0x0C, 0xE8, 0x1D, 0x01, 0x38, 0x11, 0x14, 0xA8, 0x56, 0x14, 0x4F, 0x52, 0x48, 0x7B,
  0xB2, 0x0D, 0xFC, 0xFE, 0x71, 0x83, 0x8C, 0x09, 0x97, 0x18, 0x3D, 0xF9, 0xEE, 0x71, 0x83, 0x47,
  0xF7, 0x47, 0x30, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_miscellaneous_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_miscellaneous_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_mode_of_travel 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_maps_mode_of_travel_data[] PROGMEM = {
  0x50, 0x02, 0x72, 0x81, 0x19, 0xEA, 0x81, 0xE9, 0x15, 0x89, 0x02, 0xDE, 0x73, 0x37, 0xEE, 0x24,
  0x81, 0xDC, 0x14, 0x81, 0x1C, 0xD3, 0x81, 0x6F, 0x26, 0x81, 0x2F, 0x62, 0x00, 0xB7, 0x10, 0x0B,
  0x20, 0xC0, 0x86, 0x86, 0x3B, 0xDE, 0xB6, 0xAA, 0x70, 0xAA, 0x83, 0xD2, 0x6E, 0x17, 0x81, 0xAD,
  0x22, 0x0E, 0x09, 0x48, 0x12, 0x96, 0x58, 0x15, 0xF4, 0x30, 0xEA, 0x04, 0x58, 0x1A, 0xE2, 0x2B,
  0x06, 0x68, 0x5B, 0xD2, 0x2E, 0xEA, 0x78, 0x41, 0xCE, 0xEC, 0x17, 0x30, 0x0B, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_mode_of_travel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_mode_of_travel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_money 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_maps_money_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xA8, 0x90, 0x7D, 0x93,
  0x4B, 0xB4, 0x38, 0xA0, 0x03, 0xA1, 0x86, 0x91, 0x31, 0x55, 0x13, 0x1A, 0x00, 0x3A, 0x18, 0x69,
  0x18, 0x55, 0x54, 0x91, 0xA0, 0x03, 0xA1, 0x86, 0x91, 0x85, 0x55, 0x49, 0x1A, 0x00, 0x3A, 0x18,
  0x69, 0x13, 0x15, 0x51, 0x31, 0xA0, 0x03, 0xA8, 0x90, 0x7D, 0x93, 0x4B, 0xB4, 0x38, 0xA0, 0x03,
  0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_money() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_money_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_moped 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_maps_moped_data[] PROGMEM = {
  0x20, 0x30, 0xF9, 0x28, 0x11, 0x97, 0x50, 0x10, 0xF3, 0x38, 0x13, 0x96, 0x30, 0x10, 0x90, 0xFB,
  0x40, 0x60, 0x73, 0x0C, 0xC0, 0x12, 0x81, 0x1D, 0x42, 0x03, 0xD8, 0x31, 0x01, 0xD4, 0x30, 0x4D,
  0x8A, 0x45, 0x4D, 0x5B, 0xEB, 0x03, 0xBD, 0xDB, 0xFB, 0xB4, 0x3B, 0x0B, 0x32, 0x82, 0x3D, 0x8D,
  0x38, 0x31, 0xD7, 0xD1, 0x38, 0x13, 0x71, 0x48, 0x12, 0x72, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_moped() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_maps_moped_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_mosque 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_maps_mosque_data[] PROGMEM = {
  0x78, 0x23, 0xCC, 0x37, 0x10, 0x14, 0x09, 0xC0, 0x94, 0x83, 0x10, 0x1E, 0x32, 0x0C, 0xE0, 0xC2,
  0x86, 0x3E, 0x19, 0xFB, 0x05, 0xF9, 0x89, 0x05, 0x0B, 0xF9, 0x8F, 0xB0, 0x7F, 0x98, 0x90, 0x70,
  0xBF, 0x81, 0xF3, 0x02, 0x80, 0x43, 0x89, 0x02, 0x03, 0xF1, 0x1F, 0x30, 0x98, 0x04, 0xB8, 0x79,
  0x03, 0xF1, 0x1F, 0x35, 0xFB, 0x86, 0x53, 0xF1, 0x1F, 0x57, 0xFB, 0x83, 0x75, 0xF1, 0x1F, 0x00,
  0xEF, 0x00, 0x1E, 0x09, 0x20, 0x9E, 0x00, 0x1E, 0x03, 0x20, 0x3E, 0x00, 0x1E, 0x03, 0x20, 0x3E,
  0x00, 0x1E, 0x03, 0x20, 0x3E, 0x01, 0x18, 0x02, 0x34, 0x80, 0x23, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_mosque() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_mosque_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_moving 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_maps_moving_data[] PROGMEM = {
  0x73, 0x04, 0x0F, 0x77, 0x40, 0x4B, 0x03, 0x74, 0x0C, 0xA0, 0x37, 0x38, 0x3B, 0xE7, 0xF3, 0x30,
  0x6A, 0x08, 0x28, 0x3B, 0xE3, 0x03, 0x38, 0x77, 0xF8, 0x6F, 0xBC, 0xE3, 0x58, 0x17, 0xF6, 0x28,
  0x23, 0xAA, 0x25, 0x81, 0x7F, 0x67, 0x50, 0xA0, 0x67, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_moving() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_maps_moving_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_multiple_stop 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_maps_multiple_stop_data[] PROGMEM = {
  0x73, 0x01, 0x03, 0x75, 0x81, 0x3E, 0x42, 0x8A, 0x61, 0xA1, 0x1A, 0x11, 0xAB, 0xCF, 0xE3, 0x01,
  0xA1, 0x1A, 0x11, 0xAB, 0xCA, 0x04, 0x73, 0x81, 0x3F, 0x47, 0x40, 0x10, 0x34, 0x03, 0x01, 0x74,
  0x81, 0x4E, 0x37, 0x38, 0x95, 0x3E, 0xFC, 0xBA, 0x11, 0xA1, 0x1A, 0x10, 0x4A, 0x89, 0x0C, 0xBA,
  0x11, 0xA1, 0x1A, 0x12, 0x81, 0x4F, 0x37, 0x50, 0x30, 0x17, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_multiple_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_multiple_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_museum 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_museum_data[] PROGMEM = {
  0x58, 0x22, 0xCC, 0x27, 0x20, 0x6C, 0x06, 0x60, 0x10, 0xBE, 0x0B, 0x01, 0x30, 0x40, 0xEF, 0x98,
  0x2E, 0x50, 0x3F, 0xD8, 0x53, 0x01, 0x8F, 0x79, 0xA8, 0x39, 0x7F, 0x81, 0x38, 0x90, 0x7F, 0x40,
  0xDD, 0x04, 0xF7, 0x48, 0x90, 0x7F, 0x43, 0x33, 0x34, 0xF7, 0x48, 0x90, 0x7F, 0x4B, 0x22, 0xB4,
  0xF7, 0x48, 0x90, 0x7F, 0x4C, 0xDD, 0xC4, 0xF7, 0x48, 0x27, 0xFA, 0xEA, 0x82, 0xEA, 0xF7, 0x28,
  0x11, 0x7B, 0xF9, 0x81, 0xB7, 0x11, 0x80, 0x90, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_museum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_museum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_my_location 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_maps_my_location_data[] PROGMEM = {
  0x70, 0x09, 0x77, 0x00, 0xB7, 0x40, 0x20, 0xBC, 0x0B, 0x02, 0x78, 0x90, 0x5E, 0xB4, 0x11, 0x4B,
  0xE5, 0x58, 0x12, 0xE8, 0x68, 0x18, 0xE2, 0x40, 0x0B, 0x28, 0x23, 0x99, 0x32, 0x00, 0xB4, 0x98,
  0x14, 0x03, 0xC8, 0x13, 0x04, 0x92, 0x84, 0x8B, 0xF1, 0x09, 0xC8, 0x92, 0x90, 0x1F, 0xB8, 0x8B,
  0xF1, 0x09, 0xC8, 0x49, 0x01, 0xFB, 0x82, 0x98, 0x14, 0x03, 0xC8, 0x13, 0x04, 0x94, 0x00, 0xB2,
  0x82, 0x39, 0x93, 0x20, 0x0B, 0x48, 0x12, 0xE8, 0x68, 0x18, 0xE2, 0x58, 0x90, 0x5E, 0xB4, 0x11,
  0x4B, 0xE5, 0x70, 0x20, 0xBC, 0x0B, 0x02, 0x74, 0x00, 0xB7, 0x70, 0x09, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_my_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_my_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_navigation 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_maps_navigation_data[] PROGMEM = {
  0x50, 0x02, 0x73, 0x00, 0xA7, 0x20, 0x1A, 0x01, 0x71, 0x08, 0xA0, 0x87, 0x10, 0xEA, 0x0E, 0x70,
  0x5C, 0x05, 0x60, 0xBC, 0x0B, 0x50, 0x2E, 0x02, 0x40, 0x9E, 0x09, 0x40, 0xEE, 0x0E, 0x30, 0x6F,
  0x90, 0x62, 0x0D, 0xA8, 0x2B, 0x44, 0xBA, 0x84, 0xC0, 0x3F, 0xA2, 0x48, 0x42, 0x9F, 0x30, 0x17,
  0x10, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_navigation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_navigation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_near_me_disabled 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_maps_near_me_disabled_data[] PROGMEM = {
  0x03, 0x07, 0x76, 0x81, 0x5F, 0x97, 0x20, 0x23, 0x81, 0x7F, 0x95, 0x83, 0x28, 0xDF, 0x23, 0x81,
  0x7F, 0x92, 0x06, 0x0C, 0xB0, 0xD5, 0x83, 0x7F, 0x90, 0x4C, 0x08, 0x38, 0x13, 0x8E, 0xA8, 0x19,
  0x04, 0xB0, 0x22, 0x08, 0xE8, 0x39, 0x04, 0xFC, 0x30, 0x40, 0xCE, 0x82, 0x90, 0x46, 0x58, 0x13,
  0x9E, 0xC0, 0x97, 0x20, 0x10, 0x8C, 0x09, 0x72, 0x01, 0x0E, 0xC0, 0x97, 0x20, 0x9A, 0x82, 0xE8,
  0xF9, 0x71, 0x03, 0xA8, 0x38, 0x07, 0xF9, 0x71, 0x81, 0xCF, 0x32, 0x81, 0x7F, 0x77, 0x04, 0x09,
  0x40, 0x50, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_near_me_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_near_me_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_near_me 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_18_maps_near_me_data[] PROGMEM = {
  0x73, 0x81, 0x39, 0xB7, 0x10, 0x60, 0xCA, 0x09, 0x58, 0x13, 0x9E, 0xC0, 0x22, 0x81, 0x16, 0xCE,
  0x82, 0xC0, 0x1A, 0xFA, 0x83, 0x60, 0x19, 0xEF, 0x0E, 0x50, 0x50, 0xBD, 0x09, 0x70, 0x2C, 0x03,
  0x71, 0x0B, 0xA0, 0xC7, 0x20, 0x5A, 0x06, 0x73, 0x81, 0xEF, 0x17, 0x30, 0x90, 0xA7, 0x40, 0x01,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_near_me() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_near_me_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_nightlife 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_nightlife_data[] PROGMEM = {
  0x18, 0x02, 0x70, 0x42, 0x89, 0x21, 0x76, 0x04, 0xFE, 0xDD, 0xDF, 0xD2, 0x0B, 0xA8, 0x22, 0x0B,
  0xD2, 0x81, 0x4F, 0x52, 0x81, 0xD9, 0x32, 0x84, 0x1E, 0xCB, 0xEA, 0x30, 0xD0, 0x74, 0x05, 0xA0,
  0xD4, 0x0D, 0x07, 0x58, 0x19, 0xF3, 0x38, 0x11, 0xD7, 0x50, 0x50, 0xE2, 0x04, 0x0E, 0xA0, 0x75,
  0x05, 0x0E, 0x20, 0xDB, 0x07, 0x50, 0x50, 0xE2, 0x0E, 0xB0, 0x64, 0x05, 0xA8, 0x1D, 0x07, 0xA0,
  0xD0, 0x14, 0x82, 0x15, 0x54, 0x28, 0x13, 0x51, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_nightlife() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_nightlife_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_no_crash 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_maps_no_crash_data[] PROGMEM = {
  0x78, 0x11, 0xA2, 0x72, 0x83, 0x62, 0xCD, 0x17, 0x28, 0x2E, 0xFD, 0x17, 0x38, 0x12, 0xA1, 0x77,
  0x71, 0x04, 0x0A, 0x80, 0x2B, 0x0A, 0x04, 0x40, 0xE0, 0xB8, 0x02, 0x90, 0xB0, 0xE3, 0x81, 0x5F,
  0x16, 0x81, 0x1F, 0x52, 0x0C, 0x0B, 0x80, 0x41, 0x82, 0xBC, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00,
  0x4A, 0x02, 0x06, 0xC0, 0x60, 0x2A, 0x00, 0x4A, 0x07, 0x0A, 0xC0, 0xA0, 0x7A, 0x00, 0x4F, 0xD8,
  0x24, 0x4F, 0xD8, 0x04, 0xB8, 0x4D, 0xF4, 0x2F, 0x57, 0x18, 0x15, 0xF2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_no_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_no_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_no_meals 18x18, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_round_18_maps_no_meals_data[] PROGMEM = {
  0x58, 0x33, 0x30, 0x33, 0x48, 0x33, 0x21, 0xF7, 0x28, 0x3B, 0xB0, 0xBB, 0x28, 0x94, 0x1B, 0xFB,
  0x09, 0xF7, 0x05, 0xB0, 0xBB, 0x20, 0xAA, 0x0B, 0x28, 0x6C, 0xF7, 0x03, 0x0B, 0xB2, 0xB0, 0xB2,
  0x0B, 0xA0, 0x72, 0x00, 0xB2, 0xB0, 0xB2, 0x86, 0xBC, 0xCF, 0x70, 0x5B, 0x2B, 0x0B, 0x20, 0x9C,
  0x81, 0x70, 0x22, 0xB0, 0xB2, 0x02, 0x0E, 0xC0, 0x73, 0xB0, 0xB3, 0x85, 0x29, 0xEE, 0xBF, 0x72,
  0x0D, 0xA0, 0xB5, 0x89, 0x1B, 0xB0, 0x9F, 0x70, 0x27, 0xDB, 0x50, 0x0B, 0x28, 0x19, 0xF7, 0x20,
  0x0B, 0x50, 0x0B, 0x38, 0x49, 0xF7, 0x05, 0xB5, 0x00, 0xB4, 0x83, 0x9F, 0x70, 0x35, 0x00, 0xB5,
  0x81, 0x9F, 0x76, 0x00, 0xB6, 0x81, 0x9F, 0x75, 0x00, 0x37, 0x09, 0x97, 0x71, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_no_meals() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 15, 17), Box(0, 0, 17, 17),
      ic_round_18_maps_no_meals_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_not_listed_location 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_not_listed_location_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x20, 0xDA, 0x82,
  0xE9, 0x9E, 0xA8, 0x1D, 0x06, 0xB8, 0x23, 0x43, 0x5B, 0x06, 0x0B, 0xB8, 0x2D, 0xFC, 0x1B, 0x0B,
  0x0C, 0xC8, 0x1E, 0x37, 0xB0, 0xC0, 0x9C, 0x07, 0x04, 0xC0, 0xB0, 0x5C, 0x0C, 0x0D, 0xC8, 0x16,
  0x0D, 0xB0, 0x08, 0xB0, 0xD2, 0x05, 0xB0, 0x09, 0xB0, 0x53, 0x09, 0xE0, 0x95, 0x0B, 0xC0, 0xB6,
  0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x10, 0x0A, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_not_listed_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_not_listed_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_no_transfer 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_maps_no_transfer_data[] PROGMEM = {
  0x48, 0x62, 0x56, 0x77, 0x65, 0x23, 0x82, 0x35, 0x04, 0xF9, 0x86, 0xD2, 0x07, 0xF7, 0x05, 0xF9,
  0x0C, 0x28, 0x39, 0xF7, 0x04, 0x80, 0x27, 0x0B, 0x93, 0xA0, 0x77, 0x07, 0x93, 0x98, 0x1E, 0xF7,
  0x60, 0x79, 0x39, 0x82, 0x79, 0xF7, 0x50, 0x79, 0x39, 0x0D, 0x0B, 0xA8, 0x47, 0x03, 0xBB, 0xD9,
  0x3E, 0x81, 0x70, 0x5B, 0x39, 0x81, 0xE8, 0xDB, 0x81, 0x70, 0x5A, 0x39, 0x81, 0x80, 0x4C, 0x81,
  0x70, 0x59, 0x38, 0x2D, 0xD4, 0xAD, 0x81, 0x70, 0x53, 0x06, 0xFA, 0x07, 0x40, 0x3A, 0x80, 0x23,
  0xA0, 0x74, 0x09, 0x07, 0x68, 0x27, 0xCF, 0x57, 0x60, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_no_transfer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_no_transfer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_park 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_maps_park_data[] PROGMEM = {
  0x50, 0x04, 0x72, 0x82, 0x1E, 0xE1, 0x71, 0x0A, 0xA0, 0xA7, 0x04, 0xC0, 0x46, 0x0D, 0xC0, 0xD5,
  0x08, 0xE0, 0x84, 0x0D, 0xE0, 0xD4, 0x0B, 0xE0, 0xB3, 0x05, 0xF9, 0x82, 0x60, 0x1E, 0xF9, 0x81,
  0xE1, 0x9F, 0xB8, 0x49, 0x47, 0x77, 0xAA, 0x83, 0xA7, 0x77, 0x54, 0x05, 0xA0, 0x57, 0x18, 0x22,
  0xEE, 0x27, 0x20, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_park() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_park_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_pedal_bike 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_maps_pedal_bike_data[] PROGMEM = {
  0x71, 0x81, 0x55, 0x37, 0x68, 0x16, 0x7D, 0x77, 0x10, 0x80, 0x67, 0x18, 0x25, 0xBB, 0xA2, 0x03,
  0x0B, 0x71, 0x82, 0x16, 0xB2, 0x30, 0xC0, 0x14, 0x82, 0x6C, 0xC7, 0x18, 0x01, 0xD8, 0x93, 0xEE,
  0xC6, 0x07, 0xA1, 0x19, 0x98, 0x52, 0x85, 0x99, 0xC1, 0xA7, 0xD2, 0x8A, 0x13, 0x3E, 0x7C, 0x34,
  0xD0, 0xB3, 0x0D, 0xD0, 0x3B, 0xBE, 0x80, 0x1B, 0x18, 0x44, 0x40, 0xDC, 0x32, 0x02, 0x0D, 0x40,
  0xD0, 0x22, 0x86, 0x3C, 0x2D, 0x99, 0xD3, 0x48, 0x43, 0xD9, 0x9D, 0x22, 0x81, 0x44, 0x16, 0x81,
  0x14, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_pedal_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_pedal_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_person_pin_circle 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_maps_person_pin_circle_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x20, 0xDB, 0x00,
  0xAB, 0x81, 0xD0, 0x6B, 0x0B, 0x20, 0xBB, 0x06, 0x0B, 0xB0, 0xD2, 0x0D, 0xB0, 0xB0, 0xCC, 0x00,
  0xEC, 0x0C, 0x09, 0xA8, 0x4C, 0x52, 0x25, 0xCA, 0x0B, 0x05, 0xA0, 0x44, 0x04, 0xA8, 0x16, 0x0D,
  0xA8, 0x28, 0x44, 0x8A, 0x0D, 0x20, 0x5F, 0x90, 0x53, 0x09, 0xE0, 0x95, 0x0B, 0xC0, 0xB6, 0x01,
  0x0C, 0xA0, 0xC0, 0x17, 0x10, 0x0A, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_person_pin_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_person_pin_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_person_pin 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_maps_person_pin_data[] PROGMEM = {
  0x10, 0x18, 0x06, 0x38, 0x21, 0x01, 0xEF, 0xB8, 0x1E, 0x14, 0xFD, 0x00, 0x4C, 0x82, 0x82, 0x28,
  0xC0, 0x04, 0xB0, 0xA4, 0x0A, 0xB0, 0x04, 0xB0, 0x54, 0x05, 0xB0, 0x04, 0xB0, 0x74, 0x07, 0xB0,
  0x04, 0xB0, 0xE0, 0x12, 0x01, 0x0E, 0xB0, 0x04, 0xC8, 0x2E, 0xAA, 0xEC, 0x00, 0x4B, 0x84, 0xB7,
  0x55, 0x7B, 0xB8, 0x34, 0x4F, 0xB2, 0x68, 0x52, 0xBF, 0x44, 0xF2, 0x71, 0x82, 0x2F, 0x42, 0xFD,
  0x84, 0x20, 0x35, 0x59, 0xC8, 0x29, 0x55, 0x36, 0x09, 0xA0, 0x97, 0x40, 0x07, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_person_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_person_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_pest_control 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_maps_pest_control_data[] PROGMEM = {
  0x30, 0x14, 0x01, 0x68, 0x48, 0x96, 0x69, 0x87, 0x0E, 0xA0, 0xE7, 0x03, 0xC0, 0x24, 0x81, 0x53,
  0x7C, 0x81, 0x73, 0x52, 0x03, 0x0C, 0xA0, 0x0D, 0xA0, 0xC0, 0x32, 0x01, 0x08, 0xA0, 0x08, 0xA8,
  0x48, 0x10, 0x3B, 0xDA, 0x00, 0x8A, 0x81, 0xDB, 0x32, 0x07, 0xA0, 0x08, 0xA0, 0x73, 0x81, 0x7D,
  0xEC, 0x81, 0xED, 0x62, 0x82, 0x20, 0x4E, 0xA8, 0x2E, 0x40, 0x26, 0x00, 0x55,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_pest_control() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_pest_control_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_pest_control_rodent 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_maps_pest_control_rodent_data[] PROGMEM = {
  0x48, 0x13, 0x51, 0x74, 0x81, 0x48, 0xD7, 0x28, 0x34, 0x89, 0x9C, 0x71, 0x83, 0x8B, 0x53, 0x37,
  0x10, 0x10, 0xC2, 0x82, 0x2A, 0xB5, 0x68, 0x91, 0x3A, 0x01, 0xEF, 0xB2, 0xBC, 0x73, 0x82, 0x1D,
  0x16, 0xA0, 0x30, 0xBB, 0x04, 0x38, 0x14, 0xDD, 0xA0, 0x20, 0xEB, 0x07, 0x50, 0x9A, 0x05, 0x0A,
  0xB0, 0xE0, 0x34, 0x04, 0xA0, 0x0D, 0xA8, 0x26, 0xAE, 0x14, 0x0A, 0xD8, 0x2A, 0xDF, 0x25, 0x03,
  0x80, 0x25, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_pest_control_rodent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_pest_control_rodent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_pin_drop 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_maps_pin_drop_data[] PROGMEM = {
  0x40, 0x01, 0x60, 0x70, 0xEA, 0x0E, 0x07, 0x30, 0xAE, 0x81, 0xA0, 0x6F, 0x90, 0x60, 0xBB, 0x00,
  0x8B, 0x0B, 0x0E, 0xA0, 0xB2, 0x0B, 0xA0, 0xE0, 0xDA, 0x82, 0xD1, 0x1D, 0xA0, 0xD0, 0x9F, 0x90,
  0x90, 0x2F, 0x98, 0x12, 0x08, 0xE0, 0x83, 0x0B, 0xC0, 0xB5, 0x0A, 0xA0, 0xA7, 0x00, 0x75, 0x80,
  0x41, 0x10, 0xDF, 0x90, 0xD0, 0x18, 0x04, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_pin_drop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_pin_drop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_place 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_place_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x20, 0xDF, 0x98,
  0x1D, 0x06, 0xFB, 0x06, 0x0B, 0xC0, 0x07, 0xC0, 0xB0, 0xCB, 0x0A, 0x20, 0xAB, 0x0C, 0x09, 0xB8,
  0x2E, 0x22, 0xEB, 0x0B, 0x05, 0xFB, 0x81, 0x60, 0xDF, 0x90, 0xD2, 0x05, 0xF9, 0x05, 0x30, 0x9E,
  0x09, 0x50, 0xBC, 0x0B, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x71, 0x00, 0xA5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_place() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_place_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_plumbing 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_maps_plumbing_data[] PROGMEM = {
  0x78, 0x22, 0xDD, 0x17, 0x02, 0x0E, 0xA0, 0xD0, 0x13, 0x87, 0x64, 0x0E, 0xF7, 0x8F, 0xC3, 0x83,
  0xDF, 0x55, 0x72, 0x08, 0x93, 0x87, 0x3E, 0xF5, 0x4B, 0x10, 0x32, 0x82, 0x27, 0x3E, 0xB0, 0xC0,
  0x12, 0x83, 0x2E, 0xF3, 0x7C, 0x05, 0x28, 0x2C, 0xF7, 0x4B, 0x08, 0x03, 0x38, 0x15, 0x54, 0xB0,
  0x86, 0x04, 0xB0, 0x86, 0x04, 0xB0, 0x86, 0x04, 0xB0, 0x87, 0x0E, 0xA0, 0x87, 0x18, 0x1B, 0xF8,
  0x73, 0x01, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_plumbing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_plumbing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_railway_alert 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_maps_railway_alert_data[] PROGMEM = {
  0x74, 0x02, 0x71, 0x0F, 0x38, 0x21, 0x06, 0xEA, 0x09, 0x30, 0x30, 0xCC, 0x01, 0x05, 0xA0, 0xBA,
  0x09, 0x20, 0xEC, 0x81, 0xC0, 0xCA, 0x02, 0x0E, 0xA1, 0x02, 0xD8, 0x1A, 0x0E, 0xA0, 0xBB, 0x89,
  0x02, 0x3F, 0x53, 0x33, 0x20, 0xBA, 0x08, 0xA8, 0x3E, 0x03, 0xF2, 0x50, 0x3A, 0x0E, 0xA8, 0x36,
  0x03, 0xF2, 0x68, 0x33, 0xBE, 0xC5, 0x20, 0x3F, 0x0B, 0x02, 0x60, 0x3D, 0x0E, 0xB0, 0xC0, 0x64,
  0x03, 0xC0, 0x61, 0xC0, 0x94, 0x02, 0xC0, 0xC0, 0x8C, 0x08, 0x50, 0xCF, 0xA0, 0x35, 0x01, 0x09,
  0xE0, 0xC0, 0x47, 0x07, 0xE0, 0xD7, 0x10, 0x18, 0x03, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_railway_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_railway_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_ramen_dining 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_ramen_dining_data[] PROGMEM = {
  0x76, 0x01, 0x58, 0xA4, 0x13, 0x57, 0x8A, 0xCD, 0xDB, 0x10, 0x2D, 0xEC, 0xE9, 0x65, 0x31, 0x58,
  0x46, 0x79, 0x4C, 0x17, 0x28, 0x46, 0xCD, 0xBE, 0xA8, 0x03, 0x98, 0x61, 0x06, 0x9A, 0x7D, 0x58,
  0x03, 0x32, 0x84, 0x67, 0x94, 0xC1, 0x71, 0x0C, 0x80, 0x0E, 0x98, 0x03, 0xD0, 0xC1, 0xFF, 0x10,
  0xBF, 0xD8, 0x1B, 0x04, 0xFD, 0x04, 0x20, 0x9F, 0xB0, 0x94, 0x0A, 0xF9, 0x0A, 0x60, 0x40, 0xEC,
  0x0E, 0x04, 0x71, 0x09, 0xC0, 0x97, 0x38, 0x00, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_ramen_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_ramen_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_ramp_left 18x18, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_round_18_maps_ramp_left_data[] PROGMEM = {
  0x20, 0x0A, 0x50, 0xBA, 0x0B, 0x38, 0x44, 0xEC, 0xCE, 0x44, 0x00, 0xA6, 0x0A, 0x0C, 0x60, 0xA0,
  0xE6, 0x81, 0xAF, 0x75, 0x82, 0xAF, 0xE3, 0x40, 0xFA, 0x0E, 0x04, 0x38, 0x4A, 0xA0, 0xAF, 0x22,
  0x00, 0xA2, 0x04, 0x30, 0x09, 0x60, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_ramp_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_ramp_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_ramp_right 18x18, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_round_18_maps_ramp_right_data[] PROGMEM = {
  0x40, 0x0A, 0x50, 0xBA, 0x0B, 0x38, 0x44, 0xEC, 0xCE, 0x44, 0x00, 0xA6, 0x0C, 0x0A, 0x69, 0x0A,
  0x58, 0x17, 0xFA, 0x40, 0x3A, 0x0A, 0x30, 0x40, 0xE0, 0xFA, 0x28, 0x42, 0xFA, 0x0A, 0xA3, 0x04,
  0x20, 0x0A, 0x60, 0xA0, 0x96, 0x00, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_ramp_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 11, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_ramp_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_rate_review 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_rate_review_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3E, 0x0D, 0x0A, 0xE0, 0x03, 0xD8,
  0x2D, 0x20, 0x9D, 0x00, 0x3C, 0x0D, 0x02, 0x20, 0x7D, 0x00, 0x3B, 0x0D, 0x02, 0x20, 0x6E, 0x00,
  0x3A, 0x0D, 0x02, 0x20, 0x6F, 0x00, 0x3A, 0x07, 0x28, 0x56, 0xF9, 0x77, 0x7D, 0xA0, 0x03, 0xA8,
  0x90, 0x93, 0x7F, 0xB3, 0x33, 0x3B, 0xA0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x10, 0x3A, 0x09, 0x80,
  0x67, 0x83, 0x40, 0x3F, 0x77, 0x60, 0x30, 0x77, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_rate_review() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_rate_review_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_remove_road 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_maps_remove_road_data[] PROGMEM = {
  0x10, 0x33, 0x00, 0x23, 0x03, 0x20, 0x50, 0xE3, 0x00, 0xA3, 0x83, 0xE5, 0x06, 0xE3, 0x00, 0x93,
  0x83, 0xE6, 0x06, 0xE3, 0x00, 0x13, 0x83, 0xE6, 0x06, 0xE3, 0x00, 0x13, 0x83, 0xE6, 0x06, 0xE3,
  0x00, 0xA3, 0x83, 0xE6, 0x06, 0xE3, 0x00, 0xA3, 0x83, 0x41, 0x06, 0xE3, 0x00, 0x16, 0x06, 0x0E,
  0x38, 0x90, 0x11, 0x01, 0x40, 0x14, 0x6E, 0x38, 0x90, 0x99, 0x04, 0xF8, 0xDB, 0x5E, 0x30, 0x0A,
  0x28, 0x48, 0xFD, 0x10, 0x33, 0x86, 0x22, 0x01, 0xDD, 0xF6, 0x71, 0x83, 0x4B, 0x16, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_remove_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_remove_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_restaurant_menu 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_maps_restaurant_menu_data[] PROGMEM = {
  0x73, 0x02, 0x03, 0x30, 0xA0, 0x66, 0x09, 0xA8, 0x1C, 0x03, 0xA0, 0x64, 0x09, 0xC0, 0x03, 0xB0,
  0x63, 0xD8, 0x12, 0x0C, 0xB0, 0x62, 0xC0, 0x92, 0x02, 0x0E, 0xA8, 0x19, 0x07, 0xB0, 0x94, 0x85,
  0x2E, 0x90, 0x7F, 0x77, 0x18, 0x11, 0x07, 0xA0, 0x77, 0x28, 0x47, 0xF7, 0x7F, 0x77, 0x81, 0x7F,
  0x72, 0x81, 0x7F, 0x75, 0x81, 0x7F, 0x74, 0x81, 0x7F, 0x73, 0x81, 0x6F, 0x76, 0x81, 0x7F, 0x62,
  0x0D, 0x07, 0x71, 0x07, 0x0D, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_restaurant_menu() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_restaurant_menu_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_restaurant 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_maps_restaurant_data[] PROGMEM = {
  0x18, 0x31, 0x01, 0x01, 0x68, 0x45, 0xD5, 0xE4, 0xE3, 0x86, 0x9F, 0x66, 0xE5, 0xF5, 0x92, 0x09,
  0xA8, 0x46, 0x6E, 0x5F, 0x59, 0x2B, 0x87, 0x66, 0xE5, 0xF5, 0xF0, 0x2B, 0x87, 0x65, 0xFD, 0xFC,
  0xE0, 0x3B, 0x81, 0x61, 0xEB, 0x81, 0xA0, 0x3B, 0x87, 0x60, 0x4D, 0xFA, 0x10, 0x2B, 0x06, 0x20,
  0x59, 0x48, 0x2A, 0xDF, 0x62, 0x05, 0x96, 0x0E, 0x06, 0x20, 0x59, 0x60, 0xE0, 0x62, 0x05, 0x96,
  0x0E, 0x06, 0x20, 0x59, 0x60, 0xE0, 0x62, 0x05, 0x96, 0x0E, 0x06, 0x20, 0x50, 0xE6, 0x0D, 0x05,
  0x30, 0x16, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_restaurant() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_restaurant_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_roundabout_left 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_maps_roundabout_left_data[] PROGMEM = {
  0x72, 0x03, 0x02, 0x74, 0x07, 0x0E, 0xA0, 0xE0, 0x54, 0x05, 0x38, 0x67, 0xF7, 0x22, 0x8F, 0x42,
  0x81, 0xAE, 0x12, 0x0E, 0x07, 0x48, 0x91, 0x9D, 0x09, 0xFD, 0xBB, 0xCF, 0x14, 0x89, 0x03, 0xF1,
  0x8F, 0xC9, 0x99, 0x55, 0x85, 0x3F, 0x10, 0xAE, 0x17, 0x10, 0x90, 0xD3, 0x04, 0x78, 0x22, 0x9F,
  0x47, 0x38, 0x27, 0xFD, 0x47, 0x40, 0xB0, 0xA7, 0x60, 0xB0, 0x97, 0x60, 0xB0, 0x97, 0x60, 0xB0,
  0x87, 0x60, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_roundabout_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_roundabout_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_roundabout_right 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_maps_roundabout_right_data[] PROGMEM = {
  0x40, 0x20, 0x37, 0x40, 0x50, 0xEA, 0x0E, 0x07, 0x71, 0x86, 0x4F, 0x82, 0x27, 0xF7, 0x30, 0x53,
  0x0D, 0x09, 0x40, 0x70, 0xE2, 0x85, 0x1E, 0xA0, 0x1F, 0x34, 0x89, 0x11, 0xFC, 0xBB, 0xDF, 0x91,
  0xF3, 0x58, 0x90, 0x59, 0x99, 0xCF, 0x80, 0xD9, 0x71, 0x81, 0x1E, 0xA2, 0x82, 0x4F, 0x92, 0x70,
  0x44, 0x82, 0x4D, 0xF7, 0x76, 0x0A, 0x0B, 0x76, 0x09, 0x0B, 0x76, 0x09, 0x0B, 0x76, 0x08, 0x0B,
  0x76, 0x00, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_roundabout_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_roundabout_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_route 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_maps_route_data[] PROGMEM = {
  0x20, 0x30, 0x24, 0x02, 0x03, 0x50, 0xAA, 0x09, 0x20, 0xBA, 0x0C, 0x30, 0x3C, 0x85, 0x17, 0xE3,
  0x3E, 0x72, 0x02, 0xC8, 0x11, 0xAA, 0x20, 0x90, 0xB3, 0x09, 0xA8, 0x27, 0x0A, 0xA2, 0x09, 0x0B,
  0x40, 0xB0, 0x92, 0x00, 0xA2, 0x09, 0x0B, 0x40, 0xB0, 0x92, 0x00, 0xA2, 0x09, 0x0B, 0x40, 0xB0,
  0x92, 0x00, 0xA2, 0x09, 0x0B, 0x40, 0xB0, 0x92, 0x00, 0xA2, 0x09, 0x0B, 0x40, 0xB0, 0x92, 0x82,
  0xAA, 0x07, 0xA0, 0x93, 0x0B, 0x09, 0x28, 0x1A, 0xA1, 0xC0, 0x22, 0x85, 0x7E, 0x33, 0xE7, 0x1C,
  0x03, 0x30, 0xCA, 0x0B, 0x20, 0x9A, 0x0A, 0x50, 0x30, 0x24, 0x02, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_route() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_route_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_run_circle 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_maps_run_circle_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x50, 0x5C, 0x0A, 0x0C, 0xA0, 0x53, 0x03,
  0xD0, 0x10, 0x4B, 0x03, 0x20, 0xBD, 0x0D, 0x0E, 0xB8, 0x1B, 0x01, 0xB8, 0x3E, 0x82, 0x0A, 0xC0,
  0x10, 0x3B, 0x84, 0xB3, 0x43, 0x27, 0xB0, 0x03, 0xB8, 0x4E, 0xA3, 0x3E, 0x9B, 0x03, 0x01, 0xB8,
  0x3A, 0xC1, 0x66, 0xC8, 0x90, 0x10, 0xBF, 0xE6, 0x35, 0xD3, 0xB0, 0xB2, 0x03, 0xD0, 0xD0, 0x3B,
  0x03, 0x30, 0x5D, 0x0A, 0xA0, 0x55, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x18, 0x21, 0x33, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_run_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_run_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_safety_check 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_maps_safety_check_data[] PROGMEM = {
  0x38, 0x43, 0x9E, 0xE9, 0x34, 0x07, 0x0D, 0xE8, 0x2D, 0x70, 0xAF, 0xB0, 0xA0, 0xDB, 0x82, 0xC7,
  0x7C, 0xB0, 0x0D, 0xA0, 0x74, 0x07, 0xA8, 0x2D, 0xDF, 0xC2, 0x00, 0x42, 0x84, 0xCF, 0xDC, 0xF7,
  0x20, 0x60, 0x72, 0x84, 0x7F, 0xCB, 0xF7, 0x28, 0x90, 0x2D, 0x20, 0x7F, 0xB8, 0xFC, 0x38, 0x52,
  0x20, 0xCF, 0x82, 0xA0, 0x74, 0x07, 0xA8, 0x12, 0x0A, 0xA8, 0x2C, 0x77, 0xCA, 0x0A, 0x20, 0x10,
  0xEE, 0x0E, 0x01, 0x30, 0x20, 0xDC, 0x0D, 0x02, 0x50, 0x10, 0x9A, 0x09, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_safety_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_safety_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_sailing 18x18, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_18_maps_sailing_data[] PROGMEM = {
  0x71, 0x81, 0x39, 0x17, 0x68, 0x22, 0xFC, 0x17, 0x30, 0x90, 0x81, 0xA0, 0xB7, 0x28, 0x34, 0xF8,
  0x0E, 0xA0, 0x77, 0x84, 0x1D, 0xF8, 0x0D, 0xA0, 0xE0, 0x16, 0x0A, 0xA8, 0x18, 0x0D, 0xB0, 0x85,
  0x05, 0xB8, 0x18, 0x0E, 0xB0, 0xD4, 0x01, 0x0E, 0xB0, 0x80, 0x1D, 0x01, 0x30, 0xAC, 0x08, 0x04,
  0xD0, 0x33, 0x85, 0x35, 0x55, 0x52, 0x18, 0x01, 0x53, 0x80, 0x92, 0xB2, 0x0A, 0xFD, 0x0B, 0x28,
  0x21, 0xB6, 0xDA, 0x00, 0x9A, 0x82, 0xD6, 0xB1, 0x60, 0x50, 0x32, 0x03, 0x05, 0x68, 0xA2, 0x38,
  0xE8, 0x46, 0xCC, 0x64, 0x8E, 0x83, 0x01, 0xFE, 0xAE, 0xA0, 0x0B, 0xA8, 0x3E, 0xAE, 0xF1, 0x50,
  0x14, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_sailing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_maps_sailing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_satellite 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_maps_satellite_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x87, 0x44, 0xFE, 0x05, 0xF1, 0xBD,
  0x00, 0x4A, 0x83, 0x5E, 0x90, 0xDD, 0x00, 0x4B, 0x81, 0x90, 0x6E, 0x00, 0x4A, 0x81, 0x10, 0x6F,
  0x00, 0x4A, 0x0B, 0x0D, 0xA0, 0xD0, 0x7C, 0x00, 0x4B, 0x84, 0x99, 0xF3, 0x08, 0xB0, 0x04, 0xA0,
  0xB2, 0x05, 0x30, 0xBA, 0x00, 0x4A, 0x0B, 0x80, 0x25, 0x0B, 0xA0, 0x04, 0xFD, 0x04, 0x02, 0xFD,
  0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_satellite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_satellite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_screen_rotation_alt 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_maps_screen_rotation_alt_data[] PROGMEM = {
  0x60, 0x17, 0x78, 0x28, 0xFD, 0x17, 0x48, 0x48, 0xF6, 0xDD, 0x16, 0x89, 0x11, 0xC1, 0x8F, 0x50,
  0x1D, 0xD1, 0x58, 0x33, 0xFA, 0xF5, 0x38, 0x21, 0xDD, 0x14, 0x03, 0xA0, 0x90, 0x14, 0x82, 0x1D,
  0xD1, 0x30, 0x10, 0xEA, 0x0B, 0x58, 0x11, 0xD7, 0x50, 0x01, 0x77, 0x73, 0x00, 0x15, 0x81, 0x7D,
  0x15, 0x0B, 0xA0, 0xE0, 0x13, 0x82, 0x1D, 0xD1, 0x40, 0x10, 0x9A, 0x03, 0x48, 0x21, 0xDD, 0x13,
  0x83, 0x5F, 0xAF, 0x35, 0x89, 0x11, 0xDD, 0x10, 0x5F, 0x81, 0xC1, 0x68, 0x41, 0xDD, 0x6F, 0x87,
  0x48, 0x21, 0xDF, 0x87, 0x70, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_screen_rotation_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_screen_rotation_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_set_meal 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_maps_set_meal_data[] PROGMEM = {
  0x10, 0x98, 0x09, 0x0B, 0x81, 0x90, 0x6F, 0xF0, 0x60, 0x7A, 0x85, 0xD7, 0x42, 0x25, 0xBA, 0x85,
  0xDA, 0xF7, 0x7F, 0x87, 0x04, 0x0C, 0x29, 0x81, 0x77, 0xD7, 0x20, 0x22, 0x98, 0x37, 0x7F, 0xB2,
  0x68, 0x57, 0xE3, 0x0F, 0x77, 0xB8, 0x4B, 0x75, 0x79, 0xEB, 0x82, 0xDF, 0x75, 0xFF, 0x81, 0x50,
  0x58, 0x09, 0x07, 0x05, 0x77, 0x48, 0x94, 0x15, 0x56, 0x77, 0x99, 0xAB, 0xBD, 0xD8, 0x28, 0x94,
  0x7C, 0xBB, 0x99, 0x87, 0x75, 0x54, 0x31, 0x20, 0x38, 0x09, 0x05, 0x03, 0x20, 0x78, 0x09, 0x0B,
  0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_set_meal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_set_meal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_signpost 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_maps_signpost_data[] PROGMEM = {
  0x60, 0x02, 0x75, 0x00, 0xA7, 0x89, 0x15, 0xDD, 0xDD, 0xEE, 0xDD, 0xDB, 0x30, 0x6F, 0xB0, 0xA2,
  0x06, 0xFB, 0x82, 0xD1, 0x06, 0xFA, 0x0E, 0x02, 0x28, 0x91, 0x13, 0x33, 0x3B, 0xB3, 0x33, 0x24,
  0x89, 0x15, 0x77, 0x7C, 0xC7, 0x77, 0x73, 0x20, 0x5F, 0xB8, 0x16, 0x01, 0xFC, 0x06, 0x20, 0x7F,
  0xB0, 0x63, 0x89, 0x17, 0x99, 0x9D, 0xD9, 0x99, 0x93, 0x70, 0x0A, 0x75, 0x00, 0xA7, 0x50, 0x0A,
  0x75, 0x00, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_signpost() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_signpost_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_snowmobile 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_maps_snowmobile_data[] PROGMEM = {
  0x71, 0x82, 0xBF, 0xB1, 0x77, 0x83, 0x36, 0xDC, 0x17, 0x71, 0x82, 0x6F, 0xD1, 0x48, 0x41, 0x43,
  0x31, 0x12, 0x01, 0x0A, 0xB0, 0xD0, 0x13, 0x0D, 0xE0, 0xEE, 0x0D, 0x01, 0x20, 0xBF, 0xF0, 0xD3,
  0x81, 0x59, 0xEF, 0xC0, 0xE4, 0x83, 0x3B, 0xFB, 0xCF, 0x0B, 0x03, 0x28, 0x31, 0xAF, 0xC3, 0x28,
  0x67, 0xE1, 0x11, 0x9F, 0x43, 0x81, 0xCD, 0x53, 0x81, 0x3D, 0x94, 0x84, 0x9F, 0x57, 0x9C, 0xE0,
  0xB0, 0x12, 0x09, 0xD0, 0x60, 0x18, 0x01, 0x30, 0x24, 0x84, 0x13, 0x33, 0x32, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_snowmobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_snowmobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_sos 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_maps_sos_data[] PROGMEM = {
  0x10, 0xF1, 0x30, 0x01, 0x48, 0x21, 0x10, 0x5B, 0x81, 0x42, 0xEA, 0x82, 0xE2, 0x2E, 0xA8, 0xA5,
  0x89, 0xB3, 0x30, 0x5F, 0x33, 0xF5, 0x6E, 0x33, 0x09, 0xD9, 0x80, 0x59, 0x29, 0x89, 0x25, 0x5F,
  0x99, 0x11, 0x99, 0xF5, 0x59, 0x29, 0x8A, 0x55, 0x08, 0x9D, 0x90, 0x33, 0xE6, 0x5F, 0x33, 0xF5,
  0x03, 0x3B, 0x98, 0xA8, 0x2E, 0x22, 0xEA, 0x81, 0xE2, 0x4B, 0x82, 0x50, 0x11, 0x40, 0x01, 0x30,
  0xF1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_sos() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_maps_sos_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_soup_kitchen 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_soup_kitchen_data[] PROGMEM = {
  0x74, 0x00, 0x17, 0x40, 0x7A, 0x06, 0x73, 0x98, 0x17, 0x9D, 0x72, 0x83, 0x2F, 0x33, 0xA2, 0x89,
  0x06, 0x05, 0x04, 0x10, 0x4F, 0x14, 0x87, 0xD0, 0xB1, 0x94, 0x05, 0xE5, 0x87, 0x94, 0x76, 0x58,
  0x07, 0xD5, 0x87, 0x58, 0x2A, 0x0C, 0x09, 0xB5, 0x87, 0x36, 0x18, 0x0A, 0x0B, 0x97, 0x50, 0xC0,
  0x83, 0x02, 0x80, 0x4D, 0x90, 0x63, 0x01, 0xFA, 0x02, 0x40, 0xAF, 0x0C, 0x50, 0x10, 0xED, 0x0E,
  0x02, 0x60, 0x10, 0xAB, 0x0B, 0x02, 0x73, 0x02, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_soup_kitchen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_soup_kitchen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_stadium 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_maps_stadium_data[] PROGMEM = {
  0x10, 0x15, 0x81, 0xC7, 0x12, 0x01, 0x48, 0x14, 0xD6, 0x38, 0x1D, 0xC3, 0x28, 0x17, 0xC4, 0x28,
  0x24, 0xE7, 0x12, 0x03, 0x48, 0x17, 0xD6, 0x28, 0x92, 0x11, 0x25, 0x77, 0x99, 0x77, 0x43, 0x40,
  0x60, 0xDA, 0x84, 0xDC, 0xBB, 0xCD, 0xA8, 0x2D, 0x60, 0x2A, 0x09, 0x03, 0x60, 0x30, 0x9A, 0x02,
  0x03, 0xE0, 0x0D, 0xE0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3D, 0x82, 0xA9, 0x9A,
  0xD0, 0x03, 0xC0, 0xC4, 0x0C, 0xC8, 0x13, 0x0C, 0xB0, 0xB4, 0x0B, 0xB0, 0xC3, 0x82, 0x5A, 0xEB,
  0x48, 0x2B, 0xEA, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_stadium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_stadium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_store_mall_directory 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_maps_store_mall_directory_data[] PROGMEM = {
  0x10, 0x38, 0x06, 0xD0, 0x32, 0x01, 0x80, 0x67, 0x01, 0x20, 0x28, 0x06, 0x90, 0x22, 0x0A, 0xFB,
  0x0A, 0x20, 0xEF, 0xB8, 0x1E, 0x02, 0xFD, 0x02, 0x05, 0xFD, 0x89, 0x45, 0x08, 0xF5, 0x55, 0xAE,
  0x55, 0x5F, 0x82, 0x06, 0x0E, 0x30, 0x60, 0xD3, 0x0E, 0x06, 0x20, 0x60, 0xE3, 0x06, 0x0D, 0x30,
  0xE0, 0x62, 0x05, 0xD0, 0xD3, 0x0E, 0x05, 0x38, 0x01, 0x50, 0x23, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_store_mall_directory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_store_mall_directory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_straight 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_round_18_maps_straight_data[] PROGMEM = {
  0x20, 0x0A, 0x30, 0xBA, 0x86, 0xB0, 0x4E, 0xCC, 0xE4, 0x20, 0x0A, 0x40, 0x0A, 0x40, 0x0A, 0x40,
  0x0A, 0x40, 0x0A, 0x40, 0x0A, 0x40, 0x0A, 0x40, 0x0A, 0x40, 0x09, 0x40, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_straight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 11, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_straight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_streetview 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_maps_streetview_data[] PROGMEM = {
  0x72, 0x83, 0x6D, 0xFD, 0x62, 0x02, 0x80, 0x13, 0x10, 0x6D, 0x06, 0x02, 0xD8, 0x1A, 0x0D, 0xD0,
  0xD0, 0x4D, 0x08, 0x1F, 0x04, 0xD8, 0x1A, 0x0D, 0xD0, 0xD0, 0x4D, 0x81, 0xE0, 0x6D, 0x06, 0x04,
  0xE8, 0x79, 0x06, 0xDF, 0xD6, 0x04, 0xE0, 0x77, 0x04, 0xD8, 0x37, 0x07, 0xCD, 0xA8, 0x14, 0x04,
  0xC8, 0x17, 0x09, 0xD8, 0x14, 0x04, 0xB0, 0x72, 0x0E, 0xD8, 0x14, 0x04, 0xA0, 0x73, 0xE8, 0x34,
  0x04, 0xF7, 0x4E, 0x82, 0x40, 0x27, 0x5E, 0x02, 0x71, 0x80, 0x13, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_streetview() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_streetview_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_subway 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_maps_subway_data[] PROGMEM = {
  0x68, 0x21, 0x22, 0x17, 0x20, 0x60, 0xCE, 0x0C, 0x06, 0x50, 0xCF, 0xB0, 0xC3, 0x09, 0xA8, 0x6E,
  0xB8, 0x77, 0x8B, 0xEA, 0x09, 0x2A, 0x0C, 0x01, 0x60, 0x10, 0xCA, 0x10, 0x2A, 0x07, 0x71, 0x07,
  0xA0, 0x20, 0x3A, 0x07, 0x01, 0x80, 0x2C, 0x01, 0x07, 0xA0, 0x03, 0xA0, 0x70, 0x2E, 0x02, 0x07,
  0xA0, 0x03, 0xA0, 0x70, 0x28, 0x02, 0xD0, 0x20, 0x7A, 0x00, 0x3A, 0x07, 0x71, 0x07, 0xA0, 0x03,
  0xA8, 0x27, 0x0D, 0x12, 0x82, 0x1D, 0x07, 0xA0, 0x03, 0xA8, 0x1A, 0x04, 0x48, 0x14, 0x0A, 0xA0,
  0x03, 0xB8, 0x68, 0x11, 0x33, 0x11, 0x8B, 0x00, 0x3C, 0x05, 0x0C, 0xA0, 0xC0, 0x5C, 0x81, 0x30,
  0xEF, 0xD0, 0xE3, 0x80, 0x90, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_subway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_subway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_synagogue 18x18, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_round_18_maps_synagogue_data[] PROGMEM = {
  0x10, 0x20, 0x54, 0x82, 0x2B, 0xB2, 0x40, 0x50, 0x22, 0x81, 0xEF, 0x72, 0x04, 0x0E, 0xA0, 0xE0,
  0x42, 0x83, 0x7F, 0xE0, 0x1A, 0x81, 0x90, 0x7E, 0x81, 0x70, 0x9A, 0x84, 0x10, 0x33, 0x25, 0xB0,
  0x07, 0xB8, 0x45, 0x23, 0x30, 0x1A, 0x09, 0x07, 0xA0, 0xE2, 0x0E, 0xA0, 0x70, 0x9A, 0x00, 0x1A,
  0x09, 0x07, 0xB0, 0x09, 0xB0, 0x70, 0x9A, 0x00, 0x1A, 0x09, 0x07, 0xF9, 0x07, 0x09, 0xA0, 0x01,
  0xA0, 0x90, 0x7B, 0x00, 0xEB, 0x07, 0x09, 0xA0, 0x01, 0xA0, 0x90, 0x7A, 0x0A, 0x20, 0x9A, 0x07,
  0x09, 0xA0, 0x01, 0xA0, 0x90, 0x7A, 0x03, 0x20, 0x3A, 0x07, 0x09, 0xA0, 0x01, 0xA0, 0x90, 0x7A,
  0x03, 0x20, 0x3A, 0x07, 0x09, 0xA8, 0x41, 0x0D, 0xF9, 0x7A, 0x03, 0x20, 0x3A, 0x82, 0x79, 0xFD,
  0x28, 0x41, 0x32, 0x13, 0x34, 0x84, 0x33, 0x12, 0x31, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_synagogue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_synagogue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_takeout_dining 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_maps_takeout_dining_data[] PROGMEM = {
  0x58, 0x00, 0x37, 0x20, 0x9C, 0x09, 0x70, 0x9E, 0x09, 0x38, 0x13, 0x96, 0xF9, 0x84, 0x69, 0x32,
  0xEE, 0xF9, 0x84, 0xEE, 0x20, 0x3E, 0xF9, 0x0E, 0x03, 0x38, 0x06, 0x14, 0x04, 0xF9, 0x04, 0x40,
  0x3F, 0x90, 0x34, 0x03, 0xF9, 0x03, 0x40, 0x2F, 0x90, 0x25, 0x0E, 0xE0, 0xE6, 0x02, 0x80, 0x25,
  0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_takeout_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_takeout_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_taxi_alert 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_18_maps_taxi_alert_data[] PROGMEM = {
  0x74, 0x02, 0x76, 0x06, 0x0E, 0xA0, 0x97, 0x30, 0x5A, 0x0B, 0xA0, 0x96, 0x82, 0x9B, 0x0C, 0xA0,
  0x20, 0xEA, 0x38, 0x52, 0x89, 0xDA, 0x0E, 0xA0, 0xBB, 0x02, 0x28, 0x5C, 0xDB, 0xB9, 0x0B, 0xA0,
  0x8A, 0x0E, 0x28, 0x13, 0xF3, 0x40, 0x3A, 0x0E, 0xA0, 0x62, 0x09, 0x0C, 0x68, 0x33, 0xBE, 0xC5,
  0x20, 0x1F, 0x0B, 0x02, 0x60, 0x3F, 0xA8, 0x2C, 0xAC, 0x52, 0x03, 0xA0, 0x40, 0x6C, 0x83, 0x92,
  0xEF, 0x62, 0x03, 0xA0, 0x70, 0x8C, 0x0A, 0x04, 0xA0, 0x62, 0x03, 0xFD, 0x06, 0x28, 0x13, 0xFE,
  0x80, 0x4D, 0x81, 0xEF, 0x62, 0x81, 0x1F, 0x77, 0x18, 0x14, 0xF4, 0x30, 0x17, 0x30, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_taxi_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_taxi_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_temple_buddhist 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_maps_temple_buddhist_data[] PROGMEM = {
  0x70, 0x06, 0x76, 0x03, 0xA0, 0x37, 0x10, 0x42, 0x01, 0x0D, 0xA0, 0xD0, 0x12, 0x04, 0x38, 0x94,
  0x2F, 0x30, 0x47, 0x77, 0x74, 0x05, 0xF1, 0x38, 0x1B, 0xEA, 0x80, 0x29, 0x81, 0xAF, 0x92, 0x82,
  0x82, 0x0B, 0xF9, 0x86, 0x90, 0x28, 0xCB, 0x02, 0x80, 0x43, 0x84, 0x10, 0xBC, 0x3E, 0x98, 0x06,
  0xD9, 0x83, 0xE3, 0x01, 0x9F, 0xB0, 0x94, 0x06, 0xFB, 0x06, 0x40, 0x6F, 0xB0, 0x64, 0x06, 0xC0,
  0x0B, 0xC0, 0x64, 0x06, 0xB0, 0x82, 0x07, 0xB0, 0x64, 0x06, 0xB0, 0x32, 0x03, 0xB0, 0x64, 0x02,
  0xB0, 0x32, 0x03, 0xB0, 0x25, 0x81, 0x13, 0x34, 0x81, 0x33, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_temple_buddhist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_temple_buddhist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_temple_hindu 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_maps_temple_hindu_data[] PROGMEM = {
  0x68, 0x2B, 0x77, 0xB7, 0x58, 0x2C, 0xAA, 0xC7, 0x40, 0x1C, 0x01, 0x73, 0x07, 0xC0, 0x77, 0x77,
  0x40, 0x38, 0x02, 0xB0, 0x37, 0x10, 0x9E, 0x09, 0x40, 0x10, 0xC2, 0x06, 0x80, 0x27, 0x06, 0x28,
  0x3C, 0x13, 0xF3, 0x80, 0x61, 0x82, 0x3F, 0x33, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xE0, 0x0B, 0xE0,
  0x03, 0xD0, 0x72, 0x07, 0xD0, 0x03, 0xD0, 0x32, 0x03, 0xD0, 0x03, 0xD0, 0x32, 0x03, 0xD0, 0x31,
  0x80, 0x13, 0x48, 0x01, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_temple_hindu() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_temple_hindu_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_terrain 18x18, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_18_maps_terrain_data[] PROGMEM = {
  0x71, 0x81, 0x5C, 0x27, 0x58, 0x22, 0xEF, 0xC7, 0x50, 0xDB, 0x09, 0x78, 0x25, 0xC2, 0x2D, 0x05,
  0x58, 0x42, 0xEF, 0xD0, 0x6C, 0x0E, 0x02, 0x40, 0xCB, 0x81, 0xA0, 0xAC, 0x0C, 0x30, 0x9D, 0x08,
  0x0C, 0xD8, 0x19, 0x01, 0xFF, 0x81, 0x10, 0x68, 0x09, 0x07, 0x06, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_terrain() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_maps_terrain_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_theater_comedy 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_18_maps_theater_comedy_data[] PROGMEM = {
  0x72, 0x80, 0x33, 0x73, 0x0A, 0xF0, 0xD7, 0x20, 0xDF, 0x90, 0x17, 0x18, 0x5D, 0xFC, 0x7F, 0x9A,
  0xA0, 0x17, 0x18, 0x55, 0x6A, 0x8F, 0xAB, 0xA8, 0x11, 0x06, 0x80, 0x2B, 0x81, 0xA4, 0x4E, 0x01,
  0x1F, 0x98, 0x3D, 0x38, 0x36, 0xB1, 0x01, 0xA8, 0x2E, 0xEF, 0xDA, 0x89, 0x0D, 0x38, 0x77, 0xEF,
  0xC0, 0x1A, 0x86, 0x75, 0xF2, 0xAF, 0xD3, 0xD8, 0x15, 0x01, 0xD0, 0xEA, 0x0D, 0x03, 0xC0, 0x82,
  0x01, 0xB8, 0x1B, 0xBC, 0xA8, 0x4D, 0x18, 0xA8, 0x34, 0x84, 0xEF, 0xE2, 0x04, 0xA0, 0xB7, 0x20,
  0xAF, 0x07, 0x72, 0x01, 0x0E, 0xD0, 0xC7, 0x40, 0x10, 0xBA, 0x0E, 0x09, 0x77, 0x10, 0x27, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_theater_comedy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_theater_comedy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_tire_repair 18x18, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_round_18_maps_tire_repair_data[] PROGMEM = {
  0x75, 0x02, 0x40, 0x18, 0x01, 0x33, 0x09, 0xA8, 0x3E, 0x40, 0x1E, 0xD8, 0x92, 0x50, 0x9E, 0x53,
  0x9F, 0x23, 0xF7, 0xA8, 0xC4, 0x9C, 0x80, 0xE6, 0x19, 0x3D, 0x73, 0xF2, 0x8D, 0x0C, 0x80, 0xF5,
  0x3A, 0x0B, 0x93, 0xFB, 0x8D, 0x6F, 0x80, 0xCB, 0x28, 0x44, 0xF5, 0x3F, 0xBA, 0x8A, 0x1D, 0xD8,
  0x02, 0xEE, 0xDF, 0xA0, 0x3F, 0x2A, 0xE2, 0xC8, 0x20, 0x4A, 0x0C, 0x28, 0x63, 0xF7, 0x7D, 0x2E,
  0x83, 0x06, 0x0E, 0x38, 0x53, 0xFE, 0xCE, 0xDE, 0xA8, 0x28, 0x06, 0xE3, 0x89, 0x33, 0xF4, 0xDF,
  0x6C, 0xC7, 0xF2, 0x6E, 0x38, 0x93, 0x3F, 0x37, 0xD0, 0xD8, 0x1F, 0x36, 0xE3, 0x89, 0x33, 0xFD,
  0xAD, 0xAF, 0x80, 0xF6, 0x8D, 0x30, 0x10, 0xED, 0x81, 0x50, 0x9A, 0x07, 0x40, 0x18, 0x01, 0x33,
  0x03, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_tire_repair() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_tire_repair_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_traffic 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_maps_traffic_data[] PROGMEM = {
  0x38, 0x02, 0x35, 0x06, 0xE0, 0x62, 0x81, 0x17, 0xCE, 0x82, 0xC7, 0x12, 0xC0, 0x04, 0xC8, 0x12,
  0x06, 0xB0, 0x08, 0xB8, 0x37, 0x01, 0x5B, 0xE8, 0x2B, 0x51, 0x3C, 0x00, 0x6C, 0x81, 0x30, 0x9B,
  0x00, 0x6B, 0x09, 0x20, 0x30, 0xBE, 0x82, 0xB3, 0x03, 0xC0, 0x08, 0xC8, 0x13, 0x0B, 0xB0, 0x04,
  0xB0, 0xB3, 0x0A, 0xE0, 0xA4, 0x06, 0xE0, 0x65, 0x80, 0x23, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_traffic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_traffic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_train 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_maps_train_data[] PROGMEM = {
  0x48, 0x21, 0x22, 0x15, 0x04, 0x0B, 0xE8, 0x2C, 0x50, 0x2F, 0xB0, 0x20, 0x5F, 0xB8, 0x95, 0x56,
  0xF5, 0x55, 0xCC, 0x55, 0x5F, 0x66, 0xE3, 0x00, 0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x95,
  0xE6, 0x6F, 0xDD, 0xDE, 0xED, 0xDD, 0xF6, 0x6F, 0xB8, 0x46, 0x6F, 0xE1, 0x7A, 0x84, 0x71, 0xEF,
  0x65, 0xA0, 0x60, 0xBA, 0x0B, 0x06, 0xA8, 0x15, 0x1E, 0xF9, 0x83, 0xE1, 0x03, 0xCE, 0x0C, 0x03,
  0x38, 0x16, 0xE3, 0x28, 0x13, 0xE6, 0x40, 0x10, 0x24, 0x02, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_train() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_train_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_tram 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_tram_data[] PROGMEM = {
  0x38, 0x02, 0x15, 0x86, 0x6B, 0xBB, 0xFB, 0xB6, 0x58, 0x41, 0x37, 0xC3, 0x14, 0x05, 0x0D, 0xE8,
  0x2D, 0x60, 0x3F, 0xB0, 0x30, 0x6F, 0xB8, 0x16, 0x6E, 0x80, 0x43, 0x82, 0xE6, 0x6E, 0x71, 0x82,
  0xE6, 0x6E, 0x71, 0x81, 0xE6, 0x6F, 0xB0, 0x06, 0xC0, 0x0E, 0xC0, 0x06, 0xC0, 0x03, 0xC0, 0x60,
  0x5C, 0x00, 0xAC, 0x81, 0x51, 0xEF, 0x98, 0x93, 0xE1, 0x02, 0xAF, 0xED, 0xDE, 0xFA, 0x23, 0x81,
  0x7E, 0x22, 0x81, 0x2E, 0x75, 0x01, 0x40, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_tram() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_tram_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_transfer_within_a_station 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_maps_transfer_within_a_station_data[] PROGMEM = {
  0x60, 0x27, 0x78, 0x1D, 0xF8, 0x75, 0x03, 0xA0, 0xC7, 0x68, 0x1A, 0xD5, 0x74, 0x82, 0x16, 0x71,
  0x73, 0x03, 0x0A, 0xB0, 0xB7, 0x39, 0x0C, 0x09, 0xB0, 0x77, 0x18, 0x21, 0xF3, 0x7A, 0x82, 0x8F,
  0xB5, 0x78, 0x1C, 0x2A, 0xA1, 0x81, 0x29, 0x97, 0x28, 0x2D, 0xFE, 0x24, 0x03, 0x68, 0x31, 0xF5,
  0xCD, 0x30, 0x60, 0xB0, 0xF3, 0x38, 0x44, 0xF1, 0x2F, 0x32, 0x84, 0xAD, 0x99, 0x91, 0x28, 0x47,
  0xD0, 0x2F, 0x33, 0x82, 0x60, 0x51, 0x38, 0x4A, 0xA0, 0x2F, 0x32, 0x0F, 0x90, 0xC0, 0xD3, 0x84,
  0xC7, 0x01, 0xF2, 0x20, 0xF3, 0x00, 0x93, 0x01, 0x30, 0x16, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_transfer_within_a_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_transfer_within_a_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_transit_enterexit 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_round_18_maps_transit_enterexit_data[] PROGMEM = {
  0x68, 0x23, 0x04, 0x53, 0x83, 0x7F, 0x39, 0xB2, 0x89, 0x07, 0xF7, 0x09, 0xB0, 0x7F, 0x72, 0x83,
  0x9B, 0x7F, 0x73, 0x82, 0x9E, 0xF7, 0x48, 0x95, 0x8F, 0xEB, 0xBB, 0x60, 0x18, 0x99, 0x99, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_transit_enterexit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 12, 12), Box(0, 0, 17, 17),
      ic_round_18_maps_transit_enterexit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_trip_origin 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_maps_trip_origin_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9B, 0x82, 0xC9, 0x9C,
  0xB0, 0x93, 0x03, 0xA0, 0xE0, 0x54, 0x05, 0x0E, 0xA0, 0x32, 0x0B, 0xA0, 0x56, 0x05, 0xA0, 0xB2,
  0xA0, 0xC7, 0x10, 0xCA, 0x10, 0x2A, 0x09, 0x71, 0x09, 0xA0, 0x02, 0xA0, 0x97, 0x10, 0x9A, 0x02,
  0x1A, 0x0C, 0x71, 0x0C, 0xA2, 0x0B, 0xA0, 0x56, 0x05, 0xA0, 0xB2, 0x03, 0xA0, 0xE0, 0x54, 0x05,
  0x0E, 0xA0, 0x33, 0x09, 0xB8, 0x2C, 0x99, 0xCB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0,
  0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_trip_origin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_trip_origin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_turn_left 18x18, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_18_maps_turn_left_data[] PROGMEM = {
  0x10, 0x50, 0xD7, 0x81, 0x5F, 0xB8, 0x01, 0x38, 0x11, 0x0C, 0xF8, 0x95, 0xD0, 0x3E, 0xB1, 0x11,
  0x14, 0xF2, 0x03, 0xB4, 0x81, 0x3F, 0x27, 0x81, 0x3F, 0x27, 0x81, 0x3F, 0x27, 0x81, 0x3F, 0x27,
  0x81, 0x2F, 0x27, 0x10, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_turn_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 12, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_turn_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_turn_right 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_18_maps_turn_right_data[] PROGMEM = {
  0x70, 0xD0, 0x52, 0x01, 0x80, 0x13, 0x83, 0xBF, 0x50, 0xDF, 0x89, 0x4C, 0x2F, 0x41, 0x11, 0x1B,
  0xE3, 0x2F, 0x34, 0x84, 0xB3, 0x02, 0xF3, 0x78, 0x12, 0xF3, 0x78, 0x12, 0xF3, 0x78, 0x12, 0xF2,
  0x71, 0x04, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_turn_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_turn_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_turn_sharp_left 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_maps_turn_sharp_left_data[] PROGMEM = {
  0x18, 0x13, 0xC6, 0x60, 0x30, 0xEA, 0x06, 0x58, 0x3A, 0xBF, 0xBE, 0x79, 0x04, 0x71, 0x90, 0x47,
  0x19, 0x04, 0x71, 0x90, 0xA8, 0x01, 0x70, 0x32, 0x07, 0x80, 0x1B, 0x0C, 0x0E, 0x71, 0x04, 0x97,
  0x10, 0x49, 0x71, 0x04, 0x97, 0x10, 0x49, 0x72, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_turn_sharp_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_turn_sharp_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_turn_sharp_right 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_maps_turn_sharp_right_data[] PROGMEM = {
  0x68, 0x16, 0xC3, 0x60, 0x6A, 0x0E, 0x03, 0x58, 0x3E, 0xBF, 0xBA, 0x60, 0x49, 0x71, 0x04, 0x97,
  0x10, 0x49, 0x20, 0x38, 0x01, 0x70, 0xA9, 0x20, 0xE0, 0xC8, 0x01, 0xB0, 0x72, 0x90, 0x47, 0x19,
  0x04, 0x71, 0x90, 0x47, 0x19, 0x04, 0x71, 0x02, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_turn_sharp_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_turn_sharp_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_turn_slight_left 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_18_maps_turn_slight_left_data[] PROGMEM = {
  0x82, 0x35, 0x52, 0x3B, 0x09, 0x3A, 0x0B, 0x49, 0x81, 0x7E, 0xB3, 0x83, 0x40, 0x2E, 0xB5, 0x81,
  0x2E, 0xB5, 0x81, 0x3F, 0x34, 0x81, 0x1F, 0x34, 0x81, 0x1F, 0x34, 0x81, 0x1F, 0x34, 0x81, 0x1F,
  0x35, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_turn_slight_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 11, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_turn_slight_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_turn_slight_right 18x18, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_round_18_maps_turn_slight_right_data[] PROGMEM = {
  0x38, 0x22, 0x55, 0x33, 0x09, 0xB4, 0x0B, 0xA3, 0x81, 0xBE, 0x79, 0x28, 0x7B, 0xE2, 0x04, 0x0B,
  0xE2, 0x38, 0x13, 0xF3, 0x48, 0x13, 0xF1, 0x48, 0x13, 0xF1, 0x48, 0x13, 0xF1, 0x48, 0x13, 0xF1,
  0x50, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_turn_slight_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 12, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_turn_slight_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_two_wheeler 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_maps_two_wheeler_data[] PROGMEM = {
  0x68, 0x17, 0x91, 0x74, 0x83, 0x36, 0xD6, 0xB3, 0x89, 0x12, 0xBB, 0x91, 0x5B, 0xBE, 0xF4, 0x40,
  0x60, 0xED, 0x89, 0x1E, 0x9E, 0xC4, 0x01, 0xD2, 0x2E, 0xB8, 0x68, 0xD2, 0x2D, 0x13, 0xA2, 0x84,
  0xBE, 0xFE, 0x3B, 0x28, 0x95, 0xA3, 0x0D, 0x67, 0xC2, 0xA5, 0x0C, 0x76, 0xD2, 0x82, 0x17, 0x71,
  0x48, 0x21, 0x77, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_two_wheeler() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_maps_two_wheeler_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_u_turn_left 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_maps_u_turn_left_data[] PROGMEM = {
  0x50, 0x30, 0x26, 0x04, 0x0E, 0xA0, 0xE0, 0x53, 0x86, 0x3F, 0x82, 0x29, 0xF4, 0x20, 0xB0, 0xA4,
  0x0B, 0x0C, 0x20, 0xE0, 0x54, 0x05, 0x92, 0x90, 0x44, 0x85, 0x4F, 0x65, 0xF7, 0x83, 0x81, 0x4F,
  0x7B, 0x0B, 0x38, 0x44, 0xF0, 0x8F, 0xB4, 0x04, 0x92, 0x03, 0x50, 0x49, 0x71, 0x04, 0x97, 0x10,
  0x49, 0x72, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_u_turn_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 12, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_u_turn_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_u_turn_right 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_maps_u_turn_right_data[] PROGMEM = {
  0x30, 0x20, 0x36, 0x05, 0x0E, 0xA0, 0xE0, 0x43, 0x86, 0x4F, 0x92, 0x28, 0xF3, 0x20, 0xC0, 0xB4,
  0x0A, 0x0B, 0x29, 0x05, 0x40, 0x50, 0xE2, 0x90, 0x44, 0x04, 0x92, 0x90, 0x43, 0x85, 0x87, 0xF5,
  0x6F, 0x43, 0x0B, 0xB8, 0x17, 0xF4, 0x48, 0x4B, 0xF8, 0x0F, 0x45, 0x03, 0x29, 0x04, 0x71, 0x90,
  0x47, 0x10, 0x47, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_u_turn_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_u_turn_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_volunteer_activism 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_maps_volunteer_activism_data[] PROGMEM = {
  0x72, 0x00, 0x12, 0x00, 0x17, 0x30, 0x9A, 0x0A, 0x0B, 0xA0, 0x77, 0x10, 0x3F, 0x90, 0x17, 0x03,
  0xF9, 0x01, 0x71, 0x0D, 0xE0, 0xB7, 0x20, 0x20, 0xEC, 0x0D, 0x01, 0x73, 0x03, 0x0E, 0xA0, 0xD0,
  0x23, 0x89, 0x39, 0xC3, 0x0D, 0xC7, 0x10, 0x3E, 0xD1, 0x30, 0x1A, 0x09, 0x1C, 0x81, 0xB6, 0x15,
  0x01, 0xA0, 0x91, 0xF0, 0x54, 0x01, 0xA0, 0x91, 0xB8, 0x39, 0xAB, 0xB3, 0x40, 0x1A, 0x09, 0x1B,
  0x0B, 0x06, 0x80, 0x15, 0x81, 0x30, 0x1A, 0x09, 0x1F, 0xC0, 0x01, 0xA8, 0x19, 0x0D, 0xF8, 0x1E,
  0x93, 0x28, 0x1D, 0xF5, 0x28, 0x52, 0x6A, 0xEF, 0xB5, 0x60, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_volunteer_activism() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_volunteer_activism_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_warehouse 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_maps_warehouse_data[] PROGMEM = {
  0x70, 0x01, 0x75, 0x05, 0x0B, 0xA0, 0xB0, 0x57, 0x81, 0x39, 0xEE, 0x81, 0xE9, 0x33, 0x0B, 0xFD,
  0x81, 0xB0, 0x2F, 0xF0, 0x20, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3B, 0x06, 0x60, 0x6B, 0x00, 0x3B,
  0x06, 0x60, 0x6B, 0x00, 0x3B, 0x06, 0x20, 0x02, 0x20, 0x6B, 0x00, 0x3B, 0x06, 0x20, 0x0A, 0x20,
  0x6B, 0x00, 0x3B, 0x06, 0x60, 0x6B, 0x81, 0x31, 0xEA, 0x86, 0x60, 0xF5, 0x5F, 0x06, 0xA8, 0x97,
  0xE1, 0x01, 0x33, 0x10, 0x31, 0x13, 0x01, 0x33, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_warehouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_warehouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_wine_bar 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_maps_wine_bar_data[] PROGMEM = {
  0x03, 0x80, 0x4B, 0x03, 0x07, 0x98, 0x02, 0xB9, 0x00, 0x79, 0x69, 0x00, 0x79, 0x69, 0x00, 0x7F,
  0x90, 0x70, 0x5F, 0x90, 0x50, 0x1F, 0x98, 0x11, 0x07, 0xE0, 0x73, 0x06, 0x0D, 0xA0, 0xD0, 0x66,
  0x00, 0xC7, 0x10, 0x0B, 0x71, 0x00, 0xB6, 0x84, 0x9B, 0xEE, 0xB9, 0x48, 0x49, 0xBB, 0xBB, 0x92,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_wine_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_wine_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_wrong_location 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_maps_wrong_location_data[] PROGMEM = {
  0x48, 0x90, 0x13, 0x31, 0x0B, 0x51, 0xC3, 0x20, 0x20, 0xBC, 0x87, 0x58, 0xFE, 0xC1, 0x03, 0xED,
  0x83, 0xA1, 0xEF, 0x62, 0x0E, 0xE8, 0x52, 0xDC, 0x9F, 0x37, 0xF8, 0x54, 0x51, 0x35, 0x1B, 0xB8,
  0x6E, 0x55, 0xEE, 0xAD, 0xA2, 0x0C, 0xB0, 0xA2, 0x0A, 0xB0, 0xC2, 0x09, 0xB8, 0x2E, 0x33, 0xEB,
  0x0B, 0x20, 0x5F, 0xB0, 0x63, 0x0D, 0xF9, 0x0D, 0x40, 0x4F, 0x90, 0x45, 0x08, 0xE0, 0x87, 0x0A,
  0xC0, 0xA7, 0x20, 0xBA, 0x0B, 0x74, 0x00, 0x97,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_wrong_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_maps_wrong_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_zoom_in_map 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_maps_zoom_in_map_data[] PROGMEM = {
  0x82, 0xD7, 0x04, 0x48, 0x74, 0x07, 0xD6, 0xF9, 0xF2, 0x28, 0x52, 0xF9, 0xF6, 0x08, 0xA0, 0x32,
  0x03, 0xA8, 0x18, 0x04, 0xB0, 0x22, 0x02, 0xB8, 0x34, 0x03, 0x32, 0x48, 0x12, 0x33, 0x77, 0x75,
  0x81, 0x33, 0x24, 0x83, 0x23, 0x30, 0x4B, 0x02, 0x20, 0x2B, 0x81, 0x40, 0x8A, 0x03, 0x20, 0x3A,
  0x85, 0x80, 0x6F, 0x9F, 0x22, 0x87, 0x2F, 0x9F, 0x6D, 0x70, 0x44, 0x82, 0x40, 0x7D,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_zoom_in_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_maps_zoom_in_map_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_maps_zoom_out_map 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_maps_zoom_out_map_data[] PROGMEM = {
  0x18, 0x13, 0x32, 0x68, 0x32, 0x33, 0x04, 0xA0, 0x66, 0x06, 0xA0, 0x04, 0xA0, 0x76, 0x07, 0xA8,
  0x44, 0x26, 0x6F, 0x64, 0x83, 0x6F, 0x76, 0x23, 0x06, 0x0A, 0x40, 0xA0, 0x68, 0x0F, 0x20, 0x06,
  0x0A, 0x40, 0xA0, 0x63, 0x83, 0x26, 0x7F, 0x64, 0x84, 0x6F, 0x66, 0x24, 0xA0, 0x66, 0x07, 0xA0,
  0x04, 0xA0, 0x66, 0x06, 0xA8, 0x34, 0x03, 0x32, 0x68, 0x12, 0x33, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_maps_zoom_out_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_maps_zoom_out_map_data, Alpha4(color::Black));
  return value;
}
