#include "hardware.h"

using namespace roo_display;

// Image file ic_round_18_hardware_adf_scanner 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_hardware_adf_scanner_data[] PROGMEM = {
  0x40, 0x48, 0x02, 0x50, 0x47, 0x05, 0xF9, 0x05, 0x60, 0x70, 0xD6, 0x0D, 0x07, 0x60, 0x70, 0xD6,
  0x0D, 0x07, 0x60, 0x70, 0xD6, 0x0D, 0x07, 0x48, 0x21, 0x6B, 0xE8, 0x02, 0x78, 0x2E, 0xB6, 0x12,
  0x0D, 0xFD, 0x81, 0xD0, 0x2F, 0xC0, 0xEA, 0x02, 0x03, 0xFB, 0x0A, 0x02, 0xA0, 0x03, 0xFC, 0x0E,
  0xA0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_adf_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_adf_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_browser_not_supported 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_hardware_browser_not_supported_data[] PROGMEM = {
  0x81, 0x70, 0x48, 0x04, 0x51, 0x81, 0x9A, 0x28, 0x03, 0x78, 0x3B, 0x56, 0xEA, 0x78, 0x47, 0x66,
  0x79, 0xA6, 0x85, 0x76, 0x67, 0x09, 0xA5, 0x82, 0x76, 0x67, 0x20, 0x90, 0xA4, 0x82, 0x76, 0x67,
  0x30, 0x90, 0xA3, 0x82, 0x76, 0x67, 0x40, 0x90, 0xA2, 0x82, 0x76, 0x67, 0x58, 0x59, 0xA0, 0x76,
  0x67, 0x68, 0x49, 0xA2, 0x45, 0xB8, 0x03, 0x70, 0xE0, 0xA2, 0x80, 0x55, 0x09, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_browser_not_supported() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_browser_not_supported_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_browser_updated 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_hardware_browser_updated_data[] PROGMEM = {
  0x10, 0x18, 0x02, 0x32, 0x02, 0x50, 0x10, 0xEE, 0x81, 0x16, 0xD5, 0x81, 0x3F, 0x26, 0x06, 0x0E,
  0x58, 0x13, 0xF2, 0x60, 0x60, 0xE5, 0x81, 0x3F, 0x26, 0x06, 0x0E, 0x58, 0x13, 0xF2, 0x60, 0x60,
  0xE5, 0x81, 0x3F, 0x24, 0x85, 0x8D, 0xEF, 0xDD, 0x12, 0x81, 0x3F, 0x24, 0x01, 0x0D, 0xB8, 0x56,
  0x06, 0x03, 0xF2, 0x58, 0x91, 0x1D, 0xF6, 0x02, 0xF3, 0x3F, 0x26, 0x01, 0x05, 0x28, 0x22, 0xF3,
  0x19, 0x80, 0x90, 0xD9, 0x85, 0x10, 0x47, 0x77, 0xEC, 0x83, 0xE7, 0x77, 0x45, 0x02, 0xE0, 0x27,
  0x28, 0x02, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_browser_updated() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_browser_updated_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_cast_connected 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_hardware_cast_connected_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x11, 0x1B, 0x74, 0x81, 0x2F, 0x33, 0x01, 0x07,
  0x80, 0x2B, 0x89, 0x2A, 0x22, 0xF3, 0x1A, 0x83, 0x04, 0xED, 0x89, 0x27, 0x2F, 0x30, 0x9D, 0xFB,
  0x12, 0xEC, 0x82, 0x72, 0xF3, 0x38, 0x34, 0xDE, 0x24, 0xC8, 0x93, 0x72, 0xF3, 0x1E, 0xB2, 0x1D,
  0xC0, 0xAB, 0x8B, 0x27, 0x2F, 0x30, 0x5C, 0xE3, 0x3F, 0x52, 0xBB, 0xA2, 0x2F, 0x30, 0x20, 0xBC,
  0x0B, 0xB5, 0x89, 0x32, 0xF3, 0x3F, 0x43, 0xF2, 0x7D, 0x07, 0xD8, 0x41, 0x05, 0x20, 0x42, 0x86,
  0x40, 0x25, 0x55, 0x53, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_cast_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_cast_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_cast_for_education 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_hardware_cast_for_education_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x11, 0x1B, 0x74, 0x81, 0x2F, 0x37, 0x18, 0x92,
  0x5D, 0xA2, 0x02, 0xF3, 0x1A, 0x83, 0x30, 0x4B, 0x89, 0x1D, 0x02, 0xF3, 0x09, 0xDF, 0xB1, 0x28,
  0x64, 0xB9, 0x30, 0x2F, 0x33, 0x8A, 0x64, 0xDE, 0x20, 0xD7, 0xA9, 0x02, 0xF3, 0x1E, 0xB2, 0x1D,
  0xC0, 0x18, 0x62, 0x89, 0x12, 0xF3, 0x05, 0xCE, 0x33, 0xF5, 0x58, 0x91, 0x2F, 0x30, 0x20, 0xBC,
  0x0B, 0xB5, 0x89, 0x32, 0xF3, 0x3F, 0x43, 0xF2, 0x7D, 0x07, 0xD8, 0x41, 0x05, 0x20, 0x42, 0x86,
  0x40, 0x25, 0x55, 0x53, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_cast_for_education() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_cast_for_education_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_cast 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_hardware_cast_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x11, 0x1B, 0x74, 0x81, 0x2F, 0x37, 0x68, 0x52,
  0xF3, 0x1A, 0x83, 0x72, 0x87, 0x2F, 0x30, 0x9D, 0xFB, 0x17, 0x81, 0x2F, 0x33, 0x82, 0x4D, 0xE2,
  0x68, 0x90, 0x2F, 0x31, 0xEB, 0x21, 0xDC, 0x68, 0x91, 0x2F, 0x30, 0x5C, 0xE3, 0x3F, 0x55, 0x89,
  0x12, 0xF3, 0x02, 0x0B, 0xC0, 0xBB, 0x58, 0x93, 0x2F, 0x33, 0xF4, 0x3F, 0x27, 0xD0, 0x7D, 0x84,
  0x10, 0x52, 0x04, 0x28, 0x64, 0x02, 0x55, 0x55, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_cast() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_cast_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_computer 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_hardware_computer_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x2F, 0x58, 0x06,
  0x38, 0x35, 0xF2, 0x0C, 0xFD, 0x0C, 0x77, 0x30, 0xEF, 0xF0, 0xE8, 0x09, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_computer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_computer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_connected_tv 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_hardware_connected_tv_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x62, 0xF3, 0x3F, 0x58, 0x47, 0x18, 0x90, 0x2F, 0x33, 0xF2, 0x49, 0xB1, 0x68, 0x90,
  0x2F, 0x33, 0xF5, 0xB4, 0x4C, 0x68, 0x91, 0x2F, 0x33, 0xF2, 0x3C, 0x68, 0x75, 0x89, 0x12, 0xF3,
  0x3F, 0x7C, 0x2D, 0x2C, 0x58, 0x91, 0x2F, 0x33, 0xF5, 0xB3, 0x71, 0x85, 0x82, 0x2F, 0x31, 0x98,
  0x09, 0x0D, 0x98, 0x51, 0x04, 0x77, 0x7D, 0xC8, 0x3D, 0x77, 0x74, 0x60, 0x9C, 0x09, 0x74, 0x80,
  0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_connected_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_connected_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_desktop_mac 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_hardware_desktop_mac_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x58, 0x06, 0x38, 0x25, 0xF3, 0x3F, 0xF0,
  0x03, 0xFF, 0x03, 0x01, 0xFF, 0x85, 0x10, 0x35, 0x55, 0x7C, 0x83, 0x75, 0x55, 0x36, 0x0B, 0xC0,
  0xC7, 0x38, 0x42, 0x33, 0x33, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_desktop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_desktop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_desktop_windows 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_hardware_desktop_windows_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38,
  0x22, 0xF3, 0x19, 0x80, 0x90, 0xD9, 0x86, 0x10, 0x47, 0x77, 0x7A, 0xA8, 0x4A, 0x77, 0x77, 0x47,
  0x06, 0xA0, 0x67, 0x40, 0x9C, 0x09, 0x74, 0x80, 0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_desktop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_desktop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_developer_board_off 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_18_hardware_developer_board_off_data[] PROGMEM = {
  0x05, 0x06, 0x28, 0x04, 0x30, 0x23, 0x83, 0x6F, 0x70, 0x9F, 0x90, 0x32, 0x03, 0xA0, 0x77, 0x10,
  0xE0, 0x62, 0x8A, 0x43, 0xF8, 0xF7, 0x01, 0x05, 0x93, 0x0E, 0xB8, 0x03, 0xF2, 0x9F, 0x72, 0x89,
  0x2D, 0xF9, 0x0E, 0xDA, 0x13, 0xF2, 0x7A, 0x82, 0x70, 0x13, 0x20, 0xE0, 0x62, 0x82, 0x3F, 0x24,
  0xB8, 0xB3, 0x70, 0x76, 0x0E, 0xB9, 0x03, 0xF2, 0x01, 0x16, 0xF7, 0x04, 0x0E, 0xB9, 0x03, 0xF2,
  0x5A, 0x82, 0xE6, 0xF7, 0x20, 0xE0, 0x62, 0x82, 0x3F, 0x27, 0xB0, 0x1A, 0x8A, 0x77, 0x09, 0xDA,
  0x13, 0xF2, 0x19, 0x96, 0x05, 0xAF, 0x70, 0x78, 0x03, 0xF2, 0x78, 0x16, 0xF7, 0x30, 0x10, 0xEF,
  0xC0, 0x73, 0x01, 0x80, 0x63, 0x81, 0x7F, 0x67, 0x70, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_developer_board_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_developer_board_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_developer_board 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_18_hardware_developer_board_data[] PROGMEM = {
  0x10, 0x18, 0x06, 0x30, 0x23, 0x01, 0x0E, 0xFC, 0x03, 0x28, 0x13, 0xF2, 0x72, 0x0E, 0x06, 0x28,
  0xA2, 0x3F, 0x21, 0x99, 0x60, 0x59, 0x30, 0xEB, 0x80, 0x3F, 0x27, 0xB8, 0x93, 0x1D, 0xF9, 0x0E,
  0xDA, 0x13, 0xF2, 0x7B, 0x81, 0x11, 0x32, 0x0E, 0x06, 0x28, 0x23, 0xF2, 0x4A, 0x89, 0x6D, 0x0A,
  0xD6, 0x0E, 0xB9, 0x03, 0xF2, 0x01, 0x12, 0xA8, 0x90, 0xA0, 0xEB, 0x90, 0x3F, 0x25, 0xA0, 0xE1,
  0xA8, 0x2A, 0x0E, 0x62, 0x82, 0x3F, 0x27, 0xB0, 0x1A, 0x8A, 0x7A, 0x0E, 0xDA, 0x13, 0xF2, 0x19,
  0x96, 0x05, 0x93, 0x0E, 0xB8, 0x03, 0xF2, 0x72, 0x0E, 0x06, 0x20, 0x10, 0xEF, 0xC0, 0x33, 0x01,
  0x80, 0x63, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_developer_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_developer_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_device_hub 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_hardware_device_hub_data[] PROGMEM = {
  0x60, 0x20, 0x37, 0x40, 0x9A, 0x0A, 0x72, 0x02, 0xC0, 0x27, 0x10, 0x2C, 0x02, 0x72, 0x08, 0xA0,
  0x87, 0x40, 0x0A, 0x75, 0x00, 0xA7, 0x40, 0x5A, 0x05, 0x72, 0x84, 0x3F, 0x99, 0xF3, 0x58, 0x33,
  0x35, 0xEA, 0x28, 0x5A, 0xE5, 0x33, 0x03, 0xB0, 0xB4, 0x0B, 0xB0, 0x30, 0x4B, 0x04, 0x40, 0x4B,
  0x04, 0x03, 0xB0, 0x34, 0x03, 0xB0, 0x31, 0x0F, 0x36, 0x0F, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_device_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_device_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_devices_other 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_hardware_devices_other_data[] PROGMEM = {
  0x10, 0x38, 0x07, 0x53, 0x01, 0xFD, 0x03, 0x28, 0x13, 0xF2, 0x76, 0x81, 0x3F, 0x27, 0x10, 0xF3,
  0x83, 0x20, 0x3F, 0x27, 0x0A, 0xC8, 0x21, 0x3F, 0x22, 0x89, 0x42, 0xDD, 0x50, 0xBA, 0x13, 0xF3,
  0x3F, 0x22, 0x05, 0xA8, 0x91, 0x80, 0xB9, 0x02, 0xF3, 0x3F, 0x22, 0x8B, 0x4E, 0xA8, 0xF2, 0xB9,
  0x02, 0xF3, 0x3F, 0x20, 0x1F, 0x52, 0xF4, 0xB9, 0x02, 0xF3, 0x3F, 0x22, 0x89, 0x2A, 0xFE, 0xD0,
  0xB9, 0x02, 0xF3, 0x1B, 0x00, 0x3A, 0x81, 0x60, 0xAC, 0x83, 0x20, 0x35, 0x52, 0x87, 0x55, 0x10,
  0x15, 0x55, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_devices_other() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_devices_other_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_device_unknown 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_hardware_device_unknown_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x28, 0x21, 0x78, 0x12, 0x82, 0xE6, 0x6E, 0x28, 0x2B, 0x99, 0xC2, 0x82, 0xE6,
  0x6E, 0x28, 0x21, 0x01, 0xE2, 0x82, 0xE6, 0x6E, 0x40, 0xB0, 0x72, 0x82, 0xE6, 0x6E, 0x30, 0x60,
  0xB3, 0x82, 0xE6, 0x6E, 0x30, 0x01, 0x38, 0x2E, 0x66, 0xE3, 0x07, 0x08, 0x38, 0x2E, 0x66, 0xE3,
  0x00, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x47, 0x90, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x2E, 0xF9,
  0x0E, 0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_device_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_hardware_device_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_dock 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_hardware_dock_data[] PROGMEM = {
  0x28, 0x02, 0x12, 0x03, 0x0E, 0xE8, 0x1E, 0x37, 0xF9, 0x00, 0x7F, 0x98, 0x17, 0x7E, 0x80, 0x27,
  0x82, 0xE7, 0x7D, 0x68, 0x2D, 0x77, 0xD6, 0x82, 0xD7, 0x7D, 0x68, 0x2D, 0x77, 0xD6, 0x82, 0xD7,
  0x7D, 0x68, 0x2D, 0x77, 0xD8, 0x02, 0x38, 0x1D, 0x77, 0xF9, 0x00, 0x7F, 0x90, 0x70, 0x5F, 0x98,
  0x15, 0x04, 0x80, 0x25, 0x04, 0x38, 0x41, 0x33, 0x33, 0x14, 0x09, 0xC0, 0x95, 0x80, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_dock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 13, 17), Box(0, 0, 17, 17),
      ic_round_18_hardware_dock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_earbuds_battery 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_hardware_earbuds_battery_data[] PROGMEM = {
  0x10, 0x40, 0x63, 0x81, 0x56, 0x23, 0x06, 0x05, 0x20, 0x1A, 0x89, 0x46, 0x0B, 0xFE, 0xE3, 0x08,
  0xFE, 0x70, 0x3A, 0x86, 0x43, 0xF3, 0x0B, 0xA4, 0xC8, 0x42, 0x3F, 0x30, 0x59, 0x28, 0x18, 0xC4,
  0xC8, 0x43, 0x3F, 0x20, 0x59, 0x28, 0x18, 0xC4, 0xC8, 0x43, 0x3F, 0x20, 0x59, 0x28, 0x18, 0xC4,
  0xC8, 0x43, 0x3F, 0x20, 0x59, 0x28, 0x19, 0xC4, 0xC8, 0x92, 0x31, 0xF5, 0x09, 0xD0, 0xAF, 0xC4,
  0xC8, 0x92, 0x30, 0x8F, 0xDF, 0x50, 0xCF, 0xA4, 0xC0, 0x22, 0x81, 0x47, 0x32, 0x86, 0x27, 0x10,
  0x67, 0x76, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_earbuds_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_earbuds_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_earbuds 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_hardware_earbuds_data[] PROGMEM = {
  0x20, 0x30, 0x25, 0x03, 0x02, 0x40, 0x9A, 0x08, 0x20, 0x50, 0xEA, 0x82, 0xC2, 0x02, 0xC8, 0x90,
  0x13, 0xF8, 0x13, 0xCC, 0x04, 0xC8, 0x11, 0x8C, 0x38, 0x23, 0xF2, 0x4B, 0x82, 0x70, 0xAA, 0x38,
  0x51, 0xF4, 0x4F, 0x21, 0x20, 0x0A, 0x38, 0x21, 0xF4, 0x49, 0x40, 0x0A, 0x38, 0x21, 0xF4, 0x49,
  0x40, 0x0A, 0x38, 0x21, 0xF4, 0x49, 0x40, 0x0A, 0x28, 0x51, 0x2F, 0x44, 0xF1, 0x38, 0x2A, 0xA0,
  0x7B, 0x82, 0x42, 0xF3, 0x38, 0x1D, 0x81, 0xC8, 0x90, 0x40, 0xCC, 0x32, 0x8F, 0x21, 0xC8, 0x22,
  0x02, 0xCA, 0x0E, 0x05, 0x20, 0x9A, 0x09, 0x40, 0x20, 0x35, 0x00, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_earbuds() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_earbuds_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_gamepad 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_hardware_gamepad_data[] PROGMEM = {
  0x68, 0x22, 0x33, 0x27, 0x40, 0x2C, 0x02, 0x73, 0x03, 0xC0, 0x37, 0x30, 0x3C, 0x03, 0x73, 0x03,
  0xC0, 0x36, 0x84, 0x23, 0x33, 0x09, 0xA8, 0x69, 0x03, 0x33, 0x20, 0x1C, 0x84, 0x90, 0x77, 0x09,
  0xC0, 0x10, 0x3D, 0x07, 0x20, 0x7D, 0x00, 0x3D, 0x07, 0x20, 0x7D, 0x03, 0x01, 0xC8, 0x49, 0x07,
  0x70, 0x9C, 0x86, 0x10, 0x23, 0x33, 0x09, 0xA8, 0x49, 0x02, 0x33, 0x26, 0x03, 0xC0, 0x37, 0x30,
  0x3C, 0x03, 0x73, 0x03, 0xC0, 0x37, 0x30, 0x2C, 0x02, 0x74, 0x82, 0x23, 0x32, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_gamepad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_gamepad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_headphones_battery 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_hardware_headphones_battery_data[] PROGMEM = {
  0x38, 0x22, 0x56, 0x25, 0x04, 0x03, 0x48, 0x48, 0xFE, 0xEF, 0xA3, 0x82, 0x8D, 0xD7, 0x28, 0x17,
  0xF5, 0x28, 0x34, 0xE9, 0x04, 0xC8, 0x22, 0x0E, 0x74, 0x82, 0x5F, 0x14, 0xC8, 0x23, 0x2F, 0x34,
  0x82, 0x1F, 0x44, 0xC8, 0x23, 0x3F, 0x25, 0x90, 0x50, 0x4C, 0x83, 0x33, 0xFE, 0x32, 0x83, 0x1E,
  0xF5, 0x4C, 0x00, 0x3A, 0x07, 0x20, 0x5A, 0x05, 0x04, 0xC0, 0x30, 0x1A, 0x06, 0x20, 0x3A, 0x03,
  0x04, 0xC8, 0x22, 0x04, 0x64, 0x00, 0x52, 0x82, 0x67, 0x76, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_headphones_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_headphones_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_headphones 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_hardware_headphones_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x58, 0x90, 0x5F, 0xB4, 0x11, 0x4B, 0xF5,
  0x38, 0x13, 0xF8, 0x68, 0x18, 0xF3, 0x20, 0x0B, 0x71, 0x84, 0xBB, 0x01, 0xF4, 0x71, 0x84, 0x4F,
  0x13, 0xF1, 0x71, 0x85, 0x1F, 0x34, 0xF2, 0x16, 0x83, 0x12, 0xF4, 0x4B, 0x0D, 0x40, 0xDB, 0x00,
  0x4C, 0x03, 0x20, 0x3C, 0x00, 0x4C, 0x03, 0x20, 0x3C, 0x00, 0x4C, 0x03, 0x20, 0x3C, 0x04, 0x02,
  0xB0, 0xE0, 0x12, 0x01, 0x0E, 0xB8, 0x42, 0x02, 0x33, 0x14, 0x82, 0x13, 0x32, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_headphones() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_headphones_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_headset_mic 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_hardware_headset_mic_data[] PROGMEM = {
  0x60, 0x02, 0x72, 0x81, 0x2A, 0xEA, 0x81, 0xEA, 0x25, 0x89, 0x04, 0xED, 0x63, 0x36, 0xDE, 0x43,
  0x81, 0x2E, 0x96, 0x81, 0x9E, 0x22, 0x0B, 0x0C, 0x71, 0x84, 0xCB, 0x01, 0xF5, 0x71, 0x84, 0x5F,
  0x13, 0xF1, 0x71, 0x82, 0x1F, 0x34, 0x97, 0x39, 0x00, 0x4B, 0x0B, 0x40, 0xBB, 0x00, 0x4C, 0x02,
  0x20, 0x2C, 0x00, 0x4C, 0x03, 0x20, 0x3C, 0x00, 0x4C, 0x03, 0x20, 0x3C, 0x04, 0x02, 0xC0, 0x12,
  0x01, 0xC8, 0x44, 0x03, 0x55, 0x34, 0x83, 0x35, 0x6F, 0x47, 0x85, 0x8B, 0xBB, 0xBF, 0x37, 0x84,
  0x79, 0x99, 0x97, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_headset_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_headset_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_headset_off 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_18_hardware_headset_off_data[] PROGMEM = {
  0x70, 0x02, 0x60, 0x50, 0x62, 0x81, 0x2A, 0xEA, 0x81, 0xEA, 0x23, 0x89, 0x35, 0xF7, 0x08, 0xD6,
  0x33, 0x6D, 0xE4, 0x38, 0x16, 0xF7, 0x78, 0x19, 0xE2, 0x38, 0x1B, 0xF7, 0x70, 0xC0, 0xB2, 0x83,
  0x1F, 0xAF, 0x76, 0x89, 0x05, 0xF1, 0x03, 0xF1, 0x6F, 0x75, 0x83, 0x1F, 0x30, 0x49, 0x28, 0x16,
  0xF7, 0x59, 0x81, 0x40, 0x4B, 0x84, 0xB6, 0xF7, 0x06, 0xB8, 0x14, 0x04, 0xC8, 0x42, 0x6F, 0x70,
  0x9A, 0x81, 0x40, 0x4C, 0x89, 0x13, 0x06, 0xF7, 0x09, 0xF4, 0x04, 0xC0, 0x32, 0x86, 0x6F, 0x70,
  0x94, 0x02, 0xC0, 0x12, 0x01, 0xA8, 0x17, 0x01, 0x28, 0x23, 0x55, 0x34, 0x82, 0x37, 0xF7, 0x72,
  0x85, 0x8B, 0xBB, 0xEF, 0x67, 0x18, 0x57, 0x99, 0x99, 0x85,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_headset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_headset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_headset 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_hardware_headset_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x58, 0x90, 0x5F, 0xB4, 0x11, 0x4B, 0xF5,
  0x38, 0x13, 0xF8, 0x68, 0x18, 0xF3, 0x20, 0x0B, 0x71, 0x84, 0xBB, 0x01, 0xF4, 0x71, 0x84, 0x4F,
  0x13, 0xF1, 0x71, 0x85, 0x1F, 0x34, 0xF2, 0x16, 0x83, 0x12, 0xF4, 0x4B, 0x0D, 0x40, 0xDB, 0x00,
  0x4C, 0x03, 0x20, 0x3C, 0x00, 0x4C, 0x03, 0x20, 0x3C, 0x00, 0x4C, 0x03, 0x20, 0x3C, 0x04, 0x02,
  0xB0, 0xE0, 0x12, 0x01, 0x0E, 0xB8, 0x42, 0x02, 0x33, 0x14, 0x82, 0x13, 0x32, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_headset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_headset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_home_max 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_hardware_home_max_data[] PROGMEM = {
  0x20, 0x28, 0x09, 0x05, 0x02, 0x30, 0x5F, 0xF0, 0x52, 0x0E, 0x09, 0x75, 0x84, 0x9E, 0x01, 0xF4,
  0x75, 0x84, 0x4F, 0x11, 0xF3, 0x75, 0x84, 0x3F, 0x11, 0xF3, 0x75, 0x84, 0x3F, 0x11, 0xF3, 0x75,
  0x84, 0x3F, 0x11, 0xF3, 0x75, 0x84, 0x3F, 0x10, 0xE8, 0x75, 0x08, 0x0E, 0x20, 0x69, 0x80, 0x90,
  0xD9, 0x06, 0x38, 0x23, 0x77, 0xCE, 0x82, 0xC7, 0x73, 0x70, 0x28, 0x02, 0x50, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_home_max() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_home_max_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_home_mini 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_hardware_home_mini_data[] PROGMEM = {
  0x58, 0x41, 0x45, 0x54, 0x17, 0x10, 0x40, 0xCE, 0x0C, 0x05, 0x58, 0x39, 0xFA, 0x41, 0x28, 0x31,
  0x4A, 0xF8, 0x38, 0x16, 0xF5, 0x71, 0x81, 0x5F, 0x62, 0x0D, 0x09, 0x73, 0x84, 0x8D, 0x02, 0xF4,
  0x73, 0x82, 0x3F, 0x22, 0xFF, 0x82, 0x20, 0xEB, 0x80, 0x65, 0x0A, 0x92, 0x81, 0x9E, 0x17, 0x20,
  0xD0, 0x92, 0x82, 0x1D, 0xD4, 0x68, 0x24, 0xDD, 0x13, 0x01, 0x0B, 0xF9, 0x0B, 0x01, 0x60, 0x28,
  0x02, 0x50, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_home_mini() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_home_mini_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_alt 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_hardware_keyboard_alt_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x23, 0x01, 0x20, 0xDF, 0xF8, 0x1D, 0x01, 0xFF, 0xA0, 0x01, 0xB8, 0x90, 0xEE,
  0xFD, 0xEE, 0xDF, 0xEE, 0xB0, 0x01, 0xB8, 0x90, 0x45, 0xF0, 0xAA, 0x0F, 0x54, 0xB0, 0x01, 0xB8,
  0x90, 0xCD, 0xFB, 0xEE, 0xBF, 0xDC, 0xB0, 0x01, 0xB8, 0x90, 0x9A, 0xF7, 0xCC, 0x7F, 0xA9, 0xB0,
  0x01, 0xB8, 0x90, 0x57, 0xF1, 0xBB, 0x1F, 0x75, 0xB0, 0x01, 0xFF, 0xA0, 0x01, 0xD8, 0x48, 0x33,
  0x33, 0x8D, 0x00, 0x1D, 0x84, 0xED, 0xDD, 0xDE, 0xD0, 0x01, 0xFF, 0xA8, 0x11, 0x0D, 0xFF, 0x0D,
  0x20, 0x18, 0x09, 0x23, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_arrow_down 18x18, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_round_18_hardware_keyboard_arrow_down_data[] PROGMEM = {
  0x10, 0x56, 0x83, 0x50, 0x1E, 0xA4, 0x85, 0xAE, 0x10, 0x3E, 0xA2, 0x81, 0xAE, 0x33, 0x84, 0x3E,
  0xAA, 0xE3, 0x58, 0x23, 0xEE, 0x37, 0x00, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 13, 11), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_arrow_left 18x18, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_round_18_hardware_keyboard_arrow_left_data[] PROGMEM = {
  0x40, 0x14, 0x81, 0x3E, 0x52, 0x81, 0x3E, 0xA2, 0x81, 0x3E, 0xA2, 0x81, 0x1E, 0xA3, 0x81, 0x1E,
  0xA4, 0x81, 0x3E, 0xA4, 0x81, 0x3E, 0xA4, 0x81, 0x3E, 0x54, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 11, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_arrow_right 18x18, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_round_18_hardware_keyboard_arrow_right_data[] PROGMEM = {
  0x10, 0x14, 0x81, 0x5E, 0x34, 0x81, 0xAE, 0x34, 0x81, 0xAE, 0x34, 0x81, 0xAE, 0x13, 0x81, 0xAE,
  0x12, 0x81, 0xAE, 0x32, 0x81, 0xAE, 0x32, 0x81, 0x5E, 0x34, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 11, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_arrow_up 18x18, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_round_18_hardware_keyboard_arrow_up_data[] PROGMEM = {
  0x40, 0x01, 0x78, 0x23, 0xEE, 0x35, 0x84, 0x3E, 0xAA, 0xE3, 0x38, 0x13, 0xEA, 0x28, 0x5A, 0xE3,
  0x01, 0xEA, 0x48, 0x3A, 0xE1, 0x05, 0x60, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 13, 11), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_backspace 18x18, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_round_18_hardware_keyboard_backspace_data[] PROGMEM = {
  0x30, 0x80, 0x17, 0x38, 0x1B, 0xE1, 0x72, 0x81, 0xBE, 0x27, 0x28, 0x1A, 0xFC, 0x80, 0x59, 0x82,
  0x1A, 0xFC, 0x80, 0x59, 0x83, 0x10, 0xBE, 0x27, 0x48, 0x1B, 0xE1, 0x74, 0x08, 0x01, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_backspace() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_backspace_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_capslock 18x18, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_round_18_hardware_keyboard_capslock_data[] PROGMEM = {
  0x28, 0x22, 0xEE, 0x23, 0x89, 0x02, 0xEB, 0xBE, 0x20, 0x1E, 0xB2, 0x83, 0xBE, 0x11, 0x84, 0x08,
  0x01, 0x71, 0x04, 0x80, 0x2B, 0x04, 0x03, 0x80, 0x29, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_capslock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 12, 12), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_capslock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_command_key 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_18_hardware_keyboard_command_key_data[] PROGMEM = {
  0x20, 0x20, 0x36, 0x03, 0x02, 0x30, 0x8A, 0x0C, 0x01, 0x20, 0x10, 0xCA, 0x86, 0x80, 0x2F, 0x62,
  0xD7, 0x28, 0x92, 0x7D, 0x26, 0xF2, 0x3F, 0x20, 0xA9, 0x28, 0xA1, 0x9A, 0x02, 0xF3, 0x0C, 0xDB,
  0xEE, 0xBB, 0xEE, 0xBD, 0xC2, 0x89, 0x21, 0x79, 0xDD, 0x99, 0xDD, 0x97, 0x15, 0x00, 0xA2, 0x00,
  0xA7, 0x10, 0x0A, 0x20, 0x0A, 0x58, 0x92, 0x17, 0x9D, 0xD9, 0x9D, 0xD9, 0x71, 0x28, 0xA1, 0xCD,
  0xBE, 0xEB, 0xBE, 0xEB, 0xDC, 0x03, 0xF2, 0x0A, 0x92, 0x89, 0x29, 0xA0, 0x2F, 0x32, 0xF6, 0x2D,
  0x72, 0x86, 0x7D, 0x26, 0xF2, 0x08, 0xA0, 0xC0, 0x12, 0x01, 0x0C, 0xA0, 0x83, 0x02, 0x03, 0x60,
  0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_command_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_command_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_control_key 18x18, 4-bit Alpha,  RLE, 23 bytes.
static const unsigned char ic_round_18_hardware_keyboard_control_key_data[] PROGMEM = {
  0x30, 0x01, 0x58, 0x22, 0xDD, 0x13, 0x8A, 0x01, 0xDC, 0xCD, 0x10, 0x1D, 0xC1, 0x1C, 0xD1, 0xDC,
  0x12, 0x83, 0x1C, 0xD8, 0x14, 0x01, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_control_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 12, 9), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_control_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_double_arrow_down 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_18_hardware_keyboard_double_arrow_down_data[] PROGMEM = {
  0x81, 0x2E, 0x44, 0x85, 0x5E, 0x10, 0x9F, 0x42, 0x81, 0x5F, 0x83, 0x84, 0x9F, 0x45, 0xF8, 0x50,
  0x9A, 0x08, 0x70, 0x70, 0x64, 0x81, 0x19, 0x14, 0x85, 0x29, 0x01, 0xDC, 0x12, 0x81, 0x2D, 0xC2,
  0x86, 0x1D, 0xC1, 0x2D, 0xC1, 0x38, 0x41, 0xDC, 0xDC, 0x15, 0x82, 0x1D, 0xC1, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_double_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_double_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_double_arrow_left 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_hardware_keyboard_double_arrow_left_data[] PROGMEM = {
  0x72, 0x01, 0x28, 0x11, 0xD9, 0x38, 0x59, 0xE0, 0x1D, 0xC1, 0x28, 0x59, 0xF4, 0x1D, 0xC1, 0x28,
  0x59, 0xF4, 0x0D, 0xC1, 0x28, 0x18, 0xF4, 0x28, 0x1D, 0xC1, 0x28, 0x18, 0xF4, 0x28, 0x21, 0xDC,
  0x12, 0x81, 0x9F, 0x42, 0x82, 0x1D, 0xC1, 0x28, 0x19, 0xF4, 0x28, 0x11, 0xD9, 0x30, 0x90, 0xE7,
  0x20, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_double_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_double_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_double_arrow_right 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_hardware_keyboard_double_arrow_right_data[] PROGMEM = {
  0x01, 0x40, 0x14, 0x90, 0x83, 0x81, 0xAC, 0x12, 0x81, 0x5F, 0x82, 0x82, 0x2D, 0xC1, 0x28, 0x15,
  0xF8, 0x28, 0x22, 0xDC, 0x12, 0x81, 0x5F, 0x62, 0x81, 0x2D, 0xB2, 0x81, 0x5F, 0x62, 0x85, 0x2D,
  0xC0, 0x5F, 0x82, 0x85, 0x2D, 0xC1, 0x5F, 0x82, 0x85, 0x2D, 0xC1, 0x0F, 0x83, 0x81, 0xAC, 0x12,
  0x01, 0x40, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_double_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_double_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_double_arrow_up 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_hardware_keyboard_double_arrow_up_data[] PROGMEM = {
  0x38, 0x21, 0xDC, 0x15, 0x84, 0x1D, 0xCD, 0xC1, 0x38, 0x93, 0x1D, 0xC1, 0x2D, 0xC1, 0x01, 0xDC,
  0x12, 0x85, 0x2D, 0xC0, 0x19, 0x14, 0x02, 0x09, 0x50, 0x07, 0x70, 0x9A, 0x08, 0x58, 0x49, 0xF4,
  0x5F, 0x83, 0x81, 0x9F, 0x42, 0x85, 0x5F, 0x80, 0x2E, 0x44, 0x81, 0x5E, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_double_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_double_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_hide 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_hardware_keyboard_hide_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x81, 0xE1, 0x3A, 0x89, 0x0B, 0x8A, 0x9A, 0xA9,
  0xA8, 0xBA, 0x00, 0x3A, 0x89, 0x08, 0x37, 0x56, 0x65, 0x73, 0x8A, 0x00, 0x3A, 0x89, 0x09, 0x58,
  0x67, 0x76, 0x85, 0x9A, 0x00, 0x3A, 0x89, 0x0A, 0x79, 0x88, 0x88, 0x97, 0xAA, 0x00, 0x3C, 0x84,
  0xC7, 0x77, 0x7C, 0xC0, 0x03, 0xC8, 0x47, 0x11, 0x11, 0x7C, 0x03, 0x02, 0xFF, 0x81, 0x20, 0x78,
  0x09, 0x0B, 0x07, 0x77, 0x72, 0x80, 0x07, 0x75, 0x0A, 0xA0, 0xA7, 0x60, 0x0A, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_hide() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_hide_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_option_key 18x18, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_18_hardware_keyboard_option_key_data[] PROGMEM = {
  0x18, 0x00, 0x70, 0x13, 0x80, 0x07, 0x18, 0x42, 0xDD, 0xDE, 0xB2, 0x84, 0x1C, 0xDD, 0xD2, 0x48,
  0x13, 0xF5, 0x75, 0x09, 0x0D, 0x75, 0x81, 0x1E, 0x77, 0x58, 0x17, 0xE1, 0x75, 0x0D, 0x0A, 0x75,
  0x81, 0x5F, 0x37, 0x58, 0x4B, 0xED, 0xDD, 0x27, 0x10, 0x18, 0x00, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_option_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_option_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_hardware_keyboard_data[] PROGMEM = {
  0x10, 0x48, 0x09, 0x07, 0x81, 0x40, 0x1F, 0xF0, 0x10, 0x3A, 0x89, 0x09, 0x58, 0x67, 0x76, 0x85,
  0x9A, 0x00, 0x3A, 0x89, 0x0A, 0x79, 0x88, 0x88, 0x97, 0xAA, 0x00, 0x3A, 0x89, 0x08, 0x37, 0x56,
  0x65, 0x73, 0x8A, 0x00, 0x3A, 0x89, 0x0B, 0x8A, 0x9A, 0xA9, 0xA8, 0xBA, 0x00, 0x3C, 0x84, 0xA5,
  0x55, 0x5A, 0xC0, 0x03, 0xC8, 0x49, 0x33, 0x33, 0x9C, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x48, 0x09,
  0x07, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_return 18x18, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_round_18_hardware_keyboard_return_data[] PROGMEM = {
  0x30, 0x80, 0x17, 0x28, 0x1B, 0xE1, 0x58, 0x47, 0x20, 0xBE, 0x26, 0x83, 0xE6, 0xAF, 0xC8, 0x03,
  0x99, 0x82, 0x6A, 0xFC, 0x80, 0x49, 0x83, 0x10, 0xBE, 0x27, 0x38, 0x1B, 0xE1, 0x73, 0x08, 0x01,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_return() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 14, 12), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_return_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_tab 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_hardware_keyboard_tab_data[] PROGMEM = {
  0x76, 0x06, 0x71, 0x08, 0x02, 0x38, 0x12, 0xF3, 0x78, 0x1C, 0xD2, 0x28, 0x12, 0xF3, 0x78, 0x61,
  0xCD, 0x20, 0x2F, 0x38, 0x04, 0x98, 0x5B, 0xFD, 0x02, 0xF3, 0x80, 0x49, 0x85, 0xAF, 0xD0, 0x2F,
  0x37, 0x86, 0x1C, 0xD1, 0x02, 0xF3, 0x78, 0x1C, 0xD1, 0x28, 0x12, 0xF3, 0x70, 0x80, 0x13, 0x81,
  0x2F, 0x37, 0x60, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_tab() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_tab_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_keyboard_voice 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_hardware_keyboard_voice_data[] PROGMEM = {
  0x40, 0x01, 0x70, 0x8A, 0x08, 0x50, 0x2C, 0x02, 0x40, 0x3C, 0x03, 0x40, 0x3C, 0x03, 0x40, 0x3C,
  0x03, 0x40, 0x3C, 0x03, 0x28, 0x14, 0x13, 0xC8, 0x53, 0x14, 0xC9, 0x0E, 0xA8, 0xA0, 0xE0, 0x9C,
  0x7E, 0x13, 0xAA, 0x31, 0xE7, 0x0D, 0xD3, 0x28, 0x13, 0xDD, 0x28, 0x61, 0xBF, 0xEE, 0xFB, 0x14,
  0x82, 0x3C, 0xC3, 0x70, 0x09, 0x71, 0x00, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_keyboard_voice() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_keyboard_voice_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_laptop_chromebook 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_hardware_laptop_chromebook_data[] PROGMEM = {
  0x20, 0x18, 0x09, 0x03, 0x01, 0x30, 0x10, 0xEF, 0xD0, 0xE0, 0x12, 0x81, 0x3F, 0x27, 0x38, 0x12,
  0xF3, 0x28, 0x13, 0xF2, 0x73, 0x81, 0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13,
  0xF2, 0x73, 0x81, 0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13, 0xF2, 0x73, 0x81,
  0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13, 0xF5, 0x80, 0x63, 0x81, 0x5F, 0x32,
  0x03, 0xD8, 0x2B, 0x99, 0xBD, 0x03, 0x20, 0x3D, 0x82, 0xA7, 0x7A, 0xD8, 0x13, 0x0D, 0xFF, 0xA0,
  0xD0, 0x28, 0x09, 0x43, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_laptop_chromebook() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_laptop_chromebook_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_laptop_mac 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_hardware_laptop_mac_data[] PROGMEM = {
  0x20, 0x18, 0x09, 0x03, 0x01, 0x30, 0x10, 0xEF, 0xD0, 0xE0, 0x12, 0x81, 0x3F, 0x27, 0x38, 0x12,
  0xF3, 0x28, 0x13, 0xF2, 0x73, 0x81, 0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13,
  0xF2, 0x73, 0x81, 0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13, 0xF2, 0x73, 0x81,
  0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13, 0xF2, 0x73, 0x81, 0x2F, 0x32, 0x81,
  0x2F, 0x78, 0x06, 0x58, 0x17, 0xF2, 0x30, 0xBD, 0x00, 0x9D, 0x0B, 0x20, 0xCF, 0x00, 0xBF, 0x0C,
  0x01, 0x80, 0x94, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_laptop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_laptop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_laptop 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_hardware_laptop_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x2F, 0x58, 0x06,
  0x38, 0x35, 0xF2, 0x0C, 0xFD, 0x0C, 0x77, 0x30, 0xEF, 0xF0, 0xE8, 0x09, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_laptop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_laptop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_laptop_windows 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_hardware_laptop_windows_data[] PROGMEM = {
  0x20, 0x18, 0x09, 0x03, 0x01, 0x30, 0x10, 0xEF, 0xD0, 0xE0, 0x12, 0x81, 0x3F, 0x27, 0x38, 0x12,
  0xF3, 0x28, 0x13, 0xF2, 0x73, 0x81, 0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13,
  0xF2, 0x73, 0x81, 0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13, 0xF2, 0x73, 0x81,
  0x2F, 0x32, 0x81, 0x3F, 0x27, 0x38, 0x12, 0xF3, 0x28, 0x13, 0xF2, 0x73, 0x81, 0x2F, 0x32, 0x01,
  0x98, 0x09, 0x0D, 0x90, 0x13, 0x04, 0x0A, 0xFB, 0x0A, 0x04, 0x20, 0xDF, 0xFA, 0x0D, 0x02, 0x80,
  0x94, 0x30, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_laptop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_laptop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_memory 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_hardware_memory_data[] PROGMEM = {
  0x50, 0x22, 0x02, 0x72, 0x84, 0x3F, 0x11, 0xF3, 0x78, 0x66, 0x9F, 0x88, 0xF9, 0x65, 0x06, 0x98,
  0x02, 0xD9, 0x06, 0x38, 0x13, 0x9D, 0x68, 0x3D, 0x93, 0x02, 0xA8, 0x6D, 0x06, 0xBB, 0x60, 0xDA,
  0x89, 0x42, 0x01, 0x8D, 0x0C, 0xBB, 0xC0, 0xD8, 0x12, 0x89, 0x41, 0x8D, 0x0C, 0xBB, 0xC0, 0xD8,
  0x10, 0x2A, 0x86, 0xD0, 0x6B, 0xB6, 0x0D, 0xA8, 0x32, 0x03, 0x9D, 0x68, 0x1D, 0x93, 0x30, 0x69,
  0x80, 0x2D, 0x90, 0x65, 0x86, 0x69, 0xF8, 0x8F, 0x96, 0x78, 0x43, 0xF1, 0x1F, 0x37, 0x20, 0x22,
  0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_memory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_memory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_monitor 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_hardware_monitor_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38,
  0x22, 0xF3, 0x19, 0x80, 0x90, 0xD9, 0x85, 0x10, 0x47, 0x77, 0xEC, 0x83, 0xE7, 0x77, 0x45, 0x02,
  0xE0, 0x27, 0x28, 0x02, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_mouse 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_hardware_mouse_data[] PROGMEM = {
  0x38, 0x48, 0xD5, 0x5D, 0x85, 0x0C, 0xA0, 0x05, 0xA0, 0xC3, 0x09, 0xB0, 0x05, 0xB0, 0x92, 0xC0,
  0x05, 0xC1, 0x89, 0x23, 0xBB, 0xBB, 0x33, 0xBB, 0xBB, 0x37, 0x50, 0x58, 0x06, 0xD0, 0x50, 0x6F,
  0xB0, 0x06, 0xFB, 0x06, 0x05, 0xFB, 0x05, 0x01, 0xFB, 0x81, 0x10, 0x9F, 0x90, 0x92, 0x01, 0x0C,
  0xE0, 0xC0, 0x14, 0x08, 0x0E, 0xA0, 0xE0, 0x87, 0x10, 0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_mouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_mouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_phone_android 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_hardware_phone_android_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x6F,
  0xB0, 0x06, 0xFB, 0x00, 0x6B, 0x82, 0xC1, 0x1C, 0xB0, 0x06, 0xFB, 0x81, 0x62, 0xEF, 0x90, 0xE0,
  0x22, 0x80, 0x41, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_phone_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_hardware_phone_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_phone_iphone 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_hardware_phone_iphone_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x6F,
  0xB0, 0x06, 0xC0, 0x0E, 0xC0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xFB, 0x81, 0x62, 0xEF, 0x90, 0xE0,
  0x22, 0x80, 0x41, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_phone_iphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_hardware_phone_iphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_phonelink_off 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_hardware_phonelink_off_data[] PROGMEM = {
  0x18, 0x2E, 0x70, 0x18, 0x05, 0x53, 0x83, 0x6F, 0x70, 0x9F, 0x0E, 0x02, 0x38, 0x18, 0xF7, 0x76,
  0x06, 0xA0, 0x74, 0x83, 0x9B, 0xBB, 0x93, 0x83, 0x6E, 0x6F, 0x72, 0x85, 0x3F, 0xA9, 0xAF, 0x32,
  0x89, 0x46, 0xE0, 0x6F, 0x70, 0x3F, 0x20, 0x2F, 0x32, 0x06, 0x0E, 0x28, 0x90, 0x6F, 0x70, 0x92,
  0x02, 0xF3, 0x20, 0x60, 0xE3, 0x81, 0x6F, 0x73, 0x81, 0x2F, 0x32, 0x06, 0x0E, 0x48, 0x16, 0xF7,
  0x28, 0xA2, 0x2F, 0x30, 0x49, 0xF5, 0x55, 0x30, 0x6F, 0x70, 0x2F, 0x31, 0xE8, 0x1D, 0x02, 0xA8,
  0x47, 0x09, 0x20, 0x48, 0x01, 0x50, 0x32, 0x82, 0x47, 0xF7, 0x77, 0x06, 0x0E, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_phonelink_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_phonelink_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_phonelink 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_hardware_phonelink_data[] PROGMEM = {
  0x30, 0x48, 0x06, 0x54, 0x04, 0xFB, 0x0E, 0x02, 0x30, 0x60, 0xE7, 0x70, 0x60, 0xE6, 0x83, 0x9B,
  0xBB, 0x93, 0x06, 0x0E, 0x58, 0x53, 0xFA, 0x9A, 0xF3, 0x20, 0x60, 0xE5, 0x85, 0x3F, 0x20, 0x2F,
  0x32, 0x06, 0x0E, 0x58, 0x53, 0xF2, 0x02, 0xF3, 0x20, 0x60, 0xE5, 0x85, 0x3F, 0x20, 0x2F, 0x32,
  0x06, 0x0E, 0x58, 0xA6, 0x3F, 0x20, 0x2F, 0x30, 0x49, 0xF5, 0x55, 0x30, 0x3F, 0x75, 0x7F, 0x31,
  0xE8, 0x1D, 0x02, 0xD8, 0x12, 0x04, 0x80, 0x15, 0x03, 0x28, 0x34, 0x55, 0x54, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_phonelink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_phonelink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_point_of_sale 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_hardware_point_of_sale_data[] PROGMEM = {
  0x38, 0x04, 0x35, 0x06, 0x0C, 0x80, 0x29, 0x0C, 0x06, 0x40, 0x60, 0xB8, 0x02, 0x70, 0xB0, 0x65,
  0x80, 0x45, 0x60, 0x68, 0x02, 0xB0, 0x65, 0x89, 0x01, 0xF5, 0xB8, 0x8B, 0x5F, 0x14, 0x89, 0x08,
  0xFE, 0xFE, 0xEF, 0xEF, 0x84, 0x89, 0x0E, 0xF4, 0xB7, 0x7B, 0x4F, 0xE3, 0x06, 0xA8, 0x4C, 0xED,
  0xDE, 0xCA, 0x06, 0x20, 0xCA, 0x84, 0x6C, 0x99, 0xC6, 0xA8, 0x1C, 0x01, 0x80, 0x90, 0x90, 0x10,
  0x28, 0x09, 0x07, 0x02, 0x03, 0xFD, 0x03, 0x18, 0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_point_of_sale() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_point_of_sale_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_power_input 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_round_18_hardware_power_input_data[] PROGMEM = {
  0x02, 0x80, 0x90, 0xB0, 0x20, 0x18, 0x09, 0x07, 0x82, 0x10, 0x11, 0x30, 0x01, 0x38, 0x21, 0x10,
  0x2A, 0x81, 0xD0, 0x8A, 0x81, 0x80, 0xDA, 0x89, 0x42, 0x03, 0x32, 0x01, 0x33, 0x10, 0x23, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_power_input() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 15, 11), Box(0, 0, 17, 17),
      ic_round_18_hardware_power_input_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_router 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_hardware_router_data[] PROGMEM = {
  0x72, 0x02, 0x01, 0x72, 0x01, 0x09, 0xB0, 0xE0, 0x87, 0x86, 0x7D, 0x63, 0x37, 0xE5, 0x71, 0x81,
  0x16, 0x57, 0x48, 0x28, 0xEE, 0x57, 0x77, 0x40, 0x70, 0x57, 0x50, 0xB0, 0x95, 0x80, 0x31, 0x81,
  0xCA, 0x12, 0x01, 0x0D, 0xFB, 0x81, 0xD1, 0x4F, 0xD0, 0x04, 0xA8, 0x51, 0xC8, 0x5F, 0x0D, 0xB0,
  0x04, 0xA8, 0x4D, 0xFE, 0xDF, 0xCC, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_router() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_router_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_scanner 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_hardware_scanner_data[] PROGMEM = {
  0x10, 0x10, 0x27, 0x58, 0x39, 0xFB, 0x61, 0x73, 0x84, 0x4A, 0xEF, 0xA5, 0x74, 0x84, 0x5B, 0xFE,
  0x93, 0x73, 0x87, 0x17, 0xCF, 0xD7, 0x01, 0xCF, 0xC0, 0x30, 0x4F, 0xD0, 0x04, 0xA8, 0x12, 0xCC,
  0x40, 0x1A, 0x00, 0x4A, 0x86, 0xBF, 0xEA, 0x99, 0x9B, 0xA0, 0x40, 0x2F, 0xD8, 0x12, 0x03, 0x80,
  0x65, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_security 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_hardware_security_data[] PROGMEM = {
  0x38, 0x43, 0x9E, 0xE9, 0x34, 0x83, 0x7D, 0xFC, 0x6B, 0x85, 0xD7, 0x0A, 0xE9, 0x32, 0xD8, 0x1A,
  0xD7, 0x4D, 0x81, 0xDD, 0x74, 0xD8, 0x1D, 0xD7, 0x4D, 0x81, 0xDC, 0x84, 0xD0, 0xC0, 0xBD, 0x48,
  0x1A, 0xB8, 0xD4, 0x81, 0xE8, 0x2D, 0x38, 0x35, 0xF2, 0x0A, 0xC2, 0x81, 0x1D, 0xA2, 0x01, 0x0E,
  0xB1, 0x82, 0x1C, 0xE1, 0x30, 0x20, 0xDA, 0x82, 0x7E, 0xD2, 0x50, 0x10, 0x9A, 0x09, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_security() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_security_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_sim_card 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_hardware_sim_card_data[] PROGMEM = {
  0x40, 0x28, 0x01, 0x30, 0x14, 0x07, 0xF0, 0x22, 0x07, 0xF9, 0x81, 0x60, 0x7F, 0xA0, 0x60, 0x4F,
  0xB0, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0xC4, 0x66, 0xFE, 0x3E, 0x88, 0xE3, 0xEF, 0x66, 0xFD, 0x0C,
  0xCC, 0xC0, 0xDF, 0x66, 0xFE, 0x4E, 0xEE, 0xE4, 0xEF, 0x66, 0xC0, 0x05, 0xC8, 0x94, 0x66, 0xFE,
  0x3E, 0x55, 0xE3, 0xEF, 0x66, 0xA8, 0x49, 0xFC, 0xCF, 0x9A, 0x00, 0x6F, 0xB0, 0x60, 0x2F, 0xB8,
  0x12, 0x01, 0x80, 0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_sim_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_sim_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_smart_display 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_hardware_smart_display_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xD0, 0x70, 0xAF, 0x00,
  0x3D, 0x82, 0x30, 0x4D, 0xD0, 0x03, 0xD0, 0x33, 0x0A, 0xC0, 0x03, 0xD0, 0x33, 0x0A, 0xC0, 0x03,
  0xD8, 0x23, 0x04, 0xDD, 0x00, 0x3D, 0x07, 0x0A, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10,
  0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_smart_display() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_smart_display_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_smartphone 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_hardware_smartphone_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x81, 0xE6, 0x69, 0x80, 0x47, 0x90, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x2E, 0xF9, 0x0E, 0x02,
  0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_smartphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_hardware_smartphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_smart_screen 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_hardware_smart_screen_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x25, 0x02, 0x20, 0xEF, 0xF8, 0x1E, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B,
  0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B, 0x89, 0x07, 0x31, 0x31, 0x30,
  0x40, 0x7B, 0x00, 0x1B, 0x89, 0x07, 0x31, 0x31, 0x30, 0x40, 0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07,
  0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB8, 0x11, 0x0E, 0xFF, 0x0E,
  0x20, 0x28, 0x09, 0x25, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_smart_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_smart_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_smart_toy 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_hardware_smart_toy_data[] PROGMEM = {
  0x70, 0x02, 0x76, 0x06, 0xA0, 0x67, 0x28, 0x25, 0x77, 0xDA, 0x82, 0xD7, 0x75, 0x50, 0x4F, 0xB0,
  0x44, 0x06, 0xFB, 0x06, 0x30, 0x50, 0xDA, 0x0C, 0x0E, 0xA0, 0x0D, 0xA8, 0x2D, 0x50, 0x1B, 0x81,
  0xE0, 0x7A, 0x03, 0x02, 0xC0, 0x01, 0xC0, 0xA0, 0xDA, 0x00, 0xCC, 0x82, 0x10, 0x5D, 0xA8, 0x4E,
  0xBB, 0xBB, 0xEA, 0x0D, 0x05, 0x30, 0x6A, 0x06, 0x40, 0x6A, 0x06, 0x40, 0x6B, 0x80, 0x0D, 0xB0,
  0x64, 0x06, 0xFB, 0x06, 0x40, 0x3F, 0xB0, 0x35, 0x02, 0x80, 0x43, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_smart_toy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_smart_toy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_speaker_group 18x18, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_18_hardware_speaker_group_data[] PROGMEM = {
  0x58, 0x03, 0x15, 0x04, 0xF9, 0x0D, 0x01, 0x30, 0x9F, 0xA0, 0x43, 0x09, 0xB0, 0xD0, 0xAC, 0x83,
  0x40, 0x50, 0x9B, 0x81, 0x40, 0x9B, 0x83, 0x44, 0xF0, 0x9B, 0x81, 0x93, 0xCB, 0x83, 0x44, 0xF0,
  0x9B, 0x81, 0xEC, 0xEB, 0x83, 0x44, 0xF0, 0x9A, 0x08, 0x20, 0x10, 0xCA, 0x89, 0x24, 0x4F, 0x09,
  0xFD, 0x07, 0xD4, 0x2A, 0x89, 0x14, 0x4F, 0x09, 0xFA, 0x0E, 0xFA, 0x1A, 0x89, 0x24, 0x4F, 0x09,
  0xFD, 0x06, 0xB3, 0x3A, 0x83, 0x44, 0xF0, 0x9A, 0x0A, 0x20, 0x20, 0xDA, 0x83, 0x44, 0xF0, 0x9C,
  0x0D, 0xC8, 0x34, 0x4F, 0x07, 0xFA, 0x02, 0x04, 0x92, 0x80, 0x45, 0x83, 0x30, 0x4F, 0x48, 0x03,
  0x34, 0x01, 0x0D, 0xF9, 0x07, 0x58, 0x04, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_speaker_group() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_round_18_hardware_speaker_group_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_speaker 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_hardware_speaker_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x38, 0x11, 0x02, 0xFB, 0x02, 0x06, 0xFB, 0x00, 0x6B, 0x82, 0xE3, 0x3E, 0xB0,
  0x06, 0xB0, 0xA2, 0x0A, 0xB0, 0x06, 0xC0, 0x06, 0xC0, 0x06, 0xB8, 0x2E, 0xBB, 0xEB, 0x00, 0x6A,
  0x0C, 0x02, 0x20, 0x20, 0xCA, 0x00, 0x6A, 0x84, 0x23, 0xDD, 0x32, 0xA8, 0x46, 0x6F, 0xE0, 0xBA,
  0x84, 0xB0, 0xEF, 0x66, 0xA1, 0x09, 0xA0, 0x91, 0xA0, 0x06, 0xA8, 0x46, 0x07, 0x70, 0x6A, 0x00,
  0x6B, 0x82, 0x72, 0x27, 0xB0, 0x06, 0xFB, 0x06, 0x02, 0xFB, 0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_speaker() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_speaker_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_start 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_18_hardware_start_data[] PROGMEM = {
  0x03, 0x02, 0x75, 0x0B, 0x09, 0x70, 0x10, 0x23, 0x0B, 0x09, 0x78, 0x16, 0xF4, 0x20, 0xB0, 0x97,
  0x18, 0x69, 0xF4, 0x0B, 0x90, 0x88, 0x03, 0x9A, 0x83, 0x3B, 0x90, 0x88, 0x03, 0x9A, 0x81, 0x3B,
  0x97, 0x18, 0x49, 0xF4, 0x0B, 0x97, 0x81, 0x6F, 0x42, 0x0B, 0x09, 0x70, 0x10, 0x23, 0x03, 0x02,
  0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_start() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_start_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_tablet_android 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_hardware_tablet_android_data[] PROGMEM = {
  0x28, 0x06, 0x12, 0x01, 0x0D, 0xFB, 0x81, 0xD1, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF8, 0x80,
  0x47, 0x82, 0x8F, 0x44, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73,
  0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x98, 0x24, 0x4F, 0x48, 0x04, 0x38, 0x24, 0xF4, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4C, 0x82, 0xC1, 0x1C, 0xC0, 0x04, 0xFD, 0x81, 0x41, 0xDF, 0xB0, 0xD0,
  0x12, 0x80, 0x61, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_tablet_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_round_18_hardware_tablet_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_tablet_mac 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_hardware_tablet_mac_data[] PROGMEM = {
  0x28, 0x06, 0x12, 0x01, 0x0D, 0xFB, 0x81, 0xD1, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF8, 0x80,
  0x47, 0x82, 0x8F, 0x44, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73,
  0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x98, 0x24, 0x4F, 0x48, 0x04, 0x38, 0x24, 0xF4, 0x4F,
  0xD0, 0x04, 0xD0, 0x0E, 0xD0, 0x04, 0xD0, 0x06, 0xD0, 0x04, 0xFD, 0x81, 0x41, 0xDF, 0xB0, 0xD0,
  0x12, 0x80, 0x61, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_tablet_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_round_18_hardware_tablet_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_tablet 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_hardware_tablet_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x25, 0x02, 0x20, 0xEF, 0xF8, 0x1E, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B,
  0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB0, 0x01,
  0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00,
  0x1B, 0x07, 0x71, 0x07, 0xB8, 0x11, 0x0E, 0xFF, 0x0E, 0x20, 0x28, 0x09, 0x25, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_tablet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_hardware_tablet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_toys 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_hardware_toys_data[] PROGMEM = {
  0x18, 0x31, 0x10, 0x9E, 0xA0, 0xE0, 0x94, 0x89, 0x13, 0xE7, 0x5F, 0x7C, 0xC7, 0xF5, 0x38, 0x91,
  0xDF, 0xBB, 0xB0, 0xAA, 0x0B, 0xA3, 0x02, 0x03, 0xA8, 0x6A, 0x5C, 0xC5, 0xAF, 0x33, 0x09, 0xFB,
  0x81, 0x90, 0x2F, 0xD0, 0x20, 0x3F, 0xD8, 0x43, 0x0C, 0xF7, 0xBC, 0x82, 0xB7, 0xFC, 0x28, 0x92,
  0x1F, 0x9C, 0xD9, 0x9D, 0xC9, 0xF1, 0x38, 0x25, 0xDC, 0x22, 0x82, 0x2C, 0xD5, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_toys() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_toys_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_tv 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_hardware_tv_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38,
  0x22, 0xF3, 0x19, 0x80, 0x90, 0xD9, 0x85, 0x10, 0x47, 0x77, 0xDC, 0x83, 0xD7, 0x77, 0x46, 0x0A,
  0xC0, 0xA7, 0x38, 0x42, 0x33, 0x33, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_videogame_asset_off 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_hardware_videogame_asset_off_data[] PROGMEM = {
  0x10, 0xE0, 0x77, 0x78, 0x39, 0xF7, 0x02, 0x80, 0x47, 0x81, 0x40, 0x1B, 0x81, 0x70, 0x9F, 0x90,
  0x10, 0x3C, 0x81, 0x70, 0x9F, 0x00, 0x3B, 0x83, 0xCF, 0x70, 0x9A, 0x84, 0x32, 0xEF, 0x33, 0xA8,
  0x94, 0x62, 0x6F, 0x70, 0x9F, 0x10, 0xEF, 0x33, 0xA8, 0x90, 0x62, 0x1B, 0xF7, 0x09, 0xED, 0xA0,
  0x03, 0xB0, 0x70, 0x3B, 0x81, 0x70, 0x9B, 0x00, 0x3B, 0x0E, 0x0D, 0xC8, 0x17, 0x09, 0xA0, 0x30,
  0x1F, 0xB8, 0x57, 0x09, 0xF1, 0x04, 0x80, 0x47, 0x83, 0x9F, 0x70, 0x27, 0x58, 0x16, 0xF7, 0x77,
  0x06, 0x0E, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_videogame_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_hardware_videogame_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_videogame_asset 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_hardware_videogame_asset_data[] PROGMEM = {
  0x10, 0x48, 0x09, 0x07, 0x81, 0x40, 0x1F, 0xF0, 0x10, 0x3B, 0x0E, 0x0D, 0xFA, 0x00, 0x3B, 0x07,
  0x03, 0xD8, 0x43, 0x2E, 0xF3, 0x3A, 0x89, 0x46, 0x21, 0x5D, 0xFD, 0xE1, 0x0E, 0xF3, 0x3A, 0x89,
  0x06, 0x21, 0x5D, 0xC0, 0x3E, 0xDA, 0x00, 0x3B, 0x07, 0x03, 0xA8, 0x1D, 0x15, 0xC0, 0x03, 0xB0,
  0xE0, 0xDF, 0xA0, 0x30, 0x1F, 0xF8, 0x11, 0x04, 0x80, 0x90, 0x70, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_videogame_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_hardware_videogame_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_watch_off 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_hardware_watch_off_data[] PROGMEM = {
  0x60, 0x03, 0x73, 0x0C, 0xA0, 0xD4, 0x0E, 0x07, 0x20, 0x3C, 0x03, 0x38, 0x36, 0xF7, 0x05, 0xC0,
  0x74, 0x87, 0x6F, 0x70, 0x9E, 0xEF, 0xC5, 0x81, 0x6F, 0x73, 0x81, 0x4E, 0xA4, 0x03, 0xA0, 0x73,
  0x81, 0x4F, 0x33, 0x83, 0x6E, 0x6F, 0x73, 0x0E, 0x06, 0x38, 0x46, 0xE0, 0x6F, 0x72, 0x0E, 0x06,
  0x38, 0x90, 0x3F, 0x40, 0x6F, 0x70, 0x93, 0x48, 0x5A, 0xE4, 0x06, 0xF7, 0x78, 0x2C, 0xFE, 0xEA,
  0x07, 0x60, 0x7C, 0x81, 0xCF, 0x75, 0x03, 0xC8, 0x23, 0x6F, 0x75, 0x0D, 0xA0, 0xC2, 0x06, 0x0E,
  0x60, 0x03, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_watch_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_watch_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_hardware_watch 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_hardware_watch_data[] PROGMEM = {
  0x40, 0x03, 0x70, 0xCA, 0x0D, 0x50, 0x3C, 0x03, 0x40, 0x7C, 0x07, 0x48, 0x4C, 0xFE, 0xEF, 0xC3,
  0x81, 0xAE, 0x42, 0x85, 0x4E, 0xA0, 0x3F, 0x44, 0x83, 0x4F, 0x36, 0xE6, 0x82, 0xE6, 0x6E, 0x68,
  0x3E, 0x63, 0xF4, 0x48, 0x54, 0xF3, 0x0A, 0xE4, 0x28, 0x14, 0xEA, 0x38, 0x4C, 0xFE, 0xEF, 0xC4,
  0x07, 0xC0, 0x74, 0x03, 0xC0, 0x35, 0x0D, 0xA0, 0xC7, 0x00, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_hardware_watch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 16), Box(0, 0, 17, 17),
      ic_round_18_hardware_watch_data, Alpha4(color::Black));
  return value;
}
