#include "communication.h"

using namespace roo_display;

// Image file ic_round_18_communication_3p 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_communication_3p_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xD8, 0x2D, 0x11,
  0xDD, 0x00, 0x3D, 0x0B, 0x20, 0xBD, 0x00, 0x3E, 0x00, 0x7E, 0x00, 0x3D, 0x82, 0xB7, 0x7B, 0xD0,
  0x03, 0xC0, 0x44, 0x04, 0xC0, 0x03, 0xC8, 0x44, 0x33, 0x33, 0x4C, 0x00, 0x3F, 0xF0, 0x03, 0xFF,
  0x01, 0x03, 0xA0, 0x98, 0x06, 0x78, 0x34, 0x03, 0xF7, 0x76, 0x01, 0x05, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_3p() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_3p_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_add_ic_call 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_communication_add_ic_call_data[] PROGMEM = {
  0x10, 0xF3, 0x02, 0x50, 0x23, 0x03, 0xB0, 0xE5, 0x90, 0x32, 0x02, 0xC0, 0x42, 0x83, 0x34, 0xF7,
  0x32, 0xC0, 0x62, 0x0E, 0xC8, 0x12, 0x0B, 0xA0, 0xD0, 0x13, 0x82, 0x2F, 0x51, 0x28, 0x25, 0xFD,
  0x15, 0x0E, 0x03, 0x40, 0xD0, 0xA7, 0x58, 0x14, 0xF5, 0x75, 0x81, 0x8E, 0x33, 0x81, 0x16, 0x46,
  0x84, 0xAE, 0x50, 0x1D, 0xA0, 0xE0, 0x25, 0x82, 0x8F, 0xAD, 0xC0, 0x46, 0x04, 0x0D, 0xD0, 0x47,
  0x10, 0x50, 0xBB, 0x03, 0x74, 0x02, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_add_ic_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_add_ic_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_alternate_email 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_round_18_communication_alternate_email_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x52, 0x82, 0x37, 0x73, 0x28, 0x15, 0xF3, 0x20, 0x0B,
  0x28, 0x47, 0xFD, 0xDF, 0x72, 0x00, 0xB2, 0x98, 0x35, 0x03, 0xF6, 0x28, 0x93, 0x6F, 0x30, 0x5F,
  0x02, 0xF3, 0x07, 0xD4, 0x89, 0x2D, 0x70, 0x3F, 0x22, 0xF3, 0x07, 0xD4, 0x89, 0x3D, 0x90, 0x2F,
  0x30, 0xF5, 0x03, 0xF6, 0x28, 0x90, 0x6F, 0xB0, 0x4F, 0x10, 0xBB, 0x28, 0x90, 0x7F, 0xDD, 0xFA,
  0xFC, 0xEB, 0x28, 0x13, 0xF5, 0x28, 0x63, 0x78, 0x30, 0x38, 0x64, 0x81, 0x9F, 0x57, 0x78, 0x39,
  0xFB, 0x53, 0x0F, 0x17, 0x20, 0x30, 0xBD, 0x07, 0x74, 0x02, 0x0F, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_alternate_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_alternate_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_app_registration 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_communication_app_registration_data[] PROGMEM = {
  0x10, 0x40, 0x32, 0x00, 0x32, 0x03, 0x04, 0x20, 0x4A, 0x02, 0x03, 0xA0, 0x30, 0x2A, 0x81, 0x40,
  0x3A, 0x00, 0x2A, 0x00, 0x2A, 0x03, 0x20, 0x02, 0x20, 0x02, 0x20, 0x02, 0x30, 0x30, 0x22, 0x00,
  0x33, 0x82, 0x58, 0x03, 0xA0, 0x20, 0x3A, 0x85, 0x30, 0x25, 0xF2, 0x3A, 0x87, 0x23, 0xFB, 0x05,
  0xF5, 0x22, 0x03, 0x02, 0x28, 0x13, 0x05, 0xA0, 0x53, 0x00, 0x23, 0x05, 0xA0, 0x53, 0x03, 0xA8,
  0x12, 0x05, 0xA0, 0x54, 0x04, 0xA8, 0x32, 0x0D, 0xF5, 0x60, 0x40, 0x32, 0x05, 0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_app_registration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_app_registration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_business 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_18_communication_business_data[] PROGMEM = {
  0x10, 0x28, 0x01, 0x30, 0x27, 0x10, 0x1E, 0x0E, 0x71, 0x85, 0x3F, 0x27, 0xF4, 0x59, 0x71, 0x85,
  0x3F, 0xAC, 0xFB, 0xB9, 0x80, 0x29, 0x87, 0x70, 0x3F, 0xDE, 0xFE, 0xE9, 0x80, 0x1B, 0x89, 0x0C,
  0xF2, 0x3F, 0x27, 0xF4, 0x59, 0x58, 0xD0, 0x2F, 0x33, 0xFC, 0xDF, 0xCC, 0xFB, 0x40, 0x95, 0x2F,
  0x33, 0xFC, 0xDF, 0xCC, 0xF9, 0x30, 0x74, 0x2F, 0x33, 0xF2, 0x7F, 0x45, 0x95, 0x8D, 0x02, 0xF3,
  0x3F, 0xDE, 0xFE, 0xEF, 0xD4, 0x0B, 0x72, 0xF3, 0x3F, 0xAC, 0xFB, 0xBF, 0x72, 0x05, 0x32, 0xF3,
  0x3F, 0x27, 0xF4, 0x59, 0x58, 0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x02, 0x80, 0x90, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_call_end 18x18, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_18_communication_call_end_data[] PROGMEM = {
  0x48, 0x61, 0x58, 0x99, 0x85, 0x16, 0x02, 0x0A, 0xA8, 0x2C, 0xAA, 0xCA, 0x0A, 0x02, 0x30, 0x7B,
  0x04, 0x40, 0x4B, 0x81, 0x70, 0x9C, 0x04, 0x40, 0x4C, 0x09, 0xD0, 0x34, 0x03, 0xD0, 0x6A, 0x0E,
  0x05, 0x60, 0x50, 0xEA, 0x83, 0x60, 0x5A, 0x27, 0x18, 0x12, 0xA5, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_call_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_communication_call_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_call_made 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_18_communication_call_made_data[] PROGMEM = {
  0x48, 0x01, 0x70, 0x34, 0x0B, 0xC0, 0x75, 0x0B, 0xB0, 0x75, 0x07, 0xB0, 0x74, 0x84, 0x7F, 0x7B,
  0xF7, 0x38, 0x17, 0xF7, 0x20, 0xB0, 0x72, 0x81, 0x7F, 0x76, 0x81, 0x7F, 0x76, 0x81, 0x7F, 0x77,
  0x90, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_call_made() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_communication_call_made_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_call_merge 18x18, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_round_18_communication_call_merge_data[] PROGMEM = {
  0x40, 0x0B, 0x70, 0xBA, 0x0B, 0x50, 0xBC, 0x0B, 0x48, 0x43, 0x3B, 0xB3, 0x36, 0x00, 0xA7, 0x10,
  0x0A, 0x71, 0x0B, 0x0A, 0x78, 0x18, 0xF5, 0x68, 0x48, 0xF5, 0x0A, 0x83, 0x81, 0x8F, 0x52, 0x85,
  0x5F, 0x80, 0x1F, 0x54, 0x81, 0x5F, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_call_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_communication_call_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_call_missed_outgoing 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_communication_call_missed_outgoing_data[] PROGMEM = {
  0x02, 0x68, 0x63, 0x99, 0x99, 0x1D, 0xB5, 0x01, 0x0D, 0xB8, 0x24, 0x3E, 0xB5, 0x02, 0xB8, 0x34,
  0x03, 0xEB, 0x48, 0x3B, 0xED, 0xF4, 0x28, 0x13, 0xEB, 0x28, 0x4B, 0xE3, 0x1D, 0x43, 0x84, 0x3E,
  0xBB, 0xE3, 0x71, 0x82, 0x3E, 0xE3, 0x73, 0x00, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_call_missed_outgoing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_communication_call_missed_outgoing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_call_missed 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_communication_call_missed_data[] PROGMEM = {
  0x84, 0x19, 0x99, 0x93, 0x60, 0x20, 0x4B, 0x0D, 0x01, 0x58, 0x1B, 0xD4, 0xB0, 0x25, 0x86, 0xBE,
  0x34, 0xFD, 0xEB, 0x48, 0x90, 0xBE, 0x30, 0x4D, 0x13, 0xEB, 0x28, 0x1B, 0xE3, 0x68, 0x43, 0xEB,
  0xBE, 0x37, 0x18, 0x23, 0xEE, 0x37, 0x30, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_call_missed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 14, 12), Box(0, 0, 17, 17),
      ic_round_18_communication_call_missed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_call 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_communication_call_data[] PROGMEM = {
  0x10, 0xF3, 0x02, 0x72, 0x03, 0xB0, 0xE7, 0x20, 0x2C, 0x04, 0x72, 0xC0, 0x67, 0x20, 0xBA, 0x0D,
  0x01, 0x72, 0x82, 0x5F, 0xD1, 0x74, 0x0D, 0x0A, 0x75, 0x81, 0x4F, 0x57, 0x58, 0x18, 0xE3, 0x38,
  0x11, 0x64, 0x68, 0x4A, 0xE5, 0x01, 0xDA, 0x0E, 0x02, 0x58, 0x28, 0xFA, 0xDC, 0x04, 0x60, 0x40,
  0xDD, 0x04, 0x71, 0x05, 0x0B, 0xB0, 0x37, 0x40, 0x20, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_call_received 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_18_communication_call_received_data[] PROGMEM = {
  0x71, 0x07, 0x97, 0x81, 0x7F, 0x66, 0x81, 0x7F, 0x66, 0x81, 0x7F, 0x62, 0x07, 0x0B, 0x28, 0x17,
  0xF6, 0x38, 0x47, 0xFB, 0x7F, 0x64, 0x07, 0xB0, 0x75, 0x07, 0xB0, 0xB5, 0x07, 0xC0, 0xB4, 0x03,
  0x80, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_call_received() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_communication_call_received_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_call_split 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_communication_call_split_data[] PROGMEM = {
  0x83, 0x15, 0x55, 0x22, 0x84, 0x25, 0x55, 0x16, 0xA0, 0xE0, 0x22, 0x03, 0x0E, 0xA0, 0x06, 0xA0,
  0x94, 0x09, 0xA8, 0x46, 0x6E, 0x9F, 0x72, 0x89, 0x76, 0xF9, 0xE6, 0x23, 0x06, 0xF7, 0x09, 0x70,
  0x21, 0x48, 0x16, 0xF5, 0x73, 0x0B, 0x0A, 0x73, 0x00, 0xA7, 0x30, 0x0A, 0x73, 0x00, 0xA7, 0x30,
  0x0A, 0x73, 0x00, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_call_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_call_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_cancel_presentation 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_communication_cancel_presentation_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x22,
  0x01, 0x04, 0x20, 0x40, 0x12, 0x84, 0x2F, 0x33, 0xF2, 0x28, 0x44, 0xF7, 0x7F, 0x42, 0x84, 0x2F,
  0x33, 0xF2, 0x30, 0x7A, 0x07, 0x38, 0x42, 0xF3, 0x3F, 0x23, 0x07, 0xA0, 0x73, 0x84, 0x2F, 0x33,
  0xF2, 0x28, 0x44, 0xF7, 0x7F, 0x42, 0x84, 0x2F, 0x33, 0xF2, 0x20, 0x10, 0x42, 0x04, 0x01, 0x28,
  0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_cancel_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_cancel_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_cell_tower 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_18_communication_cell_tower_data[] PROGMEM = {
  0x20, 0x50, 0x37, 0x10, 0x30, 0x53, 0x81, 0x2F, 0x67, 0x18, 0x16, 0xF2, 0x28, 0x3A, 0xC0, 0x53,
  0x48, 0x33, 0x50, 0xCA, 0x28, 0xA4, 0xE6, 0x1F, 0x60, 0x66, 0x06, 0xF1, 0x6E, 0x02, 0xF3, 0x5F,
  0x09, 0xA8, 0x94, 0x90, 0xF5, 0x3F, 0x22, 0xF2, 0x6E, 0x0A, 0xA8, 0x94, 0xB0, 0xE6, 0x2F, 0x21,
  0xF4, 0x3F, 0x34, 0xA8, 0xA4, 0x43, 0xF3, 0x4F, 0x10, 0xC9, 0x0B, 0x66, 0xEF, 0x46, 0xB0, 0x9C,
  0x28, 0x15, 0xF3, 0x28, 0x2B, 0x9B, 0x92, 0x81, 0x3F, 0x53, 0x86, 0xA6, 0x01, 0xF4, 0x7D, 0x20,
  0x60, 0xA7, 0x84, 0x6E, 0x03, 0xF2, 0x73, 0x84, 0xBD, 0x77, 0xF6, 0x72, 0x85, 0x1F, 0xDD, 0xDE,
  0xA7, 0x20, 0x40, 0xE3, 0x05, 0x0D, 0x73, 0x01, 0x40, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_cell_tower() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_cell_tower_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_cell_wifi 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_communication_cell_wifi_data[] PROGMEM = {
  0x40, 0xF3, 0x71, 0x81, 0x19, 0xEB, 0x81, 0xE9, 0x24, 0x89, 0x12, 0xED, 0x62, 0x12, 0x6D, 0xE3,
  0x38, 0x91, 0x18, 0x01, 0x68, 0x61, 0x07, 0x25, 0x85, 0x3E, 0xEC, 0xEF, 0x42, 0x81, 0x1C, 0x22,
  0x01, 0x06, 0x38, 0x55, 0x10, 0x1C, 0xF3, 0x48, 0x14, 0xC5, 0x28, 0x31, 0xCE, 0xF3, 0x48, 0x90,
  0x19, 0x10, 0x1C, 0xD4, 0xF3, 0x78, 0x51, 0xCF, 0x72, 0xF3, 0x60, 0x10, 0xCA, 0x82, 0x72, 0xF3,
  0x50, 0x10, 0xCB, 0x82, 0x72, 0xF3, 0x40, 0x10, 0xCC, 0x82, 0x72, 0xF3, 0x30, 0x10, 0xCD, 0x82,
  0x83, 0xF3, 0x30, 0xBF, 0xA0, 0x23, 0x02, 0x80, 0x53, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_cell_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_cell_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_chat_bubble_outline 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_communication_chat_bubble_outline_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x3E, 0x03, 0xF3, 0x80, 0x61, 0x84, 0x3F, 0x33, 0xF2, 0x73,
  0x84, 0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x84,
  0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F,
  0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF8, 0x80, 0x7D, 0x90, 0x10, 0x3A, 0x09, 0x80, 0x67, 0x83,
  0x40, 0x3F, 0x77, 0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_chat_bubble_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_chat_bubble_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_chat_bubble 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_communication_chat_bubble_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F,
  0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0,
  0x10, 0x3A, 0x09, 0x80, 0x67, 0x83, 0x40, 0x3F, 0x77, 0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_chat_bubble() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_chat_bubble_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_chat 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_communication_chat_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3A, 0x0D, 0x80, 0x47, 0x0D, 0xA0,
  0x03, 0xA0, 0xA0, 0x28, 0x02, 0x10, 0x20, 0xAA, 0x00, 0x3F, 0xF0, 0x03, 0xA0, 0x97, 0x10, 0x9A,
  0x00, 0x3A, 0x0E, 0x80, 0x49, 0x0E, 0xA0, 0x03, 0xA0, 0xD8, 0x01, 0x70, 0xAD, 0x00, 0x3A, 0x0B,
  0x80, 0x13, 0x07, 0xD0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x10, 0x3A, 0x09, 0x80, 0x67, 0x83, 0x40,
  0x3F, 0x77, 0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_clear_all 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_round_18_communication_clear_all_data[] PROGMEM = {
  0x30, 0x38, 0x05, 0x90, 0x13, 0x04, 0x80, 0x5B, 0x01, 0x77, 0x20, 0x78, 0x04, 0x90, 0x74, 0x07,
  0x80, 0x49, 0x07, 0x77, 0x20, 0x18, 0x05, 0xB0, 0x43, 0x01, 0x80, 0x59, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_clear_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_communication_clear_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_comment 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_communication_comment_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3A, 0x0D, 0x80, 0x47, 0x0D, 0xA0,
  0x03, 0xA0, 0xA0, 0x28, 0x02, 0x10, 0x20, 0xAA, 0x00, 0x3F, 0xF0, 0x03, 0xA0, 0x97, 0x10, 0x9A,
  0x00, 0x3A, 0x0E, 0x80, 0x49, 0x0E, 0xA0, 0x03, 0xA0, 0xD8, 0x04, 0x70, 0xDA, 0x00, 0x3A, 0x0B,
  0x80, 0x43, 0x0B, 0xA0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x30, 0x48, 0x06, 0x70, 0x9A, 0x03,
  0x76, 0x81, 0x7F, 0x37, 0x70, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_comments_disabled 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_communication_comments_disabled_data[] PROGMEM = {
  0x38, 0x07, 0x32, 0x82, 0x56, 0x09, 0xFB, 0x85, 0xE0, 0x6F, 0x70, 0x9F, 0xB0, 0x03, 0xA8, 0x17,
  0x06, 0x80, 0x27, 0x0D, 0xA0, 0x03, 0xB0, 0x72, 0x80, 0x01, 0x02, 0x0A, 0xA0, 0x03, 0xC8, 0x17,
  0x09, 0xF0, 0x03, 0xA8, 0x29, 0x6F, 0x75, 0x09, 0xA0, 0x03, 0xA8, 0x90, 0xE9, 0xDF, 0x70, 0x39,
  0x9E, 0xA0, 0x03, 0xD8, 0x5B, 0xF7, 0x06, 0x7D, 0xA0, 0x03, 0xD8, 0x27, 0xAF, 0x72, 0x0B, 0xA0,
  0x03, 0xFA, 0x81, 0x70, 0x9A, 0x03, 0x01, 0xFB, 0x85, 0x70, 0x9F, 0x30, 0x48, 0x04, 0x78, 0x49,
  0xF7, 0x09, 0x37, 0x48, 0x16, 0xF7, 0x77, 0x81, 0x6F, 0x67, 0x70, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_comments_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_comments_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_contact_emergency 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_communication_contact_emergency_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x30, 0x10, 0xCF, 0xFA, 0x0C, 0xFF, 0xFF, 0xB0, 0x8F, 0x98, 0x2E, 0x75, 0xBB,
  0x83, 0xB8, 0x18, 0xBE, 0x05, 0x30, 0xBA, 0x83, 0xE3, 0x03, 0xEE, 0x01, 0x30, 0x7A, 0x83, 0x93,
  0x03, 0x9E, 0x04, 0x30, 0xBC, 0x04, 0xF9, 0x82, 0xE6, 0x49, 0xFF, 0x82, 0xEC, 0xBD, 0xFD, 0x0E,
  0x06, 0x40, 0x20, 0x9F, 0xA0, 0xD0, 0x17, 0x05, 0xF0, 0xCF, 0xFA, 0x0C, 0x01, 0x80, 0x94, 0x30,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_contact_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_contact_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_contact_mail 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_communication_contact_mail_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x30, 0x10, 0xCF, 0xFA, 0x0C, 0xFF, 0xFF, 0x84, 0x65, 0x55, 0x5D, 0xE8, 0x92,
  0xE7, 0x5B, 0xFD, 0x34, 0x03, 0x5A, 0xE0, 0x53, 0x86, 0xBD, 0x07, 0xB9, 0x1A, 0xE0, 0x13, 0x07,
  0x0E, 0x20, 0x12, 0x0B, 0xE0, 0x43, 0x0B, 0xFE, 0x82, 0xE6, 0x49, 0xFF, 0x82, 0xEC, 0xBD, 0xFD,
  0x0E, 0x06, 0x40, 0x20, 0x9F, 0xA0, 0xD0, 0x17, 0x05, 0xF0, 0xCF, 0xFA, 0x0C, 0x01, 0x80, 0x94,
  0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_contact_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_contact_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_contact_phone 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_communication_contact_phone_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x30, 0x10, 0xCF, 0xFA, 0x0C, 0xFE, 0x0D, 0x0E, 0xFF, 0x98, 0x1D, 0x13, 0xF8,
  0x2E, 0x75, 0xBC, 0x82, 0x40, 0x2E, 0xE0, 0x53, 0x0B, 0xA8, 0x2E, 0x2B, 0xEF, 0x01, 0x30, 0x7A,
  0x0B, 0x05, 0xFA, 0x04, 0x30, 0xBA, 0x0B, 0x05, 0xFA, 0x82, 0xE6, 0x49, 0xB8, 0x2E, 0x2B, 0xEF,
  0x82, 0xEC, 0xBD, 0xC8, 0x24, 0x02, 0xEC, 0x0E, 0x06, 0x40, 0x20, 0x9A, 0x81, 0xD1, 0x3C, 0x0D,
  0x01, 0x70, 0x5A, 0x0D, 0x0E, 0xB0, 0xCF, 0xFA, 0x0C, 0x01, 0x80, 0x94, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_contact_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_contact_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_contacts 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_communication_contacts_data[] PROGMEM = {
  0x20, 0x28, 0x06, 0x90, 0x24, 0x02, 0x80, 0x6B, 0x02, 0x30, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F,
  0xF0, 0x10, 0x3D, 0x82, 0xE7, 0x7E, 0xD0, 0x03, 0xD0, 0x22, 0x02, 0xD0, 0x03, 0xC0, 0xC4, 0x0C,
  0xC0, 0x03, 0xC0, 0xE4, 0x0E, 0xC0, 0x03, 0xD8, 0x2B, 0x33, 0xBD, 0x00, 0x3E, 0x00, 0xDE, 0x00,
  0x3B, 0x0D, 0x05, 0x40, 0x50, 0xDB, 0x00, 0x3A, 0x0B, 0x71, 0x0B, 0xA0, 0x30, 0x1F, 0xF8, 0x11,
  0x03, 0x80, 0x90, 0x50, 0x33, 0x02, 0x80, 0x6B, 0x02, 0x40, 0x28, 0x06, 0x90, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_co_present 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_communication_co_present_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x23, 0x01, 0x20, 0xDF, 0xF8, 0x3D, 0x01, 0xF3, 0x75, 0x84, 0x3F, 0x11, 0xF3,
  0x28, 0x16, 0x83, 0x78, 0x63, 0xF1, 0x1F, 0x30, 0xCB, 0x06, 0x68, 0x53, 0xF1, 0x1F, 0x34, 0xC0,
  0xD6, 0x85, 0x3F, 0x11, 0xF3, 0x4C, 0x0E, 0x68, 0x63, 0xF1, 0x1F, 0x30, 0xDB, 0x08, 0x68, 0x91,
  0x3F, 0x10, 0xA1, 0x02, 0x9B, 0x77, 0x81, 0x3F, 0x14, 0x01, 0x0F, 0x37, 0x81, 0x3F, 0x12, 0x06,
  0x0C, 0xD0, 0xA0, 0x34, 0x83, 0x3F, 0x10, 0xBF, 0xA0, 0x53, 0x82, 0x3F, 0x11, 0xFB, 0x0A, 0x30,
  0x30, 0xD2, 0x0D, 0xFA, 0x07, 0x30, 0x01, 0x38, 0x04, 0x30, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_co_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_co_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_desktop_access_disabled 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_18_communication_desktop_access_disabled_data[] PROGMEM = {
  0x05, 0x06, 0x28, 0x06, 0x38, 0x51, 0x06, 0xF7, 0x09, 0xFA, 0x81, 0xE1, 0x3A, 0x07, 0x72, 0x86,
  0x2F, 0x33, 0xF8, 0xF7, 0x71, 0x87, 0x2F, 0x33, 0xF2, 0x6F, 0x77, 0x89, 0x02, 0xF3, 0x3F, 0x20,
  0x6F, 0x76, 0x84, 0x2F, 0x33, 0xF2, 0x28, 0x16, 0xF7, 0x58, 0x42, 0xF3, 0x3F, 0x23, 0x81, 0x6F,
  0x74, 0x84, 0x2F, 0x33, 0xF2, 0x48, 0x16, 0xF7, 0x38, 0x42, 0xF3, 0x3F, 0x25, 0x81, 0x6F, 0x72,
  0x82, 0x2F, 0x31, 0x98, 0x03, 0xDA, 0x89, 0x27, 0x07, 0xF1, 0x04, 0x77, 0x77, 0xAA, 0x84, 0xA9,
  0xF7, 0x02, 0x70, 0x6A, 0x83, 0x60, 0x6F, 0x77, 0x09, 0xC8, 0x39, 0x06, 0xF6, 0x78, 0x00, 0x33,
  0x00, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_desktop_access_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_desktop_access_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_dialer_sip 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_communication_dialer_sip_data[] PROGMEM = {
  0x10, 0xF3, 0x89, 0x22, 0x03, 0x32, 0x01, 0x13, 0x30, 0x3B, 0x89, 0x2E, 0x0D, 0x96, 0x49, 0x7B,
  0xD3, 0x2C, 0x89, 0x04, 0xD7, 0x54, 0x97, 0xAD, 0x31, 0xC8, 0x76, 0x46, 0xC4, 0x97, 0x95, 0x20,
  0xBA, 0x87, 0xD1, 0x9B, 0xC4, 0x97, 0x53, 0x89, 0x05, 0xFD, 0x10, 0x23, 0x20, 0x16, 0x0D, 0x0A,
  0x76, 0x81, 0x4F, 0x57, 0x68, 0x18, 0xE3, 0x38, 0x11, 0x64, 0x78, 0x4A, 0xE5, 0x01, 0xDA, 0x0E,
  0x02, 0x68, 0x28, 0xFA, 0xDC, 0x04, 0x70, 0x40, 0xDD, 0x04, 0x72, 0x05, 0x0B, 0xB0, 0x37, 0x50,
  0x20, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_dialer_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_dialer_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_dialpad 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_communication_dialpad_data[] PROGMEM = {
  0x89, 0x32, 0xED, 0x11, 0xEE, 0x11, 0xDE, 0x25, 0xA0, 0x30, 0x4A, 0x04, 0x03, 0xA8, 0x25, 0x07,
  0x62, 0x00, 0x62, 0x06, 0x07, 0x77, 0x07, 0x06, 0x20, 0x06, 0x28, 0x26, 0x70, 0x5A, 0x03, 0x04,
  0xA0, 0x40, 0x3A, 0x89, 0x35, 0x2E, 0xD1, 0x1E, 0xE1, 0x1D, 0xE2, 0x77, 0x73, 0x89, 0x32, 0xED,
  0x11, 0xEE, 0x11, 0xDE, 0x25, 0xA0, 0x30, 0x4A, 0x04, 0x03, 0xA8, 0x25, 0x07, 0x62, 0x00, 0x62,
  0x06, 0x07, 0x77, 0x40, 0x06, 0x72, 0x04, 0xA0, 0x47, 0x18, 0x21, 0xEE, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_dialpad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_dialpad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_document_scanner 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_round_18_communication_document_scanner_data[] PROGMEM = {
  0x10, 0xF1, 0x71, 0x0F, 0x11, 0x02, 0xB0, 0x46, 0x04, 0xB8, 0x32, 0x3F, 0x53, 0x71, 0x87, 0x35,
  0xF3, 0x3F, 0x20, 0x48, 0x02, 0x58, 0x74, 0x02, 0xF3, 0x06, 0x05, 0xF9, 0x81, 0x50, 0x64, 0x07,
  0xF9, 0x07, 0x60, 0x7A, 0x82, 0x83, 0x38, 0xA0, 0x76, 0x07, 0xA8, 0x29, 0x55, 0x9A, 0x07, 0x60,
  0x7A, 0x82, 0x95, 0x59, 0xA0, 0x76, 0x07, 0xA8, 0x29, 0x55, 0x9A, 0x07, 0x60, 0x7A, 0x82, 0x95,
  0x59, 0xA0, 0x76, 0x07, 0xA8, 0x28, 0x33, 0x8A, 0x07, 0x60, 0x7F, 0x90, 0x74, 0x81, 0x60, 0x5F,
  0x98, 0x75, 0x06, 0x03, 0xF2, 0x04, 0x80, 0x25, 0x87, 0x40, 0x2F, 0x33, 0xF5, 0x37, 0x18, 0x33,
  0x5F, 0x32, 0xB0, 0x46, 0x04, 0xB0, 0x21, 0x0F, 0x17, 0x10, 0xF1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_document_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_communication_document_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_domain_disabled 18x18, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_18_communication_domain_disabled_data[] PROGMEM = {
  0x08, 0x0B, 0x20, 0xF3, 0x02, 0x71, 0x83, 0x4F, 0xC0, 0x4A, 0x0E, 0x71, 0x03, 0xA0, 0xC2, 0x05,
  0x97, 0x10, 0x3B, 0x81, 0xC0, 0x39, 0x80, 0x29, 0x89, 0x07, 0x03, 0xFD, 0xEF, 0xC0, 0x48, 0x01,
  0xB8, 0x5C, 0xF2, 0x3F, 0x27, 0xA0, 0xC6, 0x85, 0x2F, 0x33, 0xFC, 0xDB, 0x0C, 0x38, 0x94, 0x95,
  0x2F, 0x33, 0xFC, 0xDF, 0xCC, 0xFC, 0x28, 0x92, 0x74, 0x2F, 0x33, 0xF2, 0x7F, 0x45, 0xA0, 0xC3,
  0x89, 0x02, 0xF3, 0x3F, 0xDE, 0xFE, 0xEB, 0x0C, 0x28, 0xB0, 0x2F, 0x33, 0xFA, 0xCF, 0xBB, 0xF7,
  0x7E, 0xC0, 0x1F, 0x33, 0xF2, 0x7F, 0x45, 0x92, 0x85, 0x2E, 0xC0, 0x42, 0x1F, 0xD0, 0xC3, 0x02,
  0x80, 0x63, 0x81, 0x4E, 0x97, 0x70, 0x10, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_domain_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_domain_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_domain_verification 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_communication_domain_verification_data[] PROGMEM = {
  0x18, 0x06, 0x51, 0x05, 0xFB, 0x05, 0x06, 0xFB, 0x81, 0x66, 0x98, 0x04, 0x38, 0x29, 0x66, 0x77,
  0x18, 0x27, 0x66, 0x75, 0x87, 0x98, 0x07, 0x66, 0x70, 0x12, 0x09, 0x0A, 0x28, 0x77, 0x66, 0x70,
  0x7A, 0x9A, 0x38, 0x27, 0x66, 0x72, 0x08, 0x09, 0x48, 0x27, 0x66, 0x77, 0x18, 0x27, 0x65, 0xC8,
  0x04, 0x70, 0xC0, 0x51, 0x80, 0x65, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_domain_verification() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_domain_verification_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_duo 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_communication_duo_data[] PROGMEM = {
  0x70, 0x28, 0x02, 0x36, 0x03, 0x0B, 0xF9, 0x0E, 0x40, 0x9F, 0xC0, 0x32, 0x09, 0xFD, 0x81, 0x30,
  0x3F, 0xE8, 0x13, 0x0B, 0xA8, 0x6D, 0xBB, 0xBB, 0xEF, 0xEB, 0x03, 0x1B, 0x06, 0x48, 0x1A, 0x86,
  0xB0, 0x30, 0x2B, 0x06, 0x48, 0x11, 0x06, 0xB0, 0x30, 0x2B, 0x06, 0x48, 0x11, 0x06, 0xB0, 0x21,
  0xB0, 0x64, 0x81, 0xA8, 0x6B, 0x20, 0xBA, 0x86, 0xDB, 0xBB, 0xBE, 0xFE, 0xA0, 0xB2, 0x03, 0xFD,
  0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_duo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_duo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_email 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_communication_email_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x31, 0x3F, 0xAB, 0xF9, 0x89, 0x0B, 0xAF, 0x33,
  0xF5, 0x04, 0xDC, 0x85, 0xD4, 0x05, 0xF3, 0x3A, 0x89, 0x0A, 0x20, 0x6E, 0xE6, 0x02, 0xAA, 0x00,
  0x3C, 0x84, 0x80, 0x11, 0x08, 0xC0, 0x03, 0xD8, 0x2E, 0x66, 0xED, 0x00, 0x3F, 0xF0, 0x03, 0xFF,
  0x00, 0x3F, 0xF0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_forum 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_communication_forum_data[] PROGMEM = {
  0x28, 0x04, 0x30, 0x26, 0x0E, 0xFA, 0x05, 0x40, 0x3F, 0xB0, 0x94, 0x03, 0xFB, 0x09, 0x40, 0x3F,
  0xB8, 0x49, 0x09, 0x50, 0x3F, 0xB0, 0x91, 0xA0, 0x20, 0x3F, 0xB0, 0x91, 0xA0, 0x03, 0xFB, 0x09,
  0x1A, 0x00, 0x3A, 0x0E, 0x80, 0x2D, 0x0C, 0x03, 0x1A, 0x83, 0x33, 0xFC, 0x17, 0x2A, 0x84, 0x32,
  0xC1, 0x07, 0x80, 0x4B, 0xA0, 0x34, 0x07, 0xFB, 0x03, 0x50, 0x68, 0x02, 0x70, 0x9A, 0x03, 0x76,
  0x81, 0x7F, 0x37, 0x70, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_forum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_forum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_forward_to_inbox 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_communication_forward_to_inbox_data[] PROGMEM = {
  0x10, 0x48, 0x06, 0x58, 0x34, 0x03, 0xE8, 0x80, 0x47, 0x85, 0x8E, 0x34, 0xDD, 0x46, 0x89, 0x04,
  0xDD, 0x44, 0x92, 0xBA, 0x12, 0x86, 0x1A, 0xB2, 0x94, 0x49, 0x28, 0x46, 0xD5, 0x5D, 0x62, 0x82,
  0x94, 0x49, 0x38, 0x21, 0x99, 0x13, 0x82, 0x94, 0x49, 0x73, 0x82, 0x94, 0x49, 0x73, 0x82, 0x73,
  0x49, 0x72, 0x03, 0x20, 0x40, 0x97, 0x28, 0x37, 0xB0, 0x3C, 0x80, 0x17, 0x87, 0x60, 0x77, 0xBF,
  0xB0, 0x48, 0x02, 0x51, 0x83, 0x55, 0xAF, 0x97, 0x40, 0x70, 0x97, 0x50, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_forward_to_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_forward_to_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_hourglass_bottom 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_18_communication_hourglass_bottom_data[] PROGMEM = {
  0x18, 0x02, 0x31, 0x89, 0x08, 0xC9, 0x99, 0x9C, 0x89, 0x44, 0x82, 0x49, 0x94, 0x48, 0x34, 0x94,
  0xC1, 0x28, 0x90, 0x1C, 0x40, 0x6C, 0x11, 0xC6, 0x38, 0x26, 0xCC, 0x64, 0x06, 0xA0, 0x63, 0x06,
  0xC8, 0x16, 0x04, 0xE0, 0x40, 0x9E, 0x00, 0x9E, 0x09, 0x08, 0xE0, 0x81, 0x80, 0x23, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_hourglass_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_hourglass_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_hourglass_top 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_18_communication_hourglass_top_data[] PROGMEM = {
  0x18, 0x02, 0x31, 0x08, 0xE0, 0x80, 0x9E, 0x00, 0x9E, 0x09, 0x04, 0xE8, 0x14, 0x06, 0xC0, 0x63,
  0x06, 0xA0, 0x64, 0x82, 0x6C, 0xC6, 0x38, 0x90, 0x6C, 0x11, 0xC6, 0x04, 0xC1, 0x28, 0x31, 0xC4,
  0x94, 0x48, 0x24, 0x99, 0x44, 0x89, 0x04, 0x98, 0xC9, 0x99, 0x9C, 0x81, 0x80, 0x23, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_hourglass_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_hourglass_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_hub 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_communication_hub_data[] PROGMEM = {
  0x78, 0x25, 0xDD, 0x57, 0x60, 0x1C, 0x01, 0x75, 0x03, 0xC0, 0x37, 0x60, 0xCA, 0x0C, 0x77, 0x10,
  0x09, 0x71, 0x82, 0x3D, 0xF9, 0x40, 0x07, 0x48, 0x39, 0xFD, 0x3C, 0xB8, 0x25, 0x01, 0xBA, 0x82,
  0xB2, 0x05, 0xB0, 0xC0, 0xEB, 0x81, 0xB4, 0xDC, 0x81, 0xD4, 0xBB, 0x0E, 0x08, 0xA8, 0x1E, 0x6B,
  0xE8, 0x1B, 0x6E, 0xA8, 0x57, 0x04, 0x61, 0x04, 0xE8, 0x34, 0x01, 0x64, 0x60, 0x1E, 0x01, 0x74,
  0x09, 0xC0, 0x97, 0x28, 0x92, 0x25, 0x5D, 0x48, 0x84, 0xD5, 0x52, 0x50, 0x3B, 0x06, 0x40, 0x6B,
  0x03, 0x40, 0xAB, 0x0A, 0x40, 0xAB, 0x0A, 0x40, 0x9B, 0x09, 0x40, 0x9B, 0x09, 0x48, 0x31, 0xCF,
  0xC1, 0x48, 0x31, 0xCF, 0xC1, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_import_contacts 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_communication_import_contacts_data[] PROGMEM = {
  0x38, 0x22, 0x33, 0x24, 0x82, 0x23, 0x32, 0x40, 0x80, 0xEC, 0x82, 0xD7, 0x7D, 0xC8, 0x2E, 0x80,
  0x1F, 0x98, 0x90, 0xE8, 0x31, 0x13, 0x9F, 0x11, 0xF9, 0x68, 0x23, 0xF1, 0x1F, 0x96, 0x82, 0x3F,
  0x11, 0xF9, 0x68, 0x23, 0xF1, 0x1F, 0x96, 0x82, 0x3F, 0x11, 0xF9, 0x68, 0x23, 0xF1, 0x1F, 0x96,
  0x82, 0x3F, 0x11, 0xF9, 0x68, 0x23, 0xF1, 0x1F, 0x92, 0x86, 0x35, 0x53, 0x4F, 0x11, 0xF9, 0x07,
  0x0E, 0xE8, 0x31, 0x07, 0x62, 0x28, 0x42, 0x8E, 0xE8, 0x22, 0x81, 0x26, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_import_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_import_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_import_export 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_communication_import_export_data[] PROGMEM = {
  0x18, 0x11, 0xC6, 0x60, 0x10, 0xDA, 0x06, 0x58, 0x31, 0x7E, 0xB5, 0x70, 0xE0, 0x67, 0x10, 0xE0,
  0x67, 0x10, 0xE0, 0x67, 0x10, 0xE0, 0x62, 0x04, 0x0A, 0x40, 0xA0, 0x42, 0x06, 0x0E, 0x71, 0x06,
  0x0E, 0x71, 0x06, 0x0E, 0x71, 0x06, 0x0E, 0x78, 0x35, 0xBE, 0x71, 0x50, 0x6A, 0x0D, 0x01, 0x68,
  0x16, 0xC1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_import_export() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_import_export_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_invert_colors_off 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_communication_invert_colors_off_data[] PROGMEM = {
  0x60, 0x0A, 0x50, 0xE0, 0x73, 0x82, 0xAE, 0xFA, 0x48, 0x56, 0xF7, 0x05, 0xE4, 0xA0, 0x94, 0x83,
  0x6F, 0x70, 0x21, 0xB0, 0x94, 0x81, 0xAF, 0x72, 0xC0, 0x72, 0x85, 0x1E, 0xBF, 0x70, 0x9C, 0x89,
  0x01, 0x06, 0xE0, 0x6F, 0x70, 0x9B, 0x82, 0x60, 0x8B, 0x28, 0x36, 0xF7, 0x09, 0xA8, 0x29, 0x08,
  0xD3, 0x89, 0x16, 0xF7, 0x09, 0xF8, 0x04, 0xF2, 0x3A, 0x82, 0x70, 0x94, 0x20, 0xD0, 0xC3, 0xB0,
  0x74, 0x83, 0x2E, 0xD5, 0x2C, 0x07, 0x40, 0x20, 0xAC, 0x82, 0x97, 0xF7, 0x58, 0x11, 0x33, 0x30,
  0x60, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_invert_colors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_invert_colors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_key_off 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_communication_key_off_data[] PROGMEM = {
  0x10, 0xE0, 0x77, 0x78, 0x16, 0xF7, 0x76, 0x05, 0xA0, 0x77, 0x40, 0x4A, 0x81, 0xEF, 0x77, 0x38,
  0x7C, 0xFB, 0x06, 0xF7, 0x01, 0x80, 0x25, 0x1A, 0x03, 0x28, 0x36, 0xF7, 0x09, 0xD0, 0x9A, 0x03,
  0x38, 0x39, 0xF7, 0x09, 0xC8, 0x29, 0xCF, 0xB2, 0x01, 0x0D, 0xA8, 0x67, 0x07, 0xBF, 0x90, 0x4A,
  0x86, 0xEC, 0xEF, 0xE7, 0xF7, 0x20, 0x63, 0x05, 0x0E, 0xB8, 0x4D, 0x30, 0x6F, 0x76, 0x82, 0x15,
  0x64, 0x48, 0x16, 0xF7, 0x77, 0x81, 0x6F, 0x77, 0x70, 0x60, 0xE2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_key 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_communication_key_data[] PROGMEM = {
  0x28, 0x21, 0x55, 0x47, 0x40, 0x60, 0xEB, 0x0D, 0x03, 0x71, 0x04, 0xA8, 0x4E, 0xCE, 0xFE, 0x17,
  0x81, 0xCF, 0xB2, 0x82, 0x1D, 0xFA, 0x80, 0x25, 0x1A, 0x03, 0x30, 0x7F, 0x90, 0x9A, 0x03, 0x30,
  0x7F, 0x98, 0x29, 0xCF, 0xB2, 0x89, 0x21, 0xDF, 0xA8, 0xFC, 0xBF, 0x90, 0x4A, 0x89, 0x1E, 0xCE,
  0xFE, 0x10, 0x51, 0x06, 0x30, 0x60, 0xEB, 0x0D, 0x03, 0x73, 0x82, 0x15, 0x74, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_communication_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_list_alt 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_communication_list_alt_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x8B, 0x44, 0x4F, 0x03, 0x40,
  0x69, 0x99, 0x30, 0xF4, 0x4F, 0x04, 0x60, 0x8B, 0xBB, 0x40, 0xF4, 0x49, 0x73, 0x98, 0xB4, 0x44,
  0xF0, 0x45, 0x07, 0x99, 0x94, 0x0F, 0x44, 0xF0, 0x45, 0x07, 0x99, 0x94, 0x0F, 0x44, 0x97, 0x39,
  0x8B, 0x44, 0x4F, 0x04, 0x60, 0x8B, 0xBB, 0x40, 0xF4, 0x4F, 0x03, 0x40, 0x69, 0x99, 0x30, 0xF4,
  0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_list_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_list_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_live_help 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_communication_live_help_data[] PROGMEM = {
  0x10, 0x18, 0x06, 0x38, 0x21, 0x01, 0xEF, 0xB8, 0x1E, 0x14, 0xFD, 0x00, 0x4C, 0x82, 0x92, 0x28,
  0xC0, 0x04, 0xC8, 0x31, 0x99, 0x0D, 0xB0, 0x04, 0xE8, 0x1E, 0x0B, 0xB0, 0x04, 0xE0, 0x04, 0xC0,
  0x04, 0xD8, 0x18, 0x2E, 0xC0, 0x04, 0xD0, 0xC0, 0xBD, 0x00, 0x4D, 0x00, 0xBD, 0x00, 0x4D, 0x00,
  0x4D, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x42, 0x03, 0x55, 0x9C, 0x82, 0x95, 0x53, 0x60, 0x9A,
  0x09, 0x74, 0x00, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_live_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_live_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_location_off 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_communication_location_off_data[] PROGMEM = {
  0x60, 0x02, 0x71, 0x81, 0x19, 0xEA, 0x81, 0xE9, 0x12, 0x82, 0xE7, 0x08, 0xE8, 0x6D, 0x20, 0x6F,
  0x70, 0x9E, 0x0D, 0x28, 0x39, 0xF7, 0x09, 0xE8, 0x16, 0x0B, 0xA8, 0x27, 0x05, 0x7C, 0x81, 0xB0,
  0xCB, 0x07, 0x20, 0xBB, 0x81, 0xC0, 0x9C, 0x81, 0x70, 0x8B, 0x81, 0xB0, 0x5D, 0x81, 0x70, 0x9A,
  0x06, 0x20, 0xDD, 0x82, 0x70, 0x9D, 0x30, 0x5E, 0x81, 0x70, 0x24, 0x09, 0xE0, 0x76, 0x0B, 0xC8,
  0x1D, 0xF7, 0x50, 0x10, 0xCA, 0x83, 0xC1, 0x6F, 0x76, 0x00, 0xA3, 0x06, 0x0E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_location_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_location_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_location_on 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_communication_location_on_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x20, 0xDF, 0x98,
  0x1D, 0x06, 0xFB, 0x06, 0x0B, 0xC0, 0x07, 0xC0, 0xB0, 0xCB, 0x0A, 0x20, 0xAB, 0x0C, 0x09, 0xB8,
  0x2E, 0x22, 0xEB, 0x0B, 0x05, 0xFB, 0x81, 0x60, 0xDF, 0x90, 0xD2, 0x05, 0xF9, 0x05, 0x30, 0x9E,
  0x09, 0x50, 0xBC, 0x0B, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x71, 0x00, 0xA5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_location_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_location_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_mail_lock 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_communication_mail_lock_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x03, 0x20, 0x1F, 0xF8, 0x41, 0x03, 0xFA, 0xBF, 0x98, 0x91, 0xBA, 0xF3,
  0x03, 0xF5, 0x04, 0xDC, 0x86, 0xD4, 0x05, 0xF3, 0x03, 0xA8, 0x95, 0xA2, 0x06, 0xEE, 0x60, 0x2A,
  0xC9, 0x10, 0x3C, 0x89, 0x38, 0x01, 0x10, 0x8E, 0x40, 0x52, 0x03, 0xD8, 0x92, 0xE7, 0x7E, 0xF7,
  0x07, 0x6B, 0x03, 0xFB, 0x85, 0x30, 0xA4, 0xA3, 0x3F, 0xB0, 0x20, 0x7C, 0x03, 0xFB, 0x02, 0x07,
  0xC0, 0x1F, 0xB0, 0x20, 0x7C, 0x10, 0x38, 0x05, 0x51, 0x02, 0x80, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_mail_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_mail_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_mail_outline 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_communication_mail_outline_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x31, 0x3F, 0xAB, 0xF9, 0x89, 0x0B, 0xAF, 0x33,
  0xF5, 0x04, 0xDC, 0x85, 0xD4, 0x05, 0xF3, 0x3A, 0x89, 0x0A, 0x20, 0x6E, 0xE6, 0x02, 0xAA, 0x00,
  0x3C, 0x84, 0x80, 0x11, 0x08, 0xC0, 0x03, 0xD8, 0x2E, 0x66, 0xED, 0x00, 0x3F, 0xF0, 0x03, 0xFF,
  0x00, 0x3F, 0xF0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_mail_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_mail_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_mark_chat_read 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_communication_mark_chat_read_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x3F, 0xD0, 0x30, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xF9,
  0x84, 0xB6, 0x35, 0x24, 0xF0, 0x65, 0x04, 0xE0, 0xA4, 0x81, 0x19, 0x4E, 0x03, 0x38, 0x21, 0xC6,
  0x4E, 0x18, 0x53, 0x91, 0xC6, 0x04, 0xA0, 0xA0, 0xF9, 0x28, 0x19, 0xE6, 0x28, 0x14, 0xF7, 0x70,
  0x23, 0x04, 0x07, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_mark_chat_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_mark_chat_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_mark_chat_unread 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_communication_mark_chat_unread_data[] PROGMEM = {
  0x74, 0x02, 0x38, 0x04, 0x31, 0x83, 0xCF, 0xC0, 0x3F, 0x0D, 0x03, 0xB0, 0x30, 0x4F, 0x85, 0xE1,
  0xEF, 0xE1, 0x4F, 0x98, 0x4A, 0x25, 0x21, 0x4F, 0xA8, 0x3E, 0xBE, 0x44, 0xFD, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4A, 0x0A, 0x80, 0x49, 0x83, 0x80, 0x4F, 0x77,
  0x40, 0x40, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_mark_chat_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_mark_chat_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_mark_email_read 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_communication_mark_email_read_data[] PROGMEM = {
  0x10, 0x48, 0x06, 0x58, 0x14, 0x03, 0xFD, 0x83, 0x34, 0xC2, 0xBE, 0x89, 0x0B, 0x2C, 0x44, 0xFD,
  0x35, 0xEA, 0x85, 0xE5, 0x3C, 0xF4, 0x4B, 0x84, 0x91, 0x99, 0x19, 0xB0, 0x04, 0xC8, 0x2D, 0x55,
  0xDC, 0x00, 0x4F, 0x98, 0x48, 0x30, 0x21, 0x4F, 0x03, 0x50, 0x4E, 0x08, 0x48, 0x12, 0xB4, 0xE0,
  0x33, 0x82, 0x2D, 0x33, 0xE1, 0x83, 0x3C, 0x3D, 0x32, 0x04, 0x80, 0x15, 0x28, 0x16, 0xE3, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_mark_email_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_mark_email_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_mark_email_unread 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_communication_mark_email_unread_data[] PROGMEM = {
  0x74, 0x03, 0x30, 0x48, 0x03, 0x51, 0x83, 0xDF, 0xD0, 0x3F, 0x0D, 0x03, 0xB8, 0x33, 0x4C, 0x2B,
  0xD8, 0x91, 0x2D, 0xFD, 0x04, 0xFC, 0x35, 0xEA, 0x85, 0xE3, 0x13, 0x11, 0x4B, 0x89, 0x19, 0x19,
  0x92, 0x9F, 0xDF, 0x44, 0xC8, 0x2D, 0x55, 0xDC, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x04, 0x03, 0xFD, 0x81, 0x30, 0x48, 0x06, 0x50, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_mark_email_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_mark_email_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_mark_unread_chat_alt 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_communication_mark_unread_chat_alt_data[] PROGMEM = {
  0x74, 0x82, 0x3A, 0xA2, 0x38, 0x03, 0x38, 0x11, 0x1E, 0xA0, 0xD2, 0x0E, 0xF0, 0x50, 0x3C, 0x02,
  0x03, 0xF9, 0x81, 0x81, 0xEA, 0x81, 0xD0, 0x3A, 0x0D, 0x80, 0x17, 0x86, 0x60, 0x29, 0x92, 0x03,
  0xA0, 0xA0, 0x28, 0x03, 0x12, 0x81, 0x52, 0x3F, 0xF0, 0x03, 0xA0, 0x97, 0x10, 0x9A, 0x00, 0x3A,
  0x0E, 0x80, 0x49, 0x0E, 0xA0, 0x03, 0xA0, 0xD8, 0x01, 0x70, 0xAD, 0x00, 0x3A, 0x0B, 0x80, 0x13,
  0x07, 0xD0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x10, 0x3A, 0x09, 0x80, 0x67, 0x83, 0x40, 0x3F, 0x77,
  0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_mark_unread_chat_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_mark_unread_chat_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_message 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_communication_message_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3A, 0x0D, 0x80, 0x47, 0x0D, 0xA0,
  0x03, 0xA0, 0xA0, 0x28, 0x02, 0x10, 0x20, 0xAA, 0x00, 0x3F, 0xF0, 0x03, 0xA0, 0x97, 0x10, 0x9A,
  0x00, 0x3A, 0x0E, 0x80, 0x49, 0x0E, 0xA0, 0x03, 0xA0, 0xD8, 0x01, 0x70, 0xAD, 0x00, 0x3A, 0x0B,
  0x80, 0x13, 0x07, 0xD0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x10, 0x3A, 0x09, 0x80, 0x67, 0x83, 0x40,
  0x3F, 0x77, 0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_message() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_message_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_mobile_screen_share 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_communication_mobile_screen_share_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x48, 0x62, 0xE2, 0x0E, 0x66,
  0xE2, 0x04, 0x0D, 0xA8, 0x4C, 0x0E, 0x66, 0xE2, 0x89, 0x6E, 0xA4, 0xE3, 0x0E, 0x66, 0xE0, 0x3F,
  0x20, 0x12, 0x85, 0xE6, 0x6E, 0x01, 0x85, 0x82, 0xE6, 0x6E, 0x71, 0x81, 0xE6, 0x69, 0x80, 0x47,
  0x90, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x2E, 0xF9, 0x0E, 0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_mobile_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_communication_mobile_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_more_time 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_communication_more_time_data[] PROGMEM = {
  0x73, 0x01, 0x02, 0x68, 0x23, 0x66, 0x32, 0x06, 0x07, 0x48, 0x96, 0x2C, 0xB8, 0x68, 0x19, 0xBC,
  0x91, 0x02, 0xD5, 0x58, 0x23, 0x89, 0x32, 0x0A, 0x06, 0x20, 0x30, 0x53, 0x05, 0x07, 0x20, 0x10,
  0xD3, 0x05, 0x08, 0x70, 0x40, 0xA3, 0x05, 0x08, 0x30, 0x60, 0x72, 0x03, 0x0B, 0x38, 0x14, 0xB1,
  0x20, 0x80, 0x63, 0x0D, 0x48, 0x45, 0xD5, 0x0B, 0x33, 0x09, 0x08, 0x58, 0x13, 0x5C, 0x50, 0xC0,
  0x84, 0x81, 0x6D, 0x26, 0x85, 0x9D, 0xBA, 0xDA, 0x27, 0x28, 0x13, 0x31, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_more_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_more_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_nat 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_communication_nat_data[] PROGMEM = {
  0x30, 0x10, 0x37, 0x68, 0x23, 0xBD, 0x77, 0x78, 0x18, 0xC1, 0x76, 0x06, 0x0A, 0x77, 0x0B, 0x03,
  0x68, 0x15, 0xB7, 0x40, 0x50, 0x92, 0x8C, 0x34, 0x20, 0x1D, 0x3B, 0x97, 0x77, 0x2D, 0x77, 0xBF,
  0x71, 0xD3, 0xB9, 0x77, 0x72, 0xD7, 0x7B, 0xF7, 0x05, 0xB7, 0x40, 0x50, 0x92, 0x04, 0x02, 0x72,
  0x0B, 0x03, 0x75, 0x06, 0x0A, 0x75, 0x81, 0x8C, 0x17, 0x28, 0x23, 0xBD, 0x77, 0x40, 0x10, 0x37,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_nat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_nat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_no_sim 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_communication_no_sim_data[] PROGMEM = {
  0x68, 0x02, 0x30, 0x12, 0x05, 0x06, 0x30, 0x7F, 0x85, 0x20, 0x5F, 0x70, 0x4F, 0x90, 0x62, 0x83,
  0x6F, 0x70, 0x9F, 0x06, 0x38, 0x38, 0xF7, 0x09, 0xE0, 0x63, 0x06, 0xA8, 0x17, 0x09, 0xD0, 0x63,
  0x06, 0xB8, 0x17, 0x09, 0xC0, 0x63, 0x06, 0xC8, 0x17, 0x09, 0xB0, 0x63, 0x06, 0xD8, 0x17, 0x09,
  0xA0, 0x63, 0x06, 0xE8, 0x37, 0x09, 0xF6, 0x30, 0x6F, 0x82, 0x70, 0x96, 0x30, 0x6F, 0x98, 0x17,
  0x01, 0x30, 0x6F, 0xA0, 0x74, 0x06, 0xFB, 0x07, 0x30, 0x2F, 0xC0, 0x63, 0x01, 0x80, 0x43, 0x81,
  0x15, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_pause_presentation 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_communication_pause_presentation_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x23,
  0x82, 0x81, 0x18, 0x38, 0x42, 0xF3, 0x3F, 0x23, 0x90, 0x05, 0x93, 0x84, 0x2F, 0x33, 0xF2, 0x39,
  0x00, 0x59, 0x38, 0x42, 0xF3, 0x3F, 0x23, 0x90, 0x05, 0x93, 0x84, 0x2F, 0x33, 0xF2, 0x39, 0x00,
  0x59, 0x38, 0x42, 0xF3, 0x3F, 0x23, 0x82, 0x81, 0x18, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22,
  0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_pause_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_pause_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_person_add_disabled 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_communication_person_add_disabled_data[] PROGMEM = {
  0x10, 0xE0, 0x72, 0x81, 0x45, 0x17, 0x38, 0x66, 0xF7, 0x09, 0xFE, 0x33, 0x02, 0x07, 0x58, 0x56,
  0xF7, 0x09, 0xFB, 0x38, 0x14, 0xF1, 0x58, 0x93, 0x8F, 0x70, 0x9D, 0x02, 0x79, 0xF8, 0x74, 0x02,
  0xA8, 0x91, 0x70, 0x40, 0x4D, 0xEF, 0xDD, 0x14, 0x82, 0x5D, 0xF7, 0x48, 0x14, 0xF1, 0x71, 0x81,
  0x7F, 0x73, 0x81, 0x3D, 0x14, 0x81, 0x4A, 0xEC, 0x07, 0x71, 0x0A, 0xF9, 0x07, 0x60, 0x2F, 0xB0,
  0x75, 0x03, 0xFC, 0x07, 0x40, 0x18, 0x06, 0x58, 0x17, 0xF7, 0x77, 0x10, 0x60, 0xE3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_person_add_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_person_add_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_person_search 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_communication_person_search_data[] PROGMEM = {
  0x48, 0x15, 0x61, 0x71, 0x0A, 0xA0, 0xD7, 0x01, 0xC0, 0x47, 0x0E, 0xB0, 0x27, 0x82, 0x4D, 0xE6,
  0x72, 0x00, 0x17, 0x04, 0x0B, 0xA8, 0x39, 0x3D, 0xDA, 0x20, 0x3C, 0x86, 0x3D, 0x20, 0x95, 0x05,
  0xC0, 0x20, 0xD2, 0x07, 0x06, 0x28, 0x90, 0x67, 0x77, 0x27, 0xC8, 0xE5, 0x71, 0x83, 0x35, 0x3D,
  0x37, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_person_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_person_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_phone_disabled 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_communication_phone_disabled_data[] PROGMEM = {
  0x72, 0x85, 0x23, 0x33, 0x0E, 0x76, 0x01, 0x0E, 0xB8, 0x23, 0x6F, 0x75, 0x04, 0xC8, 0x32, 0x06,
  0xF7, 0x40, 0x7B, 0x0E, 0x38, 0x16, 0xF7, 0x30, 0x10, 0xDA, 0x0A, 0x48, 0x16, 0xF7, 0x38, 0x22,
  0xDF, 0x55, 0x81, 0x6F, 0x73, 0x0A, 0x0D, 0x78, 0x56, 0xF7, 0x03, 0xF4, 0x48, 0x74, 0x71, 0x06,
  0xF7, 0x05, 0x30, 0x20, 0xEA, 0x84, 0xD1, 0x0A, 0xF7, 0x40, 0x4C, 0x84, 0xDA, 0xFB, 0xF7, 0x30,
  0x4D, 0x84, 0xD4, 0x06, 0xF7, 0x20, 0x3B, 0x0B, 0x05, 0x48, 0x16, 0xF7, 0x20, 0x30, 0x27, 0x10,
  0x60, 0xE1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_phone_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_phone_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_phone_enabled 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_communication_phone_enabled_data[] PROGMEM = {
  0x72, 0x02, 0x0F, 0x37, 0x30, 0xEB, 0x03, 0x71, 0x04, 0xC0, 0x27, 0x10, 0x6C, 0x72, 0x01, 0x0D,
  0xA0, 0xB7, 0x38, 0x21, 0xDF, 0x57, 0x40, 0xA0, 0xD7, 0x48, 0x15, 0xF4, 0x48, 0x14, 0x71, 0x38,
  0x13, 0xE8, 0x30, 0x20, 0xEA, 0x84, 0xD1, 0x05, 0xEA, 0x40, 0x4C, 0x82, 0xDA, 0xF8, 0x50, 0x4D,
  0x0D, 0x04, 0x60, 0x3B, 0x0B, 0x05, 0x72, 0x03, 0x02, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_phone_enabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_phone_enabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_phonelink_erase 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_communication_phonelink_erase_data[] PROGMEM = {
  0x28, 0x04, 0x14, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x20, 0x6F, 0xB0, 0x62, 0x06, 0xFB, 0x06, 0x20,
  0x69, 0x80, 0x47, 0x90, 0x62, 0x06, 0x0E, 0x71, 0x05, 0x02, 0x20, 0x60, 0xE6, 0x08, 0x04, 0x28,
  0x27, 0x46, 0xE6, 0x86, 0x8F, 0x59, 0xF4, 0x6E, 0x70, 0x9A, 0x82, 0x50, 0x6E, 0x70, 0x9A, 0x82,
  0x50, 0x6E, 0x68, 0x68, 0xF5, 0x9F, 0x46, 0xE6, 0x08, 0x04, 0x28, 0x27, 0x46, 0xE7, 0x10, 0x50,
  0x22, 0x06, 0x98, 0x04, 0x79, 0x06, 0x20, 0x6F, 0xB0, 0x62, 0x06, 0xFB, 0x06, 0x20, 0x20, 0xEF,
  0x90, 0xE0, 0x24, 0x80, 0x41, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_phonelink_erase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_communication_phonelink_erase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_phonelink_lock 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_communication_phonelink_lock_data[] PROGMEM = {
  0x28, 0x04, 0x13, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x06, 0xFB, 0x81, 0x60, 0x6F, 0xB8, 0x16, 0x06,
  0x98, 0x04, 0x79, 0x82, 0x60, 0x6E, 0x71, 0x83, 0x52, 0x06, 0xE7, 0x84, 0x39, 0x30, 0x6E, 0x78,
  0x4A, 0x1A, 0x06, 0xE6, 0x85, 0x9E, 0xDE, 0x96, 0xE6, 0x0B, 0xB8, 0x1B, 0x6E, 0x60, 0xBB, 0x81,
  0xB6, 0xE6, 0x85, 0x7B, 0xBB, 0x76, 0xE7, 0x18, 0x25, 0x20, 0x69, 0x80, 0x47, 0x98, 0x16, 0x06,
  0xFB, 0x81, 0x60, 0x6F, 0xB8, 0x26, 0x02, 0xEF, 0x90, 0xE0, 0x23, 0x80, 0x41, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_phonelink_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 15, 17), Box(0, 0, 17, 17),
      ic_round_18_communication_phonelink_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_phonelink_ring 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_communication_phonelink_ring_data[] PROGMEM = {
  0x28, 0x04, 0x15, 0x01, 0x0D, 0xF9, 0x0E, 0x03, 0x30, 0x4F, 0xB0, 0x73, 0x04, 0xFB, 0x07, 0x38,
  0x14, 0xF8, 0x80, 0x37, 0x0E, 0x07, 0x30, 0x49, 0x71, 0x81, 0x42, 0x52, 0x04, 0x97, 0x38, 0x2E,
  0x70, 0x49, 0x71, 0x84, 0x61, 0x7E, 0x04, 0x97, 0x18, 0x4E, 0x53, 0xF1, 0x49, 0x71, 0x84, 0xE6,
  0x3F, 0x24, 0x97, 0x18, 0x46, 0x17, 0xE0, 0x49, 0x73, 0x82, 0xE8, 0x04, 0x97, 0x18, 0x14, 0x26,
  0x28, 0x14, 0xF8, 0x80, 0x37, 0x0E, 0x07, 0x30, 0x4F, 0xB0, 0x73, 0x04, 0xFB, 0x07, 0x30, 0x10,
  0xDF, 0x90, 0xE0, 0x35, 0x80, 0x41, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_phonelink_ring() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_communication_phonelink_ring_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_phonelink_setup 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_communication_phonelink_setup_data[] PROGMEM = {
  0x28, 0x04, 0x14, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x20, 0x6F, 0xB0, 0x62, 0x06, 0xFB, 0x06, 0x20,
  0x69, 0x80, 0x47, 0x90, 0x62, 0x06, 0x0E, 0x71, 0x05, 0x02, 0x20, 0x60, 0xE7, 0x10, 0x90, 0x22,
  0x06, 0x0E, 0x68, 0x66, 0x9F, 0xC9, 0x06, 0xE6, 0x86, 0x7E, 0x3A, 0xD0, 0x6E, 0x68, 0x66, 0xE3,
  0xAD, 0x06, 0xE6, 0x86, 0x69, 0xFC, 0x91, 0x6E, 0x71, 0x09, 0x02, 0x20, 0x60, 0xE7, 0x10, 0x50,
  0x22, 0x06, 0x98, 0x04, 0x79, 0x06, 0x20, 0x6F, 0xB0, 0x62, 0x06, 0xFB, 0x06, 0x20, 0x20, 0xEF,
  0x90, 0xE0, 0x24, 0x80, 0x41, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_phonelink_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_communication_phonelink_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_phone 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_communication_phone_data[] PROGMEM = {
  0x10, 0xF3, 0x02, 0x72, 0x03, 0xB0, 0xE7, 0x20, 0x2C, 0x04, 0x72, 0xC0, 0x67, 0x20, 0xBA, 0x0D,
  0x01, 0x72, 0x82, 0x5F, 0xD1, 0x74, 0x0D, 0x0A, 0x75, 0x81, 0x4F, 0x57, 0x58, 0x18, 0xE3, 0x38,
  0x11, 0x64, 0x68, 0x4A, 0xE5, 0x01, 0xDA, 0x0E, 0x02, 0x58, 0x28, 0xFA, 0xDC, 0x04, 0x60, 0x40,
  0xDD, 0x04, 0x71, 0x05, 0x0B, 0xB0, 0x37, 0x40, 0x20, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_portable_wifi_off 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_18_communication_portable_wifi_off_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x04, 0x0B, 0xC0, 0xB0, 0x35, 0x89, 0x2E, 0x70, 0x9B, 0x63, 0x35, 0xBF, 0x94,
  0x81, 0x6F, 0x72, 0x86, 0x36, 0x62, 0x05, 0xF9, 0x30, 0x4A, 0x89, 0x17, 0x09, 0xEE, 0xF9, 0x05,
  0xF3, 0x28, 0x3B, 0xB6, 0xF7, 0x38, 0x44, 0xE9, 0x0B, 0xB2, 0x90, 0x50, 0x3A, 0x07, 0x38, 0x94,
  0x4F, 0x25, 0xF0, 0x2F, 0x36, 0xE6, 0xF7, 0x38, 0x94, 0xE6, 0x3F, 0x22, 0xF3, 0x6E, 0x06, 0xF7,
  0x28, 0xA1, 0xE6, 0x3F, 0x20, 0xF5, 0x3F, 0x40, 0x6F, 0x70, 0x93, 0x59, 0x28, 0x3B, 0xB0, 0x95,
  0x28, 0x16, 0xF7, 0x20, 0x0B, 0x28, 0x14, 0xF4, 0x58, 0x46, 0xF7, 0x09, 0x43, 0x07, 0x05, 0x68,
  0x16, 0xF7, 0x77, 0x81, 0x6F, 0x77, 0x70, 0x60, 0xE2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_portable_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_portable_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_present_to_all 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_communication_present_to_all_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x24,
  0x00, 0x34, 0x84, 0x2F, 0x33, 0xF2, 0x38, 0x23, 0xEE, 0x33, 0x84, 0x2F, 0x33, 0xF2, 0x30, 0xEA,
  0x0E, 0x38, 0x42, 0xF3, 0x3F, 0x24, 0x00, 0xA4, 0x84, 0x2F, 0x33, 0xF2, 0x40, 0x0A, 0x48, 0x42,
  0xF3, 0x3F, 0x24, 0x00, 0x54, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x82, 0x2F, 0x31, 0xFF, 0x81, 0x10,
  0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_present_to_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_present_to_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_print_disabled 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_communication_print_disabled_data[] PROGMEM = {
  0x48, 0x04, 0x35, 0x82, 0xE7, 0x09, 0xF0, 0x54, 0x83, 0x6F, 0x70, 0x9E, 0x07, 0x58, 0x16, 0xF7,
  0x18, 0x02, 0x50, 0x24, 0x85, 0x4A, 0xEF, 0x70, 0x58, 0x01, 0xB8, 0x2A, 0x40, 0x1D, 0x81, 0x70,
  0x9E, 0x01, 0x03, 0xE8, 0x47, 0x09, 0xFB, 0x4A, 0x00, 0x3F, 0x83, 0x70, 0x9E, 0xBA, 0x00, 0x3F,
  0x98, 0x17, 0x09, 0xB0, 0x30, 0x2B, 0x87, 0xD3, 0x33, 0x7F, 0x70, 0x9A, 0x84, 0x20, 0x79, 0xCD,
  0x48, 0x46, 0xF7, 0x07, 0x74, 0x07, 0x0D, 0x58, 0x16, 0xF7, 0x60, 0x5F, 0xA0, 0x76, 0x80, 0x43,
  0x06, 0x0E, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_print_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_print_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_qr_code_2 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_18_communication_qr_code_2_data[] PROGMEM = {
  0x83, 0x6B, 0xBB, 0x62, 0x8B, 0x1B, 0x56, 0xBB, 0xB6, 0xB9, 0x79, 0xB1, 0x3B, 0x5B, 0x97, 0x9B,
  0xB6, 0xF6, 0xB7, 0x92, 0x8C, 0x7B, 0x6F, 0x6B, 0xB9, 0x59, 0xB7, 0xFB, 0x5B, 0x95, 0x9B, 0x6B,
  0xBB, 0x65, 0xBB, 0x56, 0xBB, 0xB6, 0x55, 0x05, 0x77, 0x75, 0x28, 0x61, 0x71, 0x0B, 0xB0, 0xBB,
  0x0B, 0x28, 0x13, 0xF3, 0x28, 0x53, 0xF3, 0x3F, 0x33, 0xA8, 0x7B, 0x0B, 0xB0, 0x17, 0x11, 0x80,
  0x17, 0x89, 0x25, 0x0B, 0xB6, 0xBB, 0xB6, 0x0B, 0xB4, 0x0F, 0xB8, 0x79, 0x79, 0xB0, 0xBB, 0x0B,
  0xA8, 0xC1, 0x30, 0xB6, 0xF6, 0xB0, 0xBB, 0x05, 0x9F, 0x30, 0xB9, 0x59, 0xB0, 0x25, 0xB2, 0x3F,
  0xC8, 0x6B, 0xBB, 0x62, 0x85, 0x2B, 0x22, 0xBB, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_qr_code_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_qr_code_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_qr_code 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_communication_qr_code_data[] PROGMEM = {
  0x10, 0xF5, 0x03, 0x28, 0xA1, 0x35, 0x55, 0x05, 0xB7, 0x7D, 0x11, 0xD7, 0x7B, 0x56, 0x62, 0x82,
  0xB1, 0x1B, 0x28, 0x00, 0x62, 0x82, 0xB1, 0x1B, 0x28, 0x56, 0x63, 0xDB, 0xBD, 0x28, 0x3D, 0xBB,
  0xD3, 0x10, 0xF1, 0x40, 0xF1, 0x20, 0xF1, 0x30, 0x14, 0x89, 0x43, 0xDB, 0xBD, 0x01, 0xA5, 0x87,
  0x46, 0x62, 0x89, 0x0B, 0x10, 0x58, 0x66, 0x16, 0x62, 0x8A, 0x7B, 0x10, 0x86, 0x76, 0x35, 0xB7,
  0x7D, 0x10, 0x76, 0x66, 0x30, 0x55, 0x53, 0x28, 0x34, 0x13, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_qr_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_qr_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_qr_code_scanner 18x18, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_round_18_communication_qr_code_scanner_data[] PROGMEM = {
  0x82, 0x17, 0x76, 0x71, 0x83, 0x67, 0x71, 0x7A, 0x0E, 0x01, 0x60, 0x10, 0xEA, 0x8C, 0x37, 0x7F,
  0x13, 0x33, 0x31, 0x13, 0x33, 0x31, 0xF7, 0x6E, 0x3F, 0xDD, 0xF3, 0x3F, 0xDD, 0xF3, 0xE6, 0x01,
  0x3D, 0x28, 0x2D, 0x33, 0xD2, 0x81, 0xD3, 0x13, 0x03, 0x0D, 0x28, 0x2D, 0x33, 0xD2, 0x0D, 0x03,
  0x48, 0x92, 0x3F, 0xDD, 0xF3, 0x3F, 0xDD, 0xF3, 0x48, 0x92, 0x13, 0x33, 0x31, 0x13, 0x33, 0x31,
  0x48, 0x90, 0x13, 0x33, 0x31, 0x13, 0x03, 0x68, 0x91, 0x3F, 0xDD, 0xF3, 0x3C, 0x1D, 0x35, 0x03,
  0x0D, 0x28, 0x6D, 0x30, 0x1F, 0x0D, 0x33, 0x81, 0x13, 0xD2, 0x8C, 0x0D, 0x33, 0xD0, 0xF1, 0x01,
  0x06, 0xE3, 0xFD, 0xDF, 0x30, 0x3D, 0x1C, 0x3E, 0x67, 0xF1, 0x33, 0x33, 0x12, 0x85, 0x30, 0x31,
  0xF7, 0x7A, 0x0E, 0x01, 0x60, 0x10, 0xEA, 0x83, 0x71, 0x77, 0x67, 0x18, 0x26, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_qr_code_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_qr_code_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_read_more 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_communication_read_more_data[] PROGMEM = {
  0x50, 0x32, 0x84, 0xAB, 0xBB, 0xB2, 0x50, 0xC0, 0x61, 0x80, 0x13, 0x18, 0xB2, 0x17, 0x77, 0x7D,
  0xF6, 0x01, 0x77, 0x71, 0x17, 0x77, 0x7D, 0xF6, 0x01, 0x77, 0x71, 0x50, 0xC0, 0x61, 0x80, 0x13,
  0x60, 0x32, 0x84, 0xAB, 0xBB, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_read_more() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 15, 11), Box(0, 0, 17, 17),
      ic_round_18_communication_read_more_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_ring_volume 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_communication_ring_volume_data[] PROGMEM = {
  0x70, 0x09, 0x77, 0x00, 0xA7, 0x18, 0x11, 0xA1, 0x30, 0x0A, 0x38, 0x11, 0xA1, 0x38, 0x1C, 0xD1,
  0x20, 0x02, 0x28, 0x11, 0xDC, 0x48, 0x11, 0xC8, 0x68, 0x18, 0xC1, 0x80, 0xC2, 0x08, 0x65, 0xAD,
  0xEE, 0xDA, 0x56, 0x89, 0x26, 0xEF, 0xC7, 0x55, 0x7C, 0xFE, 0x62, 0x01, 0x0B, 0xB0, 0x44, 0x04,
  0xB8, 0x1B, 0x1C, 0xC0, 0x44, 0x04, 0xC0, 0xC0, 0xEB, 0x0E, 0x02, 0x40, 0x20, 0xEB, 0x84, 0xE2,
  0xEF, 0xB1, 0x68, 0x61, 0xBF, 0xE2, 0x02, 0x57, 0x30, 0x50, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_ring_volume() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_ring_volume_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_rss_feed 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_communication_rss_feed_data[] PROGMEM = {
  0x10, 0x20, 0x17, 0x40, 0x2A, 0x81, 0xEA, 0x47, 0x28, 0x17, 0xAD, 0xA0, 0xC0, 0x47, 0x30, 0x30,
  0xAA, 0x08, 0x74, 0x82, 0x3D, 0xFA, 0x48, 0x21, 0xA8, 0x43, 0x82, 0x1C, 0xF8, 0x30, 0x20, 0xEA,
  0x0C, 0x03, 0x28, 0x21, 0xDF, 0x43, 0x81, 0x15, 0xAA, 0x05, 0x28, 0x13, 0xFC, 0x68, 0x25, 0xEF,
  0x32, 0x81, 0xAF, 0x46, 0x81, 0x5F, 0xC2, 0x81, 0x3F, 0xA2, 0x03, 0x04, 0x38, 0x1B, 0xF4, 0x28,
  0x2D, 0xE0, 0x2A, 0x04, 0x28, 0x15, 0xF8, 0x28, 0x2A, 0xF1, 0x2A, 0x03, 0x28, 0x11, 0xEA, 0x28,
  0x47, 0xF2, 0x02, 0x24, 0x02, 0x01, 0x30, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_rss_feed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_rss_feed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_rtt 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_communication_rtt_data[] PROGMEM = {
  0x50, 0x18, 0x03, 0x30, 0x25, 0x0D, 0xF9, 0x18, 0xA5, 0x37, 0x71, 0xFD, 0x7D, 0xF8, 0x7E, 0xE0,
  0x6D, 0xC5, 0xF8, 0x0D, 0xE2, 0x90, 0xB4, 0x8A, 0x24, 0xF4, 0x0F, 0xC0, 0x1F, 0x80, 0xAB, 0x70,
  0x10, 0x3F, 0x92, 0x01, 0x28, 0x17, 0x74, 0x38, 0x16, 0xF6, 0x58, 0x00, 0x12, 0x81, 0x9F, 0x34,
  0x07, 0xC2, 0x0B, 0x96, 0x80, 0x03, 0x20, 0xE0, 0xD5, 0x87, 0x45, 0x55, 0x20, 0x1F, 0xA5, 0x0C,
  0xB8, 0x47, 0x19, 0xFB, 0x47, 0x20, 0x7B, 0x0C, 0x73, 0x0F, 0x30, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_rtt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_rtt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_screen_share 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_communication_screen_share_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x81, 0xE1, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F,
  0x81, 0xE2, 0xDC, 0x00, 0x3C, 0x0C, 0x02, 0x30, 0x2C, 0x00, 0x3C, 0x84, 0x51, 0x98, 0x0A, 0xC0,
  0x03, 0xC0, 0x05, 0xA0, 0xDD, 0x00, 0x3C, 0x00, 0xDF, 0x90, 0x30, 0x2F, 0xF8, 0x12, 0x0C, 0xFD,
  0x0C, 0x77, 0x30, 0xEF, 0xF0, 0xE8, 0x09, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_send_time_extension 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_communication_send_time_extension_data[] PROGMEM = {
  0x58, 0x24, 0xEE, 0x47, 0x83, 0x23, 0x33, 0xCA, 0x83, 0xC3, 0x33, 0x22, 0x02, 0xFD, 0x81, 0x20,
  0x4F, 0xD8, 0x14, 0x04, 0xFD, 0x81, 0x40, 0x4F, 0xD8, 0x24, 0x01, 0x6C, 0x81, 0x84, 0xCC, 0x04,
  0x30, 0x9B, 0x08, 0x20, 0x40, 0xCA, 0x04, 0x30, 0x9B, 0x89, 0x18, 0x1A, 0x30, 0x4C, 0x40, 0x16,
  0xC0, 0x80, 0x1A, 0x0A, 0x03, 0x30, 0x4D, 0x81, 0x81, 0xDB, 0x82, 0xA3, 0x04, 0xD0, 0x82, 0x04,
  0x0D, 0xB0, 0x80, 0x4D, 0x81, 0x50, 0xAB, 0x82, 0xD6, 0x02, 0xC8, 0x16, 0x01, 0xA0, 0xD0, 0x64,
  0x02, 0x0F, 0x32, 0x81, 0x1D, 0x65,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_send_time_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_send_time_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_sentiment_satisfied_alt 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_communication_sentiment_satisfied_alt_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBA, 0x81, 0xC5, 0xCA, 0x81, 0xC5, 0xCA, 0x0B, 0x2B, 0x81, 0x70, 0x6A, 0x81,
  0x60, 0x7B, 0x10, 0x2B, 0x81, 0xD7, 0xDA, 0x81, 0xD7, 0xDB, 0x00, 0x2F, 0xF0, 0x21, 0xB8, 0x1D,
  0x7E, 0xA8, 0x1E, 0x7D, 0xB2, 0x0B, 0xA8, 0x6D, 0x02, 0x89, 0x30, 0xDA, 0x0B, 0x20, 0x3B, 0x0C,
  0x04, 0x20, 0x40, 0xCB, 0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_sentiment_satisfied_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_sentiment_satisfied_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_sip 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_communication_sip_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3A, 0x89,
  0x0C, 0x43, 0xEA, 0xAD, 0x34, 0xCA, 0x00, 0x3A, 0x89, 0x08, 0x38, 0xF8, 0x8C, 0x48, 0x7A, 0x00,
  0x3A, 0x89, 0x0E, 0x61, 0xD8, 0x8C, 0x02, 0xBA, 0x00, 0x3A, 0x86, 0xA3, 0x5F, 0xAA, 0xD7, 0xC0,
  0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_speaker_phone 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_communication_speaker_phone_data[] PROGMEM = {
  0x18, 0x14, 0xAE, 0xA8, 0xA6, 0xEA, 0x40, 0x9F, 0xB6, 0x44, 0x6B, 0xF9, 0x53, 0x02, 0x55, 0x20,
  0x35, 0x20, 0xAC, 0x0A, 0x40, 0x50, 0x42, 0x04, 0x05, 0x77, 0x84, 0xAB, 0xBB, 0xBA, 0x30, 0x2E,
  0x02, 0x20, 0x20, 0xB4, 0x0B, 0x02, 0x20, 0x20, 0xB4, 0x0B, 0x02, 0x20, 0x20, 0xB4, 0x0B, 0x02,
  0x20, 0x20, 0xB4, 0x0B, 0x02, 0x20, 0x20, 0xB4, 0x0B, 0x02, 0x28, 0x62, 0xE9, 0x99, 0x9E, 0x22,
  0x01, 0xE0, 0x13, 0x84, 0x13, 0x33, 0x31, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_speaker_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_speaker_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_spoke 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_communication_spoke_data[] PROGMEM = {
  0x60, 0x03, 0x74, 0x0B, 0xA0, 0xB7, 0x20, 0x7C, 0x07, 0x71, 0x0A, 0xC0, 0xA7, 0x10, 0x6C, 0x06,
  0x72, 0x09, 0xA0, 0x97, 0x77, 0x76, 0x83, 0x4D, 0xFC, 0x22, 0x86, 0x2C, 0xFD, 0x40, 0x1E, 0xB0,
  0xC2, 0x0C, 0xB8, 0x1E, 0x13, 0xD2, 0xD0, 0x30, 0x1C, 0x0D, 0x20, 0xDC, 0x81, 0x10, 0x6A, 0x0E,
  0x04, 0x20, 0x40, 0xEA, 0x06, 0x30, 0x10, 0x36, 0x03, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_spoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_spoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_stay_current_landscape 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_communication_stay_current_landscape_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x25, 0x02, 0x20, 0xEF, 0xF8, 0x1E, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B,
  0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB0, 0x01,
  0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00,
  0x1B, 0x07, 0x71, 0x07, 0xB8, 0x11, 0x0E, 0xFF, 0x0E, 0x20, 0x28, 0x09, 0x25, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_stay_current_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_stay_current_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_stay_current_portrait 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_communication_stay_current_portrait_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x81, 0xE6, 0x69, 0x80, 0x47, 0x90, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x2E, 0xF9, 0x0E, 0x02,
  0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_stay_current_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_communication_stay_current_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_stay_primary_landscape 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_communication_stay_primary_landscape_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x25, 0x02, 0x20, 0xEF, 0xF8, 0x1E, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B,
  0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB0, 0x01,
  0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00,
  0x1B, 0x07, 0x71, 0x07, 0xB8, 0x11, 0x0E, 0xFF, 0x0E, 0x20, 0x28, 0x09, 0x25, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_stay_primary_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_stay_primary_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_stay_primary_portrait 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_communication_stay_primary_portrait_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x81, 0xE6, 0x69, 0x80, 0x47, 0x90, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x2E, 0xF9, 0x0E, 0x02,
  0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_stay_primary_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_communication_stay_primary_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_stop_screen_share 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_communication_stop_screen_share_data[] PROGMEM = {
  0x00, 0x72, 0x80, 0x63, 0x85, 0x10, 0x6F, 0x70, 0x9F, 0xA8, 0x1E, 0x13, 0xA8, 0x17, 0x09, 0xFA,
  0x00, 0x3B, 0x81, 0x70, 0x9F, 0x90, 0x03, 0xC8, 0x47, 0x09, 0xE2, 0xDC, 0x00, 0x3D, 0x07, 0x30,
  0x2C, 0x00, 0x3C, 0x81, 0xBF, 0x72, 0x0A, 0xC0, 0x03, 0xC8, 0x45, 0x8F, 0x70, 0x9C, 0x00, 0x3C,
  0x00, 0xDA, 0x81, 0x70, 0x9B, 0x03, 0x02, 0xFA, 0x81, 0x70, 0x9A, 0x81, 0x20, 0xCF, 0xA8, 0x27,
  0x09, 0xC7, 0x48, 0x16, 0xF7, 0x30, 0xEF, 0xD0, 0x72, 0x80, 0x90, 0x38, 0x17, 0xF7, 0x77, 0x06,
  0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_stop_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_stop_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_swap_calls 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_communication_swap_calls_data[] PROGMEM = {
  0x38, 0x11, 0x53, 0x50, 0x14, 0x04, 0x0E, 0xA0, 0xA3, 0x81, 0x6F, 0x63, 0x86, 0xEA, 0x03, 0xE6,
  0x04, 0xB8, 0x35, 0x02, 0xF3, 0x28, 0x92, 0xA9, 0x01, 0x5F, 0x51, 0x02, 0xF2, 0x20, 0x0A, 0x28,
  0x12, 0xF2, 0x28, 0x12, 0xF2, 0x20, 0x0A, 0x28, 0x12, 0xF2, 0x28, 0x12, 0xF2, 0x20, 0x0A, 0x28,
  0x12, 0xF2, 0x28, 0x12, 0xF2, 0x20, 0x0A, 0x28, 0x92, 0x2F, 0x20, 0x15, 0xF5, 0x10, 0x9A, 0x28,
  0x33, 0xF2, 0x05, 0xB8, 0x64, 0x06, 0xE3, 0x0A, 0xE3, 0x81, 0x6F, 0x63, 0x0A, 0xA0, 0xE0, 0x44,
  0x01, 0x58, 0x13, 0x51, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_swap_calls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_swap_calls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_textsms 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_communication_textsms_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F,
  0xF0, 0x03, 0xB8, 0x68, 0x6F, 0x77, 0xF6, 0x8B, 0x00, 0x3B, 0x86, 0xED, 0xFD, 0xDF, 0xDE, 0xB0,
  0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x10, 0x3A, 0x09, 0x80, 0x67, 0x83,
  0x40, 0x3F, 0x77, 0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_textsms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_textsms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_unsubscribe 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_communication_unsubscribe_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x03, 0x20, 0x1F, 0xF8, 0x41, 0x03, 0xFA, 0xBF, 0x98, 0x91, 0xBA, 0xF3,
  0x03, 0xF5, 0x04, 0xDC, 0x86, 0xD4, 0x05, 0xF3, 0x03, 0xA8, 0x90, 0xA2, 0x06, 0xEE, 0x60, 0x2A,
  0xA8, 0x13, 0x03, 0xC8, 0x93, 0x80, 0x11, 0x08, 0xDA, 0x9A, 0x20, 0x3D, 0x83, 0xD6, 0x6D, 0x86,
  0x03, 0xF9, 0x87, 0x70, 0x7E, 0xFD, 0x50, 0x3F, 0x81, 0xD0, 0x7D, 0x04, 0x03, 0xF0, 0x81, 0xE0,
  0xC0, 0x1F, 0x82, 0x72, 0xFB, 0x38, 0x2E, 0xE0, 0x38, 0x02, 0x50, 0x31, 0xE0, 0xC7, 0x30, 0x7D,
  0x04, 0x74, 0x83, 0x7E, 0xFD, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_unsubscribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_communication_unsubscribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_voicemail 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_communication_voicemail_data[] PROGMEM = {
  0x28, 0x23, 0x77, 0x24, 0x82, 0x27, 0x73, 0x38, 0x45, 0xFD, 0xDF, 0x42, 0x84, 0x4F, 0xDD, 0xF5,
  0x20, 0xE0, 0x82, 0x0A, 0x0D, 0x20, 0xD0, 0xA2, 0x84, 0x8E, 0x02, 0xF3, 0x20, 0x49, 0x29, 0x04,
  0x28, 0x43, 0xF2, 0x0E, 0x72, 0x09, 0x0E, 0x20, 0xE0, 0x92, 0x07, 0x0E, 0x28, 0x94, 0x6F, 0xBC,
  0xFD, 0x99, 0xDF, 0xCB, 0xF6, 0x30, 0x40, 0xA8, 0x04, 0xB0, 0xA0, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_voicemail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 11), Box(0, 0, 17, 17),
      ic_round_18_communication_voicemail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_vpn_key_off 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_communication_vpn_key_off_data[] PROGMEM = {
  0x10, 0xE0, 0x77, 0x78, 0x16, 0xF7, 0x76, 0x06, 0xA0, 0x77, 0x40, 0x4C, 0x07, 0x73, 0x0C, 0xA8,
  0x47, 0x7F, 0x70, 0x18, 0x02, 0x50, 0x1A, 0x0B, 0x28, 0x36, 0xF7, 0x09, 0xD0, 0xEA, 0x0B, 0x38,
  0x3E, 0xF7, 0x09, 0xC0, 0xE0, 0xCA, 0x81, 0x73, 0x9B, 0x81, 0x70, 0x9A, 0x81, 0x81, 0x3E, 0x86,
  0xE7, 0xF7, 0x09, 0xF4, 0x20, 0x50, 0xEB, 0x87, 0xD3, 0x06, 0xF7, 0x09, 0x33, 0x82, 0x14, 0x75,
  0x48, 0x16, 0xF7, 0x77, 0x81, 0x6F, 0x77, 0x70, 0x60, 0xE2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_vpn_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_communication_vpn_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_vpn_key 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_communication_vpn_key_data[] PROGMEM = {
  0x28, 0x21, 0x55, 0x47, 0x40, 0x60, 0xEB, 0x0D, 0x03, 0x71, 0x04, 0xE0, 0xE0, 0x17, 0x0C, 0xA8,
  0x17, 0x3A, 0xA0, 0xA8, 0x02, 0x50, 0x1A, 0x0B, 0x30, 0xEF, 0x90, 0xEA, 0x0B, 0x30, 0xEF, 0x90,
  0xE0, 0xCA, 0x81, 0x73, 0xAA, 0x82, 0xA5, 0x59, 0xA8, 0x18, 0x14, 0xE0, 0xE0, 0x12, 0x06, 0xA0,
  0x42, 0x06, 0x0E, 0xB0, 0xD0, 0x33, 0x04, 0xA0, 0x33, 0x82, 0x15, 0x74, 0x60, 0x05, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_vpn_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_communication_vpn_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_communication_wifi_calling 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_communication_wifi_calling_data[] PROGMEM = {
  0x18, 0x13, 0x53, 0x48, 0x43, 0x54, 0x10, 0x3B, 0x82, 0x10, 0x3D, 0xC0, 0x80, 0x3B, 0x82, 0x30,
  0x1E, 0xC0, 0x61, 0xB0, 0x32, 0x04, 0xB0, 0xA2, 0x81, 0xBF, 0x94, 0x81, 0x7F, 0xC3, 0x81, 0x5F,
  0x15, 0x09, 0x02, 0x40, 0xC0, 0x97, 0x48, 0x12, 0xE7, 0x30, 0x02, 0x68, 0x34, 0xE9, 0x07, 0xA0,
  0xE0, 0x35, 0x81, 0x2C, 0xEC, 0x07, 0x70, 0x60, 0xCB, 0x06, 0x72, 0x81, 0x14, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_communication_wifi_calling() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_communication_wifi_calling_data, Alpha4(color::Black));
  return value;
}
