#include "hardware.h"

using namespace roo_display;

// Image file ic_filled_48_hardware_adf_scanner 48x48, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_filled_48_hardware_adf_scanner_data[] PROGMEM = {
  0x71, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xC7,
  0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7,
  0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7,
  0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x48, 0x16,
  0xCE, 0xFF, 0xFF, 0x81, 0xEC, 0x64, 0x01, 0x0C, 0xFF, 0xFF, 0xE0, 0xC0, 0x12, 0x0C, 0x80, 0xC0,
  0xF8, 0x1C, 0x06, 0x80, 0xC2, 0xF0, 0x60, 0xC8, 0x0C, 0x2F, 0x0C, 0x0E, 0x80, 0xC2, 0xF0, 0xEF,
  0xFF, 0xFA, 0x82, 0xB1, 0x1B, 0x80, 0xC0, 0xF0, 0x12, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x01, 0x80,
  0xC0, 0xF8, 0x2B, 0x11, 0xB8, 0x0B, 0xE2, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_adf_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_adf_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_browser_not_supported 48x48, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_filled_48_hardware_browser_not_supported_data[] PROGMEM = {
  0x20, 0x28, 0x0C, 0x00, 0x81, 0x6F, 0x47, 0x77, 0x76, 0x06, 0xB0, 0x44, 0x07, 0xFF, 0xFB, 0x83,
  0xDA, 0x10, 0xBC, 0x04, 0x40, 0x7F, 0xFF, 0xC8, 0x2E, 0x10, 0xBC, 0x04, 0x40, 0x7F, 0xFF, 0xC0,
  0xA2, 0xD0, 0x44, 0x07, 0xFF, 0xFB, 0x0D, 0x2E, 0x04, 0x77, 0x74, 0xC2, 0xF0, 0x47, 0x77, 0x3C,
  0x2F, 0x90, 0x47, 0x77, 0x2C, 0x2C, 0x0B, 0xC0, 0x47, 0x77, 0x1C, 0x2C, 0x10, 0xBC, 0x04, 0x77,
  0x7C, 0x2C, 0x20, 0xBC, 0x04, 0x77, 0x6C, 0x2C, 0x30, 0xBC, 0x04, 0x77, 0x5C, 0x2C, 0x40, 0xBC,
  0x04, 0x77, 0x4C, 0x2C, 0x50, 0xBC, 0x04, 0x77, 0x3C, 0x2C, 0x60, 0xBC, 0x04, 0x77, 0x2C, 0x2C,
  0x70, 0xBC, 0x04, 0x77, 0x1C, 0x2C, 0x71, 0x0B, 0xC0, 0x47, 0x7C, 0x2C, 0x72, 0x0B, 0xC0, 0x47,
  0x6C, 0x2C, 0x73, 0x0B, 0xC0, 0x47, 0x5C, 0x2C, 0x74, 0x0B, 0xC0, 0x47, 0x4C, 0x2C, 0x75, 0x0B,
  0xC0, 0x47, 0x3C, 0x2C, 0x76, 0x0B, 0xC0, 0x47, 0x2C, 0x2C, 0x77, 0x0B, 0xC0, 0x47, 0x1C, 0x2C,
  0x77, 0x10, 0xBC, 0x04, 0x7C, 0x2C, 0x77, 0x20, 0xBC, 0x04, 0x6C, 0x2C, 0x77, 0x30, 0xBC, 0x04,
  0x5C, 0x2C, 0x77, 0x40, 0xBC, 0x04, 0x40, 0x7B, 0x2C, 0x77, 0x50, 0xBC, 0x04, 0x40, 0x7A, 0x2C,
  0x77, 0x60, 0xBC, 0x04, 0x40, 0x79, 0x20, 0xDF, 0xFF, 0xF9, 0x04, 0x40, 0x62, 0x0A, 0xFF, 0xFF,
  0xA0, 0x46, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0x46, 0x81, 0x1A, 0xDF, 0xFF, 0xF9, 0x04, 0x77, 0x77,
  0x50, 0xBC, 0x04, 0x77, 0x77, 0x50, 0xBC, 0x02, 0x77, 0x77, 0x50, 0xBA, 0x07, 0x77, 0x77, 0x70,
  0xB0, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_browser_not_supported() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 41, 43), Box(0, 0, 47, 47),
      ic_filled_48_hardware_browser_not_supported_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_browser_updated 48x48, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_filled_48_hardware_browser_updated_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xA4, 0xC7, 0x50, 0x10, 0xEF, 0xFC, 0x4C, 0x75, 0x0A, 0xFF, 0xD4, 0xC7,
  0x50, 0xDF, 0xFD, 0x4C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C,
  0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C,
  0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x50, 0x7F, 0xFC, 0x07, 0x4C, 0x76, 0x07,
  0xFF, 0xA0, 0x75, 0xC7, 0x70, 0x7F, 0xF0, 0x76, 0xC7, 0x71, 0x07, 0xFD, 0x07, 0x7C, 0x77, 0x20,
  0x7F, 0xB0, 0x77, 0x1C, 0x77, 0x30, 0x7F, 0x90, 0x77, 0x2C, 0x77, 0x40, 0x7E, 0x07, 0x6F, 0x97,
  0x75, 0x07, 0xC0, 0x77, 0xF9, 0x77, 0x60, 0x7A, 0x07, 0x71, 0xF9, 0x77, 0x70, 0x07, 0x72, 0xF9,
  0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A,
  0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x17, 0x30, 0x7F, 0xFE,
  0x07, 0x77, 0x30, 0x7F, 0xFF, 0x90, 0x77, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF,
  0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_browser_updated() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_browser_updated_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_cast_connected 48x48, 4-bit Alpha,  RLE, 272 bytes.
static const unsigned char ic_filled_48_hardware_cast_connected_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x4F, 0xFF, 0xF4, 0xF9, 0x4F, 0xFF, 0xF4, 0xC7, 0x1F, 0xFF, 0xF4,
  0xC7, 0x10, 0x70, 0xDF, 0xFF, 0xD4, 0xC7, 0x30, 0x30, 0xBF, 0xFF, 0xB4, 0xC7, 0x50, 0x30, 0xCF,
  0xFF, 0x94, 0xD8, 0x3D, 0xDA, 0x84, 0x71, 0x07, 0xFF, 0xF4, 0xFC, 0x0A, 0x04, 0x60, 0x30, 0xDF,
  0xFD, 0x4F, 0xE0, 0xC0, 0x45, 0x01, 0x0C, 0xFF, 0xC4, 0xFF, 0x90, 0xB0, 0x25, 0x0B, 0xFF, 0xB4,
  0xC1, 0x83, 0x23, 0x59, 0xEE, 0x0E, 0x05, 0x50, 0xCF, 0xFA, 0x4C, 0x60, 0x30, 0xAE, 0x08, 0x40,
  0x10, 0xDF, 0xF9, 0x4C, 0x71, 0x03, 0x0B, 0xD0, 0x94, 0x03, 0xFF, 0x94, 0xC7, 0x30, 0x6D, 0x07,
  0x40, 0x7F, 0xF4, 0xC8, 0x3E, 0xDB, 0x73, 0x60, 0x40, 0xEC, 0x05, 0x40, 0xCF, 0xE4, 0xFA, 0x0D,
  0x05, 0x50, 0x20, 0xEB, 0x0E, 0x02, 0x30, 0x3F, 0xE4, 0xFC, 0x0C, 0x02, 0x40, 0x4C, 0x0B, 0x40,
  0xBF, 0xD4, 0xFD, 0x0E, 0x03, 0x40, 0x6C, 0x05, 0x30, 0x3F, 0xD4, 0xC1, 0x81, 0x25, 0xAE, 0x03,
  0x40, 0xBB, 0x0C, 0x40, 0xDF, 0xC4, 0xC4, 0x02, 0x0A, 0xC0, 0xE0, 0x23, 0x03, 0xC0, 0x43, 0x07,
  0xFC, 0x4C, 0x60, 0x7C, 0x0C, 0x40, 0xAB, 0x0A, 0x77, 0x5C, 0x70, 0x7C, 0x05, 0x30, 0x3B, 0x0E,
  0x77, 0x5C, 0x81, 0xEC, 0x65, 0x0A, 0xB0, 0xD4, 0x0E, 0xB0, 0x47, 0x74, 0xF0, 0xC0, 0x13, 0x02,
  0xC0, 0x33, 0x09, 0xB0, 0x87, 0x74, 0xF9, 0x0C, 0x40, 0xAB, 0x07, 0x30, 0x5B, 0x0A, 0x4F, 0xFB,
  0x0D, 0xD0, 0x63, 0x05, 0xB0, 0xB3, 0x03, 0xB0, 0xD4, 0xFF, 0xB0, 0xAD, 0x0C, 0x30, 0x2B, 0x0D,
  0x30, 0x2B, 0x0E, 0x4F, 0xFA, 0x0E, 0x01, 0xD0, 0xE4, 0xB0, 0xE4, 0xC4, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_cast_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_cast_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_cast_for_education 48x48, 4-bit Alpha,  RLE, 320 bytes.
static const unsigned char ic_filled_48_hardware_cast_for_education_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x77, 0x78,
  0x22, 0xBB, 0x27, 0x4F, 0x97, 0x75, 0x01, 0x09, 0xC0, 0x90, 0x17, 0x2F, 0x97, 0x73, 0x01, 0x08,
  0xF9, 0x08, 0x01, 0x7F, 0x97, 0x72, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x6C, 0x77, 0x40, 0x50, 0xDF,
  0xF0, 0xD0, 0x54, 0xC7, 0x72, 0x04, 0x0C, 0xFF, 0xC0, 0xC0, 0x42, 0xC7, 0x72, 0x04, 0x0C, 0xFF,
  0xC0, 0xC0, 0x42, 0xC7, 0x74, 0x05, 0x0D, 0xFF, 0x0D, 0x05, 0x4D, 0x83, 0xDD, 0xA8, 0x47, 0x70,
  0x70, 0xEF, 0xB0, 0xE0, 0x76, 0xFC, 0x0A, 0x04, 0x75, 0x01, 0x08, 0xF9, 0x08, 0x01, 0x7F, 0xE0,
  0xC0, 0x47, 0x28, 0x38, 0x10, 0x19, 0xC8, 0x39, 0x10, 0x18, 0x6F, 0xF9, 0x0B, 0x02, 0x79, 0x0E,
  0x07, 0x28, 0x22, 0xBB, 0x22, 0x07, 0x0E, 0x96, 0xC1, 0x83, 0x23, 0x59, 0xEE, 0x0E, 0x05, 0x6B,
  0x0D, 0x05, 0x40, 0x50, 0xDB, 0x6C, 0x60, 0x30, 0xAE, 0x08, 0x5D, 0x82, 0xC4, 0x4C, 0xD6, 0xC7,
  0x10, 0x30, 0xBD, 0x09, 0x40, 0x70, 0xEF, 0xB0, 0xE0, 0x76, 0xC7, 0x30, 0x6D, 0x07, 0x40, 0x10,
  0x8F, 0x90, 0x80, 0x17, 0xC8, 0x3E, 0xDB, 0x73, 0x60, 0x40, 0xEC, 0x05, 0x50, 0x10, 0x9C, 0x09,
  0x01, 0x72, 0xFA, 0x0D, 0x05, 0x50, 0x20, 0xEB, 0x0E, 0x02, 0x68, 0x22, 0xBB, 0x27, 0x4F, 0xC0,
  0xC0, 0x24, 0x04, 0xC0, 0xB7, 0x77, 0xFD, 0x0E, 0x03, 0x40, 0x6C, 0x05, 0x77, 0x6C, 0x18, 0x12,
  0x5A, 0xE0, 0x34, 0x0B, 0xB0, 0xC7, 0x76, 0xC4, 0x02, 0x0A, 0xC0, 0xE0, 0x23, 0x03, 0xC0, 0x47,
  0x75, 0xC6, 0x07, 0xC0, 0xC4, 0x0A, 0xB0, 0xA7, 0x75, 0xC7, 0x07, 0xC0, 0x53, 0x03, 0xB0, 0xE7,
  0x75, 0xC8, 0x1E, 0xC6, 0x50, 0xAB, 0x0D, 0x40, 0xEB, 0x04, 0x77, 0x4F, 0x0C, 0x01, 0x30, 0x2C,
  0x03, 0x30, 0x9B, 0x08, 0x77, 0x4F, 0x90, 0xC4, 0x0A, 0xB0, 0x73, 0x05, 0xB0, 0xA4, 0xFF, 0xB0,
  0xDD, 0x06, 0x30, 0x5B, 0x0B, 0x30, 0x3B, 0x0D, 0x4F, 0xFB, 0x0A, 0xD0, 0xC3, 0x02, 0xB0, 0xD3,
  0x02, 0xB0, 0xE4, 0xFF, 0xA0, 0xE0, 0x1D, 0x0E, 0x4B, 0x0E, 0x4C, 0x4F, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_cast_for_education() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_cast_for_education_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_cast 48x48, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_filled_48_hardware_cast_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC8, 0x0C, 0x40, 0xC8, 0x0C,
  0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xD8, 0x3D, 0xDA, 0x84, 0x77, 0x77, 0x6F, 0xC0, 0xA0,
  0x47, 0x77, 0x73, 0xFE, 0x0C, 0x04, 0x77, 0x77, 0x1F, 0xF9, 0x0B, 0x02, 0x77, 0x76, 0xC1, 0x83,
  0x23, 0x59, 0xEE, 0x0E, 0x05, 0x77, 0x75, 0xC6, 0x03, 0x0A, 0xE0, 0x87, 0x77, 0x4C, 0x71, 0x03,
  0x0B, 0xD0, 0x97, 0x77, 0x3C, 0x73, 0x06, 0xD0, 0x77, 0x77, 0x2C, 0x83, 0xED, 0xB7, 0x36, 0x04,
  0x0E, 0xC0, 0x57, 0x77, 0x1F, 0xA0, 0xD0, 0x55, 0x02, 0x0E, 0xB0, 0xE0, 0x27, 0x77, 0xFC, 0x0C,
  0x02, 0x40, 0x4C, 0x0B, 0x77, 0x7F, 0xD0, 0xE0, 0x34, 0x06, 0xC0, 0x57, 0x76, 0xC1, 0x81, 0x25,
  0xAE, 0x03, 0x40, 0xBB, 0x0C, 0x77, 0x6C, 0x40, 0x20, 0xAC, 0x0E, 0x02, 0x30, 0x3C, 0x04, 0x77,
  0x5C, 0x60, 0x7C, 0x0C, 0x40, 0xAB, 0x0A, 0x77, 0x5C, 0x70, 0x7C, 0x05, 0x30, 0x3B, 0x0E, 0x77,
  0x5C, 0x81, 0xEC, 0x65, 0x0A, 0xB0, 0xD4, 0x0E, 0xB0, 0x47, 0x74, 0xF0, 0xC0, 0x13, 0x02, 0xC0,
  0x33, 0x09, 0xB0, 0x87, 0x74, 0xF9, 0x0C, 0x40, 0xAB, 0x07, 0x30, 0x5B, 0x0A, 0x4F, 0xFB, 0x0D,
  0xD0, 0x63, 0x05, 0xB0, 0xB3, 0x03, 0xB0, 0xD4, 0xFF, 0xB0, 0xAD, 0x0C, 0x30, 0x2B, 0x0D, 0x30,
  0x2B, 0x0E, 0x4F, 0xFA, 0x0E, 0x01, 0xD0, 0xE4, 0xB0, 0xE4, 0xC4, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_cast() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_cast_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_computer 48x48, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_filled_48_hardware_computer_data[] PROGMEM = {
  0x58, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0x80, 0xC0, 0xF0, 0xE0, 0x17,
  0x10, 0xA8, 0x0C, 0x2F, 0x0A, 0x71, 0x0D, 0x80, 0xC2, 0xF0, 0xD7, 0x1C, 0x77, 0x77, 0x4C, 0x71,
  0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77,
  0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C,
  0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74,
  0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7,
  0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C,
  0x71, 0xC7, 0x77, 0x74, 0xC7, 0x10, 0xD8, 0x0C, 0x2F, 0x0D, 0x71, 0x0A, 0x80, 0xC2, 0xF0, 0x97,
  0x10, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x15,
  0x80, 0xAF, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_computer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_computer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_connected_tv 48x48, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_filled_48_hardware_connected_tv_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x28, 0x3E, 0xDB, 0x94,
  0x77, 0x77, 0x1F, 0x92, 0xD8, 0x1E, 0x91, 0x77, 0x75, 0xF9, 0x20, 0xEE, 0x0E, 0x07, 0x77, 0x74,
  0xF9, 0x48, 0x12, 0x6B, 0xC0, 0xC0, 0x17, 0x77, 0x2F, 0x97, 0x02, 0x0A, 0xB0, 0xD0, 0x27, 0x77,
  0x1F, 0x97, 0x20, 0x40, 0xEA, 0x0D, 0x01, 0x77, 0x7F, 0x92, 0x82, 0xED, 0x95, 0x40, 0x20, 0xDA,
  0x0C, 0x77, 0x7F, 0x92, 0xC0, 0xD0, 0x43, 0x02, 0x0E, 0xA0, 0x77, 0x76, 0xF9, 0x20, 0xDD, 0x08,
  0x30, 0x4A, 0x0E, 0x01, 0x77, 0x5F, 0x94, 0x05, 0x0C, 0xB0, 0x83, 0x0A, 0xA0, 0x97, 0x75, 0xF9,
  0x60, 0x7B, 0x04, 0x20, 0x2A, 0x0E, 0x77, 0x5F, 0x97, 0x07, 0xA0, 0xD3, 0x0B, 0xA0, 0x47, 0x74,
  0xF9, 0x28, 0x1E, 0xA1, 0x30, 0xCA, 0x05, 0x20, 0x6A, 0x09, 0x77, 0x4F, 0x92, 0xA0, 0xE0, 0x12,
  0x05, 0xA0, 0x92, 0x02, 0xA0, 0xB7, 0x74, 0xF9, 0x2B, 0x0A, 0x3A, 0x0D, 0x3A, 0x0D, 0x77, 0x4F,
  0x92, 0xB0, 0xD3, 0x81, 0xEF, 0xE3, 0x81, 0xEF, 0xE7, 0x74, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C,
  0x00, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x19, 0x1E, 0x80, 0xC4, 0xF8, 0x4E,
  0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x17, 0x71, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77,
  0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_connected_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_connected_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_conveyor_belt 48x48, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_filled_48_hardware_conveyor_belt_data[] PROGMEM = {
  0x77, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x47, 0x76, 0x0D, 0xFF, 0xC0, 0xD7, 0x76, 0xFF, 0xE7, 0x76,
  0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x3D, 0x0D, 0x4E, 0x71, 0xE7, 0x3D, 0x0D, 0x4E,
  0x71, 0xE7, 0x3D, 0x0D, 0x4E, 0x71, 0xE7, 0x3D, 0x0D, 0x4E, 0x71, 0xE7, 0x76, 0xFF, 0xE7, 0x76,
  0xFF, 0xE6, 0xFA, 0x0D, 0x4F, 0xFE, 0x6F, 0xA0, 0xD4, 0xFF, 0xE6, 0xFA, 0x0D, 0x4F, 0xFE, 0x68,
  0x05, 0xD0, 0xB4, 0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x76, 0x0D, 0xFF, 0xC0, 0xD7,
  0x76, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x48, 0x0A, 0xC5, 0x08, 0x16, 0xCE, 0xFF, 0xFF, 0x81, 0xEC,
  0x64, 0x01, 0x0C, 0xFF, 0xFF, 0xE0, 0xC0, 0x12, 0x0C, 0x80, 0xC0, 0xF8, 0x1C, 0x06, 0x80, 0xC2,
  0xF0, 0x60, 0xCB, 0x0B, 0x01, 0x77, 0x77, 0x01, 0x0B, 0xB0, 0xC0, 0xEB, 0x01, 0x77, 0x77, 0x20,
  0x1B, 0x00, 0xEB, 0x01, 0x77, 0x77, 0x20, 0x1B, 0x0E, 0x0C, 0xB0, 0xB0, 0x17, 0x77, 0x70, 0x10,
  0xBB, 0x0C, 0x06, 0x80, 0xC2, 0xF8, 0x16, 0x0C, 0x80, 0xC0, 0xF0, 0xC2, 0x01, 0x0C, 0xFF, 0xFF,
  0xE0, 0xC0, 0x14, 0x81, 0x6C, 0xEF, 0xFF, 0xF8, 0x1E, 0xC6, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_conveyor_belt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_conveyor_belt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_desktop_mac 48x48, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_48_hardware_desktop_mac_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xDD, 0x4F, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8,
  0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1,
  0x77, 0x20, 0x7F, 0x90, 0x77, 0x77, 0x71, 0x07, 0xFB, 0x07, 0x77, 0x76, 0x07, 0xFD, 0x07, 0x77,
  0x74, 0x07, 0xFF, 0x07, 0x77, 0x73, 0xFF, 0xA7, 0x77, 0x3F, 0xFA, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_desktop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_desktop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_desktop_windows 48x48, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_48_hardware_desktop_windows_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xCB, 0x4F, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8,
  0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1,
  0x77, 0x3F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0xFF,
  0xA7, 0x77, 0x3F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x77, 0x3F, 0xFA, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_desktop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_desktop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_developer_board_off 48x48, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_filled_48_hardware_developer_board_off_data[] PROGMEM = {
  0x20, 0x20, 0x78, 0x0C, 0x40, 0x82, 0x2E, 0xF7, 0x80, 0xC2, 0x00, 0x20, 0xEB, 0x07, 0x50, 0xCF,
  0xFF, 0xA8, 0x1D, 0xA1, 0x50, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFF, 0xB0, 0xE0, 0x15, 0x03, 0x0E,
  0xC0, 0x75, 0x0C, 0xFF, 0xFB, 0x0A, 0x60, 0x3D, 0x07, 0x50, 0xCF, 0xFF, 0xA0, 0xD7, 0xE0, 0x77,
  0x77, 0x4C, 0x7F, 0x07, 0x77, 0x73, 0xC7, 0xF9, 0x07, 0x77, 0x72, 0xC7, 0xC0, 0xEC, 0x07, 0x77,
  0x71, 0xC7, 0xC0, 0x30, 0xEC, 0x07, 0x50, 0xC9, 0x2F, 0x94, 0xF9, 0x3C, 0x10, 0x30, 0xEC, 0x07,
  0x50, 0xC2, 0xF9, 0x4F, 0x93, 0xC2, 0x03, 0x0E, 0xC0, 0x77, 0xF9, 0x4F, 0x93, 0xC3, 0x03, 0xD0,
  0x76, 0xF9, 0x4F, 0x93, 0xC4, 0xE0, 0x75, 0x0C, 0xF4, 0xC7, 0xC4, 0xF0, 0x75, 0x0C, 0xE4, 0xC7,
  0xC4, 0xF9, 0x07, 0x77, 0x1C, 0x7C, 0x4F, 0xA0, 0x77, 0x7C, 0x7C, 0x4F, 0xB0, 0x75, 0x0C, 0xB4,
  0xF9, 0x3C, 0x4F, 0xC0, 0x75, 0x0C, 0xA4, 0xF9, 0x3C, 0x73, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0x94,
  0xF9, 0x3C, 0x74, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0x4F, 0x93, 0xC4, 0xFF, 0x07, 0x72, 0xC7, 0xC4,
  0xFB, 0x0E, 0xC0, 0x77, 0x1C, 0x7C, 0x4F, 0xB0, 0x30, 0xEC, 0x07, 0x7C, 0x7C, 0x4F, 0xB1, 0x03,
  0xD0, 0x76, 0xC7, 0xC4, 0xFB, 0x2E, 0x07, 0x50, 0xCF, 0x3C, 0x4F, 0xB2, 0xF0, 0x75, 0x0C, 0xE3,
  0xC4, 0xFB, 0x2F, 0x90, 0x75, 0x0C, 0xD3, 0xC4, 0xFB, 0x2F, 0xA0, 0x75, 0x0C, 0xC3, 0xC7, 0x76,
  0x03, 0x0E, 0xC0, 0x77, 0x5C, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x74, 0xC7, 0x77, 0x10, 0x30, 0xEC,
  0x07, 0x73, 0xC7, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x72, 0x0D, 0xFF, 0xFF, 0xD0, 0x77, 0x10, 0xAF,
  0xFF, 0xFE, 0x07, 0x70, 0x10, 0xEF, 0xFF, 0xFE, 0x07, 0x78, 0x11, 0xAD, 0xFF, 0xFF, 0xD0, 0x78,
  0x0C, 0x10, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x10, 0x03, 0x0E, 0xC0, 0x68, 0x0C, 0x10, 0x03, 0x0E,
  0xA0, 0xE0, 0x28, 0x0C, 0x20, 0x82, 0x3E, 0xE2, 0x80, 0xC4, 0x00, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_developer_board_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 43, 46), Box(0, 0, 47, 47),
      ic_filled_48_hardware_developer_board_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_developer_board 48x48, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_filled_48_hardware_developer_board_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x15, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14, 0x0A,
  0xFF, 0xFF, 0xE0, 0xA4, 0x0D, 0xFF, 0xFF, 0xE0, 0xD4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4,
  0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC4, 0xFB, 0x2F, 0x94, 0xFD, 0x4F, 0xB2, 0xF9, 0x4F,
  0xD4, 0xFB, 0x2F, 0x94, 0xFD, 0x4F, 0xB2, 0xF9, 0x4F, 0xD4, 0xFB, 0x2F, 0x94, 0xC4, 0xC4, 0xFB,
  0x2F, 0x94, 0xC4, 0xC4, 0xFB, 0x77, 0xC4, 0xC4, 0xFB, 0x77, 0xC4, 0xC4, 0xFB, 0x2F, 0x94, 0xFD,
  0x4F, 0xB2, 0xF9, 0x4F, 0xD7, 0x72, 0xF9, 0x4F, 0xD7, 0x72, 0xF9, 0x4F, 0xD4, 0xFB, 0x2F, 0x94,
  0xC4, 0xC4, 0xFB, 0x2F, 0x94, 0xC4, 0xC4, 0xFB, 0x2F, 0x94, 0xC4, 0xC4, 0xFB, 0x2F, 0x94, 0xC4,
  0xC4, 0xFB, 0x2F, 0x94, 0xFD, 0x4F, 0xB2, 0xF9, 0x4F, 0xD4, 0xFB, 0x2F, 0x94, 0xFD, 0x4F, 0xB2,
  0xF9, 0x4F, 0xD7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD4, 0x0A, 0xFF, 0xFF, 0xE0, 0xA4, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0,
  0x15, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_developer_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_developer_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_device_hub 48x48, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_filled_48_hardware_device_hub_data[] PROGMEM = {
  0x77, 0x18, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x06, 0xFB, 0x06, 0x77, 0x73, 0x0C, 0xFB, 0x0C, 0x77, 0x73, 0x0E, 0xFB, 0x0E,
  0x77, 0x73, 0x0E, 0xFB, 0x0E, 0x77, 0x73, 0x0B, 0xFB, 0x0B, 0x77, 0x73, 0x05, 0xFB, 0x05, 0x77,
  0x74, 0x0C, 0xF9, 0x0C, 0x77, 0x75, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x70, 0x5C, 0x05, 0x77,
  0x77, 0x3C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77,
  0x4C, 0x77, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x77, 0x10, 0x7E, 0x07, 0x77, 0x76, 0x07, 0xF9, 0x07,
  0x77, 0x74, 0x07, 0xC0, 0x0D, 0xC0, 0x77, 0x77, 0x20, 0x7C, 0x82, 0xD2, 0x2D, 0xC0, 0x77, 0x77,
  0x07, 0xC0, 0xE0, 0x22, 0x02, 0x0E, 0xC0, 0x77, 0x75, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0,
  0x77, 0x73, 0x07, 0xC0, 0xE0, 0x36, 0x03, 0x0E, 0xC0, 0x77, 0x1F, 0xE0, 0x47, 0x10, 0x4F, 0xFF,
  0xC0, 0x47, 0x30, 0x4F, 0xFF, 0xA0, 0x57, 0x50, 0x5F, 0xFF, 0x05, 0x77, 0x05, 0xFF, 0xE7, 0x72,
  0xFF, 0xE7, 0x72, 0xFF, 0xE7, 0x72, 0xFF, 0xE7, 0x72, 0xFF, 0xE7, 0x72, 0xFF, 0xE7, 0x72, 0xFB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_device_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_device_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_devices_other 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_filled_48_hardware_devices_other_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF4, 0x01, 0x0E, 0x80, 0xC2, 0xF4, 0x0A, 0x80, 0xC3, 0xF4, 0x0D,
  0x80, 0xC3, 0xF4, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC7,
  0x77, 0x30, 0x30, 0xDF, 0xD0, 0xD0, 0x3C, 0x77, 0x73, 0x0D, 0xFF, 0x0D, 0xC7, 0x77, 0x3F, 0xFE,
  0x77, 0x73, 0xFF, 0xE7, 0x77, 0x3C, 0x71, 0xF9, 0x77, 0x73, 0xC7, 0x1F, 0x97, 0x77, 0x3C, 0x71,
  0xF9, 0x77, 0x73, 0xC7, 0x1F, 0x97, 0x5F, 0x94, 0xC7, 0x1F, 0x97, 0x5F, 0x94, 0xC7, 0x1F, 0x97,
  0x5F, 0x94, 0xC7, 0x1F, 0x97, 0x40, 0x1F, 0x90, 0x13, 0xC7, 0x1F, 0x97, 0x40, 0xCF, 0x90, 0xC3,
  0xC7, 0x1F, 0x97, 0x30, 0x6B, 0x82, 0x71, 0x17, 0xB0, 0x62, 0xC7, 0x1F, 0x97, 0x30, 0xCA, 0x07,
  0x40, 0x7A, 0x0C, 0x2C, 0x71, 0xF9, 0x73, 0x0E, 0xA0, 0x14, 0x01, 0xA0, 0xE2, 0xC7, 0x1F, 0x97,
  0x30, 0xEA, 0x01, 0x40, 0x1A, 0x0E, 0x2C, 0x71, 0xF9, 0x73, 0x0C, 0xA0, 0x74, 0x07, 0xA0, 0xC2,
  0xC7, 0x1F, 0x97, 0x30, 0x6B, 0x82, 0x71, 0x17, 0xB0, 0x62, 0xC7, 0x1F, 0x97, 0x40, 0xCF, 0x90,
  0xC3, 0xC7, 0x1C, 0x0D, 0xFC, 0x30, 0x1F, 0x90, 0x13, 0xFF, 0xA0, 0xAF, 0xC4, 0xF9, 0x4F, 0xFA,
  0x01, 0x0E, 0xFB, 0x4F, 0x94, 0x0D, 0xFF, 0x83, 0xD0, 0x1A, 0xDF, 0x94, 0xF9, 0x40, 0x30, 0xDF,
  0xD0, 0xD0, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_devices_other() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_devices_other_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_device_unknown 48x48, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_filled_48_hardware_device_unknown_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0x9E, 0x0F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x84,
  0x15, 0x77, 0x51, 0x7F, 0x95, 0x01, 0x09, 0xE0, 0x90, 0x15, 0xF9, 0x40, 0x10, 0xDF, 0x90, 0xD0,
  0x14, 0xF9, 0x40, 0xCC, 0x00, 0xEC, 0x0C, 0x4F, 0x93, 0x05, 0xB0, 0xD0, 0x42, 0x04, 0x0D, 0xB0,
  0x53, 0xF9, 0x30, 0xBB, 0x02, 0x40, 0x2B, 0x0B, 0x3F, 0x93, 0x0E, 0xA0, 0xA6, 0x0A, 0xA0, 0xE3,
  0xF9, 0x30, 0xF5, 0x03, 0x60, 0x8A, 0x0E, 0x3F, 0x97, 0x60, 0xBA, 0x0C, 0x3F, 0x97, 0x50, 0x6B,
  0x07, 0x3F, 0x97, 0x40, 0x8B, 0x0C, 0x4F, 0x97, 0x30, 0xAB, 0x0D, 0x01, 0x4F, 0x97, 0x20, 0x9B,
  0x0D, 0x01, 0x5F, 0x97, 0x10, 0x2B, 0x0D, 0x01, 0x6F, 0x97, 0x10, 0x8B, 0x03, 0x7F, 0x97, 0x10,
  0xBA, 0x0D, 0x71, 0xF9, 0x71, 0x02, 0x0F, 0x37, 0x1F, 0x97, 0x76, 0xF9, 0x71, 0x0B, 0xA0, 0xB7,
  0x1F, 0x97, 0x10, 0xBA, 0x0B, 0x71, 0xF9, 0x71, 0x0B, 0xA0, 0xB7, 0x1F, 0x97, 0x18, 0x25, 0x77,
  0x57, 0x1F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x0F, 0x0D, 0xFF, 0xFD, 0x0D,
  0x0A, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_device_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_device_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_dock 48x48, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_filled_48_hardware_dock_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xA8, 0x4D, 0x91, 0x01, 0xEF, 0xFE, 0x81, 0xE1, 0xAF, 0xFF, 0x90, 0xA0,
  0xDF, 0xFF, 0x90, 0xD8, 0x09, 0xC0, 0xF7, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F,
  0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97,
  0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72,
  0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x28, 0x09, 0xC0, 0xF0, 0xDF, 0xFF, 0x90, 0xD0, 0xAF,
  0xFF, 0x98, 0x1A, 0x1E, 0xFF, 0xE8, 0x4E, 0x10, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x18, 0x09, 0xC1,
  0x0F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_dock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 2, 35, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_dock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_earbuds_battery 48x48, 4-bit Alpha,  RLE, 222 bytes.
static const unsigned char ic_filled_48_hardware_earbuds_battery_data[] PROGMEM = {
  0x18, 0x41, 0xAD, 0xDA, 0x17, 0x85, 0x5B, 0xEF, 0xD9, 0x27, 0x4C, 0x40, 0x10, 0xEC, 0x0E, 0x01,
  0x40, 0x10, 0xCF, 0x07, 0x73, 0xC4, 0x0A, 0xE0, 0xA3, 0x01, 0x0D, 0xFA, 0x07, 0x50, 0x40, 0xDF,
  0x98, 0x1D, 0x4D, 0xE0, 0xD3, 0x09, 0xB8, 0x37, 0x20, 0x3C, 0xB0, 0x24, 0x0D, 0xFB, 0x0D, 0xF0,
  0xD2, 0x01, 0xB0, 0x55, 0x0C, 0xA0, 0x94, 0xFF, 0xD0, 0xA2, 0x05, 0xA0, 0xC6, 0x03, 0xA0, 0xD4,
  0xFF, 0xC0, 0xE0, 0x12, 0x07, 0xA0, 0x87, 0xB4, 0xFF, 0x98, 0x2E, 0xDA, 0x13, 0x07, 0xA0, 0x87,
  0x0E, 0xA4, 0xFF, 0x97, 0x07, 0xA0, 0x87, 0x0E, 0xA4, 0xFF, 0x97, 0x07, 0xA0, 0x87, 0x0E, 0xA4,
  0xFF, 0x97, 0x07, 0xA0, 0x87, 0x0E, 0xA4, 0xFF, 0x97, 0x07, 0xA0, 0x87, 0x0E, 0xA4, 0xFF, 0x97,
  0x07, 0xA0, 0x87, 0x0E, 0xA4, 0xFF, 0x97, 0x07, 0xA0, 0x87, 0x0E, 0xA4, 0xFF, 0x97, 0x07, 0xA0,
  0x87, 0x0E, 0xA4, 0xFF, 0x97, 0x07, 0xA0, 0x87, 0x0E, 0xA4, 0xFF, 0x97, 0x07, 0xA0, 0x83, 0x82,
  0x1A, 0xDE, 0xB4, 0xFF, 0x97, 0x08, 0xA0, 0x72, 0x01, 0x0E, 0xE4, 0xFD, 0x0D, 0xA0, 0x46, 0x0B,
  0xA0, 0x52, 0x0A, 0xF4, 0xFD, 0x09, 0xA0, 0xC5, 0x04, 0xB0, 0x12, 0x0D, 0xF4, 0xFD, 0x02, 0xB8,
  0x3C, 0x30, 0x27, 0xB0, 0xA3, 0x0D, 0xE0, 0xD4, 0xFD, 0x10, 0x7F, 0xA0, 0xD0, 0x13, 0x0A, 0xE0,
  0xA4, 0xFD, 0x20, 0x7F, 0x0C, 0x02, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x40, 0xDF, 0xB0, 0xD3, 0x85,
  0x29, 0xDF, 0xEB, 0x67, 0x84, 0x1A, 0xDD, 0xA1, 0x50, 0x40, 0xDF, 0x90, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_earbuds_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 43, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_earbuds_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_earbuds 48x48, 4-bit Alpha,  RLE, 244 bytes.
static const unsigned char ic_filled_48_hardware_earbuds_data[] PROGMEM = {
  0x38, 0x45, 0xBE, 0xEC, 0x67, 0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x10, 0xBE, 0x0C, 0x01, 0x72,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x50, 0xAF, 0x90, 0xC7, 0x10, 0x8F, 0xD0, 0x83, 0x04, 0xFB, 0x06,
  0x60, 0x8F, 0xF0, 0x82, 0x0A, 0xFB, 0x0C, 0x50, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x81, 0x40,
  0xEF, 0xB0, 0xE5, 0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xD1, 0xFD, 0x40, 0x5C, 0x02, 0x71,
  0x02, 0xC0, 0x5F, 0xC0, 0xC4, 0x09, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0xFC, 0x06, 0x40, 0xDB, 0x03,
  0x73, 0x03, 0xB0, 0xDF, 0xB0, 0xB5, 0x0E, 0xB7, 0x5B, 0x0E, 0xFA, 0x0B, 0x01, 0x5C, 0x75, 0xFB,
  0x81, 0xEB, 0x57, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9,
  0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7,
  0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7, 0x5F, 0x97,
  0x5C, 0x78, 0x15, 0xBE, 0xFB, 0x75, 0xC5, 0x01, 0x0B, 0xFA, 0x0E, 0xB7, 0x5B, 0x0E, 0x50, 0xBF,
  0xB0, 0xDB, 0x03, 0x73, 0x03, 0xB0, 0xD4, 0x06, 0xFC, 0x09, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0x40,
  0xCF, 0xC0, 0x5C, 0x02, 0x71, 0x02, 0xC0, 0x54, 0xFD, 0x10, 0xDB, 0x0D, 0x02, 0x60, 0x20, 0xDB,
  0x0D, 0x5F, 0xC8, 0x1E, 0x04, 0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x45, 0x0C, 0xFB, 0x0A, 0x20,
  0x8F, 0xF0, 0x86, 0x06, 0xFB, 0x04, 0x30, 0x8F, 0xD0, 0x87, 0x10, 0xCF, 0x90, 0xA5, 0x04, 0x0D,
  0xF9, 0x0D, 0x04, 0x72, 0x01, 0x0C, 0xE0, 0xB7, 0x18, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x60, 0x60,
  0xCA, 0x0B, 0x05, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_earbuds() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_earbuds_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_forklift 48x48, 4-bit Alpha,  RLE, 248 bytes.
static const unsigned char ic_filled_48_hardware_forklift_data[] PROGMEM = {
  0x77, 0x77, 0x6C, 0x80, 0xC4, 0x0C, 0x75, 0xFF, 0xA0, 0x37, 0x4C, 0x75, 0xFF, 0xA0, 0x97, 0x4C,
  0x75, 0xFF, 0xB0, 0x17, 0x3C, 0x75, 0xFF, 0xB0, 0x77, 0x3C, 0x75, 0xC7, 0x20, 0x6B, 0x0D, 0x73,
  0xC7, 0x5C, 0x73, 0x0E, 0xB0, 0x57, 0x2C, 0x75, 0xC7, 0x30, 0x9B, 0x0B, 0x72, 0xC7, 0x5C, 0x73,
  0x02, 0xC0, 0x27, 0x1C, 0x75, 0xC7, 0x40, 0xBB, 0x09, 0x71, 0xC7, 0x5C, 0x74, 0x04, 0xB0, 0xE0,
  0x17, 0xC7, 0x5C, 0x75, 0x0D, 0xB0, 0x77, 0xC7, 0x5C, 0x75, 0x07, 0xB0, 0xD7, 0xC7, 0x1F, 0x90,
  0x77, 0x40, 0x10, 0xEB, 0x04, 0x6C, 0x71, 0xFA, 0x07, 0x74, 0x09, 0xB0, 0xB6, 0xC7, 0x1F, 0xB0,
  0x67, 0x30, 0x2C, 0x02, 0x5C, 0x71, 0xFC, 0x06, 0x73, 0x0B, 0xB0, 0x85, 0xC7, 0x1F, 0xD0, 0x57,
  0x20, 0x5B, 0x0E, 0x5C, 0x71, 0xFE, 0x05, 0x72, 0x0D, 0xB0, 0x64, 0xC7, 0x1F, 0xFF, 0xE0, 0xD4,
  0xC7, 0x1F, 0xFF, 0xF0, 0x43, 0xC7, 0x1F, 0xFF, 0xF0, 0xA3, 0xC7, 0x01, 0xFF, 0xFF, 0x90, 0x22,
  0xC7, 0x0C, 0xFF, 0xF8, 0x27, 0x11, 0x7C, 0x07, 0x2C, 0x60, 0x6F, 0xFF, 0x07, 0x40, 0x7B, 0x0C,
  0x2C, 0x60, 0xCB, 0x82, 0xB1, 0x1B, 0xFF, 0x01, 0x40, 0x1B, 0x0E, 0x2C, 0x60, 0xEB, 0x01, 0x20,
  0x1F, 0xF0, 0x14, 0x01, 0xB0, 0xE2, 0xC6, 0x0E, 0xB0, 0x12, 0x01, 0xFF, 0x07, 0x40, 0x7B, 0x0C,
  0x2F, 0xB0, 0xCB, 0x82, 0xB1, 0x1B, 0xFF, 0x98, 0x27, 0x11, 0x7C, 0x07, 0x2F, 0xB0, 0x6F, 0xB0,
  0x66, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x2F, 0xB1, 0x0C, 0xF9, 0x0C, 0x71, 0x04, 0xFB, 0x05, 0x3F,
  0xB1, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x20, 0x40, 0xEE, 0x0E, 0x05, 0x77, 0x38, 0x46, 0xCE, 0xEB,
  0x57, 0x58, 0x61, 0x7C, 0xEE, 0xC7, 0x17, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_forklift() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_forklift_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_front_loader 48x48, 4-bit Alpha,  RLE, 231 bytes.
static const unsigned char ic_filled_48_hardware_front_loader_data[] PROGMEM = {
  0x77, 0xFB, 0x81, 0xEC, 0x67, 0x77, 0x75, 0xFE, 0x0C, 0x01, 0x77, 0x77, 0x3F, 0xF0, 0xC7, 0x77,
  0x73, 0xFF, 0x90, 0x67, 0x77, 0x72, 0xC6, 0x01, 0x0B, 0xB0, 0xC7, 0x77, 0x72, 0xC7, 0x01, 0xB0,
  0xE6, 0x07, 0x04, 0x77, 0x71, 0xC7, 0x1C, 0x58, 0x17, 0xFC, 0x77, 0x71, 0xC7, 0x1C, 0x40, 0x7B,
  0x05, 0x77, 0x7C, 0x71, 0xC3, 0x07, 0xC0, 0xC7, 0x77, 0xC7, 0x1C, 0x20, 0x5E, 0x05, 0x78, 0x11,
  0xAD, 0xFF, 0x71, 0xC2, 0x0B, 0xE0, 0xD6, 0x01, 0x0E, 0xFF, 0xA7, 0x1C, 0x20, 0xEF, 0x06, 0x50,
  0xAF, 0xFB, 0x71, 0xC2, 0xF9, 0x0E, 0x50, 0xDF, 0xFB, 0x71, 0xC2, 0xFA, 0x07, 0x48, 0x0C, 0x5F,
  0x0E, 0x01, 0x38, 0x0C, 0x6F, 0x08, 0x38, 0x0C, 0x6F, 0x0E, 0x01, 0x28, 0x0C, 0x7F, 0x09, 0x2F,
  0xFF, 0xFA, 0x20, 0xEF, 0xC0, 0x21, 0xFF, 0xFF, 0xA2, 0x0A, 0xFC, 0x0A, 0x1F, 0xFF, 0xFA, 0x20,
  0x10, 0xEF, 0xC0, 0x3F, 0xFF, 0xFA, 0x01, 0x28, 0x11, 0xAE, 0xFA, 0x0B, 0xFF, 0xFF, 0xA0, 0xB7,
  0x71, 0xFF, 0xFF, 0xB0, 0x57, 0x7C, 0x82, 0xB1, 0x1B, 0xFF, 0xA8, 0x2B, 0x11, 0xBB, 0x0B, 0x77,
  0xC0, 0x12, 0x01, 0xFF, 0xA0, 0x12, 0x01, 0xB0, 0xE7, 0x70, 0xEB, 0x01, 0x20, 0x1F, 0xFA, 0x01,
  0x20, 0x1B, 0x0E, 0x77, 0x0B, 0xB8, 0x2B, 0x11, 0xBF, 0xFA, 0x82, 0xB1, 0x1B, 0xB0, 0xB7, 0x70,
  0x5F, 0xB0, 0x57, 0x10, 0x6F, 0xB0, 0x57, 0x71, 0x0B, 0xF9, 0x0B, 0x73, 0x0C, 0xF9, 0x0B, 0x77,
  0x20, 0x10, 0xBE, 0x0B, 0x01, 0x73, 0x01, 0x0C, 0xE0, 0xB0, 0x17, 0x74, 0x84, 0x6C, 0xED, 0xC5,
  0x77, 0x84, 0x6C, 0xEE, 0xB6, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_front_loader() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 47, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_front_loader_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_gamepad 48x48, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_filled_48_hardware_gamepad_data[] PROGMEM = {
  0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77,
  0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD,
  0x77, 0x77, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x10, 0x7F, 0x90, 0x77, 0x77, 0x73, 0x07, 0xE0, 0x77,
  0x72, 0xFC, 0x07, 0x50, 0x7C, 0x07, 0x50, 0x7F, 0xFF, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xFF,
  0xFC, 0x07, 0x50, 0x07, 0x50, 0x7F, 0xFF, 0xE0, 0x77, 0x30, 0x7F, 0xFF, 0xF9, 0x07, 0x71, 0x07,
  0xFF, 0xFF, 0xB0, 0x76, 0x07, 0xFF, 0xFF, 0xC0, 0x76, 0x07, 0xFF, 0xFF, 0xB0, 0x77, 0x10, 0x7F,
  0xFF, 0xF9, 0x07, 0x73, 0x07, 0xFF, 0xFE, 0x07, 0x50, 0x07, 0x50, 0x7F, 0xFF, 0xC0, 0x75, 0x07,
  0xA0, 0x75, 0x07, 0xFF, 0xFA, 0x07, 0x50, 0x7C, 0x07, 0x50, 0x7F, 0xC7, 0x72, 0x07, 0xE0, 0x77,
  0x77, 0x73, 0x07, 0xF9, 0x07, 0x77, 0x77, 0x10, 0x7F, 0xB0, 0x77, 0x77, 0x7F, 0xD7, 0x77, 0x7F,
  0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7,
  0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_gamepad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_hardware_gamepad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_headphones_battery 48x48, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_filled_48_hardware_headphones_battery_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x77, 0x1C, 0x72, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x76,
  0xC7, 0x10, 0x40, 0xEF, 0xD0, 0xE0, 0x47, 0x10, 0x40, 0xDF, 0x90, 0xD0, 0x43, 0x06, 0xC8, 0x1B,
  0x62, 0x28, 0x12, 0x6B, 0xC0, 0x67, 0x0D, 0xFB, 0x0D, 0x20, 0x4B, 0x0D, 0x03, 0x71, 0x03, 0x0D,
  0xB0, 0x46, 0xFD, 0x10, 0x10, 0xEA, 0x0B, 0x01, 0x73, 0x01, 0x0B, 0xA0, 0xE0, 0x15, 0xFD, 0x10,
  0x9A, 0x0D, 0x01, 0x75, 0x01, 0x0D, 0xA0, 0x95, 0xFD, 0x01, 0xB0, 0x37, 0x70, 0x3B, 0x01, 0x4F,
  0xD0, 0x6A, 0x0B, 0x77, 0x20, 0xBA, 0x06, 0x4F, 0xD0, 0xBA, 0x06, 0x77, 0x20, 0x6A, 0x0B, 0x4F,
  0xD0, 0xDA, 0x02, 0x77, 0x20, 0x2A, 0x0D, 0x4F, 0xD0, 0xEA, 0x77, 0x4A, 0x0E, 0x4F, 0xF9, 0x77,
  0x4B, 0x4F, 0xF9, 0x77, 0x4B, 0x4F, 0xFE, 0x71, 0xF9, 0x4F, 0xFE, 0x71, 0xF9, 0x4F, 0xFE, 0x71,
  0xF9, 0x4F, 0xFE, 0x71, 0xF9, 0x4F, 0xFE, 0x71, 0xF9, 0x4F, 0xFE, 0x71, 0xF9, 0x4F, 0xD0, 0xDF,
  0x71, 0xF0, 0xD4, 0xFD, 0x0A, 0xF7, 0x1F, 0x0A, 0x4F, 0xD0, 0x10, 0xEE, 0x71, 0xE0, 0xE0, 0x14,
  0x0D, 0xFB, 0x83, 0xD0, 0x1A, 0xDC, 0x71, 0xC8, 0x1D, 0xA1, 0x50, 0x40, 0xDF, 0x90, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_headphones_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 43, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_headphones_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_headphones 48x48, 4-bit Alpha,  RLE, 207 bytes.
static const unsigned char ic_filled_48_hardware_headphones_data[] PROGMEM = {
  0x75, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x77, 0x10, 0x40, 0xBF, 0xD0, 0xB0, 0x47,
  0x74, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x37, 0x71, 0x08, 0xFF, 0xE0, 0x87, 0x50, 0x10, 0xBE, 0x82,
  0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE, 0x0B, 0x01, 0x72, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20,
  0xAD, 0x0C, 0x01, 0x71, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x70, 0x8C, 0x0B, 0x01,
  0x77, 0x20, 0x10, 0xBC, 0x08, 0x50, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x40, 0xBB, 0x0D, 0x01,
  0x77, 0x60, 0x10, 0xDB, 0x0B, 0x30, 0x4C, 0x03, 0x77, 0x71, 0x03, 0xC0, 0x42, 0x0B, 0xB0, 0xA7,
  0x77, 0x30, 0xAB, 0x81, 0xB0, 0x1C, 0x02, 0x77, 0x73, 0x02, 0xC0, 0x10, 0x5B, 0x0C, 0x77, 0x75,
  0x0C, 0xB0, 0x50, 0x9B, 0x07, 0x77, 0x75, 0x07, 0xB0, 0x90, 0xBB, 0x03, 0x77, 0x75, 0x03, 0xB0,
  0xB0, 0xDB, 0x02, 0x77, 0x75, 0x02, 0xB0, 0xD0, 0xEB, 0x77, 0x77, 0xB0, 0xEC, 0x77, 0x77, 0xF9,
  0x77, 0x77, 0xFF, 0xA7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7,
  0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F,
  0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xD0, 0xDF, 0xC7, 0x5F, 0xC0, 0xD0, 0xAF, 0xC7, 0x5F, 0xC8,
  0x1A, 0x1E, 0xFB, 0x75, 0xFB, 0x84, 0xE1, 0x01, 0xAD, 0xF9, 0x75, 0xF9, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_headphones() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_headphones_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_headset_mic 48x48, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_filled_48_hardware_headset_mic_data[] PROGMEM = {
  0x75, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x77, 0x10, 0x40, 0xBF, 0xD0, 0xB0, 0x47,
  0x74, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x37, 0x71, 0x08, 0xFF, 0xE0, 0x87, 0x50, 0x10, 0xBE, 0x82,
  0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE, 0x0B, 0x01, 0x72, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20,
  0xAD, 0x0C, 0x01, 0x71, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x70, 0x8C, 0x0B, 0x01,
  0x77, 0x20, 0x10, 0xBC, 0x08, 0x50, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x40, 0xBB, 0x0D, 0x01,
  0x77, 0x60, 0x10, 0xDB, 0x0B, 0x30, 0x4C, 0x03, 0x77, 0x71, 0x03, 0xC0, 0x42, 0x0B, 0xB0, 0xA7,
  0x77, 0x30, 0xAB, 0x81, 0xB0, 0x1C, 0x02, 0x77, 0x73, 0x02, 0xC0, 0x10, 0x5B, 0x0C, 0x77, 0x75,
  0x0C, 0xB0, 0x50, 0x9B, 0x07, 0x77, 0x75, 0x07, 0xB0, 0x90, 0xBB, 0x03, 0x77, 0x75, 0x03, 0xB0,
  0xB0, 0xDB, 0x02, 0x77, 0x75, 0x02, 0xB0, 0xD0, 0xEB, 0x77, 0x77, 0xB0, 0xEC, 0x77, 0x77, 0xF9,
  0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xFF, 0xA7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7,
  0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F,
  0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xD0, 0xEF, 0xC7, 0x5F, 0xD0, 0xCF, 0xC7, 0x5F, 0xD0, 0x6F,
  0xC7, 0x5F, 0xD1, 0x0C, 0xFB, 0x75, 0xFD, 0x10, 0x10, 0xCF, 0xA7, 0x5F, 0xD3, 0x81, 0x6C, 0xEE,
  0x75, 0xFD, 0x77, 0x77, 0x4B, 0x0E, 0x77, 0x77, 0x4B, 0x0C, 0x77, 0x4F, 0xFB, 0x06, 0x77, 0x4F,
  0xFA, 0x0C, 0x77, 0x5F, 0xF9, 0x0C, 0x01, 0x77, 0x5F, 0xD8, 0x1E, 0xC6, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_headset_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_headset_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_headset_off 48x48, 4-bit Alpha,  RLE, 327 bytes.
static const unsigned char ic_filled_48_hardware_headset_off_data[] PROGMEM = {
  0x20, 0x48, 0x0C, 0x50, 0x81, 0x7F, 0x97, 0x58, 0x92, 0x15, 0x9C, 0xDF, 0xED, 0xB9, 0x51, 0x77,
  0x10, 0x7B, 0x09, 0x72, 0x05, 0x0B, 0xFD, 0x0B, 0x04, 0x76, 0x07, 0xC0, 0x96, 0x03, 0x0C, 0xFF,
  0xA0, 0xB0, 0x37, 0x50, 0x7C, 0x09, 0x40, 0x2F, 0xFE, 0x08, 0x75, 0x07, 0xC0, 0x94, 0x05, 0xC8,
  0x2B, 0x73, 0x12, 0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x40, 0x7C, 0x09, 0x48, 0x25, 0xF9, 0x27,
  0x30, 0x20, 0xAD, 0x0C, 0x01, 0x74, 0x07, 0xC0, 0x94, 0x01, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x50,
  0x7C, 0x09, 0x77, 0x50, 0x10, 0xBC, 0x08, 0x75, 0x08, 0xC0, 0x97, 0x76, 0x0B, 0xC0, 0x37, 0x40,
  0xCD, 0x09, 0x77, 0x50, 0x10, 0xDB, 0x0B, 0x73, 0x04, 0xF0, 0x97, 0x75, 0x03, 0xC0, 0x47, 0x20,
  0xBB, 0x0D, 0xC0, 0x97, 0x75, 0x0A, 0xB0, 0xB7, 0x10, 0x1C, 0x02, 0x07, 0xC0, 0x97, 0x74, 0x02,
  0xC0, 0x17, 0x06, 0xB0, 0xB2, 0x07, 0xC0, 0x97, 0x74, 0x0C, 0xB0, 0x57, 0x09, 0xB0, 0x73, 0x07,
  0xC0, 0x97, 0x73, 0x07, 0xB0, 0x97, 0x0C, 0xB0, 0x34, 0x07, 0xC0, 0x97, 0x72, 0x03, 0xB0, 0xB7,
  0x0D, 0xB0, 0x15, 0x07, 0xC0, 0x97, 0x71, 0x02, 0xB0, 0xD7, 0x0E, 0xB7, 0x07, 0xC0, 0x97, 0x71,
  0xB0, 0xE7, 0xC7, 0x10, 0x7C, 0x09, 0x77, 0xC7, 0xC7, 0x20, 0x7C, 0x09, 0x76, 0xC7, 0xC7, 0x30,
  0x7C, 0x09, 0x75, 0xC7, 0xC7, 0x40, 0x7C, 0x09, 0x74, 0xC7, 0xFD, 0x40, 0x7C, 0x09, 0x40, 0x5F,
  0xA7, 0xFD, 0x50, 0x7C, 0x09, 0x40, 0x5F, 0x97, 0xFD, 0x60, 0x7C, 0x09, 0x40, 0x5F, 0x7F, 0xD7,
  0x07, 0xC0, 0x94, 0x05, 0xE7, 0xFD, 0x71, 0x07, 0xC0, 0x94, 0x05, 0xD7, 0xFD, 0x72, 0x07, 0xC0,
  0x94, 0x05, 0xC7, 0xFD, 0x73, 0x07, 0xC0, 0x94, 0x05, 0xB7, 0xFD, 0x74, 0x07, 0xC0, 0x94, 0x05,
  0xA7, 0xFD, 0x75, 0xD0, 0x94, 0x05, 0x97, 0xFD, 0x75, 0xE0, 0x94, 0x05, 0x70, 0xEF, 0xC7, 0x5F,
  0x09, 0x74, 0x0C, 0xFC, 0x75, 0xF9, 0x09, 0x73, 0x06, 0xFC, 0x75, 0xFA, 0x09, 0x73, 0x0C, 0xFB,
  0x75, 0xFB, 0x09, 0x72, 0x01, 0x0C, 0xFA, 0x75, 0xFC, 0x09, 0x73, 0x81, 0x6C, 0xEE, 0x75, 0xE0,
  0xE0, 0xCC, 0x09, 0x80, 0xC2, 0x00, 0x7C, 0x09, 0x80, 0xC2, 0x00, 0x7C, 0x04, 0x80, 0xC2, 0x00,
  0x7A, 0x07, 0x80, 0xC4, 0x00, 0x07, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_headset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 44, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_headset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_headset 48x48, 4-bit Alpha,  RLE, 219 bytes.
static const unsigned char ic_filled_48_hardware_headset_data[] PROGMEM = {
  0x75, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x77, 0x10, 0x40, 0xBF, 0xD0, 0xB0, 0x47,
  0x74, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x37, 0x71, 0x08, 0xFF, 0xE0, 0x87, 0x50, 0x10, 0xBE, 0x82,
  0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE, 0x0B, 0x01, 0x72, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20,
  0xAD, 0x0C, 0x01, 0x71, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x70, 0x8C, 0x0B, 0x01,
  0x77, 0x20, 0x10, 0xBC, 0x08, 0x50, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x40, 0xBB, 0x0D, 0x01,
  0x77, 0x60, 0x10, 0xDB, 0x0B, 0x30, 0x4C, 0x03, 0x77, 0x71, 0x03, 0xC0, 0x42, 0x0B, 0xB0, 0xA7,
  0x77, 0x30, 0xAB, 0x81, 0xB0, 0x1C, 0x02, 0x77, 0x73, 0x02, 0xC0, 0x10, 0x5B, 0x0C, 0x77, 0x75,
  0x0C, 0xB0, 0x50, 0x9B, 0x07, 0x77, 0x75, 0x07, 0xB0, 0x90, 0xBB, 0x03, 0x77, 0x75, 0x03, 0xB0,
  0xB0, 0xDB, 0x02, 0x77, 0x75, 0x02, 0xB0, 0xD0, 0xEB, 0x77, 0x77, 0xB0, 0xEC, 0x77, 0x77, 0xF9,
  0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xFF, 0xA7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7,
  0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F,
  0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xD0, 0xEF, 0xC7, 0x5F, 0xC0, 0xE0, 0xCF, 0xC7, 0x5F, 0xC0,
  0xC0, 0x6F, 0xC7, 0x5F, 0xC8, 0x16, 0x0C, 0xFB, 0x75, 0xFB, 0x0C, 0x20, 0x10, 0xCF, 0xA7, 0x5F,
  0xA0, 0xC0, 0x14, 0x81, 0x6C, 0xEE, 0x75, 0xE8, 0x1E, 0xC6, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_headset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_headset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_home_max 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_filled_48_hardware_home_max_data[] PROGMEM = {
  0x48, 0x22, 0x8C, 0xEF, 0xFF, 0xF8, 0x2E, 0xC8, 0x27, 0x09, 0x80, 0xC0, 0xF0, 0x95, 0x0B, 0x80,
  0xC2, 0xF0, 0xB3, 0x09, 0x80, 0xC4, 0xF8, 0x19, 0x02, 0xC8, 0x1D, 0x51, 0x77, 0x77, 0x81, 0x15,
  0xDC, 0x02, 0x08, 0xB0, 0xD0, 0x17, 0x77, 0x74, 0x01, 0x0D, 0xB0, 0x80, 0xCB, 0x05, 0x77, 0x77,
  0x60, 0x5B, 0x0C, 0x0E, 0xB0, 0x17, 0x77, 0x76, 0x01, 0xB0, 0xEC, 0x80, 0xC0, 0x0F, 0x98, 0x0C,
  0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9,
  0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xEB, 0x01,
  0x77, 0x77, 0x60, 0x1B, 0x0E, 0x0C, 0xB0, 0x57, 0x77, 0x76, 0x05, 0xB0, 0xC0, 0x8B, 0x0D, 0x01,
  0x77, 0x77, 0x40, 0x10, 0xDB, 0x08, 0x02, 0xC8, 0x1D, 0x51, 0x77, 0x77, 0x81, 0x15, 0xDC, 0x81,
  0x20, 0x98, 0x0C, 0x4F, 0x09, 0x30, 0xB8, 0x0C, 0x2F, 0x0B, 0x50, 0x98, 0x0C, 0x0F, 0x09, 0x78,
  0x22, 0x8C, 0xEF, 0xFF, 0xF8, 0x2E, 0xC8, 0x27, 0x72, 0xFF, 0xE7, 0x77, 0x3F, 0xFE, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_home_max() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_filled_48_hardware_home_max_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_home_mini 48x48, 4-bit Alpha,  RLE, 220 bytes.
static const unsigned char ic_filled_48_hardware_home_mini_data[] PROGMEM = {
  0x75, 0x85, 0x25, 0x8A, 0xCD, 0xEA, 0x85, 0xED, 0xDA, 0x86, 0x27, 0x77, 0x81, 0x39, 0xDF, 0xFA,
  0x81, 0xE9, 0x37, 0x72, 0x04, 0x0C, 0xFF, 0xF9, 0x0C, 0x04, 0x75, 0x01, 0x0A, 0xFF, 0xFD, 0x0B,
  0x01, 0x72, 0x03, 0x0E, 0xE8, 0x4E, 0xA7, 0x53, 0x14, 0x84, 0x13, 0x47, 0xAE, 0xE0, 0xE0, 0x37,
  0x04, 0x0E, 0xD0, 0xA0, 0x47, 0x72, 0x04, 0x0A, 0xD0, 0xE0, 0x45, 0x02, 0x0E, 0xC0, 0xB0, 0x27,
  0x76, 0x02, 0x0B, 0xC0, 0xE0, 0x24, 0x0C, 0xC0, 0x77, 0x77, 0x30, 0x7C, 0x0C, 0x30, 0x6C, 0x06,
  0x77, 0x75, 0x06, 0xC0, 0x62, 0x0E, 0xB0, 0x97, 0x77, 0x70, 0xAB, 0x81, 0xD0, 0x5B, 0x0E, 0x01,
  0x77, 0x77, 0x01, 0x0E, 0xB0, 0x40, 0x9B, 0x08, 0x77, 0x77, 0x20, 0x9B, 0x09, 0x0D, 0xB0, 0x37,
  0x77, 0x72, 0x03, 0xB0, 0xC0, 0xEB, 0x77, 0x77, 0x4B, 0x00, 0xE8, 0x0C, 0x3F, 0x0D, 0x80, 0xC2,
  0xF0, 0xE0, 0xB8, 0x0C, 0x2F, 0x0C, 0x07, 0x80, 0xC2, 0xF0, 0x90, 0x3C, 0x02, 0x77, 0x77, 0x02,
  0xC8, 0x14, 0x0D, 0xB0, 0xB7, 0x77, 0x70, 0xBB, 0x0E, 0x20, 0x5C, 0x07, 0x77, 0x75, 0x07, 0xC0,
  0x73, 0x0C, 0xC0, 0x87, 0x77, 0x30, 0x8C, 0x0D, 0x40, 0x20, 0xEC, 0x0B, 0x02, 0x77, 0x60, 0x20,
  0xBD, 0x03, 0x50, 0x3E, 0x81, 0xB6, 0x27, 0x78, 0x12, 0x6B, 0xD0, 0xE0, 0x47, 0x03, 0x0E, 0xFF,
  0xFF, 0x0E, 0x04, 0x72, 0x02, 0x0C, 0xFF, 0xFD, 0x0A, 0x01, 0x75, 0x05, 0x0D, 0xFF, 0xF9, 0x0B,
  0x04, 0x77, 0x28, 0x33, 0x7B, 0xDE, 0xFD, 0x83, 0xED, 0xA7, 0x27, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_home_mini() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_filled_48_hardware_home_mini_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_alt 48x48, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_alt_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xD8, 0x0A, 0xE4, 0xF4, 0xC4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4,
  0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xC4, 0x80, 0xAF, 0x4F, 0x4C,
  0x4C, 0x4C, 0x4F, 0xFA, 0x4C, 0x4C, 0x4C, 0x4F, 0xFA, 0x4C, 0x4C, 0x4C, 0x4F, 0xFA, 0x4C, 0x4C,
  0x4C, 0x48, 0x0B, 0x82, 0xF7, 0x72, 0xFF, 0xFF, 0x77, 0x28, 0x0A, 0xF2, 0xF0, 0xD8, 0x0C, 0x6F,
  0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_arrow_down 48x48, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_arrow_down_data[] PROGMEM = {
  0x20, 0x70, 0x37, 0x72, 0x03, 0x07, 0x38, 0x27, 0xFE, 0x37, 0x78, 0x43, 0xEF, 0x70, 0x7B, 0x0E,
  0x03, 0x75, 0x03, 0x0E, 0xB0, 0x07, 0xC0, 0xE0, 0x37, 0x30, 0x30, 0xEC, 0x81, 0x70, 0x7C, 0x0E,
  0x03, 0x71, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x36, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0xC0,
  0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x77, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C,
  0x82, 0xE3, 0x3E, 0xC0, 0x77, 0x40, 0x7C, 0x00, 0xEC, 0x07, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x10,
  0x7E, 0x07, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x70, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 17, 35, 31), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_arrow_left 48x48, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_arrow_left_data[] PROGMEM = {
  0x74, 0x00, 0x77, 0x50, 0x7A, 0x07, 0x73, 0x07, 0xC0, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x70, 0x7C,
  0x0E, 0x03, 0x70, 0x7C, 0x0E, 0x03, 0x70, 0x7C, 0x0E, 0x03, 0x70, 0x7C, 0x0E, 0x03, 0x70, 0x7C,
  0x0E, 0x03, 0x70, 0x7C, 0x0E, 0x03, 0x70, 0x7C, 0x0E, 0x03, 0x70, 0x7C, 0x0E, 0x03, 0x71, 0x07,
  0xC0, 0xE0, 0x37, 0x20, 0x7C, 0x0E, 0x03, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x20, 0x7C, 0x0E, 0x03,
  0x72, 0x07, 0xC0, 0xE0, 0x37, 0x20, 0x7C, 0x0E, 0x03, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x20, 0x7C,
  0x0E, 0x03, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x20, 0x7C, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x50, 0x07,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(16, 12, 30, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_arrow_right 48x48, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_arrow_right_data[] PROGMEM = {
  0x20, 0x07, 0x75, 0x07, 0xA0, 0x77, 0x30, 0x7C, 0x07, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x30,
  0xEC, 0x07, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x72, 0x03, 0x0E, 0xC0, 0x77,
  0x20, 0x30, 0xEC, 0x07, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x72, 0x03, 0x0E,
  0xC0, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x70, 0x30, 0xEC, 0x07, 0x70, 0x30, 0xEC, 0x07, 0x70, 0x30,
  0xEC, 0x07, 0x70, 0x30, 0xEC, 0x07, 0x70, 0x30, 0xEC, 0x07, 0x70, 0x30, 0xEC, 0x07, 0x70, 0x30,
  0xEC, 0x07, 0x70, 0x30, 0xEC, 0x07, 0x71, 0x07, 0xC0, 0x77, 0x30, 0x7A, 0x07, 0x75, 0x00, 0x77,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(17, 12, 31, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_arrow_up 48x48, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_arrow_up_data[] PROGMEM = {
  0x74, 0x00, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x75, 0x07, 0xC0, 0x77, 0x73, 0x07, 0xE0, 0x77, 0x71,
  0x07, 0xF9, 0x07, 0x76, 0x07, 0xC0, 0x0E, 0xC0, 0x77, 0x40, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x77,
  0x20, 0x7C, 0x0E, 0x03, 0x20, 0x30, 0xEC, 0x07, 0x70, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x07,
  0x50, 0x7C, 0x0E, 0x03, 0x60, 0x30, 0xEC, 0x07, 0x30, 0x7C, 0x0E, 0x03, 0x71, 0x03, 0x0E, 0xC8,
  0x17, 0x07, 0xC0, 0xE0, 0x37, 0x30, 0x30, 0xEC, 0x00, 0x7B, 0x0E, 0x03, 0x75, 0x03, 0x0E, 0xB8,
  0x47, 0x07, 0xFE, 0x37, 0x78, 0x23, 0xEF, 0x73, 0x07, 0x03, 0x77, 0x20, 0x30, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 16, 35, 30), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_backspace 48x48, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_backspace_data[] PROGMEM = {
  0x74, 0x00, 0x77, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x77, 0x71, 0x07,
  0xC0, 0xE0, 0x37, 0x77, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x70,
  0x7C, 0x0E, 0x03, 0x77, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x77,
  0x07, 0xC0, 0xE0, 0x37, 0x77, 0x70, 0x7F, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF,
  0x10, 0x7F, 0xFF, 0xFE, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77,
  0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0x03,
  0x77, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x7C,
  0x07, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x77, 0x50, 0x07, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_backspace() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 41, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_backspace_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_capslock 48x48, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_capslock_data[] PROGMEM = {
  0x74, 0x00, 0x57, 0x77, 0x05, 0xA0, 0x57, 0x75, 0x05, 0xC0, 0x57, 0x73, 0x05, 0xE0, 0x57, 0x71,
  0x05, 0xF9, 0x05, 0x76, 0x05, 0xFB, 0x05, 0x74, 0x05, 0xD0, 0x05, 0xD0, 0x57, 0x20, 0x5D, 0x05,
  0x20, 0x5D, 0x05, 0x70, 0x5D, 0x05, 0x40, 0x5D, 0x05, 0x50, 0x5D, 0x05, 0x60, 0x5D, 0x05, 0x30,
  0x5D, 0x05, 0x71, 0x05, 0xD8, 0x15, 0x05, 0xD0, 0x57, 0x30, 0x5D, 0x05, 0x0A, 0xC0, 0x57, 0x50,
  0x5C, 0x81, 0xA0, 0xAA, 0x05, 0x77, 0x05, 0xA0, 0xA3, 0x0A, 0x05, 0x77, 0x20, 0x50, 0xA8, 0x0A,
  0x96, 0x08, 0x09, 0xB4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_capslock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 11, 35, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_capslock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_command_key 48x48, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_command_key_data[] PROGMEM = {
  0x38, 0x61, 0x7C, 0xEE, 0xC7, 0x17, 0x78, 0x61, 0x7C, 0xEE, 0xC7, 0x15, 0x05, 0x0E, 0xE0, 0xE0,
  0x57, 0x50, 0x50, 0xEE, 0x0E, 0x05, 0x30, 0x5F, 0xB0, 0x57, 0x30, 0x5F, 0xB8, 0x25, 0x01, 0xEF,
  0xB0, 0xE0, 0x17, 0x10, 0x10, 0xEF, 0xB8, 0x1E, 0x17, 0xC8, 0x27, 0x11, 0x7C, 0x07, 0x71, 0x07,
  0xC8, 0x27, 0x11, 0x7C, 0x07, 0x0C, 0xB0, 0x74, 0x07, 0xB0, 0xC7, 0x10, 0xCB, 0x07, 0x40, 0x7B,
  0x0C, 0x0E, 0xB0, 0x14, 0x01, 0xB0, 0xE7, 0x10, 0xEB, 0x01, 0x40, 0x1B, 0x00, 0xEB, 0x01, 0x5C,
  0x71, 0xC5, 0x01, 0xB0, 0xE0, 0xCB, 0x07, 0x5C, 0x71, 0xC5, 0x07, 0xB0, 0xC0, 0x7C, 0x07, 0x01,
  0x3C, 0x71, 0xC3, 0x01, 0x07, 0xC8, 0x17, 0x1E, 0xFF, 0xFF, 0xC8, 0x2E, 0x10, 0x5F, 0xFF, 0xFC,
  0x05, 0x30, 0x50, 0xEF, 0xFF, 0xF0, 0xE0, 0x55, 0x82, 0x17, 0xCE, 0xFF, 0xF9, 0x82, 0xEC, 0x71,
  0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7,
  0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x68, 0x21, 0x7C, 0xEF,
  0xFF, 0x98, 0x2E, 0xC7, 0x15, 0x05, 0x0E, 0xFF, 0xFF, 0x0E, 0x05, 0x30, 0x5F, 0xFF, 0xFC, 0x82,
  0x50, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x17, 0xC0, 0x70, 0x13, 0xC7, 0x1C, 0x30, 0x10, 0x7C, 0x07,
  0x0C, 0xB0, 0x75, 0xC7, 0x1C, 0x50, 0x7B, 0x0C, 0x0E, 0xB0, 0x15, 0xC7, 0x1C, 0x50, 0x1B, 0x00,
  0xEB, 0x01, 0x40, 0x1B, 0x0E, 0x71, 0x0E, 0xB0, 0x14, 0x01, 0xB0, 0xE0, 0xCB, 0x07, 0x40, 0x7B,
  0x0C, 0x71, 0x0C, 0xB0, 0x74, 0x07, 0xB0, 0xC0, 0x7C, 0x82, 0x71, 0x17, 0xC0, 0x77, 0x10, 0x7C,
  0x82, 0x71, 0x17, 0xC8, 0x17, 0x1E, 0xFB, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xFB, 0x82, 0xE1, 0x05,
  0xFB, 0x05, 0x73, 0x05, 0xFB, 0x05, 0x30, 0x50, 0xEE, 0x0E, 0x05, 0x75, 0x05, 0x0E, 0xE0, 0xE0,
  0x55, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x77, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_command_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_command_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_control_key 48x48, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_control_key_data[] PROGMEM = {
  0x76, 0x00, 0x77, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x72, 0x07, 0xC0, 0x77, 0x77, 0x07, 0xE0, 0x77,
  0x75, 0x07, 0xF9, 0x07, 0x77, 0x30, 0x7C, 0x00, 0xEC, 0x07, 0x77, 0x10, 0x7C, 0x82, 0xE3, 0x3E,
  0xC0, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x20, 0x30, 0xEC, 0x07, 0x74, 0x07, 0xC0, 0xE0, 0x34, 0x03,
  0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x60, 0x30, 0xEC, 0x07, 0x70, 0x7C, 0x0E, 0x03, 0x71,
  0x03, 0x0E, 0xC0, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x30, 0x30, 0xEC, 0x07, 0x30, 0x7C, 0x0E, 0x03,
  0x75, 0x03, 0x0E, 0xC8, 0x17, 0x07, 0xC0, 0xE0, 0x37, 0x70, 0x30, 0xEC, 0x00, 0x7B, 0x0E, 0x03,
  0x77, 0x20, 0x30, 0xEB, 0x84, 0x70, 0x7F, 0xE3, 0x77, 0x48, 0x23, 0xEF, 0x73, 0x07, 0x03, 0x77,
  0x60, 0x30, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_control_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 10, 37, 26), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_control_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_double_arrow_down 48x48, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_double_arrow_down_data[] PROGMEM = {
  0x20, 0xA0, 0x57, 0x72, 0x05, 0x0A, 0x30, 0xAA, 0x05, 0x77, 0x05, 0xA8, 0x1A, 0x0A, 0xC0, 0x57,
  0x50, 0x5C, 0x0A, 0x05, 0xD0, 0x57, 0x30, 0x5D, 0x81, 0x50, 0x5D, 0x05, 0x71, 0x05, 0xD0, 0x53,
  0x05, 0xD0, 0x56, 0x05, 0xD0, 0x55, 0x05, 0xD0, 0x54, 0x05, 0xD0, 0x57, 0x05, 0xD0, 0x52, 0x05,
  0xD0, 0x57, 0x20, 0x5D, 0x00, 0x5D, 0x05, 0x74, 0x05, 0xFB, 0x05, 0x76, 0x05, 0xF9, 0x05, 0x77,
  0x10, 0x5E, 0x05, 0x77, 0x30, 0x5C, 0x05, 0x74, 0x07, 0x03, 0x60, 0x5A, 0x05, 0x60, 0x30, 0x73,
  0x82, 0x7F, 0xE3, 0x60, 0x05, 0x68, 0x43, 0xEF, 0x70, 0x7B, 0x0E, 0x03, 0x75, 0x03, 0x0E, 0xB0,
  0x07, 0xC0, 0xE0, 0x37, 0x30, 0x30, 0xEC, 0x81, 0x70, 0x7C, 0x0E, 0x03, 0x71, 0x03, 0x0E, 0xC0,
  0x73, 0x07, 0xC0, 0xE0, 0x36, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0,
  0x77, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x77,
  0x40, 0x7C, 0x00, 0xEC, 0x07, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x10, 0x7E, 0x07, 0x77, 0x30, 0x7C,
  0x07, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x70, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_double_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 10, 35, 37), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_double_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_double_arrow_left 48x48, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_double_arrow_left_data[] PROGMEM = {
  0x74, 0x00, 0x77, 0x40, 0x50, 0xA7, 0x50, 0x7A, 0x07, 0x72, 0x05, 0xA0, 0xA7, 0x30, 0x7C, 0x07,
  0x70, 0x5C, 0x0A, 0x71, 0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0, 0x57, 0x07, 0xC0, 0xE0, 0x36, 0x05,
  0xD0, 0x57, 0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0, 0x57, 0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0, 0x57,
  0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0, 0x57, 0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0, 0x57, 0x07, 0xC0,
  0xE0, 0x36, 0x05, 0xD0, 0x57, 0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0, 0x57, 0x07, 0xC0, 0xE0, 0x36,
  0x05, 0xD0, 0x57, 0x10, 0x7C, 0x0E, 0x03, 0x60, 0x5D, 0x05, 0x72, 0x07, 0xC0, 0xE0, 0x36, 0x05,
  0xD0, 0x57, 0x20, 0x7C, 0x0E, 0x03, 0x60, 0x5D, 0x05, 0x72, 0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0,
  0x57, 0x20, 0x7C, 0x0E, 0x03, 0x60, 0x5D, 0x05, 0x72, 0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0, 0x57,
  0x20, 0x7C, 0x0E, 0x03, 0x60, 0x5D, 0x05, 0x72, 0x07, 0xC0, 0xE0, 0x36, 0x05, 0xD0, 0x57, 0x20,
  0x7C, 0x0E, 0x03, 0x60, 0x5D, 0x05, 0x72, 0x07, 0xC0, 0x77, 0x05, 0xC0, 0xA7, 0x30, 0x7A, 0x07,
  0x72, 0x05, 0xA0, 0xA7, 0x50, 0x07, 0x74, 0x05, 0x0A, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_double_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 12, 37, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_double_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_double_arrow_right 48x48, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_double_arrow_right_data[] PROGMEM = {
  0x20, 0xA0, 0x57, 0x40, 0x07, 0x75, 0x0A, 0xA0, 0x57, 0x20, 0x7A, 0x07, 0x73, 0x0A, 0xC0, 0x57,
  0x07, 0xC0, 0x77, 0x20, 0x5D, 0x05, 0x60, 0x30, 0xEC, 0x07, 0x72, 0x05, 0xD0, 0x56, 0x03, 0x0E,
  0xC0, 0x77, 0x20, 0x5D, 0x05, 0x60, 0x30, 0xEC, 0x07, 0x72, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0,
  0x77, 0x20, 0x5D, 0x05, 0x60, 0x30, 0xEC, 0x07, 0x72, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0, 0x77,
  0x20, 0x5D, 0x05, 0x60, 0x30, 0xEC, 0x07, 0x72, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0, 0x77, 0x20,
  0x5D, 0x05, 0x60, 0x30, 0xEC, 0x07, 0x71, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0, 0x77, 0x05, 0xD0,
  0x56, 0x03, 0x0E, 0xC0, 0x77, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0, 0x77, 0x05, 0xD0, 0x56, 0x03,
  0x0E, 0xC0, 0x77, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0, 0x77, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0,
  0x77, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0, 0x77, 0x05, 0xD0, 0x56, 0x03, 0x0E, 0xC0, 0x77, 0x05,
  0xD0, 0x56, 0x03, 0x0E, 0xC0, 0x77, 0x10, 0xAC, 0x05, 0x70, 0x7C, 0x07, 0x73, 0x0A, 0xA0, 0x57,
  0x20, 0x7A, 0x07, 0x75, 0x0A, 0x05, 0x74, 0x00, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_double_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 12, 37, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_double_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_double_arrow_up 48x48, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_double_arrow_up_data[] PROGMEM = {
  0x74, 0x00, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x75, 0x07, 0xC0, 0x77, 0x73, 0x07, 0xE0, 0x77, 0x71,
  0x07, 0xF9, 0x07, 0x76, 0x07, 0xC0, 0x0E, 0xC0, 0x77, 0x40, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x77,
  0x20, 0x7C, 0x0E, 0x03, 0x20, 0x30, 0xEC, 0x07, 0x70, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x07,
  0x50, 0x7C, 0x0E, 0x03, 0x60, 0x30, 0xEC, 0x07, 0x30, 0x7C, 0x0E, 0x03, 0x71, 0x03, 0x0E, 0xC8,
  0x17, 0x07, 0xC0, 0xE0, 0x37, 0x30, 0x30, 0xEC, 0x00, 0x7B, 0x0E, 0x03, 0x75, 0x03, 0x0E, 0xB8,
  0x47, 0x07, 0xFE, 0x36, 0x00, 0x56, 0x82, 0x3E, 0xF7, 0x30, 0x70, 0x36, 0x05, 0xA0, 0x56, 0x03,
  0x07, 0x74, 0x05, 0xC0, 0x57, 0x73, 0x05, 0xE0, 0x57, 0x71, 0x05, 0xF9, 0x05, 0x76, 0x05, 0xFB,
  0x05, 0x74, 0x05, 0xD0, 0x05, 0xD0, 0x57, 0x20, 0x5D, 0x05, 0x20, 0x5D, 0x05, 0x70, 0x5D, 0x05,
  0x40, 0x5D, 0x05, 0x50, 0x5D, 0x05, 0x60, 0x5D, 0x05, 0x30, 0x5D, 0x05, 0x71, 0x05, 0xD8, 0x15,
  0x05, 0xD0, 0x57, 0x30, 0x5D, 0x05, 0x0A, 0xC0, 0x57, 0x50, 0x5C, 0x81, 0xA0, 0xAA, 0x05, 0x77,
  0x05, 0xA0, 0xA3, 0x0A, 0x05, 0x77, 0x20, 0x50, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_double_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 10, 35, 37), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_double_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_hide 48x48, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_hide_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xA2, 0xF4, 0xA4, 0xA4, 0xA4, 0xA4, 0xFD, 0x4A,
  0x4A, 0x4A, 0x4A, 0x4F, 0xD4, 0xA4, 0xA4, 0xA4, 0xA4, 0xFD, 0x4A, 0x4A, 0x4A, 0x4A, 0x48, 0x09,
  0xB0, 0xF4, 0xA4, 0xA4, 0xA4, 0xA4, 0xFD, 0x4A, 0x4A, 0x4A, 0x4A, 0x4F, 0xD4, 0xA4, 0xA4, 0xA4,
  0xA4, 0xFD, 0x4A, 0x4A, 0x4A, 0x4A, 0x48, 0x0A, 0xD6, 0xF7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF,
  0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xD0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A,
  0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x18, 0x0A, 0xD1, 0x00,
  0x7F, 0xF0, 0x77, 0x77, 0x40, 0x7F, 0xD0, 0x77, 0x77, 0x60, 0x7F, 0xB0, 0x77, 0x77, 0x71, 0x07,
  0xF9, 0x07, 0x77, 0x77, 0x30, 0x7E, 0x07, 0x77, 0x77, 0x50, 0x7C, 0x07, 0x77, 0x77, 0x70, 0x7A,
  0x07, 0x80, 0xC1, 0x00, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_hide() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_hide_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_option_key 48x48, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_option_key_data[] PROGMEM = {
  0xFD, 0x04, 0x74, 0xFF, 0xFB, 0x0D, 0x74, 0xFF, 0xFC, 0x06, 0x73, 0xFF, 0xFC, 0x0E, 0x01, 0x72,
  0xFD, 0x72, 0x01, 0x0E, 0xB0, 0x97, 0x77, 0x73, 0x06, 0xC0, 0x27, 0x77, 0x73, 0x0D, 0xB0, 0xB7,
  0x77, 0x73, 0x04, 0xC0, 0x57, 0x77, 0x73, 0x0A, 0xB0, 0xD7, 0x77, 0x73, 0x02, 0xC0, 0x77, 0x77,
  0x73, 0x08, 0xB0, 0xE0, 0x17, 0x77, 0x73, 0x0E, 0xB0, 0x97, 0x77, 0x73, 0x06, 0xC0, 0x37, 0x77,
  0x73, 0x0C, 0xB0, 0xC7, 0x77, 0x73, 0x03, 0xC0, 0x57, 0x77, 0x73, 0x0A, 0xB0, 0xD7, 0x77, 0x73,
  0x01, 0x0E, 0xB0, 0x87, 0x77, 0x73, 0x07, 0xC0, 0x27, 0x77, 0x73, 0x0D, 0xB0, 0xA7, 0x77, 0x73,
  0x05, 0xC0, 0x47, 0x77, 0x73, 0x0C, 0xB0, 0xC7, 0x77, 0x73, 0x03, 0xC0, 0x67, 0x77, 0x73, 0x09,
  0xB0, 0xE0, 0x17, 0x77, 0x72, 0x01, 0x0E, 0xB0, 0x87, 0x77, 0x73, 0x07, 0xFF, 0x77, 0x71, 0x0D,
  0xFE, 0x77, 0x71, 0x05, 0xFE, 0x77, 0x72, 0x0B, 0xFD,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_option_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_option_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard 48x48, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xA2, 0xF4, 0xA4, 0xA4, 0xA4, 0xA4, 0xFD, 0x4A,
  0x4A, 0x4A, 0x4A, 0x4F, 0xD4, 0xA4, 0xA4, 0xA4, 0xA4, 0xFD, 0x4A, 0x4A, 0x4A, 0x4A, 0x48, 0x09,
  0xB0, 0xF4, 0xA4, 0xA4, 0xA4, 0xA4, 0xFD, 0x4A, 0x4A, 0x4A, 0x4A, 0x4F, 0xD4, 0xA4, 0xA4, 0xA4,
  0xA4, 0xFD, 0x4A, 0x4A, 0x4A, 0x4A, 0x48, 0x0A, 0xD6, 0xF7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF,
  0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xD0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A,
  0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_return 48x48, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_return_data[] PROGMEM = {
  0x74, 0x00, 0x77, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x77, 0x75, 0x07, 0xC0, 0x77, 0x75, 0xC7, 0x10,
  0x7C, 0x0E, 0x03, 0x77, 0x5C, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x6C, 0x60, 0x7C, 0x0E, 0x03, 0x77,
  0x7C, 0x50, 0x7C, 0x0E, 0x03, 0x77, 0x71, 0xC4, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x2C, 0x30, 0x7C,
  0x0E, 0x03, 0x77, 0x73, 0xC2, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x4C, 0x10, 0x78, 0x0C, 0x0F, 0x07,
  0x80, 0xC1, 0xF0, 0x78, 0x0C, 0x1F, 0x10, 0x78, 0x0C, 0x0F, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77,
  0x40, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x7C, 0x0E, 0x03,
  0x77, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x7C,
  0x0E, 0x03, 0x77, 0x77, 0x40, 0x7C, 0x07, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x77, 0x70, 0x07,
  0x77, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_return() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 41, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_return_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_tab 48x48, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_tab_data[] PROGMEM = {
  0x77, 0x72, 0x00, 0x77, 0x6C, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x5C, 0x77, 0x70, 0x7C, 0x07, 0x74,
  0xC7, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x3C, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x2C, 0x77, 0x72,
  0x03, 0x0E, 0xC0, 0x77, 0x1C, 0x77, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0xC7, 0x77, 0x40, 0x30, 0xEC,
  0x07, 0x6C, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x75, 0xC7, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x48, 0x0C,
  0x2F, 0x07, 0x38, 0x0C, 0x3F, 0x07, 0x28, 0x0C, 0x3F, 0x07, 0x28, 0x0C, 0x2F, 0x07, 0x3C, 0x77,
  0x76, 0x03, 0x0E, 0xC0, 0x74, 0xC7, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x5C, 0x77, 0x74, 0x03, 0x0E,
  0xC0, 0x76, 0xC7, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x7C, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x1C,
  0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x2C, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x73, 0xC7, 0x77, 0x07,
  0xC0, 0x77, 0x4C, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x5C, 0x77, 0x72, 0x00, 0x77, 0x6C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_tab() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 12, 43, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_tab_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_keyboard_voice 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_filled_48_hardware_keyboard_voice_data[] PROGMEM = {
  0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x60, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x40, 0xCF, 0x90, 0xC7,
  0x73, 0x06, 0xFB, 0x06, 0x77, 0x20, 0xCF, 0xB0, 0xC7, 0x72, 0x0E, 0xFB, 0x0E, 0x77, 0x2F, 0xD7,
  0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72,
  0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x71, 0x0E, 0xA0, 0x74, 0x0E,
  0xFB, 0x0E, 0x40, 0x7A, 0x0E, 0x0D, 0xA0, 0x84, 0x0C, 0xFB, 0x0B, 0x40, 0x8A, 0x0D, 0x0B, 0xA0,
  0xB4, 0x06, 0xFB, 0x06, 0x40, 0xBA, 0x0B, 0x07, 0xB0, 0x14, 0x0C, 0xF9, 0x0C, 0x40, 0x1B, 0x07,
  0x02, 0xB0, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x07, 0xB8, 0x12, 0x0B, 0xA0, 0xE0, 0x15, 0x84,
  0x6C, 0xEE, 0xC6, 0x50, 0x10, 0xEA, 0x0B, 0x20, 0x3B, 0x0C, 0x77, 0x20, 0xCB, 0x03, 0x30, 0x8B,
  0x0B, 0x01, 0x75, 0x01, 0x0B, 0xB0, 0x85, 0x0B, 0xB0, 0xD0, 0x47, 0x30, 0x40, 0xDB, 0x0B, 0x60,
  0x10, 0xBC, 0x81, 0xC6, 0x14, 0x81, 0x16, 0xCC, 0x0B, 0x01, 0x71, 0x0A, 0xE8, 0x2E, 0xDD, 0xEE,
  0x0A, 0x74, 0x05, 0x0D, 0xFD, 0x0E, 0x05, 0x77, 0x05, 0x0C, 0xF9, 0x0C, 0x06, 0x77, 0x40, 0x10,
  0x4C, 0x04, 0x01, 0x77, 0x71, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7,
  0x77, 0x3C, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_keyboard_voice() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 43), Box(0, 0, 47, 47),
      ic_filled_48_hardware_keyboard_voice_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_laptop_chromebook 48x48, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_filled_48_hardware_laptop_chromebook_data[] PROGMEM = {
  0x48, 0x0C, 0x4F, 0x71, 0x80, 0xC4, 0xF7, 0x18, 0x0C, 0x4F, 0x71, 0x80, 0xC4, 0xF7, 0x1C, 0x77,
  0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7,
  0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77,
  0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71,
  0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77,
  0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C,
  0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x18, 0x0C, 0x4F, 0x71, 0x80, 0xC4, 0xF7, 0x18,
  0x0C, 0x4F, 0x71, 0x80, 0xC4, 0xF7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA4,
  0x80, 0xAF, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_laptop_chromebook() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 47, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_laptop_chromebook_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_laptop_mac 48x48, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_filled_48_hardware_laptop_mac_data[] PROGMEM = {
  0x58, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0x80, 0xC0, 0xF0, 0xE0, 0x17,
  0x10, 0xA8, 0x0C, 0x2F, 0x0A, 0x71, 0x0D, 0x80, 0xC2, 0xF0, 0xD7, 0x1C, 0x77, 0x77, 0x4C, 0x71,
  0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77,
  0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C,
  0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74,
  0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7,
  0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C,
  0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x10, 0xD8,
  0x0C, 0x2F, 0x0D, 0x71, 0x0A, 0x80, 0xC2, 0xF0, 0x97, 0x10, 0x10, 0xEF, 0xFA, 0x82, 0xB1, 0x1B,
  0xFF, 0xA0, 0xE0, 0x17, 0x28, 0x11, 0xAD, 0xFF, 0x01, 0x20, 0x1F, 0xF8, 0x1D, 0xA1, 0x50, 0xDF,
  0xFF, 0x01, 0x20, 0x1F, 0xFF, 0x0D, 0x0A, 0xFF, 0xF8, 0x2B, 0x11, 0xBF, 0xFF, 0x81, 0xA1, 0xE8,
  0x0D, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC4, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_laptop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 47, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_laptop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_laptop 48x48, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_filled_48_hardware_laptop_data[] PROGMEM = {
  0x58, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0x80, 0xC0, 0xF0, 0xE0, 0x17,
  0x10, 0xA8, 0x0C, 0x2F, 0x0A, 0x71, 0x0D, 0x80, 0xC2, 0xF0, 0xD7, 0x1C, 0x77, 0x77, 0x4C, 0x71,
  0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77,
  0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C,
  0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74,
  0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7,
  0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C,
  0x71, 0xC7, 0x77, 0x74, 0xC7, 0x10, 0xD8, 0x0C, 0x2F, 0x0D, 0x71, 0x0A, 0x80, 0xC2, 0xF0, 0xA7,
  0x10, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x15,
  0x80, 0xAF, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_laptop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_laptop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_laptop_windows 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_filled_48_hardware_laptop_windows_data[] PROGMEM = {
  0x58, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0x80, 0xC0, 0xF0, 0xE0, 0x17,
  0x10, 0xA8, 0x0C, 0x2F, 0x0A, 0x71, 0x0D, 0x80, 0xC2, 0xF0, 0xD7, 0x1C, 0x77, 0x77, 0x4C, 0x71,
  0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77,
  0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C,
  0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74,
  0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7,
  0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C,
  0x71, 0xC7, 0x77, 0x74, 0xC7, 0x10, 0xD8, 0x0C, 0x2F, 0x0D, 0x71, 0x0A, 0x80, 0xC2, 0xF0, 0x97,
  0x10, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x17,
  0x6F, 0xFF, 0xFC, 0x77, 0x2F, 0xFF, 0xFC, 0x71, 0x80, 0xAF, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_laptop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 47, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_laptop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_memory 48x48, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_filled_48_hardware_memory_data[] PROGMEM = {
  0x75, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x38, 0x11,
  0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x71, 0x0A, 0xFF, 0xFD,
  0x0A, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76,
  0xC7, 0x1C, 0x77, 0x6C, 0x4F, 0x94, 0xFD, 0x4F, 0xFA, 0x4F, 0xD4, 0xFF, 0xA4, 0xFD, 0x4F, 0xFA,
  0x4F, 0xD4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4C, 0x71, 0xC4, 0xC4, 0xC4, 0xC7, 0x1C, 0x4C, 0x4C, 0x4C,
  0x71, 0xC4, 0xC4, 0xC4, 0xC4, 0xF9, 0x4F, 0xD4, 0xFF, 0xA4, 0xFD, 0x4F, 0xFA, 0x4F, 0xD4, 0xFF,
  0xA4, 0xFD, 0x4F, 0x94, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77,
  0x6C, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x71, 0x0A, 0xFF, 0xFD, 0x0A, 0x71, 0x01, 0x0E, 0xFF, 0xFB,
  0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x17, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C,
  0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_memory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_memory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_monitor 48x48, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_filled_48_hardware_monitor_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0,
  0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x17, 0x30, 0x7F, 0xFE, 0x07, 0x77, 0x30,
  0x7F, 0xFF, 0x90, 0x77, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F,
  0xFF, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_mouse 48x48, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_filled_48_hardware_mouse_data[] PROGMEM = {
  0x74, 0x81, 0x48, 0xB4, 0x81, 0xB8, 0x47, 0x75, 0x81, 0x18, 0xEB, 0x4B, 0x81, 0xE8, 0x17, 0x71,
  0x07, 0xE4, 0xE0, 0x77, 0x50, 0x10, 0xCF, 0x4F, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xF9, 0x4F, 0x90,
  0xD0, 0x27, 0x01, 0x0E, 0xFA, 0x4F, 0xA0, 0xE0, 0x16, 0x0C, 0xFB, 0x4F, 0xB0, 0xC5, 0x08, 0xFC,
  0x4F, 0xC0, 0x83, 0x01, 0xFD, 0x4F, 0xD0, 0x12, 0x08, 0xFD, 0x4F, 0xD0, 0x82, 0x0E, 0xFD, 0x4F,
  0xD8, 0x1E, 0x04, 0xFE, 0x4F, 0xE0, 0x40, 0x8F, 0xE4, 0xFE, 0x08, 0x0B, 0xFE, 0x4F, 0xE0, 0xB0,
  0xDF, 0xE4, 0xFE, 0x0D, 0x0E, 0xFE, 0x4F, 0xE0, 0xE8, 0x09, 0xF4, 0x08, 0x0B, 0xF4, 0xF0, 0xEF,
  0xFF, 0xFA, 0x0E, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xBF, 0xFF, 0xFA, 0x0B, 0x09, 0xFF, 0xFF, 0xA0,
  0x90, 0x4F, 0xFF, 0xFA, 0x81, 0x40, 0xEF, 0xFF, 0xF0, 0xE2, 0x09, 0xFF, 0xFF, 0x09, 0x20, 0x10,
  0xEF, 0xFF, 0xD0, 0xE0, 0x13, 0x07, 0xFF, 0xFD, 0x07, 0x50, 0xCF, 0xFF, 0xB0, 0xC6, 0x01, 0x0D,
  0xFF, 0xF9, 0x0D, 0x01, 0x70, 0x20, 0xDF, 0xFE, 0x0D, 0x02, 0x72, 0x01, 0x0C, 0xFF, 0xC0, 0xC0,
  0x17, 0x50, 0x70, 0xEF, 0xF0, 0xE0, 0x77, 0x71, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77, 0x58,
  0x90, 0x49, 0xBD, 0xEE, 0xDB, 0x94, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_mouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_mouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_pallet 48x48, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_filled_48_hardware_pallet_data[] PROGMEM = {
  0x60, 0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x47, 0x50, 0xDF, 0xFF, 0xD0, 0xD7, 0x5F, 0xFF, 0xF7, 0x5F,
  0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0x97,
  0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0xFF,
  0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7,
  0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F,
  0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x50, 0xDF, 0xFF, 0xD0, 0xD7, 0x50, 0x40, 0xDF,
  0xFF, 0xB0, 0xD0, 0x48, 0x0A, 0xC2, 0x08, 0x0A, 0xC2, 0xF7, 0x4E, 0x74, 0xFD, 0x74, 0xE7, 0x4F,
  0xD7, 0x4E, 0x74, 0xFD, 0x74, 0xE7, 0x4E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_pallet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_hardware_pallet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_phone_android 48x48, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_filled_48_hardware_phone_android_data[] PROGMEM = {
  0x38, 0x16, 0xCE, 0xFF, 0xA8, 0x1E, 0xC6, 0x40, 0x10, 0xCF, 0xFF, 0x90, 0xC0, 0x12, 0x0C, 0xFF,
  0xFB, 0x81, 0xC0, 0x6F, 0xFF, 0xD0, 0x60, 0xCF, 0xFF, 0xD0, 0xC0, 0xEF, 0xFF, 0xD0, 0xEB, 0x07,
  0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07,
  0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07,
  0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07,
  0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07,
  0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07,
  0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07,
  0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x60, 0x78, 0x09,
  0xD7, 0xF0, 0xEF, 0xA7, 0x1F, 0xA0, 0xE0, 0xCF, 0xA7, 0x1F, 0xA0, 0xC0, 0x6F, 0xFF, 0xD8, 0x16,
  0x0C, 0xFF, 0xFB, 0x0C, 0x20, 0x10, 0xCF, 0xFF, 0x90, 0xC0, 0x14, 0x81, 0x6C, 0xEF, 0xFA, 0x81,
  0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_phone_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_phone_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_phone_iphone 48x48, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_filled_48_hardware_phone_iphone_data[] PROGMEM = {
  0x28, 0x14, 0xBE, 0xFF, 0xA8, 0x1E, 0xB4, 0x30, 0x8F, 0xFF, 0x98, 0x18, 0x04, 0xFF, 0xFB, 0x04,
  0x0B, 0xFF, 0xFB, 0x0B, 0x0E, 0xFF, 0xFB, 0x0E, 0xFF, 0xFF, 0xA7, 0x74, 0xF9, 0x77, 0x4F, 0x97,
  0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74,
  0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9,
  0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77,
  0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x48,
  0x0F, 0x7F, 0x82, 0x71, 0x17, 0xFF, 0xF0, 0x74, 0x07, 0xFF, 0xE0, 0x14, 0x01, 0xFB, 0x0E, 0xFA,
  0x01, 0x40, 0x1F, 0xA0, 0xE0, 0xBF, 0xA0, 0x74, 0x07, 0xFA, 0x0B, 0x04, 0xFB, 0x82, 0x71, 0x17,
  0xFB, 0x81, 0x40, 0x8F, 0xFF, 0x90, 0x83, 0x81, 0x4B, 0xEF, 0xFA, 0x81, 0xEB, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_phone_iphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 35, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_phone_iphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_phonelink_off 48x48, 4-bit Alpha,  RLE, 345 bytes.
static const unsigned char ic_filled_48_hardware_phonelink_off_data[] PROGMEM = {
  0x30, 0x50, 0x28, 0x0D, 0x10, 0x82, 0x5F, 0xD2, 0x80, 0xC7, 0x00, 0x5B, 0x0D, 0x02, 0x80, 0xC6,
  0x00, 0x20, 0xDB, 0x0D, 0x02, 0x80, 0xC6, 0x00, 0x20, 0xDB, 0x0D, 0x02, 0x80, 0xC6, 0x00, 0x20,
  0xDB, 0x0D, 0x02, 0x30, 0x10, 0xCF, 0xFF, 0xF9, 0x71, 0x03, 0xC0, 0xD0, 0x23, 0x01, 0x0C, 0xFF,
  0xFF, 0x71, 0x09, 0xD0, 0xD0, 0x23, 0x01, 0x0C, 0xFF, 0xFE, 0x71, 0x0E, 0xE0, 0xD0, 0x23, 0x01,
  0x0C, 0xFF, 0xFD, 0x71, 0xC0, 0xDB, 0x0D, 0x02, 0x80, 0xC2, 0x0C, 0x02, 0x0D, 0xB0, 0xD0, 0x28,
  0x0C, 0x10, 0xC1, 0x02, 0x0D, 0xB0, 0xD0, 0x28, 0x0C, 0x00, 0xC2, 0x02, 0x0D, 0xB0, 0xD0, 0x27,
  0x77, 0x77, 0xC3, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x70, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0xC4, 0x02,
  0x0D, 0xB0, 0xD0, 0x27, 0x60, 0xDF, 0xF0, 0xD4, 0xC5, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x5F, 0xFA,
  0x4C, 0x60, 0x20, 0xDB, 0x0D, 0x02, 0x74, 0xFF, 0xA4, 0xC7, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x3C,
  0x71, 0xC4, 0xC7, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x72, 0xC7, 0x1C, 0x4C, 0x72, 0x02, 0x0D, 0xB0,
  0xD0, 0x27, 0x1C, 0x71, 0xC4, 0xC7, 0x30, 0x20, 0xDB, 0x0D, 0x02, 0x7C, 0x71, 0xC4, 0xC7, 0x40,
  0x20, 0xDB, 0x0D, 0x02, 0x6C, 0x71, 0xC4, 0xC7, 0x50, 0x20, 0xDB, 0x0D, 0x02, 0x5C, 0x71, 0xC4,
  0xC7, 0x60, 0x20, 0xDB, 0x0D, 0x02, 0x40, 0xCB, 0x71, 0xC4, 0xC7, 0x70, 0x20, 0xDB, 0x0D, 0x02,
  0x30, 0x10, 0xCA, 0x71, 0xC4, 0xC7, 0x71, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0x97, 0x1C,
  0x4C, 0x77, 0x20, 0x20, 0xDB, 0x0D, 0x02, 0x30, 0x10, 0xC7, 0x1C, 0x4C, 0x77, 0x30, 0x20, 0xDB,
  0x0D, 0x02, 0x30, 0x17, 0x1C, 0x4C, 0x77, 0x40, 0x20, 0xDB, 0x0D, 0x02, 0x74, 0xC4, 0xC7, 0x75,
  0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x3C, 0x4C, 0x77, 0x60, 0x20, 0xDB, 0x0D, 0x02, 0x72, 0x80, 0xC2,
  0xF0, 0xD0, 0x23, 0x01, 0x0C, 0x80, 0xC6, 0xF0, 0xD0, 0x23, 0x01, 0x0C, 0x80, 0xC6, 0xF0, 0xD0,
  0x23, 0x01, 0x0C, 0x80, 0xC6, 0xF0, 0xD0, 0x23, 0x01, 0x0C, 0x80, 0xC6, 0xF0, 0xD0, 0x23, 0x01,
  0x0C, 0xA0, 0xD8, 0x0C, 0x3F, 0x0D, 0x02, 0x38, 0x21, 0xCD, 0x47, 0x77, 0x77, 0x02, 0x0D, 0xB0,
  0xD0, 0x28, 0x0C, 0x60, 0x02, 0x0D, 0xB0, 0xD0, 0x28, 0x0C, 0x60, 0x02, 0x0D, 0xB0, 0x58, 0x0C,
  0x70, 0x82, 0x2D, 0xF5, 0x80, 0xD1, 0x00, 0x20, 0x57,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_phonelink_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 47, 44), Box(0, 0, 47, 47),
      ic_filled_48_hardware_phonelink_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_phonelink 48x48, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_filled_48_hardware_phonelink_data[] PROGMEM = {
  0x58, 0x11, 0xAD, 0x80, 0xC0, 0xF7, 0x10, 0x10, 0xE8, 0x0C, 0x2F, 0x71, 0x0A, 0x80, 0xC3, 0xF7,
  0x10, 0xD8, 0x0C, 0x3F, 0x71, 0xC8, 0x0D, 0x00, 0xC8, 0x0D, 0x00, 0xC8, 0x0D, 0x00, 0xC8, 0x0D,
  0x00, 0xC7, 0x77, 0x30, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0xC7, 0x77, 0x30, 0xDF, 0xF0, 0xD4, 0xC7,
  0x77, 0x3F, 0xFA, 0x4C, 0x77, 0x73, 0xFF, 0xA4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C,
  0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71,
  0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4,
  0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7,
  0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xFF, 0xFF, 0xC4,
  0x80, 0xD0, 0xF4, 0x80, 0xD0, 0xF4, 0x80, 0xD0, 0xF4, 0x80, 0xD0, 0xF4, 0x0D, 0xFF, 0x0D, 0xFF,
  0xFF, 0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_phonelink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_phonelink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_point_of_sale 48x48, 4-bit Alpha,  RLE, 232 bytes.
static const unsigned char ic_filled_48_hardware_point_of_sale_data[] PROGMEM = {
  0x78, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x76, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x75, 0x0A,
  0xFF, 0xFD, 0x0A, 0x75, 0x0D, 0xFF, 0xFD, 0x0D, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75,
  0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0x0D, 0xFF, 0xFD, 0x0D, 0x75, 0x0A, 0xFF, 0xFD, 0x0A,
  0x75, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x76, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x18, 0x09,
  0xB3, 0x00, 0x50, 0xCF, 0xFE, 0x0C, 0x05, 0x77, 0x10, 0x7F, 0xFF, 0xB0, 0x77, 0x60, 0x1F, 0xFF,
  0xD0, 0x17, 0x50, 0x8F, 0xFF, 0xD0, 0x87, 0x50, 0xED, 0x03, 0x20, 0x3A, 0x03, 0x20, 0x3A, 0x03,
  0x20, 0x3D, 0x0E, 0x74, 0x06, 0xE0, 0x32, 0x03, 0xA0, 0x32, 0x03, 0xA0, 0x32, 0x03, 0xE0, 0x67,
  0x30, 0xDF, 0xFF, 0xF0, 0xD7, 0x20, 0x5F, 0xFF, 0xFA, 0x05, 0x71, 0x0C, 0xF0, 0x32, 0x03, 0xA0,
  0x32, 0x03, 0xA0, 0x32, 0x03, 0xF0, 0xC7, 0x03, 0xF9, 0x03, 0x20, 0x3A, 0x03, 0x20, 0x3A, 0x03,
  0x20, 0x3F, 0x90, 0x36, 0x0A, 0xFF, 0xFF, 0xC0, 0xA5, 0x01, 0xFF, 0xFF, 0xE0, 0x14, 0x08, 0xFA,
  0x03, 0x20, 0x3A, 0x03, 0x20, 0x3A, 0x03, 0x20, 0x3F, 0xA0, 0x84, 0x0E, 0xFA, 0x03, 0x20, 0x3A,
  0x03, 0x20, 0x3A, 0x03, 0x20, 0x3F, 0xA0, 0xE3, 0x06, 0x80, 0xC0, 0xF0, 0x62, 0x0D, 0x80, 0xC0,
  0xF8, 0x1D, 0x05, 0x80, 0xC2, 0xF0, 0x50, 0xC8, 0x0C, 0x2F, 0x0C, 0x80, 0x99, 0x40, 0x80, 0x99,
  0x4F, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1,
  0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_point_of_sale() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_hardware_point_of_sale_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_power_input 48x48, 4-bit Alpha,  RLE, 21 bytes.
static const unsigned char ic_filled_48_hardware_power_input_data[] PROGMEM = {
  0x80, 0xAA, 0x4F, 0x80, 0xAA, 0x40, 0xFB, 0x4F, 0xB4, 0xFF, 0xE4, 0xFB, 0x4F, 0xFE, 0x4F, 0xB4,
  0xFF, 0xE4, 0xFB, 0x4F, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_power_input() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 18, 41, 29), Box(0, 0, 47, 47),
      ic_filled_48_hardware_power_input_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_router 48x48, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_filled_48_hardware_router_data[] PROGMEM = {
  0x77, 0x78, 0x90, 0x37, 0xBD, 0xEE, 0xDB, 0x73, 0x77, 0x73, 0x04, 0x0C, 0xFB, 0x0C, 0x04, 0x77,
  0x60, 0x10, 0xBB, 0x86, 0xEA, 0x87, 0x78, 0xAE, 0xB0, 0xB0, 0x17, 0x73, 0x03, 0x0E, 0xA0, 0xC0,
  0x57, 0x10, 0x50, 0xCA, 0x0E, 0x03, 0x77, 0x28, 0x2A, 0xFE, 0x54, 0x82, 0x35, 0x53, 0x48, 0x25,
  0xEF, 0xA7, 0x73, 0x08, 0x02, 0x28, 0x12, 0xAE, 0xC8, 0x1E, 0xA2, 0x20, 0x20, 0x87, 0x77, 0x07,
  0xFB, 0x07, 0x77, 0x72, 0x05, 0xA8, 0x1D, 0x72, 0x28, 0x12, 0x7D, 0xA0, 0x57, 0x77, 0x20, 0x70,
  0x97, 0x10, 0x90, 0x78, 0x0A, 0x84, 0x0C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C,
  0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x72, 0x81, 0x1A, 0xDF,
  0xFF, 0xF8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xFC, 0x81, 0xE1, 0xAF, 0xFF, 0xFE, 0x0A, 0x0D, 0xFF,
  0xFF, 0xE0, 0xD8, 0x09, 0x92, 0xF4, 0xB4, 0xB4, 0xFF, 0xC4, 0xB4, 0xB4, 0xFF, 0xC4, 0xB4, 0xB4,
  0xFF, 0xC4, 0xB4, 0xB4, 0x80, 0x9A, 0x0F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81,
  0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_router() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_router_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_scanner 48x48, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_filled_48_hardware_scanner_data[] PROGMEM = {
  0x28, 0x1B, 0x93, 0x77, 0x77, 0x40, 0x2B, 0x81, 0xD7, 0x27, 0x77, 0x71, 0x08, 0xE8, 0x1B, 0x61,
  0x77, 0x75, 0x0C, 0xFA, 0x0A, 0x04, 0x77, 0x74, 0x05, 0x0A, 0xFA, 0x81, 0xE8, 0x37, 0x77, 0x38,
  0x11, 0x6C, 0xFA, 0x81, 0xD7, 0x17, 0x77, 0x38, 0x12, 0x7D, 0xFA, 0x0B, 0x05, 0x77, 0x74, 0x81,
  0x39, 0xEF, 0x98, 0x1E, 0xA4, 0x77, 0x74, 0x05, 0x0A, 0xFA, 0x81, 0xE8, 0x37, 0x77, 0x38, 0x11,
  0x6B, 0xFA, 0x81, 0xC7, 0x17, 0x77, 0x38, 0x11, 0x7D, 0xFA, 0x0B, 0x05, 0x77, 0x74, 0x81, 0x38,
  0xEF, 0x98, 0x1E, 0x92, 0x77, 0x74, 0x81, 0x4A, 0xEF, 0x0E, 0x02, 0x77, 0x76, 0x05, 0x0B, 0xE8,
  0x3A, 0x01, 0xAD, 0xFF, 0xFF, 0xB8, 0x1E, 0x1E, 0xFF, 0xFF, 0xE0, 0xAF, 0xFF, 0xFF, 0x0D, 0x80,
  0x9D, 0x3F, 0x4C, 0x77, 0x6F, 0x94, 0xC7, 0x76, 0xF9, 0x4C, 0x77, 0x6F, 0x94, 0xC7, 0x76, 0x80,
  0x99, 0x0F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84,
  0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_security 48x48, 4-bit Alpha,  RLE, 259 bytes.
static const unsigned char ic_filled_48_hardware_security_data[] PROGMEM = {
  0x77, 0x28, 0x25, 0xCC, 0x57, 0x77, 0x72, 0x06, 0x0D, 0xC0, 0xD0, 0x67, 0x77, 0x48, 0x11, 0x8E,
  0xF9, 0x81, 0xE8, 0x17, 0x76, 0x03, 0x0A, 0xFF, 0x0A, 0x03, 0x77, 0x20, 0x50, 0xCF, 0x90, 0x9F,
  0xA0, 0xC0, 0x57, 0x50, 0x60, 0xDF, 0x81, 0xE7, 0x11, 0xFC, 0x0D, 0x06, 0x78, 0x11, 0x8E, 0xF0,
  0xC0, 0x54, 0xFE, 0x81, 0xE8, 0x12, 0x03, 0x0A, 0xF9, 0x0A, 0x04, 0x6F, 0xFA, 0x0A, 0x03, 0xF9,
  0x09, 0x02, 0x71, 0xFF, 0xFA, 0x81, 0xE7, 0x17, 0x3F, 0xFF, 0x90, 0x57, 0x6F, 0xFF, 0x97, 0x7F,
  0xFF, 0x97, 0x7F, 0xFF, 0x97, 0x7F, 0xFF, 0x97, 0x7F, 0xFF, 0x97, 0x7F, 0xFF, 0x97, 0x7F, 0xFF,
  0x97, 0x7F, 0xFF, 0x97, 0x7F, 0xFF, 0x97, 0x7F, 0xFC, 0x0E, 0xB7, 0x7F, 0xFB, 0x0E, 0x0D, 0xB7,
  0x7F, 0xFB, 0x0D, 0x0C, 0xFF, 0xB7, 0x60, 0x1B, 0x0C, 0x0A, 0xFF, 0xB7, 0x60, 0x4B, 0x0A, 0x08,
  0xFF, 0xB7, 0x60, 0x7B, 0x08, 0x04, 0xFF, 0xB7, 0x60, 0xBB, 0x04, 0x1F, 0xFB, 0x75, 0x01, 0xC2,
  0x0C, 0xFF, 0xA7, 0x50, 0x6B, 0x0C, 0x20, 0x7F, 0xFA, 0x75, 0x0D, 0xB0, 0x72, 0x01, 0x0E, 0xFF,
  0x97, 0x40, 0x5B, 0x0E, 0x01, 0x30, 0x9F, 0xF9, 0x74, 0x0D, 0xB0, 0x94, 0x02, 0xFF, 0x97, 0x30,
  0x7C, 0x02, 0x50, 0x9F, 0xF7, 0x20, 0x3C, 0x09, 0x70, 0xDF, 0xE7, 0x10, 0x10, 0xDB, 0x0D, 0x71,
  0x05, 0xFE, 0x71, 0x0B, 0xC0, 0x57, 0x20, 0x9F, 0xD7, 0x0B, 0xC0, 0x97, 0x40, 0xBF, 0xC5, 0x01,
  0x0C, 0xC0, 0xB7, 0x60, 0xCF, 0xB4, 0x05, 0x0E, 0xC0, 0xC7, 0x70, 0x10, 0xCF, 0xA2, 0x02, 0x0B,
  0xD0, 0xC0, 0x17, 0x72, 0x0A, 0xF9, 0x05, 0x0B, 0xE0, 0xA7, 0x75, 0x07, 0xFF, 0x07, 0x77, 0x70,
  0x20, 0xAF, 0xB0, 0xA0, 0x27, 0x77, 0x30, 0x40, 0xCE, 0x0C, 0x04, 0x77, 0x77, 0x84, 0x27, 0xCC,
  0x72, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_security() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_security_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_sim_card 48x48, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_filled_48_hardware_sim_card_data[] PROGMEM = {
  0x74, 0x07, 0xFF, 0xA8, 0x1D, 0xA1, 0x74, 0x07, 0xFF, 0xD0, 0xE0, 0x17, 0x20, 0x7F, 0xFF, 0x09,
  0x71, 0x07, 0xFF, 0xF9, 0x0D, 0x70, 0x7F, 0xFF, 0xB6, 0x07, 0xFF, 0xFC, 0x50, 0x7F, 0xFF, 0xD4,
  0x07, 0xFF, 0xFE, 0x30, 0x7F, 0xFF, 0xF2, 0x07, 0xFF, 0xFF, 0x91, 0x07, 0xFF, 0xFF, 0xA0, 0x78,
  0x0B, 0xC1, 0xF4, 0xC4, 0xC4, 0xFD, 0x4C, 0x4C, 0x4F, 0xD4, 0xC4, 0xC4, 0xFD, 0x4C, 0x4C, 0x4F,
  0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xFE, 0x4F, 0xFF, 0xF4,
  0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xE4, 0xC4, 0xC4, 0xFD, 0x4C, 0x4C, 0x4F, 0xD4, 0xC4, 0xC4,
  0xFD, 0x4C, 0x4C, 0x48, 0x09, 0x82, 0xF0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A,
  0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFB, 0x81, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_sim_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_filled_48_hardware_sim_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_smart_display 48x48, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_filled_48_hardware_smart_display_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0A, 0x83, 0xF0, 0x50, 0xD8, 0x0C, 0x2F, 0x10, 0x10,
  0x98, 0x0C, 0x1F, 0x30, 0x30, 0xDF, 0xFF, 0xFF, 0x50, 0x8F, 0xFF, 0xFE, 0x60, 0x30, 0xCF, 0xFF,
  0xFC, 0x71, 0x07, 0x0E, 0xFF, 0xFF, 0xA7, 0x20, 0x20, 0xBF, 0xFF, 0xF9, 0x74, 0x06, 0x0E, 0xFF,
  0xFE, 0x75, 0x01, 0x0A, 0xFF, 0xFD, 0x75, 0x01, 0x0A, 0xFF, 0xFD, 0x74, 0x06, 0x0E, 0xFF, 0xFE,
  0x72, 0x02, 0x0B, 0xFF, 0xFF, 0x97, 0x10, 0x70, 0xEF, 0xFF, 0xFA, 0x60, 0x30, 0xCF, 0xFF, 0xFC,
  0x50, 0x8F, 0xFF, 0xFE, 0x30, 0x30, 0xDF, 0xFF, 0xFF, 0x10, 0x10, 0x98, 0x0C, 0x1F, 0x05, 0x0D,
  0x80, 0xA9, 0x3F, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F,
  0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_smart_display() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_smart_display_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_smartphone 48x48, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_filled_48_hardware_smartphone_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0x9E, 0x0F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x0F, 0x0D,
  0xFF, 0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_smartphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_smartphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_smart_screen 48x48, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_filled_48_hardware_smart_screen_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDF, 0xB7, 0x77, 0x3F, 0xFE, 0x77, 0x73, 0xFF, 0xE7, 0x77,
  0x3F, 0xFE, 0x77, 0x73, 0xFF, 0xE7, 0x77, 0x3F, 0xFE, 0x77, 0x73, 0xFF, 0xE7, 0x77, 0x3F, 0xFE,
  0x77, 0x73, 0xFF, 0xE3, 0x0F, 0x72, 0x0F, 0x72, 0x0F, 0x72, 0x0F, 0x73, 0xFF, 0xE3, 0xB2, 0xB2,
  0xB2, 0xB3, 0xFF, 0xE3, 0xB2, 0xB2, 0xB2, 0xB3, 0xFF, 0xE3, 0x0F, 0x72, 0x0F, 0x72, 0x0F, 0x72,
  0x0F, 0x73, 0xFF, 0xE7, 0x77, 0x3F, 0xFE, 0x77, 0x73, 0xFF, 0xE7, 0x77, 0x3F, 0xFE, 0x77, 0x73,
  0xFF, 0xE7, 0x77, 0x3F, 0xFE, 0x77, 0x73, 0xFF, 0xE7, 0x77, 0x3F, 0xFE, 0x77, 0x73, 0xFB, 0x0D,
  0x80, 0xC6, 0xF0, 0xD0, 0xA8, 0x0C, 0x6F, 0x81, 0xA1, 0xE8, 0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD,
  0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_smart_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_filled_48_hardware_smart_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_smart_toy 48x48, 4-bit Alpha,  RLE, 235 bytes.
static const unsigned char ic_filled_48_hardware_smart_toy_data[] PROGMEM = {
  0x77, 0x58, 0x46, 0xCE, 0xEC, 0x68, 0x0C, 0x00, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x76, 0x0C,
  0xF9, 0x0C, 0x77, 0x77, 0x50, 0x6F, 0xB0, 0x67, 0x77, 0x74, 0x0C, 0xFB, 0x0C, 0x77, 0x77, 0x40,
  0xEF, 0xB0, 0xE7, 0x77, 0x28, 0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x17, 0x60, 0x10, 0xEF, 0xFF,
  0xF0, 0xE0, 0x17, 0x50, 0xAF, 0xFF, 0xFA, 0x0A, 0x75, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x5F, 0xFF,
  0xFC, 0x75, 0xFF, 0xFF, 0xC7, 0x5F, 0xFF, 0xFC, 0x75, 0xFF, 0xFF, 0xC7, 0x28, 0x16, 0xCE, 0xFF,
  0xFF, 0xC8, 0x1E, 0xC6, 0x40, 0x10, 0xC8, 0x0C, 0x2F, 0x0C, 0x01, 0x20, 0xCF, 0xD8, 0x27, 0x11,
  0x7F, 0x98, 0x27, 0x11, 0x7F, 0xD8, 0x1C, 0x06, 0xFD, 0x07, 0x40, 0x7E, 0x07, 0x40, 0x7F, 0xD0,
  0x60, 0xCF, 0xD0, 0x14, 0x01, 0xE0, 0x14, 0x01, 0xFD, 0x0C, 0x0E, 0xFD, 0x01, 0x40, 0x1E, 0x01,
  0x40, 0x1F, 0xD0, 0x0E, 0xFD, 0x07, 0x40, 0x7E, 0x07, 0x40, 0x7F, 0xD0, 0xE0, 0xCF, 0xE8, 0x27,
  0x11, 0x7F, 0x98, 0x27, 0x11, 0x7F, 0xE0, 0xC0, 0x68, 0x0C, 0x6F, 0x81, 0x60, 0xC8, 0x0C, 0x4F,
  0x0C, 0x20, 0x10, 0xC8, 0x0C, 0x2F, 0x0C, 0x01, 0x48, 0x16, 0xCE, 0xFF, 0xFF, 0xC8, 0x1E, 0xC6,
  0x72, 0xF9, 0x77, 0x2F, 0x97, 0x5F, 0x97, 0x72, 0xF9, 0x75, 0xF9, 0x77, 0x2F, 0x97, 0x5F, 0x97,
  0x72, 0xF9, 0x75, 0xFF, 0xFF, 0xC7, 0x5F, 0xFF, 0xFC, 0x75, 0xFF, 0xFF, 0xC7, 0x5F, 0xFF, 0xFC,
  0x75, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x50, 0xAF, 0xFF, 0xFA, 0x0A, 0x75, 0x01, 0x0E, 0xFF, 0xFF,
  0x0E, 0x01, 0x76, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_smart_toy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_smart_toy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_speaker_group 48x48, 4-bit Alpha,  RLE, 245 bytes.
static const unsigned char ic_filled_48_hardware_speaker_group_data[] PROGMEM = {
  0x72, 0x81, 0x3B, 0xEF, 0xFA, 0x81, 0xEB, 0x37, 0x20, 0x3F, 0xFF, 0x90, 0x37, 0x10, 0xBF, 0xFF,
  0x90, 0xB7, 0x10, 0xEF, 0xFF, 0x90, 0xE7, 0x1F, 0xA8, 0x4D, 0x51, 0x15, 0xDF, 0xA7, 0x1F, 0x90,
  0xD0, 0x14, 0x01, 0x0D, 0xF9, 0x71, 0xF9, 0x05, 0x60, 0x5F, 0x97, 0x1F, 0x90, 0x16, 0x01, 0xFD,
  0x4F, 0x90, 0x16, 0x01, 0xFD, 0x4F, 0x90, 0x56, 0x05, 0xFD, 0x4F, 0x90, 0xD0, 0x14, 0x01, 0x0D,
  0xFD, 0x4F, 0xA8, 0x4D, 0x51, 0x15, 0xDF, 0xE4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F,
  0x98, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xFD, 0x4F, 0x06, 0x71, 0x06, 0xFC, 0x4E, 0x04, 0x73, 0x04,
  0xFB, 0x4D, 0x06, 0x38, 0x44, 0xBE, 0xEB, 0x43, 0x06, 0xFA, 0x4C, 0x0C, 0x30, 0x8E, 0x08, 0x30,
  0xCF, 0x94, 0xC0, 0x62, 0x04, 0xF9, 0x04, 0x20, 0x6F, 0x94, 0xC0, 0x22, 0x0B, 0xF9, 0x0B, 0x20,
  0x2F, 0x94, 0xC3, 0x0E, 0xF9, 0x0E, 0x3F, 0x94, 0xC3, 0x0E, 0xF9, 0x0E, 0x3F, 0x94, 0xC0, 0x22,
  0x0B, 0xF9, 0x0B, 0x20, 0x2F, 0x94, 0xC0, 0x62, 0x04, 0xF9, 0x04, 0x20, 0x6F, 0x94, 0xC0, 0xC3,
  0x08, 0xE0, 0x83, 0x0C, 0xF9, 0x4D, 0x06, 0x38, 0x44, 0xBE, 0xEB, 0x43, 0x06, 0xFA, 0x4E, 0x04,
  0x73, 0x04, 0xFB, 0x4F, 0x06, 0x71, 0x06, 0xFC, 0x4F, 0x98, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xFD,
  0x4F, 0xFF, 0xF4, 0x0E, 0xFF, 0xF9, 0x0E, 0xC4, 0x0B, 0xFF, 0xF9, 0x0B, 0xC4, 0x03, 0xFF, 0xF9,
  0x03, 0xC5, 0x81, 0x3B, 0xEF, 0xFA, 0x81, 0xEB, 0x31, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77,
  0x7C, 0x77, 0x77, 0x0D, 0xFF, 0xFA, 0x71, 0x0A, 0xFF, 0xFA, 0x71, 0x01, 0x0E, 0xFF, 0xF9, 0x72,
  0x81, 0x1A, 0xDF, 0xFE, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_speaker_group() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 45), Box(0, 0, 47, 47),
      ic_filled_48_hardware_speaker_group_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_speaker 48x48, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_filled_48_hardware_speaker_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xFC, 0x84, 0xD5, 0x11, 0x5D, 0xFF, 0xF0, 0xD0, 0x14, 0x01, 0x0D, 0xFF,
  0xE0, 0x56, 0x05, 0xFF, 0xE0, 0x16, 0x01, 0xFF, 0xE0, 0x16, 0x01, 0xFF, 0xE0, 0x56, 0x05, 0xFF,
  0xE0, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xF8, 0x4D, 0x51, 0x15, 0xD8, 0x0A, 0x81, 0xF8, 0x1A, 0x52,
  0x28, 0x12, 0x5A, 0xFF, 0xC0, 0xA0, 0x27, 0x10, 0x20, 0xAF, 0xF9, 0x07, 0x75, 0x07, 0xFE, 0x07,
  0x77, 0x07, 0xFC, 0x0A, 0x58, 0x46, 0xCE, 0xEC, 0x65, 0x0A, 0xFB, 0x02, 0x30, 0x10, 0xCE, 0x0C,
  0x01, 0x30, 0x2F, 0xA0, 0xA4, 0x0C, 0xF9, 0x0C, 0x40, 0xAF, 0x90, 0x53, 0x06, 0xFB, 0x06, 0x30,
  0x5F, 0x90, 0x23, 0x0C, 0xFB, 0x0C, 0x30, 0x2F, 0x94, 0x0E, 0xFB, 0x0E, 0x4F, 0x94, 0x0E, 0xFB,
  0x0E, 0x4F, 0x90, 0x23, 0x0C, 0xFB, 0x0C, 0x30, 0x2F, 0x90, 0x53, 0x06, 0xFB, 0x06, 0x30, 0x5F,
  0x90, 0xA4, 0x0C, 0xF9, 0x0C, 0x40, 0xAF, 0xA0, 0x23, 0x01, 0x0C, 0xE0, 0xC0, 0x13, 0x02, 0xFB,
  0x0A, 0x58, 0x46, 0xCE, 0xEC, 0x65, 0x0A, 0xFC, 0x07, 0x77, 0x07, 0xFE, 0x07, 0x75, 0x07, 0xFF,
  0x90, 0xA0, 0x27, 0x10, 0x20, 0xAF, 0xFC, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAF, 0xB0, 0xDF, 0xFF,
  0xD0, 0xD0, 0xAF, 0xFF, 0xD8, 0x1A, 0x1E, 0xFF, 0xFB, 0x84, 0xE1, 0x01, 0x9D, 0xFF, 0xE8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_speaker() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 43), Box(0, 0, 47, 47),
      ic_filled_48_hardware_speaker_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_start 48x48, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_filled_48_hardware_start_data[] PROGMEM = {
  0xC7, 0x77, 0x20, 0x07, 0x74, 0xC7, 0x77, 0x10, 0x7A, 0x07, 0x73, 0xC7, 0x77, 0x07, 0xC0, 0x77,
  0x2C, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x71, 0xC7, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x7C, 0x77, 0x72,
  0x03, 0x0E, 0xC0, 0x76, 0xC7, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x5C, 0x77, 0x74, 0x03, 0x0E, 0xC0,
  0x74, 0xC7, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x3C, 0x77, 0x76, 0x03, 0x0E, 0xC0, 0x72, 0xC4, 0xFF,
  0xFF, 0xA0, 0x71, 0xC4, 0xFF, 0xFF, 0xB0, 0x7C, 0x4F, 0xFF, 0xFB, 0x07, 0xC4, 0xFF, 0xFF, 0xA0,
  0x71, 0xC7, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x2C, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x73, 0xC7, 0x77,
  0x40, 0x30, 0xEC, 0x07, 0x4C, 0x77, 0x73, 0x03, 0x0E, 0xC0, 0x75, 0xC7, 0x77, 0x20, 0x30, 0xEC,
  0x07, 0x6C, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0xC7, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x1C, 0x77,
  0x70, 0x7C, 0x07, 0x72, 0xC7, 0x77, 0x10, 0x7A, 0x07, 0x73, 0xC7, 0x77, 0x20, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_start() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 43, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_start_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_tablet_android 48x48, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_filled_48_hardware_tablet_android_data[] PROGMEM = {
  0x38, 0x16, 0xCE, 0xFF, 0xFB, 0x81, 0xEC, 0x64, 0x01, 0x0C, 0xFF, 0xFF, 0xA0, 0xC0, 0x12, 0x0C,
  0xFF, 0xFF, 0xC8, 0x1C, 0x06, 0xFF, 0xFF, 0xE0, 0x60, 0xCF, 0xFF, 0xFE, 0x0C, 0x0E, 0xFF, 0xFF,
  0xE0, 0xEB, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0,
  0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77,
  0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07,
  0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70,
  0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77,
  0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07,
  0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77,
  0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E,
  0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0x77, 0x77,
  0x70, 0x78, 0x0A, 0x97, 0xF0, 0xEF, 0xE7, 0x1F, 0xE0, 0xE0, 0xCF, 0xE7, 0x1F, 0xE0, 0xC0, 0x6F,
  0xFF, 0xFE, 0x81, 0x60, 0xCF, 0xFF, 0xFC, 0x0C, 0x20, 0x10, 0xCF, 0xFF, 0xFA, 0x0C, 0x01, 0x48,
  0x16, 0xCE, 0xFF, 0xFB, 0x81, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_tablet_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 41, 47), Box(0, 0, 47, 47),
      ic_filled_48_hardware_tablet_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_tablet_mac 48x48, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_filled_48_hardware_tablet_mac_data[] PROGMEM = {
  0x28, 0x14, 0xBE, 0xFF, 0xFF, 0x81, 0xEB, 0x43, 0x08, 0xFF, 0xFF, 0xE8, 0x18, 0x04, 0x80, 0xC0,
  0xF0, 0x40, 0xB8, 0x0C, 0x0F, 0x0B, 0x0E, 0x80, 0xC0, 0xF0, 0xE8, 0x0C, 0x6F, 0x77, 0x77, 0x2F,
  0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77,
  0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9,
  0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77,
  0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97,
  0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72,
  0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77,
  0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0x80, 0x9B, 0x5F, 0x82,
  0x71, 0x17, 0xFF, 0xFF, 0xD0, 0x74, 0x07, 0xFF, 0xFF, 0xC0, 0x14, 0x01, 0xFF, 0xA0, 0xEF, 0xF9,
  0x01, 0x40, 0x1F, 0xF9, 0x0E, 0x0B, 0xFF, 0x90, 0x74, 0x07, 0xFF, 0x90, 0xB0, 0x4F, 0xFA, 0x82,
  0x71, 0x17, 0xFF, 0xA8, 0x14, 0x08, 0xFF, 0xFF, 0xE0, 0x83, 0x81, 0x4B, 0xEF, 0xFF, 0xF8, 0x1E,
  0xB4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_tablet_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 41, 47), Box(0, 0, 47, 47),
      ic_filled_48_hardware_tablet_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_tablet 48x48, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_filled_48_hardware_tablet_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDF, 0x97, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77,
  0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA,
  0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77,
  0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7,
  0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F,
  0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xF9, 0x0D, 0x80, 0xC6, 0xF0, 0xD0,
  0xA8, 0x0C, 0x6F, 0x81, 0x91, 0xE8, 0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC0, 0xF8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_tablet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_tablet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_toys 48x48, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_filled_48_hardware_toys_data[] PROGMEM = {
  0x77, 0x81, 0x6C, 0xEF, 0xB8, 0x1E, 0xC6, 0x77, 0x73, 0x02, 0x0D, 0xFF, 0xA0, 0xD0, 0x27, 0x78,
  0x24, 0xDD, 0x44, 0x0D, 0xFF, 0xC0, 0xD7, 0x60, 0x5B, 0x0D, 0x30, 0x7F, 0xFE, 0x07, 0x74, 0x05,
  0xC0, 0xD3, 0x0E, 0xB0, 0x90, 0x13, 0xC3, 0x01, 0x09, 0xB0, 0xE7, 0x30, 0x5D, 0x04, 0x20, 0x4B,
  0x0E, 0x5C, 0x50, 0xEB, 0x04, 0x71, 0x04, 0xE0, 0x52, 0x09, 0xB0, 0x95, 0xC5, 0x09, 0xB0, 0x97,
  0x10, 0xDF, 0x81, 0x50, 0xEB, 0x04, 0x5C, 0x50, 0x4B, 0x0E, 0x71, 0x0D, 0xF9, 0x09, 0xB0, 0xE6,
  0xC6, 0x0E, 0xB0, 0x47, 0x83, 0x4D, 0xD4, 0x5F, 0x90, 0x96, 0xC6, 0x09, 0xB0, 0x97, 0x50, 0x5F,
  0x04, 0x6C, 0x60, 0x4B, 0x0E, 0x76, 0x05, 0xD0, 0xE7, 0xC7, 0x0E, 0xB0, 0x47, 0x50, 0x20, 0xCF,
  0xFF, 0xE8, 0x1D, 0x82, 0x72, 0x08, 0xFF, 0xFF, 0xC0, 0x87, 0x0B, 0xFF, 0xFF, 0xE0, 0xB5, 0x08,
  0x80, 0xC0, 0xF0, 0x83, 0x02, 0x80, 0xC2, 0xF0, 0x22, 0x08, 0x80, 0xC2, 0xF0, 0x82, 0x0C, 0x80,
  0xC2, 0xF0, 0xC2, 0x0E, 0x80, 0xC2, 0xF0, 0xE2, 0x0E, 0x80, 0xC2, 0xF0, 0xE2, 0x0C, 0x80, 0xC2,
  0xF0, 0xC2, 0x08, 0x80, 0xC2, 0xF0, 0x82, 0x02, 0x80, 0xC2, 0xF0, 0x23, 0x08, 0xE8, 0x2B, 0x11,
  0xBF, 0xFA, 0x82, 0xB1, 0x1B, 0xE0, 0x85, 0x0A, 0xD0, 0x12, 0x01, 0xFF, 0xA0, 0x12, 0x01, 0xD0,
  0xB7, 0x07, 0xC0, 0x12, 0x01, 0xFF, 0xA0, 0x12, 0x01, 0xC0, 0x87, 0x20, 0xBB, 0x82, 0xB1, 0x1B,
  0xFF, 0xA8, 0x2B, 0x11, 0xBB, 0x0C, 0x73, 0x05, 0xFB, 0x05, 0x71, 0x05, 0xFB, 0x06, 0x74, 0x0C,
  0xF9, 0x0C, 0x73, 0x0B, 0xF9, 0x0C, 0x75, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x30, 0x10, 0xCE, 0x0C,
  0x01, 0x77, 0x84, 0x6C, 0xEE, 0xB5, 0x77, 0x84, 0x5B, 0xEE, 0xC6, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_toys() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_hardware_toys_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_trolley 48x48, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_filled_48_hardware_trolley_data[] PROGMEM = {
  0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x72, 0xF9, 0x77, 0x77, 0x2F, 0x97, 0x77, 0x76, 0xC7, 0x77,
  0x76, 0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76,
  0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6,
  0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6,
  0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6, 0xC2, 0xFD, 0x2F, 0xD6,
  0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76, 0xFF, 0xFF, 0xE4, 0xFF, 0xFF, 0xE4, 0xFF, 0xFF, 0xE4, 0xFF,
  0xFF, 0xE8, 0x09, 0x95, 0x08, 0x41, 0xAE, 0xD9, 0x17, 0x76, 0x84, 0x1A, 0xED, 0x91, 0x50, 0x10,
  0xEC, 0x0E, 0x01, 0x77, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x40, 0xAE, 0x0A, 0x77, 0x40, 0xAE, 0x0A,
  0x40, 0xDE, 0x0D, 0x77, 0x40, 0xDE, 0x0D, 0x40, 0xDE, 0x0D, 0x77, 0x40, 0xDE, 0x0D, 0x40, 0xAE,
  0x0A, 0x77, 0x40, 0xAE, 0x09, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x40, 0x10, 0xEC, 0x0E, 0x01,
  0x58, 0x41, 0xAE, 0xD9, 0x17, 0x76, 0x84, 0x1A, 0xED, 0x91, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_trolley() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_trolley_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_tv 48x48, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_filled_48_hardware_tv_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98,
  0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00,
  0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80,
  0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F,
  0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A,
  0x80, 0xC6, 0xF8, 0x19, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA,
  0x17, 0x71, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_hardware_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_videogame_asset_off 48x48, 4-bit Alpha,  RLE, 278 bytes.
static const unsigned char ic_filled_48_hardware_videogame_asset_off_data[] PROGMEM = {
  0x20, 0x28, 0x0C, 0x30, 0x81, 0x4F, 0x78, 0x0C, 0x10, 0x04, 0xB0, 0x78, 0x0C, 0x00, 0x0E, 0xC0,
  0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03,
  0x0E, 0xC0, 0x77, 0x77, 0x76, 0x02, 0x0C, 0xD0, 0x75, 0x0C, 0xFF, 0xF8, 0x1D, 0xA1, 0x20, 0x20,
  0xEF, 0x07, 0x50, 0xCF, 0xFF, 0x98, 0x2E, 0x10, 0xAF, 0xA0, 0x75, 0x0C, 0xFF, 0xF9, 0x81, 0xA0,
  0xEF, 0xB0, 0x75, 0x0C, 0xFF, 0xF0, 0xD1, 0xFD, 0x07, 0x50, 0xCF, 0xFF, 0x1F, 0xE0, 0x75, 0x0C,
  0xFF, 0xE1, 0xFF, 0x07, 0x50, 0xCF, 0x98, 0x27, 0x11, 0x7F, 0x1F, 0xB0, 0xEC, 0x07, 0x50, 0xCE,
  0x07, 0x40, 0x7E, 0x1F, 0xB0, 0x30, 0xEC, 0x07, 0x50, 0xCD, 0x01, 0x40, 0x1E, 0x1F, 0xB1, 0x03,
  0x0E, 0xC0, 0x75, 0x0C, 0xC0, 0x14, 0x01, 0xE1, 0xE6, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB0, 0x74,
  0x07, 0xE1, 0xE7, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB8, 0x27, 0x11, 0x7F, 0x1E, 0x71, 0x03, 0x0E,
  0xC0, 0x75, 0x0C, 0xFE, 0x1E, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFD, 0x1F, 0xB4, 0xF9, 0x07,
  0x50, 0xCF, 0xC1, 0xFB, 0x4F, 0xA0, 0x75, 0x0C, 0xFB, 0x1F, 0xB4, 0xFB, 0x07, 0x50, 0xCF, 0xA1,
  0xFB, 0x4F, 0xC0, 0x75, 0x0C, 0xF9, 0x1F, 0xFF, 0xD0, 0x75, 0x0C, 0xF1, 0xFF, 0xFE, 0x07, 0x50,
  0xCE, 0x10, 0xDF, 0xFF, 0xE0, 0x75, 0x0C, 0xC8, 0x1E, 0x0A, 0xFF, 0xFF, 0x07, 0x50, 0xCB, 0x82,
  0xA0, 0x1E, 0xFF, 0xFF, 0x07, 0x58, 0x2C, 0xFE, 0x22, 0x81, 0x1A, 0xDF, 0xFF, 0xE0, 0x75, 0x08,
  0x02, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03,
  0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77,
  0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x27, 0x77, 0x77, 0x03, 0x0E, 0xA0,
  0x48, 0x0C, 0x10, 0x81, 0x3E, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_videogame_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 43, 44), Box(0, 0, 47, 47),
      ic_filled_48_hardware_videogame_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_videogame_asset 48x48, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_filled_48_hardware_videogame_asset_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDF, 0xB4, 0x80, 0xC4, 0xF4, 0x80, 0xC4, 0xF4, 0xFF, 0xF8,
  0x27, 0x11, 0x7F, 0xF9, 0x4F, 0xFE, 0x07, 0x40, 0x7F, 0xF4, 0xFF, 0xE0, 0x14, 0x01, 0xFF, 0x4F,
  0xFE, 0x01, 0x40, 0x1F, 0x97, 0x72, 0xFF, 0x07, 0x40, 0x7F, 0x97, 0x72, 0xFF, 0x98, 0x27, 0x11,
  0x7F, 0xA7, 0x72, 0xF8, 0x27, 0x11, 0x7F, 0xFB, 0x77, 0x2E, 0x07, 0x40, 0x7F, 0xFF, 0x94, 0xFD,
  0x01, 0x40, 0x1F, 0xFF, 0x94, 0xFD, 0x01, 0x40, 0x1F, 0xFF, 0x94, 0xFD, 0x07, 0x40, 0x7F, 0xFF,
  0x94, 0xFE, 0x82, 0x71, 0x17, 0xFF, 0xFA, 0x48, 0x0C, 0x4F, 0x4F, 0xFF, 0xFA, 0x0D, 0x80, 0xC6,
  0xF0, 0xD0, 0xA8, 0x0C, 0x6F, 0x81, 0xA1, 0xE8, 0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC0,
  0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_videogame_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 12, 45, 35), Box(0, 0, 47, 47),
      ic_filled_48_hardware_videogame_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_watch_off 48x48, 4-bit Alpha,  RLE, 339 bytes.
static const unsigned char ic_filled_48_hardware_watch_off_data[] PROGMEM = {
  0x77, 0x02, 0xFD, 0x02, 0x77, 0x02, 0x74, 0x06, 0xFD, 0x07, 0x76, 0x81, 0x4F, 0x77, 0x30, 0xBF,
  0xD0, 0xB7, 0x50, 0x4B, 0x07, 0x71, 0x01, 0xFF, 0x01, 0x74, 0x0E, 0xC0, 0x77, 0x05, 0xFF, 0x05,
  0x74, 0x03, 0x0E, 0xC0, 0x76, 0x09, 0xFF, 0x0A, 0x75, 0x03, 0x0E, 0xC0, 0x75, 0x0B, 0xFF, 0x0E,
  0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0x03, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFE, 0x08,
  0x77, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFD, 0x0E, 0x03, 0x77, 0x03, 0x0E, 0xC0, 0x75, 0x81, 0x85,
  0x22, 0x81, 0x25, 0xAD, 0x0E, 0x03, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x50, 0x20, 0xAC, 0x0E, 0x01,
  0x77, 0x03, 0x0E, 0xC0, 0x77, 0x60, 0x7C, 0x0B, 0x77, 0x10, 0x7D, 0x07, 0x76, 0x07, 0xC0, 0x57,
  0x70, 0xCE, 0x07, 0x76, 0x0A, 0xB0, 0xC7, 0x60, 0x3F, 0x90, 0x77, 0x50, 0x2C, 0x02, 0x75, 0x08,
  0xB0, 0xC0, 0xEC, 0x07, 0x75, 0x0A, 0xB0, 0x87, 0x50, 0xBB, 0x81, 0x53, 0xEC, 0x07, 0x74, 0x05,
  0xB0, 0xB7, 0x50, 0xDB, 0x82, 0x20, 0x3E, 0xC0, 0x77, 0x30, 0x2B, 0x0C, 0x75, 0xC3, 0x03, 0x0E,
  0xC0, 0x77, 0x3B, 0x0E, 0x75, 0x0E, 0xB4, 0x03, 0x0E, 0xC0, 0x77, 0x2C, 0x75, 0x0C, 0xB0, 0x24,
  0x03, 0x0E, 0xC0, 0x77, 0x02, 0xB0, 0xD7, 0x50, 0xBB, 0x05, 0x50, 0x30, 0xEC, 0x07, 0x60, 0x5B,
  0x0B, 0x75, 0x08, 0xB0, 0xA6, 0x03, 0x0E, 0xC0, 0x75, 0x08, 0xB0, 0x87, 0x50, 0x2C, 0x02, 0x60,
  0x30, 0xEC, 0x07, 0x50, 0xCA, 0x03, 0x76, 0x0C, 0xB0, 0xA7, 0x03, 0x0E, 0xC0, 0x75, 0x00, 0xC7,
  0x70, 0x5C, 0x07, 0x70, 0x30, 0xEC, 0x07, 0x50, 0x37, 0x71, 0x0B, 0xC0, 0x77, 0x03, 0x0E, 0xC0,
  0x77, 0x76, 0x01, 0x0E, 0xC0, 0xA0, 0x26, 0x03, 0x0E, 0xC0, 0x77, 0x76, 0x03, 0x0E, 0xD8, 0x1A,
  0x52, 0x28, 0x12, 0x5C, 0xD0, 0x77, 0x76, 0x03, 0x0E, 0xFF, 0xC0, 0x77, 0x76, 0x08, 0xFF, 0xD0,
  0x77, 0x75, 0x03, 0xFF, 0xE0, 0x77, 0x75, 0x0E, 0xFF, 0x00, 0xEC, 0x07, 0x77, 0x40, 0xAF, 0xF8,
  0x19, 0x3E, 0xC0, 0x77, 0x73, 0x05, 0xFF, 0x82, 0x50, 0x3E, 0xC0, 0x77, 0x72, 0x01, 0xFF, 0x01,
  0x20, 0x30, 0xEC, 0x07, 0x77, 0x20, 0xBF, 0xD0, 0xB4, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0x07, 0xFD,
  0x06, 0x50, 0x30, 0xEC, 0x02, 0x77, 0x02, 0xFD, 0x02, 0x60, 0x30, 0xEA, 0x04, 0x80, 0xC0, 0x08,
  0x13, 0xE4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_watch_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 42, 44), Box(0, 0, 47, 47),
      ic_filled_48_hardware_watch_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_hardware_watch 48x48, 4-bit Alpha,  RLE, 289 bytes.
static const unsigned char ic_filled_48_hardware_watch_data[] PROGMEM = {
  0x70, 0x1F, 0xFA, 0x01, 0x77, 0x03, 0xFF, 0xA0, 0x37, 0x70, 0x6F, 0xFA, 0x06, 0x77, 0x09, 0xFF,
  0xA0, 0x97, 0x70, 0xBF, 0xFA, 0x0B, 0x77, 0x0E, 0xFF, 0xA0, 0xE7, 0x60, 0x1F, 0xFC, 0x01, 0x75,
  0x03, 0xFF, 0xC0, 0x37, 0x50, 0x6F, 0xFC, 0x06, 0x75, 0x08, 0xFF, 0xC0, 0x97, 0x50, 0xBF, 0xFC,
  0x0B, 0x74, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x17, 0x20, 0x20, 0xDD, 0x82, 0xD9, 0x42, 0x28, 0x22,
  0x49, 0xDD, 0x0D, 0x02, 0x70, 0x10, 0xDC, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xC0, 0xD0, 0x26, 0x0C,
  0xC0, 0xA7, 0x70, 0xAC, 0x0C, 0x50, 0x8C, 0x08, 0x77, 0x20, 0x8C, 0x08, 0x30, 0x2C, 0x0A, 0x77,
  0x40, 0xAC, 0x02, 0x20, 0x9B, 0x0D, 0x77, 0x60, 0xDB, 0x09, 0x20, 0xEB, 0x06, 0x77, 0x60, 0x6B,
  0x81, 0xE0, 0x5B, 0x0D, 0x77, 0x71, 0x0D, 0xB0, 0x50, 0x9B, 0x09, 0x77, 0x71, 0x09, 0xB0, 0x90,
  0xCB, 0x04, 0x77, 0x71, 0x04, 0xB0, 0xC0, 0xEB, 0x02, 0x77, 0x71, 0x02, 0xB0, 0xEC, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0xC0, 0xEB, 0x02, 0x77, 0x71, 0x02, 0xB0, 0xE0, 0xCB, 0x04, 0x77, 0x71, 0x04,
  0xB0, 0xC0, 0x9B, 0x09, 0x77, 0x71, 0x09, 0xB0, 0x90, 0x5B, 0x0D, 0x77, 0x71, 0x0D, 0xB8, 0x15,
  0x0E, 0xB0, 0x67, 0x76, 0x06, 0xB0, 0xE2, 0x09, 0xB0, 0xD7, 0x76, 0x0D, 0xB0, 0x92, 0x02, 0xC0,
  0xA7, 0x74, 0x0A, 0xC0, 0x23, 0x08, 0xC0, 0x87, 0x72, 0x08, 0xC0, 0x85, 0x0C, 0xC0, 0xA7, 0x70,
  0xAC, 0x0C, 0x60, 0x10, 0xDC, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xC0, 0xD0, 0x27, 0x02, 0x0D, 0xD8,
  0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xD0, 0xD0, 0x27, 0x20, 0x10, 0xEF, 0xFC, 0x0E, 0x01, 0x74,
  0x0B, 0xFF, 0xC0, 0xB7, 0x50, 0x8F, 0xFC, 0x09, 0x75, 0x06, 0xFF, 0xC0, 0x67, 0x50, 0x3F, 0xFC,
  0x03, 0x75, 0x01, 0xFF, 0xC0, 0x17, 0x60, 0xEF, 0xFA, 0x0E, 0x77, 0x0B, 0xFF, 0xA0, 0xB7, 0x70,
  0x9F, 0xFA, 0x09, 0x77, 0x06, 0xFF, 0xA0, 0x67, 0x70, 0x3F, 0xFA, 0x03, 0x77, 0x01, 0xFF, 0xA0,
  0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_hardware_watch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 0, 39, 47), Box(0, 0, 47, 47),
      ic_filled_48_hardware_watch_data, Alpha4(color::Black));
  return value;
}
