#include "places.h"

using namespace roo_display;

// Image file ic_filled_18_places_ac_unit 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_filled_18_places_ac_unit_data[] PROGMEM = {
  0x70, 0x05, 0x74, 0x86, 0x63, 0x0B, 0xB0, 0x36, 0x71, 0x86, 0xDE, 0x3B, 0xB3, 0xED, 0x71, 0x86,
  0x1D, 0xED, 0xDE, 0xD1, 0x58, 0x47, 0xD1, 0x01, 0xDA, 0x84, 0xD1, 0x01, 0xD7, 0x28, 0x94, 0x3E,
  0xD1, 0x01, 0xEE, 0x10, 0x1D, 0xE3, 0x38, 0x92, 0x3E, 0xD1, 0x0B, 0xB0, 0x1D, 0xE3, 0x28, 0xB6,
  0x5B, 0xBD, 0xFE, 0xBE, 0xEB, 0xEF, 0xDB, 0xB5, 0x5B, 0xBD, 0xFE, 0xBE, 0xEB, 0xEF, 0xDB, 0xB5,
  0x28, 0x92, 0x3E, 0xD1, 0x0B, 0xB0, 0x1D, 0xE3, 0x38, 0x94, 0x3E, 0xD1, 0x01, 0xEE, 0x10, 0x1D,
  0xE3, 0x28, 0x47, 0xD1, 0x01, 0xDA, 0x84, 0xD1, 0x01, 0xD7, 0x58, 0x61, 0xDE, 0xDD, 0xED, 0x17,
  0x18, 0x6D, 0xE3, 0xBB, 0x3E, 0xD7, 0x18, 0x66, 0x30, 0xBB, 0x03, 0x67, 0x40, 0x05, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_ac_unit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_ac_unit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_airport_shuttle 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_18_places_airport_shuttle_data[] PROGMEM = {
  0x10, 0x18, 0x07, 0x35, 0x01, 0x0E, 0xFC, 0x07, 0x48, 0x95, 0x3F, 0x63, 0x3C, 0xC3, 0x36, 0xF6,
  0xBF, 0x73, 0x81, 0x3F, 0x32, 0x00, 0xB2, 0x85, 0x3F, 0x30, 0xBF, 0x72, 0x81, 0x3F, 0x32, 0x00,
  0xB2, 0x81, 0x3F, 0x32, 0x8A, 0x1B, 0xF7, 0x03, 0xFC, 0xBB, 0xEE, 0xBB, 0xCF, 0xCB, 0xBC, 0xA0,
  0x03, 0xFF, 0xA0, 0x03, 0xB0, 0xEF, 0x90, 0xEB, 0x00, 0x3A, 0x81, 0x80, 0x8E, 0x81, 0x20, 0xDA,
  0x03, 0x28, 0x39, 0x80, 0x89, 0x49, 0x82, 0x20, 0xD4, 0x48, 0x32, 0xEE, 0xE2, 0x48, 0x27, 0xFE,
  0xA7, 0x03, 0x70, 0x10, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_airport_shuttle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_airport_shuttle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_all_inclusive 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_filled_18_places_all_inclusive_data[] PROGMEM = {
  0x18, 0x41, 0xAE, 0xEB, 0x34, 0x89, 0x52, 0xBE, 0xEA, 0x10, 0x1E, 0xE8, 0x8D, 0xF5, 0x28, 0x91,
  0x5F, 0xD8, 0x8E, 0xE1, 0xAE, 0x22, 0x86, 0x1B, 0x40, 0x6F, 0xB1, 0x28, 0x32, 0xEA, 0xD9, 0x68,
  0x18, 0xFA, 0x58, 0x29, 0xDD, 0x95, 0x81, 0xAF, 0x86, 0x83, 0x9D, 0xAE, 0x22, 0x86, 0x1B, 0xF7,
  0x05, 0xB1, 0x28, 0x91, 0x2E, 0xA1, 0xEE, 0x88, 0xDF, 0x52, 0x89, 0x55, 0xFE, 0x88, 0xEE, 0x10,
  0x1A, 0xEE, 0xB2, 0x48, 0x43, 0xBE, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_all_inclusive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 5, 17, 12), Box(0, 0, 17, 17),
      ic_filled_18_places_all_inclusive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_apartment 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_filled_18_places_apartment_data[] PROGMEM = {
  0x40, 0x48, 0x01, 0x50, 0x37, 0x0A, 0xD0, 0x97, 0x85, 0xAF, 0x6E, 0x7F, 0x93, 0x89, 0x13, 0xBB,
  0xBE, 0xFB, 0xFC, 0xF9, 0x30, 0x4D, 0x83, 0x5E, 0x6F, 0x93, 0x82, 0x4F, 0x8A, 0xA8, 0x92, 0xDF,
  0xDF, 0xED, 0xD4, 0x4F, 0xEE, 0xA8, 0x92, 0x3E, 0x4F, 0xEE, 0xF4, 0x4F, 0x9A, 0xE8, 0x6A, 0x9F,
  0x44, 0xFD, 0xDB, 0x0B, 0xA8, 0x6D, 0xDF, 0x44, 0xFA, 0xBB, 0x01, 0xA8, 0x3B, 0xAF, 0x44, 0xE0,
  0x1D, 0x04, 0x01, 0x80, 0x25, 0x18, 0x01, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_apartment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_apartment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_baby_changing_station 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_18_places_baby_changing_station_data[] PROGMEM = {
  0x30, 0x27, 0x28, 0x17, 0xFB, 0x71, 0x81, 0x9F, 0xD7, 0x18, 0x11, 0x72, 0x70, 0x20, 0x77, 0x28,
  0x1B, 0xFB, 0x78, 0x41, 0xFD, 0x7D, 0xA5, 0x84, 0x6F, 0x80, 0x11, 0x58, 0x67, 0xF4, 0x0C, 0xD4,
  0xA3, 0x81, 0x7F, 0x42, 0xA8, 0x5A, 0x3F, 0x37, 0xF4, 0x28, 0x77, 0xB4, 0x19, 0x17, 0xF4, 0x18,
  0x02, 0x58, 0x42, 0x7F, 0x40, 0x68, 0x01, 0x78, 0x23, 0x7F, 0x47, 0x18, 0x11, 0x31, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_baby_changing_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_baby_changing_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_backpack 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_18_places_backpack_data[] PROGMEM = {
  0x30, 0x30, 0x22, 0x02, 0x03, 0x58, 0x65, 0xFC, 0x55, 0xCF, 0x53, 0x09, 0xF9, 0x81, 0x90, 0x3F,
  0xB0, 0x30, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x6E, 0x80, 0x4D, 0x82, 0xE6, 0x69,
  0x80, 0x33, 0x82, 0x27, 0x66, 0xF9, 0x82, 0xA9, 0x66, 0xFB, 0x00, 0x6F, 0xB0, 0x60, 0x5F, 0xB0,
  0x51, 0x80, 0x63, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_backpack() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_backpack_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_balcony 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_filled_18_places_balcony_data[] PROGMEM = {
  0x60, 0x02, 0x73, 0x08, 0x0E, 0xA0, 0xE0, 0x86, 0x89, 0x01, 0xCE, 0x7B, 0xB7, 0xEC, 0x14, 0x89,
  0x09, 0xE2, 0x0A, 0xA0, 0x2E, 0x93, 0x81, 0x1F, 0x52, 0x00, 0xA2, 0x81, 0x5F, 0x12, 0x81, 0x5F,
  0x12, 0x00, 0xA2, 0x81, 0x1F, 0x52, 0x89, 0x26, 0xE0, 0x43, 0xAA, 0x34, 0x0E, 0x62, 0x06, 0x0E,
  0x18, 0x02, 0xA1, 0x0E, 0x06, 0x20, 0x60, 0xE3, 0x00, 0xA3, 0x8A, 0x0E, 0x60, 0x18, 0xE3, 0x33,
  0xBB, 0x33, 0x3E, 0x81, 0x4F, 0xD8, 0xD2, 0x44, 0xF2, 0x8D, 0x1B, 0xB1, 0xD8, 0x2F, 0x44, 0xF0,
  0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x44, 0xF2, 0x8D, 0x1B, 0xB1, 0xD8, 0x2F, 0x44, 0xFD, 0x04, 0x01,
  0x80, 0x90, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_balcony() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_balcony_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_bathtub 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_18_places_bathtub_data[] PROGMEM = {
  0x73, 0x03, 0x74, 0x83, 0x2D, 0xAD, 0x14, 0x06, 0x04, 0x28, 0x46, 0xF3, 0x08, 0x53, 0x06, 0xA0,
  0x12, 0x06, 0x20, 0x70, 0x63, 0x81, 0x4F, 0xE6, 0x07, 0x06, 0x40, 0x17, 0x07, 0x06, 0x38, 0x12,
  0xCA, 0x60, 0x70, 0x62, 0x01, 0x08, 0xA8, 0x90, 0xB2, 0x11, 0x11, 0x87, 0x04, 0xFD, 0x00, 0x4F,
  0xD0, 0x04, 0xFD, 0x04, 0x03, 0xFD, 0x81, 0x30, 0x8F, 0xB0, 0x82, 0x01, 0x80, 0x63, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_bathtub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_bathtub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_beach_access 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_18_places_beach_access_data[] PROGMEM = {
  0x58, 0x45, 0x9B, 0xA8, 0x36, 0x05, 0x0D, 0xE0, 0xB0, 0x23, 0x85, 0x6C, 0x83, 0x37, 0xDB, 0x0D,
  0x20, 0x50, 0xCB, 0x85, 0xB3, 0x06, 0xFE, 0x32, 0x0D, 0x07, 0xD8, 0x28, 0x03, 0x32, 0x81, 0x5F,
  0x3E, 0x0A, 0x48, 0x29, 0xF3, 0xBC, 0x0E, 0x03, 0x48, 0x2B, 0xF7, 0x3B, 0x0E, 0x03, 0x58, 0x90,
  0xAF, 0xD0, 0x8F, 0xE3, 0xA8, 0x40, 0x8A, 0x86, 0x60, 0xA3, 0x08, 0xF8, 0x30, 0x3B, 0x03, 0x48,
  0x18, 0xF8, 0x38, 0x2B, 0xFE, 0x35, 0x81, 0x8F, 0x82, 0x81, 0x2D, 0x37, 0x81, 0x8F, 0x77, 0x50,
  0x70, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_beach_access() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_beach_access_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_bento 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_filled_18_places_bento_data[] PROGMEM = {
  0x10, 0x18, 0x03, 0x38, 0x61, 0x03, 0x33, 0x10, 0x3F, 0x90, 0x71, 0xC0, 0x30, 0x7F, 0x90, 0x71,
  0xC0, 0x07, 0xF9, 0x07, 0x1C, 0x00, 0x7B, 0x00, 0xEB, 0x07, 0x1C, 0x00, 0x7A, 0x82, 0xE1, 0x1E,
  0xA8, 0x67, 0x03, 0x33, 0x31, 0x7A, 0x82, 0xE1, 0x1E, 0xA8, 0x67, 0x03, 0x33, 0x31, 0x7B, 0x00,
  0xEB, 0x07, 0x1C, 0x00, 0x7F, 0x90, 0x71, 0xC0, 0x07, 0xF9, 0x07, 0x1C, 0x07, 0x03, 0xF9, 0x07,
  0x1C, 0x81, 0x30, 0x18, 0x03, 0x38, 0x41, 0x03, 0x33, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_bento() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_bento_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_bungalow 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_filled_18_places_bungalow_data[] PROGMEM = {
  0x50, 0x07, 0x72, 0x02, 0xA0, 0x27, 0x10, 0xBA, 0x0B, 0x70, 0x5C, 0x05, 0x50, 0x10, 0xEC, 0x0E,
  0x01, 0x40, 0x9E, 0x09, 0x30, 0x3B, 0x00, 0x5B, 0x03, 0x20, 0xDB, 0x00, 0xBB, 0x83, 0xD0, 0x2C,
  0xBA, 0x00, 0xCA, 0x81, 0xBC, 0x22, 0x09, 0xA0, 0x05, 0xA0, 0x94, 0x09, 0xA0, 0x05, 0xA0, 0x94,
  0x09, 0xA0, 0x05, 0xA0, 0x94, 0x86, 0x23, 0x31, 0x13, 0x32, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_bungalow() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_bungalow_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_business_center 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_filled_18_places_business_center_data[] PROGMEM = {
  0x68, 0x29, 0xBB, 0x97, 0x48, 0x4B, 0xDB, 0xBD, 0xB7, 0x39, 0x07, 0x20, 0x79, 0x68, 0x96, 0x9B,
  0xBB, 0xFD, 0xBB, 0xDF, 0xBB, 0xB9, 0x06, 0xFF, 0x06, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70, 0x5D,
  0x07, 0x20, 0x7D, 0x86, 0x50, 0x57, 0x77, 0x73, 0x28, 0x43, 0x77, 0x77, 0x52, 0x84, 0x8B, 0xBB,
  0xB5, 0x28, 0x45, 0xBB, 0xBB, 0x82, 0x0B, 0xFD, 0x0B, 0x20, 0xBF, 0xD0, 0xB2, 0x0A, 0xFD, 0x0A,
  0x20, 0x20, 0xA8, 0x06, 0xB0, 0xA0, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_business_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_business_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_cabin 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_filled_18_places_cabin_data[] PROGMEM = {
  0x50, 0x70, 0x57, 0x58, 0x29, 0xEF, 0x47, 0x48, 0x54, 0xF6, 0x20, 0x77, 0x75, 0x01, 0x0A, 0xA0,
  0xA0, 0x17, 0x89, 0x06, 0xE3, 0xDE, 0x55, 0xED, 0x36, 0x06, 0xFA, 0x06, 0x58, 0x1A, 0xF8, 0x80,
  0x23, 0x81, 0x8F, 0xA2, 0x02, 0x0D, 0xA8, 0x04, 0x7A, 0x83, 0xD2, 0x0A, 0x89, 0x80, 0x4D, 0x90,
  0x80, 0xA3, 0x06, 0x0E, 0x71, 0x0E, 0x06, 0x40, 0x69, 0x80, 0x4B, 0x90, 0x64, 0x06, 0x98, 0x04,
  0x99, 0x06, 0x40, 0x60, 0xE7, 0x10, 0xE0, 0x64, 0x06, 0xFB, 0x06, 0x40, 0x18, 0x06, 0x30, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_cabin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_cabin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_carpenter 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_18_places_carpenter_data[] PROGMEM = {
  0x20, 0x30, 0x87, 0x48, 0x23, 0xEF, 0x97, 0x20, 0x30, 0xEB, 0x09, 0x71, 0x05, 0xD0, 0x97, 0x10,
  0xAD, 0x09, 0x70, 0x10, 0xDD, 0x09, 0x70, 0x4E, 0x09, 0x70, 0x8E, 0x09, 0x70, 0xCE, 0x09, 0x60,
  0x3D, 0x81, 0xDF, 0x96, 0x07, 0xB8, 0x3C, 0x08, 0xF2, 0x68, 0x5C, 0xFC, 0x02, 0xDD, 0x78, 0x5E,
  0xC0, 0x2D, 0xE2, 0x78, 0x4C, 0xE5, 0xDE, 0x27, 0x18, 0x31, 0xDF, 0xE2, 0x73, 0x81, 0x15, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_carpenter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_carpenter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_casino 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_filled_18_places_casino_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD8, 0x4A, 0xBF, 0xE8, 0xDC, 0x89, 0x0D, 0x8E, 0xFB,
  0xBF, 0x80, 0x4C, 0x89, 0x04, 0x08, 0xFB, 0xBF, 0xD4, 0xAC, 0x84, 0xA4, 0xDF, 0xBB, 0xD0, 0x0E,
  0xD0, 0x0B, 0xC8, 0x2E, 0x11, 0xEC, 0x00, 0xBC, 0x82, 0xE1, 0x1E, 0xC0, 0x0B, 0xD0, 0x0E, 0xD8,
  0x4B, 0xBF, 0xD4, 0xAC, 0x89, 0x0A, 0x4D, 0xFB, 0xBF, 0x80, 0x4C, 0x89, 0x04, 0x08, 0xFB, 0xBF,
  0xE8, 0xDC, 0x84, 0xD8, 0xEF, 0xBA, 0xFD, 0x81, 0xA2, 0xA8, 0x06, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_casino() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_casino_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_chalet 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_filled_18_places_chalet_data[] PROGMEM = {
  0x74, 0x01, 0x76, 0x81, 0x69, 0x47, 0x48, 0x34, 0x2A, 0x04, 0x72, 0x85, 0x5C, 0x8B, 0xB8, 0x14,
  0x81, 0x3D, 0x22, 0x83, 0x70, 0x82, 0x54, 0x83, 0x3E, 0xFE, 0x22, 0x81, 0x8B, 0x44, 0x03, 0x0E,
  0xB0, 0xE0, 0x22, 0x03, 0x40, 0x30, 0xED, 0x0E, 0x02, 0x50, 0x30, 0xEA, 0x0E, 0x0B, 0xB0, 0xE0,
  0x24, 0x04, 0x0A, 0xA8, 0x5B, 0x0D, 0xFD, 0xB3, 0x6A, 0x83, 0xB0, 0xDF, 0xC7, 0x18, 0x5E, 0xFB,
  0x0D, 0xFC, 0x71, 0x85, 0x55, 0x40, 0x55, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_chalet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_chalet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_charging_station 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_filled_18_places_charging_station_data[] PROGMEM = {
  0x18, 0x04, 0x31, 0x06, 0xF9, 0x06, 0x07, 0xF9, 0x81, 0x77, 0xA8, 0x02, 0x78, 0x2A, 0x77, 0x66,
  0x82, 0x67, 0x76, 0x30, 0x22, 0x82, 0x67, 0x76, 0x20, 0x30, 0x62, 0x82, 0x67, 0x76, 0x28, 0x92,
  0xCB, 0x10, 0x67, 0x76, 0x01, 0xBC, 0x28, 0x26, 0x77, 0x62, 0x06, 0x03, 0x28, 0x26, 0x77, 0x62,
  0x02, 0x38, 0x26, 0x77, 0x66, 0x82, 0x67, 0x7A, 0x80, 0x27, 0x81, 0xA7, 0x7F, 0x90, 0x70, 0x6F,
  0x90, 0x61, 0x80, 0x43, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_charging_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_charging_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_checkroom 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_filled_18_places_checkroom_data[] PROGMEM = {
  0x60, 0x05, 0x74, 0x82, 0x8A, 0xA8, 0x73, 0x82, 0x20, 0x3B, 0x74, 0x81, 0x4E, 0x47, 0x40, 0x07,
  0x74, 0x82, 0x7D, 0xD7, 0x71, 0x81, 0x2C, 0x82, 0x81, 0x8C, 0x25, 0x81, 0x6C, 0x34, 0x81, 0x3C,
  0x62, 0x82, 0x1B, 0xD6, 0x80, 0x25, 0x83, 0x6D, 0xB1, 0x18, 0x09, 0x07, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_checkroom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_filled_18_places_checkroom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_child_care 18x18, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_filled_18_places_child_care_data[] PROGMEM = {
  0x68, 0x43, 0x8B, 0xB8, 0x37, 0x38, 0x90, 0x1B, 0xFE, 0xCC, 0xEF, 0xB1, 0x78, 0x21, 0xDE, 0x64,
  0x82, 0x6E, 0xD1, 0x68, 0x1B, 0xE3, 0x68, 0x13, 0xEB, 0x48, 0x21, 0xAF, 0x67, 0x18, 0x26, 0xFA,
  0x12, 0x81, 0xCE, 0x82, 0x09, 0x0D, 0x20, 0xD0, 0x92, 0x85, 0x8E, 0xC0, 0x2F, 0x63, 0x06, 0x09,
  0x20, 0x90, 0x63, 0x84, 0x6F, 0x22, 0xF6, 0x75, 0x87, 0x6F, 0x20, 0xCE, 0x80, 0x18, 0x02, 0x78,
  0x31, 0x08, 0xEC, 0x28, 0x41, 0xAF, 0x60, 0xAC, 0x84, 0xA0, 0x6F, 0xA1, 0x48, 0x92, 0xBE, 0x30,
  0x5A, 0xA5, 0x03, 0xEB, 0x68, 0x21, 0xDE, 0x64, 0x82, 0x6E, 0xD1, 0x78, 0x90, 0x1B, 0xFE, 0xCC,
  0xEF, 0xB1, 0x73, 0x84, 0x38, 0xAA, 0x83, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_child_care() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_child_care_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_child_friendly 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_18_places_child_friendly_data[] PROGMEM = {
  0x71, 0x81, 0x16, 0x37, 0x50, 0x3A, 0x0C, 0x02, 0x73, 0x03, 0xB0, 0xE0, 0x37, 0x20, 0x3C, 0x0D,
  0x72, 0x03, 0xD8, 0x25, 0x13, 0x35, 0x03, 0xD0, 0x90, 0x7A, 0x07, 0x40, 0x18, 0x01, 0x78, 0x35,
  0x13, 0xBE, 0x80, 0x6B, 0x08, 0x20, 0x3F, 0xC0, 0x93, 0x0B, 0xFB, 0x04, 0x30, 0x7F, 0xA0, 0xB3,
  0x82, 0x3F, 0xDD, 0xD8, 0x1C, 0xED, 0x30, 0x80, 0xE2, 0x0E, 0xB8, 0x3B, 0x03, 0xF4, 0x28, 0x93,
  0x7F, 0x22, 0xF9, 0x3C, 0xD1, 0x6F, 0x32, 0x01, 0x0D, 0xA8, 0x2D, 0x10, 0x4B, 0x0B, 0x48, 0x21,
  0x66, 0x13, 0x81, 0x26, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_child_friendly() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_child_friendly_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_corporate_fare 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_18_places_corporate_fare_data[] PROGMEM = {
  0x05, 0x80, 0x3B, 0x71, 0x85, 0x7F, 0xBB, 0xBB, 0xD9, 0x71, 0x07, 0x94, 0x07, 0x97, 0x18, 0x57,
  0xFB, 0xBB, 0xBD, 0x98, 0x03, 0xB8, 0x65, 0x7F, 0xBB, 0xBB, 0xD9, 0x80, 0x2B, 0x90, 0x07, 0x94,
  0x07, 0x96, 0x98, 0xC0, 0x77, 0xFB, 0xBB, 0xBD, 0xF0, 0x5B, 0xB5, 0x0F, 0x77, 0xFB, 0xBB, 0xBD,
  0xF0, 0x5B, 0xB5, 0x0F, 0x77, 0x94, 0x07, 0x96, 0x98, 0xC0, 0x77, 0xFB, 0xBB, 0xBD, 0xF0, 0x5B,
  0xB5, 0x0F, 0x77, 0xFB, 0xBB, 0xBD, 0xF0, 0x5B, 0xB5, 0x0F, 0x77, 0x94, 0x07, 0x96, 0x98, 0x67,
  0x7F, 0xBB, 0xBB, 0xD9, 0x80, 0x2B, 0x90, 0x70, 0x58, 0x09, 0x2B, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_corporate_fare() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_corporate_fare_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_cottage 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_filled_18_places_cottage_data[] PROGMEM = {
  0x50, 0x70, 0x57, 0x58, 0x29, 0xEF, 0x47, 0x48, 0x54, 0xF6, 0x20, 0x77, 0x75, 0x01, 0x0A, 0xA0,
  0xA0, 0x17, 0x82, 0x6E, 0x3D, 0xC0, 0xD0, 0x36, 0x06, 0xFA, 0x06, 0x50, 0xAF, 0xB0, 0xA2, 0x02,
  0x0D, 0xFD, 0x83, 0xD2, 0x0A, 0x8F, 0xB0, 0x80, 0xA3, 0x06, 0xFB, 0x06, 0x40, 0x6C, 0x00, 0x7C,
  0x06, 0x40, 0x6C, 0x00, 0x5C, 0x06, 0x40, 0x6C, 0x00, 0x5C, 0x06, 0x40, 0x6C, 0x00, 0x5C, 0x06,
  0x48, 0x92, 0x13, 0x33, 0x31, 0x13, 0x33, 0x31, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_cottage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_cottage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_countertops 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_filled_18_places_countertops_data[] PROGMEM = {
  0x2C, 0x84, 0x70, 0x3C, 0xE8, 0x6C, 0x85, 0x70, 0xCD, 0xAF, 0x45, 0xC8, 0x57, 0x03, 0x20, 0xF7,
  0x50, 0xDB, 0x05, 0x49, 0x07, 0x38, 0x13, 0x79, 0xA0, 0xD8, 0x01, 0x79, 0x83, 0xB7, 0x73, 0x7F,
  0xF0, 0x72, 0xD0, 0x03, 0xD4, 0xD0, 0x03, 0xD4, 0xD0, 0x03, 0xD4, 0xD0, 0x03, 0xD4, 0xD0, 0x09,
  0xD4, 0xFD, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_countertops() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_countertops_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_crib 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_filled_18_places_crib_data[] PROGMEM = {
  0x20, 0x30, 0xF5, 0x70, 0x9C, 0x60, 0x3D, 0x60, 0x6D, 0x60, 0x6D, 0x80, 0x0B, 0x81, 0xA0, 0x6F,
  0xB0, 0x50, 0x6F, 0xB0, 0x06, 0xFB, 0x81, 0x62, 0xEF, 0x90, 0xE0, 0x22, 0x86, 0x1B, 0xA1, 0x1A,
  0xB1, 0x38, 0x27, 0x6A, 0xA2, 0x82, 0xAB, 0x67, 0x20, 0x8A, 0x82, 0xB3, 0x3B, 0xA0, 0x93, 0x03,
  0x0B, 0xC0, 0xB0, 0x37, 0x00, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_crib() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_crib_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_desk 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_18_places_desk_data[] PROGMEM = {
  0x01, 0x80, 0x92, 0x70, 0x10, 0x39, 0x80, 0x4D, 0x90, 0xFD, 0x98, 0x23, 0x3F, 0x26, 0x89, 0x03,
  0xF2, 0x02, 0xF3, 0x3F, 0x26, 0x89, 0x03, 0xF7, 0x57, 0xF3, 0x3F, 0x26, 0x03, 0xD8, 0x23, 0x3F,
  0x26, 0x89, 0x03, 0xF2, 0x02, 0xF3, 0x3F, 0x26, 0x89, 0x03, 0xF5, 0x35, 0xF3, 0x3F, 0x26, 0x03,
  0xD8, 0x23, 0x3F, 0x26, 0x89, 0x03, 0xF3, 0x13, 0xF3, 0x17, 0x16, 0x85, 0x17, 0x10, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_desk() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_filled_18_places_desk_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_do_not_step 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_filled_18_places_do_not_step_data[] PROGMEM = {
  0x01, 0x06, 0x50, 0x16, 0x0B, 0x07, 0x38, 0x11, 0xDB, 0x68, 0x3B, 0x70, 0x1D, 0xA0, 0xB6, 0x82,
  0xB7, 0x3E, 0xB0, 0xB6, 0x82, 0xB7, 0x4E, 0xB0, 0xB5, 0x83, 0x2B, 0x74, 0xEA, 0x0C, 0x06, 0x48,
  0x78, 0xBF, 0x74, 0xEC, 0x8B, 0x30, 0x50, 0xBB, 0x82, 0x73, 0x8B, 0x28, 0x13, 0xBC, 0xD0, 0x70,
  0x32, 0x03, 0xE8, 0x2D, 0x2B, 0x72, 0x04, 0xD0, 0xD0, 0x12, 0x82, 0xB7, 0x01, 0x80, 0x15, 0x01,
  0x40, 0xB0, 0x67, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_do_not_step() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_do_not_step_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_do_not_touch 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_18_places_do_not_touch_data[] PROGMEM = {
  0x70, 0x16, 0x02, 0x58, 0x26, 0xD0, 0x24, 0x0A, 0x07, 0x28, 0x52, 0x26, 0xD2, 0xF1, 0x48, 0x92,
  0xB7, 0x0A, 0x96, 0xD3, 0xF2, 0x51, 0x38, 0x91, 0xB7, 0x49, 0x6D, 0x3F, 0x2E, 0x64, 0x89, 0x0B,
  0x71, 0x6D, 0x3F, 0x2E, 0x65, 0x87, 0xC7, 0x3D, 0x3F, 0x2E, 0x65, 0x89, 0x5A, 0xF7, 0x3D, 0xFD,
  0xF6, 0x01, 0xDB, 0x1A, 0xA8, 0x17, 0x4E, 0xA0, 0x62, 0x82, 0x7F, 0xED, 0xB8, 0x37, 0x4E, 0xF6,
  0x30, 0x7E, 0x82, 0x74, 0xE6, 0x40, 0x7E, 0x81, 0x74, 0x55, 0x08, 0xE0, 0x77, 0x08, 0xE0, 0x77,
  0x86, 0x23, 0x33, 0x31, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_do_not_touch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_do_not_touch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_dry 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_18_places_dry_data[] PROGMEM = {
  0x72, 0x82, 0x30, 0x11, 0x74, 0x82, 0xC0, 0x57, 0x71, 0x03, 0x28, 0x3A, 0x51, 0xC2, 0x60, 0x89,
  0x38, 0x2C, 0x33, 0xC5, 0x81, 0x9F, 0xA3, 0x83, 0x57, 0x0A, 0x33, 0x82, 0x9F, 0xE1, 0x38, 0x21,
  0x20, 0x23, 0x09, 0xA0, 0xE8, 0x02, 0xD0, 0xA3, 0x09, 0xE8, 0x00, 0x70, 0x42, 0x02, 0xF8, 0x02,
  0x90, 0x10, 0x3F, 0x80, 0x1B, 0x81, 0xA1, 0x3F, 0x80, 0x15, 0x20, 0x3F, 0x80, 0x1D, 0x81, 0x30,
  0x2F, 0x80, 0x01, 0x40, 0xBF, 0xA0, 0xE5, 0x02, 0x80, 0x43, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_dry() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_dry_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_elevator 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_18_places_elevator_data[] PROGMEM = {
  0x18, 0x06, 0x51, 0x05, 0xFB, 0x05, 0x06, 0xA0, 0x90, 0xDE, 0x00, 0x6A, 0x07, 0x0C, 0xA0, 0xD0,
  0x5A, 0x84, 0x66, 0xFB, 0x35, 0xA8, 0x64, 0x0B, 0xF6, 0x6F, 0x62, 0x8A, 0x2D, 0xFD, 0xDE, 0xF6,
  0x6F, 0x70, 0x1E, 0xFD, 0xDE, 0xF6, 0x6A, 0x01, 0x08, 0xA8, 0x44, 0x0B, 0xF6, 0x6A, 0x01, 0x08,
  0xA0, 0xD0, 0x5A, 0x00, 0x6A, 0x06, 0x0B, 0xE0, 0x60, 0x5F, 0xB0, 0x51, 0x80, 0x65, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_elevator() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_elevator_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_escalator 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_18_places_escalator_data[] PROGMEM = {
  0x18, 0x06, 0x51, 0x05, 0xFB, 0x05, 0x06, 0xE8, 0x47, 0x56, 0xD6, 0x6D, 0x09, 0x38, 0x19, 0x66,
  0xC0, 0xD2, 0x83, 0xAC, 0xF6, 0x6C, 0x81, 0x40, 0x8B, 0x00, 0x6B, 0x81, 0x90, 0x3C, 0x83, 0x66,
  0xFC, 0xB2, 0x0D, 0xC8, 0x16, 0x69, 0x30, 0x8D, 0x84, 0x66, 0xD6, 0x56, 0xE0, 0x60, 0x5F, 0xB0,
  0x51, 0x80, 0x65, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_escalator() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_escalator_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_escalator_warning 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_filled_18_places_escalator_warning_data[] PROGMEM = {
  0x20, 0x30, 0x17, 0x28, 0x25, 0xFE, 0x17, 0x10, 0x5A, 0x01, 0x72, 0x04, 0x03, 0x71, 0x83, 0x1A,
  0xBB, 0x74, 0x82, 0x92, 0x06, 0xC0, 0x42, 0x83, 0x2F, 0x50, 0x6C, 0x0D, 0x60, 0x6B, 0x87, 0xCF,
  0x71, 0xDF, 0xE3, 0x6B, 0x82, 0xA8, 0xEA, 0xB8, 0x16, 0x19, 0xA8, 0x3A, 0x0B, 0xAB, 0xA8, 0x16,
  0x07, 0xA0, 0xA3, 0x81, 0xBF, 0xE2, 0x07, 0xA0, 0xA3, 0x81, 0xBF, 0xE2, 0x07, 0xA0, 0xA3, 0x81,
  0xBF, 0xE2, 0x82, 0x13, 0x32, 0x38, 0x12, 0x33, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_escalator_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_escalator_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_family_restroom 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_filled_18_places_family_restroom_data[] PROGMEM = {
  0x20, 0x02, 0x60, 0x02, 0x30, 0x3A, 0x02, 0x40, 0x2A, 0x03, 0x20, 0x4A, 0x02, 0x40, 0x2A, 0x04,
  0x30, 0x40, 0x36, 0x03, 0x04, 0x38, 0x29, 0xBB, 0x95, 0x07, 0x08, 0x20, 0x4C, 0x83, 0x32, 0xA1,
  0x3A, 0x81, 0x50, 0x4C, 0x83, 0x33, 0xD2, 0x9A, 0x81, 0xA0, 0x4C, 0x83, 0x30, 0x10, 0xBA, 0x82,
  0xE0, 0x3D, 0xA8, 0x4C, 0x2B, 0xF9, 0x5B, 0x81, 0x50, 0x6A, 0x89, 0x24, 0x0D, 0xFC, 0x3E, 0xFB,
  0x70, 0x6A, 0x86, 0x40, 0xBF, 0x90, 0xDE, 0x30, 0x6A, 0x86, 0x40, 0x6F, 0x50, 0xDE, 0x30, 0x6A,
  0x86, 0x40, 0x6F, 0x50, 0xDE, 0x38, 0x91, 0x13, 0x31, 0x01, 0x31, 0x03, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_family_restroom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_family_restroom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_fence 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_filled_18_places_fence_data[] PROGMEM = {
  0x38, 0x67, 0x70, 0x77, 0x07, 0x75, 0x07, 0xA0, 0xBA, 0x0B, 0xA0, 0x73, 0x89, 0x23, 0xF9, 0x9F,
  0x99, 0xF9, 0x9F, 0x32, 0x8B, 0x23, 0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x30, 0x59, 0xF9, 0x9F, 0x99,
  0xF9, 0x9F, 0x95, 0xBF, 0xD8, 0xB4, 0xB0, 0x3F, 0x33, 0xF3, 0x3F, 0x33, 0xF3, 0x05, 0x9F, 0x99,
  0xF9, 0x9F, 0x99, 0xF9, 0x5B, 0xFD, 0x89, 0x4B, 0x03, 0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x32, 0x89,
  0x23, 0xF9, 0x9F, 0x99, 0xF9, 0x9F, 0x32, 0x03, 0xFB, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_fence() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_fence_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_fire_extinguisher 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_18_places_fire_extinguisher_data[] PROGMEM = {
  0x48, 0x42, 0xAA, 0x57, 0x72, 0x03, 0x06, 0x0F, 0xEA, 0x0B, 0x02, 0xC0, 0x05, 0xA0, 0xB2, 0x03,
  0x06, 0x0F, 0xEA, 0x0B, 0x30, 0x10, 0xBA, 0x81, 0xE9, 0x72, 0x01, 0x0D, 0xC0, 0xD0, 0x12, 0x07,
  0xE0, 0x72, 0x02, 0x80, 0x23, 0x02, 0x20, 0xBE, 0x0B, 0x20, 0xBE, 0x0B, 0x20, 0xBE, 0x0B, 0x20,
  0x58, 0x02, 0x70, 0x52, 0x08, 0x80, 0x2B, 0x08, 0x20, 0x9E, 0x09, 0x38, 0x46, 0x77, 0x77, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_fire_extinguisher() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 12, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_fire_extinguisher_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_fitness_center 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_18_places_fitness_center_data[] PROGMEM = {
  0x48, 0x23, 0x02, 0x17, 0x28, 0x55, 0x84, 0xEB, 0xEB, 0x72, 0x08, 0xC0, 0xE0, 0x27, 0x20, 0x4B,
  0x0E, 0x02, 0x72, 0x03, 0x0E, 0xB0, 0x97, 0x48, 0x4B, 0xFE, 0x9F, 0x87, 0x28, 0x62, 0xEE, 0x20,
  0x8F, 0x87, 0x18, 0x11, 0xB2, 0x38, 0x18, 0xF8, 0x77, 0x81, 0x8F, 0x83, 0x81, 0x2B, 0x17, 0x18,
  0x68, 0xF8, 0x02, 0xEE, 0x27, 0x28, 0x48, 0xF9, 0xEF, 0xB7, 0x40, 0x9B, 0x0E, 0x03, 0x72, 0x02,
  0x0E, 0xB0, 0x47, 0x20, 0x20, 0xEC, 0x08, 0x72, 0x85, 0xBE, 0xBE, 0x48, 0x57, 0x28, 0x21, 0x20,
  0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_fitness_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_fitness_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_food_bank 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_filled_18_places_food_bank_data[] PROGMEM = {
  0x50, 0x05, 0x72, 0x09, 0xA0, 0x96, 0x02, 0x0C, 0xC0, 0xC0, 0x23, 0x05, 0x0E, 0xE8, 0x2E, 0x50,
  0x9F, 0xB0, 0x9B, 0x0F, 0x78, 0x1A, 0x6C, 0xE0, 0xF5, 0x81, 0x60, 0xBE, 0x84, 0x62, 0x26, 0x0B,
  0xE8, 0x4E, 0x47, 0xB1, 0xBF, 0x83, 0x7B, 0xF7, 0xBF, 0x83, 0x7B, 0xF7, 0xBF, 0x83, 0xBD, 0xFB,
  0xDF, 0xF9, 0x80, 0x90, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_food_bank() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_food_bank_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_foundation 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_filled_18_places_foundation_data[] PROGMEM = {
  0x70, 0x04, 0x76, 0x06, 0xA0, 0x67, 0x40, 0x7C, 0x07, 0x72, 0x86, 0x9F, 0x9B, 0xB9, 0xF9, 0x78,
  0x90, 0xAF, 0x80, 0xBB, 0x08, 0xFA, 0x48, 0x21, 0xBF, 0x72, 0x00, 0xB2, 0x85, 0x7F, 0xB1, 0x01,
  0xCA, 0x03, 0x20, 0x0B, 0x20, 0x3A, 0x0C, 0x01, 0x28, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3,
  0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3, 0x38, 0x94, 0x8C, 0xFC, 0xBB, 0xEE, 0xBB, 0xCF,
  0xC8, 0x28, 0x94, 0x8C, 0xFC, 0xBB, 0xEE, 0xBB, 0xCF, 0xC8, 0x38, 0x13, 0xF3, 0x20, 0x0B, 0x28,
  0x13, 0xF3, 0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_foundation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_foundation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_free_breakfast 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_filled_18_places_free_breakfast_data[] PROGMEM = {
  0x80, 0x90, 0xB0, 0x91, 0xFB, 0x82, 0xDB, 0xF6, 0xFB, 0x82, 0x70, 0xF7, 0xFB, 0x82, 0x70, 0xF7,
  0xFE, 0x05, 0xFB, 0x81, 0xB7, 0x51, 0xFB, 0x07, 0x3F, 0xB0, 0x73, 0x0D, 0xFA, 0x05, 0x30, 0x5F,
  0x90, 0xC5, 0x04, 0x0A, 0x80, 0x1B, 0x08, 0x77, 0x58, 0x09, 0x0B, 0x28, 0x09, 0x0B, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_free_breakfast() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 16, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_free_breakfast_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_gite 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_filled_18_places_gite_data[] PROGMEM = {
  0x40, 0x30, 0x47, 0x70, 0x90, 0xB7, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x23, 0x02, 0x0D, 0xFA, 0x84,
  0xDD, 0x20, 0x1D, 0xFA, 0x84, 0x61, 0xCD, 0x13, 0xFA, 0x0B, 0x28, 0x42, 0xF3, 0x3F, 0x26, 0x00,
  0xA2, 0x84, 0x2F, 0x33, 0xF2, 0x60, 0x0A, 0x28, 0x42, 0xF3, 0x3F, 0x26, 0x00, 0xA2, 0x82, 0x2F,
  0x33, 0x98, 0x03, 0xD8, 0x6E, 0xED, 0xDD, 0xF3, 0x18, 0x09, 0x27, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_gite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 13), Box(0, 0, 17, 17),
      ic_filled_18_places_gite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_golf_course 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_filled_18_places_golf_course_data[] PROGMEM = {
  0x30, 0x10, 0x27, 0x48, 0x23, 0xF9, 0x27, 0x20, 0x3B, 0x0A, 0x02, 0x70, 0x3D, 0x04, 0x60, 0x3B,
  0x09, 0x01, 0x78, 0x23, 0xFA, 0x17, 0x28, 0x13, 0xF3, 0x73, 0x81, 0x3F, 0x37, 0x38, 0x13, 0xF3,
  0x73, 0x81, 0x3F, 0x37, 0x38, 0x13, 0xF3, 0x73, 0x81, 0x3F, 0x37, 0x18, 0x51, 0x13, 0xF8, 0x51,
  0x38, 0x46, 0x29, 0xF3, 0x3C, 0x84, 0x90, 0x6F, 0xA9, 0xF8, 0x93, 0x90, 0x2A, 0x40, 0x14, 0x67,
  0x64, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_golf_course() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_golf_course_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_grass 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_filled_18_places_grass_data[] PROGMEM = {
  0x40, 0x60, 0x27, 0x78, 0x11, 0xE3, 0x50, 0x40, 0x27, 0x0A, 0x0D, 0x38, 0x15, 0xD8, 0x71, 0x85,
  0x6F, 0x60, 0x6F, 0xA7, 0x28, 0x24, 0xF2, 0x2A, 0x01, 0x72, 0x84, 0x2B, 0x09, 0xE5, 0x58, 0x31,
  0x8E, 0xC6, 0x38, 0x6B, 0x10, 0x6C, 0xE8, 0x12, 0x89, 0x23, 0xDF, 0xC1, 0x01, 0x1C, 0xFD, 0x35,
  0x03, 0xA0, 0xC2, 0x0C, 0xA0, 0x37, 0x09, 0xA8, 0x36, 0x0E, 0xF9, 0x48, 0x33, 0x77, 0x79, 0xA8,
  0x90, 0xC0, 0xAF, 0x97, 0x77, 0x37, 0xE8, 0x1E, 0x08, 0xD0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_grass() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_grass_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_holiday_village 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_18_places_holiday_village_data[] PROGMEM = {
  0x48, 0x62, 0x03, 0x51, 0x04, 0x55, 0x89, 0x09, 0xE3, 0x1C, 0xD2, 0x2E, 0xC3, 0x09, 0xA8, 0x91,
  0xE3, 0x1C, 0xD2, 0x2E, 0xA0, 0x9C, 0x87, 0xE3, 0x1C, 0xD0, 0x9B, 0x8E, 0x86, 0xE2, 0x4F, 0x09,
  0xBB, 0xA0, 0xB0, 0x6B, 0x85, 0x54, 0xF0, 0x9B, 0xBA, 0x0B, 0x06, 0xB8, 0x55, 0x4F, 0x09, 0xBB,
  0xF8, 0x55, 0x4F, 0x09, 0xBB, 0xA0, 0x91, 0xB8, 0x55, 0x4F, 0x09, 0xBB, 0xA0, 0x91, 0xB8, 0x55,
  0x4F, 0x09, 0xBB, 0xA0, 0x91, 0xB8, 0xA2, 0x54, 0xF0, 0x9B, 0x45, 0x53, 0x05, 0x55, 0x21, 0x50,
  0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_holiday_village() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_holiday_village_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_hot_tub 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_filled_18_places_hot_tub_data[] PROGMEM = {
  0x71, 0x83, 0xB5, 0x0B, 0x56, 0x81, 0xBE, 0x42, 0x83, 0xE8, 0x0E, 0x85, 0x03, 0xA0, 0xA2, 0x84,
  0x9E, 0x29, 0xE2, 0x58, 0x1B, 0xE4, 0x38, 0x3D, 0xB0, 0xDB, 0x60, 0x34, 0x83, 0x7E, 0x07, 0xE5,
  0x81, 0xDF, 0xC3, 0x83, 0x37, 0x03, 0x74, 0x03, 0xB0, 0xB7, 0x20, 0x7F, 0xF8, 0x9A, 0x07, 0x7F,
  0xD7, 0xDD, 0x7D, 0xD7, 0xDD, 0x7D, 0xF7, 0x7F, 0xB0, 0xBB, 0x0B, 0xB0, 0xBB, 0x0B, 0xF7, 0x7F,
  0xB0, 0xBB, 0x0B, 0xB0, 0xBB, 0x0B, 0xF7, 0x7F, 0xB0, 0xBB, 0x0B, 0xB0, 0xBB, 0x0B, 0xF7, 0x7F,
  0xB0, 0xBB, 0x0B, 0xB0, 0xBB, 0x0B, 0xF7, 0x5F, 0xF8, 0x15, 0x05, 0x80, 0x90, 0x70, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_hot_tub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_hot_tub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_houseboat 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_filled_18_places_houseboat_data[] PROGMEM = {
  0x70, 0x0A, 0x75, 0x03, 0x0D, 0xA0, 0xD0, 0x37, 0x20, 0x7E, 0x07, 0x60, 0x10, 0xBF, 0x90, 0xB0,
  0x14, 0x81, 0x1C, 0xBE, 0x81, 0xBC, 0x13, 0x01, 0x20, 0x9A, 0x00, 0x6A, 0x09, 0x20, 0x12, 0x82,
  0xBB, 0x2A, 0xA0, 0x06, 0xA8, 0x2A, 0x2B, 0xB2, 0x03, 0x0D, 0xFB, 0x0D, 0x03, 0x48, 0x06, 0x34,
  0x8A, 0x13, 0xAC, 0x70, 0x5B, 0xB5, 0x06, 0xCB, 0x30, 0x3F, 0xB9, 0xB0, 0x0A, 0xB8, 0x49, 0xBF,
  0x31, 0x42, 0x81, 0x15, 0x32, 0x81, 0x25, 0x12, 0x04, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_houseboat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_houseboat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_house 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_filled_18_places_house_data[] PROGMEM = {
  0x50, 0x01, 0x72, 0x85, 0x2D, 0xD2, 0x27, 0x34, 0x04, 0x0E, 0xA8, 0x2E, 0x8F, 0x73, 0x06, 0xF0,
  0x72, 0x08, 0xB0, 0x08, 0xB8, 0x1A, 0x0A, 0xC0, 0x0D, 0xC8, 0x1A, 0x07, 0xF9, 0x07, 0x20, 0x7B,
  0x00, 0xBB, 0x07, 0x20, 0x7B, 0x00, 0x1B, 0x07, 0x20, 0x7B, 0x00, 0x1B, 0x07, 0x20, 0x7B, 0x00,
  0x1B, 0x07, 0x20, 0x20, 0xF5, 0x20, 0xF5, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_house() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_house_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_house_siding 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_filled_18_places_house_siding_data[] PROGMEM = {
  0x70, 0x04, 0x76, 0x06, 0xA0, 0x67, 0x48, 0x47, 0xFA, 0xAF, 0x77, 0x28, 0x19, 0xF9, 0x28, 0x19,
  0xF9, 0x70, 0xAF, 0x90, 0xA4, 0x82, 0x1B, 0xF9, 0x80, 0x27, 0x85, 0x9F, 0xB1, 0x01, 0xCA, 0x03,
  0x60, 0x3A, 0x0C, 0x01, 0x20, 0x3F, 0xB0, 0x34, 0x81, 0x3F, 0x98, 0x02, 0x78, 0x19, 0xF3, 0x48,
  0x13, 0xF3, 0x68, 0x13, 0xF3, 0x40, 0x3F, 0xB0, 0x34, 0x81, 0x3F, 0x98, 0x02, 0x78, 0x19, 0xF3,
  0x48, 0x13, 0xF3, 0x68, 0x13, 0xF3, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_house_siding() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_house_siding_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_iron 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_filled_18_places_iron_data[] PROGMEM = {
  0x58, 0x91, 0x69, 0x99, 0x96, 0x01, 0xCF, 0x34, 0x89, 0x16, 0xFB, 0xBB, 0xBF, 0x66, 0xE4, 0x50,
  0x20, 0x34, 0x82, 0xB9, 0x7D, 0x30, 0x10, 0xA8, 0x03, 0xD9, 0x81, 0x97, 0xD3, 0x0C, 0xFA, 0x81,
  0x97, 0xD2, 0x02, 0xFB, 0x81, 0xDD, 0xA2, 0x03, 0xFB, 0x81, 0xD9, 0x12, 0x03, 0xFB, 0x09, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_iron() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 12), Box(0, 0, 17, 17),
      ic_filled_18_places_iron_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_kitchen 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_filled_18_places_kitchen_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x38, 0x11, 0x02, 0xFB, 0x02, 0x06, 0xFB, 0x00, 0x6A, 0x04, 0x05, 0xE0, 0x06,
  0xA0, 0x06, 0xE0, 0x60, 0x48, 0x06, 0xB0, 0x47, 0x50, 0x58, 0x06, 0xD0, 0x50, 0x6A, 0x04, 0x05,
  0xE0, 0x06, 0xA0, 0x40, 0x5E, 0x00, 0x6A, 0x04, 0x05, 0xE0, 0x06, 0xA0, 0x80, 0x9E, 0x00, 0x6F,
  0xB0, 0x06, 0xFB, 0x06, 0x02, 0xFB, 0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_kitchen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_kitchen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_meeting_room 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_filled_18_places_meeting_room_data[] PROGMEM = {
  0x10, 0x28, 0x02, 0xB0, 0x56, 0x03, 0xFB, 0x03, 0x20, 0x3E, 0x83, 0xB7, 0x9F, 0x32, 0x03, 0xE8,
  0x37, 0x03, 0xF3, 0x20, 0x3E, 0x83, 0x70, 0x3F, 0x32, 0x03, 0xE8, 0x37, 0x03, 0xF3, 0x20, 0x3B,
  0x86, 0x93, 0xF7, 0x03, 0xF3, 0x20, 0x3B, 0x86, 0x93, 0xF7, 0x03, 0xF3, 0x20, 0x3E, 0x83, 0x70,
  0x3F, 0x32, 0x03, 0xE8, 0x37, 0x03, 0xF3, 0x20, 0x3E, 0x83, 0x70, 0x3F, 0x32, 0x03, 0xE8, 0x67,
  0x03, 0xF3, 0x08, 0xCE, 0x85, 0x70, 0x3F, 0xC8, 0x88, 0x03, 0xB8, 0x45, 0x02, 0xBB, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_meeting_room() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_meeting_room_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_microwave 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_18_places_microwave_data[] PROGMEM = {
  0x02, 0x0D, 0xFD, 0x81, 0xD2, 0x79, 0x80, 0x37, 0x0B, 0xD0, 0x07, 0x97, 0x8B, 0x77, 0xFC, 0x3C,
  0xF7, 0x7F, 0x07, 0xEC, 0x57, 0x07, 0xFC, 0x3C, 0xF7, 0x7F, 0x05, 0xAC, 0xFE, 0x37, 0xD0, 0x07,
  0x94, 0x89, 0x13, 0x10, 0x7F, 0xE5, 0xEF, 0x77, 0x92, 0x03, 0x01, 0x38, 0x91, 0x7F, 0xE5, 0xEF,
  0x77, 0xF0, 0xAA, 0x82, 0x9A, 0x17, 0xD8, 0xA0, 0x77, 0xF0, 0x26, 0x9E, 0xC2, 0x7F, 0xE5, 0xEF,
  0x77, 0x97, 0x86, 0x7F, 0xE5, 0xEF, 0x77, 0x98, 0x03, 0x70, 0xBD, 0x81, 0x72, 0xDF, 0xD0, 0xD0,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_microwave() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_microwave_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_night_shelter 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_filled_18_places_night_shelter_data[] PROGMEM = {
  0x50, 0x05, 0x72, 0x09, 0xA0, 0x96, 0x02, 0x0C, 0xC0, 0xC0, 0x23, 0x05, 0x0E, 0xE8, 0x2E, 0x50,
  0x9F, 0xB0, 0x9F, 0xF0, 0x6F, 0xC8, 0x23, 0xC7, 0x92, 0x01, 0x0A, 0xC8, 0x23, 0x70, 0x73, 0x04,
  0xC8, 0x23, 0x97, 0x63, 0x03, 0xC0, 0x38, 0x02, 0x90, 0x3C, 0x09, 0xE0, 0x9F, 0xF8, 0x09, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_night_shelter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_night_shelter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_no_backpack 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_18_places_no_backpack_data[] PROGMEM = {
  0x48, 0x15, 0x73, 0x28, 0x13, 0x75, 0x30, 0x40, 0x72, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB3, 0x83,
  0x9F, 0x70, 0x5E, 0x0E, 0x08, 0x38, 0x39, 0xF7, 0x05, 0xF0, 0x83, 0x83, 0xEF, 0x70, 0x5E, 0x0E,
  0x3B, 0x81, 0x70, 0x5E, 0x3C, 0x81, 0x70, 0x5D, 0x3D, 0x81, 0x70, 0x5C, 0x39, 0x07, 0x28, 0x19,
  0xF7, 0x30, 0x79, 0x39, 0x85, 0xB7, 0x77, 0xEF, 0x72, 0x07, 0x93, 0xF9, 0x81, 0x70, 0x49, 0x3F,
  0xA8, 0x17, 0x05, 0x3F, 0xB0, 0x74, 0xFC, 0x07, 0x30, 0xDF, 0xC0, 0x72, 0x02, 0x80, 0x67, 0x09,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_no_backpack() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_no_backpack_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_no_cell 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_filled_18_places_no_cell_data[] PROGMEM = {
  0x38, 0x04, 0x33, 0x81, 0x20, 0x6F, 0x90, 0x62, 0x82, 0xA7, 0x3E, 0xF0, 0x73, 0x81, 0xB7, 0x38,
  0x02, 0x70, 0xA0, 0x74, 0x0B, 0x07, 0x60, 0x60, 0x74, 0x81, 0x7E, 0x75, 0x06, 0x07, 0x48, 0x27,
  0x6B, 0x74, 0x06, 0x07, 0x48, 0x37, 0x60, 0xB7, 0x30, 0x60, 0x74, 0x07, 0x06, 0x20, 0xB0, 0x72,
  0x06, 0x07, 0x40, 0x70, 0x63, 0x83, 0xB7, 0x06, 0x74, 0x07, 0x06, 0x48, 0x2B, 0x73, 0x74, 0x07,
  0x06, 0x50, 0xB0, 0x75, 0x07, 0x0A, 0x80, 0x17, 0x81, 0x8F, 0x74, 0x07, 0xFA, 0x07, 0x30, 0x6F,
  0x98, 0x16, 0xA2, 0x38, 0x04, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_no_cell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_no_cell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_no_drinks 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_18_places_no_drinks_data[] PROGMEM = {
  0x01, 0x06, 0x18, 0x05, 0x58, 0x32, 0x0B, 0x73, 0x80, 0x27, 0x81, 0x8F, 0x42, 0x81, 0xB7, 0x18,
  0x01, 0x90, 0xB0, 0x84, 0x82, 0xB7, 0x4E, 0xB0, 0xA6, 0x84, 0xC7, 0x4E, 0xFC, 0x78, 0x41, 0xD7,
  0x4D, 0x17, 0x18, 0x12, 0xE7, 0x74, 0x81, 0x7E, 0x77, 0x38, 0x26, 0x7B, 0x77, 0x28, 0x36, 0x60,
  0xB7, 0x58, 0x74, 0x77, 0xBB, 0x78, 0xE7, 0x40, 0x38, 0x02, 0x58, 0x14, 0xB6, 0x75, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_no_drinks() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_no_drinks_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_no_flash 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_filled_18_places_no_flash_data[] PROGMEM = {
  0x73, 0x84, 0x13, 0x30, 0x16, 0x71, 0x81, 0x6F, 0xE2, 0x0B, 0x07, 0x78, 0x16, 0xF9, 0x30, 0xB0,
  0x76, 0x82, 0x5E, 0xE1, 0x38, 0x3B, 0x71, 0xB3, 0x30, 0x70, 0x62, 0x89, 0x14, 0x5C, 0xF7, 0x4E,
  0x65, 0x05, 0x20, 0x3C, 0x84, 0xE7, 0x4E, 0xF8, 0x30, 0x4A, 0x86, 0xD4, 0x8F, 0x74, 0xE9, 0x30,
  0x4A, 0x05, 0x0E, 0xA8, 0x2E, 0x74, 0x83, 0x04, 0xA0, 0x5B, 0x81, 0x6F, 0x74, 0x04, 0xA8, 0x38,
  0x8F, 0xB5, 0xA0, 0x73, 0x04, 0xB8, 0x29, 0x57, 0xEB, 0x07, 0x20, 0x3F, 0xA8, 0x18, 0xB6, 0x28,
  0x05, 0x32, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_no_flash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_no_flash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_no_food 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_18_places_no_food_data[] PROGMEM = {
  0x72, 0x02, 0x40, 0x27, 0x10, 0xB0, 0x23, 0x0A, 0x07, 0x70, 0xB0, 0x24, 0x0B, 0x07, 0x38, 0x66,
  0x77, 0xD8, 0x77, 0x22, 0x0B, 0x07, 0x20, 0xCE, 0x03, 0x38, 0x2B, 0x70, 0xBE, 0x02, 0x48, 0x2B,
  0x74, 0xED, 0x38, 0x54, 0xAD, 0xF7, 0x4E, 0xC2, 0x06, 0xD8, 0x17, 0x4E, 0xA0, 0xD2, 0xF8, 0x57,
  0x4E, 0xFC, 0x02, 0x80, 0x3B, 0x85, 0xD7, 0x4E, 0xB0, 0x18, 0x04, 0x58, 0x4B, 0x74, 0x90, 0x28,
  0x03, 0x78, 0x26, 0x0B, 0x72, 0x02, 0x80, 0x39, 0x07, 0x20, 0xB0, 0x72, 0x80, 0x33, 0x02, 0x30,
  0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_no_food() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_no_food_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_no_meeting_room 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_filled_18_places_no_meeting_room_data[] PROGMEM = {
  0x10, 0x17, 0x71, 0x83, 0x1E, 0x70, 0x58, 0x01, 0xB0, 0x57, 0x83, 0x6F, 0x70, 0x9F, 0x90, 0x34,
  0x83, 0x6F, 0x70, 0x9B, 0x83, 0xB7, 0x9F, 0x35, 0x83, 0x7F, 0x70, 0x9A, 0x83, 0x70, 0x3F, 0x35,
  0x03, 0xA8, 0x77, 0x09, 0xF7, 0x03, 0xF3, 0x50, 0x3B, 0x86, 0x70, 0x97, 0x03, 0xF3, 0x50, 0x3B,
  0x09, 0x28, 0x32, 0x03, 0xF3, 0x50, 0x3B, 0x81, 0x93, 0x72, 0x81, 0x3F, 0x35, 0x03, 0xE8, 0x37,
  0x03, 0xF3, 0x50, 0x3F, 0x82, 0x70, 0x93, 0x50, 0x3E, 0x81, 0xCF, 0x77, 0x03, 0xE8, 0x27, 0x6F,
  0x75, 0x08, 0x0C, 0xE8, 0x37, 0x06, 0xF7, 0x40, 0x88, 0x03, 0xB0, 0x52, 0x81, 0x6F, 0x77, 0x71,
  0x81, 0x6E, 0x17, 0x71, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_no_meeting_room() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 17), Box(0, 0, 17, 17),
      ic_filled_18_places_no_meeting_room_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_no_photography 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_18_places_no_photography_data[] PROGMEM = {
  0x02, 0x48, 0x00, 0x35, 0x0A, 0x07, 0x20, 0x9C, 0x09, 0x58, 0x2E, 0x72, 0xED, 0x83, 0xA7, 0x60,
  0x4A, 0x81, 0x74, 0xEF, 0x00, 0x4B, 0x83, 0x73, 0x66, 0xBC, 0x00, 0x4B, 0x0E, 0x07, 0x30, 0x9B,
  0x00, 0x4B, 0x81, 0x2F, 0x72, 0x01, 0xB0, 0x04, 0xA0, 0xD0, 0x3A, 0x07, 0x20, 0xEA, 0x00, 0x4B,
  0x01, 0x0D, 0xA8, 0x17, 0x0E, 0xA0, 0x04, 0xB8, 0x91, 0xA2, 0x99, 0xB7, 0x4E, 0xF4, 0x4C, 0x89,
  0x0C, 0x77, 0xCF, 0x74, 0xE4, 0x3F, 0xB8, 0x37, 0x43, 0x04, 0x80, 0x55, 0x0B, 0x07, 0x76, 0x0A,
  0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_no_photography() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_no_photography_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_no_stroller 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_18_places_no_stroller_data[] PROGMEM = {
  0x01, 0x06, 0x28, 0x63, 0x54, 0x10, 0x15, 0x12, 0x82, 0xB7, 0x3E, 0xA8, 0x4B, 0x1D, 0x9D, 0x22,
  0x89, 0x1B, 0x74, 0xED, 0x2C, 0xA0, 0x32, 0x38, 0x5B, 0x73, 0x2A, 0xFA, 0x78, 0x4B, 0x72, 0xEF,
  0xA7, 0x18, 0x3C, 0x74, 0xEA, 0x70, 0x4A, 0x81, 0x74, 0xA6, 0x02, 0x0E, 0xB0, 0x70, 0x16, 0x85,
  0x5B, 0xBB, 0xBD, 0x75, 0x04, 0x03, 0x48, 0x12, 0xE7, 0x30, 0x4A, 0x02, 0x30, 0xEA, 0x07, 0x20,
  0x3A, 0x02, 0x38, 0x3D, 0xF7, 0xB6, 0x20, 0x02, 0x40, 0x10, 0x32, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_no_stroller() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_no_stroller_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_other_houses 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_filled_18_places_other_houses_data[] PROGMEM = {
  0x70, 0x07, 0x75, 0x01, 0x0A, 0xA0, 0xA0, 0x17, 0x20, 0x30, 0xDC, 0x0D, 0x03, 0x70, 0x6F, 0x90,
  0x65, 0x0A, 0xFB, 0x0A, 0x20, 0x20, 0xDF, 0xD8, 0x3D, 0x20, 0xA8, 0xFB, 0x08, 0x0A, 0x38, 0x92,
  0x6F, 0xB2, 0xF6, 0x6F, 0x2B, 0xF6, 0x40, 0x6A, 0x84, 0xDF, 0xEE, 0xFD, 0xA0, 0x64, 0x06, 0xFB,
  0x06, 0x40, 0x6F, 0xB0, 0x64, 0x06, 0xFB, 0x06, 0x40, 0x18, 0x06, 0x30, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_other_houses() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_other_houses_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_pool 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_filled_18_places_pool_data[] PROGMEM = {
  0x28, 0x22, 0xB8, 0x34, 0x81, 0x7A, 0x45, 0x03, 0xB0, 0x82, 0x05, 0xB0, 0x15, 0x85, 0x26, 0xEF,
  0x90, 0x6B, 0x02, 0x78, 0x62, 0xDF, 0x90, 0xBE, 0x87, 0x10, 0x10, 0xDA, 0x09, 0x73, 0x01, 0x0D,
  0xC0, 0x97, 0x28, 0x68, 0xFA, 0x55, 0xAF, 0x57, 0x76, 0x8A, 0x21, 0x7C, 0xC7, 0x27, 0xCC, 0x72,
  0x7C, 0xC7, 0x17, 0xFB, 0xBB, 0x00, 0xBB, 0x84, 0xBB, 0xF7, 0x22, 0x28, 0x12, 0x52, 0x28, 0x12,
  0x52, 0x28, 0xA1, 0x22, 0x01, 0x66, 0x10, 0x16, 0x61, 0x01, 0x66, 0x10, 0x5C, 0x0B, 0xC0, 0xBC,
  0x89, 0x75, 0x58, 0x11, 0x8B, 0x81, 0x18, 0xB8, 0x11, 0x85,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_pool() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_pool_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_rice_bowl 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_18_places_rice_bowl_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x50, 0x20, 0xDA, 0x82, 0x81, 0x18, 0xA0,
  0xD0, 0x23, 0x84, 0x1D, 0xD3, 0xF7, 0x28, 0x47, 0xF3, 0xDD, 0x12, 0x84, 0x9F, 0x30, 0xF7, 0x28,
  0x47, 0xF0, 0x3F, 0x92, 0x90, 0x92, 0x90, 0x72, 0x07, 0x92, 0x84, 0x9F, 0x05, 0xF3, 0x29, 0x07,
  0x20, 0x79, 0x28, 0x43, 0xF5, 0x6F, 0x12, 0x90, 0x72, 0x07, 0x92, 0x82, 0x1F, 0x66, 0xFF, 0x06,
  0x03, 0xFF, 0x81, 0x30, 0xDF, 0xD0, 0xD2, 0x05, 0xFD, 0x05, 0x30, 0x7F, 0xB0, 0x75, 0x05, 0x0D,
  0xE0, 0xD0, 0x57, 0x1E, 0x73, 0x80, 0x27, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_rice_bowl() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_rice_bowl_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_roofing 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_filled_18_places_roofing_data[] PROGMEM = {
  0x70, 0x04, 0x76, 0x06, 0xA0, 0x61, 0xA0, 0x37, 0x84, 0x7F, 0xAA, 0xF7, 0xA0, 0x36, 0x81, 0x9F,
  0x92, 0x09, 0xB0, 0x35, 0x81, 0xAF, 0x84, 0x08, 0xA0, 0x33, 0x82, 0x1B, 0xF6, 0x68, 0x76, 0xFB,
  0x10, 0x1C, 0xF5, 0x71, 0x82, 0x5F, 0xC1, 0x77, 0x78, 0x41, 0x77, 0x77, 0x17, 0x30, 0x3C, 0x03,
  0x73, 0x84, 0x3F, 0x33, 0xF3, 0x73, 0x84, 0x3F, 0x99, 0xF3, 0x73, 0x03, 0xC0, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_roofing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_roofing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_room_preferences 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_18_places_room_preferences_data[] PROGMEM = {
  0x10, 0x28, 0x02, 0xB0, 0x57, 0x03, 0xFB, 0x03, 0x30, 0x3E, 0x83, 0xB7, 0x9F, 0x33, 0x03, 0xE8,
  0x37, 0x03, 0xF3, 0x30, 0x3E, 0x83, 0x70, 0x3F, 0x33, 0x03, 0xE8, 0x37, 0x01, 0x71, 0x30, 0x3B,
  0x82, 0x93, 0xF5, 0x70, 0x3B, 0x81, 0x93, 0x62, 0x81, 0x5F, 0x53, 0x03, 0xC8, 0x91, 0xC0, 0x68,
  0xDF, 0xD7, 0x60, 0x3C, 0x89, 0x16, 0x0D, 0xFA, 0x4A, 0xFD, 0x03, 0xC8, 0x91, 0x40, 0x5F, 0x10,
  0x1F, 0x50, 0x3C, 0x89, 0x15, 0x09, 0xF4, 0x04, 0xF9, 0x8C, 0xC8, 0x19, 0x0C, 0xA0, 0xCA, 0x0C,
  0x08, 0x80, 0x2B, 0x18, 0x51, 0x08, 0xF8, 0x01, 0x73, 0x81, 0x27, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_room_preferences() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_room_preferences_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_room_service 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_filled_18_places_room_service_data[] PROGMEM = {
  0x70, 0x01, 0x76, 0x03, 0xA0, 0x37, 0x50, 0x7A, 0x07, 0x73, 0x04, 0x0B, 0xC0, 0xB0, 0x47, 0x07,
  0xF9, 0x07, 0x50, 0x6F, 0xB0, 0x63, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x20, 0x6F, 0xD0, 0x62, 0x09,
  0xFD, 0x81, 0x90, 0x18, 0x09, 0x23, 0x01, 0x07, 0xFF, 0x07, 0x01, 0x80, 0x92, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_room_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_room_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_rv_hookup 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_filled_18_places_rv_hookup_data[] PROGMEM = {
  0x72, 0x01, 0x76, 0x03, 0x0B, 0x60, 0x3F, 0x0A, 0x50, 0x18, 0x01, 0x78, 0x19, 0xF4, 0x30, 0x10,
  0x26, 0x03, 0x04, 0x38, 0x11, 0xD6, 0x80, 0x43, 0x30, 0xBF, 0xB0, 0xB2, 0x89, 0x11, 0xD6, 0x33,
  0xCF, 0x93, 0x39, 0x93, 0x01, 0x02, 0x28, 0x1B, 0xF7, 0x20, 0x79, 0x28, 0x01, 0x78, 0x4D, 0xFB,
  0x77, 0xB9, 0x2F, 0xD2, 0xFD, 0x81, 0x31, 0xBB, 0x0D, 0x0A, 0xF8, 0x77, 0x03, 0x3E, 0xA2, 0xF8,
  0x80, 0x13, 0x01, 0x30, 0x8A, 0x0E, 0x01, 0x73, 0x81, 0x46, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_rv_hookup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 16, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_rv_hookup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_smoke_free 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_filled_18_places_smoke_free_data[] PROGMEM = {
  0x71, 0x01, 0x05, 0x30, 0x17, 0x28, 0x12, 0xE9, 0x20, 0x70, 0xB3, 0x02, 0x50, 0x80, 0x92, 0x81,
  0x7F, 0x52, 0x81, 0x3F, 0x54, 0x08, 0x0A, 0x28, 0x24, 0xAE, 0x42, 0x81, 0x7F, 0x53, 0x86, 0x2E,
  0xA9, 0x72, 0x5E, 0x38, 0x17, 0xF5, 0x38, 0x61, 0x67, 0xAE, 0x2C, 0x53, 0x81, 0x7F, 0x56, 0x82,
  0x98, 0x97, 0x48, 0x17, 0xF5, 0x58, 0xA3, 0x79, 0x97, 0x13, 0x33, 0x3B, 0xF5, 0x01, 0x32, 0x12,
  0x21, 0x7F, 0x87, 0x50, 0xAB, 0x79, 0x97, 0x7F, 0x98, 0x55, 0x06, 0x79, 0x97, 0x71, 0x81, 0x7F,
  0x57, 0x78, 0x17, 0xF5, 0x77, 0x81, 0x7F, 0x57, 0x78, 0x17, 0xF5, 0x77, 0x07, 0x0D, 0x77, 0x10,
  0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_smoke_free() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 17), Box(0, 0, 17, 17),
      ic_filled_18_places_smoke_free_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_smoking_rooms 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_filled_18_places_smoking_rooms_data[] PROGMEM = {
  0x74, 0x04, 0x03, 0x77, 0x81, 0x6E, 0x47, 0x40, 0x22, 0x06, 0x0C, 0x73, 0x00, 0xC2, 0x05, 0x0C,
  0x72, 0x07, 0x0B, 0x28, 0x16, 0xE5, 0x72, 0x00, 0x82, 0x82, 0x5C, 0xD3, 0x71, 0x86, 0x3E, 0x75,
  0x40, 0x7D, 0x72, 0x86, 0x4A, 0xBD, 0xD1, 0xD5, 0x75, 0x82, 0xB7, 0xA7, 0x75, 0x82, 0x79, 0x97,
  0x75, 0x83, 0x12, 0x21, 0x7F, 0xB8, 0x4B, 0x79, 0x97, 0x7F, 0xB8, 0x4B, 0x79, 0x97, 0x18, 0x06,
  0x38, 0x32, 0x12, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_smoking_rooms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_smoking_rooms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_soap 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_filled_18_places_soap_data[] PROGMEM = {
  0x73, 0x01, 0x76, 0x81, 0x1F, 0x77, 0x68, 0x27, 0x24, 0x37, 0x87, 0x30, 0x6C, 0x84, 0xCD, 0x25,
  0x89, 0x08, 0xF0, 0xC0, 0xB5, 0xDD, 0x24, 0x89, 0x09, 0xFA, 0x0A, 0xAB, 0x02, 0x24, 0x82, 0x9F,
  0xE1, 0x20, 0x27, 0x09, 0xA0, 0xE8, 0x02, 0xD0, 0x43, 0x09, 0xE8, 0x00, 0x70, 0x12, 0x02, 0xF8,
  0x02, 0x90, 0x10, 0x3F, 0x80, 0x1B, 0x81, 0xA1, 0x3F, 0x80, 0x15, 0x20, 0x3F, 0x80, 0x1D, 0x81,
  0x30, 0x2F, 0x0F, 0x15, 0x0B, 0xFA, 0x07, 0x50, 0x28, 0x04, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_soap() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_soap_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_spa 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_18_places_spa_data[] PROGMEM = {
  0x70, 0x01, 0x77, 0x0B, 0x0C, 0x76, 0x06, 0xA0, 0x77, 0x50, 0xEA, 0x0E, 0x74, 0x04, 0xC0, 0x47,
  0x30, 0x7C, 0x07, 0x58, 0x13, 0x53, 0x20, 0x30, 0xDA, 0x0D, 0x03, 0x28, 0x23, 0x53, 0x6A, 0x0D,
  0x07, 0x20, 0x0B, 0x20, 0x70, 0xDA, 0x06, 0x03, 0xC0, 0xD0, 0x22, 0x02, 0x0D, 0xC8, 0x13, 0x0E,
  0xC8, 0x2E, 0x22, 0xEC, 0x0E, 0x20, 0x8D, 0x00, 0xDD, 0x08, 0x20, 0x10, 0xEF, 0xB0, 0xE0, 0x13,
  0x04, 0xFB, 0x04, 0x50, 0x40, 0xEE, 0x0E, 0x04, 0x70, 0x10, 0xAC, 0x0A, 0x01, 0x73, 0x82, 0x15,
  0x51, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_spa() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_spa_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_sports_bar 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_filled_18_places_sports_bar_data[] PROGMEM = {
  0x50, 0x27, 0x40, 0x50, 0xEA, 0x81, 0x87, 0x26, 0x87, 0x4F, 0x83, 0x7F, 0xDF, 0x54, 0x81, 0x7F,
  0xC5, 0x08, 0x0E, 0x38, 0x11, 0xF7, 0x38, 0x43, 0x89, 0xBF, 0x12, 0x81, 0x3F, 0x12, 0x07, 0xC8,
  0x7E, 0x41, 0x01, 0xE9, 0x28, 0xF8, 0x3E, 0x20, 0x5E, 0xF8, 0x2A, 0x2F, 0x42, 0x01, 0xF8, 0x29,
  0x0F, 0x43, 0xF8, 0x29, 0x0F, 0x43, 0xF8, 0x29, 0x0F, 0x43, 0xF8, 0x2B, 0x6F, 0x43, 0xFA, 0x0B,
  0x4F, 0x09, 0x68, 0x03, 0x30, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_sports_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_sports_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_stairs 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_filled_18_places_stairs_data[] PROGMEM = {
  0x18, 0x06, 0x51, 0x05, 0xFB, 0x05, 0x06, 0xE8, 0x4D, 0x55, 0xA6, 0x6E, 0x84, 0xC3, 0xBD, 0x66,
  0xC8, 0x2C, 0x97, 0x4A, 0x00, 0x6C, 0x82, 0x84, 0x7A, 0xA0, 0x06, 0xA8, 0x2A, 0x74, 0x8C, 0x00,
  0x6A, 0x82, 0x47, 0x9C, 0xC8, 0x46, 0x6D, 0xB3, 0xCE, 0x84, 0x66, 0xA5, 0x5D, 0xE0, 0x60, 0x5F,
  0xB0, 0x51, 0x80, 0x65, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_stairs() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_stairs_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_storefront 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_filled_18_places_storefront_data[] PROGMEM = {
  0x10, 0x20, 0xA8, 0x06, 0xB0, 0xA0, 0x22, 0x89, 0x4A, 0xEB, 0xEE, 0xBE, 0xEB, 0xEE, 0xBE, 0xA2,
  0x89, 0x81, 0xD9, 0x0C, 0xA0, 0xBB, 0x0A, 0xC0, 0x9D, 0x02, 0xF5, 0x0E, 0x80, 0xBB, 0x08, 0xE0,
  0x6F, 0x25, 0xF2, 0x1F, 0x60, 0xBB, 0x07, 0xF1, 0x2F, 0x56, 0xF1, 0x3F, 0x60, 0xDD, 0x07, 0xF3,
  0x1F, 0x62, 0xFD, 0xEA, 0x0D, 0xA0, 0xDA, 0x8A, 0x1E, 0xDF, 0x20, 0xBE, 0x93, 0x8A, 0x65, 0xA8,
  0x39, 0xEB, 0x20, 0x0B, 0x73, 0x00, 0xB2, 0x00, 0xB7, 0x30, 0x0B, 0x20, 0x0B, 0x73, 0x00, 0xB2,
  0x00, 0xB7, 0x30, 0x0B, 0x20, 0xA0, 0xE8, 0x06, 0xB0, 0xE0, 0xA2, 0x02, 0x0A, 0x80, 0x6B, 0x0A,
  0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_storefront() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_storefront_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_stroller 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_18_places_stroller_data[] PROGMEM = {
  0x38, 0x63, 0x54, 0x10, 0x15, 0x12, 0x02, 0x0E, 0xB8, 0x4B, 0x1D, 0x9D, 0x22, 0x07, 0xA8, 0x5D,
  0x2C, 0xA0, 0x32, 0x38, 0x47, 0xE2, 0xAF, 0xA7, 0x01, 0x08, 0xA0, 0xA7, 0x06, 0xB0, 0xA6, 0x04,
  0xC0, 0xA5, 0x02, 0x0E, 0xC0, 0xA5, 0x05, 0x80, 0x1B, 0x04, 0x40, 0x40, 0x34, 0x02, 0x05, 0x30,
  0x4A, 0x02, 0x38, 0x1E, 0xF7, 0x20, 0x3A, 0x02, 0x38, 0x1D, 0xF6, 0x30, 0x02, 0x40, 0x10, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_stroller() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_stroller_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_tapas 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_filled_18_places_tapas_data[] PROGMEM = {
  0x30, 0x10, 0x34, 0x01, 0x80, 0x13, 0x01, 0x30, 0x79, 0x40, 0x7D, 0x8A, 0x07, 0x19, 0xBD, 0xFB,
  0xB6, 0x07, 0xF3, 0x33, 0xF7, 0xBF, 0x03, 0x07, 0x93, 0x90, 0x70, 0xCF, 0x89, 0x04, 0x7F, 0x77,
  0x7F, 0x73, 0xDD, 0x81, 0xA0, 0x7D, 0x86, 0x70, 0x23, 0x9F, 0x33, 0x20, 0x7D, 0x07, 0x06, 0xE8,
  0x1D, 0x17, 0xD0, 0x70, 0xCF, 0x05, 0x04, 0xD0, 0x40, 0x9F, 0x81, 0x20, 0xAB, 0x0A, 0x28, 0x55,
  0x7B, 0xF7, 0x72, 0x38, 0x16, 0xF6, 0x50, 0x79, 0x68, 0x13, 0xF3, 0x50, 0x79, 0x68, 0x13, 0xF3,
  0x50, 0x79, 0x68, 0x13, 0xF3, 0x50, 0x79, 0x68, 0x13, 0xF3, 0x50, 0x79, 0x58, 0x32, 0x6F, 0x62,
  0x40, 0x79, 0x50, 0xBB, 0x0B, 0x40, 0x10, 0x35, 0x83, 0x23, 0x33, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_tapas() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_filled_18_places_tapas_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_tty 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_filled_18_places_tty_data[] PROGMEM = {
  0x10, 0xF5, 0x38, 0x65, 0x14, 0x22, 0x31, 0x3B, 0x01, 0x28, 0x66, 0x15, 0x33, 0x42, 0x1B, 0x05,
  0x28, 0x41, 0x72, 0x54, 0x32, 0x0D, 0xA0, 0x93, 0x83, 0x31, 0x21, 0x12, 0x82, 0x8F, 0xE2, 0x28,
  0x91, 0xA2, 0x84, 0x57, 0x30, 0x1F, 0x53, 0x84, 0x10, 0x10, 0x11, 0x30, 0x70, 0x97, 0x60, 0xA0,
  0x72, 0x81, 0x17, 0x47, 0x18, 0x2B, 0x93, 0xDB, 0x05, 0x70, 0x8D, 0x07, 0x71, 0x81, 0x29, 0xEA,
  0x07, 0x74, 0x81, 0x35, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_tty() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_tty_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_umbrella 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_filled_18_places_umbrella_data[] PROGMEM = {
  0x40, 0x16, 0x82, 0x3D, 0xD1, 0x48, 0x26, 0x76, 0x24, 0x00, 0x63, 0x8B, 0x5B, 0x65, 0xEE, 0x56,
  0xB9, 0xCA, 0x88, 0xAC, 0x94, 0xA0, 0x66, 0x0A, 0x40, 0xD0, 0x66, 0x0D, 0x28, 0x4A, 0x36, 0x63,
  0xA2, 0x84, 0x58, 0x66, 0x85, 0x28, 0x41, 0xD6, 0x6D, 0x13, 0x82, 0xC9, 0x9C, 0x48, 0x27, 0xDD,
  0x74, 0x02, 0xA0, 0x25, 0x00, 0xD6, 0x00, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_umbrella() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_umbrella_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_vape_free 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_filled_18_places_vape_free_data[] PROGMEM = {
  0x74, 0x01, 0x50, 0x27, 0x20, 0x0A, 0x38, 0x11, 0xE7, 0x68, 0x33, 0x40, 0xA4, 0x38, 0x16, 0xF7,
  0x48, 0x47, 0xC5, 0x09, 0x44, 0x81, 0x6F, 0x73, 0x0D, 0x20, 0x90, 0xD6, 0x81, 0x6F, 0x72, 0x85,
  0xD2, 0x05, 0xAC, 0x15, 0x89, 0x16, 0xF7, 0x03, 0xDB, 0xB4, 0x7A, 0x68, 0x16, 0xF7, 0x28, 0x31,
  0x3D, 0x2D, 0x78, 0x16, 0xF7, 0x38, 0x28, 0x5B, 0x27, 0x81, 0x6F, 0x72, 0x89, 0x55, 0x48, 0x20,
  0x11, 0x31, 0x23, 0x3A, 0xF7, 0x28, 0x23, 0x30, 0x3B, 0x82, 0x6A, 0xEC, 0xB8, 0xA3, 0x70, 0x9F,
  0x30, 0x35, 0x63, 0x57, 0x77, 0x79, 0xF7, 0x06, 0x17, 0x48, 0x16, 0xF7, 0x77, 0x81, 0x6E, 0x27,
  0x70, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_vape_free() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_vape_free_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_vaping_rooms 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_filled_18_places_vaping_rooms_data[] PROGMEM = {
  0x74, 0x01, 0x77, 0x10, 0x0A, 0x75, 0x83, 0x34, 0x0A, 0x47, 0x38, 0x47, 0xC5, 0x09, 0x47, 0x30,
  0xD2, 0x09, 0x0D, 0x74, 0x85, 0xD2, 0x05, 0xAC, 0x17, 0x28, 0x53, 0xDB, 0xB4, 0x7A, 0x74, 0x83,
  0x13, 0xD2, 0xD7, 0x68, 0x28, 0x5B, 0x27, 0x58, 0x90, 0x54, 0x82, 0x01, 0x13, 0x12, 0x80, 0x53,
  0x10, 0x3B, 0x82, 0x6A, 0xEC, 0xF8, 0x53, 0x03, 0x56, 0x35, 0x80, 0x57, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_vaping_rooms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 13), Box(0, 0, 17, 17),
      ic_filled_18_places_vaping_rooms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_villa 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_filled_18_places_villa_data[] PROGMEM = {
  0x72, 0x01, 0x73, 0x82, 0x16, 0xCA, 0x71, 0x04, 0x0A, 0xB0, 0xA5, 0x81, 0x17, 0xDD, 0x0A, 0x40,
  0x4F, 0x90, 0xA4, 0x04, 0xA0, 0xB8, 0x01, 0x98, 0x46, 0x03, 0x20, 0x4A, 0x06, 0x60, 0x3A, 0x02,
  0x04, 0xA0, 0x60, 0x3F, 0x90, 0x04, 0xA0, 0x60, 0x3F, 0x90, 0x04, 0xA0, 0x60, 0x3B, 0x00, 0xCB,
  0x00, 0x4A, 0x06, 0x03, 0xB0, 0x50, 0x4B, 0x00, 0x4A, 0x06, 0x03, 0xB0, 0x50, 0x4B, 0x00, 0x4A,
  0x06, 0x03, 0xB0, 0x50, 0x4B, 0x89, 0x54, 0x13, 0x31, 0x13, 0x33, 0x11, 0x33, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_villa() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_villa_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_wash 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_filled_18_places_wash_data[] PROGMEM = {
  0x75, 0x00, 0x17, 0x60, 0xB0, 0xA7, 0x03, 0x28, 0x11, 0x04, 0xA0, 0x25, 0x08, 0x92, 0x81, 0xB5,
  0x3A, 0x02, 0x48, 0x19, 0xFA, 0x28, 0x3E, 0x90, 0x22, 0x48, 0x29, 0xFE, 0x12, 0x01, 0x70, 0x9A,
  0x0E, 0x80, 0x2D, 0x0A, 0x30, 0x9E, 0x80, 0x07, 0x04, 0x20, 0x2F, 0x80, 0x29, 0x01, 0x03, 0xF8,
  0x01, 0xB8, 0x1A, 0x13, 0xF8, 0x01, 0x52, 0x03, 0xF8, 0x01, 0xD8, 0x13, 0x02, 0xF8, 0x00, 0x14,
  0x0B, 0xFA, 0x0E, 0x50, 0x28, 0x04, 0x30, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_wash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_filled_18_places_wash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_water_damage 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_filled_18_places_water_damage_data[] PROGMEM = {
  0x70, 0x04, 0x76, 0x06, 0xA0, 0x67, 0x40, 0x7C, 0x07, 0x72, 0x09, 0xE0, 0x97, 0x0A, 0xF9, 0x0A,
  0x40, 0x10, 0xBC, 0x00, 0xEC, 0x83, 0xB1, 0x01, 0xCD, 0x00, 0x5D, 0x0C, 0x01, 0x20, 0x3B, 0x0C,
  0x20, 0xCB, 0x03, 0x40, 0x3B, 0x08, 0x20, 0x8B, 0x03, 0x40, 0x3B, 0x82, 0xD2, 0x2D, 0xB0, 0x34,
  0x03, 0xFB, 0x03, 0x40, 0x3F, 0xB0, 0x34, 0x03, 0xFB, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_water_damage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 14), Box(0, 0, 17, 17),
      ic_filled_18_places_water_damage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_18_places_wheelchair_pickup 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_18_places_wheelchair_pickup_data[] PROGMEM = {
  0x20, 0x02, 0x74, 0x03, 0xA0, 0x27, 0x30, 0x4A, 0x02, 0x74, 0x04, 0x03, 0x74, 0x82, 0x9B, 0xB9,
  0x30, 0x20, 0x84, 0x04, 0xC0, 0x32, 0x03, 0x0A, 0x40, 0x4C, 0x03, 0x20, 0x30, 0xA4, 0x04, 0xB8,
  0x4B, 0x05, 0xB3, 0xA4, 0x03, 0x0D, 0xA8, 0x73, 0x4C, 0x13, 0xB3, 0x31, 0x28, 0x92, 0x6F, 0xE0,
  0xA3, 0x02, 0xBB, 0xBC, 0x28, 0x46, 0xFD, 0x0B, 0x23, 0x84, 0x32, 0x88, 0x06, 0xA8, 0x11, 0x6A,
  0x28, 0x51, 0xD2, 0x0B, 0x06, 0xA8, 0x54, 0x08, 0xDA, 0xD5, 0x48, 0x21, 0x33, 0x12, 0x01, 0x03,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_18_places_wheelchair_pickup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_filled_18_places_wheelchair_pickup_data, Alpha4(color::Black));
  return value;
}
