#include "device.h"

using namespace roo_display;

// Image file ic_sharp_36_device_1x_mobiledata 36x36, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_sharp_36_device_1x_mobiledata_data[] PROGMEM = {
  0x80, 0x27, 0x48, 0x26, 0x77, 0x54, 0x82, 0x57, 0x76, 0x1E, 0x40, 0x6B, 0x02, 0x20, 0x2B, 0x06,
  0x1E, 0x50, 0xCA, 0x0A, 0x20, 0xAA, 0x0C, 0x20, 0xF7, 0xB5, 0x03, 0xB0, 0x04, 0xB0, 0x35, 0xB6,
  0x09, 0xA0, 0x0D, 0xA0, 0x96, 0xB6, 0x01, 0x0E, 0xC0, 0xE0, 0x16, 0xB7, 0x06, 0xC0, 0x67, 0xB7,
  0x10, 0xDA, 0x0D, 0x71, 0xB7, 0x04, 0xC0, 0x47, 0xB7, 0x0D, 0xC0, 0xD7, 0xB6, 0x07, 0xA0, 0x0E,
  0xA0, 0x76, 0xB5, 0x02, 0xB0, 0x50, 0x6A, 0x0E, 0x02, 0x5B, 0x50, 0xAA, 0x0C, 0x20, 0xCA, 0x0A,
  0x5B, 0x40, 0x4B, 0x03, 0x20, 0x3B, 0x04, 0x4B, 0x40, 0xDA, 0x09, 0x40, 0x9A, 0x0D, 0x40, 0xF7,
  0x38, 0x32, 0x77, 0x71, 0x48, 0x31, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_1x_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 28, 25), Box(0, 0, 35, 35),
      ic_sharp_36_device_1x_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_30fps 36x36, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_sharp_36_device_30fps_data[] PROGMEM = {
  0x80, 0x91, 0x70, 0x31, 0x80, 0x93, 0x7F, 0xE0, 0x71, 0xFF, 0xFF, 0x07, 0x1F, 0xFF, 0xF0, 0x71,
  0xFF, 0xFF, 0x07, 0x1F, 0xF9, 0x72, 0xC0, 0x71, 0xC0, 0x75, 0x07, 0xC7, 0x2C, 0x07, 0x1C, 0x07,
  0x50, 0x7C, 0x72, 0xC0, 0x71, 0xC0, 0x75, 0x07, 0xC1, 0x01, 0x80, 0x33, 0xC0, 0x71, 0xC0, 0x75,
  0x07, 0xC1, 0x07, 0xFC, 0x07, 0x1C, 0x07, 0x50, 0x7C, 0x10, 0x7F, 0xC0, 0x71, 0xC0, 0x75, 0x07,
  0xC1, 0x07, 0xFC, 0x07, 0x1C, 0x07, 0x50, 0x7C, 0x10, 0x7F, 0xC0, 0x71, 0xC0, 0x75, 0x07, 0xC1,
  0x01, 0x80, 0x33, 0xC0, 0x71, 0xC0, 0x75, 0x07, 0xC7, 0x2C, 0x07, 0x1C, 0x07, 0x50, 0x7C, 0x72,
  0xC0, 0x71, 0xC0, 0x75, 0x07, 0xC7, 0x2C, 0x07, 0x1C, 0x07, 0x50, 0x7F, 0xFB, 0x07, 0x1F, 0xFF,
  0xF0, 0x71, 0xFF, 0xFF, 0x07, 0x1F, 0xFF, 0xF0, 0x71, 0xFF, 0x98, 0x09, 0x17, 0x03, 0x18, 0x09,
  0x37,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_30fps() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 32, 28), Box(0, 0, 35, 35),
      ic_sharp_36_device_30fps_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_3g_mobiledata 36x36, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_36_device_3g_mobiledata_data[] PROGMEM = {
  0x03, 0x80, 0x67, 0x38, 0x09, 0x17, 0x03, 0x07, 0xFB, 0x3F, 0xE0, 0x07, 0xFB, 0x3F, 0xE0, 0x70,
  0x38, 0x03, 0x7B, 0x3B, 0x80, 0x67, 0x03, 0x71, 0xB3, 0xB7, 0x75, 0xB3, 0xB7, 0x68, 0x02, 0x7B,
  0x3B, 0x30, 0x18, 0x02, 0x70, 0x32, 0xFA, 0x3B, 0x30, 0x3E, 0x07, 0x2F, 0xA3, 0xB3, 0x03, 0xE0,
  0x72, 0x80, 0x27, 0xB3, 0xB3, 0x83, 0x17, 0x77, 0xBA, 0x07, 0x71, 0xB3, 0xB7, 0x07, 0xA0, 0x77,
  0x1B, 0x3B, 0x70, 0x7A, 0x07, 0x03, 0x80, 0x37, 0xB3, 0xB8, 0x03, 0x70, 0xBA, 0x00, 0x7F, 0xB3,
  0xFE, 0x00, 0x7F, 0xB3, 0xFE, 0x07, 0x03, 0x80, 0x67, 0x38, 0x09, 0x17, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_3g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 31, 25), Box(0, 0, 35, 35),
      ic_sharp_36_device_3g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_4g_mobiledata 36x36, 4-bit Alpha,  RLE, 126 bytes.
static const unsigned char ic_sharp_36_device_4g_mobiledata_data[] PROGMEM = {
  0x82, 0x37, 0x73, 0x28, 0x23, 0x77, 0x34, 0x80, 0x91, 0x70, 0x30, 0x7A, 0x07, 0x20, 0x7A, 0x07,
  0x4F, 0xE0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0xFE, 0x00, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x4B,
  0x80, 0x67, 0x03, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0xB7, 0x40, 0x7A, 0x07, 0x20, 0x7A, 0x07,
  0x4B, 0x74, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0xB4, 0x03, 0x80, 0x17, 0x03, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x74, 0xB4, 0x07, 0xD0, 0x07, 0xFC, 0x07, 0x1B, 0x40, 0x7D, 0x00, 0x7F, 0xC0, 0x71,
  0xB4, 0x82, 0x37, 0x7B, 0xA0, 0x07, 0xFC, 0x07, 0x1B, 0x70, 0x7A, 0x07, 0x60, 0x7A, 0x07, 0x4B,
  0x70, 0x7A, 0x07, 0x60, 0x7A, 0x07, 0x4B, 0x80, 0x37, 0x0B, 0xA0, 0x76, 0x07, 0xA0, 0x74, 0xFE,
  0x07, 0x60, 0x7A, 0x07, 0x4F, 0xE0, 0x76, 0x82, 0x37, 0x73, 0x48, 0x09, 0x17, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_4g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 31, 25), Box(0, 0, 35, 35),
      ic_sharp_36_device_4g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_4g_plus_mobiledata 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_sharp_36_device_4g_plus_mobiledata_data[] PROGMEM = {
  0x82, 0x37, 0x73, 0x28, 0x23, 0x77, 0x32, 0x03, 0x80, 0x77, 0x03, 0x73, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x72, 0x07, 0xFC, 0x07, 0x73, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xFC, 0x07, 0x73,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0xB8, 0x04, 0x70, 0x34, 0x0F, 0x73, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x6B, 0x30, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A,
  0x07, 0x76, 0xB3, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x03, 0x80, 0x17, 0x03,
  0x10, 0xF7, 0xB8, 0x00, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x07, 0x1F,
  0xA0, 0x7F, 0xB1, 0x07, 0xA0, 0x72, 0x07, 0xD0, 0x71, 0xFA, 0x07, 0xFB, 0x10, 0x7A, 0x07, 0x28,
  0x23, 0x77, 0xBA, 0x07, 0x10, 0xF7, 0xB8, 0x00, 0x7F, 0xB1, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x74,
  0xB7, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x4B, 0x72, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0xB8, 0x01, 0x70, 0xBA, 0x07, 0x40, 0xF7, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xFC, 0x07, 0x77,
  0x20, 0x7A, 0x07, 0x20, 0x7F, 0xC0, 0x77, 0x72, 0x82, 0x37, 0x73, 0x20, 0x38, 0x07, 0x70, 0x37,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_4g_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 10, 35, 25), Box(0, 0, 35, 35),
      ic_sharp_36_device_4g_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_60fps 36x36, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_sharp_36_device_60fps_data[] PROGMEM = {
  0x80, 0x90, 0x73, 0x80, 0x93, 0x7F, 0xD3, 0xFF, 0xFE, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x3F, 0xFD,
  0x07, 0x73, 0xC0, 0x75, 0x07, 0xF9, 0x07, 0x73, 0xC0, 0x75, 0x07, 0xF9, 0x07, 0x73, 0xC0, 0x75,
  0x07, 0xFF, 0xB0, 0x71, 0xC0, 0x75, 0x07, 0xFF, 0xB0, 0x71, 0xC0, 0x75, 0x07, 0xFF, 0xB0, 0x71,
  0xC0, 0x75, 0x07, 0xFF, 0xB0, 0x71, 0xC0, 0x75, 0x07, 0xF9, 0x0B, 0x80, 0x07, 0xC0, 0x71, 0xC0,
  0x75, 0x07, 0xF9, 0x07, 0x4C, 0x07, 0x1C, 0x07, 0x50, 0x7F, 0x90, 0x74, 0xC0, 0x71, 0xC0, 0x75,
  0x07, 0xF9, 0x07, 0x4C, 0x07, 0x1C, 0x07, 0x50, 0x7F, 0x90, 0x74, 0xC0, 0x71, 0xC0, 0x75, 0x07,
  0xFF, 0xB0, 0x71, 0xFF, 0xFF, 0x07, 0x1F, 0xFF, 0xF0, 0x71, 0xFF, 0xFF, 0x07, 0x1F, 0xF9, 0x80,
  0x91, 0x70, 0x31, 0x80, 0x93, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_60fps() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 32, 28), Box(0, 0, 35, 35),
      ic_sharp_36_device_60fps_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_access_alarm 36x36, 4-bit Alpha,  RLE, 298 bytes.
static const unsigned char ic_sharp_36_device_access_alarm_data[] PROGMEM = {
  0x58, 0x11, 0xC7, 0x77, 0x81, 0x7C, 0x17, 0x20, 0x30, 0xEA, 0x05, 0x75, 0x05, 0xA0, 0xE0, 0x37,
  0x05, 0xC0, 0x57, 0x50, 0x5C, 0x05, 0x50, 0x8B, 0x0E, 0x03, 0x28, 0x90, 0x27, 0xBD, 0xEE, 0xDB,
  0x72, 0x20, 0x30, 0xEB, 0x07, 0x30, 0xAB, 0x83, 0xC1, 0x04, 0xCF, 0xB8, 0x3C, 0x40, 0x1C, 0xB8,
  0x1A, 0x0B, 0xB0, 0xA2, 0x0A, 0xFF, 0x0A, 0x20, 0xBB, 0x0B, 0x03, 0xA8, 0x28, 0x02, 0xDB, 0x82,
  0xE9, 0x52, 0x28, 0x22, 0x59, 0xEB, 0x82, 0xD2, 0x08, 0xA8, 0x53, 0x05, 0x50, 0x1D, 0xB0, 0x90,
  0x17, 0x10, 0x10, 0x9B, 0x83, 0xD1, 0x06, 0x55, 0x0C, 0xA0, 0xE0, 0x47, 0x50, 0x40, 0xEA, 0x0C,
  0x70, 0x7B, 0x03, 0x58, 0x17, 0xFB, 0x60, 0x3B, 0x07, 0x50, 0x10, 0xEA, 0x06, 0x68, 0x17, 0xFB,
  0x70, 0x6A, 0x0E, 0x01, 0x40, 0x7A, 0x0C, 0x78, 0x17, 0xFB, 0x71, 0x0C, 0xA0, 0x74, 0x0C, 0xA0,
  0x47, 0x81, 0x7F, 0xB7, 0x10, 0x4A, 0x0C, 0x30, 0x2A, 0x0E, 0x71, 0x81, 0x7F, 0xB7, 0x20, 0xEA,
  0x02, 0x20, 0x4A, 0x0B, 0x71, 0x81, 0x7F, 0xB7, 0x20, 0xBA, 0x04, 0x20, 0x6A, 0x09, 0x71, 0x81,
  0x7F, 0xB7, 0x20, 0x9A, 0x06, 0x20, 0x7A, 0x08, 0x71, 0x81, 0x7F, 0xB7, 0x20, 0x8A, 0x07, 0x20,
  0x6A, 0x09, 0x71, 0x07, 0xA0, 0xA0, 0x17, 0x09, 0xA0, 0x62, 0x04, 0xA0, 0xB7, 0x10, 0x10, 0x9A,
  0x0E, 0x07, 0x60, 0xBA, 0x04, 0x20, 0x2A, 0x0E, 0x73, 0x03, 0x0C, 0xA0, 0xD0, 0x44, 0x0E, 0xA0,
  0x23, 0x0C, 0xA0, 0x47, 0x40, 0x60, 0xEA, 0x07, 0x20, 0x4A, 0x0C, 0x40, 0x7A, 0x0C, 0x75, 0x82,
  0x19, 0xE2, 0x20, 0xCA, 0x07, 0x40, 0x10, 0xEA, 0x06, 0x76, 0x01, 0x20, 0x6A, 0x0E, 0x01, 0x50,
  0x7B, 0x03, 0x77, 0x03, 0xB0, 0x77, 0x0C, 0xA0, 0xE0, 0x47, 0x50, 0x40, 0xEA, 0x0C, 0x71, 0x01,
  0x0D, 0xB0, 0x90, 0x17, 0x10, 0x10, 0x9B, 0x0D, 0x01, 0x72, 0x02, 0x0D, 0xB8, 0x2E, 0x95, 0x22,
  0x82, 0x25, 0x9E, 0xB0, 0xD0, 0x27, 0x40, 0x10, 0xAF, 0xF0, 0xA7, 0x71, 0x04, 0x0C, 0xFB, 0x0C,
  0x04, 0x77, 0x48, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_access_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_access_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_access_alarms 36x36, 4-bit Alpha,  RLE, 305 bytes.
static const unsigned char ic_sharp_36_device_access_alarms_data[] PROGMEM = {
  0x77, 0x72, 0x01, 0x74, 0x81, 0x1C, 0x77, 0x78, 0x19, 0xD2, 0x72, 0x03, 0x0D, 0xA0, 0x57, 0x50,
  0x7A, 0x0E, 0x04, 0x70, 0x50, 0xEB, 0x05, 0x75, 0x04, 0x0E, 0xB0, 0x65, 0x07, 0xB0, 0xE0, 0x32,
  0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x22, 0x02, 0x0D, 0xB0, 0x83, 0x0A, 0xB8, 0x3C, 0x10, 0x4C,
  0xFB, 0x83, 0xC4, 0x01, 0xBB, 0x81, 0xB0, 0xBB, 0x82, 0xA0, 0x1B, 0xFF, 0x82, 0xB1, 0x09, 0xB8,
  0x6B, 0x3E, 0xF8, 0x02, 0xDB, 0x82, 0xE9, 0x52, 0x28, 0x22, 0x59, 0xEB, 0x89, 0x3D, 0x20, 0x7F,
  0xE3, 0x04, 0x50, 0x1E, 0xB0, 0x80, 0x17, 0x10, 0x10, 0x8B, 0x83, 0xE1, 0x05, 0x45, 0x0C, 0xA0,
  0xE0, 0x47, 0x50, 0x40, 0xEA, 0x0C, 0x70, 0x7B, 0x03, 0x58, 0x17, 0xFB, 0x60, 0x3B, 0x07, 0x50,
  0x10, 0xEA, 0x06, 0x68, 0x17, 0xFB, 0x70, 0x6A, 0x0E, 0x01, 0x40, 0x8A, 0x0C, 0x78, 0x17, 0xFB,
  0x71, 0x0C, 0xA0, 0x84, 0x0C, 0xA0, 0x47, 0x81, 0x7F, 0xB7, 0x10, 0x4A, 0x0C, 0x30, 0x2A, 0x0E,
  0x71, 0x81, 0x7F, 0xB7, 0x20, 0xEA, 0x02, 0x20, 0x4A, 0x0B, 0x71, 0x81, 0x7F, 0xB7, 0x20, 0xBA,
  0x04, 0x20, 0x6A, 0x09, 0x71, 0x81, 0x7F, 0xB7, 0x20, 0x9A, 0x06, 0x20, 0x7A, 0x08, 0x71, 0x81,
  0x7F, 0xB7, 0x20, 0x8A, 0x07, 0x20, 0x6A, 0x09, 0x71, 0x07, 0xA0, 0x90, 0x17, 0x09, 0xA0, 0x62,
  0x04, 0xA0, 0xB7, 0x10, 0x10, 0x9A, 0x0E, 0x06, 0x60, 0xBA, 0x04, 0x20, 0x2A, 0x0E, 0x73, 0x03,
  0x0C, 0xA0, 0xC0, 0x34, 0x0E, 0xA0, 0x23, 0x0C, 0xA0, 0x47, 0x40, 0x70, 0xEA, 0x06, 0x20, 0x4A,
  0x0C, 0x40, 0x8A, 0x0C, 0x75, 0x82, 0x1A, 0xE2, 0x20, 0xCA, 0x08, 0x40, 0x10, 0xEA, 0x06, 0x76,
  0x02, 0x20, 0x6A, 0x0E, 0x01, 0x50, 0x7B, 0x03, 0x77, 0x03, 0xB0, 0x77, 0x0C, 0xA0, 0xE0, 0x47,
  0x50, 0x40, 0xEA, 0x0C, 0x71, 0x01, 0x0E, 0xB0, 0x80, 0x17, 0x10, 0x10, 0x8B, 0x0E, 0x01, 0x72,
  0x02, 0x0D, 0xB8, 0x2E, 0x95, 0x22, 0x82, 0x25, 0x9E, 0xB0, 0xD0, 0x27, 0x40, 0x10, 0xBF, 0xF0,
  0xB0, 0x17, 0x70, 0x40, 0xCF, 0xB0, 0xC0, 0x47, 0x74, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x27,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_access_alarms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_access_alarms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_access_time_filled 36x36, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_sharp_36_device_access_time_filled_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x08, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x75, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDF, 0xB8, 0x2B, 0x77, 0xBF, 0xB0, 0xD3, 0x07, 0xFC,
  0x07, 0x20, 0x7F, 0xC0, 0x72, 0x0E, 0xFC, 0x07, 0x20, 0x7F, 0xC8, 0x1E, 0x03, 0xFD, 0x07, 0x20,
  0x7F, 0xD0, 0x30, 0x8F, 0xD0, 0x72, 0x07, 0xFD, 0x08, 0x0B, 0xFD, 0x07, 0x20, 0x7F, 0xD0, 0xB0,
  0xDF, 0xD0, 0x72, 0x07, 0xFD, 0x0D, 0x0E, 0xFD, 0x07, 0x20, 0x4F, 0xD0, 0x0E, 0xFD, 0x08, 0x30,
  0x6F, 0xC0, 0xE0, 0xDF, 0xE0, 0x63, 0x06, 0xFB, 0x0D, 0x0B, 0xFF, 0x05, 0x30, 0x6F, 0xA0, 0xB0,
  0x8F, 0xF9, 0x05, 0x30, 0x6F, 0x90, 0x80, 0x3F, 0xFA, 0x05, 0x30, 0x6F, 0x81, 0x30, 0xEF, 0xFA,
  0x05, 0x20, 0x7E, 0x0E, 0x20, 0x7F, 0xFB, 0x05, 0x07, 0xF0, 0x73, 0x0D, 0xFF, 0xFB, 0x0D, 0x40,
  0x5F, 0xFF, 0xB0, 0x55, 0x08, 0xFF, 0xF9, 0x07, 0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x08, 0xFF, 0xC0,
  0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03,
  0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_access_time_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_access_time_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_access_time 36x36, 4-bit Alpha,  RLE, 254 bytes.
static const unsigned char ic_sharp_36_device_access_time_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x08, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x20,
  0xAB, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xB0, 0xA7, 0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x07, 0x50, 0x5B,
  0x08, 0x77, 0x20, 0x8B, 0x05, 0x40, 0xDA, 0x0A, 0x78, 0x13, 0x75, 0x71, 0x0A, 0xA0, 0xD3, 0x07,
  0xA0, 0xD7, 0x18, 0x17, 0xFB, 0x72, 0x0D, 0xA0, 0x72, 0x0E, 0xA0, 0x67, 0x18, 0x17, 0xFB, 0x72,
  0x06, 0xA8, 0x1E, 0x03, 0xA0, 0xD7, 0x28, 0x17, 0xFB, 0x73, 0x0D, 0xA0, 0x30, 0x8A, 0x08, 0x72,
  0x81, 0x7F, 0xB7, 0x30, 0x8A, 0x08, 0x0B, 0xA0, 0x47, 0x28, 0x17, 0xFB, 0x73, 0x04, 0xA0, 0xB0,
  0xDA, 0x02, 0x72, 0x81, 0x7F, 0xB7, 0x30, 0x2A, 0x0D, 0x0E, 0xA7, 0x38, 0x17, 0xFB, 0x74, 0xA0,
  0x0E, 0xA7, 0x38, 0x27, 0xFD, 0x37, 0x3A, 0x0E, 0x0D, 0xA0, 0x27, 0x20, 0x5B, 0x09, 0x01, 0x70,
  0x2A, 0x0D, 0x0B, 0xA0, 0x47, 0x30, 0x20, 0xAA, 0x0E, 0x06, 0x60, 0x4A, 0x0B, 0x08, 0xA0, 0x87,
  0x50, 0x40, 0xDA, 0x0C, 0x03, 0x40, 0x8A, 0x08, 0x03, 0xA0, 0xD7, 0x70, 0x7B, 0x04, 0x30, 0xDA,
  0x81, 0x30, 0xEA, 0x06, 0x77, 0x81, 0x2A, 0xC3, 0x06, 0xA0, 0xE2, 0x07, 0xA0, 0xD7, 0x76, 0x0D,
  0xA0, 0x73, 0x0D, 0xA0, 0xA7, 0x74, 0x0A, 0xA0, 0xD4, 0x05, 0xB0, 0x87, 0x72, 0x08, 0xB0, 0x55,
  0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x07, 0x70, 0xAB, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xB0, 0xA7, 0x20,
  0x8C, 0x82, 0xD9, 0x42, 0x28, 0x22, 0x49, 0xDC, 0x07, 0x74, 0x05, 0x0D, 0xFF, 0x0D, 0x05, 0x77,
  0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x48, 0x90, 0x38, 0xBD, 0xEE, 0xDB, 0x83, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_access_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_access_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_add_alarm 36x36, 4-bit Alpha,  RLE, 283 bytes.
static const unsigned char ic_sharp_36_device_add_alarm_data[] PROGMEM = {
  0x58, 0x11, 0xC7, 0x77, 0x81, 0x7C, 0x17, 0x20, 0x30, 0xEA, 0x05, 0x75, 0x05, 0xA0, 0xE0, 0x37,
  0x05, 0xC0, 0x57, 0x50, 0x5C, 0x05, 0x50, 0x8B, 0x0E, 0x03, 0x28, 0x90, 0x27, 0xBD, 0xEE, 0xDB,
  0x72, 0x20, 0x30, 0xEB, 0x07, 0x30, 0xAB, 0x83, 0xC1, 0x04, 0xCF, 0xB8, 0x3C, 0x40, 0x1C, 0xB8,
  0x1A, 0x0B, 0xB0, 0xA2, 0x0A, 0xFF, 0x0A, 0x20, 0xBB, 0x0B, 0x03, 0xA8, 0x28, 0x02, 0xDB, 0x82,
  0xE9, 0x52, 0x28, 0x22, 0x59, 0xEB, 0x82, 0xD2, 0x08, 0xA8, 0x53, 0x05, 0x50, 0x1D, 0xB0, 0x90,
  0x17, 0x10, 0x10, 0x9B, 0x83, 0xD1, 0x06, 0x55, 0x0C, 0xA0, 0xE0, 0x47, 0x50, 0x40, 0xEA, 0x0C,
  0x70, 0x7B, 0x03, 0x77, 0x03, 0xB0, 0x75, 0x01, 0x0E, 0xA0, 0x66, 0x82, 0x37, 0x73, 0x60, 0x6A,
  0x0E, 0x01, 0x40, 0x7A, 0x0C, 0x70, 0x7A, 0x07, 0x70, 0xCA, 0x07, 0x40, 0xCA, 0x04, 0x70, 0x7A,
  0x07, 0x70, 0x4A, 0x0C, 0x30, 0x2A, 0x0E, 0x71, 0x07, 0xA0, 0x77, 0x10, 0xEA, 0x02, 0x20, 0x4A,
  0x0B, 0x71, 0x07, 0xA0, 0x77, 0x10, 0xBA, 0x04, 0x20, 0x6A, 0x09, 0x4F, 0xD4, 0x09, 0xA0, 0x62,
  0x07, 0xA0, 0x84, 0xFD, 0x40, 0x8A, 0x07, 0x20, 0x6A, 0x09, 0x4F, 0xD4, 0x09, 0xA0, 0x62, 0x04,
  0xA0, 0xB7, 0x10, 0x7A, 0x07, 0x71, 0x0B, 0xA0, 0x42, 0x02, 0xA0, 0xE7, 0x10, 0x7A, 0x07, 0x71,
  0x0E, 0xA0, 0x23, 0x0C, 0xA0, 0x47, 0x07, 0xA0, 0x77, 0x04, 0xA0, 0xC4, 0x07, 0xA0, 0xC7, 0x07,
  0xA0, 0x77, 0x0C, 0xA0, 0x74, 0x01, 0x0E, 0xA0, 0x66, 0x82, 0x37, 0x73, 0x60, 0x6A, 0x0E, 0x01,
  0x50, 0x7B, 0x03, 0x77, 0x03, 0xB0, 0x77, 0x0C, 0xA0, 0xE0, 0x47, 0x50, 0x40, 0xEA, 0x0C, 0x71,
  0x01, 0x0D, 0xB0, 0x90, 0x17, 0x10, 0x10, 0x9B, 0x0D, 0x01, 0x72, 0x02, 0x0D, 0xB8, 0x2E, 0x95,
  0x22, 0x82, 0x25, 0x9E, 0xB0, 0xD0, 0x27, 0x40, 0x10, 0xAF, 0xF0, 0xA7, 0x71, 0x04, 0x0C, 0xFB,
  0x0C, 0x04, 0x77, 0x48, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_add_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_add_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_add_to_home_screen 36x36, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_sharp_36_device_add_to_home_screen_data[] PROGMEM = {
  0x58, 0x0A, 0x17, 0x5F, 0xFF, 0x5F, 0xFF, 0x5F, 0xFF, 0x5F, 0xFF, 0x5F, 0xFF, 0x5B, 0x80, 0x93,
  0x7B, 0x5B, 0x77, 0x1B, 0x77, 0x72, 0xB7, 0x77, 0x2B, 0x77, 0x72, 0xB3, 0x07, 0xFB, 0x72, 0xB3,
  0x07, 0xFB, 0x72, 0xB3, 0x07, 0xFB, 0x72, 0xB7, 0x10, 0x9D, 0x72, 0xB7, 0x09, 0xE7, 0x2B, 0x60,
  0x9B, 0x09, 0xB7, 0x2B, 0x50, 0x9B, 0x09, 0x1B, 0x72, 0xB4, 0x09, 0xB0, 0x92, 0xB7, 0x2B, 0x30,
  0x9B, 0x09, 0x3B, 0x72, 0xB2, 0x09, 0xB0, 0x94, 0xB7, 0x2B, 0x10, 0x9B, 0x09, 0x50, 0xF7, 0x72,
  0xB0, 0x3B, 0x09, 0x77, 0x4B, 0x18, 0x16, 0xF9, 0x77, 0x5B, 0x20, 0x37, 0x76, 0xB7, 0x77, 0x2B,
  0x5B, 0x77, 0x1B, 0x5B, 0x80, 0x93, 0x7B, 0x5F, 0xFF, 0x5F, 0xFF, 0x5F, 0xFF, 0x5F, 0xFF, 0x5F,
  0xFF, 0x58, 0x0A, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_add_to_home_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 29, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_add_to_home_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_ad_units 36x36, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_sharp_36_device_ad_units_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x0B, 0x80, 0x92, 0x70, 0xBA, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0,
  0x07, 0xA0, 0x71, 0xFD, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x1F, 0xD1, 0x07, 0xA0, 0x07, 0xA0, 0x71,
  0xFD, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A,
  0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x0B, 0x80, 0x92,
  0x70, 0xBA, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F,
  0xFE, 0x07, 0x03, 0x80, 0xA0, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_ad_units() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_ad_units_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_airplanemode_active 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_sharp_36_device_airplanemode_active_data[] PROGMEM = {
  0x76, 0x82, 0x5D, 0xD5, 0x77, 0x74, 0x01, 0xC0, 0x17, 0x77, 0x30, 0x3C, 0x03, 0x77, 0x73, 0x03,
  0xC0, 0x37, 0x77, 0x30, 0x3C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x03, 0x77,
  0x73, 0x03, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x37, 0x77, 0x30, 0x7C,
  0x07, 0x77, 0x71, 0x02, 0x0B, 0xE0, 0xB0, 0x27, 0x74, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x77, 0x10,
  0x60, 0xEF, 0xD0, 0xE0, 0x67, 0x50, 0x30, 0xCF, 0xFA, 0x0C, 0x03, 0x71, 0x01, 0x09, 0xFF, 0xE0,
  0x90, 0x15, 0x07, 0x0E, 0xFF, 0xF9, 0x0E, 0x07, 0x20, 0x40, 0xDF, 0x98, 0x1E, 0x98, 0xC8, 0x18,
  0x9E, 0xF9, 0x0D, 0x04, 0xF8, 0x1C, 0x73, 0x20, 0x3C, 0x03, 0x28, 0x13, 0x7C, 0xFB, 0x82, 0xEA,
  0x51, 0x50, 0x3C, 0x03, 0x58, 0x21, 0x5A, 0xEB, 0x81, 0xD8, 0x47, 0x20, 0x3C, 0x03, 0x72, 0x81,
  0x48, 0xD7, 0x50, 0x3C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x03, 0x77, 0x73,
  0x03, 0xC0, 0x37, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x71, 0x02, 0x0B, 0xE0, 0xB0, 0x27, 0x75, 0x08,
  0xFB, 0x08, 0x77, 0x4C, 0x82, 0xD9, 0x9D, 0xC7, 0x74, 0x82, 0xD9, 0x51, 0x48, 0x21, 0x59, 0xD7,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_airplanemode_active() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_airplanemode_active_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_airplanemode_inactive 36x36, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_sharp_36_device_airplanemode_inactive_data[] PROGMEM = {
  0x77, 0x82, 0x5D, 0xD5, 0x77, 0x02, 0x07, 0x73, 0x01, 0xC0, 0x17, 0x58, 0x22, 0xEF, 0x77, 0x20,
  0x3C, 0x03, 0x75, 0x09, 0xB0, 0x77, 0x10, 0x3C, 0x03, 0x76, 0x0B, 0xB0, 0x77, 0x03, 0xC0, 0x37,
  0x70, 0xBB, 0x07, 0x60, 0x3C, 0x03, 0x77, 0x10, 0xBB, 0x07, 0x50, 0x3C, 0x03, 0x77, 0x20, 0xBB,
  0x07, 0x40, 0x3C, 0x03, 0x77, 0x30, 0xBB, 0x07, 0x30, 0x2C, 0x03, 0x77, 0x40, 0xBB, 0x07, 0x30,
  0x4B, 0x03, 0x77, 0x50, 0xBB, 0x07, 0x30, 0x4A, 0x07, 0x77, 0x60, 0xBB, 0x07, 0x30, 0x4A, 0x0B,
  0x02, 0x77, 0x50, 0xBB, 0x07, 0x30, 0x4B, 0x09, 0x01, 0x77, 0x20, 0x60, 0xEC, 0x07, 0x30, 0x4B,
  0x0E, 0x06, 0x76, 0x03, 0x0C, 0xF0, 0x73, 0x04, 0xC0, 0xC0, 0x37, 0x20, 0x10, 0xAF, 0xB0, 0x73,
  0x04, 0xD0, 0x90, 0x16, 0x07, 0x0E, 0xFD, 0x07, 0x30, 0x4D, 0x0E, 0x07, 0x30, 0x40, 0xDF, 0x98,
  0x1E, 0x98, 0xC0, 0x73, 0x04, 0xE0, 0xD0, 0x41, 0xF8, 0x1C, 0x73, 0x20, 0x3D, 0x07, 0x30, 0x4F,
  0x1B, 0x82, 0xEA, 0x51, 0x50, 0x3E, 0x07, 0x38, 0x21, 0x5A, 0xEB, 0x18, 0x1D, 0x84, 0x72, 0x03,
  0xF0, 0x76, 0x81, 0x48, 0xD7, 0x60, 0x3C, 0x0D, 0xB0, 0x77, 0x77, 0x03, 0xC0, 0x40, 0xBB, 0x07,
  0x77, 0x60, 0x3C, 0x81, 0x30, 0xBB, 0x07, 0x77, 0x50, 0x3C, 0x03, 0x20, 0xBB, 0x07, 0x77, 0x40,
  0x7C, 0x07, 0x30, 0xBB, 0x07, 0x77, 0x10, 0x20, 0xBE, 0x0B, 0x02, 0x20, 0xBB, 0x07, 0x76, 0x08,
  0xFB, 0x08, 0x20, 0xBB, 0x07, 0x75, 0xC8, 0x2D, 0x99, 0xDC, 0x30, 0xBB, 0x06, 0x74, 0x82, 0xD9,
  0x51, 0x48, 0x21, 0x59, 0xD4, 0x82, 0xBF, 0xE2, 0x77, 0x77, 0x09, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_airplanemode_inactive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 32, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_airplanemode_inactive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_airplane_ticket 36x36, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_sharp_36_device_airplane_ticket_data[] PROGMEM = {
  0x80, 0xAF, 0x3F, 0x81, 0xEA, 0xCF, 0xFF, 0xE0, 0x52, 0x0B, 0xFF, 0xFD, 0x0D, 0x30, 0xAF, 0xF0,
  0x10, 0x7F, 0xB0, 0x73, 0x09, 0xFE, 0x20, 0x7F, 0xA0, 0xE0, 0x13, 0x08, 0xFD, 0x20, 0x1F, 0xB0,
  0x94, 0x85, 0x7F, 0xB7, 0x32, 0xCD, 0x20, 0x1D, 0x00, 0xEC, 0x03, 0x72, 0x05, 0xD2, 0x07, 0xC8,
  0x6E, 0x11, 0xCF, 0xD9, 0x47, 0x10, 0x10, 0xBD, 0x01, 0x07, 0xE0, 0x92, 0x02, 0x71, 0x81, 0x37,
  0xBF, 0xFA, 0x02, 0x68, 0x22, 0x6A, 0xEF, 0xFD, 0x0B, 0x28, 0x21, 0x59, 0xDF, 0xFF, 0xB0, 0xA0,
  0xC8, 0x0B, 0x82, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_airplane_ticket() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_airplane_ticket_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_air 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_sharp_36_device_air_data[] PROGMEM = {
  0x77, 0x48, 0x22, 0x67, 0x47, 0x77, 0x30, 0x10, 0xAC, 0x0E, 0x05, 0x77, 0x71, 0x0C, 0xF0, 0x57,
  0x76, 0x07, 0xB8, 0x1A, 0x8D, 0xA0, 0xE7, 0x76, 0x0C, 0xA0, 0x63, 0x0D, 0xA0, 0x57, 0x75, 0x0F,
  0xB4, 0x08, 0xA0, 0x77, 0x77, 0x50, 0xAA, 0x06, 0x77, 0x74, 0x06, 0xB0, 0x24, 0xFF, 0xFB, 0x0A,
  0x5F, 0xFF, 0xA0, 0xC0, 0x15, 0xFF, 0xF0, 0xC0, 0x78, 0x0C, 0x10, 0x80, 0xA5, 0x70, 0x60, 0x23,
  0xFF, 0xFE, 0x0A, 0x01, 0x1F, 0xFF, 0xF0, 0xC1, 0x80, 0xA5, 0x70, 0xAB, 0x07, 0x77, 0x75, 0x06,
  0xA0, 0xCF, 0xF8, 0x1E, 0xB4, 0x72, 0x01, 0xFF, 0xE0, 0x77, 0x10, 0x2A, 0x0E, 0xFF, 0xC0, 0x36,
  0x02, 0x0C, 0xA0, 0xA7, 0x70, 0x10, 0xAA, 0x08, 0x50, 0x3C, 0x03, 0x72, 0x82, 0x17, 0x76, 0x20,
  0x4A, 0x0A, 0x50, 0x3B, 0x05, 0x74, 0xB8, 0x14, 0x1A, 0xA0, 0x85, 0x82, 0x3E, 0xA3, 0x75, 0x0B,
  0xF0, 0x37, 0x77, 0x01, 0x0D, 0xD0, 0x77, 0x77, 0x28, 0x41, 0x9D, 0xEB, 0x47, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_air() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_air_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_aod 36x36, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_sharp_36_device_aod_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x1F, 0xD1, 0x07,
  0xA0, 0x07, 0xA0, 0x71, 0xFD, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x18, 0x09, 0x03, 0x10, 0x7A, 0x00,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x03, 0x80, 0x47, 0x03, 0x20, 0x7A, 0x00, 0x7A,
  0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x05, 0x80, 0x4B, 0x05, 0x20, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xFF, 0xE0, 0x07,
  0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF,
  0xE0, 0x70, 0x38, 0x0A, 0x07, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_aod() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_aod_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_0_bar 36x36, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_sharp_36_device_battery_0_bar_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07,
  0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A,
  0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00,
  0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_1_bar 36x36, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_sharp_36_device_battery_1_bar_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07,
  0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A,
  0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07,
  0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_2_bar 36x36, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_sharp_36_device_battery_2_bar_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07,
  0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_3_bar 36x36, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_sharp_36_device_battery_3_bar_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07,
  0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xFF,
  0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00,
  0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_4_bar 36x36, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_sharp_36_device_battery_4_bar_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7F, 0xF0,
  0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07,
  0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF,
  0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_5_bar 36x36, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_sharp_36_device_battery_5_bar_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xFF, 0x00,
  0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_5_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_5_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_6_bar 36x36, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_sharp_36_device_battery_6_bar_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7F, 0xF0, 0x07,
  0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF,
  0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00,
  0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_6_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_6_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_alert 36x36, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_sharp_36_device_battery_alert_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xD8, 0x2B, 0x77, 0xBD, 0x00, 0x7D, 0x07, 0x20, 0x7D,
  0x00, 0x7D, 0x07, 0x20, 0x7D, 0x00, 0x7D, 0x07, 0x20, 0x7D, 0x00, 0x7D, 0x07, 0x20, 0x7D, 0x00,
  0x7D, 0x07, 0x20, 0x7D, 0x00, 0x7D, 0x07, 0x20, 0x7D, 0x00, 0x7D, 0x07, 0x20, 0x7D, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xD0, 0x72, 0x07, 0xD0, 0x07, 0xD0, 0x72, 0x07, 0xD0,
  0x07, 0xD0, 0x72, 0x07, 0xD0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07,
  0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_charging_full 36x36, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_sharp_36_device_battery_charging_full_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0x90, 0xED, 0x00, 0x7F, 0x0E, 0x08, 0xD0, 0x07, 0xF0, 0x60, 0x7D, 0x00, 0x7E, 0x81, 0xD0, 0x7D,
  0x00, 0x7E, 0x81, 0x50, 0x7D, 0x00, 0x7D, 0x0C, 0x20, 0x7D, 0x00, 0x7D, 0x04, 0x20, 0x7D, 0x00,
  0x7C, 0x0B, 0x30, 0x7D, 0x00, 0x7C, 0x03, 0x38, 0x25, 0xBB, 0xDA, 0x00, 0x7B, 0x0A, 0x70, 0xDA,
  0x00, 0x7B, 0x02, 0x60, 0x6B, 0x00, 0x7A, 0x82, 0xC3, 0x31, 0x40, 0xEB, 0x00, 0x7D, 0x07, 0x30,
  0x7C, 0x00, 0x7D, 0x07, 0x20, 0x10, 0xEC, 0x00, 0x7D, 0x07, 0x20, 0x8D, 0x00, 0x7D, 0x81, 0x70,
  0x1E, 0x00, 0x7D, 0x81, 0x70, 0x9E, 0x00, 0x7D, 0x07, 0x02, 0xF0, 0x07, 0xD0, 0x70, 0xAF, 0x00,
  0x7D, 0x0B, 0xF9, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_charging_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_charging_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_full 36x36, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_sharp_36_device_battery_full_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07,
  0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF,
  0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_saver 36x36, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_sharp_36_device_battery_saver_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xD0, 0x72, 0x07, 0xD0,
  0x07, 0xD0, 0x72, 0x07, 0xD0, 0x07, 0xD0, 0x72, 0x07, 0xD0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7D, 0x07, 0x20, 0x7D, 0x00,
  0x7D, 0x07, 0x20, 0x7D, 0x00, 0x7D, 0x07, 0x20, 0x7D, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_saver() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_saver_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_std 36x36, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_sharp_36_device_battery_std_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F,
  0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07,
  0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF,
  0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_std() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_std_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_battery_unknown 36x36, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_sharp_36_device_battery_unknown_data[] PROGMEM = {
  0x5E, 0x73, 0xE7, 0x3E, 0x60, 0xAF, 0xD8, 0x1A, 0x05, 0xFF, 0x05, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xC8, 0x4C, 0x51, 0x15, 0xCC, 0x00, 0x7B, 0x0A, 0x60, 0xAB,
  0x00, 0x7A, 0x89, 0x0E, 0x10, 0x2A, 0xA2, 0x01, 0xEA, 0x00, 0x7A, 0x0A, 0x20, 0xEA, 0x0E, 0x20,
  0xAA, 0x00, 0x7A, 0x81, 0xB7, 0x9C, 0x81, 0x30, 0x8A, 0x00, 0x7F, 0x90, 0xE2, 0x0A, 0xA0, 0x07,
  0xF8, 0x2E, 0x30, 0x3B, 0x00, 0x7F, 0x82, 0x30, 0x1D, 0xB0, 0x07, 0xE0, 0x72, 0x0C, 0xC0, 0x07,
  0xD0, 0xE2, 0x07, 0xD0, 0x07, 0xD8, 0x2E, 0x77, 0xDD, 0x00, 0x7F, 0xF0, 0x07, 0xD0, 0x72, 0x07,
  0xD0, 0x07, 0xD0, 0x72, 0x07, 0xD0, 0x07, 0xD0, 0x72, 0x07, 0xD0, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x70, 0x5F, 0xF8, 0x15, 0x0A, 0xFD, 0x0A, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_battery_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_battery_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_bloodtype 36x36, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_sharp_36_device_bloodtype_data[] PROGMEM = {
  0x74, 0x00, 0x87, 0x77, 0x0A, 0xA0, 0xA7, 0x75, 0x0B, 0xC0, 0xB7, 0x73, 0x0B, 0xE0, 0xB7, 0x71,
  0x0B, 0xF9, 0x0B, 0x76, 0x0B, 0xFB, 0x0B, 0x74, 0x09, 0xFD, 0x09, 0x72, 0x07, 0xFF, 0x07, 0x70,
  0x3F, 0xFA, 0x03, 0x50, 0x10, 0xDF, 0xFA, 0x0D, 0x01, 0x40, 0x8F, 0x82, 0xB7, 0x7B, 0xF0, 0x83,
  0x02, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x22, 0x0A, 0xF9, 0x07, 0x20, 0x7F, 0x98, 0x1A, 0x01, 0xE8,
  0x2B, 0x77, 0x32, 0x82, 0x37, 0x7B, 0xE0, 0x10, 0x6E, 0x07, 0x71, 0x07, 0xE0, 0x60, 0xBE, 0x07,
  0x71, 0x07, 0xE0, 0xB0, 0xDE, 0x82, 0xB7, 0x73, 0x28, 0x23, 0x77, 0xBE, 0x0D, 0xFB, 0x07, 0x20,
  0x7F, 0xB0, 0xEF, 0xA0, 0x72, 0x07, 0xFA, 0x0E, 0x0C, 0xFA, 0x82, 0xB7, 0x7B, 0xFA, 0x0C, 0x0A,
  0xFF, 0xF9, 0x0A, 0x06, 0xE0, 0x77, 0x10, 0x7E, 0x06, 0x01, 0xE0, 0x77, 0x10, 0x7E, 0x81, 0x10,
  0x9D, 0x07, 0x71, 0x07, 0xD0, 0x92, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x13, 0x05, 0xFF, 0xC0, 0x55,
  0x07, 0xFF, 0xA0, 0x77, 0x05, 0x0E, 0xFD, 0x0E, 0x05, 0x72, 0x02, 0x09, 0xFB, 0x09, 0x02, 0x75,
  0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA6, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_bloodtype() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_bloodtype_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_bluetooth_connected 36x36, 4-bit Alpha,  RLE, 229 bytes.
static const unsigned char ic_sharp_36_device_bluetooth_connected_data[] PROGMEM = {
  0x75, 0x81, 0x7F, 0x77, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xB0, 0x77, 0x77, 0x20, 0x7C,
  0x07, 0x77, 0x10, 0x36, 0x07, 0xD0, 0x77, 0x68, 0x16, 0xF9, 0x50, 0x7E, 0x07, 0x74, 0x03, 0xB0,
  0x94, 0x07, 0xA0, 0x80, 0xBB, 0x07, 0x74, 0x09, 0xB0, 0x93, 0x07, 0xA8, 0x17, 0x0B, 0xB0, 0x77,
  0x40, 0x9B, 0x09, 0x20, 0x7A, 0x07, 0x20, 0xDB, 0x04, 0x74, 0x09, 0xB8, 0x19, 0x07, 0xA8, 0x17,
  0x09, 0xB0, 0x97, 0x60, 0x9B, 0x09, 0x07, 0xA0, 0x70, 0x9B, 0x09, 0x77, 0x10, 0x9B, 0x0E, 0xA0,
  0xEB, 0x09, 0x73, 0x81, 0x1B, 0x14, 0x09, 0xF9, 0x09, 0x48, 0x11, 0xB1, 0x38, 0x31, 0xDF, 0xD1,
  0x40, 0x9E, 0x09, 0x48, 0x61, 0xDF, 0xD1, 0x01, 0xDB, 0x0D, 0x01, 0x40, 0x9C, 0x09, 0x40, 0x10,
  0xDB, 0x82, 0xD1, 0x1D, 0xB0, 0xD0, 0x14, 0x09, 0xC0, 0x94, 0x01, 0x0D, 0xB8, 0x6D, 0x10, 0x1D,
  0xFD, 0x14, 0x09, 0xE0, 0x94, 0x83, 0x1D, 0xFD, 0x13, 0x81, 0x1B, 0x14, 0x09, 0xF9, 0x09, 0x48,
  0x11, 0xB1, 0x73, 0x09, 0xB0, 0xEA, 0x0E, 0xB0, 0x97, 0x71, 0x09, 0xB0, 0x90, 0x7A, 0x07, 0x09,
  0xB0, 0x97, 0x60, 0x9B, 0x81, 0x90, 0x7A, 0x81, 0x70, 0x9B, 0x09, 0x74, 0x09, 0xB0, 0x92, 0x07,
  0xA0, 0x72, 0x0D, 0xB0, 0x47, 0x20, 0x9B, 0x09, 0x30, 0x7A, 0x81, 0x70, 0xBB, 0x07, 0x72, 0x03,
  0xB0, 0x94, 0x07, 0xA0, 0x80, 0xBB, 0x07, 0x74, 0x81, 0x6F, 0x95, 0x07, 0xE0, 0x77, 0x60, 0x36,
  0x07, 0xD0, 0x77, 0x77, 0x07, 0xC0, 0x77, 0x77, 0x10, 0x7B, 0x07, 0x77, 0x72, 0x07, 0xA0, 0x77,
  0x77, 0x38, 0x17, 0xF7, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_bluetooth_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_bluetooth_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_bluetooth_disabled 36x36, 4-bit Alpha,  RLE, 193 bytes.
static const unsigned char ic_sharp_36_device_bluetooth_disabled_data[] PROGMEM = {
  0x73, 0x81, 0x7F, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xB0, 0x77, 0x30, 0x60, 0x97, 0x07,
  0xC0, 0x77, 0x10, 0x6A, 0x09, 0x60, 0x7D, 0x07, 0x70, 0x9B, 0x09, 0x50, 0x7E, 0x07, 0x70, 0x9B,
  0x09, 0x40, 0x7A, 0x08, 0x0B, 0xB0, 0x77, 0x09, 0xB0, 0x93, 0x06, 0xA8, 0x17, 0x0B, 0xB0, 0x77,
  0x09, 0xB0, 0x93, 0x81, 0x8F, 0x72, 0x0D, 0xB0, 0x47, 0x09, 0xB0, 0x93, 0x82, 0x87, 0x09, 0xB0,
  0x97, 0x20, 0x9B, 0x09, 0x30, 0x20, 0x9B, 0x09, 0x74, 0x09, 0xB0, 0x93, 0x08, 0xA0, 0x97, 0x60,
  0x9B, 0x09, 0x30, 0x80, 0x97, 0x71, 0x09, 0xB0, 0x97, 0x76, 0x09, 0xB0, 0x97, 0x75, 0x09, 0xC0,
  0x97, 0x73, 0x09, 0xE0, 0x97, 0x71, 0x09, 0xF9, 0x09, 0x76, 0x09, 0xB0, 0xEA, 0x0E, 0xB0, 0x97,
  0x40, 0x9B, 0x09, 0x07, 0xA0, 0x70, 0x9B, 0x09, 0x72, 0x09, 0xB8, 0x19, 0x07, 0xA8, 0x17, 0x09,
  0xB0, 0x97, 0x09, 0xB0, 0x92, 0x07, 0xA0, 0x72, 0x0D, 0xB0, 0x95, 0x09, 0xB0, 0x93, 0x07, 0xA8,
  0x17, 0x0B, 0xD0, 0x93, 0x03, 0xB0, 0x94, 0x07, 0xA0, 0x80, 0xBB, 0x0C, 0xB0, 0x93, 0x81, 0x6F,
  0x95, 0x07, 0xE8, 0x17, 0x09, 0xB0, 0x93, 0x03, 0x60, 0x7D, 0x07, 0x30, 0x9A, 0x06, 0x73, 0x07,
  0xC0, 0x75, 0x09, 0x06, 0x74, 0x07, 0xB0, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x76, 0x81, 0x7F, 0x77,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_bluetooth_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_bluetooth_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_bluetooth_drive 36x36, 4-bit Alpha,  RLE, 196 bytes.
static const unsigned char ic_sharp_36_device_bluetooth_drive_data[] PROGMEM = {
  0x77, 0x74, 0x07, 0x77, 0x77, 0x19, 0x0A, 0x77, 0x73, 0x01, 0x3A, 0x0A, 0x77, 0x71, 0x81, 0x3E,
  0x42, 0x98, 0x1C, 0xFA, 0x77, 0x71, 0x87, 0xBF, 0x40, 0xF7, 0x6F, 0xA7, 0x77, 0x18, 0x6C, 0xF5,
  0xF8, 0xCF, 0x43, 0x03, 0x80, 0x93, 0x70, 0x33, 0x0C, 0xC0, 0x44, 0x0A, 0xFF, 0x90, 0x74, 0x0C,
  0xA0, 0x44, 0x01, 0xFF, 0xA0, 0x74, 0x0C, 0xA0, 0x44, 0x06, 0xA0, 0xD8, 0x09, 0x17, 0x03, 0x30,
  0xCC, 0x04, 0x30, 0xBA, 0x06, 0x77, 0x28, 0x90, 0xCF, 0x5F, 0x8B, 0xF4, 0x01, 0xB0, 0x17, 0x71,
  0x89, 0x1C, 0xF4, 0x0F, 0x76, 0xFA, 0x06, 0xA0, 0xB7, 0x71, 0x81, 0x3E, 0x42, 0x98, 0x1C, 0xFA,
  0x20, 0xCA, 0x06, 0x77, 0x6A, 0x0A, 0x20, 0x2F, 0xFC, 0x09, 0x59, 0x0A, 0x30, 0x7F, 0xFC, 0x0D,
  0x01, 0x40, 0x74, 0x0C, 0xFF, 0xD0, 0xC0, 0x37, 0x1F, 0xFF, 0xE3, 0xD8, 0x1D, 0x8A, 0xFC, 0x81,
  0xA8, 0xDD, 0x3C, 0x0D, 0x30, 0x6F, 0xA0, 0x63, 0x0D, 0xC3, 0xC0, 0x83, 0x01, 0xFA, 0x01, 0x30,
  0x8C, 0x3C, 0x0A, 0x30, 0x2F, 0xA0, 0x23, 0x0A, 0xC3, 0xD8, 0x26, 0x02, 0xCF, 0xA8, 0x2C, 0x20,
  0x6D, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x3C, 0x0B, 0x80, 0x95, 0x70,
  0xBC, 0x3C, 0x07, 0x77, 0x30, 0x7C, 0x3C, 0x07, 0x77, 0x30, 0x7C, 0x38, 0x00, 0x70, 0x37, 0x73,
  0x03, 0x80, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_bluetooth_drive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_bluetooth_drive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_bluetooth 36x36, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_sharp_36_device_bluetooth_data[] PROGMEM = {
  0x72, 0x81, 0x7F, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xB0, 0x77, 0x71, 0x07, 0xC0, 0x77,
  0x03, 0x60, 0x7D, 0x07, 0x58, 0x16, 0xF9, 0x50, 0x7E, 0x07, 0x30, 0x3B, 0x09, 0x40, 0x7A, 0x08,
  0x0B, 0xB0, 0x73, 0x09, 0xB0, 0x93, 0x07, 0xA8, 0x17, 0x0B, 0xB0, 0x73, 0x09, 0xB0, 0x92, 0x07,
  0xA0, 0x72, 0x0D, 0xB0, 0x43, 0x09, 0xB8, 0x19, 0x07, 0xA8, 0x17, 0x09, 0xB0, 0x95, 0x09, 0xB0,
  0x90, 0x7A, 0x07, 0x09, 0xB0, 0x97, 0x09, 0xB0, 0xEA, 0x0E, 0xB0, 0x97, 0x20, 0x9F, 0x90, 0x97,
  0x40, 0x9E, 0x09, 0x76, 0x09, 0xC0, 0x97, 0x70, 0x9C, 0x09, 0x76, 0x09, 0xE0, 0x97, 0x40, 0x9F,
  0x90, 0x97, 0x20, 0x9B, 0x0E, 0xA0, 0xEB, 0x09, 0x70, 0x9B, 0x09, 0x07, 0xA0, 0x70, 0x9B, 0x09,
  0x50, 0x9B, 0x81, 0x90, 0x7A, 0x81, 0x70, 0x9B, 0x09, 0x30, 0x9B, 0x09, 0x20, 0x7A, 0x07, 0x20,
  0xDB, 0x81, 0x40, 0x9B, 0x09, 0x30, 0x7A, 0x81, 0x70, 0xBB, 0x81, 0x70, 0x3B, 0x09, 0x40, 0x7A,
  0x08, 0x0B, 0xB0, 0x73, 0x81, 0x6F, 0x95, 0x07, 0xE0, 0x75, 0x03, 0x60, 0x7D, 0x07, 0x76, 0x07,
  0xC0, 0x77, 0x70, 0x7B, 0x07, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x28, 0x17, 0xF7, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_bluetooth() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 26, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_bluetooth_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_bluetooth_searching 36x36, 4-bit Alpha,  RLE, 250 bytes.
static const unsigned char ic_sharp_36_device_bluetooth_searching_data[] PROGMEM = {
  0x72, 0x81, 0x7F, 0x77, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xB0, 0x77, 0x77, 0x20, 0x7C,
  0x07, 0x77, 0x10, 0x36, 0x07, 0xD0, 0x77, 0x68, 0x16, 0xF9, 0x50, 0x7E, 0x07, 0x74, 0x03, 0xB0,
  0x94, 0x07, 0xA0, 0x80, 0xBB, 0x07, 0x74, 0x09, 0xB0, 0x93, 0x07, 0xA8, 0x17, 0x0B, 0xB0, 0x75,
  0x03, 0x07, 0x40, 0x9B, 0x09, 0x20, 0x7A, 0x07, 0x20, 0xDB, 0x04, 0x38, 0x23, 0xEE, 0x14, 0x09,
  0xB8, 0x19, 0x07, 0xA8, 0x17, 0x09, 0xB0, 0x94, 0x05, 0xA0, 0x75, 0x09, 0xB0, 0x90, 0x7A, 0x07,
  0x09, 0xB0, 0x96, 0x81, 0xEF, 0xC6, 0x09, 0xB0, 0xEA, 0x0E, 0xB0, 0x93, 0x02, 0x30, 0x9A, 0x01,
  0x60, 0x9F, 0x90, 0x93, 0x81, 0x2E, 0x12, 0x05, 0xA0, 0x47, 0x09, 0xE0, 0x93, 0x82, 0x3E, 0xF5,
  0x20, 0x3A, 0x06, 0x71, 0x09, 0xC0, 0x93, 0x03, 0x0E, 0xA0, 0x72, 0x02, 0xA0, 0x77, 0x10, 0x9C,
  0x09, 0x30, 0x30, 0xEA, 0x07, 0x20, 0x2A, 0x07, 0x70, 0x9E, 0x09, 0x38, 0x23, 0xEF, 0x52, 0x03,
  0xA0, 0x66, 0x09, 0xF9, 0x09, 0x38, 0x13, 0xE1, 0x20, 0x6A, 0x03, 0x50, 0x9B, 0x0E, 0xA0, 0xEB,
  0x09, 0x30, 0x23, 0x09, 0xA5, 0x09, 0xB0, 0x90, 0x7A, 0x07, 0x09, 0xB0, 0x96, 0x81, 0xEF, 0xB4,
  0x09, 0xB8, 0x19, 0x07, 0xA8, 0x17, 0x09, 0xB0, 0x94, 0x05, 0xA0, 0x53, 0x09, 0xB0, 0x92, 0x07,
  0xA0, 0x72, 0x0D, 0xB0, 0x43, 0x81, 0x2E, 0xD3, 0x09, 0xB0, 0x93, 0x07, 0xA8, 0x17, 0x0B, 0xB0,
  0x75, 0x02, 0x05, 0x20, 0x3B, 0x09, 0x40, 0x7A, 0x08, 0x0B, 0xB0, 0x77, 0x48, 0x16, 0xF9, 0x50,
  0x7E, 0x07, 0x76, 0x03, 0x60, 0x7D, 0x07, 0x77, 0x70, 0x7C, 0x07, 0x77, 0x71, 0x07, 0xB0, 0x77,
  0x77, 0x20, 0x7A, 0x07, 0x77, 0x73, 0x81, 0x7F, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_bluetooth_searching() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_bluetooth_searching_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_brightness_auto 36x36, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_sharp_36_device_brightness_auto_data[] PROGMEM = {
  0x77, 0x20, 0x07, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x76, 0x07,
  0xE0, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB,
  0x73, 0xFF, 0xFB, 0x73, 0xFB, 0x82, 0xA7, 0x7A, 0xFB, 0x73, 0xFB, 0x02, 0x20, 0x2F, 0xB7, 0x3F,
  0xA0, 0xC4, 0x0C, 0xFA, 0x72, 0x07, 0xFA, 0x06, 0x40, 0x6F, 0xA0, 0x77, 0x07, 0xFB, 0x84, 0x10,
  0x44, 0x01, 0xFB, 0x07, 0x50, 0x7F, 0xB0, 0xB2, 0x00, 0x92, 0x0B, 0xFB, 0x07, 0x30, 0x7F, 0xC0,
  0x52, 0x00, 0xE2, 0x05, 0xFC, 0x81, 0x70, 0x7F, 0xC0, 0xE2, 0x04, 0xA0, 0x42, 0x0E, 0xFC, 0x00,
  0x7F, 0xC0, 0xA2, 0x08, 0xA0, 0x82, 0x0A, 0xFC, 0x81, 0x70, 0x7F, 0xB0, 0x47, 0x10, 0x4F, 0xB0,
  0x73, 0x07, 0xF9, 0x0E, 0x73, 0x0E, 0xF9, 0x07, 0x50, 0x7F, 0x09, 0x20, 0x8C, 0x08, 0x20, 0x9F,
  0x07, 0x70, 0x7E, 0x03, 0x20, 0xEC, 0x0E, 0x20, 0x3E, 0x07, 0x72, 0xD0, 0xD2, 0x04, 0xE0, 0x42,
  0x0D, 0xD7, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF,
  0xB7, 0x3F, 0xFF, 0xB7, 0x73, 0x07, 0xF9, 0x07, 0x77, 0x74, 0x07, 0xE0, 0x77, 0x77, 0x60, 0x7C,
  0x07, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x77, 0x30, 0x07, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_brightness_auto() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_brightness_auto_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_brightness_high 36x36, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_sharp_36_device_brightness_high_data[] PROGMEM = {
  0x77, 0x20, 0x07, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x76, 0x07,
  0xE0, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB,
  0x73, 0xF9, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF, 0x97, 0x3E, 0x0D, 0x03, 0x71, 0x03, 0x0D, 0xE7,
  0x3D, 0x0B, 0x01, 0x73, 0x01, 0x0B, 0xD7, 0x3C, 0x0D, 0x01, 0x38, 0x46, 0xCE, 0xEC, 0x63, 0x01,
  0x0D, 0xC7, 0x20, 0x7C, 0x03, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x20, 0x3C, 0x07, 0x70, 0x7C, 0x0B,
  0x30, 0xCF, 0x90, 0xC3, 0x0B, 0xC0, 0x75, 0x07, 0xD0, 0x62, 0x06, 0xFB, 0x06, 0x20, 0x6D, 0x07,
  0x30, 0x7E, 0x02, 0x20, 0xCF, 0xB0, 0xC2, 0x02, 0xE8, 0x17, 0x07, 0xF3, 0x0E, 0xFB, 0x0E, 0x3F,
  0x00, 0x7F, 0x30, 0xEF, 0xB0, 0xE3, 0xF8, 0x17, 0x07, 0xE0, 0x22, 0x0C, 0xFB, 0x0C, 0x20, 0x2E,
  0x07, 0x30, 0x7D, 0x06, 0x20, 0x6F, 0xB0, 0x62, 0x06, 0xD0, 0x75, 0x07, 0xC0, 0xB3, 0x0C, 0xF9,
  0x0C, 0x30, 0xBC, 0x07, 0x70, 0x7C, 0x03, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x20, 0x3C, 0x07, 0x72,
  0xC0, 0xD0, 0x13, 0x84, 0x6C, 0xEE, 0xC6, 0x30, 0x10, 0xDC, 0x73, 0xD0, 0xB0, 0x17, 0x30, 0x10,
  0xBD, 0x73, 0xE0, 0xD0, 0x37, 0x10, 0x30, 0xDE, 0x73, 0xF9, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF,
  0x97, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x73, 0x07, 0xF9, 0x07, 0x77, 0x74,
  0x07, 0xE0, 0x77, 0x77, 0x60, 0x7C, 0x07, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x77, 0x30, 0x07,
  0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_brightness_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_brightness_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_brightness_low 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_sharp_36_device_brightness_low_data[] PROGMEM = {
  0x77, 0x20, 0x07, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x76, 0x07,
  0xE0, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB,
  0x73, 0xF9, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF, 0x97, 0x3E, 0x0D, 0x03, 0x71, 0x03, 0x0D, 0xE7,
  0x3D, 0x0B, 0x01, 0x73, 0x01, 0x0B, 0xD7, 0x3C, 0x0D, 0x01, 0x75, 0x01, 0x0D, 0xC7, 0x20, 0x7C,
  0x03, 0x77, 0x03, 0xC0, 0x77, 0x07, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x75, 0x07, 0xD0, 0x67, 0x72,
  0x06, 0xD0, 0x73, 0x07, 0xE0, 0x27, 0x72, 0x02, 0xE8, 0x17, 0x07, 0xF7, 0x74, 0xF0, 0x07, 0xF7,
  0x74, 0xF8, 0x17, 0x07, 0xE0, 0x27, 0x72, 0x02, 0xE0, 0x73, 0x07, 0xD0, 0x67, 0x72, 0x06, 0xD0,
  0x75, 0x07, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x77, 0x07, 0xC0, 0x37, 0x70, 0x3C, 0x07, 0x72, 0xC0,
  0xD0, 0x17, 0x50, 0x10, 0xDC, 0x73, 0xD0, 0xB0, 0x17, 0x30, 0x10, 0xBD, 0x73, 0xE0, 0xD0, 0x37,
  0x10, 0x30, 0xDE, 0x73, 0xF9, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF, 0x97, 0x3F, 0xFF, 0xB7, 0x3F,
  0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x73, 0x07, 0xF9, 0x07, 0x77, 0x74, 0x07, 0xE0, 0x77, 0x77, 0x60,
  0x7C, 0x07, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x77, 0x30, 0x07, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_brightness_low() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_brightness_low_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_brightness_medium 36x36, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_sharp_36_device_brightness_medium_data[] PROGMEM = {
  0x77, 0x20, 0x07, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x76, 0x07,
  0xE0, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB,
  0x73, 0xFD, 0x18, 0x12, 0x6B, 0xF9, 0x73, 0xFD, 0x40, 0x30, 0xDE, 0x73, 0xFD, 0x50, 0x10, 0xBD,
  0x73, 0xFD, 0x60, 0x10, 0xDC, 0x72, 0x07, 0xFD, 0x70, 0x3C, 0x07, 0x70, 0x7F, 0xE7, 0x10, 0xBC,
  0x07, 0x50, 0x7F, 0xF7, 0x10, 0x6D, 0x07, 0x30, 0x7F, 0xF9, 0x71, 0x02, 0xE8, 0x17, 0x07, 0xFF,
  0xA7, 0x2F, 0x00, 0x7F, 0xFA, 0x72, 0xF8, 0x17, 0x07, 0xFF, 0x97, 0x10, 0x2E, 0x07, 0x30, 0x7F,
  0xF7, 0x10, 0x6D, 0x07, 0x50, 0x7F, 0xE7, 0x10, 0xBC, 0x07, 0x70, 0x7F, 0xD7, 0x03, 0xC0, 0x77,
  0x2F, 0xD6, 0x01, 0x0D, 0xC7, 0x3F, 0xD5, 0x01, 0x0B, 0xD7, 0x3F, 0xD4, 0x03, 0x0D, 0xE7, 0x3F,
  0xD1, 0x81, 0x26, 0xBF, 0x97, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x3F, 0xFF, 0xB7, 0x73, 0x07,
  0xF9, 0x07, 0x77, 0x74, 0x07, 0xE0, 0x77, 0x77, 0x60, 0x7C, 0x07, 0x77, 0x77, 0x10, 0x7A, 0x07,
  0x77, 0x77, 0x30, 0x07, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_brightness_medium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_brightness_medium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_cable 36x36, 4-bit Alpha,  RLE, 245 bytes.
static const unsigned char ic_sharp_36_device_cable_data[] PROGMEM = {
  0x30, 0x38, 0x07, 0x70, 0x34, 0x80, 0x27, 0x50, 0x7F, 0xC0, 0x74, 0xE5, 0x07, 0xFC, 0x07, 0x4E,
  0x50, 0x7A, 0x0B, 0x80, 0x17, 0x0B, 0xA0, 0x72, 0x03, 0x07, 0xE0, 0x70, 0x33, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x72, 0x07, 0xF9, 0x07, 0x30, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x73,
  0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xF9, 0x07, 0x30, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x20,
  0x7F, 0x90, 0x73, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xF9, 0x07, 0x30, 0x7A, 0x07, 0x50,
  0x7A, 0x07, 0x20, 0x7F, 0x90, 0x73, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xF9, 0x07, 0x30,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x60, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A,
  0x07, 0x60, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x60, 0x7A, 0x07, 0x50, 0x7A, 0x07,
  0x50, 0x7A, 0x07, 0x60, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x60, 0x7A, 0x07, 0x50,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x73, 0x07,
  0xF9, 0x07, 0x20, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x75, 0x07,
  0xA0, 0x73, 0x07, 0xF9, 0x07, 0x20, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x7F, 0x90, 0x72, 0x07,
  0xA0, 0x75, 0x07, 0xA0, 0x73, 0x07, 0xF9, 0x07, 0x20, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x7F,
  0x90, 0x72, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x73, 0x03, 0x07, 0xE0, 0x70, 0x32, 0x07, 0xA0, 0xB8,
  0x01, 0x70, 0xBA, 0x07, 0x5E, 0x40, 0x7F, 0xC0, 0x75, 0xE4, 0x07, 0xFC, 0x07, 0x58, 0x02, 0x74,
  0x03, 0x80, 0x77, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_cable() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_cable_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_cameraswitch 36x36, 4-bit Alpha,  RLE, 250 bytes.
static const unsigned char ic_sharp_36_device_cameraswitch_data[] PROGMEM = {
  0x76, 0x82, 0x69, 0xCE, 0xA8, 0x3D, 0xC9, 0x61, 0x77, 0x74, 0x06, 0xFB, 0x0B, 0x05, 0x77, 0x73,
  0x06, 0xFC, 0x0D, 0x04, 0x77, 0x72, 0x06, 0xB8, 0x29, 0x36, 0xAD, 0x09, 0x77, 0x72, 0x06, 0xA0,
  0x83, 0x81, 0x17, 0xEB, 0x0D, 0x01, 0x77, 0x71, 0x81, 0x6F, 0x85, 0x01, 0x09, 0xB0, 0xD0, 0x27,
  0x77, 0x10, 0x60, 0x87, 0x05, 0xB0, 0xD0, 0x17, 0x77, 0x10, 0x17, 0x10, 0x4B, 0x0A, 0x77, 0x77,
  0x40, 0x5B, 0x05, 0x77, 0x20, 0x7E, 0x07, 0x71, 0x09, 0xA0, 0xD7, 0x48, 0x00, 0x70, 0x9F, 0x90,
  0x98, 0x00, 0x73, 0x01, 0x0E, 0xA0, 0x67, 0x3F, 0xFC, 0x40, 0x6A, 0x0D, 0x73, 0xFF, 0xC5, 0x0E,
  0xA0, 0x37, 0x2F, 0xFC, 0x50, 0x9A, 0x07, 0x72, 0xFF, 0xC5, 0x05, 0xA0, 0xB7, 0x2F, 0x82, 0x71,
  0x17, 0xF5, 0x02, 0xA0, 0xD7, 0x2E, 0x07, 0x40, 0x7E, 0x60, 0xF7, 0x72, 0xE0, 0x14, 0x01, 0xE7,
  0x74, 0xE0, 0x14, 0x01, 0xE7, 0x20, 0xF7, 0x6E, 0x07, 0x40, 0x7E, 0x72, 0x0D, 0xA0, 0x25, 0xF8,
  0x27, 0x11, 0x7F, 0x72, 0x0B, 0xA0, 0x55, 0xFF, 0xC7, 0x20, 0x7A, 0x09, 0x5F, 0xFC, 0x72, 0x03,
  0xA0, 0xE5, 0xFF, 0xC7, 0x30, 0xDA, 0x06, 0x4F, 0xFC, 0x73, 0x06, 0xA0, 0xE0, 0x13, 0x80, 0x96,
  0x77, 0x40, 0xDA, 0x09, 0x77, 0x77, 0x40, 0x5B, 0x05, 0x77, 0x77, 0x40, 0xAB, 0x04, 0x71, 0x01,
  0x77, 0x71, 0x01, 0x0D, 0xB0, 0x57, 0x08, 0x06, 0x77, 0x71, 0x02, 0x0D, 0xB0, 0x90, 0x15, 0x81,
  0x8F, 0x67, 0x77, 0x10, 0x10, 0xDB, 0x81, 0xE7, 0x13, 0x08, 0xA0, 0x67, 0x77, 0x20, 0x9D, 0x82,
  0xA6, 0x39, 0xB0, 0x67, 0x77, 0x20, 0x40, 0xDF, 0xC0, 0x67, 0x77, 0x30, 0x50, 0xBF, 0xB0, 0x67,
  0x77, 0x48, 0x31, 0x69, 0xCD, 0xA8, 0x2E, 0xC9, 0x67, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_cameraswitch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 35, 35), Box(0, 0, 35, 35),
      ic_sharp_36_device_cameraswitch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_credit_score 36x36, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_sharp_36_device_credit_score_data[] PROGMEM = {
  0x80, 0x9B, 0x1F, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0x80, 0xAE, 0x6F, 0x77, 0x76, 0xB7,
  0x77, 0x6B, 0x77, 0x73, 0x05, 0x02, 0x1B, 0x77, 0x72, 0x82, 0x5F, 0xE2, 0xB7, 0x77, 0x10, 0x5B,
  0x0B, 0xB7, 0x77, 0x05, 0xB0, 0xC0, 0x1B, 0x75, 0x02, 0x70, 0x5B, 0x0C, 0x01, 0x1B, 0x74, 0x81,
  0xCE, 0x35, 0x05, 0xB0, 0xC0, 0x12, 0xB7, 0x30, 0xAA, 0x0E, 0x03, 0x30, 0x5B, 0x0C, 0x01, 0x3F,
  0xB0, 0x72, 0x02, 0x0E, 0xA8, 0x2E, 0x30, 0x5B, 0x0C, 0x01, 0x4F, 0xB0, 0x73, 0x02, 0x0E, 0xA0,
  0xE0, 0x7B, 0x0C, 0x01, 0x5F, 0xB0, 0x74, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77, 0x10, 0x20, 0xEB,
  0x0C, 0x01, 0x77, 0x73, 0x83, 0x2E, 0xFC, 0x17, 0x77, 0x58, 0x12, 0xB1, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_credit_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_credit_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_dark_mode 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_sharp_36_device_dark_mode_data[] PROGMEM = {
  0x74, 0x83, 0x35, 0x77, 0x57, 0x76, 0x81, 0x4A, 0xEB, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xBE, 0x03,
  0x77, 0x40, 0x6F, 0x09, 0x77, 0x40, 0x8F, 0x90, 0x27, 0x73, 0x06, 0xF9, 0x0D, 0x77, 0x30, 0x3F,
  0xA0, 0xB7, 0x73, 0x0B, 0xFA, 0x0A, 0x77, 0x20, 0x4F, 0xB0, 0xC7, 0x72, 0x0A, 0xFB, 0x0E, 0x77,
  0x20, 0xEF, 0xC0, 0x57, 0x70, 0x3F, 0xD0, 0xD7, 0x70, 0x5F, 0xE0, 0x97, 0x48, 0x13, 0x56, 0xFF,
  0x09, 0x72, 0x82, 0x3E, 0x76, 0xFF, 0x90, 0xD0, 0x55, 0x02, 0x09, 0xA0, 0x60, 0x5F, 0xFB, 0x83,
  0xEB, 0xAB, 0xDC, 0x05, 0x03, 0xFF, 0xFD, 0x81, 0x30, 0xEF, 0xFF, 0xB0, 0xE2, 0x0A, 0xFF, 0xFB,
  0x0A, 0x20, 0x4F, 0xFF, 0xB0, 0x43, 0x0B, 0xFF, 0xF9, 0x0B, 0x40, 0x3F, 0xFF, 0x90, 0x35, 0x06,
  0xFF, 0xE0, 0x67, 0x08, 0xFF, 0xC0, 0x87, 0x20, 0x6F, 0xFA, 0x06, 0x74, 0x03, 0x0B, 0xFD, 0x0B,
  0x03, 0x77, 0x81, 0x4A, 0xEE, 0x81, 0xEA, 0x47, 0x75, 0x84, 0x35, 0x77, 0x53, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_dark_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_dark_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_data_saver_off 36x36, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_sharp_36_device_data_saver_off_data[] PROGMEM = {
  0x73, 0x82, 0x48, 0xB6, 0x28, 0x26, 0xB8, 0x47, 0x74, 0x07, 0x0D, 0xB0, 0x72, 0x07, 0xB0, 0xD0,
  0x77, 0x70, 0x40, 0xDD, 0x07, 0x20, 0x7D, 0x0D, 0x04, 0x74, 0x08, 0xF0, 0x72, 0x07, 0xF0, 0x87,
  0x20, 0x9F, 0x0D, 0x05, 0x20, 0x50, 0xDF, 0x09, 0x70, 0x8D, 0x81, 0xE8, 0x26, 0x81, 0x28, 0xED,
  0x08, 0x50, 0x4D, 0x0C, 0x02, 0x73, 0x02, 0x0C, 0xD0, 0x44, 0x0E, 0xC0, 0xA7, 0x70, 0xAC, 0x0E,
  0x30, 0x7C, 0x0C, 0x77, 0x20, 0xCC, 0x07, 0x20, 0xEB, 0x0E, 0x01, 0x77, 0x20, 0x10, 0xEB, 0x81,
  0xE0, 0x3C, 0x08, 0x77, 0x40, 0x8C, 0x03, 0x08, 0xC0, 0x17, 0x74, 0x01, 0xC0, 0x80, 0xBB, 0x0C,
  0x77, 0x60, 0xCB, 0x0B, 0x0D, 0xB0, 0x97, 0x76, 0x09, 0xB0, 0xD0, 0xEB, 0x08, 0x77, 0x60, 0x8B,
  0x00, 0xEB, 0x08, 0x77, 0x60, 0x8C, 0x0D, 0xB0, 0xA7, 0x76, 0x09, 0xB0, 0xE0, 0xBB, 0x0C, 0x77,
  0x60, 0xDB, 0x0B, 0x08, 0xC0, 0x27, 0x74, 0x01, 0xC0, 0x80, 0x3C, 0x08, 0x77, 0x50, 0x30, 0xCA,
  0x81, 0x40, 0xEC, 0x01, 0x77, 0x60, 0x60, 0xC2, 0x07, 0xC0, 0xC7, 0x72, 0x03, 0x71, 0x0D, 0xC0,
  0xA7, 0x78, 0x2B, 0xFA, 0x16, 0x05, 0xD0, 0xC0, 0x17, 0x30, 0x20, 0xBB, 0x0E, 0x07, 0x60, 0x8E,
  0x08, 0x02, 0x60, 0x20, 0x8E, 0x08, 0x70, 0xAF, 0x84, 0xD9, 0x88, 0xAC, 0xF0, 0x97, 0x20, 0x8F,
  0xFC, 0x08, 0x74, 0x05, 0x0D, 0xFF, 0x0D, 0x05, 0x77, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x48,
  0x90, 0x38, 0xBD, 0xEF, 0xDB, 0x84, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_data_saver_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_data_saver_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_data_saver_on 36x36, 4-bit Alpha,  RLE, 247 bytes.
static const unsigned char ic_sharp_36_device_data_saver_on_data[] PROGMEM = {
  0x73, 0x82, 0x48, 0xB6, 0x28, 0x26, 0xB8, 0x47, 0x74, 0x07, 0x0D, 0xB0, 0x72, 0x07, 0xB0, 0xD0,
  0x77, 0x70, 0x40, 0xDD, 0x07, 0x20, 0x7D, 0x0D, 0x04, 0x74, 0x08, 0xF0, 0x72, 0x07, 0xF0, 0x87,
  0x20, 0x9F, 0x0D, 0x05, 0x20, 0x50, 0xDF, 0x09, 0x70, 0x8D, 0x81, 0xE8, 0x26, 0x81, 0x28, 0xED,
  0x08, 0x50, 0x4D, 0x0C, 0x02, 0x73, 0x02, 0x0C, 0xD0, 0x44, 0x0E, 0xC0, 0xA7, 0x70, 0xAC, 0x0E,
  0x30, 0x7C, 0x0C, 0x77, 0x20, 0xCC, 0x07, 0x20, 0xEB, 0x0E, 0x01, 0x60, 0x7A, 0x07, 0x60, 0x10,
  0xEB, 0x81, 0xE0, 0x3C, 0x08, 0x70, 0x7A, 0x07, 0x70, 0x8C, 0x03, 0x08, 0xC0, 0x17, 0x07, 0xA0,
  0x77, 0x01, 0xC0, 0x80, 0xBB, 0x0C, 0x71, 0x07, 0xA0, 0x77, 0x10, 0xCB, 0x0B, 0x0D, 0xB0, 0x94,
  0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x00, 0x74, 0x09, 0xB0, 0xD0, 0xEB, 0x08, 0x4F, 0xD4, 0x08, 0xB0,
  0x0E, 0xB0, 0x84, 0xFD, 0x40, 0x8C, 0x0D, 0xB0, 0xA4, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x00, 0x74,
  0x09, 0xB0, 0xE0, 0xBB, 0x0C, 0x71, 0x07, 0xA0, 0x77, 0x10, 0xDB, 0x0B, 0x08, 0xC0, 0x27, 0x07,
  0xA0, 0x77, 0x01, 0xC0, 0x80, 0x3C, 0x08, 0x70, 0x7A, 0x07, 0x71, 0x03, 0x0C, 0xA8, 0x14, 0x0E,
  0xC0, 0x16, 0x07, 0xA0, 0x77, 0x30, 0x60, 0xC2, 0x07, 0xC0, 0xC7, 0x72, 0x03, 0x71, 0x0D, 0xC0,
  0xA7, 0x78, 0x2B, 0xFA, 0x16, 0x05, 0xD0, 0xC0, 0x17, 0x30, 0x20, 0xBB, 0x0E, 0x07, 0x60, 0x8E,
  0x08, 0x02, 0x60, 0x20, 0x8E, 0x08, 0x70, 0xAF, 0x84, 0xD9, 0x88, 0xAC, 0xF0, 0x97, 0x20, 0x8F,
  0xFC, 0x08, 0x74, 0x05, 0x0D, 0xFF, 0x0D, 0x05, 0x77, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x48,
  0x90, 0x38, 0xBD, 0xEF, 0xDB, 0x84, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_data_saver_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_data_saver_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_dataset_linked 36x36, 4-bit Alpha,  RLE, 233 bytes.
static const unsigned char ic_sharp_36_device_dataset_linked_data[] PROGMEM = {
  0x03, 0x80, 0xA6, 0x70, 0x34, 0x07, 0xFF, 0xFD, 0x07, 0x40, 0x7F, 0xFF, 0xD0, 0x74, 0x07, 0xFF,
  0xFD, 0x07, 0x40, 0x7F, 0xFF, 0xD0, 0x74, 0x07, 0xFF, 0xFD, 0x07, 0x40, 0x7D, 0x0B, 0x80, 0x17,
  0x0B, 0xA0, 0xB8, 0x01, 0x70, 0xBD, 0x07, 0x40, 0x7D, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7D, 0x07,
  0x40, 0x7D, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7D, 0x07, 0x40, 0x7D, 0x07, 0x50, 0x7A, 0x07, 0x50,
  0x7D, 0x07, 0x40, 0x7D, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7D, 0x07, 0x40, 0x7D, 0x07, 0x50, 0x7A,
  0x07, 0x50, 0x7D, 0x07, 0x40, 0x7D, 0x0B, 0x80, 0x17, 0x0B, 0xA0, 0xB8, 0x01, 0x70, 0xBD, 0x07,
  0x40, 0x7F, 0xFF, 0xD0, 0x74, 0x07, 0xFD, 0x81, 0xB5, 0x27, 0x40, 0x14, 0x07, 0xD0, 0xB8, 0x01,
  0x70, 0x37, 0x75, 0x07, 0xD0, 0x77, 0x77, 0x40, 0x7D, 0x07, 0x78, 0x16, 0xCE, 0xB3, 0xB8, 0x1E,
  0xC6, 0x30, 0x7D, 0x07, 0x50, 0x10, 0xCE, 0x3E, 0x82, 0xC1, 0x07, 0xD0, 0x75, 0x0C, 0xF3, 0xF8,
  0x1C, 0x07, 0xD0, 0x74, 0x06, 0xB0, 0x70, 0x17, 0x20, 0x10, 0x7B, 0x06, 0x07, 0xD0, 0xB0, 0x73,
  0x0C, 0xA0, 0x72, 0x80, 0x57, 0x20, 0x7A, 0x0C, 0x07, 0xF3, 0x0E, 0xA0, 0x12, 0xFA, 0x20, 0x1A,
  0x0E, 0x07, 0xF3, 0x0E, 0xA0, 0x12, 0xFA, 0x20, 0x1A, 0x0E, 0x07, 0xF0, 0x22, 0x0C, 0xA0, 0x72,
  0x80, 0x57, 0x20, 0x7A, 0x0C, 0x07, 0xF0, 0x52, 0x06, 0xB0, 0x70, 0x17, 0x20, 0x10, 0x7B, 0x06,
  0x07, 0xF0, 0xB3, 0x0C, 0xF3, 0xF8, 0x1C, 0x03, 0x80, 0x47, 0x30, 0x10, 0xCE, 0x3E, 0x0C, 0x01,
  0x77, 0x18, 0x16, 0xCE, 0xB3, 0xB8, 0x1E, 0xC6, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_dataset_linked() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 35, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_dataset_linked_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_dataset 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_sharp_36_device_dataset_data[] PROGMEM = {
  0x03, 0x80, 0xA6, 0x70, 0x30, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xD0, 0xB8, 0x01, 0x70, 0xBA, 0x0B, 0x80, 0x17, 0x0B,
  0xD0, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x75, 0x07,
  0xD0, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x75, 0x07,
  0xD0, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0xB8, 0x01, 0x70, 0xBA, 0x0B,
  0x80, 0x17, 0x0B, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xD0, 0xB8, 0x01, 0x70,
  0xBA, 0x0B, 0x80, 0x17, 0x0B, 0xD0, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xD0,
  0x75, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xD0,
  0x75, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xD0,
  0xB8, 0x01, 0x70, 0xBA, 0x0B, 0x80, 0x17, 0x0B, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x03, 0x80, 0xA6, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_dataset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_dataset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_data_usage 36x36, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_sharp_36_device_data_usage_data[] PROGMEM = {
  0x73, 0x82, 0x48, 0xB6, 0x28, 0x26, 0xB8, 0x47, 0x74, 0x07, 0x0D, 0xB0, 0x72, 0x07, 0xB0, 0xD0,
  0x77, 0x70, 0x40, 0xDD, 0x07, 0x20, 0x7D, 0x0D, 0x04, 0x74, 0x08, 0xF0, 0x72, 0x07, 0xF0, 0x87,
  0x20, 0x9F, 0x0D, 0x05, 0x20, 0x50, 0xDF, 0x09, 0x70, 0x8D, 0x81, 0xE8, 0x26, 0x81, 0x28, 0xED,
  0x08, 0x50, 0x4D, 0x0C, 0x02, 0x73, 0x02, 0x0C, 0xD0, 0x44, 0x0E, 0xC0, 0xA7, 0x70, 0xAC, 0x0E,
  0x30, 0x7C, 0x0C, 0x77, 0x20, 0xCC, 0x07, 0x20, 0xEB, 0x0E, 0x01, 0x77, 0x20, 0x10, 0xEB, 0x81,
  0xE0, 0x3C, 0x08, 0x77, 0x40, 0x8C, 0x03, 0x08, 0xC0, 0x17, 0x74, 0x01, 0xC0, 0x80, 0xBB, 0x0C,
  0x77, 0x60, 0xCB, 0x0B, 0x0D, 0xB0, 0x97, 0x76, 0x09, 0xB0, 0xD0, 0xEB, 0x08, 0x77, 0x60, 0x8B,
  0x00, 0xEB, 0x08, 0x77, 0x60, 0x8C, 0x0D, 0xB0, 0xA7, 0x76, 0x09, 0xB0, 0xE0, 0xBB, 0x0C, 0x77,
  0x60, 0xDB, 0x0B, 0x08, 0xC0, 0x27, 0x74, 0x01, 0xC0, 0x80, 0x3C, 0x08, 0x77, 0x50, 0x30, 0xCA,
  0x81, 0x40, 0xEC, 0x01, 0x77, 0x60, 0x60, 0xC2, 0x07, 0xC0, 0xC7, 0x72, 0x03, 0x71, 0x0D, 0xC0,
  0xA7, 0x78, 0x2B, 0xFA, 0x16, 0x05, 0xD0, 0xC0, 0x17, 0x30, 0x20, 0xBB, 0x0E, 0x07, 0x60, 0x8E,
  0x08, 0x02, 0x60, 0x20, 0x8E, 0x08, 0x70, 0xAF, 0x84, 0xD9, 0x88, 0xAC, 0xF0, 0x97, 0x20, 0x8F,
  0xFC, 0x08, 0x74, 0x05, 0x0D, 0xFF, 0x0D, 0x05, 0x77, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x48,
  0x90, 0x38, 0xBD, 0xEF, 0xDB, 0x84, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_data_usage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_data_usage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_developer_mode 36x36, 4-bit Alpha,  RLE, 196 bytes.
static const unsigned char ic_sharp_36_device_developer_mode_data[] PROGMEM = {
  0x10, 0x38, 0x0A, 0x07, 0x03, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE,
  0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7A, 0x0B, 0x80, 0x92, 0x70, 0xBA,
  0x07, 0x20, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x28, 0x23,
  0x77, 0x37, 0x78, 0x23, 0x77, 0x37, 0x07, 0x04, 0x71, 0x04, 0x07, 0x74, 0x07, 0xA0, 0x46, 0x04,
  0xA0, 0x77, 0x20, 0x7B, 0x0A, 0x60, 0xAB, 0x07, 0x70, 0x7B, 0x0B, 0x71, 0x0B, 0xB0, 0x75, 0x07,
  0xB0, 0xB7, 0x30, 0xBB, 0x07, 0x30, 0x7B, 0x0B, 0x75, 0x0B, 0xB8, 0x17, 0x07, 0xB0, 0xB7, 0x70,
  0xBB, 0x00, 0x7B, 0x0B, 0x77, 0x0B, 0xB8, 0x17, 0x07, 0xB0, 0xB7, 0x50, 0xBB, 0x07, 0x30, 0x7B,
  0x0B, 0x73, 0x0B, 0xB0, 0x75, 0x07, 0xB0, 0xB7, 0x10, 0xBB, 0x07, 0x70, 0x7B, 0x0A, 0x60, 0xAB,
  0x07, 0x72, 0x07, 0xA0, 0x46, 0x04, 0xA0, 0x77, 0x40, 0x70, 0x47, 0x10, 0x40, 0x77, 0x82, 0x37,
  0x73, 0x77, 0x82, 0x37, 0x73, 0x20, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x07, 0x20, 0x7A, 0x0B, 0x80, 0x92, 0x70, 0xBA, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F,
  0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x38,
  0x0A, 0x07, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_developer_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 29, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_developer_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_devices_fold 36x36, 4-bit Alpha,  RLE, 156 bytes.
static const unsigned char ic_sharp_36_device_devices_fold_data[] PROGMEM = {
  0x77, 0x68, 0x12, 0x97, 0x77, 0x74, 0x05, 0x0B, 0xA0, 0x77, 0x77, 0x18, 0x11, 0x7D, 0xC0, 0x77,
  0x76, 0x02, 0x09, 0xF0, 0x77, 0x0F, 0x73, 0x0F, 0x73, 0x0B, 0xFA, 0x0B, 0x80, 0x37, 0xB3, 0xB3,
  0xFF, 0xF3, 0xB3, 0xFF, 0xC0, 0xF7, 0x30, 0xF7, 0x3F, 0xB0, 0xB8, 0x00, 0x7B, 0x75, 0xFB, 0x07,
  0x4B, 0x75, 0xFB, 0x07, 0x4B, 0x0F, 0x77, 0x2F, 0xB0, 0x74, 0xE7, 0x2F, 0xB0, 0x74, 0xE7, 0x2F,
  0xB0, 0x74, 0xB0, 0xF7, 0x72, 0xFB, 0x07, 0x4B, 0x75, 0xFB, 0x07, 0x4B, 0x75, 0xFB, 0x07, 0x4B,
  0x0F, 0x77, 0x2F, 0xB0, 0x74, 0xE7, 0x2F, 0xB0, 0x74, 0xE7, 0x2F, 0xB0, 0x74, 0xB0, 0xF7, 0x72,
  0xFB, 0x07, 0x4B, 0x75, 0xFB, 0x07, 0x4B, 0x75, 0xFB, 0x07, 0x4B, 0x0F, 0x77, 0x2F, 0xB0, 0x74,
  0xE7, 0x2F, 0xB0, 0x74, 0xE7, 0x2F, 0xB0, 0x74, 0xB0, 0xF7, 0x72, 0xFB, 0x07, 0x4B, 0x75, 0xFB,
  0x07, 0x4B, 0x75, 0xF9, 0x0D, 0x06, 0x5B, 0x0F, 0x73, 0x0F, 0x73, 0xF0, 0xC8, 0x03, 0x7E, 0x3B,
  0x3F, 0xFF, 0x3B, 0x3F, 0xFC, 0x0F, 0x73, 0x0F, 0x73, 0x80, 0x96, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_devices_fold() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 32, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_devices_fold_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_devices 36x36, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_36_device_devices_data[] PROGMEM = {
  0x3F, 0xFF, 0xFA, 0x6F, 0xFF, 0xFA, 0x6F, 0xFF, 0xFA, 0x6B, 0x77, 0x77, 0x5B, 0x77, 0x77, 0x5B,
  0x77, 0x77, 0x5B, 0x77, 0x4F, 0xD3, 0xB7, 0x74, 0xFD, 0x3B, 0x77, 0x4F, 0xD3, 0xB7, 0x74, 0xB6,
  0xB3, 0xB7, 0x74, 0xB6, 0xB3, 0xB7, 0x74, 0xB6, 0xB3, 0xB7, 0x74, 0xB6, 0xB3, 0xB7, 0x74, 0xB6,
  0xB3, 0xB7, 0x74, 0xB6, 0xB3, 0xB7, 0x74, 0xB6, 0xB3, 0xB7, 0x74, 0xB6, 0xB3, 0xB7, 0x74, 0xB6,
  0xB3, 0xB7, 0x74, 0xB6, 0xB0, 0xF7, 0xB8, 0x09, 0x37, 0x3B, 0x80, 0x27, 0xFF, 0xFB, 0x3F, 0xFF,
  0xFD, 0x3F, 0xFF, 0xFD, 0x3F, 0xFF, 0xFD, 0x3F, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_devices() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_devices_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_device_thermostat 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_sharp_36_device_device_thermostat_data[] PROGMEM = {
  0x58, 0x42, 0xAD, 0xDA, 0x27, 0x20, 0x4E, 0x04, 0x71, 0x0E, 0xE0, 0xE7, 0x04, 0xA8, 0x2D, 0x22,
  0xDA, 0x04, 0x60, 0x7A, 0x08, 0x20, 0x8A, 0x07, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0x7A,
  0x07, 0x1C, 0x07, 0x60, 0x7A, 0x82, 0x70, 0x7B, 0xA0, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0x07, 0xA8, 0x27, 0x07, 0xBA, 0x07, 0x60, 0x7A, 0x07, 0x1C,
  0x07, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0x7A, 0x82, 0xB7, 0x7B, 0xA0, 0x76, 0x07, 0xF9,
  0x07, 0x60, 0x7F, 0x90, 0x76, 0x09, 0xF9, 0x09, 0x50, 0x8F, 0xB0, 0x83, 0x04, 0xFD, 0x04, 0x20,
  0xCF, 0xD8, 0x1C, 0x03, 0xFF, 0x03, 0x05, 0xFF, 0x05, 0x07, 0xFF, 0x07, 0x06, 0xFF, 0x06, 0x03,
  0xFF, 0x81, 0x30, 0xDF, 0xD0, 0xD2, 0x04, 0xFD, 0x04, 0x30, 0x8F, 0xB0, 0x85, 0x07, 0xF9, 0x07,
  0x78, 0x61, 0x8C, 0xEE, 0xC8, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_device_thermostat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_device_thermostat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_discount 36x36, 4-bit Alpha,  RLE, 259 bytes.
static const unsigned char ic_sharp_36_device_discount_data[] PROGMEM = {
  0x07, 0xFE, 0x08, 0x77, 0x07, 0xFF, 0x08, 0x76, 0x07, 0xFF, 0x90, 0x87, 0x50, 0x7F, 0xFA, 0x08,
  0x74, 0x07, 0xC8, 0x1E, 0x9A, 0xFB, 0x08, 0x73, 0x07, 0xC0, 0x42, 0x08, 0xFB, 0x08, 0x72, 0x07,
  0xC3, 0x04, 0xFC, 0x08, 0x71, 0x07, 0xC0, 0x72, 0x0A, 0xFD, 0x08, 0x70, 0x7D, 0x0C, 0x0D, 0xFF,
  0x08, 0x60, 0x7F, 0xFF, 0x90, 0x85, 0x07, 0xFF, 0xFA, 0x08, 0x40, 0x7F, 0xFF, 0xB0, 0x83, 0x07,
  0xFF, 0xFC, 0x08, 0x20, 0x6F, 0xFF, 0xD0, 0x82, 0x08, 0xFF, 0xFD, 0x07, 0x20, 0x8F, 0xFF, 0xB0,
  0xD0, 0x13, 0x08, 0xFF, 0xF9, 0x83, 0xD1, 0x07, 0x32, 0x08, 0xFF, 0xE0, 0xD0, 0x12, 0x81, 0x7E,
  0x32, 0x08, 0xFF, 0xC0, 0xD0, 0x13, 0x82, 0x7F, 0xE3, 0x20, 0x8F, 0xFA, 0x0D, 0x01, 0x40, 0x7A,
  0x0E, 0x03, 0x20, 0x8F, 0xF0, 0xD0, 0x12, 0x83, 0xA2, 0x02, 0xDA, 0x0E, 0x03, 0x20, 0x8F, 0xD0,
  0xD0, 0x12, 0x85, 0xBF, 0xD2, 0x02, 0xDA, 0x0E, 0x03, 0x20, 0x8F, 0xB0, 0xD0, 0x12, 0x0B, 0xB0,
  0x62, 0x02, 0x0D, 0xA0, 0xE0, 0x32, 0x08, 0xF9, 0x0D, 0x01, 0x20, 0xBB, 0x06, 0x40, 0x20, 0xDA,
  0x0E, 0x03, 0x20, 0x8E, 0x0D, 0x01, 0x20, 0xBB, 0x06, 0x60, 0x20, 0xDA, 0x0E, 0x03, 0x20, 0x8C,
  0x0D, 0x01, 0x20, 0xBB, 0x06, 0x71, 0x02, 0x0D, 0xA0, 0xE0, 0x32, 0x08, 0xA0, 0xD0, 0x12, 0x0B,
  0xB0, 0x67, 0x30, 0x20, 0xDA, 0x0E, 0x03, 0x28, 0x18, 0xD1, 0x20, 0xBB, 0x06, 0x75, 0x02, 0x0D,
  0xA0, 0xE0, 0x35, 0x0B, 0xB0, 0x67, 0x70, 0x20, 0xDA, 0x0E, 0x03, 0x30, 0xBB, 0x06, 0x77, 0x20,
  0x20, 0xDA, 0x82, 0xE3, 0x0B, 0xB0, 0x67, 0x74, 0x02, 0x0D, 0xA0, 0xE0, 0xCB, 0x06, 0x77, 0x60,
  0x20, 0xDD, 0x06, 0x77, 0x71, 0x02, 0x0D, 0xB0, 0x67, 0x77, 0x38, 0x22, 0xDF, 0x67, 0x77, 0x50,
  0x20, 0x67, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_discount() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 32, 35), Box(0, 0, 35, 35),
      ic_sharp_36_device_discount_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_do_not_disturb_on_total_silence 36x36, 4-bit Alpha,  RLE, 287 bytes.
static const unsigned char ic_sharp_36_device_do_not_disturb_on_total_silence_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x20,
  0xAB, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xB0, 0xA7, 0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x08, 0x50, 0x5B,
  0x08, 0x48, 0x63, 0x9D, 0xEE, 0xD9, 0x44, 0x08, 0xB0, 0x54, 0x0D, 0xA0, 0xA3, 0x02, 0x0B, 0xF9,
  0x0B, 0x02, 0x30, 0xAA, 0x0D, 0x30, 0x7A, 0x0D, 0x30, 0x30, 0xEF, 0xB0, 0xE0, 0x43, 0x0D, 0xA0,
  0x72, 0x0E, 0xA0, 0x62, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x20, 0x6A, 0x81, 0xE0, 0x3A, 0x0D, 0x30,
  0xBF, 0xF0, 0xB3, 0x0D, 0xA0, 0x30, 0x8A, 0x09, 0x20, 0x4F, 0xFA, 0x04, 0x20, 0x9A, 0x08, 0x0B,
  0xA0, 0x42, 0x09, 0xFF, 0xA0, 0x92, 0x04, 0xA0, 0xB0, 0xDA, 0x02, 0x20, 0xDB, 0x0B, 0x80, 0x47,
  0x0B, 0xB0, 0xD2, 0x02, 0xA0, 0xD0, 0xEA, 0x30, 0xEB, 0x07, 0x71, 0x07, 0xB0, 0xE3, 0xA0, 0x0E,
  0xA3, 0x0E, 0xB0, 0x77, 0x10, 0x7B, 0x0E, 0x3A, 0x0E, 0x0D, 0xA0, 0x22, 0x0D, 0xB0, 0xB8, 0x04,
  0x70, 0xBB, 0x0D, 0x20, 0x2A, 0x0D, 0x0B, 0xA0, 0x42, 0x09, 0xFF, 0xA0, 0x92, 0x04, 0xA0, 0xB0,
  0x8A, 0x09, 0x20, 0x4F, 0xFA, 0x04, 0x20, 0x9A, 0x08, 0x03, 0xA0, 0xD3, 0x0B, 0xFF, 0x0B, 0x30,
  0xDA, 0x81, 0x30, 0xEA, 0x06, 0x20, 0x20, 0xEF, 0xD0, 0xE0, 0x22, 0x06, 0xA0, 0xE2, 0x07, 0xA0,
  0xD3, 0x03, 0x0E, 0xFB, 0x0E, 0x03, 0x30, 0xDA, 0x07, 0x30, 0xDA, 0x0A, 0x30, 0x20, 0xBF, 0x90,
  0xB0, 0x23, 0x0A, 0xA0, 0xD4, 0x05, 0xB0, 0x84, 0x86, 0x39, 0xDE, 0xED, 0x93, 0x40, 0x8B, 0x05,
  0x50, 0x8B, 0x0A, 0x77, 0x0A, 0xB0, 0x87, 0x0A, 0xB0, 0xD0, 0x67, 0x30, 0x60, 0xDB, 0x0A, 0x72,
  0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57,
  0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_do_not_disturb_on_total_silence() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_do_not_disturb_on_total_silence_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_dvr 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_sharp_36_device_dvr_data[] PROGMEM = {
  0x03, 0x80, 0xB4, 0x70, 0x30, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7A, 0x0B, 0x80,
  0xA6, 0x70, 0xBA, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07,
  0x20, 0x7A, 0x07, 0x1F, 0xFA, 0x07, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x1F, 0xFA,
  0x07, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x1F, 0xFA, 0x07, 0x20, 0x7A, 0x00, 0x7A,
  0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75,
  0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x71, 0xFF, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x71, 0xFF, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x71, 0xFF, 0xA0,
  0x72, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0xB8,
  0x0A, 0x67, 0x0B, 0xA0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x70, 0x38, 0x06, 0x7F,
  0xD8, 0x06, 0x70, 0x37, 0x4F, 0xD7, 0x77, 0x1F, 0xD7, 0x77, 0x18, 0x09, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_edgesensor_high 36x36, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_sharp_36_device_edgesensor_high_data[] PROGMEM = {
  0x72, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x74,
  0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x68, 0x23, 0x77, 0x31, 0xB8, 0x09, 0x07, 0xB6, 0x0F, 0x74, 0x07,
  0xA0, 0x71, 0xB7, 0x5B, 0x6B, 0x40, 0x7A, 0x07, 0x1B, 0x75, 0xB6, 0xB4, 0x07, 0xA0, 0x71, 0xB7,
  0x5B, 0x6B, 0x40, 0x7A, 0x07, 0x1B, 0x75, 0xB6, 0xE1, 0x07, 0xA0, 0x71, 0xB7, 0x5B, 0x10, 0x7A,
  0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x75, 0xB1, 0x07, 0xA0, 0x71, 0xE1, 0x07, 0xA0, 0x71, 0xB7,
  0x5B, 0x10, 0x7A, 0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x75, 0xB1, 0x07, 0xA0, 0x71, 0xE1, 0x07,
  0xA0, 0x71, 0xB7, 0x5B, 0x10, 0x7A, 0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x75, 0xB1, 0x07, 0xA0,
  0x71, 0xE6, 0xB7, 0x5B, 0x10, 0x7A, 0x07, 0x4B, 0x6B, 0x75, 0xB1, 0x07, 0xA0, 0x74, 0xB6, 0xB7,
  0x5B, 0x10, 0x7A, 0x07, 0x4B, 0x6B, 0x75, 0xB1, 0x07, 0xA0, 0x74, 0x0F, 0x76, 0xB8, 0x09, 0x07,
  0xB1, 0x82, 0x37, 0x73, 0x76, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x74, 0xFF, 0xC7,
  0x74, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_edgesensor_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 35, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_edgesensor_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_edgesensor_low 36x36, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_sharp_36_device_edgesensor_low_data[] PROGMEM = {
  0x6F, 0xFC, 0x75, 0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0xFF, 0xC7, 0x5F,
  0xFC, 0x60, 0xF7, 0x3B, 0x80, 0x90, 0x7B, 0x6B, 0x3B, 0x75, 0xB6, 0xB3, 0xB7, 0x5B, 0x6B, 0x3B,
  0x75, 0xB6, 0xB3, 0xB7, 0x5B, 0x6B, 0x3B, 0x75, 0xB3, 0xE3, 0xB7, 0x5B, 0x3E, 0x3B, 0x75, 0xB3,
  0xE3, 0xB7, 0x5B, 0x3E, 0x3B, 0x75, 0xB3, 0xE3, 0xB7, 0x5B, 0x3B, 0x6B, 0x75, 0xB3, 0xB6, 0xB7,
  0x5B, 0x3B, 0x6B, 0x75, 0xB3, 0xB6, 0xB7, 0x5B, 0x3B, 0x6B, 0x80, 0x90, 0x7B, 0x30, 0xF7, 0x6F,
  0xFC, 0x75, 0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0xFF, 0xC7, 0x5F, 0xFC,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_edgesensor_low() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_edgesensor_low_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_e_mobiledata 36x36, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_sharp_36_device_e_mobiledata_data[] PROGMEM = {
  0x80, 0x90, 0x7F, 0xFF, 0xE8, 0x05, 0x7B, 0x72, 0xB7, 0x2B, 0x80, 0x57, 0xFF, 0xFE, 0x80, 0x57,
  0xB7, 0x2B, 0x72, 0xB8, 0x05, 0x7F, 0xFF, 0xB8, 0x09, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_e_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 10, 23, 25), Box(0, 0, 35, 35),
      ic_sharp_36_device_e_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_flashlight_off 36x36, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_sharp_36_device_flashlight_off_data[] PROGMEM = {
  0x7F, 0xFC, 0x60, 0x20, 0x74, 0xFF, 0xC5, 0x82, 0x2E, 0xF7, 0x30, 0x4F, 0xFB, 0x50, 0x9B, 0x07,
  0x30, 0x4F, 0xFA, 0x60, 0xBB, 0x07, 0x30, 0x38, 0x09, 0x37, 0x70, 0xBB, 0x07, 0x77, 0x75, 0x0B,
  0xB0, 0x77, 0x77, 0x50, 0xBB, 0x07, 0x48, 0x09, 0x07, 0x73, 0x0B, 0xB0, 0x73, 0x04, 0xFC, 0x74,
  0x0B, 0xB0, 0x73, 0x04, 0xFA, 0x0A, 0x75, 0x0B, 0xB0, 0x73, 0x04, 0xF0, 0xE0, 0x17, 0x60, 0xBB,
  0x07, 0x30, 0x4E, 0x05, 0x77, 0x10, 0xBB, 0x07, 0x30, 0x4C, 0x0A, 0x77, 0x3C, 0x07, 0x30, 0x4B,
  0x01, 0x77, 0x3D, 0x07, 0x30, 0x4A, 0x77, 0x4E, 0x07, 0x30, 0x49, 0x77, 0x4F, 0x07, 0x30, 0x47,
  0x74, 0xF9, 0x07, 0x77, 0x7F, 0xA0, 0x77, 0x76, 0xFB, 0x07, 0x77, 0x5F, 0xC0, 0x77, 0x74, 0xFD,
  0x07, 0x77, 0x3F, 0xE0, 0x77, 0x72, 0xFF, 0x07, 0x77, 0x1F, 0xF9, 0x07, 0x77, 0xFD, 0x0B, 0xB0,
  0x77, 0x6F, 0xD1, 0x0B, 0xB0, 0x77, 0x5F, 0xD2, 0x0B, 0xB0, 0x77, 0x4F, 0xD3, 0x0B, 0xB0, 0x67,
  0x3F, 0xD4, 0x82, 0xBF, 0xE2, 0x77, 0x76, 0x09, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_flashlight_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 31, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_flashlight_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_flashlight_on 36x36, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_sharp_36_device_flashlight_on_data[] PROGMEM = {
  0x80, 0x98, 0x4F, 0x80, 0x96, 0x78, 0x0C, 0x00, 0x80, 0x96, 0x7F, 0xFC, 0x0A, 0xFF, 0xA8, 0x1A,
  0x1E, 0xFF, 0x82, 0xE1, 0x05, 0xFF, 0x05, 0x30, 0xAF, 0xD0, 0xA4, 0x01, 0xFD, 0x01, 0x5F, 0xD6,
  0xD0, 0x0D, 0xD6, 0xC0, 0x62, 0x06, 0xC6, 0xB0, 0xD4, 0x0D, 0xB6, 0xB0, 0xD4, 0x0D, 0xB6, 0xC0,
  0x62, 0x06, 0xC6, 0xD0, 0x0D, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD,
  0x6F, 0xD6, 0xFD, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_flashlight_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 3, 26, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_flashlight_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_flourescent 36x36, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_sharp_36_device_flourescent_data[] PROGMEM = {
  0x74, 0x07, 0xA0, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x10, 0x7A,
  0x07, 0x75, 0x81, 0x4C, 0x17, 0x82, 0x37, 0x73, 0x78, 0x31, 0xC4, 0x04, 0xA0, 0xD0, 0x17, 0x72,
  0x84, 0x1D, 0xFE, 0x44, 0xB0, 0xC7, 0x72, 0x0C, 0xB8, 0x44, 0x04, 0xFE, 0x37, 0x72, 0x82, 0x3E,
  0xF4, 0x30, 0x40, 0x37, 0x74, 0x03, 0x04, 0x77, 0x77, 0x20, 0x38, 0x0A, 0x07, 0x03, 0x40, 0x7F,
  0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F,
  0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x38,
  0x0A, 0x07, 0x03, 0x77, 0x77, 0x20, 0x30, 0x27, 0x74, 0x01, 0x02, 0x38, 0x23, 0xED, 0x17, 0x72,
  0x85, 0x1D, 0xE2, 0x03, 0xEA, 0x0C, 0x77, 0x20, 0xCA, 0x81, 0xE2, 0x5A, 0x0E, 0x02, 0x77, 0x20,
  0x30, 0xEA, 0x83, 0x50, 0x6E, 0x27, 0x82, 0x37, 0x73, 0x78, 0x13, 0xE6, 0x75, 0x07, 0xA0, 0x77,
  0x10, 0x17, 0x60, 0x7A, 0x07, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_flourescent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 30, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_flourescent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_fluorescent 36x36, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_sharp_36_device_fluorescent_data[] PROGMEM = {
  0x74, 0x07, 0xA0, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x10, 0x7A,
  0x07, 0x75, 0x81, 0x4C, 0x17, 0x82, 0x37, 0x73, 0x78, 0x31, 0xC4, 0x04, 0xA0, 0xD0, 0x17, 0x72,
  0x84, 0x1D, 0xFE, 0x44, 0xB0, 0xC7, 0x72, 0x0C, 0xB8, 0x44, 0x04, 0xFE, 0x37, 0x72, 0x82, 0x3E,
  0xF4, 0x30, 0x40, 0x37, 0x74, 0x03, 0x04, 0x77, 0x77, 0x20, 0x38, 0x0A, 0x07, 0x03, 0x40, 0x7F,
  0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F,
  0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x7F, 0xFE, 0x07, 0x40, 0x38,
  0x0A, 0x07, 0x03, 0x77, 0x77, 0x20, 0x30, 0x27, 0x74, 0x01, 0x02, 0x38, 0x23, 0xED, 0x17, 0x72,
  0x85, 0x1D, 0xE2, 0x03, 0xEA, 0x0C, 0x77, 0x20, 0xCA, 0x81, 0xE2, 0x5A, 0x0E, 0x02, 0x77, 0x20,
  0x30, 0xEA, 0x83, 0x50, 0x6E, 0x27, 0x82, 0x37, 0x73, 0x78, 0x13, 0xE6, 0x75, 0x07, 0xA0, 0x77,
  0x10, 0x17, 0x60, 0x7A, 0x07, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_fluorescent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 30, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_fluorescent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_fmd_bad 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_sharp_36_device_fmd_bad_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x75, 0x02, 0x09, 0xFB, 0x09, 0x02, 0x72, 0x05, 0x0E,
  0xFD, 0x0E, 0x05, 0x70, 0x7F, 0xFA, 0x07, 0x50, 0x5F, 0xFC, 0x05, 0x30, 0x10, 0xEF, 0xFC, 0x0E,
  0x01, 0x20, 0x9F, 0x90, 0x72, 0x07, 0xF9, 0x81, 0x90, 0x1F, 0xA0, 0x72, 0x07, 0xFA, 0x01, 0x06,
  0xFA, 0x07, 0x20, 0x7F, 0xA0, 0x60, 0xAF, 0xA0, 0x72, 0x07, 0xFA, 0x0A, 0x0C, 0xFA, 0x07, 0x20,
  0x7F, 0xA0, 0xC0, 0xEF, 0xA0, 0x72, 0x07, 0xFA, 0x0E, 0xFB, 0x07, 0x20, 0x7F, 0xB0, 0xDF, 0xA8,
  0x2B, 0x77, 0xBF, 0xA0, 0xD0, 0xBF, 0xFF, 0x90, 0xB0, 0x6F, 0xFF, 0x90, 0x60, 0x1F, 0xA8, 0x2B,
  0x77, 0xBF, 0xA8, 0x11, 0x0A, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0xA2, 0x02, 0xF9, 0x07, 0x20, 0x7F,
  0x90, 0x23, 0x08, 0xF8, 0x2B, 0x77, 0xBF, 0x08, 0x40, 0x10, 0xDF, 0xFA, 0x0D, 0x01, 0x50, 0x3F,
  0xFA, 0x03, 0x70, 0x7F, 0xF0, 0x77, 0x20, 0x9F, 0xD0, 0x97, 0x40, 0xBF, 0xB0, 0xB7, 0x60, 0xBF,
  0x90, 0xB7, 0x71, 0x0B, 0xE0, 0xB7, 0x73, 0x0B, 0xC0, 0xB7, 0x75, 0x0A, 0xA0, 0xA7, 0x77, 0x00,
  0x87, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_fmd_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_fmd_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_fmd_good 36x36, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_sharp_36_device_fmd_good_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x75, 0x02, 0x09, 0xFB, 0x09, 0x02, 0x72, 0x05, 0x0E,
  0xFD, 0x0E, 0x05, 0x70, 0x7F, 0xFA, 0x07, 0x50, 0x5F, 0xFC, 0x05, 0x30, 0x10, 0xEF, 0xFC, 0x0E,
  0x01, 0x20, 0x9F, 0xFE, 0x81, 0x90, 0x1F, 0xFF, 0x90, 0x10, 0x6F, 0xFF, 0x90, 0x60, 0xAF, 0xA8,
  0x27, 0x11, 0x7F, 0xA0, 0xA0, 0xCF, 0x90, 0x74, 0x07, 0xF9, 0x0C, 0x0E, 0xF9, 0x01, 0x40, 0x1F,
  0x90, 0xEF, 0xA0, 0x14, 0x01, 0xFA, 0x0D, 0xF9, 0x07, 0x40, 0x7F, 0x90, 0xD0, 0xBF, 0xA8, 0x27,
  0x11, 0x7F, 0xA0, 0xB0, 0x6F, 0xFF, 0x90, 0x60, 0x1F, 0xFF, 0x98, 0x11, 0x0A, 0xFF, 0xE0, 0xA2,
  0x02, 0xFF, 0xE0, 0x23, 0x08, 0xFF, 0xC0, 0x84, 0x01, 0x0D, 0xFF, 0xA0, 0xD0, 0x15, 0x03, 0xFF,
  0xA0, 0x37, 0x07, 0xFF, 0x07, 0x72, 0x09, 0xFD, 0x09, 0x74, 0x0B, 0xFB, 0x0B, 0x76, 0x0B, 0xF9,
  0x0B, 0x77, 0x10, 0xBE, 0x0B, 0x77, 0x30, 0xBC, 0x0B, 0x77, 0x50, 0xAA, 0x0A, 0x77, 0x70, 0x08,
  0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_fmd_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_fmd_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_g_mobiledata 36x36, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_sharp_36_device_g_mobiledata_data[] PROGMEM = {
  0x03, 0x80, 0x92, 0x7F, 0xE0, 0x7F, 0xE0, 0x7A, 0x0B, 0x80, 0x77, 0xA0, 0x77, 0x30, 0x7A, 0x07,
  0x73, 0x07, 0xA0, 0x74, 0x80, 0x37, 0xA0, 0x74, 0xE0, 0x7A, 0x07, 0x4E, 0x07, 0xA0, 0x74, 0x0F,
  0x7B, 0x07, 0xA0, 0x77, 0xB0, 0x7A, 0x07, 0x7B, 0x07, 0xA0, 0xB8, 0x03, 0x7B, 0x07, 0xFE, 0x07,
  0xFE, 0x03, 0x80, 0x91, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 10, 23, 25), Box(0, 0, 35, 35),
      ic_sharp_36_device_g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_gpp_bad 36x36, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_sharp_36_device_gpp_bad_data[] PROGMEM = {
  0x72, 0x84, 0x16, 0xCC, 0x61, 0x77, 0x20, 0x40, 0xAE, 0x0A, 0x04, 0x74, 0x81, 0x28, 0xEF, 0xB8,
  0x1E, 0x82, 0x58, 0x11, 0x6C, 0xFF, 0xA8, 0x3C, 0x61, 0x0A, 0xFF, 0xF9, 0x0A, 0x80, 0x9C, 0x4F,
  0x0E, 0xE0, 0xEF, 0xF9, 0x81, 0xE2, 0x6C, 0x81, 0x62, 0xEF, 0xE0, 0xE0, 0x22, 0x06, 0xA0, 0x62,
  0x02, 0x0E, 0xFE, 0x06, 0x30, 0x06, 0x30, 0x6F, 0xF9, 0x06, 0x60, 0x5F, 0x90, 0xEF, 0x90, 0x64,
  0x05, 0xF9, 0x0E, 0x0D, 0xF9, 0x06, 0x40, 0x5F, 0x90, 0xD0, 0xBF, 0x06, 0x60, 0x5F, 0x0B, 0x07,
  0xE0, 0x63, 0x00, 0x53, 0x06, 0xE0, 0x70, 0x3D, 0x0E, 0x02, 0x20, 0x5A, 0x05, 0x20, 0x20, 0xED,
  0x81, 0x30, 0xED, 0x81, 0xE2, 0x6C, 0x81, 0x62, 0xED, 0x0E, 0x20, 0x8E, 0x0E, 0xE0, 0xEE, 0x08,
  0x20, 0x1F, 0xFE, 0x01, 0x30, 0x7F, 0xFC, 0x07, 0x50, 0xDF, 0xFA, 0x0D, 0x60, 0x30, 0xEF, 0xF0,
  0xE0, 0x37, 0x04, 0xFF, 0x04, 0x72, 0x05, 0x0E, 0xFB, 0x0E, 0x05, 0x74, 0x03, 0x0D, 0xF9, 0x0D,
  0x03, 0x77, 0x08, 0xE0, 0x87, 0x73, 0x84, 0x17, 0xCC, 0x71, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_gpp_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_gpp_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_gpp_good 36x36, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_sharp_36_device_gpp_good_data[] PROGMEM = {
  0x72, 0x84, 0x16, 0xCC, 0x61, 0x77, 0x20, 0x40, 0xAE, 0x0A, 0x04, 0x74, 0x81, 0x28, 0xEF, 0xB8,
  0x1E, 0x82, 0x58, 0x11, 0x6C, 0xFF, 0xA8, 0x3C, 0x61, 0x0A, 0xFF, 0xF9, 0x0A, 0x80, 0x9D, 0x4F,
  0x0E, 0xFF, 0xF9, 0x81, 0xD1, 0x6F, 0xFE, 0x0D, 0x01, 0x20, 0x7F, 0xFC, 0x0D, 0x01, 0x30, 0xBF,
  0xC8, 0x19, 0x3E, 0xB0, 0xD0, 0x13, 0x0B, 0xE0, 0xEC, 0x09, 0x28, 0x33, 0xEF, 0xD1, 0x30, 0xBE,
  0x0E, 0x0D, 0xC0, 0x93, 0x81, 0x3C, 0x13, 0x0B, 0xF0, 0xD0, 0xBD, 0x09, 0x70, 0xBF, 0x90, 0xB0,
  0x7E, 0x09, 0x50, 0xBF, 0xA0, 0x70, 0x3F, 0x09, 0x30, 0xBF, 0xB8, 0x13, 0x0E, 0xF8, 0x19, 0x0B,
  0xFB, 0x0E, 0x20, 0x8F, 0x90, 0xEF, 0xC0, 0x82, 0x01, 0xFF, 0xE0, 0x13, 0x07, 0xFF, 0xC0, 0x75,
  0x0D, 0xFF, 0xA0, 0xD6, 0x03, 0x0E, 0xFF, 0x0E, 0x03, 0x70, 0x4F, 0xF0, 0x47, 0x20, 0x50, 0xEF,
  0xB0, 0xE0, 0x57, 0x40, 0x30, 0xDF, 0x90, 0xD0, 0x37, 0x70, 0x8E, 0x08, 0x77, 0x38, 0x41, 0x7C,
  0xC7, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_gpp_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_gpp_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_gpp_maybe 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_sharp_36_device_gpp_maybe_data[] PROGMEM = {
  0x72, 0x84, 0x16, 0xCC, 0x61, 0x77, 0x20, 0x40, 0xAE, 0x0A, 0x04, 0x74, 0x81, 0x28, 0xEF, 0xB8,
  0x1E, 0x82, 0x58, 0x11, 0x6C, 0xFF, 0xA8, 0x3C, 0x61, 0x0A, 0xFF, 0xF9, 0x0A, 0x80, 0xE6, 0xF8,
  0x2B, 0x77, 0xBF, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE,
  0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xB0, 0xEF, 0xA0, 0x72, 0x07,
  0xFA, 0x0E, 0x0D, 0xFF, 0xF9, 0x0D, 0x0B, 0xFF, 0xF9, 0x0B, 0x07, 0xFF, 0xF9, 0x07, 0x03, 0xFA,
  0x07, 0x20, 0x7F, 0xA8, 0x13, 0x0E, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0xE2, 0x08, 0xF9, 0x07, 0x20,
  0x7F, 0x90, 0x82, 0x01, 0xFF, 0xE0, 0x13, 0x07, 0xFF, 0xC0, 0x75, 0x0D, 0xFF, 0xA0, 0xD6, 0x03,
  0x0E, 0xFF, 0x0E, 0x03, 0x70, 0x4F, 0xF0, 0x47, 0x20, 0x50, 0xEF, 0xB0, 0xE0, 0x57, 0x40, 0x30,
  0xDF, 0x90, 0xD0, 0x37, 0x70, 0x8E, 0x08, 0x77, 0x38, 0x41, 0x7C, 0xC7, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_gpp_maybe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_gpp_maybe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_gps_fixed 36x36, 4-bit Alpha,  RLE, 276 bytes.
static const unsigned char ic_sharp_36_device_gps_fixed_data[] PROGMEM = {
  0x77, 0x18, 0x23, 0x77, 0x37, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77,
  0x71, 0x03, 0x0A, 0xA0, 0xA0, 0x37, 0x77, 0x40, 0x40, 0xAF, 0x90, 0xA0, 0x47, 0x76, 0x03, 0x0C,
  0xFD, 0x0C, 0x03, 0x77, 0x30, 0x6D, 0x84, 0xD9, 0x88, 0x9D, 0xD0, 0x67, 0x71, 0x08, 0xC0, 0x80,
  0x26, 0x02, 0x08, 0xC0, 0x87, 0x60, 0x6B, 0x0C, 0x01, 0x73, 0x01, 0x0C, 0xB0, 0x67, 0x40, 0x3B,
  0x0A, 0x77, 0x0A, 0xB0, 0x37, 0x30, 0xCA, 0x0C, 0x77, 0x20, 0xCA, 0x0C, 0x72, 0x04, 0xB0, 0x15,
  0x84, 0x6C, 0xEE, 0xC6, 0x50, 0x1B, 0x04, 0x71, 0x0A, 0xA0, 0x84, 0x01, 0x0C, 0xE0, 0xC0, 0x14,
  0x08, 0xA0, 0xA7, 0x1B, 0x02, 0x40, 0xCF, 0x90, 0xC4, 0x02, 0xB7, 0x03, 0xA0, 0xC4, 0x06, 0xFB,
  0x06, 0x40, 0xCA, 0x03, 0x38, 0x23, 0x77, 0xAA, 0x0A, 0x40, 0xCF, 0xB0, 0xC4, 0x0A, 0xA8, 0x3A,
  0x77, 0x37, 0xD0, 0x84, 0x0E, 0xFB, 0x0E, 0x40, 0x8D, 0x00, 0x7D, 0x08, 0x40, 0xEF, 0xB0, 0xE4,
  0x08, 0xD8, 0x37, 0x37, 0x7A, 0xA0, 0xA4, 0x0C, 0xFB, 0x0C, 0x40, 0xAA, 0x82, 0xA7, 0x73, 0x30,
  0x3A, 0x0C, 0x40, 0x6F, 0xB0, 0x64, 0x0C, 0xA0, 0x37, 0xB0, 0x24, 0x0C, 0xF9, 0x0C, 0x40, 0x2B,
  0x71, 0x0A, 0xA0, 0x84, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x08, 0xA0, 0xA7, 0x10, 0x4B, 0x01, 0x58,
  0x46, 0xCE, 0xEC, 0x65, 0x01, 0xB0, 0x47, 0x20, 0xCA, 0x0C, 0x77, 0x20, 0xCA, 0x0C, 0x73, 0x03,
  0xB0, 0xA7, 0x70, 0xAB, 0x03, 0x74, 0x06, 0xB0, 0xC0, 0x17, 0x30, 0x10, 0xCB, 0x06, 0x76, 0x08,
  0xC0, 0x80, 0x26, 0x02, 0x08, 0xC0, 0x87, 0x71, 0x06, 0xD8, 0x4D, 0x98, 0x89, 0xDD, 0x06, 0x77,
  0x30, 0x30, 0xCF, 0xD0, 0xC0, 0x37, 0x76, 0x04, 0x0A, 0xF9, 0x0A, 0x04, 0x77, 0x74, 0x03, 0x0A,
  0xA0, 0xA0, 0x37, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x82,
  0x37, 0x73, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_gps_fixed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_gps_fixed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_gps_not_fixed 36x36, 4-bit Alpha,  RLE, 241 bytes.
static const unsigned char ic_sharp_36_device_gps_not_fixed_data[] PROGMEM = {
  0x77, 0x18, 0x23, 0x77, 0x37, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77,
  0x71, 0x03, 0x0A, 0xA0, 0xA0, 0x37, 0x77, 0x40, 0x40, 0xAF, 0x90, 0xA0, 0x47, 0x76, 0x03, 0x0C,
  0xFD, 0x0C, 0x03, 0x77, 0x30, 0x6D, 0x84, 0xD9, 0x88, 0x9D, 0xD0, 0x67, 0x71, 0x08, 0xC0, 0x80,
  0x26, 0x02, 0x08, 0xC0, 0x87, 0x60, 0x6B, 0x0C, 0x01, 0x73, 0x01, 0x0C, 0xB0, 0x67, 0x40, 0x3B,
  0x0A, 0x77, 0x0A, 0xB0, 0x37, 0x30, 0xCA, 0x0C, 0x77, 0x20, 0xCA, 0x0C, 0x72, 0x04, 0xB0, 0x17,
  0x72, 0x01, 0xB0, 0x47, 0x10, 0xAA, 0x08, 0x77, 0x40, 0x8A, 0x0A, 0x71, 0xB0, 0x27, 0x74, 0x02,
  0xB7, 0x03, 0xA0, 0xC7, 0x76, 0x0C, 0xA0, 0x33, 0x82, 0x37, 0x7A, 0xA0, 0xA7, 0x76, 0x0A, 0xA8,
  0x3A, 0x77, 0x37, 0xD0, 0x87, 0x76, 0x08, 0xD0, 0x07, 0xD0, 0x87, 0x76, 0x08, 0xD8, 0x37, 0x37,
  0x7A, 0xA0, 0xA7, 0x76, 0x0A, 0xA8, 0x2A, 0x77, 0x33, 0x03, 0xA0, 0xC7, 0x76, 0x0C, 0xA0, 0x37,
  0xB0, 0x27, 0x74, 0x02, 0xB7, 0x10, 0xAA, 0x08, 0x77, 0x40, 0x8A, 0x0A, 0x71, 0x04, 0xB0, 0x17,
  0x72, 0x01, 0xB0, 0x47, 0x20, 0xCA, 0x0C, 0x77, 0x20, 0xCA, 0x0C, 0x73, 0x03, 0xB0, 0xA7, 0x70,
  0xAB, 0x03, 0x74, 0x06, 0xB0, 0xC0, 0x17, 0x30, 0x10, 0xCB, 0x06, 0x76, 0x08, 0xC0, 0x80, 0x26,
  0x02, 0x08, 0xC0, 0x87, 0x71, 0x06, 0xD8, 0x4D, 0x98, 0x89, 0xDD, 0x06, 0x77, 0x30, 0x30, 0xCF,
  0xD0, 0xC0, 0x37, 0x76, 0x04, 0x0A, 0xF9, 0x0A, 0x04, 0x77, 0x74, 0x03, 0x0A, 0xA0, 0xA0, 0x37,
  0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x82, 0x37, 0x73, 0x77,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_gps_not_fixed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_gps_not_fixed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_gps_off 36x36, 4-bit Alpha,  RLE, 283 bytes.
static const unsigned char ic_sharp_36_device_gps_off_data[] PROGMEM = {
  0x77, 0x18, 0x23, 0x77, 0x37, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x76,
  0x06, 0x71, 0x03, 0x0A, 0xA0, 0xA0, 0x37, 0x74, 0x81, 0x9F, 0xB4, 0x03, 0x0A, 0xF9, 0x0A, 0x04,
  0x77, 0x03, 0xB0, 0xB3, 0x01, 0x0C, 0xFB, 0x0C, 0x03, 0x76, 0x06, 0xB0, 0xB3, 0x86, 0x1C, 0xD9,
  0x88, 0x9D, 0xD0, 0x67, 0x60, 0x6B, 0x0B, 0x73, 0x02, 0x08, 0xC0, 0x87, 0x60, 0xAB, 0x0B, 0x74,
  0x01, 0x0C, 0xB0, 0x67, 0x40, 0x3D, 0x0B, 0x75, 0x0A, 0xB0, 0x37, 0x30, 0xCA, 0x0D, 0xB0, 0xB7,
  0x50, 0xCA, 0x0C, 0x72, 0x04, 0xA8, 0x1E, 0x26, 0xB0, 0xB7, 0x40, 0x1B, 0x04, 0x71, 0x0A, 0xA0,
  0x82, 0x06, 0xB0, 0xB7, 0x40, 0x8A, 0x0A, 0x71, 0xB0, 0x13, 0x06, 0xB0, 0xB7, 0x30, 0x2B, 0x70,
  0x3A, 0x0D, 0x50, 0x6B, 0x0B, 0x73, 0x0C, 0xA0, 0x33, 0x82, 0x37, 0x7A, 0xA0, 0x96, 0x06, 0xB0,
  0xB7, 0x20, 0xAA, 0x83, 0xA7, 0x73, 0x7D, 0x08, 0x70, 0x6B, 0x0B, 0x71, 0x08, 0xD0, 0x07, 0xD0,
  0x87, 0x10, 0x6B, 0x0B, 0x70, 0x8D, 0x83, 0x73, 0x77, 0xAA, 0x0A, 0x72, 0x06, 0xB0, 0xB6, 0x09,
  0xA8, 0x2A, 0x77, 0x33, 0x03, 0xA0, 0xC7, 0x30, 0x6B, 0x0B, 0x50, 0xCA, 0x03, 0x7B, 0x02, 0x73,
  0x06, 0xB0, 0xB4, 0x0C, 0xA7, 0x10, 0xAA, 0x08, 0x74, 0x06, 0xB0, 0xB3, 0x81, 0x1C, 0xA7, 0x10,
  0x4B, 0x01, 0x74, 0x06, 0xB0, 0xB3, 0x01, 0x03, 0x72, 0x0C, 0xA0, 0xC7, 0x50, 0x6B, 0x0B, 0x76,
  0x03, 0xB0, 0xA7, 0x50, 0x6B, 0x0B, 0x76, 0x06, 0xB0, 0xC0, 0x17, 0x30, 0x20, 0xDB, 0x0B, 0x76,
  0x08, 0xC0, 0x80, 0x26, 0x81, 0x18, 0xED, 0x0B, 0x76, 0x06, 0xD8, 0x4D, 0x98, 0x89, 0xDD, 0x0A,
  0xB0, 0xB7, 0x60, 0x30, 0xCF, 0xD8, 0x2C, 0x30, 0x6B, 0x06, 0x77, 0x04, 0x0A, 0xF9, 0x0A, 0x04,
  0x48, 0x16, 0xF9, 0x77, 0x40, 0x30, 0xAA, 0x0A, 0x03, 0x71, 0x03, 0x77, 0x60, 0x7A, 0x07, 0x77,
  0x77, 0x20, 0x7A, 0x07, 0x77, 0x77, 0x28, 0x23, 0x77, 0x37, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_gps_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_gps_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_graphic_eq 36x36, 4-bit Alpha,  RLE, 253 bytes.
static const unsigned char ic_sharp_36_device_graphic_eq_data[] PROGMEM = {
  0x75, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A,
  0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x20, 0x7A,
  0x07, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A,
  0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x77, 0x50, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x77, 0x50, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x75, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A,
  0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73,
  0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_graphic_eq() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_graphic_eq_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_grid_3x3 36x36, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_36_device_grid_3x3_data[] PROGMEM = {
  0x6B, 0x6B, 0x75, 0xB6, 0xB7, 0x5B, 0x6B, 0x75, 0xB6, 0xB7, 0x5B, 0x6B, 0x75, 0xB6, 0xB6, 0x80,
  0x98, 0x4F, 0x6B, 0x6B, 0x75, 0xB6, 0xB7, 0x5B, 0x6B, 0x75, 0xB6, 0xB7, 0x5B, 0x6B, 0x75, 0xB6,
  0xB6, 0x80, 0x98, 0x4F, 0x6B, 0x6B, 0x75, 0xB6, 0xB7, 0x5B, 0x6B, 0x75, 0xB6, 0xB7, 0x5B, 0x6B,
  0x75, 0xB6, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_grid_3x3() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 29, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_grid_3x3_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_grid_4x4 36x36, 4-bit Alpha,  RLE, 272 bytes.
static const unsigned char ic_sharp_36_device_grid_4x4_data[] PROGMEM = {
  0x40, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x75, 0x07, 0xA0, 0x74, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x01, 0x70, 0xBA, 0x0B, 0x80,
  0x17, 0x0B, 0xA0, 0xB8, 0x00, 0x78, 0x0F, 0x0F, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x01, 0x70, 0xBA,
  0x0B, 0x80, 0x17, 0x0B, 0xA0, 0xB8, 0x00, 0x74, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x77, 0x10, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x75, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x71, 0x07, 0xA0,
  0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x74, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x01, 0x70, 0xBA, 0x0B,
  0x80, 0x17, 0x0B, 0xA0, 0xB8, 0x00, 0x78, 0x0F, 0x0F, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x01, 0x70,
  0xBA, 0x0B, 0x80, 0x17, 0x0B, 0xA0, 0xB8, 0x00, 0x74, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07,
  0xA0, 0x77, 0x10, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x75, 0x07,
  0xA0, 0x75, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x71, 0x07,
  0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x74, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x01, 0x70, 0xBA,
  0x0B, 0x80, 0x17, 0x0B, 0xA0, 0xB8, 0x00, 0x78, 0x0F, 0x0F, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x01,
  0x70, 0xBA, 0x0B, 0x80, 0x17, 0x0B, 0xA0, 0xB8, 0x00, 0x74, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x75, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_grid_4x4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_grid_4x4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_grid_goldenratio 36x36, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_sharp_36_device_grid_goldenratio_data[] PROGMEM = {
  0x73, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x38, 0x06, 0x70, 0xBA, 0x82, 0xB7, 0x7B, 0xA0, 0xB8, 0x06,
  0x78, 0x0F, 0x0F, 0x80, 0x67, 0x0B, 0xA8, 0x2B, 0x77, 0xBA, 0x0B, 0x80, 0x67, 0x73, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x38, 0x06, 0x70, 0xBA, 0x82,
  0xB7, 0x7B, 0xA0, 0xB8, 0x06, 0x78, 0x0F, 0x0F, 0x80, 0x67, 0x0B, 0xA8, 0x2B, 0x77, 0xBA, 0x0B,
  0x80, 0x67, 0x73, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77,
  0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_grid_goldenratio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_grid_goldenratio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_hdr_auto 36x36, 4-bit Alpha,  RLE, 221 bytes.
static const unsigned char ic_sharp_36_device_hdr_auto_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFB, 0x05, 0x20, 0x5F, 0xB0, 0x54, 0x0D, 0xFA, 0x0E, 0x40, 0xEF, 0xA0, 0xD3,
  0x07, 0xFB, 0x08, 0x40, 0x9F, 0xB0, 0x72, 0x0E, 0xFB, 0x84, 0x30, 0x33, 0x03, 0xFB, 0x81, 0xE0,
  0x3F, 0xB0, 0xC2, 0x09, 0x08, 0x20, 0xDF, 0xB0, 0x30, 0x8F, 0xB0, 0x62, 0x00, 0xE2, 0x07, 0xFB,
  0x08, 0x0B, 0xFB, 0x81, 0x10, 0x4A, 0x81, 0x40, 0x1F, 0xB0, 0xB0, 0xDF, 0xA0, 0xA2, 0x09, 0xA0,
  0x92, 0x0B, 0xFA, 0x0D, 0x0E, 0xFA, 0x05, 0x20, 0xEA, 0x0E, 0x20, 0x5F, 0xA0, 0x0E, 0xF9, 0x0E,
  0x28, 0x44, 0xDD, 0xDD, 0x42, 0x0E, 0xF9, 0x0E, 0x0D, 0xF9, 0x08, 0x73, 0x09, 0xF9, 0x0D, 0x0B,
  0xF9, 0x03, 0x73, 0x03, 0xF9, 0x0B, 0x08, 0xF0, 0xC2, 0x05, 0x80, 0x2B, 0x05, 0x20, 0xCF, 0x08,
  0x03, 0xF0, 0x62, 0x0B, 0xE0, 0xB2, 0x07, 0xF8, 0x13, 0x0E, 0xE8, 0x11, 0x01, 0xF9, 0x81, 0x10,
  0x1E, 0x0E, 0x20, 0x7D, 0x0A, 0x20, 0x7F, 0x90, 0x72, 0x0B, 0xD0, 0x73, 0x0D, 0xC8, 0x2A, 0x77,
  0xDF, 0x98, 0x2D, 0x77, 0xBC, 0x0D, 0x40, 0x5F, 0xFF, 0xB0, 0x55, 0x08, 0xFF, 0xF9, 0x08, 0x70,
  0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70,
  0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_hdr_auto() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_hdr_auto_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_hdr_auto_select 36x36, 4-bit Alpha,  RLE, 273 bytes.
static const unsigned char ic_sharp_36_device_hdr_auto_select_data[] PROGMEM = {
  0x77, 0x86, 0x49, 0xDE, 0xED, 0x94, 0x77, 0x75, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x77, 0x72, 0x03,
  0x0E, 0xFB, 0x0E, 0x03, 0x77, 0x70, 0x20, 0xEC, 0x0D, 0x20, 0xDC, 0x0E, 0x02, 0x77, 0x60, 0xBD,
  0x07, 0x20, 0x7D, 0x0B, 0x77, 0x50, 0x4E, 0x82, 0x13, 0x32, 0xE0, 0x47, 0x74, 0x09, 0xD8, 0x4B,
  0x09, 0x90, 0xBD, 0x09, 0x77, 0x40, 0xDD, 0x84, 0x50, 0xEE, 0x05, 0xD0, 0xD7, 0x74, 0x0E, 0xC8,
  0x1E, 0x04, 0xA8, 0x14, 0x0E, 0xC0, 0xE7, 0x74, 0x0E, 0xC8, 0x69, 0x02, 0x33, 0x20, 0x9C, 0x0E,
  0x77, 0x40, 0xDC, 0x86, 0x30, 0x11, 0x11, 0x03, 0xC0, 0xD7, 0x74, 0x09, 0xB8, 0x1D, 0x05, 0xC8,
  0x15, 0x0D, 0xB0, 0x97, 0x74, 0x04, 0xB8, 0x17, 0x0B, 0xC8, 0x1A, 0x07, 0xB0, 0x47, 0x75, 0x0B,
  0xA0, 0x90, 0x7E, 0x07, 0x09, 0xA0, 0xB7, 0x76, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x77, 0x70, 0x30,
  0xEF, 0xB0, 0xE0, 0x37, 0x77, 0x20, 0x20, 0xBF, 0x90, 0xB0, 0x27, 0x77, 0x58, 0x64, 0x9D, 0xEE,
  0xD9, 0x48, 0x09, 0xE6, 0x0A, 0x03, 0x28, 0x3B, 0xF7, 0x03, 0xD0, 0xD0, 0x52, 0x07, 0xF3, 0x81,
  0x13, 0x33, 0xA0, 0x32, 0x83, 0xBF, 0x70, 0x3F, 0x81, 0x10, 0x7F, 0x30, 0x3A, 0x3A, 0x03, 0x28,
  0x3B, 0xF7, 0x03, 0xA0, 0xF3, 0xA8, 0x63, 0x07, 0xFC, 0x33, 0x6A, 0x30, 0x3A, 0x3F, 0x81, 0x70,
  0x3A, 0x3A, 0x86, 0x30, 0x7F, 0xC3, 0x36, 0xA8, 0x21, 0x33, 0x6A, 0x0F, 0x3F, 0x81, 0x70, 0x3A,
  0x3A, 0x81, 0x30, 0x7F, 0x03, 0xFB, 0x86, 0x63, 0x3C, 0xF7, 0x03, 0xA3, 0xA8, 0x13, 0x07, 0xF0,
  0x3F, 0xB0, 0x32, 0x83, 0xBF, 0x70, 0x3A, 0x0F, 0x3A, 0x87, 0x30, 0x7F, 0xB0, 0x5F, 0xD4, 0x03,
  0xA3, 0xA0, 0x32, 0x83, 0xBF, 0x70, 0x3F, 0x83, 0x10, 0x7F, 0xB2, 0x81, 0xDF, 0x53, 0x03, 0xA3,
  0xA0, 0x32, 0x83, 0xBF, 0x70, 0x3D, 0x0D, 0x05, 0x28, 0x17, 0xFB, 0x28, 0x17, 0xFC, 0x30, 0x3A,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_hdr_auto_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 35, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_hdr_auto_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_hdr_off_select 36x36, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_sharp_36_device_hdr_off_select_data[] PROGMEM = {
  0x72, 0x03, 0x48, 0x13, 0x9D, 0xA8, 0x1D, 0x94, 0x77, 0x71, 0x81, 0x7F, 0x73, 0x04, 0xF0, 0xB0,
  0x27, 0x75, 0x05, 0xB0, 0x73, 0x04, 0xF0, 0xE0, 0x37, 0x75, 0x0B, 0xB0, 0x73, 0x0F, 0x10, 0x30,
  0x9B, 0x0E, 0x02, 0x77, 0x50, 0xBB, 0x07, 0x70, 0x30, 0xDA, 0x0B, 0x77, 0x50, 0x4C, 0x07, 0x70,
  0x3B, 0x04, 0x77, 0x40, 0x9D, 0x07, 0x70, 0x9A, 0x09, 0x77, 0x40, 0xDA, 0x0D, 0xB0, 0x76, 0x03,
  0xA0, 0xD7, 0x74, 0xB0, 0x10, 0xBB, 0x07, 0x50, 0x1B, 0x77, 0x4B, 0x81, 0x10, 0xBB, 0x07, 0x40,
  0x1B, 0x77, 0x40, 0xDA, 0x03, 0x20, 0xBB, 0x07, 0x30, 0x1A, 0x0D, 0x77, 0x40, 0x9A, 0x09, 0x30,
  0xBB, 0x07, 0x38, 0x14, 0xF9, 0x77, 0x40, 0x4B, 0x03, 0x30, 0xBB, 0x07, 0x30, 0x40, 0x37, 0x75,
  0x0B, 0xA0, 0xD0, 0x33, 0x0B, 0xB0, 0x77, 0x77, 0x20, 0x20, 0xEB, 0x83, 0x93, 0x11, 0xDB, 0x07,
  0x77, 0x72, 0x03, 0x0E, 0xFC, 0x07, 0x77, 0x72, 0x02, 0x0B, 0xFC, 0x07, 0x77, 0x73, 0x81, 0x49,
  0xDA, 0x82, 0xD9, 0x4B, 0xB0, 0x37, 0x77, 0x74, 0x81, 0xBF, 0x77, 0x77, 0x76, 0x05, 0x80, 0xD3,
  0x0A, 0x03, 0x28, 0x3B, 0xF7, 0x03, 0xD0, 0xD0, 0x52, 0x07, 0xF3, 0x81, 0x13, 0x33, 0xA0, 0x32,
  0x83, 0xBF, 0x70, 0x3F, 0x81, 0x10, 0x7F, 0x30, 0x3A, 0x3A, 0x03, 0x28, 0x3B, 0xF7, 0x03, 0xA0,
  0xF3, 0xA8, 0x63, 0x07, 0xFC, 0x33, 0x6A, 0x30, 0x3A, 0x3F, 0x81, 0x70, 0x3A, 0x3A, 0x86, 0x30,
  0x7F, 0xC3, 0x36, 0xA8, 0x21, 0x33, 0x6A, 0x0F, 0x3F, 0x81, 0x70, 0x3A, 0x3A, 0x81, 0x30, 0x7F,
  0x03, 0xFB, 0x86, 0x63, 0x3C, 0xF7, 0x03, 0xA3, 0xA8, 0x13, 0x07, 0xF0, 0x3F, 0xB0, 0x32, 0x83,
  0xBF, 0x70, 0x3A, 0x0F, 0x3A, 0x87, 0x30, 0x7F, 0xB0, 0x5F, 0xD4, 0x03, 0xA3, 0xA0, 0x32, 0x83,
  0xBF, 0x70, 0x3F, 0x83, 0x10, 0x7F, 0xB2, 0x81, 0xDF, 0x53, 0x03, 0xA3, 0xA0, 0x32, 0x83, 0xBF,
  0x70, 0x3D, 0x0D, 0x05, 0x28, 0x17, 0xFB, 0x28, 0x17, 0xFC, 0x30, 0x3A, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_hdr_off_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 35, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_hdr_off_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_hdr_on_select 36x36, 4-bit Alpha,  RLE, 265 bytes.
static const unsigned char ic_sharp_36_device_hdr_on_select_data[] PROGMEM = {
  0x77, 0x86, 0x49, 0xDE, 0xED, 0x94, 0x77, 0x75, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x77, 0x72, 0x03,
  0x0E, 0xFB, 0x0E, 0x03, 0x77, 0x70, 0x20, 0xEB, 0x08, 0x03, 0x20, 0x30, 0x8B, 0x0E, 0x02, 0x77,
  0x60, 0xBA, 0x0D, 0x02, 0x60, 0x20, 0xDA, 0x0B, 0x77, 0x50, 0x4B, 0x02, 0x71, 0x02, 0xB0, 0x47,
  0x74, 0x09, 0xA0, 0x87, 0x30, 0x8A, 0x09, 0x77, 0x40, 0xDA, 0x03, 0x73, 0x03, 0xA0, 0xD7, 0x74,
  0x0E, 0xA7, 0x5A, 0x0E, 0x77, 0x40, 0xEA, 0x75, 0xA0, 0xE7, 0x74, 0x0D, 0xA0, 0x37, 0x30, 0x3A,
  0x0D, 0x77, 0x40, 0x9A, 0x08, 0x73, 0x08, 0xA0, 0x97, 0x74, 0x04, 0xB0, 0x27, 0x10, 0x2B, 0x04,
  0x77, 0x50, 0xBA, 0x0D, 0x02, 0x60, 0x20, 0xDA, 0x0B, 0x77, 0x60, 0x20, 0xEB, 0x08, 0x03, 0x20,
  0x30, 0x8B, 0x0E, 0x02, 0x77, 0x70, 0x30, 0xEF, 0xB0, 0xE0, 0x37, 0x77, 0x20, 0x20, 0xBF, 0x90,
  0xB0, 0x27, 0x77, 0x58, 0x64, 0x9D, 0xEE, 0xD9, 0x48, 0x09, 0xE6, 0x0A, 0x03, 0x28, 0x3B, 0xF7,
  0x03, 0xD0, 0xD0, 0x52, 0x07, 0xF3, 0x81, 0x13, 0x33, 0xA0, 0x32, 0x83, 0xBF, 0x70, 0x3F, 0x81,
  0x10, 0x7F, 0x30, 0x3A, 0x3A, 0x03, 0x28, 0x3B, 0xF7, 0x03, 0xA0, 0xF3, 0xA8, 0x63, 0x07, 0xFC,
  0x33, 0x6A, 0x30, 0x3A, 0x3F, 0x81, 0x70, 0x3A, 0x3A, 0x86, 0x30, 0x7F, 0xC3, 0x36, 0xA8, 0x21,
  0x33, 0x6A, 0x0F, 0x3F, 0x81, 0x70, 0x3A, 0x3A, 0x81, 0x30, 0x7F, 0x03, 0xFB, 0x86, 0x63, 0x3C,
  0xF7, 0x03, 0xA3, 0xA8, 0x13, 0x07, 0xD8, 0x1E, 0xD3, 0xFB, 0x03, 0x28, 0x3B, 0xF7, 0x03, 0xA0,
  0xF3, 0xA8, 0x73, 0x07, 0xFB, 0x05, 0xFE, 0x40, 0x3A, 0x3A, 0x03, 0x28, 0x3B, 0xF7, 0x03, 0xF8,
  0x31, 0x07, 0xFB, 0x28, 0x1D, 0xF5, 0x30, 0x3A, 0x3A, 0x03, 0x28, 0x3B, 0xF7, 0x03, 0xD0, 0xD0,
  0x52, 0x81, 0x7F, 0xB2, 0x81, 0x7F, 0xC3, 0x03, 0xA3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_hdr_on_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 35, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_hdr_on_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_h_mobiledata 36x36, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_36_device_h_mobiledata_data[] PROGMEM = {
  0x82, 0x37, 0x73, 0x71, 0x83, 0x37, 0x73, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x04, 0x70, 0xBA, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7A, 0x0B,
  0x80, 0x47, 0x0B, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x83,
  0x73, 0x77, 0x37, 0x18, 0x23, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_h_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 10, 25, 25), Box(0, 0, 35, 35),
      ic_sharp_36_device_h_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_h_plus_mobiledata 36x36, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_sharp_36_device_h_plus_mobiledata_data[] PROGMEM = {
  0x0F, 0x77, 0x20, 0xF7, 0x75, 0xB7, 0x2B, 0x75, 0xB7, 0x2B, 0x75, 0xB7, 0x2B, 0x60, 0xF7, 0x3B,
  0x72, 0xB6, 0xB3, 0xB7, 0x2B, 0x6B, 0x3B, 0x80, 0x57, 0xB3, 0x0F, 0x7B, 0x0F, 0x7F, 0xF9, 0x3F,
  0xFF, 0xB3, 0xFD, 0x80, 0x57, 0xB3, 0x0F, 0x7B, 0x0F, 0x7B, 0x72, 0xB6, 0xB3, 0xB7, 0x2B, 0x6B,
  0x3B, 0x72, 0xB6, 0x0F, 0x73, 0xB7, 0x2B, 0x75, 0xB7, 0x2B, 0x75, 0x0F, 0x77, 0x20, 0xF7, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_h_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 32, 25), Box(0, 0, 35, 35),
      ic_sharp_36_device_h_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_lan 36x36, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_sharp_36_device_lan_data[] PROGMEM = {
  0x71, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72,
  0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x00,
  0x77, 0x76, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x38, 0x03, 0x70, 0xBA, 0x0B, 0x80,
  0x37, 0x73, 0xFF, 0xC7, 0x3F, 0xFC, 0x73, 0xB8, 0x09, 0x07, 0xB7, 0x3B, 0x75, 0xB7, 0x3B, 0x75,
  0xB5, 0x03, 0x80, 0x07, 0xB8, 0x00, 0x70, 0x32, 0x03, 0x80, 0x07, 0xB8, 0x00, 0x70, 0x30, 0x7F,
  0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC,
  0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72,
  0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F,
  0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_lan() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_lan_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_lens_blur 36x36, 4-bit Alpha,  RLE, 246 bytes.
static const unsigned char ic_sharp_36_device_lens_blur_data[] PROGMEM = {
  0x74, 0x00, 0x14, 0x00, 0x17, 0x77, 0x10, 0x0A, 0x40, 0x0A, 0x77, 0x71, 0x00, 0x14, 0x00, 0x18,
  0x0D, 0x20, 0x00, 0x54, 0x00, 0x54, 0x00, 0x54, 0x00, 0x57, 0x20, 0x5A, 0x05, 0x20, 0x5A, 0x05,
  0x20, 0x5A, 0x05, 0x20, 0x5A, 0x05, 0x71, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x52,
  0x05, 0xA0, 0x57, 0x20, 0x05, 0x40, 0x05, 0x40, 0x05, 0x40, 0x05, 0x80, 0xD2, 0x00, 0x02, 0x40,
  0x02, 0x77, 0x20, 0x05, 0x30, 0x9A, 0x09, 0x20, 0x9A, 0x09, 0x30, 0x05, 0x58, 0x31, 0xA1, 0x05,
  0xA8, 0x15, 0x02, 0xC0, 0x02, 0xC8, 0x12, 0x05, 0xA8, 0x90, 0x50, 0x1A, 0x11, 0xA1, 0x05, 0xA8,
  0x15, 0x02, 0xC0, 0x02, 0xC8, 0x12, 0x05, 0xA8, 0x35, 0x01, 0xA1, 0x50, 0x05, 0x30, 0x9A, 0x09,
  0x20, 0x9A, 0x09, 0x30, 0x05, 0x77, 0x20, 0x02, 0x40, 0x02, 0x77, 0x71, 0x00, 0x24, 0x00, 0x27,
  0x72, 0x00, 0x53, 0x09, 0xA0, 0x92, 0x09, 0xA0, 0x93, 0x00, 0x55, 0x83, 0x1A, 0x10, 0x5A, 0x81,
  0x50, 0x2C, 0x00, 0x2C, 0x81, 0x20, 0x5A, 0x89, 0x05, 0x01, 0xA1, 0x1A, 0x10, 0x5A, 0x81, 0x50,
  0x2C, 0x00, 0x2C, 0x81, 0x20, 0x5A, 0x83, 0x50, 0x1A, 0x15, 0x00, 0x53, 0x09, 0xA0, 0x92, 0x09,
  0xA0, 0x93, 0x00, 0x57, 0x72, 0x00, 0x24, 0x00, 0x28, 0x0D, 0x20, 0x00, 0x54, 0x00, 0x54, 0x00,
  0x54, 0x00, 0x57, 0x20, 0x5A, 0x05, 0x20, 0x5A, 0x05, 0x20, 0x5A, 0x05, 0x20, 0x5A, 0x05, 0x71,
  0x05, 0xA0, 0x52, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x57, 0x20, 0x05, 0x40, 0x05,
  0x40, 0x05, 0x40, 0x05, 0x80, 0xD2, 0x00, 0x01, 0x40, 0x01, 0x77, 0x71, 0x00, 0xA4, 0x00, 0xA7,
  0x77, 0x10, 0x01, 0x40, 0x01, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_lens_blur() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_lens_blur_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_light_mode 36x36, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_sharp_36_device_light_mode_data[] PROGMEM = {
  0x77, 0x18, 0x23, 0x77, 0x37, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77,
  0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x0B, 0x09, 0x70, 0x7A, 0x07, 0x70,
  0x90, 0xB7, 0x40, 0xBA, 0x09, 0x68, 0x23, 0x77, 0x36, 0x09, 0xA0, 0xB7, 0x30, 0x9B, 0x09, 0x77,
  0x09, 0xB0, 0x97, 0x40, 0x9B, 0x05, 0x75, 0x05, 0xB0, 0x97, 0x68, 0x19, 0xF9, 0x58, 0x25, 0x77,
  0x55, 0x81, 0x9F, 0x97, 0x71, 0x05, 0x30, 0x10, 0x9E, 0x09, 0x01, 0x30, 0x57, 0x75, 0x02, 0x0D,
  0xF9, 0x0D, 0x02, 0x77, 0x70, 0x10, 0xDF, 0xB0, 0xD0, 0x17, 0x76, 0x09, 0xFD, 0x09, 0x77, 0x6F,
  0xF7, 0x30, 0x38, 0x01, 0x70, 0x32, 0x05, 0xFF, 0x05, 0x20, 0x38, 0x01, 0x70, 0x30, 0x7D, 0x07,
  0x20, 0x6F, 0xF0, 0x62, 0x07, 0xD0, 0x07, 0xD0, 0x72, 0x06, 0xFF, 0x06, 0x20, 0x7D, 0x07, 0x03,
  0x80, 0x17, 0x03, 0x20, 0x5F, 0xF0, 0x52, 0x03, 0x80, 0x17, 0x03, 0x73, 0xFF, 0x77, 0x60, 0x9F,
  0xD0, 0x97, 0x76, 0x01, 0x0D, 0xFB, 0x0D, 0x01, 0x77, 0x70, 0x20, 0xDF, 0x90, 0xD0, 0x27, 0x75,
  0x06, 0x30, 0x10, 0x9E, 0x09, 0x01, 0x30, 0x57, 0x71, 0x81, 0x9F, 0x95, 0x82, 0x57, 0x75, 0x58,
  0x19, 0xF9, 0x76, 0x09, 0xB0, 0x57, 0x50, 0x6B, 0x09, 0x74, 0x09, 0xB0, 0x97, 0x70, 0x9B, 0x09,
  0x73, 0x0B, 0xA0, 0x96, 0x82, 0x37, 0x73, 0x60, 0x9A, 0x0B, 0x74, 0x0B, 0x09, 0x70, 0x7A, 0x07,
  0x70, 0x90, 0xB7, 0x77, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0,
  0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x82, 0x37, 0x73, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_light_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_light_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_location_disabled 36x36, 4-bit Alpha,  RLE, 283 bytes.
static const unsigned char ic_sharp_36_device_location_disabled_data[] PROGMEM = {
  0x77, 0x18, 0x23, 0x77, 0x37, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x76,
  0x06, 0x71, 0x03, 0x0A, 0xA0, 0xA0, 0x37, 0x74, 0x81, 0x9F, 0xB4, 0x03, 0x0A, 0xF9, 0x0A, 0x04,
  0x77, 0x03, 0xB0, 0xB3, 0x01, 0x0C, 0xFB, 0x0C, 0x03, 0x76, 0x06, 0xB0, 0xB3, 0x86, 0x1C, 0xD9,
  0x88, 0x9D, 0xD0, 0x67, 0x60, 0x6B, 0x0B, 0x73, 0x02, 0x08, 0xC0, 0x87, 0x60, 0xAB, 0x0B, 0x74,
  0x01, 0x0C, 0xB0, 0x67, 0x40, 0x3D, 0x0B, 0x75, 0x0A, 0xB0, 0x37, 0x30, 0xCA, 0x0D, 0xB0, 0xB7,
  0x50, 0xCA, 0x0C, 0x72, 0x04, 0xA8, 0x1E, 0x26, 0xB0, 0xB7, 0x40, 0x1B, 0x04, 0x71, 0x0A, 0xA0,
  0x82, 0x06, 0xB0, 0xB7, 0x40, 0x8A, 0x0A, 0x71, 0xB0, 0x13, 0x06, 0xB0, 0xB7, 0x30, 0x2B, 0x70,
  0x3A, 0x0D, 0x50, 0x6B, 0x0B, 0x73, 0x0C, 0xA0, 0x33, 0x82, 0x37, 0x7A, 0xA0, 0x96, 0x06, 0xB0,
  0xB7, 0x20, 0xAA, 0x83, 0xA7, 0x73, 0x7D, 0x08, 0x70, 0x6B, 0x0B, 0x71, 0x08, 0xD0, 0x07, 0xD0,
  0x87, 0x10, 0x6B, 0x0B, 0x70, 0x8D, 0x83, 0x73, 0x77, 0xAA, 0x0A, 0x72, 0x06, 0xB0, 0xB6, 0x09,
  0xA8, 0x2A, 0x77, 0x33, 0x03, 0xA0, 0xC7, 0x30, 0x6B, 0x0B, 0x50, 0xCA, 0x03, 0x7B, 0x02, 0x73,
  0x06, 0xB0, 0xB4, 0x0C, 0xA7, 0x10, 0xAA, 0x08, 0x74, 0x06, 0xB0, 0xB3, 0x81, 0x1C, 0xA7, 0x10,
  0x4B, 0x01, 0x74, 0x06, 0xB0, 0xB3, 0x01, 0x03, 0x72, 0x0C, 0xA0, 0xC7, 0x50, 0x6B, 0x0B, 0x76,
  0x03, 0xB0, 0xA7, 0x50, 0x6B, 0x0B, 0x76, 0x06, 0xB0, 0xC0, 0x17, 0x30, 0x20, 0xDB, 0x0B, 0x76,
  0x08, 0xC0, 0x80, 0x26, 0x81, 0x18, 0xED, 0x0B, 0x76, 0x06, 0xD8, 0x4D, 0x98, 0x89, 0xDD, 0x0A,
  0xB0, 0xB7, 0x60, 0x30, 0xCF, 0xD8, 0x2C, 0x30, 0x6B, 0x06, 0x77, 0x04, 0x0A, 0xF9, 0x0A, 0x04,
  0x48, 0x16, 0xF9, 0x77, 0x40, 0x30, 0xAA, 0x0A, 0x03, 0x71, 0x03, 0x77, 0x60, 0x7A, 0x07, 0x77,
  0x77, 0x20, 0x7A, 0x07, 0x77, 0x77, 0x28, 0x23, 0x77, 0x37, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_location_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_location_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_location_searching 36x36, 4-bit Alpha,  RLE, 241 bytes.
static const unsigned char ic_sharp_36_device_location_searching_data[] PROGMEM = {
  0x77, 0x18, 0x23, 0x77, 0x37, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77,
  0x71, 0x03, 0x0A, 0xA0, 0xA0, 0x37, 0x77, 0x40, 0x40, 0xAF, 0x90, 0xA0, 0x47, 0x76, 0x03, 0x0C,
  0xFD, 0x0C, 0x03, 0x77, 0x30, 0x6D, 0x84, 0xD9, 0x88, 0x9D, 0xD0, 0x67, 0x71, 0x08, 0xC0, 0x80,
  0x26, 0x02, 0x08, 0xC0, 0x87, 0x60, 0x6B, 0x0C, 0x01, 0x73, 0x01, 0x0C, 0xB0, 0x67, 0x40, 0x3B,
  0x0A, 0x77, 0x0A, 0xB0, 0x37, 0x30, 0xCA, 0x0C, 0x77, 0x20, 0xCA, 0x0C, 0x72, 0x04, 0xB0, 0x17,
  0x72, 0x01, 0xB0, 0x47, 0x10, 0xAA, 0x08, 0x77, 0x40, 0x8A, 0x0A, 0x71, 0xB0, 0x27, 0x74, 0x02,
  0xB7, 0x03, 0xA0, 0xC7, 0x76, 0x0C, 0xA0, 0x33, 0x82, 0x37, 0x7A, 0xA0, 0xA7, 0x76, 0x0A, 0xA8,
  0x3A, 0x77, 0x37, 0xD0, 0x87, 0x76, 0x08, 0xD0, 0x07, 0xD0, 0x87, 0x76, 0x08, 0xD8, 0x37, 0x37,
  0x7A, 0xA0, 0xA7, 0x76, 0x0A, 0xA8, 0x2A, 0x77, 0x33, 0x03, 0xA0, 0xC7, 0x76, 0x0C, 0xA0, 0x37,
  0xB0, 0x27, 0x74, 0x02, 0xB7, 0x10, 0xAA, 0x08, 0x77, 0x40, 0x8A, 0x0A, 0x71, 0x04, 0xB0, 0x17,
  0x72, 0x01, 0xB0, 0x47, 0x20, 0xCA, 0x0C, 0x77, 0x20, 0xCA, 0x0C, 0x73, 0x03, 0xB0, 0xA7, 0x70,
  0xAB, 0x03, 0x74, 0x06, 0xB0, 0xC0, 0x17, 0x30, 0x10, 0xCB, 0x06, 0x76, 0x08, 0xC0, 0x80, 0x26,
  0x02, 0x08, 0xC0, 0x87, 0x71, 0x06, 0xD8, 0x4D, 0x98, 0x89, 0xDD, 0x06, 0x77, 0x30, 0x30, 0xCF,
  0xD0, 0xC0, 0x37, 0x76, 0x04, 0x0A, 0xF9, 0x0A, 0x04, 0x77, 0x74, 0x03, 0x0A, 0xA0, 0xA0, 0x37,
  0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x82, 0x37, 0x73, 0x77,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_location_searching() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_location_searching_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_lte_mobiledata 36x36, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_36_device_lte_mobiledata_data[] PROGMEM = {
  0xB4, 0x07, 0xF9, 0x07, 0x1F, 0x07, 0xB4, 0x07, 0xF9, 0x07, 0x1F, 0x07, 0xB4, 0x07, 0xF9, 0x07,
  0x1F, 0x07, 0xB7, 0x07, 0xA0, 0x74, 0xB5, 0xB7, 0x07, 0xA0, 0x74, 0xB8, 0x00, 0x70, 0x3B, 0x70,
  0x7A, 0x07, 0x4F, 0x07, 0xB7, 0x07, 0xA0, 0x74, 0xF0, 0x7B, 0x70, 0x7A, 0x07, 0x4B, 0x80, 0x07,
  0x03, 0xB7, 0x07, 0xA0, 0x74, 0xB5, 0xF0, 0x72, 0x07, 0xA0, 0x74, 0xF0, 0x7F, 0x07, 0x20, 0x7A,
  0x07, 0x4F, 0x07, 0xF0, 0x72, 0x07, 0xA0, 0x74, 0xF0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_lte_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 31, 23), Box(0, 0, 35, 35),
      ic_sharp_36_device_lte_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_lte_plus_mobiledata 36x36, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_36_device_lte_plus_mobiledata_data[] PROGMEM = {
  0x07, 0xA0, 0x72, 0x07, 0xF9, 0x07, 0x1F, 0x07, 0x73, 0x07, 0xA0, 0x72, 0x07, 0xF9, 0x07, 0x1F,
  0x07, 0x40, 0xF7, 0x30, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x71, 0xF0, 0x74, 0xB3, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x74, 0xB7, 0x2B, 0x30, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x4B, 0x80, 0x07, 0x03, 0x10,
  0xF7, 0xB8, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x4F, 0x07, 0x1F, 0xA0, 0x7A, 0x07, 0x50, 0x7A,
  0x07, 0x4F, 0x07, 0x1F, 0xA0, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x4B, 0x80, 0x07, 0x03, 0x10, 0xF7,
  0xB8, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x4B, 0x72, 0xB3, 0x07, 0xF1, 0x07, 0xA0, 0x74, 0xF0,
  0x74, 0xB3, 0x07, 0xF1, 0x07, 0xA0, 0x74, 0xF0, 0x74, 0x0F, 0x73, 0x07, 0xF1, 0x07, 0xA0, 0x74,
  0xF0, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_lte_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 12, 35, 23), Box(0, 0, 35, 35),
      ic_sharp_36_device_lte_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_macro_off 36x36, 4-bit Alpha,  RLE, 275 bytes.
static const unsigned char ic_sharp_36_device_macro_off_data[] PROGMEM = {
  0x77, 0x82, 0x26, 0x62, 0x77, 0x74, 0x07, 0xC0, 0x77, 0x77, 0x20, 0x3E, 0x03, 0x74, 0x02, 0x07,
  0x78, 0x11, 0x09, 0xE0, 0x97, 0x38, 0x22, 0xEF, 0x74, 0x0A, 0xA0, 0x0D, 0xE8, 0x4D, 0xCF, 0xEA,
  0x15, 0x09, 0xB0, 0x73, 0x04, 0xFF, 0x90, 0xC6, 0x0B, 0xB0, 0x73, 0x04, 0xFF, 0x90, 0x56, 0x0B,
  0xB0, 0x73, 0x04, 0xB8, 0x29, 0x55, 0x9F, 0x08, 0x70, 0xBB, 0x07, 0x38, 0x14, 0xE4, 0x40, 0x4E,
  0x07, 0x71, 0x0B, 0xB0, 0x73, 0x02, 0x60, 0x9C, 0x0E, 0x01, 0x72, 0x0B, 0xB0, 0x77, 0x20, 0x5B,
  0x0E, 0x04, 0x74, 0x0B, 0xB0, 0x77, 0x10, 0x5B, 0x0D, 0x03, 0x74, 0x01, 0xC0, 0x77, 0x09, 0xC0,
  0xE0, 0x17, 0x30, 0x7D, 0x07, 0x50, 0x4E, 0x07, 0x73, 0x08, 0xE0, 0x73, 0x01, 0x0E, 0xE0, 0x87,
  0x30, 0x5F, 0x07, 0x30, 0x4E, 0x05, 0x74, 0x0C, 0xF0, 0x73, 0x04, 0xC0, 0xD7, 0x50, 0x10, 0xAA,
  0x0C, 0x0D, 0xB0, 0x73, 0x04, 0xA0, 0xA0, 0x17, 0x82, 0x36, 0x42, 0x48, 0x11, 0x09, 0xC0, 0x73,
  0x01, 0x48, 0x22, 0x56, 0x32, 0x06, 0xB8, 0x1C, 0x71, 0x30, 0x3D, 0x07, 0x48, 0x11, 0x8D, 0xB0,
  0x62, 0x04, 0xD0, 0xE0, 0x73, 0x07, 0xD0, 0x73, 0x04, 0xD0, 0x52, 0x02, 0xF0, 0xC0, 0x12, 0x81,
  0x26, 0xBB, 0x07, 0x30, 0x4C, 0x02, 0x30, 0xCF, 0x0D, 0x02, 0x40, 0xAB, 0x07, 0x30, 0x4A, 0x0D,
  0x40, 0x7F, 0x90, 0xD0, 0x14, 0x0A, 0xB0, 0x73, 0x81, 0x4F, 0x84, 0x01, 0x0E, 0xF9, 0x0A, 0x40,
  0xAC, 0x07, 0x30, 0x40, 0x15, 0x07, 0xFA, 0x04, 0x20, 0x4E, 0x07, 0x73, 0x0C, 0xF9, 0x0C, 0x20,
  0xCF, 0x07, 0x72, 0x01, 0x0D, 0xF9, 0x02, 0x03, 0xFA, 0x07, 0x72, 0x02, 0x0D, 0xF0, 0x07, 0xFB,
  0x07, 0x73, 0x0A, 0xE0, 0x0B, 0xE0, 0xA0, 0xBB, 0x07, 0x73, 0x04, 0x0C, 0xC0, 0x0D, 0xC0, 0xC0,
  0x42, 0x0A, 0xB0, 0x77, 0x48, 0x90, 0x27, 0xBD, 0xDE, 0xDB, 0x73, 0x58, 0x2A, 0xFE, 0x27, 0x77,
  0x60, 0x90, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_macro_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 31, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_macro_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_media_bluetooth_off 36x36, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_sharp_36_device_media_bluetooth_off_data[] PROGMEM = {
  0x10, 0x20, 0x67, 0x10, 0x38, 0x04, 0x70, 0x37, 0x38, 0x22, 0xEF, 0x77, 0x07, 0xF9, 0x07, 0x73,
  0x09, 0xB0, 0x76, 0x07, 0xF9, 0x07, 0x74, 0x0B, 0xB0, 0x75, 0x07, 0xF9, 0x07, 0x75, 0x0B, 0xB0,
  0x74, 0x07, 0xF9, 0x07, 0x76, 0x0B, 0xB0, 0x73, 0x03, 0xF9, 0x07, 0x77, 0x0B, 0xB0, 0x73, 0x81,
  0x4F, 0xB8, 0x01, 0x70, 0x37, 0x71, 0x0B, 0xB0, 0x73, 0x04, 0x07, 0x77, 0x71, 0x0B, 0xB0, 0x77,
  0x77, 0x60, 0xAB, 0x07, 0x76, 0x07, 0x01, 0x75, 0x0A, 0xB0, 0x77, 0x59, 0x0C, 0x01, 0x75, 0x0A,
  0xB0, 0x77, 0x4A, 0x0C, 0x01, 0x75, 0x0A, 0xB0, 0x75, 0x07, 0x03, 0x3B, 0x0C, 0x01, 0x75, 0x0B,
  0xB0, 0x73, 0x82, 0x2F, 0xE3, 0x29, 0x83, 0xBA, 0xFC, 0x17, 0x40, 0x7C, 0x07, 0x38, 0x91, 0x4F,
  0xE3, 0x0F, 0xB0, 0xCF, 0xB6, 0x84, 0x25, 0x75, 0x17, 0xD0, 0x73, 0x89, 0x04, 0xFE, 0x3F, 0xB6,
  0xFE, 0x34, 0x01, 0x0A, 0xD0, 0xDE, 0x07, 0x38, 0x64, 0xFE, 0xFE, 0xFE, 0x34, 0x01, 0x0D, 0xFA,
  0x08, 0x0B, 0xB0, 0x73, 0x04, 0xB0, 0xE0, 0x35, 0x0A, 0xFB, 0x81, 0x70, 0xBB, 0x07, 0x30, 0x4A,
  0x05, 0x50, 0x2F, 0xC0, 0x72, 0x0B, 0xB0, 0x73, 0x82, 0x4F, 0xE3, 0x40, 0x6F, 0xC0, 0x73, 0x0A,
  0xB0, 0x73, 0x82, 0x4F, 0xE3, 0x30, 0x7F, 0xC0, 0x74, 0x0A, 0xB0, 0x73, 0x82, 0x4F, 0xE3, 0x20,
  0x6F, 0xC0, 0x65, 0x0C, 0xB0, 0x73, 0x81, 0x4F, 0xB2, 0x02, 0xFC, 0x02, 0x40, 0x3D, 0x07, 0x30,
  0x30, 0x13, 0x0A, 0xFA, 0x0A, 0x68, 0x16, 0x3A, 0xB0, 0x77, 0x01, 0x0D, 0xF0, 0xD0, 0x17, 0x20,
  0xAB, 0x07, 0x70, 0x10, 0xAD, 0x0A, 0x01, 0x74, 0x0A, 0xB0, 0x77, 0x18, 0x31, 0x57, 0x52, 0x77,
  0x0A, 0xB0, 0x77, 0x77, 0x68, 0x2A, 0xFE, 0x27, 0x77, 0x70, 0x90, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_media_bluetooth_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 32, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_media_bluetooth_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_media_bluetooth_on 36x36, 4-bit Alpha,  RLE, 216 bytes.
static const unsigned char ic_sharp_36_device_media_bluetooth_on_data[] PROGMEM = {
  0x72, 0x03, 0x80, 0x47, 0x03, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x74, 0x07, 0xF9, 0x07, 0x77, 0x40,
  0x7F, 0x90, 0x77, 0x74, 0x07, 0xF9, 0x07, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x74, 0x07, 0xA0, 0xB8,
  0x01, 0x70, 0x37, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77,
  0x10, 0x04, 0x77, 0x07, 0xA0, 0x77, 0x18, 0x18, 0xF5, 0x76, 0x07, 0xA0, 0x77, 0x10, 0x8A, 0x05,
  0x75, 0x07, 0xA0, 0x73, 0x01, 0x08, 0x30, 0x8B, 0x05, 0x74, 0x07, 0xA0, 0x73, 0x81, 0xAF, 0x92,
  0x84, 0x8F, 0x7E, 0xF5, 0x73, 0x07, 0xA0, 0x73, 0x87, 0x1C, 0xF9, 0x08, 0xF3, 0x5A, 0x03, 0x48,
  0x42, 0x57, 0x51, 0x7A, 0x07, 0x48, 0x90, 0x1C, 0xF9, 0x8F, 0x5C, 0xF9, 0x30, 0x10, 0xAD, 0x0D,
  0xA0, 0x75, 0x86, 0x1C, 0xFE, 0xFE, 0xF9, 0x30, 0x10, 0xDF, 0xA0, 0x76, 0x01, 0x0C, 0xB0, 0x94,
  0x0A, 0xFB, 0x07, 0x70, 0x2A, 0x0D, 0x40, 0x2F, 0xC0, 0x76, 0x01, 0x0C, 0xB0, 0x93, 0x06, 0xFC,
  0x07, 0x58, 0x61, 0xCF, 0xEF, 0xEF, 0x92, 0x07, 0xFC, 0x07, 0x48, 0x92, 0x1C, 0xF9, 0x8F, 0x5C,
  0xF9, 0x06, 0xFC, 0x06, 0x38, 0x71, 0xCF, 0x90, 0x8F, 0x35, 0xA0, 0x30, 0x2F, 0xC0, 0x23, 0x81,
  0xAF, 0x92, 0x84, 0x8F, 0x7E, 0xF5, 0x20, 0xAF, 0xA0, 0xA4, 0x01, 0x08, 0x30, 0x8B, 0x05, 0x30,
  0x10, 0xDF, 0x0D, 0x01, 0x72, 0x08, 0xA0, 0x55, 0x01, 0x0A, 0xD0, 0xA0, 0x17, 0x38, 0x18, 0xF5,
  0x71, 0x83, 0x25, 0x75, 0x27, 0x50, 0x04, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_media_bluetooth_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_media_bluetooth_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_medication_liquid 36x36, 4-bit Alpha,  RLE, 224 bytes.
static const unsigned char ic_sharp_36_device_medication_liquid_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x57, 0x03, 0x76, 0x07, 0xFF, 0xB0, 0x77, 0x60, 0x7F, 0xFB, 0x07, 0x76, 0x03,
  0x80, 0x95, 0x70, 0x38, 0x0D, 0x10, 0x08, 0x0D, 0xFF, 0x90, 0xD0, 0x84, 0x84, 0x19, 0xEE, 0x91,
  0x20, 0x8F, 0xFD, 0x08, 0x20, 0x10, 0xDC, 0x82, 0xD1, 0x0D, 0xFF, 0xD0, 0xD2, 0x0A, 0xE0, 0xA1,
  0xB7, 0x71, 0xB1, 0x01, 0xB0, 0x04, 0xB0, 0x1B, 0x77, 0x1B, 0x10, 0x5A, 0x0B, 0x20, 0xBA, 0x05,
  0xB5, 0x83, 0x8B, 0xBB, 0x85, 0xB1, 0x07, 0xA0, 0x82, 0x08, 0xA0, 0x7B, 0x50, 0xBB, 0x0B, 0x5B,
  0x10, 0x6A, 0x08, 0x20, 0x8A, 0x06, 0xB5, 0x0B, 0xB0, 0xB5, 0xB1, 0x05, 0xA0, 0xB2, 0x0B, 0xA0,
  0x5B, 0x50, 0xBB, 0x0B, 0x5B, 0x10, 0x1B, 0x00, 0x4B, 0x01, 0xB1, 0x07, 0xFC, 0x07, 0x1B, 0x20,
  0x9E, 0x09, 0x1B, 0x10, 0x7F, 0xC0, 0x71, 0xB3, 0x0D, 0xC0, 0xD2, 0xB1, 0x07, 0xFC, 0x07, 0x1B,
  0x40, 0xBA, 0x0B, 0x3B, 0x10, 0x7F, 0xC0, 0x71, 0xB4, 0x07, 0xA0, 0x73, 0xB1, 0x83, 0x37, 0x77,
  0xDB, 0x83, 0xD7, 0x77, 0x31, 0xB4, 0x07, 0xA0, 0x73, 0xB5, 0x0B, 0xB0, 0xB5, 0xB4, 0x07, 0xA0,
  0x73, 0xB5, 0x0B, 0xB0, 0xB5, 0xB4, 0x07, 0xA0, 0x73, 0xB5, 0x0B, 0xB0, 0xB5, 0xB4, 0x07, 0xA0,
  0x73, 0xB5, 0x83, 0x23, 0x33, 0x25, 0xB4, 0x07, 0xA0, 0x73, 0xB7, 0x71, 0xB4, 0x07, 0xA0, 0x73,
  0xB8, 0x09, 0x37, 0xB4, 0x07, 0xA0, 0x73, 0x0B, 0xFF, 0xD0, 0xB4, 0x07, 0xA0, 0x73, 0x03, 0x0E,
  0xFF, 0xB0, 0xE0, 0x34, 0x05, 0xA0, 0x54, 0x01, 0x06, 0x80, 0x93, 0x70, 0x60, 0x16, 0x00, 0x54,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_medication_liquid() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 34, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_medication_liquid_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_medication 36x36, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_sharp_36_device_medication_data[] PROGMEM = {
  0x28, 0x09, 0x67, 0x4F, 0xFC, 0x4F, 0xFC, 0x48, 0x09, 0x67, 0x77, 0x73, 0x07, 0xFF, 0xE0, 0x07,
  0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xF8, 0x4C, 0x33, 0x33,
  0xCF, 0x00, 0x7F, 0x0B, 0x40, 0xBF, 0x00, 0x7F, 0x0B, 0x40, 0xBF, 0x00, 0x7F, 0x0B, 0x40, 0xBF,
  0x00, 0x7C, 0x75, 0xC0, 0x07, 0xC7, 0x5C, 0x00, 0x7C, 0x75, 0xC0, 0x07, 0xC7, 0x5C, 0x00, 0x7C,
  0x0F, 0x70, 0x54, 0x05, 0x0F, 0x7C, 0x00, 0x7F, 0x0B, 0x40, 0xBF, 0x00, 0x7F, 0x0B, 0x40, 0xBF,
  0x00, 0x7F, 0x0B, 0x40, 0xBF, 0x00, 0x7F, 0x84, 0xEB, 0xBB, 0xBE, 0xF0, 0x07, 0xFF, 0xE0, 0x07,
  0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x70, 0x38, 0x0A, 0x07, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_medication() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 28, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_medication_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_mobiledata_off 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_sharp_36_device_mobiledata_off_data[] PROGMEM = {
  0x10, 0x20, 0x77, 0x73, 0x03, 0x72, 0x82, 0x2E, 0xF7, 0x77, 0x18, 0x17, 0xF7, 0x71, 0x09, 0xB0,
  0x77, 0x60, 0x7B, 0x07, 0x71, 0x0B, 0xB0, 0x77, 0x40, 0x7D, 0x07, 0x71, 0x0B, 0xB0, 0x77, 0x20,
  0x7F, 0x07, 0x71, 0x0B, 0xB0, 0x77, 0x07, 0xFA, 0x07, 0x71, 0x0B, 0xB0, 0x75, 0x01, 0x80, 0x07,
  0xB8, 0x00, 0x70, 0x17, 0x10, 0xBB, 0x07, 0x72, 0xB7, 0x70, 0xBB, 0x07, 0x71, 0xB7, 0x71, 0x0B,
  0xB0, 0x77, 0xB7, 0x72, 0x0B, 0xB0, 0x76, 0xB7, 0x73, 0x0B, 0xB0, 0x75, 0xB7, 0x74, 0xC0, 0x74,
  0xB7, 0x74, 0xD0, 0x73, 0x04, 0xA7, 0x74, 0xE0, 0x73, 0x04, 0x97, 0x74, 0xB0, 0xBB, 0x07, 0x30,
  0x47, 0x74, 0xB1, 0x0B, 0xB0, 0x77, 0x77, 0xB2, 0x0B, 0xB0, 0x77, 0x76, 0xB3, 0x0B, 0xB0, 0x77,
  0x75, 0xB4, 0x0B, 0xB0, 0x77, 0x74, 0xB5, 0x0B, 0xB0, 0x77, 0x50, 0x28, 0x00, 0x7B, 0x80, 0x07,
  0x81, 0x10, 0xBB, 0x07, 0x75, 0x08, 0xFA, 0x07, 0x30, 0xBB, 0x07, 0x75, 0x08, 0xF0, 0x75, 0x0B,
  0xB0, 0x77, 0x50, 0x7D, 0x07, 0x70, 0xBB, 0x07, 0x75, 0x07, 0xB0, 0x77, 0x20, 0xBB, 0x07, 0x75,
  0x81, 0x7F, 0x77, 0x40, 0xBB, 0x07, 0x75, 0x03, 0x76, 0x0B, 0xB0, 0x77, 0x77, 0x58, 0x2B, 0xFE,
  0x27, 0x77, 0x60, 0x90, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_mobiledata_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 31, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_mobiledata_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_mobile_friendly 36x36, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_sharp_36_device_mobile_friendly_data[] PROGMEM = {
  0x50, 0x38, 0x0A, 0x07, 0x03, 0x50, 0x7F, 0xFE, 0x07, 0x50, 0x7F, 0xFE, 0x07, 0x50, 0x7F, 0xFE,
  0x07, 0x50, 0x7F, 0xFE, 0x07, 0x50, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x72, 0x07,
  0xA0, 0x77, 0x70, 0x67, 0x10, 0x7A, 0x07, 0x76, 0x81, 0xBF, 0x87, 0x07, 0xA0, 0x77, 0x50, 0xBA,
  0x0D, 0x01, 0x60, 0x7A, 0x07, 0x74, 0x0B, 0xA0, 0xD0, 0x17, 0x07, 0xA0, 0x77, 0x30, 0xBA, 0x0D,
  0x01, 0x71, 0x07, 0xA8, 0x17, 0x05, 0x70, 0xBA, 0x0D, 0x01, 0x72, 0x07, 0xA8, 0x27, 0x6F, 0xB5,
  0x0B, 0xA0, 0xD0, 0x17, 0x30, 0x7A, 0x07, 0x0D, 0xA0, 0xB3, 0x0B, 0xA0, 0xD0, 0x17, 0x40, 0x7A,
  0x81, 0x71, 0xDA, 0x81, 0xB1, 0xBA, 0x0D, 0x01, 0x75, 0x07, 0xA8, 0x27, 0x01, 0xDA, 0x0E, 0xA0,
  0xD0, 0x17, 0x60, 0x7A, 0x07, 0x20, 0x10, 0xDB, 0x0D, 0x01, 0x77, 0x07, 0xA0, 0x73, 0x83, 0x1D,
  0xFD, 0x17, 0x71, 0x07, 0xA0, 0x74, 0x81, 0x1B, 0x17, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7A,
  0x07, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x77, 0x07, 0xA0,
  0x75, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x75, 0x07, 0xFF,
  0xE0, 0x75, 0x07, 0xFF, 0xE0, 0x75, 0x07, 0xFF, 0xE0, 0x75, 0x07, 0xFF, 0xE0, 0x75, 0x03, 0x80,
  0xA0, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_mobile_friendly() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 31, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_mobile_friendly_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_mobile_off 36x36, 4-bit Alpha,  RLE, 269 bytes.
static const unsigned char ic_sharp_36_device_mobile_off_data[] PROGMEM = {
  0x50, 0x38, 0x0A, 0x07, 0x03, 0x72, 0x05, 0xFF, 0xE0, 0x76, 0x03, 0x30, 0x6F, 0xFD, 0x07, 0x58,
  0x19, 0xF5, 0x30, 0x6F, 0xFC, 0x07, 0x40, 0x7B, 0x05, 0x30, 0x6F, 0xFB, 0x07, 0x40, 0x10, 0xCB,
  0x05, 0x30, 0x6F, 0xFA, 0x07, 0x50, 0x10, 0xCB, 0x05, 0x30, 0x58, 0x09, 0x07, 0x0B, 0xA0, 0x76,
  0x01, 0x0C, 0xB0, 0x57, 0x71, 0x07, 0xA0, 0x77, 0x01, 0x0C, 0xB0, 0x57, 0x70, 0x7A, 0x07, 0x71,
  0x01, 0x0C, 0xB0, 0x57, 0x60, 0x7A, 0x07, 0x72, 0x07, 0xC0, 0x57, 0x50, 0x7A, 0x07, 0x72, 0x07,
  0xD0, 0x57, 0x40, 0x7A, 0x07, 0x72, 0x07, 0xE0, 0x57, 0x30, 0x7A, 0x07, 0x72, 0x07, 0xA0, 0x90,
  0xCB, 0x05, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x7A, 0x81, 0x71, 0xCB, 0x05, 0x71, 0x07, 0xA0, 0x77,
  0x20, 0x7A, 0x82, 0x70, 0x1C, 0xB0, 0x57, 0x07, 0xA0, 0x77, 0x20, 0x7A, 0x07, 0x20, 0x10, 0xCB,
  0x05, 0x60, 0x7A, 0x07, 0x72, 0x07, 0xA0, 0x73, 0x01, 0x0C, 0xB0, 0x55, 0x07, 0xA0, 0x77, 0x20,
  0x7A, 0x07, 0x40, 0x10, 0xCB, 0x05, 0x40, 0x7A, 0x07, 0x72, 0x07, 0xA0, 0x75, 0x01, 0x0C, 0xB0,
  0x53, 0x05, 0xA0, 0x77, 0x20, 0x7A, 0x07, 0x60, 0x10, 0xCB, 0x05, 0x38, 0x16, 0xF7, 0x72, 0x07,
  0xA0, 0x77, 0x01, 0x0C, 0xB0, 0x53, 0x06, 0x07, 0x72, 0x07, 0xA0, 0x77, 0x10, 0x10, 0xCB, 0x05,
  0x30, 0x17, 0x20, 0x7A, 0x07, 0x72, 0x01, 0x0C, 0xB0, 0x57, 0x50, 0x7A, 0x07, 0x73, 0x01, 0x0C,
  0xB0, 0x57, 0x40, 0x7A, 0x07, 0x74, 0x01, 0x0C, 0xB0, 0x57, 0x30, 0x7A, 0x07, 0x75, 0x01, 0x0C,
  0xB0, 0x57, 0x20, 0x7A, 0x0B, 0x80, 0x91, 0x70, 0x9C, 0x05, 0x71, 0x07, 0xFF, 0xF9, 0x05, 0x70,
  0x7F, 0xFF, 0xA0, 0x56, 0x07, 0xFF, 0xFB, 0x05, 0x50, 0x7F, 0xFE, 0x09, 0x0C, 0xA0, 0xD5, 0x07,
  0xFF, 0xE8, 0x37, 0x1C, 0xD1, 0x50, 0x38, 0x0A, 0x07, 0x82, 0x30, 0x11, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_mobile_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 32, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_mobile_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_mode_night 36x36, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_sharp_36_device_mode_night_data[] PROGMEM = {
  0x28, 0x90, 0x27, 0xAD, 0xEF, 0xDB, 0x94, 0x74, 0x05, 0x0C, 0xFB, 0x81, 0xE9, 0x17, 0x10, 0x8F,
  0xE0, 0xE0, 0x77, 0x10, 0x30, 0xEF, 0xE0, 0xB7, 0x10, 0x20, 0xEF, 0xE0, 0xC0, 0x17, 0x03, 0x0E,
  0xFE, 0x0B, 0x71, 0x06, 0xFF, 0x08, 0x71, 0x0C, 0xFF, 0x02, 0x70, 0x4F, 0xF0, 0xB7, 0x10, 0xCF,
  0xF0, 0x27, 0x07, 0xFF, 0x07, 0x70, 0x2F, 0xF0, 0xC7, 0x10, 0xEF, 0xF7, 0x10, 0xDF, 0xF0, 0x17,
  0x0C, 0xFF, 0x03, 0x70, 0xCF, 0xF0, 0x37, 0x0D, 0xFF, 0x01, 0x70, 0xEF, 0xF7, 0x02, 0xFF, 0x0C,
  0x70, 0x7F, 0xF0, 0x77, 0x0C, 0xFF, 0x02, 0x60, 0x4F, 0xF0, 0xB7, 0x0C, 0xFF, 0x02, 0x60, 0x6F,
  0xF0, 0x86, 0x03, 0x0E, 0xFE, 0x0B, 0x60, 0x20, 0xEF, 0xE0, 0xC0, 0x15, 0x03, 0x0E, 0xFE, 0x0B,
  0x60, 0x8F, 0xE0, 0xE0, 0x77, 0x05, 0x0C, 0xFB, 0x81, 0xE9, 0x17, 0x38, 0x90, 0x27, 0xAD, 0xEF,
  0xDB, 0x94, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_mode_night() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_mode_night_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_mode_standby 36x36, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_sharp_36_device_mode_standby_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x04,
  0x0D, 0xFF, 0x0D, 0x04, 0x74, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x20,
  0x9B, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xB0, 0x97, 0x07, 0xB0, 0xA7, 0x70, 0xAB, 0x07, 0x50, 0x4B,
  0x08, 0x77, 0x20, 0x8B, 0x04, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xAA, 0x0D, 0x30, 0x7A, 0x0D, 0x77,
  0x60, 0xDA, 0x07, 0x20, 0xEA, 0x06, 0x77, 0x60, 0x6A, 0x81, 0xE0, 0x3A, 0x0D, 0x72, 0x82, 0x26,
  0x62, 0x72, 0x0D, 0xA0, 0x30, 0x8A, 0x09, 0x71, 0x0A, 0xC0, 0xA7, 0x10, 0x9A, 0x08, 0x0B, 0xA0,
  0x47, 0x09, 0xE0, 0x97, 0x04, 0xA0, 0xB0, 0xDA, 0x02, 0x60, 0x2F, 0x90, 0x26, 0x02, 0xA0, 0xD0,
  0xEA, 0x70, 0x6F, 0x90, 0x67, 0xA0, 0x0E, 0xA7, 0x06, 0xF9, 0x06, 0x7A, 0x0E, 0x0D, 0xA0, 0x26,
  0x02, 0xF9, 0x02, 0x60, 0x2A, 0x0D, 0x0B, 0xA0, 0x47, 0x09, 0xE0, 0x97, 0x04, 0xA0, 0xB0, 0x8A,
  0x09, 0x71, 0x0A, 0xC0, 0xA7, 0x10, 0x9A, 0x08, 0x03, 0xA0, 0xD7, 0x28, 0x22, 0x66, 0x27, 0x20,
  0xDA, 0x81, 0x30, 0xEA, 0x06, 0x77, 0x60, 0x6A, 0x0E, 0x20, 0x7A, 0x0D, 0x77, 0x60, 0xDA, 0x07,
  0x30, 0xDA, 0x0A, 0x77, 0x40, 0xAA, 0x0D, 0x40, 0x4B, 0x08, 0x77, 0x20, 0x8B, 0x04, 0x50, 0x7B,
  0x0A, 0x77, 0x0A, 0xB0, 0x77, 0x09, 0xB0, 0xD0, 0x67, 0x30, 0x60, 0xDB, 0x09, 0x72, 0x07, 0xC8,
  0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x40, 0x40, 0xDF, 0xF0, 0xD0, 0x47, 0x70, 0x70,
  0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_mode_standby() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_mode_standby_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_monitor_heart 36x36, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_sharp_36_device_monitor_heart_data[] PROGMEM = {
  0x80, 0xA8, 0x5F, 0x0A, 0x09, 0xFF, 0xFE, 0x09, 0x20, 0x9F, 0xFF, 0xD0, 0x12, 0x01, 0x0E, 0xFF,
  0xFB, 0x08, 0x40, 0x8F, 0xFF, 0xB0, 0x14, 0x01, 0x0E, 0xFF, 0xF9, 0x08, 0x20, 0x01, 0x20, 0x8F,
  0x98, 0x05, 0x70, 0xAC, 0x01, 0x20, 0x08, 0x20, 0x18, 0x04, 0x77, 0x30, 0x9A, 0x08, 0x20, 0x1A,
  0x01, 0x77, 0x60, 0x1A, 0x01, 0x20, 0x8A, 0x09, 0x73, 0x80, 0x47, 0x01, 0x20, 0x08, 0x20, 0x1C,
  0x0A, 0x80, 0x57, 0xF9, 0x08, 0x20, 0x01, 0x20, 0x8F, 0xFF, 0xA0, 0x14, 0x01, 0xFF, 0xFB, 0x08,
  0x40, 0x8F, 0xFF, 0xC0, 0x12, 0x01, 0xFF, 0xFD, 0x09, 0x20, 0x9F, 0xFF, 0xE0, 0x0A, 0x80, 0xA8,
  0x5F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_monitor_heart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_monitor_heart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_monitor_weight 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_sharp_36_device_monitor_weight_data[] PROGMEM = {
  0x03, 0x80, 0xA6, 0x70, 0x30, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x00, 0x7F, 0xB8, 0x4B, 0x41, 0x15, 0xCF, 0xB0, 0x07, 0xFA, 0x08, 0x60, 0xAF, 0xA0,
  0x07, 0xF9, 0x0E, 0x01, 0x60, 0x10, 0xEF, 0x90, 0x07, 0xF9, 0x89, 0x0A, 0x03, 0x12, 0x21, 0x30,
  0xAF, 0x90, 0x07, 0xF9, 0x89, 0x08, 0x0F, 0x7B, 0xB7, 0xF0, 0x8F, 0x90, 0x07, 0xF9, 0x89, 0x0A,
  0x03, 0x12, 0x21, 0x30, 0xAF, 0x90, 0x07, 0xF9, 0x0E, 0x01, 0x60, 0x10, 0xEF, 0x90, 0x07, 0xFA,
  0x0A, 0x60, 0x8F, 0xA0, 0x07, 0xFB, 0x84, 0xC5, 0x11, 0x4C, 0xFB, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F,
  0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x38, 0x0A, 0x67, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_monitor_weight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_monitor_weight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_nearby_error 36x36, 4-bit Alpha,  RLE, 236 bytes.
static const unsigned char ic_sharp_36_device_nearby_error_data[] PROGMEM = {
  0x77, 0x10, 0xA0, 0xB7, 0x77, 0x70, 0xAA, 0x0B, 0x77, 0x75, 0x0A, 0xC0, 0xB7, 0x77, 0x30, 0xAE,
  0x0B, 0x77, 0x71, 0x0A, 0xF9, 0x0B, 0x77, 0x60, 0xAC, 0x00, 0xAC, 0x0B, 0x77, 0x40, 0xAC, 0x0A,
  0x20, 0xAC, 0x0B, 0x77, 0x20, 0xAC, 0x0A, 0x40, 0xAC, 0x0B, 0x77, 0x0A, 0xC0, 0xA6, 0x0A, 0xC0,
  0xB7, 0x50, 0xAC, 0x0A, 0x30, 0x03, 0x30, 0xAC, 0x74, 0x0A, 0xC0, 0xA3, 0x82, 0x3E, 0xE3, 0x30,
  0xAB, 0x73, 0x0A, 0xC0, 0xA3, 0x03, 0x0E, 0xA0, 0xE0, 0x33, 0x0A, 0xA7, 0x20, 0xAC, 0x0A, 0x30,
  0x30, 0xEC, 0x0E, 0x03, 0x30, 0xA9, 0x71, 0x0A, 0xC0, 0xA3, 0x03, 0x0E, 0xE0, 0xE0, 0x33, 0x0A,
  0x3B, 0x10, 0xAC, 0x0A, 0x30, 0x30, 0xEF, 0x90, 0xE0, 0x36, 0xB0, 0xAC, 0x0A, 0x30, 0x30, 0xEF,
  0xB0, 0xE0, 0x35, 0xB0, 0xBC, 0x0A, 0x30, 0x30, 0xEF, 0xB0, 0xE0, 0x35, 0xB1, 0x0B, 0xC0, 0xA3,
  0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x6B, 0x20, 0xBC, 0x0A, 0x30, 0x30, 0xEE, 0x0E, 0x03, 0x30, 0xA3,
  0xB3, 0x0B, 0xC0, 0xA3, 0x03, 0x0E, 0xC0, 0xE0, 0x33, 0x0A, 0x93, 0xB4, 0x0B, 0xC0, 0xA3, 0x03,
  0x0E, 0xA0, 0xE0, 0x33, 0x0A, 0xA3, 0xB5, 0x0B, 0xC0, 0xA3, 0x82, 0x3E, 0xE3, 0x30, 0xAB, 0x3B,
  0x60, 0xBC, 0x0A, 0x30, 0x03, 0x30, 0xAC, 0x3B, 0x70, 0xBC, 0x0A, 0x60, 0xAC, 0x0B, 0x3B, 0x71,
  0x0B, 0xC0, 0xA4, 0x0A, 0xC0, 0xB4, 0xB7, 0x20, 0xBC, 0x0A, 0x20, 0xAC, 0x0B, 0x77, 0x40, 0xBC,
  0x00, 0xAC, 0x0B, 0x77, 0x60, 0xBF, 0x90, 0xB7, 0x77, 0x10, 0xBE, 0x0B, 0x71, 0xB7, 0x60, 0xBC,
  0x0B, 0x72, 0xB7, 0x70, 0xBA, 0x0B, 0x73, 0xB7, 0x71, 0x00, 0xB7, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_nearby_error() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 32, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_nearby_error_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_nearby_off 36x36, 4-bit Alpha,  RLE, 280 bytes.
static const unsigned char ic_sharp_36_device_nearby_off_data[] PROGMEM = {
  0x77, 0x10, 0xB0, 0xA7, 0x77, 0x71, 0x0B, 0xA0, 0xA7, 0x71, 0x02, 0x06, 0x73, 0x0B, 0xC0, 0xA7,
  0x68, 0x22, 0xEF, 0x77, 0x10, 0xBE, 0x0A, 0x75, 0x09, 0xB0, 0x76, 0x0B, 0xF9, 0x0A, 0x75, 0x0B,
  0xB0, 0x74, 0x0A, 0xC0, 0x0A, 0xC0, 0xA7, 0x50, 0xBB, 0x07, 0x30, 0x4B, 0x0A, 0x20, 0xAC, 0x0A,
  0x75, 0x0B, 0xB0, 0x73, 0x81, 0x4F, 0xA4, 0x0A, 0xC0, 0xA7, 0x50, 0xBB, 0x07, 0x30, 0x36, 0x0A,
  0xC0, 0xA7, 0x50, 0xBB, 0x07, 0x50, 0x03, 0x30, 0xAC, 0x0A, 0x74, 0x0B, 0xC0, 0x74, 0x81, 0xDE,
  0x33, 0x0A, 0xC0, 0xA7, 0x20, 0xBE, 0x07, 0x38, 0x24, 0xFE, 0x33, 0x0A, 0xC0, 0xA7, 0x0B, 0xC0,
  0xEB, 0x07, 0x38, 0x24, 0xFE, 0x33, 0x0A, 0xC0, 0xA5, 0x0B, 0xC8, 0x1A, 0x0B, 0xB0, 0x73, 0x82,
  0x4F, 0xE3, 0x30, 0xAC, 0x0A, 0x30, 0xBC, 0x0A, 0x30, 0xBB, 0x07, 0x38, 0x24, 0xFE, 0x33, 0x0A,
  0xC8, 0x1A, 0x0B, 0xC0, 0xA3, 0x03, 0x0E, 0xC0, 0x73, 0x82, 0x4F, 0xE3, 0x30, 0xAC, 0x00, 0xAC,
  0x0A, 0x30, 0x30, 0xED, 0x07, 0x38, 0x14, 0xD3, 0x30, 0xAC, 0x81, 0xB0, 0xAC, 0x0A, 0x30, 0x30,
  0xED, 0x07, 0x70, 0xAC, 0x0B, 0x30, 0xAC, 0x0A, 0x30, 0x30, 0xED, 0x07, 0x50, 0xAC, 0x0B, 0x50,
  0xAC, 0x0A, 0x30, 0x30, 0xED, 0x07, 0x30, 0x3C, 0x0B, 0x70, 0xAC, 0x0A, 0x30, 0x30, 0xED, 0x07,
  0x30, 0x4A, 0x0B, 0x72, 0x0A, 0xC0, 0xA3, 0x82, 0x3E, 0xEB, 0xB0, 0x73, 0x04, 0x0A, 0x74, 0x0A,
  0xC0, 0xA3, 0x82, 0x33, 0x0B, 0xB0, 0x77, 0x72, 0x0A, 0xC0, 0xA6, 0x0E, 0xB0, 0x77, 0x72, 0x0A,
  0xC0, 0xA4, 0x0A, 0xD0, 0x77, 0x72, 0x0A, 0xC0, 0xA2, 0x0A, 0xF0, 0x77, 0x72, 0x0A, 0xC0, 0x0A,
  0xC0, 0x0B, 0xB0, 0x77, 0x72, 0x0A, 0xF9, 0x0B, 0x20, 0xBB, 0x07, 0x77, 0x20, 0xAE, 0x0B, 0x40,
  0xBB, 0x07, 0x77, 0x20, 0xAC, 0x0B, 0x60, 0xAB, 0x07, 0x77, 0x20, 0xAA, 0x0B, 0x71, 0x82, 0xAF,
  0xE2, 0x77, 0x30, 0xA0, 0xB7, 0x30, 0x90, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_nearby_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 33, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_nearby_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_network_cell 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_sharp_36_device_network_cell_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x77, 0x77, 0x70, 0x79, 0x77, 0x76, 0x07, 0xA7, 0x77, 0x50, 0x7B, 0x77, 0x74,
  0x07, 0xC7, 0x77, 0x30, 0x7D, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x10, 0x7B, 0x0B, 0xB7, 0x77, 0x07,
  0xB0, 0xB1, 0xB7, 0x76, 0x07, 0xB0, 0xB2, 0xB7, 0x75, 0x07, 0xB0, 0xB3, 0xB7, 0x74, 0x07, 0xB0,
  0xB4, 0xB7, 0x73, 0x07, 0xC0, 0x74, 0xB7, 0x72, 0x07, 0xD0, 0x74, 0xB7, 0x71, 0x07, 0xE0, 0x74,
  0xB7, 0x70, 0x7F, 0x07, 0x4B, 0x76, 0x07, 0xF9, 0x07, 0x4B, 0x75, 0x07, 0xFA, 0x07, 0x4B, 0x74,
  0x07, 0xFB, 0x07, 0x4B, 0x73, 0x07, 0xFC, 0x07, 0x4B, 0x72, 0x07, 0xFD, 0x07, 0x4B, 0x71, 0x07,
  0xFE, 0x07, 0x4B, 0x70, 0x7F, 0xF0, 0x74, 0xB6, 0x07, 0xFF, 0x90, 0x74, 0xB5, 0x07, 0xFF, 0xA0,
  0x74, 0xB4, 0x07, 0xFF, 0xB0, 0x74, 0xB3, 0x07, 0xFF, 0xC0, 0x74, 0xB2, 0x07, 0xFF, 0xFE, 0x10,
  0x7F, 0xFF, 0xF0, 0x7F, 0xFF, 0xF9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_network_cell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_network_cell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_network_wifi_1_bar 36x36, 4-bit Alpha,  RLE, 218 bytes.
static const unsigned char ic_sharp_36_device_network_wifi_1_bar_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAE, 0x83, 0xB7, 0x43, 0x12, 0x83,
  0x13, 0x47, 0xBE, 0x0A, 0x02, 0x70, 0x60, 0xEC, 0x0B, 0x04, 0x77, 0x04, 0x0B, 0xC0, 0xE0, 0x64,
  0x01, 0x0A, 0xC0, 0x90, 0x27, 0x74, 0x02, 0x09, 0xC8, 0x3A, 0x10, 0x1C, 0xB0, 0xD0, 0x37, 0x77,
  0x10, 0x30, 0xDB, 0x81, 0xC1, 0xBB, 0x0B, 0x77, 0x75, 0x0B, 0xB8, 0x1B, 0x1D, 0xB0, 0x47, 0x77,
  0x30, 0x4B, 0x83, 0xD1, 0x01, 0xDB, 0x04, 0x77, 0x71, 0x04, 0xB0, 0xD0, 0x13, 0x01, 0x0D, 0xB0,
  0x47, 0x76, 0x04, 0xB0, 0xD0, 0x15, 0x01, 0x0D, 0xB0, 0x47, 0x74, 0x04, 0xB0, 0xD0, 0x17, 0x01,
  0x0D, 0xB0, 0x47, 0x72, 0x04, 0xB0, 0xD0, 0x17, 0x20, 0x10, 0xDB, 0x04, 0x77, 0x04, 0xB0, 0xD0,
  0x17, 0x40, 0x10, 0xDB, 0x04, 0x75, 0x04, 0xB0, 0xD0, 0x17, 0x60, 0x10, 0xDB, 0x83, 0x40, 0x5A,
  0xDA, 0x83, 0xDA, 0x50, 0x4B, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xDB, 0x0E, 0xF9, 0x0E, 0xB0, 0xD0,
  0x17, 0x73, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xD0, 0xD0, 0x17, 0x77, 0x01,
  0x0D, 0xFB, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x74, 0x01, 0x0D, 0xE0,
  0xD0, 0x17, 0x77, 0x60, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x10, 0xDA, 0x0D, 0x01, 0x77,
  0x77, 0x38, 0x21, 0xDD, 0x17, 0x77, 0x75, 0x00, 0x17, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_network_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_network_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_network_wifi_2_bar 36x36, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_sharp_36_device_network_wifi_2_bar_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAE, 0x83, 0xB7, 0x43, 0x12, 0x83,
  0x13, 0x47, 0xBE, 0x0A, 0x02, 0x70, 0x60, 0xEC, 0x0B, 0x04, 0x77, 0x04, 0x0B, 0xC0, 0xE0, 0x64,
  0x01, 0x0A, 0xC0, 0x90, 0x27, 0x74, 0x02, 0x09, 0xC8, 0x3A, 0x10, 0x1C, 0xB0, 0xD0, 0x37, 0x77,
  0x10, 0x30, 0xDB, 0x81, 0xC1, 0xBB, 0x0B, 0x77, 0x75, 0x0B, 0xB8, 0x1B, 0x1D, 0xB0, 0x47, 0x77,
  0x30, 0x4B, 0x83, 0xD1, 0x01, 0xDB, 0x04, 0x77, 0x71, 0x04, 0xB0, 0xD0, 0x13, 0x01, 0x0D, 0xB0,
  0x47, 0x76, 0x04, 0xB0, 0xD0, 0x15, 0x01, 0x0D, 0xB0, 0x47, 0x74, 0x04, 0xB0, 0xD0, 0x17, 0x01,
  0x0D, 0xB0, 0x43, 0x82, 0x38, 0xBD, 0xA8, 0x2D, 0xB8, 0x33, 0x04, 0xB0, 0xD0, 0x17, 0x20, 0x10,
  0xDB, 0x81, 0x44, 0xCF, 0xB8, 0x1C, 0x44, 0xB0, 0xD0, 0x17, 0x40, 0x10, 0xDF, 0xFE, 0x0D, 0x01,
  0x76, 0x01, 0x0D, 0xFF, 0xC0, 0xD0, 0x17, 0x71, 0x01, 0x0D, 0xFF, 0xA0, 0xD0, 0x17, 0x73, 0x01,
  0x0D, 0xFF, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xD0, 0xD0, 0x17, 0x77, 0x01, 0x0D, 0xFB, 0x0D,
  0x01, 0x77, 0x72, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x74, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x77,
  0x60, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x10, 0xDA, 0x0D, 0x01, 0x77, 0x77, 0x38, 0x21,
  0xDD, 0x17, 0x77, 0x75, 0x00, 0x17, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_network_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_network_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_network_wifi_3_bar 36x36, 4-bit Alpha,  RLE, 216 bytes.
static const unsigned char ic_sharp_36_device_network_wifi_3_bar_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAE, 0x83, 0xB7, 0x43, 0x12, 0x83,
  0x13, 0x47, 0xBE, 0x0A, 0x02, 0x70, 0x60, 0xEC, 0x0B, 0x04, 0x77, 0x04, 0x0B, 0xC0, 0xE0, 0x64,
  0x01, 0x0A, 0xC0, 0x90, 0x27, 0x74, 0x02, 0x09, 0xC8, 0x3A, 0x10, 0x1C, 0xB0, 0xD0, 0x37, 0x77,
  0x10, 0x30, 0xDB, 0x81, 0xC1, 0xBB, 0x0B, 0x77, 0x75, 0x0B, 0xB8, 0x1B, 0x1D, 0xB0, 0x47, 0x77,
  0x30, 0x4B, 0x83, 0xD1, 0x01, 0xDB, 0x04, 0x58, 0x31, 0x59, 0xCD, 0xA8, 0x3D, 0xC9, 0x51, 0x50,
  0x4B, 0x0D, 0x01, 0x30, 0x10, 0xDB, 0x04, 0x28, 0x12, 0x9E, 0xFB, 0x81, 0xE9, 0x22, 0x04, 0xB0,
  0xD0, 0x15, 0x01, 0x0D, 0xB0, 0x50, 0x9F, 0xFA, 0x09, 0x05, 0xB0, 0xD0, 0x17, 0x01, 0x0D, 0xFF,
  0xFB, 0x0D, 0x01, 0x72, 0x01, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xFF, 0xE0, 0xD0,
  0x17, 0x60, 0x10, 0xDF, 0xFC, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xDF, 0xFA, 0x0D, 0x01, 0x77, 0x30,
  0x10, 0xDF, 0xF0, 0xD0, 0x17, 0x75, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x70, 0x10, 0xDF, 0xB0,
  0xD0, 0x17, 0x77, 0x20, 0x10, 0xDF, 0x90, 0xD0, 0x17, 0x77, 0x40, 0x10, 0xDE, 0x0D, 0x01, 0x77,
  0x76, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x77, 0x71, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x77, 0x73, 0x82,
  0x1D, 0xD1, 0x77, 0x77, 0x50, 0x01, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_network_wifi_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_network_wifi_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_network_wifi 36x36, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_sharp_36_device_network_wifi_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAE, 0x83, 0xB7, 0x43, 0x12, 0x83,
  0x13, 0x47, 0xBE, 0x0A, 0x02, 0x70, 0x60, 0xEC, 0x0B, 0x04, 0x77, 0x04, 0x0B, 0xC0, 0xE0, 0x64,
  0x01, 0x0A, 0xC0, 0x90, 0x27, 0x74, 0x02, 0x09, 0xC8, 0x3A, 0x10, 0x1C, 0xB0, 0xD0, 0x35, 0x83,
  0x26, 0xAC, 0xDA, 0x83, 0xDC, 0xA6, 0x25, 0x03, 0x0D, 0xB8, 0x1C, 0x1B, 0xB0, 0xB5, 0x06, 0x0D,
  0xFD, 0x0D, 0x06, 0x50, 0xBB, 0x81, 0xB1, 0xDB, 0x04, 0x20, 0x70, 0xEF, 0xFA, 0x0E, 0x07, 0x20,
  0x4B, 0x83, 0xD1, 0x01, 0xDB, 0x06, 0x0C, 0xFF, 0xE0, 0xC0, 0x7B, 0x0D, 0x01, 0x30, 0x10, 0xDF,
  0xFF, 0xF0, 0xD0, 0x15, 0x01, 0x0D, 0xFF, 0xFD, 0x0D, 0x01, 0x70, 0x10, 0xDF, 0xFF, 0xB0, 0xD0,
  0x17, 0x20, 0x10, 0xDF, 0xFF, 0x90, 0xD0, 0x17, 0x40, 0x10, 0xDF, 0xFE, 0x0D, 0x01, 0x76, 0x01,
  0x0D, 0xFF, 0xC0, 0xD0, 0x17, 0x71, 0x01, 0x0D, 0xFF, 0xA0, 0xD0, 0x17, 0x73, 0x01, 0x0D, 0xFF,
  0x0D, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xD0, 0xD0, 0x17, 0x77, 0x01, 0x0D, 0xFB, 0x0D, 0x01, 0x77,
  0x72, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x74, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x77, 0x60, 0x10,
  0xDC, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x10, 0xDA, 0x0D, 0x01, 0x77, 0x77, 0x38, 0x21, 0xDD, 0x17,
  0x77, 0x75, 0x00, 0x17, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_network_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_network_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_nfc 36x36, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_sharp_36_device_nfc_data[] PROGMEM = {
  0x80, 0x9B, 0x1F, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE3, 0xE1, 0x07, 0xFB, 0x3E, 0x3E,
  0x10, 0x7F, 0xB3, 0xE3, 0xE1, 0x07, 0xFB, 0x3E, 0x3B, 0x40, 0x7A, 0x07, 0x4B, 0x3E, 0x3B, 0x40,
  0x7A, 0x07, 0x4B, 0x3E, 0x3B, 0x40, 0x7A, 0x07, 0x4B, 0x3E, 0x3B, 0x40, 0xAA, 0x0A, 0x4B, 0x3E,
  0x3B, 0x30, 0x8C, 0x08, 0x3B, 0x3E, 0x3B, 0x30, 0xEC, 0x0E, 0x3B, 0x3E, 0x3B, 0x30, 0xDC, 0x0D,
  0x3B, 0x3E, 0x3B, 0x30, 0x8C, 0x08, 0x3B, 0x3E, 0x3B, 0x48, 0x28, 0xDD, 0x84, 0xB3, 0xE3, 0xB7,
  0x5B, 0x3E, 0x3B, 0x75, 0xB3, 0xE3, 0xB7, 0x5B, 0x3E, 0x3F, 0xFC, 0x3E, 0x3F, 0xFC, 0x3E, 0x3F,
  0xFC, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0x80, 0x9B, 0x1F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_nfc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_nfc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_nightlight 36x36, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_sharp_36_device_nightlight_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xFD, 0xB8, 0x47, 0x40, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x05, 0x0D,
  0xFE, 0x0A, 0x01, 0x50, 0x7F, 0xF0, 0x66, 0x0A, 0xFF, 0x05, 0x60, 0x8F, 0xF0, 0x66, 0x05, 0xFF,
  0x0A, 0x70, 0xDF, 0xE0, 0xE0, 0x16, 0x07, 0xFF, 0x07, 0x70, 0xEF, 0xF0, 0x16, 0x03, 0xFF, 0x0B,
  0x70, 0x8F, 0xF0, 0x67, 0x0B, 0xFF, 0x03, 0x70, 0xDF, 0xF0, 0x17, 0x0E, 0xFF, 0x71, 0x0E, 0xFF,
  0x71, 0x0D, 0xFF, 0x01, 0x70, 0xBF, 0xF0, 0x37, 0x08, 0xFF, 0x06, 0x70, 0x3F, 0xF0, 0xB7, 0x10,
  0xEF, 0xF0, 0x17, 0x07, 0xFF, 0x07, 0x71, 0x0D, 0xFE, 0x0E, 0x01, 0x70, 0x5F, 0xF0, 0xA7, 0x10,
  0x8F, 0xF0, 0x67, 0x10, 0xAF, 0xF0, 0x57, 0x10, 0x7F, 0xF0, 0x67, 0x10, 0x50, 0xDF, 0xE0, 0xA0,
  0x17, 0x10, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x48, 0x90, 0x38, 0xBD, 0xEF, 0xDB, 0x84, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_nightlight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 28, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_nightlight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_note_alt 36x36, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_sharp_36_device_note_alt_data[] PROGMEM = {
  0x75, 0x82, 0x36, 0x63, 0x77, 0x72, 0x0A, 0xC0, 0xA7, 0x77, 0x0A, 0xE0, 0xA7, 0x30, 0x38, 0x04,
  0x70, 0x8B, 0x00, 0x4B, 0x08, 0x80, 0x47, 0x03, 0x07, 0xFC, 0x0E, 0x20, 0xEF, 0xC0, 0x07, 0xFD,
  0x00, 0xCF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFB,
  0x06, 0x0E, 0xF0, 0x07, 0xFF, 0xA8, 0x24, 0x02, 0xEE, 0x00, 0x7F, 0xF9, 0x0B, 0x30, 0x20, 0xED,
  0x00, 0x7F, 0xF8, 0x19, 0xFA, 0x30, 0x7D, 0x00, 0x7F, 0xE8, 0x54, 0x06, 0xFA, 0x05, 0xE0, 0x07,
  0xFD, 0x04, 0x38, 0x16, 0xFC, 0xF0, 0x07, 0xFC, 0x04, 0x50, 0x9F, 0x90, 0x07, 0xFB, 0x04, 0x50,
  0x5F, 0xA0, 0x07, 0xFA, 0x04, 0x50, 0x5F, 0xB0, 0x07, 0xF9, 0x04, 0x50, 0x5F, 0xC0, 0x07, 0xF0,
  0x45, 0x05, 0xFD, 0x00, 0x7E, 0x04, 0x50, 0x5F, 0xE0, 0x07, 0xD0, 0x85, 0x05, 0xFF, 0x00, 0x7D,
  0x07, 0x40, 0x5F, 0xF9, 0x00, 0x7D, 0x07, 0x30, 0x5F, 0xFA, 0x00, 0x7D, 0x82, 0xB7, 0x78, 0xFF,
  0xB0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x07, 0x03, 0x80, 0xA6, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_note_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_note_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_password 36x36, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_sharp_36_device_password_data[] PROGMEM = {
  0x30, 0x42, 0x04, 0x71, 0x04, 0x20, 0x47, 0x10, 0x42, 0x04, 0x58, 0x4C, 0xF4, 0x4F, 0xC6, 0x84,
  0xCF, 0x44, 0xFC, 0x68, 0x4C, 0xF4, 0x4F, 0xC4, 0x84, 0xBF, 0xDD, 0xFB, 0x68, 0x4B, 0xFD, 0xDF,
  0xB6, 0x84, 0xBF, 0xDD, 0xFB, 0x28, 0x11, 0x14, 0xC8, 0x14, 0x11, 0x28, 0x11, 0x14, 0xC8, 0x14,
  0x11, 0x28, 0x11, 0x14, 0xC8, 0x24, 0x11, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90,
  0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x82, 0x71, 0x15, 0xC8, 0x15, 0x11, 0x28,
  0x11, 0x15, 0xC8, 0x15, 0x11, 0x28, 0x11, 0x15, 0xC8, 0x15, 0x11, 0x28, 0x4B, 0xFC, 0xCF, 0xB6,
  0x84, 0xBF, 0xCC, 0xFB, 0x68, 0x4B, 0xFC, 0xCF, 0xB4, 0x84, 0xBF, 0x33, 0xFB, 0x68, 0x4B, 0xF3,
  0x3F, 0xB6, 0x84, 0xBF, 0x33, 0xFB, 0x50, 0x32, 0x03, 0x71, 0x03, 0x20, 0x37, 0x10, 0x32, 0x03,
  0x80, 0xAD, 0x30, 0x80, 0xB2, 0x74, 0xFF, 0xFF, 0xA4, 0xFF, 0xFF, 0xA4, 0x80, 0xB2, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_password() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 10, 34, 28), Box(0, 0, 35, 35),
      ic_sharp_36_device_password_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_pattern 36x36, 4-bit Alpha,  RLE, 185 bytes.
static const unsigned char ic_sharp_36_device_pattern_data[] PROGMEM = {
  0x18, 0x28, 0xDD, 0x85, 0x82, 0x8D, 0xD8, 0x58, 0x48, 0xDD, 0x80, 0x8C, 0x08, 0x30, 0x8C, 0x08,
  0x30, 0x8C, 0x08, 0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0x0D, 0xC0, 0xD3, 0x0D, 0xC0,
  0xD3, 0x0E, 0xC0, 0xD0, 0x8C, 0x08, 0x30, 0x8C, 0x08, 0x20, 0x9D, 0x84, 0x80, 0x8D, 0xD8, 0x58,
  0x28, 0xDD, 0x82, 0x09, 0xB8, 0x1E, 0xD8, 0x77, 0x20, 0x9B, 0x09, 0x77, 0x40, 0x9B, 0x09, 0x77,
  0x40, 0x9B, 0x09, 0x78, 0x28, 0xDD, 0x85, 0x81, 0x8D, 0xEB, 0x09, 0x28, 0x48, 0xDD, 0x80, 0x8C,
  0x08, 0x30, 0x8D, 0x09, 0x20, 0x8C, 0x08, 0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0xE3, 0x0D, 0xC0, 0x0D,
  0xC0, 0xD3, 0x0E, 0xC0, 0xD3, 0x0D, 0xC0, 0xD0, 0x8C, 0x08, 0x20, 0x9D, 0x08, 0x30, 0x8C, 0x84,
  0x80, 0x8D, 0xD8, 0x20, 0x9B, 0x81, 0xED, 0x85, 0x82, 0x8D, 0xD8, 0x70, 0x9B, 0x09, 0x77, 0x40,
  0x9B, 0x09, 0x77, 0x40, 0x9B, 0x09, 0x77, 0x28, 0x18, 0xDE, 0xB0, 0x92, 0x82, 0x8E, 0xE8, 0x58,
  0x48, 0xED, 0x70, 0x8D, 0x82, 0xE7, 0x7A, 0xC8, 0x3A, 0x77, 0x7B, 0xC0, 0x70, 0xDF, 0xFF, 0x90,
  0x0D, 0xFF, 0xF9, 0x0D, 0x08, 0xC8, 0x3A, 0x77, 0x7A, 0xC8, 0x3A, 0x77, 0x7A, 0xC8, 0x48, 0x08,
  0xDE, 0x85, 0x82, 0x8E, 0xE8, 0x58, 0x28, 0xED, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_pattern() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 29, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_pattern_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_phishing 36x36, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_sharp_36_device_phishing_data[] PROGMEM = {
  0x77, 0x10, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07,
  0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x30, 0x20, 0xCA, 0x0C, 0x02, 0x77, 0x10,
  0x4E, 0x04, 0x77, 0x0E, 0xE0, 0xE7, 0x60, 0x5A, 0x82, 0xD2, 0x2D, 0xA0, 0x50, 0x17, 0x40, 0x7A,
  0x08, 0x20, 0x8A, 0x0F, 0x77, 0x30, 0x5A, 0x82, 0xD2, 0x2D, 0xA8, 0x25, 0x7F, 0x77, 0x30, 0xEE,
  0x81, 0xE0, 0x7A, 0x07, 0x72, 0x04, 0xE8, 0x14, 0x07, 0xB0, 0x77, 0x20, 0x20, 0xCA, 0x0C, 0x02,
  0x20, 0x7C, 0x07, 0x72, 0x07, 0xA0, 0x73, 0x07, 0xD0, 0x77, 0x10, 0x7A, 0x07, 0x30, 0x7E, 0x07,
  0x70, 0x7A, 0x07, 0x30, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x73, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x07,
  0x30, 0x6A, 0x09, 0x74, 0x09, 0xA0, 0x63, 0x03, 0xA0, 0xD7, 0x40, 0xDA, 0x03, 0x40, 0xEA, 0x05,
  0x72, 0x05, 0xA0, 0xE5, 0x08, 0xA0, 0xE0, 0x27, 0x02, 0x0E, 0xA0, 0x86, 0x0D, 0xA0, 0xE0, 0x55,
  0x05, 0x0E, 0xA0, 0xD7, 0x03, 0x0E, 0xB8, 0x3D, 0x97, 0x9D, 0xB0, 0xE0, 0x37, 0x10, 0x30, 0xDF,
  0xA0, 0xD0, 0x37, 0x40, 0x80, 0xED, 0x0E, 0x08, 0x77, 0x18, 0x33, 0x67, 0x63, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_phishing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_phishing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_pin 36x36, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_sharp_36_device_pin_data[] PROGMEM = {
  0x80, 0xBA, 0x4F, 0x81, 0xD7, 0xBB, 0x82, 0xE9, 0x8B, 0xD8, 0x1A, 0x8A, 0xFC, 0x82, 0xA1, 0x08,
  0xA0, 0xD0, 0x13, 0x07, 0xA0, 0xE0, 0x33, 0x04, 0xFA, 0x0B, 0x30, 0x8A, 0x89, 0x59, 0x09, 0xD2,
  0x0E, 0xFD, 0x48, 0xE4, 0x0D, 0xFA, 0x82, 0x7A, 0x08, 0xB0, 0xEA, 0x81, 0x50, 0xED, 0x81, 0x40,
  0xEF, 0xB8, 0x1B, 0x08, 0xD8, 0x1B, 0x04, 0xC0, 0x82, 0x09, 0xFC, 0x81, 0xB0, 0x8C, 0x82, 0xC1,
  0x1D, 0xC8, 0x3A, 0x51, 0x1E, 0xFB, 0x81, 0xB0, 0x8B, 0x82, 0xC1, 0x1C, 0xC0, 0xCA, 0x81, 0xB0,
  0x8F, 0xB8, 0x1B, 0x08, 0xA8, 0x2C, 0x11, 0xCC, 0x85, 0x90, 0x7D, 0x60, 0x9F, 0xB8, 0x1B, 0x08,
  0xA0, 0x65, 0x82, 0xBF, 0xE3, 0x30, 0x20, 0xEF, 0xB8, 0x1D, 0x7B, 0xA0, 0xA8, 0x01, 0x70, 0xDB,
  0x81, 0xA7, 0xA8, 0x0B, 0xA4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_play_lesson 36x36, 4-bit Alpha,  RLE, 229 bytes.
static const unsigned char ic_sharp_36_device_play_lesson_data[] PROGMEM = {
  0x07, 0xFF, 0xFA, 0x07, 0x60, 0x7F, 0xFF, 0xA0, 0x76, 0x07, 0xFF, 0xFA, 0x07, 0x60, 0x7D, 0x07,
  0x7F, 0xB0, 0x76, 0x07, 0xD0, 0x77, 0xFB, 0x07, 0x60, 0x7D, 0x07, 0x7F, 0xB0, 0x76, 0x07, 0xD0,
  0x77, 0xFB, 0x07, 0x60, 0x7D, 0x07, 0x7F, 0xB0, 0x76, 0x07, 0xD0, 0x77, 0xFB, 0x07, 0x60, 0x7D,
  0x07, 0x7F, 0xB0, 0x76, 0x07, 0xD0, 0x77, 0xFB, 0x07, 0x60, 0x7D, 0x07, 0x28, 0x14, 0x81, 0x2F,
  0xB0, 0x76, 0x07, 0xD8, 0x17, 0x2A, 0xA0, 0xE0, 0x61, 0xFB, 0x07, 0x60, 0x7D, 0x0C, 0xE0, 0xCE,
  0x83, 0xD9, 0x88, 0x46, 0x07, 0xFF, 0xB0, 0x80, 0x27, 0x40, 0x7F, 0xF9, 0x0C, 0x01, 0x76, 0x07,
  0xFF, 0x0A, 0x58, 0x25, 0x77, 0x56, 0x07, 0xFE, 0x0C, 0x30, 0x10, 0x9E, 0x09, 0x01, 0x30, 0x7F,
  0xE0, 0x12, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x20, 0x7F, 0xD0, 0x82, 0x01, 0x0D, 0xFB, 0x82, 0xD1,
  0x07, 0xFD, 0x02, 0x20, 0x9C, 0x09, 0xF8, 0x19, 0x07, 0xFC, 0x0C, 0x3D, 0x81, 0x12, 0xBE, 0x10,
  0x7F, 0xC0, 0xA2, 0x05, 0xD0, 0x12, 0x05, 0x0E, 0xC0, 0x50, 0x7F, 0xC0, 0x82, 0x06, 0xD0, 0x13,
  0x01, 0x09, 0xB0, 0x60, 0x7F, 0xC0, 0x82, 0x06, 0xD0, 0x13, 0x01, 0x09, 0xB0, 0x60, 0x7F, 0xC0,
  0x92, 0x05, 0xD0, 0x12, 0x05, 0x0E, 0xC0, 0x50, 0x7F, 0xC0, 0xC3, 0xD8, 0x11, 0x2B, 0xE1, 0x07,
  0xFD, 0x02, 0x20, 0x9C, 0x09, 0xF8, 0x19, 0x07, 0xFD, 0x08, 0x20, 0x10, 0xDF, 0xB8, 0x2D, 0x10,
  0x7F, 0xD0, 0xE0, 0x12, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x77, 0x60, 0x10, 0x9E, 0x09, 0x01, 0x77,
  0x73, 0x82, 0x57, 0x75, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_play_lesson() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 34, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_play_lesson_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_price_change 36x36, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_36_device_price_change_data[] PROGMEM = {
  0x80, 0x9F, 0x5F, 0x0F, 0x7F, 0xFF, 0xE3, 0xFF, 0xFB, 0x72, 0xD0, 0x07, 0xFF, 0x72, 0xC0, 0x72,
  0x07, 0xFE, 0x72, 0xB0, 0x74, 0x07, 0xFD, 0x3F, 0xFF, 0xE3, 0x80, 0x27, 0xFF, 0xF7, 0x2F, 0xFF,
  0x72, 0xFF, 0xF8, 0x02, 0x73, 0xFF, 0xFE, 0x3F, 0xFF, 0x72, 0xB8, 0x48, 0x55, 0x55, 0x8F, 0xD7,
  0x2B, 0x0E, 0x03, 0x20, 0x30, 0xEF, 0xD7, 0x2C, 0x82, 0xE3, 0x3E, 0xFF, 0xA3, 0xF9, 0x00, 0xEF,
  0xFB, 0x0F, 0x78, 0x0A, 0x86, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_price_change() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_price_change_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_price_check 36x36, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_sharp_36_device_price_check_data[] PROGMEM = {
  0x38, 0x21, 0x77, 0x57, 0x77, 0x10, 0x3A, 0x0B, 0x77, 0x5F, 0xB0, 0x77, 0x71, 0xFB, 0x07, 0x77,
  0x1F, 0xB0, 0x77, 0x71, 0xB7, 0x77, 0x2B, 0x77, 0x72, 0xB7, 0x77, 0x2F, 0xB0, 0x77, 0x71, 0xFB,
  0x07, 0x77, 0x1F, 0xB0, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x10,
  0x7A, 0x07, 0x77, 0x1F, 0xB0, 0x77, 0x71, 0xFB, 0x07, 0x74, 0x81, 0x5E, 0x21, 0xFB, 0x07, 0x73,
  0x05, 0xA0, 0xE0, 0x23, 0x03, 0xA0, 0xB7, 0x60, 0x5B, 0x0C, 0x01, 0x38, 0x21, 0x77, 0x57, 0x50,
  0x5B, 0x0C, 0x01, 0x74, 0x0B, 0x03, 0x60, 0x5B, 0x0C, 0x01, 0x74, 0x82, 0xCF, 0xE3, 0x40, 0x5B,
  0x0C, 0x01, 0x74, 0x02, 0x0E, 0xA0, 0xE0, 0x32, 0x05, 0xB0, 0xC0, 0x17, 0x60, 0x20, 0xEA, 0x81,
  0xE3, 0x5B, 0x0C, 0x01, 0x77, 0x10, 0x20, 0xEA, 0x0E, 0xB0, 0xC0, 0x17, 0x73, 0x02, 0x0E, 0xC0,
  0xC0, 0x17, 0x75, 0x02, 0x0E, 0xA0, 0xC0, 0x17, 0x77, 0x82, 0x2E, 0xC1, 0x77, 0x72, 0x02, 0x01,
  0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_price_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_price_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_punch_clock 36x36, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_sharp_36_device_punch_clock_data[] PROGMEM = {
  0x58, 0x09, 0x67, 0x73, 0xFF, 0xC7, 0x3F, 0xFC, 0x73, 0xB8, 0x09, 0x07, 0xB7, 0x3B, 0x75, 0xB7,
  0x3B, 0x75, 0xB7, 0x3B, 0x75, 0xB7, 0x3B, 0x75, 0xB5, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFB, 0x84, 0xEA, 0x88, 0xAE, 0xFB, 0x00, 0x7F,
  0x90, 0xE0, 0x66, 0x06, 0x0E, 0xF9, 0x00, 0x7F, 0x0C, 0x01, 0x71, 0x01, 0x0C, 0xF0, 0x07, 0xE0,
  0xE0, 0x17, 0x30, 0x10, 0xEE, 0x00, 0x7E, 0x06, 0x50, 0x08, 0x50, 0x6E, 0x00, 0x7D, 0x0E, 0x60,
  0x0B, 0x60, 0xED, 0x00, 0x7D, 0x0A, 0x60, 0x0B, 0x60, 0xAD, 0x00, 0x7D, 0x08, 0x60, 0xB0, 0xC6,
  0x08, 0xD0, 0x07, 0xD0, 0x86, 0x81, 0x8F, 0x85, 0x08, 0xD0, 0x07, 0xD0, 0xA7, 0x81, 0x8F, 0x74,
  0x0A, 0xD0, 0x07, 0xD0, 0xE7, 0x10, 0x70, 0x14, 0x0E, 0xD0, 0x07, 0xE0, 0x67, 0x50, 0x6E, 0x00,
  0x7E, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xE0, 0x07, 0xF0, 0xC0, 0x17, 0x10, 0x10, 0xCF, 0x00, 0x7F,
  0x90, 0xE0, 0x66, 0x06, 0x0E, 0xF9, 0x00, 0x7F, 0xB8, 0x4E, 0xA8, 0x8A, 0xEF, 0xB0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_punch_clock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_punch_clock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_quiz 36x36, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_sharp_36_device_quiz_data[] PROGMEM = {
  0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xB8, 0x2C, 0x88, 0xBF, 0xB6,
  0xF9, 0x0E, 0x04, 0x40, 0x30, 0xDF, 0xC3, 0xF9, 0x04, 0x20, 0x04, 0x20, 0x3F, 0xC3, 0xF8, 0x2D,
  0x10, 0xAA, 0x0B, 0x20, 0xDF, 0xB3, 0xFA, 0x0B, 0xC2, 0x0B, 0xFB, 0x3F, 0xE0, 0xA2, 0x0D, 0xFB,
  0x3F, 0xD0, 0xB2, 0x06, 0xFC, 0x3F, 0xC0, 0xC2, 0x04, 0xFD, 0x3F, 0xC8, 0x12, 0x03, 0xFE, 0x3F,
  0xB0, 0xE2, 0x0B, 0xFE, 0x3F, 0xB8, 0x2E, 0x33, 0xDF, 0xE3, 0xFF, 0xFE, 0x3F, 0xB8, 0x2E, 0x77,
  0xEF, 0xE3, 0xFB, 0x08, 0x20, 0x8F, 0xE3, 0xFB, 0x09, 0x20, 0x9F, 0xE3, 0xFC, 0x00, 0x9F, 0xF3,
  0xFF, 0xFE, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x3F, 0xFF, 0xE7, 0x77, 0x6B, 0x77, 0x76, 0xB7, 0x77,
  0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xFF, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_quiz() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_quiz_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_radar 36x36, 4-bit Alpha,  RLE, 324 bytes.
static const unsigned char ic_sharp_36_device_radar_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x20,
  0xAB, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xB0, 0xA7, 0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x08, 0x50, 0x5B,
  0x08, 0x48, 0x63, 0x9D, 0xEE, 0xC9, 0x34, 0x08, 0xB0, 0x54, 0x0D, 0xA0, 0xA3, 0x02, 0x0B, 0xF9,
  0x0B, 0x01, 0x30, 0xAA, 0x0D, 0x30, 0x7A, 0x0D, 0x30, 0x30, 0xEF, 0xB0, 0xE0, 0x33, 0x0D, 0xA0,
  0x72, 0x0E, 0xA0, 0x62, 0x02, 0x0E, 0xB8, 0x49, 0x31, 0x13, 0x9B, 0x0E, 0x01, 0x20, 0x6A, 0x81,
  0xE0, 0x3A, 0x0D, 0x30, 0xBA, 0x0D, 0x02, 0x60, 0x30, 0xEA, 0x0B, 0x30, 0xDA, 0x03, 0x08, 0xA0,
  0x92, 0x04, 0xB0, 0x27, 0x10, 0x3B, 0x03, 0x20, 0x9A, 0x08, 0x0B, 0xA0, 0x42, 0x09, 0xA0, 0x83,
  0x82, 0x8E, 0xD8, 0x30, 0x9A, 0x08, 0x20, 0x4A, 0x0B, 0x0D, 0xA0, 0x22, 0x0D, 0xA0, 0x32, 0x08,
  0xC0, 0x82, 0x03, 0xA0, 0xC2, 0x02, 0xA0, 0xD0, 0xEA, 0x3B, 0x30, 0xEC, 0x0D, 0x20, 0x1A, 0x0E,
  0x3A, 0x00, 0xEA, 0x3B, 0x30, 0xEC, 0x0D, 0x20, 0x1A, 0x0E, 0x3A, 0x0E, 0x0D, 0xA0, 0x22, 0x0D,
  0xA0, 0x22, 0x08, 0xD8, 0x19, 0x04, 0xA0, 0xC2, 0x01, 0xA0, 0xD0, 0xBA, 0x04, 0x20, 0x9A, 0x08,
  0x38, 0x18, 0xDD, 0xB0, 0x09, 0xA0, 0x92, 0x04, 0xA0, 0xB0, 0x8A, 0x09, 0x20, 0x4A, 0x0E, 0x02,
  0x50, 0x9E, 0x03, 0x20, 0x8A, 0x08, 0x03, 0xA0, 0xD3, 0x0C, 0xA0, 0xD0, 0x25, 0x09, 0xC0, 0xB3,
  0x0D, 0xA8, 0x14, 0x0E, 0xA0, 0x62, 0x02, 0x0E, 0xA8, 0x1E, 0x82, 0x20, 0x30, 0x9C, 0x09, 0x20,
  0x5A, 0x0D, 0x20, 0x7A, 0x0D, 0x30, 0x40, 0xEF, 0xE8, 0x19, 0x1E, 0xA0, 0x73, 0x0D, 0xA0, 0xA3,
  0x02, 0x0C, 0xF9, 0x0B, 0x09, 0xB0, 0xDA, 0x0D, 0x40, 0x5B, 0x08, 0x48, 0x14, 0x9D, 0xA8, 0x1D,
  0x94, 0x20, 0x9D, 0x04, 0x50, 0x8B, 0x0A, 0x76, 0x01, 0x0D, 0xB0, 0x87, 0x0A, 0xB0, 0xD0, 0x67,
  0x30, 0x50, 0xEB, 0x0A, 0x72, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x14, 0x8D, 0xC0, 0x87, 0x40,
  0x50, 0xDF, 0xF0, 0xD0, 0x47, 0x70, 0x70, 0xEF, 0xB0, 0xD0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE,
  0xED, 0xB8, 0x47, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_radar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_radar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_remember_me 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_sharp_36_device_remember_me_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x75, 0x82, 0x26, 0x62, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x40, 0x9C, 0x09, 0x40, 0x7A, 0x00,
  0x7A, 0x07, 0x30, 0x9E, 0x09, 0x30, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x2F, 0x90, 0x22, 0x07, 0xA0,
  0x07, 0xA0, 0x72, 0x06, 0xF9, 0x06, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x6F, 0x90, 0x62, 0x07,
  0xA0, 0x07, 0xA0, 0x72, 0x02, 0xF9, 0x02, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x30, 0x9E, 0x09, 0x30,
  0x7A, 0x00, 0x7A, 0x07, 0x40, 0x9C, 0x09, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x58, 0x22, 0x66, 0x25,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x28, 0x25, 0x9C, 0xDA, 0x82, 0xDC,
  0x95, 0x20, 0x7A, 0x00, 0x7A, 0x0A, 0x09, 0xFD, 0x09, 0x0A, 0xA0, 0x07, 0xFF, 0xE0, 0x07, 0xFF,
  0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x70, 0x38, 0x0A, 0x07,
  0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_remember_me() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_remember_me_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_reset_tv 36x36, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_36_device_reset_tv_data[] PROGMEM = {
  0x80, 0xB2, 0x78, 0x0F, 0x3F, 0x80, 0xA4, 0x7E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x76, 0x01, 0x73,
  0xE7, 0x50, 0x07, 0x73, 0xE7, 0x48, 0x17, 0xF7, 0x76, 0xB7, 0x30, 0x7A, 0x07, 0x76, 0xB7, 0x20,
  0x7B, 0x07, 0x76, 0xB7, 0x10, 0x7F, 0xFF, 0x70, 0x3F, 0xFF, 0x97, 0x10, 0x7F, 0xFF, 0x72, 0x07,
  0xB0, 0x77, 0x3E, 0x73, 0x07, 0xA0, 0x77, 0x3E, 0x74, 0x81, 0x7F, 0x77, 0x3E, 0x75, 0x00, 0x77,
  0x3E, 0x76, 0x01, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE8, 0x0A, 0x47, 0x80, 0xF3, 0xF8, 0x05,
  0x7F, 0xD8, 0x05, 0x77, 0x2F, 0xD7, 0x74, 0xFD, 0x77, 0x48, 0x09, 0x07, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_reset_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_reset_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_restart_alt 36x36, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_sharp_36_device_restart_alt_data[] PROGMEM = {
  0x74, 0x07, 0x77, 0x71, 0x07, 0x97, 0x77, 0x07, 0xA7, 0x76, 0x07, 0xB7, 0x75, 0x07, 0xC8, 0x17,
  0x53, 0x77, 0x10, 0x7F, 0x98, 0x1E, 0x92, 0x75, 0x07, 0xFC, 0x08, 0x75, 0x07, 0xC8, 0x18, 0xAD,
  0xC0, 0xB0, 0x16, 0x0B, 0x01, 0x30, 0x7B, 0x30, 0x30, 0xBB, 0x0C, 0x58, 0x2A, 0xFD, 0x13, 0x07,
  0xA5, 0x06, 0xB0, 0xA3, 0x05, 0xB0, 0x54, 0x07, 0x96, 0x05, 0xB0, 0x52, 0x0D, 0xA0, 0x86, 0x07,
  0x70, 0x8A, 0x81, 0xD0, 0x4A, 0x0E, 0x77, 0x20, 0xEA, 0x04, 0x08, 0xA0, 0x87, 0x72, 0x08, 0xA0,
  0x80, 0xCA, 0x03, 0x77, 0x20, 0x3A, 0x0C, 0x0D, 0xA0, 0x17, 0x72, 0x01, 0xA0, 0xDB, 0x77, 0x4B,
  0x0E, 0xA0, 0x17, 0x72, 0x01, 0xA0, 0xE0, 0xCA, 0x03, 0x77, 0x20, 0x3A, 0x0C, 0x08, 0xA0, 0x87,
  0x72, 0x08, 0xA0, 0x80, 0x4A, 0x0E, 0x77, 0x20, 0xEA, 0x81, 0x40, 0xDA, 0x08, 0x77, 0x08, 0xA0,
  0xD2, 0x05, 0xB0, 0x57, 0x50, 0x5B, 0x05, 0x30, 0xAB, 0x06, 0x73, 0x06, 0xB0, 0xA4, 0x01, 0x0C,
  0xB0, 0xB0, 0x36, 0x03, 0x0B, 0xB0, 0xC0, 0x15, 0x01, 0x0C, 0xC0, 0xD0, 0x52, 0x05, 0x0D, 0xC0,
  0xC0, 0x17, 0x10, 0x8C, 0x07, 0x20, 0x7C, 0x08, 0x74, 0x83, 0x28, 0xEF, 0x72, 0x83, 0x7F, 0xE8,
  0x27, 0x71, 0x00, 0x22, 0x00, 0x27, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_restart_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_restart_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_reviews 36x36, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_sharp_36_device_reviews_data[] PROGMEM = {
  0x80, 0xA8, 0x2F, 0x00, 0xEF, 0xFF, 0xF0, 0x08, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xE0, 0x92, 0x09,
  0xFF, 0xFD, 0x02, 0x20, 0x2F, 0xFF, 0xC0, 0x94, 0x09, 0xFF, 0xF9, 0x09, 0x02, 0x60, 0x20, 0x9F,
  0xFB, 0x81, 0xE8, 0x17, 0x38, 0x11, 0x8E, 0xFF, 0x81, 0xE8, 0x17, 0x38, 0x11, 0x8E, 0xFF, 0xB0,
  0x90, 0x26, 0x02, 0x09, 0xFF, 0xF9, 0x09, 0x40, 0x9F, 0xFF, 0xC0, 0x22, 0x02, 0xFF, 0xFD, 0x09,
  0x20, 0x9F, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0x00, 0x8F, 0xFF, 0xF0, 0x0E, 0x80, 0xA8, 0x7F, 0x07,
  0x77, 0x73, 0xC0, 0x77, 0x77, 0x4B, 0x07, 0x77, 0x75, 0xA0, 0x77, 0x77, 0x69, 0x07, 0x77, 0x77,
  0x07, 0x77, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_reviews() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_reviews_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_r_mobiledata 36x36, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_sharp_36_device_r_mobiledata_data[] PROGMEM = {
  0xFB, 0x07, 0xFB, 0x07, 0xFB, 0x07, 0xB4, 0x07, 0xA0, 0x7B, 0x40, 0x7A, 0x07, 0xFB, 0x07, 0xFB,
  0x07, 0xF9, 0x81, 0xEB, 0x5B, 0x38, 0x1E, 0xFE, 0x2B, 0x30, 0x8A, 0x06, 0x1B, 0x30, 0x2A, 0x0D,
  0x1B, 0x40, 0xBA, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_r_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 13, 14), Box(0, 0, 35, 35),
      ic_sharp_36_device_r_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_rsvp 36x36, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_sharp_36_device_rsvp_data[] PROGMEM = {
  0x03, 0x80, 0x37, 0x10, 0x38, 0x02, 0x78, 0x21, 0x17, 0x73, 0x81, 0x77, 0x18, 0x03, 0x70, 0x30,
  0x7F, 0x10, 0x7E, 0x87, 0x30, 0xEF, 0x40, 0x4F, 0xE1, 0xF8, 0x57, 0x7F, 0xEB, 0xBC, 0xA1, 0x89,
  0x67, 0xFE, 0xBB, 0xBB, 0x20, 0xAF, 0x90, 0x9F, 0xA1, 0xA8, 0x7C, 0xBB, 0xEF, 0x77, 0xFB, 0x20,
  0x3A, 0x18, 0x17, 0xFC, 0x80, 0x01, 0x28, 0x55, 0xFD, 0x0D, 0xF5, 0x1A, 0x03, 0x28, 0x7B, 0xF7,
  0x7F, 0xEB, 0xBC, 0xA1, 0x07, 0xE8, 0x13, 0x01, 0xA0, 0x5A, 0x01, 0x1A, 0x85, 0xCB, 0xBE, 0xF7,
  0x7F, 0x10, 0x7E, 0x03, 0x28, 0x3C, 0xFD, 0xFC, 0x2F, 0x87, 0x77, 0xFD, 0x7B, 0xFE, 0x71, 0x80,
  0x11, 0xA0, 0x32, 0x07, 0xB0, 0x72, 0xA8, 0x91, 0x97, 0x77, 0x73, 0x7F, 0xB0, 0x1A, 0x81, 0x20,
  0x58, 0x00, 0xBA, 0x03, 0x20, 0x3B, 0x03, 0x2A, 0x03, 0x58, 0x17, 0xFB, 0x28, 0x3A, 0xF8, 0x07,
  0xE0, 0x33, 0x81, 0xEF, 0xE3, 0xA0, 0x35, 0x81, 0x37, 0x52, 0x83, 0x27, 0x60, 0x38, 0x02, 0x70,
  0x13, 0x81, 0x57, 0x53, 0x81, 0x77, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_rsvp() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 13, 34, 22), Box(0, 0, 35, 35),
      ic_sharp_36_device_rsvp_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_screen_lock_landscape 36x36, 4-bit Alpha,  RLE, 161 bytes.
static const unsigned char ic_sharp_36_device_screen_lock_landscape_data[] PROGMEM = {
  0x03, 0x80, 0xB4, 0x70, 0x30, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7D, 0x0B, 0x80,
  0xA0, 0x70, 0xBD, 0x00, 0x7D, 0x07, 0x77, 0x60, 0x7D, 0x00, 0x7D, 0x07, 0x71, 0x82, 0x8D, 0xE8,
  0x71, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x84, 0x8D, 0x55, 0xD7, 0x70, 0x7D, 0x00, 0x7D, 0x07, 0x70,
  0xD0, 0x52, 0x05, 0x0D, 0x70, 0x7D, 0x00, 0x7D, 0x07, 0x79, 0x03, 0x20, 0x39, 0x70, 0x7D, 0x00,
  0x7D, 0x07, 0x58, 0x90, 0x37, 0xF9, 0x77, 0x9F, 0x73, 0x50, 0x7D, 0x00, 0x7D, 0x07, 0x50, 0x7F,
  0x90, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0x75, 0x07, 0xF9, 0x07, 0x50, 0x7D, 0x00, 0x7D, 0x07, 0x50,
  0x7F, 0x90, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0x75, 0x07, 0xF9, 0x07, 0x50, 0x7D, 0x00, 0x7D, 0x07,
  0x50, 0x7F, 0x90, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0x75, 0x07, 0xF9, 0x07, 0x50, 0x7D, 0x00, 0x7D,
  0x07, 0x50, 0x7F, 0x90, 0x75, 0x07, 0xD0, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x07, 0xD0, 0xB8,
  0x0A, 0x07, 0x0B, 0xD0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x70, 0x38, 0x0B, 0x47,
  0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_screen_lock_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 28), Box(0, 0, 35, 35),
      ic_sharp_36_device_screen_lock_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_screen_lock_portrait 36x36, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_sharp_36_device_screen_lock_portrait_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x0B, 0x80, 0x92, 0x70, 0xBA, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A,
  0x00, 0x7A, 0x07, 0x58, 0x28, 0xDE, 0x85, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x84, 0x8D, 0x55, 0xD7,
  0x40, 0x7A, 0x00, 0x7A, 0x07, 0x40, 0xD0, 0x52, 0x05, 0x0D, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x49,
  0x03, 0x20, 0x39, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x28, 0x90, 0x37, 0xF9, 0x77, 0x9F, 0x73, 0x20,
  0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xF9, 0x07,
  0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xF9,
  0x07, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07,
  0xF9, 0x07, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x09, 0x27, 0x0B, 0xA0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x70, 0x38, 0x0A, 0x07, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_screen_lock_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_screen_lock_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_screen_lock_rotation 36x36, 4-bit Alpha,  RLE, 340 bytes.
static const unsigned char ic_sharp_36_device_screen_lock_rotation_data[] PROGMEM = {
  0x76, 0x09, 0x04, 0x73, 0x81, 0x56, 0x37, 0x75, 0x09, 0xA0, 0x47, 0x84, 0x3D, 0xDB, 0xEA, 0x77,
  0x30, 0x9C, 0x04, 0x60, 0xD0, 0x82, 0x81, 0x1C, 0x77, 0x71, 0x09, 0xE0, 0x44, 0x04, 0x0E, 0x40,
  0x40, 0xE7, 0x70, 0x9B, 0x09, 0x0D, 0xB0, 0x43, 0x06, 0x0C, 0x40, 0x29, 0x76, 0x09, 0xB8, 0x29,
  0x01, 0xDA, 0x0C, 0x20, 0xEF, 0xA0, 0x87, 0x30, 0x9B, 0x09, 0x38, 0x21, 0xDC, 0x12, 0x0E, 0xFA,
  0x08, 0x72, 0x09, 0xB0, 0x95, 0x00, 0x13, 0x0E, 0xFA, 0x08, 0x71, 0x09, 0xB0, 0x97, 0x40, 0xEF,
  0xA0, 0x87, 0x09, 0xB0, 0x97, 0x50, 0xEF, 0xA0, 0x86, 0x09, 0xB0, 0x97, 0x60, 0xEF, 0xA0, 0x85,
  0x09, 0xB0, 0x97, 0x70, 0xEF, 0xA0, 0x84, 0x08, 0xB0, 0xA7, 0x71, 0x0E, 0xFA, 0x08, 0x40, 0x30,
  0xEA, 0x0E, 0x02, 0x77, 0x0E, 0xFA, 0x08, 0x50, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x77, 0x20, 0x30,
  0xEA, 0x0E, 0x02, 0x77, 0x77, 0x20, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x48, 0x12, 0xD4, 0x72, 0x03,
  0x0E, 0xA0, 0xE0, 0x27, 0x72, 0x02, 0x0E, 0xA0, 0x43, 0x81, 0x67, 0x23, 0x03, 0x0E, 0xA0, 0xE0,
  0x27, 0x71, 0x01, 0x0D, 0xB0, 0x42, 0x81, 0xBF, 0x74, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x71, 0x01,
  0x0D, 0xB8, 0x34, 0x08, 0xFA, 0x50, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x10, 0x10, 0xDB, 0x82, 0x45,
  0xFE, 0x60, 0x30, 0xEA, 0x0E, 0x02, 0x77, 0x10, 0x7B, 0x0B, 0x01, 0xA0, 0x46, 0x03, 0x0E, 0xA0,
  0xE0, 0x27, 0x60, 0x6B, 0x0B, 0x28, 0x1A, 0xFA, 0x70, 0x30, 0xEA, 0x0E, 0x02, 0x74, 0x06, 0xB0,
  0xB3, 0x04, 0xA0, 0x27, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x20, 0x6B, 0x0B, 0x58, 0x1C, 0xFC, 0x71,
  0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x06, 0xB0, 0xB6, 0x03, 0xA0, 0x77, 0x10, 0x30, 0xEA, 0x0E, 0x02,
  0x50, 0x6B, 0x0B, 0x71, 0x08, 0xA0, 0x47, 0x10, 0x30, 0xEA, 0x0E, 0x02, 0x30, 0x6B, 0x0B, 0x73,
  0x0B, 0xA0, 0x57, 0x10, 0x30, 0xEA, 0x82, 0xE2, 0x06, 0xB0, 0xB7, 0x50, 0xCA, 0x07, 0x30, 0x10,
  0x73, 0x03, 0x0E, 0xA0, 0xE0, 0x8B, 0x0B, 0x76, 0x01, 0x0B, 0xA8, 0x4B, 0x31, 0xDF, 0x83, 0x03,
  0x0E, 0xD0, 0xB7, 0x72, 0x08, 0xB0, 0xEB, 0x08, 0x30, 0x30, 0xEB, 0x0B, 0x77, 0x40, 0x40, 0xCE,
  0x08, 0x38, 0x23, 0xEF, 0xB7, 0x77, 0x04, 0x0B, 0xD0, 0x83, 0x03, 0x0A, 0x77, 0x73, 0x85, 0x15,
  0x9B, 0xDE, 0x87, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_screen_lock_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 34, 35), Box(0, 0, 35, 35),
      ic_sharp_36_device_screen_lock_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_screen_rotation 36x36, 4-bit Alpha,  RLE, 380 bytes.
static const unsigned char ic_sharp_36_device_screen_rotation_data[] PROGMEM = {
  0x77, 0x38, 0x58, 0xED, 0xB9, 0x51, 0x77, 0x74, 0x0A, 0x03, 0x30, 0x8D, 0x0B, 0x04, 0x77, 0x71,
  0x82, 0xAF, 0xE3, 0x30, 0x8E, 0x0C, 0x04, 0x77, 0x50, 0xAB, 0x0E, 0x03, 0x30, 0x8B, 0x0E, 0xB0,
  0x87, 0x73, 0x0A, 0xA8, 0x38, 0xDF, 0xE3, 0x38, 0x48, 0xFD, 0x13, 0xCA, 0x0B, 0x01, 0x77, 0x0A,
  0xA8, 0x57, 0x01, 0xDF, 0xE3, 0x30, 0x70, 0x13, 0x07, 0xA0, 0xC7, 0x60, 0xAA, 0x07, 0x38, 0x31,
  0xDF, 0xE3, 0x71, 0x05, 0xA0, 0xB7, 0x40, 0xAA, 0x07, 0x58, 0x31, 0xDF, 0xE3, 0x71, 0x05, 0xA0,
  0x87, 0x20, 0xAA, 0x07, 0x78, 0x31, 0xDF, 0xE3, 0x71, 0x07, 0xA0, 0x37, 0x0A, 0xA0, 0x77, 0x28,
  0x31, 0xDF, 0xE3, 0x71, 0x81, 0xCF, 0xC6, 0x0A, 0xA0, 0x77, 0x48, 0x31, 0xDF, 0xE3, 0x70, 0x2A,
  0x04, 0x40, 0xAA, 0x07, 0x76, 0x83, 0x1D, 0xFE, 0x37, 0x81, 0xAF, 0xA3, 0x0A, 0xA0, 0x77, 0x71,
  0x83, 0x1D, 0xFE, 0x36, 0x04, 0xA8, 0x11, 0x0A, 0xA0, 0x87, 0x73, 0x83, 0x1D, 0xFE, 0x36, 0x87,
  0xEF, 0x50, 0x3E, 0xFD, 0x17, 0x73, 0x83, 0x1D, 0xFE, 0x35, 0x81, 0xAF, 0x82, 0x83, 0x3E, 0xFD,
  0x17, 0x73, 0x83, 0x1D, 0xFE, 0x34, 0x81, 0x7F, 0xB3, 0x83, 0x3E, 0xFD, 0x17, 0x73, 0x83, 0x1D,
  0xFE, 0x33, 0x81, 0x27, 0x64, 0x83, 0x3E, 0xFD, 0x17, 0x73, 0x83, 0x1D, 0xFE, 0x37, 0x38, 0x33,
  0xEF, 0xD1, 0x77, 0x38, 0x31, 0xDF, 0xE3, 0x48, 0x16, 0x72, 0x38, 0x33, 0xEF, 0xD1, 0x77, 0x38,
  0x31, 0xDF, 0xE3, 0x38, 0x1B, 0xF7, 0x48, 0x33, 0xEF, 0xD1, 0x77, 0x38, 0x31, 0xDF, 0xE3, 0x28,
  0x18, 0xFA, 0x58, 0x33, 0xEF, 0xD1, 0x77, 0x38, 0x71, 0xDF, 0xE3, 0x05, 0xFE, 0x68, 0x33, 0xEF,
  0xD1, 0x77, 0x30, 0x8A, 0x81, 0xA0, 0x1A, 0x04, 0x68, 0x33, 0xEF, 0xD1, 0x77, 0x10, 0x7A, 0x0A,
  0x38, 0x1A, 0xFA, 0x78, 0x33, 0xEF, 0xD1, 0x76, 0x07, 0xA0, 0xA4, 0x04, 0xA0, 0x27, 0x83, 0x3E,
  0xFD, 0x17, 0x40, 0x7A, 0x0A, 0x68, 0x1C, 0xFC, 0x71, 0x83, 0x3E, 0xFD, 0x17, 0x20, 0x7A, 0x0A,
  0x70, 0x3A, 0x07, 0x71, 0x83, 0x3E, 0xFD, 0x17, 0x07, 0xA0, 0xA7, 0x20, 0x8A, 0x04, 0x71, 0x83,
  0x3E, 0xFD, 0x15, 0x07, 0xA0, 0xA7, 0x40, 0xBA, 0x05, 0x71, 0x83, 0x3E, 0xFD, 0x13, 0x07, 0xA0,
  0xA7, 0x60, 0xCA, 0x07, 0x30, 0x10, 0x73, 0x85, 0x3E, 0xFD, 0x10, 0x7A, 0x0A, 0x77, 0x01, 0x0B,
  0xA8, 0x4B, 0x31, 0xDF, 0x83, 0x83, 0x3E, 0xFD, 0x8A, 0x0A, 0x77, 0x30, 0x8B, 0x0E, 0xB0, 0x83,
  0x03, 0x0E, 0xB0, 0xA7, 0x75, 0x04, 0x0C, 0xE0, 0x83, 0x82, 0x3E, 0xFA, 0x77, 0x71, 0x04, 0x0B,
  0xD0, 0x83, 0x03, 0x0A, 0x77, 0x74, 0x85, 0x15, 0x9B, 0xDE, 0x87, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_screen_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 35, 35), Box(0, 0, 35, 35),
      ic_sharp_36_device_screen_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_screen_search_desktop 36x36, 4-bit Alpha,  RLE, 144 bytes.
static const unsigned char ic_sharp_36_device_screen_search_desktop_data[] PROGMEM = {
  0x28, 0x0B, 0x27, 0x4F, 0xFF, 0xFA, 0x4F, 0xFF, 0xFA, 0x4F, 0xFF, 0xFA, 0x4F, 0xFF, 0xFA, 0x4F,
  0xE8, 0x1C, 0xBE, 0xFF, 0x4F, 0xC0, 0x80, 0x13, 0x04, 0x0D, 0xFD, 0x4F, 0xB0, 0x57, 0x0D, 0xFC,
  0x4F, 0xA0, 0xA2, 0x85, 0x5D, 0xEA, 0x10, 0x3F, 0xC4, 0xFA, 0x81, 0x30, 0x4C, 0x0C, 0x20, 0xCF,
  0xB4, 0xFA, 0x20, 0xAD, 0x81, 0x20, 0x8F, 0xB4, 0xFA, 0x20, 0xAD, 0x81, 0x20, 0x9F, 0xB4, 0xFA,
  0x81, 0x30, 0x4C, 0x0C, 0x20, 0xCF, 0xB4, 0xFA, 0x0A, 0x28, 0x55, 0xDE, 0xA1, 0x02, 0xFC, 0x4F,
  0xB0, 0x67, 0x10, 0xAF, 0xB4, 0xFC, 0x09, 0x01, 0x30, 0x50, 0x32, 0x0A, 0xFA, 0x4F, 0xE8, 0x4D,
  0xDE, 0xFE, 0x32, 0x0A, 0xF9, 0x4F, 0xFC, 0x82, 0xE3, 0x0B, 0xF9, 0x4F, 0xFD, 0x0E, 0x0B, 0xFA,
  0x4F, 0xFF, 0xFA, 0x4F, 0xFF, 0xFA, 0x4F, 0xFF, 0xFA, 0x4F, 0xFF, 0xFA, 0x80, 0xC0, 0x00, 0x38,
  0x0B, 0x47, 0x03, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x70, 0x38, 0x0B, 0x47, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_screen_search_desktop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_screen_search_desktop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_screenshot_monitor 36x36, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_sharp_36_device_screenshot_monitor_data[] PROGMEM = {
  0x80, 0xB2, 0x78, 0x0F, 0x3F, 0x80, 0xA4, 0x7E, 0x77, 0x73, 0xE1, 0x07, 0xD0, 0x77, 0x72, 0xE1,
  0x07, 0xD0, 0x77, 0x72, 0xE1, 0x85, 0x7F, 0xC3, 0x33, 0x17, 0x72, 0xE1, 0x81, 0x7F, 0xB7, 0x76,
  0xE1, 0x81, 0x7F, 0xB7, 0x76, 0xE1, 0x81, 0x7F, 0xB7, 0x76, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7,
  0x77, 0x3E, 0x77, 0x68, 0x1B, 0xF7, 0x1E, 0x77, 0x68, 0x1B, 0xF7, 0x1E, 0x77, 0x68, 0x1B, 0xF7,
  0x1E, 0x77, 0x28, 0x51, 0x33, 0x3C, 0xF7, 0x1E, 0x77, 0x20, 0x7D, 0x07, 0x1E, 0x77, 0x20, 0x7D,
  0x07, 0x1E, 0x77, 0x73, 0xE8, 0x0A, 0x47, 0x80, 0xF3, 0xF8, 0x05, 0x7F, 0xD8, 0x05, 0x77, 0x2F,
  0xD7, 0x74, 0xFD, 0x77, 0x48, 0x09, 0x07, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_screenshot_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_screenshot_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_screenshot 36x36, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_sharp_36_device_screenshot_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x71, 0x80, 0x27, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x1E, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x1A,
  0x0C, 0x0F, 0xB7, 0x07, 0xA0, 0x07, 0xA0, 0x71, 0xA0, 0x37, 0x30, 0x7A, 0x00, 0x7A, 0x07, 0x1A,
  0x03, 0x73, 0x07, 0xA0, 0x07, 0xA0, 0x71, 0xA0, 0x37, 0x30, 0x7A, 0x00, 0x7A, 0x83, 0x70, 0x77,
  0x17, 0x30, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A,
  0x07, 0x73, 0x83, 0x17, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x73, 0x03, 0xA1, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x30, 0x3A, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x73, 0x03, 0xA1, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x0F, 0xB0, 0xCA, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x7E, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x78, 0x02,
  0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F,
  0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x07, 0x03, 0x80,
  0xA0, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_screenshot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_screenshot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_sd_storage 36x36, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_sharp_36_device_sd_storage_data[] PROGMEM = {
  0x71, 0x07, 0xFF, 0x97, 0x07, 0xFF, 0xA6, 0x07, 0xFF, 0xB5, 0x07, 0xB3, 0x90, 0x72, 0x07, 0x93,
  0xB4, 0x07, 0xC3, 0x90, 0x72, 0x07, 0x93, 0xB3, 0x07, 0xD3, 0x90, 0x72, 0x07, 0x93, 0xB2, 0x07,
  0xE3, 0x90, 0x72, 0x07, 0x93, 0xB1, 0x07, 0xF3, 0x90, 0x72, 0x07, 0x93, 0xB0, 0x7F, 0x93, 0x90,
  0x72, 0x07, 0x93, 0x80, 0xFE, 0x7F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_sd_storage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_sd_storage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_security_update_good 36x36, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_sharp_36_device_security_update_good_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x73, 0x09, 0x06, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x72, 0x09, 0xA8, 0x16, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x10, 0x9B, 0x81, 0x80, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x10, 0x93, 0x09, 0xB0,
  0x82, 0x07, 0xA0, 0x07, 0xA8, 0x67, 0x01, 0xCF, 0xB0, 0x9B, 0x08, 0x30, 0x7A, 0x00, 0x7A, 0x81,
  0x70, 0x5B, 0x0E, 0xB0, 0x84, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x06, 0xD0, 0x85, 0x07, 0xA0, 0x07,
  0xA0, 0x73, 0x06, 0xB0, 0x86, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x81, 0x6F, 0x87, 0x07, 0xA0, 0x07,
  0xA0, 0x75, 0x03, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xFF, 0xE0, 0x07,
  0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF,
  0xE0, 0x70, 0x38, 0x0A, 0x07, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_security_update_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_security_update_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_security_update 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_sharp_36_device_security_update_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA8, 0x17, 0x07, 0xFB, 0x81,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x73, 0x07, 0xE0,
  0x73, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x07, 0xC0, 0x74, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x76, 0x00, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x07,
  0x03, 0x80, 0xA0, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_security_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_security_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_security_update_warning 36x36, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_sharp_36_device_security_update_warning_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x75, 0x82, 0x37, 0x73, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x58, 0x23, 0x77, 0x35, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x82, 0x37,
  0x73, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A,
  0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x58, 0x23, 0x77, 0x35, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x07, 0x03, 0x80, 0xA0, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_security_update_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_security_update_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_sell 36x36, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_sharp_36_device_sell_data[] PROGMEM = {
  0xFF, 0x90, 0x77, 0x71, 0xFF, 0xA0, 0x77, 0x7F, 0xFB, 0x07, 0x76, 0xFF, 0xC0, 0x77, 0x5D, 0x81,
  0xD8, 0xAF, 0xC0, 0x77, 0x4C, 0x0D, 0x30, 0x6F, 0xC0, 0x77, 0x3C, 0x08, 0x30, 0x1F, 0xD0, 0x77,
  0x2C, 0x0A, 0x30, 0x2F, 0xE0, 0x77, 0x1D, 0x82, 0x60, 0x2C, 0xFF, 0x07, 0x7F, 0xFF, 0xB0, 0x76,
  0xFF, 0xFC, 0x07, 0x5F, 0xFF, 0xD0, 0x74, 0xFF, 0xFE, 0x07, 0x3F, 0xFF, 0xF0, 0x72, 0xFF, 0xFF,
  0x98, 0x17, 0x07, 0xFF, 0xFF, 0x98, 0x17, 0x07, 0xFF, 0xFF, 0x0D, 0x20, 0x7F, 0xFF, 0xD0, 0xD0,
  0x13, 0x07, 0xFF, 0xFB, 0x0D, 0x01, 0x50, 0x7F, 0xFF, 0x90, 0xD0, 0x17, 0x07, 0xFF, 0xE0, 0xD0,
  0x17, 0x20, 0x7F, 0xFC, 0x0D, 0x01, 0x74, 0x07, 0xFF, 0xA0, 0xD0, 0x17, 0x60, 0x7F, 0xF0, 0xD0,
  0x17, 0x71, 0x07, 0xFD, 0x0D, 0x01, 0x77, 0x30, 0x7F, 0xB0, 0xD0, 0x17, 0x75, 0x07, 0xF9, 0x0D,
  0x01, 0x77, 0x70, 0x7E, 0x0D, 0x01, 0x77, 0x72, 0x07, 0xC0, 0xD0, 0x17, 0x77, 0x40, 0x7A, 0x0D,
  0x01, 0x77, 0x76, 0x81, 0x7D, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_sell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 33, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_sell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_send_to_mobile 36x36, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_sharp_36_device_send_to_mobile_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x34, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0,
  0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0,
  0x74, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x40, 0x7A, 0x07, 0x77, 0x82, 0x37, 0x73, 0x40, 0x7A,
  0x07, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x72, 0x07, 0x50, 0x7A, 0x07, 0x77, 0x29, 0x07, 0x40, 0x7A,
  0x07, 0x77, 0x2A, 0x07, 0x30, 0x7A, 0x07, 0x77, 0x2B, 0x07, 0x20, 0x7A, 0x07, 0x71, 0x03, 0x80,
  0x37, 0xC8, 0x17, 0x07, 0xA0, 0x77, 0x10, 0x7F, 0xD0, 0x07, 0xA0, 0x77, 0x10, 0x7F, 0xD0, 0x07,
  0xA0, 0x77, 0x10, 0x38, 0x03, 0x7C, 0x81, 0x70, 0x7A, 0x07, 0x77, 0x2B, 0x07, 0x20, 0x7A, 0x07,
  0x77, 0x2A, 0x07, 0x30, 0x7A, 0x07, 0x77, 0x29, 0x07, 0x40, 0x7A, 0x07, 0x77, 0x20, 0x75, 0x07,
  0xA0, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x82, 0x37, 0x73, 0x40, 0x7A, 0x07, 0x77, 0x07, 0xA0,
  0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0,
  0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0, 0x74, 0x07, 0xFF, 0xE0, 0x74, 0x03, 0x80, 0xA0,
  0x70, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_send_to_mobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 32, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_send_to_mobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_settings_suggest 36x36, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_sharp_36_device_settings_suggest_data[] PROGMEM = {
  0x77, 0x74, 0x06, 0x77, 0x77, 0x40, 0xD0, 0x67, 0x77, 0x72, 0x81, 0x5F, 0xD7, 0x77, 0x71, 0x01,
  0x0D, 0xA0, 0x77, 0x77, 0x50, 0x30, 0xAD, 0x0D, 0x06, 0x77, 0x72, 0x01, 0x0A, 0xF0, 0xD0, 0x67,
  0x40, 0xCE, 0x0C, 0x50, 0x20, 0x9B, 0x0D, 0x05, 0x76, 0x0E, 0xE0, 0xE7, 0x09, 0xA0, 0x17, 0x20,
  0x13, 0x01, 0xF9, 0x01, 0x30, 0x12, 0x81, 0x2F, 0xA7, 0x38, 0x3D, 0xC6, 0x04, 0xF9, 0x83, 0x40,
  0x6C, 0xD3, 0x0A, 0x03, 0x72, 0x08, 0xB0, 0xEF, 0xB0, 0xEB, 0x08, 0x20, 0x17, 0x20, 0x2F, 0xFE,
  0x02, 0x74, 0x0A, 0xFF, 0xE0, 0xA7, 0x30, 0x4F, 0xA8, 0x2C, 0x99, 0xCF, 0xA0, 0x33, 0x01, 0x50,
  0xCF, 0x0E, 0x05, 0x40, 0x50, 0xEF, 0x0C, 0x30, 0xA0, 0x33, 0x01, 0x0C, 0xF0, 0x56, 0x05, 0xF8,
  0x4C, 0x10, 0x2F, 0xA5, 0x09, 0xD0, 0xC7, 0x10, 0xCD, 0x09, 0x20, 0x60, 0xDA, 0x0A, 0x03, 0x40,
  0x7C, 0x09, 0x71, 0x09, 0xC0, 0x72, 0x06, 0x0E, 0xC0, 0xA0, 0x13, 0x07, 0xC0, 0x97, 0x10, 0x9C,
  0x07, 0x48, 0x27, 0xFD, 0x24, 0x09, 0xD0, 0xC7, 0x10, 0xCD, 0x09, 0x40, 0xD0, 0x63, 0x01, 0x0C,
  0xF0, 0x56, 0x05, 0xF0, 0xC0, 0x12, 0x06, 0x50, 0xCF, 0x0E, 0x05, 0x40, 0x50, 0xEF, 0x0C, 0x72,
  0x03, 0xFA, 0x82, 0xC9, 0x9C, 0xFA, 0x04, 0x73, 0x0A, 0xFF, 0xE0, 0xA7, 0x40, 0x2F, 0xFE, 0x02,
  0x75, 0x08, 0xB0, 0xEF, 0xB0, 0xEB, 0x08, 0x77, 0x83, 0xDC, 0x60, 0x4F, 0x98, 0x34, 0x06, 0xCD,
  0x77, 0x10, 0x13, 0x01, 0xF9, 0x01, 0x30, 0x17, 0x76, 0x0E, 0xE0, 0xE7, 0x77, 0x40, 0xCE, 0x0C,
  0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_settings_suggest() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 34, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_settings_suggest_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_settings_system_daydream 36x36, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_sharp_36_device_settings_system_daydream_data[] PROGMEM = {
  0x03, 0x80, 0xB4, 0x70, 0x30, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7A, 0x0B, 0x80,
  0xA6, 0x70, 0xBA, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07,
  0x73, 0x84, 0x4B, 0xEE, 0xB4, 0x73, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x20, 0x9E, 0x08, 0x72, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x10, 0x6F, 0x90, 0x57, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x60, 0x70, 0xCF,
  0xA0, 0xD7, 0x10, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0xBF, 0xD0, 0x70, 0x36, 0x07, 0xA0, 0x07, 0xA0,
  0x74, 0x07, 0xFF, 0x90, 0xA5, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x0C, 0xFF, 0xA0, 0x74, 0x07, 0xA0,
  0x07, 0xA0, 0x74, 0x0E, 0xFF, 0xA0, 0xD4, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x0C, 0xFF, 0xA0, 0xE4,
  0x07, 0xA0, 0x07, 0xA0, 0x74, 0x07, 0xFF, 0xA0, 0xB4, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x0B, 0xFF,
  0x90, 0x34, 0x07, 0xA0, 0x07, 0xA0, 0x76, 0x07, 0x0C, 0xFB, 0x81, 0xEB, 0x35, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77,
  0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0xB8, 0x0A, 0x67, 0x0B, 0xA0,
  0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x70, 0x38, 0x0B, 0x47, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_settings_system_daydream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_settings_system_daydream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_share_location 36x36, 4-bit Alpha,  RLE, 275 bytes.
static const unsigned char ic_sharp_36_device_share_location_data[] PROGMEM = {
  0x73, 0x82, 0x48, 0xB6, 0x28, 0x26, 0xB8, 0x47, 0x74, 0x07, 0x0D, 0xB0, 0x72, 0x07, 0xB0, 0xE0,
  0x77, 0x70, 0x40, 0xDD, 0x07, 0x20, 0x7D, 0x0E, 0x05, 0x74, 0x08, 0xC8, 0x2E, 0x85, 0x12, 0x82,
  0x14, 0x8D, 0xC0, 0x37, 0x20, 0x9B, 0x0E, 0x06, 0x73, 0x82, 0x5D, 0xF6, 0x72, 0x07, 0xB0, 0xA0,
  0x17, 0x60, 0x43, 0x03, 0x50, 0x4B, 0x09, 0x77, 0x48, 0x15, 0xF5, 0x40, 0xDA, 0x0B, 0x78, 0x24,
  0x77, 0x47, 0x04, 0xA0, 0xE3, 0x06, 0xA0, 0xE0, 0x15, 0x05, 0x0E, 0xC0, 0xE0, 0x56, 0x0D, 0xA0,
  0x72, 0x0D, 0xA0, 0x65, 0x06, 0xF9, 0x06, 0x50, 0x5A, 0x81, 0xE0, 0x3A, 0x0E, 0x50, 0x2F, 0xB0,
  0x25, 0x0D, 0xA0, 0x40, 0x7A, 0x09, 0x50, 0x9C, 0x00, 0xDC, 0x09, 0x50, 0x8A, 0x09, 0x0B, 0xA0,
  0x55, 0x0D, 0xB0, 0xB2, 0x0B, 0xB0, 0xD5, 0x04, 0xA0, 0x0C, 0xA0, 0x25, 0xC0, 0x62, 0x06, 0xC5,
  0x83, 0x17, 0x77, 0xEA, 0x01, 0x50, 0xCB, 0x82, 0xC2, 0x2C, 0xB0, 0xC7, 0x20, 0xEA, 0x01, 0x50,
  0x9F, 0xB0, 0x97, 0x20, 0xCA, 0x02, 0x50, 0x2F, 0xB0, 0x25, 0x83, 0x17, 0x77, 0xBA, 0x05, 0x60,
  0x9F, 0x90, 0x96, 0x04, 0xA0, 0xC0, 0x7A, 0x09, 0x70, 0xCE, 0x0C, 0x70, 0x8A, 0x09, 0x03, 0xA0,
  0xE7, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x0D, 0xA8, 0x14, 0x0D, 0xA0, 0x67, 0x03, 0x0E, 0xA0, 0xE0,
  0x37, 0x05, 0xA0, 0xE2, 0x06, 0xA0, 0xE0, 0x17, 0x82, 0x2D, 0xD2, 0x71, 0x0D, 0xA0, 0x73, 0x0D,
  0xA0, 0xB7, 0x10, 0x02, 0x71, 0x04, 0xA0, 0xE4, 0x04, 0xB0, 0x97, 0x74, 0x81, 0x5F, 0x55, 0x07,
  0xB0, 0xA0, 0x17, 0x60, 0x43, 0x03, 0x70, 0x9B, 0x0E, 0x06, 0x73, 0x82, 0x5D, 0xF6, 0x74, 0x08,
  0xC8, 0x2E, 0x85, 0x12, 0x82, 0x14, 0x8D, 0xC0, 0x37, 0x40, 0x40, 0xDD, 0x07, 0x20, 0x7D, 0x0E,
  0x05, 0x77, 0x07, 0x0D, 0xB0, 0x72, 0x07, 0xB0, 0xE0, 0x77, 0x74, 0x82, 0x48, 0xB6, 0x28, 0x26,
  0xB8, 0x47, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_share_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_share_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_shortcut 36x36, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_36_device_shortcut_data[] PROGMEM = {
  0x77, 0x40, 0x17, 0x77, 0x60, 0x07, 0x77, 0x75, 0x81, 0x7F, 0x77, 0x77, 0x40, 0x7A, 0x07, 0x77,
  0x73, 0x07, 0xB0, 0x77, 0x77, 0x20, 0x7C, 0x07, 0x77, 0x71, 0x07, 0xD0, 0x77, 0x77, 0x07, 0xE0,
  0x76, 0x82, 0x18, 0xCE, 0xFF, 0xC0, 0x74, 0x07, 0xFF, 0xFA, 0x03, 0x20, 0x8F, 0xFF, 0xA0, 0x72,
  0x04, 0xB8, 0x1C, 0x51, 0x73, 0x07, 0xE0, 0x73, 0x0D, 0xA0, 0xB7, 0x60, 0x7D, 0x07, 0x30, 0x3A,
  0x0E, 0x01, 0x76, 0x07, 0xC0, 0x74, 0x06, 0xA0, 0xA7, 0x70, 0x7B, 0x07, 0x50, 0x7A, 0x08, 0x77,
  0x07, 0xA0, 0x76, 0x07, 0xA0, 0x77, 0x78, 0x17, 0xF7, 0x70, 0x7A, 0x07, 0x77, 0x00, 0x77, 0x10,
  0x7A, 0x07, 0x77, 0x01, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x82, 0x37,
  0x73, 0x77, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_shortcut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 31, 28), Box(0, 0, 35, 35),
      ic_sharp_36_device_shortcut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_0_bar 36x36, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_0_bar_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x77, 0x77, 0x70, 0x79, 0x77, 0x76, 0x07, 0xA7, 0x77, 0x50, 0x7B, 0x77, 0x74,
  0x07, 0xC7, 0x77, 0x30, 0x7D, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x10, 0x7B, 0x0B, 0xB7, 0x77, 0x07,
  0xB0, 0xB1, 0xB7, 0x76, 0x07, 0xB0, 0xB2, 0xB7, 0x75, 0x07, 0xB0, 0xB3, 0xB7, 0x74, 0x07, 0xB0,
  0xB4, 0xB7, 0x73, 0x07, 0xB0, 0xB5, 0xB7, 0x72, 0x07, 0xB0, 0xB6, 0xB7, 0x71, 0x07, 0xB0, 0xB7,
  0xB7, 0x70, 0x7B, 0x0B, 0x71, 0xB7, 0x60, 0x7B, 0x0B, 0x72, 0xB7, 0x50, 0x7B, 0x0B, 0x73, 0xB7,
  0x40, 0x7B, 0x0B, 0x74, 0xB7, 0x30, 0x7B, 0x0B, 0x75, 0xB7, 0x20, 0x7B, 0x0B, 0x76, 0xB7, 0x10,
  0x7B, 0x0B, 0x77, 0xB7, 0x07, 0xB0, 0xB7, 0x71, 0xB6, 0x07, 0xB0, 0xB7, 0x72, 0xB5, 0x07, 0xB0,
  0xB7, 0x73, 0xB4, 0x07, 0xB0, 0xB7, 0x74, 0xB3, 0x07, 0xB0, 0xB7, 0x75, 0xB2, 0x07, 0xFF, 0xFE,
  0x10, 0x7F, 0xFF, 0xF0, 0x7F, 0xFF, 0xF9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_4_bar 36x36, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_4_bar_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x77, 0x77, 0x70, 0x79, 0x77, 0x76, 0x07, 0xA7, 0x77, 0x50, 0x7B, 0x77, 0x74,
  0x07, 0xC7, 0x77, 0x30, 0x7D, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x10, 0x7F, 0x77, 0x70, 0x7F, 0x97,
  0x76, 0x07, 0xFA, 0x77, 0x50, 0x7F, 0xB7, 0x74, 0x07, 0xFC, 0x77, 0x30, 0x7F, 0xD7, 0x72, 0x07,
  0xFE, 0x77, 0x10, 0x7F, 0xF7, 0x70, 0x7F, 0xF9, 0x76, 0x07, 0xFF, 0xA7, 0x50, 0x7F, 0xFB, 0x74,
  0x07, 0xFF, 0xC7, 0x30, 0x7F, 0xFD, 0x72, 0x07, 0xFF, 0xE7, 0x10, 0x7F, 0xFF, 0x70, 0x7F, 0xFF,
  0x96, 0x07, 0xFF, 0xFA, 0x50, 0x7F, 0xFF, 0xB4, 0x07, 0xFF, 0xFC, 0x30, 0x7F, 0xFF, 0xD2, 0x07,
  0xFF, 0xFE, 0x10, 0x7F, 0xFF, 0xF0, 0x7F, 0xFF, 0xF9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_alt_1_bar 36x36, 4-bit Alpha,  RLE, 14 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_alt_1_bar_data[] PROGMEM = {
  0x07, 0xC0, 0x7C, 0x07, 0xC0, 0x7C, 0x07, 0xC0, 0x7C, 0x07, 0xC0, 0x7C, 0x07, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_alt_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 21, 11, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_alt_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_alt_2_bar 36x36, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_alt_2_bar_data[] PROGMEM = {
  0x72, 0x03, 0x80, 0x07, 0x72, 0x07, 0xC7, 0x20, 0x7C, 0x72, 0x07, 0xC7, 0x20, 0x7C, 0x72, 0x07,
  0xC7, 0x20, 0x7C, 0x72, 0x07, 0xC0, 0x7C, 0x40, 0x7C, 0x07, 0xC4, 0x07, 0xC0, 0x7C, 0x40, 0x7C,
  0x07, 0xC4, 0x07, 0xC0, 0x7C, 0x40, 0x7C, 0x07, 0xC4, 0x07, 0xC0, 0x7C, 0x40, 0x7C, 0x07, 0xC4,
  0x07, 0xC0, 0x7C, 0x40, 0x7C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_alt_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 13, 20, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_alt_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_alt 36x36, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_alt_data[] PROGMEM = {
  0x77, 0x40, 0x7C, 0x77, 0x40, 0x7C, 0x77, 0x40, 0x7C, 0x77, 0x40, 0x7C, 0x77, 0x40, 0x7C, 0x77,
  0x40, 0x7C, 0x77, 0x40, 0x7C, 0x72, 0x03, 0x80, 0x07, 0x40, 0x7C, 0x72, 0x07, 0xC4, 0x07, 0xC7,
  0x20, 0x7C, 0x40, 0x7C, 0x72, 0x07, 0xC4, 0x07, 0xC7, 0x20, 0x7C, 0x40, 0x7C, 0x72, 0x07, 0xC4,
  0x07, 0xC7, 0x20, 0x7C, 0x40, 0x7C, 0x72, 0x07, 0xC4, 0x07, 0xC0, 0x7C, 0x40, 0x7C, 0x40, 0x7C,
  0x07, 0xC4, 0x07, 0xC4, 0x07, 0xC0, 0x7C, 0x40, 0x7C, 0x40, 0x7C, 0x07, 0xC4, 0x07, 0xC4, 0x07,
  0xC0, 0x7C, 0x40, 0x7C, 0x40, 0x7C, 0x07, 0xC4, 0x07, 0xC4, 0x07, 0xC0, 0x7C, 0x40, 0x7C, 0x40,
  0x7C, 0x07, 0xC4, 0x07, 0xC4, 0x07, 0xC0, 0x7C, 0x40, 0x7C, 0x40, 0x7C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 6, 29, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_connected_no_internet_0_bar 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_connected_no_internet_0_bar_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x77, 0x77, 0x70, 0x79, 0x77, 0x76, 0x07, 0xA7, 0x77, 0x50, 0x7B, 0x77, 0x74,
  0x07, 0xC7, 0x77, 0x30, 0x7D, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x10, 0x7B, 0x0B, 0xB7, 0x77, 0x07,
  0xB0, 0xB1, 0xB7, 0x76, 0x07, 0xB0, 0xB7, 0x77, 0x30, 0x7B, 0x0B, 0x77, 0x73, 0x07, 0xB0, 0xB7,
  0x77, 0x30, 0x7B, 0x0B, 0x5B, 0x77, 0x20, 0x7B, 0x0B, 0x6B, 0x77, 0x10, 0x7B, 0x0B, 0x7B, 0x77,
  0x07, 0xB0, 0xB7, 0x1B, 0x76, 0x07, 0xB0, 0xB7, 0x2B, 0x75, 0x07, 0xB0, 0xB7, 0x3B, 0x74, 0x07,
  0xB0, 0xB7, 0x4B, 0x73, 0x07, 0xB0, 0xB7, 0x5B, 0x72, 0x07, 0xB0, 0xB7, 0x6B, 0x71, 0x07, 0xB0,
  0xB7, 0x7B, 0x70, 0x7B, 0x0B, 0x77, 0x1B, 0x60, 0x7B, 0x0B, 0x77, 0x2B, 0x50, 0x7B, 0x0B, 0x77,
  0x73, 0x07, 0xB0, 0xB7, 0x77, 0x30, 0x7B, 0x0B, 0x77, 0x73, 0x07, 0xFF, 0xF3, 0xB1, 0x07, 0xFF,
  0xF9, 0x3B, 0x07, 0xFF, 0xFA, 0x3B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_connected_no_internet_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_connected_no_internet_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_connected_no_internet_4_bar 36x36, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_connected_no_internet_4_bar_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x77, 0x77, 0x70, 0x79, 0x77, 0x76, 0x07, 0xA7, 0x77, 0x50, 0x7B, 0x77, 0x74,
  0x07, 0xC7, 0x77, 0x30, 0x7D, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x10, 0x7F, 0x77, 0x70, 0x7F, 0x97,
  0x76, 0x07, 0xB7, 0x77, 0x40, 0x7C, 0x77, 0x73, 0x07, 0xD7, 0x77, 0x20, 0x7E, 0x3B, 0x77, 0x20,
  0x7F, 0x3B, 0x77, 0x10, 0x7F, 0x93, 0xB7, 0x70, 0x7F, 0xA3, 0xB7, 0x60, 0x7F, 0xB3, 0xB7, 0x50,
  0x7F, 0xC3, 0xB7, 0x40, 0x7F, 0xD3, 0xB7, 0x30, 0x7F, 0xE3, 0xB7, 0x20, 0x7F, 0xF3, 0xB7, 0x10,
  0x7F, 0xF9, 0x3B, 0x70, 0x7F, 0xFA, 0x3B, 0x60, 0x7F, 0xFB, 0x3B, 0x50, 0x7F, 0xFC, 0x73, 0x07,
  0xFF, 0xD7, 0x20, 0x7F, 0xFE, 0x71, 0x07, 0xFF, 0xF3, 0xB1, 0x07, 0xFF, 0xF9, 0x3B, 0x07, 0xFF,
  0xFA, 0x3B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_connected_no_internet_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_connected_no_internet_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_nodata 36x36, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_nodata_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x77, 0x77, 0x70, 0x79, 0x77, 0x76, 0x07, 0xA7, 0x77, 0x50, 0x7B, 0x77, 0x74,
  0x07, 0xC7, 0x77, 0x30, 0x7D, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x10, 0x7F, 0x77, 0x70, 0x7F, 0x97,
  0x76, 0x07, 0xFA, 0x77, 0x50, 0x7F, 0xB7, 0x74, 0x07, 0xFC, 0x77, 0x30, 0x7F, 0xD7, 0x72, 0x07,
  0xFE, 0x77, 0x10, 0x7F, 0xF7, 0x70, 0x7F, 0xF9, 0x76, 0x07, 0xA0, 0xB8, 0x09, 0x17, 0x75, 0x07,
  0xB0, 0x77, 0x77, 0x30, 0x7C, 0x07, 0x20, 0x60, 0x94, 0x81, 0x2B, 0x17, 0x50, 0x7D, 0x81, 0x70,
  0x6A, 0x09, 0x28, 0x32, 0xEF, 0xC1, 0x73, 0x07, 0xE8, 0x17, 0x09, 0xB8, 0x19, 0x3E, 0xA0, 0xE0,
  0x27, 0x20, 0x7F, 0x07, 0x20, 0x9E, 0x0E, 0x03, 0x72, 0x07, 0xF9, 0x07, 0x30, 0x9C, 0x0E, 0x03,
  0x72, 0x07, 0xFA, 0x07, 0x30, 0x3C, 0x0A, 0x72, 0x07, 0xFB, 0x07, 0x20, 0x20, 0xED, 0x09, 0x70,
  0x7F, 0xC8, 0x27, 0x02, 0xEA, 0x0E, 0x0A, 0xB0, 0x95, 0x07, 0xFD, 0x81, 0x70, 0xBA, 0x82, 0xE3,
  0x09, 0xB0, 0x33, 0x07, 0xFE, 0x84, 0x70, 0x1C, 0xE3, 0x38, 0x19, 0xF6, 0x30, 0x7F, 0xF0, 0x72,
  0x01, 0x02, 0x50, 0x33, 0x07, 0xFF, 0x90, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_nodata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_nodata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_no_sim 36x36, 4-bit Alpha,  RLE, 191 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_no_sim_data[] PROGMEM = {
  0x74, 0x01, 0x80, 0x91, 0x70, 0x35, 0x02, 0x70, 0x10, 0xDF, 0xE0, 0x74, 0x81, 0x3E, 0x85, 0x01,
  0x0D, 0xFF, 0x07, 0x30, 0x20, 0xEA, 0x08, 0x40, 0xCF, 0xF9, 0x07, 0x40, 0x9B, 0x08, 0x30, 0x30,
  0xEF, 0xF0, 0x75, 0x09, 0xB0, 0x83, 0x03, 0x0E, 0xFE, 0x07, 0x60, 0x9B, 0x08, 0x30, 0x30, 0xEF,
  0xD0, 0x77, 0x0A, 0xB0, 0x83, 0x03, 0x0E, 0xFC, 0x07, 0x70, 0x7C, 0x08, 0x30, 0x30, 0xEF, 0xB0,
  0x77, 0x07, 0xD0, 0x83, 0x03, 0x0E, 0xFA, 0x07, 0x70, 0x7E, 0x08, 0x30, 0x30, 0xEF, 0x90, 0x77,
  0x07, 0xF0, 0x83, 0x03, 0x0E, 0xF0, 0x77, 0x07, 0xF9, 0x08, 0x30, 0x30, 0xEE, 0x07, 0x70, 0x7F,
  0xA0, 0x83, 0x03, 0x0E, 0xD0, 0x77, 0x07, 0xFB, 0x08, 0x30, 0x30, 0xEC, 0x07, 0x70, 0x7F, 0xC0,
  0x83, 0x03, 0x0E, 0xB0, 0x77, 0x07, 0xFD, 0x08, 0x30, 0x30, 0xEA, 0x07, 0x70, 0x7F, 0xE0, 0x83,
  0x82, 0x3E, 0xF7, 0x70, 0x7F, 0xF0, 0x83, 0x81, 0x3E, 0x77, 0x07, 0xFF, 0x90, 0x83, 0x03, 0x06,
  0x70, 0x7F, 0xFA, 0x08, 0x74, 0x07, 0xFF, 0xB0, 0x87, 0x30, 0x7F, 0xFC, 0x08, 0x72, 0x07, 0xFF,
  0xD0, 0x87, 0x10, 0x7F, 0xFE, 0x08, 0x70, 0x7F, 0xFF, 0x08, 0x60, 0x7F, 0xFF, 0x90, 0x85, 0x03,
  0x80, 0x97, 0x70, 0xAB, 0x08, 0x77, 0x74, 0x82, 0x9F, 0xE3, 0x77, 0x75, 0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 31, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_null 36x36, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_null_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x77, 0x77, 0x70, 0x79, 0x77, 0x76, 0x07, 0xA7, 0x77, 0x50, 0x7B, 0x77, 0x74,
  0x07, 0xC7, 0x77, 0x30, 0x7D, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x10, 0x7B, 0x0B, 0xB7, 0x77, 0x07,
  0xB0, 0xB1, 0xB7, 0x76, 0x07, 0xB0, 0xB2, 0xB7, 0x75, 0x07, 0xB0, 0xB3, 0xB7, 0x74, 0x07, 0xB0,
  0xB4, 0xB7, 0x73, 0x07, 0xB0, 0xB5, 0xB7, 0x72, 0x07, 0xB0, 0xB6, 0xB7, 0x71, 0x07, 0xB0, 0xB7,
  0xB7, 0x70, 0x7B, 0x0B, 0x71, 0xB7, 0x60, 0x7B, 0x0B, 0x72, 0xB7, 0x50, 0x7B, 0x0B, 0x73, 0xB7,
  0x40, 0x7B, 0x0B, 0x74, 0xB7, 0x30, 0x7B, 0x0B, 0x75, 0xB7, 0x20, 0x7B, 0x0B, 0x76, 0xB7, 0x10,
  0x7B, 0x0B, 0x77, 0xB7, 0x07, 0xB0, 0xB7, 0x71, 0xB6, 0x07, 0xB0, 0xB7, 0x72, 0xB5, 0x07, 0xB0,
  0xB7, 0x73, 0xB4, 0x07, 0xB0, 0xB7, 0x74, 0xB3, 0x07, 0xB0, 0xB7, 0x75, 0xB2, 0x07, 0xFF, 0xFE,
  0x10, 0x7F, 0xFF, 0xF0, 0x7F, 0xFF, 0xF9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_null() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_null_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_cellular_off 36x36, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_sharp_36_device_signal_cellular_off_data[] PROGMEM = {
  0x77, 0x77, 0x20, 0x17, 0x77, 0x72, 0x00, 0x77, 0x77, 0x71, 0x81, 0x7F, 0x77, 0x77, 0x70, 0x7A,
  0x07, 0x77, 0x76, 0x07, 0xB0, 0x77, 0x03, 0x77, 0x40, 0x7C, 0x07, 0x68, 0x19, 0xF5, 0x77, 0x20,
  0x7D, 0x07, 0x50, 0x7B, 0x05, 0x77, 0x07, 0xE0, 0x75, 0x01, 0x0C, 0xB0, 0x57, 0x50, 0x7F, 0x07,
  0x60, 0x10, 0xCB, 0x05, 0x73, 0x07, 0xF9, 0x07, 0x70, 0x10, 0xCB, 0x05, 0x71, 0x07, 0xFA, 0x07,
  0x71, 0x01, 0x0C, 0xB0, 0x56, 0x07, 0xFB, 0x07, 0x72, 0x01, 0x0C, 0xB0, 0x54, 0x07, 0xFC, 0x07,
  0x73, 0x01, 0x0C, 0xB0, 0x53, 0x06, 0xFC, 0x07, 0x74, 0x01, 0x0C, 0xB0, 0x53, 0x06, 0xFB, 0x07,
  0x75, 0x01, 0x0C, 0xB0, 0x53, 0x06, 0xFA, 0x07, 0x76, 0x01, 0x0C, 0xB0, 0x53, 0x06, 0xF9, 0x07,
  0x77, 0x08, 0xC0, 0x53, 0x06, 0xF0, 0x77, 0x60, 0x7E, 0x05, 0x30, 0x6E, 0x07, 0x75, 0x07, 0xF9,
  0x05, 0x30, 0x6D, 0x07, 0x74, 0x07, 0xFB, 0x05, 0x30, 0x6C, 0x07, 0x73, 0x07, 0xFD, 0x05, 0x30,
  0x6B, 0x07, 0x72, 0x07, 0xFF, 0x05, 0x30, 0x6A, 0x07, 0x71, 0x07, 0xFF, 0xA0, 0x53, 0x81, 0x6F,
  0x77, 0x07, 0xFF, 0xC0, 0x53, 0x06, 0x07, 0x60, 0x7F, 0xFE, 0x05, 0x30, 0x15, 0x07, 0xFF, 0xF9,
  0x05, 0x70, 0x7F, 0xFF, 0xB0, 0x55, 0x07, 0xFF, 0xFD, 0x05, 0x30, 0x7F, 0xFF, 0xF8, 0x15, 0x01,
  0x80, 0xA6, 0x70, 0xCB, 0x05, 0x77, 0x76, 0x01, 0x0C, 0xA0, 0xD7, 0x77, 0x78, 0x21, 0xCE, 0x27,
  0x77, 0x71, 0x01, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_cellular_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 32, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_cellular_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_0_bar 36x36, 4-bit Alpha,  RLE, 223 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_0_bar_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAE, 0x83, 0xB7, 0x43, 0x12, 0x83,
  0x13, 0x47, 0xBE, 0x0A, 0x02, 0x70, 0x60, 0xEC, 0x0B, 0x04, 0x77, 0x04, 0x0B, 0xC0, 0xE0, 0x64,
  0x01, 0x0A, 0xC0, 0x90, 0x27, 0x74, 0x02, 0x09, 0xC8, 0x3A, 0x10, 0x1C, 0xB0, 0xD0, 0x37, 0x77,
  0x10, 0x30, 0xDB, 0x81, 0xC1, 0xBB, 0x0B, 0x77, 0x75, 0x0B, 0xB8, 0x1B, 0x1D, 0xB0, 0x47, 0x77,
  0x30, 0x4B, 0x83, 0xD1, 0x01, 0xDB, 0x04, 0x77, 0x71, 0x04, 0xB0, 0xD0, 0x13, 0x01, 0x0D, 0xB0,
  0x47, 0x76, 0x04, 0xB0, 0xD0, 0x15, 0x01, 0x0D, 0xB0, 0x47, 0x74, 0x04, 0xB0, 0xD0, 0x17, 0x01,
  0x0D, 0xB0, 0x47, 0x72, 0x04, 0xB0, 0xD0, 0x17, 0x20, 0x10, 0xDB, 0x04, 0x77, 0x04, 0xB0, 0xD0,
  0x17, 0x40, 0x10, 0xDB, 0x04, 0x75, 0x04, 0xB0, 0xD0, 0x17, 0x60, 0x10, 0xDB, 0x04, 0x73, 0x04,
  0xB0, 0xD0, 0x17, 0x71, 0x01, 0x0D, 0xB0, 0x47, 0x10, 0x4B, 0x0D, 0x01, 0x77, 0x30, 0x10, 0xDB,
  0x04, 0x60, 0x4B, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xDB, 0x04, 0x40, 0x4B, 0x0D, 0x01, 0x77, 0x70,
  0x10, 0xDB, 0x04, 0x20, 0x4B, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xB0, 0x04, 0xB0, 0xD0, 0x17,
  0x77, 0x40, 0x10, 0xDE, 0x0D, 0x01, 0x77, 0x76, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x77, 0x71, 0x01,
  0x0D, 0xA0, 0xD0, 0x17, 0x77, 0x73, 0x82, 0x1D, 0xD1, 0x77, 0x77, 0x50, 0x01, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_4_bar_lock 36x36, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_4_bar_lock_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAF, 0xFF, 0xB0, 0xA0, 0x27, 0x06,
  0x0E, 0xFF, 0xFD, 0x0E, 0x06, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x83, 0xA1, 0x01, 0xCF, 0xFF, 0xFC,
  0x81, 0xC1, 0xBF, 0xFF, 0xFE, 0x81, 0xB1, 0xDF, 0xFF, 0xFC, 0x83, 0xD1, 0x01, 0xDF, 0xFF, 0xFA,
  0x0D, 0x01, 0x30, 0x10, 0xDF, 0xFF, 0x98, 0x6D, 0xA8, 0x77, 0x77, 0x15, 0x01, 0x0D, 0xFF, 0xD0,
  0xE0, 0x67, 0x70, 0x10, 0xDF, 0xFB, 0x0E, 0x03, 0x77, 0x20, 0x10, 0xDF, 0xFA, 0x07, 0x48, 0x21,
  0x66, 0x17, 0x30, 0x10, 0xDF, 0xF0, 0xE4, 0x03, 0x0E, 0xA0, 0xE0, 0x37, 0x30, 0x10, 0xDF, 0xE0,
  0xA4, 0x84, 0xBD, 0x22, 0xDB, 0x74, 0x01, 0x0D, 0xFD, 0x09, 0x49, 0x08, 0x20, 0x80, 0xE7, 0x50,
  0x10, 0xDF, 0xC0, 0x84, 0x90, 0x72, 0x07, 0x97, 0x60, 0x10, 0xDF, 0xB0, 0x82, 0x07, 0xF9, 0x07,
  0x75, 0x01, 0x0D, 0xFA, 0x08, 0x20, 0x7F, 0x90, 0x77, 0x60, 0x10, 0xDF, 0x90, 0x82, 0x07, 0xF9,
  0x07, 0x77, 0x01, 0x0D, 0xE0, 0xD0, 0x12, 0x07, 0xF9, 0x07, 0x77, 0x10, 0x10, 0xDC, 0x0D, 0x01,
  0x30, 0x7F, 0x90, 0x77, 0x72, 0x01, 0x0D, 0xA0, 0xD0, 0x14, 0x07, 0xF9, 0x07, 0x77, 0x38, 0x21,
  0xDD, 0x15, 0x07, 0xF9, 0x07, 0x77, 0x40, 0x01, 0x60, 0x38, 0x04, 0x70, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_4_bar_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_4_bar_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_4_bar 36x36, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_4_bar_data[] PROGMEM = {
  0x76, 0x89, 0x01, 0x35, 0x57, 0x75, 0x53, 0x17, 0x77, 0x18, 0x22, 0x6A, 0xEF, 0xB8, 0x2E, 0xA6,
  0x27, 0x72, 0x06, 0x0C, 0xFF, 0xC0, 0xC0, 0x67, 0x48, 0x11, 0x8E, 0xFF, 0xF9, 0x81, 0xE8, 0x17,
  0x07, 0x0E, 0xFF, 0xFD, 0x0E, 0x07, 0x40, 0x30, 0xDF, 0xFF, 0xFA, 0x82, 0xD3, 0x03, 0xFF, 0xFF,
  0xE8, 0x13, 0x0A, 0xFF, 0xFF, 0xC0, 0xA3, 0x0C, 0xFF, 0xFF, 0xA0, 0xC4, 0x01, 0x0E, 0xFF, 0xFF,
  0x0E, 0x01, 0x50, 0x4F, 0xFF, 0xF0, 0x47, 0x06, 0xFF, 0xFD, 0x06, 0x72, 0x09, 0xFF, 0xFB, 0x09,
  0x74, 0x0C, 0xFF, 0xF9, 0x0C, 0x75, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x17, 0x60, 0x3F, 0xFE, 0x03,
  0x77, 0x10, 0x6F, 0xFC, 0x06, 0x77, 0x30, 0x9F, 0xFA, 0x09, 0x77, 0x50, 0xCF, 0xF0, 0xC7, 0x76,
  0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x70, 0x3F, 0xD0, 0x37, 0x77, 0x20, 0x6F, 0xB0, 0x67, 0x77,
  0x40, 0x9F, 0x90, 0x97, 0x77, 0x60, 0xCE, 0x0C, 0x77, 0x77, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77,
  0x71, 0x03, 0xC0, 0x37, 0x77, 0x73, 0x06, 0xA0, 0x67, 0x77, 0x75, 0x00, 0x97, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_bad 36x36, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_bad_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAF, 0xFF, 0xB0, 0xA0, 0x27, 0x06,
  0x0E, 0xFF, 0xFD, 0x0E, 0x06, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x83, 0xA1, 0x01, 0xCF, 0xFF, 0xFC,
  0x81, 0xC1, 0xBF, 0xFF, 0xFE, 0x81, 0xB1, 0xDF, 0xFF, 0xFC, 0x83, 0xD1, 0x01, 0xDF, 0xFF, 0xFA,
  0x0D, 0x01, 0x30, 0x10, 0xDF, 0xFF, 0xF0, 0xD0, 0x15, 0x01, 0x0D, 0xFF, 0xFD, 0x0D, 0x01, 0x70,
  0x10, 0xDF, 0xD7, 0x77, 0x20, 0x10, 0xDF, 0xC7, 0x77, 0x30, 0x10, 0xDF, 0xB7, 0x77, 0x40, 0x10,
  0xDF, 0xA4, 0x06, 0x09, 0x48, 0x12, 0xB1, 0x76, 0x01, 0x0D, 0xF9, 0x30, 0x6A, 0x09, 0x28, 0x32,
  0xEF, 0xC1, 0x76, 0x01, 0x0D, 0xF3, 0x09, 0xB8, 0x19, 0x3E, 0xA0, 0xE0, 0x27, 0x70, 0x10, 0xDE,
  0x40, 0x9E, 0x0E, 0x03, 0x77, 0x20, 0x10, 0xDD, 0x50, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x10, 0xDC,
  0x50, 0x3C, 0x0A, 0x77, 0x60, 0x10, 0xDB, 0x40, 0x20, 0xED, 0x09, 0x77, 0x60, 0x10, 0xDA, 0x30,
  0x20, 0xEA, 0x0E, 0x0A, 0xB0, 0x97, 0x76, 0x01, 0x0D, 0x93, 0x0B, 0xA8, 0x2E, 0x30, 0x9B, 0x03,
  0x77, 0x60, 0x10, 0xD3, 0x82, 0x1C, 0xE3, 0x38, 0x19, 0xF6, 0x77, 0x71, 0x01, 0x40, 0x10, 0x25,
  0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_connected_no_internet_4 36x36, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_connected_no_internet_4_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAF, 0xFF, 0xB0, 0xA0, 0x27, 0x06,
  0x0E, 0xFF, 0xFD, 0x0E, 0x06, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x83, 0xA1, 0x01, 0xCF, 0xFF, 0xFC,
  0x81, 0xC1, 0xBF, 0xFF, 0xFE, 0x81, 0xB1, 0xDF, 0xFF, 0xFC, 0x83, 0xD1, 0x01, 0xDF, 0xFF, 0xFA,
  0x0D, 0x01, 0x30, 0x10, 0xDF, 0xFF, 0xF0, 0xD0, 0x15, 0x01, 0x0D, 0xFF, 0xFD, 0x0D, 0x01, 0x70,
  0x10, 0xDF, 0xD7, 0x77, 0x20, 0x10, 0xDF, 0xC7, 0x77, 0x30, 0x10, 0xDF, 0xB7, 0x77, 0x40, 0x10,
  0xDF, 0xA4, 0x06, 0x09, 0x48, 0x12, 0xB1, 0x76, 0x01, 0x0D, 0xF9, 0x30, 0x6A, 0x09, 0x28, 0x32,
  0xEF, 0xC1, 0x76, 0x01, 0x0D, 0xF3, 0x09, 0xB8, 0x19, 0x3E, 0xA0, 0xE0, 0x27, 0x70, 0x10, 0xDE,
  0x40, 0x9E, 0x0E, 0x03, 0x77, 0x20, 0x10, 0xDD, 0x50, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x10, 0xDC,
  0x50, 0x3C, 0x0A, 0x77, 0x60, 0x10, 0xDB, 0x40, 0x20, 0xED, 0x09, 0x77, 0x60, 0x10, 0xDA, 0x30,
  0x20, 0xEA, 0x0E, 0x0A, 0xB0, 0x97, 0x76, 0x01, 0x0D, 0x93, 0x0B, 0xA8, 0x2E, 0x30, 0x9B, 0x03,
  0x77, 0x60, 0x10, 0xD3, 0x82, 0x1C, 0xE3, 0x38, 0x19, 0xF6, 0x77, 0x71, 0x01, 0x40, 0x10, 0x25,
  0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_connected_no_internet_4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_connected_no_internet_4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_off 36x36, 4-bit Alpha,  RLE, 222 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_off_data[] PROGMEM = {
  0x40, 0x60, 0x97, 0x77, 0x75, 0x06, 0xA0, 0x97, 0x77, 0x74, 0x08, 0xB0, 0x95, 0x89, 0x01, 0x35,
  0x67, 0x75, 0x53, 0x17, 0x73, 0x08, 0xB0, 0x93, 0x02, 0x0E, 0xFA, 0x82, 0xEA, 0x62, 0x77, 0x08,
  0xB0, 0x93, 0x02, 0x0E, 0xFD, 0x0C, 0x06, 0x74, 0x01, 0x08, 0xC0, 0x93, 0x02, 0x0E, 0xFE, 0x81,
  0xE8, 0x17, 0x07, 0x0E, 0xE0, 0x93, 0x02, 0x0E, 0xFF, 0x0E, 0x07, 0x40, 0x30, 0xDF, 0xA0, 0x93,
  0x02, 0x0E, 0xFF, 0x98, 0x2D, 0x30, 0x3F, 0xD0, 0x93, 0x02, 0x0E, 0xFF, 0xA8, 0x13, 0x0A, 0xFD,
  0x09, 0x30, 0x20, 0xEF, 0xF0, 0xA3, 0x0C, 0xFD, 0x09, 0x30, 0x20, 0xEF, 0xD0, 0xC4, 0x01, 0x0E,
  0xFD, 0x09, 0x30, 0x20, 0xEF, 0xB0, 0xE0, 0x15, 0x04, 0xFE, 0x09, 0x30, 0x20, 0xEF, 0xA0, 0x47,
  0x06, 0xFE, 0x09, 0x30, 0x20, 0xEF, 0x07, 0x72, 0x09, 0xFE, 0x09, 0x30, 0x20, 0xED, 0x0A, 0x74,
  0x0C, 0xFE, 0x09, 0x30, 0x20, 0xEB, 0x0C, 0x75, 0x01, 0x0E, 0xFE, 0x09, 0x38, 0x32, 0xEF, 0xE1,
  0x76, 0x03, 0xFF, 0x09, 0x38, 0x12, 0xE4, 0x77, 0x10, 0x6F, 0xF0, 0x97, 0x77, 0x09, 0xFF, 0x09,
  0x77, 0x70, 0xCF, 0xF0, 0x97, 0x76, 0x01, 0x0E, 0xFF, 0x09, 0x77, 0x60, 0x3F, 0xF9, 0x09, 0x77,
  0x60, 0x6F, 0xB0, 0x60, 0x8B, 0x09, 0x77, 0x60, 0x9F, 0x90, 0x92, 0x08, 0xB0, 0x97, 0x76, 0x0C,
  0xE0, 0xC4, 0x08, 0xB0, 0x97, 0x75, 0x01, 0x0D, 0xC0, 0xE0, 0x15, 0x08, 0xA0, 0x47, 0x76, 0x03,
  0xC0, 0x37, 0x08, 0x04, 0x77, 0x71, 0x06, 0xA0, 0x67, 0x77, 0x75, 0x00, 0x97, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_statusbar_4_bar 36x36, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_statusbar_4_bar_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAF, 0xFF, 0xB0, 0xA0, 0x27, 0x06,
  0x0E, 0xFF, 0xFD, 0x0E, 0x06, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x83, 0xA1, 0x01, 0xCF, 0xFF, 0xFC,
  0x81, 0xC1, 0xBF, 0xFF, 0xFE, 0x81, 0xB1, 0xDF, 0xFF, 0xFC, 0x83, 0xD1, 0x01, 0xDF, 0xFF, 0xFA,
  0x0D, 0x01, 0x30, 0x10, 0xDF, 0xFF, 0xF0, 0xD0, 0x15, 0x01, 0x0D, 0xFF, 0xFD, 0x0D, 0x01, 0x70,
  0x10, 0xDF, 0xFF, 0xB0, 0xD0, 0x17, 0x20, 0x10, 0xDF, 0xFF, 0x90, 0xD0, 0x17, 0x40, 0x10, 0xDF,
  0xFE, 0x0D, 0x01, 0x76, 0x01, 0x0D, 0xFF, 0xC0, 0xD0, 0x17, 0x71, 0x01, 0x0D, 0xFF, 0xA0, 0xD0,
  0x17, 0x73, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xD0, 0xD0, 0x17, 0x77, 0x01,
  0x0D, 0xFB, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x74, 0x01, 0x0D, 0xE0,
  0xD0, 0x17, 0x77, 0x60, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x10, 0xDA, 0x0D, 0x01, 0x77,
  0x77, 0x38, 0x21, 0xDD, 0x17, 0x77, 0x75, 0x00, 0x17, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_statusbar_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_statusbar_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_statusbar_connected_no_internet_4 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_statusbar_connected_no_internet_4_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4E, 0xDB, 0x95, 0x27, 0x73, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x75, 0x03, 0x0B, 0xFF, 0xE0, 0xA0, 0x37, 0x10, 0x20, 0xAF, 0xFF, 0xB0, 0xA0, 0x15, 0x06,
  0x0E, 0xFF, 0xFD, 0x0E, 0x06, 0x20, 0x10, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xCF, 0xFF, 0xA0, 0x77,
  0x10, 0xBF, 0xFF, 0xB0, 0x77, 0x10, 0x10, 0xDF, 0xFF, 0xA0, 0x77, 0x20, 0x10, 0xDF, 0xFF, 0x90,
  0x72, 0x07, 0xA0, 0x74, 0x01, 0x0D, 0xFF, 0xF0, 0x72, 0x07, 0xA0, 0x75, 0x01, 0x0D, 0xFF, 0xE0,
  0x72, 0x07, 0xA0, 0x76, 0x01, 0x0D, 0xFF, 0xD0, 0x72, 0x07, 0xA0, 0x77, 0x01, 0x0D, 0xFF, 0xC0,
  0x72, 0x07, 0xA0, 0x77, 0x10, 0x10, 0xDF, 0xFB, 0x07, 0x20, 0x7A, 0x07, 0x72, 0x01, 0x0D, 0xFF,
  0xA0, 0x72, 0x07, 0xA0, 0x77, 0x30, 0x10, 0xDF, 0xF9, 0x07, 0x20, 0x7A, 0x07, 0x74, 0x01, 0x0D,
  0xFF, 0x07, 0x20, 0x7A, 0x07, 0x75, 0x01, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xDF, 0xB0,
  0xD0, 0x17, 0x77, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xE0, 0xD0, 0x15, 0x07,
  0xA0, 0x77, 0x72, 0x01, 0x0D, 0xC0, 0xD0, 0x16, 0x07, 0xA0, 0x77, 0x73, 0x01, 0x0D, 0xA0, 0xD0,
  0x17, 0x07, 0xA0, 0x77, 0x74, 0x82, 0x1D, 0xD1, 0x77, 0x77, 0x30, 0x01, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_statusbar_connected_no_internet_4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 33, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_statusbar_connected_no_internet_4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_signal_wifi_statusbar_null 36x36, 4-bit Alpha,  RLE, 223 bytes.
static const unsigned char ic_sharp_36_device_signal_wifi_statusbar_null_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAE, 0x83, 0xB7, 0x43, 0x12, 0x83,
  0x13, 0x47, 0xBE, 0x0A, 0x02, 0x70, 0x60, 0xEC, 0x0B, 0x04, 0x77, 0x04, 0x0B, 0xC0, 0xE0, 0x64,
  0x01, 0x0A, 0xC0, 0x90, 0x27, 0x74, 0x02, 0x09, 0xC8, 0x3A, 0x10, 0x1C, 0xB0, 0xD0, 0x37, 0x77,
  0x10, 0x30, 0xDB, 0x81, 0xC1, 0xBB, 0x0B, 0x77, 0x75, 0x0B, 0xB8, 0x1B, 0x1D, 0xB0, 0x47, 0x77,
  0x30, 0x4B, 0x83, 0xD1, 0x01, 0xDB, 0x04, 0x77, 0x71, 0x04, 0xB0, 0xD0, 0x13, 0x01, 0x0D, 0xB0,
  0x47, 0x76, 0x04, 0xB0, 0xD0, 0x15, 0x01, 0x0D, 0xB0, 0x47, 0x74, 0x04, 0xB0, 0xD0, 0x17, 0x01,
  0x0D, 0xB0, 0x47, 0x72, 0x04, 0xB0, 0xD0, 0x17, 0x20, 0x10, 0xDB, 0x04, 0x77, 0x04, 0xB0, 0xD0,
  0x17, 0x40, 0x10, 0xDB, 0x04, 0x75, 0x04, 0xB0, 0xD0, 0x17, 0x60, 0x10, 0xDB, 0x04, 0x73, 0x04,
  0xB0, 0xD0, 0x17, 0x71, 0x01, 0x0D, 0xB0, 0x47, 0x10, 0x4B, 0x0D, 0x01, 0x77, 0x30, 0x10, 0xDB,
  0x04, 0x60, 0x4B, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xDB, 0x04, 0x40, 0x4B, 0x0D, 0x01, 0x77, 0x70,
  0x10, 0xDB, 0x04, 0x20, 0x4B, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xB0, 0x04, 0xB0, 0xD0, 0x17,
  0x77, 0x40, 0x10, 0xDE, 0x0D, 0x01, 0x77, 0x76, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x77, 0x71, 0x01,
  0x0D, 0xA0, 0xD0, 0x17, 0x77, 0x73, 0x82, 0x1D, 0xD1, 0x77, 0x77, 0x50, 0x01, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_signal_wifi_statusbar_null() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_signal_wifi_statusbar_null_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_sim_card_download 36x36, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_sharp_36_device_sim_card_download_data[] PROGMEM = {
  0x71, 0x07, 0xFF, 0x97, 0x07, 0xFF, 0xA6, 0x07, 0xFF, 0xB5, 0x07, 0xFF, 0xC4, 0x07, 0xFF, 0xD3,
  0x07, 0xFF, 0xE2, 0x07, 0xFF, 0xF1, 0x07, 0xFF, 0xF9, 0x07, 0x80, 0xE5, 0xF8, 0x2B, 0x77, 0xBF,
  0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F,
  0xFE, 0x07, 0x20, 0x7F, 0xFA, 0x83, 0x97, 0x77, 0x32, 0x83, 0x37, 0x77, 0x9F, 0xD0, 0xD0, 0x17,
  0x10, 0x10, 0xDF, 0xE0, 0xD0, 0x16, 0x01, 0x0D, 0xFF, 0x90, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xB0,
  0xD0, 0x12, 0x01, 0x0D, 0xFF, 0xD8, 0x2D, 0x11, 0xDF, 0xFF, 0x00, 0xD8, 0x0A, 0xD7, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_sim_card_download() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_sim_card_download_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_splitscreen 36x36, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_sharp_36_device_splitscreen_data[] PROGMEM = {
  0x80, 0x98, 0x7F, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77,
  0x4E, 0x80, 0x96, 0x78, 0x0D, 0x7F, 0x80, 0xA4, 0x78, 0x0D, 0x40, 0x80, 0xA4, 0x78, 0x0D, 0x7F,
  0x80, 0x96, 0x7E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77,
  0x48, 0x09, 0x87, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_splitscreen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_splitscreen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_sports_score 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_sharp_36_device_sports_score_data[] PROGMEM = {
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x07, 0xD0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x73, 0x07, 0xD0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x73, 0x07, 0xD0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x73, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xD0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x73, 0x07, 0xD0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x73, 0x07,
  0xD0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x73, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x74, 0x07, 0xA0, 0x77,
  0x74, 0x07, 0xA0, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x74, 0x07, 0xA0, 0x77,
  0x74, 0x07, 0xA0, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_sports_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 6, 28, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_sports_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_ssid_chart 36x36, 4-bit Alpha,  RLE, 203 bytes.
static const unsigned char ic_sharp_36_device_ssid_chart_data[] PROGMEM = {
  0x77, 0x76, 0x02, 0x77, 0x74, 0x81, 0x1B, 0x77, 0x77, 0x38, 0x25, 0xEF, 0x77, 0x04, 0x77, 0x10,
  0x9B, 0x07, 0x68, 0x19, 0xFB, 0x75, 0x02, 0x0C, 0xB0, 0xD0, 0x34, 0x02, 0x0C, 0xB0, 0xB7, 0x30,
  0x6C, 0x0A, 0x50, 0x60, 0xED, 0x0B, 0x70, 0x10, 0xAB, 0x0E, 0x05, 0x40, 0x10, 0xAB, 0x0E, 0x0A,
  0xB0, 0xB5, 0x03, 0x0D, 0xB0, 0xC0, 0x24, 0x03, 0x0D, 0xB8, 0x2C, 0x20, 0x7B, 0x0B, 0x30, 0x7C,
  0x08, 0x60, 0x7B, 0x08, 0x40, 0x7B, 0x81, 0xB2, 0xBB, 0x0E, 0x04, 0x78, 0x27, 0xFE, 0x46, 0x07,
  0xF0, 0xB0, 0x17, 0x18, 0x17, 0xB1, 0x71, 0x07, 0xD0, 0x77, 0x30, 0x27, 0x40, 0x7A, 0x0D, 0x03,
  0x77, 0x73, 0x07, 0x09, 0x77, 0x30, 0x01, 0x77, 0x74, 0x82, 0x4E, 0xC1, 0x77, 0x72, 0x09, 0xB0,
  0xD0, 0x17, 0x76, 0x02, 0x0D, 0xD0, 0xD0, 0x17, 0x75, 0x07, 0xB0, 0xBB, 0x0D, 0x02, 0x73, 0x06,
  0x80, 0x27, 0x85, 0x37, 0xFE, 0x50, 0x4B, 0x0D, 0x02, 0x70, 0x10, 0xBF, 0x82, 0x77, 0xB1, 0x30,
  0x40, 0xEA, 0x0E, 0x02, 0x50, 0x20, 0xDF, 0x90, 0x70, 0x26, 0x03, 0x0E, 0xA0, 0xE0, 0x33, 0x05,
  0x0E, 0xB0, 0x98, 0x01, 0x70, 0x37, 0x10, 0x30, 0xEA, 0x82, 0xE3, 0x08, 0xB0, 0xE0, 0x47, 0x72,
  0x03, 0x0E, 0xA0, 0xE0, 0xBB, 0x0D, 0x02, 0x77, 0x40, 0x20, 0xED, 0x0A, 0x77, 0x70, 0x20, 0xDB,
  0x07, 0x77, 0x72, 0x82, 0x2D, 0xE4, 0x77, 0x74, 0x00, 0x27, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_ssid_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_ssid_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_storage 36x36, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_36_device_storage_data[] PROGMEM = {
  0xFF, 0xFF, 0xD0, 0xF7, 0xFF, 0xFE, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x0F, 0x78, 0x0E, 0x2F, 0x80,
  0x9A, 0x60, 0xFF, 0xFF, 0xD0, 0xF7, 0xFF, 0xFE, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x0F, 0x78, 0x0E,
  0x2F, 0x80, 0x9A, 0x60, 0xFF, 0xFF, 0xD0, 0xF7, 0xFF, 0xFE, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x0F,
  0x78, 0x0E, 0x2F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_storage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_storage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_storm 36x36, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_sharp_36_device_storm_data[] PROGMEM = {
  0x10, 0x8A, 0x09, 0x77, 0x73, 0x0C, 0xA0, 0x47, 0x77, 0x20, 0x1A, 0x0E, 0x77, 0x73, 0x04, 0xA0,
  0xB5, 0x89, 0x01, 0x6A, 0xDE, 0xFD, 0xA6, 0x17, 0x20, 0x7A, 0x08, 0x30, 0x10, 0x9F, 0xB0, 0x90,
  0x17, 0x09, 0xA0, 0x62, 0x05, 0x0E, 0xFD, 0x0E, 0x05, 0x60, 0xAA, 0x81, 0x40, 0x6C, 0x81, 0xB5,
  0x22, 0x81, 0x25, 0xBC, 0x06, 0x50, 0xBA, 0x03, 0x05, 0xB0, 0xD0, 0x37, 0x10, 0x30, 0xDB, 0x04,
  0x40, 0xBA, 0x05, 0x0E, 0xA0, 0xB7, 0x40, 0x10, 0xBA, 0x0E, 0x01, 0x30, 0xBA, 0x0D, 0xA0, 0xD4,
  0x84, 0x6C, 0xEE, 0xC6, 0x40, 0xDA, 0x0A, 0x30, 0xAD, 0x03, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x20,
  0x3B, 0x02, 0x20, 0x8C, 0x0B, 0x30, 0xCF, 0x90, 0xC3, 0x0B, 0xA0, 0x92, 0x06, 0xC0, 0x52, 0x06,
  0xB8, 0x27, 0x11, 0x7B, 0x06, 0x20, 0x6B, 0x81, 0x10, 0x3C, 0x02, 0x20, 0xCA, 0x07, 0x40, 0x7A,
  0x0C, 0x20, 0x2B, 0x06, 0x20, 0xEB, 0x30, 0xEA, 0x01, 0x40, 0x1A, 0x0E, 0x3B, 0x0B, 0x20, 0xBB,
  0x30, 0xEA, 0x01, 0x40, 0x1A, 0x0E, 0x3B, 0x0E, 0x20, 0x6B, 0x02, 0x20, 0xCA, 0x07, 0x40, 0x7A,
  0x0C, 0x20, 0x2C, 0x81, 0x30, 0x1B, 0x06, 0x20, 0x6B, 0x82, 0x71, 0x17, 0xB0, 0x62, 0x05, 0xC0,
  0x62, 0x09, 0xA0, 0xB3, 0x0C, 0xF9, 0x0C, 0x30, 0xBC, 0x08, 0x20, 0x2B, 0x03, 0x20, 0x10, 0xCE,
  0x0C, 0x01, 0x20, 0x3D, 0x0A, 0x30, 0xAA, 0x0D, 0x48, 0x46, 0xCE, 0xEC, 0x64, 0x0D, 0xA0, 0xDA,
  0x0B, 0x30, 0x10, 0xEA, 0x0B, 0x01, 0x74, 0x0B, 0xA0, 0xE0, 0x5A, 0x0B, 0x40, 0x4B, 0x0D, 0x03,
  0x71, 0x03, 0x0D, 0xB0, 0x50, 0x3A, 0x0B, 0x50, 0x6C, 0x81, 0xB5, 0x22, 0x81, 0x25, 0xBC, 0x81,
  0x60, 0x4A, 0x0A, 0x60, 0x50, 0xEF, 0xD0, 0xE0, 0x52, 0x06, 0xA0, 0x97, 0x01, 0x09, 0xFB, 0x09,
  0x01, 0x30, 0x8A, 0x07, 0x72, 0x89, 0x01, 0x6A, 0xDF, 0xDD, 0xA6, 0x15, 0x0B, 0xA0, 0x47, 0x77,
  0x30, 0xEA, 0x01, 0x77, 0x72, 0x04, 0xA0, 0xC7, 0x77, 0x30, 0x9A, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_storm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_storm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_summarize 36x36, 4-bit Alpha,  RLE, 144 bytes.
static const unsigned char ic_sharp_36_device_summarize_data[] PROGMEM = {
  0x03, 0x80, 0x95, 0x70, 0x57, 0x20, 0x7F, 0xFC, 0x07, 0x71, 0x07, 0xFF, 0xD0, 0x77, 0x07, 0xFF,
  0xA0, 0x4B, 0x07, 0x60, 0x7F, 0xFA, 0x10, 0x4B, 0x07, 0x50, 0x7F, 0xFA, 0x20, 0x4B, 0x07, 0x40,
  0x7E, 0x00, 0x9F, 0x93, 0x04, 0xB0, 0x73, 0x07, 0xD0, 0x92, 0x09, 0xF4, 0x04, 0xB0, 0x72, 0x07,
  0xD0, 0x92, 0x09, 0xF5, 0x04, 0xB8, 0x17, 0x07, 0xE0, 0x09, 0xF9, 0x60, 0x4B, 0x05, 0x07, 0xFF,
  0xA7, 0x04, 0xA0, 0x07, 0xFF, 0xFD, 0x00, 0x7E, 0x00, 0x9F, 0xFC, 0x00, 0x7D, 0x09, 0x20, 0x9F,
  0xFB, 0x00, 0x7D, 0x09, 0x20, 0x9F, 0xFB, 0x00, 0x7E, 0x00, 0x9F, 0xFC, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x00, 0x7E, 0x00, 0x9F, 0xFC, 0x00, 0x7D, 0x09, 0x20, 0x9F, 0xFB, 0x00, 0x7D,
  0x09, 0x20, 0x9F, 0xFB, 0x00, 0x7E, 0x00, 0x9F, 0xFC, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x38, 0x0A, 0x67, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_summarize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_summarize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_system_security_update_good 36x36, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_sharp_36_device_system_security_update_good_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x73, 0x09, 0x06, 0x20, 0x7A, 0x00, 0x7A, 0x07, 0x72, 0x09, 0xA8, 0x16, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x10, 0x9B, 0x81, 0x80, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x10, 0x93, 0x09, 0xB0,
  0x82, 0x07, 0xA0, 0x07, 0xA8, 0x67, 0x01, 0xCF, 0xB0, 0x9B, 0x08, 0x30, 0x7A, 0x00, 0x7A, 0x81,
  0x70, 0x5B, 0x0E, 0xB0, 0x84, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x06, 0xD0, 0x85, 0x07, 0xA0, 0x07,
  0xA0, 0x73, 0x06, 0xB0, 0x86, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x81, 0x6F, 0x87, 0x07, 0xA0, 0x07,
  0xA0, 0x75, 0x03, 0x71, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xFF, 0xE0, 0x07,
  0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF,
  0xE0, 0x70, 0x38, 0x0A, 0x07, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_system_security_update_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_system_security_update_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_system_security_update 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_sharp_36_device_system_security_update_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA8, 0x17, 0x07, 0xFB, 0x81,
  0x70, 0x7A, 0x00, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x73, 0x07, 0xE0,
  0x73, 0x07, 0xA0, 0x07, 0xA0, 0x74, 0x07, 0xC0, 0x74, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x76, 0x00, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00,
  0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x07,
  0x03, 0x80, 0xA0, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_system_security_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_system_security_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_system_security_update_warning 36x36, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_sharp_36_device_system_security_update_warning_data[] PROGMEM = {
  0x03, 0x80, 0xA0, 0x70, 0x30, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07,
  0xA0, 0x75, 0x82, 0x37, 0x73, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00,
  0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x58, 0x23, 0x77, 0x35, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x75, 0x82, 0x37,
  0x73, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x50, 0x7A,
  0x07, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x58, 0x23, 0x77, 0x35, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE,
  0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x07, 0x03, 0x80, 0xA0, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_system_security_update_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 34), Box(0, 0, 35, 35),
      ic_sharp_36_device_system_security_update_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_task 36x36, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_sharp_36_device_task_data[] PROGMEM = {
  0xFF, 0x90, 0x77, 0x1F, 0xFA, 0x07, 0x7F, 0xE0, 0xBB, 0x07, 0x6F, 0xE0, 0x70, 0x4B, 0x07, 0x5F,
  0xE8, 0x17, 0x04, 0xB0, 0x74, 0xFE, 0x07, 0x20, 0x4B, 0x07, 0x3F, 0xE0, 0x73, 0x04, 0xB0, 0x72,
  0xFE, 0x07, 0x40, 0x4B, 0x07, 0x1F, 0xE0, 0x75, 0x04, 0xB0, 0x7F, 0xE0, 0x76, 0x04, 0xFF, 0xA0,
  0xB8, 0x03, 0x70, 0xB8, 0x0F, 0x6F, 0x0A, 0x0E, 0xFF, 0xF8, 0x29, 0x03, 0xEF, 0xFD, 0x09, 0x30,
  0x5F, 0xD0, 0xDD, 0x09, 0x30, 0x20, 0xEF, 0xC8, 0x14, 0x1C, 0xB0, 0x93, 0x02, 0x0E, 0xFC, 0x05,
  0x28, 0x21, 0xCF, 0x93, 0x02, 0x0E, 0xFD, 0x0C, 0x01, 0x20, 0x10, 0x73, 0x02, 0x0E, 0xFF, 0x0C,
  0x01, 0x50, 0x20, 0xEF, 0xFA, 0x0C, 0x01, 0x30, 0x20, 0xEF, 0xFC, 0x83, 0xC1, 0x02, 0xEF, 0xFE,
  0x81, 0xC3, 0xE8, 0x0A, 0xB0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_task() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_task_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_thermostat 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_sharp_36_device_thermostat_data[] PROGMEM = {
  0x58, 0x42, 0xAD, 0xDA, 0x27, 0x20, 0x4E, 0x04, 0x71, 0x0E, 0xE0, 0xE7, 0x04, 0xA8, 0x2D, 0x22,
  0xDA, 0x04, 0x60, 0x7A, 0x82, 0x80, 0x7B, 0xA0, 0x76, 0x07, 0xA0, 0x71, 0xC0, 0x76, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76,
  0x07, 0xA0, 0x71, 0xC0, 0x76, 0x07, 0xA8, 0x27, 0x07, 0xBA, 0x07, 0x60, 0x7A, 0x07, 0x20, 0x7A,
  0x07, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0x7A, 0x82, 0xB7, 0x7B, 0xA0, 0x76, 0x07, 0xF9,
  0x07, 0x60, 0x7F, 0x90, 0x76, 0x09, 0xF9, 0x09, 0x50, 0x8F, 0xB0, 0x83, 0x04, 0xFD, 0x04, 0x20,
  0xCF, 0xD8, 0x1C, 0x03, 0xFF, 0x03, 0x05, 0xFF, 0x05, 0x07, 0xFF, 0x07, 0x06, 0xFF, 0x06, 0x03,
  0xFF, 0x81, 0x30, 0xDF, 0xD0, 0xD2, 0x04, 0xFD, 0x04, 0x30, 0x8F, 0xB0, 0x85, 0x07, 0xF9, 0x07,
  0x78, 0x61, 0x8C, 0xEE, 0xC8, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_thermostat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 25, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_thermostat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_timer_10_select 36x36, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_sharp_36_device_timer_10_select_data[] PROGMEM = {
  0x03, 0x80, 0x37, 0x10, 0x38, 0x09, 0x17, 0x74, 0x07, 0xF1, 0x07, 0xFE, 0x74, 0x07, 0xF1, 0x07,
  0xFE, 0x74, 0x07, 0xF1, 0x07, 0xFE, 0x74, 0x07, 0xF1, 0x07, 0xFE, 0x77, 0x07, 0xC1, 0x07, 0xC4,
  0x07, 0xC7, 0x70, 0x7C, 0x10, 0x7C, 0x40, 0x7C, 0x77, 0x07, 0xC1, 0x07, 0xC4, 0x07, 0xC7, 0x70,
  0x7C, 0x10, 0x7C, 0x40, 0x7C, 0x77, 0x07, 0xC1, 0x07, 0xC4, 0x07, 0xC1, 0x03, 0x80, 0x47, 0x03,
  0x30, 0x7C, 0x10, 0x7C, 0x40, 0x7C, 0x10, 0x7F, 0x90, 0x73, 0x07, 0xC1, 0x07, 0xC4, 0x07, 0xC1,
  0x07, 0xF9, 0x07, 0x30, 0x7C, 0x10, 0x7C, 0x40, 0x7C, 0x10, 0x7A, 0x0B, 0x80, 0x17, 0x03, 0x30,
  0x7C, 0x10, 0x7C, 0x40, 0x7C, 0x10, 0x7A, 0x07, 0x72, 0x07, 0xC1, 0x07, 0xC4, 0x07, 0xC1, 0x07,
  0xF9, 0x07, 0x30, 0x7C, 0x10, 0x7C, 0x40, 0x7C, 0x10, 0x7F, 0x90, 0x73, 0x07, 0xC1, 0x07, 0xC4,
  0x07, 0xC1, 0x07, 0xF9, 0x07, 0x30, 0x7C, 0x10, 0x7F, 0xE7, 0x07, 0xA0, 0x73, 0x07, 0xC1, 0x07,
  0xFE, 0x10, 0x38, 0x01, 0x70, 0xBA, 0x07, 0x30, 0x7C, 0x10, 0x7F, 0xE1, 0x07, 0xF9, 0x07, 0x30,
  0x7C, 0x10, 0x7F, 0xE1, 0x07, 0xF9, 0x07, 0x38, 0x53, 0x77, 0x77, 0x03, 0x80, 0x91, 0x71, 0x03,
  0x80, 0x47, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_timer_10_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 28), Box(0, 0, 35, 35),
      ic_sharp_36_device_timer_10_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_timer_3_select 36x36, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_sharp_36_device_timer_3_select_data[] PROGMEM = {
  0x80, 0x91, 0x70, 0x37, 0x5F, 0xE0, 0x77, 0x5F, 0xE0, 0x77, 0x5F, 0xE0, 0x77, 0x5F, 0xE0, 0x77,
  0x77, 0xC0, 0x77, 0x77, 0xC0, 0x77, 0x77, 0xC0, 0x77, 0x58, 0x05, 0x3C, 0x07, 0x75, 0xFE, 0x07,
  0x20, 0x38, 0x04, 0x70, 0x3F, 0xE0, 0x72, 0x07, 0xF9, 0x07, 0xFE, 0x07, 0x20, 0x7F, 0x90, 0x7F,
  0xE0, 0x72, 0x07, 0xA0, 0xB8, 0x01, 0x78, 0x06, 0x3C, 0x07, 0x20, 0x7A, 0x07, 0x77, 0x1C, 0x07,
  0x20, 0x7F, 0x90, 0x77, 0x2C, 0x07, 0x20, 0x7F, 0x90, 0x77, 0x2C, 0x07, 0x20, 0x7F, 0x90, 0x7F,
  0xE0, 0x77, 0x10, 0x7A, 0x07, 0xFE, 0x07, 0x20, 0x38, 0x01, 0x70, 0xBA, 0x07, 0xFE, 0x07, 0x20,
  0x7F, 0x90, 0x7F, 0xE0, 0x72, 0x07, 0xF9, 0x80, 0x92, 0x70, 0x32, 0x03, 0x80, 0x47, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_timer_3_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 7, 31, 28), Box(0, 0, 35, 35),
      ic_sharp_36_device_timer_3_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_tungsten 36x36, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_sharp_36_device_tungsten_data[] PROGMEM = {
  0x73, 0x03, 0x80, 0x47, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60,
  0x7A, 0x82, 0xB7, 0x7B, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA8, 0x2A, 0x77, 0xAA, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77,
  0x75, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x77, 0x40, 0xDF, 0xB0, 0xD7, 0x73, 0x09, 0xFD, 0x09, 0x77,
  0x20, 0xEF, 0xD0, 0xE7, 0x18, 0x00, 0x70, 0x32, 0x04, 0xFF, 0x04, 0x20, 0x38, 0x00, 0x7C, 0x07,
  0x20, 0x6F, 0xF0, 0x62, 0x07, 0xF9, 0x07, 0x20, 0x6F, 0xF0, 0x62, 0x07, 0xC8, 0x00, 0x70, 0x32,
  0x05, 0xFF, 0x05, 0x20, 0x38, 0x00, 0x77, 0x1F, 0xF7, 0x72, 0x09, 0xFD, 0x09, 0x77, 0x20, 0x10,
  0xDF, 0xB0, 0xD0, 0x17, 0x73, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x77, 0x10, 0x01, 0x20, 0x10, 0x9E,
  0x09, 0x01, 0x20, 0x01, 0x74, 0x82, 0x1C, 0xD1, 0x48, 0x25, 0x77, 0x54, 0x82, 0x1D, 0xC1, 0x72,
  0x01, 0x0C, 0xA0, 0xD7, 0x50, 0xDA, 0x0C, 0x01, 0x71, 0x0C, 0xB0, 0x57, 0x50, 0x5B, 0x0C, 0x71,
  0x06, 0xA0, 0x55, 0x82, 0x37, 0x73, 0x50, 0x5A, 0x06, 0x72, 0x06, 0x05, 0x60, 0x7A, 0x07, 0x60,
  0x50, 0x67, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_tungsten() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_tungsten_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_usb_off 36x36, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_sharp_36_device_usb_off_data[] PROGMEM = {
  0x77, 0x10, 0x05, 0x77, 0x02, 0x06, 0x74, 0x82, 0x2E, 0xE2, 0x75, 0x82, 0x2E, 0xF7, 0x73, 0x0C,
  0xA0, 0xC7, 0x50, 0x9B, 0x07, 0x71, 0x09, 0xC0, 0x97, 0x50, 0xBB, 0x07, 0x60, 0x5E, 0x05, 0x75,
  0x0B, 0xB0, 0x74, 0x02, 0x0E, 0xE0, 0xE0, 0x27, 0x50, 0xBB, 0x07, 0x60, 0x7A, 0x07, 0x77, 0x20,
  0xBB, 0x07, 0x50, 0x7A, 0x07, 0x77, 0x30, 0xBB, 0x07, 0x40, 0x7A, 0x07, 0x77, 0x40, 0xBB, 0x07,
  0x30, 0x3A, 0x07, 0x20, 0x7D, 0x07, 0x71, 0x01, 0x0E, 0xC0, 0x73, 0x81, 0x4F, 0x72, 0x07, 0xD0,
  0x77, 0x10, 0x6E, 0x07, 0x30, 0x40, 0x72, 0x07, 0xD0, 0x77, 0x10, 0x6F, 0x07, 0x60, 0x7D, 0x07,
  0x71, 0x01, 0x0E, 0xF0, 0x75, 0x07, 0xD0, 0x77, 0x20, 0x3B, 0x03, 0x0B, 0xB0, 0x74, 0x07, 0xD0,
  0x77, 0x3B, 0x20, 0xBB, 0x07, 0x5B, 0x75, 0xB3, 0x0B, 0xB0, 0x74, 0xB7, 0x5B, 0x40, 0xBB, 0x07,
  0x30, 0x4A, 0x75, 0x0D, 0xFC, 0x07, 0x30, 0x40, 0xD7, 0x50, 0x8F, 0xD0, 0x73, 0x01, 0x76, 0x08,
  0x0E, 0xFC, 0x07, 0x77, 0x71, 0x07, 0xA0, 0x80, 0xBB, 0x07, 0x77, 0x70, 0x7A, 0x81, 0x70, 0xBB,
  0x07, 0x77, 0x60, 0x7A, 0x07, 0x20, 0xBB, 0x07, 0x77, 0x50, 0xAA, 0x0A, 0x30, 0xBB, 0x07, 0x77,
  0x30, 0x8C, 0x08, 0x30, 0xBB, 0x07, 0x77, 0x20, 0xEC, 0x0E, 0x40, 0xBB, 0x07, 0x77, 0x10, 0xDC,
  0x0D, 0x50, 0xBB, 0x07, 0x77, 0x08, 0xC0, 0x86, 0x0B, 0xB0, 0x67, 0x78, 0x28, 0xDD, 0x87, 0x18,
  0x2B, 0xFD, 0x27, 0x77, 0x60, 0x90, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_usb_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 31, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_usb_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_usb 36x36, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_sharp_36_device_usb_data[] PROGMEM = {
  0x73, 0x00, 0x17, 0x76, 0x00, 0xB7, 0x75, 0x07, 0xA0, 0x77, 0x73, 0x04, 0xC0, 0x47, 0x71, 0x01,
  0x0E, 0xC0, 0xE0, 0x17, 0x70, 0xBE, 0x0B, 0x76, 0x82, 0x27, 0x7B, 0xA8, 0x2B, 0x77, 0x27, 0x71,
  0x07, 0xA0, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x38, 0x31, 0x9B, 0x91, 0x30, 0x7A, 0x07, 0x20, 0x38,
  0x01, 0x78, 0x13, 0x1E, 0xB0, 0xE0, 0x12, 0x07, 0xA0, 0x72, 0x07, 0xD0, 0x70, 0x9D, 0x09, 0x20,
  0x7A, 0x07, 0x20, 0x7D, 0x07, 0x0B, 0xD0, 0xB2, 0x07, 0xA0, 0x72, 0x07, 0xD0, 0x70, 0x9D, 0x09,
  0x20, 0x7A, 0x07, 0x20, 0x7D, 0x81, 0x71, 0xEB, 0x0E, 0x01, 0x20, 0x7A, 0x07, 0x20, 0x7D, 0x81,
  0x70, 0x1B, 0x01, 0x30, 0x7A, 0x07, 0x20, 0x30, 0x7B, 0x07, 0x03, 0x2B, 0x40, 0x7A, 0x07, 0x4B,
  0x4B, 0x40, 0x7A, 0x07, 0x4B, 0x4B, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x00, 0x7B, 0x40, 0xBF, 0xFA,
  0x0B, 0x40, 0x30, 0xEF, 0xF0, 0xE0, 0x35, 0x85, 0x16, 0x77, 0x77, 0xBA, 0x85, 0xB7, 0x77, 0x76,
  0x17, 0x50, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07,
  0x77, 0x30, 0x20, 0xDA, 0x0D, 0x02, 0x77, 0x20, 0xDC, 0x0D, 0x77, 0x10, 0x3E, 0x03, 0x77, 0x03,
  0xE0, 0x37, 0x71, 0x0D, 0xC0, 0xD7, 0x72, 0x02, 0x0D, 0xA0, 0xD0, 0x27, 0x74, 0x00, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_usb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_usb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wallpaper 36x36, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_sharp_36_device_wallpaper_data[] PROGMEM = {
  0xFE, 0x07, 0x20, 0x7F, 0xFF, 0xD0, 0x72, 0x07, 0xFF, 0xFD, 0x07, 0x20, 0x7F, 0xFA, 0x77, 0x73,
  0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x28, 0x14, 0x61, 0x5E, 0x77, 0x10, 0x8A,
  0x0E, 0x01, 0x4E, 0x77, 0x10, 0xEB, 0x06, 0x4E, 0x77, 0x10, 0xCB, 0x04, 0x4E, 0x77, 0x18, 0x23,
  0xCE, 0x85, 0xE7, 0x77, 0x3B, 0x0F, 0x77, 0x77, 0x30, 0xF7, 0x80, 0xF0, 0x00, 0xF7, 0x71, 0x00,
  0x17, 0x70, 0xF7, 0xB7, 0x10, 0x0B, 0x77, 0xE7, 0x09, 0xA0, 0x95, 0x0A, 0x7E, 0x60, 0x6C, 0x06,
  0x38, 0x19, 0xF9, 0x6E, 0x50, 0x3E, 0x81, 0x30, 0x5B, 0x05, 0x5E, 0x40, 0x10, 0xDE, 0x81, 0xD4,
  0xEB, 0x0E, 0x02, 0x4E, 0x40, 0xBF, 0xF0, 0xC4, 0xE3, 0x09, 0xFF, 0xA0, 0x93, 0xE7, 0x77, 0x3E,
  0x77, 0x73, 0xE7, 0x77, 0x3F, 0xFA, 0x07, 0x20, 0x7F, 0xFF, 0xD0, 0x72, 0x07, 0xFF, 0xFD, 0x07,
  0x20, 0x7F, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wallpaper() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_wallpaper_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_water 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_sharp_36_device_water_data[] PROGMEM = {
  0x38, 0x24, 0x67, 0x46, 0x82, 0x46, 0x74, 0x68, 0x24, 0x67, 0x44, 0x06, 0x0E, 0xC8, 0x4D, 0x61,
  0x06, 0xEC, 0x84, 0xD6, 0x10, 0x6E, 0xC8, 0x1D, 0x61, 0xFF, 0xFF, 0xD8, 0x2E, 0x89, 0xDE, 0x82,
  0xD8, 0x9D, 0xE8, 0x2D, 0x89, 0xDB, 0x81, 0xEC, 0x64, 0x84, 0x6C, 0xFE, 0xC6, 0x48, 0x46, 0xCF,
  0xEC, 0x64, 0x81, 0x6C, 0xE7, 0x77, 0x75, 0x82, 0x46, 0x74, 0x68, 0x24, 0x67, 0x46, 0x82, 0x46,
  0x74, 0x40, 0x60, 0xEC, 0x84, 0xD6, 0x10, 0x6E, 0xC8, 0x4D, 0x61, 0x06, 0xEC, 0x81, 0xD6, 0x1F,
  0xFF, 0xFD, 0x82, 0xE8, 0x9D, 0xE8, 0x2D, 0x89, 0xDE, 0x82, 0xD8, 0x9D, 0xB8, 0x1E, 0xC6, 0x48,
  0x46, 0xCF, 0xEC, 0x64, 0x84, 0x6C, 0xFE, 0xC6, 0x48, 0x16, 0xCE, 0x77, 0x77, 0x58, 0x24, 0x67,
  0x46, 0x82, 0x46, 0x74, 0x68, 0x24, 0x67, 0x44, 0x06, 0x0D, 0xC8, 0x4E, 0x61, 0x06, 0xDC, 0x84,
  0xE6, 0x10, 0x6D, 0xC8, 0x1E, 0x61, 0xFF, 0xFF, 0xD8, 0x2D, 0x89, 0xDE, 0x82, 0xD8, 0x9D, 0xE8,
  0x2D, 0x89, 0xDB, 0x81, 0xEC, 0x64, 0x84, 0x6C, 0xFE, 0xC6, 0x48, 0x46, 0xCF, 0xEC, 0x64, 0x06,
  0x0C, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_water() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 10, 32, 26), Box(0, 0, 35, 35),
      ic_sharp_36_device_water_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_widgets 36x36, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_sharp_36_device_widgets_data[] PROGMEM = {
  0x77, 0x60, 0x01, 0x77, 0x76, 0x82, 0x1D, 0xD1, 0x70, 0x38, 0x07, 0x70, 0x35, 0x01, 0x0D, 0xA0,
  0xD0, 0x16, 0x07, 0xFC, 0x07, 0x40, 0x10, 0xDC, 0x0D, 0x01, 0x50, 0x7F, 0xC0, 0x73, 0x01, 0x0D,
  0xE0, 0xD0, 0x14, 0x07, 0xFC, 0x07, 0x20, 0x10, 0xDF, 0x90, 0xD0, 0x13, 0x07, 0xFC, 0x82, 0x70,
  0x1D, 0xFB, 0x0D, 0x01, 0x20, 0x7F, 0xC8, 0x17, 0x1D, 0xFD, 0x82, 0xD1, 0x07, 0xFC, 0x09, 0x0D,
  0xFF, 0x81, 0xD1, 0x7F, 0xC0, 0x90, 0xDF, 0xF8, 0x1D, 0x17, 0xFC, 0x81, 0x72, 0xDF, 0xD8, 0x2D,
  0x10, 0x7F, 0xC8, 0x27, 0x02, 0xDF, 0xB0, 0xD0, 0x12, 0x07, 0xFC, 0x07, 0x20, 0x20, 0xDF, 0x90,
  0xD0, 0x13, 0x07, 0xFC, 0x07, 0x30, 0x20, 0xDE, 0x0D, 0x01, 0x40, 0x38, 0x07, 0x70, 0x34, 0x02,
  0x0D, 0xC0, 0xD0, 0x17, 0x77, 0x20, 0x20, 0xDA, 0x0D, 0x01, 0x77, 0x74, 0x82, 0x2D, 0xD1, 0x70,
  0x38, 0x07, 0x70, 0x32, 0x85, 0x37, 0x77, 0x79, 0x98, 0x01, 0x70, 0x32, 0x07, 0xFC, 0x07, 0x20,
  0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xC0,
  0x72, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xC0, 0x72, 0x07,
  0xFC, 0x07, 0x20, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07,
  0x20, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x07, 0x20, 0x7F,
  0xC0, 0x72, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xC0, 0x72, 0x03, 0x80, 0x77, 0x03, 0x20, 0x38, 0x07,
  0x70, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_widgets() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 33, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_widgets_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_1_bar 36x36, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_sharp_36_device_wifi_1_bar_data[] PROGMEM = {
  0x28, 0x61, 0x8C, 0xEE, 0xC8, 0x13, 0x07, 0xF9, 0x82, 0x70, 0x1D, 0xF9, 0x83, 0xD1, 0x01, 0xDE,
  0x0D, 0x01, 0x30, 0x10, 0xDC, 0x0D, 0x01, 0x50, 0x10, 0xDA, 0x0D, 0x01, 0x78, 0x21, 0xDD, 0x17,
  0x20, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 24, 23, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_2_bar 36x36, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_sharp_36_device_wifi_2_bar_data[] PROGMEM = {
  0x78, 0x90, 0x49, 0xBD, 0xEE, 0xDB, 0x94, 0x74, 0x81, 0x29, 0xEF, 0xB8, 0x1E, 0x92, 0x60, 0x10,
  0x8F, 0xFA, 0x08, 0x01, 0x30, 0x20, 0xDF, 0xFC, 0x83, 0xD2, 0x03, 0xEF, 0x84, 0xC9, 0x88, 0x9C,
  0xF8, 0x2E, 0x41, 0xDC, 0x81, 0xD6, 0x16, 0x81, 0x16, 0xDC, 0x83, 0xD1, 0x01, 0xDA, 0x07, 0x75,
  0x07, 0xA0, 0xD0, 0x13, 0x81, 0x1C, 0x37, 0x78, 0x13, 0xC1, 0x77, 0x77, 0x68, 0x61, 0x8C, 0xEE,
  0xC8, 0x17, 0x71, 0x07, 0xF9, 0x07, 0x76, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x76, 0x01, 0x0D, 0xE0,
  0xD0, 0x17, 0x71, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x73, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x75, 0x82,
  0x1D, 0xD1, 0x77, 0x70, 0x01, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 15, 29, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_calling_3 36x36, 4-bit Alpha,  RLE, 207 bytes.
static const unsigned char ic_sharp_36_device_wifi_calling_3_data[] PROGMEM = {
  0x03, 0x80, 0x47, 0x04, 0x71, 0x84, 0x35, 0x76, 0x52, 0x50, 0x6F, 0x90, 0xA5, 0x81, 0x3A, 0xEE,
  0x0D, 0x07, 0x30, 0x5F, 0x90, 0xD3, 0x01, 0x0B, 0xC8, 0x2D, 0xBC, 0xEB, 0x82, 0xE5, 0x04, 0xFA,
  0x82, 0x10, 0x3E, 0xA0, 0xB0, 0x55, 0x81, 0x28, 0xEA, 0x08, 0x02, 0xFA, 0x84, 0x40, 0x4F, 0xE4,
  0x72, 0x84, 0x1A, 0xFA, 0x0E, 0xF9, 0x07, 0x20, 0x40, 0x22, 0x85, 0x39, 0xDF, 0xEB, 0x63, 0x05,
  0x20, 0xBF, 0x90, 0xA5, 0x0A, 0xF0, 0xE0, 0x44, 0x08, 0xF9, 0x0D, 0x40, 0x3A, 0x86, 0xB6, 0x34,
  0x8E, 0xFA, 0x40, 0x3F, 0x90, 0x75, 0x04, 0x05, 0x50, 0x10, 0x86, 0x0D, 0xE0, 0x77, 0x28, 0x12,
  0x65, 0x72, 0x08, 0xD0, 0x77, 0x20, 0x10, 0xEA, 0x08, 0x71, 0x01, 0xC0, 0x77, 0x48, 0x14, 0xFA,
  0x73, 0x09, 0xA0, 0xD7, 0x60, 0x37, 0x40, 0x1B, 0x06, 0x77, 0x74, 0x08, 0xA0, 0xE0, 0x17, 0x77,
  0x40, 0xCA, 0x0C, 0x77, 0x74, 0x03, 0xB0, 0xA7, 0x77, 0x40, 0x6B, 0x09, 0x71, 0x84, 0x7E, 0xA7,
  0x41, 0x74, 0x07, 0xB0, 0xA6, 0x07, 0xE8, 0x1E, 0xA4, 0x72, 0x09, 0xB0, 0xC0, 0x13, 0x07, 0xFA,
  0x07, 0x73, 0x07, 0xB8, 0x2E, 0x60, 0x7F, 0xB0, 0x77, 0x40, 0x6C, 0x0D, 0xFC, 0x07, 0x75, 0x03,
  0x0C, 0xFF, 0x07, 0x77, 0x08, 0xFE, 0x07, 0x77, 0x10, 0x10, 0x9F, 0xC0, 0x77, 0x73, 0x81, 0x18,
  0xDF, 0x90, 0x77, 0x76, 0x82, 0x38, 0xBE, 0xC0, 0x77, 0x77, 0x38, 0x32, 0x45, 0x63, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_calling_3() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 32, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_calling_3_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_channel 36x36, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_sharp_36_device_wifi_channel_data[] PROGMEM = {
  0x77, 0x48, 0x21, 0x55, 0x17, 0x77, 0x20, 0x20, 0xDA, 0x0D, 0x02, 0x77, 0x71, 0x0C, 0xC0, 0xC7,
  0x77, 0x06, 0xA0, 0x0E, 0xA0, 0x67, 0x76, 0x0D, 0xA0, 0x05, 0xA0, 0xD7, 0x75, 0x04, 0xA0, 0xD2,
  0x0D, 0xA0, 0x47, 0x74, 0x09, 0xA0, 0x72, 0x07, 0xA0, 0x97, 0x74, 0x0E, 0xA0, 0x22, 0x02, 0xA0,
  0xE7, 0x28, 0x26, 0xDD, 0x64, 0x02, 0xA0, 0xD4, 0x0D, 0xA0, 0x37, 0x06, 0xC0, 0x63, 0x06, 0xA0,
  0xA4, 0x0A, 0xA0, 0x66, 0x02, 0xE0, 0x22, 0x09, 0xA0, 0x64, 0x06, 0xA0, 0xA6, 0x09, 0xA0, 0xB0,
  0xCA, 0x09, 0x20, 0xCA, 0x03, 0x40, 0x3A, 0x0D, 0x50, 0x1B, 0x02, 0x03, 0xB0, 0x11, 0xB6, 0xB5,
  0x07, 0xA0, 0xB2, 0x0B, 0xA0, 0x70, 0x2A, 0x0D, 0x60, 0xDA, 0x03, 0x40, 0xCA, 0x05, 0x20, 0x5A,
  0x0C, 0x04, 0xA0, 0xB6, 0x0B, 0xA0, 0x53, 0x01, 0xA0, 0xE4, 0x0E, 0xA0, 0x9A, 0x86, 0x90, 0x26,
  0x62, 0x08, 0xA0, 0x73, 0x06, 0xA0, 0xA4, 0x0A, 0xD0, 0x60, 0x7C, 0x07, 0x06, 0xA0, 0x93, 0x0A,
  0xA0, 0x64, 0x06, 0xD0, 0xCE, 0x0C, 0xA0, 0xB3, 0x0E, 0xA0, 0x24, 0x02, 0xF9, 0x00, 0xBD, 0x0D,
  0x20, 0x2A, 0x0D, 0x60, 0xDE, 0x0A, 0x20, 0xAC, 0x0E, 0x20, 0x5A, 0x0A, 0x60, 0xAD, 0x0E, 0x01,
  0x20, 0x10, 0xEC, 0x20, 0x8A, 0x07, 0x60, 0x7D, 0x08, 0x40, 0x8C, 0x81, 0x20, 0xBA, 0x04, 0x60,
  0x4D, 0x01, 0x40, 0x1C, 0x81, 0x30, 0xEA, 0x01, 0x60, 0x1C, 0x0A, 0x60, 0xBB, 0x04, 0x01, 0xA0,
  0xE7, 0x10, 0xEB, 0x05, 0x60, 0x5B, 0x05, 0x03, 0xA0, 0xC7, 0x10, 0xCB, 0x71, 0xB0, 0x60, 0x5A,
  0x0A, 0x71, 0x0A, 0xA0, 0xB7, 0x10, 0xBA, 0x83, 0x73, 0x77, 0x47, 0x18, 0x24, 0x77, 0x47, 0x18,
  0x24, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_channel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_channel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_find 36x36, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_sharp_36_device_wifi_find_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAF, 0xFF, 0xB0, 0xA0, 0x27, 0x06,
  0x0E, 0xFF, 0xFD, 0x0E, 0x06, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x83, 0xA1, 0x01, 0xCF, 0xFD, 0x87,
  0xE8, 0x31, 0x02, 0x48, 0xEC, 0x81, 0xC1, 0xBF, 0xFD, 0x07, 0x72, 0x08, 0xC8, 0x1B, 0x1D, 0xFF,
  0xB0, 0x47, 0x40, 0x4A, 0x83, 0xD1, 0x01, 0xDF, 0xF9, 0x05, 0x38, 0x53, 0x9D, 0xFD, 0x93, 0x38,
  0x16, 0xD1, 0x30, 0x10, 0xDF, 0xE0, 0xB3, 0x07, 0xF0, 0x73, 0x01, 0x50, 0x10, 0xDF, 0xD0, 0x32,
  0x05, 0xFA, 0x05, 0x72, 0x01, 0x0D, 0xFB, 0x0D, 0x30, 0xEA, 0x83, 0xC3, 0x03, 0xCA, 0x0E, 0x73,
  0x01, 0x0D, 0xFA, 0x0A, 0x20, 0x4A, 0x0D, 0x50, 0xDA, 0x04, 0x73, 0x01, 0x0D, 0xF9, 0x08, 0x20,
  0x7A, 0x09, 0x50, 0x9A, 0x07, 0x74, 0x01, 0x0D, 0xF0, 0x82, 0x07, 0xA0, 0x95, 0x09, 0xA0, 0x67,
  0x50, 0x10, 0xDE, 0x0A, 0x20, 0x4A, 0x0D, 0x50, 0xDA, 0x04, 0x76, 0x01, 0x0D, 0xD0, 0xD3, 0x0E,
  0xA8, 0x3C, 0x30, 0x3C, 0xA0, 0xD7, 0x71, 0x01, 0x0D, 0xD0, 0x42, 0x05, 0xFA, 0x0E, 0x02, 0x77,
  0x10, 0x10, 0xDC, 0x0B, 0x30, 0x7F, 0xA0, 0xE0, 0x27, 0x71, 0x01, 0x0D, 0xC0, 0x63, 0x86, 0x39,
  0xDF, 0xD9, 0x5E, 0xA0, 0xE0, 0x27, 0x71, 0x01, 0x0D, 0xC0, 0x57, 0x20, 0x20, 0xEA, 0x0E, 0x02,
  0x77, 0x10, 0x10, 0xDC, 0x06, 0x72, 0x83, 0x2E, 0xFC, 0x17, 0x72, 0x01, 0x0D, 0xA0, 0xD0, 0x17,
  0x38, 0x12, 0xB1, 0x77, 0x48, 0x21, 0xDD, 0x17, 0x77, 0x75, 0x00, 0x17, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_find() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_find_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_lock 36x36, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_sharp_36_device_wifi_lock_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAF, 0xFF, 0xB0, 0xA0, 0x27, 0x06,
  0x0E, 0xFF, 0xFD, 0x0E, 0x06, 0x40, 0x10, 0xAF, 0xFF, 0xFA, 0x83, 0xA1, 0x01, 0xCF, 0xFF, 0xFC,
  0x81, 0xC1, 0xBF, 0xFF, 0xFE, 0x81, 0xB1, 0xDF, 0xFF, 0xFC, 0x83, 0xD1, 0x01, 0xDF, 0xFF, 0xFA,
  0x0D, 0x01, 0x30, 0x10, 0xDF, 0xFF, 0x98, 0x6D, 0xA8, 0x77, 0x77, 0x15, 0x01, 0x0D, 0xFF, 0xD0,
  0xE0, 0x67, 0x70, 0x10, 0xDF, 0xFB, 0x0E, 0x03, 0x77, 0x20, 0x10, 0xDF, 0xFA, 0x07, 0x48, 0x21,
  0x66, 0x17, 0x30, 0x10, 0xDF, 0xF0, 0xE4, 0x03, 0x0E, 0xA0, 0xE0, 0x37, 0x30, 0x10, 0xDF, 0xE0,
  0xA4, 0x84, 0xBD, 0x22, 0xDB, 0x74, 0x01, 0x0D, 0xFD, 0x09, 0x49, 0x08, 0x20, 0x80, 0xE7, 0x50,
  0x10, 0xDF, 0xC0, 0x84, 0x90, 0x72, 0x07, 0x97, 0x60, 0x10, 0xDF, 0xB0, 0x82, 0x07, 0xF9, 0x07,
  0x75, 0x01, 0x0D, 0xFA, 0x08, 0x20, 0x7F, 0x90, 0x77, 0x60, 0x10, 0xDF, 0x90, 0x82, 0x07, 0xF9,
  0x07, 0x77, 0x01, 0x0D, 0xE0, 0xD0, 0x12, 0x07, 0xF9, 0x07, 0x77, 0x10, 0x10, 0xDC, 0x0D, 0x01,
  0x30, 0x7F, 0x90, 0x77, 0x72, 0x01, 0x0D, 0xA0, 0xD0, 0x14, 0x07, 0xF9, 0x07, 0x77, 0x38, 0x21,
  0xDD, 0x15, 0x07, 0xF9, 0x07, 0x77, 0x40, 0x01, 0x60, 0x38, 0x04, 0x70, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 31), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_password 36x36, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_sharp_36_device_wifi_password_data[] PROGMEM = {
  0x74, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x75, 0x81, 0x27, 0xDF, 0xF8, 0x1D,
  0x72, 0x77, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x30, 0x20, 0xAF, 0xFF, 0xB0, 0xA0, 0x27, 0x06,
  0x0E, 0xFA, 0x86, 0xCA, 0x97, 0x79, 0xAC, 0xFA, 0x0E, 0x06, 0x40, 0x10, 0xAF, 0x81, 0xD8, 0x37,
  0x38, 0x13, 0x8D, 0xF8, 0x3A, 0x10, 0x1C, 0xE0, 0xC0, 0x47, 0x72, 0x04, 0x0C, 0xE8, 0x1C, 0x1B,
  0xD0, 0xE0, 0x57, 0x76, 0x05, 0x0E, 0xD8, 0x1B, 0x1D, 0xB0, 0xA0, 0x17, 0x77, 0x10, 0x10, 0xAB,
  0x85, 0xD1, 0x01, 0xDF, 0x77, 0x18, 0x90, 0x49, 0xBD, 0xEE, 0xDB, 0x94, 0x71, 0x82, 0x7F, 0xD1,
  0x30, 0x10, 0x56, 0x81, 0x29, 0xEF, 0xB8, 0x1E, 0x92, 0x60, 0x50, 0x17, 0x30, 0x10, 0x8F, 0xFA,
  0x08, 0x01, 0x77, 0x10, 0x20, 0xDF, 0xFC, 0x0D, 0x02, 0x76, 0x04, 0x0E, 0xF8, 0x4C, 0x98, 0x89,
  0xCF, 0x0E, 0x03, 0x75, 0x01, 0x0D, 0xC8, 0x1D, 0x61, 0x68, 0x11, 0x6D, 0xC0, 0xD0, 0x17, 0x60,
  0x10, 0xDA, 0x07, 0x75, 0x07, 0xA0, 0xD0, 0x17, 0x71, 0x81, 0x1C, 0x37, 0x78, 0x13, 0xC1, 0x80,
  0xE6, 0x08, 0x61, 0x8C, 0xEE, 0xC8, 0x17, 0x83, 0x3B, 0xEB, 0x37, 0x71, 0x07, 0xF9, 0x07, 0x58,
  0x51, 0xED, 0x8D, 0xE1, 0x76, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x48, 0x56, 0xF2, 0x02, 0xF6, 0x77,
  0x01, 0x0D, 0xE0, 0xD0, 0x15, 0x07, 0x93, 0x90, 0x77, 0x71, 0x01, 0x0D, 0xC0, 0xD0, 0x15, 0x87,
  0x7B, 0xF7, 0x77, 0xFB, 0x77, 0x71, 0x01, 0x0D, 0xA0, 0xD0, 0x16, 0xFA, 0x77, 0x28, 0x21, 0xDD,
  0x17, 0xFA, 0x77, 0x30, 0x01, 0x71, 0xFA, 0x77, 0x76, 0xFA, 0x77, 0x76, 0xFA, 0x77, 0x76, 0xFA,
  0x77, 0x76, 0xFA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_password() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 35), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_password_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_tethering_error 36x36, 4-bit Alpha,  RLE, 256 bytes.
static const unsigned char ic_sharp_36_device_wifi_tethering_error_data[] PROGMEM = {
  0x74, 0x86, 0x13, 0x57, 0x75, 0x41, 0x77, 0x60, 0x60, 0xBF, 0x90, 0xC0, 0x67, 0x72, 0x06, 0x0E,
  0xFD, 0x0E, 0x07, 0x75, 0x01, 0x0C, 0xD8, 0x4C, 0x98, 0x8A, 0xCD, 0x0C, 0x02, 0x72, 0x03, 0x0E,
  0xB8, 0x1D, 0x61, 0x68, 0x11, 0x6D, 0xB0, 0xE0, 0x37, 0x02, 0x0E, 0xB0, 0x67, 0x50, 0x7B, 0x0E,
  0x02, 0x50, 0x10, 0xDA, 0x0E, 0x03, 0x48, 0x41, 0x57, 0x75, 0x14, 0x03, 0x0E, 0xA0, 0xD0, 0x14,
  0x09, 0xA0, 0xE0, 0x23, 0x03, 0x0B, 0xE0, 0xB0, 0x33, 0x03, 0x0E, 0xA0, 0xA3, 0x03, 0xB0, 0x43,
  0x08, 0xFB, 0x08, 0x73, 0x0B, 0xA0, 0xA3, 0x0A, 0xC8, 0x2B, 0x88, 0xBC, 0x0A, 0x71, 0x01, 0xB0,
  0x22, 0x06, 0xB0, 0xA0, 0x14, 0x01, 0x0A, 0xB0, 0x67, 0x06, 0xA0, 0xB2, 0x01, 0x0E, 0xA0, 0x87,
  0x10, 0x8A, 0x0E, 0x01, 0x3B, 0x0A, 0xA0, 0x62, 0x06, 0xA0, 0xC3, 0x82, 0x16, 0x61, 0x30, 0xCA,
  0x06, 0x3B, 0x0C, 0xA0, 0x32, 0x0B, 0xA0, 0x52, 0x03, 0x0E, 0xA0, 0xE0, 0x32, 0x05, 0xA0, 0xB3,
  0xB0, 0xDA, 0x01, 0x20, 0xDA, 0x01, 0x20, 0xBC, 0x0B, 0x20, 0x1A, 0x0D, 0x3E, 0x3B, 0x30, 0xEC,
  0x0E, 0x3B, 0x3B, 0x0D, 0xA0, 0x12, 0x0D, 0xA0, 0x12, 0x0B, 0xC0, 0xB2, 0x01, 0xA0, 0xD3, 0xB0,
  0xCA, 0x03, 0x20, 0xBA, 0x05, 0x20, 0x30, 0xEA, 0x0E, 0x03, 0x20, 0x5A, 0x0B, 0x3B, 0x0A, 0xA0,
  0x62, 0x06, 0xA0, 0xC3, 0x82, 0x16, 0x61, 0x30, 0xCA, 0x06, 0x3B, 0x06, 0xA0, 0xB2, 0x01, 0x0E,
  0xA0, 0x77, 0x10, 0x7A, 0x0E, 0x01, 0x3B, 0x01, 0xB0, 0x22, 0x82, 0x6F, 0xD1, 0x71, 0x82, 0x1D,
  0xF6, 0x71, 0x0B, 0xA0, 0xA3, 0x08, 0x01, 0x73, 0x01, 0x08, 0x72, 0x03, 0xB0, 0x47, 0x77, 0x50,
  0x9A, 0x0E, 0x02, 0x77, 0x6B, 0x28, 0x31, 0xDF, 0xD1, 0x77, 0x6B, 0x38, 0x12, 0xC1, 0x77, 0x7B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_tethering_error() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_tethering_error_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_tethering_error_rounded 36x36, 4-bit Alpha,  RLE, 256 bytes.
static const unsigned char ic_sharp_36_device_wifi_tethering_error_rounded_data[] PROGMEM = {
  0x74, 0x86, 0x13, 0x57, 0x75, 0x41, 0x77, 0x60, 0x60, 0xBF, 0x90, 0xC0, 0x67, 0x72, 0x06, 0x0E,
  0xFD, 0x0E, 0x07, 0x75, 0x01, 0x0C, 0xD8, 0x4C, 0x98, 0x8A, 0xCD, 0x0C, 0x02, 0x72, 0x03, 0x0E,
  0xB8, 0x1D, 0x61, 0x68, 0x11, 0x6D, 0xB0, 0xE0, 0x37, 0x02, 0x0E, 0xB0, 0x67, 0x50, 0x7B, 0x0E,
  0x02, 0x50, 0x10, 0xDA, 0x0E, 0x03, 0x48, 0x41, 0x57, 0x75, 0x14, 0x03, 0x0E, 0xA0, 0xD0, 0x14,
  0x09, 0xA0, 0xE0, 0x23, 0x03, 0x0B, 0xE0, 0xB0, 0x33, 0x03, 0x0E, 0xA0, 0xA3, 0x03, 0xB0, 0x43,
  0x08, 0xFB, 0x08, 0x73, 0x0B, 0xA0, 0xA3, 0x0A, 0xC8, 0x2B, 0x88, 0xBC, 0x0A, 0x71, 0x01, 0xB0,
  0x22, 0x06, 0xB0, 0xA0, 0x14, 0x01, 0x0A, 0xB0, 0x67, 0x06, 0xA0, 0xB2, 0x01, 0x0E, 0xA0, 0x87,
  0x10, 0x8A, 0x0E, 0x01, 0x3B, 0x0A, 0xA0, 0x62, 0x06, 0xA0, 0xC3, 0x82, 0x16, 0x61, 0x30, 0xCA,
  0x06, 0x3B, 0x0C, 0xA0, 0x32, 0x0B, 0xA0, 0x52, 0x03, 0x0E, 0xA0, 0xE0, 0x32, 0x05, 0xA0, 0xB3,
  0xB0, 0xDA, 0x01, 0x20, 0xDA, 0x01, 0x20, 0xBC, 0x0B, 0x20, 0x1A, 0x0D, 0x3E, 0x3B, 0x30, 0xEC,
  0x0E, 0x3B, 0x3B, 0x0D, 0xA0, 0x12, 0x0D, 0xA0, 0x12, 0x0B, 0xC0, 0xB2, 0x01, 0xA0, 0xD3, 0xB0,
  0xCA, 0x03, 0x20, 0xBA, 0x05, 0x20, 0x30, 0xEA, 0x0E, 0x03, 0x20, 0x5A, 0x0B, 0x3B, 0x0A, 0xA0,
  0x62, 0x06, 0xA0, 0xC3, 0x82, 0x16, 0x61, 0x30, 0xCA, 0x06, 0x3B, 0x06, 0xA0, 0xB2, 0x01, 0x0E,
  0xA0, 0x77, 0x10, 0x7A, 0x0E, 0x01, 0x3B, 0x01, 0xB0, 0x22, 0x82, 0x6F, 0xD1, 0x71, 0x82, 0x1D,
  0xF6, 0x71, 0x0B, 0xA0, 0xA3, 0x08, 0x01, 0x73, 0x01, 0x08, 0x72, 0x03, 0xB0, 0x47, 0x77, 0x50,
  0x9A, 0x0E, 0x02, 0x77, 0x6B, 0x28, 0x31, 0xDF, 0xD1, 0x77, 0x6B, 0x38, 0x12, 0xC1, 0x77, 0x7B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_tethering_error_rounded() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 29), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_tethering_error_rounded_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_tethering_off 36x36, 4-bit Alpha,  RLE, 312 bytes.
static const unsigned char ic_sharp_36_device_wifi_tethering_off_data[] PROGMEM = {
  0x10, 0x20, 0x77, 0x28, 0x61, 0x45, 0x77, 0x53, 0x17, 0x48, 0x22, 0xEF, 0x76, 0x06, 0x0C, 0xF9,
  0x0B, 0x06, 0x72, 0x09, 0xB0, 0x73, 0x01, 0x0D, 0xFD, 0x0E, 0x06, 0x71, 0x0B, 0xB0, 0x73, 0x04,
  0xB8, 0x4C, 0xA8, 0x89, 0xCD, 0x0C, 0x01, 0x70, 0xBB, 0x07, 0x38, 0x14, 0x61, 0x68, 0x11, 0x6D,
  0xB0, 0xE0, 0x37, 0x0B, 0xB0, 0x77, 0x70, 0x6B, 0x0E, 0x02, 0x60, 0x1C, 0x07, 0x48, 0x41, 0x57,
  0x75, 0x14, 0x03, 0x0E, 0xA0, 0xD0, 0x15, 0x09, 0xD0, 0x73, 0x04, 0xD0, 0xB0, 0x33, 0x02, 0x0E,
  0xA0, 0x94, 0x03, 0xB0, 0xCB, 0x07, 0x30, 0x4E, 0x08, 0x30, 0x4B, 0x03, 0x30, 0xAA, 0x81, 0xA0,
  0xBB, 0x07, 0x38, 0x13, 0x8B, 0xC0, 0xA3, 0x0A, 0xA0, 0xB2, 0x01, 0xB0, 0x22, 0x0C, 0xB0, 0x75,
  0x01, 0x0A, 0xB0, 0x62, 0x02, 0xB8, 0x11, 0x06, 0xA0, 0xB2, 0x01, 0x0E, 0xC0, 0x76, 0x08, 0xA0,
  0xE0, 0x12, 0x0B, 0xA8, 0x16, 0x0A, 0xA0, 0x62, 0x07, 0xE0, 0x76, 0x0C, 0xA0, 0x62, 0x06, 0xA8,
  0x1A, 0x0C, 0xA0, 0x22, 0x0B, 0xA0, 0x60, 0xBB, 0x07, 0x50, 0x5A, 0x0B, 0x20, 0x3A, 0x81, 0xC0,
  0xEA, 0x01, 0x20, 0xEA, 0x81, 0x10, 0xBB, 0x07, 0x40, 0x1A, 0x0D, 0x20, 0x1A, 0x0D, 0x1B, 0x3B,
  0x3C, 0x07, 0x4B, 0x3B, 0x10, 0xDA, 0x01, 0x20, 0xDA, 0x01, 0x20, 0xBC, 0x07, 0x38, 0x14, 0xFE,
  0x20, 0x1A, 0x81, 0xE0, 0xCA, 0x03, 0x20, 0xBA, 0x05, 0x20, 0x30, 0xEC, 0x07, 0x30, 0x40, 0xB2,
  0x03, 0xA8, 0x1D, 0x0A, 0xA0, 0x62, 0x06, 0xA0, 0xC3, 0x81, 0x16, 0xBB, 0x07, 0x60, 0x6A, 0x81,
  0xA0, 0x6A, 0x0B, 0x20, 0x10, 0xEA, 0x07, 0x50, 0xAB, 0x07, 0x50, 0xBA, 0x81, 0x60, 0x1B, 0x02,
  0x28, 0x26, 0xFD, 0x16, 0x0A, 0xB0, 0x74, 0x0E, 0xA0, 0x12, 0x0B, 0xA0, 0xA3, 0x08, 0x01, 0x71,
  0x0A, 0xB0, 0x73, 0x81, 0x4F, 0xB3, 0x03, 0xB0, 0x47, 0x60, 0xAB, 0x07, 0x30, 0x40, 0x34, 0x09,
  0xA0, 0xE0, 0x27, 0x60, 0xAB, 0x07, 0x71, 0x83, 0x1D, 0xFD, 0x17, 0x70, 0xAB, 0x07, 0x71, 0x81,
  0x2C, 0x17, 0x72, 0x0A, 0xB0, 0x77, 0x77, 0x60, 0xAB, 0x07, 0x77, 0x76, 0x0A, 0xB0, 0x77, 0x77,
  0x68, 0x2A, 0xFE, 0x27, 0x77, 0x70, 0x90, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_tethering_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 32, 33), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_tethering_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_36_device_wifi_tethering 36x36, 4-bit Alpha,  RLE, 325 bytes.
static const unsigned char ic_sharp_36_device_wifi_tethering_data[] PROGMEM = {
  0x74, 0x86, 0x13, 0x57, 0x75, 0x31, 0x77, 0x60, 0x60, 0xBF, 0x90, 0xB0, 0x67, 0x72, 0x06, 0x0E,
  0xFD, 0x0E, 0x06, 0x75, 0x01, 0x0C, 0xD8, 0x4C, 0x98, 0x89, 0xCD, 0x0C, 0x01, 0x72, 0x03, 0x0E,
  0xB8, 0x1D, 0x61, 0x68, 0x11, 0x6D, 0xB0, 0xE0, 0x37, 0x02, 0x0E, 0xB0, 0x67, 0x50, 0x6B, 0x0E,
  0x02, 0x50, 0x10, 0xDA, 0x0E, 0x03, 0x48, 0x41, 0x57, 0x75, 0x14, 0x03, 0x0E, 0xA0, 0xD0, 0x14,
  0x09, 0xA0, 0xE0, 0x23, 0x03, 0x0B, 0xE0, 0xB0, 0x33, 0x02, 0x0E, 0xA0, 0x93, 0x03, 0xB0, 0x43,
  0x08, 0xFB, 0x08, 0x30, 0x4B, 0x03, 0x20, 0xBA, 0x0A, 0x30, 0xAC, 0x82, 0xB8, 0x8B, 0xC0, 0xA3,
  0x0A, 0xA8, 0x1B, 0x01, 0xB0, 0x22, 0x06, 0xB0, 0xA0, 0x14, 0x01, 0x0A, 0xB0, 0x62, 0x02, 0xB0,
  0x10, 0x6A, 0x0B, 0x20, 0x10, 0xEA, 0x08, 0x71, 0x08, 0xA0, 0xE0, 0x12, 0x0B, 0xA0, 0x60, 0xAA,
  0x06, 0x20, 0x6A, 0x0C, 0x38, 0x21, 0x66, 0x13, 0x0C, 0xA0, 0x62, 0x06, 0xA0, 0xA0, 0xCA, 0x03,
  0x20, 0xBA, 0x05, 0x20, 0x30, 0xEA, 0x0E, 0x03, 0x20, 0x5A, 0x0B, 0x20, 0x3A, 0x0C, 0x0D, 0xA0,
  0x12, 0x0D, 0xA0, 0x12, 0x0B, 0xC0, 0xB2, 0x01, 0xA0, 0xD2, 0x01, 0xA0, 0xDB, 0x3B, 0x30, 0xEC,
  0x0E, 0x3B, 0x3B, 0x0E, 0xA0, 0x12, 0x0D, 0xA0, 0x22, 0x0B, 0xC0, 0xB2, 0x02, 0xA0, 0xD2, 0x01,
  0xA0, 0xE0, 0xDA, 0x02, 0x20, 0xBA, 0x06, 0x20, 0x30, 0xEA, 0x0E, 0x03, 0x20, 0x6A, 0x0B, 0x20,
  0x2A, 0x0D, 0x0A, 0xA0, 0x62, 0x06, 0xA0, 0xC3, 0x82, 0x16, 0x61, 0x30, 0xCA, 0x06, 0x20, 0x6A,
  0x0A, 0x06, 0xA0, 0xB3, 0x0E, 0xA0, 0x97, 0x10, 0x9A, 0x0E, 0x30, 0xBA, 0x06, 0x01, 0xB0, 0x22,
  0x06, 0xB0, 0xA6, 0x0A, 0xB0, 0x62, 0x02, 0xB8, 0x11, 0x0B, 0xA0, 0x93, 0x09, 0xA0, 0x86, 0x08,
  0xA0, 0x93, 0x09, 0xA0, 0xB2, 0x03, 0xB0, 0x43, 0x08, 0x0D, 0x71, 0x0D, 0x08, 0x30, 0x4B, 0x03,
  0x30, 0xAA, 0x0E, 0x02, 0x30, 0x17, 0x10, 0x13, 0x02, 0x0E, 0xA0, 0xA4, 0x01, 0x0D, 0xA0, 0xE0,
  0x37, 0x70, 0x30, 0xEA, 0x0D, 0x01, 0x50, 0x20, 0xEA, 0x0E, 0x06, 0x75, 0x06, 0xB0, 0xE0, 0x27,
  0x03, 0x0E, 0xA0, 0x97, 0x50, 0x9A, 0x0E, 0x03, 0x72, 0x82, 0x2C, 0xE1, 0x75, 0x82, 0x1E, 0xC2,
  0x75, 0x03, 0x77, 0x03, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_36_device_wifi_tethering() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 32), Box(0, 0, 35, 35),
      ic_sharp_36_device_wifi_tethering_data, Alpha4(color::Black));
  return value;
}
