#include "maps.h"

using namespace roo_display;

// Image file ic_sharp_24_maps_360 24x24, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_sharp_24_maps_360_data[] PROGMEM = {
  0x48, 0x32, 0x6A, 0xCD, 0xA8, 0x3D, 0xCA, 0x62, 0x60, 0x40, 0xBF, 0xD0, 0xB0, 0x43, 0x09, 0xA8,
  0x3E, 0x95, 0x31, 0x28, 0x31, 0x35, 0x9E, 0xA8, 0x49, 0x07, 0xFE, 0x67, 0x58, 0x56, 0xEF, 0x7D,
  0xF3, 0x77, 0x84, 0x3F, 0xDE, 0xF4, 0x40, 0x77, 0x28, 0x24, 0xFE, 0x7A, 0x07, 0x39, 0x07, 0x78,
  0x47, 0xEF, 0x70, 0x9A, 0x81, 0xEA, 0x6A, 0x07, 0x40, 0x90, 0xEA, 0x08, 0x30, 0x40, 0xCE, 0x07,
  0x3A, 0x0B, 0x03, 0x68, 0x12, 0x7A, 0xB0, 0x73, 0x06, 0x01, 0x74, 0xA0, 0x77, 0x73, 0x90, 0x77,
  0x74, 0x07, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_360() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_360_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_add_business 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_24_maps_add_business_data[] PROGMEM = {
  0x1F, 0xF9, 0x7F, 0xF9, 0x77, 0x77, 0x01, 0xFF, 0x90, 0x15, 0x04, 0xFF, 0x90, 0x45, 0x07, 0xFF,
  0x90, 0x75, 0x0A, 0xFF, 0x90, 0xA5, 0x0D, 0xFF, 0x90, 0xD5, 0xFF, 0xB5, 0xFF, 0xB6, 0xA5, 0xA4,
  0xA7, 0xA5, 0xA4, 0xA1, 0xA4, 0xA5, 0xA4, 0xA1, 0xA4, 0xA5, 0xA7, 0xA4, 0xFA, 0x4F, 0x91, 0xFA,
  0x4F, 0x97, 0x73, 0xA7, 0x76, 0xA7, 0x76, 0xA3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_add_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_add_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_add_location_alt 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_sharp_24_maps_add_location_alt_data[] PROGMEM = {
  0x77, 0xA7, 0x73, 0xA7, 0x84, 0x28, 0xCE, 0xEC, 0x4A, 0x60, 0x9E, 0x1F, 0x92, 0x0B, 0xF1, 0xF9,
  0x10, 0x9F, 0x94, 0xA3, 0x02, 0xFD, 0x1A, 0x30, 0x8F, 0xD1, 0xA3, 0x0C, 0xD8, 0x2B, 0x11, 0xBB,
  0x60, 0xED, 0x01, 0x20, 0x1D, 0x0E, 0x30, 0xED, 0x01, 0x20, 0x1E, 0x30, 0xDD, 0x82, 0xB1, 0x1B,
  0xD0, 0xD3, 0x09, 0xFF, 0x09, 0x30, 0x2F, 0xF0, 0x24, 0x0A, 0xFD, 0x0A, 0x50, 0x10, 0xEF, 0xB0,
  0xE0, 0x16, 0x05, 0xFB, 0x05, 0x71, 0x08, 0xF9, 0x08, 0x73, 0x0A, 0xE0, 0xA7, 0x50, 0xAC, 0x0A,
  0x77, 0x0A, 0xA0, 0xA7, 0x72, 0x00, 0x87, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_add_location_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_add_location_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_add_location 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_maps_add_location_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x50, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x81,
  0x90, 0x2E, 0x2E, 0x02, 0x08, 0xE2, 0xE0, 0x80, 0xCE, 0x2E, 0x0C, 0x0E, 0xB7, 0x1B, 0x00, 0xEB,
  0x71, 0xB0, 0xE0, 0xDE, 0x2E, 0x0D, 0x09, 0xE2, 0xE0, 0x90, 0x2E, 0x2E, 0x81, 0x20, 0xAF, 0xD0,
  0xA2, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x30, 0x5F, 0xB0, 0x55, 0x08, 0xF9, 0x08, 0x70, 0xAE, 0x0A,
  0x72, 0x0A, 0xC0, 0xA7, 0x40, 0xAA, 0x0A, 0x76, 0x00, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_add_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_add_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_add_road 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_24_maps_add_road_data[] PROGMEM = {
  0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA7, 0x5A, 0x3A, 0x75,
  0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA7, 0x3A, 0x77, 0x3A, 0x75,
  0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA2, 0xFB, 0x5A, 0x2F, 0x97, 0x7A, 0x77, 0x3A,
  0x77, 0x3A, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_add_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_add_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_agriculture 24x24, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_sharp_24_maps_agriculture_data[] PROGMEM = {
  0x74, 0x05, 0x0C, 0x77, 0x58, 0x15, 0xD2, 0x77, 0x48, 0x25, 0xEE, 0x37, 0x74, 0x81, 0xC2, 0x3F,
  0x0D, 0x04, 0x30, 0xBB, 0x0D, 0x04, 0x4F, 0x90, 0xD3, 0x0B, 0xC0, 0xD4, 0xFA, 0x75, 0x01, 0xFA,
  0x38, 0x44, 0x5E, 0xE8, 0x22, 0x01, 0x0B, 0xFA, 0x28, 0x17, 0xFD, 0xA8, 0x2C, 0xF7, 0x3F, 0xC1,
  0x02, 0xA8, 0x27, 0x11, 0x7A, 0x04, 0x08, 0xD8, 0x78, 0x20, 0x28, 0x08, 0xC7, 0x48, 0x27, 0xD5,
  0x3C, 0x89, 0x04, 0x4C, 0xEC, 0x40, 0xEF, 0x14, 0x81, 0x1F, 0xE1, 0xB0, 0x80, 0x4D, 0x82, 0x4E,
  0xF1, 0x48, 0x11, 0xFE, 0x1B, 0x89, 0x13, 0xCF, 0x70, 0x7F, 0xC5, 0xD7, 0x48, 0x17, 0xC8, 0x50,
  0xE9, 0x39, 0x0E, 0x04, 0xA8, 0x27, 0x11, 0x7A, 0x02, 0x58, 0x91, 0xCF, 0x70, 0x7F, 0xC0, 0x7F,
  0xCA, 0x81, 0xDF, 0x76, 0x04, 0xD0, 0x42, 0x84, 0x28, 0xEE, 0x54, 0x71, 0x83, 0x4C, 0xEC, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_agriculture() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_agriculture_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_airlines 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_24_maps_airlines_data[] PROGMEM = {
  0x73, 0x05, 0xF9, 0x0E, 0x72, 0x01, 0x0E, 0xF9, 0x0B, 0x72, 0x0B, 0xFA, 0x08, 0x71, 0x06, 0xFB,
  0x05, 0x70, 0x20, 0xEF, 0xB0, 0x27, 0x0B, 0xA8, 0x3D, 0x40, 0x4D, 0xB0, 0xE7, 0x07, 0xB0, 0x43,
  0x04, 0xB0, 0xC6, 0x02, 0xC5, 0xB0, 0x96, 0x0C, 0xC0, 0x43, 0x04, 0xB0, 0x65, 0x08, 0xD8, 0x3D,
  0x40, 0x4D, 0xB0, 0x34, 0x03, 0xFF, 0x50, 0xDF, 0xE0, 0xD4, 0x09, 0xFF, 0x0A, 0x30, 0x4F, 0xF9,
  0x07, 0x20, 0x10, 0xDF, 0xF9, 0x04, 0x20, 0xAF, 0xFA, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_airlines() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_airlines_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_airline_stops 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_sharp_24_maps_airline_stops_data[] PROGMEM = {
  0x75, 0x07, 0xE7, 0x60, 0x7E, 0x82, 0xDA, 0x61, 0x72, 0x08, 0xF9, 0x0E, 0x07, 0x70, 0x30, 0xDC,
  0x18, 0x12, 0x6B, 0xA0, 0xC0, 0x24, 0x83, 0x4E, 0xFB, 0x8A, 0x48, 0x33, 0xDF, 0xE2, 0x28, 0x23,
  0xEF, 0x92, 0x07, 0x96, 0x81, 0xBF, 0xD2, 0x81, 0xDF, 0x94, 0x07, 0x78, 0x4C, 0xF8, 0x8F, 0xC7,
  0x60, 0x3C, 0x03, 0x77, 0x0A, 0xA0, 0xA7, 0x71, 0x05, 0xA0, 0x57, 0x71, 0x01, 0xA0, 0x17, 0x7E,
  0x76, 0xE6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_airline_stops() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 20, 18), Box(0, 0, 23, 23),
      ic_sharp_24_maps_airline_stops_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_alt_route 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_24_maps_alt_route_data[] PROGMEM = {
  0x30, 0x07, 0x71, 0x00, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x73, 0x07, 0xC0, 0x74, 0x07, 0xC8,
  0x17, 0x07, 0xE0, 0x72, 0x07, 0xE0, 0x73, 0x0E, 0x97, 0x19, 0x0E, 0x68, 0x1D, 0xD1, 0x68, 0x12,
  0xFD, 0x77, 0x18, 0x15, 0xFA, 0x68, 0x12, 0x98, 0x68, 0x1A, 0xF7, 0x60, 0x1A, 0x04, 0x40, 0x4A,
  0x01, 0x78, 0x17, 0xF6, 0x38, 0x23, 0xEF, 0x77, 0x28, 0x64, 0x06, 0x33, 0xEF, 0xA7, 0x48, 0x44,
  0xFE, 0xEF, 0x97, 0x60, 0xBA, 0x0B, 0x77, 0x03, 0xA0, 0x37, 0x71, 0xA7, 0x72, 0xA7, 0x72, 0xA7,
  0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_alt_route() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_alt_route_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_atm 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_24_maps_atm_data[] PROGMEM = {
  0xD1, 0xE1, 0x07, 0xF8, 0xA0, 0xB7, 0xBF, 0x07, 0x7D, 0xD7, 0x70, 0x7F, 0x7F, 0xBB, 0xA8, 0x17,
  0x07, 0x93, 0x00, 0xB3, 0x84, 0x7F, 0x0F, 0x77, 0xE3, 0x00, 0xB3, 0x84, 0x7F, 0x0F, 0x77, 0xA8,
  0x1B, 0x7B, 0x93, 0x00, 0xB3, 0x84, 0x7F, 0x0F, 0x77, 0xA8, 0x17, 0x07, 0x93, 0x00, 0xB3, 0x07,
  0x93, 0x07, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_atm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 9, 21, 14), Box(0, 0, 23, 23),
      ic_sharp_24_maps_atm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_attractions 24x24, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_sharp_24_maps_attractions_data[] PROGMEM = {
  0x78, 0x24, 0xDD, 0x47, 0x60, 0x10, 0xDA, 0x0E, 0x01, 0x73, 0x03, 0x0B, 0xE0, 0xB0, 0x37, 0x89,
  0x26, 0xFB, 0x44, 0xDD, 0x44, 0xBF, 0x73, 0x83, 0x3D, 0xEF, 0x77, 0x18, 0x47, 0xFE, 0xD3, 0xCA,
  0x0E, 0x73, 0x0E, 0xA0, 0x0C, 0xA0, 0xE4, 0x00, 0x44, 0x0E, 0xA8, 0x3C, 0x4F, 0xD5, 0x20, 0x40,
  0xEA, 0x0E, 0x04, 0x28, 0x54, 0xDF, 0x45, 0xF1, 0x20, 0x10, 0xEC, 0x0E, 0x01, 0x28, 0x31, 0xF5,
  0x7E, 0x30, 0x5E, 0x05, 0x39, 0x81, 0x77, 0xE3, 0x05, 0xE0, 0x53, 0x98, 0x27, 0x5F, 0x12, 0x01,
  0x0E, 0xC0, 0xE0, 0x12, 0x85, 0x2F, 0x54, 0xFD, 0x52, 0x0D, 0xC0, 0xD2, 0x83, 0x5E, 0xF4, 0xCA,
  0x89, 0x2E, 0x04, 0xF9, 0x55, 0xAF, 0x40, 0xEA, 0x00, 0xCB, 0x18, 0x1B, 0xF2, 0x28, 0x12, 0xFB,
  0x1B, 0x86, 0xC3, 0xDE, 0xFB, 0xFA, 0x48, 0x5A, 0xFC, 0xFE, 0xD3, 0x30, 0x6A, 0x84, 0xA6, 0xDD,
  0x6A, 0xA0, 0x66, 0x81, 0x1F, 0xEE, 0x81, 0xEF, 0x16, 0x83, 0x8F, 0x51, 0xDA, 0x83, 0xE1, 0x5F,
  0x76, 0x0E, 0x0D, 0x28, 0x24, 0xDD, 0x42, 0x0D, 0x0E, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_attractions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_attractions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_badge 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_sharp_24_maps_badge_data[] PROGMEM = {
  0x7E, 0x77, 0xE7, 0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x7A, 0x2A, 0x7F, 0xA2, 0xFF, 0xC2, 0x80, 0x98,
  0x6F, 0x82, 0xD2, 0x2D, 0xB4, 0xFA, 0x08, 0x20, 0x8B, 0x80, 0x07, 0xFA, 0x82, 0xD2, 0x2D, 0xFF,
  0xA8, 0x2E, 0xCC, 0xEB, 0x4F, 0x90, 0x84, 0x08, 0xA8, 0x00, 0x7F, 0x96, 0x80, 0x9A, 0x6F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_badge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_badge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_bakery_dining 24x24, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_sharp_24_maps_bakery_dining_data[] PROGMEM = {
  0x71, 0x0E, 0xC0, 0xE7, 0x78, 0x13, 0x0D, 0xC8, 0x1D, 0x03, 0x72, 0x84, 0x28, 0xEB, 0x0B, 0xC8,
  0x4B, 0x0B, 0xE8, 0x26, 0x0E, 0xA8, 0x1C, 0x0A, 0xC8, 0x1A, 0x0C, 0xA0, 0xE6, 0x09, 0xA8, 0x1E,
  0x09, 0xC8, 0x19, 0x0E, 0xA0, 0x96, 0x03, 0xB1, 0x07, 0xC0, 0x71, 0xB0, 0x37, 0x0C, 0xA0, 0x10,
  0x6C, 0x06, 0x01, 0xA0, 0xC6, 0x81, 0xA0, 0x6A, 0x02, 0x04, 0xC0, 0x40, 0x2A, 0x81, 0x60, 0xA3,
  0x86, 0x3F, 0x50, 0xEF, 0x43, 0xC8, 0x63, 0x4F, 0xE0, 0x5F, 0x32, 0x86, 0xBF, 0xC0, 0x9F, 0x52,
  0xC8, 0x90, 0x25, 0xF9, 0x0C, 0xFB, 0x04, 0xB8, 0x22, 0x3F, 0x71, 0xC1, 0x82, 0x7F, 0x32, 0xB8,
  0x44, 0x19, 0xFB, 0x27, 0x58, 0x32, 0xBF, 0x91, 0x20, 0x17, 0x72, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_bakery_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 22, 18), Box(0, 0, 23, 23),
      ic_sharp_24_maps_bakery_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_beenhere 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_sharp_24_maps_beenhere_data[] PROGMEM = {
  0x80, 0x9A, 0x2F, 0x0C, 0xFF, 0xA8, 0x1A, 0x07, 0xFF, 0x0A, 0x20, 0x7F, 0xE0, 0xA2, 0x07, 0xE0,
  0xCE, 0x0A, 0x20, 0x7E, 0x81, 0x70, 0xAC, 0x0A, 0x20, 0x7F, 0x07, 0x20, 0xAA, 0x0A, 0x20, 0x7F,
  0xA0, 0x72, 0x00, 0xA2, 0x07, 0xFC, 0x07, 0x40, 0x7F, 0xE0, 0x72, 0x07, 0xFF, 0x90, 0x07, 0xFF,
  0xFF, 0x05, 0x0E, 0xFF, 0x83, 0xE5, 0x01, 0xAF, 0xD0, 0xA0, 0x14, 0x05, 0x0E, 0xF9, 0x0E, 0x05,
  0x70, 0x10, 0xAE, 0x0A, 0x01, 0x73, 0x05, 0x0E, 0xA0, 0xE0, 0x57, 0x68, 0x21, 0xAA, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_beenhere() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_beenhere_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_bike_scooter 24x24, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_sharp_24_maps_bike_scooter_data[] PROGMEM = {
  0x74, 0xD0, 0x87, 0x3D, 0x09, 0x2D, 0x0D, 0x73, 0xD0, 0xC6, 0x81, 0xDF, 0x47, 0x6A, 0x68, 0x17,
  0xF9, 0x76, 0x81, 0xCF, 0x45, 0x81, 0x1F, 0xE7, 0x68, 0x28, 0xF7, 0x7F, 0x98, 0x1E, 0xB5, 0x72,
  0x82, 0x5F, 0xB3, 0xFC, 0x08, 0x71, 0x81, 0x1F, 0xE4, 0x04, 0xC0, 0x30, 0x7A, 0x05, 0x71, 0x81,
  0xDF, 0x23, 0x89, 0x0B, 0xF7, 0xAF, 0x70, 0x6F, 0xB7, 0x83, 0x6E, 0xF6, 0x8C, 0x86, 0x14, 0xFA,
  0x01, 0xFE, 0x50, 0x10, 0xCB, 0x09, 0x05, 0xC8, 0x11, 0x02, 0x28, 0x11, 0xFE, 0x58, 0x3C, 0xFD,
  0x51, 0x48, 0x1B, 0xF7, 0x48, 0x16, 0xFB, 0x48, 0x66, 0xFD, 0x18, 0xDD, 0x82, 0x04, 0xA8, 0x27,
  0x11, 0x7A, 0x04, 0x48, 0x2B, 0xF5, 0x8C, 0x08, 0x20, 0x7E, 0x07, 0x1E, 0x85, 0x1D, 0xF3, 0x3F,
  0xD3, 0x84, 0x4B, 0xEE, 0xB4, 0x2E, 0x18, 0x4D, 0xF3, 0x3F, 0xD7, 0x74, 0x08, 0xC0, 0x87, 0x75,
  0x82, 0x8D, 0xD8, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_bike_scooter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_bike_scooter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_breakfast_dining 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_sharp_24_maps_breakfast_dining_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0xFD, 0x84, 0xD9, 0x10, 0x1D, 0xFF, 0xA8, 0x1D, 0x19, 0xFF, 0xC0, 0x90, 0xEF,
  0xFC, 0x00, 0xEF, 0xFC, 0x0E, 0x0A, 0xF9, 0x00, 0xEF, 0x98, 0x1A, 0x1E, 0xE8, 0x2E, 0x22, 0xEE,
  0x82, 0xE1, 0x01, 0xD0, 0xE0, 0x22, 0x02, 0x0E, 0xD0, 0x13, 0xC0, 0xE0, 0x24, 0x02, 0x0E, 0xC4,
  0xB0, 0xE0, 0x26, 0x02, 0x0E, 0xB4, 0xB0, 0xE0, 0x26, 0x02, 0x0E, 0xB4, 0xC0, 0xE0, 0x24, 0x02,
  0x0E, 0xC4, 0xD0, 0xE0, 0x22, 0x02, 0x0E, 0xD4, 0xE8, 0x2E, 0x22, 0xEE, 0x4F, 0x00, 0xEF, 0x4F,
  0xFA, 0x4F, 0xFA, 0x4F, 0xFA, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_breakfast_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_breakfast_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_brunch_dining 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_sharp_24_maps_brunch_dining_data[] PROGMEM = {
  0x77, 0xE7, 0x7E, 0x77, 0xA2, 0xA7, 0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x7A, 0x2A, 0x77, 0xE7, 0x7E,
  0x77, 0xE7, 0x7E, 0x77, 0x0D, 0xC0, 0xD7, 0x70, 0x9C, 0x09, 0x5C, 0x50, 0x20, 0xEB, 0x02, 0x5C,
  0x60, 0x5A, 0x06, 0x1F, 0xF2, 0xA2, 0xFF, 0x2A, 0x77, 0x4A, 0x77, 0x4A, 0x2F, 0xF2, 0xFF, 0xC2,
  0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_brunch_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_brunch_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_bus_alert 24x24, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_sharp_24_maps_bus_alert_data[] PROGMEM = {
  0x76, 0x84, 0x4B, 0xEE, 0xB4, 0x77, 0x08, 0xE0, 0x83, 0x82, 0x48, 0xBD, 0xB8, 0x17, 0x04, 0xB0,
  0x07, 0xB8, 0x14, 0x1B, 0xF8, 0x12, 0x0B, 0xB0, 0x07, 0xB0, 0xB0, 0xAF, 0x92, 0x0E, 0xB0, 0x07,
  0xB0, 0xE0, 0xDF, 0x92, 0x0E, 0xB0, 0x07, 0xB0, 0xEF, 0xA8, 0x13, 0x0B, 0xF9, 0x0B, 0xA7, 0x20,
  0x4B, 0x00, 0x7B, 0x04, 0xA7, 0x30, 0x8E, 0x08, 0x1A, 0x74, 0x84, 0x4B, 0xEE, 0xB4, 0x2F, 0xC0,
  0xA7, 0x2F, 0xD8, 0x1E, 0x72, 0x6F, 0xFA, 0x5B, 0x81, 0x70, 0x7C, 0x81, 0x70, 0x7B, 0x5B, 0x3C,
  0x3B, 0x5B, 0x81, 0x70, 0x7C, 0x81, 0x70, 0x7B, 0x50, 0xCF, 0xF0, 0xC5, 0x04, 0xFF, 0x04, 0x6F,
  0xF7, 0xB7, 0x1B, 0x7B, 0x71, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_bus_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_bus_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_car_crash 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_sharp_24_maps_car_crash_data[] PROGMEM = {
  0x75, 0x84, 0x4B, 0xEE, 0xB4, 0x76, 0x08, 0xE0, 0x87, 0x40, 0x4B, 0x00, 0x7B, 0x04, 0x20, 0xBD,
  0x81, 0x30, 0xBB, 0x00, 0x7B, 0x81, 0xB0, 0x1E, 0x81, 0x10, 0xEB, 0x00, 0x7B, 0x83, 0xE0, 0x7F,
  0xA6, 0x0E, 0xB0, 0x07, 0xB8, 0x3E, 0x0C, 0xF5, 0x60, 0xBF, 0x98, 0x2B, 0x2F, 0xE7, 0x04, 0xB0,
  0x07, 0xB0, 0x40, 0x7F, 0x82, 0xE1, 0x08, 0xE8, 0x18, 0x0C, 0xF9, 0x0A, 0x28, 0x44, 0xBE, 0xEB,
  0x42, 0xFB, 0x0A, 0x72, 0xB8, 0x17, 0x07, 0xD0, 0xE0, 0x23, 0x03, 0x07, 0x2B, 0x3E, 0x3B, 0x2B,
  0x81, 0x70, 0x7E, 0x81, 0x70, 0x7B, 0x2F, 0xFC, 0x2F, 0xFC, 0x2F, 0xFC, 0x2B, 0x75, 0xB2, 0xB7,
  0x5B, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_car_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_car_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_car_rental 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_sharp_24_maps_car_rental_data[] PROGMEM = {
  0x18, 0x28, 0xDE, 0x87, 0x20, 0x8C, 0x08, 0x71, 0x82, 0xDF, 0x33, 0xFB, 0x82, 0xDF, 0x33, 0xFB,
  0x08, 0xC0, 0x85, 0xA2, 0x82, 0x8D, 0xE8, 0x6A, 0x77, 0x77, 0x20, 0x4F, 0xB0, 0x42, 0x09, 0xFB,
  0x09, 0x28, 0x1E, 0xF2, 0x68, 0x52, 0xFE, 0x04, 0xFC, 0x71, 0x82, 0xCF, 0x49, 0xFD, 0x09, 0x0E,
  0xFD, 0x0E, 0xB0, 0x0A, 0xC0, 0x0A, 0xE2, 0xC2, 0xE0, 0x0A, 0xC0, 0x0A, 0xFF, 0xFF, 0xD7, 0x3C,
  0x73, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_car_rental() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_car_rental_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_car_repair 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_24_maps_car_repair_data[] PROGMEM = {
  0x20, 0x4F, 0xB0, 0x44, 0x09, 0xFB, 0x09, 0x48, 0x1E, 0xF2, 0x68, 0x12, 0xFE, 0x38, 0x14, 0xFC,
  0x71, 0x81, 0xCF, 0x42, 0x09, 0xFD, 0x09, 0x20, 0xEF, 0xD0, 0xE2, 0xB0, 0x0A, 0xC0, 0x0A, 0xB2,
  0xB2, 0xC2, 0xB2, 0xB0, 0x0A, 0xC0, 0x0A, 0xB2, 0xFF, 0x2F, 0xF2, 0xA7, 0x3A, 0x2A, 0x73, 0xA7,
  0x73, 0xFF, 0xFF, 0xC7, 0xA7, 0x7A, 0x77, 0xA7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_car_repair() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_car_repair_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_castle 24x24, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_sharp_24_maps_castle_data[] PROGMEM = {
  0x4A, 0x2A, 0x2A, 0x2A, 0x71, 0xA2, 0xA2, 0xA2, 0xA7, 0x1F, 0xF7, 0x1F, 0xF7, 0x1F, 0xF7, 0x1F,
  0xF4, 0xA2, 0xC2, 0xA2, 0xC2, 0xC2, 0xC2, 0xA2, 0xC2, 0xFB, 0x2A, 0x28, 0x09, 0xC5, 0xF4, 0xFF,
  0xC4, 0xFF, 0xC4, 0xFF, 0xC4, 0xFF, 0xC4, 0xFA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_castle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_castle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_category 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_24_maps_category_data[] PROGMEM = {
  0x71, 0x00, 0x47, 0x73, 0x00, 0xD7, 0x72, 0x08, 0xA0, 0x87, 0x70, 0x2C, 0x02, 0x76, 0x0B, 0xC0,
  0xB7, 0x50, 0x5E, 0x05, 0x73, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x20, 0x9F, 0x90, 0x97, 0x10, 0x3F,
  0xB0, 0x38, 0x0C, 0x60, 0x80, 0x47, 0x48, 0x37, 0xCE, 0xC7, 0x2F, 0x93, 0x0B, 0xD0, 0xB1, 0xF9,
  0x20, 0x7F, 0x07, 0xF9, 0x20, 0xCF, 0x0C, 0xF9, 0x20, 0xEF, 0x0E, 0xF9, 0x20, 0xCF, 0x0C, 0xF9,
  0x20, 0x7F, 0x07, 0xF9, 0x30, 0xBD, 0x0B, 0x18, 0x04, 0x74, 0x83, 0x7C, 0xEC, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_category() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_category_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_celebration 24x24, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_sharp_24_maps_celebration_data[] PROGMEM = {
  0x75, 0x04, 0x77, 0x68, 0x14, 0xF8, 0x77, 0x20, 0x43, 0x81, 0x8F, 0x87, 0x78, 0x14, 0xF8, 0x38,
  0x17, 0xF8, 0x20, 0x08, 0x73, 0x81, 0x8F, 0x82, 0x83, 0x8F, 0x80, 0x8A, 0x08, 0x72, 0x89, 0x48,
  0xF8, 0x08, 0xF8, 0x08, 0xF8, 0x8F, 0x47, 0x89, 0x14, 0xF8, 0x08, 0xF8, 0x08, 0xF8, 0x20, 0x45,
  0x02, 0x07, 0x28, 0x74, 0x08, 0xF8, 0x08, 0xF8, 0x72, 0x81, 0x8F, 0x72, 0x85, 0x4F, 0x80, 0x8F,
  0x87, 0x30, 0xDA, 0x07, 0x28, 0x64, 0x08, 0xF8, 0x08, 0x77, 0x03, 0xC0, 0x72, 0x83, 0x4F, 0x80,
  0x8A, 0x08, 0x60, 0x9D, 0x07, 0x28, 0x64, 0x08, 0xF8, 0x8F, 0x85, 0x0E, 0xE0, 0x72, 0x81, 0x4F,
  0x82, 0x81, 0x8F, 0x43, 0x05, 0xF9, 0x07, 0x20, 0x44, 0x04, 0x40, 0xAF, 0xA0, 0x77, 0x30, 0x1F,
  0xC0, 0x77, 0x20, 0x6F, 0xA8, 0x1D, 0x82, 0x72, 0x0B, 0xE8, 0x1E, 0x93, 0x74, 0x01, 0xD0, 0xA0,
  0x57, 0x70, 0x7A, 0x81, 0xB6, 0x17, 0x72, 0x81, 0x97, 0x17, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_celebration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 23, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_celebration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_church 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_24_maps_church_data[] PROGMEM = {
  0x72, 0xA7, 0x74, 0xA7, 0x72, 0xE7, 0x7E, 0x77, 0x2A, 0x77, 0x30, 0x3A, 0x03, 0x77, 0x03, 0x0B,
  0xC0, 0xB0, 0x37, 0x30, 0x30, 0xBF, 0x90, 0xB0, 0x37, 0x1F, 0xD7, 0x1D, 0x00, 0x9D, 0x71, 0xC0,
  0x92, 0x09, 0xC6, 0x01, 0x08, 0xC0, 0x92, 0x09, 0xC0, 0x80, 0x12, 0x03, 0x0A, 0xF0, 0x09, 0xF0,
  0xA0, 0x38, 0x09, 0x80, 0xF4, 0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA4, 0xF9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_church() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_church_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_cleaning_services 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_maps_cleaning_services_data[] PROGMEM = {
  0x6E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE6, 0x80,
  0xC2, 0xF7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2,
  0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0x80, 0xC2, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_cleaning_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_cleaning_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_compass_calibration 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_sharp_24_maps_compass_calibration_data[] PROGMEM = {
  0x58, 0x90, 0x37, 0xBD, 0xEE, 0xDB, 0x73, 0x71, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x40, 0x20, 0xCF,
  0xF8, 0x3C, 0x20, 0x4E, 0xFF, 0xA8, 0x1E, 0x49, 0xFF, 0xC8, 0x19, 0x09, 0xFF, 0xA0, 0x93, 0x09,
  0xFF, 0x09, 0x50, 0x9A, 0x86, 0xE8, 0x41, 0x14, 0x8E, 0xA0, 0x97, 0x81, 0x9B, 0x16, 0x81, 0x1B,
  0x97, 0x77, 0x73, 0x84, 0x1A, 0xDD, 0xA1, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x50, 0xAE, 0x0A,
  0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xDE, 0x0D, 0x75, 0x0A, 0xE0, 0xA7, 0x50, 0x10, 0xEC, 0x0E, 0x01,
  0x76, 0x84, 0x1A, 0xDD, 0xA1, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_compass_calibration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_compass_calibration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_connecting_airports 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_sharp_24_maps_connecting_airports_data[] PROGMEM = {
  0x30, 0x03, 0x77, 0x06, 0x0D, 0x77, 0x81, 0x2F, 0x87, 0x78, 0x1D, 0xF2, 0x72, 0x0D, 0x05, 0x28,
  0x18, 0xFA, 0x72, 0x08, 0xFA, 0x0B, 0x50, 0x8F, 0xA0, 0xB5, 0x0D, 0x05, 0x28, 0x18, 0xFA, 0x76,
  0x81, 0xDF, 0x24, 0x00, 0x36, 0x81, 0x2F, 0x85, 0x0D, 0x06, 0x60, 0x60, 0xD5, 0x81, 0x8F, 0x26,
  0x00, 0x34, 0x81, 0x2F, 0xD7, 0x68, 0x1A, 0xF8, 0x20, 0x50, 0xD5, 0x0B, 0xFA, 0x08, 0x50, 0xBF,
  0xA0, 0x87, 0x28, 0x1A, 0xF8, 0x20, 0x50, 0xD7, 0x28, 0x12, 0xFD, 0x77, 0x81, 0x8F, 0x27, 0x70,
  0xD0, 0x67, 0x70, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_connecting_airports() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_connecting_airports_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_crisis_alert 24x24, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_sharp_24_maps_crisis_alert_data[] PROGMEM = {
  0x71, 0x82, 0x6D, 0xD6, 0x77, 0x10, 0x3C, 0x03, 0x77, 0x07, 0xC0, 0x77, 0x48, 0x25, 0x70, 0x5C,
  0x82, 0x50, 0x75, 0x78, 0x38, 0xFC, 0x02, 0xC8, 0x32, 0x0C, 0xF8, 0x50, 0x8A, 0x06, 0x20, 0xDA,
  0x0D, 0x20, 0x6A, 0x08, 0x30, 0x5A, 0x04, 0x30, 0x9A, 0x09, 0x30, 0x4A, 0x05, 0x28, 0x6D, 0xF7,
  0x01, 0x60, 0x4A, 0x89, 0x24, 0x06, 0x10, 0x7F, 0xD0, 0x5F, 0xD2, 0x0C, 0x0D, 0x20, 0x04, 0x20,
  0xD0, 0xC2, 0x89, 0x0D, 0xF5, 0xAF, 0x60, 0x6F, 0xD6, 0x8C, 0x2D, 0xF6, 0x06, 0xFA, 0xDF, 0x30,
  0xCF, 0x50, 0x4D, 0xD4, 0x05, 0xFC, 0x03, 0xFD, 0xEF, 0x10, 0xEF, 0x10, 0xDA, 0x89, 0x0D, 0x01,
  0xFE, 0x01, 0xFE, 0xE9, 0x28, 0x3E, 0xF1, 0x0D, 0xA8, 0x3D, 0x01, 0xFE, 0x29, 0x8B, 0x3E, 0xDF,
  0x20, 0xCF, 0x50, 0x4D, 0xD4, 0x05, 0xFC, 0x02, 0xFD, 0x9F, 0x60, 0x6F, 0xD1, 0x48, 0x91, 0x1D,
  0xF6, 0x06, 0xF9, 0x5F, 0xC2, 0x89, 0x0C, 0xFD, 0x51, 0x15, 0xDF, 0xC2, 0x89, 0x0C, 0xF5, 0x0D,
  0xF6, 0x01, 0xCE, 0x84, 0xC1, 0x06, 0xFD, 0x20, 0x4A, 0x04, 0x28, 0x46, 0xCE, 0xEC, 0x62, 0x04,
  0xA0, 0x43, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x50, 0x8A, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCA,
  0x08, 0x70, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_crisis_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_crisis_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_delivery_dining 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_24_maps_delivery_dining_data[] PROGMEM = {
  0x75, 0xD6, 0xD4, 0xD6, 0xD7, 0xA7, 0x74, 0xA3, 0xF9, 0x7A, 0x3F, 0x96, 0x81, 0xAF, 0xC3, 0xF9,
  0x58, 0x27, 0xFE, 0x23, 0xF9, 0x40, 0x4A, 0x04, 0x4F, 0x93, 0x86, 0x2E, 0xF7, 0x8D, 0xD8, 0x1F,
  0xE0, 0xA0, 0x8C, 0x08, 0xFD, 0x86, 0xC0, 0xDF, 0x33, 0xFD, 0x28, 0x4D, 0xF3, 0x3F, 0xD6, 0x84,
  0xDF, 0x33, 0xFD, 0x20, 0x8C, 0x08, 0x60, 0x8C, 0x08, 0x38, 0x28, 0xDD, 0x87, 0x18, 0x28, 0xDD,
  0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_delivery_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_maps_delivery_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_departure_board 24x24, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_sharp_24_maps_departure_board_data[] PROGMEM = {
  0x74, 0x86, 0x17, 0xBE, 0xDC, 0x71, 0x76, 0x04, 0x0E, 0xE0, 0xE0, 0x47, 0x40, 0x4A, 0x0A, 0x03,
  0x20, 0x30, 0xAA, 0x04, 0x38, 0x35, 0x9C, 0xDE, 0xC0, 0x72, 0x90, 0x72, 0x84, 0x7F, 0xE1, 0x1C,
  0xF9, 0x0A, 0x39, 0x07, 0x38, 0x2A, 0xF7, 0xAF, 0xA0, 0x33, 0x90, 0x73, 0x82, 0x3F, 0xCE, 0xFA,
  0x49, 0x07, 0x49, 0x0E, 0xA6, 0x0E, 0x94, 0x90, 0xC0, 0x23, 0x90, 0xEA, 0x68, 0x1C, 0xF3, 0x38,
  0x64, 0xDF, 0x91, 0x3F, 0xCA, 0x68, 0x17, 0xFA, 0x58, 0x47, 0xD1, 0xAF, 0x7A, 0x68, 0x21, 0xEF,
  0x76, 0x82, 0x7F, 0xE1, 0xA7, 0x04, 0xA0, 0xA0, 0x32, 0x03, 0x0A, 0xA0, 0x51, 0xFF, 0xC0, 0xE0,
  0x42, 0xFF, 0xA8, 0x1C, 0x71, 0x3F, 0xFA, 0x6A, 0x81, 0x70, 0x7E, 0x81, 0x70, 0x7A, 0x6A, 0x3E,
  0x3A, 0x68, 0x3D, 0xF7, 0x07, 0xE8, 0x37, 0x07, 0xFD, 0x60, 0x8F, 0xF0, 0x87, 0xFF, 0x71, 0xB7,
  0x1B, 0x71, 0xB7, 0x1B, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_departure_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_departure_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_design_services 24x24, 4-bit Alpha,  RLE, 140 bytes.
static const unsigned char ic_sharp_24_maps_design_services_data[] PROGMEM = {
  0x40, 0x50, 0x47, 0x20, 0x27, 0x82, 0x5F, 0xE4, 0x78, 0x14, 0xF9, 0x50, 0x5B, 0x0E, 0x04, 0x50,
  0x4B, 0x09, 0x30, 0x5A, 0x83, 0x79, 0xFE, 0x44, 0x07, 0xC8, 0x19, 0x05, 0xA8, 0x92, 0x70, 0x1E,
  0xFE, 0x40, 0x45, 0x07, 0xC8, 0x92, 0x24, 0xEF, 0x90, 0xBF, 0xEF, 0xE7, 0xA8, 0x15, 0x07, 0xA0,
  0x42, 0x86, 0x4E, 0xF9, 0x1A, 0x19, 0xD8, 0x25, 0x07, 0x44, 0x82, 0x4E, 0xF9, 0x20, 0x4E, 0x05,
  0x78, 0x34, 0xEF, 0x94, 0xF0, 0x47, 0x10, 0x40, 0xEF, 0x90, 0x77, 0x30, 0x7F, 0x90, 0xE0, 0x47,
  0x10, 0x4F, 0x83, 0x49, 0xFE, 0x46, 0x04, 0xF8, 0x54, 0x01, 0xEF, 0xE4, 0x40, 0x4F, 0x98, 0x69,
  0x0A, 0xFE, 0xFE, 0x42, 0x04, 0xF8, 0x91, 0x7E, 0xF9, 0x1B, 0x19, 0xFE, 0x41, 0xF8, 0x44, 0x04,
  0xEF, 0x92, 0x07, 0xA0, 0x51, 0xE0, 0x43, 0x83, 0x4E, 0xF9, 0x7A, 0x05, 0x2D, 0x04, 0x50, 0x40,
  0xEB, 0x05, 0x3C, 0x04, 0x78, 0x24, 0xEF, 0x57, 0x73, 0x04, 0x05, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_design_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_design_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_diamond 24x24, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_sharp_24_maps_diamond_data[] PROGMEM = {
  0x20, 0x3C, 0x84, 0xD0, 0x66, 0x0D, 0xC0, 0x34, 0x0B, 0xC8, 0x46, 0x0D, 0xD0, 0x6C, 0x0B, 0x30,
  0x3C, 0x81, 0xD0, 0x6A, 0x81, 0x60, 0xDC, 0x03, 0x20, 0xBC, 0x81, 0x60, 0xDA, 0x81, 0xD0, 0x6C,
  0x81, 0xB0, 0x3C, 0x81, 0xD0, 0x6C, 0x81, 0x60, 0xDC, 0x8A, 0x43, 0x23, 0x33, 0x32, 0x02, 0x33,
  0x33, 0x20, 0x23, 0x33, 0x32, 0x18, 0x04, 0x30, 0x01, 0x80, 0x43, 0x81, 0x10, 0xBF, 0x00, 0x3F,
  0x0B, 0x20, 0x10, 0xDE, 0x00, 0x3E, 0x0D, 0x01, 0x30, 0x20, 0xED, 0x00, 0x3D, 0x0E, 0x02, 0x50,
  0x4D, 0x00, 0x3D, 0x04, 0x70, 0x6C, 0x00, 0x3C, 0x06, 0x72, 0x09, 0xB0, 0x03, 0xB0, 0x97, 0x40,
  0xBA, 0x00, 0x3A, 0x0B, 0x75, 0x86, 0x1D, 0xF3, 0x3F, 0xD1, 0x76, 0x84, 0x2E, 0x33, 0xE2, 0x77,
  0x18, 0x24, 0x33, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_diamond() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_diamond_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_dinner_dining 24x24, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_sharp_24_maps_dinner_dining_data[] PROGMEM = {
  0x1F, 0xA7, 0x48, 0x57, 0xFB, 0xBF, 0x77, 0xA7, 0x48, 0x5B, 0xFD, 0xDF, 0xBB, 0xA8, 0x05, 0xB2,
  0x85, 0xBF, 0xDD, 0xFB, 0xBA, 0x80, 0x5B, 0x28, 0x57, 0xFB, 0xBF, 0x77, 0xA7, 0x4F, 0xA7, 0x59,
  0x00, 0x79, 0x77, 0x29, 0x00, 0x79, 0x77, 0x29, 0x00, 0x79, 0x77, 0x29, 0x00, 0x79, 0x38, 0x51,
  0x8D, 0xFD, 0x91, 0x69, 0x00, 0x79, 0x20, 0x30, 0xED, 0x0E, 0x04, 0x59, 0x84, 0x77, 0xF0, 0x1E,
  0xF0, 0xE0, 0x14, 0x98, 0x3D, 0xEF, 0xBB, 0xFA, 0x09, 0x30, 0x2F, 0xF9, 0x0D, 0x30, 0xBF, 0xF9,
  0x0E, 0x77, 0x71, 0x07, 0xFF, 0xC8, 0x17, 0x07, 0xFF, 0xA0, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_dinner_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_dinner_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_bike 24x24, 4-bit Alpha,  RLE, 165 bytes.
static const unsigned char ic_sharp_24_maps_directions_bike_data[] PROGMEM = {
  0x77, 0x81, 0x27, 0x27, 0x76, 0x02, 0xB0, 0x27, 0x75, 0x06, 0xB0, 0x67, 0x75, 0x02, 0xB0, 0x27,
  0x72, 0x85, 0x4D, 0xE6, 0x27, 0x27, 0x72, 0x04, 0xC0, 0x77, 0x73, 0x04, 0xE0, 0x87, 0x71, 0x04,
  0xC0, 0xB0, 0x6A, 0x0B, 0x04, 0x75, 0x04, 0xC0, 0xB2, 0x05, 0x0E, 0xB0, 0x17, 0x30, 0x20, 0xDA,
  0x0E, 0x01, 0x38, 0x31, 0x7C, 0xE1, 0x74, 0x01, 0x0C, 0xA0, 0xB7, 0x78, 0x64, 0xBE, 0xEB, 0x40,
  0xAA, 0x0A, 0x38, 0x44, 0xBE, 0xEB, 0x43, 0x89, 0x08, 0xFD, 0x99, 0xDF, 0x80, 0x8A, 0x28, 0x92,
  0x8F, 0xD9, 0x9D, 0xF8, 0x04, 0xF9, 0x48, 0x19, 0xF4, 0x1A, 0x18, 0x14, 0xF9, 0x48, 0x39, 0xF4,
  0xBD, 0x60, 0xD0, 0xB1, 0xA1, 0x0B, 0x0D, 0x68, 0x2D, 0xBE, 0x96, 0x09, 0x0E, 0x1A, 0x10, 0xE0,
  0x96, 0x82, 0x9E, 0xE9, 0x60, 0x90, 0xE1, 0xA1, 0x0E, 0x09, 0x68, 0x29, 0xEB, 0xD6, 0x0D, 0x0B,
  0x1A, 0x10, 0xB0, 0xD6, 0x83, 0xDB, 0x4F, 0x94, 0x81, 0x9F, 0x44, 0x81, 0x4F, 0x94, 0x89, 0x29,
  0xF4, 0x08, 0xFD, 0x99, 0xDF, 0x86, 0x86, 0x8F, 0xD9, 0x9D, 0xF8, 0x38, 0x44, 0xBE, 0xEB, 0x47,
  0x18, 0x44, 0xBE, 0xEB, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 23, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_boat_filled 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_sharp_24_maps_directions_boat_filled_data[] PROGMEM = {
  0x71, 0xE7, 0x72, 0xE7, 0x72, 0xE7, 0x4F, 0xFA, 0x6F, 0xFA, 0x6A, 0x75, 0xA6, 0xA7, 0x5A, 0x6A,
  0x38, 0x42, 0x7D, 0xD7, 0x23, 0xA6, 0xA8, 0x13, 0x8D, 0xE8, 0x1D, 0x83, 0xA5, 0x03, 0xFF, 0xA0,
  0x32, 0x01, 0x0D, 0xFF, 0xC8, 0x2D, 0x10, 0xDF, 0xFC, 0x0D, 0x20, 0x9F, 0xFC, 0x09, 0x20, 0x5F,
  0xFC, 0x05, 0x20, 0x1F, 0xFC, 0x01, 0x30, 0xBF, 0xFA, 0x0B, 0x40, 0x7B, 0x00, 0x7E, 0x00, 0x7B,
  0x07, 0x48, 0x23, 0xEB, 0x32, 0x84, 0x3B, 0xEE, 0xB3, 0x28, 0x23, 0xBE, 0x37, 0x10, 0x01, 0x60,
  0x01, 0x72, 0x81, 0x13, 0x8A, 0x84, 0x84, 0x11, 0x48, 0xA8, 0x18, 0x31, 0x4F, 0xFE, 0x2A, 0x89,
  0x6E, 0xC8, 0x33, 0x8C, 0xEE, 0xC8, 0x33, 0x8C, 0xEA, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_boat_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_boat_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_boat 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_sharp_24_maps_directions_boat_data[] PROGMEM = {
  0x71, 0xE7, 0x72, 0xE7, 0x72, 0xE7, 0x4F, 0xFA, 0x6F, 0xFA, 0x6A, 0x75, 0xA6, 0xA7, 0x5A, 0x6A,
  0x38, 0x42, 0x7D, 0xD7, 0x23, 0xA6, 0xA8, 0x13, 0x8D, 0xE8, 0x1D, 0x83, 0xA5, 0x03, 0xFF, 0xA0,
  0x32, 0x01, 0x0D, 0xFF, 0xC8, 0x2D, 0x10, 0xDF, 0xFC, 0x0D, 0x20, 0x9F, 0xFC, 0x09, 0x20, 0x5F,
  0xFC, 0x05, 0x20, 0x1F, 0xFC, 0x01, 0x30, 0xBF, 0xFA, 0x0B, 0x40, 0x7B, 0x00, 0x7E, 0x00, 0x7B,
  0x07, 0x48, 0x23, 0xEB, 0x32, 0x84, 0x3B, 0xEE, 0xB3, 0x28, 0x23, 0xBE, 0x37, 0x10, 0x01, 0x60,
  0x01, 0x72, 0x81, 0x13, 0x8A, 0x84, 0x84, 0x11, 0x48, 0xA8, 0x18, 0x31, 0x4F, 0xFE, 0x2A, 0x89,
  0x6E, 0xC8, 0x33, 0x8C, 0xEE, 0xC8, 0x33, 0x8C, 0xEA, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_boat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_boat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_bus_filled 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_sharp_24_maps_directions_bus_filled_data[] PROGMEM = {
  0x28, 0x34, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x95, 0x20, 0x10, 0xBF, 0xD8, 0x1C, 0x19, 0xFF, 0x0A,
  0x0E, 0xFF, 0x0E, 0xFF, 0xC7, 0x5C, 0x75, 0xC7, 0x58, 0x0E, 0x1F, 0x81, 0x70, 0x7C, 0x81, 0x70,
  0x7E, 0x3C, 0x3E, 0x81, 0x70, 0x7C, 0x81, 0x70, 0x7B, 0x0C, 0xFF, 0x0C, 0x04, 0xFF, 0x04, 0x1F,
  0xF2, 0xB7, 0x1B, 0x2B, 0x71, 0xB1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_bus_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_bus_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_bus 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_sharp_24_maps_directions_bus_data[] PROGMEM = {
  0x28, 0x35, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x95, 0x20, 0x10, 0xCF, 0xD8, 0x1C, 0x1A, 0xFF, 0x0A,
  0x0E, 0xFF, 0x0E, 0xA7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x58, 0x0E, 0x0F, 0x81, 0x70, 0x7E,
  0x81, 0x70, 0x7C, 0x3E, 0x3A, 0x83, 0xDF, 0x70, 0x7E, 0x84, 0x70, 0x7F, 0xD8, 0xFF, 0x08, 0x1F,
  0xF2, 0xB7, 0x1B, 0x2B, 0x71, 0xB1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_bus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_bus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_car_filled 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_sharp_24_maps_directions_car_filled_data[] PROGMEM = {
  0x20, 0xBF, 0xD0, 0xB3, 0x01, 0xFF, 0x01, 0x28, 0x16, 0xFA, 0x73, 0x81, 0xAF, 0x62, 0x81, 0xCF,
  0x57, 0x38, 0x55, 0xFC, 0x02, 0xFE, 0x75, 0x82, 0xEF, 0x27, 0xFF, 0xA0, 0x70, 0xCF, 0xFA, 0x0C,
  0xFF, 0xF8, 0x17, 0x07, 0xE8, 0x17, 0x07, 0xE3, 0xE3, 0xE8, 0x17, 0x07, 0xE8, 0x17, 0x07, 0x80,
  0xF0, 0xF7, 0x5E, 0x75, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_car_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_car_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_car 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_sharp_24_maps_directions_car_data[] PROGMEM = {
  0x20, 0xBF, 0xD0, 0xB3, 0x81, 0x1F, 0xA8, 0x06, 0x78, 0x1A, 0xF1, 0x28, 0x16, 0xF2, 0x73, 0x81,
  0x2F, 0x62, 0x00, 0xC7, 0x58, 0x4C, 0xC0, 0x2F, 0x77, 0x58, 0x47, 0xF2, 0x7F, 0x27, 0x58, 0x22,
  0xF7, 0xCF, 0xFA, 0x0C, 0xFF, 0xE8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x7C, 0x3F, 0x93, 0xC8, 0x17,
  0x07, 0xF9, 0x81, 0x70, 0x78, 0x0E, 0x7F, 0x75, 0xE7, 0x5B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_car() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_car_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions 24x24, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_sharp_24_maps_directions_data[] PROGMEM = {
  0x73, 0x00, 0x17, 0x75, 0x82, 0x1C, 0xC1, 0x77, 0x30, 0x10, 0xCA, 0x0C, 0x01, 0x77, 0x10, 0x10,
  0xCC, 0x0C, 0x01, 0x76, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x40, 0x10, 0xCF, 0x90, 0xC0, 0x17, 0x20,
  0x10, 0xCF, 0x0D, 0xA0, 0xC0, 0x17, 0x01, 0x0C, 0xF9, 0x01, 0x0D, 0xA0, 0xC0, 0x15, 0x01, 0x0C,
  0xFA, 0x10, 0x10, 0xDA, 0x0C, 0x01, 0x30, 0x10, 0xCC, 0x71, 0x01, 0x0D, 0xA8, 0x3C, 0x10, 0x1C,
  0xD7, 0x10, 0x10, 0xDB, 0x82, 0xC1, 0x1C, 0xD2, 0xC1, 0x01, 0x0D, 0xC8, 0x3C, 0x10, 0x1C, 0xC2,
  0xC0, 0x10, 0xDC, 0x0C, 0x01, 0x30, 0x10, 0xCB, 0x2C, 0x0D, 0xC0, 0xC0, 0x15, 0x01, 0x0C, 0xFD,
  0x0C, 0x01, 0x70, 0x10, 0xCF, 0xB0, 0xC0, 0x17, 0x20, 0x10, 0xCF, 0x90, 0xC0, 0x17, 0x40, 0x10,
  0xCE, 0x0C, 0x01, 0x76, 0x01, 0x0C, 0xC0, 0xC0, 0x17, 0x71, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x73,
  0x82, 0x1C, 0xC1, 0x77, 0x50, 0x01, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_railway_filled 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_24_maps_directions_railway_filled_data[] PROGMEM = {
  0x28, 0x34, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x95, 0x20, 0x10, 0xBF, 0xD8, 0x1C, 0x19, 0xFF, 0x0A,
  0x0E, 0xFF, 0x0E, 0xFF, 0xC7, 0x5C, 0x75, 0xC7, 0x58, 0x0E, 0x4F, 0x82, 0xD2, 0x2D, 0xFD, 0x08,
  0x20, 0x8F, 0xD8, 0x2D, 0x22, 0xDE, 0x0C, 0xFF, 0x0C, 0x04, 0xFF, 0x82, 0x40, 0x4C, 0xFB, 0x0C,
  0x04, 0x30, 0x50, 0xEF, 0x90, 0xE0, 0x54, 0xFD, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_railway_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_railway_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_railway 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_sharp_24_maps_directions_railway_data[] PROGMEM = {
  0x28, 0x35, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x95, 0x20, 0x10, 0xCF, 0xD8, 0x1C, 0x1A, 0xFF, 0x0A,
  0x0E, 0xFF, 0x0E, 0xA7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x58, 0x0E, 0x4F, 0x82, 0xB1, 0x1B,
  0xFD, 0x01, 0x20, 0x1F, 0xD0, 0x12, 0x01, 0xE0, 0xCD, 0x82, 0xB1, 0x1B, 0xD0, 0xC0, 0x4F, 0xF8,
  0x24, 0x04, 0xCF, 0xB0, 0xC0, 0x43, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x40, 0xDF, 0xB0, 0xD2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_railway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_railway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_run 24x24, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_sharp_24_maps_directions_run_data[] PROGMEM = {
  0x72, 0x81, 0x37, 0x37, 0x50, 0x3B, 0x02, 0x74, 0x07, 0xB0, 0x67, 0x40, 0x2B, 0x02, 0x75, 0x81,
  0x26, 0x27, 0x38, 0x33, 0x9E, 0xD3, 0x72, 0x05, 0x0C, 0xC0, 0xE0, 0x17, 0x0E, 0xF0, 0xA7, 0xA0,
  0x05, 0xD0, 0x76, 0xA1, 0x08, 0xB0, 0xCA, 0x81, 0xA4, 0x13, 0xA1, 0x0B, 0xB8, 0x14, 0x6E, 0xB3,
  0xA1, 0x0E, 0xB8, 0x41, 0x01, 0x7C, 0xE5, 0x01, 0xB0, 0xE0, 0x17, 0x30, 0x4C, 0x0D, 0x01, 0x72,
  0x82, 0x8F, 0xB8, 0xA0, 0xD4, 0x89, 0x0C, 0xC8, 0x52, 0xBF, 0x80, 0x7A, 0x4F, 0x04, 0x2A, 0x48,
  0x31, 0x47, 0xAE, 0xA0, 0x12, 0xA7, 0x20, 0x10, 0x43, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_run() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 18, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_run_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_subway_filled 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_maps_directions_subway_filled_data[] PROGMEM = {
  0x28, 0x34, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x95, 0x20, 0x10, 0xBF, 0xD8, 0x1C, 0x19, 0xFF, 0x0A,
  0x0E, 0xFF, 0x0E, 0xFF, 0xC5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0x80, 0xE1, 0xF8, 0x17, 0x07, 0xC8,
  0x17, 0x07, 0xE3, 0xC3, 0xE8, 0x17, 0x07, 0xC8, 0x17, 0x07, 0xB0, 0xCF, 0xF0, 0xC0, 0x4F, 0xF8,
  0x24, 0x04, 0xCF, 0xB0, 0xC0, 0x43, 0x05, 0x0E, 0xF9, 0x0E, 0x05, 0x4F, 0xD2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_subway_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_subway_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_subway 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_sharp_24_maps_directions_subway_data[] PROGMEM = {
  0x28, 0x35, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x95, 0x20, 0x10, 0xCF, 0xD8, 0x1C, 0x1A, 0xFF, 0x0A,
  0x0E, 0xFF, 0x0E, 0xA5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0x80, 0xE0, 0xF8,
  0x17, 0x07, 0xE8, 0x17, 0x07, 0xC3, 0xE3, 0xA8, 0x3C, 0xF7, 0x07, 0xE8, 0x47, 0x07, 0xFC, 0x4F,
  0xF8, 0x24, 0x04, 0xCF, 0xB0, 0xC0, 0x43, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x40, 0xDF, 0xB0, 0xD2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_subway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_subway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_transit_filled 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_maps_directions_transit_filled_data[] PROGMEM = {
  0x28, 0x34, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x95, 0x20, 0x10, 0xBF, 0xD8, 0x1C, 0x19, 0xFF, 0x0A,
  0x0E, 0xFF, 0x0E, 0xFF, 0xC5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0x80, 0xE1, 0xF8, 0x17, 0x07, 0xC8,
  0x17, 0x07, 0xE3, 0xC3, 0xE8, 0x17, 0x07, 0xC8, 0x17, 0x07, 0xB0, 0xCF, 0xF0, 0xC0, 0x4F, 0xF8,
  0x24, 0x04, 0xCF, 0xB0, 0xC0, 0x43, 0x05, 0x0E, 0xF9, 0x0E, 0x05, 0x4F, 0xD2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_transit_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_transit_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_transit 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_sharp_24_maps_directions_transit_data[] PROGMEM = {
  0x28, 0x35, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x95, 0x20, 0x10, 0xCF, 0xD8, 0x1C, 0x1A, 0xFF, 0x0A,
  0x0E, 0xFF, 0x0E, 0xA5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0x80, 0xE0, 0xF8,
  0x17, 0x07, 0xE8, 0x17, 0x07, 0xC3, 0xE3, 0xA8, 0x3C, 0xF7, 0x07, 0xE8, 0x47, 0x07, 0xFC, 0x4F,
  0xF8, 0x24, 0x04, 0xCF, 0xB0, 0xC0, 0x43, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x40, 0xDF, 0xB0, 0xD2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_transit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_transit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_directions_walk 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_24_maps_directions_walk_data[] PROGMEM = {
  0x68, 0x12, 0x72, 0x72, 0x02, 0xB0, 0x27, 0x10, 0x6B, 0x06, 0x71, 0x02, 0xB0, 0x27, 0x28, 0x12,
  0x72, 0x78, 0x32, 0x9E, 0xD4, 0x60, 0x50, 0xBC, 0x0E, 0x01, 0x40, 0xDF, 0x0A, 0x4A, 0x06, 0x05,
  0xD0, 0x63, 0xA1, 0x08, 0xB0, 0xDA, 0x81, 0xA3, 0x1A, 0x10, 0xBB, 0x81, 0x46, 0xED, 0x10, 0xEB,
  0x84, 0x10, 0x17, 0xCE, 0x20, 0x1C, 0x01, 0x70, 0x4C, 0x0D, 0x01, 0x68, 0x27, 0xFC, 0x8A, 0x0D,
  0x68, 0x3B, 0xF8, 0x08, 0xA6, 0x81, 0xEF, 0x52, 0xA5, 0x01, 0xA0, 0x12, 0xA5, 0x81, 0x4F, 0xD3,
  0xA5, 0x81, 0x7F, 0xA3, 0xA5, 0x81, 0xAF, 0x63, 0xA5, 0x81, 0xDF, 0x33, 0xA4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_directions_walk() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 18, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_directions_walk_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_dry_cleaning 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_24_maps_dry_cleaning_data[] PROGMEM = {
  0x78, 0x28, 0xED, 0x87, 0x60, 0x8C, 0x08, 0x75, 0x84, 0xEF, 0x33, 0xFD, 0x75, 0x81, 0xEF, 0x37,
  0x71, 0x08, 0xB7, 0x71, 0x08, 0xA7, 0x71, 0x05, 0xA0, 0x57, 0x50, 0x60, 0xDC, 0x0D, 0x06, 0x78,
  0x11, 0x8E, 0xA8, 0x2D, 0x66, 0xDA, 0x81, 0xE8, 0x12, 0x03, 0x0A, 0xB0, 0xB0, 0x44, 0x04, 0x0B,
  0xB0, 0xA0, 0x3B, 0x09, 0x02, 0x71, 0x02, 0x09, 0xD0, 0x11, 0xFB, 0x10, 0x18, 0x0C, 0x2F, 0x4F,
  0xB7, 0x1F, 0xB7, 0x1F, 0xB7, 0x1F, 0xB7, 0x1F, 0xB7, 0x1F, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_dry_cleaning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_dry_cleaning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_edit_attributes 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_sharp_24_maps_edit_attributes_data[] PROGMEM = {
  0x20, 0x60, 0xCF, 0xD0, 0xD0, 0x73, 0x0A, 0xFF, 0xA8, 0x1A, 0x05, 0xF0, 0xCF, 0xB0, 0x50, 0xBE,
  0x81, 0xB1, 0xCF, 0xA8, 0x3B, 0xEF, 0xE7, 0xA8, 0x1B, 0x1B, 0xFB, 0x00, 0xEA, 0x83, 0x45, 0xB1,
  0xBF, 0xC0, 0xE0, 0xBB, 0x81, 0x40, 0xBF, 0xD0, 0xB0, 0x5C, 0x0C, 0xFE, 0x81, 0x50, 0xAF, 0xFA,
  0x0A, 0x30, 0x70, 0xDF, 0xD0, 0xC0, 0x62,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_edit_attributes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 16), Box(0, 0, 23, 23),
      ic_sharp_24_maps_edit_attributes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_edit_location_alt 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_24_maps_edit_location_alt_data[] PROGMEM = {
  0x77, 0x10, 0x27, 0x72, 0x81, 0x9E, 0x35, 0x85, 0x28, 0xCE, 0xEC, 0x32, 0x83, 0x19, 0xFE, 0x23,
  0x09, 0xD0, 0x82, 0x83, 0x9D, 0x19, 0x93, 0x0B, 0xD0, 0x82, 0x09, 0xA0, 0xD0, 0x13, 0x09, 0xD0,
  0x82, 0x09, 0xB0, 0x93, 0x02, 0xD0, 0x82, 0x09, 0xB0, 0x94, 0x08, 0xC0, 0x82, 0x09, 0xB0, 0x92,
  0x03, 0x20, 0xCC, 0x20, 0x9B, 0x09, 0x20, 0x80, 0xC2, 0x0E, 0xC2, 0xB0, 0x92, 0x81, 0x8F, 0xE2,
  0x0E, 0xC2, 0xA0, 0x92, 0x08, 0xA0, 0xE2, 0x0D, 0xC6, 0x08, 0xB0, 0xD2, 0x09, 0xC5, 0x08, 0xC0,
  0x92, 0x02, 0xFF, 0x02, 0x30, 0xAF, 0xD0, 0xA4, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x50, 0x5F, 0xB0,
  0x57, 0x08, 0xF9, 0x08, 0x72, 0x0A, 0xE0, 0xA7, 0x40, 0xAC, 0x0A, 0x76, 0x0A, 0xA0, 0xA7, 0x71,
  0x00, 0x87, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_edit_location_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_edit_location_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_edit_location 24x24, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_sharp_24_maps_edit_location_data[] PROGMEM = {
  0x77, 0x10, 0x80, 0x37, 0x71, 0x82, 0x8F, 0xE3, 0x48, 0x52, 0x8C, 0xEE, 0xC8, 0x38, 0x23, 0xEF,
  0x83, 0x09, 0xE8, 0x54, 0x09, 0xC0, 0x38, 0x30, 0xBE, 0x81, 0x40, 0x9A, 0x0C, 0x40, 0x9E, 0x81,
  0x40, 0x9B, 0x09, 0x30, 0x2E, 0x81, 0x40, 0x9B, 0x09, 0x40, 0x8D, 0x81, 0x40, 0x9B, 0x82, 0x90,
  0x47, 0x20, 0xCC, 0x81, 0x80, 0x9B, 0x83, 0x90, 0x4F, 0xC2, 0x0E, 0xC0, 0x71, 0xB8, 0x19, 0x04,
  0xA0, 0xE2, 0x0E, 0xC0, 0x71, 0xA8, 0x19, 0x04, 0xB0, 0xE2, 0x0D, 0xC0, 0x74, 0x04, 0xC0, 0xD2,
  0x09, 0xC8, 0x3B, 0x77, 0x78, 0xD0, 0x92, 0x03, 0xFF, 0x03, 0x30, 0xAF, 0xD0, 0xA4, 0x01, 0x0E,
  0xFB, 0x0E, 0x01, 0x50, 0x5F, 0xB0, 0x57, 0x08, 0xF9, 0x08, 0x72, 0x0A, 0xE0, 0xA7, 0x40, 0xAC,
  0x0A, 0x76, 0x0A, 0xA0, 0xA7, 0x71, 0x00, 0x87, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_edit_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_edit_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_edit_road 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_sharp_24_maps_edit_road_data[] PROGMEM = {
  0xA4, 0xA4, 0xA5, 0xA4, 0xA4, 0xA5, 0xA4, 0xA4, 0xA5, 0xA4, 0xA4, 0xA5, 0xA7, 0x3A, 0x5A, 0x73,
  0xA5, 0xA4, 0xA4, 0x90, 0x65, 0xA4, 0xA4, 0x06, 0x28, 0x1A, 0xE6, 0x1A, 0x4A, 0x60, 0xBB, 0x06,
  0xA4, 0xA5, 0x0B, 0xC0, 0xEA, 0x73, 0x82, 0xBF, 0x77, 0xA0, 0xAA, 0x72, 0x85, 0xBF, 0x70, 0x7F,
  0xB1, 0xA4, 0xA2, 0x85, 0xBF, 0x70, 0x7F, 0xB2, 0xA4, 0xA2, 0x98, 0x39, 0x07, 0xFB, 0x3A, 0x4A,
  0x29, 0x82, 0xB9, 0xFB, 0x4A, 0x4A, 0x2B, 0x0B, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_edit_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_edit_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_egg_alt 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_sharp_24_maps_egg_alt_data[] PROGMEM = {
  0x48, 0x63, 0x9D, 0xEE, 0xD9, 0x37, 0x40, 0x9F, 0x90, 0x97, 0x20, 0xAF, 0xB0, 0xB7, 0x06, 0xFD,
  0x08, 0x60, 0xEF, 0xE0, 0x34, 0x06, 0xFF, 0x0D, 0x40, 0xAF, 0x82, 0xD9, 0x9D, 0xC0, 0x93, 0x0D,
  0xE0, 0x94, 0x09, 0xC0, 0x72, 0x0E, 0xD0, 0xD6, 0x0D, 0xC0, 0x61, 0xE0, 0x96, 0x09, 0xD0, 0x20,
  0xDD, 0x09, 0x60, 0x9D, 0x09, 0x0B, 0xD0, 0xD6, 0x0D, 0xD0, 0xD0, 0x5E, 0x09, 0x40, 0x9E, 0x81,
  0xE0, 0xCE, 0x82, 0xD9, 0x9D, 0xF8, 0x2E, 0x02, 0xDF, 0xFA, 0x0C, 0x20, 0x10, 0xAF, 0xF9, 0x08,
  0x48, 0x13, 0x9C, 0xFD, 0x02, 0x71, 0x03, 0x0B, 0xF9, 0x07, 0x74, 0x0B, 0xE0, 0x87, 0x68, 0x46,
  0xCE, 0xEB, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_egg_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_egg_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_egg 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_24_maps_egg_data[] PROGMEM = {
  0x48, 0x41, 0x9D, 0xD9, 0x17, 0x01, 0x0D, 0xC0, 0xD0, 0x16, 0x0D, 0xE0, 0xD5, 0x09, 0xF9, 0x09,
  0x30, 0x3F, 0xB0, 0x32, 0x0A, 0xFB, 0x81, 0xA0, 0x1F, 0xD0, 0x10, 0x6F, 0xD0, 0x60, 0xAF, 0xD0,
  0xA0, 0xDA, 0x2F, 0x90, 0xD0, 0xEA, 0x20, 0xEF, 0x00, 0xEA, 0x81, 0x30, 0xAF, 0x0E, 0x0C, 0xA8,
  0x39, 0x01, 0xAE, 0xD0, 0xC0, 0x7B, 0x04, 0x4C, 0x81, 0x71, 0xEB, 0x09, 0x03, 0x2B, 0x82, 0xE1,
  0x05, 0xFB, 0x05, 0x30, 0x50, 0xEE, 0x0E, 0x05, 0x58, 0x61, 0x7C, 0xEE, 0xC7, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_egg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_egg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_electrical_services 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_maps_electrical_services_data[] PROGMEM = {
  0x1F, 0x97, 0x3F, 0x97, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x2F, 0xA7, 0x2F, 0xA7, 0x2A, 0x77,
  0x2A, 0x7D, 0x4A, 0x7D, 0x1D, 0x5F, 0x1F, 0xA1, 0xF4, 0xE1, 0xF7, 0x4F, 0x1B, 0x72, 0xD1, 0xB7,
  0x2D, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_electrical_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_electrical_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_electric_bike 24x24, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_sharp_24_maps_electric_bike_data[] PROGMEM = {
  0x75, 0xC0, 0x27, 0x75, 0xC0, 0x87, 0x77, 0x81, 0x3F, 0xD7, 0x7D, 0x38, 0x1D, 0xF4, 0x76, 0xD3,
  0x81, 0x7F, 0x97, 0x70, 0x1A, 0x01, 0x38, 0x11, 0xFE, 0x71, 0x86, 0x4B, 0xEE, 0xB4, 0x0A, 0xFA,
  0x81, 0xEB, 0x43, 0x07, 0xE0, 0x70, 0x5F, 0xD8, 0x18, 0x04, 0xA8, 0x27, 0x11, 0x6A, 0x84, 0x5E,
  0xF2, 0x04, 0xC0, 0x30, 0x7A, 0x82, 0x5B, 0xF7, 0x48, 0xA2, 0x7F, 0xB9, 0xF8, 0x0B, 0xF7, 0xAF,
  0x70, 0x7F, 0xBE, 0xF1, 0x2F, 0xC8, 0x91, 0x14, 0xFA, 0x01, 0xFE, 0xEF, 0x12, 0xFC, 0x81, 0x10,
  0x22, 0x84, 0x1F, 0xEB, 0xF7, 0x48, 0x17, 0xFB, 0x48, 0x1B, 0xF7, 0x48, 0x27, 0xFB, 0x4A, 0x82,
  0x71, 0x16, 0xA0, 0x44, 0x04, 0xA8, 0x27, 0x11, 0x7A, 0x81, 0x40, 0x8E, 0x07, 0x60, 0x7E, 0x07,
  0x38, 0x44, 0xBE, 0xEB, 0x47, 0x18, 0x44, 0xBE, 0xEB, 0x48, 0x0C, 0x10, 0x0B, 0x03, 0x77, 0x71,
  0xA0, 0xB0, 0x37, 0x72, 0x03, 0x0B, 0xE0, 0xB0, 0x37, 0x72, 0x03, 0x0B, 0xA7, 0x77, 0x10, 0x30,
  0xB7, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_electric_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 23, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_electric_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_electric_car 24x24, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_sharp_24_maps_electric_car_data[] PROGMEM = {
  0x20, 0xBF, 0xD0, 0xB3, 0x81, 0x1F, 0xA8, 0x06, 0x78, 0x1A, 0xF1, 0x28, 0x16, 0xF2, 0x73, 0x81,
  0x2F, 0x62, 0x00, 0xC7, 0x58, 0x4C, 0xC0, 0x2F, 0x77, 0x58, 0x47, 0xF2, 0x7F, 0x27, 0x58, 0x22,
  0xF7, 0xCF, 0xFA, 0x0C, 0xFF, 0xE8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x7C, 0x3F, 0x93, 0xC8, 0x17,
  0x07, 0xF9, 0x81, 0x70, 0x78, 0x0E, 0x7F, 0x75, 0xE7, 0x5B, 0x77, 0x75, 0x0B, 0x03, 0x77, 0x2A,
  0x0B, 0x03, 0x73, 0x03, 0x0B, 0xE0, 0xB0, 0x37, 0x30, 0x30, 0xBA, 0x77, 0x20, 0x30, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_electric_car() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_electric_car_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_electric_moped 24x24, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_sharp_24_maps_electric_moped_data[] PROGMEM = {
  0x75, 0xD6, 0xD4, 0xD6, 0xD7, 0xA7, 0x74, 0xA4, 0x81, 0x1A, 0xDC, 0x7A, 0x30, 0x10, 0xEE, 0x68,
  0x1A, 0xFC, 0x30, 0xAF, 0x58, 0x27, 0xFE, 0x23, 0x0D, 0xF4, 0x04, 0xA0, 0x44, 0xF9, 0x38, 0x62,
  0xEF, 0x78, 0xDD, 0x81, 0xFE, 0x0A, 0x08, 0xC0, 0x8F, 0xD8, 0x6C, 0x0D, 0xF3, 0x3F, 0xD2, 0x84,
  0xDF, 0x33, 0xFD, 0x68, 0x4D, 0xF3, 0x3F, 0xD2, 0x08, 0xC0, 0x86, 0x08, 0xC0, 0x83, 0x82, 0x8D,
  0xD8, 0x71, 0x82, 0x8D, 0xD8, 0x77, 0x77, 0x20, 0xB0, 0x37, 0x74, 0xA0, 0xB0, 0x37, 0x50, 0x30,
  0xBE, 0x0B, 0x03, 0x75, 0x03, 0x0B, 0xA7, 0x74, 0x03, 0x0B, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_electric_moped() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_electric_moped_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_electric_rickshaw 24x24, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_sharp_24_maps_electric_rickshaw_data[] PROGMEM = {
  0xFF, 0x90, 0x66, 0xFF, 0xA0, 0x45, 0xA4, 0xA5, 0xB0, 0xE0, 0x24, 0xA4, 0xA5, 0xA8, 0x2A, 0xFD,
  0x13, 0xA4, 0xA5, 0xA1, 0x81, 0xCF, 0xB3, 0xA4, 0xA5, 0xA1, 0x82, 0x1D, 0xF9, 0x2F, 0xC2, 0xF2,
  0xFC, 0x2F, 0x2F, 0x95, 0xF0, 0x81, 0xF9, 0x5F, 0x90, 0x8C, 0x00, 0x3F, 0xD8, 0x23, 0x3F, 0xEC,
  0x00, 0x3F, 0xD8, 0x23, 0x3F, 0xE2, 0x08, 0xC0, 0x87, 0x10, 0x8C, 0x08, 0x38, 0x28, 0xEE, 0x87,
  0x38, 0x28, 0xEE, 0x87, 0x77, 0x75, 0x0B, 0x03, 0x77, 0x6A, 0x0B, 0x03, 0x77, 0x03, 0x0B, 0xE0,
  0xB0, 0x37, 0x70, 0x30, 0xBA, 0x77, 0x60, 0x30, 0xB7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_electric_rickshaw() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_electric_rickshaw_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_electric_scooter 24x24, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_sharp_24_maps_electric_scooter_data[] PROGMEM = {
  0x73, 0xD0, 0x97, 0x7D, 0x0C, 0x77, 0x4A, 0x77, 0x48, 0x1B, 0xF4, 0x77, 0x38, 0x18, 0xF7, 0x77,
  0x38, 0x15, 0xFB, 0x77, 0x38, 0x11, 0xFE, 0x77, 0x48, 0x1D, 0xF2, 0x77, 0x28, 0x26, 0xEF, 0x67,
  0x70, 0x10, 0xCB, 0x09, 0x77, 0x83, 0xCF, 0xD5, 0x14, 0x82, 0x8E, 0xE8, 0x68, 0x90, 0x6F, 0xD1,
  0x8D, 0xD8, 0x08, 0xC0, 0x85, 0x82, 0xBF, 0x58, 0xC8, 0x38, 0xEF, 0x33, 0xFA, 0x89, 0x11, 0xDF,
  0x33, 0xFD, 0xDF, 0x33, 0xFA, 0x18, 0x5D, 0xF3, 0x3F, 0xD8, 0xC0, 0x87, 0x10, 0x8C, 0x84, 0x80,
  0x8D, 0xE8, 0x73, 0x82, 0x8D, 0xD8, 0x73, 0x0B, 0x03, 0x77, 0x4A, 0x0B, 0x03, 0x75, 0x03, 0x0B,
  0xE0, 0xB0, 0x37, 0x50, 0x30, 0xBA, 0x77, 0x40, 0x30, 0xB7, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_electric_scooter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_electric_scooter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_emergency 24x24, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_sharp_24_maps_emergency_data[] PROGMEM = {
  0x7C, 0x77, 0xC7, 0x7C, 0x71, 0x81, 0x3E, 0x73, 0xC3, 0x81, 0x7E, 0x32, 0x0C, 0xA0, 0xD0, 0x51,
  0xC1, 0x05, 0x0D, 0xA8, 0x1C, 0x05, 0xD0, 0xBC, 0x0B, 0xD8, 0x15, 0x5E, 0xFF, 0x0E, 0x05, 0x20,
  0x8F, 0xD0, 0x85, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x60, 0x20, 0xBF, 0x90, 0xB0, 0x25, 0x08, 0xFD,
  0x08, 0x20, 0x50, 0xEF, 0xF8, 0x1E, 0x55, 0xD0, 0xBC, 0x0B, 0xD8, 0x15, 0x0C, 0xA0, 0xD0, 0x51,
  0xC1, 0x05, 0x0D, 0xA0, 0xC2, 0x81, 0x3E, 0x73, 0xC3, 0x81, 0x7E, 0x37, 0x1C, 0x77, 0xC7, 0x7C,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_emergency_recording 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_sharp_24_maps_emergency_recording_data[] PROGMEM = {
  0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA3, 0x01, 0xF2, 0xF2, 0x01, 0x0D, 0xB0, 0xE0, 0xCA, 0x2A, 0x0C,
  0x0E, 0xB1, 0x02, 0x0D, 0xC8, 0x26, 0x06, 0xE2, 0x82, 0xE6, 0x06, 0xB0, 0x20, 0xDD, 0x07, 0x20,
  0x12, 0x01, 0x20, 0x7B, 0x0D, 0xF0, 0xD0, 0x44, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF,
  0xC0, 0x72, 0x01, 0x20, 0x12, 0x07, 0xB0, 0xDE, 0x82, 0x60, 0x6E, 0x28, 0x2E, 0x60, 0x6B, 0x02,
  0x0D, 0xD0, 0xE0, 0xCA, 0x2A, 0x0C, 0x0E, 0xB1, 0x02, 0x0D, 0xF9, 0x2F, 0x20, 0x10, 0xDF, 0xFA,
  0x30, 0x1F, 0xFA, 0x4F, 0xFA, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_emergency_recording() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_emergency_recording_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_emergency_share 24x24, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_sharp_24_maps_emergency_share_data[] PROGMEM = {
  0x38, 0x90, 0x15, 0xAD, 0xEE, 0xDA, 0x51, 0x50, 0x70, 0xEF, 0x90, 0xE0, 0x72, 0x01, 0x0C, 0xA8,
  0x1B, 0x62, 0x28, 0x12, 0x6B, 0xA8, 0x4C, 0x16, 0xFD, 0x37, 0x18, 0xA1, 0x3D, 0xF7, 0x05, 0x10,
  0x17, 0xCE, 0xEC, 0x71, 0x01, 0x54, 0x05, 0x0E, 0xE0, 0xE0, 0x56, 0x82, 0x7F, 0xA3, 0x28, 0x23,
  0xAF, 0x77, 0x03, 0x60, 0x37, 0x77, 0x48, 0x46, 0xCE, 0xEC, 0x67, 0x10, 0x10, 0xCE, 0x0C, 0x01,
  0x60, 0xCF, 0x90, 0xC5, 0x06, 0xFB, 0x06, 0x40, 0xBC, 0x00, 0x9C, 0x0B, 0x40, 0xEB, 0x09, 0x20,
  0x9B, 0x0E, 0x40, 0xEB, 0x09, 0x20, 0x9B, 0x0E, 0x40, 0xBC, 0x00, 0x9C, 0x0B, 0x40, 0x6F, 0xB0,
  0x65, 0x0D, 0xF9, 0x0D, 0x60, 0x4F, 0x90, 0x47, 0x07, 0xE0, 0x77, 0x20, 0x9C, 0x09, 0x74, 0x09,
  0xA0, 0x97, 0x60, 0x08, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_emergency_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 19, 23), Box(0, 0, 23, 23),
      ic_sharp_24_maps_emergency_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_ev_station 24x24, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_sharp_24_maps_ev_station_data[] PROGMEM = {
  0xFB, 0x10, 0x10, 0x24, 0xFB, 0x18, 0x1B, 0xD2, 0x3F, 0xB1, 0x82, 0x2D, 0xD2, 0x2D, 0x0B, 0xC2,
  0x82, 0x3F, 0xD2, 0x1D, 0x03, 0xC1, 0x01, 0x0D, 0xA0, 0xD1, 0xC0, 0xA1, 0xC1, 0x84, 0x6F, 0x33,
  0xF6, 0xC0, 0x21, 0xC1, 0x84, 0x6F, 0x33, 0xF7, 0xB0, 0x92, 0xC1, 0x01, 0x0D, 0xB0, 0x7A, 0x0E,
  0x01, 0x30, 0x4A, 0x28, 0x31, 0x66, 0xF7, 0xA0, 0x84, 0x0D, 0xD2, 0x90, 0x7A, 0x08, 0x07, 0x20,
  0x6B, 0x07, 0x0B, 0x92, 0x90, 0x7C, 0x10, 0x10, 0xEB, 0x10, 0x79, 0x29, 0x07, 0xC1, 0x08, 0xC1,
  0x07, 0x92, 0x90, 0x7C, 0x02, 0xD1, 0x07, 0x92, 0x90, 0x7C, 0x0B, 0xD1, 0x07, 0x92, 0x90, 0x7F,
  0xB1, 0x07, 0x92, 0x90, 0x7F, 0xB1, 0x84, 0x7F, 0x77, 0xF7, 0xFB, 0x10, 0x7C, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_ev_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_ev_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_factory 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_maps_factory_data[] PROGMEM = {
  0x77, 0x10, 0x1B, 0x01, 0x77, 0x10, 0x2B, 0x02, 0x77, 0x10, 0x4B, 0x04, 0x77, 0x10, 0x6B, 0x06,
  0x77, 0x10, 0x8B, 0x08, 0x50, 0x50, 0xC3, 0x06, 0x0C, 0x30, 0xAB, 0x0A, 0x28, 0x11, 0x7E, 0xA8,
  0x13, 0x9E, 0xA3, 0x85, 0x57, 0x77, 0x53, 0x9F, 0xB7, 0x18, 0x09, 0xA1, 0xF2, 0xA2, 0xA2, 0xFB,
  0x2A, 0x2A, 0x2F, 0xB2, 0xA2, 0xA2, 0xFB, 0x2A, 0x2A, 0x28, 0x09, 0xA1, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_factory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_factory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_fastfood 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_sharp_24_maps_fastfood_data[] PROGMEM = {
  0x77, 0x1A, 0x77, 0x6A, 0x77, 0x6A, 0x77, 0x6A, 0x77, 0x10, 0xEF, 0xB0, 0xE7, 0x30, 0xDF, 0xB0,
  0xD7, 0x30, 0x50, 0xAF, 0xA0, 0xB7, 0x50, 0x20, 0xAF, 0x0A, 0x38, 0x72, 0x8C, 0xEF, 0xEC, 0x82,
  0x20, 0x7E, 0x08, 0x20, 0x8F, 0xA0, 0x82, 0x08, 0xD8, 0x16, 0x0A, 0xFC, 0x0A, 0x20, 0xDC, 0x00,
  0x5F, 0xE8, 0x15, 0x06, 0xC0, 0x30, 0xBF, 0xE8, 0x1B, 0x02, 0xC0, 0x20, 0xEF, 0xE0, 0xE2, 0xC7,
  0x74, 0xB0, 0xE7, 0x74, 0xB0, 0xD1, 0xFF, 0x92, 0xB0, 0xB1, 0xFF, 0x92, 0xB0, 0xA7, 0x74, 0xB0,
  0x87, 0x74, 0xB0, 0x61, 0xFF, 0x92, 0xB0, 0x51, 0xFF, 0x92, 0xB0, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_fastfood() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_fastfood_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_festival 24x24, 4-bit Alpha,  RLE, 161 bytes.
static const unsigned char ic_sharp_24_maps_festival_data[] PROGMEM = {
  0x73, 0x00, 0x87, 0x75, 0x0A, 0xA0, 0xA7, 0x72, 0x86, 0x2C, 0xFE, 0xEF, 0xC2, 0x76, 0x89, 0x05,
  0xEF, 0xD2, 0x2D, 0xFE, 0x57, 0x30, 0x20, 0xBA, 0x0A, 0x40, 0xAA, 0x0B, 0x02, 0x60, 0x10, 0x8A,
  0x0E, 0x05, 0x60, 0x50, 0xEA, 0x08, 0x01, 0x28, 0x13, 0x9E, 0xA0, 0x90, 0x17, 0x10, 0x10, 0x9A,
  0x81, 0xE9, 0x38, 0x0D, 0x0F, 0x83, 0xEF, 0x20, 0x2A, 0x81, 0x20, 0x2A, 0x81, 0x20, 0x2A, 0x89,
  0x02, 0x02, 0xFE, 0x9F, 0xD8, 0xDA, 0x81, 0xD8, 0xDA, 0x81, 0xD8, 0xDA, 0x85, 0xD8, 0xDF, 0x91,
  0xCB, 0x00, 0xCB, 0x00, 0xCB, 0x00, 0xCB, 0x0C, 0x01, 0x28, 0x6C, 0xF6, 0x02, 0xFD, 0x42, 0x86,
  0x4D, 0xF2, 0x06, 0xFC, 0x48, 0x5D, 0xF2, 0x03, 0xFB, 0x48, 0x5B, 0xF3, 0x02, 0xFC, 0x48, 0x5E,
  0xF1, 0x05, 0xFA, 0x48, 0x5A, 0xF4, 0x01, 0xFD, 0x4A, 0x28, 0x16, 0xF9, 0x48, 0x19, 0xF6, 0x2A,
  0x38, 0x11, 0xFD, 0x28, 0x18, 0xF7, 0x48, 0x17, 0xF7, 0x28, 0x1D, 0xF1, 0x28, 0x14, 0xFB, 0x28,
  0x19, 0xF6, 0x48, 0x16, 0xF9, 0x28, 0x1B, 0xF4, 0x20, 0x8F, 0xFC, 0x08, 0x20, 0xDF, 0xFC, 0x0D,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_festival() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_festival_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_fire_hydrant_alt 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_sharp_24_maps_fire_hydrant_alt_data[] PROGMEM = {
  0x68, 0x45, 0xBE, 0xEB, 0x57, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x71, 0x0C, 0xF9, 0x0C, 0x70, 0x5F,
  0xB0, 0x54, 0xFF, 0xA2, 0xFF, 0xA4, 0xFD, 0x6F, 0xD6, 0xC8, 0x2D, 0x99, 0xDC, 0x3E, 0x09, 0x40,
  0x9F, 0xC0, 0xD2, 0x00, 0x52, 0x0D, 0xFB, 0x81, 0x90, 0x5A, 0x81, 0x50, 0x9F, 0xB8, 0x19, 0x05,
  0xA8, 0x15, 0x09, 0xFB, 0x0D, 0x20, 0x05, 0x20, 0xDF, 0xC0, 0x94, 0x09, 0xE3, 0xC8, 0x2D, 0x99,
  0xDC, 0x6F, 0xD6, 0xFD, 0x4F, 0xFA, 0x2F, 0xFA, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_fire_hydrant_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_fire_hydrant_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_fire_truck 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_24_maps_fire_truck_data[] PROGMEM = {
  0x77, 0x1B, 0x77, 0x5B, 0x4F, 0xB1, 0xFA, 0x89, 0x22, 0x07, 0xFB, 0x7D, 0xD7, 0xBF, 0x71, 0xFA,
  0x07, 0x29, 0x84, 0x70, 0xBB, 0x07, 0x92, 0xA5, 0x89, 0x44, 0xFC, 0x07, 0xFB, 0x7D, 0xD7, 0xBF,
  0x71, 0xA6, 0x81, 0xEF, 0x2F, 0xB1, 0xA6, 0x81, 0x9F, 0x77, 0x4A, 0x68, 0x14, 0xFC, 0x80, 0xA8,
  0x5F, 0x00, 0x3F, 0x90, 0x03, 0xD3, 0x84, 0xDF, 0x33, 0xFD, 0x48, 0x4D, 0xF3, 0x3F, 0xD6, 0x08,
  0xC0, 0x84, 0x08, 0xC0, 0x87, 0x82, 0x8D, 0xD8, 0x68, 0x28, 0xDD, 0x84,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_fire_truck() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_fire_truck_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_flight_class 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_sharp_24_maps_flight_class_data[] PROGMEM = {
  0xA5, 0xF9, 0x5F, 0x95, 0xF9, 0x5E, 0x81, 0xDF, 0x24, 0xE8, 0x18, 0xF7, 0x4E, 0x81, 0x3F, 0xC4,
  0xE1, 0x81, 0xEF, 0x13, 0xE1, 0x81, 0xAF, 0x63, 0xE1, 0x81, 0x5F, 0xB7, 0x30, 0x1A, 0x74, 0x81,
  0xBF, 0x57, 0x30, 0x7F, 0xB2, 0x02, 0xFB, 0x77, 0x2F, 0xB3, 0xFB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_flight_class() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 17, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_flight_class_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_flight 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_sharp_24_maps_flight_data[] PROGMEM = {
  0x71, 0x81, 0x8E, 0x87, 0x72, 0xB7, 0x72, 0xB7, 0x72, 0xB7, 0x72, 0xB7, 0x72, 0xB7, 0x72, 0xB7,
  0x70, 0x10, 0xAB, 0x0A, 0x01, 0x74, 0x06, 0x0E, 0xD0, 0xE0, 0x67, 0x10, 0x30, 0xCF, 0xA0, 0xC0,
  0x35, 0x08, 0xFE, 0x08, 0x20, 0x40, 0xDC, 0x0E, 0x0A, 0xB0, 0xA0, 0xEC, 0x0D, 0x04, 0xB8, 0x1D,
  0x94, 0x2B, 0x28, 0x14, 0x9D, 0xB8, 0x1D, 0x83, 0x5B, 0x58, 0x13, 0x8D, 0x71, 0xB7, 0x72, 0xB7,
  0x72, 0xB7, 0x71, 0x09, 0xB0, 0x97, 0x60, 0xCD, 0x0C, 0x75, 0x85, 0xD8, 0x41, 0x48, 0xD6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_flight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_flight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_forest 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_24_maps_forest_data[] PROGMEM = {
  0x71, 0x00, 0x54, 0x00, 0x57, 0x71, 0x82, 0x1E, 0xE1, 0x28, 0x21, 0xEE, 0x17, 0x70, 0xBA, 0x0B,
  0x20, 0xBA, 0x0B, 0x76, 0x07, 0xC0, 0x70, 0x3C, 0x07, 0x74, 0x02, 0xE0, 0x20, 0x9C, 0x02, 0x73,
  0x0C, 0xE8, 0x1C, 0x1D, 0xB0, 0xC7, 0x20, 0x8F, 0x90, 0x80, 0x3C, 0x08, 0x70, 0x3F, 0xB0, 0x30,
  0x8C, 0x03, 0x50, 0x10, 0xDF, 0xB8, 0x1D, 0x1C, 0xB0, 0xD0, 0x14, 0x0A, 0xFD, 0x81, 0xA2, 0xEB,
  0x0A, 0x50, 0x7F, 0xB0, 0x72, 0x06, 0xA0, 0x75, 0x02, 0x0E, 0xFB, 0x81, 0xE2, 0xAB, 0x0E, 0x02,
  0x40, 0xBF, 0xD8, 0x1B, 0x1E, 0xB0, 0xB3, 0x06, 0xFF, 0x00, 0x6C, 0x82, 0x60, 0x1E, 0xFF, 0x81,
  0xE1, 0xBB, 0x81, 0xE1, 0xAF, 0xFA, 0x0A, 0x02, 0xC0, 0xA7, 0xC7, 0x76, 0xC2, 0xC7, 0x7C, 0x2C,
  0x77, 0xC2, 0xC7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_forest() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_forest_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_fork_left 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_24_maps_fork_left_data[] PROGMEM = {
  0x72, 0x00, 0x77, 0x40, 0x7A, 0x07, 0x72, 0x07, 0xC0, 0x77, 0x07, 0xE0, 0x76, 0x81, 0x7F, 0x5A,
  0x81, 0x5F, 0x77, 0x02, 0x1A, 0x10, 0x24, 0x00, 0x74, 0xA5, 0x07, 0xA0, 0x23, 0xA4, 0x07, 0xA0,
  0x64, 0xA3, 0x07, 0xD8, 0x1D, 0x81, 0xA3, 0x07, 0xC0, 0xEA, 0x0D, 0xA4, 0x07, 0xA8, 0x25, 0x03,
  0xBB, 0x50, 0x7A, 0x02, 0x20, 0xBA, 0x60, 0x07, 0x30, 0x3A, 0x75, 0xA7, 0x5A, 0x75, 0xA7, 0x5A,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_fork_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 17, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_fork_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_fork_right 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_24_maps_fork_right_data[] PROGMEM = {
  0x30, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x20, 0x7C, 0x07, 0x70, 0x7E, 0x07, 0x68, 0x17, 0xF5, 0xA8,
  0x15, 0xF7, 0x70, 0x21, 0xA1, 0x02, 0x73, 0xA4, 0x00, 0x76, 0xA3, 0x02, 0xA0, 0x75, 0xA4, 0x06,
  0xA0, 0x74, 0xA8, 0x11, 0x8D, 0xD0, 0x73, 0xA0, 0xDA, 0x0E, 0xC0, 0x73, 0xB8, 0x2B, 0x30, 0x5A,
  0x07, 0x4A, 0x0B, 0x20, 0x2A, 0x07, 0x5A, 0x03, 0x30, 0x07, 0x6A, 0x75, 0xA7, 0x5A, 0x75, 0xA7,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_fork_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_fork_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_fort 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_24_maps_fort_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA2, 0xFD, 0x2F, 0xFE, 0x2F, 0xB0, 0x7F,
  0x90, 0x72, 0x07, 0xF9, 0x81, 0x70, 0x7E, 0x07, 0x40, 0x7E, 0x07, 0x3E, 0x6E, 0x4F, 0xFC, 0x4F,
  0xFC, 0x4F, 0xFC, 0x4F, 0xFC, 0x4F, 0xFC, 0x30, 0x7F, 0xFC, 0x81, 0x70, 0x7F, 0x94, 0xF9, 0x07,
  0xFA, 0x4F, 0xFC, 0x4F, 0xFC, 0x4F, 0xFC, 0x4F, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_fort() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_fort_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_hail 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_maps_hail_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x43, 0x90, 0xE6, 0x0D, 0xA0, 0xD2, 0x81, 0x2F, 0xD6, 0x0D, 0xA0, 0xD2, 0x81,
  0x7F, 0x96, 0x87, 0x4D, 0xD4, 0x02, 0xEF, 0x37, 0x28, 0x32, 0x7E, 0xF9, 0x58, 0x22, 0x8C, 0xEC,
  0x09, 0x50, 0x8F, 0x02, 0x50, 0x9F, 0x95, 0x04, 0xA0, 0x5E, 0x58, 0x1A, 0xF7, 0x1E, 0x58, 0x1D,
  0xF2, 0x1E, 0x5A, 0x2E, 0x72, 0xE7, 0x2E, 0x4B, 0x2A, 0x2A, 0x4B, 0x2A, 0x2A, 0x4B, 0x2A, 0x2A,
  0x4B, 0x2A, 0x2A, 0x4B, 0x2A, 0x2A, 0x4B, 0x2A, 0x2A, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_hail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 18, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_hail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_handyman 24x24, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_sharp_24_maps_handyman_data[] PROGMEM = {
  0x76, 0x04, 0x0A, 0x73, 0x09, 0x04, 0x78, 0x14, 0xFE, 0x72, 0x09, 0xA0, 0x45, 0x04, 0xA8, 0x1E,
  0x29, 0x60, 0x9C, 0x04, 0x30, 0x10, 0xEA, 0x82, 0xED, 0xFA, 0x50, 0x5C, 0x0D, 0x48, 0x12, 0x36,
  0xC0, 0xA5, 0x05, 0xB0, 0xE0, 0x15, 0x0D, 0xD0, 0xA5, 0x84, 0x5D, 0xEF, 0xC1, 0x40, 0x6E, 0x06,
  0x68, 0x31, 0xDF, 0xC1, 0x20, 0x10, 0xCB, 0x0E, 0xA0, 0xA7, 0x89, 0x51, 0xDF, 0xC1, 0x1C, 0xFD,
  0x6D, 0x28, 0xF9, 0x71, 0x86, 0x1D, 0xFC, 0xCF, 0xD1, 0x40, 0x70, 0x27, 0x20, 0x10, 0xDA, 0x0D,
  0x01, 0x77, 0x18, 0x61, 0x2C, 0xFD, 0x10, 0x17, 0x50, 0x20, 0xDB, 0x85, 0xD1, 0x04, 0xFD, 0x17,
  0x20, 0x20, 0xDC, 0x81, 0x20, 0x4B, 0x0D, 0x01, 0x70, 0x20, 0xDD, 0x02, 0x01, 0xD0, 0xD0, 0x25,
  0x02, 0x0D, 0xD8, 0x2D, 0x11, 0xDD, 0x0D, 0x02, 0x30, 0x20, 0xDD, 0x0D, 0x02, 0x20, 0x20, 0xDD,
  0x83, 0xD2, 0x01, 0xDD, 0x0D, 0x02, 0x40, 0x20, 0xDD, 0x82, 0xD1, 0x0B, 0xC0, 0xD0, 0x26, 0x02,
  0x0D, 0xC0, 0xB3, 0x0B, 0xA0, 0xD0, 0x27, 0x10, 0x20, 0xDA, 0x0B, 0x58, 0x1B, 0xD2, 0x73, 0x81,
  0x2D, 0xB7, 0x02, 0x75, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_handyman() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_handyman_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_hardware 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_sharp_24_maps_hardware_data[] PROGMEM = {
  0x28, 0x14, 0xBE, 0xE2, 0x07, 0xA1, 0x08, 0xFA, 0x10, 0x7B, 0x04, 0xFB, 0x07, 0xC0, 0xBF, 0xF9,
  0x0E, 0xFF, 0x95, 0xE0, 0x7C, 0x5E, 0x10, 0x7B, 0x5E, 0x20, 0x7A, 0x80, 0xC1, 0x0E, 0x73, 0xE7,
  0x3E, 0x73, 0xE7, 0x3E, 0x73, 0xE7, 0x3E, 0x73, 0xE5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_hardware() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_hardware_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_home_repair_service 24x24, 4-bit Alpha,  RLE, 25 bytes.
static const unsigned char ic_sharp_24_maps_home_repair_service_data[] PROGMEM = {
  0x5F, 0xB7, 0x3F, 0xB7, 0x3A, 0x6A, 0x73, 0xA6, 0xA5, 0x80, 0x9A, 0x0F, 0x2F, 0x92, 0xF9, 0x2F,
  0x92, 0xC7, 0x76, 0xC2, 0xF9, 0x28, 0x09, 0xA0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_home_repair_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_home_repair_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_hotel 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_sharp_24_maps_hotel_data[] PROGMEM = {
  0xA7, 0x76, 0xA7, 0x76, 0xA2, 0x82, 0x8D, 0xD8, 0x2F, 0xF1, 0x08, 0xC0, 0x81, 0xFF, 0x10, 0xDC,
  0x0D, 0x1F, 0xF1, 0x0D, 0xC0, 0xD1, 0xFF, 0x10, 0x8C, 0x08, 0x1F, 0xF2, 0x82, 0x8D, 0xD8, 0x2F,
  0xF7, 0x18, 0x09, 0x94, 0xF7, 0x74, 0xC7, 0x74, 0xC7, 0x74, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_hotel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_hotel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_hvac 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_24_maps_hvac_data[] PROGMEM = {
  0x80, 0xF0, 0xF0, 0x80, 0x32, 0x03, 0x08, 0xFB, 0x0D, 0x02, 0x60, 0x20, 0xDF, 0x98, 0x90, 0x20,
  0x19, 0xEE, 0x91, 0x02, 0xF0, 0x87, 0x30, 0x8E, 0x81, 0x30, 0xAE, 0x81, 0xA0, 0x3E, 0x20, 0x68,
  0x02, 0x70, 0x62, 0xE2, 0x06, 0x80, 0x37, 0x2E, 0x81, 0x30, 0xAE, 0x81, 0xA0, 0x3E, 0x08, 0x73,
  0x08, 0xF8, 0x90, 0x20, 0x19, 0xEE, 0x91, 0x02, 0xF9, 0x0D, 0x02, 0x60, 0x20, 0xDF, 0xB0, 0x80,
  0x32, 0x03, 0x08, 0x80, 0xF0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_hvac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_hvac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_icecream 24x24, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_sharp_24_maps_icecream_data[] PROGMEM = {
  0x68, 0x47, 0xCE, 0xEC, 0x77, 0x30, 0x30, 0xDE, 0x0D, 0x03, 0x70, 0x20, 0xEF, 0x90, 0xE0, 0x26,
  0x0B, 0xFB, 0x0B, 0x50, 0x2F, 0xD0, 0x23, 0x02, 0x0B, 0xFD, 0x83, 0xB2, 0x02, 0xEF, 0xF8, 0x1E,
  0x2A, 0xFF, 0xA0, 0xA0, 0xEF, 0xFA, 0x0E, 0x0D, 0xFF, 0xA0, 0xD0, 0xAF, 0xFA, 0x81, 0xA1, 0xEF,
  0xF8, 0x4E, 0x10, 0x1A, 0xDA, 0x84, 0xBC, 0xEE, 0xCB, 0xA8, 0x1D, 0xA1, 0x58, 0x15, 0xFD, 0x48,
  0x1C, 0xF6, 0x72, 0x81, 0xDF, 0x62, 0x81, 0x5F, 0xD7, 0x38, 0x15, 0xFD, 0x28, 0x1D, 0xF6, 0x74,
  0x84, 0xCF, 0x75, 0xFD, 0x75, 0x84, 0x4F, 0xED, 0xF5, 0x76, 0x0B, 0xA0, 0xD7, 0x70, 0x3A, 0x05,
  0x77, 0x10, 0xB0, 0xC7, 0x72, 0x03, 0x04, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_icecream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_icecream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_kebab_dining 24x24, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_sharp_24_maps_kebab_dining_data[] PROGMEM = {
  0x30, 0x0B, 0x71, 0x00, 0xB3, 0x01, 0x0B, 0xC0, 0xB0, 0x12, 0x01, 0x0B, 0xC8, 0x1B, 0x1B, 0xE0,
  0xB2, 0x0B, 0xE0, 0xB0, 0xEE, 0x0E, 0x20, 0xEE, 0x0E, 0x0B, 0xE0, 0xB2, 0x0B, 0xE8, 0x1B, 0x1B,
  0xC0, 0xB0, 0x12, 0x01, 0x0B, 0xC0, 0xB0, 0x13, 0x00, 0xB7, 0x10, 0x0B, 0x3F, 0x92, 0xFF, 0xA2,
  0xFF, 0xA2, 0xFF, 0xA2, 0xFF, 0xA2, 0xF9, 0x30, 0x0B, 0x71, 0x00, 0xB3, 0x01, 0x0B, 0xC0, 0xB0,
  0x12, 0x01, 0x0B, 0xC8, 0x1B, 0x1B, 0xE0, 0xB2, 0x0B, 0xE0, 0xB0, 0xEE, 0x0E, 0x20, 0xEE, 0x0E,
  0x0B, 0xE0, 0xB2, 0x0B, 0xE8, 0x1B, 0x1B, 0xC0, 0xB0, 0x12, 0x01, 0x0B, 0xC0, 0xB0, 0x13, 0x00,
  0xB7, 0x10, 0x0B, 0x60, 0x0B, 0x71, 0x00, 0xB6, 0x00, 0xB7, 0x10, 0x0B, 0x60, 0x0B, 0x71, 0x00,
  0xB3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_kebab_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_kebab_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_layers_clear 24x24, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_sharp_24_maps_layers_clear_data[] PROGMEM = {
  0x81, 0x4D, 0x27, 0x73, 0x82, 0xAF, 0xD2, 0x50, 0x09, 0x73, 0x82, 0xBF, 0xD2, 0x20, 0x10, 0xCA,
  0x0C, 0x01, 0x72, 0x85, 0xBF, 0xD2, 0x02, 0xEB, 0x0E, 0x04, 0x72, 0x85, 0xBF, 0xD2, 0x02, 0xEC,
  0x07, 0x71, 0x86, 0x1E, 0xFD, 0x20, 0x2E, 0xC0, 0xB0, 0x15, 0x03, 0x0D, 0xB8, 0x3D, 0x20, 0x2E,
  0xC0, 0xD0, 0x33, 0x06, 0xE8, 0x3D, 0x20, 0x2E, 0xD0, 0x62, 0x06, 0xF8, 0x3D, 0x20, 0x2E, 0xC0,
  0x63, 0x03, 0x0D, 0xE8, 0x6D, 0x20, 0x2E, 0xFD, 0x35, 0x01, 0x0B, 0xE8, 0x4D, 0x20, 0x2A, 0x17,
  0x10, 0x7E, 0x0D, 0x02, 0x78, 0x15, 0xE7, 0x20, 0x40, 0xED, 0x84, 0xD2, 0x01, 0xD5, 0x20, 0x7A,
  0x83, 0xB1, 0x01, 0xCA, 0x86, 0xCB, 0xFD, 0x20, 0x36, 0x38, 0x33, 0xEF, 0xD3, 0x20, 0x09, 0x28,
  0x2C, 0xFD, 0x26, 0x01, 0x0B, 0xA0, 0x64, 0x06, 0xB0, 0xD0, 0x27, 0x08, 0xA0, 0x92, 0x09, 0xA8,
  0x38, 0xBF, 0xD2, 0x78, 0x65, 0xEF, 0xCC, 0xFE, 0x52, 0x82, 0xBF, 0xD2, 0x70, 0x20, 0xDA, 0x0D,
  0x02, 0x48, 0x1B, 0xFD, 0x72, 0x00, 0xA7, 0x0A, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_layers_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_layers_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_layers 24x24, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_sharp_24_maps_layers_data[] PROGMEM = {
  0x71, 0x00, 0x97, 0x70, 0x10, 0xCA, 0x0C, 0x01, 0x74, 0x04, 0x0E, 0xC0, 0xE0, 0x47, 0x20, 0x7F,
  0x90, 0x76, 0x01, 0x0B, 0xFB, 0x0B, 0x01, 0x30, 0x30, 0xDF, 0xD8, 0x2D, 0x30, 0x6F, 0xFA, 0x00,
  0x6F, 0xF9, 0x83, 0xE5, 0x03, 0xDF, 0xD0, 0xD0, 0x33, 0x01, 0x0B, 0xFB, 0x0B, 0x01, 0x60, 0x7F,
  0x90, 0x74, 0x81, 0x5E, 0x72, 0x04, 0x0E, 0xC0, 0xE0, 0x42, 0x82, 0x8E, 0x57, 0xA8, 0x3B, 0x10,
  0x1C, 0xA8, 0x3C, 0x10, 0x1B, 0xA8, 0x57, 0x03, 0xEF, 0xD3, 0x20, 0x09, 0x28, 0x33, 0xDF, 0xE3,
  0x30, 0x10, 0xBA, 0x06, 0x40, 0x6A, 0x0B, 0x01, 0x60, 0x8A, 0x09, 0x20, 0x9A, 0x08, 0x72, 0x86,
  0x5E, 0xFC, 0xCF, 0xE5, 0x74, 0x02, 0x0D, 0xA0, 0xD0, 0x27, 0x70, 0x0A, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_layers() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_layers_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_liquor 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_sharp_24_maps_liquor_data[] PROGMEM = {
  0x74, 0xD7, 0x7D, 0x77, 0xA1, 0xA7, 0x7D, 0x3E, 0x5D, 0x3E, 0x5A, 0x1A, 0x3A, 0x2A, 0x28, 0x12,
  0x7C, 0xA1, 0xA8, 0x1D, 0x72, 0xA2, 0xA2, 0xB8, 0x3E, 0x90, 0x9E, 0xD2, 0xA2, 0xA0, 0x45, 0x04,
  0xF9, 0x2A, 0x7F, 0x92, 0xFF, 0xB2, 0xFC, 0x0E, 0xC0, 0xE2, 0xFC, 0x08, 0xC0, 0x82, 0xFC, 0x10,
  0x8A, 0x08, 0x3F, 0xC2, 0xA4, 0xFC, 0x2A, 0x4A, 0x7A, 0x2A, 0x4A, 0x7F, 0x92, 0xFF, 0xB2, 0xFC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_liquor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_liquor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_activity 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_24_maps_local_activity_data[] PROGMEM = {
  0x80, 0xD5, 0xF0, 0x0B, 0xFF, 0xC0, 0x05, 0xFF, 0xB0, 0xE2, 0x0E, 0xFE, 0x82, 0xDD, 0xC6, 0x28,
  0x27, 0xCD, 0xED, 0x01, 0x0B, 0xA0, 0xB0, 0x17, 0x10, 0x10, 0xBA, 0x82, 0xB1, 0x01, 0xB0, 0xD0,
  0x26, 0x02, 0x0D, 0xB0, 0x12, 0x01, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC8, 0x21, 0x01, 0xBD, 0x04,
  0x40, 0x4D, 0x0B, 0x01, 0xF2, 0x00, 0x32, 0xFE, 0x81, 0xB0, 0x8A, 0x81, 0x80, 0xBF, 0xD0, 0xB0,
  0xDC, 0x0D, 0x0B, 0x80, 0xF6, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_activity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_activity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_airport 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_sharp_24_maps_local_airport_data[] PROGMEM = {
  0x71, 0x82, 0x2D, 0xD2, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07,
  0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x10, 0x60, 0xEA,
  0x0E, 0x06, 0x75, 0x03, 0x0C, 0xE0, 0xC0, 0x37, 0x10, 0x10, 0x9F, 0xB0, 0x90, 0x15, 0x07, 0x0E,
  0xFD, 0x0E, 0x07, 0x20, 0x40, 0xDD, 0x00, 0xCA, 0x00, 0xCD, 0x0D, 0x04, 0xB8, 0x4E, 0xA5, 0x10,
  0x7A, 0x84, 0x70, 0x15, 0xAE, 0xB8, 0x1D, 0x84, 0x50, 0x7A, 0x07, 0x58, 0x14, 0x8D, 0x71, 0x07,
  0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x71, 0x06, 0x0E, 0xA0, 0xE0, 0x67,
  0x60, 0xCE, 0x0C, 0x75, 0x86, 0xD9, 0x51, 0x15, 0x9D, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_airport() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_airport_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_atm 24x24, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_sharp_24_maps_local_atm_data[] PROGMEM = {
  0x80, 0xC6, 0xF7, 0x72, 0xC7, 0xA7, 0xC5, 0xE5, 0xC5, 0xE5, 0xC5, 0xA7, 0x2C, 0x5E, 0x5C, 0x5E,
  0x5C, 0x72, 0xA5, 0xC5, 0xE5, 0xC5, 0xE5, 0xC7, 0xA7, 0xC7, 0x72, 0x80, 0xC6, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_atm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_atm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_bar 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_sharp_24_maps_local_bar_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x28, 0xFE, 0x27, 0x38, 0x72, 0xEF, 0x80, 0xAF, 0xD1, 0x71, 0x82, 0x1D, 0xFA,
  0x30, 0xBF, 0xD0, 0xB4, 0x01, 0x0C, 0xFB, 0x0C, 0x01, 0x50, 0x10, 0xDF, 0x90, 0xD0, 0x17, 0x02,
  0x0E, 0xE0, 0xE0, 0x27, 0x20, 0x3E, 0x03, 0x74, 0x05, 0xC0, 0x57, 0x60, 0x6A, 0x06, 0x77, 0x1A,
  0x77, 0x2A, 0x77, 0x2A, 0x77, 0x2A, 0x77, 0x2A, 0x74, 0xFD, 0x6F, 0xD3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_cafe 24x24, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_sharp_24_maps_local_cafe_data[] PROGMEM = {
  0x2F, 0xFA, 0x0D, 0x04, 0x2F, 0xFB, 0x0D, 0x2F, 0xF2, 0xA2, 0xFF, 0x2A, 0x2F, 0xF2, 0xA2, 0xFF,
  0xB0, 0xD2, 0xFF, 0xA0, 0xD0, 0x42, 0xFF, 0x6F, 0xF6, 0xFF, 0x6F, 0xF6, 0xFF, 0x6F, 0xF6, 0xFF,
  0x80, 0xD0, 0x0F, 0xFC, 0x2F, 0xFC, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_cafe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_cafe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_car_wash 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_24_maps_local_car_wash_data[] PROGMEM = {
  0x30, 0x08, 0x30, 0x08, 0x30, 0x08, 0x50, 0x2A, 0x81, 0x20, 0x2A, 0x81, 0x20, 0x2A, 0x02, 0x40,
  0x6A, 0x81, 0x60, 0x6A, 0x81, 0x60, 0x6A, 0x06, 0x48, 0x94, 0x2D, 0xD2, 0x02, 0xDD, 0x20, 0x2D,
  0xD2, 0x80, 0xC4, 0x00, 0xBF, 0xD0, 0xB3, 0x81, 0x1F, 0xA8, 0x06, 0x78, 0x1A, 0xF1, 0x28, 0x16,
  0xF2, 0x73, 0x81, 0x2F, 0x62, 0x00, 0xC7, 0x58, 0x4C, 0xC0, 0x2F, 0x77, 0x58, 0x47, 0xF2, 0x7F,
  0x27, 0x58, 0x22, 0xF7, 0xCF, 0xFA, 0x0C, 0xFF, 0xE8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x7C, 0x3F,
  0x93, 0xC8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x78, 0x0E, 0x7F, 0x75, 0xE7, 0x5B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_car_wash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_car_wash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_convenience_store 24x24, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_sharp_24_maps_local_convenience_store_data[] PROGMEM = {
  0x3F, 0xF6, 0xFF, 0x6F, 0xF3, 0xE3, 0xA1, 0x91, 0xFF, 0x1A, 0x19, 0x1F, 0xD3, 0xA3, 0xFD, 0x1E,
  0x1F, 0xD3, 0xC1, 0x80, 0x9B, 0x2F, 0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_convenience_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_convenience_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_dining 24x24, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_sharp_24_maps_local_dining_data[] PROGMEM = {
  0x10, 0x01, 0x74, 0x83, 0x49, 0xCA, 0x32, 0x81, 0xBC, 0x17, 0x20, 0x9D, 0x04, 0x01, 0xA0, 0xC0,
  0x17, 0x0A, 0xE0, 0xB0, 0x3B, 0x0C, 0x01, 0x50, 0x4F, 0x0C, 0x1C, 0x0C, 0x01, 0x40, 0xAF, 0x81,
  0x90, 0x8C, 0x0C, 0x01, 0x30, 0xCF, 0x04, 0x20, 0xBC, 0x0C, 0x01, 0x20, 0xAE, 0x09, 0x40, 0xBC,
  0x82, 0xA0, 0x1D, 0xD0, 0xA6, 0x0B, 0xA8, 0x90, 0xD1, 0x1D, 0xFC, 0xAC, 0xA4, 0x71, 0x86, 0xBD,
  0x11, 0xDF, 0xC1, 0x76, 0x81, 0x11, 0xDA, 0x0C, 0x01, 0x76, 0x86, 0x1D, 0xFC, 0xCF, 0xC1, 0x74,
  0x89, 0x01, 0xDF, 0xC1, 0x1C, 0xFC, 0x17, 0x28, 0x31, 0xDF, 0xC1, 0x28, 0x31, 0xCF, 0xC1, 0x78,
  0x31, 0xDF, 0xC1, 0x48, 0x31, 0xCF, 0xC1, 0x58, 0x31, 0xDF, 0xC1, 0x68, 0x31, 0xCF, 0xC1, 0x38,
  0x31, 0xDF, 0xC1, 0x71, 0x83, 0x1C, 0xFC, 0x13, 0x81, 0xAC, 0x17, 0x38, 0x11, 0xCA, 0x50, 0x17,
  0x50, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_drink 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_sharp_24_maps_local_drink_data[] PROGMEM = {
  0x0E, 0xFF, 0xA0, 0xE0, 0xCF, 0xFA, 0x82, 0xCB, 0xF4, 0x75, 0x84, 0x4F, 0xB9, 0xF6, 0x75, 0x84,
  0x6F, 0x97, 0xF7, 0x75, 0x84, 0x7F, 0x76, 0xF9, 0x75, 0x82, 0x9F, 0x64, 0xFF, 0xA0, 0x40, 0x2F,
  0xFA, 0x02, 0x1F, 0x00, 0xEF, 0x81, 0x10, 0xEE, 0x00, 0x4E, 0x0E, 0x20, 0xDD, 0x08, 0x20, 0x8D,
  0x0D, 0x20, 0xBC, 0x0D, 0x40, 0xDC, 0x0B, 0x20, 0x9C, 0x06, 0x40, 0x6C, 0x09, 0x20, 0x7C, 0x02,
  0x40, 0x1C, 0x07, 0x20, 0x6C, 0x01, 0x40, 0x1C, 0x06, 0x20, 0x4C, 0x07, 0x40, 0x7C, 0x04, 0x20,
  0x2D, 0x82, 0x71, 0x17, 0xD0, 0x22, 0x01, 0xFF, 0x01, 0x30, 0xEF, 0xD0, 0xE4, 0x0D, 0xFD, 0x0D,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_drink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_drink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_fire_department 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_sharp_24_maps_local_fire_department_data[] PROGMEM = {
  0x60, 0x20, 0xB7, 0x60, 0x50, 0xE9, 0x75, 0x08, 0xB7, 0x40, 0x9C, 0x73, 0x07, 0xD0, 0x72, 0x07,
  0x0A, 0x40, 0x3F, 0x00, 0xCA, 0x0C, 0x30, 0xCF, 0xD8, 0x19, 0x03, 0xFF, 0x02, 0x09, 0xE0, 0x09,
  0xE0, 0x90, 0xDD, 0x08, 0x20, 0x8D, 0x0C, 0x0E, 0xC0, 0x84, 0x08, 0xC0, 0x0E, 0xB0, 0x82, 0x00,
  0x92, 0x08, 0xB0, 0xD0, 0xCA, 0x0B, 0x20, 0x9A, 0x09, 0x20, 0xBA, 0x0C, 0x08, 0xA8, 0x14, 0x07,
  0xC8, 0x17, 0x04, 0xA0, 0x80, 0x2A, 0x20, 0xDC, 0x0D, 0x2A, 0x85, 0x20, 0x8F, 0x10, 0xEC, 0x83,
  0xE0, 0x1F, 0x83, 0x82, 0xB4, 0x08, 0xC8, 0x28, 0x03, 0xB5, 0x04, 0x28, 0x28, 0xEE, 0x82, 0x04,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_fire_department() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_fire_department_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_florist 24x24, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_sharp_24_maps_local_florist_data[] PROGMEM = {
  0x78, 0x26, 0xDD, 0x67, 0x60, 0x3C, 0x03, 0x72, 0x82, 0x29, 0xAA, 0xC8, 0x2A, 0xA9, 0x25, 0x01,
  0x0E, 0xFB, 0x0E, 0x01, 0x40, 0x5C, 0x82, 0xE9, 0x9E, 0xC0, 0x54, 0x03, 0xB0, 0xE0, 0x22, 0x02,
  0x0E, 0xB0, 0x35, 0x09, 0xA0, 0x94, 0x09, 0xA0, 0x96, 0x09, 0xA0, 0x94, 0x09, 0xA0, 0x95, 0x03,
  0xB0, 0xE0, 0x22, 0x02, 0x0E, 0xB0, 0x34, 0x05, 0xC8, 0x2E, 0x99, 0xEC, 0x05, 0x40, 0x10, 0xEF,
  0xB0, 0xE0, 0x15, 0x82, 0x29, 0xAA, 0xC8, 0x2A, 0xA9, 0x23, 0x82, 0xDD, 0x94, 0x20, 0x3C, 0x03,
  0x20, 0x40, 0x90, 0xFD, 0xB8, 0x90, 0xB2, 0x06, 0xDD, 0x60, 0x2B, 0xB0, 0xD0, 0x9C, 0x0E, 0x03,
  0x40, 0x30, 0xEC, 0x09, 0x04, 0xD0, 0xE0, 0x22, 0x02, 0x0E, 0xD8, 0x14, 0x0B, 0xD0, 0xB2, 0x0B,
  0xD0, 0xB2, 0x02, 0x0E, 0xD0, 0x04, 0xD0, 0xE0, 0x23, 0x03, 0x0E, 0xC0, 0x09, 0xC0, 0xE0, 0x35,
  0x02, 0x0B, 0xB0, 0x0D, 0xB0, 0xB0, 0x27, 0x18, 0x64, 0x9D, 0xDD, 0xD9, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_florist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_florist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_gas_station 24x24, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_sharp_24_maps_local_gas_station_data[] PROGMEM = {
  0xFB, 0x10, 0x10, 0x24, 0xFB, 0x18, 0x1B, 0xD2, 0x3A, 0x6A, 0x18, 0x22, 0xDD, 0x22, 0xA6, 0xA2,
  0x82, 0x3F, 0xD2, 0x1A, 0x6A, 0x10, 0x10, 0xDA, 0x0D, 0x1A, 0x6A, 0x18, 0x46, 0xF3, 0x3F, 0x6A,
  0x6A, 0x18, 0x46, 0xF3, 0x3F, 0x7F, 0xB1, 0x01, 0x0D, 0xB0, 0x7F, 0xB2, 0x83, 0x16, 0x6F, 0x7F,
  0xE2, 0x90, 0x7F, 0xB0, 0x70, 0xB9, 0x29, 0x07, 0xFB, 0x10, 0x79, 0x29, 0x07, 0xFB, 0x10, 0x79,
  0x29, 0x07, 0xFB, 0x10, 0x79, 0x29, 0x07, 0xFB, 0x10, 0x79, 0x29, 0x07, 0xFB, 0x10, 0x79, 0x29,
  0x07, 0xFB, 0x18, 0x47, 0xF7, 0x7F, 0x7F, 0xB1, 0x07, 0xC0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_gas_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_gas_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_grocery_store 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_sharp_24_maps_local_grocery_store_data[] PROGMEM = {
  0xB0, 0x77, 0x73, 0xB0, 0xE7, 0x75, 0x0B, 0xFF, 0xB0, 0x62, 0x04, 0xFF, 0xA0, 0xD4, 0x0C, 0xFF,
  0x90, 0x54, 0x05, 0xFF, 0x0B, 0x60, 0xDF, 0xE0, 0x36, 0x06, 0xFD, 0x0A, 0x71, 0x0D, 0xFC, 0x02,
  0x71, 0x08, 0xFB, 0x08, 0x72, 0x0D, 0xFA, 0x0E, 0x01, 0x71, 0x81, 0x7F, 0xC7, 0x73, 0x82, 0x1E,
  0xF4, 0x77, 0x30, 0x8F, 0xF5, 0x02, 0xFF, 0x97, 0x77, 0x78, 0x24, 0xDD, 0x46, 0x82, 0x4D, 0xD4,
  0x70, 0xDA, 0x0D, 0x60, 0xDA, 0x0D, 0x70, 0xDA, 0x0D, 0x60, 0xDA, 0x0D, 0x78, 0x24, 0xDD, 0x46,
  0x82, 0x4D, 0xD4, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_grocery_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_grocery_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_hospital 24x24, 4-bit Alpha,  RLE, 23 bytes.
static const unsigned char ic_sharp_24_maps_local_hospital_data[] PROGMEM = {
  0x80, 0xF1, 0xF4, 0xFF, 0x4F, 0xF4, 0xFF, 0x4F, 0xB7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xFB, 0x4F,
  0xF4, 0xFF, 0x4F, 0xF4, 0x80, 0xF1, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_hospital() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_hospital_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_hotel 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_sharp_24_maps_local_hotel_data[] PROGMEM = {
  0xA7, 0x76, 0xA7, 0x76, 0xA2, 0x82, 0x8D, 0xD8, 0x2F, 0xF1, 0x08, 0xC0, 0x81, 0xFF, 0x10, 0xDC,
  0x0D, 0x1F, 0xF1, 0x0D, 0xC0, 0xD1, 0xFF, 0x10, 0x8C, 0x08, 0x1F, 0xF2, 0x82, 0x8D, 0xD8, 0x2F,
  0xF7, 0x18, 0x09, 0x94, 0xF7, 0x74, 0xC7, 0x74, 0xC7, 0x74, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_hotel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_hotel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_laundry_service 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_24_maps_local_laundry_service_data[] PROGMEM = {
  0xFF, 0xFF, 0xE8, 0x33, 0x3F, 0x33, 0xFC, 0x83, 0x33, 0xF3, 0x38, 0x0D, 0x2F, 0x08, 0x03, 0x20,
  0x30, 0x8F, 0x90, 0xD0, 0x26, 0x02, 0x0D, 0xE0, 0x27, 0x10, 0x2D, 0x08, 0x78, 0x27, 0x10, 0x8C,
  0x03, 0x68, 0x37, 0xFA, 0x03, 0xC6, 0x07, 0xA0, 0xD2, 0xC5, 0x07, 0xB0, 0xD2, 0xC0, 0x33, 0x07,
  0xC8, 0x1A, 0x03, 0xC0, 0x82, 0x07, 0xC8, 0x2E, 0x10, 0x8D, 0x89, 0x02, 0x01, 0xAE, 0xEA, 0x10,
  0x2E, 0x0D, 0x02, 0x60, 0x20, 0xDF, 0x90, 0x80, 0x32, 0x03, 0x08, 0x80, 0xC1, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_laundry_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_laundry_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_library 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_24_maps_local_library_data[] PROGMEM = {
  0x78, 0x28, 0xDD, 0x87, 0x60, 0x8C, 0x08, 0x75, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x75, 0x08,
  0xC0, 0x87, 0x68, 0x28, 0xDD, 0x87, 0x83, 0xED, 0xB7, 0x27, 0x18, 0x32, 0x7B, 0xDE, 0xD0, 0xB0,
  0x34, 0x03, 0x0B, 0xFD, 0x09, 0x20, 0x9F, 0xF9, 0x00, 0xC8, 0x0A, 0x82, 0xF1, 0x82, 0x24, 0x8C,
  0xF9, 0x82, 0xC8, 0x42, 0x60, 0x30, 0xBC, 0x0B, 0x03, 0x75, 0x05, 0xA0, 0x67, 0x71, 0x00, 0x37,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_mall 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_sharp_24_maps_local_mall_data[] PROGMEM = {
  0x68, 0x44, 0xBE, 0xEB, 0x47, 0x40, 0x8E, 0x08, 0x72, 0x04, 0xA8, 0x27, 0x11, 0x7A, 0x04, 0x71,
  0x81, 0xBF, 0x74, 0x81, 0x7F, 0xB7, 0x18, 0x1E, 0xF1, 0x48, 0x11, 0xFE, 0x48, 0x0C, 0x4F, 0x20,
  0xDC, 0x0D, 0x2F, 0x98, 0x13, 0x08, 0xC8, 0x18, 0x03, 0xF9, 0x0A, 0x28, 0x28, 0xDD, 0x82, 0x0A,
  0xFA, 0x07, 0x60, 0x7F, 0xC0, 0xA0, 0x32, 0x03, 0x0A, 0x80, 0xAC, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_mall() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_mall_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_movies 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_maps_local_movies_data[] PROGMEM = {
  0xA2, 0xF9, 0x2C, 0x2F, 0x92, 0x80, 0xC0, 0xF2, 0xF9, 0x2C, 0x2F, 0x92, 0x80, 0xC0, 0xF2, 0xF9,
  0x2C, 0x2F, 0x92, 0x80, 0xC0, 0xF2, 0xF9, 0x2C, 0x2F, 0x92, 0x80, 0xC0, 0xF2, 0xF9, 0x2C, 0x2F,
  0x92, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_movies() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_movies_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_offer 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_sharp_24_maps_local_offer_data[] PROGMEM = {
  0xFB, 0x05, 0x73, 0xFC, 0x05, 0x72, 0xA8, 0x17, 0x07, 0xF0, 0x57, 0x1A, 0x3F, 0x90, 0x57, 0xA8,
  0x17, 0x07, 0xFA, 0x05, 0x6F, 0xF9, 0x05, 0x5F, 0xFA, 0x05, 0x4F, 0xFB, 0x05, 0x3F, 0xFC, 0x05,
  0x2F, 0xFD, 0x81, 0x50, 0x5F, 0xFD, 0x81, 0x50, 0x5F, 0xFC, 0x05, 0x20, 0x5F, 0xFA, 0x05, 0x40,
  0x5F, 0xF0, 0x56, 0x05, 0xFD, 0x05, 0x71, 0x05, 0xFB, 0x05, 0x73, 0x05, 0xF9, 0x05, 0x75, 0x05,
  0xE0, 0x57, 0x70, 0x5C, 0x05, 0x77, 0x20, 0x5A, 0x05, 0x77, 0x40, 0x05, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_offer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_offer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_parking 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_sharp_24_maps_local_parking_data[] PROGMEM = {
  0xF8, 0x1E, 0xC6, 0x3F, 0xB0, 0xC0, 0x11, 0xFC, 0x0C, 0x1F, 0xD0, 0x6C, 0x40, 0x8B, 0x0C, 0xC5,
  0x0E, 0xA0, 0xEC, 0x50, 0xEA, 0x0E, 0xC4, 0x08, 0xB0, 0xCF, 0xD0, 0x6F, 0xC0, 0xC1, 0xFB, 0x0C,
  0x01, 0x1F, 0x81, 0xEC, 0x63, 0xC7, 0x2C, 0x72, 0xC7, 0x2C, 0x72, 0xC7, 0x2C, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_parking() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 18, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_parking_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_pharmacy 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_sharp_24_maps_local_pharmacy_data[] PROGMEM = {
  0x76, 0x82, 0x1D, 0x71, 0x77, 0x06, 0xA0, 0x47, 0x78, 0x1B, 0xFD, 0x77, 0x02, 0xA0, 0x82, 0x80,
  0xC0, 0xF0, 0xCF, 0xFA, 0x0C, 0x07, 0xFF, 0xA0, 0x70, 0x2F, 0x2F, 0x81, 0x20, 0xCE, 0x2E, 0x0C,
  0x20, 0x7E, 0x2E, 0x07, 0x20, 0x2B, 0x71, 0xB0, 0x22, 0x02, 0xB7, 0x1B, 0x02, 0x20, 0x7E, 0x2E,
  0x07, 0x20, 0xCE, 0x2E, 0x81, 0xC0, 0x2F, 0x2F, 0x02, 0x07, 0xFF, 0xA0, 0x70, 0xCF, 0xFA, 0x0C,
  0x80, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_pharmacy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_pharmacy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_phone 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_maps_local_phone_data[] PROGMEM = {
  0xD0, 0x97, 0x5D, 0x0B, 0x75, 0x0E, 0xC0, 0xC7, 0x50, 0xCC, 0x0E, 0x75, 0x09, 0xD0, 0x17, 0x40,
  0x5C, 0x0C, 0x75, 0x01, 0xB0, 0xC0, 0x17, 0x68, 0x2A, 0xFD, 0x17, 0x78, 0x23, 0xFE, 0x17, 0x71,
  0x81, 0xAF, 0xA7, 0x71, 0x82, 0x2E, 0xF7, 0x77, 0x10, 0x5A, 0x05, 0x77, 0x10, 0x7A, 0x07, 0x38,
  0x51, 0xCF, 0xEC, 0xB9, 0x50, 0x7A, 0x82, 0xA1, 0x1C, 0xE6, 0x83, 0x5E, 0xFE, 0xDF, 0x70, 0x20,
  0xAF, 0xA7, 0x20, 0x30, 0xAF, 0x74, 0x83, 0x15, 0x9C, 0xEA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_pizza 24x24, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_sharp_24_maps_local_pizza_data[] PROGMEM = {
  0x48, 0x90, 0x16, 0xBD, 0xEE, 0xDB, 0x61, 0x60, 0x10, 0x9F, 0xB0, 0x90, 0x13, 0x05, 0x0E, 0xFD,
  0x82, 0xE5, 0x06, 0xB8, 0x2B, 0x11, 0xBF, 0xA0, 0x60, 0xBB, 0x01, 0x20, 0x1F, 0xA0, 0xB0, 0x2B,
  0x01, 0x20, 0x1F, 0xA8, 0x12, 0x09, 0xA8, 0x2B, 0x11, 0xBF, 0x90, 0x92, 0x01, 0x0E, 0xFD, 0x0E,
  0x01, 0x30, 0x7F, 0xD0, 0x75, 0x0D, 0xB8, 0x2B, 0x11, 0xBB, 0x0D, 0x60, 0x5B, 0x01, 0x20, 0x1B,
  0x05, 0x70, 0xBA, 0x01, 0x20, 0x1A, 0x0B, 0x71, 0x03, 0xA8, 0x2B, 0x11, 0xBA, 0x03, 0x72, 0x0A,
  0xE0, 0xA7, 0x30, 0x1E, 0x01, 0x74, 0x08, 0xC0, 0x87, 0x60, 0xEA, 0x0E, 0x77, 0x06, 0xA0, 0x67,
  0x71, 0x00, 0xC7, 0x72, 0x00, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_pizza() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_pizza_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_play 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_24_maps_local_play_data[] PROGMEM = {
  0x80, 0xD5, 0xF0, 0x0B, 0xFF, 0xC0, 0x05, 0xFF, 0xB0, 0xE2, 0x0E, 0xFE, 0x82, 0xDD, 0xC6, 0x28,
  0x27, 0xCD, 0xED, 0x01, 0x0B, 0xA0, 0xB0, 0x17, 0x10, 0x10, 0xBA, 0x82, 0xB1, 0x01, 0xB0, 0xD0,
  0x26, 0x02, 0x0D, 0xB0, 0x12, 0x01, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC8, 0x21, 0x01, 0xBD, 0x04,
  0x40, 0x4D, 0x0B, 0x01, 0xF2, 0x00, 0x32, 0xFE, 0x81, 0xB0, 0x8A, 0x81, 0x80, 0xBF, 0xD0, 0xB0,
  0xDC, 0x0D, 0x0B, 0x80, 0xF6, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_police 24x24, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_sharp_24_maps_local_police_data[] PROGMEM = {
  0x78, 0x25, 0xCC, 0x57, 0x50, 0x60, 0xDC, 0x0D, 0x06, 0x78, 0x11, 0x8E, 0xF9, 0x81, 0xE8, 0x12,
  0x03, 0x0A, 0xFF, 0x0A, 0x03, 0xFF, 0xFD, 0x00, 0xCF, 0xFA, 0x00, 0x5F, 0xF9, 0x0E, 0x20, 0xEF,
  0xC8, 0x2E, 0xDB, 0x62, 0x82, 0x6B, 0xCD, 0xF0, 0xD0, 0x27, 0x10, 0x20, 0xDB, 0x0E, 0xB0, 0xE0,
  0x46, 0x04, 0x0E, 0xB0, 0xE0, 0xDD, 0x04, 0x40, 0x4D, 0x0D, 0x0B, 0xD0, 0x44, 0x04, 0xD0, 0xB0,
  0x7D, 0x84, 0x10, 0x44, 0x01, 0xD0, 0x70, 0x2C, 0x81, 0xC1, 0xAA, 0x81, 0xA1, 0xCC, 0x81, 0x20,
  0xAB, 0x0D, 0x0E, 0xC0, 0xE0, 0xDB, 0x0A, 0x20, 0x2F, 0xF0, 0x23, 0x07, 0xFD, 0x07, 0x50, 0xAF,
  0xB0, 0xA7, 0x09, 0xF9, 0x09, 0x72, 0x06, 0x0E, 0xC0, 0xE0, 0x67, 0x48, 0x41, 0x7C, 0xC7, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_police() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_police_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_post_office 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_sharp_24_maps_local_post_office_data[] PROGMEM = {
  0x80, 0xC6, 0xF0, 0x40, 0xDF, 0xD0, 0xD0, 0x4C, 0x20, 0x8F, 0xB0, 0x82, 0xC8, 0x3A, 0x10, 0x3C,
  0xE8, 0x3C, 0x30, 0x1A, 0xD0, 0xE0, 0x62, 0x06, 0x0E, 0xA0, 0xE0, 0x62, 0x06, 0x0E, 0xF9, 0x89,
  0x0C, 0x30, 0x1A, 0xA1, 0x03, 0xCF, 0xD0, 0x84, 0x08, 0xFF, 0x98, 0x2D, 0x44, 0xD8, 0x0A, 0xA0,
  0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_post_office() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_post_office_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_printshop 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_sharp_24_maps_local_printshop_data[] PROGMEM = {
  0x4F, 0xD7, 0x1F, 0xD7, 0x1F, 0xD7, 0x1F, 0xD7, 0x77, 0x38, 0x0E, 0x4F, 0x00, 0x3F, 0xFC, 0x00,
  0x38, 0x0D, 0x4F, 0x71, 0xFD, 0x71, 0xFD, 0x71, 0xE4, 0xA7, 0x1A, 0x71, 0xA7, 0x1A, 0x71, 0xFD,
  0x71, 0xFD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_printshop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_printshop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_see 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_24_maps_local_see_data[] PROGMEM = {
  0x60, 0x7E, 0x07, 0x74, 0x05, 0xF9, 0x05, 0x58, 0x0F, 0x7F, 0x0A, 0x03, 0x20, 0x30, 0xAF, 0xE0,
  0x72, 0x00, 0x12, 0x07, 0xFC, 0x82, 0xA0, 0x1B, 0xA8, 0x2B, 0x10, 0xAF, 0xB8, 0x13, 0x0B, 0xC8,
  0x1B, 0x03, 0xFB, 0x10, 0x1E, 0x01, 0x1F, 0xB1, 0x01, 0xE0, 0x11, 0xFB, 0x81, 0x30, 0xBC, 0x81,
  0xB0, 0x3F, 0xB8, 0x2A, 0x01, 0xBA, 0x82, 0xB1, 0x0A, 0xFC, 0x07, 0x20, 0x01, 0x20, 0x7F, 0xE0,
  0xA0, 0x32, 0x03, 0x0A, 0x80, 0xF7, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_see() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_see_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_shipping 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_24_maps_local_shipping_data[] PROGMEM = {
  0xFF, 0xA6, 0xFF, 0xA6, 0xFF, 0xA6, 0xFF, 0xA6, 0xFF, 0xD0, 0x52, 0xFF, 0xA8, 0x37, 0x7A, 0xE2,
  0x1F, 0xFA, 0x30, 0xB0, 0xC1, 0xFF, 0xA3, 0x81, 0x1D, 0x98, 0x09, 0xB0, 0xF0, 0x03, 0xFB, 0x00,
  0x3C, 0x28, 0x4D, 0xF3, 0x3F, 0xD6, 0x84, 0xDF, 0x33, 0xFD, 0x40, 0x8C, 0x08, 0x60, 0x8C, 0x08,
  0x58, 0x28, 0xDD, 0x87, 0x18, 0x28, 0xDD, 0x83,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_shipping() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_shipping_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_local_taxi 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_maps_local_taxi_data[] PROGMEM = {
  0x6E, 0x75, 0xE7, 0x10, 0xBF, 0xD0, 0xB3, 0x81, 0x1F, 0xA8, 0x06, 0x78, 0x1A, 0xF1, 0x28, 0x16,
  0xF2, 0x73, 0x81, 0x2F, 0x62, 0x00, 0xC7, 0x58, 0x4C, 0xC0, 0x2F, 0x77, 0x58, 0x47, 0xF2, 0x7F,
  0x27, 0x58, 0x22, 0xF7, 0xCF, 0xFA, 0x0C, 0xFF, 0xE8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x7C, 0x3F,
  0x93, 0xC8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x78, 0x0E, 0x7F, 0x75, 0xE7, 0x5B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_local_taxi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_local_taxi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_lunch_dining 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_24_maps_lunch_dining_data[] PROGMEM = {
  0x48, 0x33, 0x7A, 0xCE, 0xA8, 0x3E, 0xDA, 0x73, 0x60, 0x30, 0xCF, 0xD0, 0xC0, 0x33, 0x07, 0xFF,
  0xA8, 0x17, 0x04, 0xFF, 0xC0, 0x40, 0xBF, 0xFC, 0x0B, 0x0E, 0xFF, 0xC0, 0xEF, 0xFE, 0x77, 0x78,
  0x21, 0x57, 0x43, 0x82, 0x36, 0x73, 0x38, 0x54, 0x75, 0x10, 0x9E, 0xB8, 0x1D, 0x8B, 0xC8, 0x1B,
  0x8D, 0xB0, 0xE0, 0x9A, 0x81, 0xB8, 0xDB, 0x82, 0xE9, 0x9E, 0xB8, 0x1D, 0x8B, 0xA0, 0x60, 0x33,
  0x82, 0x47, 0x51, 0x28, 0x21, 0x67, 0x43, 0x02, 0x07, 0x77, 0x68, 0x09, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_lunch_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_lunch_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_map 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_sharp_24_maps_map_data[] PROGMEM = {
  0x77, 0x30, 0x13, 0x84, 0x27, 0xCC, 0x71, 0x68, 0x44, 0xAF, 0x27, 0xCE, 0x84, 0xB6, 0x11, 0x7D,
  0xFA, 0x81, 0x49, 0xEF, 0xF9, 0x30, 0x50, 0xAF, 0xE5, 0x01, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6,
  0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x01, 0x5F, 0xE0, 0xA0, 0x53, 0xFF, 0x98, 0x1E, 0x94,
  0xFA, 0x84, 0xD7, 0x11, 0x6B, 0xE8, 0x4C, 0x72, 0xE9, 0x36, 0x84, 0x17, 0xCC, 0x72, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_map_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_maps_ugc 24x24, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_sharp_24_maps_maps_ugc_data[] PROGMEM = {
  0x78, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x10, 0x8A, 0x81, 0xC6,
  0x22, 0x81, 0x26, 0xCA, 0x08, 0x60, 0x8A, 0x06, 0x71, 0x06, 0xA0, 0x84, 0x04, 0xA0, 0x47, 0x30,
  0x4A, 0x04, 0x38, 0x1D, 0xF6, 0x75, 0x81, 0x6F, 0xD2, 0x81, 0x5F, 0xC6, 0xA6, 0x85, 0xCF, 0x50,
  0x9F, 0x66, 0xA6, 0x85, 0x6F, 0x90, 0xDF, 0x26, 0xA6, 0x83, 0x2F, 0xD0, 0xE9, 0x4F, 0x94, 0x98,
  0x1E, 0x0E, 0x94, 0xF9, 0x49, 0x83, 0xE0, 0xCF, 0x26, 0xA6, 0x85, 0x2F, 0xD0, 0x9F, 0x76, 0xA6,
  0x85, 0x6F, 0x90, 0x4F, 0xC6, 0xA6, 0x85, 0xCF, 0x50, 0x1F, 0xE7, 0x68, 0x16, 0xFD, 0x28, 0x15,
  0xFA, 0x75, 0x04, 0xA0, 0x42, 0x81, 0xAF, 0x67, 0x40, 0x6A, 0x08, 0x38, 0x7E, 0xF3, 0x6A, 0xEC,
  0x72, 0x28, 0x12, 0x6C, 0xA0, 0x83, 0x04, 0xFF, 0x0D, 0x04, 0x40, 0x8A, 0x89, 0x2E, 0xA5, 0x14,
  0x9C, 0xEE, 0xD9, 0x56, 0x81, 0xB8, 0x47, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_maps_ugc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_maps_ugc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_medical_information 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_sharp_24_maps_medical_information_data[] PROGMEM = {
  0x7E, 0x77, 0xE7, 0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x7A, 0x2A, 0x7F, 0xA2, 0xFF, 0xC2, 0x80, 0x98,
  0x6F, 0x2F, 0xFC, 0x2C, 0x6E, 0x6A, 0x80, 0x27, 0xE6, 0xFF, 0xA2, 0xC4, 0xFB, 0x2C, 0x80, 0x07,
  0x80, 0x9A, 0x1F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_medical_information() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_medical_information_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_medical_services 24x24, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_sharp_24_maps_medical_services_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5A, 0x4A, 0x75, 0xA4, 0xA6, 0x80, 0x9A, 0x5F, 0x2F, 0xFC, 0x2F, 0xFC,
  0x2F, 0xF9, 0x71, 0xFD, 0x71, 0xFF, 0x92, 0xFF, 0xC2, 0xFF, 0xC2, 0x80, 0x9A, 0x5F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_medical_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_medical_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_menu_book 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_sharp_24_maps_menu_book_data[] PROGMEM = {
  0x28, 0x51, 0x57, 0x75, 0x41, 0x48, 0x51, 0x57, 0x76, 0x51, 0x20, 0x40, 0xCF, 0x82, 0xC4, 0x4C,
  0xF0, 0xC0, 0x4F, 0xE8, 0x5E, 0xB9, 0x78, 0xAD, 0xFE, 0x0B, 0x04, 0x7F, 0xE7, 0x2F, 0xE1, 0x85,
  0x49, 0xCD, 0xFD, 0xC1, 0xFE, 0x19, 0x84, 0xDA, 0x87, 0x8A, 0x1F, 0xE1, 0x85, 0x40, 0x23, 0x53,
  0x21, 0xFE, 0x10, 0xA0, 0xED, 0x1F, 0xE1, 0x85, 0xD8, 0x53, 0x13, 0x51, 0xFE, 0x28, 0x44, 0x79,
  0x98, 0x71, 0xFE, 0x10, 0xEA, 0x0F, 0xD9, 0x1F, 0xE1, 0x09, 0x03, 0x6F, 0xE7, 0x2F, 0xE1, 0x86,
  0x38, 0xBE, 0xFE, 0xC9, 0xFE, 0x0B, 0xFC, 0x82, 0xA5, 0x31, 0x28, 0x12, 0x5A, 0xA8, 0x91, 0xA5,
  0x31, 0x01, 0x26, 0xAF, 0x37, 0x20, 0x03, 0x72, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_menu_book() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_menu_book_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_merge 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_24_maps_merge_data[] PROGMEM = {
  0x60, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x20, 0x7C, 0x07, 0x70, 0x7E, 0x07, 0x68, 0x17, 0xF5, 0xA8,
  0x15, 0xF7, 0x70, 0x21, 0xA1, 0x02, 0x73, 0xA7, 0x5A, 0x75, 0xA7, 0x40, 0x1A, 0x01, 0x73, 0x05,
  0xA0, 0x57, 0x20, 0x10, 0xDA, 0x0E, 0x01, 0x78, 0x61, 0xCF, 0xCC, 0xFC, 0x15, 0x89, 0x01, 0xCF,
  0xC1, 0x1C, 0xFC, 0x13, 0x83, 0x1C, 0xFC, 0x12, 0x89, 0x11, 0xCF, 0xC1, 0x01, 0xCF, 0xC1, 0x48,
  0x71, 0xCF, 0xC1, 0xBF, 0xC1, 0x68, 0x51, 0xCF, 0xB2, 0xB1, 0x71, 0x81, 0x1B, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_minor_crash 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_24_maps_minor_crash_data[] PROGMEM = {
  0x71, 0xA7, 0x72, 0xA7, 0x38, 0x12, 0xB1, 0x3A, 0x38, 0x11, 0xB2, 0x48, 0x2B, 0xFC, 0x12, 0xA2,
  0x82, 0x1C, 0xFB, 0x48, 0x31, 0xCF, 0xC1, 0x1A, 0x18, 0x31, 0xCF, 0xC1, 0x58, 0x21, 0xCC, 0x14,
  0x82, 0x1C, 0xC1, 0x70, 0x01, 0x60, 0x01, 0x77, 0x73, 0x0B, 0xFD, 0x0B, 0x30, 0x1F, 0xF0, 0x12,
  0x81, 0x6F, 0xA7, 0x38, 0x1A, 0xF6, 0x28, 0x1C, 0xF5, 0x73, 0x85, 0x5F, 0xC0, 0x2F, 0xE7, 0x58,
  0x2E, 0xF2, 0x7F, 0xFA, 0x07, 0x0C, 0xFF, 0xA0, 0xCF, 0xFF, 0x81, 0x70, 0x7E, 0x81, 0x70, 0x7E,
  0x3E, 0x3E, 0x81, 0x70, 0x7E, 0x81, 0x70, 0x78, 0x0F, 0x0F, 0x75, 0xE7, 0x5B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_minor_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 20, 23), Box(0, 0, 23, 23),
      ic_sharp_24_maps_minor_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_miscellaneous_services 24x24, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_sharp_24_maps_miscellaneous_services_data[] PROGMEM = {
  0x50, 0xEA, 0x09, 0x77, 0x10, 0x1B, 0x0B, 0x75, 0x82, 0x99, 0x4A, 0xB8, 0x3E, 0x65, 0xB4, 0x70,
  0x3F, 0xC0, 0xD7, 0x0C, 0xFD, 0x06, 0x60, 0x7C, 0x82, 0x81, 0x2C, 0xB0, 0xD0, 0x27, 0x07, 0xA0,
  0xE3, 0x04, 0xB0, 0x17, 0x10, 0x7A, 0x0E, 0x30, 0x4B, 0x01, 0x70, 0x6C, 0x82, 0x81, 0x2C, 0xB0,
  0xD0, 0x26, 0x0C, 0xFD, 0x06, 0x60, 0x3F, 0xC0, 0xD7, 0x18, 0x29, 0x94, 0xAB, 0x87, 0xE6, 0x5B,
  0x40, 0x8F, 0xC7, 0x01, 0xB0, 0xB3, 0x86, 0x84, 0xCF, 0xE4, 0x71, 0x50, 0xEA, 0x09, 0x20, 0x6F,
  0x0A, 0x74, 0x06, 0xA8, 0x1C, 0x49, 0xA0, 0xA7, 0x58, 0x3B, 0xF6, 0x02, 0xA7, 0x50, 0x6A, 0x81,
  0xC4, 0x9A, 0x0A, 0x74, 0x06, 0xF0, 0xA7, 0x58, 0x18, 0x4C, 0xA8, 0x15, 0x72, 0x77, 0x81, 0x8F,
  0xC3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_miscellaneous_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_miscellaneous_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_mode_of_travel 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_sharp_24_maps_mode_of_travel_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x40, 0x9F, 0x90, 0x97, 0x20, 0xBA, 0x08, 0x03, 0x28, 0x33,
  0x8E, 0xFB, 0x78, 0x29, 0xFD, 0x26, 0x82, 0x2D, 0xF9, 0x50, 0x2A, 0x02, 0x71, 0x02, 0xA0, 0x24,
  0x81, 0x8F, 0x97, 0x38, 0x18, 0xF8, 0x48, 0x1C, 0xF3, 0x73, 0x81, 0x3F, 0xC4, 0x81, 0xEF, 0x17,
  0x89, 0x11, 0x77, 0x8F, 0xE7, 0x77, 0x1E, 0x97, 0x20, 0x7E, 0x83, 0x70, 0xDF, 0x37, 0x20, 0x7C,
  0x07, 0x28, 0x19, 0xF8, 0x73, 0x07, 0xA0, 0x73, 0x82, 0x2F, 0xE1, 0x73, 0x00, 0x75, 0x81, 0xAF,
  0xA6, 0x82, 0x6D, 0xD6, 0x78, 0x21, 0xEF, 0x54, 0x03, 0xC0, 0x37, 0x05, 0xA0, 0x33, 0x06, 0xC0,
  0x67, 0x18, 0x28, 0xFE, 0x22, 0x05, 0xC0, 0x37, 0x28, 0x90, 0xAF, 0xE3, 0x3E, 0xFE, 0xE6, 0x74,
  0x84, 0xAF, 0xEE, 0xFA, 0x77, 0x10, 0xAA, 0x0A, 0x77, 0x30, 0x08, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_mode_of_travel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 23, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_mode_of_travel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_money 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_sharp_24_maps_money_data[] PROGMEM = {
  0x80, 0xC6, 0xF7, 0x72, 0xC7, 0x72, 0xC1, 0xA1, 0xD1, 0xD1, 0xC1, 0xA1, 0xD1, 0xD1, 0xC1, 0xA1,
  0xA1, 0xA1, 0xA1, 0xA1, 0xC1, 0xA1, 0xA1, 0xA1, 0xA1, 0xA1, 0xC1, 0xA1, 0xA1, 0xA1, 0xA1, 0xA1,
  0xC1, 0xA1, 0xA1, 0xA1, 0xA1, 0xA1, 0xC1, 0xA1, 0xD1, 0xD1, 0xC1, 0xA1, 0xD1, 0xD1, 0xC7, 0x72,
  0xC7, 0x72, 0x80, 0xC6, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_money() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_money_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_moped 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_24_maps_moped_data[] PROGMEM = {
  0x75, 0xD6, 0xD4, 0xD6, 0xD7, 0xA7, 0x74, 0xA4, 0x81, 0x1A, 0xDC, 0x7A, 0x30, 0x10, 0xEE, 0x68,
  0x1A, 0xFC, 0x30, 0xAF, 0x58, 0x27, 0xFE, 0x23, 0x0D, 0xF4, 0x04, 0xA0, 0x44, 0xF9, 0x38, 0x62,
  0xEF, 0x78, 0xDD, 0x81, 0xFE, 0x0A, 0x08, 0xC0, 0x8F, 0xD8, 0x6C, 0x0D, 0xF3, 0x3F, 0xD2, 0x84,
  0xDF, 0x33, 0xFD, 0x68, 0x4D, 0xF3, 0x3F, 0xD2, 0x08, 0xC0, 0x86, 0x08, 0xC0, 0x83, 0x82, 0x8D,
  0xD8, 0x71, 0x82, 0x8D, 0xD8, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_moped() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_maps_moped_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_mosque 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_sharp_24_maps_mosque_data[] PROGMEM = {
  0x73, 0x82, 0x1A, 0xA1, 0x77, 0x50, 0x50, 0xEA, 0x0E, 0x05, 0x77, 0x20, 0x10, 0xAE, 0x0A, 0x01,
  0x71, 0x00, 0x73, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x38, 0x27, 0x70, 0x4A, 0x04, 0x20, 0x9F, 0xB0,
  0x92, 0x04, 0xA0, 0x40, 0xDA, 0x0C, 0x20, 0xEF, 0xB0, 0xE2, 0x0D, 0xA0, 0xC0, 0xDA, 0x0D, 0x20,
  0xEF, 0xB0, 0xE2, 0x0D, 0xA0, 0xD0, 0x4A, 0x04, 0x77, 0x20, 0x4A, 0x04, 0x1A, 0x2F, 0xF2, 0xA2,
  0xA2, 0xFF, 0x2A, 0x2A, 0x2F, 0xF2, 0xA2, 0xA2, 0xFF, 0x2A, 0x2F, 0xFF, 0x92, 0xFF, 0xF9, 0x2F,
  0xA4, 0xFA, 0x2F, 0xA4, 0xFA, 0x2F, 0xA4, 0xFA, 0x2F, 0xA4, 0xFA, 0x2F, 0xA4, 0xFA, 0x2F, 0xA4,
  0xFA, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_mosque() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 23, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_mosque_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_moving 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_24_maps_moving_data[] PROGMEM = {
  0x77, 0x07, 0xD7, 0x71, 0x07, 0xC7, 0x71, 0x01, 0x0E, 0xB7, 0x78, 0x21, 0xCF, 0xEA, 0x68, 0x16,
  0x85, 0x48, 0x41, 0xCF, 0xC1, 0x79, 0x40, 0x10, 0xCB, 0x0A, 0x28, 0x31, 0xCF, 0xC1, 0x20, 0x73,
  0x89, 0x31, 0xCF, 0xD8, 0xEF, 0xB5, 0xCF, 0xC1, 0x68, 0x61, 0xCF, 0xC1, 0x02, 0xEB, 0x0C, 0x01,
  0x68, 0x31, 0xCF, 0xC1, 0x38, 0x21, 0x8B, 0x77, 0x83, 0x1C, 0xFC, 0x17, 0x71, 0x82, 0xBF, 0xC1,
  0x77, 0x28, 0x12, 0xB1, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_moving() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 21, 17), Box(0, 0, 23, 23),
      ic_sharp_24_maps_moving_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_multiple_stop 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_sharp_24_maps_multiple_stop_data[] PROGMEM = {
  0x77, 0x07, 0x77, 0x39, 0x07, 0x77, 0x2A, 0x07, 0x3A, 0x2A, 0x2F, 0x07, 0x2A, 0x2A, 0x2F, 0x07,
  0x77, 0xA0, 0x77, 0x71, 0x90, 0x77, 0x72, 0x07, 0x60, 0x77, 0x72, 0x07, 0x97, 0x71, 0x07, 0xA7,
  0x70, 0x7F, 0x2A, 0x2A, 0x20, 0x7F, 0x2A, 0x2A, 0x30, 0x7A, 0x77, 0x20, 0x79, 0x77, 0x30, 0x77,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_multiple_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_multiple_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_museum 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_24_maps_museum_data[] PROGMEM = {
  0x71, 0x82, 0x1A, 0xA1, 0x77, 0x10, 0x30, 0xDA, 0x0D, 0x03, 0x76, 0x08, 0xE0, 0x87, 0x30, 0x20,
  0xCF, 0x90, 0xC0, 0x27, 0x06, 0xFD, 0x06, 0x40, 0x10, 0xBF, 0xF8, 0x3B, 0x10, 0x5E, 0xFF, 0xA0,
  0xE0, 0x58, 0x0C, 0x4F, 0x2C, 0x20, 0xAA, 0x0A, 0x2C, 0x4C, 0x28, 0x21, 0xEE, 0x12, 0xC4, 0xC3,
  0x00, 0x53, 0xC4, 0xC2, 0x05, 0x20, 0x52, 0xC4, 0xC2, 0x82, 0xE1, 0x1E, 0x2C, 0x4C, 0x29, 0x00,
  0xA9, 0x2C, 0x4C, 0x2C, 0x2C, 0x4F, 0xFA, 0x4F, 0xFA, 0x28, 0x0C, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_museum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_museum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_my_location 24x24, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_sharp_24_maps_my_location_data[] PROGMEM = {
  0x73, 0xA7, 0x76, 0xA7, 0x73, 0x81, 0x49, 0xCA, 0x81, 0xC9, 0x47, 0x50, 0x20, 0xBF, 0x90, 0xB0,
  0x27, 0x28, 0x43, 0xEF, 0xE7, 0x22, 0x84, 0x27, 0xEF, 0xE3, 0x78, 0x22, 0xEF, 0xA7, 0x18, 0x2A,
  0xFE, 0x26, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x58, 0x14, 0xFE, 0x38, 0x41, 0xAD, 0xDA, 0x13,
  0x81, 0xEF, 0x44, 0x81, 0x9F, 0x72, 0x01, 0x0E, 0xC0, 0xE0, 0x12, 0x81, 0x7F, 0x94, 0x81, 0xDF,
  0x22, 0x0A, 0xE0, 0xA2, 0x81, 0x2F, 0xD2, 0xC3, 0x0D, 0xE0, 0xD3, 0xF9, 0x30, 0xDE, 0x0D, 0x3C,
  0x28, 0x1D, 0xF2, 0x20, 0xAE, 0x0A, 0x28, 0x12, 0xFD, 0x48, 0x19, 0xF7, 0x20, 0x10, 0xEC, 0x0E,
  0x01, 0x28, 0x17, 0xF9, 0x48, 0x14, 0xFE, 0x38, 0x41, 0xAD, 0xDA, 0x13, 0x81, 0xEF, 0x45, 0x81,
  0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x68, 0x22, 0xEF, 0xA7, 0x18, 0x2A, 0xFE, 0x27, 0x84, 0x3E, 0xFE,
  0x72, 0x28, 0x42, 0x7E, 0xFE, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xB0, 0x27, 0x58, 0x14, 0x9C, 0xA8,
  0x1C, 0x94, 0x77, 0x3A, 0x77, 0x6A, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_my_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_my_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_navigation 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_24_maps_navigation_data[] PROGMEM = {
  0x70, 0x03, 0x77, 0x00, 0x97, 0x68, 0x21, 0xEE, 0x17, 0x50, 0x6A, 0x06, 0x75, 0x0D, 0xA0, 0xD7,
  0x40, 0x3C, 0x03, 0x73, 0x0A, 0xC0, 0xA7, 0x20, 0x1E, 0x01, 0x71, 0x07, 0xE0, 0x77, 0x10, 0xDE,
  0x0D, 0x70, 0x4F, 0x90, 0x46, 0x0B, 0xF9, 0x0B, 0x50, 0x2F, 0xB0, 0x24, 0x08, 0xFB, 0x08, 0x40,
  0xEF, 0xB0, 0xE3, 0x05, 0xFD, 0x05, 0x20, 0xBC, 0x82, 0xA3, 0x3A, 0xC8, 0x1B, 0x02, 0xA8, 0x1E,
  0x81, 0x48, 0x11, 0x8E, 0xA8, 0x22, 0x3D, 0x67, 0x38, 0x16, 0xD3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_navigation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_navigation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_near_me_disabled 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_24_maps_near_me_disabled_data[] PROGMEM = {
  0x01, 0x04, 0x77, 0x48, 0x1C, 0xF5, 0x77, 0x30, 0x7A, 0x05, 0x74, 0x81, 0x16, 0x93, 0x07, 0xA0,
  0x57, 0x10, 0x50, 0xAA, 0x06, 0x40, 0x7A, 0x05, 0x48, 0x13, 0x9E, 0xC0, 0x15, 0x07, 0xA0, 0x52,
  0x09, 0xE0, 0xA7, 0x08, 0xA0, 0x52, 0x0C, 0xD0, 0x55, 0x81, 0x39, 0xEB, 0x05, 0x20, 0xCB, 0x0E,
  0x40, 0x70, 0xDF, 0x05, 0x20, 0xCA, 0x09, 0x4F, 0xB0, 0x52, 0x81, 0xCF, 0x34, 0x04, 0x0A, 0xFA,
  0x05, 0x20, 0x97, 0x81, 0x17, 0xDF, 0x05, 0x75, 0x04, 0x0A, 0xE0, 0x57, 0x60, 0xAE, 0x05, 0x75,
  0x04, 0xF0, 0x57, 0x50, 0xDB, 0x0E, 0x08, 0xA0, 0x57, 0x40, 0x7B, 0x81, 0x90, 0x7A, 0x05, 0x73,
  0x01, 0xB0, 0x32, 0x07, 0xA0, 0x57, 0x38, 0x1A, 0xFD, 0x40, 0x7A, 0x04, 0x72, 0x81, 0x4F, 0x75,
  0x81, 0x7C, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_near_me_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_near_me_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_near_me 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_24_maps_near_me_data[] PROGMEM = {
  0x77, 0x20, 0x50, 0x97, 0x68, 0x31, 0x8E, 0xF5, 0x74, 0x04, 0x0A, 0xB0, 0xE7, 0x28, 0x11, 0x6D,
  0xD0, 0x87, 0x81, 0x29, 0xEF, 0x01, 0x50, 0x50, 0xBF, 0xA0, 0xA3, 0x81, 0x18, 0xEF, 0xC0, 0x42,
  0x0A, 0xFE, 0x0D, 0x30, 0xAF, 0xE0, 0x64, 0x81, 0x17, 0xDF, 0xA0, 0xE0, 0x17, 0x81, 0x39, 0xEE,
  0x09, 0x73, 0x01, 0x0E, 0xD0, 0x27, 0x40, 0x9C, 0x0B, 0x75, 0x03, 0xC0, 0x57, 0x60, 0xDA, 0x0D,
  0x77, 0x07, 0xA0, 0x77, 0x70, 0x1A, 0x01, 0x77, 0x10, 0xB0, 0xA7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_near_me() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_near_me_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_nightlife 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_maps_nightlife_data[] PROGMEM = {
  0x0A, 0xFD, 0x0A, 0x2D, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x2D, 0x18, 0x15, 0xFC, 0x68, 0x1C, 0xF5,
  0x3D, 0x28, 0x1A, 0xF8, 0x48, 0x18, 0xFA, 0x4A, 0x50, 0x10, 0xEE, 0x0E, 0x01, 0x4A, 0x60, 0x5E,
  0x05, 0x5A, 0x70, 0xAC, 0x0A, 0x6A, 0x70, 0x10, 0xEA, 0x0E, 0x01, 0x6A, 0x71, 0x05, 0xA0, 0x57,
  0xA7, 0x2A, 0x58, 0x18, 0xDE, 0xA7, 0x2A, 0x40, 0x8D, 0x72, 0xA4, 0x0D, 0xD7, 0x2A, 0x40, 0xDC,
  0x0D, 0x7E, 0x20, 0x8C, 0x08, 0x7E, 0x38, 0x28, 0xDD, 0x84,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_nightlife() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_nightlife_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_no_crash 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_sharp_24_maps_no_crash_data[] PROGMEM = {
  0x74, 0x81, 0x1B, 0x27, 0x78, 0x21, 0xDF, 0xA7, 0x48, 0x59, 0x11, 0xDF, 0xC1, 0x73, 0x85, 0x8F,
  0xDD, 0xFC, 0x17, 0x40, 0x10, 0xCA, 0x0C, 0x01, 0x76, 0x82, 0x1C, 0xC1, 0x77, 0x10, 0x01, 0x77,
  0x77, 0x0B, 0xFD, 0x0B, 0x30, 0x1F, 0xF0, 0x12, 0x81, 0x6F, 0xA7, 0x38, 0x1A, 0xF6, 0x28, 0x1C,
  0xF5, 0x73, 0x85, 0x5F, 0xC0, 0x2F, 0xE7, 0x58, 0x2E, 0xF2, 0x7F, 0xFA, 0x07, 0x0C, 0xFF, 0xA0,
  0xCF, 0xFF, 0x81, 0x70, 0x7E, 0x81, 0x70, 0x7E, 0x3E, 0x3E, 0x81, 0x70, 0x7E, 0x81, 0x70, 0x78,
  0x0F, 0x0F, 0x75, 0xE7, 0x5B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_no_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 20, 23), Box(0, 0, 23, 23),
      ic_sharp_24_maps_no_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_no_meals 24x24, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_sharp_24_maps_no_meals_data[] PROGMEM = {
  0x10, 0x40, 0x74, 0xA2, 0xA5, 0x86, 0x4B, 0xE0, 0x1E, 0xF7, 0x3A, 0x2A, 0x40, 0x9B, 0x20, 0x5A,
  0x07, 0x20, 0xA9, 0x2A, 0x30, 0x7C, 0x30, 0x5A, 0x07, 0x20, 0xA2, 0xA3, 0x0D, 0xC4, 0xB0, 0x74,
  0xA3, 0xD4, 0xC0, 0x73, 0xA3, 0xD4, 0xA0, 0x5A, 0x07, 0x20, 0xA9, 0x3D, 0x40, 0xDD, 0x07, 0x20,
  0x93, 0xD4, 0x0A, 0xE0, 0x75, 0xD4, 0x01, 0x0E, 0xE0, 0x74, 0xD5, 0x81, 0x1A, 0xDA, 0x0E, 0xA0,
  0x73, 0xD7, 0x1A, 0x10, 0x5A, 0x07, 0x2D, 0x71, 0xA2, 0x05, 0xA0, 0x74, 0xA7, 0x1A, 0x30, 0x5A,
  0x07, 0x3A, 0x71, 0xA4, 0x05, 0xA0, 0x72, 0x0A, 0x97, 0x1A, 0x50, 0x5A, 0x07, 0x20, 0xA7, 0x1A,
  0x60, 0x5A, 0x07, 0x73, 0xA7, 0x05, 0xA0, 0x77, 0x2A, 0x71, 0x05, 0xA0, 0x77, 0x1A, 0x72, 0x05,
  0xA0, 0x77, 0x75, 0x81, 0x5E, 0x47, 0x76, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_no_meals() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 21, 23), Box(0, 0, 23, 23),
      ic_sharp_24_maps_no_meals_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_not_listed_location 24x24, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_sharp_24_maps_not_listed_location_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x50, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x81,
  0x90, 0x2D, 0x83, 0x71, 0x05, 0xEC, 0x02, 0x08, 0xC8, 0x47, 0x02, 0x20, 0x5C, 0x08, 0x0C, 0xC0,
  0x10, 0x2A, 0x01, 0x1C, 0x0C, 0x0E, 0xF8, 0x1D, 0x02, 0xC0, 0x0E, 0xE8, 0x2D, 0x10, 0xBC, 0x0E,
  0x0D, 0xE8, 0x14, 0x09, 0xD0, 0xD0, 0x9E, 0x02, 0x1E, 0x09, 0x02, 0xFF, 0x81, 0x20, 0xAD, 0x00,
  0x3D, 0x0A, 0x20, 0x10, 0xEC, 0x04, 0x03, 0xC0, 0xE0, 0x13, 0x05, 0xFB, 0x05, 0x50, 0x8F, 0x90,
  0x87, 0x0A, 0xE0, 0xA7, 0x20, 0xAC, 0x0A, 0x74, 0x0A, 0xA0, 0xA7, 0x60, 0x08, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_not_listed_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_not_listed_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_no_transfer 24x24, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_sharp_24_maps_no_transfer_data[] PROGMEM = {
  0x58, 0x25, 0x9C, 0xDB, 0x83, 0xED, 0xC9, 0x53, 0x81, 0x1C, 0x72, 0x0A, 0xFC, 0x82, 0xC1, 0x04,
  0xA0, 0x72, 0x0A, 0xFC, 0x0A, 0x20, 0x5A, 0x07, 0x20, 0xAF, 0xB0, 0xE3, 0x05, 0xA0, 0x77, 0x4A,
  0x4B, 0x07, 0x73, 0xA4, 0xC0, 0x77, 0x2A, 0x4A, 0x05, 0xA0, 0x77, 0x1A, 0x4A, 0x10, 0x5A, 0x07,
  0x7A, 0x4F, 0x07, 0x20, 0xAD, 0x4F, 0x90, 0x72, 0x0A, 0xC4, 0xFA, 0x07, 0x20, 0xAB, 0x4A, 0x81,
  0x70, 0x7D, 0x07, 0x20, 0xAA, 0x4A, 0x3E, 0x07, 0x20, 0xA9, 0x48, 0x3D, 0xF7, 0x07, 0xF0, 0x72,
  0x08, 0x40, 0x8F, 0xD0, 0x77, 0xFE, 0x07, 0x6B, 0x71, 0xB0, 0x75, 0xB7, 0x1C, 0x07, 0x77, 0x38,
  0x15, 0xFC, 0x77, 0x40, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_no_transfer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_no_transfer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_park 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_sharp_24_maps_park_data[] PROGMEM = {
  0x71, 0x00, 0x57, 0x71, 0x82, 0x1E, 0xE1, 0x77, 0x0B, 0xA0, 0xB7, 0x60, 0x6C, 0x07, 0x74, 0x02,
  0x0E, 0xD0, 0x27, 0x30, 0xCE, 0x0C, 0x72, 0x08, 0xF9, 0x08, 0x70, 0x3F, 0xB0, 0x36, 0x0D, 0xFB,
  0x0D, 0x01, 0x40, 0x9F, 0xD0, 0xA5, 0x05, 0xFB, 0x05, 0x50, 0x10, 0xEF, 0xB0, 0xE0, 0x14, 0x09,
  0xFD, 0x0A, 0x30, 0x4F, 0xF0, 0x52, 0x0D, 0xFF, 0x81, 0xE1, 0x8F, 0xFA, 0x0A, 0x7C, 0x77, 0xC7,
  0x7C, 0x77, 0xC7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_park() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_park_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_pedal_bike 24x24, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_sharp_24_maps_pedal_bike_data[] PROGMEM = {
  0x75, 0xC0, 0x27, 0x75, 0xC0, 0x87, 0x77, 0x81, 0x3F, 0xD7, 0x7D, 0x38, 0x1D, 0xF4, 0x76, 0xD3,
  0x81, 0x7F, 0x97, 0x70, 0x1A, 0x01, 0x38, 0x11, 0xFE, 0x71, 0x86, 0x4B, 0xEE, 0xB4, 0x0A, 0xFA,
  0x81, 0xEB, 0x53, 0x07, 0xE0, 0x70, 0x5F, 0xD8, 0x18, 0x04, 0xA8, 0x27, 0x11, 0x6A, 0x84, 0x5E,
  0xF2, 0x04, 0xC0, 0x30, 0x7A, 0x82, 0x5B, 0xF7, 0x48, 0xA2, 0x7F, 0xB9, 0xF8, 0x0B, 0xF7, 0xAF,
  0x70, 0x6F, 0xBE, 0xF1, 0x2F, 0xC8, 0x91, 0x14, 0xFA, 0x01, 0xFE, 0xEF, 0x12, 0xFC, 0x81, 0x10,
  0x22, 0x84, 0x1F, 0xEB, 0xF7, 0x48, 0x17, 0xFB, 0x48, 0x1B, 0xF7, 0x48, 0x26, 0xFB, 0x4A, 0x82,
  0x71, 0x16, 0xA0, 0x44, 0x04, 0xA8, 0x27, 0x11, 0x7A, 0x81, 0x40, 0x8E, 0x07, 0x60, 0x7E, 0x07,
  0x38, 0x44, 0xBE, 0xEB, 0x47, 0x18, 0x44, 0xBE, 0xEB, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_pedal_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_pedal_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_person_pin_circle 24x24, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_sharp_24_maps_person_pin_circle_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x50, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x81,
  0x90, 0x2D, 0x82, 0xB1, 0x1B, 0xD0, 0x20, 0x8D, 0x01, 0x20, 0x1D, 0x08, 0x0C, 0xD0, 0x12, 0x01,
  0xD0, 0xC0, 0xED, 0x82, 0xB1, 0x1B, 0xD0, 0x0E, 0xFF, 0x0E, 0x0D, 0xB8, 0x1E, 0x83, 0x28, 0x13,
  0x8E, 0xB0, 0xD0, 0x9B, 0x03, 0x60, 0x4B, 0x09, 0x02, 0xB0, 0x56, 0x05, 0xB8, 0x12, 0x0A, 0xB0,
  0xA0, 0x32, 0x03, 0x0A, 0xB0, 0xA2, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x30, 0x5F, 0xB0, 0x55, 0x08,
  0xF9, 0x08, 0x70, 0xAE, 0x0A, 0x72, 0x0A, 0xC0, 0xA7, 0x40, 0xAA, 0x0A, 0x76, 0x00, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_person_pin_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_person_pin_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_person_pin 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_24_maps_person_pin_data[] PROGMEM = {
  0x80, 0xF1, 0xF8, 0x2C, 0x66, 0xCF, 0xE0, 0xC4, 0x0C, 0xFD, 0x06, 0x40, 0x6F, 0xD0, 0x64, 0x06,
  0xFD, 0x0C, 0x40, 0xCF, 0xE8, 0x2C, 0x66, 0xCF, 0xFF, 0xFA, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF,
  0x90, 0xD0, 0x37, 0x10, 0x30, 0xDE, 0x02, 0x73, 0x02, 0xE7, 0x58, 0x09, 0x87, 0xF6, 0x07, 0xC0,
  0x77, 0x60, 0x7A, 0x07, 0x77, 0x10, 0x07, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_person_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_person_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_pest_control 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_24_maps_pest_control_data[] PROGMEM = {
  0x48, 0x15, 0xE3, 0x48, 0x13, 0xE5, 0x71, 0x89, 0x09, 0xFE, 0xAE, 0xEA, 0xEF, 0x97, 0x20, 0xAE,
  0x0A, 0x73, 0x0A, 0xE0, 0xA7, 0x30, 0xEE, 0x0E, 0x60, 0x13, 0xF9, 0x30, 0x12, 0x82, 0xCD, 0x58,
  0xF9, 0x85, 0x85, 0xDC, 0x01, 0xCF, 0xF0, 0xC0, 0x12, 0x06, 0x0E, 0xC2, 0xC0, 0xE0, 0x65, 0x0C,
  0xC2, 0xC0, 0xC3, 0xF9, 0x2F, 0xFA, 0x2F, 0x93, 0x0C, 0xC2, 0xC0, 0xC5, 0x06, 0x0E, 0xC2, 0xC0,
  0xE0, 0x62, 0x01, 0x0C, 0xFF, 0x85, 0xC1, 0x0C, 0xD5, 0x8F, 0x98, 0x28, 0x5D, 0xC2, 0x01, 0x30,
  0x9E, 0x09, 0x30, 0x17, 0x84, 0x4B, 0xEE, 0xB4, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_pest_control() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_pest_control_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_pest_control_rodent 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_sharp_24_maps_pest_control_rodent_data[] PROGMEM = {
  0x5B, 0x0B, 0x01, 0x77, 0x1C, 0x0B, 0x77, 0x38, 0x12, 0xFE, 0x75, 0x81, 0x4B, 0xEC, 0x0B, 0x74,
  0x08, 0xE0, 0xB0, 0x17, 0x30, 0x4A, 0x07, 0x01, 0x77, 0x18, 0x1B, 0xF7, 0x77, 0x38, 0x1E, 0xF1,
  0x38, 0x43, 0xAE, 0xEB, 0x17, 0x18, 0x1E, 0xF1, 0x20, 0x6C, 0x84, 0x34, 0xCF, 0xC5, 0x48, 0x3B,
  0xF7, 0x03, 0xC0, 0x80, 0x5D, 0x05, 0x30, 0x3A, 0x07, 0x0A, 0xC0, 0x20, 0xDD, 0x0D, 0x40, 0x7F,
  0x10, 0xEE, 0x50, 0x40, 0xAD, 0x02, 0x0C, 0xE0, 0x36, 0x0E, 0xC0, 0x70, 0x4F, 0x05, 0x50, 0xBC,
  0x0E, 0x09, 0xC0, 0x03, 0xA0, 0x64, 0x04, 0xFB, 0x00, 0x3A, 0x0D, 0x50, 0x7F, 0xE0, 0xD6, 0x81,
  0x4B, 0xEF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_pest_control_rodent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_pest_control_rodent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_pin_drop 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_sharp_24_maps_pin_drop_data[] PROGMEM = {
  0x38, 0x61, 0x7C, 0xEE, 0xC7, 0x15, 0x05, 0x0E, 0xE0, 0xE0, 0x53, 0x05, 0xFB, 0x82, 0x50, 0x1E,
  0xFB, 0x81, 0xE1, 0x7F, 0xD0, 0x70, 0xCC, 0x82, 0xB1, 0x2B, 0xC0, 0xC0, 0xEC, 0x01, 0x20, 0x1C,
  0x00, 0xEC, 0x01, 0x20, 0x1C, 0x0E, 0x0B, 0xC8, 0x2B, 0x12, 0xBC, 0x0B, 0x08, 0xFD, 0x81, 0x81,
  0xEF, 0xB8, 0x2E, 0x10, 0x7F, 0xB0, 0x73, 0x0B, 0xF9, 0x0B, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x50,
  0x10, 0xDC, 0x0D, 0x01, 0x70, 0x10, 0xBA, 0x0B, 0x01, 0x73, 0x00, 0x97, 0x76, 0xFF, 0xFF,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_pin_drop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_pin_drop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_place 24x24, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_sharp_24_maps_place_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x50, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x81,
  0x90, 0x2F, 0xF0, 0x20, 0x8F, 0xF0, 0x80, 0xCD, 0x82, 0xB1, 0x1B, 0xD0, 0xC0, 0xED, 0x01, 0x20,
  0x1D, 0x00, 0xED, 0x01, 0x20, 0x1D, 0x0E, 0x0D, 0xD8, 0x2B, 0x11, 0xBD, 0x0D, 0x09, 0xFF, 0x09,
  0x02, 0xFF, 0x81, 0x20, 0xAF, 0xD0, 0xA2, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x30, 0x5F, 0xB0, 0x55,
  0x08, 0xF9, 0x08, 0x70, 0xAE, 0x0A, 0x72, 0x0A, 0xC0, 0xA7, 0x40, 0xAA, 0x0A, 0x76, 0x00, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_place() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_place_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_plumbing 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_24_maps_plumbing_data[] PROGMEM = {
  0x75, 0x01, 0x04, 0x77, 0x18, 0x21, 0xDF, 0x47, 0x60, 0x10, 0xDB, 0x04, 0x74, 0x01, 0x0D, 0xD0,
  0x47, 0x82, 0xB5, 0x0C, 0xB0, 0xDA, 0x0E, 0x01, 0x50, 0xBA, 0x85, 0x53, 0xEF, 0x41, 0xDA, 0x07,
  0x40, 0x10, 0xCB, 0x81, 0x53, 0x42, 0x82, 0x1D, 0xF7, 0x50, 0x10, 0xCB, 0x86, 0x54, 0xE3, 0x01,
  0xD2, 0x48, 0x21, 0x81, 0xCD, 0x0E, 0x03, 0x68, 0x41, 0xDF, 0xA1, 0xCD, 0x0E, 0x03, 0x40, 0x10,
  0xDB, 0x03, 0x05, 0xE0, 0xA4, 0x0D, 0xB0, 0x04, 0xD0, 0x50, 0x75, 0x05, 0xA0, 0x04, 0xD0, 0x57,
  0x18, 0x15, 0x44, 0xD0, 0x57, 0x30, 0x4D, 0x05, 0x73, 0x04, 0xD0, 0x57, 0x30, 0x4D, 0x05, 0x73,
  0x04, 0xD0, 0x57, 0x30, 0x4D, 0x05, 0x74, 0x01, 0x0C, 0xB0, 0x57, 0x68, 0x21, 0xCF, 0x57, 0x71,
  0x01, 0x04, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_plumbing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_plumbing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_railway_alert 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_sharp_24_maps_railway_alert_data[] PROGMEM = {
  0x76, 0x84, 0x4B, 0xEE, 0xB4, 0x77, 0x08, 0xE0, 0x83, 0x82, 0x48, 0xBD, 0xB8, 0x17, 0x04, 0xB0,
  0x07, 0xB8, 0x14, 0x1B, 0xF8, 0x12, 0x0B, 0xB0, 0x07, 0xB0, 0xB0, 0xAF, 0x92, 0x0E, 0xB0, 0x07,
  0xB0, 0xE0, 0xDF, 0x92, 0x0E, 0xB0, 0x07, 0xB0, 0xEF, 0xA8, 0x13, 0x0B, 0xF9, 0x0B, 0xA7, 0x20,
  0x4B, 0x00, 0x7B, 0x04, 0xA7, 0x30, 0x8E, 0x08, 0x1A, 0x74, 0x84, 0x4B, 0xEE, 0xB4, 0x2F, 0xC0,
  0xA7, 0x2F, 0xD8, 0x1E, 0x72, 0x6F, 0xFA, 0x5E, 0x82, 0xD2, 0x2D, 0xE5, 0xE0, 0x82, 0x08, 0xE5,
  0xE8, 0x2D, 0x22, 0xDE, 0x50, 0xCF, 0xF0, 0xC5, 0x04, 0xFF, 0x04, 0x60, 0x40, 0xCF, 0xB0, 0xC0,
  0x47, 0x10, 0x50, 0xEF, 0x90, 0xE0, 0x57, 0x2F, 0xD7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_railway_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_railway_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_ramen_dining 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_sharp_24_maps_ramen_dining_data[] PROGMEM = {
  0x75, 0x86, 0x24, 0x57, 0x9B, 0xCE, 0x28, 0x71, 0x24, 0x67, 0x9B, 0xDE, 0xD8, 0x2D, 0xCA, 0x82,
  0xE8, 0x5D, 0xA8, 0x75, 0x31, 0x79, 0x84, 0xA9, 0xF0, 0xF7, 0x76, 0x98, 0x4B, 0xBF, 0x7F, 0xB8,
  0x07, 0x72, 0xFF, 0xC2, 0x98, 0x47, 0x7F, 0x0F, 0x77, 0x69, 0x84, 0x77, 0xF0, 0xF7, 0x76, 0x98,
  0x47, 0x7F, 0x0F, 0x77, 0x69, 0x84, 0x77, 0xF0, 0xF7, 0x74, 0x0E, 0xFF, 0xC0, 0xE0, 0xDF, 0xFC,
  0x0D, 0x09, 0xFF, 0xC0, 0x90, 0x2F, 0xFC, 0x81, 0x20, 0x9F, 0xFA, 0x09, 0x30, 0xCF, 0xF0, 0xC4,
  0x01, 0x0C, 0xFD, 0x0C, 0x01, 0x60, 0x70, 0xEF, 0x90, 0xE0, 0x77, 0x20, 0x1F, 0x90, 0x17, 0x4F,
  0x96,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_ramen_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_ramen_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_ramp_left 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_24_maps_ramp_left_data[] PROGMEM = {
  0x30, 0x07, 0x71, 0x07, 0xA0, 0x76, 0x07, 0xC0, 0x74, 0x07, 0xE0, 0x73, 0x81, 0x7F, 0x5A, 0x81,
  0x5F, 0x74, 0x02, 0x1A, 0x10, 0x27, 0xA7, 0x2A, 0x03, 0x71, 0xA0, 0x77, 0x1A, 0x0E, 0x01, 0x7B,
  0x09, 0x7A, 0x81, 0xEF, 0x76, 0xA0, 0x5A, 0x08, 0x5A, 0x10, 0x6A, 0x0B, 0x01, 0x3A, 0x28, 0x24,
  0xEF, 0xA3, 0xA3, 0x01, 0x08, 0x4A, 0x72, 0xA6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_ramp_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 3, 18, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_ramp_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_ramp_right 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_24_maps_ramp_right_data[] PROGMEM = {
  0x60, 0x07, 0x71, 0x07, 0xA0, 0x76, 0x07, 0xC0, 0x74, 0x07, 0xE0, 0x73, 0x81, 0x7F, 0x5A, 0x81,
  0x5F, 0x74, 0x02, 0x1A, 0x10, 0x27, 0xA7, 0x10, 0x3A, 0x71, 0x07, 0xA7, 0x01, 0x0E, 0xA7, 0x09,
  0xB6, 0x81, 0x7F, 0xEA, 0x50, 0x8A, 0x05, 0xA3, 0x01, 0x0B, 0xA0, 0x51, 0xA3, 0x82, 0xAF, 0xE4,
  0x2A, 0x40, 0x80, 0x13, 0xA7, 0x2A, 0x72, 0xA3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_ramp_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 15, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_ramp_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_rate_review 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_24_maps_rate_review_data[] PROGMEM = {
  0x80, 0xD6, 0xF0, 0xD0, 0xAF, 0xFB, 0x82, 0xD2, 0x08, 0xFF, 0x90, 0xD0, 0x23, 0x0A, 0xFE, 0x0D,
  0x02, 0x30, 0x20, 0xDF, 0xD0, 0xD0, 0x23, 0x02, 0x0D, 0xFD, 0x0D, 0x02, 0x30, 0x20, 0xDF, 0xD0,
  0xD0, 0x23, 0x02, 0x0D, 0xFE, 0x02, 0x30, 0x20, 0xDF, 0xF3, 0x82, 0x2D, 0xD1, 0x5F, 0x92, 0x82,
  0x2D, 0xD1, 0x68, 0x09, 0xA3, 0xF0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x77, 0x74, 0x07, 0x77,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_rate_review() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_rate_review_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_remove_road 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_24_maps_remove_road_data[] PROGMEM = {
  0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA7, 0x5A, 0x3A, 0x75,
  0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA5, 0xA3, 0xA5, 0xA7, 0x3A, 0x77, 0x3A, 0x73,
  0x09, 0x06, 0x20, 0x60, 0x91, 0xA5, 0xA2, 0x03, 0xA0, 0x06, 0xA0, 0x3A, 0x5A, 0x30, 0x6C, 0x06,
  0x1A, 0x5A, 0x40, 0xAA, 0x0A, 0x2A, 0x5A, 0x30, 0x6C, 0x06, 0x75, 0x03, 0xA0, 0x06, 0xA0, 0x37,
  0x50, 0x90, 0x62, 0x06, 0x09, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_remove_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_remove_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_restaurant_menu 24x24, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_sharp_24_maps_restaurant_menu_data[] PROGMEM = {
  0x10, 0x01, 0x74, 0x83, 0x49, 0xCA, 0x32, 0x81, 0xBC, 0x17, 0x20, 0x9D, 0x04, 0x01, 0xA0, 0xC0,
  0x17, 0x0A, 0xE0, 0xB0, 0x3B, 0x0C, 0x01, 0x50, 0x4F, 0x0C, 0x1C, 0x0C, 0x01, 0x40, 0xAF, 0x81,
  0x90, 0x8C, 0x0C, 0x01, 0x30, 0xCF, 0x04, 0x20, 0xBC, 0x0C, 0x01, 0x20, 0xAE, 0x09, 0x40, 0xBC,
  0x82, 0xA0, 0x1D, 0xD0, 0xA6, 0x0B, 0xA8, 0x90, 0xD1, 0x1D, 0xFC, 0xAC, 0xA4, 0x71, 0x86, 0xBD,
  0x11, 0xDF, 0xC1, 0x76, 0x81, 0x11, 0xDA, 0x0C, 0x01, 0x76, 0x86, 0x1D, 0xFC, 0xCF, 0xC1, 0x74,
  0x89, 0x01, 0xDF, 0xC1, 0x1C, 0xFC, 0x17, 0x28, 0x31, 0xDF, 0xC1, 0x28, 0x31, 0xCF, 0xC1, 0x78,
  0x31, 0xDF, 0xC1, 0x48, 0x31, 0xCF, 0xC1, 0x58, 0x31, 0xDF, 0xC1, 0x68, 0x31, 0xCF, 0xC1, 0x38,
  0x31, 0xDF, 0xC1, 0x71, 0x83, 0x1C, 0xFC, 0x13, 0x81, 0xAC, 0x17, 0x38, 0x11, 0xCA, 0x50, 0x17,
  0x50, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_restaurant_menu() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_restaurant_menu_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_restaurant 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_24_maps_restaurant_data[] PROGMEM = {
  0xA2, 0xA2, 0xA5, 0x81, 0x4A, 0xEA, 0x2A, 0x2A, 0x40, 0x9D, 0x2A, 0x2A, 0x30, 0x7E, 0x2A, 0x2A,
  0x30, 0xEE, 0x2A, 0x2A, 0x3F, 0x2A, 0x2A, 0x3F, 0x2A, 0x2A, 0x3D, 0x0D, 0xF9, 0x0D, 0x3D, 0x0A,
  0xF9, 0x0A, 0x3D, 0x01, 0x0E, 0xE0, 0xE0, 0x13, 0xD1, 0x81, 0x1A, 0xDA, 0x81, 0xDA, 0x14, 0xD4,
  0xA7, 0xD4, 0xA7, 0x3A, 0x4A, 0x73, 0xA4, 0xA7, 0x3A, 0x4A, 0x73, 0xA4, 0xA7, 0x3A, 0x4A, 0x73,
  0xA4, 0xA7, 0x3A, 0x4A, 0x73, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_restaurant() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_restaurant_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_roundabout_left 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_24_maps_roundabout_left_data[] PROGMEM = {
  0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x75, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x00, 0x74, 0x89, 0x0C, 0xFD,
  0x51, 0x15, 0xDF, 0xC3, 0x07, 0xA0, 0x22, 0x82, 0x5F, 0xD1, 0x48, 0x41, 0xDF, 0x60, 0x7A, 0x05,
  0x38, 0x1B, 0xF5, 0x68, 0x25, 0xFC, 0x7F, 0xA0, 0x16, 0x82, 0x1F, 0xE7, 0xFA, 0x78, 0x31, 0xFE,
  0x07, 0xA0, 0x57, 0x58, 0x15, 0xFB, 0x20, 0x7A, 0x02, 0x73, 0x82, 0x1D, 0xF5, 0x30, 0x07, 0x72,
  0x83, 0x15, 0xDF, 0xC7, 0x7C, 0x0C, 0x01, 0x77, 0xA0, 0xC0, 0x67, 0x72, 0xA7, 0x74, 0xA7, 0x74,
  0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_roundabout_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_roundabout_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_roundabout_right 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_sharp_24_maps_roundabout_right_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEC, 0x67, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x73, 0x89, 0x0C, 0xFD, 0x51, 0x15,
  0xDF, 0xC4, 0x00, 0x73, 0x82, 0x6F, 0xD1, 0x48, 0x21, 0xDF, 0x62, 0x02, 0xA0, 0x72, 0x81, 0xCF,
  0x56, 0x81, 0x5F, 0xC3, 0x05, 0xA8, 0x37, 0x0E, 0xF1, 0x60, 0x1F, 0xA8, 0x27, 0xEF, 0x17, 0xFA,
  0x82, 0x7B, 0xF5, 0x75, 0x05, 0xA8, 0x47, 0x05, 0xFD, 0x17, 0x30, 0x2A, 0x07, 0x38, 0x3C, 0xFD,
  0x51, 0x72, 0x00, 0x74, 0x01, 0x0C, 0xC7, 0x72, 0x06, 0x0C, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74,
  0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_roundabout_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_roundabout_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_route 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_24_maps_route_data[] PROGMEM = {
  0x18, 0x28, 0xDD, 0x83, 0xF9, 0x20, 0x8C, 0x08, 0x2F, 0x92, 0x0D, 0xC0, 0xD2, 0xA4, 0xA2, 0x0E,
  0xC0, 0xE2, 0xA4, 0xA2, 0x08, 0xC0, 0x82, 0xA4, 0xA3, 0x08, 0xA0, 0x83, 0xA4, 0xA4, 0xA4, 0xA4,
  0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4,
  0xA4, 0xA3, 0x08, 0xA0, 0x83, 0xA4, 0xA2, 0x08, 0xC0, 0x82, 0xA4, 0xA2, 0x0E, 0xC0, 0xE2, 0xA4,
  0xA2, 0x0D, 0xC0, 0xD2, 0xF9, 0x20, 0x8C, 0x08, 0x2F, 0x93, 0x82, 0x8D, 0xD8, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_route() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_route_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_run_circle 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_24_maps_run_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xF9, 0x81, 0xA0, 0xAD, 0x04, 0x20, 0xDF, 0x98, 0x1A, 0x0A, 0xD8, 0x1D,
  0x05, 0xF9, 0x81, 0xB7, 0xDF, 0x05, 0x09, 0xE0, 0x70, 0x12, 0x02, 0x0E, 0xE0, 0x90, 0xDE, 0x18,
  0x4C, 0x60, 0x44, 0xDD, 0x0D, 0x0E, 0xE1, 0x98, 0x33, 0x2F, 0x81, 0xD0, 0x0E, 0xF9, 0x10, 0x3F,
  0x90, 0xE0, 0xDF, 0x82, 0xC2, 0x37, 0xF0, 0xD0, 0x9C, 0x84, 0xB3, 0x66, 0x5E, 0x1F, 0x09, 0x05,
  0xC8, 0x3E, 0xB8, 0x59, 0x91, 0xF8, 0x15, 0x0D, 0xFA, 0x1E, 0x0D, 0x20, 0x4F, 0xA1, 0xE0, 0x43,
  0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE,
  0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_run_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_run_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_safety_check 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_sharp_24_maps_safety_check_data[] PROGMEM = {
  0x58, 0x41, 0x6C, 0xC6, 0x17, 0x10, 0x40, 0xAE, 0x0A, 0x04, 0x38, 0x12, 0x8E, 0xFB, 0x81, 0xE8,
  0x28, 0x0C, 0x1F, 0x0A, 0x03, 0x20, 0x30, 0xAF, 0xA0, 0x76, 0x07, 0xF0, 0xA3, 0x00, 0x73, 0x0A,
  0xE0, 0x33, 0x00, 0x73, 0x03, 0xB0, 0xEA, 0x40, 0x70, 0x84, 0xA0, 0xE0, 0xDA, 0x48, 0x13, 0xE3,
  0x3A, 0x0D, 0x0B, 0xA0, 0x34, 0x83, 0x3E, 0x10, 0x3A, 0x0B, 0x07, 0xA0, 0xA5, 0x01, 0x20, 0xAA,
  0x07, 0x01, 0xB0, 0x76, 0x07, 0xB8, 0x11, 0x09, 0xB0, 0xA0, 0x32, 0x03, 0x0A, 0xB0, 0x92, 0x01,
  0x0E, 0xFB, 0x0E, 0x01, 0x30, 0x4F, 0xB0, 0x45, 0x06, 0xF9, 0x06, 0x70, 0x40, 0xDC, 0x0D, 0x04,
  0x73, 0x82, 0x7C, 0xC7, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_safety_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_safety_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_sailing 24x24, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_sharp_24_maps_sailing_data[] PROGMEM = {
  0x73, 0x81, 0x5A, 0x27, 0x71, 0x84, 0x50, 0x1F, 0xE5, 0x76, 0x01, 0x0E, 0x20, 0xEA, 0x06, 0x75,
  0x0B, 0x92, 0x0B, 0xB0, 0x57, 0x30, 0x6A, 0x20, 0x9B, 0x0E, 0x02, 0x71, 0x02, 0x0E, 0xA2, 0x08,
  0xC0, 0xC7, 0x10, 0xCB, 0x20, 0x7D, 0x05, 0x60, 0x8C, 0x20, 0x8D, 0x0D, 0x50, 0x3D, 0x20, 0x9E,
  0x03, 0x40, 0xDD, 0x20, 0xBE, 0x08, 0x30, 0x9E, 0x20, 0xEE, 0x0C, 0x20, 0x4F, 0x10, 0x2F, 0x0D,
  0x20, 0x68, 0x03, 0x71, 0x03, 0x80, 0x47, 0x77, 0x70, 0xDF, 0xFC, 0x0D, 0x07, 0xFF, 0xC8, 0x47,
  0x0C, 0xFD, 0xDC, 0x00, 0xDC, 0x82, 0xDD, 0xFC, 0x28, 0xA0, 0x18, 0x11, 0x9E, 0xE9, 0x11, 0x9E,
  0xE9, 0x11, 0x81, 0x77, 0x71, 0x8A, 0x01, 0x4B, 0xB4, 0x11, 0x4B, 0xB4, 0x11, 0x4B, 0xB4, 0x11,
  0xFF, 0xF8, 0xA0, 0xEC, 0x66, 0xCE, 0xEC, 0x66, 0xCE, 0xEC, 0x66, 0xCE, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_sailing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_sailing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_satellite 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_sharp_24_maps_satellite_data[] PROGMEM = {
  0x80, 0xC2, 0xF2, 0x81, 0x1F, 0xE2, 0xFC, 0x28, 0x37, 0xFB, 0x02, 0xFC, 0x01, 0x07, 0xA8, 0x14,
  0x07, 0xFF, 0x08, 0x20, 0xEF, 0xC8, 0x1E, 0xB4, 0x20, 0xAF, 0xD4, 0x0A, 0xFE, 0x18, 0x12, 0x7E,
  0xFF, 0xF9, 0x81, 0xE5, 0xEF, 0xB0, 0xCC, 0x81, 0x50, 0x5F, 0xA8, 0x1B, 0x0A, 0xA0, 0x83, 0x09,
  0xF0, 0xD0, 0x12, 0x0C, 0x0B, 0x50, 0xCE, 0x03, 0x30, 0x01, 0x50, 0x20, 0xEC, 0x06, 0x75, 0x05,
  0x80, 0xE4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_satellite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_satellite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_screen_rotation_alt 24x24, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_sharp_24_maps_screen_rotation_alt_data[] PROGMEM = {
  0x70, 0x10, 0x87, 0x73, 0x82, 0x1C, 0xFA, 0x77, 0x10, 0x10, 0xCB, 0x0A, 0x76, 0x86, 0x1C, 0xFC,
  0x4E, 0xFA, 0x71, 0xA1, 0x89, 0x01, 0xCF, 0xC1, 0x02, 0xEF, 0xA7, 0xA8, 0x31, 0xCF, 0xC1, 0x38,
  0x22, 0xEF, 0xA6, 0xA8, 0x2C, 0xFC, 0x15, 0x82, 0x2E, 0xFA, 0x5B, 0x0C, 0x01, 0x78, 0x22, 0xEF,
  0xB4, 0xE7, 0x82, 0x2E, 0xFB, 0x3E, 0x71, 0x82, 0x2E, 0xFB, 0x80, 0xD0, 0x08, 0x2B, 0xFE, 0x27,
  0x1E, 0x38, 0x2B, 0xFE, 0x27, 0xE4, 0x82, 0xBF, 0xE2, 0x70, 0x10, 0xCB, 0x58, 0x2B, 0xFE, 0x25,
  0x82, 0x1C, 0xFC, 0xA6, 0x82, 0xBF, 0xE2, 0x38, 0x31, 0xCF, 0xC1, 0xA7, 0x89, 0x0B, 0xFE, 0x20,
  0x1C, 0xFC, 0x11, 0xA7, 0x18, 0x6B, 0xFE, 0x4C, 0xFC, 0x17, 0x60, 0xBB, 0x0C, 0x01, 0x77, 0x18,
  0x2B, 0xFC, 0x17, 0x73, 0x08, 0x01, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_screen_rotation_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_screen_rotation_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_set_meal 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_24_maps_set_meal_data[] PROGMEM = {
  0x80, 0xD1, 0xF8, 0x4D, 0xA8, 0x79, 0xBF, 0xD0, 0xB0, 0x46, 0x01, 0x07, 0xA8, 0x1D, 0x51, 0xC0,
  0x77, 0x38, 0x12, 0xC1, 0x2B, 0x0A, 0x75, 0x01, 0x3C, 0x07, 0x73, 0x81, 0x2C, 0x12, 0xD0, 0xB0,
  0x46, 0x01, 0x07, 0xA8, 0x1D, 0x51, 0xF8, 0x4D, 0xA8, 0x79, 0xB8, 0x0D, 0x5F, 0x80, 0xC6, 0x08,
  0x97, 0x11, 0x23, 0x35, 0x57, 0x78, 0x99, 0xBB, 0xCD, 0xD2, 0xFC, 0x85, 0xDD, 0xCB, 0xA9, 0x92,
  0x86, 0x76, 0x55, 0x33, 0x21, 0x75, 0x80, 0x96, 0x72, 0xFF, 0xC1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_set_meal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_set_meal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_signpost 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_maps_signpost_data[] PROGMEM = {
  0x71, 0x00, 0xB7, 0x72, 0xA7, 0x20, 0x8F, 0xD0, 0xE0, 0x73, 0xFF, 0x90, 0x72, 0xFF, 0xA0, 0x31,
  0xFF, 0xA0, 0x31, 0xFF, 0x90, 0x72, 0x08, 0xFD, 0x0E, 0x07, 0x73, 0xA7, 0x72, 0xA7, 0x30, 0x70,
  0xEF, 0xD0, 0x82, 0x07, 0xFF, 0x91, 0x03, 0xFF, 0xA1, 0x03, 0xFF, 0xA2, 0x07, 0xFF, 0x93, 0x07,
  0x0E, 0xFD, 0x08, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0x00, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_signpost() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_signpost_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_snowmobile 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_sharp_24_maps_snowmobile_data[] PROGMEM = {
  0x74, 0xB0, 0x87, 0x76, 0xC0, 0xA7, 0x77, 0x82, 0x3E, 0xFB, 0x77, 0x70, 0xAA, 0x0C, 0x01, 0x77,
  0x30, 0x20, 0xCC, 0x0D, 0x02, 0x58, 0x92, 0xBD, 0xCA, 0x97, 0x53, 0x20, 0x5E, 0xE0, 0xE0, 0x33,
  0x03, 0xFF, 0xE0, 0x52, 0x0B, 0xFF, 0xF8, 0x36, 0x02, 0x7B, 0xFF, 0xD0, 0x94, 0x02, 0x0D, 0xFF,
  0xA0, 0x73, 0x01, 0x08, 0xB8, 0x28, 0x48, 0xDF, 0x98, 0x1E, 0x71, 0x30, 0x40, 0xEA, 0x0A, 0x02,
  0x38, 0x11, 0xFD, 0x40, 0x7A, 0x05, 0x48, 0x2D, 0xFB, 0x34, 0x82, 0x1B, 0xFA, 0x50, 0x7A, 0x83,
  0x53, 0xFD, 0xDF, 0xA0, 0xE0, 0x13, 0xF9, 0x81, 0x84, 0xDE, 0x81, 0xDA, 0x14, 0xE0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_snowmobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 5, 23, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_snowmobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_sos 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_24_maps_sos_data[] PROGMEM = {
  0xE1, 0x07, 0xE0, 0x71, 0xFD, 0x10, 0x7E, 0x07, 0x1F, 0x95, 0x81, 0x7F, 0x72, 0x81, 0x7F, 0x71,
  0xA4, 0xA5, 0x81, 0x7F, 0x72, 0x81, 0x7F, 0x71, 0xA4, 0xE1, 0x81, 0x7F, 0x72, 0x81, 0x7F, 0x71,
  0xFD, 0x18, 0x17, 0xF7, 0x28, 0x17, 0xF7, 0x1E, 0x4A, 0x18, 0x17, 0xF7, 0x28, 0x17, 0xF7, 0x5A,
  0x4A, 0x18, 0x17, 0xF7, 0x28, 0x17, 0xF7, 0x5F, 0x91, 0x07, 0xE0, 0x71, 0xFD, 0x10, 0x7E, 0x07,
  0x1E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_sos() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 22, 16), Box(0, 0, 23, 23),
      ic_sharp_24_maps_sos_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_soup_kitchen 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_24_maps_soup_kitchen_data[] PROGMEM = {
  0x76, 0x83, 0x2B, 0xEC, 0x47, 0x70, 0xDC, 0x02, 0x75, 0x85, 0x5F, 0xC1, 0x9F, 0x77, 0x58, 0x57,
  0xF8, 0x06, 0xF8, 0x75, 0x89, 0x78, 0xF6, 0x01, 0x53, 0x04, 0xF2, 0x1F, 0x60, 0xCA, 0x28, 0x1A,
  0xF5, 0x58, 0x77, 0xF0, 0x3F, 0x40, 0xE8, 0x28, 0x1C, 0xF3, 0x58, 0x73, 0xF4, 0x0E, 0x80, 0xBC,
  0x28, 0x1D, 0xF1, 0x68, 0x7D, 0x90, 0x9D, 0x05, 0xF2, 0x1A, 0x78, 0x92, 0x9E, 0x05, 0xF2, 0x1F,
  0x61, 0xFE, 0x78, 0x92, 0x8E, 0x04, 0xF2, 0x1F, 0x63, 0xFC, 0x78, 0x92, 0x55, 0x04, 0x70, 0x27,
  0x14, 0xFA, 0x77, 0x28, 0x16, 0xF9, 0x5F, 0xE0, 0x75, 0x0D, 0xFD, 0x04, 0x50, 0x9F, 0xC0, 0xE0,
  0x15, 0x02, 0xFC, 0x08, 0x70, 0x6F, 0xA0, 0xC7, 0x20, 0x6F, 0x0C, 0x01, 0x73, 0x85, 0x28, 0xDF,
  0xEB, 0x57, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_soup_kitchen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_soup_kitchen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_stadium 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_24_maps_stadium_data[] PROGMEM = {
  0x72, 0x0B, 0x03, 0x73, 0x0B, 0x03, 0x6A, 0x0B, 0x03, 0x30, 0xB0, 0x33, 0xA0, 0xB0, 0x34, 0xA0,
  0xB0, 0x33, 0xA0, 0xB0, 0x31, 0xA0, 0xB0, 0x34, 0x0B, 0x03, 0x5A, 0x83, 0xB3, 0x0B, 0x37, 0x60,
  0xB0, 0x35, 0x83, 0x47, 0xAC, 0xDC, 0x83, 0xDC, 0xA7, 0x43, 0x81, 0x18, 0xEF, 0xF8, 0x2E, 0x81,
  0xCA, 0x84, 0xC8, 0x53, 0x11, 0x38, 0x31, 0x35, 0x8C, 0xA0, 0xCB, 0x83, 0xC8, 0x53, 0x14, 0x83,
  0x13, 0x58, 0xC8, 0x09, 0xF6, 0xF6, 0xFF, 0x6F, 0x0C, 0xE6, 0xE8, 0x2C, 0x08, 0xEC, 0x6C, 0x0E,
  0x08, 0x48, 0x23, 0x7A, 0xC6, 0x82, 0xCA, 0x74, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_stadium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_stadium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_store_mall_directory 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_sharp_24_maps_store_mall_directory_data[] PROGMEM = {
  0x1F, 0xFA, 0x2F, 0xFA, 0x77, 0x50, 0x1F, 0xFA, 0x01, 0x04, 0xFF, 0xA0, 0x40, 0x7F, 0xFA, 0x07,
  0x0A, 0xFF, 0xA0, 0xA0, 0xDF, 0xFA, 0x0D, 0x80, 0xC0, 0xF1, 0xA6, 0xA4, 0xA2, 0xA6, 0xA4, 0xA2,
  0xA6, 0xA4, 0xA2, 0xA6, 0xA4, 0xA2, 0xFB, 0x4A, 0x2F, 0xB4, 0xA1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_store_mall_directory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_store_mall_directory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_straight 24x24, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_sharp_24_maps_straight_data[] PROGMEM = {
  0x30, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x7C, 0x81, 0x70, 0x7E, 0x82, 0x77, 0xF5, 0xA8, 0x35, 0xF7,
  0x02, 0x1A, 0x10, 0x24, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_straight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 3, 15, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_straight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_streetview 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_sharp_24_maps_streetview_data[] PROGMEM = {
  0x75, 0x84, 0x4B, 0xEE, 0xB4, 0x76, 0x08, 0xE8, 0x28, 0x04, 0xDF, 0x01, 0x04, 0xF9, 0x04, 0x0D,
  0xF8, 0x1B, 0x0B, 0xF9, 0x0B, 0xF9, 0x81, 0x80, 0xEF, 0x90, 0xEF, 0x98, 0x18, 0x0E, 0xF9, 0x0E,
  0xF9, 0x81, 0xA0, 0xBF, 0x90, 0xBF, 0x98, 0x1E, 0x14, 0xF9, 0x04, 0xFA, 0x81, 0x80, 0x8E, 0x08,
  0x1F, 0xB8, 0x62, 0x04, 0xBE, 0xEB, 0x42, 0xFA, 0x07, 0x73, 0xF9, 0x07, 0x38, 0x41, 0x57, 0x75,
  0x12, 0xF0, 0x72, 0x04, 0x0B, 0xE2, 0xE0, 0x72, 0x08, 0xF9, 0x2D, 0x07, 0x3F, 0xA2, 0xC0, 0x74,
  0xFA, 0x2B, 0x07, 0x5F, 0xA2, 0xA0, 0x76, 0xFA, 0x20, 0xD0, 0x77, 0xF9, 0x0D, 0x20, 0x27, 0x1F,
  0x0D, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_streetview() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_streetview_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_subway 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_sharp_24_maps_subway_data[] PROGMEM = {
  0x48, 0x34, 0x8C, 0xDE, 0xA8, 0x3E, 0xDC, 0x84, 0x60, 0x30, 0xCF, 0xD0, 0xC0, 0x33, 0x04, 0xFF,
  0xA8, 0x24, 0x01, 0xEF, 0xFA, 0x81, 0xE1, 0x8C, 0x82, 0xA5, 0x21, 0x28, 0x21, 0x25, 0xAC, 0x08,
  0x0C, 0xB0, 0x87, 0x30, 0x8B, 0x0C, 0x0E, 0xB0, 0x17, 0x30, 0x1B, 0x0E, 0xC1, 0xFB, 0x1F, 0x91,
  0xFB, 0x1F, 0x91, 0xFB, 0x1F, 0x91, 0xFB, 0x1F, 0x91, 0xFB, 0x1F, 0x97, 0x5F, 0x91, 0x81, 0x4E,
  0x44, 0x81, 0x4E, 0x41, 0xF9, 0x82, 0x34, 0xE4, 0x48, 0x24, 0xE4, 0x3F, 0x90, 0xC0, 0x17, 0x10,
  0x10, 0xCF, 0xA8, 0x90, 0xE4, 0x04, 0x77, 0x40, 0x4E, 0xFB, 0x81, 0xA0, 0x5C, 0x81, 0x50, 0xA8,
  0x0D, 0x1F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_subway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_subway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_synagogue 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_sharp_24_maps_synagogue_data[] PROGMEM = {
  0x73, 0x00, 0x97, 0x74, 0x01, 0x0B, 0xA0, 0xB0, 0x17, 0x18, 0x24, 0xDD, 0x43, 0x02, 0x0D, 0xC0,
  0xD0, 0x23, 0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0x20, 0x40, 0xEE, 0x0E, 0x04, 0x20, 0xDA, 0x0D, 0xC1,
  0x06, 0xFB, 0x06, 0x1C, 0x5D, 0x00, 0x9D, 0x5C, 0x1C, 0x09, 0x20, 0x9C, 0x1F, 0x91, 0xC0, 0x92,
  0x09, 0xC1, 0xF9, 0x1D, 0x00, 0x9D, 0x1F, 0x91, 0xFD, 0x1F, 0x91, 0xFD, 0x1F, 0x91, 0xC4, 0xC1,
  0xF9, 0x1C, 0x4C, 0x1F, 0x91, 0xC4, 0xC1, 0xF9, 0x1C, 0x4C, 0x1F, 0x91, 0xC4, 0xC1, 0xF9, 0x1C,
  0x4C, 0x1F, 0x91, 0xC4, 0xC1, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_synagogue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_synagogue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_takeout_dining 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_sharp_24_maps_takeout_dining_data[] PROGMEM = {
  0x60, 0x7E, 0x07, 0x74, 0x07, 0xF9, 0x07, 0x72, 0x07, 0xFB, 0x07, 0x48, 0x22, 0xB1, 0x7F, 0xD8,
  0x57, 0x1A, 0x2B, 0xFD, 0xFF, 0x83, 0xCF, 0xB1, 0xCF, 0xFA, 0x83, 0xC1, 0x01, 0xCF, 0xF0, 0xC0,
  0x17, 0x77, 0x30, 0x58, 0x09, 0x07, 0x05, 0x60, 0x9F, 0xD0, 0x96, 0x08, 0xFD, 0x08, 0x60, 0x7F,
  0xD0, 0x76, 0x06, 0xFD, 0x06, 0x60, 0x5F, 0xD0, 0x56, 0x03, 0xFD, 0x03, 0x60, 0x2F, 0xD0, 0x26,
  0x01, 0xFD, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_takeout_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_takeout_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_taxi_alert 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_sharp_24_maps_taxi_alert_data[] PROGMEM = {
  0x76, 0x84, 0x4B, 0xEE, 0xB4, 0x77, 0x08, 0xE0, 0x87, 0x50, 0x4B, 0x00, 0x7B, 0x04, 0x6B, 0x81,
  0x30, 0xBB, 0x00, 0x7B, 0x0B, 0x6B, 0x81, 0x10, 0xEB, 0x00, 0x7B, 0x0E, 0x20, 0xBE, 0x81, 0x10,
  0xEB, 0x00, 0x7B, 0x81, 0xE0, 0x1F, 0x81, 0x30, 0xBF, 0x98, 0x3B, 0x06, 0xFA, 0x70, 0x4B, 0x00,
  0x7B, 0x83, 0x40, 0xCF, 0x57, 0x10, 0x8E, 0x83, 0x80, 0x2F, 0xE7, 0x38, 0x44, 0xBE, 0xEB, 0x42,
  0x07, 0xFB, 0x0A, 0x72, 0x0C, 0xFC, 0x84, 0xE7, 0x20, 0x13, 0x3F, 0xFC, 0x3B, 0x81, 0x70, 0x7E,
  0x81, 0x70, 0x7B, 0x3B, 0x3E, 0x3B, 0x3B, 0x81, 0x70, 0x7E, 0x81, 0x70, 0x7B, 0x3F, 0xFC, 0x3F,
  0xFC, 0x3F, 0xFC, 0x3B, 0x75, 0xB3, 0xB7, 0x5B, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_taxi_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_taxi_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_temple_buddhist 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_sharp_24_maps_temple_buddhist_data[] PROGMEM = {
  0x73, 0x00, 0x57, 0x75, 0x82, 0x2E, 0xE2, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x30, 0x9C, 0x09, 0x73,
  0x81, 0xEF, 0x12, 0x05, 0xE0, 0x52, 0x81, 0x1F, 0xE4, 0x82, 0xAF, 0xA1, 0x73, 0x82, 0x1A, 0xFA,
  0x40, 0x20, 0xEF, 0xF0, 0xE0, 0x25, 0x02, 0x09, 0xFD, 0x0A, 0x01, 0x38, 0x1E, 0xF1, 0x2F, 0xD2,
  0x85, 0x1F, 0xEA, 0xFA, 0x17, 0x78, 0x41, 0xAF, 0xA2, 0xEF, 0xFC, 0x83, 0xE2, 0x02, 0x9F, 0xFA,
  0x0A, 0x01, 0x4F, 0xFA, 0x6F, 0xFA, 0x6F, 0xFA, 0x6F, 0xFA, 0x6E, 0x4E, 0x6E, 0x4E, 0x6E, 0x4E,
  0x6E, 0x4E, 0x6E, 0x4E, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_temple_buddhist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_temple_buddhist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_temple_hindu 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_sharp_24_maps_temple_hindu_data[] PROGMEM = {
  0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x60, 0x2E, 0x02, 0x75, 0x06, 0xE0, 0x77, 0x50, 0xBE, 0x0B, 0x80,
  0xD7, 0x00, 0xAF, 0x90, 0xA7, 0x30, 0xEF, 0x90, 0xE7, 0x20, 0x3F, 0xB0, 0x34, 0xA7, 0x72, 0xC7,
  0x72, 0x80, 0x9A, 0x6F, 0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_temple_hindu() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_temple_hindu_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_terrain 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_sharp_24_maps_terrain_data[] PROGMEM = {
  0x75, 0x00, 0x57, 0x75, 0x82, 0x2E, 0xE2, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x30, 0x9C, 0x09, 0x74,
  0x00, 0x52, 0x05, 0xE0, 0x57, 0x28, 0x42, 0xEE, 0x20, 0x5E, 0x0E, 0x02, 0x71, 0x0C, 0xA0, 0xC2,
  0x09, 0xE0, 0xC7, 0x09, 0xC0, 0x92, 0x0C, 0xE0, 0x95, 0x05, 0xE8, 0x15, 0x02, 0xF0, 0x53, 0x02,
  0x0E, 0xE8, 0x1E, 0x4B, 0xF0, 0xE0, 0x22, 0x0C, 0xFF, 0xC8, 0x1C, 0x09, 0xFF, 0xE0, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_terrain() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 22, 17), Box(0, 0, 23, 23),
      ic_sharp_24_maps_terrain_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_theater_comedy 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_sharp_24_maps_theater_comedy_data[] PROGMEM = {
  0x73, 0xFD, 0x73, 0xFD, 0x73, 0xFD, 0x73, 0xB0, 0x0A, 0xA0, 0x0A, 0xB7, 0x3B, 0x2A, 0x2B, 0x73,
  0x80, 0x07, 0x0A, 0xA0, 0x0A, 0xB7, 0x60, 0x7F, 0xFE, 0x18, 0x37, 0x61, 0x16, 0xB0, 0xEF, 0xD1,
  0x84, 0x21, 0x11, 0x1A, 0xA0, 0xCF, 0xD1, 0x07, 0xF0, 0x6B, 0x00, 0xAA, 0x00, 0xAB, 0x10, 0x7E,
  0x0C, 0x1B, 0x2A, 0x2B, 0x10, 0x7D, 0x0C, 0x01, 0x1B, 0x00, 0xAA, 0x00, 0xAB, 0x18, 0x44, 0xCE,
  0xEC, 0x63, 0xFD, 0x73, 0x0E, 0xA0, 0xA4, 0x0A, 0xA0, 0xE7, 0x30, 0xCB, 0x82, 0x83, 0x38, 0xB0,
  0xC7, 0x30, 0x6F, 0xB0, 0x67, 0x40, 0xCF, 0x90, 0xC7, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x84,
  0x6C, 0xEE, 0xC6, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_theater_comedy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_theater_comedy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_tire_repair 24x24, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_sharp_24_maps_tire_repair_data[] PROGMEM = {
  0x77, 0x84, 0x4B, 0xEE, 0xB4, 0x20, 0x40, 0xDE, 0x0D, 0x04, 0x30, 0x8E, 0x83, 0x80, 0xDF, 0xEC,
  0x81, 0xEF, 0xD2, 0x04, 0xA8, 0x27, 0x11, 0x7A, 0x04, 0xA0, 0x30, 0xEA, 0x0E, 0x03, 0xA2, 0x81,
  0xBF, 0x72, 0x83, 0x45, 0x7F, 0xBA, 0x10, 0x3A, 0x03, 0x1A, 0x28, 0x90, 0xEF, 0x10, 0xBF, 0x41,
  0xFE, 0xA0, 0x11, 0xA1, 0x01, 0xA2, 0x89, 0x0E, 0xF1, 0x0B, 0xC0, 0x1F, 0xEA, 0x0D, 0x01, 0xA0,
  0x10, 0xDA, 0x28, 0x1B, 0xF7, 0x48, 0x17, 0xFB, 0xA0, 0xE0, 0xDA, 0x0D, 0x0E, 0xA2, 0x04, 0xA8,
  0x27, 0x11, 0x7A, 0x04, 0xA0, 0x30, 0xEA, 0x0E, 0x03, 0xA3, 0x07, 0xE0, 0x71, 0xA1, 0x03, 0xA0,
  0x31, 0xA4, 0x04, 0xC0, 0x42, 0xA0, 0x11, 0xA1, 0x01, 0xA5, 0xC3, 0xA0, 0xD0, 0x1A, 0x01, 0x0D,
  0xE2, 0xA4, 0xA0, 0xE0, 0xDA, 0x0D, 0x0E, 0xE2, 0xA4, 0xA0, 0x30, 0xEA, 0x0E, 0x03, 0xA2, 0xA2,
  0xA4, 0xA1, 0x03, 0xA0, 0x31, 0xA2, 0xA2, 0xA4, 0xA0, 0x11, 0xA1, 0x01, 0xA2, 0xA2, 0xA4, 0xA0,
  0xD0, 0x1A, 0x01, 0x0D, 0xA2, 0xA2, 0xA4, 0x0D, 0xA0, 0xDA, 0x0D, 0xA0, 0xD2, 0xE4, 0x04, 0x0D,
  0xE0, 0xD0, 0x42, 0xE4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_tire_repair() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 23, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_tire_repair_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_traffic 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_24_maps_traffic_data[] PROGMEM = {
  0x3F, 0xB6, 0xFB, 0x30, 0xED, 0x82, 0xB1, 0x1B, 0xD0, 0xE0, 0xAD, 0x01, 0x20, 0x1D, 0x81, 0xA2,
  0xEC, 0x01, 0x20, 0x1C, 0x83, 0xE2, 0x02, 0x9B, 0x82, 0xB1, 0x1B, 0xB0, 0x90, 0x24, 0xFB, 0x30,
  0xED, 0x82, 0xB1, 0x1B, 0xD0, 0xE0, 0xAD, 0x01, 0x20, 0x1D, 0x81, 0xA2, 0xEC, 0x01, 0x20, 0x1C,
  0x83, 0xE2, 0x02, 0x9B, 0x82, 0xB1, 0x1B, 0xB0, 0x90, 0x24, 0xFB, 0x30, 0xED, 0x82, 0xB1, 0x1B,
  0xD0, 0xE0, 0xAD, 0x01, 0x20, 0x1D, 0x81, 0xA2, 0xEC, 0x01, 0x20, 0x1C, 0x83, 0xE2, 0x02, 0x9B,
  0x82, 0xB1, 0x1B, 0xB0, 0x90, 0x24, 0xFB, 0x6F, 0xB3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_traffic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_traffic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_train 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_sharp_24_maps_train_data[] PROGMEM = {
  0x28, 0x34, 0x9C, 0xDE, 0xA8, 0x3E, 0xDC, 0x94, 0x20, 0x10, 0xBF, 0xD8, 0x1B, 0x19, 0xFF, 0x09,
  0x0E, 0xFF, 0x0E, 0xA5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0xC5, 0xA5, 0x80, 0x98, 0x0F, 0x81, 0x70,
  0x7E, 0x81, 0x70, 0x7C, 0x3E, 0x3A, 0x83, 0xCF, 0x70, 0x7E, 0x84, 0x70, 0x7F, 0xC4, 0xFF, 0x82,
  0x40, 0x4C, 0xFB, 0x0C, 0x04, 0x38, 0x21, 0xDF, 0x74, 0x82, 0x7F, 0xD1, 0x48, 0x1D, 0xF7, 0x68,
  0x17, 0xFD, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_train() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_train_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_tram 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_24_maps_tram_data[] PROGMEM = {
  0x2F, 0xB4, 0x80, 0x07, 0x81, 0xAF, 0xC0, 0xF7, 0x71, 0x81, 0xBF, 0x36, 0x83, 0x17, 0xBD, 0xEA,
  0x86, 0xED, 0xB7, 0x10, 0x3E, 0xFB, 0x81, 0xE3, 0xCF, 0xD0, 0xCF, 0xFA, 0x73, 0xC7, 0x3C, 0x73,
  0xC7, 0x3C, 0x73, 0xFF, 0xF9, 0x00, 0x9F, 0xC0, 0x92, 0x09, 0xD0, 0xEC, 0x09, 0x20, 0x9C, 0x0E,
  0x08, 0xD0, 0x09, 0xD8, 0x28, 0x08, 0xEF, 0x90, 0xE0, 0x82, 0x82, 0x1D, 0xF7, 0x48, 0x27, 0xFD,
  0x12, 0x81, 0xDF, 0x76, 0x81, 0x7F, 0xD1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_tram() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_tram_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_transfer_within_a_station 24x24, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_sharp_24_maps_transfer_within_a_station_data[] PROGMEM = {
  0x68, 0x12, 0x72, 0x77, 0x20, 0x2B, 0x02, 0x77, 0x10, 0x6B, 0x06, 0x77, 0x10, 0x2B, 0x02, 0x77,
  0x28, 0x12, 0x72, 0x77, 0x83, 0x28, 0xDD, 0x47, 0x60, 0x40, 0xBC, 0x0E, 0x01, 0x74, 0x0D, 0xF0,
  0x97, 0x4A, 0x00, 0x6D, 0x07, 0x73, 0xA1, 0x08, 0xB0, 0xCA, 0x81, 0xA3, 0x17, 0xA1, 0x0B, 0xB8,
  0x15, 0x5E, 0xB7, 0xA1, 0x0E, 0xB8, 0x42, 0x01, 0x7C, 0xE7, 0x20, 0x2C, 0x02, 0x77, 0x05, 0xC0,
  0xD0, 0x24, 0x04, 0x07, 0x78, 0x28, 0xFB, 0x9A, 0x0D, 0x38, 0x14, 0xFB, 0x80, 0x17, 0x28, 0x3B,
  0xF8, 0x08, 0xA3, 0x0A, 0xF2, 0x81, 0xEF, 0x42, 0xA4, 0x0B, 0x07, 0x60, 0x1A, 0x01, 0x2A, 0x50,
  0x32, 0x05, 0x02, 0x28, 0x14, 0xFD, 0x3A, 0x38, 0x01, 0x38, 0x59, 0xD1, 0x07, 0xFA, 0x3A, 0x3F,
  0x83, 0xB0, 0xAF, 0x63, 0xA3, 0x80, 0x13, 0x85, 0x9D, 0x10, 0xDF, 0x33, 0xA7, 0x10, 0x50, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_transfer_within_a_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_transfer_within_a_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_transit_enterexit 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_maps_transit_enterexit_data[] PROGMEM = {
  0x72, 0x08, 0x07, 0x72, 0x08, 0xA0, 0x7B, 0x40, 0x9B, 0x08, 0xB3, 0x09, 0xB0, 0x81, 0xB2, 0x09,
  0xB0, 0x82, 0xB1, 0x0A, 0xB0, 0x93, 0xB0, 0xAB, 0x09, 0x4E, 0x09, 0x5D, 0x09, 0x6F, 0xB2, 0xFB,
  0x2F, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_transit_enterexit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 17, 17), Box(0, 0, 23, 23),
      ic_sharp_24_maps_transit_enterexit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_trip_origin 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_sharp_24_maps_trip_origin_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x42, 0x0D, 0xB0, 0xD0, 0x26, 0x02,
  0x0D, 0xB8, 0x1D, 0x05, 0xC0, 0x27, 0x10, 0x2C, 0x05, 0x09, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0x0D,
  0xB0, 0x37, 0x30, 0x3B, 0x0D, 0x0E, 0xB7, 0x5B, 0x00, 0xEB, 0x75, 0xB0, 0xE0, 0xDB, 0x03, 0x73,
  0x03, 0xB0, 0xD0, 0x9B, 0x08, 0x73, 0x08, 0xB0, 0x90, 0x5C, 0x02, 0x71, 0x02, 0xC8, 0x15, 0x0D,
  0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xD2, 0x04, 0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x43, 0x08,
  0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED,
  0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_trip_origin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_trip_origin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_turn_left 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_maps_turn_left_data[] PROGMEM = {
  0x30, 0x07, 0x74, 0x07, 0xA0, 0x27, 0x20, 0x7A, 0x05, 0x72, 0x07, 0xFE, 0x07, 0xFE, 0x10, 0x7A,
  0x05, 0x7A, 0x20, 0x7A, 0x02, 0x6A, 0x30, 0x07, 0x7A, 0x75, 0xA7, 0x5A, 0x75, 0xA7, 0x5A, 0x75,
  0xA7, 0x5A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_turn_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 16, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_turn_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_turn_right 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_maps_turn_right_data[] PROGMEM = {
  0x72, 0x00, 0x77, 0x40, 0x2A, 0x07, 0x74, 0x05, 0xA0, 0x71, 0xFE, 0x07, 0xFE, 0x07, 0xA7, 0x05,
  0xA0, 0x71, 0xA6, 0x02, 0xA0, 0x72, 0xA7, 0x00, 0x73, 0xA7, 0x5A, 0x75, 0xA7, 0x5A, 0x75, 0xA7,
  0x5A, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_turn_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 6, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_turn_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_turn_sharp_left 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_maps_turn_sharp_left_data[] PROGMEM = {
  0x30, 0x07, 0x75, 0x07, 0xA0, 0x77, 0x30, 0x7C, 0x07, 0x71, 0x07, 0xE0, 0x77, 0x81, 0x7F, 0x5A,
  0x81, 0x5F, 0x77, 0x10, 0x21, 0xA1, 0x02, 0x74, 0xA7, 0x6A, 0x76, 0xA7, 0x6A, 0x76, 0xFD, 0x3F,
  0xD7, 0x6A, 0x76, 0xA7, 0x6A, 0x76, 0xA7, 0x6A, 0x76, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_turn_sharp_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 17, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_turn_sharp_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_turn_sharp_right 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_maps_turn_sharp_right_data[] PROGMEM = {
  0x73, 0x00, 0x77, 0x50, 0x7A, 0x07, 0x73, 0x07, 0xC0, 0x77, 0x10, 0x7E, 0x07, 0x78, 0x17, 0xF5,
  0xA8, 0x15, 0xF7, 0x71, 0x02, 0x1A, 0x10, 0x27, 0x4A, 0x76, 0xA7, 0x6A, 0x76, 0xA3, 0xFD, 0x3F,
  0xD3, 0xA7, 0x6A, 0x76, 0xA7, 0x6A, 0x76, 0xA7, 0x6A, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_turn_sharp_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_turn_sharp_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_turn_slight_left 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_sharp_24_maps_turn_slight_left_data[] PROGMEM = {
  0xD0, 0xA3, 0xD0, 0xA3, 0xB0, 0xC0, 0x14, 0xA8, 0x2C, 0xFC, 0x13, 0xA8, 0x31, 0xCF, 0xC1, 0x28,
  0x69, 0x90, 0x1C, 0xFC, 0x15, 0x83, 0x1C, 0xFC, 0x15, 0x82, 0x1C, 0xFC, 0x60, 0x1A, 0x7A, 0x7A,
  0x7A, 0x7A, 0x7A, 0x7A, 0x7A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_turn_slight_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 14, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_turn_slight_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_turn_slight_right 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_sharp_24_maps_turn_slight_right_data[] PROGMEM = {
  0x30, 0xAD, 0x30, 0xAD, 0x40, 0x10, 0xCB, 0x38, 0x21, 0xCF, 0xCA, 0x28, 0x31, 0xCF, 0xC1, 0xA1,
  0x89, 0x31, 0xCF, 0xC1, 0x09, 0x91, 0xCF, 0xC1, 0x48, 0x2C, 0xFC, 0x15, 0xA0, 0x16, 0xA7, 0xA7,
  0xA7, 0xA7, 0xA7, 0xA7, 0xA7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_turn_slight_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 17, 19), Box(0, 0, 23, 23),
      ic_sharp_24_maps_turn_slight_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_two_wheeler 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_24_maps_two_wheeler_data[] PROGMEM = {
  0x72, 0xC0, 0xC0, 0x17, 0x74, 0xD0, 0xC0, 0x12, 0x03, 0x0B, 0x77, 0x28, 0x41, 0xCF, 0xC4, 0xBA,
  0x77, 0x30, 0x10, 0xCD, 0x4D, 0x07, 0x30, 0x30, 0xBE, 0x0C, 0x01, 0x5E, 0x81, 0x73, 0xBF, 0xA0,
  0xC0, 0x15, 0x81, 0x1A, 0xDF, 0xD0, 0x30, 0xCA, 0x84, 0xDA, 0x10, 0x1E, 0xFE, 0x81, 0x82, 0xEC,
  0x86, 0xE1, 0xAF, 0xB1, 0x1B, 0xF9, 0x89, 0x3E, 0x1A, 0xFB, 0x11, 0xBF, 0xAD, 0xF1, 0x20, 0x1F,
  0x98, 0x36, 0x0E, 0xF1, 0x28, 0x41, 0xFD, 0xDF, 0x12, 0x82, 0x1F, 0xD7, 0xC0, 0xD2, 0x81, 0xDF,
  0x12, 0x89, 0x31, 0xFD, 0xAF, 0xB1, 0x1B, 0xFA, 0x07, 0xB0, 0x42, 0x89, 0x0A, 0xFB, 0x11, 0xBF,
  0xA1, 0xEC, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xC8, 0x7E, 0x10, 0x1A, 0xDD, 0xA1, 0x73, 0x84, 0x1A,
  0xDD, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_two_wheeler() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 5, 23, 18), Box(0, 0, 23, 23),
      ic_sharp_24_maps_two_wheeler_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_u_turn_left 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_sharp_24_maps_u_turn_left_data[] PROGMEM = {
  0x68, 0x46, 0xCE, 0xEC, 0x67, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0x89, 0x0C, 0xFD, 0x51, 0x15, 0xDF,
  0xC4, 0x82, 0x6F, 0xD1, 0x48, 0x21, 0xDF, 0x63, 0x81, 0xCF, 0x56, 0x81, 0x5F, 0xC3, 0x81, 0xEF,
  0x16, 0x81, 0x1F, 0xE3, 0xA7, 0x1A, 0x3A, 0x71, 0xA1, 0x02, 0x1A, 0x10, 0x26, 0xA8, 0x17, 0xF5,
  0xA8, 0x15, 0xF7, 0x5A, 0x07, 0xE0, 0x75, 0xA1, 0x07, 0xC0, 0x76, 0xA2, 0x07, 0xA0, 0x77, 0xA3,
  0x00, 0x77, 0x1A, 0x76, 0xA7, 0x6A, 0x76, 0xA7, 0x6A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_u_turn_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 17, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_u_turn_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_u_turn_right 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_maps_u_turn_right_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEC, 0x67, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0x89, 0x0C, 0xFD, 0x51, 0x15, 0xDF,
  0xC4, 0x82, 0x6F, 0xD1, 0x48, 0x21, 0xDF, 0x63, 0x81, 0xCF, 0x56, 0x81, 0x5F, 0xC3, 0x81, 0xEF,
  0x16, 0x81, 0x1F, 0xE3, 0xA7, 0x1A, 0x3A, 0x71, 0xA3, 0xA6, 0x02, 0x1A, 0x10, 0x21, 0xA5, 0x81,
  0x7F, 0x5A, 0x81, 0x5F, 0x7A, 0x50, 0x7E, 0x07, 0xA6, 0x07, 0xC0, 0x71, 0xA7, 0x07, 0xA0, 0x72,
  0xA7, 0x10, 0x07, 0x3A, 0x76, 0xA7, 0x6A, 0x76, 0xA7, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_u_turn_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_u_turn_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_volunteer_activism 24x24, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_sharp_24_maps_volunteer_activism_data[] PROGMEM = {
  0x73, 0x89, 0x06, 0xCF, 0xB3, 0x3B, 0xFC, 0x67, 0x30, 0x6C, 0x00, 0xEC, 0x06, 0x72, 0x0D, 0xFB,
  0x0D, 0x72, 0x0E, 0xFB, 0x0E, 0x72, 0x0B, 0xFB, 0x0A, 0x72, 0x03, 0xFB, 0x03, 0x73, 0x07, 0xF9,
  0x07, 0x75, 0x09, 0xE0, 0x97, 0x70, 0x9C, 0x0A, 0x3C, 0x2A, 0x81, 0xC6, 0x12, 0x09, 0xA0, 0x94,
  0xC2, 0xD8, 0x3A, 0x40, 0x88, 0x5C, 0x2F, 0x81, 0xE8, 0x25, 0xC2, 0xFB, 0x5C, 0x2C, 0x08, 0x0C,
  0xC5, 0xC2, 0xC0, 0x80, 0x27, 0x2C, 0x2F, 0xFD, 0x2F, 0xFD, 0x2F, 0xD8, 0x1E, 0x82, 0xC2, 0x81,
  0x26, 0xBF, 0x0A, 0x04, 0x3C, 0x68, 0x44, 0x9D, 0xC6, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_volunteer_activism() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_volunteer_activism_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_warehouse 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_sharp_24_maps_warehouse_data[] PROGMEM = {
  0x71, 0x82, 0x6C, 0xC6, 0x76, 0x81, 0x39, 0xEC, 0x81, 0xE9, 0x37, 0x10, 0x60, 0xCF, 0xB0, 0xC0,
  0x63, 0x81, 0x39, 0xEF, 0xF8, 0x1E, 0x93, 0x80, 0x9C, 0x5F, 0x73, 0xFB, 0x73, 0xFB, 0x73, 0xFB,
  0x73, 0xFB, 0x4A, 0x4F, 0xB4, 0xA4, 0xFB, 0x73, 0xFB, 0x2A, 0x2A, 0x2F, 0xB2, 0xA2, 0xA2, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_warehouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_warehouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_wine_bar 24x24, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_sharp_24_maps_wine_bar_data[] PROGMEM = {
  0xFF, 0xFD, 0x71, 0xC7, 0x1C, 0x71, 0xFF, 0x0E, 0xFB, 0x0E, 0x0C, 0xFB, 0x0C, 0x06, 0xFB, 0x81,
  0x60, 0xCF, 0x90, 0xC2, 0x01, 0x0C, 0xE0, 0xB0, 0x14, 0x06, 0x0C, 0xA0, 0xB0, 0x57, 0x1A, 0x73,
  0xA7, 0x3A, 0x73, 0xA7, 0xF9, 0x4F, 0x92,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_wine_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 17, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_wine_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_wrong_location 24x24, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_sharp_24_maps_wrong_location_data[] PROGMEM = {
  0x75, 0x03, 0x01, 0x20, 0x10, 0x37, 0x58, 0x63, 0xEC, 0x11, 0xCE, 0x34, 0x89, 0x52, 0x8C, 0xEE,
  0xC0, 0x1C, 0xFC, 0xCF, 0xC1, 0x30, 0x9E, 0x20, 0x10, 0xCA, 0x0C, 0x01, 0x30, 0xBF, 0x20, 0x10,
  0xCA, 0x0C, 0x01, 0x20, 0x9F, 0x91, 0x87, 0x1C, 0xFC, 0xCF, 0xC1, 0x2F, 0xA1, 0x87, 0x3E, 0xC1,
  0x1C, 0xE3, 0x8F, 0xA2, 0x03, 0x01, 0x28, 0x21, 0x30, 0xCD, 0x82, 0xB1, 0x1B, 0x72, 0x0E, 0xD0,
  0x12, 0x01, 0xD0, 0xE3, 0x0E, 0xD0, 0x12, 0x01, 0xD0, 0xE3, 0x0D, 0xD8, 0x2B, 0x11, 0xBD, 0x0D,
  0x30, 0x9F, 0xF0, 0x93, 0x02, 0xFF, 0x02, 0x40, 0xAF, 0xD0, 0xA5, 0x01, 0x0E, 0xFB, 0x0E, 0x01,
  0x60, 0x5F, 0xB0, 0x57, 0x10, 0x8F, 0x90, 0x87, 0x30, 0xAE, 0x0A, 0x75, 0x0A, 0xC0, 0xA7, 0x70,
  0xAA, 0x0A, 0x77, 0x20, 0x08, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_wrong_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_maps_wrong_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_zoom_in_map 24x24, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_sharp_24_maps_zoom_in_map_data[] PROGMEM = {
  0x10, 0x20, 0x17, 0x78, 0x51, 0x20, 0x2E, 0xC1, 0x1A, 0x6A, 0x18, 0x71, 0xCE, 0x21, 0xCF, 0xC1,
  0xA6, 0xA8, 0x90, 0x1C, 0xFC, 0x10, 0x1C, 0xFC, 0xA6, 0xA8, 0x2C, 0xFC, 0x13, 0x01, 0x0C, 0xB6,
  0xB0, 0xC0, 0x13, 0xE6, 0xE2, 0xE6, 0xE8, 0x09, 0xE6, 0x0E, 0x6E, 0x2E, 0x6E, 0x30, 0x10, 0xCB,
  0x6B, 0x0C, 0x01, 0x38, 0x21, 0xCF, 0xCA, 0x6A, 0x89, 0x0C, 0xFC, 0x10, 0x1C, 0xFC, 0x1A, 0x6A,
  0x87, 0x1C, 0xFC, 0x12, 0xEC, 0x11, 0xA6, 0xA1, 0x85, 0x1C, 0xE2, 0x02, 0x17, 0x70, 0x10, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_zoom_in_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_maps_zoom_in_map_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_maps_zoom_out_map 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_24_maps_zoom_out_map_data[] PROGMEM = {
  0xD0, 0x76, 0x07, 0xFA, 0x07, 0x71, 0x07, 0xF0, 0xE0, 0x17, 0x10, 0x10, 0xED, 0x82, 0xEF, 0xC1,
  0x68, 0x21, 0xCF, 0xEB, 0x84, 0x71, 0xCF, 0xC1, 0x48, 0x61, 0xCF, 0xC1, 0x7F, 0x72, 0x82, 0x1C,
  0xF4, 0x48, 0x24, 0xFC, 0x12, 0x07, 0x40, 0x10, 0x46, 0x04, 0x01, 0x80, 0x99, 0x40, 0x01, 0x04,
  0x60, 0x40, 0x14, 0x07, 0x28, 0x21, 0xCF, 0x44, 0x82, 0x4F, 0xC1, 0x28, 0x67, 0xF7, 0x1C, 0xFC,
  0x14, 0x84, 0x1C, 0xFC, 0x17, 0xB8, 0x2E, 0xFC, 0x16, 0x82, 0x1C, 0xFE, 0xD0, 0xE0, 0x17, 0x10,
  0x10, 0xEF, 0x07, 0x71, 0x07, 0xFA, 0x07, 0x60, 0x7D,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_maps_zoom_out_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_maps_zoom_out_map_data, Alpha4(color::Black));
  return value;
}
