#include "editor.h"

using namespace roo_display;

// Image file ic_sharp_24_editor_add_chart 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_sharp_24_editor_add_chart_data[] PROGMEM = {
  0xFC, 0x3A, 0x2F, 0xC3, 0xA2, 0xA7, 0x3F, 0x97, 0x3F, 0x96, 0xA4, 0xA2, 0xA6, 0xA4, 0xA2, 0xA6,
  0xA7, 0x1A, 0x2A, 0x2A, 0x6C, 0x2A, 0x2A, 0x6C, 0x2A, 0x2A, 0x6C, 0x2A, 0x2A, 0x2A, 0x2C, 0x2A,
  0x2A, 0x2A, 0x2C, 0x2A, 0x2A, 0x2A, 0x2C, 0x2A, 0x2A, 0x2A, 0x2C, 0x77, 0xC7, 0x78, 0x0C, 0x2F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_add_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_add_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_add_comment 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_sharp_24_editor_add_comment_data[] PROGMEM = {
  0x80, 0x98, 0x1F, 0x2F, 0xFC, 0x2F, 0xFC, 0x2F, 0xFC, 0x2F, 0xF7, 0x3F, 0xB7, 0x3F, 0xF2, 0xFF,
  0xC2, 0xFF, 0xC2, 0xFF, 0xC2, 0x80, 0x98, 0x1F, 0x77, 0x20, 0x7B, 0x77, 0x30, 0x7A, 0x77, 0x40,
  0x79, 0x77, 0x50, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_add_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_add_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_align_horizontal_center 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_sharp_24_editor_align_horizontal_center_data[] PROGMEM = {
  0x71, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x18, 0x0E, 0x2F, 0x71, 0xA7, 0x72,
  0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x4F, 0xD6, 0xFD, 0x6F, 0xD7, 0x4A, 0x77, 0x2A, 0x77, 0x2A, 0x77,
  0x2A, 0x77, 0x2A, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_align_horizontal_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_align_horizontal_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_align_horizontal_left 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_editor_align_horizontal_left_data[] PROGMEM = {
  0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA2, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF,
  0xC7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA2, 0xFB, 0x6A, 0x2F, 0xB6, 0xA2, 0xFB, 0x6A,
  0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_align_horizontal_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_align_horizontal_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_align_horizontal_right 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_editor_align_horizontal_right_data[] PROGMEM = {
  0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4F, 0xFC, 0x2F, 0xFC, 0x2F, 0xFC, 0x2A,
  0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x77, 0x4A, 0x6F, 0xB2, 0xA6, 0xFB, 0x2A, 0x6F, 0xB2, 0xA7,
  0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x74, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_align_horizontal_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_align_horizontal_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_align_vertical_bottom 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_editor_align_vertical_bottom_data[] PROGMEM = {
  0x5B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x77, 0x3B, 0x4B, 0x73, 0xB4,
  0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7,
  0x3B, 0x4B, 0x73, 0xB4, 0xB8, 0x0D, 0x10, 0x80, 0xC4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_align_vertical_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_align_vertical_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_align_vertical_center 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_editor_align_vertical_center_data[] PROGMEM = {
  0x6B, 0x77, 0x4B, 0x77, 0x4B, 0x77, 0x4B, 0x4B, 0x74, 0xB4, 0xB7, 0x4B, 0x4B, 0x74, 0xB4, 0xB7,
  0x4B, 0x4B, 0x50, 0x2F, 0xFE, 0x02, 0xFF, 0xE6, 0xB4, 0xB7, 0x4B, 0x4B, 0x74, 0xB4, 0xB7, 0x4B,
  0x4B, 0x74, 0xB4, 0xB7, 0x4B, 0x77, 0x4B, 0x77, 0x4B, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_align_vertical_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_align_vertical_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_align_vertical_top 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_editor_align_vertical_top_data[] PROGMEM = {
  0x80, 0xC4, 0xF8, 0x0D, 0x10, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4,
  0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB4, 0xB7, 0x3B, 0x4B, 0x73, 0xB7, 0x73,
  0xB7, 0x73, 0xB7, 0x73, 0xB7, 0x73, 0xB7, 0x73, 0xB7, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_align_vertical_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_align_vertical_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_area_chart 24x24, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_sharp_24_editor_area_chart_data[] PROGMEM = {
  0x71, 0x05, 0x09, 0x77, 0x18, 0x31, 0xEF, 0xB1, 0x76, 0x0B, 0xB0, 0xD0, 0x37, 0x40, 0x7E, 0x06,
  0x40, 0x94, 0x03, 0xFE, 0x0C, 0x02, 0x20, 0xDA, 0x0D, 0xFC, 0x81, 0xE5, 0x9A, 0x82, 0xD1, 0x5E,
  0xF0, 0xCE, 0x04, 0x20, 0x20, 0xDE, 0x10, 0x9C, 0x82, 0x80, 0x12, 0x20, 0xAD, 0x20, 0x6A, 0x0C,
  0x28, 0x1B, 0xE5, 0x20, 0x7C, 0x09, 0x28, 0x34, 0xD2, 0x07, 0xB0, 0x82, 0x04, 0x0E, 0xB0, 0xB0,
  0x13, 0x03, 0xD8, 0x3B, 0x10, 0x1C, 0xB0, 0xD0, 0x32, 0x0D, 0xE0, 0xD0, 0x32, 0x09, 0xC0, 0x60,
  0x9F, 0xA0, 0x62, 0xFF, 0xA0, 0xA1, 0xFF, 0xB0, 0xDF, 0xFC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_area_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_area_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_attach_file 24x24, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_sharp_24_editor_attach_file_data[] PROGMEM = {
  0x18, 0x41, 0xAD, 0xDA, 0x14, 0x86, 0x1E, 0xE9, 0x9E, 0xE1, 0x38, 0x1A, 0xE2, 0x28, 0x12, 0xEA,
  0x30, 0xD0, 0x94, 0x09, 0x0D, 0x39, 0x07, 0x40, 0x79, 0x39, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A,
  0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07,
  0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70,
  0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A, 0x87, 0x70, 0xF7, 0x07, 0xF0, 0x7A,
  0x87, 0x70, 0xF8, 0x08, 0xF0, 0x7A, 0x87, 0x70, 0xBE, 0x8E, 0xB0, 0x7A, 0x89, 0x28, 0x01, 0xBE,
  0xB1, 0x08, 0xFD, 0xA7, 0x83, 0xAD, 0x9E, 0x25, 0x85, 0x2E, 0x91, 0xEC, 0x23, 0x89, 0x42, 0xCE,
  0x10, 0x4E, 0xEA, 0x8A, 0xEE, 0x43, 0x85, 0x29, 0xDF, 0xD9, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_attach_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 17, 22), Box(0, 0, 23, 23),
      ic_sharp_24_editor_attach_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_attach_money 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_24_editor_attach_money_data[] PROGMEM = {
  0x4B, 0x71, 0xB6, 0x03, 0x0A, 0xB0, 0x90, 0x23, 0x07, 0xB0, 0xEA, 0x82, 0xE3, 0x03, 0xA0, 0x73,
  0x85, 0xAF, 0xC0, 0x6F, 0xD4, 0x01, 0xA8, 0x31, 0x5F, 0xE2, 0x78, 0x41, 0xDF, 0xE8, 0x36, 0x02,
  0x0C, 0xB8, 0x1D, 0x81, 0x58, 0x15, 0xAE, 0xA0, 0xE0, 0x47, 0x83, 0x5D, 0xFE, 0x17, 0x85, 0x1E,
  0xF6, 0x8F, 0xA5, 0x82, 0xDF, 0x63, 0xA0, 0x63, 0x07, 0xA8, 0x13, 0x07, 0xB0, 0xDB, 0x09, 0x30,
  0x30, 0xAB, 0x0A, 0x04, 0x6B, 0x71, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_attach_money() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 16, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_attach_money_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_auto_graph 24x24, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_sharp_24_editor_auto_graph_data[] PROGMEM = {
  0x70, 0x77, 0x76, 0x81, 0x2F, 0x27, 0x74, 0x83, 0x2B, 0xFB, 0x27, 0x72, 0x06, 0xD0, 0x67, 0x72,
  0x83, 0x2B, 0xFB, 0x23, 0x00, 0x37, 0x68, 0x12, 0xF2, 0x40, 0x0A, 0x50, 0x33, 0x00, 0x33, 0x07,
  0x30, 0x30, 0xAA, 0x0A, 0x03, 0x28, 0x14, 0xF8, 0x20, 0x0A, 0x70, 0x30, 0xAA, 0x87, 0xA3, 0x03,
  0xEF, 0x73, 0xAA, 0x0A, 0x03, 0x70, 0x0A, 0x28, 0x52, 0xEF, 0x90, 0x3A, 0xA0, 0xA0, 0x33, 0x04,
  0x38, 0x53, 0x30, 0x1D, 0xFA, 0x40, 0x0A, 0x48, 0x17, 0xF7, 0x58, 0x1C, 0xFC, 0x50, 0x03, 0x30,
  0x7B, 0x07, 0x38, 0x2B, 0xFD, 0x17, 0x20, 0x7A, 0x0B, 0xA8, 0x47, 0x09, 0xFE, 0x27, 0x20, 0x7A,
  0x81, 0x70, 0x7A, 0x82, 0xBF, 0xE3, 0x72, 0x07, 0xA0, 0x73, 0x07, 0xB0, 0x47, 0x20, 0x7A, 0x07,
  0x58, 0x17, 0xF5, 0x72, 0x07, 0xA0, 0x77, 0x03, 0x73, 0x81, 0x7F, 0x77, 0x76, 0x03, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_auto_graph() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_auto_graph_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_bar_chart 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_sharp_24_editor_bar_chart_data[] PROGMEM = {
  0x6C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x6C, 0x2C, 0x6C, 0x2C, 0x6C, 0x2C, 0x6C, 0x2C, 0x6C,
  0x2C, 0x2F, 0x92, 0xC2, 0xF9, 0x2C, 0x2F, 0x92, 0xC2, 0xF9, 0x2C, 0x2F, 0x92, 0xC2, 0xF9, 0x2C,
  0x2C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_bar_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_bar_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_all 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_sharp_24_editor_border_all_data[] PROGMEM = {
  0x80, 0xC2, 0xF6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0x80, 0xC4,
  0xF6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0x80, 0xC2, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_bottom 24x24, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_sharp_24_editor_border_bottom_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8,
  0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6,
  0xA6, 0xA8, 0x0C, 0x00, 0x80, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_clear 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_sharp_24_editor_border_clear_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8,
  0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6,
  0xA6, 0xA8, 0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_color 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_sharp_24_editor_border_color_data[] PROGMEM = {
  0x77, 0x02, 0x77, 0x48, 0x14, 0xF8, 0x77, 0x20, 0x4B, 0x08, 0x77, 0x10, 0x7C, 0x08, 0x75, 0x82,
  0x45, 0x07, 0xB0, 0xE0, 0x27, 0x30, 0x4A, 0x81, 0x50, 0x7A, 0x04, 0x73, 0x04, 0xC8, 0x25, 0x07,
  0x47, 0x30, 0x4E, 0x05, 0x74, 0x04, 0xF0, 0x47, 0x30, 0x4F, 0x04, 0x73, 0x04, 0xF0, 0x47, 0x30,
  0x4F, 0x04, 0x73, 0x04, 0xF0, 0x47, 0x4F, 0x04, 0x75, 0xE0, 0x47, 0x6D, 0x04, 0x77, 0xC0, 0x48,
  0x0E, 0x10, 0x80, 0x99, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_color() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 23), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_color_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_horizontal 24x24, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_sharp_24_editor_border_horizontal_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8,
  0x0C, 0x00, 0x80, 0xC0, 0xF8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8, 0x0C, 0x00, 0xA2, 0xA2,
  0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_horizontal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_horizontal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_inner 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_sharp_24_editor_border_inner_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA6, 0xA6, 0xC6,
  0xA6, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0x80, 0xC0, 0xF7, 0x1A, 0x77, 0x2A, 0x71, 0xA6, 0xA6, 0xC6,
  0xA6, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_inner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_inner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_left 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_sharp_24_editor_border_left_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC7, 0x72, 0xA7, 0x72, 0xA6, 0xA6, 0xC6, 0xA6,
  0xC7, 0x72, 0xA7, 0x72, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC7, 0x72, 0xA7, 0x72,
  0xA6, 0xA6, 0xC6, 0xA6, 0xC7, 0x72, 0xA7, 0x72, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2,
  0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_outer 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_sharp_24_editor_border_outer_data[] PROGMEM = {
  0x80, 0xC2, 0xF7, 0x7C, 0x77, 0xC6, 0xA6, 0xC6, 0xA6, 0xC7, 0x7C, 0x77, 0xC2, 0xA2, 0xA2, 0xA2,
  0xC2, 0xA2, 0xA2, 0xA2, 0xC7, 0x7C, 0x77, 0xC6, 0xA6, 0xC6, 0xA6, 0xC7, 0x7C, 0x77, 0x80, 0xC2,
  0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_outer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_outer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_right 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_sharp_24_editor_border_right_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA7, 0x72, 0xA7, 0x72, 0xC6, 0xA6, 0xC6, 0xA6,
  0xA7, 0x72, 0xA7, 0x72, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA7, 0x72, 0xA7, 0x72,
  0xC6, 0xA6, 0xC6, 0xA6, 0xA7, 0x72, 0xA7, 0x72, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2,
  0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_style 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_sharp_24_editor_border_style_data[] PROGMEM = {
  0x80, 0xC2, 0xF7, 0x72, 0xA7, 0x72, 0xA7, 0x7C, 0x77, 0xC7, 0x72, 0xA7, 0x72, 0xA7, 0x7C, 0x77,
  0xC7, 0x72, 0xA7, 0x72, 0xA7, 0x7C, 0x77, 0xC7, 0x72, 0xA7, 0x72, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2,
  0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_style() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_style_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_top 24x24, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_sharp_24_editor_border_top_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8, 0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2,
  0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA6, 0xA6, 0xC6, 0xA6, 0xA8, 0x0C, 0x00, 0xA2, 0xA2,
  0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_border_vertical 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_sharp_24_editor_border_vertical_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA6, 0xA6, 0xC6,
  0xA6, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA7, 0x1A,
  0x77, 0x2A, 0x71, 0xA6, 0xA6, 0xC6, 0xA6, 0xA7, 0x1A, 0x77, 0x2A, 0x71, 0xA2, 0xA2, 0xA2, 0xA2,
  0xC2, 0xA2, 0xA2, 0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_border_vertical() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_border_vertical_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_bubble_chart 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_24_editor_bubble_chart_data[] PROGMEM = {
  0x71, 0x84, 0x19, 0xDE, 0xB5, 0x72, 0x03, 0x0E, 0xD0, 0x97, 0x10, 0xDF, 0x05, 0x60, 0x5F, 0x90,
  0xB6, 0x08, 0xF9, 0x0E, 0x60, 0x7F, 0x90, 0xD6, 0x03, 0xF9, 0x84, 0x90, 0x3A, 0xB7, 0x20, 0xAE,
  0x81, 0xE1, 0x4C, 0x82, 0xA0, 0x1A, 0xC8, 0x2D, 0x30, 0xCD, 0x03, 0x28, 0x23, 0x78, 0x53, 0x0E,
  0xD0, 0x57, 0x20, 0xBD, 0x02, 0x72, 0x02, 0x0E, 0xB0, 0x83, 0x82, 0x6E, 0xC2, 0x48, 0x21, 0x78,
  0x33, 0x01, 0xB0, 0xA7, 0x40, 0x1B, 0x0A, 0x75, 0x82, 0x6E, 0xC2, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_bubble_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_bubble_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_candlestick_chart 24x24, 4-bit Alpha,  RLE, 29 bytes.
static const unsigned char ic_sharp_24_editor_candlestick_chart_data[] PROGMEM = {
  0x2A, 0x6A, 0x4A, 0x6A, 0x2E, 0x4A, 0x2E, 0x4A, 0x2E, 0x2F, 0xD2, 0xFD, 0x2F, 0xD2, 0xFD, 0x2F,
  0xD2, 0xFD, 0x2F, 0xD4, 0xA2, 0xE4, 0xA2, 0xE4, 0xA4, 0xA6, 0xA4, 0xA6, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_candlestick_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 18, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_candlestick_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_checklist 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_editor_checklist_data[] PROGMEM = {
  0x70, 0xB0, 0x57, 0x73, 0x81, 0xBF, 0xD7, 0x48, 0x12, 0xA1, 0x28, 0x2B, 0xFD, 0x27, 0x48, 0x6B,
  0xFC, 0x1B, 0xFD, 0x23, 0xFA, 0x01, 0x0D, 0xB0, 0xD0, 0x24, 0xFA, 0x18, 0x31, 0xDF, 0xD2, 0x77,
  0x28, 0x11, 0xB2, 0x80, 0xC6, 0x00, 0xB0, 0x57, 0x73, 0x81, 0xBF, 0xD7, 0x48, 0x12, 0xA1, 0x28,
  0x2B, 0xFD, 0x27, 0x48, 0x6B, 0xFC, 0x1B, 0xFD, 0x23, 0xFA, 0x01, 0x0D, 0xB0, 0xD0, 0x24, 0xFA,
  0x18, 0x31, 0xDF, 0xD2, 0x77, 0x28, 0x11, 0xB2, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_checklist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_checklist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_checklist_rtl 24x24, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_sharp_24_editor_checklist_rtl_data[] PROGMEM = {
  0x77, 0x38, 0x11, 0xC3, 0x77, 0x28, 0x21, 0xDF, 0xB7, 0x40, 0x40, 0x92, 0x82, 0x1D, 0xFC, 0x1F,
  0xA2, 0x85, 0xEF, 0xA2, 0xDF, 0xC2, 0xFA, 0x20, 0x30, 0xEB, 0x0C, 0x77, 0x18, 0x23, 0xEF, 0xC7,
  0x73, 0x03, 0x0B, 0x80, 0xC6, 0x08, 0x11, 0xC3, 0x77, 0x28, 0x21, 0xDF, 0xB7, 0x40, 0x40, 0x92,
  0x82, 0x1D, 0xFC, 0x1F, 0xA2, 0x85, 0xEF, 0xA2, 0xDF, 0xC2, 0xFA, 0x20, 0x30, 0xEB, 0x0C, 0x77,
  0x18, 0x23, 0xEF, 0xC7, 0x73, 0x03, 0x0B, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_checklist_rtl() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_checklist_rtl_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_data_array 24x24, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_sharp_24_editor_data_array_data[] PROGMEM = {
  0xD6, 0xFB, 0x6F, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75,
  0xC7, 0x5C, 0x75, 0xC7, 0x5F, 0x6F, 0xB6, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_data_array() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_data_array_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_data_object 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_editor_data_object_data[] PROGMEM = {
  0x2E, 0x4E, 0x4E, 0x4E, 0x4A, 0x75, 0xA4, 0xA7, 0x5A, 0x4A, 0x75, 0xA4, 0xA7, 0x5A, 0x2C, 0x75,
  0xE0, 0x07, 0x75, 0x00, 0x7C, 0x00, 0x77, 0x50, 0x07, 0xE7, 0x5C, 0x2A, 0x75, 0xA4, 0xA7, 0x5A,
  0x4A, 0x75, 0xA4, 0xA7, 0x5A, 0x4E, 0x4E, 0x4E, 0x4E, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_data_object() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_data_object_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_drag_handle 24x24, 4-bit Alpha,  RLE, 8 bytes.
static const unsigned char ic_sharp_24_editor_drag_handle_data[] PROGMEM = {
  0xFF, 0xFF, 0xC7, 0x77, 0x74, 0xFF, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_drag_handle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 19, 14), Box(0, 0, 23, 23),
      ic_sharp_24_editor_drag_handle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_draw 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_sharp_24_editor_draw_data[] PROGMEM = {
  0x18, 0x44, 0xBE, 0xEB, 0x47, 0x01, 0x40, 0x6E, 0x06, 0x58, 0x1B, 0xC1, 0x38, 0x1D, 0xF6, 0x28,
  0x16, 0xFD, 0x40, 0xBA, 0x0C, 0x01, 0x78, 0x16, 0xFD, 0x30, 0x10, 0xDB, 0x0C, 0x01, 0x40, 0x50,
  0xCA, 0x06, 0x28, 0x22, 0x02, 0xDB, 0x83, 0xC1, 0x04, 0xDA, 0x0D, 0x05, 0x28, 0x4B, 0xE3, 0x02,
  0xDA, 0x81, 0xB0, 0x5A, 0x0D, 0x06, 0x30, 0xBA, 0x84, 0xE3, 0x02, 0xDB, 0x28, 0x1D, 0xF7, 0x40,
  0xBC, 0x82, 0xE3, 0x01, 0x38, 0x1E, 0xF7, 0x30, 0xBE, 0x0E, 0x02, 0x48, 0x16, 0xF6, 0x20, 0xBF,
  0x0B, 0x60, 0x22, 0x0B, 0xF0, 0xB7, 0x20, 0xBF, 0x0B, 0x72, 0x0B, 0xF0, 0xB2, 0x81, 0x6E, 0x24,
  0x0B, 0xF0, 0xB3, 0x81, 0xBF, 0xC4, 0xF0, 0xB4, 0x81, 0x1F, 0xE4, 0xE0, 0xB4, 0x82, 0x3B, 0xFB,
  0x4D, 0x0B, 0x3C, 0x0E, 0x02, 0x4C, 0x0B, 0x49, 0x82, 0xEC, 0x71, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_draw() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_draw_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_edit_note 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_sharp_24_editor_edit_note_data[] PROGMEM = {
  0xFC, 0x71, 0xFC, 0x80, 0xD2, 0x0F, 0xC7, 0x1F, 0xC5, 0x04, 0x77, 0x38, 0x19, 0xF7, 0x77, 0x10,
  0x20, 0x5A, 0x04, 0xF6, 0x83, 0x9E, 0x35, 0x91, 0xF5, 0x09, 0xA0, 0xE0, 0x27, 0x60, 0x9B, 0x09,
  0x76, 0x09, 0xB0, 0x97, 0x60, 0x9B, 0x09, 0x77, 0xB0, 0x97, 0x71, 0xA0, 0x97,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_edit_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_edit_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_align_center 24x24, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_sharp_24_editor_format_align_center_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0C, 0x40, 0xFB, 0x71, 0xFB, 0x80, 0xC4, 0x08, 0x0C, 0x0F, 0x80, 0xC4, 0x0F,
  0xB7, 0x1F, 0xB8, 0x0C, 0x40, 0x80, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_align_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_align_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_align_justify 24x24, 4-bit Alpha,  RLE, 23 bytes.
static const unsigned char ic_sharp_24_editor_format_align_justify_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0C, 0x00, 0x80, 0xC0, 0xF8, 0x0C, 0x00, 0x80, 0xC0, 0xF8, 0x0C, 0x00, 0x80,
  0xC0, 0xF8, 0x0C, 0x00, 0x80, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_align_justify() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_align_justify_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_align_left 24x24, 4-bit Alpha,  RLE, 23 bytes.
static const unsigned char ic_sharp_24_editor_format_align_left_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0C, 0x00, 0xFD, 0x6F, 0xD8, 0x0C, 0x60, 0x80, 0xC0, 0xF8, 0x0C, 0x00, 0xFD,
  0x6F, 0xD8, 0x0C, 0x60, 0x80, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_align_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_align_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_align_right 24x24, 4-bit Alpha,  RLE, 23 bytes.
static const unsigned char ic_sharp_24_editor_format_align_right_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0C, 0x60, 0xFD, 0x6F, 0xD8, 0x0C, 0x00, 0x80, 0xC0, 0xF8, 0x0C, 0x60, 0xFD,
  0x6F, 0xD8, 0x0C, 0x00, 0x80, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_align_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_align_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_bold 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_sharp_24_editor_format_bold_data[] PROGMEM = {
  0xE8, 0x1E, 0xB3, 0x2F, 0xA0, 0x51, 0xB0, 0xF7, 0x09, 0xA0, 0xE1, 0xB4, 0x09, 0xA0, 0x2B, 0x40,
  0x9A, 0x02, 0xB0, 0xF7, 0x09, 0xA0, 0xB1, 0xF9, 0x0D, 0x01, 0x1F, 0xA0, 0x81, 0xB0, 0xF7, 0x08,
  0x0D, 0xA0, 0x4B, 0x40, 0x2A, 0x0A, 0xB4, 0x02, 0xA0, 0xAB, 0x0F, 0x70, 0x80, 0xDA, 0x07, 0xFA,
  0x0D, 0x1F, 0x81, 0xE9, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_bold() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 17, 17), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_bold_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_clear 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_24_editor_format_clear_data[] PROGMEM = {
  0x84, 0x4D, 0x20, 0x2E, 0xFD, 0x85, 0xAF, 0xD2, 0x02, 0xEF, 0xC1, 0x85, 0xBF, 0xD2, 0x02, 0xEF,
  0xB2, 0x82, 0xBF, 0xD2, 0x38, 0x1E, 0xFE, 0x72, 0x87, 0xBF, 0xD2, 0x02, 0xEF, 0x87, 0x38, 0x6B,
  0xFD, 0x20, 0x2E, 0x27, 0x48, 0x4B, 0xFD, 0x20, 0x17, 0x68, 0x2B, 0xFD, 0x27, 0x70, 0x2A, 0x0D,
  0x02, 0x76, 0x08, 0xB0, 0xD0, 0x27, 0x58, 0x5E, 0xFE, 0xBF, 0xD2, 0x73, 0x06, 0xA8, 0x48, 0x0B,
  0xFD, 0x27, 0x20, 0xDA, 0x02, 0x28, 0x2B, 0xFD, 0x27, 0x04, 0xA0, 0xB4, 0x82, 0xBF, 0xD2, 0x77,
  0x18, 0x1B, 0xFD, 0x77, 0x20, 0xA0, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_color_fill 24x24, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_sharp_24_editor_format_color_fill_data[] PROGMEM = {
  0x48, 0x11, 0xB3, 0x77, 0x38, 0x28, 0xFE, 0x37, 0x73, 0x82, 0xAF, 0xE3, 0x77, 0x38, 0x2B, 0xFE,
  0x37, 0x71, 0x03, 0x0E, 0xA0, 0xE0, 0x37, 0x68, 0x63, 0xEF, 0xAA, 0xFE, 0x37, 0x48, 0x23, 0xEF,
  0xA2, 0x82, 0xAF, 0xE3, 0x72, 0x82, 0x3E, 0xFA, 0x48, 0x2A, 0xFE, 0x37, 0x82, 0x3E, 0xFA, 0x68,
  0x2A, 0xFE, 0x35, 0x82, 0x3E, 0xFA, 0x71, 0x82, 0xAF, 0xE3, 0x40, 0x30, 0xEF, 0xD0, 0xE0, 0x35,
  0x03, 0x0E, 0xFB, 0x83, 0xE3, 0x01, 0x14, 0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x20, 0x0C, 0x50, 0x30,
  0xEE, 0x0E, 0x03, 0x20, 0x7A, 0x06, 0x50, 0x30, 0xEC, 0x0E, 0x03, 0x30, 0xDA, 0x0D, 0x60, 0x30,
  0xEA, 0x0E, 0x03, 0x40, 0xDA, 0x0D, 0x78, 0x23, 0xEE, 0x35, 0x82, 0x4D, 0xD4, 0x71, 0x00, 0x38,
  0x0D, 0x70, 0x80, 0x99, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_color_fill() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 23), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_color_fill_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_color_reset 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_24_editor_format_color_reset_data[] PROGMEM = {
  0x70, 0x04, 0x76, 0x82, 0x2E, 0xE2, 0x60, 0x10, 0x94, 0x0C, 0xA0, 0xC6, 0x81, 0xBF, 0xB2, 0x04,
  0xC0, 0x85, 0x82, 0x2D, 0xFB, 0x20, 0x6C, 0x03, 0x58, 0x22, 0xDF, 0xB2, 0x06, 0xB0, 0xD6, 0x82,
  0x2E, 0xFB, 0x20, 0x6B, 0x07, 0x60, 0xEA, 0x0B, 0x20, 0x6A, 0x0E, 0x50, 0x6C, 0x0B, 0x20, 0x6A,
  0x06, 0x40, 0xBD, 0x0B, 0x28, 0x16, 0xFB, 0x40, 0xEE, 0x0B, 0x20, 0x60, 0xE4, 0x0E, 0xF0, 0xB2,
  0x05, 0x40, 0xCF, 0x90, 0xB6, 0x06, 0xFA, 0x0B, 0x60, 0xCF, 0xA0, 0xB5, 0x01, 0x0C, 0xE8, 0x2C,
  0xDF, 0xB6, 0x89, 0x16, 0xCE, 0xEC, 0x60, 0x2D, 0xFA, 0x76, 0x81, 0x2D, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_color_reset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_color_reset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_color_text 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_sharp_24_editor_format_color_text_data[] PROGMEM = {
  0x71, 0x06, 0xA0, 0x67, 0x72, 0x0C, 0xA0, 0xC7, 0x71, 0x84, 0x2F, 0xEE, 0xF2, 0x77, 0x84, 0x8F,
  0x99, 0xF8, 0x77, 0x84, 0xEF, 0x44, 0xFE, 0x76, 0x81, 0x4F, 0xE2, 0x81, 0xEF, 0x47, 0x58, 0x1A,
  0xF8, 0x28, 0x18, 0xFA, 0x74, 0x01, 0xA0, 0x32, 0x03, 0xA0, 0x17, 0x30, 0x6A, 0x80, 0x09, 0xA0,
  0x67, 0x30, 0xCF, 0x90, 0xC7, 0x20, 0x3A, 0x84, 0x65, 0x55, 0x56, 0xA0, 0x37, 0x18, 0x18, 0xFC,
  0x68, 0x1C, 0xF8, 0x71, 0x81, 0xEF, 0x66, 0x81, 0x6F, 0xE7, 0x05, 0xA0, 0x16, 0x01, 0xA0, 0x58,
  0x0F, 0x30, 0x80, 0x99, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_color_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 23), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_color_text_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_indent_decrease 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_sharp_24_editor_format_indent_decrease_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0D, 0x00, 0xFB, 0x30, 0x74, 0xFB, 0x20, 0x79, 0x77, 0x10, 0x7A, 0x77, 0x07,
  0xB4, 0xFB, 0x07, 0xB4, 0xFB, 0x10, 0x7A, 0x77, 0x20, 0x79, 0x77, 0x30, 0x74, 0xFB, 0x71, 0xFB,
  0x80, 0xC0, 0x08, 0x0C, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_indent_decrease() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_indent_decrease_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_indent_increase 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_sharp_24_editor_format_indent_increase_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0D, 0x00, 0xFB, 0x07, 0x7F, 0xC0, 0x77, 0x72, 0xA0, 0x77, 0x71, 0xB0, 0x74,
  0xFE, 0x07, 0x4F, 0xD0, 0x77, 0x71, 0x90, 0x77, 0x72, 0x07, 0x7F, 0xB7, 0x1F, 0xB8, 0x0C, 0x00,
  0x80, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_indent_increase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_indent_increase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_italic 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_sharp_24_editor_format_italic_data[] PROGMEM = {
  0x4F, 0x94, 0xF9, 0x4F, 0x96, 0x81, 0xEF, 0xE7, 0x10, 0x6A, 0x08, 0x71, 0x0D, 0xA0, 0x27, 0x04,
  0xA0, 0xB7, 0x10, 0xBA, 0x04, 0x70, 0x2A, 0x0D, 0x71, 0x08, 0xA0, 0x67, 0x18, 0x1E, 0xFE, 0x6F,
  0x94, 0xF9, 0x4F, 0x94,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_italic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 17, 17), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_italic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_line_spacing 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_24_editor_format_line_spacing_data[] PROGMEM = {
  0x30, 0x01, 0x77, 0x48, 0x21, 0xDD, 0x17, 0x72, 0x01, 0x0D, 0xA0, 0xD0, 0x12, 0xFD, 0x01, 0x0D,
  0xC0, 0xD0, 0x11, 0xFD, 0x3A, 0x77, 0x5A, 0x77, 0x5A, 0x77, 0x5A, 0x77, 0x5A, 0x4F, 0xD3, 0xA4,
  0xFD, 0x3A, 0x77, 0x5A, 0x77, 0x5A, 0x77, 0x5A, 0x77, 0x20, 0x10, 0xDC, 0x0D, 0x01, 0x1F, 0xD1,
  0x01, 0x0D, 0xA0, 0xD0, 0x12, 0xFD, 0x28, 0x21, 0xDD, 0x17, 0x74, 0x00, 0x17, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_line_spacing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_line_spacing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_list_bulleted 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_sharp_24_editor_format_list_bulleted_data[] PROGMEM = {
  0x10, 0x05, 0x77, 0x20, 0x5A, 0x05, 0x1F, 0xF0, 0x5A, 0x05, 0x1F, 0xF1, 0x00, 0x58, 0x0E, 0x30,
  0x00, 0x57, 0x72, 0x05, 0xA0, 0x51, 0xFF, 0x05, 0xA0, 0x51, 0xFF, 0x10, 0x05, 0x80, 0xE3, 0x00,
  0x05, 0x77, 0x20, 0x5A, 0x05, 0x1F, 0xF0, 0x5A, 0x05, 0x1F, 0xF1, 0x00, 0x57, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_list_bulleted() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_list_bulleted_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_list_numbered 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_sharp_24_editor_format_list_numbered_data[] PROGMEM = {
  0xA7, 0x74, 0x93, 0xFF, 0x19, 0x3F, 0xF1, 0x98, 0x0E, 0x30, 0xB7, 0x73, 0x09, 0x07, 0x2F, 0xF0,
  0x70, 0x93, 0xFF, 0xB8, 0x0E, 0x20, 0xB7, 0x73, 0x07, 0x92, 0xFF, 0x10, 0x79, 0x2F, 0xFB, 0x77,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_list_numbered() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_list_numbered_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_list_numbered_rtl 24x24, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_sharp_24_editor_format_list_numbered_rtl_data[] PROGMEM = {
  0x77, 0x2A, 0x1F, 0xF3, 0x91, 0xFF, 0x39, 0x77, 0x49, 0x80, 0xE3, 0x0F, 0xFB, 0x30, 0x90, 0x7F,
  0xF2, 0x07, 0x09, 0x77, 0x3B, 0x80, 0xE2, 0x0F, 0xFB, 0x30, 0x7F, 0xF9, 0x30, 0x79, 0x77, 0x2B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_list_numbered_rtl() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_list_numbered_rtl_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_paint 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_sharp_24_editor_format_paint_data[] PROGMEM = {
  0xFF, 0x3F, 0xF3, 0x80, 0xD4, 0xF1, 0xFF, 0xA1, 0xA7, 0x71, 0xA7, 0x71, 0xA5, 0xFD, 0x5F, 0xD5,
  0xC7, 0x6C, 0x76, 0xC7, 0x6C, 0x76, 0xC7, 0x6C, 0x76, 0xC7, 0x6C, 0x76, 0xC7, 0x6C, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_paint() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_paint_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_quote 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_editor_format_quote_data[] PROGMEM = {
  0xE4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4E, 0x20, 0x3A, 0x0B, 0x60, 0x3A, 0x0B, 0x20,
  0xBA, 0x03, 0x60, 0xBA, 0x81, 0x30, 0x3A, 0x0B, 0x60, 0x3A, 0x0B, 0x20, 0xBA, 0x03, 0x60, 0xBA,
  0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_quote() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 19, 16), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_quote_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_shapes 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_sharp_24_editor_format_shapes_data[] PROGMEM = {
  0xE7, 0x3F, 0xD7, 0x3F, 0x92, 0xFF, 0x2C, 0x2F, 0xF2, 0xF9, 0x73, 0xFD, 0x73, 0xE2, 0xA6, 0x00,
  0xD6, 0xA4, 0xA5, 0x04, 0xA0, 0x45, 0xA4, 0xA5, 0x82, 0xAC, 0xC9, 0x5A, 0x4A, 0x48, 0x31, 0xF7,
  0x7E, 0x5A, 0x4A, 0x48, 0x46, 0xF1, 0x1F, 0x64, 0xA4, 0xA4, 0x84, 0xCD, 0x33, 0xDB, 0x4A, 0x4A,
  0x30, 0x2E, 0x02, 0x3A, 0x4A, 0x38, 0x18, 0xF1, 0x28, 0x11, 0xF8, 0x3A, 0x4A, 0x30, 0xE0, 0xA4,
  0x0B, 0x0D, 0x3A, 0x4A, 0x77, 0xA2, 0xE7, 0x3F, 0xD7, 0x3F, 0x92, 0xFF, 0x2C, 0x2F, 0xF2, 0xF9,
  0x73, 0xFD, 0x73, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_shapes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_shapes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_size 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_editor_format_size_data[] PROGMEM = {
  0x6F, 0xE6, 0xFE, 0x6F, 0xE7, 0x4B, 0x77, 0x2B, 0x5F, 0xA2, 0xB5, 0xFA, 0x2B, 0x5F, 0xA2, 0xB7,
  0x1B, 0x5B, 0x71, 0xB5, 0xB7, 0x1B, 0x5B, 0x71, 0xB5, 0xB7, 0x1B, 0x5B, 0x71, 0xB5, 0xB7, 0x1B,
  0x5B, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_size() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_size_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_strikethrough 24x24, 4-bit Alpha,  RLE, 21 bytes.
static const unsigned char ic_sharp_24_editor_format_strikethrough_data[] PROGMEM = {
  0x2F, 0xF4, 0xFF, 0x4F, 0xF7, 0x2C, 0x77, 0xC7, 0x7C, 0x80, 0xC7, 0x08, 0x0C, 0x0F, 0x80, 0xC7,
  0x0C, 0x77, 0xC7, 0x7C, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_strikethrough() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_strikethrough_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_textdirection_l_to_r 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_editor_format_textdirection_l_to_r_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xF9, 0x40, 0x10, 0xEF, 0xB4, 0x0A, 0xD2, 0xA6, 0x0D, 0xD2, 0xA6, 0x0D, 0xD2,
  0xA6, 0x0A, 0xD2, 0xA6, 0x01, 0x0E, 0xC2, 0xA7, 0x81, 0x1A, 0xDA, 0x2A, 0x73, 0xA2, 0xA7, 0x3A,
  0x2A, 0x73, 0xA2, 0xA7, 0x3A, 0x2A, 0x73, 0xA2, 0xA2, 0x07, 0x77, 0x19, 0x07, 0x77, 0xA0, 0x71,
  0xFF, 0x90, 0x7F, 0xF9, 0x07, 0x75, 0xA0, 0x77, 0x69, 0x07, 0x77, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_textdirection_l_to_r() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_textdirection_l_to_r_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_textdirection_r_to_l 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_sharp_24_editor_format_textdirection_r_to_l_data[] PROGMEM = {
  0x38, 0x11, 0xAD, 0xF9, 0x40, 0x10, 0xEF, 0xB4, 0x0A, 0xD2, 0xA6, 0x0D, 0xD2, 0xA6, 0x0D, 0xD2,
  0xA6, 0x0A, 0xD2, 0xA6, 0x01, 0x0E, 0xC2, 0xA7, 0x81, 0x1A, 0xDA, 0x2A, 0x73, 0xA2, 0xA7, 0x3A,
  0x2A, 0x73, 0xA2, 0xA7, 0x3A, 0x2A, 0x70, 0x72, 0xA2, 0xA6, 0x07, 0x97, 0x60, 0x7A, 0x75, 0x07,
  0xFF, 0x90, 0x7F, 0xF9, 0x10, 0x7A, 0x77, 0x07, 0x97, 0x71, 0x07, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_textdirection_r_to_l() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_textdirection_r_to_l_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_format_underlined 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_24_editor_format_underlined_data[] PROGMEM = {
  0x1A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A,
  0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A, 0x2A, 0x07, 0x60, 0x7A,
  0x28, 0x1E, 0xF9, 0x68, 0x19, 0xFE, 0x28, 0x1C, 0xFD, 0x68, 0x1D, 0xFC, 0x20, 0x6A, 0x09, 0x40,
  0x9A, 0x06, 0x30, 0xCA, 0x82, 0xD9, 0x9D, 0xA0, 0xC4, 0x01, 0x0C, 0xE0, 0xC0, 0x16, 0x84, 0x6C,
  0xEE, 0xC6, 0x77, 0x77, 0x4F, 0xFF, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_format_underlined() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_format_underlined_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_functions 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_sharp_24_editor_functions_data[] PROGMEM = {
  0xFF, 0xFB, 0x07, 0xFC, 0x10, 0x5B, 0x07, 0x71, 0x04, 0xB0, 0x77, 0x10, 0x30, 0xEA, 0x07, 0x71,
  0x03, 0x0E, 0xA0, 0x77, 0x10, 0x20, 0xDA, 0x07, 0x70, 0x20, 0xDA, 0x07, 0x60, 0x30, 0xEA, 0x07,
  0x60, 0x30, 0xEA, 0x07, 0x60, 0x4B, 0x07, 0x60, 0x5B, 0x07, 0x60, 0x7F, 0xFF, 0xFF,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_functions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 17, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_functions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_height 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_sharp_24_editor_height_data[] PROGMEM = {
  0x30, 0x07, 0x50, 0x7A, 0x07, 0x30, 0x7C, 0x81, 0x70, 0x7E, 0x07, 0x3A, 0x6A, 0x6A, 0x6A, 0x6A,
  0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x30, 0x7E, 0x81, 0x70, 0x7C, 0x07, 0x30, 0x7A, 0x07, 0x50, 0x07,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_height() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 3, 15, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_height_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_hexagon 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_sharp_24_editor_hexagon_data[] PROGMEM = {
  0x50, 0x7F, 0xB0, 0x77, 0x20, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x10, 0x9F, 0xD0, 0x97, 0x03, 0xFF,
  0x03, 0x60, 0xCF, 0xF0, 0xC5, 0x05, 0xFF, 0xA0, 0x54, 0x0D, 0xFF, 0xA0, 0xD3, 0x08, 0xFF, 0xC8,
  0x18, 0x02, 0xFF, 0xE0, 0x02, 0xFF, 0xE8, 0x12, 0x08, 0xFF, 0xC0, 0x83, 0x0D, 0xFF, 0xA0, 0xD4,
  0x05, 0xFF, 0xA0, 0x55, 0x0C, 0xFF, 0x0C, 0x60, 0x3F, 0xF0, 0x37, 0x09, 0xFD, 0x09, 0x71, 0x01,
  0x0E, 0xFB, 0x0E, 0x01, 0x72, 0x07, 0xFB, 0x07, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_hexagon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_hexagon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_highlight 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_24_editor_highlight_data[] PROGMEM = {
  0x71, 0xA7, 0x72, 0xA7, 0x20, 0x20, 0x15, 0xA5, 0x85, 0x12, 0x02, 0xED, 0x17, 0x38, 0x61, 0xDE,
  0x21, 0xCF, 0xB7, 0x38, 0x6C, 0xFC, 0x10, 0x1B, 0x37, 0x38, 0x13, 0xB1, 0x77, 0x71, 0xFD, 0x6F,
  0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x60, 0x7F, 0xB0, 0x77, 0x07, 0xF9, 0x07, 0x72, 0x07, 0xE0, 0x77,
  0x4E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_highlight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_highlight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_horizontal_distribute 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_editor_horizontal_distribute_data[] PROGMEM = {
  0xA7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07,
  0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07,
  0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07, 0xA0, 0x76, 0xC6, 0x07,
  0xA0, 0x76, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_horizontal_distribute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_horizontal_distribute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_horizontal_rule 24x24, 4-bit Alpha,  RLE, 3 bytes.
static const unsigned char ic_sharp_24_editor_horizontal_rule_data[] PROGMEM = {
  0xFF, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_horizontal_rule() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 11, 19, 12), Box(0, 0, 23, 23),
      ic_sharp_24_editor_horizontal_rule_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_chart_outlined 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_editor_insert_chart_outlined_data[] PROGMEM = {
  0x80, 0xC2, 0xF7, 0x7C, 0x77, 0xC6, 0xA6, 0xC6, 0xA6, 0xC6, 0xA6, 0xC2, 0xA2, 0xA6, 0xC2, 0xA2,
  0xA6, 0xC2, 0xA2, 0xA6, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2,
  0xC2, 0xA2, 0xA2, 0xA2, 0xC7, 0x7C, 0x77, 0x80, 0xC2, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_chart_outlined() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_chart_outlined_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_chart 24x24, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_sharp_24_editor_insert_chart_data[] PROGMEM = {
  0x80, 0x99, 0x4F, 0x2F, 0xFA, 0x2F, 0xFA, 0x2F, 0xD2, 0xA2, 0xFD, 0x2A, 0x2F, 0xD2, 0xA2, 0xFD,
  0x2A, 0x2A, 0x2F, 0x92, 0xA2, 0xA2, 0xF9, 0x2A, 0x2A, 0x2F, 0x92, 0xA2, 0xA2, 0x80, 0x99, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_comment 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_sharp_24_editor_insert_comment_data[] PROGMEM = {
  0x80, 0x9A, 0x0F, 0x75, 0xF9, 0x75, 0xFF, 0xFF, 0x75, 0xF9, 0x75, 0xFF, 0xFF, 0x75, 0xF9, 0x75,
  0x80, 0x9A, 0x0F, 0x77, 0x20, 0x7B, 0x77, 0x30, 0x7A, 0x77, 0x40, 0x79, 0x77, 0x50, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_drive_file 24x24, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_sharp_24_editor_insert_drive_file_data[] PROGMEM = {
  0xFB, 0x07, 0x5F, 0xA8, 0x1D, 0xF7, 0x4F, 0xA8, 0x21, 0xDF, 0x73, 0xFA, 0x18, 0x21, 0xDF, 0x72,
  0xFA, 0x28, 0x21, 0xDF, 0x71, 0xFA, 0x38, 0x21, 0xDF, 0x7F, 0xA4, 0x01, 0x0D, 0x80, 0xB9, 0x5F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_drive_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_drive_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_emoticon 24x24, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_sharp_24_editor_insert_emoticon_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x67, 0x58, 0x56, 0xFD, 0x05, 0xFC, 0x28, 0x18, 0xE8, 0x48, 0x18, 0xE8,
  0x28, 0x4C, 0xF5, 0xAF, 0x62, 0x81, 0xEF, 0xE4, 0x81, 0xEF, 0xE2, 0x84, 0x6F, 0x9D, 0xF2, 0x28,
  0x18, 0xE8, 0x48, 0x18, 0xE8, 0x28, 0x22, 0xFD, 0xE9, 0x77, 0x29, 0x00, 0xE9, 0x77, 0x29, 0x82,
  0xED, 0xF2, 0x77, 0x84, 0x2F, 0xDA, 0xF6, 0x20, 0xCF, 0x90, 0xC2, 0x84, 0x6F, 0x95, 0xFC, 0x20,
  0x30, 0xEE, 0x0E, 0x03, 0x28, 0x5C, 0xF5, 0x0D, 0xF6, 0x20, 0x30, 0xCC, 0x0C, 0x03, 0x28, 0x16,
  0xFD, 0x20, 0x4A, 0x04, 0x38, 0x23, 0x66, 0x33, 0x04, 0xA0, 0x43, 0x08, 0xA0, 0x67, 0x10, 0x6A,
  0x08, 0x50, 0x8A, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCA, 0x08, 0x70, 0x50, 0xDF, 0x90, 0xD0, 0x47,
  0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_emoticon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_emoticon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_invitation 24x24, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_sharp_24_editor_insert_invitation_data[] PROGMEM = {
  0x3A, 0x71, 0xA6, 0xA7, 0x1A, 0x38, 0x09, 0xB0, 0xF7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0xD2,
  0xC7, 0xD2, 0xC7, 0xD2, 0xC7, 0xD2, 0xC7, 0xD2, 0xC7, 0x7C, 0x77, 0x80, 0xC2, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_invitation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_invitation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_link 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_sharp_24_editor_insert_link_data[] PROGMEM = {
  0x28, 0x14, 0xBE, 0xC2, 0xC8, 0x1E, 0xB4, 0x30, 0x8B, 0x80, 0x0D, 0x28, 0x00, 0xDB, 0x84, 0x80,
  0x4F, 0xE5, 0x75, 0x85, 0x5E, 0xF4, 0xBF, 0x57, 0x78, 0x25, 0xFB, 0xE9, 0x4F, 0x94, 0x90, 0x0E,
  0x94, 0xF9, 0x49, 0x82, 0xEB, 0xF5, 0x77, 0x85, 0x5F, 0xB4, 0xFE, 0x57, 0x58, 0x45, 0xEF, 0x40,
  0x8B, 0x80, 0x0D, 0x28, 0x00, 0xDB, 0x08, 0x38, 0x14, 0xBE, 0xC2, 0xC8, 0x1E, 0xB4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_link() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 16), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_link_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_page_break 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_24_editor_insert_page_break_data[] PROGMEM = {
  0x3F, 0xB0, 0x77, 0x4F, 0xA8, 0x1D, 0xF7, 0x73, 0xFA, 0x82, 0x1D, 0xF7, 0x72, 0xFA, 0x18, 0x21,
  0xDF, 0x77, 0x1F, 0xA2, 0x82, 0x1D, 0xF7, 0x7F, 0xA3, 0x82, 0x1D, 0xF7, 0x6F, 0xA4, 0x01, 0x0D,
  0x96, 0xFF, 0xA6, 0xFF, 0xA8, 0x0D, 0x30, 0xE2, 0xE2, 0xFD, 0x2E, 0x2E, 0x80, 0xD3, 0x0F, 0xFA,
  0x6F, 0xFA, 0x6F, 0xFA, 0x6F, 0xFA, 0x6F, 0xFA, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_page_break() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_page_break_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_insert_photo 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_sharp_24_editor_insert_photo_data[] PROGMEM = {
  0x80, 0xAD, 0x0F, 0x81, 0xE5, 0xEF, 0xB0, 0xCC, 0x81, 0x50, 0x5F, 0xA8, 0x1B, 0x0A, 0xA0, 0x83,
  0x09, 0xF0, 0xD0, 0x12, 0x0C, 0x0B, 0x50, 0xCE, 0x03, 0x30, 0x01, 0x50, 0x20, 0xEC, 0x06, 0x75,
  0x05, 0x80, 0xE4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_insert_photo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_insert_photo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_linear_scale 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_sharp_24_editor_linear_scale_data[] PROGMEM = {
  0x18, 0x13, 0x73, 0x48, 0x21, 0x66, 0x14, 0x83, 0x37, 0x30, 0x6B, 0x06, 0x20, 0x10, 0xDA, 0x0D,
  0x01, 0x20, 0x6B, 0x06, 0x0D, 0xFF, 0xC0, 0x0D, 0xFF, 0xC0, 0xD0, 0x6B, 0x06, 0x20, 0x10, 0xDA,
  0x0D, 0x01, 0x20, 0x6B, 0x83, 0x60, 0x37, 0x34, 0x82, 0x16, 0x61, 0x48, 0x13, 0x73, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_linear_scale() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 9, 21, 14), Box(0, 0, 23, 23),
      ic_sharp_24_editor_linear_scale_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_line_axis 24x24, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_sharp_24_editor_line_axis_data[] PROGMEM = {
  0x68, 0x11, 0xB2, 0x77, 0x28, 0x31, 0xDF, 0xE3, 0x77, 0x01, 0x0D, 0xB0, 0xE0, 0x37, 0x0A, 0x02,
  0x38, 0x71, 0xDF, 0xD2, 0xAF, 0xE4, 0x58, 0x1B, 0xFB, 0x28, 0x31, 0xDF, 0xD1, 0x20, 0x9A, 0x05,
  0x38, 0x90, 0x9F, 0xE2, 0x01, 0xDF, 0xD1, 0x40, 0x7A, 0x89, 0x66, 0x07, 0xFE, 0x30, 0x1D, 0xFD,
  0x10, 0x2B, 0x22, 0x06, 0xA0, 0xAA, 0x04, 0x28, 0x90, 0xBF, 0xD2, 0x02, 0xDF, 0xD2, 0x20, 0x5B,
  0x05, 0x38, 0x42, 0xB2, 0x02, 0xDB, 0x83, 0xD2, 0x03, 0xEA, 0x0A, 0x68, 0x95, 0x1D, 0xFD, 0x3D,
  0xFD, 0x4E, 0xFA, 0xEF, 0xA4, 0x86, 0x1D, 0xFD, 0x10, 0x1D, 0xB8, 0x4A, 0x03, 0xEF, 0xB2, 0x83,
  0x1D, 0xFD, 0x13, 0x82, 0x1D, 0xFC, 0x38, 0x72, 0xDF, 0xB1, 0xDF, 0xD1, 0x58, 0x11, 0xB1, 0x48,
  0x51, 0xB2, 0xBF, 0xD1, 0x77, 0x28, 0x11, 0xB1, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_line_axis() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_line_axis_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_margin 24x24, 4-bit Alpha,  RLE, 21 bytes.
static const unsigned char ic_sharp_24_editor_margin_data[] PROGMEM = {
  0x80, 0x99, 0x0F, 0x2A, 0x2A, 0x2F, 0x92, 0xA2, 0xA2, 0x80, 0xD0, 0xF2, 0xA2, 0xA2, 0xF9, 0x2A,
  0x2A, 0x28, 0x0A, 0xA0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_margin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_margin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_merge_type 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_editor_merge_type_data[] PROGMEM = {
  0x60, 0x01, 0x74, 0x82, 0x1D, 0xD1, 0x72, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x01, 0x0D, 0xC0, 0xD0,
  0x15, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x1A, 0x75, 0xA7, 0x5A, 0x75, 0xA7, 0x5A, 0x74, 0x01, 0xA7,
  0x38, 0x21, 0xCF, 0xC7, 0x28, 0x61, 0xCF, 0xC1, 0x01, 0x15, 0x89, 0x01, 0xCF, 0xC1, 0x01, 0xCC,
  0x13, 0x83, 0x1C, 0xFC, 0x12, 0x89, 0x11, 0xCF, 0xC1, 0x01, 0xCF, 0xC1, 0x48, 0x71, 0xCF, 0xC1,
  0x1C, 0xC1, 0x68, 0x51, 0xCC, 0x10, 0x11, 0x71, 0x00, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_merge_type() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_merge_type_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_mode_comment 24x24, 4-bit Alpha,  RLE, 15 bytes.
static const unsigned char ic_sharp_24_editor_mode_comment_data[] PROGMEM = {
  0x80, 0xCF, 0x4F, 0x77, 0x20, 0x7B, 0x77, 0x30, 0x7A, 0x77, 0x40, 0x79, 0x77, 0x50, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_mode_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_mode_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_mode_edit_outline 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_24_editor_mode_edit_outline_data[] PROGMEM = {
  0x77, 0x02, 0x77, 0x38, 0x14, 0xF8, 0x77, 0x10, 0x40, 0xEA, 0x08, 0x77, 0x07, 0xC0, 0x87, 0x48,
  0x24, 0x50, 0x7C, 0x02, 0x72, 0x04, 0xA8, 0x15, 0x07, 0xA0, 0x47, 0x20, 0x4C, 0x82, 0x50, 0x74,
  0x72, 0x04, 0xE0, 0x57, 0x30, 0x4F, 0x04, 0x72, 0x04, 0xF0, 0x47, 0x20, 0x4F, 0x04, 0x72, 0x04,
  0xF0, 0x47, 0x20, 0x4F, 0x04, 0x72, 0x04, 0xF0, 0x47, 0x20, 0x4F, 0x04, 0x73, 0xF0, 0x47, 0x4E,
  0x04, 0x75, 0xD0, 0x47, 0x6C, 0x04, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_mode_edit_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_mode_edit_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_mode_edit 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_24_editor_mode_edit_data[] PROGMEM = {
  0x77, 0x02, 0x77, 0x38, 0x14, 0xF8, 0x77, 0x10, 0x40, 0xEA, 0x08, 0x77, 0x07, 0xC0, 0x87, 0x48,
  0x24, 0x50, 0x7C, 0x02, 0x72, 0x04, 0xA8, 0x15, 0x07, 0xA0, 0x47, 0x20, 0x4C, 0x82, 0x50, 0x74,
  0x72, 0x04, 0xE0, 0x57, 0x30, 0x4F, 0x04, 0x72, 0x04, 0xF0, 0x47, 0x20, 0x4F, 0x04, 0x72, 0x04,
  0xF0, 0x47, 0x20, 0x4F, 0x04, 0x72, 0x04, 0xF0, 0x47, 0x20, 0x4F, 0x04, 0x73, 0xF0, 0x47, 0x4E,
  0x04, 0x75, 0xD0, 0x47, 0x6C, 0x04, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_mode_edit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_mode_edit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_mode 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_24_editor_mode_data[] PROGMEM = {
  0x77, 0x02, 0x77, 0x38, 0x14, 0xF8, 0x77, 0x10, 0x40, 0xEA, 0x08, 0x77, 0x07, 0xC0, 0x87, 0x48,
  0x24, 0x50, 0x7C, 0x02, 0x72, 0x04, 0xA8, 0x15, 0x07, 0xA0, 0x47, 0x20, 0x4C, 0x82, 0x50, 0x74,
  0x72, 0x04, 0xE0, 0x57, 0x30, 0x4F, 0x04, 0x72, 0x04, 0xF0, 0x47, 0x20, 0x4F, 0x04, 0x72, 0x04,
  0xF0, 0x47, 0x20, 0x4F, 0x04, 0x72, 0x04, 0xF0, 0x47, 0x20, 0x4F, 0x04, 0x73, 0xF0, 0x47, 0x4E,
  0x04, 0x75, 0xD0, 0x47, 0x6C, 0x04, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_monetization_on 24x24, 4-bit Alpha,  RLE, 144 bytes.
static const unsigned char ic_sharp_24_editor_monetization_on_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xC0, 0xB2, 0x09,
  0xC0, 0x85, 0x08, 0xD0, 0xB2, 0x09, 0xD0, 0x83, 0x04, 0xC0, 0xE0, 0x64, 0x06, 0xD0, 0x42, 0x0D,
  0xC8, 0x63, 0x02, 0x77, 0x20, 0x5C, 0x81, 0xD0, 0x5C, 0x82, 0xB0, 0x2E, 0xA8, 0x2E, 0x10, 0xDC,
  0x05, 0x09, 0xC8, 0x1A, 0x03, 0xC8, 0x1B, 0x9E, 0xC0, 0x90, 0xDC, 0x83, 0xE1, 0x04, 0xBF, 0xA0,
  0xD0, 0xED, 0x0B, 0x01, 0x28, 0x11, 0x5C, 0xE0, 0x0E, 0xE8, 0x1E, 0x94, 0x30, 0x8D, 0x0E, 0x0D,
  0xFA, 0x0E, 0x08, 0x20, 0xCC, 0x0D, 0x09, 0xC8, 0x1C, 0x9C, 0xC8, 0x15, 0x08, 0xC0, 0x90, 0x5C,
  0x81, 0xA0, 0x4C, 0x81, 0x40, 0x9C, 0x81, 0x50, 0xDC, 0x87, 0x30, 0x37, 0x73, 0x01, 0xDB, 0x0D,
  0x20, 0x4C, 0x0E, 0x06, 0x40, 0x40, 0xCC, 0x04, 0x30, 0x8D, 0x0B, 0x20, 0x8D, 0x08, 0x50, 0x8C,
  0x0B, 0x20, 0x9C, 0x08, 0x70, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_monetization_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_monetization_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_money_off_csred 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_24_editor_money_off_csred_data[] PROGMEM = {
  0x7B, 0x68, 0x12, 0xC2, 0x4B, 0x68, 0x2A, 0xFD, 0x22, 0x09, 0xB0, 0x90, 0x25, 0x86, 0xBF, 0xD2,
  0x03, 0xEE, 0xA0, 0xE0, 0x35, 0x82, 0xBF, 0xD2, 0x48, 0x1A, 0xFC, 0x68, 0x2B, 0xFD, 0x23, 0x01,
  0xA0, 0x15, 0x05, 0xA0, 0xD0, 0x27, 0x40, 0x10, 0xDA, 0x0D, 0x02, 0x74, 0x02, 0x0C, 0xA0, 0xD0,
  0x27, 0x58, 0x35, 0xCF, 0xD2, 0x76, 0x82, 0xBF, 0xD2, 0x76, 0x82, 0xBF, 0xD2, 0x68, 0x18, 0xFA,
  0x48, 0x2B, 0xFD, 0x25, 0x03, 0xA0, 0x63, 0x07, 0xA0, 0xD0, 0x25, 0x07, 0xB0, 0xDB, 0x82, 0xEF,
  0xD2, 0x50, 0x30, 0xAB, 0x84, 0xA5, 0x0B, 0xFC, 0x7B, 0x40, 0xA0, 0x37, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_money_off_csred() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_money_off_csred_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_money_off 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_24_editor_money_off_data[] PROGMEM = {
  0x7B, 0x68, 0x12, 0xC2, 0x4B, 0x68, 0x2A, 0xFD, 0x22, 0x09, 0xB0, 0x90, 0x25, 0x86, 0xBF, 0xD2,
  0x03, 0xEE, 0xA0, 0xE0, 0x35, 0x82, 0xBF, 0xD2, 0x48, 0x1A, 0xFC, 0x68, 0x2B, 0xFD, 0x23, 0x01,
  0xA0, 0x15, 0x05, 0xA0, 0xD0, 0x27, 0x40, 0x10, 0xDA, 0x0D, 0x02, 0x74, 0x02, 0x0C, 0xA0, 0xD0,
  0x27, 0x58, 0x35, 0xCF, 0xD2, 0x76, 0x82, 0xBF, 0xD2, 0x76, 0x82, 0xBF, 0xD2, 0x68, 0x18, 0xFA,
  0x48, 0x2B, 0xFD, 0x25, 0x03, 0xA0, 0x63, 0x07, 0xA0, 0xD0, 0x25, 0x07, 0xB0, 0xDB, 0x82, 0xEF,
  0xD2, 0x50, 0x30, 0xAB, 0x84, 0xA5, 0x0B, 0xFC, 0x7B, 0x40, 0xA0, 0x37, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_money_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_money_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_move_down 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_sharp_24_editor_move_down_data[] PROGMEM = {
  0x38, 0x21, 0x7C, 0xEB, 0x2F, 0xA2, 0x05, 0x0E, 0xE2, 0xFA, 0x10, 0x5A, 0x0A, 0x03, 0x6A, 0x5A,
  0x82, 0x1E, 0xF7, 0x71, 0xA5, 0xA8, 0x17, 0xFA, 0x72, 0xA5, 0xA8, 0x1C, 0xF3, 0x72, 0xFA, 0x0E,
  0x97, 0x3F, 0xA8, 0x1E, 0xF1, 0x77, 0x48, 0x1C, 0xF4, 0x77, 0x48, 0x17, 0xFB, 0x20, 0x07, 0x5F,
  0xA8, 0x31, 0xEF, 0x82, 0xA0, 0x74, 0xFA, 0x10, 0x5A, 0x0B, 0x0A, 0xA0, 0x73, 0xFA, 0x20, 0x50,
  0xED, 0x07, 0x2F, 0xA3, 0x81, 0x17, 0xCB, 0x07, 0x2F, 0xA5, 0x05, 0xA0, 0x73, 0xFA, 0x40, 0x2A,
  0x07, 0x4F, 0xA5, 0x00, 0x77, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_move_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_move_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_move_up 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_sharp_24_editor_move_up_data[] PROGMEM = {
  0x50, 0x07, 0x77, 0x40, 0x2A, 0x07, 0x4F, 0xA5, 0x05, 0xA0, 0x73, 0xFA, 0x38, 0x11, 0x7C, 0xB0,
  0x72, 0xFA, 0x20, 0x50, 0xED, 0x07, 0x2F, 0xA1, 0x05, 0xA0, 0xB0, 0xAA, 0x07, 0x3F, 0xA8, 0x31,
  0xEF, 0x82, 0xA0, 0x74, 0xFA, 0x81, 0x7F, 0xB2, 0x00, 0x75, 0xFA, 0x81, 0xCF, 0x47, 0x74, 0x81,
  0xEF, 0x17, 0x74, 0x0E, 0x97, 0x3F, 0xA8, 0x1C, 0xF3, 0x72, 0xFA, 0x81, 0x7F, 0xA7, 0x2A, 0x5A,
  0x82, 0x1E, 0xF7, 0x71, 0xA5, 0xA1, 0x05, 0xA0, 0xA0, 0x36, 0xA5, 0xA2, 0x05, 0x0E, 0xE2, 0xFA,
  0x38, 0x21, 0x7C, 0xEB, 0x2F, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_move_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_move_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_multiline_chart 24x24, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_sharp_24_editor_multiline_chart_data[] PROGMEM = {
  0x38, 0x72, 0x7B, 0xDF, 0xDC, 0x83, 0x60, 0x32, 0x02, 0x0A, 0xFA, 0x0B, 0x02, 0x38, 0x95, 0x4F,
  0x85, 0xEF, 0xE9, 0x41, 0x01, 0x38, 0xEA, 0x89, 0x06, 0x03, 0xEF, 0x77, 0xF9, 0x17, 0x10, 0x9A,
  0x82, 0x8E, 0xF9, 0x20, 0x35, 0x04, 0x50, 0x6B, 0x0A, 0x71, 0x81, 0x8F, 0x85, 0x0D, 0xA0, 0x27,
  0x07, 0xB0, 0x83, 0x0B, 0xB0, 0x96, 0x07, 0xA0, 0xBA, 0x86, 0x80, 0x9F, 0xE5, 0xFE, 0x50, 0x7A,
  0x81, 0x70, 0x7A, 0x86, 0xCF, 0xE3, 0x0B, 0xF5, 0x30, 0x7A, 0x07, 0x30, 0x7B, 0x04, 0x28, 0x16,
  0xFA, 0x20, 0x7A, 0x07, 0x58, 0x17, 0xF5, 0x38, 0x33, 0xFD, 0x07, 0xA0, 0x77, 0x03, 0x58, 0x47,
  0x70, 0x7F, 0x77, 0x74, 0x03, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_multiline_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_multiline_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_notes 24x24, 4-bit Alpha,  RLE, 13 bytes.
static const unsigned char ic_sharp_24_editor_notes_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0E, 0x20, 0x80, 0xC0, 0xF8, 0x0E, 0x20, 0xFD, 0x6F, 0xD6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_notes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 17), Box(0, 0, 23, 23),
      ic_sharp_24_editor_notes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_numbers 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_24_editor_numbers_data[] PROGMEM = {
  0x68, 0x11, 0xFD, 0x38, 0x11, 0xFD, 0x72, 0x81, 0x5F, 0x93, 0x81, 0x5F, 0x97, 0x28, 0x19, 0xF5,
  0x38, 0x19, 0xF5, 0x72, 0x81, 0xDF, 0x13, 0x81, 0xDF, 0x14, 0x01, 0xFF, 0x98, 0x1D, 0x05, 0xFF,
  0x90, 0x95, 0x81, 0x9F, 0x53, 0x81, 0x9F, 0x57, 0x28, 0x1D, 0xF1, 0x38, 0x1D, 0xF1, 0x71, 0x81,
  0x1F, 0xD3, 0x81, 0x1F, 0xD7, 0x28, 0x15, 0xF9, 0x38, 0x15, 0xF9, 0x50, 0x9F, 0xF9, 0x81, 0x50,
  0xDF, 0xF9, 0x01, 0x48, 0x11, 0xFD, 0x38, 0x11, 0xFD, 0x72, 0x81, 0x5F, 0x93, 0x81, 0x5F, 0x97,
  0x28, 0x19, 0xF5, 0x38, 0x19, 0xF5, 0x72, 0x81, 0xDF, 0x13, 0x81, 0xDF, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_numbers() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_numbers_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_padding 24x24, 4-bit Alpha,  RLE, 12 bytes.
static const unsigned char ic_sharp_24_editor_padding_data[] PROGMEM = {
  0x80, 0x99, 0x0F, 0x2A, 0x2A, 0x2F, 0x92, 0xA2, 0xA2, 0x80, 0xBB, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_padding() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_padding_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_pentagon 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_sharp_24_editor_pentagon_data[] PROGMEM = {
  0x71, 0x82, 0x1A, 0xA1, 0x77, 0x10, 0x30, 0xDA, 0x0D, 0x03, 0x76, 0x08, 0xE0, 0x87, 0x30, 0x20,
  0xCF, 0x90, 0xC0, 0x27, 0x06, 0xFD, 0x06, 0x40, 0x10, 0xBF, 0xF8, 0x3B, 0x10, 0x5E, 0xFF, 0xA8,
  0x1E, 0x5C, 0xFF, 0xC0, 0xC0, 0x7F, 0xFC, 0x07, 0x02, 0xFF, 0xC8, 0x12, 0x0C, 0xFF, 0xA0, 0xC2,
  0x07, 0xFF, 0xA0, 0x72, 0x02, 0xFF, 0xA0, 0x23, 0x0C, 0xFF, 0x0C, 0x40, 0x7F, 0xF0, 0x74, 0x02,
  0xFF, 0x02, 0x50, 0xCF, 0xD0, 0xC6, 0x07, 0xFD, 0x07, 0x60, 0x2F, 0xD0, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_pentagon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_pentagon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_pie_chart_outline 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_sharp_24_editor_pie_chart_outline_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0xA8, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x63, 0xA3, 0x06, 0xA0, 0x83, 0x04, 0xA0, 0x44, 0xA4,
  0x04, 0xA0, 0x42, 0x81, 0xDF, 0x65, 0xA5, 0x85, 0x6F, 0xD0, 0x5F, 0xD6, 0xA6, 0x84, 0xCF, 0x59,
  0xF6, 0x6A, 0x68, 0x46, 0xF9, 0xDF, 0x26, 0xA6, 0x82, 0x2F, 0xDE, 0x97, 0xFB, 0x00, 0xE9, 0x7F,
  0xB8, 0x2E, 0xDF, 0x26, 0xA6, 0x84, 0x2F, 0xD9, 0xF6, 0x6A, 0x68, 0x46, 0xF9, 0x5F, 0xD6, 0xA6,
  0x85, 0xCF, 0x50, 0xDF, 0x65, 0xA5, 0x81, 0x6F, 0xD2, 0x04, 0xA0, 0x44, 0xA4, 0x04, 0xA0, 0x43,
  0x08, 0xA0, 0x63, 0xA3, 0x06, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0xA8, 0x12, 0x6C, 0xA0, 0x87,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_pie_chart_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_pie_chart_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_pie_chart 24x24, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_sharp_24_editor_pie_chart_data[] PROGMEM = {
  0x68, 0x15, 0xAE, 0x28, 0x1D, 0xB6, 0x73, 0x05, 0x0E, 0xB2, 0xB0, 0xE0, 0x57, 0x09, 0xD2, 0xD0,
  0x95, 0x09, 0xE2, 0xE0, 0x93, 0x05, 0xF2, 0xF0, 0x52, 0x0D, 0xF2, 0xF8, 0x1E, 0x05, 0xF9, 0x2F,
  0x90, 0x50, 0xAF, 0x92, 0xF9, 0x0B, 0x0D, 0xF9, 0x2F, 0x90, 0x0E, 0xF9, 0x74, 0x0E, 0xF9, 0x74,
  0x0D, 0xF9, 0x2F, 0x90, 0xE0, 0xAF, 0x92, 0xF9, 0x0B, 0x05, 0xF9, 0x2F, 0x98, 0x15, 0x0D, 0xF2,
  0xF0, 0xE2, 0x05, 0xF2, 0xF0, 0x53, 0x09, 0xE2, 0xE0, 0x95, 0x09, 0xD2, 0xD0, 0x97, 0x05, 0x0E,
  0xB2, 0xB0, 0xE0, 0x57, 0x38, 0x15, 0xAE, 0x28, 0x1D, 0xB6, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_pie_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_pie_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_polyline 24x24, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_sharp_24_editor_polyline_data[] PROGMEM = {
  0x7E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x74, 0x08, 0xE7, 0x30, 0x6A, 0x04, 0x76, 0x04, 0xA0,
  0x67, 0x3E, 0x07, 0x74, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x07, 0x74, 0xF0, 0xE0, 0x77, 0x70, 0x30,
  0xBA, 0x0E, 0x07, 0x1E, 0x70, 0x30, 0xBA, 0x0E, 0xE7, 0x20, 0x30, 0xBF, 0x74, 0x03, 0xE7, 0x5E,
  0x75, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_polyline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_polyline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_post_add 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_24_editor_post_add_data[] PROGMEM = {
  0x77, 0xA7, 0x73, 0xA7, 0x73, 0xA3, 0xFA, 0x2F, 0xFB, 0x2F, 0xB7, 0x5A, 0x3A, 0x75, 0xA3, 0xA2,
  0xF9, 0x2A, 0x3A, 0x2F, 0x97, 0xA7, 0x73, 0xA2, 0xF9, 0x2A, 0x3A, 0x2F, 0x92, 0xA3, 0xA7, 0x5A,
  0x3A, 0x2F, 0x92, 0xA3, 0xA2, 0xF9, 0x2A, 0x3A, 0x75, 0xA3, 0xA7, 0x5A, 0x3A, 0x80, 0x90, 0xBA,
  0x3F, 0xFA, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_post_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_post_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_publish 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_sharp_24_editor_publish_data[] PROGMEM = {
  0xFF, 0xFF, 0x77, 0x60, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x20, 0x7C, 0x07, 0x70, 0x7E, 0x07, 0x50,
  0x7F, 0x90, 0x73, 0x07, 0xFB, 0x81, 0x70, 0x7F, 0xD0, 0x74, 0xE7, 0x1E, 0x71, 0xE7, 0x1E, 0x71,
  0xE7, 0x1E, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_publish() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 18, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_publish_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_query_stats 24x24, 4-bit Alpha,  RLE, 149 bytes.
static const unsigned char ic_sharp_24_editor_query_stats_data[] PROGMEM = {
  0x77, 0x60, 0xB0, 0x37, 0x75, 0x81, 0x8F, 0xB7, 0x74, 0x03, 0xA0, 0x27, 0x74, 0x81, 0xCF, 0x87,
  0x50, 0x40, 0x54, 0x81, 0x7F, 0xD7, 0x68, 0x1D, 0xE1, 0x28, 0x22, 0xEF, 0x47, 0x50, 0x8A, 0x0A,
  0x28, 0x1B, 0xF9, 0x70, 0x40, 0x63, 0x02, 0xA8, 0x5E, 0xF5, 0x5F, 0xE1, 0x78, 0x1D, 0xF4, 0x28,
  0x7B, 0xF8, 0x44, 0x11, 0x54, 0x70, 0x8A, 0x83, 0xE2, 0x5F, 0xD2, 0x82, 0x14, 0x52, 0x70, 0x3A,
  0x86, 0xBF, 0xDE, 0xF5, 0x07, 0xC0, 0x96, 0x83, 0xCF, 0x80, 0xBA, 0x81, 0xB0, 0x7A, 0x83, 0xAA,
  0xEF, 0xA4, 0x81, 0x6F, 0xD2, 0x83, 0x1D, 0xF2, 0x1A, 0x03, 0x28, 0x22, 0xEF, 0x32, 0x82, 0x1E,
  0xF4, 0x38, 0x42, 0x60, 0x4F, 0xA4, 0x81, 0x8F, 0x72, 0x81, 0xAF, 0xA7, 0x81, 0x5F, 0xA4, 0x81,
  0x7F, 0x82, 0x81, 0x5D, 0x17, 0x82, 0x1F, 0xE2, 0x38, 0x1D, 0xF4, 0x76, 0x84, 0x9F, 0xE8, 0x7D,
  0xA0, 0x17, 0x70, 0xAE, 0x0C, 0x01, 0x77, 0x87, 0x37, 0x84, 0x1C, 0xFC, 0x17, 0x74, 0x82, 0x1C,
  0xFB, 0x77, 0x58, 0x11, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_query_stats() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_editor_query_stats_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_rectangle 24x24, 4-bit Alpha,  RLE, 3 bytes.
static const unsigned char ic_sharp_24_editor_rectangle_data[] PROGMEM = {
  0x80, 0xCF, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_rectangle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_rectangle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_scatter_plot 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_sharp_24_editor_scatter_plot_data[] PROGMEM = {
  0x58, 0x28, 0xDD, 0x87, 0x40, 0x8C, 0x08, 0x73, 0x0D, 0xC0, 0xD7, 0x30, 0xDC, 0x0D, 0x73, 0x08,
  0xC0, 0x87, 0x48, 0x28, 0xDD, 0x88, 0x0C, 0x40, 0x82, 0x8D, 0xD8, 0x74, 0x08, 0xC0, 0x87, 0x30,
  0xDC, 0x0D, 0x73, 0x0D, 0xC0, 0xD5, 0x81, 0x25, 0x32, 0x08, 0xC0, 0x84, 0x07, 0xB0, 0x92, 0x82,
  0x8D, 0xD8, 0x40, 0x2D, 0x05, 0x72, 0x05, 0xD0, 0x87, 0x20, 0x3D, 0x06, 0x73, 0x09, 0xB0, 0xC7,
  0x58, 0x15, 0x86, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_scatter_plot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_scatter_plot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_schema 24x24, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_sharp_24_editor_schema_data[] PROGMEM = {
  0xF7, 0x3F, 0x73, 0xF7, 0x3F, 0x73, 0xF7, 0x3F, 0x75, 0x81, 0x7F, 0x77, 0x78, 0x17, 0xF7, 0x75,
  0xF3, 0xFF, 0x38, 0x0D, 0x4F, 0x3F, 0xF3, 0xF2, 0x81, 0x7F, 0x77, 0x78, 0x17, 0xF7, 0x75, 0xF7,
  0x3F, 0x73, 0xF7, 0x3F, 0x73, 0xF7, 0x3F, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_schema() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_editor_schema_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_score 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_sharp_24_editor_score_data[] PROGMEM = {
  0x80, 0xC4, 0xF4, 0x91, 0x82, 0x7F, 0x22, 0xF9, 0x89, 0x07, 0x73, 0x0F, 0x07, 0x70, 0xCF, 0x98,
  0x73, 0x31, 0x0F, 0x04, 0x07, 0xFA, 0x18, 0x61, 0x33, 0xF0, 0x40, 0x7F, 0xA1, 0x87, 0x37, 0x7F,
  0x07, 0x70, 0xCF, 0x94, 0x91, 0x84, 0x7F, 0x22, 0xFD, 0xFF, 0xA0, 0xD0, 0x1F, 0x00, 0xDE, 0x0D,
  0x01, 0x1E, 0x82, 0xD1, 0x1D, 0xC8, 0x2D, 0x10, 0x7D, 0x0D, 0x01, 0x20, 0x10, 0xDA, 0x82, 0xD1,
  0x07, 0xD8, 0x92, 0xD1, 0x07, 0x70, 0x1D, 0xD1, 0x07, 0xE8, 0x11, 0x07, 0xA8, 0x47, 0x01, 0x10,
  0x7F, 0x10, 0x7C, 0x07, 0x20, 0x7F, 0x90, 0x7E, 0x00, 0x78, 0x0C, 0x7F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_shape_line 24x24, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_sharp_24_editor_shape_line_data[] PROGMEM = {
  0x28, 0x44, 0xBE, 0xEB, 0x47, 0x71, 0x08, 0xE0, 0x87, 0x82, 0x8D, 0xD8, 0x20, 0x4F, 0x90, 0x45,
  0x08, 0xC8, 0x18, 0x0B, 0xF9, 0x0B, 0x50, 0xDC, 0x81, 0xD0, 0xEF, 0x90, 0xE5, 0x0D, 0xC8, 0x1D,
  0x0E, 0xF9, 0x0E, 0x40, 0x10, 0xDC, 0x81, 0x80, 0xBF, 0x90, 0xB3, 0x85, 0x1C, 0xFD, 0xDD, 0x82,
  0x04, 0xF9, 0x04, 0x28, 0x31, 0xCF, 0xC1, 0x60, 0x8E, 0x08, 0x28, 0x31, 0xCF, 0xC1, 0x71, 0x84,
  0x4B, 0xEE, 0xB4, 0x28, 0x31, 0xCF, 0xC1, 0x77, 0x28, 0x31, 0xCF, 0xC1, 0x77, 0x28, 0x31, 0xCF,
  0xC1, 0x77, 0x28, 0x31, 0xCF, 0xC1, 0x77, 0x28, 0x31, 0xCF, 0xC1, 0x2F, 0xA5, 0x83, 0x1C, 0xFC,
  0x13, 0xFA, 0x28, 0x58, 0xDD, 0xDF, 0xC1, 0x4F, 0xA1, 0x08, 0xC0, 0xD0, 0x15, 0xFA, 0x10, 0xDC,
  0x0D, 0x6F, 0xA1, 0x0D, 0xC0, 0xD6, 0xFA, 0x10, 0x8C, 0x08, 0x6F, 0xA2, 0x82, 0x8D, 0xD8, 0x7F,
  0xA7, 0x6F, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_shape_line() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_editor_shape_line_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_short_text 24x24, 4-bit Alpha,  RLE, 8 bytes.
static const unsigned char ic_sharp_24_editor_short_text_data[] PROGMEM = {
  0xFF, 0xFF, 0xC7, 0x77, 0x74, 0xFB, 0x6F, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_short_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 19, 14), Box(0, 0, 23, 23),
      ic_sharp_24_editor_short_text_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_show_chart 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_editor_show_chart_data[] PROGMEM = {
  0x77, 0x40, 0x37, 0x74, 0x81, 0x4F, 0x87, 0x72, 0x82, 0x3E, 0xF7, 0x77, 0x18, 0x22, 0xEF, 0x97,
  0x10, 0x46, 0x82, 0x1D, 0xFA, 0x71, 0x81, 0x8F, 0x85, 0x81, 0xCF, 0xC7, 0x10, 0x7B, 0x08, 0x38,
  0x2B, 0xFD, 0x17, 0x07, 0xA0, 0xBA, 0x84, 0x80, 0x9F, 0xE2, 0x70, 0x7A, 0x81, 0x70, 0x7A, 0x82,
  0xCF, 0xE3, 0x70, 0x7A, 0x07, 0x30, 0x7B, 0x04, 0x70, 0x7A, 0x07, 0x58, 0x17, 0xF5, 0x70, 0x7A,
  0x07, 0x70, 0x37, 0x18, 0x17, 0xF7, 0x77, 0x40, 0x37, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_show_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_show_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_space_bar 24x24, 4-bit Alpha,  RLE, 9 bytes.
static const unsigned char ic_sharp_24_editor_space_bar_data[] PROGMEM = {
  0xA7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xFF, 0xFF, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_space_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 19, 14), Box(0, 0, 23, 23),
      ic_sharp_24_editor_space_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_square 24x24, 4-bit Alpha,  RLE, 3 bytes.
static const unsigned char ic_sharp_24_editor_square_data[] PROGMEM = {
  0x80, 0xD8, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_square() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_square_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_stacked_line_chart 24x24, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_sharp_24_editor_stacked_line_chart_data[] PROGMEM = {
  0x77, 0x40, 0x37, 0x74, 0x81, 0x4F, 0x87, 0x72, 0x82, 0x3E, 0xF7, 0x77, 0x18, 0x22, 0xEF, 0x97,
  0x10, 0x46, 0x82, 0x1D, 0xFA, 0x71, 0x81, 0x8F, 0x85, 0x81, 0xCF, 0xC7, 0x10, 0x7B, 0x08, 0x38,
  0x4B, 0xFD, 0x10, 0x35, 0x07, 0xA0, 0xBA, 0x89, 0x08, 0x09, 0xFE, 0x20, 0x4F, 0x83, 0x07, 0xA8,
  0x17, 0x07, 0xA8, 0x7C, 0xFE, 0x30, 0x3E, 0xF7, 0x20, 0x7A, 0x07, 0x30, 0x7B, 0x84, 0x40, 0x2E,
  0xF9, 0x20, 0x7A, 0x07, 0x20, 0x42, 0x86, 0x7F, 0x50, 0x1D, 0xFA, 0x20, 0x7A, 0x07, 0x28, 0x18,
  0xF8, 0x20, 0x32, 0x81, 0xCF, 0xC3, 0x81, 0x7F, 0x72, 0x07, 0xB0, 0x83, 0x82, 0xBF, 0xD1, 0x40,
  0x32, 0x07, 0xA0, 0xBA, 0x84, 0x80, 0x9F, 0xE2, 0x70, 0x7A, 0x81, 0x70, 0x7A, 0x82, 0xCF, 0xE3,
  0x70, 0x7A, 0x07, 0x30, 0x7B, 0x04, 0x70, 0x7A, 0x07, 0x58, 0x17, 0xF5, 0x70, 0x7A, 0x07, 0x70,
  0x37, 0x18, 0x17, 0xF7, 0x77, 0x40, 0x37, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_stacked_line_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_stacked_line_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_strikethrough_s 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_sharp_24_editor_strikethrough_s_data[] PROGMEM = {
  0x68, 0x57, 0xCE, 0xFD, 0x92, 0x72, 0x02, 0x0D, 0xF0, 0x57, 0x10, 0xBA, 0x82, 0xD7, 0x6A, 0xA0,
  0xE0, 0x16, 0x01, 0xA0, 0xE0, 0x13, 0x0A, 0xA0, 0x76, 0x01, 0xA0, 0xE4, 0x82, 0x37, 0x74, 0x70,
  0xDA, 0x0C, 0x03, 0x77, 0x76, 0x80, 0xC0, 0xF7, 0x30, 0x60, 0xEA, 0x05, 0x68, 0x27, 0xDD, 0x54,
  0x08, 0xA0, 0x86, 0x06, 0xA0, 0xB4, 0x08, 0xA0, 0x87, 0x0D, 0xA8, 0x2C, 0x65, 0x9B, 0x04, 0x70,
  0x20, 0xDF, 0x09, 0x73, 0x85, 0x7B, 0xEF, 0xEA, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_strikethrough_s() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 17), Box(0, 0, 23, 23),
      ic_sharp_24_editor_strikethrough_s_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_subscript 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_sharp_24_editor_subscript_data[] PROGMEM = {
  0x07, 0xA0, 0x24, 0x02, 0xA0, 0x76, 0x81, 0xCF, 0xB4, 0x81, 0xCF, 0xC7, 0x03, 0xA0, 0x62, 0x06,
  0xA0, 0x37, 0x18, 0x68, 0xFE, 0x11, 0xEF, 0x87, 0x38, 0x4D, 0xF9, 0x9F, 0xD7, 0x40, 0x4C, 0x04,
  0x75, 0x0A, 0xA0, 0xA7, 0x50, 0x10, 0xEA, 0x0D, 0x75, 0x84, 0x9F, 0xEE, 0xF9, 0x73, 0x03, 0xA0,
  0x05, 0xA0, 0x37, 0x28, 0x1D, 0xFB, 0x28, 0x1B, 0xFD, 0x71, 0x82, 0x8F, 0xE2, 0x28, 0x22, 0xEF,
  0x82, 0xC0, 0x2A, 0x07, 0x40, 0x7A, 0x02, 0x49, 0x81, 0xCF, 0xC6, 0x81, 0xCF, 0xC1, 0xC7, 0x69,
  0x77, 0x2C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_subscript() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_subscript_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_superscript 24x24, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_sharp_24_editor_superscript_data[] PROGMEM = {
  0x76, 0xC7, 0x72, 0x90, 0x7A, 0x02, 0x40, 0x2A, 0x07, 0x1C, 0x18, 0x1C, 0xFB, 0x48, 0x1C, 0xFC,
  0x29, 0x40, 0x3A, 0x06, 0x20, 0x6A, 0x03, 0x2C, 0x28, 0x68, 0xFE, 0x11, 0xEF, 0x87, 0x38, 0x4D,
  0xF9, 0x9F, 0xD7, 0x40, 0x4C, 0x04, 0x75, 0x0A, 0xA0, 0xA7, 0x50, 0x10, 0xEA, 0x0D, 0x75, 0x84,
  0x9F, 0xEE, 0xF9, 0x73, 0x03, 0xA0, 0x05, 0xA0, 0x37, 0x28, 0x1D, 0xFB, 0x28, 0x1B, 0xFD, 0x71,
  0x82, 0x8F, 0xE2, 0x28, 0x22, 0xEF, 0x86, 0x02, 0xA0, 0x74, 0x07, 0xA0, 0x25, 0x81, 0xCF, 0xC6,
  0x81, 0xCF, 0xC5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_superscript() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_superscript_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_table_chart 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_sharp_24_editor_table_chart_data[] PROGMEM = {
  0x80, 0x9B, 0x3F, 0x80, 0xC2, 0x0D, 0x2D, 0x2F, 0xB2, 0xD2, 0xFB, 0x2D, 0x2F, 0xB2, 0xD2, 0xFB,
  0x2D, 0x2F, 0xB2, 0xD2, 0xFB, 0x2D, 0x2F, 0xB2, 0xD2, 0xFB, 0x2D, 0x2F, 0xB2, 0xD2, 0xFB, 0x2D,
  0x2D,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_table_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_table_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_table_rows 24x24, 4-bit Alpha,  RLE, 14 bytes.
static const unsigned char ic_sharp_24_editor_table_rows_data[] PROGMEM = {
  0x80, 0x98, 0x4F, 0x80, 0xC0, 0x08, 0x09, 0x84, 0xF8, 0x0C, 0x00, 0x80, 0x98, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_table_rows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_editor_table_rows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_text_decrease 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_sharp_24_editor_text_decrease_data[] PROGMEM = {
  0x58, 0x1E, 0xFE, 0x77, 0x40, 0x4B, 0x04, 0x77, 0x38, 0x3A, 0xFD, 0xFA, 0x77, 0x20, 0x1A, 0x03,
  0xA0, 0x17, 0x71, 0x85, 0x6F, 0xB0, 0xBF, 0x67, 0x71, 0x85, 0xCF, 0x60, 0x6F, 0xC7, 0x70, 0x3A,
  0x81, 0x10, 0x1A, 0x03, 0x3F, 0x92, 0x81, 0x8F, 0xB3, 0x81, 0xBF, 0x83, 0xF9, 0x28, 0x7E, 0xFC,
  0x99, 0x9C, 0xFE, 0x75, 0x04, 0xFA, 0x04, 0x74, 0x81, 0xAF, 0xB8, 0x01, 0x58, 0x1B, 0xFA, 0x73,
  0x01, 0xA0, 0x45, 0x04, 0xA0, 0x17, 0x28, 0x16, 0xFE, 0x78, 0x1E, 0xF6, 0x72, 0x81, 0xCF, 0x97,
  0x81, 0x9F, 0xC7, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_text_decrease() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_text_decrease_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_text_fields 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_sharp_24_editor_text_fields_data[] PROGMEM = {
  0x07, 0xFD, 0x07, 0x60, 0x7F, 0xD0, 0x76, 0x07, 0xFD, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x72, 0x07,
  0xA0, 0x77, 0x72, 0x07, 0xA8, 0x17, 0x07, 0xF9, 0x07, 0x50, 0x7A, 0x81, 0x70, 0x7F, 0x90, 0x75,
  0x07, 0xA8, 0x17, 0x07, 0xF9, 0x07, 0x50, 0x7A, 0x07, 0x40, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x74,
  0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x40, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x74, 0x07, 0xA0, 0x77,
  0x10, 0x7A, 0x07, 0x40, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x74, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07,
  0x40, 0x7A, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_text_fields() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_text_fields_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_text_increase 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_sharp_24_editor_text_increase_data[] PROGMEM = {
  0x58, 0x1E, 0xFE, 0x77, 0x40, 0x4B, 0x04, 0x77, 0x38, 0x3A, 0xFD, 0xFA, 0x77, 0x20, 0x1A, 0x03,
  0xA0, 0x17, 0xA6, 0x85, 0x6F, 0xB0, 0xBF, 0x67, 0xA6, 0x85, 0xCF, 0x60, 0x6F, 0xC7, 0xA5, 0x03,
  0xA8, 0x11, 0x01, 0xA0, 0x33, 0xF9, 0x28, 0x18, 0xFB, 0x38, 0x1B, 0xF8, 0x3F, 0x92, 0x87, 0xEF,
  0xC9, 0x99, 0xCF, 0xE6, 0xA4, 0x04, 0xFA, 0x04, 0x5A, 0x48, 0x1A, 0xFB, 0x80, 0x15, 0x81, 0xBF,
  0xA5, 0xA3, 0x01, 0xA0, 0x45, 0x04, 0xA0, 0x17, 0x28, 0x16, 0xFE, 0x78, 0x1E, 0xF6, 0x72, 0x81,
  0xCF, 0x97, 0x81, 0x9F, 0xC7, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_text_increase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_text_increase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_title 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_sharp_24_editor_title_data[] PROGMEM = {
  0x80, 0xC6, 0xF5, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07,
  0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07,
  0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_title() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 18, 18), Box(0, 0, 23, 23),
      ic_sharp_24_editor_title_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_type_specimen 24x24, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_sharp_24_editor_type_specimen_data[] PROGMEM = {
  0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0x00, 0x8F, 0xA2, 0xE0, 0xC2, 0x0C, 0xF9, 0x2E, 0x82,
  0x62, 0x26, 0xF9, 0x2E, 0x82, 0x17, 0x71, 0xF9, 0x2D, 0x84, 0xA0, 0xDD, 0x0A, 0xF2, 0xD8, 0x44,
  0x2D, 0xD2, 0x5F, 0x2C, 0x0E, 0x60, 0xEE, 0x2C, 0x86, 0x80, 0xAB, 0xBB, 0x08, 0xE2, 0xC0, 0x20,
  0x4C, 0x04, 0x03, 0xE2, 0xB8, 0x1E, 0x7B, 0xC8, 0x1B, 0x7E, 0xD2, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF,
  0xC7, 0x74, 0xA7, 0x74, 0xFF, 0xA4, 0xFF, 0xA4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_type_specimen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_type_specimen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_vertical_align_bottom 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_sharp_24_editor_vertical_align_bottom_data[] PROGMEM = {
  0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x40,
  0x7E, 0x07, 0x72, 0x07, 0xC0, 0x77, 0x40, 0x7A, 0x07, 0x76, 0x00, 0x78, 0x0C, 0x30, 0xFF, 0xFF,
  0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_vertical_align_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_vertical_align_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_vertical_align_center 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_sharp_24_editor_vertical_align_center_data[] PROGMEM = {
  0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x40, 0x7E, 0x07, 0x72, 0x07, 0xC0, 0x77, 0x40, 0x7A, 0x07,
  0x76, 0x00, 0x78, 0x0C, 0x30, 0xFF, 0xFF, 0xC8, 0x0C, 0x30, 0x00, 0x77, 0x60, 0x7A, 0x07, 0x74,
  0x07, 0xC0, 0x77, 0x20, 0x7E, 0x07, 0x74, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_vertical_align_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_sharp_24_editor_vertical_align_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_vertical_align_top 24x24, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_sharp_24_editor_vertical_align_top_data[] PROGMEM = {
  0xFF, 0xFF, 0xC8, 0x0C, 0x30, 0x00, 0x77, 0x60, 0x7A, 0x07, 0x74, 0x07, 0xC0, 0x77, 0x20, 0x7E,
  0x07, 0x74, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_vertical_align_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_vertical_align_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_vertical_distribute 24x24, 4-bit Alpha,  RLE, 20 bytes.
static const unsigned char ic_sharp_24_editor_vertical_distribute_data[] PROGMEM = {
  0x80, 0xC4, 0xF8, 0x09, 0xF1, 0x08, 0x06, 0x77, 0x3F, 0xB7, 0x3F, 0xB7, 0x38, 0x06, 0x78, 0x09,
  0xF1, 0x08, 0x0C, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_vertical_distribute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_editor_vertical_distribute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_editor_wrap_text 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_sharp_24_editor_wrap_text_data[] PROGMEM = {
  0xFF, 0xA1, 0xFF, 0xA8, 0x09, 0x81, 0x0F, 0xE8, 0x1D, 0xA1, 0x1F, 0xF9, 0x0E, 0x01, 0x77, 0x81,
  0x8F, 0xA7, 0x71, 0x00, 0xD7, 0x30, 0x74, 0x00, 0xD7, 0x20, 0x79, 0x38, 0x18, 0xFA, 0xE2, 0x07,
  0xE0, 0xE0, 0x1E, 0x20, 0x7C, 0x81, 0xDA, 0x17, 0x30, 0x79, 0x77, 0x20, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_editor_wrap_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_editor_wrap_text_data, Alpha4(color::Black));
  return value;
}
