#include "content.h"

using namespace roo_display;

// Image file ic_sharp_24_content_add_box 24x24, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_sharp_24_content_add_box_data[] PROGMEM = {
  0x80, 0x99, 0x4F, 0x2F, 0xFA, 0x2F, 0xFA, 0x2F, 0xFA, 0x2F, 0xD7, 0x3F, 0x97, 0x3F, 0xD2, 0xFF,
  0xA2, 0xFF, 0xA2, 0xFF, 0xA2, 0x80, 0x99, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_add_box() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_add_box_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_add_circle_outline 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_sharp_24_content_add_circle_outline_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x65, 0xA5, 0x85, 0x6F, 0xD0, 0x5F, 0xC6, 0xA6, 0x84, 0xCF, 0x59, 0xF6,
  0x6A, 0x68, 0x46, 0xF9, 0xDF, 0x26, 0xA6, 0x82, 0x2F, 0xDE, 0x93, 0xFB, 0x39, 0x00, 0xE9, 0x3F,
  0xB3, 0x98, 0x2E, 0xDF, 0x26, 0xA6, 0x84, 0x2F, 0xD9, 0xF6, 0x6A, 0x68, 0x46, 0xF9, 0x5F, 0xC6,
  0xA6, 0x85, 0xCF, 0x50, 0xDF, 0x65, 0xA5, 0x81, 0x6F, 0xD2, 0x04, 0xA0, 0x47, 0x30, 0x4A, 0x04,
  0x30, 0x8A, 0x06, 0x71, 0x06, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_add_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_add_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_add_circle 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_24_content_add_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xF2, 0xF8, 0x1D, 0x05, 0xF9, 0x2F, 0x90, 0x50,
  0x9F, 0x92, 0xF9, 0x09, 0x0D, 0xF9, 0x2F, 0x90, 0xD0, 0xEC, 0x73, 0xC0, 0x0E, 0xC7, 0x3C, 0x0E,
  0x0D, 0xF9, 0x2F, 0x90, 0xD0, 0x9F, 0x92, 0xF9, 0x09, 0x05, 0xF9, 0x2F, 0x98, 0x15, 0x0D, 0xF2,
  0xF0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9,
  0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_add_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_add_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_add_link 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_24_content_add_link_data[] PROGMEM = {
  0x28, 0x14, 0xBE, 0xC2, 0xC8, 0x1E, 0xB4, 0x30, 0x8B, 0x80, 0x0D, 0x28, 0x00, 0xDB, 0x84, 0x80,
  0x4F, 0xE5, 0x75, 0x85, 0x5E, 0xF4, 0xBF, 0x57, 0x78, 0x25, 0xFB, 0xE9, 0x4F, 0x94, 0x90, 0x0E,
  0x94, 0xF9, 0x1A, 0x38, 0x1B, 0xF5, 0x75, 0xA3, 0x82, 0x4F, 0xE5, 0x74, 0xA4, 0x08, 0xB8, 0x00,
  0xD3, 0xF9, 0x28, 0x14, 0xBE, 0xC3, 0xF9, 0x77, 0x1A, 0x77, 0x4A, 0x77, 0x4A, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_add_link() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_add_link_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_add 24x24, 4-bit Alpha,  RLE, 20 bytes.
static const unsigned char ic_sharp_24_content_add_data[] PROGMEM = {
  0x6A, 0x75, 0xA7, 0x5A, 0x75, 0xA7, 0x5A, 0x75, 0xA6, 0xFF, 0xFF, 0x6A, 0x75, 0xA7, 0x5A, 0x75,
  0xA7, 0x5A, 0x75, 0xA6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 18, 18), Box(0, 0, 23, 23),
      ic_sharp_24_content_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_amp_stories 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_sharp_24_content_amp_stories_data[] PROGMEM = {
  0x4F, 0xB7, 0x1F, 0xB4, 0xA2, 0xFB, 0x2C, 0x2F, 0xB2, 0xC2, 0xFB, 0x2C, 0x2F, 0xB2, 0xC2, 0xFB,
  0x2C, 0x2F, 0xB2, 0xC2, 0xFB, 0x2C, 0x2F, 0xB2, 0xC2, 0xFB, 0x2C, 0x2F, 0xB2, 0xC2, 0xFB, 0x2A,
  0x4F, 0xB7, 0x1F, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_amp_stories() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 18), Box(0, 0, 23, 23),
      ic_sharp_24_content_amp_stories_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_archive 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_24_content_archive_data[] PROGMEM = {
  0x10, 0x20, 0xEF, 0xD8, 0x4E, 0x20, 0x1D, 0x87, 0x58, 0x29, 0xD1, 0xBF, 0xFA, 0x0B, 0x80, 0x99,
  0x3F, 0x4F, 0xF4, 0xFB, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xF0, 0xD0, 0x16, 0x01, 0x0D, 0xFA, 0x0D,
  0x01, 0x40, 0x10, 0xDF, 0xC0, 0xD0, 0x12, 0x01, 0x0D, 0xFE, 0x82, 0xD1, 0x1D, 0xFF, 0x90, 0x0D,
  0x80, 0xF2, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_archive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_archive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_attribution 24x24, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_sharp_24_content_attribution_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x62, 0x82, 0x2D, 0xD2, 0x20, 0x6A, 0x08, 0x30, 0x5A,
  0x04, 0x30, 0x6A, 0x06, 0x30, 0x4A, 0x04, 0x28, 0x1D, 0xF6, 0x48, 0x22, 0xDD, 0x24, 0x85, 0x6F,
  0xD0, 0x5F, 0xC4, 0x84, 0x57, 0x77, 0x75, 0x48, 0x4C, 0xF5, 0xAF, 0x64, 0x0B, 0xC0, 0xB4, 0x84,
  0x6F, 0x9D, 0xF2, 0x40, 0xBC, 0x0B, 0x48, 0x22, 0xFD, 0xE9, 0x50, 0xBC, 0x0B, 0x59, 0x00, 0xE9,
  0x50, 0xBC, 0x0B, 0x59, 0x82, 0xED, 0xF2, 0x40, 0xBC, 0x0B, 0x48, 0x42, 0xFD, 0xAF, 0x64, 0x05,
  0x09, 0xA0, 0x90, 0x54, 0x84, 0x6F, 0xA5, 0xFC, 0x50, 0x3A, 0x03, 0x58, 0x5C, 0xF5, 0x0D, 0xF6,
  0x40, 0x3A, 0x03, 0x48, 0x16, 0xFD, 0x20, 0x5A, 0x04, 0x30, 0x3A, 0x03, 0x30, 0x4A, 0x04, 0x30,
  0x8A, 0x06, 0x20, 0x3A, 0x03, 0x20, 0x6A, 0x08, 0x50, 0x8A, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCA,
  0x08, 0x70, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_attribution() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_attribution_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_backspace 24x24, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_sharp_24_content_backspace_data[] PROGMEM = {
  0x50, 0x5F, 0xFC, 0x40, 0x10, 0xEF, 0xFC, 0x40, 0xAF, 0xFD, 0x30, 0x5F, 0xFE, 0x20, 0x10, 0xED,
  0x81, 0xC3, 0xEC, 0x81, 0xE3, 0xCD, 0x20, 0xAE, 0x82, 0x30, 0x2E, 0xA8, 0x2E, 0x20, 0x3D, 0x10,
  0x5F, 0x89, 0x0E, 0x20, 0x2E, 0xE2, 0x02, 0xED, 0x01, 0x0E, 0xF9, 0x86, 0xE2, 0x02, 0x20, 0x2E,
  0xE0, 0xAF, 0xB0, 0xE0, 0x22, 0x02, 0x0E, 0xF0, 0xAF, 0xB0, 0xE0, 0x22, 0x02, 0x0E, 0xF0, 0x10,
  0xEF, 0x98, 0x6E, 0x20, 0x22, 0x02, 0xEE, 0x10, 0x5F, 0x89, 0x0E, 0x20, 0x2E, 0xE2, 0x02, 0xED,
  0x20, 0xAE, 0x82, 0x30, 0x2E, 0xA8, 0x2E, 0x20, 0x3D, 0x20, 0x10, 0xED, 0x81, 0xC3, 0xEC, 0x81,
  0xE3, 0xCD, 0x30, 0x5F, 0xFE, 0x40, 0xAF, 0xFD, 0x40, 0x10, 0xEF, 0xFC, 0x50, 0x5F, 0xFC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_backspace() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_backspace_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_ballot 24x24, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_sharp_24_content_ballot_data[] PROGMEM = {
  0x80, 0xE5, 0xF5, 0xFE, 0x1B, 0x1A, 0x80, 0x17, 0xE1, 0xB1, 0xA5, 0xE1, 0xB1, 0xA8, 0x01, 0x7E,
  0x58, 0x0D, 0x5F, 0x5F, 0xE1, 0xB1, 0xA8, 0x01, 0x7E, 0x1B, 0x1A, 0x5E, 0x1B, 0x1A, 0x80, 0x17,
  0xE5, 0x80, 0xF4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_ballot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_ballot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_biotech 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_sharp_24_content_biotech_data[] PROGMEM = {
  0x58, 0x22, 0x99, 0x37, 0x30, 0x5B, 0x01, 0x72, 0x0C, 0xB0, 0x77, 0x20, 0x40, 0xBA, 0x0C, 0x71,
  0x82, 0x27, 0x28, 0xA0, 0x25, 0x84, 0x40, 0xDF, 0xD1, 0xA0, 0x84, 0x85, 0x7F, 0x1D, 0xFD, 0x1A,
  0x0D, 0x30, 0x4A, 0x83, 0x32, 0x72, 0x8B, 0x04, 0x28, 0x1B, 0xF7, 0x40, 0x9A, 0x0C, 0x01, 0x28,
  0x1E, 0xF1, 0x48, 0x22, 0x5D, 0x73, 0x81, 0xEF, 0x17, 0x48, 0x1B, 0xF7, 0x74, 0x04, 0xA0, 0x70,
  0x17, 0x30, 0x8F, 0xC3, 0x81, 0x4B, 0xEF, 0x96, 0xB7, 0x4B, 0x6F, 0xFF, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_biotech() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_biotech_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_block 24x24, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_sharp_24_content_block_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x7A, 0x08, 0x30, 0x4A, 0x04, 0x71, 0x01,
  0x0C, 0xB0, 0x42, 0x81, 0xDF, 0x67, 0x18, 0x91, 0x1C, 0xFC, 0x7F, 0xD0, 0x5F, 0xC7, 0x18, 0x92,
  0x1C, 0xFC, 0x10, 0xCF, 0x59, 0xF6, 0x78, 0x31, 0xCF, 0xC1, 0x28, 0x46, 0xF9, 0xDF, 0x26, 0x83,
  0x1C, 0xFC, 0x13, 0x82, 0x2F, 0xDE, 0x96, 0x83, 0x1C, 0xFC, 0x15, 0x90, 0x0E, 0x95, 0x83, 0x1C,
  0xFC, 0x16, 0x98, 0x2E, 0xDF, 0x23, 0x83, 0x1C, 0xFC, 0x16, 0x84, 0x2F, 0xD9, 0xF6, 0x28, 0x31,
  0xCF, 0xC1, 0x78, 0x92, 0x6F, 0x95, 0xFC, 0x01, 0xCF, 0xC1, 0x71, 0x89, 0x1C, 0xF5, 0x0D, 0xF7,
  0xCF, 0xC1, 0x71, 0x81, 0x6F, 0xD2, 0x04, 0xB0, 0xC0, 0x17, 0x10, 0x4A, 0x04, 0x30, 0x8A, 0x07,
  0x71, 0x06, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9,
  0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_block() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_block_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_bolt 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_24_content_bolt_data[] PROGMEM = {
  0x50, 0x40, 0xE7, 0x20, 0x0C, 0x71, 0x81, 0x6F, 0x97, 0x82, 0x1E, 0xF7, 0x70, 0x8A, 0x05, 0x60,
  0x2B, 0x03, 0x60, 0xAB, 0x01, 0x50, 0x4F, 0x82, 0xE1, 0x0C, 0xF8, 0x16, 0x06, 0xF0, 0xC2, 0x0E,
  0xF0, 0x45, 0x01, 0xB0, 0xB6, 0x03, 0xB0, 0x26, 0x05, 0xA0, 0x87, 0x82, 0x7F, 0xE1, 0x78, 0x19,
  0xF6, 0x71, 0x0C, 0x0D, 0x72, 0x0E, 0x04, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_bolt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 17, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_bolt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_calculate 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_24_content_calculate_data[] PROGMEM = {
  0x80, 0xF4, 0xF8, 0x39, 0x6F, 0x69, 0xE8, 0x92, 0xCB, 0xBB, 0xBE, 0xF7, 0x02, 0x07, 0xE0, 0x34,
  0x0B, 0xA8, 0x13, 0x03, 0xF8, 0x92, 0xCB, 0xBB, 0xBE, 0xF6, 0x03, 0x06, 0xFE, 0x83, 0x97, 0xF7,
  0x9F, 0xFF, 0xD0, 0x70, 0xBF, 0xFA, 0x10, 0x7B, 0x80, 0x13, 0xE8, 0x47, 0x70, 0x37, 0xB9, 0x80,
  0x13, 0xE5, 0x07, 0x98, 0x01, 0xBF, 0x91, 0x07, 0xB5, 0xF9, 0x10, 0x7B, 0x80, 0x1B, 0x80, 0xE5,
  0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_calculate() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_calculate_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_change_circle 24x24, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_sharp_24_content_change_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8E, 0x07, 0xF0, 0x83, 0x04, 0xE0, 0x61, 0xF9, 0x04, 0x20, 0xDD, 0x07, 0x28, 0x11, 0x4A, 0xD8,
  0x1D, 0x05, 0xE0, 0xB2, 0x82, 0x61, 0x07, 0xD0, 0x50, 0x9C, 0x83, 0xBC, 0xFB, 0x1A, 0x81, 0x50,
  0xBC, 0x09, 0x0D, 0xC0, 0x40, 0x3A, 0x0C, 0xB0, 0x20, 0x4C, 0x0D, 0x0E, 0xC0, 0x10, 0x6E, 0x06,
  0x01, 0xC0, 0x0E, 0xC0, 0x10, 0x6E, 0x06, 0x01, 0xC0, 0xE0, 0xDC, 0x04, 0x02, 0xB0, 0xCA, 0x03,
  0x04, 0xC0, 0xD0, 0x9C, 0x89, 0x0B, 0x05, 0xEF, 0x1B, 0xFC, 0xBC, 0x09, 0x05, 0xD8, 0x27, 0x01,
  0x62, 0x0B, 0xE8, 0x15, 0x0D, 0xD0, 0xB0, 0x43, 0x07, 0xD0, 0xD2, 0x04, 0xF9, 0x10, 0x6E, 0x04,
  0x30, 0x8F, 0x07, 0xE0, 0x85, 0x08, 0xFD, 0x08, 0x70, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65,
  0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_change_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_change_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_clear 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_24_content_clear_data[] PROGMEM = {
  0x81, 0x2B, 0x17, 0x18, 0x51, 0xB2, 0xBF, 0xC1, 0x68, 0x71, 0xCF, 0xB1, 0xCF, 0xC1, 0x48, 0x91,
  0x1C, 0xFC, 0x10, 0x1C, 0xFC, 0x12, 0x83, 0x1C, 0xFC, 0x13, 0x89, 0x01, 0xCF, 0xC1, 0x1C, 0xFC,
  0x15, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x70, 0x10, 0xCA, 0x0C, 0x01, 0x71, 0x01, 0x0C, 0xA0, 0xC0,
  0x17, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x58, 0x90, 0x1C, 0xFC, 0x11, 0xCF, 0xC1, 0x38, 0x31, 0xCF,
  0xC1, 0x28, 0x91, 0x1C, 0xFC, 0x10, 0x1C, 0xFC, 0x14, 0x87, 0x1C, 0xFC, 0x1B, 0xFC, 0x16, 0x85,
  0x1C, 0xFB, 0x2B, 0x17, 0x18, 0x11, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 18, 18), Box(0, 0, 23, 23),
      ic_sharp_24_content_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_content_copy 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_24_content_content_copy_data[] PROGMEM = {
  0xFF, 0x5F, 0xF5, 0xA7, 0x73, 0xA7, 0x73, 0xA2, 0xFF, 0xB2, 0xFF, 0xB2, 0xA7, 0x4C, 0x2A, 0x74,
  0xC2, 0xA7, 0x4C, 0x2A, 0x74, 0xC2, 0xA7, 0x4C, 0x2A, 0x74, 0xC2, 0xA7, 0x4C, 0x2A, 0x74, 0xC2,
  0xA7, 0x4C, 0x2A, 0x74, 0xA4, 0xA7, 0x4A, 0x4A, 0x74, 0xA4, 0xA7, 0x4A, 0x4A, 0x74, 0xA4, 0xFF,
  0x94, 0xFF, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_content_copy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_content_copy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_content_cut 24x24, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_sharp_24_content_content_cut_data[] PROGMEM = {
  0x18, 0x41, 0xAD, 0xDA, 0x17, 0x60, 0x10, 0xEC, 0x0E, 0x01, 0x71, 0x07, 0xB8, 0x6A, 0xFB, 0x11,
  0xBF, 0xA7, 0x07, 0xB8, 0x27, 0xDF, 0x12, 0x81, 0x1F, 0xD6, 0x07, 0xB8, 0x37, 0x0D, 0xF1, 0x28,
  0x11, 0xFE, 0x50, 0x7B, 0x07, 0x28, 0x6A, 0xFB, 0x11, 0xBF, 0xB4, 0x07, 0xB0, 0x73, 0x01, 0x0E,
  0xE0, 0x72, 0x07, 0xB0, 0x75, 0x83, 0x1A, 0xDE, 0xBB, 0x81, 0x70, 0x7A, 0x07, 0x74, 0x07, 0xB8,
  0x27, 0x07, 0x77, 0x68, 0x37, 0xFC, 0xC7, 0x77, 0x18, 0x47, 0xFC, 0xCF, 0x77, 0x60, 0x7E, 0x07,
  0x78, 0x31, 0xAD, 0xEB, 0xB0, 0x07, 0xB0, 0x75, 0x01, 0x0E, 0xE0, 0x72, 0x07, 0xB0, 0x74, 0x86,
  0xAF, 0xB1, 0x1B, 0xFB, 0x40, 0x7B, 0x07, 0x38, 0x1D, 0xF1, 0x28, 0x11, 0xFE, 0x50, 0x7B, 0x07,
  0x28, 0x1D, 0xF1, 0x28, 0x11, 0xFD, 0x60, 0x7B, 0x89, 0x07, 0x0A, 0xFB, 0x11, 0xBF, 0xA7, 0x07,
  0xB8, 0x17, 0x1E, 0xC0, 0xE0, 0x17, 0x10, 0x7B, 0x18, 0x41, 0xAD, 0xDA, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_content_cut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_content_cut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_content_paste_go 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_sharp_24_content_content_paste_go_data[] PROGMEM = {
  0x78, 0x28, 0xEE, 0x87, 0x70, 0x8C, 0x08, 0x7F, 0x90, 0x03, 0xF9, 0x1F, 0x90, 0x03, 0xF9, 0x1A,
  0x2F, 0xB2, 0xA1, 0xA2, 0xFB, 0x2A, 0x1A, 0x2F, 0xB2, 0xA1, 0xA7, 0x7A, 0x1A, 0x77, 0xA1, 0xA7,
  0x7A, 0x1A, 0x77, 0x3A, 0x77, 0x3A, 0x75, 0x00, 0x73, 0xA7, 0x40, 0x2A, 0x07, 0x2A, 0x75, 0x05,
  0xA0, 0x71, 0xA7, 0xFA, 0x07, 0xA7, 0xFA, 0x07, 0xA7, 0x50, 0x5A, 0x07, 0x1F, 0x60, 0x2A, 0x07,
  0x2F, 0x70, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_content_paste_go() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_content_paste_go_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_content_paste_off 24x24, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_sharp_24_content_content_paste_off_data[] PROGMEM = {
  0x72, 0x82, 0x8E, 0xE8, 0x77, 0x10, 0x8C, 0x08, 0x68, 0x11, 0xC7, 0x20, 0xAC, 0x00, 0x3F, 0x90,
  0x4A, 0x07, 0x20, 0xAB, 0x00, 0x3F, 0x91, 0x05, 0xA0, 0x72, 0x0A, 0xF9, 0x2A, 0x2B, 0x07, 0x20,
  0xAF, 0x2A, 0x2C, 0x07, 0x20, 0xAE, 0x2A, 0x2A, 0x05, 0xA0, 0x77, 0x3A, 0x2A, 0x10, 0x5A, 0x07,
  0x72, 0xA2, 0xA2, 0x05, 0xA0, 0x77, 0x1A, 0x2A, 0x30, 0x5A, 0x07, 0x7A, 0x2A, 0x40, 0x5A, 0x07,
  0x6A, 0x2A, 0x50, 0x5A, 0x07, 0x5A, 0x2A, 0x60, 0x5A, 0x07, 0x4A, 0x2A, 0x70, 0x5A, 0x07, 0x3A,
  0x2A, 0x71, 0x05, 0xA0, 0x72, 0x0A, 0x92, 0xA7, 0x20, 0x5A, 0x07, 0x20, 0xA2, 0xA7, 0x30, 0x5A,
  0x07, 0x4F, 0xFA, 0x07, 0x3F, 0xFB, 0x07, 0x77, 0x38, 0x15, 0xFC, 0x77, 0x40, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_content_paste_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_content_paste_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_content_paste 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_sharp_24_content_content_paste_data[] PROGMEM = {
  0x78, 0x28, 0xEE, 0x87, 0x60, 0x8C, 0x08, 0x6F, 0x90, 0x03, 0xFF, 0xA0, 0x03, 0xFB, 0x2F, 0xB2,
  0xC2, 0xFB, 0x2C, 0x2F, 0xB2, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C,
  0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x78, 0x0C, 0x2F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_content_paste() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_content_paste_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_content_paste_search 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_sharp_24_content_content_paste_search_data[] PROGMEM = {
  0x78, 0x28, 0xEE, 0x87, 0x71, 0x08, 0xC0, 0x87, 0x1F, 0x90, 0x03, 0xF9, 0x2F, 0x90, 0x03, 0xF9,
  0x2A, 0x2F, 0xB2, 0xA2, 0xA2, 0xFB, 0x2A, 0x2A, 0x2F, 0xB2, 0xA2, 0xA7, 0x7A, 0x2A, 0x77, 0xA2,
  0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x28, 0x37, 0xCE, 0xC7, 0x4A, 0x71, 0x0B, 0xD0, 0xB3, 0xA7, 0x87,
  0x7F, 0xD3, 0x03, 0xDF, 0x72, 0xA7, 0x81, 0xCF, 0x43, 0x81, 0x4F, 0xC2, 0xA7, 0x0E, 0x95, 0x90,
  0xE2, 0xA7, 0x81, 0xCF, 0x43, 0x81, 0x4F, 0xC2, 0xA7, 0x87, 0x7F, 0xD3, 0x03, 0xDF, 0x72, 0xF3,
  0x0B, 0xE0, 0xC0, 0x11, 0xF4, 0x87, 0x7C, 0xEC, 0x7C, 0xFC, 0x17, 0x72, 0x82, 0x1C, 0xFB, 0x77,
  0x38, 0x11, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_content_paste_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_content_paste_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_copy_all 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_content_copy_all_data[] PROGMEM = {
  0x4F, 0xE4, 0xFE, 0x4A, 0x72, 0xA4, 0xA7, 0x2C, 0x2A, 0x72, 0xC2, 0xA7, 0x2A, 0x4A, 0x72, 0xA0,
  0x07, 0x2A, 0x72, 0xC2, 0xA7, 0x2A, 0x00, 0x72, 0xA7, 0x2A, 0x4A, 0x72, 0xC2, 0xA7, 0x2C, 0x2A,
  0x72, 0xA4, 0xA7, 0x2A, 0x00, 0x72, 0xFF, 0x92, 0xFE, 0x00, 0x77, 0x77, 0x74, 0xA1, 0x81, 0x7F,
  0x71, 0xA1, 0x81, 0x7F, 0x74, 0xA1, 0x81, 0x7F, 0x71, 0xA1, 0x81, 0x7F, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_copy_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_copy_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_create 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_24_content_create_data[] PROGMEM = {
  0x77, 0x02, 0x77, 0x38, 0x14, 0xF8, 0x77, 0x10, 0x40, 0xEA, 0x08, 0x77, 0x07, 0xC0, 0x87, 0x48,
  0x24, 0x50, 0x7C, 0x02, 0x72, 0x04, 0xA8, 0x15, 0x07, 0xA0, 0x47, 0x20, 0x4C, 0x82, 0x50, 0x74,
  0x72, 0x04, 0xE0, 0x57, 0x30, 0x4F, 0x04, 0x72, 0x04, 0xF0, 0x47, 0x20, 0x4F, 0x04, 0x72, 0x04,
  0xF0, 0x47, 0x20, 0x4F, 0x04, 0x72, 0x04, 0xF0, 0x47, 0x20, 0x4F, 0x04, 0x73, 0xF0, 0x47, 0x4E,
  0x04, 0x75, 0xD0, 0x47, 0x6C, 0x04, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_create() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_create_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_delete_sweep 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_sharp_24_content_delete_sweep_data[] PROGMEM = {
  0x30, 0x7C, 0x07, 0x74, 0xFD, 0x71, 0xFD, 0x77, 0x77, 0x1F, 0xB2, 0xF1, 0xFB, 0x2F, 0x1F, 0xB7,
  0x3F, 0xB7, 0x3F, 0xB2, 0xE2, 0xFB, 0x2E, 0x2F, 0xB7, 0x3F, 0xB7, 0x3F, 0xB2, 0xC4, 0xFB, 0x2C,
  0x4F, 0xB7, 0x3F, 0xB7, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_delete_sweep() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_delete_sweep_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_deselect 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_sharp_24_content_deselect_data[] PROGMEM = {
  0x81, 0x1C, 0x73, 0xA2, 0xA2, 0xA2, 0xA0, 0x4A, 0x07, 0x20, 0xA9, 0x2A, 0x2A, 0x2A, 0x10, 0x5A,
  0x07, 0x77, 0x30, 0x5A, 0x07, 0x77, 0x2C, 0x07, 0x20, 0xAE, 0x2A, 0x2A, 0x05, 0xA0, 0x72, 0x0A,
  0xD2, 0xA5, 0x05, 0xA0, 0x75, 0xA7, 0x3B, 0x07, 0x4A, 0x6A, 0x2C, 0x07, 0x3A, 0x2A, 0x2A, 0x2A,
  0x05, 0xA0, 0x72, 0x0A, 0x92, 0xA6, 0xA1, 0x05, 0xA0, 0x72, 0x0A, 0x73, 0xA2, 0x05, 0xA0, 0x77,
  0x1A, 0x2F, 0x90, 0x73, 0xA2, 0xA2, 0xFA, 0x07, 0x20, 0xA9, 0x76, 0x05, 0xA0, 0x77, 0x73, 0x05,
  0xA0, 0x74, 0xA2, 0xA2, 0xA2, 0xC0, 0x73, 0xA2, 0xA2, 0xA2, 0xA0, 0x5A, 0x07, 0x77, 0x38, 0x15,
  0xFC, 0x77, 0x40, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_deselect() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_deselect_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_drafts 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_24_content_drafts_data[] PROGMEM = {
  0x71, 0x82, 0x2A, 0xA2, 0x77, 0x10, 0x8C, 0x08, 0x75, 0x89, 0x05, 0xDF, 0xD4, 0x4D, 0xFD, 0x57,
  0x18, 0x33, 0xBF, 0xE7, 0x48, 0x37, 0xEF, 0xB3, 0x40, 0x10, 0x9A, 0x09, 0x01, 0x60, 0x10, 0x9A,
  0x86, 0x91, 0x06, 0xEF, 0xC3, 0x73, 0x86, 0x3C, 0xFE, 0x6F, 0xE6, 0x77, 0x06, 0x0E, 0xB0, 0xA0,
  0x17, 0x50, 0x10, 0xAD, 0x0E, 0x06, 0x73, 0x06, 0x0E, 0xF9, 0x0C, 0x03, 0x60, 0x30, 0xCF, 0xD0,
  0x84, 0x08, 0xFF, 0x98, 0x2D, 0x44, 0xD8, 0x0A, 0xA0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_drafts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_drafts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_dynamic_feed 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_sharp_24_content_dynamic_feed_data[] PROGMEM = {
  0x71, 0xFD, 0x71, 0xFD, 0x71, 0xFD, 0x71, 0xFD, 0x71, 0xA7, 0x1A, 0x4A, 0x2A, 0x71, 0xA4, 0xA2,
  0xA7, 0x1A, 0x4A, 0x2A, 0x71, 0xA4, 0xA2, 0xFF, 0x2A, 0x2F, 0xF2, 0xA7, 0x7A, 0x2A, 0x77, 0xA2,
  0xFC, 0x5A, 0x2F, 0xC5, 0xA7, 0x74, 0xA7, 0x74, 0xFC, 0x72, 0xFC, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_dynamic_feed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_dynamic_feed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_file_copy 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_sharp_24_content_file_copy_data[] PROGMEM = {
  0xFF, 0x5F, 0xF5, 0xA7, 0x73, 0xA7, 0x73, 0xA2, 0xFA, 0x07, 0x5A, 0x2F, 0x98, 0x1D, 0xF7, 0x4A,
  0x2F, 0x98, 0x21, 0xDF, 0x73, 0xA2, 0xF9, 0x18, 0x21, 0xDF, 0x72, 0xA2, 0xF9, 0x28, 0x21, 0xDF,
  0x71, 0xA2, 0xF9, 0x38, 0x21, 0xDF, 0x7A, 0x2F, 0x94, 0x01, 0x0D, 0xB2, 0xFF, 0xB2, 0xFF, 0xB2,
  0xFF, 0xB2, 0xFF, 0xB2, 0xFF, 0x94, 0xFF, 0x94, 0xFF, 0x94, 0xFF, 0x94, 0xFF, 0x94, 0xFF, 0x94,
  0xFF, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_file_copy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_file_copy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_filter_list_off 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_sharp_24_content_filter_list_off_data[] PROGMEM = {
  0x81, 0x1C, 0x77, 0x73, 0x04, 0xA0, 0x77, 0x73, 0x05, 0xA0, 0x77, 0x73, 0xB0, 0x72, 0x0A, 0xFC,
  0x2C, 0x07, 0x20, 0xAF, 0xB4, 0x05, 0xA0, 0x77, 0x73, 0x05, 0xA0, 0x77, 0x73, 0x05, 0xA0, 0x77,
  0x71, 0xD0, 0x72, 0x0A, 0xB7, 0x1E, 0x07, 0x20, 0xAA, 0x75, 0x05, 0xA0, 0x77, 0x73, 0x05, 0xA0,
  0x77, 0x73, 0x05, 0xA0, 0x77, 0x7E, 0x07, 0x76, 0xC0, 0x5A, 0x07, 0x77, 0x30, 0x5A, 0x07, 0x77,
  0x30, 0x5A, 0x07, 0x77, 0x30, 0x5A, 0x07, 0x77, 0x38, 0x15, 0xFC, 0x77, 0x40, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_filter_list_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_filter_list_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_filter_list 24x24, 4-bit Alpha,  RLE, 13 bytes.
static const unsigned char ic_sharp_24_content_filter_list_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0E, 0x50, 0xFD, 0x6F, 0xD8, 0x0F, 0x40, 0xC7, 0x7C, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_filter_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 17), Box(0, 0, 23, 23),
      ic_sharp_24_content_filter_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_flag_circle 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_sharp_24_content_flag_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xC6, 0x0B, 0xD8, 0x1D, 0x05, 0xD6, 0x03, 0xE0,
  0x50, 0x9D, 0x73, 0xB0, 0x90, 0xDD, 0x73, 0xB0, 0xD0, 0xED, 0x73, 0xB0, 0x0E, 0xD7, 0x3B, 0x0E,
  0x0D, 0xD1, 0x07, 0xA0, 0x35, 0xB0, 0xD0, 0x9D, 0x10, 0x7A, 0x0B, 0x5B, 0x09, 0x05, 0xD1, 0x07,
  0xFC, 0x81, 0x50, 0xDC, 0x10, 0x7F, 0xB0, 0xD2, 0x04, 0xC1, 0x07, 0xFB, 0x04, 0x30, 0x8F, 0xF0,
  0x85, 0x08, 0xFD, 0x08, 0x70, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_flag_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_flag_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_flag 24x24, 4-bit Alpha,  RLE, 20 bytes.
static const unsigned char ic_sharp_24_content_flag_data[] PROGMEM = {
  0xFA, 0x01, 0x5F, 0xA0, 0x45, 0x80, 0x9E, 0x6F, 0x50, 0x4F, 0xA5, 0x01, 0xFA, 0x76, 0xA7, 0x6A,
  0x76, 0xA7, 0x6A, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_flag() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_flag_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_font_download_off 24x24, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_sharp_24_content_font_download_off_data[] PROGMEM = {
  0x10, 0x40, 0x72, 0x0A, 0xFF, 0xA8, 0x21, 0xEF, 0x72, 0x0A, 0xFF, 0x91, 0x05, 0xA0, 0x72, 0x0A,
  0xFF, 0x2B, 0x07, 0x20, 0xAF, 0xE2, 0xC0, 0x72, 0x0A, 0x0B, 0x20, 0xBF, 0x92, 0xD0, 0x72, 0x02,
  0x20, 0x5F, 0x92, 0xE0, 0x72, 0x82, 0x22, 0x0E, 0xF2, 0xF0, 0x72, 0x81, 0x20, 0x9F, 0x2F, 0x90,
  0x73, 0x03, 0xF2, 0xE0, 0xEA, 0x07, 0x30, 0xDE, 0x2E, 0x07, 0x05, 0xA0, 0x72, 0x07, 0xE2, 0xE8,
  0x11, 0x05, 0xA0, 0x72, 0x0A, 0xD2, 0xD0, 0xB2, 0x01, 0x07, 0xA0, 0x72, 0x0A, 0xC2, 0xD8, 0x15,
  0x09, 0xD0, 0x72, 0x0A, 0xB2, 0xC0, 0xE2, 0x0E, 0xE0, 0x72, 0x0A, 0xA2, 0xC8, 0x19, 0x05, 0xF9,
  0x07, 0x20, 0xA9, 0x2F, 0xFA, 0x07, 0x20, 0xA2, 0xFF, 0xB0, 0x74, 0xFF, 0xC0, 0x73, 0xFF, 0xD0,
  0x77, 0x75, 0x81, 0x5E, 0x47, 0x76, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_font_download_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 21, 23), Box(0, 0, 23, 23),
      ic_sharp_24_content_font_download_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_font_download 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_sharp_24_content_font_download_data[] PROGMEM = {
  0x80, 0x98, 0x1F, 0x00, 0x7F, 0xFB, 0x0A, 0x20, 0xAF, 0xFA, 0x04, 0x20, 0x4F, 0xF9, 0x84, 0xD0,
  0x33, 0x0D, 0xFF, 0x84, 0x70, 0x88, 0x07, 0xFF, 0x84, 0x10, 0xEE, 0x01, 0xFE, 0x81, 0xB0, 0x4A,
  0x81, 0x40, 0xBF, 0xD8, 0x14, 0x0A, 0xA8, 0x1A, 0x04, 0xFC, 0x0E, 0x28, 0x00, 0x72, 0x0E, 0xFB,
  0x08, 0x71, 0x08, 0xFB, 0x02, 0x18, 0x02, 0x71, 0x02, 0xFA, 0x81, 0xB0, 0x3E, 0x81, 0x20, 0xBF,
  0x98, 0x15, 0x08, 0xE8, 0x18, 0x05, 0xF9, 0x81, 0x87, 0xEE, 0x81, 0xE7, 0x88, 0x0F, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_font_download() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_font_download_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_forward 24x24, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_sharp_24_content_forward_data[] PROGMEM = {
  0x71, 0x07, 0x77, 0x19, 0x07, 0x77, 0xA0, 0x77, 0x6B, 0x07, 0x4F, 0xD0, 0x73, 0xFE, 0x07, 0x2F,
  0xF0, 0x71, 0xFF, 0x90, 0x7F, 0xF9, 0x07, 0xFF, 0x07, 0x1F, 0xE0, 0x72, 0xFD, 0x07, 0x74, 0xB0,
  0x77, 0x5A, 0x07, 0x76, 0x90, 0x77, 0x70, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_forward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_forward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_gesture 24x24, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_sharp_24_content_gesture_data[] PROGMEM = {
  0x18, 0x35, 0xCE, 0xA1, 0x75, 0x07, 0xC0, 0x97, 0x58, 0x4B, 0xFE, 0xDF, 0xD7, 0x68, 0x39, 0x2A,
  0xFD, 0x77, 0x03, 0xA0, 0x97, 0x78, 0x2C, 0xFE, 0x13, 0x83, 0x49, 0xBA, 0x45, 0x07, 0xA0, 0x62,
  0x01, 0x0B, 0xD0, 0x64, 0x81, 0xEF, 0xC2, 0x01, 0x0D, 0xA0, 0xE0, 0xCA, 0x0E, 0x30, 0x6A, 0x04,
  0x20, 0xCA, 0x0A, 0x20, 0x4A, 0x05, 0x28, 0x1B, 0xFD, 0x20, 0xAA, 0x09, 0x20, 0x10, 0x5A, 0x86,
  0xC9, 0x9C, 0xFA, 0x08, 0xA0, 0xB2, 0x08, 0x0E, 0xE8, 0x2B, 0xFD, 0x9A, 0x0C, 0x20, 0xBD, 0x82,
  0xED, 0xD5, 0xC8, 0x2E, 0x10, 0x7A, 0x0C, 0x05, 0xA0, 0x63, 0x89, 0x26, 0xEF, 0xB2, 0x01, 0xEF,
  0xB0, 0x4A, 0x04, 0x72, 0x04, 0xA8, 0x33, 0x0B, 0xFE, 0x73, 0x03, 0xA0, 0x0A, 0xA0, 0x87, 0x40,
  0xCC, 0x0C, 0x75, 0x83, 0x19, 0xED, 0x85,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_gesture() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_gesture_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_how_to_reg 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_sharp_24_content_how_to_reg_data[] PROGMEM = {
  0x58, 0x41, 0xAD, 0xDA, 0x17, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x74, 0x0A, 0xE0, 0xA7, 0x40, 0xDE,
  0x0D, 0x74, 0x0D, 0xE0, 0xD7, 0x40, 0xAE, 0x0A, 0x74, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x58, 0x41,
  0xAD, 0xDA, 0x17, 0x77, 0x40, 0x37, 0x73, 0x81, 0x6F, 0x93, 0x84, 0x26, 0xAD, 0xE8, 0x60, 0x6A,
  0x82, 0x60, 0x3B, 0xC0, 0x82, 0x02, 0x30, 0x5A, 0x81, 0x60, 0x4D, 0x07, 0x28, 0x37, 0xF5, 0x05,
  0xA0, 0x62, 0x0D, 0xD0, 0x72, 0x07, 0xA0, 0x9A, 0x06, 0x3F, 0x07, 0x20, 0x7B, 0x07, 0x4F, 0x90,
  0x72, 0x81, 0x8F, 0x77, 0x73, 0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_how_to_reg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_how_to_reg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_how_to_vote 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_sharp_24_content_how_to_vote_data[] PROGMEM = {
  0x73, 0x02, 0x77, 0x28, 0x17, 0xF5, 0x77, 0x07, 0xB0, 0x57, 0x50, 0x7A, 0x0A, 0xA0, 0x57, 0x30,
  0x7A, 0x81, 0x50, 0x6A, 0x05, 0x71, 0x07, 0xA0, 0x53, 0x06, 0xA0, 0x56, 0x07, 0xA0, 0x55, 0x06,
  0xA0, 0x54, 0x07, 0xA0, 0x56, 0x08, 0xA0, 0x43, 0x82, 0x1E, 0xFB, 0x60, 0x8A, 0x04, 0x58, 0x23,
  0xEF, 0x94, 0x08, 0xA0, 0x47, 0x82, 0x3E, 0xF9, 0x20, 0x8A, 0x04, 0x72, 0x83, 0x3E, 0xF9, 0x8A,
  0x04, 0x78, 0x47, 0xF5, 0x03, 0xEB, 0x83, 0x40, 0x3E, 0x73, 0x07, 0xB8, 0x75, 0x03, 0xEF, 0x40,
  0x3E, 0xA8, 0x17, 0x07, 0xA0, 0x54, 0x03, 0x04, 0x40, 0x5A, 0x07, 0xA0, 0x67, 0x50, 0x68, 0x09,
  0xB0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_how_to_vote() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_how_to_vote_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_inbox 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_sharp_24_content_inbox_data[] PROGMEM = {
  0x80, 0xC2, 0xF7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C,
  0x77, 0xF9, 0x01, 0x40, 0x1F, 0xD0, 0x74, 0x07, 0xFE, 0x82, 0x71, 0x17, 0x80, 0xF1, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_insights 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_sharp_24_content_insights_data[] PROGMEM = {
  0x76, 0x00, 0x37, 0x76, 0x00, 0xA7, 0x74, 0x03, 0x0A, 0xA0, 0xA0, 0x37, 0x03, 0x71, 0x03, 0x0A,
  0xA0, 0xA0, 0x37, 0x0B, 0x73, 0x00, 0xA7, 0x83, 0x3B, 0xFB, 0x37, 0x10, 0x03, 0x38, 0x24, 0xDD,
  0x42, 0x0B, 0x48, 0x24, 0xDD, 0x47, 0x0D, 0xA0, 0xD2, 0x03, 0x40, 0xDA, 0x0D, 0x60, 0x1B, 0x0D,
  0x60, 0x1C, 0x01, 0x40, 0x10, 0xCA, 0x0D, 0x04, 0x50, 0x10, 0xCC, 0x0C, 0x01, 0x28, 0x31, 0xCF,
  0xC1, 0x68, 0x95, 0x1C, 0xFC, 0x11, 0xCF, 0xC1, 0x1C, 0xFC, 0x16, 0x83, 0x1C, 0xFC, 0x12, 0x01,
  0x0C, 0xC0, 0xC0, 0x16, 0x83, 0x1C, 0xFC, 0x14, 0x01, 0xC0, 0x15, 0x04, 0x0D, 0xA0, 0xC0, 0x16,
  0x0D, 0xA0, 0xD6, 0x0D, 0xB0, 0x17, 0x82, 0x4D, 0xD4, 0x60, 0xDA, 0x0D, 0x77, 0x48, 0x24, 0xDD,
  0x47, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_insights() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_insights_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_inventory_2 24x24, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_sharp_24_content_inventory_2_data[] PROGMEM = {
  0x80, 0xC6, 0xF7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xFF, 0xF9, 0x0B, 0xFF, 0xC0, 0xB1, 0xFF, 0xC2,
  0xFF, 0xC2, 0xFF, 0xC2, 0xE6, 0xE2, 0xE6, 0xE2, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF, 0xC2,
  0xFF, 0xC2, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF, 0xC1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_inventory_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_inventory_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_inventory 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_24_content_inventory_data[] PROGMEM = {
  0x78, 0x28, 0xEE, 0x87, 0x71, 0x08, 0xC0, 0x87, 0x1F, 0x90, 0x03, 0xF9, 0x2F, 0x90, 0x03, 0xF9,
  0x2A, 0x2F, 0xB2, 0xA2, 0xA2, 0xFB, 0x2A, 0x2A, 0x2F, 0xB2, 0xA2, 0xA7, 0x7A, 0x2A, 0x77, 0xA2,
  0xA7, 0x74, 0xA7, 0x71, 0x00, 0x11, 0xA7, 0x78, 0x21, 0xDD, 0x1A, 0x76, 0x83, 0x1D, 0xFD, 0x1A,
  0x68, 0x11, 0xB1, 0x38, 0x31, 0xDF, 0xD1, 0x1A, 0x68, 0x90, 0xBF, 0xD1, 0x01, 0xDF, 0xD1, 0x2A,
  0x68, 0x71, 0xDF, 0xD3, 0xDF, 0xD1, 0x3A, 0x70, 0x10, 0xDB, 0x0D, 0x01, 0x4A, 0x71, 0x83, 0x1D,
  0xFD, 0x25, 0xF9, 0x38, 0x11, 0xB2, 0x6F, 0x97, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_inventory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_inventory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_link_off 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_sharp_24_content_link_off_data[] PROGMEM = {
  0x81, 0x4D, 0x27, 0x73, 0x82, 0xAF, 0xD2, 0x77, 0x38, 0x2B, 0xFD, 0x27, 0x73, 0x82, 0xBF, 0xD2,
  0x77, 0x20, 0x4A, 0x0D, 0x02, 0x4C, 0x81, 0xEB, 0x43, 0x07, 0xC0, 0xD0, 0x23, 0x80, 0x0D, 0xB8,
  0x91, 0x80, 0x4F, 0xE5, 0x1B, 0xFD, 0x27, 0x85, 0x5E, 0xF4, 0xBF, 0x53, 0x82, 0xBF, 0xD2, 0x78,
  0x25, 0xFB, 0xE9, 0x4B, 0x83, 0xD2, 0x02, 0xE4, 0x90, 0x0E, 0x94, 0xC8, 0x2D, 0x20, 0x24, 0x83,
  0xEE, 0xBF, 0x56, 0x82, 0xBF, 0xD2, 0x48, 0x55, 0xFB, 0x4F, 0xE5, 0x68, 0x2B, 0xFD, 0x22, 0x84,
  0x4E, 0xF4, 0x08, 0xB8, 0x00, 0xD2, 0xA8, 0x4D, 0x20, 0x2E, 0x73, 0x81, 0x4B, 0xEC, 0x2B, 0x82,
  0xD2, 0x01, 0x77, 0x18, 0x2B, 0xFD, 0x27, 0x73, 0x82, 0xBF, 0xD2, 0x77, 0x38, 0x1B, 0xFD, 0x77,
  0x40, 0xA0, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_link_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_link_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_link 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_content_link_data[] PROGMEM = {
  0x28, 0x14, 0xBE, 0xC2, 0xC8, 0x1E, 0xB4, 0x30, 0x8F, 0x2F, 0x81, 0x80, 0x4A, 0x07, 0x01, 0x73,
  0x01, 0x07, 0xA8, 0x24, 0xBF, 0x77, 0x78, 0x47, 0xFB, 0xEF, 0x13, 0xF9, 0x38, 0x41, 0xFE, 0xEF,
  0x13, 0xF9, 0x38, 0x41, 0xFE, 0xBF, 0x77, 0x78, 0x27, 0xFB, 0x4A, 0x07, 0x01, 0x73, 0x01, 0x07,
  0xA8, 0x14, 0x08, 0xF2, 0xF0, 0x83, 0x81, 0x4B, 0xEC, 0x2C, 0x81, 0xEB, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_link() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 16), Box(0, 0, 23, 23),
      ic_sharp_24_content_link_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_low_priority 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_sharp_24_content_low_priority_data[] PROGMEM = {
  0x38, 0x13, 0xAD, 0xC2, 0xF9, 0x20, 0x8F, 0x2F, 0x91, 0x09, 0xA0, 0x80, 0x37, 0x70, 0x3A, 0x03,
  0x77, 0x28, 0x1A, 0xF8, 0x77, 0x38, 0x1D, 0xF3, 0x72, 0x80, 0x47, 0xA7, 0x3F, 0x98, 0x1D, 0xF3,
  0x72, 0x80, 0x47, 0x81, 0xAF, 0x87, 0x73, 0x03, 0xA0, 0x33, 0x07, 0x76, 0x09, 0xA8, 0x38, 0x30,
  0xF7, 0x76, 0x08, 0xE0, 0x72, 0xF9, 0x38, 0x13, 0xAD, 0xB0, 0x72, 0xF9, 0x79, 0x07, 0x77, 0x40,
  0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_low_priority() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_low_priority_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_mail 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_sharp_24_content_mail_data[] PROGMEM = {
  0x80, 0xC6, 0xF0, 0x40, 0xDF, 0xD0, 0xD0, 0x4C, 0x20, 0x8F, 0xB0, 0x82, 0xC8, 0x3A, 0x10, 0x3C,
  0xE8, 0x3C, 0x30, 0x1A, 0xD0, 0xE0, 0x62, 0x06, 0x0E, 0xA0, 0xE0, 0x62, 0x06, 0x0E, 0xF9, 0x89,
  0x0C, 0x30, 0x1A, 0xA1, 0x03, 0xCF, 0xD0, 0x84, 0x08, 0xFF, 0x98, 0x2D, 0x44, 0xD8, 0x0A, 0xA0,
  0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_markunread 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_sharp_24_content_markunread_data[] PROGMEM = {
  0x80, 0xC6, 0xF0, 0x40, 0xDF, 0xD0, 0xD0, 0x4C, 0x20, 0x8F, 0xB0, 0x82, 0xC8, 0x3A, 0x10, 0x3C,
  0xE8, 0x3C, 0x30, 0x1A, 0xD0, 0xE0, 0x62, 0x06, 0x0E, 0xA0, 0xE0, 0x62, 0x06, 0x0E, 0xF9, 0x89,
  0x0C, 0x30, 0x1A, 0xA1, 0x03, 0xCF, 0xD0, 0x84, 0x08, 0xFF, 0x98, 0x2D, 0x44, 0xD8, 0x0A, 0xA0,
  0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_markunread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_markunread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_move_to_inbox 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_sharp_24_content_move_to_inbox_data[] PROGMEM = {
  0x80, 0xC2, 0xF7, 0x7C, 0x77, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC3, 0x07, 0xE0, 0x73, 0xC4,
  0x07, 0xC0, 0x74, 0xC5, 0x07, 0xA0, 0x75, 0xC6, 0x00, 0x76, 0xC7, 0x7F, 0x90, 0x14, 0x01, 0xFD,
  0x07, 0x40, 0x7F, 0xE8, 0x27, 0x11, 0x78, 0x0F, 0x1F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_move_to_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_move_to_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_next_week 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_sharp_24_content_next_week_data[] PROGMEM = {
  0x60, 0x40, 0xDC, 0x0D, 0x04, 0x75, 0x0D, 0xE0, 0xD7, 0x5A, 0x4A, 0x75, 0xA4, 0xA6, 0x80, 0x98,
  0x0F, 0x00, 0xDF, 0xFC, 0x81, 0x31, 0xDF, 0xFB, 0x82, 0xD1, 0x1D, 0xFF, 0xB8, 0x2D, 0x11, 0xDF,
  0xFB, 0x81, 0xB0, 0x3F, 0xFA, 0x82, 0xD1, 0x1D, 0xFF, 0x98, 0x2D, 0x11, 0xDF, 0xFA, 0x81, 0x31,
  0xDF, 0xFB, 0x00, 0xD8, 0x09, 0x82, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_next_week() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_next_week_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_outlined_flag 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_content_outlined_flag_data[] PROGMEM = {
  0xF9, 0x03, 0x6F, 0x90, 0xB6, 0xA5, 0x0B, 0xFA, 0x50, 0x3F, 0xA7, 0x4C, 0x74, 0xC7, 0x4C, 0x74,
  0xFB, 0x03, 0x4F, 0xB0, 0xB4, 0xC5, 0x0B, 0xFA, 0x50, 0x3F, 0xA7, 0x6A, 0x76, 0xA7, 0x6A, 0x76,
  0xA7, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_outlined_flag() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 19, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_outlined_flag_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_policy 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_sharp_24_content_policy_data[] PROGMEM = {
  0x78, 0x25, 0xCC, 0x57, 0x50, 0x60, 0xDC, 0x0D, 0x06, 0x78, 0x11, 0x8E, 0xF9, 0x81, 0xE8, 0x12,
  0x03, 0x0A, 0xFF, 0x0A, 0x03, 0x80, 0xC6, 0xF8, 0x4B, 0x41, 0x14, 0xAF, 0xC0, 0x76, 0x07, 0xFA,
  0x0A, 0x28, 0x28, 0xDD, 0x82, 0x0B, 0xF9, 0x81, 0x40, 0x8C, 0x81, 0x80, 0x4C, 0x0E, 0xB8, 0x11,
  0x0D, 0xC8, 0x1D, 0x01, 0xB0, 0xE0, 0xDB, 0x81, 0x10, 0xDC, 0x81, 0xD0, 0x1B, 0x0D, 0x0B, 0xB8,
  0x14, 0x08, 0xC8, 0x18, 0x04, 0xB0, 0xB0, 0x7B, 0x0C, 0x28, 0x28, 0xDD, 0x82, 0x0A, 0xB0, 0x70,
  0x2C, 0x08, 0x70, 0x20, 0xEA, 0x81, 0x10, 0xAC, 0x89, 0x1B, 0x40, 0x14, 0xA2, 0x02, 0xEA, 0x20,
  0x2F, 0xB8, 0x3E, 0x20, 0x22, 0x30, 0x7F, 0xB0, 0xE0, 0x26, 0x0A, 0xFB, 0x09, 0x70, 0x9F, 0x90,
  0x97, 0x20, 0x60, 0xEC, 0x0E, 0x06, 0x74, 0x84, 0x17, 0xCC, 0x71, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_policy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_policy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_push_pin 24x24, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_sharp_24_content_push_pin_data[] PROGMEM = {
  0x1F, 0xD2, 0xFD, 0x4F, 0x96, 0xF9, 0x6F, 0x96, 0xF9, 0x6F, 0x95, 0x01, 0xF9, 0x01, 0x40, 0x7F,
  0x90, 0x72, 0x01, 0x07, 0xFB, 0x07, 0x01, 0xFF, 0xFF, 0x6A, 0x75, 0xA7, 0x5A, 0x75, 0xA7, 0x5A,
  0x75, 0xA7, 0x5A, 0x75, 0x08, 0x07, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_push_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_push_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_redo 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_24_content_redo_data[] PROGMEM = {
  0x77, 0x60, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xC7, 0x24, 0x07, 0x94, 0x02, 0x0A, 0xFA, 0x82, 0xA1,
  0x07, 0xA3, 0x04, 0x0E, 0xB8, 0x3C, 0x97, 0x9C, 0xB0, 0xE0, 0x9B, 0x20, 0x4B, 0x09, 0x01, 0x50,
  0x20, 0x9E, 0x18, 0x31, 0xEF, 0xE4, 0x72, 0x0A, 0xD1, 0x0A, 0xA0, 0x47, 0x20, 0x7E, 0x02, 0xA0,
  0x97, 0x20, 0x7F, 0x82, 0x18, 0xD1, 0x71, 0x07, 0xF9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_redo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 21, 15), Box(0, 0, 23, 23),
      ic_sharp_24_content_redo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_remove_circle_outline 24x24, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_sharp_24_content_remove_circle_outline_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x67, 0x58, 0x56, 0xFD, 0x05, 0xFC, 0x77, 0x84, 0xCF, 0x59, 0xF6, 0x77,
  0x84, 0x6F, 0x9D, 0xF2, 0x77, 0x82, 0x2F, 0xDE, 0x93, 0xFB, 0x39, 0x00, 0xE9, 0x3F, 0xB3, 0x98,
  0x2E, 0xDF, 0x27, 0x78, 0x42, 0xFD, 0x9F, 0x67, 0x78, 0x46, 0xF9, 0x5F, 0xC7, 0x78, 0x5C, 0xF5,
  0x0D, 0xF6, 0x75, 0x81, 0x6F, 0xD2, 0x04, 0xA0, 0x47, 0x30, 0x4A, 0x04, 0x30, 0x8A, 0x06, 0x71,
  0x06, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9, 0x0D,
  0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_remove_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_remove_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_remove_circle 24x24, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_sharp_24_content_remove_circle_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xFF, 0xC0, 0x50, 0x9F,
  0xFC, 0x09, 0x0D, 0xFF, 0xC0, 0xD0, 0xEC, 0x73, 0xC0, 0x0E, 0xC7, 0x3C, 0x0E, 0x0D, 0xFF, 0xC0,
  0xD0, 0x9F, 0xFC, 0x09, 0x05, 0xFF, 0xC8, 0x15, 0x0D, 0xFF, 0xA0, 0xD2, 0x04, 0xFF, 0xA0, 0x43,
  0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE,
  0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_remove_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_remove_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_remove 24x24, 4-bit Alpha,  RLE, 2 bytes.
static const unsigned char ic_sharp_24_content_remove_data[] PROGMEM = {
  0xFF, 0xFF,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_remove() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 11, 18, 12), Box(0, 0, 23, 23),
      ic_sharp_24_content_remove_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_reply_all 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_sharp_24_content_reply_all_data[] PROGMEM = {
  0x60, 0x75, 0x07, 0x77, 0x20, 0x79, 0x40, 0x79, 0x77, 0x10, 0x7A, 0x30, 0x7A, 0x77, 0x07, 0xA0,
  0x72, 0x07, 0xB7, 0x60, 0x7A, 0x07, 0x20, 0x7C, 0x81, 0xDA, 0x67, 0x20, 0x7A, 0x07, 0x20, 0x7F,
  0x90, 0xE0, 0x86, 0x07, 0xA0, 0x72, 0x07, 0xFC, 0x0D, 0x03, 0x40, 0x7A, 0x07, 0x20, 0x7F, 0xD0,
  0xE0, 0x44, 0x07, 0xA0, 0x72, 0x07, 0xFD, 0x0E, 0x02, 0x40, 0x7A, 0x07, 0x20, 0x7C, 0x0D, 0xF0,
  0xC5, 0x07, 0xA0, 0x72, 0x07, 0xB2, 0x82, 0x13, 0x7C, 0xB0, 0x65, 0x07, 0xA3, 0x07, 0xA6, 0x82,
  0x2B, 0xFD, 0x60, 0x79, 0x40, 0x79, 0x71, 0x81, 0x6F, 0x46, 0x07, 0x50, 0x77, 0x20, 0x40, 0x97,
  0x77, 0x20, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_reply_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 5, 23, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_reply_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_reply 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_sharp_24_content_reply_data[] PROGMEM = {
  0x60, 0x77, 0x72, 0x07, 0x97, 0x71, 0x07, 0xA7, 0x70, 0x7B, 0x76, 0x07, 0xC8, 0x1D, 0xA6, 0x72,
  0x07, 0xF9, 0x0E, 0x08, 0x60, 0x7F, 0xC0, 0xD0, 0x34, 0x07, 0xFD, 0x0E, 0x04, 0x40, 0x7F, 0xD0,
  0xE0, 0x24, 0x07, 0xC0, 0xDF, 0x0C, 0x50, 0x7B, 0x28, 0x21, 0x37, 0xCB, 0x06, 0x50, 0x7A, 0x68,
  0x22, 0xBF, 0xD6, 0x07, 0x97, 0x18, 0x16, 0xF4, 0x60, 0x77, 0x20, 0x40, 0x97, 0x73, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_reply() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 20, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_reply_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_report_gmailerrorred 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_sharp_24_content_report_gmailerrorred_data[] PROGMEM = {
  0x40, 0x40, 0xEE, 0x0E, 0x04, 0x70, 0x40, 0xEF, 0x90, 0xE0, 0x45, 0x82, 0x4E, 0xF9, 0x68, 0x29,
  0xFE, 0x43, 0x82, 0x4E, 0xF9, 0x71, 0x87, 0x9F, 0xE4, 0x04, 0xEF, 0x94, 0xA4, 0x85, 0x9F, 0xE4,
  0xEF, 0x95, 0xA5, 0x81, 0x9F, 0xEA, 0x6A, 0x6C, 0x6A, 0x6C, 0x6A, 0x6C, 0x6A, 0x6C, 0x6A, 0x6C,
  0x77, 0xA8, 0x1E, 0xF9, 0x50, 0x0B, 0x58, 0x59, 0xFE, 0x4E, 0xF9, 0x40, 0x0B, 0x48, 0x79, 0xFE,
  0x40, 0x4E, 0xF9, 0x71, 0x82, 0x9F, 0xE4, 0x38, 0x24, 0xEF, 0x96, 0x82, 0x9F, 0xE4, 0x50, 0x40,
  0xEF, 0x90, 0xE0, 0x47, 0x04, 0x0E, 0xE0, 0xE0, 0x44,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_report_gmailerrorred() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_report_gmailerrorred_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_report_off 24x24, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_sharp_24_content_report_off_data[] PROGMEM = {
  0x10, 0x27, 0x76, 0x81, 0x7F, 0x57, 0x75, 0x07, 0xA0, 0x52, 0x03, 0x0E, 0xE0, 0xE0, 0x47, 0x07,
  0xA0, 0x52, 0x0B, 0xF0, 0xE0, 0x47, 0x07, 0xA0, 0x52, 0x0B, 0xF0, 0xE0, 0x47, 0x09, 0xA0, 0x52,
  0x0B, 0xF0, 0xE0, 0x45, 0x04, 0x0E, 0xB0, 0x54, 0xE0, 0xE0, 0x44, 0x0E, 0xD0, 0x53, 0xF0, 0xE4,
  0xF0, 0x52, 0x0B, 0xF4, 0xF9, 0x05, 0x20, 0xBE, 0x4F, 0xA0, 0x52, 0x0B, 0xD4, 0xFB, 0x05, 0x20,
  0xBC, 0x4F, 0xC0, 0x52, 0x0B, 0xB4, 0xF9, 0x00, 0xDA, 0x05, 0x20, 0xBA, 0x40, 0xEE, 0x0D, 0x20,
  0xDA, 0x05, 0x20, 0xB0, 0xE4, 0x04, 0x0E, 0xD0, 0xD2, 0x0D, 0xB0, 0x52, 0x03, 0x50, 0x40, 0xED,
  0x00, 0xDD, 0x05, 0x71, 0x04, 0x0E, 0xFD, 0x05, 0x71, 0x04, 0x0E, 0xF9, 0x0E, 0x09, 0xA0, 0x57,
  0x10, 0x40, 0xEE, 0x82, 0xE4, 0x07, 0xA0, 0x57, 0x75, 0x07, 0xA0, 0x27, 0x75, 0x00, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_report_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_report_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_report 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_sharp_24_content_report_data[] PROGMEM = {
  0x40, 0x40, 0xEE, 0x0E, 0x04, 0x70, 0x40, 0xEF, 0x90, 0xE0, 0x45, 0x04, 0x0E, 0xFB, 0x0E, 0x04,
  0x30, 0x40, 0xEF, 0xD8, 0x3E, 0x40, 0x4E, 0xE2, 0xE8, 0x1E, 0x4E, 0xF2, 0xF0, 0xEF, 0x92, 0xFF,
  0xA2, 0xFF, 0xA2, 0xFF, 0xA2, 0xFF, 0xFF, 0xE0, 0x0D, 0xF9, 0x0E, 0xE0, 0xD2, 0x0D, 0xE8, 0x1E,
  0x4E, 0xD0, 0xD2, 0x0D, 0xD8, 0x3E, 0x40, 0x4E, 0xD0, 0x0D, 0xD0, 0xE0, 0x43, 0x04, 0x0E, 0xFB,
  0x0E, 0x04, 0x50, 0x40, 0xEF, 0x90, 0xE0, 0x47, 0x04, 0x0E, 0xE0, 0xE0, 0x44,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_report() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_report_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_save_alt 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_24_content_save_alt_data[] PROGMEM = {
  0x71, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x50, 0x10,
  0xA2, 0xA2, 0x0A, 0x01, 0x71, 0x81, 0xBF, 0xB1, 0xA1, 0x81, 0xBF, 0xB4, 0xA2, 0x82, 0x1D, 0xFB,
  0xA8, 0x2B, 0xFD, 0x12, 0xC3, 0x01, 0x0D, 0xC0, 0xD0, 0x13, 0xC4, 0x01, 0x0D, 0xA0, 0xD0, 0x14,
  0xC5, 0x82, 0x1D, 0xD1, 0x5C, 0x60, 0x01, 0x6C, 0x77, 0xC7, 0x78, 0x0C, 0x2F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_save_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_save_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_save_as 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_sharp_24_content_save_as_data[] PROGMEM = {
  0xFF, 0x07, 0x6F, 0xF9, 0x07, 0x5F, 0xFA, 0x07, 0x4B, 0x72, 0xD0, 0x73, 0xB7, 0x2E, 0x3B, 0x72,
  0xE3, 0xB7, 0x2E, 0x3F, 0xFC, 0x3F, 0xFC, 0x3F, 0x82, 0x71, 0x17, 0xE0, 0xC3, 0xE0, 0x74, 0x07,
  0xC0, 0xC0, 0x13, 0xE0, 0x14, 0x01, 0xB8, 0x3C, 0x10, 0x41, 0x1E, 0x01, 0x40, 0x1A, 0x85, 0xC1,
  0x02, 0xFD, 0x1E, 0x07, 0x48, 0x90, 0x7F, 0xC1, 0x04, 0x46, 0xF4, 0xF8, 0x93, 0x71, 0x17, 0xFC,
  0x10, 0x4F, 0xE4, 0x21, 0xFC, 0x82, 0xC1, 0x04, 0xB0, 0x42, 0xFB, 0x82, 0xC1, 0x04, 0xB0, 0x43,
  0xFA, 0x82, 0xC1, 0x04, 0xB0, 0x47, 0x72, 0xB0, 0x47, 0x73, 0xA0, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_save_as() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 23, 22), Box(0, 0, 23, 23),
      ic_sharp_24_content_save_as_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_save 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_sharp_24_content_save_data[] PROGMEM = {
  0xFF, 0x07, 0x3F, 0xF9, 0x07, 0x2A, 0x73, 0xC0, 0x71, 0xA7, 0x3D, 0x07, 0xA7, 0x3F, 0x97, 0x38,
  0x09, 0xA1, 0xF8, 0x27, 0x11, 0x7F, 0xE0, 0x74, 0x07, 0xFD, 0x01, 0x40, 0x1F, 0xD0, 0x14, 0x01,
  0xFD, 0x07, 0x40, 0x7F, 0xE8, 0x27, 0x11, 0x78, 0x0C, 0x7F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_save() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_save_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_select_all 24x24, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_sharp_24_content_select_all_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA8, 0x0C, 0x00, 0xA2, 0xFB, 0x2C, 0x2F, 0xB2,
  0xA4, 0xA6, 0xA7, 0x1A, 0x6A, 0x4A, 0x2A, 0x6A, 0x2C, 0x2A, 0x6A, 0x2A, 0x4A, 0x6A, 0x71, 0xA6,
  0xA4, 0xA2, 0xFB, 0x2C, 0x2F, 0xB2, 0xA8, 0x0C, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2,
  0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_select_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_select_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_send 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_sharp_24_content_send_data[] PROGMEM = {
  0x0C, 0x05, 0x77, 0x5A, 0x81, 0xE7, 0x17, 0x72, 0xD0, 0xA0, 0x37, 0x7F, 0x0C, 0x05, 0x75, 0xFA,
  0x81, 0xE7, 0x17, 0x2F, 0xD0, 0xA0, 0x37, 0xFF, 0x0C, 0x05, 0x58, 0x51, 0x35, 0x79, 0xBD, 0xFA,
  0x81, 0xE7, 0x17, 0x38, 0x52, 0x46, 0x8A, 0xCE, 0xC0, 0xA0, 0x37, 0x18, 0x52, 0x46, 0x8A, 0xCE,
  0xC8, 0x7A, 0x31, 0x35, 0x79, 0xBD, 0xFA, 0x81, 0xE7, 0x12, 0xFF, 0x0C, 0x05, 0x5F, 0xD0, 0xA0,
  0x37, 0xFA, 0x81, 0xE7, 0x17, 0x2F, 0x0C, 0x05, 0x75, 0xD0, 0xA0, 0x37, 0x7A, 0x81, 0xE7, 0x17,
  0x72, 0x0C, 0x05, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_send() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 22, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_send_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_shield 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_sharp_24_content_shield_data[] PROGMEM = {
  0x58, 0x41, 0x6C, 0xC6, 0x17, 0x10, 0x40, 0xAE, 0x0A, 0x04, 0x38, 0x12, 0x8E, 0xFB, 0x81, 0xE8,
  0x28, 0x09, 0xB4, 0xF0, 0xEF, 0xF0, 0xE0, 0xDF, 0xF0, 0xD0, 0xBF, 0xF0, 0xB0, 0x7F, 0xF0, 0x70,
  0x1F, 0xF8, 0x11, 0x09, 0xFD, 0x09, 0x20, 0x10, 0xEF, 0xB0, 0xE0, 0x13, 0x04, 0xFB, 0x04, 0x50,
  0x6F, 0x90, 0x67, 0x04, 0x0D, 0xC0, 0xD0, 0x47, 0x38, 0x27, 0xCC, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_shield() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_shield_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_sort 24x24, 4-bit Alpha,  RLE, 13 bytes.
static const unsigned char ic_sharp_24_content_sort_data[] PROGMEM = {
  0x80, 0xC0, 0xF8, 0x0E, 0x20, 0xFD, 0x6F, 0xD8, 0x0F, 0x00, 0xE7, 0x5E, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_sort() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 17), Box(0, 0, 23, 23),
      ic_sharp_24_content_sort_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_square_foot 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_sharp_24_content_square_foot_data[] PROGMEM = {
  0x07, 0x77, 0x19, 0x07, 0x77, 0x90, 0xE0, 0x17, 0x69, 0x81, 0x86, 0x77, 0x5C, 0x07, 0x74, 0xC0,
  0x70, 0x17, 0x3C, 0x81, 0x7E, 0x77, 0x2B, 0x0B, 0xB0, 0x57, 0x1B, 0x18, 0x3B, 0xFD, 0x15, 0x7B,
  0x28, 0x3B, 0xFC, 0xF7, 0x6B, 0x30, 0xBA, 0x0E, 0x01, 0x5B, 0x40, 0xB9, 0x0F, 0x74, 0xB5, 0x0B,
  0xB0, 0x73, 0xFD, 0x06, 0x01, 0x2F, 0xD8, 0x18, 0xE7, 0x1F, 0xF9, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_square_foot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_square_foot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_stacked_bar_chart 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_sharp_24_content_stacked_bar_chart_data[] PROGMEM = {
  0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x2C, 0x75, 0xC6, 0xC2, 0xC6, 0xC2, 0xC2, 0xF9, 0x71, 0xF9, 0x2C,
  0x2F, 0x92, 0xC2, 0xF9, 0x2C, 0x6C, 0x2C, 0x2F, 0x92, 0xC2, 0xF9, 0x2C, 0x2F, 0x92, 0xC2, 0xF9,
  0x2C, 0x2C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_stacked_bar_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_stacked_bar_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_stream 24x24, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_sharp_24_content_stream_data[] PROGMEM = {
  0x71, 0x82, 0x4D, 0xD4, 0x77, 0x20, 0xDA, 0x0D, 0x74, 0x07, 0x01, 0x30, 0xDA, 0x0D, 0x30, 0x10,
  0x75, 0x82, 0x6F, 0xD1, 0x28, 0x24, 0xDD, 0x42, 0x82, 0x1D, 0xF7, 0x48, 0x31, 0xCF, 0xD1, 0x68,
  0x31, 0xDF, 0xC1, 0x58, 0x31, 0xCF, 0xD1, 0x48, 0x31, 0xDF, 0xC1, 0x78, 0x21, 0xCF, 0xC4, 0x82,
  0xCF, 0xC1, 0x72, 0x81, 0x1B, 0x34, 0x81, 0x3B, 0x15, 0x82, 0x4D, 0xD4, 0x75, 0x83, 0x4D, 0xD4,
  0xDA, 0x0D, 0x75, 0x0D, 0xA0, 0x0D, 0xA0, 0xD7, 0x50, 0xDA, 0x83, 0xD4, 0xDD, 0x47, 0x58, 0x24,
  0xDD, 0x45, 0x81, 0x1C, 0x34, 0x81, 0x3C, 0x17, 0x28, 0x21, 0xDF, 0xB4, 0x82, 0xBF, 0xD1, 0x78,
  0x31, 0xDF, 0xC1, 0x48, 0x31, 0xCF, 0xD1, 0x58, 0x31, 0xDF, 0xC1, 0x68, 0x31, 0xCF, 0xD1, 0x48,
  0x27, 0xFC, 0x12, 0x82, 0x4D, 0xD4, 0x28, 0x21, 0xCF, 0x75, 0x06, 0x40, 0xDA, 0x0D, 0x30, 0x10,
  0x67, 0x40, 0xDA, 0x0D, 0x77, 0x28, 0x24, 0xDD, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_stream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_stream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_tag 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_sharp_24_content_tag_data[] PROGMEM = {
  0x4A, 0x4A, 0x71, 0xA4, 0xA7, 0x1A, 0x4A, 0x71, 0xA4, 0xA4, 0xFF, 0xFF, 0xC4, 0xA4, 0xA7, 0x1A,
  0x4A, 0x71, 0xA4, 0xA7, 0x1A, 0x4A, 0x4F, 0xFF, 0xFC, 0x4A, 0x4A, 0x71, 0xA4, 0xA7, 0x1A, 0x4A,
  0x71, 0xA4, 0xA4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_tag() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_sharp_24_content_tag_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_text_format 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_24_content_text_format_data[] PROGMEM = {
  0x60, 0x0E, 0x74, 0x06, 0xA0, 0x67, 0x38, 0x00, 0xC7, 0x28, 0x44, 0xF6, 0x6F, 0x47, 0x18, 0x4A,
  0xF1, 0x1F, 0xA7, 0x81, 0x2F, 0xA2, 0x81, 0xAF, 0x26, 0x81, 0x8F, 0x42, 0x81, 0x4F, 0x86, 0x0E,
  0xE0, 0xE5, 0x89, 0x06, 0xFD, 0xBB, 0xBB, 0xDF, 0x64, 0x81, 0xDF, 0x34, 0x81, 0x3F, 0xD3, 0x81,
  0x4F, 0xC6, 0x81, 0xCF, 0x47, 0x77, 0x71, 0xFF, 0xFF,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_text_format() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 18, 18), Box(0, 0, 23, 23),
      ic_sharp_24_content_text_format_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_unarchive 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_24_content_unarchive_data[] PROGMEM = {
  0x10, 0x20, 0xEF, 0xD8, 0x4E, 0x20, 0x1D, 0x87, 0x58, 0x29, 0xD1, 0xBF, 0xFA, 0x0B, 0x80, 0xF2,
  0xF0, 0x0D, 0xFF, 0x98, 0x2D, 0x11, 0xDF, 0xE0, 0xD0, 0x12, 0x01, 0x0D, 0xFC, 0x0D, 0x01, 0x40,
  0x10, 0xDF, 0xA0, 0xD0, 0x16, 0x01, 0x0D, 0xF0, 0xD0, 0x17, 0x10, 0x10, 0xDF, 0xB4, 0xFF, 0x48,
  0x09, 0x93, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_unarchive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_unarchive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_undo 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_sharp_24_content_undo_data[] PROGMEM = {
  0x07, 0x77, 0x69, 0x07, 0x48, 0x72, 0x7C, 0xDF, 0xEC, 0x82, 0x6A, 0x82, 0x70, 0x1A, 0xFA, 0x0A,
  0x02, 0x4B, 0x09, 0x0E, 0xB8, 0x3C, 0x97, 0x9C, 0xB0, 0xE0, 0x43, 0xE0, 0x90, 0x25, 0x01, 0x09,
  0xB0, 0x42, 0xD0, 0xA7, 0x28, 0x34, 0xEF, 0xE1, 0x1E, 0x07, 0x72, 0x04, 0xA0, 0xA1, 0xF0, 0x77,
  0x20, 0x9A, 0x02, 0xF9, 0x07, 0x71, 0x82, 0x1D, 0x82,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_undo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 22, 15), Box(0, 0, 23, 23),
      ic_sharp_24_content_undo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_upcoming 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_sharp_24_content_upcoming_data[] PROGMEM = {
  0x72, 0xA7, 0x74, 0xA7, 0x74, 0xA7, 0x38, 0x16, 0xC1, 0x5A, 0x58, 0x11, 0xC6, 0x28, 0x2C, 0xFC,
  0x14, 0xA4, 0x82, 0x1C, 0xFC, 0x28, 0x31, 0xCF, 0xC1, 0x71, 0x83, 0x1C, 0xFC, 0x13, 0x82, 0x1C,
  0xF8, 0x71, 0x82, 0x8F, 0xC1, 0x50, 0x10, 0x87, 0x30, 0x80, 0x17, 0x77, 0x2F, 0x01, 0x40, 0x1F,
  0xF0, 0x74, 0x07, 0xFF, 0x98, 0x27, 0x11, 0x78, 0x09, 0xF4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_upcoming() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_upcoming_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_waves 24x24, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_sharp_24_content_waves_data[] PROGMEM = {
  0x38, 0x22, 0x44, 0x16, 0x82, 0x14, 0x41, 0x40, 0x40, 0xBC, 0x0B, 0x04, 0x20, 0x40, 0xBC, 0x0B,
  0x04, 0x1B, 0x82, 0xEA, 0xAE, 0xE8, 0x2E, 0xAA, 0xEB, 0x81, 0xEB, 0x54, 0x84, 0x6B, 0xEE, 0xB6,
  0x48, 0x16, 0xBE, 0x77, 0x71, 0x84, 0x4A, 0xDD, 0xA4, 0x48, 0x44, 0xAD, 0xDA, 0x42, 0x09, 0x0D,
  0xE8, 0x2D, 0x99, 0xDE, 0x0D, 0x09, 0xA8, 0x4C, 0x61, 0x16, 0xCC, 0x84, 0xC6, 0x11, 0x6C, 0xA0,
  0x50, 0x36, 0x82, 0x35, 0x53, 0x60, 0x30, 0x53, 0x82, 0x36, 0x63, 0x68, 0x23, 0x66, 0x33, 0x81,
  0x26, 0xDC, 0x84, 0xD6, 0x22, 0x6D, 0xC8, 0x1D, 0x62, 0xB8, 0x2C, 0x88, 0xCE, 0x82, 0xC8, 0x8C,
  0xB8, 0x1D, 0xA4, 0x48, 0x44, 0xAD, 0xDA, 0x44, 0x81, 0x4A, 0xD7, 0x77, 0x10, 0x60, 0xCA, 0x0C,
  0x06, 0x40, 0x60, 0xCA, 0x0C, 0x06, 0x20, 0xA0, 0xEE, 0x82, 0xEA, 0xAE, 0xE0, 0xE0, 0xAA, 0x0B,
  0x04, 0x20, 0x40, 0xBC, 0x0B, 0x04, 0x20, 0x40, 0xBA, 0x04, 0x01, 0x68, 0x22, 0x44, 0x26, 0x01,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_waves() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_sharp_24_content_waves_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_web_stories 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_sharp_24_content_web_stories_data[] PROGMEM = {
  0xFE, 0x71, 0xFE, 0x71, 0xFE, 0x2A, 0x4F, 0xE2, 0xA4, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x29,
  0x07, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x29,
  0x07, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x29,
  0x07, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x29, 0x07, 0xFE, 0x2A, 0x4F, 0xE2, 0xA4, 0xFE, 0x71,
  0xFE, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_web_stories() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 22, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_web_stories_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_weekend 24x24, 4-bit Alpha,  RLE, 27 bytes.
static const unsigned char ic_sharp_24_content_weekend_data[] PROGMEM = {
  0x3F, 0xFA, 0x6F, 0xFA, 0x6F, 0xFA, 0x6F, 0xFA, 0x71, 0xFD, 0x5C, 0x1F, 0xD1, 0xF9, 0x1F, 0xD1,
  0xF9, 0x1F, 0xD1, 0xF9, 0x1F, 0xD1, 0xF9, 0x77, 0x80, 0x9B, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_weekend() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_sharp_24_content_weekend_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_24_content_where_to_vote 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_sharp_24_content_where_to_vote_data[] PROGMEM = {
  0x38, 0x61, 0x7C, 0xEE, 0xC7, 0x15, 0x05, 0x0E, 0xE0, 0xE0, 0x53, 0x05, 0xFB, 0x82, 0x50, 0x1E,
  0xFB, 0x81, 0xE1, 0x7F, 0x98, 0x4E, 0x4D, 0xF7, 0xCF, 0x85, 0xE3, 0x03, 0xFC, 0xEE, 0x8A, 0x0E,
  0x30, 0x2D, 0xFE, 0xEF, 0xD5, 0xEF, 0xE3, 0x02, 0xDA, 0x89, 0x1E, 0xCF, 0x30, 0x3D, 0x30, 0x2D,
  0xB8, 0x3C, 0x8F, 0xD1, 0x30, 0x20, 0xDC, 0x08, 0x02, 0xA8, 0x3D, 0x10, 0x2D, 0xD8, 0x12, 0x0B,
  0xA8, 0x1D, 0x3D, 0xD0, 0xB2, 0x04, 0xFB, 0x04, 0x30, 0xBF, 0x90, 0xB4, 0x02, 0x0E, 0xE0, 0xE0,
  0x25, 0x07, 0xE0, 0x77, 0x0B, 0xC0, 0xB7, 0x10, 0x10, 0xEA, 0x0E, 0x01, 0x72, 0x04, 0xA0, 0x47,
  0x40, 0x06, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_24_content_where_to_vote() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 21), Box(0, 0, 23, 23),
      ic_sharp_24_content_where_to_vote_data, Alpha4(color::Black));
  return value;
}
