#include "action.h"

using namespace roo_display;

// Image file ic_round_48_action_123 48x48, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_48_action_123_data[] PROGMEM = {
  0x08, 0xB0, 0xD0, 0x44, 0x08, 0xE0, 0xD0, 0x43, 0x08, 0xE8, 0x1D, 0x4E, 0xC0, 0xD4, 0x0E, 0xF0,
  0xD3, 0x0E, 0xF0, 0xD0, 0x8D, 0x40, 0x8F, 0x93, 0x08, 0xF9, 0x3B, 0x73, 0xB7, 0x2B, 0x3B, 0x73,
  0xB7, 0x2B, 0x3B, 0x40, 0x40, 0xDE, 0x0D, 0x50, 0xBE, 0x3B, 0x40, 0xDE, 0x0D, 0x04, 0x50, 0xBE,
  0x3B, 0x4B, 0x77, 0x1B, 0x3B, 0x4B, 0x77, 0x1B, 0x3B, 0x4F, 0x90, 0x83, 0x08, 0xF9, 0x3B, 0x40,
  0xDF, 0x0E, 0x30, 0xEF, 0x0D, 0x38, 0x18, 0xE8, 0x40, 0x40, 0xDE, 0x08, 0x30, 0x8E, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_123() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 18, 38, 29), Box(0, 0, 47, 47),
      ic_round_48_action_123_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_3d_rotation 48x48, 4-bit Alpha,  RLE, 428 bytes.
static const unsigned char ic_round_48_action_3d_rotation_data[] PROGMEM = {
  0x77, 0x71, 0x87, 0x1C, 0xED, 0xDA, 0x85, 0x18, 0x0C, 0x40, 0x01, 0x0C, 0xE8, 0x1B, 0x71, 0x80,
  0xC2, 0x00, 0x10, 0xCF, 0x81, 0xE8, 0x18, 0x0C, 0x10, 0x01, 0x0C, 0xF9, 0x0E, 0x07, 0x80, 0xC1,
  0x00, 0x10, 0xCF, 0xA0, 0xC0, 0x28, 0x0C, 0x00, 0x01, 0x0C, 0xB8, 0x17, 0x4D, 0xB0, 0xE0, 0x48,
  0x0C, 0x00, 0x82, 0x1C, 0xF7, 0x30, 0x7C, 0x06, 0x80, 0xC0, 0x00, 0x10, 0x55, 0x03, 0x0D, 0xB0,
  0x68, 0x0C, 0x70, 0x01, 0x0C, 0xB0, 0x48, 0x0D, 0x00, 0x0C, 0xA0, 0xE0, 0x28, 0x0C, 0x70, 0x01,
  0x0D, 0xA0, 0xC8, 0x0D, 0x00, 0x02, 0xB0, 0x68, 0x0D, 0x00, 0x07, 0xA0, 0xE0, 0x18, 0x0D, 0x00,
  0x0C, 0xA0, 0x88, 0x0D, 0x00, 0x05, 0xA0, 0xE0, 0x18, 0x0D, 0x00, 0x0C, 0xA0, 0x67, 0x78, 0x51,
  0x8D, 0xFE, 0xC6, 0x4D, 0x82, 0xEC, 0x71, 0x73, 0x06, 0xA0, 0xB7, 0x60, 0x20, 0xDE, 0x0A, 0x3F,
  0x90, 0xE0, 0x47, 0x20, 0x1B, 0x01, 0x75, 0x0B, 0xA8, 0x27, 0x22, 0xAA, 0x05, 0x2A, 0x84, 0xD3,
  0x34, 0x8E, 0xA0, 0x47, 0x20, 0xBA, 0x04, 0x74, 0x01, 0xA0, 0x94, 0x81, 0xEF, 0x92, 0xA0, 0xC4,
  0x82, 0x2E, 0xFD, 0x72, 0x08, 0xA0, 0x87, 0x58, 0x13, 0x31, 0x48, 0x1D, 0xFB, 0x2A, 0x0C, 0x50,
  0x6A, 0x06, 0x71, 0x04, 0xA0, 0xA7, 0x74, 0x01, 0xA0, 0x82, 0xA0, 0xC5, 0x01, 0xA0, 0xA7, 0x28,
  0x1B, 0xE4, 0x77, 0x18, 0x53, 0x35, 0xDF, 0xD1, 0x2A, 0x0C, 0x68, 0x1E, 0xFD, 0x77, 0x76, 0xC0,
  0xC0, 0x23, 0xA0, 0xC6, 0x81, 0xDF, 0xE7, 0x77, 0x60, 0x0D, 0xB0, 0x83, 0xA0, 0xC6, 0x81, 0xDF,
  0xE7, 0x77, 0x72, 0x06, 0xA0, 0x72, 0xA0, 0xC6, 0x81, 0xEF, 0xD7, 0x58, 0x14, 0xEC, 0x77, 0x28,
  0x1B, 0xFD, 0x2A, 0x0C, 0x50, 0x1A, 0x0A, 0x75, 0x0A, 0xA0, 0x47, 0x82, 0x15, 0x51, 0x40, 0x9A,
  0x2A, 0x0C, 0x50, 0x7A, 0x06, 0x75, 0x08, 0xA0, 0x87, 0x03, 0xA0, 0x74, 0x81, 0xCF, 0xD2, 0xA0,
  0xC4, 0x82, 0x3E, 0xFE, 0x76, 0x04, 0xA0, 0xB7, 0x10, 0xDA, 0x82, 0x62, 0x29, 0xA0, 0x72, 0xA8,
  0x3D, 0x33, 0x48, 0xB0, 0x47, 0x60, 0x1B, 0x01, 0x70, 0x30, 0xEE, 0x0B, 0x3F, 0x90, 0xE0, 0x47,
  0x71, 0x0B, 0xA0, 0x67, 0x18, 0x51, 0x8D, 0xFE, 0xC6, 0x4D, 0x82, 0xEB, 0x71, 0x77, 0x20, 0x6A,
  0x0C, 0x80, 0xD0, 0x00, 0x10, 0xEA, 0x05, 0x80, 0xD0, 0x00, 0x8A, 0x0C, 0x80, 0xD0, 0x00, 0x10,
  0xEA, 0x07, 0x80, 0xD0, 0x00, 0x6B, 0x03, 0x80, 0xD0, 0x00, 0xCA, 0x0D, 0x01, 0x80, 0xC7, 0x00,
  0x20, 0xEA, 0x0C, 0x01, 0x80, 0xC7, 0x00, 0x4B, 0x0C, 0x01, 0x80, 0xC7, 0x00, 0x6B, 0x0D, 0x03,
  0x50, 0x60, 0x18, 0x0C, 0x00, 0x05, 0xC0, 0x73, 0x82, 0x7F, 0xC1, 0x80, 0xC0, 0x00, 0x40, 0xEB,
  0x81, 0xD5, 0x7B, 0x0C, 0x01, 0x80, 0xC0, 0x00, 0x20, 0xCF, 0xA0, 0xC0, 0x18, 0x0C, 0x10, 0x06,
  0x0E, 0xF9, 0x0C, 0x01, 0x80, 0xC1, 0x08, 0x11, 0x8E, 0xF0, 0xC0, 0x18, 0x0C, 0x30, 0x06, 0x0B,
  0xE0, 0xC0, 0x18, 0x0C, 0x40, 0x86, 0x15, 0x8A, 0xDD, 0xDA, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_3d_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 47, 47), Box(0, 0, 47, 47),
      ic_round_48_action_3d_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_abc 48x48, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_48_action_abc_data[] PROGMEM = {
  0x04, 0x0D, 0xE0, 0xD0, 0x43, 0x04, 0x0D, 0xE0, 0xD0, 0x43, 0x04, 0x0D, 0xE8, 0x1D, 0x4D, 0xF9,
  0x0D, 0x30, 0xDF, 0x90, 0xD3, 0x0D, 0xF9, 0x0D, 0xFB, 0x3F, 0xB3, 0xFE, 0x4B, 0x3B, 0x4B, 0x3B,
  0x48, 0x17, 0xE8, 0xB4, 0xB3, 0xB8, 0x00, 0x7A, 0x0D, 0x3B, 0x7B, 0x4B, 0x3F, 0x90, 0xD0, 0x43,
  0xB7, 0xFB, 0x3F, 0x90, 0xD0, 0x43, 0xB7, 0xFB, 0x3B, 0x80, 0x07, 0xA0, 0xD3, 0xB7, 0xFB, 0x3B,
  0x4B, 0x3B, 0x48, 0x17, 0xE8, 0xB4, 0xB3, 0xFB, 0x3F, 0xE4, 0xB3, 0x0D, 0xF9, 0x0D, 0x30, 0xDF,
  0x98, 0x2D, 0x8E, 0x84, 0x81, 0x8E, 0x83, 0x04, 0x0D, 0xE0, 0xD0, 0x43, 0x04, 0x0D, 0xE0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_abc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 18, 41, 29), Box(0, 0, 47, 47),
      ic_round_48_action_abc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_accessibility_new 48x48, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_round_48_action_accessibility_new_data[] PROGMEM = {
  0x77, 0x18, 0x41, 0xAD, 0xDA, 0x17, 0x77, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x70, 0xAE,
  0x0A, 0x77, 0x77, 0x0D, 0xE0, 0xD7, 0x77, 0x70, 0xDE, 0x0D, 0x77, 0x77, 0x0A, 0xE0, 0xA7, 0x77,
  0x70, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x77, 0x18, 0x41, 0xAD, 0xDA, 0x17, 0x72, 0x82, 0x37, 0x63,
  0x77, 0x75, 0x84, 0x36, 0x73, 0x03, 0xD8, 0x7D, 0xB9, 0x75, 0x43, 0x11, 0x68, 0x71, 0x13, 0x45,
  0x79, 0xBD, 0xD0, 0x30, 0x8F, 0xFF, 0xFE, 0x07, 0x03, 0xFF, 0xFF, 0xE8, 0x43, 0x03, 0x9C, 0xEF,
  0xFF, 0xD8, 0x2E, 0xC9, 0x36, 0x85, 0x25, 0x79, 0xBC, 0xEF, 0xD8, 0x5E, 0xCB, 0x97, 0x52, 0x77,
  0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F,
  0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7,
  0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7,
  0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C,
  0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x30, 0xDA, 0x0D,
  0x40, 0xDA, 0x0D, 0x77, 0x73, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x47, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_accessibility_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_accessibility_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_accessibility 48x48, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_round_48_action_accessibility_data[] PROGMEM = {
  0x77, 0x18, 0x41, 0xAD, 0xDA, 0x17, 0x77, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x70, 0xAE,
  0x0A, 0x77, 0x77, 0x0D, 0xE0, 0xD7, 0x77, 0x70, 0xDE, 0x0D, 0x77, 0x77, 0x0A, 0xE0, 0xA7, 0x77,
  0x70, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x77, 0x18, 0x41, 0xAD, 0xDA, 0x18, 0x09, 0xA3, 0x00, 0x40,
  0xDF, 0xFF, 0xFC, 0x81, 0xD4, 0xDF, 0xFF, 0xFE, 0x00, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF,
  0xFC, 0x0D, 0x04, 0x75, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73,
  0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD,
  0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xC4, 0xC7,
  0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C,
  0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77,
  0x73, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD7, 0x77, 0x38, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_accessibility() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_accessibility_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_accessible_forward 48x48, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_round_48_action_accessible_forward_data[] PROGMEM = {
  0x77, 0x72, 0x84, 0x18, 0xCC, 0x81, 0x77, 0x72, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x77, 0x10, 0x9E,
  0x09, 0x77, 0x71, 0x0D, 0xE0, 0xD7, 0x77, 0x10, 0xEE, 0x0E, 0x77, 0x71, 0x0A, 0xE0, 0xA7, 0x77,
  0x10, 0x20, 0xEC, 0x0E, 0x02, 0x77, 0x72, 0x84, 0x2B, 0xEE, 0xB2, 0x80, 0xC4, 0x00, 0x60, 0xCF,
  0xC8, 0x1E, 0xA1, 0x76, 0x09, 0xFF, 0x90, 0xE0, 0x27, 0x40, 0x3F, 0xFB, 0x0A, 0x74, 0x09, 0xFF,
  0xB0, 0xE7, 0x40, 0xDB, 0x05, 0x30, 0x3F, 0xA0, 0xE7, 0x40, 0x9A, 0x0D, 0x40, 0xAF, 0xA0, 0xA7,
  0x58, 0x17, 0x82, 0x30, 0x2F, 0xB0, 0x37, 0x74, 0x08, 0xFA, 0x0C, 0x77, 0x50, 0xEF, 0xA0, 0x57,
  0x74, 0x07, 0xFA, 0x0D, 0x75, 0x82, 0x59, 0xDE, 0x30, 0xDF, 0xA0, 0x67, 0x30, 0x40, 0xDC, 0x20,
  0x5F, 0xA0, 0xE7, 0x30, 0x8E, 0x20, 0xBF, 0xA0, 0x77, 0x20, 0x8F, 0x2F, 0xF8, 0x1D, 0xA1, 0x20,
  0x4D, 0x08, 0x03, 0x30, 0xEF, 0xF9, 0x82, 0xE1, 0x0D, 0xB0, 0xD0, 0x35, 0x09, 0xFF, 0xA0, 0xA0,
  0x5C, 0x03, 0x60, 0x10, 0xEF, 0xF9, 0x0D, 0x09, 0xB0, 0x87, 0x18, 0x11, 0xAE, 0xFF, 0x0D, 0xB0,
  0x37, 0x77, 0xC0, 0xEB, 0x77, 0x71, 0xC0, 0xEB, 0x75, 0xB0, 0xE6, 0xC0, 0xDB, 0x03, 0x73, 0x03,
  0xB0, 0xD6, 0xC0, 0x9B, 0x08, 0x73, 0x08, 0xB0, 0x96, 0xC0, 0x5C, 0x03, 0x71, 0x03, 0xC0, 0x56,
  0xC1, 0x0D, 0xB0, 0xD0, 0x36, 0x03, 0x0D, 0xB0, 0xD7, 0xC1, 0x04, 0xD0, 0x80, 0x32, 0x03, 0x08,
  0xD0, 0x47, 0xC2, 0x08, 0xFF, 0x08, 0x71, 0x0D, 0xA0, 0xD3, 0x08, 0xFD, 0x08, 0x72, 0x82, 0x4D,
  0xD4, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x76, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_accessible_forward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 5, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_accessible_forward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_accessible 48x48, 4-bit Alpha,  RLE, 222 bytes.
static const unsigned char ic_round_48_action_accessible_data[] PROGMEM = {
  0x74, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x60, 0xAE, 0x0A, 0x77,
  0x60, 0xDE, 0x0D, 0x77, 0x60, 0xDE, 0x0D, 0x77, 0x60, 0xAE, 0x0A, 0x77, 0x60, 0x10, 0xEC, 0x0E,
  0x01, 0x77, 0x78, 0x41, 0xAD, 0xDA, 0x18, 0x09, 0x92, 0x08, 0x41, 0x9D, 0xD9, 0x27, 0x77, 0x01,
  0x0D, 0xD0, 0x47, 0x76, 0x09, 0xE0, 0xE0, 0x37, 0x75, 0x0D, 0xF0, 0xE0, 0x27, 0x74, 0xFA, 0x0D,
  0x02, 0x77, 0x3F, 0xB0, 0xE0, 0x37, 0x72, 0xFD, 0x08, 0x01, 0x77, 0xFF, 0x81, 0x95, 0x17, 0x4F,
  0x90, 0x7F, 0x90, 0x67, 0x3F, 0x91, 0x03, 0x0B, 0xE0, 0xE6, 0x05, 0x0A, 0x2F, 0x93, 0x04, 0x0B,
  0xC0, 0xC4, 0x05, 0x0D, 0xA2, 0xF9, 0x58, 0x32, 0x6A, 0xA2, 0x30, 0x8C, 0x2F, 0x97, 0x50, 0x8D,
  0x2F, 0x97, 0x40, 0x4D, 0x09, 0x2F, 0x97, 0x40, 0xDB, 0x0E, 0x03, 0x3F, 0xF8, 0x3D, 0xA1, 0x05,
  0xC0, 0x34, 0x0D, 0xFF, 0x98, 0x1E, 0x1A, 0xB0, 0x95, 0x0A, 0xFF, 0xA0, 0xA0, 0xDB, 0x03, 0x50,
  0x10, 0xEF, 0xF9, 0x0D, 0x0E, 0xB0, 0x16, 0x81, 0x1A, 0xDF, 0xF0, 0xEB, 0x77, 0x6C, 0x0D, 0xB0,
  0x37, 0x75, 0xC0, 0x9B, 0x08, 0x73, 0x09, 0xB0, 0xA4, 0xC0, 0x5C, 0x02, 0x71, 0x03, 0xC0, 0x54,
  0xC1, 0x0D, 0xB0, 0xD0, 0x26, 0x03, 0x0E, 0xB0, 0xD5, 0xC1, 0x04, 0xD8, 0x48, 0x30, 0x13, 0x9D,
  0x05, 0x5C, 0x20, 0x8F, 0xF0, 0x86, 0xC3, 0x08, 0xFD, 0x08, 0x7C, 0x40, 0x40, 0xDF, 0x90, 0xD0,
  0x47, 0x10, 0xDA, 0x0D, 0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x38, 0x24, 0xDD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_accessible() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 43), Box(0, 0, 47, 47),
      ic_round_48_action_accessible_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_account_balance 48x48, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_round_48_action_account_balance_data[] PROGMEM = {
  0x77, 0x38, 0x22, 0x66, 0x27, 0x77, 0x74, 0x02, 0x0A, 0xC0, 0xA0, 0x27, 0x77, 0x70, 0x10, 0x9F,
  0x90, 0x90, 0x17, 0x77, 0x30, 0x10, 0x8F, 0xD0, 0x80, 0x17, 0x76, 0x81, 0x18, 0xEF, 0xF8, 0x1E,
  0x81, 0x77, 0x30, 0x70, 0xEF, 0xFC, 0x0E, 0x07, 0x77, 0x06, 0x0E, 0xFF, 0xF9, 0x0E, 0x06, 0x73,
  0x05, 0x0D, 0xFF, 0xFD, 0x0D, 0x05, 0x60, 0x40, 0xCF, 0xFF, 0xFA, 0x0C, 0x04, 0x20, 0x10, 0xBF,
  0xFF, 0xFE, 0x81, 0xB1, 0xB8, 0x0C, 0x0F, 0x0B, 0x0E, 0x80, 0xC0, 0xF0, 0xE0, 0xB8, 0x0C, 0x0F,
  0x81, 0xB1, 0xBF, 0xFF, 0xFE, 0x0B, 0x01, 0x80, 0xAB, 0x10, 0x82, 0x8D, 0xD8, 0x71, 0x82, 0x8D,
  0xD8, 0x71, 0x82, 0x8D, 0xD8, 0x72, 0x08, 0xC0, 0x86, 0x08, 0xC0, 0x86, 0x08, 0xC0, 0x87, 0x10,
  0xDC, 0x0D, 0x60, 0xDC, 0x0D, 0x60, 0xDC, 0x0D, 0x71, 0xE6, 0xE6, 0xE7, 0x1E, 0x6E, 0x6E, 0x71,
  0xE6, 0xE6, 0xE7, 0x1E, 0x6E, 0x6E, 0x71, 0xE6, 0xE6, 0xE7, 0x1E, 0x6E, 0x6E, 0x71, 0xE6, 0xE6,
  0xE7, 0x1E, 0x6E, 0x6E, 0x71, 0x0D, 0xC0, 0xD6, 0x0D, 0xC0, 0xD6, 0x0D, 0xC0, 0xD7, 0x10, 0x8C,
  0x08, 0x60, 0x8C, 0x08, 0x60, 0x8C, 0x08, 0x72, 0x82, 0x8D, 0xD8, 0x71, 0x82, 0x8D, 0xD8, 0x71,
  0x82, 0x8D, 0xD8, 0x80, 0xAB, 0x20, 0x08, 0x0D, 0xFF, 0xFF, 0xC8, 0x2D, 0x80, 0x88, 0x0C, 0x0F,
  0x08, 0x0D, 0x80, 0xC0, 0xF0, 0x0D, 0x80, 0xC0, 0xF0, 0xD0, 0x88, 0x0C, 0x0F, 0x82, 0x80, 0x8D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_account_balance() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_account_balance_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_account_balance_wallet 48x48, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_round_48_action_account_balance_wallet_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x13, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x12, 0x0A,
  0xFF, 0xFF, 0xE0, 0xA2, 0x0D, 0xFF, 0xFF, 0xE0, 0xD2, 0x80, 0xC0, 0xF2, 0x80, 0xC0, 0xF2, 0xFF,
  0x98, 0x1D, 0x51, 0x77, 0x6F, 0xF0, 0xD0, 0x17, 0x77, 0x1F, 0xF0, 0x57, 0x77, 0x2F, 0xF0, 0x17,
  0x77, 0x2F, 0xF4, 0x04, 0x0D, 0xFF, 0xFF, 0xC4, 0x0D, 0xFF, 0xFF, 0xD4, 0xFF, 0xFF, 0xE4, 0xFF,
  0xFF, 0xE4, 0xFF, 0xFF, 0xE4, 0xE8, 0x27, 0x11, 0x7F, 0xFF, 0xB4, 0xD0, 0x74, 0x07, 0xFF, 0xFA,
  0x4D, 0x01, 0x40, 0x1F, 0xFF, 0xA4, 0xD0, 0x14, 0x01, 0xFF, 0xFA, 0x4D, 0x07, 0x40, 0x7F, 0xFF,
  0xA4, 0xE8, 0x27, 0x11, 0x7F, 0xFF, 0xB4, 0xFF, 0xFF, 0xE4, 0xFF, 0xFF, 0xE4, 0xFF, 0xFF, 0xE4,
  0x0D, 0xFF, 0xFF, 0xD4, 0x04, 0x0D, 0xFF, 0xFF, 0xC0, 0x17, 0x77, 0x2F, 0xF0, 0x57, 0x77, 0x2F,
  0xF0, 0xD0, 0x17, 0x77, 0x1F, 0xF9, 0x81, 0xD5, 0x17, 0x76, 0x80, 0xC0, 0xF2, 0x80, 0xC0, 0xF2,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD2, 0x0A, 0xFF, 0xFF, 0xE0, 0xA2, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0,
  0x13, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_account_balance_wallet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_account_balance_wallet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_account_box 48x48, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_round_48_action_account_box_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0x9A, 0x2F, 0x81, 0xE7, 0x22, 0x81, 0x27, 0xEF, 0xFF,
  0xE0, 0xA7, 0x10, 0xAF, 0xFF, 0xC0, 0xA7, 0x30, 0xAF, 0xFF, 0xA0, 0xE7, 0x50, 0xEF, 0xFF, 0x90,
  0x77, 0x50, 0x7F, 0xFF, 0x90, 0x27, 0x50, 0x2F, 0xFF, 0x97, 0x7F, 0xFF, 0x97, 0x7F, 0xFF, 0x90,
  0x27, 0x50, 0x2F, 0xFF, 0x90, 0x77, 0x50, 0x7F, 0xFF, 0x90, 0xE7, 0x50, 0xEF, 0xFF, 0xA0, 0xA7,
  0x30, 0xAF, 0xFF, 0xC0, 0xA7, 0x10, 0xAF, 0xFF, 0xE8, 0x1E, 0x72, 0x28, 0x12, 0x7E, 0x80, 0xAC,
  0x6F, 0x83, 0xD8, 0x43, 0x12, 0x83, 0x13, 0x48, 0xDF, 0xFF, 0x81, 0xE7, 0x17, 0x58, 0x11, 0x7E,
  0xFF, 0xA0, 0xE0, 0x67, 0x74, 0x06, 0x0E, 0xFE, 0x0B, 0x01, 0x77, 0x60, 0x10, 0xBF, 0xC0, 0x67,
  0x77, 0x30, 0x6F, 0xA0, 0x97, 0x77, 0x50, 0x9F, 0x90, 0x27, 0x77, 0x50, 0x2F, 0x97, 0x77, 0x7C,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_account_box() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_account_box_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_account_circle 48x48, 4-bit Alpha,  RLE, 302 bytes.
static const unsigned char ic_round_48_action_account_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFD, 0x81, 0xE7, 0x22, 0x81, 0x27, 0xEF, 0xD0, 0x55, 0x01, 0x0E,
  0xFC, 0x0A, 0x71, 0x0A, 0xFC, 0x0E, 0x01, 0x40, 0x9F, 0xC0, 0xA7, 0x30, 0xAF, 0xC0, 0x93, 0x01,
  0xFC, 0x0E, 0x75, 0x0E, 0xFC, 0x01, 0x20, 0x8F, 0xC0, 0x77, 0x50, 0x7F, 0xC0, 0x82, 0x0D, 0xFC,
  0x02, 0x75, 0x02, 0xFC, 0x81, 0xD0, 0x3F, 0xD7, 0x7F, 0xD0, 0x30, 0x7F, 0xD7, 0x7F, 0xD0, 0x70,
  0xAF, 0xD0, 0x27, 0x50, 0x2F, 0xD0, 0xA0, 0xCF, 0xD0, 0x77, 0x50, 0x7F, 0xD0, 0xC0, 0xEF, 0xD0,
  0xE7, 0x50, 0xEF, 0xD0, 0xEF, 0xF0, 0xA7, 0x30, 0xAF, 0xFF, 0xF9, 0x0A, 0x71, 0x0A, 0xFF, 0x90,
  0xEF, 0xF9, 0x81, 0xE7, 0x22, 0x81, 0x27, 0xEF, 0xF9, 0x0E, 0x0C, 0x80, 0xC2, 0xF0, 0xC0, 0xA8,
  0x0C, 0x2F, 0x0A, 0x07, 0x80, 0xC2, 0xF0, 0x70, 0x38, 0x0C, 0x2F, 0x81, 0x30, 0xDF, 0xD8, 0x3D,
  0x94, 0x31, 0x28, 0x31, 0x34, 0x9D, 0xFD, 0x0D, 0x20, 0x8F, 0xA8, 0x1E, 0x81, 0x75, 0x81, 0x18,
  0xEF, 0xA0, 0x82, 0x01, 0xF0, 0xE0, 0x67, 0x74, 0x06, 0x0E, 0xF0, 0x13, 0x09, 0xD0, 0xB0, 0x17,
  0x76, 0x01, 0x0B, 0xD0, 0x94, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01,
  0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0D, 0x02, 0x77, 0x40, 0x20,
  0xDC, 0x09, 0x72, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x81, 0xD6, 0x17, 0x38,
  0x11, 0x6D, 0xD0, 0xA7, 0x60, 0x9F, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10,
  0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D,
  0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_account_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_account_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_add_card 48x48, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_round_48_action_add_card_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x50, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x40,
  0x98, 0x0C, 0x2F, 0x0A, 0x40, 0xD8, 0x0C, 0x2F, 0x0D, 0x4C, 0x77, 0x77, 0x4C, 0x4C, 0x77, 0x77,
  0x4C, 0x4C, 0x77, 0x77, 0x4C, 0x4C, 0x77, 0x77, 0x4C, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48,
  0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48, 0x0C,
  0x4F, 0x4C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77, 0x77,
  0x28, 0x24, 0xDD, 0x46, 0xC7, 0x77, 0x72, 0x0D, 0xA0, 0xD6, 0xC7, 0x77, 0x72, 0xC6, 0xC7, 0x77,
  0x72, 0xC6, 0xC7, 0x77, 0x72, 0xC6, 0xC7, 0x77, 0x72, 0xC6, 0xC7, 0x77, 0x30, 0x40, 0xDF, 0xD0,
  0xD0, 0x4C, 0x77, 0x73, 0x0D, 0xFF, 0x00, 0xDF, 0xFF, 0x0D, 0x04, 0x40, 0xDF, 0xF0, 0xD0, 0xAF,
  0xFF, 0x90, 0xD4, 0x04, 0x0D, 0xFD, 0x82, 0xD4, 0x1E, 0xFF, 0xF0, 0xD7, 0x3C, 0x78, 0x11, 0xAE,
  0xFF, 0xC0, 0xD0, 0x47, 0x3C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x00, 0xDA, 0x0D,
  0x80, 0xC4, 0x08, 0x24, 0xDD, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_add_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 47, 43), Box(0, 0, 47, 47),
      ic_round_48_action_add_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_addchart 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_48_action_addchart_data[] PROGMEM = {
  0x77, 0x77, 0x82, 0x4D, 0xD4, 0x77, 0x77, 0x60, 0xDA, 0x0D, 0x78, 0x11, 0xAD, 0xFB, 0x0D, 0x04,
  0x75, 0xC6, 0x01, 0x0E, 0xFE, 0x0D, 0x75, 0xC6, 0x0A, 0xFF, 0x0D, 0x75, 0xC6, 0x0D, 0xFE, 0x0D,
  0x04, 0x75, 0xC6, 0xC7, 0x74, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xC7, 0x74, 0x0D, 0xFF, 0x0D, 0xC7,
  0x74, 0x0D, 0xFF, 0x0D, 0xC7, 0x74, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xC7, 0x77, 0x3C, 0x6C, 0x77,
  0x73, 0xC6, 0xC7, 0x77, 0x3C, 0x6C, 0x77, 0x73, 0xC6, 0xC7, 0x58, 0x24, 0xDD, 0x47, 0x10, 0xDA,
  0x0D, 0x6C, 0x75, 0x0D, 0xA0, 0xD7, 0x18, 0x24, 0xDD, 0x46, 0xC7, 0x5C, 0x77, 0x4C, 0x75, 0xC7,
  0x74, 0xC4, 0x82, 0x4D, 0xD4, 0x4C, 0x77, 0x4C, 0x40, 0xDA, 0x0D, 0x4C, 0x77, 0x4C, 0x4C, 0x4C,
  0x77, 0x4C, 0x4C, 0x4C, 0x77, 0x4C, 0x4C, 0x4C, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x2C,
  0x4C, 0x4C, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x2C, 0x4C, 0x4C, 0x4C, 0x4C, 0x2C, 0x4C, 0x4C,
  0x4C, 0x4C, 0x2C, 0x4C, 0x4C, 0x4C, 0x4C, 0x2C, 0x4C, 0x4C, 0x4C, 0x4C, 0x2C, 0x4C, 0x4C, 0x4C,
  0x4C, 0x2C, 0x4C, 0x4C, 0x4C, 0x4C, 0x2C, 0x77, 0x77, 0xC2, 0xC7, 0x77, 0x7C, 0x2C, 0x77, 0x77,
  0xC2, 0xC7, 0x77, 0x7C, 0x20, 0xDF, 0xFF, 0xFE, 0x0D, 0x20, 0xAF, 0xFF, 0xFE, 0x0A, 0x20, 0x10,
  0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x38, 0x11, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_addchart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_addchart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_add_home 48x48, 4-bit Alpha,  RLE, 249 bytes.
static const unsigned char ic_round_48_action_add_home_data[] PROGMEM = {
  0x76, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x77, 0x30, 0x50, 0xEC, 0x0E, 0x05, 0x77, 0x77, 0x10, 0x9F,
  0x90, 0x97, 0x77, 0x50, 0x20, 0xCF, 0xB0, 0xC0, 0x27, 0x77, 0x20, 0x50, 0xEF, 0xD0, 0xE0, 0x57,
  0x77, 0x09, 0xFF, 0xA0, 0x97, 0x74, 0x02, 0x0C, 0xFF, 0xC0, 0xC0, 0x27, 0x71, 0x05, 0x0E, 0xFF,
  0xE0, 0xE0, 0x57, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x30, 0x20, 0xCF, 0xFF, 0xD0, 0xC0, 0x27, 0x02,
  0x0E, 0xFF, 0xFF, 0x0E, 0x02, 0x60, 0xAF, 0xFF, 0xFA, 0x0A, 0x60, 0xEF, 0xFF, 0xFA, 0x0E, 0x6F,
  0xFF, 0xFC, 0x6F, 0xFF, 0xFC, 0x6F, 0xFF, 0xA8, 0x2B, 0x74, 0x12, 0x81, 0x14, 0x76, 0xFF, 0xF0,
  0x90, 0x27, 0x71, 0xFF, 0xD0, 0xD0, 0x37, 0x73, 0xFF, 0xC0, 0xB0, 0x17, 0x74, 0xFF, 0xB0, 0xB6,
  0x86, 0x59, 0xDE, 0xED, 0x95, 0x6F, 0xFA, 0x0D, 0x01, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x44, 0xFF,
  0xA0, 0x34, 0x08, 0xFD, 0x08, 0x3F, 0xF9, 0x09, 0x40, 0x8F, 0xF0, 0x82, 0xFF, 0x90, 0x23, 0x04,
  0xF2, 0xF0, 0x41, 0xFF, 0x0B, 0x40, 0xDF, 0x2F, 0x0D, 0x1F, 0xF0, 0x73, 0x05, 0xF9, 0x2F, 0x90,
  0x5F, 0xF0, 0x33, 0x09, 0xF9, 0x2F, 0x90, 0x9F, 0xF0, 0x13, 0x0D, 0xF9, 0x2F, 0x90, 0xDF, 0xF4,
  0x0E, 0xB7, 0x5B, 0x0E, 0xFF, 0x40, 0xEB, 0x75, 0xB0, 0xEF, 0xF0, 0x13, 0x0D, 0xF9, 0x2F, 0x90,
  0x0D, 0xFE, 0x03, 0x30, 0x9F, 0x92, 0xF9, 0x09, 0x0A, 0xFE, 0x07, 0x30, 0x5F, 0x92, 0xF9, 0x81,
  0x51, 0xEF, 0xD0, 0xC4, 0x0D, 0xF2, 0xF0, 0xD2, 0x81, 0x1A, 0xDF, 0xC0, 0x23, 0x04, 0xF2, 0xF0,
  0x47, 0x77, 0x08, 0xFF, 0x08, 0x77, 0x72, 0x08, 0xFD, 0x08, 0x77, 0x74, 0x04, 0x0D, 0xF9, 0x0D,
  0x04, 0x77, 0x77, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_add_home() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 7, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_add_home_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_add_shopping_cart 48x48, 4-bit Alpha,  RLE, 306 bytes.
static const unsigned char ic_round_48_action_add_shopping_cart_data[] PROGMEM = {
  0x77, 0x68, 0x24, 0xDD, 0x48, 0x0C, 0x00, 0x0D, 0xA0, 0xD7, 0x72, 0x04, 0x0D, 0xC0, 0xC7, 0x6C,
  0x77, 0x20, 0xDE, 0x03, 0x75, 0xC7, 0x72, 0x0D, 0xE0, 0xB7, 0x5C, 0x77, 0x20, 0x40, 0xDE, 0x03,
  0x74, 0xC7, 0x76, 0x0B, 0xB0, 0xA5, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x60, 0x10, 0x36, 0x04, 0xC0,
  0x24, 0x0D, 0xFF, 0x0D, 0x58, 0x23, 0xEF, 0xC6, 0x0C, 0xB0, 0x94, 0x0D, 0xFF, 0x0D, 0x50, 0xCB,
  0x03, 0x50, 0x5C, 0x01, 0x30, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x05, 0xC0, 0x16, 0x0D, 0xB0, 0x87,
  0x2C, 0x73, 0x0D, 0xB0, 0x97, 0x06, 0xB0, 0xE0, 0x17, 0x1C, 0x72, 0x06, 0xC0, 0x27, 0x10, 0xDB,
  0x07, 0x71, 0xC7, 0x20, 0xDB, 0x09, 0x72, 0x06, 0xB0, 0xE7, 0x1C, 0x71, 0x07, 0xB0, 0xE0, 0x17,
  0x30, 0xEB, 0x07, 0x70, 0xDA, 0x0D, 0x71, 0x0E, 0xB0, 0x87, 0x40, 0x7B, 0x0D, 0x78, 0x24, 0xDD,
  0x47, 0x08, 0xB0, 0xE0, 0x17, 0x40, 0x10, 0xEB, 0x06, 0x77, 0x20, 0x10, 0xEB, 0x07, 0x76, 0x08,
  0xB0, 0xD7, 0x72, 0x08, 0xB0, 0xD7, 0x70, 0x1C, 0x05, 0x77, 0x02, 0xC0, 0x67, 0x71, 0x09, 0xB0,
  0xC7, 0x70, 0x9B, 0x0D, 0x77, 0x20, 0x2F, 0xFF, 0x90, 0x57, 0x73, 0x0E, 0xFF, 0xE0, 0xC7, 0x73,
  0x08, 0xFF, 0xE0, 0xE0, 0x37, 0x72, 0x01, 0x0E, 0xFF, 0xC8, 0x1E, 0xB3, 0x77, 0x30, 0x9B, 0x0D,
  0x77, 0x77, 0x60, 0x3C, 0x05, 0x77, 0x77, 0x60, 0xAB, 0x0C, 0x77, 0x77, 0x70, 0xEB, 0x04, 0x77,
  0x77, 0x70, 0xEF, 0xFF, 0xC0, 0xD0, 0x47, 0x50, 0xAF, 0xFF, 0xD0, 0xD7, 0x50, 0x20, 0xEF, 0xFF,
  0xC0, 0xD7, 0x68, 0x12, 0xAE, 0xFF, 0xF9, 0x0D, 0x04, 0x80, 0x9B, 0x10, 0x84, 0x1A, 0xDD, 0xA1,
  0x77, 0x84, 0x1A, 0xDD, 0xA1, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0E, 0x01,
  0x75, 0x09, 0xE0, 0xA7, 0x50, 0x9E, 0x0A, 0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xDE, 0x0D, 0x75, 0x0D,
  0xE0, 0xD7, 0x50, 0xDE, 0x0D, 0x75, 0x09, 0xE0, 0xA7, 0x50, 0x9E, 0x0A, 0x75, 0x01, 0x0E, 0xC0,
  0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x76, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x84, 0x1A, 0xDD,
  0xA1, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_add_shopping_cart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_add_shopping_cart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_add_task 48x48, 4-bit Alpha,  RLE, 379 bytes.
static const unsigned char ic_round_48_action_add_task_data[] PROGMEM = {
  0x77, 0x83, 0x27, 0x9B, 0xDA, 0x83, 0xDC, 0xA7, 0x27, 0x77, 0x71, 0x81, 0x17, 0xCF, 0xD8, 0x1D,
  0x71, 0x77, 0x74, 0x07, 0x0E, 0xFF, 0xB0, 0x77, 0x77, 0x10, 0x40, 0xDF, 0xFE, 0x01, 0x77, 0x60,
  0x7E, 0x83, 0xEA, 0x63, 0x12, 0x83, 0x13, 0x6A, 0xEC, 0x01, 0x58, 0x17, 0x81, 0x74, 0x09, 0xD0,
  0xD0, 0x67, 0x58, 0x26, 0xDE, 0x75, 0x0B, 0xA0, 0xD7, 0x30, 0x9D, 0x07, 0x77, 0x71, 0x0B, 0xC0,
  0x17, 0x10, 0x7C, 0x0D, 0x02, 0x77, 0x71, 0x0B, 0xC0, 0xB7, 0x10, 0x4C, 0x0C, 0x01, 0x77, 0x71,
  0x0B, 0xC0, 0xC0, 0x17, 0x10, 0xDB, 0x0D, 0x01, 0x77, 0x71, 0x0B, 0xC0, 0xC0, 0x17, 0x10, 0x7C,
  0x03, 0x77, 0x71, 0x0B, 0xC0, 0xC0, 0x17, 0x10, 0x10, 0xEB, 0x07, 0x77, 0x71, 0x0B, 0xC0, 0xC0,
  0x17, 0x20, 0x7B, 0x0D, 0x77, 0x71, 0x0B, 0xC0, 0xC0, 0x17, 0x30, 0xCB, 0x06, 0x77, 0x70, 0xBC,
  0x0C, 0x01, 0x73, 0x02, 0xB0, 0xE7, 0x77, 0x0B, 0xC0, 0xC0, 0x17, 0x40, 0x7B, 0x0A, 0x77, 0x60,
  0xBC, 0x0C, 0x01, 0x75, 0x09, 0xB0, 0x67, 0x75, 0x0B, 0xC0, 0xC0, 0x17, 0x60, 0xBB, 0x03, 0x77,
  0x40, 0xBC, 0x0C, 0x01, 0x77, 0x0E, 0xB0, 0x16, 0x03, 0x73, 0x0B, 0xC0, 0xC0, 0x17, 0x71, 0xC0,
  0x14, 0x83, 0x1D, 0xFE, 0x37, 0x0B, 0xC0, 0xC0, 0x17, 0x72, 0xC0, 0x14, 0x06, 0xB0, 0xE0, 0x35,
  0x0B, 0xC0, 0xC0, 0x17, 0x82, 0x4D, 0xD4, 0x60, 0xEB, 0x01, 0x40, 0x4C, 0x0E, 0x03, 0x30, 0xBC,
  0x0C, 0x01, 0x71, 0x0D, 0xA0, 0xD6, 0x0C, 0xB0, 0x45, 0x08, 0xC8, 0x2E, 0x30, 0xBC, 0x0C, 0x01,
  0x72, 0xC6, 0x0A, 0xB0, 0x76, 0x08, 0xC0, 0xE0, 0xCC, 0x0C, 0x01, 0x73, 0xC6, 0x07, 0xB0, 0xA7,
  0x08, 0xF9, 0x0C, 0x01, 0x74, 0xC6, 0x03, 0xB0, 0xE0, 0x17, 0x08, 0xE0, 0xC0, 0x17, 0x5C, 0x70,
  0xDB, 0x07, 0x71, 0x08, 0xC0, 0xC0, 0x17, 0x04, 0x0D, 0xFD, 0x82, 0xD4, 0x08, 0xB0, 0xD7, 0x20,
  0x7A, 0x0C, 0x01, 0x71, 0x0D, 0xFF, 0x81, 0xD0, 0x1C, 0x07, 0x72, 0x03, 0x04, 0x73, 0x0D, 0xFF,
  0x0D, 0x20, 0x9C, 0x03, 0x77, 0x60, 0x40, 0xDF, 0xD0, 0xD0, 0x42, 0x01, 0x0E, 0xB0, 0xD0, 0x17,
  0x77, 0x4C, 0x72, 0x05, 0xC0, 0xD0, 0x27, 0x77, 0x3C, 0x73, 0x09, 0xC0, 0xE0, 0x37, 0x77, 0x2C,
  0x74, 0x0B, 0xD0, 0x87, 0x77, 0x1C, 0x75, 0x0B, 0xD8, 0x1D, 0x61, 0x77, 0x50, 0xDA, 0x0D, 0x76,
  0x09, 0xF8, 0x2B, 0x64, 0x22, 0x85, 0x13, 0x6B, 0xEF, 0x66, 0x82, 0x4D, 0xD4, 0x77, 0x05, 0x0E,
  0xFF, 0xC7, 0x77, 0x40, 0x10, 0x9F, 0xFA, 0x0E, 0x77, 0x76, 0x81, 0x18, 0xDF, 0xD0, 0xD0, 0x47,
  0x77, 0x72, 0x89, 0x23, 0x7A, 0xCD, 0xFE, 0xDB, 0xA6, 0x27, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_add_task() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 47, 43), Box(0, 0, 47, 47),
      ic_round_48_action_add_task_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_add_to_drive 48x48, 4-bit Alpha,  RLE, 276 bytes.
static const unsigned char ic_round_48_action_add_to_drive_data[] PROGMEM = {
  0x77, 0x0B, 0xFC, 0x04, 0x77, 0x77, 0x10, 0x2F, 0xC0, 0xC7, 0x77, 0x72, 0x08, 0xFC, 0x06, 0x77,
  0x75, 0x07, 0x20, 0x10, 0xEF, 0xB0, 0xE7, 0x77, 0x48, 0x18, 0xF2, 0x20, 0x6F, 0xC0, 0x87, 0x77,
  0x28, 0x21, 0xEF, 0xB3, 0x0C, 0xFB, 0x0E, 0x01, 0x77, 0x71, 0x09, 0xB0, 0x42, 0x03, 0xFC, 0x09,
  0x77, 0x70, 0x3C, 0x0D, 0x30, 0xAF, 0xC0, 0x37, 0x76, 0x0B, 0xD0, 0x72, 0x01, 0x0E, 0xFB, 0x0B,
  0x77, 0x50, 0x4E, 0x0E, 0x01, 0x20, 0x7F, 0xC0, 0x47, 0x74, 0x0D, 0xF0, 0x93, 0x0D, 0xFB, 0x0D,
  0x77, 0x30, 0x6F, 0xA0, 0x22, 0x05, 0xFC, 0x06, 0x77, 0x10, 0x10, 0xEF, 0xA0, 0xB3, 0x0C, 0xFB,
  0x0E, 0x01, 0x77, 0x08, 0xFC, 0x05, 0x20, 0x3F, 0xC0, 0x87, 0x60, 0x2F, 0xD0, 0x63, 0x09, 0xFC,
  0x02, 0x75, 0x0A, 0xFC, 0x0C, 0x40, 0x10, 0xEF, 0xB0, 0xA7, 0x40, 0x3F, 0xD0, 0x35, 0x07, 0xD8,
  0x2D, 0x94, 0x27, 0x60, 0xCF, 0xC0, 0xA7, 0x0D, 0xA0, 0xE0, 0x67, 0x72, 0x05, 0xFD, 0x02, 0x78,
  0x15, 0xFA, 0x77, 0x40, 0xDF, 0xC0, 0x87, 0x20, 0x67, 0x74, 0x07, 0xFC, 0x0D, 0x77, 0x3C, 0x70,
  0x10, 0xEF, 0xC0, 0x57, 0x73, 0xC7, 0x09, 0xFC, 0x0C, 0x77, 0x4C, 0x60, 0x2F, 0xD0, 0x37, 0x74,
  0xC6, 0x0B, 0xFC, 0x09, 0x77, 0x5C, 0x60, 0xBF, 0xB0, 0xE0, 0x12, 0x07, 0xE0, 0x47, 0x2C, 0x60,
  0x2F, 0xB0, 0x72, 0x01, 0x0E, 0xE0, 0x13, 0xFF, 0xA1, 0x09, 0xF9, 0x0D, 0x30, 0x9F, 0x4F, 0xFA,
  0x10, 0x1F, 0x90, 0x52, 0x03, 0xF9, 0x4F, 0xFA, 0x20, 0x8E, 0x0B, 0x30, 0xCF, 0x90, 0x23, 0xFF,
  0xA2, 0x01, 0x0E, 0xD0, 0x22, 0x05, 0xFA, 0x04, 0x72, 0xC7, 0x20, 0x7C, 0x09, 0x30, 0xDF, 0xA0,
  0x87, 0x2C, 0x73, 0x0D, 0xA0, 0xE0, 0x12, 0x08, 0xFB, 0x0D, 0x72, 0xC7, 0x30, 0x5A, 0x06, 0x20,
  0x2F, 0xD0, 0x67, 0x1C, 0x74, 0x0C, 0x0D, 0x30, 0xAF, 0xD0, 0xD0, 0x17, 0xC7, 0x40, 0x04, 0x20,
  0x3F, 0xF0, 0xA7, 0xC6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_add_to_drive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_add_to_drive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_admin_panel_settings 48x48, 4-bit Alpha,  RLE, 254 bytes.
static const unsigned char ic_round_48_action_admin_panel_settings_data[] PROGMEM = {
  0x76, 0x82, 0x48, 0x84, 0x77, 0x77, 0x18, 0x11, 0x7D, 0xC8, 0x1D, 0x71, 0x77, 0x73, 0x81, 0x29,
  0xEF, 0x98, 0x1E, 0x92, 0x77, 0x60, 0x40, 0xBF, 0xF0, 0xB0, 0x47, 0x72, 0x06, 0x0D, 0xFF, 0xC0,
  0xD0, 0x67, 0x50, 0x80, 0xEF, 0xFF, 0x90, 0xE0, 0x87, 0x10, 0x10, 0xDF, 0xFF, 0xD0, 0xD0, 0x16,
  0x09, 0xFF, 0xFF, 0x09, 0x60, 0xDF, 0xFF, 0xF0, 0xD6, 0xFF, 0xFF, 0xA6, 0xFF, 0xFF, 0xA6, 0xFF,
  0xFF, 0xA6, 0xFF, 0xFF, 0xA6, 0xFF, 0xFF, 0xA6, 0xFF, 0xFF, 0xA6, 0xFF, 0xFF, 0xA6, 0xFF, 0xFA,
  0x82, 0xD9, 0x42, 0x20, 0x16, 0x0D, 0xFF, 0xE0, 0xD0, 0x67, 0x60, 0xCF, 0xFD, 0x0A, 0x77, 0x10,
  0xBF, 0xFC, 0x08, 0x77, 0x20, 0x7F, 0xFB, 0x0A, 0x58, 0x62, 0x8C, 0xEE, 0xC8, 0x24, 0x03, 0xFF,
  0xA0, 0xD5, 0x09, 0xF9, 0x09, 0x40, 0xEF, 0xF9, 0x06, 0x40, 0xBC, 0x00, 0xDC, 0x0B, 0x30, 0x9F,
  0xF0, 0xD4, 0x09, 0xC0, 0x62, 0x06, 0xC0, 0x92, 0x03, 0xFF, 0x09, 0x30, 0x2C, 0x0D, 0x40, 0xDC,
  0x02, 0x20, 0xBF, 0xE0, 0x43, 0x08, 0xC0, 0xD4, 0x0D, 0xC0, 0x82, 0x03, 0xFE, 0x02, 0x30, 0xCD,
  0x06, 0x20, 0x6D, 0x0C, 0x30, 0x8F, 0xD4, 0x0E, 0xE0, 0x0D, 0xE0, 0xE4, 0x0D, 0xFC, 0x40, 0xEF,
  0xF0, 0xE4, 0x02, 0x0E, 0xFB, 0x01, 0x30, 0xCB, 0x81, 0xE7, 0x32, 0x81, 0x37, 0xEB, 0x0C, 0x50,
  0x3F, 0xB0, 0x43, 0x08, 0xA0, 0xD7, 0x10, 0xCA, 0x08, 0x60, 0x40, 0xEF, 0x90, 0x83, 0x02, 0xA0,
  0xC7, 0x10, 0xCA, 0x02, 0x70, 0x20, 0xDF, 0x0D, 0x40, 0x9A, 0x0C, 0x02, 0x40, 0x20, 0xCA, 0x09,
  0x73, 0x09, 0xF0, 0x54, 0x0B, 0xB8, 0x2B, 0x88, 0xBB, 0x0B, 0x75, 0x02, 0x0B, 0xD0, 0xD5, 0x09,
  0xF9, 0x09, 0x77, 0x18, 0x42, 0x7C, 0xC7, 0x26, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_admin_panel_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_admin_panel_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_ads_click 48x48, 4-bit Alpha,  RLE, 439 bytes.
static const unsigned char ic_round_48_action_ads_click_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x58, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x77, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x74, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x72,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x70, 0xAD, 0x0D, 0x06, 0x75, 0x06,
  0x0D, 0xD0, 0xA7, 0x50, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x73, 0x09, 0xC0, 0xD0, 0x37, 0x74,
  0x03, 0x0D, 0xC0, 0x97, 0x10, 0x5C, 0x0C, 0x01, 0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x50,
  0x10, 0xCC, 0x05, 0x60, 0x10, 0xEB, 0x0D, 0x01, 0x40, 0x10, 0x9F, 0xB0, 0x90, 0x14, 0x01, 0x0D,
  0xB0, 0xE0, 0x15, 0x09, 0xC0, 0x34, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x40, 0x3C, 0x09, 0x40, 0x1C,
  0x07, 0x40, 0x6F, 0xFA, 0x06, 0x40, 0x7C, 0x01, 0x30, 0x8B, 0x0D, 0x40, 0x4D, 0x81, 0xC6, 0x22,
  0x81, 0x26, 0xCD, 0x04, 0x40, 0xDB, 0x08, 0x30, 0xDB, 0x06, 0x30, 0x10, 0xEC, 0x06, 0x71, 0x06,
  0xC0, 0xE0, 0x13, 0x06, 0xB0, 0xD2, 0x03, 0xC4, 0x09, 0xC0, 0x47, 0x30, 0x3C, 0x09, 0x4C, 0x81,
  0x30, 0x7B, 0x0B, 0x30, 0x1C, 0x06, 0x75, 0x06, 0xC0, 0x13, 0x0B, 0xB8, 0x17, 0x0A, 0xB0, 0x63,
  0x06, 0xB0, 0xC7, 0x70, 0xCB, 0x06, 0x30, 0x6B, 0x81, 0xA0, 0xCB, 0x03, 0x30, 0xBB, 0x06, 0x77,
  0x06, 0xB0, 0xA3, 0x03, 0xB8, 0x1C, 0x0E, 0xB0, 0x23, 0x0D, 0xB0, 0x27, 0x71, 0x82, 0x5A, 0xED,
  0x30, 0x2B, 0x0E, 0x1C, 0x40, 0xEB, 0x77, 0x50, 0x34, 0xC1, 0xC4, 0x0E, 0xB7, 0x18, 0x11, 0x73,
  0x76, 0x0B, 0xB1, 0x0E, 0xB0, 0x23, 0x0D, 0xB0, 0x27, 0x06, 0xA8, 0x1E, 0x95, 0x74, 0x83, 0x15,
  0x90, 0xCB, 0x03, 0x30, 0xBB, 0x06, 0x70, 0x3E, 0x81, 0xB6, 0x27, 0x40, 0xAB, 0x06, 0x30, 0x6B,
  0x0C, 0x71, 0x0E, 0xF9, 0x81, 0xD8, 0x37, 0x10, 0x7B, 0x0B, 0x30, 0x1C, 0x06, 0x70, 0x9F, 0xC8,
  0x1E, 0x95, 0x50, 0x3C, 0x40, 0x9C, 0x03, 0x60, 0x5F, 0xF9, 0x06, 0x40, 0xDB, 0x06, 0x30, 0x10,
  0xEC, 0x06, 0x50, 0x1F, 0xF9, 0x07, 0x40, 0x8B, 0x0D, 0x40, 0x4D, 0x0C, 0x06, 0x40, 0xBF, 0xC8,
  0x1D, 0x72, 0x50, 0x1C, 0x07, 0x40, 0x6E, 0x05, 0x30, 0x6F, 0xA0, 0xC0, 0x27, 0x20, 0x9C, 0x03,
  0x40, 0x50, 0xEC, 0x0A, 0x30, 0x2F, 0xB0, 0x67, 0x20, 0x10, 0xEB, 0x0D, 0x01, 0x40, 0x10, 0x9B,
  0x0E, 0x40, 0xDF, 0xB0, 0x77, 0x20, 0x5C, 0x0C, 0x01, 0x58, 0x31, 0x6A, 0xD4, 0x30, 0x8F, 0xC0,
  0x77, 0x20, 0x9C, 0x0D, 0x03, 0x75, 0x03, 0xC0, 0xCF, 0x07, 0x72, 0x0A, 0xD0, 0x77, 0x50, 0xEB,
  0x02, 0x06, 0xF0, 0x77, 0x20, 0xAD, 0x0D, 0x06, 0x73, 0x09, 0xA0, 0xC2, 0x06, 0xF0, 0x77, 0x20,
  0x9F, 0x82, 0xB6, 0x32, 0x50, 0x5A, 0x07, 0x30, 0x6F, 0x07, 0x72, 0x05, 0x0E, 0xFB, 0x0C, 0x30,
  0x1A, 0x02, 0x40, 0x6F, 0x05, 0x72, 0x01, 0x09, 0xFB, 0x01, 0x30, 0x60, 0x76, 0x06, 0xE0, 0x57,
  0x48, 0x11, 0x8D, 0xF0, 0x57, 0x50, 0x6C, 0x08, 0x77, 0x18, 0x33, 0x7A, 0xCD, 0xA0, 0x97, 0x60,
  0x6A, 0x08, 0x80, 0xC2, 0x00, 0x40, 0x53,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_ads_click() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 44, 44), Box(0, 0, 47, 47),
      ic_round_48_action_ads_click_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_alarm_add 48x48, 4-bit Alpha,  RLE, 375 bytes.
static const unsigned char ic_round_48_action_alarm_add_data[] PROGMEM = {
  0x78, 0x16, 0x71, 0x77, 0x48, 0x11, 0x76, 0x75, 0x01, 0x0C, 0xA0, 0xB7, 0x74, 0x0C, 0xA0, 0xC0,
  0x17, 0x20, 0x30, 0xEC, 0x77, 0x4C, 0x0E, 0x03, 0x70, 0x5D, 0x0A, 0x77, 0x40, 0xAD, 0x05, 0x50,
  0x8D, 0x0A, 0x48, 0x92, 0x15, 0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x40, 0xAD, 0x08, 0x30, 0xAD, 0x07,
  0x30, 0x40, 0xBF, 0xD0, 0xB0, 0x43, 0x08, 0xD8, 0x1A, 0x0A, 0xC0, 0xE0, 0x52, 0x03, 0x0B, 0xFF,
  0xA0, 0xB0, 0x32, 0x05, 0xD0, 0xAC, 0x0D, 0x03, 0x20, 0x8F, 0xFE, 0x08, 0x20, 0x30, 0xEC, 0x0B,
  0xA8, 0x3C, 0x10, 0x1B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE8, 0x3B, 0x10, 0x1C, 0xA8,
  0x2B, 0x17, 0x62, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x28, 0x16, 0x71,
  0x50, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x20, 0x8C, 0x0B, 0x01, 0x77, 0x20, 0x10,
  0xBC, 0x08, 0x70, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x60, 0xBB, 0x0D, 0x01, 0x77, 0x60, 0x10,
  0xDB, 0x0B, 0x50, 0x4C, 0x03, 0x72, 0x82, 0x4D, 0xD4, 0x72, 0x03, 0xC0, 0x44, 0x0B, 0xB0, 0xA7,
  0x30, 0xDA, 0x0D, 0x73, 0x0A, 0xB0, 0xB3, 0x01, 0xC0, 0x27, 0x3C, 0x73, 0x02, 0xC0, 0x12, 0x05,
  0xB0, 0xC7, 0x4C, 0x74, 0x0C, 0xB0, 0x52, 0x09, 0xB0, 0x77, 0x4C, 0x74, 0x07, 0xB0, 0x92, 0x0B,
  0xB0, 0x37, 0x4C, 0x74, 0x03, 0xB0, 0xB2, 0x0D, 0xB0, 0x25, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x50,
  0x2B, 0x0D, 0x20, 0xEB, 0x60, 0xDF, 0xF0, 0xD6, 0xB0, 0xE2, 0x0E, 0xB6, 0x0D, 0xFF, 0x0D, 0x6B,
  0x0E, 0x20, 0xDB, 0x02, 0x50, 0x40, 0xDF, 0xD0, 0xD0, 0x45, 0x02, 0xB0, 0xD2, 0x0B, 0xB0, 0x37,
  0x4C, 0x74, 0x03, 0xB0, 0xB2, 0x09, 0xB0, 0x77, 0x4C, 0x74, 0x07, 0xB0, 0x92, 0x05, 0xB0, 0xC7,
  0x4C, 0x74, 0x0C, 0xB0, 0x52, 0x01, 0xC0, 0x27, 0x3C, 0x73, 0x02, 0xC0, 0x13, 0x0B, 0xB0, 0xA7,
  0x30, 0xDA, 0x0D, 0x73, 0x0A, 0xB0, 0xB4, 0x04, 0xC0, 0x37, 0x28, 0x24, 0xDD, 0x47, 0x20, 0x3C,
  0x04, 0x50, 0xBB, 0x0D, 0x01, 0x77, 0x60, 0x10, 0xDB, 0x0B, 0x60, 0x3C, 0x0B, 0x77, 0x60, 0xBC,
  0x03, 0x70, 0x8C, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBC, 0x08, 0x72, 0x0B, 0xC0, 0xD0, 0x37, 0x70,
  0x30, 0xDC, 0x0B, 0x73, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x74, 0x01,
  0x0B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x70, 0x8F, 0xFE, 0x08, 0x77,
  0x30, 0x30, 0xBF, 0xFA, 0x0B, 0x03, 0x77, 0x60, 0x40, 0xBF, 0xD0, 0xB0, 0x47, 0x77, 0x38, 0x92,
  0x15, 0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_alarm_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 42, 43), Box(0, 0, 47, 47),
      ic_round_48_action_alarm_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_alarm_off 48x48, 4-bit Alpha,  RLE, 391 bytes.
static const unsigned char ic_round_48_action_alarm_off_data[] PROGMEM = {
  0x71, 0x81, 0x47, 0x17, 0x74, 0x81, 0x17, 0x67, 0x82, 0x3D, 0xD5, 0x48, 0x11, 0xDC, 0x77, 0x40,
  0xCA, 0x0C, 0x01, 0x50, 0xDB, 0x05, 0x40, 0x10, 0xD7, 0x74, 0xC0, 0xE0, 0x34, 0x0D, 0xC0, 0x54,
  0x01, 0x77, 0x40, 0xAD, 0x05, 0x30, 0x4D, 0x05, 0x78, 0x92, 0x16, 0x9C, 0xDF, 0xED, 0xB9, 0x51,
  0x40, 0xAD, 0x08, 0x30, 0x5D, 0x05, 0x50, 0x9F, 0xD0, 0xB0, 0x43, 0x07, 0xD0, 0xA2, 0x0B, 0xE0,
  0x54, 0x01, 0x0D, 0xFE, 0x0B, 0x03, 0x20, 0x50, 0xEC, 0x0B, 0x1F, 0x90, 0x54, 0x01, 0x0D, 0xFF,
  0x08, 0x20, 0x30, 0xDC, 0x10, 0xCA, 0x0D, 0xD0, 0x54, 0x82, 0x17, 0x41, 0x28, 0x22, 0x47, 0xCE,
  0x83, 0xB1, 0x01, 0xCA, 0x85, 0xC0, 0x17, 0x60, 0x5D, 0x05, 0x76, 0x02, 0x0A, 0xD0, 0xC0, 0x12,
  0x81, 0x67, 0x16, 0x0C, 0xD0, 0x57, 0x70, 0x30, 0xDC, 0x0B, 0x73, 0x08, 0xF0, 0x57, 0x70, 0x10,
  0xBC, 0x08, 0x71, 0x03, 0xFA, 0x05, 0x77, 0x10, 0xBC, 0x03, 0x70, 0xCB, 0x0D, 0x06, 0xD0, 0x57,
  0x70, 0x10, 0xDB, 0x0B, 0x60, 0x4C, 0x81, 0x30, 0x5D, 0x05, 0x77, 0x03, 0xC0, 0x45, 0x0B, 0xB0,
  0xA3, 0x05, 0xD0, 0x57, 0x70, 0xAB, 0x0B, 0x40, 0x1C, 0x02, 0x40, 0x5D, 0x05, 0x76, 0x02, 0xC0,
  0x13, 0x05, 0xB0, 0xB6, 0x05, 0xD0, 0x57, 0x60, 0xCB, 0x05, 0x30, 0x9B, 0x07, 0x70, 0x5D, 0x05,
  0x75, 0x07, 0xB0, 0x93, 0x0B, 0xB0, 0x37, 0x10, 0x5D, 0x05, 0x74, 0x03, 0xB0, 0xB3, 0x0D, 0xB0,
  0x27, 0x20, 0x5D, 0x05, 0x73, 0x02, 0xB0, 0xD3, 0x0E, 0xB7, 0x40, 0x5D, 0x05, 0x73, 0xB0, 0xE3,
  0x0E, 0xB7, 0x50, 0x5D, 0x05, 0x72, 0xC3, 0x0D, 0xB0, 0x27, 0x50, 0x5D, 0x05, 0x70, 0x1B, 0x0E,
  0x30, 0xBB, 0x03, 0x76, 0x05, 0xD0, 0x56, 0x04, 0xB0, 0xC3, 0x09, 0xB0, 0x77, 0x70, 0x5D, 0x05,
  0x50, 0x7B, 0x09, 0x30, 0x5B, 0x0C, 0x77, 0x10, 0x5D, 0x05, 0x40, 0x10, 0xDA, 0x06, 0x30, 0x1C,
  0x02, 0x77, 0x10, 0x5D, 0x05, 0x48, 0x21, 0xDF, 0x14, 0x0B, 0xB0, 0xA7, 0x72, 0x05, 0xD0, 0x54,
  0x01, 0x09, 0x50, 0x4C, 0x03, 0x77, 0x20, 0x5D, 0x05, 0x74, 0x0B, 0xB0, 0xD0, 0x17, 0x72, 0x05,
  0xD0, 0x57, 0x30, 0x3C, 0x0B, 0x77, 0x30, 0x5D, 0x05, 0x73, 0x08, 0xC0, 0xB0, 0x17, 0x72, 0x06,
  0xD0, 0x57, 0x30, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xE0, 0x57, 0x20, 0x10, 0xCD, 0x0A, 0x02,
  0x73, 0x02, 0x0A, 0xFA, 0x05, 0x72, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x14, 0x7B, 0xE0,
  0xCD, 0x05, 0x73, 0x08, 0xFF, 0xE8, 0x18, 0x05, 0xC0, 0xD7, 0x40, 0x30, 0xBF, 0xFA, 0x0C, 0x03,
  0x30, 0x5B, 0x0D, 0x76, 0x04, 0x0B, 0xFD, 0x0B, 0x04, 0x68, 0x24, 0xDD, 0x47, 0x71, 0x89, 0x21,
  0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_alarm_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 42, 43), Box(0, 0, 47, 47),
      ic_round_48_action_alarm_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_alarm_on 48x48, 4-bit Alpha,  RLE, 389 bytes.
static const unsigned char ic_round_48_action_alarm_on_data[] PROGMEM = {
  0x78, 0x16, 0x71, 0x77, 0x48, 0x11, 0x76, 0x75, 0x01, 0x0C, 0xA0, 0xB7, 0x74, 0x0C, 0xA0, 0xC0,
  0x17, 0x20, 0x30, 0xEC, 0x77, 0x4C, 0x0E, 0x03, 0x70, 0x5D, 0x0A, 0x77, 0x40, 0xAD, 0x05, 0x50,
  0x8D, 0x0A, 0x48, 0x92, 0x15, 0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x40, 0xAD, 0x08, 0x30, 0xAD, 0x07,
  0x30, 0x40, 0xBF, 0xD0, 0xB0, 0x43, 0x08, 0xD8, 0x1A, 0x0A, 0xC0, 0xE0, 0x52, 0x03, 0x0B, 0xFF,
  0xA0, 0xB0, 0x32, 0x05, 0xD0, 0xAC, 0x0D, 0x03, 0x20, 0x8F, 0xFE, 0x08, 0x20, 0x30, 0xEC, 0x0B,
  0xA8, 0x3C, 0x10, 0x1B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE8, 0x3B, 0x10, 0x1C, 0xA8,
  0x2B, 0x17, 0x62, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x28, 0x16, 0x71,
  0x50, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x20, 0x8C, 0x0B, 0x01, 0x77, 0x20, 0x10,
  0xBC, 0x08, 0x70, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x60, 0xBB, 0x0D, 0x01, 0x77, 0x60, 0x10,
  0xDB, 0x0B, 0x50, 0x4C, 0x03, 0x77, 0x71, 0x03, 0xC0, 0x44, 0x0B, 0xB0, 0xA7, 0x74, 0x00, 0x14,
  0x0A, 0xB0, 0xB3, 0x01, 0xC0, 0x27, 0x73, 0x82, 0x6F, 0xE2, 0x30, 0x2C, 0x01, 0x20, 0x5B, 0x0C,
  0x77, 0x30, 0x6B, 0x05, 0x40, 0xCB, 0x05, 0x20, 0x9B, 0x07, 0x77, 0x20, 0x6B, 0x0C, 0x50, 0x7B,
  0x09, 0x20, 0xBB, 0x03, 0x77, 0x10, 0x6B, 0x0C, 0x60, 0x3B, 0x0B, 0x20, 0xDB, 0x02, 0x77, 0x06,
  0xB0, 0xC7, 0x02, 0xB0, 0xD2, 0x0E, 0xB6, 0x07, 0x05, 0x60, 0x5B, 0x0C, 0x72, 0xB0, 0xE2, 0x0E,
  0xB5, 0x08, 0xA0, 0x84, 0x05, 0xB0, 0xC7, 0x3B, 0x0E, 0x20, 0xDB, 0x02, 0x40, 0x7B, 0x08, 0x20,
  0x5B, 0x0C, 0x73, 0x02, 0xB0, 0xD2, 0x0B, 0xB0, 0x35, 0x0A, 0xB0, 0x80, 0x5B, 0x0C, 0x74, 0x03,
  0xB0, 0xB2, 0x09, 0xB0, 0x76, 0x0A, 0xE0, 0xC7, 0x50, 0x7B, 0x09, 0x20, 0x5B, 0x0C, 0x70, 0xAC,
  0x0C, 0x76, 0x0C, 0xB0, 0x52, 0x01, 0xC0, 0x27, 0x0A, 0xA0, 0xC7, 0x60, 0x2C, 0x01, 0x30, 0xBB,
  0x0A, 0x71, 0x07, 0x08, 0x77, 0x0A, 0xB0, 0xB4, 0x04, 0xC0, 0x37, 0x77, 0x10, 0x3C, 0x04, 0x50,
  0xBB, 0x0D, 0x01, 0x77, 0x60, 0x10, 0xDB, 0x0B, 0x60, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x70,
  0x8C, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBC, 0x08, 0x72, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC,
  0x0B, 0x73, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x74, 0x01, 0x0B, 0xE8,
  0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x70, 0x8F, 0xFE, 0x08, 0x77, 0x30, 0x30,
  0xBF, 0xFA, 0x0B, 0x03, 0x77, 0x60, 0x40, 0xBF, 0xD0, 0xB0, 0x47, 0x77, 0x38, 0x92, 0x15, 0x9B,
  0xDE, 0xED, 0xB9, 0x51, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_alarm_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 42, 43), Box(0, 0, 47, 47),
      ic_round_48_action_alarm_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_alarm 48x48, 4-bit Alpha,  RLE, 379 bytes.
static const unsigned char ic_round_48_action_alarm_data[] PROGMEM = {
  0x78, 0x16, 0x71, 0x77, 0x48, 0x11, 0x76, 0x75, 0x01, 0x0C, 0xA0, 0xB7, 0x74, 0x0C, 0xA0, 0xC0,
  0x17, 0x20, 0x30, 0xEC, 0x77, 0x4C, 0x0E, 0x03, 0x70, 0x5D, 0x0A, 0x77, 0x40, 0xAD, 0x05, 0x50,
  0x8D, 0x0A, 0x48, 0x92, 0x15, 0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x40, 0xAD, 0x08, 0x30, 0xAD, 0x07,
  0x30, 0x40, 0xBF, 0xD0, 0xB0, 0x43, 0x08, 0xD8, 0x1A, 0x0A, 0xC0, 0xE0, 0x52, 0x03, 0x0B, 0xFF,
  0xA0, 0xB0, 0x32, 0x05, 0xD0, 0xAC, 0x0D, 0x03, 0x20, 0x8F, 0xFE, 0x08, 0x20, 0x30, 0xEC, 0x0B,
  0xA8, 0x3C, 0x10, 0x1B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE8, 0x3B, 0x10, 0x1C, 0xA8,
  0x2B, 0x17, 0x62, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x28, 0x16, 0x71,
  0x50, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x20, 0x8C, 0x0B, 0x01, 0x77, 0x20, 0x10,
  0xBC, 0x08, 0x70, 0x3C, 0x0B, 0x71, 0x81, 0x8F, 0x87, 0x20, 0xBC, 0x03, 0x60, 0xBB, 0x0D, 0x01,
  0x71, 0xB7, 0x20, 0x10, 0xDB, 0x0B, 0x50, 0x4C, 0x03, 0x72, 0xB7, 0x30, 0x3C, 0x04, 0x40, 0xBB,
  0x0A, 0x73, 0xB7, 0x40, 0xAB, 0x0B, 0x30, 0x1C, 0x02, 0x73, 0xB7, 0x40, 0x2C, 0x01, 0x20, 0x5B,
  0x0C, 0x74, 0xB7, 0x50, 0xCB, 0x05, 0x20, 0x9B, 0x07, 0x74, 0xB7, 0x50, 0x7B, 0x09, 0x20, 0xBB,
  0x03, 0x74, 0xB7, 0x50, 0x3B, 0x0B, 0x20, 0xDB, 0x02, 0x74, 0xB7, 0x50, 0x2B, 0x0D, 0x20, 0xEB,
  0x75, 0xB7, 0x6B, 0x0E, 0x20, 0xEB, 0x75, 0xB0, 0x37, 0x5B, 0x0E, 0x20, 0xDB, 0x02, 0x74, 0x0C,
  0xB0, 0x90, 0x17, 0x20, 0x2B, 0x0D, 0x20, 0xBB, 0x03, 0x74, 0x02, 0x0D, 0xB0, 0xE0, 0x67, 0x10,
  0x3B, 0x0B, 0x20, 0x9B, 0x07, 0x76, 0x07, 0xC0, 0xC0, 0x36, 0x07, 0xB0, 0x92, 0x05, 0xB0, 0xC7,
  0x70, 0x20, 0xBC, 0x09, 0x50, 0xCB, 0x05, 0x20, 0x1C, 0x02, 0x77, 0x10, 0x40, 0xDB, 0x05, 0x30,
  0x2C, 0x01, 0x30, 0xBB, 0x0A, 0x77, 0x30, 0x7A, 0x03, 0x30, 0xAB, 0x0B, 0x40, 0x4C, 0x03, 0x77,
  0x40, 0x13, 0x03, 0xC0, 0x45, 0x0B, 0xB0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xB0, 0xB6, 0x03, 0xC0,
  0xB7, 0x76, 0x0B, 0xC0, 0x37, 0x08, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xC0, 0x87, 0x20, 0xBC,
  0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x30, 0x10, 0xCD, 0x0A, 0x02, 0x73, 0x02, 0x0A, 0xD0,
  0xC0, 0x17, 0x40, 0x10, 0xBE, 0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE, 0x0B, 0x01, 0x77, 0x08,
  0xFF, 0xE0, 0x87, 0x73, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x37, 0x76, 0x04, 0x0B, 0xFD, 0x0B, 0x04,
  0x77, 0x73, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 42, 43), Box(0, 0, 47, 47),
      ic_round_48_action_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_all_inbox 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_round_48_action_all_inbox_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC0, 0xB0, 0x17, 0x77, 0x30, 0x10, 0xBF, 0x90, 0x17, 0x77,
  0x50, 0x1F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77,
  0x7F, 0x97, 0x77, 0x7F, 0xF0, 0xE0, 0x77, 0x50, 0x70, 0xEF, 0xFF, 0x90, 0x37, 0x30, 0x3F, 0xFF,
  0xB0, 0xA7, 0x30, 0xAF, 0xFF, 0xC0, 0x37, 0x10, 0x3F, 0xFF, 0xD0, 0xE0, 0x36, 0x03, 0x0E, 0xFF,
  0xFF, 0x84, 0xA4, 0x11, 0x4A, 0xFF, 0x90, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A,
  0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x80, 0xA9, 0x50, 0x04,
  0x0D, 0xF9, 0x0E, 0x07, 0x75, 0x07, 0x0E, 0xF9, 0x81, 0xD4, 0xDF, 0xC0, 0x27, 0x30, 0x2F, 0xC0,
  0xDF, 0xD0, 0x97, 0x30, 0x9F, 0xFF, 0xC0, 0x37, 0x10, 0x3F, 0xFF, 0xD0, 0xE0, 0x36, 0x03, 0x0E,
  0xFF, 0xFF, 0x84, 0x93, 0x11, 0x39, 0xFF, 0x90, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8,
  0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_all_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_all_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_all_out 48x48, 4-bit Alpha,  RLE, 253 bytes.
static const unsigned char ic_round_48_action_all_out_data[] PROGMEM = {
  0x0B, 0xE0, 0x77, 0x72, 0x07, 0xE0, 0xBE, 0x07, 0x77, 0x40, 0x7F, 0xC0, 0x75, 0x89, 0x03, 0x7B,
  0xDE, 0xED, 0xB7, 0x35, 0x07, 0xFA, 0x07, 0x40, 0x50, 0xDF, 0xB0, 0xD0, 0x54, 0x07, 0xF0, 0x73,
  0x02, 0x0C, 0xFF, 0x0C, 0x02, 0x30, 0x7D, 0x07, 0x30, 0x30, 0xEF, 0xFA, 0x0E, 0x03, 0x30, 0x7B,
  0x07, 0x30, 0x3E, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAE, 0x03, 0x38, 0x17, 0xF7, 0x30, 0x20, 0xEC,
  0x0A, 0x02, 0x71, 0x02, 0x0A, 0xC0, 0xE0, 0x23, 0x07, 0x40, 0xCC, 0x07, 0x75, 0x07, 0xC0, 0xC7,
  0x05, 0xC0, 0x77, 0x70, 0x7C, 0x05, 0x60, 0xDB, 0x0A, 0x77, 0x20, 0xAB, 0x0D, 0x50, 0x3C, 0x02,
  0x77, 0x20, 0x2C, 0x03, 0x40, 0x7B, 0x0A, 0x77, 0x40, 0xAB, 0x07, 0x40, 0xBB, 0x05, 0x77, 0x40,
  0x5B, 0x0B, 0x40, 0xDB, 0x02, 0x77, 0x40, 0x2B, 0x0D, 0x40, 0xEB, 0x77, 0x6B, 0x0E, 0x40, 0xEB,
  0x77, 0x6B, 0x0E, 0x40, 0xDB, 0x02, 0x77, 0x40, 0x2B, 0x0D, 0x40, 0xBB, 0x05, 0x77, 0x40, 0x5B,
  0x0B, 0x40, 0x7B, 0x0A, 0x77, 0x40, 0xAB, 0x07, 0x40, 0x3C, 0x02, 0x77, 0x20, 0x2C, 0x03, 0x50,
  0xDB, 0x0A, 0x77, 0x20, 0xAB, 0x0D, 0x60, 0x5C, 0x07, 0x77, 0x07, 0xC0, 0x57, 0x0C, 0xC0, 0x77,
  0x50, 0x7C, 0x0C, 0x40, 0x73, 0x02, 0x0E, 0xC0, 0xA0, 0x27, 0x10, 0x20, 0xAC, 0x0E, 0x02, 0x38,
  0x17, 0xF7, 0x30, 0x3E, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAE, 0x03, 0x30, 0x7B, 0x07, 0x30, 0x30,
  0xEF, 0xFA, 0x0E, 0x03, 0x30, 0x7D, 0x07, 0x30, 0x20, 0xCF, 0xF0, 0xC0, 0x23, 0x07, 0xF0, 0x74,
  0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x40, 0x7F, 0xA0, 0x75, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x35,
  0x07, 0xFC, 0x07, 0x77, 0x40, 0x7E, 0x0B, 0xE0, 0x77, 0x72, 0x07, 0xE0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_all_out() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_all_out_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_analytics 48x48, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_round_48_action_analytics_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAC, 0x4F, 0x82, 0xB1, 0x1B, 0xFF, 0xFF, 0xC0, 0x12,
  0x01, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFB, 0x82,
  0xB1, 0x1B, 0xC4, 0xFF, 0xFB, 0x01, 0x20, 0x1C, 0x4F, 0xFF, 0xB0, 0x12, 0x01, 0xC4, 0xFF, 0xFB,
  0x82, 0xB1, 0x1B, 0xC4, 0xFF, 0xA8, 0x2B, 0x11, 0xBF, 0xD4, 0xFF, 0xA0, 0x12, 0x01, 0xFD, 0x4F,
  0xFA, 0x4F, 0xD4, 0xFF, 0xA4, 0xFD, 0x4F, 0xFA, 0x4C, 0x82, 0xB1, 0x1B, 0xC4, 0xFF, 0xA4, 0xC0,
  0x12, 0x01, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA0, 0x12, 0x01, 0xC0,
  0x12, 0x01, 0xC0, 0x12, 0x01, 0xFF, 0xA8, 0x2B, 0x11, 0xBC, 0x82, 0xB1, 0x1B, 0xC8, 0x2B, 0x11,
  0xB8, 0x0A, 0xA4, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF,
  0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_analytics() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_analytics_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_anchor 48x48, 4-bit Alpha,  RLE, 265 bytes.
static const unsigned char ic_round_48_action_anchor_data[] PROGMEM = {
  0x77, 0x18, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x06, 0xFB, 0x06, 0x77, 0x73, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x77, 0x73,
  0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x77, 0x30, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x77, 0x73, 0x0B,
  0xB8, 0x2B, 0x11, 0xBB, 0x0B, 0x77, 0x73, 0x05, 0xFB, 0x05, 0x77, 0x74, 0x0C, 0xF9, 0x0C, 0x77,
  0x75, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x70, 0x5C, 0x05, 0x77, 0x77, 0x3C, 0x77, 0x77, 0x4C,
  0x77, 0x75, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x77, 0x60, 0xDF, 0xF0, 0xD7, 0x76, 0x0D, 0xFF, 0x0D,
  0x77, 0x60, 0x40, 0xDF, 0xD0, 0xD0, 0x47, 0x77, 0x5C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77,
  0x28, 0x1B, 0xC2, 0x76, 0xC7, 0x68, 0x12, 0xCB, 0xA0, 0xE0, 0x57, 0x5C, 0x75, 0x05, 0x0E, 0xE0,
  0x97, 0x4C, 0x74, 0x09, 0xFA, 0x0C, 0x02, 0x72, 0xC7, 0x20, 0x20, 0xDF, 0xC0, 0xE0, 0x37, 0x1C,
  0x71, 0x03, 0x0E, 0xE0, 0xEE, 0x05, 0x71, 0xC7, 0x10, 0x5E, 0x0E, 0x0B, 0xD0, 0x77, 0x2C, 0x72,
  0x07, 0xD0, 0xD0, 0x9C, 0x07, 0x73, 0xC7, 0x30, 0x7C, 0x09, 0x03, 0xC0, 0x37, 0x3C, 0x73, 0x03,
  0xC8, 0x13, 0x0C, 0xB0, 0xD0, 0x17, 0x2C, 0x72, 0x01, 0x0D, 0xB0, 0xC2, 0x04, 0xC0, 0xC0, 0x17,
  0x1C, 0x71, 0x01, 0x0C, 0xC0, 0x43, 0x07, 0xC0, 0xD0, 0x37, 0xC7, 0x03, 0x0D, 0xC0, 0x75, 0x0B,
  0xD0, 0x80, 0x15, 0xC5, 0x01, 0x08, 0xD0, 0xB7, 0x0A, 0xD8, 0x1E, 0x81, 0x3C, 0x38, 0x11, 0x8E,
  0xD0, 0xA7, 0x20, 0x8F, 0x81, 0xC8, 0x4C, 0x81, 0x48, 0xCF, 0x08, 0x74, 0x03, 0x0D, 0xFF, 0xE0,
  0xD0, 0x37, 0x70, 0x70, 0xEF, 0xFA, 0x0E, 0x07, 0x77, 0x40, 0x50, 0xCF, 0xD0, 0xC0, 0x57, 0x77,
  0x18, 0x92, 0x15, 0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_anchor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_anchor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_android 48x48, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_round_48_action_android_data[] PROGMEM = {
  0x70, 0x10, 0x27, 0x77, 0x50, 0x17, 0x71, 0x81, 0xDF, 0x57, 0x77, 0x38, 0x15, 0xFC, 0x77, 0x81,
  0xDF, 0xE7, 0x77, 0x38, 0x1E, 0xFD, 0x77, 0x05, 0xA0, 0x87, 0x77, 0x10, 0x8A, 0x05, 0x77, 0x10,
  0xCA, 0x02, 0x77, 0x60, 0x2A, 0x0C, 0x77, 0x20, 0x3A, 0x0B, 0x77, 0x60, 0xBA, 0x03, 0x77, 0x30,
  0x9A, 0x04, 0x38, 0x34, 0x8A, 0xDD, 0xA8, 0x3D, 0xDA, 0x84, 0x30, 0x4A, 0x09, 0x77, 0x48, 0x41,
  0xEF, 0xD5, 0xAF, 0xF8, 0x4A, 0x5D, 0xFE, 0x17, 0x75, 0x07, 0xFF, 0xF9, 0x07, 0x77, 0x50, 0x30,
  0xCF, 0xFF, 0x90, 0xC0, 0x37, 0x73, 0x07, 0xFF, 0xFD, 0x07, 0x77, 0x10, 0xAF, 0xFF, 0xF0, 0xA7,
  0x60, 0xBF, 0xFF, 0xFA, 0x0B, 0x74, 0x0A, 0xFF, 0xFF, 0xC0, 0xA7, 0x20, 0x8F, 0xFF, 0xFE, 0x08,
  0x70, 0x4E, 0x82, 0xE9, 0x9E, 0xFF, 0xA8, 0x2E, 0x99, 0xEE, 0x04, 0x60, 0xDD, 0x0E, 0x02, 0x20,
  0x20, 0xEF, 0xF0, 0xE0, 0x22, 0x02, 0x0E, 0xD0, 0xD5, 0x07, 0xE0, 0x94, 0x09, 0xFF, 0x09, 0x40,
  0x9E, 0x07, 0x40, 0xEE, 0x09, 0x40, 0x9F, 0xF0, 0x94, 0x09, 0xE0, 0xE3, 0x06, 0xF0, 0xE0, 0x22,
  0x02, 0x0E, 0xFF, 0x0E, 0x02, 0x20, 0x20, 0xEF, 0x06, 0x20, 0xCF, 0x98, 0x2E, 0x99, 0xEF, 0xFA,
  0x82, 0xE9, 0x9E, 0xF9, 0x81, 0xC0, 0x18, 0x0C, 0x6F, 0x01, 0x06, 0x80, 0xC6, 0xF0, 0x60, 0x98,
  0x0C, 0x6F, 0x09, 0x0C, 0x80, 0xC6, 0xF0, 0xC0, 0xE8, 0x0C, 0x6F, 0x0E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 35), Box(0, 0, 47, 47),
      ic_round_48_action_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_announcement 48x48, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_round_48_action_announcement_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xB6, 0xF8, 0x2B, 0x11, 0xB8, 0x0C, 0x0F, 0x01,
  0x20, 0x18, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F,
  0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x01, 0x20, 0x18, 0x0C,
  0x0F, 0x82, 0xB1, 0x1B, 0x80, 0xB8, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F,
  0x48, 0x0A, 0x85, 0xF0, 0xD8, 0x0C, 0x3F, 0x0A, 0x80, 0xC2, 0xF0, 0xE0, 0x18, 0x0C, 0x0F, 0x81,
  0xDA, 0x11, 0xF0, 0x77, 0x77, 0x74, 0xE0, 0x77, 0x77, 0x75, 0xD0, 0x77, 0x77, 0x76, 0xC0, 0x77,
  0x77, 0x77, 0xB0, 0x78, 0x0C, 0x00, 0xA0, 0x78, 0x0C, 0x10, 0x90, 0x78, 0x0C, 0x20, 0x07, 0x80,
  0xC3, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_announcement() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_announcement_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_api 48x48, 4-bit Alpha,  RLE, 328 bytes.
static const unsigned char ic_round_48_action_api_data[] PROGMEM = {
  0x77, 0x60, 0x03, 0x80, 0xC2, 0x00, 0x50, 0xEA, 0x0E, 0x05, 0x77, 0x77, 0x70, 0x7E, 0x07, 0x77,
  0x77, 0x50, 0x7F, 0x90, 0x77, 0x77, 0x73, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x10, 0x7F, 0xD0, 0x77,
  0x77, 0x60, 0x7F, 0xF0, 0x77, 0x77, 0x40, 0x7F, 0xFA, 0x07, 0x77, 0x73, 0x0D, 0xFF, 0xA0, 0xD7,
  0x77, 0x30, 0x10, 0xDE, 0x00, 0x7E, 0x0D, 0x01, 0x77, 0x74, 0x01, 0x0D, 0xC0, 0x72, 0x07, 0xC0,
  0xD0, 0x17, 0x77, 0x60, 0x10, 0xDA, 0x07, 0x40, 0x7A, 0x0D, 0x01, 0x77, 0x78, 0x17, 0xD1, 0x58,
  0x11, 0xD7, 0x68, 0x17, 0xD1, 0x58, 0x11, 0xD7, 0x76, 0x07, 0xA0, 0xD0, 0x17, 0x76, 0x01, 0x0D,
  0xA0, 0x77, 0x40, 0x7C, 0x0D, 0x01, 0x77, 0x40, 0x10, 0xDC, 0x07, 0x72, 0x07, 0xE0, 0xD0, 0x17,
  0x72, 0x01, 0x0D, 0xE0, 0x77, 0x07, 0xF9, 0x0D, 0x77, 0x20, 0xDF, 0x90, 0x75, 0x07, 0xFA, 0x07,
  0x77, 0x20, 0x7F, 0xA0, 0x73, 0x05, 0xFA, 0x07, 0x78, 0x25, 0xBB, 0x47, 0x07, 0xFA, 0x05, 0x20,
  0xEF, 0x90, 0x77, 0x04, 0xC0, 0x57, 0x07, 0xF9, 0x81, 0xE0, 0x3F, 0x90, 0x77, 0x10, 0xBC, 0x0B,
  0x71, 0x07, 0xF9, 0x00, 0x3F, 0x90, 0x77, 0x10, 0xBC, 0x0B, 0x71, 0x07, 0xF9, 0x81, 0x30, 0xEF,
  0x90, 0x77, 0x05, 0xC0, 0x57, 0x07, 0xF9, 0x0E, 0x20, 0x5F, 0xA0, 0x77, 0x82, 0x5B, 0xB5, 0x70,
  0x7F, 0xA0, 0x53, 0x07, 0xFA, 0x07, 0x77, 0x20, 0x7F, 0xA0, 0x75, 0x07, 0xF9, 0x0D, 0x77, 0x20,
  0xDF, 0x90, 0x77, 0x07, 0xE0, 0xD0, 0x17, 0x72, 0x01, 0x0D, 0xE0, 0x77, 0x20, 0x7C, 0x0D, 0x01,
  0x77, 0x40, 0x10, 0xDC, 0x07, 0x74, 0x07, 0xA0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xA0, 0x77, 0x68,
  0x17, 0xD1, 0x58, 0x11, 0xD7, 0x68, 0x17, 0xD1, 0x58, 0x11, 0xD7, 0x77, 0x70, 0x10, 0xDA, 0x07,
  0x40, 0x7A, 0x0D, 0x01, 0x77, 0x76, 0x01, 0x0D, 0xC0, 0x72, 0x07, 0xC0, 0xD0, 0x17, 0x77, 0x40,
  0x10, 0xDE, 0x00, 0x7E, 0x0D, 0x01, 0x77, 0x73, 0x0D, 0xFF, 0xA0, 0xD7, 0x77, 0x30, 0x7F, 0xFA,
  0x07, 0x77, 0x74, 0x07, 0xFF, 0x07, 0x77, 0x76, 0x07, 0xFD, 0x07, 0x77, 0x77, 0x10, 0x7F, 0xB0,
  0x77, 0x77, 0x73, 0x07, 0xF9, 0x07, 0x77, 0x77, 0x50, 0x7E, 0x07, 0x77, 0x77, 0x70, 0x50, 0xEA,
  0x0E, 0x05, 0x80, 0xC2, 0x00, 0x03, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_api() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 44, 44), Box(0, 0, 47, 47),
      ic_round_48_action_api_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_app_blocking 48x48, 4-bit Alpha,  RLE, 224 bytes.
static const unsigned char ic_round_48_action_app_blocking_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x70, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x16, 0x0A, 0xFF,
  0xFD, 0x0A, 0x60, 0xDF, 0xFF, 0xD0, 0xD6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF, 0x6F, 0xFF,
  0xF6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC6, 0xC7, 0x77, 0x72, 0xC7,
  0x77, 0x72, 0xC7, 0x74, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x4C, 0x77, 0x30, 0x9F, 0x90, 0x93, 0xC7,
  0x72, 0x0B, 0xFB, 0x0B, 0x2C, 0x77, 0x10, 0x9B, 0x84, 0xA3, 0x01, 0x4E, 0xB0, 0x91, 0xC7, 0x70,
  0x2B, 0x07, 0x40, 0x9D, 0x02, 0xC7, 0x70, 0x8A, 0x0A, 0x40, 0x9B, 0x0E, 0xA0, 0x8C, 0x77, 0x0C,
  0xA0, 0x33, 0x09, 0xB0, 0x90, 0x4A, 0x0C, 0xC7, 0x70, 0xEA, 0x30, 0x9B, 0x81, 0x90, 0x1A, 0x0E,
  0xC7, 0x70, 0xEA, 0x81, 0x10, 0x9B, 0x09, 0x3A, 0x0E, 0xC7, 0x70, 0xCA, 0x04, 0x09, 0xB0, 0x93,
  0x03, 0xA0, 0xCC, 0x77, 0x08, 0xA0, 0xEB, 0x09, 0x40, 0xAA, 0x08, 0xC7, 0x70, 0x2D, 0x09, 0x40,
  0x7B, 0x02, 0xC7, 0x71, 0x09, 0xB8, 0x4E, 0x41, 0x03, 0xAB, 0x09, 0x1C, 0x77, 0x20, 0xBF, 0xB0,
  0xB2, 0xC7, 0x73, 0x09, 0xF9, 0x09, 0x3C, 0x77, 0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x24, 0xC7, 0x77,
  0x72, 0xC7, 0x77, 0x72, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xFF,
  0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0x0D, 0xFF, 0xFD, 0x0D, 0x60, 0xAF, 0xFF,
  0xD0, 0xA6, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x78, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_app_blocking() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 43, 45), Box(0, 0, 47, 47),
      ic_round_48_action_app_blocking_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_app_shortcut 48x48, 4-bit Alpha,  RLE, 242 bytes.
static const unsigned char ic_round_48_action_app_shortcut_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x71, 0x0A,
  0xFF, 0xFD, 0x0A, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF,
  0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77,
  0x6C, 0x71, 0xC7, 0x77, 0x60, 0x01, 0x3C, 0x77, 0x76, 0x0A, 0x0B, 0x3C, 0x77, 0x75, 0x03, 0xA0,
  0x32, 0xC7, 0x73, 0x00, 0x55, 0x01, 0x0A, 0xC0, 0xB0, 0x1C, 0x77, 0x20, 0x2A, 0x02, 0x40, 0x10,
  0xAC, 0x0A, 0x01, 0xC7, 0x72, 0x09, 0xA0, 0x96, 0x02, 0xA0, 0x32, 0xC7, 0x71, 0x01, 0x0E, 0xA0,
  0xE0, 0x16, 0x00, 0xA3, 0xC7, 0x70, 0x10, 0x9C, 0x09, 0x01, 0x50, 0x01, 0x3C, 0x75, 0x02, 0x09,
  0xF8, 0x1E, 0x82, 0x71, 0xC7, 0x40, 0x5F, 0xD0, 0x57, 0xC7, 0x40, 0x5F, 0xD0, 0x57, 0xC7, 0x58,
  0x12, 0x8E, 0xE8, 0x1E, 0x92, 0x71, 0xC7, 0x70, 0x10, 0x9C, 0x09, 0x01, 0x50, 0x01, 0x3C, 0x77,
  0x10, 0x10, 0xEA, 0x0E, 0x01, 0x60, 0x0A, 0x3C, 0x77, 0x20, 0x9A, 0x08, 0x60, 0x3A, 0x03, 0x2C,
  0x77, 0x20, 0x2A, 0x02, 0x40, 0x10, 0xAC, 0x0A, 0x01, 0xC7, 0x73, 0x00, 0x55, 0x01, 0x0A, 0xC0,
  0xA0, 0x1C, 0x77, 0x75, 0x03, 0xA0, 0x32, 0xC7, 0x77, 0x60, 0x0A, 0x3C, 0x77, 0x76, 0x00, 0x13,
  0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71,
  0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x71, 0x0A, 0xFF,
  0xFD, 0x0A, 0x71, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA,
  0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_app_shortcut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_app_shortcut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_arrow_circle_down 48x48, 4-bit Alpha,  RLE, 339 bytes.
static const unsigned char ic_round_48_action_arrow_circle_down_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x93,
  0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x75, 0x82, 0x4D, 0xD4, 0x75, 0x0E,
  0xB0, 0x82, 0x0D, 0xB0, 0x67, 0x50, 0xDA, 0x0D, 0x75, 0x06, 0xB8, 0x1D, 0x03, 0xC7, 0x6C, 0x76,
  0xC0, 0x30, 0x7B, 0x0B, 0x76, 0xC7, 0x60, 0xBB, 0x07, 0x0A, 0xB0, 0x67, 0x6C, 0x76, 0x06, 0xB0,
  0xA0, 0xCB, 0x03, 0x76, 0xC7, 0x60, 0x3B, 0x0C, 0x0E, 0xB0, 0x27, 0x6C, 0x76, 0x02, 0xB0, 0xEC,
  0x77, 0xC7, 0x7F, 0x97, 0x20, 0x5F, 0xD0, 0x57, 0x2C, 0x0E, 0xB0, 0x27, 0x10, 0x5F, 0xD0, 0x57,
  0x10, 0x2B, 0x0E, 0x0C, 0xB0, 0x37, 0x20, 0x7F, 0xB0, 0x77, 0x20, 0x3B, 0x0C, 0x0A, 0xB0, 0x67,
  0x30, 0x7F, 0x90, 0x77, 0x30, 0x6B, 0x0A, 0x07, 0xB0, 0xB7, 0x40, 0x7E, 0x07, 0x74, 0x0B, 0xB0,
  0x70, 0x3C, 0x75, 0x07, 0xC0, 0x77, 0x5C, 0x81, 0x30, 0xDB, 0x06, 0x75, 0x07, 0xA0, 0x77, 0x50,
  0x6B, 0x0D, 0x20, 0x8B, 0x0E, 0x76, 0x00, 0x57, 0x60, 0xEB, 0x08, 0x20, 0x1C, 0x07, 0x77, 0x75,
  0x07, 0xC0, 0x13, 0x09, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x09, 0x40, 0x10, 0xEB, 0x0E, 0x01, 0x77,
  0x71, 0x01, 0x0E, 0xB0, 0xE0, 0x15, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x57, 0x09,
  0xC0, 0xE0, 0x37, 0x74, 0x03, 0x0E, 0xC0, 0x97, 0x20, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x74,
  0x0A, 0xD0, 0xE0, 0x67, 0x50, 0x60, 0xED, 0x0A, 0x76, 0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23,
  0x6B, 0xF0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90,
  0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC,
  0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_arrow_circle_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_arrow_circle_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_arrow_circle_left 48x48, 4-bit Alpha,  RLE, 249 bytes.
static const unsigned char ic_round_48_action_arrow_circle_left_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0x80, 0xC0, 0xF0, 0x82, 0x0D,
  0xFF, 0xA0, 0x90, 0xAF, 0xFC, 0x81, 0xD0, 0x3F, 0xFA, 0x07, 0x2F, 0xFD, 0x03, 0x07, 0xFF, 0x90,
  0x73, 0xFF, 0xD0, 0x70, 0xAF, 0xF0, 0x74, 0xFF, 0xD0, 0xA0, 0xCF, 0xE0, 0x75, 0xFF, 0xD0, 0xC0,
  0xEF, 0xD0, 0x77, 0x50, 0x10, 0xBF, 0xC0, 0xEF, 0xD0, 0xA7, 0x70, 0x1F, 0xFF, 0xB0, 0xA7, 0x70,
  0x1F, 0xD0, 0xEF, 0xD0, 0x87, 0x50, 0x10, 0xBF, 0xC0, 0xE0, 0xCF, 0xE0, 0x85, 0xFF, 0xD0, 0xC0,
  0xAF, 0xF0, 0x84, 0xFF, 0xD0, 0xA0, 0x7F, 0xF9, 0x08, 0x3F, 0xFD, 0x07, 0x03, 0xFF, 0xA0, 0x82,
  0xFF, 0xD8, 0x13, 0x0D, 0xFF, 0xA0, 0x0A, 0xFF, 0xC0, 0xD2, 0x08, 0x80, 0xC0, 0xF0, 0x82, 0x01,
  0x80, 0xC0, 0xF0, 0x13, 0x09, 0xFF, 0xFF, 0xE0, 0x94, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x15,
  0x05, 0xFF, 0xFF, 0xC0, 0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40,
  0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57,
  0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74,
  0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_arrow_circle_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_arrow_circle_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_arrow_circle_right 48x48, 4-bit Alpha,  RLE, 249 bytes.
static const unsigned char ic_round_48_action_arrow_circle_right_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0x80, 0xC0, 0xF0, 0x82, 0x0D,
  0xFF, 0xC0, 0x0A, 0xFF, 0xA8, 0x1D, 0x03, 0xFF, 0xD2, 0x08, 0xFF, 0xA0, 0x30, 0x7F, 0xFD, 0x30,
  0x8F, 0xF9, 0x07, 0x0A, 0xFF, 0xD4, 0x08, 0xFF, 0x0A, 0x0C, 0xFF, 0xD5, 0x08, 0xFE, 0x0C, 0x0E,
  0xFC, 0x0B, 0x01, 0x75, 0x08, 0xFD, 0x0E, 0xFD, 0x01, 0x77, 0x0A, 0xFF, 0xFB, 0x01, 0x77, 0x0A,
  0xFD, 0x0E, 0xFC, 0x0B, 0x01, 0x75, 0x07, 0xFD, 0x0E, 0x0C, 0xFF, 0xD5, 0x07, 0xFE, 0x0C, 0x0A,
  0xFF, 0xD4, 0x07, 0xFF, 0x0A, 0x07, 0xFF, 0xD3, 0x07, 0xFF, 0x90, 0x70, 0x3F, 0xFD, 0x20, 0x7F,
  0xFA, 0x81, 0x30, 0xDF, 0xFC, 0x0A, 0x09, 0xFF, 0xA0, 0xD2, 0x08, 0x80, 0xC0, 0xF0, 0x82, 0x01,
  0x80, 0xC0, 0xF0, 0x13, 0x09, 0xFF, 0xFF, 0xE0, 0x94, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x15,
  0x05, 0xFF, 0xFF, 0xC0, 0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40,
  0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57,
  0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74,
  0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_arrow_circle_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_arrow_circle_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_arrow_circle_up 48x48, 4-bit Alpha,  RLE, 339 bytes.
static const unsigned char ic_round_48_action_arrow_circle_up_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x93,
  0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x76, 0x00, 0x57, 0x60, 0xEB, 0x08,
  0x20, 0xDB, 0x06, 0x75, 0x07, 0xA0, 0x77, 0x50, 0x6B, 0x81, 0xD0, 0x3C, 0x75, 0x07, 0xC0, 0x77,
  0x5C, 0x03, 0x07, 0xB0, 0xB7, 0x40, 0x7E, 0x07, 0x74, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x73, 0x07,
  0xF9, 0x07, 0x73, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x72, 0x07, 0xFB, 0x07, 0x72, 0x03, 0xB0, 0xC0,
  0xEB, 0x02, 0x71, 0x05, 0xFD, 0x05, 0x71, 0x02, 0xB0, 0xEC, 0x72, 0x05, 0xFD, 0x05, 0x72, 0xF9,
  0x77, 0xC7, 0x7C, 0x0E, 0xB0, 0x27, 0x6C, 0x76, 0x02, 0xB0, 0xE0, 0xCB, 0x03, 0x76, 0xC7, 0x60,
  0x3B, 0x0C, 0x0A, 0xB0, 0x67, 0x6C, 0x76, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x76, 0xC7, 0x60, 0xBB,
  0x07, 0x03, 0xC7, 0x6C, 0x76, 0xC8, 0x13, 0x0D, 0xB0, 0x67, 0x50, 0xDA, 0x0D, 0x75, 0x06, 0xB0,
  0xD2, 0x08, 0xB0, 0xE7, 0x58, 0x24, 0xDD, 0x47, 0x50, 0xEB, 0x08, 0x20, 0x1C, 0x07, 0x77, 0x75,
  0x07, 0xC0, 0x13, 0x09, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x09, 0x40, 0x10, 0xEB, 0x0E, 0x01, 0x77,
  0x71, 0x01, 0x0E, 0xB0, 0xE0, 0x15, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x57, 0x09,
  0xC0, 0xE0, 0x37, 0x74, 0x03, 0x0E, 0xC0, 0x97, 0x20, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x74,
  0x0A, 0xD0, 0xE0, 0x67, 0x50, 0x60, 0xED, 0x0A, 0x76, 0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23,
  0x6B, 0xF0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90,
  0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC,
  0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_arrow_circle_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_arrow_circle_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_arrow_outward 48x48, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_round_48_action_arrow_outward_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFE, 0x0D, 0x04, 0x20, 0xDF, 0xFF, 0x90, 0xD2, 0x0D, 0xFF, 0xFA, 0x20, 0x40,
  0xDF, 0xFF, 0x97, 0x74, 0x05, 0xF7, 0x73, 0x05, 0xF9, 0x77, 0x20, 0x5F, 0xA7, 0x71, 0x05, 0xD0,
  0x5C, 0x77, 0x05, 0xD0, 0x51, 0xC7, 0x60, 0x5D, 0x05, 0x2C, 0x75, 0x05, 0xD0, 0x53, 0xC7, 0x40,
  0x5D, 0x05, 0x4C, 0x73, 0x05, 0xD0, 0x55, 0xC7, 0x20, 0x5D, 0x05, 0x6C, 0x71, 0x05, 0xD0, 0x57,
  0xC7, 0x05, 0xD0, 0x57, 0x1C, 0x60, 0x5D, 0x05, 0x72, 0xC5, 0x05, 0xD0, 0x57, 0x3C, 0x40, 0x5D,
  0x05, 0x74, 0xC3, 0x05, 0xD0, 0x57, 0x5C, 0x20, 0x5D, 0x05, 0x76, 0xC1, 0x05, 0xD0, 0x57, 0x7C,
  0x10, 0xEC, 0x05, 0x77, 0x10, 0xDA, 0x0D, 0x01, 0xC0, 0x57, 0x72, 0x87, 0x4D, 0xD4, 0x08, 0xFE,
  0x57, 0x77, 0x20, 0x17, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_arrow_outward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 12, 35, 37), Box(0, 0, 47, 47),
      ic_round_48_action_arrow_outward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_arrow_right_alt 48x48, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_48_action_arrow_right_alt_data[] PROGMEM = {
  0x77, 0x73, 0x05, 0x06, 0x77, 0x77, 0x28, 0x1E, 0xF8, 0x77, 0x77, 0x1B, 0x07, 0x77, 0x77, 0xC0,
  0x77, 0x77, 0x6D, 0x07, 0x20, 0x40, 0xDF, 0xFF, 0xF8, 0x17, 0x0D, 0xFF, 0xFF, 0xA0, 0x50, 0xDF,
  0xFF, 0xFA, 0x81, 0x54, 0xDF, 0xFF, 0xF0, 0x77, 0x77, 0x4D, 0x07, 0x77, 0x75, 0xC0, 0x77, 0x77,
  0x6B, 0x07, 0x77, 0x77, 0x81, 0xEF, 0x77, 0x77, 0x71, 0x00, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_arrow_right_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 17, 39, 30), Box(0, 0, 47, 47),
      ic_round_48_action_arrow_right_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_article 48x48, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_round_48_action_article_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAA, 0x4F, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBF, 0xFA,
  0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xB8,
  0x0A, 0xB4, 0xF0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xFF, 0xA0, 0x17, 0x74, 0x01, 0xFF, 0xA0, 0x17,
  0x74, 0x01, 0xFF, 0xA0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0x80, 0xAB, 0x4F, 0x0B, 0x01, 0x73, 0x01,
  0x0B, 0xFF, 0xF9, 0x01, 0x75, 0x01, 0xFF, 0xF9, 0x01, 0x75, 0x01, 0xFF, 0xF9, 0x0B, 0x01, 0x73,
  0x01, 0x0B, 0x80, 0xAB, 0x2F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF,
  0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_article() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_article_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_aspect_ratio 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_48_action_aspect_ratio_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x0A, 0x01, 0x77, 0x77, 0x40, 0x10, 0xAF, 0x90, 0x17,
  0x77, 0x76, 0x01, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x40, 0x40, 0xDE, 0x0D, 0x04,
  0x77, 0x71, 0xF9, 0x40, 0xDF, 0x90, 0xD7, 0x77, 0x1F, 0x94, 0xFA, 0x0D, 0x77, 0x71, 0xF9, 0x4F,
  0x90, 0xD0, 0x47, 0x77, 0x1F, 0x94, 0xC7, 0x77, 0x7F, 0x94, 0xC7, 0x77, 0x7F, 0x94, 0xC7, 0x77,
  0x7F, 0x94, 0xC7, 0x77, 0x7F, 0x94, 0x0D, 0xA0, 0xD7, 0x77, 0x7F, 0x94, 0x82, 0x4D, 0xD4, 0x77,
  0x77, 0xF9, 0x77, 0x77, 0x82, 0x4D, 0xD4, 0x4F, 0x97, 0x77, 0x70, 0xDA, 0x0D, 0x4F, 0x97, 0x77,
  0x7C, 0x4F, 0x97, 0x77, 0x7C, 0x4F, 0x97, 0x77, 0x7C, 0x4F, 0x97, 0x77, 0x7C, 0x4F, 0x97, 0x77,
  0x10, 0x40, 0xDF, 0x94, 0xF9, 0x77, 0x71, 0x0D, 0xFA, 0x4F, 0x97, 0x77, 0x10, 0xDF, 0x90, 0xD4,
  0xF9, 0x77, 0x71, 0x04, 0x0D, 0xE0, 0xD0, 0x44, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9,
  0x01, 0x77, 0x77, 0x60, 0x1F, 0x90, 0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xC0, 0xD8, 0x0C, 0x6F,
  0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_aspect_ratio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_aspect_ratio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_assessment 48x48, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_round_48_action_assessment_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAB, 0x4F, 0x82, 0xB1, 0x1B, 0xFF, 0xFF, 0xC0, 0x12,
  0x01, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFB, 0x82,
  0xB1, 0x1B, 0xC4, 0xFF, 0xFB, 0x01, 0x20, 0x1C, 0x4F, 0xFF, 0xB4, 0xC4, 0xFF, 0xFB, 0x4C, 0x4F,
  0xFF, 0xB4, 0xC4, 0xFF, 0xFB, 0x4C, 0x4F, 0xFF, 0xB4, 0xC4, 0xC8, 0x2B, 0x11, 0xBF, 0xFA, 0x4C,
  0x4C, 0x01, 0x20, 0x1F, 0xFA, 0x4C, 0x4C, 0x4F, 0xFA, 0x4C, 0x4C, 0x4F, 0xFA, 0x4C, 0x4C, 0x4F,
  0xFA, 0x4C, 0x4C, 0x4F, 0xFA, 0x01, 0x20, 0x1C, 0x01, 0x20, 0x1C, 0x01, 0x20, 0x1F, 0xFA, 0x82,
  0xB1, 0x1B, 0xC8, 0x2B, 0x11, 0xBC, 0x82, 0xB1, 0x1B, 0x80, 0xAA, 0x4F, 0x0D, 0xFF, 0xFF, 0xE0,
  0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81,
  0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_assessment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_assessment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_assignment_ind 48x48, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_round_48_action_assignment_ind_data[] PROGMEM = {
  0x77, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x05, 0xFB, 0x05, 0x76, 0x81, 0x1A, 0xDF, 0xD8, 0x2B, 0x11, 0xBF, 0xD8, 0x4D,
  0xA1, 0x01, 0xEF, 0xF0, 0x12, 0x01, 0xFF, 0x81, 0xE1, 0xAF, 0xF9, 0x01, 0x20, 0x1F, 0xF9, 0x0A,
  0x0D, 0xFF, 0x98, 0x2B, 0x11, 0xBF, 0xF9, 0x0D, 0x80, 0xAB, 0x3F, 0x08, 0x03, 0x20, 0x30, 0x8F,
  0xFF, 0xF0, 0xD0, 0x26, 0x02, 0x0D, 0xFF, 0xFD, 0x02, 0x71, 0x02, 0xFF, 0xFC, 0x08, 0x73, 0x08,
  0xFF, 0xFB, 0x03, 0x73, 0x03, 0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x03, 0x73, 0x03,
  0xFF, 0xFB, 0x08, 0x73, 0x08, 0xFF, 0xFC, 0x02, 0x71, 0x02, 0xFF, 0xFD, 0x0D, 0x02, 0x60, 0x20,
  0xDF, 0xFF, 0xF0, 0x80, 0x32, 0x03, 0x08, 0x80, 0xA8, 0x3F, 0x83, 0xD9, 0x63, 0x12, 0x83, 0x13,
  0x69, 0xDF, 0xFF, 0x90, 0x90, 0x37, 0x50, 0x30, 0x9F, 0xFC, 0x0A, 0x01, 0x77, 0x20, 0x10, 0xAF,
  0xF9, 0x06, 0x77, 0x60, 0x6F, 0xE0, 0x97, 0x77, 0x10, 0x9F, 0xD0, 0x27, 0x77, 0x10, 0x2F, 0xD7,
  0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3E, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE,
  0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_assignment_ind() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_assignment_ind_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_assignment_late 48x48, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_round_48_action_assignment_late_data[] PROGMEM = {
  0x77, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x05, 0xC0, 0x09, 0xC0, 0x57, 0x68, 0x11, 0xAD, 0xFD, 0x09, 0x20, 0x9F, 0xD8,
  0x4D, 0xA1, 0x01, 0xEF, 0xF0, 0x92, 0x09, 0xFF, 0x81, 0xE1, 0xAF, 0xFA, 0x00, 0x9F, 0xFA, 0x0A,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD8, 0x0A, 0xB4, 0xF8, 0x2B, 0x11, 0xBF, 0xFF, 0xFC, 0x01, 0x20, 0x1F,
  0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF,
  0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x01, 0x20, 0x1F, 0xFF, 0xFC, 0x82,
  0xB1, 0x1B, 0x80, 0xAD, 0x4F, 0x82, 0xB1, 0x1B, 0xFF, 0xFF, 0xC0, 0x12, 0x01, 0xFF, 0xFF, 0xC0,
  0x12, 0x01, 0xFF, 0xFF, 0xC8, 0x2B, 0x11, 0xB8, 0x0A, 0xB4, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A,
  0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_assignment_late() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_assignment_late_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_assignment 48x48, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_round_48_action_assignment_data[] PROGMEM = {
  0x77, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x05, 0xFB, 0x05, 0x76, 0x81, 0x1A, 0xDF, 0xD8, 0x2B, 0x11, 0xBF, 0xD8, 0x4D,
  0xA1, 0x01, 0xEF, 0xF0, 0x12, 0x01, 0xFF, 0x81, 0xE1, 0xAF, 0xF9, 0x01, 0x20, 0x1F, 0xF9, 0x0A,
  0x0D, 0xFF, 0x98, 0x2B, 0x11, 0xBF, 0xF9, 0x0D, 0x80, 0xAA, 0x4F, 0x0B, 0x01, 0x77, 0x20, 0x10,
  0xBF, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x0B, 0x01, 0x77, 0x20,
  0x10, 0xB8, 0x0A, 0xB4, 0xF0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xFF, 0xA0, 0x17, 0x74, 0x01, 0xFF,
  0xA0, 0x17, 0x74, 0x01, 0xFF, 0xA0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0x80, 0xAB, 0x4F, 0x0B, 0x01,
  0x73, 0x01, 0x0B, 0xFF, 0xF9, 0x01, 0x75, 0x01, 0xFF, 0xF9, 0x01, 0x75, 0x01, 0xFF, 0xF9, 0x0B,
  0x01, 0x73, 0x01, 0x0B, 0x80, 0xAB, 0x2F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81,
  0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_assignment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_assignment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_assignment_returned 48x48, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_round_48_action_assignment_returned_data[] PROGMEM = {
  0x77, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x05, 0xFB, 0x05, 0x76, 0x81, 0x1A, 0xDF, 0xD8, 0x2B, 0x11, 0xBF, 0xD8, 0x4D,
  0xA1, 0x01, 0xEF, 0xF0, 0x12, 0x01, 0xFF, 0x81, 0xE1, 0xAF, 0xF9, 0x01, 0x20, 0x1F, 0xF9, 0x0A,
  0x0D, 0xFF, 0x98, 0x2B, 0x11, 0xBF, 0xF9, 0x0D, 0x80, 0xCD, 0x2F, 0x71, 0xFF, 0xFF, 0x71, 0xFF,
  0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF,
  0x71, 0xFF, 0xF9, 0x07, 0x77, 0x40, 0x7F, 0xFB, 0x07, 0x77, 0x20, 0x7F, 0xFD, 0x07, 0x77, 0x07,
  0xFF, 0xF0, 0x77, 0x50, 0x7F, 0xFF, 0xA0, 0x77, 0x30, 0x7F, 0xFF, 0xC0, 0x77, 0x10, 0x7F, 0xFF,
  0xE0, 0x76, 0x07, 0xFF, 0xFF, 0x90, 0x74, 0x07, 0xFF, 0xFF, 0xB0, 0x72, 0x07, 0xFF, 0xFF, 0xD0,
  0x09, 0x80, 0x9A, 0x5F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF,
  0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_assignment_returned() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_assignment_returned_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_assignment_return 48x48, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_round_48_action_assignment_return_data[] PROGMEM = {
  0x77, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x05, 0xFB, 0x05, 0x76, 0x81, 0x1A, 0xDF, 0xD8, 0x2B, 0x11, 0xBF, 0xD8, 0x4D,
  0xA1, 0x01, 0xEF, 0xF0, 0x12, 0x01, 0xFF, 0x81, 0xE1, 0xAF, 0xF9, 0x01, 0x20, 0x1F, 0xF9, 0x0A,
  0x0D, 0xFF, 0x98, 0x2B, 0x11, 0xBF, 0xF9, 0x0D, 0x80, 0xBC, 0x5F, 0x07, 0xFF, 0xFF, 0xE0, 0x71,
  0xFF, 0xFF, 0xD0, 0x72, 0xFF, 0xFF, 0xC0, 0x73, 0xFF, 0xFF, 0xB0, 0x74, 0xFF, 0xFF, 0xA0, 0x75,
  0xFF, 0xFF, 0x90, 0x77, 0x7F, 0xFE, 0x07, 0x77, 0x1F, 0xFD, 0x07, 0x77, 0x2F, 0xFC, 0x09, 0x77,
  0x3F, 0xFC, 0x09, 0x77, 0x3F, 0xFD, 0x07, 0x77, 0x2F, 0xFE, 0x07, 0x77, 0x1F, 0xFF, 0x07, 0x77,
  0xFF, 0xF9, 0x07, 0x5F, 0xFF, 0xFB, 0x07, 0x4F, 0xFF, 0xFC, 0x07, 0x3F, 0xFF, 0xFD, 0x07, 0x2F,
  0xFF, 0xFE, 0x07, 0x1F, 0xFF, 0xFF, 0x07, 0x80, 0x9A, 0x6F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF,
  0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_assignment_return() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_assignment_return_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_assignment_turned_in 48x48, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_round_48_action_assignment_turned_in_data[] PROGMEM = {
  0x77, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x05, 0xFB, 0x05, 0x76, 0x81, 0x1A, 0xDF, 0xD8, 0x2B, 0x11, 0xBF, 0xD8, 0x4D,
  0xA1, 0x01, 0xEF, 0xF0, 0x12, 0x01, 0xFF, 0x81, 0xE1, 0xAF, 0xF9, 0x01, 0x20, 0x1F, 0xF9, 0x0A,
  0x0D, 0xFF, 0x98, 0x2B, 0x11, 0xBF, 0xF9, 0x0D, 0x80, 0xBD, 0x5F, 0x82, 0xC2, 0x19, 0xFF, 0xFF,
  0xB0, 0xC4, 0x0E, 0xFF, 0xFF, 0x90, 0xC5, 0x0E, 0xFF, 0xFF, 0x0C, 0x50, 0x8F, 0xFF, 0xF0, 0xC5,
  0x08, 0xFF, 0xFF, 0x0C, 0x50, 0x8F, 0xFF, 0xF0, 0xC5, 0x08, 0xFF, 0xFF, 0x0C, 0x50, 0x8F, 0xFC,
  0x82, 0x80, 0x2C, 0xE0, 0xC5, 0x08, 0xFF, 0xC0, 0xE3, 0x01, 0x0C, 0xC0, 0xC5, 0x08, 0xFF, 0xD0,
  0xE5, 0x0C, 0xA0, 0xC5, 0x08, 0xFF, 0xF0, 0x85, 0x00, 0xC5, 0x08, 0xFF, 0xFA, 0x07, 0x73, 0x08,
  0xFF, 0xFC, 0x07, 0x71, 0x08, 0xFF, 0xFE, 0x07, 0x60, 0x8F, 0xFF, 0xF9, 0x07, 0x40, 0x8F, 0xFF,
  0xFB, 0x08, 0x20, 0x8F, 0xFF, 0xFD, 0x00, 0xE8, 0x0A, 0xC1, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A,
  0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_assignment_turned_in() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_assignment_turned_in_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_assured_workload 48x48, 4-bit Alpha,  RLE, 319 bytes.
static const unsigned char ic_round_48_action_assured_workload_data[] PROGMEM = {
  0x77, 0x48, 0x23, 0x77, 0x38, 0x0C, 0x20, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x77, 0x76, 0x03, 0x0B,
  0xF9, 0x0B, 0x03, 0x77, 0x77, 0x20, 0x30, 0xBF, 0xD0, 0xB0, 0x37, 0x77, 0x50, 0x30, 0xBF, 0xFA,
  0x0B, 0x03, 0x77, 0x71, 0x03, 0x0B, 0xFF, 0xE0, 0xB0, 0x37, 0x74, 0x03, 0x0B, 0xFF, 0xFB, 0x0B,
  0x03, 0x77, 0x03, 0x0B, 0xFF, 0xFF, 0x0B, 0x03, 0x73, 0x03, 0x0B, 0xFF, 0xFF, 0xC0, 0xB0, 0x36,
  0x01, 0x0B, 0x80, 0xC0, 0xF0, 0xB0, 0x14, 0x0B, 0x80, 0xC2, 0xF0, 0xB4, 0x0E, 0x80, 0xC2, 0xF0,
  0xE4, 0x0B, 0x80, 0xC2, 0xF0, 0xB4, 0x01, 0x0B, 0x80, 0xC0, 0xF0, 0xB0, 0x28, 0x0A, 0xE6, 0x08,
  0x24, 0xDD, 0x47, 0x18, 0x24, 0xDD, 0x47, 0x18, 0x24, 0xDD, 0x47, 0x72, 0x0D, 0xA0, 0xD7, 0x10,
  0xDA, 0x0D, 0x71, 0x0D, 0xA0, 0xD7, 0x72, 0xC7, 0x1C, 0x71, 0xC7, 0x72, 0xC7, 0x1C, 0x71, 0xC7,
  0x72, 0xC7, 0x1C, 0x71, 0xB0, 0xB7, 0x72, 0xC7, 0x1C, 0x71, 0x90, 0xB0, 0x47, 0x73, 0xC7, 0x1C,
  0x71, 0x04, 0x77, 0x5C, 0x71, 0xC7, 0x77, 0x7C, 0x71, 0xC7, 0x58, 0x24, 0xA9, 0x37, 0x5C, 0x71,
  0xC7, 0x30, 0x40, 0xBC, 0x0B, 0x03, 0x73, 0xC7, 0x1C, 0x71, 0x04, 0x0B, 0xF9, 0x0B, 0x03, 0x71,
  0xC7, 0x1C, 0x60, 0x20, 0xBF, 0xD0, 0xB0, 0x16, 0x0D, 0xA0, 0xD7, 0x10, 0xDA, 0x0D, 0x60, 0xCF,
  0xF0, 0xC6, 0x82, 0x4D, 0xD4, 0x71, 0x82, 0x4D, 0xD4, 0x6F, 0xB8, 0x1D, 0xAE, 0xB7, 0x77, 0x7F,
  0xA8, 0x2C, 0x10, 0x4B, 0x77, 0x77, 0xF9, 0x0C, 0x01, 0x20, 0x3B, 0x77, 0x77, 0xB8, 0x3D, 0x7B,
  0xFC, 0x30, 0x10, 0xCB, 0x77, 0x77, 0x0E, 0xA0, 0x32, 0x07, 0x30, 0x10, 0xCB, 0x81, 0xE4, 0xDF,
  0xFF, 0x90, 0x23, 0x0D, 0xA0, 0x45, 0x01, 0x0C, 0xC0, 0x0D, 0xFF, 0xFA, 0x03, 0x30, 0xBA, 0x0D,
  0x02, 0x30, 0x10, 0xCD, 0x0B, 0x0D, 0xFF, 0xFA, 0x06, 0x30, 0x7B, 0x83, 0xD3, 0x01, 0xCE, 0x81,
  0x74, 0xDF, 0xFF, 0x90, 0xA3, 0x01, 0xD0, 0xDF, 0x90, 0x17, 0x77, 0x71, 0x09, 0xFD, 0x09, 0x77,
  0x77, 0x20, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x77, 0x73, 0x04, 0xFB, 0x04, 0x77, 0x77, 0x50, 0x6F,
  0x90, 0x67, 0x77, 0x77, 0x04, 0x0D, 0xC0, 0xD0, 0x48, 0x0C, 0x20, 0x82, 0x7C, 0xC7, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_assured_workload() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 47, 47), Box(0, 0, 47, 47),
      ic_round_48_action_assured_workload_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_autorenew 48x48, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_round_48_action_autorenew_data[] PROGMEM = {
  0x77, 0x20, 0x05, 0x77, 0x77, 0x2A, 0x07, 0x77, 0x77, 0x1B, 0x07, 0x77, 0x77, 0xC0, 0x77, 0x77,
  0x6D, 0x07, 0x77, 0x78, 0x34, 0x9B, 0xDE, 0xE0, 0x77, 0x73, 0x81, 0x19, 0xEF, 0xD0, 0x57, 0x71,
  0x07, 0x0E, 0xFF, 0x05, 0x76, 0x01, 0x0C, 0xFF, 0x90, 0x77, 0x60, 0x20, 0xDD, 0x82, 0xD9, 0x42,
  0x1D, 0x07, 0x76, 0x01, 0x0D, 0xC0, 0xD0, 0x65, 0xC0, 0x77, 0x70, 0xCC, 0x0A, 0x7B, 0x07, 0x77,
  0x07, 0xC0, 0x87, 0x1A, 0x07, 0x77, 0x01, 0x0E, 0xB0, 0xA7, 0x20, 0x05, 0x73, 0x00, 0x13, 0x09,
  0xB0, 0xD7, 0x77, 0x06, 0xA0, 0x62, 0x0E, 0xB0, 0x67, 0x77, 0x0E, 0xA8, 0x1E, 0x04, 0xB0, 0xD7,
  0x77, 0x10, 0xDB, 0x04, 0x09, 0xB0, 0x97, 0x77, 0x10, 0x9B, 0x08, 0x0B, 0xB0, 0x47, 0x77, 0x10,
  0x4B, 0x0B, 0x0D, 0xB0, 0x27, 0x77, 0x10, 0x2B, 0x0D, 0x0E, 0xB7, 0x77, 0x3B, 0x00, 0xEB, 0x77,
  0x73, 0xB0, 0xE0, 0xDB, 0x02, 0x77, 0x71, 0x02, 0xB0, 0xD0, 0xBB, 0x04, 0x77, 0x71, 0x04, 0xB0,
  0xB0, 0x8B, 0x08, 0x77, 0x71, 0x09, 0xB0, 0x90, 0x4B, 0x0D, 0x77, 0x71, 0x0D, 0xB8, 0x14, 0x0E,
  0xA0, 0xE7, 0x77, 0x06, 0xB0, 0xE2, 0x06, 0xA0, 0x67, 0x77, 0x0D, 0xB0, 0x93, 0x00, 0x17, 0x30,
  0x05, 0x72, 0x0A, 0xB0, 0xE0, 0x17, 0x70, 0x7A, 0x71, 0x08, 0xC0, 0x77, 0x70, 0x7B, 0x70, 0xAC,
  0x0C, 0x77, 0x07, 0xC5, 0x06, 0x0D, 0xC0, 0xD0, 0x17, 0x60, 0x7D, 0x18, 0x22, 0x49, 0xDD, 0x0D,
  0x02, 0x76, 0x07, 0xFF, 0x90, 0xC0, 0x17, 0x60, 0x5F, 0xF0, 0xE0, 0x77, 0x71, 0x05, 0xFD, 0x81,
  0xE9, 0x17, 0x73, 0x07, 0xE8, 0x3E, 0xDB, 0x94, 0x77, 0x70, 0x7D, 0x77, 0x76, 0x07, 0xC7, 0x77,
  0x70, 0x7B, 0x77, 0x77, 0x10, 0x7A, 0x77, 0x77, 0x20, 0x05, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_autorenew() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 3, 39, 44), Box(0, 0, 47, 47),
      ic_round_48_action_autorenew_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_backup 48x48, 4-bit Alpha,  RLE, 222 bytes.
static const unsigned char ic_round_48_action_backup_data[] PROGMEM = {
  0x77, 0x38, 0x90, 0x37, 0xBD, 0xFE, 0xDB, 0x73, 0x77, 0x77, 0x40, 0x50, 0xCF, 0xB0, 0xD0, 0x57,
  0x77, 0x70, 0x20, 0xBF, 0xF0, 0xC0, 0x27, 0x77, 0x40, 0x30, 0xEF, 0xFA, 0x0E, 0x03, 0x77, 0x72,
  0x04, 0x0E, 0xFF, 0xD0, 0x37, 0x77, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x27, 0x76, 0x0B, 0xFF, 0xF9,
  0x0C, 0x77, 0x50, 0x5F, 0xFF, 0xB0, 0x57, 0x74, 0x0C, 0xFF, 0xFB, 0x0D, 0x77, 0x30, 0x2F, 0xFF,
  0xD0, 0x37, 0x71, 0x05, 0x0C, 0xFD, 0x00, 0xAF, 0xD0, 0x77, 0x60, 0x70, 0xEF, 0xE0, 0x82, 0x07,
  0xFC, 0x0B, 0x74, 0x01, 0x0C, 0xFF, 0x08, 0x40, 0x7F, 0xB0, 0xD7, 0x30, 0x10, 0xDF, 0xF0, 0x86,
  0x07, 0xFA, 0x0E, 0x73, 0x0C, 0xFF, 0x08, 0x71, 0x07, 0xFA, 0x81, 0xDA, 0x46, 0x07, 0xFF, 0x08,
  0x73, 0x07, 0xFC, 0x0C, 0x02, 0x40, 0xEF, 0xE0, 0x97, 0x50, 0x9F, 0xC0, 0xE0, 0x42, 0x06, 0xFF,
  0x09, 0x75, 0x09, 0xFD, 0x82, 0xE2, 0x0A, 0xFF, 0xD4, 0xFF, 0xC8, 0x1C, 0x0D, 0xFF, 0xD4, 0xFF,
  0xD0, 0x40, 0xEF, 0xFD, 0x4F, 0xFD, 0x09, 0x0E, 0xFF, 0xD4, 0xFF, 0xD0, 0x0D, 0xFF, 0xD0, 0x12,
  0x01, 0xFF, 0xD0, 0xE0, 0xAF, 0xFD, 0x82, 0xB1, 0x1B, 0xFF, 0xD0, 0xE0, 0x58, 0x0C, 0x6F, 0x81,
  0xD1, 0xE8, 0x0C, 0x5F, 0x81, 0x90, 0x78, 0x0C, 0x5F, 0x03, 0x20, 0xC8, 0x0C, 0x3F, 0x0B, 0x30,
  0x10, 0xD8, 0x0C, 0x1F, 0x0E, 0x02, 0x40, 0x10, 0xCF, 0xFF, 0xFF, 0x0E, 0x03, 0x70, 0x70, 0xEF,
  0xFF, 0xFC, 0x0B, 0x02, 0x72, 0x83, 0x15, 0xAD, 0xEF, 0xFF, 0xB8, 0x2E, 0xD9, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_backup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 39), Box(0, 0, 47, 47),
      ic_round_48_action_backup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_backup_table 48x48, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_round_48_action_backup_table_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0xC7, 0x77, 0x3C, 0x71, 0xC7,
  0x77, 0x3C, 0x71, 0xC7, 0x77, 0x3C, 0x71, 0xC7, 0x77, 0x3C, 0x82, 0x4D, 0xD4, 0x4C, 0x77, 0x73,
  0xC0, 0xDA, 0x0D, 0x4C, 0x77, 0x73, 0xF9, 0x4C, 0x77, 0x73, 0xF9, 0x4C, 0x77, 0x73, 0xF9, 0x4C,
  0x77, 0x73, 0xF9, 0x4C, 0x77, 0x73, 0xF9, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F,
  0x48, 0x0C, 0x0F, 0x4C, 0x73, 0xC7, 0x3F, 0x94, 0xC7, 0x3C, 0x73, 0xF9, 0x4C, 0x73, 0xC7, 0x3F,
  0x94, 0xC7, 0x3C, 0x73, 0xF9, 0x4C, 0x73, 0xC7, 0x3F, 0x94, 0xC7, 0x3C, 0x73, 0xF9, 0x4C, 0x73,
  0xC7, 0x3F, 0x94, 0xC7, 0x3C, 0x73, 0xF9, 0x4C, 0x73, 0xC7, 0x3F, 0x94, 0xC7, 0x3C, 0x73, 0xF9,
  0x40, 0xDF, 0xFF, 0xFA, 0x0D, 0xC4, 0x0A, 0xFF, 0xFF, 0xA0, 0xAC, 0x40, 0x10, 0xEF, 0xFF, 0xF0,
  0xE0, 0x1C, 0x58, 0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x11, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00,
  0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0x0D, 0xFF, 0xFF, 0x90, 0xD0, 0x47, 0x10, 0xAF, 0xFF, 0xFA,
  0x0D, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0x90, 0xD7, 0x28, 0x11, 0xAD, 0xFF, 0xFD, 0x0D, 0x04, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_backup_table() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_backup_table_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_balance 48x48, 4-bit Alpha,  RLE, 309 bytes.
static const unsigned char ic_round_48_action_balance_data[] PROGMEM = {
  0x77, 0x38, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x72, 0x0C,
  0xF9, 0x0C, 0x77, 0x77, 0x10, 0x6F, 0xB0, 0x67, 0x72, 0x04, 0x0D, 0xFF, 0x82, 0xB1, 0x1B, 0xFF,
  0x0D, 0x04, 0x40, 0xDF, 0xF9, 0x01, 0x20, 0x1F, 0xF9, 0x0D, 0x40, 0xDF, 0xF9, 0x01, 0x20, 0x1F,
  0xF9, 0x0D, 0x40, 0x40, 0xDF, 0xF8, 0x2B, 0x11, 0xBF, 0xF0, 0xD0, 0x47, 0x03, 0xA0, 0x35, 0x06,
  0xFB, 0x06, 0x50, 0x3A, 0x03, 0x73, 0x09, 0xA0, 0x96, 0x0C, 0xF9, 0x0C, 0x60, 0x9A, 0x09, 0x72,
  0x01, 0xC0, 0x15, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0x01, 0xC0, 0x17, 0x10, 0x7C, 0x07, 0x70, 0x6C,
  0x06, 0x70, 0x7C, 0x07, 0x71, 0x0D, 0xC0, 0xD7, 0x1C, 0x71, 0x0D, 0xC0, 0xD7, 0x05, 0xA0, 0x0D,
  0xA0, 0x57, 0xC7, 0x05, 0xA0, 0x0D, 0xA0, 0x56, 0x0C, 0xA0, 0x07, 0xA0, 0xC7, 0xC7, 0x0C, 0xA0,
  0x07, 0xA0, 0xC5, 0x03, 0xB0, 0x01, 0xB0, 0x36, 0xC6, 0x03, 0xB0, 0x01, 0xB0, 0x34, 0x09, 0xA0,
  0x92, 0x09, 0xA0, 0x96, 0xC6, 0x09, 0xA0, 0x92, 0x09, 0xA0, 0x93, 0x01, 0xB0, 0x22, 0x02, 0xB0,
  0x15, 0xC5, 0x01, 0xB0, 0x22, 0x02, 0xB0, 0x12, 0x07, 0xA0, 0xB4, 0x0B, 0xA0, 0x75, 0xC5, 0x07,
  0xA0, 0xB4, 0x0B, 0xA0, 0x72, 0x0D, 0xA0, 0x54, 0x05, 0xA0, 0xD5, 0xC5, 0x0D, 0xA0, 0x54, 0x05,
  0xA8, 0x1D, 0x05, 0xA0, 0xD6, 0x0D, 0xA0, 0x54, 0xC4, 0x05, 0xA0, 0xD6, 0x0D, 0xA0, 0x50, 0xAA,
  0x07, 0x60, 0x7A, 0x0A, 0x4C, 0x40, 0xAA, 0x07, 0x60, 0x7A, 0x0A, 0x0D, 0xFD, 0x0D, 0x4C, 0x40,
  0xDF, 0xD0, 0xD0, 0xBF, 0xD0, 0xB4, 0xC4, 0x0B, 0xFD, 0x0B, 0x04, 0xFD, 0x05, 0x4C, 0x40, 0x3F,
  0xD8, 0x15, 0x09, 0xFB, 0x09, 0x5C, 0x50, 0x9F, 0xB0, 0x93, 0x08, 0xF9, 0x08, 0x6C, 0x60, 0x8F,
  0x90, 0x85, 0x86, 0x18, 0xCE, 0xEC, 0x81, 0x7C, 0x78, 0x61, 0x8C, 0xEE, 0xC8, 0x17, 0x77, 0xC8,
  0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC7, 0x74,
  0x04, 0x0D, 0x80, 0xC0, 0xF8, 0x1D, 0x4D, 0x80, 0xC2, 0xF0, 0x0D, 0x80, 0xC2, 0xF8, 0x1D, 0x4D,
  0x80, 0xC0, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_balance() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_balance_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_batch_prediction 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_round_48_action_batch_prediction_data[] PROGMEM = {
  0x50, 0x80, 0xDF, 0xF0, 0xD0, 0x87, 0x20, 0x8F, 0xFC, 0x08, 0x71, 0x0D, 0xFF, 0xC0, 0xD8, 0x09,
  0xA7, 0x00, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x50, 0x8F, 0xFF, 0x90, 0x84, 0x0D, 0xFF, 0xF9, 0x0D,
  0x80, 0x9A, 0x30, 0x81, 0x1A, 0xDF, 0xFE, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFB, 0x81, 0xE1, 0xAF,
  0xFF, 0xD0, 0xA0, 0xDF, 0xA8, 0x1E, 0x72, 0x28, 0x12, 0x7E, 0xFA, 0x0D, 0xFA, 0x0A, 0x71, 0x0A,
  0xFF, 0xB0, 0xA7, 0x30, 0xAF, 0xF9, 0x0E, 0x75, 0x0E, 0xFF, 0x07, 0x75, 0x07, 0xFF, 0x02, 0x75,
  0x02, 0xFF, 0x77, 0xFF, 0x01, 0x75, 0x01, 0xFF, 0x04, 0x75, 0x04, 0xFF, 0x0A, 0x75, 0x0A, 0xFF,
  0x90, 0x37, 0x30, 0x3F, 0xFA, 0x0C, 0x73, 0x0D, 0xFF, 0xB0, 0x97, 0x10, 0x9F, 0xFD, 0x04, 0x60,
  0x5F, 0xFE, 0x0E, 0x01, 0x40, 0x10, 0xEF, 0xFF, 0x09, 0x40, 0x9F, 0xFF, 0x90, 0xD4, 0x0D, 0x80,
  0x99, 0x3F, 0x4F, 0xFF, 0xB0, 0x12, 0x01, 0xFD, 0x0D, 0xFC, 0x82, 0xB1, 0x1B, 0xFC, 0x0D, 0x0A,
  0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_batch_prediction() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 43), Box(0, 0, 47, 47),
      ic_round_48_action_batch_prediction_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_bookmark_added 48x48, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_round_48_action_bookmark_added_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFE, 0x0A, 0x76, 0x84, 0x6D, 0xA1, 0x1E, 0xFF, 0x90, 0x17, 0x50, 0x7B, 0x09,
  0x0A, 0xFF, 0x90, 0xA7, 0x50, 0x7C, 0x09, 0x0D, 0xFF, 0x90, 0x57, 0x40, 0x7C, 0x0E, 0x02, 0xFF,
  0xA0, 0x24, 0x81, 0x28, 0x73, 0x07, 0xC0, 0xE0, 0x31, 0xFF, 0xA5, 0x0D, 0xA8, 0x1B, 0x07, 0xC0,
  0xE0, 0x32, 0xFF, 0xA4, 0x01, 0xC0, 0xDC, 0x0E, 0x03, 0x3F, 0xFA, 0x02, 0x40, 0xBF, 0x0E, 0x03,
  0x4F, 0xFA, 0x05, 0x50, 0xCD, 0x0E, 0x03, 0x5F, 0xFA, 0x0A, 0x60, 0xCB, 0x0E, 0x03, 0x6F, 0xFB,
  0x02, 0x68, 0x2B, 0xFD, 0x37, 0xFF, 0xB0, 0xA7, 0x01, 0x72, 0xFF, 0xC0, 0x77, 0x72, 0xFF, 0xD0,
  0x77, 0x71, 0xFF, 0xE0, 0xA0, 0x27, 0x6F, 0xFF, 0x98, 0x1A, 0x52, 0x20, 0x27, 0xFF, 0xFF, 0x7F,
  0xFF, 0xF7, 0xFF, 0xFF, 0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0x7F, 0xFF,
  0xF7, 0xFF, 0xFF, 0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0x7F, 0xFF, 0xF7,
  0xFD, 0x82, 0x93, 0x39, 0xFD, 0x7F, 0xA8, 0x1D, 0x71, 0x48, 0x11, 0x7D, 0xFA, 0x7F, 0x0C, 0x05,
  0x73, 0x05, 0x0C, 0xF7, 0x0D, 0xC0, 0x90, 0x37, 0x70, 0x30, 0x9C, 0x0D, 0x78, 0x33, 0xDC, 0x71,
  0x77, 0x48, 0x31, 0x7C, 0xC3, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_bookmark_added() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 44, 40), Box(0, 0, 47, 47),
      ic_round_48_action_bookmark_added_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_bookmark_add 48x48, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_round_48_action_bookmark_add_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFE, 0x0A, 0x68, 0x24, 0xDD, 0x44, 0x01, 0x0E, 0xFF, 0x90, 0x16, 0x0D, 0xA0,
  0xD4, 0x0A, 0xFF, 0x90, 0xA7, 0xC4, 0x0D, 0xFF, 0x90, 0x57, 0xC4, 0xFF, 0xA0, 0x23, 0x04, 0x0D,
  0xF9, 0x0D, 0x04, 0xFF, 0xA4, 0x0D, 0xFB, 0x0D, 0xFF, 0xA4, 0x0D, 0xFB, 0x0D, 0xFF, 0xA0, 0x23,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0xFF, 0xA0, 0x57, 0xC4, 0xFF, 0xA0, 0xA7, 0xC4, 0xFF, 0xB0, 0x26,
  0x0D, 0xA0, 0xD4, 0xFF, 0xB0, 0xA6, 0x82, 0x4D, 0xD4, 0x4F, 0xFC, 0x07, 0x76, 0xFF, 0xD0, 0x77,
  0x5F, 0xFE, 0x0A, 0x02, 0x73, 0xFF, 0xF9, 0x81, 0xA5, 0x22, 0x02, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF,
  0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F,
  0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xD8,
  0x29, 0x33, 0x9F, 0xD4, 0xFA, 0x81, 0xD7, 0x14, 0x81, 0x17, 0xDF, 0xA4, 0xF0, 0xC0, 0x57, 0x30,
  0x50, 0xCF, 0x40, 0xDC, 0x09, 0x03, 0x77, 0x03, 0x09, 0xC0, 0xD4, 0x83, 0x3D, 0xC7, 0x17, 0x74,
  0x83, 0x17, 0xCC, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_bookmark_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 41, 40), Box(0, 0, 47, 47),
      ic_round_48_action_bookmark_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_bookmark_border 48x48, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_round_48_action_bookmark_border_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xF9, 0x01, 0x77, 0x40, 0x1F, 0x97,
  0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x72,
  0x00, 0x27, 0x2F, 0x97, 0x04, 0x0A, 0xA0, 0xA0, 0x47, 0xF9, 0x50, 0x60, 0xCE, 0x0C, 0x06, 0x5F,
  0x92, 0x81, 0x18, 0xEF, 0xB8, 0x1E, 0x81, 0x2F, 0x90, 0x30, 0xAF, 0xFA, 0x0A, 0x03, 0xFF, 0xA8,
  0x29, 0x33, 0x9F, 0xFF, 0x81, 0xE7, 0x14, 0x81, 0x17, 0xEF, 0xFA, 0x0C, 0x05, 0x73, 0x05, 0x0C,
  0xFD, 0x09, 0x03, 0x77, 0x03, 0x09, 0xF8, 0x1E, 0x71, 0x77, 0x48, 0x11, 0x7E, 0xA0, 0xC0, 0x57,
  0x77, 0x30, 0x50, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_bookmark_border() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_round_48_action_bookmark_border_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_bookmark 48x48, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_48_action_bookmark_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0x9B, 0xC0, 0xF8, 0x29, 0x33, 0x9F, 0xFF, 0x81, 0xE7, 0x14, 0x81,
  0x17, 0xEF, 0xFA, 0x0C, 0x05, 0x73, 0x05, 0x0C, 0xFD, 0x09, 0x03, 0x77, 0x03, 0x09, 0xF8, 0x1E,
  0x71, 0x77, 0x48, 0x11, 0x7E, 0xA0, 0xC0, 0x57, 0x77, 0x30, 0x50, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_bookmark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_round_48_action_bookmark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_bookmark_remove 48x48, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_round_48_action_bookmark_remove_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFE, 0x0A, 0x77, 0x01, 0x0E, 0xFF, 0x90, 0x17, 0x70, 0xAF, 0xF9, 0x0A, 0x77,
  0x10, 0xDF, 0xF9, 0x05, 0x77, 0x1F, 0xFA, 0x02, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x4F, 0xFA, 0x40,
  0xDF, 0xB0, 0xDF, 0xFA, 0x40, 0xDF, 0xB0, 0xDF, 0xFA, 0x02, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x4F,
  0xFA, 0x05, 0x77, 0x1F, 0xFA, 0x0A, 0x77, 0x1F, 0xFB, 0x02, 0x77, 0xFF, 0xB0, 0xA7, 0x7F, 0xFC,
  0x07, 0x76, 0xFF, 0xD0, 0x77, 0x5F, 0xFE, 0x0A, 0x02, 0x73, 0xFF, 0xF9, 0x81, 0xA5, 0x22, 0x02,
  0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F,
  0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF,
  0xF4, 0xFF, 0xFF, 0x4F, 0xD8, 0x29, 0x33, 0x9F, 0xD4, 0xFA, 0x81, 0xD7, 0x14, 0x81, 0x17, 0xDF,
  0xA4, 0xF0, 0xC0, 0x57, 0x30, 0x50, 0xCF, 0x40, 0xDC, 0x09, 0x03, 0x77, 0x03, 0x09, 0xC0, 0xD4,
  0x83, 0x3C, 0xC7, 0x17, 0x74, 0x83, 0x17, 0xCC, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_bookmark_remove() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 41, 40), Box(0, 0, 47, 47),
      ic_round_48_action_bookmark_remove_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_bookmarks 48x48, 4-bit Alpha,  RLE, 193 bytes.
static const unsigned char ic_round_48_action_bookmarks_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xEF, 0xFE, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x10,
  0xAF, 0xFF, 0xD0, 0xA7, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x77, 0x78, 0x11, 0x5D, 0xD7, 0x77, 0x72,
  0x01, 0x0D, 0xC7, 0x77, 0x73, 0x05, 0xC7, 0x77, 0x73, 0x01, 0xC1, 0x81, 0x1A, 0xDF, 0xFE, 0x81,
  0xDA, 0x15, 0xC0, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x14, 0xC0, 0xAF, 0xFF, 0xD0, 0xA4, 0xC0, 0xDF,
  0xFF, 0xD0, 0xD4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF,
  0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF,
  0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4,
  0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF,
  0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0x03, 0x0B, 0xFF, 0xFF, 0xA6, 0x03, 0x0B, 0xFF,
  0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFD, 0x82, 0x93, 0x39, 0xFD, 0x71, 0xFA, 0x81, 0xE7, 0x14, 0x81,
  0x17, 0xEF, 0xA7, 0x1F, 0x0C, 0x05, 0x73, 0x05, 0x0C, 0xF7, 0x1D, 0x09, 0x03, 0x77, 0x03, 0x09,
  0xD7, 0x1A, 0x81, 0xE7, 0x17, 0x74, 0x81, 0x17, 0xEA, 0x71, 0x0C, 0x05, 0x77, 0x73, 0x05, 0x0C,
  0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_bookmarks() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_round_48_action_bookmarks_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_book_online 48x48, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_round_48_action_book_online_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0xAD, 0x0F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x20, 0x30, 0xDF, 0xD0, 0xD0, 0x32, 0xF9, 0x20, 0xCF, 0xF0, 0xC2, 0xF9, 0x2F, 0xFA, 0x2F,
  0x92, 0xF0, 0x03, 0xF2, 0xF9, 0x2F, 0x00, 0x3F, 0x2F, 0x92, 0xFF, 0xA2, 0xF9, 0x20, 0x40, 0xDF,
  0xD0, 0xB0, 0x12, 0xF9, 0x30, 0x2D, 0x00, 0x3D, 0x01, 0x3F, 0x93, 0x01, 0xD0, 0x03, 0xD0, 0x13,
  0xF9, 0x30, 0x8F, 0xD0, 0xB0, 0x12, 0xF9, 0x20, 0xEF, 0xF9, 0x2F, 0x92, 0xF0, 0x03, 0xF2, 0xF9,
  0x2F, 0x00, 0x3F, 0x2F, 0x92, 0xFF, 0xA2, 0xF9, 0x20, 0xCF, 0xF0, 0xC2, 0xF9, 0x20, 0x30, 0xDF,
  0xD0, 0xD0, 0x32, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0x80, 0xAD, 0x0F,
  0x0D, 0xFF, 0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF,
  0xFE, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_book_online() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_round_48_action_book_online_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_book 48x48, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_48_action_book_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0x81, 0xE1, 0xAF, 0xFF, 0xFA,
  0x0A, 0x0D, 0xFF, 0xFF, 0xA0, 0xDC, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73,
  0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF,
  0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x38, 0x22, 0xAA,
  0x23, 0xFF, 0xF9, 0x20, 0x7C, 0x07, 0x2F, 0xFF, 0x90, 0x40, 0xDE, 0x0D, 0x04, 0x80, 0x98, 0x96,
  0xF0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_book() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_book_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_browse_gallery 48x48, 4-bit Alpha,  RLE, 331 bytes.
static const unsigned char ic_round_48_action_browse_gallery_data[] PROGMEM = {
  0x75, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x77, 0x76, 0x04, 0x0B, 0xFD, 0x0B, 0x04,
  0x77, 0x77, 0x20, 0x30, 0xBF, 0xFA, 0x0B, 0x03, 0x71, 0x82, 0x2B, 0xA3, 0x77, 0x10, 0x8F, 0xFE,
  0x08, 0x70, 0xCB, 0x08, 0x75, 0x01, 0x0B, 0xFF, 0xF9, 0x0B, 0x01, 0x50, 0xEC, 0x0B, 0x73, 0x01,
  0x0C, 0xFF, 0xFB, 0x0C, 0x01, 0x40, 0x6D, 0x0C, 0x72, 0x0B, 0xFF, 0xFD, 0x0B, 0x50, 0x30, 0xDC,
  0x0B, 0x70, 0x8F, 0xFF, 0xF0, 0x86, 0x0B, 0xC0, 0x85, 0x03, 0xFE, 0x82, 0xB1, 0x1B, 0xFE, 0x03,
  0x60, 0xBC, 0x03, 0x40, 0xBF, 0xE0, 0x12, 0x01, 0xFE, 0x0B, 0x70, 0xDB, 0x0C, 0x30, 0x4F, 0xF4,
  0xFF, 0x04, 0x60, 0x3C, 0x05, 0x20, 0xBF, 0xF4, 0xFF, 0x0B, 0x70, 0x9B, 0x81, 0xB0, 0x1F, 0xF9,
  0x4F, 0xF9, 0x01, 0x60, 0x2C, 0x01, 0x05, 0xFF, 0x94, 0xFF, 0x90, 0x57, 0x0B, 0xB0, 0x60, 0x9F,
  0xF9, 0x4F, 0xF9, 0x09, 0x70, 0x7B, 0x09, 0x0B, 0xFF, 0x94, 0xFF, 0x90, 0xB7, 0x03, 0xB0, 0xC0,
  0xDF, 0xF9, 0x4F, 0xF9, 0x0D, 0x70, 0x1B, 0x0D, 0x0E, 0xFF, 0x90, 0x13, 0x0A, 0xFF, 0x0E, 0x71,
  0xB0, 0x0E, 0xFF, 0x90, 0x44, 0x0A, 0xFE, 0x0E, 0x71, 0xB0, 0xE0, 0xDF, 0xF9, 0x0B, 0x50, 0xAF,
  0xD0, 0xD7, 0x01, 0xB0, 0xD0, 0xBF, 0xFA, 0x0A, 0x50, 0xAF, 0xC0, 0xB7, 0x03, 0xB0, 0xC0, 0x9F,
  0xFB, 0x0A, 0x50, 0xAF, 0xB0, 0x97, 0x07, 0xB0, 0x90, 0x5F, 0xFC, 0x0A, 0x50, 0xCF, 0xA0, 0x57,
  0x0B, 0xB0, 0x60, 0x1F, 0xFD, 0x0A, 0x40, 0x7F, 0xA0, 0x16, 0x02, 0xC8, 0x11, 0x0B, 0xFF, 0xD0,
  0xA3, 0x0A, 0xF9, 0x0B, 0x70, 0x9B, 0x0B, 0x20, 0x4F, 0xFE, 0x81, 0xC7, 0xAF, 0xA0, 0x46, 0x03,
  0xC0, 0x53, 0x0B, 0xFF, 0xFF, 0xA0, 0xB7, 0x0D, 0xB0, 0xC4, 0x03, 0xFF, 0xFF, 0xA0, 0x36, 0x0B,
  0xC0, 0x35, 0x08, 0xFF, 0xFF, 0x08, 0x60, 0xBC, 0x08, 0x70, 0xBF, 0xFF, 0xD0, 0xB5, 0x03, 0x0D,
  0xC0, 0xB7, 0x10, 0x10, 0xCF, 0xFF, 0xB0, 0xC0, 0x14, 0x06, 0xD0, 0xC7, 0x30, 0x10, 0xBF, 0xFF,
  0x90, 0xB0, 0x15, 0x0E, 0xC0, 0xB7, 0x60, 0x8F, 0xFE, 0x08, 0x70, 0xCB, 0x08, 0x77, 0x10, 0x30,
  0xBF, 0xFA, 0x0B, 0x03, 0x71, 0x82, 0x2B, 0xA3, 0x77, 0x40, 0x40, 0xBF, 0xD0, 0xB0, 0x47, 0x77,
  0x76, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_browse_gallery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 47, 41), Box(0, 0, 47, 47),
      ic_round_48_action_browse_gallery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_bug_report 48x48, 4-bit Alpha,  RLE, 214 bytes.
static const unsigned char ic_round_48_action_bug_report_data[] PROGMEM = {
  0x71, 0x01, 0x77, 0x01, 0x77, 0x18, 0x29, 0xFE, 0x57, 0x38, 0x25, 0xEF, 0x97, 0x60, 0x1C, 0x05,
  0x71, 0x05, 0xC0, 0x17, 0x60, 0xEC, 0x05, 0x60, 0x5C, 0x0E, 0x77, 0x05, 0xD0, 0xB0, 0xDA, 0x0D,
  0x0B, 0xD0, 0x57, 0x71, 0x05, 0xFF, 0x05, 0x77, 0x20, 0x50, 0xEF, 0xD0, 0xE0, 0x57, 0x71, 0x06,
  0xFF, 0xA0, 0x67, 0x60, 0x5F, 0xFC, 0x05, 0x74, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x15, 0x04, 0x0D,
  0xFF, 0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF, 0xFF, 0xF0,
  0xD0, 0x44, 0x0D, 0xF0, 0xB0, 0x14, 0x01, 0x0B, 0xF0, 0xD7, 0x10, 0xEF, 0x01, 0x60, 0x1F, 0x0E,
  0x71, 0xF9, 0x01, 0x60, 0x1F, 0x97, 0x1F, 0x90, 0xB0, 0x14, 0x01, 0x0B, 0xF9, 0x40, 0x40, 0xDF,
  0xFF, 0xF8, 0x1D, 0x4D, 0xFF, 0xFF, 0xA0, 0x0D, 0xFF, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xFF, 0x0D,
  0x04, 0x4F, 0x90, 0xB0, 0x14, 0x01, 0x0B, 0xF9, 0x71, 0xF9, 0x01, 0x60, 0x1F, 0x97, 0x10, 0xEF,
  0x01, 0x60, 0x1F, 0x0E, 0x71, 0x0D, 0xF0, 0xB0, 0x14, 0x01, 0x0B, 0xF0, 0xD4, 0x04, 0x0D, 0xFF,
  0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF, 0xFF, 0xF0, 0xD0,
  0x45, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x17, 0x40, 0x5F, 0xFC, 0x05, 0x76, 0x06, 0xFF, 0xA0, 0x67,
  0x71, 0x05, 0x0E, 0xFD, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0x76, 0x82, 0x17,
  0xAD, 0xA8, 0x2D, 0xA7, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_bug_report() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 39, 41), Box(0, 0, 47, 47),
      ic_round_48_action_bug_report_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_build_circle 48x48, 4-bit Alpha,  RLE, 291 bytes.
static const unsigned char ic_round_48_action_build_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFB, 0x83, 0xD9, 0x9A, 0xDF,
  0xFB, 0x0E, 0x01, 0x40, 0x9F, 0xB0, 0x85, 0x03, 0x0C, 0xFF, 0xA0, 0x93, 0x01, 0xFD, 0x05, 0x60,
  0xAF, 0xFA, 0x01, 0x20, 0x8F, 0xE0, 0x56, 0x0D, 0xFF, 0x90, 0x82, 0x0D, 0xF9, 0x08, 0xD0, 0x55,
  0x04, 0xFF, 0x98, 0x1D, 0x03, 0xF9, 0x81, 0xD0, 0x4D, 0x05, 0x50, 0xEF, 0xF9, 0x03, 0x07, 0xF9,
  0x09, 0x20, 0x4C, 0x06, 0x50, 0xBF, 0xF9, 0x07, 0x0A, 0xF9, 0x09, 0x30, 0x4A, 0x06, 0x60, 0xAF,
  0xF9, 0x0A, 0x0C, 0xF9, 0x09, 0x40, 0x40, 0x67, 0x0B, 0xFF, 0x90, 0xC0, 0xEF, 0x90, 0xE7, 0x60,
  0xEF, 0xF9, 0x0E, 0xFB, 0x04, 0x75, 0x04, 0xFF, 0xFD, 0x0D, 0x76, 0x04, 0xFF, 0x90, 0xEF, 0xB0,
  0xB7, 0x60, 0x4F, 0xE0, 0xE0, 0xCF, 0xC0, 0xD0, 0x47, 0x50, 0x4F, 0xD0, 0xC0, 0xAF, 0xE8, 0x4E,
  0xB9, 0xBE, 0x47, 0x04, 0xFC, 0x0A, 0x07, 0xFF, 0xD0, 0x47, 0x04, 0xFB, 0x07, 0x03, 0xFF, 0xE0,
  0x47, 0x08, 0xFA, 0x81, 0x30, 0xDF, 0xFE, 0x04, 0x60, 0x6F, 0x90, 0xD2, 0x08, 0xFF, 0xF0, 0x45,
  0x0C, 0xF9, 0x08, 0x20, 0x1F, 0xFF, 0x90, 0x43, 0x0A, 0xFA, 0x01, 0x30, 0x9F, 0xFF, 0x98, 0x18,
  0x6C, 0xFA, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70,
  0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09,
  0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09,
  0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D,
  0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_build_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_build_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_build 48x48, 4-bit Alpha,  RLE, 276 bytes.
static const unsigned char ic_round_48_action_build_data[] PROGMEM = {
  0x71, 0x89, 0x02, 0x7A, 0xDE, 0xED, 0xA7, 0x27, 0x77, 0x74, 0x05, 0xFB, 0x0B, 0x03, 0x77, 0x77,
  0x30, 0x8F, 0xC0, 0x87, 0x77, 0x73, 0x08, 0xFC, 0x0B, 0x77, 0x77, 0x30, 0x8F, 0xC0, 0xB7, 0x77,
  0x73, 0x08, 0xFC, 0x08, 0x77, 0x77, 0x30, 0x8F, 0xC0, 0x37, 0x75, 0x04, 0x74, 0x08, 0xFB, 0x0B,
  0x77, 0x48, 0x12, 0xF7, 0x74, 0x08, 0xFB, 0x02, 0x77, 0x30, 0x7A, 0x07, 0x74, 0x0E, 0xFA, 0x07,
  0x77, 0x30, 0xBB, 0x07, 0x73, 0x0E, 0xFA, 0x0B, 0x77, 0x30, 0xDC, 0x07, 0x71, 0x08, 0xFB, 0x0D,
  0x77, 0x30, 0xED, 0x07, 0x60, 0x8F, 0xC0, 0xE7, 0x73, 0x0E, 0xE0, 0x74, 0x08, 0xFD, 0x0E, 0x77,
  0x30, 0xDF, 0x07, 0x20, 0x8F, 0xE0, 0xD7, 0x73, 0x0B, 0xF9, 0x0D, 0x0E, 0xFF, 0x0B, 0x77, 0x30,
  0x7F, 0xFF, 0xB0, 0x77, 0x73, 0x02, 0xFF, 0xFB, 0x03, 0x77, 0x40, 0xBF, 0xFF, 0xA0, 0xB7, 0x74,
  0x03, 0xFF, 0xFB, 0x0B, 0x77, 0x40, 0x9F, 0xFF, 0xB0, 0xB7, 0x74, 0x0B, 0xFF, 0xFB, 0x0B, 0x77,
  0x30, 0x10, 0xBF, 0xFF, 0xB0, 0xB7, 0x74, 0x09, 0xFF, 0xFB, 0x0B, 0x77, 0x40, 0x30, 0xBF, 0xFF,
  0xA0, 0xB7, 0x75, 0x82, 0x27, 0xBD, 0xA8, 0x3D, 0xB7, 0x4E, 0xFE, 0x0B, 0x77, 0x77, 0x02, 0x0E,
  0xFE, 0x0B, 0x77, 0x77, 0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x77, 0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x77,
  0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x77, 0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x77, 0x02, 0x0E, 0xFE, 0x0B,
  0x77, 0x77, 0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x77, 0x02, 0x0E, 0xFE, 0x0B, 0x77, 0x77, 0x02, 0x0E,
  0xFE, 0x08, 0x77, 0x77, 0x02, 0x0E, 0xFE, 0x01, 0x77, 0x77, 0x02, 0x0E, 0xFD, 0x05, 0x77, 0x77,
  0x10, 0x20, 0xEF, 0xC0, 0x67, 0x77, 0x72, 0x02, 0x0E, 0xFB, 0x04, 0x77, 0x77, 0x30, 0x20, 0xEF,
  0x90, 0xE7, 0x77, 0x75, 0x02, 0x0E, 0xF0, 0x57, 0x77, 0x76, 0x02, 0x0C, 0xD0, 0x68, 0x0C, 0x10,
  0x83, 0x48, 0x96, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_build() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 44, 44), Box(0, 0, 47, 47),
      ic_round_48_action_build_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_cached 48x48, 4-bit Alpha,  RLE, 238 bytes.
static const unsigned char ic_round_48_action_cached_data[] PROGMEM = {
  0x77, 0x28, 0x90, 0x49, 0xBD, 0xEE, 0xDB, 0x84, 0x77, 0x77, 0x18, 0x11, 0x9E, 0xFB, 0x0E, 0x06,
  0x77, 0x75, 0x07, 0x0E, 0xFF, 0x01, 0x77, 0x72, 0x01, 0x0C, 0xFF, 0xA0, 0x17, 0x77, 0x10, 0x20,
  0xDD, 0x82, 0xD9, 0x42, 0x28, 0x42, 0x49, 0xDE, 0x67, 0x77, 0x10, 0x10, 0xDC, 0x0D, 0x06, 0x77,
  0x77, 0x60, 0xCC, 0x0A, 0x77, 0x77, 0x70, 0x7C, 0x08, 0x77, 0x77, 0x70, 0x10, 0xEB, 0x0A, 0x77,
  0x71, 0x00, 0x57, 0x50, 0x9B, 0x0D, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x40, 0xEB, 0x06, 0x77, 0x70,
  0x7C, 0x07, 0x72, 0x04, 0xB0, 0xD7, 0x77, 0x07, 0xE0, 0x77, 0x10, 0x9B, 0x09, 0x77, 0x60, 0x7F,
  0x90, 0x77, 0x0B, 0xB0, 0x47, 0x75, 0x07, 0xFB, 0x07, 0x60, 0xDB, 0x02, 0x77, 0x40, 0x5F, 0xD0,
  0x55, 0x0E, 0xB7, 0x75, 0x05, 0xFD, 0x00, 0x5F, 0xD0, 0x57, 0x75, 0xB0, 0xE5, 0x05, 0xFD, 0x05,
  0x77, 0x40, 0x2B, 0x0D, 0x60, 0x7F, 0xB0, 0x77, 0x75, 0x04, 0xB0, 0xB7, 0x07, 0xF9, 0x07, 0x77,
  0x60, 0x9B, 0x09, 0x71, 0x07, 0xE0, 0x77, 0x77, 0x0D, 0xB0, 0x47, 0x20, 0x7C, 0x07, 0x77, 0x70,
  0x6B, 0x0E, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x10, 0xDB, 0x09, 0x75, 0x00, 0x57, 0x77, 0x10, 0xAB,
  0x0E, 0x01, 0x77, 0x77, 0x70, 0x8C, 0x07, 0x77, 0x77, 0x70, 0xAC, 0x0C, 0x77, 0x77, 0x60, 0x60,
  0xDC, 0x0D, 0x01, 0x77, 0x71, 0x84, 0x6E, 0xD9, 0x42, 0x28, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x77,
  0x71, 0x01, 0xFF, 0xA0, 0xC0, 0x17, 0x77, 0x20, 0x1F, 0xF0, 0xE0, 0x77, 0x77, 0x50, 0x60, 0xEF,
  0xB8, 0x1E, 0x91, 0x77, 0x77, 0x18, 0x90, 0x48, 0xBD, 0xEE, 0xDB, 0x94, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_cached() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 8, 44, 39), Box(0, 0, 47, 47),
      ic_round_48_action_cached_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_calendar_month 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_48_action_calendar_month_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x72, 0x82, 0x4D, 0xD4, 0x75, 0x0D, 0xA0, 0xD7, 0x72, 0x0D, 0xA0, 0xD7,
  0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x4D, 0xA1, 0x01, 0xEF,
  0xFF, 0xFC, 0x81, 0xE1, 0x9F, 0xFF, 0xFE, 0x0A, 0x0D, 0xFF, 0xFF, 0xE0, 0xD8, 0x0C, 0xC0, 0xF7,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x94, 0x82, 0x4D, 0xD4, 0x48,
  0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x4F, 0x94, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0,
  0xD4, 0xF9, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x4F, 0x94, 0x82, 0x4D, 0xD4,
  0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77,
  0x7F, 0x97, 0x77, 0x7F, 0x94, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x4F,
  0x94, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0xF9, 0x40, 0xDA, 0x0D, 0x40, 0xDA,
  0x0D, 0x40, 0xDA, 0x0D, 0x4F, 0x94, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4,
  0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C, 0x0D, 0xFF, 0xFF,
  0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_calendar_month() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_calendar_month_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_calendar_today 48x48, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_round_48_action_calendar_today_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x76, 0x82, 0x4D, 0xD4, 0x75, 0x0D, 0xA0, 0xD7, 0x76, 0x0D, 0xA0, 0xD7,
  0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x84, 0xDA, 0x10, 0x1E,
  0x80, 0xC0, 0xF8, 0x1E, 0x1A, 0x80, 0xC2, 0xF0, 0xA0, 0xD8, 0x0C, 0x2F, 0x0D, 0x80, 0xBE, 0x0F,
  0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x97, 0x77, 0x74, 0xF9, 0x01, 0x77, 0x77, 0x20, 0x1F, 0x90, 0xB0, 0x17, 0x77, 0x70, 0x10, 0xBC,
  0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_calendar_today() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_round_48_action_calendar_today_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_calendar_view_day 48x48, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_48_action_calendar_view_day_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x48, 0x0A, 0x95, 0x08, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E,
  0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF, 0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xED, 0x4F,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x18, 0x0A, 0x95, 0x00, 0x40, 0xDF, 0xFF, 0xFC, 0x81, 0xD4, 0xDF,
  0xFF, 0xFE, 0x00, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_calendar_view_day() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_calendar_view_day_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_calendar_view_month 48x48, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_48_action_calendar_view_month_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71,
  0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9,
  0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71,
  0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0x80, 0xAC, 0x4F, 0x71, 0xC7, 0x1C, 0x71, 0xF9,
  0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71,
  0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7,
  0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1C, 0x71, 0xC0, 0xD8, 0x0C, 0x2F,
  0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_calendar_view_month() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_calendar_view_month_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_calendar_view_week 48x48, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_round_48_action_calendar_view_week_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5, 0xC5, 0xF9,
  0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5, 0xC5, 0xF9, 0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5,
  0xC5, 0xF9, 0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5, 0xC5, 0xF9, 0x5C, 0x5C, 0x5C, 0x5F, 0x95,
  0xC5, 0xC5, 0xC5, 0xF9, 0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5, 0xC5, 0xF9, 0x5C, 0x5C, 0x5C,
  0x5F, 0x95, 0xC5, 0xC5, 0xC5, 0xF9, 0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5, 0xC5, 0xF9, 0x5C,
  0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5, 0xC5, 0xF9, 0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5, 0xC5,
  0xF9, 0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5, 0xC5, 0xC5, 0xF9, 0x5C, 0x5C, 0x5C, 0x5F, 0x95, 0xC5,
  0xC5, 0xC5, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8,
  0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_calendar_view_week() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_calendar_view_week_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_camera_enhance 48x48, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_round_48_action_camera_enhance_data[] PROGMEM = {
  0x76, 0x04, 0x0B, 0xFB, 0x0B, 0x04, 0x77, 0x74, 0x05, 0xFF, 0x05, 0x77, 0x72, 0x04, 0xFF, 0xA0,
  0x47, 0x77, 0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x48, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1,
  0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C, 0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09,
  0xB4, 0xF8, 0x1A, 0x52, 0x28, 0x12, 0x5A, 0xFF, 0xFF, 0xA0, 0xA0, 0x27, 0x10, 0x20, 0xAF, 0xFF,
  0xE0, 0x75, 0x00, 0x35, 0x07, 0xFF, 0xFC, 0x07, 0x60, 0x0A, 0x60, 0x7F, 0xFF, 0xA0, 0xA6, 0x02,
  0xA0, 0x26, 0x0A, 0xFF, 0xF9, 0x02, 0x60, 0x9A, 0x09, 0x60, 0x2F, 0xFF, 0x0A, 0x60, 0x10, 0xEA,
  0x0E, 0x01, 0x60, 0xAF, 0xFE, 0x05, 0x50, 0x10, 0x9C, 0x09, 0x01, 0x50, 0x5F, 0xFE, 0x02, 0x38,
  0x12, 0x9E, 0xE8, 0x1E, 0x92, 0x30, 0x2F, 0xFE, 0x20, 0x30, 0xAF, 0xD0, 0xA0, 0x32, 0xFF, 0xE2,
  0x03, 0x0A, 0xFD, 0x0A, 0x03, 0x2F, 0xFE, 0x02, 0x38, 0x12, 0x9E, 0xE8, 0x1E, 0x92, 0x30, 0x2F,
  0xFE, 0x05, 0x50, 0x10, 0x9C, 0x09, 0x01, 0x50, 0x5F, 0xFE, 0x0A, 0x60, 0x10, 0xEA, 0x0E, 0x01,
  0x60, 0xAF, 0xFF, 0x02, 0x60, 0x9A, 0x09, 0x60, 0x2F, 0xFF, 0x90, 0xA6, 0x02, 0xA0, 0x26, 0x0A,
  0xFF, 0xFA, 0x07, 0x60, 0x0A, 0x60, 0x7F, 0xFF, 0xC0, 0x75, 0x00, 0x35, 0x07, 0xFF, 0xFE, 0x0A,
  0x02, 0x71, 0x02, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x52, 0x28, 0x12, 0x5A, 0x80, 0x9B, 0x4F, 0x0D,
  0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD,
  0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_camera_enhance() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_camera_enhance_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_cancel_schedule_send 48x48, 4-bit Alpha,  RLE, 382 bytes.
static const unsigned char ic_round_48_action_cancel_schedule_send_data[] PROGMEM = {
  0x83, 0x3D, 0xD7, 0x18, 0x0C, 0x50, 0x0D, 0xC0, 0xA0, 0x38, 0x0C, 0x30, 0xF0, 0xC0, 0x58, 0x0C,
  0x10, 0xFA, 0x81, 0xE7, 0x17, 0x77, 0x76, 0xFD, 0x0A, 0x03, 0x77, 0x77, 0x4F, 0xF0, 0xC0, 0x57,
  0x77, 0x72, 0xFF, 0xA8, 0x1E, 0x71, 0x77, 0x76, 0xFF, 0xD0, 0xA0, 0x37, 0x77, 0x4F, 0xFF, 0x0C,
  0x05, 0x77, 0x72, 0xFF, 0xFA, 0x81, 0xE7, 0x17, 0x76, 0xFF, 0xFD, 0x0A, 0x03, 0x77, 0x4F, 0xFF,
  0xF8, 0x6D, 0xDE, 0xED, 0xB8, 0x37, 0x30, 0x9F, 0xFF, 0xFF, 0x0E, 0x07, 0x72, 0x81, 0x48, 0xCF,
  0xFF, 0xFE, 0x0D, 0x05, 0x74, 0x82, 0x36, 0xAD, 0xFF, 0xFF, 0xB0, 0x77, 0x78, 0x21, 0x58, 0xCF,
  0xE8, 0x2E, 0x95, 0x22, 0x82, 0x25, 0x9E, 0xD0, 0xA7, 0x74, 0x82, 0x36, 0xAD, 0xF0, 0x80, 0x17,
  0x10, 0x10, 0x8D, 0x08, 0x77, 0x38, 0x23, 0x6A, 0xDD, 0x0D, 0x03, 0x75, 0x03, 0x0D, 0xC0, 0x57,
  0x48, 0x21, 0x58, 0xCF, 0xA0, 0xD0, 0x17, 0x70, 0x10, 0xDB, 0x0D, 0x78, 0x23, 0x6A, 0xDF, 0xE0,
  0x37, 0x72, 0x03, 0xC0, 0x72, 0x81, 0x48, 0xBF, 0xFB, 0x08, 0x77, 0x40, 0x8B, 0x81, 0xE0, 0x9F,
  0xFD, 0x0E, 0x01, 0x48, 0x11, 0x61, 0x48, 0x11, 0x61, 0x40, 0x10, 0xEB, 0x03, 0xFF, 0xE0, 0x95,
  0x82, 0x6F, 0xC1, 0x28, 0x21, 0xCF, 0x65, 0x09, 0xB0, 0x8F, 0xFE, 0x04, 0x58, 0x90, 0x1C, 0xFC,
  0x11, 0xCF, 0xC1, 0x50, 0x4B, 0x0B, 0xFF, 0xE0, 0x26, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x60, 0x2B,
  0x0D, 0xFF, 0xE7, 0x10, 0x10, 0xCA, 0x0C, 0x01, 0x71, 0xB0, 0xEF, 0xFE, 0x71, 0x01, 0x0C, 0xA0,
  0xC0, 0x17, 0x1B, 0x0E, 0xFF, 0xE0, 0x26, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x60, 0x2B, 0x0D, 0xFF,
  0x81, 0xC5, 0xBB, 0x04, 0x58, 0x90, 0x1C, 0xFC, 0x11, 0xCF, 0xC1, 0x50, 0x4B, 0x0B, 0xFD, 0x0A,
  0x03, 0x20, 0x7B, 0x09, 0x58, 0x26, 0xFC, 0x12, 0x82, 0x1C, 0xF6, 0x50, 0x9B, 0x08, 0xFA, 0x81,
  0xE7, 0x14, 0x04, 0xB0, 0xE0, 0x14, 0x81, 0x16, 0x14, 0x81, 0x16, 0x14, 0x01, 0x0E, 0xB0, 0x3F,
  0x0C, 0x05, 0x71, 0x0D, 0xB0, 0x87, 0x74, 0x08, 0xB8, 0x1E, 0x0D, 0xC0, 0xA0, 0x37, 0x30, 0x7C,
  0x03, 0x77, 0x20, 0x3C, 0x85, 0x70, 0x3C, 0xD7, 0x17, 0x60, 0xDB, 0x0D, 0x01, 0x77, 0x01, 0x0D,
  0xB0, 0xD7, 0x76, 0x04, 0xC0, 0xD0, 0x37, 0x50, 0x30, 0xDC, 0x05, 0x77, 0x70, 0x8D, 0x08, 0x01,
  0x71, 0x01, 0x08, 0xD0, 0x87, 0x77, 0x20, 0x9D, 0x82, 0xE9, 0x52, 0x28, 0x22, 0x59, 0xED, 0x0A,
  0x77, 0x74, 0x08, 0xFF, 0xC0, 0x77, 0x77, 0x60, 0x40, 0xEF, 0xF0, 0xD0, 0x57, 0x77, 0x72, 0x07,
  0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x77, 0x68, 0x90, 0x38, 0xBD, 0xEE, 0xDB, 0x83, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_cancel_schedule_send() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 47, 47), Box(0, 0, 47, 47),
      ic_round_48_action_cancel_schedule_send_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_card_giftcard 48x48, 4-bit Alpha,  RLE, 231 bytes.
static const unsigned char ic_round_48_action_card_giftcard_data[] PROGMEM = {
  0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x68, 0x46, 0xCE, 0xEC, 0x67, 0x76, 0x01, 0x0C, 0xE0, 0xC0, 0x12,
  0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x74, 0x0C, 0xF9, 0x0C, 0x20, 0xCF, 0x90, 0xC7, 0x73, 0x06, 0xFB,
  0x00, 0x9F, 0xB0, 0x67, 0x72, 0x0C, 0xB8, 0x2B, 0x11, 0xBF, 0x98, 0x2B, 0x11, 0xBB, 0x0C, 0x77,
  0x20, 0xEB, 0x01, 0x20, 0x1F, 0x90, 0x12, 0x01, 0xB0, 0xE7, 0x72, 0x0E, 0xB0, 0x12, 0x01, 0xF9,
  0x01, 0x20, 0x1B, 0x0E, 0x77, 0x20, 0xBB, 0x82, 0xB1, 0x1B, 0xF9, 0x82, 0xB1, 0x1B, 0xB0, 0xB7,
  0x28, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0xFF, 0xC0, 0x07, 0xFF, 0xC0, 0xDC, 0x0B, 0x01, 0x70, 0x3C, 0x0B, 0x20, 0xBC,
  0x03, 0x70, 0x10, 0xBF, 0x90, 0x17, 0x01, 0x0D, 0xB0, 0xE0, 0x12, 0x01, 0x0E, 0xB0, 0xD0, 0x17,
  0x01, 0xF9, 0x71, 0x0A, 0xC0, 0x44, 0x04, 0xC0, 0xA7, 0x1F, 0x97, 0x06, 0xC0, 0x86, 0x08, 0xC0,
  0x67, 0xF9, 0x70, 0xEB, 0x0C, 0x71, 0x0C, 0xB0, 0xE7, 0xF9, 0x60, 0x1B, 0x0E, 0x02, 0x71, 0x02,
  0x0E, 0xB0, 0x16, 0xF9, 0x70, 0x9A, 0x04, 0x73, 0x04, 0xA0, 0x97, 0xF9, 0x71, 0x00, 0x17, 0x50,
  0x01, 0x71, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0x80, 0xBE, 0x4F, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10,
  0x1A, 0xEF, 0xFF, 0xFC, 0x81, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_card_giftcard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_card_giftcard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_card_membership 48x48, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_round_48_action_card_membership_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x0B, 0x01, 0x77, 0x77, 0x01, 0x0B, 0xF9, 0x01, 0x77,
  0x77, 0x20, 0x1F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x48, 0x0B, 0xE4, 0xF7, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1,
  0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAE, 0xFF, 0xFF, 0xC8, 0x1E, 0xA1, 0x76, 0xFF, 0xA7, 0x77,
  0x3F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x77, 0x3F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x77, 0x3F, 0xFA,
  0x77, 0x73, 0xE8, 0x2B, 0x33, 0xBE, 0x77, 0x73, 0xC0, 0xB0, 0x34, 0x03, 0x0B, 0xC7, 0x77, 0x3A,
  0x0B, 0x03, 0x71, 0x03, 0x0B, 0xA7, 0x77, 0x30, 0xB0, 0x37, 0x50, 0x30, 0xB7, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_card_membership() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_card_membership_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_card_travel 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_round_48_action_card_travel_data[] PROGMEM = {
  0x74, 0x81, 0x1A, 0xEF, 0xD8, 0x1E, 0xA1, 0x77, 0x70, 0x10, 0xEF, 0xFA, 0x0E, 0x01, 0x77, 0x60,
  0xAF, 0xFC, 0x0A, 0x77, 0x60, 0xDF, 0xFC, 0x0D, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77,
  0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x74, 0x81, 0x1A, 0xEF, 0xFF, 0xFC, 0x84, 0xEA, 0x10, 0x1E,
  0x80, 0xC0, 0xF8, 0x1E, 0x1A, 0x80, 0xC2, 0xF0, 0xA0, 0xD8, 0x0C, 0x2F, 0x0D, 0xC0, 0xB0, 0x14,
  0xC7, 0x5C, 0x40, 0x10, 0xBF, 0x90, 0x15, 0xC7, 0x5C, 0x50, 0x1F, 0x96, 0x0D, 0xA0, 0xD7, 0x50,
  0xDA, 0x0D, 0x6F, 0x96, 0x82, 0x4D, 0xD4, 0x75, 0x82, 0x4D, 0xD4, 0x6F, 0x97, 0x77, 0x74, 0xF9,
  0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x48, 0x0B, 0xE4, 0xF7, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F,
  0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAE, 0xFF, 0xFF, 0xC8, 0x1E, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_card_travel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_card_travel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_change_history 48x48, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_round_48_action_change_history_data[] PROGMEM = {
  0x77, 0x40, 0x01, 0x77, 0x77, 0x70, 0x7A, 0x07, 0x77, 0x77, 0x50, 0x3C, 0x03, 0x77, 0x77, 0x40,
  0xCC, 0x0C, 0x77, 0x77, 0x30, 0x6E, 0x06, 0x77, 0x77, 0x10, 0x10, 0xEE, 0x0E, 0x01, 0x77, 0x77,
  0x0A, 0xB0, 0x0E, 0xB0, 0xA7, 0x77, 0x60, 0x4C, 0x00, 0x6C, 0x04, 0x77, 0x75, 0x0D, 0xB0, 0xB2,
  0x0B, 0xB0, 0xD7, 0x77, 0x40, 0x8C, 0x02, 0x20, 0x2C, 0x08, 0x77, 0x72, 0x03, 0xC0, 0x84, 0x08,
  0xC0, 0x37, 0x77, 0x10, 0xCB, 0x0D, 0x60, 0xDB, 0x0C, 0x77, 0x70, 0x6C, 0x04, 0x60, 0x4C, 0x06,
  0x77, 0x50, 0x10, 0xEB, 0x0A, 0x71, 0x0A, 0xB0, 0xE0, 0x17, 0x74, 0x0A, 0xB0, 0xE0, 0x17, 0x10,
  0x10, 0xEB, 0x0A, 0x77, 0x30, 0x4C, 0x06, 0x73, 0x06, 0xC0, 0x47, 0x72, 0x0D, 0xB0, 0xB7, 0x50,
  0xBB, 0x0D, 0x77, 0x10, 0x8C, 0x02, 0x75, 0x02, 0xC0, 0x87, 0x60, 0x3C, 0x08, 0x77, 0x08, 0xC0,
  0x37, 0x50, 0xCB, 0x0D, 0x77, 0x20, 0xDB, 0x0C, 0x74, 0x06, 0xC0, 0x47, 0x72, 0x04, 0xC0, 0x67,
  0x20, 0x10, 0xEB, 0x0A, 0x77, 0x40, 0xAB, 0x0E, 0x01, 0x71, 0x0A, 0xB0, 0xE0, 0x17, 0x74, 0x01,
  0x0E, 0xB0, 0xA7, 0x05, 0xC0, 0x67, 0x76, 0x06, 0xC0, 0x56, 0x0D, 0xB0, 0xB7, 0x77, 0x10, 0xBB,
  0x0D, 0x50, 0x8C, 0x02, 0x77, 0x71, 0x02, 0xC0, 0x83, 0x03, 0xC0, 0x87, 0x77, 0x30, 0x8C, 0x03,
  0x20, 0xCF, 0xFF, 0xFE, 0x81, 0xC0, 0x48, 0x0C, 0x0F, 0x00, 0x48, 0x0C, 0x0F, 0x82, 0x40, 0x8E,
  0xFF, 0xFF, 0xC0, 0xE0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_change_history() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 9, 42, 39), Box(0, 0, 47, 47),
      ic_round_48_action_change_history_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_check_circle_outline 48x48, 4-bit Alpha,  RLE, 378 bytes.
static const unsigned char ic_round_48_action_check_circle_outline_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x93,
  0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x77, 0x78, 0x23, 0xCE, 0x63, 0x0E,
  0xB0, 0x82, 0x0D, 0xB0, 0x67, 0x76, 0x03, 0x0E, 0xB0, 0x12, 0x06, 0xB8, 0x1D, 0x03, 0xC7, 0x76,
  0x03, 0x0E, 0xC0, 0x13, 0xC0, 0x30, 0x7B, 0x0B, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x40, 0xBB, 0x07,
  0x0A, 0xB0, 0x67, 0x74, 0x03, 0x0E, 0xC0, 0x75, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x77, 0x30, 0x30,
  0xEC, 0x07, 0x60, 0x3B, 0x0C, 0x0E, 0xB0, 0x27, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x02, 0xB0, 0xEC,
  0x77, 0x20, 0x30, 0xEC, 0x07, 0x72, 0xF9, 0x58, 0x26, 0xEC, 0x36, 0x03, 0x0E, 0xC0, 0x77, 0x3C,
  0x0E, 0xB0, 0x23, 0x01, 0xB0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x77, 0x30, 0x2B, 0x0E, 0x0C, 0xB0,
  0x33, 0x01, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x3B, 0x0C, 0x0A, 0xB0, 0x64, 0x07,
  0xC8, 0x2E, 0x33, 0xEC, 0x07, 0x75, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x50, 0x7C, 0x00, 0xEC, 0x07,
  0x76, 0x0B, 0xB0, 0x70, 0x3C, 0x60, 0x7F, 0x90, 0x77, 0x7C, 0x81, 0x30, 0xDB, 0x06, 0x60, 0x7E,
  0x07, 0x77, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xE7, 0x07, 0xC0, 0x77, 0x71, 0x0E, 0xB0, 0x82, 0x01,
  0xC0, 0x77, 0x07, 0xA0, 0x77, 0x71, 0x07, 0xC0, 0x13, 0x09, 0xC0, 0x37, 0x00, 0x17, 0x71, 0x03,
  0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C,
  0x01, 0x77, 0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC, 0x09, 0x72,
  0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0E, 0x06, 0x75, 0x06, 0x0E, 0xD0, 0xA7,
  0x60, 0x9F, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E,
  0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17,
  0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_check_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_check_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_check_circle 48x48, 4-bit Alpha,  RLE, 286 bytes.
static const unsigned char ic_round_48_action_check_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFD, 0x82, 0xC2, 0x19, 0xC0, 0x93, 0x01, 0xFF, 0xFD, 0x0C, 0x40, 0xEC, 0x01, 0x20,
  0x8F, 0xFF, 0xC0, 0xC5, 0x0E, 0xC0, 0x82, 0x0D, 0xFF, 0xFB, 0x0C, 0x50, 0x8D, 0x81, 0xD0, 0x3F,
  0xFF, 0xB0, 0xC5, 0x08, 0xF0, 0x30, 0x7F, 0xFF, 0xA0, 0xC5, 0x08, 0xF9, 0x07, 0x0A, 0xFF, 0xF9,
  0x0C, 0x50, 0x8F, 0xA0, 0xA0, 0xCF, 0xFF, 0x0C, 0x50, 0x8F, 0xB0, 0xC0, 0xEE, 0x82, 0x80, 0x2C,
  0xFB, 0x0C, 0x50, 0x8F, 0xC0, 0xEE, 0x0E, 0x30, 0x10, 0xCF, 0x90, 0xC5, 0x08, 0xFF, 0xD0, 0xE4,
  0x01, 0x0C, 0xE0, 0xC5, 0x08, 0xFF, 0x0E, 0xE0, 0x85, 0x0C, 0xC0, 0xC5, 0x08, 0xFF, 0x0E, 0x0C,
  0xF0, 0x75, 0x0C, 0xA0, 0xC5, 0x08, 0xFF, 0x90, 0xC0, 0xAF, 0x90, 0x75, 0x00, 0xC5, 0x08, 0xFF,
  0xA0, 0xA0, 0x7F, 0xA0, 0x77, 0x30, 0x8F, 0xFB, 0x07, 0x03, 0xFB, 0x07, 0x71, 0x08, 0xFF, 0xC8,
  0x13, 0x0D, 0xFB, 0x07, 0x60, 0x8F, 0xFC, 0x0D, 0x20, 0x8F, 0xC0, 0x74, 0x08, 0xFF, 0xD0, 0x82,
  0x01, 0xFD, 0x08, 0x20, 0x8F, 0xFE, 0x01, 0x30, 0x9F, 0xD0, 0x0E, 0xFF, 0xE0, 0x94, 0x01, 0x0E,
  0xFF, 0xFF, 0xC0, 0xE0, 0x15, 0x05, 0xFF, 0xFF, 0xC0, 0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20,
  0xAF, 0xFF, 0xF0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05,
  0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF,
  0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_check_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_check_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_chrome_reader_mode 48x48, 4-bit Alpha,  RLE, 165 bytes.
static const unsigned char ic_round_48_action_chrome_reader_mode_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDF, 0xFF, 0x97, 0x72, 0x01, 0x0B, 0xFF, 0xFD, 0x77, 0x30,
  0x1F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF,
  0xD7, 0x74, 0xFF, 0xFD, 0x20, 0x8F, 0xD0, 0x82, 0xFF, 0xFD, 0x20, 0xEF, 0xD0, 0xE2, 0xFF, 0xFD,
  0x20, 0x8F, 0xD0, 0x82, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x20, 0x8F, 0xD0,
  0x82, 0xFF, 0xFD, 0x20, 0xEF, 0xD0, 0xE2, 0xFF, 0xFD, 0x20, 0x8F, 0xD0, 0x82, 0xFF, 0xFD, 0x77,
  0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x20, 0x8F, 0xD0, 0x82, 0xFF, 0xFD, 0x20, 0xEF, 0xD0, 0xE2,
  0xFF, 0xFD, 0x20, 0x8F, 0xD0, 0x82, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77,
  0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x30, 0x1F, 0xFF, 0xD7, 0x72, 0x01, 0x0B, 0xC0, 0xD8,
  0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8,
  0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_chrome_reader_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_chrome_reader_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_circle_notifications 48x48, 4-bit Alpha,  RLE, 271 bytes.
static const unsigned char ic_round_48_action_circle_notifications_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFE, 0x82, 0xB1, 0x1B, 0xFE, 0x09, 0x70, 0x5F, 0xF0, 0x12, 0x01, 0xFF, 0x05, 0x50, 0x10, 0xEF,
  0xF4, 0xFF, 0x0E, 0x01, 0x40, 0x9F, 0xE0, 0xD0, 0x74, 0x07, 0x0D, 0xFE, 0x09, 0x30, 0x1F, 0xE0,
  0x67, 0x10, 0x6F, 0xE0, 0x12, 0x08, 0xFD, 0x04, 0x73, 0x04, 0xFD, 0x08, 0x20, 0xDF, 0xC0, 0x67,
  0x50, 0x6F, 0xC8, 0x1D, 0x03, 0xFC, 0x0C, 0x77, 0x0C, 0xFC, 0x03, 0x07, 0xFC, 0x06, 0x77, 0x06,
  0xFC, 0x07, 0x0A, 0xFC, 0x02, 0x77, 0x02, 0xFC, 0x0A, 0x0C, 0xFC, 0x77, 0x2F, 0xC0, 0xC0, 0xEF,
  0xC7, 0x72, 0xFC, 0x0E, 0xFD, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFD, 0x0E, 0xFC, 0x77, 0x2F, 0xC0,
  0xE0, 0xCF, 0xC7, 0x72, 0xFC, 0x0C, 0x0A, 0xFC, 0x77, 0x2F, 0xC0, 0xA0, 0x7F, 0xA0, 0xB0, 0x17,
  0x72, 0x01, 0x0B, 0xFA, 0x07, 0x03, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xA8, 0x13, 0x0D, 0xF9, 0x01,
  0x77, 0x40, 0x1F, 0x90, 0xD2, 0x08, 0xF9, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBF, 0x90, 0x82, 0x01,
  0x80, 0xC0, 0xF0, 0x13, 0x09, 0xFF, 0xFF, 0xE0, 0x94, 0x01, 0x0E, 0xFE, 0x01, 0x40, 0x1F, 0xE0,
  0xE0, 0x15, 0x05, 0xFE, 0x07, 0x40, 0x7F, 0xE0, 0x57, 0x09, 0xFE, 0x82, 0x71, 0x17, 0xFE, 0x09,
  0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77,
  0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11,
  0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_circle_notifications() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_circle_notifications_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_class 48x48, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_48_action_class_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0x81, 0xE1, 0xAF, 0xFF, 0xFA,
  0x0A, 0x0D, 0xFF, 0xFF, 0xA0, 0xDC, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73,
  0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF,
  0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x73, 0xFF, 0xF9, 0x38, 0x22, 0xAA,
  0x23, 0xFF, 0xF9, 0x20, 0x7C, 0x07, 0x2F, 0xFF, 0x90, 0x40, 0xDE, 0x0D, 0x04, 0x80, 0x98, 0x96,
  0xF0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_class() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_class_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_close_fullscreen 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_48_action_close_fullscreen_data[] PROGMEM = {
  0x80, 0xC1, 0x00, 0x18, 0x0C, 0x10, 0x82, 0x5E, 0xF9, 0x77, 0x77, 0x70, 0x5C, 0x01, 0x77, 0x77,
  0x50, 0x5C, 0x0E, 0x77, 0x77, 0x50, 0x5D, 0x05, 0x77, 0x77, 0x40, 0x5D, 0x05, 0x77, 0x73, 0x01,
  0x70, 0x5D, 0x05, 0x77, 0x72, 0x06, 0xA0, 0x75, 0x05, 0xD0, 0x57, 0x77, 0x30, 0xDB, 0x08, 0x30,
  0x5D, 0x05, 0x77, 0x74, 0xD8, 0x18, 0x05, 0xD0, 0x57, 0x77, 0x5E, 0x0A, 0xD0, 0x57, 0x77, 0x6F,
  0xC0, 0x57, 0x77, 0x7F, 0xB0, 0x57, 0x77, 0x71, 0xFA, 0x0A, 0x77, 0x77, 0x2F, 0xB0, 0x77, 0x77,
  0x71, 0xFC, 0x07, 0x77, 0x77, 0xFD, 0x06, 0x77, 0x76, 0xFD, 0x0E, 0x77, 0x76, 0x0D, 0xFD, 0x77,
  0x76, 0x04, 0x0E, 0xFA, 0x0E, 0x06, 0x77, 0x06, 0x0D, 0xFA, 0x0D, 0x04, 0x77, 0x76, 0xFD, 0x0E,
  0x77, 0x75, 0x01, 0xFE, 0x77, 0x76, 0x07, 0xFD, 0x77, 0x77, 0x08, 0xFC, 0x77, 0x77, 0x10, 0x8F,
  0xB7, 0x77, 0x72, 0x0A, 0xFA, 0x77, 0x77, 0x10, 0x5F, 0xB7, 0x77, 0x70, 0x5F, 0xC7, 0x77, 0x60,
  0x5D, 0x0A, 0xE7, 0x77, 0x50, 0x5D, 0x81, 0x50, 0x7D, 0x77, 0x74, 0x05, 0xD0, 0x53, 0x07, 0xB0,
  0xE7, 0x77, 0x30, 0x5D, 0x05, 0x58, 0x26, 0xEF, 0x67, 0x77, 0x20, 0x5D, 0x05, 0x77, 0x77, 0x40,
  0x5D, 0x05, 0x77, 0x77, 0x40, 0x5D, 0x05, 0x77, 0x77, 0x50, 0xEC, 0x05, 0x77, 0x77, 0x50, 0x1C,
  0x05, 0x77, 0x77, 0x78, 0x29, 0xFE, 0x58, 0x0C, 0x10, 0x01, 0x80, 0xC1, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_close_fullscreen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_close_fullscreen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_code_off 48x48, 4-bit Alpha,  RLE, 332 bytes.
static const unsigned char ic_round_48_action_code_off_data[] PROGMEM = {
  0x18, 0x12, 0x74, 0x80, 0xC1, 0x00, 0x10, 0xEA, 0x07, 0x80, 0xC0, 0x00, 0x5C, 0x07, 0x77, 0x77,
  0x70, 0x10, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07,
  0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x40, 0x01, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x20,
  0x6A, 0x07, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x10, 0xEB, 0x07, 0x77, 0x10, 0x30, 0xEC, 0x07,
  0x77, 0x0C, 0xC0, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x07, 0xE0,
  0x77, 0x60, 0x30, 0xEC, 0x07, 0x75, 0x07, 0xF9, 0x07, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x30, 0x7C,
  0x00, 0xEC, 0x07, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x10, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x77, 0x60,
  0x30, 0xEC, 0x07, 0x60, 0x7C, 0x0E, 0x03, 0x20, 0x30, 0xEC, 0x07, 0x76, 0x03, 0x0E, 0xC0, 0x74,
  0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x20, 0x1C, 0x0E, 0x03,
  0x60, 0x30, 0xEC, 0x07, 0x76, 0x03, 0x0E, 0xC8, 0x11, 0x01, 0xC0, 0xE0, 0x37, 0x03, 0x0E, 0xC0,
  0x77, 0x50, 0x30, 0xEC, 0x01, 0x20, 0x7C, 0x0E, 0x03, 0x70, 0x30, 0xEC, 0x07, 0x73, 0x03, 0x0E,
  0xC0, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x03, 0x0E, 0xC0, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x60, 0x7C,
  0x0E, 0x03, 0x70, 0x30, 0xEC, 0x07, 0x60, 0x30, 0xEC, 0x07, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x03,
  0x0E, 0xC0, 0x75, 0x0B, 0xC0, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0x70, 0x30, 0xEC, 0x07, 0x50, 0xCA,
  0x07, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x03, 0x0E, 0xC0, 0x74, 0x81, 0x1C, 0x77, 0x70, 0x7C, 0x0E,
  0x03, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x70, 0x7C, 0x0C, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x07,
  0xB0, 0xE7, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x70, 0x7A, 0x06, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x77,
  0x00, 0x17, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30,
  0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x77,
  0x70, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x04, 0x77, 0x77, 0x70, 0x30, 0xEB, 0x07,
  0x80, 0xC0, 0x08, 0x33, 0xEF, 0xE2, 0x80, 0xC1, 0x08, 0x11, 0x51, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_code_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 43, 44), Box(0, 0, 47, 47),
      ic_round_48_action_code_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_code 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_48_action_code_data[] PROGMEM = {
  0x74, 0x00, 0x17, 0x70, 0x01, 0x77, 0x70, 0x7A, 0x06, 0x75, 0x06, 0xA0, 0x77, 0x75, 0x07, 0xB0,
  0xE7, 0x50, 0xEB, 0x07, 0x77, 0x30, 0x7C, 0x0C, 0x75, 0x0C, 0xC0, 0x77, 0x71, 0x07, 0xC0, 0xE0,
  0x27, 0x50, 0x20, 0xEC, 0x07, 0x76, 0x07, 0xC0, 0xE0, 0x27, 0x70, 0x20, 0xEC, 0x07, 0x74, 0x07,
  0xC0, 0xE0, 0x27, 0x72, 0x02, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x0E, 0x02, 0x77, 0x40, 0x20, 0xEC,
  0x07, 0x70, 0x7C, 0x0E, 0x02, 0x77, 0x60, 0x20, 0xEC, 0x07, 0x50, 0x7C, 0x0E, 0x02, 0x77, 0x71,
  0x02, 0x0E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0x20, 0xEC, 0x81, 0x70, 0x1C, 0x0E,
  0x02, 0x77, 0x75, 0x02, 0x0E, 0xC0, 0x01, 0xC0, 0xE0, 0x27, 0x77, 0x50, 0x20, 0xEC, 0x81, 0x10,
  0x7C, 0x0E, 0x02, 0x77, 0x73, 0x02, 0x0E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x27, 0x77, 0x10, 0x20,
  0xEC, 0x07, 0x50, 0x7C, 0x0E, 0x02, 0x77, 0x60, 0x20, 0xEC, 0x07, 0x70, 0x7C, 0x0E, 0x02, 0x77,
  0x40, 0x20, 0xEC, 0x07, 0x72, 0x07, 0xC0, 0xE0, 0x27, 0x72, 0x02, 0x0E, 0xC0, 0x77, 0x40, 0x7C,
  0x0E, 0x02, 0x77, 0x02, 0x0E, 0xC0, 0x77, 0x60, 0x7C, 0x0E, 0x02, 0x75, 0x02, 0x0E, 0xC0, 0x77,
  0x71, 0x07, 0xC0, 0xC7, 0x50, 0xCC, 0x07, 0x77, 0x30, 0x7B, 0x0E, 0x75, 0x0E, 0xB0, 0x77, 0x75,
  0x07, 0xA0, 0x67, 0x50, 0x6A, 0x07, 0x77, 0x70, 0x01, 0x77, 0x00, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 43, 35), Box(0, 0, 47, 47),
      ic_round_48_action_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_comment_bank 48x48, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_round_48_action_comment_bank_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDF, 0xFF, 0xB7, 0x3F, 0xFF, 0xFA, 0x73, 0xFF, 0xFF, 0xA7,
  0x3F, 0xFF, 0xFA, 0x73, 0xFF, 0xFF, 0xA7, 0x3F, 0xFF, 0xFA, 0x73, 0xFF, 0xFF, 0xA7, 0x3F, 0xFF,
  0xFA, 0x73, 0xFF, 0xFF, 0xA7, 0x3F, 0xFF, 0xFA, 0x73, 0xFF, 0xFF, 0xA7, 0x3F, 0xFF, 0xFA, 0x73,
  0xFF, 0xFF, 0xA7, 0x3F, 0xFF, 0xFA, 0x38, 0x22, 0xAA, 0x23, 0xFF, 0xFF, 0xA8, 0x21, 0x07, 0xEA,
  0x82, 0xE7, 0x01, 0xFF, 0xFF, 0xA0, 0xE0, 0xDE, 0x00, 0xD8, 0x0D, 0xD1, 0xF0, 0xD8, 0x0C, 0x3F,
  0x0A, 0x80, 0xC2, 0xF0, 0xE0, 0x18, 0x0C, 0x0F, 0x81, 0xDA, 0x11, 0xF0, 0x77, 0x77, 0x74, 0xE0,
  0x77, 0x77, 0x75, 0xD0, 0x77, 0x77, 0x76, 0x0D, 0xB0, 0x77, 0x77, 0x77, 0x06, 0xA0, 0x78, 0x0C,
  0x20, 0x01, 0x80, 0xC1, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_comment_bank() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_comment_bank_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_commit 48x48, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_round_48_action_commit_data[] PROGMEM = {
  0x77, 0x28, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x77, 0x72, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x76,
  0x08, 0xFD, 0x08, 0x77, 0x74, 0x08, 0xFF, 0x08, 0x77, 0x72, 0x05, 0xD0, 0x80, 0x32, 0x03, 0x08,
  0xD0, 0x57, 0x77, 0x10, 0xDB, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x0D, 0x77, 0x70, 0x5C, 0x02, 0x71,
  0x02, 0xC0, 0x57, 0x76, 0x0A, 0xB0, 0x87, 0x30, 0x8B, 0x0A, 0x73, 0x04, 0x0D, 0xFD, 0x03, 0x73,
  0x03, 0xFD, 0x81, 0xD4, 0xDF, 0xE7, 0x5F, 0xE0, 0x0D, 0xFE, 0x75, 0xFE, 0x81, 0xD4, 0xDF, 0xD0,
  0x37, 0x30, 0x3F, 0xD0, 0xD0, 0x47, 0x30, 0xAB, 0x08, 0x73, 0x08, 0xB0, 0xA7, 0x76, 0x05, 0xC0,
  0x27, 0x10, 0x2C, 0x05, 0x77, 0x70, 0xDB, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x0D, 0x77, 0x71, 0x05,
  0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x57, 0x77, 0x20, 0x8F, 0xF0, 0x87, 0x77, 0x40, 0x8F, 0xD0,
  0x87, 0x77, 0x60, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x72, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_commit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 14, 43, 33), Box(0, 0, 47, 47),
      ic_round_48_action_commit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_commute 48x48, 4-bit Alpha,  RLE, 231 bytes.
static const unsigned char ic_round_48_action_commute_data[] PROGMEM = {
  0x38, 0x16, 0xCE, 0xFF, 0x81, 0xEC, 0x67, 0x74, 0x01, 0x0C, 0xFF, 0xE0, 0xC0, 0x17, 0x72, 0x0C,
  0xFF, 0xF9, 0x0C, 0x77, 0x10, 0x6F, 0xFF, 0xB0, 0x67, 0x70, 0xCB, 0x03, 0x77, 0x20, 0x3B, 0x0C,
  0x77, 0x0E, 0xB7, 0x74, 0xB0, 0xE7, 0x7C, 0x77, 0x4C, 0x77, 0xC7, 0x74, 0xC7, 0x7C, 0x80, 0xC0,
  0x0C, 0x80, 0xC0, 0x0C, 0x77, 0x10, 0x70, 0xEF, 0xF0, 0xE0, 0x73, 0xC7, 0x70, 0x3F, 0xFC, 0x03,
  0x2C, 0x77, 0x81, 0x8F, 0xB7, 0x78, 0x1B, 0xF8, 0x2C, 0x77, 0x81, 0xDF, 0x57, 0x78, 0x14, 0xFD,
  0x2C, 0x76, 0x81, 0x3F, 0xE7, 0x72, 0x81, 0xEF, 0x31, 0xC7, 0x68, 0x19, 0xFA, 0x77, 0x28, 0x19,
  0xF9, 0x1C, 0x76, 0x81, 0xEF, 0x47, 0x72, 0x81, 0x3F, 0xE1, 0xC0, 0x37, 0x40, 0x4A, 0x06, 0x77,
  0x20, 0x5A, 0x04, 0xFF, 0x20, 0x9F, 0xFF, 0x90, 0x9F, 0xF2, 0x0E, 0xFF, 0xF9, 0x0E, 0xC8, 0x2B,
  0x11, 0xBE, 0x2A, 0x82, 0xB1, 0x1B, 0xFD, 0x82, 0xB1, 0x1B, 0xE0, 0x12, 0x01, 0xE2, 0xA0, 0x12,
  0x01, 0xFD, 0x01, 0x20, 0x1A, 0x0E, 0xB0, 0x12, 0x01, 0xE2, 0xA0, 0x12, 0x01, 0xFD, 0x01, 0x20,
  0x1A, 0x0C, 0xB8, 0x2B, 0x11, 0xBE, 0x2A, 0x82, 0xB1, 0x1B, 0xFD, 0x82, 0xB1, 0x1B, 0xA0, 0x6F,
  0xE2, 0xFF, 0xFB, 0x10, 0xCF, 0xD2, 0xFF, 0xFB, 0x10, 0x10, 0xCF, 0xC2, 0xFF, 0xFB, 0x38, 0x16,
  0xCE, 0xF9, 0x2F, 0xFF, 0xB5, 0x07, 0xB0, 0x76, 0xC7, 0x72, 0xC4, 0x07, 0xB0, 0x77, 0xC7, 0x72,
  0xC4, 0x0E, 0xA0, 0x77, 0x10, 0xDA, 0x0E, 0x77, 0x20, 0xDA, 0x0E, 0x48, 0x17, 0xD7, 0x72, 0x82,
  0x4D, 0xD4, 0x77, 0x28, 0x24, 0xDD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_commute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_commute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_compare_arrows 48x48, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_round_48_action_compare_arrows_data[] PROGMEM = {
  0x77, 0x73, 0x00, 0x58, 0x0C, 0x10, 0x81, 0x7F, 0xE8, 0x0C, 0x00, 0x07, 0xB7, 0x77, 0x77, 0x07,
  0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xFF, 0xC0, 0xD0, 0x47, 0x74, 0x05, 0xFF, 0xE0,
  0xD7, 0x74, 0x05, 0xFF, 0xE0, 0xD7, 0x75, 0x07, 0xFF, 0xC0, 0xD0, 0x47, 0x76, 0x07, 0xD7, 0x77,
  0x77, 0x07, 0xC8, 0x0C, 0x00, 0x07, 0xB7, 0x77, 0x70, 0x50, 0x67, 0x81, 0x8F, 0xE7, 0x77, 0x78,
  0x1E, 0xF8, 0x70, 0x05, 0x77, 0x77, 0xB0, 0x78, 0x0C, 0x00, 0xC0, 0x77, 0x77, 0x77, 0xD0, 0x77,
  0x76, 0x04, 0x0D, 0xFF, 0xC0, 0x77, 0x75, 0x0D, 0xFF, 0xE0, 0x57, 0x74, 0x0D, 0xFF, 0xE0, 0x57,
  0x74, 0x04, 0x0D, 0xFF, 0xC0, 0x77, 0x77, 0x75, 0xD0, 0x77, 0x77, 0x76, 0xC0, 0x77, 0x77, 0x77,
  0xB0, 0x78, 0x0C, 0x00, 0x81, 0xEF, 0x78, 0x0C, 0x10, 0x00, 0x57, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_compare_arrows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 11, 43, 36), Box(0, 0, 47, 47),
      ic_round_48_action_compare_arrows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_compress 48x48, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_round_48_action_compress_data[] PROGMEM = {
  0x77, 0x82, 0x4D, 0xD4, 0x77, 0x77, 0x0D, 0xA0, 0xD7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C,
  0x77, 0x77, 0xC7, 0x77, 0x20, 0x5F, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x05, 0x77, 0x50, 0x7F, 0xB0,
  0x77, 0x77, 0x07, 0xF9, 0x07, 0x77, 0x72, 0x07, 0xE0, 0x77, 0x77, 0x40, 0x7C, 0x07, 0x77, 0x76,
  0x07, 0xA0, 0x77, 0x77, 0x71, 0x00, 0x58, 0x09, 0x93, 0x00, 0x40, 0xDF, 0xFF, 0xF8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xA0, 0x0D, 0xFF, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xFF, 0x0D, 0x04, 0x80, 0xF4, 0x00,
  0x40, 0xDF, 0xFF, 0xF8, 0x1D, 0x4D, 0xFF, 0xFF, 0xA0, 0x0D, 0xFF, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF,
  0xFF, 0x0D, 0x04, 0x80, 0x99, 0x30, 0x00, 0x57, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x60, 0x7C,
  0x07, 0x77, 0x74, 0x07, 0xE0, 0x77, 0x77, 0x20, 0x7F, 0x90, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x77,
  0x50, 0x5F, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x05, 0x77, 0x72, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7,
  0x77, 0x7C, 0x77, 0x77, 0x0D, 0xA0, 0xD7, 0x77, 0x78, 0x24, 0xDD, 0x47, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_compress() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_compress_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_contactless 48x48, 4-bit Alpha,  RLE, 329 bytes.
static const unsigned char ic_round_48_action_contactless_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xE0, 0xEF, 0xC0, 0xE0,
  0x14, 0x09, 0xFF, 0xE8, 0x17, 0x03, 0xFC, 0x09, 0x30, 0x1F, 0xFF, 0x02, 0x20, 0xBF, 0xC0, 0x12,
  0x08, 0xFF, 0x90, 0xD0, 0xAC, 0x06, 0x20, 0x5F, 0xC0, 0x82, 0x0D, 0xFF, 0x82, 0xE1, 0x05, 0xB0,
  0xC3, 0xFC, 0x81, 0xD0, 0x3F, 0xF9, 0x0E, 0x3C, 0x02, 0x20, 0xBF, 0xC0, 0x30, 0x7F, 0xB0, 0xD0,
  0xCC, 0x02, 0x20, 0xBB, 0x06, 0x20, 0x7F, 0xC0, 0x70, 0xAF, 0xA0, 0xC2, 0x09, 0xB0, 0x72, 0x06,
  0xB0, 0x92, 0x05, 0xFC, 0x0A, 0x0C, 0xFA, 0x0A, 0x20, 0x4B, 0x0B, 0x20, 0x4B, 0x0C, 0x20, 0x2F,
  0xC0, 0xC0, 0xEF, 0xA0, 0xC2, 0x01, 0xB0, 0xC2, 0x02, 0xB0, 0xE2, 0x01, 0xFC, 0x0E, 0xFB, 0x0E,
  0x3B, 0x0E, 0x20, 0x1C, 0x3F, 0xFF, 0x90, 0xE3, 0xC3, 0xC3, 0xFD, 0x0E, 0xFA, 0x0C, 0x20, 0x1B,
  0x0D, 0x3B, 0x0E, 0x20, 0x1F, 0xC0, 0xE0, 0xCF, 0xA0, 0xA2, 0x04, 0xB0, 0xC2, 0x02, 0xB0, 0xC2,
  0x02, 0xFC, 0x0C, 0x0A, 0xFA, 0x0B, 0x20, 0x9B, 0x09, 0x20, 0x4B, 0x09, 0x20, 0x5F, 0xC0, 0xA0,
  0x7F, 0xB0, 0xC0, 0xBC, 0x04, 0x20, 0x8B, 0x06, 0x20, 0x7F, 0xC0, 0x70, 0x3F, 0xFA, 0x30, 0xDB,
  0x02, 0x20, 0xBF, 0xC8, 0x13, 0x0D, 0xFF, 0x98, 0x11, 0x03, 0xB0, 0xC3, 0xFC, 0x0D, 0x20, 0x8F,
  0xF9, 0x81, 0xD9, 0xEB, 0x06, 0x20, 0x5F, 0xC0, 0x82, 0x01, 0xFF, 0xF0, 0x22, 0x0B, 0xFC, 0x01,
  0x30, 0x9F, 0xFE, 0x81, 0x70, 0x3F, 0xC0, 0x94, 0x01, 0x0E, 0xFF, 0xE0, 0xEF, 0xC0, 0xE0, 0x15,
  0x05, 0xFF, 0xFF, 0xC0, 0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40,
  0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57,
  0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74,
  0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_contactless() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_contactless_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_contact_page 48x48, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_round_48_action_contact_page_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x0A, 0xFF, 0xF0,
  0x77, 0x20, 0xDF, 0xFF, 0x90, 0x77, 0x1F, 0xFF, 0xB0, 0x77, 0xFF, 0xFC, 0x07, 0x6F, 0xFF, 0xD0,
  0x75, 0xFF, 0xFE, 0x07, 0x4F, 0xFF, 0xF0, 0x73, 0xFF, 0xFF, 0x90, 0x72, 0xFF, 0xFF, 0xA0, 0x71,
  0xFF, 0xFF, 0xB0, 0x4F, 0xFF, 0xFB, 0x0B, 0xFF, 0xFF, 0xB0, 0xE8, 0x09, 0x91, 0xF8, 0x4D, 0x51,
  0x15, 0xDF, 0xFF, 0xC0, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xFB, 0x05, 0x60, 0x5F, 0xFF, 0xB0, 0x16,
  0x01, 0xFF, 0xFB, 0x01, 0x60, 0x1F, 0xFF, 0xB0, 0x56, 0x05, 0xFF, 0xFB, 0x0D, 0x01, 0x40, 0x10,
  0xDF, 0xFF, 0xC8, 0x4D, 0x51, 0x15, 0xD8, 0x09, 0xA4, 0xF8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C,
  0xFF, 0xE0, 0xB0, 0x27, 0x30, 0x20, 0xBF, 0xFB, 0x0C, 0x77, 0x0C, 0xFF, 0xA0, 0x47, 0x70, 0x4F,
  0xFA, 0x77, 0x2F, 0xFA, 0x77, 0x28, 0x0A, 0x84, 0xF0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF,
  0xA8, 0x1A, 0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_contact_page() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_contact_page_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_contact_support 48x48, 4-bit Alpha,  RLE, 262 bytes.
static const unsigned char ic_round_48_action_contact_support_data[] PROGMEM = {
  0x75, 0x89, 0x05, 0x9B, 0xDE, 0xED, 0xB9, 0x57, 0x77, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x77,
  0x20, 0x10, 0x9F, 0xFA, 0x09, 0x01, 0x76, 0x04, 0x0E, 0xFF, 0xC0, 0xE0, 0x47, 0x40, 0x6F, 0x81,
  0xC6, 0x22, 0x81, 0x26, 0xCF, 0x06, 0x72, 0x06, 0xF0, 0x67, 0x10, 0x6F, 0x06, 0x70, 0x4F, 0x03,
  0x73, 0x04, 0xF0, 0x45, 0x01, 0x0E, 0xE0, 0x67, 0x50, 0x7E, 0x0E, 0x01, 0x40, 0x9E, 0x0C, 0x48,
  0x41, 0x9D, 0xD9, 0x14, 0x0D, 0xE0, 0x93, 0x02, 0xF0, 0x63, 0x01, 0x0D, 0xC0, 0xD0, 0x13, 0x07,
  0xF0, 0x22, 0x0A, 0xF0, 0x53, 0x09, 0xE0, 0x93, 0x03, 0xF0, 0xA2, 0x0E, 0xF8, 0x2C, 0x20, 0x6F,
  0x0D, 0x30, 0x1F, 0x81, 0xE0, 0x4F, 0xFD, 0x0E, 0x30, 0x1F, 0x90, 0x40, 0x9F, 0xFD, 0x09, 0x30,
  0x3F, 0x90, 0x90, 0xBF, 0xFC, 0x0C, 0x01, 0x30, 0xAF, 0x90, 0xB0, 0xDF, 0xFB, 0x0B, 0x01, 0x30,
  0x5F, 0xA0, 0xD0, 0xEF, 0xFA, 0x09, 0x40, 0x4F, 0xB0, 0x0E, 0xFF, 0x90, 0x94, 0x05, 0xFC, 0x0E,
  0x0D, 0xFF, 0x0D, 0x40, 0x6F, 0xD0, 0xD0, 0xBF, 0xF0, 0x63, 0x03, 0xFE, 0x0C, 0x09, 0xFF, 0x02,
  0x30, 0xAF, 0xE0, 0xA0, 0x4F, 0xF4, 0x0D, 0xFE, 0x81, 0x60, 0xEF, 0xFF, 0xFB, 0x81, 0x20, 0xAF,
  0xFF, 0xFA, 0x0E, 0x20, 0x2F, 0xFF, 0xFA, 0x08, 0x30, 0x9F, 0xD4, 0xFE, 0x02, 0x30, 0x10, 0xEF,
  0xC4, 0xFD, 0x0B, 0x50, 0x4F, 0xC4, 0xFD, 0x03, 0x60, 0x6F, 0xB4, 0xFC, 0x09, 0x71, 0x06, 0xFF,
  0xFA, 0x0E, 0x01, 0x72, 0x04, 0x0E, 0xFF, 0xF0, 0x57, 0x40, 0x10, 0x9F, 0xFD, 0x08, 0x77, 0x81,
  0x2A, 0xEF, 0xF9, 0x0B, 0x77, 0x48, 0x35, 0x9B, 0xDE, 0xFA, 0x0C, 0x01, 0x77, 0x73, 0xF0, 0xB7,
  0x77, 0x5E, 0x0B, 0x77, 0x76, 0xD0, 0x87, 0x77, 0x7B, 0x0E, 0x04, 0x77, 0x77, 0x1A, 0x09, 0x01,
  0x77, 0x77, 0x20, 0xB0, 0x27, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_contact_support() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_contact_support_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_copyright 48x48, 4-bit Alpha,  RLE, 385 bytes.
static const unsigned char ic_round_48_action_copyright_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x93,
  0x01, 0xC0, 0x77, 0x28, 0x52, 0x7A, 0xBB, 0x84, 0x73, 0x07, 0xC0, 0x12, 0x08, 0xB0, 0xE7, 0x20,
  0x9F, 0x0C, 0x02, 0x72, 0x0E, 0xB0, 0x82, 0x0D, 0xB0, 0x67, 0x10, 0xCF, 0xA0, 0xE0, 0x27, 0x10,
  0x6B, 0x81, 0xD0, 0x3C, 0x71, 0x09, 0xB8, 0x3E, 0x75, 0x6D, 0xB0, 0xB7, 0x2C, 0x03, 0x07, 0xB0,
  0xB7, 0x02, 0xB0, 0xE0, 0x24, 0x0C, 0xB0, 0x37, 0x10, 0xBB, 0x07, 0x0A, 0xB0, 0x67, 0x07, 0xB0,
  0x85, 0x03, 0xB0, 0x77, 0x10, 0x6B, 0x0A, 0x0C, 0xB0, 0x37, 0x0B, 0xB0, 0x36, 0x0F, 0x90, 0x57,
  0x10, 0x3B, 0x0C, 0x0E, 0xB0, 0x27, 0x0E, 0xB0, 0x17, 0x74, 0x02, 0xB0, 0xEC, 0x71, 0xC7, 0x76,
  0xF9, 0x71, 0xC7, 0x76, 0xC0, 0xEB, 0x02, 0x70, 0xEB, 0x01, 0x77, 0x40, 0x2B, 0x0E, 0x0C, 0xB0,
  0x37, 0x0B, 0xB0, 0x36, 0x80, 0x01, 0x71, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x70, 0x8B, 0x08, 0x50,
  0x2B, 0x07, 0x71, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x70, 0x2B, 0x0E, 0x02, 0x40, 0xAB, 0x03, 0x71,
  0x0B, 0xB0, 0x70, 0x3C, 0x71, 0x09, 0xB8, 0x3E, 0x74, 0x6C, 0xB0, 0xB7, 0x2C, 0x81, 0x30, 0xDB,
  0x06, 0x71, 0x0C, 0xFA, 0x0D, 0x01, 0x71, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xE7, 0x20, 0x9F, 0x0B,
  0x01, 0x72, 0x0E, 0xB0, 0x82, 0x01, 0xC0, 0x77, 0x28, 0x52, 0x79, 0xBA, 0x83, 0x73, 0x07, 0xC0,
  0x13, 0x09, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x09, 0x40, 0x10, 0xEB, 0x0E, 0x01, 0x77, 0x71, 0x01,
  0x0E, 0xB0, 0xE0, 0x15, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x57, 0x09, 0xC0, 0xE0,
  0x37, 0x74, 0x03, 0x0E, 0xC0, 0x97, 0x20, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x74, 0x0A, 0xD0,
  0xE0, 0x67, 0x50, 0x60, 0xED, 0x0A, 0x76, 0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0,
  0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76,
  0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_copyright() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_copyright_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_credit_card_off 48x48, 4-bit Alpha,  RLE, 264 bytes.
static const unsigned char ic_round_48_action_credit_card_off_data[] PROGMEM = {
  0x82, 0x2C, 0xE6, 0x80, 0xC2, 0x00, 0xAB, 0x07, 0x80, 0xC1, 0x00, 0xAC, 0x07, 0x80, 0xC0, 0x00,
  0x20, 0xEC, 0x07, 0x50, 0xCF, 0xFF, 0xC8, 0x1E, 0xA1, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFF,
  0xD0, 0xE0, 0x12, 0x0A, 0xD0, 0x75, 0x0C, 0xFF, 0xFD, 0x0A, 0x20, 0xEE, 0x07, 0x50, 0xCF, 0xFF,
  0xC0, 0xD2, 0xF9, 0x07, 0x50, 0xCF, 0xFF, 0xC2, 0xFA, 0x07, 0x50, 0xCF, 0xFF, 0xB2, 0xFB, 0x07,
  0x50, 0xCF, 0xFF, 0xA2, 0xFC, 0x07, 0x50, 0xCF, 0xFF, 0x92, 0xC2, 0x03, 0x0E, 0xC0, 0x77, 0x77,
  0x2C, 0x2C, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x71, 0xC2, 0xC4, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0xC2,
  0xC5, 0x03, 0x0E, 0xC0, 0x77, 0x76, 0xC2, 0xC6, 0x03, 0x0E, 0xC0, 0x77, 0x75, 0xC2, 0xC7, 0x03,
  0x0E, 0xC0, 0x77, 0x74, 0xC2, 0xC7, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x3C, 0x2C, 0x72, 0x03, 0x0E,
  0xC0, 0x77, 0x72, 0xC2, 0xFF, 0xE0, 0x75, 0x0C, 0xFE, 0x2F, 0xFF, 0x07, 0x50, 0xCF, 0xD2, 0xFF,
  0xF9, 0x07, 0x50, 0xCF, 0xC2, 0xFF, 0xFA, 0x07, 0x50, 0xCF, 0xB2, 0xFF, 0xFB, 0x07, 0x50, 0xCF,
  0xA2, 0xFF, 0xFC, 0x07, 0x50, 0xCF, 0x92, 0xFF, 0xFD, 0x07, 0x50, 0xCF, 0x2F, 0xFF, 0xE0, 0x75,
  0x0C, 0xE2, 0xFF, 0xFF, 0x07, 0x50, 0xCD, 0x2F, 0xFF, 0xF9, 0x07, 0x50, 0xCC, 0x2F, 0xFF, 0xFA,
  0x07, 0x50, 0xCB, 0x2F, 0xFF, 0xFB, 0x07, 0x50, 0xCA, 0x20, 0xDF, 0xFF, 0xFB, 0x07, 0x50, 0xC0,
  0xE2, 0x0A, 0xFF, 0xFF, 0xC0, 0x75, 0x07, 0x20, 0x10, 0xEF, 0xFF, 0xFC, 0x07, 0x71, 0x81, 0x1A,
  0xEF, 0xFF, 0xFB, 0x07, 0x80, 0xC0, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC0, 0x00, 0x30, 0xEC, 0x07,
  0x80, 0xC0, 0x00, 0x30, 0xEC, 0x06, 0x80, 0xC0, 0x00, 0x30, 0xEB, 0x0D, 0x80, 0xC1, 0x00, 0x30,
  0xEA, 0x0C, 0x80, 0xC2, 0x08, 0x22, 0xAA, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_credit_card_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 43, 45), Box(0, 0, 47, 47),
      ic_round_48_action_credit_card_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_credit_card 48x48, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_round_48_action_credit_card_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0x80, 0xD8, 0x4F, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x01, 0x77, 0x77, 0x20, 0x1F, 0x90,
  0xB0, 0x17, 0x77, 0x70, 0x10, 0xBC, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1,
  0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAE, 0xFF, 0xFF, 0xC8, 0x1E, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_credit_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_credit_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_css 48x48, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_48_action_css_data[] PROGMEM = {
  0x04, 0x0D, 0xE0, 0xD0, 0x43, 0x04, 0x0D, 0xE0, 0xD0, 0x43, 0x04, 0x0D, 0xE8, 0x1D, 0x4D, 0xF9,
  0x0D, 0x30, 0xDF, 0x90, 0xD3, 0x0D, 0xF9, 0x0D, 0xFB, 0x3F, 0xB3, 0xFE, 0x48, 0x17, 0xE8, 0x3B,
  0x48, 0x17, 0xE8, 0x3B, 0x48, 0x17, 0xE8, 0xB7, 0x3B, 0x73, 0xB7, 0xB7, 0x30, 0xDF, 0x0D, 0x04,
  0x30, 0xDF, 0x0D, 0x04, 0xB7, 0x30, 0x40, 0xDF, 0x0D, 0x30, 0x40, 0xDF, 0x0D, 0xB7, 0x73, 0xB7,
  0x3E, 0x48, 0x17, 0xE8, 0x38, 0x18, 0xE7, 0x4B, 0x38, 0x18, 0xE7, 0x4F, 0xE3, 0xFB, 0x3F, 0xB0,
  0xDF, 0x90, 0xD3, 0x0D, 0xF9, 0x0D, 0x30, 0xDF, 0x98, 0x1D, 0x4D, 0xE0, 0xD0, 0x43, 0x04, 0x0D,
  0xE0, 0xD0, 0x43, 0x04, 0x0D, 0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_css() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 18, 41, 29), Box(0, 0, 47, 47),
      ic_round_48_action_css_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_currency_exchange 48x48, 4-bit Alpha,  RLE, 472 bytes.
static const unsigned char ic_round_48_action_currency_exchange_data[] PROGMEM = {
  0x77, 0x28, 0x34, 0x8A, 0xDE, 0xA8, 0x3D, 0xDA, 0x74, 0x77, 0x77, 0x18, 0x14, 0xAE, 0xFD, 0x81,
  0xEA, 0x47, 0x77, 0x30, 0x40, 0xCF, 0xFC, 0x0C, 0x04, 0x77, 0x60, 0x10, 0xBF, 0xFF, 0x90, 0xB0,
  0x27, 0x73, 0x05, 0x0E, 0xE8, 0x3E, 0x95, 0x31, 0x28, 0x31, 0x25, 0x9D, 0xE0, 0xE0, 0x54, 0x82,
  0x4D, 0xD4, 0x70, 0x8E, 0x0A, 0x03, 0x75, 0x03, 0x0A, 0xE0, 0x83, 0x0D, 0xA0, 0xD6, 0x08, 0xD0,
  0xB0, 0x37, 0x72, 0x02, 0x0B, 0xD0, 0x82, 0xC5, 0x08, 0xD0, 0x77, 0x76, 0x06, 0xD0, 0x81, 0xC4,
  0x05, 0xC0, 0xE0, 0x37, 0x28, 0x23, 0xDD, 0x37, 0x20, 0x30, 0xEC, 0x05, 0xC3, 0x02, 0x0E, 0xB0,
  0xE0, 0x37, 0x30, 0xAA, 0x0A, 0x73, 0x02, 0x0E, 0xB0, 0xEC, 0x30, 0xBC, 0x03, 0x73, 0x03, 0x0D,
  0xA0, 0xD0, 0x47, 0x30, 0x3F, 0x92, 0x04, 0xC0, 0x67, 0x20, 0x40, 0xDE, 0x0D, 0x05, 0x72, 0x06,
  0xF2, 0x0C, 0xB0, 0xC7, 0x20, 0x6F, 0xB0, 0x84, 0x04, 0x0D, 0xFB, 0x10, 0x4C, 0x02, 0x71, 0x02,
  0xC8, 0x2E, 0xA9, 0xDC, 0x03, 0x30, 0xDF, 0xC1, 0x0A, 0xB0, 0xA7, 0x20, 0x9B, 0x07, 0x40, 0x5B,
  0x05, 0x30, 0xDF, 0xB8, 0x1D, 0x0E, 0xB0, 0x47, 0x20, 0xDA, 0x0A, 0x68, 0x14, 0xB8, 0x40, 0x40,
  0xDF, 0x98, 0x1D, 0x44, 0xB0, 0xD7, 0x3B, 0x08, 0x77, 0x74, 0x08, 0xB0, 0x97, 0x30, 0xDA, 0x0C,
  0x77, 0x74, 0x0A, 0xB0, 0x67, 0x30, 0x9B, 0x0B, 0x01, 0x77, 0x72, 0x0D, 0xB0, 0x37, 0x30, 0x20,
  0xEC, 0x09, 0x04, 0x77, 0x70, 0xCA, 0x0E, 0x75, 0x04, 0x0E, 0xD8, 0x1E, 0x81, 0x77, 0x48, 0x23,
  0xDE, 0x57, 0x60, 0x20, 0xBF, 0x08, 0x80, 0xC0, 0x08, 0x13, 0x9E, 0xD0, 0xC0, 0x17, 0x48, 0x25,
  0xED, 0x37, 0x77, 0x10, 0x50, 0xCC, 0x0B, 0x74, 0x0E, 0xA0, 0xC7, 0x77, 0x30, 0x50, 0xEB, 0x04,
  0x72, 0x03, 0xB0, 0xD7, 0x77, 0x40, 0x4B, 0x09, 0x72, 0x06, 0xB0, 0xA7, 0x72, 0x03, 0x01, 0x71,
  0x0D, 0xA0, 0xB7, 0x20, 0x9B, 0x08, 0x77, 0x18, 0x2D, 0xFD, 0x17, 0x0C, 0xA0, 0xB7, 0x20, 0xDB,
  0x81, 0x44, 0xDF, 0x90, 0xD0, 0x42, 0x03, 0xB0, 0xA6, 0x01, 0xB0, 0x97, 0x10, 0x4B, 0x81, 0xE0,
  0xDF, 0xB0, 0xD3, 0x0E, 0xB0, 0xA0, 0x13, 0x03, 0x0C, 0xB0, 0x47, 0x10, 0xAB, 0x0A, 0x1F, 0xC0,
  0xD3, 0x04, 0xC8, 0x2E, 0xCB, 0xDC, 0x0C, 0x71, 0x02, 0xC0, 0x41, 0xFB, 0x0D, 0x04, 0x40, 0x5F,
  0xB0, 0xD0, 0x17, 0x10, 0xCB, 0x0C, 0x2F, 0x06, 0x72, 0x03, 0x0B, 0xF0, 0x80, 0x17, 0x10, 0x6C,
  0x04, 0x2F, 0x90, 0x37, 0x30, 0x20, 0xDA, 0x81, 0xD5, 0x17, 0x20, 0x3C, 0x0B, 0x3C, 0x0E, 0xB0,
  0xE0, 0x27, 0x30, 0xAA, 0x0A, 0x73, 0x03, 0x0E, 0xB0, 0xE0, 0x23, 0xC0, 0x5C, 0x0E, 0x03, 0x72,
  0x82, 0x3D, 0xD3, 0x72, 0x03, 0x0E, 0xC0, 0x54, 0xC1, 0x08, 0xD0, 0x67, 0x76, 0x07, 0xD0, 0x85,
  0xC2, 0x08, 0xD0, 0xB0, 0x27, 0x72, 0x03, 0x0B, 0xD0, 0x86, 0x0D, 0xA0, 0xD3, 0x08, 0xE0, 0xA0,
  0x37, 0x50, 0x30, 0xAE, 0x08, 0x78, 0x24, 0xDD, 0x44, 0x05, 0x0E, 0xE8, 0x3D, 0x95, 0x21, 0x28,
  0x31, 0x35, 0x9E, 0xE0, 0xE0, 0x57, 0x73, 0x02, 0x0B, 0xFF, 0xF9, 0x0B, 0x01, 0x77, 0x60, 0x40,
  0xCF, 0xFC, 0x0C, 0x04, 0x77, 0x73, 0x81, 0x4A, 0xEF, 0xD8, 0x1E, 0xA4, 0x77, 0x77, 0x18, 0x34,
  0x7A, 0xDD, 0xA8, 0x3E, 0xDA, 0x84, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_currency_exchange() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_currency_exchange_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_dangerous 48x48, 4-bit Alpha,  RLE, 242 bytes.
static const unsigned char ic_round_48_action_dangerous_data[] PROGMEM = {
  0x73, 0x08, 0x0D, 0xFD, 0x81, 0xD9, 0x17, 0x73, 0x01, 0x0D, 0xFF, 0xA0, 0xD0, 0x17, 0x71, 0x01,
  0x0D, 0xFF, 0xC0, 0xD0, 0x17, 0x60, 0x10, 0xDF, 0xFE, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xFF, 0xF9,
  0x0D, 0x01, 0x72, 0x01, 0x0D, 0xFF, 0xFB, 0x0D, 0x01, 0x70, 0x10, 0xDF, 0xFF, 0xD0, 0xD0, 0x15,
  0x01, 0x0D, 0xFF, 0xFF, 0x0D, 0x01, 0x30, 0x10, 0xDF, 0xFF, 0xFA, 0x83, 0xD1, 0x01, 0xDF, 0xFF,
  0xFC, 0x81, 0xC0, 0x9F, 0xB8, 0x19, 0x6B, 0xF9, 0x81, 0xB6, 0x9F, 0xB0, 0x80, 0xDF, 0xA0, 0x93,
  0x0A, 0xE0, 0xA3, 0x09, 0xFA, 0x0D, 0xFB, 0x06, 0x40, 0xAC, 0x0A, 0x40, 0x6F, 0xFE, 0x0B, 0x50,
  0xAA, 0x0A, 0x50, 0xBF, 0xFF, 0x0A, 0x50, 0x0A, 0x50, 0xAF, 0xFF, 0xA0, 0xA7, 0x30, 0xAF, 0xFF,
  0xC0, 0xA7, 0x10, 0xAF, 0xFF, 0xE0, 0xA6, 0x0A, 0xFF, 0xFF, 0x0A, 0x60, 0xAF, 0xFF, 0xE0, 0xA7,
  0x10, 0xAF, 0xFF, 0xC0, 0xA7, 0x30, 0xAF, 0xFF, 0xA0, 0xA5, 0x00, 0xA5, 0x0A, 0xFF, 0xF0, 0xB5,
  0x0A, 0xA0, 0xA5, 0x0B, 0xFF, 0xE0, 0x64, 0x0A, 0xC0, 0xA4, 0x06, 0xFB, 0x0D, 0xFA, 0x09, 0x30,
  0xAE, 0x0A, 0x30, 0x8F, 0xA0, 0xD0, 0x8F, 0xB8, 0x19, 0x6B, 0xF9, 0x81, 0xB6, 0x8F, 0xB8, 0x19,
  0x0C, 0xFF, 0xFF, 0xC8, 0x3D, 0x10, 0x1D, 0xFF, 0xFF, 0xA0, 0xD0, 0x13, 0x01, 0x0D, 0xFF, 0xFF,
  0x0D, 0x01, 0x50, 0x10, 0xDF, 0xFF, 0xD0, 0xD0, 0x17, 0x01, 0x0D, 0xFF, 0xFB, 0x0D, 0x01, 0x72,
  0x01, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x74, 0x01, 0x0D, 0xFF, 0xE0, 0xD0, 0x17, 0x60, 0x10, 0xDF,
  0xFC, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xDF, 0xFA, 0x0D, 0x01, 0x77, 0x38, 0x11, 0x9D, 0xFD, 0x0D,
  0x08, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_dangerous() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_dangerous_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_dashboard_customize 48x48, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_round_48_action_dashboard_customize_data[] PROGMEM = {
  0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xD8, 0x1D, 0x4D, 0xFF, 0x0D, 0x40, 0xDF, 0xF0,
  0xDF, 0xFA, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF,
  0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC,
  0x4F, 0xFF, 0xFC, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x40, 0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04,
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x48, 0x0A, 0x94, 0x00, 0x40, 0xDF, 0xD0, 0xD0, 0x47, 0x38, 0x24,
  0xDD, 0x46, 0x0D, 0xFF, 0x0D, 0x73, 0x0D, 0xA0, 0xD6, 0xFF, 0xA7, 0x3C, 0x6F, 0xFA, 0x73, 0xC6,
  0xFF, 0xA7, 0x3C, 0x6F, 0xFA, 0x73, 0xC6, 0xFF, 0xA4, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xFF, 0xA4,
  0x0D, 0xFF, 0x0D, 0xFF, 0xA4, 0x0D, 0xFF, 0x0D, 0xFF, 0xA4, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xFF,
  0xA7, 0x3C, 0x6F, 0xFA, 0x73, 0xC6, 0xFF, 0xA7, 0x3C, 0x6F, 0xFA, 0x73, 0xC6, 0x0D, 0xFF, 0x0D,
  0x73, 0x0D, 0xA0, 0xD6, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x73, 0x82, 0x4D, 0xD4, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_dashboard_customize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_dashboard_customize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_dashboard 48x48, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_round_48_action_dashboard_data[] PROGMEM = {
  0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xD8, 0x1D, 0x4D, 0xFF, 0x0D, 0x40, 0xDF, 0xF0,
  0xDF, 0xFA, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF,
  0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x40, 0xDF, 0xF0, 0xDF, 0xFA, 0x40,
  0x40, 0xDF, 0xD0, 0xD0, 0x4F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x77,
  0x6F, 0xFA, 0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x4F, 0xFA, 0x40, 0xDF, 0xF0, 0x0D, 0xFF, 0x0D, 0x4F,
  0xFA, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x4F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F,
  0xFA, 0x77, 0x6F, 0xFA, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x4F, 0xFF,
  0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC,
  0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x40, 0xDF, 0xF8, 0x1D, 0x4D,
  0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_dashboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_dashboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_data_exploration 48x48, 4-bit Alpha,  RLE, 284 bytes.
static const unsigned char ic_round_48_action_data_exploration_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0xFF, 0xE0, 0xB0, 0x16, 0x01,
  0x0B, 0xE0, 0x82, 0x0D, 0xFF, 0xE0, 0x17, 0x10, 0x1E, 0x81, 0xD0, 0x3F, 0xFF, 0x01, 0x72, 0xF0,
  0x30, 0x7F, 0xFF, 0x0B, 0x01, 0x71, 0xF0, 0x70, 0xAF, 0xFF, 0xA0, 0xA7, 0xF0, 0xA0, 0xCF, 0xB0,
  0xD0, 0xCF, 0xB0, 0xA7, 0x1F, 0x0C, 0x0E, 0xFA, 0x07, 0x20, 0x40, 0xEF, 0x0A, 0x72, 0xF0, 0xEF,
  0xA0, 0x74, 0x02, 0x0D, 0xD0, 0xA5, 0x0A, 0x4F, 0xFA, 0x07, 0x60, 0x10, 0xBB, 0x0A, 0x58, 0x1A,
  0xF1, 0x20, 0x1F, 0x90, 0xEE, 0x07, 0x72, 0x81, 0x9F, 0xA5, 0x0A, 0xA8, 0x2B, 0x11, 0xBF, 0x90,
  0xCD, 0x07, 0x50, 0x45, 0x05, 0x50, 0xAF, 0xF9, 0x0A, 0xC0, 0x75, 0x81, 0xCF, 0x77, 0x20, 0xAF,
  0xFA, 0x07, 0xB0, 0x75, 0x0C, 0xB0, 0xA7, 0x0A, 0xFF, 0xB0, 0x3A, 0x07, 0x50, 0xCD, 0x0C, 0x01,
  0x40, 0xAF, 0xFC, 0x10, 0xD0, 0x85, 0x0C, 0xF0, 0xD0, 0x22, 0x0A, 0xFF, 0xD1, 0x03, 0x50, 0xCF,
  0xB0, 0xB0, 0xDF, 0xFE, 0x60, 0xCF, 0xFF, 0xFD, 0x50, 0xCF, 0xFF, 0xFE, 0x40, 0xCF, 0xFF, 0xFF,
  0x30, 0x48, 0x0C, 0x0F, 0x40, 0x8F, 0xFF, 0xFF, 0x50, 0xAF, 0xFF, 0xE8, 0x2B, 0x11, 0xBB, 0x60,
  0xBF, 0xFF, 0xD0, 0x12, 0x01, 0xB7, 0x08, 0xFF, 0xFC, 0x01, 0x20, 0x1B, 0x71, 0x05, 0x0E, 0xFF,
  0xFA, 0x82, 0xB1, 0x1B, 0xA0, 0xD7, 0x20, 0x10, 0x9F, 0xFF, 0xF0, 0xA7, 0x48, 0x11, 0x8D, 0xFF,
  0xFB, 0x0E, 0x01, 0x77, 0x83, 0x37, 0xAC, 0xDF, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_data_exploration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_data_exploration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_data_thresholding 48x48, 4-bit Alpha,  RLE, 256 bytes.
static const unsigned char ic_round_48_action_data_thresholding_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xA8, 0x2F, 0x0D, 0xFF, 0xFF, 0xD8, 0x3E, 0x40, 0x1D,
  0xFF, 0xFF, 0xA0, 0xE0, 0x33, 0x06, 0xFF, 0xFF, 0x90, 0xE0, 0x34, 0x07, 0xFF, 0xE8, 0x2E, 0x63,
  0x9C, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xFD, 0x0E, 0x03, 0x30, 0x7A, 0x0E, 0x03, 0x40, 0x30, 0xEF,
  0xFD, 0x0E, 0x03, 0x58, 0x17, 0xE3, 0x40, 0x30, 0xEF, 0xFD, 0x0E, 0x03, 0x70, 0x14, 0x03, 0x0E,
  0xFF, 0xD0, 0xE0, 0x37, 0x50, 0x30, 0xEF, 0xFD, 0x0E, 0x03, 0x40, 0x30, 0xB6, 0x03, 0x0E, 0xFF,
  0xD0, 0xE0, 0x34, 0x82, 0x3E, 0xFC, 0x40, 0x30, 0xEF, 0xFE, 0x07, 0x40, 0x30, 0xEB, 0x83, 0xC1,
  0x04, 0xEF, 0xFF, 0x06, 0x30, 0x30, 0xEE, 0x0D, 0xFF, 0xFA, 0x83, 0xC1, 0x03, 0xEF, 0xFF, 0xFC,
  0x0E, 0x0D, 0x80, 0xAD, 0x2F, 0x20, 0x20, 0xDA, 0x0E, 0x03, 0x20, 0x30, 0xEA, 0x0E, 0x02, 0x20,
  0xAB, 0x08, 0x20, 0x30, 0xEF, 0xA1, 0x02, 0x0D, 0xA0, 0xE0, 0x32, 0x03, 0x0E, 0xA0, 0xE0, 0x22,
  0x0A, 0xB0, 0x82, 0x03, 0x0E, 0xFB, 0x02, 0x0D, 0xA0, 0xE0, 0x32, 0x03, 0x0E, 0xA0, 0xE0, 0x22,
  0x0A, 0xB0, 0x82, 0x03, 0x0E, 0xA0, 0xDF, 0x90, 0xDA, 0x0E, 0x03, 0x20, 0x30, 0xEA, 0x0E, 0x02,
  0x20, 0xAB, 0x08, 0x20, 0x30, 0xEA, 0x0D, 0x02, 0xFB, 0x0E, 0x03, 0x20, 0x30, 0xEA, 0x0E, 0x02,
  0x20, 0xAB, 0x08, 0x20, 0x30, 0xEA, 0x0D, 0x02, 0x1F, 0xA0, 0xE0, 0x32, 0x03, 0x0E, 0xA0, 0xE0,
  0x22, 0x0A, 0xB0, 0x82, 0x03, 0x0E, 0xA0, 0xD0, 0x22, 0xC0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF,
  0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_data_thresholding() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_data_thresholding_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_date_range 48x48, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_48_action_date_range_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x72, 0x82, 0x4D, 0xD4, 0x75, 0x0D, 0xA0, 0xD7, 0x72, 0x0D, 0xA0, 0xD7,
  0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x4D, 0xA1, 0x01, 0xEF,
  0xFF, 0xFC, 0x81, 0xE1, 0x9F, 0xFF, 0xFE, 0x0A, 0x0D, 0xFF, 0xFF, 0xE0, 0xD8, 0x0B, 0xB0, 0xF7,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x94, 0xC4, 0xC4, 0xC4, 0xF9,
  0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F, 0x97, 0x77, 0x7F,
  0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77,
  0x7F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x90, 0xB0, 0x17, 0x77, 0x30, 0x10, 0xBC, 0x0D, 0xFF, 0xFF,
  0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_date_range() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_date_range_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_delete_forever 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_round_48_action_delete_forever_data[] PROGMEM = {
  0x71, 0x06, 0x0E, 0xF9, 0x0E, 0x06, 0x77, 0x10, 0x7F, 0xD0, 0x77, 0x04, 0x0D, 0xFF, 0xFB, 0x81,
  0xD4, 0xDF, 0xFF, 0xD0, 0x0D, 0xFF, 0xFD, 0x81, 0xD4, 0xDF, 0xFF, 0xB0, 0xD0, 0x48, 0x0E, 0x60,
  0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF,
  0xFB, 0x4F, 0x0C, 0x0E, 0xE0, 0xE0, 0xCF, 0x4E, 0x04, 0x20, 0xAC, 0x0A, 0x20, 0x5E, 0x4D, 0x0C,
  0x40, 0xAA, 0x0A, 0x40, 0xDD, 0x4D, 0x0E, 0x50, 0x0A, 0x50, 0xED, 0x4E, 0x0A, 0x73, 0x0A, 0xE4,
  0xF0, 0xA7, 0x10, 0xAF, 0x4F, 0x90, 0xA6, 0x0A, 0xF9, 0x4F, 0x90, 0xA6, 0x0A, 0xF9, 0x4F, 0x0A,
  0x71, 0x0A, 0xF4, 0xE0, 0xA7, 0x30, 0xAE, 0x4D, 0x0E, 0x50, 0x0A, 0x50, 0xED, 0x4D, 0x0D, 0x40,
  0xAA, 0x0A, 0x40, 0xDD, 0x4E, 0x05, 0x20, 0xAC, 0x0A, 0x20, 0x5E, 0x4F, 0x0C, 0x0E, 0xE0, 0xE0,
  0xCF, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0x0D, 0xFF, 0xF9, 0x0D, 0x40, 0xAF, 0xFF,
  0x90, 0xA4, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x15, 0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_delete_forever() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_round_48_action_delete_forever_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_delete_outline 48x48, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_round_48_action_delete_outline_data[] PROGMEM = {
  0x71, 0x06, 0x0E, 0xF9, 0x0E, 0x06, 0x77, 0x10, 0x7F, 0xD0, 0x77, 0x04, 0x0D, 0xFF, 0xFB, 0x81,
  0xD4, 0xDF, 0xFF, 0xD0, 0x0D, 0xFF, 0xFD, 0x81, 0xD4, 0xDF, 0xFF, 0xB0, 0xD0, 0x48, 0x0E, 0x70,
  0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x15, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x14, 0x0A, 0xFF, 0xF9,
  0x0A, 0x40, 0xDF, 0xFF, 0x90, 0xD4, 0xC0, 0xB0, 0x17, 0x50, 0x10, 0xBC, 0x4C, 0x01, 0x77, 0x01,
  0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4,
  0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7,
  0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72, 0xC4, 0xC7, 0x72,
  0xC4, 0xC0, 0x17, 0x70, 0x1C, 0x4C, 0x0B, 0x01, 0x75, 0x01, 0x0B, 0xC4, 0x0D, 0xFF, 0xF9, 0x0D,
  0x40, 0xAF, 0xFF, 0x90, 0xA4, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x15, 0x81, 0x1A, 0xDF, 0xFA, 0x81,
  0xDA, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_delete_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_round_48_action_delete_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_delete 48x48, 4-bit Alpha,  RLE, 126 bytes.
static const unsigned char ic_round_48_action_delete_data[] PROGMEM = {
  0x71, 0x06, 0x0E, 0xF9, 0x0E, 0x06, 0x77, 0x10, 0x7F, 0xD0, 0x77, 0x04, 0x0D, 0xFF, 0xFB, 0x81,
  0xD4, 0xDF, 0xFF, 0xD0, 0x0D, 0xFF, 0xFD, 0x81, 0xD4, 0xDF, 0xFF, 0xB0, 0xD0, 0x48, 0x0E, 0x70,
  0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x15, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x14, 0x0A, 0xFF, 0xF9,
  0x0A, 0x40, 0xDF, 0xFF, 0x90, 0xD4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4,
  0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF,
  0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB,
  0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0x0D, 0xFF, 0xF9, 0x0D, 0x40, 0xAF, 0xFF, 0x90,
  0xA4, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x15, 0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_delete() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_round_48_action_delete_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_density_large 48x48, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_48_action_density_large_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x48, 0x09, 0xFD, 0x40, 0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF,
  0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_density_large() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_density_large_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_density_medium 48x48, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_48_action_density_medium_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x48, 0x0E, 0xD4, 0x00, 0x40, 0xDF, 0xFF, 0xFC, 0x81, 0xD4, 0xDF, 0xFF,
  0xFE, 0x00, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04, 0x80, 0xED, 0x40, 0x04,
  0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF,
  0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_density_medium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_density_medium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_density_small 48x48, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_48_action_density_small_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x48, 0x0C, 0xB4, 0x00, 0x40, 0xDF, 0xFF, 0xFC, 0x81, 0xD4, 0xDF, 0xFF,
  0xFE, 0x00, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04, 0x80, 0xCB, 0x40, 0x04,
  0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF,
  0xFF, 0xC0, 0xD0, 0x48, 0x0C, 0xB4, 0x00, 0x40, 0xDF, 0xFF, 0xFC, 0x81, 0xD4, 0xDF, 0xFF, 0xFE,
  0x00, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_density_small() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_density_small_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_description 48x48, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_round_48_action_description_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x0A, 0xFF, 0xF0,
  0x77, 0x20, 0xDF, 0xFB, 0x07, 0xC0, 0x77, 0x1F, 0xFC, 0x10, 0x7C, 0x07, 0x7F, 0xFC, 0x20, 0x7C,
  0x07, 0x6F, 0xFC, 0x30, 0x7C, 0x07, 0x5F, 0xFC, 0x40, 0x7C, 0x07, 0x4F, 0xFC, 0x50, 0x7C, 0x07,
  0x3F, 0xFC, 0x60, 0x7C, 0x07, 0x2F, 0xFC, 0x70, 0x7C, 0x07, 0x1F, 0xFC, 0x71, 0x07, 0xC0, 0x4F,
  0xFC, 0x01, 0x71, 0x07, 0xB0, 0xBF, 0xFC, 0x0B, 0x01, 0x71, 0x07, 0xA0, 0xE8, 0x0B, 0x84, 0xF0,
  0xB0, 0x17, 0x50, 0x10, 0xBF, 0xFA, 0x01, 0x77, 0x01, 0xFF, 0xA0, 0x17, 0x70, 0x1F, 0xFA, 0x0B,
  0x01, 0x75, 0x01, 0x0B, 0x80, 0xA9, 0x4F, 0x0B, 0x01, 0x75, 0x01, 0x0B, 0xFF, 0xA0, 0x17, 0x70,
  0x1F, 0xFA, 0x01, 0x77, 0x01, 0xFF, 0xA0, 0xB0, 0x17, 0x50, 0x10, 0xB8, 0x0A, 0x84, 0xF0, 0xDF,
  0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01, 0xAE, 0xFF,
  0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_description() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_description_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_disabled_by_default 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_round_48_action_disabled_by_default_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAA, 0x6F, 0x0D, 0x0E, 0xFD, 0x00, 0xEF, 0xFD, 0x06,
  0x20, 0xAF, 0xB0, 0xA2, 0x06, 0xFF, 0xB0, 0xD4, 0x0A, 0xF9, 0x0A, 0x40, 0xDF, 0xFA, 0x0E, 0x50,
  0xAE, 0x0A, 0x50, 0xEF, 0xFB, 0x0A, 0x50, 0xAC, 0x0A, 0x50, 0xAF, 0xFD, 0x0A, 0x50, 0xAA, 0x0A,
  0x50, 0xAF, 0xFF, 0x0A, 0x50, 0x0A, 0x50, 0xAF, 0xFF, 0xA0, 0xA7, 0x30, 0xAF, 0xFF, 0xC0, 0xA7,
  0x10, 0xAF, 0xFF, 0xE0, 0xA6, 0x0A, 0xFF, 0xFF, 0x0A, 0x60, 0xAF, 0xFF, 0xE0, 0xA7, 0x10, 0xAF,
  0xFF, 0xC0, 0xA7, 0x30, 0xAF, 0xFF, 0xA0, 0xA5, 0x00, 0xA5, 0x0A, 0xFF, 0xF0, 0xA5, 0x0A, 0xA0,
  0xA5, 0x0A, 0xFF, 0xD0, 0xA5, 0x0A, 0xC0, 0xA5, 0x0A, 0xFF, 0xB0, 0xE5, 0x0A, 0xE0, 0xA5, 0x0E,
  0xFF, 0xA0, 0xD4, 0x0A, 0xF9, 0x0A, 0x40, 0xDF, 0xFB, 0x06, 0x20, 0xAF, 0xB0, 0xA2, 0x06, 0xFF,
  0xD0, 0xD0, 0xEF, 0xD0, 0x0E, 0x80, 0xAA, 0x6F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE,
  0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_disabled_by_default() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_disabled_by_default_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_disabled_visible 48x48, 4-bit Alpha,  RLE, 414 bytes.
static const unsigned char ic_round_48_action_disabled_visible_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x71, 0x81, 0x18, 0xDF, 0xD8, 0x1D,
  0x81, 0x77, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x77, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57,
  0x75, 0x09, 0xE8, 0x3E, 0xA6, 0x31, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x30, 0xAD, 0x0D, 0x06,
  0x75, 0x06, 0x0D, 0xD0, 0xA7, 0x71, 0x0A, 0xD0, 0x87, 0x72, 0x07, 0xD0, 0xA7, 0x60, 0x9D, 0x07,
  0x77, 0x40, 0x30, 0xDC, 0x09, 0x74, 0x05, 0xF0, 0x57, 0x74, 0x01, 0x0C, 0xC0, 0x57, 0x20, 0x10,
  0xEF, 0x90, 0x57, 0x74, 0x01, 0x0D, 0xB0, 0xE0, 0x17, 0x10, 0x9C, 0x07, 0xD0, 0x57, 0x74, 0x02,
  0xC0, 0x97, 0x01, 0xC8, 0x18, 0x05, 0xD0, 0x57, 0x74, 0x07, 0xC0, 0x16, 0x08, 0xB0, 0xD3, 0x05,
  0xD0, 0x57, 0x74, 0x0D, 0xB0, 0x86, 0x0D, 0xB0, 0x64, 0x05, 0xD0, 0x57, 0x73, 0x06, 0xB0, 0xD5,
  0x03, 0xB0, 0xE6, 0x05, 0xD0, 0x57, 0x72, 0x01, 0xC0, 0x34, 0x07, 0xB0, 0xA7, 0x05, 0xD0, 0x57,
  0x72, 0x0A, 0xB0, 0x74, 0x0A, 0xB0, 0x67, 0x10, 0x5D, 0x05, 0x77, 0x10, 0x6B, 0x0A, 0x40, 0xCB,
  0x03, 0x72, 0x05, 0xD0, 0x57, 0x70, 0x4B, 0x0C, 0x40, 0xEB, 0x01, 0x73, 0x05, 0xD0, 0x57, 0x60,
  0x1B, 0x0E, 0x4C, 0x75, 0x05, 0xC0, 0xD0, 0x17, 0x68, 0x11, 0x7D, 0x94, 0x0E, 0xB7, 0x68, 0x25,
  0xFE, 0x67, 0x74, 0x06, 0x40, 0xDB, 0x01, 0x76, 0x04, 0x01, 0x77, 0x73, 0x0B, 0xB0, 0x37, 0x76,
  0x82, 0x58, 0xCD, 0xA8, 0x2D, 0xC8, 0x57, 0x20, 0xAB, 0x06, 0x77, 0x38, 0x11, 0x9E, 0xFB, 0x81,
  0xE9, 0x16, 0x06, 0xB0, 0xA7, 0x72, 0x07, 0x0E, 0xFF, 0x0E, 0x07, 0x50, 0x2B, 0x0E, 0x77, 0x01,
  0x0B, 0xFF, 0xC0, 0xB0, 0x14, 0x0D, 0xB0, 0x67, 0x50, 0x10, 0xCF, 0x0A, 0x03, 0x20, 0x30, 0xAF,
  0x0C, 0x01, 0x30, 0x7B, 0x0D, 0x75, 0x0C, 0xF0, 0x76, 0x07, 0xF0, 0xC3, 0x01, 0x0E, 0xB0, 0x77,
  0x30, 0x9F, 0x0A, 0x28, 0x28, 0xDD, 0x82, 0x0A, 0xF0, 0x93, 0x08, 0xC0, 0x37, 0x10, 0x3F, 0x98,
  0x13, 0x08, 0xC8, 0x18, 0x03, 0xF9, 0x03, 0x20, 0x10, 0xEB, 0x0D, 0x01, 0x70, 0xBF, 0x92, 0x0D,
  0xC0, 0xD2, 0xF9, 0x0B, 0x30, 0x4C, 0x0C, 0x01, 0x60, 0xBF, 0x92, 0x0D, 0xC0, 0xD2, 0xF9, 0x0B,
  0x40, 0x8C, 0x0D, 0x02, 0x50, 0x3F, 0x98, 0x13, 0x08, 0xC8, 0x18, 0x03, 0xF9, 0x03, 0x50, 0xAD,
  0x07, 0x50, 0x9F, 0x0A, 0x28, 0x28, 0xDD, 0x82, 0x0A, 0xF0, 0x97, 0x09, 0xD0, 0xD0, 0x34, 0x0C,
  0xF0, 0x76, 0x07, 0xF0, 0xC7, 0x20, 0x8D, 0x0D, 0x40, 0x10, 0xCF, 0x0A, 0x03, 0x20, 0x30, 0xAF,
  0x0C, 0x01, 0x73, 0x04, 0x0D, 0xC0, 0x94, 0x01, 0x0B, 0xFF, 0xC0, 0xB0, 0x17, 0x60, 0x8C, 0x06,
  0x50, 0x70, 0xEF, 0xF0, 0xE0, 0x77, 0x72, 0x81, 0x17, 0xDA, 0x05, 0x58, 0x11, 0x9E, 0xFB, 0x81,
  0xE9, 0x17, 0x76, 0x82, 0x36, 0x94, 0x78, 0x25, 0x8C, 0xDA, 0x82, 0xDC, 0x85, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_disabled_visible() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 47, 43), Box(0, 0, 47, 47),
      ic_round_48_action_disabled_visible_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_display_settings 48x48, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_round_48_action_display_settings_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x71, 0xB7, 0xF9, 0x77, 0x71, 0xB7, 0xF9, 0x48, 0x09, 0x47,
  0x2B, 0x0F, 0x74, 0xF9, 0x4F, 0xFA, 0x2E, 0x4F, 0x94, 0xFF, 0xA2, 0xE4, 0xF9, 0x48, 0x09, 0x47,
  0x2B, 0x0F, 0x74, 0xF9, 0x77, 0x71, 0xB7, 0xF9, 0x77, 0x71, 0xB7, 0xF9, 0x7B, 0x77, 0x71, 0xF9,
  0x7B, 0x77, 0x71, 0xF9, 0x40, 0xF7, 0xB2, 0x80, 0x94, 0x74, 0xF9, 0x4E, 0x2F, 0xFA, 0x4F, 0x94,
  0xE2, 0xFF, 0xA4, 0xF9, 0x40, 0xF7, 0xB2, 0x80, 0x94, 0x74, 0xF9, 0x7B, 0x77, 0x71, 0xF9, 0x7B,
  0x77, 0x71, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10,
  0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x17, 0x6F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x77, 0x30, 0xDF,
  0xF0, 0xD7, 0x77, 0x30, 0x40, 0xDF, 0xD0, 0xD0, 0x47, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_display_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_display_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_dns 48x48, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_round_48_action_dns_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xD8, 0x4D, 0x51, 0x15, 0xDF, 0xFF, 0xF9, 0x0D, 0x01, 0x40,
  0x10, 0xDF, 0xFF, 0xF0, 0x56, 0x05, 0xFF, 0xFF, 0x01, 0x60, 0x1F, 0xFF, 0xF0, 0x16, 0x01, 0xFF,
  0xFF, 0x05, 0x60, 0x5F, 0xFF, 0xF0, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xFF, 0x98, 0x4D, 0x51, 0x15,
  0xDF, 0xFF, 0xC0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8,
  0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x80, 0xA9, 0x60, 0x81, 0x1A, 0xDF, 0xFF, 0xF8,
  0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xFC, 0x81, 0xE1, 0xAF, 0xFF, 0xFE, 0x0A, 0x0D, 0xFF, 0xFF, 0xE0,
  0xDD, 0x84, 0xD5, 0x11, 0x5D, 0xFF, 0xFF, 0x90, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xFF, 0x05, 0x60,
  0x5F, 0xFF, 0xF0, 0x16, 0x01, 0xFF, 0xFF, 0x01, 0x60, 0x1F, 0xFF, 0xF0, 0x56, 0x05, 0xFF, 0xFF,
  0x0D, 0x01, 0x40, 0x10, 0xDF, 0xFF, 0xF9, 0x84, 0xD5, 0x11, 0x5D, 0xFF, 0xFC, 0x0D, 0xFF, 0xFF,
  0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_dns() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_dns_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_done_all 48x48, 4-bit Alpha,  RLE, 255 bytes.
static const unsigned char ic_round_48_action_done_all_data[] PROGMEM = {
  0x77, 0x77, 0x28, 0x22, 0xCE, 0x67, 0x18, 0x1A, 0xEA, 0x77, 0x77, 0x20, 0x30, 0xEB, 0x01, 0x60,
  0xCB, 0x05, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x15, 0x0C, 0xC0, 0x57, 0x77, 0x60, 0x30, 0xEC, 0x07,
  0x50, 0xCC, 0x0B, 0x77, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xC0, 0xB7, 0x77, 0x60, 0x30, 0xEC,
  0x07, 0x50, 0xCC, 0x0B, 0x77, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xC0, 0xB7, 0x77, 0x60, 0x30,
  0xEC, 0x07, 0x50, 0xCC, 0x0B, 0x77, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xC0, 0xB7, 0x77, 0x60,
  0x30, 0xEC, 0x07, 0x50, 0xCC, 0x0B, 0x77, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xC0, 0xB7, 0x77,
  0x60, 0x20, 0xEC, 0x07, 0x50, 0xCC, 0x0B, 0x74, 0x01, 0x73, 0x00, 0x14, 0x01, 0x0C, 0xB0, 0x75,
  0x0C, 0xC0, 0xB7, 0x48, 0x2B, 0xFD, 0x37, 0x07, 0xA0, 0x64, 0x82, 0x1C, 0xF8, 0x50, 0xCC, 0x0B,
  0x74, 0x04, 0xB0, 0xE0, 0x36, 0x0E, 0xB0, 0x74, 0x01, 0x06, 0x50, 0xCC, 0x0B, 0x75, 0x02, 0xC0,
  0xE0, 0x35, 0x0D, 0xC0, 0x77, 0x20, 0xCC, 0x0B, 0x77, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0,
  0x77, 0x0C, 0xC0, 0xB7, 0x72, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xC0, 0xB7,
  0x74, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x73, 0x0C, 0xC0, 0xB7, 0x76, 0x07, 0xC0, 0xE0,
  0x34, 0x03, 0x0E, 0xC8, 0x17, 0x0C, 0xC0, 0xB7, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEC,
  0x0D, 0xC0, 0xB7, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0x0B, 0x77, 0x75, 0x07, 0xC0,
  0xE0, 0x34, 0x03, 0x0E, 0xD0, 0xB7, 0x77, 0x70, 0x7C, 0x07, 0x50, 0x30, 0xEB, 0x0B, 0x77, 0x77,
  0x20, 0x7A, 0x07, 0x78, 0x23, 0xEF, 0xB7, 0x77, 0x74, 0x00, 0x17, 0x30, 0x17, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_done_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 12, 46, 37), Box(0, 0, 47, 47),
      ic_round_48_action_done_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_done_outline 48x48, 4-bit Alpha,  RLE, 367 bytes.
static const unsigned char ic_round_48_action_done_outline_data[] PROGMEM = {
  0x80, 0xC2, 0x00, 0x18, 0x0C, 0x70, 0x83, 0x7E, 0xFE, 0x88, 0x0C, 0x40, 0x0B, 0xD0, 0xC0, 0x18,
  0x0C, 0x10, 0x0B, 0xF0, 0xC0, 0x17, 0x77, 0x77, 0x0B, 0xFA, 0x0C, 0x77, 0x77, 0x60, 0xBC, 0x81,
  0xEB, 0xEC, 0x09, 0x77, 0x77, 0x40, 0xBC, 0x83, 0xC1, 0x01, 0xDC, 0x01, 0x77, 0x77, 0x20, 0xBC,
  0x0C, 0x01, 0x30, 0x8C, 0x04, 0x77, 0x77, 0x10, 0xBC, 0x0C, 0x01, 0x40, 0xBC, 0x02, 0x77, 0x77,
  0x0B, 0xC0, 0xC0, 0x14, 0x07, 0xC0, 0xC7, 0x77, 0x70, 0xBC, 0x0C, 0x01, 0x40, 0x7C, 0x0E, 0x02,
  0x77, 0x76, 0x0B, 0xC0, 0xC0, 0x14, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x60, 0xBC, 0x0C, 0x01, 0x40,
  0x7C, 0x0E, 0x03, 0x77, 0x76, 0x0B, 0xC0, 0xC0, 0x14, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x60, 0xBC,
  0x0C, 0x01, 0x40, 0x7C, 0x0E, 0x03, 0x73, 0x83, 0x4A, 0xCA, 0x37, 0x50, 0xBC, 0x0C, 0x01, 0x40,
  0x7C, 0x0E, 0x03, 0x73, 0x08, 0xD0, 0x77, 0x30, 0xBC, 0x0C, 0x01, 0x40, 0x7C, 0x0E, 0x03, 0x73,
  0x08, 0xF0, 0x77, 0x10, 0xBC, 0x0C, 0x01, 0x40, 0x7C, 0x0E, 0x03, 0x73, 0x08, 0xFA, 0x07, 0x60,
  0xBC, 0x0C, 0x01, 0x40, 0x7C, 0x0E, 0x03, 0x73, 0x06, 0xFC, 0x07, 0x40, 0xBC, 0x0C, 0x01, 0x40,
  0x7C, 0x0E, 0x03, 0x73, 0x01, 0x0E, 0xB8, 0x3E, 0x40, 0x4E, 0xC0, 0x72, 0x0B, 0xC0, 0xC0, 0x14,
  0x07, 0xC0, 0xE0, 0x37, 0x40, 0x4C, 0x08, 0x30, 0x30, 0xEC, 0x07, 0x0B, 0xC0, 0xC0, 0x14, 0x07,
  0xC0, 0xE0, 0x37, 0x50, 0x3C, 0x09, 0x40, 0x30, 0xEF, 0x90, 0xC0, 0x14, 0x07, 0xC0, 0xE0, 0x37,
  0x70, 0xEC, 0x04, 0x40, 0x30, 0xEE, 0x0C, 0x01, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x10, 0x5C, 0x0E,
  0x03, 0x40, 0x30, 0xEC, 0x0C, 0x01, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x30, 0x6C, 0x0E, 0x03, 0x40,
  0x30, 0xEA, 0x0C, 0x01, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x50, 0x6C, 0x0E, 0x03, 0x48, 0x23, 0xEC,
  0x14, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x06, 0xC0, 0xE0, 0x34, 0x03, 0x01, 0x40, 0x7C, 0x0E, 0x03,
  0x77, 0x72, 0x06, 0xC0, 0xE0, 0x37, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x74, 0x06, 0xC0, 0xE0, 0x36,
  0x07, 0xC0, 0xE0, 0x37, 0x77, 0x60, 0x6C, 0x0E, 0x03, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x10,
  0x6C, 0x0E, 0x04, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x30, 0x6D, 0x0B, 0x0C, 0xC0, 0xE0, 0x37,
  0x77, 0x75, 0x06, 0xFA, 0x0E, 0x03, 0x77, 0x77, 0x70, 0x6F, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x6D,
  0x0E, 0x03, 0x80, 0xC3, 0x00, 0x40, 0xDA, 0x0B, 0x01, 0x80, 0xC6, 0x00, 0x17, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_done_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 46, 42), Box(0, 0, 47, 47),
      ic_round_48_action_done_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_done 48x48, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_round_48_action_done_data[] PROGMEM = {
  0x77, 0x77, 0x28, 0x22, 0xCE, 0x67, 0x77, 0x72, 0x02, 0x0E, 0xB0, 0x17, 0x77, 0x70, 0x20, 0xEC,
  0x01, 0x77, 0x76, 0x02, 0x0E, 0xC0, 0x77, 0x77, 0x60, 0x20, 0xEC, 0x07, 0x77, 0x76, 0x02, 0x0E,
  0xC0, 0x77, 0x77, 0x60, 0x20, 0xEC, 0x07, 0x77, 0x76, 0x02, 0x0E, 0xC0, 0x77, 0x77, 0x60, 0x20,
  0xEC, 0x07, 0x77, 0x76, 0x02, 0x0E, 0xC0, 0x77, 0x77, 0x60, 0x20, 0xEC, 0x07, 0x77, 0x76, 0x02,
  0x0E, 0xC0, 0x77, 0x40, 0x17, 0x71, 0x02, 0x0E, 0xC0, 0x77, 0x48, 0x2B, 0xFD, 0x27, 0x50, 0x20,
  0xEC, 0x07, 0x74, 0x04, 0xB0, 0xE0, 0x27, 0x30, 0x20, 0xEC, 0x07, 0x75, 0x03, 0xC0, 0xE0, 0x27,
  0x10, 0x20, 0xEC, 0x07, 0x77, 0x07, 0xC0, 0xE0, 0x26, 0x02, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xC0,
  0xE0, 0x24, 0x02, 0x0E, 0xC0, 0x77, 0x74, 0x07, 0xC0, 0xE0, 0x22, 0x02, 0x0E, 0xC0, 0x77, 0x76,
  0x07, 0xC8, 0x2E, 0x22, 0xEC, 0x07, 0x77, 0x71, 0x07, 0xC0, 0x0E, 0xC0, 0x77, 0x77, 0x30, 0x7F,
  0x90, 0x77, 0x77, 0x50, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xC0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77,
  0x77, 0x74, 0x00, 0x17, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_done() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 12, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_done_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_donut_large 48x48, 4-bit Alpha,  RLE, 317 bytes.
static const unsigned char ic_round_48_action_donut_large_data[] PROGMEM = {
  0x77, 0x01, 0x02, 0x71, 0x03, 0x01, 0x77, 0x74, 0x81, 0x17, 0xDA, 0x0B, 0x01, 0x40, 0x10, 0xCA,
  0x81, 0xD7, 0x17, 0x77, 0x08, 0xE0, 0xA4, 0x0A, 0xE0, 0x80, 0x17, 0x73, 0x05, 0x0D, 0xF0, 0xE4,
  0x0E, 0xF0, 0xE0, 0x47, 0x71, 0x08, 0xFA, 0x0D, 0x40, 0xDF, 0xA0, 0x87, 0x60, 0xAF, 0xB0, 0x54,
  0x06, 0xFB, 0x0A, 0x74, 0x0A, 0xFA, 0x0C, 0x04, 0x60, 0x40, 0xCF, 0xA0, 0xA7, 0x20, 0x8F, 0x90,
  0xA0, 0x37, 0x30, 0x20, 0xAF, 0x90, 0x87, 0x04, 0xF0, 0xD0, 0x37, 0x70, 0x30, 0xDF, 0x04, 0x60,
  0xDE, 0x0B, 0x01, 0x77, 0x30, 0xBE, 0x0E, 0x01, 0x40, 0x8E, 0x0B, 0x77, 0x60, 0xBE, 0x08, 0x30,
  0x1E, 0x0D, 0x01, 0x77, 0x60, 0x10, 0xDD, 0x0E, 0x01, 0x20, 0x7E, 0x03, 0x77, 0x71, 0x03, 0xE0,
  0x72, 0x0D, 0xD0, 0x97, 0x77, 0x30, 0xAD, 0x81, 0xD0, 0x2E, 0x02, 0x77, 0x73, 0x02, 0xE0, 0x20,
  0x6D, 0x0B, 0x77, 0x75, 0x0B, 0xD0, 0x20, 0xAD, 0x07, 0x77, 0x75, 0x04, 0xC8, 0x1C, 0x0C, 0xD0,
  0x37, 0x77, 0x68, 0x56, 0xDE, 0xA1, 0x0D, 0xD0, 0x17, 0x77, 0x75, 0x0E, 0xD7, 0x77, 0x76, 0x0E,
  0xD7, 0x77, 0x76, 0x0D, 0xD0, 0x17, 0x77, 0x75, 0x0C, 0xD0, 0x37, 0x77, 0x68, 0x56, 0xDE, 0xA1,
  0x0A, 0xD0, 0x77, 0x77, 0x50, 0x4C, 0x81, 0xC0, 0x6D, 0x0B, 0x77, 0x75, 0x0B, 0xD0, 0x02, 0xE0,
  0x27, 0x77, 0x30, 0x2E, 0x81, 0x20, 0xDD, 0x09, 0x77, 0x73, 0x09, 0xD0, 0xD2, 0x07, 0xE0, 0x37,
  0x77, 0x10, 0x3E, 0x07, 0x20, 0x1E, 0x0D, 0x01, 0x77, 0x70, 0xDD, 0x0E, 0x01, 0x30, 0x8E, 0x0B,
  0x77, 0x60, 0xBE, 0x08, 0x50, 0xDE, 0x0B, 0x01, 0x77, 0x30, 0xBE, 0x0E, 0x01, 0x50, 0x4F, 0x0D,
  0x03, 0x77, 0x03, 0x0D, 0xF0, 0x47, 0x08, 0xF9, 0x0A, 0x03, 0x73, 0x02, 0x0A, 0xF9, 0x08, 0x72,
  0x0A, 0xFA, 0x0C, 0x04, 0x60, 0x40, 0xCF, 0xA0, 0xA7, 0x40, 0xAF, 0xB0, 0x54, 0x06, 0xFB, 0x0A,
  0x76, 0x08, 0xFA, 0x0D, 0x40, 0xDF, 0xA0, 0x87, 0x71, 0x05, 0x0D, 0xF0, 0xE4, 0x0E, 0xF0, 0xE0,
  0x47, 0x74, 0x08, 0xE0, 0xA4, 0x0A, 0xD8, 0x1E, 0x81, 0x77, 0x68, 0x11, 0x7D, 0xA0, 0xB0, 0x14,
  0x01, 0x0C, 0xA8, 0x1D, 0x71, 0x77, 0x74, 0x01, 0x02, 0x71, 0x02, 0x01, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_donut_large() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_donut_large_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_donut_small 48x48, 4-bit Alpha,  RLE, 280 bytes.
static const unsigned char ic_round_48_action_donut_small_data[] PROGMEM = {
  0x77, 0x82, 0x38, 0x81, 0x48, 0x21, 0x88, 0x47, 0x77, 0x48, 0x12, 0x9E, 0xB0, 0xB4, 0x0A, 0xB8,
  0x1E, 0x92, 0x77, 0x60, 0x20, 0x9F, 0x40, 0xEE, 0x0A, 0x02, 0x77, 0x30, 0x50, 0xEF, 0x94, 0x0E,
  0xF0, 0xE0, 0x77, 0x71, 0x09, 0xFB, 0x40, 0xEF, 0xA0, 0xA7, 0x60, 0xBF, 0xC4, 0x0E, 0xFB, 0x0C,
  0x01, 0x73, 0x0B, 0xFD, 0x40, 0xEF, 0xC0, 0xC7, 0x20, 0x9F, 0xE4, 0x0E, 0xFD, 0x0A, 0x70, 0x5F,
  0xF4, 0x0E, 0xFE, 0x06, 0x50, 0x10, 0xEF, 0xF4, 0x0E, 0xFE, 0x0E, 0x02, 0x40, 0x9F, 0xF9, 0x40,
  0xEF, 0xF0, 0xA3, 0x01, 0xFF, 0xA4, 0x0E, 0xFF, 0x90, 0x22, 0x07, 0xFF, 0xA4, 0x0E, 0xFF, 0x90,
  0x92, 0x0D, 0xFF, 0xA4, 0x0E, 0xFF, 0x98, 0x1E, 0x02, 0xFF, 0xB4, 0x0E, 0xFF, 0xA0, 0x40, 0x6F,
  0xFB, 0x40, 0xEF, 0xFA, 0x08, 0x0A, 0xFF, 0xB4, 0x0C, 0xFF, 0xA0, 0x80, 0xCF, 0xFB, 0x40, 0x30,
  0xDF, 0xF8, 0x1B, 0x1D, 0xFF, 0xB7, 0x77, 0x10, 0xEF, 0xFB, 0x77, 0x71, 0x0E, 0xFF, 0xB7, 0x77,
  0x10, 0xDF, 0xFB, 0x77, 0x71, 0x0C, 0xFF, 0xB4, 0x03, 0x0D, 0xFF, 0x81, 0xB1, 0xAF, 0xFB, 0x40,
  0xCF, 0xFA, 0x08, 0x06, 0xFF, 0xB4, 0x0E, 0xFF, 0xA0, 0x80, 0x2F, 0xFB, 0x40, 0xEF, 0xFA, 0x81,
  0x40, 0xDF, 0xFA, 0x40, 0xEF, 0xF9, 0x0E, 0x20, 0x7F, 0xFA, 0x40, 0xEF, 0xF9, 0x09, 0x20, 0x1F,
  0xFA, 0x40, 0xEF, 0xF9, 0x02, 0x30, 0x9F, 0xF9, 0x40, 0xEF, 0xF0, 0xA4, 0x01, 0x0E, 0xFF, 0x40,
  0xEF, 0xE0, 0xE0, 0x25, 0x05, 0xFF, 0x40, 0xEF, 0xE0, 0x77, 0x09, 0xFE, 0x40, 0xEF, 0xD0, 0xA7,
  0x20, 0xBF, 0xD4, 0x0E, 0xFC, 0x0C, 0x74, 0x0B, 0xFC, 0x40, 0xEF, 0xB0, 0xC0, 0x17, 0x50, 0x9F,
  0xB4, 0x0E, 0xFA, 0x0B, 0x77, 0x10, 0x50, 0xEF, 0x94, 0x0E, 0xF0, 0xE0, 0x77, 0x73, 0x02, 0x09,
  0xF4, 0x0E, 0xE0, 0xA0, 0x27, 0x76, 0x81, 0x29, 0xEB, 0x0B, 0x40, 0xAB, 0x81, 0xE9, 0x27, 0x77,
  0x48, 0x23, 0x88, 0x14, 0x82, 0x18, 0x84, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_donut_small() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_donut_small_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_drag_indicator 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_round_48_action_drag_indicator_data[] PROGMEM = {
  0x18, 0x41, 0xAD, 0xDA, 0x16, 0x87, 0x1A, 0xDD, 0xA1, 0x01, 0xEC, 0x0E, 0x01, 0x40, 0x10, 0xEC,
  0x81, 0xE1, 0xAE, 0x0A, 0x40, 0xAE, 0x0A, 0x0D, 0xE0, 0xD4, 0x0D, 0xE0, 0x0D, 0xE0, 0xD4, 0x0D,
  0xE0, 0xD0, 0xAE, 0x0A, 0x40, 0xAE, 0x81, 0xA1, 0xEC, 0x0E, 0x01, 0x40, 0x10, 0xEC, 0x87, 0xE1,
  0x01, 0xAD, 0xDA, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x80, 0x99, 0x60, 0x84, 0x1A, 0xDD, 0xA1, 0x68,
  0x71, 0xAD, 0xDA, 0x10, 0x1E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC8, 0x1E, 0x1A, 0xE0, 0xA4, 0x0A,
  0xE0, 0xA0, 0xDE, 0x0D, 0x40, 0xDE, 0x00, 0xDE, 0x0D, 0x40, 0xDE, 0x0D, 0x0A, 0xE0, 0xA4, 0x0A,
  0xE8, 0x1A, 0x1E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC8, 0x7E, 0x10, 0x1A, 0xDD, 0xA1, 0x68, 0x41,
  0xAD, 0xDA, 0x18, 0x09, 0x96, 0x08, 0x41, 0xAD, 0xDA, 0x16, 0x87, 0x1A, 0xDD, 0xA1, 0x01, 0xEC,
  0x0E, 0x01, 0x40, 0x10, 0xEC, 0x81, 0xE1, 0xAE, 0x0A, 0x40, 0xAE, 0x0A, 0x0D, 0xE0, 0xD4, 0x0D,
  0xE0, 0x0D, 0xE0, 0xD4, 0x0D, 0xE0, 0xD0, 0xAE, 0x0A, 0x40, 0xAE, 0x81, 0xA1, 0xEC, 0x0E, 0x01,
  0x40, 0x10, 0xEC, 0x87, 0xE1, 0x01, 0xAD, 0xDA, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_drag_indicator() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 8, 33, 39), Box(0, 0, 47, 47),
      ic_round_48_action_drag_indicator_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_dynamic_form 48x48, 4-bit Alpha,  RLE, 184 bytes.
static const unsigned char ic_round_48_action_dynamic_form_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xC4, 0x0B, 0xFD, 0x81, 0x41, 0xEF, 0xFE, 0x4F, 0xE0, 0x50, 0xAF, 0xFF,
  0x4F, 0xD8, 0x1E, 0x0D, 0xFF, 0xF4, 0xFD, 0x09, 0x1F, 0xFF, 0x94, 0xFD, 0x03, 0x1E, 0x00, 0x9F,
  0xF4, 0xFC, 0x0C, 0x2D, 0x09, 0x20, 0x9F, 0xE4, 0xFC, 0x06, 0x2D, 0x09, 0x20, 0x9F, 0xE4, 0xFB,
  0x0E, 0x3E, 0x00, 0x9F, 0xF4, 0xFB, 0x09, 0x3F, 0xFF, 0x94, 0xFB, 0x03, 0x30, 0xDF, 0xFF, 0x4F,
  0xD8, 0x1E, 0x3A, 0xFF, 0xF4, 0xFE, 0x81, 0x41, 0xEF, 0xFE, 0x4F, 0xD0, 0xD2, 0x81, 0x1A, 0xDF,
  0xFC, 0x40, 0xBF, 0xC0, 0x67, 0x77, 0x73, 0xF0, 0xE7, 0x77, 0x74, 0xF0, 0x77, 0x77, 0x74, 0xE0,
  0xE0, 0x17, 0x77, 0x74, 0xE0, 0x94, 0x81, 0x1A, 0xDF, 0xFF, 0x94, 0xE0, 0x23, 0x01, 0x0E, 0xFF,
  0xFB, 0x4D, 0x0A, 0x40, 0xAF, 0xFF, 0xC4, 0xD0, 0x34, 0x0D, 0xFF, 0xFC, 0x4C, 0x0C, 0x5F, 0xFF,
  0xD4, 0xC0, 0x55, 0xE0, 0x09, 0xFF, 0xC4, 0xB0, 0xD6, 0xD0, 0x92, 0x09, 0xFF, 0xB4, 0xB0, 0x66,
  0xD0, 0x92, 0x09, 0xFF, 0xB4, 0xA0, 0xE7, 0xE0, 0x09, 0xFF, 0xC4, 0xA0, 0x77, 0xFF, 0xFD, 0x48,
  0x1E, 0xE1, 0x70, 0xDF, 0xFF, 0xC4, 0x03, 0x02, 0x71, 0x0A, 0xFF, 0xFC, 0x77, 0x01, 0x0E, 0xFF,
  0xFB, 0x77, 0x18, 0x11, 0xAD, 0xFF, 0xF9, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_dynamic_form() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_dynamic_form_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_eco 48x48, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_round_48_action_eco_data[] PROGMEM = {
  0x77, 0x73, 0x86, 0x24, 0x67, 0x9B, 0xC3, 0x77, 0x48, 0x31, 0x47, 0xAC, 0xF9, 0x0C, 0x77, 0x82,
  0x14, 0x8D, 0xFE, 0x0B, 0x74, 0x81, 0x16, 0xBF, 0xFB, 0x09, 0x72, 0x03, 0x0A, 0xFF, 0xE0, 0x77,
  0x03, 0x0B, 0xFF, 0xF9, 0x06, 0x50, 0x10, 0xAF, 0xFF, 0xB0, 0x44, 0x03, 0x0D, 0xFF, 0xFC, 0x02,
  0x30, 0x3F, 0xFF, 0xE3, 0x01, 0x0E, 0xFF, 0xFD, 0x0C, 0x30, 0xCF, 0xFF, 0xE0, 0xA2, 0x05, 0xFF,
  0xFF, 0x07, 0x20, 0xDF, 0xF9, 0x0C, 0x0E, 0xFC, 0x81, 0x40, 0x3F, 0xF8, 0x1E, 0x6B, 0xFD, 0x81,
  0x10, 0x8F, 0xE8, 0x1A, 0x2B, 0xFD, 0x0D, 0x20, 0xCF, 0xD8, 0x17, 0x0B, 0xFE, 0x08, 0x20, 0xEF,
  0xB8, 0x2E, 0x50, 0x8F, 0xF0, 0x42, 0xFB, 0x82, 0xE3, 0x05, 0xFF, 0x90, 0x12, 0xFB, 0x82, 0x30,
  0x1E, 0xFF, 0x0B, 0x30, 0xEF, 0x90, 0x52, 0x0A, 0xFF, 0x90, 0x63, 0x0D, 0xF0, 0x72, 0x04, 0xFF,
  0xA0, 0x13, 0x08, 0xE0, 0xB3, 0x0C, 0xFF, 0x90, 0xA4, 0x04, 0xD0, 0xE0, 0x12, 0x05, 0xFF, 0xA0,
  0x35, 0x0E, 0xC0, 0x53, 0x0C, 0xFF, 0x90, 0xB6, 0x06, 0xB0, 0xB3, 0x03, 0xFF, 0xA0, 0x37, 0x0D,
  0xA0, 0x23, 0x09, 0xFF, 0x90, 0xA7, 0x18, 0x12, 0xEA, 0x40, 0xEF, 0xF0, 0xD0, 0x17, 0x20, 0x50,
  0x23, 0x04, 0xFF, 0x90, 0x37, 0x71, 0x08, 0xFE, 0x0E, 0x04, 0x77, 0x20, 0xCF, 0xD0, 0xC0, 0x27,
  0x73, 0x0D, 0xFB, 0x0D, 0x06, 0x77, 0x68, 0x24, 0x8C, 0xEA, 0x82, 0xEC, 0x84, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_eco() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_eco_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_edit_calendar 48x48, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_round_48_action_edit_calendar_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x72, 0x82, 0x4D, 0xD4, 0x77, 0x30, 0xDA, 0x0D, 0x77, 0x20, 0xDA, 0x0D,
  0x77, 0x3C, 0x77, 0x2C, 0x77, 0x3C, 0x77, 0x2C, 0x75, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1,
  0x60, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50, 0x9F, 0xFF, 0xFE, 0x0A, 0x50, 0xDF, 0xFF, 0xFE,
  0x0D, 0x58, 0x0C, 0x0F, 0x58, 0x0C, 0x0F, 0x58, 0x0C, 0x0F, 0x58, 0x0C, 0x0F, 0x58, 0x0C, 0x0F,
  0x58, 0x0C, 0x0F, 0x58, 0x0C, 0x0F, 0x58, 0x0C, 0x0F, 0x5C, 0x77, 0x77, 0xC5, 0xC7, 0x77, 0x7C,
  0x5C, 0x77, 0x77, 0xC5, 0xC7, 0x77, 0x7C, 0x5C, 0x80, 0xC1, 0x0C, 0x80, 0xC1, 0x0C, 0x80, 0xC1,
  0x0C, 0x77, 0x77, 0x40, 0x30, 0x13, 0xC7, 0x77, 0x73, 0x0A, 0xA0, 0x62, 0xC7, 0x77, 0x72, 0x0A,
  0xC0, 0x61, 0xC7, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x1C, 0x77, 0x77, 0x83, 0x91, 0x03, 0xEB, 0x02,
  0xC7, 0x77, 0x68, 0x7B, 0xFD, 0x10, 0x3E, 0xFA, 0x1C, 0x77, 0x75, 0x0B, 0xB8, 0x3D, 0x10, 0x3A,
  0x2C, 0x77, 0x74, 0x0B, 0xD0, 0xD0, 0x14, 0xC7, 0x77, 0x30, 0xBF, 0x09, 0x4C, 0x77, 0x72, 0x0B,
  0xF0, 0xB5, 0xC7, 0x77, 0x10, 0xBF, 0x0B, 0x6C, 0x77, 0x70, 0xBF, 0x0B, 0x7C, 0x77, 0x60, 0xBF,
  0x0B, 0x71, 0x0D, 0xFF, 0xB5, 0x0B, 0xF0, 0xB7, 0x20, 0xAF, 0xFB, 0x40, 0x9F, 0x0B, 0x73, 0x01,
  0x0E, 0xFF, 0xA4, 0x0E, 0xE0, 0xB7, 0x58, 0x11, 0xAD, 0xFF, 0x4E, 0x0B, 0x77, 0x77, 0x6D, 0x0B,
  0x77, 0x77, 0x70, 0xBA, 0x0E, 0x09, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_edit_calendar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 46, 45), Box(0, 0, 47, 47),
      ic_round_48_action_edit_calendar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_edit_off 48x48, 4-bit Alpha,  RLE, 340 bytes.
static const unsigned char ic_round_48_action_edit_off_data[] PROGMEM = {
  0x18, 0x12, 0x74, 0x77, 0x75, 0x82, 0x1B, 0xE8, 0x50, 0x20, 0xEA, 0x08, 0x77, 0x73, 0x01, 0x0D,
  0xB0, 0xA4, 0x05, 0xC0, 0x87, 0x77, 0x10, 0x10, 0xDD, 0x0A, 0x30, 0x10, 0xEC, 0x07, 0x77, 0x60,
  0x10, 0xDF, 0x0A, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x50, 0x6F, 0xA0, 0xA3, 0x03, 0x0E, 0xC0, 0x77,
  0x75, 0x07, 0xFA, 0x08, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x02, 0x03, 0x30, 0x7F, 0x90, 0xE4, 0x03,
  0x0E, 0xC0, 0x77, 0x58, 0x22, 0xDE, 0x43, 0x07, 0xF0, 0xB5, 0x03, 0x0E, 0xC0, 0x77, 0x30, 0x20,
  0xDA, 0x0E, 0x04, 0x30, 0x7D, 0x0D, 0x01, 0x60, 0x30, 0xEC, 0x07, 0x71, 0x02, 0x0D, 0xC0, 0xE0,
  0x43, 0x07, 0xB0, 0xD0, 0x17, 0x10, 0x30, 0xEC, 0x07, 0x60, 0x20, 0xDE, 0x0E, 0x04, 0x38, 0x27,
  0xFD, 0x17, 0x30, 0x30, 0xEC, 0x07, 0x50, 0xAF, 0x90, 0xE0, 0x43, 0x06, 0x01, 0x75, 0x03, 0x0E,
  0xC0, 0x75, 0x0C, 0xF9, 0x0E, 0x04, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0x90, 0xE0, 0x37,
  0x73, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xF0, 0xD0, 0x17, 0x74, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xD0,
  0xD0, 0x17, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB0, 0xD0, 0x17, 0x77, 0x02, 0x0D, 0xD0, 0x75,
  0x82, 0xCF, 0xD1, 0x77, 0x70, 0x20, 0xDF, 0x07, 0x50, 0xA0, 0x17, 0x77, 0x02, 0x0D, 0xFA, 0x07,
  0x77, 0x75, 0x02, 0x0D, 0xFC, 0x07, 0x77, 0x73, 0x02, 0x0D, 0xFE, 0x07, 0x77, 0x71, 0x02, 0x0D,
  0xFF, 0x90, 0x77, 0x76, 0x02, 0x0D, 0xFF, 0xB0, 0x77, 0x74, 0x01, 0x0D, 0xFE, 0x0D, 0x0E, 0xC0,
  0x77, 0x72, 0x01, 0x0D, 0xFE, 0x82, 0xD1, 0x3E, 0xC0, 0x77, 0x70, 0x10, 0xDF, 0xE0, 0xD0, 0x12,
  0x03, 0x0E, 0xC0, 0x77, 0x50, 0x10, 0xDF, 0xE0, 0xD0, 0x14, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0xDF,
  0xE0, 0xD0, 0x16, 0x03, 0x0E, 0xC0, 0x77, 0x3F, 0xE0, 0xD0, 0x17, 0x10, 0x30, 0xEC, 0x07, 0x72,
  0xFD, 0x0D, 0x01, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x1F, 0xC0, 0xD0, 0x17, 0x50, 0x30, 0xEC, 0x07,
  0x7F, 0xB0, 0xD0, 0x17, 0x70, 0x30, 0xEC, 0x07, 0x6F, 0xA0, 0xD0, 0x17, 0x72, 0x03, 0x0E, 0xC0,
  0x75, 0xF9, 0x0D, 0x01, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x40, 0xBE, 0x0D, 0x01, 0x77, 0x60, 0x30,
  0xEC, 0x03, 0x77, 0x77, 0x50, 0x30, 0xEB, 0x07, 0x77, 0x77, 0x68, 0x33, 0xEF, 0xE2, 0x77, 0x77,
  0x78, 0x11, 0x51, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_edit_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 41, 44), Box(0, 0, 47, 47),
      ic_round_48_action_edit_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_eject 48x48, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_round_48_action_eject_data[] PROGMEM = {
  0x76, 0x00, 0x47, 0x77, 0x40, 0x9A, 0x09, 0x77, 0x72, 0x05, 0xC0, 0x57, 0x77, 0x01, 0x0E, 0xC0,
  0xE0, 0x17, 0x76, 0x0A, 0xE0, 0xA7, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x30, 0x10, 0xEF, 0x90, 0xE0,
  0x17, 0x72, 0x0A, 0xFB, 0x0A, 0x77, 0x10, 0x5F, 0xD0, 0x57, 0x60, 0x10, 0xEF, 0xD0, 0xE0, 0x17,
  0x50, 0xAF, 0xF0, 0xA7, 0x40, 0x5F, 0xFA, 0x05, 0x72, 0x01, 0x0E, 0xFF, 0xA0, 0xE0, 0x17, 0x10,
  0xAF, 0xFC, 0x0A, 0x70, 0x5F, 0xFE, 0x05, 0x50, 0x10, 0xEF, 0xFE, 0x0E, 0x01, 0x40, 0x7F, 0xFF,
  0x90, 0x74, 0x07, 0xFF, 0xF9, 0x07, 0x50, 0xAF, 0xFE, 0x0A, 0x80, 0x9D, 0x70, 0x04, 0x0D, 0xFF,
  0xFB, 0x81, 0xD4, 0xDF, 0xFF, 0xD0, 0x0D, 0xFF, 0xFD, 0x81, 0xD4, 0xDF, 0xFF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_eject() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 11, 37, 37), Box(0, 0, 47, 47),
      ic_round_48_action_eject_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_euro_symbol 48x48, 4-bit Alpha,  RLE, 223 bytes.
static const unsigned char ic_round_48_action_euro_symbol_data[] PROGMEM = {
  0x77, 0x48, 0x31, 0x59, 0xCD, 0xA8, 0x3D, 0xC9, 0x61, 0x77, 0x70, 0x40, 0xBF, 0xD0, 0xB0, 0x57,
  0x73, 0x03, 0x0C, 0xFF, 0xA0, 0xC0, 0x37, 0x70, 0x9F, 0xFE, 0x03, 0x74, 0x01, 0x0B, 0xFF, 0xF0,
  0x97, 0x40, 0xCF, 0x82, 0xC7, 0x41, 0x28, 0x21, 0x47, 0xDD, 0x08, 0x73, 0x0B, 0xE0, 0xB0, 0x37,
  0x30, 0x30, 0xBA, 0x0D, 0x01, 0x72, 0x08, 0xD0, 0xE0, 0x67, 0x70, 0x20, 0x47, 0x30, 0x3D, 0x0E,
  0x03, 0x77, 0x76, 0x0C, 0xD0, 0x37, 0x77, 0x60, 0x4D, 0x06, 0x77, 0x77, 0x0B, 0xC0, 0xC7, 0x77,
  0x10, 0x40, 0xDF, 0xFE, 0x0D, 0x04, 0x74, 0x0D, 0xFF, 0xF9, 0x0D, 0x74, 0x0D, 0xFF, 0xF9, 0x0D,
  0x74, 0x04, 0x0D, 0xFF, 0xE0, 0xD0, 0x47, 0x73, 0x0E, 0xC0, 0x17, 0x77, 0x71, 0xD7, 0x77, 0x72,
  0xD7, 0x77, 0x72, 0x0E, 0xC0, 0x17, 0x77, 0x20, 0x40, 0xDF, 0xFE, 0x0D, 0x04, 0x74, 0x0D, 0xFF,
  0xF9, 0x0D, 0x74, 0x0D, 0xFF, 0xF9, 0x0D, 0x74, 0x04, 0x0D, 0xFF, 0xE0, 0xD0, 0x47, 0x74, 0x0B,
  0xC0, 0xC7, 0x77, 0x71, 0x04, 0xD0, 0x67, 0x77, 0x71, 0x0C, 0xD0, 0x37, 0x77, 0x70, 0x3D, 0x0E,
  0x03, 0x77, 0x77, 0x08, 0xD0, 0xE0, 0x67, 0x70, 0x20, 0x47, 0x50, 0xBE, 0x0B, 0x03, 0x73, 0x03,
  0x0B, 0xA0, 0xD0, 0x17, 0x40, 0xCF, 0x82, 0xC7, 0x41, 0x28, 0x21, 0x47, 0xCD, 0x08, 0x74, 0x01,
  0x0B, 0xFF, 0xF0, 0x97, 0x60, 0x9F, 0xFE, 0x03, 0x77, 0x03, 0x0C, 0xFF, 0xA0, 0xC0, 0x37, 0x73,
  0x04, 0x0B, 0xFD, 0x0B, 0x05, 0x77, 0x78, 0x31, 0x59, 0xCD, 0xA8, 0x3D, 0xC9, 0x61, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_euro_symbol() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 40, 41), Box(0, 0, 47, 47),
      ic_round_48_action_euro_symbol_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_event 48x48, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_round_48_action_event_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x72, 0x82, 0x4D, 0xD4, 0x75, 0x0D, 0xA0, 0xD7, 0x72, 0x0D, 0xA0, 0xD7,
  0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x4D, 0xA1, 0x01, 0xEF,
  0xFF, 0xFC, 0x81, 0xE1, 0x9F, 0xFF, 0xFE, 0x0A, 0x0D, 0xFF, 0xFF, 0xE0, 0xD8, 0x0B, 0xB0, 0xF7,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77,
  0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x70, 0x40, 0xDE, 0x0D, 0x04, 0x4F, 0x97, 0x70,
  0xDF, 0x90, 0xD4, 0xF9, 0x77, 0xFB, 0x4F, 0x97, 0x7F, 0xB4, 0xF9, 0x77, 0xFB, 0x4F, 0x97, 0x7F,
  0xB4, 0xF9, 0x77, 0xFB, 0x4F, 0x97, 0x7F, 0xB4, 0xF9, 0x77, 0x0D, 0xF9, 0x0D, 0x4F, 0x97, 0x70,
  0x40, 0xDE, 0x0D, 0x04, 0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x90, 0x17, 0x77, 0x50, 0x1F,
  0x90, 0xB0, 0x17, 0x77, 0x30, 0x10, 0xBC, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81,
  0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_event() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_event_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_event_repeat 48x48, 4-bit Alpha,  RLE, 255 bytes.
static const unsigned char ic_round_48_action_event_repeat_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x72, 0x82, 0x4D, 0xD4, 0x77, 0x40, 0xDA, 0x0D, 0x77, 0x20, 0xDA, 0x0D,
  0x77, 0x4C, 0x77, 0x2C, 0x77, 0x4C, 0x77, 0x2C, 0x76, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1,
  0x70, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x60, 0xAF, 0xFF, 0xFE, 0x0A, 0x60, 0xDF, 0xFF, 0xFE,
  0x0D, 0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F,
  0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F, 0x6C, 0x77, 0x77, 0xC6, 0xC7, 0x77, 0x7C,
  0x6C, 0x77, 0x77, 0xC6, 0xC7, 0x77, 0x7C, 0x6C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x80, 0xC2,
  0x0C, 0x80, 0xC2, 0x0C, 0x77, 0x48, 0x18, 0xE8, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56, 0xC7, 0x74,
  0xB1, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x4C, 0x77, 0x4B, 0x08, 0xFD, 0x08, 0x3C, 0x77, 0x4E, 0x81,
  0xE7, 0x22, 0x81, 0x27, 0xEB, 0x08, 0x2C, 0x77, 0x4D, 0x0A, 0x71, 0x0A, 0xB0, 0x41, 0xC7, 0x74,
  0xF0, 0x87, 0x0A, 0xA0, 0xD1, 0xC7, 0x74, 0x0D, 0xE0, 0xE7, 0x10, 0xEA, 0x05, 0xC7, 0x74, 0x04,
  0x0D, 0xD0, 0x87, 0x10, 0x7A, 0x09, 0xC7, 0x77, 0x76, 0x02, 0xA0, 0xDC, 0x77, 0x77, 0x7A, 0x0E,
  0xC7, 0x77, 0x77, 0xA0, 0xEC, 0x77, 0x77, 0x60, 0x2A, 0x00, 0xDF, 0xFB, 0x58, 0x1B, 0xE4, 0x75,
  0x07, 0xA0, 0x90, 0xAF, 0xFB, 0x40, 0x2A, 0x0E, 0x01, 0x74, 0x0E, 0xA8, 0x15, 0x1E, 0xFF, 0xA5,
  0x0D, 0xA0, 0xA7, 0x30, 0xAA, 0x0D, 0x28, 0x11, 0xAD, 0xFF, 0x50, 0x4B, 0x0B, 0x71, 0x0A, 0xB0,
  0x47, 0x77, 0x40, 0x8B, 0x86, 0xE8, 0x31, 0x02, 0x7E, 0xB0, 0x87, 0x77, 0x60, 0x8F, 0xD0, 0x87,
  0x77, 0x71, 0x05, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x77, 0x48, 0x65, 0xAD, 0xFE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_event_repeat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 47, 47), Box(0, 0, 47, 47),
      ic_round_48_action_event_repeat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_event_seat 48x48, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_round_48_action_event_seat_data[] PROGMEM = {
  0x74, 0x81, 0x1A, 0xDF, 0xD8, 0x1D, 0xA1, 0x77, 0x70, 0x10, 0xEF, 0xFA, 0x0E, 0x01, 0x77, 0x60,
  0xAF, 0xFC, 0x0A, 0x77, 0x60, 0xDF, 0xFC, 0x0D, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F,
  0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE,
  0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x73, 0x04, 0x0D, 0xA0, 0xD0, 0x44, 0xFF, 0xE4, 0x04, 0x0D,
  0xA8, 0x1D, 0x4D, 0xC0, 0xD4, 0xFF, 0xE4, 0x0D, 0xC0, 0xDE, 0x4F, 0xFE, 0x4F, 0xD4, 0xFF, 0xE4,
  0xE0, 0xDC, 0x0D, 0x4F, 0xFE, 0x40, 0xDC, 0x81, 0xD4, 0xDA, 0x0D, 0x04, 0x4F, 0xFE, 0x40, 0x40,
  0xDA, 0x0D, 0x04, 0x80, 0xAC, 0x10, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E,
  0xFF, 0xFF, 0x0E, 0x01, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71,
  0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC, 0x71, 0xE7, 0x76, 0xE7, 0x1E, 0x77, 0x6E, 0x71, 0xE7, 0x76,
  0xE7, 0x10, 0xDC, 0x0D, 0x77, 0x60, 0xDC, 0x0D, 0x71, 0x08, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0x87,
  0x28, 0x28, 0xDD, 0x87, 0x77, 0x18, 0x28, 0xDD, 0x85,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_event_seat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_event_seat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_exit_to_app 48x48, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_round_48_action_exit_to_app_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC0, 0xB0, 0x17, 0x77, 0x30, 0x10, 0xBF, 0x90, 0x17, 0x77,
  0x50, 0x1F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x50, 0x01, 0x77, 0xF9, 0x74, 0x06, 0xA0,
  0x77, 0x6C, 0x0D, 0xA0, 0xD7, 0x40, 0xEB, 0x07, 0x75, 0xC8, 0x24, 0xDD, 0x47, 0x40, 0xCC, 0x07,
  0x74, 0xC7, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x3C, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x72, 0xC7, 0x73,
  0x03, 0x0E, 0xC0, 0x77, 0x1C, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x7C, 0x04, 0x0D, 0xFF, 0xFA, 0x07,
  0x6C, 0x0D, 0xFF, 0xFC, 0x01, 0x5C, 0x0D, 0xFF, 0xFC, 0x01, 0x5C, 0x04, 0x0D, 0xFF, 0xFA, 0x07,
  0x6C, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x7C, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x71, 0xC7, 0x72, 0x03,
  0x0E, 0xC0, 0x77, 0x2C, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x73, 0xC8, 0x24, 0xDD, 0x47, 0x40, 0xCC,
  0x07, 0x74, 0xC0, 0xDA, 0x0D, 0x74, 0x0E, 0xB0, 0x77, 0x5F, 0x97, 0x40, 0x6A, 0x07, 0x76, 0xF9,
  0x75, 0x00, 0x17, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x90,
  0xB0, 0x17, 0x77, 0x30, 0x10, 0xBC, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1,
  0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_exit_to_app() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_exit_to_app_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_expand 48x48, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_round_48_action_expand_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF,
  0xFF, 0xF0, 0xD0, 0x48, 0x09, 0x93, 0x00, 0x05, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x76, 0x07,
  0xC0, 0x77, 0x77, 0x40, 0x7E, 0x07, 0x77, 0x72, 0x07, 0xF9, 0x07, 0x77, 0x70, 0x7F, 0xB0, 0x77,
  0x75, 0x05, 0xFD, 0x05, 0x77, 0x40, 0x5F, 0xD0, 0x57, 0x77, 0x2C, 0x77, 0x77, 0xC7, 0x77, 0x7C,
  0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77,
  0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x20, 0x5F, 0xD0, 0x57, 0x74, 0x05, 0xFD, 0x05,
  0x77, 0x50, 0x7F, 0xB0, 0x77, 0x77, 0x07, 0xF9, 0x07, 0x77, 0x72, 0x07, 0xE0, 0x77, 0x77, 0x40,
  0x7C, 0x07, 0x77, 0x76, 0x07, 0xA0, 0x77, 0x77, 0x71, 0x00, 0x58, 0x09, 0x93, 0x00, 0x40, 0xDF,
  0xFF, 0xF8, 0x1D, 0x4D, 0xFF, 0xFF, 0xA0, 0x0D, 0xFF, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xFF, 0x0D,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_expand() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_expand_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_explore_off 48x48, 4-bit Alpha,  RLE, 350 bytes.
static const unsigned char ic_round_48_action_explore_off_data[] PROGMEM = {
  0x77, 0x83, 0x36, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x7D, 0xFD, 0x81, 0xD8,
  0x17, 0x77, 0x08, 0xFF, 0xC0, 0x90, 0x17, 0x74, 0x0A, 0xFF, 0xE0, 0xE0, 0x57, 0x20, 0x5A, 0x07,
  0x50, 0xCF, 0xFF, 0x09, 0x71, 0x0D, 0xB0, 0x75, 0x0C, 0xFF, 0xF0, 0xA7, 0x0C, 0xC0, 0x75, 0x0C,
  0xFF, 0xF0, 0xA6, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xF0, 0x96, 0x03, 0x0E, 0xC0, 0x75, 0x0C,
  0xFF, 0x90, 0xA0, 0x7C, 0x05, 0x60, 0xED, 0x07, 0x50, 0xCF, 0xD8, 0x29, 0x20, 0xAC, 0x0E, 0x01,
  0x40, 0x7F, 0x07, 0x50, 0xCF, 0x98, 0x1E, 0x81, 0x20, 0x2E, 0x09, 0x30, 0x10, 0xEF, 0x90, 0x75,
  0x0C, 0xD8, 0x1E, 0x71, 0x40, 0x9F, 0x01, 0x20, 0x7F, 0xB0, 0x75, 0x0C, 0xA0, 0xD0, 0x66, 0x01,
  0xF9, 0x08, 0x20, 0xCF, 0xC0, 0x75, 0x09, 0x05, 0x71, 0x08, 0xF9, 0x81, 0xD0, 0x2F, 0xE0, 0x77,
  0x60, 0x10, 0xEF, 0xA0, 0x30, 0x6F, 0xF0, 0x77, 0x50, 0x7F, 0xB0, 0x70, 0x9F, 0xF9, 0x07, 0x74,
  0x0E, 0xFB, 0x0A, 0x0B, 0xFF, 0xA0, 0x77, 0x20, 0x6F, 0xC0, 0xC0, 0xDF, 0xFB, 0x07, 0x71, 0x0D,
  0xFC, 0x00, 0xEF, 0xD0, 0xD0, 0xEC, 0x07, 0x60, 0x5F, 0xE0, 0xEF, 0xD8, 0x15, 0x3E, 0xC0, 0x75,
  0x09, 0xFD, 0x0E, 0x0D, 0xFC, 0x0D, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xC0, 0xD0, 0xBF, 0xC0,
  0x63, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFB, 0x0C, 0x0A, 0xFB, 0x0E, 0x50, 0x30, 0xEC, 0x07, 0x50,
  0xCF, 0xA0, 0xA0, 0x7F, 0xB0, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xF9, 0x06, 0x03, 0xFA, 0x0E,
  0x01, 0x70, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0x81, 0x30, 0xEF, 0x90, 0x87, 0x10, 0x50, 0xDD, 0x07,
  0x50, 0xCD, 0x0D, 0x20, 0x8F, 0x90, 0x16, 0x06, 0x0D, 0xF9, 0x07, 0x50, 0xCC, 0x07, 0x20, 0x1F,
  0x09, 0x48, 0x11, 0x7E, 0xFC, 0x07, 0x50, 0xCB, 0x01, 0x30, 0x9E, 0x02, 0x28, 0x11, 0x8E, 0xFF,
  0x07, 0x58, 0x1C, 0xF8, 0x40, 0x10, 0xEC, 0x82, 0xA0, 0x29, 0xFF, 0xC0, 0x75, 0x0A, 0x60, 0x5C,
  0x07, 0x0A, 0xFF, 0xF0, 0x77, 0x50, 0x9F, 0xFF, 0xE0, 0x77, 0x50, 0xBF, 0xFF, 0xE0, 0x77, 0x50,
  0xBF, 0xFF, 0xE0, 0x77, 0x50, 0x9F, 0xFF, 0xE0, 0x67, 0x50, 0x50, 0xEF, 0xFE, 0x00, 0xEC, 0x76,
  0x01, 0x09, 0xFF, 0xB8, 0x3E, 0x70, 0x3E, 0xA0, 0xE7, 0x71, 0x81, 0x18, 0xEF, 0xD8, 0x1D, 0x71,
  0x38, 0x23, 0xCD, 0x57, 0x74, 0x89, 0x23, 0x7A, 0xBD, 0xEF, 0xDB, 0x97, 0x27, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_explore_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_explore_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_explore 48x48, 4-bit Alpha,  RLE, 308 bytes.
static const unsigned char ic_round_48_action_explore_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFD, 0x0A, 0x07, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFB, 0x82,
  0x92, 0x0A, 0xC0, 0xE0, 0x14, 0x09, 0xFF, 0xF9, 0x81, 0xE8, 0x12, 0x02, 0xE0, 0x93, 0x01, 0xFF,
  0xF8, 0x1E, 0x71, 0x40, 0x9F, 0x01, 0x20, 0x8F, 0xFD, 0x0D, 0x06, 0x60, 0x1F, 0x90, 0x82, 0x0D,
  0xFF, 0xB0, 0xC0, 0x57, 0x10, 0x8F, 0x98, 0x1D, 0x03, 0xFF, 0xA0, 0xB0, 0x47, 0x20, 0x10, 0xEF,
  0xA0, 0x30, 0x7F, 0xF0, 0xC0, 0x37, 0x40, 0x7F, 0xB0, 0x70, 0xAF, 0xF0, 0x37, 0x50, 0xEF, 0xB0,
  0xA0, 0xCF, 0xE0, 0xB4, 0x00, 0x16, 0x06, 0xFC, 0x0C, 0x0E, 0xFE, 0x04, 0x30, 0x8A, 0x08, 0x50,
  0xDF, 0xC0, 0xEF, 0xE0, 0xC3, 0x01, 0xC0, 0x13, 0x05, 0xFF, 0xFD, 0x05, 0x30, 0x1C, 0x01, 0x30,
  0xCF, 0xE0, 0xEF, 0xC0, 0xD5, 0x08, 0xA0, 0x83, 0x04, 0xFE, 0x0E, 0x0C, 0xFC, 0x06, 0x60, 0x01,
  0x40, 0xBF, 0xE0, 0xC0, 0xAF, 0xB0, 0xE7, 0x50, 0x3F, 0xF0, 0xA0, 0x7F, 0xB0, 0x77, 0x40, 0x30,
  0xCF, 0xF0, 0x70, 0x3F, 0xA0, 0xE0, 0x17, 0x20, 0x40, 0xBF, 0xFA, 0x81, 0x30, 0xDF, 0x90, 0x87,
  0x10, 0x50, 0xCF, 0xFB, 0x0D, 0x20, 0x8F, 0x90, 0x16, 0x06, 0x0D, 0xFF, 0xD0, 0x82, 0x01, 0xF0,
  0x94, 0x81, 0x17, 0xEF, 0xFF, 0x01, 0x30, 0x9E, 0x02, 0x28, 0x11, 0x8E, 0xFF, 0xF9, 0x09, 0x40,
  0x10, 0xEC, 0x82, 0xA0, 0x29, 0xFF, 0xFB, 0x0E, 0x01, 0x50, 0x5C, 0x07, 0x0A, 0xFF, 0xFD, 0x05,
  0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76,
  0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC,
  0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8,
  0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_explore() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_explore_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_extension_off 48x48, 4-bit Alpha,  RLE, 293 bytes.
static const unsigned char ic_round_48_action_extension_off_data[] PROGMEM = {
  0x77, 0x38, 0x44, 0xBE, 0xEB, 0x47, 0x77, 0x77, 0x08, 0xE0, 0x87, 0x77, 0x75, 0x04, 0xF9, 0x04,
  0x77, 0x48, 0x12, 0x74, 0x74, 0x0B, 0xF9, 0x0B, 0x77, 0x30, 0x10, 0xEA, 0x07, 0x73, 0x0E, 0xF9,
  0x0E, 0x77, 0x30, 0x5C, 0x07, 0x50, 0xCF, 0xFF, 0x81, 0xDA, 0x16, 0x01, 0x0E, 0xC0, 0x75, 0x0C,
  0xFF, 0xF9, 0x0E, 0x01, 0x60, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFF, 0x90, 0xA7, 0x03, 0xD0, 0x75,
  0x0C, 0xFF, 0xF0, 0xD7, 0x1E, 0x07, 0x50, 0xCF, 0xFF, 0x71, 0xF0, 0x75, 0x0C, 0xFF, 0xE7, 0x1F,
  0x90, 0x75, 0x0C, 0xFF, 0xD7, 0x1F, 0xA0, 0x75, 0x0C, 0xFF, 0xC7, 0x1F, 0xB0, 0x75, 0x0C, 0xFF,
  0xB7, 0x1F, 0xC0, 0x75, 0x0C, 0xFF, 0xA7, 0x1F, 0xD0, 0x75, 0x0C, 0xFF, 0x97, 0x10, 0x90, 0xBF,
  0xC0, 0x75, 0x0C, 0xFF, 0x74, 0x07, 0xFB, 0x07, 0x50, 0xCF, 0xE8, 0x1E, 0xB4, 0x72, 0x05, 0xFB,
  0x07, 0x50, 0xCF, 0xF9, 0x08, 0x72, 0x0A, 0xFB, 0x07, 0x50, 0xCF, 0xF9, 0x04, 0x71, 0x03, 0xFC,
  0x07, 0x50, 0xCF, 0xF0, 0xB7, 0x2F, 0xD0, 0x75, 0x0C, 0xFE, 0x0E, 0x72, 0xFE, 0x07, 0x50, 0xCF,
  0xD0, 0xE7, 0x10, 0x3F, 0xF0, 0x75, 0x0C, 0xFC, 0x0B, 0x71, 0x09, 0xFF, 0x90, 0x75, 0x0C, 0xFB,
  0x04, 0x70, 0x4F, 0xFB, 0x07, 0x50, 0xCF, 0x90, 0x87, 0x07, 0xFF, 0xD0, 0x75, 0x0C, 0xC8, 0x1E,
  0xB4, 0x50, 0x90, 0xBF, 0xFF, 0x90, 0x75, 0x0C, 0xB7, 0x1F, 0xFF, 0xC0, 0x75, 0x0C, 0xA7, 0x1F,
  0xFF, 0xD0, 0x75, 0x0C, 0x97, 0x1F, 0xFF, 0xE0, 0x75, 0x0C, 0x71, 0xFF, 0xFF, 0x07, 0x76, 0xFF,
  0xFF, 0x90, 0x77, 0x5F, 0xF0, 0x90, 0x32, 0x03, 0x09, 0xFB, 0x07, 0x74, 0xFE, 0x04, 0x60, 0x4F,
  0xB0, 0x77, 0x30, 0xDF, 0xC0, 0x77, 0x10, 0x7F, 0xB0, 0x77, 0x20, 0xAF, 0xC0, 0x17, 0x10, 0x1F,
  0xC0, 0x77, 0x10, 0x10, 0xEF, 0xA0, 0xB7, 0x30, 0xBF, 0xC0, 0x77, 0x18, 0x11, 0xAD, 0xF0, 0xA7,
  0x30, 0xAF, 0xD0, 0x48, 0x0C, 0x00, 0x03, 0x0E, 0xB0, 0x78, 0x0C, 0x10, 0x83, 0x3E, 0xFE, 0x38,
  0x0C, 0x20, 0x81, 0x15, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_extension_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 44, 44), Box(0, 0, 47, 47),
      ic_round_48_action_extension_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_extension 48x48, 4-bit Alpha,  RLE, 240 bytes.
static const unsigned char ic_round_48_action_extension_data[] PROGMEM = {
  0x77, 0x84, 0x4B, 0xEE, 0xB4, 0x77, 0x77, 0x70, 0x8E, 0x08, 0x77, 0x77, 0x50, 0x4F, 0x90, 0x47,
  0x77, 0x74, 0x0B, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0xEF, 0x90, 0xE7, 0x77, 0x74, 0xFB, 0x77, 0x77,
  0x4F, 0xB7, 0x77, 0x74, 0xFB, 0x77, 0x78, 0x11, 0xAD, 0xFF, 0xFD, 0x81, 0xDA, 0x17, 0x20, 0x10,
  0xEF, 0xFF, 0xFA, 0x0E, 0x01, 0x71, 0x09, 0xFF, 0xFF, 0xC0, 0xA7, 0x10, 0xDF, 0xFF, 0xFC, 0x0D,
  0x71, 0xFF, 0xFF, 0xE7, 0x1F, 0xFF, 0xFE, 0x71, 0xFF, 0xFF, 0xE7, 0x1F, 0xFF, 0xFE, 0x71, 0xFF,
  0xFF, 0xE7, 0x1F, 0xFF, 0xFE, 0x71, 0xFF, 0xFF, 0xE7, 0x18, 0x00, 0x90, 0xDF, 0xFF, 0xF9, 0x76,
  0x03, 0x0D, 0xFF, 0xFF, 0xA8, 0x1E, 0xB4, 0x71, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0x87, 0x10, 0x3F,
  0xFF, 0xFD, 0x04, 0x71, 0x0D, 0xFF, 0xFF, 0xC0, 0xB7, 0x10, 0xAF, 0xFF, 0xFC, 0x0E, 0x71, 0x0A,
  0xFF, 0xFF, 0xC0, 0xE7, 0x10, 0xDF, 0xFF, 0xFC, 0x0B, 0x70, 0x3F, 0xFF, 0xFD, 0x04, 0x60, 0x10,
  0xDF, 0xFF, 0xFC, 0x08, 0x60, 0x30, 0xDF, 0xFF, 0xFA, 0x81, 0xEB, 0x42, 0x80, 0x09, 0x0D, 0xFF,
  0xFF, 0x97, 0x1F, 0xFF, 0xFE, 0x71, 0xFF, 0xFF, 0xE7, 0x1F, 0xF9, 0x82, 0xD9, 0x9D, 0xFF, 0x97,
  0x1F, 0xE0, 0xD0, 0x34, 0x03, 0x0D, 0xFE, 0x71, 0xFD, 0x0D, 0x01, 0x60, 0x10, 0xDF, 0xD7, 0x1F,
  0xD0, 0x37, 0x10, 0x3F, 0xD7, 0x1F, 0xC0, 0xD7, 0x30, 0xDF, 0xC7, 0x10, 0xDF, 0xB0, 0xA7, 0x30,
  0xAF, 0xB0, 0xD7, 0x10, 0xAF, 0xB0, 0x97, 0x30, 0x9F, 0xB0, 0xA7, 0x10, 0x10, 0xEF, 0xA0, 0x97,
  0x30, 0x9F, 0xA0, 0xE0, 0x17, 0x28, 0x11, 0xAD, 0xF0, 0x97, 0x30, 0x9F, 0x81, 0xDA, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 45, 43), Box(0, 0, 47, 47),
      ic_round_48_action_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_face 48x48, 4-bit Alpha,  RLE, 332 bytes.
static const unsigned char ic_round_48_action_face_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFC, 0x0D, 0xFF, 0xE0, 0x55, 0x01, 0x0E, 0xFC, 0x01, 0x0A, 0xFF,
  0xD0, 0xE0, 0x14, 0x09, 0xFC, 0x08, 0x20, 0xAF, 0xFD, 0x09, 0x30, 0x1F, 0xC0, 0xE0, 0x13, 0x09,
  0xFF, 0xD0, 0x12, 0x08, 0xFC, 0x05, 0x50, 0x50, 0xEF, 0xFB, 0x08, 0x20, 0xDF, 0xB0, 0x87, 0x01,
  0x08, 0xFF, 0xA8, 0x1D, 0x03, 0xFB, 0x0A, 0x73, 0x81, 0x17, 0xDF, 0xF0, 0x30, 0x7F, 0xA0, 0xA7,
  0x78, 0x33, 0x7A, 0xCD, 0xA8, 0x2D, 0xCA, 0xCB, 0x07, 0x0A, 0xF9, 0x08, 0x77, 0x74, 0x06, 0xB0,
  0xA0, 0xCE, 0x0E, 0x04, 0x77, 0x75, 0x03, 0xB0, 0xC0, 0xED, 0x08, 0x01, 0x77, 0x76, 0x01, 0xB0,
  0xEC, 0x07, 0x01, 0x70, 0x06, 0x73, 0x00, 0x67, 0x2F, 0x97, 0x10, 0xDA, 0x0D, 0x71, 0x0D, 0xA0,
  0xD7, 0x1C, 0x0E, 0xB0, 0x26, 0x06, 0xC0, 0x66, 0x06, 0xC0, 0x66, 0x02, 0xB0, 0xE0, 0xCB, 0x03,
  0x60, 0x6C, 0x06, 0x60, 0x6C, 0x06, 0x60, 0x3B, 0x0C, 0x0A, 0xB0, 0x67, 0x0D, 0xA0, 0xD7, 0x10,
  0xDA, 0x0D, 0x70, 0x6B, 0x0A, 0x07, 0xB0, 0xB7, 0x10, 0x06, 0x73, 0x00, 0x67, 0x10, 0xBB, 0x07,
  0x03, 0xC7, 0x77, 0x72, 0xC8, 0x13, 0x0D, 0xB0, 0x67, 0x77, 0x70, 0x6B, 0x0D, 0x20, 0x8B, 0x0E,
  0x77, 0x77, 0x0E, 0xB0, 0x82, 0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x77,
  0x73, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x50,
  0x5C, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC,
  0x09, 0x72, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0E, 0x06, 0x75, 0x06, 0x0E,
  0xD0, 0xA7, 0x60, 0x9F, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF,
  0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81,
  0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_face() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_face_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_face_unlock 48x48, 4-bit Alpha,  RLE, 386 bytes.
static const unsigned char ic_round_48_action_face_unlock_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFA, 0x0A, 0x01, 0x28, 0x31, 0x36, 0xAE, 0xE0, 0x97, 0x60, 0xAF, 0xC0, 0x37, 0x06, 0x0D,
  0xD0, 0xA7, 0x40, 0xAD, 0x09, 0xE0, 0xD0, 0x17, 0x10, 0x7D, 0x0A, 0x72, 0x09, 0xC8, 0x1D, 0x37,
  0xF0, 0xD0, 0x17, 0x10, 0x30, 0xDC, 0x09, 0x70, 0x5C, 0x82, 0xD1, 0x0D, 0xB0, 0xDC, 0x0D, 0x03,
  0x71, 0x01, 0x0D, 0xC0, 0x55, 0x01, 0x0E, 0xB8, 0x2D, 0x10, 0x8C, 0x01, 0x0A, 0xD0, 0x77, 0x10,
  0x10, 0xDB, 0x0E, 0x01, 0x40, 0x9C, 0x81, 0x30, 0x3C, 0x08, 0x20, 0xAD, 0x0D, 0x06, 0x70, 0x3C,
  0x09, 0x30, 0x1C, 0x82, 0x80, 0x1D, 0xB0, 0xE0, 0x13, 0x09, 0xE8, 0x3E, 0xA6, 0x31, 0x20, 0x10,
  0xAC, 0x01, 0x20, 0x8B, 0x82, 0xD0, 0x1D, 0xC0, 0x55, 0x05, 0x0E, 0xFF, 0xB0, 0x82, 0x0D, 0xB8,
  0x17, 0x3D, 0xC0, 0x87, 0x01, 0x08, 0xFF, 0xA8, 0x1D, 0x03, 0xC0, 0x9D, 0x0A, 0x73, 0x81, 0x17,
  0xDF, 0xF0, 0x30, 0x7F, 0xA0, 0xA7, 0x78, 0x33, 0x7A, 0xCD, 0xA8, 0x2D, 0xCA, 0xCB, 0x07, 0x0A,
  0xF9, 0x08, 0x77, 0x74, 0x06, 0xB0, 0xA0, 0xCE, 0x0E, 0x04, 0x77, 0x75, 0x03, 0xB0, 0xC0, 0xED,
  0x08, 0x01, 0x77, 0x76, 0x01, 0xB0, 0xEC, 0x07, 0x01, 0x70, 0x06, 0x73, 0x00, 0x67, 0x2F, 0x97,
  0x10, 0xDA, 0x0D, 0x71, 0x0D, 0xA0, 0xD7, 0x1C, 0x0E, 0xB0, 0x26, 0x06, 0xC0, 0x66, 0x06, 0xC0,
  0x66, 0x02, 0xB0, 0xE0, 0xCB, 0x03, 0x60, 0x6C, 0x06, 0x60, 0x6C, 0x06, 0x60, 0x3B, 0x0C, 0x0A,
  0xB0, 0x67, 0x0D, 0xA0, 0xD7, 0x10, 0xDA, 0x0D, 0x70, 0x6B, 0x0A, 0x07, 0xB0, 0xB7, 0x10, 0x06,
  0x73, 0x00, 0x67, 0x10, 0xBB, 0x07, 0x03, 0xC7, 0x77, 0x72, 0xC8, 0x13, 0x0D, 0xB0, 0x67, 0x77,
  0x70, 0x6B, 0x0D, 0x20, 0x8B, 0x0E, 0x77, 0x77, 0x0E, 0xB0, 0x82, 0x01, 0xC0, 0x77, 0x77, 0x50,
  0x7C, 0x01, 0x30, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77,
  0x10, 0x10, 0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C,
  0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC, 0x09, 0x72, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40,
  0xAD, 0x0E, 0x06, 0x75, 0x06, 0x0E, 0xD0, 0xA7, 0x60, 0x9F, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36,
  0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01,
  0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA,
  0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_face_unlock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_face_unlock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_fact_check 48x48, 4-bit Alpha,  RLE, 184 bytes.
static const unsigned char ic_round_48_action_fact_check_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0A, 0xC2, 0xF0, 0xB0, 0x16, 0x01, 0x0B, 0xFF, 0xFF,
  0xA0, 0x17, 0x10, 0x1F, 0xFF, 0xFA, 0x01, 0x71, 0x01, 0xFF, 0xFF, 0xA0, 0xB0, 0x16, 0x01, 0x0B,
  0x80, 0xE3, 0xF0, 0x0E, 0x80, 0xC1, 0xF0, 0x72, 0x09, 0xFF, 0xFF, 0xF0, 0x73, 0x01, 0xFF, 0xFF,
  0xE0, 0x74, 0x02, 0xFD, 0x0B, 0x01, 0x60, 0x10, 0xBD, 0x82, 0xC6, 0x7E, 0xA0, 0x74, 0x01, 0x0C,
  0xFD, 0x01, 0x71, 0x01, 0xC0, 0xE0, 0x12, 0x81, 0x3E, 0x74, 0x01, 0x0C, 0xFE, 0x01, 0x71, 0x01,
  0xC0, 0xD4, 0x01, 0x40, 0x10, 0xCF, 0xF0, 0xB0, 0x16, 0x01, 0x0B, 0xD0, 0x37, 0x01, 0x0C, 0xFF,
  0xFF, 0xA0, 0xE0, 0x35, 0x01, 0x0C, 0xFF, 0xFF, 0xC0, 0xE0, 0x33, 0x01, 0x0C, 0xFF, 0xFF, 0xE8,
  0x3E, 0x30, 0x1C, 0x80, 0xC1, 0xF0, 0xDF, 0xFE, 0x0B, 0x01, 0x60, 0x10, 0xBF, 0xFF, 0xFA, 0x01,
  0x71, 0x01, 0xFF, 0xFF, 0xA0, 0x17, 0x10, 0x1F, 0xFF, 0xFA, 0x0B, 0x01, 0x60, 0x10, 0xB8, 0x0A,
  0xE4, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E,
  0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_fact_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_fact_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_favorite_border 48x48, 4-bit Alpha,  RLE, 312 bytes.
static const unsigned char ic_round_48_action_favorite_border_data[] PROGMEM = {
  0x68, 0x90, 0x15, 0xAD, 0xEE, 0xDA, 0x61, 0x71, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA5, 0x17, 0x40,
  0x70, 0xEF, 0x98, 0x1E, 0x81, 0x48, 0x11, 0x8E, 0xF9, 0x0E, 0x07, 0x71, 0x01, 0x0C, 0xFD, 0x0D,
  0x04, 0x20, 0x40, 0xDF, 0xD0, 0xC0, 0x15, 0x02, 0x0D, 0xFF, 0x90, 0x05, 0xFF, 0x90, 0xD0, 0x24,
  0x0C, 0xC8, 0x6D, 0x72, 0x01, 0x37, 0xEF, 0xB8, 0x6E, 0x73, 0x10, 0x27, 0xDC, 0x0C, 0x30, 0x7C,
  0x09, 0x71, 0x07, 0xF9, 0x07, 0x71, 0x09, 0xC0, 0x72, 0x0E, 0xB0, 0x97, 0x30, 0x5E, 0x05, 0x73,
  0x09, 0xB8, 0x1E, 0x06, 0xB0, 0xD7, 0x50, 0x8C, 0x09, 0x75, 0x0D, 0xB0, 0x60, 0xAB, 0x07, 0x76,
  0x80, 0x0B, 0x01, 0x75, 0x07, 0xB0, 0xA0, 0xCB, 0x02, 0x77, 0x77, 0x20, 0x2B, 0x0C, 0xC7, 0x77,
  0x74, 0xC0, 0xEB, 0x01, 0x77, 0x77, 0x20, 0x1B, 0x0E, 0x0D, 0xB0, 0x37, 0x77, 0x72, 0x03, 0xB0,
  0xD0, 0xBB, 0x06, 0x77, 0x77, 0x20, 0x6B, 0x0B, 0x06, 0xB0, 0xC7, 0x77, 0x72, 0x0C, 0xB0, 0x60,
  0x2C, 0x03, 0x77, 0x77, 0x03, 0xC8, 0x11, 0x0B, 0xB0, 0xC7, 0x77, 0x70, 0xCB, 0x0B, 0x20, 0x3C,
  0x06, 0x77, 0x75, 0x06, 0xC0, 0x33, 0x0A, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x0A, 0x40, 0x10, 0xEB,
  0x0D, 0x01, 0x77, 0x71, 0x01, 0x0D, 0xB0, 0xE0, 0x15, 0x05, 0xC0, 0xB7, 0x77, 0x10, 0xBC, 0x04,
  0x70, 0x9C, 0x0A, 0x77, 0x60, 0xAC, 0x08, 0x72, 0x0B, 0xC0, 0x97, 0x74, 0x09, 0xC0, 0xA7, 0x40,
  0xCC, 0x09, 0x77, 0x20, 0x9C, 0x0C, 0x75, 0x01, 0x0D, 0xC0, 0xA7, 0x70, 0xAC, 0x0D, 0x01, 0x76,
  0x01, 0x0D, 0xC0, 0xA7, 0x50, 0xAC, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xDC, 0x0B, 0x73, 0x0B, 0xC0,
  0xD0, 0x17, 0x73, 0x02, 0x0D, 0xC0, 0xC0, 0x16, 0x01, 0x0C, 0xC0, 0xD0, 0x17, 0x75, 0x01, 0x0D,
  0xC0, 0xC0, 0x14, 0x01, 0x0C, 0xC0, 0xC0, 0x17, 0x77, 0x01, 0x0C, 0xC0, 0xD0, 0x22, 0x02, 0x0D,
  0xC0, 0xC0, 0x17, 0x77, 0x30, 0xBC, 0x82, 0xE3, 0x3E, 0xC0, 0xB7, 0x77, 0x60, 0xAC, 0x00, 0xEC,
  0x0A, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x97, 0x77, 0x73, 0x08, 0xE0, 0x77, 0x77, 0x75, 0x05, 0x0E,
  0xA0, 0xE0, 0x58, 0x0C, 0x00, 0x00, 0x37, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_favorite_border() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_favorite_border_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_favorite 48x48, 4-bit Alpha,  RLE, 218 bytes.
static const unsigned char ic_round_48_action_favorite_data[] PROGMEM = {
  0x68, 0x90, 0x15, 0xAD, 0xEE, 0xDA, 0x61, 0x71, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA5, 0x17, 0x40,
  0x70, 0xEF, 0x98, 0x1E, 0x81, 0x48, 0x11, 0x8E, 0xF9, 0x0E, 0x07, 0x71, 0x01, 0x0C, 0xFD, 0x0D,
  0x04, 0x20, 0x40, 0xDF, 0xD0, 0xC0, 0x15, 0x02, 0x0D, 0xFF, 0x90, 0x05, 0xFF, 0x90, 0xD0, 0x24,
  0x0C, 0xFF, 0xFF, 0xE0, 0xC3, 0x07, 0x80, 0xC0, 0xF0, 0x72, 0x0E, 0x80, 0xC0, 0xF8, 0x1E, 0x06,
  0x80, 0xC2, 0xF0, 0x60, 0xA8, 0x0C, 0x2F, 0x0A, 0x0C, 0x80, 0xC2, 0xF0, 0xC8, 0x0C, 0x4F, 0x0E,
  0x80, 0xC2, 0xF0, 0xE0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0B, 0x80, 0xC2, 0xF0, 0xB0, 0x68, 0x0C, 0x2F,
  0x06, 0x01, 0x80, 0xC2, 0xF8, 0x12, 0x0B, 0x80, 0xC0, 0xF0, 0xB2, 0x03, 0x80, 0xC0, 0xF0, 0x33,
  0x0A, 0xFF, 0xFF, 0xE0, 0xA4, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x15, 0x04, 0xFF, 0xFF, 0xC0,
  0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xBF, 0xFF, 0xF0, 0xB7, 0x40, 0xCF, 0xFF, 0xD0, 0xC7,
  0x50, 0x10, 0xDF, 0xFF, 0xB0, 0xD0, 0x17, 0x60, 0x10, 0xDF, 0xFF, 0x90, 0xD0, 0x17, 0x71, 0x01,
  0x0D, 0xFF, 0xE0, 0xD0, 0x17, 0x73, 0x01, 0x0D, 0xFF, 0xC0, 0xD0, 0x27, 0x75, 0x01, 0x0C, 0xFF,
  0xA0, 0xD0, 0x17, 0x77, 0x01, 0x0C, 0xFF, 0x0C, 0x01, 0x77, 0x73, 0x0B, 0xFD, 0x0B, 0x77, 0x76,
  0x0A, 0xFB, 0x0A, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x97, 0x77, 0x73, 0x07, 0xE0, 0x87, 0x77, 0x75,
  0x05, 0x0E, 0xA0, 0xE0, 0x58, 0x0C, 0x00, 0x00, 0x37, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_favorite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_favorite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_fax 48x48, 4-bit Alpha,  RLE, 217 bytes.
static const unsigned char ic_round_48_action_fax_data[] PROGMEM = {
  0x76, 0x81, 0x1A, 0xDF, 0xD8, 0x1D, 0xA1, 0x77, 0x70, 0x10, 0xEF, 0xFA, 0x0E, 0x01, 0x77, 0x60,
  0xAF, 0xFC, 0x0A, 0x77, 0x60, 0xDF, 0xFC, 0x0D, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77,
  0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x73, 0x84, 0x4B, 0xEE, 0xB4, 0x4C, 0x75, 0xC7, 0x20, 0x8E,
  0x08, 0x3C, 0x75, 0xC7, 0x10, 0x4F, 0x90, 0x42, 0xFF, 0xF9, 0x81, 0xEC, 0x63, 0x0B, 0xF9, 0x0B,
  0x2F, 0xFF, 0xC8, 0x2C, 0x10, 0xEF, 0x90, 0xE2, 0xFF, 0xFD, 0x0C, 0x1F, 0xB2, 0xFF, 0xFE, 0x06,
  0xFB, 0x2F, 0xFF, 0xE0, 0xCF, 0xB2, 0xFF, 0xFE, 0x0E, 0xFB, 0x2C, 0x71, 0xA8, 0x2B, 0x11, 0xBA,
  0x82, 0xB1, 0x1B, 0xFF, 0x2C, 0x71, 0xA0, 0x12, 0x01, 0xA0, 0x12, 0x01, 0xFF, 0x2C, 0x71, 0xA0,
  0x12, 0x01, 0xA0, 0x12, 0x01, 0xFF, 0x2C, 0x71, 0xA8, 0x2B, 0x11, 0xBA, 0x82, 0xB1, 0x1B, 0xFF,
  0x2C, 0x71, 0xFF, 0xFD, 0x2C, 0x71, 0xFF, 0xFD, 0x2C, 0x71, 0xA8, 0x2B, 0x11, 0xBA, 0x82, 0xB1,
  0x1B, 0xFF, 0x2C, 0x71, 0xA0, 0x12, 0x01, 0xA0, 0x12, 0x01, 0xFF, 0x2C, 0x71, 0xA0, 0x12, 0x01,
  0xA0, 0x12, 0x01, 0xFF, 0x2C, 0x71, 0xA8, 0x2B, 0x11, 0xBA, 0x82, 0xB1, 0x1B, 0xFF, 0x28, 0x0C,
  0x2F, 0x28, 0x0C, 0x2F, 0x2F, 0xFF, 0xE0, 0xD0, 0xEF, 0x90, 0xE2, 0xFF, 0xFE, 0x0A, 0x0B, 0xF9,
  0x0B, 0x2F, 0xFF, 0xD8, 0x1E, 0x14, 0xF9, 0x04, 0x2F, 0xFF, 0xB8, 0x1D, 0xA1, 0x20, 0x8E, 0x08,
  0x77, 0x77, 0x58, 0x44, 0xBE, 0xEB, 0x47, 0x77, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_fax() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_fax_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_feedback 48x48, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_round_48_action_feedback_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0A, 0xD6, 0xF8, 0x2B, 0x11, 0xB8, 0x0C, 0x0F, 0x01,
  0x20, 0x18, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F,
  0x01, 0x20, 0x18, 0x0C, 0x0F, 0x82, 0xB1, 0x1B, 0x80, 0xB8, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C,
  0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0B, 0xA5, 0xF0, 0xD8, 0x0C, 0x3F, 0x0A, 0x80, 0xC2, 0xF0, 0xE0,
  0x18, 0x0C, 0x0F, 0x81, 0xDA, 0x11, 0xF0, 0x77, 0x77, 0x74, 0xE0, 0x77, 0x77, 0x75, 0xD0, 0x77,
  0x77, 0x76, 0xC0, 0x77, 0x77, 0x77, 0xB0, 0x78, 0x0C, 0x00, 0xA0, 0x78, 0x0C, 0x10, 0x90, 0x78,
  0x0C, 0x20, 0x07, 0x80, 0xC3, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_feedback() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_feedback_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_file_present 48x48, 4-bit Alpha,  RLE, 216 bytes.
static const unsigned char ic_round_48_action_file_present_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x0A, 0xFF, 0xF0,
  0x77, 0x20, 0xDF, 0xFF, 0x90, 0x77, 0x1F, 0xFE, 0x07, 0xB0, 0x77, 0xFF, 0xE1, 0x07, 0xB0, 0x76,
  0xFF, 0xE2, 0x07, 0xB0, 0x75, 0xFF, 0xE3, 0x07, 0xB0, 0x74, 0xFF, 0xE4, 0x07, 0xB0, 0x73, 0xFF,
  0xE5, 0x07, 0xB0, 0x72, 0xFB, 0x0B, 0x03, 0x20, 0x30, 0xAC, 0x01, 0x50, 0x7B, 0x07, 0x1F, 0xA0,
  0x96, 0x07, 0xB0, 0xB0, 0x15, 0x07, 0xB0, 0x4F, 0x90, 0xC7, 0x10, 0xAF, 0xE0, 0xBF, 0x90, 0x57,
  0x10, 0x3F, 0xE0, 0xEF, 0x90, 0x23, 0x00, 0xB4, 0xFF, 0xF9, 0x4A, 0x4F, 0xFF, 0x94, 0xA4, 0xFF,
  0xF9, 0x4A, 0x4F, 0xFF, 0x94, 0xA4, 0xA8, 0x2B, 0x11, 0xBF, 0xFA, 0x4A, 0x4A, 0x01, 0x20, 0x1F,
  0xFA, 0x4A, 0x4A, 0x4F, 0xFA, 0x4A, 0x4A, 0x4F, 0xFA, 0x4A, 0x4A, 0x4F, 0xFA, 0x4A, 0x4A, 0x4F,
  0xFA, 0x4A, 0x01, 0x20, 0x1A, 0x4F, 0xFA, 0x4A, 0x82, 0xB1, 0x1B, 0xA4, 0xFF, 0xA0, 0x13, 0x0D,
  0xE0, 0xE4, 0xFF, 0xA0, 0x33, 0x09, 0xE0, 0xA3, 0x02, 0xFF, 0xA0, 0x73, 0x01, 0x0D, 0xC0, 0xE0,
  0x23, 0x06, 0xFF, 0xA0, 0xE4, 0x84, 0x19, 0xEE, 0xA2, 0x40, 0xCF, 0xFB, 0x08, 0x75, 0x06, 0xFF,
  0xD0, 0x57, 0x30, 0x4F, 0xFF, 0x07, 0x71, 0x06, 0xFF, 0xFA, 0x81, 0xD6, 0x22, 0x81, 0x26, 0xD8,
  0x09, 0x90, 0xF0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0xFF, 0x84,
  0xE1, 0x01, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_file_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_file_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_filter_alt_off 48x48, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_round_48_action_filter_alt_off_data[] PROGMEM = {
  0x18, 0x12, 0x74, 0x77, 0x77, 0x70, 0x20, 0xEA, 0x07, 0x77, 0x77, 0x60, 0x5C, 0x07, 0x50, 0xCF,
  0xFF, 0xA0, 0xD0, 0x42, 0x01, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xFA, 0x0D, 0x30, 0x30, 0xEC, 0x07,
  0x50, 0xCF, 0xFF, 0x90, 0xD4, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xF0, 0x55, 0x03, 0x0E, 0xC0,
  0x75, 0x0C, 0xFF, 0xD0, 0x87, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xB0, 0xB7, 0x20, 0x4D, 0x07,
  0x50, 0xCF, 0xF9, 0x0E, 0x01, 0x73, 0x04, 0xD0, 0x75, 0x0C, 0xFF, 0x03, 0x75, 0x04, 0xD0, 0x75,
  0x0C, 0xFD, 0x06, 0x77, 0x05, 0xD0, 0x75, 0x0C, 0xFB, 0x0A, 0x77, 0x20, 0x5D, 0x07, 0x50, 0xCF,
  0x90, 0xC7, 0x74, 0x05, 0xD0, 0x75, 0x0C, 0xE0, 0xE0, 0x27, 0x75, 0x05, 0xD0, 0x75, 0x0C, 0xD0,
  0x47, 0x77, 0x06, 0xD0, 0x75, 0x0C, 0xB0, 0x77, 0x77, 0x20, 0x6D, 0x07, 0x58, 0x1C, 0xFB, 0x77,
  0x74, 0x06, 0xD0, 0x75, 0x0A, 0x01, 0x77, 0x75, 0x07, 0xD0, 0x77, 0x77, 0x75, 0x07, 0xD0, 0x77,
  0x77, 0x75, 0xE0, 0x77, 0x77, 0x74, 0xF0, 0x77, 0x77, 0x73, 0xF9, 0x07, 0x77, 0x77, 0x2F, 0xA0,
  0x77, 0x77, 0x71, 0xFB, 0x07, 0x77, 0x77, 0xFC, 0x07, 0x77, 0x76, 0xFD, 0x07, 0x77, 0x75, 0xF9,
  0x0E, 0xC0, 0x77, 0x77, 0x4F, 0x90, 0x30, 0xEC, 0x07, 0x77, 0x73, 0xF9, 0x10, 0x30, 0xEC, 0x07,
  0x77, 0x72, 0x0D, 0xE0, 0xD2, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x10, 0xAE, 0x0A, 0x30, 0x30, 0xEC,
  0x07, 0x77, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x78, 0x41, 0xAD, 0xDA,
  0x16, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0,
  0x47, 0x77, 0x75, 0x03, 0x0E, 0xB0, 0x77, 0x77, 0x76, 0x83, 0x3E, 0xFE, 0x27, 0x77, 0x77, 0x81,
  0x15, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_filter_alt_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 41, 44), Box(0, 0, 47, 47),
      ic_round_48_action_filter_alt_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_filter_alt 48x48, 4-bit Alpha,  RLE, 140 bytes.
static const unsigned char ic_round_48_action_filter_alt_data[] PROGMEM = {
  0x03, 0x0C, 0xFF, 0xFF, 0x81, 0xC3, 0xCF, 0xFF, 0xFA, 0x00, 0xCF, 0xFF, 0xFA, 0x0C, 0x04, 0xFF,
  0xFF, 0xA8, 0x14, 0x07, 0xFF, 0xFF, 0x07, 0x30, 0xBF, 0xFF, 0xD0, 0xB4, 0x01, 0x0D, 0xFF, 0xFB,
  0x0D, 0x01, 0x50, 0x3F, 0xFF, 0xB0, 0x37, 0x06, 0xFF, 0xF9, 0x06, 0x72, 0x09, 0xFF, 0xE0, 0x97,
  0x40, 0xCF, 0xFC, 0x0C, 0x75, 0x01, 0x0E, 0xFF, 0xA0, 0xE0, 0x17, 0x60, 0x4F, 0xFA, 0x04, 0x77,
  0x10, 0x7F, 0xF0, 0x77, 0x73, 0x0B, 0xFD, 0x0B, 0x77, 0x40, 0x10, 0xDF, 0xB0, 0xD0, 0x17, 0x75,
  0x03, 0xFB, 0x03, 0x77, 0x70, 0x6F, 0x90, 0x67, 0x77, 0x2F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F,
  0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97,
  0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x30, 0xDE, 0x0D, 0x77, 0x73, 0x0A, 0xE0, 0xA7, 0x77,
  0x30, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x74, 0x84, 0x1A, 0xDD, 0xA1, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_filter_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_filter_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_find_in_page 48x48, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_round_48_action_find_in_page_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x09, 0xFF, 0xF0,
  0x77, 0x20, 0xDF, 0xFF, 0x90, 0x77, 0x1F, 0xFF, 0xB0, 0x77, 0xFF, 0xFC, 0x07, 0x6F, 0xFF, 0xD0,
  0x75, 0xFF, 0xFE, 0x07, 0x4F, 0xFF, 0xF0, 0x73, 0xFF, 0xFF, 0x90, 0x72, 0xFF, 0xFF, 0xA0, 0x71,
  0xFF, 0xFF, 0xB0, 0x4F, 0xD8, 0x6A, 0x52, 0x01, 0x25, 0x9F, 0xC0, 0xBF, 0xB0, 0xA0, 0x27, 0x10,
  0x10, 0xAF, 0xA0, 0xEF, 0xA0, 0x77, 0x50, 0x6F, 0xFB, 0x07, 0x77, 0x06, 0xFF, 0x90, 0xA5, 0x84,
  0x6C, 0xEE, 0xC6, 0x50, 0xAF, 0xF0, 0x23, 0x01, 0x0C, 0xE0, 0xC0, 0x13, 0x01, 0xFE, 0x0A, 0x40,
  0xCF, 0x90, 0xC4, 0x09, 0xFD, 0x05, 0x30, 0x6F, 0xB0, 0x63, 0x05, 0xFD, 0x02, 0x30, 0xCF, 0xB0,
  0xC3, 0x02, 0xFD, 0x40, 0xEF, 0xB0, 0xE4, 0xFD, 0x01, 0x30, 0xEF, 0xB0, 0xE4, 0xFD, 0x01, 0x30,
  0xCF, 0xB0, 0xC3, 0x02, 0xFD, 0x05, 0x30, 0x6F, 0xB0, 0x63, 0x05, 0xFD, 0x0A, 0x40, 0xCF, 0x90,
  0xC4, 0x0A, 0xFE, 0x01, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x30, 0x2F, 0xF0, 0xB5, 0x84, 0x6C, 0xEE,
  0xC6, 0x50, 0x7F, 0xF9, 0x07, 0x77, 0x20, 0xAF, 0xF9, 0x07, 0x77, 0x20, 0xAF, 0xF9, 0x0B, 0x02,
  0x71, 0x01, 0x07, 0x50, 0xAF, 0xFA, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAA, 0x0A, 0x50, 0xAF, 0xFF,
  0xD0, 0xA5, 0x0A, 0xFF, 0xFD, 0x0A, 0x50, 0xAF, 0xFF, 0xD0, 0xA5, 0x0A, 0xFF, 0xFD, 0x0A, 0x50,
  0xDF, 0xFF, 0xD0, 0xA4, 0x0A, 0xFF, 0xFE, 0x0A, 0x30, 0x10, 0xEF, 0xFF, 0xE0, 0xA3, 0x81, 0x1A,
  0xEF, 0xFF, 0xB8, 0x1E, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_find_in_page() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_find_in_page_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_find_replace 48x48, 4-bit Alpha,  RLE, 209 bytes.
static const unsigned char ic_round_48_action_find_replace_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDF, 0xED, 0xB7, 0x37, 0x77, 0x10, 0x50, 0xCF, 0xB0, 0xD0, 0x55, 0x00,
  0x57, 0x40, 0x20, 0xBF, 0xF0, 0xB0, 0x12, 0x07, 0xA7, 0x30, 0x40, 0xEF, 0xFA, 0x81, 0xE3, 0x7B,
  0x72, 0x03, 0xE8, 0x1A, 0x52, 0x28, 0x12, 0x5A, 0xFB, 0x71, 0x02, 0x0E, 0xC0, 0xA0, 0x17, 0x10,
  0x20, 0xAF, 0x97, 0x10, 0xBC, 0x06, 0x75, 0x06, 0xF7, 0x05, 0xC0, 0x67, 0x60, 0x7F, 0x70, 0xCB,
  0x0A, 0x76, 0x07, 0xF9, 0x60, 0x2C, 0x01, 0x75, 0x07, 0xFA, 0x60, 0x2B, 0x09, 0x75, 0x05, 0xFB,
  0x78, 0x27, 0xEC, 0x17, 0x50, 0x5F, 0xA0, 0xB8, 0x0A, 0x92, 0x00, 0xBF, 0xA0, 0x57, 0x58, 0x21,
  0xCE, 0x77, 0xFB, 0x05, 0x75, 0x09, 0xB0, 0x26, 0xFA, 0x07, 0x75, 0x01, 0xC0, 0x26, 0xF9, 0x07,
  0x76, 0x0A, 0xB0, 0xC7, 0xF0, 0x77, 0x60, 0x6C, 0x05, 0x7F, 0x06, 0x75, 0x06, 0xC0, 0xB7, 0x1F,
  0x90, 0xA0, 0x27, 0x10, 0x10, 0xAD, 0x08, 0x71, 0xFB, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAF, 0x90,
  0x77, 0xB8, 0x17, 0x3E, 0xFF, 0xF0, 0x76, 0xA0, 0x72, 0x01, 0x0B, 0xFF, 0x0B, 0x08, 0xD0, 0x75,
  0x00, 0x55, 0x05, 0x0D, 0xFB, 0x0C, 0x05, 0x20, 0x7D, 0x07, 0x76, 0x89, 0x03, 0x7B, 0xDE, 0xFD,
  0xB7, 0x35, 0x07, 0xD0, 0x77, 0x77, 0x70, 0x7D, 0x07, 0x77, 0x77, 0x07, 0xD0, 0x77, 0x77, 0x70,
  0x7D, 0x06, 0x77, 0x77, 0x07, 0xC0, 0xE7, 0x77, 0x71, 0x07, 0xB0, 0xE7, 0x77, 0x72, 0x07, 0xA0,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_find_replace() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_find_replace_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_fingerprint 48x48, 4-bit Alpha,  RLE, 569 bytes.
static const unsigned char ic_round_48_action_fingerprint_data[] PROGMEM = {
  0x74, 0x84, 0x25, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x85, 0x27, 0x75, 0x81, 0x27, 0xCF, 0xF8, 0x1C,
  0x72, 0x77, 0x03, 0x0A, 0xB8, 0x4E, 0xA7, 0x41, 0x12, 0x84, 0x11, 0x47, 0xAE, 0xB0, 0xA0, 0x37,
  0x40, 0x5B, 0x09, 0x04, 0x77, 0x04, 0x09, 0xB0, 0x67, 0x38, 0x24, 0xD8, 0x17, 0x10, 0x01, 0x71,
  0x82, 0x18, 0xD5, 0x77, 0x28, 0x22, 0x6A, 0xCE, 0x82, 0xCA, 0x72, 0x77, 0x58, 0x11, 0x7D, 0xE0,
  0x0D, 0xE8, 0x1D, 0x71, 0x77, 0x81, 0x18, 0xEA, 0x82, 0xE9, 0x53, 0x68, 0x23, 0x59, 0xEB, 0x08,
  0x01, 0x74, 0x05, 0x0E, 0xA0, 0xA0, 0x47, 0x70, 0x40, 0xAA, 0x0E, 0x05, 0x72, 0x09, 0xA0, 0xB0,
  0x26, 0x84, 0x23, 0x54, 0x31, 0x60, 0x20, 0xBA, 0x09, 0x78, 0x2C, 0xFE, 0x54, 0x82, 0x16, 0xBE,
  0xE8, 0x2E, 0xA5, 0x14, 0x83, 0x5E, 0xFC, 0x13, 0x83, 0x1C, 0xFD, 0x23, 0x02, 0x09, 0xC8, 0x4D,
  0xBA, 0xBC, 0xDB, 0x81, 0xE8, 0x13, 0x83, 0x2D, 0xFC, 0x12, 0x82, 0xBF, 0xD1, 0x30, 0x7B, 0x81,
  0xA5, 0x16, 0x81, 0x26, 0xBA, 0x0E, 0x06, 0x38, 0x71, 0xDF, 0xB0, 0x8F, 0xD1, 0x20, 0x10, 0xCA,
  0x09, 0x01, 0x75, 0x03, 0x0B, 0xA0, 0x93, 0x85, 0x1E, 0xF8, 0xEF, 0x32, 0x83, 0x1D, 0xFD, 0x35,
  0x84, 0x24, 0x66, 0x42, 0x58, 0x25, 0xEF, 0xB3, 0x83, 0x3F, 0xD3, 0x33, 0x82, 0xDF, 0xC1, 0x38,
  0x11, 0x8D, 0xE8, 0x1D, 0x81, 0x38, 0x22, 0xDF, 0xA3, 0x00, 0x24, 0x82, 0xAF, 0xC1, 0x30, 0x70,
  0xEA, 0x84, 0xDA, 0x99, 0xAD, 0xA0, 0xE0, 0x73, 0x82, 0x2E, 0xF8, 0x78, 0x25, 0xFE, 0x23, 0x0A,
  0xA0, 0xA0, 0x36, 0x03, 0x0A, 0xA0, 0xA3, 0x03, 0xA0, 0x26, 0x81, 0xDF, 0x63, 0x82, 0xAF, 0xE4,
  0x73, 0x82, 0x4E, 0xFA, 0x38, 0x19, 0xFB, 0x58, 0x15, 0xFC, 0x38, 0x27, 0xFE, 0x23, 0x83, 0x15,
  0x77, 0x54, 0x82, 0x2E, 0xF7, 0x28, 0x21, 0xEF, 0x34, 0x81, 0xBF, 0x52, 0x82, 0x1E, 0xF3, 0x30,
  0x8D, 0x0E, 0x06, 0x38, 0x23, 0xFE, 0x12, 0x81, 0x8F, 0x84, 0xA3, 0x81, 0x8F, 0xA3, 0x0A, 0xA8,
  0x2B, 0x78, 0xBA, 0x08, 0x38, 0x1A, 0xF8, 0x28, 0x13, 0xFD, 0x38, 0x13, 0xFC, 0x38, 0x1D, 0xF3,
  0x28, 0x26, 0xFE, 0x34, 0x04, 0xA0, 0x42, 0x81, 0x3F, 0xD3, 0x81, 0xEF, 0x12, 0x81, 0x5F, 0x92,
  0x81, 0x1F, 0xE3, 0x81, 0xDF, 0x56, 0x81, 0x6F, 0xB3, 0x81, 0xEF, 0x12, 0x81, 0xBF, 0x32, 0x81,
  0x6F, 0x82, 0x81, 0x3F, 0xB2, 0x81, 0x2F, 0xE3, 0x08, 0x05, 0x20, 0x1A, 0x38, 0x1B, 0xF3, 0x28,
  0x1A, 0xF5, 0x28, 0x16, 0xF8, 0x28, 0x14, 0xFA, 0x28, 0x13, 0xFC, 0x28, 0x11, 0xFD, 0x38, 0x1D,
  0xF2, 0x28, 0x19, 0xF3, 0x28, 0x19, 0xF6, 0x28, 0x15, 0xF8, 0x28, 0x13, 0xFB, 0x28, 0x11, 0xFD,
  0x30, 0xE9, 0x38, 0x1B, 0xF5, 0x20, 0x10, 0x33, 0x81, 0xDF, 0x42, 0x81, 0x4F, 0xA2, 0x81, 0x2F,
  0xC3, 0xA3, 0x81, 0xDF, 0x32, 0x81, 0x6F, 0xD6, 0x81, 0x6F, 0xE3, 0x81, 0x2F, 0xC3, 0xA3, 0x81,
  0xDF, 0x32, 0x81, 0x8F, 0x93, 0x82, 0xDF, 0xC3, 0x30, 0x7A, 0x06, 0x49, 0x0E, 0x38, 0x1D, 0xF2,
  0x28, 0x18, 0xF8, 0x28, 0x22, 0xFE, 0x12, 0x02, 0x0D, 0xA0, 0xE0, 0xDB, 0x07, 0x58, 0x1B, 0xF3,
  0x28, 0x19, 0xF7, 0x28, 0x13, 0xFD, 0x38, 0x1A, 0xFB, 0x40, 0x80, 0xDB, 0x0B, 0x04, 0x68, 0x17,
  0xF8, 0x28, 0x14, 0xFC, 0x38, 0x1C, 0xF6, 0x28, 0x21, 0xDF, 0x95, 0x00, 0x17, 0x28, 0x13, 0xFC,
  0x38, 0x1D, 0xF4, 0x28, 0x24, 0xFE, 0x12, 0x83, 0x3E, 0xFB, 0x27, 0x71, 0x09, 0x08, 0x38, 0x17,
  0xFC, 0x38, 0x1B, 0xFC, 0x30, 0x20, 0xDA, 0x85, 0xA6, 0x32, 0x24, 0x27, 0x78, 0x1D, 0xF6, 0x28,
  0x21, 0xDF, 0xA3, 0x01, 0x09, 0xF0, 0xE7, 0x78, 0x25, 0xFE, 0x22, 0x83, 0x2E, 0xFC, 0x13, 0x86,
  0x16, 0x9B, 0xDD, 0xB7, 0x77, 0x18, 0x29, 0xFD, 0x12, 0x83, 0x2D, 0xFE, 0x67, 0x77, 0x58, 0x2C,
  0xFC, 0x12, 0x01, 0x0A, 0xA8, 0x1D, 0x72, 0x77, 0x72, 0x82, 0x1D, 0xF6, 0x40, 0x50, 0xCB, 0x08,
  0x77, 0x72, 0x81, 0x17, 0x16, 0x82, 0x49, 0xE8, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_fingerprint() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_fingerprint_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_fit_screen 48x48, 4-bit Alpha,  RLE, 199 bytes.
static const unsigned char ic_round_48_action_fit_screen_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xC0, 0xD0, 0x47, 0x76, 0x04, 0x0D, 0xC8, 0x4D, 0xA1, 0x01, 0xEF, 0x0D, 0x77,
  0x60, 0xDF, 0x81, 0xE1, 0xAF, 0x90, 0xD7, 0x76, 0x0D, 0xF9, 0x0A, 0x0D, 0xF0, 0xD0, 0x47, 0x76,
  0x04, 0x0D, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77,
  0x74, 0xC0, 0xDA, 0x0D, 0x58, 0x11, 0xAD, 0xFF, 0xA8, 0x1D, 0xA1, 0x50, 0xDA, 0x83, 0xD4, 0xDD,
  0x44, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x14, 0x82, 0x4D, 0xD4, 0x71, 0x0A, 0xFF, 0xF9, 0x0A, 0x77,
  0x20, 0xDF, 0xFF, 0x90, 0xD7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77,
  0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF,
  0xB7, 0x72, 0x0D, 0xFF, 0xF9, 0x0D, 0x77, 0x20, 0xAF, 0xFF, 0x90, 0xA7, 0x18, 0x24, 0xDD, 0x44,
  0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x14, 0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0x58, 0x11, 0xAD, 0xFF, 0xA8,
  0x1D, 0xA1, 0x50, 0xDA, 0x0D, 0xC7, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9,
  0x77, 0x77, 0x4C, 0x0D, 0xF0, 0xD0, 0x47, 0x76, 0x04, 0x0D, 0xF0, 0xD0, 0xAF, 0x90, 0xD7, 0x76,
  0x0D, 0xF9, 0x81, 0xA1, 0xEF, 0x0D, 0x77, 0x60, 0xDF, 0x84, 0xE1, 0x01, 0xAD, 0xC0, 0xD0, 0x47,
  0x76, 0x04, 0x0D, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_fit_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_fit_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_flaky 48x48, 4-bit Alpha,  RLE, 357 bytes.
static const unsigned char ic_round_48_action_flaky_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x08, 0xFF, 0xC0, 0x80, 0x17, 0x73, 0x04, 0x0E, 0xFF, 0xE0, 0xE0, 0x47, 0x71,
  0x08, 0xFF, 0xFB, 0x08, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x08,
  0xFF, 0xFF, 0xA0, 0x87, 0x04, 0xFF, 0xFE, 0x0D, 0xC0, 0x45, 0x01, 0x0E, 0xD8, 0x1B, 0x37, 0xB8,
  0x17, 0x3B, 0xFD, 0x81, 0x70, 0xDB, 0x0E, 0x01, 0x40, 0x8E, 0x03, 0x28, 0x15, 0xF5, 0x20, 0x3F,
  0xC0, 0x72, 0x02, 0x0E, 0xB0, 0x83, 0x01, 0xF0, 0x73, 0x02, 0x30, 0x7F, 0xB0, 0x74, 0x07, 0xC0,
  0x12, 0x07, 0xF9, 0x05, 0x50, 0x5F, 0xB0, 0x76, 0x0D, 0xB0, 0x72, 0x0D, 0xFA, 0x02, 0x30, 0x2F,
  0xB0, 0x77, 0x06, 0xB8, 0x1D, 0x03, 0xFA, 0x05, 0x50, 0x5F, 0x90, 0x77, 0x2C, 0x03, 0x07, 0xF9,
  0x07, 0x30, 0x23, 0x07, 0xE0, 0x77, 0x30, 0xBB, 0x07, 0x0A, 0xF9, 0x03, 0x28, 0x15, 0xF5, 0x20,
  0x3D, 0x07, 0x74, 0x06, 0xB0, 0xA0, 0xCF, 0x98, 0x1B, 0x37, 0xB8, 0x17, 0x3B, 0xC0, 0x77, 0x50,
  0x3B, 0x0C, 0x0E, 0xFF, 0xE0, 0x77, 0x60, 0x2B, 0x0E, 0xFF, 0xE0, 0x77, 0x71, 0xFF, 0xFA, 0x07,
  0x77, 0x2C, 0x0E, 0xFF, 0xB0, 0x77, 0x72, 0x02, 0xB0, 0xE0, 0xCF, 0xFA, 0x07, 0x73, 0x03, 0x04,
  0x50, 0x3B, 0x0C, 0x0A, 0xFF, 0x90, 0x77, 0x30, 0x7A, 0x05, 0x40, 0x6B, 0x0A, 0x07, 0xFF, 0x07,
  0x50, 0x14, 0x07, 0xB0, 0x74, 0x0B, 0xB0, 0x70, 0x3F, 0xE0, 0x75, 0x81, 0xBF, 0x92, 0x07, 0xB0,
  0xB5, 0xC8, 0x13, 0x0D, 0xFC, 0x07, 0x50, 0x1B, 0x09, 0x07, 0xB0, 0xB5, 0x06, 0xB0, 0xD2, 0x07,
  0xFB, 0x07, 0x70, 0x9E, 0x0B, 0x60, 0xEB, 0x07, 0x20, 0x1F, 0xA0, 0x77, 0x20, 0x9C, 0x0B, 0x60,
  0x7C, 0x01, 0x30, 0x8F, 0x07, 0x74, 0x08, 0xA0, 0xB6, 0x03, 0xC0, 0x84, 0x01, 0x0E, 0xD0, 0x77,
  0x60, 0x70, 0x96, 0x01, 0x0E, 0xB0, 0xE0, 0x15, 0x04, 0xC0, 0xD7, 0x77, 0x01, 0x0C, 0xC0, 0x47,
  0x08, 0xC0, 0xD0, 0x27, 0x74, 0x03, 0x0E, 0xC0, 0x87, 0x20, 0xAC, 0x0E, 0x07, 0x77, 0x20, 0x7D,
  0x0A, 0x74, 0x0A, 0xD0, 0xD0, 0x67, 0x50, 0x60, 0xED, 0x0A, 0x76, 0x08, 0xF8, 0x2B, 0x63, 0x22,
  0x82, 0x23, 0x6B, 0xF0, 0x87, 0x71, 0x04, 0x0E, 0xFF, 0xE0, 0xE0, 0x47, 0x73, 0x01, 0x08, 0xFF,
  0xC0, 0x80, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA,
  0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_flaky() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_flaky_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_flight_land 48x48, 4-bit Alpha,  RLE, 209 bytes.
static const unsigned char ic_round_48_action_flight_land_data[] PROGMEM = {
  0x77, 0x28, 0x11, 0x41, 0x77, 0x77, 0x60, 0x4A, 0x0E, 0x01, 0x77, 0x77, 0x50, 0xAB, 0x08, 0x77,
  0x77, 0x50, 0xBB, 0x0D, 0x77, 0x77, 0x50, 0xBC, 0x02, 0x77, 0x77, 0x40, 0xBC, 0x07, 0x77, 0x77,
  0x40, 0xBC, 0x0C, 0x77, 0x77, 0x40, 0xBD, 0x01, 0x77, 0x30, 0x27, 0x60, 0xBD, 0x06, 0x77, 0x28,
  0x25, 0xFE, 0x47, 0x40, 0xBD, 0x0A, 0x77, 0x20, 0x7A, 0x0D, 0x74, 0x0B, 0xD0, 0xE7, 0x72, 0x07,
  0xB0, 0x57, 0x30, 0xBE, 0x04, 0x77, 0x10, 0x7B, 0x0B, 0x73, 0x0B, 0xE0, 0x97, 0x71, 0x07, 0xC0,
  0x27, 0x20, 0xBE, 0x0E, 0x77, 0x10, 0x7D, 0x81, 0xC7, 0x36, 0x0B, 0xF0, 0x37, 0x70, 0x7F, 0x98,
  0x2E, 0xB7, 0x32, 0x0B, 0xF0, 0x87, 0x70, 0x7F, 0xD8, 0x1E, 0xAD, 0xF0, 0xD7, 0x70, 0x6F, 0xFF,
  0xA0, 0x27, 0x60, 0x10, 0xDF, 0xFF, 0x90, 0x67, 0x71, 0x81, 0x59, 0xDF, 0xFD, 0x82, 0xEA, 0x62,
  0x77, 0x18, 0x22, 0x6A, 0xEF, 0xFD, 0x82, 0xD9, 0x51, 0x77, 0x18, 0x13, 0x7B, 0xFF, 0xE8, 0x1C,
  0x84, 0x77, 0x28, 0x14, 0x8C, 0xFF, 0xD0, 0xE0, 0x57, 0x73, 0x82, 0x15, 0x9D, 0xFF, 0xB0, 0x17,
  0x76, 0x82, 0x26, 0xAE, 0xFE, 0x06, 0x77, 0x73, 0x81, 0x37, 0xBF, 0xB0, 0x57, 0x77, 0x78, 0x14,
  0x9D, 0xD0, 0xC7, 0x77, 0x74, 0x84, 0x15, 0xAB, 0x81, 0x80, 0xBC, 0x10, 0x04, 0x0D, 0xFF, 0xFF,
  0xE8, 0x1D, 0x4D, 0x80, 0xC0, 0xF0, 0x0D, 0x80, 0xC0, 0xF8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_flight_land() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 42, 41), Box(0, 0, 47, 47),
      ic_round_48_action_flight_land_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_flight_takeoff 48x48, 4-bit Alpha,  RLE, 199 bytes.
static const unsigned char ic_round_48_action_flight_takeoff_data[] PROGMEM = {
  0x73, 0x81, 0x57, 0x48, 0x0C, 0x10, 0x05, 0xB0, 0x78, 0x0C, 0x00, 0x0A, 0xC0, 0x87, 0x77, 0x77,
  0x06, 0xD0, 0x97, 0x77, 0x77, 0x0D, 0xD0, 0xA7, 0x77, 0x76, 0x05, 0xE0, 0xB7, 0x77, 0x76, 0x0B,
  0xE0, 0xC0, 0x17, 0x77, 0x74, 0x02, 0xF0, 0xC0, 0x17, 0x77, 0x74, 0x09, 0xF0, 0xD0, 0x27, 0x77,
  0x73, 0x01, 0x0E, 0xF0, 0xE0, 0x27, 0x77, 0x73, 0x06, 0xF9, 0x0E, 0x03, 0x73, 0x83, 0x49, 0xCD,
  0x97, 0x72, 0x0D, 0xF9, 0x0E, 0x04, 0x58, 0x13, 0x7C, 0xE0, 0xB7, 0x71, 0x04, 0xFB, 0x83, 0x52,
  0x6B, 0xEF, 0xB0, 0x27, 0x71, 0x0B, 0xFF, 0xFB, 0x02, 0x77, 0x10, 0x2F, 0xFF, 0xA8, 0x4C, 0x02,
  0x99, 0x27, 0x40, 0x30, 0xCF, 0xFF, 0x82, 0xB1, 0x0B, 0xB0, 0x66, 0x82, 0x26, 0xAE, 0xFF, 0xD8,
  0x2D, 0x95, 0x13, 0x05, 0xC8, 0x49, 0x01, 0x59, 0xDF, 0xFD, 0x82, 0xEA, 0x62, 0x71, 0x0B, 0xC0,
  0xEF, 0xFE, 0x81, 0xB7, 0x37, 0x50, 0x3F, 0xFF, 0x81, 0xD9, 0x47, 0x73, 0x09, 0xFF, 0xA8, 0x2E,
  0xA5, 0x17, 0x76, 0x01, 0x0E, 0xFC, 0x82, 0xEB, 0x72, 0x77, 0x74, 0x07, 0xF9, 0x81, 0xC8, 0x37,
  0x77, 0x72, 0x0C, 0xB8, 0x2D, 0x95, 0x17, 0x77, 0x75, 0x82, 0x16, 0x62, 0x80, 0xCA, 0x40, 0x04,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0x43, 0x0D, 0x80, 0xC0, 0xF0, 0xD3, 0x0D, 0x80, 0xC0, 0xF0, 0xD3,
  0x04, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_flight_takeoff() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 44, 41), Box(0, 0, 47, 47),
      ic_round_48_action_flight_takeoff_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_flip_to_back 48x48, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_round_48_action_flip_to_back_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xD4, 0xC4, 0xC4, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEA, 0x4C, 0x4C, 0x4A, 0x0E,
  0x01, 0x71, 0x0A, 0xB4, 0xC4, 0xC4, 0xB0, 0xA7, 0x10, 0xDB, 0x4C, 0x4C, 0x4B, 0x0D, 0x80, 0xA9,
  0x40, 0x82, 0x4D, 0xD4, 0x4C, 0x77, 0x6C, 0x0D, 0xA0, 0xD4, 0xC7, 0x76, 0xF9, 0x4C, 0x77, 0x6F,
  0x94, 0xC7, 0x76, 0xF9, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C,
  0x4C, 0x77, 0x6F, 0x94, 0xC7, 0x76, 0xF9, 0x4C, 0x77, 0x6F, 0x94, 0xC7, 0x76, 0xF9, 0x77, 0x77,
  0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x40, 0xDB, 0x4C, 0x4C, 0x4B, 0x0D,
  0xC4, 0x0A, 0xB4, 0xC4, 0xC4, 0xB0, 0xAC, 0x40, 0x10, 0xEA, 0x4C, 0x4C, 0x4A, 0x0E, 0x01, 0xC5,
  0x81, 0x1A, 0xD4, 0xC4, 0xC4, 0x81, 0xDA, 0x11, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC0, 0x17,
  0x77, 0x73, 0xC0, 0xB0, 0x17, 0x77, 0x72, 0x0D, 0xFF, 0xFC, 0x0D, 0x04, 0x71, 0x0A, 0xFF, 0xFD,
  0x0D, 0x71, 0x01, 0x0E, 0xFF, 0xFC, 0x0D, 0x72, 0x81, 0x1A, 0xDF, 0xFF, 0x90, 0xD0, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_flip_to_back() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_flip_to_back_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_flip_to_front 48x48, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_round_48_action_flip_to_front_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x10,
  0xAF, 0xFF, 0xD0, 0xA7, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x1C, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBC,
  0x71, 0xC0, 0x17, 0x74, 0x01, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xF9, 0x4C, 0x77, 0x6F,
  0x94, 0xC7, 0x76, 0xF9, 0x4C, 0x77, 0x6F, 0x94, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7,
  0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xF9, 0x4C, 0x77, 0x6F, 0x94, 0xC7, 0x76, 0xF9,
  0x4C, 0x77, 0x6F, 0x94, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x01,
  0x77, 0x40, 0x1C, 0x71, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xF9, 0x40, 0xDF, 0xFF, 0xD0, 0xDC,
  0x40, 0xAF, 0xFF, 0xD0, 0xAC, 0x40, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x1C, 0x58, 0x11, 0xAD, 0xFF,
  0xE8, 0x1D, 0xA1, 0x80, 0xA9, 0x50, 0x0D, 0xB4, 0xC4, 0xC4, 0xC7, 0x10, 0xAB, 0x4C, 0x4C, 0x4C,
  0x71, 0x01, 0x0E, 0xA4, 0xC4, 0xC4, 0xC7, 0x28, 0x11, 0xAD, 0x4C, 0x4C, 0x4C, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_flip_to_front() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_flip_to_front_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_flutter_dash 48x48, 4-bit Alpha,  RLE, 510 bytes.
static const unsigned char ic_round_48_action_flutter_dash_data[] PROGMEM = {
  0x77, 0x58, 0x12, 0xAE, 0x80, 0xC0, 0x00, 0x20, 0xEA, 0x82, 0x7E, 0xE7, 0x77, 0x77, 0x40, 0x9D,
  0x0B, 0x01, 0x77, 0x77, 0x18, 0x14, 0x7B, 0xE0, 0x67, 0x77, 0x68, 0x11, 0x8E, 0xFB, 0x81, 0xE8,
  0x17, 0x77, 0x20, 0x7B, 0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xCA, 0x0E, 0x07, 0x77, 0x60, 0x10,
  0xBA, 0x0A, 0x02, 0x73, 0x02, 0x0A, 0xA0, 0xC0, 0x17, 0x73, 0x83, 0x2D, 0xFD, 0x37, 0x78, 0x33,
  0xDF, 0xD2, 0x75, 0x86, 0x8E, 0xA1, 0xDF, 0xB1, 0x77, 0x28, 0x61, 0xBF, 0xD1, 0xAE, 0x86, 0x01,
  0x0C, 0xA8, 0x93, 0xEC, 0xFB, 0x01, 0x8C, 0xEE, 0xC8, 0x12, 0x89, 0x21, 0x8C, 0xEE, 0xC8, 0x10,
  0xBF, 0xCB, 0x0C, 0x01, 0x40, 0xBD, 0x81, 0xD1, 0x7F, 0x90, 0x06, 0xF9, 0x81, 0x71, 0xDD, 0x0B,
  0x30, 0x6E, 0x03, 0x08, 0xA0, 0x90, 0x32, 0x03, 0x09, 0xC0, 0x90, 0x32, 0x03, 0x09, 0xA0, 0x80,
  0x3E, 0x06, 0x20, 0xED, 0x0A, 0x04, 0xA0, 0x46, 0x82, 0x5E, 0xE5, 0x60, 0x4A, 0x04, 0x0A, 0xD8,
  0x1E, 0x05, 0xE8, 0x22, 0xDF, 0x62, 0x82, 0x7D, 0xD7, 0x20, 0x03, 0x28, 0x27, 0xDD, 0x72, 0x82,
  0x6F, 0xD2, 0xE0, 0x50, 0x9D, 0x82, 0xC3, 0xFD, 0x20, 0x6A, 0x81, 0x2A, 0x64, 0x06, 0xA8, 0x12,
  0xA6, 0x28, 0x2D, 0xF3, 0xCD, 0x09, 0x0D, 0xD8, 0x27, 0x6F, 0x92, 0x0C, 0xA8, 0x1A, 0xDC, 0x40,
  0xCA, 0x81, 0xAD, 0xC2, 0x82, 0x9F, 0x67, 0xD0, 0xD0, 0xED, 0x82, 0x37, 0xF8, 0x20, 0xEC, 0x0E,
  0x40, 0xEC, 0x0E, 0x28, 0x28, 0xF7, 0x3D, 0x0E, 0xE8, 0x22, 0x6F, 0xA2, 0x0C, 0xC0, 0xC4, 0x0C,
  0xC0, 0xC2, 0x82, 0x9F, 0x62, 0xE0, 0xED, 0x18, 0x13, 0xFD, 0x20, 0x6C, 0x06, 0x40, 0x6C, 0x06,
  0x28, 0x1D, 0xF2, 0x1D, 0x0E, 0x0B, 0xD2, 0x81, 0xEF, 0x72, 0x86, 0x7D, 0xD7, 0x01, 0x65, 0x28,
  0x27, 0xDD, 0x72, 0x81, 0x6F, 0xE2, 0xD0, 0xB0, 0x8D, 0x01, 0x05, 0xB0, 0x55, 0x01, 0x0D, 0xA0,
  0x96, 0x04, 0xB0, 0x40, 0x1D, 0x81, 0x81, 0xEC, 0x82, 0x2C, 0xFB, 0xA0, 0xA0, 0x42, 0x01, 0x0C,
  0xB0, 0xE4, 0x03, 0x09, 0xA8, 0x2B, 0xFC, 0x2C, 0x89, 0x3E, 0x10, 0x4D, 0xDD, 0xF8, 0xFD, 0x06,
  0xA0, 0x62, 0x0C, 0xC8, 0x1C, 0x01, 0xC8, 0x91, 0xE6, 0x0D, 0xF7, 0xFD, 0xDD, 0x45, 0x83, 0x8F,
  0xEF, 0x82, 0x01, 0x05, 0x20, 0xBC, 0x87, 0xC2, 0x05, 0xEE, 0xC7, 0x12, 0x83, 0x8F, 0xEF, 0x87,
  0x10, 0x5B, 0x04, 0x50, 0xAB, 0x0E, 0x06, 0x74, 0x04, 0xB0, 0x57, 0x2B, 0x01, 0x40, 0x9B, 0x09,
  0x01, 0x75, 0x01, 0xB0, 0x17, 0x20, 0xAA, 0x40, 0x7A, 0x0B, 0x03, 0x77, 0x1A, 0x0A, 0x73, 0x03,
  0xA0, 0x12, 0x82, 0x4F, 0xC4, 0x77, 0x20, 0x1A, 0x03, 0x74, 0x85, 0xAF, 0xB0, 0x1B, 0x57, 0x74,
  0x81, 0xAF, 0xA7, 0x58, 0x21, 0xEF, 0xA7, 0x76, 0x82, 0x9F, 0xE1, 0x76, 0x83, 0x3E, 0xFB, 0x17,
  0x72, 0x83, 0x1A, 0xFE, 0x37, 0x71, 0x84, 0x3D, 0xFE, 0x71, 0x75, 0x84, 0x17, 0xEF, 0xE3, 0x77,
  0x30, 0x10, 0xAB, 0x83, 0xB7, 0x42, 0x13, 0x82, 0x24, 0x7B, 0xB0, 0xA0, 0x17, 0x76, 0x03, 0x0A,
  0xFF, 0x0A, 0x03, 0x77, 0x73, 0x84, 0xEF, 0x9B, 0xDD, 0xA0, 0x0D, 0xA0, 0x77, 0x77, 0x68, 0x1E,
  0xF1, 0x78, 0x2A, 0xFB, 0x17, 0x77, 0x58, 0x2A, 0xFB, 0x16, 0x02, 0x0E, 0xB0, 0xD7, 0x77, 0x30,
  0x20, 0xEB, 0x0D, 0x50, 0x20, 0xAB, 0x08, 0x77, 0x73, 0x02, 0x0A, 0xB0, 0x86, 0x0D, 0xB0, 0x47,
  0x77, 0x40, 0xDB, 0x04, 0x50, 0xEC, 0x03, 0x77, 0x73, 0x0E, 0xC0, 0x34, 0x0C, 0xC0, 0x57, 0x77,
  0x30, 0xCC, 0x05, 0x48, 0x35, 0xED, 0xA3, 0x77, 0x74, 0x83, 0x5E, 0xDA, 0x37, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_flutter_dash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 43, 45), Box(0, 0, 47, 47),
      ic_round_48_action_flutter_dash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_free_cancellation 48x48, 4-bit Alpha,  RLE, 254 bytes.
static const unsigned char ic_round_48_action_free_cancellation_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x72, 0x82, 0x4D, 0xD4, 0x77, 0x0D, 0xA0, 0xD7, 0x72, 0x0D, 0xA0, 0xD7,
  0x7C, 0x77, 0x2C, 0x77, 0xC7, 0x72, 0xC7, 0x28, 0x11, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x13, 0x01,
  0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x12, 0x09, 0xFF, 0xFF, 0xE0, 0xA2, 0x0D, 0xFF, 0xFF, 0xE0, 0xD2,
  0x80, 0xC0, 0xF2, 0x80, 0xC0, 0xF2, 0x80, 0xC0, 0xF2, 0x80, 0xC0, 0xF2, 0x80, 0xC0, 0xF2, 0x80,
  0xC0, 0xF2, 0x80, 0xC0, 0xF2, 0x80, 0xC0, 0xF2, 0xC7, 0x77, 0x7C, 0x2C, 0x77, 0x77, 0xC2, 0xC4,
  0x01, 0x60, 0x17, 0x72, 0xC2, 0xC3, 0x82, 0x8F, 0xE5, 0x28, 0x25, 0xEF, 0x87, 0x71, 0xC2, 0xC2,
  0x01, 0xC0, 0x05, 0xC0, 0x17, 0x7C, 0x2C, 0x30, 0xEF, 0x90, 0xE7, 0x71, 0xC2, 0xC3, 0x05, 0xF9,
  0x05, 0x77, 0x10, 0xCA, 0x0D, 0x2C, 0x40, 0x5E, 0x05, 0x77, 0x28, 0x23, 0xCC, 0x32, 0xC4, 0x05,
  0xE0, 0x57, 0x77, 0x1C, 0x30, 0x5F, 0x90, 0x57, 0x77, 0xC3, 0x0E, 0xF9, 0x0E, 0x77, 0x7C, 0x20,
  0x1C, 0x00, 0x5C, 0x01, 0x77, 0x28, 0x11, 0x41, 0x1C, 0x38, 0x28, 0xFE, 0x52, 0x82, 0x5E, 0xF8,
  0x77, 0x28, 0x32, 0xDF, 0xE2, 0xC4, 0x01, 0x60, 0x17, 0x72, 0x02, 0x0E, 0xB0, 0x7C, 0x77, 0x76,
  0x02, 0x0E, 0xC0, 0x4C, 0x77, 0x75, 0x02, 0x0E, 0xC0, 0x81, 0xC7, 0x73, 0x82, 0x7F, 0xD3, 0x40,
  0x20, 0xEC, 0x08, 0x2C, 0x77, 0x20, 0x1B, 0x0E, 0x03, 0x20, 0x20, 0xEC, 0x08, 0x3C, 0x77, 0x3C,
  0x82, 0xE3, 0x2E, 0xC0, 0x84, 0xC7, 0x73, 0x06, 0xC0, 0x0E, 0xC0, 0x85, 0x0D, 0xFF, 0x90, 0xB0,
  0x14, 0x06, 0xF9, 0x08, 0x60, 0xAF, 0xFA, 0x07, 0x50, 0x6E, 0x08, 0x70, 0x10, 0xEF, 0xF9, 0x06,
  0x60, 0x6C, 0x08, 0x72, 0x81, 0x1A, 0xDF, 0xD0, 0xA7, 0x18, 0x25, 0xEF, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_free_cancellation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_free_cancellation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_gavel 48x48, 4-bit Alpha,  RLE, 379 bytes.
static const unsigned char ic_round_48_action_gavel_data[] PROGMEM = {
  0x77, 0x78, 0x11, 0x42, 0x80, 0xC1, 0x00, 0x9B, 0x0C, 0x02, 0x77, 0x77, 0x50, 0x10, 0xCD, 0x0E,
  0x03, 0x77, 0x77, 0x30, 0x10, 0xCF, 0x0E, 0x03, 0x77, 0x77, 0x20, 0xBF, 0xA0, 0xE0, 0x37, 0x77,
  0x71, 0x03, 0x0E, 0xFA, 0x0E, 0x03, 0x77, 0x77, 0x10, 0x30, 0xEF, 0xA0, 0xE0, 0x37, 0x77, 0x20,
  0x10, 0x34, 0x03, 0x0E, 0xFA, 0x0E, 0x02, 0x77, 0x78, 0x21, 0xCE, 0x34, 0x03, 0x0E, 0xFA, 0x0C,
  0x77, 0x60, 0x10, 0xCA, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xA0, 0x27, 0x74, 0x01, 0x0C, 0xC0, 0xE0,
  0x34, 0x03, 0x0E, 0xF9, 0x03, 0x77, 0x30, 0x10, 0xCE, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0x01, 0x77,
  0x20, 0x10, 0xCF, 0x90, 0xE0, 0x34, 0x03, 0x0E, 0xD0, 0x87, 0x73, 0x03, 0x0E, 0xFA, 0x0E, 0x03,
  0x40, 0x30, 0xEB, 0x0B, 0x77, 0x50, 0x30, 0xEF, 0xA0, 0xE0, 0x34, 0x82, 0x3E, 0xFB, 0x77, 0x70,
  0x30, 0xEF, 0xA0, 0xE0, 0x34, 0x03, 0x0A, 0x77, 0x28, 0x11, 0xB3, 0x40, 0x30, 0xEF, 0xA0, 0xE0,
  0x37, 0x76, 0x83, 0x1C, 0xFE, 0x34, 0x03, 0x0E, 0xFA, 0x0E, 0x03, 0x77, 0x40, 0x10, 0xCB, 0x0E,
  0x03, 0x40, 0x30, 0xEF, 0xA0, 0xE0, 0x37, 0x73, 0x09, 0xD0, 0xE0, 0x34, 0x03, 0x0E, 0xFA, 0x0E,
  0x03, 0x77, 0x10, 0x1F, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xA0, 0xE0, 0x37, 0x70, 0x4F, 0x90, 0xE0,
  0x34, 0x03, 0x0E, 0xFA, 0x0E, 0x03, 0x76, 0x02, 0xFA, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xA0, 0xE0,
  0x37, 0x60, 0xBF, 0xA0, 0xE0, 0x34, 0x03, 0x0E, 0xFA, 0x0E, 0x03, 0x75, 0x02, 0x0E, 0xFA, 0x0E,
  0x03, 0x40, 0x30, 0xEF, 0xA0, 0xE0, 0x37, 0x50, 0x20, 0xEF, 0xA0, 0xE0, 0x34, 0x03, 0x0E, 0xFA,
  0x0E, 0x03, 0x75, 0x02, 0x0E, 0xFA, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xA0, 0xE0, 0x37, 0x50, 0x20,
  0xEF, 0xA0, 0xA5, 0x03, 0x0E, 0xFA, 0x0E, 0x03, 0x75, 0x02, 0x0E, 0xF0, 0xB7, 0x03, 0x0E, 0xFA,
  0x0E, 0x03, 0x75, 0x02, 0x0E, 0xD0, 0xB7, 0x20, 0x30, 0xEF, 0xA0, 0xE0, 0x37, 0x50, 0x20, 0xBB,
  0x08, 0x74, 0x03, 0x0E, 0xFA, 0x0E, 0x03, 0x76, 0x01, 0x03, 0x77, 0x03, 0x0E, 0xFA, 0x0E, 0x03,
  0x77, 0x77, 0x10, 0x30, 0xEF, 0xA0, 0xE0, 0x37, 0x77, 0x71, 0x03, 0x0E, 0xFA, 0x0D, 0x01, 0x77,
  0x77, 0x10, 0x30, 0xEF, 0xA0, 0x77, 0x77, 0x72, 0x03, 0x0E, 0xF9, 0x0A, 0x77, 0x77, 0x30, 0x30,
  0xEF, 0x09, 0x77, 0x77, 0x40, 0x30, 0xEE, 0x04, 0x77, 0x77, 0x50, 0x30, 0xDC, 0x82, 0x90, 0x4D,
  0xFF, 0xE0, 0xD0, 0x47, 0x38, 0x31, 0x7A, 0x94, 0x20, 0xDF, 0xFF, 0x90, 0xD7, 0x73, 0x0D, 0xFF,
  0xF9, 0x0D, 0x77, 0x30, 0x40, 0xDF, 0xFE, 0x0D, 0x04, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_gavel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 42, 45), Box(0, 0, 47, 47),
      ic_round_48_action_gavel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_generating_tokens 48x48, 4-bit Alpha,  RLE, 328 bytes.
static const unsigned char ic_round_48_action_generating_tokens_data[] PROGMEM = {
  0x77, 0x77, 0x70, 0x05, 0x80, 0xC4, 0x00, 0x2A, 0x02, 0x80, 0xC3, 0x00, 0x9A, 0x09, 0x80, 0xC2,
  0x00, 0x10, 0xEA, 0x0E, 0x01, 0x80, 0xC0, 0x00, 0x10, 0x9C, 0x09, 0x01, 0x77, 0x89, 0x04, 0x9B,
  0xDE, 0xED, 0xB9, 0x47, 0x28, 0x12, 0x8E, 0xF0, 0x90, 0x27, 0x28, 0x11, 0x9E, 0xFB, 0x81, 0xE9,
  0x15, 0x05, 0xFD, 0x05, 0x70, 0x70, 0xEF, 0xF0, 0xE0, 0x74, 0x05, 0xFD, 0x05, 0x50, 0x10, 0xCF,
  0xFC, 0x0C, 0x01, 0x38, 0x12, 0x9E, 0xE8, 0x1E, 0x82, 0x50, 0x20, 0xDF, 0xFE, 0x0D, 0x02, 0x40,
  0x10, 0x9C, 0x09, 0x01, 0x60, 0x10, 0xDF, 0xFF, 0x90, 0xD0, 0x14, 0x01, 0x0E, 0xA0, 0xE0, 0x17,
  0x0C, 0xFF, 0xFB, 0x0C, 0x50, 0x8A, 0x09, 0x70, 0x7F, 0xFF, 0xD0, 0x74, 0x02, 0xA0, 0x26, 0x01,
  0x0E, 0xFF, 0xFD, 0x0E, 0x01, 0x40, 0x05, 0x70, 0x9F, 0xFF, 0xF0, 0x97, 0x60, 0xEF, 0x90, 0x77,
  0x30, 0x7F, 0x90, 0xE7, 0x50, 0x4F, 0xA7, 0x5F, 0xA0, 0x47, 0x40, 0x9F, 0xA0, 0x77, 0x30, 0x7F,
  0xA0, 0x97, 0x40, 0xBF, 0xE4, 0xFE, 0x0B, 0x74, 0x0D, 0xFE, 0x4F, 0xE0, 0xD7, 0x40, 0xEF, 0xE4,
  0xFE, 0x0E, 0x74, 0x0E, 0xFE, 0x4F, 0xE0, 0xE7, 0x40, 0xDF, 0xE4, 0xFE, 0x0D, 0x74, 0x0B, 0xFE,
  0x4F, 0xE0, 0xB7, 0x40, 0x9F, 0xE4, 0xFE, 0x09, 0x74, 0x04, 0xFE, 0x4F, 0xE0, 0x47, 0x50, 0xEF,
  0xD0, 0x12, 0x01, 0xFD, 0x0E, 0x76, 0x09, 0xFD, 0x82, 0xB1, 0x1B, 0xFD, 0x09, 0x76, 0x01, 0x0E,
  0xFF, 0xFD, 0x0E, 0x01, 0x40, 0x05, 0x71, 0x07, 0xFF, 0xFD, 0x07, 0x40, 0x2A, 0x02, 0x71, 0x0C,
  0xFF, 0xFB, 0x0C, 0x50, 0x9A, 0x09, 0x71, 0x01, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x40, 0x10, 0xEA,
  0x0E, 0x01, 0x71, 0x02, 0x0D, 0xFF, 0xE0, 0xD0, 0x24, 0x01, 0x09, 0xC0, 0x90, 0x17, 0x10, 0x10,
  0xCF, 0xFC, 0x0C, 0x01, 0x38, 0x12, 0x8E, 0xF0, 0x90, 0x27, 0x10, 0x70, 0xEF, 0xF0, 0xE0, 0x74,
  0x05, 0xFD, 0x05, 0x71, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x50, 0x5F, 0xD0, 0x57, 0x48, 0x90,
  0x49, 0xBD, 0xEE, 0xDB, 0x94, 0x72, 0x81, 0x29, 0xEE, 0x81, 0xE8, 0x27, 0x77, 0x75, 0x01, 0x09,
  0xC0, 0x90, 0x18, 0x0C, 0x00, 0x01, 0x0E, 0xA0, 0xE0, 0x18, 0x0C, 0x20, 0x08, 0xA0, 0x98, 0x0C,
  0x30, 0x02, 0xA0, 0x28, 0x0C, 0x40, 0x00, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_generating_tokens() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 44, 44), Box(0, 0, 47, 47),
      ic_round_48_action_generating_tokens_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_get_app 48x48, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_round_48_action_get_app_data[] PROGMEM = {
  0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x20, 0xDF, 0xB0, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7,
  0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72,
  0xFD, 0x77, 0x2F, 0xD7, 0x40, 0x60, 0xDF, 0xFC, 0x0E, 0x06, 0x6F, 0xFF, 0x95, 0x01, 0xFF, 0xF0,
  0xE0, 0x15, 0x07, 0xFF, 0xE0, 0x77, 0x08, 0xFF, 0xC0, 0x77, 0x20, 0x8F, 0xFA, 0x07, 0x74, 0x08,
  0xFF, 0x07, 0x76, 0x08, 0xFD, 0x07, 0x77, 0x10, 0x8F, 0xB0, 0x77, 0x73, 0x08, 0xF9, 0x07, 0x77,
  0x50, 0x8E, 0x07, 0x77, 0x70, 0x8C, 0x07, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x40, 0x01, 0x80,
  0x9F, 0x10, 0x04, 0x0D, 0xFF, 0xFB, 0x81, 0xD4, 0xDF, 0xFF, 0xD0, 0x0D, 0xFF, 0xFD, 0x81, 0xD4,
  0xDF, 0xFF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_get_app() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 39), Box(0, 0, 47, 47),
      ic_round_48_action_get_app_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_gif_box 48x48, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_48_action_gif_box_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xDD, 0x5F, 0x0B, 0x01, 0x30, 0x3A, 0x00, 0x3A, 0x03,
  0x40, 0x3F, 0xFC, 0x01, 0x40, 0x3A, 0x2A, 0x50, 0x3F, 0xFC, 0x2E, 0x2A, 0x2F, 0xFF, 0x92, 0xE2,
  0xA4, 0x03, 0xFF, 0xD2, 0xA0, 0x03, 0xA2, 0xA4, 0x03, 0xFF, 0xD2, 0xA2, 0xA2, 0xA2, 0xFF, 0xF9,
  0x01, 0x40, 0x1A, 0x2A, 0x2F, 0xFF, 0x90, 0xB0, 0x12, 0x01, 0x0B, 0xA0, 0x03, 0xA0, 0x03, 0x80,
  0xDE, 0x1F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84,
  0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_gif_box() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_gif_box_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_gif 48x48, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_48_action_gif_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0x83, 0x81, 0x8E, 0x83, 0x04, 0x0D, 0xE0, 0x80, 0xDF, 0x90, 0xE3, 0xB3, 0x0D,
  0xF0, 0xEF, 0xA0, 0x83, 0xB3, 0xF9, 0x08, 0xB7, 0x3B, 0x3B, 0x6B, 0x73, 0xB3, 0xB6, 0xB7, 0x3B,
  0x3E, 0x08, 0x2B, 0x48, 0x18, 0xE8, 0x3B, 0x3E, 0x0E, 0x2B, 0x4B, 0x3B, 0x3E, 0x08, 0x2B, 0x4B,
  0x3B, 0x3B, 0x6F, 0xB3, 0xB3, 0xB6, 0x0D, 0xF9, 0x0D, 0x3B, 0x3B, 0x60, 0x40, 0xDE, 0x0D, 0x04,
  0x38, 0x18, 0xE8, 0x38, 0x18, 0xE8, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_gif() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 18, 37, 29), Box(0, 0, 47, 47),
      ic_round_48_action_gif_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_grade 48x48, 4-bit Alpha,  RLE, 222 bytes.
static const unsigned char ic_round_48_action_grade_data[] PROGMEM = {
  0x77, 0x40, 0x03, 0x77, 0x77, 0x78, 0x21, 0xEE, 0x17, 0x77, 0x76, 0x07, 0xA0, 0x77, 0x77, 0x76,
  0x0D, 0xA0, 0xD7, 0x77, 0x75, 0x05, 0xC0, 0x57, 0x77, 0x74, 0x0B, 0xC0, 0xB7, 0x77, 0x73, 0x02,
  0xE0, 0x27, 0x77, 0x72, 0x09, 0xE0, 0x97, 0x77, 0x71, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x77, 0x70,
  0x6F, 0x90, 0x67, 0x77, 0x70, 0xDF, 0x90, 0xD7, 0x77, 0x60, 0x4F, 0xB0, 0x47, 0x74, 0x87, 0x12,
  0x35, 0x67, 0x9A, 0xDF, 0xB8, 0x7D, 0xA9, 0x76, 0x53, 0x21, 0x58, 0x22, 0xBC, 0xDF, 0xFF, 0xFA,
  0x83, 0xDC, 0xB2, 0x68, 0x0C, 0x0F, 0x81, 0x70, 0x9F, 0xFF, 0xFE, 0x0A, 0x30, 0x7F, 0xFF, 0xFC,
  0x08, 0x50, 0x5F, 0xFF, 0xFA, 0x06, 0x70, 0x40, 0xEF, 0xFF, 0xD0, 0xE0, 0x47, 0x20, 0x20, 0xDF,
  0xFF, 0xB0, 0xD0, 0x27, 0x40, 0x10, 0xCF, 0xFF, 0x90, 0xC0, 0x17, 0x70, 0xAF, 0xFE, 0x0B, 0x77,
  0x30, 0x8F, 0xFC, 0x09, 0x77, 0x40, 0x3F, 0xFC, 0x03, 0x77, 0x40, 0x6F, 0xFC, 0x07, 0x77, 0x40,
  0xAF, 0xFC, 0x0A, 0x77, 0x40, 0xEF, 0xFC, 0x0E, 0x77, 0x30, 0x2F, 0xFE, 0x02, 0x77, 0x20, 0x5F,
  0xFE, 0x06, 0x77, 0x20, 0x9F, 0xA0, 0x0C, 0xFA, 0x09, 0x77, 0x20, 0xDF, 0x0E, 0x06, 0x20, 0x60,
  0xEF, 0x0D, 0x77, 0x10, 0x1F, 0x0A, 0x01, 0x40, 0x10, 0xAF, 0x01, 0x77, 0x04, 0xD0, 0xD0, 0x47,
  0x10, 0x30, 0xDD, 0x05, 0x77, 0x08, 0xB0, 0xE0, 0x77, 0x50, 0x70, 0xEB, 0x08, 0x77, 0x0B, 0xA0,
  0xA0, 0x17, 0x70, 0x10, 0xAA, 0x0C, 0x77, 0x81, 0x8C, 0x47, 0x74, 0x81, 0x4C, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_grade() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 42, 40), Box(0, 0, 47, 47),
      ic_round_48_action_grade_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_grading 48x48, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_round_48_action_grading_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF,
  0xFF, 0xF0, 0xD0, 0x48, 0x09, 0xF4, 0x00, 0x40, 0xDF, 0xFF, 0xF8, 0x1D, 0x4D, 0xFF, 0xFF, 0xA0,
  0x0D, 0xFF, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xFF, 0x0D, 0x04, 0x80, 0x9F, 0x40, 0x04, 0x0D, 0xFF,
  0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF, 0xFF, 0xF0, 0xD0,
  0x48, 0x09, 0xF4, 0x00, 0x40, 0xDF, 0xB0, 0xD0, 0x47, 0x71, 0x01, 0x20, 0xDF, 0xD0, 0xD7, 0x68,
  0x45, 0xEF, 0x80, 0xDF, 0xD0, 0xD7, 0x50, 0x5C, 0x81, 0x14, 0xDF, 0xB0, 0xD0, 0x47, 0x40, 0x5C,
  0x0E, 0x77, 0x58, 0x21, 0x88, 0x12, 0x05, 0xD0, 0x57, 0x75, 0x0B, 0xA8, 0x1D, 0x15, 0xD0, 0x57,
  0x76, 0x0E, 0xB0, 0xDD, 0x05, 0x77, 0x70, 0x8F, 0x90, 0x54, 0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x50,
  0xAE, 0x05, 0x50, 0xDF, 0xD0, 0xD6, 0x0A, 0xC0, 0x56, 0x0D, 0xFD, 0x0D, 0x78, 0x29, 0xFE, 0x57,
  0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x71, 0x01, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_grading() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 39, 41), Box(0, 0, 47, 47),
      ic_round_48_action_grading_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_group_work 48x48, 4-bit Alpha,  RLE, 290 bytes.
static const unsigned char ic_round_48_action_group_work_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFD, 0x0A, 0x03, 0x20, 0x30, 0xAF, 0xD0, 0x97, 0x05, 0xFD, 0x07, 0x60, 0x7F, 0xD0, 0x55, 0x01,
  0x0E, 0xFC, 0x0A, 0x71, 0x0A, 0xFC, 0x0E, 0x01, 0x40, 0x9F, 0xD0, 0x37, 0x10, 0x3F, 0xD0, 0x93,
  0x01, 0xFE, 0x73, 0xFE, 0x01, 0x20, 0x8F, 0xE7, 0x3F, 0xE0, 0x82, 0x0D, 0xFE, 0x03, 0x71, 0x03,
  0xFE, 0x81, 0xD0, 0x3F, 0xF0, 0xA7, 0x10, 0xAF, 0xF0, 0x30, 0x7F, 0xF9, 0x07, 0x60, 0x7F, 0xF9,
  0x07, 0x0A, 0xFF, 0xA0, 0xA0, 0x32, 0x03, 0x0A, 0xFF, 0xA0, 0xA0, 0xC8, 0x0C, 0x2F, 0x0C, 0x0E,
  0x80, 0xC2, 0xF0, 0xE8, 0x09, 0x94, 0xF0, 0xEF, 0x90, 0xA0, 0x32, 0x03, 0x0A, 0xFB, 0x0A, 0x03,
  0x20, 0x30, 0xAF, 0x90, 0xE0, 0xCF, 0x07, 0x60, 0x7F, 0x90, 0x76, 0x07, 0xF0, 0xC0, 0xAE, 0x0A,
  0x71, 0x0A, 0xE0, 0xA7, 0x10, 0xAE, 0x0A, 0x07, 0xE0, 0x37, 0x10, 0x3E, 0x03, 0x71, 0x03, 0xE0,
  0x70, 0x3E, 0x73, 0xE7, 0x3E, 0x81, 0x30, 0xDD, 0x73, 0xE7, 0x3D, 0x0D, 0x20, 0x8D, 0x03, 0x71,
  0x03, 0xE0, 0x37, 0x10, 0x3D, 0x08, 0x20, 0x1D, 0x0A, 0x71, 0x0A, 0xE0, 0xA7, 0x10, 0xAD, 0x01,
  0x30, 0x9D, 0x07, 0x60, 0x7F, 0x90, 0x76, 0x07, 0xD0, 0x94, 0x01, 0x0E, 0xD0, 0xA0, 0x32, 0x03,
  0x0A, 0xFB, 0x0A, 0x03, 0x20, 0x30, 0xAD, 0x0E, 0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F,
  0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF,
  0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01,
  0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA,
  0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_group_work() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_group_work_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_g_translate 48x48, 4-bit Alpha,  RLE, 327 bytes.
static const unsigned char ic_round_48_action_g_translate_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFD, 0x02, 0x77, 0x72, 0x01, 0x0E, 0xFF, 0x06, 0x77, 0x72, 0x0A, 0xFF, 0x90,
  0xB7, 0x77, 0x20, 0xDF, 0xFA, 0x77, 0x72, 0xFF, 0xB0, 0x47, 0x77, 0x1F, 0xFB, 0x09, 0x77, 0x71,
  0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x18, 0x0C, 0x2F, 0x0E, 0x01, 0xFA, 0x81, 0xDD, 0xEE, 0x07, 0x77,
  0x38, 0x21, 0xBF, 0xAE, 0x0C, 0x05, 0x48, 0x12, 0x7E, 0xB0, 0xC7, 0x74, 0x81, 0x1F, 0xDD, 0x06,
  0x71, 0x01, 0x0A, 0xB0, 0x17, 0x74, 0xE0, 0x57, 0x30, 0x7B, 0x05, 0x77, 0x4D, 0x08, 0x48, 0x56,
  0xAC, 0xA4, 0x08, 0xC0, 0xA7, 0x74, 0xC0, 0xE3, 0x01, 0x0B, 0xD0, 0xCD, 0x0E, 0x77, 0x4C, 0x09,
  0x30, 0x9F, 0xE0, 0x43, 0x81, 0x5F, 0xB7, 0x4C, 0x05, 0x20, 0x1C, 0x80, 0x4D, 0xA0, 0x83, 0x81,
  0x5F, 0xB7, 0x4C, 0x03, 0x20, 0x4C, 0x02, 0x78, 0x7D, 0xFE, 0xDD, 0xDE, 0xFE, 0x80, 0x3D, 0x4C,
  0x03, 0x20, 0x4C, 0x02, 0x70, 0xDF, 0xF9, 0x4C, 0x05, 0x20, 0x1C, 0x04, 0x80, 0x01, 0x30, 0xEA,
  0x08, 0x80, 0x31, 0x83, 0xCF, 0x61, 0x14, 0xC0, 0x93, 0x09, 0xF0, 0x52, 0x02, 0xB0, 0xB6, 0x02,
  0xA7, 0xC0, 0xE3, 0x01, 0x0B, 0xD0, 0x93, 0x07, 0xC8, 0x1B, 0xB1, 0x38, 0x1A, 0xF9, 0x7D, 0x08,
  0x48, 0x36, 0xAC, 0xA4, 0x40, 0xDE, 0x0A, 0x20, 0x3A, 0x02, 0x7E, 0x05, 0x74, 0x0A, 0xD0, 0xCA,
  0x83, 0x50, 0xDF, 0x87, 0x1F, 0x07, 0x72, 0x0A, 0xE8, 0x5D, 0x7F, 0xEB, 0xFD, 0x72, 0xF9, 0x81,
  0xC5, 0x13, 0x81, 0x16, 0xDF, 0x90, 0x30, 0xBA, 0x0E, 0x02, 0x72, 0xFC, 0x81, 0xDD, 0xEF, 0xC0,
  0x70, 0x9A, 0x0D, 0x01, 0x72, 0xFF, 0xFF, 0x82, 0xDF, 0xD1, 0x71, 0xFF, 0xFE, 0x84, 0x51, 0xCF,
  0xD1, 0x7F, 0xFF, 0xD0, 0x82, 0x83, 0x1C, 0xFD, 0x16, 0xFF, 0xFD, 0x0A, 0x38, 0x31, 0xCF, 0xD1,
  0x5A, 0x0D, 0xFF, 0xFA, 0x0E, 0x48, 0x21, 0xCF, 0xC5, 0xA0, 0xAF, 0xFF, 0xB0, 0x44, 0x81, 0x1B,
  0x25, 0xA0, 0x10, 0xEF, 0xFF, 0xA0, 0x87, 0x5A, 0x18, 0x11, 0xAD, 0xFF, 0xF0, 0xD7, 0x5A, 0x77,
  0x40, 0xCE, 0x07, 0x75, 0xA7, 0x74, 0x07, 0xD0, 0x77, 0x6A, 0x77, 0x40, 0x2C, 0x07, 0x76, 0x81,
  0x1F, 0xD7, 0x75, 0x0C, 0xA0, 0x77, 0x68, 0x21, 0xBF, 0xA7, 0x75, 0x07, 0xFF, 0xC0, 0xE0, 0x17,
  0x75, 0x02, 0xFF, 0xA8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_g_translate() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_g_translate_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_help_center 48x48, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_round_48_action_help_center_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0x9A, 0x2F, 0x81, 0xD7, 0x22, 0x81, 0x26, 0xCF, 0xFF,
  0xE0, 0x97, 0x10, 0x7F, 0xFF, 0xC0, 0x97, 0x30, 0x6F, 0xFF, 0xA0, 0xD4, 0x82, 0x38, 0x84, 0x40,
  0xCF, 0xFF, 0x90, 0xD3, 0x07, 0xC0, 0x93, 0x06, 0xFF, 0xFA, 0x81, 0x93, 0x7E, 0x02, 0x20, 0x3F,
  0xFF, 0xFC, 0x03, 0x20, 0x2F, 0xFF, 0xFB, 0x0E, 0x30, 0x4F, 0xFF, 0xFB, 0x05, 0x30, 0xAF, 0xFF,
  0xFA, 0x06, 0x30, 0x3F, 0xFF, 0xFA, 0x06, 0x30, 0x10, 0xDF, 0xFF, 0xF9, 0x07, 0x30, 0x10, 0xDF,
  0xFF, 0xF9, 0x0C, 0x30, 0x10, 0xDF, 0xFF, 0xFA, 0x06, 0x30, 0x9F, 0xFF, 0xFB, 0x04, 0x3F, 0xFF,
  0xFC, 0x08, 0x20, 0x5F, 0xFF, 0xFD, 0x00, 0xB8, 0x09, 0xC5, 0xF8, 0x28, 0x11, 0x7F, 0xFF, 0xFB,
  0x0B, 0x40, 0xBF, 0xFF, 0xFA, 0x08, 0x40, 0x8F, 0xFF, 0xFA, 0x0B, 0x40, 0xBF, 0xFF, 0xFB, 0x82,
  0x81, 0x18, 0x80, 0x9A, 0x4F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF,
  0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_help_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_help_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_help_outline 48x48, 4-bit Alpha,  RLE, 372 bytes.
static const unsigned char ic_round_48_action_help_outline_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x16, 0x81, 0x28, 0xDA, 0x81, 0xC9, 0x26, 0x01, 0x0C,
  0xC0, 0x55, 0x01, 0x0E, 0xB0, 0xE0, 0x16, 0x09, 0xF9, 0x08, 0x60, 0x10, 0xEB, 0x0E, 0x01, 0x40,
  0x9C, 0x03, 0x60, 0xBF, 0xB0, 0xA6, 0x03, 0xC0, 0x93, 0x01, 0xC0, 0x76, 0x08, 0xFD, 0x08, 0x60,
  0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x60, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x26, 0x0E, 0xB0, 0x82,
  0x0D, 0xB0, 0x66, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x86, 0x06, 0xB8, 0x1D, 0x03, 0xC7,
  0x09, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0xC0, 0x30, 0x7B, 0x0B, 0x78, 0x22, 0xCF, 0x97, 0x01, 0xB0,
  0xE7, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x77, 0x5B, 0x0E, 0x70, 0x6B, 0x0A, 0x0C, 0xB0, 0x37, 0x74,
  0x05, 0xB0, 0xB7, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x77, 0x30, 0x30, 0xEB, 0x05, 0x70, 0x2B, 0x0E,
  0xC7, 0x73, 0x04, 0x0E, 0xB0, 0xA7, 0x2F, 0x97, 0x72, 0x07, 0xC0, 0xA7, 0x3C, 0x0E, 0xB0, 0x27,
  0x70, 0x7C, 0x09, 0x73, 0x02, 0xB0, 0xE0, 0xCB, 0x03, 0x76, 0x02, 0xC0, 0x97, 0x40, 0x3B, 0x0C,
  0x0A, 0xB0, 0x67, 0x60, 0x9B, 0x0C, 0x75, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x76, 0x0D, 0xB0, 0x47,
  0x50, 0xBB, 0x07, 0x03, 0xC7, 0x60, 0xEB, 0x01, 0x75, 0xC8, 0x13, 0x0D, 0xB0, 0x67, 0x77, 0x70,
  0x6B, 0x0D, 0x20, 0x8B, 0x0E, 0x77, 0x77, 0x0E, 0xB0, 0x82, 0x01, 0xC0, 0x77, 0x4C, 0x74, 0x07,
  0xC0, 0x13, 0x09, 0xC0, 0x37, 0x3C, 0x73, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x2C,
  0x72, 0x01, 0x0E, 0xB0, 0xE0, 0x15, 0x05, 0xC0, 0xC0, 0x17, 0x1C, 0x71, 0x01, 0x0C, 0xC0, 0x57,
  0x09, 0xC0, 0xE0, 0x37, 0x74, 0x03, 0x0E, 0xC0, 0x97, 0x20, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A,
  0x74, 0x0A, 0xD0, 0xE0, 0x67, 0x50, 0x60, 0xED, 0x0A, 0x76, 0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82,
  0x23, 0x6B, 0xF0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0,
  0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83,
  0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_help_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_help_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_help 48x48, 4-bit Alpha,  RLE, 291 bytes.
static const unsigned char ic_round_48_action_help_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFB, 0x86, 0xD7, 0x31, 0x14,
  0x9E, 0xFB, 0x0A, 0x72, 0x09, 0xFB, 0x07, 0x70, 0x10, 0xAF, 0xB0, 0x97, 0x05, 0xFB, 0x04, 0x73,
  0x08, 0xFB, 0x05, 0x50, 0x10, 0xEF, 0xA0, 0x67, 0x50, 0xAF, 0xA0, 0xE0, 0x14, 0x09, 0xFA, 0x0D,
  0x48, 0x41, 0x9E, 0xDA, 0x23, 0x01, 0x0E, 0xFA, 0x09, 0x30, 0x1F, 0xB0, 0x63, 0x02, 0x0E, 0xC0,
  0xE0, 0x23, 0x07, 0xFB, 0x01, 0x20, 0x8F, 0xB0, 0x53, 0x0A, 0xE0, 0xA3, 0x03, 0xFB, 0x08, 0x20,
  0xDF, 0xB8, 0x2C, 0x10, 0x5F, 0x0E, 0x4F, 0xB8, 0x1D, 0x03, 0xFF, 0xF9, 0x0E, 0x4F, 0xC0, 0x30,
  0x7F, 0xFF, 0x90, 0xA3, 0x03, 0xFC, 0x07, 0x0A, 0xFF, 0xF0, 0xE0, 0x23, 0x08, 0xFC, 0x0A, 0x0C,
  0xFF, 0xE0, 0xE0, 0x33, 0x01, 0x0E, 0xFC, 0x0C, 0x0E, 0xFF, 0xD0, 0xE0, 0x33, 0x01, 0x0C, 0xFD,
  0x0E, 0xFF, 0xE0, 0x34, 0x0C, 0xFF, 0xFF, 0xD0, 0x64, 0x0B, 0xFF, 0x90, 0xEF, 0xFB, 0x0D, 0x40,
  0x9F, 0xF9, 0x0E, 0x0C, 0xFF, 0xB0, 0x63, 0x04, 0xFF, 0xA0, 0xC0, 0xAF, 0xFB, 0x02, 0x30, 0xAF,
  0xFA, 0x0A, 0x07, 0xFF, 0xB4, 0x0D, 0xFF, 0xA0, 0x70, 0x3F, 0xFB, 0x4F, 0xFB, 0x81, 0x30, 0xD8,
  0x0C, 0x0F, 0x0D, 0x20, 0x88, 0x0C, 0x0F, 0x08, 0x20, 0x18, 0x0C, 0x0F, 0x01, 0x30, 0x9F, 0xFF,
  0xFE, 0x09, 0x40, 0x10, 0xEF, 0xF4, 0xFF, 0x0E, 0x01, 0x50, 0x5F, 0xF4, 0xFF, 0x05, 0x70, 0x9F,
  0xE4, 0xFE, 0x09, 0x72, 0x0A, 0xFD, 0x4F, 0xD0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F,
  0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90,
  0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC,
  0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_hide_source 48x48, 4-bit Alpha,  RLE, 402 bytes.
static const unsigned char ic_round_48_action_hide_source_data[] PROGMEM = {
  0x77, 0x18, 0x33, 0x6A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77, 0x75, 0x81, 0x17, 0xDF, 0xD8, 0x1D,
  0x81, 0x75, 0x81, 0x27, 0x47, 0x08, 0xFF, 0xC0, 0x90, 0x17, 0x20, 0x20, 0xEA, 0x07, 0x50, 0xAF,
  0xFE, 0x0E, 0x05, 0x71, 0x05, 0xC0, 0x75, 0x0C, 0xC8, 0x2A, 0x63, 0x12, 0x82, 0x23, 0x6B, 0xF0,
  0x97, 0x01, 0x0E, 0xC0, 0x74, 0x82, 0x1C, 0xD6, 0x75, 0x06, 0x0E, 0xD0, 0xA7, 0x03, 0x0E, 0xC0,
  0x77, 0x77, 0x07, 0xD0, 0xA7, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x97, 0x03, 0x0E,
  0xC0, 0x77, 0x77, 0x01, 0x0C, 0xC0, 0x57, 0x0E, 0xD0, 0x77, 0x77, 0x01, 0x0E, 0xB0, 0xE0, 0x15,
  0x07, 0xF0, 0x77, 0x77, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xF9, 0x07, 0x77, 0x70, 0x7C, 0x01, 0x30,
  0x7B, 0x81, 0xD3, 0xEC, 0x07, 0x77, 0x70, 0xEB, 0x08, 0x30, 0xDB, 0x82, 0x60, 0x3E, 0xC0, 0x77,
  0x76, 0x06, 0xB0, 0xD2, 0x02, 0xB0, 0xE3, 0x03, 0x0E, 0xC0, 0x77, 0x76, 0xC8, 0x13, 0x07, 0xB0,
  0xA4, 0x03, 0x0E, 0xC0, 0x77, 0x75, 0x0B, 0xB8, 0x17, 0x09, 0xB0, 0x65, 0x03, 0x0E, 0xC0, 0x77,
  0x74, 0x06, 0xB8, 0x1A, 0x0B, 0xB0, 0x36, 0x03, 0x0E, 0xC0, 0x77, 0x73, 0x03, 0xB8, 0x1C, 0x0E,
  0xB0, 0x17, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0x02, 0xB8, 0x1E, 0x0E, 0xB7, 0x20, 0x30, 0xEC, 0x07,
  0x77, 0x2C, 0x10, 0xEB, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0xB8, 0x1E, 0x0D, 0xB0, 0x27, 0x30,
  0x30, 0xEC, 0x07, 0x76, 0x01, 0xB8, 0x1D, 0x0C, 0xB0, 0x37, 0x40, 0x30, 0xEC, 0x07, 0x75, 0x03,
  0xB8, 0x1C, 0x09, 0xB0, 0x67, 0x50, 0x30, 0xEC, 0x07, 0x74, 0x06, 0xB8, 0x1A, 0x06, 0xB0, 0xB7,
  0x60, 0x30, 0xEC, 0x07, 0x73, 0x0A, 0xB8, 0x16, 0x03, 0xC7, 0x70, 0x30, 0xEC, 0x07, 0x72, 0xC0,
  0x32, 0x0D, 0xB0, 0x67, 0x70, 0x30, 0xEC, 0x07, 0x70, 0x6B, 0x0D, 0x30, 0x7B, 0x0E, 0x77, 0x10,
  0x30, 0xEC, 0x07, 0x60, 0xDB, 0x07, 0x30, 0x1C, 0x07, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x50, 0xCB,
  0x01, 0x40, 0x8C, 0x03, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x58, 0x1C, 0xF8, 0x60, 0xDB, 0x0E, 0x01,
  0x77, 0x10, 0x30, 0xEC, 0x07, 0x50, 0xA7, 0x04, 0xC0, 0xC0, 0x17, 0x71, 0x03, 0x0E, 0xC0, 0x77,
  0x60, 0x7C, 0x0E, 0x03, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x76, 0x0A, 0xD0, 0x77, 0x71, 0x03, 0xD0,
  0x77, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06, 0x0D, 0xE0, 0x77, 0x60, 0x7F, 0x82, 0xB6, 0x32, 0x28,
  0x21, 0x36, 0xAF, 0xB0, 0x77, 0x60, 0x40, 0xDF, 0xFE, 0x00, 0xEC, 0x07, 0x77, 0x08, 0xFF, 0xB8,
  0x3E, 0x70, 0x3E, 0xC0, 0x47, 0x78, 0x11, 0x7D, 0xFD, 0x81, 0xD7, 0x13, 0x03, 0x0E, 0xB0, 0x77,
  0x73, 0x89, 0x23, 0x69, 0xCD, 0xDE, 0xEC, 0x97, 0x27, 0x83, 0x3E, 0xFE, 0x28, 0x0C, 0x10, 0x81,
  0x15, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_hide_source() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 43, 44), Box(0, 0, 47, 47),
      ic_round_48_action_hide_source_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_highlight_alt 48x48, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_round_48_action_highlight_alt_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x4C, 0x4C, 0x4C, 0x48, 0x4D, 0xA1, 0x01, 0xEA, 0x4C, 0x4C, 0x4C, 0x4A, 0x81,
  0xE1, 0xAB, 0x4C, 0x4C, 0x4C, 0x4B, 0x0A, 0x0D, 0xB4, 0xC4, 0xC4, 0xC4, 0xB0, 0xD8, 0x0A, 0x94,
  0x0C, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xC8, 0x0A, 0x94, 0x0C,
  0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xC8, 0x0A, 0x94, 0x0C, 0x77,
  0x60, 0x40, 0xDF, 0x90, 0x51, 0xC7, 0x76, 0x0D, 0xFA, 0x05, 0x1C, 0x77, 0x6F, 0xA0, 0x72, 0xC7,
  0x76, 0xF9, 0x07, 0x77, 0x76, 0xF0, 0xA7, 0x77, 0x7F, 0x90, 0x57, 0x77, 0x6F, 0xA0, 0x57, 0x77,
  0x5C, 0x0A, 0xD8, 0x15, 0x0D, 0xB4, 0xC4, 0xC4, 0xB8, 0x17, 0x05, 0xD0, 0x40, 0xAB, 0x4C, 0x4C,
  0x4A, 0x07, 0x30, 0x5C, 0x81, 0xD1, 0xEA, 0x4C, 0x4C, 0x40, 0x05, 0x50, 0x5B, 0x83, 0xD0, 0x1A,
  0xD4, 0xC4, 0xC7, 0x58, 0x24, 0xDD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_highlight_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_highlight_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_highlight_off 48x48, 4-bit Alpha,  RLE, 372 bytes.
static const unsigned char ic_round_48_action_highlight_off_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xEC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xBD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xB7, 0x40, 0xBD, 0x07, 0x77, 0x20, 0x7D, 0x0B, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x93,
  0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x71, 0x01, 0x73, 0x01, 0x71, 0x0E,
  0xB0, 0x82, 0x0D, 0xB0, 0x67, 0x82, 0x9F, 0xE5, 0x68, 0x25, 0xEF, 0x97, 0x06, 0xB8, 0x1D, 0x03,
  0xC7, 0x01, 0xC0, 0x54, 0x05, 0xC0, 0x17, 0xC0, 0x30, 0x7B, 0x0B, 0x71, 0x0E, 0xC0, 0x52, 0x05,
  0xC0, 0xE7, 0x10, 0xBB, 0x07, 0x0A, 0xB0, 0x67, 0x10, 0x5D, 0x00, 0x5D, 0x05, 0x71, 0x06, 0xB0,
  0xA0, 0xCB, 0x03, 0x72, 0x05, 0xFB, 0x05, 0x72, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x73, 0x05, 0xF9,
  0x05, 0x73, 0x02, 0xB0, 0xEC, 0x75, 0x05, 0xE0, 0x57, 0x5F, 0x97, 0x50, 0x5E, 0x05, 0x75, 0xC0,
  0xEB, 0x02, 0x73, 0x05, 0xF9, 0x05, 0x73, 0x02, 0xB0, 0xE0, 0xCB, 0x03, 0x72, 0x05, 0xFB, 0x05,
  0x72, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x71, 0x05, 0xD0, 0x05, 0xD0, 0x57, 0x10, 0x6B, 0x0A, 0x07,
  0xB0, 0xB7, 0x10, 0xEC, 0x05, 0x20, 0x5C, 0x0E, 0x71, 0x0B, 0xB0, 0x70, 0x3C, 0x70, 0x1C, 0x05,
  0x40, 0x5C, 0x01, 0x7C, 0x81, 0x30, 0xDB, 0x06, 0x78, 0x29, 0xFE, 0x56, 0x82, 0x5E, 0xF9, 0x70,
  0x6B, 0x0D, 0x20, 0x8B, 0x0E, 0x71, 0x01, 0x73, 0x01, 0x71, 0x0E, 0xB0, 0x82, 0x01, 0xC0, 0x77,
  0x77, 0x50, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xE0,
  0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xCC, 0x05,
  0x70, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC, 0x09, 0x72, 0x0B, 0xD0, 0x77, 0x72, 0x07, 0xD0,
  0xB7, 0x40, 0xBD, 0x0E, 0x06, 0x75, 0x06, 0x0E, 0xD0, 0xB7, 0x60, 0x9F, 0x82, 0xB6, 0x32, 0x28,
  0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC,
  0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCE, 0xA8,
  0x3E, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_highlight_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_highlight_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_history 48x48, 4-bit Alpha,  RLE, 308 bytes.
static const unsigned char ic_round_48_action_history_data[] PROGMEM = {
  0x77, 0x38, 0x91, 0x15, 0x9B, 0xDE, 0xFD, 0xB9, 0x57, 0x77, 0x70, 0x40, 0xBF, 0xD0, 0xA0, 0x47,
  0x77, 0x20, 0x30, 0xBF, 0xFA, 0x0B, 0x02, 0x77, 0x60, 0x8F, 0xFE, 0x07, 0x77, 0x30, 0x10, 0xBE,
  0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE, 0x0A, 0x77, 0x20, 0xCD, 0x0A, 0x02, 0x73, 0x02, 0x0B,
  0xD0, 0xC7, 0x70, 0xBC, 0x0D, 0x03, 0x77, 0x04, 0x0E, 0xC0, 0xA7, 0x50, 0x8C, 0x0B, 0x01, 0x77,
  0x20, 0x10, 0xCC, 0x07, 0x73, 0x03, 0xC0, 0xB7, 0x76, 0x0C, 0xC0, 0x27, 0x20, 0xBB, 0x0D, 0x01,
  0x77, 0x60, 0x10, 0xEB, 0x0B, 0x71, 0x05, 0xC0, 0x37, 0x28, 0x18, 0xE8, 0x73, 0x04, 0xC0, 0x47,
  0x0B, 0xB0, 0xA7, 0x3B, 0x74, 0x0B, 0xB0, 0xA6, 0x01, 0xC0, 0x27, 0x3B, 0x74, 0x02, 0xC0, 0x15,
  0x05, 0xB0, 0xC7, 0x4B, 0x75, 0x0C, 0xB0, 0x55, 0x09, 0xB0, 0x77, 0x4B, 0x75, 0x07, 0xB0, 0x95,
  0x0B, 0xB0, 0x37, 0x4B, 0x75, 0x04, 0xB0, 0xB5, 0x0D, 0xB0, 0x27, 0x4B, 0x75, 0x02, 0xB0, 0xD5,
  0x0E, 0xB7, 0x5B, 0x76, 0xC0, 0x5F, 0xD0, 0x57, 0xB0, 0x67, 0x40, 0x1B, 0x0E, 0x05, 0xFD, 0x05,
  0x70, 0xCB, 0x0C, 0x03, 0x72, 0x02, 0xB8, 0x1D, 0x07, 0xFB, 0x07, 0x71, 0x02, 0x0D, 0xC0, 0x90,
  0x17, 0x03, 0xB0, 0xB2, 0x07, 0xF9, 0x07, 0x74, 0x07, 0x0E, 0xB0, 0xE0, 0x66, 0x07, 0xB0, 0x93,
  0x07, 0xE0, 0x77, 0x60, 0x10, 0xAC, 0x05, 0x50, 0xCB, 0x05, 0x40, 0x7C, 0x07, 0x77, 0x20, 0x30,
  0xCA, 0x05, 0x40, 0x2C, 0x01, 0x50, 0x7A, 0x08, 0x77, 0x50, 0x05, 0x50, 0xAB, 0x0B, 0x70, 0x05,
  0x77, 0x75, 0x03, 0xC0, 0x47, 0x77, 0x76, 0x01, 0x0D, 0xB0, 0xB7, 0x77, 0x77, 0x0B, 0xC0, 0x37,
  0x70, 0x30, 0x57, 0x73, 0x01, 0x0B, 0xC0, 0x87, 0x70, 0x5A, 0x0D, 0x04, 0x77, 0x03, 0x0D, 0xC0,
  0xB7, 0x71, 0x0B, 0xC0, 0x90, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x77, 0x10, 0x8E, 0x82, 0xB7,
  0x31, 0x28, 0x22, 0x47, 0xCE, 0x0B, 0x77, 0x40, 0x8F, 0xFE, 0x08, 0x77, 0x60, 0x30, 0xCF, 0xFA,
  0x0B, 0x03, 0x77, 0x72, 0x04, 0x0B, 0xFD, 0x0B, 0x05, 0x77, 0x76, 0x89, 0x21, 0x59, 0xCD, 0xEE,
  0xDB, 0x95, 0x17, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_history() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_history_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_history_toggle_off 48x48, 4-bit Alpha,  RLE, 323 bytes.
static const unsigned char ic_round_48_action_history_toggle_off_data[] PROGMEM = {
  0x77, 0x82, 0x36, 0x9C, 0x48, 0x2C, 0x96, 0x37, 0x77, 0x50, 0x70, 0xCC, 0x4C, 0x0C, 0x07, 0x77,
  0x73, 0x0C, 0xD4, 0xD0, 0xC7, 0x77, 0x30, 0x3D, 0x4D, 0x03, 0x77, 0x50, 0x70, 0xB4, 0x83, 0x9E,
  0xA6, 0x34, 0x83, 0x36, 0xAE, 0x94, 0x0B, 0x07, 0x76, 0x09, 0xA0, 0x53, 0x01, 0x75, 0x01, 0x30,
  0x5A, 0x0A, 0x74, 0x09, 0xB0, 0xD7, 0x76, 0x0D, 0xB0, 0x97, 0x20, 0x7C, 0x0D, 0x01, 0x77, 0x40,
  0x20, 0xDC, 0x07, 0x71, 0x0B, 0xB0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xB0, 0xB7, 0x28, 0x25, 0xDD,
  0x17, 0x77, 0x18, 0x21, 0xDD, 0x47, 0x50, 0x27, 0x38, 0x24, 0xDD, 0x47, 0x30, 0x17, 0x77, 0x40,
  0xDA, 0x0D, 0x77, 0x58, 0x17, 0xC3, 0x77, 0xC7, 0x78, 0x13, 0xC7, 0x20, 0xCA, 0x09, 0x01, 0x75,
  0xC7, 0x50, 0x10, 0x9A, 0x81, 0xC0, 0x3B, 0x0E, 0x76, 0xC7, 0x60, 0xEB, 0x03, 0x06, 0xB0, 0xA7,
  0x6C, 0x76, 0x0A, 0xB0, 0x60, 0x9B, 0x06, 0x76, 0xC7, 0x60, 0x6B, 0x09, 0x0C, 0xB0, 0x37, 0x6C,
  0x76, 0x03, 0xB0, 0xC7, 0x74, 0xC8, 0x0C, 0x00, 0x0E, 0xB0, 0x57, 0x77, 0x77, 0x0B, 0xC0, 0x57,
  0x77, 0x76, 0x02, 0xD0, 0x57, 0x71, 0x0C, 0xB0, 0x37, 0x70, 0x5D, 0x05, 0x72, 0x03, 0xB0, 0xC0,
  0x9B, 0x06, 0x77, 0x10, 0x5D, 0x05, 0x71, 0x06, 0xB0, 0x90, 0x6B, 0x0A, 0x77, 0x20, 0x5D, 0x05,
  0x70, 0xAB, 0x06, 0x03, 0xB0, 0xE7, 0x73, 0x05, 0xD0, 0x36, 0x0E, 0xB8, 0x13, 0x0C, 0xA0, 0x90,
  0x17, 0x73, 0x05, 0xC0, 0x85, 0x01, 0x09, 0xA0, 0xC2, 0x81, 0x7C, 0x37, 0x76, 0x05, 0xB0, 0x47,
  0x81, 0x3C, 0x77, 0x77, 0x58, 0x13, 0x84, 0x77, 0x50, 0x17, 0x77, 0x30, 0x27, 0x58, 0x24, 0xDD,
  0x17, 0x77, 0x18, 0x21, 0xDD, 0x57, 0x20, 0xBB, 0x0D, 0x01, 0x77, 0x60, 0x10, 0xCB, 0x0B, 0x71,
  0x07, 0xC0, 0xD0, 0x27, 0x74, 0x01, 0x0D, 0xC0, 0x77, 0x20, 0x9B, 0x0D, 0x77, 0x60, 0xDB, 0x0A,
  0x74, 0x09, 0xA0, 0x53, 0x01, 0x75, 0x01, 0x30, 0x4A, 0x09, 0x76, 0x07, 0x0B, 0x48, 0x39, 0xEA,
  0x63, 0x48, 0x33, 0x6A, 0xE9, 0x40, 0xB0, 0x77, 0x75, 0x03, 0xD4, 0xD0, 0x37, 0x77, 0x30, 0xCD,
  0x4D, 0x0C, 0x77, 0x73, 0x07, 0x0C, 0xC4, 0xC0, 0xC0, 0x77, 0x77, 0x58, 0x23, 0x69, 0xC4, 0x82,
  0xC9, 0x63, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_history_toggle_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_history_toggle_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_hls_off 48x48, 4-bit Alpha,  RLE, 260 bytes.
static const unsigned char ic_round_48_action_hls_off_data[] PROGMEM = {
  0x18, 0x12, 0x74, 0x77, 0x77, 0x70, 0x20, 0xEA, 0x07, 0x77, 0x77, 0x60, 0x5C, 0x07, 0x77, 0x77,
  0x50, 0x10, 0xEC, 0x07, 0x77, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x50, 0x30, 0xEC, 0x07,
  0x77, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x50, 0x30,
  0xEC, 0x07, 0x77, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x77,
  0x50, 0x30, 0xEC, 0x07, 0x77, 0x76, 0x81, 0x8E, 0x83, 0x03, 0x0E, 0xC0, 0x77, 0x50, 0x40, 0xDE,
  0x0D, 0x04, 0x4B, 0x4E, 0x07, 0x74, 0x0D, 0xF9, 0x0D, 0x4B, 0x4F, 0x07, 0x73, 0xFB, 0x4B, 0x4B,
  0x0E, 0xC0, 0x77, 0x2B, 0x48, 0x17, 0xE8, 0x4F, 0xB0, 0x30, 0xEC, 0x07, 0x71, 0xB7, 0x4F, 0xB1,
  0x03, 0x0E, 0xC0, 0x77, 0x0D, 0xF0, 0xD0, 0x44, 0xFB, 0x20, 0x30, 0xEC, 0x07, 0x60, 0x40, 0xDF,
  0x0D, 0x4B, 0x4B, 0x30, 0x3D, 0x07, 0x75, 0xB4, 0xB4, 0xB4, 0xE0, 0x75, 0x0B, 0x07, 0x4B, 0x4B,
  0x4B, 0x4F, 0x07, 0x50, 0xCF, 0x4B, 0x4B, 0x40, 0xDF, 0x07, 0x50, 0xCD, 0x0D, 0x48, 0x18, 0xE8,
  0x48, 0x18, 0xE8, 0x40, 0x40, 0xDF, 0x07, 0x50, 0xCB, 0x0D, 0x04, 0x77, 0x71, 0x03, 0x0E, 0xC0,
  0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03,
  0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77,
  0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0,
  0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03,
  0x0E, 0xC0, 0x47, 0x77, 0x75, 0x03, 0x0E, 0xB0, 0x77, 0x77, 0x76, 0x83, 0x3E, 0xFE, 0x27, 0x77,
  0x77, 0x81, 0x15, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_hls_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 41, 44), Box(0, 0, 47, 47),
      ic_round_48_action_hls_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_hls 48x48, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_48_action_hls_data[] PROGMEM = {
  0x81, 0x8E, 0x84, 0x81, 0x8E, 0x84, 0x81, 0x8E, 0x87, 0x10, 0x40, 0xDE, 0x0D, 0x04, 0xB4, 0xB4,
  0xB7, 0x10, 0xDF, 0x90, 0xDB, 0x4B, 0x4B, 0x71, 0xFE, 0x4B, 0x4B, 0x71, 0xB4, 0x81, 0x7E, 0x8F,
  0xB4, 0xB7, 0x1B, 0x7F, 0xB4, 0xB7, 0x10, 0xDF, 0x0D, 0x04, 0xFB, 0x4B, 0x71, 0x04, 0x0D, 0xF0,
  0xDB, 0x4B, 0x4B, 0x77, 0x1E, 0x4B, 0x4B, 0x71, 0x81, 0x8E, 0x74, 0xE4, 0xB4, 0xF0, 0x83, 0xFE,
  0x4B, 0x40, 0xDE, 0x0E, 0x30, 0xDF, 0x98, 0x2D, 0x8E, 0x84, 0x81, 0x8E, 0x84, 0x04, 0x0D, 0xD0,
  0x83, 0x04, 0x0D, 0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_hls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 18, 40, 29), Box(0, 0, 47, 47),
      ic_round_48_action_hls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_home 48x48, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_round_48_action_home_data[] PROGMEM = {
  0x77, 0x40, 0x03, 0x77, 0x77, 0x70, 0x9A, 0x09, 0x77, 0x77, 0x50, 0xBC, 0x0B, 0x77, 0x77, 0x20,
  0x10, 0xCE, 0x0C, 0x01, 0x77, 0x76, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x77, 0x74, 0x03, 0x0E, 0xFB,
  0x0E, 0x03, 0x77, 0x72, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x77, 0x70, 0x5F, 0xFA, 0x05, 0x77, 0x50,
  0x7F, 0xFC, 0x07, 0x77, 0x30, 0x8F, 0xFE, 0x08, 0x77, 0x10, 0x9F, 0xFF, 0x90, 0x97, 0x60, 0xBF,
  0xFF, 0xB0, 0xB7, 0x30, 0x10, 0xCF, 0xFF, 0xD0, 0xC0, 0x17, 0x02, 0x0D, 0xFF, 0xFF, 0x0D, 0x02,
  0x50, 0x30, 0xEF, 0xFF, 0xFA, 0x0E, 0x03, 0x30, 0x40, 0xEF, 0xFF, 0xFC, 0x82, 0xE4, 0x03, 0x80,
  0xC0, 0xF8, 0x13, 0x3E, 0xFF, 0xFF, 0xE0, 0xE0, 0x35, 0xFF, 0xFF, 0x73, 0xFF, 0xFF, 0x73, 0xFF,
  0xFF, 0x73, 0xFF, 0xFF, 0x73, 0xFB, 0x71, 0xFB, 0x73, 0xFB, 0x71, 0xFB, 0x73, 0xFB, 0x71, 0xFB,
  0x73, 0xFB, 0x71, 0xFB, 0x73, 0xFB, 0x71, 0xFB, 0x73, 0xFB, 0x71, 0xFB, 0x73, 0xFB, 0x71, 0xFB,
  0x73, 0xFB, 0x71, 0xFB, 0x73, 0xFB, 0x71, 0xFB, 0x73, 0xFB, 0x71, 0xFB, 0x73, 0x0D, 0xF9, 0x0D,
  0x71, 0x0D, 0xF9, 0x0D, 0x73, 0x04, 0x0D, 0xE0, 0xD0, 0x47, 0x10, 0x40, 0xDE, 0x0D, 0x04, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_home() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 42, 39), Box(0, 0, 47, 47),
      ic_round_48_action_home_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_horizontal_split 48x48, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_48_action_horizontal_split_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x48, 0x0A, 0x94, 0x00, 0x40, 0xDF, 0xFF, 0xFC, 0x81, 0xD4, 0xDF, 0xFF,
  0xFE, 0x00, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04, 0x80, 0xA9, 0x40, 0x04,
  0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0xD8, 0x0C, 0xB4, 0xF0, 0xDF, 0xFF, 0xFE,
  0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_horizontal_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_horizontal_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_hotel_class 48x48, 4-bit Alpha,  RLE, 292 bytes.
static const unsigned char ic_round_48_action_hotel_class_data[] PROGMEM = {
  0x77, 0x30, 0x50, 0x46, 0x02, 0x07, 0x77, 0x77, 0x30, 0x1A, 0x01, 0x58, 0x1A, 0xF6, 0x77, 0x77,
  0x20, 0x6A, 0x05, 0x58, 0x1E, 0xFB, 0x77, 0x77, 0x20, 0xAA, 0x0A, 0x40, 0x4B, 0x77, 0x77, 0x20,
  0xEA, 0x0E, 0x40, 0x9B, 0x05, 0x77, 0x77, 0x04, 0xC0, 0x43, 0x08, 0xB0, 0x97, 0x77, 0x70, 0x9C,
  0x08, 0x30, 0x3B, 0x0E, 0x77, 0x77, 0x0D, 0xC0, 0xD4, 0x0E, 0xB0, 0x37, 0x77, 0x50, 0x2E, 0x02,
  0x30, 0x9B, 0x08, 0x77, 0x75, 0x07, 0xE0, 0x73, 0x05, 0xB0, 0xD7, 0x77, 0x50, 0xCE, 0x0C, 0x77,
  0x77, 0x50, 0x1F, 0x90, 0x17, 0x77, 0x74, 0x06, 0xF9, 0x06, 0x77, 0x77, 0x40, 0xAF, 0x90, 0xA7,
  0x75, 0x09, 0xFF, 0xFF, 0xE0, 0x96, 0x0A, 0xFF, 0xFF, 0xE0, 0x97, 0x07, 0xFF, 0xFF, 0xC0, 0x77,
  0x20, 0x30, 0xDF, 0xFF, 0xF0, 0xD0, 0x37, 0x50, 0xAF, 0xFF, 0xD0, 0x97, 0x71, 0x05, 0x0E, 0xFF,
  0xF9, 0x0E, 0x05, 0x77, 0x30, 0x20, 0xCF, 0xFE, 0x0B, 0x01, 0x50, 0x40, 0xEB, 0x0D, 0x01, 0x71,
  0x07, 0xFF, 0xC0, 0x76, 0x09, 0xD0, 0xE0, 0x17, 0x20, 0x30, 0xDF, 0xF0, 0xD0, 0x35, 0x02, 0x0C,
  0xD0, 0xB0, 0x17, 0x40, 0xDF, 0xF0, 0xD5, 0x06, 0xE0, 0x77, 0x50, 0x2F, 0xFA, 0x02, 0x30, 0x7D,
  0x0D, 0x03, 0x76, 0x07, 0xFF, 0xA0, 0x73, 0x05, 0xC0, 0x97, 0x71, 0x0B, 0xFF, 0xA0, 0xC4, 0xC0,
  0x27, 0x70, 0x1F, 0xFC, 0x01, 0x30, 0xBB, 0x07, 0x77, 0x06, 0xF9, 0x00, 0xDF, 0x90, 0x63, 0x06,
  0xB0, 0xC7, 0x70, 0xAF, 0x82, 0xB1, 0x1B, 0xF0, 0xB3, 0x01, 0xC0, 0x17, 0x6F, 0x08, 0x40, 0x8F,
  0x40, 0xCB, 0x06, 0x75, 0x05, 0xD0, 0xE0, 0x46, 0x04, 0x0E, 0xD0, 0x53, 0x07, 0xB0, 0xB7, 0x50,
  0x9C, 0x0C, 0x01, 0x71, 0x01, 0x0C, 0xC0, 0x93, 0x02, 0xC7, 0x50, 0xEB, 0x08, 0x75, 0x08, 0xB0,
  0xE4, 0x0D, 0xB0, 0x57, 0x30, 0x3A, 0x0E, 0x05, 0x77, 0x05, 0x0E, 0xA0, 0x43, 0x01, 0x0C, 0xA0,
  0x97, 0x38, 0x25, 0xFC, 0x27, 0x72, 0x82, 0x2C, 0xF5, 0x58, 0x18, 0xFB, 0x74, 0x04, 0x77, 0x60,
  0x37, 0x02, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_hotel_class() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 45, 42), Box(0, 0, 47, 47),
      ic_round_48_action_hotel_class_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_hourglass_disabled 48x48, 4-bit Alpha,  RLE, 317 bytes.
static const unsigned char ic_round_48_action_hourglass_disabled_data[] PROGMEM = {
  0x74, 0x81, 0x2A, 0xEF, 0xFA, 0x81, 0xDA, 0x17, 0x18, 0x22, 0xCE, 0x66, 0x02, 0x0E, 0xFF, 0xE0,
  0xE0, 0x17, 0x0A, 0xB0, 0x75, 0x08, 0xFF, 0xF9, 0x0A, 0x70, 0xAC, 0x07, 0x50, 0xCF, 0xFF, 0x0D,
  0x70, 0x20, 0xEC, 0x07, 0x58, 0x2C, 0xFB, 0x17, 0x50, 0x10, 0xBC, 0x71, 0x03, 0x0E, 0xC0, 0x75,
  0x0C, 0x01, 0x77, 0x01, 0xC7, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x7C, 0x73, 0x03, 0x0E, 0xC0, 0x77,
  0x76, 0xC7, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x5C, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x74, 0xC7, 0x60,
  0x30, 0xEC, 0x07, 0x77, 0x3B, 0x0E, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0x07, 0xB0, 0xB7, 0x71,
  0x03, 0x0E, 0xC0, 0x77, 0x60, 0x7C, 0x05, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x74, 0x07, 0xC0, 0x77,
  0x74, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x07, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x70, 0x7C, 0x07,
  0x77, 0x71, 0x03, 0x0E, 0xC0, 0x75, 0x06, 0xC0, 0x77, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x40, 0x10,
  0xCA, 0x07, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x74, 0x81, 0x1C, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07,
  0x77, 0x77, 0x70, 0x3D, 0x07, 0x77, 0x77, 0x60, 0x8E, 0x07, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x77,
  0x77, 0x72, 0x07, 0xC0, 0x90, 0xEC, 0x07, 0x77, 0x77, 0x07, 0xC8, 0x27, 0x03, 0xEC, 0x07, 0x77,
  0x75, 0x07, 0xC0, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x30, 0x7C, 0x07, 0x50, 0x30, 0xEC, 0x07,
  0x77, 0x71, 0x05, 0xC0, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x0B, 0xB0, 0x77, 0x20, 0x30, 0xEC,
  0x07, 0x77, 0x60, 0xEB, 0x74, 0x03, 0x0E, 0xC0, 0x77, 0x75, 0xC7, 0x50, 0x30, 0xEC, 0x07, 0x77,
  0x4C, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x73, 0xC7, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x2C, 0x77, 0x10,
  0x3D, 0x07, 0x77, 0x1C, 0x01, 0x77, 0x01, 0xE0, 0x77, 0x7C, 0x0B, 0x01, 0x75, 0x01, 0x0B, 0xF0,
  0x77, 0x60, 0xDF, 0xFF, 0xE0, 0x77, 0x50, 0xAF, 0xFF, 0x90, 0xC0, 0xEC, 0x07, 0x74, 0x01, 0x0E,
  0xFF, 0xE8, 0x2E, 0x23, 0xEC, 0x06, 0x74, 0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xEA, 0x22, 0x03, 0x0E,
  0xB0, 0xD8, 0x0C, 0x00, 0x03, 0x0E, 0xA0, 0xC8, 0x0C, 0x10, 0x82, 0x2A, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_hourglass_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 42, 45), Box(0, 0, 47, 47),
      ic_round_48_action_hourglass_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_hourglass_empty 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_48_action_hourglass_empty_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xA8, 0x4D, 0xA1, 0x01, 0xEF, 0xFE, 0x81, 0xE1, 0xAF, 0xFF, 0x90, 0xA0,
  0xDF, 0xFF, 0x90, 0xDC, 0x0B, 0x01, 0x75, 0x01, 0x0B, 0xF9, 0x01, 0x77, 0x01, 0xF9, 0x77, 0x2F,
  0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xC0, 0xEB, 0x77, 0x2B, 0x0E, 0x0B, 0xB0, 0x77, 0x70,
  0x7B, 0x0B, 0x04, 0xC0, 0x77, 0x50, 0x7C, 0x81, 0x50, 0x7C, 0x07, 0x73, 0x07, 0xC0, 0x73, 0x07,
  0xC0, 0x77, 0x10, 0x7C, 0x07, 0x50, 0x7C, 0x07, 0x60, 0x7C, 0x07, 0x70, 0x7C, 0x07, 0x40, 0x7C,
  0x07, 0x72, 0x07, 0xC0, 0x72, 0x07, 0xC0, 0x77, 0x40, 0x7C, 0x00, 0x7C, 0x07, 0x76, 0x07, 0xF9,
  0x07, 0x77, 0x07, 0xF9, 0x07, 0x76, 0x07, 0xC0, 0x07, 0xC0, 0x77, 0x40, 0x7C, 0x07, 0x20, 0x7C,
  0x07, 0x72, 0x07, 0xC0, 0x74, 0x07, 0xC0, 0x77, 0x07, 0xC0, 0x76, 0x07, 0xC0, 0x75, 0x07, 0xC0,
  0x77, 0x10, 0x7C, 0x07, 0x30, 0x7C, 0x07, 0x73, 0x07, 0xC8, 0x17, 0x05, 0xC0, 0x77, 0x50, 0x7C,
  0x04, 0x0B, 0xB0, 0x77, 0x70, 0x7B, 0x0B, 0x0E, 0xB7, 0x72, 0xB0, 0xEC, 0x77, 0x2F, 0x97, 0x72,
  0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x01, 0x77, 0x01, 0xF9, 0x0B, 0x01, 0x75, 0x01, 0x0B, 0xC0,
  0xDF, 0xFF, 0x90, 0xD0, 0xAF, 0xFF, 0x98, 0x1A, 0x1E, 0xFF, 0xE8, 0x4E, 0x10, 0x1A, 0xDF, 0xFA,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_hourglass_empty() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 4, 35, 43), Box(0, 0, 47, 47),
      ic_round_48_action_hourglass_empty_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_hourglass_full 48x48, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_round_48_action_hourglass_full_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xA8, 0x4D, 0xA1, 0x01, 0xEF, 0xFE, 0x81, 0xE1, 0xAF, 0xFF, 0x90, 0xA0,
  0xDF, 0xFF, 0x90, 0xD8, 0x0A, 0x94, 0xF0, 0xEF, 0xFF, 0x90, 0xE0, 0xBF, 0xFF, 0x90, 0xB0, 0x4F,
  0xFF, 0x98, 0x15, 0x07, 0xFF, 0xE0, 0x73, 0x07, 0xFF, 0xC0, 0x75, 0x07, 0xFF, 0xA0, 0x77, 0x07,
  0xFF, 0x07, 0x72, 0x07, 0xFD, 0x07, 0x74, 0x07, 0xFB, 0x07, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x07,
  0xF9, 0x07, 0x76, 0x07, 0xFB, 0x07, 0x74, 0x07, 0xFD, 0x07, 0x72, 0x07, 0xFF, 0x07, 0x70, 0x7F,
  0xFA, 0x07, 0x50, 0x7F, 0xFC, 0x07, 0x30, 0x7F, 0xFE, 0x81, 0x70, 0x5F, 0xFF, 0x90, 0x40, 0xBF,
  0xFF, 0x90, 0xB0, 0xEF, 0xFF, 0x90, 0xE8, 0x0A, 0x94, 0xF0, 0xDF, 0xFF, 0x90, 0xD0, 0xAF, 0xFF,
  0x98, 0x1A, 0x1E, 0xFF, 0xE8, 0x4E, 0x10, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_hourglass_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 4, 35, 43), Box(0, 0, 47, 47),
      ic_round_48_action_hourglass_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_html 48x48, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_round_48_action_html_data[] PROGMEM = {
  0x81, 0x8E, 0x84, 0x81, 0x8E, 0x82, 0x08, 0xF9, 0x08, 0x20, 0x40, 0xDF, 0xA0, 0xD0, 0x43, 0x81,
  0x8E, 0x85, 0xB4, 0xB2, 0x0E, 0xF9, 0x0E, 0x20, 0xDF, 0xC0, 0xD3, 0xB5, 0xB4, 0xB2, 0x08, 0xF9,
  0x08, 0x2F, 0xE3, 0xB5, 0xB4, 0xB5, 0x07, 0xA0, 0x75, 0xB2, 0xB2, 0xB3, 0xB5, 0xFB, 0x50, 0x7A,
  0x07, 0x5B, 0x2B, 0x2B, 0x3B, 0x5F, 0xB5, 0x07, 0xA0, 0x75, 0xB2, 0xB2, 0xB3, 0xB5, 0xFB, 0x50,
  0x7A, 0x07, 0x5B, 0x2B, 0x2B, 0x3B, 0x5B, 0x4B, 0x50, 0x7A, 0x07, 0x5B, 0x2B, 0x2B, 0x3B, 0x5B,
  0x4B, 0x50, 0x7A, 0x07, 0x5B, 0x2B, 0x2B, 0x3B, 0x5B, 0x4B, 0x50, 0x7A, 0x07, 0x5B, 0x28, 0x18,
  0xE8, 0x2B, 0x3F, 0x08, 0xB4, 0xB5, 0x07, 0xA0, 0x75, 0xB7, 0xB3, 0x0D, 0xE8, 0x2E, 0x8E, 0x84,
  0x81, 0x8E, 0x85, 0x82, 0x2D, 0xD2, 0x58, 0x18, 0xE8, 0x78, 0x18, 0xE8, 0x30, 0x40, 0xDD, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_html() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 18, 47, 29), Box(0, 0, 47, 47),
      ic_round_48_action_html_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_http 48x48, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_48_action_http_data[] PROGMEM = {
  0x81, 0x8E, 0x84, 0x81, 0x8E, 0x82, 0x08, 0xF0, 0x82, 0x08, 0xF0, 0x82, 0x04, 0x0D, 0xD0, 0xD0,
  0x81, 0xB4, 0xB2, 0x0E, 0xF0, 0xE2, 0x0E, 0xF0, 0xE2, 0x0D, 0xF9, 0x08, 0xB4, 0xB2, 0x08, 0xF0,
  0x82, 0x08, 0xF0, 0x82, 0xFA, 0x0D, 0xB4, 0xB5, 0xB7, 0x1B, 0x5B, 0x4F, 0xE5, 0xB7, 0x1B, 0x5B,
  0x4F, 0xE5, 0xB7, 0x1B, 0x5F, 0xA0, 0xDF, 0xB5, 0xB7, 0x1B, 0x5F, 0xA0, 0x8B, 0x4B, 0x5B, 0x71,
  0xB5, 0xF0, 0xD0, 0x81, 0xB4, 0xB5, 0xB7, 0x1B, 0x5B, 0x7B, 0x4B, 0x5B, 0x71, 0xB5, 0xB7, 0xB4,
  0xB5, 0xB7, 0x1B, 0x5B, 0x78, 0x18, 0xE8, 0x48, 0x18, 0xE8, 0x58, 0x18, 0xE8, 0x71, 0x81, 0x8E,
  0x85, 0x81, 0x8E, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_http() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 18, 45, 29), Box(0, 0, 47, 47),
      ic_round_48_action_http_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_https 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_round_48_action_https_data[] PROGMEM = {
  0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x50, 0x8F,
  0xD0, 0x87, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x10, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x04, 0x77,
  0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xD7, 0x60, 0x5C, 0x02, 0x71, 0x02, 0xC0, 0x57, 0x50,
  0x9B, 0x08, 0x73, 0x08, 0xB0, 0x97, 0x50, 0xDB, 0x03, 0x73, 0x03, 0xB0, 0xD7, 0x50, 0xEB, 0x75,
  0xB0, 0xE7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x81, 0x1A,
  0xDF, 0xFF, 0xB8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xF8, 0x1E, 0x1A, 0xFF, 0xFF, 0xA0, 0xA0, 0xDF,
  0xFF, 0xFA, 0x0D, 0x80, 0xB9, 0x1F, 0x84, 0xD5, 0x11, 0x5D, 0xFF, 0xFC, 0x0D, 0x01, 0x40, 0x10,
  0xDF, 0xFF, 0xB0, 0x56, 0x05, 0xFF, 0xFB, 0x01, 0x60, 0x1F, 0xFF, 0xB0, 0x16, 0x01, 0xFF, 0xFB,
  0x05, 0x60, 0x5F, 0xFF, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xFC, 0x84, 0xD5, 0x11, 0x5D, 0x80,
  0xB9, 0x1F, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF, 0xF8, 0x4E,
  0x10, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_https() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_https_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_important_devices 48x48, 4-bit Alpha,  RLE, 274 bytes.
static const unsigned char ic_round_48_action_important_devices_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x50, 0x10, 0xE8, 0x0C, 0x4F, 0x0E, 0x01, 0x40,
  0xA8, 0x0C, 0x6F, 0x0A, 0x40, 0xD8, 0x0C, 0x6F, 0x0D, 0x4C, 0x0B, 0x01, 0x77, 0x77, 0x40, 0x10,
  0xBC, 0x4C, 0x01, 0x77, 0x77, 0x60, 0x1C, 0x4C, 0x80, 0xC0, 0x0C, 0x4C, 0x80, 0xC0, 0x0C, 0x4C,
  0x77, 0x30, 0x02, 0x77, 0x3C, 0x4C, 0x77, 0x30, 0x07, 0x77, 0x3C, 0x4C, 0x77, 0x30, 0x0C, 0x77,
  0x3C, 0x4C, 0x77, 0x20, 0x2A, 0x02, 0x77, 0x2C, 0x4C, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0xDA,
  0x0D, 0x4C, 0x77, 0x20, 0xCA, 0x0C, 0x77, 0x28, 0x24, 0xDD, 0x44, 0xC7, 0x30, 0x50, 0xEF, 0xD0,
  0xE0, 0x57, 0x74, 0xC7, 0x40, 0x10, 0xBF, 0xB0, 0xB0, 0x17, 0x75, 0xC7, 0x60, 0x7F, 0x90, 0x77,
  0x77, 0xC7, 0x70, 0x4E, 0x04, 0x77, 0x71, 0xC7, 0x70, 0x5E, 0x05, 0x71, 0x04, 0x0D, 0xFB, 0x0D,
  0x04, 0xC7, 0x70, 0xAA, 0x00, 0xEA, 0x0A, 0x71, 0x0D, 0xFD, 0x0D, 0xC7, 0x7A, 0x82, 0xC2, 0x2C,
  0xA7, 0x1F, 0xFC, 0x76, 0x81, 0x5F, 0x84, 0x81, 0x8F, 0x57, 0xFF, 0xC7, 0x60, 0x90, 0x46, 0x04,
  0x09, 0x7A, 0x73, 0xE7, 0x77, 0x72, 0xA7, 0x3E, 0x77, 0x77, 0x2A, 0x73, 0xE7, 0x77, 0x72, 0xA7,
  0x3E, 0x01, 0x77, 0x77, 0x1A, 0x73, 0xE0, 0xB0, 0x17, 0x77, 0x7A, 0x73, 0xA0, 0xDF, 0xFF, 0xE0,
  0xD0, 0x44, 0xA7, 0x3A, 0x0A, 0xFF, 0xFF, 0x0D, 0x4A, 0x73, 0xA0, 0x10, 0xEF, 0xFF, 0xE0, 0xD4,
  0xA7, 0x3A, 0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x0D, 0x04, 0x4A, 0x73, 0xA7, 0x74, 0xF9, 0x71, 0xA7,
  0x3A, 0x77, 0x4F, 0x97, 0x1A, 0x73, 0xA7, 0x74, 0xF9, 0x71, 0xA7, 0x3A, 0x77, 0x4F, 0x97, 0x1A,
  0x73, 0xA7, 0x70, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0xFF, 0x77, 0x0D, 0xFF, 0x0D, 0x4F, 0xF7, 0x70,
  0xDF, 0xF0, 0xD4, 0x0D, 0xFD, 0x0D, 0x77, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xB0,
  0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_important_devices() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 47, 43), Box(0, 0, 47, 47),
      ic_round_48_action_important_devices_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_info_outline 48x48, 4-bit Alpha,  RLE, 328 bytes.
static const unsigned char ic_round_48_action_info_outline_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x73, 0xC7, 0x30, 0x3C, 0x09,
  0x30, 0x1C, 0x07, 0x74, 0xC7, 0x40, 0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x75, 0xC7, 0x50, 0xEB, 0x08,
  0x20, 0xDB, 0x06, 0x75, 0xC7, 0x50, 0x6B, 0x81, 0xD0, 0x3C, 0x77, 0x77, 0x2C, 0x03, 0x07, 0xB0,
  0xB7, 0x77, 0x72, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x77, 0x77, 0x20, 0x6B, 0x0A, 0x0C, 0xB0, 0x37,
  0x77, 0x72, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x76, 0x82, 0x4D, 0xD4, 0x76, 0x02, 0xB0, 0xEC, 0x77,
  0x0D, 0xA0, 0xD7, 0x7F, 0x97, 0x7C, 0x77, 0xC0, 0xEB, 0x02, 0x76, 0xC7, 0x60, 0x2B, 0x0E, 0x0C,
  0xB0, 0x37, 0x6C, 0x76, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x76, 0xC7, 0x60, 0x6B, 0x0A, 0x07, 0xB0,
  0xB7, 0x6C, 0x76, 0x0B, 0xB0, 0x70, 0x3C, 0x76, 0xC7, 0x6C, 0x81, 0x30, 0xDB, 0x06, 0x75, 0xC7,
  0x50, 0x6B, 0x0D, 0x20, 0x8B, 0x0E, 0x75, 0xC7, 0x50, 0xEB, 0x08, 0x20, 0x1C, 0x07, 0x74, 0x0D,
  0xA0, 0xD7, 0x40, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x73, 0x82, 0x4D, 0xD4, 0x73, 0x03, 0xC0, 0x94,
  0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77,
  0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC, 0x09, 0x72, 0x0A, 0xD0,
  0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0E, 0x06, 0x75, 0x06, 0x0E, 0xD0, 0xA7, 0x60, 0x9F,
  0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77,
  0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48,
  0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_info_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_info_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_info 48x48, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_round_48_action_info_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0x94, 0xFF, 0x90, 0x93, 0x01, 0xFF, 0xA4, 0xFF, 0xA0, 0x12, 0x08, 0xFF, 0xA4, 0xFF,
  0xA0, 0x82, 0x0D, 0xFF, 0xA4, 0xFF, 0xA8, 0x1D, 0x03, 0x80, 0xC2, 0xF0, 0x30, 0x78, 0x0C, 0x2F,
  0x07, 0x0A, 0x80, 0xC2, 0xF0, 0xA0, 0xC8, 0x0C, 0x2F, 0x0C, 0x0E, 0xFF, 0xB8, 0x2B, 0x11, 0xBF,
  0xFB, 0x0E, 0xFF, 0xC0, 0x12, 0x01, 0x80, 0xC0, 0xF4, 0xFF, 0xC0, 0xEF, 0xFB, 0x4F, 0xFB, 0x0E,
  0x0C, 0xFF, 0xB4, 0xFF, 0xB0, 0xC0, 0xAF, 0xFB, 0x4F, 0xFB, 0x0A, 0x07, 0xFF, 0xB4, 0xFF, 0xB0,
  0x70, 0x3F, 0xFB, 0x4F, 0xFB, 0x81, 0x30, 0xDF, 0xFA, 0x4F, 0xFA, 0x0D, 0x20, 0x8F, 0xFA, 0x4F,
  0xFA, 0x08, 0x20, 0x1F, 0xFA, 0x01, 0x20, 0x1F, 0xFA, 0x01, 0x30, 0x9F, 0xF9, 0x82, 0xB1, 0x1B,
  0xFF, 0x90, 0x94, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x15, 0x05, 0xFF, 0xFF, 0xC0, 0x57, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F,
  0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90,
  0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC,
  0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_info() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_info_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_input 48x48, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_round_48_action_input_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0x80, 0xC0, 0xF8, 0x4D, 0x91, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0x98, 0x0C,
  0x6F, 0x09, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x0A, 0x01, 0x77, 0x77, 0x40, 0x10, 0xAF, 0x90, 0x17,
  0x77, 0x76, 0x01, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C,
  0x00, 0xC0, 0xDA, 0x0D, 0x80, 0xC0, 0x0C, 0x82, 0x4D, 0xD4, 0x77, 0x20, 0x05, 0x77, 0x4C, 0x77,
  0x6A, 0x07, 0x77, 0x3C, 0x77, 0x6B, 0x07, 0x77, 0x2C, 0x77, 0x6C, 0x07, 0x77, 0x1C, 0x77, 0x6D,
  0x07, 0x77, 0xC0, 0x40, 0xDF, 0xFF, 0xB0, 0x77, 0x6C, 0x0D, 0xFF, 0xFD, 0x05, 0x75, 0xC0, 0xDF,
  0xFF, 0xD0, 0x57, 0x5C, 0x04, 0x0D, 0xFF, 0xFB, 0x07, 0x76, 0xC7, 0x76, 0xD0, 0x77, 0x7C, 0x77,
  0x6C, 0x07, 0x77, 0x1C, 0x77, 0x6B, 0x07, 0x77, 0x2C, 0x77, 0x6A, 0x07, 0x77, 0x3C, 0x82, 0x4D,
  0xD4, 0x77, 0x20, 0x05, 0x77, 0x4C, 0x0D, 0xA0, 0xD8, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98,
  0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x1F, 0x90,
  0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x19,
  0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x19, 0xD8, 0x0C, 0x0F, 0x81, 0xD9, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_input() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_input_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_install_desktop 48x48, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_round_48_action_install_desktop_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xA7, 0x18, 0x24, 0xDD, 0x47, 0x10, 0x10, 0xEF, 0xFC, 0x71, 0x0D, 0xA0,
  0xD7, 0x10, 0xAF, 0xFD, 0x71, 0xC7, 0x10, 0xDF, 0xFD, 0x71, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C,
  0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C,
  0x77, 0x73, 0xC7, 0x1C, 0x77, 0x38, 0x26, 0xEC, 0x33, 0xC3, 0x82, 0x3C, 0xE6, 0x1C, 0x77, 0x20,
  0x1B, 0x0E, 0x03, 0x2C, 0x20, 0x30, 0xEB, 0x01, 0xC7, 0x72, 0x01, 0xC0, 0xE0, 0x31, 0xC1, 0x03,
  0x0E, 0xC0, 0x1C, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0xC0, 0x30, 0xEC, 0x07, 0x1C, 0x77, 0x40, 0x7C,
  0x0E, 0xC0, 0xEC, 0x07, 0x2C, 0x77, 0x50, 0x7F, 0xD0, 0x73, 0xC7, 0x76, 0x07, 0xFB, 0x07, 0x4C,
  0x77, 0x70, 0x7F, 0x90, 0x75, 0xC7, 0x77, 0x10, 0x7E, 0x07, 0x6C, 0x77, 0x72, 0x07, 0xC0, 0x77,
  0xC7, 0x77, 0x30, 0x7A, 0x07, 0x71, 0xC7, 0x77, 0x40, 0x01, 0x72, 0xC7, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C,
  0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x76, 0xFF, 0xA7, 0x77, 0x3F, 0xFA, 0x77, 0x73, 0x0D, 0xFF,
  0x0D, 0x77, 0x73, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_install_desktop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_install_desktop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_install_mobile 48x48, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_round_48_action_install_mobile_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x77, 0x40, 0x10, 0xEF, 0xFA, 0x77, 0x40, 0xAF, 0xFB, 0x77, 0x40, 0xDF,
  0xFB, 0x77, 0x4F, 0xFC, 0x68, 0x24, 0xDD, 0x47, 0x1F, 0xFC, 0x60, 0xDA, 0x0D, 0x71, 0xFF, 0xC6,
  0xC7, 0x1F, 0xFC, 0x6C, 0x71, 0xFF, 0xC6, 0xC7, 0x1F, 0xFC, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C,
  0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x68, 0x26, 0xEC, 0x33, 0xC3,
  0x82, 0x3C, 0xE6, 0x1C, 0x75, 0x01, 0xB0, 0xE0, 0x32, 0xC2, 0x03, 0x0E, 0xB0, 0x1C, 0x75, 0x01,
  0xC0, 0xE0, 0x31, 0xC1, 0x03, 0x0E, 0xC0, 0x1C, 0x76, 0x07, 0xC0, 0xE0, 0x3C, 0x03, 0x0E, 0xC0,
  0x71, 0xC7, 0x70, 0x7C, 0x0E, 0xC0, 0xEC, 0x07, 0x2C, 0x77, 0x10, 0x7F, 0xD0, 0x73, 0xC7, 0x72,
  0x07, 0xFB, 0x07, 0x4C, 0x77, 0x30, 0x7F, 0x90, 0x75, 0xC7, 0x74, 0x07, 0xE0, 0x76, 0xC7, 0x75,
  0x07, 0xC0, 0x77, 0xC7, 0x76, 0x07, 0xA0, 0x77, 0x1C, 0x77, 0x70, 0x01, 0x72, 0xC7, 0x77, 0x74,
  0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71,
  0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71,
  0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x71, 0x0A, 0xFF,
  0xFD, 0x0A, 0x71, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA,
  0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_install_mobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_install_mobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_integration_instructions 48x48, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_round_48_action_integration_instructions_data[] PROGMEM = {
  0x77, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x05, 0xC0, 0x09, 0xC0, 0x57, 0x68, 0x11, 0xAE, 0xFD, 0x09, 0x20, 0x9F, 0xD8,
  0x4D, 0xA1, 0x02, 0xEF, 0xF0, 0x92, 0x09, 0xFF, 0x81, 0xE1, 0xAF, 0xFA, 0x00, 0x9F, 0xFA, 0x0A,
  0x0E, 0xFF, 0xFF, 0xE0, 0xD8, 0x0C, 0x84, 0xF0, 0xD0, 0xBF, 0x90, 0xB0, 0xCF, 0xFF, 0xA0, 0x82,
  0x04, 0xE0, 0x42, 0x07, 0xFF, 0xF0, 0x84, 0x0D, 0xC0, 0xD4, 0x07, 0xFF, 0xD0, 0x84, 0x01, 0x0E,
  0xD0, 0x14, 0x07, 0xFF, 0xB0, 0x85, 0x0B, 0xE0, 0xC5, 0x07, 0xFF, 0x90, 0x85, 0x0C, 0xF9, 0x0C,
  0x50, 0x8F, 0xE0, 0xE5, 0x0C, 0xFB, 0x0C, 0x50, 0xEF, 0xD0, 0xE5, 0x0C, 0xFB, 0x0C, 0x50, 0xEF,
  0xE0, 0x85, 0x0C, 0xF9, 0x0C, 0x50, 0x8F, 0xF9, 0x07, 0x50, 0xCE, 0x0C, 0x50, 0x8F, 0xFB, 0x07,
  0x40, 0x1E, 0x01, 0x40, 0x8F, 0xFD, 0x07, 0x40, 0xDC, 0x0D, 0x40, 0x8F, 0xFF, 0x07, 0x20, 0x4E,
  0x04, 0x20, 0x8F, 0xFF, 0xA0, 0xC0, 0xBF, 0x90, 0xB0, 0xC8, 0x0C, 0x84, 0xF0, 0xDF, 0xFF, 0xFE,
  0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x3E, 0x10, 0x2A, 0xFF, 0xFF, 0x98,
  0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_integration_instructions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_integration_instructions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_invert_colors 48x48, 4-bit Alpha,  RLE, 234 bytes.
static const unsigned char ic_round_48_action_invert_colors_data[] PROGMEM = {
  0x77, 0x10, 0x01, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x76, 0x08, 0xC0, 0x87, 0x77, 0x40, 0x8E,
  0x08, 0x77, 0x72, 0x08, 0xF9, 0x08, 0x77, 0x70, 0x9C, 0x0E, 0xD0, 0x97, 0x75, 0x09, 0xC0, 0xE0,
  0x2E, 0x09, 0x77, 0x30, 0x9C, 0x0E, 0x02, 0x1F, 0x09, 0x77, 0x10, 0x9C, 0x0E, 0x02, 0x2F, 0x90,
  0x97, 0x60, 0x9C, 0x0D, 0x02, 0x3F, 0xA0, 0x97, 0x40, 0xAC, 0x0D, 0x02, 0x4F, 0xB0, 0xA7, 0x20,
  0x9C, 0x0D, 0x02, 0x5F, 0xC0, 0x97, 0x07, 0xC0, 0xD0, 0x26, 0xFD, 0x07, 0x50, 0x4C, 0x0D, 0x01,
  0x7F, 0xE0, 0x44, 0x0C, 0xB0, 0xE0, 0x27, 0x1F, 0xE0, 0xC3, 0x05, 0xC0, 0x37, 0x2F, 0xF0, 0x52,
  0x0D, 0xB0, 0x97, 0x3F, 0xF8, 0x1D, 0x02, 0xB0, 0xE0, 0x17, 0x3F, 0xF9, 0x02, 0x07, 0xB0, 0xA7,
  0x4F, 0xF9, 0x07, 0x0B, 0xB0, 0x57, 0x4F, 0xF9, 0x0B, 0x0C, 0xB0, 0x27, 0x4F, 0xF9, 0x0C, 0x0E,
  0xB0, 0x17, 0x4F, 0xF9, 0x0E, 0xC7, 0x5F, 0xFA, 0x0D, 0xB0, 0x17, 0x4F, 0xF9, 0x0D, 0x0B, 0xB0,
  0x37, 0x4F, 0xF9, 0x0B, 0x09, 0xB0, 0x87, 0x4F, 0xF9, 0x09, 0x05, 0xB0, 0xD7, 0x4F, 0xF9, 0x05,
  0x1C, 0x04, 0x73, 0xFF, 0x92, 0x0A, 0xB0, 0xD7, 0x3F, 0xF0, 0xA2, 0x02, 0xC0, 0x97, 0x2F, 0xF0,
  0x23, 0x08, 0xC0, 0x77, 0x1F, 0xE0, 0x85, 0x0D, 0xC0, 0x97, 0xFD, 0x0D, 0x60, 0x20, 0xEC, 0x0D,
  0x05, 0x5F, 0xC0, 0xE0, 0x27, 0x03, 0x0E, 0xD8, 0x2D, 0x84, 0x21, 0xFB, 0x0E, 0x03, 0x72, 0x02,
  0x0C, 0xFF, 0xC0, 0xC0, 0x27, 0x50, 0x8F, 0xFA, 0x08, 0x77, 0x18, 0x11, 0x9E, 0xFB, 0x81, 0xE9,
  0x17, 0x75, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_invert_colors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_round_48_action_invert_colors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_javascript 48x48, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_48_action_javascript_data[] PROGMEM = {
  0x68, 0x18, 0xE8, 0x30, 0x40, 0xDE, 0x0D, 0x04, 0x6B, 0x30, 0xDF, 0x90, 0xD6, 0xB3, 0xFB, 0x6B,
  0x3B, 0x48, 0x17, 0xE8, 0x6B, 0x3B, 0x76, 0xB3, 0x0D, 0xF0, 0xD0, 0x46, 0xB3, 0x04, 0x0D, 0xF8,
  0x2D, 0x8E, 0x83, 0xB7, 0x3E, 0x3B, 0x38, 0x18, 0xE7, 0x4B, 0x0D, 0xF0, 0xD3, 0xFB, 0x08, 0xF0,
  0x83, 0x0D, 0xF9, 0x82, 0xD0, 0x8D, 0xB0, 0xD0, 0x84, 0x04, 0x0D, 0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_javascript() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 18, 33, 29), Box(0, 0, 47, 47),
      ic_round_48_action_javascript_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_join_full 48x48, 4-bit Alpha,  RLE, 298 bytes.
static const unsigned char ic_round_48_action_join_full_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x26, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x72,
  0x05, 0x0D, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xD0, 0x57, 0x50, 0x10, 0xBF, 0xB0, 0x87, 0x10, 0x8F,
  0xB0, 0xB0, 0x17, 0x20, 0x30, 0xEF, 0xB0, 0xA3, 0x82, 0x4C, 0xC4, 0x30, 0xAF, 0xB0, 0xE0, 0x37,
  0x03, 0xFC, 0x0D, 0x30, 0x4C, 0x04, 0x30, 0xDF, 0xC0, 0x35, 0x01, 0x0E, 0xFC, 0x05, 0x20, 0x20,
  0xEC, 0x0E, 0x02, 0x20, 0x5F, 0xC0, 0xE0, 0x14, 0x0B, 0xFC, 0x0C, 0x30, 0xCE, 0x0C, 0x30, 0xCF,
  0xC0, 0xB3, 0x05, 0xFD, 0x05, 0x20, 0x5F, 0x90, 0x52, 0x05, 0xFD, 0x05, 0x20, 0xDF, 0xC0, 0xE3,
  0x0D, 0xF9, 0x0C, 0x30, 0xEF, 0xC8, 0x1D, 0x03, 0xFD, 0x0A, 0x20, 0x3F, 0xB0, 0x32, 0x0A, 0xFD,
  0x03, 0x07, 0xFD, 0x06, 0x20, 0x8F, 0xB0, 0x82, 0x06, 0xFD, 0x07, 0x0B, 0xFD, 0x03, 0x20, 0xBF,
  0xB0, 0xB2, 0x03, 0xFD, 0x0B, 0x0D, 0xFD, 0x01, 0x20, 0xDF, 0xB0, 0xD2, 0x01, 0xFD, 0x0D, 0x0E,
  0xFD, 0x3F, 0xD3, 0xFD, 0x00, 0xEF, 0xD3, 0xFD, 0x3F, 0xD0, 0xE0, 0xDF, 0xD0, 0x12, 0x0D, 0xFB,
  0x0D, 0x20, 0x1F, 0xD0, 0xD0, 0xBF, 0xD0, 0x32, 0x0B, 0xFB, 0x0B, 0x20, 0x3F, 0xD0, 0xB0, 0x7F,
  0xD0, 0x62, 0x08, 0xFB, 0x08, 0x20, 0x6F, 0xD0, 0x70, 0x3F, 0xD0, 0xA2, 0x03, 0xFB, 0x03, 0x20,
  0xAF, 0xD8, 0x13, 0x0D, 0xFC, 0x0E, 0x30, 0xCF, 0x90, 0xD3, 0x0E, 0xFC, 0x0D, 0x20, 0x5F, 0xD0,
  0x52, 0x05, 0xF9, 0x05, 0x20, 0x5F, 0xD0, 0x53, 0x0B, 0xFC, 0x0C, 0x30, 0xCE, 0x0C, 0x30, 0xCF,
  0xC0, 0xB4, 0x01, 0x0E, 0xFC, 0x05, 0x20, 0x20, 0xEC, 0x0E, 0x02, 0x20, 0x5F, 0xC0, 0xE0, 0x15,
  0x03, 0xFC, 0x0D, 0x30, 0x4C, 0x04, 0x30, 0xDF, 0xC0, 0x37, 0x03, 0x0E, 0xFB, 0x0A, 0x38, 0x24,
  0xCC, 0x43, 0x0A, 0xFB, 0x0E, 0x03, 0x72, 0x01, 0x0B, 0xFB, 0x08, 0x71, 0x08, 0xFB, 0x0B, 0x01,
  0x75, 0x05, 0x0D, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xD0, 0x57, 0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED,
  0xB7, 0x26, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_join_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_round_48_action_join_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_join_inner 48x48, 4-bit Alpha,  RLE, 312 bytes.
static const unsigned char ic_round_48_action_join_inner_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x26, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x72,
  0x05, 0x0D, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xD0, 0x57, 0x50, 0x10, 0xBF, 0xB0, 0x87, 0x10, 0x8F,
  0xB0, 0xB0, 0x17, 0x20, 0x30, 0xEF, 0xB0, 0xA3, 0x82, 0x4C, 0xC4, 0x30, 0xAF, 0xB0, 0xE0, 0x37,
  0x03, 0xE8, 0x4A, 0x52, 0x01, 0x23, 0x04, 0xC0, 0x43, 0x84, 0x21, 0x02, 0x5A, 0xE0, 0x35, 0x01,
  0x0E, 0xC0, 0xA0, 0x27, 0x10, 0x20, 0xEC, 0x0E, 0x02, 0x71, 0x02, 0x0A, 0xC0, 0xE0, 0x14, 0x0B,
  0xC0, 0x77, 0x30, 0xCE, 0x0C, 0x73, 0x07, 0xC0, 0xB3, 0x05, 0xC0, 0x77, 0x30, 0x5F, 0x90, 0x57,
  0x30, 0x7C, 0x05, 0x20, 0xDB, 0x0A, 0x74, 0x0D, 0xF9, 0x0C, 0x74, 0x0A, 0xB8, 0x1D, 0x03, 0xC0,
  0x27, 0x30, 0x3F, 0xB0, 0x37, 0x30, 0x2C, 0x03, 0x07, 0xB0, 0xA7, 0x40, 0x8F, 0xB0, 0x87, 0x40,
  0xAB, 0x07, 0x0B, 0xB0, 0x57, 0x40, 0xBF, 0xB0, 0xB7, 0x40, 0x5B, 0x0B, 0x0D, 0xB0, 0x27, 0x40,
  0xDF, 0xB0, 0xD7, 0x40, 0x2B, 0x0D, 0x0E, 0xB7, 0x5F, 0xD7, 0x5B, 0x00, 0xEB, 0x75, 0xFD, 0x75,
  0xB0, 0xE0, 0xDB, 0x02, 0x74, 0x0D, 0xFB, 0x0D, 0x74, 0x02, 0xB0, 0xD0, 0xBB, 0x05, 0x74, 0x0B,
  0xFB, 0x0B, 0x74, 0x05, 0xB0, 0xB0, 0x7B, 0x0A, 0x74, 0x08, 0xFB, 0x08, 0x74, 0x0A, 0xB0, 0x70,
  0x3C, 0x02, 0x73, 0x03, 0xFB, 0x03, 0x73, 0x02, 0xC8, 0x13, 0x0D, 0xB0, 0xA7, 0x40, 0xCF, 0x90,
  0xD7, 0x40, 0xAB, 0x0D, 0x20, 0x5C, 0x07, 0x73, 0x05, 0xF9, 0x05, 0x73, 0x07, 0xC0, 0x53, 0x0B,
  0xC0, 0x77, 0x30, 0xCE, 0x0C, 0x73, 0x07, 0xC0, 0xB4, 0x01, 0x0E, 0xC0, 0xA0, 0x27, 0x10, 0x20,
  0xEC, 0x0E, 0x02, 0x71, 0x02, 0x0A, 0xC0, 0xE0, 0x15, 0x03, 0xE8, 0x4A, 0x52, 0x01, 0x23, 0x04,
  0xC0, 0x43, 0x84, 0x21, 0x02, 0x5A, 0xE0, 0x37, 0x03, 0x0E, 0xFB, 0x0A, 0x38, 0x24, 0xCC, 0x43,
  0x0A, 0xFB, 0x0E, 0x03, 0x72, 0x01, 0x0B, 0xFB, 0x08, 0x71, 0x08, 0xFB, 0x0B, 0x01, 0x75, 0x05,
  0x0D, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xD0, 0x57, 0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x26,
  0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_join_inner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_round_48_action_join_inner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_join_left 48x48, 4-bit Alpha,  RLE, 305 bytes.
static const unsigned char ic_round_48_action_join_left_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x26, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x72,
  0x05, 0x0D, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xD0, 0x57, 0x50, 0x10, 0xBF, 0xB0, 0x87, 0x10, 0x8F,
  0xB0, 0xB0, 0x17, 0x20, 0x30, 0xEF, 0xB0, 0xA3, 0x82, 0x4C, 0xC4, 0x30, 0xAF, 0xB0, 0xE0, 0x37,
  0x03, 0xFC, 0x0D, 0x30, 0x4C, 0x04, 0x38, 0x42, 0x10, 0x25, 0xAE, 0x03, 0x50, 0x10, 0xEF, 0xC0,
  0x52, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x10, 0x20, 0xAC, 0x0E, 0x01, 0x40, 0xBF, 0xC0, 0xC3, 0x0C,
  0xE0, 0xC7, 0x30, 0x7C, 0x0B, 0x30, 0x5F, 0xD0, 0x52, 0x05, 0xF9, 0x05, 0x73, 0x07, 0xC0, 0x52,
  0x0D, 0xFC, 0x0E, 0x30, 0xDF, 0x90, 0xC7, 0x40, 0xAB, 0x81, 0xD0, 0x3F, 0xD0, 0xA2, 0x03, 0xFB,
  0x03, 0x73, 0x02, 0xC0, 0x30, 0x7F, 0xD0, 0x62, 0x08, 0xFB, 0x08, 0x74, 0x0A, 0xB0, 0x70, 0xBF,
  0xD0, 0x32, 0x0B, 0xFB, 0x0B, 0x74, 0x05, 0xB0, 0xB0, 0xDF, 0xD0, 0x12, 0x0D, 0xFB, 0x0D, 0x74,
  0x02, 0xB0, 0xD0, 0xEF, 0xD3, 0xFD, 0x75, 0xB0, 0x0E, 0xFD, 0x3F, 0xD7, 0x5B, 0x0E, 0x0D, 0xFD,
  0x01, 0x20, 0xDF, 0xB0, 0xD7, 0x40, 0x2B, 0x0D, 0x0B, 0xFD, 0x03, 0x20, 0xBF, 0xB0, 0xB7, 0x40,
  0x5B, 0x0B, 0x07, 0xFD, 0x06, 0x20, 0x8F, 0xB0, 0x87, 0x40, 0xAB, 0x07, 0x03, 0xFD, 0x0A, 0x20,
  0x3F, 0xB0, 0x37, 0x30, 0x2C, 0x81, 0x30, 0xDF, 0xC0, 0xE3, 0x0C, 0xF9, 0x0D, 0x74, 0x0A, 0xB0,
  0xD2, 0x05, 0xFD, 0x05, 0x20, 0x5F, 0x90, 0x57, 0x30, 0x7C, 0x05, 0x30, 0xBF, 0xC0, 0xC3, 0x0C,
  0xE0, 0xC7, 0x30, 0x7C, 0x0B, 0x40, 0x10, 0xEF, 0xC0, 0x52, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x10,
  0x20, 0xAC, 0x0E, 0x01, 0x50, 0x3F, 0xC0, 0xD3, 0x04, 0xC0, 0x43, 0x84, 0x21, 0x02, 0x5A, 0xE0,
  0x37, 0x03, 0x0E, 0xFB, 0x0A, 0x38, 0x24, 0xCC, 0x43, 0x0A, 0xFB, 0x0E, 0x03, 0x72, 0x01, 0x0B,
  0xFB, 0x08, 0x71, 0x08, 0xFB, 0x0B, 0x01, 0x75, 0x05, 0x0D, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xD0,
  0x57, 0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x26, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x37,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_join_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_round_48_action_join_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_join_right 48x48, 4-bit Alpha,  RLE, 305 bytes.
static const unsigned char ic_round_48_action_join_right_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x26, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x72,
  0x05, 0x0D, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xD0, 0x57, 0x50, 0x10, 0xBF, 0xB0, 0x87, 0x10, 0x8F,
  0xB0, 0xB0, 0x17, 0x20, 0x30, 0xEF, 0xB0, 0xA3, 0x82, 0x4C, 0xC4, 0x30, 0xAF, 0xB0, 0xE0, 0x37,
  0x03, 0xE8, 0x4A, 0x52, 0x01, 0x23, 0x04, 0xC0, 0x43, 0x0D, 0xFC, 0x03, 0x50, 0x10, 0xEC, 0x0A,
  0x02, 0x71, 0x02, 0x0E, 0xC0, 0xE0, 0x22, 0x05, 0xFC, 0x0E, 0x01, 0x40, 0xBC, 0x07, 0x73, 0x0C,
  0xE0, 0xC3, 0x0C, 0xFC, 0x0B, 0x30, 0x5C, 0x07, 0x73, 0x05, 0xF9, 0x05, 0x20, 0x5F, 0xD0, 0x52,
  0x0D, 0xB0, 0xA7, 0x40, 0xDF, 0x90, 0xC3, 0x0E, 0xFC, 0x81, 0xD0, 0x3C, 0x02, 0x73, 0x03, 0xFB,
  0x03, 0x20, 0xAF, 0xD0, 0x30, 0x7B, 0x0A, 0x74, 0x08, 0xFB, 0x08, 0x20, 0x6F, 0xD0, 0x70, 0xBB,
  0x05, 0x74, 0x0B, 0xFB, 0x0B, 0x20, 0x3F, 0xD0, 0xB0, 0xDB, 0x02, 0x74, 0x0D, 0xFB, 0x0D, 0x20,
  0x1F, 0xD0, 0xD0, 0xEB, 0x75, 0xFD, 0x3F, 0xD0, 0x0E, 0xB7, 0x5F, 0xD3, 0xFD, 0x0E, 0x0D, 0xB0,
  0x27, 0x40, 0xDF, 0xB0, 0xD2, 0x01, 0xFD, 0x0D, 0x0B, 0xB0, 0x57, 0x40, 0xBF, 0xB0, 0xB2, 0x03,
  0xFD, 0x0B, 0x07, 0xB0, 0xA7, 0x40, 0x8F, 0xB0, 0x82, 0x06, 0xFD, 0x07, 0x03, 0xC0, 0x27, 0x30,
  0x3F, 0xB0, 0x32, 0x0A, 0xFD, 0x81, 0x30, 0xDB, 0x0A, 0x74, 0x0C, 0xF9, 0x0D, 0x30, 0xEF, 0xC0,
  0xD2, 0x05, 0xC0, 0x77, 0x30, 0x5F, 0x90, 0x52, 0x05, 0xFD, 0x05, 0x30, 0xBC, 0x07, 0x73, 0x0C,
  0xE0, 0xC3, 0x0C, 0xFC, 0x0B, 0x40, 0x10, 0xEC, 0x0A, 0x02, 0x71, 0x02, 0x0E, 0xC0, 0xE0, 0x22,
  0x05, 0xFC, 0x0E, 0x01, 0x50, 0x3E, 0x84, 0xA5, 0x20, 0x12, 0x30, 0x4C, 0x04, 0x30, 0xDF, 0xC0,
  0x37, 0x03, 0x0E, 0xFB, 0x0A, 0x38, 0x24, 0xCC, 0x43, 0x0A, 0xFB, 0x0E, 0x03, 0x72, 0x01, 0x0B,
  0xFB, 0x08, 0x71, 0x08, 0xFB, 0x0B, 0x01, 0x75, 0x05, 0x0D, 0xFA, 0x08, 0x60, 0x8F, 0xA0, 0xD0,
  0x57, 0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x26, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x37,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_join_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_round_48_action_join_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_label_important_outline 48x48, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_round_48_action_label_important_outline_data[] PROGMEM = {
  0x10, 0x80, 0xEF, 0xFE, 0x81, 0xEA, 0x27, 0x20, 0x3F, 0xFF, 0xB0, 0xE0, 0x27, 0x10, 0x3F, 0xFF,
  0xC0, 0xC7, 0x20, 0xBF, 0xFF, 0xC0, 0x87, 0x10, 0x20, 0xEB, 0x05, 0x77, 0x20, 0xAC, 0x04, 0x71,
  0x07, 0xB0, 0xE0, 0x17, 0x71, 0x01, 0x0D, 0xB0, 0xD0, 0x17, 0x10, 0xCB, 0x0B, 0x77, 0x20, 0x3C,
  0x0A, 0x71, 0x03, 0xC0, 0x77, 0x72, 0x08, 0xC0, 0x67, 0x10, 0x8C, 0x02, 0x77, 0x20, 0xCB, 0x0E,
  0x02, 0x71, 0x0D, 0xB0, 0xC7, 0x72, 0x02, 0xC0, 0xC7, 0x10, 0x3C, 0x08, 0x77, 0x20, 0x7C, 0x08,
  0x71, 0x09, 0xC0, 0x37, 0x72, 0x0B, 0xC0, 0x37, 0x01, 0x0D, 0xB0, 0xD0, 0x17, 0x71, 0x01, 0x0E,
  0xB0, 0xD7, 0x10, 0x5C, 0x0A, 0x77, 0x20, 0x5C, 0x07, 0x70, 0x5C, 0x0A, 0x77, 0x20, 0x5C, 0x07,
  0x60, 0x10, 0xDB, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xEB, 0x0D, 0x70, 0x9C, 0x03, 0x77, 0x20, 0xBC,
  0x03, 0x60, 0x3C, 0x08, 0x77, 0x20, 0x7C, 0x08, 0x70, 0xDB, 0x0C, 0x77, 0x20, 0x2C, 0x0C, 0x70,
  0x8C, 0x02, 0x77, 0x20, 0xCB, 0x0E, 0x02, 0x60, 0x3C, 0x07, 0x77, 0x20, 0x8C, 0x06, 0x70, 0xCB,
  0x0B, 0x77, 0x20, 0x3C, 0x0A, 0x70, 0x7B, 0x0E, 0x01, 0x77, 0x10, 0x10, 0xDB, 0x0D, 0x01, 0x60,
  0x20, 0xEB, 0x05, 0x77, 0x20, 0xAC, 0x04, 0x70, 0xBF, 0xFF, 0xC0, 0x87, 0x03, 0xFF, 0xFC, 0x0C,
  0x71, 0x03, 0xFF, 0xFB, 0x0E, 0x02, 0x72, 0x08, 0x0E, 0xFF, 0xE8, 0x1E, 0xA2, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_label_important_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_label_important_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_label_important 48x48, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_round_48_action_label_important_data[] PROGMEM = {
  0x05, 0x0D, 0xFF, 0xC8, 0x1E, 0xA2, 0x72, 0x0E, 0xFF, 0xF0, 0xE0, 0x27, 0x10, 0xEF, 0xFF, 0x90,
  0xC7, 0x10, 0x7F, 0xFF, 0xA0, 0x87, 0x10, 0xCF, 0xFF, 0xA0, 0x37, 0x02, 0x0E, 0xFF, 0xF9, 0x0D,
  0x01, 0x70, 0x5F, 0xFF, 0xA0, 0xA7, 0x10, 0xAF, 0xFF, 0xA0, 0x57, 0x10, 0xDF, 0xFF, 0x90, 0xE0,
  0x27, 0x03, 0xFF, 0xFA, 0x0C, 0x71, 0x07, 0xFF, 0xFA, 0x07, 0x71, 0x0B, 0xFF, 0xFA, 0x03, 0x70,
  0x20, 0xEF, 0xFF, 0x90, 0xD7, 0x10, 0x5F, 0xFF, 0xA0, 0x67, 0x05, 0xFF, 0xFA, 0x06, 0x60, 0x20,
  0xEF, 0xFF, 0x90, 0xD7, 0x0B, 0xFF, 0xFA, 0x03, 0x60, 0x7F, 0xFF, 0xA0, 0x76, 0x03, 0xFF, 0xFA,
  0x0C, 0x70, 0xDF, 0xFF, 0x90, 0xE0, 0x26, 0x0A, 0xFF, 0xFA, 0x05, 0x60, 0x5F, 0xFF, 0xA0, 0xA6,
  0x02, 0x0E, 0xFF, 0xF9, 0x0D, 0x01, 0x60, 0xCF, 0xFF, 0xA0, 0x36, 0x07, 0xFF, 0xFA, 0x08, 0x70,
  0xEF, 0xFF, 0x90, 0xC7, 0x10, 0xEF, 0xFF, 0x0E, 0x02, 0x71, 0x05, 0x0D, 0xFF, 0xC8, 0x1E, 0xA2,
  0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_label_important() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_label_important_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_label_off 48x48, 4-bit Alpha,  RLE, 264 bytes.
static const unsigned char ic_round_48_action_label_off_data[] PROGMEM = {
  0x82, 0x5D, 0xC3, 0x77, 0x77, 0x7B, 0x0E, 0x03, 0x77, 0x77, 0x6C, 0x0E, 0x03, 0x77, 0x77, 0x50,
  0x7C, 0x0E, 0x03, 0x77, 0x77, 0x50, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xE8, 0x1E, 0xA2, 0x73,
  0x02, 0x0E, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xFF, 0x0E, 0x02, 0x72, 0x0A, 0xE0, 0xE0, 0x34, 0x03,
  0x0E, 0xFF, 0x0C, 0x72, 0x0E, 0xF0, 0xE0, 0x34, 0x03, 0x0E, 0xFF, 0x08, 0x71, 0xFA, 0x0E, 0x03,
  0x40, 0x30, 0xEF, 0xF0, 0x47, 0xFB, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xE0, 0xD0, 0x16, 0xFC, 0x0E,
  0x03, 0x40, 0x30, 0xEF, 0xE0, 0xA6, 0xFD, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xE0, 0x65, 0xFE, 0x0E,
  0x03, 0x40, 0x30, 0xEF, 0xD0, 0xE0, 0x24, 0xFF, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xD0, 0xC4, 0xFF,
  0x90, 0xE0, 0x34, 0x03, 0x0E, 0xFD, 0x08, 0x3F, 0xFA, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xD0, 0x32,
  0xFF, 0xB0, 0xE0, 0x34, 0x03, 0x0E, 0xFC, 0x0D, 0x2F, 0xFC, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xC0,
  0x71, 0xFF, 0xD0, 0xE0, 0x34, 0x04, 0x0E, 0xFB, 0x07, 0x1F, 0xFE, 0x0E, 0x03, 0x40, 0x40, 0xEF,
  0x90, 0xD2, 0xFF, 0xF0, 0xE0, 0x34, 0x04, 0x0E, 0xF0, 0x32, 0xFF, 0xF9, 0x0E, 0x03, 0x40, 0x40,
  0xED, 0x08, 0x3F, 0xFF, 0xA0, 0xE0, 0x34, 0x04, 0x0E, 0xB0, 0xC4, 0xFF, 0xFB, 0x0E, 0x03, 0x48,
  0x34, 0xEF, 0xE2, 0x4F, 0xFF, 0xC0, 0xE0, 0x34, 0x81, 0x4E, 0x65, 0xFF, 0xFD, 0x0E, 0x03, 0x40,
  0x26, 0xFF, 0xFE, 0x0E, 0x03, 0x73, 0xFF, 0xFF, 0x0E, 0x03, 0x72, 0x0D, 0xFF, 0xFF, 0x0E, 0x03,
  0x71, 0x0A, 0xFF, 0xFF, 0x90, 0xE0, 0x37, 0x01, 0x0E, 0xFF, 0xFF, 0x90, 0xE0, 0x37, 0x81, 0x1A,
  0xDF, 0xFF, 0xF0, 0xE0, 0x37, 0x77, 0x75, 0x07, 0xC0, 0xC7, 0x77, 0x76, 0x07, 0xB0, 0xE7, 0x77,
  0x77, 0x07, 0xA0, 0x68, 0x0C, 0x00, 0x00, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_label_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_label_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_label_outline 48x48, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_round_48_action_label_outline_data[] PROGMEM = {
  0x18, 0x11, 0x9C, 0x80, 0xA2, 0xD0, 0xC0, 0x87, 0x30, 0x10, 0xEF, 0xFF, 0xD0, 0xC0, 0x17, 0x10,
  0xAF, 0xFF, 0xF0, 0xB7, 0x10, 0xEF, 0xFF, 0xF9, 0x06, 0x7C, 0x0B, 0x03, 0x77, 0x60, 0xBC, 0x02,
  0x6C, 0x02, 0x77, 0x70, 0x10, 0xEB, 0x0C, 0x6C, 0x77, 0x72, 0x05, 0xC0, 0x85, 0xC7, 0x77, 0x30,
  0x9C, 0x04, 0x4C, 0x77, 0x74, 0x0D, 0xB0, 0xE0, 0x13, 0xC7, 0x77, 0x40, 0x3C, 0x0A, 0x3C, 0x77,
  0x75, 0x07, 0xC0, 0x62, 0xC7, 0x77, 0x60, 0xBB, 0x0E, 0x02, 0x1C, 0x77, 0x76, 0x01, 0x0E, 0xB0,
  0xC1, 0xC7, 0x77, 0x70, 0x5C, 0x04, 0xC7, 0x77, 0x70, 0x4C, 0x05, 0xC7, 0x77, 0x60, 0x10, 0xEB,
  0x0D, 0x1C, 0x77, 0x76, 0x0A, 0xC0, 0x31, 0xC7, 0x77, 0x50, 0x6C, 0x07, 0x2C, 0x77, 0x74, 0x02,
  0x0E, 0xB0, 0xC3, 0xC7, 0x77, 0x40, 0xCB, 0x0E, 0x01, 0x3C, 0x77, 0x73, 0x08, 0xC0, 0x54, 0xC7,
  0x77, 0x20, 0x3C, 0x0A, 0x5C, 0x01, 0x77, 0x70, 0x10, 0xDB, 0x0D, 0x01, 0x5C, 0x0A, 0x01, 0x77,
  0x60, 0xAC, 0x03, 0x60, 0xEF, 0xFF, 0xF9, 0x08, 0x70, 0xBF, 0xFF, 0xF0, 0xC7, 0x10, 0x20, 0xEF,
  0xFF, 0xD0, 0xE0, 0x27, 0x28, 0x12, 0xBE, 0xFF, 0xF9, 0x81, 0xEA, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_label_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 43, 37), Box(0, 0, 47, 47),
      ic_round_48_action_label_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_label 48x48, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_round_48_action_label_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0xFF, 0xF9, 0x81, 0xEA, 0x27, 0x20, 0x10, 0xEF, 0xFF, 0xD0, 0xE0, 0x27, 0x10,
  0xAF, 0xFF, 0xF0, 0xC7, 0x10, 0xDF, 0xFF, 0xF9, 0x08, 0x7F, 0xFF, 0xFB, 0x04, 0x6F, 0xFF, 0xFB,
  0x0D, 0x01, 0x5F, 0xFF, 0xFC, 0x0A, 0x5F, 0xFF, 0xFD, 0x06, 0x4F, 0xFF, 0xFD, 0x0E, 0x02, 0x3F,
  0xFF, 0xFE, 0x0C, 0x3F, 0xFF, 0xFF, 0x08, 0x28, 0x0C, 0x0F, 0x03, 0x18, 0x0C, 0x0F, 0x0D, 0x18,
  0x0C, 0x1F, 0x07, 0x80, 0xC1, 0xF0, 0x78, 0x0C, 0x0F, 0x0D, 0x18, 0x0C, 0x0F, 0x03, 0x1F, 0xFF,
  0xFF, 0x08, 0x2F, 0xFF, 0xFE, 0x0C, 0x3F, 0xFF, 0xFD, 0x0E, 0x02, 0x3F, 0xFF, 0xFD, 0x06, 0x4F,
  0xFF, 0xFC, 0x0A, 0x5F, 0xFF, 0xFB, 0x0D, 0x01, 0x5F, 0xFF, 0xFB, 0x04, 0x60, 0xDF, 0xFF, 0xF9,
  0x08, 0x70, 0xAF, 0xFF, 0xF0, 0xC7, 0x10, 0x10, 0xEF, 0xFF, 0xD0, 0xE0, 0x27, 0x28, 0x11, 0x9D,
  0xFF, 0xF9, 0x81, 0xEA, 0x27, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 43, 37), Box(0, 0, 47, 47),
      ic_round_48_action_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_language 48x48, 4-bit Alpha,  RLE, 386 bytes.
static const unsigned char ic_round_48_action_language_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFC, 0x00, 0xBF, 0xC0, 0x97, 0x60, 0xBD, 0x81, 0xD7, 0x8B, 0x82, 0xE2, 0x2E, 0xB8, 0x18,
  0x7D, 0xD0, 0xA7, 0x40, 0xBD, 0x08, 0x20, 0xDB, 0x08, 0x20, 0x8B, 0x0D, 0x20, 0x8D, 0x0A, 0x72,
  0x09, 0xC0, 0xD0, 0x32, 0x05, 0xB0, 0xE4, 0x0E, 0xB0, 0x52, 0x03, 0x0D, 0xC0, 0x97, 0x05, 0xC0,
  0xD0, 0x13, 0x0C, 0xB0, 0x74, 0x07, 0xB0, 0xC3, 0x01, 0x0D, 0xC0, 0x55, 0x01, 0x0E, 0xB0, 0xD0,
  0x13, 0x02, 0xC0, 0x14, 0x01, 0xC0, 0x23, 0x01, 0x0D, 0xB0, 0xE0, 0x14, 0x09, 0xC0, 0x34, 0x07,
  0xB0, 0xA6, 0x0A, 0xB0, 0x74, 0x03, 0xC0, 0x93, 0x01, 0xC0, 0x75, 0x0C, 0xB0, 0x56, 0x05, 0xB0,
  0xC5, 0x07, 0xC0, 0x12, 0x08, 0x80, 0xC0, 0xF0, 0x82, 0x0D, 0x80, 0xC0, 0xF8, 0x1D, 0x03, 0x80,
  0xC2, 0xF0, 0x30, 0x78, 0x0C, 0x2F, 0x07, 0x0A, 0xB0, 0x66, 0x0B, 0xB0, 0x47, 0x10, 0x4B, 0x0B,
  0x60, 0x6B, 0x0A, 0x0C, 0xB0, 0x36, 0x0C, 0xB0, 0x37, 0x10, 0x3B, 0x0C, 0x60, 0x3B, 0x0C, 0x0E,
  0xB0, 0x16, 0x0D, 0xB0, 0x17, 0x10, 0x1B, 0x0D, 0x60, 0x1B, 0x0E, 0xC7, 0x0E, 0xB7, 0x3B, 0x0E,
  0x7F, 0x97, 0x0E, 0xB7, 0x3B, 0x0E, 0x7C, 0x0E, 0xB0, 0x16, 0x0D, 0xB0, 0x17, 0x10, 0x1B, 0x0D,
  0x60, 0x1B, 0x0E, 0x0C, 0xB0, 0x36, 0x0C, 0xB0, 0x27, 0x10, 0x3B, 0x0C, 0x60, 0x3B, 0x0C, 0x0A,
  0xB0, 0x66, 0x0B, 0xB0, 0x47, 0x10, 0x4B, 0x0B, 0x60, 0x6B, 0x0A, 0x07, 0x80, 0xC2, 0xF0, 0x70,
  0x38, 0x0C, 0x2F, 0x81, 0x30, 0xD8, 0x0C, 0x0F, 0x0D, 0x20, 0x88, 0x0C, 0x0F, 0x08, 0x20, 0x1C,
  0x07, 0x50, 0xCB, 0x05, 0x60, 0x5B, 0x0C, 0x50, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x40, 0x7B, 0x0A,
  0x60, 0xAB, 0x07, 0x40, 0x3C, 0x09, 0x40, 0x10, 0xEB, 0x0D, 0x01, 0x30, 0x2C, 0x01, 0x40, 0x1C,
  0x02, 0x30, 0x10, 0xDB, 0x0E, 0x01, 0x50, 0x5C, 0x0D, 0x01, 0x30, 0xCB, 0x07, 0x40, 0x7B, 0x0C,
  0x30, 0x10, 0xDC, 0x05, 0x70, 0x9C, 0x0D, 0x03, 0x20, 0x5B, 0x0E, 0x40, 0xEB, 0x05, 0x20, 0x30,
  0xDC, 0x09, 0x72, 0x0B, 0xD0, 0x82, 0x0D, 0xB0, 0x82, 0x08, 0xB0, 0xD2, 0x08, 0xD0, 0xA7, 0x40,
  0xBD, 0x81, 0xD7, 0x8B, 0x82, 0xE2, 0x2E, 0xB8, 0x18, 0x7D, 0xD0, 0xA7, 0x60, 0x9F, 0xC0, 0x0B,
  0xFC, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01,
  0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCE, 0xA8, 0x3D, 0xCA,
  0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_language() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_language_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_launch 48x48, 4-bit Alpha,  RLE, 202 bytes.
static const unsigned char ic_round_48_action_launch_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xD0, 0x10, 0xEF, 0xF9, 0x0D, 0x40, 0xDF,
  0xE0, 0xAF, 0xFA, 0x0D, 0x40, 0xDF, 0xE0, 0xDF, 0xF9, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xFA, 0x0B,
  0x01, 0x77, 0x71, 0x05, 0xFC, 0x01, 0x77, 0x71, 0x05, 0xFD, 0x77, 0x71, 0x05, 0xFE, 0x77, 0x70,
  0x5D, 0x05, 0xF9, 0x77, 0x60, 0x5D, 0x05, 0x1F, 0x97, 0x75, 0x05, 0xD0, 0x52, 0xF9, 0x77, 0x40,
  0x5D, 0x05, 0x3F, 0x97, 0x73, 0x05, 0xD0, 0x54, 0xF9, 0x77, 0x20, 0x5D, 0x05, 0x50, 0xDA, 0x0D,
  0xC7, 0x71, 0x05, 0xD0, 0x56, 0x82, 0x4D, 0xD4, 0xC7, 0x70, 0x5D, 0x05, 0x74, 0xC7, 0x60, 0x5D,
  0x05, 0x75, 0xC7, 0x50, 0x5D, 0x05, 0x76, 0xC7, 0x40, 0x5D, 0x05, 0x77, 0xC7, 0x30, 0x5D, 0x05,
  0x74, 0x82, 0x4D, 0xD4, 0xC7, 0x20, 0x5D, 0x05, 0x75, 0x0D, 0xA0, 0xDC, 0x71, 0x05, 0xD0, 0x57,
  0x6F, 0x97, 0x05, 0xD0, 0x57, 0x7F, 0x96, 0x03, 0xD0, 0x57, 0x71, 0xF9, 0x60, 0x9C, 0x05, 0x77,
  0x2F, 0x96, 0x06, 0xB0, 0x57, 0x73, 0xF9, 0x78, 0x16, 0x93, 0x77, 0x4F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x90, 0xB0, 0x17,
  0x77, 0x30, 0x10, 0xBC, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF,
  0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_launch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_launch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_leaderboard 48x48, 4-bit Alpha,  RLE, 225 bytes.
static const unsigned char ic_round_48_action_leaderboard_data[] PROGMEM = {
  0x77, 0x10, 0xAF, 0x90, 0xA7, 0x77, 0x71, 0x05, 0xFB, 0x05, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x77,
  0x77, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x77, 0x77,
  0x07, 0xFB, 0x07, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x07,
  0xFB, 0x07, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x77, 0x04, 0x0D, 0xF0,
  0xD0, 0x43, 0x07, 0xFB, 0x07, 0x77, 0x0D, 0xFA, 0x0D, 0x30, 0x7F, 0xB0, 0x77, 0x7F, 0xC3, 0x07,
  0xFB, 0x07, 0x77, 0xFC, 0x30, 0x7F, 0xB0, 0x77, 0x7F, 0xC3, 0x07, 0xFB, 0x07, 0x30, 0x40, 0xDF,
  0x0D, 0x04, 0xFC, 0x30, 0x7F, 0xB0, 0x73, 0x0D, 0xFA, 0x0D, 0xFC, 0x30, 0x7F, 0xB0, 0x73, 0xFF,
  0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0,
  0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30,
  0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF,
  0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0,
  0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30,
  0x7F, 0xB0, 0x73, 0xFF, 0xF9, 0x30, 0x7F, 0xB0, 0x73, 0xFC, 0x0D, 0xFA, 0x0D, 0x30, 0x5F, 0xB0,
  0x53, 0x0D, 0xFA, 0x81, 0xD4, 0xDF, 0x0D, 0x04, 0x40, 0xAF, 0x90, 0xA4, 0x04, 0x0D, 0xF0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_leaderboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_leaderboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lightbulb_circle 48x48, 4-bit Alpha,  RLE, 282 bytes.
static const unsigned char ic_round_48_action_lightbulb_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFB, 0x81, 0xA5, 0x22, 0x81,
  0x25, 0xAF, 0xB0, 0xA7, 0x20, 0x9F, 0xA0, 0xA0, 0x27, 0x10, 0x20, 0xAF, 0xA0, 0x97, 0x05, 0xFA,
  0x07, 0x75, 0x07, 0xFA, 0x05, 0x50, 0x10, 0xEF, 0x90, 0x77, 0x70, 0x7F, 0x90, 0xE0, 0x14, 0x09,
  0xF9, 0x0A, 0x77, 0x20, 0xAF, 0x90, 0x93, 0x01, 0xFA, 0x02, 0x77, 0x20, 0x2F, 0xA0, 0x12, 0x08,
  0xF9, 0x0A, 0x77, 0x40, 0xAF, 0x90, 0x82, 0x0D, 0xF9, 0x05, 0x77, 0x40, 0x5F, 0x98, 0x1D, 0x03,
  0xFA, 0x02, 0x77, 0x40, 0x2F, 0xA0, 0x30, 0x7F, 0xA7, 0x76, 0xFA, 0x07, 0x0A, 0xFA, 0x77, 0x6F,
  0xA0, 0xA0, 0xCF, 0xA0, 0x27, 0x74, 0x02, 0xFA, 0x0C, 0x0E, 0xFA, 0x05, 0x77, 0x40, 0x5F, 0xA0,
  0xEF, 0xB0, 0xB7, 0x74, 0x0B, 0xFF, 0xF0, 0x27, 0x72, 0x02, 0xFC, 0x0E, 0xFB, 0x0B, 0x77, 0x20,
  0xBF, 0xB0, 0xE0, 0xCF, 0xC0, 0x77, 0x70, 0x7F, 0xC0, 0xC0, 0xAF, 0xD0, 0x87, 0x50, 0x8F, 0xD0,
  0xA0, 0x78, 0x0C, 0x2F, 0x07, 0x03, 0x80, 0xC2, 0xF8, 0x13, 0x0D, 0xFD, 0x07, 0x73, 0x07, 0xFD,
  0x0D, 0x20, 0x8F, 0xD7, 0x5F, 0xD0, 0x82, 0x01, 0xFD, 0x07, 0x73, 0x07, 0xFD, 0x01, 0x30, 0x9F,
  0xFF, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50, 0x5F, 0xE0, 0x14, 0x01, 0xFE,
  0x05, 0x70, 0x9F, 0xD0, 0x74, 0x07, 0xFD, 0x09, 0x72, 0x0A, 0xFD, 0x82, 0x71, 0x17, 0xFD, 0x0A,
  0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E,
  0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17,
  0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lightbulb_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_lightbulb_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lightbulb_outline 48x48, 4-bit Alpha,  RLE, 214 bytes.
static const unsigned char ic_round_48_action_lightbulb_outline_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x72, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x75, 0x01,
  0x0B, 0xFF, 0x0B, 0x01, 0x72, 0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x03, 0xE8, 0x1A, 0x52, 0x28,
  0x12, 0x5A, 0xE0, 0x35, 0x01, 0x0E, 0xC0, 0xA0, 0x27, 0x10, 0x20, 0xAC, 0x0E, 0x01, 0x40, 0xBC,
  0x07, 0x75, 0x07, 0xC0, 0xB3, 0x05, 0xC0, 0x77, 0x70, 0x7C, 0x05, 0x20, 0xDB, 0x0A, 0x77, 0x20,
  0xAB, 0x81, 0xD0, 0x3C, 0x02, 0x77, 0x20, 0x2C, 0x03, 0x07, 0xB0, 0xA7, 0x74, 0x0A, 0xB0, 0x70,
  0xBB, 0x05, 0x77, 0x40, 0x5B, 0x0B, 0x0D, 0xB0, 0x27, 0x74, 0x02, 0xB0, 0xD0, 0xEB, 0x77, 0x6B,
  0x0E, 0xC7, 0x76, 0xC0, 0xDB, 0x02, 0x77, 0x40, 0x2B, 0x0D, 0x0B, 0xB0, 0x57, 0x74, 0x05, 0xB0,
  0xB0, 0x8B, 0x0B, 0x77, 0x40, 0xBB, 0x08, 0x03, 0xC0, 0x27, 0x72, 0x02, 0xC8, 0x13, 0x0D, 0xB0,
  0xB7, 0x72, 0x0B, 0xB0, 0xD2, 0x05, 0xC0, 0x77, 0x70, 0x7C, 0x05, 0x30, 0xCC, 0x07, 0x75, 0x07,
  0xC0, 0xC4, 0x02, 0x0E, 0xC0, 0xA0, 0x17, 0x10, 0x10, 0xAC, 0x0E, 0x02, 0x50, 0x4D, 0x0D, 0x71,
  0x0D, 0xD0, 0x47, 0x04, 0x0E, 0xC7, 0x1C, 0x0E, 0x04, 0x72, 0x02, 0xC7, 0x1C, 0x02, 0x74, 0xC7,
  0x1C, 0x75, 0xC7, 0x1C, 0x75, 0xFF, 0xA7, 0x5F, 0xFA, 0x75, 0x0D, 0xFF, 0x0D, 0x75, 0x04, 0x0D,
  0xFD, 0x0D, 0x04, 0x80, 0x9F, 0x20, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0x0D, 0xFB, 0x0D, 0x77, 0x20,
  0x40, 0xDF, 0x90, 0xD0, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lightbulb_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 43), Box(0, 0, 47, 47),
      ic_round_48_action_lightbulb_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lightbulb 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_round_48_action_lightbulb_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDF, 0xFF, 0xB0, 0xD3, 0x07, 0xFF, 0xFD, 0x07, 0x20,
  0xEF, 0xFF, 0xD8, 0x1E, 0x03, 0xFF, 0xFF, 0x03, 0x08, 0xFF, 0xFF, 0x08, 0x0B, 0xFF, 0xFF, 0x0B,
  0x0D, 0xFF, 0xFF, 0x0D, 0x0E, 0xFF, 0xFF, 0x00, 0xEF, 0xFF, 0xF0, 0xE0, 0xDF, 0xFF, 0xF0, 0xD0,
  0xCF, 0xFF, 0xF0, 0xC0, 0x8F, 0xFF, 0xF0, 0x80, 0x4F, 0xFF, 0xF8, 0x14, 0x0E, 0xFF, 0xFD, 0x0E,
  0x20, 0x7F, 0xFF, 0xD0, 0x73, 0x0D, 0xFF, 0xFB, 0x0D, 0x40, 0x4F, 0xFF, 0xB0, 0x45, 0x08, 0xFF,
  0xF9, 0x08, 0x70, 0x9F, 0xFE, 0x09, 0x72, 0x08, 0xFF, 0xC0, 0x87, 0x40, 0x40, 0xEF, 0xF0, 0xE0,
  0x48, 0x09, 0x85, 0x00, 0x40, 0xDF, 0xD0, 0xD0, 0x47, 0x70, 0xDF, 0xF0, 0xD7, 0x70, 0xDF, 0xF0,
  0xD7, 0x70, 0x40, 0xDF, 0xD0, 0xD0, 0x48, 0x09, 0x92, 0x00, 0xDE, 0x0D, 0x77, 0x71, 0x0A, 0xE0,
  0xA7, 0x77, 0x10, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x72, 0x84, 0x1A, 0xDD, 0xA1, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lightbulb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 38, 43), Box(0, 0, 47, 47),
      ic_round_48_action_lightbulb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_line_style 48x48, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_round_48_action_line_style_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0xD8, 0x0A, 0x94, 0xF0, 0xDF, 0xFF,
  0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04, 0x80, 0xA9, 0x40, 0x04, 0x0D, 0xFD, 0x0D, 0x04,
  0x40, 0x40, 0xDF, 0xD8, 0x1D, 0x4D, 0xFF, 0x0D, 0x40, 0xDF, 0xF0, 0x0D, 0xFF, 0x0D, 0x40, 0xDF,
  0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x48, 0x0A, 0x94, 0x00, 0x40,
  0xDE, 0x0D, 0x04, 0x30, 0x40, 0xDE, 0x0D, 0x04, 0x30, 0x40, 0xDE, 0x81, 0xD4, 0xDF, 0x90, 0xD3,
  0x0D, 0xF9, 0x0D, 0x30, 0xDF, 0x90, 0x0D, 0xF9, 0x0D, 0x30, 0xDF, 0x90, 0xD3, 0x0D, 0xF9, 0x81,
  0xD4, 0xDE, 0x0D, 0x04, 0x30, 0x40, 0xDE, 0x0D, 0x04, 0x30, 0x40, 0xDE, 0x0D, 0x04, 0x80, 0xA9,
  0x40, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x83,
  0x4D, 0xD4, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x00,
  0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x83, 0xD4, 0xDD,
  0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_line_style() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_round_48_action_line_style_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_line_weight 48x48, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_48_action_line_weight_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0xD8, 0x0A, 0x94, 0xF0, 0xDF, 0xFF,
  0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04, 0x80, 0xA9, 0x40, 0x04, 0x0D, 0xFF, 0xFF, 0xC8,
  0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0xD8, 0x09, 0x84, 0xF0, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF,
  0xFC, 0x0D, 0x04, 0x80, 0xA9, 0x40, 0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0,
  0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xFF, 0xC0, 0xD0, 0x48, 0x0A, 0x94, 0x00, 0xBF, 0xFF,
  0xFE, 0x00, 0xBF, 0xFF, 0xFE, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_line_weight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_round_48_action_line_weight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_list 48x48, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_48_action_list_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x40, 0x40, 0xDF, 0xFF, 0xB8, 0x1D, 0x4D, 0xA0, 0xD4, 0x0D, 0xFF, 0xFD, 0x00,
  0xDA, 0x0D, 0x40, 0xDF, 0xFF, 0xD8, 0x3D, 0x4D, 0xD4, 0x40, 0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x48,
  0x0A, 0x94, 0x08, 0x24, 0xDD, 0x44, 0x04, 0x0D, 0xFF, 0xFB, 0x81, 0xD4, 0xDA, 0x0D, 0x40, 0xDF,
  0xFF, 0xD0, 0x0D, 0xA0, 0xD4, 0x0D, 0xFF, 0xFD, 0x83, 0xD4, 0xDD, 0x44, 0x04, 0x0D, 0xFF, 0xFB,
  0x0D, 0x04, 0x80, 0xA9, 0x40, 0x82, 0x4D, 0xD4, 0x40, 0x40, 0xDF, 0xFF, 0xB8, 0x1D, 0x4D, 0xA0,
  0xD4, 0x0D, 0xFF, 0xFD, 0x00, 0xDA, 0x0D, 0x40, 0xDF, 0xFF, 0xD8, 0x3D, 0x4D, 0xD4, 0x40, 0x40,
  0xDF, 0xFF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 14, 41, 33), Box(0, 0, 47, 47),
      ic_round_48_action_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lock_clock 48x48, 4-bit Alpha,  RLE, 293 bytes.
static const unsigned char ic_round_48_action_lock_clock_data[] PROGMEM = {
  0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x77, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x74, 0x08,
  0xFD, 0x08, 0x77, 0x72, 0x08, 0xFF, 0x08, 0x77, 0x70, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x04,
  0x77, 0x60, 0xDB, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x0D, 0x77, 0x50, 0x5C, 0x02, 0x71, 0x02, 0xC0,
  0x57, 0x74, 0x09, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0x77, 0x40, 0xDB, 0x03, 0x73, 0x03, 0xB0, 0xD7,
  0x74, 0x0E, 0xB7, 0x5B, 0x0E, 0x77, 0x4C, 0x75, 0xC7, 0x74, 0xC7, 0x5C, 0x77, 0x4C, 0x75, 0xC7,
  0x74, 0xC7, 0x5C, 0x76, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x70, 0x10, 0xEF, 0xFF, 0xF0,
  0xE0, 0x16, 0x0A, 0xFF, 0xFF, 0xA0, 0xA6, 0x0D, 0xFF, 0xFF, 0xA0, 0xD6, 0xFF, 0xFF, 0xC6, 0xFF,
  0xFF, 0xC6, 0xFF, 0xFA, 0x82, 0xC7, 0x42, 0x28, 0x11, 0x37, 0x6F, 0xFF, 0x0A, 0x02, 0x77, 0x1F,
  0xFD, 0x0D, 0x03, 0x77, 0x3F, 0xFC, 0x0B, 0x01, 0x77, 0x4F, 0xFB, 0x0B, 0x68, 0x65, 0x9D, 0xEE,
  0xD9, 0x56, 0xFF, 0xA0, 0xD0, 0x14, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x4F, 0xFA, 0x03, 0x40, 0x8F,
  0xD0, 0x83, 0xFF, 0x90, 0xA4, 0x08, 0xFF, 0x08, 0x2F, 0xF9, 0x02, 0x30, 0x4F, 0x00, 0x3F, 0x04,
  0x1F, 0xF0, 0xC4, 0x0D, 0xF2, 0xF0, 0xD1, 0xFF, 0x07, 0x30, 0x5F, 0x92, 0xF9, 0x05, 0xFF, 0x03,
  0x30, 0x9F, 0x92, 0xF9, 0x09, 0xFF, 0x02, 0x30, 0xDF, 0x92, 0xF9, 0x0D, 0xFF, 0x40, 0xEF, 0x92,
  0x0E, 0xF0, 0xEF, 0xF4, 0x0E, 0xF9, 0x82, 0x30, 0x2E, 0xE0, 0xEF, 0xF0, 0x13, 0x0D, 0xF9, 0x83,
  0xE2, 0x02, 0xED, 0x0D, 0xFF, 0x03, 0x30, 0x9F, 0xA8, 0x2E, 0x20, 0x2D, 0x09, 0xFF, 0x07, 0x30,
  0x5F, 0xB8, 0x2E, 0x20, 0xCC, 0x05, 0x0D, 0xFE, 0x0B, 0x40, 0xDF, 0xB0, 0xE0, 0xCC, 0x81, 0xD0,
  0xAF, 0xF0, 0x23, 0x04, 0xFF, 0xA8, 0x24, 0x01, 0xEF, 0xE0, 0x94, 0x08, 0xFF, 0x08, 0x38, 0x11,
  0xAD, 0xFD, 0x03, 0x40, 0x8F, 0xD0, 0x87, 0x77, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x78,
  0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lock_clock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_lock_clock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lock_open 48x48, 4-bit Alpha,  RLE, 218 bytes.
static const unsigned char ic_round_48_action_lock_open_data[] PROGMEM = {
  0x75, 0x86, 0x5A, 0xDF, 0xED, 0x95, 0x77, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x50, 0x8F,
  0xD0, 0x87, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x10, 0x5D, 0x84, 0x93, 0x10, 0x38, 0xD0, 0x47, 0x70,
  0xDB, 0x0E, 0x03, 0x60, 0x30, 0xDB, 0x0D, 0x76, 0x05, 0xC0, 0x37, 0x10, 0x3C, 0x05, 0x75, 0x09,
  0xB0, 0x97, 0x30, 0x8B, 0x09, 0x75, 0x09, 0xB0, 0x37, 0x30, 0x3B, 0x0D, 0x75, 0x82, 0x2C, 0xE7,
  0x75, 0xB0, 0xE7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x81, 0x1A, 0xDF,
  0xFF, 0xB8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xF8, 0x1E, 0x1A, 0xFF, 0xFF, 0xA0, 0xA0, 0xDF, 0xFF,
  0xFA, 0x0D, 0xC0, 0xB0, 0x17, 0x76, 0x01, 0x0B, 0xF9, 0x01, 0x77, 0x71, 0x01, 0xF9, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x72, 0x84, 0x1A, 0xDD, 0xA1, 0x72,
  0xF9, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x1F, 0x97, 0x10, 0xAE, 0x0A, 0x71, 0xF9, 0x71, 0x0D,
  0xE0, 0xD7, 0x1F, 0x97, 0x10, 0xDE, 0x0D, 0x71, 0xF9, 0x71, 0x0A, 0xE0, 0xA7, 0x1F, 0x97, 0x10,
  0x10, 0xEC, 0x0E, 0x01, 0x71, 0xF9, 0x72, 0x84, 0x1A, 0xDD, 0xA1, 0x72, 0xF9, 0x77, 0x73, 0xF9,
  0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x01, 0x77, 0x71, 0x01, 0xF9, 0x0B, 0x01,
  0x77, 0x60, 0x10, 0xBC, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF,
  0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lock_open() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_lock_open_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lock_outline 48x48, 4-bit Alpha,  RLE, 219 bytes.
static const unsigned char ic_round_48_action_lock_outline_data[] PROGMEM = {
  0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x50, 0x8F,
  0xD0, 0x87, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x10, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x04, 0x77,
  0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xD7, 0x60, 0x5C, 0x02, 0x71, 0x02, 0xC0, 0x57, 0x50,
  0x9B, 0x08, 0x73, 0x08, 0xB0, 0x97, 0x50, 0xDB, 0x03, 0x73, 0x03, 0xB0, 0xD7, 0x50, 0xEB, 0x75,
  0xB0, 0xE7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x81, 0x1A,
  0xDF, 0xFF, 0xB8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xF8, 0x1E, 0x1A, 0xFF, 0xFF, 0xA0, 0xA0, 0xDF,
  0xFF, 0xFA, 0x0D, 0xC0, 0xB0, 0x17, 0x76, 0x01, 0x0B, 0xF9, 0x01, 0x77, 0x71, 0x01, 0xF9, 0x77,
  0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x72, 0x84, 0x1A, 0xDD, 0xA1,
  0x72, 0xF9, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x1F, 0x97, 0x10, 0xAE, 0x0A, 0x71, 0xF9, 0x71,
  0x0D, 0xE0, 0xD7, 0x1F, 0x97, 0x10, 0xDE, 0x0D, 0x71, 0xF9, 0x71, 0x0A, 0xE0, 0xA7, 0x1F, 0x97,
  0x10, 0x10, 0xEC, 0x0E, 0x01, 0x71, 0xF9, 0x72, 0x84, 0x1A, 0xDD, 0xA1, 0x72, 0xF9, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x01, 0x77, 0x71, 0x01, 0xF9, 0x0B,
  0x01, 0x77, 0x60, 0x10, 0xBC, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF,
  0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lock_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_lock_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lock_person 48x48, 4-bit Alpha,  RLE, 311 bytes.
static const unsigned char ic_round_48_action_lock_person_data[] PROGMEM = {
  0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x77, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x74, 0x08,
  0xFD, 0x08, 0x77, 0x72, 0x08, 0xD8, 0x2E, 0xDD, 0xED, 0x08, 0x77, 0x70, 0x4C, 0x0D, 0x05, 0x40,
  0x50, 0xDC, 0x04, 0x77, 0x60, 0xDB, 0x0B, 0x71, 0x0B, 0xB0, 0xD7, 0x75, 0x05, 0xB0, 0xD7, 0x30,
  0xDB, 0x05, 0x77, 0x40, 0x9B, 0x05, 0x73, 0x05, 0xB0, 0x97, 0x74, 0x0D, 0xB7, 0x5B, 0x0D, 0x77,
  0x40, 0xEA, 0x0D, 0x75, 0x0D, 0xA0, 0xE7, 0x74, 0xB0, 0xC7, 0x50, 0xCB, 0x77, 0x4B, 0x0C, 0x75,
  0x0C, 0xB7, 0x74, 0xB0, 0xC7, 0x50, 0xCB, 0x77, 0x4B, 0x0C, 0x75, 0x0C, 0xB7, 0x68, 0x11, 0xAD,
  0xFF, 0xFB, 0x81, 0xDA, 0x17, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x60, 0xAF, 0xFF, 0xFA, 0x0A,
  0x60, 0xDF, 0xFF, 0xFA, 0x0D, 0x6F, 0xFF, 0xFC, 0x6F, 0xFF, 0xFC, 0x6F, 0xFF, 0xA8, 0x2C, 0x74,
  0x22, 0x81, 0x13, 0x76, 0xFF, 0xF0, 0xA0, 0x27, 0x71, 0xFF, 0xD0, 0xD0, 0x37, 0x73, 0xFF, 0xC0,
  0xB0, 0x17, 0x74, 0xFF, 0xB0, 0xB6, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x6F, 0xFA, 0x0D, 0x01, 0x40,
  0x40, 0xDF, 0x90, 0xD0, 0x44, 0xFF, 0xA0, 0x34, 0x08, 0xFD, 0x08, 0x3F, 0xF9, 0x0A, 0x40, 0x8F,
  0xF0, 0x82, 0xFF, 0x90, 0x23, 0x04, 0xE8, 0x27, 0x11, 0x7E, 0x04, 0x1F, 0xF0, 0xC4, 0x0D, 0xD0,
  0x74, 0x07, 0xD0, 0xD1, 0xFF, 0x07, 0x30, 0x5E, 0x01, 0x40, 0x1E, 0x05, 0xFF, 0x03, 0x30, 0x9E,
  0x01, 0x40, 0x1E, 0x09, 0xFF, 0x02, 0x30, 0xDE, 0x07, 0x40, 0x7E, 0x0D, 0xFF, 0x40, 0xEF, 0x82,
  0x71, 0x17, 0xF0, 0xEF, 0xF4, 0x0E, 0xFF, 0xC0, 0xEF, 0xF0, 0x13, 0x0D, 0xFF, 0xC0, 0xDF, 0xF0,
  0x33, 0x09, 0xD8, 0x1A, 0x52, 0x28, 0x12, 0x5A, 0xD0, 0x9F, 0xF0, 0x73, 0x05, 0xC0, 0x57, 0x10,
  0x5C, 0x05, 0x0D, 0xFE, 0x0B, 0x40, 0xDB, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x81, 0xD0, 0xAF, 0xF0,
  0x23, 0x04, 0xD8, 0x49, 0x31, 0x13, 0x9D, 0x82, 0x40, 0x1E, 0xFE, 0x09, 0x40, 0x8F, 0xF0, 0x83,
  0x81, 0x1A, 0xDF, 0xD0, 0x34, 0x08, 0xFD, 0x08, 0x77, 0x74, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77,
  0x77, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lock_person() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_lock_person_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lock 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_round_48_action_lock_data[] PROGMEM = {
  0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x50, 0x8F,
  0xD0, 0x87, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x10, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x04, 0x77,
  0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xD7, 0x60, 0x5C, 0x02, 0x71, 0x02, 0xC0, 0x57, 0x50,
  0x9B, 0x08, 0x73, 0x08, 0xB0, 0x97, 0x50, 0xDB, 0x03, 0x73, 0x03, 0xB0, 0xD7, 0x50, 0xEB, 0x75,
  0xB0, 0xE7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x81, 0x1A,
  0xDF, 0xFF, 0xB8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xF8, 0x1E, 0x1A, 0xFF, 0xFF, 0xA0, 0xA0, 0xDF,
  0xFF, 0xFA, 0x0D, 0x80, 0xB9, 0x1F, 0x84, 0xD5, 0x11, 0x5D, 0xFF, 0xFC, 0x0D, 0x01, 0x40, 0x10,
  0xDF, 0xFF, 0xB0, 0x56, 0x05, 0xFF, 0xFB, 0x01, 0x60, 0x1F, 0xFF, 0xB0, 0x16, 0x01, 0xFF, 0xFB,
  0x05, 0x60, 0x5F, 0xFF, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xFC, 0x84, 0xD5, 0x11, 0x5D, 0x80,
  0xB9, 0x1F, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF, 0xF8, 0x4E,
  0x10, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_lock_reset 48x48, 4-bit Alpha,  RLE, 317 bytes.
static const unsigned char ic_round_48_action_lock_reset_data[] PROGMEM = {
  0x77, 0x38, 0x91, 0x15, 0x9B, 0xDE, 0xFD, 0xB9, 0x57, 0x77, 0x70, 0x40, 0xBF, 0xD0, 0xA0, 0x47,
  0x77, 0x20, 0x30, 0xCF, 0xFA, 0x0B, 0x02, 0x77, 0x60, 0x8F, 0xFE, 0x07, 0x77, 0x30, 0x10, 0xBE,
  0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE, 0x0A, 0x77, 0x20, 0xCD, 0x0A, 0x02, 0x73, 0x03, 0x0B,
  0xD0, 0xB7, 0x70, 0xBC, 0x0D, 0x03, 0x77, 0x04, 0x0E, 0xC0, 0xA7, 0x50, 0x8C, 0x0B, 0x01, 0x77,
  0x20, 0x10, 0xCC, 0x07, 0x73, 0x03, 0xC0, 0xB7, 0x76, 0x0C, 0xC0, 0x27, 0x20, 0xBB, 0x0D, 0x01,
  0x77, 0x60, 0x10, 0xEB, 0x0B, 0x71, 0x05, 0xC0, 0x37, 0x18, 0x41, 0xAD, 0xDA, 0x17, 0x10, 0x4C,
  0x04, 0x70, 0xBB, 0x0A, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x10, 0xBB, 0x0A, 0x60, 0x1C, 0x02,
  0x71, 0x86, 0xAF, 0xB1, 0x1B, 0xFA, 0x71, 0x03, 0xC0, 0x15, 0x05, 0xB0, 0xC7, 0x28, 0x1D, 0xF1,
  0x28, 0x11, 0xFD, 0x72, 0x0D, 0xB0, 0x55, 0x09, 0xB0, 0x77, 0x2A, 0x4A, 0x72, 0x07, 0xB0, 0x95,
  0x0B, 0xB0, 0x37, 0x2A, 0x4A, 0x72, 0x04, 0xB0, 0xB5, 0x0D, 0xB0, 0x27, 0x04, 0x0D, 0xF9, 0x0D,
  0x04, 0x70, 0x2B, 0x0D, 0x50, 0xEB, 0x71, 0x0D, 0xFB, 0x0D, 0x71, 0xC0, 0x5F, 0xD0, 0x53, 0xFD,
  0x71, 0xB0, 0xE0, 0x5F, 0xD0, 0x63, 0xFD, 0x70, 0x2B, 0x81, 0xD0, 0x7F, 0xB0, 0x84, 0xFD, 0x70,
  0x3B, 0x0B, 0x20, 0x7F, 0x90, 0x75, 0xFD, 0x70, 0x7B, 0x09, 0x30, 0x7E, 0x07, 0x6F, 0xD7, 0x0C,
  0xB0, 0x54, 0x07, 0xC0, 0x77, 0xFD, 0x60, 0x2C, 0x01, 0x50, 0x7A, 0x07, 0x71, 0x0D, 0xFB, 0x0D,
  0x60, 0xAB, 0x0B, 0x70, 0x05, 0x72, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x50, 0x3C, 0x04, 0x77, 0x77,
  0x60, 0x10, 0xDB, 0x0C, 0x77, 0x77, 0x70, 0xBC, 0x03, 0x77, 0x01, 0x03, 0x77, 0x30, 0x10, 0xBC,
  0x08, 0x77, 0x83, 0x3E, 0xFD, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x77, 0x10, 0x9C, 0x09, 0x02, 0x73,
  0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x71, 0x07, 0xE8, 0x2B, 0x73, 0x12, 0x82, 0x24, 0x7C, 0xE0, 0xB7,
  0x74, 0x08, 0xFF, 0xE0, 0x87, 0x76, 0x03, 0x0C, 0xFF, 0xA0, 0xB0, 0x37, 0x77, 0x20, 0x40, 0xBF,
  0xD0, 0xB0, 0x57, 0x77, 0x68, 0x92, 0x15, 0x9C, 0xDF, 0xED, 0xB9, 0x51, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_lock_reset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_lock_reset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_login 48x48, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_round_48_action_login_data[] PROGMEM = {
  0x77, 0x60, 0x40, 0xDF, 0xF8, 0x1D, 0xA1, 0x77, 0x70, 0xDF, 0xFB, 0x0E, 0x01, 0x77, 0x60, 0xDF,
  0xFC, 0x0A, 0x77, 0x60, 0x40, 0xDF, 0xFB, 0x0D, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0,
  0x0C, 0x80, 0xC0, 0x0C, 0x77, 0x30, 0x01, 0x77, 0x3C, 0x77, 0x20, 0x6A, 0x07, 0x77, 0x2C, 0x77,
  0x20, 0xEB, 0x07, 0x77, 0x1C, 0x77, 0x20, 0xCC, 0x07, 0x77, 0xC7, 0x72, 0x02, 0x0E, 0xC0, 0x77,
  0x6C, 0x77, 0x30, 0x20, 0xEC, 0x07, 0x75, 0xC7, 0x74, 0x02, 0x0E, 0xC0, 0x77, 0x4C, 0x77, 0x50,
  0x20, 0xEC, 0x07, 0x73, 0xC0, 0x40, 0xDF, 0xFF, 0xB0, 0x77, 0x2C, 0x0D, 0xFF, 0xFD, 0x01, 0x71,
  0xC0, 0xDF, 0xFF, 0xD0, 0x17, 0x1C, 0x04, 0x0D, 0xFF, 0xFB, 0x07, 0x72, 0xC7, 0x75, 0x02, 0x0E,
  0xC0, 0x77, 0x3C, 0x77, 0x40, 0x20, 0xEC, 0x07, 0x74, 0xC7, 0x73, 0x02, 0x0E, 0xC0, 0x77, 0x5C,
  0x77, 0x20, 0x20, 0xEC, 0x07, 0x76, 0xC7, 0x72, 0x0C, 0xC0, 0x77, 0x7C, 0x77, 0x20, 0xEB, 0x07,
  0x77, 0x1C, 0x77, 0x20, 0x6A, 0x07, 0x77, 0x2C, 0x77, 0x30, 0x01, 0x77, 0x3C, 0x80, 0xC0, 0x0C,
  0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x77, 0x60, 0x40, 0xDF, 0xFB, 0x0D, 0x77,
  0x60, 0xDF, 0xFC, 0x0A, 0x77, 0x60, 0xDF, 0xFB, 0x0E, 0x01, 0x77, 0x60, 0x40, 0xDF, 0xF8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_login() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_login_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_logout 48x48, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_round_48_action_logout_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFD, 0x0D, 0x04, 0x77, 0x40, 0x10, 0xEF, 0xF9, 0x0D, 0x77, 0x40, 0xAF, 0xFA,
  0x0D, 0x77, 0x40, 0xDF, 0xF9, 0x0D, 0x04, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77,
  0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x73,
  0x00, 0x56, 0xC7, 0x77, 0x3A, 0x07, 0x5C, 0x77, 0x73, 0xB0, 0x74, 0xC7, 0x77, 0x3C, 0x07, 0x3C,
  0x77, 0x73, 0xD0, 0x72, 0xC7, 0x10, 0x40, 0xDF, 0xFE, 0x07, 0x1C, 0x71, 0x0D, 0xFF, 0xF9, 0x05,
  0xC7, 0x10, 0xDF, 0xFF, 0x90, 0x5C, 0x71, 0x04, 0x0D, 0xFF, 0xE0, 0x71, 0xC7, 0x77, 0x3D, 0x07,
  0x2C, 0x77, 0x73, 0xC0, 0x73, 0xC7, 0x77, 0x3B, 0x07, 0x4C, 0x77, 0x73, 0xA0, 0x75, 0xC7, 0x77,
  0x30, 0x05, 0x6C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77,
  0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x40, 0xDF, 0xF9, 0x0D, 0x04, 0x77, 0x40, 0xAF, 0xFA,
  0x0D, 0x77, 0x40, 0x10, 0xEF, 0xF9, 0x0D, 0x77, 0x58, 0x11, 0xAD, 0xFD, 0x0D, 0x04, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_logout() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_logout_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_loyalty 48x48, 4-bit Alpha,  RLE, 302 bytes.
static const unsigned char ic_round_48_action_loyalty_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEA, 0x27, 0x75, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x37, 0x74, 0x0A,
  0xFF, 0xE0, 0xE0, 0x37, 0x73, 0x0D, 0xFF, 0xF0, 0xE0, 0x37, 0x72, 0xD8, 0x27, 0x11, 0x7F, 0xF0,
  0xE0, 0x37, 0x71, 0xC0, 0x74, 0x07, 0xFF, 0x0E, 0x03, 0x77, 0xC0, 0x14, 0x01, 0xFF, 0x90, 0xE0,
  0x37, 0x6C, 0x01, 0x40, 0x1F, 0xFA, 0x0E, 0x03, 0x75, 0xC0, 0x74, 0x07, 0xFF, 0xB0, 0xE0, 0x37,
  0x4D, 0x82, 0x71, 0x17, 0xFF, 0xD0, 0xE0, 0x37, 0x3F, 0xFF, 0xF9, 0x0E, 0x03, 0x72, 0xFF, 0xFF,
  0xA0, 0xE0, 0x37, 0x1F, 0xFF, 0xFB, 0x0E, 0x03, 0x7F, 0xFF, 0xFC, 0x0E, 0x03, 0x6F, 0xFF, 0xFD,
  0x0E, 0x03, 0x5F, 0xFF, 0xFE, 0x0E, 0x03, 0x4F, 0xFF, 0xFF, 0x0E, 0x03, 0x38, 0x0C, 0x0F, 0x0E,
  0x03, 0x20, 0xEF, 0xE8, 0x4A, 0x31, 0x14, 0xBC, 0x0A, 0x03, 0x20, 0x30, 0xAF, 0x82, 0xE3, 0x0A,
  0xFD, 0x06, 0x60, 0x7A, 0x06, 0x60, 0x7F, 0x82, 0xE2, 0x2E, 0xFB, 0x0A, 0x71, 0x00, 0x67, 0x10,
  0xAF, 0x82, 0xA0, 0x3E, 0xFA, 0x03, 0x77, 0x40, 0x3F, 0x0E, 0x20, 0x30, 0xEF, 0x97, 0x76, 0xF0,
  0xE3, 0x03, 0x0E, 0xF7, 0x76, 0xF0, 0xA4, 0x03, 0x0E, 0xE0, 0x37, 0x74, 0x03, 0xE0, 0xE0, 0x25,
  0x03, 0x0E, 0xD0, 0xA7, 0x74, 0x0A, 0xD0, 0xE0, 0x37, 0x03, 0x0E, 0xD0, 0x67, 0x72, 0x06, 0xD0,
  0xE0, 0x37, 0x20, 0x30, 0xED, 0x06, 0x77, 0x06, 0xD0, 0xE0, 0x37, 0x40, 0x30, 0xED, 0x06, 0x75,
  0x06, 0xD0, 0xE0, 0x37, 0x60, 0x30, 0xED, 0x06, 0x73, 0x06, 0xD0, 0xE0, 0x37, 0x71, 0x03, 0x0E,
  0xD0, 0x67, 0x10, 0x6D, 0x0E, 0x03, 0x77, 0x30, 0x30, 0xED, 0x06, 0x60, 0x6D, 0x0E, 0x03, 0x77,
  0x50, 0x30, 0xED, 0x06, 0x40, 0x6D, 0x0E, 0x03, 0x77, 0x70, 0x30, 0xED, 0x06, 0x20, 0x6D, 0x0E,
  0x03, 0x77, 0x72, 0x03, 0x0E, 0xD0, 0x08, 0xD0, 0xE0, 0x37, 0x77, 0x40, 0x30, 0xEF, 0xB0, 0xE0,
  0x37, 0x77, 0x60, 0x30, 0xEF, 0x90, 0xE0, 0x37, 0x77, 0x71, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77,
  0x73, 0x03, 0x0E, 0xC0, 0xE0, 0x37, 0x77, 0x75, 0x84, 0x2A, 0xEE, 0xA2, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_loyalty() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_loyalty_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_manage_accounts 48x48, 4-bit Alpha,  RLE, 266 bytes.
static const unsigned char ic_round_48_action_manage_accounts_data[] PROGMEM = {
  0x75, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0x77, 0x30, 0x9F, 0x90, 0x97, 0x77, 0x71, 0x0B, 0xFB,
  0x0B, 0x77, 0x76, 0x09, 0xFD, 0x09, 0x77, 0x74, 0x02, 0xFF, 0x02, 0x77, 0x73, 0x08, 0xFF, 0x08,
  0x77, 0x73, 0x0C, 0xFF, 0x0C, 0x77, 0x73, 0x0E, 0xFF, 0x0E, 0x77, 0x73, 0x0E, 0xFF, 0x0E, 0x77,
  0x73, 0x0C, 0xFF, 0x0C, 0x77, 0x73, 0x08, 0xFF, 0x08, 0x77, 0x73, 0x02, 0xFF, 0x02, 0x77, 0x74,
  0x09, 0xFD, 0x09, 0x77, 0x76, 0x0B, 0xFB, 0x0B, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x97, 0x0C, 0xA0,
  0xD0, 0x17, 0x75, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x70, 0x4C, 0x04, 0x77, 0x77, 0x60, 0x7C, 0x08,
  0x77, 0x77, 0x10, 0x05, 0x20, 0x80, 0xED, 0x08, 0x20, 0x50, 0x67, 0x48, 0x42, 0x58, 0xBD, 0xDA,
  0x02, 0x30, 0x5A, 0x0E, 0x0D, 0xF9, 0x0D, 0x0E, 0xA0, 0x57, 0x81, 0x27, 0xDF, 0x0B, 0x40, 0xDF,
  0xFA, 0x0E, 0x50, 0x30, 0xBF, 0xB0, 0x73, 0x04, 0xE8, 0x4D, 0x51, 0x15, 0xDE, 0x04, 0x20, 0x20,
  0xBF, 0xD0, 0x34, 0x0B, 0xC0, 0xD0, 0x14, 0x01, 0x0D, 0xC0, 0xB2, 0x04, 0x0E, 0xFE, 0x01, 0x50,
  0x9B, 0x05, 0x60, 0x5B, 0x0A, 0x20, 0x10, 0xEF, 0xF6, 0x06, 0xB0, 0x16, 0x01, 0xB0, 0x72, 0x08,
  0xFF, 0x96, 0x06, 0xB0, 0x16, 0x01, 0xB0, 0x72, 0x0D, 0xFF, 0x90, 0x15, 0x09, 0xB0, 0x56, 0x05,
  0xB0, 0xA2, 0xFF, 0xA0, 0x34, 0x0B, 0xC0, 0xD0, 0x14, 0x01, 0x0D, 0xC0, 0xB1, 0xFF, 0xA0, 0x73,
  0x04, 0xE8, 0x4D, 0x51, 0x15, 0xDE, 0x04, 0xFF, 0xA0, 0xB4, 0x0D, 0xFF, 0xA0, 0xE1, 0xFF, 0xB0,
  0x23, 0x05, 0xA0, 0xE0, 0xDF, 0x90, 0xD0, 0xEA, 0x81, 0x50, 0xDF, 0xFA, 0x09, 0x40, 0x05, 0x20,
  0x80, 0xED, 0x08, 0x20, 0x50, 0x62, 0x04, 0x0D, 0xFF, 0xA0, 0x37, 0x10, 0x7C, 0x08, 0x77, 0x77,
  0x60, 0x4C, 0x04, 0x77, 0x77, 0x70, 0xCA, 0x0D, 0x01, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_manage_accounts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_manage_accounts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_manage_history 48x48, 4-bit Alpha,  RLE, 375 bytes.
static const unsigned char ic_round_48_action_manage_history_data[] PROGMEM = {
  0x75, 0x89, 0x21, 0x69, 0xCD, 0xFE, 0xDB, 0x95, 0x17, 0x77, 0x70, 0x50, 0xBF, 0xD0, 0xB0, 0x47,
  0x72, 0x82, 0x4D, 0xD4, 0x40, 0x30, 0xCF, 0xFA, 0x0B, 0x03, 0x77, 0x0D, 0xA0, 0xD3, 0x08, 0xFF,
  0xE0, 0x87, 0x6C, 0x10, 0x10, 0xBE, 0x82, 0xB7, 0x31, 0x28, 0x22, 0x47, 0xCE, 0x0B, 0x01, 0x74,
  0xC0, 0x10, 0xCD, 0x09, 0x02, 0x73, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x3C, 0x0B, 0xC0, 0xD0, 0x37,
  0x70, 0x30, 0xDC, 0x0B, 0x73, 0xF9, 0x0B, 0x77, 0x30, 0x10, 0xBC, 0x08, 0x72, 0xF0, 0xB7, 0x18,
  0x24, 0xDD, 0x47, 0x10, 0xBC, 0x03, 0x71, 0xE0, 0xD7, 0x20, 0xDA, 0x0D, 0x71, 0x01, 0x0D, 0xB0,
  0xB7, 0x1F, 0xB0, 0xD0, 0x44, 0xC7, 0x20, 0x3C, 0x04, 0x7F, 0xC0, 0xD4, 0xC7, 0x30, 0xAB, 0x0B,
  0x70, 0xDF, 0xB0, 0xD4, 0xC7, 0x30, 0x2C, 0x01, 0x60, 0x40, 0xDF, 0x90, 0xD0, 0x44, 0xC7, 0x40,
  0xCB, 0x05, 0x77, 0x71, 0xC7, 0x40, 0x7B, 0x09, 0x77, 0x71, 0xC7, 0x40, 0x3B, 0x0B, 0x77, 0x71,
  0xC7, 0x40, 0x2B, 0x0D, 0x77, 0x71, 0xC0, 0x57, 0x4B, 0x0E, 0x77, 0x71, 0x0D, 0xC0, 0x58, 0x0C,
  0x00, 0x05, 0xD0, 0x57, 0x76, 0x81, 0xAE, 0xA7, 0x60, 0x5C, 0x07, 0x77, 0x50, 0x5B, 0x06, 0x76,
  0x05, 0xA0, 0xD7, 0x76, 0x06, 0xB0, 0xC7, 0x78, 0x15, 0xF5, 0x71, 0x0C, 0xA0, 0xD0, 0x17, 0x01,
  0xC0, 0x27, 0x70, 0x37, 0x10, 0x4C, 0x04, 0x71, 0x0B, 0xB0, 0x97, 0x77, 0x20, 0x7C, 0x08, 0x71,
  0x05, 0xC0, 0x37, 0x73, 0x00, 0x52, 0x08, 0x0E, 0xD0, 0x82, 0x05, 0x06, 0x40, 0xCB, 0x0D, 0x77,
  0x20, 0x5A, 0x0E, 0x0D, 0xF9, 0x0D, 0x0E, 0xA0, 0x53, 0x03, 0xC0, 0xB7, 0x71, 0x0D, 0xFF, 0xA0,
  0xE4, 0x08, 0xC0, 0xB7, 0x60, 0x4E, 0x84, 0xD5, 0x11, 0x5D, 0xE0, 0x44, 0x0B, 0xC0, 0xD0, 0x37,
  0x50, 0xBC, 0x0D, 0x01, 0x40, 0x10, 0xDC, 0x0B, 0x50, 0x10, 0xCD, 0x09, 0x02, 0x74, 0x09, 0xB0,
  0x56, 0x05, 0xB0, 0xA7, 0x01, 0x0B, 0xE8, 0x1B, 0x73, 0x71, 0x06, 0xB0, 0x16, 0x01, 0xB0, 0x77,
  0x20, 0x8F, 0x90, 0x27, 0x06, 0xB0, 0x16, 0x01, 0xB0, 0x77, 0x30, 0x30, 0xDE, 0x0A, 0x70, 0x9B,
  0x05, 0x60, 0x5B, 0x0A, 0x75, 0x04, 0x0B, 0xD0, 0x45, 0x0B, 0xC0, 0xD0, 0x14, 0x01, 0x0D, 0xC0,
  0xB7, 0x68, 0x41, 0x59, 0xBD, 0xC4, 0x04, 0xE8, 0x4D, 0x51, 0x15, 0xDE, 0x04, 0x77, 0x72, 0x0D,
  0xFF, 0xA0, 0xE7, 0x77, 0x30, 0x5A, 0x0E, 0x0D, 0xF9, 0x0D, 0x0E, 0xA0, 0x57, 0x77, 0x40, 0x05,
  0x20, 0x80, 0xED, 0x08, 0x20, 0x50, 0x67, 0x77, 0x73, 0x07, 0xC0, 0x88, 0x0C, 0x00, 0x04, 0xC0,
  0x48, 0x0C, 0x10, 0x0C, 0xA0, 0xD0, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_manage_history() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 47, 47), Box(0, 0, 47, 47),
      ic_round_48_action_manage_history_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_mark_as_unread 48x48, 4-bit Alpha,  RLE, 270 bytes.
static const unsigned char ic_round_48_action_mark_as_unread_data[] PROGMEM = {
  0x77, 0x18, 0x23, 0x77, 0x37, 0x77, 0x76, 0x04, 0x0B, 0xC0, 0xB0, 0x37, 0x77, 0x72, 0x04, 0x0B,
  0xF9, 0x0B, 0x03, 0x77, 0x75, 0x04, 0x0C, 0xFD, 0x0A, 0x03, 0x77, 0x71, 0x04, 0x0C, 0xE8, 0x2C,
  0x44, 0xCE, 0x0A, 0x02, 0x77, 0x40, 0x40, 0xCE, 0x0C, 0x04, 0x40, 0x40, 0xCE, 0x0A, 0x02, 0x77,
  0x04, 0x0C, 0xE0, 0xD0, 0x57, 0x10, 0x50, 0xDE, 0x0A, 0x02, 0x73, 0x03, 0x0C, 0xE0, 0xD0, 0x67,
  0x50, 0x60, 0xDE, 0x09, 0x01, 0x70, 0x5E, 0x0E, 0x06, 0x77, 0x20, 0x70, 0xED, 0x0D, 0x01, 0x60,
  0xCC, 0x0E, 0x07, 0x77, 0x60, 0x70, 0xEC, 0x08, 0x6C, 0x08, 0x01, 0x77, 0x77, 0x6C, 0x80, 0xC0,
  0x0C, 0x38, 0x11, 0xAD, 0xFF, 0xFD, 0x81, 0xDA, 0x11, 0xC2, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0xE0,
  0x1C, 0x20, 0xAF, 0xFF, 0xFC, 0x0A, 0xC2, 0x0D, 0xFF, 0xFF, 0xC0, 0xDC, 0x28, 0x0C, 0x2F, 0x2C,
  0x82, 0xB3, 0x5C, 0xFF, 0xC8, 0x2C, 0x53, 0xBF, 0x92, 0xC0, 0x13, 0x04, 0x0C, 0xFF, 0x0C, 0x04,
  0x30, 0x1F, 0x92, 0xC0, 0x25, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x50, 0x2F, 0x92, 0xC0, 0xD0, 0x36,
  0x05, 0x0D, 0xE0, 0xD0, 0x56, 0x03, 0x0D, 0xF9, 0x2E, 0x0B, 0x03, 0x60, 0x60, 0xDA, 0x0D, 0x06,
  0x60, 0x30, 0xBF, 0xB2, 0xF9, 0x0A, 0x02, 0x60, 0x06, 0x60, 0x20, 0xAF, 0xD2, 0xFB, 0x0A, 0x02,
  0x73, 0x02, 0x0A, 0xFF, 0x2F, 0xD0, 0x90, 0x26, 0x02, 0x09, 0xFF, 0xA2, 0xFF, 0x09, 0x01, 0x20,
  0x10, 0x9F, 0xF0, 0xDB, 0x2F, 0xFA, 0x00, 0xAF, 0xFA, 0x0A, 0xB2, 0xFF, 0xFF, 0xE0, 0x10, 0xEA,
  0x2F, 0xFF, 0xFE, 0x18, 0x11, 0xAD, 0x2F, 0xFF, 0xFE, 0x6F, 0xFF, 0xFE, 0x6F, 0xFF, 0xFE, 0x6F,
  0xFF, 0xFE, 0x6F, 0xFF, 0xFE, 0x60, 0xDF, 0xFF, 0xFC, 0x0D, 0x60, 0xAF, 0xFF, 0xFC, 0x0A, 0x60,
  0x10, 0xEF, 0xFF, 0xFA, 0x0E, 0x01, 0x78, 0x11, 0xAD, 0xFF, 0xFD, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_mark_as_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_mark_as_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_markunread_mailbox 48x48, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_round_48_action_markunread_mailbox_data[] PROGMEM = {
  0x71, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x77, 0x73, 0x0D, 0xFF, 0x0D, 0x77, 0x73, 0xFF, 0xA7, 0x77,
  0x3F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x77, 0x3F, 0xFA, 0x77, 0x73, 0xFF, 0x90, 0xD7, 0x77, 0x3F,
  0xF0, 0xD0, 0x47, 0x77, 0x3C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x77, 0x77,
  0x18, 0x11, 0xAD, 0xF9, 0x4F, 0xFE, 0x84, 0xDA, 0x10, 0x1E, 0xFB, 0x4F, 0xFF, 0x98, 0x1E, 0x1A,
  0xFC, 0x4F, 0xFF, 0xA0, 0xA0, 0xDF, 0xC4, 0xFF, 0xFA, 0x0D, 0xFD, 0x48, 0x0C, 0x0F, 0x48, 0x0C,
  0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x01, 0x20, 0x18,
  0x0C, 0x0F, 0x82, 0xB1, 0x1B, 0x80, 0x9A, 0xA4, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2,
  0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_markunread_mailbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_markunread_mailbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_maximize 48x48, 4-bit Alpha,  RLE, 21 bytes.
static const unsigned char ic_round_48_action_maximize_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_maximize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 9), Box(0, 0, 47, 47),
      ic_round_48_action_maximize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_mediation 48x48, 4-bit Alpha,  RLE, 297 bytes.
static const unsigned char ic_round_48_action_mediation_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x72, 0x0C, 0xF9,
  0x0C, 0x77, 0x77, 0x10, 0x6F, 0xB0, 0x67, 0x77, 0x70, 0xBF, 0xB0, 0xB7, 0x77, 0x70, 0xEF, 0xB0,
  0xE7, 0x77, 0x70, 0xEF, 0xC0, 0xC0, 0x37, 0x77, 0x50, 0xBF, 0xE0, 0x87, 0x77, 0x40, 0x6F, 0xF0,
  0xB7, 0x77, 0x40, 0xBF, 0x90, 0xDD, 0x0C, 0x01, 0x77, 0x72, 0x01, 0x0B, 0xE8, 0x2C, 0x13, 0xDC,
  0x0B, 0x77, 0x74, 0x84, 0x6B, 0xDF, 0xB6, 0x30, 0x10, 0xBC, 0x08, 0x77, 0x77, 0x70, 0xBC, 0x03,
  0x77, 0x77, 0x60, 0x10, 0xDB, 0x0C, 0x77, 0x77, 0x70, 0x3C, 0x04, 0x77, 0x77, 0x70, 0x9B, 0x0B,
  0x74, 0x00, 0x57, 0x28, 0x46, 0xCE, 0xEB, 0x57, 0x02, 0xC0, 0x17, 0x3A, 0x07, 0x60, 0x10, 0xCE,
  0x0C, 0x01, 0x60, 0xCB, 0x05, 0x73, 0xB0, 0x75, 0x0C, 0xF9, 0x0C, 0x60, 0x7B, 0x09, 0x73, 0xC0,
  0x73, 0x06, 0xFB, 0x05, 0x50, 0x4B, 0x0B, 0x73, 0xD0, 0x72, 0x0C, 0x80, 0xC1, 0xF8, 0x17, 0x0E,
  0x80, 0xC2, 0xF0, 0x50, 0xE8, 0x0C, 0x2F, 0x05, 0x0C, 0x80, 0xC1, 0xF8, 0x17, 0x06, 0xFB, 0x06,
  0x50, 0x4B, 0x0C, 0x73, 0xD0, 0x73, 0x0C, 0xF9, 0x0C, 0x60, 0x7B, 0x09, 0x73, 0xC0, 0x74, 0x01,
  0x0C, 0xE0, 0xC0, 0x16, 0x0C, 0xB0, 0x67, 0x3B, 0x07, 0x78, 0x46, 0xBE, 0xEB, 0x67, 0x02, 0xC0,
  0x17, 0x3A, 0x07, 0x77, 0x70, 0xAB, 0x0B, 0x74, 0x00, 0x57, 0x77, 0x03, 0xC0, 0x47, 0x77, 0x75,
  0x01, 0x0D, 0xB0, 0xC7, 0x77, 0x76, 0x0B, 0xC0, 0x37, 0x77, 0x28, 0x46, 0xCE, 0xEC, 0x63, 0x01,
  0x0B, 0xC0, 0x97, 0x77, 0x10, 0x10, 0xCE, 0x82, 0xC1, 0x3D, 0xC0, 0xB7, 0x77, 0x20, 0xCF, 0x90,
  0xDD, 0x0C, 0x01, 0x77, 0x71, 0x06, 0xFF, 0x0B, 0x01, 0x77, 0x72, 0x0C, 0xFE, 0x08, 0x77, 0x74,
  0x0E, 0xFC, 0x0C, 0x03, 0x77, 0x75, 0x0E, 0xFB, 0x0E, 0x77, 0x77, 0x0B, 0xFB, 0x0C, 0x77, 0x77,
  0x06, 0xFB, 0x06, 0x77, 0x77, 0x10, 0xCF, 0x90, 0xC7, 0x77, 0x72, 0x01, 0x0C, 0xE0, 0xC0, 0x17,
  0x77, 0x74, 0x84, 0x6B, 0xEE, 0xC6, 0x77, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_mediation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_round_48_action_mediation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_minimize 48x48, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_round_48_action_minimize_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xF9, 0x00, 0xDF, 0xFF, 0x98, 0x1D, 0x4D, 0xFF, 0xE0,
  0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_minimize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 38, 35, 41), Box(0, 0, 47, 47),
      ic_round_48_action_minimize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_model_training 48x48, 4-bit Alpha,  RLE, 294 bytes.
static const unsigned char ic_round_48_action_model_training_data[] PROGMEM = {
  0x77, 0x40, 0x05, 0x77, 0x77, 0x6A, 0x07, 0x77, 0x77, 0x5B, 0x07, 0x77, 0x77, 0x4C, 0x07, 0x77,
  0x77, 0x3D, 0x07, 0x77, 0x73, 0x84, 0x15, 0x9B, 0xDE, 0xE0, 0x77, 0x77, 0x04, 0x0B, 0xFE, 0x05,
  0x77, 0x40, 0x30, 0xBF, 0xF9, 0x05, 0x77, 0x30, 0x8F, 0xFA, 0x07, 0x77, 0x20, 0x10, 0xBD, 0x82,
  0xB6, 0x31, 0x2D, 0x07, 0x77, 0x20, 0x10, 0xCC, 0x0B, 0x02, 0x6C, 0x07, 0x58, 0x26, 0xCA, 0x17,
  0x10, 0xBB, 0x0E, 0x05, 0x71, 0xB0, 0x75, 0x02, 0xB0, 0xB7, 0x08, 0xB0, 0xE0, 0x37, 0x2A, 0x07,
  0x60, 0x3C, 0x08, 0x50, 0x3C, 0x04, 0x73, 0x00, 0x57, 0x10, 0xAC, 0x04, 0x40, 0xBB, 0x09, 0x77,
  0x70, 0x10, 0xDB, 0x0C, 0x30, 0x4B, 0x0E, 0x01, 0x77, 0x71, 0x03, 0xC0, 0x42, 0x0B, 0xB0, 0x77,
  0x77, 0x30, 0xAB, 0x81, 0xB0, 0x1C, 0x01, 0x71, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x71, 0x02, 0xC0,
  0x10, 0x5B, 0x0B, 0x71, 0x05, 0x0E, 0xE0, 0xE0, 0x57, 0x10, 0xCB, 0x05, 0x09, 0xB0, 0x77, 0x05,
  0xFB, 0x05, 0x70, 0x7B, 0x09, 0x0B, 0xB0, 0x36, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x60, 0x3B, 0x0B,
  0x0D, 0xB0, 0x16, 0x07, 0xFD, 0x07, 0x60, 0x2B, 0x0D, 0x0E, 0xB7, 0x0C, 0xFD, 0x0C, 0x7B, 0x00,
  0xEB, 0x70, 0xEF, 0xD0, 0xE7, 0xB0, 0xE0, 0xDB, 0x01, 0x60, 0xEF, 0xD0, 0xE6, 0x01, 0xB0, 0xD0,
  0xCB, 0x03, 0x60, 0xBF, 0xD0, 0xB6, 0x03, 0xB0, 0xC0, 0x9B, 0x07, 0x60, 0x5F, 0xD0, 0x56, 0x07,
  0xB0, 0x90, 0x6B, 0x0B, 0x70, 0xCF, 0xB0, 0xB7, 0x0C, 0xB0, 0x60, 0x1C, 0x02, 0x60, 0x20, 0xEF,
  0x90, 0xE0, 0x26, 0x02, 0xC8, 0x11, 0x0B, 0xB0, 0x97, 0x06, 0xF9, 0x06, 0x70, 0xAB, 0x0B, 0x20,
  0x5C, 0x02, 0x70, 0xAE, 0x09, 0x70, 0x3C, 0x05, 0x30, 0xCB, 0x07, 0x70, 0x10, 0xDC, 0x0D, 0x71,
  0x07, 0xB0, 0xC4, 0x03, 0xB0, 0x47, 0x10, 0x6C, 0x06, 0x71, 0x04, 0xB0, 0x35, 0x81, 0x49, 0x57,
  0x20, 0x1C, 0x01, 0x72, 0x81, 0x48, 0x48, 0x09, 0xA7, 0x0C, 0x77, 0x77, 0x40, 0xDA, 0x0D, 0x77,
  0x77, 0x48, 0x24, 0xDD, 0x47, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_model_training() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_model_training_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_network_ping 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_48_action_network_ping_data[] PROGMEM = {
  0x77, 0x77, 0x48, 0x44, 0xBE, 0xEB, 0x43, 0x82, 0x6E, 0xC3, 0x77, 0x75, 0x08, 0xE8, 0x18, 0x01,
  0xB0, 0xE0, 0x37, 0x77, 0x30, 0x4F, 0x90, 0x40, 0x1C, 0x0E, 0x03, 0x77, 0x72, 0x0B, 0xF9, 0x81,
  0xB0, 0x7C, 0x0E, 0x03, 0x77, 0x71, 0x0E, 0xF9, 0x0E, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x70, 0xEF,
  0x90, 0xE3, 0x07, 0xC0, 0xE0, 0x37, 0x76, 0x0B, 0xF9, 0x0B, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x40,
  0x30, 0xEF, 0x90, 0x45, 0x07, 0xC0, 0xE0, 0x37, 0x72, 0x03, 0x0E, 0xF9, 0x08, 0x70, 0x7C, 0x0E,
  0x03, 0x77, 0x03, 0x0E, 0xC8, 0x3C, 0xEE, 0xB4, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x50, 0x30, 0xEC,
  0x07, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x73, 0x07, 0xC0, 0xE0, 0x37,
  0x10, 0x30, 0xEC, 0x07, 0x77, 0x50, 0x7C, 0x0E, 0x03, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x70, 0x7C,
  0x0E, 0x03, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x72, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC0, 0x77,
  0x77, 0x40, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x77, 0x77, 0x60, 0x7C, 0x00, 0xEC, 0x07, 0x77, 0x77,
  0x10, 0x7F, 0x90, 0x77, 0x77, 0x73, 0x07, 0xE0, 0x77, 0x76, 0x04, 0x0D, 0xFF, 0xFF, 0x0D, 0x04,
  0x71, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0x04, 0x0D, 0xFF, 0xFF,
  0x0D, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_network_ping() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 43, 35), Box(0, 0, 47, 47),
      ic_round_48_action_network_ping_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_new_label 48x48, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_round_48_action_new_label_data[] PROGMEM = {
  0x38, 0x11, 0xAD, 0xFF, 0xE8, 0x1E, 0xA2, 0x73, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x02, 0x72, 0x0A,
  0xFF, 0xFD, 0x0C, 0x72, 0x0D, 0xFF, 0xFE, 0x08, 0x71, 0xFF, 0xFF, 0x90, 0x47, 0xFF, 0xFF, 0x90,
  0xD0, 0x16, 0xFF, 0xFF, 0xA0, 0xA6, 0xFF, 0xFF, 0xB0, 0x65, 0xFF, 0xFF, 0xB0, 0xE0, 0x24, 0xFF,
  0xFF, 0xC0, 0xC7, 0x40, 0x30, 0x8F, 0xFF, 0xB0, 0x87, 0x50, 0x20, 0xDF, 0xFF, 0xA0, 0x37, 0x50,
  0x2F, 0xFF, 0xA0, 0xB7, 0x60, 0x8F, 0xFF, 0xA6, 0x82, 0x4D, 0xD4, 0x30, 0x3F, 0xFF, 0xA6, 0x0D,
  0xA0, 0xD4, 0xFF, 0xF9, 0x0B, 0x6C, 0x50, 0x30, 0x8F, 0xFD, 0x03, 0x6C, 0x70, 0x20, 0xDF, 0xFA,
  0x08, 0x7C, 0x71, 0x02, 0xFF, 0x90, 0xC7, 0x1C, 0x72, 0x08, 0xFE, 0x0E, 0x02, 0x20, 0x40, 0xDF,
  0xD0, 0xD0, 0x43, 0x03, 0xFE, 0x06, 0x30, 0xDF, 0xF0, 0xD4, 0xFD, 0x0A, 0x40, 0xDF, 0xF0, 0xD4,
  0xFC, 0x0D, 0x01, 0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0xFC, 0x04, 0x74, 0xC7, 0x3F, 0xB0, 0x87,
  0x5C, 0x73, 0xFA, 0x0C, 0x76, 0xC7, 0x3F, 0x90, 0xE0, 0x27, 0x6C, 0x73, 0xE8, 0x1E, 0xA2, 0x77,
  0x0D, 0xA0, 0xD7, 0x77, 0x75, 0x82, 0x4D, 0xD4, 0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_new_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 40, 39), Box(0, 0, 47, 47),
      ic_round_48_action_new_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_next_plan 48x48, 4-bit Alpha,  RLE, 273 bytes.
static const unsigned char ic_round_48_action_next_plan_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0x80, 0xC0, 0xF0, 0x82, 0x0D,
  0x80, 0xC0, 0xF8, 0x1D, 0x03, 0xFE, 0x82, 0xD7, 0x31, 0x28, 0x21, 0x38, 0xDF, 0x06, 0xF0, 0x30,
  0x7F, 0xC0, 0xD0, 0x47, 0x30, 0x50, 0xDC, 0x06, 0x1F, 0x07, 0x0A, 0xFB, 0x09, 0x38, 0x16, 0xAE,
  0xA8, 0x1D, 0xB5, 0x30, 0xAA, 0x06, 0x2F, 0x0A, 0x0C, 0xFA, 0x08, 0x20, 0x50, 0xEF, 0x90, 0xD0,
  0x52, 0x09, 0x06, 0x3F, 0x0C, 0x0E, 0xF9, 0x09, 0x20, 0x9F, 0xD0, 0x86, 0xF0, 0xEF, 0x90, 0xD2,
  0x09, 0xFF, 0x04, 0x5F, 0xFA, 0x81, 0x50, 0x5F, 0xF0, 0x66, 0xF9, 0x0E, 0xE0, 0xD2, 0x0D, 0xFE,
  0x06, 0x7F, 0x0E, 0x0C, 0xE8, 0x18, 0x05, 0xFE, 0x06, 0x71, 0xF0, 0xC0, 0xAE, 0x81, 0xD8, 0xBF,
  0xD0, 0x67, 0x2F, 0x0A, 0x07, 0x80, 0xC2, 0xF0, 0x70, 0x38, 0x0C, 0x2F, 0x81, 0x30, 0xD8, 0x0C,
  0x0F, 0x0D, 0x20, 0x88, 0x0C, 0x0F, 0x08, 0x20, 0x18, 0x0C, 0x0F, 0x01, 0x30, 0x9F, 0xFF, 0xFE,
  0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF,
  0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB,
  0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77,
  0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73,
  0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_next_plan() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_next_plan_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_nightlight_round 48x48, 4-bit Alpha,  RLE, 172 bytes.
static const unsigned char ic_round_48_action_nightlight_round_data[] PROGMEM = {
  0x77, 0x86, 0x16, 0xAB, 0xDE, 0xE7, 0x75, 0x07, 0x0D, 0xF0, 0xE7, 0x30, 0x80, 0xEF, 0xA0, 0xB7,
  0x10, 0x30, 0xDF, 0xB0, 0xA7, 0x10, 0x8F, 0xC0, 0x67, 0x10, 0xAF, 0xC0, 0x47, 0x10, 0xAF, 0xC0,
  0x47, 0x10, 0x8F, 0xC0, 0x67, 0x10, 0x4F, 0xC0, 0xA7, 0x10, 0x10, 0xDF, 0xB0, 0xE0, 0x17, 0x10,
  0x9F, 0xC0, 0x67, 0x10, 0x10, 0xEF, 0xB0, 0xD7, 0x20, 0x7F, 0xC0, 0x77, 0x20, 0xEF, 0xC0, 0x17,
  0x10, 0x2F, 0xC0, 0xC7, 0x20, 0x6F, 0xC0, 0x87, 0x20, 0xAF, 0xC0, 0x57, 0x20, 0xCF, 0xC0, 0x27,
  0x20, 0xEF, 0xC0, 0x17, 0x2F, 0xD7, 0x3F, 0xD7, 0x30, 0xEF, 0xC0, 0x17, 0x20, 0xCF, 0xC0, 0x27,
  0x20, 0xAF, 0xC0, 0x57, 0x20, 0x7F, 0xC0, 0x87, 0x20, 0x3F, 0xC0, 0xB7, 0x30, 0xDF, 0xC0, 0x17,
  0x20, 0x8F, 0xC0, 0x67, 0x20, 0x1F, 0xC0, 0xD7, 0x30, 0x9F, 0xC0, 0x67, 0x20, 0x10, 0xEF, 0xB0,
  0xE0, 0x17, 0x20, 0x5F, 0xC0, 0x97, 0x30, 0x9F, 0xC0, 0x67, 0x30, 0xAF, 0xC0, 0x47, 0x30, 0xBF,
  0xB0, 0xE0, 0x47, 0x30, 0x9F, 0xC0, 0x67, 0x30, 0x50, 0xEF, 0xB0, 0xA7, 0x30, 0x10, 0x8F, 0xB0,
  0xB7, 0x48, 0x11, 0x7D, 0xF0, 0xE7, 0x78, 0x63, 0x7A, 0xCD, 0xFE, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_nightlight_round() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(11, 4, 32, 43), Box(0, 0, 47, 47),
      ic_round_48_action_nightlight_round_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_no_accounts 48x48, 4-bit Alpha,  RLE, 378 bytes.
static const unsigned char ic_round_48_action_no_accounts_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xE8, 0x3E, 0xA6, 0x31, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x76, 0x0A, 0xD0, 0xD0, 0x67, 0x50,
  0x60, 0xDD, 0x0A, 0x74, 0x0A, 0xD0, 0x87, 0x72, 0x07, 0xD0, 0xA7, 0x20, 0x9D, 0x07, 0x77, 0x40,
  0x30, 0xDC, 0x09, 0x70, 0x5F, 0x05, 0x58, 0x55, 0xCE, 0xEC, 0x71, 0x60, 0x10, 0xCC, 0x05, 0x50,
  0x10, 0xEF, 0x90, 0x54, 0x02, 0x0D, 0xC0, 0xE0, 0x56, 0x01, 0x0D, 0xB0, 0xE0, 0x14, 0x09, 0xC0,
  0x7D, 0x05, 0x40, 0x20, 0xDD, 0x05, 0x60, 0x3C, 0x09, 0x30, 0x1C, 0x81, 0x80, 0x5D, 0x05, 0x40,
  0x20, 0xDC, 0x0E, 0x01, 0x60, 0x7C, 0x01, 0x20, 0x8B, 0x0D, 0x30, 0x5D, 0x05, 0x40, 0x20, 0xDC,
  0x07, 0x70, 0xDB, 0x08, 0x20, 0xDB, 0x06, 0x40, 0x5D, 0x05, 0x40, 0x20, 0xDB, 0x0C, 0x70, 0x6B,
  0x81, 0xD0, 0x3B, 0x0E, 0x60, 0x5D, 0x05, 0x40, 0x20, 0xDA, 0x0E, 0x71, 0xC0, 0x30, 0x7B, 0x0A,
  0x70, 0x5D, 0x05, 0x48, 0x22, 0xDF, 0xE7, 0x10, 0xBB, 0x07, 0x0A, 0xB0, 0x67, 0x10, 0xBD, 0x05,
  0x48, 0x12, 0xDC, 0x71, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x71, 0x07, 0xE0, 0x54, 0x02, 0x05, 0x71,
  0x03, 0xB0, 0xC0, 0xEB, 0x01, 0x71, 0x01, 0x0E, 0xE0, 0x57, 0x60, 0x2B, 0x0E, 0xC7, 0x30, 0x4F,
  0x05, 0x76, 0xF9, 0x74, 0x04, 0x0E, 0xE0, 0x57, 0x5C, 0x0E, 0xB0, 0x27, 0x48, 0x11, 0x7C, 0xD0,
  0x57, 0x30, 0x1B, 0x0E, 0x0C, 0xB0, 0x37, 0x70, 0x5D, 0x05, 0x72, 0x03, 0xB0, 0xC0, 0xAB, 0x06,
  0x77, 0x10, 0x5D, 0x05, 0x71, 0x06, 0xB0, 0xA0, 0x7B, 0x0A, 0x77, 0x20, 0x5D, 0x05, 0x70, 0xAB,
  0x07, 0x03, 0xB0, 0xE7, 0x73, 0x05, 0xD0, 0x56, 0x0E, 0xB8, 0x13, 0x0D, 0xB0, 0x67, 0x18, 0x90,
  0x26, 0xAB, 0xDE, 0xED, 0xBE, 0xD0, 0x54, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xD5, 0x81, 0x17, 0xDF,
  0xFA, 0x05, 0x30, 0xDB, 0x08, 0x20, 0x1C, 0x07, 0x30, 0x80, 0xEF, 0xFD, 0x81, 0x50, 0x8C, 0x01,
  0x30, 0x9C, 0x81, 0x34, 0xDF, 0xFF, 0x90, 0x7C, 0x09, 0x40, 0x10, 0xEB, 0x0E, 0xFF, 0xFF, 0x0E,
  0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A,
  0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E,
  0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17,
  0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_no_accounts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_no_accounts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_noise_aware 48x48, 4-bit Alpha,  RLE, 365 bytes.
static const unsigned char ic_round_48_action_noise_aware_data[] PROGMEM = {
  0x77, 0x48, 0x24, 0xDD, 0x47, 0x77, 0x71, 0x01, 0x02, 0x50, 0xDA, 0x0D, 0x50, 0x27, 0x77, 0x18,
  0x24, 0xEF, 0x94, 0x0D, 0xA0, 0xD4, 0x82, 0xAF, 0xE4, 0x77, 0x60, 0xBB, 0x01, 0x38, 0x24, 0xDD,
  0x43, 0x02, 0xB0, 0xB7, 0x76, 0x09, 0xA0, 0xE7, 0x50, 0xEA, 0x09, 0x77, 0x68, 0x21, 0x9A, 0x37,
  0x58, 0x23, 0xA9, 0x17, 0x71, 0x02, 0x01, 0x77, 0x75, 0x01, 0x02, 0x72, 0x08, 0xA0, 0x67, 0x77,
  0x30, 0x6A, 0x08, 0x71, 0xB0, 0xD7, 0x86, 0x39, 0xCE, 0xEC, 0x93, 0x72, 0x0D, 0xB7, 0x10, 0xDA,
  0x0B, 0x50, 0x20, 0xBF, 0x90, 0xB0, 0x17, 0x0B, 0xA0, 0xD7, 0x18, 0x22, 0xA9, 0x14, 0x03, 0x0E,
  0xFB, 0x0D, 0x03, 0x68, 0x21, 0x9A, 0x27, 0x71, 0x02, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x73, 0x0B,
  0xC8, 0x4A, 0x30, 0x14, 0xBC, 0x0A, 0x77, 0x72, 0x03, 0xC0, 0x76, 0x07, 0xC0, 0x27, 0x68, 0x1A,
  0xF9, 0x60, 0x9B, 0x0A, 0x71, 0x0B, 0xB0, 0x27, 0x18, 0x39, 0xFA, 0x06, 0xB0, 0x55, 0x0C, 0xB0,
  0x37, 0x18, 0x21, 0xBE, 0x77, 0x10, 0x5B, 0x00, 0x6B, 0x05, 0x50, 0xEB, 0x77, 0x70, 0x5B, 0x83,
  0x60, 0xAF, 0x96, 0x0E, 0xB7, 0x77, 0x18, 0x19, 0xFA, 0x74, 0x0C, 0xB0, 0x36, 0x82, 0x8D, 0xD8,
  0x77, 0x74, 0x09, 0xB0, 0xA5, 0x08, 0xC0, 0x87, 0x77, 0x30, 0x4C, 0x05, 0x40, 0xDC, 0x0D, 0x77,
  0x74, 0x0C, 0xC0, 0x53, 0x0D, 0xC0, 0xD7, 0x71, 0x81, 0xAF, 0x97, 0x02, 0xD0, 0x52, 0x08, 0xC0,
  0x87, 0x38, 0x39, 0xFA, 0x06, 0xB0, 0x57, 0x05, 0xD0, 0x42, 0x82, 0x8D, 0xD8, 0x73, 0x05, 0xB0,
  0x06, 0xB0, 0x57, 0x10, 0x5C, 0x0E, 0x01, 0x77, 0x10, 0x5B, 0x83, 0x60, 0xBF, 0x97, 0x30, 0x5C,
  0x09, 0x77, 0x28, 0x19, 0xFA, 0x77, 0x20, 0x6C, 0x01, 0x38, 0x1A, 0xE9, 0x77, 0x77, 0x10, 0xDB,
  0x82, 0xA1, 0x2A, 0xB0, 0x57, 0x77, 0x70, 0x5F, 0xB0, 0x57, 0x72, 0x82, 0x2A, 0xA1, 0x72, 0x0B,
  0xF9, 0x0B, 0x58, 0x21, 0x9A, 0x27, 0x10, 0xDA, 0x0B, 0x73, 0x0B, 0xE0, 0xC0, 0x15, 0x0B, 0xA0,
  0xD7, 0x1B, 0x0D, 0x74, 0x84, 0x6B, 0xFE, 0xB6, 0x70, 0xDB, 0x71, 0x08, 0xA0, 0x67, 0x77, 0x30,
  0x6A, 0x08, 0x72, 0x02, 0x01, 0x77, 0x75, 0x01, 0x02, 0x77, 0x18, 0x21, 0x9A, 0x37, 0x58, 0x23,
  0xA9, 0x17, 0x76, 0x09, 0xA0, 0xE7, 0x50, 0xEA, 0x09, 0x77, 0x60, 0xBB, 0x02, 0x38, 0x24, 0xDD,
  0x43, 0x02, 0xB0, 0xB7, 0x76, 0x82, 0x4E, 0xFA, 0x40, 0xDA, 0x0D, 0x48, 0x29, 0xFE, 0x47, 0x77,
  0x10, 0x25, 0x0D, 0xA0, 0xD5, 0x02, 0x77, 0x77, 0x28, 0x24, 0xDD, 0x47, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_noise_aware() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_noise_aware_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_noise_control_off 48x48, 4-bit Alpha,  RLE, 355 bytes.
static const unsigned char ic_round_48_action_noise_control_off_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD7,
  0x17, 0x77, 0x02, 0x0E, 0xFF, 0xA0, 0xE0, 0x27, 0x76, 0x07, 0xFF, 0xC0, 0x77, 0x76, 0x04, 0xB8,
  0x3E, 0xA6, 0x31, 0x28, 0x31, 0x36, 0xAE, 0xB0, 0x47, 0x77, 0x81, 0x59, 0x57, 0x58, 0x16, 0x95,
  0x80, 0x9C, 0x60, 0x86, 0x39, 0xCE, 0xEC, 0x93, 0x77, 0x77, 0x20, 0x20, 0xBF, 0x90, 0xB0, 0x17,
  0x73, 0x81, 0x27, 0x47, 0x03, 0x0E, 0xFB, 0x0D, 0x03, 0x72, 0x81, 0x47, 0x23, 0x01, 0x0E, 0xA0,
  0x55, 0x02, 0x0E, 0xFD, 0x0E, 0x01, 0x70, 0x5A, 0x0E, 0x01, 0x20, 0x7B, 0x09, 0x50, 0xBC, 0x84,
  0xA3, 0x01, 0x4B, 0xC0, 0xA7, 0x09, 0xB0, 0x72, 0x0D, 0xB0, 0x64, 0x03, 0xC0, 0x76, 0x07, 0xC0,
  0x26, 0x05, 0xB8, 0x1D, 0x03, 0xB0, 0xE5, 0x09, 0xB0, 0xA7, 0x10, 0xBB, 0x02, 0x70, 0xEB, 0x03,
  0x07, 0xB0, 0xA5, 0x0C, 0xB0, 0x37, 0x18, 0x21, 0xBE, 0x77, 0x10, 0xAB, 0x07, 0x0A, 0xB0, 0x65,
  0x0E, 0xB7, 0x77, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x50, 0xEB, 0x77, 0x70, 0x3B, 0x0C, 0x0E, 0xB0,
  0x15, 0x0C, 0xB0, 0x36, 0x82, 0x8D, 0xD8, 0x73, 0x01, 0xB0, 0xEC, 0x60, 0x9B, 0x0A, 0x50, 0x8C,
  0x08, 0x73, 0xF9, 0x60, 0x4C, 0x05, 0x40, 0xDC, 0x0D, 0x73, 0xC0, 0xEB, 0x01, 0x60, 0xCC, 0x05,
  0x30, 0xDC, 0x0D, 0x72, 0x01, 0xB0, 0xE0, 0xCB, 0x03, 0x60, 0x2D, 0x05, 0x20, 0x8C, 0x08, 0x72,
  0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x70, 0x5D, 0x04, 0x28, 0x28, 0xDD, 0x87, 0x30, 0x6B, 0x0A, 0x07,
  0xB0, 0xA7, 0x10, 0x5C, 0x0E, 0x01, 0x77, 0x10, 0xAB, 0x07, 0x03, 0xB0, 0xE7, 0x20, 0x5C, 0x09,
  0x77, 0x10, 0xEB, 0x81, 0x30, 0xDB, 0x05, 0x72, 0x06, 0xC0, 0x13, 0x81, 0xAD, 0x87, 0x06, 0xB0,
  0xD2, 0x07, 0xB0, 0x97, 0x30, 0xDB, 0x82, 0xA1, 0x2B, 0xB0, 0x56, 0x09, 0xB0, 0x72, 0x01, 0x0E,
  0xA0, 0x57, 0x30, 0x5F, 0xB0, 0x56, 0x05, 0xA0, 0xE0, 0x13, 0x81, 0x27, 0x47, 0x50, 0xBF, 0x90,
  0xC7, 0x18, 0x14, 0x72, 0x77, 0x60, 0xBE, 0x0C, 0x01, 0x77, 0x77, 0x48, 0x46, 0xBF, 0xEC, 0x68,
  0x09, 0xC6, 0x08, 0x15, 0x96, 0x75, 0x81, 0x59, 0x57, 0x77, 0x04, 0xB8, 0x3E, 0xA6, 0x31, 0x28,
  0x31, 0x36, 0xAE, 0xB0, 0x47, 0x76, 0x07, 0xFF, 0xC0, 0x77, 0x76, 0x02, 0x0E, 0xFF, 0xA0, 0xE0,
  0x27, 0x77, 0x81, 0x17, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC,
  0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_noise_control_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_noise_control_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_not_accessible 48x48, 4-bit Alpha,  RLE, 348 bytes.
static const unsigned char ic_round_48_action_not_accessible_data[] PROGMEM = {
  0x77, 0x48, 0x41, 0xAD, 0xDA, 0x17, 0x77, 0x74, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x71, 0x81, 0x27,
  0x47, 0x60, 0xAE, 0x0A, 0x77, 0x02, 0x0E, 0xA0, 0x77, 0x50, 0xDE, 0x0D, 0x77, 0x05, 0xC0, 0x77,
  0x40, 0xDE, 0x0D, 0x77, 0x01, 0x0E, 0xC0, 0x77, 0x30, 0xAE, 0x0A, 0x77, 0x10, 0x30, 0xEC, 0x07,
  0x72, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x28, 0x41, 0xAD, 0xDA, 0x17,
  0x74, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x75, 0x03, 0x0E, 0xC0,
  0x76, 0x84, 0x19, 0xED, 0x92, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x50, 0x8C, 0x0E, 0x04, 0x77, 0x70,
  0x30, 0xEC, 0x07, 0x50, 0x9C, 0x0E, 0x03, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x50, 0x9C, 0x0E, 0x02,
  0x77, 0x70, 0x30, 0xEC, 0x07, 0x50, 0x9C, 0x0D, 0x02, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x50, 0x9C,
  0x0E, 0x03, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x50, 0x9D, 0x08, 0x01, 0x77, 0x60, 0x30, 0xEC, 0x07,
  0x50, 0x9E, 0x81, 0x95, 0x17, 0x74, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0xF9, 0x06, 0x77, 0x40, 0x30,
  0xEC, 0x07, 0x50, 0x30, 0xBE, 0x0E, 0x77, 0x38, 0x25, 0xA3, 0xEC, 0x07, 0x60, 0x40, 0xBC, 0x0C,
  0x77, 0x10, 0x50, 0xDA, 0x10, 0x3D, 0x07, 0x78, 0x32, 0x6A, 0xA2, 0x77, 0x08, 0xC2, 0xE0, 0x77,
  0x77, 0x30, 0x8D, 0x2F, 0x07, 0x77, 0x71, 0x04, 0xD0, 0x92, 0xF9, 0x07, 0x77, 0x70, 0xDB, 0x0E,
  0x03, 0x3F, 0xA0, 0x77, 0x75, 0x05, 0xC0, 0x34, 0x0D, 0xFA, 0x07, 0x77, 0x40, 0xAB, 0x09, 0x50,
  0xAF, 0xB0, 0x77, 0x73, 0x0D, 0xB0, 0x35, 0x01, 0x0E, 0xFB, 0x07, 0x77, 0x20, 0xEB, 0x01, 0x68,
  0x11, 0xAD, 0xFA, 0x07, 0x77, 0x10, 0xEB, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x70, 0xDB, 0x03, 0x77,
  0x03, 0x0E, 0xC0, 0x77, 0x60, 0x9B, 0x08, 0x73, 0x09, 0xB8, 0x1A, 0x3E, 0xC0, 0x77, 0x50, 0x5C,
  0x02, 0x71, 0x03, 0xC8, 0x25, 0x03, 0xEC, 0x07, 0x75, 0x0D, 0xB0, 0xD0, 0x26, 0x03, 0x0E, 0xB0,
  0xD3, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x4D, 0x84, 0x83, 0x01, 0x39, 0xD0, 0x54, 0x03, 0x0E, 0xC0,
  0x77, 0x40, 0x8F, 0xF0, 0x86, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x8F, 0xD0, 0x87, 0x10, 0x30, 0xEC,
  0x04, 0x74, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x03, 0x0E, 0xB0, 0x77, 0x68, 0x65, 0x9D, 0xEE,
  0xD9, 0x57, 0x68, 0x33, 0xEF, 0xE2, 0x77, 0x77, 0x78, 0x11, 0x51, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_not_accessible() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 41, 44), Box(0, 0, 47, 47),
      ic_round_48_action_not_accessible_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_note_add 48x48, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_round_48_action_note_add_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x0A, 0xFF, 0xF0,
  0x77, 0x20, 0xDF, 0xFB, 0x07, 0xC0, 0x77, 0x1F, 0xFC, 0x10, 0x7C, 0x07, 0x7F, 0xFC, 0x20, 0x7C,
  0x07, 0x6F, 0xFC, 0x30, 0x7C, 0x07, 0x5F, 0xFC, 0x40, 0x7C, 0x07, 0x4F, 0xFC, 0x50, 0x7C, 0x07,
  0x3F, 0xFC, 0x60, 0x7C, 0x07, 0x2F, 0xFC, 0x70, 0x7C, 0x07, 0x1F, 0xFC, 0x71, 0x07, 0xC0, 0x4F,
  0xFC, 0x01, 0x71, 0x07, 0xB0, 0xBF, 0xFC, 0x0B, 0x01, 0x71, 0x07, 0xA0, 0xE8, 0x0A, 0x92, 0xF8,
  0x2B, 0x11, 0xBF, 0xFF, 0xF0, 0x12, 0x01, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF,
  0xF4, 0xFF, 0xF9, 0x0B, 0x01, 0x75, 0x01, 0x0B, 0xFF, 0xA0, 0x17, 0x70, 0x1F, 0xFA, 0x01, 0x77,
  0x01, 0xFF, 0xA0, 0xB0, 0x17, 0x50, 0x10, 0xBF, 0xFF, 0x94, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF,
  0xFF, 0x4F, 0xFF, 0xF0, 0x12, 0x01, 0xFF, 0xFF, 0x82, 0xB1, 0x1B, 0x80, 0x99, 0x2F, 0x0D, 0xFF,
  0xFF, 0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xEF, 0xFF,
  0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_note_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_note_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_not_started 48x48, 4-bit Alpha,  RLE, 264 bytes.
static const unsigned char ic_round_48_action_not_started_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0xFD, 0x82, 0xB1, 0x1B, 0xFF,
  0xE0, 0x82, 0x0D, 0xFD, 0x01, 0x20, 0x1F, 0xFE, 0x81, 0xD0, 0x3F, 0xE4, 0xA8, 0x2D, 0x44, 0xCF,
  0xF9, 0x03, 0x07, 0xFE, 0x4A, 0x03, 0x30, 0x9F, 0xF0, 0x70, 0xAF, 0xE4, 0xA5, 0x06, 0xFE, 0x0A,
  0x0C, 0xFE, 0x4A, 0x60, 0x30, 0xDF, 0xC0, 0xC0, 0xEF, 0xE4, 0xA7, 0x01, 0x0D, 0xFB, 0x0E, 0xFF,
  0x4A, 0x71, 0x05, 0xFF, 0xFC, 0x4A, 0x71, 0x05, 0xFC, 0x0E, 0xFE, 0x4A, 0x70, 0x10, 0xDF, 0xB0,
  0xE0, 0xCF, 0xE4, 0xA6, 0x03, 0x0D, 0xFC, 0x0C, 0x0A, 0xFE, 0x4A, 0x50, 0x6F, 0xE0, 0xA0, 0x7F,
  0xE4, 0xA0, 0x23, 0x09, 0xFF, 0x07, 0x03, 0xFE, 0x4A, 0x82, 0xD4, 0x4C, 0xFF, 0x98, 0x13, 0x0D,
  0xFD, 0x01, 0x20, 0x1F, 0xFE, 0x0D, 0x20, 0x8F, 0xD8, 0x2B, 0x11, 0xBF, 0xFE, 0x08, 0x20, 0x18,
  0x0C, 0x0F, 0x01, 0x30, 0x9F, 0xFF, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50,
  0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A,
  0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77,
  0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48,
  0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_not_started() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_not_started_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_offline_bolt 48x48, 4-bit Alpha,  RLE, 282 bytes.
static const unsigned char ic_round_48_action_offline_bolt_data[] PROGMEM = {
  0x77, 0x89, 0x22, 0x69, 0xCD, 0xEE, 0xDC, 0x96, 0x27, 0x77, 0x48, 0x11, 0x7D, 0xFD, 0x81, 0xD7,
  0x17, 0x77, 0x08, 0x0E, 0xFF, 0xA0, 0xE0, 0x87, 0x74, 0x04, 0x0D, 0xFF, 0xE0, 0xD0, 0x47, 0x71,
  0x08, 0xFF, 0xFB, 0x08, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x08,
  0xFF, 0x90, 0x06, 0xFE, 0x08, 0x70, 0x4F, 0xF9, 0x0A, 0x2F, 0xF0, 0x46, 0x0D, 0xFF, 0x90, 0x22,
  0xFF, 0x0D, 0x50, 0x8F, 0xF9, 0x0A, 0x3F, 0xF9, 0x08, 0x30, 0x10, 0xEF, 0xF9, 0x02, 0x3F, 0xF9,
  0x0E, 0x01, 0x20, 0x7F, 0xF9, 0x09, 0x4F, 0xFA, 0x07, 0x20, 0xDF, 0xF9, 0x02, 0x4F, 0xFA, 0x81,
  0xD0, 0x2F, 0xF9, 0x09, 0x5F, 0xFB, 0x02, 0x06, 0xFF, 0x90, 0x15, 0xFF, 0xB0, 0x60, 0x9F, 0xF0,
  0x96, 0x80, 0x17, 0x0A, 0xFC, 0x09, 0x0C, 0xFF, 0x01, 0x75, 0xFC, 0x0C, 0x0D, 0xFE, 0x08, 0x75,
  0x04, 0xFC, 0x0D, 0x0E, 0xFD, 0x0E, 0x01, 0x75, 0x0C, 0xFC, 0x00, 0xEF, 0xD0, 0x87, 0x50, 0x4F,
  0xD0, 0xE0, 0xDF, 0xC0, 0xE0, 0x17, 0x50, 0xCF, 0xD0, 0xD0, 0xCF, 0xC0, 0xB7, 0x50, 0x4F, 0xE0,
  0xC0, 0x9F, 0xD0, 0x88, 0x01, 0x76, 0x0C, 0xFE, 0x09, 0x06, 0xFF, 0xB0, 0xE5, 0x04, 0xFF, 0x06,
  0x02, 0xFF, 0xB0, 0xE5, 0x0C, 0xFF, 0x81, 0x20, 0xDF, 0xFA, 0x0E, 0x40, 0x4F, 0xF0, 0xD2, 0x07,
  0xFF, 0xA0, 0xE4, 0x0C, 0xFF, 0x07, 0x20, 0x10, 0xEF, 0xF9, 0x0E, 0x30, 0x4F, 0xF0, 0xE0, 0x13,
  0x08, 0xFF, 0x90, 0xE3, 0x0C, 0xFF, 0x08, 0x50, 0xDF, 0xF0, 0xE2, 0x04, 0xFF, 0x0D, 0x60, 0x4F,
  0xF9, 0x20, 0xCF, 0xF0, 0x47, 0x08, 0xFF, 0x00, 0x7F, 0xF0, 0x87, 0x20, 0xAF, 0xFF, 0xF0, 0xA7,
  0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x8F, 0xFF, 0xB0, 0x87, 0x71, 0x04, 0x0D, 0xFF, 0xE0, 0xD0,
  0x47, 0x74, 0x08, 0x0E, 0xFF, 0xA0, 0xE0, 0x87, 0x77, 0x81, 0x17, 0xDF, 0xD8, 0x1D, 0x71, 0x77,
  0x74, 0x89, 0x22, 0x69, 0xCD, 0xEE, 0xDC, 0x96, 0x27, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_offline_bolt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_offline_bolt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_offline_pin 48x48, 4-bit Alpha,  RLE, 293 bytes.
static const unsigned char ic_round_48_action_offline_pin_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x08, 0xFF, 0xC0, 0x80, 0x17, 0x73, 0x04, 0x0E, 0xFF, 0xE0, 0xE0, 0x47, 0x71,
  0x08, 0xFF, 0xFB, 0x08, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x08,
  0xFF, 0xFF, 0xA0, 0x87, 0x04, 0xFF, 0xF9, 0x0C, 0x0A, 0xF9, 0x04, 0x50, 0x10, 0xEF, 0xFF, 0x07,
  0x20, 0x3F, 0x0E, 0x01, 0x40, 0x8F, 0xFF, 0x07, 0x40, 0xDF, 0x08, 0x30, 0x1F, 0xFF, 0x07, 0x40,
  0x1F, 0xA0, 0x12, 0x07, 0xFF, 0xE0, 0x74, 0x01, 0x0C, 0xFA, 0x07, 0x20, 0xDF, 0xFD, 0x07, 0x40,
  0x10, 0xCF, 0xB8, 0x1D, 0x03, 0xFF, 0xD0, 0x74, 0x01, 0x0C, 0xFD, 0x03, 0x07, 0xFB, 0x81, 0xD7,
  0x9D, 0x07, 0x40, 0x10, 0xCF, 0xE0, 0x70, 0xAF, 0xB0, 0x12, 0x04, 0xB0, 0x74, 0x01, 0x0C, 0xFF,
  0x0A, 0x0C, 0xFA, 0x0D, 0x48, 0x14, 0xF7, 0x40, 0x10, 0xCF, 0xF9, 0x0C, 0x0E, 0xFB, 0x03, 0x40,
  0x24, 0x01, 0x0C, 0xFF, 0xA0, 0xEF, 0xC0, 0xE0, 0x27, 0x01, 0x0C, 0xFF, 0xFF, 0xA0, 0xE0, 0x25,
  0x01, 0x0C, 0xFF, 0xD0, 0xEF, 0xD0, 0xE0, 0x23, 0x01, 0x0C, 0xFF, 0xD0, 0xE0, 0xCF, 0xE8, 0x3E,
  0x30, 0x1C, 0xFF, 0xE0, 0xC0, 0xAF, 0xF9, 0x0D, 0xFF, 0xF9, 0x0A, 0x07, 0x80, 0xC2, 0xF0, 0x70,
  0x38, 0x0C, 0x2F, 0x81, 0x30, 0xD8, 0x0C, 0x0F, 0x0D, 0x20, 0x78, 0x0C, 0x0F, 0x07, 0x20, 0x1F,
  0x90, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xF9, 0x01, 0x30, 0x8F, 0x01, 0x77, 0x40, 0x1F, 0x08, 0x40,
  0x10, 0xEE, 0x01, 0x77, 0x40, 0x1E, 0x0E, 0x01, 0x50, 0x4E, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBE,
  0x04, 0x70, 0x8F, 0xFF, 0xFA, 0x08, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A,
  0x76, 0x08, 0xFF, 0xFB, 0x08, 0x77, 0x10, 0x40, 0xEF, 0xFE, 0x0E, 0x04, 0x77, 0x30, 0x10, 0x8F,
  0xFC, 0x08, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD,
  0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_offline_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_offline_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_on_device_training 48x48, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_round_48_action_on_device_training_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x84, 0xD9, 0x10, 0x1E, 0xFF, 0xFF, 0x81, 0xE1, 0xAF, 0xFF, 0xFA,
  0x0A, 0x0D, 0xFF, 0xFF, 0xA0, 0xD8, 0x0B, 0x80, 0xF7, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x50,
  0xB0, 0x37, 0x3F, 0x97, 0x59, 0x0E, 0x04, 0x72, 0xF9, 0x71, 0x82, 0x59, 0xDE, 0xB0, 0x57, 0x1F,
  0x96, 0x04, 0x0D, 0xF9, 0x01, 0x7F, 0x95, 0x08, 0xFA, 0x06, 0x71, 0xF9, 0x40, 0x8B, 0x85, 0xE7,
  0x20, 0xFE, 0x47, 0x2F, 0x93, 0x04, 0xB0, 0xA4, 0x0B, 0x03, 0x73, 0xF9, 0x30, 0xDA, 0x0A, 0x74,
  0x81, 0x4E, 0xA3, 0xF9, 0x20, 0x5A, 0x0E, 0x38, 0x42, 0xAE, 0xEA, 0x23, 0x0A, 0xA0, 0x42, 0xF9,
  0x20, 0x9A, 0x07, 0x20, 0x20, 0xEC, 0x0E, 0x02, 0x20, 0x8A, 0x09, 0x2F, 0x92, 0x0D, 0xA0, 0x22,
  0x0A, 0xE0, 0xA2, 0x03, 0xA0, 0xC2, 0xF9, 0x20, 0xEA, 0x30, 0xEE, 0x0E, 0x20, 0x1A, 0x0E, 0x2F,
  0x92, 0x0E, 0xA3, 0x0E, 0xE0, 0xE2, 0x01, 0xA0, 0xE2, 0xF9, 0x20, 0xCA, 0x03, 0x20, 0xAE, 0x0A,
  0x20, 0x3A, 0x0C, 0x2F, 0x92, 0x09, 0xA0, 0x72, 0x01, 0x0E, 0xC0, 0xE0, 0x22, 0x08, 0xA0, 0x92,
  0xF9, 0x20, 0x4A, 0x0A, 0x30, 0x1C, 0x01, 0x30, 0xAA, 0x04, 0x2F, 0x93, 0x81, 0xAE, 0x44, 0x0E,
  0xA0, 0xE4, 0x81, 0x4D, 0xA3, 0xF9, 0x77, 0x73, 0xF9, 0x73, 0x0B, 0xA0, 0xB7, 0x3F, 0x97, 0x30,
  0xBA, 0x0B, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0x80, 0xB8, 0x0F, 0x0D, 0xFF, 0xFF, 0xA0,
  0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_on_device_training() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 45), Box(0, 0, 47, 47),
      ic_round_48_action_on_device_training_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_online_prediction 48x48, 4-bit Alpha,  RLE, 370 bytes.
static const unsigned char ic_round_48_action_online_prediction_data[] PROGMEM = {
  0x50, 0x50, 0x47, 0x77, 0x50, 0x40, 0x57, 0x20, 0x8A, 0x04, 0x77, 0x73, 0x03, 0xA0, 0x87, 0x04,
  0xB0, 0x47, 0x77, 0x30, 0x4B, 0x04, 0x50, 0x10, 0xEA, 0x0A, 0x77, 0x75, 0x0A, 0xA0, 0xD0, 0x14,
  0x08, 0xA0, 0xD0, 0x13, 0x01, 0x77, 0x40, 0x13, 0x01, 0x0E, 0xA0, 0x83, 0x01, 0x0E, 0xA0, 0x42,
  0x82, 0x2E, 0xF5, 0x77, 0x28, 0x25, 0xFE, 0x22, 0x04, 0xA0, 0xE0, 0x12, 0x07, 0xA0, 0xC3, 0x0B,
  0xA0, 0x94, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x40, 0x9A, 0x0B, 0x30, 0xCA, 0x07, 0x20, 0xDA, 0x05,
  0x20, 0x5B, 0x02, 0x30, 0x50, 0xEE, 0x0E, 0x05, 0x30, 0x3B, 0x05, 0x20, 0x5A, 0x81, 0xD0, 0x2A,
  0x0E, 0x30, 0xCA, 0x07, 0x30, 0x5F, 0xB0, 0x53, 0x07, 0xA0, 0xC3, 0x0E, 0xA0, 0x20, 0x6A, 0x0A,
  0x20, 0x3A, 0x0E, 0x30, 0x10, 0xEF, 0xB0, 0xE0, 0x13, 0x0E, 0xA0, 0x32, 0x0A, 0xA0, 0x60, 0xAA,
  0x06, 0x20, 0x7A, 0x09, 0x30, 0x7F, 0xD0, 0x73, 0x09, 0xA0, 0x72, 0x06, 0xA0, 0xA0, 0xBA, 0x03,
  0x20, 0xBA, 0x05, 0x30, 0xCF, 0xD0, 0xC3, 0x05, 0xA0, 0xB2, 0x03, 0xA0, 0xB0, 0xDA, 0x02, 0x20,
  0xDA, 0x02, 0x30, 0xEF, 0xD0, 0xE3, 0x02, 0xA0, 0xD2, 0x02, 0xA0, 0xD0, 0xEA, 0x30, 0xEA, 0x40,
  0xEF, 0xD0, 0xE4, 0xA0, 0xE3, 0xA0, 0x0E, 0xA3, 0x0E, 0xA4, 0x0B, 0xFD, 0x0B, 0x4A, 0x0E, 0x3A,
  0x0E, 0x0D, 0xA0, 0x22, 0x0D, 0xA0, 0x23, 0x05, 0xFD, 0x05, 0x30, 0x2A, 0x0D, 0x20, 0x2A, 0x0D,
  0x0B, 0xA0, 0x32, 0x0B, 0xA0, 0x54, 0x0C, 0xFB, 0x0B, 0x40, 0x5A, 0x0B, 0x20, 0x3A, 0x0B, 0x0A,
  0xA0, 0x62, 0x07, 0xA0, 0x94, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x40, 0x9A, 0x07, 0x20, 0x6A, 0x0A,
  0x06, 0xA0, 0xA2, 0x03, 0xA0, 0xE5, 0x06, 0xF9, 0x06, 0x50, 0xEA, 0x03, 0x20, 0xAA, 0x06, 0x02,
  0xA0, 0xE3, 0x0C, 0xA0, 0x75, 0x0A, 0xE0, 0x95, 0x07, 0xA0, 0xC3, 0x0E, 0xA8, 0x12, 0x0D, 0xA0,
  0x52, 0x05, 0xB0, 0x34, 0x01, 0x0D, 0xC0, 0xD5, 0x02, 0xB0, 0x52, 0x05, 0xA0, 0xD2, 0x07, 0xA0,
  0xC3, 0x0B, 0xA0, 0x95, 0x06, 0xC0, 0x65, 0x09, 0xA0, 0xC3, 0x0C, 0xA0, 0x72, 0x01, 0x0E, 0xA0,
  0x42, 0x82, 0x2E, 0xF5, 0x50, 0x1C, 0x01, 0x58, 0x25, 0xFE, 0x22, 0x04, 0xA0, 0xE0, 0x13, 0x08,
  0xA0, 0xD0, 0x13, 0x01, 0x77, 0x40, 0x20, 0x12, 0x01, 0x0D, 0xA0, 0x84, 0x01, 0x0E, 0xA0, 0xA7,
  0x77, 0x50, 0xAA, 0x0E, 0x01, 0x50, 0x4B, 0x04, 0x73, 0xC7, 0x30, 0x4B, 0x04, 0x70, 0x8A, 0x03,
  0x73, 0x0D, 0xA0, 0xD7, 0x30, 0x4A, 0x08, 0x72, 0x05, 0x04, 0x74, 0x82, 0x4D, 0xD4, 0x74, 0x04,
  0x05, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_online_prediction() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_round_48_action_online_prediction_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_opacity 48x48, 4-bit Alpha,  RLE, 241 bytes.
static const unsigned char ic_round_48_action_opacity_data[] PROGMEM = {
  0x77, 0x10, 0x01, 0x77, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x76, 0x08, 0xC0, 0x87, 0x77, 0x40, 0x8E,
  0x08, 0x77, 0x72, 0x08, 0xF9, 0x08, 0x77, 0x70, 0x9C, 0x00, 0xEC, 0x09, 0x77, 0x50, 0x9C, 0x82,
  0xE2, 0x2E, 0xC0, 0x97, 0x73, 0x09, 0xC0, 0xE0, 0x22, 0x02, 0x0E, 0xC0, 0x97, 0x71, 0x09, 0xC0,
  0xE0, 0x24, 0x02, 0x0E, 0xC0, 0x97, 0x60, 0x9C, 0x0D, 0x02, 0x60, 0x20, 0xDC, 0x09, 0x74, 0x0A,
  0xC0, 0xD0, 0x27, 0x10, 0x20, 0xDC, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x27, 0x30, 0x20, 0xDC, 0x09,
  0x70, 0x7C, 0x0D, 0x02, 0x75, 0x02, 0x0D, 0xC0, 0x75, 0x04, 0xC0, 0xD0, 0x17, 0x70, 0x10, 0xDC,
  0x04, 0x40, 0xCB, 0x0E, 0x02, 0x77, 0x20, 0x20, 0xEB, 0x0C, 0x30, 0x5C, 0x03, 0x77, 0x40, 0x3C,
  0x05, 0x20, 0xDB, 0x08, 0x77, 0x60, 0x8B, 0x81, 0xD0, 0x2B, 0x0E, 0x01, 0x77, 0x60, 0x10, 0xEB,
  0x02, 0x07, 0xB0, 0x97, 0x77, 0x10, 0xAB, 0x07, 0x0B, 0xB0, 0x57, 0x77, 0x10, 0x5B, 0x0B, 0x0C,
  0xB0, 0x27, 0x77, 0x10, 0x2B, 0x0C, 0x0E, 0xB7, 0x77, 0x20, 0x1B, 0x0E, 0xC7, 0x77, 0x3C, 0x0D,
  0xB0, 0x17, 0x77, 0x10, 0x1B, 0x0D, 0x0B, 0xFF, 0xFF, 0xA0, 0xB0, 0x9F, 0xFF, 0xFA, 0x09, 0x05,
  0xFF, 0xFF, 0xA0, 0x51, 0xFF, 0xFF, 0xA2, 0x0A, 0xFF, 0xFF, 0x0A, 0x20, 0x2F, 0xFF, 0xF0, 0x23,
  0x08, 0xFF, 0xFD, 0x08, 0x50, 0xDF, 0xFF, 0xB0, 0xD6, 0x02, 0x0E, 0xFF, 0xF9, 0x0E, 0x02, 0x70,
  0x30, 0xEF, 0xFE, 0x0E, 0x03, 0x72, 0x02, 0x0C, 0xFF, 0xC0, 0xC0, 0x27, 0x50, 0x8F, 0xFA, 0x08,
  0x77, 0x18, 0x11, 0x9E, 0xFB, 0x81, 0xE9, 0x17, 0x75, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_opacity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_round_48_action_opacity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_open_in_browser 48x48, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_round_48_action_open_in_browser_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAA, 0x0F, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77,
  0x77, 0xF9, 0x77, 0x77, 0xF9, 0x76, 0x00, 0x57, 0x6F, 0x97, 0x50, 0x7A, 0x07, 0x75, 0xF9, 0x74,
  0x07, 0xC0, 0x77, 0x4F, 0x97, 0x30, 0x7E, 0x07, 0x73, 0xF9, 0x72, 0x07, 0xF9, 0x07, 0x72, 0xF9,
  0x71, 0x07, 0xFB, 0x07, 0x71, 0xF9, 0x70, 0x5F, 0xD0, 0x57, 0xF9, 0x70, 0x5F, 0xD0, 0x57, 0xF9,
  0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7,
  0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xC0, 0xDF, 0xA0, 0xD0, 0x44,
  0xC4, 0x04, 0x0D, 0xFA, 0x0D, 0x0A, 0xFB, 0x0D, 0x4C, 0x40, 0xDF, 0xB8, 0x1A, 0x1E, 0xFA, 0x0D,
  0x40, 0xDA, 0x0D, 0x40, 0xDF, 0xA8, 0x4E, 0x10, 0x1A, 0xDE, 0x0D, 0x04, 0x48, 0x24, 0xDD, 0x44,
  0x04, 0x0D, 0xE8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_open_in_browser() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_round_48_action_open_in_browser_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_open_in_full 48x48, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_round_48_action_open_in_full_data[] PROGMEM = {
  0x77, 0x72, 0x06, 0x0D, 0xFA, 0x0D, 0x04, 0x77, 0x72, 0xFD, 0x0D, 0x77, 0x71, 0x01, 0xFE, 0x77,
  0x72, 0x07, 0xFD, 0x77, 0x73, 0x08, 0xFC, 0x77, 0x74, 0x08, 0xFB, 0x77, 0x75, 0x0A, 0xFA, 0x77,
  0x74, 0x05, 0xFB, 0x77, 0x73, 0x05, 0xFC, 0x77, 0x72, 0x05, 0xD0, 0xAE, 0x77, 0x71, 0x05, 0xD8,
  0x15, 0x07, 0xD7, 0x77, 0x05, 0xD0, 0x53, 0x07, 0xB0, 0xE7, 0x76, 0x05, 0xD0, 0x55, 0x82, 0x6E,
  0xF6, 0x77, 0x50, 0x5D, 0x05, 0x70, 0x17, 0x76, 0x05, 0xD0, 0x57, 0x77, 0x70, 0x5D, 0x05, 0x77,
  0x77, 0x05, 0xD0, 0x57, 0x77, 0x70, 0x5D, 0x05, 0x77, 0x77, 0x05, 0xD0, 0x57, 0x77, 0x70, 0x5D,
  0x05, 0x77, 0x77, 0x05, 0xD0, 0x57, 0x77, 0x70, 0x5D, 0x05, 0x77, 0x60, 0x17, 0x05, 0xD0, 0x57,
  0x75, 0x82, 0x6F, 0xE6, 0x50, 0x5D, 0x05, 0x77, 0x60, 0xEB, 0x07, 0x30, 0x5D, 0x05, 0x77, 0x7D,
  0x81, 0x70, 0x5D, 0x05, 0x77, 0x71, 0xE0, 0xAD, 0x05, 0x77, 0x72, 0xFC, 0x05, 0x77, 0x73, 0xFB,
  0x05, 0x77, 0x74, 0xFA, 0x0A, 0x77, 0x75, 0xFB, 0x08, 0x77, 0x74, 0xFC, 0x08, 0x77, 0x73, 0xFD,
  0x07, 0x77, 0x72, 0xFE, 0x01, 0x77, 0x71, 0x0D, 0xFD, 0x77, 0x72, 0x04, 0x0D, 0xFA, 0x0D, 0x06,
  0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_open_in_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_open_in_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_open_in_new_off 48x48, 4-bit Alpha,  RLE, 297 bytes.
static const unsigned char ic_round_48_action_open_in_new_off_data[] PROGMEM = {
  0x18, 0x12, 0x74, 0x50, 0xCF, 0xA0, 0xD0, 0x45, 0x05, 0xFC, 0x81, 0xB1, 0xEA, 0x07, 0x50, 0xCF,
  0xA0, 0xD5, 0x05, 0xFD, 0x05, 0xC0, 0x75, 0x0C, 0xF9, 0x0D, 0x60, 0x8F, 0xC0, 0x10, 0xEC, 0x07,
  0x50, 0xCE, 0x0D, 0x04, 0x70, 0x8F, 0xB1, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x08, 0xFA, 0x20, 0x3D,
  0x07, 0x77, 0x70, 0xAF, 0x93, 0xE0, 0x77, 0x75, 0x05, 0xFA, 0x3F, 0x07, 0x77, 0x30, 0x5F, 0xB3,
  0xF9, 0x07, 0x77, 0x10, 0x5D, 0x0A, 0xD3, 0xC0, 0xEC, 0x07, 0x76, 0x05, 0xD8, 0x15, 0x07, 0xC3,
  0xC0, 0x30, 0xEC, 0x07, 0x74, 0x05, 0xD0, 0x53, 0x07, 0xB3, 0xC1, 0x03, 0x0E, 0xC0, 0x77, 0x20,
  0x5D, 0x05, 0x50, 0x7A, 0x3C, 0x20, 0x30, 0xEC, 0x07, 0x70, 0x5D, 0x05, 0x70, 0x05, 0x3C, 0x30,
  0x30, 0xEC, 0x07, 0x50, 0x4D, 0x05, 0x76, 0xC4, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB0, 0x57, 0x7C,
  0x50, 0x30, 0xEC, 0x07, 0x58, 0x1C, 0xF5, 0x77, 0x1C, 0x60, 0x30, 0xEC, 0x07, 0x50, 0x47, 0x72,
  0xC7, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0xC7, 0x10, 0x30, 0xEC, 0x07, 0x76, 0x82, 0x4D, 0xD4, 0x3C,
  0x72, 0x07, 0xD0, 0x77, 0x50, 0xDA, 0x0D, 0x3C, 0x71, 0x05, 0xF0, 0x77, 0x4C, 0x3C, 0x70, 0x3F,
  0xA0, 0x77, 0x3C, 0x3C, 0x70, 0x8C, 0x07, 0x0E, 0xC0, 0x77, 0x2C, 0x3C, 0x70, 0x4B, 0x82, 0x50,
  0x3E, 0xC0, 0x77, 0x1C, 0x3C, 0x71, 0x81, 0x48, 0x33, 0x03, 0x0E, 0xC0, 0x77, 0xC3, 0xC7, 0x71,
  0x03, 0x0E, 0xC0, 0x76, 0xC3, 0xC7, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB3, 0xC7, 0x73, 0x03,
  0x0E, 0xC0, 0x75, 0x0C, 0xA3, 0xC7, 0x74, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0x93, 0xC7, 0x75, 0x03,
  0x0E, 0xC0, 0x75, 0x0C, 0x3C, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x71, 0xC7, 0x77, 0x03, 0x0E, 0xC0,
  0x77, 0x0D, 0xFF, 0xFF, 0xB0, 0x76, 0x0A, 0xFF, 0xFF, 0xC0, 0x75, 0x01, 0x0E, 0xFF, 0xFF, 0xC0,
  0x75, 0x81, 0x1A, 0xDF, 0xFF, 0xFB, 0x04, 0x77, 0x77, 0x50, 0x30, 0xEB, 0x07, 0x77, 0x77, 0x68,
  0x33, 0xEF, 0xE2, 0x77, 0x77, 0x78, 0x11, 0x51, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_open_in_new_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 41, 44), Box(0, 0, 47, 47),
      ic_round_48_action_open_in_new_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_open_in_new 48x48, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_round_48_action_open_in_new_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xB8, 0x2D, 0x41, 0xEF, 0xF9, 0x0D, 0x40,
  0xDF, 0xD0, 0xD0, 0xAF, 0xFA, 0x0D, 0x40, 0xDF, 0xE0, 0xDF, 0xF9, 0x0D, 0x04, 0x40, 0x40, 0xDF,
  0xFA, 0x0B, 0x01, 0x77, 0x71, 0x05, 0xFC, 0x01, 0x77, 0x71, 0x05, 0xFD, 0x77, 0x71, 0x05, 0xFE,
  0x77, 0x70, 0x5D, 0x05, 0xF9, 0x77, 0x60, 0x5D, 0x05, 0x1F, 0x97, 0x75, 0x05, 0xD0, 0x52, 0xF9,
  0x77, 0x40, 0x5D, 0x05, 0x3F, 0x97, 0x73, 0x05, 0xD0, 0x54, 0xF9, 0x77, 0x20, 0x5D, 0x05, 0x50,
  0xDA, 0x0D, 0xC7, 0x71, 0x05, 0xD0, 0x56, 0x82, 0x4D, 0xD4, 0xC7, 0x70, 0x5D, 0x05, 0x74, 0xC7,
  0x60, 0x5D, 0x05, 0x75, 0xC7, 0x50, 0x5D, 0x05, 0x76, 0xC7, 0x40, 0x5D, 0x05, 0x77, 0xC7, 0x30,
  0x5D, 0x05, 0x74, 0x82, 0x4D, 0xD4, 0xC7, 0x20, 0x5D, 0x05, 0x75, 0x0D, 0xA0, 0xDC, 0x71, 0x05,
  0xD0, 0x57, 0x6F, 0x97, 0x05, 0xD0, 0x57, 0x7F, 0x96, 0x03, 0xD0, 0x57, 0x71, 0xF9, 0x60, 0x9C,
  0x05, 0x77, 0x2F, 0x96, 0x06, 0xB0, 0x57, 0x73, 0xF9, 0x78, 0x16, 0x93, 0x77, 0x4F, 0x97, 0x77,
  0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x90, 0x17, 0x77, 0x50, 0x1F, 0x90,
  0xB0, 0x17, 0x77, 0x30, 0x10, 0xBC, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1,
  0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_open_in_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_open_in_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_open_with 48x48, 4-bit Alpha,  RLE, 245 bytes.
static const unsigned char ic_round_48_action_open_with_data[] PROGMEM = {
  0x77, 0x70, 0x05, 0x80, 0xC5, 0x00, 0x7A, 0x07, 0x80, 0xC3, 0x00, 0x7C, 0x07, 0x80, 0xC1, 0x00,
  0x7E, 0x07, 0x77, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x77, 0x75, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x30,
  0x7F, 0xD0, 0x77, 0x77, 0x71, 0x07, 0xFF, 0x07, 0x77, 0x76, 0x05, 0xFF, 0xA0, 0x57, 0x77, 0x50,
  0x5F, 0xFA, 0x05, 0x77, 0x77, 0x3F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x97, 0x77, 0x50,
  0x05, 0x71, 0xF9, 0x71, 0x00, 0x57, 0x71, 0x07, 0xA7, 0x1F, 0x97, 0x1A, 0x07, 0x76, 0x07, 0xB7,
  0x10, 0xBE, 0x0B, 0x71, 0xB0, 0x77, 0x40, 0x7C, 0x77, 0x73, 0xC0, 0x77, 0x20, 0x7D, 0x77, 0x73,
  0xD0, 0x77, 0x07, 0xFC, 0x0B, 0x75, 0x0B, 0xFC, 0x07, 0x50, 0x7F, 0xE7, 0x5F, 0xE0, 0x73, 0x07,
  0xFF, 0x75, 0xFF, 0x81, 0x70, 0x5F, 0xF9, 0x75, 0xFF, 0x90, 0x05, 0xFF, 0x97, 0x5F, 0xF9, 0x81,
  0x50, 0x7F, 0xF7, 0x5F, 0xF0, 0x73, 0x07, 0xFE, 0x75, 0xFE, 0x07, 0x50, 0x7F, 0xC0, 0xB7, 0x50,
  0xBF, 0xC0, 0x77, 0x07, 0xD7, 0x77, 0x3D, 0x07, 0x72, 0x07, 0xC7, 0x77, 0x3C, 0x07, 0x74, 0x07,
  0xB7, 0x10, 0xBE, 0x0B, 0x71, 0xB0, 0x77, 0x60, 0x7A, 0x71, 0xF9, 0x71, 0xA0, 0x77, 0x71, 0x00,
  0x57, 0x1F, 0x97, 0x10, 0x05, 0x77, 0x75, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x77,
  0x77, 0x30, 0x5F, 0xFA, 0x05, 0x77, 0x75, 0x05, 0xFF, 0xA0, 0x57, 0x77, 0x60, 0x7F, 0xF0, 0x77,
  0x77, 0x71, 0x07, 0xFD, 0x07, 0x77, 0x77, 0x30, 0x7F, 0xB0, 0x77, 0x77, 0x75, 0x07, 0xF9, 0x07,
  0x77, 0x77, 0x70, 0x7E, 0x07, 0x80, 0xC1, 0x00, 0x7C, 0x07, 0x80, 0xC3, 0x00, 0x7A, 0x07, 0x80,
  0xC5, 0x00, 0x05, 0x77, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_open_with() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_open_with_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_outbond 48x48, 4-bit Alpha,  RLE, 274 bytes.
static const unsigned char ic_round_48_action_outbond_data[] PROGMEM = {
  0x77, 0x89, 0x21, 0x69, 0xAC, 0xDD, 0xBA, 0x85, 0x17, 0x77, 0x48, 0x11, 0x7B, 0xFD, 0x0B, 0x06,
  0x77, 0x71, 0x07, 0x0E, 0xFF, 0xA0, 0xE0, 0x67, 0x74, 0x04, 0x0D, 0xFF, 0xE0, 0xD0, 0x37, 0x71,
  0x07, 0xFF, 0xFB, 0x05, 0x76, 0x09, 0xFF, 0xFD, 0x08, 0x74, 0x0A, 0xFF, 0xFF, 0x08, 0x72, 0x07,
  0xFF, 0xFF, 0xA0, 0x57, 0x05, 0xFF, 0xFF, 0xC0, 0x35, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xD5, 0x07,
  0xFF, 0xFF, 0xE0, 0x63, 0x01, 0xFF, 0xFF, 0xF0, 0xE3, 0x08, 0xFF, 0xA0, 0x77, 0x10, 0xAF, 0xB0,
  0x62, 0x0D, 0xFF, 0xA0, 0x47, 0x10, 0x1F, 0xB8, 0x1B, 0x02, 0xFF, 0xB0, 0xE0, 0x27, 0x01, 0xFC,
  0x01, 0x07, 0xFF, 0xC0, 0xE0, 0x26, 0x01, 0xFC, 0x05, 0x0A, 0xFF, 0xD0, 0x96, 0x01, 0xFC, 0x08,
  0x0C, 0xFF, 0xC0, 0xA7, 0x01, 0xFC, 0x0A, 0x0D, 0xFF, 0xB0, 0xA7, 0x10, 0x1F, 0xC0, 0xBF, 0xFB,
  0x0A, 0x50, 0x90, 0x22, 0x01, 0xFC, 0x0D, 0xFF, 0xA0, 0xA5, 0x84, 0xAF, 0xE2, 0x01, 0xFC, 0x0D,
  0x0E, 0xFF, 0x0A, 0x50, 0xAB, 0x81, 0xE7, 0xDF, 0xC0, 0x0C, 0xFE, 0x0A, 0x50, 0xAF, 0xFC, 0x0A,
  0x0B, 0xFD, 0x0A, 0x50, 0xAF, 0xFD, 0x09, 0x07, 0xFC, 0x0A, 0x50, 0xAF, 0xFE, 0x06, 0x03, 0xFC,
  0x01, 0x40, 0xAF, 0xFF, 0x81, 0x10, 0xDF, 0xA0, 0xE4, 0x0A, 0xFF, 0xF0, 0xB2, 0x09, 0xFB, 0x82,
  0x60, 0x1A, 0xFF, 0xF9, 0x07, 0x20, 0x2F, 0xC0, 0xEF, 0xFF, 0xA0, 0xE0, 0x13, 0x09, 0xFF, 0xFF,
  0xE0, 0x74, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xD6, 0x06, 0xFF, 0xFF, 0xC0, 0x47, 0x09, 0xFF, 0xFF,
  0xA0, 0x77, 0x20, 0xBF, 0xFF, 0xF0, 0x97, 0x30, 0x10, 0xBF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF,
  0xB0, 0x77, 0x71, 0x06, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x70, 0x17,
  0x76, 0x81, 0x29, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xBC, 0xEA, 0x83, 0xDC, 0xA7,
  0x27, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_outbond() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_outbond_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_outbound 48x48, 4-bit Alpha,  RLE, 264 bytes.
static const unsigned char ic_round_48_action_outbound_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0xFF, 0xA0, 0x57, 0x10, 0x3F,
  0xB0, 0x82, 0x0D, 0xFF, 0xA0, 0x47, 0x2F, 0xB8, 0x1D, 0x03, 0xFF, 0xB0, 0xE0, 0x37, 0x1F, 0xC0,
  0x30, 0x7F, 0xFC, 0x0E, 0x03, 0x7F, 0xC0, 0x70, 0xAF, 0xFD, 0x09, 0x7F, 0xC0, 0xA0, 0xCF, 0xFC,
  0x0A, 0x71, 0xFC, 0x0C, 0x0E, 0xFF, 0xB0, 0xA7, 0x2F, 0xC0, 0xEF, 0xFB, 0x0A, 0x50, 0x90, 0x33,
  0xFF, 0xFF, 0x0A, 0x58, 0x2A, 0xFE, 0x32, 0xFD, 0x0E, 0xFF, 0x0A, 0x50, 0xAB, 0x81, 0xE5, 0x5F,
  0xC0, 0xE0, 0xCF, 0xE0, 0xA5, 0x0A, 0xFF, 0xC0, 0xC0, 0xAF, 0xD0, 0xA5, 0x0A, 0xFF, 0xD0, 0xA0,
  0x7F, 0xC0, 0xA5, 0x0A, 0xFF, 0xE0, 0x70, 0x3F, 0xC5, 0x0A, 0xFF, 0xF8, 0x13, 0x0D, 0xFA, 0x0E,
  0x40, 0xAF, 0xFF, 0x0D, 0x20, 0x8F, 0xB0, 0x72, 0x0A, 0xFF, 0xF9, 0x08, 0x20, 0x1F, 0xC0, 0x0E,
  0xFF, 0xFA, 0x01, 0x30, 0x9F, 0xFF, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50,
  0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A,
  0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77,
  0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48,
  0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_outbound() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_outbound_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_outbox 48x48, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_round_48_action_outbox_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x60, 0x05, 0x76, 0xF9, 0x75, 0x07, 0xA0, 0x77, 0x5F, 0x97, 0x40, 0x7C, 0x07,
  0x74, 0xF9, 0x73, 0x07, 0xE0, 0x77, 0x3F, 0x97, 0x20, 0x7F, 0x90, 0x77, 0x2F, 0x97, 0x10, 0x7F,
  0xB0, 0x77, 0x1F, 0x97, 0x05, 0xFD, 0x05, 0x7F, 0x97, 0x05, 0xFD, 0x05, 0x7F, 0x97, 0x5C, 0x75,
  0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x50, 0xDA, 0x0D, 0x75,
  0xF9, 0x75, 0x82, 0x4D, 0xD4, 0x75, 0xFF, 0x81, 0xEA, 0x27, 0x38, 0x12, 0xAE, 0xFF, 0xF9, 0x0E,
  0x03, 0x71, 0x03, 0x0E, 0xFF, 0xFC, 0x0E, 0x03, 0x60, 0x30, 0xEF, 0xFF, 0xF0, 0x90, 0x32, 0x03,
  0x09, 0x80, 0xBC, 0x3F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF,
  0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_outbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_outbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_outlet 48x48, 4-bit Alpha,  RLE, 270 bytes.
static const unsigned char ic_round_48_action_outlet_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFA, 0x82, 0xB1, 0x1B, 0xF9, 0x82, 0xB1, 0x1B, 0xFA, 0x09, 0x30, 0x1F, 0xB0, 0x12, 0x01,
  0xF9, 0x01, 0x20, 0x1F, 0xB0, 0x12, 0x08, 0xFB, 0x4F, 0x94, 0xFB, 0x08, 0x20, 0xDF, 0xB4, 0xF9,
  0x4F, 0xB8, 0x1D, 0x03, 0xFC, 0x4F, 0x94, 0xFC, 0x03, 0x07, 0xFC, 0x4F, 0x94, 0xFC, 0x07, 0x0A,
  0xFC, 0x4F, 0x94, 0xFC, 0x0A, 0x0C, 0xFC, 0x4F, 0x94, 0xFC, 0x0C, 0x0E, 0xFC, 0x01, 0x20, 0x1F,
  0x90, 0x12, 0x01, 0xFC, 0x0E, 0xFD, 0x82, 0xB1, 0x1B, 0xF9, 0x82, 0xB1, 0x1B, 0x80, 0xE0, 0xF0,
  0xE8, 0x0C, 0x2F, 0x0E, 0x0C, 0x80, 0xC2, 0xF0, 0xC0, 0xA8, 0x0C, 0x2F, 0x0A, 0x07, 0xFF, 0xA0,
  0xD0, 0x52, 0x04, 0x0D, 0xFF, 0xA0, 0x70, 0x3F, 0xF9, 0x0D, 0x01, 0x40, 0x10, 0xDF, 0xF9, 0x81,
  0x30, 0xDF, 0xF0, 0x66, 0x05, 0xFF, 0x0D, 0x20, 0x8F, 0xF0, 0x17, 0xFF, 0x08, 0x20, 0x1F, 0xF7,
  0x1F, 0xF0, 0x13, 0x09, 0xFE, 0x71, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xD0, 0x16, 0x01, 0xFD, 0x0E,
  0x01, 0x50, 0x5F, 0xD0, 0xB0, 0x14, 0x01, 0x0B, 0xFD, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72,
  0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10,
  0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D,
  0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_outlet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_outlet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_output 48x48, 4-bit Alpha,  RLE, 208 bytes.
static const unsigned char ic_round_48_action_output_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x13, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x12, 0x0A,
  0xFF, 0xFF, 0xE0, 0xA2, 0x0D, 0xFF, 0xFF, 0xE0, 0xD2, 0xC7, 0x77, 0x7C, 0x2C, 0x77, 0x77, 0xC2,
  0xC7, 0x77, 0x70, 0xDA, 0x0D, 0x2C, 0x77, 0x77, 0x82, 0x4D, 0xD4, 0x2C, 0x77, 0x72, 0x00, 0x17,
  0x2C, 0x77, 0x71, 0x06, 0xA0, 0x77, 0x1C, 0x77, 0x71, 0x0E, 0xB0, 0x87, 0xC7, 0x77, 0x10, 0xCC,
  0x08, 0x6C, 0x77, 0x71, 0x02, 0x0E, 0xC0, 0x85, 0xC7, 0x77, 0x20, 0x30, 0xEC, 0x08, 0x4C, 0x77,
  0x73, 0x03, 0x0E, 0xC0, 0x83, 0xC7, 0x77, 0x40, 0x30, 0xEC, 0x08, 0x2C, 0x71, 0x04, 0x0D, 0xFF,
  0xF9, 0x07, 0x1C, 0x71, 0x0D, 0xFF, 0xFB, 0x01, 0xC7, 0x10, 0xDF, 0xFF, 0xB0, 0x1C, 0x71, 0x04,
  0x0D, 0xFF, 0xF9, 0x07, 0x1C, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x72, 0xC7, 0x77, 0x30, 0x30, 0xEC,
  0x07, 0x3C, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x74, 0xC7, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x5C, 0x77,
  0x71, 0x0C, 0xC0, 0x76, 0xC7, 0x77, 0x10, 0xEB, 0x07, 0x7C, 0x77, 0x71, 0x06, 0xA0, 0x77, 0x1C,
  0x77, 0x72, 0x00, 0x17, 0x2C, 0x77, 0x77, 0x82, 0x4D, 0xD4, 0x2C, 0x77, 0x77, 0x0D, 0xA0, 0xD2,
  0xC7, 0x77, 0x7C, 0x2C, 0x77, 0x77, 0xC2, 0x0D, 0xFF, 0xFF, 0xE0, 0xD2, 0x0A, 0xFF, 0xFF, 0xE0,
  0xA2, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x13, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_output() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_output_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pageview 48x48, 4-bit Alpha,  RLE, 203 bytes.
static const unsigned char ic_round_48_action_pageview_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xB3, 0xF8, 0x1B, 0x52, 0x28, 0x12, 0x5A, 0xFF,
  0xFF, 0xA0, 0xD0, 0x37, 0x10, 0x30, 0xCF, 0xFF, 0xE0, 0xB0, 0x17, 0x40, 0xBF, 0xFF, 0xC0, 0xD0,
  0x17, 0x60, 0xCF, 0xFF, 0xB0, 0x34, 0x84, 0x4B, 0xEE, 0xB4, 0x40, 0x3F, 0xFF, 0xA0, 0xB4, 0x08,
  0xE0, 0x84, 0x0B, 0xFF, 0xF9, 0x06, 0x30, 0x4F, 0x90, 0x43, 0x05, 0xFF, 0xF9, 0x02, 0x30, 0xBF,
  0x90, 0xB3, 0x01, 0xFF, 0xF9, 0x01, 0x30, 0xEF, 0x90, 0xE4, 0xFF, 0xF9, 0x01, 0x30, 0xEF, 0x90,
  0xE4, 0xFF, 0xF9, 0x02, 0x30, 0xBF, 0x90, 0xB3, 0x02, 0xFF, 0xF9, 0x05, 0x30, 0x4F, 0x90, 0x43,
  0x05, 0xFF, 0xF9, 0x0B, 0x40, 0x8E, 0x08, 0x40, 0xBF, 0xFF, 0xA0, 0x34, 0x84, 0x4B, 0xEE, 0xB4,
  0x40, 0x3F, 0xFF, 0xB0, 0xD0, 0x17, 0x70, 0x9F, 0xFF, 0xB0, 0xB0, 0x17, 0x70, 0x9F, 0xFF, 0xB0,
  0xD0, 0x37, 0x10, 0x35, 0x09, 0xFF, 0xFC, 0x81, 0xB5, 0x22, 0x83, 0x26, 0xBF, 0xA5, 0x09, 0xFF,
  0xFF, 0xE0, 0xA5, 0x0B, 0xFF, 0xFF, 0xE0, 0xA4, 0x06, 0xFF, 0xFF, 0xF0, 0xA3, 0x0A, 0x80, 0xC0,
  0xF8, 0x1B, 0x7A, 0xFA, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C,
  0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pageview() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_pageview_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_paid 48x48, 4-bit Alpha,  RLE, 333 bytes.
static const unsigned char ic_round_48_action_paid_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFD, 0x82, 0xC1, 0x1C, 0xFD,
  0x0A, 0x72, 0x09, 0xFE, 0x04, 0x20, 0x4F, 0xE0, 0x97, 0x05, 0xFE, 0x0B, 0x01, 0x28, 0x11, 0xBE,
  0xFD, 0x05, 0x50, 0x10, 0xEF, 0xC0, 0xA0, 0x16, 0x01, 0x09, 0xFC, 0x0E, 0x01, 0x40, 0x9F, 0xC0,
  0x97, 0x30, 0x7F, 0xC0, 0x93, 0x01, 0xFC, 0x0C, 0x48, 0x21, 0x55, 0x24, 0x0B, 0xFC, 0x01, 0x20,
  0x8F, 0xC0, 0x53, 0x07, 0xC0, 0x93, 0x0A, 0xFC, 0x08, 0x20, 0xDF, 0xC0, 0x12, 0x04, 0xE8, 0x1A,
  0x46, 0xFD, 0x81, 0xD0, 0x3F, 0xD3, 0x06, 0xFF, 0xF9, 0x03, 0x07, 0xFD, 0x02, 0x20, 0x2F, 0xFF,
  0x90, 0x70, 0xAF, 0xD0, 0x63, 0x04, 0x0D, 0xFF, 0xE0, 0xA0, 0xCF, 0xD0, 0xD0, 0x14, 0x05, 0x0B,
  0xFF, 0xC0, 0xC0, 0xEF, 0xE0, 0xB6, 0x81, 0x17, 0xDF, 0xF9, 0x0E, 0xFF, 0x90, 0xD0, 0x47, 0x06,
  0x0E, 0xFF, 0xFF, 0xB8, 0x1C, 0x61, 0x50, 0x20, 0xEF, 0xE0, 0xEF, 0xFD, 0x0A, 0x03, 0x40, 0x3F,
  0xD0, 0xE0, 0xCF, 0xFF, 0x0A, 0x01, 0x30, 0xAF, 0xC0, 0xC0, 0xAF, 0xFF, 0x90, 0xB3, 0x06, 0xFC,
  0x0A, 0x07, 0xFD, 0x81, 0xEA, 0xEF, 0x90, 0x22, 0x04, 0xFC, 0x07, 0x03, 0xFC, 0x83, 0xE1, 0x01,
  0xEF, 0x03, 0x20, 0x3F, 0xC8, 0x13, 0x0D, 0xFB, 0x0B, 0x30, 0x4E, 0x0D, 0x30, 0x5F, 0xB0, 0xD2,
  0x08, 0xFB, 0x0E, 0x01, 0x30, 0x40, 0xDB, 0x0B, 0x02, 0x30, 0xAF, 0xB0, 0x82, 0x01, 0xFC, 0x0A,
  0x58, 0x12, 0x31, 0x40, 0x3F, 0xC0, 0x13, 0x09, 0xFC, 0x0A, 0x73, 0x02, 0x0D, 0xFB, 0x09, 0x40,
  0x10, 0xEF, 0xC0, 0xC0, 0x47, 0x06, 0x0E, 0xFB, 0x0E, 0x01, 0x50, 0x5F, 0xE0, 0xC0, 0x22, 0x81,
  0x1A, 0xEF, 0xD0, 0x57, 0x09, 0xFE, 0x04, 0x20, 0x4F, 0xE0, 0x97, 0x20, 0xAF, 0xD8, 0x2C, 0x11,
  0xCF, 0xD0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E,
  0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8,
  0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_paid() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_paid_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pan_tool_alt 48x48, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_round_48_action_pan_tool_alt_data[] PROGMEM = {
  0x74, 0x82, 0x8D, 0xD8, 0x77, 0x74, 0x08, 0xC0, 0x87, 0x77, 0x30, 0xDC, 0x0D, 0x77, 0x73, 0xE7,
  0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77,
  0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xF9, 0x81, 0xE9,
  0x27, 0x75, 0xFC, 0x09, 0x02, 0x77, 0x3F, 0xE0, 0x90, 0x27, 0x71, 0xFF, 0x90, 0x90, 0x27, 0x6F,
  0xFB, 0x09, 0x01, 0x74, 0xFF, 0xC0, 0xD0, 0x17, 0x3F, 0xFD, 0x09, 0x20, 0x17, 0xFF, 0xD8, 0x7E,
  0x1D, 0xFE, 0xB8, 0x41, 0x2F, 0xFD, 0x0E, 0x07, 0xF0, 0xD0, 0x9F, 0xFD, 0x0C, 0x06, 0xFF, 0xFF,
  0x81, 0xA0, 0xBF, 0xFF, 0xE0, 0x82, 0x0C, 0xFF, 0xFD, 0x06, 0x20, 0x10, 0xCF, 0xFF, 0xC0, 0x43,
  0x01, 0x0D, 0xFF, 0xFB, 0x02, 0x40, 0x10, 0xDF, 0xFF, 0xA6, 0x02, 0x0E, 0xFF, 0xF0, 0xD7, 0x02,
  0x0E, 0xFF, 0xE0, 0xA7, 0x10, 0x30, 0xEF, 0xFD, 0x05, 0x72, 0x03, 0x0E, 0xFF, 0xB0, 0xB7, 0x48,
  0x12, 0x9D, 0xFE, 0x0D, 0x08, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pan_tool_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 39, 41), Box(0, 0, 47, 47),
      ic_round_48_action_pan_tool_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pan_tool 48x48, 4-bit Alpha,  RLE, 262 bytes.
static const unsigned char ic_round_48_action_pan_tool_data[] PROGMEM = {
  0x77, 0x71, 0x82, 0x8D, 0xD8, 0x80, 0xC2, 0x00, 0x8C, 0x08, 0x80, 0xC1, 0x00, 0xDC, 0x0D, 0x38,
  0x28, 0xDD, 0x87, 0x77, 0x72, 0xE2, 0x08, 0xC0, 0x87, 0x77, 0x71, 0xE2, 0x0D, 0xC0, 0xD7, 0x77,
  0x71, 0xE2, 0xE7, 0x77, 0x18, 0x28, 0xDD, 0x83, 0xE2, 0xE7, 0x77, 0x08, 0xC0, 0x82, 0xE2, 0xE7,
  0x77, 0x0D, 0xC0, 0xD2, 0xE2, 0xE3, 0x82, 0x8D, 0xD8, 0x77, 0xE2, 0xE2, 0xE2, 0x08, 0xC0, 0x87,
  0x6E, 0x2E, 0x2E, 0x20, 0xDC, 0x0D, 0x76, 0xE2, 0xE2, 0xE2, 0xE7, 0x6E, 0x2E, 0x2E, 0x2E, 0x76,
  0xE2, 0xE2, 0xE2, 0xE7, 0x6E, 0x2E, 0x2E, 0x2E, 0x76, 0xE2, 0xE2, 0xE2, 0xE7, 0x6E, 0x2E, 0x2E,
  0x2E, 0x76, 0xE2, 0xE2, 0xE2, 0xE7, 0x6E, 0x2E, 0x2E, 0x2E, 0x76, 0xE2, 0xE2, 0xE2, 0xE7, 0x6E,
  0x2E, 0x2E, 0x2E, 0x76, 0xE0, 0x03, 0xE0, 0x03, 0xE0, 0x03, 0xE7, 0x6F, 0xFF, 0xFA, 0x76, 0xFF,
  0xFF, 0xA7, 0x6F, 0xFF, 0xFA, 0x76, 0xFF, 0xFF, 0xA2, 0x02, 0x03, 0x72, 0xFF, 0xFF, 0xA1, 0x09,
  0xA0, 0xE0, 0x77, 0xFF, 0xFF, 0xA0, 0x6D, 0x0D, 0x04, 0x5F, 0xFF, 0xFA, 0x0A, 0xF0, 0xB0, 0x23,
  0xFF, 0xFF, 0xA0, 0x8F, 0xA0, 0x90, 0x11, 0xFF, 0xFF, 0xA0, 0x10, 0xEF, 0xA0, 0xE0, 0x7F, 0xFF,
  0xFA, 0x10, 0x30, 0xE8, 0x0C, 0x4F, 0x20, 0x30, 0xE8, 0x0C, 0x3F, 0x30, 0x40, 0xE8, 0x0C, 0x2F,
  0x40, 0x40, 0xE8, 0x0C, 0x1F, 0x50, 0x48, 0x0C, 0x1F, 0x60, 0x48, 0x0C, 0x0F, 0x70, 0x4F, 0xFF,
  0xFF, 0x71, 0x04, 0xFF, 0xFF, 0xE7, 0x20, 0x5F, 0xFF, 0xFC, 0x0E, 0x73, 0x05, 0xFF, 0xFF, 0xB0,
  0xC7, 0x40, 0x5F, 0xFF, 0xFA, 0x08, 0x75, 0x05, 0xFF, 0xFF, 0x90, 0x27, 0x60, 0x6F, 0xFF, 0xE0,
  0x97, 0x71, 0x06, 0xFF, 0xFC, 0x0B, 0x77, 0x30, 0x40, 0xDF, 0xFF, 0x90, 0x97, 0x76, 0x81, 0x6B,
  0xDF, 0xF9, 0x82, 0xEC, 0x82, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pan_tool() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 45, 47), Box(0, 0, 47, 47),
      ic_round_48_action_pan_tool_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_payment 48x48, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_48_action_payment_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x0B, 0x01, 0x77, 0x77, 0x01, 0x0B, 0xF9, 0x01, 0x77,
  0x77, 0x20, 0x1F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x48, 0x0D, 0x84, 0xF7, 0x77, 0x74, 0xF9,
  0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x90,
  0x17, 0x77, 0x72, 0x01, 0xF9, 0x0B, 0x01, 0x77, 0x77, 0x01, 0x0B, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D,
  0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xEF, 0xFF, 0xFC, 0x81,
  0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_payment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_payment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pending_actions 48x48, 4-bit Alpha,  RLE, 266 bytes.
static const unsigned char ic_round_48_action_pending_actions_data[] PROGMEM = {
  0x76, 0x84, 0x5B, 0xEE, 0xB5, 0x77, 0x77, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x50, 0xCF, 0x90,
  0xC7, 0x77, 0x40, 0x5F, 0xB0, 0x57, 0x71, 0x81, 0x1A, 0xDF, 0xB8, 0x2B, 0x11, 0xBF, 0xB8, 0x1D,
  0xA1, 0x50, 0x10, 0xEF, 0xD0, 0x12, 0x01, 0xFD, 0x0E, 0x01, 0x40, 0xAF, 0xE0, 0x12, 0x01, 0xFE,
  0x0A, 0x40, 0xDF, 0xE8, 0x2B, 0x11, 0xBF, 0xE0, 0xD4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA4,
  0xC4, 0xC4, 0x0D, 0xFF, 0x0D, 0x4C, 0x4C, 0x40, 0xAF, 0xF0, 0xA4, 0xC4, 0xC4, 0x01, 0x0E, 0xFD,
  0x0E, 0x01, 0x4C, 0x4C, 0x58, 0x11, 0xAD, 0xF9, 0x81, 0xDA, 0x15, 0xC4, 0xC7, 0x77, 0x3C, 0x4C,
  0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x38, 0x14, 0x7C, 0x94,
  0xC7, 0x77, 0x60, 0x24, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x74, 0x86, 0x59, 0xDE, 0xED,
  0x95, 0x6C, 0x77, 0x20, 0x40, 0xDF, 0x90, 0xD0, 0x44, 0xC7, 0x71, 0x08, 0xFD, 0x08, 0x3C, 0x77,
  0x08, 0xFF, 0x08, 0x2C, 0x76, 0x04, 0xF0, 0x30, 0x4F, 0x04, 0x1C, 0x76, 0x0D, 0xF2, 0xF0, 0xD1,
  0xC7, 0x50, 0x5F, 0x92, 0xF9, 0x05, 0xC7, 0x50, 0x9F, 0x92, 0xF9, 0x09, 0xC7, 0x50, 0xDF, 0x92,
  0xF9, 0x0D, 0xC7, 0x50, 0xEF, 0x92, 0x0E, 0xF0, 0xEC, 0x75, 0x0E, 0xF9, 0x82, 0x30, 0x3E, 0xE0,
  0xEC, 0x75, 0x0D, 0xF9, 0x83, 0xE2, 0x03, 0xED, 0x0D, 0xC7, 0x50, 0x9F, 0xA8, 0x2E, 0x20, 0x3D,
  0x09, 0xC7, 0x50, 0x5F, 0xB8, 0x2E, 0x20, 0xDC, 0x05, 0xC7, 0x60, 0xDF, 0xB0, 0xE0, 0xCC, 0x0D,
  0x1C, 0x76, 0x04, 0xFF, 0xA8, 0x14, 0x0D, 0xFD, 0x0A, 0x40, 0x8F, 0xF0, 0x82, 0x0A, 0xFE, 0x03,
  0x40, 0x8F, 0xD0, 0x83, 0x01, 0x0E, 0xFD, 0x0D, 0x01, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x45, 0x81,
  0x1A, 0xDF, 0xC0, 0xB6, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pending_actions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_pending_actions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pending 48x48, 4-bit Alpha,  RLE, 263 bytes.
static const unsigned char ic_round_48_action_pending_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0x80, 0xC0, 0xF0, 0x82, 0x0D,
  0x80, 0xC0, 0xF8, 0x1D, 0x03, 0x80, 0xC2, 0xF0, 0x30, 0x78, 0x0C, 0x2F, 0x07, 0x0A, 0x80, 0xC2,
  0xF0, 0xA0, 0xCF, 0x82, 0x71, 0x17, 0xE8, 0x27, 0x11, 0x7E, 0x82, 0x71, 0x17, 0xF0, 0xC0, 0xEE,
  0x07, 0x40, 0x7C, 0x07, 0x40, 0x7C, 0x07, 0x40, 0x7E, 0x0E, 0xF0, 0x14, 0x01, 0xC0, 0x14, 0x01,
  0xC0, 0x14, 0x01, 0xFF, 0x01, 0x40, 0x1C, 0x01, 0x40, 0x1C, 0x01, 0x40, 0x1F, 0x0E, 0xE0, 0x74,
  0x07, 0xC0, 0x74, 0x07, 0xC0, 0x74, 0x07, 0xE0, 0xE0, 0xCF, 0x82, 0x71, 0x17, 0xE8, 0x27, 0x11,
  0x7E, 0x82, 0x71, 0x17, 0xF0, 0xC0, 0xA8, 0x0C, 0x2F, 0x0A, 0x07, 0x80, 0xC2, 0xF0, 0x70, 0x38,
  0x0C, 0x2F, 0x81, 0x30, 0xD8, 0x0C, 0x0F, 0x0D, 0x20, 0x88, 0x0C, 0x0F, 0x08, 0x20, 0x18, 0x0C,
  0x0F, 0x01, 0x30, 0x9F, 0xFF, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50, 0x5F,
  0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF,
  0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30,
  0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33,
  0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pending() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_pending_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_percent 48x48, 4-bit Alpha,  RLE, 264 bytes.
static const unsigned char ic_round_48_action_percent_data[] PROGMEM = {
  0x38, 0x61, 0x7C, 0xEE, 0xC7, 0x17, 0x74, 0x01, 0x40, 0x50, 0xEE, 0x0E, 0x05, 0x77, 0x18, 0x25,
  0xEF, 0x82, 0x05, 0xFB, 0x05, 0x76, 0x05, 0xC8, 0x11, 0x1E, 0xFB, 0x0E, 0x01, 0x74, 0x05, 0xC8,
  0x1E, 0x07, 0xC8, 0x27, 0x11, 0x7C, 0x07, 0x73, 0x05, 0xD8, 0x15, 0x0C, 0xB0, 0x74, 0x07, 0xB0,
  0xC7, 0x20, 0x5D, 0x05, 0x20, 0xEB, 0x01, 0x40, 0x1B, 0x0E, 0x71, 0x05, 0xD0, 0x53, 0x0E, 0xB0,
  0x14, 0x01, 0xB0, 0xE7, 0x05, 0xD0, 0x54, 0x0C, 0xB0, 0x74, 0x07, 0xB0, 0xC6, 0x05, 0xD0, 0x55,
  0x07, 0xC8, 0x27, 0x11, 0x7C, 0x07, 0x50, 0x5D, 0x05, 0x60, 0x10, 0xEF, 0xB0, 0xE0, 0x14, 0x05,
  0xD0, 0x57, 0x10, 0x5F, 0xB0, 0x54, 0x05, 0xD0, 0x57, 0x30, 0x50, 0xEE, 0x0E, 0x05, 0x40, 0x5D,
  0x05, 0x75, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x40, 0x5D, 0x05, 0x77, 0x73, 0x05, 0xD0, 0x57, 0x77,
  0x30, 0x5D, 0x05, 0x77, 0x73, 0x05, 0xD0, 0x57, 0x77, 0x30, 0x5D, 0x05, 0x77, 0x73, 0x05, 0xD0,
  0x54, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x75, 0x05, 0xD0, 0x54, 0x05, 0x0E, 0xE0, 0xE0, 0x57, 0x30,
  0x5D, 0x05, 0x40, 0x5F, 0xB0, 0x57, 0x10, 0x5D, 0x05, 0x40, 0x10, 0xEF, 0xB0, 0xE0, 0x16, 0x05,
  0xD0, 0x55, 0x07, 0xC8, 0x27, 0x11, 0x7C, 0x07, 0x50, 0x5D, 0x05, 0x60, 0xCB, 0x07, 0x40, 0x7B,
  0x0C, 0x40, 0x5D, 0x05, 0x70, 0xEB, 0x01, 0x40, 0x1B, 0x0E, 0x30, 0x5D, 0x05, 0x71, 0x0E, 0xB0,
  0x14, 0x01, 0xB0, 0xE2, 0x05, 0xD0, 0x57, 0x20, 0xCB, 0x07, 0x40, 0x7B, 0x81, 0xC0, 0x5D, 0x05,
  0x73, 0x07, 0xC8, 0x27, 0x11, 0x7C, 0x81, 0x70, 0xEC, 0x05, 0x74, 0x01, 0x0E, 0xFB, 0x81, 0xE1,
  0x1C, 0x05, 0x76, 0x05, 0xFB, 0x05, 0x28, 0x28, 0xFE, 0x57, 0x71, 0x05, 0x0E, 0xE0, 0xE0, 0x54,
  0x01, 0x77, 0x48, 0x61, 0x7C, 0xEE, 0xC7, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_percent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_percent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_perm_camera_mic 48x48, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_round_48_action_perm_camera_mic_data[] PROGMEM = {
  0x76, 0x04, 0x0B, 0xFB, 0x0B, 0x04, 0x77, 0x74, 0x05, 0xFF, 0x05, 0x77, 0x72, 0x04, 0xFF, 0xA0,
  0x47, 0x77, 0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x48, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1,
  0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C, 0x2F, 0x09, 0x0D, 0x80, 0xC2, 0xF0, 0xDF, 0xFB,
  0x84, 0xD5, 0x11, 0x5D, 0xFF, 0xFF, 0xD0, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0x56, 0x05,
  0xFF, 0xFF, 0xC0, 0x16, 0x01, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC, 0x71, 0xFF, 0xFF, 0xC7, 0x1F,
  0xFF, 0xFC, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC,
  0x71, 0xFF, 0xFB, 0x82, 0xC2, 0x08, 0xC0, 0x16, 0x01, 0xC8, 0x28, 0x03, 0xDF, 0xFA, 0x04, 0x30,
  0xDB, 0x05, 0x60, 0x5B, 0x0D, 0x30, 0x5F, 0xFA, 0x04, 0x30, 0x9B, 0x0D, 0x01, 0x40, 0x10, 0xDB,
  0x08, 0x30, 0x4F, 0xFA, 0x08, 0x30, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x23, 0x08, 0xFF, 0xA0,
  0xD4, 0x09, 0xFD, 0x09, 0x40, 0xDF, 0xFB, 0x05, 0x40, 0xBF, 0xB0, 0xB4, 0x05, 0xFF, 0xC0, 0xD0,
  0x14, 0x09, 0xF9, 0x09, 0x40, 0x10, 0xEF, 0xFD, 0x0A, 0x58, 0x62, 0x8C, 0xEE, 0xC8, 0x25, 0x0A,
  0xFF, 0xF0, 0x97, 0x72, 0x09, 0xFF, 0xFA, 0x0A, 0x01, 0x75, 0x01, 0x0A, 0xFF, 0xFC, 0x0E, 0x05,
  0x73, 0x05, 0x0E, 0xFF, 0xFF, 0x81, 0xE8, 0x44, 0x81, 0x48, 0xEF, 0xF9, 0x0D, 0xFF, 0xB4, 0xFF,
  0xB0, 0xD0, 0xAF, 0xFB, 0x4F, 0xFB, 0x81, 0x91, 0xEF, 0xFA, 0x4F, 0xFA, 0x84, 0xE1, 0x01, 0xAD,
  0xFF, 0x4F, 0xF8, 0x1D, 0x91, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_perm_camera_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_perm_camera_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_perm_contact_calendar 48x48, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_round_48_action_perm_contact_calendar_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x72, 0x82, 0x4D, 0xD4, 0x75, 0x0D, 0xA0, 0xD7, 0x72, 0x0D, 0xA0, 0xD7,
  0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x4D, 0xA1, 0x01, 0xEF,
  0xFF, 0xFC, 0x81, 0xE1, 0xAF, 0xFF, 0xFE, 0x0A, 0x0D, 0xFF, 0xFF, 0xE0, 0xD8, 0x09, 0xA3, 0xF0,
  0x80, 0x32, 0x03, 0x08, 0xFF, 0xFF, 0x0D, 0x02, 0x60, 0x20, 0xDF, 0xFF, 0xD0, 0x27, 0x10, 0x2F,
  0xFF, 0xC0, 0x87, 0x30, 0x8F, 0xFF, 0xB0, 0x37, 0x30, 0x3F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F,
  0xFF, 0xB0, 0x37, 0x30, 0x3F, 0xFF, 0xB0, 0x87, 0x30, 0x8F, 0xFF, 0xC0, 0x27, 0x10, 0x2F, 0xFF,
  0xD0, 0xD0, 0x26, 0x02, 0x0D, 0xFF, 0xFF, 0x08, 0x03, 0x20, 0x30, 0x88, 0x0A, 0x87, 0xF8, 0x00,
  0xDF, 0xFF, 0xF8, 0x1B, 0x63, 0x68, 0x13, 0x6B, 0xFF, 0xF8, 0x1D, 0x61, 0x75, 0x81, 0x16, 0xDF,
  0xFB, 0x07, 0x77, 0x40, 0x7F, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0xE0, 0x77, 0x77, 0x10, 0x7F, 0xD0,
  0x17, 0x77, 0x10, 0x1F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x38, 0x09, 0x92, 0xF0, 0xDF, 0xFF, 0xFE,
  0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8,
  0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_perm_contact_calendar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_perm_contact_calendar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_perm_data_setting 48x48, 4-bit Alpha,  RLE, 293 bytes.
static const unsigned char ic_round_48_action_perm_data_setting_data[] PROGMEM = {
  0x77, 0x77, 0x70, 0x18, 0x0D, 0x00, 0x07, 0xA0, 0x58, 0x0C, 0x50, 0x07, 0xB0, 0xD8, 0x0C, 0x40,
  0x07, 0xD8, 0x0C, 0x30, 0x07, 0xE8, 0x0C, 0x20, 0x07, 0xF8, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC0,
  0x00, 0x7F, 0xA7, 0x77, 0x77, 0x07, 0xFB, 0x77, 0x77, 0x60, 0x7F, 0xC7, 0x77, 0x75, 0x07, 0xFD,
  0x77, 0x77, 0x40, 0x7F, 0xE7, 0x77, 0x73, 0x07, 0xFF, 0x77, 0x77, 0x20, 0x7F, 0xF9, 0x77, 0x77,
  0x10, 0x7F, 0xFA, 0x77, 0x77, 0x07, 0xFF, 0xB7, 0x77, 0x60, 0x7F, 0xFC, 0x77, 0x75, 0x07, 0xFF,
  0xD7, 0x77, 0x40, 0x7F, 0xFE, 0x77, 0x73, 0x07, 0xFF, 0xF7, 0x77, 0x20, 0x7F, 0xFF, 0x97, 0x77,
  0x10, 0x7F, 0xFA, 0x82, 0xB6, 0x32, 0x20, 0x17, 0x77, 0x07, 0xFF, 0x81, 0xE8, 0x17, 0x77, 0x60,
  0x7F, 0xF0, 0xA0, 0x17, 0x77, 0x70, 0x7F, 0xF0, 0x77, 0x77, 0x71, 0x07, 0xFF, 0x05, 0x77, 0x77,
  0x10, 0x7F, 0xF0, 0x77, 0x10, 0x7C, 0x06, 0x77, 0x10, 0x7F, 0xF0, 0xA7, 0x20, 0xAC, 0x09, 0x77,
  0x07, 0xFF, 0x0E, 0x01, 0x72, 0x0C, 0xC0, 0xB7, 0x60, 0x7F, 0xF9, 0x08, 0x58, 0x3C, 0xB5, 0x19,
  0xE8, 0x38, 0x15, 0xBB, 0x70, 0x7F, 0xFA, 0x01, 0x40, 0x6F, 0xFA, 0x05, 0x50, 0x7F, 0xFA, 0x0B,
  0x40, 0x10, 0xEF, 0xFA, 0x0D, 0x40, 0x7F, 0xFB, 0x06, 0x40, 0x8F, 0xFC, 0x07, 0x20, 0x7F, 0xFC,
  0x03, 0x40, 0x5F, 0x82, 0x71, 0x17, 0xE8, 0x2E, 0x50, 0x7F, 0xFD, 0x02, 0x50, 0x30, 0xDC, 0x06,
  0x40, 0x7C, 0x83, 0xD3, 0x01, 0xEF, 0xFD, 0x70, 0x7C, 0x01, 0x40, 0x1C, 0x06, 0x3F, 0xFE, 0x70,
  0x7C, 0x01, 0x40, 0x1C, 0x06, 0x30, 0x60, 0xEF, 0xFC, 0x01, 0x50, 0x30, 0xDC, 0x06, 0x40, 0x7C,
  0x0D, 0x03, 0x77, 0x76, 0x05, 0xF8, 0x27, 0x11, 0x7F, 0x05, 0x77, 0x75, 0x08, 0xFF, 0xC0, 0x77,
  0x77, 0x50, 0x10, 0xEF, 0xFA, 0x0D, 0x77, 0x77, 0x06, 0xFF, 0xA0, 0x57, 0x77, 0x71, 0x83, 0xCB,
  0x51, 0x9E, 0x83, 0x81, 0x5B, 0xB7, 0x77, 0x77, 0x0C, 0xC0, 0xC8, 0x0C, 0x40, 0x0A, 0xC0, 0x98,
  0x0C, 0x40, 0x07, 0xC0, 0x67,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_perm_data_setting() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 47, 47), Box(0, 0, 47, 47),
      ic_round_48_action_perm_data_setting_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_perm_device_information 48x48, 4-bit Alpha,  RLE, 140 bytes.
static const unsigned char ic_round_48_action_perm_device_information_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0x9E, 0x0F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x71, 0x82, 0x4D, 0xD4, 0x71, 0xF9, 0x71,
  0x0D, 0xA0, 0xD7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71,
  0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F,
  0x97, 0x10, 0xDA, 0x0D, 0x71, 0xF9, 0x71, 0x82, 0x4D, 0xD4, 0x71, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x0F, 0x0D, 0xFF, 0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81,
  0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_perm_device_information() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_round_48_action_perm_device_information_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_perm_identity 48x48, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_round_48_action_perm_identity_data[] PROGMEM = {
  0x75, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0x72, 0x09, 0xF9, 0x09, 0x77, 0x70, 0xBF, 0xB0, 0xB7,
  0x75, 0x09, 0xFD, 0x09, 0x77, 0x30, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x27, 0x72, 0x08, 0xB0,
  0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x72, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0x72, 0x0E, 0xB0,
  0x16, 0x01, 0xB0, 0xE7, 0x72, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x72, 0x0C, 0xB0, 0x56, 0x05,
  0xB0, 0xC7, 0x72, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x72, 0x02, 0xC8, 0x4D, 0x51,
  0x15, 0xDC, 0x02, 0x77, 0x30, 0x9F, 0xD0, 0x97, 0x75, 0x0B, 0xFB, 0x0B, 0x77, 0x70, 0x9F, 0x90,
  0x97, 0x77, 0x28, 0x62, 0x8C, 0xEE, 0xC8, 0x28, 0x09, 0xA1, 0x08, 0x41, 0x48, 0xAC, 0xDA, 0x84,
  0xDC, 0xA8, 0x41, 0x77, 0x18, 0x12, 0x7C, 0xFF, 0x81, 0xC7, 0x27, 0x30, 0x40, 0xBF, 0xFE, 0x0B,
  0x04, 0x60, 0x10, 0xBF, 0xFF, 0xB0, 0xB0, 0x13, 0x04, 0x0E, 0xF8, 0x3B, 0x85, 0x21, 0x28, 0x32,
  0x35, 0x8B, 0xF8, 0x3E, 0x40, 0x2E, 0xD0, 0xB0, 0x57, 0x70, 0x50, 0xBD, 0x81, 0xE2, 0xAC, 0x0A,
  0x02, 0x77, 0x40, 0x20, 0xAC, 0x0A, 0x0E, 0xB0, 0x67, 0x77, 0x10, 0x6B, 0x0E, 0xC7, 0x77, 0x3F,
  0x97, 0x77, 0x38, 0x09, 0x80, 0xF0, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF, 0xFF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_perm_identity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_perm_identity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_perm_media 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_48_action_perm_media_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0x98, 0x1E, 0xB5, 0x77, 0x77, 0x10, 0x10, 0xEF, 0xE0, 0x77, 0x77, 0x70,
  0x9F, 0xF9, 0x07, 0x77, 0x76, 0x0D, 0xFF, 0xA0, 0x77, 0x77, 0x5F, 0xFF, 0xFC, 0x81, 0xDA, 0x17,
  0x2F, 0xFF, 0xFE, 0x0E, 0x01, 0x71, 0xFF, 0xFF, 0xF0, 0xA7, 0x1F, 0xFF, 0xFF, 0x83, 0xD4, 0xDD,
  0x44, 0x80, 0xC0, 0xF0, 0xDA, 0x0D, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48,
  0x0C, 0x4F, 0x4F, 0xFE, 0x0E, 0x0B, 0xFF, 0xC4, 0xFF, 0xD8, 0x2E, 0x20, 0x9F, 0xFB, 0x4F, 0xFD,
  0x05, 0x30, 0xCF, 0xFA, 0x4F, 0xC8, 0x1E, 0x6A, 0xC0, 0x94, 0x02, 0x0E, 0xFF, 0x94, 0xFC, 0x05,
  0x20, 0xCA, 0x0C, 0x60, 0x5F, 0xF9, 0x4F, 0xB0, 0x93, 0x82, 0x2E, 0xE2, 0x70, 0x9F, 0xF4, 0xFA,
  0x0C, 0x50, 0x05, 0x72, 0x0C, 0xFE, 0x4F, 0xA0, 0x37, 0x72, 0x03, 0xFE, 0x4F, 0xA0, 0x37, 0x72,
  0x03, 0xFE, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x40, 0xDF,
  0xFF, 0xFE, 0x0D, 0xC4, 0x0A, 0xFF, 0xFF, 0xE0, 0xAC, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01,
  0xC5, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x1C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80,
  0xC4, 0x0C, 0x80, 0xC4, 0x00, 0xDF, 0xFF, 0xFF, 0x0D, 0x04, 0x60, 0xA8, 0x0C, 0x0F, 0x0D, 0x60,
  0x10, 0xEF, 0xFF, 0xFF, 0x0D, 0x78, 0x11, 0xAD, 0xFF, 0xFF, 0xC0, 0xD0, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_perm_media() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_perm_media_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_perm_phone_msg 48x48, 4-bit Alpha,  RLE, 227 bytes.
static const unsigned char ic_round_48_action_perm_phone_msg_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0xC0, 0xC0, 0x57, 0x10, 0x40, 0xDF, 0xF8, 0x2D, 0x41, 0xDF, 0x90, 0x87, 0x0D,
  0xFF, 0xA0, 0xD0, 0x9F, 0xB0, 0x26, 0xFF, 0xC0, 0xCF, 0xB0, 0x76, 0xFF, 0xC0, 0xDF, 0xB0, 0x96,
  0xFF, 0xC0, 0xCF, 0xB0, 0xB6, 0xFF, 0xC0, 0xAF, 0xB0, 0xD6, 0xFF, 0xC0, 0x8F, 0xB0, 0xE6, 0xFF,
  0xC0, 0x5F, 0xC6, 0xFF, 0xC0, 0x2F, 0xC6, 0xFF, 0xC1, 0x0E, 0xFA, 0x0C, 0x6F, 0xFC, 0x10, 0x9F,
  0xA0, 0x36, 0xFF, 0xC1, 0x05, 0xF9, 0x05, 0x7F, 0xFB, 0x0D, 0x20, 0xEE, 0x05, 0x71, 0xFF, 0xA0,
  0xD0, 0x42, 0x09, 0xD0, 0x57, 0x2D, 0x07, 0x77, 0x03, 0xC0, 0x77, 0x3C, 0x07, 0x77, 0x20, 0xBB,
  0x0B, 0x73, 0xB0, 0x77, 0x73, 0x03, 0xC0, 0x47, 0x2A, 0x07, 0x77, 0x50, 0xBB, 0x0D, 0x01, 0x71,
  0x90, 0x77, 0x76, 0x02, 0xC0, 0x97, 0x10, 0x77, 0x77, 0x10, 0x7C, 0x06, 0x77, 0x77, 0x30, 0xCC,
  0x03, 0x77, 0x77, 0x20, 0x20, 0xEB, 0x0E, 0x02, 0x77, 0x77, 0x20, 0x5C, 0x0E, 0x02, 0x77, 0x77,
  0x20, 0x7C, 0x0E, 0x03, 0x72, 0x03, 0x0C, 0xA8, 0x4E, 0xCA, 0x96, 0x27, 0x40, 0x8D, 0x06, 0x70,
  0x5F, 0xB0, 0x87, 0x40, 0x8D, 0x09, 0x01, 0x40, 0x5F, 0xD0, 0x67, 0x40, 0x7D, 0x0D, 0x05, 0x20,
  0x5F, 0xE0, 0xC7, 0x50, 0x50, 0xED, 0x0B, 0x07, 0xFF, 0x0E, 0x76, 0x02, 0x0C, 0xFF, 0xF7, 0x71,
  0x07, 0xFF, 0xE7, 0x72, 0x02, 0x0B, 0xFF, 0xC7, 0x74, 0x03, 0x0B, 0xFF, 0x90, 0xD7, 0x76, 0x81,
  0x39, 0xEF, 0xD0, 0x97, 0x77, 0x28, 0x15, 0x9E, 0xF9, 0x0D, 0x01, 0x77, 0x75, 0x87, 0x25, 0x8A,
  0xCD, 0xC9, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_perm_phone_msg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_perm_phone_msg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_perm_scan_wifi 48x48, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_round_48_action_perm_scan_wifi_data[] PROGMEM = {
  0x77, 0x18, 0x53, 0x79, 0xBD, 0xDE, 0xA8, 0x5E, 0xDD, 0xB9, 0x63, 0x77, 0x75, 0x81, 0x37, 0xCF,
  0xFC, 0x81, 0xC7, 0x37, 0x75, 0x81, 0x17, 0xDF, 0xFF, 0xB8, 0x1D, 0x71, 0x77, 0x02, 0x0A, 0xFF,
  0xFF, 0xA0, 0x90, 0x27, 0x30, 0x20, 0xAF, 0xFF, 0xFE, 0x0A, 0x02, 0x70, 0x88, 0x0C, 0x2F, 0x08,
  0x40, 0x40, 0xDF, 0xFC, 0x4F, 0xFC, 0x82, 0xD3, 0x07, 0xFF, 0xE4, 0xFF, 0xE0, 0x7F, 0xFF, 0x4F,
  0xFF, 0x0E, 0xFF, 0xE4, 0xFF, 0xE0, 0xE0, 0x58, 0x0D, 0x0F, 0x81, 0x50, 0x88, 0x0C, 0x6F, 0x08,
  0x30, 0xA8, 0x0C, 0x4F, 0x0B, 0x50, 0xD8, 0x0C, 0x2F, 0x0D, 0x01, 0x50, 0x20, 0xEF, 0xFA, 0x82,
  0xB1, 0x1B, 0xFF, 0xA0, 0xE0, 0x27, 0x04, 0xFF, 0xA0, 0x12, 0x01, 0xFF, 0xA0, 0x47, 0x20, 0x7F,
  0xF9, 0x4F, 0xF9, 0x07, 0x74, 0x0A, 0xFF, 0x4F, 0xF0, 0xA7, 0x60, 0xCF, 0xE4, 0xFE, 0x0C, 0x77,
  0x01, 0x0E, 0xFD, 0x4F, 0xD0, 0xE0, 0x17, 0x71, 0x03, 0xFD, 0x4F, 0xD0, 0x37, 0x73, 0x06, 0xFC,
  0x4F, 0xC0, 0x67, 0x75, 0x09, 0xFB, 0x4F, 0xB0, 0x97, 0x77, 0x0B, 0xFA, 0x4F, 0xA0, 0xB7, 0x77,
  0x10, 0x10, 0xDF, 0x90, 0x12, 0x01, 0xF9, 0x0D, 0x01, 0x77, 0x72, 0x02, 0x0E, 0xF8, 0x2B, 0x11,
  0xBF, 0x0E, 0x03, 0x77, 0x74, 0x05, 0xFF, 0xC0, 0x57, 0x77, 0x60, 0x8F, 0xFA, 0x08, 0x77, 0x77,
  0x10, 0xAF, 0xF0, 0xB7, 0x77, 0x73, 0x0D, 0xFD, 0x0D, 0x77, 0x77, 0x40, 0x20, 0xEF, 0xB0, 0xE0,
  0x27, 0x77, 0x75, 0x04, 0xFB, 0x04, 0x77, 0x77, 0x70, 0x7F, 0x90, 0x78, 0x0C, 0x10, 0x0A, 0xE0,
  0xA8, 0x0C, 0x30, 0x0A, 0xC0, 0xB8, 0x0C, 0x50, 0x82, 0x48, 0x95, 0x77, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_perm_scan_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 46, 41), Box(0, 0, 47, 47),
      ic_round_48_action_perm_scan_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pets 48x48, 4-bit Alpha,  RLE, 291 bytes.
static const unsigned char ic_round_48_action_pets_data[] PROGMEM = {
  0x74, 0x84, 0x4B, 0xEE, 0xB4, 0x68, 0x44, 0xBE, 0xEB, 0x47, 0x77, 0x08, 0xE0, 0x84, 0x08, 0xE0,
  0x87, 0x75, 0x04, 0xF9, 0x04, 0x20, 0x4F, 0x90, 0x47, 0x74, 0x0B, 0xF9, 0x0B, 0x20, 0xBF, 0x90,
  0xB7, 0x74, 0x0E, 0xF9, 0x0E, 0x20, 0xEF, 0x90, 0xE7, 0x74, 0x0E, 0xF9, 0x0E, 0x20, 0xEF, 0x90,
  0xE7, 0x74, 0x0B, 0xF9, 0x0B, 0x20, 0xBF, 0x90, 0xB7, 0x74, 0x04, 0xF9, 0x04, 0x20, 0x4F, 0x90,
  0x47, 0x48, 0x44, 0xBE, 0xEB, 0x42, 0x08, 0xE0, 0x84, 0x08, 0xE0, 0x82, 0x84, 0x4B, 0xEE, 0xB4,
  0x30, 0x8E, 0x08, 0x28, 0x44, 0xBE, 0xEB, 0x46, 0x84, 0x4B, 0xEE, 0xB4, 0x20, 0x8E, 0x81, 0x80,
  0x4F, 0x90, 0x47, 0x76, 0x04, 0xF9, 0x04, 0x0B, 0xF9, 0x0B, 0x77, 0x60, 0xBF, 0x90, 0xB0, 0xEF,
  0x90, 0xE7, 0x76, 0x0E, 0xF9, 0x00, 0xEF, 0x90, 0xE7, 0x76, 0x0E, 0xF9, 0x0E, 0x0B, 0xF9, 0x0B,
  0x77, 0x60, 0xBF, 0x90, 0xB0, 0x4F, 0x90, 0x46, 0x81, 0x19, 0xDA, 0x81, 0xD9, 0x26, 0x04, 0xF9,
  0x81, 0x40, 0x8E, 0x08, 0x60, 0x40, 0xEE, 0x0E, 0x04, 0x60, 0x8E, 0x08, 0x38, 0x44, 0xBE, 0xEB,
  0x46, 0x05, 0xFB, 0x05, 0x68, 0x44, 0xBE, 0xEB, 0x47, 0x71, 0x03, 0xFD, 0x03, 0x77, 0x74, 0x02,
  0x0E, 0xFD, 0x0E, 0x02, 0x77, 0x72, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x77, 0x71, 0x0B, 0xFF, 0xA0,
  0xB7, 0x77, 0x09, 0xFF, 0xC0, 0x97, 0x75, 0x07, 0xFF, 0xE0, 0x77, 0x73, 0x07, 0xFF, 0xF9, 0x07,
  0x77, 0x10, 0x6F, 0xFF, 0xB0, 0x67, 0x60, 0x4F, 0xFF, 0xD0, 0x47, 0x40, 0x20, 0xEF, 0xFF, 0xD0,
  0xE0, 0x27, 0x30, 0xCF, 0xFF, 0xF0, 0xC7, 0x20, 0x5F, 0xFF, 0xFA, 0x05, 0x71, 0x0B, 0xFF, 0xFF,
  0xA0, 0xA7, 0x10, 0xEF, 0xFF, 0xFA, 0x0D, 0x71, 0xFF, 0xFF, 0xB0, 0xE7, 0x10, 0xDF, 0xFF, 0xFA,
  0x0C, 0x71, 0x07, 0xFF, 0xFF, 0xA0, 0x67, 0x20, 0xCF, 0xFF, 0xF0, 0xC7, 0x30, 0x20, 0xDF, 0xFF,
  0xD0, 0xC0, 0x17, 0x58, 0xB0, 0x7D, 0xFE, 0xCA, 0x87, 0x53, 0x31, 0x11, 0x13, 0x35, 0x78, 0xAC,
  0xEF, 0xD7, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pets() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_pets_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_php 48x48, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_48_action_php_data[] PROGMEM = {
  0x04, 0x0D, 0xD0, 0xD0, 0x84, 0x81, 0x8E, 0x84, 0x81, 0x8E, 0x84, 0x04, 0x0D, 0xD8, 0x2D, 0x80,
  0xDF, 0x90, 0x83, 0xB4, 0xB4, 0x0D, 0xF9, 0x08, 0xFA, 0x0D, 0x3B, 0x4B, 0x4F, 0xA0, 0xDB, 0x4B,
  0x3B, 0x4B, 0x4B, 0x4E, 0x4B, 0x3F, 0xB4, 0xB4, 0xFD, 0x0D, 0x3F, 0xB4, 0xFA, 0x0D, 0xFA, 0x08,
  0x3F, 0xB4, 0xFA, 0x08, 0xF0, 0xD0, 0x84, 0xB4, 0xB4, 0xF0, 0xD0, 0x81, 0xB7, 0x3B, 0x4B, 0x4B,
  0x7B, 0x73, 0xB4, 0xB4, 0xB7, 0xB7, 0x3B, 0x4B, 0x4B, 0x78, 0x18, 0xE8, 0x73, 0x81, 0x8E, 0x84,
  0x81, 0x8E, 0x84, 0x81, 0x8E, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_php() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 18, 42, 29), Box(0, 0, 47, 47),
      ic_round_48_action_php_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_picture_in_picture_alt 48x48, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_round_48_action_picture_in_picture_alt_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0x80, 0xC0, 0xF8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0E, 0x80, 0xC6, 0xF0, 0xEC, 0x0A, 0x77, 0x77, 0x60, 0xAF, 0x90, 0x17, 0x77, 0x76,
  0x01, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9,
  0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x77, 0x20, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0xF9, 0x77, 0x20, 0xDF,
  0xF0, 0xD4, 0xF9, 0x77, 0x2F, 0xFA, 0x4F, 0x97, 0x72, 0xFF, 0xA4, 0xF9, 0x77, 0x2F, 0xFA, 0x4F,
  0x97, 0x72, 0xFF, 0xA4, 0xF9, 0x77, 0x2F, 0xFA, 0x4F, 0x97, 0x72, 0xFF, 0xA4, 0xF9, 0x77, 0x2F,
  0xFA, 0x4F, 0x97, 0x72, 0xFF, 0xA4, 0xF9, 0x77, 0x20, 0xDF, 0xF0, 0xD4, 0xF9, 0x77, 0x20, 0x40,
  0xDF, 0xD0, 0xD0, 0x44, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x01, 0x77, 0x77, 0x60,
  0x1F, 0x90, 0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6,
  0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_picture_in_picture_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_picture_in_picture_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_picture_in_picture 48x48, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_round_48_action_picture_in_picture_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x0A, 0x01, 0x77, 0x77, 0x40, 0x10, 0xAF, 0x90, 0x17,
  0x77, 0x76, 0x01, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x77, 0x20, 0x40, 0xDF, 0xD0,
  0xD0, 0x44, 0xF9, 0x77, 0x20, 0xDF, 0xF0, 0xD4, 0xF9, 0x77, 0x2F, 0xFA, 0x4F, 0x97, 0x72, 0xFF,
  0xA4, 0xF9, 0x77, 0x2F, 0xFA, 0x4F, 0x97, 0x72, 0xFF, 0xA4, 0xF9, 0x77, 0x2F, 0xFA, 0x4F, 0x97,
  0x72, 0xFF, 0xA4, 0xF9, 0x77, 0x2F, 0xFA, 0x4F, 0x97, 0x72, 0xFF, 0xA4, 0xF9, 0x77, 0x20, 0xDF,
  0xF0, 0xD4, 0xF9, 0x77, 0x20, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C,
  0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9,
  0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x01, 0x77,
  0x77, 0x60, 0x1F, 0x90, 0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x09,
  0x80, 0xC6, 0xF8, 0x19, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x19, 0xD8, 0x0C, 0x0F, 0x81, 0xD9,
  0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_picture_in_picture() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_picture_in_picture_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pinch 48x48, 4-bit Alpha,  RLE, 256 bytes.
static const unsigned char ic_round_48_action_pinch_data[] PROGMEM = {
  0x73, 0x08, 0xF0, 0xD0, 0x47, 0x77, 0x76, 0x0E, 0xF9, 0x0D, 0x77, 0x77, 0x60, 0x8F, 0xA8, 0x0C,
  0x20, 0x09, 0xD8, 0x0C, 0x10, 0x09, 0xE8, 0x0C, 0x00, 0x09, 0xB0, 0x9B, 0x77, 0x77, 0x70, 0x9B,
  0x09, 0x1B, 0x77, 0x77, 0x60, 0x9B, 0x09, 0x2B, 0x77, 0x77, 0x50, 0x9B, 0x09, 0x3B, 0x58, 0x28,
  0xDD, 0x87, 0x77, 0x20, 0x9B, 0x09, 0x48, 0x18, 0xE8, 0x40, 0x8C, 0x08, 0x77, 0x81, 0x8E, 0x84,
  0x09, 0xB0, 0x97, 0x50, 0xDC, 0x0D, 0x77, 0xB3, 0x09, 0xB0, 0x97, 0x6E, 0x77, 0xB2, 0x09, 0xB0,
  0x97, 0x7E, 0x77, 0xB1, 0x09, 0xB0, 0x97, 0x71, 0xE7, 0x7B, 0x09, 0xB0, 0x97, 0x72, 0xE7, 0x7E,
  0x09, 0x77, 0x3E, 0x77, 0xD0, 0x97, 0x74, 0xE7, 0x7F, 0xA0, 0x87, 0x7E, 0x77, 0x0D, 0xF9, 0x0E,
  0x77, 0xE7, 0x70, 0x40, 0xDF, 0x08, 0x77, 0xE8, 0x0C, 0x20, 0xE8, 0x0C, 0x20, 0xE8, 0x0C, 0x20,
  0xE8, 0x0C, 0x20, 0xF9, 0x81, 0xE9, 0x27, 0x77, 0x75, 0xFC, 0x09, 0x02, 0x77, 0x77, 0x3F, 0xE0,
  0x90, 0x27, 0x77, 0x71, 0xFF, 0x90, 0x90, 0x27, 0x77, 0x6F, 0xFB, 0x09, 0x01, 0x77, 0x74, 0xFF,
  0xC0, 0xD0, 0x17, 0x77, 0x3F, 0xFD, 0x09, 0x77, 0x20, 0x17, 0xFF, 0xD0, 0xE7, 0x78, 0x61, 0xDF,
  0xEB, 0x84, 0x12, 0xFF, 0xD0, 0xE7, 0x70, 0x7F, 0x0D, 0x09, 0xFF, 0xD0, 0xC7, 0x70, 0x6F, 0xFF,
  0xF0, 0xA7, 0x71, 0x0B, 0xFF, 0xFE, 0x08, 0x77, 0x20, 0xCF, 0xFF, 0xD0, 0x67, 0x72, 0x01, 0x0C,
  0xFF, 0xFC, 0x04, 0x77, 0x30, 0x10, 0xDF, 0xFF, 0xB0, 0x27, 0x74, 0x01, 0x0D, 0xFF, 0xFA, 0x77,
  0x60, 0x20, 0xEF, 0xFF, 0x0D, 0x77, 0x70, 0x20, 0xEF, 0xFE, 0x0A, 0x77, 0x71, 0x03, 0x0E, 0xFF,
  0xD0, 0x57, 0x77, 0x20, 0x30, 0xEF, 0xFB, 0x0B, 0x77, 0x74, 0x81, 0x29, 0xDF, 0xE0, 0xD0, 0x83,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pinch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_pinch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pin_end 48x48, 4-bit Alpha,  RLE, 184 bytes.
static const unsigned char ic_round_48_action_pin_end_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x73, 0x0B, 0xF9, 0x0A, 0x75, 0xF9, 0x73, 0xFA, 0x0A, 0x75, 0xF9,
  0x73, 0xF9, 0x0C, 0x76, 0xF9, 0x73, 0xF0, 0xC7, 0x7F, 0x97, 0x3F, 0x06, 0x77, 0xF9, 0x73, 0xF9,
  0x05, 0x76, 0xF9, 0x73, 0xFA, 0x05, 0x75, 0xF9, 0x73, 0xB0, 0xB0, 0x5D, 0x05, 0x74, 0xF9, 0x73,
  0xA0, 0xB2, 0x05, 0xD0, 0x47, 0x7C, 0x73, 0x00, 0xA4, 0x05, 0xC0, 0xC7, 0x7C, 0x77, 0x30, 0x5B,
  0x0B, 0x77, 0xC7, 0x74, 0x82, 0x4C, 0xB2, 0x77, 0xC7, 0x77, 0x68, 0x46, 0xCE, 0xEC, 0x63, 0xC7,
  0x77, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x1C, 0x77, 0x74, 0x0C, 0xF9, 0x0C, 0x1C, 0x77, 0x73, 0x06,
  0xFB, 0x06, 0xC7, 0x77, 0x30, 0xCF, 0xB0, 0xCC, 0x77, 0x73, 0x0E, 0xFB, 0x0E, 0xC7, 0x77, 0x30,
  0xEF, 0xB0, 0xEC, 0x77, 0x73, 0x0C, 0xFB, 0x0C, 0x0D, 0xFF, 0xFA, 0x40, 0x6F, 0xB0, 0x60, 0xAF,
  0xFF, 0xA5, 0x0C, 0xF9, 0x82, 0xC0, 0x1E, 0xFF, 0xF9, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x28, 0x11,
  0xAD, 0xFF, 0xE7, 0x84, 0x6C, 0xEE, 0xC6, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pin_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_pin_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pin_invoke 48x48, 4-bit Alpha,  RLE, 184 bytes.
static const unsigned char ic_round_48_action_pin_invoke_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE7, 0x84, 0x6C, 0xEE, 0xC6, 0x30, 0x10, 0xEF, 0xFF, 0x95, 0x01, 0x0C,
  0xE8, 0x2C, 0x10, 0xAF, 0xFF, 0xA5, 0x0C, 0xF9, 0x81, 0xC0, 0xDF, 0xFF, 0xA4, 0x06, 0xFB, 0x06,
  0xC7, 0x77, 0x30, 0xCF, 0xB0, 0xCC, 0x77, 0x73, 0x0E, 0xFB, 0x0E, 0xC7, 0x77, 0x30, 0xEF, 0xB0,
  0xEC, 0x77, 0x73, 0x0C, 0xFB, 0x0C, 0xC7, 0x77, 0x30, 0x6F, 0xB0, 0x6C, 0x77, 0x74, 0x0C, 0xF9,
  0x0C, 0x1C, 0x77, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x11, 0xC7, 0x77, 0x68, 0x46, 0xCE, 0xEC, 0x63,
  0xC7, 0x50, 0xAF, 0x90, 0xB7, 0x7C, 0x75, 0x0A, 0xFA, 0x77, 0xC7, 0x60, 0xBF, 0x97, 0x7C, 0x77,
  0x0B, 0xF7, 0x7C, 0x77, 0x05, 0xF7, 0x3F, 0x97, 0x60, 0x5F, 0x97, 0x3F, 0x97, 0x50, 0x5F, 0xA7,
  0x3F, 0x97, 0x40, 0x5D, 0x06, 0x0C, 0xB7, 0x3F, 0x97, 0x30, 0x4D, 0x05, 0x20, 0xCA, 0x73, 0xF9,
  0x73, 0x0C, 0xC0, 0x54, 0x00, 0xA7, 0x3F, 0x97, 0x30, 0xBB, 0x05, 0x77, 0x3F, 0x97, 0x38, 0x22,
  0xBC, 0x47, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77,
  0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E,
  0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pin_invoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_pin_invoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_plagiarism 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_48_action_plagiarism_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x0A, 0xFF, 0xF0,
  0x77, 0x20, 0xDF, 0xFB, 0x07, 0xC0, 0x77, 0x1F, 0xFC, 0x10, 0x7C, 0x07, 0x7F, 0xFC, 0x20, 0x7C,
  0x07, 0x6F, 0xFC, 0x30, 0x7C, 0x07, 0x5F, 0xFC, 0x40, 0x7C, 0x07, 0x4F, 0xFC, 0x50, 0x7C, 0x07,
  0x3F, 0xFC, 0x60, 0x7C, 0x07, 0x2F, 0xFC, 0x70, 0x7C, 0x07, 0x1F, 0xFC, 0x71, 0x07, 0xC0, 0x4F,
  0xFC, 0x01, 0x71, 0x07, 0xB0, 0xBF, 0xFC, 0x0B, 0x01, 0x71, 0x07, 0xA0, 0xE8, 0x0A, 0x87, 0xF8,
  0x1E, 0x73, 0x28, 0x13, 0x7E, 0xFF, 0xFA, 0x0A, 0x71, 0x0A, 0xFF, 0xF0, 0xA7, 0x30, 0xAF, 0xFD,
  0x0D, 0x75, 0x0E, 0xFF, 0xC0, 0x74, 0x82, 0x8D, 0xD8, 0x40, 0x7F, 0xFC, 0x02, 0x30, 0x8C, 0x08,
  0x30, 0x3F, 0xFC, 0x40, 0xDC, 0x0D, 0x30, 0x1F, 0xFC, 0x40, 0xDC, 0x0D, 0x30, 0x1F, 0xFC, 0x03,
  0x30, 0x8C, 0x08, 0x30, 0x3F, 0xFC, 0x07, 0x48, 0x28, 0xDD, 0x84, 0x08, 0xFF, 0xC0, 0xE7, 0x50,
  0x9F, 0xFD, 0x0A, 0x75, 0x0A, 0xFF, 0xD0, 0xA7, 0x50, 0xAF, 0xFD, 0x86, 0xE8, 0x31, 0x13, 0x99,
  0x40, 0x1F, 0xFF, 0xE0, 0xA4, 0xFF, 0xFF, 0x82, 0xA1, 0x09, 0x80, 0x98, 0x4F, 0x0D, 0xFF, 0xFF,
  0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xB8,
  0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_plagiarism() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_plagiarism_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_play_for_work 48x48, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_round_48_action_play_for_work_data[] PROGMEM = {
  0x73, 0x82, 0x4D, 0xD4, 0x77, 0x60, 0xDA, 0x0D, 0x77, 0x6C, 0x77, 0x6C, 0x77, 0x6C, 0x77, 0x6C,
  0x77, 0x6C, 0x77, 0x6C, 0x77, 0x6C, 0x77, 0x6C, 0x77, 0x6C, 0x77, 0x03, 0x0C, 0x80, 0x0D, 0xC8,
  0x00, 0xD0, 0xC0, 0x37, 0x10, 0x6F, 0xF0, 0x77, 0x20, 0xAF, 0xD0, 0xA7, 0x40, 0xAF, 0xB0, 0xA7,
  0x60, 0xAF, 0x90, 0xA7, 0x71, 0x0A, 0xE0, 0xA7, 0x73, 0x0A, 0xC0, 0xA7, 0x28, 0x22, 0xCE, 0x66,
  0x0A, 0xA0, 0xA6, 0x83, 0x6E, 0xC2, 0xAB, 0x01, 0x60, 0x08, 0x60, 0x1B, 0x00, 0xAB, 0x06, 0x77,
  0x06, 0xB0, 0xA0, 0x6B, 0x0C, 0x77, 0x0C, 0xB0, 0x60, 0x1C, 0x06, 0x75, 0x06, 0xC8, 0x11, 0x09,
  0xC0, 0x47, 0x30, 0x40, 0xEB, 0x09, 0x20, 0x10, 0xEB, 0x0E, 0x06, 0x71, 0x06, 0x0E, 0xB0, 0xE0,
  0x13, 0x05, 0xD8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xD0, 0x55, 0x06, 0xFF, 0xA0, 0x67, 0x05, 0x0E,
  0xFD, 0x0E, 0x05, 0x72, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x75, 0x89, 0x01, 0x6B, 0xDE, 0xED, 0xB6,
  0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_play_for_work() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 10, 35, 39), Box(0, 0, 47, 47),
      ic_round_48_action_play_for_work_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_polymer 48x48, 4-bit Alpha,  RLE, 294 bytes.
static const unsigned char ic_round_48_action_polymer_data[] PROGMEM = {
  0x71, 0x04, 0xF0, 0xB7, 0x40, 0x4F, 0x90, 0x47, 0x72, 0x0C, 0xF0, 0x27, 0x40, 0xDF, 0x90, 0xC7,
  0x71, 0x06, 0xF0, 0x97, 0x40, 0x8F, 0xB0, 0x67, 0x70, 0xEE, 0x0E, 0x01, 0x73, 0x03, 0xFC, 0x0E,
  0x76, 0x08, 0xF0, 0x77, 0x40, 0xCF, 0xD0, 0x87, 0x40, 0x1F, 0x0D, 0x74, 0x06, 0xFF, 0x01, 0x73,
  0x0A, 0xF0, 0x57, 0x30, 0x10, 0xEE, 0x0E, 0xF0, 0xA7, 0x20, 0x3F, 0x0C, 0x74, 0x0A, 0xF0, 0x40,
  0xCF, 0x03, 0x71, 0x0C, 0xF0, 0x37, 0x30, 0x4F, 0x81, 0xA0, 0x3F, 0x0C, 0x70, 0x5F, 0x0A, 0x74,
  0x0D, 0xE0, 0xE0, 0x12, 0x0A, 0xF0, 0x56, 0x0D, 0xF0, 0x17, 0x30, 0x8F, 0x06, 0x30, 0x2F, 0x0D,
  0x50, 0x7F, 0x08, 0x73, 0x03, 0xF0, 0xC5, 0x08, 0xF0, 0x73, 0x01, 0x0E, 0xE0, 0xE7, 0x40, 0xCF,
  0x03, 0x60, 0xEE, 0x0E, 0x01, 0x20, 0x9F, 0x06, 0x73, 0x06, 0xF0, 0x87, 0x06, 0xF8, 0x19, 0x02,
  0xF0, 0xC7, 0x30, 0x10, 0xEE, 0x0D, 0x72, 0x0C, 0xF0, 0x20, 0xBF, 0x04, 0x73, 0x0A, 0xF0, 0x47,
  0x20, 0x4F, 0x00, 0xBF, 0x04, 0x72, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0B, 0x02, 0xF0, 0xC7, 0x20,
  0xDE, 0x0E, 0x01, 0x73, 0x0C, 0xF8, 0x12, 0x09, 0xF0, 0x67, 0x08, 0xF0, 0x67, 0x30, 0x6F, 0x09,
  0x20, 0x10, 0xEE, 0x0E, 0x60, 0x3F, 0x0C, 0x74, 0x0E, 0xE0, 0xE0, 0x13, 0x07, 0xF0, 0x85, 0x0C,
  0xF0, 0x37, 0x30, 0x8F, 0x07, 0x50, 0xDF, 0x02, 0x30, 0x6F, 0x08, 0x73, 0x01, 0xF0, 0xD6, 0x05,
  0xF0, 0xA2, 0x01, 0x0E, 0xE0, 0xD7, 0x40, 0xAF, 0x05, 0x70, 0xCF, 0x81, 0x30, 0xAF, 0x04, 0x73,
  0x03, 0xF0, 0xC7, 0x10, 0x3F, 0x0C, 0x04, 0xF0, 0xA7, 0x40, 0xCF, 0x03, 0x72, 0x0A, 0xF0, 0xEE,
  0x0E, 0x01, 0x73, 0x05, 0xF0, 0xA7, 0x30, 0x1F, 0xF0, 0x67, 0x40, 0xDF, 0x01, 0x74, 0x08, 0xFD,
  0x0C, 0x74, 0x07, 0xF0, 0x87, 0x60, 0xEF, 0xC0, 0x37, 0x30, 0x10, 0xEE, 0x0E, 0x77, 0x06, 0xFB,
  0x08, 0x74, 0x09, 0xF0, 0x67, 0x71, 0x0C, 0xF9, 0x0D, 0x74, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF9,
  0x04, 0x74, 0x0B, 0xF0, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_polymer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 8, 46, 39), Box(0, 0, 47, 47),
      ic_round_48_action_polymer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_power_settings_new 48x48, 4-bit Alpha,  RLE, 262 bytes.
static const unsigned char ic_round_48_action_power_settings_new_data[] PROGMEM = {
  0x77, 0x28, 0x24, 0xDD, 0x47, 0x77, 0x74, 0x0D, 0xA0, 0xD7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7,
  0x77, 0x74, 0xC7, 0x76, 0x82, 0x19, 0xC6, 0x71, 0xC7, 0x18, 0x26, 0xC9, 0x17, 0x10, 0xBB, 0x02,
  0x7C, 0x70, 0x2B, 0x0B, 0x70, 0x7C, 0x03, 0x7C, 0x70, 0x3C, 0x08, 0x50, 0x3C, 0x0A, 0x71, 0xC7,
  0x10, 0xBC, 0x03, 0x40, 0xBB, 0x0D, 0x01, 0x71, 0xC7, 0x10, 0x10, 0xDB, 0x0C, 0x30, 0x4C, 0x03,
  0x72, 0xC7, 0x20, 0x3C, 0x04, 0x20, 0xBB, 0x0A, 0x73, 0xC7, 0x30, 0xAB, 0x81, 0xB0, 0x1C, 0x02,
  0x73, 0xC7, 0x30, 0x2C, 0x01, 0x05, 0xB0, 0xC7, 0x4C, 0x74, 0x0C, 0xB0, 0x50, 0x9B, 0x07, 0x74,
  0xC7, 0x40, 0x7B, 0x09, 0x0B, 0xB0, 0x37, 0x4C, 0x74, 0x03, 0xB0, 0xB0, 0xDB, 0x02, 0x74, 0xC7,
  0x40, 0x2B, 0x0D, 0xC7, 0x5C, 0x75, 0xB0, 0x0E, 0xB7, 0x50, 0xDA, 0x0D, 0x74, 0x01, 0xB0, 0xE0,
  0xDB, 0x02, 0x74, 0x82, 0x4D, 0xD4, 0x74, 0x02, 0xB0, 0xD0, 0xBB, 0x03, 0x77, 0x75, 0x04, 0xB0,
  0xB0, 0x9B, 0x07, 0x77, 0x75, 0x08, 0xB0, 0x90, 0x5B, 0x0C, 0x77, 0x75, 0x0C, 0xB0, 0x51, 0xC0,
  0x27, 0x77, 0x30, 0x3C, 0x81, 0x10, 0xBB, 0x0A, 0x77, 0x73, 0x0B, 0xB0, 0xB2, 0x03, 0xC0, 0x37,
  0x77, 0x10, 0x4C, 0x04, 0x30, 0xBB, 0x0D, 0x01, 0x77, 0x60, 0x10, 0xEB, 0x0B, 0x40, 0x3C, 0x0B,
  0x77, 0x60, 0xCC, 0x03, 0x50, 0x6C, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xCC, 0x08, 0x70, 0xAC, 0x0D,
  0x03, 0x77, 0x04, 0x0E, 0xC0, 0xB7, 0x20, 0xBD, 0x0A, 0x02, 0x73, 0x03, 0x0B, 0xD0, 0xC7, 0x40,
  0x9E, 0x89, 0x0C, 0x74, 0x21, 0x02, 0x47, 0xDE, 0x0B, 0x01, 0x75, 0x07, 0xFF, 0xE0, 0x87, 0x71,
  0x02, 0x0B, 0xFF, 0xA0, 0xB0, 0x37, 0x74, 0x04, 0x0A, 0xFD, 0x0B, 0x04, 0x77, 0x72, 0x89, 0x05,
  0x9B, 0xDF, 0xDD, 0xB9, 0x57, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_power_settings_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_power_settings_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_pregnant_woman 48x48, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_round_48_action_pregnant_woman_data[] PROGMEM = {
  0x38, 0x41, 0xAE, 0xEA, 0x17, 0x20, 0x10, 0xEC, 0x0E, 0x01, 0x71, 0x0A, 0xE0, 0xA7, 0x10, 0xDE,
  0x0D, 0x71, 0x0D, 0xE0, 0xD7, 0x10, 0xAE, 0x0A, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x28, 0x41,
  0xAE, 0xEA, 0x18, 0x0C, 0x60, 0x84, 0x6C, 0xEF, 0xC6, 0x72, 0x0B, 0xE0, 0xC0, 0x16, 0x0B, 0xF9,
  0x0C, 0x50, 0x5F, 0xB0, 0x64, 0x0B, 0xFB, 0x0C, 0x40, 0xEF, 0xB0, 0xE4, 0xFD, 0x0A, 0x02, 0x2F,
  0xE0, 0xE0, 0x21, 0xFF, 0x0D, 0x1F, 0xF9, 0x06, 0xFF, 0x90, 0xBF, 0xF9, 0x0E, 0x80, 0x9B, 0x4F,
  0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xD0, 0xD0, 0x44, 0xE7, 0x3E, 0x73, 0xE7, 0x3E, 0x73, 0xE7, 0x3E,
  0x73, 0xE7, 0x30, 0xDC, 0x0D, 0x73, 0x08, 0xC0, 0x87, 0x48, 0x28, 0xDD, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_pregnant_woman() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(16, 4, 31, 43), Box(0, 0, 47, 47),
      ic_round_48_action_pregnant_woman_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_preview 48x48, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_round_48_action_preview_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAA, 0x0F, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77,
  0x77, 0xF9, 0x77, 0x77, 0xF9, 0x72, 0x82, 0x27, 0xBD, 0xA8, 0x2D, 0xB7, 0x27, 0x2F, 0x97, 0x03,
  0x0B, 0xFB, 0x0B, 0x03, 0x7F, 0x96, 0x09, 0xFF, 0x09, 0x6F, 0x94, 0x01, 0x0C, 0xD0, 0xA0, 0x32,
  0x03, 0x0A, 0xD0, 0xC0, 0x14, 0xF9, 0x40, 0xCD, 0x07, 0x60, 0x7D, 0x0C, 0x4F, 0x93, 0x09, 0xD0,
  0xA2, 0x82, 0x8D, 0xD8, 0x20, 0xAD, 0x09, 0x3F, 0x92, 0x03, 0xE8, 0x13, 0x08, 0xC8, 0x18, 0x03,
  0xE0, 0x32, 0xF9, 0x20, 0xBE, 0x20, 0xDC, 0x0D, 0x2E, 0x0B, 0x2F, 0x92, 0x0B, 0xE2, 0x0D, 0xC0,
  0xD2, 0xE0, 0xB2, 0xF9, 0x20, 0x3E, 0x81, 0x30, 0x8C, 0x81, 0x80, 0x3E, 0x03, 0x2F, 0x93, 0x09,
  0xD0, 0xA2, 0x82, 0x8D, 0xD8, 0x20, 0xAD, 0x09, 0x3F, 0x94, 0x0C, 0xD0, 0x76, 0x07, 0xD0, 0xC4,
  0xF9, 0x40, 0x10, 0xCD, 0x0A, 0x03, 0x20, 0x30, 0xAD, 0x0C, 0x01, 0x4F, 0x96, 0x09, 0xFF, 0x09,
  0x6F, 0x97, 0x03, 0x0B, 0xFB, 0x0B, 0x03, 0x7F, 0x97, 0x28, 0x22, 0x7B, 0xDA, 0x82, 0xDB, 0x72,
  0x72, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xC0, 0xDF, 0xFF,
  0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF,
  0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_preview() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_preview_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_print 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_round_48_action_print_data[] PROGMEM = {
  0x71, 0x04, 0x0D, 0xFF, 0xE0, 0xD0, 0x47, 0x72, 0x0D, 0xFF, 0xF9, 0x0D, 0x77, 0x2F, 0xFF, 0xB7,
  0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x20, 0xDF, 0xFF, 0x90, 0xD7,
  0x72, 0x04, 0x0D, 0xFF, 0xE0, 0xD0, 0x48, 0x09, 0xA7, 0x08, 0x16, 0xCE, 0xFF, 0xFF, 0x81, 0xEC,
  0x64, 0x01, 0x0C, 0xFF, 0xFF, 0xE0, 0xC0, 0x12, 0x0C, 0x80, 0xC0, 0xF8, 0x1C, 0x06, 0x80, 0xC2,
  0xF0, 0x60, 0xCF, 0xFF, 0xFB, 0x82, 0xB1, 0x1B, 0xB0, 0xC0, 0xEF, 0xFF, 0xFB, 0x01, 0x20, 0x1B,
  0x0E, 0xFF, 0xFF, 0xC0, 0x12, 0x01, 0x80, 0xC0, 0xF8, 0x2B, 0x11, 0xB8, 0x0A, 0xD4, 0xF7, 0x72,
  0xFF, 0xFB, 0x77, 0x2F, 0xD0, 0xDF, 0xC7, 0x72, 0xFC, 0x0D, 0x0A, 0xFC, 0x77, 0x2F, 0xC8, 0x1A,
  0x1E, 0xFB, 0x77, 0x2F, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0x97, 0x72, 0xF9, 0x81, 0xDA, 0x17, 0x2C,
  0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x01, 0x77, 0x01, 0xC7, 0x72, 0xC0, 0xB0, 0x17,
  0x50, 0x10, 0xBC, 0x77, 0x20, 0xDF, 0xFF, 0x90, 0xD7, 0x72, 0x0A, 0xFF, 0xF9, 0x0A, 0x77, 0x20,
  0x10, 0xEF, 0xFE, 0x0E, 0x01, 0x77, 0x38, 0x11, 0xAD, 0xFF, 0xA8, 0x1D, 0xA1, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_print() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_print_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_privacy_tip 48x48, 4-bit Alpha,  RLE, 225 bytes.
static const unsigned char ic_round_48_action_privacy_tip_data[] PROGMEM = {
  0x77, 0x28, 0x24, 0x88, 0x47, 0x77, 0x72, 0x06, 0x0D, 0xC0, 0xD0, 0x67, 0x77, 0x48, 0x11, 0x8E,
  0xF9, 0x81, 0xE8, 0x17, 0x76, 0x03, 0x0A, 0xFF, 0x0A, 0x03, 0x77, 0x20, 0x50, 0xCF, 0xFC, 0x0C,
  0x05, 0x75, 0x06, 0x0D, 0xFF, 0xF9, 0x0D, 0x06, 0x78, 0x11, 0x8E, 0xFF, 0xFD, 0x81, 0xE8, 0x13,
  0x07, 0xFF, 0xFF, 0xC8, 0x17, 0x05, 0xFF, 0xFF, 0xE0, 0x50, 0xCF, 0xFF, 0xFE, 0x0C, 0x80, 0x9A,
  0x4F, 0x82, 0xB1, 0x1B, 0xFF, 0xFF, 0xC0, 0x12, 0x01, 0xFF, 0xFF, 0xC0, 0x12, 0x01, 0xFF, 0xFF,
  0xC8, 0x2B, 0x11, 0xB8, 0x0A, 0xB4, 0xF0, 0xEF, 0xF9, 0x82, 0xB1, 0x1B, 0xFF, 0x90, 0xE0, 0xDF,
  0xF9, 0x01, 0x20, 0x1F, 0xF9, 0x0D, 0x0C, 0xFF, 0x94, 0xFF, 0x90, 0xC0, 0xAF, 0xF9, 0x4F, 0xF9,
  0x0A, 0x08, 0xFF, 0x94, 0xFF, 0x90, 0x80, 0x4F, 0xF9, 0x4F, 0xF9, 0x04, 0x1F, 0xF9, 0x4F, 0xF9,
  0x20, 0xCF, 0xF4, 0xFF, 0x0C, 0x20, 0x7F, 0xF4, 0xFF, 0x07, 0x20, 0x10, 0xEF, 0xE4, 0xFE, 0x0E,
  0x01, 0x30, 0x9F, 0xE0, 0x12, 0x01, 0xFE, 0x09, 0x40, 0x2F, 0xE8, 0x2B, 0x11, 0xBF, 0xE0, 0x25,
  0x09, 0xFF, 0xFF, 0x09, 0x70, 0xDF, 0xFF, 0xD0, 0xD7, 0x10, 0x5F, 0xFF, 0xD0, 0x57, 0x20, 0x9F,
  0xFF, 0xB0, 0x97, 0x40, 0xBF, 0xFF, 0x90, 0xB7, 0x60, 0xCF, 0xFE, 0x0C, 0x77, 0x01, 0x0C, 0xFF,
  0xC0, 0xC0, 0x17, 0x72, 0x0A, 0xFF, 0xA0, 0xA7, 0x75, 0x07, 0xFF, 0x07, 0x77, 0x70, 0x20, 0xAF,
  0xB0, 0xA0, 0x27, 0x77, 0x30, 0x40, 0xCE, 0x0C, 0x04, 0x77, 0x77, 0x84, 0x27, 0xCC, 0x72, 0x77,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_privacy_tip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_round_48_action_privacy_tip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_private_connectivity 48x48, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_round_48_action_private_connectivity_data[] PROGMEM = {
  0x77, 0x18, 0x90, 0x37, 0xBD, 0xEE, 0xDB, 0x73, 0x77, 0x77, 0x05, 0x0C, 0xFB, 0x0C, 0x05, 0x77,
  0x73, 0x01, 0x0C, 0xFF, 0x0C, 0x01, 0x77, 0x70, 0x40, 0xEF, 0xFA, 0x0E, 0x04, 0x77, 0x50, 0x30,
  0xEF, 0xFC, 0x0E, 0x03, 0x77, 0x30, 0x20, 0xEF, 0x0D, 0x04, 0x20, 0x50, 0xDF, 0x0E, 0x02, 0x77,
  0x20, 0xBF, 0x0D, 0x01, 0x40, 0x10, 0xDF, 0x0B, 0x77, 0x10, 0x5F, 0x98, 0x65, 0x04, 0xDD, 0x40,
  0x6F, 0x90, 0x57, 0x70, 0xCF, 0x98, 0x11, 0x0D, 0xA8, 0x1D, 0x01, 0xF9, 0x0C, 0x76, 0x03, 0xFA,
  0x2C, 0x2F, 0xA0, 0x37, 0x50, 0x7F, 0xA2, 0xC2, 0xFA, 0x07, 0x75, 0x0B, 0xF0, 0xB0, 0x17, 0x10,
  0x10, 0xBF, 0x0B, 0x60, 0x40, 0xDF, 0xD0, 0x17, 0x30, 0x1F, 0xD8, 0x1D, 0x4D, 0xFE, 0x75, 0xFE,
  0x00, 0xDF, 0xE5, 0x00, 0x55, 0xFE, 0x81, 0xD4, 0xDF, 0xD4, 0x05, 0xA0, 0x54, 0xFD, 0x0D, 0x04,
  0x60, 0xBF, 0x40, 0x5A, 0x05, 0x4F, 0x0B, 0x75, 0x07, 0xF5, 0x00, 0x55, 0xF0, 0x77, 0x50, 0x3F,
  0x75, 0xF0, 0x37, 0x60, 0xCE, 0x01, 0x73, 0x01, 0xE0, 0xC7, 0x70, 0x5E, 0x0B, 0x01, 0x71, 0x01,
  0x0B, 0xE0, 0x57, 0x71, 0x0B, 0xFF, 0xF9, 0x0B, 0x77, 0x20, 0x20, 0xEF, 0xFE, 0x0E, 0x02, 0x77,
  0x30, 0x30, 0xEF, 0xFC, 0x0E, 0x03, 0x77, 0x50, 0x40, 0xEF, 0xFA, 0x0E, 0x04, 0x77, 0x70, 0x10,
  0xCF, 0xF0, 0xC0, 0x17, 0x77, 0x30, 0x50, 0xCF, 0xB0, 0xC0, 0x57, 0x77, 0x78, 0x90, 0x37, 0xBD,
  0xEE, 0xDB, 0x73, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_private_connectivity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_round_48_action_private_connectivity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_production_quantity_limits 48x48, 4-bit Alpha,  RLE, 301 bytes.
static const unsigned char ic_round_48_action_production_quantity_limits_data[] PROGMEM = {
  0x77, 0x68, 0x24, 0xDD, 0x48, 0x0C, 0x00, 0x0D, 0xA0, 0xD7, 0x72, 0x04, 0x0D, 0xC0, 0xC7, 0x6C,
  0x77, 0x20, 0xDE, 0x03, 0x75, 0xC7, 0x72, 0x0D, 0xE0, 0xB7, 0x5C, 0x77, 0x20, 0x40, 0xDE, 0x03,
  0x74, 0xC7, 0x76, 0x0B, 0xB0, 0xA7, 0x4C, 0x75, 0x01, 0x03, 0x60, 0x4C, 0x02, 0x73, 0xC7, 0x48,
  0x23, 0xEF, 0xC6, 0x0C, 0xB0, 0x97, 0x30, 0xDA, 0x0D, 0x74, 0x0C, 0xB0, 0x35, 0x05, 0xC0, 0x17,
  0x28, 0x24, 0xDD, 0x47, 0x30, 0x5C, 0x01, 0x60, 0xDB, 0x08, 0x77, 0x72, 0x0D, 0xB0, 0x97, 0x06,
  0xB0, 0xE0, 0x17, 0x77, 0x06, 0xC0, 0x27, 0x10, 0xDB, 0x07, 0x77, 0x70, 0xDB, 0x09, 0x72, 0x06,
  0xB0, 0xE7, 0x76, 0x07, 0xB0, 0xE0, 0x17, 0x30, 0xEB, 0x07, 0x78, 0x24, 0xDD, 0x47, 0x10, 0xEB,
  0x08, 0x74, 0x07, 0xB0, 0xD7, 0x0D, 0xA0, 0xD7, 0x08, 0xB0, 0xE0, 0x17, 0x40, 0x10, 0xEB, 0x06,
  0x60, 0xDA, 0x0D, 0x60, 0x10, 0xEB, 0x07, 0x76, 0x08, 0xB0, 0xD6, 0x82, 0x4D, 0xD4, 0x60, 0x8B,
  0x0D, 0x77, 0x01, 0xC0, 0x57, 0x70, 0x2C, 0x06, 0x77, 0x10, 0x9B, 0x0C, 0x77, 0x09, 0xB0, 0xD7,
  0x72, 0x02, 0xFF, 0xF9, 0x05, 0x77, 0x30, 0xEF, 0xFE, 0x0C, 0x77, 0x30, 0x8F, 0xFE, 0x0E, 0x03,
  0x77, 0x20, 0x10, 0xEF, 0xFC, 0x81, 0xEB, 0x37, 0x73, 0x09, 0xB0, 0xD7, 0x77, 0x76, 0x03, 0xC0,
  0x57, 0x77, 0x76, 0x0A, 0xB0, 0xC7, 0x77, 0x77, 0x0E, 0xB0, 0x47, 0x77, 0x77, 0x0E, 0xFF, 0xFC,
  0x0D, 0x04, 0x75, 0x0A, 0xFF, 0xFD, 0x0D, 0x75, 0x02, 0x0E, 0xFF, 0xFC, 0x0D, 0x76, 0x81, 0x2A,
  0xEF, 0xFF, 0x90, 0xD0, 0x48, 0x09, 0xB1, 0x08, 0x41, 0xAD, 0xDA, 0x17, 0x78, 0x41, 0xAD, 0xDA,
  0x17, 0x60, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x50, 0x9E, 0x0A, 0x75,
  0x09, 0xE0, 0xA7, 0x50, 0xDE, 0x0D, 0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xDE, 0x0D, 0x75, 0x0D, 0xE0,
  0xD7, 0x50, 0x9E, 0x0A, 0x75, 0x09, 0xE0, 0xA7, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x01, 0x0E,
  0xC0, 0xE0, 0x17, 0x68, 0x41, 0xAD, 0xDA, 0x17, 0x78, 0x41, 0xAD, 0xDA, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_production_quantity_limits() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_production_quantity_limits_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_published_with_changes 48x48, 4-bit Alpha,  RLE, 379 bytes.
static const unsigned char ic_round_48_action_published_with_changes_data[] PROGMEM = {
  0x77, 0x72, 0x81, 0x67, 0x27, 0x73, 0x05, 0xFA, 0x0B, 0x71, 0x0A, 0xB8, 0x1D, 0x81, 0x77, 0x05,
  0xFB, 0x71, 0x0E, 0xD8, 0x1E, 0x81, 0x76, 0x07, 0xFA, 0x71, 0x0A, 0xF0, 0xE0, 0x47, 0x60, 0x7F,
  0x97, 0x20, 0x50, 0xBF, 0x08, 0x76, 0x0D, 0xF7, 0x50, 0x60, 0xED, 0x0A, 0x74, 0x0A, 0xF9, 0x77,
  0x07, 0xD0, 0xA7, 0x20, 0x8F, 0xA7, 0x71, 0x03, 0x0D, 0xC0, 0x87, 0x04, 0xC0, 0xD0, 0x8C, 0x77,
  0x20, 0x10, 0xDC, 0x04, 0x50, 0x10, 0xDB, 0x82, 0xE2, 0x07, 0xB7, 0x73, 0x01, 0x0D, 0xB0, 0xD0,
  0x14, 0x08, 0xC0, 0x33, 0x07, 0xA7, 0x74, 0x03, 0xC0, 0x83, 0x01, 0x0E, 0xB0, 0x85, 0x00, 0x57,
  0x75, 0x07, 0xB0, 0xE0, 0x12, 0x07, 0xB0, 0xE0, 0x17, 0x77, 0x60, 0xDB, 0x07, 0x20, 0xDB, 0x06,
  0x77, 0x78, 0x19, 0xD9, 0x40, 0x6B, 0x81, 0xD0, 0x3C, 0x01, 0x77, 0x60, 0xBB, 0x05, 0x40, 0xEB,
  0x02, 0x07, 0xB0, 0xB7, 0x76, 0x0B, 0xC0, 0x54, 0x0A, 0xB0, 0x60, 0xAB, 0x06, 0x77, 0x50, 0xBC,
  0x0C, 0x50, 0x6B, 0x0A, 0x0C, 0xB0, 0x47, 0x74, 0x0B, 0xC0, 0xC0, 0x15, 0x03, 0xB0, 0xC0, 0xEB,
  0x02, 0x60, 0x37, 0x30, 0xBC, 0x0C, 0x01, 0x60, 0x2B, 0x0D, 0xC5, 0x83, 0x1D, 0xFE, 0x37, 0x0B,
  0xC0, 0xC0, 0x17, 0x1B, 0x00, 0xEB, 0x50, 0x6B, 0x0E, 0x03, 0x50, 0xBC, 0x0C, 0x01, 0x72, 0xC0,
  0xDB, 0x02, 0x40, 0x4C, 0x0E, 0x03, 0x30, 0xBC, 0x0C, 0x01, 0x72, 0x02, 0xB0, 0xE0, 0xCB, 0x03,
  0x50, 0x8C, 0x82, 0xE3, 0x0B, 0xC0, 0xC0, 0x17, 0x30, 0x4B, 0x0C, 0x0A, 0xB0, 0x66, 0x08, 0xC0,
  0xE0, 0xCC, 0x0C, 0x01, 0x74, 0x06, 0xB0, 0xA0, 0x6B, 0x0A, 0x70, 0x8F, 0x90, 0xC0, 0x17, 0x50,
  0xBB, 0x07, 0x02, 0xB0, 0xE7, 0x10, 0x8E, 0x0C, 0x01, 0x75, 0x01, 0xC8, 0x13, 0x0D, 0xB0, 0x67,
  0x10, 0x8C, 0x0C, 0x01, 0x76, 0x06, 0xB0, 0xD2, 0x07, 0xB0, 0xD7, 0x20, 0x7A, 0x0C, 0x01, 0x76,
  0x01, 0x0E, 0xB0, 0x72, 0x01, 0x0E, 0xB0, 0x77, 0x20, 0x30, 0x47, 0x10, 0x05, 0x50, 0x8B, 0x0E,
  0x01, 0x30, 0x8C, 0x03, 0x77, 0x4A, 0x07, 0x30, 0x3C, 0x08, 0x40, 0x10, 0xDB, 0x0D, 0x01, 0x77,
  0x3B, 0x82, 0x70, 0x2E, 0xB0, 0xD0, 0x15, 0x04, 0xC0, 0xD0, 0x17, 0x72, 0xC0, 0x80, 0xDC, 0x04,
  0x70, 0x8C, 0x0D, 0x03, 0x77, 0x1F, 0xA0, 0x87, 0x20, 0xAD, 0x07, 0x77, 0xF9, 0x0A, 0x74, 0x0A,
  0xD0, 0xE0, 0x67, 0x5F, 0x0D, 0x76, 0x08, 0xF0, 0xB0, 0x57, 0x2F, 0x90, 0x77, 0x60, 0x40, 0xEF,
  0x0A, 0x71, 0xFA, 0x07, 0x76, 0x81, 0x18, 0xED, 0x0E, 0x71, 0xFB, 0x05, 0x77, 0x81, 0x18, 0xDB,
  0x0A, 0x71, 0x0B, 0xFA, 0x05, 0x77, 0x38, 0x12, 0x76, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_published_with_changes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_published_with_changes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_query_builder 48x48, 4-bit Alpha,  RLE, 344 bytes.
static const unsigned char ic_round_48_action_query_builder_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xBD, 0x0D, 0x06, 0x75, 0x06,
  0x0D, 0xD0, 0xA7, 0x40, 0xBD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x37, 0x74,
  0x03, 0x0D, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xD0, 0x17, 0x77, 0x10, 0x10, 0xDB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x73, 0x81, 0x8F, 0x87, 0x40,
  0x3C, 0x09, 0x30, 0x1C, 0x07, 0x74, 0xB7, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0D, 0x75, 0xB7, 0x60,
  0xDB, 0x08, 0x20, 0xDB, 0x06, 0x75, 0xB7, 0x60, 0x6B, 0x81, 0xD0, 0x3C, 0x76, 0xB7, 0x7C, 0x03,
  0x07, 0xB0, 0xB7, 0x6B, 0x77, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x76, 0xB7, 0x70, 0x6B, 0x0A, 0x0C,
  0xB0, 0x37, 0x6B, 0x77, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x76, 0xB7, 0x70, 0x2B, 0x0E, 0xC7, 0x7B,
  0x77, 0x1F, 0x97, 0x7B, 0x03, 0x77, 0xC0, 0xEB, 0x02, 0x76, 0x0C, 0xB0, 0x90, 0x17, 0x40, 0x2B,
  0x0E, 0x0C, 0xB0, 0x37, 0x60, 0x20, 0xDB, 0x0E, 0x06, 0x73, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x77,
  0x10, 0x7C, 0x0C, 0x03, 0x71, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x77, 0x20, 0x20, 0xBC, 0x09, 0x01,
  0x60, 0xBB, 0x07, 0x03, 0xC7, 0x74, 0x04, 0x0D, 0xB0, 0xE0, 0x25, 0xC8, 0x13, 0x0D, 0xB0, 0x67,
  0x75, 0x07, 0xB0, 0x64, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xD7, 0x76, 0x81, 0x29, 0xA5, 0x0D, 0xB0,
  0x82, 0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x94,
  0x01, 0x0E, 0xB0, 0xD0, 0x17, 0x77, 0x10, 0x10, 0xDB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77,
  0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0D, 0x03, 0x77, 0x40, 0x30, 0xDC, 0x09, 0x72, 0x0B, 0xD0,
  0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xBD, 0x0D, 0x06, 0x75, 0x06, 0x0D, 0xD0, 0xA7, 0x60, 0x9F,
  0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77,
  0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48,
  0x33, 0x7A, 0xCE, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_query_builder() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_query_builder_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_question_answer 48x48, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_round_48_action_question_answer_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xF9, 0x81, 0xDA, 0x17, 0x40, 0x10, 0xEF, 0xFF, 0xD0, 0xE0, 0x17, 0x30,
  0xAF, 0xFF, 0xF0, 0xA7, 0x30, 0xDF, 0xFF, 0xF0, 0xD7, 0x3F, 0xFF, 0xFA, 0x73, 0xFF, 0xFF, 0xA7,
  0x3F, 0xFF, 0xFA, 0x73, 0xFF, 0xFF, 0xA7, 0x3F, 0xFF, 0xFA, 0x4A, 0x81, 0xDA, 0x11, 0xFF, 0xFF,
  0xA4, 0xC0, 0xE0, 0x1F, 0xFF, 0xFA, 0x4D, 0x0A, 0xFF, 0xFF, 0xA4, 0xD0, 0xDF, 0xFF, 0xFA, 0x48,
  0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x4F, 0xFF,
  0xFF, 0x0D, 0x4F, 0xFF, 0xFF, 0x0A, 0x4F, 0xFF, 0xFE, 0x0E, 0x01, 0x4F, 0xFF, 0xFC, 0x81, 0xDA,
  0x15, 0xFE, 0x07, 0x77, 0x75, 0xFD, 0x07, 0x77, 0x76, 0xFC, 0x07, 0x77, 0x76, 0x01, 0xFB, 0x07,
  0x77, 0x76, 0x01, 0x0B, 0xFA, 0x07, 0x4F, 0xFF, 0xFE, 0x07, 0x5F, 0xFF, 0xFD, 0x07, 0x60, 0xDF,
  0xFF, 0xFB, 0x07, 0x70, 0xAF, 0xFF, 0xFB, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA7, 0x28, 0x11, 0xAD,
  0xFF, 0xFF, 0x77, 0x77, 0x40, 0x7F, 0x77, 0x77, 0x50, 0x7E, 0x77, 0x77, 0x60, 0x7D, 0x77, 0x77,
  0x70, 0x7C, 0x80, 0xC0, 0x00, 0x7B, 0x80, 0xC1, 0x00, 0x7A, 0x80, 0xC2, 0x00, 0x79, 0x80, 0xC3,
  0x00, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_question_answer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_question_answer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_question_mark 48x48, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_round_48_action_question_mark_data[] PROGMEM = {
  0x58, 0x21, 0x7B, 0xDA, 0x82, 0xDB, 0x83, 0x72, 0x01, 0x09, 0xFB, 0x0C, 0x03, 0x60, 0x30, 0xDF,
  0xE0, 0x74, 0x03, 0xFF, 0xA0, 0x82, 0x02, 0x0E, 0xFF, 0xB8, 0x14, 0x0A, 0xE8, 0x4E, 0x97, 0x79,
  0xDE, 0x81, 0xC0, 0xDD, 0x0A, 0x01, 0x50, 0x7E, 0x04, 0x0A, 0xC0, 0xA7, 0x10, 0x8D, 0x81, 0x81,
  0xCA, 0x0B, 0x72, 0x01, 0xD0, 0xB2, 0x00, 0x37, 0x40, 0xDC, 0x0D, 0x77, 0x10, 0xCC, 0x0D, 0x77,
  0x1D, 0x0C, 0x77, 0x07, 0xD0, 0x87, 0x60, 0x3E, 0x03, 0x75, 0x02, 0x0E, 0xD0, 0xA7, 0x50, 0x30,
  0xED, 0x0D, 0x75, 0x03, 0x0E, 0xD0, 0xE0, 0x27, 0x40, 0x30, 0xED, 0x0E, 0x03, 0x74, 0x01, 0x0D,
  0xD0, 0xE0, 0x47, 0x50, 0xAE, 0x04, 0x75, 0x02, 0xE0, 0x67, 0x60, 0x7D, 0x0A, 0x77, 0x0A, 0xD0,
  0x47, 0x70, 0xAD, 0x77, 0x10, 0x5C, 0x09, 0x77, 0x28, 0x26, 0xDE, 0x98, 0x09, 0xC0, 0x08, 0x41,
  0xAD, 0xDA, 0x17, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x76, 0x0A, 0xE0, 0xA7, 0x60, 0xDE, 0x0D, 0x76,
  0x0D, 0xE0, 0xD7, 0x60, 0xAE, 0x0A, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x78, 0x41, 0xAD, 0xDA,
  0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_question_mark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 6, 34, 43), Box(0, 0, 47, 47),
      ic_round_48_action_question_mark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_quickreply 48x48, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_round_48_action_quickreply_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x20, 0x10, 0xE8, 0x0C, 0x0F, 0x82, 0xE1, 0x09,
  0x80, 0xC2, 0xF8, 0x1A, 0x0D, 0x80, 0xC2, 0xF0, 0xD1, 0x80, 0xC4, 0xF1, 0x80, 0xC4, 0xF1, 0x80,
  0xC4, 0xF1, 0x80, 0xC4, 0xF1, 0x80, 0xC4, 0xF1, 0x80, 0xC4, 0xF1, 0x80, 0xC4, 0xF1, 0x80, 0xC4,
  0xF1, 0x80, 0xC4, 0xF1, 0x80, 0xC4, 0xF1, 0x80, 0xC4, 0xF1, 0x80, 0xC4, 0xF1, 0xFF, 0xFD, 0x0B,
  0x01, 0x76, 0xFF, 0xFD, 0x01, 0x77, 0xFF, 0xFD, 0x77, 0x1F, 0xFF, 0xD7, 0x71, 0xFF, 0xFD, 0x40,
  0xBF, 0x0E, 0x04, 0x1F, 0xFF, 0xD4, 0xFA, 0x05, 0x1F, 0xFF, 0xD4, 0xF9, 0x0E, 0x2F, 0xFF, 0xD4,
  0xF9, 0x07, 0x2F, 0xFF, 0xD4, 0xF9, 0x01, 0x2F, 0xFF, 0xD4, 0xF0, 0xA3, 0xFF, 0xFD, 0x4F, 0x03,
  0x3F, 0xFF, 0xD4, 0xE0, 0xC4, 0xFF, 0xFD, 0x4F, 0xA0, 0xE0, 0x2F, 0xFF, 0xD4, 0xFB, 0x03, 0xFF,
  0xFD, 0x4F, 0xA0, 0xB1, 0xFF, 0xFD, 0x40, 0xBF, 0x90, 0x31, 0xF0, 0x77, 0x77, 0x5C, 0x0B, 0x2E,
  0x07, 0x77, 0x76, 0xC0, 0x32, 0xD0, 0x77, 0x77, 0x7B, 0x0B, 0x3C, 0x07, 0x77, 0x77, 0x1B, 0x03,
  0x3B, 0x07, 0x77, 0x77, 0x2A, 0x0B, 0x4A, 0x07, 0x77, 0x77, 0x3A, 0x03, 0x49, 0x07, 0x77, 0x77,
  0x49, 0x0B, 0x50, 0x77, 0x77, 0x75, 0x90, 0x38, 0x0C, 0x30, 0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_quickreply() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 44, 44), Box(0, 0, 47, 47),
      ic_round_48_action_quickreply_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_receipt 48x48, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_round_48_action_receipt_data[] PROGMEM = {
  0x05, 0x40, 0x05, 0x40, 0x05, 0x40, 0x05, 0x40, 0x05, 0x40, 0x05, 0x48, 0x15, 0xF7, 0x20, 0x7A,
  0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7B, 0x00,
  0x9C, 0x00, 0x9C, 0x00, 0x9C, 0x00, 0x9C, 0x00, 0x9C, 0x00, 0x98, 0x0C, 0x80, 0xF0, 0xB0, 0x17,
  0x76, 0x01, 0x0B, 0xFD, 0x01, 0x77, 0x71, 0x01, 0xFD, 0x01, 0x77, 0x71, 0x01, 0xFD, 0x0B, 0x01,
  0x77, 0x60, 0x10, 0xB8, 0x0A, 0xB0, 0xF0, 0xB0, 0x17, 0x76, 0x01, 0x0B, 0xFD, 0x01, 0x77, 0x71,
  0x01, 0xFD, 0x01, 0x77, 0x71, 0x01, 0xFD, 0x0B, 0x01, 0x77, 0x60, 0x10, 0xB8, 0x0A, 0xB0, 0xF0,
  0xB0, 0x17, 0x76, 0x01, 0x0B, 0xFD, 0x01, 0x77, 0x71, 0x01, 0xFD, 0x01, 0x77, 0x71, 0x01, 0xFD,
  0x0B, 0x01, 0x77, 0x60, 0x10, 0xB8, 0x0C, 0x80, 0xF0, 0x0A, 0xC0, 0x0A, 0xC0, 0x0A, 0xC0, 0x0A,
  0xC0, 0x0A, 0xC0, 0x0A, 0xB0, 0x72, 0x08, 0xA0, 0x72, 0x08, 0xA0, 0x72, 0x08, 0xA0, 0x72, 0x08,
  0xA0, 0x72, 0x08, 0xA0, 0x72, 0x81, 0x8F, 0x64, 0x00, 0x54, 0x00, 0x54, 0x00, 0x54, 0x00, 0x54,
  0x00, 0x54, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_receipt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_receipt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_record_voice_over 48x48, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_round_48_action_record_voice_over_data[] PROGMEM = {
  0x80, 0xC0, 0x08, 0x24, 0xCC, 0x48, 0x0C, 0x30, 0x01, 0xC0, 0x38, 0x0C, 0x20, 0x04, 0xC0, 0xC8,
  0x0C, 0x20, 0x01, 0x0E, 0xC0, 0x78, 0x0C, 0x20, 0x06, 0xC0, 0xE7, 0x78, 0x62, 0x8C, 0xEE, 0xC8,
  0x27, 0x73, 0x0C, 0xC0, 0x67, 0x50, 0x9F, 0x90, 0x97, 0x72, 0x05, 0xC0, 0xC7, 0x40, 0xBF, 0xB0,
  0xB7, 0x82, 0x3C, 0xD7, 0x50, 0xEC, 0x02, 0x72, 0x09, 0xFD, 0x09, 0x50, 0x10, 0xEB, 0x05, 0x40,
  0x9C, 0x05, 0x71, 0x02, 0xFF, 0x02, 0x40, 0x3C, 0x0C, 0x40, 0x5C, 0x09, 0x71, 0x08, 0xFF, 0x08,
  0x40, 0x1D, 0x02, 0x30, 0x2C, 0x0C, 0x71, 0x0C, 0xFF, 0x0C, 0x50, 0xCC, 0x05, 0x30, 0x1C, 0x0D,
  0x71, 0x0E, 0xFF, 0x0E, 0x50, 0x9C, 0x07, 0x4C, 0x0E, 0x71, 0x0E, 0xFF, 0x0E, 0x50, 0x9C, 0x07,
  0x4C, 0x0E, 0x71, 0x0C, 0xFF, 0x0C, 0x50, 0xCC, 0x05, 0x30, 0x1C, 0x0D, 0x71, 0x08, 0xFF, 0x08,
  0x40, 0x1D, 0x03, 0x30, 0x3C, 0x0C, 0x71, 0x02, 0xFF, 0x02, 0x40, 0x3C, 0x0D, 0x40, 0x6C, 0x0A,
  0x72, 0x09, 0xFD, 0x09, 0x60, 0xEB, 0x07, 0x40, 0xAC, 0x06, 0x73, 0x0B, 0xFB, 0x0B, 0x78, 0x23,
  0xCD, 0x84, 0x01, 0x0E, 0xC0, 0x27, 0x40, 0x9F, 0x90, 0x97, 0x72, 0x06, 0xC0, 0xD7, 0x68, 0x62,
  0x8C, 0xEE, 0xC8, 0x27, 0x73, 0x0D, 0xC0, 0x68, 0x0C, 0x10, 0x08, 0xC0, 0xE8, 0x0C, 0x10, 0x01,
  0xD0, 0x78, 0x0C, 0x10, 0x05, 0xC0, 0xC8, 0x0C, 0x20, 0x01, 0xC0, 0x37, 0x58, 0x41, 0x48, 0xAC,
  0xDA, 0x84, 0xDC, 0xA8, 0x41, 0x76, 0x82, 0x4C, 0xC4, 0x73, 0x81, 0x27, 0xCF, 0xF8, 0x1C, 0x72,
  0x77, 0x71, 0x04, 0x0B, 0xFF, 0xE0, 0xB0, 0x47, 0x74, 0x01, 0x0B, 0xFF, 0xFB, 0x0B, 0x01, 0x77,
  0x10, 0x40, 0xEF, 0xFF, 0xD0, 0xE0, 0x47, 0x60, 0x20, 0xEF, 0xFF, 0xF0, 0xE0, 0x27, 0x50, 0xAF,
  0xFF, 0xFA, 0x0A, 0x75, 0x0E, 0xFF, 0xFF, 0xA0, 0xE7, 0x5F, 0xFF, 0xFC, 0x75, 0xFF, 0xFF, 0xC7,
  0x50, 0xDF, 0xFF, 0xFA, 0x0D, 0x75, 0x04, 0x0D, 0xFF, 0xFF, 0x0D, 0x04, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_record_voice_over() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_record_voice_over_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_redeem 48x48, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_round_48_action_redeem_data[] PROGMEM = {
  0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x68, 0x46, 0xCE, 0xEC, 0x67, 0x76, 0x01, 0x0C, 0xE0, 0xC0, 0x12,
  0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x74, 0x0C, 0xF9, 0x0C, 0x20, 0xCF, 0x90, 0xC7, 0x73, 0x06, 0xFB,
  0x00, 0x9F, 0xB0, 0x67, 0x72, 0x0C, 0xB8, 0x2B, 0x11, 0xBF, 0x98, 0x2B, 0x11, 0xBB, 0x0C, 0x77,
  0x20, 0xEB, 0x01, 0x20, 0x1F, 0x90, 0x12, 0x01, 0xB0, 0xE7, 0x72, 0x0E, 0xB0, 0x12, 0x01, 0xF9,
  0x01, 0x20, 0x1B, 0x0E, 0x77, 0x20, 0xBB, 0x82, 0xB1, 0x1B, 0xF9, 0x82, 0xB1, 0x1B, 0xB0, 0xB7,
  0x28, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0xFF, 0xC0, 0x07, 0xFF, 0xC0, 0xDC, 0x0B, 0x01, 0x70, 0x3C, 0x0B, 0x20, 0xBC,
  0x03, 0x70, 0x10, 0xBF, 0x90, 0x17, 0x01, 0x0D, 0xB0, 0xE0, 0x12, 0x01, 0x0E, 0xB0, 0xD0, 0x17,
  0x01, 0xF9, 0x71, 0x0A, 0xC0, 0x44, 0x04, 0xC0, 0xA7, 0x1F, 0x97, 0x06, 0xC0, 0x86, 0x08, 0xC0,
  0x67, 0xF9, 0x70, 0xEB, 0x0C, 0x71, 0x0C, 0xB0, 0xE7, 0xF9, 0x60, 0x1B, 0x0E, 0x02, 0x71, 0x02,
  0x0E, 0xB0, 0x16, 0xF9, 0x70, 0x9A, 0x04, 0x73, 0x04, 0xA0, 0x97, 0xF9, 0x71, 0x00, 0x17, 0x50,
  0x01, 0x71, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0x80, 0xBE, 0x4F, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x01, 0x77, 0x77, 0x20, 0x1F, 0x90,
  0xB0, 0x17, 0x77, 0x70, 0x10, 0xBC, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1,
  0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAE, 0xFF, 0xFF, 0xC8, 0x1E, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_redeem() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_redeem_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_remove_done 48x48, 4-bit Alpha,  RLE, 359 bytes.
static const unsigned char ic_round_48_action_remove_done_data[] PROGMEM = {
  0x60, 0x28, 0x0C, 0x50, 0x82, 0xBF, 0xE3, 0x80, 0xC2, 0x00, 0x3B, 0x0E, 0x03, 0x80, 0xC1, 0x00,
  0x2C, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x6C, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x6C, 0x0E, 0x03, 0x80,
  0xC1, 0x00, 0x6C, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x6C, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x6C, 0x0E,
  0x03, 0x75, 0x00, 0x17, 0x30, 0x17, 0x50, 0x6C, 0x0E, 0x03, 0x73, 0x82, 0x9F, 0xE4, 0x78, 0x25,
  0xEF, 0x87, 0x50, 0x6C, 0x0E, 0x03, 0x71, 0x09, 0xB0, 0xC6, 0x05, 0xC0, 0x17, 0x50, 0x6C, 0x0E,
  0x03, 0x60, 0x9C, 0x0A, 0x50, 0x5C, 0x0E, 0x77, 0x06, 0xC0, 0xE0, 0x34, 0x02, 0x0E, 0xB0, 0xD0,
  0x14, 0x05, 0xD0, 0x57, 0x71, 0x06, 0xC0, 0xE0, 0x34, 0x83, 0x3E, 0xFD, 0x14, 0x05, 0xD0, 0x57,
  0x73, 0x06, 0xC0, 0xE0, 0x34, 0x81, 0x3C, 0x14, 0x05, 0xD0, 0x57, 0x75, 0x06, 0xC0, 0xE0, 0x37,
  0x20, 0x5D, 0x05, 0x77, 0x70, 0x6C, 0x0E, 0x03, 0x70, 0x5D, 0x05, 0x77, 0x72, 0x06, 0xC0, 0xE0,
  0x35, 0x05, 0xD0, 0x57, 0x00, 0x27, 0x20, 0x10, 0x35, 0x06, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xB0,
  0x57, 0x07, 0xA0, 0x87, 0x83, 0x3E, 0xFC, 0x14, 0x06, 0xC0, 0xE0, 0x34, 0x82, 0x3E, 0xF5, 0x71,
  0x0E, 0xB0, 0x96, 0x09, 0xB0, 0xC0, 0x14, 0x06, 0xC0, 0xE0, 0x34, 0x03, 0x05, 0x72, 0x0C, 0xC0,
  0x95, 0x07, 0xC0, 0xC0, 0x14, 0x06, 0xC0, 0xE0, 0x37, 0x70, 0x20, 0xDC, 0x09, 0x50, 0xAC, 0x0D,
  0x01, 0x40, 0x6C, 0x0E, 0x03, 0x77, 0x02, 0x0D, 0xC0, 0x95, 0x0A, 0xC0, 0xD0, 0x14, 0x09, 0xC0,
  0xE0, 0x37, 0x70, 0x20, 0xDC, 0x09, 0x50, 0xAC, 0x0D, 0x01, 0x20, 0x5E, 0x0E, 0x03, 0x77, 0x02,
  0x0D, 0xC0, 0x95, 0x0A, 0xC8, 0x1D, 0x15, 0xF9, 0x0E, 0x03, 0x77, 0x02, 0x0D, 0xC0, 0x95, 0x0A,
  0xC0, 0xDD, 0x09, 0xC0, 0xE0, 0x37, 0x70, 0x20, 0xDC, 0x09, 0x50, 0xAF, 0x98, 0x14, 0x06, 0xC0,
  0xE0, 0x37, 0x70, 0x20, 0xDC, 0x09, 0x50, 0xAE, 0x04, 0x30, 0x6C, 0x0E, 0x03, 0x77, 0x02, 0x0D,
  0xB0, 0xD0, 0x15, 0x0A, 0xC0, 0x45, 0x06, 0xC0, 0xE0, 0x37, 0x78, 0x32, 0xDF, 0xD1, 0x78, 0x2A,
  0xFE, 0x47, 0x06, 0xC0, 0xE0, 0x37, 0x78, 0x12, 0xB1, 0x72, 0x01, 0x73, 0x06, 0xC0, 0xE0, 0x38,
  0x0C, 0x10, 0x06, 0xC0, 0xE0, 0x38, 0x0C, 0x10, 0x06, 0xC0, 0xE0, 0x38, 0x0C, 0x10, 0x06, 0xC0,
  0xE0, 0x38, 0x0C, 0x10, 0x06, 0xC0, 0xE0, 0x28, 0x0C, 0x10, 0x06, 0xC0, 0x88, 0x0C, 0x20, 0x06,
  0xB0, 0x68, 0x0C, 0x30, 0x81, 0x4A, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_remove_done() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 45, 42), Box(0, 0, 47, 47),
      ic_round_48_action_remove_done_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_remove_shopping_cart 48x48, 4-bit Alpha,  RLE, 367 bytes.
static const unsigned char ic_round_48_action_remove_shopping_cart_data[] PROGMEM = {
  0x18, 0x25, 0xDB, 0x28, 0x0C, 0x50, 0xB0, 0xE0, 0x28, 0x0C, 0x30, 0x01, 0xC0, 0xE0, 0x28, 0x0C,
  0x30, 0x08, 0xC0, 0xE0, 0x28, 0x0C, 0x30, 0x08, 0xC0, 0xE0, 0x28, 0x0C, 0x30, 0x08, 0xC0, 0xE0,
  0x24, 0x04, 0xFF, 0xFC, 0x0D, 0x04, 0x70, 0x8C, 0x0E, 0x02, 0x40, 0x4F, 0xFF, 0xC0, 0xD7, 0x10,
  0x8C, 0x0E, 0x02, 0x40, 0x4F, 0xFF, 0xB0, 0xD7, 0x20, 0x8C, 0x0E, 0x02, 0x40, 0x4F, 0xFF, 0xA0,
  0x77, 0x30, 0x8C, 0x0E, 0x02, 0x40, 0x4F, 0xFF, 0x0D, 0x75, 0x08, 0xC0, 0xE0, 0x24, 0x04, 0xFF,
  0xE0, 0x57, 0x60, 0xDC, 0x0E, 0x02, 0x40, 0x4F, 0xFC, 0x0C, 0x77, 0x06, 0xD0, 0xE0, 0x24, 0x04,
  0xFF, 0xB0, 0x37, 0x71, 0x0E, 0xD0, 0xE0, 0x24, 0x04, 0xFF, 0x90, 0xA7, 0x72, 0x07, 0xE0, 0xE0,
  0x24, 0x04, 0xFF, 0x02, 0x77, 0x20, 0x10, 0xEE, 0x0E, 0x02, 0x40, 0x4F, 0xD0, 0x97, 0x74, 0x08,
  0xF0, 0xE0, 0x24, 0x04, 0xFB, 0x0E, 0x01, 0x77, 0x40, 0x1F, 0x90, 0xE0, 0x24, 0x04, 0xFA, 0x07,
  0x77, 0x60, 0x9F, 0x90, 0xE0, 0x24, 0x04, 0xF0, 0xD7, 0x77, 0x02, 0xFA, 0x0E, 0x02, 0x40, 0x4E,
  0x06, 0x77, 0x70, 0x10, 0xEF, 0xA0, 0xE0, 0x24, 0x04, 0xC0, 0xC7, 0x77, 0x10, 0x8F, 0xC0, 0xE0,
  0x24, 0x04, 0xA0, 0xE0, 0x37, 0x77, 0x01, 0xFE, 0x0E, 0x02, 0x48, 0x14, 0xB3, 0x77, 0x71, 0x09,
  0xB0, 0xD5, 0x08, 0xC0, 0xE0, 0x27, 0x77, 0x60, 0x3C, 0x05, 0x60, 0x8C, 0x0E, 0x02, 0x77, 0x75,
  0x0A, 0xB0, 0xC7, 0x10, 0x8C, 0x0E, 0x02, 0x77, 0x74, 0x0E, 0xB0, 0x47, 0x20, 0x8C, 0x0E, 0x02,
  0x77, 0x73, 0x0E, 0xFF, 0xD0, 0xE0, 0x27, 0x77, 0x20, 0x9F, 0xFE, 0x0E, 0x02, 0x77, 0x71, 0x01,
  0x0D, 0xFF, 0xE0, 0xE0, 0x27, 0x77, 0x18, 0x11, 0x9D, 0xFF, 0xD0, 0xE0, 0x28, 0x0C, 0x30, 0x08,
  0xC0, 0xE0, 0x28, 0x0C, 0x30, 0x08, 0xC0, 0xE0, 0x27, 0x75, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x09,
  0xC0, 0xE0, 0x27, 0x73, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x50, 0x20, 0xED, 0x0E, 0x02, 0x77, 0x20,
  0x9E, 0x0A, 0x75, 0x0A, 0xF0, 0xE0, 0x27, 0x71, 0x0D, 0xE0, 0xD7, 0x50, 0xEF, 0x90, 0xE0, 0x27,
  0x70, 0xDE, 0x0D, 0x75, 0x0D, 0xFA, 0x0E, 0x02, 0x76, 0x09, 0xE0, 0xA7, 0x50, 0x9F, 0xB0, 0xE0,
  0x27, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x9C, 0x0E, 0x02, 0x75, 0x84,
  0x1A, 0xDD, 0xA1, 0x77, 0x86, 0x1A, 0xDE, 0xA2, 0x08, 0xC0, 0xD0, 0x28, 0x0C, 0x30, 0x08, 0xC0,
  0xB8, 0x0C, 0x40, 0x08, 0xB0, 0xC8, 0x0C, 0x50, 0x08, 0xA0, 0x58, 0x0C, 0x60, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_remove_shopping_cart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 44, 47), Box(0, 0, 47, 47),
      ic_round_48_action_remove_shopping_cart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_reorder 48x48, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_48_action_reorder_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x48, 0x0A, 0x94, 0x00, 0x40, 0xDF, 0xFF, 0xFC, 0x81, 0xD4, 0xDF, 0xFF,
  0xFE, 0x00, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04, 0x80, 0xA9, 0x40, 0x04,
  0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF,
  0xFF, 0xC0, 0xD0, 0x48, 0x0A, 0x94, 0x00, 0x40, 0xDF, 0xFF, 0xFC, 0x81, 0xD4, 0xDF, 0xFF, 0xFE,
  0x00, 0xDF, 0xFF, 0xFE, 0x81, 0xD4, 0xDF, 0xFF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_reorder() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_reorder_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_repartition 48x48, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_round_48_action_repartition_data[] PROGMEM = {
  0x70, 0x01, 0x77, 0x77, 0x70, 0x7A, 0x06, 0x77, 0x77, 0x50, 0x7B, 0x0E, 0x77, 0x77, 0x40, 0x7C,
  0x0C, 0x77, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x20,
  0x7F, 0xFF, 0xF8, 0x2E, 0xD8, 0x24, 0x01, 0xFF, 0xFF, 0xD0, 0x83, 0x01, 0xFF, 0xFF, 0xE0, 0xB3,
  0x07, 0xFF, 0xFF, 0xE0, 0x83, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x81, 0x16, 0xDC, 0x02, 0x30, 0x7C,
  0x0E, 0x03, 0x77, 0x71, 0x01, 0x0D, 0xB0, 0x84, 0x07, 0xC0, 0xC7, 0x77, 0x20, 0x5B, 0x0C, 0x50,
  0x7B, 0x0E, 0x77, 0x72, 0x01, 0xB0, 0xE6, 0x07, 0xA0, 0x67, 0x77, 0x3B, 0x0E, 0x70, 0x01, 0x77,
  0x73, 0x05, 0xB0, 0xC7, 0x77, 0x74, 0x01, 0x0D, 0xB0, 0x87, 0x77, 0x73, 0x05, 0x0D, 0xC0, 0x22,
  0x04, 0x0D, 0xFF, 0xFF, 0xC0, 0x83, 0x0D, 0xFF, 0xFF, 0xC0, 0xA4, 0x0D, 0xFF, 0xFF, 0xB0, 0x75,
  0x04, 0x0D, 0xFF, 0xFD, 0x82, 0xEB, 0x71, 0x80, 0xAB, 0x30, 0x08, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0,
  0x83, 0x08, 0xFF, 0xFF, 0xE0, 0x82, 0x0D, 0xFF, 0xFF, 0xE0, 0xD2, 0x80, 0xC0, 0xF2, 0xC6, 0x05,
  0xB0, 0xA6, 0x0A, 0xB0, 0x56, 0xC2, 0xC6, 0x05, 0xB0, 0xA6, 0x0A, 0xB0, 0x56, 0xC2, 0xC6, 0x05,
  0xB0, 0xA6, 0x0A, 0xB0, 0x56, 0xC2, 0xC6, 0x05, 0xB0, 0xA6, 0x0A, 0xB0, 0x56, 0xC2, 0x80, 0xC0,
  0xF2, 0x0D, 0xFF, 0xFF, 0xE0, 0xD2, 0x08, 0xFF, 0xFF, 0xE0, 0x83, 0x08, 0x0D, 0xFF, 0xFF, 0xA0,
  0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_repartition() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_repartition_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_report_problem 48x48, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_round_48_action_report_problem_data[] PROGMEM = {
  0x77, 0x58, 0x24, 0xDD, 0x38, 0x0C, 0x10, 0x01, 0x0E, 0xA0, 0xE0, 0x18, 0x0C, 0x00, 0x09, 0xC0,
  0x97, 0x77, 0x77, 0x03, 0xE0, 0x27, 0x77, 0x76, 0x0B, 0xE0, 0xB7, 0x77, 0x75, 0x05, 0xF9, 0x05,
  0x77, 0x77, 0x40, 0xDF, 0x90, 0xD7, 0x77, 0x73, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x10, 0x10, 0xEF,
  0xB0, 0xE0, 0x17, 0x77, 0x70, 0xAF, 0xD0, 0x97, 0x77, 0x60, 0x3F, 0xF0, 0x37, 0x77, 0x50, 0xCF,
  0xF0, 0xC7, 0x77, 0x40, 0x6F, 0xFA, 0x05, 0x77, 0x72, 0x01, 0x0E, 0xFF, 0xA0, 0xE7, 0x77, 0x20,
  0x8F, 0x82, 0xB1, 0x1B, 0xF0, 0x87, 0x77, 0x02, 0xF9, 0x01, 0x20, 0x1F, 0x90, 0x27, 0x76, 0x0B,
  0xF9, 0x4F, 0x90, 0xA7, 0x75, 0x04, 0xFA, 0x4F, 0xA0, 0x47, 0x74, 0x0D, 0xFA, 0x4F, 0xA0, 0xD7,
  0x73, 0x07, 0xFB, 0x4F, 0xB0, 0x67, 0x71, 0x01, 0x0E, 0xFB, 0x01, 0x20, 0x1F, 0xB0, 0xE0, 0x17,
  0x70, 0x9F, 0xC8, 0x2B, 0x11, 0xBF, 0xC0, 0x97, 0x60, 0x3F, 0xFF, 0xF0, 0x27, 0x50, 0xBF, 0xFF,
  0xF0, 0xB7, 0x40, 0x5F, 0xFF, 0xFA, 0x05, 0x73, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x20, 0x7F, 0xF4,
  0xFF, 0x07, 0x70, 0x10, 0xEF, 0xF4, 0xFF, 0x0E, 0x01, 0x60, 0xAF, 0xF9, 0x4F, 0xF9, 0x0A, 0x50,
  0x3F, 0xFA, 0x4F, 0xFA, 0x03, 0x40, 0xC8, 0x0C, 0x0F, 0x0C, 0x30, 0x68, 0x0C, 0x2F, 0x82, 0x60,
  0x1E, 0x80, 0xC2, 0xF8, 0x1E, 0x06, 0x80, 0xC4, 0xF0, 0x06, 0x80, 0xC4, 0xF8, 0x16, 0x0A, 0x80,
  0xC2, 0xF0, 0xA1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_report_problem() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 44, 41), Box(0, 0, 47, 47),
      ic_round_48_action_report_problem_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_request_page 48x48, 4-bit Alpha,  RLE, 161 bytes.
static const unsigned char ic_round_48_action_request_page_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x0A, 0xFF, 0xF0,
  0x77, 0x20, 0xDF, 0xFF, 0x90, 0x77, 0x1F, 0xFF, 0xB0, 0x77, 0xFF, 0xFC, 0x07, 0x6F, 0xFF, 0xD0,
  0x75, 0xFF, 0xFE, 0x07, 0x4F, 0xFF, 0xF0, 0x73, 0xFF, 0xFF, 0x90, 0x72, 0xFF, 0xFF, 0xA0, 0x71,
  0xFF, 0xFF, 0xB0, 0x4F, 0xF8, 0x2B, 0x11, 0xBF, 0xE0, 0xBF, 0xF0, 0x12, 0x01, 0xFE, 0x0E, 0xFB,
  0x0B, 0x01, 0x71, 0x01, 0x0B, 0xFF, 0xE0, 0x17, 0x30, 0x1F, 0xFE, 0x74, 0x01, 0xFF, 0xE7, 0x30,
  0x10, 0xBF, 0xFE, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x73, 0x01, 0x0B, 0xFF, 0xE7, 0x40, 0x1F, 0xFE,
  0x01, 0x74, 0xFF, 0xE0, 0xB0, 0x17, 0x3F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFE, 0x0B, 0x01, 0x73,
  0xFF, 0xE0, 0x17, 0x4F, 0xFE, 0x01, 0x73, 0x01, 0xFF, 0xE0, 0xB0, 0x17, 0x10, 0x10, 0xBF, 0xFF,
  0xB0, 0x12, 0x01, 0xFF, 0xFF, 0x82, 0xB1, 0x1B, 0x80, 0xA9, 0x2F, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0,
  0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_request_page() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_request_page_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_restore_from_trash 48x48, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_round_48_action_restore_from_trash_data[] PROGMEM = {
  0x71, 0x06, 0x0E, 0xF9, 0x0E, 0x06, 0x77, 0x10, 0x7F, 0xD0, 0x77, 0x04, 0x0D, 0xFF, 0xFB, 0x81,
  0xD4, 0xDF, 0xFF, 0xD0, 0x0D, 0xFF, 0xFD, 0x81, 0xD4, 0xDF, 0xFF, 0xB0, 0xD0, 0x48, 0x0E, 0x70,
  0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x15, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x14, 0x0A, 0xFF, 0xF9,
  0x0A, 0x40, 0xDF, 0xFF, 0x90, 0xD4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFC, 0x00, 0x9F, 0xC4, 0xFB,
  0x07, 0x20, 0x7F, 0xB4, 0xFA, 0x07, 0x40, 0x7F, 0xA4, 0xF9, 0x07, 0x60, 0x7F, 0x94, 0xF0, 0x77,
  0x10, 0x7F, 0x4E, 0x07, 0x73, 0x07, 0xE4, 0xD0, 0x77, 0x50, 0x7D, 0x4C, 0x07, 0x77, 0x07, 0xC4,
  0xF9, 0x71, 0xF9, 0x4F, 0x97, 0x1F, 0x94, 0xF9, 0x71, 0xF9, 0x4F, 0x97, 0x1F, 0x94, 0xF9, 0x71,
  0xF9, 0x4F, 0x97, 0x1F, 0x94, 0xF9, 0x71, 0xF9, 0x4F, 0x97, 0x1F, 0x94, 0xFF, 0xFB, 0x4F, 0xFF,
  0xB4, 0x0D, 0xFF, 0xF9, 0x0D, 0x40, 0xAF, 0xFF, 0x90, 0xA4, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x15,
  0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_restore_from_trash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_round_48_action_restore_from_trash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_restore_page 48x48, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_round_48_action_restore_page_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x09, 0xFF, 0xF0,
  0x77, 0x20, 0xDF, 0xFF, 0x90, 0x77, 0x1F, 0xFF, 0xB0, 0x77, 0xFF, 0xFC, 0x07, 0x6F, 0xFF, 0xD0,
  0x75, 0xFF, 0xFE, 0x07, 0x4F, 0xFF, 0xF0, 0x73, 0xFF, 0xFF, 0x90, 0x72, 0xFF, 0xFF, 0xA0, 0x71,
  0xFF, 0xFF, 0xB0, 0x4F, 0xD8, 0x6B, 0x53, 0x10, 0x25, 0xAF, 0xC0, 0xBF, 0xB0, 0xB0, 0x17, 0x10,
  0x20, 0xAF, 0xA0, 0xED, 0x07, 0xB0, 0x77, 0x50, 0x7F, 0xF1, 0x81, 0x7F, 0x83, 0x86, 0x17, 0xCE,
  0xEC, 0x71, 0x30, 0x7F, 0xE2, 0x05, 0x30, 0x40, 0xEE, 0x0E, 0x04, 0x30, 0xAF, 0xD5, 0x04, 0xFB,
  0x04, 0x20, 0x2F, 0xD5, 0x0E, 0xFB, 0x0E, 0x01, 0x20, 0xAF, 0xC5, 0x07, 0xFC, 0x07, 0x20, 0x5F,
  0xC6, 0x07, 0xFB, 0x0C, 0x20, 0x2F, 0xC0, 0x36, 0x07, 0xFA, 0x0E, 0x3F, 0xFF, 0xF0, 0xE3, 0xFF,
  0xFF, 0x0C, 0x20, 0x2F, 0xFF, 0xF0, 0x72, 0x05, 0xFE, 0x82, 0xE7, 0x7E, 0xFB, 0x0E, 0x01, 0x20,
  0xAF, 0xE0, 0x92, 0x04, 0xFB, 0x04, 0x20, 0x2F, 0xF0, 0xB3, 0x05, 0x0E, 0xE0, 0xE0, 0x43, 0x0A,
  0xFF, 0x90, 0x73, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x30, 0x7F, 0xFB, 0x07, 0x75, 0x07, 0xFF, 0xD0,
  0xB0, 0x17, 0x10, 0x20, 0xAF, 0xFF, 0x98, 0x1A, 0x52, 0x28, 0x12, 0x5A, 0x80, 0xA9, 0x0F, 0x0D,
  0xFF, 0xFF, 0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xEF,
  0xFF, 0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_restore_page() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_restore_page_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_restore 48x48, 4-bit Alpha,  RLE, 308 bytes.
static const unsigned char ic_round_48_action_restore_data[] PROGMEM = {
  0x77, 0x38, 0x91, 0x15, 0x9B, 0xDE, 0xFD, 0xB9, 0x57, 0x77, 0x70, 0x40, 0xBF, 0xD0, 0xA0, 0x47,
  0x77, 0x20, 0x40, 0xCF, 0xFA, 0x0B, 0x02, 0x77, 0x60, 0x8F, 0xFE, 0x07, 0x77, 0x30, 0x10, 0xBE,
  0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xDE, 0x09, 0x77, 0x10, 0x10, 0xDD, 0x0A, 0x02, 0x73, 0x03,
  0x0B, 0xD0, 0xB7, 0x70, 0xBC, 0x0D, 0x03, 0x77, 0x04, 0x0E, 0xC0, 0x97, 0x50, 0x9C, 0x0B, 0x01,
  0x77, 0x20, 0x10, 0xCC, 0x07, 0x73, 0x03, 0xC0, 0xB7, 0x76, 0x0C, 0xC0, 0x27, 0x20, 0xCB, 0x0D,
  0x01, 0x77, 0x60, 0x10, 0xEB, 0x0B, 0x71, 0x05, 0xC0, 0x37, 0x28, 0x18, 0xE7, 0x73, 0x04, 0xC0,
  0x47, 0x0B, 0xB0, 0xA7, 0x3A, 0x0E, 0x74, 0x0B, 0xB0, 0xA6, 0x01, 0xC0, 0x27, 0x3B, 0x74, 0x03,
  0xC6, 0x05, 0xB0, 0xC7, 0x4B, 0x75, 0x0D, 0xB0, 0x55, 0x0A, 0xB0, 0x77, 0x4B, 0x75, 0x08, 0xB0,
  0x95, 0x0B, 0xB0, 0x37, 0x4B, 0x75, 0x04, 0xB0, 0xB5, 0x0D, 0xB0, 0x27, 0x4B, 0x75, 0x02, 0xB0,
  0xD5, 0x0E, 0xB7, 0x5B, 0x76, 0xB0, 0xE0, 0x5F, 0xD0, 0x57, 0xB0, 0x67, 0x40, 0x1B, 0x0D, 0x05,
  0xFD, 0x05, 0x70, 0xDB, 0x0C, 0x03, 0x72, 0x02, 0xB8, 0x1C, 0x07, 0xFB, 0x07, 0x71, 0x02, 0x0D,
  0xC0, 0x90, 0x17, 0x04, 0xB0, 0xB2, 0x07, 0xF9, 0x07, 0x74, 0x07, 0x0E, 0xB0, 0xE0, 0x66, 0x08,
  0xB0, 0x93, 0x07, 0xE0, 0x77, 0x60, 0x10, 0xAC, 0x05, 0x50, 0xCB, 0x05, 0x40, 0x7C, 0x07, 0x77,
  0x20, 0x40, 0xDA, 0x05, 0x40, 0x2C, 0x60, 0x8A, 0x07, 0x77, 0x50, 0x05, 0x50, 0xAB, 0x0B, 0x70,
  0x05, 0x77, 0x75, 0x03, 0xC0, 0x47, 0x77, 0x76, 0x01, 0x0D, 0xB0, 0xB7, 0x77, 0x77, 0x0B, 0xC0,
  0x37, 0x70, 0x30, 0x57, 0x73, 0x01, 0x0B, 0xC0, 0x87, 0x70, 0x6A, 0x0D, 0x03, 0x77, 0x03, 0x0D,
  0xC0, 0xB7, 0x71, 0x0B, 0xC0, 0x90, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x77, 0x10, 0x8E, 0x82,
  0xB7, 0x31, 0x28, 0x22, 0x47, 0xCE, 0x0A, 0x77, 0x40, 0x8F, 0xFE, 0x08, 0x77, 0x60, 0x30, 0xDF,
  0xFA, 0x0B, 0x03, 0x77, 0x72, 0x04, 0x0B, 0xFD, 0x0B, 0x04, 0x77, 0x76, 0x89, 0x11, 0x59, 0xCD,
  0xFE, 0xDB, 0x95, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_restore() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_restore_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_rocket_launch 48x48, 4-bit Alpha,  RLE, 350 bytes.
static const unsigned char ic_round_48_action_rocket_launch_data[] PROGMEM = {
  0x77, 0x77, 0x18, 0x31, 0x59, 0xCE, 0xA8, 0x1E, 0xB2, 0x77, 0x76, 0x05, 0x0B, 0xFA, 0x0B, 0x77,
  0x74, 0x04, 0x0D, 0xFC, 0x0E, 0x77, 0x72, 0x02, 0x0B, 0xFF, 0x77, 0x71, 0x06, 0xFF, 0xA7, 0x76,
  0x01, 0x0A, 0xFF, 0xA0, 0xE7, 0x75, 0x02, 0x0D, 0xFF, 0xB0, 0xC7, 0x18, 0x51, 0x9D, 0xDA, 0x71,
  0x30, 0x30, 0xEF, 0xFC, 0x09, 0x70, 0x30, 0xEC, 0x0B, 0x30, 0x40, 0xEF, 0xFD, 0x05, 0x60, 0x30,
  0xEC, 0x0E, 0x01, 0x20, 0x20, 0xED, 0x84, 0xD5, 0x11, 0x5D, 0xFA, 0x01, 0x50, 0x30, 0xED, 0x04,
  0x20, 0x10, 0xDD, 0x0D, 0x01, 0x40, 0x10, 0xDF, 0x0A, 0x50, 0x30, 0xED, 0x08, 0x30, 0xCE, 0x05,
  0x60, 0x5F, 0x04, 0x40, 0x30, 0xED, 0x0D, 0x30, 0x7F, 0x01, 0x60, 0x1E, 0x0C, 0x40, 0x30, 0xEE,
  0x04, 0x20, 0x3F, 0x90, 0x16, 0x01, 0xE0, 0x43, 0x01, 0x0E, 0xE0, 0xA3, 0x0C, 0xF9, 0x05, 0x60,
  0x5D, 0x0B, 0x40, 0x6F, 0x02, 0x20, 0x6F, 0xA0, 0xD0, 0x14, 0x01, 0x0D, 0xC0, 0xE0, 0x24, 0x04,
  0xE0, 0x93, 0x0E, 0xFB, 0x84, 0xD5, 0x11, 0x5D, 0xD0, 0x66, 0x05, 0x0D, 0xC0, 0x22, 0x07, 0xFF,
  0xF0, 0xA7, 0x28, 0x24, 0xBF, 0xA2, 0x01, 0x0E, 0xFF, 0xE0, 0xC0, 0x17, 0x40, 0x02, 0x20, 0x6F,
  0xFE, 0x0D, 0x01, 0x77, 0x20, 0x8F, 0xFD, 0x0E, 0x02, 0x77, 0x30, 0x20, 0xEF, 0xFB, 0x0E, 0x03,
  0x77, 0x50, 0x30, 0xEF, 0xF9, 0x0D, 0x02, 0x77, 0x70, 0x30, 0xEF, 0xE0, 0xB0, 0x17, 0x77, 0x20,
  0x30, 0xEF, 0xC0, 0x74, 0x01, 0x75, 0x84, 0x6B, 0xEE, 0xB6, 0x30, 0x30, 0xEF, 0x90, 0xC0, 0x23,
  0x81, 0x1B, 0x77, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x20, 0x30, 0xED, 0x0E, 0x06, 0x48, 0x24, 0xEF,
  0xA7, 0x30, 0xCF, 0x90, 0xC3, 0x03, 0x0E, 0xA0, 0xE0, 0x75, 0x08, 0xB0, 0xD7, 0x20, 0x5F, 0xB0,
  0x63, 0x81, 0x28, 0x65, 0x04, 0x0D, 0xC0, 0xD7, 0x20, 0xBF, 0xB0, 0xB7, 0x20, 0x20, 0xAE, 0x09,
  0x71, 0x01, 0xFC, 0x0E, 0x70, 0x20, 0x9F, 0x0E, 0x01, 0x71, 0x06, 0xFC, 0x0E, 0x50, 0x20, 0xAF,
  0x90, 0xE0, 0x37, 0x20, 0xAF, 0xC0, 0xB5, 0x02, 0xF9, 0x0E, 0x03, 0x73, 0x0E, 0xFC, 0x06, 0x60,
  0xBE, 0x0E, 0x03, 0x73, 0x02, 0xFC, 0x0C, 0x70, 0x4D, 0x0E, 0x03, 0x74, 0x05, 0xFB, 0x0B, 0x01,
  0x71, 0x0D, 0xB0, 0xE0, 0x37, 0x50, 0x7F, 0x90, 0xB0, 0x47, 0x30, 0x5A, 0x0E, 0x03, 0x76, 0x03,
  0xC8, 0x2E, 0xA6, 0x17, 0x68, 0x14, 0x61, 0x77, 0x18, 0x23, 0x75, 0x27, 0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_rocket_launch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 42, 43), Box(0, 0, 47, 47),
      ic_round_48_action_rocket_launch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_rocket 48x48, 4-bit Alpha,  RLE, 249 bytes.
static const unsigned char ic_round_48_action_rocket_data[] PROGMEM = {
  0x77, 0x82, 0x18, 0x81, 0x77, 0x76, 0x03, 0x0D, 0xA0, 0xD0, 0x37, 0x77, 0x40, 0x20, 0xEC, 0x0E,
  0x02, 0x77, 0x72, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x77, 0x10, 0xBF, 0x90, 0xB7, 0x77, 0x05, 0xFB,
  0x05, 0x77, 0x60, 0xDF, 0xB0, 0xD7, 0x75, 0x05, 0xFD, 0x05, 0x77, 0x40, 0xCF, 0xD0, 0xC7, 0x73,
  0x03, 0xFF, 0x03, 0x77, 0x20, 0x8F, 0xF0, 0x87, 0x72, 0x0D, 0xFF, 0x0C, 0x77, 0x10, 0x1F, 0xFA,
  0x01, 0x77, 0x04, 0xD8, 0x4D, 0x51, 0x15, 0xDD, 0x04, 0x77, 0x07, 0xC0, 0xD0, 0x14, 0x01, 0x0D,
  0xC0, 0x77, 0x70, 0x9C, 0x05, 0x60, 0x5C, 0x09, 0x77, 0x0B, 0xC0, 0x16, 0x01, 0xC0, 0xB7, 0x70,
  0xDC, 0x01, 0x60, 0x1C, 0x0D, 0x77, 0x0E, 0xC0, 0x56, 0x05, 0xC0, 0xE7, 0x70, 0xEC, 0x0D, 0x01,
  0x40, 0x10, 0xDC, 0x0E, 0x77, 0xE8, 0x4D, 0x51, 0x15, 0xDE, 0x77, 0x0E, 0xFF, 0xA0, 0xE7, 0x30,
  0x53, 0x0D, 0xFF, 0xA0, 0xD3, 0x05, 0x48, 0x21, 0xAF, 0x32, 0x0C, 0xFF, 0xA0, 0xC2, 0x85, 0x2F,
  0xA1, 0x01, 0xDA, 0x04, 0x20, 0xAF, 0xFA, 0x0A, 0x20, 0x4A, 0x81, 0xD1, 0x9B, 0x06, 0x20, 0x8F,
  0xFA, 0x08, 0x20, 0x6B, 0x09, 0x0E, 0xB0, 0x92, 0x05, 0xFF, 0xA0, 0x52, 0x09, 0xB0, 0xEC, 0x0C,
  0x20, 0x1F, 0xFA, 0x01, 0x20, 0xCF, 0xA3, 0x0D, 0xFF, 0x0D, 0x3F, 0xB0, 0x42, 0x09, 0xFF, 0x09,
  0x20, 0x4F, 0xB0, 0x82, 0x05, 0xFF, 0x05, 0x20, 0x8F, 0xB0, 0xD3, 0xFF, 0x30, 0xCF, 0xC0, 0x22,
  0x0A, 0xFD, 0x0A, 0x20, 0x2F, 0xD0, 0x72, 0x05, 0xFD, 0x05, 0x20, 0x7F, 0xD0, 0xC3, 0x09, 0xFB,
  0x09, 0x30, 0xCF, 0xE0, 0x27, 0x72, 0x02, 0xF0, 0xDC, 0x0C, 0x06, 0x77, 0x40, 0x60, 0xCC, 0x84,
  0xD4, 0xEE, 0x93, 0x77, 0x71, 0x83, 0x39, 0xEE, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_rocket() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 5, 39, 42), Box(0, 0, 47, 47),
      ic_round_48_action_rocket_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_room 48x48, 4-bit Alpha,  RLE, 229 bytes.
static const unsigned char ic_round_48_action_room_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x10, 0x8F, 0xFA, 0x08, 0x75, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x30, 0xEF, 0xFE, 0x0E,
  0x03, 0x70, 0x10, 0xEF, 0xFF, 0x90, 0xE0, 0x16, 0x0C, 0xFF, 0xFB, 0x0C, 0x50, 0x7F, 0xFF, 0xD0,
  0x73, 0x01, 0x0E, 0xFF, 0xFD, 0x0E, 0x01, 0x20, 0x9F, 0xFF, 0xF0, 0x92, 0x0E, 0xFF, 0xFF, 0x81,
  0xE0, 0x3F, 0xFF, 0xFA, 0x03, 0x08, 0xFD, 0x84, 0xD5, 0x11, 0x5D, 0xFD, 0x08, 0x0B, 0xFC, 0x0D,
  0x01, 0x40, 0x10, 0xDF, 0xC0, 0xB0, 0xDF, 0xC0, 0x56, 0x05, 0xFC, 0x0C, 0x0E, 0xFC, 0x01, 0x60,
  0x1F, 0xC0, 0xEF, 0xD0, 0x16, 0x01, 0xFD, 0x0D, 0xFC, 0x05, 0x60, 0x5F, 0xC0, 0xD0, 0xCF, 0xC0,
  0xD0, 0x14, 0x01, 0x0D, 0xFC, 0x0C, 0x09, 0xFD, 0x84, 0xD5, 0x11, 0x5D, 0xFD, 0x09, 0x04, 0xFF,
  0xFF, 0xA8, 0x14, 0x0E, 0xFF, 0xFF, 0x0E, 0x20, 0x9F, 0xFF, 0xF0, 0x92, 0x02, 0xFF, 0xFF, 0x02,
  0x30, 0xAF, 0xFF, 0xD0, 0xA4, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x50, 0x7F, 0xFF, 0xB0, 0x77,
  0x0C, 0xFF, 0xF9, 0x0C, 0x71, 0x02, 0x0E, 0xFF, 0xE0, 0xE0, 0x27, 0x20, 0x5F, 0xFE, 0x05, 0x74,
  0x08, 0xFF, 0xC0, 0x87, 0x60, 0xAF, 0xFA, 0x0A, 0x77, 0x10, 0xCF, 0xF0, 0xC7, 0x72, 0x01, 0x0C,
  0xFD, 0x0C, 0x01, 0x77, 0x30, 0x10, 0xCF, 0xB0, 0xC0, 0x17, 0x75, 0x01, 0x0D, 0xF9, 0x0D, 0x01,
  0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x73, 0x0B, 0xC0, 0xB7, 0x77, 0x60, 0xAA, 0x0A, 0x77,
  0x77, 0x10, 0x03, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_room() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_room_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_rounded_corner 48x48, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_round_48_action_rounded_corner_data[] PROGMEM = {
  0xC4, 0xC4, 0xFB, 0x82, 0xED, 0x95, 0x6C, 0x4C, 0x4F, 0xF0, 0xD0, 0x44, 0xC4, 0xC4, 0xFF, 0xA0,
  0x83, 0xC4, 0xC4, 0xFF, 0xB0, 0x87, 0x77, 0x71, 0x03, 0x08, 0xD0, 0x47, 0x77, 0x72, 0x03, 0x0D,
  0xB0, 0xD7, 0x77, 0x73, 0x03, 0xC0, 0x57, 0x77, 0x73, 0x08, 0xB0, 0x9C, 0x77, 0x76, 0x03, 0xB0,
  0xDC, 0x77, 0x77, 0xB0, 0xEC, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74,
  0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9,
  0x77, 0x77, 0xC8, 0x0A, 0x94, 0x0C, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77,
  0x77, 0xC8, 0x0A, 0x94, 0x0C, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C,
  0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_rounded_corner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_rounded_corner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_rowing 48x48, 4-bit Alpha,  RLE, 257 bytes.
static const unsigned char ic_round_48_action_rowing_data[] PROGMEM = {
  0x77, 0x48, 0x41, 0xAD, 0xDA, 0x17, 0x77, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x74, 0x0A, 0xE0,
  0xA7, 0x77, 0x40, 0xDE, 0x0D, 0x77, 0x74, 0x0D, 0xE0, 0xD7, 0x77, 0x40, 0xAE, 0x0A, 0x77, 0x74,
  0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x58, 0x41, 0xAD, 0xDA, 0x18, 0x09, 0xB1, 0x08, 0x37, 0xDF,
  0xC6, 0x77, 0x75, 0x01, 0x0C, 0xD0, 0xB7, 0x77, 0x40, 0xBF, 0x06, 0x77, 0x72, 0x0A, 0xF9, 0x0C,
  0x77, 0x71, 0x09, 0xFB, 0x77, 0x70, 0xAF, 0xC7, 0x75, 0x04, 0x0C, 0xFD, 0x77, 0x30, 0x40, 0xBF,
  0xF7, 0x58, 0x34, 0x68, 0xAE, 0xE0, 0xEF, 0xA7, 0x40, 0xAF, 0xB0, 0xA0, 0x1F, 0xA7, 0x30, 0x1F,
  0xA0, 0xD0, 0x52, 0xFA, 0x74, 0x0E, 0xF0, 0xB4, 0xFA, 0x74, 0x82, 0x4D, 0xED, 0xD0, 0x73, 0xFA,
  0x77, 0x10, 0x8D, 0x07, 0x20, 0xAF, 0x97, 0x72, 0x07, 0xD0, 0x72, 0x0A, 0xF7, 0x73, 0x07, 0xD0,
  0x72, 0x0A, 0xE7, 0x74, 0x07, 0xD0, 0x72, 0x0A, 0xC0, 0xE7, 0x71, 0x00, 0x72, 0x07, 0xD0, 0x72,
  0x0A, 0xB0, 0xC7, 0x70, 0x7A, 0x07, 0x20, 0x7D, 0x07, 0x20, 0xAA, 0x06, 0x76, 0x07, 0xC0, 0x72,
  0x07, 0xD0, 0x72, 0x0A, 0x0C, 0x76, 0x07, 0xE0, 0x72, 0x07, 0xD0, 0x72, 0x01, 0x75, 0x07, 0xF9,
  0x07, 0x20, 0x7D, 0x07, 0x76, 0x07, 0xD0, 0x77, 0x07, 0xD0, 0x77, 0x40, 0x7D, 0x07, 0x72, 0x07,
  0xD0, 0x77, 0x20, 0x7D, 0x07, 0x74, 0x07, 0xF0, 0xE0, 0x65, 0xD0, 0x77, 0x60, 0x7F, 0x90, 0x74,
  0xC0, 0x77, 0x71, 0x07, 0xF9, 0x07, 0x30, 0x6A, 0x07, 0x77, 0x3F, 0xA0, 0x77, 0x77, 0x2F, 0xB0,
  0x77, 0x77, 0x10, 0xEF, 0xB0, 0x17, 0x77, 0x06, 0xFB, 0x01, 0x77, 0x71, 0x07, 0xF9, 0x07, 0x77,
  0x73, 0x07, 0xE0, 0x77, 0x77, 0x50, 0x7C, 0x07, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x00,
  0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_rowing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 2, 41, 47), Box(0, 0, 47, 47),
      ic_round_48_action_rowing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_rule 48x48, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_round_48_action_rule_data[] PROGMEM = {
  0x80, 0xC0, 0x08, 0x11, 0x41, 0x80, 0xC0, 0x08, 0x32, 0xDF, 0xE2, 0x77, 0x77, 0x60, 0x20, 0xEB,
  0x07, 0x77, 0x77, 0x50, 0x20, 0xEC, 0x04, 0x77, 0x77, 0x40, 0x20, 0xEC, 0x08, 0x77, 0x73, 0x82,
  0x7F, 0xD3, 0x40, 0x20, 0xEC, 0x08, 0x20, 0x40, 0xDF, 0xF0, 0xD0, 0x44, 0x01, 0xB0, 0xE0, 0x32,
  0x02, 0x0E, 0xC0, 0x83, 0x0D, 0xFF, 0xA0, 0xD5, 0xC8, 0x2E, 0x32, 0xEC, 0x08, 0x40, 0xDF, 0xFA,
  0x0D, 0x50, 0x6C, 0x00, 0xEC, 0x08, 0x50, 0x40, 0xDF, 0xF0, 0xD0, 0x46, 0x06, 0xF9, 0x08, 0x77,
  0x77, 0x30, 0x6E, 0x08, 0x77, 0x77, 0x50, 0x6C, 0x08, 0x77, 0x77, 0x70, 0x6A, 0x07, 0x80, 0xC2,
  0x00, 0x18, 0x09, 0xD6, 0x00, 0x17, 0x30, 0x17, 0x77, 0x68, 0x28, 0xFE, 0x56, 0x82, 0x5E, 0xF8,
  0x77, 0x74, 0x01, 0xC0, 0x54, 0x05, 0xC0, 0x17, 0x77, 0x40, 0xEC, 0x05, 0x20, 0x5C, 0x0E, 0x77,
  0x75, 0x05, 0xD0, 0x05, 0xD0, 0x57, 0x77, 0x60, 0x5F, 0xB0, 0x54, 0x04, 0x0D, 0xFF, 0x0D, 0x04,
  0x70, 0x5F, 0x90, 0x55, 0x0D, 0xFF, 0xA0, 0xD7, 0x10, 0x5E, 0x05, 0x60, 0xDF, 0xFA, 0x0D, 0x71,
  0x05, 0xE0, 0x56, 0x04, 0x0D, 0xFF, 0x0D, 0x04, 0x70, 0x5F, 0x90, 0x57, 0x77, 0x71, 0x05, 0xFB,
  0x05, 0x77, 0x76, 0x05, 0xD0, 0x05, 0xD0, 0x57, 0x77, 0x50, 0xEC, 0x05, 0x20, 0x5C, 0x0E, 0x77,
  0x74, 0x01, 0xC0, 0x54, 0x05, 0xC0, 0x17, 0x77, 0x48, 0x28, 0xFE, 0x56, 0x82, 0x5E, 0xF8, 0x77,
  0x76, 0x01, 0x73, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_rule() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_rule_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_satellite_alt 48x48, 4-bit Alpha,  RLE, 511 bytes.
static const unsigned char ic_round_48_action_satellite_alt_data[] PROGMEM = {
  0x77, 0x77, 0x38, 0x34, 0xBE, 0xD7, 0x80, 0xC4, 0x00, 0x7D, 0x0C, 0x01, 0x80, 0xC1, 0x00, 0x7F,
  0x0C, 0x01, 0x77, 0x77, 0x70, 0x7F, 0xA0, 0xC0, 0x17, 0x77, 0x75, 0x07, 0xC8, 0x1E, 0x4B, 0xC0,
  0xC0, 0x17, 0x77, 0x73, 0x07, 0xC0, 0xE0, 0x32, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x71, 0x07, 0xD0,
  0xD0, 0x13, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x60, 0x6F, 0x0D, 0x01, 0x30, 0xBC, 0x0C, 0x01, 0x77,
  0x74, 0x02, 0xC0, 0xE0, 0x7B, 0x0D, 0x01, 0x30, 0xBC, 0x0B, 0x77, 0x74, 0x07, 0xB8, 0x2E, 0x30,
  0x4B, 0x0D, 0x01, 0x30, 0xBC, 0x06, 0x77, 0x73, 0x09, 0xB0, 0x93, 0x04, 0xB0, 0xD0, 0x13, 0x0B,
  0xB0, 0xA7, 0x77, 0x30, 0x6C, 0x07, 0x30, 0x4B, 0x0D, 0x01, 0x20, 0x9B, 0x0A, 0x77, 0x74, 0x0D,
  0xC0, 0x73, 0x04, 0xB8, 0x1D, 0x19, 0xC0, 0x77, 0x75, 0x82, 0x16, 0x74, 0x20, 0x30, 0xEC, 0x07,
  0x30, 0x4B, 0x0E, 0xC0, 0xC7, 0x75, 0x06, 0x0E, 0xB8, 0x3C, 0x10, 0x3E, 0xC0, 0x73, 0x04, 0xE0,
  0xD0, 0x17, 0x74, 0x07, 0xE8, 0x2D, 0x10, 0x4D, 0x07, 0x30, 0xBC, 0x0D, 0x01, 0x77, 0x40, 0x7F,
  0x98, 0x1D, 0x2C, 0xE8, 0x17, 0x0A, 0xC0, 0xD0, 0x17, 0x74, 0x06, 0xFF, 0x0E, 0xC0, 0xCC, 0x0D,
  0x01, 0x77, 0x40, 0x20, 0xEF, 0xE8, 0x15, 0x3E, 0xF0, 0xD0, 0x17, 0x75, 0x06, 0xFE, 0x83, 0xD1,
  0x03, 0xED, 0x0D, 0x01, 0x77, 0x60, 0x7F, 0xF8, 0x3D, 0x10, 0x3D, 0xB0, 0xB0, 0x17, 0x77, 0x04,
  0xFF, 0x90, 0xD0, 0x12, 0x81, 0x35, 0x37, 0x77, 0x30, 0xCF, 0xF9, 0x0B, 0x77, 0x72, 0x86, 0x27,
  0x96, 0x10, 0x1D, 0xFF, 0x90, 0x27, 0x77, 0x06, 0xC8, 0x3D, 0x30, 0x1D, 0xFF, 0x04, 0x77, 0x60,
  0x7E, 0x82, 0xE3, 0x02, 0xFF, 0x02, 0x77, 0x50, 0x7F, 0x98, 0x1E, 0x4C, 0xFE, 0x0B, 0x77, 0x50,
  0x7C, 0x0E, 0x09, 0xF9, 0x0E, 0xFA, 0x0D, 0x01, 0x77, 0x40, 0x7C, 0x82, 0xE3, 0x07, 0xE8, 0x16,
  0x1D, 0xF0, 0xD0, 0x24, 0x82, 0x7E, 0xB1, 0x48, 0x25, 0xED, 0x32, 0x07, 0xD0, 0x73, 0x07, 0xC8,
  0x3E, 0x30, 0x1D, 0xD0, 0xD0, 0x24, 0x02, 0xB0, 0x94, 0xB8, 0x1B, 0x07, 0xF0, 0x43, 0x07, 0xC8,
  0x3E, 0x30, 0x1A, 0xB0, 0xB0, 0x15, 0x09, 0xB0, 0x93, 0x03, 0xB0, 0xC0, 0x3C, 0x0E, 0x0D, 0xB0,
  0x43, 0x07, 0xC0, 0xE0, 0x32, 0x81, 0x24, 0x26, 0x03, 0xC0, 0x43, 0x07, 0xB0, 0x90, 0xBB, 0x82,
  0xE3, 0x1D, 0xB0, 0x43, 0x07, 0xC0, 0xD7, 0x30, 0x30, 0xDB, 0x0D, 0x40, 0xBB, 0x06, 0x0E, 0xB0,
  0x42, 0x01, 0x0D, 0xB0, 0x43, 0x07, 0xC0, 0x47, 0x02, 0x09, 0xD0, 0x43, 0x02, 0xC0, 0x20, 0xCB,
  0x0B, 0x30, 0x10, 0xDB, 0x04, 0x30, 0xCB, 0x06, 0x60, 0x7E, 0x07, 0x40, 0x9B, 0x81, 0xB0, 0x7C,
  0x0B, 0x30, 0x10, 0xDB, 0x81, 0x40, 0xAC, 0x03, 0x60, 0xED, 0x07, 0x40, 0x3C, 0x05, 0x20, 0xBC,
  0x0B, 0x30, 0x10, 0xDB, 0x0B, 0xC0, 0xB7, 0x0C, 0xB0, 0xD0, 0x45, 0x0C, 0xB0, 0xC4, 0x0C, 0xC0,
  0xB3, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x82, 0x2A, 0xA4, 0x60, 0xBC, 0x03, 0x50, 0xCC, 0x0B, 0x30,
  0x10, 0xEC, 0x0D, 0x02, 0x77, 0x30, 0xBC, 0x09, 0x70, 0xCC, 0x0B, 0x20, 0x9C, 0x0D, 0x02, 0x77,
  0x20, 0x30, 0xCC, 0x0B, 0x72, 0x0C, 0xC0, 0xB0, 0xAC, 0x0D, 0x02, 0x77, 0x10, 0x20, 0x9D, 0x0D,
  0x01, 0x73, 0x0C, 0xF9, 0x0D, 0x02, 0x76, 0x81, 0x47, 0xBE, 0x0B, 0x01, 0x75, 0x0C, 0xE0, 0xD0,
  0x27, 0x50, 0x5F, 0xA0, 0x97, 0x71, 0x0B, 0xC0, 0xD0, 0x27, 0x60, 0xEF, 0x0C, 0x03, 0x77, 0x38,
  0x25, 0xAA, 0x77, 0x71, 0x0D, 0xD0, 0xB0, 0x58, 0x0C, 0x20, 0x84, 0x3B, 0xC9, 0x61, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_satellite_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_satellite_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_saved_search 48x48, 4-bit Alpha,  RLE, 289 bytes.
static const unsigned char ic_round_48_action_saved_search_data[] PROGMEM = {
  0x71, 0x82, 0x27, 0xBD, 0xA8, 0x2E, 0xB8, 0x37, 0x77, 0x30, 0x30, 0xBF, 0xB0, 0xC0, 0x47, 0x77,
  0x09, 0xFF, 0x09, 0x77, 0x40, 0x10, 0xBF, 0xFA, 0x0C, 0x01, 0x77, 0x20, 0xBD, 0x81, 0xB6, 0x22,
  0x81, 0x26, 0xBD, 0x0C, 0x77, 0x10, 0x9C, 0x0D, 0x03, 0x71, 0x03, 0x0D, 0xC0, 0x97, 0x60, 0x3C,
  0x0B, 0x01, 0x40, 0x02, 0x40, 0x10, 0xBC, 0x03, 0x75, 0x0B, 0xB0, 0xD0, 0x15, 0x00, 0x75, 0x01,
  0x0D, 0xB0, 0xB7, 0x40, 0x2C, 0x03, 0x60, 0x0C, 0x60, 0x3C, 0x02, 0x73, 0x07, 0xB0, 0xB6, 0x02,
  0xA0, 0x26, 0x0B, 0xB0, 0x77, 0x30, 0xBB, 0x06, 0x28, 0x00, 0x10, 0x7A, 0x07, 0x80, 0x01, 0x20,
  0x6B, 0x0A, 0x73, 0x0D, 0xB0, 0x22, 0x0A, 0xFB, 0x0A, 0x20, 0x2B, 0x0C, 0x73, 0xC4, 0x07, 0xF9,
  0x07, 0x4B, 0x0E, 0x73, 0x0E, 0xB5, 0x04, 0x0E, 0xC0, 0xE0, 0x45, 0xB0, 0xD7, 0x30, 0xDB, 0x02,
  0x50, 0x9C, 0x09, 0x50, 0x2B, 0x0C, 0x73, 0x0B, 0xB0, 0x65, 0x0E, 0xC0, 0xE5, 0x06, 0xB0, 0xB7,
  0x30, 0x7B, 0x0B, 0x48, 0x63, 0xFE, 0x55, 0xEF, 0x34, 0x0B, 0xB0, 0x67, 0x30, 0x3C, 0x03, 0x38,
  0x18, 0xC2, 0x28, 0x12, 0xC8, 0x30, 0x3C, 0x01, 0x74, 0x0C, 0xB0, 0xD0, 0x12, 0x07, 0x60, 0x72,
  0x01, 0x0D, 0xB0, 0xA7, 0x50, 0x3C, 0x0B, 0x01, 0x73, 0x01, 0x0B, 0xC0, 0x27, 0x60, 0x9C, 0x0D,
  0x03, 0x71, 0x03, 0x0D, 0xC0, 0x97, 0x71, 0x0C, 0xD8, 0x1B, 0x62, 0x28, 0x12, 0x6B, 0xF0, 0x57,
  0x70, 0x10, 0xCF, 0xFE, 0x05, 0x77, 0x10, 0x9F, 0xF0, 0x9D, 0x05, 0x77, 0x10, 0x30, 0xBF, 0xB8,
  0x2A, 0x20, 0x5D, 0x05, 0x77, 0x28, 0x90, 0x27, 0xAC, 0xFD, 0xDA, 0x61, 0x40, 0x5D, 0x05, 0x77,
  0x77, 0x20, 0x5D, 0x05, 0x77, 0x77, 0x20, 0x5D, 0x05, 0x77, 0x77, 0x20, 0x5D, 0x05, 0x77, 0x77,
  0x20, 0x5D, 0x05, 0x77, 0x77, 0x20, 0x5D, 0x05, 0x77, 0x77, 0x20, 0x5D, 0x05, 0x77, 0x77, 0x20,
  0x5C, 0x0E, 0x77, 0x77, 0x30, 0x5C, 0x01, 0x77, 0x77, 0x38, 0x25, 0xEF, 0x87, 0x77, 0x76, 0x01,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_saved_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_saved_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_savings 48x48, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_round_48_action_savings_data[] PROGMEM = {
  0x77, 0x74, 0x84, 0x4A, 0xCE, 0xD7, 0x77, 0x77, 0x40, 0x40, 0xDE, 0x08, 0x77, 0x77, 0x20, 0x8F,
  0x90, 0xE7, 0x77, 0x71, 0x08, 0xFA, 0x0E, 0x77, 0x83, 0x15, 0xAD, 0xEF, 0xFE, 0x09, 0x76, 0x07,
  0x0E, 0xFF, 0xFB, 0x05, 0x74, 0x01, 0x0C, 0xFF, 0xFD, 0x04, 0x73, 0x01, 0x0D, 0xFF, 0xFE, 0x0E,
  0x03, 0x72, 0x0C, 0xFF, 0xFF, 0x90, 0xE0, 0x37, 0x07, 0xFF, 0xFF, 0xB0, 0xE0, 0x35, 0x01, 0x0E,
  0xFB, 0x0B, 0x01, 0x60, 0x10, 0xBF, 0xD0, 0xE0, 0x34, 0x05, 0xFC, 0x01, 0x71, 0x01, 0xFF, 0xA8,
  0x1D, 0x4A, 0xFC, 0x01, 0x71, 0x01, 0xFF, 0xB0, 0x0D, 0xFC, 0x0B, 0x01, 0x60, 0x10, 0xBF, 0xFC,
  0x0E, 0xFF, 0xFC, 0x82, 0xB1, 0x1B, 0x80, 0xC0, 0xF0, 0x12, 0x01, 0xFB, 0x0E, 0xFF, 0xFC, 0x01,
  0x20, 0x1F, 0xB0, 0xCF, 0xFF, 0xC8, 0x2B, 0x11, 0xBF, 0xB0, 0xA8, 0x0C, 0x3F, 0x07, 0x80, 0xC3,
  0xF0, 0x58, 0x0C, 0x3F, 0x02, 0x80, 0xC3, 0xF1, 0x0E, 0x80, 0xC2, 0xF1, 0x0B, 0x80, 0xC2, 0xF1,
  0x08, 0x80, 0xC1, 0xF8, 0x1A, 0x04, 0xFF, 0xFF, 0xF0, 0xB0, 0x62, 0x01, 0xFF, 0xFF, 0xC8, 0x1C,
  0x61, 0x50, 0xCF, 0xFF, 0xFB, 0x02, 0x70, 0x8F, 0xFF, 0xFA, 0x0D, 0x71, 0x04, 0xFF, 0xFF, 0xA0,
  0x87, 0x10, 0x1F, 0xFF, 0xFA, 0x03, 0x72, 0x0C, 0xFF, 0xFF, 0x0E, 0x73, 0x08, 0xFF, 0xFF, 0x0A,
  0x73, 0x04, 0xFF, 0xFF, 0x05, 0x74, 0x0E, 0xFB, 0x0D, 0x40, 0xDF, 0xC0, 0x17, 0x40, 0x9F, 0xB0,
  0xA4, 0x0A, 0xFB, 0x0A, 0x75, 0x02, 0x0E, 0xF9, 0x0E, 0x01, 0x40, 0x10, 0xEF, 0x90, 0xE0, 0x27,
  0x68, 0x12, 0xAE, 0xC8, 0x1D, 0xA1, 0x68, 0x11, 0xAD, 0xC8, 0x1E, 0xA2, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_savings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_savings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_schedule 48x48, 4-bit Alpha,  RLE, 344 bytes.
static const unsigned char ic_round_48_action_schedule_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xBD, 0x0D, 0x06, 0x75, 0x06,
  0x0D, 0xD0, 0xA7, 0x40, 0xBD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x37, 0x74,
  0x03, 0x0D, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xD0, 0x17, 0x77, 0x10, 0x10, 0xDB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x73, 0x81, 0x8F, 0x87, 0x40,
  0x3C, 0x09, 0x30, 0x1C, 0x07, 0x74, 0xB7, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0D, 0x75, 0xB7, 0x60,
  0xDB, 0x08, 0x20, 0xDB, 0x06, 0x75, 0xB7, 0x60, 0x6B, 0x81, 0xD0, 0x3C, 0x76, 0xB7, 0x7C, 0x03,
  0x07, 0xB0, 0xB7, 0x6B, 0x77, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x76, 0xB7, 0x70, 0x6B, 0x0A, 0x0C,
  0xB0, 0x37, 0x6B, 0x77, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x76, 0xB7, 0x70, 0x2B, 0x0E, 0xC7, 0x7B,
  0x77, 0x1F, 0x97, 0x7B, 0x03, 0x77, 0xC0, 0xEB, 0x02, 0x76, 0x0C, 0xB0, 0x90, 0x17, 0x40, 0x2B,
  0x0E, 0x0C, 0xB0, 0x37, 0x60, 0x20, 0xDB, 0x0E, 0x06, 0x73, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x77,
  0x10, 0x7C, 0x0C, 0x03, 0x71, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x77, 0x20, 0x20, 0xBC, 0x09, 0x01,
  0x60, 0xBB, 0x07, 0x03, 0xC7, 0x74, 0x04, 0x0D, 0xB0, 0xE0, 0x25, 0xC8, 0x13, 0x0D, 0xB0, 0x67,
  0x75, 0x07, 0xB0, 0x64, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xD7, 0x76, 0x81, 0x29, 0xA5, 0x0D, 0xB0,
  0x82, 0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x94,
  0x01, 0x0E, 0xB0, 0xD0, 0x17, 0x77, 0x10, 0x10, 0xDB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77,
  0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0D, 0x03, 0x77, 0x40, 0x30, 0xDC, 0x09, 0x72, 0x0B, 0xD0,
  0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xBD, 0x0D, 0x06, 0x75, 0x06, 0x0D, 0xD0, 0xA7, 0x60, 0x9F,
  0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77,
  0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48,
  0x33, 0x7A, 0xCE, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_schedule() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_schedule_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_schedule_send 48x48, 4-bit Alpha,  RLE, 254 bytes.
static const unsigned char ic_round_48_action_schedule_send_data[] PROGMEM = {
  0x83, 0x4D, 0xD8, 0x17, 0x77, 0x75, 0x0D, 0xC0, 0xA0, 0x47, 0x77, 0x73, 0xF0, 0xD0, 0x67, 0x77,
  0x71, 0xFA, 0x81, 0xE9, 0x27, 0x77, 0x5F, 0xD0, 0xB0, 0x57, 0x77, 0x3F, 0xF8, 0x1D, 0x71, 0x77,
  0x7F, 0xFB, 0x09, 0x03, 0x77, 0x5F, 0xFD, 0x0C, 0x05, 0x77, 0x3F, 0xFF, 0x81, 0xE8, 0x17, 0x7F,
  0xFF, 0xB0, 0xA0, 0x47, 0x50, 0x9F, 0xFF, 0xC0, 0xD0, 0x67, 0x48, 0x15, 0x9D, 0xFF, 0xD8, 0x2C,
  0x74, 0x27, 0x71, 0x82, 0x15, 0x9D, 0xFE, 0x0A, 0x02, 0x77, 0x72, 0x82, 0x15, 0x9D, 0xF0, 0xD0,
  0x37, 0x77, 0x71, 0x82, 0x15, 0x9D, 0xA0, 0xB0, 0x17, 0x77, 0x72, 0x84, 0x15, 0x9D, 0xFB, 0x68,
  0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x78, 0x21, 0x59, 0xDC, 0x0D, 0x01, 0x40, 0x40, 0xDF, 0x90, 0xD0,
  0x47, 0x18, 0x21, 0x59, 0xDF, 0x90, 0x34, 0x08, 0xFD, 0x08, 0x48, 0x15, 0x9D, 0xFC, 0x0A, 0x40,
  0x8F, 0xF0, 0x82, 0x09, 0xFF, 0x02, 0x30, 0x4F, 0x00, 0x3F, 0x04, 0x1F, 0xF0, 0xC4, 0x0D, 0xF2,
  0xF0, 0xD1, 0xFF, 0x07, 0x30, 0x5F, 0x92, 0xF9, 0x05, 0xFF, 0x03, 0x30, 0x9F, 0x92, 0xF9, 0x09,
  0xFF, 0x02, 0x30, 0xDF, 0x92, 0xF9, 0x0D, 0xFF, 0x40, 0xEF, 0x92, 0x0E, 0xF0, 0xEF, 0xD0, 0xB0,
  0x44, 0x0E, 0xF9, 0x82, 0x30, 0x2E, 0xE0, 0xEF, 0xA8, 0x1E, 0x82, 0x60, 0xDF, 0x98, 0x3E, 0x20,
  0x2E, 0xD0, 0xDF, 0x0C, 0x06, 0x72, 0x09, 0xFA, 0x82, 0xE2, 0x02, 0xD0, 0x90, 0xDC, 0x0A, 0x03,
  0x74, 0x05, 0xFB, 0x82, 0xE2, 0x0D, 0xC8, 0x45, 0x4D, 0xD8, 0x17, 0x70, 0xDF, 0xB0, 0xE0, 0xCC,
  0x0D, 0x77, 0x60, 0x4F, 0xFA, 0x04, 0x77, 0x70, 0x8F, 0xF0, 0x87, 0x77, 0x20, 0x8F, 0xD0, 0x87,
  0x77, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x78, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_schedule_send() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 9, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_schedule_send_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_search_off 48x48, 4-bit Alpha,  RLE, 275 bytes.
static const unsigned char ic_round_48_action_search_off_data[] PROGMEM = {
  0x75, 0x89, 0x02, 0x7A, 0xDF, 0xDD, 0xB7, 0x27, 0x77, 0x50, 0x30, 0xBF, 0xB0, 0xB0, 0x37, 0x77,
  0x20, 0x8F, 0xF0, 0x87, 0x77, 0x0B, 0xFF, 0xA0, 0xB7, 0x75, 0x0B, 0xD8, 0x6B, 0x52, 0x01, 0x26,
  0xCD, 0x0B, 0x77, 0x30, 0x8C, 0x0D, 0x03, 0x71, 0x05, 0x0E, 0xC0, 0x87, 0x71, 0x03, 0xC0, 0xB0,
  0x17, 0x30, 0x10, 0xDC, 0x03, 0x77, 0x0B, 0xB0, 0xD0, 0x17, 0x50, 0x20, 0xEB, 0x0B, 0x76, 0x01,
  0xC0, 0x47, 0x70, 0x5C, 0x02, 0x75, 0x07, 0xB0, 0xC7, 0x72, 0x0C, 0xB0, 0x77, 0x50, 0xAB, 0x06,
  0x77, 0x20, 0x6B, 0x0B, 0x75, 0x0D, 0xB0, 0x37, 0x72, 0x02, 0xB0, 0xD7, 0x77, 0x76, 0xB0, 0xE7,
  0x77, 0x76, 0xB0, 0xE7, 0x77, 0x75, 0x02, 0xB0, 0xD7, 0x77, 0x75, 0x06, 0xB0, 0xA7, 0x18, 0x19,
  0xB1, 0x68, 0x11, 0xB9, 0x76, 0x0B, 0xB0, 0x77, 0x18, 0x2B, 0xFC, 0x14, 0x82, 0x1C, 0xFB, 0x75,
  0x03, 0xC0, 0x27, 0x18, 0x31, 0xCF, 0xC1, 0x28, 0x31, 0xCF, 0xC1, 0x74, 0x01, 0x0D, 0xB0, 0xB7,
  0x38, 0x90, 0x1C, 0xFC, 0x11, 0xCF, 0xC1, 0x74, 0x01, 0x0B, 0xC0, 0x37, 0x48, 0x61, 0xCF, 0xCC,
  0xFC, 0x17, 0x40, 0x30, 0xDC, 0x08, 0x76, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x28, 0x12, 0x6B, 0xE0,
  0x17, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x7F, 0xE0, 0x77, 0x38, 0x61, 0xCF, 0xCC, 0xFC, 0x16, 0xF9,
  0x08, 0x01, 0xC0, 0x77, 0x18, 0x90, 0x1C, 0xFC, 0x11, 0xCF, 0xC1, 0x5E, 0x0A, 0x03, 0x2D, 0x07,
  0x68, 0x31, 0xCF, 0xC1, 0x28, 0x31, 0xCF, 0xC1, 0x49, 0x83, 0xDD, 0xA7, 0x24, 0x07, 0xD0, 0x75,
  0x82, 0xBF, 0xC1, 0x48, 0x21, 0xCF, 0xB7, 0x71, 0x07, 0xD0, 0x74, 0x81, 0x9B, 0x16, 0x81, 0x1B,
  0x97, 0x72, 0x07, 0xD0, 0x77, 0x77, 0x74, 0x07, 0xD0, 0x77, 0x77, 0x74, 0x07, 0xD0, 0x77, 0x77,
  0x74, 0x07, 0xD0, 0x67, 0x77, 0x74, 0x07, 0xC0, 0xE7, 0x77, 0x75, 0x07, 0xB0, 0xE7, 0x77, 0x76,
  0x07, 0xA0, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_search_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_search_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_search 48x48, 4-bit Alpha,  RLE, 235 bytes.
static const unsigned char ic_round_48_action_search_data[] PROGMEM = {
  0x71, 0x89, 0x02, 0x6A, 0xDD, 0xDD, 0xB7, 0x27, 0x77, 0x10, 0x30, 0xAF, 0xB0, 0xB0, 0x37, 0x75,
  0x08, 0xFF, 0x09, 0x77, 0x20, 0x10, 0xBF, 0xFA, 0x0B, 0x77, 0x10, 0xBD, 0x81, 0xB6, 0x22, 0x81,
  0x26, 0xBD, 0x0B, 0x76, 0x08, 0xC0, 0xD0, 0x37, 0x10, 0x30, 0xDC, 0x09, 0x74, 0x03, 0xC0, 0xB0,
  0x17, 0x30, 0x10, 0xBC, 0x03, 0x73, 0x0A, 0xB0, 0xD0, 0x17, 0x50, 0x10, 0xDB, 0x0B, 0x72, 0x02,
  0xC0, 0x37, 0x70, 0x3C, 0x02, 0x71, 0x07, 0xB0, 0xB7, 0x72, 0x0B, 0xB0, 0x77, 0x10, 0xAB, 0x06,
  0x77, 0x20, 0x6B, 0x0B, 0x71, 0x0D, 0xB0, 0x27, 0x72, 0x02, 0xB0, 0xD7, 0x10, 0xEB, 0x77, 0x4B,
  0x0E, 0x71, 0x0E, 0xB7, 0x74, 0xB0, 0xE7, 0x10, 0xDB, 0x02, 0x77, 0x20, 0x2B, 0x0D, 0x71, 0x0B,
  0xB0, 0x67, 0x72, 0x06, 0xB0, 0xA7, 0x10, 0x7B, 0x0B, 0x77, 0x20, 0xBB, 0x07, 0x71, 0x02, 0xC0,
  0x37, 0x70, 0x3C, 0x02, 0x72, 0x0B, 0xB0, 0xD0, 0x17, 0x50, 0x10, 0xDB, 0x0B, 0x73, 0x03, 0xC0,
  0xB0, 0x17, 0x30, 0x10, 0xBC, 0x03, 0x74, 0x09, 0xC0, 0xD0, 0x37, 0x10, 0x30, 0xDC, 0x08, 0x76,
  0x0B, 0xD8, 0x1B, 0x62, 0x28, 0x12, 0x6B, 0xE0, 0x17, 0x70, 0xBF, 0xFE, 0x07, 0x76, 0x09, 0xFF,
  0x08, 0x01, 0xC0, 0x77, 0x60, 0x30, 0xBF, 0xB0, 0xA0, 0x32, 0xD0, 0x77, 0x78, 0x90, 0x27, 0xBD,
  0xDF, 0xDA, 0x71, 0x40, 0x7D, 0x07, 0x77, 0x77, 0x07, 0xD0, 0x77, 0x77, 0x70, 0x7D, 0x07, 0x77,
  0x77, 0x07, 0xD0, 0x77, 0x77, 0x70, 0x7D, 0x07, 0x77, 0x77, 0x07, 0xD0, 0x67, 0x77, 0x70, 0x7C,
  0x0E, 0x77, 0x77, 0x10, 0x7B, 0x0E, 0x77, 0x77, 0x20, 0x7A, 0x06,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_segment 48x48, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_48_action_segment_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xFF, 0xE0, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xFF, 0xC0, 0xD0, 0x48, 0x0B, 0xC0, 0x00, 0x40, 0xDF, 0xFE, 0x0D, 0x04, 0x75, 0x0D, 0xFF,
  0xF9, 0x0D, 0x75, 0x0D, 0xFF, 0xF9, 0x0D, 0x75, 0x04, 0x0D, 0xFF, 0xE0, 0xD0, 0x48, 0x0B, 0xC0,
  0x00, 0x40, 0xDF, 0xFE, 0x0D, 0x04, 0x75, 0x0D, 0xFF, 0xF9, 0x0D, 0x75, 0x0D, 0xFF, 0xF9, 0x0D,
  0x75, 0x04, 0x0D, 0xFF, 0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_segment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 41, 35), Box(0, 0, 47, 47),
      ic_round_48_action_segment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_send_and_archive 48x48, 4-bit Alpha,  RLE, 255 bytes.
static const unsigned char ic_round_48_action_send_and_archive_data[] PROGMEM = {
  0x0C, 0x05, 0x80, 0xC0, 0x0A, 0x81, 0xE8, 0x17, 0x77, 0x75, 0xD0, 0xA0, 0x47, 0x77, 0x73, 0xF0,
  0xD0, 0x67, 0x77, 0x71, 0xFA, 0x81, 0xE8, 0x27, 0x77, 0x5F, 0xD0, 0xB0, 0x47, 0x77, 0x3F, 0xF8,
  0x1D, 0x71, 0x77, 0x7F, 0xFB, 0x09, 0x03, 0x77, 0x5F, 0xFD, 0x0C, 0x05, 0x77, 0x3F, 0xFF, 0x81,
  0xE8, 0x17, 0x7F, 0xFF, 0xB0, 0xA0, 0x47, 0x5F, 0xFF, 0xD0, 0xD0, 0x67, 0x38, 0x21, 0x59, 0xDF,
  0xFD, 0x82, 0xC7, 0x42, 0x77, 0x18, 0x21, 0x59, 0xDF, 0xE0, 0xA0, 0x27, 0x77, 0x28, 0x21, 0x59,
  0xDF, 0x0D, 0x03, 0x77, 0x77, 0x18, 0x21, 0x59, 0xDA, 0x0B, 0x01, 0x77, 0x77, 0x28, 0x41, 0x59,
  0xDF, 0xB6, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x82, 0x15, 0x9D, 0xC0, 0xD0, 0x14, 0x04, 0x0D,
  0xF9, 0x0D, 0x04, 0x71, 0x82, 0x15, 0x9D, 0xF9, 0x03, 0x40, 0x8F, 0xD0, 0x83, 0x82, 0x15, 0x9D,
  0xFC, 0x0A, 0x40, 0x8F, 0xF0, 0x82, 0xFF, 0x90, 0x23, 0x04, 0xF0, 0x03, 0xF0, 0x41, 0xFF, 0x0C,
  0x40, 0xDF, 0x2F, 0x0D, 0x1F, 0xF0, 0x73, 0x05, 0xF9, 0x2F, 0x90, 0x5F, 0xF0, 0x33, 0x09, 0xF9,
  0x2F, 0x90, 0x9F, 0xF0, 0x23, 0x0D, 0xF9, 0x2F, 0x90, 0xDF, 0xF4, 0x0E, 0xF9, 0x2F, 0x90, 0xEF,
  0xD0, 0xB0, 0x44, 0x0E, 0xC0, 0x97, 0x10, 0x9C, 0x0E, 0xFA, 0x81, 0xE8, 0x26, 0x0D, 0xC0, 0x97,
  0x10, 0x9C, 0x0D, 0xF0, 0xC0, 0x67, 0x20, 0x9D, 0x08, 0x60, 0x7D, 0x09, 0xD0, 0xA0, 0x47, 0x40,
  0x5E, 0x08, 0x40, 0x7E, 0x05, 0xA8, 0x1E, 0x81, 0x77, 0x0D, 0xE0, 0x82, 0x07, 0xE8, 0x2D, 0x0C,
  0x57, 0x73, 0x04, 0xF0, 0x0A, 0xF0, 0x47, 0x77, 0x08, 0xFF, 0x08, 0x77, 0x72, 0x08, 0xFD, 0x08,
  0x77, 0x74, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x77, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_send_and_archive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_send_and_archive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_sensors_off 48x48, 4-bit Alpha,  RLE, 396 bytes.
static const unsigned char ic_round_48_action_sensors_off_data[] PROGMEM = {
  0x18, 0x12, 0x74, 0x80, 0xC1, 0x00, 0x10, 0xEA, 0x07, 0x80, 0xC0, 0x00, 0x5C, 0x07, 0x77, 0x77,
  0x70, 0x10, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x75, 0x01, 0x02, 0x70, 0x30,
  0xEC, 0x07, 0x77, 0x73, 0x06, 0xA0, 0x87, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x20, 0xDB, 0x04, 0x70,
  0xED, 0x07, 0x77, 0x71, 0x0B, 0xB0, 0xD0, 0x15, 0x08, 0xF0, 0x77, 0x77, 0x03, 0xC0, 0x84, 0x01,
  0xFA, 0x07, 0x77, 0x70, 0x7B, 0x0E, 0x01, 0x30, 0x7B, 0x81, 0xD3, 0xEC, 0x07, 0x77, 0x81, 0x47,
  0x24, 0x0D, 0xB0, 0x73, 0x0D, 0xB8, 0x26, 0x03, 0xEC, 0x07, 0x75, 0x05, 0xA0, 0xE0, 0x13, 0x06,
  0xB0, 0xD2, 0x03, 0xB0, 0xE3, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x9B, 0x09, 0x40, 0xEB, 0x81, 0x20,
  0x6B, 0x0A, 0x30, 0x1E, 0x07, 0x73, 0x05, 0xC0, 0x13, 0x0A, 0xB8, 0x16, 0x0A, 0xB0, 0x63, 0x06,
  0xF0, 0x77, 0x30, 0xCB, 0x07, 0x30, 0x6B, 0x81, 0xA0, 0xCB, 0x03, 0x30, 0xBF, 0x90, 0x77, 0x20,
  0x6B, 0x0A, 0x30, 0x3B, 0x81, 0xC0, 0xDB, 0x01, 0x30, 0xCB, 0x06, 0x0E, 0xC0, 0x77, 0x10, 0x2B,
  0x0D, 0x30, 0x2B, 0x81, 0xD0, 0xEB, 0x40, 0xEB, 0x81, 0x13, 0xEC, 0x07, 0x71, 0xB0, 0xE4, 0xB8,
  0x1E, 0x0E, 0xB4, 0x0E, 0xB2, 0x03, 0x0E, 0xC0, 0x76, 0x01, 0xB0, 0xE4, 0xB8, 0x1E, 0x0D, 0xB0,
  0x23, 0x0D, 0xB0, 0x22, 0x03, 0x0E, 0xC0, 0x75, 0x03, 0xB0, 0xC3, 0x01, 0xB8, 0x1D, 0x0C, 0xB0,
  0x33, 0x0A, 0xB0, 0x63, 0x03, 0x0E, 0xC0, 0x74, 0x01, 0x0C, 0xA0, 0xA3, 0x03, 0xB8, 0x1C, 0x0A,
  0xB0, 0x63, 0x07, 0xB0, 0xC4, 0x03, 0x0E, 0xC0, 0x74, 0x82, 0x1C, 0xF6, 0x30, 0x6B, 0x81, 0xA0,
  0x6B, 0x0A, 0x30, 0x1C, 0x05, 0x40, 0x30, 0xEC, 0x07, 0x48, 0x11, 0xC1, 0x30, 0xAB, 0x81, 0x60,
  0x2B, 0x0E, 0x40, 0x9B, 0x09, 0x50, 0x30, 0xEC, 0x07, 0x72, 0x0E, 0xB0, 0x32, 0x0D, 0xB0, 0x63,
  0x01, 0x0E, 0xA0, 0x56, 0x03, 0x0E, 0xC0, 0x77, 0x06, 0xB0, 0xD3, 0x07, 0xB0, 0xD4, 0x81, 0x27,
  0x37, 0x10, 0x30, 0xEC, 0x07, 0x60, 0xDB, 0x07, 0x30, 0x10, 0xEB, 0x07, 0x77, 0x10, 0x30, 0xEC,
  0x07, 0x50, 0xCB, 0x01, 0x40, 0x8C, 0x03, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x58, 0x1C, 0xF8, 0x50,
  0x10, 0xDB, 0x0B, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xA7, 0x04, 0xB0, 0xD7, 0x73, 0x03, 0x0E,
  0xC0, 0x77, 0x60, 0x8A, 0x06, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x76, 0x02, 0x01, 0x77, 0x60, 0x30,
  0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x77,
  0x70, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x04, 0x77, 0x77, 0x70, 0x30, 0xEB, 0x07,
  0x80, 0xC0, 0x08, 0x33, 0xEF, 0xE2, 0x80, 0xC1, 0x08, 0x11, 0x51, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_sensors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 43, 44), Box(0, 0, 47, 47),
      ic_round_48_action_sensors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_sensors 48x48, 4-bit Alpha,  RLE, 315 bytes.
static const unsigned char ic_round_48_action_sensors_data[] PROGMEM = {
  0x50, 0x20, 0x17, 0x77, 0x50, 0x10, 0x27, 0x20, 0x8A, 0x06, 0x77, 0x73, 0x06, 0xA0, 0x87, 0x04,
  0xB0, 0xD7, 0x77, 0x30, 0xDB, 0x04, 0x50, 0x10, 0xDB, 0x0B, 0x77, 0x73, 0x0B, 0xB0, 0xD0, 0x14,
  0x08, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x08, 0x30, 0x10, 0xEB, 0x07, 0x77, 0x75, 0x07, 0xB0, 0xE0,
  0x12, 0x07, 0xB0, 0xD4, 0x81, 0x17, 0x37, 0x78, 0x14, 0x72, 0x40, 0xDB, 0x07, 0x20, 0xDB, 0x06,
  0x30, 0x10, 0xEA, 0x05, 0x75, 0x05, 0xA0, 0xE0, 0x13, 0x06, 0xB8, 0x1D, 0x02, 0xB0, 0xE4, 0x09,
  0xB0, 0x97, 0x50, 0x9B, 0x09, 0x40, 0xEB, 0x02, 0x06, 0xB0, 0xA3, 0x01, 0xC0, 0x57, 0x50, 0x5C,
  0x01, 0x30, 0xAB, 0x06, 0x0A, 0xB0, 0x63, 0x07, 0xB0, 0xC4, 0x84, 0x1A, 0xDD, 0xA1, 0x40, 0xCB,
  0x07, 0x30, 0x6B, 0x0A, 0x0C, 0xB0, 0x33, 0x0A, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x06,
  0xB0, 0xA3, 0x03, 0xB0, 0xC0, 0xDB, 0x02, 0x30, 0xDB, 0x02, 0x30, 0xAE, 0x0A, 0x30, 0x2B, 0x0D,
  0x30, 0x2B, 0x0D, 0x0E, 0xB4, 0x0E, 0xB4, 0x0D, 0xE0, 0xD4, 0xB0, 0xE4, 0xB0, 0x0E, 0xB4, 0x0E,
  0xB4, 0x0D, 0xE0, 0xD4, 0xB0, 0xE4, 0xB0, 0xE0, 0xDB, 0x02, 0x30, 0xDB, 0x02, 0x30, 0xAE, 0x0A,
  0x30, 0x2B, 0x0D, 0x30, 0x2B, 0x0D, 0x0C, 0xB0, 0x33, 0x0A, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0xE0,
  0x13, 0x06, 0xB0, 0xA3, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x30, 0x7B, 0x0C, 0x48, 0x41, 0xAD, 0xDA,
  0x14, 0x0C, 0xB0, 0x73, 0x06, 0xB0, 0xA0, 0x6B, 0x0A, 0x30, 0x1C, 0x05, 0x75, 0x05, 0xC0, 0x13,
  0x0A, 0xB0, 0x60, 0x2B, 0x0E, 0x40, 0x9B, 0x09, 0x75, 0x09, 0xB0, 0x94, 0x0E, 0xB8, 0x12, 0x0D,
  0xB0, 0x63, 0x01, 0x0E, 0xA0, 0x57, 0x50, 0x5A, 0x0E, 0x01, 0x30, 0x6B, 0x0D, 0x20, 0x7B, 0x0D,
  0x48, 0x12, 0x73, 0x77, 0x81, 0x37, 0x24, 0x0D, 0xB0, 0x72, 0x01, 0x0E, 0xB0, 0x77, 0x77, 0x50,
  0x7B, 0x0E, 0x01, 0x30, 0x8C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x84, 0x01, 0x0D, 0xB0, 0xB7, 0x77,
  0x30, 0xBB, 0x0D, 0x01, 0x50, 0x4B, 0x0D, 0x77, 0x73, 0x0D, 0xB0, 0x47, 0x08, 0xA0, 0x67, 0x77,
  0x30, 0x6A, 0x08, 0x72, 0x02, 0x01, 0x77, 0x75, 0x01, 0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_sensors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_round_48_action_sensors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_accessibility 48x48, 4-bit Alpha,  RLE, 227 bytes.
static const unsigned char ic_round_48_action_settings_accessibility_data[] PROGMEM = {
  0x77, 0x18, 0x41, 0xAD, 0xDA, 0x17, 0x77, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x70, 0xAE,
  0x0A, 0x77, 0x77, 0x0D, 0xE0, 0xD7, 0x77, 0x70, 0xDE, 0x0D, 0x77, 0x77, 0x0A, 0xE0, 0xA7, 0x77,
  0x70, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x77, 0x18, 0x41, 0xAD, 0xDA, 0x17, 0x72, 0x82, 0x47, 0x63,
  0x77, 0x75, 0x84, 0x36, 0x74, 0x04, 0xD8, 0x7D, 0xB9, 0x75, 0x43, 0x11, 0x68, 0x71, 0x13, 0x45,
  0x79, 0xBD, 0xD0, 0x40, 0x8F, 0xFF, 0xFE, 0x08, 0x04, 0xFF, 0xFF, 0xE8, 0x44, 0x04, 0x8C, 0xEF,
  0xFF, 0xD8, 0x2E, 0xC8, 0x46, 0x85, 0x25, 0x79, 0xBC, 0xEF, 0xD8, 0x5E, 0xCB, 0x97, 0x52, 0x77,
  0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F,
  0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7, 0x77, 0x3F, 0xD7,
  0x77, 0x3F, 0xD7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4,
  0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77,
  0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x30, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x77, 0x73, 0x82,
  0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x48, 0x0B, 0xD0, 0x08, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48,
  0x24, 0xDD, 0x47, 0x72, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD7, 0x72, 0x0D, 0xA0,
  0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD7, 0x72, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82,
  0x4D, 0xD4, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_accessibility() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 41, 47), Box(0, 0, 47, 47),
      ic_round_48_action_settings_accessibility_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_applications 48x48, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_round_48_action_settings_applications_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAB, 0x3F, 0x0E, 0x02, 0x20, 0x20, 0xEF, 0xFF, 0xFA,
  0x0A, 0x40, 0xAF, 0xFF, 0xFA, 0x07, 0x40, 0x7F, 0xFF, 0xC8, 0x39, 0xAE, 0xE6, 0x68, 0x36, 0xEE,
  0x99, 0xFF, 0xD0, 0x93, 0x01, 0x71, 0x01, 0x30, 0x9F, 0xFB, 0x0E, 0x01, 0x77, 0x20, 0x10, 0xEF,
  0xFA, 0x0A, 0x68, 0x41, 0xAD, 0xDA, 0x16, 0x0A, 0xFF, 0xA0, 0xE0, 0x34, 0x01, 0x0E, 0xC0, 0xE0,
  0x14, 0x04, 0xFF, 0xD0, 0x53, 0x0A, 0xE0, 0xA3, 0x05, 0xFF, 0xE0, 0x83, 0x0D, 0xE0, 0xD3, 0x08,
  0xFF, 0xE0, 0x83, 0x0D, 0xE0, 0xD3, 0x08, 0xFF, 0xE0, 0x53, 0x0A, 0xE0, 0xA3, 0x05, 0xFF, 0xD0,
  0x44, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x03, 0x0E, 0xFF, 0xA0, 0xB6, 0x84, 0x1A, 0xDD, 0xA1, 0x60,
  0xAF, 0xFA, 0x0E, 0x01, 0x77, 0x20, 0x10, 0xEF, 0xFB, 0x0A, 0x30, 0x17, 0x10, 0x13, 0x09, 0xFF,
  0xD8, 0x39, 0xAE, 0xE6, 0x68, 0x36, 0xEE, 0xA9, 0xFF, 0xFC, 0x08, 0x40, 0x7F, 0xFF, 0xFA, 0x0B,
  0x40, 0xAF, 0xFF, 0xFA, 0x0E, 0x02, 0x20, 0x20, 0xE8, 0x0A, 0xB3, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D,
  0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_applications() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_settings_applications_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_backup_restore 48x48, 4-bit Alpha,  RLE, 286 bytes.
static const unsigned char ic_round_48_action_settings_backup_restore_data[] PROGMEM = {
  0x75, 0x89, 0x11, 0x69, 0xCD, 0xFE, 0xDB, 0x95, 0x77, 0x72, 0x05, 0x0B, 0xFD, 0x0B, 0x03, 0x77,
  0x40, 0x40, 0xCF, 0xFA, 0x0B, 0x03, 0x71, 0x00, 0x55, 0x08, 0xFF, 0xE0, 0x67, 0xA0, 0x72, 0x01,
  0x0B, 0xE8, 0x2D, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE0, 0xA6, 0xB8, 0x17, 0x1C, 0xD0, 0xA0, 0x37,
  0x30, 0x20, 0xAD, 0x0B, 0x5C, 0x0D, 0xC0, 0xD0, 0x47, 0x70, 0x40, 0xDC, 0x09, 0x4F, 0x90, 0xC0,
  0x17, 0x72, 0x01, 0x0C, 0xC0, 0x73, 0xF0, 0xC0, 0x17, 0x75, 0x0B, 0xC0, 0x22, 0xF0, 0x87, 0x77,
  0x0D, 0xB0, 0xB2, 0xF9, 0x07, 0x77, 0x60, 0x4C, 0x04, 0x1F, 0xA0, 0x77, 0x76, 0x09, 0xB0, 0xA1,
  0xFB, 0x05, 0x77, 0x50, 0x3C, 0x10, 0xBF, 0xA0, 0x57, 0x76, 0x0C, 0xB0, 0x57, 0x71, 0x84, 0x1A,
  0xDD, 0xA1, 0x73, 0x07, 0xB0, 0x97, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x72, 0x04, 0xB0, 0xB7, 0x70,
  0xAE, 0x0A, 0x72, 0x02, 0xB0, 0xD7, 0x70, 0xDE, 0x0D, 0x73, 0xC7, 0x70, 0xDE, 0x0D, 0x72, 0x01,
  0xB0, 0xE7, 0x70, 0xAE, 0x0A, 0x72, 0x02, 0xB8, 0x3D, 0x09, 0xEA, 0x73, 0x01, 0x0E, 0xC0, 0xE0,
  0x17, 0x20, 0x3B, 0x0B, 0x05, 0xB0, 0x77, 0x38, 0x41, 0xAD, 0xDA, 0x17, 0x30, 0x7B, 0x09, 0x05,
  0xB0, 0xD7, 0x77, 0x50, 0xBB, 0x05, 0x01, 0xC0, 0x37, 0x77, 0x30, 0x2C, 0x81, 0x10, 0xBB, 0x0A,
  0x77, 0x73, 0x09, 0xB0, 0xB2, 0x04, 0xC0, 0x47, 0x77, 0x10, 0x3C, 0x04, 0x30, 0xCB, 0x0D, 0x01,
  0x77, 0x70, 0xCB, 0x0C, 0x40, 0x3C, 0x0C, 0x77, 0x60, 0xBC, 0x03, 0x50, 0x8C, 0x0B, 0x01, 0x77,
  0x30, 0xBC, 0x08, 0x70, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x10, 0x10, 0xCD, 0x0A,
  0x02, 0x73, 0x02, 0x09, 0xD0, 0xC0, 0x17, 0x30, 0xBE, 0x89, 0x0C, 0x74, 0x20, 0x12, 0x47, 0xBE,
  0x0B, 0x76, 0x08, 0xFF, 0xE0, 0x87, 0x71, 0x03, 0x0C, 0xFF, 0xA0, 0xB0, 0x37, 0x74, 0x04, 0x0B,
  0xFD, 0x0B, 0x05, 0x77, 0x71, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_backup_restore() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_settings_backup_restore_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_bluetooth 48x48, 4-bit Alpha,  RLE, 245 bytes.
static const unsigned char ic_round_48_action_settings_bluetooth_data[] PROGMEM = {
  0x75, 0x81, 0x8E, 0x77, 0x77, 0x1B, 0x07, 0x77, 0x7C, 0x07, 0x77, 0x6D, 0x07, 0x77, 0x5E, 0x07,
  0x77, 0x4F, 0x07, 0x70, 0x17, 0x2F, 0x90, 0x75, 0x82, 0x9F, 0xE4, 0x7C, 0x0E, 0xC0, 0x73, 0x01,
  0xC0, 0x56, 0xC0, 0x30, 0xEC, 0x07, 0x30, 0xEC, 0x05, 0x5C, 0x10, 0x30, 0xEC, 0x07, 0x20, 0x5D,
  0x05, 0x4C, 0x20, 0x30, 0xEC, 0x04, 0x20, 0x5D, 0x05, 0x3C, 0x30, 0x7C, 0x08, 0x30, 0x5D, 0x05,
  0x2C, 0x20, 0x5D, 0x03, 0x40, 0x5D, 0x05, 0x1C, 0x10, 0x5D, 0x05, 0x60, 0x5D, 0x05, 0xC0, 0x5D,
  0x05, 0x71, 0x05, 0xFF, 0x05, 0x73, 0x05, 0xFD, 0x05, 0x75, 0x05, 0xFB, 0x05, 0x77, 0x05, 0xF9,
  0x05, 0x77, 0x20, 0x5E, 0x05, 0x77, 0x30, 0x5E, 0x05, 0x77, 0x20, 0x5F, 0x90, 0x57, 0x70, 0x5F,
  0xB0, 0x57, 0x50, 0x5F, 0xD0, 0x57, 0x30, 0x5F, 0xF0, 0x57, 0x10, 0x5D, 0x05, 0xC0, 0x5D, 0x05,
  0x60, 0x5D, 0x05, 0x1C, 0x10, 0x5D, 0x05, 0x40, 0x5D, 0x05, 0x2C, 0x20, 0x5D, 0x03, 0x20, 0x5D,
  0x05, 0x3C, 0x30, 0x7C, 0x81, 0x80, 0x5D, 0x05, 0x4C, 0x20, 0x30, 0xEC, 0x81, 0x40, 0xEC, 0x05,
  0x5C, 0x10, 0x30, 0xEC, 0x81, 0x70, 0x1C, 0x05, 0x6C, 0x03, 0x0E, 0xC0, 0x73, 0x82, 0x9F, 0xE5,
  0x7C, 0x0E, 0xC0, 0x75, 0x01, 0x72, 0xF9, 0x07, 0x77, 0x2F, 0x07, 0x77, 0x3E, 0x07, 0x77, 0x4D,
  0x07, 0x77, 0x5C, 0x07, 0x77, 0x6B, 0x07, 0x77, 0x78, 0x18, 0xE7, 0x80, 0x9D, 0x60, 0x82, 0x4D,
  0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x50, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA,
  0x0D, 0x50, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x58, 0x24, 0xDD, 0x44, 0x82, 0x4D,
  0xD4, 0x48, 0x24, 0xDD, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_bluetooth() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 0, 34, 47), Box(0, 0, 47, 47),
      ic_round_48_action_settings_bluetooth_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_brightness 48x48, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_round_48_action_settings_brightness_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0E, 0x7F, 0x00, 0x98, 0x0C, 0x1F, 0x07, 0x20, 0x7F,
  0xFF, 0xFF, 0x07, 0x40, 0x7F, 0xFF, 0xF9, 0x03, 0x77, 0x03, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7,
  0x18, 0x1E, 0xC6, 0x5F, 0xFF, 0xB7, 0x1B, 0x0C, 0x01, 0x3F, 0xFF, 0xB7, 0x1C, 0x0C, 0x3F, 0xFF,
  0xA0, 0x77, 0x1D, 0x06, 0x20, 0x7F, 0xFF, 0x07, 0x72, 0xD0, 0xC3, 0x07, 0xFF, 0xD0, 0x97, 0x3D,
  0x0E, 0x40, 0x9F, 0xFC, 0x09, 0x73, 0xD0, 0xE4, 0x09, 0xFF, 0xD0, 0x77, 0x2D, 0x0C, 0x30, 0x7F,
  0xFF, 0x07, 0x71, 0xD0, 0x62, 0x07, 0xFF, 0xFA, 0x71, 0xC0, 0xC3, 0xFF, 0xFB, 0x71, 0xB0, 0xC0,
  0x13, 0xFF, 0xFB, 0x71, 0x81, 0xEC, 0x65, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB0, 0x37, 0x70, 0x3F,
  0xFF, 0xF9, 0x07, 0x40, 0x7F, 0xFF, 0xFF, 0x07, 0x20, 0x78, 0x0C, 0x1F, 0x00, 0x98, 0x0E, 0x7F,
  0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_brightness() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_settings_brightness_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_cell 48x48, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_round_48_action_settings_cell_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xA8, 0x4D, 0x91, 0x01, 0xEF, 0xFE, 0x81, 0xE1, 0xAF, 0xFF, 0x90, 0xA0,
  0xDF, 0xFF, 0x90, 0xD8, 0x09, 0xC0, 0xF7, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F,
  0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97,
  0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72,
  0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9,
  0x77, 0x28, 0x09, 0xC0, 0xF0, 0xDF, 0xFF, 0x90, 0xD0, 0xAF, 0xFF, 0x98, 0x1A, 0x1E, 0xFF, 0xE8,
  0x4E, 0x10, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x18, 0x09, 0xB7, 0x08, 0x24, 0xDD, 0x44, 0x82, 0x4D,
  0xD4, 0x48, 0x24, 0xDD, 0x44, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0,
  0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D,
  0xD4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_cell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 0, 35, 47), Box(0, 0, 47, 47),
      ic_round_48_action_settings_cell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_ethernet 48x48, 4-bit Alpha,  RLE, 246 bytes.
static const unsigned char ic_round_48_action_settings_ethernet_data[] PROGMEM = {
  0x74, 0x00, 0x17, 0x74, 0x00, 0x17, 0x77, 0x07, 0xA0, 0x67, 0x72, 0x06, 0xA0, 0x77, 0x75, 0x07,
  0xB0, 0xE7, 0x72, 0x0E, 0xB0, 0x77, 0x73, 0x07, 0xC0, 0xC7, 0x72, 0x0C, 0xC0, 0x77, 0x71, 0x07,
  0xC0, 0xE0, 0x37, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC,
  0x07, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77,
  0x71, 0x03, 0x0E, 0xC0, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x50, 0x7C,
  0x0E, 0x03, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x34, 0x82, 0x4D, 0xD4, 0x48,
  0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x40, 0x30, 0xEC, 0x81, 0x70, 0x1C, 0x0E, 0x03, 0x50, 0xDA,
  0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x50, 0x30, 0xEC, 0x00, 0x1C, 0x0E, 0x03, 0x50, 0xDA,
  0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x50, 0x30, 0xEC, 0x81, 0x10, 0x7C, 0x0E, 0x03, 0x48,
  0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x50, 0x7C, 0x0E, 0x03, 0x77, 0x73, 0x03, 0x0E, 0xC0,
  0x77, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x76,
  0x03, 0x0E, 0xC0, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x76, 0x07, 0xC0,
  0xE0, 0x37, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0x07, 0xC0, 0xC7, 0x72, 0x0C, 0xC0, 0x77, 0x73,
  0x07, 0xB0, 0xE7, 0x72, 0x0E, 0xB0, 0x77, 0x75, 0x07, 0xA0, 0x67, 0x72, 0x06, 0xA0, 0x77, 0x77,
  0x00, 0x17, 0x74, 0x00, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_ethernet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 12, 45, 35), Box(0, 0, 47, 47),
      ic_round_48_action_settings_ethernet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_input_antenna 48x48, 4-bit Alpha,  RLE, 381 bytes.
static const unsigned char ic_round_48_action_settings_input_antenna_data[] PROGMEM = {
  0x77, 0x28, 0x34, 0x8A, 0xDE, 0xA8, 0x3E, 0xDA, 0x84, 0x77, 0x77, 0x18, 0x14, 0xAE, 0xFD, 0x81,
  0xEA, 0x47, 0x77, 0x30, 0x40, 0xCF, 0xFC, 0x0C, 0x04, 0x77, 0x60, 0x10, 0xBF, 0xFF, 0x90, 0xB0,
  0x17, 0x73, 0x05, 0x0E, 0xE8, 0x3E, 0x95, 0x31, 0x28, 0x31, 0x35, 0x9E, 0xE0, 0xE0, 0x57, 0x71,
  0x08, 0xE0, 0xA0, 0x37, 0x50, 0x30, 0xAE, 0x08, 0x76, 0x08, 0xD0, 0xB0, 0x37, 0x72, 0x03, 0x0B,
  0xD0, 0x87, 0x40, 0x8D, 0x07, 0x77, 0x60, 0x7D, 0x08, 0x72, 0x05, 0xC0, 0xE0, 0x36, 0x89, 0x03,
  0x7B, 0xDE, 0xED, 0xB7, 0x36, 0x03, 0x0E, 0xC0, 0x57, 0x02, 0x0E, 0xB0, 0xE0, 0x35, 0x05, 0x0C,
  0xFB, 0x0C, 0x05, 0x50, 0x30, 0xEB, 0x0E, 0x02, 0x60, 0xBC, 0x03, 0x40, 0x10, 0xBF, 0xF0, 0xB0,
  0x14, 0x03, 0xC0, 0xB5, 0x04, 0xC0, 0x64, 0x04, 0x0E, 0xFF, 0xA0, 0xE0, 0x44, 0x06, 0xC0, 0x44,
  0x0C, 0xB0, 0xC4, 0x03, 0x0E, 0xD8, 0x1A, 0x52, 0x28, 0x12, 0x5A, 0xD0, 0xE0, 0x34, 0x0C, 0xB0,
  0xC3, 0x04, 0xC0, 0x23, 0x02, 0x0E, 0xC0, 0xA0, 0x17, 0x10, 0x10, 0xAC, 0x0E, 0x02, 0x30, 0x2C,
  0x04, 0x20, 0xAB, 0x0A, 0x40, 0xBC, 0x06, 0x75, 0x06, 0xC0, 0xB4, 0x0A, 0xB0, 0xA2, 0x0E, 0xB0,
  0x43, 0x05, 0xC0, 0x67, 0x70, 0x6C, 0x05, 0x30, 0x4B, 0x81, 0xE0, 0x4B, 0x0D, 0x40, 0xCB, 0x0A,
  0x77, 0x20, 0xAB, 0x0C, 0x40, 0xDB, 0x04, 0x08, 0xB0, 0x93, 0x03, 0xC0, 0x15, 0x84, 0x4B, 0xEE,
  0xB4, 0x50, 0x1C, 0x03, 0x30, 0x9B, 0x08, 0x0A, 0xB0, 0x63, 0x07, 0xB0, 0xA5, 0x08, 0xE0, 0x85,
  0x0A, 0xB0, 0x73, 0x06, 0xB0, 0xA0, 0xDB, 0x03, 0x30, 0xBB, 0x05, 0x40, 0x4F, 0x90, 0x54, 0x05,
  0xB0, 0xB3, 0x03, 0xB0, 0xD0, 0xCA, 0x0E, 0x40, 0xBB, 0x01, 0x40, 0xBF, 0x90, 0xB4, 0x01, 0xB0,
  0xB4, 0x0E, 0xA8, 0x3C, 0x3D, 0xE5, 0x48, 0x22, 0xCE, 0x65, 0x0E, 0xF9, 0x0D, 0x58, 0x26, 0xEC,
  0x24, 0x82, 0x5E, 0xD3, 0x77, 0x30, 0xEF, 0x90, 0xE7, 0x77, 0x76, 0x0B, 0xF9, 0x0A, 0x77, 0x77,
  0x60, 0x4F, 0x90, 0x47, 0x77, 0x77, 0x07, 0xE0, 0x78, 0x0C, 0x10, 0x04, 0xC0, 0x38, 0x0C, 0x30,
  0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8,
  0x0C, 0x30, 0x05, 0xC0, 0x58, 0x0C, 0x10, 0x05, 0xE0, 0x57, 0x77, 0x77, 0x05, 0xF9, 0x05, 0x77,
  0x77, 0x50, 0x5F, 0xB0, 0x57, 0x77, 0x73, 0x05, 0xD0, 0x04, 0xD0, 0x57, 0x77, 0x71, 0x05, 0xD0,
  0x42, 0x04, 0xD0, 0x57, 0x77, 0x70, 0xDC, 0x04, 0x40, 0x4C, 0x0D, 0x77, 0x77, 0x0D, 0xB0, 0x46,
  0x04, 0xB0, 0xD7, 0x77, 0x78, 0x24, 0xDD, 0x47, 0x18, 0x24, 0xDD, 0x47, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_input_antenna() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 43), Box(0, 0, 47, 47),
      ic_round_48_action_settings_input_antenna_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_input_component 48x48, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_round_48_action_settings_input_component_data[] PROGMEM = {
  0x48, 0x24, 0xDD, 0x47, 0x58, 0x24, 0xDD, 0x47, 0x58, 0x24, 0xDD, 0x47, 0x10, 0xDA, 0x0D, 0x75,
  0x0D, 0xA0, 0xD7, 0x50, 0xDA, 0x0D, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x71,
  0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7,
  0x5C, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x44,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0x98, 0x1D, 0x4D, 0xFB, 0x0D, 0x40, 0xDF, 0xB0,
  0xD4, 0x0D, 0xFB, 0x0D, 0xFD, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF,
  0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF,
  0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFD, 0x80, 0xAD, 0x40, 0xFD,
  0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFD, 0x0E,
  0xFB, 0x0E, 0x40, 0xEF, 0xB0, 0xE4, 0x0E, 0xFB, 0x0E, 0x0B, 0xFB, 0x0B, 0x40, 0xBF, 0xB0, 0xB4,
  0x0B, 0xFB, 0x0B, 0x05, 0xFB, 0x05, 0x40, 0x5F, 0xB0, 0x54, 0x05, 0xFB, 0x81, 0x50, 0xCF, 0x90,
  0xC6, 0x0C, 0xF9, 0x0C, 0x60, 0xCF, 0x90, 0xC2, 0x01, 0x0C, 0xE0, 0xC0, 0x16, 0x01, 0x0C, 0xE0,
  0xC0, 0x16, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x05, 0xC0, 0x57, 0x30, 0x5C, 0x05, 0x73, 0x05, 0xC0,
  0x57, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75,
  0xC7, 0x5C, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x71, 0x0D, 0xA0, 0xD7, 0x50,
  0xDA, 0x0D, 0x75, 0x0D, 0xA0, 0xD7, 0x18, 0x24, 0xDD, 0x47, 0x58, 0x24, 0xDD, 0x47, 0x58, 0x24,
  0xDD, 0x44,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_input_component() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_settings_input_component_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_input_composite 48x48, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_round_48_action_settings_input_composite_data[] PROGMEM = {
  0x48, 0x24, 0xDD, 0x47, 0x58, 0x24, 0xDD, 0x47, 0x58, 0x24, 0xDD, 0x47, 0x10, 0xDA, 0x0D, 0x75,
  0x0D, 0xA0, 0xD7, 0x50, 0xDA, 0x0D, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x71,
  0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7,
  0x5C, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x44,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0x98, 0x1D, 0x4D, 0xFB, 0x0D, 0x40, 0xDF, 0xB0,
  0xD4, 0x0D, 0xFB, 0x0D, 0xFD, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF,
  0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF,
  0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFD, 0x80, 0xAD, 0x40, 0xFD,
  0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFD, 0x0E,
  0xFB, 0x0E, 0x40, 0xEF, 0xB0, 0xE4, 0x0E, 0xFB, 0x0E, 0x0B, 0xFB, 0x0B, 0x40, 0xBF, 0xB0, 0xB4,
  0x0B, 0xFB, 0x0B, 0x05, 0xFB, 0x05, 0x40, 0x5F, 0xB0, 0x54, 0x05, 0xFB, 0x81, 0x50, 0xCF, 0x90,
  0xC6, 0x0C, 0xF9, 0x0C, 0x60, 0xCF, 0x90, 0xC2, 0x01, 0x0C, 0xE0, 0xC0, 0x16, 0x01, 0x0C, 0xE0,
  0xC0, 0x16, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x05, 0xC0, 0x57, 0x30, 0x5C, 0x05, 0x73, 0x05, 0xC0,
  0x57, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75,
  0xC7, 0x5C, 0x71, 0xC7, 0x5C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x5C, 0x71, 0x0D, 0xA0, 0xD7, 0x50,
  0xDA, 0x0D, 0x75, 0x0D, 0xA0, 0xD7, 0x18, 0x24, 0xDD, 0x47, 0x58, 0x24, 0xDD, 0x47, 0x58, 0x24,
  0xDD, 0x44,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_input_composite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_settings_input_composite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_input_hdmi 48x48, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_48_action_settings_input_hdmi_data[] PROGMEM = {
  0x38, 0x11, 0xAD, 0xFF, 0xA8, 0x1D, 0xA1, 0x50, 0x10, 0xEF, 0xFE, 0x0E, 0x01, 0x40, 0xAF, 0xFF,
  0x90, 0xA4, 0x0D, 0xFF, 0xF9, 0x0D, 0x4C, 0x77, 0x2C, 0x4C, 0x77, 0x2C, 0x4C, 0x40, 0x0B, 0x40,
  0x0B, 0x4C, 0x4C, 0x4A, 0x4A, 0x4C, 0x4C, 0x4A, 0x4A, 0x4C, 0x4C, 0x4A, 0x4A, 0x4C, 0x20, 0x40,
  0xDF, 0xFF, 0xB8, 0x1D, 0x4D, 0xFF, 0xFD, 0x0D, 0x80, 0xCA, 0x4F, 0x0A, 0xFF, 0xFD, 0x0A, 0x02,
  0xFF, 0xFD, 0x81, 0x20, 0xAF, 0xFF, 0xB0, 0xA2, 0x02, 0xFF, 0xFB, 0x02, 0x30, 0xAF, 0xFF, 0x90,
  0xA4, 0x03, 0xFF, 0xF9, 0x03, 0x50, 0xAF, 0xFE, 0x0A, 0x60, 0x3F, 0xFE, 0x03, 0x70, 0xBF, 0xFC,
  0x0B, 0x71, 0x03, 0xFF, 0xC0, 0x37, 0x20, 0xBF, 0xFA, 0x0B, 0x73, 0x03, 0xFF, 0xA0, 0x37, 0x4F,
  0xFA, 0x75, 0xFF, 0xA7, 0x5F, 0xFA, 0x75, 0xFF, 0xA7, 0x50, 0xDF, 0xF0, 0xD7, 0x50, 0x40, 0xDF,
  0xD0, 0xD0, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_input_hdmi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 43), Box(0, 0, 47, 47),
      ic_round_48_action_settings_input_hdmi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_input_svideo 48x48, 4-bit Alpha,  RLE, 391 bytes.
static const unsigned char ic_round_48_action_settings_input_svideo_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0D, 0x06, 0x75, 0x06,
  0x0D, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x37, 0x74,
  0x03, 0x0D, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x15, 0x08, 0x0D, 0xE0, 0xD0, 0x85, 0x01, 0x0C, 0xC0,
  0x55, 0x01, 0x0E, 0xB0, 0xD0, 0x15, 0x08, 0xFB, 0x08, 0x50, 0x10, 0xDB, 0x0E, 0x01, 0x40, 0x9C,
  0x03, 0x60, 0xDF, 0xB0, 0xD6, 0x03, 0xC0, 0x93, 0x01, 0xC0, 0x77, 0x0D, 0xFB, 0x0D, 0x70, 0x7C,
  0x01, 0x20, 0x8B, 0x0D, 0x71, 0x08, 0xFB, 0x08, 0x71, 0x0D, 0xB0, 0x82, 0x0D, 0xB0, 0x67, 0x20,
  0x80, 0xDE, 0x0D, 0x08, 0x72, 0x06, 0xB8, 0x1D, 0x03, 0xC7, 0x77, 0x72, 0xC0, 0x30, 0x7B, 0x0B,
  0x77, 0x77, 0x20, 0xBB, 0x07, 0x0A, 0xB0, 0x64, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x40,
  0x6B, 0x0A, 0x0C, 0xB0, 0x33, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x30, 0x3B, 0x0C, 0x0E, 0xB0,
  0x23, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x30, 0x2B, 0x0E, 0xC4, 0x0D, 0xC0, 0xD7, 0x50, 0xDC,
  0x0D, 0x4F, 0x94, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x4C, 0x0E, 0xB0, 0x24, 0x82, 0x8D, 0xD8,
  0x77, 0x82, 0x8D, 0xD8, 0x40, 0x2B, 0x0E, 0x0C, 0xB0, 0x37, 0x77, 0x72, 0x03, 0xB0, 0xC0, 0xAB,
  0x06, 0x77, 0x77, 0x20, 0x6B, 0x0A, 0x07, 0xB0, 0xB7, 0x77, 0x72, 0x0B, 0xB0, 0x70, 0x3C, 0x78,
  0x28, 0xDD, 0x87, 0x18, 0x28, 0xDD, 0x87, 0xC8, 0x13, 0x0D, 0xB0, 0x65, 0x08, 0xC0, 0x86, 0x08,
  0xC0, 0x85, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xD5, 0x0D, 0xC0, 0xD6, 0x0D, 0xC0, 0xD5, 0x0D, 0xB0,
  0x82, 0x01, 0xC0, 0x74, 0x0D, 0xC0, 0xD6, 0x0D, 0xC0, 0xD4, 0x07, 0xC0, 0x13, 0x09, 0xC0, 0x33,
  0x08, 0xC0, 0x86, 0x08, 0xC0, 0x83, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xD0, 0x13, 0x82, 0x8D,
  0xD8, 0x71, 0x82, 0x8D, 0xD8, 0x30, 0x10, 0xDB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60,
  0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0D, 0x03, 0x77, 0x40, 0x30, 0xDC, 0x09, 0x72, 0x0A, 0xD0, 0x77,
  0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0D, 0x06, 0x75, 0x06, 0x0D, 0xD0, 0xA7, 0x60, 0x9F, 0x82,
  0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30,
  0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33,
  0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_input_svideo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_settings_input_svideo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_overscan 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_round_48_action_settings_overscan_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x10,
  0x70, 0x87, 0x71, 0xF9, 0x77, 0x07, 0xA0, 0x77, 0x7F, 0x97, 0x60, 0x7C, 0x07, 0x76, 0xF9, 0x75,
  0x07, 0xE0, 0x77, 0x5F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x95, 0x07, 0x77, 0x60, 0x75,
  0xF9, 0x40, 0x79, 0x77, 0x69, 0x07, 0x4F, 0x93, 0x07, 0xA7, 0x76, 0xA0, 0x73, 0xF9, 0x20, 0x7B,
  0x77, 0x6B, 0x07, 0x2F, 0x92, 0x08, 0xB7, 0x76, 0xB0, 0x82, 0xF9, 0x30, 0x7A, 0x77, 0x6A, 0x07,
  0x3F, 0x94, 0x07, 0x97, 0x76, 0x90, 0x74, 0xF9, 0x50, 0x77, 0x76, 0x07, 0x5F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x50, 0x7E, 0x07, 0x75, 0xF9, 0x76, 0x07, 0xC0, 0x77, 0x6F, 0x97,
  0x70, 0x7A, 0x07, 0x77, 0xF9, 0x77, 0x10, 0x70, 0x87, 0x71, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77,
  0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E,
  0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_overscan() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_settings_overscan_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_phone 48x48, 4-bit Alpha,  RLE, 233 bytes.
static const unsigned char ic_round_48_action_settings_phone_data[] PROGMEM = {
  0x04, 0x0D, 0xF9, 0x0E, 0x08, 0x77, 0x73, 0x0D, 0xFC, 0x03, 0x77, 0x72, 0x0E, 0xFC, 0x06, 0x77,
  0x72, 0x0C, 0xFC, 0x0A, 0x77, 0x72, 0x0A, 0xFC, 0x0D, 0x77, 0x72, 0x09, 0xFD, 0x77, 0x72, 0x06,
  0xFD, 0x04, 0x77, 0x71, 0x03, 0xFD, 0x07, 0x77, 0x72, 0x0E, 0xFC, 0x0A, 0x77, 0x72, 0x0A, 0xFC,
  0x0B, 0x77, 0x72, 0x06, 0xFC, 0x05, 0x77, 0x72, 0x01, 0xFB, 0x07, 0x77, 0x74, 0x0A, 0xF9, 0x07,
  0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x42, 0x05, 0xF0, 0x75, 0x0D, 0xA0,
  0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD3, 0x0D, 0xD0, 0x76, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4,
  0x0D, 0xA0, 0xD3, 0x06, 0xC0, 0x87, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4,
  0x40, 0xDB, 0x0A, 0x77, 0x77, 0x30, 0x6C, 0x05, 0x77, 0x77, 0x30, 0xCB, 0x0E, 0x01, 0x77, 0x77,
  0x20, 0x2C, 0x0A, 0x77, 0x77, 0x30, 0x7C, 0x08, 0x77, 0x77, 0x30, 0xCC, 0x07, 0x77, 0x77, 0x20,
  0x10, 0xDC, 0x05, 0x74, 0x83, 0x5B, 0x96, 0x37, 0x70, 0x20, 0xEC, 0x07, 0x72, 0x06, 0xE8, 0x2C,
  0x96, 0x37, 0x30, 0x4D, 0x08, 0x70, 0x7F, 0xC0, 0x87, 0x30, 0x5D, 0x0A, 0x01, 0x40, 0x7F, 0xD0,
  0xE7, 0x40, 0x40, 0xEC, 0x0E, 0x05, 0x20, 0x7F, 0xF7, 0x50, 0x20, 0xDD, 0x0A, 0x08, 0xFF, 0x97,
  0x60, 0x10, 0xCF, 0xFF, 0x77, 0x10, 0x7F, 0xFE, 0x77, 0x20, 0x20, 0xCF, 0xFC, 0x77, 0x40, 0x60,
  0xDF, 0xFA, 0x77, 0x60, 0x60, 0xDF, 0xF7, 0x77, 0x10, 0x40, 0xAF, 0xD7, 0x77, 0x38, 0x21, 0x6A,
  0xEF, 0x0D, 0x77, 0x77, 0x86, 0x26, 0x9A, 0xCE, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_settings_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings 48x48, 4-bit Alpha,  RLE, 283 bytes.
static const unsigned char ic_round_48_action_settings_data[] PROGMEM = {
  0x77, 0x01, 0x0C, 0xF9, 0x0C, 0x01, 0x77, 0x77, 0x09, 0xFB, 0x09, 0x77, 0x77, 0x0C, 0xFB, 0x0C,
  0x77, 0x77, 0x0E, 0xFB, 0x0E, 0x77, 0x76, 0x01, 0xFD, 0x01, 0x77, 0x40, 0x10, 0x36, 0x02, 0xFD,
  0x02, 0x60, 0x30, 0x17, 0x28, 0x43, 0xEF, 0xD7, 0x13, 0x09, 0xFD, 0x09, 0x38, 0x41, 0x7D, 0xFE,
  0x37, 0x10, 0xDD, 0x81, 0x96, 0xDF, 0xF8, 0x1D, 0x69, 0xD0, 0xD7, 0x06, 0xFF, 0xFF, 0xC0, 0x65,
  0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14, 0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x02, 0x80, 0xC0, 0xF0,
  0x32, 0x0B, 0x80, 0xC0, 0xF8, 0x1B, 0x04, 0xFF, 0x98, 0x1E, 0x83, 0x28, 0x12, 0x7D, 0xFF, 0x90,
  0x40, 0x5F, 0xF0, 0xB0, 0x17, 0x09, 0xFF, 0x81, 0x51, 0xDF, 0xD0, 0xB7, 0x30, 0x9F, 0xD8, 0x3D,
  0x10, 0x1B, 0xFB, 0x0E, 0x01, 0x74, 0x0D, 0xFB, 0x0A, 0x01, 0x40, 0x7F, 0xA0, 0x87, 0x50, 0x6F,
  0xA0, 0x77, 0x03, 0xF9, 0x04, 0x75, 0x01, 0xF9, 0x03, 0x72, 0xF9, 0x02, 0x76, 0xF9, 0x73, 0xF9,
  0x02, 0x76, 0xF9, 0x72, 0x03, 0xF9, 0x04, 0x75, 0x01, 0xF9, 0x03, 0x70, 0x7F, 0xA0, 0x87, 0x50,
  0x6F, 0xA0, 0x64, 0x01, 0x0A, 0xFB, 0x0E, 0x01, 0x74, 0x0D, 0xFB, 0x0A, 0x20, 0x10, 0xDF, 0xD0,
  0xB7, 0x30, 0x9F, 0xD8, 0x1D, 0x05, 0xFF, 0x0B, 0x01, 0x70, 0x9F, 0xF0, 0x50, 0x4F, 0xF9, 0x81,
  0xE8, 0x32, 0x81, 0x27, 0xDF, 0xF9, 0x81, 0x30, 0xB8, 0x0C, 0x0F, 0x0B, 0x20, 0x38, 0x0C, 0x0F,
  0x02, 0x30, 0x9F, 0xFF, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50, 0x6F, 0xFF,
  0xFC, 0x06, 0x70, 0xDD, 0x81, 0x96, 0xDF, 0xF8, 0x1D, 0x69, 0xD0, 0xC7, 0x18, 0x43, 0xEF, 0xD7,
  0x13, 0x09, 0xFD, 0x08, 0x38, 0x41, 0x7D, 0xFE, 0x37, 0x20, 0x10, 0x36, 0x02, 0xFD, 0x02, 0x60,
  0x37, 0x75, 0x01, 0xFD, 0x77, 0x77, 0x0E, 0xFB, 0x0E, 0x77, 0x77, 0x0C, 0xFB, 0x0C, 0x77, 0x77,
  0x09, 0xFB, 0x09, 0x77, 0x77, 0x01, 0x0C, 0xF9, 0x0C, 0x01, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_power 48x48, 4-bit Alpha,  RLE, 281 bytes.
static const unsigned char ic_round_48_action_settings_power_data[] PROGMEM = {
  0x77, 0x82, 0x4D, 0xD4, 0x77, 0x77, 0x0D, 0xA0, 0xD7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C,
  0x77, 0x58, 0x11, 0x63, 0x6C, 0x68, 0x13, 0x61, 0x72, 0x02, 0x0D, 0xA0, 0x55, 0xC5, 0x05, 0xA0,
  0xD0, 0x17, 0x01, 0x0E, 0xB0, 0xA5, 0xC5, 0x0A, 0xB0, 0xD0, 0x16, 0x0C, 0xC0, 0x65, 0xC5, 0x06,
  0xC0, 0xC5, 0x08, 0xC0, 0x96, 0xC6, 0x09, 0xC0, 0x63, 0x02, 0xC0, 0xA7, 0xC7, 0x0A, 0xB0, 0xE0,
  0x12, 0x09, 0xB0, 0xE0, 0x17, 0xC7, 0x10, 0xDB, 0x09, 0x20, 0xEB, 0x06, 0x71, 0xC7, 0x10, 0x5B,
  0x81, 0xE0, 0x5B, 0x0E, 0x72, 0xC7, 0x20, 0xDB, 0x04, 0x09, 0xB0, 0x97, 0x2C, 0x72, 0x08, 0xB0,
  0x90, 0xCB, 0x04, 0x72, 0xC7, 0x20, 0x4B, 0x0B, 0x0E, 0xB0, 0x27, 0x2C, 0x72, 0x01, 0xB0, 0xCC,
  0x73, 0xC7, 0x3B, 0x0E, 0xC7, 0x30, 0xDA, 0x0D, 0x73, 0xC0, 0xEB, 0x02, 0x72, 0x82, 0x4D, 0xD4,
  0x72, 0x01, 0xB0, 0xE0, 0xCB, 0x04, 0x77, 0x71, 0x04, 0xB0, 0xC0, 0x9B, 0x09, 0x77, 0x71, 0x08,
  0xB0, 0x90, 0x5B, 0x0E, 0x77, 0x71, 0x0D, 0xB8, 0x15, 0x1E, 0xB0, 0x57, 0x76, 0x05, 0xB0, 0xE2,
  0x09, 0xB0, 0xE0, 0x17, 0x75, 0x0D, 0xB0, 0x92, 0x02, 0xC0, 0xA7, 0x74, 0x09, 0xC0, 0x23, 0x08,
  0xC0, 0x97, 0x72, 0x08, 0xC0, 0x85, 0x0D, 0xC0, 0xA0, 0x17, 0x60, 0x9C, 0x0C, 0x60, 0x20, 0xEC,
  0x0E, 0x05, 0x73, 0x05, 0x0D, 0xC0, 0xE0, 0x27, 0x03, 0x0E, 0xD8, 0x90, 0xE8, 0x42, 0x01, 0x24,
  0x8D, 0xD0, 0xE0, 0x27, 0x20, 0x20, 0xDF, 0xFC, 0x0C, 0x02, 0x75, 0x08, 0xFF, 0xA0, 0x87, 0x71,
  0x02, 0x09, 0xFD, 0x09, 0x02, 0x77, 0x48, 0x31, 0x59, 0xCE, 0xA8, 0x2E, 0xC9, 0x58, 0x0B, 0x95,
  0x08, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x47, 0x50, 0xDA, 0x0D, 0x40, 0xDA,
  0x0D, 0x40, 0xDA, 0x0D, 0x75, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD7, 0x58, 0x24,
  0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_power() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 47), Box(0, 0, 47, 47),
      ic_round_48_action_settings_power_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_remote 48x48, 4-bit Alpha,  RLE, 218 bytes.
static const unsigned char ic_round_48_action_settings_remote_data[] PROGMEM = {
  0x72, 0x89, 0x23, 0x7A, 0xBD, 0xEE, 0xDB, 0xA7, 0x37, 0x71, 0x81, 0x3A, 0xEF, 0xD8, 0x1E, 0xA3,
  0x73, 0x04, 0x0B, 0xFF, 0xC0, 0xB0, 0x46, 0x01, 0x0A, 0xFF, 0xF9, 0x0A, 0x01, 0x30, 0x50, 0xEE,
  0x83, 0xD9, 0x53, 0x12, 0x83, 0x13, 0x59, 0xDE, 0x82, 0xE4, 0x04, 0xE0, 0xA0, 0x37, 0x50, 0x30,
  0xAE, 0x04, 0x09, 0xC0, 0xB0, 0x27, 0x72, 0x02, 0x0B, 0xC0, 0x80, 0x4A, 0x0E, 0x06, 0x77, 0x60,
  0x7B, 0x83, 0x40, 0x37, 0x26, 0x82, 0x37, 0xBD, 0xA8, 0x2D, 0xB7, 0x36, 0x81, 0x27, 0x47, 0x20,
  0x50, 0xCF, 0xB0, 0xC0, 0x57, 0x70, 0x20, 0xBF, 0xF0, 0xB0, 0x27, 0x50, 0xCF, 0xFA, 0x0B, 0x75,
  0x0D, 0xC8, 0x1A, 0x52, 0x28, 0x12, 0x5A, 0xC0, 0xD7, 0x50, 0x6A, 0x0A, 0x01, 0x71, 0x01, 0x0A,
  0xA0, 0x67, 0x60, 0x01, 0x75, 0x00, 0x18, 0x09, 0xC4, 0x00, 0x40, 0xDF, 0xD0, 0xD0, 0x47, 0x70,
  0xDF, 0xF0, 0xD7, 0x7F, 0xFA, 0x77, 0xFF, 0xA7, 0x7F, 0xFA, 0x77, 0xE8, 0x2E, 0x99, 0xEE, 0x77,
  0xD0, 0xE0, 0x22, 0x02, 0x0E, 0xD7, 0x7D, 0x09, 0x40, 0x9D, 0x77, 0xD0, 0x94, 0x09, 0xD7, 0x7D,
  0x0E, 0x02, 0x20, 0x20, 0xED, 0x77, 0xE8, 0x2E, 0x99, 0xEE, 0x77, 0xFF, 0xA7, 0x7F, 0xFA, 0x77,
  0xFF, 0xA7, 0x7F, 0xFA, 0x77, 0xFF, 0xA7, 0x7F, 0xFA, 0x77, 0xFF, 0xA7, 0x7F, 0xFA, 0x77, 0xFF,
  0xA7, 0x7F, 0xFA, 0x77, 0xFF, 0xA7, 0x7F, 0xFA, 0x77, 0xFF, 0xA7, 0x7F, 0xFA, 0x77, 0xFF, 0xA7,
  0x70, 0xDF, 0xF0, 0xD7, 0x70, 0x40, 0xDF, 0xD0, 0xD0, 0x47,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_remote() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 0, 38, 45), Box(0, 0, 47, 47),
      ic_round_48_action_settings_remote_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_settings_voice 48x48, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_round_48_action_settings_voice_data[] PROGMEM = {
  0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x60, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x40, 0xCF, 0x90, 0xC7,
  0x73, 0x06, 0xFB, 0x06, 0x77, 0x20, 0xCF, 0xB0, 0xC7, 0x72, 0x0E, 0xFB, 0x0E, 0x77, 0x2F, 0xD7,
  0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72,
  0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x71, 0x82, 0x2C, 0xE6, 0x40,
  0xEF, 0xB0, 0xE4, 0x83, 0x6E, 0xC2, 0xBB, 0x01, 0x30, 0xCF, 0xB0, 0xC3, 0x01, 0xB0, 0x0B, 0xB0,
  0x53, 0x06, 0xFB, 0x06, 0x30, 0x5B, 0x0B, 0x08, 0xB0, 0xA4, 0x0C, 0xF9, 0x0C, 0x40, 0xAB, 0x08,
  0x03, 0xC0, 0x13, 0x01, 0x0C, 0xE0, 0xC0, 0x13, 0x01, 0xC8, 0x13, 0x0C, 0xB0, 0xA5, 0x84, 0x6C,
  0xEE, 0xC6, 0x50, 0xAB, 0x0C, 0x20, 0x5C, 0x06, 0x77, 0x06, 0xC0, 0x53, 0x0B, 0xC0, 0x67, 0x50,
  0x6C, 0x0B, 0x40, 0x20, 0xEC, 0x0A, 0x01, 0x71, 0x01, 0x0A, 0xC0, 0xE0, 0x25, 0x03, 0xE8, 0x1A,
  0x52, 0x28, 0x12, 0x5A, 0xE0, 0x37, 0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x20, 0x20, 0xBF, 0xF0,
  0xB0, 0x27, 0x50, 0x50, 0xCF, 0xB0, 0xC0, 0x57, 0x72, 0x81, 0x37, 0xBC, 0x81, 0xB7, 0x37, 0x77,
  0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0x0D, 0xA0, 0xD7, 0x77, 0x38, 0x24,
  0xDD, 0x48, 0x09, 0xF4, 0x08, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x47, 0x10,
  0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x71, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D,
  0xA0, 0xD7, 0x18, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_settings_voice() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 47), Box(0, 0, 47, 47),
      ic_round_48_action_settings_voice_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_shop_2 48x48, 4-bit Alpha,  RLE, 216 bytes.
static const unsigned char ic_round_48_action_shop_2_data[] PROGMEM = {
  0x77, 0x58, 0x11, 0xAE, 0xF9, 0x81, 0xEA, 0x17, 0x77, 0x71, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77,
  0x77, 0x0A, 0xFF, 0x0A, 0x77, 0x77, 0x0D, 0xFF, 0x0D, 0x77, 0x77, 0xC7, 0x1C, 0x77, 0x77, 0xC7,
  0x1C, 0x77, 0x77, 0xC7, 0x1C, 0x77, 0x77, 0xC7, 0x1C, 0x77, 0x48, 0x0C, 0x0F, 0x71, 0x80, 0xC0,
  0xF7, 0x18, 0x0C, 0x0F, 0x71, 0x80, 0xC0, 0xF7, 0x18, 0x0C, 0x0F, 0x71, 0x80, 0xC0, 0xF7, 0x1F,
  0xF0, 0x0E, 0xFF, 0xE7, 0x1F, 0xF8, 0x12, 0x09, 0xFF, 0xD8, 0x24, 0xDD, 0x44, 0xFF, 0x30, 0x30,
  0xDF, 0xFB, 0x0D, 0xA0, 0xD4, 0xFF, 0x50, 0x7F, 0xFE, 0x4F, 0xF6, 0x02, 0x0B, 0xFF, 0xC4, 0xFF,
  0x71, 0x06, 0x0E, 0xFF, 0xA4, 0xFF, 0x72, 0x01, 0x0E, 0xFF, 0x94, 0xFF, 0x72, 0x01, 0x0E, 0xFF,
  0x94, 0xFF, 0x71, 0x06, 0x0E, 0xFF, 0xA4, 0xFF, 0x60, 0x20, 0xBF, 0xFC, 0x4F, 0xF5, 0x07, 0xFF,
  0xE4, 0xFF, 0x30, 0x30, 0xDF, 0xFF, 0x4F, 0xF8, 0x12, 0x09, 0xFF, 0xFA, 0x4F, 0xF0, 0x0E, 0xFF,
  0xFB, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x40, 0xDF, 0xFF, 0xFE, 0x0D, 0xC4, 0x0A, 0xFF, 0xFF,
  0xE0, 0xAC, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0xC5, 0x81, 0x1A, 0xEF, 0xFF, 0xF8, 0x1E,
  0xA1, 0x1C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x00, 0xDF, 0xFF,
  0xFD, 0x0D, 0x04, 0x71, 0x0A, 0xFF, 0xFF, 0xE0, 0xD7, 0x10, 0x10, 0xEF, 0xFF, 0xFD, 0x0D, 0x72,
  0x81, 0x1A, 0xDF, 0xFF, 0xFA, 0x0D, 0x04, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_shop_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 43), Box(0, 0, 47, 47),
      ic_round_48_action_shop_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_shopping_bag 48x48, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_round_48_action_shopping_bag_data[] PROGMEM = {
  0x75, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0x72, 0x09, 0xF9, 0x09, 0x77, 0x70, 0xBF, 0xB0, 0xB7,
  0x75, 0x09, 0xFD, 0x09, 0x77, 0x30, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x27, 0x72, 0x08, 0xB0,
  0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x72, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0x72, 0x0E, 0xB0,
  0x16, 0x01, 0xB0, 0xE7, 0x28, 0x11, 0xAD, 0xFF, 0xFB, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0x81,
  0xE1, 0xAF, 0xFF, 0xFA, 0x0A, 0x0D, 0xFF, 0xFF, 0xA0, 0xDF, 0x94, 0xF9, 0x4F, 0xFA, 0x4F, 0x94,
  0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA0, 0x12, 0x01, 0xF9, 0x01, 0x20, 0x1F, 0xFA,
  0x82, 0xB1, 0x1B, 0xF9, 0x82, 0xB1, 0x1B, 0x80, 0x99, 0x84, 0xF0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A,
  0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_shopping_bag() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_round_48_action_shopping_bag_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_shopping_basket 48x48, 4-bit Alpha,  RLE, 261 bytes.
static const unsigned char ic_round_48_action_shopping_basket_data[] PROGMEM = {
  0x77, 0x68, 0x24, 0xED, 0x48, 0x0C, 0x30, 0x02, 0x0E, 0xA0, 0xE0, 0x18, 0x0C, 0x20, 0x0B, 0xC0,
  0xB8, 0x0C, 0x10, 0x06, 0xE0, 0x67, 0x77, 0x77, 0x02, 0x0E, 0xE0, 0xE0, 0x17, 0x77, 0x76, 0x0B,
  0xB0, 0x0E, 0xB0, 0xB7, 0x77, 0x75, 0x06, 0xC0, 0x50, 0x6C, 0x06, 0x77, 0x77, 0x30, 0x20, 0xEB,
  0x0A, 0x20, 0xBB, 0x0E, 0x01, 0x77, 0x77, 0x20, 0xBB, 0x0E, 0x01, 0x20, 0x10, 0xEB, 0x0B, 0x77,
  0x77, 0x10, 0x7C, 0x05, 0x40, 0x6C, 0x06, 0x77, 0x76, 0x02, 0x0E, 0xB0, 0xA6, 0x0B, 0xB0, 0xE0,
  0x27, 0x77, 0x50, 0xCB, 0x0E, 0x01, 0x60, 0x10, 0xEB, 0x0B, 0x77, 0x74, 0x07, 0xC0, 0x57, 0x10,
  0x6C, 0x06, 0x77, 0x72, 0x02, 0xC0, 0xA7, 0x30, 0xBB, 0x0E, 0x02, 0x74, 0x04, 0x0D, 0x80, 0xC4,
  0xF8, 0x1D, 0x4D, 0x80, 0xC6, 0xF0, 0xD0, 0xE8, 0x0C, 0x6F, 0x0E, 0x0A, 0x80, 0xC6, 0xF0, 0xA0,
  0x58, 0x0C, 0x6F, 0x06, 0x01, 0x80, 0xC6, 0xF8, 0x12, 0x0C, 0x80, 0xC4, 0xF0, 0xD2, 0x08, 0x80,
  0xC4, 0xF0, 0x92, 0x04, 0xFF, 0xB8, 0x4D, 0x51, 0x15, 0xDF, 0xFB, 0x04, 0x3F, 0xFA, 0x0D, 0x01,
  0x40, 0x10, 0xDF, 0xFA, 0x40, 0xBF, 0xF9, 0x05, 0x60, 0x5F, 0xF9, 0x0B, 0x40, 0x7F, 0xF9, 0x01,
  0x60, 0x1F, 0xF9, 0x07, 0x40, 0x2F, 0xF9, 0x01, 0x60, 0x1F, 0xF9, 0x03, 0x50, 0xEF, 0xF0, 0x56,
  0x05, 0xFF, 0x0E, 0x60, 0x9F, 0xF0, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0x0A, 0x60, 0x5F, 0xF9, 0x84,
  0xD5, 0x11, 0x5D, 0xFF, 0x90, 0x66, 0x01, 0x80, 0xC0, 0xF0, 0x17, 0x0C, 0xFF, 0xFF, 0xE0, 0xD7,
  0x10, 0x8F, 0xFF, 0xFE, 0x08, 0x71, 0x04, 0xFF, 0xFF, 0xE0, 0x47, 0x20, 0xEF, 0xFF, 0xFD, 0x73,
  0x0A, 0xFF, 0xFF, 0xC0, 0xA7, 0x30, 0x20, 0xEF, 0xFF, 0xFA, 0x0E, 0x02, 0x74, 0x81, 0x2A, 0xEF,
  0xFF, 0xD8, 0x1E, 0xA2, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_shopping_basket() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_shopping_basket_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_shopping_cart_checkout 48x48, 4-bit Alpha,  RLE, 313 bytes.
static const unsigned char ic_round_48_action_shopping_cart_checkout_data[] PROGMEM = {
  0x04, 0x0D, 0xB0, 0xE0, 0x77, 0x70, 0x01, 0x77, 0x30, 0xDE, 0x03, 0x75, 0x06, 0xA0, 0x77, 0x72,
  0x0D, 0xE0, 0xB7, 0x50, 0xEB, 0x07, 0x77, 0x10, 0x40, 0xDE, 0x03, 0x74, 0x0C, 0xC0, 0x77, 0x74,
  0x0B, 0xB0, 0xA7, 0x40, 0x30, 0xEC, 0x07, 0x72, 0x01, 0x03, 0x60, 0x4C, 0x02, 0x74, 0x03, 0x0E,
  0xC0, 0x77, 0x82, 0x3E, 0xFC, 0x60, 0xCB, 0x09, 0x40, 0x40, 0xDF, 0xD0, 0x76, 0x0C, 0xB0, 0x35,
  0x05, 0xC0, 0x13, 0x0D, 0xFF, 0x01, 0x40, 0x5C, 0x01, 0x60, 0xDB, 0x08, 0x30, 0xDF, 0xF0, 0x14,
  0x0D, 0xB0, 0x97, 0x06, 0xB0, 0xE0, 0x12, 0x04, 0x0D, 0xFD, 0x07, 0x40, 0x6C, 0x02, 0x71, 0x0D,
  0xB0, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xDB, 0x09, 0x72, 0x06, 0xB0, 0xE7, 0x10, 0x30, 0xEC,
  0x07, 0x50, 0x7B, 0x0E, 0x01, 0x73, 0x0E, 0xB0, 0x77, 0x0C, 0xC0, 0x76, 0x0E, 0xB0, 0x87, 0x40,
  0x7B, 0x0D, 0x70, 0xEB, 0x07, 0x60, 0x8B, 0x0E, 0x01, 0x74, 0x01, 0x0E, 0xB0, 0x66, 0x06, 0xA0,
  0x76, 0x01, 0x0E, 0xB0, 0x77, 0x60, 0x8B, 0x0D, 0x70, 0x01, 0x70, 0x8B, 0x0D, 0x77, 0x01, 0xC0,
  0x57, 0x70, 0x2C, 0x06, 0x77, 0x10, 0x9B, 0x0C, 0x77, 0x09, 0xB0, 0xD7, 0x72, 0x02, 0xFF, 0xF9,
  0x05, 0x77, 0x30, 0xEF, 0xFE, 0x0C, 0x77, 0x30, 0x8F, 0xFE, 0x0E, 0x03, 0x77, 0x20, 0x10, 0xEF,
  0xFC, 0x81, 0xEB, 0x37, 0x73, 0x09, 0xB0, 0xD7, 0x77, 0x76, 0x03, 0xC0, 0x57, 0x77, 0x76, 0x0A,
  0xB0, 0xC7, 0x77, 0x77, 0x0E, 0xB0, 0x47, 0x77, 0x77, 0x0E, 0xFF, 0xFC, 0x0D, 0x04, 0x75, 0x0A,
  0xFF, 0xFD, 0x0D, 0x75, 0x02, 0x0E, 0xFF, 0xFC, 0x0D, 0x76, 0x81, 0x2A, 0xEF, 0xFF, 0x90, 0xD0,
  0x48, 0x09, 0xB1, 0x08, 0x41, 0xAD, 0xDA, 0x17, 0x78, 0x41, 0xAD, 0xDA, 0x17, 0x60, 0x10, 0xEC,
  0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x50, 0x9E, 0x0A, 0x75, 0x09, 0xE0, 0xA7, 0x50,
  0xDE, 0x0D, 0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xDE, 0x0D, 0x75, 0x0D, 0xE0, 0xD7, 0x50, 0x9E, 0x0A,
  0x75, 0x09, 0xE0, 0xA7, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x68,
  0x41, 0xAD, 0xDA, 0x17, 0x78, 0x41, 0xAD, 0xDA, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_shopping_cart_checkout() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_shopping_cart_checkout_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_shopping_cart 48x48, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_round_48_action_shopping_cart_data[] PROGMEM = {
  0x04, 0x0D, 0xB0, 0xE0, 0x77, 0x77, 0x75, 0x0D, 0xE0, 0x37, 0x77, 0x74, 0x0D, 0xE0, 0xB7, 0x77,
  0x74, 0x04, 0x0D, 0xE0, 0x27, 0x77, 0x77, 0x0B, 0xFF, 0xFF, 0xD0, 0xD0, 0x44, 0x04, 0xFF, 0xFF,
  0xE0, 0xD5, 0x0C, 0xFF, 0xFF, 0xD0, 0xD5, 0x05, 0xFF, 0xFF, 0xD0, 0x76, 0x0D, 0xFF, 0xFF, 0xB0,
  0xD7, 0x06, 0xFF, 0xFF, 0xB0, 0x57, 0x10, 0xDF, 0xFF, 0xF9, 0x0C, 0x72, 0x06, 0xFF, 0xFF, 0x90,
  0x37, 0x30, 0xEF, 0xFF, 0xE0, 0xA7, 0x40, 0x7F, 0xFF, 0xE0, 0x27, 0x40, 0x10, 0xEF, 0xFF, 0xC0,
  0x97, 0x60, 0x8F, 0xFF, 0xB0, 0xE0, 0x17, 0x60, 0x1F, 0xFF, 0xB0, 0x77, 0x71, 0x09, 0xFF, 0xF9,
  0x0D, 0x77, 0x20, 0x2F, 0xFF, 0x90, 0x67, 0x73, 0x0E, 0xFF, 0xE0, 0xC7, 0x73, 0x08, 0xFF, 0xE0,
  0xE0, 0x37, 0x72, 0x01, 0x0E, 0xFF, 0xC8, 0x1E, 0xB3, 0x77, 0x30, 0x9B, 0x0D, 0x77, 0x77, 0x60,
  0x3C, 0x05, 0x77, 0x77, 0x60, 0xAB, 0x0C, 0x77, 0x77, 0x70, 0xEB, 0x04, 0x77, 0x77, 0x70, 0xEF,
  0xFF, 0xC0, 0xD0, 0x47, 0x50, 0xAF, 0xFF, 0xD0, 0xD7, 0x50, 0x20, 0xEF, 0xFF, 0xC0, 0xD7, 0x68,
  0x12, 0xAE, 0xFF, 0xF9, 0x0D, 0x04, 0x80, 0x9B, 0x10, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x84, 0x1A,
  0xDD, 0xA1, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x09, 0xE0,
  0xA7, 0x50, 0x9E, 0x0A, 0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xDE, 0x0D, 0x75, 0x0D, 0xE0, 0xD7, 0x50,
  0xDE, 0x0D, 0x75, 0x09, 0xE0, 0xA7, 0x50, 0x9E, 0x0A, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x50,
  0x10, 0xEC, 0x0E, 0x01, 0x76, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x84, 0x1A, 0xDD, 0xA1, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_shopping_cart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 41, 43), Box(0, 0, 47, 47),
      ic_round_48_action_shopping_cart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_shop 48x48, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_round_48_action_shop_data[] PROGMEM = {
  0x76, 0x81, 0x1A, 0xDF, 0x98, 0x1D, 0xA1, 0x77, 0x74, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x73,
  0x0A, 0xFF, 0x0A, 0x77, 0x73, 0x0D, 0xFF, 0x0D, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C,
  0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x76, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x84, 0xDA,
  0x10, 0x1E, 0x80, 0xC0, 0xF8, 0x1E, 0x1A, 0x80, 0xC2, 0xF0, 0xA0, 0xD8, 0x0C, 0x2F, 0x0D, 0x80,
  0x9B, 0x2F, 0x00, 0xC8, 0x0C, 0x2F, 0x82, 0x10, 0x5D, 0x80, 0xC0, 0xF4, 0x05, 0x0D, 0xFF, 0xFF,
  0xE6, 0x07, 0x0E, 0xFF, 0xFF, 0xC7, 0x10, 0x70, 0xEF, 0xFF, 0xFA, 0x72, 0x01, 0x09, 0xFF, 0xFF,
  0x97, 0x40, 0x20, 0x9F, 0xFF, 0xE7, 0x60, 0x3F, 0xFF, 0xD7, 0x60, 0x1F, 0xFF, 0xD7, 0x50, 0x50,
  0xEF, 0xFF, 0xD7, 0x30, 0x10, 0xAF, 0xFF, 0xF7, 0x20, 0x50, 0xEF, 0xFF, 0xF9, 0x70, 0x10, 0xAF,
  0xFF, 0xFB, 0x60, 0x50, 0xEF, 0xFF, 0xFC, 0x40, 0x10, 0xAF, 0xFF, 0xFE, 0x30, 0x50, 0xEF, 0xFF,
  0xFF, 0x81, 0x21, 0xA8, 0x0A, 0x93, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A,
  0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_shop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_shop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_shop_two 48x48, 4-bit Alpha,  RLE, 229 bytes.
static const unsigned char ic_round_48_action_shop_two_data[] PROGMEM = {
  0x77, 0x58, 0x11, 0xAD, 0xF9, 0x81, 0xDA, 0x17, 0x77, 0x71, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77,
  0x77, 0x0A, 0xFF, 0x0A, 0x77, 0x77, 0x0D, 0xFF, 0x0D, 0x77, 0x77, 0xC7, 0x1C, 0x77, 0x77, 0xC7,
  0x1C, 0x77, 0x77, 0xC7, 0x1C, 0x77, 0x77, 0xC7, 0x1C, 0x77, 0x58, 0x11, 0xAD, 0xFF, 0xFF, 0x81,
  0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x71, 0x0A, 0xFF, 0xFF, 0xE0, 0xA7, 0x10,
  0xDF, 0xFF, 0xFE, 0x0D, 0x71, 0x80, 0xC0, 0xF7, 0x18, 0x0C, 0x0F, 0x71, 0xFF, 0x00, 0xDF, 0xFE,
  0x71, 0xFF, 0x82, 0x10, 0x5D, 0xFF, 0xC8, 0x24, 0xDD, 0x44, 0xFF, 0x40, 0x60, 0xEF, 0xFA, 0x0D,
  0xA0, 0xD4, 0xFF, 0x50, 0x10, 0x8F, 0xFD, 0x4F, 0xF7, 0x01, 0x09, 0xFF, 0xB4, 0xFF, 0x72, 0x03,
  0xFF, 0xA4, 0xFF, 0x72, 0x01, 0x0E, 0xFF, 0x94, 0xFF, 0x71, 0x03, 0x0D, 0xFF, 0xA4, 0xFF, 0x70,
  0x7F, 0xFC, 0x4F, 0xF5, 0x01, 0x0B, 0xFF, 0xD4, 0xFF, 0x40, 0x40, 0xEF, 0xFE, 0x4F, 0xF3, 0x08,
  0xFF, 0xF9, 0x4F, 0xF8, 0x13, 0x2C, 0xFF, 0xFA, 0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48, 0x0C,
  0x4F, 0x40, 0xDF, 0xFF, 0xFE, 0x0D, 0xC4, 0x0A, 0xFF, 0xFF, 0xE0, 0xAC, 0x40, 0x10, 0xEF, 0xFF,
  0xFC, 0x0E, 0x01, 0xC5, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x1C, 0x80, 0xC4, 0x0C, 0x80,
  0xC4, 0x0C, 0x01, 0x80, 0xC3, 0x0C, 0x0B, 0x01, 0x80, 0xC2, 0x00, 0xDF, 0xFF, 0xFE, 0x0D, 0x71,
  0x0A, 0xFF, 0xFF, 0xE0, 0xA7, 0x10, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF,
  0xFF, 0xF8, 0x1E, 0xA1, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_shop_two() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 43), Box(0, 0, 47, 47),
      ic_round_48_action_shop_two_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_smart_button 48x48, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_48_action_smart_button_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x40, 0x0A, 0x5F, 0x97, 0x77, 0x30, 0x2A, 0x02, 0x4F, 0x97, 0x77, 0x20, 0xAC,
  0x0A, 0x3F, 0x97, 0x77, 0x20, 0xAC, 0x0A, 0x3F, 0x97, 0x76, 0x00, 0x42, 0x03, 0xA0, 0x34, 0xF9,
  0x77, 0x50, 0x2A, 0x01, 0x20, 0x0A, 0x5F, 0x97, 0x75, 0x08, 0xA0, 0x87, 0x2F, 0x97, 0x74, 0x01,
  0x0E, 0xA0, 0xE0, 0x17, 0x1F, 0x97, 0x72, 0x81, 0x18, 0xEC, 0x81, 0xE8, 0x16, 0xC0, 0xDF, 0xF9,
  0x30, 0x5F, 0xB0, 0x43, 0xD0, 0xD0, 0xAF, 0xF9, 0x30, 0x5F, 0xB0, 0x53, 0xD8, 0x1A, 0x1E, 0xFF,
  0x48, 0x12, 0x9E, 0xC8, 0x1E, 0x82, 0x4C, 0x84, 0xE1, 0x01, 0xAD, 0xFD, 0x60, 0x10, 0xEA, 0x0E,
  0x01, 0x6A, 0x81, 0xDA, 0x17, 0x77, 0x30, 0x9A, 0x08, 0x80, 0xC0, 0x00, 0x2A, 0x02, 0x80, 0xC1,
  0x00, 0x05, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_smart_button() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 14, 43, 36), Box(0, 0, 47, 47),
      ic_round_48_action_smart_button_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_source 48x48, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_48_action_source_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFB, 0x81, 0xEB, 0x57, 0x77, 0x20, 0x10, 0xEF, 0xF9, 0x07, 0x77, 0x71, 0x09,
  0xFF, 0xB0, 0x77, 0x77, 0x0D, 0xFF, 0xC0, 0x77, 0x76, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x18, 0x0C,
  0x2F, 0x0E, 0x01, 0x80, 0xC3, 0xF0, 0xA8, 0x0C, 0x3F, 0x0D, 0x80, 0xAC, 0x4F, 0x77, 0x73, 0xFF,
  0xA7, 0x77, 0x3F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x77, 0x38, 0x0A, 0xD4, 0xF7, 0x72, 0xFF, 0xFB,
  0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x28, 0x0A, 0xD4, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D,
  0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81,
  0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_source() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_source_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_space_dashboard 48x48, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_round_48_action_space_dashboard_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xF9, 0x81, 0xDA, 0x16, 0x81, 0x1A, 0xDF, 0x98, 0x4D, 0xA1, 0x01, 0xEF, 0xD0,
  0xE0, 0x14, 0x01, 0x0E, 0xFD, 0x81, 0xE1, 0xAF, 0xF0, 0xA4, 0x0A, 0xFF, 0x0A, 0x0D, 0xFF, 0x0D,
  0x40, 0xDF, 0xF0, 0xDF, 0xFA, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF,
  0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x40, 0xDF, 0xF0, 0xDF, 0xFA, 0x40, 0xAF, 0xF0, 0xAF,
  0xFA, 0x40, 0x10, 0xEF, 0xD0, 0xE0, 0x1F, 0xFA, 0x58, 0x11, 0xAD, 0xF9, 0x81, 0xDA, 0x11, 0xFF,
  0xA7, 0x76, 0xFF, 0xA7, 0x76, 0xFF, 0xA7, 0x76, 0xFF, 0xA7, 0x76, 0xFF, 0xA5, 0x81, 0x1A, 0xDF,
  0x98, 0x1D, 0xA1, 0x1F, 0xFA, 0x40, 0x10, 0xEF, 0xD0, 0xE0, 0x1F, 0xFA, 0x40, 0xAF, 0xF0, 0xAF,
  0xFA, 0x40, 0xDF, 0xF0, 0xDF, 0xFA, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F,
  0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF,
  0xFC, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x40, 0xDF, 0xF0, 0xD0, 0xAF, 0xF0, 0xA4, 0x0A, 0xFF, 0x81,
  0xA1, 0xEF, 0xD0, 0xE0, 0x14, 0x01, 0x0E, 0xFD, 0x84, 0xE1, 0x01, 0xAD, 0xF9, 0x81, 0xDA, 0x16,
  0x81, 0x1A, 0xDF, 0x98, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_space_dashboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_space_dashboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_spatial_audio_off 48x48, 4-bit Alpha,  RLE, 291 bytes.
static const unsigned char ic_round_48_action_spatial_audio_off_data[] PROGMEM = {
  0x77, 0x77, 0x78, 0x29, 0xFC, 0x18, 0x0C, 0x10, 0x04, 0xB0, 0xB8, 0x0C, 0x10, 0x03, 0xC0, 0x68,
  0x0C, 0x10, 0x0A, 0xB0, 0xE0, 0x18, 0x0C, 0x00, 0x01, 0x0E, 0xB0, 0x77, 0x77, 0x73, 0x03, 0x02,
  0x40, 0x8B, 0x0C, 0x77, 0x77, 0x20, 0xAA, 0x06, 0x30, 0x1C, 0x03, 0x75, 0x86, 0x28, 0xCE, 0xEC,
  0x82, 0x72, 0xB0, 0xE0, 0x13, 0x0B, 0xB0, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x10, 0xDB, 0x06, 0x30,
  0x7B, 0x0A, 0x73, 0x0B, 0xFB, 0x0B, 0x70, 0x7B, 0x0A, 0x30, 0x4B, 0x0C, 0x72, 0x09, 0xFD, 0x09,
  0x60, 0x3B, 0x0D, 0x30, 0x1B, 0x0E, 0x71, 0x02, 0xFF, 0x02, 0x50, 0x1B, 0x0E, 0x30, 0x1B, 0x0E,
  0x71, 0x08, 0xFF, 0x08, 0x50, 0x1B, 0x0E, 0x4B, 0x0D, 0x71, 0x0C, 0xFF, 0x0C, 0x50, 0x5B, 0x0C,
  0x30, 0x2B, 0x0D, 0x71, 0x0E, 0xFF, 0x0E, 0x50, 0xBB, 0x08, 0x30, 0x4B, 0x0A, 0x71, 0x0E, 0xFF,
  0x0E, 0x5C, 0x03, 0x30, 0x7B, 0x07, 0x71, 0x0C, 0xFF, 0x0C, 0x50, 0xEA, 0x0B, 0x40, 0xDB, 0x03,
  0x71, 0x08, 0xFF, 0x08, 0x58, 0x23, 0xA9, 0x13, 0x03, 0xB0, 0xD7, 0x20, 0x2F, 0xF0, 0x27, 0x50,
  0xCB, 0x08, 0x73, 0x09, 0xFD, 0x09, 0x75, 0x06, 0xC0, 0x27, 0x40, 0xBF, 0xB0, 0xB7, 0x50, 0x10,
  0xEB, 0x09, 0x76, 0x09, 0xF9, 0x09, 0x76, 0x04, 0xB0, 0xE0, 0x17, 0x78, 0x62, 0x8C, 0xEE, 0xC8,
  0x27, 0x70, 0x10, 0xEA, 0x05, 0x80, 0xC2, 0x08, 0x12, 0x74, 0x80, 0xE3, 0x08, 0x42, 0x68, 0xBD,
  0xDA, 0x84, 0xDD, 0xB8, 0x62, 0x77, 0x74, 0x81, 0x49, 0xEF, 0xF8, 0x1E, 0x94, 0x77, 0x60, 0x70,
  0xDF, 0xFE, 0x0D, 0x07, 0x77, 0x20, 0x50, 0xEF, 0xFF, 0xB0, 0xE0, 0x57, 0x60, 0x7F, 0xFF, 0xF0,
  0x77, 0x40, 0x3F, 0xFF, 0xFA, 0x03, 0x73, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x30, 0xDF, 0xFF, 0xFA,
  0x0D, 0x73, 0xFF, 0xFF, 0xC7, 0x3F, 0xFF, 0xFC, 0x73, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x30, 0xAF,
  0xFF, 0xFA, 0x0A, 0x73, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x74, 0x81, 0x1A, 0xDF, 0xFF, 0xB8,
  0x1D, 0xA1, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_spatial_audio_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_spatial_audio_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_spatial_audio 48x48, 4-bit Alpha,  RLE, 269 bytes.
static const unsigned char ic_round_48_action_spatial_audio_data[] PROGMEM = {
  0x77, 0x73, 0x82, 0x3D, 0xE5, 0x48, 0x22, 0xCE, 0x67, 0x77, 0x72, 0x0C, 0xA0, 0xE4, 0x0A, 0xB0,
  0x27, 0x77, 0x71, 0x0D, 0xB0, 0x23, 0x0A, 0xB0, 0x87, 0x77, 0x71, 0x0A, 0xB0, 0x53, 0x05, 0xB0,
  0xE0, 0x27, 0x77, 0x70, 0x6B, 0x0A, 0x40, 0xDB, 0x0E, 0x02, 0x77, 0x76, 0x01, 0xC0, 0x13, 0x05,
  0xD0, 0x80, 0x27, 0x77, 0x50, 0xBB, 0x08, 0x40, 0x9E, 0x06, 0x77, 0x74, 0x04, 0xB0, 0xE0, 0x24,
  0x08, 0xD0, 0xD7, 0x58, 0x62, 0x8C, 0xEE, 0xC8, 0x26, 0x0C, 0xB0, 0xC5, 0x03, 0x0D, 0xB0, 0xB7,
  0x40, 0x9F, 0x90, 0x95, 0x03, 0xC0, 0xA6, 0x82, 0x59, 0x81, 0x73, 0x0B, 0xFB, 0x0B, 0x50, 0x8C,
  0x0B, 0x77, 0x40, 0x9F, 0xD0, 0x95, 0x0C, 0xC0, 0xD0, 0x37, 0x71, 0x02, 0xFF, 0x02, 0x40, 0x10,
  0xCD, 0x0A, 0x02, 0x76, 0x08, 0xFF, 0x08, 0x50, 0x10, 0xDE, 0x81, 0xC7, 0x37, 0x30, 0xCF, 0xF0,
  0xC7, 0x0A, 0xF9, 0x0E, 0x05, 0x71, 0x0E, 0xFF, 0x0E, 0x71, 0x05, 0x0D, 0xF0, 0xD7, 0x10, 0xEF,
  0xF0, 0xE7, 0x30, 0x60, 0xCD, 0x0C, 0x71, 0x0C, 0xFF, 0x0C, 0x75, 0x84, 0x26, 0xAC, 0xB2, 0x71,
  0x08, 0xFF, 0x08, 0x77, 0x75, 0x02, 0xFF, 0x02, 0x77, 0x76, 0x09, 0xFD, 0x09, 0x77, 0x77, 0x10,
  0xBF, 0xB0, 0xB7, 0x77, 0x73, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x58, 0x62, 0x8C, 0xEE, 0xC8, 0x28,
  0x09, 0xD7, 0x08, 0x42, 0x68, 0xBD, 0xDA, 0x84, 0xDD, 0xB8, 0x62, 0x77, 0x74, 0x81, 0x49, 0xEF,
  0xF8, 0x1E, 0x94, 0x77, 0x60, 0x70, 0xDF, 0xFE, 0x0D, 0x07, 0x77, 0x20, 0x50, 0xEF, 0xFF, 0xB0,
  0xE0, 0x57, 0x60, 0x7F, 0xFF, 0xF0, 0x77, 0x40, 0x3F, 0xFF, 0xFA, 0x03, 0x73, 0x09, 0xFF, 0xFF,
  0xA0, 0x97, 0x30, 0xDF, 0xFF, 0xFA, 0x0D, 0x73, 0xFF, 0xFF, 0xC7, 0x3F, 0xFF, 0xFC, 0x73, 0xFF,
  0xFF, 0xC7, 0x3F, 0xFF, 0xFC, 0x73, 0xFF, 0xFF, 0xC7, 0x3F, 0xFF, 0xFC, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_spatial_audio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_spatial_audio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_spatial_tracking 48x48, 4-bit Alpha,  RLE, 277 bytes.
static const unsigned char ic_round_48_action_spatial_tracking_data[] PROGMEM = {
  0x77, 0x77, 0x38, 0x21, 0xCF, 0x98, 0x0C, 0x10, 0x0B, 0xB0, 0x47, 0x77, 0x77, 0x06, 0xC0, 0x37,
  0x77, 0x77, 0x0D, 0xB0, 0xA7, 0x77, 0x77, 0x06, 0xB0, 0xE0, 0x17, 0x77, 0x77, 0x0B, 0xB0, 0x74,
  0x02, 0x03, 0x77, 0x77, 0x10, 0x1B, 0x0E, 0x40, 0x7A, 0x09, 0x75, 0x86, 0x28, 0xCE, 0xEC, 0x82,
  0x71, 0x06, 0xB0, 0xA3, 0x01, 0x0E, 0xB7, 0x40, 0x9F, 0x90, 0x97, 0x09, 0xB0, 0x53, 0x07, 0xB0,
  0xD7, 0x30, 0xBF, 0xB0, 0xB6, 0x0C, 0xB0, 0x33, 0x0B, 0xB0, 0x77, 0x20, 0x9F, 0xD0, 0x95, 0x0D,
  0xB4, 0x0D, 0xB0, 0x27, 0x10, 0x2F, 0xF0, 0x24, 0x0E, 0xB4, 0x0E, 0xB0, 0x17, 0x10, 0x8F, 0xF0,
  0x84, 0x0E, 0xB4, 0x0E, 0xB0, 0x17, 0x10, 0xCF, 0xF0, 0xC4, 0x0D, 0xB0, 0x23, 0x0C, 0xB0, 0x47,
  0x10, 0xEF, 0xF0, 0xE4, 0x0B, 0xB0, 0x53, 0x08, 0xB0, 0xA7, 0x10, 0xEF, 0xF0, 0xE4, 0x09, 0xB0,
  0x93, 0x03, 0xC7, 0x10, 0xCF, 0xF0, 0xC4, 0x05, 0xB0, 0xE4, 0x0B, 0xA0, 0xE7, 0x10, 0x8F, 0xF0,
  0x85, 0x0E, 0xB0, 0x43, 0x82, 0x19, 0xA3, 0x71, 0x02, 0xFF, 0x02, 0x50, 0xAB, 0x0C, 0x77, 0x20,
  0x9F, 0xD0, 0x96, 0x04, 0xC0, 0x57, 0x72, 0x0B, 0xFB, 0x0B, 0x71, 0x0B, 0xB0, 0xE0, 0x17, 0x72,
  0x09, 0xF9, 0x09, 0x72, 0x02, 0x0E, 0xB0, 0x47, 0x73, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x74, 0x06,
  0xA0, 0xE0, 0x18, 0x0C, 0x10, 0x81, 0x47, 0x28, 0x0E, 0x40, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D,
  0xDB, 0x86, 0x27, 0x77, 0x38, 0x14, 0x9E, 0xFF, 0x81, 0xE9, 0x47, 0x75, 0x07, 0x0D, 0xFF, 0xE0,
  0xD0, 0x77, 0x71, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x75, 0x07, 0xFF, 0xFF, 0x07, 0x73, 0x03,
  0xFF, 0xFF, 0xA0, 0x37, 0x20, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x2F,
  0xFF, 0xFC, 0x72, 0xFF, 0xFF, 0xC7, 0x2F, 0xFF, 0xFC, 0x72, 0xFF, 0xFF, 0xC7, 0x2F, 0xFF, 0xFC,
  0x72, 0xFF, 0xFF, 0xC7, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_spatial_tracking() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 44, 41), Box(0, 0, 47, 47),
      ic_round_48_action_spatial_tracking_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_speaker_notes_off 48x48, 4-bit Alpha,  RLE, 320 bytes.
static const unsigned char ic_round_48_action_speaker_notes_off_data[] PROGMEM = {
  0x18, 0x16, 0xB7, 0x40, 0x5F, 0xFF, 0xFB, 0x83, 0xDA, 0x10, 0x2B, 0x09, 0x40, 0x5F, 0xFF, 0xFC,
  0x81, 0xE1, 0x1C, 0x09, 0x40, 0x5F, 0xFF, 0xFC, 0x81, 0xA0, 0x7C, 0x09, 0x40, 0x5F, 0xFF, 0xFB,
  0x0D, 0x20, 0x7C, 0x09, 0x40, 0x5F, 0xFF, 0xFB, 0x30, 0x7C, 0x09, 0x40, 0x5F, 0xFF, 0xFA, 0x40,
  0xEC, 0x09, 0x40, 0x5F, 0xFF, 0xF9, 0x40, 0xED, 0x09, 0x40, 0x5F, 0xFF, 0xF4, 0x0E, 0xE0, 0x94,
  0x05, 0xB0, 0xB0, 0x17, 0x50, 0x10, 0xBF, 0x94, 0x0E, 0xF0, 0x94, 0x05, 0xA0, 0x17, 0x70, 0x1F,
  0x94, 0x0E, 0xF9, 0x09, 0x48, 0x15, 0xF1, 0x77, 0x01, 0xF9, 0x40, 0xEF, 0xA0, 0x94, 0x81, 0x5A,
  0x17, 0x50, 0x10, 0xBF, 0x94, 0xFC, 0x09, 0x40, 0x5F, 0xFF, 0xA4, 0xFD, 0x09, 0x40, 0x5F, 0xFF,
  0x94, 0xF9, 0x84, 0xB1, 0x1B, 0xF9, 0x77, 0x20, 0x10, 0xBF, 0x94, 0xF9, 0x01, 0x20, 0x1A, 0x09,
  0x77, 0x20, 0x1F, 0x94, 0xF9, 0x01, 0x20, 0x1B, 0x09, 0x77, 0x10, 0x1F, 0x94, 0xF9, 0x82, 0xB1,
  0x1B, 0xC0, 0x97, 0x60, 0x10, 0xBF, 0x94, 0xFF, 0xB0, 0x94, 0x05, 0xFF, 0xB4, 0xFF, 0xC0, 0x94,
  0x05, 0xFF, 0xA4, 0xF9, 0x82, 0xB1, 0x1B, 0xF0, 0x94, 0x05, 0xFF, 0x94, 0xF9, 0x01, 0x20, 0x1F,
  0x90, 0x94, 0x05, 0xFF, 0x4F, 0x90, 0x12, 0x01, 0xFA, 0x09, 0x40, 0x5F, 0xE4, 0xF9, 0x82, 0xB1,
  0x1B, 0xFB, 0x09, 0x40, 0x5F, 0xD4, 0xFF, 0xFA, 0x09, 0x40, 0x5F, 0xC4, 0xFF, 0xFB, 0x09, 0x40,
  0x5F, 0xB4, 0xFF, 0xFC, 0x09, 0x40, 0x5F, 0xA4, 0xFF, 0xFD, 0x09, 0x40, 0x5F, 0x94, 0xFF, 0xFE,
  0x09, 0x40, 0x5E, 0x0D, 0x4F, 0xFF, 0xF0, 0x94, 0x05, 0xD0, 0xA4, 0xFF, 0xFF, 0x90, 0x94, 0x05,
  0xB0, 0xE0, 0x14, 0xFF, 0xFF, 0xA0, 0x94, 0x82, 0x5D, 0x91, 0x5F, 0x07, 0x77, 0x40, 0x7C, 0x09,
  0x75, 0xE0, 0x77, 0x76, 0x07, 0xC0, 0x97, 0x4D, 0x07, 0x77, 0x71, 0x07, 0xC0, 0x97, 0x3C, 0x07,
  0x77, 0x73, 0x07, 0xC0, 0x97, 0x2B, 0x07, 0x77, 0x75, 0x07, 0xC0, 0x97, 0x1A, 0x07, 0x77, 0x77,
  0x07, 0xC0, 0x97, 0x90, 0x77, 0x77, 0x72, 0x07, 0xC0, 0x96, 0x07, 0x77, 0x77, 0x40, 0x7C, 0x08,
  0x80, 0xC3, 0x00, 0x7C, 0x02, 0x80, 0xC3, 0x00, 0x7B, 0x01, 0x80, 0xC4, 0x08, 0x15, 0xA4, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_speaker_notes_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 43, 46), Box(0, 0, 47, 47),
      ic_round_48_action_speaker_notes_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_speaker_notes 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_round_48_action_speaker_notes_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0A, 0xC4, 0xF4, 0xC0, 0xB0, 0x17, 0x50, 0x10, 0xBF,
  0xFA, 0x4C, 0x01, 0x77, 0x01, 0xFF, 0xA4, 0xC0, 0x17, 0x70, 0x1F, 0xFA, 0x4C, 0x0B, 0x01, 0x75,
  0x01, 0x0B, 0x80, 0x9B, 0x4F, 0x4C, 0x0B, 0x01, 0x75, 0x01, 0x0B, 0xFF, 0xA4, 0xC0, 0x17, 0x70,
  0x1F, 0xFA, 0x4C, 0x01, 0x77, 0x01, 0xFF, 0xA4, 0xC0, 0xB0, 0x17, 0x50, 0x10, 0xB8, 0x09, 0xB4,
  0xF4, 0xC0, 0xB0, 0x16, 0x01, 0x0B, 0xFF, 0xF9, 0x4C, 0x01, 0x71, 0x01, 0xFF, 0xF9, 0x4C, 0x01,
  0x71, 0x01, 0xFF, 0xF9, 0x4C, 0x0B, 0x01, 0x60, 0x10, 0xB8, 0x0B, 0xA1, 0xF0, 0xD8, 0x0C, 0x3F,
  0x0A, 0x80, 0xC2, 0xF0, 0xE0, 0x18, 0x0C, 0x0F, 0x81, 0xDA, 0x11, 0xF0, 0x77, 0x77, 0x74, 0xE0,
  0x77, 0x77, 0x75, 0xD0, 0x77, 0x77, 0x76, 0xC0, 0x77, 0x77, 0x77, 0xB0, 0x78, 0x0C, 0x00, 0xA0,
  0x78, 0x0C, 0x10, 0x90, 0x78, 0x0C, 0x20, 0x07, 0x80, 0xC3, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_speaker_notes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_speaker_notes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_spellcheck 48x48, 4-bit Alpha,  RLE, 294 bytes.
static const unsigned char ic_round_48_action_spellcheck_data[] PROGMEM = {
  0x73, 0x82, 0x7E, 0xE7, 0x80, 0xC0, 0x00, 0x6C, 0x06, 0x77, 0x77, 0x70, 0xCC, 0x0C, 0x77, 0x77,
  0x60, 0x3E, 0x03, 0x77, 0x77, 0x50, 0x9E, 0x09, 0x77, 0x77, 0x50, 0xEA, 0x00, 0xCA, 0x0E, 0x77,
  0x77, 0x40, 0x6B, 0x00, 0x6B, 0x06, 0x77, 0x77, 0x30, 0xCB, 0x00, 0x1B, 0x0C, 0x77, 0x77, 0x20,
  0x3B, 0x0A, 0x20, 0xAB, 0x03, 0x77, 0x77, 0x10, 0x9B, 0x04, 0x20, 0x4B, 0x09, 0x77, 0x77, 0x10,
  0xEA, 0x0E, 0x40, 0xEA, 0x0E, 0x77, 0x77, 0x05, 0xB0, 0x84, 0x08, 0xB0, 0x57, 0x77, 0x60, 0xBB,
  0x02, 0x40, 0x2B, 0x0B, 0x77, 0x75, 0x02, 0xB0, 0xC6, 0x0C, 0xB0, 0x27, 0x77, 0x40, 0x8B, 0x06,
  0x60, 0x6B, 0x08, 0x77, 0x74, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x77, 0x30, 0x5F, 0xFA, 0x05,
  0x77, 0x72, 0x0B, 0xFF, 0xA0, 0xB7, 0x77, 0x10, 0x2F, 0xFC, 0x02, 0x77, 0x82, 0x3C, 0xE6, 0x30,
  0x8F, 0xFC, 0x08, 0x76, 0x03, 0x0E, 0xB0, 0x12, 0x0D, 0xB0, 0x27, 0x30, 0x3B, 0x0D, 0x75, 0x03,
  0x0E, 0xC8, 0x11, 0x04, 0xB0, 0xC7, 0x50, 0xCB, 0x04, 0x73, 0x03, 0x0E, 0xC0, 0x72, 0x0A, 0xB0,
  0x67, 0x50, 0x6B, 0x0A, 0x72, 0x03, 0x0E, 0xC0, 0x73, 0xC0, 0x17, 0x50, 0x1C, 0x71, 0x03, 0x0E,
  0xC0, 0x73, 0x01, 0xB0, 0xA7, 0x70, 0xAB, 0x01, 0x60, 0x30, 0xEC, 0x07, 0x58, 0x26, 0xEC, 0x17,
  0x78, 0x22, 0xCE, 0x66, 0x03, 0x0E, 0xC0, 0x77, 0x75, 0x01, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x75,
  0x82, 0xBF, 0xD3, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x75, 0x04, 0xB0, 0xE0, 0x37, 0x10, 0x30, 0xEC,
  0x07, 0x77, 0x60, 0x2C, 0x0E, 0x03, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x34,
  0x03, 0x0E, 0xC0, 0x77, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x75, 0x07,
  0xC8, 0x2E, 0x33, 0xEC, 0x07, 0x77, 0x77, 0x07, 0xC0, 0x0E, 0xC0, 0x77, 0x77, 0x72, 0x07, 0xF9,
  0x07, 0x77, 0x77, 0x40, 0x7E, 0x08, 0x77, 0x77, 0x60, 0x7C, 0x08, 0x80, 0xC0, 0x00, 0x7A, 0x07,
  0x80, 0xC2, 0x00, 0x01, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_spellcheck() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 45, 44), Box(0, 0, 47, 47),
      ic_round_48_action_spellcheck_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_star_rate 48x48, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_round_48_action_star_rate_data[] PROGMEM = {
  0x77, 0x05, 0xA0, 0x57, 0x77, 0x70, 0xEA, 0x0E, 0x77, 0x76, 0x04, 0xC0, 0x47, 0x77, 0x50, 0x8C,
  0x09, 0x77, 0x75, 0x0D, 0xC0, 0xD7, 0x77, 0x40, 0x2E, 0x02, 0x77, 0x73, 0x07, 0xE0, 0x77, 0x77,
  0x30, 0xCE, 0x0C, 0x77, 0x72, 0x01, 0xF9, 0x01, 0x77, 0x71, 0x06, 0xF9, 0x06, 0x77, 0x71, 0x0A,
  0xF9, 0x0A, 0x74, 0x02, 0x0C, 0xFF, 0xFF, 0x81, 0xC2, 0x9F, 0xFF, 0xFA, 0x00, 0x9F, 0xFF, 0xFA,
  0x81, 0x92, 0xDF, 0xFF, 0xF0, 0xD0, 0x12, 0x09, 0xFF, 0xFD, 0x0A, 0x50, 0x50, 0xEF, 0xFF, 0x90,
  0xE0, 0x57, 0x01, 0x0B, 0xFF, 0xE0, 0xC0, 0x27, 0x30, 0x7F, 0xFC, 0x07, 0x76, 0x03, 0x0D, 0xFF,
  0x0D, 0x03, 0x77, 0x10, 0xDF, 0xF0, 0xD7, 0x71, 0x02, 0xFF, 0xA0, 0x27, 0x70, 0x7F, 0xFA, 0x07,
  0x77, 0x0C, 0xFF, 0xA0, 0xB7, 0x60, 0x1F, 0xFC, 0x01, 0x75, 0x06, 0xF9, 0x00, 0xDF, 0x90, 0x67,
  0x50, 0xBF, 0x82, 0xB1, 0x1B, 0xF0, 0xA7, 0x5F, 0x07, 0x40, 0x8F, 0x74, 0x05, 0xD0, 0xE0, 0x46,
  0x04, 0x0E, 0xD0, 0x57, 0x30, 0x8C, 0x0B, 0x01, 0x71, 0x01, 0x0C, 0xC0, 0x87, 0x30, 0x5B, 0x08,
  0x75, 0x08, 0xB0, 0x57, 0x48, 0x15, 0x94, 0x77, 0x81, 0x38, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_star_rate() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 9, 39, 40), Box(0, 0, 47, 47),
      ic_round_48_action_star_rate_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_stars 48x48, 4-bit Alpha,  RLE, 299 bytes.
static const unsigned char ic_round_48_action_stars_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0B, 0xFF, 0xFD, 0x0A, 0x74, 0x0B, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0x00, 0xCF, 0xF0, 0x97, 0x05, 0xFF, 0x0E, 0x20, 0xEF, 0xF0, 0x55, 0x01, 0x0E, 0xFF, 0x08,
  0x20, 0x8F, 0xF0, 0xE0, 0x14, 0x09, 0xFF, 0x90, 0x12, 0x01, 0xFF, 0x90, 0x93, 0x01, 0xFF, 0x90,
  0xA4, 0x0A, 0xFF, 0x90, 0x12, 0x08, 0xFF, 0x90, 0x34, 0x03, 0xFF, 0x90, 0x82, 0x0D, 0xFF, 0x0C,
  0x60, 0xCF, 0xF8, 0x1D, 0x03, 0xFF, 0x90, 0x66, 0x06, 0xFF, 0x90, 0x30, 0x7F, 0x86, 0xC9, 0x87,
  0x54, 0x31, 0x71, 0x86, 0x13, 0x45, 0x78, 0x9C, 0xF0, 0x70, 0xAE, 0x0D, 0x77, 0x73, 0x0D, 0xE0,
  0xA0, 0xCF, 0x03, 0x77, 0x71, 0x03, 0xF0, 0xC0, 0xEF, 0x0E, 0x04, 0x77, 0x60, 0x5F, 0x90, 0xEF,
  0xB0, 0x67, 0x74, 0x07, 0xFF, 0xF0, 0x87, 0x72, 0x09, 0xFC, 0x0E, 0xFC, 0x0A, 0x77, 0x0B, 0xFC,
  0x0E, 0x0C, 0xFD, 0x09, 0x75, 0x0A, 0xFD, 0x0C, 0x0A, 0xFD, 0x07, 0x75, 0x07, 0xFD, 0x0A, 0x07,
  0xFD, 0x04, 0x75, 0x04, 0xFD, 0x07, 0x03, 0xFD, 0x77, 0xFD, 0x81, 0x30, 0xDF, 0xB0, 0xC7, 0x70,
  0xCF, 0xB0, 0xD2, 0x08, 0xFB, 0x08, 0x58, 0x23, 0xCC, 0x35, 0x09, 0xFB, 0x08, 0x20, 0x1F, 0xB0,
  0x53, 0x01, 0x09, 0xC0, 0x90, 0x13, 0x05, 0xFB, 0x01, 0x30, 0x9F, 0xA0, 0x12, 0x05, 0x0E, 0xE0,
  0xE0, 0x52, 0x02, 0xFA, 0x09, 0x40, 0x10, 0xEF, 0x98, 0x15, 0x3C, 0xFB, 0x81, 0xC3, 0x5F, 0x90,
  0xE0, 0x15, 0x05, 0xFF, 0xFF, 0xC0, 0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xBF, 0xFF, 0xF0,
  0xA7, 0x40, 0xBF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0,
  0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81,
  0x77, 0x74, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_stars() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_stars_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_sticky_note_2 48x48, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_round_48_action_sticky_note_2_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xBB, 0x4F, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBF, 0xFA,
  0x01, 0x77, 0x40, 0x1F, 0xFA, 0x01, 0x77, 0x40, 0x1F, 0xFA, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xB8,
  0x0A, 0xB4, 0xF0, 0xB0, 0x16, 0x01, 0x0B, 0xFF, 0xFD, 0x01, 0x71, 0x01, 0xFF, 0xFD, 0x01, 0x71,
  0x01, 0xFF, 0xFD, 0x0B, 0x01, 0x60, 0x10, 0xB8, 0x0C, 0x4F, 0x0B, 0x01, 0x71, 0x07, 0xFF, 0xFC,
  0x01, 0x71, 0x07, 0xFF, 0xFD, 0x71, 0x07, 0xC0, 0x7F, 0xFF, 0x97, 0x07, 0xC0, 0x71, 0xFF, 0xF9,
  0x60, 0x7C, 0x07, 0x2F, 0xFF, 0x95, 0x07, 0xC0, 0x73, 0xFF, 0xF9, 0x40, 0x7C, 0x07, 0x4F, 0xFF,
  0x93, 0x07, 0xC0, 0x75, 0xFF, 0xF9, 0x20, 0x7C, 0x07, 0x6F, 0xFF, 0x91, 0x07, 0xC0, 0x77, 0x0D,
  0xFF, 0xF0, 0x7C, 0x07, 0x71, 0x09, 0xFF, 0xFC, 0x07, 0x72, 0x01, 0x0E, 0xFF, 0xFA, 0x07, 0x74,
  0x81, 0x1A, 0xDF, 0xFE, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_sticky_note_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_sticky_note_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_store 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_round_48_action_store_data[] PROGMEM = {
  0x30, 0x40, 0xDF, 0xFF, 0xF0, 0xD0, 0x46, 0x0D, 0xFF, 0xFF, 0xA0, 0xD6, 0x0D, 0xFF, 0xFF, 0xA0,
  0xD6, 0x04, 0x0D, 0xFF, 0xFF, 0x0D, 0x04, 0x80, 0x99, 0x60, 0x09, 0x0E, 0xFF, 0xFF, 0x0E, 0x09,
  0x50, 0x4F, 0xFF, 0xFC, 0x04, 0x40, 0x7F, 0xFF, 0xFC, 0x07, 0x40, 0xAF, 0xFF, 0xFC, 0x0A, 0x40,
  0xDF, 0xFF, 0xFC, 0x0D, 0x30, 0x1F, 0xFF, 0xFE, 0x01, 0x20, 0x4F, 0xFF, 0xFE, 0x04, 0x20, 0x7F,
  0xFF, 0xFE, 0x07, 0x20, 0xAF, 0xFF, 0xFE, 0x0A, 0x20, 0xDF, 0xFF, 0xFE, 0x81, 0xD0, 0x18, 0x0C,
  0x0F, 0x01, 0x04, 0x80, 0xC0, 0xF0, 0x40, 0x38, 0x0C, 0x0F, 0x82, 0x30, 0x8E, 0xFF, 0xFF, 0xC0,
  0xE0, 0x84, 0xC7, 0x5C, 0x71, 0xC6, 0xC7, 0x5C, 0x71, 0xC6, 0xC7, 0x5C, 0x71, 0xC6, 0xC7, 0x5C,
  0x71, 0xC6, 0xC7, 0x5C, 0x71, 0xC6, 0xC7, 0x5C, 0x71, 0xC6, 0xC7, 0x5C, 0x71, 0xC6, 0xC7, 0x5C,
  0x71, 0xC6, 0xFF, 0xE7, 0x1C, 0x6F, 0xFE, 0x71, 0xC6, 0x0D, 0xFF, 0xC0, 0xD7, 0x10, 0xDA, 0x0D,
  0x60, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x71, 0x82, 0x4D, 0xD4, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 8, 42, 39), Box(0, 0, 47, 47),
      ic_round_48_action_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_subject 48x48, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_48_action_subject_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF,
  0xFF, 0xF0, 0xD0, 0x48, 0x09, 0xF4, 0x00, 0x40, 0xDF, 0xFF, 0xF8, 0x1D, 0x4D, 0xFF, 0xFF, 0xA0,
  0x0D, 0xFF, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xFF, 0x0D, 0x04, 0x80, 0x9F, 0x40, 0x04, 0x0D, 0xFF,
  0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF, 0xFF, 0xF0, 0xD0,
  0x48, 0x09, 0xF4, 0x00, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x75, 0x0D, 0xFF, 0xC0, 0xD7, 0x50, 0xDF,
  0xFC, 0x0D, 0x75, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x47, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_subject() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 10, 39, 37), Box(0, 0, 47, 47),
      ic_round_48_action_subject_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_subtitles_off 48x48, 4-bit Alpha,  RLE, 268 bytes.
static const unsigned char ic_round_48_action_subtitles_off_data[] PROGMEM = {
  0x10, 0x02, 0x80, 0xC2, 0x00, 0x8A, 0x07, 0x80, 0xC1, 0x0C, 0x07, 0x80, 0xC0, 0x00, 0xDC, 0x07,
  0x50, 0xCF, 0xFF, 0xC8, 0x4D, 0xA1, 0x03, 0xEC, 0x07, 0x50, 0xCF, 0xFF, 0xD8, 0x2E, 0x10, 0xAD,
  0x07, 0x50, 0xCF, 0xFF, 0xD8, 0x1A, 0x0E, 0xE0, 0x75, 0x0C, 0xFF, 0xFC, 0x0D, 0x1F, 0x90, 0x75,
  0x0C, 0xFF, 0xFC, 0x1F, 0xA0, 0x75, 0x0C, 0xFF, 0xFB, 0x1F, 0xB0, 0x75, 0x0C, 0xFF, 0xFA, 0x1F,
  0xC0, 0x75, 0x0C, 0xFF, 0xF9, 0x1F, 0xD0, 0x75, 0x0C, 0xFF, 0xF1, 0xFE, 0x07, 0x50, 0xCF, 0xFE,
  0x1F, 0xF0, 0x75, 0x0C, 0xFF, 0xD1, 0xFF, 0x90, 0x75, 0x0C, 0xFF, 0xC1, 0xFF, 0xA0, 0x75, 0x0C,
  0xFF, 0xB1, 0xFF, 0xB0, 0x75, 0x0C, 0xFF, 0xA1, 0xFF, 0xC0, 0x75, 0x0C, 0xFF, 0x91, 0xFF, 0xD0,
  0x75, 0x0C, 0xFF, 0x1C, 0x0B, 0x01, 0x40, 0x10, 0xBF, 0x90, 0x77, 0x60, 0x10, 0xBC, 0x1C, 0x01,
  0x60, 0x1F, 0xA0, 0x77, 0x60, 0x1C, 0x1C, 0x01, 0x60, 0x1F, 0xB0, 0x77, 0x50, 0x1C, 0x1C, 0x0B,
  0x01, 0x40, 0x10, 0xBF, 0xC0, 0x77, 0x30, 0x10, 0xBC, 0x1F, 0xFF, 0xB0, 0x75, 0x0C, 0xFA, 0x1F,
  0xFF, 0xC0, 0x75, 0x0C, 0xF9, 0x1F, 0xFF, 0xD0, 0x75, 0x0C, 0xF1, 0xFF, 0xFE, 0x07, 0x50, 0xCE,
  0x1C, 0x0B, 0x01, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xCD, 0x1C, 0x01, 0x77, 0x40, 0x3D, 0x07,
  0x50, 0xCC, 0x1C, 0x01, 0x77, 0x40, 0x1E, 0x07, 0x50, 0xCB, 0x1C, 0x0B, 0x01, 0x77, 0x20, 0x10,
  0xBF, 0x07, 0x50, 0xCA, 0x10, 0xDF, 0xFF, 0xFB, 0x07, 0x58, 0x2C, 0xE0, 0xAF, 0xFF, 0xFC, 0x07,
  0x58, 0x27, 0x01, 0xEF, 0xFF, 0xFC, 0x07, 0x78, 0x11, 0xAD, 0xFF, 0xFF, 0xB0, 0x77, 0x77, 0x77,
  0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x17,
  0x77, 0x77, 0x03, 0x0E, 0xB0, 0x28, 0x0C, 0x00, 0x82, 0x3D, 0xF8, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_subtitles_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 43, 44), Box(0, 0, 47, 47),
      ic_round_48_action_subtitles_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_supervised_user_circle 48x48, 4-bit Alpha,  RLE, 364 bytes.
static const unsigned char ic_round_48_action_supervised_user_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFA, 0x82, 0xDA, 0x8C, 0xFF,
  0xD0, 0xE0, 0x14, 0x09, 0xFA, 0x07, 0x40, 0x30, 0xDF, 0xFC, 0x09, 0x30, 0x1F, 0xA0, 0x76, 0x01,
  0x0E, 0xFF, 0xC0, 0x12, 0x08, 0xF9, 0x0D, 0x71, 0x07, 0xE8, 0x1C, 0xBE, 0xFA, 0x08, 0x20, 0xDF,
  0x90, 0xA7, 0x10, 0x3C, 0x0C, 0x02, 0x30, 0x7F, 0x98, 0x1D, 0x03, 0xFA, 0x08, 0x71, 0x01, 0xB0,
  0xE0, 0x15, 0x09, 0xF9, 0x03, 0x07, 0xFA, 0x0B, 0x71, 0x04, 0xB0, 0x86, 0x01, 0xF9, 0x07, 0x0A,
  0xFB, 0x02, 0x70, 0xBB, 0x06, 0x7F, 0x90, 0xA0, 0xCF, 0xB0, 0xC0, 0x15, 0x07, 0xC0, 0x86, 0x01,
  0xF9, 0x0C, 0x0E, 0xFC, 0x84, 0xE6, 0x21, 0x4B, 0xD0, 0xD0, 0x15, 0x08, 0xF9, 0x0E, 0xFF, 0xFB,
  0x0B, 0x01, 0x30, 0x6F, 0xFF, 0xFF, 0x82, 0xEB, 0xAD, 0xFC, 0x0E, 0x80, 0xC2, 0xF0, 0xE0, 0xCF,
  0x98, 0x3E, 0xA6, 0x31, 0x28, 0x11, 0x28, 0xFF, 0xE0, 0xC0, 0xAE, 0x0A, 0x03, 0x71, 0x07, 0xE8,
  0x5C, 0xA8, 0x89, 0xBE, 0xF9, 0x0A, 0x07, 0xC0, 0xC0, 0x37, 0x20, 0x7C, 0x81, 0xA5, 0x17, 0x81,
  0x38, 0xED, 0x07, 0x03, 0xC0, 0x17, 0x20, 0x3B, 0x0C, 0x02, 0x75, 0x01, 0x09, 0xC8, 0x13, 0x0D,
  0xB0, 0x67, 0x20, 0x8A, 0x0D, 0x77, 0x10, 0x6B, 0x0D, 0x20, 0x8B, 0x0D, 0x72, 0x0B, 0xA0, 0x77,
  0x71, 0x0D, 0xB0, 0x82, 0x01, 0xC0, 0x77, 0x10, 0xCA, 0x06, 0x77, 0x07, 0xC0, 0x13, 0x09, 0xC0,
  0x37, 0x0C, 0xA0, 0x67, 0x60, 0x3C, 0x09, 0x40, 0x10, 0xEB, 0x0D, 0x01, 0x60, 0xCA, 0x06, 0x75,
  0x01, 0x0D, 0xB0, 0xE0, 0x15, 0x05, 0xC0, 0xC0, 0x15, 0x0C, 0xA0, 0x67, 0x40, 0x10, 0xDC, 0x05,
  0x70, 0x9C, 0x0D, 0x02, 0x40, 0xCA, 0x06, 0x73, 0x03, 0x0D, 0xC0, 0x97, 0x20, 0xAD, 0x07, 0x30,
  0xCA, 0x06, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x82, 0xD6, 0x0C, 0xA0, 0x67, 0x06, 0x0D, 0xD0,
  0xA7, 0x60, 0x9E, 0x00, 0xEA, 0x07, 0x28, 0x31, 0x36, 0xAE, 0xE0, 0x97, 0x71, 0x05, 0x0E, 0xFF,
  0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D,
  0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_supervised_user_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_supervised_user_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_supervisor_account 48x48, 4-bit Alpha,  RLE, 193 bytes.
static const unsigned char ic_round_48_action_supervisor_account_data[] PROGMEM = {
  0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x77, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x77, 0x20, 0xCF,
  0x90, 0xC7, 0x77, 0x71, 0x06, 0xFB, 0x06, 0x77, 0x77, 0x0C, 0xFB, 0x0B, 0x68, 0x44, 0xBE, 0xEB,
  0x47, 0x72, 0x0E, 0xFB, 0x0E, 0x50, 0x8E, 0x07, 0x77, 0x10, 0xEF, 0xB0, 0xE4, 0x04, 0xF9, 0x04,
  0x77, 0x0C, 0xFB, 0x0B, 0x40, 0xBF, 0x90, 0xB7, 0x70, 0x6F, 0xB0, 0x64, 0x0E, 0xF9, 0x0E, 0x77,
  0x10, 0xCF, 0x90, 0xC5, 0x0E, 0xF9, 0x0E, 0x77, 0x10, 0x10, 0xCE, 0x0C, 0x01, 0x50, 0xBF, 0x90,
  0xB7, 0x73, 0x84, 0x6C, 0xEE, 0xC6, 0x70, 0x4F, 0x90, 0x47, 0x77, 0x73, 0x08, 0xE0, 0x77, 0x77,
  0x75, 0x84, 0x4B, 0xEE, 0xB4, 0x80, 0x9B, 0x40, 0x83, 0x37, 0xAC, 0xDA, 0x82, 0xDC, 0xA3, 0x77,
  0x75, 0x81, 0x5A, 0xEF, 0x90, 0xE0, 0x57, 0x77, 0x40, 0x60, 0xDF, 0xB0, 0xE0, 0x36, 0x83, 0x15,
  0x9B, 0xDA, 0x83, 0xDB, 0x95, 0x16, 0x01, 0x0B, 0xFD, 0x05, 0x50, 0x40, 0xBF, 0xD0, 0xB0, 0x44,
  0x0D, 0xFD, 0x0B, 0x40, 0x20, 0xCF, 0xFA, 0x82, 0xC2, 0x09, 0xFE, 0x05, 0x30, 0x20, 0xEF, 0xFC,
  0x81, 0xE2, 0xEF, 0xE0, 0x13, 0x0B, 0xFF, 0xE0, 0xBF, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4,
  0xFF, 0xF9, 0x0D, 0xFE, 0x40, 0xDF, 0xFE, 0x81, 0xD4, 0xDF, 0xD4, 0x04, 0x0D, 0xFF, 0xC0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_supervisor_account() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_round_48_action_supervisor_account_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_support 48x48, 4-bit Alpha,  RLE, 387 bytes.
static const unsigned char ic_round_48_action_support_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xD8, 0x1E, 0x79, 0xFB, 0x81, 0x97, 0xED, 0x0A, 0x74, 0x0A,
  0xD0, 0x72, 0x02, 0xFB, 0x02, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x34, 0x0B, 0xF9, 0x0B,
  0x40, 0x30, 0xEC, 0x09, 0x70, 0x5C, 0x0C, 0x01, 0x50, 0x4F, 0x90, 0x55, 0x01, 0x0C, 0xC0, 0x55,
  0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x0D, 0xE0, 0xE7, 0x01, 0x0E, 0xB0, 0xE0, 0x14, 0x09, 0xC0, 0x37,
  0x10, 0x9E, 0x0A, 0x71, 0x03, 0xC0, 0x93, 0x01, 0xC0, 0x77, 0x04, 0x0C, 0xF9, 0x0C, 0x04, 0x70,
  0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x70, 0x7F, 0xD0, 0x77, 0x0E, 0xB0, 0x82, 0x0D, 0xB0, 0x76, 0x07,
  0xFF, 0x07, 0x60, 0x7B, 0x81, 0xD0, 0x3C, 0x09, 0x02, 0x40, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D,
  0x04, 0x40, 0x20, 0x9C, 0x03, 0x07, 0xE0, 0xB0, 0x42, 0x0C, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0,
  0xC2, 0x05, 0x0B, 0xE0, 0x70, 0xAF, 0x90, 0xD0, 0x9C, 0x02, 0x71, 0x02, 0xC0, 0xA0, 0xEF, 0x90,
  0xA0, 0xCF, 0xE0, 0x87, 0x30, 0x8F, 0xE0, 0xC0, 0xEF, 0xE0, 0x37, 0x30, 0x3F, 0xE0, 0xEF, 0xF7,
  0x5F, 0xFF, 0xF7, 0x5F, 0xF0, 0xEF, 0xE0, 0x37, 0x30, 0x3F, 0xE0, 0xE0, 0xCF, 0xE0, 0x87, 0x30,
  0x8F, 0xE0, 0xC0, 0xAF, 0x90, 0xD0, 0xAC, 0x02, 0x71, 0x02, 0xC0, 0x90, 0xDF, 0x90, 0xA0, 0x7E,
  0x0B, 0x05, 0x20, 0xCB, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x0C, 0x20, 0x40, 0xBE, 0x07, 0x03, 0xC0,
  0x90, 0x24, 0x04, 0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x44, 0x02, 0x09, 0xC8, 0x13, 0x0D, 0xB0,
  0x76, 0x07, 0xFF, 0x07, 0x60, 0x7B, 0x0D, 0x20, 0x8B, 0x0E, 0x70, 0x7F, 0xD0, 0x77, 0x0E, 0xB0,
  0x82, 0x01, 0xC0, 0x77, 0x04, 0x0C, 0xF9, 0x0C, 0x04, 0x70, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x71,
  0x09, 0xE0, 0xA7, 0x10, 0x3C, 0x09, 0x40, 0x10, 0xEB, 0x0E, 0x01, 0x70, 0xDE, 0x0E, 0x70, 0x10,
  0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x50, 0x4F, 0x90, 0x55, 0x01, 0x0C, 0xC0, 0x57, 0x09,
  0xC0, 0xE0, 0x34, 0x0B, 0xF9, 0x0B, 0x40, 0x30, 0xEC, 0x09, 0x72, 0x0A, 0xD0, 0x72, 0x02, 0xFB,
  0x02, 0x20, 0x7D, 0x0A, 0x74, 0x0A, 0xD8, 0x1E, 0x79, 0xFB, 0x81, 0x97, 0xED, 0x0A, 0x76, 0x09,
  0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09,
  0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D,
  0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_support() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_support_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swap_horizontal_circle 48x48, 4-bit Alpha,  RLE, 264 bytes.
static const unsigned char ic_round_48_action_swap_horizontal_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xF9, 0x07, 0xFA, 0x0E,
  0x01, 0x40, 0x9F, 0xFF, 0xA1, 0x07, 0xFA, 0x09, 0x30, 0x1F, 0xFF, 0xB2, 0x07, 0xFA, 0x01, 0x20,
  0x8F, 0xFF, 0xB3, 0x07, 0xF9, 0x08, 0x20, 0xDF, 0xFF, 0xB4, 0x07, 0xF8, 0x1D, 0x03, 0xFF, 0xB7,
  0x60, 0x7F, 0x03, 0x07, 0xFF, 0xB7, 0x70, 0x9E, 0x07, 0x0A, 0xFF, 0xB7, 0x70, 0x9E, 0x0A, 0x0C,
  0xFD, 0x07, 0xC7, 0x60, 0x7F, 0x0C, 0x0E, 0xFC, 0x07, 0x1F, 0xD4, 0x07, 0xF9, 0x0E, 0xFC, 0x07,
  0x2F, 0xD3, 0x07, 0xFF, 0xE0, 0x73, 0xFD, 0x20, 0x7F, 0xC0, 0xEF, 0x90, 0x74, 0xFD, 0x10, 0x7F,
  0xC0, 0xE0, 0xCF, 0x07, 0x76, 0xC0, 0x7F, 0xD0, 0xC0, 0xAE, 0x09, 0x77, 0xFF, 0xB0, 0xA0, 0x7E,
  0x09, 0x77, 0xFF, 0xB0, 0x70, 0x3F, 0x07, 0x76, 0xFF, 0xB8, 0x13, 0x0D, 0xF0, 0x74, 0xFF, 0xFB,
  0x0D, 0x20, 0x8F, 0x90, 0x73, 0xFF, 0xFB, 0x08, 0x20, 0x1F, 0xA0, 0x72, 0xFF, 0xFB, 0x01, 0x30,
  0x9F, 0xA0, 0x71, 0xFF, 0xFA, 0x09, 0x40, 0x10, 0xEF, 0xA0, 0x7F, 0xFF, 0x90, 0xE0, 0x15, 0x05,
  0xFF, 0xFF, 0xC0, 0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40, 0xAF,
  0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73,
  0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83,
  0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swap_horizontal_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_swap_horizontal_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swap_horiz 48x48, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_round_48_action_swap_horiz_data[] PROGMEM = {
  0x77, 0x77, 0x04, 0x05, 0x77, 0x77, 0x68, 0x1E, 0xF8, 0x77, 0x77, 0x50, 0xEA, 0x07, 0x77, 0x77,
  0x40, 0xEB, 0x07, 0x77, 0x77, 0x30, 0xEC, 0x07, 0x77, 0x20, 0x40, 0xDF, 0xFC, 0x07, 0x77, 0x10,
  0xDF, 0xFE, 0x05, 0x77, 0x0D, 0xFF, 0xE0, 0x57, 0x70, 0x40, 0xDF, 0xFC, 0x07, 0x77, 0x77, 0x1D,
  0x07, 0x77, 0x77, 0x2C, 0x07, 0x77, 0x77, 0x3B, 0x07, 0x73, 0x00, 0x57, 0x76, 0x81, 0xEF, 0x77,
  0x38, 0x17, 0xFE, 0x77, 0x60, 0x05, 0x73, 0x07, 0xB7, 0x77, 0x73, 0x07, 0xC7, 0x77, 0x72, 0x07,
  0xD7, 0x77, 0x71, 0x07, 0xFF, 0xC0, 0xD0, 0x47, 0x70, 0x5F, 0xFE, 0x0D, 0x77, 0x05, 0xFF, 0xE0,
  0xD7, 0x71, 0x07, 0xFF, 0xC0, 0xD0, 0x47, 0x72, 0x07, 0xD7, 0x77, 0x73, 0x07, 0xC7, 0x77, 0x74,
  0x07, 0xB7, 0x77, 0x75, 0x81, 0x8F, 0xE7, 0x77, 0x76, 0x06, 0x05, 0x77, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swap_horiz() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 11, 41, 36), Box(0, 0, 47, 47),
      ic_round_48_action_swap_horiz_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swap_vertical_circle 48x48, 4-bit Alpha,  RLE, 261 bytes.
static const unsigned char ic_round_48_action_swap_vertical_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFB, 0x00, 0x9F, 0xFC, 0x09, 0x70, 0x5F, 0xB0, 0x72, 0x07, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFA,
  0x07, 0x40, 0x7F, 0xFB, 0x0E, 0x01, 0x40, 0x9F, 0xA0, 0x76, 0x07, 0xFF, 0xB0, 0x93, 0x01, 0xFA,
  0x07, 0x71, 0x07, 0xFF, 0xB0, 0x12, 0x08, 0xF9, 0x07, 0x73, 0x07, 0xFF, 0xA0, 0x82, 0x0D, 0xF0,
  0x77, 0x50, 0x7F, 0xF9, 0x81, 0xD0, 0x3F, 0xE4, 0xFF, 0xF0, 0x30, 0x7F, 0xE4, 0xFF, 0xF0, 0x70,
  0xAF, 0xE4, 0xFF, 0xF0, 0xA0, 0xCF, 0xE4, 0xFF, 0xF0, 0xC0, 0xEF, 0xE4, 0xC4, 0xFE, 0x0E, 0xFF,
  0x4C, 0x4F, 0xFF, 0xF4, 0xC4, 0xFF, 0x0E, 0xFE, 0x4C, 0x4F, 0xE0, 0xE0, 0xCF, 0xFF, 0x4F, 0xE0,
  0xC0, 0xAF, 0xFF, 0x4F, 0xE0, 0xA0, 0x7F, 0xFF, 0x4F, 0xE0, 0x70, 0x3F, 0xFF, 0x4F, 0xE8, 0x13,
  0x0D, 0xFF, 0x90, 0x77, 0x50, 0x7F, 0x0D, 0x20, 0x8F, 0xFA, 0x07, 0x73, 0x07, 0xF9, 0x08, 0x20,
  0x1F, 0xFB, 0x07, 0x71, 0x07, 0xFA, 0x01, 0x30, 0x9F, 0xFB, 0x07, 0x60, 0x7F, 0xA0, 0x94, 0x01,
  0x0E, 0xFF, 0xB0, 0x74, 0x07, 0xFA, 0x0E, 0x01, 0x50, 0x5F, 0xFC, 0x07, 0x20, 0x7F, 0xB0, 0x57,
  0x09, 0xFF, 0xC0, 0x09, 0xFB, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A,
  0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F,
  0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD,
  0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swap_vertical_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_swap_vertical_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swap_vert 48x48, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_round_48_action_swap_vert_data[] PROGMEM = {
  0x60, 0x05, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x07, 0xC0, 0x77, 0x75, 0x07, 0xE0, 0x77, 0x73,
  0x07, 0xF9, 0x07, 0x77, 0x10, 0x7F, 0xB0, 0x77, 0x60, 0x5F, 0xD0, 0x57, 0x50, 0x50, 0xEF, 0xB0,
  0xE0, 0x57, 0x73, 0xC7, 0x77, 0x1C, 0x77, 0x71, 0xC7, 0x77, 0x1C, 0x77, 0x71, 0xC7, 0x77, 0x1C,
  0x77, 0x71, 0xC7, 0x18, 0x24, 0xDD, 0x47, 0x3C, 0x71, 0x0D, 0xA0, 0xD7, 0x3C, 0x71, 0xC7, 0x3C,
  0x71, 0xC7, 0x3C, 0x71, 0xC7, 0x3C, 0x71, 0xC7, 0x30, 0xDA, 0x0D, 0x71, 0xC7, 0x38, 0x24, 0xDD,
  0x47, 0x1C, 0x77, 0x71, 0xC7, 0x77, 0x1C, 0x77, 0x71, 0xC7, 0x77, 0x1C, 0x77, 0x71, 0xC7, 0x77,
  0x1C, 0x77, 0x30, 0x50, 0xEF, 0xB0, 0xE0, 0x57, 0x50, 0x5F, 0xD0, 0x67, 0x60, 0x7F, 0xB0, 0x87,
  0x71, 0x07, 0xF9, 0x07, 0x77, 0x30, 0x7E, 0x07, 0x77, 0x50, 0x7C, 0x07, 0x77, 0x70, 0x7A, 0x07,
  0x77, 0x72, 0x00, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swap_vert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(11, 6, 36, 41), Box(0, 0, 47, 47),
      ic_round_48_action_swap_vert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_down_alt 48x48, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_48_action_swipe_down_alt_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xFF, 0xC0, 0x50, 0x9F,
  0xFC, 0x09, 0x0D, 0xFF, 0xC0, 0xD0, 0xEF, 0xFC, 0x00, 0xEF, 0xFC, 0x0E, 0x0D, 0xFF, 0xC0, 0xD0,
  0xAF, 0xFC, 0x0A, 0x05, 0xFF, 0xC8, 0x15, 0x0D, 0xFF, 0xA0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08,
  0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x05, 0x0D, 0xF9, 0x0D, 0x05, 0x73, 0x05, 0x0A, 0xC0, 0xA0,
  0x57, 0x7C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x74, 0x82, 0x6E, 0xC3,
  0x1C, 0x18, 0x23, 0xCE, 0x65, 0x01, 0xB0, 0xE0, 0x3C, 0x03, 0x0E, 0xB0, 0x14, 0x01, 0xC0, 0xEC,
  0x0E, 0xC0, 0x15, 0x07, 0xFD, 0x07, 0x70, 0x7F, 0xB0, 0x77, 0x20, 0x7F, 0x90, 0x77, 0x40, 0x7E,
  0x07, 0x76, 0x07, 0xC0, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x73, 0x00, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_down_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 8, 33, 43), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_down_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_down 48x48, 4-bit Alpha,  RLE, 299 bytes.
static const unsigned char ic_round_48_action_swipe_down_data[] PROGMEM = {
  0x73, 0x02, 0x80, 0xC7, 0x08, 0x1C, 0xF9, 0x80, 0xC5, 0x00, 0x6A, 0x0D, 0x80, 0xC4, 0x00, 0x10,
  0xEA, 0x07, 0x80, 0xC4, 0x00, 0x8A, 0x0D, 0x80, 0xC5, 0x00, 0xEA, 0x04, 0x80, 0xC4, 0x00, 0x6A,
  0x0C, 0x68, 0x33, 0xAC, 0x91, 0x77, 0x77, 0x20, 0xCA, 0x06, 0x50, 0x2C, 0x0B, 0x77, 0x77, 0x10,
  0x1B, 0x01, 0x50, 0x8D, 0x05, 0x77, 0x77, 0x04, 0xA0, 0xC6, 0x09, 0xD0, 0xB7, 0x77, 0x70, 0x8A,
  0x08, 0x60, 0x5E, 0x03, 0x77, 0x76, 0x0B, 0xA0, 0x47, 0x0D, 0xD0, 0xA7, 0x77, 0x60, 0xCA, 0x03,
  0x70, 0x7E, 0x01, 0x77, 0x75, 0x0D, 0xA0, 0x17, 0x01, 0x0E, 0xD0, 0x87, 0x77, 0x50, 0xEA, 0x72,
  0x08, 0xD0, 0xE7, 0x77, 0x5B, 0x72, 0x02, 0xE0, 0x67, 0x77, 0x40, 0xEA, 0x01, 0x72, 0x0A, 0xD0,
  0xD7, 0x77, 0x04, 0x06, 0x20, 0xDA, 0x02, 0x20, 0x60, 0x45, 0x03, 0xE0, 0x42, 0x82, 0x12, 0x11,
  0x76, 0x03, 0xA8, 0x1B, 0x0B, 0xA8, 0x14, 0x0B, 0xA0, 0x35, 0x0C, 0xD8, 0x1B, 0x5C, 0xF0, 0xFD,
  0x81, 0xB8, 0x24, 0x03, 0xB0, 0xB0, 0x8A, 0x08, 0x0B, 0xB0, 0x25, 0x05, 0xFF, 0xE0, 0xE0, 0x34,
  0x08, 0xB0, 0xEE, 0x07, 0x70, 0xDF, 0xFE, 0x0D, 0x50, 0x8F, 0x90, 0x77, 0x10, 0x7F, 0xFF, 0x04,
  0x50, 0x8E, 0x07, 0x72, 0x01, 0x0E, 0xFF, 0xE0, 0x86, 0x08, 0xC0, 0x77, 0x40, 0x9F, 0xFE, 0x0D,
  0x70, 0x7A, 0x06, 0x75, 0x02, 0xFF, 0xF0, 0x27, 0x00, 0x17, 0x70, 0xAF, 0xFE, 0x06, 0x77, 0x72,
  0x03, 0xFF, 0xE0, 0xB7, 0x77, 0x30, 0xCF, 0xFD, 0x0E, 0x77, 0x73, 0x05, 0xFF, 0xE0, 0x47, 0x77,
  0x30, 0xDF, 0xFD, 0x08, 0x77, 0x58, 0x31, 0x47, 0xAD, 0xFF, 0xE0, 0xB7, 0x72, 0x81, 0x4A, 0xDF,
  0xFF, 0xC0, 0xA7, 0x71, 0x03, 0xFF, 0xFF, 0x06, 0x77, 0x10, 0x7F, 0xFF, 0xE0, 0xB7, 0x72, 0x02,
  0x0E, 0xFF, 0xFB, 0x0D, 0x06, 0x77, 0x48, 0x11, 0x8E, 0xFF, 0xE0, 0xC0, 0x57, 0x77, 0x20, 0x60,
  0xCF, 0xFA, 0x0A, 0x03, 0x77, 0x76, 0x03, 0x09, 0xFC, 0x81, 0xE8, 0x27, 0x77, 0x73, 0x81, 0x17,
  0xDE, 0x81, 0xD7, 0x18, 0x0C, 0x00, 0x84, 0x4B, 0xEE, 0xB5, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 46, 43), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_left_alt 48x48, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_round_48_action_swipe_left_alt_data[] PROGMEM = {
  0x77, 0x71, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x75, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x74, 0x00,
  0x17, 0x30, 0x8F, 0xD0, 0x87, 0x20, 0x7A, 0x06, 0x71, 0x08, 0xFF, 0x08, 0x70, 0x7B, 0x0E, 0x70,
  0x5F, 0xFA, 0x04, 0x50, 0x7C, 0x0C, 0x70, 0xDF, 0xFA, 0x0D, 0x40, 0x7C, 0x0E, 0x03, 0x60, 0x5F,
  0xFC, 0x05, 0x20, 0x7C, 0x0E, 0x03, 0x70, 0xAF, 0xFC, 0x81, 0x90, 0x7F, 0xFF, 0xFD, 0x0D, 0x01,
  0xFF, 0xFF, 0xE0, 0xE0, 0x1F, 0xFF, 0xFE, 0x81, 0xE0, 0x7F, 0xFF, 0xFD, 0x0D, 0x20, 0x7C, 0x0E,
  0x03, 0x70, 0xAF, 0xFC, 0x09, 0x30, 0x7C, 0x0E, 0x03, 0x60, 0x5F, 0xFC, 0x05, 0x40, 0x7C, 0x0C,
  0x70, 0xDF, 0xFA, 0x0D, 0x60, 0x7B, 0x0E, 0x70, 0x5F, 0xFA, 0x04, 0x70, 0x7A, 0x06, 0x71, 0x08,
  0xFF, 0x08, 0x72, 0x00, 0x17, 0x30, 0x8F, 0xD0, 0x87, 0x77, 0x20, 0x40, 0xDF, 0x90, 0xD0, 0x47,
  0x77, 0x58, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_left_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 14, 39, 33), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_left_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_left 48x48, 4-bit Alpha,  RLE, 271 bytes.
static const unsigned char ic_round_48_action_swipe_left_data[] PROGMEM = {
  0x76, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4D, 0xDB, 0x96, 0x37, 0x77, 0x28, 0x14, 0x9E, 0xFF, 0x81,
  0xD9, 0x37, 0x38, 0x18, 0xE8, 0x50, 0x60, 0xDF, 0xFE, 0x0C, 0x05, 0x71, 0xB3, 0x05, 0x0D, 0xD8,
  0x4E, 0xA6, 0x42, 0x12, 0x84, 0x11, 0x46, 0xAD, 0xD0, 0xC0, 0x26, 0xB1, 0x02, 0x0B, 0xC8, 0x1E,
  0x93, 0x77, 0x81, 0x38, 0xEC, 0x07, 0x5B, 0x05, 0x0E, 0xB0, 0xE0, 0x77, 0x75, 0x81, 0x17, 0xEB,
  0x09, 0x4F, 0x08, 0x01, 0x77, 0x71, 0x02, 0x0B, 0xB0, 0xB3, 0xD0, 0xD0, 0x37, 0x77, 0x50, 0x8B,
  0x09, 0x2C, 0x0B, 0x01, 0x74, 0x82, 0x8D, 0xD8, 0x76, 0x07, 0xB0, 0x51, 0xFA, 0x08, 0x60, 0x8C,
  0x08, 0x76, 0x09, 0xA8, 0x1D, 0x0D, 0xF9, 0x0E, 0x60, 0xDC, 0x0D, 0x77, 0x0D, 0xA8, 0x14, 0x4D,
  0xF0, 0x86, 0xE7, 0x78, 0x13, 0xEB, 0x77, 0x3E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77,
  0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E,
  0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6F, 0x98, 0x1E, 0x92, 0x77, 0x77, 0x1F, 0xC0,
  0x90, 0x27, 0x77, 0x6F, 0xE0, 0x90, 0x27, 0x77, 0x4F, 0xF9, 0x09, 0x02, 0x77, 0x72, 0xFF, 0xB0,
  0x90, 0x17, 0x77, 0xFF, 0xC0, 0xD0, 0x17, 0x76, 0xFF, 0xD0, 0x97, 0x50, 0x17, 0xFF, 0xD0, 0xE7,
  0x38, 0x61, 0xDF, 0xEB, 0x84, 0x12, 0xFF, 0xD0, 0xE7, 0x30, 0x7F, 0x0D, 0x09, 0xFF, 0xD0, 0xC7,
  0x30, 0x6F, 0xFF, 0xF0, 0xA7, 0x40, 0xBF, 0xFF, 0xE0, 0x87, 0x50, 0xCF, 0xFF, 0xD0, 0x67, 0x50,
  0x10, 0xCF, 0xFF, 0xC0, 0x47, 0x60, 0x10, 0xDF, 0xFF, 0xB0, 0x27, 0x70, 0x10, 0xDF, 0xFF, 0xA7,
  0x72, 0x02, 0x0E, 0xFF, 0xF0, 0xD7, 0x73, 0x02, 0x0E, 0xFF, 0xE0, 0xA7, 0x74, 0x03, 0x0E, 0xFF,
  0xD0, 0x57, 0x75, 0x03, 0x0E, 0xFF, 0xB0, 0xB7, 0x77, 0x81, 0x29, 0xDF, 0xE0, 0xD0, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe 48x48, 4-bit Alpha,  RLE, 262 bytes.
static const unsigned char ic_round_48_action_swipe_data[] PROGMEM = {
  0x75, 0x85, 0x14, 0x7A, 0xCD, 0xEA, 0x85, 0xED, 0xCA, 0x74, 0x17, 0x77, 0x81, 0x17, 0xCF, 0xFA,
  0x81, 0xC7, 0x17, 0x72, 0x02, 0x0A, 0xFF, 0xF9, 0x0A, 0x02, 0x70, 0x05, 0x40, 0x9E, 0x84, 0xB8,
  0x53, 0x11, 0x28, 0x41, 0x13, 0x58, 0xBE, 0x09, 0x40, 0x05, 0xA8, 0x27, 0x02, 0xCC, 0x0B, 0x05,
  0x77, 0x20, 0x50, 0xBC, 0x82, 0xC2, 0x07, 0xD0, 0x80, 0xDB, 0x0B, 0x02, 0x77, 0x60, 0x20, 0xBB,
  0x0D, 0x08, 0xFA, 0x0E, 0x05, 0x77, 0x73, 0x05, 0x0E, 0xFD, 0x03, 0x77, 0x75, 0x03, 0xFD, 0x07,
  0x73, 0x82, 0x8D, 0xD8, 0x75, 0x07, 0xFE, 0x07, 0x71, 0x08, 0xC0, 0x87, 0x30, 0x7F, 0xF9, 0x05,
  0x70, 0xDC, 0x0D, 0x72, 0x05, 0xF9, 0x0B, 0xF0, 0x57, 0xE7, 0x20, 0x5F, 0x0B, 0x77, 0x2E, 0x77,
  0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77,
  0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6E, 0x77, 0x77, 0x6F,
  0x90, 0xB0, 0x57, 0x77, 0x72, 0xFB, 0x0D, 0x06, 0x77, 0x77, 0xFD, 0x81, 0xE7, 0x17, 0x77, 0x4F,
  0xF8, 0x1E, 0x81, 0x77, 0x72, 0xFF, 0xB0, 0x90, 0x17, 0x77, 0xFF, 0xC0, 0xD0, 0x17, 0x76, 0xFF,
  0xD0, 0x97, 0x76, 0xFF, 0xD0, 0xE7, 0x48, 0x49, 0xED, 0xA7, 0x33, 0xFF, 0xD0, 0xE7, 0x30, 0x6F,
  0x0C, 0x09, 0xFF, 0xD0, 0xC7, 0x30, 0x8F, 0xFF, 0xF0, 0xA7, 0x30, 0x20, 0xEF, 0xFF, 0xE0, 0x87,
  0x40, 0x40, 0xEF, 0xFF, 0xD0, 0x67, 0x50, 0x40, 0xEF, 0xFF, 0xC0, 0x47, 0x60, 0x40, 0xEF, 0xFF,
  0xB0, 0x27, 0x70, 0x40, 0xEF, 0xFF, 0xA7, 0x72, 0x04, 0x0E, 0xFF, 0xF0, 0xD7, 0x73, 0x04, 0x0E,
  0xFF, 0xE0, 0xA7, 0x74, 0x04, 0x0E, 0xFF, 0xD0, 0x67, 0x75, 0x04, 0x0E, 0xFF, 0xB0, 0xB7, 0x77,
  0x81, 0x2A, 0xEF, 0xE0, 0xD0, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_right_alt 48x48, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_round_48_action_swipe_right_alt_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x77, 0x50, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x20, 0x8F,
  0xD0, 0x87, 0x30, 0x01, 0x72, 0x08, 0xFF, 0x08, 0x71, 0x06, 0xA0, 0x77, 0x04, 0xFF, 0xA0, 0x57,
  0x0E, 0xB0, 0x76, 0x0D, 0xFF, 0xA0, 0xD7, 0x0C, 0xC0, 0x74, 0x05, 0xFF, 0xC0, 0x56, 0x03, 0x0E,
  0xC0, 0x73, 0x09, 0xFF, 0xC0, 0xA7, 0x03, 0x0E, 0xC0, 0x72, 0x0D, 0xFF, 0xFF, 0xD8, 0x17, 0x0E,
  0xFF, 0xFF, 0xE0, 0x10, 0xEF, 0xFF, 0xFE, 0x01, 0x0D, 0xFF, 0xFF, 0xD8, 0x17, 0x09, 0xFF, 0xC0,
  0xA7, 0x03, 0x0E, 0xC0, 0x72, 0x05, 0xFF, 0xC0, 0x56, 0x03, 0x0E, 0xC0, 0x74, 0x0D, 0xFF, 0xA0,
  0xD7, 0x0C, 0xC0, 0x75, 0x04, 0xFF, 0xA0, 0x57, 0x0E, 0xB0, 0x77, 0x08, 0xFF, 0x08, 0x71, 0x06,
  0xA0, 0x77, 0x20, 0x8F, 0xD0, 0x87, 0x30, 0x01, 0x74, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x75,
  0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_right_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 14, 43, 33), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_right_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_right 48x48, 4-bit Alpha,  RLE, 273 bytes.
static const unsigned char ic_round_48_action_swipe_right_data[] PROGMEM = {
  0x76, 0x84, 0x36, 0x9B, 0xDD, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77, 0x28, 0x13, 0x9D, 0xFF, 0x81,
  0xE9, 0x47, 0x74, 0x05, 0x0C, 0xFF, 0xE0, 0xD0, 0x65, 0x81, 0x8E, 0x86, 0x02, 0x0C, 0xD8, 0x4D,
  0xA6, 0x41, 0x12, 0x84, 0x12, 0x46, 0xAE, 0xD0, 0xD0, 0x53, 0xB5, 0x07, 0xC8, 0x1E, 0x83, 0x77,
  0x81, 0x39, 0xEC, 0x0B, 0x02, 0x1B, 0x40, 0x9B, 0x81, 0xE7, 0x17, 0x75, 0x07, 0x0E, 0xB0, 0xE0,
  0x5B, 0x30, 0xBB, 0x0B, 0x02, 0x77, 0x71, 0x01, 0x08, 0xF2, 0x09, 0xB0, 0x87, 0x77, 0x50, 0x30,
  0xDD, 0x10, 0x5B, 0x07, 0x74, 0x82, 0x8D, 0xD8, 0x76, 0x01, 0x0B, 0xC1, 0x0E, 0xA0, 0x97, 0x40,
  0x8C, 0x08, 0x71, 0x08, 0xFA, 0x04, 0xA0, 0xD7, 0x50, 0xDC, 0x0D, 0x71, 0x0E, 0xF9, 0x83, 0xD0,
  0xBE, 0x37, 0x5E, 0x71, 0x08, 0xF0, 0xD0, 0x47, 0x72, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7,
  0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77,
  0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xF9, 0x81, 0xE9, 0x27, 0x77, 0x71,
  0xFC, 0x09, 0x02, 0x77, 0x76, 0xFE, 0x09, 0x02, 0x77, 0x74, 0xFF, 0x90, 0x90, 0x27, 0x77, 0x2F,
  0xFB, 0x09, 0x01, 0x77, 0x7F, 0xFC, 0x0D, 0x01, 0x77, 0x6F, 0xFD, 0x09, 0x75, 0x01, 0x7F, 0xFD,
  0x0E, 0x73, 0x86, 0x1D, 0xFE, 0xB8, 0x41, 0x2F, 0xFD, 0x0E, 0x73, 0x07, 0xF0, 0xD0, 0x9F, 0xFD,
  0x0C, 0x73, 0x06, 0xFF, 0xFF, 0x0A, 0x74, 0x0B, 0xFF, 0xFE, 0x08, 0x75, 0x0C, 0xFF, 0xFD, 0x06,
  0x75, 0x01, 0x0C, 0xFF, 0xFC, 0x04, 0x76, 0x01, 0x0D, 0xFF, 0xFB, 0x02, 0x77, 0x01, 0x0D, 0xFF,
  0xFA, 0x77, 0x20, 0x20, 0xEF, 0xFF, 0x0D, 0x77, 0x30, 0x20, 0xEF, 0xFE, 0x0A, 0x77, 0x40, 0x30,
  0xEF, 0xFD, 0x05, 0x77, 0x50, 0x30, 0xEF, 0xFB, 0x0B, 0x77, 0x78, 0x12, 0x9D, 0xFE, 0x0D, 0x08,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_up_alt 48x48, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_round_48_action_swipe_up_alt_data[] PROGMEM = {
  0x71, 0x82, 0x5D, 0xD4, 0x77, 0x10, 0x5C, 0x05, 0x76, 0x05, 0xE0, 0x57, 0x40, 0x5F, 0x90, 0x57,
  0x20, 0x5F, 0xB0, 0x57, 0x05, 0xFD, 0x05, 0x60, 0xEF, 0xD0, 0xE5, 0x01, 0xC0, 0x5C, 0x05, 0xC0,
  0x15, 0x82, 0x8F, 0xE5, 0x1C, 0x18, 0x25, 0xEF, 0x87, 0x01, 0x3C, 0x30, 0x17, 0x5C, 0x77, 0x2C,
  0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x02, 0x07, 0xC0, 0x70, 0x27, 0x30, 0x20, 0xBF, 0x90,
  0xB0, 0x27, 0x06, 0xFD, 0x06, 0x50, 0x6F, 0xF0, 0x63, 0x03, 0xFF, 0xA0, 0x32, 0x0C, 0xFF, 0xA8,
  0x1C, 0x04, 0xFF, 0xC0, 0x40, 0x9F, 0xFC, 0x09, 0x0D, 0xFF, 0xC0, 0xD0, 0xEF, 0xFC, 0x00, 0xEF,
  0xFC, 0x0E, 0x0D, 0xFF, 0xC0, 0xD0, 0xAF, 0xFC, 0x0A, 0x05, 0xFF, 0xC8, 0x15, 0x0E, 0xFF, 0xA0,
  0xE2, 0x06, 0xFF, 0xA0, 0x63, 0x0A, 0xFF, 0x0A, 0x50, 0xAF, 0xD0, 0xA7, 0x07, 0x0E, 0xF9, 0x0E,
  0x07, 0x72, 0x81, 0x17, 0xCC, 0x81, 0xC7, 0x17, 0x70, 0x01, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_up_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 39), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_up_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_up 48x48, 4-bit Alpha,  RLE, 310 bytes.
static const unsigned char ic_round_48_action_swipe_up_data[] PROGMEM = {
  0x60, 0x01, 0x80, 0xC6, 0x00, 0x7A, 0x07, 0x80, 0xC4, 0x00, 0x7C, 0x07, 0x80, 0xC2, 0x00, 0x7E,
  0x07, 0x80, 0xC0, 0x00, 0x7F, 0x90, 0x77, 0x77, 0x76, 0x07, 0xB0, 0xEE, 0x07, 0x77, 0x77, 0x40,
  0x3B, 0x0B, 0x08, 0xA0, 0x80, 0xBB, 0x03, 0x77, 0x77, 0x30, 0x3A, 0x81, 0xB0, 0xBA, 0x81, 0x50,
  0xBA, 0x03, 0x77, 0x77, 0x40, 0x40, 0x62, 0x0D, 0xA0, 0x22, 0x06, 0x04, 0x38, 0x33, 0xAC, 0x91,
  0x77, 0x77, 0x10, 0xEA, 0x01, 0x60, 0x2C, 0x0B, 0x77, 0x77, 0x1B, 0x70, 0x8D, 0x05, 0x77, 0x77,
  0x0E, 0xA7, 0x09, 0xD0, 0xB7, 0x77, 0x70, 0xDA, 0x01, 0x60, 0x5E, 0x03, 0x77, 0x76, 0x0C, 0xA0,
  0x37, 0x0D, 0xD0, 0xA7, 0x77, 0x60, 0xBA, 0x04, 0x70, 0x7E, 0x01, 0x77, 0x75, 0x08, 0xA0, 0x87,
  0x01, 0x0E, 0xD0, 0x87, 0x77, 0x50, 0x4A, 0x0C, 0x71, 0x08, 0xD0, 0xE7, 0x77, 0x50, 0x1B, 0x01,
  0x70, 0x2E, 0x06, 0x77, 0x75, 0x0C, 0xA0, 0x67, 0x10, 0xAD, 0x0D, 0x77, 0x75, 0x06, 0xA0, 0xD7,
  0x10, 0x3E, 0x04, 0x28, 0x21, 0x21, 0x17, 0x76, 0x0E, 0xA0, 0x47, 0x10, 0xCD, 0x81, 0xB5, 0xCF,
  0x0F, 0xD8, 0x1B, 0x82, 0x74, 0x08, 0xA0, 0xD7, 0x10, 0x5F, 0xFE, 0x0E, 0x03, 0x73, 0x01, 0x0E,
  0xA0, 0x77, 0x10, 0xDF, 0xFE, 0x0D, 0x74, 0x06, 0xA0, 0xD7, 0x10, 0x7F, 0xFF, 0x04, 0x74, 0x81,
  0xCF, 0x97, 0x10, 0x10, 0xEF, 0xFE, 0x08, 0x75, 0x02, 0x73, 0x09, 0xFF, 0xE0, 0xD7, 0x77, 0x20,
  0x2F, 0xFF, 0x02, 0x77, 0x72, 0x0A, 0xFF, 0xE0, 0x67, 0x77, 0x20, 0x3F, 0xFE, 0x0B, 0x77, 0x73,
  0x0C, 0xFF, 0xD0, 0xE7, 0x77, 0x30, 0x5F, 0xFE, 0x04, 0x77, 0x73, 0x0D, 0xFF, 0xD0, 0x87, 0x75,
  0x83, 0x14, 0x7A, 0xDF, 0xFE, 0x0B, 0x77, 0x28, 0x14, 0xAD, 0xFF, 0xFC, 0x0A, 0x77, 0x10, 0x3F,
  0xFF, 0xF0, 0x67, 0x71, 0x07, 0xFF, 0xFE, 0x0B, 0x77, 0x20, 0x20, 0xEF, 0xFF, 0xB0, 0xD0, 0x67,
  0x74, 0x81, 0x18, 0xEF, 0xFE, 0x0C, 0x05, 0x77, 0x72, 0x06, 0x0C, 0xFF, 0xA0, 0xA0, 0x37, 0x77,
  0x60, 0x30, 0x9F, 0xC8, 0x1E, 0x82, 0x77, 0x77, 0x38, 0x11, 0x7D, 0xE8, 0x1D, 0x71, 0x80, 0xC0,
  0x08, 0x44, 0xBE, 0xEB, 0x57, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 46, 43), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_swipe_vertical 48x48, 4-bit Alpha,  RLE, 340 bytes.
static const unsigned char ic_round_48_action_swipe_vertical_data[] PROGMEM = {
  0x20, 0x8F, 0x0D, 0x04, 0x80, 0xC1, 0x00, 0xEF, 0x90, 0xD8, 0x0C, 0x10, 0x08, 0xFA, 0x80, 0xC4,
  0x00, 0x5E, 0x80, 0xC3, 0x00, 0x20, 0xEA, 0x0B, 0xB8, 0x0C, 0x30, 0x0B, 0xA0, 0xD0, 0x1B, 0x80,
  0xC2, 0x00, 0x5B, 0x03, 0x1B, 0x68, 0x33, 0xAC, 0x91, 0x77, 0x76, 0x0D, 0xA0, 0x82, 0xB5, 0x02,
  0xC0, 0xB7, 0x77, 0x50, 0x6A, 0x0E, 0x01, 0x2B, 0x50, 0x8D, 0x05, 0x77, 0x74, 0x0D, 0xA0, 0x73,
  0x81, 0x8E, 0x85, 0x09, 0xD0, 0xB7, 0x77, 0x30, 0x4A, 0x0E, 0x75, 0x05, 0xE0, 0x37, 0x77, 0x20,
  0x9A, 0x09, 0x76, 0x0D, 0xD0, 0xA7, 0x77, 0x20, 0xEA, 0x03, 0x76, 0x07, 0xE0, 0x17, 0x77, 0x03,
  0xA0, 0xE7, 0x70, 0x10, 0xED, 0x08, 0x77, 0x70, 0x6A, 0x0A, 0x77, 0x10, 0x8D, 0x0E, 0x77, 0x70,
  0x9A, 0x06, 0x77, 0x10, 0x2E, 0x06, 0x77, 0x60, 0xBA, 0x04, 0x77, 0x20, 0xAD, 0x0D, 0x77, 0x60,
  0xDA, 0x02, 0x77, 0x20, 0x3E, 0x04, 0x28, 0x21, 0x21, 0x17, 0x60, 0xEA, 0x01, 0x77, 0x30, 0xCD,
  0x81, 0xB5, 0xCF, 0x0F, 0xD8, 0x1B, 0x82, 0x4B, 0x77, 0x40, 0x5F, 0xFE, 0x0E, 0x03, 0x3B, 0x77,
  0x50, 0xDF, 0xFE, 0x0D, 0x30, 0xEA, 0x01, 0x77, 0x40, 0x7F, 0xFF, 0x04, 0x20, 0xDA, 0x02, 0x77,
  0x40, 0x10, 0xEF, 0xFE, 0x08, 0x20, 0xBA, 0x04, 0x77, 0x50, 0x9F, 0xFE, 0x0D, 0x20, 0x9A, 0x06,
  0x77, 0x50, 0x2F, 0xFF, 0x81, 0x20, 0x6A, 0x0A, 0x77, 0x60, 0xAF, 0xFE, 0x81, 0x60, 0x3A, 0x0E,
  0x77, 0x60, 0x3F, 0xFE, 0x0B, 0x20, 0xEA, 0x03, 0x77, 0x60, 0xCF, 0xFD, 0x0E, 0x20, 0x9A, 0x09,
  0x77, 0x60, 0x5F, 0xFE, 0x81, 0x40, 0x4A, 0x0E, 0x77, 0x70, 0xDF, 0xFD, 0x08, 0x20, 0xDA, 0x07,
  0x38, 0x18, 0xE8, 0x72, 0x83, 0x14, 0x7A, 0xDF, 0xFE, 0x0B, 0x20, 0x6A, 0x0E, 0x01, 0x2B, 0x68,
  0x14, 0xAD, 0xFF, 0xFC, 0x0A, 0x30, 0xDA, 0x08, 0x2B, 0x50, 0x3F, 0xFF, 0xF0, 0x63, 0x05, 0xB0,
  0x31, 0xB5, 0x07, 0xFF, 0xFE, 0x0B, 0x50, 0xBA, 0x0D, 0x01, 0xB5, 0x02, 0x0E, 0xFF, 0xFB, 0x0D,
  0x06, 0x60, 0x20, 0xEA, 0x0B, 0xB6, 0x81, 0x18, 0xEF, 0xFE, 0x0C, 0x05, 0x72, 0x05, 0xE7, 0x20,
  0x60, 0xCF, 0xFA, 0x0A, 0x03, 0x71, 0x08, 0xFA, 0x74, 0x03, 0x09, 0xFC, 0x81, 0xE8, 0x27, 0x30,
  0xEF, 0x90, 0xD7, 0x68, 0x11, 0x7D, 0xE8, 0x1D, 0x71, 0x75, 0x08, 0xF0, 0xD0, 0x47, 0x72, 0x84,
  0x4B, 0xEE, 0xB5, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_swipe_vertical() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 46, 43), Box(0, 0, 47, 47),
      ic_round_48_action_swipe_vertical_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_switch_access_shortcut_add 48x48, 4-bit Alpha,  RLE, 323 bytes.
static const unsigned char ic_round_48_action_switch_access_shortcut_add_data[] PROGMEM = {
  0x77, 0x50, 0x5F, 0xC0, 0xB7, 0x77, 0x71, 0x05, 0xFD, 0x77, 0x77, 0x20, 0x7F, 0xC7, 0x77, 0x73,
  0x07, 0xFB, 0x77, 0x77, 0x40, 0x7F, 0xA7, 0x77, 0x75, 0x0B, 0xF9, 0x77, 0x50, 0x03, 0x74, 0x03,
  0xFA, 0x77, 0x50, 0x0A, 0x74, 0x0D, 0xFA, 0x77, 0x40, 0x2A, 0x02, 0x72, 0x09, 0xC0, 0x9D, 0x77,
  0x40, 0x9A, 0x09, 0x71, 0x02, 0xC8, 0x18, 0x07, 0xC7, 0x72, 0x02, 0x09, 0xC0, 0x90, 0x26, 0x0A,
  0xB0, 0xC3, 0x07, 0xB7, 0x70, 0x30, 0xAF, 0x90, 0xA0, 0x33, 0x02, 0xC0, 0x44, 0x07, 0xA7, 0x70,
  0x30, 0xAF, 0x90, 0xA0, 0x33, 0x09, 0xB0, 0xC6, 0x00, 0x57, 0x72, 0x02, 0x09, 0xC0, 0x90, 0x25,
  0x0D, 0xB0, 0x57, 0x77, 0x50, 0x9A, 0x09, 0x60, 0x2B, 0x0E, 0x77, 0x76, 0x02, 0xA0, 0x26, 0x07,
  0xB0, 0xA7, 0x77, 0x70, 0x0A, 0x70, 0xAB, 0x06, 0x77, 0x77, 0x00, 0x37, 0x0B, 0xB0, 0x37, 0x77,
  0x10, 0x03, 0x76, 0x0D, 0xB0, 0x27, 0x77, 0x10, 0x0A, 0x76, 0x0E, 0xB7, 0x77, 0x10, 0x3A, 0x03,
  0x75, 0x0E, 0xB7, 0x58, 0x24, 0xDD, 0x44, 0x03, 0x0A, 0xC0, 0xA0, 0x37, 0x30, 0xDB, 0x01, 0x74,
  0x0D, 0xA0, 0xD4, 0x03, 0x0A, 0xC0, 0xA0, 0x37, 0x30, 0xCB, 0x03, 0x74, 0xC6, 0x03, 0xA0, 0x37,
  0x50, 0xAB, 0x06, 0x74, 0xC7, 0x00, 0xA7, 0x60, 0x6B, 0x0A, 0x70, 0x40, 0xDF, 0x90, 0xD0, 0x43,
  0x00, 0x37, 0x60, 0x3B, 0x0E, 0x70, 0xDF, 0xB0, 0xD7, 0x20, 0x03, 0x71, 0x0D, 0xB0, 0x56, 0x0D,
  0xFB, 0x0D, 0x72, 0x00, 0xA7, 0x10, 0x7B, 0x0D, 0x60, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x10, 0x2A,
  0x02, 0x70, 0x1C, 0x06, 0x72, 0xC7, 0x50, 0x9A, 0x09, 0x71, 0x08, 0xB0, 0xE0, 0x17, 0x1C, 0x73,
  0x02, 0x09, 0xC0, 0x90, 0x26, 0x01, 0x0E, 0xB0, 0xB7, 0x10, 0xDA, 0x0D, 0x71, 0x03, 0x0A, 0xF9,
  0x0A, 0x03, 0x50, 0x6C, 0x09, 0x78, 0x24, 0xDD, 0x47, 0x10, 0x30, 0xAF, 0x90, 0xA0, 0x36, 0x0B,
  0xC0, 0x97, 0x76, 0x02, 0x09, 0xC0, 0x90, 0x27, 0x10, 0x10, 0xDC, 0x0A, 0x77, 0x70, 0x9A, 0x09,
  0x74, 0x02, 0x0E, 0xC0, 0xD0, 0x37, 0x75, 0x02, 0xA0, 0x27, 0x50, 0x20, 0xDD, 0x06, 0x77, 0x50,
  0x0A, 0x77, 0x01, 0x0C, 0xC0, 0xE7, 0x75, 0x00, 0x37, 0x72, 0x08, 0xB0, 0xC8, 0x0C, 0x20, 0x82,
  0x3A, 0xA2, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_switch_access_shortcut_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 47, 42), Box(0, 0, 47, 47),
      ic_round_48_action_switch_access_shortcut_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_switch_access_shortcut 48x48, 4-bit Alpha,  RLE, 271 bytes.
static const unsigned char ic_round_48_action_switch_access_shortcut_data[] PROGMEM = {
  0x77, 0x50, 0x5F, 0xC0, 0xB7, 0x75, 0x05, 0xFD, 0x77, 0x60, 0x7F, 0xC7, 0x77, 0x07, 0xFB, 0x77,
  0x71, 0x07, 0xFA, 0x77, 0x72, 0x0B, 0xF9, 0x72, 0x00, 0x37, 0x40, 0x3F, 0xA7, 0x20, 0x0A, 0x74,
  0x0D, 0xFA, 0x71, 0x02, 0xA0, 0x27, 0x20, 0x9C, 0x09, 0xD7, 0x10, 0x9A, 0x09, 0x71, 0x02, 0xC8,
  0x18, 0x07, 0xC6, 0x02, 0x09, 0xC0, 0x90, 0x26, 0x0A, 0xB0, 0xC3, 0x07, 0xB4, 0x03, 0x0A, 0xF9,
  0x0A, 0x03, 0x30, 0x2C, 0x04, 0x40, 0x7A, 0x40, 0x30, 0xAF, 0x90, 0xA0, 0x33, 0x09, 0xB0, 0xC6,
  0x00, 0x56, 0x02, 0x09, 0xC0, 0x90, 0x25, 0x0D, 0xB0, 0x57, 0x72, 0x09, 0xA0, 0x96, 0x02, 0xB0,
  0xE7, 0x73, 0x02, 0xA0, 0x26, 0x07, 0xB0, 0xA7, 0x74, 0x00, 0xA7, 0x0A, 0xB0, 0x67, 0x74, 0x00,
  0x37, 0x0B, 0xB0, 0x37, 0x50, 0x03, 0x76, 0x0D, 0xB0, 0x27, 0x50, 0x0A, 0x76, 0x0E, 0xB7, 0x50,
  0x3A, 0x03, 0x75, 0x0E, 0xB7, 0x30, 0x30, 0xAC, 0x0A, 0x03, 0x73, 0x0D, 0xB0, 0x17, 0x20, 0x30,
  0xAC, 0x0A, 0x03, 0x73, 0x0C, 0xB0, 0x37, 0x40, 0x3A, 0x03, 0x75, 0x0A, 0xB0, 0x67, 0x50, 0x0A,
  0x76, 0x06, 0xB0, 0xA7, 0x50, 0x03, 0x76, 0x03, 0xB0, 0xE7, 0x74, 0x00, 0x37, 0x10, 0xDB, 0x05,
  0x77, 0x30, 0x0A, 0x71, 0x07, 0xB0, 0xD7, 0x72, 0x02, 0xA0, 0x27, 0x01, 0xC0, 0x67, 0x71, 0x09,
  0xA0, 0x97, 0x10, 0x8B, 0x0E, 0x01, 0x75, 0x02, 0x09, 0xC0, 0x90, 0x26, 0x01, 0x0E, 0xB0, 0xB7,
  0x30, 0x30, 0xAF, 0x90, 0xA0, 0x35, 0x06, 0xC0, 0x97, 0x20, 0x30, 0xAF, 0x90, 0xA0, 0x36, 0x0B,
  0xC0, 0x97, 0x30, 0x20, 0x9C, 0x09, 0x02, 0x71, 0x01, 0x0D, 0xC0, 0xA7, 0x40, 0x9A, 0x09, 0x74,
  0x02, 0x0E, 0xC0, 0xD0, 0x37, 0x20, 0x2A, 0x02, 0x75, 0x02, 0x0D, 0xD0, 0x67, 0x20, 0x0A, 0x77,
  0x01, 0x0C, 0xC0, 0xE7, 0x20, 0x03, 0x77, 0x20, 0x8B, 0x0C, 0x77, 0x77, 0x82, 0x3A, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_switch_access_shortcut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 37, 42), Box(0, 0, 47, 47),
      ic_round_48_action_switch_access_shortcut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_sync_alt 48x48, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_round_48_action_sync_alt_data[] PROGMEM = {
  0x77, 0x77, 0x40, 0x05, 0x80, 0xC2, 0x0A, 0x07, 0x80, 0xC1, 0x0B, 0x07, 0x80, 0xC0, 0x0C, 0x07,
  0x77, 0x77, 0x7D, 0x07, 0x40, 0x40, 0xDF, 0xFF, 0xFE, 0x07, 0x30, 0xD8, 0x0C, 0x0F, 0x05, 0x20,
  0xD8, 0x0C, 0x0F, 0x05, 0x20, 0x40, 0xDF, 0xFF, 0xFE, 0x07, 0x77, 0x77, 0x5D, 0x07, 0x77, 0x77,
  0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0, 0x0A, 0x07, 0x80, 0xC1, 0x00, 0x05, 0x80, 0x9B,
  0x00, 0x00, 0x58, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x00, 0x07, 0xB7, 0x77, 0x77, 0x07, 0xC7, 0x77,
  0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xFF, 0xFF, 0xE0, 0xD0, 0x42, 0x05, 0x80, 0xC0, 0xF0, 0xD2,
  0x05, 0x80, 0xC0, 0xF0, 0xD3, 0x07, 0xFF, 0xFF, 0xE0, 0xD0, 0x44, 0x07, 0xD7, 0x77, 0x77, 0x07,
  0xC8, 0x0C, 0x00, 0x07, 0xB8, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x20, 0x00, 0x57, 0x77, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_sync_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 43, 38), Box(0, 0, 47, 47),
      ic_round_48_action_sync_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_system_update_alt 48x48, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_round_48_action_system_update_alt_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFB, 0x0D, 0x04, 0x48, 0x24, 0xDD, 0x44, 0x04, 0x0D, 0xFB, 0x84, 0xDA, 0x10,
  0x1E, 0xFE, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDF, 0xE8, 0x1E, 0x1A, 0xFF, 0x0D, 0x4C, 0x40, 0xDF,
  0xF0, 0xA0, 0xDF, 0xE0, 0xD0, 0x44, 0xC4, 0x04, 0x0D, 0xFE, 0x0D, 0xC0, 0xA0, 0x17, 0x7C, 0x77,
  0x01, 0x0A, 0xF9, 0x01, 0x77, 0x1C, 0x77, 0x10, 0x1F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C,
  0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9,
  0x77, 0x2C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97, 0x72, 0xC7,
  0x72, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97,
  0x40, 0x5F, 0xC0, 0xE0, 0x57, 0x4F, 0x97, 0x40, 0x5F, 0xD0, 0x57, 0x4F, 0x97, 0x50, 0x7F, 0xB0,
  0x77, 0x5F, 0x97, 0x60, 0x7F, 0x90, 0x77, 0x6F, 0x97, 0x70, 0x7E, 0x07, 0x77, 0xF9, 0x77, 0x10,
  0x7C, 0x07, 0x77, 0x1F, 0x97, 0x72, 0x07, 0xA0, 0x77, 0x72, 0xF9, 0x77, 0x30, 0x05, 0x77, 0x3F,
  0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x90, 0x17,
  0x77, 0x76, 0x01, 0xF9, 0x0A, 0x01, 0x77, 0x77, 0x40, 0x10, 0xAC, 0x0D, 0x80, 0xC6, 0xF0, 0xD0,
  0xA8, 0x0C, 0x6F, 0x81, 0xA1, 0xE8, 0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC0, 0xF8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_system_update_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_system_update_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_table_view 48x48, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_round_48_action_table_view_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x71, 0x0A,
  0xFF, 0xFD, 0x0A, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71,
  0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC5, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x11, 0xC4, 0x01,
  0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0xC4, 0x0A, 0xFF, 0xFD, 0x0A, 0xC4, 0x0D, 0xFF, 0xFD, 0x0D, 0xC4,
  0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xF9, 0x4C, 0x01, 0x77, 0x40, 0x1F, 0x94, 0xC0, 0x17, 0x74,
  0x01, 0xF9, 0x4C, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBF, 0x94, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4,
  0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4,
  0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4C, 0x0D, 0xD2, 0xFF, 0xFF, 0x0A, 0xD2, 0xFF, 0xFF, 0x01,
  0x0E, 0xC2, 0xFF, 0xFF, 0x18, 0x11, 0xAD, 0xA2, 0xFF, 0xFF, 0x71, 0xC4, 0xC4, 0xC4, 0xC7, 0x1C,
  0x4C, 0x4C, 0x4C, 0x71, 0xC4, 0xC4, 0xC4, 0xC7, 0x1C, 0x4C, 0x4C, 0x4C, 0x71, 0x0D, 0xFF, 0xFD,
  0x0D, 0x71, 0x0A, 0xFF, 0xFD, 0x0A, 0x71, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x72, 0x81, 0x1A,
  0xDF, 0xFE, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_table_view() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_table_view_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_tab 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_round_48_action_tab_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x0B, 0x01, 0x77, 0x4F, 0xFF, 0xB0, 0x17, 0x75, 0xFF,
  0xFB, 0x77, 0x6F, 0xFF, 0xB7, 0x76, 0xFF, 0xFB, 0x77, 0x6F, 0xFF, 0xB7, 0x76, 0xFF, 0xFB, 0x77,
  0x60, 0xDF, 0xFF, 0xA7, 0x76, 0x04, 0x0D, 0xFF, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9,
  0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98,
  0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00,
  0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x1F, 0x90, 0xB0, 0x17,
  0x77, 0x74, 0x01, 0x0B, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80,
  0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_tab() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_tab_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_tab_unselected 48x48, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_round_48_action_tab_unselected_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x4C, 0x4C, 0x4F, 0xFA, 0x84, 0xDA, 0x10, 0x1E, 0xA4, 0xC4, 0xC4, 0xFF, 0xC8,
  0x1E, 0x1A, 0xB4, 0xC4, 0xC4, 0xFF, 0xD0, 0xA0, 0xDB, 0x4C, 0x4C, 0x4F, 0xFD, 0x0D, 0x77, 0x73,
  0xFF, 0xE7, 0x77, 0x3F, 0xFE, 0x77, 0x73, 0xFF, 0xE7, 0x77, 0x3F, 0xFF, 0xB7, 0x76, 0xFF, 0xFB,
  0x77, 0x6F, 0xFF, 0xB7, 0x76, 0x0D, 0xFF, 0xFA, 0x77, 0x60, 0x40, 0xDF, 0xFC, 0x80, 0xAD, 0x40,
  0xC8, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0C, 0x80, 0xAD,
  0x40, 0xC8, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0C, 0x80,
  0xAD, 0x40, 0x0D, 0xB4, 0xC4, 0xC4, 0xC4, 0xC4, 0xB0, 0xD0, 0xAB, 0x4C, 0x4C, 0x4C, 0x4C, 0x4B,
  0x81, 0xA1, 0xEA, 0x4C, 0x4C, 0x4C, 0x4C, 0x4A, 0x84, 0xE1, 0x01, 0xAD, 0x4C, 0x4C, 0x4C, 0x4C,
  0x48, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_tab_unselected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_tab_unselected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_task_alt 48x48, 4-bit Alpha,  RLE, 389 bytes.
static const unsigned char ic_round_48_action_task_alt_data[] PROGMEM = {
  0x77, 0x89, 0x22, 0x6A, 0xCD, 0xFE, 0xDC, 0x97, 0x37, 0x77, 0x48, 0x11, 0x7D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x77, 0x74, 0x05, 0x0E, 0xFF, 0xE0, 0x17, 0x72, 0x09, 0xE8,
  0x3E, 0xA6, 0x31, 0x28, 0x31, 0x36, 0xAE, 0xC0, 0x15, 0x81, 0x78, 0x17, 0x0A, 0xD0, 0xD0, 0x67,
  0x58, 0x26, 0xCE, 0x65, 0x0B, 0xA0, 0xD6, 0x0B, 0xD0, 0x77, 0x77, 0x10, 0xBC, 0x01, 0x40, 0x8C,
  0x0D, 0x02, 0x77, 0x71, 0x0B, 0xC0, 0xB4, 0x05, 0xC0, 0xC0, 0x17, 0x77, 0x10, 0xBC, 0x0C, 0x01,
  0x30, 0x10, 0xEB, 0x0D, 0x01, 0x77, 0x71, 0x0B, 0xC0, 0xC0, 0x14, 0x09, 0xC0, 0x37, 0x77, 0x10,
  0xBC, 0x0C, 0x01, 0x40, 0x1C, 0x07, 0x77, 0x71, 0x0B, 0xC0, 0xC0, 0x15, 0x07, 0xB0, 0xD7, 0x77,
  0x10, 0xBC, 0x0C, 0x01, 0x60, 0xEB, 0x06, 0x77, 0x70, 0xBC, 0x0C, 0x01, 0x60, 0x3B, 0x0E, 0x01,
  0x77, 0x60, 0xBC, 0x0C, 0x01, 0x70, 0x6B, 0x0A, 0x77, 0x60, 0xBC, 0x0C, 0x01, 0x48, 0x35, 0xDA,
  0x1A, 0xB0, 0x67, 0x75, 0x0B, 0xC0, 0xC0, 0x14, 0x01, 0xB0, 0x90, 0xCB, 0x03, 0x77, 0x40, 0xBC,
  0x0C, 0x01, 0x50, 0x2B, 0x0C, 0x0E, 0xB0, 0x16, 0x03, 0x73, 0x0B, 0xC0, 0xC0, 0x16, 0x01, 0xB0,
  0x0E, 0xB5, 0x83, 0x1D, 0xFE, 0x37, 0x0B, 0xC0, 0xC0, 0x17, 0x1C, 0x0E, 0xB5, 0x06, 0xB0, 0xE0,
  0x35, 0x0B, 0xC0, 0xC0, 0x17, 0x2C, 0x0E, 0xB0, 0x14, 0x04, 0xC0, 0xE0, 0x33, 0x0B, 0xC0, 0xC0,
  0x17, 0x20, 0x1B, 0x0E, 0x0C, 0xB0, 0x35, 0x08, 0xC8, 0x2E, 0x30, 0xBC, 0x0C, 0x01, 0x73, 0x03,
  0xB0, 0xD0, 0xAB, 0x06, 0x60, 0x8C, 0x0E, 0x0C, 0xC0, 0xC0, 0x17, 0x40, 0x6B, 0x0A, 0x07, 0xB0,
  0xA7, 0x08, 0xF9, 0x0C, 0x01, 0x75, 0x0B, 0xB0, 0x70, 0x3B, 0x0E, 0x71, 0x08, 0xE0, 0xC0, 0x17,
  0x50, 0x1C, 0x81, 0x30, 0xDB, 0x06, 0x71, 0x08, 0xC0, 0xC0, 0x17, 0x60, 0x7B, 0x0D, 0x20, 0x7B,
  0x0D, 0x72, 0x07, 0xA0, 0xC0, 0x17, 0x60, 0x10, 0xEB, 0x07, 0x20, 0x1C, 0x07, 0x72, 0x03, 0x04,
  0x77, 0x10, 0x9B, 0x0E, 0x01, 0x30, 0x8C, 0x03, 0x77, 0x73, 0x04, 0xC0, 0x84, 0x01, 0x0E, 0xB0,
  0xD0, 0x17, 0x77, 0x10, 0x20, 0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60, 0x20, 0xDC,
  0x04, 0x70, 0x8C, 0x0D, 0x03, 0x77, 0x40, 0x40, 0xEC, 0x08, 0x72, 0x0A, 0xD0, 0x77, 0x72, 0x08,
  0xD0, 0xA7, 0x40, 0xAD, 0x0D, 0x06, 0x75, 0x07, 0x0E, 0xD0, 0xA7, 0x60, 0x9E, 0x83, 0xEA, 0x63,
  0x12, 0x82, 0x13, 0x6A, 0xF0, 0x87, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x47, 0x73, 0x01, 0x08,
  0xFF, 0xC0, 0x87, 0x77, 0x81, 0x17, 0xDF, 0xD8, 0x1D, 0x71, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA,
  0x83, 0xDD, 0xA6, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_task_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_task_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_terminal 48x48, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_round_48_action_terminal_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0A, 0xC0, 0xF7, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x96, 0x00, 0x17, 0x77, 0x3F, 0x95, 0x06, 0xA0, 0x77, 0x77, 0x2F, 0x95, 0x0E, 0xB0, 0x77, 0x77,
  0x1F, 0x95, 0x0C, 0xC0, 0x77, 0x77, 0xF9, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x6F, 0x96, 0x03, 0x0E,
  0xC0, 0x77, 0x75, 0xF9, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x4F, 0x97, 0x10, 0x30, 0xEC, 0x01, 0x77,
  0x3F, 0x97, 0x10, 0x30, 0xEC, 0x01, 0x77, 0x3F, 0x97, 0x03, 0x0E, 0xC0, 0x77, 0x74, 0xF9, 0x60,
  0x30, 0xEC, 0x07, 0x77, 0x5F, 0x95, 0x03, 0x0E, 0xC0, 0x77, 0x76, 0xF9, 0x50, 0xCC, 0x07, 0x50,
  0x40, 0xDF, 0x90, 0xD0, 0x44, 0xF9, 0x50, 0xEB, 0x07, 0x60, 0xDF, 0xB0, 0xD4, 0xF9, 0x50, 0x6A,
  0x07, 0x70, 0xDF, 0xB0, 0xD4, 0xF9, 0x60, 0x01, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1,
  0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_terminal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_terminal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_text_rotate_up 48x48, 4-bit Alpha,  RLE, 196 bytes.
static const unsigned char ic_round_48_action_text_rotate_up_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x05, 0x77, 0x77, 0x40, 0x8A, 0x07, 0x77, 0x77, 0x20, 0x8C, 0x07, 0x77, 0x77,
  0x08, 0xE0, 0x77, 0x77, 0x50, 0x5F, 0x90, 0x57, 0x77, 0x40, 0x5F, 0x90, 0x57, 0x77, 0x7C, 0x77,
  0x77, 0x3C, 0x77, 0x68, 0x31, 0x7D, 0xD4, 0x6C, 0x77, 0x40, 0x20, 0x9C, 0x0D, 0x6C, 0x77, 0x20,
  0x50, 0xBE, 0x0D, 0x6C, 0x76, 0x81, 0x17, 0xDF, 0x0C, 0x03, 0x6C, 0x74, 0x81, 0x29, 0xEF, 0x09,
  0x03, 0x71, 0xC7, 0x20, 0x40, 0xBF, 0xA0, 0x97, 0x3C, 0x70, 0x60, 0xDE, 0x0C, 0x06, 0xB0, 0x97,
  0x3C, 0x48, 0x12, 0x8E, 0xD8, 0x1E, 0x83, 0x2B, 0x09, 0x73, 0xC3, 0x05, 0xE0, 0xA0, 0x45, 0xB0,
  0x97, 0x3C, 0x30, 0xEB, 0x81, 0xC6, 0x17, 0xB0, 0x97, 0x3C, 0x30, 0xEB, 0x81, 0xC6, 0x17, 0xB0,
  0x97, 0x3C, 0x30, 0x6E, 0x0A, 0x04, 0x5B, 0x09, 0x73, 0xC4, 0x81, 0x29, 0xED, 0x81, 0xE8, 0x32,
  0xB0, 0x97, 0x3C, 0x68, 0x11, 0x6D, 0xE0, 0xC0, 0x6B, 0x09, 0x73, 0xC7, 0x20, 0x40, 0xBF, 0xA0,
  0x97, 0x3C, 0x74, 0x02, 0x09, 0xF9, 0x09, 0x03, 0x71, 0xC7, 0x68, 0x11, 0x7D, 0xF0, 0xC0, 0x36,
  0xC7, 0x72, 0x05, 0x0C, 0xE0, 0xD6, 0xC7, 0x74, 0x03, 0x09, 0xC0, 0xD6, 0xC7, 0x76, 0x83, 0x17,
  0xDE, 0x46, 0xC7, 0x77, 0x73, 0xC7, 0x77, 0x73, 0xC7, 0x77, 0x73, 0x0D, 0xA0, 0xD7, 0x77, 0x73,
  0x82, 0x4D, 0xD4, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_text_rotate_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 40, 39), Box(0, 0, 47, 47),
      ic_round_48_action_text_rotate_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_text_rotate_vertical 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_48_action_text_rotate_vertical_data[] PROGMEM = {
  0x38, 0x24, 0xDD, 0x47, 0x77, 0x71, 0x0D, 0xA0, 0xD7, 0x77, 0x71, 0xC7, 0x78, 0x26, 0xEE, 0x67,
  0x4C, 0x76, 0x02, 0xC0, 0x27, 0x3C, 0x76, 0x09, 0xC0, 0x97, 0x3C, 0x75, 0x01, 0x0E, 0xC0, 0xE0,
  0x17, 0x2C, 0x75, 0x06, 0xA0, 0x0C, 0xA0, 0x77, 0x2C, 0x75, 0x0D, 0xA0, 0x06, 0xA0, 0xD7, 0x2C,
  0x74, 0x04, 0xB0, 0x01, 0xB0, 0x57, 0x1C, 0x74, 0x0B, 0xA0, 0xA2, 0x0A, 0xA0, 0xB7, 0x1C, 0x73,
  0x02, 0xB0, 0x42, 0x04, 0xB0, 0x37, 0xC7, 0x30, 0x9A, 0x0E, 0x40, 0xEA, 0x09, 0x7C, 0x72, 0x01,
  0x0E, 0xA0, 0x84, 0x08, 0xB0, 0x16, 0xC7, 0x20, 0x7B, 0x03, 0x40, 0x3B, 0x07, 0x6C, 0x72, 0x0D,
  0xA0, 0xC6, 0x0C, 0xA0, 0xE6, 0xC7, 0x10, 0x5B, 0x06, 0x60, 0x6B, 0x05, 0x5C, 0x71, 0x0B, 0xFF,
  0x0C, 0x5C, 0x70, 0x3F, 0xFA, 0x03, 0x4C, 0x70, 0x9F, 0xFA, 0x0A, 0x4C, 0x60, 0x1C, 0x80, 0x69,
  0x0E, 0xB0, 0x13, 0xC6, 0x07, 0xB0, 0xA7, 0x30, 0x9B, 0x08, 0x3C, 0x60, 0xDB, 0x03, 0x73, 0x03,
  0xB0, 0xD3, 0xC6, 0x0D, 0xA0, 0xC7, 0x50, 0xCA, 0x0E, 0x3C, 0x68, 0x24, 0xDD, 0x37, 0x58, 0x23,
  0xDD, 0x53, 0xC7, 0x77, 0x71, 0xC7, 0x77, 0x50, 0x5F, 0x90, 0x57, 0x77, 0x20, 0x5F, 0x90, 0x57,
  0x77, 0x30, 0x7E, 0x07, 0x77, 0x75, 0x07, 0xC0, 0x77, 0x77, 0x70, 0x7A, 0x07, 0x77, 0x77, 0x20,
  0x05, 0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_text_rotate_vertical() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 8, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_text_rotate_vertical_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_text_rotation_angledown 48x48, 4-bit Alpha,  RLE, 240 bytes.
static const unsigned char ic_round_48_action_text_rotation_angledown_data[] PROGMEM = {
  0x77, 0x77, 0x18, 0x23, 0x77, 0x17, 0x77, 0x68, 0x11, 0x6C, 0xB0, 0xC7, 0x77, 0x48, 0x13, 0x9E,
  0xE0, 0x27, 0x77, 0x81, 0x16, 0xDF, 0x90, 0xE7, 0x76, 0x04, 0x0A, 0xE8, 0x1D, 0x69, 0xA0, 0x97,
  0x73, 0x81, 0x17, 0xDE, 0x82, 0xC4, 0x01, 0xB0, 0x37, 0x71, 0x04, 0x0A, 0xF0, 0xA0, 0x33, 0x08,
  0xA0, 0xC7, 0x68, 0x11, 0x7D, 0xF0, 0x90, 0x25, 0x0E, 0xA0, 0x67, 0x60, 0xDF, 0x90, 0x46, 0x06,
  0xB0, 0x17, 0x50, 0x4F, 0xA0, 0xE0, 0x35, 0x0D, 0xA0, 0x97, 0x60, 0x10, 0xEA, 0x82, 0xC5, 0x2D,
  0xB0, 0xE0, 0x33, 0x05, 0xB0, 0x35, 0x02, 0x01, 0x78, 0x12, 0x53, 0x30, 0x10, 0xDB, 0x0E, 0x03,
  0x20, 0xCA, 0x0D, 0x58, 0x2A, 0xFE, 0x57, 0x60, 0x10, 0xDB, 0x81, 0xE3, 0x4B, 0x07, 0x40, 0x2C,
  0x05, 0x76, 0x01, 0x0D, 0xB0, 0xE0, 0xCB, 0x01, 0x50, 0xEC, 0x05, 0x76, 0x01, 0x0D, 0xE0, 0xA6,
  0x04, 0xD0, 0x57, 0x60, 0x10, 0xDD, 0x04, 0x70, 0x4D, 0x05, 0x76, 0x01, 0x0D, 0xB0, 0xD7, 0x20,
  0x4D, 0x05, 0x76, 0x09, 0xB0, 0x77, 0x30, 0x4D, 0x05, 0x74, 0x01, 0x0E, 0xB0, 0x17, 0x40, 0x4D,
  0x05, 0x73, 0x07, 0xB0, 0xA7, 0x60, 0x4D, 0x05, 0x72, 0x0C, 0xB0, 0x47, 0x70, 0x4D, 0x05, 0x71,
  0x0B, 0xA0, 0xD7, 0x72, 0x04, 0xD0, 0x57, 0x82, 0x2C, 0xC3, 0x77, 0x30, 0x4D, 0x05, 0x77, 0x77,
  0x04, 0xD0, 0x57, 0x77, 0x70, 0x4D, 0x05, 0x77, 0x77, 0x04, 0xD0, 0x57, 0x77, 0x70, 0x4D, 0x05,
  0x77, 0x77, 0x04, 0xD8, 0x25, 0x1D, 0xC7, 0x77, 0x40, 0x4D, 0x0D, 0xA7, 0x77, 0x50, 0x4F, 0x77,
  0x76, 0x04, 0xE7, 0x77, 0x60, 0x10, 0xDD, 0x77, 0x76, 0x0D, 0xE7, 0x77, 0x60, 0xCD, 0x0B, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_text_rotation_angledown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 7, 39, 41), Box(0, 0, 47, 47),
      ic_round_48_action_text_rotation_angledown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_text_rotation_angleup 48x48, 4-bit Alpha,  RLE, 241 bytes.
static const unsigned char ic_round_48_action_text_rotation_angleup_data[] PROGMEM = {
  0x20, 0x17, 0x77, 0x75, 0x83, 0xBF, 0xE9, 0x37, 0x77, 0x71, 0x07, 0xD8, 0x1C, 0x61, 0x77, 0x75,
  0x07, 0xF8, 0x1E, 0x93, 0x77, 0x73, 0x03, 0xB0, 0x9E, 0x81, 0xD6, 0x17, 0x77, 0x10, 0xCA, 0x82,
  0x61, 0x8E, 0xE0, 0xA0, 0x37, 0x76, 0x06, 0xA0, 0xD3, 0x06, 0x0D, 0xE8, 0x1D, 0x71, 0x77, 0x30,
  0x1B, 0x04, 0x40, 0x50, 0xCF, 0x0A, 0x04, 0x77, 0x20, 0x9A, 0x0B, 0x60, 0x40, 0xCF, 0x0D, 0x03,
  0x77, 0x03, 0xB0, 0x35, 0x03, 0x0E, 0xF9, 0x0C, 0x77, 0x10, 0xDA, 0x0A, 0x40, 0x30, 0xEB, 0x81,
  0xD9, 0xEB, 0x0B, 0x50, 0xCD, 0x0B, 0x30, 0x7B, 0x02, 0x20, 0x30, 0xEB, 0x86, 0xD1, 0x01, 0x6B,
  0xB2, 0x50, 0xDE, 0x30, 0x1B, 0x82, 0x90, 0x3E, 0xB0, 0xD0, 0x17, 0x50, 0x10, 0xDD, 0x40, 0xAB,
  0x04, 0x0E, 0xB0, 0xD0, 0x17, 0x60, 0x5E, 0x40, 0x4F, 0x0D, 0x01, 0x76, 0x05, 0xF5, 0x0D, 0xD0,
  0xD0, 0x17, 0x60, 0x5D, 0x0D, 0xA5, 0x07, 0xC0, 0xD0, 0x17, 0x60, 0x5D, 0x82, 0x51, 0xCC, 0x50,
  0x1C, 0x02, 0x76, 0x05, 0xD0, 0x57, 0x30, 0xAB, 0x06, 0x75, 0x05, 0xD0, 0x57, 0x40, 0x4B, 0x0C,
  0x74, 0x05, 0xD0, 0x57, 0x60, 0xDB, 0x03, 0x72, 0x05, 0xD0, 0x57, 0x70, 0x7B, 0x06, 0x71, 0x05,
  0xD0, 0x57, 0x71, 0x83, 0x1D, 0xFE, 0x27, 0x05, 0xD0, 0x57, 0x73, 0x81, 0x14, 0x17, 0x05, 0xD0,
  0x57, 0x77, 0x60, 0x5D, 0x05, 0x77, 0x76, 0x05, 0xD0, 0x57, 0x77, 0x60, 0x5D, 0x05, 0x77, 0x76,
  0x05, 0xD0, 0x57, 0x77, 0x60, 0x5D, 0x05, 0x77, 0x76, 0x05, 0xD0, 0x57, 0x77, 0x60, 0x10, 0xEC,
  0x05, 0x77, 0x77, 0x02, 0xC0, 0x57, 0x77, 0x72, 0x82, 0x9F, 0xE5, 0x77, 0x77, 0x40, 0x20, 0x17,
  0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_text_rotation_angleup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 8, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_text_rotation_angleup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_text_rotation_down 48x48, 4-bit Alpha,  RLE, 196 bytes.
static const unsigned char ic_round_48_action_text_rotation_down_data[] PROGMEM = {
  0x38, 0x24, 0xDD, 0x47, 0x77, 0x73, 0x0D, 0xA0, 0xD7, 0x77, 0x73, 0xC7, 0x77, 0x73, 0xC7, 0x77,
  0x73, 0xC6, 0x83, 0x4E, 0xD7, 0x17, 0x76, 0xC6, 0x0D, 0xC0, 0x90, 0x37, 0x74, 0xC6, 0x0D, 0xE0,
  0xC0, 0x57, 0x72, 0xC6, 0x03, 0x0C, 0xF8, 0x1D, 0x71, 0x76, 0xC7, 0x10, 0x30, 0x9F, 0x90, 0x90,
  0x27, 0x4C, 0x73, 0x09, 0xFA, 0x0B, 0x04, 0x72, 0xC7, 0x30, 0x9B, 0x06, 0x0C, 0xE8, 0x1D, 0x61,
  0x6C, 0x73, 0x09, 0xB2, 0x81, 0x38, 0xED, 0x81, 0xE9, 0x24, 0xC7, 0x30, 0x9B, 0x50, 0x40, 0xAE,
  0x06, 0x3C, 0x73, 0x09, 0xB7, 0x81, 0x16, 0xCB, 0x0E, 0x3C, 0x73, 0x09, 0xB7, 0x81, 0x16, 0xCB,
  0x0E, 0x3C, 0x73, 0x09, 0xB5, 0x04, 0x0A, 0xE0, 0x63, 0xC7, 0x30, 0x9B, 0x28, 0x13, 0x8E, 0xD8,
  0x1E, 0x92, 0x4C, 0x73, 0x09, 0xB0, 0x60, 0xCE, 0x81, 0xD6, 0x16, 0xC7, 0x30, 0x9F, 0xA0, 0xB0,
  0x47, 0x2C, 0x71, 0x03, 0x09, 0xF9, 0x09, 0x02, 0x74, 0xC6, 0x03, 0x0C, 0xF8, 0x1D, 0x71, 0x76,
  0xC6, 0x0D, 0xE0, 0xC0, 0x57, 0x72, 0xC6, 0x0D, 0xC0, 0x90, 0x37, 0x74, 0xC6, 0x83, 0x5E, 0xD7,
  0x17, 0x76, 0xC7, 0x77, 0x73, 0xC7, 0x77, 0x70, 0x5F, 0x90, 0x57, 0x77, 0x40, 0x5F, 0x90, 0x57,
  0x77, 0x50, 0x7E, 0x07, 0x77, 0x77, 0x07, 0xC0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x74,
  0x00, 0x57, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_text_rotation_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 8, 41, 39), Box(0, 0, 47, 47),
      ic_round_48_action_text_rotation_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_text_rotation_none 48x48, 4-bit Alpha,  RLE, 184 bytes.
static const unsigned char ic_round_48_action_text_rotation_none_data[] PROGMEM = {
  0x75, 0x82, 0x6E, 0xE6, 0x77, 0x76, 0x02, 0xC0, 0x27, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x74, 0x01,
  0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x6A, 0x00, 0xCA, 0x06, 0x77, 0x73, 0x0D, 0xA0, 0x06, 0xA0,
  0xD7, 0x77, 0x20, 0x4B, 0x00, 0x1B, 0x04, 0x77, 0x71, 0x0B, 0xA0, 0xA2, 0x0A, 0xA0, 0xB7, 0x77,
  0x02, 0xB0, 0x42, 0x04, 0xB0, 0x27, 0x76, 0x09, 0xA0, 0xE4, 0x0E, 0xA0, 0x97, 0x75, 0x01, 0x0E,
  0xA0, 0x84, 0x08, 0xA0, 0xE0, 0x17, 0x74, 0x07, 0xB0, 0x34, 0x03, 0xB0, 0x77, 0x74, 0x0D, 0xA0,
  0xC6, 0x0C, 0xA0, 0xD7, 0x73, 0x05, 0xB0, 0x66, 0x06, 0xB0, 0x57, 0x72, 0x0B, 0xFF, 0x0B, 0x77,
  0x10, 0x3F, 0xFA, 0x03, 0x77, 0x09, 0xFF, 0xA0, 0x97, 0x60, 0x1C, 0x80, 0x69, 0x0E, 0xB0, 0x17,
  0x50, 0x7B, 0x09, 0x73, 0x09, 0xB0, 0x77, 0x50, 0xDB, 0x03, 0x73, 0x03, 0xB0, 0xD7, 0x50, 0xDA,
  0x0C, 0x75, 0x0C, 0xA0, 0xE7, 0x58, 0x24, 0xDD, 0x37, 0x58, 0x23, 0xDD, 0x58, 0x09, 0xF6, 0x00,
  0x05, 0x77, 0x77, 0x2A, 0x07, 0x77, 0x77, 0x1B, 0x07, 0x20, 0x40, 0xDF, 0xFF, 0xF8, 0x17, 0x0D,
  0xFF, 0xFF, 0xA0, 0x50, 0xDF, 0xFF, 0xFA, 0x81, 0x54, 0xDF, 0xFF, 0xF0, 0x77, 0x77, 0x6B, 0x07,
  0x77, 0x77, 0xA0, 0x77, 0x77, 0x71, 0x00, 0x54,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_text_rotation_none() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 41, 40), Box(0, 0, 47, 47),
      ic_round_48_action_text_rotation_none_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_theaters 48x48, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_48_action_theaters_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0x40, 0xDF,
  0xF0, 0xD4, 0x0D, 0xA0, 0xDC, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0x80, 0xA8, 0x4F, 0x4F, 0xFA,
  0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0x80, 0xA8, 0x4F, 0x4F, 0xFA,
  0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0x80, 0xA8, 0x4F, 0x4F, 0xFA,
  0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0x80, 0xA8, 0x4F, 0x4F, 0xFA,
  0x4F, 0x94, 0xFF, 0xA4, 0xC0, 0xDA, 0x0D, 0x40, 0xDF, 0xF0, 0xD4, 0x0D, 0xA8, 0x3D, 0x4D, 0xD4,
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x82, 0x4D, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_theaters() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 39, 41), Box(0, 0, 47, 47),
      ic_round_48_action_theaters_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_thumb_down_off_alt 48x48, 4-bit Alpha,  RLE, 294 bytes.
static const unsigned char ic_round_48_action_thumb_down_off_alt_data[] PROGMEM = {
  0x71, 0x81, 0x2A, 0xEF, 0xFC, 0x81, 0xD9, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x71, 0x02, 0x0E, 0xFF,
  0xF9, 0x0E, 0x01, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x70, 0xAF, 0xFF, 0xB0, 0x94, 0x0A, 0xE0, 0xA6,
  0x02, 0xFF, 0xFC, 0x0D, 0x40, 0xDE, 0x0D, 0x60, 0x8B, 0x0C, 0x77, 0x4C, 0x4F, 0x96, 0x0E, 0xB0,
  0x57, 0x74, 0xC4, 0xF9, 0x50, 0x6B, 0x0E, 0x77, 0x5C, 0x4F, 0x95, 0x0C, 0xB0, 0x77, 0x75, 0xC4,
  0xF9, 0x40, 0x4C, 0x01, 0x77, 0x5C, 0x4F, 0x94, 0x0A, 0xB0, 0xA7, 0x76, 0xC4, 0xF9, 0x30, 0x2C,
  0x03, 0x77, 0x6C, 0x4F, 0x93, 0x08, 0xB0, 0xC7, 0x77, 0xC4, 0xF9, 0x30, 0xEB, 0x05, 0x77, 0x7C,
  0x4F, 0x92, 0x06, 0xB0, 0xE7, 0x77, 0x1C, 0x4F, 0x92, 0x0C, 0xB0, 0x77, 0x77, 0x1C, 0x4F, 0x91,
  0x04, 0xC0, 0x17, 0x77, 0x1C, 0x4F, 0x91, 0x0A, 0xB0, 0xA7, 0x77, 0x2C, 0x4F, 0x90, 0x1C, 0x03,
  0x77, 0x72, 0xC4, 0xF9, 0x06, 0xB0, 0xC7, 0x77, 0x3C, 0x4F, 0x90, 0x9B, 0x06, 0x77, 0x73, 0xC4,
  0xF9, 0x09, 0xB0, 0x67, 0x77, 0x3C, 0x40, 0xDE, 0x0D, 0x06, 0xB0, 0xE0, 0x37, 0x77, 0x2C, 0x40,
  0xAE, 0x0A, 0x01, 0xFF, 0xF0, 0x66, 0xC4, 0x01, 0x0E, 0xC8, 0x2E, 0x10, 0x7F, 0xFE, 0x03, 0x6C,
  0x58, 0x41, 0xAD, 0xDA, 0x13, 0x08, 0xFF, 0xD6, 0x08, 0xB0, 0xD7, 0x71, 0x81, 0x4A, 0xDF, 0xF9,
  0x0C, 0x50, 0x8C, 0x09, 0x77, 0x77, 0x10, 0x7B, 0x09, 0x40, 0x8C, 0x0E, 0x02, 0x77, 0x77, 0x10,
  0xAB, 0x06, 0x30, 0x8C, 0x0E, 0x03, 0x77, 0x77, 0x20, 0xDB, 0x02, 0x20, 0x8C, 0x0E, 0x03, 0x77,
  0x77, 0x20, 0x1B, 0x0E, 0x20, 0x8C, 0x0E, 0x03, 0x77, 0x77, 0x30, 0x4B, 0x81, 0xB0, 0x8C, 0x0E,
  0x03, 0x77, 0x77, 0x40, 0x8B, 0x00, 0x8C, 0x0E, 0x03, 0x77, 0x77, 0x50, 0xBB, 0x0C, 0xC0, 0xE0,
  0x37, 0x77, 0x76, 0x0E, 0xF0, 0xE0, 0x37, 0x77, 0x76, 0x02, 0xF0, 0xE0, 0x37, 0x77, 0x77, 0x04,
  0xE0, 0xE0, 0x38, 0x0C, 0x00, 0x03, 0xD0, 0xE0, 0x38, 0x0C, 0x20, 0x0B, 0xB0, 0xE0, 0x38, 0x0C,
  0x40, 0x82, 0x7B, 0x81, 0x77, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_thumb_down_off_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 45, 44), Box(0, 0, 47, 47),
      ic_round_48_action_thumb_down_off_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_thumb_down 48x48, 4-bit Alpha,  RLE, 247 bytes.
static const unsigned char ic_round_48_action_thumb_down_data[] PROGMEM = {
  0x71, 0x81, 0x2A, 0xEF, 0xFC, 0x81, 0xD9, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x71, 0x02, 0x0E, 0xFF,
  0xF9, 0x0E, 0x01, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x70, 0xAF, 0xFF, 0xB0, 0x94, 0x0A, 0xE0, 0xA6,
  0x02, 0xFF, 0xFC, 0x0D, 0x40, 0xDE, 0x0D, 0x60, 0x8F, 0xFF, 0xD4, 0xF9, 0x60, 0xEF, 0xFF, 0xD4,
  0xF9, 0x50, 0x6F, 0xFF, 0xE4, 0xF9, 0x50, 0xCF, 0xFF, 0xE4, 0xF9, 0x40, 0x4F, 0xFF, 0xF4, 0xF9,
  0x40, 0xAF, 0xFF, 0xF4, 0xF9, 0x30, 0x2F, 0xFF, 0xF9, 0x4F, 0x93, 0x08, 0xFF, 0xFF, 0x94, 0xF9,
  0x30, 0xEF, 0xFF, 0xF9, 0x4F, 0x92, 0x06, 0xFF, 0xFF, 0xA4, 0xF9, 0x20, 0xCF, 0xFF, 0xFA, 0x4F,
  0x91, 0x04, 0xFF, 0xFF, 0xB4, 0xF9, 0x10, 0xAF, 0xFF, 0xFB, 0x4F, 0x90, 0x1F, 0xFF, 0xFC, 0x4F,
  0x90, 0x6F, 0xFF, 0xFC, 0x4F, 0x90, 0x9F, 0xFF, 0xFC, 0x4F, 0x90, 0x9F, 0xFF, 0xFC, 0x40, 0xDE,
  0x0D, 0x06, 0xFF, 0xFF, 0xC4, 0x0A, 0xE0, 0xA0, 0x1F, 0xFF, 0xFC, 0x40, 0x10, 0xEC, 0x82, 0xE1,
  0x07, 0xFF, 0xFF, 0xB5, 0x84, 0x1A, 0xDD, 0xA1, 0x30, 0x8F, 0xFF, 0xF9, 0x0D, 0x77, 0x18, 0x14,
  0xAD, 0xFF, 0xFD, 0x09, 0x77, 0x77, 0x10, 0x7F, 0xE0, 0xE0, 0x27, 0x77, 0x71, 0x0A, 0xFD, 0x0E,
  0x03, 0x77, 0x77, 0x20, 0xDF, 0xC0, 0xE0, 0x37, 0x77, 0x72, 0x01, 0xFC, 0x0E, 0x03, 0x77, 0x77,
  0x30, 0x4F, 0xB0, 0xE0, 0x37, 0x77, 0x74, 0x08, 0xFA, 0x0E, 0x03, 0x77, 0x77, 0x50, 0xBF, 0x90,
  0xE0, 0x37, 0x77, 0x76, 0x0E, 0xF0, 0xE0, 0x37, 0x77, 0x76, 0x02, 0xF0, 0xE0, 0x37, 0x77, 0x77,
  0x04, 0xE0, 0xE0, 0x38, 0x0C, 0x00, 0x03, 0xD0, 0xE0, 0x38, 0x0C, 0x20, 0x0B, 0xB0, 0xE0, 0x38,
  0x0C, 0x40, 0x82, 0x7B, 0x91, 0x77, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_thumb_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 45, 44), Box(0, 0, 47, 47),
      ic_round_48_action_thumb_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_thumbs_up_down 48x48, 4-bit Alpha,  RLE, 262 bytes.
static const unsigned char ic_round_48_action_thumbs_up_down_data[] PROGMEM = {
  0x72, 0x82, 0x9F, 0xD3, 0x80, 0xC7, 0x00, 0xAB, 0x0C, 0x80, 0xC6, 0x00, 0xAC, 0x0E, 0x80, 0xC5,
  0x00, 0xAD, 0x0C, 0x80, 0xC4, 0x00, 0xAE, 0x08, 0x80, 0xC3, 0x00, 0xAF, 0x05, 0x80, 0xC2, 0x00,
  0xAF, 0x90, 0x28, 0x0C, 0x10, 0x0A, 0xF9, 0x0E, 0x80, 0xC1, 0x00, 0xAF, 0xA0, 0xB8, 0x0C, 0x00,
  0x07, 0xFF, 0xD8, 0x1E, 0xB3, 0x77, 0x74, 0x0C, 0xFF, 0xF9, 0x03, 0x77, 0x73, 0xFF, 0xFA, 0x0C,
  0x77, 0x73, 0xFF, 0xFB, 0x77, 0x73, 0xFF, 0xFB, 0x01, 0x77, 0x72, 0xFF, 0xFA, 0x0C, 0x77, 0x73,
  0xFF, 0xFA, 0x06, 0x77, 0x73, 0xFF, 0xF9, 0x0E, 0x77, 0x74, 0xFF, 0xF9, 0x08, 0x77, 0x74, 0xFF,
  0xF9, 0x02, 0x77, 0x74, 0xFF, 0xF0, 0xA7, 0x81, 0x19, 0xEF, 0xD8, 0x1D, 0xA1, 0x1F, 0xFF, 0x04,
  0x70, 0xDF, 0xFA, 0x0E, 0x01, 0xFF, 0xE0, 0xC7, 0x08, 0xFF, 0xC0, 0x9F, 0xFE, 0x06, 0x70, 0xEF,
  0xFC, 0x00, 0xDF, 0xFC, 0x0E, 0x70, 0x6F, 0xFE, 0x0A, 0xFF, 0xC0, 0x87, 0x0C, 0xFF, 0xE0, 0x10,
  0xEF, 0xFA, 0x0D, 0x70, 0x4F, 0xFF, 0x18, 0x11, 0xAD, 0xFD, 0x81, 0xE9, 0x17, 0x0A, 0xFF, 0xF7,
  0x77, 0x40, 0x2F, 0xFF, 0x97, 0x77, 0x40, 0x8F, 0xFF, 0x97, 0x77, 0x40, 0xEF, 0xFF, 0x97, 0x77,
  0x30, 0x6F, 0xFF, 0xA7, 0x77, 0x30, 0xCF, 0xFF, 0xA7, 0x77, 0x20, 0x1F, 0xFF, 0xB7, 0x77, 0x20,
  0x1F, 0xFF, 0xB7, 0x77, 0x30, 0xCF, 0xFF, 0x90, 0xE7, 0x77, 0x30, 0x3F, 0xFF, 0x90, 0xC7, 0x77,
  0x48, 0x13, 0xBE, 0xFF, 0xD0, 0x78, 0x0C, 0x00, 0x0B, 0xFA, 0x0A, 0x80, 0xC1, 0x00, 0xEF, 0x90,
  0xA8, 0x0C, 0x10, 0x02, 0xF9, 0x0A, 0x80, 0xC2, 0x00, 0x5F, 0x0A, 0x80, 0xC3, 0x00, 0x8E, 0x0A,
  0x80, 0xC4, 0x00, 0xCD, 0x0A, 0x80, 0xC5, 0x00, 0xEC, 0x0A, 0x80, 0xC6, 0x00, 0xCB, 0x0A, 0x80,
  0xC7, 0x08, 0x23, 0xDF, 0x97, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_thumbs_up_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 47, 46), Box(0, 0, 47, 47),
      ic_round_48_action_thumbs_up_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_thumb_up_off_alt 48x48, 4-bit Alpha,  RLE, 247 bytes.
static const unsigned char ic_round_48_action_thumb_up_off_alt_data[] PROGMEM = {
  0x77, 0x73, 0x82, 0x19, 0xB7, 0x80, 0xC4, 0x00, 0x30, 0xEB, 0x0B, 0x80, 0xC2, 0x00, 0x30, 0xED,
  0x03, 0x80, 0xC0, 0x00, 0x30, 0xEE, 0x04, 0x77, 0x77, 0x70, 0x30, 0xEF, 0x02, 0x77, 0x77, 0x60,
  0x30, 0xEF, 0x0E, 0x77, 0x77, 0x60, 0x30, 0xEF, 0x90, 0xB7, 0x77, 0x75, 0x03, 0x0E, 0xFA, 0x08,
  0x77, 0x77, 0x40, 0x30, 0xEF, 0xB0, 0x47, 0x77, 0x73, 0x03, 0x0E, 0xFC, 0x01, 0x77, 0x77, 0x20,
  0x30, 0xEF, 0xC0, 0xD7, 0x77, 0x72, 0x03, 0x0E, 0xFD, 0x0A, 0x77, 0x77, 0x10, 0x20, 0xEF, 0xE0,
  0x77, 0x77, 0x71, 0x0A, 0xFF, 0xFD, 0x81, 0xDA, 0x47, 0x71, 0x0D, 0xFF, 0xFF, 0x90, 0x83, 0x84,
  0x1A, 0xDD, 0xA1, 0x5F, 0xFF, 0xFB, 0x82, 0x70, 0x1E, 0xC0, 0xE0, 0x14, 0xFF, 0xFF, 0xC0, 0x10,
  0xAE, 0x0A, 0x4F, 0xFF, 0xFC, 0x06, 0x0D, 0xE0, 0xD4, 0xFF, 0xFF, 0xC0, 0x9F, 0x94, 0xFF, 0xFF,
  0xC0, 0x9F, 0x94, 0xFF, 0xFF, 0xC0, 0x6F, 0x94, 0xFF, 0xFF, 0xC0, 0x2F, 0x94, 0xFF, 0xFF, 0xB0,
  0xB1, 0xF9, 0x4F, 0xFF, 0xFB, 0x04, 0x1F, 0x94, 0xFF, 0xFF, 0xA0, 0xD2, 0xF9, 0x4F, 0xFF, 0xFA,
  0x06, 0x2F, 0x94, 0xFF, 0xFF, 0x90, 0xE3, 0xF9, 0x4F, 0xFF, 0xF9, 0x08, 0x3F, 0x94, 0xFF, 0xFF,
  0x90, 0x23, 0xF9, 0x4F, 0xFF, 0xF0, 0xB4, 0xF9, 0x4F, 0xFF, 0xF0, 0x44, 0xF9, 0x4F, 0xFF, 0xE0,
  0xD5, 0xF9, 0x4F, 0xFF, 0xE0, 0x65, 0xF9, 0x4F, 0xFF, 0xD0, 0xE6, 0xF9, 0x4F, 0xFF, 0xD0, 0x86,
  0x0D, 0xE0, 0xD4, 0x0D, 0xFF, 0xFC, 0x02, 0x60, 0xAE, 0x0A, 0x40, 0xAF, 0xFF, 0xB0, 0xA7, 0x01,
  0x0E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xFF, 0xF9, 0x0E, 0x02, 0x71, 0x84, 0x1A, 0xDD, 0xA1, 0x68,
  0x11, 0xAD, 0xFF, 0xC8, 0x1E, 0xA2, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_thumb_up_off_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 46, 41), Box(0, 0, 47, 47),
      ic_round_48_action_thumb_up_off_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_thumb_up 48x48, 4-bit Alpha,  RLE, 247 bytes.
static const unsigned char ic_round_48_action_thumb_up_data[] PROGMEM = {
  0x77, 0x73, 0x82, 0x19, 0xB7, 0x80, 0xC4, 0x00, 0x30, 0xEB, 0x0B, 0x80, 0xC2, 0x00, 0x30, 0xED,
  0x03, 0x80, 0xC0, 0x00, 0x30, 0xEE, 0x04, 0x77, 0x77, 0x70, 0x30, 0xEF, 0x02, 0x77, 0x77, 0x60,
  0x30, 0xEF, 0x0E, 0x77, 0x77, 0x60, 0x30, 0xEF, 0x90, 0xB7, 0x77, 0x75, 0x03, 0x0E, 0xFA, 0x08,
  0x77, 0x77, 0x40, 0x30, 0xEF, 0xB0, 0x47, 0x77, 0x73, 0x03, 0x0E, 0xFC, 0x01, 0x77, 0x77, 0x20,
  0x30, 0xEF, 0xC0, 0xD7, 0x77, 0x72, 0x03, 0x0E, 0xFD, 0x0A, 0x77, 0x77, 0x10, 0x20, 0xEF, 0xE0,
  0x77, 0x77, 0x71, 0x0A, 0xFF, 0xFD, 0x81, 0xDA, 0x47, 0x71, 0x0D, 0xFF, 0xFF, 0x90, 0x83, 0x84,
  0x1A, 0xDD, 0xA1, 0x5F, 0xFF, 0xFB, 0x82, 0x70, 0x1E, 0xC0, 0xE0, 0x14, 0xFF, 0xFF, 0xC0, 0x10,
  0xAE, 0x0A, 0x4F, 0xFF, 0xFC, 0x06, 0x0D, 0xE0, 0xD4, 0xFF, 0xFF, 0xC0, 0x9F, 0x94, 0xFF, 0xFF,
  0xC0, 0x9F, 0x94, 0xFF, 0xFF, 0xC0, 0x6F, 0x94, 0xFF, 0xFF, 0xC0, 0x2F, 0x94, 0xFF, 0xFF, 0xB0,
  0xB1, 0xF9, 0x4F, 0xFF, 0xFB, 0x04, 0x1F, 0x94, 0xFF, 0xFF, 0xA0, 0xD2, 0xF9, 0x4F, 0xFF, 0xFA,
  0x06, 0x2F, 0x94, 0xFF, 0xFF, 0x90, 0xE3, 0xF9, 0x4F, 0xFF, 0xF9, 0x08, 0x3F, 0x94, 0xFF, 0xFF,
  0x90, 0x23, 0xF9, 0x4F, 0xFF, 0xF0, 0xB4, 0xF9, 0x4F, 0xFF, 0xF0, 0x44, 0xF9, 0x4F, 0xFF, 0xE0,
  0xD5, 0xF9, 0x4F, 0xFF, 0xE0, 0x65, 0xF9, 0x4F, 0xFF, 0xD0, 0xE6, 0xF9, 0x4F, 0xFF, 0xD0, 0x86,
  0x0D, 0xE0, 0xD4, 0x0D, 0xFF, 0xFC, 0x02, 0x60, 0xAE, 0x0A, 0x40, 0xAF, 0xFF, 0xB0, 0xA7, 0x01,
  0x0E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xFF, 0xF9, 0x0E, 0x02, 0x71, 0x84, 0x1A, 0xDD, 0xA1, 0x68,
  0x11, 0xAD, 0xFF, 0xC8, 0x1E, 0xA2, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_thumb_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 46, 41), Box(0, 0, 47, 47),
      ic_round_48_action_thumb_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_timeline 48x48, 4-bit Alpha,  RLE, 193 bytes.
static const unsigned char ic_round_48_action_timeline_data[] PROGMEM = {
  0x80, 0xC1, 0x08, 0x41, 0xAD, 0xDA, 0x18, 0x0C, 0x10, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x71, 0x84,
  0x1A, 0xDD, 0xA1, 0x77, 0x10, 0xAE, 0x0A, 0x77, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x70, 0xDE, 0x0D,
  0x77, 0x0A, 0xE0, 0xA7, 0x70, 0xEE, 0x0D, 0x77, 0x0D, 0xE0, 0xD7, 0x60, 0x5F, 0x0A, 0x77, 0x0E,
  0xE0, 0xE7, 0x50, 0x5F, 0x0E, 0x01, 0x76, 0x05, 0xF9, 0x05, 0x73, 0x05, 0xD8, 0x2E, 0xDA, 0x17,
  0x60, 0x5F, 0xB0, 0x57, 0x10, 0x5D, 0x05, 0x77, 0x20, 0x5D, 0x00, 0xED, 0x05, 0x60, 0x5D, 0x05,
  0x77, 0x20, 0x5D, 0x05, 0x20, 0x5D, 0x05, 0x40, 0x5D, 0x05, 0x77, 0x20, 0x5D, 0x05, 0x40, 0x5D,
  0x05, 0x20, 0x5D, 0x05, 0x77, 0x20, 0x5D, 0x05, 0x60, 0x5D, 0x00, 0xED, 0x05, 0x77, 0x20, 0x5D,
  0x05, 0x71, 0x05, 0xFB, 0x05, 0x77, 0x20, 0x5D, 0x05, 0x73, 0x05, 0xF9, 0x05, 0x77, 0x20, 0x5D,
  0x05, 0x75, 0x0E, 0xE0, 0xE7, 0x68, 0x21, 0xAD, 0xED, 0x05, 0x76, 0x0D, 0xE0, 0xD7, 0x50, 0x10,
  0xEF, 0x05, 0x77, 0x0A, 0xE0, 0xA7, 0x50, 0xAF, 0x05, 0x77, 0x10, 0x10, 0xEC, 0x0E, 0x01, 0x75,
  0x0D, 0xE0, 0xE7, 0x73, 0x84, 0x1A, 0xDD, 0xA1, 0x76, 0x0D, 0xE0, 0xD8, 0x0C, 0x00, 0x0A, 0xE0,
  0xA8, 0x0C, 0x00, 0x01, 0x0E, 0xC0, 0xE0, 0x18, 0x0C, 0x10, 0x84, 0x1A, 0xDD, 0xA1, 0x80, 0xC1,
  0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_timeline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 12, 45, 35), Box(0, 0, 47, 47),
      ic_round_48_action_timeline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_tips_and_updates 48x48, 4-bit Alpha,  RLE, 274 bytes.
static const unsigned char ic_round_48_action_tips_and_updates_data[] PROGMEM = {
  0x77, 0x77, 0x60, 0x03, 0x80, 0xC7, 0x00, 0x0A, 0x80, 0xC6, 0x00, 0x2A, 0x02, 0x80, 0xC5, 0x00,
  0x9A, 0x09, 0x77, 0x48, 0x90, 0x38, 0xBD, 0xEE, 0xDB, 0x83, 0x74, 0x02, 0x09, 0xC0, 0x90, 0x27,
  0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x03, 0x0A, 0xF9, 0x0A, 0x03, 0x73, 0x05, 0x0D, 0xFF, 0x0D,
  0x05, 0x50, 0x30, 0xAF, 0x90, 0xA0, 0x37, 0x20, 0x7F, 0xFC, 0x07, 0x60, 0x20, 0x9C, 0x09, 0x02,
  0x73, 0x0A, 0xFF, 0xE0, 0xA7, 0x09, 0xA0, 0x97, 0x40, 0x8F, 0xFF, 0x90, 0x86, 0x02, 0xA0, 0x27,
  0x30, 0x5F, 0xFF, 0xB0, 0x56, 0x00, 0xA7, 0x40, 0xDF, 0xFF, 0xB0, 0xD6, 0x00, 0x37, 0x30, 0x7F,
  0xFF, 0xD0, 0x77, 0x40, 0x03, 0x40, 0xEF, 0xFF, 0xD0, 0xE7, 0x40, 0x0A, 0x30, 0x3F, 0xFF, 0xF0,
  0x37, 0x20, 0x3A, 0x03, 0x20, 0x8F, 0xFF, 0xF0, 0x87, 0x03, 0x0A, 0xC8, 0x1A, 0x3B, 0xFF, 0xFF,
  0x0B, 0x70, 0x30, 0xAC, 0x81, 0xA3, 0xDF, 0xFF, 0xF0, 0xD7, 0x20, 0x3A, 0x03, 0x20, 0xEF, 0xFF,
  0xF0, 0xE7, 0x30, 0x0A, 0x30, 0xEF, 0xFF, 0xF0, 0xE7, 0x30, 0x03, 0x30, 0xDF, 0xFF, 0xF0, 0xD7,
  0x71, 0x0C, 0xFF, 0xFF, 0x0C, 0x77, 0x10, 0x8F, 0xFF, 0xF0, 0x87, 0x71, 0x04, 0xFF, 0xFF, 0x04,
  0x77, 0x20, 0xEF, 0xFF, 0xD0, 0xE7, 0x73, 0x07, 0xFF, 0xFD, 0x07, 0x77, 0x40, 0xDF, 0xFF, 0xB0,
  0xD7, 0x75, 0x04, 0xFF, 0xFB, 0x04, 0x77, 0x60, 0x8F, 0xFF, 0x90, 0x87, 0x77, 0x10, 0x9F, 0xFE,
  0x09, 0x77, 0x73, 0x08, 0xFF, 0xC0, 0x87, 0x77, 0x50, 0x40, 0xEF, 0xF0, 0xE0, 0x48, 0x09, 0xE2,
  0x00, 0x40, 0xDF, 0xD0, 0xD0, 0x47, 0x77, 0x71, 0x0D, 0xFF, 0x0D, 0x77, 0x77, 0x10, 0xDF, 0xF0,
  0xD7, 0x77, 0x71, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x80, 0x9E, 0x70, 0x0D, 0xE0, 0xD8, 0x0C, 0x10,
  0x0A, 0xE0, 0xA8, 0x0C, 0x10, 0x01, 0x0E, 0xC0, 0xE0, 0x18, 0x0C, 0x20, 0x84, 0x1A, 0xDD, 0xA1,
  0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_tips_and_updates() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 47, 43), Box(0, 0, 47, 47),
      ic_round_48_action_tips_and_updates_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_toc 48x48, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_48_action_toc_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x4C, 0x0D, 0xFF, 0xFD, 0x0D, 0x4C, 0x0D, 0xFF, 0xFD, 0x0D,
  0x4C, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x4C, 0x80, 0xA9, 0x40, 0x04, 0x0D, 0xFF, 0xFB, 0x0D,
  0x04, 0x4C, 0x0D, 0xFF, 0xFD, 0x0D, 0x4C, 0x0D, 0xFF, 0xFD, 0x0D, 0x4C, 0x04, 0x0D, 0xFF, 0xFB,
  0x0D, 0x04, 0x4C, 0x80, 0xA9, 0x40, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x4C, 0x0D, 0xFF, 0xFD,
  0x0D, 0x4C, 0x0D, 0xFF, 0xFD, 0x0D, 0x4C, 0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x4C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_toc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 14, 41, 33), Box(0, 0, 47, 47),
      ic_round_48_action_toc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_today 48x48, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_round_48_action_today_data[] PROGMEM = {
  0x68, 0x24, 0xDD, 0x47, 0x72, 0x82, 0x4D, 0xD4, 0x75, 0x0D, 0xA0, 0xD7, 0x72, 0x0D, 0xA0, 0xD7,
  0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x4D, 0xA1, 0x01, 0xEF,
  0xFF, 0xFC, 0x81, 0xE1, 0x9F, 0xFF, 0xFE, 0x0A, 0x0D, 0xFF, 0xFF, 0xE0, 0xD8, 0x0B, 0xB0, 0xF7,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x94, 0x04, 0x0D, 0xE0, 0xD0,
  0x47, 0x7F, 0x94, 0x0D, 0xF9, 0x0D, 0x77, 0xF9, 0x4F, 0xB7, 0x7F, 0x94, 0xFB, 0x77, 0xF9, 0x4F,
  0xB7, 0x7F, 0x94, 0xFB, 0x77, 0xF9, 0x4F, 0xB7, 0x7F, 0x94, 0xFB, 0x77, 0xF9, 0x40, 0xDF, 0x90,
  0xD7, 0x7F, 0x94, 0x04, 0x0D, 0xE0, 0xD0, 0x47, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x90, 0x17, 0x77, 0x50, 0x1F,
  0x90, 0xB0, 0x17, 0x77, 0x30, 0x10, 0xBC, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81,
  0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_today() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_today_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_token 48x48, 4-bit Alpha,  RLE, 281 bytes.
static const unsigned char ic_round_48_action_token_data[] PROGMEM = {
  0x77, 0x28, 0x21, 0x55, 0x17, 0x77, 0x72, 0x01, 0x09, 0xC0, 0x90, 0x17, 0x77, 0x60, 0x70, 0xEE,
  0x0E, 0x07, 0x77, 0x73, 0x05, 0x0D, 0xFB, 0x0D, 0x06, 0x77, 0x60, 0x40, 0xCF, 0xF0, 0xC0, 0x47,
  0x72, 0x02, 0x0B, 0xFF, 0xC0, 0xB0, 0x27, 0x50, 0x10, 0x9F, 0xFF, 0x90, 0x90, 0x17, 0x20, 0x70,
  0xEF, 0xFF, 0xB0, 0xE0, 0x76, 0x05, 0x0D, 0xFF, 0xFF, 0x0E, 0x05, 0x40, 0x20, 0xAF, 0xFF, 0xF0,
  0x90, 0x16, 0x03, 0x0B, 0xFF, 0xFB, 0x0B, 0x03, 0x73, 0x05, 0x0D, 0xFF, 0xE0, 0xD0, 0x46, 0x06,
  0x70, 0x60, 0xEC, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCC, 0x0E, 0x06, 0x78, 0x26, 0xFD, 0x57, 0x08,
  0xA0, 0x67, 0x10, 0x6A, 0x08, 0x70, 0x50, 0xDC, 0x0B, 0x03, 0x60, 0x10, 0x37, 0x30, 0x30, 0x16,
  0x03, 0x0B, 0xF9, 0x0A, 0x02, 0x77, 0x71, 0x02, 0x0A, 0xFD, 0x08, 0x01, 0x68, 0x41, 0xAD, 0xDA,
  0x16, 0x01, 0x08, 0xFF, 0x90, 0xE0, 0x64, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x06, 0x0E, 0xFF, 0xC0,
  0x33, 0x0A, 0xE0, 0xA3, 0x03, 0xFF, 0xE0, 0x13, 0x0D, 0xE0, 0xD3, 0x01, 0xFF, 0xE4, 0x0D, 0xE0,
  0xD4, 0xFF, 0xE0, 0x23, 0x0A, 0xE0, 0xA3, 0x02, 0xFF, 0xE0, 0x63, 0x01, 0x0E, 0xC0, 0xE0, 0x13,
  0x06, 0xFF, 0xE0, 0xC4, 0x84, 0x1A, 0xDD, 0xA1, 0x40, 0xCF, 0xFF, 0x06, 0x75, 0x06, 0xFF, 0xFA,
  0x03, 0x73, 0x03, 0xFF, 0xFC, 0x06, 0x71, 0x06, 0xFF, 0xFE, 0x0C, 0x06, 0x40, 0x60, 0xCF, 0xF0,
  0xDF, 0xF9, 0x4F, 0xF9, 0x0D, 0x07, 0xFF, 0x94, 0xFF, 0x98, 0x17, 0x0B, 0xFF, 0x4F, 0xF0, 0xB3,
  0x05, 0x0D, 0xFD, 0x4F, 0xD0, 0xD0, 0x56, 0x07, 0x0E, 0xFB, 0x4F, 0xB0, 0xE0, 0x77, 0x20, 0x10,
  0x9F, 0xA4, 0xFA, 0x09, 0x01, 0x75, 0x02, 0x0B, 0xF4, 0xF0, 0xB0, 0x27, 0x72, 0x04, 0x0C, 0xD4,
  0xD0, 0xC0, 0x47, 0x76, 0x05, 0x0D, 0xB4, 0xB0, 0xD0, 0x57, 0x77, 0x30, 0x70, 0xE9, 0x49, 0x0E,
  0x07, 0x77, 0x76, 0x01, 0x09, 0x40, 0x90, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_token() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 42), Box(0, 0, 47, 47),
      ic_round_48_action_token_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_toll 48x48, 4-bit Alpha,  RLE, 343 bytes.
static const unsigned char ic_round_48_action_toll_data[] PROGMEM = {
  0x77, 0x72, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x82, 0x18, 0x92, 0x71, 0x81, 0x19,
  0xEF, 0xB8, 0x1E, 0x91, 0x77, 0x10, 0x70, 0xEA, 0x0C, 0x70, 0x70, 0xEF, 0xF0, 0xE0, 0x77, 0x50,
  0x10, 0xCD, 0x50, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xD0, 0x94, 0x02, 0x0D, 0xD8,
  0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xD0, 0xD0, 0x27, 0x01, 0x0E, 0xC0, 0xD0, 0x54, 0x01, 0x0D,
  0xC0, 0xD0, 0x67, 0x30, 0x60, 0xDC, 0x0D, 0x01, 0x60, 0xCC, 0x0A, 0x60, 0xCC, 0x0A, 0x77, 0x0A,
  0xC0, 0xC5, 0x08, 0xC0, 0x86, 0x07, 0xC0, 0x87, 0x72, 0x08, 0xC0, 0x73, 0x01, 0xC0, 0xA6, 0x01,
  0x0E, 0xB0, 0xA7, 0x74, 0x0A, 0xB0, 0xE0, 0x12, 0x09, 0xB0, 0xD7, 0x09, 0xB0, 0xD7, 0x76, 0x0D,
  0xB0, 0x92, 0x0E, 0xB0, 0x57, 0x0E, 0xB0, 0x67, 0x76, 0x06, 0xB8, 0x1E, 0x05, 0xB0, 0xD7, 0x04,
  0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x04, 0x08, 0xB0, 0x87, 0x09, 0xB0, 0x97, 0x77, 0x10, 0x9B, 0x09,
  0x0C, 0xB0, 0x47, 0x0B, 0xB0, 0x47, 0x77, 0x10, 0x4B, 0x0B, 0x0D, 0xB0, 0x17, 0x0D, 0xB0, 0x27,
  0x77, 0x10, 0x2B, 0x0D, 0x0E, 0xB7, 0x10, 0xEB, 0x77, 0x73, 0xB0, 0x0E, 0xB7, 0x10, 0xEB, 0x77,
  0x73, 0xB0, 0xE0, 0xDB, 0x01, 0x70, 0xDB, 0x02, 0x77, 0x71, 0x02, 0xB0, 0xD0, 0xCB, 0x04, 0x70,
  0xBB, 0x04, 0x77, 0x71, 0x04, 0xB0, 0xB0, 0x8B, 0x08, 0x70, 0x9B, 0x09, 0x77, 0x71, 0x09, 0xB0,
  0x90, 0x5B, 0x0D, 0x70, 0x4B, 0x0D, 0x77, 0x71, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x57, 0x0E, 0xB0,
  0x67, 0x76, 0x06, 0xB0, 0xE2, 0x09, 0xB0, 0xD7, 0x09, 0xB0, 0xD7, 0x76, 0x0D, 0xB0, 0x92, 0x01,
  0xC0, 0xA6, 0x01, 0x0E, 0xB0, 0xA7, 0x74, 0x0A, 0xB0, 0xE0, 0x13, 0x08, 0xC0, 0x86, 0x07, 0xC0,
  0x87, 0x72, 0x08, 0xC0, 0x75, 0x0C, 0xC0, 0xA6, 0x0C, 0xC0, 0xA7, 0x70, 0xAC, 0x0C, 0x60, 0x10,
  0xEC, 0x0D, 0x05, 0x40, 0x10, 0xDC, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xC0, 0xD0, 0x17, 0x02, 0x0D,
  0xD0, 0x94, 0x02, 0x0D, 0xD8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xD0, 0xD0, 0x27, 0x20, 0x10,
  0xCD, 0x50, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x75, 0x07, 0x0E, 0xA0, 0xC7, 0x07, 0x0E, 0xFF, 0x0E,
  0x07, 0x77, 0x18, 0x21, 0x89, 0x27, 0x18, 0x11, 0x9E, 0xFB, 0x81, 0xE9, 0x17, 0x77, 0x73, 0x89,
  0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_toll() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 39), Box(0, 0, 47, 47),
      ic_round_48_action_toll_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_touch_app 48x48, 4-bit Alpha,  RLE, 261 bytes.
static const unsigned char ic_round_48_action_touch_app_data[] PROGMEM = {
  0x72, 0x86, 0x6B, 0xDF, 0xDC, 0x71, 0x77, 0x50, 0x60, 0xEF, 0x0E, 0x07, 0x77, 0x30, 0x9F, 0xC0,
  0xB7, 0x71, 0x07, 0xFE, 0x0A, 0x76, 0x02, 0xC8, 0x5E, 0x72, 0x01, 0x6D, 0xC0, 0x57, 0x50, 0xAB,
  0x0E, 0x02, 0x50, 0x10, 0xCB, 0x0D, 0x75, 0xC8, 0x74, 0x02, 0xBE, 0xC3, 0x02, 0xC0, 0x27, 0x30,
  0x4B, 0x0C, 0x20, 0xDB, 0x82, 0xE2, 0x0A, 0xB0, 0x67, 0x30, 0x5B, 0x81, 0x90, 0x4D, 0x81, 0x70,
  0x7B, 0x08, 0x73, 0x05, 0xB8, 0x18, 0x06, 0xD8, 0x18, 0x06, 0xB0, 0x77, 0x30, 0x3B, 0x81, 0x80,
  0x6D, 0x81, 0x80, 0x6B, 0x06, 0x73, 0x01, 0xB8, 0x18, 0x06, 0xD8, 0x18, 0x06, 0xB0, 0x27, 0x40,
  0x9A, 0x81, 0x80, 0x6D, 0x81, 0x80, 0x6A, 0x0C, 0x75, 0x03, 0xA8, 0x18, 0x06, 0xD8, 0x18, 0x06,
  0xA0, 0x57, 0x68, 0x37, 0xF8, 0x06, 0xD8, 0x38, 0x06, 0xF9, 0x77, 0x18, 0x28, 0x80, 0x6D, 0x82,
  0x80, 0x6A, 0x77, 0x38, 0x12, 0x06, 0xD8, 0x18, 0x01, 0x77, 0x60, 0x6D, 0x08, 0x77, 0x71, 0x06,
  0xD0, 0x87, 0x77, 0x10, 0x6D, 0x08, 0x77, 0x71, 0x06, 0xD0, 0x87, 0x77, 0x10, 0x6F, 0x81, 0xE9,
  0x27, 0x74, 0x06, 0xFB, 0x09, 0x02, 0x77, 0x20, 0x6F, 0xD0, 0x90, 0x27, 0x70, 0x6F, 0xF0, 0x90,
  0x27, 0x50, 0x6F, 0xFA, 0x09, 0x01, 0x73, 0x06, 0xFF, 0xB0, 0xD0, 0x17, 0x20, 0x6F, 0xFC, 0x09,
  0x72, 0x06, 0xFF, 0xC8, 0x6D, 0x3C, 0xEC, 0x85, 0x22, 0x06, 0xFF, 0xC0, 0xE0, 0xCE, 0x81, 0xEB,
  0xBF, 0xFC, 0x0C, 0x0E, 0xFF, 0xFE, 0x0A, 0x08, 0xFF, 0xFE, 0x81, 0x70, 0xAF, 0xFF, 0xD0, 0x52,
  0x0A, 0xFF, 0xFC, 0x03, 0x30, 0xAF, 0xFF, 0xB0, 0x14, 0x0A, 0xFF, 0xF9, 0x0E, 0x60, 0xAF, 0xFF,
  0x0C, 0x70, 0xAF, 0xFE, 0x0A, 0x71, 0x0A, 0xFF, 0xD0, 0x57, 0x20, 0xAF, 0xFB, 0x0B, 0x74, 0x06,
  0x0C, 0xFE, 0x0D, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_touch_app() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 38, 43), Box(0, 0, 47, 47),
      ic_round_48_action_touch_app_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_tour 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_round_48_action_tour_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x77, 0x76, 0x0D, 0xA0, 0xD7, 0x77, 0x6C, 0x77, 0x76, 0xC7, 0x77, 0x6F, 0xFF,
  0xF9, 0x0D, 0x04, 0xFF, 0xFF, 0xA0, 0xEF, 0xFF, 0xFA, 0x0E, 0xFF, 0xFF, 0xA0, 0x9F, 0xFF, 0xFA,
  0x03, 0xFF, 0xFF, 0x90, 0xC1, 0xFE, 0x84, 0xD5, 0x11, 0x5D, 0xFB, 0x06, 0x1F, 0xD0, 0xD0, 0x14,
  0x01, 0x0D, 0xF9, 0x0E, 0x2F, 0xD0, 0x56, 0x05, 0xF9, 0x09, 0x2F, 0xD0, 0x16, 0x01, 0xF9, 0x03,
  0x2F, 0xD0, 0x16, 0x01, 0xF9, 0x03, 0x2F, 0xD0, 0x56, 0x05, 0xF9, 0x09, 0x2F, 0xD0, 0xD0, 0x14,
  0x01, 0x0D, 0xF9, 0x0E, 0x2F, 0xE8, 0x4D, 0x51, 0x15, 0xDF, 0xB0, 0x61, 0xFF, 0xFF, 0x90, 0xC1,
  0xFF, 0xFF, 0xA0, 0x3F, 0xFF, 0xFA, 0x09, 0xFF, 0xFF, 0xA0, 0xEF, 0xFF, 0xFA, 0x0E, 0xFF, 0xFF,
  0x90, 0xD0, 0x4C, 0x77, 0x76, 0xC7, 0x77, 0x6C, 0x77, 0x76, 0xC7, 0x77, 0x6C, 0x77, 0x76, 0xC7,
  0x77, 0x6C, 0x77, 0x76, 0xC7, 0x77, 0x6C, 0x77, 0x76, 0xC7, 0x77, 0x6C, 0x77, 0x76, 0xC7, 0x77,
  0x6C, 0x77, 0x76, 0xC7, 0x77, 0x6C, 0x77, 0x76, 0xC7, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_tour() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 40, 43), Box(0, 0, 47, 47),
      ic_round_48_action_tour_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_track_changes 48x48, 4-bit Alpha,  RLE, 436 bytes.
static const unsigned char ic_round_48_action_track_changes_data[] PROGMEM = {
  0x77, 0x86, 0x26, 0xAC, 0xDE, 0xF8, 0x77, 0x77, 0x18, 0x11, 0x8D, 0xF9, 0x77, 0x76, 0x81, 0x18,
  0xEF, 0xB7, 0x77, 0x50, 0x40, 0xEF, 0xD7, 0x77, 0x40, 0x7E, 0x82, 0xEA, 0x73, 0xC7, 0x77, 0x30,
  0xAD, 0x81, 0xD7, 0x13, 0xC7, 0x77, 0x20, 0x9D, 0x08, 0x6C, 0x74, 0x01, 0x02, 0x72, 0x08, 0xC0,
  0xD0, 0x37, 0xC7, 0x30, 0x6A, 0x08, 0x70, 0x5C, 0x0D, 0x01, 0x58, 0x11, 0x6A, 0xC7, 0x30, 0xDB,
  0x05, 0x50, 0x10, 0xEB, 0x0D, 0x01, 0x40, 0x10, 0x9F, 0x73, 0x0B, 0xB0, 0xE0, 0x14, 0x08, 0xC0,
  0x34, 0x04, 0x0E, 0xF9, 0x73, 0x02, 0xC0, 0x83, 0x01, 0xC0, 0x74, 0x06, 0xFB, 0x74, 0x07, 0xC0,
  0x12, 0x08, 0xB0, 0xD4, 0x04, 0xD0, 0xD0, 0x7C, 0x58, 0x13, 0x72, 0x40, 0xDB, 0x08, 0x20, 0xDB,
  0x06, 0x30, 0x10, 0xEC, 0x06, 0x2C, 0x40, 0x5A, 0x0E, 0x01, 0x30, 0x5B, 0x81, 0xE0, 0x3B, 0x0E,
  0x40, 0x9C, 0x04, 0x3C, 0x40, 0x9B, 0x09, 0x40, 0xEB, 0x03, 0x07, 0xB0, 0xB3, 0x01, 0xC0, 0x64,
  0xC4, 0x05, 0xC0, 0x13, 0x09, 0xB0, 0x70, 0xAB, 0x06, 0x30, 0x6B, 0x0C, 0x40, 0x1C, 0x01, 0x40,
  0xCB, 0x07, 0x30, 0x5B, 0x0A, 0x0C, 0xB0, 0x33, 0x0A, 0xB0, 0x63, 0x02, 0x0E, 0xC0, 0xE0, 0x23,
  0x06, 0xB0, 0xA3, 0x02, 0xB0, 0xD0, 0xEB, 0x02, 0x30, 0xDB, 0x02, 0x30, 0xAE, 0x0A, 0x30, 0x2B,
  0x0D, 0x4B, 0x00, 0xEB, 0x40, 0xEB, 0x40, 0xEE, 0x0E, 0x4B, 0x0E, 0x40, 0xEB, 0x0E, 0xB4, 0x0E,
  0xB4, 0x0D, 0xE0, 0xD4, 0xB0, 0xE4, 0xC0, 0xEB, 0x01, 0x30, 0xDB, 0x02, 0x30, 0xAE, 0x0A, 0x30,
  0x2B, 0x0C, 0x4B, 0x0E, 0x0C, 0xB0, 0x33, 0x0A, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x06,
  0xB0, 0xB3, 0x02, 0xB0, 0xD0, 0xAB, 0x06, 0x30, 0x7B, 0x0C, 0x48, 0x41, 0xAD, 0xDA, 0x14, 0x0D,
  0xB0, 0x63, 0x05, 0xB0, 0xA0, 0x7B, 0x0A, 0x30, 0x1C, 0x06, 0x75, 0x06, 0xC0, 0x13, 0x0A, 0xB0,
  0x70, 0x3B, 0x0E, 0x40, 0x9C, 0x04, 0x73, 0x04, 0xC0, 0x94, 0x0E, 0xB8, 0x12, 0x0D, 0xB0, 0x63,
  0x01, 0x0E, 0xB0, 0xE0, 0x67, 0x10, 0x7C, 0x0E, 0x01, 0x30, 0x6B, 0x0D, 0x20, 0x8B, 0x0D, 0x40,
  0x4D, 0x86, 0xC6, 0x20, 0x12, 0x7C, 0xD0, 0x44, 0x0D, 0xB0, 0x72, 0x01, 0xC0, 0x74, 0x06, 0xFF,
  0xA0, 0x64, 0x07, 0xB0, 0xE0, 0x13, 0x09, 0xC0, 0x24, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x40, 0x2C,
  0x08, 0x40, 0x10, 0xEB, 0x0D, 0x01, 0x40, 0x10, 0x9F, 0xB0, 0x90, 0x14, 0x01, 0x0D, 0xB0, 0xD0,
  0x15, 0x06, 0xC0, 0xC0, 0x15, 0x89, 0x01, 0x6A, 0xDD, 0xDD, 0xA6, 0x15, 0x01, 0x0C, 0xC0, 0x47,
  0x0A, 0xC0, 0xD0, 0x27, 0x74, 0x02, 0x0D, 0xC0, 0x87, 0x20, 0xCC, 0x0E, 0x06, 0x77, 0x20, 0x70,
  0xEC, 0x0A, 0x73, 0x01, 0x0C, 0xD0, 0xC0, 0x57, 0x50, 0x60, 0xDD, 0x0A, 0x76, 0x0A, 0xE8, 0x2E,
  0x95, 0x24, 0x82, 0x25, 0xAE, 0xE0, 0x87, 0x71, 0x07, 0xFF, 0xF0, 0xD0, 0x57, 0x73, 0x02, 0x0B,
  0xFF, 0xC0, 0x87, 0x77, 0x81, 0x3A, 0xEF, 0xD8, 0x1D, 0x71, 0x77, 0x74, 0x82, 0x58, 0xCD, 0xC8,
  0x2C, 0xA7, 0x27, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_track_changes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_track_changes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_transcribe 48x48, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_round_48_action_transcribe_data[] PROGMEM = {
  0x77, 0x77, 0x48, 0x25, 0xCC, 0x48, 0x0C, 0x30, 0x03, 0xB0, 0xE0, 0x18, 0x0C, 0x20, 0x0D, 0xC0,
  0x48, 0x0C, 0x10, 0x08, 0xC0, 0xE0, 0x18, 0x0C, 0x00, 0x01, 0x0E, 0xC0, 0x77, 0x76, 0x86, 0x28,
  0xCE, 0xEC, 0x82, 0x72, 0x07, 0xC0, 0xD7, 0x76, 0x09, 0xF9, 0x09, 0x71, 0x0D, 0xC0, 0x67, 0x75,
  0x0B, 0xFB, 0x0B, 0x60, 0x2C, 0x0E, 0x01, 0x48, 0x29, 0xFC, 0x37, 0x30, 0x9F, 0xD0, 0x95, 0x06,
  0xC0, 0xA4, 0x07, 0xB0, 0xE7, 0x20, 0x2F, 0xF0, 0x24, 0x0A, 0xC0, 0x64, 0x0D, 0xC0, 0x37, 0x10,
  0x8F, 0xF0, 0x84, 0x0C, 0xC0, 0x33, 0x03, 0xD0, 0x17, 0x10, 0xCF, 0xF0, 0xC4, 0x0D, 0xC0, 0x13,
  0x05, 0xC0, 0xC7, 0x20, 0xEF, 0xF0, 0xE4, 0xD4, 0x07, 0xC0, 0x97, 0x20, 0xEF, 0xF0, 0xE4, 0x0E,
  0xC4, 0x07, 0xC0, 0x97, 0x20, 0xCF, 0xF0, 0xC4, 0x0D, 0xC4, 0x05, 0xC0, 0xB7, 0x20, 0x8F, 0xF0,
  0x84, 0x0C, 0xC0, 0x23, 0x02, 0xD0, 0x17, 0x10, 0x2F, 0xF0, 0x24, 0x09, 0xC0, 0x54, 0x0C, 0xC0,
  0x37, 0x20, 0x9F, 0xD0, 0x95, 0x06, 0xC0, 0x94, 0x06, 0xB0, 0xE0, 0x17, 0x30, 0xBF, 0xB0, 0xB6,
  0x02, 0xC0, 0xE5, 0x82, 0x8E, 0xC3, 0x75, 0x09, 0xF9, 0x09, 0x71, 0x0C, 0xC0, 0x57, 0x77, 0x86,
  0x28, 0xCE, 0xEC, 0x82, 0x72, 0x06, 0xC0, 0xC8, 0x0C, 0x30, 0x0E, 0xC0, 0x68, 0x0C, 0x20, 0x07,
  0xC0, 0xE0, 0x17, 0x72, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x10, 0xCC, 0x04,
  0x76, 0x81, 0x49, 0xEF, 0xF8, 0x1E, 0x94, 0x50, 0x3C, 0x01, 0x74, 0x07, 0x0D, 0xFF, 0xE0, 0xD0,
  0x74, 0x82, 0x4C, 0xC4, 0x73, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x10, 0x7F, 0xFF, 0xF0,
  0x77, 0x60, 0x3F, 0xFF, 0xFA, 0x03, 0x75, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x50, 0xDF, 0xFF, 0xFA,
  0x0D, 0x75, 0xFF, 0xFF, 0xC7, 0x5F, 0xFF, 0xFC, 0x75, 0xFF, 0xFF, 0xC7, 0x5F, 0xFF, 0xFC, 0x75,
  0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x50, 0x40, 0xDF, 0xFF, 0xF0, 0xD0, 0x47, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_transcribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_transcribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_translate 48x48, 4-bit Alpha,  RLE, 335 bytes.
static const unsigned char ic_round_48_action_translate_data[] PROGMEM = {
  0x77, 0x82, 0x4D, 0xD4, 0x80, 0xC4, 0x00, 0xDA, 0x0D, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77,
  0x75, 0x04, 0x0D, 0xFF, 0xFF, 0x0D, 0x04, 0x75, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x50, 0xDF, 0xFF,
  0xFA, 0x0D, 0x75, 0x04, 0x0D, 0xFF, 0xFF, 0x0D, 0x04, 0x77, 0x77, 0x60, 0xDA, 0x0E, 0x80, 0xC3,
  0x00, 0x4B, 0x09, 0x80, 0xC3, 0x00, 0xAB, 0x03, 0x80, 0xC2, 0x00, 0x2B, 0x0C, 0x77, 0x77, 0x81,
  0xBE, 0x67, 0x10, 0xAB, 0x05, 0x77, 0x76, 0x06, 0xB0, 0x36, 0x03, 0xB0, 0xD7, 0x77, 0x70, 0x4B,
  0x0D, 0x60, 0xCB, 0x05, 0x77, 0x77, 0x10, 0xBB, 0x07, 0x40, 0x7B, 0x0B, 0x77, 0x77, 0x20, 0x2C,
  0x03, 0x20, 0x3C, 0x02, 0x71, 0x82, 0x8E, 0xE8, 0x77, 0x50, 0x7B, 0x82, 0xE1, 0x1E, 0xB0, 0x77,
  0x10, 0x7C, 0x07, 0x77, 0x50, 0xBB, 0x00, 0xCB, 0x0B, 0x72, 0x0E, 0xC0, 0xE7, 0x75, 0x01, 0x0D,
  0xE0, 0xD0, 0x17, 0x10, 0x4E, 0x05, 0x77, 0x50, 0x30, 0xEC, 0x0E, 0x03, 0x72, 0x0A, 0xE0, 0xA7,
  0x75, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x10, 0x1B, 0x00, 0xEB, 0x01, 0x77, 0x30, 0x20, 0xDE, 0x0D,
  0x02, 0x70, 0x6B, 0x00, 0x8B, 0x06, 0x77, 0x20, 0x20, 0xEF, 0x90, 0xE0, 0x26, 0x0C, 0xB0, 0x03,
  0xB0, 0xC7, 0x71, 0x02, 0x0E, 0xC0, 0x07, 0xC0, 0xE0, 0x24, 0x02, 0xB0, 0xC2, 0x0C, 0xB0, 0x37,
  0x60, 0x20, 0xEC, 0x07, 0x20, 0x7C, 0x0E, 0x40, 0x8B, 0x06, 0x20, 0x6B, 0x08, 0x75, 0x02, 0x0E,
  0xC0, 0x74, 0x07, 0xC0, 0x53, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x40, 0x30, 0xEC, 0x07, 0x60,
  0x7B, 0x02, 0x20, 0x4B, 0x0A, 0x40, 0xAB, 0x05, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x18, 0x14, 0x83,
  0x30, 0xAB, 0x04, 0x40, 0x4B, 0x0A, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x70, 0x1B, 0x0E, 0x60, 0xEB,
  0x01, 0x70, 0xCC, 0x07, 0x77, 0x10, 0x6F, 0xF0, 0x67, 0x0E, 0xB0, 0x87, 0x72, 0x0C, 0xFF, 0x0C,
  0x70, 0x6A, 0x07, 0x77, 0x20, 0x2F, 0xFA, 0x03, 0x70, 0x01, 0x77, 0x30, 0x8F, 0xFA, 0x08, 0x77,
  0x75, 0x0E, 0xB0, 0x17, 0x10, 0x1B, 0x0E, 0x77, 0x74, 0x04, 0xB0, 0xA7, 0x30, 0xAB, 0x04, 0x77,
  0x73, 0x0A, 0xB0, 0x47, 0x30, 0x4B, 0x0A, 0x77, 0x73, 0xB0, 0xE7, 0x50, 0xEB, 0x77, 0x72, 0x01,
  0xB0, 0x87, 0x50, 0x8B, 0x01, 0x77, 0x72, 0x82, 0x7E, 0xB1, 0x75, 0x82, 0x1B, 0xE7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_translate() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 45, 43), Box(0, 0, 47, 47),
      ic_round_48_action_translate_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_trending_down 48x48, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_round_48_action_trending_down_data[] PROGMEM = {
  0x20, 0x18, 0x0C, 0x20, 0x82, 0x9F, 0xE5, 0x77, 0x77, 0x70, 0x1C, 0x05, 0x77, 0x77, 0x70, 0xEC,
  0x05, 0x77, 0x77, 0x60, 0x4D, 0x05, 0x77, 0x01, 0x77, 0x50, 0x4D, 0x05, 0x75, 0x82, 0x9F, 0xE4,
  0x77, 0x40, 0x5D, 0x05, 0x73, 0x0A, 0xC0, 0x47, 0x74, 0x05, 0xD0, 0x57, 0x10, 0xAE, 0x05, 0x77,
  0x40, 0x5D, 0x05, 0x60, 0xAF, 0x90, 0x57, 0x74, 0x05, 0xD0, 0x54, 0x0A, 0xC0, 0xDD, 0x05, 0x77,
  0x40, 0x5D, 0x05, 0x20, 0xAC, 0x81, 0xD1, 0x5D, 0x05, 0x77, 0x40, 0x5D, 0x05, 0x0A, 0xC0, 0xD0,
  0x12, 0x05, 0xD0, 0x57, 0x74, 0x05, 0xFA, 0x0D, 0x01, 0x40, 0x5D, 0x05, 0x77, 0x40, 0x5F, 0x0D,
  0x01, 0x60, 0x5D, 0x05, 0x50, 0x05, 0x74, 0x05, 0xD0, 0xD0, 0x17, 0x10, 0x5D, 0x05, 0x38, 0x18,
  0xFE, 0x75, 0x05, 0xB0, 0xD0, 0x17, 0x30, 0x5D, 0x81, 0x50, 0x8B, 0x76, 0x82, 0x4B, 0xA1, 0x75,
  0x05, 0xD0, 0xAC, 0x77, 0x77, 0x20, 0x5F, 0xA7, 0x77, 0x73, 0x05, 0xF9, 0x77, 0x77, 0x40, 0xAF,
  0x77, 0x77, 0x30, 0x7F, 0x97, 0x77, 0x72, 0x07, 0xFA, 0x77, 0x77, 0x10, 0x5F, 0xB7, 0x77, 0x71,
  0x05, 0xFA, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_trending_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 43, 35), Box(0, 0, 47, 47),
      ic_round_48_action_trending_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_trending_flat 48x48, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_48_action_trending_flat_data[] PROGMEM = {
  0x77, 0x77, 0x20, 0x05, 0x80, 0xC0, 0x0A, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x77, 0x77, 0x6C, 0x07,
  0x77, 0x77, 0x5D, 0x07, 0x20, 0x40, 0xDF, 0xFF, 0xFE, 0x81, 0x70, 0xD8, 0x0C, 0x0F, 0x05, 0x0D,
  0x80, 0xC0, 0xF8, 0x15, 0x4D, 0xFF, 0xFF, 0xE0, 0x77, 0x77, 0x73, 0xD0, 0x77, 0x77, 0x74, 0xC0,
  0x77, 0x77, 0x75, 0xB0, 0x77, 0x77, 0x76, 0xA0, 0x77, 0x77, 0x77, 0x00, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_trending_flat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 17, 43, 30), Box(0, 0, 47, 47),
      ic_round_48_action_trending_flat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_trending_up 48x48, 4-bit Alpha,  RLE, 165 bytes.
static const unsigned char ic_round_48_action_trending_up_data[] PROGMEM = {
  0x77, 0x77, 0x10, 0x5F, 0xA0, 0xB7, 0x77, 0x71, 0x05, 0xFB, 0x77, 0x77, 0x20, 0x7F, 0xA7, 0x77,
  0x73, 0x07, 0xF9, 0x77, 0x77, 0x40, 0xAF, 0x77, 0x77, 0x30, 0x5F, 0x97, 0x77, 0x72, 0x05, 0xFA,
  0x76, 0x82, 0x4B, 0xA1, 0x75, 0x05, 0xD0, 0xAC, 0x75, 0x05, 0xB0, 0xD0, 0x17, 0x30, 0x5D, 0x81,
  0x50, 0x8B, 0x74, 0x05, 0xD0, 0xD0, 0x17, 0x10, 0x5D, 0x05, 0x38, 0x18, 0xFE, 0x73, 0x05, 0xF0,
  0xD0, 0x16, 0x05, 0xD0, 0x55, 0x00, 0x57, 0x20, 0x5F, 0xA0, 0xD0, 0x14, 0x05, 0xD0, 0x57, 0x72,
  0x05, 0xD0, 0x50, 0xAC, 0x0D, 0x01, 0x20, 0x5D, 0x05, 0x77, 0x20, 0x5D, 0x05, 0x20, 0xAC, 0x81,
  0xD1, 0x5D, 0x05, 0x77, 0x20, 0x5D, 0x05, 0x40, 0xAC, 0x0D, 0xD0, 0x57, 0x72, 0x05, 0xD0, 0x56,
  0x0A, 0xF9, 0x05, 0x77, 0x20, 0x5D, 0x05, 0x71, 0x0A, 0xE0, 0x57, 0x72, 0x05, 0xD0, 0x57, 0x30,
  0xAC, 0x04, 0x77, 0x20, 0x4D, 0x05, 0x75, 0x82, 0x9F, 0xE4, 0x77, 0x20, 0x4D, 0x05, 0x77, 0x01,
  0x77, 0x40, 0xEC, 0x05, 0x77, 0x77, 0x50, 0x1C, 0x05, 0x77, 0x77, 0x78, 0x29, 0xFE, 0x58, 0x0C,
  0x10, 0x01, 0x80, 0xC1, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_trending_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 43, 35), Box(0, 0, 47, 47),
      ic_round_48_action_trending_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_troubleshoot 48x48, 4-bit Alpha,  RLE, 367 bytes.
static const unsigned char ic_round_48_action_troubleshoot_data[] PROGMEM = {
  0x77, 0x18, 0x90, 0x58, 0xBE, 0xED, 0xDC, 0x85, 0x77, 0x77, 0x18, 0x12, 0x8E, 0xFB, 0x81, 0xE8,
  0x27, 0x77, 0x40, 0x70, 0xEF, 0xF0, 0xE0, 0x77, 0x77, 0x10, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x77,
  0x50, 0x20, 0xDD, 0x89, 0x0E, 0x84, 0x20, 0x11, 0x48, 0xDD, 0x0D, 0x02, 0x77, 0x30, 0x10, 0xDC,
  0x0E, 0x05, 0x73, 0x05, 0x0D, 0xC0, 0xD0, 0x17, 0x72, 0x0B, 0xC0, 0xA0, 0x17, 0x60, 0xAC, 0x0C,
  0x77, 0x10, 0x7C, 0x09, 0x77, 0x20, 0x9C, 0x07, 0x76, 0x01, 0xC0, 0xB2, 0x82, 0x5E, 0xD5, 0x75,
  0x0A, 0xC0, 0x27, 0x50, 0x8B, 0x82, 0xD1, 0x01, 0xB0, 0xE7, 0x60, 0xDB, 0x08, 0x75, 0x0E, 0xB0,
  0x62, 0x05, 0xC0, 0x47, 0x50, 0x5B, 0x0E, 0x74, 0x04, 0xB0, 0xD3, 0x0A, 0xC0, 0x77, 0x60, 0xDB,
  0x04, 0x73, 0x08, 0xB0, 0x93, 0x0E, 0xC0, 0xB3, 0x82, 0x5E, 0xE6, 0x60, 0x8B, 0x08, 0x73, 0x0B,
  0xB0, 0x42, 0x04, 0xA0, 0xDA, 0x0E, 0x20, 0x1C, 0x02, 0x50, 0x4B, 0x0B, 0x77, 0x30, 0x9A, 0x07,
  0x0D, 0xA8, 0x12, 0x06, 0xC0, 0x85, 0x01, 0xB0, 0xD7, 0x73, 0x0E, 0xA0, 0x30, 0xAA, 0x81, 0x60,
  0xBC, 0x0E, 0x50, 0x1B, 0x0D, 0x60, 0x8F, 0xD8, 0x1D, 0x06, 0xA0, 0xA0, 0x1B, 0x0D, 0xA0, 0x55,
  0xB0, 0xE6, 0x0E, 0xFD, 0x81, 0x80, 0x2A, 0x0D, 0x06, 0xA0, 0xB0, 0x7A, 0x0C, 0x40, 0x1B, 0x0D,
  0x60, 0x8F, 0xC0, 0xB0, 0x12, 0x0E, 0xA0, 0xDA, 0x06, 0x01, 0xC0, 0x72, 0x05, 0xB0, 0xB7, 0x77,
  0x10, 0xBD, 0x81, 0x10, 0x9B, 0x0E, 0x20, 0x8B, 0x08, 0x77, 0x71, 0x07, 0xC0, 0xB2, 0x01, 0x0C,
  0xA0, 0x72, 0x0E, 0xB0, 0x47, 0x40, 0xEB, 0x05, 0x60, 0x4C, 0x06, 0x71, 0x05, 0xB0, 0xE7, 0x50,
  0x8B, 0x0D, 0x70, 0xEA, 0x0E, 0x01, 0x70, 0x10, 0xDB, 0x08, 0x75, 0x02, 0xC0, 0xA6, 0x82, 0x5D,
  0xE5, 0x71, 0x0A, 0xB0, 0xE0, 0x17, 0x60, 0x7C, 0x09, 0x77, 0x20, 0x9C, 0x06, 0x77, 0x10, 0xCC,
  0x0A, 0x76, 0x01, 0x0A, 0xC0, 0xC7, 0x72, 0x01, 0x0D, 0xC0, 0xD0, 0x57, 0x30, 0x60, 0xEE, 0x05,
  0x77, 0x20, 0x20, 0xDD, 0x82, 0xD8, 0x41, 0x28, 0x22, 0x49, 0xEF, 0xA0, 0x57, 0x72, 0x01, 0x0C,
  0xFF, 0xC0, 0xCD, 0x05, 0x77, 0x30, 0x7F, 0xFA, 0x81, 0x70, 0x5D, 0x05, 0x77, 0x38, 0x12, 0x8E,
  0xFB, 0x81, 0xE8, 0x13, 0x05, 0xD0, 0x57, 0x75, 0x89, 0x04, 0x8C, 0xDF, 0xED, 0xC8, 0x47, 0x05,
  0xD0, 0x58, 0x0C, 0x00, 0x05, 0xD0, 0x58, 0x0C, 0x00, 0x05, 0xD0, 0x58, 0x0C, 0x00, 0x05, 0xC0,
  0xE8, 0x0C, 0x10, 0x05, 0xC0, 0x18, 0x0C, 0x10, 0x82, 0x5E, 0xF8, 0x80, 0xC4, 0x00, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_troubleshoot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_troubleshoot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_try 48x48, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_round_48_action_try_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0A, 0x87, 0xF0, 0x09, 0x80, 0xC1, 0xF0, 0xC2, 0x0D,
  0x80, 0xC0, 0xF0, 0x52, 0x06, 0xFF, 0xFF, 0xF0, 0xD4, 0x0D, 0xFF, 0xFF, 0xE0, 0x74, 0x07, 0xFF,
  0xFF, 0xD0, 0xE5, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0xD0, 0x77, 0x10, 0x70, 0xDF, 0xFF, 0xD0, 0xC0,
  0x57, 0x50, 0x50, 0xCF, 0xFF, 0xA0, 0x97, 0x72, 0x09, 0xFF, 0xF9, 0x09, 0x77, 0x20, 0x9F, 0xFF,
  0xA0, 0xD0, 0x67, 0x50, 0x60, 0xDF, 0xFF, 0xD8, 0x1E, 0x71, 0x68, 0x11, 0x7E, 0xFF, 0xFF, 0xA0,
  0xE5, 0x01, 0x0E, 0xFF, 0xFF, 0xD0, 0x74, 0x07, 0xFF, 0xFF, 0xE0, 0xD4, 0x0E, 0xFF, 0xFF, 0xF0,
  0x52, 0x06, 0x80, 0xC0, 0xF0, 0xC2, 0x0D, 0x80, 0xC1, 0xF0, 0x09, 0x80, 0xAD, 0x6F, 0x0D, 0x80,
  0xC3, 0xF0, 0xA8, 0x0C, 0x2F, 0x0E, 0x01, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77,
  0x4E, 0x07, 0x77, 0x77, 0x5D, 0x07, 0x77, 0x77, 0x60, 0xDB, 0x07, 0x77, 0x77, 0x70, 0x6A, 0x07,
  0x80, 0xC2, 0x00, 0x18, 0x0C, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_try() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_try_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_turned_in_not 48x48, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_round_48_action_turned_in_not_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x19, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xF9, 0x01, 0x77, 0x40, 0x1F, 0x97,
  0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x72,
  0x00, 0x27, 0x2F, 0x97, 0x04, 0x0A, 0xA0, 0xA0, 0x47, 0xF9, 0x50, 0x60, 0xCE, 0x0C, 0x06, 0x5F,
  0x92, 0x81, 0x18, 0xEF, 0xB8, 0x1E, 0x81, 0x2F, 0x90, 0x30, 0xAF, 0xFA, 0x0A, 0x03, 0xFF, 0xA8,
  0x29, 0x33, 0x9F, 0xFF, 0x81, 0xE7, 0x14, 0x81, 0x17, 0xEF, 0xFA, 0x0C, 0x05, 0x73, 0x05, 0x0C,
  0xFD, 0x09, 0x03, 0x77, 0x03, 0x09, 0xF8, 0x1E, 0x71, 0x77, 0x48, 0x11, 0x7E, 0xA0, 0xC0, 0x57,
  0x77, 0x30, 0x50, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_turned_in_not() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_round_48_action_turned_in_not_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_turned_in 48x48, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_48_action_turned_in_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x19, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0x9B, 0xC0, 0xF8, 0x29, 0x33, 0x9F, 0xFF, 0x81, 0xE7, 0x14, 0x81,
  0x17, 0xEF, 0xFA, 0x0C, 0x05, 0x73, 0x05, 0x0C, 0xFD, 0x09, 0x03, 0x77, 0x03, 0x09, 0xF8, 0x1E,
  0x71, 0x77, 0x48, 0x11, 0x7E, 0xA0, 0xC0, 0x57, 0x77, 0x30, 0x50, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_turned_in() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_round_48_action_turned_in_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_unfold_less_double 48x48, 4-bit Alpha,  RLE, 249 bytes.
static const unsigned char ic_round_48_action_unfold_less_double_data[] PROGMEM = {
  0x20, 0x17, 0x50, 0x13, 0x82, 0xBF, 0xD3, 0x71, 0x84, 0x3E, 0xFB, 0x04, 0xB0, 0xE0, 0x36, 0x03,
  0x0E, 0xB0, 0x40, 0x2C, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x81, 0x20, 0x7C, 0x0E, 0x03, 0x20, 0x30,
  0xEC, 0x07, 0x30, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x75, 0x07, 0xC0, 0x0E, 0xC0, 0x77, 0x07, 0xF9,
  0x07, 0x72, 0x07, 0xE0, 0x77, 0x40, 0x7C, 0x07, 0x71, 0x01, 0x40, 0x7A, 0x07, 0x40, 0x13, 0x82,
  0xBF, 0xD3, 0x30, 0x01, 0x38, 0x43, 0xEF, 0xB0, 0x4B, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x04, 0x02,
  0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC8, 0x12, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC0, 0x73, 0x07,
  0xC8, 0x2E, 0x33, 0xEC, 0x07, 0x50, 0x7C, 0x00, 0xEC, 0x07, 0x70, 0x7F, 0x90, 0x77, 0x20, 0x7E,
  0x07, 0x74, 0x07, 0xC0, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x10, 0x01, 0x80, 0x9A, 0x40, 0x00, 0x17,
  0x71, 0x07, 0xA0, 0x77, 0x60, 0x7C, 0x07, 0x74, 0x07, 0xE0, 0x77, 0x20, 0x7F, 0x90, 0x77, 0x07,
  0xC0, 0x0E, 0xC0, 0x75, 0x07, 0xC8, 0x2E, 0x33, 0xEC, 0x07, 0x30, 0x7C, 0x0E, 0x03, 0x20, 0x30,
  0xEC, 0x81, 0x70, 0x2C, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x02, 0x03, 0xB0, 0xE0, 0x36, 0x03, 0x0E,
  0xB8, 0x44, 0x0B, 0xFD, 0x33, 0x00, 0x13, 0x82, 0x3D, 0xFB, 0x30, 0x14, 0x07, 0xA0, 0x74, 0x01,
  0x71, 0x07, 0xC0, 0x77, 0x40, 0x7E, 0x07, 0x72, 0x07, 0xF9, 0x07, 0x70, 0x7C, 0x00, 0xEC, 0x07,
  0x50, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC8, 0x17, 0x02,
  0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x20, 0x4B, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x84, 0x40, 0xBF,
  0xE3, 0x71, 0x82, 0x3D, 0xFB, 0x30, 0x17, 0x50, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_unfold_less_double() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(15, 0, 32, 47), Box(0, 0, 47, 47),
      ic_round_48_action_unfold_less_double_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_unfold_more_double 48x48, 4-bit Alpha,  RLE, 250 bytes.
static const unsigned char ic_round_48_action_unfold_more_double_data[] PROGMEM = {
  0x71, 0x00, 0x17, 0x71, 0x07, 0xA0, 0x77, 0x60, 0x7C, 0x07, 0x74, 0x07, 0xE0, 0x77, 0x20, 0x7F,
  0x90, 0x77, 0x07, 0xC0, 0x0E, 0xC0, 0x75, 0x07, 0xC8, 0x2E, 0x33, 0xEC, 0x07, 0x30, 0x7C, 0x0E,
  0x03, 0x20, 0x30, 0xEC, 0x81, 0x70, 0x2C, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x02, 0x04, 0xB0, 0xE0,
  0x36, 0x03, 0x0E, 0xB8, 0x43, 0x0B, 0xFD, 0x33, 0x00, 0x13, 0x82, 0x3D, 0xFB, 0x30, 0x14, 0x07,
  0xA0, 0x74, 0x01, 0x71, 0x07, 0xC0, 0x77, 0x40, 0x7E, 0x07, 0x72, 0x07, 0xF9, 0x07, 0x70, 0x7C,
  0x00, 0xEC, 0x07, 0x50, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E,
  0xC8, 0x17, 0x02, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x20, 0x4B, 0x0E, 0x03, 0x60, 0x30, 0xEB,
  0x84, 0x30, 0xBF, 0xD3, 0x71, 0x82, 0x3D, 0xFB, 0x30, 0x17, 0x50, 0x18, 0x09, 0x90, 0x00, 0x17,
  0x50, 0x13, 0x82, 0xBF, 0xD3, 0x71, 0x84, 0x3D, 0xFB, 0x03, 0xB0, 0xE0, 0x36, 0x03, 0x0E, 0xB0,
  0x40, 0x2C, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x81, 0x20, 0x7C, 0x0E, 0x03, 0x20, 0x30, 0xEC, 0x07,
  0x30, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x75, 0x07, 0xC0, 0x0E, 0xC0, 0x77, 0x07, 0xF9, 0x07, 0x72,
  0x07, 0xE0, 0x77, 0x40, 0x7C, 0x07, 0x71, 0x01, 0x40, 0x7A, 0x07, 0x40, 0x13, 0x82, 0xBF, 0xD3,
  0x30, 0x01, 0x38, 0x43, 0xDF, 0xA0, 0x3B, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x04, 0x02, 0xC0, 0xE0,
  0x34, 0x03, 0x0E, 0xC8, 0x12, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC8, 0x2E,
  0x33, 0xEC, 0x08, 0x50, 0x7C, 0x00, 0xEC, 0x08, 0x70, 0x7F, 0x90, 0x87, 0x20, 0x7E, 0x08, 0x74,
  0x07, 0xC0, 0x87, 0x60, 0x7A, 0x07, 0x77, 0x10, 0x01, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_unfold_more_double() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(15, 0, 32, 47), Box(0, 0, 47, 47),
      ic_round_48_action_unfold_more_double_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_unpublished 48x48, 4-bit Alpha,  RLE, 363 bytes.
static const unsigned char ic_round_48_action_unpublished_data[] PROGMEM = {
  0x77, 0x18, 0x92, 0x27, 0x9C, 0xEE, 0xDD, 0xC9, 0x63, 0x77, 0x75, 0x81, 0x17, 0xDF, 0xD8, 0x1D,
  0x71, 0x75, 0x81, 0x27, 0x47, 0x07, 0x0E, 0xFF, 0xB0, 0x87, 0x30, 0x20, 0xEA, 0x07, 0x50, 0xAF,
  0xFE, 0x0D, 0x04, 0x71, 0x05, 0xC0, 0x75, 0x0C, 0xFF, 0xF0, 0x77, 0x01, 0x0E, 0xC0, 0x75, 0x0C,
  0xFF, 0xF0, 0xA7, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xF0, 0xA7, 0x03, 0x0E, 0xC0, 0x75, 0x0C,
  0xFF, 0xF0, 0x77, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xF0, 0x47, 0x0E, 0xD0, 0x75, 0x0C, 0xFF,
  0xE0, 0xD6, 0x08, 0xF0, 0x75, 0x0C, 0xFF, 0xE0, 0x84, 0x01, 0x0E, 0xF9, 0x07, 0x50, 0xCF, 0xFE,
  0x01, 0x30, 0x7F, 0xB0, 0x75, 0x0C, 0xFF, 0xD0, 0x73, 0x0D, 0xFC, 0x07, 0x50, 0xCE, 0x82, 0xE5,
  0x16, 0xF9, 0x0D, 0x20, 0x2F, 0xE0, 0x75, 0x0C, 0xC0, 0xE0, 0x33, 0x0A, 0xF9, 0x81, 0x30, 0x7F,
  0xF0, 0x75, 0x0C, 0xA0, 0xE0, 0x34, 0x09, 0xF9, 0x81, 0x60, 0x9F, 0xF9, 0x07, 0x58, 0x1C, 0xE3,
  0x40, 0x3F, 0xA8, 0x19, 0x0C, 0xFF, 0xA0, 0x75, 0x03, 0x40, 0x30, 0xEF, 0xA8, 0x1C, 0x0E, 0xFA,
  0x81, 0xEB, 0xED, 0x07, 0x71, 0x03, 0x0E, 0xFB, 0x81, 0xD0, 0xEF, 0x98, 0x3D, 0x10, 0x1C, 0xD0,
  0x76, 0x03, 0x0E, 0xFC, 0x81, 0xE0, 0xEF, 0x90, 0x83, 0x01, 0x0C, 0xD0, 0x75, 0x0B, 0xFD, 0x81,
  0xE0, 0xDF, 0x90, 0xB4, 0x01, 0x0C, 0xD0, 0x75, 0x0C, 0xFC, 0x81, 0xE0, 0xCF, 0xA0, 0x74, 0x01,
  0x0C, 0xD0, 0x75, 0x0C, 0xFB, 0x81, 0xB0, 0x9F, 0xB0, 0x74, 0x81, 0x16, 0xEC, 0x07, 0x50, 0xCF,
  0xA8, 0x19, 0x06, 0xFC, 0x07, 0x50, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0x98, 0x17, 0x03, 0xFD, 0x07,
  0x50, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0x02, 0x20, 0xDF, 0xD0, 0x74, 0x03, 0x0E, 0xD0, 0x75, 0x0C,
  0xD0, 0xC3, 0x07, 0xFE, 0x07, 0x20, 0x30, 0xEF, 0x07, 0x50, 0xCC, 0x07, 0x30, 0x1F, 0xF0, 0xC0,
  0xAF, 0xB0, 0x75, 0x0C, 0xA0, 0xE0, 0x14, 0x08, 0xFF, 0xFD, 0x07, 0x58, 0x1C, 0xF7, 0x60, 0xDF,
  0xFF, 0xD0, 0x75, 0x0A, 0x70, 0x4F, 0xFF, 0xE0, 0x77, 0x60, 0x7F, 0xFF, 0xE0, 0x77, 0x60, 0x9F,
  0xFF, 0xE0, 0x77, 0x60, 0x9F, 0xFF, 0xE0, 0x77, 0x60, 0x7F, 0xFF, 0xE0, 0x77, 0x60, 0x40, 0xDF,
  0xFE, 0x0D, 0x0E, 0xC0, 0x77, 0x70, 0x7F, 0xFB, 0x83, 0xE7, 0x03, 0xEC, 0x04, 0x77, 0x81, 0x17,
  0xDF, 0xD8, 0x1C, 0x71, 0x30, 0x30, 0xEB, 0x07, 0x77, 0x38, 0x92, 0x26, 0x9C, 0xDD, 0xDD, 0xB9,
  0x62, 0x78, 0x33, 0xEF, 0xE2, 0x80, 0xC1, 0x08, 0x11, 0x41, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_unpublished() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 43, 44), Box(0, 0, 47, 47),
      ic_round_48_action_unpublished_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_update_disabled 48x48, 4-bit Alpha,  RLE, 373 bytes.
static const unsigned char ic_round_48_action_update_disabled_data[] PROGMEM = {
  0x18, 0x12, 0x74, 0x74, 0x89, 0x21, 0x58, 0xCD, 0xEF, 0xEC, 0x96, 0x17, 0x50, 0x20, 0xEA, 0x07,
  0x71, 0x04, 0x0A, 0xFD, 0x0C, 0x05, 0x73, 0x05, 0xC0, 0x75, 0x02, 0x0B, 0xFF, 0xA0, 0xC0, 0x47,
  0x10, 0x10, 0xEC, 0x07, 0x50, 0xCF, 0xFC, 0x09, 0x58, 0x35, 0x50, 0x3E, 0xC0, 0x75, 0x0C, 0xA8,
  0x2C, 0x73, 0x12, 0x82, 0x24, 0x7D, 0xE0, 0xC0, 0x12, 0x07, 0xA2, 0x03, 0x0E, 0xC0, 0x75, 0x08,
  0x02, 0x73, 0x03, 0x0A, 0xD8, 0x1C, 0x17, 0xB3, 0x03, 0x0E, 0xC0, 0x77, 0x74, 0x04, 0x0D, 0xC0,
  0xDC, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x40, 0x10, 0xCF, 0x95, 0x05, 0xD0, 0x77, 0x82, 0x4D, 0xD4,
  0x70, 0x10, 0xCF, 0x50, 0xBE, 0x07, 0x60, 0xDA, 0x0D, 0x71, 0x08, 0xF4, 0x04, 0xF9, 0x07, 0x50,
  0xCB, 0x70, 0x7F, 0x94, 0x0A, 0xB0, 0xC0, 0xEC, 0x07, 0x50, 0xCA, 0x60, 0x7F, 0xA3, 0x01, 0xC8,
  0x13, 0x3E, 0xC0, 0x75, 0x0C, 0x95, 0x05, 0xFB, 0x30, 0x5B, 0x0C, 0x20, 0x30, 0xEC, 0x07, 0x50,
  0xC5, 0x05, 0xFA, 0x0B, 0x30, 0x9B, 0x08, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x73, 0x0C, 0xB0, 0x44,
  0x03, 0x0E, 0xC0, 0x77, 0x77, 0x20, 0xDB, 0x02, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x71, 0xC0, 0x16,
  0x03, 0x0E, 0xC0, 0x77, 0x77, 0x0E, 0xB7, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x60, 0xDB, 0x02, 0x71,
  0x03, 0x0E, 0xC0, 0x77, 0x75, 0x0B, 0xB0, 0x37, 0x20, 0x30, 0xEC, 0x07, 0x74, 0x81, 0xAE, 0xA4,
  0x09, 0xB0, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x72, 0x06, 0xB0, 0x53, 0x05, 0xB0, 0xB7, 0x40, 0x30,
  0xEC, 0x07, 0x71, 0x0C, 0xB0, 0x63, 0x01, 0xC0, 0x27, 0x40, 0x30, 0xEC, 0x07, 0x60, 0x2C, 0x01,
  0x40, 0xBB, 0x09, 0x75, 0x03, 0x0E, 0xC0, 0x75, 0x08, 0xB0, 0xB5, 0x04, 0xC0, 0x37, 0x50, 0x30,
  0xEC, 0x07, 0x50, 0xBA, 0x05, 0x60, 0xCB, 0x0C, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0B, 0x0C, 0x70,
  0x3C, 0x0B, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x02, 0x71, 0x08, 0xC0, 0xA7, 0x60, 0x30, 0xEC, 0x07,
  0x77, 0x0B, 0xC0, 0xC0, 0x37, 0x50, 0x30, 0xEC, 0x07, 0x76, 0x01, 0x0C, 0xD0, 0x90, 0x27, 0x30,
  0x30, 0xBD, 0x07, 0x77, 0x0B, 0xE8, 0x2B, 0x73, 0x12, 0x82, 0x14, 0x7C, 0xF9, 0x07, 0x77, 0x08,
  0xFF, 0xFB, 0x07, 0x77, 0x03, 0x0B, 0xFF, 0xA8, 0x1C, 0x6E, 0xC0, 0x77, 0x71, 0x05, 0x0B, 0xFD,
  0x0B, 0x04, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x28, 0x92, 0x15, 0x9B, 0xDE, 0xFD, 0xC9, 0x61, 0x50,
  0x30, 0xEC, 0x04, 0x77, 0x77, 0x50, 0x30, 0xEB, 0x07, 0x77, 0x77, 0x68, 0x33, 0xEF, 0xE2, 0x77,
  0x77, 0x78, 0x11, 0x51, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_update_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 41, 44), Box(0, 0, 47, 47),
      ic_round_48_action_update_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_update 48x48, 4-bit Alpha,  RLE, 295 bytes.
static const unsigned char ic_round_48_action_update_data[] PROGMEM = {
  0x75, 0x83, 0x16, 0x9C, 0xDA, 0x83, 0xDC, 0x96, 0x17, 0x77, 0x10, 0x50, 0xBF, 0xD0, 0xB0, 0x57,
  0x10, 0x05, 0x71, 0x03, 0x0C, 0xFF, 0xA0, 0xC0, 0x45, 0x07, 0xA7, 0x08, 0xFF, 0xE0, 0x93, 0x07,
  0xB6, 0x0B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE8, 0x1C, 0x17, 0xC5, 0x0C, 0xD0, 0xA0,
  0x27, 0x30, 0x20, 0xAD, 0x0E, 0xD4, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDF, 0xA3, 0x08, 0xC0,
  0xB0, 0x17, 0x72, 0x01, 0x0B, 0xF9, 0x20, 0x3C, 0x0B, 0x77, 0x50, 0x7F, 0x92, 0x0C, 0xB0, 0xD0,
  0x17, 0x74, 0x07, 0xFA, 0x10, 0x4C, 0x03, 0x72, 0x81, 0x8E, 0x86, 0x07, 0xFB, 0x10, 0xBB, 0x0A,
  0x73, 0xB5, 0x07, 0xFC, 0x01, 0xC0, 0x27, 0x3B, 0x40, 0x5F, 0xD0, 0x5B, 0x0C, 0x74, 0xB4, 0x05,
  0xFC, 0x0B, 0x09, 0xB0, 0x77, 0x4B, 0x77, 0x30, 0xCB, 0x03, 0x74, 0xB7, 0x73, 0x0E, 0xB0, 0x27,
  0x4B, 0x77, 0x30, 0xEB, 0x75, 0xB7, 0x73, 0x0E, 0xB7, 0x5B, 0x06, 0x75, 0x83, 0x6E, 0xD3, 0xEB,
  0x02, 0x74, 0x0C, 0xB0, 0xC0, 0x37, 0x3B, 0x0B, 0x0C, 0xB0, 0x47, 0x40, 0x20, 0xDC, 0x09, 0x01,
  0x70, 0x4B, 0x0C, 0x09, 0xB0, 0x77, 0x60, 0x70, 0xEB, 0x0E, 0x06, 0x60, 0x7B, 0x09, 0x06, 0xB0,
  0xD7, 0x70, 0x10, 0xAC, 0x05, 0x50, 0xBB, 0x05, 0x01, 0xC0, 0x37, 0x71, 0x03, 0x0C, 0xA0, 0x54,
  0x02, 0xC8, 0x11, 0x0B, 0xB0, 0xB7, 0x73, 0x00, 0x55, 0x09, 0xB0, 0xB2, 0x05, 0xC0, 0x47, 0x77,
  0x10, 0x3C, 0x04, 0x30, 0xCB, 0x0E, 0x01, 0x77, 0x70, 0xDB, 0x0C, 0x40, 0x4C, 0x0C, 0x77, 0x60,
  0xBC, 0x03, 0x50, 0x9C, 0x0C, 0x01, 0x77, 0x20, 0x10, 0xBC, 0x08, 0x70, 0xCC, 0x0E, 0x04, 0x77,
  0x03, 0x0D, 0xC0, 0xB7, 0x10, 0x10, 0xCD, 0x0B, 0x03, 0x73, 0x02, 0x0A, 0xD0, 0xC7, 0x30, 0x10,
  0xCE, 0x82, 0xC7, 0x42, 0x28, 0x21, 0x37, 0xBE, 0x0B, 0x01, 0x75, 0x09, 0xFF, 0xE0, 0x87, 0x71,
  0x04, 0x0C, 0xFF, 0xA0, 0xC0, 0x47, 0x74, 0x05, 0x0B, 0xFD, 0x0B, 0x04, 0x77, 0x71, 0x89, 0x22,
  0x6A, 0xCD, 0xFE, 0xDB, 0x95, 0x17, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_upgrade 48x48, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_48_action_upgrade_data[] PROGMEM = {
  0x70, 0x05, 0x76, 0x07, 0xA0, 0x77, 0x40, 0x7C, 0x07, 0x72, 0x07, 0xE0, 0x77, 0x07, 0xF9, 0x07,
  0x50, 0x7F, 0xB0, 0x73, 0x05, 0xFD, 0x05, 0x20, 0x50, 0xEF, 0xB0, 0xE0, 0x57, 0xC7, 0x5C, 0x75,
  0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7,
  0x5C, 0x75, 0x0D, 0xA0, 0xD7, 0x58, 0x24, 0xDD, 0x48, 0x09, 0x82, 0x00, 0x40, 0xDF, 0xD8, 0x1D,
  0x4D, 0xFF, 0x00, 0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_upgrade() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(16, 8, 31, 39), Box(0, 0, 47, 47),
      ic_round_48_action_upgrade_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_verified 48x48, 4-bit Alpha,  RLE, 340 bytes.
static const unsigned char ic_round_48_action_verified_data[] PROGMEM = {
  0x77, 0x81, 0x2C, 0x67, 0x38, 0x16, 0xC2, 0x77, 0x77, 0x0A, 0xA8, 0x1E, 0x92, 0x48, 0x12, 0x9E,
  0xA0, 0xA7, 0x77, 0x60, 0x4E, 0x82, 0xB4, 0x4B, 0xE0, 0x47, 0x77, 0x50, 0xDF, 0xFA, 0x0D, 0x77,
  0x74, 0x07, 0xFF, 0xC0, 0x77, 0x77, 0x20, 0x10, 0xEF, 0xFC, 0x0E, 0x01, 0x77, 0x68, 0x12, 0x6C,
  0xFF, 0xE8, 0x1B, 0x62, 0x76, 0x83, 0x14, 0x8B, 0xEF, 0xFF, 0xD8, 0x2E, 0xA7, 0x37, 0x20, 0xBF,
  0xFF, 0xFE, 0x0B, 0x71, 0x0A, 0xFF, 0xFF, 0xE0, 0xA7, 0x10, 0x8F, 0xFF, 0xFE, 0x08, 0x71, 0x07,
  0xFF, 0xFF, 0xE0, 0x77, 0x10, 0x5F, 0xFF, 0xFE, 0x06, 0x71, 0x04, 0xFF, 0xFB, 0x0A, 0x0B, 0xF9,
  0x04, 0x71, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0x20, 0x6F, 0x03, 0x71, 0x04, 0xFF, 0xF0, 0xE0, 0x34,
  0xF0, 0x47, 0x02, 0x0E, 0xFF, 0xE0, 0xE0, 0x34, 0x02, 0xF0, 0xE0, 0x25, 0x01, 0x0D, 0xFF, 0xE0,
  0xE0, 0x34, 0x01, 0x0C, 0xF9, 0x0D, 0x01, 0x40, 0xCF, 0xFE, 0x0E, 0x03, 0x40, 0x10, 0xCF, 0xB0,
  0xC3, 0x0A, 0xFF, 0xE0, 0xE0, 0x34, 0x01, 0x0C, 0xFD, 0x81, 0xA0, 0x8F, 0xC8, 0x1E, 0xBD, 0xE0,
  0xE0, 0x34, 0x01, 0x0C, 0xFF, 0x00, 0x8F, 0xB0, 0xD0, 0x12, 0x0B, 0xC0, 0xE0, 0x34, 0x01, 0x0C,
  0xFF, 0x98, 0x18, 0x0A, 0xFA, 0x07, 0x40, 0xBA, 0x0E, 0x03, 0x40, 0x10, 0xCF, 0xF9, 0x0A, 0x30,
  0xCF, 0x90, 0x95, 0x81, 0xBE, 0x34, 0x01, 0x0C, 0xFF, 0x90, 0xC4, 0x01, 0x0D, 0xF9, 0x04, 0x50,
  0x34, 0x01, 0x0C, 0xFF, 0x90, 0xD0, 0x15, 0x02, 0x0E, 0xF9, 0x04, 0x72, 0x0C, 0xFF, 0x90, 0xE0,
  0x27, 0x04, 0xFA, 0x04, 0x70, 0xCF, 0xFA, 0x04, 0x71, 0x03, 0xFB, 0x04, 0x50, 0xCF, 0xFB, 0x03,
  0x71, 0x04, 0xFC, 0x04, 0x30, 0xCF, 0xFC, 0x04, 0x71, 0x06, 0xFD, 0x81, 0x86, 0xDF, 0xFD, 0x06,
  0x71, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x10, 0x8F, 0xFF, 0xFE, 0x08, 0x71, 0x0A, 0xFF, 0xFF, 0xE0,
  0xA7, 0x10, 0xBF, 0xFF, 0xFE, 0x0B, 0x72, 0x82, 0x47, 0xBE, 0xFF, 0xFD, 0x82, 0xEA, 0x73, 0x77,
  0x81, 0x26, 0xCF, 0xFE, 0x81, 0xB6, 0x27, 0x76, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x17, 0x77, 0x20,
  0x7F, 0xFC, 0x07, 0x77, 0x74, 0x0D, 0xFF, 0xA0, 0xD7, 0x77, 0x50, 0x4E, 0x82, 0xA4, 0x4A, 0xE0,
  0x47, 0x77, 0x60, 0xAA, 0x81, 0xE8, 0x24, 0x81, 0x28, 0xEA, 0x0A, 0x77, 0x77, 0x81, 0x2C, 0x67,
  0x38, 0x16, 0xC1, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_verified() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 45, 44), Box(0, 0, 47, 47),
      ic_round_48_action_verified_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_verified_user 48x48, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_round_48_action_verified_user_data[] PROGMEM = {
  0x77, 0x28, 0x24, 0x88, 0x47, 0x77, 0x72, 0x06, 0x0D, 0xC0, 0xD0, 0x67, 0x77, 0x48, 0x11, 0x8E,
  0xF9, 0x81, 0xE8, 0x17, 0x76, 0x03, 0x0A, 0xFF, 0x0A, 0x03, 0x77, 0x20, 0x50, 0xCF, 0xFC, 0x0C,
  0x05, 0x75, 0x06, 0x0D, 0xFF, 0xF9, 0x0D, 0x06, 0x78, 0x11, 0x8E, 0xFF, 0xFD, 0x81, 0xE8, 0x13,
  0x07, 0xFF, 0xFF, 0xC8, 0x17, 0x05, 0xFF, 0xFF, 0xE0, 0x50, 0xCF, 0xFF, 0xFE, 0x0C, 0x80, 0xAC,
  0x5F, 0x82, 0xC2, 0x19, 0xFF, 0xFF, 0xB0, 0xC4, 0x0E, 0xFF, 0xFF, 0x90, 0xC5, 0x0E, 0xFF, 0xFF,
  0x0C, 0x50, 0x8F, 0xFF, 0xF0, 0xC5, 0x08, 0xFF, 0xFF, 0x0C, 0x50, 0x8F, 0xA0, 0xEF, 0xFC, 0x0C,
  0x50, 0x8F, 0xA0, 0xE0, 0xDF, 0xFB, 0x0C, 0x50, 0x8F, 0xB0, 0xD0, 0xCE, 0x82, 0x80, 0x2C, 0xE0,
  0xC5, 0x08, 0xFC, 0x0C, 0x0A, 0xD0, 0xE3, 0x01, 0x0C, 0xC0, 0xC5, 0x08, 0xFD, 0x0A, 0x08, 0xD0,
  0xE5, 0x0C, 0xA0, 0xC5, 0x08, 0xFE, 0x08, 0x04, 0xE0, 0x85, 0x00, 0xC5, 0x08, 0xFF, 0x04, 0x1F,
  0x07, 0x73, 0x08, 0xFF, 0x92, 0x0C, 0xF0, 0x77, 0x10, 0x8F, 0xF9, 0x0C, 0x20, 0x7F, 0x90, 0x76,
  0x08, 0xFF, 0xA0, 0x72, 0x01, 0x0E, 0xF9, 0x07, 0x40, 0x8F, 0xFA, 0x0E, 0x01, 0x30, 0x9F, 0xA0,
  0x82, 0x08, 0xFF, 0xB0, 0x94, 0x02, 0xFB, 0x00, 0xEF, 0xFC, 0x02, 0x50, 0x9F, 0xFF, 0xF0, 0x97,
  0x0D, 0xFF, 0xFD, 0x0D, 0x71, 0x05, 0xFF, 0xFD, 0x05, 0x72, 0x09, 0xFF, 0xFB, 0x09, 0x74, 0x0B,
  0xFF, 0xF9, 0x0B, 0x76, 0x0C, 0xFF, 0xE0, 0xC7, 0x70, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x77, 0x20,
  0xAF, 0xFA, 0x0A, 0x77, 0x50, 0x7F, 0xF0, 0x77, 0x77, 0x02, 0x0A, 0xFB, 0x0A, 0x02, 0x77, 0x73,
  0x04, 0x0C, 0xE0, 0xC0, 0x47, 0x77, 0x78, 0x42, 0x7C, 0xC7, 0x27, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_verified_user() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_round_48_action_verified_user_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_vertical_split 48x48, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_48_action_vertical_split_data[] PROGMEM = {
  0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xD8, 0x1D, 0x4D, 0xFF, 0x0D, 0x40, 0xDF, 0xF0,
  0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x4F, 0xFA, 0x77, 0x6F, 0xFA, 0x77,
  0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x4F, 0xFA, 0x0D,
  0xFF, 0x0D, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x4F, 0xFA,
  0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x04, 0x0D, 0xFD, 0x0D,
  0x04, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x04, 0x0D, 0xFD,
  0x0D, 0x04, 0x4F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA, 0x77, 0x6F, 0xFA,
  0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x0D, 0xFF, 0x0D, 0x40,
  0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04, 0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_vertical_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_vertical_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_agenda 48x48, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_48_action_view_agenda_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCB, 0x4F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF,
  0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x18, 0x0A,
  0x96, 0x08, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF,
  0xFF, 0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCB, 0x4F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF,
  0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_agenda() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_view_agenda_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_array 48x48, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_round_48_action_view_array_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xD0, 0x42, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x42, 0x04, 0x0D, 0xA8, 0x1D, 0x4D,
  0xC0, 0xD2, 0x0D, 0xFF, 0xC0, 0xD2, 0x0D, 0xC0, 0xDE, 0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xFD,
  0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xFD, 0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xFD, 0x2F, 0xFE,
  0x2F, 0xD2, 0xFF, 0xE2, 0xFD, 0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xFD, 0x2F, 0xFE, 0x2F, 0xD2,
  0xFF, 0xE2, 0xFD, 0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xFD, 0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2,
  0xFD, 0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xFD, 0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xFD, 0x2F,
  0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xFD, 0x2F, 0xFE, 0x2F, 0xD2, 0xFF, 0xE2, 0xE0, 0xDC, 0x0D, 0x20,
  0xDF, 0xFC, 0x0D, 0x20, 0xDC, 0x81, 0xD4, 0xDA, 0x0D, 0x04, 0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04,
  0x20, 0x40, 0xDA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_array() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_view_array_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_carousel 48x48, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_round_48_action_view_carousel_data[] PROGMEM = {
  0x73, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x47, 0x76, 0x0D, 0xFF, 0xC0, 0xD7, 0x76, 0xFF, 0xE7, 0x76,
  0xFF, 0xE7, 0x30, 0x40, 0xDC, 0x0D, 0x04, 0x2F, 0xFE, 0x20, 0x40, 0xDC, 0x81, 0xD4, 0xDE, 0x0D,
  0x2F, 0xFE, 0x20, 0xDE, 0x0D, 0xF9, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE,
  0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE,
  0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE,
  0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0xFA, 0x2F, 0xFE,
  0x2F, 0xFA, 0x2F, 0xFE, 0x2F, 0x90, 0xDE, 0x0D, 0x2F, 0xFE, 0x20, 0xDE, 0x81, 0xD4, 0xDC, 0x0D,
  0x04, 0x2F, 0xFE, 0x20, 0x40, 0xDC, 0x0D, 0x04, 0x73, 0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x76, 0x0D,
  0xFF, 0xC0, 0xD7, 0x76, 0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x47, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_carousel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_round_48_action_view_carousel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_column 48x48, 4-bit Alpha,  RLE, 229 bytes.
static const unsigned char ic_round_48_action_view_column_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xB0, 0x12, 0x08, 0x0E, 0xE0, 0xE0, 0x82, 0x01, 0x0B, 0xF8, 0x1D, 0x4D, 0xFA,
  0x81, 0x80, 0x3F, 0xB8, 0x13, 0x08, 0xFA, 0x0D, 0xFB, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF,
  0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8,
  0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A,
  0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04,
  0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB,
  0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81,
  0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50,
  0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF,
  0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE,
  0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81,
  0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0,
  0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xB0, 0xDF, 0xA8, 0x18,
  0x03, 0xFB, 0x81, 0x30, 0x8F, 0xA8, 0x1D, 0x4D, 0xF0, 0xB0, 0x12, 0x08, 0x0E, 0xE0, 0xE0, 0x82,
  0x01, 0x0B, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_column() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_view_column_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_comfy_alt 48x48, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_round_48_action_view_comfy_alt_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xA6, 0xF0, 0x36, 0x03, 0xC0, 0x36, 0x03, 0xFF,
  0xE7, 0x1C, 0x71, 0xFF, 0xE7, 0x1C, 0x71, 0xFF, 0xE7, 0x1C, 0x71, 0xFF, 0xE7, 0x1C, 0x71, 0xFF,
  0xE7, 0x1C, 0x71, 0xFF, 0xE7, 0x1C, 0x71, 0xFF, 0xE0, 0x36, 0x03, 0xC0, 0x36, 0x03, 0x80, 0xAE,
  0x0F, 0x03, 0x60, 0x3C, 0x03, 0x60, 0x3F, 0xFE, 0x71, 0xC7, 0x1F, 0xFE, 0x71, 0xC7, 0x1F, 0xFE,
  0x71, 0xC7, 0x1F, 0xFE, 0x71, 0xC7, 0x1F, 0xFE, 0x71, 0xC7, 0x1F, 0xFE, 0x71, 0xC7, 0x1F, 0xFE,
  0x03, 0x60, 0x3C, 0x03, 0x60, 0x38, 0x09, 0xA6, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2,
  0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_comfy_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_view_comfy_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_compact_alt 48x48, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_round_48_action_view_compact_alt_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xF7, 0xF0, 0x36, 0x03, 0xA0, 0x36, 0x03, 0xFF,
  0xF9, 0x71, 0xA7, 0x1F, 0xFF, 0x97, 0x1A, 0x71, 0xFF, 0xF9, 0x71, 0xA7, 0x1F, 0xFF, 0x97, 0x1A,
  0x71, 0xFF, 0xF9, 0x71, 0xA7, 0x1F, 0xFF, 0x97, 0x1A, 0x71, 0xFF, 0xF9, 0x03, 0x60, 0x3A, 0x03,
  0x60, 0x38, 0x09, 0xC2, 0xF0, 0x36, 0x03, 0xA0, 0x36, 0x03, 0xFF, 0xF9, 0x71, 0xA7, 0x1F, 0xFF,
  0x97, 0x1A, 0x71, 0xFF, 0xF9, 0x71, 0xA7, 0x1F, 0xFF, 0x97, 0x1A, 0x71, 0xFF, 0xF9, 0x71, 0xA7,
  0x1F, 0xFF, 0x97, 0x1A, 0x71, 0xFF, 0xF9, 0x03, 0x60, 0x3A, 0x03, 0x60, 0x38, 0x09, 0xF7, 0xF0,
  0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A,
  0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_compact_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_view_compact_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_cozy 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_48_action_view_cozy_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xA6, 0xF0, 0xE0, 0x88, 0x01, 0x70, 0x80, 0xEA,
  0x0E, 0x08, 0x80, 0x17, 0x08, 0x0E, 0xFF, 0xE0, 0x87, 0x08, 0xA0, 0x87, 0x08, 0xFF, 0xE0, 0x77,
  0x07, 0xA0, 0x77, 0x07, 0xFF, 0xE0, 0x77, 0x07, 0xA0, 0x77, 0x07, 0xFF, 0xE0, 0x77, 0x07, 0xA0,
  0x77, 0x07, 0xFF, 0xE0, 0x77, 0x07, 0xA0, 0x77, 0x07, 0xFF, 0xE0, 0x77, 0x07, 0xA0, 0x77, 0x07,
  0xFF, 0xE0, 0x87, 0x08, 0xA0, 0x87, 0x08, 0xFF, 0xE0, 0xE0, 0x88, 0x01, 0x70, 0x80, 0xEA, 0x0E,
  0x08, 0x80, 0x17, 0x08, 0x0E, 0x80, 0x9C, 0x0F, 0x0E, 0x08, 0x80, 0x17, 0x08, 0x0E, 0xA0, 0xE0,
  0x88, 0x01, 0x70, 0x80, 0xEF, 0xFE, 0x08, 0x70, 0x8A, 0x08, 0x70, 0x8F, 0xFE, 0x07, 0x70, 0x7A,
  0x07, 0x70, 0x7F, 0xFE, 0x07, 0x70, 0x7A, 0x07, 0x70, 0x7F, 0xFE, 0x07, 0x70, 0x7A, 0x07, 0x70,
  0x7F, 0xFE, 0x07, 0x70, 0x7A, 0x07, 0x70, 0x7F, 0xFE, 0x07, 0x70, 0x7A, 0x07, 0x70, 0x7F, 0xFE,
  0x08, 0x70, 0x8A, 0x08, 0x70, 0x8F, 0xFE, 0x0E, 0x08, 0x80, 0x17, 0x08, 0x0E, 0xA0, 0xE0, 0x88,
  0x01, 0x70, 0x80, 0xE8, 0x09, 0xA6, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A,
  0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_cozy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_view_cozy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_day 48x48, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_48_action_view_day_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D, 0x80, 0xC0, 0xF0, 0xD8, 0x09, 0x90, 0xF0, 0xD8, 0x0C,
  0x0F, 0x81, 0xD4, 0xDF, 0xFF, 0xFE, 0x0D, 0x04, 0x80, 0xAA, 0x40, 0x04, 0x0D, 0xFF, 0xFF, 0xE8,
  0x1D, 0x4D, 0x80, 0xC0, 0xF0, 0xD8, 0x0F, 0x84, 0xF0, 0xD8, 0x0C, 0x0F, 0x81, 0xD4, 0xDF, 0xFF,
  0xFE, 0x0D, 0x04, 0x80, 0xAA, 0x40, 0x04, 0x0D, 0xFF, 0xFF, 0xE8, 0x1D, 0x4D, 0x80, 0xC0, 0xF0,
  0xD8, 0x09, 0x90, 0xF0, 0xD8, 0x0C, 0x0F, 0x81, 0xD4, 0xDF, 0xFF, 0xFE, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_day() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_view_day_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_headline 48x48, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_48_action_view_headline_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF,
  0xFF, 0xF0, 0xD0, 0x48, 0x09, 0xF4, 0x00, 0x40, 0xDF, 0xFF, 0xF8, 0x1D, 0x4D, 0xFF, 0xFF, 0xA0,
  0x0D, 0xFF, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xFF, 0x0D, 0x04, 0x80, 0x9F, 0x40, 0x04, 0x0D, 0xFF,
  0xFF, 0x81, 0xD4, 0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x81, 0xD4, 0xDF, 0xFF, 0xF0, 0xD0,
  0x48, 0x09, 0xF4, 0x00, 0x40, 0xDF, 0xFF, 0xF8, 0x1D, 0x4D, 0xFF, 0xFF, 0xA0, 0x0D, 0xFF, 0xFF,
  0xA8, 0x1D, 0x4D, 0xFF, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_headline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 10, 39, 37), Box(0, 0, 47, 47),
      ic_round_48_action_view_headline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_in_ar 48x48, 4-bit Alpha,  RLE, 382 bytes.
static const unsigned char ic_round_48_action_view_in_ar_data[] PROGMEM = {
  0x38, 0x16, 0xCE, 0xA0, 0xD0, 0x47, 0x77, 0x30, 0x40, 0xDA, 0x81, 0xEC, 0x64, 0x01, 0x0C, 0xE0,
  0xD7, 0x77, 0x30, 0xDE, 0x0C, 0x01, 0x20, 0xCF, 0x0D, 0x77, 0x73, 0x0D, 0xF8, 0x1C, 0x06, 0xF0,
  0xD0, 0x47, 0x77, 0x30, 0x40, 0xDF, 0x06, 0x0C, 0xB0, 0xB0, 0x17, 0x77, 0x74, 0x01, 0x0B, 0xB0,
  0xC0, 0xEB, 0x01, 0x77, 0x77, 0x60, 0x1B, 0x0E, 0xC7, 0x72, 0x82, 0x26, 0x62, 0x77, 0x2F, 0x97,
  0x70, 0x20, 0xAC, 0x0A, 0x01, 0x77, 0xC0, 0xDA, 0x0D, 0x76, 0x08, 0xF9, 0x08, 0x76, 0x0D, 0xA8,
  0x3D, 0x4D, 0xD4, 0x74, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x74, 0x82, 0x4D, 0xD4, 0x76, 0x03, 0x0C,
  0xE0, 0x0C, 0xE0, 0xC0, 0x37, 0x77, 0x30, 0x10, 0xAE, 0x0D, 0x05, 0x20, 0x50, 0xDE, 0x09, 0x01,
  0x77, 0x70, 0x70, 0xEE, 0x07, 0x60, 0x7E, 0x0E, 0x07, 0x77, 0x50, 0xCE, 0x0A, 0x01, 0x71, 0x01,
  0x0A, 0xE0, 0xC7, 0x73, 0x08, 0xD0, 0xC0, 0x37, 0x50, 0x30, 0xCD, 0x08, 0x77, 0x20, 0xDD, 0x0A,
  0x02, 0x75, 0x02, 0x0A, 0xD0, 0xD7, 0x72, 0xF9, 0x08, 0x73, 0x08, 0xF9, 0x77, 0x2F, 0xA0, 0xD0,
  0x56, 0x05, 0x0D, 0xFA, 0x77, 0x2C, 0x0B, 0xE0, 0xB0, 0x32, 0x03, 0x0B, 0xE0, 0xBC, 0x77, 0x2C,
  0x10, 0x50, 0xDE, 0x00, 0x9E, 0x0D, 0x05, 0x1C, 0x77, 0x2C, 0x30, 0x7F, 0xD0, 0x73, 0xC7, 0x72,
  0xC4, 0x02, 0x0A, 0xF9, 0x0A, 0x02, 0x4C, 0x77, 0x2C, 0x60, 0x40, 0xCC, 0x0C, 0x04, 0x6C, 0x77,
  0x2C, 0x71, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x1C, 0x77, 0x2C,
  0x71, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x1C, 0x77, 0x20, 0xDB, 0x0E, 0x06, 0x6C, 0x60, 0x60,
  0xEB, 0x0D, 0x77, 0x20, 0x8D, 0x0C, 0x03, 0x4C, 0x40, 0x30, 0xCD, 0x08, 0x77, 0x30, 0xCE, 0x0A,
  0x02, 0x2C, 0x20, 0x20, 0xAE, 0x0C, 0x77, 0x50, 0x70, 0xEE, 0x08, 0x1C, 0x10, 0x8E, 0x0E, 0x07,
  0x77, 0x70, 0x10, 0x9E, 0x0D, 0xC0, 0xDE, 0x09, 0x01, 0x77, 0x73, 0x03, 0x0C, 0xFF, 0x0C, 0x03,
  0x76, 0x82, 0x4D, 0xD4, 0x74, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x74, 0x83, 0x4D, 0xD4, 0xDA, 0x0D,
  0x76, 0x08, 0xF9, 0x08, 0x76, 0x0D, 0xA0, 0xDC, 0x77, 0x01, 0x0A, 0xC0, 0xA0, 0x17, 0x7F, 0x97,
  0x72, 0x82, 0x26, 0x62, 0x77, 0x2C, 0x0E, 0xB0, 0x17, 0x77, 0x76, 0x01, 0xB0, 0xE0, 0xCB, 0x0B,
  0x01, 0x77, 0x77, 0x40, 0x10, 0xBB, 0x0C, 0x06, 0xF0, 0xD0, 0x47, 0x77, 0x30, 0x40, 0xDF, 0x81,
  0x60, 0xCF, 0x0D, 0x77, 0x73, 0x0D, 0xF0, 0xC2, 0x01, 0x0C, 0xE0, 0xD7, 0x77, 0x30, 0xDE, 0x0C,
  0x01, 0x48, 0x16, 0xCE, 0xA0, 0xD0, 0x47, 0x77, 0x30, 0x40, 0xDA, 0x81, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_in_ar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_view_in_ar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_kanban 48x48, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_round_48_action_view_kanban_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAA, 0x4F, 0x82, 0xB1, 0x1B, 0xC8, 0x2B, 0x11, 0xBC,
  0x82, 0xB1, 0x1B, 0xFF, 0xA0, 0x12, 0x01, 0xC0, 0x12, 0x01, 0xC0, 0x12, 0x01, 0xFF, 0xA4, 0xC4,
  0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4,
  0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC0, 0x12, 0x01, 0xC4, 0xFF, 0xA4, 0xC8, 0x2B, 0x11,
  0xBC, 0x4F, 0xFA, 0x4F, 0xD4, 0xFF, 0xA4, 0xFD, 0x4F, 0xFA, 0x4F, 0xD4, 0xFF, 0xA4, 0xFD, 0x4F,
  0xFA, 0x4F, 0xD0, 0x12, 0x01, 0xFF, 0xA4, 0xFD, 0x82, 0xB1, 0x1B, 0xFF, 0xA4, 0xFF, 0xFF, 0xC4,
  0xFF, 0xFF, 0xC0, 0x12, 0x01, 0xFF, 0xFF, 0xC8, 0x2B, 0x11, 0xB8, 0x0A, 0xC4, 0xF0, 0xDF, 0xFF,
  0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF,
  0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_kanban() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_view_kanban_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_list 48x48, 4-bit Alpha,  RLE, 149 bytes.
static const unsigned char ic_round_48_action_view_list_data[] PROGMEM = {
  0x04, 0x0D, 0xC0, 0xD0, 0x42, 0x04, 0x0D, 0xFF, 0xF9, 0x81, 0xD4, 0xDE, 0x0D, 0x20, 0xDF, 0xFF,
  0xB0, 0xDF, 0x92, 0xFF, 0xFF, 0xE2, 0xFF, 0xFF, 0xE2, 0xFF, 0xFF, 0xE2, 0xFF, 0xFD, 0x0D, 0xE0,
  0xD2, 0x0D, 0xFF, 0xFB, 0x81, 0xD4, 0xDC, 0x0D, 0x04, 0x20, 0x40, 0xDF, 0xFF, 0x90, 0xD0, 0x48,
  0x09, 0x84, 0x00, 0x40, 0xDC, 0x0D, 0x04, 0x20, 0x40, 0xDF, 0xFF, 0x98, 0x1D, 0x4D, 0xE0, 0xD2,
  0x0D, 0xFF, 0xFB, 0x0D, 0xF9, 0x2F, 0xFF, 0xFE, 0x2F, 0xFF, 0xFE, 0x2F, 0xFF, 0xFE, 0x2F, 0xFF,
  0xD0, 0xDE, 0x0D, 0x20, 0xDF, 0xFF, 0xB8, 0x1D, 0x4D, 0xC0, 0xD0, 0x42, 0x04, 0x0D, 0xFF, 0xF9,
  0x0D, 0x04, 0x80, 0x98, 0x40, 0x04, 0x0D, 0xC0, 0xD0, 0x42, 0x04, 0x0D, 0xFF, 0xF9, 0x81, 0xD4,
  0xDE, 0x0D, 0x20, 0xDF, 0xFF, 0xB0, 0xDF, 0x92, 0xFF, 0xFF, 0xE2, 0xFF, 0xFF, 0xE2, 0xFF, 0xFF,
  0xE2, 0xFF, 0xFD, 0x0D, 0xE0, 0xD2, 0x0D, 0xFF, 0xFB, 0x81, 0xD4, 0xDC, 0x0D, 0x04, 0x20, 0x40,
  0xDF, 0xFF, 0x90, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_view_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_module 48x48, 4-bit Alpha,  RLE, 235 bytes.
static const unsigned char ic_round_48_action_view_module_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xB0, 0x12, 0x08, 0x0E, 0xE0, 0xE0, 0x82, 0x01, 0x0B, 0xF8, 0x1D, 0x4D, 0xFA,
  0x81, 0x80, 0x3F, 0xB8, 0x13, 0x08, 0xFA, 0x0D, 0xFB, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF,
  0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8,
  0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A,
  0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04,
  0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFB, 0x0D, 0xFA, 0x81, 0x80,
  0x3F, 0xB8, 0x13, 0x08, 0xFA, 0x81, 0xD4, 0xDF, 0x0B, 0x01, 0x20, 0x80, 0xEE, 0x0E, 0x08, 0x20,
  0x10, 0xBF, 0x0D, 0x04, 0x80, 0x98, 0x40, 0x04, 0x0D, 0xF0, 0xB0, 0x12, 0x08, 0x0E, 0xE0, 0xE0,
  0x82, 0x01, 0x0B, 0xF8, 0x1D, 0x4D, 0xFA, 0x81, 0x80, 0x3F, 0xB8, 0x13, 0x08, 0xFA, 0x0D, 0xFB,
  0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81,
  0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0,
  0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F,
  0xB8, 0x15, 0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8,
  0x15, 0x0A, 0xFB, 0x0D, 0xFA, 0x81, 0x80, 0x3F, 0xB8, 0x13, 0x08, 0xFA, 0x81, 0xD4, 0xDF, 0x0B,
  0x01, 0x20, 0x80, 0xEE, 0x0E, 0x08, 0x20, 0x10, 0xBF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_module() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_view_module_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_quilt 48x48, 4-bit Alpha,  RLE, 198 bytes.
static const unsigned char ic_round_48_action_view_quilt_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xB0, 0x12, 0x08, 0x0E, 0xFF, 0xD8, 0x1D, 0x4D, 0xFA, 0x81, 0x80, 0x3F, 0xFF,
  0x90, 0xDF, 0xB8, 0x1A, 0x05, 0xFF, 0xFF, 0xD8, 0x1A, 0x05, 0xFF, 0xFF, 0xD8, 0x1A, 0x05, 0xFF,
  0xFF, 0xD8, 0x1A, 0x05, 0xFF, 0xFF, 0xD8, 0x1A, 0x05, 0xFF, 0xFF, 0xD8, 0x1A, 0x05, 0xFF, 0xFF,
  0xD8, 0x1A, 0x05, 0xFF, 0xFF, 0xD8, 0x1A, 0x05, 0xFF, 0xFF, 0xD8, 0x1A, 0x05, 0xFF, 0xFF, 0xD8,
  0x1A, 0x03, 0xFF, 0xF9, 0x0D, 0xFB, 0x0A, 0x20, 0x80, 0xEF, 0xFD, 0x0D, 0x04, 0xFB, 0x0A, 0x77,
  0x74, 0xFB, 0x0A, 0x77, 0x74, 0xFB, 0x0A, 0x20, 0x80, 0xEE, 0x0E, 0x08, 0x20, 0x10, 0xBF, 0x0D,
  0x04, 0xFB, 0x81, 0xA0, 0x3F, 0xB8, 0x13, 0x08, 0xFA, 0x0D, 0xFB, 0x81, 0xA0, 0x4F, 0xB8, 0x15,
  0x0A, 0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A,
  0xFF, 0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF,
  0xE8, 0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFF, 0xE8,
  0x1A, 0x04, 0xFB, 0x81, 0x50, 0xAF, 0xFE, 0x81, 0xA0, 0x4F, 0xB8, 0x15, 0x0A, 0xFB, 0x0D, 0xFA,
  0x81, 0x80, 0x3F, 0xB8, 0x13, 0x08, 0xFA, 0x81, 0xD4, 0xDF, 0x0B, 0x01, 0x20, 0x80, 0xEE, 0x0E,
  0x08, 0x20, 0x10, 0xBF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_quilt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_view_quilt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_sidebar 48x48, 4-bit Alpha,  RLE, 144 bytes.
static const unsigned char ic_round_48_action_view_sidebar_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x40, 0x40, 0xDC, 0x81, 0xD4, 0xDF, 0xFF, 0xD0, 0xD4, 0x0D,
  0xE0, 0xDF, 0xFF, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4,
  0x0D, 0xE0, 0xDF, 0xFF, 0xF4, 0x04, 0x0D, 0xC0, 0xD0, 0x4F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F,
  0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF4, 0x04, 0x0D, 0xC0, 0xD0, 0x4F, 0xFF, 0xF4, 0x0D,
  0xE0, 0xDF, 0xFF, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4,
  0x0D, 0xE0, 0xDF, 0xFF, 0xF4, 0x04, 0x0D, 0xC0, 0xD0, 0x4F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F,
  0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF4, 0x04, 0x0D, 0xC0, 0xD0, 0x4F, 0xFF, 0xF4, 0x0D,
  0xE0, 0xDF, 0xFF, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0xF9, 0x0D, 0xFF,
  0xFD, 0x0D, 0x40, 0xDE, 0x81, 0xD4, 0xDF, 0xFF, 0xB0, 0xD0, 0x44, 0x04, 0x0D, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_sidebar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_view_sidebar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_stream 48x48, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_48_action_view_stream_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xA9, 0x4F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF,
  0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x18, 0x0A,
  0x96, 0x08, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF,
  0xFF, 0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xA9, 0x4F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF,
  0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_stream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_round_48_action_view_stream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_timeline 48x48, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_round_48_action_view_timeline_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAB, 0x6F, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xFF, 0xFB,
  0x01, 0x73, 0x01, 0xFF, 0xFB, 0x01, 0x73, 0x01, 0xFF, 0xFB, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0x80,
  0xAB, 0x6F, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xFF, 0xFB, 0x01, 0x73, 0x01, 0xFF, 0xFB, 0x01, 0x73,
  0x01, 0xFF, 0xFB, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0x80, 0xAB, 0x6F, 0x0B, 0x01, 0x71, 0x01, 0x0B,
  0xFF, 0xFB, 0x01, 0x73, 0x01, 0xFF, 0xFB, 0x01, 0x73, 0x01, 0xFF, 0xFB, 0x0B, 0x01, 0x71, 0x01,
  0x0B, 0x80, 0xAB, 0x6F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF,
  0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_timeline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_view_timeline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_view_week 48x48, 4-bit Alpha,  RLE, 275 bytes.
static const unsigned char ic_round_48_action_view_week_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xB0, 0xC0, 0x77, 0x81, 0x4B, 0xEA, 0x81, 0xEB, 0x47, 0x07, 0x0C, 0xB8, 0x4D,
  0xA1, 0x01, 0xEF, 0x0A, 0x50, 0x5F, 0x90, 0x55, 0x0A, 0xF8, 0x1E, 0x1A, 0xFA, 0x04, 0x40, 0xEF,
  0x90, 0xE4, 0x04, 0xFA, 0x0A, 0x0D, 0xFA, 0x08, 0x30, 0x3F, 0xB0, 0x33, 0x08, 0xFA, 0x0D, 0xFB,
  0x0A, 0x30, 0x4F, 0xB0, 0x53, 0x0A, 0xFF, 0xE0, 0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A,
  0x30, 0x4F, 0xB0, 0x53, 0x0A, 0xFF, 0xE0, 0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30,
  0x4F, 0xB0, 0x53, 0x0A, 0xFF, 0xE0, 0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F,
  0xB0, 0x53, 0x0A, 0xFF, 0xE0, 0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F, 0xB0,
  0x53, 0x0A, 0xFF, 0xE0, 0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F, 0xB0, 0x53,
  0x0A, 0xFF, 0xE0, 0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F, 0xB0, 0x53, 0x0A,
  0xFF, 0xE0, 0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F, 0xB0, 0x53, 0x0A, 0xFF,
  0xE0, 0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F, 0xB0, 0x53, 0x0A, 0xFF, 0xE0,
  0xA3, 0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F, 0xB0, 0x53, 0x0A, 0xFF, 0xE0, 0xA3,
  0x04, 0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F, 0xB0, 0x53, 0x0A, 0xFF, 0xE0, 0xA3, 0x04,
  0xFB, 0x05, 0x30, 0xAF, 0xFE, 0x0A, 0x30, 0x4F, 0xB0, 0x53, 0x0A, 0xFF, 0xE0, 0xA3, 0x04, 0xFB,
  0x05, 0x30, 0xAF, 0xB0, 0xDF, 0xA0, 0x83, 0x03, 0xFB, 0x03, 0x30, 0x8F, 0xA0, 0xD0, 0xAF, 0xA0,
  0x44, 0x0E, 0xF9, 0x0E, 0x40, 0x4F, 0xA8, 0x1A, 0x1E, 0xF0, 0xA5, 0x05, 0xF9, 0x05, 0x50, 0xAF,
  0x84, 0xE1, 0x01, 0xAD, 0xB0, 0xC0, 0x77, 0x81, 0x4B, 0xEA, 0x81, 0xEB, 0x47, 0x07, 0x0C, 0xB8,
  0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_view_week() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_view_week_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_visibility_off 48x48, 4-bit Alpha,  RLE, 365 bytes.
static const unsigned char ic_round_48_action_visibility_off_data[] PROGMEM = {
  0x40, 0x30, 0x18, 0x0C, 0x50, 0x0A, 0xA0, 0x68, 0x0C, 0x30, 0x01, 0xC0, 0x68, 0x0C, 0x30, 0x0E,
  0xC0, 0x67, 0x83, 0x48, 0xBC, 0xDA, 0x83, 0xDC, 0xB8, 0x47, 0x75, 0x03, 0x0E, 0xC0, 0x65, 0x0C,
  0xFE, 0x0B, 0x05, 0x77, 0x30, 0x30, 0xEC, 0x06, 0x40, 0x10, 0xCF, 0xF0, 0xE0, 0x87, 0x72, 0x03,
  0x0E, 0xC0, 0x64, 0x01, 0x0C, 0xFF, 0x90, 0xD0, 0x57, 0x71, 0x03, 0x0E, 0xC0, 0x64, 0x01, 0x0C,
  0xFF, 0xA0, 0xB0, 0x17, 0x60, 0x30, 0xED, 0x06, 0x48, 0x11, 0x52, 0x28, 0x12, 0x5A, 0xFB, 0x0D,
  0x02, 0x74, 0x04, 0x0E, 0xF0, 0x67, 0x40, 0x20, 0xAF, 0xA0, 0xE0, 0x47, 0x20, 0x3F, 0xB0, 0x67,
  0x50, 0x7F, 0xA0, 0xE0, 0x37, 0x02, 0x0E, 0xFC, 0x06, 0x75, 0x07, 0xFA, 0x0E, 0x02, 0x60, 0xDF,
  0xE0, 0x65, 0x08, 0x05, 0x50, 0xAF, 0xA0, 0xD5, 0x09, 0xFB, 0x0E, 0xC0, 0x64, 0x82, 0x1C, 0xB1,
  0x30, 0x2F, 0xB0, 0x83, 0x03, 0xFB, 0x81, 0xA4, 0xEC, 0x06, 0x48, 0x11, 0xCB, 0x40, 0xAF, 0xB0,
  0x32, 0x0C, 0xFB, 0x82, 0x50, 0x4E, 0xC0, 0x64, 0x81, 0x1C, 0x53, 0x05, 0xFB, 0x81, 0xC0, 0x4F,
  0xC0, 0x22, 0x04, 0xD0, 0x64, 0x01, 0x08, 0x30, 0x2F, 0xC0, 0x40, 0xBF, 0xC4, 0x0E, 0xD0, 0x67,
  0x2F, 0xC0, 0x0B, 0xFC, 0x40, 0xEE, 0x06, 0x71, 0xFC, 0x0B, 0x04, 0xFC, 0x02, 0x30, 0xCF, 0x06,
  0x60, 0x2F, 0xC8, 0x14, 0x0C, 0xFB, 0x05, 0x30, 0x6F, 0x90, 0x65, 0x05, 0xFB, 0x0C, 0x20, 0x3F,
  0xB0, 0xA4, 0x0C, 0xF9, 0x06, 0x40, 0x10, 0xCF, 0xA0, 0x33, 0x08, 0xFB, 0x02, 0x30, 0x10, 0xCF,
  0x90, 0x64, 0x01, 0x0C, 0xF0, 0x95, 0x0D, 0xFA, 0x0A, 0x58, 0x26, 0xCE, 0xED, 0x06, 0x40, 0x10,
  0xCD, 0x0C, 0x60, 0x20, 0xEF, 0xA0, 0x77, 0x10, 0x30, 0xEC, 0x06, 0x40, 0x10, 0xCB, 0x0E, 0x02,
  0x70, 0x30, 0xEF, 0xA0, 0x77, 0x10, 0x30, 0xEC, 0x06, 0x48, 0x31, 0xCF, 0xE3, 0x72, 0x04, 0x0E,
  0xFA, 0x0A, 0x02, 0x70, 0x30, 0xEC, 0x06, 0x48, 0x11, 0xB3, 0x74, 0x02, 0x0D, 0xFB, 0x81, 0xA5,
  0x22, 0x81, 0x25, 0xBE, 0x06, 0x77, 0x40, 0x10, 0xBF, 0xFF, 0xB0, 0x67, 0x75, 0x05, 0x0D, 0xFF,
  0xFA, 0x06, 0x77, 0x60, 0x80, 0xEF, 0xFF, 0x90, 0x67, 0x77, 0x05, 0x0B, 0xFF, 0x81, 0xB7, 0xEC,
  0x06, 0x77, 0x72, 0x83, 0x48, 0xBC, 0xDA, 0x84, 0xED, 0xA8, 0x41, 0x20, 0x40, 0xEC, 0x06, 0x80,
  0xC2, 0x00, 0x40, 0xEC, 0x06, 0x80, 0xC2, 0x00, 0x40, 0xEC, 0x03, 0x80, 0xC2, 0x00, 0x40, 0xEB,
  0x06, 0x80, 0xC3, 0x08, 0x34, 0xEF, 0xE1, 0x80, 0xC4, 0x08, 0x11, 0x51, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_visibility_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 45, 42), Box(0, 0, 47, 47),
      ic_round_48_action_visibility_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_visibility 48x48, 4-bit Alpha,  RLE, 292 bytes.
static const unsigned char ic_round_48_action_visibility_data[] PROGMEM = {
  0x77, 0x28, 0x34, 0x8B, 0xCD, 0xA8, 0x3D, 0xCB, 0x84, 0x77, 0x77, 0x10, 0x50, 0xBF, 0xF0, 0xB0,
  0x57, 0x77, 0x30, 0x80, 0xEF, 0xFC, 0x0E, 0x08, 0x77, 0x60, 0x50, 0xDF, 0xFF, 0x90, 0xD0, 0x57,
  0x72, 0x01, 0x0B, 0xFF, 0xFD, 0x0B, 0x01, 0x76, 0x02, 0x0D, 0xFB, 0x81, 0xA5, 0x22, 0x81, 0x25,
  0xAF, 0xB0, 0xD0, 0x27, 0x40, 0x40, 0xEF, 0xA0, 0xA0, 0x27, 0x10, 0x20, 0xAF, 0xA0, 0xE0, 0x47,
  0x20, 0x30, 0xEF, 0xA0, 0x77, 0x50, 0x7F, 0xA0, 0xE0, 0x37, 0x02, 0x0E, 0xFA, 0x07, 0x77, 0x07,
  0xFA, 0x0E, 0x02, 0x60, 0xDF, 0xA0, 0xA5, 0x84, 0x6C, 0xEE, 0xC6, 0x50, 0xAF, 0xA0, 0xD5, 0x08,
  0xFB, 0x02, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x30, 0x2F, 0xB0, 0x83, 0x03, 0xFB, 0x0A, 0x40, 0xCF,
  0x90, 0xC4, 0x0A, 0xFB, 0x03, 0x20, 0xCF, 0xB0, 0x53, 0x06, 0xFB, 0x06, 0x30, 0x5F, 0xB8, 0x1C,
  0x04, 0xFC, 0x02, 0x30, 0xCF, 0xB0, 0xC3, 0x02, 0xFC, 0x04, 0x0B, 0xFC, 0x40, 0xEF, 0xB0, 0xE4,
  0xFC, 0x00, 0xBF, 0xC4, 0x0E, 0xFB, 0x0E, 0x4F, 0xC0, 0xB0, 0x4F, 0xC0, 0x23, 0x0C, 0xFB, 0x0C,
  0x30, 0x2F, 0xC8, 0x14, 0x0C, 0xFB, 0x05, 0x30, 0x6F, 0xB0, 0x63, 0x05, 0xFB, 0x0C, 0x20, 0x3F,
  0xB0, 0xA4, 0x0C, 0xF9, 0x0C, 0x40, 0xAF, 0xB0, 0x33, 0x08, 0xFB, 0x02, 0x30, 0x10, 0xCE, 0x0C,
  0x01, 0x30, 0x2F, 0xB0, 0x85, 0x0D, 0xFA, 0x0A, 0x58, 0x46, 0xCE, 0xEC, 0x65, 0x0A, 0xFA, 0x0D,
  0x60, 0x20, 0xEF, 0xA0, 0x77, 0x70, 0x7F, 0xA0, 0xE0, 0x27, 0x03, 0x0E, 0xFA, 0x07, 0x75, 0x07,
  0xFA, 0x0E, 0x03, 0x72, 0x04, 0x0E, 0xFA, 0x0A, 0x02, 0x71, 0x02, 0x0A, 0xFA, 0x0E, 0x04, 0x74,
  0x02, 0x0D, 0xFB, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAF, 0xB0, 0xD0, 0x27, 0x60, 0x10, 0xBF, 0xFF,
  0xD0, 0xB0, 0x17, 0x72, 0x05, 0x0D, 0xFF, 0xF9, 0x0D, 0x05, 0x77, 0x60, 0x80, 0xEF, 0xFC, 0x0E,
  0x08, 0x77, 0x73, 0x05, 0x0B, 0xFF, 0x0B, 0x05, 0x77, 0x77, 0x18, 0x34, 0x8B, 0xCD, 0xA8, 0x3D,
  0xCB, 0x84, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_visibility() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 37), Box(0, 0, 47, 47),
      ic_round_48_action_visibility_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_voice_over_off 48x48, 4-bit Alpha,  RLE, 349 bytes.
static const unsigned char ic_round_48_action_voice_over_off_data[] PROGMEM = {
  0x80, 0xC0, 0x08, 0x24, 0xCC, 0x47, 0x30, 0x60, 0x47, 0x77, 0x60, 0x1C, 0x03, 0x71, 0x0C, 0xA0,
  0x97, 0x77, 0x50, 0x4C, 0x0C, 0x70, 0x1C, 0x09, 0x77, 0x74, 0x01, 0x0E, 0xC0, 0x77, 0x0D, 0xC0,
  0x97, 0x77, 0x40, 0x6C, 0x0E, 0x70, 0x20, 0xDC, 0x09, 0x58, 0x17, 0x82, 0x77, 0x30, 0xCC, 0x06,
  0x70, 0x20, 0xDC, 0x09, 0x58, 0x1A, 0xF8, 0x77, 0x20, 0x5C, 0x0C, 0x71, 0x02, 0x0D, 0xC0, 0x95,
  0x81, 0xAF, 0xB7, 0x82, 0x3B, 0xD7, 0x50, 0xEC, 0x01, 0x71, 0x02, 0x0E, 0xC0, 0x95, 0x81, 0xAF,
  0x86, 0x0E, 0xB0, 0x64, 0x09, 0xC0, 0x57, 0x10, 0x2E, 0x09, 0x58, 0x1A, 0xF2, 0x40, 0x3C, 0x0C,
  0x40, 0x5C, 0x09, 0x71, 0x08, 0xF0, 0x95, 0x0A, 0x08, 0x40, 0x1D, 0x03, 0x30, 0x2C, 0x0B, 0x71,
  0x0C, 0xF9, 0x09, 0x50, 0x75, 0x0C, 0xC0, 0x53, 0x01, 0xC0, 0xD7, 0x10, 0xEF, 0xA0, 0x97, 0x30,
  0x9C, 0x07, 0x4C, 0x0E, 0x71, 0x0E, 0xFB, 0x09, 0x72, 0x09, 0xC0, 0x74, 0xC0, 0xE7, 0x10, 0xCF,
  0xC0, 0x97, 0x10, 0xCC, 0x06, 0x30, 0x1C, 0x0D, 0x71, 0x08, 0xFD, 0x09, 0x7D, 0x03, 0x30, 0x3C,
  0x0C, 0x71, 0x02, 0xFE, 0x09, 0x6C, 0x0D, 0x40, 0x6C, 0x0A, 0x72, 0x08, 0xFE, 0x09, 0x50, 0x9B,
  0x07, 0x40, 0xAC, 0x06, 0x73, 0x0B, 0xFE, 0x09, 0x58, 0x15, 0x74, 0x40, 0x1D, 0x02, 0x74, 0x08,
  0xF9, 0x0E, 0xC0, 0x97, 0x40, 0x6C, 0x0D, 0x76, 0x89, 0x02, 0x8C, 0xEE, 0xC8, 0x22, 0xDC, 0x09,
  0x73, 0x0D, 0xC0, 0x67, 0x77, 0x10, 0x20, 0xDC, 0x09, 0x71, 0x07, 0xC0, 0xE0, 0x17, 0x77, 0x20,
  0x20, 0xDC, 0x09, 0x70, 0xEC, 0x07, 0x77, 0x74, 0x02, 0x0D, 0xC0, 0x96, 0xC0, 0xD7, 0x77, 0x60,
  0x20, 0xDC, 0x09, 0x50, 0x9A, 0x0E, 0x03, 0x75, 0x84, 0x14, 0x8A, 0xCD, 0xA8, 0x4E, 0xCA, 0x74,
  0x12, 0x02, 0x0D, 0xC0, 0x95, 0x81, 0x47, 0x27, 0x38, 0x12, 0x7C, 0xFF, 0x83, 0xC7, 0x22, 0xDC,
  0x09, 0x77, 0x10, 0x40, 0xBF, 0xFE, 0x81, 0xB5, 0xDC, 0x09, 0x75, 0x01, 0x0B, 0xFF, 0xFB, 0x0D,
  0xD0, 0x97, 0x30, 0x40, 0xEF, 0xFF, 0xFC, 0x09, 0x71, 0x02, 0x0E, 0xFF, 0xFF, 0xE0, 0x97, 0x0A,
  0xFF, 0xFF, 0xA0, 0xC0, 0xDC, 0x09, 0x60, 0xEF, 0xFF, 0xFA, 0x81, 0xE2, 0xDC, 0x09, 0x5F, 0xFF,
  0xFC, 0x10, 0x20, 0xDC, 0x04, 0x4F, 0xFF, 0xFC, 0x20, 0x20, 0xDB, 0x05, 0x40, 0xDF, 0xFF, 0xFA,
  0x0D, 0x38, 0x22, 0xDF, 0xC5, 0x04, 0x0D, 0xFF, 0xFF, 0x0D, 0x04, 0x50, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_voice_over_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 45, 41), Box(0, 0, 47, 47),
      ic_round_48_action_voice_over_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_watch_later 48x48, 4-bit Alpha,  RLE, 260 bytes.
static const unsigned char ic_round_48_action_watch_later_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x08, 0xFF, 0xC0, 0x80, 0x17, 0x73, 0x04, 0x0E, 0xFF, 0xE0, 0xE0, 0x47, 0x71,
  0x08, 0xFF, 0xFB, 0x08, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x08,
  0xFF, 0xFF, 0xA0, 0x87, 0x04, 0xFF, 0xFF, 0xC0, 0x45, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x08, 0xFF, 0x98, 0x17, 0x07, 0xFF, 0xA0, 0x83, 0x01, 0xFF, 0xA3, 0xFF, 0xB0, 0x12, 0x07, 0xFF,
  0xA3, 0xFF, 0xB0, 0x72, 0x0D, 0xFF, 0xA3, 0xFF, 0xB8, 0x1D, 0x03, 0xFF, 0xB3, 0xFF, 0xC0, 0x30,
  0x7F, 0xFB, 0x3F, 0xFC, 0x07, 0x0A, 0xFF, 0xB3, 0xFF, 0xC0, 0xA0, 0xCF, 0xFB, 0x3F, 0xFC, 0x0C,
  0x0E, 0xFF, 0xB3, 0xFF, 0xC0, 0xEF, 0xFC, 0x38, 0x0C, 0x1F, 0x30, 0xAF, 0xFC, 0x0E, 0xFF, 0xB0,
  0x23, 0x04, 0x0D, 0xFF, 0x90, 0xE0, 0xCF, 0xFB, 0x0C, 0x01, 0x40, 0x7F, 0xF0, 0xC0, 0xAF, 0xFC,
  0x0E, 0x07, 0x40, 0x20, 0xBF, 0xD0, 0xA0, 0x7F, 0xFE, 0x0C, 0x03, 0x40, 0x40, 0xDF, 0xB0, 0x70,
  0x3F, 0xFF, 0x90, 0x90, 0x14, 0x0D, 0xFA, 0x81, 0x30, 0xDF, 0xFF, 0x90, 0xE0, 0x53, 0x09, 0xF9,
  0x0D, 0x20, 0x7F, 0xFF, 0xB8, 0x2B, 0x45, 0xEF, 0x90, 0x72, 0x01, 0x80, 0xC0, 0xF0, 0x13, 0x08,
  0xFF, 0xFF, 0xE0, 0x84, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x15, 0x04, 0xFF, 0xFF, 0xC0, 0x47,
  0x08, 0xFF, 0xFF, 0xA0, 0x87, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60,
  0x8F, 0xFF, 0xB0, 0x87, 0x71, 0x04, 0x0E, 0xFF, 0xE0, 0xE0, 0x47, 0x73, 0x01, 0x08, 0xFF, 0xC0,
  0x80, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83,
  0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_watch_later() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_round_48_action_watch_later_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_webhook 48x48, 4-bit Alpha,  RLE, 376 bytes.
static const unsigned char ic_round_48_action_webhook_data[] PROGMEM = {
  0x77, 0x38, 0x65, 0x9D, 0xEE, 0xDA, 0x57, 0x77, 0x72, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x76,
  0x08, 0xFD, 0x08, 0x77, 0x74, 0x08, 0xFF, 0x08, 0x77, 0x72, 0x04, 0xD8, 0x48, 0x30, 0x13, 0x9D,
  0x05, 0x77, 0x71, 0x0D, 0xB0, 0xD0, 0x36, 0x03, 0x0E, 0xB0, 0xD7, 0x77, 0x05, 0xC0, 0x37, 0x10,
  0x3C, 0x05, 0x77, 0x60, 0x9B, 0x08, 0x38, 0x28, 0xDD, 0x83, 0x09, 0xB0, 0x97, 0x76, 0x0D, 0xB0,
  0x32, 0x08, 0xC0, 0x82, 0x02, 0xB0, 0x97, 0x76, 0x0E, 0xB3, 0x0D, 0xC0, 0xD3, 0x82, 0x7E, 0xC1,
  0x77, 0x60, 0xEB, 0x01, 0x20, 0xEC, 0x0E, 0x77, 0x76, 0x0D, 0xB0, 0x32, 0x08, 0xD0, 0x47, 0x77,
  0x50, 0xAB, 0x09, 0x30, 0x80, 0xEB, 0x0D, 0x77, 0x75, 0x05, 0xC0, 0x33, 0x03, 0xC0, 0x77, 0x77,
  0x50, 0xDB, 0x0D, 0x03, 0x30, 0x9B, 0x0E, 0x01, 0x77, 0x74, 0x04, 0xD0, 0x42, 0x01, 0x0E, 0xB0,
  0xA7, 0x77, 0x50, 0x8C, 0x0C, 0x30, 0x6C, 0x04, 0x77, 0x74, 0x01, 0xC0, 0x94, 0x0C, 0xB0, 0xD7,
  0x77, 0x40, 0xAB, 0x0E, 0x01, 0x40, 0x3C, 0x84, 0xDE, 0xED, 0x95, 0x73, 0x82, 0x4C, 0xC3, 0x40,
  0x4C, 0x06, 0x60, 0x9F, 0xA0, 0xD0, 0x47, 0x07, 0xB0, 0xD4, 0x0D, 0xB0, 0xC7, 0x01, 0x0E, 0xFB,
  0x08, 0x50, 0x7C, 0x0D, 0x30, 0x7C, 0x03, 0x71, 0x05, 0xFC, 0x08, 0x30, 0x4D, 0x04, 0x20, 0x10,
  0xEB, 0x09, 0x73, 0x81, 0x47, 0x32, 0x03, 0x08, 0xD0, 0x42, 0x0D, 0xB0, 0xD0, 0x33, 0x0A, 0xB0,
  0xE0, 0x17, 0x73, 0x03, 0x0D, 0xB8, 0x1D, 0x04, 0xC0, 0x33, 0x04, 0xC0, 0x67, 0x75, 0x03, 0xC0,
  0x50, 0x9B, 0x09, 0x30, 0x80, 0xEB, 0x0C, 0x77, 0x82, 0x8D, 0xD8, 0x30, 0x8B, 0x09, 0x0C, 0xB0,
  0x32, 0x08, 0xD0, 0x32, 0x06, 0x0E, 0xFF, 0x08, 0x20, 0x3B, 0x0D, 0x0E, 0xB0, 0x12, 0x0E, 0xC0,
  0xE3, 0x0E, 0xFF, 0x90, 0xD3, 0xB0, 0x0E, 0xB3, 0x0D, 0xC0, 0xD2, 0x01, 0xFF, 0xA0, 0xD3, 0xB0,
  0xE0, 0xDB, 0x03, 0x20, 0x8C, 0x08, 0x20, 0x4F, 0xFA, 0x08, 0x20, 0x3B, 0x0D, 0x09, 0xB0, 0x83,
  0x82, 0x8D, 0xD8, 0x30, 0x9B, 0x0A, 0x71, 0x82, 0x8D, 0xD8, 0x30, 0x8B, 0x09, 0x05, 0xC0, 0x27,
  0x10, 0x3C, 0x05, 0x77, 0x03, 0xC8, 0x15, 0x0D, 0xB0, 0xE0, 0x36, 0x03, 0x0E, 0xB0, 0xD7, 0x70,
  0x30, 0xDB, 0x0D, 0x20, 0x4D, 0x84, 0x93, 0x01, 0x38, 0xD0, 0x55, 0x87, 0x3D, 0xD8, 0x31, 0x03,
  0x8D, 0x04, 0x30, 0x8F, 0xF0, 0x86, 0x0B, 0xFD, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x0B, 0xFC, 0x08,
  0x70, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x10, 0x30, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE,
  0xD9, 0x57, 0x58, 0x64, 0xAC, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_webhook() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_webhook_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_width_full 48x48, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_48_action_width_full_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F,
  0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F,
  0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F,
  0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F,
  0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F,
  0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xF9, 0x2F,
  0xFF, 0xF2, 0xF9, 0x2F, 0xFF, 0xF2, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A,
  0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_width_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_width_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_width_normal 48x48, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_round_48_action_width_normal_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9,
  0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA,
  0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97,
  0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7,
  0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71,
  0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71,
  0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F,
  0xFA, 0x71, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8,
  0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_width_normal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_width_normal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_width_wide 48x48, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_48_action_width_wide_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A,
  0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_width_wide() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_round_48_action_width_wide_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_wifi_protected_setup 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_48_action_wifi_protected_setup_data[] PROGMEM = {
  0x77, 0x0B, 0xFD, 0x0E, 0x05, 0x77, 0x3F, 0xF0, 0x57, 0x73, 0xFE, 0x07, 0x77, 0x4F, 0xD0, 0x77,
  0x75, 0xFC, 0x0A, 0x77, 0x6F, 0xD0, 0x57, 0x40, 0x47, 0xFE, 0x03, 0x72, 0x81, 0xBF, 0x46, 0xFE,
  0x0D, 0x01, 0x70, 0x8A, 0x04, 0x6F, 0xF0, 0x96, 0x04, 0xB0, 0x16, 0xFF, 0x90, 0x25, 0x0D, 0xB7,
  0xFF, 0x90, 0xA4, 0x06, 0xB0, 0xE7, 0xC0, 0xA0, 0xEF, 0xB0, 0x13, 0x0D, 0xB0, 0xE7, 0xB8, 0x27,
  0x02, 0xEF, 0xA0, 0x62, 0x02, 0xD7, 0xA0, 0x73, 0x02, 0x0E, 0xF9, 0x0A, 0x20, 0x7D, 0x02, 0x60,
  0x05, 0x50, 0x4F, 0x90, 0xD2, 0x0B, 0xD0, 0x57, 0x70, 0x8F, 0x92, 0x0D, 0xD0, 0xA7, 0x71, 0x0D,
  0xF2, 0xE0, 0xE7, 0x71, 0x06, 0xF0, 0x01, 0xF0, 0x67, 0x71, 0x0E, 0xE2, 0xF0, 0xD7, 0x71, 0x0A,
  0xD0, 0xD2, 0xF9, 0x08, 0x77, 0x05, 0xD0, 0xB2, 0x0D, 0xF9, 0x04, 0x50, 0x05, 0x60, 0x2D, 0x07,
  0x20, 0xAF, 0x90, 0xE0, 0x23, 0x81, 0x7F, 0xE7, 0xD0, 0x22, 0x06, 0xFA, 0x82, 0xE2, 0x07, 0xB7,
  0x0E, 0xB0, 0xD3, 0x01, 0xFB, 0x0E, 0x09, 0xC7, 0x0E, 0xB0, 0x64, 0x0A, 0xFF, 0x97, 0xB0, 0xD5,
  0x03, 0xFF, 0x96, 0x01, 0xB0, 0x46, 0x0A, 0xFF, 0x60, 0x4A, 0x08, 0x70, 0x10, 0xEF, 0xE6, 0x81,
  0x4F, 0xB7, 0x20, 0x3F, 0xE7, 0x04, 0x74, 0x05, 0xFD, 0x77, 0x60, 0xAF, 0xC7, 0x75, 0x07, 0xFD,
  0x77, 0x40, 0x7F, 0xE7, 0x73, 0x05, 0xFF, 0x77, 0x30, 0x5F, 0xE0, 0xB7, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_wifi_protected_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 39, 41), Box(0, 0, 47, 47),
      ic_round_48_action_wifi_protected_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_work_history 48x48, 4-bit Alpha,  RLE, 273 bytes.
static const unsigned char ic_round_48_action_work_history_data[] PROGMEM = {
  0x76, 0x81, 0x1A, 0xEF, 0x98, 0x1E, 0xA1, 0x77, 0x76, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x75,
  0x0A, 0xFF, 0x0A, 0x77, 0x75, 0x0D, 0xFF, 0x0D, 0x77, 0x75, 0xC7, 0x1C, 0x77, 0x75, 0xC7, 0x1C,
  0x77, 0x75, 0xC7, 0x1C, 0x77, 0x75, 0xC7, 0x1C, 0x77, 0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x1E,
  0xA1, 0x30, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x20, 0x98, 0x0C, 0x2F, 0x0A, 0x20, 0xD8, 0x0C,
  0x2F, 0x0D, 0x28, 0x0C, 0x4F, 0x28, 0x0C, 0x4F, 0x28, 0x0C, 0x4F, 0x28, 0x0C, 0x4F, 0x28, 0x0C,
  0x4F, 0x28, 0x0C, 0x4F, 0x2F, 0xFF, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x13, 0x7B, 0xB2, 0xFF, 0xFC,
  0x0A, 0x02, 0x73, 0x02, 0x09, 0x92, 0xFF, 0xFA, 0x0D, 0x03, 0x77, 0x03, 0x2F, 0xFF, 0x90, 0xB0,
  0x17, 0x74, 0xFF, 0xF0, 0xB6, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x6F, 0xFE, 0x0D, 0x01, 0x40, 0x40,
  0xDF, 0x90, 0xD0, 0x44, 0xFF, 0xE0, 0x34, 0x08, 0xFD, 0x08, 0x3F, 0xFD, 0x0A, 0x40, 0x8F, 0xF0,
  0x82, 0xFF, 0xD0, 0x23, 0x04, 0xF2, 0xF0, 0x41, 0xFF, 0xC0, 0xC4, 0x0D, 0xF2, 0xF0, 0xD1, 0xFF,
  0xC0, 0x73, 0x05, 0xF9, 0x2F, 0x90, 0x5F, 0xFC, 0x03, 0x30, 0x9F, 0x92, 0xF9, 0x09, 0xFF, 0xC0,
  0x23, 0x0D, 0xF9, 0x2F, 0x90, 0xDF, 0xFC, 0x40, 0xEF, 0x92, 0x0E, 0xF0, 0xEF, 0xFC, 0x40, 0xEF,
  0x98, 0x22, 0x02, 0xEE, 0x0E, 0xFF, 0xC0, 0x13, 0x0D, 0xF9, 0x83, 0xE2, 0x02, 0xED, 0x00, 0xDF,
  0xFB, 0x03, 0x30, 0x9F, 0xA8, 0x3E, 0x20, 0x2E, 0xC0, 0x90, 0xAF, 0xFB, 0x07, 0x30, 0x5F, 0xB8,
  0x2E, 0x20, 0x9C, 0x81, 0x51, 0xEF, 0xFA, 0x0B, 0x40, 0xDF, 0xB0, 0xE0, 0x9C, 0x0D, 0x28, 0x11,
  0xAE, 0xFF, 0x90, 0x23, 0x04, 0xFF, 0xA0, 0x47, 0x77, 0x40, 0x8F, 0xF0, 0x87, 0x77, 0x60, 0x8F,
  0xD0, 0x87, 0x77, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x77, 0x48, 0x65, 0x9D, 0xEE, 0xD9,
  0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_work_history() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_work_history_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_work_off 48x48, 4-bit Alpha,  RLE, 268 bytes.
static const unsigned char ic_round_48_action_work_off_data[] PROGMEM = {
  0x18, 0x11, 0x65, 0x72, 0x81, 0x2A, 0xEF, 0x98, 0x1E, 0xA1, 0x77, 0x20, 0xDA, 0x09, 0x70, 0x20,
  0xEF, 0xD0, 0xE0, 0x17, 0x70, 0x2C, 0x09, 0x60, 0x9F, 0xF0, 0xA7, 0x71, 0x0C, 0xC0, 0x95, 0x0A,
  0xFF, 0x0D, 0x77, 0x10, 0x10, 0xDC, 0x09, 0x50, 0xAA, 0x71, 0xC7, 0x72, 0x01, 0x0D, 0xC0, 0x95,
  0x0A, 0x97, 0x1C, 0x77, 0x30, 0x20, 0xDC, 0x09, 0x50, 0xA7, 0x1C, 0x77, 0x40, 0x20, 0xDC, 0x09,
  0x76, 0xC7, 0x71, 0x81, 0x1A, 0xEF, 0x09, 0x50, 0xAF, 0xFC, 0x81, 0xEA, 0x13, 0x01, 0x0E, 0xFB,
  0x09, 0x50, 0xAF, 0xFD, 0x0E, 0x01, 0x20, 0x9F, 0xD0, 0x95, 0x0A, 0xFF, 0xD0, 0xA2, 0x0D, 0xFE,
  0x09, 0x50, 0xAF, 0xFC, 0x0D, 0x2F, 0xF9, 0x09, 0x50, 0xAF, 0xFC, 0x2F, 0xFA, 0x09, 0x50, 0xAF,
  0xFB, 0x2F, 0xFB, 0x09, 0x50, 0xAF, 0xFA, 0x2F, 0xFC, 0x09, 0x50, 0xAF, 0xF9, 0x2F, 0xFD, 0x09,
  0x50, 0xAF, 0xF2, 0xFF, 0xE0, 0x95, 0x0A, 0xFE, 0x2F, 0xFF, 0x09, 0x50, 0xAF, 0xD2, 0xFF, 0xF9,
  0x09, 0x50, 0xAF, 0xC2, 0xFF, 0xFA, 0x09, 0x50, 0xAF, 0xB2, 0xFF, 0xFB, 0x09, 0x50, 0xAF, 0xA2,
  0xFF, 0xFC, 0x09, 0x50, 0xAF, 0x92, 0xFF, 0xFD, 0x09, 0x50, 0xAF, 0x2F, 0xFF, 0xE0, 0x95, 0x0A,
  0xE2, 0xFF, 0xFF, 0x09, 0x50, 0xAD, 0x2F, 0xFF, 0xF9, 0x09, 0x50, 0xAC, 0x2F, 0xFF, 0xFA, 0x09,
  0x50, 0xAB, 0x2F, 0xFF, 0xFB, 0x09, 0x50, 0xAA, 0x2F, 0xFF, 0xFC, 0x09, 0x50, 0xA9, 0x2F, 0xFF,
  0xFD, 0x09, 0x50, 0xA2, 0xFF, 0xFF, 0xE0, 0x97, 0xFF, 0xFF, 0xF0, 0x96, 0x80, 0xC0, 0xF0, 0x95,
  0x0D, 0x80, 0xC0, 0xF0, 0x94, 0x0A, 0x80, 0xC1, 0xF0, 0x93, 0x01, 0x0E, 0x80, 0xC1, 0xF0, 0x93,
  0x81, 0x1A, 0xE8, 0x0C, 0x0F, 0x09, 0x80, 0xC0, 0x00, 0x20, 0xDC, 0x04, 0x80, 0xC0, 0x00, 0x20,
  0xDB, 0x06, 0x80, 0xC1, 0x08, 0x22, 0xDF, 0xC8, 0x0C, 0x40, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_work_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 45, 45), Box(0, 0, 47, 47),
      ic_round_48_action_work_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_work_outline 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_round_48_action_work_outline_data[] PROGMEM = {
  0x76, 0x81, 0x1A, 0xEF, 0x98, 0x1E, 0xA1, 0x77, 0x74, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x73,
  0x0A, 0xFF, 0x0A, 0x77, 0x73, 0x0D, 0xFF, 0x0D, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C,
  0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x76, 0x81, 0x1A, 0xEF, 0xFF, 0xFC, 0x84, 0xEA,
  0x10, 0x1E, 0x80, 0xC0, 0xF8, 0x1E, 0x19, 0x80, 0xC2, 0xF0, 0xA0, 0xD8, 0x0C, 0x2F, 0x0D, 0xC0,
  0xB0, 0x17, 0x77, 0x70, 0x10, 0xBF, 0x90, 0x17, 0x77, 0x72, 0x01, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x01, 0x77, 0x77, 0x20, 0x1F,
  0x90, 0xB0, 0x17, 0x77, 0x70, 0x10, 0xBC, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81,
  0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAE, 0xFF, 0xFF, 0xC8, 0x1E, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_work_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_work_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_work 48x48, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_48_action_work_data[] PROGMEM = {
  0x76, 0x81, 0x1A, 0xEF, 0x98, 0x1E, 0xA1, 0x77, 0x74, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x73,
  0x0A, 0xFF, 0x0A, 0x77, 0x73, 0x0D, 0xFF, 0x0D, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C,
  0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x76, 0x81, 0x1A, 0xEF, 0xFF, 0xFC, 0x84, 0xEA,
  0x10, 0x1E, 0x80, 0xC0, 0xF8, 0x1E, 0x19, 0x80, 0xC2, 0xF0, 0xA0, 0xD8, 0x0C, 0x2F, 0x0D, 0x80,
  0x9D, 0xD4, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8,
  0x4E, 0x10, 0x1A, 0xEF, 0xFF, 0xFC, 0x81, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_work() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 41), Box(0, 0, 47, 47),
      ic_round_48_action_work_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_wysiwyg 48x48, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_48_action_wysiwyg_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAA, 0x0F, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77,
  0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x40, 0x40, 0xDF, 0xFA, 0x0D,
  0x04, 0x4F, 0x94, 0x0D, 0xFF, 0xC0, 0xD4, 0xF9, 0x40, 0xDF, 0xFC, 0x0D, 0x4F, 0x94, 0x04, 0x0D,
  0xFF, 0xA0, 0xD0, 0x44, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77,
  0xF9, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x5F, 0x94, 0x0D, 0xFB, 0x0D, 0x75, 0xF9, 0x40, 0xDF,
  0xB0, 0xD7, 0x5F, 0x94, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x75, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77,
  0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xC0, 0xDF, 0xFF, 0xFE,
  0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8,
  0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_wysiwyg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_round_48_action_wysiwyg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_youtube_searched_for 48x48, 4-bit Alpha,  RLE, 242 bytes.
static const unsigned char ic_round_48_action_youtube_searched_for_data[] PROGMEM = {
  0x76, 0x89, 0x01, 0x6A, 0xCE, 0xEC, 0xA7, 0x27, 0x77, 0x60, 0x20, 0xAF, 0xB0, 0xB0, 0x37, 0x77,
  0x30, 0x7F, 0xF0, 0x87, 0x77, 0x10, 0xAF, 0xFA, 0x0B, 0x77, 0x60, 0xAD, 0x81, 0xB6, 0x22, 0x81,
  0x26, 0xBD, 0x0B, 0x77, 0x40, 0x7C, 0x0D, 0x03, 0x71, 0x04, 0x0D, 0xC0, 0x97, 0x72, 0x02, 0x0E,
  0xB0, 0xB0, 0x17, 0x30, 0x10, 0xCC, 0x03, 0x77, 0x10, 0xAB, 0x0D, 0x01, 0x75, 0x01, 0x0D, 0xB0,
  0xB7, 0x70, 0x1C, 0x04, 0x77, 0x04, 0xC0, 0x27, 0x60, 0x6B, 0x0B, 0x77, 0x20, 0xBB, 0x07, 0x76,
  0x0A, 0xB0, 0x67, 0x72, 0x06, 0xB0, 0xB7, 0x60, 0xCB, 0x02, 0x77, 0x20, 0x2B, 0x0D, 0x76, 0x0E,
  0xB0, 0x17, 0x73, 0xB0, 0xE7, 0x10, 0xDF, 0xD0, 0xE0, 0x47, 0x5B, 0x0E, 0x71, 0x0D, 0xFE, 0x04,
  0x74, 0x02, 0xB0, 0xD7, 0x10, 0x10, 0xCF, 0xC0, 0x67, 0x50, 0x5B, 0x0A, 0x73, 0x09, 0xFA, 0x05,
  0x76, 0x0B, 0xB0, 0x77, 0x40, 0x7F, 0x05, 0x76, 0x03, 0xC0, 0x27, 0x50, 0x40, 0xEC, 0x04, 0x76,
  0x01, 0x0D, 0xB0, 0xB7, 0x78, 0x32, 0xCF, 0xE4, 0x76, 0x01, 0x0B, 0xC0, 0x37, 0x72, 0x07, 0x03,
  0x76, 0x03, 0x0D, 0xC0, 0x87, 0x77, 0x38, 0x15, 0x52, 0x28, 0x12, 0x6B, 0xE0, 0x17, 0x77, 0x20,
  0xAF, 0xFA, 0x08, 0x77, 0x7F, 0xD0, 0x80, 0x1C, 0x07, 0x77, 0x60, 0xCF, 0xA0, 0xB0, 0x32, 0xD0,
  0x77, 0x75, 0x89, 0x01, 0x7B, 0xDF, 0xED, 0xB7, 0x24, 0x07, 0xD0, 0x77, 0x77, 0x75, 0x07, 0xD0,
  0x77, 0x77, 0x75, 0x07, 0xD0, 0x77, 0x77, 0x75, 0x07, 0xD0, 0x77, 0x77, 0x75, 0x07, 0xD0, 0x77,
  0x77, 0x75, 0x07, 0xD0, 0x77, 0x77, 0x75, 0x06, 0xD7, 0x77, 0x76, 0x06, 0xC7, 0x77, 0x77, 0x82,
  0x6E, 0xF6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_youtube_searched_for() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 42, 39), Box(0, 0, 47, 47),
      ic_round_48_action_youtube_searched_for_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_zoom_in 48x48, 4-bit Alpha,  RLE, 241 bytes.
static const unsigned char ic_round_48_action_zoom_in_data[] PROGMEM = {
  0x71, 0x89, 0x02, 0x6A, 0xDD, 0xDD, 0xB7, 0x27, 0x77, 0x10, 0x30, 0xAF, 0xB0, 0xB0, 0x37, 0x75,
  0x08, 0xFF, 0x09, 0x77, 0x20, 0x10, 0xBF, 0xFA, 0x0B, 0x77, 0x10, 0xBD, 0x81, 0xB6, 0x22, 0x81,
  0x26, 0xBD, 0x0B, 0x76, 0x08, 0xC0, 0xD0, 0x37, 0x10, 0x30, 0xDC, 0x09, 0x74, 0x03, 0xC0, 0xB0,
  0x17, 0x30, 0x10, 0xBC, 0x03, 0x73, 0x0A, 0xB0, 0xD0, 0x17, 0x50, 0x10, 0xDB, 0x0B, 0x72, 0x02,
  0xC0, 0x36, 0x00, 0xB6, 0x03, 0xC0, 0x27, 0x10, 0x6B, 0x0B, 0x7A, 0x70, 0xBB, 0x07, 0x71, 0x0A,
  0xB0, 0x67, 0xA7, 0x06, 0xB0, 0xB7, 0x10, 0xDB, 0x02, 0x7A, 0x70, 0x2B, 0x0D, 0x71, 0x0E, 0xB4,
  0x0B, 0xF9, 0x0B, 0x4B, 0x0E, 0x71, 0x0E, 0xB4, 0x0B, 0xF9, 0x0B, 0x4B, 0x0E, 0x71, 0x0D, 0xB0,
  0x27, 0xA7, 0x02, 0xB0, 0xD7, 0x10, 0xBB, 0x06, 0x7A, 0x70, 0x6B, 0x0A, 0x71, 0x07, 0xB0, 0xB7,
  0xA7, 0x0B, 0xB0, 0x77, 0x10, 0x2C, 0x03, 0x60, 0x0B, 0x60, 0x3C, 0x02, 0x72, 0x0B, 0xB0, 0xD0,
  0x17, 0x50, 0x10, 0xDB, 0x0B, 0x73, 0x03, 0xC0, 0xB0, 0x17, 0x30, 0x10, 0xBC, 0x03, 0x74, 0x09,
  0xC0, 0xD0, 0x37, 0x10, 0x30, 0xDC, 0x08, 0x76, 0x0B, 0xD8, 0x1B, 0x62, 0x28, 0x12, 0x6B, 0xE0,
  0x17, 0x70, 0xBF, 0xFE, 0x07, 0x76, 0x09, 0xFF, 0x08, 0x01, 0xC0, 0x77, 0x60, 0x30, 0xBF, 0xB0,
  0xA0, 0x32, 0xD0, 0x77, 0x78, 0x90, 0x27, 0xBD, 0xDF, 0xDA, 0x71, 0x40, 0x7D, 0x07, 0x77, 0x77,
  0x07, 0xD0, 0x77, 0x77, 0x70, 0x7D, 0x07, 0x77, 0x77, 0x07, 0xD0, 0x77, 0x77, 0x70, 0x7D, 0x07,
  0x77, 0x77, 0x07, 0xD0, 0x67, 0x77, 0x70, 0x7D, 0x77, 0x77, 0x10, 0x7C, 0x77, 0x77, 0x20, 0x6A,
  0x06,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_zoom_in() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_zoom_in_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_48_action_zoom_out 48x48, 4-bit Alpha,  RLE, 238 bytes.
static const unsigned char ic_round_48_action_zoom_out_data[] PROGMEM = {
  0x71, 0x89, 0x02, 0x6A, 0xDD, 0xDD, 0xB7, 0x27, 0x77, 0x10, 0x30, 0xAF, 0xB0, 0xB0, 0x37, 0x75,
  0x08, 0xFF, 0x09, 0x77, 0x20, 0x10, 0xBF, 0xFA, 0x0B, 0x77, 0x10, 0xBD, 0x81, 0xB6, 0x22, 0x81,
  0x26, 0xBD, 0x0B, 0x76, 0x08, 0xC0, 0xD0, 0x37, 0x10, 0x30, 0xDC, 0x09, 0x74, 0x03, 0xC0, 0xB0,
  0x17, 0x30, 0x10, 0xBC, 0x03, 0x73, 0x0A, 0xB0, 0xD0, 0x17, 0x50, 0x10, 0xDB, 0x0B, 0x72, 0x02,
  0xC0, 0x37, 0x70, 0x3C, 0x02, 0x71, 0x07, 0xB0, 0xB7, 0x72, 0x0B, 0xB0, 0x77, 0x10, 0xAB, 0x06,
  0x77, 0x20, 0x6B, 0x0B, 0x71, 0x0D, 0xB0, 0x27, 0x72, 0x02, 0xB0, 0xD7, 0x10, 0xEB, 0x40, 0xBF,
  0x90, 0xB4, 0xB0, 0xE7, 0x10, 0xEB, 0x40, 0xBF, 0x90, 0xB4, 0xB0, 0xE7, 0x10, 0xDB, 0x02, 0x77,
  0x20, 0x2B, 0x0D, 0x71, 0x0B, 0xB0, 0x67, 0x72, 0x06, 0xB0, 0xA7, 0x10, 0x7B, 0x0B, 0x77, 0x20,
  0xBB, 0x07, 0x71, 0x02, 0xC0, 0x37, 0x70, 0x3C, 0x02, 0x72, 0x0B, 0xB0, 0xD0, 0x17, 0x50, 0x10,
  0xDB, 0x0B, 0x73, 0x03, 0xC0, 0xB0, 0x17, 0x30, 0x10, 0xBC, 0x03, 0x74, 0x09, 0xC0, 0xD0, 0x37,
  0x10, 0x30, 0xDC, 0x08, 0x76, 0x0B, 0xD8, 0x1B, 0x62, 0x28, 0x12, 0x6B, 0xE0, 0x17, 0x70, 0xBF,
  0xFE, 0x07, 0x76, 0x09, 0xFF, 0x08, 0x01, 0xC0, 0x77, 0x60, 0x30, 0xBF, 0xB0, 0xA0, 0x32, 0xD0,
  0x77, 0x78, 0x90, 0x27, 0xBD, 0xDF, 0xDA, 0x71, 0x40, 0x7D, 0x07, 0x77, 0x77, 0x07, 0xD0, 0x77,
  0x77, 0x70, 0x7D, 0x07, 0x77, 0x77, 0x07, 0xD0, 0x77, 0x77, 0x70, 0x7D, 0x07, 0x77, 0x77, 0x07,
  0xD0, 0x67, 0x77, 0x70, 0x7D, 0x77, 0x77, 0x10, 0x7C, 0x77, 0x77, 0x20, 0x6A, 0x06,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_48_action_zoom_out() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 39, 39), Box(0, 0, 47, 47),
      ic_round_48_action_zoom_out_data, Alpha4(color::Black));
  return value;
}
