#include "av.h"

using namespace roo_display;

// Image file ic_round_36_av_10k 36x36, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_round_36_av_10k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xA8, 0x29, 0x77, 0xBA, 0x84, 0xB7, 0x77, 0x79, 0xA0, 0xB0, 0x9A, 0x81,
  0xD8, 0xEB, 0x82, 0x77, 0xFC, 0x40, 0x0D, 0x60, 0x99, 0x28, 0x3C, 0xE2, 0x09, 0xB0, 0x07, 0xA0,
  0x50, 0x32, 0x00, 0xB2, 0x83, 0x33, 0x10, 0x79, 0x28, 0x3B, 0x50, 0x1E, 0xB0, 0x07, 0xC2, 0x00,
  0xB2, 0xA8, 0x13, 0x07, 0x92, 0x04, 0x20, 0xBC, 0x00, 0x7C, 0x20, 0x0B, 0x2A, 0x81, 0x30, 0x79,
  0x40, 0x7D, 0x00, 0x7C, 0x20, 0x0B, 0x2A, 0x81, 0x30, 0x79, 0x40, 0x7D, 0x00, 0x7C, 0x20, 0x0B,
  0x2A, 0x81, 0x30, 0x79, 0x20, 0x42, 0x0B, 0xC0, 0x07, 0xC2, 0x00, 0xB2, 0x83, 0x33, 0x10, 0x79,
  0x28, 0x3B, 0x50, 0x1E, 0xB0, 0x07, 0xC2, 0x0C, 0x0D, 0x60, 0x99, 0x28, 0x3C, 0xE2, 0x09, 0xB0,
  0x07, 0xC0, 0xB0, 0x9A, 0x84, 0xB7, 0x77, 0x79, 0xA0, 0xB0, 0x9A, 0x81, 0xD8, 0xEB, 0x00, 0x7F,
  0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x07, 0x04, 0xFF, 0xFD, 0x81, 0x40, 0x9F, 0xFF, 0xB0, 0x93, 0x04, 0x80, 0xA2,
  0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_10k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_10k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_1k_plus 36x36, 4-bit Alpha,  RLE, 187 bytes.
static const unsigned char ic_round_36_av_1k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x2B, 0x77, 0x9B, 0x09, 0x0B, 0xA0, 0xB0, 0x9F, 0xA0, 0x07, 0xC4,
  0x81, 0x9F, 0xC2, 0x90, 0xC2, 0x0D, 0xF9, 0x00, 0x7C, 0x85, 0x83, 0x10, 0x7F, 0xB2, 0x82, 0xE2,
  0x04, 0xA8, 0x1D, 0x1D, 0xC0, 0x07, 0xE8, 0x33, 0x07, 0xFB, 0x28, 0x24, 0x01, 0xEA, 0x81, 0xB0,
  0xBC, 0x00, 0x7E, 0x83, 0x30, 0x7F, 0xB4, 0x87, 0xBF, 0xB4, 0x20, 0x24, 0xBA, 0x00, 0x7E, 0x83,
  0x30, 0x7F, 0xB4, 0x87, 0xBF, 0xB4, 0x20, 0x24, 0xBA, 0x00, 0x7E, 0x83, 0x30, 0x7F, 0xB2, 0x82,
  0x40, 0x1E, 0xA8, 0x1B, 0x0B, 0xC0, 0x07, 0xE8, 0x33, 0x07, 0xFB, 0x28, 0x2E, 0x20, 0x4A, 0x81,
  0xD1, 0xDC, 0x00, 0x7E, 0x83, 0x40, 0x8F, 0xC2, 0x90, 0xC2, 0x0D, 0xF9, 0x00, 0x7E, 0x81, 0xD8,
  0xEA, 0x09, 0x0B, 0xA0, 0xB0, 0x9F, 0xA0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8,
  0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_1k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_1k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_1k 36x36, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_round_36_av_1k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x3E, 0x87, 0x8D, 0xB0, 0xB0, 0x9A, 0x81, 0xD8, 0xEE, 0x00, 0x7D,
  0x08, 0x30, 0x2B, 0x28, 0x3C, 0xE2, 0x09, 0xE0, 0x07, 0xD8, 0x1D, 0x42, 0x2B, 0x28, 0x3B, 0x50,
  0x1E, 0xE0, 0x07, 0xF0, 0xB2, 0xB2, 0x04, 0x20, 0xBF, 0x00, 0x7F, 0x0B, 0x2B, 0x40, 0x7F, 0x90,
  0x07, 0xF0, 0xB2, 0xB4, 0x07, 0xF9, 0x00, 0x7F, 0x0B, 0x2B, 0x20, 0x42, 0x0B, 0xF0, 0x07, 0xF0,
  0xB2, 0xB2, 0x83, 0xB5, 0x01, 0xEE, 0x00, 0x7F, 0x0C, 0x2B, 0x28, 0x3C, 0xE2, 0x09, 0xE0, 0x07,
  0xF9, 0x09, 0x0B, 0xB0, 0xB0, 0x9A, 0x81, 0xD8, 0xEE, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x04,
  0xFF, 0xFD, 0x81, 0x40, 0x9F, 0xFF, 0xB0, 0x93, 0x04, 0x80, 0xA2, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_1k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_1k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_2k_plus 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_round_36_av_2k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x90, 0xB7, 0x77, 0x8D, 0xFE, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07,
  0xC5, 0x87, 0x2F, 0x80, 0x4F, 0x90, 0x2F, 0x90, 0x07, 0xC8, 0x28, 0x33, 0x22, 0x98, 0x27, 0x03,
  0xC2, 0x83, 0x8F, 0xD1, 0xDC, 0x00, 0x7F, 0x0B, 0x29, 0x84, 0x70, 0x21, 0x04, 0xA8, 0x1B, 0x0B,
  0xC0, 0x07, 0xC8, 0x6A, 0x43, 0x20, 0x1F, 0x73, 0x87, 0x1E, 0xB4, 0x20, 0x24, 0xBA, 0x00, 0x7C,
  0x86, 0x10, 0x23, 0x4A, 0xF7, 0x38, 0x71, 0xEB, 0x42, 0x02, 0x4B, 0xA0, 0x07, 0xC2, 0x0B, 0xC8,
  0x47, 0x02, 0x10, 0x4A, 0x81, 0xB0, 0xBC, 0x00, 0x7C, 0x28, 0x72, 0x33, 0x8F, 0x70, 0x3C, 0x28,
  0x37, 0xFD, 0x1D, 0xC0, 0x07, 0xC0, 0x25, 0x98, 0x58, 0x04, 0xF9, 0x01, 0xF9, 0x00, 0x7C, 0x89,
  0x0D, 0x87, 0x77, 0xBF, 0xE8, 0xDA, 0x09, 0x0B, 0xF9, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x04,
  0xFF, 0xFD, 0x81, 0x40, 0x9F, 0xFF, 0xB0, 0x93, 0x04, 0x80, 0xA2, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_2k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_2k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_2k 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_round_36_av_2k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x49, 0x77, 0x77, 0x9B, 0x81, 0xE8, 0xDA, 0x09, 0x0B, 0xD0, 0x07,
  0xC0, 0xC6, 0x09, 0xA8, 0x58, 0x04, 0xF9, 0x02, 0xD0, 0x07, 0xD8, 0x55, 0x33, 0x31, 0x07, 0xA8,
  0x27, 0x04, 0xC2, 0x08, 0xD0, 0x07, 0xFA, 0x81, 0x30, 0x7A, 0x84, 0x70, 0x21, 0x04, 0xE0, 0x07,
  0xD8, 0x58, 0x33, 0x31, 0x08, 0xA0, 0x73, 0x01, 0x0E, 0xE0, 0x07, 0xC0, 0xC2, 0x0F, 0x30, 0x60,
  0xEA, 0x07, 0x30, 0x10, 0xEE, 0x00, 0x7C, 0x0B, 0x2F, 0x84, 0x70, 0x21, 0x04, 0xE0, 0x07, 0xC0,
  0xB2, 0x0F, 0x30, 0x40, 0xDA, 0x82, 0x70, 0x3C, 0x20, 0x7D, 0x00, 0x7C, 0x0D, 0x60, 0x8A, 0x85,
  0x80, 0x4F, 0x90, 0x1D, 0x00, 0x7D, 0x85, 0xB7, 0x77, 0x78, 0xEA, 0x81, 0xE8, 0xDA, 0x09, 0x0B,
  0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30,
  0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_2k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_2k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_3k_plus 36x36, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_round_36_av_3k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xB8, 0x91, 0xD7, 0x77, 0x78, 0xDF, 0xE8, 0xDA, 0x09, 0x0B, 0xF9, 0x00,
  0x7B, 0x04, 0x58, 0x72, 0xF7, 0x05, 0xF9, 0x02, 0xF9, 0x00, 0x7B, 0x83, 0xB4, 0x33, 0x22, 0x98,
  0x27, 0x04, 0xC2, 0x83, 0x8F, 0xD1, 0xDC, 0x00, 0x7F, 0x0B, 0x29, 0x84, 0x70, 0x21, 0x04, 0xA8,
  0x1B, 0x0B, 0xC0, 0x07, 0xC8, 0x2E, 0x43, 0x22, 0x90, 0x73, 0x87, 0x1E, 0xB4, 0x20, 0x24, 0xBA,
  0x00, 0x7C, 0x82, 0xE4, 0x32, 0x29, 0x07, 0x38, 0x71, 0xEB, 0x42, 0x02, 0x4B, 0xA0, 0x07, 0xF0,
  0xB2, 0x98, 0x47, 0x02, 0x10, 0x4A, 0x81, 0xB0, 0xBC, 0x00, 0x7B, 0x83, 0xB4, 0x33, 0x22, 0x98,
  0x27, 0x03, 0xC2, 0x83, 0x7F, 0xD1, 0xDC, 0x00, 0x7B, 0x04, 0x58, 0x72, 0xF8, 0x04, 0xF9, 0x01,
  0xF9, 0x00, 0x7B, 0x89, 0x1D, 0x77, 0x77, 0x8D, 0xFE, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27,
  0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_3k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_3k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_3k 36x36, 4-bit Alpha,  RLE, 180 bytes.
static const unsigned char ic_round_36_av_3k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x49, 0x77, 0x77, 0x9B, 0x81, 0xE8, 0xDA, 0x09, 0x0B, 0xD0, 0x07,
  0xC0, 0xC6, 0x09, 0xA8, 0x58, 0x04, 0xF9, 0x02, 0xD0, 0x07, 0xD8, 0x55, 0x33, 0x31, 0x07, 0xA8,
  0x27, 0x03, 0xC2, 0x08, 0xD0, 0x07, 0xFA, 0x81, 0x30, 0x7A, 0x84, 0x70, 0x21, 0x04, 0xE0, 0x07,
  0xE8, 0x49, 0x33, 0x10, 0x7A, 0x07, 0x30, 0x10, 0xEE, 0x00, 0x7E, 0x84, 0x93, 0x31, 0x07, 0xA0,
  0x73, 0x01, 0x0E, 0xE0, 0x07, 0xFA, 0x81, 0x30, 0x7A, 0x84, 0x70, 0x21, 0x04, 0xE0, 0x07, 0xD8,
  0x55, 0x33, 0x31, 0x07, 0xA8, 0x27, 0x03, 0xC2, 0x07, 0xD0, 0x07, 0xC0, 0xC6, 0x09, 0xA8, 0x58,
  0x04, 0xF9, 0x01, 0xD0, 0x07, 0xD8, 0x49, 0x77, 0x77, 0x9B, 0x81, 0xE8, 0xDA, 0x09, 0x0B, 0xD0,
  0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48,
  0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_3k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_3k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_4k_plus 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_round_36_av_4k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xB8, 0x1D, 0x8E, 0xA0, 0x90, 0xBA, 0x85, 0xD8, 0xEF, 0xE8, 0xDF, 0x00,
  0x7B, 0x83, 0x40, 0x8F, 0xC2, 0xA8, 0x54, 0x08, 0xF5, 0x05, 0xF0, 0x07, 0xB8, 0x33, 0x07, 0xFB,
  0x2A, 0x82, 0x30, 0x78, 0x28, 0x2B, 0xD1, 0xDC, 0x00, 0x7B, 0x83, 0x30, 0x7F, 0xB2, 0xA8, 0x13,
  0x04, 0x28, 0x37, 0xFB, 0x0B, 0xC0, 0x07, 0xB8, 0x33, 0x07, 0xFB, 0x2A, 0x03, 0x38, 0x64, 0xB4,
  0x20, 0x24, 0xBA, 0x00, 0x7B, 0x03, 0x70, 0xB0, 0x33, 0x86, 0x4B, 0x42, 0x02, 0x4B, 0xA0, 0x07,
  0xB0, 0x87, 0x82, 0x93, 0x04, 0x28, 0x37, 0xFB, 0x0B, 0xC0, 0x07, 0xC8, 0x2C, 0xBB, 0x82, 0x84,
  0xCF, 0x30, 0x78, 0x28, 0x2B, 0xD1, 0xDC, 0x00, 0x7F, 0x0C, 0x2A, 0x85, 0x40, 0x8F, 0x50, 0x5F,
  0x00, 0x7F, 0x90, 0x90, 0xBA, 0x85, 0xD8, 0xEF, 0xE8, 0xDF, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07,
  0x04, 0xFF, 0xFD, 0x81, 0x40, 0x9F, 0xFF, 0xB0, 0x93, 0x04, 0x80, 0xA2, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_4k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_4k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_4k 36x36, 4-bit Alpha,  RLE, 186 bytes.
static const unsigned char ic_round_36_av_4k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD0, 0x90, 0xBA, 0x81, 0xD8, 0xEA, 0x81, 0xE8, 0xDA, 0x0D, 0x09, 0xD0,
  0x07, 0xC0, 0xC2, 0xA8, 0x14, 0x08, 0xA8, 0x68, 0x04, 0xFE, 0x10, 0xAC, 0x00, 0x7C, 0x0B, 0x2A,
  0x81, 0x30, 0x7A, 0x86, 0x70, 0x3F, 0x60, 0x1E, 0xC0, 0x07, 0xC0, 0xB2, 0xA8, 0x13, 0x07, 0xA8,
  0x27, 0x03, 0xB2, 0x0A, 0xD0, 0x07, 0xC0, 0xB2, 0xA8, 0x13, 0x07, 0xA8, 0x47, 0x03, 0x10, 0x5E,
  0x00, 0x7C, 0x0B, 0x78, 0x64, 0xF7, 0x03, 0x20, 0x5E, 0x00, 0x7C, 0x0E, 0x01, 0x68, 0x41, 0xF7,
  0x03, 0xB2, 0x0A, 0xD0, 0x07, 0xD8, 0x97, 0xEB, 0xBB, 0x20, 0x5E, 0xF7, 0x03, 0xF6, 0x01, 0xEC,
  0x00, 0x7F, 0xA8, 0x14, 0x08, 0xA8, 0x68, 0x04, 0xFE, 0x20, 0xAC, 0x00, 0x7F, 0xA8, 0x1D, 0x8E,
  0xA8, 0x1E, 0x8D, 0xA0, 0xD0, 0x8D, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF,
  0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x04, 0xFF, 0xFD, 0x81,
  0x40, 0x9F, 0xFF, 0xB0, 0x93, 0x04, 0x80, 0xA2, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_4k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_4k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_5g 36x36, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_round_36_av_5g_data[] PROGMEM = {
  0x10, 0x58, 0x04, 0x70, 0x24, 0x01, 0x06, 0x80, 0x57, 0x81, 0x50, 0x5F, 0xA0, 0xD3, 0x03, 0x0E,
  0xFC, 0x05, 0x07, 0xFA, 0x0D, 0x30, 0xBF, 0xD0, 0x50, 0x7A, 0x0B, 0x80, 0x27, 0x02, 0x3B, 0x80,
  0x57, 0x81, 0x50, 0x7A, 0x07, 0x73, 0xB7, 0x40, 0x7A, 0x07, 0x73, 0xB7, 0x40, 0x7A, 0x85, 0xB7,
  0x77, 0x76, 0x14, 0xB5, 0x85, 0x57, 0x77, 0x50, 0x7F, 0x90, 0xE0, 0x33, 0xB4, 0x05, 0xD0, 0x05,
  0xFA, 0x0B, 0x3B, 0x40, 0x5D, 0x81, 0x70, 0x58, 0x02, 0x7B, 0x3B, 0x58, 0x15, 0x7B, 0xA0, 0x77,
  0x1B, 0x3B, 0x70, 0x7A, 0x07, 0x71, 0xB3, 0xB7, 0x07, 0xA8, 0x17, 0x05, 0x80, 0x27, 0xB3, 0xB8,
  0x03, 0x70, 0xBA, 0x07, 0x05, 0xFA, 0x0B, 0x30, 0xBF, 0xD0, 0x40, 0x5F, 0x90, 0xE0, 0x33, 0x03,
  0x0E, 0xFB, 0x09, 0x20, 0x58, 0x02, 0x70, 0x60, 0x15, 0x01, 0x06, 0x80, 0x47, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_5g() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 31, 25), Box(0, 0, 35, 35),
      ic_round_36_av_5g_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_5k_plus 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_round_36_av_5k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x90, 0xD8, 0x77, 0x7B, 0xFE, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07,
  0xC0, 0x25, 0x98, 0x58, 0x04, 0xF9, 0x02, 0xF9, 0x00, 0x7C, 0x28, 0x72, 0x33, 0x8F, 0x70, 0x3C,
  0x28, 0x38, 0xFD, 0x1D, 0xC0, 0x07, 0xC2, 0x0B, 0xC8, 0x47, 0x02, 0x10, 0x4A, 0x81, 0xB0, 0xBC,
  0x00, 0x7C, 0x86, 0x10, 0x23, 0x4A, 0xF7, 0x38, 0x71, 0xEB, 0x42, 0x02, 0x4B, 0xA0, 0x07, 0xC8,
  0x6A, 0x43, 0x20, 0x1F, 0x73, 0x87, 0x1E, 0xB4, 0x20, 0x24, 0xBA, 0x00, 0x7F, 0x0B, 0x29, 0x84,
  0x70, 0x21, 0x04, 0xA8, 0x1B, 0x0B, 0xC0, 0x07, 0xC8, 0x28, 0x33, 0x22, 0x98, 0x27, 0x03, 0xC2,
  0x83, 0x7F, 0xD1, 0xDC, 0x00, 0x7C, 0x58, 0x72, 0xF8, 0x04, 0xF9, 0x01, 0xF9, 0x00, 0x7C, 0x89,
  0x0B, 0x77, 0x78, 0xDF, 0xE8, 0xDA, 0x09, 0x0B, 0xF9, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x04,
  0xFF, 0xFD, 0x81, 0x40, 0x9F, 0xFF, 0xB0, 0x93, 0x04, 0x80, 0xA2, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_5k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_5k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_5k 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_round_36_av_5k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x59, 0x77, 0x77, 0x8E, 0xA8, 0x1E, 0x8D, 0xA0, 0x90, 0xBD, 0x00,
  0x7C, 0x0C, 0x60, 0x8A, 0x85, 0x80, 0x4F, 0x90, 0x2D, 0x00, 0x7C, 0x0B, 0x20, 0xF3, 0x04, 0x0D,
  0xA8, 0x27, 0x04, 0xC2, 0x08, 0xD0, 0x07, 0xC0, 0xB2, 0xF8, 0x47, 0x02, 0x10, 0x4E, 0x00, 0x7C,
  0x0B, 0x20, 0xF3, 0x06, 0x0E, 0xA0, 0x73, 0x01, 0x0E, 0xE0, 0x07, 0xD8, 0x55, 0x33, 0x31, 0x08,
  0xA0, 0x73, 0x01, 0x0E, 0xE0, 0x07, 0xFA, 0x81, 0x30, 0x7A, 0x84, 0x70, 0x21, 0x04, 0xE0, 0x07,
  0xD8, 0x55, 0x33, 0x31, 0x07, 0xA8, 0x27, 0x03, 0xC2, 0x07, 0xD0, 0x07, 0xC0, 0xC6, 0x09, 0xA8,
  0x58, 0x04, 0xF9, 0x01, 0xD0, 0x07, 0xD8, 0x49, 0x77, 0x77, 0x9B, 0x81, 0xE8, 0xDA, 0x09, 0x0B,
  0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30,
  0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_5k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_5k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_6k_plus 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_round_36_av_6k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x90, 0xD8, 0x77, 0x7B, 0xFE, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07,
  0xC0, 0x25, 0x98, 0x58, 0x04, 0xF9, 0x02, 0xF9, 0x00, 0x7C, 0x28, 0x72, 0x33, 0x8F, 0x70, 0x4C,
  0x28, 0x38, 0xFD, 0x1D, 0xC0, 0x07, 0xC2, 0x0B, 0xC8, 0x47, 0x02, 0x10, 0x4A, 0x81, 0xB0, 0xBC,
  0x00, 0x7C, 0x28, 0x42, 0x34, 0xAF, 0x73, 0x87, 0x1E, 0xB4, 0x20, 0x24, 0xBA, 0x00, 0x7C, 0x28,
  0x42, 0x20, 0x1F, 0x73, 0x87, 0x1E, 0xB4, 0x20, 0x24, 0xBA, 0x00, 0x7C, 0x20, 0x0B, 0x29, 0x84,
  0x70, 0x21, 0x04, 0xA8, 0x1B, 0x0B, 0xC0, 0x07, 0xC2, 0x00, 0xB2, 0x98, 0x27, 0x03, 0xC2, 0x83,
  0x7F, 0xD1, 0xDC, 0x00, 0x7C, 0x02, 0x48, 0x72, 0xF8, 0x04, 0xF9, 0x01, 0xF9, 0x00, 0x7C, 0x89,
  0x0D, 0x87, 0x78, 0xDF, 0xE8, 0xDA, 0x09, 0x0B, 0xF9, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x04,
  0xFF, 0xFD, 0x81, 0x40, 0x9F, 0xFF, 0xB0, 0x93, 0x04, 0x80, 0xA2, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_6k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_6k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_6k 36x36, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_round_36_av_6k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x5B, 0x77, 0x77, 0x8E, 0xA8, 0x1E, 0x8D, 0xA0, 0x90, 0xBD, 0x00,
  0x7C, 0x0D, 0x60, 0x8A, 0x85, 0x80, 0x4F, 0x90, 0x2D, 0x00, 0x7C, 0x0B, 0x20, 0xF3, 0x04, 0x0D,
  0xA8, 0x27, 0x04, 0xC2, 0x08, 0xD0, 0x07, 0xC0, 0xB2, 0xF8, 0x47, 0x02, 0x10, 0x4E, 0x00, 0x7C,
  0x0B, 0x20, 0xF3, 0x06, 0x0E, 0xA0, 0x73, 0x01, 0x0E, 0xE0, 0x07, 0xC0, 0xB2, 0x83, 0x33, 0x10,
  0x8A, 0x07, 0x30, 0x10, 0xEE, 0x00, 0x7C, 0x0B, 0x2A, 0x81, 0x30, 0x7A, 0x84, 0x70, 0x21, 0x04,
  0xE0, 0x07, 0xC0, 0xB2, 0xA8, 0x13, 0x07, 0xA8, 0x27, 0x03, 0xC2, 0x07, 0xD0, 0x07, 0xC0, 0xD6,
  0x09, 0xA8, 0x58, 0x04, 0xF9, 0x01, 0xD0, 0x07, 0xD8, 0x4B, 0x77, 0x77, 0x9B, 0x81, 0xE8, 0xDA,
  0x09, 0x0B, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF,
  0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB,
  0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_6k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_6k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_7k_plus 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_round_36_av_7k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xB8, 0x91, 0xD7, 0x77, 0x78, 0xDF, 0xE8, 0xDA, 0x09, 0x0B, 0xF9, 0x00,
  0x7B, 0x04, 0x58, 0x72, 0xF8, 0x04, 0xF9, 0x02, 0xF9, 0x00, 0x7B, 0x82, 0xB4, 0x33, 0x28, 0x41,
  0xF7, 0x04, 0xC2, 0x83, 0x8F, 0xD1, 0xDC, 0x00, 0x7E, 0x0E, 0x28, 0x66, 0xF7, 0x02, 0x10, 0x4A,
  0x81, 0xB0, 0xBC, 0x00, 0x7E, 0x09, 0x28, 0x1A, 0xF7, 0x38, 0x71, 0xEB, 0x42, 0x02, 0x4B, 0xA0,
  0x07, 0xE0, 0x52, 0xA0, 0x73, 0x87, 0x1E, 0xB4, 0x20, 0x24, 0xBA, 0x00, 0x7E, 0x20, 0x5A, 0x84,
  0x70, 0x21, 0x04, 0xA8, 0x1B, 0x0B, 0xC0, 0x07, 0xD0, 0xB2, 0x09, 0xA8, 0x27, 0x03, 0xC2, 0x83,
  0x7F, 0xD1, 0xDC, 0x00, 0x7D, 0x09, 0x20, 0xEA, 0x85, 0x80, 0x4F, 0x90, 0x1F, 0x90, 0x07, 0xD8,
  0x1E, 0x8B, 0xB8, 0x1E, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F,
  0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_7k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_7k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_7k 36x36, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_round_36_av_7k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x49, 0x77, 0x77, 0xAB, 0x81, 0xE8, 0xDA, 0x09, 0x0B, 0xD0, 0x07,
  0xC0, 0xC6, 0x0A, 0xA8, 0x58, 0x04, 0xF9, 0x02, 0xD0, 0x07, 0xD8, 0x25, 0x33, 0x22, 0x09, 0xA8,
  0x27, 0x04, 0xC2, 0x08, 0xD0, 0x07, 0xF9, 0x07, 0x20, 0xDA, 0x84, 0x70, 0x21, 0x04, 0xE0, 0x07,
  0xF9, 0x81, 0x20, 0x3B, 0x07, 0x30, 0x10, 0xEE, 0x00, 0x7F, 0x0D, 0x20, 0x7B, 0x07, 0x30, 0x10,
  0xEE, 0x00, 0x7F, 0x08, 0x20, 0xCB, 0x84, 0x70, 0x21, 0x04, 0xE0, 0x07, 0xF8, 0x13, 0x02, 0xC8,
  0x27, 0x03, 0xC2, 0x07, 0xD0, 0x07, 0xF8, 0x11, 0x07, 0xC8, 0x58, 0x04, 0xF9, 0x01, 0xD0, 0x07,
  0xF8, 0x1B, 0x8E, 0xC8, 0x1E, 0x8D, 0xA0, 0x90, 0xBD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x04,
  0xFF, 0xFD, 0x81, 0x40, 0x9F, 0xFF, 0xB0, 0x93, 0x04, 0x80, 0xA2, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_7k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_7k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_8k_plus 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_round_36_av_8k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x90, 0xD8, 0x77, 0x8D, 0xFE, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07,
  0xC0, 0x24, 0x87, 0x2F, 0x80, 0x4F, 0x90, 0x2F, 0x90, 0x07, 0xC2, 0x00, 0xB2, 0x98, 0x27, 0x04,
  0xC2, 0x83, 0x8F, 0xB0, 0xBC, 0x00, 0x7C, 0x20, 0x0B, 0x29, 0x84, 0x70, 0x21, 0x04, 0xA8, 0x1B,
  0x0B, 0xC0, 0x07, 0xC2, 0x00, 0x22, 0x90, 0x73, 0x87, 0x1E, 0x93, 0x20, 0x23, 0x9A, 0x00, 0x7C,
  0x20, 0x02, 0x29, 0x07, 0x38, 0x71, 0xE9, 0x32, 0x02, 0x39, 0xA0, 0x07, 0xC2, 0x00, 0xB2, 0x98,
  0x47, 0x02, 0x10, 0x4A, 0x81, 0xB0, 0xBC, 0x00, 0x7C, 0x20, 0x0B, 0x29, 0x82, 0x70, 0x3C, 0x28,
  0x37, 0xFB, 0x0B, 0xC0, 0x07, 0xC0, 0x24, 0x87, 0x2F, 0x80, 0x4F, 0x90, 0x1F, 0x90, 0x07, 0xC8,
  0x90, 0xD8, 0x77, 0x8D, 0xFE, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF,
  0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70,
  0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_8k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_8k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_8k 36x36, 4-bit Alpha,  RLE, 185 bytes.
static const unsigned char ic_round_36_av_8k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x4B, 0x77, 0x77, 0x9B, 0x81, 0xE8, 0xDA, 0x09, 0x0B, 0xD0, 0x07,
  0xC0, 0xD6, 0x09, 0xA8, 0x58, 0x04, 0xF9, 0x02, 0xD0, 0x07, 0xC0, 0xB2, 0xA8, 0x13, 0x07, 0xA8,
  0x27, 0x04, 0xC2, 0x08, 0xD0, 0x07, 0xC0, 0xB2, 0xA8, 0x13, 0x07, 0xA8, 0x47, 0x02, 0x10, 0x4E,
  0x00, 0x7C, 0x0B, 0x28, 0x33, 0x31, 0x07, 0xA0, 0x73, 0x01, 0x0E, 0xE0, 0x07, 0xC0, 0xB2, 0x83,
  0x33, 0x10, 0x7A, 0x07, 0x30, 0x10, 0xEE, 0x00, 0x7C, 0x0B, 0x2A, 0x81, 0x30, 0x7A, 0x84, 0x70,
  0x21, 0x04, 0xE0, 0x07, 0xC0, 0xB2, 0xA8, 0x13, 0x07, 0xA8, 0x27, 0x03, 0xC2, 0x07, 0xD0, 0x07,
  0xC0, 0xD6, 0x09, 0xA8, 0x58, 0x04, 0xF9, 0x01, 0xD0, 0x07, 0xD8, 0x4B, 0x77, 0x77, 0x9B, 0x81,
  0xE8, 0xDA, 0x09, 0x0B, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09,
  0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_8k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_8k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_9k_plus 36x36, 4-bit Alpha,  RLE, 191 bytes.
static const unsigned char ic_round_36_av_9k_plus_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x90, 0xD8, 0x77, 0x8D, 0xFE, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07,
  0xC0, 0x24, 0x87, 0x2F, 0x80, 0x4F, 0x90, 0x2F, 0x90, 0x07, 0xC2, 0x00, 0xB2, 0x98, 0x27, 0x04,
  0xC2, 0x83, 0x8F, 0xD1, 0xDC, 0x00, 0x7C, 0x20, 0x0B, 0x29, 0x84, 0x70, 0x21, 0x04, 0xA8, 0x1B,
  0x0B, 0xC0, 0x07, 0xC8, 0x21, 0x02, 0x22, 0x90, 0x73, 0x87, 0x1E, 0xB4, 0x20, 0x24, 0xBA, 0x00,
  0x7C, 0x82, 0xA4, 0x32, 0x29, 0x07, 0x38, 0x71, 0xEB, 0x42, 0x02, 0x4B, 0xA0, 0x07, 0xF0, 0xB2,
  0x98, 0x47, 0x02, 0x10, 0x4A, 0x81, 0xB0, 0xBC, 0x00, 0x7C, 0x82, 0x83, 0x32, 0x29, 0x82, 0x70,
  0x3C, 0x28, 0x37, 0xFD, 0x1D, 0xC0, 0x07, 0xC5, 0x87, 0x2F, 0x80, 0x4F, 0x90, 0x1F, 0x90, 0x07,
  0xC8, 0x90, 0xB7, 0x77, 0x8D, 0xFE, 0x8D, 0xA0, 0x90, 0xBF, 0x90, 0x07, 0xFF, 0xFD, 0x00, 0x7F,
  0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_9k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_9k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_9k 36x36, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_round_36_av_9k_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x4B, 0x77, 0x77, 0x9B, 0x81, 0xE8, 0xDA, 0x09, 0x0B, 0xD0, 0x07,
  0xC0, 0xD6, 0x09, 0xA8, 0x58, 0x04, 0xF9, 0x02, 0xD0, 0x07, 0xC0, 0xB2, 0xA8, 0x13, 0x07, 0xA8,
  0x27, 0x04, 0xC2, 0x08, 0xD0, 0x07, 0xC0, 0xB2, 0xA8, 0x13, 0x07, 0xA8, 0x47, 0x02, 0x10, 0x4E,
  0x00, 0x7C, 0x0C, 0x28, 0x33, 0x31, 0x07, 0xA0, 0x73, 0x01, 0x0E, 0xE0, 0x07, 0xD8, 0x58, 0x33,
  0x31, 0x07, 0xA0, 0x73, 0x01, 0x0E, 0xE0, 0x07, 0xFA, 0x81, 0x30, 0x7A, 0x84, 0x70, 0x21, 0x04,
  0xE0, 0x07, 0xD8, 0x55, 0x33, 0x31, 0x07, 0xA8, 0x27, 0x03, 0xC2, 0x07, 0xD0, 0x07, 0xC0, 0xC6,
  0x09, 0xA8, 0x58, 0x04, 0xF9, 0x01, 0xD0, 0x07, 0xD8, 0x49, 0x77, 0x77, 0x9B, 0x81, 0xE8, 0xDA,
  0x09, 0x0B, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF,
  0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB,
  0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_9k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_9k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_add_to_queue 36x36, 4-bit Alpha,  RLE, 200 bytes.
static const unsigned char ic_round_36_av_add_to_queue_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x50, 0x05, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x40, 0x5A,
  0x05, 0x74, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x40, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x07,
  0xA0, 0x77, 0x08, 0xFB, 0x08, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x70, 0xEF, 0xB0, 0xE7, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x08, 0xFB, 0x08, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x40,
  0x7A, 0x00, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x74, 0x07, 0xA0,
  0x77, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x74, 0x05, 0xA0, 0x57, 0x40, 0x7A, 0x00, 0x7A, 0x07, 0x75,
  0x00, 0x57, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x97, 0x77, 0x50,
  0x9A, 0x00, 0x7B, 0x09, 0x80, 0xA4, 0x70, 0x9B, 0x07, 0x04, 0xFF, 0xFF, 0xC8, 0x14, 0x09, 0xFF,
  0xFF, 0xA0, 0x93, 0x04, 0x80, 0x47, 0xFD, 0x80, 0x47, 0x04, 0x76, 0xFD, 0x77, 0x71, 0x0D, 0xFB,
  0x0D, 0x77, 0x71, 0x02, 0x80, 0x67, 0x02, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_add_to_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_av_add_to_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_airplay 36x36, 4-bit Alpha,  RLE, 199 bytes.
static const unsigned char ic_round_36_av_airplay_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0,
  0x97, 0x50, 0x03, 0x75, 0x09, 0xA0, 0x07, 0xB8, 0x39, 0x77, 0x75, 0x60, 0x7A, 0x07, 0x68, 0x35,
  0x77, 0x79, 0xB0, 0x70, 0x4F, 0x90, 0x54, 0x07, 0xC0, 0x74, 0x05, 0xF9, 0x81, 0x40, 0x9F, 0x05,
  0x30, 0x7E, 0x07, 0x30, 0x5F, 0x09, 0x30, 0x48, 0x01, 0x70, 0x53, 0x07, 0xF9, 0x07, 0x30, 0x58,
  0x01, 0x70, 0x47, 0x60, 0x7F, 0xB0, 0x77, 0x77, 0x06, 0xFD, 0x06, 0x77, 0x60, 0xCF, 0xD0, 0xC7,
  0x76, 0x06, 0x0E, 0xFB, 0x0E, 0x05, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_airplay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 32), Box(0, 0, 35, 35),
      ic_round_36_av_airplay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_album 36x36, 4-bit Alpha,  RLE, 197 bytes.
static const unsigned char ic_round_36_av_album_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDF, 0xFF, 0xB0, 0xD3, 0x07, 0xFB, 0x84, 0xB6, 0x44,
  0x6B, 0xFB, 0x07, 0x20, 0xEF, 0x90, 0xD0, 0x36, 0x03, 0x0D, 0xF9, 0x81, 0xE0, 0x3F, 0x90, 0xD0,
  0x17, 0x10, 0x10, 0xDF, 0x90, 0x30, 0x8F, 0x90, 0x37, 0x30, 0x3F, 0x90, 0x80, 0xBF, 0x0B, 0x75,
  0x0B, 0xF0, 0xB0, 0xDF, 0x06, 0x50, 0x05, 0x50, 0x6F, 0x0D, 0x0E, 0xF0, 0x44, 0x05, 0xA0, 0x54,
  0x04, 0xF0, 0x0E, 0xF0, 0x44, 0x05, 0xA0, 0x54, 0x04, 0xF0, 0xE0, 0xDF, 0x06, 0x50, 0x05, 0x50,
  0x6F, 0x0D, 0x0B, 0xF0, 0xB7, 0x50, 0xBF, 0x0B, 0x08, 0xF9, 0x03, 0x73, 0x03, 0xF9, 0x08, 0x03,
  0xF9, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xF9, 0x81, 0x30, 0xEF, 0x90, 0xD0, 0x36, 0x03, 0x0D, 0xF9,
  0x0E, 0x20, 0x7F, 0xB8, 0x4B, 0x64, 0x46, 0xBF, 0xB0, 0x73, 0x0D, 0xFF, 0xFB, 0x0D, 0x40, 0x5F,
  0xFF, 0xB0, 0x55, 0x08, 0xFF, 0xF9, 0x08, 0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77,
  0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B,
  0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_album() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_album_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_art_track 36x36, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_round_36_av_art_track_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x05, 0x70, 0x60, 0x14, 0x02, 0x80, 0x67, 0x81, 0x23, 0xEF, 0xC0, 0xE0, 0x33,
  0x0D, 0xFB, 0x0D, 0x0B, 0xFE, 0x0B, 0x30, 0xDF, 0xB0, 0xDF, 0xF9, 0x30, 0x28, 0x06, 0x70, 0x2F,
  0xF9, 0x77, 0x1F, 0xF9, 0x77, 0x1F, 0xF9, 0x30, 0x28, 0x06, 0x70, 0x2F, 0xF9, 0x30, 0xDF, 0xB0,
  0xDF, 0x90, 0xD0, 0x9D, 0x30, 0xDF, 0xB0, 0xDC, 0x0C, 0x0D, 0xA8, 0x13, 0x07, 0xC3, 0x02, 0x80,
  0x67, 0x02, 0xB8, 0x3C, 0x01, 0xD6, 0x30, 0xBB, 0x77, 0x1B, 0x02, 0x20, 0x14, 0x01, 0xB7, 0x71,
  0xB0, 0xA8, 0x03, 0x70, 0x9B, 0x30, 0x28, 0x06, 0x70, 0x20, 0xBF, 0xE0, 0xB3, 0x0D, 0xFB, 0x81,
  0xD3, 0xEF, 0xC0, 0xE0, 0x33, 0x0D, 0xFB, 0x82, 0xD0, 0x16, 0x80, 0x57, 0x06, 0x01, 0x40, 0x28,
  0x06, 0x70, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_art_track() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 10, 32, 25), Box(0, 0, 35, 35),
      ic_round_36_av_art_track_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_audio_file 36x36, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_round_36_av_audio_file_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xC0, 0xD0, 0x57, 0x10, 0x8F, 0xF9, 0x07, 0x70, 0xDF, 0xD0, 0xBB, 0x07, 0x6F,
  0xE0, 0x70, 0x4B, 0x07, 0x5F, 0xE8, 0x17, 0x04, 0xB0, 0x74, 0xFE, 0x07, 0x20, 0x4B, 0x07, 0x3F,
  0xE0, 0x73, 0x04, 0xB0, 0x72, 0xFE, 0x07, 0x40, 0x4B, 0x07, 0x1F, 0xE0, 0x75, 0x04, 0xB0, 0x5F,
  0xE0, 0x96, 0x04, 0xA0, 0xDF, 0xF0, 0x98, 0x02, 0x70, 0xB8, 0x0F, 0x2F, 0x84, 0xD8, 0x77, 0x8D,
  0xFF, 0xC0, 0x24, 0x02, 0xFF, 0xC5, 0x02, 0xFF, 0xC1, 0x83, 0x37, 0x78, 0xDF, 0xFC, 0x10, 0x7F,
  0xFD, 0x83, 0xCC, 0xF0, 0x7F, 0xFB, 0x0D, 0x02, 0x28, 0x11, 0x07, 0xFF, 0xB0, 0x25, 0x07, 0xFF,
  0xA0, 0xD6, 0x07, 0xFF, 0xA0, 0xC6, 0x09, 0xFF, 0xB0, 0x25, 0x0D, 0xFF, 0xB0, 0xB0, 0x13, 0x09,
  0xFF, 0xD8, 0x2E, 0x98, 0xD8, 0x0C, 0x0F, 0x0D, 0xFF, 0xF9, 0x0D, 0x08, 0xFF, 0xF9, 0x82, 0x80,
  0x8E, 0xFF, 0xC0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_audio_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_round_36_av_audio_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_av_timer 36x36, 4-bit Alpha,  RLE, 260 bytes.
static const unsigned char ic_round_36_av_av_timer_data[] PROGMEM = {
  0x76, 0x82, 0x57, 0x53, 0x77, 0x72, 0x05, 0xC8, 0x1E, 0xA4, 0x77, 0x60, 0x7F, 0x0B, 0x03, 0x74,
  0x02, 0x01, 0x50, 0x7A, 0x00, 0xDD, 0x06, 0x72, 0x82, 0x7F, 0xE3, 0x40, 0x7A, 0x83, 0x70, 0x28,
  0xEB, 0x08, 0x70, 0x6B, 0x0E, 0x03, 0x30, 0x5A, 0x05, 0x30, 0x20, 0xBB, 0x06, 0x50, 0x2D, 0x0E,
  0x03, 0x30, 0x05, 0x60, 0xAB, 0x03, 0x40, 0xBA, 0x0C, 0x0D, 0xA0, 0xE0, 0x37, 0x40, 0xCA, 0x0B,
  0x30, 0x4A, 0x82, 0xE2, 0x1D, 0xA0, 0xE0, 0x37, 0x30, 0x10, 0xEA, 0x04, 0x20, 0xAA, 0x08, 0x20,
  0x10, 0xDA, 0x0E, 0x03, 0x73, 0x08, 0xA0, 0xA2, 0x0E, 0xA0, 0x13, 0x01, 0x0D, 0xA0, 0xE0, 0x37,
  0x20, 0x2A, 0x81, 0xE0, 0x3A, 0x0C, 0x50, 0x20, 0xDA, 0x0E, 0x03, 0x72, 0x0C, 0xA0, 0x30, 0x5A,
  0x83, 0x90, 0x27, 0x22, 0x02, 0x0D, 0xA0, 0xE0, 0x24, 0x83, 0x27, 0x20, 0x9A, 0x05, 0x06, 0xA8,
  0x38, 0x0D, 0xFD, 0x30, 0x20, 0xDA, 0x06, 0x48, 0x3D, 0xFD, 0x08, 0xA0, 0x06, 0xA8, 0x38, 0x0D,
  0xFD, 0x48, 0x22, 0xBB, 0x14, 0x83, 0xDF, 0xD0, 0x8A, 0x07, 0x05, 0xA8, 0x3A, 0x02, 0x72, 0x75,
  0x83, 0x27, 0x20, 0x9A, 0x05, 0x03, 0xA0, 0xC7, 0x76, 0x0D, 0xA8, 0x13, 0x0E, 0xA0, 0x27, 0x74,
  0x02, 0xA0, 0xE2, 0x0A, 0xA0, 0x87, 0x74, 0x09, 0xA0, 0x92, 0x04, 0xB0, 0x17, 0x72, 0x02, 0xB0,
  0x43, 0x0B, 0xA0, 0xC6, 0x82, 0x2D, 0xD2, 0x60, 0xCA, 0x0B, 0x40, 0x3B, 0x0A, 0x50, 0x6A, 0x06,
  0x50, 0xBA, 0x0E, 0x02, 0x50, 0x6B, 0x0C, 0x01, 0x38, 0x22, 0xDD, 0x23, 0x02, 0x0C, 0xB0, 0x57,
  0x08, 0xC0, 0x80, 0x26, 0x02, 0x08, 0xC0, 0x77, 0x20, 0x6D, 0x84, 0xD9, 0x88, 0xAD, 0xC0, 0xE0,
  0x57, 0x40, 0x30, 0xBF, 0xD0, 0xB0, 0x27, 0x78, 0x14, 0xAE, 0xE8, 0x1E, 0x94, 0x77, 0x58, 0x43,
  0x56, 0x75, 0x37, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_av_timer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_av_timer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_branding_watermark 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_round_36_av_branding_watermark_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xA0, 0xD0, 0x88, 0x06, 0x70, 0x9B, 0x00, 0x7F, 0xFA, 0x02, 0x75, 0x09, 0xA0, 0x07, 0xFF,
  0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x76, 0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F,
  0xFA, 0x76, 0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x76, 0x07, 0xA0, 0x07,
  0xFF, 0xA0, 0x27, 0x50, 0x9A, 0x00, 0x7F, 0xFA, 0x0D, 0x08, 0x80, 0x67, 0x09, 0xB0, 0x70, 0x4F,
  0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x30, 0x48, 0x0B, 0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_branding_watermark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_av_branding_watermark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_call_to_action 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_round_36_av_call_to_action_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xA0, 0xD0, 0x27, 0x77, 0x30, 0x20, 0xDA, 0x00, 0x7A, 0x08, 0x77, 0x75,
  0x08, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x09, 0x77, 0x75, 0x09, 0xA0, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09,
  0x30, 0x48, 0x0B, 0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_call_to_action() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_av_call_to_action_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_closed_caption_disabled 36x36, 4-bit Alpha,  RLE, 223 bytes.
static const unsigned char ic_round_36_av_closed_caption_disabled_data[] PROGMEM = {
  0x20, 0x17, 0x77, 0x68, 0x21, 0xDF, 0x77, 0x77, 0x50, 0x3B, 0x07, 0x30, 0x4F, 0xFC, 0x0B, 0x03,
  0x20, 0xBB, 0x07, 0x30, 0x4F, 0xFC, 0x0E, 0x01, 0x20, 0xBB, 0x07, 0x30, 0x4F, 0xFC, 0x06, 0x20,
  0x7C, 0x07, 0x30, 0x4F, 0xFB, 0x07, 0x20, 0x7D, 0x07, 0x30, 0x4F, 0xFA, 0x07, 0x20, 0x7E, 0x07,
  0x30, 0x4F, 0xF9, 0x07, 0x20, 0x7F, 0x07, 0x30, 0x4F, 0xF0, 0x72, 0x07, 0xF9, 0x07, 0x30, 0x4A,
  0x85, 0x97, 0x77, 0x78, 0xDC, 0x07, 0x20, 0x7C, 0x02, 0x0A, 0xB0, 0x73, 0x04, 0x09, 0x60, 0x2C,
  0x07, 0x20, 0x7C, 0x20, 0xCB, 0x07, 0x50, 0x10, 0xF3, 0x2C, 0x07, 0x20, 0x7C, 0x20, 0xBC, 0x07,
  0x40, 0x3B, 0x08, 0x0A, 0xC0, 0x72, 0x07, 0xC2, 0x0B, 0xD0, 0x73, 0x02, 0xFA, 0x07, 0x20, 0x7C,
  0x20, 0xBE, 0x07, 0x30, 0x4F, 0x90, 0x72, 0x07, 0xC2, 0x0B, 0xA0, 0x0B, 0xB0, 0x73, 0x82, 0x4E,
  0x8A, 0xC0, 0x72, 0x07, 0xC2, 0x84, 0x23, 0x31, 0x0B, 0xB0, 0x73, 0x01, 0x2C, 0x07, 0x20, 0x7C,
  0x02, 0x60, 0x9C, 0x07, 0x40, 0x2C, 0x07, 0x20, 0x7C, 0x85, 0xD8, 0x77, 0x77, 0x9E, 0x07, 0x30,
  0x4C, 0x07, 0x20, 0x7F, 0xFC, 0x07, 0x30, 0x4B, 0x07, 0x20, 0x7F, 0xFD, 0x07, 0x30, 0x4A, 0x07,
  0x20, 0x7F, 0xFE, 0x07, 0x38, 0x14, 0xF7, 0x20, 0x7F, 0xFF, 0x07, 0x30, 0x40, 0x72, 0x06, 0xFF,
  0xF9, 0x07, 0x60, 0x10, 0xEF, 0xFF, 0x90, 0x76, 0x03, 0x0B, 0xFF, 0xF9, 0x07, 0x77, 0x75, 0x0A,
  0xB0, 0x77, 0x77, 0x50, 0xAB, 0x01, 0x77, 0x75, 0x81, 0xAF, 0xD7, 0x77, 0x70, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_closed_caption_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 31, 33), Box(0, 0, 35, 35),
      ic_round_36_av_closed_caption_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_closed_caption_off 36x36, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_round_36_av_closed_caption_off_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0x98, 0x3B, 0x30, 0x1E, 0xFF, 0xFB, 0x81, 0xE1, 0x6F, 0xFF, 0xD0, 0x60,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7C, 0x85,
  0xD8, 0x77, 0x77, 0x9C, 0x85, 0x97, 0x77, 0x78, 0xDC, 0x00, 0x7C, 0x02, 0x60, 0x9A, 0x09, 0x60,
  0x2C, 0x00, 0x7C, 0x28, 0x42, 0x33, 0x10, 0x7A, 0x81, 0x70, 0x10, 0xF3, 0x2C, 0x00, 0x7C, 0x20,
  0xBA, 0x81, 0xB7, 0xDA, 0x81, 0x70, 0x3B, 0x08, 0x0A, 0xC0, 0x07, 0xC2, 0x0B, 0xF8, 0x17, 0x03,
  0xFA, 0x00, 0x7C, 0x20, 0xBF, 0x81, 0x70, 0x3F, 0xA0, 0x07, 0xC2, 0x0B, 0xA8, 0x1B, 0x7D, 0xA8,
  0x17, 0x03, 0xB0, 0x80, 0xAC, 0x00, 0x7C, 0x28, 0x42, 0x33, 0x10, 0x7A, 0x81, 0x70, 0x10, 0xF3,
  0x2C, 0x00, 0x7C, 0x02, 0x60, 0x9A, 0x09, 0x60, 0x2C, 0x00, 0x7C, 0x85, 0xD8, 0x77, 0x77, 0x9C,
  0x85, 0x97, 0x77, 0x78, 0xDC, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x07, 0x06, 0xFF, 0xFD, 0x81, 0x61, 0xEF, 0xFF, 0xB8, 0x3E, 0x10, 0x3B, 0xFF,
  0xF9, 0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_closed_caption_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 29), Box(0, 0, 35, 35),
      ic_round_36_av_closed_caption_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_closed_caption 36x36, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_round_36_av_closed_caption_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0x98, 0x3B, 0x30, 0x1E, 0xFF, 0xFB, 0x81, 0xE1, 0x6F, 0xFF, 0xD0, 0x60,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7C, 0x85,
  0xD8, 0x77, 0x77, 0x9C, 0x85, 0x97, 0x77, 0x78, 0xDC, 0x00, 0x7C, 0x02, 0x60, 0x9A, 0x09, 0x60,
  0x2C, 0x00, 0x7C, 0x28, 0x42, 0x33, 0x10, 0x7A, 0x81, 0x70, 0x10, 0xF3, 0x2C, 0x00, 0x7C, 0x20,
  0xBA, 0x81, 0xB7, 0xDA, 0x81, 0x70, 0x3B, 0x08, 0x0A, 0xC0, 0x07, 0xC2, 0x0B, 0xF8, 0x17, 0x03,
  0xFA, 0x00, 0x7C, 0x20, 0xBF, 0x81, 0x70, 0x3F, 0xA0, 0x07, 0xC2, 0x0B, 0xA8, 0x1B, 0x7D, 0xA8,
  0x17, 0x03, 0xB0, 0x80, 0xAC, 0x00, 0x7C, 0x28, 0x42, 0x33, 0x10, 0x7A, 0x81, 0x70, 0x10, 0xF3,
  0x2C, 0x00, 0x7C, 0x02, 0x60, 0x9A, 0x09, 0x60, 0x2C, 0x00, 0x7C, 0x85, 0xD8, 0x77, 0x77, 0x9C,
  0x85, 0x97, 0x77, 0x78, 0xDC, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x07, 0x06, 0xFF, 0xFD, 0x81, 0x61, 0xEF, 0xFF, 0xB8, 0x3E, 0x10, 0x3B, 0xFF,
  0xF9, 0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_closed_caption() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 29), Box(0, 0, 35, 35),
      ic_round_36_av_closed_caption_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_control_camera 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_round_36_av_control_camera_data[] PROGMEM = {
  0x77, 0x00, 0x37, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x74, 0x07, 0xC0, 0x77, 0x77, 0x20, 0x7E, 0x07,
  0x77, 0x70, 0x4F, 0x90, 0x47, 0x76, 0x07, 0xB0, 0x0B, 0xB0, 0x77, 0x76, 0x82, 0x1D, 0xFB, 0x28,
  0x2B, 0xFD, 0x17, 0x77, 0x10, 0x14, 0x01, 0x80, 0x99, 0x00, 0x81, 0x47, 0x16, 0x82, 0x26, 0x62,
  0x68, 0x11, 0x74, 0x70, 0x7A, 0x0D, 0x50, 0x9C, 0x09, 0x50, 0xDA, 0x07, 0x50, 0x7C, 0x01, 0x30,
  0x9E, 0x09, 0x30, 0x1C, 0x07, 0x30, 0x7C, 0x0B, 0x30, 0x2F, 0x90, 0x23, 0x0B, 0xC8, 0x17, 0x03,
  0xC0, 0xB4, 0x06, 0xF9, 0x06, 0x40, 0xBC, 0x00, 0x3C, 0x0B, 0x40, 0x6F, 0x90, 0x64, 0x0B, 0xC8,
  0x13, 0x07, 0xC0, 0xA3, 0x02, 0xF9, 0x02, 0x30, 0xBC, 0x07, 0x30, 0x7C, 0x01, 0x30, 0x9E, 0x09,
  0x30, 0x1C, 0x07, 0x50, 0x7A, 0x0D, 0x50, 0x9C, 0x09, 0x50, 0xDA, 0x07, 0x78, 0x14, 0x71, 0x68,
  0x22, 0x66, 0x26, 0x81, 0x17, 0x48, 0x09, 0x90, 0x00, 0x14, 0x01, 0x77, 0x71, 0x82, 0x1D, 0xFB,
  0x28, 0x2A, 0xFD, 0x17, 0x76, 0x07, 0xB0, 0x0B, 0xB0, 0x77, 0x76, 0x04, 0xF9, 0x04, 0x77, 0x70,
  0x7E, 0x07, 0x77, 0x72, 0x07, 0xC0, 0x77, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x76, 0x00, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_control_camera() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_control_camera_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_equalizer 36x36, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_36_av_equalizer_data[] PROGMEM = {
  0x73, 0x82, 0x8D, 0xD8, 0x77, 0x50, 0x8C, 0x08, 0x77, 0x40, 0xDC, 0x0D, 0x77, 0x4E, 0x77, 0x4E,
  0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x48, 0x21, 0x66, 0x17, 0x3E, 0x30, 0x30, 0xEA, 0x0E, 0x03,
  0x72, 0xE3, 0x0B, 0xC0, 0xB7, 0x2E, 0x3E, 0x72, 0xE3, 0xE1, 0x82, 0x8D, 0xD8, 0x4E, 0x3E, 0x08,
  0xC0, 0x83, 0xE3, 0xE0, 0xDC, 0x0D, 0x3E, 0x3F, 0xD3, 0xE3, 0xFD, 0x3E, 0x3F, 0xD3, 0xE3, 0xFD,
  0x3E, 0x3F, 0xD3, 0xE3, 0xFD, 0x3E, 0x3E, 0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0xD3, 0x0D, 0xC0, 0xD0,
  0x8C, 0x08, 0x30, 0x8C, 0x08, 0x30, 0x8C, 0x84, 0x80, 0x8D, 0xD8, 0x58, 0x28, 0xDD, 0x85, 0x82,
  0x8D, 0xD8, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_equalizer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 29, 29), Box(0, 0, 35, 35),
      ic_round_36_av_equalizer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_explicit 36x36, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_round_36_av_explicit_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xA0, 0x98, 0x02, 0x70, 0x9F, 0xA0,
  0x07, 0xF9, 0x09, 0x71, 0x09, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x9F, 0x90, 0x07, 0xF9, 0x07,
  0x28, 0x43, 0x77, 0x77, 0x9F, 0xA0, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0xF0, 0x07, 0xF9, 0x07, 0x20,
  0x7F, 0xF0, 0x07, 0xF9, 0x07, 0x28, 0x43, 0x77, 0x77, 0x9F, 0xA0, 0x07, 0xF9, 0x07, 0x71, 0x09,
  0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x9F, 0x90, 0x07, 0xF9, 0x07, 0x28, 0x43, 0x77, 0x77, 0x9F,
  0xA0, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0xF0, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0xF0, 0x07, 0xF9, 0x07,
  0x28, 0x43, 0x77, 0x77, 0x9F, 0xA0, 0x07, 0xF9, 0x07, 0x71, 0x09, 0xF9, 0x00, 0x7F, 0x90, 0x97,
  0x10, 0x9F, 0x90, 0x07, 0xFA, 0x09, 0x80, 0x27, 0x09, 0xFA, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48,
  0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_explicit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_explicit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_fast_forward 36x36, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_36_av_fast_forward_data[] PROGMEM = {
  0x81, 0x38, 0x37, 0x40, 0x06, 0x72, 0x0D, 0xA0, 0x87, 0x20, 0x5A, 0x0D, 0x03, 0x7C, 0x0C, 0x02,
  0x70, 0x7C, 0x07, 0x6D, 0x0E, 0x06, 0x60, 0x7D, 0x0B, 0x01, 0x4F, 0x0A, 0x01, 0x40, 0x7E, 0x0E,
  0x05, 0x3F, 0x90, 0xE0, 0x43, 0x07, 0xF9, 0x09, 0x2F, 0xB0, 0x92, 0x07, 0xFA, 0x0D, 0x03, 0xFC,
  0x81, 0x70, 0x7F, 0xB0, 0xEF, 0xC8, 0x17, 0x07, 0xFB, 0x0E, 0xFB, 0x09, 0x20, 0x7F, 0xA0, 0xD0,
  0x3F, 0x90, 0xE0, 0x43, 0x07, 0xF9, 0x0A, 0x01, 0x1F, 0x0B, 0x01, 0x40, 0x7E, 0x0E, 0x05, 0x3D,
  0x0E, 0x06, 0x60, 0x7D, 0x0B, 0x01, 0x4C, 0x0C, 0x02, 0x70, 0x7C, 0x07, 0x60, 0xDA, 0x08, 0x72,
  0x05, 0xA0, 0xD0, 0x37, 0x81, 0x38, 0x37, 0x40, 0x60, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_fast_forward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 30, 25), Box(0, 0, 35, 35),
      ic_round_36_av_fast_forward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_fast_rewind 36x36, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_36_av_fast_rewind_data[] PROGMEM = {
  0x72, 0x07, 0x06, 0x74, 0x81, 0x38, 0x37, 0x03, 0x0D, 0xA0, 0x57, 0x20, 0x8A, 0x0D, 0x60, 0x7C,
  0x07, 0x70, 0x20, 0xCC, 0x40, 0x10, 0xBD, 0x07, 0x60, 0x60, 0xED, 0x30, 0x50, 0xEE, 0x07, 0x40,
  0x10, 0xAF, 0x10, 0x10, 0xAF, 0x90, 0x73, 0x04, 0x0E, 0xF9, 0x03, 0x0D, 0xFA, 0x07, 0x20, 0x9F,
  0xB0, 0xEF, 0xB8, 0x17, 0x07, 0xFC, 0x0E, 0xFB, 0x81, 0x70, 0x7F, 0xC0, 0x30, 0xDF, 0xA0, 0x72,
  0x09, 0xFB, 0x20, 0x9F, 0x90, 0x73, 0x04, 0x0E, 0xF9, 0x30, 0x50, 0xEE, 0x07, 0x40, 0x10, 0xAF,
  0x40, 0x10, 0xBD, 0x07, 0x60, 0x60, 0xED, 0x60, 0x7C, 0x07, 0x70, 0x20, 0xCC, 0x70, 0x30, 0xDA,
  0x05, 0x72, 0x08, 0xA0, 0xD7, 0x20, 0x06, 0x74, 0x81, 0x38, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_fast_rewind() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 10, 29, 25), Box(0, 0, 35, 35),
      ic_round_36_av_fast_rewind_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_featured_play_list 36x36, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_36_av_featured_play_list_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x06, 0x70, 0x80, 0xDF, 0xFA, 0x00, 0x7A, 0x09, 0x75, 0x02, 0xFF, 0xA0, 0x07, 0xA0,
  0x97, 0x50, 0x2F, 0xFA, 0x00, 0x7B, 0x09, 0x80, 0x67, 0x08, 0x0D, 0xFF, 0xA0, 0x07, 0xFF, 0xFF,
  0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xB0, 0x98, 0x06, 0x70, 0x80, 0xDF, 0xFA, 0x00, 0x7A, 0x09,
  0x75, 0x02, 0xFF, 0xA0, 0x07, 0xA0, 0x97, 0x50, 0x2F, 0xFA, 0x00, 0x7B, 0x09, 0x80, 0x67, 0x08,
  0x0D, 0xFF, 0xA0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x30, 0x48, 0x0B,
  0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_featured_play_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_av_featured_play_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_featured_video 36x36, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_round_36_av_featured_video_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x06, 0x70, 0x80, 0xDF, 0xFA, 0x00, 0x7A, 0x09, 0x75, 0x02, 0xFF, 0xA0, 0x07, 0xA0,
  0x77, 0x6F, 0xFA, 0x00, 0x7A, 0x07, 0x76, 0xFF, 0xA0, 0x07, 0xA0, 0x77, 0x6F, 0xFA, 0x00, 0x7A,
  0x07, 0x76, 0xFF, 0xA0, 0x07, 0xA0, 0x77, 0x6F, 0xFA, 0x00, 0x7A, 0x07, 0x76, 0xFF, 0xA0, 0x07,
  0xA0, 0x77, 0x6F, 0xFA, 0x00, 0x7A, 0x08, 0x76, 0xFF, 0xA0, 0x07, 0xA0, 0xD0, 0x27, 0x40, 0x7F,
  0xFA, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF,
  0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF,
  0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x07, 0x04, 0xFF,
  0xFF, 0xC8, 0x14, 0x09, 0xFF, 0xFF, 0xA0, 0x93, 0x04, 0x80, 0xB0, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_featured_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_av_featured_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_fiber_dvr 36x36, 4-bit Alpha,  RLE, 229 bytes.
static const unsigned char ic_round_36_av_fiber_dvr_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0xAF, 0xFF, 0xFA, 0x81, 0xA0, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xA0, 0xD8, 0x01, 0x70, 0xAB, 0x81, 0xE8, 0xEA,
  0x0B, 0x09, 0xB8, 0x5B, 0x77, 0x77, 0x8D, 0xB0, 0x07, 0xA0, 0x76, 0x06, 0xA8, 0x17, 0x06, 0xA2,
  0x0D, 0xA7, 0x0D, 0xA0, 0x07, 0xA8, 0x47, 0x01, 0x33, 0x22, 0xA8, 0x39, 0x01, 0xFB, 0x2B, 0x28,
  0x42, 0x33, 0x10, 0x8A, 0x00, 0x7A, 0x81, 0x70, 0x3A, 0x0B, 0x2A, 0x0E, 0x28, 0x2C, 0x60, 0x5B,
  0x20, 0xBA, 0x81, 0x30, 0x7A, 0x00, 0x7A, 0x81, 0x70, 0x3A, 0x0B, 0x2B, 0x84, 0x30, 0x82, 0x09,
  0xB2, 0x84, 0x23, 0x31, 0x08, 0xA0, 0x07, 0xA8, 0x17, 0x03, 0xA0, 0xB2, 0xB8, 0x17, 0x01, 0x20,
  0xDB, 0x60, 0x10, 0xDA, 0x00, 0x7A, 0x81, 0x70, 0x3A, 0x0B, 0x2B, 0x0C, 0x30, 0x3C, 0x20, 0x50,
  0x72, 0x0A, 0xB0, 0x07, 0xA8, 0x47, 0x01, 0x33, 0x22, 0xC0, 0x12, 0x07, 0xC2, 0x83, 0xBF, 0x60,
  0x5B, 0x00, 0x7A, 0x07, 0x60, 0x6C, 0x07, 0x20, 0xCC, 0x28, 0x1C, 0xFC, 0x20, 0xEA, 0x00, 0x7A,
  0x0D, 0x80, 0x17, 0x0A, 0xD8, 0x1E, 0x9B, 0xD0, 0xB0, 0x9B, 0x81, 0x51, 0xEA, 0x00, 0x7F, 0xFF,
  0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF,
  0xFC, 0x00, 0x7F, 0xFF, 0xFC, 0x07, 0x04, 0xFF, 0xFF, 0xC8, 0x14, 0x09, 0xFF, 0xFF, 0xA0, 0x93,
  0x04, 0x80, 0xB0, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_fiber_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_av_fiber_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_fiber_manual_record 36x36, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_round_36_av_fiber_manual_record_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x75, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x72, 0x04, 0x0E,
  0xFD, 0x0E, 0x04, 0x70, 0x6F, 0xFA, 0x06, 0x50, 0x4F, 0xFC, 0x04, 0x30, 0x10, 0xEF, 0xFC, 0x0E,
  0x01, 0x20, 0x9F, 0xFE, 0x81, 0x90, 0x1F, 0xFF, 0x90, 0x10, 0x6F, 0xFF, 0x90, 0x60, 0xBF, 0xFF,
  0x90, 0xB0, 0xDF, 0xFF, 0x90, 0xD0, 0xEF, 0xFF, 0x90, 0x0E, 0xFF, 0xF9, 0x0E, 0x0D, 0xFF, 0xF9,
  0x0D, 0x0B, 0xFF, 0xF9, 0x0B, 0x06, 0xFF, 0xF9, 0x06, 0x01, 0xFF, 0xF9, 0x81, 0x10, 0x9F, 0xFE,
  0x09, 0x20, 0x10, 0xEF, 0xFC, 0x0E, 0x01, 0x30, 0x4F, 0xFC, 0x04, 0x50, 0x6F, 0xFA, 0x06, 0x70,
  0x40, 0xEF, 0xD0, 0xE0, 0x47, 0x20, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0x58, 0x90, 0x16, 0xAD, 0xEE,
  0xDA, 0x61, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_fiber_manual_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 29, 29), Box(0, 0, 35, 35),
      ic_round_36_av_fiber_manual_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_fiber_new 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_round_36_av_fiber_new_data[] PROGMEM = {
  0x10, 0x80, 0xEF, 0xFF, 0xB8, 0x2E, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xE6, 0xF8, 0x1D, 0x8D, 0xB8, 0x7A, 0xCF, 0xD8, 0x77, 0x79, 0xA0, 0x90, 0xDD, 0x09, 0x0D, 0xC8,
  0x14, 0x02, 0xA8, 0x3E, 0x04, 0xF5, 0x58, 0x2D, 0xC0, 0x6C, 0x81, 0xD0, 0x5C, 0x03, 0x28, 0xA5,
  0x6F, 0xD0, 0x3F, 0x30, 0x49, 0x9B, 0xFB, 0x06, 0xF8, 0x1E, 0xD0, 0x4C, 0x03, 0x38, 0x6B, 0xD0,
  0x3F, 0x30, 0x7C, 0x89, 0x0B, 0x06, 0xF4, 0x0C, 0xD0, 0x4C, 0x8B, 0x03, 0x03, 0x01, 0xC0, 0x3F,
  0x30, 0x11, 0x12, 0xEB, 0x06, 0xF4, 0x0C, 0xD0, 0x4C, 0x89, 0x03, 0x0C, 0x10, 0x30, 0x3F, 0x34,
  0x89, 0x22, 0xEB, 0x06, 0xF4, 0x0C, 0xD0, 0x4C, 0x82, 0x30, 0xDB, 0x38, 0x33, 0xF3, 0x07, 0xC8,
  0x90, 0xB0, 0x6F, 0x40, 0xCD, 0x04, 0xC8, 0x33, 0x0D, 0xF7, 0x28, 0xA1, 0x3F, 0x30, 0x49, 0x9B,
  0xFB, 0x01, 0x31, 0x03, 0x30, 0x4C, 0x81, 0x40, 0xEA, 0x83, 0x30, 0x4F, 0x55, 0x00, 0xD7, 0x10,
  0x6C, 0x0D, 0x0A, 0xB8, 0x90, 0xE8, 0xDF, 0xE8, 0x77, 0x79, 0xA0, 0xB8, 0x02, 0x70, 0x80, 0xE8,
  0x09, 0xE6, 0xF0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28, 0x08, 0xEF, 0xFF, 0xB0, 0xE0,
  0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_fiber_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_fiber_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_fiber_pin 36x36, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_round_36_av_fiber_pin_data[] PROGMEM = {
  0x10, 0x80, 0xEF, 0xFF, 0xB8, 0x2E, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xE7, 0xF8, 0x5D, 0x87, 0x77, 0x8D, 0xB8, 0x1E, 0x8D, 0xC0, 0x80, 0xCB, 0x0C, 0x0B, 0xE0, 0x26,
  0x0D, 0xA8, 0x18, 0x04, 0xB0, 0x82, 0x0D, 0xA0, 0x21, 0xE2, 0x84, 0x23, 0x31, 0x08, 0xA8, 0x17,
  0x03, 0xB0, 0x72, 0x03, 0xA0, 0x11, 0xE2, 0x0B, 0xA8, 0x13, 0x07, 0xA8, 0x17, 0x03, 0xB0, 0x73,
  0x81, 0x7F, 0x11, 0xE2, 0x84, 0x23, 0x31, 0x08, 0xA8, 0x17, 0x03, 0xB8, 0x17, 0x03, 0x20, 0xB0,
  0x11, 0xE7, 0x0D, 0xA8, 0x17, 0x03, 0xB8, 0x57, 0x09, 0x40, 0x11, 0x1E, 0x28, 0x35, 0x77, 0x8D,
  0xB8, 0x17, 0x03, 0xB8, 0x37, 0x09, 0xE1, 0x3E, 0x20, 0xBF, 0x81, 0x70, 0x3B, 0x83, 0x70, 0x9F,
  0xB3, 0xE2, 0x0C, 0xF8, 0x18, 0x04, 0xB8, 0x18, 0x0A, 0xA0, 0x72, 0xE0, 0xB0, 0x9F, 0x98, 0x1E,
  0x8D, 0xB8, 0x1E, 0x9E, 0xB0, 0x90, 0xB8, 0x09, 0xE7, 0xF0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF,
  0xF8, 0x28, 0x08, 0xEF, 0xFF, 0xB0, 0xE0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_fiber_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_fiber_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_fiber_smart_record 36x36, 4-bit Alpha,  RLE, 187 bytes.
static const unsigned char ic_round_36_av_fiber_smart_record_data[] PROGMEM = {
  0x71, 0x87, 0x48, 0xCD, 0xFD, 0xC8, 0x47, 0x77, 0x20, 0x50, 0xDF, 0xA0, 0xD0, 0x55, 0x82, 0x2E,
  0xD5, 0x74, 0x0A, 0xFE, 0x0A, 0x40, 0x7B, 0x0A, 0x01, 0x70, 0x10, 0xCF, 0xF9, 0x0C, 0x01, 0x20,
  0x20, 0xDB, 0x0C, 0x01, 0x60, 0xBF, 0xFB, 0x0B, 0x30, 0x10, 0x9B, 0x0C, 0x50, 0x8F, 0xFD, 0x08,
  0x40, 0x5B, 0x08, 0x30, 0x2F, 0xFF, 0x02, 0x40, 0x7B, 0x02, 0x20, 0x9F, 0xFF, 0x09, 0x50, 0xBA,
  0x09, 0x20, 0xEF, 0xFF, 0x0E, 0x50, 0x4A, 0x81, 0xE0, 0x3F, 0xFF, 0xA0, 0x35, 0x0D, 0xA0, 0x30,
  0x5F, 0xFF, 0xA0, 0x55, 0x0B, 0xA0, 0x50, 0x6F, 0xFF, 0xA0, 0x65, 0x08, 0xA0, 0x70, 0x6F, 0xFF,
  0xA0, 0x65, 0x08, 0xA0, 0x70, 0x5F, 0xFF, 0xA0, 0x55, 0x0B, 0xA0, 0x50, 0x3F, 0xFF, 0xA0, 0x35,
  0x0D, 0xA8, 0x13, 0x0E, 0xFF, 0xF0, 0xE5, 0x04, 0xA0, 0xE2, 0x09, 0xFF, 0xF0, 0x95, 0x0B, 0xA0,
  0x92, 0x02, 0xFF, 0xF0, 0x24, 0x07, 0xB0, 0x23, 0x08, 0xFF, 0xD0, 0x84, 0x05, 0xB0, 0x85, 0x0B,
  0xFF, 0xB0, 0xB3, 0x01, 0x09, 0xB0, 0xC6, 0x01, 0x0C, 0xFF, 0x90, 0xC0, 0x12, 0x02, 0x0D, 0xB0,
  0xC0, 0x17, 0x10, 0xAF, 0xE0, 0xA4, 0x07, 0xB0, 0xA0, 0x17, 0x30, 0x50, 0xDF, 0xA0, 0xD0, 0x55,
  0x82, 0x2E, 0xD5, 0x77, 0x87, 0x48, 0xCD, 0xFD, 0xC8, 0x47, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_fiber_smart_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 34, 29), Box(0, 0, 35, 35),
      ic_round_36_av_fiber_smart_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_forward_10 36x36, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_round_36_av_forward_10_data[] PROGMEM = {
  0x75, 0x04, 0x01, 0x77, 0x71, 0x90, 0xD0, 0x17, 0x77, 0xA0, 0xD0, 0x17, 0x76, 0xB0, 0xD0, 0x17,
  0x75, 0xC0, 0xD0, 0x17, 0x71, 0x81, 0x35, 0x6D, 0x0D, 0x01, 0x74, 0x81, 0x28, 0xDF, 0xA0, 0xD7,
  0x30, 0x7F, 0xD0, 0xD7, 0x10, 0x10, 0xCC, 0x81, 0xDA, 0x8D, 0x0D, 0x01, 0x70, 0x10, 0xCB, 0x0B,
  0x03, 0x3C, 0x0D, 0x01, 0x71, 0x0A, 0xB0, 0x65, 0xB0, 0xD0, 0x17, 0x10, 0x5B, 0x05, 0x6A, 0x0D,
  0x01, 0x72, 0x0D, 0xA0, 0x97, 0x90, 0xD0, 0x17, 0x20, 0x3A, 0x0E, 0x71, 0x04, 0x01, 0x73, 0x09,
  0xA0, 0x87, 0x76, 0x0B, 0xA0, 0x35, 0x00, 0x22, 0x81, 0x26, 0x37, 0x10, 0xDA, 0x01, 0x38, 0x90,
  0x3C, 0xF5, 0x02, 0xE9, 0xE5, 0x70, 0xEA, 0x48, 0x90, 0x34, 0xE5, 0x07, 0xC0, 0x8A, 0x48, 0x22,
  0x71, 0xDA, 0x01, 0x58, 0x6E, 0x50, 0x8B, 0x07, 0xC4, 0x82, 0xEF, 0xBC, 0xA0, 0x35, 0x86, 0xE5,
  0x08, 0xB0, 0x7B, 0x30, 0x4A, 0x0C, 0x09, 0xA0, 0x95, 0x86, 0xE5, 0x05, 0xD0, 0xA9, 0x30, 0x8A,
  0x08, 0x04, 0xA0, 0xE5, 0x0E, 0x05, 0x28, 0x2B, 0xFD, 0x23, 0x0E, 0xA8, 0x14, 0x0D, 0xA0, 0x87,
  0x70, 0x8A, 0x0D, 0x20, 0x6B, 0x04, 0x75, 0x05, 0xB0, 0x53, 0x0C, 0xB0, 0x67, 0x30, 0x6B, 0x0A,
  0x40, 0x10, 0xDB, 0x0A, 0x04, 0x60, 0x30, 0xBB, 0x0D, 0x60, 0x20, 0xDC, 0x84, 0xDA, 0x88, 0xAD,
  0xC0, 0xB0, 0x17, 0x01, 0x09, 0xFD, 0x08, 0x74, 0x81, 0x29, 0xEE, 0x81, 0xD9, 0x27, 0x71, 0x84,
  0x35, 0x76, 0x53, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_forward_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 29, 31), Box(0, 0, 35, 35),
      ic_round_36_av_forward_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_forward_30 36x36, 4-bit Alpha,  RLE, 216 bytes.
static const unsigned char ic_round_36_av_forward_30_data[] PROGMEM = {
  0x75, 0x04, 0x01, 0x77, 0x71, 0x90, 0xD0, 0x17, 0x77, 0xA0, 0xD0, 0x17, 0x76, 0xB0, 0xD0, 0x17,
  0x75, 0xC0, 0xD0, 0x17, 0x71, 0x81, 0x35, 0x6D, 0x0D, 0x01, 0x74, 0x81, 0x28, 0xDF, 0xA0, 0xD7,
  0x30, 0x7F, 0xD0, 0xD7, 0x10, 0x10, 0xCC, 0x81, 0xDA, 0x8D, 0x0D, 0x01, 0x70, 0x10, 0xCB, 0x0B,
  0x03, 0x3C, 0x0D, 0x01, 0x71, 0x0A, 0xB0, 0x65, 0xB0, 0xD0, 0x17, 0x10, 0x5B, 0x05, 0x6A, 0x0D,
  0x01, 0x72, 0x0D, 0xA0, 0x97, 0x90, 0xD0, 0x17, 0x20, 0x3A, 0x0E, 0x71, 0x04, 0x01, 0x73, 0x09,
  0xA0, 0x87, 0x76, 0x0B, 0xA0, 0x34, 0x81, 0x55, 0x12, 0x81, 0x16, 0x57, 0x10, 0xDA, 0x01, 0x38,
  0x2C, 0xCB, 0xD2, 0x82, 0xDA, 0xD7, 0x70, 0xEA, 0x48, 0x90, 0x31, 0x1F, 0x24, 0xE0, 0x5D, 0x48,
  0x22, 0x71, 0xDA, 0x01, 0x48, 0x77, 0xDA, 0x05, 0xD0, 0x4E, 0x48, 0x2E, 0xFB, 0xCA, 0x03, 0x48,
  0x72, 0x6E, 0x25, 0xD0, 0x5E, 0x30, 0x4A, 0x0C, 0x09, 0xA0, 0x93, 0x89, 0x0B, 0x31, 0xF3, 0x2F,
  0x17, 0xC3, 0x08, 0xA0, 0x80, 0x4A, 0x0E, 0x30, 0x8A, 0x0A, 0x28, 0x29, 0xFE, 0x43, 0x0E, 0xA8,
  0x14, 0x0D, 0xA0, 0x87, 0x70, 0x8A, 0x0D, 0x20, 0x6B, 0x04, 0x75, 0x05, 0xB0, 0x53, 0x0C, 0xB0,
  0x67, 0x30, 0x6B, 0x0A, 0x40, 0x10, 0xDB, 0x0A, 0x04, 0x60, 0x30, 0xBB, 0x0D, 0x60, 0x20, 0xDC,
  0x84, 0xDA, 0x88, 0xAD, 0xC0, 0xB0, 0x17, 0x01, 0x09, 0xFD, 0x08, 0x74, 0x81, 0x29, 0xEE, 0x81,
  0xD9, 0x27, 0x71, 0x84, 0x35, 0x76, 0x53, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_forward_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 29, 31), Box(0, 0, 35, 35),
      ic_round_36_av_forward_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_forward_5 36x36, 4-bit Alpha,  RLE, 200 bytes.
static const unsigned char ic_round_36_av_forward_5_data[] PROGMEM = {
  0x75, 0x04, 0x01, 0x77, 0x71, 0x90, 0xC0, 0x17, 0x76, 0x01, 0xA0, 0xC0, 0x17, 0x75, 0x01, 0xB0,
  0xC0, 0x17, 0x74, 0x01, 0xC0, 0xC0, 0x17, 0x71, 0x81, 0x35, 0x7D, 0x0C, 0x01, 0x74, 0x81, 0x29,
  0xEF, 0xA0, 0xC7, 0x30, 0x8F, 0xD0, 0xC7, 0x10, 0x10, 0xCC, 0x81, 0xDA, 0x9D, 0x0C, 0x01, 0x70,
  0x10, 0xDB, 0x0B, 0x03, 0x20, 0x1C, 0x0C, 0x01, 0x71, 0x0B, 0xB0, 0x54, 0x01, 0xB0, 0xC0, 0x17,
  0x10, 0x6B, 0x04, 0x50, 0x1A, 0x0C, 0x01, 0x72, 0x0E, 0xA0, 0x77, 0x90, 0xC0, 0x17, 0x20, 0x4A,
  0x0D, 0x71, 0x04, 0x01, 0x73, 0x0A, 0xA0, 0x77, 0x76, 0x0C, 0xA0, 0x26, 0x03, 0x0F, 0x57, 0x3B,
  0x78, 0x2B, 0xB9, 0x97, 0x3A, 0x0E, 0x78, 0x1D, 0x51, 0x71, 0x82, 0x36, 0x1E, 0xA7, 0x82, 0xED,
  0xE9, 0x60, 0x1A, 0x0A, 0x0D, 0xA0, 0x27, 0x10, 0x39, 0x60, 0x5A, 0x0B, 0x0A, 0xA0, 0x75, 0x82,
  0x1B, 0x34, 0x96, 0x09, 0xA0, 0x70, 0x6A, 0x0D, 0x60, 0x8A, 0x06, 0x50, 0x10, 0xEA, 0x81, 0x30,
  0xEA, 0x07, 0x77, 0x09, 0xA0, 0xB2, 0x07, 0xB0, 0x37, 0x50, 0x6B, 0x04, 0x30, 0xDA, 0x0E, 0x05,
  0x73, 0x07, 0xB0, 0x94, 0x02, 0x0E, 0xB0, 0xA0, 0x36, 0x04, 0x0C, 0xB0, 0xC6, 0x02, 0x0D, 0xC8,
  0x4D, 0xA8, 0x8A, 0xEC, 0x0B, 0x71, 0x01, 0x0A, 0xFC, 0x0E, 0x07, 0x74, 0x81, 0x3A, 0xEE, 0x81,
  0xD8, 0x17, 0x71, 0x84, 0x35, 0x76, 0x52, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_forward_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 29, 31), Box(0, 0, 35, 35),
      ic_round_36_av_forward_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_games 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_round_36_av_games_data[] PROGMEM = {
  0x73, 0x02, 0x0D, 0xE0, 0xD0, 0x27, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76,
  0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90,
  0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x30, 0xEF, 0x03, 0x77, 0x70, 0x40, 0xED, 0x04, 0x74,
  0x02, 0x80, 0x37, 0x03, 0x30, 0x40, 0xEB, 0x04, 0x30, 0x38, 0x03, 0x70, 0x20, 0xDF, 0x90, 0x43,
  0x82, 0x4E, 0xF4, 0x30, 0x4F, 0x90, 0xDF, 0xB0, 0x43, 0x02, 0x03, 0x30, 0x4F, 0xFF, 0x04, 0x60,
  0x4F, 0xFF, 0xA0, 0x34, 0x03, 0xFF, 0xFA, 0x0E, 0x02, 0x40, 0x3F, 0xFF, 0x90, 0xE0, 0x46, 0x04,
  0xFF, 0xE0, 0xE0, 0x43, 0x03, 0x02, 0x30, 0x4F, 0xB0, 0xDF, 0x0E, 0x04, 0x38, 0x24, 0xFE, 0x43,
  0x04, 0xF9, 0x0D, 0x02, 0x80, 0x37, 0x03, 0x30, 0x4B, 0x0E, 0x04, 0x30, 0x38, 0x03, 0x70, 0x27,
  0x40, 0x4D, 0x0E, 0x04, 0x77, 0x70, 0x3F, 0x0E, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07,
  0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77,
  0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x02, 0x0D, 0xE0, 0xD0, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_games() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_games_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_hd 36x36, 4-bit Alpha,  RLE, 186 bytes.
static const unsigned char ic_round_36_av_hd_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xC0, 0xB0, 0x9B, 0x81, 0xD8, 0xEA, 0x0D, 0x80, 0x17, 0x08, 0x0D, 0xC0,
  0x07, 0xC2, 0x0C, 0xA8, 0x14, 0x08, 0xA0, 0x76, 0x02, 0xC0, 0x07, 0xC2, 0x0B, 0xA8, 0x13, 0x07,
  0xA8, 0x47, 0x01, 0x33, 0x22, 0xC0, 0x07, 0xC2, 0x0B, 0xA8, 0x13, 0x07, 0xA8, 0x17, 0x03, 0xA0,
  0xB2, 0xC0, 0x07, 0xC2, 0x84, 0x23, 0x31, 0x07, 0xA8, 0x17, 0x03, 0xA0, 0xB2, 0xC0, 0x07, 0xC7,
  0x07, 0xA8, 0x17, 0x03, 0xA0, 0xB2, 0xC0, 0x07, 0xC2, 0x84, 0x57, 0x71, 0x07, 0xA8, 0x17, 0x03,
  0xA0, 0xB2, 0xC0, 0x07, 0xC2, 0x0B, 0xA8, 0x13, 0x07, 0xA8, 0x47, 0x01, 0x33, 0x22, 0xC0, 0x07,
  0xC2, 0x0C, 0xA8, 0x14, 0x08, 0xA0, 0x76, 0x02, 0xC0, 0x07, 0xC0, 0xB0, 0x9B, 0x81, 0xD8, 0xEA,
  0x0D, 0x80, 0x17, 0x08, 0x0D, 0xC0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14,
  0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_hd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_hd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_hearing_disabled 36x36, 4-bit Alpha,  RLE, 297 bytes.
static const unsigned char ic_round_36_av_hearing_disabled_data[] PROGMEM = {
  0x77, 0x72, 0x81, 0x16, 0x27, 0x68, 0x66, 0xAD, 0xFE, 0xDA, 0x56, 0x82, 0xBF, 0xE2, 0x50, 0x14,
  0x06, 0x0E, 0xF9, 0x0E, 0x07, 0x40, 0xBA, 0x0B, 0x38, 0x21, 0xDF, 0x73, 0x04, 0xFC, 0x0B, 0x01,
  0x20, 0x3B, 0x06, 0x20, 0x3B, 0x07, 0x38, 0x74, 0xD7, 0x31, 0x02, 0x6D, 0xB0, 0xC3, 0x07, 0xA0,
  0xD3, 0x0A, 0xB0, 0x77, 0x40, 0x7B, 0x09, 0x30, 0xEA, 0x05, 0x30, 0xAB, 0x07, 0x74, 0x06, 0xB0,
  0x32, 0x07, 0xA0, 0xA4, 0x0D, 0xB0, 0x74, 0x00, 0x25, 0x0A, 0xA0, 0xB2, 0x02, 0xA0, 0xE4, 0x0E,
  0xC0, 0x73, 0x82, 0x4F, 0xD3, 0x30, 0x2B, 0x30, 0xDA, 0x03, 0x20, 0x4E, 0x07, 0x38, 0x24, 0xFE,
  0x23, 0x0C, 0xA0, 0x42, 0x0A, 0xA0, 0x52, 0x03, 0xA0, 0x80, 0xBB, 0x07, 0x38, 0x14, 0xF8, 0x30,
  0x9A, 0x06, 0x20, 0x9A, 0x06, 0x30, 0x40, 0x62, 0x0B, 0xB0, 0x73, 0x04, 0x0A, 0x30, 0x8A, 0x07,
  0x20, 0x8A, 0x07, 0x71, 0x0B, 0xB0, 0x73, 0x01, 0x30, 0x9A, 0x06, 0x20, 0x9A, 0x06, 0x72, 0x0B,
  0xB0, 0x76, 0x0C, 0xA0, 0x42, 0x0A, 0xA0, 0x57, 0x30, 0xBB, 0x07, 0x40, 0x2B, 0x01, 0x20, 0xDA,
  0x03, 0x74, 0x0B, 0xB0, 0x73, 0x03, 0xA0, 0xB2, 0x02, 0xA0, 0xE7, 0x60, 0xBB, 0x07, 0x38, 0x14,
  0xF4, 0x20, 0x7A, 0x0A, 0x77, 0x0B, 0xB0, 0x73, 0x03, 0x30, 0xEA, 0x05, 0x77, 0x10, 0xBB, 0x07,
  0x50, 0x7A, 0x0D, 0x77, 0x30, 0xBB, 0x07, 0x40, 0xEA, 0x06, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x38,
  0x14, 0xFB, 0x77, 0x20, 0x30, 0xEE, 0x07, 0x30, 0x40, 0x27, 0x71, 0x01, 0x0D, 0xA8, 0x1E, 0x3B,
  0xB0, 0x77, 0x75, 0x07, 0xA0, 0xD0, 0x12, 0x0B, 0xB0, 0x77, 0x74, 0x0D, 0xA0, 0x54, 0x0B, 0xB0,
  0x77, 0x18, 0x1B, 0xE5, 0x50, 0x5A, 0x0D, 0x60, 0xBB, 0x07, 0x60, 0x3A, 0x0D, 0x50, 0xDA, 0x07,
  0x70, 0xBB, 0x07, 0x60, 0xDA, 0x83, 0xC3, 0x03, 0xCA, 0x0E, 0x01, 0x71, 0x0B, 0xB0, 0x75, 0x05,
  0xFA, 0x05, 0x73, 0x0B, 0xB0, 0x75, 0x06, 0xF0, 0x67, 0x50, 0xBB, 0x01, 0x58, 0x52, 0x9C, 0xFD,
  0x92, 0x77, 0x81, 0xBF, 0xD7, 0x77, 0x70, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_hearing_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 31, 33), Box(0, 0, 35, 35),
      ic_round_36_av_hearing_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_hearing 36x36, 4-bit Alpha,  RLE, 265 bytes.
static const unsigned char ic_round_36_av_hearing_data[] PROGMEM = {
  0x48, 0x12, 0x61, 0x77, 0x73, 0x82, 0x2E, 0xFB, 0x68, 0x65, 0xAD, 0xEE, 0xDA, 0x67, 0x30, 0xBA,
  0x0B, 0x40, 0x70, 0xEF, 0x90, 0xE0, 0x77, 0x06, 0xB0, 0x32, 0x01, 0x0B, 0xFD, 0x0B, 0x01, 0x50,
  0xDA, 0x07, 0x30, 0xCB, 0x81, 0xD6, 0x22, 0x81, 0x26, 0xDB, 0x0C, 0x40, 0x5A, 0x0E, 0x30, 0x9B,
  0x07, 0x71, 0x07, 0xB0, 0x93, 0x0A, 0xA0, 0x72, 0x03, 0xB0, 0x67, 0x30, 0x6B, 0x03, 0x20, 0xEA,
  0x02, 0x20, 0xBA, 0x0A, 0x50, 0x02, 0x50, 0xAA, 0x81, 0xA0, 0x3A, 0x0D, 0x3B, 0x02, 0x30, 0x30,
  0xDA, 0x0D, 0x03, 0x30, 0x2B, 0x01, 0x05, 0xA0, 0xA2, 0x04, 0xA0, 0xC3, 0x02, 0x0E, 0xC0, 0xE0,
  0x23, 0x0C, 0xA0, 0x40, 0x6A, 0x09, 0x20, 0x6A, 0x09, 0x30, 0x8E, 0x08, 0x30, 0x8A, 0x05, 0x07,
  0xA0, 0x82, 0x07, 0xA0, 0x83, 0x0A, 0xE0, 0xA4, 0x82, 0x76, 0x06, 0xA0, 0x92, 0x06, 0xA0, 0x93,
  0x08, 0xE0, 0x87, 0x05, 0xA0, 0xA2, 0x04, 0xA0, 0xC3, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x03, 0xA0,
  0xD2, 0x01, 0xB0, 0x23, 0x03, 0x0D, 0xA0, 0xD0, 0x37, 0x20, 0xEA, 0x02, 0x20, 0xBA, 0x08, 0x50,
  0x02, 0x74, 0x0A, 0xA0, 0x72, 0x04, 0xA0, 0xE0, 0x27, 0x73, 0x05, 0xA0, 0xE3, 0x0C, 0xA0, 0xC7,
  0x74, 0x0D, 0xA0, 0x72, 0x02, 0xB0, 0xB7, 0x73, 0x06, 0xB0, 0x22, 0x06, 0xB0, 0xC0, 0x27, 0x72,
  0x0B, 0xA0, 0xB3, 0x07, 0xB0, 0xE0, 0x37, 0x71, 0x82, 0x2E, 0xFB, 0x40, 0x5B, 0x0E, 0x03, 0x77,
  0x18, 0x12, 0x61, 0x50, 0x30, 0xEA, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xA0, 0x77, 0x77, 0x30,
  0x5A, 0x0D, 0x77, 0x74, 0x0D, 0xA0, 0x55, 0x82, 0x5E, 0xD1, 0x77, 0x10, 0x7A, 0x0D, 0x50, 0xEA,
  0x04, 0x77, 0x10, 0x10, 0xEA, 0x83, 0xC3, 0x03, 0xCA, 0x0D, 0x77, 0x30, 0x5F, 0xA0, 0x57, 0x74,
  0x06, 0xF0, 0x67, 0x76, 0x85, 0x29, 0xDF, 0xC9, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_hearing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 31, 32), Box(0, 0, 35, 35),
      ic_round_36_av_hearing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_high_quality 36x36, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_round_36_av_high_quality_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0x98, 0x3B, 0x30, 0x1E, 0xFF, 0xFB, 0x81, 0xE1, 0x6F, 0xFF, 0xD0, 0x60,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7C, 0x0B,
  0x09, 0xB8, 0x1D, 0x8E, 0xB8, 0x59, 0x77, 0x77, 0x8D, 0xC0, 0x07, 0xC2, 0x0C, 0xA8, 0x14, 0x08,
  0xA0, 0x96, 0x02, 0xC0, 0x07, 0xC2, 0x0B, 0xA8, 0x13, 0x07, 0xA8, 0x47, 0x01, 0x33, 0x22, 0xC0,
  0x07, 0xC2, 0x0B, 0xA8, 0x13, 0x07, 0xA8, 0x17, 0x03, 0xA0, 0xB2, 0xC0, 0x07, 0xC2, 0x84, 0x23,
  0x31, 0x07, 0xA8, 0x17, 0x03, 0xA0, 0xB2, 0xC0, 0x07, 0xC7, 0x07, 0xA8, 0x17, 0x03, 0xA0, 0xB2,
  0xC0, 0x07, 0xC2, 0x84, 0x57, 0x71, 0x07, 0xA8, 0x17, 0x03, 0xA0, 0xB2, 0xC0, 0x07, 0xC2, 0x0B,
  0xA8, 0x13, 0x07, 0xA8, 0x47, 0x01, 0x33, 0x22, 0xC0, 0x07, 0xC2, 0x0C, 0xA8, 0x14, 0x08, 0xA0,
  0x96, 0x02, 0xC0, 0x07, 0xC0, 0xB0, 0x9B, 0x81, 0xD8, 0xEB, 0x85, 0x97, 0x10, 0x48, 0xDC, 0x00,
  0x7F, 0xFB, 0x81, 0x20, 0x9E, 0x00, 0x7F, 0xFB, 0x81, 0x95, 0xEE, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x07, 0x06, 0xFF, 0xFD, 0x81, 0x61, 0xEF, 0xFF, 0xB8, 0x3E, 0x10, 0x3B, 0xFF, 0xF9,
  0x0B, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_high_quality() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 29), Box(0, 0, 35, 35),
      ic_round_36_av_high_quality_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_interpreter_mode 36x36, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_round_36_av_interpreter_mode_data[] PROGMEM = {
  0x72, 0x84, 0x29, 0xDF, 0xD3, 0x38, 0x52, 0x9D, 0xFD, 0x92, 0x77, 0x40, 0x6C, 0x0B, 0x30, 0x6F,
  0x06, 0x77, 0x20, 0x5D, 0x03, 0x20, 0x5F, 0xA0, 0x57, 0x71, 0x0D, 0xC0, 0xD3, 0x0D, 0xFA, 0x0D,
  0x77, 0x04, 0xD0, 0xA2, 0x04, 0xFC, 0x04, 0x76, 0x06, 0xD0, 0x82, 0x06, 0xFC, 0x06, 0x76, 0x06,
  0xD0, 0x82, 0x06, 0xFC, 0x06, 0x76, 0x04, 0xD0, 0xA2, 0x04, 0xFC, 0x04, 0x77, 0x0D, 0xC0, 0xD3,
  0x0D, 0xFA, 0x0D, 0x77, 0x10, 0x5D, 0x03, 0x20, 0x5F, 0xA0, 0x57, 0x72, 0x06, 0xC0, 0xB3, 0x06,
  0xF0, 0x62, 0x81, 0x16, 0x47, 0x68, 0x42, 0x9D, 0xFD, 0x33, 0x85, 0x29, 0xDF, 0xD9, 0x22, 0x01,
  0x0E, 0xA0, 0x87, 0x77, 0x72, 0x06, 0xB0, 0xE7, 0x40, 0x01, 0x78, 0x41, 0x45, 0x67, 0x74, 0x07,
  0xC7, 0x18, 0x24, 0x9D, 0xB5, 0x81, 0x38, 0xDD, 0x0C, 0x40, 0x7C, 0x60, 0x60, 0xDA, 0x0D, 0x40,
  0x60, 0xDF, 0x90, 0x74, 0x07, 0xC4, 0x01, 0x0C, 0xC0, 0x42, 0x01, 0x0C, 0xFB, 0x84, 0x50, 0x15,
  0x07, 0xC1, 0x82, 0x24, 0x0C, 0xC0, 0xD3, 0x0C, 0xFC, 0x84, 0x40, 0x5F, 0x23, 0xB8, 0x3A, 0x0A,
  0xC4, 0xD0, 0xA2, 0x04, 0xFD, 0x89, 0x46, 0x01, 0xF9, 0x04, 0xA8, 0x12, 0xF8, 0x7D, 0x08, 0x20,
  0x7F, 0xD0, 0x92, 0x81, 0x7F, 0x83, 0x83, 0x3D, 0xD1, 0x7D, 0x07, 0x20, 0x7F, 0xE0, 0x12, 0x89,
  0x08, 0xFE, 0xCD, 0xFD, 0x20, 0x7D, 0x07, 0x20, 0x7F, 0xE0, 0x93, 0x83, 0x38, 0xFC, 0x53, 0x07,
  0xD0, 0x72, 0x07, 0xFF, 0x07, 0x49, 0x07, 0x40, 0x7D, 0x07, 0x20, 0x7F, 0xF9, 0x0A, 0x01, 0x20,
  0xC0, 0x54,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_interpreter_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 35, 29), Box(0, 0, 35, 35),
      ic_round_36_av_interpreter_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_library_add_check 36x36, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_round_36_av_library_add_check_data[] PROGMEM = {
  0x70, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x70, 0x8F, 0xFF, 0x90, 0x86, 0x0D, 0xFF, 0xF9, 0x0D, 0x6F,
  0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xFF, 0xB8, 0x18, 0xE8, 0x3F, 0xFA, 0x81, 0xDA, 0xEF, 0x93, 0xFF,
  0x98, 0x2C, 0x10, 0x5F, 0x93, 0xFF, 0x0C, 0x01, 0x20, 0x3F, 0x93, 0xFE, 0x0C, 0x01, 0x20, 0x10,
  0xCF, 0x93, 0xFD, 0x0C, 0x01, 0x20, 0x10, 0xCF, 0xA3, 0xD8, 0x1B, 0x49, 0xB0, 0xC0, 0x12, 0x01,
  0x0C, 0xFB, 0x3D, 0x02, 0x28, 0x28, 0xFD, 0x12, 0x01, 0x0C, 0xFC, 0x3D, 0x05, 0x30, 0x70, 0x12,
  0x01, 0x0C, 0xFD, 0x3D, 0x0E, 0x04, 0x50, 0x10, 0xCF, 0xE3, 0xE0, 0xE0, 0x44, 0x0C, 0xFF, 0x3F,
  0x0E, 0x04, 0x20, 0xCF, 0xF9, 0x3F, 0xA0, 0xA0, 0xDF, 0xFA, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x3F,
  0xFF, 0xE3, 0x0D, 0xFF, 0xF9, 0x0D, 0xB3, 0x08, 0xFF, 0xF9, 0x08, 0xB4, 0x08, 0x0D, 0xFF, 0xC0,
  0xD0, 0x81, 0xB7, 0x77, 0x6B, 0x77, 0x76, 0xB0, 0x77, 0x77, 0x50, 0xDF, 0xFF, 0x90, 0x86, 0x08,
  0xFF, 0xF9, 0x0E, 0x70, 0x80, 0xDF, 0xFE, 0x08, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_library_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_library_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_library_add 36x36, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_round_36_av_library_add_data[] PROGMEM = {
  0x70, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x70, 0x8F, 0xFF, 0x90, 0x86, 0x0D, 0xFF, 0xF9, 0x0D, 0x6F,
  0xFF, 0xB6, 0xFC, 0x00, 0x9F, 0xC6, 0xFB, 0x09, 0x20, 0x9F, 0xB8, 0x18, 0xE8, 0x3F, 0xB0, 0x72,
  0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07,
  0xFE, 0x3D, 0x84, 0x97, 0x77, 0x73, 0x28, 0x43, 0x77, 0x77, 0x9F, 0x93, 0xC0, 0x97, 0x70, 0x9F,
  0x3C, 0x09, 0x77, 0x09, 0xF3, 0xD8, 0x49, 0x77, 0x77, 0x32, 0x84, 0x37, 0x77, 0x79, 0xF9, 0x3F,
  0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0,
  0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x92, 0x09, 0xFE, 0x3F, 0xC0, 0x09, 0xFF, 0x3F, 0xFF, 0xE3, 0x0D,
  0xFF, 0xF9, 0x0D, 0xB3, 0x08, 0xFF, 0xF9, 0x08, 0xB4, 0x08, 0x0D, 0xFF, 0xC0, 0xD0, 0x81, 0xB7,
  0x77, 0x6B, 0x77, 0x76, 0xB0, 0x77, 0x77, 0x50, 0xDF, 0xFF, 0x90, 0x86, 0x08, 0xFF, 0xF9, 0x0E,
  0x70, 0x80, 0xDF, 0xFE, 0x08, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_library_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_library_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_library_books 36x36, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_round_36_av_library_books_data[] PROGMEM = {
  0x70, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x70, 0x8F, 0xFF, 0x90, 0x86, 0x0D, 0xFF, 0xF9, 0x0D, 0x6F,
  0xFF, 0xB6, 0xD0, 0x98, 0x09, 0x07, 0x09, 0xD6, 0xC0, 0x97, 0x70, 0x9C, 0x81, 0x8E, 0x83, 0xC0,
  0x97, 0x70, 0x9F, 0x3D, 0x09, 0x80, 0x90, 0x70, 0x9F, 0x93, 0xFF, 0xFE, 0x3F, 0xFF, 0xE3, 0xD0,
  0x98, 0x09, 0x07, 0x09, 0xF9, 0x3C, 0x09, 0x77, 0x09, 0xF3, 0xC0, 0x97, 0x70, 0x9F, 0x3D, 0x09,
  0x80, 0x90, 0x70, 0x9F, 0x93, 0xFF, 0xFE, 0x3F, 0xFF, 0xE3, 0xD0, 0x98, 0x02, 0x70, 0x9F, 0xF3,
  0xC0, 0x97, 0x10, 0x9F, 0xE3, 0xC0, 0x97, 0x10, 0x9F, 0xE3, 0xD0, 0x98, 0x02, 0x70, 0x9F, 0xF3,
  0xFF, 0xFE, 0x30, 0xDF, 0xFF, 0x90, 0xDB, 0x30, 0x8F, 0xFF, 0x90, 0x8B, 0x40, 0x80, 0xDF, 0xFC,
  0x0D, 0x08, 0x1B, 0x77, 0x76, 0xB7, 0x77, 0x6B, 0x07, 0x77, 0x75, 0x0D, 0xFF, 0xF9, 0x08, 0x60,
  0x8F, 0xFF, 0x90, 0xE7, 0x08, 0x0D, 0xFF, 0xE0, 0x86,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_library_books() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_library_books_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_library_music 36x36, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_round_36_av_library_music_data[] PROGMEM = {
  0x70, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x70, 0x8F, 0xFF, 0x90, 0x86, 0x0D, 0xFF, 0xF9, 0x0D, 0x6F,
  0xFF, 0xB6, 0xFD, 0x84, 0xD8, 0x77, 0x8D, 0xE6, 0xFD, 0x02, 0x40, 0x2E, 0x81, 0x8E, 0x83, 0xFD,
  0x50, 0x2F, 0xA3, 0xFD, 0x18, 0x33, 0x77, 0x8D, 0xFA, 0x3F, 0xD1, 0x07, 0xFE, 0x3F, 0xD1, 0x07,
  0xFE, 0x3F, 0xD1, 0x07, 0xFE, 0x3F, 0xD1, 0x07, 0xFE, 0x3F, 0x85, 0xC3, 0x02, 0x70, 0x7F, 0xE3,
  0xE0, 0xC6, 0x07, 0xFE, 0x3E, 0x03, 0x60, 0x7F, 0xE3, 0xE7, 0x07, 0xFE, 0x3E, 0x01, 0x60, 0xAF,
  0xE3, 0xE0, 0x75, 0x01, 0x0E, 0xFE, 0x3F, 0x04, 0x30, 0x10, 0xBF, 0xF3, 0xF9, 0x82, 0xB8, 0x9E,
  0xFF, 0x93, 0xFF, 0xFE, 0x30, 0xDF, 0xFF, 0x90, 0xDB, 0x30, 0x8F, 0xFF, 0x90, 0x8B, 0x40, 0x80,
  0xDF, 0xFC, 0x0D, 0x08, 0x1B, 0x77, 0x76, 0xB7, 0x77, 0x6B, 0x07, 0x77, 0x75, 0x0D, 0xFF, 0xF9,
  0x08, 0x60, 0x8F, 0xFF, 0x90, 0xE7, 0x08, 0x0D, 0xFF, 0xE0, 0x86,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_library_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_library_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_loop 36x36, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_36_av_loop_data[] PROGMEM = {
  0x73, 0x01, 0x04, 0x77, 0x70, 0x10, 0xD9, 0x77, 0x60, 0x10, 0xDA, 0x77, 0x50, 0x10, 0xDB, 0x77,
  0x40, 0x10, 0xDC, 0x83, 0xED, 0xA6, 0x17, 0x60, 0x9F, 0xB0, 0x90, 0x17, 0x40, 0x20, 0xDF, 0xB0,
  0xE0, 0x47, 0x40, 0x20, 0xDB, 0x18, 0x12, 0x6B, 0xC0, 0x67, 0x40, 0x20, 0xDA, 0x40, 0x30, 0xDB,
  0x04, 0x74, 0x02, 0x0D, 0x95, 0x01, 0x0B, 0xA0, 0xE0, 0x12, 0x02, 0x04, 0x70, 0x10, 0x46, 0x01,
  0x0D, 0xA8, 0x49, 0x01, 0xEF, 0x87, 0x71, 0x03, 0xB0, 0x10, 0x6A, 0x0A, 0x77, 0x20, 0xBA, 0x06,
  0x0A, 0xA0, 0x67, 0x72, 0x06, 0xA0, 0xB0, 0xDA, 0x02, 0x77, 0x20, 0x2A, 0x0D, 0x0E, 0xA7, 0x74,
  0xA0, 0x0E, 0xA7, 0x74, 0xA0, 0xE0, 0xDA, 0x02, 0x77, 0x20, 0x2A, 0x0D, 0x0B, 0xA0, 0x67, 0x72,
  0x06, 0xA0, 0xA0, 0x6A, 0x0B, 0x77, 0x20, 0xAA, 0x06, 0x01, 0xB0, 0x37, 0x71, 0x84, 0x8F, 0xE1,
  0x09, 0xA0, 0xD0, 0x16, 0x04, 0x01, 0x70, 0x40, 0x22, 0x01, 0x0E, 0xA0, 0xB0, 0x15, 0x90, 0xD0,
  0x17, 0x40, 0x4B, 0x0D, 0x03, 0x4A, 0x0D, 0x01, 0x74, 0x06, 0xC8, 0x1B, 0x62, 0x1B, 0x0D, 0x01,
  0x74, 0x04, 0x0E, 0xFB, 0x0D, 0x01, 0x74, 0x01, 0x09, 0xFB, 0x08, 0x76, 0x83, 0x16, 0xAD, 0xEC,
  0x0D, 0x01, 0x77, 0x4B, 0x0D, 0x01, 0x77, 0x5A, 0x0D, 0x01, 0x77, 0x69, 0x0D, 0x01, 0x77, 0x70,
  0x40, 0x17, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_loop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 29, 33), Box(0, 0, 35, 35),
      ic_round_36_av_loop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_lyrics 36x36, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_round_36_av_lyrics_data[] PROGMEM = {
  0x77, 0x76, 0x80, 0x27, 0x77, 0x76, 0xE1, 0x08, 0x0D, 0xFF, 0xB0, 0xB0, 0x35, 0xE0, 0x8F, 0xFE,
  0x0E, 0x01, 0x4B, 0x0F, 0x70, 0xDF, 0xFF, 0x06, 0x4B, 0x3F, 0xFF, 0x90, 0x64, 0xB3, 0xFF, 0xE0,
  0xD0, 0x45, 0xB3, 0xFF, 0xD0, 0xE0, 0x26, 0xB3, 0xE7, 0x30, 0x7A, 0x03, 0x38, 0x27, 0xCE, 0xCB,
  0x3E, 0x73, 0x81, 0x7F, 0xB3, 0x0B, 0xF3, 0xE7, 0x38, 0x17, 0xF4, 0x20, 0x7F, 0x93, 0xFF, 0xC0,
  0x22, 0x0C, 0xF9, 0x3E, 0x80, 0x67, 0x0B, 0x93, 0x0E, 0xF9, 0x3E, 0x73, 0x81, 0x7F, 0x22, 0x0C,
  0xF0, 0xC3, 0xE7, 0x38, 0x17, 0xF4, 0x20, 0x7F, 0x07, 0x3E, 0x80, 0x67, 0x81, 0xBF, 0xB3, 0x0B,
  0xD0, 0xB4, 0xFF, 0xD0, 0x33, 0x83, 0x7C, 0xEC, 0x75, 0xE6, 0xF0, 0xD0, 0x17, 0x5E, 0x6F, 0x90,
  0xD0, 0x37, 0x4E, 0x6F, 0xB0, 0x67, 0x3F, 0xFF, 0x90, 0x77, 0x3F, 0xFF, 0x90, 0x77, 0x3F, 0xFF,
  0x90, 0x77, 0x3F, 0xFF, 0x90, 0x67, 0x3F, 0xFF, 0x0E, 0x01, 0x73, 0xFF, 0xE0, 0xB0, 0x37, 0x4D,
  0x07, 0x77, 0x76, 0xC0, 0x77, 0x77, 0x7B, 0x07, 0x77, 0x77, 0x1A, 0x07, 0x77, 0x77, 0x29, 0x07,
  0x77, 0x77, 0x30, 0x77, 0x77, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_lyrics() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 35, 32), Box(0, 0, 35, 35),
      ic_round_36_av_lyrics_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_mic_none 36x36, 4-bit Alpha,  RLE, 185 bytes.
static const unsigned char ic_round_36_av_mic_none_data[] PROGMEM = {
  0x71, 0x84, 0x2A, 0xDD, 0xA2, 0x77, 0x10, 0x4E, 0x04, 0x77, 0x0E, 0xE0, 0xE7, 0x60, 0x4A, 0x82,
  0xD2, 0x2D, 0xA0, 0x47, 0x50, 0x7A, 0x08, 0x20, 0x8A, 0x07, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x77, 0x50, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A,
  0x07, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x07, 0x20, 0x7A,
  0x07, 0x75, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x70, 0x40,
  0x63, 0x07, 0xA0, 0x82, 0x08, 0xA0, 0x73, 0x82, 0x64, 0x03, 0xA0, 0x72, 0x04, 0xA8, 0x2D, 0x22,
  0xDA, 0x04, 0x20, 0x7A, 0x03, 0x04, 0xA0, 0xC3, 0x0E, 0xE0, 0xE3, 0x0C, 0xA0, 0x41, 0xB0, 0x22,
  0x04, 0xE0, 0x42, 0x02, 0xB2, 0x0A, 0xA0, 0xA3, 0x84, 0x2A, 0xDD, 0xA2, 0x30, 0xAA, 0x0A, 0x20,
  0x3B, 0x07, 0x73, 0x07, 0xB0, 0x33, 0x09, 0xB0, 0x87, 0x10, 0x8B, 0x09, 0x50, 0xBB, 0x81, 0xD7,
  0x22, 0x81, 0x27, 0xDB, 0x0B, 0x70, 0xAF, 0xD0, 0xA7, 0x20, 0x60, 0xEF, 0x90, 0xE0, 0x67, 0x58,
  0x15, 0xAE, 0xA8, 0x1E, 0xA5, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A,
  0x07, 0x77, 0x40, 0x5A, 0x05, 0x77, 0x50, 0x05, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_mic_none() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 31), Box(0, 0, 35, 35),
      ic_round_36_av_mic_none_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_mic_off 36x36, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_round_36_av_mic_off_data[] PROGMEM = {
  0x73, 0x84, 0x2A, 0xED, 0xA2, 0x77, 0x60, 0x4E, 0x04, 0x73, 0x81, 0x7F, 0xB6, 0x0E, 0xE0, 0xE7,
  0x30, 0xCA, 0x0C, 0x40, 0x4F, 0x90, 0x47, 0x20, 0x5B, 0x0C, 0x30, 0x10, 0xCF, 0x07, 0x73, 0x06,
  0xB0, 0xC3, 0x01, 0x0C, 0xE0, 0x77, 0x40, 0x6B, 0x0C, 0x30, 0x10, 0xCD, 0x07, 0x75, 0x06, 0xB0,
  0xC3, 0x01, 0x0C, 0xC0, 0x77, 0x60, 0x6B, 0x0C, 0x30, 0x10, 0xCB, 0x07, 0x77, 0x06, 0xB0, 0xC3,
  0x01, 0x0C, 0xA0, 0x77, 0x71, 0x06, 0xB0, 0xC3, 0x82, 0x1C, 0xF7, 0x77, 0x20, 0x6B, 0x0C, 0x38,
  0x11, 0xC7, 0x77, 0x30, 0x9B, 0x0C, 0x30, 0x10, 0x57, 0x50, 0x50, 0x43, 0x06, 0xC0, 0xC7, 0x04,
  0x05, 0x60, 0x4A, 0x01, 0x20, 0x4D, 0x0C, 0x50, 0x1A, 0x04, 0x50, 0x4A, 0x05, 0x30, 0xDD, 0x0C,
  0x40, 0x5A, 0x04, 0x68, 0x1E, 0xFA, 0x30, 0x30, 0xED, 0x0C, 0x38, 0x11, 0xCE, 0x70, 0x9A, 0x03,
  0x38, 0x22, 0xAE, 0xDB, 0x0C, 0x30, 0x10, 0x67, 0x83, 0x1E, 0xFD, 0x16, 0x06, 0xB0, 0xB7, 0x50,
  0x6A, 0x0D, 0x03, 0x60, 0x6B, 0x0B, 0x75, 0x07, 0xB0, 0xA0, 0x34, 0x04, 0x0D, 0xB0, 0xB7, 0x50,
  0x50, 0xEC, 0x00, 0xDF, 0x0B, 0x75, 0x01, 0x09, 0xF9, 0x09, 0x07, 0xB0, 0xB7, 0x68, 0x11, 0x5B,
  0xA8, 0x1B, 0x51, 0x20, 0x6B, 0x0B, 0x77, 0x07, 0xA0, 0x75, 0x06, 0xB0, 0xB7, 0x60, 0x7A, 0x07,
  0x60, 0x6B, 0x0B, 0x75, 0x07, 0xA0, 0x77, 0x06, 0xB0, 0x17, 0x40, 0x5A, 0x05, 0x71, 0x81, 0x5D,
  0x87, 0x60, 0x05, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_mic_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 31, 31), Box(0, 0, 35, 35),
      ic_round_36_av_mic_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_mic 36x36, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_round_36_av_mic_data[] PROGMEM = {
  0x71, 0x84, 0x2A, 0xDD, 0xA2, 0x77, 0x10, 0x4E, 0x04, 0x77, 0x0E, 0xE0, 0xE7, 0x60, 0x4F, 0x90,
  0x47, 0x50, 0x7F, 0x90, 0x77, 0x50, 0x7F, 0x90, 0x77, 0x50, 0x7F, 0x90, 0x77, 0x50, 0x7F, 0x90,
  0x77, 0x50, 0x7F, 0x90, 0x77, 0x50, 0x7F, 0x90, 0x77, 0x50, 0x7F, 0x90, 0x77, 0x50, 0x7F, 0x90,
  0x77, 0x50, 0x7F, 0x90, 0x77, 0x04, 0x06, 0x30, 0x7F, 0x90, 0x73, 0x82, 0x64, 0x03, 0xA0, 0x72,
  0x04, 0xF9, 0x04, 0x20, 0x7A, 0x03, 0x04, 0xA0, 0xC3, 0x0E, 0xE0, 0xE3, 0x0C, 0xA0, 0x41, 0xB0,
  0x22, 0x04, 0xE0, 0x42, 0x02, 0xB2, 0x0A, 0xA0, 0xA3, 0x84, 0x2A, 0xDD, 0xA2, 0x30, 0xAA, 0x0A,
  0x20, 0x3B, 0x07, 0x73, 0x07, 0xB0, 0x33, 0x09, 0xB0, 0x87, 0x10, 0x8B, 0x09, 0x50, 0xBB, 0x81,
  0xD7, 0x22, 0x81, 0x27, 0xDB, 0x0B, 0x70, 0xAF, 0xD0, 0xA7, 0x20, 0x60, 0xEF, 0x90, 0xE0, 0x67,
  0x58, 0x15, 0xAE, 0xA8, 0x1E, 0xA5, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40,
  0x7A, 0x07, 0x77, 0x40, 0x5A, 0x05, 0x77, 0x50, 0x05, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 31), Box(0, 0, 35, 35),
      ic_round_36_av_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_missed_video_call 36x36, 4-bit Alpha,  RLE, 140 bytes.
static const unsigned char ic_round_36_av_missed_video_call_data[] PROGMEM = {
  0x02, 0x0D, 0xFF, 0xC0, 0xD0, 0x26, 0x07, 0xFF, 0xE0, 0x76, 0x07, 0xFF, 0xE0, 0x76, 0x07, 0xFF,
  0xE0, 0x72, 0x83, 0x4E, 0xE2, 0x7B, 0x80, 0x2D, 0xFC, 0x81, 0x70, 0x4B, 0x00, 0x7A, 0x08, 0x60,
  0xDD, 0x81, 0x92, 0xDA, 0x07, 0x04, 0xC0, 0x07, 0xA0, 0x72, 0x83, 0x37, 0x77, 0xEC, 0x82, 0x90,
  0x1D, 0xA0, 0xBD, 0x00, 0x7A, 0x07, 0x30, 0x9E, 0x82, 0x90, 0x1D, 0xFA, 0x00, 0x7A, 0x84, 0x70,
  0xA2, 0x09, 0xC8, 0x29, 0x01, 0xDF, 0xB0, 0x07, 0xA8, 0x57, 0x0C, 0xD2, 0x09, 0xA8, 0x29, 0x01,
  0xDF, 0xC0, 0x07, 0xA8, 0x92, 0x70, 0xCF, 0xD2, 0x09, 0x90, 0x1D, 0xFD, 0x00, 0x7A, 0x81, 0xB7,
  0xEA, 0x0D, 0x02, 0x20, 0x10, 0xDF, 0x0B, 0xD0, 0x07, 0xF9, 0x82, 0xD4, 0x4D, 0xF9, 0x07, 0x04,
  0xC0, 0x07, 0xFF, 0xE8, 0x17, 0x04, 0xB0, 0x07, 0xFF, 0xE0, 0x72, 0x83, 0x4E, 0xE2, 0x7F, 0xFE,
  0x07, 0x60, 0x7F, 0xFE, 0x07, 0x60, 0x20, 0xDF, 0xFC, 0x0D, 0x02, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_missed_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 31, 26), Box(0, 0, 35, 35),
      ic_round_36_av_missed_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_movie 36x36, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_36_av_movie_data[] PROGMEM = {
  0x18, 0x28, 0xDF, 0xB4, 0x0B, 0xA0, 0x33, 0x03, 0xA0, 0xB4, 0x0B, 0xC0, 0x08, 0xC0, 0x33, 0x03,
  0xA0, 0xB4, 0x0B, 0xA0, 0x33, 0x03, 0xD0, 0xDC, 0x0B, 0x40, 0xBA, 0x03, 0x30, 0x3A, 0x0B, 0x40,
  0xBF, 0xB0, 0x33, 0x03, 0xA0, 0xB4, 0x0B, 0xA0, 0x33, 0x03, 0xFB, 0x0B, 0x40, 0xBA, 0x03, 0x30,
  0x3A, 0x0B, 0x40, 0xBF, 0xB0, 0x63, 0x05, 0xA0, 0xC0, 0x13, 0x0D, 0xA0, 0x63, 0x05, 0x80, 0xF8,
  0x1F, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_movie() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_movie_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_music_video 36x36, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_round_36_av_music_video_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDB, 0x77,
  0x73, 0xE7, 0x58, 0x42, 0x77, 0x77, 0x26, 0xE7, 0x50, 0xDC, 0x0D, 0x6E, 0x75, 0xD0, 0xD6, 0xE7,
  0x59, 0x83, 0xB7, 0x77, 0x26, 0xE7, 0x59, 0x07, 0x73, 0xE7, 0x59, 0x07, 0x73, 0xE7, 0x59, 0x07,
  0x73, 0xE7, 0x59, 0x07, 0x73, 0xE7, 0x85, 0x3B, 0xFD, 0x7F, 0x77, 0x3E, 0x60, 0x3E, 0x07, 0x73,
  0xE6, 0x0B, 0xE0, 0x77, 0x3E, 0x6F, 0x07, 0x73, 0xE6, 0x0D, 0xE0, 0x57, 0x3E, 0x60, 0x8D, 0x0D,
  0x74, 0xE7, 0x0A, 0xB0, 0xE0, 0x37, 0x4E, 0x71, 0x82, 0x37, 0x51, 0x75, 0xE7, 0x77, 0x3B, 0x0D,
  0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_music_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_music_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_new_releases 36x36, 4-bit Alpha,  RLE, 198 bytes.
static const unsigned char ic_round_36_av_new_releases_data[] PROGMEM = {
  0x74, 0x03, 0x70, 0x10, 0x37, 0x77, 0x83, 0xBF, 0xE8, 0x22, 0x83, 0x29, 0xEF, 0xC7, 0x75, 0x06,
  0xD0, 0x0B, 0xD0, 0x67, 0x73, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x20, 0x9F, 0xF0, 0x97, 0x58,
  0x21, 0x58, 0xCF, 0xFA, 0x82, 0xC8, 0x51, 0x70, 0xBF, 0xFF, 0xB0, 0xB5, 0x03, 0xFF, 0xFD, 0x03,
  0x40, 0x2F, 0xD0, 0x09, 0xFD, 0x02, 0x5F, 0xC0, 0x92, 0x09, 0xFC, 0x60, 0xEF, 0xB0, 0x72, 0x07,
  0xFB, 0x0E, 0x60, 0xDF, 0xB0, 0x72, 0x07, 0xFB, 0x0D, 0x50, 0x6F, 0xC0, 0x72, 0x07, 0xFC, 0x06,
  0x30, 0x5F, 0xD0, 0x72, 0x07, 0xFD, 0x82, 0x40, 0x3E, 0xFD, 0x07, 0x20, 0x7F, 0xD8, 0x1E, 0x3D,
  0xFE, 0x07, 0x20, 0x7F, 0xE0, 0x0D, 0xFE, 0x09, 0x20, 0x9F, 0xE8, 0x1D, 0x3E, 0xFE, 0x00, 0x9F,
  0xE8, 0x2E, 0x20, 0x4F, 0xFF, 0xF0, 0x43, 0x06, 0xFF, 0xFD, 0x05, 0x50, 0xDF, 0xB8, 0x2B, 0x77,
  0xBF, 0xB0, 0xD6, 0x0E, 0xFB, 0x07, 0x20, 0x7F, 0xB0, 0xE6, 0xFC, 0x07, 0x20, 0x7F, 0xC5, 0x02,
  0xFC, 0x82, 0xB7, 0x7B, 0xFC, 0x02, 0x40, 0x3F, 0xFF, 0xD0, 0x25, 0x0B, 0xFF, 0xFB, 0x0B, 0x78,
  0x22, 0x59, 0xCF, 0xFA, 0x82, 0xB8, 0x41, 0x75, 0x09, 0xFF, 0x08, 0x77, 0x20, 0x10, 0xEF, 0xD0,
  0xE7, 0x74, 0x06, 0xD0, 0x0B, 0xD0, 0x57, 0x75, 0x83, 0xCF, 0xE9, 0x22, 0x83, 0x28, 0xEF, 0xB7,
  0x77, 0x03, 0x01, 0x70, 0x37, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_new_releases() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 33, 33), Box(0, 0, 35, 35),
      ic_round_36_av_new_releases_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_note 36x36, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_36_av_note_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFB, 0x0D, 0x05, 0x71, 0x08, 0xFF, 0xF0, 0x77, 0x0D, 0xFF, 0xC0, 0xBB, 0x07,
  0x6F, 0xFD, 0x07, 0x04, 0xB0, 0x75, 0xFF, 0xD8, 0x17, 0x04, 0xB0, 0x74, 0xFF, 0xD0, 0x72, 0x04,
  0xB0, 0x73, 0xFF, 0xD0, 0x73, 0x04, 0xB0, 0x72, 0xFF, 0xD0, 0x74, 0x04, 0xB0, 0x71, 0xFF, 0xD0,
  0x75, 0x04, 0xB0, 0x5F, 0xFD, 0x09, 0x60, 0x4A, 0x0D, 0xFF, 0xE0, 0x98, 0x02, 0x70, 0xB8, 0x0C,
  0xD2, 0xF0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28, 0x08, 0xEF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_not_interested 36x36, 4-bit Alpha,  RLE, 249 bytes.
static const unsigned char ic_round_36_av_not_interested_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xC8, 0x2D, 0x84, 0x12, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x20,
  0xAB, 0x0D, 0x05, 0x73, 0x06, 0x0D, 0xB0, 0xA7, 0x08, 0xB0, 0xD0, 0x17, 0x60, 0xAB, 0x08, 0x50,
  0x5D, 0x09, 0x77, 0x08, 0xB0, 0x54, 0x0D, 0xA0, 0xDB, 0x09, 0x77, 0x0A, 0xA0, 0xD3, 0x07, 0xA8,
  0x1D, 0x19, 0xB0, 0x97, 0x70, 0xDA, 0x07, 0x20, 0xEA, 0x05, 0x20, 0x9B, 0x09, 0x76, 0x06, 0xA8,
  0x1E, 0x03, 0xA0, 0xD4, 0x09, 0xB0, 0x97, 0x60, 0xDA, 0x03, 0x08, 0xA0, 0x85, 0x09, 0xB0, 0x97,
  0x50, 0x8A, 0x08, 0x0B, 0xA0, 0x46, 0x09, 0xB0, 0x97, 0x40, 0x4A, 0x0B, 0x0D, 0xA0, 0x17, 0x09,
  0xB0, 0x97, 0x30, 0x2A, 0x0D, 0x0E, 0xA7, 0x20, 0x9B, 0x09, 0x73, 0xA0, 0x0E, 0xA7, 0x30, 0x9B,
  0x09, 0x72, 0xA0, 0xE0, 0xDA, 0x02, 0x73, 0x09, 0xB0, 0x97, 0x01, 0xA0, 0xD0, 0xBA, 0x04, 0x74,
  0x09, 0xB0, 0x96, 0x04, 0xA0, 0xB0, 0x8A, 0x08, 0x75, 0x09, 0xB0, 0x95, 0x08, 0xA0, 0x80, 0x3A,
  0x0D, 0x76, 0x09, 0xB0, 0x94, 0x0D, 0xA8, 0x13, 0x0E, 0xA0, 0x67, 0x60, 0x9B, 0x09, 0x20, 0x5A,
  0x0E, 0x20, 0x7A, 0x0D, 0x77, 0x09, 0xB8, 0x19, 0x1D, 0xA0, 0x73, 0x0D, 0xA0, 0xA7, 0x70, 0x9B,
  0x0D, 0xA0, 0xD4, 0x05, 0xB0, 0x87, 0x70, 0x9D, 0x05, 0x50, 0x8B, 0x0A, 0x76, 0x01, 0x0D, 0xB0,
  0x87, 0x0A, 0xB0, 0xD0, 0x67, 0x30, 0x50, 0xDB, 0x0A, 0x72, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82,
  0x14, 0x8D, 0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77,
  0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_not_interested() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_not_interested_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_pause_circle_filled 36x36, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_round_36_av_pause_circle_filled_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDF, 0xFF, 0xB0, 0xD3, 0x07, 0xFF, 0xFD, 0x07, 0x20,
  0xEF, 0x98, 0x2D, 0x22, 0xDA, 0x82, 0xD2, 0x2D, 0xF9, 0x81, 0xE0, 0x3F, 0xA0, 0x82, 0x08, 0xA0,
  0x82, 0x08, 0xFA, 0x03, 0x08, 0xFA, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xA0, 0x80, 0xBF, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xFA, 0x0B, 0x0D, 0xFA, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xA0,
  0xD0, 0xEF, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xFA, 0x00, 0xEF, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xFA, 0x0E, 0x0D, 0xFA, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xA0, 0xD0, 0xBF, 0xA0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xFA, 0x0B, 0x08, 0xFA, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xA0, 0x80,
  0x3F, 0xA0, 0x82, 0x08, 0xA0, 0x82, 0x08, 0xFA, 0x81, 0x30, 0xEF, 0x98, 0x2D, 0x22, 0xDA, 0x82,
  0xD2, 0x2D, 0xF9, 0x0E, 0x20, 0x7F, 0xFF, 0xD0, 0x73, 0x0D, 0xFF, 0xFB, 0x0D, 0x40, 0x5F, 0xFF,
  0xB0, 0x55, 0x08, 0xFF, 0xF9, 0x08, 0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40,
  0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE,
  0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_pause_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_pause_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_pause_circle_outline 36x36, 4-bit Alpha,  RLE, 272 bytes.
static const unsigned char ic_round_36_av_pause_circle_outline_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x20,
  0xAB, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xB0, 0xA7, 0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x08, 0x50, 0x5B,
  0x08, 0x77, 0x20, 0x8B, 0x05, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xAA, 0x0D, 0x30, 0x7A, 0x0D, 0x77,
  0x60, 0xDA, 0x07, 0x20, 0xEA, 0x06, 0x58, 0x22, 0xDD, 0x22, 0x82, 0x2D, 0xD2, 0x50, 0x6A, 0x81,
  0xE0, 0x3A, 0x0D, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0xDA, 0x03, 0x08, 0xA0, 0x96, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x76, 0x09, 0xA0, 0x80, 0xBA, 0x04, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07,
  0x60, 0x4A, 0x0B, 0x0D, 0xA0, 0x26, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0x02, 0xA0, 0xD0, 0xEA,
  0x70, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x7A, 0x00, 0xEA, 0x70, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x7A,
  0x0E, 0x0D, 0xA0, 0x26, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0x02, 0xA0, 0xD0, 0xBA, 0x04, 0x60,
  0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0x4A, 0x0B, 0x08, 0xA0, 0x96, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x76, 0x09, 0xA0, 0x80, 0x3A, 0x0D, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0xDA, 0x81, 0x30,
  0xEA, 0x06, 0x58, 0x22, 0xDD, 0x22, 0x82, 0x2D, 0xD2, 0x50, 0x6A, 0x0E, 0x20, 0x7A, 0x0D, 0x77,
  0x60, 0xDA, 0x07, 0x30, 0xDA, 0x0A, 0x77, 0x40, 0xAA, 0x0D, 0x40, 0x5B, 0x08, 0x77, 0x20, 0x8B,
  0x05, 0x50, 0x8B, 0x0A, 0x77, 0x0A, 0xB0, 0x87, 0x0A, 0xB0, 0xD0, 0x67, 0x30, 0x60, 0xDB, 0x0A,
  0x72, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0,
  0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_pause_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_pause_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_pause_circle 36x36, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_round_36_av_pause_circle_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDF, 0xFF, 0xB0, 0xD3, 0x07, 0xFF, 0xFD, 0x07, 0x20,
  0xEF, 0x98, 0x2D, 0x22, 0xDA, 0x82, 0xD2, 0x2D, 0xF9, 0x81, 0xE0, 0x3F, 0xA0, 0x82, 0x08, 0xA0,
  0x82, 0x08, 0xFA, 0x03, 0x08, 0xFA, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xA0, 0x80, 0xBF, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xFA, 0x0B, 0x0D, 0xFA, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xA0,
  0xD0, 0xEF, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xFA, 0x00, 0xEF, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xFA, 0x0E, 0x0D, 0xFA, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xA0, 0xD0, 0xBF, 0xA0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xFA, 0x0B, 0x08, 0xFA, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xA0, 0x80,
  0x3F, 0xA0, 0x82, 0x08, 0xA0, 0x82, 0x08, 0xFA, 0x81, 0x30, 0xEF, 0x98, 0x2D, 0x22, 0xDA, 0x82,
  0xD2, 0x2D, 0xF9, 0x0E, 0x20, 0x7F, 0xFF, 0xD0, 0x73, 0x0D, 0xFF, 0xFB, 0x0D, 0x40, 0x5F, 0xFF,
  0xB0, 0x55, 0x08, 0xFF, 0xF9, 0x08, 0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40,
  0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE,
  0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_pause_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_pause_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_pause 36x36, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_36_av_pause_data[] PROGMEM = {
  0x18, 0x21, 0x66, 0x17, 0x18, 0x51, 0x66, 0x10, 0x3E, 0xA0, 0xE0, 0x36, 0x03, 0x0E, 0xA8, 0x1E,
  0x3B, 0xC0, 0xB6, 0x0B, 0xC0, 0xBE, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F,
  0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xE0, 0xBC, 0x0B,
  0x60, 0xBC, 0x81, 0xB3, 0xEA, 0x0E, 0x03, 0x60, 0x30, 0xEA, 0x85, 0xE3, 0x01, 0x66, 0x17, 0x18,
  0x21, 0x66, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_pause() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 7, 26, 28), Box(0, 0, 35, 35),
      ic_round_36_av_pause_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_play_arrow 36x36, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_36_av_play_arrow_data[] PROGMEM = {
  0x10, 0x37, 0x78, 0x2B, 0xFD, 0x47, 0x5C, 0x09, 0x01, 0x73, 0xD0, 0xE0, 0x57, 0x2F, 0x0B, 0x02,
  0x7F, 0x90, 0xE0, 0x76, 0xFB, 0x0C, 0x03, 0x4F, 0xD0, 0x83, 0xFE, 0x0D, 0x04, 0x1F, 0xF9, 0x01,
  0xFF, 0x90, 0x1F, 0xE0, 0xD0, 0x31, 0xFD, 0x08, 0x3F, 0xB0, 0xC0, 0x34, 0xF9, 0x0E, 0x07, 0x6F,
  0x0B, 0x02, 0x7D, 0x0E, 0x05, 0x72, 0xC0, 0x90, 0x17, 0x38, 0x2B, 0xFD, 0x47, 0x60, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_play_arrow() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 8, 27, 27), Box(0, 0, 35, 35),
      ic_round_36_av_play_arrow_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_play_circle_filled 36x36, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_round_36_av_play_circle_filled_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDF, 0xFF, 0xB0, 0xD3, 0x07, 0xFF, 0xFD, 0x07, 0x20,
  0xEF, 0xB8, 0x12, 0x5E, 0xFE, 0x81, 0xE0, 0x3F, 0xC2, 0x02, 0x0C, 0xFE, 0x03, 0x08, 0xFC, 0x40,
  0x9F, 0xD0, 0x80, 0xBF, 0xC5, 0x05, 0x0E, 0xFB, 0x0B, 0x0D, 0xFC, 0x60, 0x20, 0xCF, 0xA0, 0xD0,
  0xEF, 0xC7, 0x10, 0xBF, 0x90, 0x0E, 0xFC, 0x71, 0x0B, 0xF9, 0x0E, 0x0D, 0xFC, 0x60, 0x20, 0xCF,
  0xA0, 0xD0, 0xBF, 0xC5, 0x05, 0x0E, 0xFB, 0x0B, 0x08, 0xFC, 0x40, 0x9F, 0xD0, 0x80, 0x3F, 0xC2,
  0x02, 0x0C, 0xFE, 0x81, 0x30, 0xEF, 0xB8, 0x12, 0x5E, 0xFE, 0x0E, 0x20, 0x7F, 0xFF, 0xD0, 0x73,
  0x0D, 0xFF, 0xFB, 0x0D, 0x40, 0x5F, 0xFF, 0xB0, 0x55, 0x08, 0xFF, 0xF9, 0x08, 0x70, 0xAF, 0xFE,
  0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0,
  0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_play_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_play_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_play_circle_outline 36x36, 4-bit Alpha,  RLE, 240 bytes.
static const unsigned char ic_round_36_av_play_circle_outline_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x20,
  0xAB, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xB0, 0xA7, 0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x08, 0x50, 0x5B,
  0x08, 0x77, 0x20, 0x8B, 0x05, 0x40, 0xDA, 0x0A, 0x77, 0x40, 0xAA, 0x0D, 0x30, 0x7A, 0x0D, 0x77,
  0x60, 0xDA, 0x07, 0x20, 0xEA, 0x06, 0x70, 0xD0, 0x97, 0x40, 0x6A, 0x81, 0xE0, 0x3A, 0x0D, 0x71,
  0xA0, 0xC0, 0x27, 0x30, 0xDA, 0x03, 0x08, 0xA0, 0x97, 0x1B, 0x0E, 0x05, 0x72, 0x09, 0xA0, 0x80,
  0xBA, 0x04, 0x71, 0xD0, 0x97, 0x10, 0x4A, 0x0B, 0x0D, 0xA0, 0x27, 0x1E, 0x0C, 0x02, 0x60, 0x2A,
  0x0D, 0x0E, 0xA7, 0x2F, 0x0E, 0x04, 0x6A, 0x00, 0xEA, 0x72, 0xF0, 0xE0, 0x46, 0xA0, 0xE0, 0xDA,
  0x02, 0x71, 0xE0, 0xC0, 0x26, 0x02, 0xA0, 0xD0, 0xBA, 0x04, 0x71, 0xD0, 0x97, 0x10, 0x4A, 0x0B,
  0x08, 0xA0, 0x97, 0x1B, 0x0E, 0x05, 0x72, 0x09, 0xA0, 0x80, 0x3A, 0x0D, 0x71, 0xA0, 0xC0, 0x27,
  0x30, 0xDA, 0x81, 0x30, 0xEA, 0x06, 0x70, 0xD0, 0x97, 0x40, 0x6A, 0x0E, 0x20, 0x7A, 0x0D, 0x77,
  0x60, 0xDA, 0x07, 0x30, 0xDA, 0x0A, 0x77, 0x40, 0xAA, 0x0D, 0x40, 0x5B, 0x08, 0x77, 0x20, 0x8B,
  0x05, 0x50, 0x8B, 0x0A, 0x77, 0x0A, 0xB0, 0x87, 0x0A, 0xB0, 0xD0, 0x67, 0x30, 0x60, 0xDB, 0x0A,
  0x72, 0x07, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0,
  0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_play_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_play_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_play_circle 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_round_36_av_play_circle_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDF, 0xFF, 0xB0, 0xD3, 0x07, 0xFF, 0xFD, 0x07, 0x20,
  0xEF, 0xA8, 0x1E, 0x8B, 0xFF, 0x81, 0xE0, 0x3F, 0xB0, 0x62, 0x05, 0x0E, 0xFE, 0x03, 0x08, 0xFB,
  0x03, 0x30, 0x10, 0x9F, 0xD0, 0x80, 0xBF, 0xB0, 0x35, 0x04, 0x0D, 0xFB, 0x0B, 0x0D, 0xFB, 0x03,
  0x70, 0x8F, 0xA0, 0xD0, 0xEF, 0xB0, 0x37, 0x10, 0xAF, 0x90, 0x0E, 0xFB, 0x03, 0x71, 0x0A, 0xF9,
  0x0E, 0x0D, 0xFB, 0x03, 0x70, 0x8F, 0xA0, 0xD0, 0xBF, 0xB0, 0x35, 0x04, 0x0D, 0xFB, 0x0B, 0x08,
  0xFB, 0x03, 0x30, 0x10, 0x9F, 0xD0, 0x80, 0x3F, 0xB0, 0x62, 0x05, 0x0E, 0xFE, 0x81, 0x30, 0xEF,
  0xA8, 0x1E, 0x8B, 0xFF, 0x0E, 0x20, 0x7F, 0xFF, 0xD0, 0x73, 0x0D, 0xFF, 0xFB, 0x0D, 0x40, 0x5F,
  0xFF, 0xB0, 0x55, 0x08, 0xFF, 0xF9, 0x08, 0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77,
  0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B,
  0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_play_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_play_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_play_disabled 36x36, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_round_36_av_play_disabled_data[] PROGMEM = {
  0x20, 0x17, 0x77, 0x68, 0x21, 0xDF, 0x77, 0x77, 0x50, 0x3B, 0x07, 0x77, 0x75, 0x0A, 0xB0, 0x77,
  0x77, 0x50, 0xAB, 0x07, 0x40, 0x37, 0x77, 0x0A, 0xB0, 0x73, 0x81, 0x4D, 0x47, 0x76, 0x0A, 0xB0,
  0x73, 0x82, 0x4F, 0x91, 0x77, 0x50, 0xAB, 0x07, 0x38, 0x24, 0xFE, 0x57, 0x75, 0x0A, 0xB0, 0x73,
  0x04, 0xA0, 0xB0, 0x27, 0x74, 0x0A, 0xB0, 0x73, 0x04, 0xA0, 0xE0, 0x77, 0x74, 0x0A, 0xB0, 0x73,
  0x04, 0xB0, 0xC0, 0x37, 0x73, 0x0A, 0xB0, 0x73, 0x04, 0xC0, 0x87, 0x73, 0xC0, 0x73, 0x04, 0xC0,
  0xD0, 0x47, 0x71, 0xD0, 0x73, 0x04, 0xD0, 0x17, 0x7E, 0x07, 0x30, 0x4C, 0x01, 0x77, 0xF0, 0x73,
  0x82, 0x4F, 0xD3, 0x77, 0x1F, 0x90, 0x73, 0x03, 0x77, 0x3F, 0xA0, 0x77, 0x76, 0xFB, 0x07, 0x77,
  0x5F, 0x0D, 0xB0, 0x77, 0x74, 0xD8, 0x2E, 0x50, 0xAB, 0x07, 0x77, 0x3C, 0x09, 0x01, 0x30, 0xAB,
  0x07, 0x77, 0x28, 0x2B, 0xFD, 0x36, 0x0A, 0xB0, 0x77, 0x72, 0x02, 0x72, 0x0A, 0xB0, 0x77, 0x77,
  0x50, 0xAB, 0x07, 0x77, 0x75, 0x0A, 0xB0, 0x77, 0x77, 0x50, 0xAB, 0x07, 0x77, 0x75, 0x0A, 0xB0,
  0x17, 0x77, 0x58, 0x1A, 0xFD, 0x77, 0x77, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_play_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 31, 33), Box(0, 0, 35, 35),
      ic_round_36_av_play_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_playlist_add_check_circle 36x36, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_round_36_av_playlist_add_check_circle_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDD, 0x09, 0x80, 0x37, 0x08, 0x0D, 0xFA, 0x0D, 0x30,
  0x7D, 0x09, 0x72, 0x02, 0xFB, 0x07, 0x20, 0xED, 0x09, 0x72, 0x02, 0xFB, 0x81, 0xE0, 0x3F, 0x09,
  0x80, 0x37, 0x08, 0x0D, 0xFC, 0x03, 0x08, 0xFF, 0xFF, 0x08, 0x0B, 0xE0, 0xD0, 0x27, 0x10, 0x7F,
  0xC0, 0xB0, 0xDE, 0x08, 0x73, 0xFC, 0x0D, 0x0E, 0xE0, 0xD0, 0x27, 0x10, 0x7F, 0xC0, 0x0E, 0xFF,
  0xF0, 0xE0, 0xAD, 0x0E, 0x0D, 0xF8, 0x29, 0x78, 0xDF, 0xA8, 0x2C, 0x10, 0x5C, 0x0D, 0x0B, 0xE0,
  0x93, 0x02, 0xF9, 0x0C, 0x01, 0x20, 0x3C, 0x0B, 0x08, 0xE0, 0x93, 0x02, 0xB0, 0x0E, 0xA0, 0xC0,
  0x12, 0x01, 0x0C, 0xC0, 0x80, 0x3F, 0x82, 0x97, 0x8D, 0xA0, 0xB2, 0x81, 0xBC, 0x12, 0x01, 0x0C,
  0xD8, 0x13, 0x0E, 0xFD, 0x07, 0x30, 0x12, 0x01, 0x0C, 0xD0, 0xE2, 0x07, 0xFD, 0x0E, 0x02, 0x40,
  0x10, 0xCE, 0x07, 0x30, 0xDF, 0xD0, 0xD0, 0x22, 0x01, 0x0C, 0xE0, 0xD4, 0x05, 0xFE, 0x82, 0xD3,
  0x3C, 0xF0, 0x55, 0x08, 0xFF, 0xF9, 0x08, 0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77,
  0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B,
  0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_playlist_add_check_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_playlist_add_check_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_playlist_add_check 36x36, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_round_36_av_playlist_add_check_data[] PROGMEM = {
  0x08, 0xFF, 0xA0, 0x87, 0x60, 0xEF, 0xFA, 0x0E, 0x76, 0x08, 0xFF, 0xA0, 0x88, 0x09, 0xC6, 0x00,
  0x8F, 0xFA, 0x08, 0x76, 0x0E, 0xFF, 0xA0, 0xE7, 0x60, 0x8F, 0xFA, 0x08, 0x74, 0x01, 0x77, 0x77,
  0x82, 0x1C, 0xF6, 0x77, 0x75, 0x01, 0x0D, 0xA0, 0xD7, 0x77, 0x40, 0x10, 0xDB, 0x07, 0x08, 0xFB,
  0x08, 0x38, 0x11, 0x51, 0x60, 0x10, 0xDB, 0x81, 0x70, 0xEF, 0xB0, 0xE3, 0x82, 0xCF, 0xD2, 0x40,
  0x10, 0xDB, 0x08, 0x20, 0x8F, 0xB0, 0x83, 0xB0, 0xD0, 0x22, 0x01, 0x0D, 0xB0, 0x87, 0x74, 0x07,
  0xB8, 0x2D, 0x21, 0xDB, 0x08, 0x77, 0x60, 0x7B, 0x00, 0xDB, 0x08, 0x77, 0x71, 0x07, 0xE0, 0x87,
  0x77, 0x30, 0x7C, 0x08, 0x77, 0x75, 0x07, 0xA0, 0x87, 0x77, 0x70, 0x03, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_playlist_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 9, 33, 29), Box(0, 0, 35, 35),
      ic_round_36_av_playlist_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_playlist_add_circle 36x36, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_round_36_av_playlist_add_circle_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDD, 0x09, 0x80, 0x37, 0x08, 0x0D, 0xFA, 0x0D, 0x30,
  0x7D, 0x09, 0x72, 0x02, 0xFB, 0x07, 0x20, 0xED, 0x09, 0x72, 0x02, 0xFB, 0x81, 0xE0, 0x3F, 0x09,
  0x80, 0x37, 0x08, 0x0D, 0xFC, 0x03, 0x08, 0xFF, 0xFF, 0x08, 0x0B, 0xE0, 0xD0, 0x27, 0x10, 0x7F,
  0xC0, 0xB0, 0xDE, 0x08, 0x73, 0xA0, 0x09, 0xF0, 0xD0, 0xEE, 0x0D, 0x02, 0x71, 0x81, 0x7F, 0x92,
  0x09, 0xE0, 0x0E, 0xFF, 0xC0, 0x72, 0x07, 0xE0, 0xE0, 0xDF, 0x82, 0x97, 0x8D, 0xD8, 0x19, 0x73,
  0x28, 0x13, 0x79, 0xC0, 0xD0, 0xBE, 0x09, 0x30, 0x2C, 0x09, 0x71, 0x09, 0xB0, 0xB0, 0x8E, 0x09,
  0x30, 0x2C, 0x09, 0x71, 0x09, 0xB0, 0x80, 0x3F, 0x82, 0x97, 0x8D, 0xD8, 0x19, 0x73, 0x28, 0x13,
  0x79, 0xC8, 0x13, 0x0E, 0xFF, 0xB0, 0x72, 0x07, 0xD0, 0xE2, 0x07, 0xFF, 0xB0, 0x92, 0x09, 0xD0,
  0x73, 0x0D, 0xFF, 0xB0, 0x09, 0xD0, 0xD4, 0x05, 0xFF, 0xFB, 0x05, 0x50, 0x8F, 0xFF, 0x90, 0x87,
  0x0A, 0xFF, 0xE0, 0xA7, 0x20, 0x7F, 0xFC, 0x07, 0x74, 0x05, 0x0D, 0xFF, 0x0D, 0x05, 0x77, 0x07,
  0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x48, 0x90, 0x38, 0xBD, 0xEE, 0xDB, 0x83, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_playlist_add_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_playlist_add_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_playlist_add 36x36, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_36_av_playlist_add_data[] PROGMEM = {
  0x08, 0xFF, 0xA0, 0x87, 0x50, 0xEF, 0xFA, 0x0E, 0x75, 0x08, 0xFF, 0xA0, 0x88, 0x09, 0xC2, 0x00,
  0x8F, 0xFA, 0x08, 0x38, 0x18, 0xE8, 0x60, 0xEF, 0xFA, 0x0E, 0x3B, 0x60, 0x8F, 0xFA, 0x08, 0x3B,
  0x77, 0x76, 0xB7, 0x77, 0x6B, 0x77, 0x76, 0xB6, 0x08, 0xFB, 0x08, 0x30, 0x8F, 0xE0, 0x80, 0xEF,
  0xB0, 0xE3, 0x0E, 0xFE, 0x0E, 0x08, 0xFB, 0x08, 0x30, 0x8F, 0xE0, 0x87, 0x77, 0xB7, 0x77, 0x6B,
  0x77, 0x76, 0xB7, 0x77, 0x6B, 0x77, 0x76, 0xB7, 0x77, 0x68, 0x18, 0xE8, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_playlist_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 9, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_playlist_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_playlist_play 36x36, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_36_av_playlist_play_data[] PROGMEM = {
  0x08, 0xFF, 0xA0, 0x84, 0x0E, 0xFF, 0xA0, 0xE4, 0x08, 0xFF, 0xA0, 0x88, 0x09, 0x82, 0x00, 0x8F,
  0xFA, 0x08, 0x40, 0xEF, 0xFA, 0x0E, 0x40, 0x8F, 0xFA, 0x08, 0x80, 0x98, 0x20, 0x08, 0xFB, 0x08,
  0x30, 0x40, 0x25, 0x0E, 0xFB, 0x0E, 0x3A, 0x08, 0x40, 0x8F, 0xB0, 0x83, 0xB0, 0xD0, 0x57, 0x73,
  0xD0, 0xB0, 0x27, 0x71, 0xE0, 0xB7, 0x71, 0xD0, 0xA0, 0x17, 0x71, 0xB0, 0xD0, 0x47, 0x73, 0x90,
  0xE0, 0x77, 0x75, 0x04, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_playlist_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 9, 27, 29), Box(0, 0, 35, 35),
      ic_round_36_av_playlist_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_playlist_remove 36x36, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_round_36_av_playlist_remove_data[] PROGMEM = {
  0x02, 0x0D, 0xFF, 0x08, 0x73, 0x06, 0xFF, 0x90, 0xE7, 0x30, 0x20, 0xDF, 0xF0, 0x88, 0x09, 0xA7,
  0x00, 0x20, 0xDF, 0xF0, 0x87, 0x30, 0x6F, 0xF9, 0x0E, 0x73, 0x02, 0x0D, 0xFF, 0x08, 0x80, 0x9A,
  0x70, 0x02, 0x0D, 0xF9, 0x08, 0x60, 0x50, 0x15, 0x82, 0x15, 0x06, 0xFA, 0x0E, 0x58, 0x2A, 0xFE,
  0x23, 0x84, 0x2E, 0xFA, 0x2D, 0xF9, 0x08, 0x50, 0xCA, 0x83, 0xE2, 0x02, 0xEA, 0x0C, 0x77, 0x20,
  0x20, 0xEA, 0x81, 0xE5, 0xEA, 0x0E, 0x02, 0x77, 0x30, 0x20, 0xED, 0x0E, 0x02, 0x77, 0x50, 0x20,
  0xEB, 0x0E, 0x02, 0x77, 0x60, 0x20, 0xEB, 0x0E, 0x02, 0x77, 0x50, 0x20, 0xED, 0x0E, 0x02, 0x77,
  0x30, 0x20, 0xEA, 0x81, 0xE5, 0xEA, 0x0E, 0x02, 0x77, 0x20, 0xCA, 0x83, 0xE3, 0x02, 0xEA, 0x0C,
  0x77, 0x28, 0x2A, 0xFE, 0x33, 0x82, 0x2E, 0xFA, 0x77, 0x30, 0x50, 0x15, 0x01, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_playlist_remove() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 30, 32), Box(0, 0, 35, 35),
      ic_round_36_av_playlist_remove_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_queue_music 36x36, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_round_36_av_queue_music_data[] PROGMEM = {
  0x02, 0x0D, 0xFF, 0x90, 0xD0, 0x23, 0x03, 0x0B, 0xC0, 0x80, 0x6F, 0xFB, 0x06, 0x20, 0x10, 0xED,
  0x81, 0xE2, 0xDF, 0xF9, 0x0D, 0x02, 0x20, 0x6E, 0x08, 0x77, 0x70, 0x7A, 0x07, 0x77, 0x74, 0x07,
  0xA0, 0x77, 0x77, 0x40, 0x7A, 0x07, 0x40, 0x20, 0xDF, 0xF9, 0x0D, 0x02, 0x20, 0x7A, 0x07, 0x40,
  0x6F, 0xFB, 0x06, 0x20, 0x7A, 0x07, 0x40, 0x20, 0xDF, 0xF9, 0x0D, 0x02, 0x20, 0x7A, 0x07, 0x77,
  0x74, 0x07, 0xA0, 0x77, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x74, 0x07, 0xA0, 0x74, 0x02, 0x0D, 0xFA,
  0x0D, 0x02, 0x48, 0x33, 0xBE, 0xED, 0xA0, 0x74, 0x06, 0xFC, 0x06, 0x30, 0x5F, 0x07, 0x40, 0x20,
  0xDF, 0xA0, 0xD0, 0x23, 0x0E, 0xF0, 0x77, 0x75, 0x05, 0xF9, 0x07, 0x77, 0x50, 0x7F, 0x90, 0x77,
  0x75, 0x05, 0xF9, 0x05, 0x77, 0x60, 0xEE, 0x0E, 0x01, 0x77, 0x60, 0x4E, 0x05, 0x77, 0x71, 0x84,
  0x3A, 0xEE, 0xB3, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_queue_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_queue_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_queue_play_next 36x36, 4-bit Alpha,  RLE, 242 bytes.
static const unsigned char ic_round_36_av_queue_play_next_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x20, 0x4F, 0xFF, 0xFC, 0x81, 0x40,
  0x7B, 0x09, 0x80, 0xA4, 0x70, 0x9B, 0x81, 0x70, 0x7A, 0x09, 0x77, 0x75, 0x09, 0xA8, 0x17, 0x07,
  0xA0, 0x77, 0x77, 0x50, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x75, 0x00, 0x57, 0x50, 0x7A, 0x81, 0x70,
  0x7A, 0x07, 0x74, 0x05, 0xA0, 0x57, 0x40, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x77,
  0x40, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x81, 0x70, 0x7A, 0x07,
  0x74, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x70, 0x8F, 0xB0, 0x87, 0x07, 0xA8,
  0x17, 0x07, 0xA0, 0x77, 0x0E, 0xFB, 0x0E, 0x70, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x70, 0x8F, 0xB0,
  0x87, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x07, 0x74, 0x05, 0xA8, 0x15, 0x07, 0xA0,
  0x77, 0x40, 0x7A, 0x07, 0x75, 0x00, 0x52, 0x07, 0xA0, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x20, 0x7A,
  0x07, 0x74, 0x05, 0xA0, 0x57, 0x18, 0x1C, 0xF7, 0x50, 0x7A, 0x07, 0x75, 0x00, 0x57, 0x10, 0x4B,
  0x07, 0x40, 0x7A, 0x07, 0x77, 0x72, 0x0D, 0xB0, 0x73, 0x07, 0xA0, 0x97, 0x77, 0x20, 0x10, 0xDB,
  0x07, 0x20, 0x7B, 0x09, 0x80, 0xA0, 0x70, 0x22, 0x01, 0x0D, 0xB8, 0x17, 0x04, 0xFF, 0xFB, 0x0D,
  0x30, 0x10, 0xDB, 0x81, 0x30, 0x9F, 0xFF, 0xA0, 0xD3, 0x01, 0x0D, 0xB0, 0x32, 0x04, 0x80, 0x47,
  0xFD, 0x81, 0x77, 0x22, 0x01, 0x0D, 0xB0, 0x77, 0x5F, 0xD4, 0x01, 0x0D, 0xB0, 0x77, 0x60, 0xDF,
  0xB0, 0xD4, 0x0D, 0xB0, 0x77, 0x70, 0x28, 0x06, 0x70, 0x23, 0x04, 0xB0, 0x77, 0x77, 0x73, 0x81,
  0xCF, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_queue_play_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 35, 32), Box(0, 0, 35, 35),
      ic_round_36_av_queue_play_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_queue 36x36, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_round_36_av_queue_data[] PROGMEM = {
  0x70, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x70, 0x8F, 0xFF, 0x90, 0x86, 0x0D, 0xFF, 0xF9, 0x0D, 0x6F,
  0xFF, 0xB6, 0xFC, 0x00, 0x9F, 0xC6, 0xFB, 0x09, 0x20, 0x9F, 0xB8, 0x18, 0xE8, 0x3F, 0xB0, 0x72,
  0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07,
  0xFE, 0x3D, 0x84, 0x97, 0x77, 0x73, 0x28, 0x43, 0x77, 0x77, 0x9F, 0x93, 0xC0, 0x97, 0x70, 0x9F,
  0x3C, 0x09, 0x77, 0x09, 0xF3, 0xD8, 0x49, 0x77, 0x77, 0x32, 0x84, 0x37, 0x77, 0x79, 0xF9, 0x3F,
  0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x72, 0x07, 0xFE, 0x3F, 0xB0,
  0x72, 0x07, 0xFE, 0x3F, 0xB0, 0x92, 0x09, 0xFE, 0x3F, 0xC0, 0x09, 0xFF, 0x3F, 0xFF, 0xE3, 0x0D,
  0xFF, 0xF9, 0x0D, 0xB3, 0x08, 0xFF, 0xF9, 0x08, 0xB4, 0x08, 0x0D, 0xFF, 0xC0, 0xD0, 0x81, 0xB7,
  0x77, 0x6B, 0x77, 0x76, 0xB0, 0x77, 0x77, 0x50, 0xDF, 0xFF, 0x90, 0x86, 0x08, 0xFF, 0xF9, 0x0E,
  0x70, 0x80, 0xDF, 0xFE, 0x08, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_radio 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_round_36_av_radio_data[] PROGMEM = {
  0x77, 0x38, 0x32, 0x8E, 0xE2, 0x77, 0x72, 0x05, 0x0B, 0xC0, 0x57, 0x76, 0x81, 0x18, 0xDC, 0x0E,
  0x07, 0x77, 0x50, 0x40, 0xAD, 0x0B, 0x05, 0x77, 0x48, 0x11, 0x7D, 0xC8, 0x1E, 0x82, 0x77, 0x40,
  0x40, 0xAD, 0x0B, 0x05, 0x77, 0x48, 0x11, 0x6D, 0xC8, 0x1E, 0x82, 0x77, 0x50, 0x8F, 0xFF, 0xC8,
  0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xEF, 0xFF, 0xF0, 0xDB, 0x07, 0x77, 0x71, 0x07, 0xE7, 0x77,
  0x3E, 0x77, 0x73, 0xE7, 0x74, 0x81, 0x8E, 0x83, 0xE7, 0x74, 0xB3, 0xE7, 0x74, 0xB3, 0x80, 0x9B,
  0x6F, 0x83, 0x83, 0x03, 0x8F, 0xFF, 0xB0, 0x35, 0x03, 0xFF, 0xF9, 0x08, 0x70, 0x8F, 0xFF, 0x03,
  0x70, 0x3F, 0xFF, 0x72, 0xFF, 0xF0, 0x37, 0x03, 0xFF, 0xF0, 0x87, 0x08, 0xFF, 0xF9, 0x03, 0x50,
  0x3F, 0xFF, 0xB8, 0x38, 0x30, 0x38, 0xFF, 0xE0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28,
  0x08, 0xDF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_radio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_radio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_recent_actors 36x36, 4-bit Alpha,  RLE, 245 bytes.
static const unsigned char ic_round_36_av_recent_actors_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x67, 0x05, 0x40, 0x05, 0x48, 0x25, 0x50, 0x5F, 0xFE, 0x05, 0x20, 0x5A, 0x05,
  0x20, 0x5A, 0x05, 0x07, 0xFF, 0xE0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xFF, 0xE0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xF9, 0x82, 0xEB, 0xBE, 0xF9, 0x07, 0x20, 0x7A, 0x07, 0x20,
  0x7A, 0x00, 0x7F, 0x0B, 0x01, 0x20, 0x10, 0xBF, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x00, 0x7E,
  0x0E, 0x01, 0x40, 0x10, 0xEE, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x00, 0x7E, 0x0B, 0x60, 0xBE,
  0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x00, 0x7E, 0x0B, 0x60, 0xBE, 0x07, 0x20, 0x7A, 0x07, 0x20,
  0x7A, 0x00, 0x7E, 0x0E, 0x01, 0x40, 0x10, 0xEE, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x00, 0x7F,
  0x0B, 0x01, 0x20, 0x10, 0xBF, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x00, 0x7F, 0x98, 0x2E, 0xBB,
  0xEF, 0x90, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xFF, 0xE0, 0x72, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x07, 0xFF, 0xE0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xD8, 0x2E, 0x95, 0x22, 0x82,
  0x25, 0x9E, 0xD0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xC0, 0x87, 0x30, 0x8C, 0x07, 0x20,
  0x7A, 0x07, 0x20, 0x7A, 0x00, 0x7B, 0x08, 0x75, 0x08, 0xB0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x07, 0xB0, 0x47, 0x50, 0x4B, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x00, 0x7B, 0x09, 0x80, 0x90,
  0x70, 0x9B, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x00, 0x7F, 0xFE, 0x07, 0x20, 0x7A, 0x07, 0x20,
  0x7A, 0x07, 0x05, 0xFF, 0xE0, 0x52, 0x05, 0xA0, 0x52, 0x05, 0xA8, 0x15, 0x05, 0x80, 0x96, 0x70,
  0x54, 0x00, 0x54, 0x00, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_recent_actors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 28), Box(0, 0, 35, 35),
      ic_round_36_av_recent_actors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_remove_from_queue 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_round_36_av_remove_from_queue_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x70, 0x8F, 0xB0, 0x87, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x0E,
  0xFB, 0x0E, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x70, 0x8F, 0xB0, 0x87, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7B, 0x09, 0x80, 0xA4, 0x70,
  0x9B, 0x07, 0x04, 0xFF, 0xFF, 0xC8, 0x14, 0x09, 0xFF, 0xFF, 0xA0, 0x93, 0x04, 0x80, 0x47, 0xFD,
  0x80, 0x47, 0x04, 0x76, 0xFD, 0x77, 0x71, 0x0D, 0xFB, 0x0D, 0x77, 0x71, 0x02, 0x80, 0x67, 0x02,
  0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_remove_from_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_av_remove_from_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_repeat_one_on 36x36, 4-bit Alpha,  RLE, 267 bytes.
static const unsigned char ic_round_36_av_repeat_one_on_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xFF, 0xFA, 0x81, 0xA3, 0xDE, 0x00, 0x7F, 0xFF, 0xA8, 0x27, 0x01, 0xDD, 0x00, 0x7F, 0xFF, 0xA0,
  0x72, 0x01, 0x0D, 0xC0, 0x07, 0xE0, 0x98, 0x09, 0x47, 0x03, 0x30, 0x10, 0xDB, 0x00, 0x7D, 0x09,
  0x77, 0x71, 0x01, 0x0E, 0xA0, 0x07, 0xD0, 0x77, 0x77, 0x10, 0x20, 0xEA, 0x00, 0x7D, 0x07, 0x20,
  0x38, 0x09, 0x27, 0x03, 0x30, 0x20, 0xDB, 0x00, 0x7D, 0x07, 0x20, 0x7F, 0xF0, 0x72, 0x02, 0x0D,
  0xC0, 0x07, 0xD0, 0x72, 0x07, 0xFF, 0x82, 0x70, 0x2D, 0xD0, 0x07, 0xD0, 0x72, 0x07, 0xC8, 0x3B,
  0x77, 0x8E, 0xD8, 0x1A, 0x3D, 0xE0, 0x07, 0xD0, 0x72, 0x07, 0xC4, 0x08, 0xFF, 0x00, 0x7D, 0x09,
  0x20, 0x9C, 0x83, 0x83, 0x10, 0x7F, 0xF0, 0x07, 0xE0, 0x09, 0xF8, 0x13, 0x07, 0xFF, 0x00, 0x7F,
  0xF9, 0x81, 0x30, 0x7F, 0xF0, 0x07, 0xFF, 0x98, 0x13, 0x07, 0xFF, 0x00, 0x7F, 0xF9, 0x81, 0x30,
  0x7E, 0x00, 0x9E, 0x00, 0x7F, 0xF9, 0x81, 0x30, 0x7D, 0x09, 0x20, 0x9D, 0x00, 0x7F, 0xF9, 0x81,
  0x40, 0x8D, 0x07, 0x20, 0x7D, 0x00, 0x7E, 0x81, 0xD3, 0xAE, 0x81, 0xD8, 0xED, 0x07, 0x20, 0x7D,
  0x00, 0x7D, 0x82, 0xD2, 0x07, 0xFF, 0x07, 0x20, 0x7D, 0x00, 0x7C, 0x0D, 0x02, 0x20, 0x7F, 0xF0,
  0x72, 0x07, 0xD0, 0x07, 0xB0, 0xD0, 0x23, 0x03, 0x80, 0x92, 0x70, 0x32, 0x07, 0xD0, 0x07, 0xA0,
  0xE0, 0x27, 0x77, 0x10, 0x7D, 0x00, 0x7A, 0x0E, 0x01, 0x77, 0x71, 0x09, 0xD0, 0x07, 0xB0, 0xD0,
  0x13, 0x03, 0x80, 0x94, 0x70, 0x9E, 0x00, 0x7C, 0x0D, 0x01, 0x20, 0x7F, 0xFF, 0xA0, 0x07, 0xD8,
  0x2D, 0x10, 0x7F, 0xFF, 0xA0, 0x07, 0xE8, 0x1D, 0x3A, 0xFF, 0xFA, 0x07, 0x04, 0xFF, 0xFF, 0xC8,
  0x14, 0x09, 0xFF, 0xFF, 0xA0, 0x93, 0x04, 0x80, 0xB0, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_repeat_one_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_round_36_av_repeat_one_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_repeat_one 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_round_36_av_repeat_one_data[] PROGMEM = {
  0x77, 0x68, 0x15, 0xC1, 0x77, 0x72, 0x82, 0x7F, 0xD1, 0x77, 0x71, 0x07, 0xA0, 0xD0, 0x14, 0x05,
  0x80, 0x94, 0x70, 0xBB, 0x0D, 0x01, 0x20, 0x5F, 0xFF, 0x90, 0xD2, 0x07, 0xFF, 0xF9, 0x0D, 0x20,
  0x7A, 0x0B, 0x80, 0x92, 0x70, 0xBB, 0x0D, 0x01, 0x20, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0xD0, 0x13,
  0x07, 0xA0, 0x77, 0x78, 0x27, 0xFD, 0x14, 0x07, 0xA0, 0x76, 0x03, 0x06, 0x68, 0x15, 0xC1, 0x50,
  0x7A, 0x07, 0x40, 0x30, 0xBA, 0x06, 0x76, 0x05, 0xA0, 0x54, 0x0E, 0xB0, 0x77, 0x70, 0x05, 0x58,
  0x34, 0x7D, 0xF7, 0x77, 0x72, 0x81, 0xBF, 0x77, 0x77, 0x28, 0x1B, 0xF7, 0x77, 0x72, 0x81, 0xBF,
  0x76, 0x00, 0x57, 0x71, 0x81, 0xBF, 0x75, 0x05, 0xA0, 0x57, 0x78, 0x1A, 0xF7, 0x50, 0x7A, 0x07,
  0x58, 0x11, 0xC5, 0x60, 0x20, 0x66, 0x07, 0xA0, 0x74, 0x82, 0x1D, 0xF7, 0x77, 0x07, 0xA0, 0x73,
  0x01, 0x0D, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x20, 0x10, 0xDB, 0x0B, 0x80, 0x92, 0x70, 0xBA, 0x07,
  0x20, 0xDF, 0xFF, 0x90, 0x72, 0x0D, 0xFF, 0xF9, 0x05, 0x20, 0x10, 0xDB, 0x0B, 0x80, 0x94, 0x70,
  0x54, 0x01, 0x0D, 0xA0, 0x77, 0x77, 0x18, 0x21, 0xDF, 0x77, 0x77, 0x28, 0x11, 0xC5, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_repeat_one() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 30, 31), Box(0, 0, 35, 35),
      ic_round_36_av_repeat_one_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_repeat_on 36x36, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_round_36_av_repeat_on_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xFF, 0xFA, 0x81, 0xA3, 0xDE, 0x00, 0x7F, 0xFF, 0xA8, 0x27, 0x01, 0xDD, 0x00, 0x7F, 0xFF, 0xA0,
  0x72, 0x01, 0x0D, 0xC0, 0x07, 0xE0, 0x98, 0x09, 0x47, 0x03, 0x30, 0x10, 0xDB, 0x00, 0x7D, 0x09,
  0x77, 0x71, 0x01, 0x0E, 0xA0, 0x07, 0xD0, 0x77, 0x77, 0x10, 0x20, 0xEA, 0x00, 0x7D, 0x07, 0x20,
  0x38, 0x09, 0x27, 0x03, 0x30, 0x20, 0xDB, 0x00, 0x7D, 0x07, 0x20, 0x7F, 0xF0, 0x72, 0x02, 0x0D,
  0xC0, 0x07, 0xD0, 0x72, 0x07, 0xFF, 0x82, 0x70, 0x2D, 0xD0, 0x07, 0xD0, 0x72, 0x07, 0xFF, 0x81,
  0xA3, 0xDE, 0x00, 0x7D, 0x07, 0x20, 0x7F, 0xFF, 0xA0, 0x07, 0xD0, 0x92, 0x09, 0xFF, 0xFA, 0x00,
  0x7E, 0x00, 0x9F, 0xFF, 0xB0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFB,
  0x00, 0x9E, 0x00, 0x7F, 0xFF, 0xA0, 0x92, 0x09, 0xD0, 0x07, 0xFF, 0xFA, 0x07, 0x20, 0x7D, 0x00,
  0x7E, 0x81, 0xD3, 0xAF, 0xF0, 0x72, 0x07, 0xD0, 0x07, 0xD8, 0x2D, 0x20, 0x7F, 0xF0, 0x72, 0x07,
  0xD0, 0x07, 0xC0, 0xD0, 0x22, 0x07, 0xFF, 0x07, 0x20, 0x7D, 0x00, 0x7B, 0x0D, 0x02, 0x30, 0x38,
  0x09, 0x27, 0x03, 0x20, 0x7D, 0x00, 0x7A, 0x0E, 0x02, 0x77, 0x71, 0x07, 0xD0, 0x07, 0xA0, 0xE0,
  0x17, 0x77, 0x10, 0x9D, 0x00, 0x7B, 0x0D, 0x01, 0x30, 0x38, 0x09, 0x47, 0x09, 0xE0, 0x07, 0xC0,
  0xD0, 0x12, 0x07, 0xFF, 0xFA, 0x00, 0x7D, 0x82, 0xD1, 0x07, 0xFF, 0xFA, 0x00, 0x7E, 0x81, 0xD3,
  0xAF, 0xFF, 0xA0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x30, 0x48, 0x0B,
  0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_repeat_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_round_36_av_repeat_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_repeat 36x36, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_36_av_repeat_data[] PROGMEM = {
  0x77, 0x68, 0x15, 0xC1, 0x77, 0x72, 0x82, 0x7F, 0xD1, 0x77, 0x71, 0x07, 0xA0, 0xD0, 0x14, 0x05,
  0x80, 0x94, 0x70, 0xBB, 0x0D, 0x01, 0x20, 0x5F, 0xFF, 0x90, 0xD2, 0x07, 0xFF, 0xF9, 0x0D, 0x20,
  0x7A, 0x0B, 0x80, 0x92, 0x70, 0xBB, 0x0D, 0x01, 0x20, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0xD0, 0x13,
  0x07, 0xA0, 0x77, 0x78, 0x27, 0xFD, 0x14, 0x07, 0xA0, 0x77, 0x78, 0x15, 0xC1, 0x50, 0x7A, 0x07,
  0x77, 0x71, 0x05, 0xA0, 0x57, 0x77, 0x20, 0x05, 0x80, 0x9B, 0x20, 0x00, 0x57, 0x77, 0x20, 0x5A,
  0x05, 0x77, 0x71, 0x07, 0xA0, 0x75, 0x81, 0x1C, 0x57, 0x70, 0x7A, 0x07, 0x48, 0x21, 0xDF, 0x77,
  0x70, 0x7A, 0x07, 0x30, 0x10, 0xDA, 0x07, 0x77, 0x07, 0xA0, 0x72, 0x01, 0x0D, 0xB0, 0xB8, 0x09,
  0x27, 0x0B, 0xA0, 0x72, 0x0D, 0xFF, 0xF9, 0x07, 0x20, 0xDF, 0xFF, 0x90, 0x52, 0x01, 0x0D, 0xB0,
  0xB8, 0x09, 0x47, 0x05, 0x40, 0x10, 0xDA, 0x07, 0x77, 0x71, 0x82, 0x1D, 0xF7, 0x77, 0x72, 0x81,
  0x1C, 0x57, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_repeat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 30, 31), Box(0, 0, 35, 35),
      ic_round_36_av_repeat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_replay_10 36x36, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_round_36_av_replay_10_data[] PROGMEM = {
  0x73, 0x01, 0x04, 0x77, 0x70, 0x10, 0xD9, 0x77, 0x60, 0x10, 0xDA, 0x77, 0x50, 0x10, 0xDB, 0x77,
  0x40, 0x10, 0xDC, 0x77, 0x30, 0x10, 0xDD, 0x81, 0x65, 0x37, 0x70, 0xDF, 0xA8, 0x1D, 0x82, 0x74,
  0x0D, 0xFD, 0x07, 0x73, 0x02, 0x0D, 0xD8, 0x18, 0xAD, 0xC0, 0xC0, 0x17, 0x20, 0x20, 0xDC, 0x30,
  0x30, 0xBB, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xB5, 0x06, 0xB0, 0xA7, 0x30, 0x20, 0xDA, 0x60, 0x5B,
  0x05, 0x73, 0x02, 0x0D, 0x97, 0x09, 0xA0, 0xD7, 0x40, 0x10, 0x47, 0x10, 0xEA, 0x03, 0x77, 0x60,
  0x9A, 0x09, 0x72, 0x02, 0x01, 0x28, 0x13, 0x63, 0x40, 0x4A, 0x0B, 0x78, 0x90, 0x3C, 0xF5, 0x02,
  0xF9, 0xE4, 0x30, 0x1A, 0x82, 0xD1, 0x72, 0x48, 0x90, 0x34, 0xE5, 0x07, 0xB0, 0x9A, 0x4A, 0x82,
  0xEB, 0xFE, 0x68, 0x6E, 0x50, 0x8A, 0x08, 0xB3, 0x02, 0xA0, 0xD0, 0xCA, 0x03, 0x58, 0x6E, 0x50,
  0x8A, 0x08, 0xB3, 0x04, 0xA0, 0xC0, 0x8A, 0x08, 0x58, 0x6E, 0x50, 0x6D, 0x0B, 0x93, 0x08, 0xA0,
  0x90, 0x4A, 0x0E, 0x50, 0xE0, 0x52, 0x82, 0xBF, 0xD2, 0x30, 0xEA, 0x81, 0x40, 0xDA, 0x08, 0x77,
  0x08, 0xA0, 0xD2, 0x05, 0xB0, 0x57, 0x50, 0x5B, 0x06, 0x30, 0xAB, 0x06, 0x73, 0x06, 0xB0, 0xB4,
  0x01, 0x0D, 0xB0, 0xB0, 0x36, 0x03, 0x0B, 0xB0, 0xD0, 0x15, 0x01, 0x0C, 0xC8, 0x4D, 0xA8, 0x8A,
  0xDC, 0x0C, 0x01, 0x71, 0x08, 0xFD, 0x08, 0x74, 0x81, 0x29, 0xEE, 0x81, 0xE9, 0x27, 0x71, 0x84,
  0x35, 0x76, 0x53, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_replay_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 29, 31), Box(0, 0, 35, 35),
      ic_round_36_av_replay_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_replay_30 36x36, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_round_36_av_replay_30_data[] PROGMEM = {
  0x73, 0x01, 0x04, 0x77, 0x70, 0x10, 0xD9, 0x77, 0x60, 0x10, 0xDA, 0x77, 0x50, 0x10, 0xDB, 0x77,
  0x40, 0x10, 0xDC, 0x77, 0x30, 0x10, 0xDD, 0x81, 0x65, 0x37, 0x70, 0xDF, 0xA8, 0x1D, 0x82, 0x74,
  0x0D, 0xFD, 0x07, 0x73, 0x02, 0x0D, 0xD8, 0x18, 0xAD, 0xC0, 0xC0, 0x17, 0x20, 0x20, 0xDC, 0x30,
  0x30, 0xBB, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xB5, 0x06, 0xB0, 0xA7, 0x30, 0x20, 0xDA, 0x60, 0x5B,
  0x05, 0x73, 0x02, 0x0D, 0x97, 0x09, 0xA0, 0xD7, 0x40, 0x10, 0x47, 0x10, 0xEA, 0x03, 0x77, 0x60,
  0x8A, 0x09, 0x71, 0x81, 0x56, 0x12, 0x81, 0x16, 0x44, 0x03, 0xA0, 0xB7, 0x89, 0x0B, 0xCA, 0xE1,
  0x0E, 0xAD, 0x73, 0x01, 0xA8, 0x2E, 0x17, 0x24, 0x89, 0x03, 0x11, 0xF3, 0x4E, 0x06, 0xD4, 0xA8,
  0x2E, 0xBF, 0xE5, 0x87, 0x7D, 0xA0, 0x5D, 0x05, 0xE3, 0x01, 0xA0, 0xD0, 0xCA, 0x04, 0x48, 0x72,
  0x5E, 0x25, 0xD0, 0x5E, 0x30, 0x3A, 0x0C, 0x08, 0xA0, 0x83, 0x89, 0x0B, 0x41, 0xE4, 0x3F, 0x18,
  0xC3, 0x08, 0xA0, 0x90, 0x4A, 0x0E, 0x30, 0x7A, 0x0A, 0x28, 0x29, 0xFE, 0x43, 0x0E, 0xA8, 0x15,
  0x0D, 0xA0, 0x87, 0x70, 0x8A, 0x0D, 0x20, 0x5B, 0x05, 0x75, 0x04, 0xB0, 0x63, 0x0A, 0xB0, 0x67,
  0x30, 0x6B, 0x0B, 0x50, 0xDB, 0x0B, 0x03, 0x60, 0x30, 0xBB, 0x0D, 0x01, 0x50, 0x10, 0xCC, 0x84,
  0xDA, 0x88, 0xAD, 0xC0, 0xC0, 0x17, 0x10, 0x8F, 0xD0, 0x97, 0x48, 0x12, 0x9E, 0xE8, 0x1E, 0x92,
  0x77, 0x18, 0x43, 0x57, 0x65, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_replay_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 29, 31), Box(0, 0, 35, 35),
      ic_round_36_av_replay_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_replay_5 36x36, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_round_36_av_replay_5_data[] PROGMEM = {
  0x73, 0x01, 0x04, 0x77, 0x70, 0x10, 0xD9, 0x77, 0x60, 0x10, 0xDA, 0x77, 0x50, 0x10, 0xDB, 0x77,
  0x40, 0x10, 0xDC, 0x77, 0x30, 0x10, 0xDD, 0x81, 0x65, 0x37, 0x70, 0xDF, 0xA8, 0x1D, 0x82, 0x74,
  0x0D, 0xFD, 0x07, 0x73, 0x02, 0x0D, 0xD8, 0x18, 0xAD, 0xC0, 0xC0, 0x17, 0x20, 0x20, 0xDC, 0x30,
  0x30, 0xBB, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xB5, 0x06, 0xB0, 0xA7, 0x30, 0x20, 0xDA, 0x60, 0x5B,
  0x05, 0x73, 0x02, 0x0D, 0x97, 0x09, 0xA0, 0xD7, 0x40, 0x10, 0x47, 0x10, 0xEA, 0x03, 0x77, 0x60,
  0x8A, 0x09, 0x73, 0x03, 0x0F, 0x56, 0x03, 0xA0, 0xB7, 0x38, 0x2A, 0xC9, 0x96, 0x01, 0xA8, 0x2D,
  0x17, 0x27, 0x81, 0xC6, 0x27, 0x1A, 0x82, 0xEB, 0xFE, 0x78, 0x2D, 0xCD, 0xA6, 0x01, 0xA0, 0xD0,
  0xCA, 0x03, 0x71, 0x81, 0x2F, 0x15, 0x03, 0xA0, 0xC0, 0x8A, 0x08, 0x68, 0x3B, 0x33, 0xF1, 0x50,
  0x9A, 0x09, 0x04, 0xA0, 0xE6, 0x07, 0xA0, 0x76, 0x0E, 0xA8, 0x15, 0x0D, 0xA0, 0x87, 0x70, 0x8A,
  0x0D, 0x20, 0x5B, 0x05, 0x75, 0x04, 0xB0, 0x63, 0x0A, 0xB0, 0x67, 0x30, 0x6B, 0x0C, 0x50, 0xDB,
  0x0B, 0x03, 0x60, 0x40, 0xAB, 0x0D, 0x01, 0x50, 0x10, 0xCC, 0x84, 0xDA, 0x88, 0xAD, 0xC0, 0xD0,
  0x27, 0x10, 0x8F, 0xD0, 0x90, 0x17, 0x38, 0x12, 0x9E, 0xE8, 0x1E, 0xA3, 0x77, 0x18, 0x43, 0x57,
  0x75, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_replay_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 29, 31), Box(0, 0, 35, 35),
      ic_round_36_av_replay_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_replay_circle_filled 36x36, 4-bit Alpha,  RLE, 227 bytes.
static const unsigned char ic_round_36_av_replay_circle_filled_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xF0, 0xB0, 0x7F, 0xA0, 0x77, 0x20, 0xAF, 0x0A, 0x2F, 0xB0,
  0xA7, 0x08, 0xF0, 0xA3, 0xFC, 0x08, 0x50, 0x5F, 0x0A, 0x40, 0xC0, 0xDF, 0xB0, 0x54, 0x0D, 0xE0,
  0xB7, 0x81, 0x27, 0xEF, 0x0D, 0x30, 0x7F, 0x06, 0x72, 0x01, 0x0A, 0xF0, 0x72, 0x0E, 0xF9, 0x04,
  0x40, 0x35, 0x08, 0xE8, 0x1E, 0x03, 0xFB, 0x04, 0x3A, 0x0A, 0x02, 0x30, 0xBE, 0x03, 0x08, 0xFC,
  0x04, 0x2B, 0x0E, 0x03, 0x20, 0x2E, 0x08, 0x0B, 0xFD, 0x04, 0x1C, 0x0E, 0x01, 0x20, 0x9D, 0x0B,
  0x0D, 0xFE, 0x0E, 0xD0, 0x82, 0x05, 0xD0, 0xD0, 0xEF, 0xFD, 0x0C, 0x20, 0x1D, 0x00, 0xEE, 0x0C,
  0x0E, 0xFC, 0x0E, 0x3D, 0x0E, 0x0D, 0xD8, 0x16, 0x02, 0xFC, 0x0E, 0x3D, 0x0D, 0x0B, 0xD0, 0x32,
  0x0B, 0xFB, 0x0A, 0x20, 0x3D, 0x0B, 0x08, 0xD0, 0x72, 0x04, 0xFB, 0x04, 0x20, 0x7D, 0x08, 0x03,
  0xD0, 0xD3, 0x0A, 0xF9, 0x09, 0x30, 0xDD, 0x81, 0x30, 0xED, 0x05, 0x30, 0x9E, 0x08, 0x30, 0x6D,
  0x0E, 0x20, 0x7D, 0x0E, 0x02, 0x38, 0x42, 0x8A, 0xA7, 0x23, 0x02, 0x0E, 0xD0, 0x73, 0x0D, 0xD0,
  0xE0, 0x27, 0x30, 0x30, 0xED, 0x0D, 0x40, 0x5F, 0x07, 0x71, 0x07, 0xF0, 0x55, 0x08, 0xF8, 0x6E,
  0x96, 0x44, 0x69, 0xEF, 0x08, 0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40, 0x50,
  0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED,
  0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_replay_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_replay_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_replay 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_round_36_av_replay_data[] PROGMEM = {
  0x73, 0x01, 0x04, 0x77, 0x70, 0x10, 0xD9, 0x77, 0x60, 0x10, 0xDA, 0x77, 0x50, 0x10, 0xDB, 0x77,
  0x40, 0x10, 0xDC, 0x77, 0x30, 0x10, 0xDD, 0x81, 0x65, 0x37, 0x70, 0xDF, 0xA8, 0x1D, 0x82, 0x74,
  0x0D, 0xFD, 0x07, 0x73, 0x02, 0x0D, 0xD8, 0x18, 0xAD, 0xC0, 0xC0, 0x17, 0x20, 0x20, 0xDC, 0x30,
  0x30, 0xBB, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xB5, 0x06, 0xB0, 0xA7, 0x30, 0x20, 0xDA, 0x60, 0x5B,
  0x05, 0x73, 0x02, 0x0D, 0x97, 0x09, 0xA0, 0xD7, 0x40, 0x10, 0x47, 0x10, 0xEA, 0x03, 0x77, 0x60,
  0x8A, 0x09, 0x77, 0x60, 0x3A, 0x0B, 0x77, 0x60, 0x1A, 0x82, 0xE1, 0x72, 0x77, 0x4A, 0x82, 0xEB,
  0xFE, 0x77, 0x30, 0x1A, 0x0D, 0x0C, 0xA0, 0x47, 0x72, 0x03, 0xA0, 0xC0, 0x8A, 0x08, 0x77, 0x20,
  0x8A, 0x09, 0x04, 0xA0, 0xE7, 0x72, 0x0E, 0xA8, 0x15, 0x0D, 0xA0, 0x87, 0x70, 0x8A, 0x0D, 0x20,
  0x5B, 0x05, 0x75, 0x04, 0xB0, 0x63, 0x0A, 0xB0, 0x67, 0x30, 0x6B, 0x0B, 0x50, 0xDB, 0x0B, 0x03,
  0x60, 0x30, 0xBB, 0x0D, 0x01, 0x50, 0x10, 0xCC, 0x84, 0xDA, 0x88, 0xAD, 0xC0, 0xC0, 0x17, 0x10,
  0x8F, 0xD0, 0x97, 0x48, 0x12, 0x9E, 0xE8, 0x1E, 0x92, 0x77, 0x18, 0x43, 0x57, 0x65, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_replay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 29, 31), Box(0, 0, 35, 35),
      ic_round_36_av_replay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_sd 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_round_36_av_sd_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xF2, 0xF8, 0x5D, 0x87, 0x77, 0x79, 0xB0, 0xB8, 0x01, 0x70, 0x80, 0xDF, 0xD0, 0x26, 0x09, 0xA0,
  0x76, 0x02, 0xFD, 0x28, 0x42, 0x33, 0x10, 0x7A, 0x84, 0x70, 0x13, 0x32, 0x2F, 0xD2, 0x0B, 0xA8,
  0x19, 0x7B, 0xA8, 0x17, 0x03, 0xA0, 0xB2, 0xFD, 0x86, 0x10, 0x23, 0x33, 0x6E, 0xA8, 0x17, 0x03,
  0xA0, 0xB2, 0xFD, 0x86, 0xA4, 0x33, 0x31, 0x08, 0xA8, 0x17, 0x03, 0xA0, 0xB2, 0xFD, 0x81, 0x77,
  0xDA, 0x81, 0x30, 0x7A, 0x81, 0x70, 0x3A, 0x0B, 0x2F, 0xD2, 0x84, 0x23, 0x31, 0x07, 0xA8, 0x47,
  0x01, 0x33, 0x22, 0xFD, 0x02, 0x60, 0x9A, 0x07, 0x60, 0x2F, 0xD8, 0x5D, 0x87, 0x77, 0x79, 0xB0,
  0xB8, 0x01, 0x70, 0x80, 0xD8, 0x09, 0xF2, 0xF0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28,
  0x08, 0xDF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_sd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_sd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_shuffle_on 36x36, 4-bit Alpha,  RLE, 278 bytes.
static const unsigned char ic_round_36_av_shuffle_on_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xC8, 0x1E, 0xAE, 0xFE, 0x05, 0x60, 0xBC, 0x00,
  0x7C, 0x82, 0x30, 0x1D, 0xFD, 0x09, 0x60, 0x9C, 0x00, 0x7C, 0x01, 0x20, 0x10, 0xDF, 0xD0, 0x95,
  0x09, 0xC0, 0x07, 0xC0, 0xB3, 0x01, 0x0D, 0xFC, 0x0B, 0x50, 0x9C, 0x00, 0x7D, 0x0B, 0x30, 0x10,
  0xDF, 0xA0, 0xB6, 0x09, 0xC0, 0x07, 0xE0, 0xB3, 0x01, 0x0D, 0xF0, 0xB3, 0x01, 0x08, 0x20, 0x9C,
  0x00, 0x7F, 0x0B, 0x30, 0x10, 0xDD, 0x0B, 0x38, 0x41, 0xDF, 0x90, 0xAC, 0x00, 0x7F, 0x90, 0xB3,
  0x01, 0x0E, 0xB0, 0xB3, 0x01, 0x0D, 0xB0, 0xED, 0x00, 0x7F, 0xA0, 0xB2, 0x07, 0xB0, 0xB3, 0x01,
  0x0D, 0xFB, 0x00, 0x7F, 0xB0, 0xB0, 0x8B, 0x0B, 0x30, 0x10, 0xDF, 0xC0, 0x07, 0xFF, 0x0B, 0x30,
  0x10, 0xDF, 0xD0, 0x07, 0xFE, 0x0B, 0x30, 0x10, 0xDF, 0xE0, 0x07, 0xFD, 0x0B, 0x30, 0x10, 0xDF,
  0xF0, 0x07, 0xFC, 0x0B, 0x30, 0x10, 0xDF, 0xF9, 0x00, 0x7F, 0xB0, 0xB3, 0x01, 0x0D, 0xB0, 0x50,
  0xDF, 0xC0, 0x07, 0xFA, 0x0B, 0x30, 0x10, 0xDB, 0x82, 0x40, 0x1D, 0xFB, 0x00, 0x7F, 0x90, 0xB3,
  0x01, 0x0D, 0xB0, 0xC3, 0x01, 0x0D, 0xB0, 0xED, 0x00, 0x7F, 0x0B, 0x30, 0x20, 0xDD, 0x0B, 0x38,
  0x41, 0xDF, 0x90, 0xAC, 0x00, 0x7E, 0x0B, 0x30, 0x20, 0xDF, 0x0B, 0x30, 0x10, 0x82, 0x09, 0xC0,
  0x07, 0xD0, 0xB3, 0x02, 0x0D, 0xFA, 0x0B, 0x60, 0x9C, 0x00, 0x7C, 0x0B, 0x30, 0x20, 0xDF, 0xC0,
  0xB5, 0x09, 0xC0, 0x07, 0xC0, 0x12, 0x02, 0x0D, 0xFD, 0x09, 0x50, 0x9C, 0x00, 0x7C, 0x82, 0x20,
  0x2D, 0xFD, 0x09, 0x60, 0x9C, 0x00, 0x7C, 0x81, 0xEA, 0xEF, 0xE0, 0x56, 0x0B, 0xC0, 0x07, 0xFF,
  0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09,
  0x30, 0x48, 0x0B, 0x07, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_shuffle_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_round_36_av_shuffle_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_shuffle 36x36, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_round_36_av_shuffle_data[] PROGMEM = {
  0x10, 0x30, 0x47, 0x60, 0x10, 0xED, 0x0C, 0x03, 0xA0, 0x97, 0x60, 0xBE, 0x04, 0xB0, 0x97, 0x60,
  0xBD, 0x10, 0x9B, 0x09, 0x75, 0x09, 0xD2, 0x09, 0xB0, 0x97, 0x30, 0x9E, 0x30, 0x9B, 0x09, 0x71,
  0x09, 0xB0, 0x90, 0xBA, 0x40, 0x9B, 0x09, 0x60, 0x9B, 0x09, 0x20, 0xB0, 0xE5, 0x09, 0xB0, 0x84,
  0x09, 0xB0, 0x94, 0x01, 0x68, 0x29, 0xFE, 0x33, 0x09, 0xB0, 0x97, 0x60, 0x80, 0x23, 0x09, 0xB0,
  0x97, 0x74, 0x09, 0xB0, 0x97, 0x74, 0x09, 0xB0, 0x97, 0x74, 0x09, 0xB0, 0x97, 0x74, 0x09, 0xB0,
  0x97, 0x74, 0x09, 0xB0, 0x93, 0x03, 0x08, 0x76, 0x09, 0xB0, 0x93, 0x82, 0x3E, 0xF9, 0x74, 0x09,
  0xB0, 0x94, 0x08, 0xB0, 0x94, 0x01, 0x40, 0x9B, 0x09, 0x60, 0x9B, 0x09, 0x20, 0xA0, 0xE3, 0x09,
  0xB0, 0x97, 0x10, 0x9B, 0x09, 0x0A, 0xA2, 0x09, 0xB0, 0x97, 0x30, 0x9E, 0x10, 0x9B, 0x09, 0x75,
  0x09, 0xD0, 0x4B, 0x09, 0x76, 0x0B, 0xD0, 0x3A, 0x09, 0x76, 0x0B, 0xE1, 0x03, 0x04, 0x76, 0x01,
  0x0E, 0xD0, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_shuffle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 29, 29), Box(0, 0, 35, 35),
      ic_round_36_av_shuffle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_skip_next 36x36, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_36_av_skip_next_data[] PROGMEM = {
  0x77, 0x18, 0x48, 0xE8, 0x38, 0x37, 0x5B, 0x0D, 0xA0, 0x87, 0x4F, 0x0C, 0x02, 0x72, 0xF9, 0x0E,
  0x06, 0x71, 0xFB, 0x0A, 0x01, 0x6F, 0xC0, 0xE0, 0x45, 0xFE, 0x09, 0x4F, 0xF0, 0x73, 0xFF, 0x07,
  0x3F, 0xE0, 0x94, 0xFC, 0x0E, 0x04, 0x5F, 0xB0, 0xB0, 0x16, 0xF9, 0x0E, 0x06, 0x71, 0xF0, 0xC0,
  0x27, 0x2B, 0x0D, 0xA0, 0x87, 0x4B, 0x81, 0x38, 0x37, 0x5B, 0x77, 0x18, 0x18, 0xE8,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_skip_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 9, 26, 26), Box(0, 0, 35, 35),
      ic_round_36_av_skip_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_skip_previous 36x36, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_36_av_skip_previous_data[] PROGMEM = {
  0x81, 0x8E, 0x87, 0x71, 0xB7, 0x58, 0x13, 0x83, 0xB7, 0x40, 0x8A, 0x0D, 0xB7, 0x20, 0x20, 0xCF,
  0x71, 0x06, 0x0E, 0xF9, 0x60, 0x10, 0xAF, 0xB5, 0x04, 0x0E, 0xFC, 0x40, 0x9F, 0xE3, 0x07, 0xFF,
  0x30, 0x7F, 0xF4, 0x09, 0xFE, 0x50, 0x40, 0xEF, 0xC6, 0x01, 0x0A, 0xFB, 0x71, 0x06, 0x0E, 0xF9,
  0x72, 0x02, 0x0C, 0xF7, 0x40, 0x8A, 0x0D, 0xB7, 0x58, 0x43, 0x83, 0x8E, 0x87, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_skip_previous() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 9, 26, 26), Box(0, 0, 35, 35),
      ic_round_36_av_skip_previous_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_slow_motion_video 36x36, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_round_36_av_slow_motion_video_data[] PROGMEM = {
  0x73, 0x81, 0x38, 0x84, 0x81, 0x78, 0x37, 0x74, 0x07, 0x0E, 0xB0, 0x62, 0x05, 0xB0, 0xE0, 0x77,
  0x70, 0x30, 0xED, 0x04, 0x20, 0x3D, 0x0E, 0x04, 0x75, 0x09, 0xB8, 0x1D, 0x93, 0x48, 0x13, 0x8D,
  0xC0, 0x87, 0x48, 0x24, 0xFD, 0x67, 0x30, 0x60, 0xDB, 0x09, 0x77, 0x74, 0x01, 0x0A, 0xB0, 0x85,
  0x81, 0x39, 0x47, 0x74, 0x09, 0xB0, 0x44, 0x0D, 0xA7, 0x75, 0x0A, 0xA0, 0xD3, 0x07, 0xA0, 0xD7,
  0x75, 0x01, 0x0D, 0xA0, 0x72, 0x0E, 0xA0, 0x67, 0x0D, 0x09, 0x74, 0x05, 0xA8, 0x1D, 0x03, 0xA0,
  0xD7, 0x1A, 0x0C, 0x02, 0x73, 0x0D, 0xA0, 0x40, 0x8A, 0x08, 0x71, 0xB0, 0xE0, 0x57, 0x20, 0x8A,
  0x00, 0x8A, 0x03, 0x71, 0xD0, 0x97, 0x10, 0x4A, 0x82, 0xB0, 0x64, 0x72, 0xE0, 0xC0, 0x26, 0x02,
  0xA0, 0xD7, 0x5F, 0x0E, 0x04, 0x6A, 0x0E, 0x75, 0xF0, 0xE0, 0x46, 0xA8, 0x2E, 0x06, 0x47, 0x2E,
  0x0C, 0x02, 0x60, 0x2A, 0x0D, 0x08, 0xA0, 0x37, 0x1D, 0x09, 0x71, 0x04, 0xA0, 0xB0, 0x8A, 0x08,
  0x71, 0xB0, 0xE0, 0x57, 0x20, 0x8A, 0x08, 0x04, 0xA0, 0xD7, 0x1A, 0x0C, 0x02, 0x73, 0x0D, 0xA8,
  0x14, 0x0E, 0xA0, 0x57, 0x0D, 0x09, 0x74, 0x05, 0xA0, 0xD2, 0x07, 0xA0, 0xD7, 0x75, 0x01, 0x0D,
  0xA0, 0x73, 0x0E, 0xA7, 0x75, 0x0A, 0xA0, 0xD4, 0x81, 0x39, 0x47, 0x74, 0x09, 0xB0, 0x47, 0x77,
  0x20, 0x10, 0xAB, 0x08, 0x72, 0x82, 0x4E, 0xD6, 0x73, 0x06, 0x0D, 0xB0, 0x97, 0x30, 0x9B, 0x81,
  0xD8, 0x34, 0x81, 0x38, 0xDC, 0x08, 0x74, 0x03, 0x0D, 0xD0, 0x42, 0x03, 0xD0, 0xE0, 0x47, 0x70,
  0x70, 0xEB, 0x06, 0x20, 0x5B, 0x0E, 0x07, 0x77, 0x48, 0x13, 0x87, 0x48, 0x17, 0x83, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_slow_motion_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_slow_motion_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_snooze 36x36, 4-bit Alpha,  RLE, 300 bytes.
static const unsigned char ic_round_36_av_snooze_data[] PROGMEM = {
  0x58, 0x11, 0x96, 0x77, 0x81, 0x69, 0x17, 0x20, 0x30, 0xEA, 0x03, 0x75, 0x03, 0xA0, 0xE0, 0x37,
  0x05, 0xB0, 0xE0, 0x17, 0x50, 0x10, 0xEB, 0x05, 0x50, 0x8B, 0x0E, 0x03, 0x28, 0x90, 0x27, 0xBD,
  0xEE, 0xDB, 0x72, 0x20, 0x30, 0xEB, 0x08, 0x30, 0xAB, 0x83, 0xC1, 0x04, 0xCF, 0xB8, 0x3C, 0x40,
  0x1C, 0xB8, 0x1A, 0x03, 0xB0, 0xA2, 0x0A, 0xFF, 0x0A, 0x20, 0xAB, 0x86, 0x31, 0xDF, 0x80, 0x2D,
  0xB8, 0x2E, 0x95, 0x22, 0x82, 0x25, 0x9E, 0xB8, 0x5D, 0x20, 0x8F, 0xD1, 0x28, 0x21, 0x01, 0xDB,
  0x09, 0x01, 0x71, 0x01, 0x09, 0xB8, 0x2D, 0x10, 0x16, 0x0C, 0xA0, 0xE0, 0x57, 0x50, 0x50, 0xEA,
  0x0C, 0x70, 0x7B, 0x03, 0x77, 0x03, 0xB0, 0x75, 0x01, 0x0E, 0xA0, 0x64, 0x05, 0x80, 0x37, 0x01,
  0x30, 0x6A, 0x0E, 0x01, 0x40, 0x7A, 0x0C, 0x40, 0x5F, 0x90, 0xC4, 0x0C, 0xA0, 0x74, 0x0C, 0xA0,
  0x44, 0x05, 0xF9, 0x0C, 0x40, 0x4A, 0x0C, 0x30, 0x2A, 0x0E, 0x68, 0x35, 0x77, 0x79, 0xA0, 0xE0,
  0x35, 0x0E, 0xA0, 0x22, 0x04, 0xA0, 0xB7, 0x20, 0x10, 0xDA, 0x05, 0x60, 0xBA, 0x04, 0x20, 0x6A,
  0x09, 0x72, 0x0B, 0xA0, 0x77, 0x09, 0xA0, 0x62, 0x07, 0xA0, 0x87, 0x10, 0x9A, 0x09, 0x71, 0x08,
  0xA0, 0x72, 0x06, 0xA0, 0x97, 0x07, 0xA0, 0xB7, 0x20, 0x9A, 0x06, 0x20, 0x4A, 0x0B, 0x60, 0x5A,
  0x0D, 0x01, 0x72, 0x0B, 0xA0, 0x42, 0x02, 0xA0, 0xE5, 0x03, 0x0E, 0xA8, 0x39, 0x77, 0x75, 0x60,
  0xEA, 0x02, 0x30, 0xCA, 0x04, 0x40, 0xCF, 0x90, 0x54, 0x04, 0xA0, 0xC4, 0x07, 0xA0, 0xC4, 0x0C,
  0xF9, 0x05, 0x40, 0xCA, 0x07, 0x40, 0x10, 0xEA, 0x06, 0x30, 0x18, 0x03, 0x70, 0x54, 0x06, 0xA0,
  0xE0, 0x15, 0x07, 0xB0, 0x37, 0x70, 0x3B, 0x07, 0x70, 0xCA, 0x0E, 0x05, 0x75, 0x05, 0x0E, 0xA0,
  0xC7, 0x10, 0x10, 0xDB, 0x09, 0x01, 0x71, 0x01, 0x09, 0xB0, 0xD0, 0x17, 0x20, 0x20, 0xDB, 0x82,
  0xE9, 0x52, 0x28, 0x22, 0x59, 0xEB, 0x0D, 0x02, 0x75, 0x0A, 0xFF, 0x0A, 0x77, 0x10, 0x40, 0xCF,
  0xB0, 0xC0, 0x47, 0x74, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_snooze() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_snooze_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_sort_by_alpha 36x36, 4-bit Alpha,  RLE, 214 bytes.
static const unsigned char ic_round_36_av_sort_by_alpha_data[] PROGMEM = {
  0x77, 0x10, 0x17, 0x77, 0x78, 0x23, 0xEC, 0x17, 0x77, 0x40, 0x30, 0xEA, 0x0C, 0x01, 0x77, 0x72,
  0x03, 0x0E, 0xC0, 0xC0, 0x18, 0x09, 0x90, 0x08, 0x14, 0x83, 0x71, 0x04, 0x80, 0x69, 0x05, 0x60,
  0x3A, 0x0E, 0x01, 0x70, 0xEF, 0xC0, 0x45, 0x0A, 0xB0, 0x67, 0x07, 0x80, 0x4D, 0xB0, 0x34, 0x01,
  0xA8, 0x1E, 0xFC, 0x77, 0x10, 0x9A, 0x0A, 0x50, 0x7A, 0x06, 0xA0, 0x37, 0x60, 0x4A, 0x0D, 0x01,
  0x58, 0x5D, 0xFA, 0x0E, 0xF9, 0x75, 0x01, 0x0E, 0xA0, 0x45, 0x03, 0xA8, 0x34, 0x09, 0xFE, 0x75,
  0x0A, 0xA0, 0x96, 0x81, 0x9F, 0xE2, 0x03, 0xA0, 0x67, 0x30, 0x5A, 0x0D, 0x68, 0x21, 0xEF, 0x83,
  0x81, 0xCF, 0xC7, 0x20, 0x10, 0xEA, 0x03, 0x60, 0x6A, 0x02, 0x30, 0x7A, 0x02, 0x71, 0x0B, 0xA0,
  0x87, 0x81, 0xCF, 0xC4, 0x01, 0xA0, 0x87, 0x07, 0xA0, 0xC7, 0x03, 0xA0, 0xB8, 0x01, 0x78, 0x1D,
  0xFE, 0x60, 0x2B, 0x02, 0x70, 0x9F, 0xC0, 0x55, 0x0C, 0xA0, 0x67, 0x18, 0x1E, 0xFE, 0x80, 0x3D,
  0xA0, 0xB4, 0x08, 0xA0, 0xB7, 0x10, 0x5A, 0x04, 0x70, 0x8A, 0x02, 0x20, 0x3A, 0x0E, 0x01, 0x71,
  0x81, 0xBF, 0xE7, 0x10, 0x3A, 0x07, 0x20, 0xCA, 0x0E, 0x80, 0x4B, 0x82, 0x4E, 0xF8, 0x72, 0x81,
  0xCF, 0xA2, 0x0D, 0xFC, 0x81, 0xA4, 0x77, 0x38, 0x12, 0x82, 0x20, 0x38, 0x07, 0x90, 0x28, 0x09,
  0x84, 0x00, 0x30, 0xEC, 0x0D, 0x01, 0x77, 0x72, 0x03, 0x0E, 0xA0, 0xD0, 0x17, 0x77, 0x48, 0x23,
  0xED, 0x17, 0x77, 0x60, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_sort_by_alpha() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_sort_by_alpha_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_speed 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_round_36_av_speed_data[] PROGMEM = {
  0x73, 0x82, 0x49, 0xCE, 0xA8, 0x2E, 0xC9, 0x47, 0x73, 0x81, 0x17, 0xEF, 0xB0, 0xE0, 0x47, 0x70,
  0x50, 0xEF, 0xE0, 0xB7, 0x60, 0x9C, 0x82, 0xD7, 0x41, 0x28, 0x41, 0x48, 0xDF, 0x67, 0x50, 0xAB,
  0x0D, 0x05, 0x77, 0x10, 0x17, 0x09, 0xB0, 0x97, 0x71, 0x03, 0x0A, 0x70, 0x5B, 0x07, 0x77, 0x18,
  0x18, 0xF3, 0x70, 0xEA, 0x09, 0x77, 0x82, 0x3C, 0xF8, 0x70, 0x7A, 0x0D, 0x77, 0x08, 0xA0, 0xD3,
  0x81, 0x49, 0x32, 0x0E, 0xA0, 0x47, 0x50, 0x30, 0xCB, 0x03, 0x38, 0x3E, 0xFE, 0x04, 0xA0, 0xD7,
  0x50, 0x8C, 0x08, 0x40, 0xDA, 0x04, 0x08, 0xA0, 0x77, 0x30, 0x30, 0xCC, 0x0D, 0x50, 0x8A, 0x08,
  0x0B, 0xA0, 0x37, 0x20, 0x8E, 0x03, 0x50, 0x4A, 0x0B, 0x0E, 0xA0, 0x17, 0x10, 0x8E, 0x08, 0x60,
  0x1A, 0x0D, 0x0E, 0xA7, 0x20, 0xDD, 0x0D, 0x71, 0xA0, 0xDB, 0x01, 0x71, 0x0D, 0xD0, 0x37, 0x1A,
  0x0E, 0x0D, 0xA0, 0x17, 0x10, 0x7C, 0x08, 0x71, 0x01, 0xA0, 0xD0, 0xBA, 0x04, 0x72, 0x82, 0x8E,
  0xE8, 0x72, 0x03, 0xA0, 0xA0, 0x8A, 0x09, 0x77, 0x71, 0x07, 0xA0, 0x70, 0x3A, 0x0E, 0x77, 0x71,
  0x0D, 0xA8, 0x14, 0x0D, 0xA0, 0x67, 0x76, 0x06, 0xA0, 0xD2, 0x07, 0xB0, 0xE8, 0x09, 0x6D, 0x0E,
  0xB0, 0x63, 0x0D, 0xFF, 0xFB, 0x0D, 0x40, 0x20, 0xBF, 0xFF, 0x90, 0xB0, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_speed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_speed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_stop_circle 36x36, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_round_36_av_stop_circle_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFF, 0xFB, 0x05, 0x40, 0xDF, 0xFF, 0xB0, 0xD3, 0x07, 0xFF, 0xFD, 0x07, 0x20,
  0xEF, 0x07, 0x73, 0x07, 0xF8, 0x1E, 0x03, 0xF9, 0x75, 0xF9, 0x03, 0x08, 0xF9, 0x75, 0xF9, 0x08,
  0x0B, 0xF9, 0x75, 0xF9, 0x0B, 0x0D, 0xF9, 0x75, 0xF9, 0x0D, 0x0E, 0xF9, 0x75, 0xF9, 0x00, 0xEF,
  0x97, 0x5F, 0x90, 0xE0, 0xDF, 0x97, 0x5F, 0x90, 0xD0, 0xBF, 0x97, 0x5F, 0x90, 0xB0, 0x8F, 0x97,
  0x5F, 0x90, 0x80, 0x3F, 0x97, 0x5F, 0x98, 0x13, 0x0E, 0xF0, 0x77, 0x30, 0x7F, 0x0E, 0x20, 0x7F,
  0xFF, 0xD0, 0x73, 0x0D, 0xFF, 0xFB, 0x0D, 0x40, 0x5F, 0xFF, 0xB0, 0x55, 0x08, 0xFF, 0xF9, 0x08,
  0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70,
  0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_stop_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_stop_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_stop 36x36, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_round_36_av_stop_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xD8, 0x2D, 0x80, 0x8F, 0xFA, 0x08, 0x0D, 0xFF, 0xA0, 0xD8, 0x0B, 0xA4, 0xF0,
  0xDF, 0xFA, 0x0D, 0x08, 0xFF, 0xA8, 0x28, 0x08, 0xDF, 0xD0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 9, 26, 26), Box(0, 0, 35, 35),
      ic_round_36_av_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_subscriptions 36x36, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_36_av_subscriptions_data[] PROGMEM = {
  0x60, 0x8F, 0xFA, 0x08, 0x75, 0x0E, 0xFF, 0xA0, 0xE7, 0x50, 0x8F, 0xFA, 0x08, 0x80, 0x9B, 0x70,
  0x08, 0xFF, 0xF9, 0x08, 0x60, 0xEF, 0xFF, 0x90, 0xE6, 0x08, 0xFF, 0xF9, 0x08, 0x80, 0x9B, 0x20,
  0x08, 0x0D, 0xFF, 0xFB, 0x82, 0xD8, 0x08, 0xFF, 0xFF, 0x08, 0x0D, 0xFF, 0xFF, 0x0D, 0x80, 0xC6,
  0xF0, 0x50, 0xDF, 0xFF, 0xF2, 0x07, 0x0E, 0xFF, 0xFD, 0x30, 0x10, 0x8F, 0xFF, 0xC5, 0x01, 0x09,
  0xFF, 0xFA, 0x70, 0x30, 0xEF, 0xFF, 0x70, 0x30, 0xEF, 0xFF, 0x50, 0x10, 0x9F, 0xFF, 0xA3, 0x01,
  0x08, 0xFF, 0xFC, 0x20, 0x70, 0xEF, 0xFF, 0xD0, 0x50, 0xD8, 0x0D, 0x2F, 0x0D, 0xFF, 0xFF, 0x0D,
  0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_subscriptions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_subscriptions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_subtitles 36x36, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_36_av_subtitles_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x0C,
  0x95, 0xF0, 0x74, 0x07, 0xB0, 0x77, 0x60, 0x7E, 0x6B, 0x77, 0x1E, 0x07, 0x40, 0x7B, 0x07, 0x76,
  0x07, 0x80, 0x9B, 0x4F, 0x07, 0x76, 0x07, 0xB0, 0x74, 0x07, 0xE7, 0x71, 0xB6, 0xE0, 0x77, 0x60,
  0x7B, 0x07, 0x40, 0x7B, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB,
  0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_subtitles() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_subtitles_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_surround_sound 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_round_36_av_surround_sound_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDF, 0xFF,
  0xFF, 0x81, 0xB4, 0x9F, 0xF8, 0x19, 0x4B, 0xFA, 0x0D, 0x30, 0xEF, 0xD0, 0xE3, 0x0D, 0xF9, 0x05,
  0x20, 0x2C, 0x08, 0x03, 0x20, 0x30, 0x8C, 0x02, 0x20, 0x5F, 0x0D, 0x30, 0xBA, 0x0D, 0x02, 0x60,
  0x20, 0xDA, 0x0B, 0x30, 0xDE, 0x08, 0x20, 0x4B, 0x02, 0x71, 0x02, 0xB0, 0x42, 0x08, 0xE0, 0x42,
  0x09, 0xA0, 0x83, 0x82, 0x8D, 0xD8, 0x30, 0x8A, 0x09, 0x20, 0x4E, 0x01, 0x20, 0xDA, 0x03, 0x20,
  0x8C, 0x08, 0x20, 0x3A, 0x0D, 0x20, 0x1E, 0x30, 0xEA, 0x30, 0xDC, 0x0D, 0x3A, 0x0E, 0x3E, 0x30,
  0xEA, 0x30, 0xDC, 0x0D, 0x3A, 0x0E, 0x3E, 0x01, 0x20, 0xDA, 0x03, 0x20, 0x8C, 0x08, 0x20, 0x3A,
  0x0D, 0x20, 0x1E, 0x04, 0x20, 0x9A, 0x08, 0x38, 0x28, 0xDD, 0x83, 0x08, 0xA0, 0x92, 0x04, 0xE0,
  0x82, 0x04, 0xB0, 0x27, 0x10, 0x2B, 0x04, 0x20, 0x8E, 0x0D, 0x30, 0xBA, 0x0D, 0x02, 0x60, 0x20,
  0xDA, 0x0C, 0x30, 0xDF, 0x05, 0x20, 0x2C, 0x08, 0x03, 0x20, 0x30, 0x8C, 0x02, 0x20, 0x5F, 0x90,
  0xD3, 0x0E, 0xFD, 0x0E, 0x30, 0xDF, 0xA8, 0x1B, 0x49, 0xFF, 0x81, 0x94, 0xBF, 0xFF, 0xFF, 0x0D,
  0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_surround_sound() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_surround_sound_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_video_call 36x36, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_36_av_video_call_data[] PROGMEM = {
  0x02, 0x0D, 0xFF, 0xC0, 0xD0, 0x26, 0x07, 0xFF, 0xE0, 0x76, 0x07, 0xFF, 0xE0, 0x76, 0x07, 0xF9,
  0x82, 0xD2, 0x2D, 0xF9, 0x07, 0x28, 0x34, 0xEE, 0x27, 0xF9, 0x08, 0x20, 0x8F, 0x98, 0x17, 0x04,
  0xB0, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x70, 0x4C, 0x00, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x0B,
  0xD0, 0x07, 0xC8, 0x3D, 0x87, 0x73, 0x28, 0x33, 0x77, 0x8D, 0xFB, 0x00, 0x7C, 0x02, 0x73, 0x02,
  0xFB, 0x00, 0x7C, 0x02, 0x73, 0x02, 0xFB, 0x00, 0x7C, 0x83, 0xD8, 0x77, 0x32, 0x83, 0x37, 0x78,
  0xDF, 0xB0, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0xBD, 0x00, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07,
  0x04, 0xC0, 0x07, 0xF9, 0x08, 0x20, 0x8F, 0x98, 0x17, 0x04, 0xB0, 0x07, 0xF9, 0x82, 0xD2, 0x2D,
  0xF9, 0x07, 0x28, 0x34, 0xEE, 0x27, 0xFF, 0xE0, 0x76, 0x07, 0xFF, 0xE0, 0x76, 0x02, 0x0D, 0xFF,
  0xC0, 0xD0, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 31, 26), Box(0, 0, 35, 35),
      ic_round_36_av_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_videocam_off 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_round_36_av_videocam_off_data[] PROGMEM = {
  0x10, 0x60, 0x77, 0x77, 0x50, 0x4A, 0x0C, 0x77, 0x74, 0x03, 0xB0, 0xC7, 0x77, 0x40, 0x6B, 0x0C,
  0x77, 0x74, 0x06, 0xB0, 0xC7, 0x77, 0x40, 0x6B, 0x0C, 0x77, 0x71, 0x02, 0x0D, 0xD0, 0xC3, 0x01,
  0x0C, 0xF0, 0xD0, 0x27, 0x07, 0xF0, 0xC3, 0x01, 0x0C, 0xF0, 0x77, 0x07, 0xF9, 0x0C, 0x30, 0x10,
  0xCE, 0x07, 0x70, 0x7F, 0xA0, 0xC3, 0x01, 0x0C, 0xD0, 0x72, 0x84, 0x4E, 0xE2, 0x07, 0xFB, 0x0C,
  0x30, 0x10, 0xCC, 0x81, 0x70, 0x4B, 0x81, 0x70, 0x7F, 0xC0, 0xC3, 0x01, 0x0C, 0xB0, 0x70, 0x4C,
  0x81, 0x70, 0x7F, 0xD0, 0xC3, 0x01, 0x0C, 0xA0, 0xBD, 0x81, 0x70, 0x7F, 0xE0, 0xC3, 0x01, 0x0C,
  0xF8, 0x17, 0x07, 0xFF, 0x0C, 0x30, 0x10, 0xCE, 0x81, 0x70, 0x7F, 0xF9, 0x0C, 0x30, 0x10, 0xCD,
  0x81, 0x70, 0x7F, 0xFA, 0x0C, 0x30, 0x10, 0xCC, 0x81, 0x70, 0x7F, 0xFB, 0x0B, 0x30, 0x10, 0xCB,
  0x81, 0x70, 0x7F, 0xFC, 0x0B, 0x30, 0x10, 0xCA, 0x81, 0x60, 0x7F, 0xFD, 0x0B, 0x38, 0x41, 0x9A,
  0x10, 0x7F, 0xFE, 0x0B, 0x70, 0x7F, 0xFF, 0x0B, 0x60, 0x7F, 0xFF, 0x90, 0xB5, 0x02, 0x0D, 0xFF,
  0xC0, 0xDB, 0x0B, 0x77, 0x74, 0x06, 0xB0, 0xB7, 0x77, 0x40, 0x6B, 0x0B, 0x77, 0x74, 0x06, 0xB7,
  0x77, 0x58, 0x15, 0xD7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_videocam_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 31, 30), Box(0, 0, 35, 35),
      ic_round_36_av_videocam_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_videocam 36x36, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_36_av_videocam_data[] PROGMEM = {
  0x02, 0x0D, 0xFF, 0xC0, 0xD0, 0x26, 0x07, 0xFF, 0xE0, 0x76, 0x07, 0xFF, 0xE0, 0x76, 0x07, 0xFF,
  0xE0, 0x72, 0x83, 0x4E, 0xE2, 0x7F, 0xFE, 0x81, 0x70, 0x4B, 0x00, 0x7F, 0xFE, 0x07, 0x04, 0xC0,
  0x07, 0xFF, 0xE0, 0xBD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x00, 0x7F, 0xFE, 0x0B, 0xD0, 0x07, 0xFF, 0xE0, 0x70, 0x4C, 0x00, 0x7F, 0xFE, 0x81,
  0x70, 0x4B, 0x00, 0x7F, 0xFE, 0x07, 0x28, 0x34, 0xEE, 0x27, 0xFF, 0xE0, 0x76, 0x07, 0xFF, 0xE0,
  0x76, 0x02, 0x0D, 0xFF, 0xC0, 0xD0, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_videocam() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 31, 26), Box(0, 0, 35, 35),
      ic_round_36_av_videocam_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_video_file 36x36, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_36_av_video_file_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xC0, 0xD0, 0x57, 0x10, 0x8F, 0xF9, 0x07, 0x70, 0xDF, 0xD0, 0xBB, 0x07, 0x6F,
  0xE0, 0x70, 0x4B, 0x07, 0x5F, 0xE8, 0x17, 0x04, 0xB0, 0x74, 0xFE, 0x07, 0x20, 0x4B, 0x07, 0x3F,
  0xE0, 0x73, 0x04, 0xB0, 0x72, 0xFE, 0x07, 0x40, 0x4B, 0x07, 0x1F, 0xE0, 0x75, 0x04, 0xB0, 0x5F,
  0xE0, 0x96, 0x04, 0xA0, 0xDF, 0xF0, 0x98, 0x02, 0x70, 0xB8, 0x09, 0xC4, 0xF0, 0x77, 0x07, 0xFF,
  0x97, 0x2F, 0xF9, 0x72, 0x81, 0xB3, 0x1F, 0xD7, 0x5F, 0xD7, 0x5F, 0xD7, 0x5F, 0xD7, 0x28, 0x1B,
  0x31, 0xFD, 0x72, 0xFF, 0x90, 0x77, 0x07, 0x80, 0x99, 0x5F, 0x0D, 0xFF, 0xF9, 0x0D, 0x08, 0xFF,
  0xF9, 0x82, 0x80, 0x8D, 0xFF, 0xC0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_video_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_round_36_av_video_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_video_label 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_round_36_av_video_label_data[] PROGMEM = {
  0x20, 0x48, 0x0B, 0x07, 0x04, 0x30, 0x9F, 0xFF, 0xFA, 0x81, 0x90, 0x4F, 0xFF, 0xFC, 0x04, 0x07,
  0xB0, 0x98, 0x0A, 0x47, 0x09, 0xB0, 0x07, 0xA0, 0x97, 0x77, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77,
  0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x07, 0xFF,
  0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF,
  0xFF, 0xC0, 0x70, 0x4F, 0xFF, 0xFC, 0x81, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x30, 0x48, 0x0B, 0x07,
  0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_video_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_round_36_av_video_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_video_library 36x36, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_round_36_av_video_library_data[] PROGMEM = {
  0x70, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x70, 0x8F, 0xFF, 0x90, 0x86, 0x0D, 0xFF, 0xF9, 0x0D, 0x6F,
  0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xA0, 0x9F, 0xF8, 0x18, 0xE8, 0x3F, 0xA1, 0x05, 0x0E, 0xFF, 0x93,
  0xFA, 0x20, 0x20, 0xCF, 0xF3, 0xFA, 0x40, 0x9F, 0xE3, 0xFA, 0x50, 0x50, 0xEF, 0xC3, 0xFA, 0x60,
  0x20, 0xCF, 0xB3, 0xFA, 0x71, 0x0B, 0xFA, 0x3F, 0xA7, 0x10, 0xBF, 0xA3, 0xFA, 0x60, 0x20, 0xCF,
  0xB3, 0xFA, 0x50, 0x50, 0xEF, 0xC3, 0xFA, 0x40, 0x9F, 0xE3, 0xFA, 0x20, 0x20, 0xCF, 0xF3, 0xFA,
  0x10, 0x50, 0xEF, 0xF9, 0x3F, 0xA0, 0x9F, 0xFB, 0x3F, 0xFF, 0xE3, 0xFF, 0xFE, 0x30, 0xDF, 0xFF,
  0x90, 0xDB, 0x30, 0x8F, 0xFF, 0x90, 0x8B, 0x40, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x1B, 0x77, 0x76,
  0xB7, 0x77, 0x6B, 0x07, 0x77, 0x75, 0x0D, 0xFF, 0xF9, 0x08, 0x60, 0x8F, 0xFF, 0x90, 0xE7, 0x08,
  0x0D, 0xFF, 0xE0, 0x86,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_video_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_round_36_av_video_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_video_settings 36x36, 4-bit Alpha,  RLE, 264 bytes.
static const unsigned char ic_round_36_av_video_settings_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0xF0, 0xB0, 0x32, 0x01, 0x0E, 0xFF, 0xFF, 0xA8, 0x2E, 0x10, 0x6F, 0xFF,
  0xFC, 0x81, 0x60, 0x7A, 0x0D, 0x02, 0x77, 0x73, 0x02, 0x0D, 0xA8, 0x17, 0x07, 0xA0, 0x87, 0x77,
  0x50, 0x8A, 0x81, 0x70, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x77, 0x10, 0x60,
  0x57, 0x72, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x77, 0x18, 0x27, 0xFA, 0x17, 0x70, 0x7A, 0x81, 0x70,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0xE0, 0x57, 0x60, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x71, 0x07, 0xC0,
  0xA0, 0x17, 0x40, 0x7A, 0x81, 0x70, 0x7A, 0x07, 0x71, 0x07, 0xD0, 0xE0, 0x57, 0x38, 0x43, 0x77,
  0x30, 0x7A, 0x07, 0x71, 0x07, 0xF0, 0xA0, 0x17, 0x60, 0x7A, 0x07, 0x71, 0x07, 0xF0, 0xA0, 0x17,
  0x60, 0x7A, 0x07, 0x71, 0x07, 0xD0, 0xE0, 0x55, 0x83, 0x27, 0x77, 0x25, 0x07, 0xA0, 0x77, 0x10,
  0x7C, 0x0A, 0x01, 0x60, 0x8B, 0x08, 0x50, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0xE0, 0x55, 0x02, 0x20,
  0xAB, 0x0A, 0x20, 0x22, 0x07, 0xA0, 0x77, 0x18, 0x27, 0xFA, 0x15, 0x82, 0x8F, 0xBB, 0xD8, 0x4A,
  0xBF, 0x80, 0x7A, 0x07, 0x71, 0x06, 0x05, 0x60, 0x2F, 0xE0, 0x20, 0x7A, 0x07, 0x77, 0x20, 0xAD,
  0x81, 0xEC, 0xED, 0x0A, 0x07, 0xA0, 0x87, 0x72, 0x03, 0x0E, 0xB8, 0x3C, 0x10, 0x1C, 0xB8, 0x1E,
  0x37, 0xA0, 0xD0, 0x27, 0x72, 0x02, 0xB0, 0x53, 0x05, 0xB8, 0x12, 0x06, 0xFF, 0xA4, 0x02, 0xB0,
  0x53, 0x05, 0xB8, 0x22, 0x01, 0xEF, 0xF9, 0x30, 0x30, 0xEB, 0x83, 0xC1, 0x01, 0xCB, 0x83, 0xD3,
  0x03, 0xBF, 0xF3, 0x0A, 0xD8, 0x1E, 0xCE, 0xD0, 0xA7, 0x76, 0x02, 0xFE, 0x02, 0x77, 0x78, 0x29,
  0xFB, 0xBD, 0x82, 0xAB, 0xF8, 0x77, 0x72, 0x02, 0x20, 0xBB, 0x0A, 0x20, 0x27, 0x77, 0x60, 0x8B,
  0x07, 0x77, 0x77, 0x28, 0x32, 0x77, 0x72, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_video_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 35, 34), Box(0, 0, 35, 35),
      ic_round_36_av_video_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_volume_down 36x36, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_36_av_volume_down_data[] PROGMEM = {
  0x74, 0x81, 0x6C, 0x67, 0x73, 0x07, 0xA0, 0xE7, 0x72, 0x07, 0xC7, 0x71, 0x07, 0xD7, 0x70, 0x7E,
  0x30, 0xA0, 0x13, 0x84, 0x57, 0x77, 0x79, 0xF3, 0x98, 0x2D, 0x10, 0x5F, 0xE3, 0xA8, 0x1B, 0x07,
  0xFE, 0x3B, 0x03, 0x07, 0xFE, 0x3B, 0x08, 0x07, 0xFE, 0x3B, 0x0A, 0x07, 0xFE, 0x3B, 0x0A, 0x07,
  0xFE, 0x3B, 0x08, 0x07, 0xFE, 0x3B, 0x03, 0x05, 0xFE, 0x3A, 0x0B, 0x28, 0x45, 0x77, 0x77, 0x9F,
  0x39, 0x0D, 0x01, 0x71, 0x07, 0xE3, 0x0A, 0x01, 0x73, 0x07, 0xD7, 0x72, 0x07, 0xC7, 0x73, 0x07,
  0xA0, 0xE7, 0x74, 0x81, 0x6C, 0x67,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_volume_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 8, 27, 27), Box(0, 0, 35, 35),
      ic_round_36_av_volume_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_volume_mute 36x36, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_36_av_volume_mute_data[] PROGMEM = {
  0x74, 0x81, 0x6C, 0x67, 0x30, 0x7A, 0x0E, 0x72, 0x07, 0xC7, 0x10, 0x7D, 0x70, 0x7E, 0x18, 0x45,
  0x77, 0x77, 0x9F, 0x05, 0xFE, 0x07, 0xFE, 0x07, 0xFE, 0x07, 0xFE, 0x07, 0xFE, 0x07, 0xFE, 0x07,
  0xFE, 0x05, 0xFE, 0x18, 0x45, 0x77, 0x77, 0x9F, 0x70, 0x7E, 0x71, 0x07, 0xD7, 0x20, 0x7C, 0x73,
  0x07, 0xA0, 0xE7, 0x48, 0x16, 0xC6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_volume_mute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 8, 23, 27), Box(0, 0, 35, 35),
      ic_round_36_av_volume_mute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_volume_off 36x36, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_round_36_av_volume_off_data[] PROGMEM = {
  0x18, 0x17, 0xE8, 0x76, 0x81, 0x49, 0x47, 0x20, 0xEA, 0x09, 0x75, 0x0E, 0xA0, 0xC0, 0x37, 0x08,
  0xB0, 0x97, 0x40, 0xCC, 0x06, 0x70, 0x9B, 0x09, 0x48, 0x16, 0xC6, 0x38, 0x11, 0x8E, 0xB0, 0x87,
  0x09, 0xB0, 0x93, 0x81, 0x3E, 0xE5, 0x01, 0x0B, 0xB0, 0x67, 0x09, 0xB0, 0x93, 0x03, 0x0E, 0x70,
  0xAB, 0x03, 0x70, 0x9B, 0x09, 0x30, 0x37, 0x10, 0xBA, 0x0C, 0x71, 0x09, 0xB0, 0x96, 0x0A, 0x01,
  0x30, 0x10, 0xEA, 0x04, 0x28, 0x45, 0x77, 0x77, 0x9C, 0x09, 0x59, 0x0D, 0x01, 0x30, 0x8A, 0x81,
  0xA0, 0x5F, 0xC0, 0x94, 0x81, 0xEF, 0xB3, 0x01, 0xB1, 0x07, 0xFD, 0x09, 0x38, 0x23, 0xEF, 0x33,
  0x0C, 0xA0, 0x30, 0x7F, 0xE0, 0x93, 0x81, 0x3E, 0x83, 0x09, 0xA0, 0x50, 0x7F, 0xF0, 0x93, 0x03,
  0x09, 0x30, 0x8A, 0x00, 0x7F, 0xF9, 0x09, 0x30, 0x13, 0x08, 0xA0, 0x07, 0xFF, 0xA0, 0x96, 0x09,
  0xA0, 0x60, 0x7F, 0xE0, 0x9B, 0x09, 0x50, 0xDA, 0x03, 0x05, 0xFE, 0x10, 0x9B, 0x09, 0x40, 0xEA,
  0x28, 0x45, 0x77, 0x77, 0x9F, 0x20, 0x9B, 0x09, 0x38, 0x13, 0xEA, 0x71, 0x07, 0xE3, 0x09, 0xB0,
  0x93, 0x03, 0x04, 0x72, 0x07, 0xD4, 0x09, 0xB0, 0x97, 0x70, 0x7C, 0x50, 0x9B, 0x09, 0x77, 0x07,
  0xA0, 0xE5, 0x02, 0x0E, 0xB0, 0x97, 0x78, 0x16, 0xC6, 0x38, 0x11, 0x8E, 0xD0, 0x97, 0x75, 0x0C,
  0xC0, 0xBB, 0x08, 0x77, 0x40, 0xDA, 0x82, 0xC2, 0x09, 0xA0, 0xE7, 0x74, 0x81, 0x38, 0x44, 0x81,
  0x8E, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_volume_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 31, 30), Box(0, 0, 35, 35),
      ic_round_36_av_volume_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_volume_up 36x36, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_round_36_av_volume_up_data[] PROGMEM = {
  0x77, 0x38, 0x14, 0x94, 0x77, 0x74, 0x0E, 0xA0, 0xC0, 0x27, 0x77, 0x20, 0xCC, 0x06, 0x77, 0x28,
  0x16, 0xC6, 0x38, 0x11, 0x8E, 0xB0, 0x87, 0x70, 0x7A, 0x0E, 0x50, 0x10, 0xBB, 0x06, 0x75, 0x07,
  0xC7, 0x0A, 0xB0, 0x37, 0x30, 0x7D, 0x71, 0x0B, 0xA0, 0xC7, 0x20, 0x7E, 0x30, 0xA0, 0x13, 0x01,
  0x0E, 0xA0, 0x42, 0x84, 0x57, 0x77, 0x79, 0xF3, 0x90, 0xD0, 0x13, 0x08, 0xA8, 0x1A, 0x05, 0xFE,
  0x3A, 0x0B, 0x30, 0x1B, 0x10, 0x7F, 0xE3, 0xB0, 0x33, 0x0C, 0xA0, 0x30, 0x7F, 0xE3, 0xB0, 0x83,
  0x09, 0xA0, 0x50, 0x7F, 0xE3, 0xB0, 0xA3, 0x08, 0xA0, 0x07, 0xFE, 0x3B, 0x0A, 0x30, 0x8A, 0x00,
  0x7F, 0xE3, 0xB0, 0x83, 0x09, 0xA0, 0x50, 0x7F, 0xE3, 0xB0, 0x33, 0x0C, 0xA0, 0x30, 0x5F, 0xE3,
  0xA0, 0xB3, 0x01, 0xB2, 0x84, 0x57, 0x77, 0x79, 0xF3, 0x90, 0xD0, 0x13, 0x08, 0xA0, 0xA7, 0x10,
  0x7E, 0x30, 0xA0, 0x13, 0x01, 0x0E, 0xA0, 0x47, 0x20, 0x7D, 0x71, 0x0B, 0xA0, 0xC7, 0x40, 0x7C,
  0x70, 0xAB, 0x03, 0x75, 0x07, 0xA0, 0xE5, 0x01, 0x0B, 0xB0, 0x67, 0x78, 0x16, 0xC6, 0x38, 0x11,
  0x8E, 0xB0, 0x87, 0x77, 0x0C, 0xC0, 0x67, 0x77, 0x10, 0xEA, 0x0C, 0x02, 0x77, 0x72, 0x81, 0x49,
  0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_volume_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 31, 30), Box(0, 0, 35, 35),
      ic_round_36_av_volume_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_web_asset_off 36x36, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_round_36_av_web_asset_off_data[] PROGMEM = {
  0x10, 0x10, 0x27, 0x77, 0x71, 0x82, 0x1E, 0xF7, 0x77, 0x77, 0x04, 0xB0, 0x77, 0x77, 0x70, 0xBB,
  0x07, 0x30, 0x4F, 0xFD, 0x0D, 0x08, 0x30, 0xCB, 0x07, 0x30, 0x4F, 0xFE, 0x08, 0x20, 0xEC, 0x07,
  0x30, 0x4F, 0xFD, 0x0D, 0x2E, 0x07, 0x30, 0x4F, 0xFD, 0x2F, 0x07, 0x30, 0x4F, 0xFC, 0x2F, 0x90,
  0x73, 0x04, 0xFF, 0xB2, 0xB2, 0x0B, 0xB0, 0x77, 0x73, 0xB2, 0xB3, 0x0B, 0xB0, 0x77, 0x72, 0xB2,
  0xB4, 0x0B, 0xB0, 0x77, 0x71, 0xB2, 0xB5, 0x0B, 0xB0, 0x77, 0x7B, 0x2B, 0x60, 0xBB, 0x07, 0x76,
  0xB2, 0xB7, 0x0B, 0xB0, 0x77, 0x5B, 0x2B, 0x71, 0x0B, 0xB0, 0x77, 0x4B, 0x2B, 0x72, 0x0B, 0xB0,
  0x77, 0x3B, 0x2B, 0x73, 0x0B, 0xB0, 0x77, 0x2B, 0x2B, 0x74, 0x0B, 0xB0, 0x77, 0x1B, 0x2B, 0x75,
  0x0B, 0xB0, 0x77, 0xB2, 0xB7, 0x60, 0xBB, 0x07, 0x6B, 0x2B, 0x77, 0x0B, 0xB0, 0x75, 0xB2, 0xB7,
  0x71, 0x0B, 0xB0, 0x74, 0xB2, 0xB7, 0x72, 0x0B, 0xB0, 0x73, 0x04, 0xA2, 0x0D, 0xFF, 0xFA, 0x07,
  0x30, 0x40, 0xD2, 0x08, 0xFF, 0xFB, 0x07, 0x30, 0x13, 0x08, 0x0D, 0xFF, 0xFA, 0x07, 0x77, 0x77,
  0x0B, 0xB0, 0x77, 0x77, 0x70, 0xBB, 0x07, 0x77, 0x77, 0x0B, 0xB0, 0x17, 0x77, 0x78, 0x2B, 0xFE,
  0x17, 0x77, 0x71, 0x04, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_web_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 32, 34), Box(0, 0, 35, 35),
      ic_round_36_av_web_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_web_asset 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_round_36_av_web_asset_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0x98, 0x3B, 0x30, 0x1E, 0xFF, 0xFB, 0x81, 0xE1, 0x6F, 0xFF, 0xD0, 0x60,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0,
  0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76,
  0x07, 0xA0, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x87, 0x76, 0x08, 0xA0, 0x07, 0xA0,
  0xD0, 0x27, 0x74, 0x02, 0x0D, 0xA0, 0x70, 0x6F, 0xFF, 0xD8, 0x16, 0x1E, 0xFF, 0xFB, 0x83, 0xE1,
  0x03, 0xBF, 0xFF, 0x90, 0xB0, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_web_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 29), Box(0, 0, 35, 35),
      ic_round_36_av_web_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_36_av_web 36x36, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_36_av_web_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09,
  0xE7, 0xF8, 0x09, 0x37, 0x09, 0xA0, 0xD8, 0x01, 0x7E, 0x77, 0x10, 0x3A, 0x0B, 0x5E, 0x77, 0x10,
  0x3A, 0x0B, 0x5E, 0x77, 0x10, 0x3A, 0x0B, 0x5E, 0x77, 0x10, 0x3A, 0x0B, 0x5E, 0x80, 0x93, 0x30,
  0x6A, 0x0B, 0x5F, 0xFF, 0xB0, 0xB5, 0xFF, 0xFB, 0x0B, 0x5E, 0x80, 0x93, 0xB0, 0xCA, 0x0B, 0x5E,
  0x77, 0x10, 0x3A, 0x0B, 0x5E, 0x77, 0x10, 0x3A, 0x0B, 0x5E, 0x77, 0x10, 0x3A, 0x0B, 0x5E, 0x77,
  0x10, 0x3A, 0x0B, 0x5E, 0x07, 0x77, 0x03, 0xA0, 0xB4, 0x07, 0xB0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F,
  0xFF, 0xF8, 0x28, 0x08, 0xDF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_36_av_web() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_round_36_av_web_data, Alpha4(color::Black));
  return value;
}
