#include "notification.h"

using namespace roo_display;

// Image file ic_round_24_notification_account_tree 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_24_notification_account_tree_data[] PROGMEM = {
  0x04, 0x0D, 0xB0, 0xD0, 0x46, 0x04, 0x0D, 0xB8, 0x1D, 0x4D, 0xD0, 0xD6, 0x0D, 0xD0, 0xDF, 0x68,
  0x0E, 0x2F, 0x2A, 0x2F, 0x0D, 0xD0, 0xD2, 0xA2, 0x0D, 0xD8, 0x1D, 0x4D, 0xB0, 0xD0, 0x42, 0xA2,
  0x04, 0x0D, 0xB0, 0xD0, 0x47, 0x2A, 0x77, 0x4A, 0x77, 0x4A, 0x20, 0x40, 0xDB, 0x0D, 0x04, 0x72,
  0xA2, 0x0D, 0xD0, 0xD7, 0x28, 0x1D, 0xF3, 0x1F, 0x72, 0x08, 0xFB, 0x73, 0x08, 0x0E, 0xF9, 0x76,
  0xF7, 0x60, 0xDD, 0x0D, 0x76, 0x04, 0x0D, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_account_tree() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_account_tree_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_adb 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_24_notification_adb_data[] PROGMEM = {
  0x10, 0x47, 0x30, 0x42, 0x0D, 0x0A, 0x71, 0x09, 0x0D, 0x28, 0x92, 0x1D, 0xA7, 0xCE, 0xEC, 0x79,
  0xD1, 0x30, 0x6F, 0x90, 0x63, 0x04, 0xFB, 0x82, 0x40, 0x1E, 0xFB, 0x81, 0xE1, 0x7A, 0x00, 0x3C,
  0x00, 0x3A, 0x07, 0x0C, 0xA0, 0x03, 0xC0, 0x03, 0xA0, 0xC0, 0xEF, 0xD0, 0xEF, 0xF7, 0x78, 0x0E,
  0x4F, 0x0E, 0xFD, 0x0E, 0x0C, 0xFD, 0x0C, 0x07, 0xFD, 0x81, 0x71, 0xEF, 0xB8, 0x2E, 0x10, 0x5F,
  0xB0, 0x53, 0x05, 0x0E, 0xE0, 0xE0, 0x55, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_adb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_adb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_airline_seat_flat_angled 24x24, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_24_notification_airline_seat_flat_angled_data[] PROGMEM = {
  0x38, 0x21, 0x66, 0x17, 0x73, 0x03, 0x0E, 0xA0, 0xE0, 0x37, 0x72, 0x0B, 0xC0, 0xB2, 0x81, 0x15,
  0x27, 0x40, 0xEC, 0x82, 0xE0, 0x2E, 0xA8, 0x1C, 0x61, 0x71, 0x0B, 0xC8, 0x1B, 0x09, 0xE0, 0xA0,
  0x56, 0x03, 0x0E, 0xA8, 0x2E, 0x30, 0xEF, 0x90, 0xE0, 0x73, 0x86, 0x44, 0x16, 0x61, 0x05, 0xFC,
  0x81, 0x90, 0x1A, 0x81, 0xD8, 0x32, 0x09, 0xFD, 0x82, 0x20, 0x6D, 0xB8, 0x4C, 0x71, 0x28, 0xDF,
  0xA0, 0x63, 0x81, 0x39, 0xEB, 0x84, 0xB6, 0x14, 0x9E, 0xE0, 0x56, 0x04, 0xD8, 0x3A, 0x40, 0x5B,
  0xC0, 0x27, 0xF8, 0x5E, 0x93, 0x16, 0xCC, 0x71, 0xFB, 0x81, 0xD7, 0x17, 0x2F, 0x90, 0x80, 0xDA,
  0x0C, 0x72, 0x0B, 0xE0, 0xB2, 0x81, 0x49, 0x62,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_airline_seat_flat_angled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 18), Box(0, 0, 23, 23),
      ic_round_24_notification_airline_seat_flat_angled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_airline_seat_flat 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_24_notification_airline_seat_flat_data[] PROGMEM = {
  0x18, 0x28, 0xEE, 0x82, 0x04, 0x0D, 0xF8, 0x3D, 0xA1, 0x08, 0xC8, 0x18, 0x0D, 0xFB, 0x81, 0xE1,
  0xDC, 0x0D, 0x1F, 0xD0, 0xA0, 0xDC, 0x0D, 0x1F, 0xD0, 0xD0, 0x8C, 0x08, 0x1F, 0xE1, 0x82, 0x8E,
  0xE8, 0x2F, 0xE7, 0x76, 0x0B, 0xFF, 0xC0, 0x0B, 0xFF, 0xC0, 0xB6, 0xF9, 0x75, 0x0B, 0xE0, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_airline_seat_flat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 17), Box(0, 0, 23, 23),
      ic_round_24_notification_airline_seat_flat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_airline_seat_individual_suite 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_24_notification_airline_seat_individual_suite_data[] PROGMEM = {
  0x00, 0xB2, 0x82, 0x8D, 0xD8, 0x20, 0x40, 0xDE, 0x81, 0xDA, 0x11, 0xA1, 0x08, 0xC8, 0x18, 0x0D,
  0xFA, 0x0E, 0x01, 0xA1, 0x0D, 0xC0, 0xD1, 0xFC, 0x0A, 0xA1, 0x0D, 0xC0, 0xD1, 0xFC, 0x0D, 0xA1,
  0x08, 0xC0, 0x81, 0xFF, 0x28, 0x28, 0xDD, 0x82, 0xFF, 0x71, 0xFF, 0xFF, 0xE0, 0xDF, 0xFE, 0x81,
  0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_airline_seat_individual_suite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 22, 16), Box(0, 0, 23, 23),
      ic_round_24_notification_airline_seat_individual_suite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_airline_seat_legroom_extra 24x24, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_24_notification_airline_seat_legroom_extra_data[] PROGMEM = {
  0x00, 0xB1, 0xE7, 0x5A, 0x1E, 0x75, 0xA1, 0xE7, 0x5A, 0x1E, 0x75, 0xA1, 0xE7, 0x5A, 0x1E, 0x75,
  0xA1, 0xFB, 0x0A, 0x7A, 0x1F, 0xC0, 0x76, 0xA1, 0x0D, 0xFB, 0x0E, 0x68, 0x2E, 0xF1, 0x8F, 0xC0,
  0x75, 0x84, 0xBF, 0x70, 0x8D, 0xFA, 0x0E, 0x50, 0x4A, 0x07, 0x01, 0x71, 0x0B, 0xA0, 0x65, 0x08,
  0xF9, 0x0B, 0x20, 0x4A, 0x0D, 0x68, 0x14, 0xBE, 0xD0, 0xB3, 0x0C, 0xA8, 0x26, 0x37, 0x27, 0x70,
  0x4D, 0x0D, 0x77, 0x10, 0xCC, 0x0C, 0x77, 0x10, 0x3B, 0x09, 0x01, 0x77, 0x28, 0x12, 0x51, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_airline_seat_legroom_extra() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_airline_seat_legroom_extra_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_airline_seat_legroom_normal 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_notification_airline_seat_legroom_normal_data[] PROGMEM = {
  0x00, 0xB1, 0xE7, 0x3A, 0x1E, 0x73, 0xA1, 0xE7, 0x3A, 0x1E, 0x73, 0xA1, 0xE7, 0x3A, 0x1E, 0x73,
  0xA1, 0xFC, 0x0D, 0x04, 0x3A, 0x1F, 0xD0, 0xD3, 0xA1, 0x0D, 0xFD, 0x38, 0x2E, 0xF1, 0x8F, 0xD3,
  0x84, 0xBF, 0x70, 0x8D, 0xFB, 0x30, 0x4A, 0x07, 0x01, 0x71, 0xB4, 0x08, 0xF9, 0x0B, 0x2B, 0x58,
  0x14, 0xBE, 0xD0, 0xB2, 0xB7, 0x72, 0xB7, 0x72, 0xD0, 0x87, 0x60, 0xDC, 0x0E, 0x76, 0x04, 0x0D,
  0xB0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_airline_seat_legroom_normal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_airline_seat_legroom_normal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_airline_seat_legroom_reduced 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_24_notification_airline_seat_legroom_reduced_data[] PROGMEM = {
  0x00, 0xB1, 0xE7, 0x1A, 0x1E, 0x71, 0xA1, 0xE7, 0x1A, 0x1E, 0x71, 0xA1, 0xE7, 0x1A, 0x1E, 0x71,
  0xA1, 0xFC, 0x0D, 0x04, 0x1A, 0x1F, 0xD0, 0xD1, 0xA1, 0x0D, 0xFC, 0x84, 0xD0, 0xEF, 0x18, 0xFC,
  0x86, 0x80, 0xBF, 0x70, 0x8D, 0xFA, 0x81, 0x40, 0x4A, 0x07, 0x01, 0x60, 0x1A, 0x0E, 0x30, 0x8E,
  0x0B, 0x20, 0x5A, 0x0B, 0x48, 0x14, 0xBE, 0xB0, 0xB2, 0x09, 0xA0, 0x67, 0x60, 0xDA, 0x02, 0x75,
  0x01, 0xD0, 0x77, 0x30, 0x1D, 0x0E, 0x74, 0x06, 0x0E, 0xB0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_airline_seat_legroom_reduced() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_airline_seat_legroom_reduced_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_airline_seat_recline_extra 24x24, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_round_24_notification_airline_seat_recline_extra_data[] PROGMEM = {
  0x38, 0x1A, 0xFA, 0x77, 0x20, 0x5B, 0x05, 0x77, 0x10, 0x5B, 0x05, 0x77, 0x28, 0x1A, 0xFA, 0x77,
  0x77, 0x60, 0x80, 0xD2, 0x82, 0x8E, 0xC4, 0x75, 0x82, 0xAF, 0x44, 0xC0, 0x77, 0x48, 0x27, 0xF8,
  0x6D, 0x81, 0xD5, 0x17, 0x18, 0x24, 0xFB, 0x4F, 0x90, 0xD0, 0x36, 0x81, 0x1F, 0xE1, 0xC8, 0x18,
  0x6C, 0xA0, 0x57, 0x82, 0xDF, 0x2C, 0xB0, 0xB3, 0x02, 0x71, 0x82, 0xAF, 0x59, 0xB0, 0xE7, 0x58,
  0x27, 0xF8, 0x5C, 0x03, 0x74, 0x82, 0x4F, 0xB1, 0xFA, 0x0A, 0x01, 0x58, 0x31, 0xFE, 0x0A, 0xFA,
  0x0E, 0x03, 0x58, 0x4B, 0xF6, 0x19, 0xEF, 0xA0, 0x64, 0x83, 0x5F, 0xE6, 0x17, 0x10, 0x9A, 0x0A,
  0x40, 0x8F, 0xA0, 0xB2, 0x06, 0xA0, 0x64, 0x81, 0x4B, 0xEE, 0x0B, 0x38, 0x13, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_airline_seat_recline_extra() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_airline_seat_recline_extra_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_airline_seat_recline_normal 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_24_notification_airline_seat_recline_normal_data[] PROGMEM = {
  0x38, 0x24, 0xDD, 0x47, 0x50, 0xDA, 0x0D, 0x75, 0x0D, 0xA0, 0xD7, 0x58, 0x24, 0xDD, 0x47, 0x77,
  0x48, 0x5B, 0xB0, 0x3C, 0xE8, 0x72, 0xA1, 0x0C, 0xB0, 0x97, 0x1A, 0x1D, 0x08, 0x7A, 0x1E, 0x0B,
  0x03, 0x5A, 0x1C, 0x0B, 0x0E, 0xA0, 0xD0, 0x73, 0xA1, 0xC8, 0x47, 0x18, 0xEF, 0xE3, 0xA1, 0xC0,
  0x73, 0x04, 0x02, 0x3A, 0x1C, 0x07, 0x71, 0xA1, 0x0D, 0xE0, 0xE0, 0x64, 0x82, 0xEF, 0x18, 0xF9,
  0x06, 0x38, 0x4B, 0xF7, 0x08, 0xDF, 0x06, 0x20, 0x4A, 0x07, 0x01, 0x60, 0x6A, 0x06, 0x20, 0x8F,
  0x98, 0x1B, 0x06, 0xA0, 0x42, 0x81, 0x4B, 0xED, 0x0B, 0x28, 0x16, 0xE5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_airline_seat_recline_normal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_airline_seat_recline_normal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_bluetooth_audio 24x24, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_round_24_notification_bluetooth_audio_data[] PROGMEM = {
  0x60, 0x05, 0x77, 0x2A, 0x07, 0x77, 0x1B, 0x07, 0x71, 0x81, 0x27, 0x13, 0xC0, 0x77, 0x82, 0x7F,
  0xC1, 0x2A, 0x05, 0xA0, 0x76, 0x83, 0x1D, 0xFC, 0x11, 0xA1, 0x06, 0xA0, 0x22, 0x03, 0x09, 0x28,
  0x31, 0xDF, 0xC1, 0xA8, 0x21, 0xDF, 0xC3, 0x81, 0x7F, 0x52, 0x82, 0x1D, 0xFC, 0xA8, 0x2D, 0xFC,
  0x13, 0x81, 0x2F, 0xA3, 0x01, 0x0D, 0xC8, 0x3C, 0x10, 0x49, 0x20, 0xE0, 0xD4, 0x01, 0x0D, 0xA8,
  0x4C, 0x10, 0x3E, 0xE2, 0x0C, 0x0E, 0x40, 0x10, 0xDA, 0x84, 0xC1, 0x03, 0xFE, 0x20, 0xC0, 0xE3,
  0x01, 0x0D, 0xC8, 0x3C, 0x10, 0x4A, 0x20, 0xE0, 0xC2, 0x82, 0x1D, 0xFC, 0xA8, 0x2D, 0xFC, 0x13,
  0x87, 0x2F, 0x90, 0x1D, 0xFC, 0x1A, 0x82, 0x1D, 0xFC, 0x38, 0x67, 0xF4, 0x1D, 0xFC, 0x11, 0xA1,
  0x06, 0xA0, 0x22, 0x85, 0x38, 0x07, 0xFC, 0x12, 0xA0, 0x5A, 0x07, 0x68, 0x12, 0x71, 0x3C, 0x07,
  0x76, 0xB0, 0x77, 0x7A, 0x07, 0x77, 0x10, 0x05, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_bluetooth_audio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_bluetooth_audio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_confirmation_number 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_24_notification_confirmation_number_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDF, 0xA0, 0x07, 0xFF, 0xC2, 0xFA, 0x0E, 0xF9,
  0x00, 0x7F, 0xA0, 0xAF, 0xFC, 0x81, 0xA0, 0xBF, 0xFA, 0x0B, 0x20, 0x2F, 0x2F, 0x02, 0x20, 0x2F,
  0x2F, 0x02, 0x20, 0xBF, 0xFA, 0x81, 0xB0, 0xAF, 0xFC, 0x0A, 0xFA, 0x00, 0x7F, 0xFC, 0x2F, 0xFC,
  0x00, 0x7F, 0xA0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_confirmation_number() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_confirmation_number_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_directions_off 24x24, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_round_24_notification_directions_off_data[] PROGMEM = {
  0x72, 0x82, 0x1B, 0xB1, 0x72, 0x09, 0x06, 0x50, 0x10, 0xCA, 0x0C, 0x01, 0x70, 0x1A, 0x07, 0x30,
  0x10, 0xCC, 0x0C, 0x01, 0x70, 0x5A, 0x07, 0x20, 0x8E, 0x0C, 0x01, 0x70, 0x5A, 0x07, 0x20, 0xAE,
  0x0C, 0x01, 0x70, 0x5A, 0x07, 0x20, 0xAA, 0x0D, 0xB0, 0xC0, 0x16, 0x01, 0x0D, 0xA0, 0x72, 0x82,
  0xAF, 0x1D, 0xB0, 0xC0, 0x14, 0x01, 0x0C, 0xC0, 0x72, 0x82, 0xA0, 0x1D, 0xB0, 0xC0, 0x12, 0x01,
  0x0C, 0xE0, 0x74, 0x01, 0x0E, 0xB8, 0x2C, 0x10, 0xBD, 0x05, 0xA0, 0x73, 0x01, 0x0E, 0xC8, 0x1B,
  0x0B, 0xD1, 0x05, 0xA0, 0x72, 0x08, 0xD8, 0x2B, 0x01, 0xCC, 0x2B, 0x07, 0x20, 0xAB, 0x0C, 0x01,
  0x20, 0x10, 0xCB, 0x00, 0x3C, 0x07, 0x28, 0x2A, 0xFC, 0x14, 0x01, 0x0C, 0xFA, 0x07, 0x20, 0x80,
  0x16, 0x01, 0x0C, 0xFA, 0x07, 0x73, 0x01, 0x0C, 0xFA, 0x07, 0x73, 0x01, 0x0C, 0xE0, 0xDA, 0x07,
  0x73, 0x01, 0x0C, 0xC8, 0x1C, 0x15, 0xA0, 0x77, 0x30, 0x10, 0xCA, 0x0C, 0x01, 0x20, 0x5A, 0x06,
  0x73, 0x82, 0x1B, 0xB1, 0x48, 0x15, 0xF9, 0x77, 0x50, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_directions_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_directions_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_disc_full 24x24, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_24_notification_disc_full_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x40, 0x9F, 0x90, 0x97, 0x20, 0xBF, 0xB0, 0xB7, 0x09, 0xFD,
  0x09, 0x38, 0x1B, 0xB2, 0xFF, 0x02, 0x2A, 0x08, 0xFF, 0x08, 0x2A, 0x0C, 0xD8, 0x2B, 0x11, 0xBD,
  0x0C, 0x2A, 0x0E, 0xD0, 0x12, 0x01, 0xD0, 0xE2, 0x81, 0xBB, 0xED, 0x01, 0x20, 0x1D, 0x0E, 0x40,
  0xCD, 0x82, 0xB1, 0x1B, 0xD0, 0xC4, 0x08, 0xFF, 0x08, 0x2A, 0x02, 0xFF, 0x02, 0x2A, 0x10, 0x9F,
  0xD0, 0x97, 0x0B, 0xFB, 0x0B, 0x72, 0x09, 0xF9, 0x09, 0x74, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_disc_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_disc_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_do_disturb_alt 24x24, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_round_24_notification_do_disturb_alt_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x7A, 0x08, 0x30, 0x4A, 0x04, 0x71, 0x01,
  0x0C, 0xB0, 0x42, 0x81, 0xDF, 0x67, 0x18, 0x91, 0x1C, 0xFC, 0x7F, 0xD0, 0x5F, 0xC7, 0x18, 0x92,
  0x1C, 0xFC, 0x10, 0xCF, 0x59, 0xF6, 0x78, 0x31, 0xCF, 0xC1, 0x28, 0x46, 0xF9, 0xDF, 0x26, 0x83,
  0x1C, 0xFC, 0x13, 0x82, 0x2F, 0xDE, 0x96, 0x83, 0x1C, 0xFC, 0x15, 0x90, 0x0E, 0x95, 0x83, 0x1C,
  0xFC, 0x16, 0x98, 0x2E, 0xDF, 0x23, 0x83, 0x1C, 0xFC, 0x16, 0x84, 0x2F, 0xD9, 0xF6, 0x28, 0x31,
  0xCF, 0xC1, 0x78, 0x92, 0x6F, 0x95, 0xFC, 0x01, 0xCF, 0xC1, 0x71, 0x89, 0x1C, 0xF5, 0x0D, 0xF7,
  0xCF, 0xC1, 0x71, 0x81, 0x6F, 0xD2, 0x04, 0xB0, 0xC0, 0x17, 0x10, 0x4A, 0x04, 0x30, 0x8A, 0x07,
  0x71, 0x06, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9,
  0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_do_disturb_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_do_disturb_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_do_disturb_off 24x24, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_round_24_notification_do_disturb_off_data[] PROGMEM = {
  0x01, 0x05, 0x58, 0x65, 0xAD, 0xFE, 0xD9, 0x56, 0x81, 0x7F, 0xB2, 0x01, 0x0D, 0xF9, 0x0D, 0x04,
  0x48, 0x21, 0xDF, 0xB2, 0x05, 0xFB, 0x08, 0x48, 0x22, 0xDF, 0xB2, 0x05, 0xFB, 0x08, 0x40, 0x6A,
  0x0B, 0x20, 0x5F, 0xB0, 0x43, 0x0D, 0xB0, 0xB2, 0x05, 0xFA, 0x0D, 0x20, 0x5D, 0x0B, 0x20, 0x5F,
  0xA8, 0x15, 0x0A, 0xE0, 0xB2, 0x05, 0xF9, 0x81, 0x90, 0xDF, 0x0B, 0x20, 0x5F, 0x81, 0xD0, 0xEC,
  0x18, 0x22, 0xDF, 0xB5, 0xC8, 0x1E, 0x0E, 0xC2, 0x82, 0x2D, 0xFB, 0x4C, 0x81, 0xE0, 0xDF, 0xB0,
  0xB2, 0x05, 0xC8, 0x1D, 0x09, 0xFC, 0x0B, 0x20, 0x5B, 0x81, 0xA0, 0x5F, 0xD0, 0xB2, 0x05, 0xA0,
  0x52, 0x0D, 0xFD, 0x0B, 0x20, 0x50, 0xD3, 0x04, 0xFE, 0x0B, 0x20, 0x14, 0x08, 0xFE, 0x0B, 0x70,
  0x8F, 0xE0, 0xB7, 0x04, 0x0D, 0xF9, 0x83, 0xD6, 0xDF, 0xB7, 0x18, 0x65, 0x9D, 0xEF, 0xDA, 0x52,
  0x82, 0x2D, 0xF5, 0x77, 0x48, 0x11, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_do_disturb_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_do_disturb_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_do_disturb_on 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_24_notification_do_disturb_on_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xFF, 0xC0, 0x50, 0x9F,
  0xFC, 0x09, 0x0D, 0xFF, 0xC0, 0xD0, 0xEC, 0x03, 0x71, 0x03, 0xC0, 0x0E, 0xC0, 0x37, 0x10, 0x3C,
  0x0E, 0x0D, 0xFF, 0xC0, 0xD0, 0x9F, 0xFC, 0x09, 0x05, 0xFF, 0xC8, 0x15, 0x0D, 0xFF, 0xA0, 0xD2,
  0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
  0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_do_disturb_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_do_disturb_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_do_disturb 24x24, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_round_24_notification_do_disturb_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x77, 0x10, 0x6A, 0x08, 0x30, 0x4B, 0x0C, 0x01, 0x71,
  0x04, 0xA0, 0x42, 0x85, 0xDF, 0x7C, 0xFC, 0x17, 0x18, 0x93, 0x6F, 0xD0, 0x5F, 0xC0, 0x1C, 0xFC,
  0x17, 0x18, 0x4C, 0xF5, 0x9F, 0x62, 0x83, 0x1C, 0xFC, 0x17, 0x84, 0x6F, 0x9D, 0xF2, 0x38, 0x31,
  0xCF, 0xC1, 0x68, 0x22, 0xFD, 0xE9, 0x58, 0x31, 0xCF, 0xC1, 0x69, 0x00, 0xE9, 0x68, 0x31, 0xCF,
  0xC1, 0x59, 0x82, 0xED, 0xF2, 0x68, 0x31, 0xCF, 0xC1, 0x38, 0x42, 0xFD, 0x9F, 0x67, 0x83, 0x1C,
  0xFC, 0x12, 0x84, 0x6F, 0x95, 0xFC, 0x71, 0x89, 0x31, 0xCF, 0xC1, 0x0C, 0xF5, 0x0D, 0xF6, 0x71,
  0x85, 0x1C, 0xFC, 0x7F, 0xD2, 0x04, 0xA0, 0x47, 0x10, 0x10, 0xCB, 0x04, 0x30, 0x8A, 0x06, 0x71,
  0x07, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9, 0x0D,
  0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_do_disturb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_do_disturb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_do_not_disturb_alt 24x24, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_round_24_notification_do_not_disturb_alt_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x7A, 0x08, 0x30, 0x4A, 0x04, 0x71, 0x01,
  0x0C, 0xB0, 0x42, 0x81, 0xDF, 0x67, 0x18, 0x91, 0x1C, 0xFC, 0x7F, 0xD0, 0x5F, 0xC7, 0x18, 0x92,
  0x1C, 0xFC, 0x10, 0xCF, 0x59, 0xF6, 0x78, 0x31, 0xCF, 0xC1, 0x28, 0x46, 0xF9, 0xDF, 0x26, 0x83,
  0x1C, 0xFC, 0x13, 0x82, 0x2F, 0xDE, 0x96, 0x83, 0x1C, 0xFC, 0x15, 0x90, 0x0E, 0x95, 0x83, 0x1C,
  0xFC, 0x16, 0x98, 0x2E, 0xDF, 0x23, 0x83, 0x1C, 0xFC, 0x16, 0x84, 0x2F, 0xD9, 0xF6, 0x28, 0x31,
  0xCF, 0xC1, 0x78, 0x92, 0x6F, 0x95, 0xFC, 0x01, 0xCF, 0xC1, 0x71, 0x89, 0x1C, 0xF5, 0x0D, 0xF7,
  0xCF, 0xC1, 0x71, 0x81, 0x6F, 0xD2, 0x04, 0xB0, 0xC0, 0x17, 0x10, 0x4A, 0x04, 0x30, 0x8A, 0x07,
  0x71, 0x06, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9,
  0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_do_not_disturb_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_do_not_disturb_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_do_not_disturb_off 24x24, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_round_24_notification_do_not_disturb_off_data[] PROGMEM = {
  0x78, 0x65, 0xAD, 0xFE, 0xD9, 0x57, 0x09, 0x06, 0x20, 0x30, 0xDF, 0x90, 0xD0, 0x44, 0x01, 0xA0,
  0x72, 0x0A, 0xFB, 0x08, 0x40, 0x5A, 0x07, 0x20, 0xAF, 0xB0, 0x84, 0x08, 0xA0, 0x72, 0x0A, 0xFB,
  0x04, 0x30, 0xDB, 0x07, 0x20, 0xAF, 0xA0, 0xD2, 0x05, 0xD0, 0x72, 0x0A, 0xFA, 0x81, 0x50, 0xAE,
  0x07, 0x20, 0xAF, 0x98, 0x19, 0x0D, 0xF0, 0x72, 0x0A, 0xF8, 0x1D, 0x0E, 0xC1, 0x05, 0xA0, 0x75,
  0xC8, 0x1E, 0x0E, 0xC2, 0x05, 0xA0, 0x74, 0xC8, 0x1E, 0x0D, 0xFB, 0x07, 0x20, 0xAC, 0x81, 0xD0,
  0xAF, 0xC0, 0x72, 0x0A, 0xB8, 0x1A, 0x05, 0xFD, 0x07, 0x20, 0xAA, 0x05, 0x20, 0xDF, 0xD0, 0x72,
  0x0A, 0x0D, 0x30, 0x5F, 0xE0, 0x72, 0x03, 0x40, 0x9F, 0xE0, 0x77, 0x09, 0xFE, 0x07, 0x70, 0x50,
  0xDF, 0x90, 0xD0, 0x8A, 0x06, 0x71, 0x86, 0x5A, 0xDE, 0xED, 0x95, 0x28, 0x15, 0xF9, 0x77, 0x50,
  0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_do_not_disturb_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_do_not_disturb_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_do_not_disturb_on 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_24_notification_do_not_disturb_on_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x05, 0xFF, 0xC0, 0x50, 0x9F,
  0xFC, 0x09, 0x0D, 0xFF, 0xC0, 0xD0, 0xEC, 0x03, 0x71, 0x03, 0xC0, 0x0E, 0xC0, 0x37, 0x10, 0x3C,
  0x0E, 0x0D, 0xFF, 0xC0, 0xD0, 0x9F, 0xFC, 0x09, 0x05, 0xFF, 0xC8, 0x15, 0x0D, 0xFF, 0xA0, 0xD2,
  0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
  0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_do_not_disturb_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_do_not_disturb_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_do_not_disturb 24x24, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_round_24_notification_do_not_disturb_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x77, 0x10, 0x6A, 0x08, 0x30, 0x4B, 0x0C, 0x01, 0x71,
  0x04, 0xA0, 0x42, 0x85, 0xDF, 0x7C, 0xFC, 0x17, 0x18, 0x93, 0x6F, 0xD0, 0x5F, 0xC0, 0x1C, 0xFC,
  0x17, 0x18, 0x4C, 0xF5, 0x9F, 0x62, 0x83, 0x1C, 0xFC, 0x17, 0x84, 0x6F, 0x9D, 0xF2, 0x38, 0x31,
  0xCF, 0xC1, 0x68, 0x22, 0xFD, 0xE9, 0x58, 0x31, 0xCF, 0xC1, 0x69, 0x00, 0xE9, 0x68, 0x31, 0xCF,
  0xC1, 0x59, 0x82, 0xED, 0xF2, 0x68, 0x31, 0xCF, 0xC1, 0x38, 0x42, 0xFD, 0x9F, 0x67, 0x83, 0x1C,
  0xFC, 0x12, 0x84, 0x6F, 0x95, 0xFC, 0x71, 0x89, 0x31, 0xCF, 0xC1, 0x0C, 0xF5, 0x0D, 0xF6, 0x71,
  0x85, 0x1C, 0xFC, 0x7F, 0xD2, 0x04, 0xA0, 0x47, 0x10, 0x10, 0xCB, 0x04, 0x30, 0x8A, 0x06, 0x71,
  0x07, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9, 0x0D,
  0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_do_not_disturb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_do_not_disturb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_drive_eta 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_24_notification_drive_eta_data[] PROGMEM = {
  0x20, 0x70, 0xEF, 0xB0, 0xE0, 0x73, 0x81, 0x1F, 0xC8, 0x06, 0x78, 0x1C, 0xF1, 0x28, 0x16, 0xF2,
  0x73, 0x81, 0x2F, 0x62, 0x00, 0xC7, 0x58, 0x4C, 0xC0, 0x2F, 0x77, 0x58, 0x47, 0xF2, 0x7F, 0x27,
  0x58, 0x22, 0xF7, 0xCF, 0xFA, 0x0C, 0xFF, 0xE8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x7C, 0x3F, 0x93,
  0xC8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x78, 0x0E, 0x7F, 0x75, 0xB8, 0x18, 0xE8, 0x75, 0x81, 0x8E,
  0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_drive_eta() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_drive_eta_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_enhanced_encryption 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_24_notification_enhanced_encryption_data[] PROGMEM = {
  0x58, 0x44, 0xBE, 0xEB, 0x47, 0x20, 0x8E, 0x08, 0x78, 0x24, 0xFE, 0x52, 0x82, 0x5E, 0xF4, 0x68,
  0x1B, 0xF5, 0x48, 0x15, 0xFB, 0x60, 0xE9, 0x69, 0x0E, 0x69, 0x0D, 0x60, 0xD9, 0x69, 0x0D, 0x60,
  0xD9, 0x30, 0x40, 0xDF, 0xD8, 0x1D, 0x4D, 0xFF, 0x0D, 0xFF, 0xFA, 0x00, 0x3F, 0xF2, 0xFF, 0x2F,
  0xC0, 0x36, 0x03, 0xF9, 0x03, 0x60, 0x3F, 0xC2, 0xFF, 0x2F, 0xF0, 0x03, 0xFF, 0xFA, 0x0D, 0xFF,
  0x81, 0xD4, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_enhanced_encryption() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_enhanced_encryption_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_event_available 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_notification_event_available_data[] PROGMEM = {
  0x30, 0x0B, 0x71, 0x00, 0xB6, 0xA7, 0x1A, 0x30, 0x40, 0xDF, 0xF8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD8,
  0x0E, 0x4F, 0x77, 0xC7, 0x7C, 0x72, 0x02, 0x08, 0x3C, 0x71, 0x82, 0x2D, 0xE1, 0x2C, 0x78, 0x22,
  0xDE, 0x23, 0xC2, 0x86, 0x2C, 0x30, 0x2D, 0xE2, 0x4C, 0x38, 0x4C, 0xE5, 0xDE, 0x25, 0xC3, 0x83,
  0x1C, 0xFE, 0x26, 0xC4, 0x81, 0x17, 0x27, 0xC7, 0x7C, 0x03, 0x75, 0x03, 0xA0, 0xDF, 0xFA, 0x81,
  0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_event_available() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_event_available_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_event_busy 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_24_notification_event_busy_data[] PROGMEM = {
  0x30, 0x0B, 0x71, 0x00, 0xB6, 0xA7, 0x1A, 0x30, 0x40, 0xDF, 0xF8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD8,
  0x0E, 0x4F, 0x77, 0xC7, 0x7C, 0x30, 0x20, 0x83, 0x04, 0x07, 0x4C, 0x38, 0x53, 0xFB, 0x05, 0xFA,
  0x4C, 0x48, 0x35, 0xFC, 0xFB, 0x5C, 0x58, 0x28, 0xFE, 0x15, 0xC4, 0x83, 0x5F, 0xCF, 0xB5, 0xC3,
  0x85, 0x3F, 0xB0, 0x5F, 0xA4, 0xC3, 0x02, 0x08, 0x30, 0x40, 0x74, 0xC7, 0x7C, 0x03, 0x75, 0x03,
  0xA0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_event_busy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_event_busy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_event_note 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_notification_event_note_data[] PROGMEM = {
  0x30, 0x0B, 0x71, 0x00, 0xB6, 0xA7, 0x1A, 0x30, 0x40, 0xDF, 0xF8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD8,
  0x0E, 0x4F, 0x77, 0xC7, 0x7C, 0x20, 0xBF, 0x90, 0xB2, 0xC2, 0x0B, 0xF9, 0x0B, 0x2C, 0x77, 0xC7,
  0x7C, 0x20, 0xBD, 0x0B, 0x5C, 0x20, 0xBD, 0x0B, 0x5C, 0x77, 0xC7, 0x7C, 0x03, 0x75, 0x03, 0xA0,
  0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_event_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_event_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_folder_special 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_notification_folder_special_data[] PROGMEM = {
  0x04, 0x0D, 0xD0, 0xE0, 0x67, 0x40, 0xDF, 0x90, 0x77, 0x3F, 0xFC, 0x0D, 0x04, 0xFF, 0xD0, 0xDF,
  0xD0, 0x0E, 0xFF, 0xC0, 0x05, 0xFF, 0xB0, 0xD2, 0x0E, 0xFF, 0x81, 0x53, 0x12, 0x81, 0x13, 0x5F,
  0xD0, 0x76, 0x07, 0xFE, 0x08, 0x40, 0x9F, 0xF0, 0x94, 0x0A, 0xFF, 0x84, 0x60, 0x66, 0x06, 0xFF,
  0x00, 0xCA, 0x0C, 0x0B, 0xFF, 0xFB, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_folder_special() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_folder_special_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_imagesearch_roller 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_notification_imagesearch_roller_data[] PROGMEM = {
  0x40, 0xBF, 0xD0, 0xB4, 0xFF, 0x04, 0x0D, 0xFF, 0xA0, 0xDF, 0xFD, 0x2F, 0xFA, 0x20, 0xBF, 0xD0,
  0xBA, 0x77, 0x2A, 0x77, 0x20, 0xDF, 0xA0, 0xD0, 0x46, 0x04, 0x0D, 0xFA, 0x0D, 0x77, 0x2A, 0x77,
  0x2A, 0x77, 0x2A, 0x77, 0x0B, 0xC0, 0xB7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7,
  0x50, 0xBC, 0x0B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_imagesearch_roller() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 19, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_imagesearch_roller_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_live_tv 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_24_notification_live_tv_data[] PROGMEM = {
  0x60, 0x40, 0x76, 0x07, 0x04, 0x75, 0x81, 0x1C, 0x74, 0x81, 0x7C, 0x17, 0x68, 0x11, 0xC7, 0x28,
  0x17, 0xC1, 0x77, 0x18, 0x41, 0xC7, 0x7C, 0x17, 0x10, 0x40, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFE,
  0x0D, 0xA0, 0x37, 0x72, 0x03, 0xC7, 0x74, 0xC6, 0x00, 0x17, 0x3C, 0x68, 0x2E, 0xF8, 0x17, 0x1C,
  0x6B, 0x0E, 0x06, 0x7C, 0x6D, 0x0B, 0x6C, 0x6D, 0x0B, 0x6C, 0x6B, 0x0E, 0x06, 0x7C, 0x68, 0x2E,
  0xF8, 0x17, 0x1C, 0x60, 0x01, 0x73, 0xC7, 0x74, 0xC0, 0x37, 0x72, 0x03, 0xA0, 0xDF, 0xFE, 0x81,
  0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_live_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_live_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_mms 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_24_notification_mms_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x09, 0xA7, 0xF8, 0x1E, 0x7E, 0xFD, 0x0E,
  0xC8, 0x15, 0x05, 0xFC, 0x81, 0xB0, 0xAA, 0x08, 0x30, 0x9F, 0xA0, 0xD0, 0x12, 0x0C, 0x0B, 0x50,
  0xCF, 0x90, 0x33, 0x00, 0x15, 0x02, 0x0E, 0xE0, 0xA7, 0x50, 0x98, 0x0F, 0x2F, 0x0D, 0xFF, 0xC0,
  0xD0, 0x4B, 0x07, 0x77, 0x2A, 0x07, 0x77, 0x39, 0x07, 0x77, 0x40, 0x77, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_mms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_mms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_more 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_24_notification_more_data[] PROGMEM = {
  0x50, 0x30, 0xDF, 0xF9, 0x0D, 0x04, 0x40, 0x10, 0xEF, 0xFB, 0x0D, 0x40, 0xAF, 0xFD, 0x30, 0x5F,
  0xFE, 0x20, 0x10, 0xEF, 0xFE, 0x20, 0xAF, 0xFF, 0x10, 0x5F, 0xFF, 0x90, 0x10, 0xEE, 0x00, 0x9B,
  0x00, 0x9B, 0x00, 0x9C, 0x09, 0xE0, 0x92, 0x81, 0x9F, 0x92, 0x81, 0x9F, 0x92, 0x09, 0xB0, 0x9E,
  0x09, 0x28, 0x19, 0xF9, 0x28, 0x19, 0xF9, 0x20, 0x9B, 0x01, 0x0E, 0xE0, 0x09, 0xB0, 0x09, 0xB0,
  0x09, 0xC1, 0x05, 0xFF, 0xF9, 0x20, 0xAF, 0xFF, 0x20, 0x10, 0xEF, 0xFE, 0x30, 0x5F, 0xFE, 0x40,
  0xAF, 0xFD, 0x40, 0x10, 0xEF, 0xFB, 0x0D, 0x50, 0x30, 0xDF, 0xF9, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_more() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_more_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_network_check 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_round_24_notification_network_check_data[] PROGMEM = {
  0x78, 0x51, 0x36, 0x77, 0x53, 0x75, 0x81, 0x16, 0xCE, 0x83, 0x59, 0x44, 0x16, 0x01, 0x09, 0xF9,
  0x86, 0xD1, 0xF3, 0xCF, 0x91, 0x30, 0x40, 0xEC, 0x85, 0xC9, 0x65, 0x53, 0x89, 0x1B, 0x82, 0xD4,
  0x03, 0xC0, 0x80, 0x26, 0x82, 0xEC, 0x08, 0xC0, 0x03, 0xA0, 0xC0, 0x27, 0x81, 0x6F, 0x92, 0x01,
  0x0B, 0xA8, 0x23, 0x04, 0x54, 0x86, 0x38, 0xBD, 0x1D, 0xF7, 0x40, 0x50, 0x46, 0x03, 0x0C, 0xB0,
  0xA0, 0x4A, 0x81, 0x48, 0x37, 0x20, 0x2D, 0x03, 0x0B, 0xA8, 0x21, 0xEF, 0x27, 0x10, 0x3A, 0x82,
  0xD6, 0x22, 0xA0, 0xD0, 0x1A, 0x03, 0x72, 0x04, 0x05, 0x30, 0x9A, 0x82, 0xA0, 0x54, 0x77, 0x01,
  0xB0, 0x77, 0x73, 0x08, 0xB0, 0x47, 0x73, 0x0D, 0xB0, 0x17, 0x73, 0x0D, 0xA0, 0xD7, 0x74, 0x82,
  0x4D, 0xD4, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_network_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_network_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_network_locked 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_24_notification_network_locked_data[] PROGMEM = {
  0x77, 0x30, 0x05, 0x77, 0x30, 0x7A, 0x77, 0x20, 0x7B, 0x77, 0x10, 0x7C, 0x77, 0x07, 0xD7, 0x60,
  0x7E, 0x75, 0x07, 0xF7, 0x40, 0x7F, 0x97, 0x30, 0x7F, 0xA7, 0x20, 0x7C, 0x81, 0xD5, 0x17, 0x40,
  0x7C, 0x0D, 0x01, 0x75, 0x07, 0xD0, 0x52, 0x82, 0x4D, 0xD4, 0x60, 0x7E, 0x01, 0x28, 0x2D, 0x33,
  0xD5, 0x07, 0xF3, 0x92, 0x94, 0x07, 0xF9, 0x20, 0xBC, 0x0B, 0x20, 0x7F, 0xA2, 0xE1, 0x07, 0xFB,
  0x2E, 0x05, 0xFC, 0x2E, 0x05, 0xFC, 0x20, 0xBC, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_network_locked() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_network_locked_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_no_encryption_gmailerrorred 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_round_24_notification_no_encryption_gmailerrorred_data[] PROGMEM = {
  0x68, 0x43, 0xBE, 0xEB, 0x47, 0x40, 0x7E, 0x08, 0x72, 0x82, 0x3F, 0xE5, 0x28, 0x25, 0xEF, 0x47,
  0x18, 0x1A, 0xF5, 0x48, 0x15, 0xFB, 0x48, 0x43, 0xA2, 0x02, 0xD6, 0x90, 0xE4, 0x84, 0x6F, 0xE2,
  0x01, 0x60, 0xD9, 0x58, 0x2A, 0xFE, 0x27, 0x0D, 0x95, 0x04, 0xA8, 0x3E, 0x20, 0x2D, 0xE0, 0xD0,
  0x42, 0x0D, 0xB8, 0x3E, 0x20, 0x2D, 0xE0, 0xD2, 0xD8, 0x3E, 0x20, 0x2D, 0xE2, 0xE8, 0x3E, 0x20,
  0x2D, 0xD2, 0xF8, 0x3E, 0x20, 0x2D, 0xC2, 0xF9, 0x83, 0xE2, 0x02, 0xDB, 0x2F, 0xA8, 0x3E, 0x20,
  0x2D, 0xA2, 0xFB, 0x83, 0xE2, 0x02, 0xD9, 0x2F, 0xC8, 0x3E, 0x20, 0x2D, 0x2F, 0xD8, 0x2E, 0x20,
  0x22, 0xFE, 0x0E, 0x02, 0x3F, 0xF0, 0xE0, 0x22, 0x0D, 0xFF, 0x83, 0xE2, 0x04, 0xDF, 0xF0, 0xA7,
  0x72, 0x06, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_no_encryption_gmailerrorred() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_no_encryption_gmailerrorred_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_no_encryption 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_round_24_notification_no_encryption_data[] PROGMEM = {
  0x68, 0x43, 0xBE, 0xEB, 0x47, 0x40, 0x7E, 0x08, 0x72, 0x82, 0x3F, 0xE5, 0x28, 0x25, 0xEF, 0x47,
  0x18, 0x1A, 0xF5, 0x48, 0x15, 0xFB, 0x48, 0x43, 0xA2, 0x02, 0xD6, 0x90, 0xE4, 0x84, 0x6F, 0xE2,
  0x01, 0x60, 0xD9, 0x58, 0x2A, 0xFE, 0x27, 0x0D, 0x95, 0x04, 0xA8, 0x3E, 0x20, 0x2D, 0xE0, 0xD0,
  0x42, 0x0D, 0xB8, 0x3E, 0x20, 0x2D, 0xE0, 0xD2, 0xD8, 0x3E, 0x20, 0x2D, 0xE2, 0xE8, 0x3E, 0x20,
  0x2D, 0xD2, 0xF8, 0x3E, 0x20, 0x2D, 0xC2, 0xF9, 0x83, 0xE2, 0x02, 0xDB, 0x2F, 0xA8, 0x3E, 0x20,
  0x2D, 0xA2, 0xFB, 0x83, 0xE2, 0x02, 0xD9, 0x2F, 0xC8, 0x3E, 0x20, 0x2D, 0x2F, 0xD8, 0x2E, 0x20,
  0x22, 0xFE, 0x0E, 0x02, 0x3F, 0xF0, 0xE0, 0x22, 0x0D, 0xFF, 0x83, 0xE2, 0x04, 0xDF, 0xF0, 0xA7,
  0x72, 0x06, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_no_encryption() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_no_encryption_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_ondemand_video 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_notification_ondemand_video_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x60,
  0x01, 0x73, 0xC6, 0x82, 0xEF, 0x81, 0x71, 0xC6, 0xB0, 0xE0, 0x67, 0xC6, 0xD0, 0xB6, 0xC6, 0xD0,
  0xB6, 0xC6, 0xB0, 0xE0, 0x67, 0xC6, 0x82, 0xEF, 0x81, 0x71, 0xC6, 0x00, 0x17, 0x3C, 0x77, 0x4C,
  0x03, 0x77, 0x20, 0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x47, 0xF9, 0x77, 0x0B,
  0xE0, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_ondemand_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_ondemand_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_personal_video 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_notification_personal_video_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77,
  0x4C, 0x03, 0x77, 0x20, 0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x47, 0xF9, 0x77,
  0x0B, 0xE0, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_personal_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_personal_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_phone_bluetooth_speaker 24x24, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_round_24_notification_phone_bluetooth_speaker_data[] PROGMEM = {
  0x77, 0x0B, 0x02, 0x76, 0x02, 0x29, 0x83, 0xD2, 0x04, 0xDA, 0x0C, 0x02, 0x58, 0x69, 0xA0, 0xF6,
  0xE1, 0xDC, 0x0A, 0x68, 0x5A, 0xAF, 0xAA, 0x0D, 0xC0, 0xC7, 0x81, 0xAF, 0xA2, 0x0B, 0xC0, 0xE7,
  0x81, 0xAF, 0xA2, 0x09, 0xD6, 0x85, 0xAA, 0xFA, 0xA0, 0x5C, 0x0B, 0x58, 0x59, 0xA0, 0xF5, 0xE1,
  0x1B, 0x0C, 0x01, 0x50, 0x22, 0x90, 0xE0, 0x22, 0x82, 0xAF, 0xD1, 0x72, 0x0B, 0x02, 0x38, 0x23,
  0xFE, 0x17, 0x71, 0x81, 0xAF, 0xA7, 0x71, 0x82, 0x1E, 0xF6, 0x77, 0x10, 0x4A, 0x05, 0x77, 0x10,
  0x7A, 0x06, 0x38, 0x51, 0xBF, 0xEC, 0xA2, 0x50, 0x7A, 0x82, 0xA1, 0x1C, 0xD0, 0xC6, 0x83, 0x4E,
  0xFE, 0xDF, 0x70, 0x10, 0xAF, 0xA7, 0x20, 0x30, 0xAE, 0x0D, 0x75, 0x84, 0x59, 0xBE, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_phone_bluetooth_speaker() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_phone_bluetooth_speaker_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_phone_callback 24x24, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_24_notification_phone_callback_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xC0, 0x27, 0x18, 0x31, 0xBB, 0x0D, 0xC0, 0xA7, 0x84, 0x1C, 0xFB, 0x0D, 0xC0,
  0xC3, 0x89, 0x0B, 0xB0, 0x1C, 0xFC, 0x10, 0xBC, 0x0E, 0x3A, 0x83, 0x1C, 0xFC, 0x12, 0x09, 0xD3,
  0xA8, 0x2C, 0xFC, 0x13, 0x05, 0xC0, 0xB3, 0xB0, 0xC0, 0x15, 0xB0, 0xC0, 0x13, 0xD0, 0xB4, 0x82,
  0xAF, 0xD1, 0x40, 0xBC, 0x0B, 0x48, 0x23, 0xFE, 0x17, 0x71, 0x81, 0xAF, 0xA7, 0x71, 0x82, 0x1E,
  0xF6, 0x77, 0x10, 0x4A, 0x05, 0x77, 0x10, 0x7A, 0x06, 0x38, 0x51, 0xBF, 0xEC, 0xA2, 0x50, 0x7A,
  0x82, 0xA1, 0x1C, 0xD0, 0xC6, 0x83, 0x4E, 0xFE, 0xDF, 0x70, 0x10, 0xAF, 0xA7, 0x20, 0x30, 0xAE,
  0x0D, 0x75, 0x84, 0x59, 0xBE, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_phone_callback() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_phone_callback_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_phone_forwarded 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_24_notification_phone_forwarded_data[] PROGMEM = {
  0x77, 0x10, 0x27, 0x75, 0x90, 0x73, 0x04, 0x0D, 0xA0, 0xC0, 0x27, 0x2A, 0x07, 0x20, 0xDC, 0x0A,
  0x50, 0xEE, 0x81, 0x70, 0xDC, 0x0C, 0x5F, 0x90, 0x70, 0xBC, 0x0E, 0x5F, 0x90, 0x70, 0x9D, 0x50,
  0xEE, 0x81, 0x70, 0x5C, 0x0B, 0x72, 0xA0, 0x73, 0xB0, 0xC0, 0x17, 0x29, 0x07, 0x48, 0x2A, 0xFD,
  0x17, 0x30, 0x25, 0x82, 0x3F, 0xE1, 0x77, 0x38, 0x1A, 0xFA, 0x77, 0x38, 0x21, 0xEF, 0x67, 0x73,
  0x04, 0xA0, 0x57, 0x73, 0x07, 0xA0, 0x63, 0x85, 0x1B, 0xFE, 0xCA, 0x27, 0x07, 0xA8, 0x2A, 0x11,
  0xCD, 0x0C, 0x71, 0x83, 0x4E, 0xFE, 0xDF, 0x72, 0x01, 0x0A, 0xFA, 0x74, 0x03, 0x0A, 0xE0, 0xD7,
  0x78, 0x45, 0x9B, 0xED, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_phone_forwarded() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_phone_forwarded_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_phone_in_talk 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_24_notification_phone_in_talk_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xC0, 0x23, 0x82, 0xAD, 0x94, 0x50, 0xDC, 0x0A, 0x30, 0xBB, 0x0B, 0x02, 0x30,
  0xDC, 0x0C, 0x48, 0x42, 0x7D, 0xFE, 0x32, 0x0B, 0xC0, 0xE7, 0x84, 0xAF, 0xE2, 0x09, 0xD3, 0x81,
  0x8B, 0x42, 0x83, 0xAF, 0xB0, 0x5C, 0x0B, 0x30, 0xCA, 0x07, 0x28, 0x1D, 0xF4, 0x1B, 0x0C, 0x01,
  0x40, 0x6A, 0x89, 0x04, 0x07, 0xF9, 0x0A, 0xFD, 0x16, 0x89, 0x26, 0xFB, 0x02, 0xFD, 0x03, 0xFE,
  0x17, 0x0C, 0x09, 0x20, 0xB0, 0xA2, 0x81, 0xAF, 0xA7, 0x71, 0x82, 0x1E, 0xF6, 0x77, 0x10, 0x4A,
  0x05, 0x77, 0x10, 0x7A, 0x06, 0x38, 0x51, 0xBF, 0xEC, 0xA2, 0x50, 0x7A, 0x82, 0xA1, 0x1C, 0xD0,
  0xC6, 0x83, 0x4E, 0xFE, 0xDF, 0x70, 0x10, 0xAF, 0xA7, 0x20, 0x30, 0xAE, 0x0D, 0x75, 0x84, 0x59,
  0xBE, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_phone_in_talk() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_phone_in_talk_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_phone_locked 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_24_notification_phone_locked_data[] PROGMEM = {
  0x76, 0x84, 0x4D, 0xD4, 0x0B, 0xC0, 0xD7, 0x84, 0xD3, 0x3D, 0x0E, 0xD0, 0x46, 0x92, 0x91, 0x0C,
  0xD0, 0x75, 0x0B, 0xC0, 0xB0, 0xAD, 0x0A, 0x5E, 0x06, 0xD0, 0xD5, 0xE0, 0x2D, 0x07, 0x5E, 0x10,
  0xBB, 0x07, 0x60, 0xBC, 0x81, 0xB0, 0x5A, 0x07, 0x77, 0x18, 0x1C, 0xF7, 0x77, 0x10, 0x3A, 0x03,
  0x77, 0x18, 0x28, 0xFD, 0x17, 0x71, 0x82, 0xBF, 0xC1, 0x48, 0x36, 0xDA, 0x74, 0x58, 0x31, 0xCF,
  0xD3, 0x20, 0x7D, 0x0D, 0x50, 0x10, 0xBA, 0x00, 0x7F, 0x70, 0x8F, 0xB7, 0x10, 0x30, 0xCF, 0x97,
  0x30, 0x50, 0xBE, 0x75, 0x84, 0x16, 0xAC, 0xEB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_phone_locked() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_phone_locked_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_phone_missed 24x24, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_round_24_notification_phone_missed_data[] PROGMEM = {
  0x50, 0xBC, 0x0B, 0x58, 0x11, 0x92, 0x73, 0xD0, 0xB4, 0x82, 0x1D, 0xF7, 0x73, 0xB0, 0xC0, 0x14,
  0x82, 0x1D, 0xFB, 0x74, 0xA8, 0x2D, 0xFC, 0x12, 0x82, 0x1D, 0xFB, 0x75, 0xA8, 0x71, 0xDF, 0xC1,
  0x1D, 0xFB, 0x76, 0x89, 0x0B, 0xB0, 0x1D, 0xFC, 0xDF, 0xB7, 0x74, 0x01, 0x0D, 0xA0, 0xB7, 0x76,
  0x81, 0x1B, 0xA8, 0x0C, 0x60, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x40, 0x20, 0x9F, 0xD0,
  0x90, 0x26, 0x01, 0x0A, 0xB8, 0x2C, 0x63, 0x12, 0x82, 0x13, 0x6C, 0xB0, 0xA0, 0x13, 0x03, 0x0D,
  0xC0, 0x67, 0x10, 0x6C, 0x82, 0xD3, 0x04, 0xE0, 0x67, 0x10, 0x6E, 0x04, 0x0A, 0xE0, 0x57, 0x10,
  0x5E, 0x0A, 0x07, 0xD0, 0xD7, 0x30, 0xDD, 0x81, 0x70, 0xAB, 0x0B, 0x01, 0x73, 0x01, 0x0B, 0xB0,
  0xA3, 0x81, 0x7B, 0x77, 0x78, 0x17, 0xB7, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_phone_missed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_phone_missed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_phone_paused 24x24, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_24_notification_phone_paused_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xC0, 0x26, 0x00, 0xB2, 0x81, 0xBB, 0xDC, 0x0A, 0x6A, 0x2A, 0x0D, 0xC0, 0xC6,
  0xA2, 0xA0, 0xBC, 0x0E, 0x6A, 0x2A, 0x09, 0xD6, 0xA2, 0xA0, 0x5C, 0x0B, 0x6A, 0x2A, 0x1B, 0x0C,
  0x01, 0x60, 0x0B, 0x28, 0x5B, 0xB0, 0xAF, 0xD1, 0x77, 0x82, 0x3F, 0xE1, 0x77, 0x18, 0x1A, 0xFA,
  0x77, 0x18, 0x21, 0xEF, 0x67, 0x71, 0x04, 0xA0, 0x57, 0x71, 0x07, 0xA0, 0x63, 0x85, 0x1B, 0xFE,
  0xCA, 0x25, 0x07, 0xA8, 0x2A, 0x11, 0xCD, 0x0C, 0x68, 0x34, 0xEF, 0xED, 0xF7, 0x01, 0x0A, 0xFA,
  0x72, 0x03, 0x0A, 0xE0, 0xD7, 0x58, 0x45, 0x9B, 0xED, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_phone_paused() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_phone_paused_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_power_off 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_24_notification_power_off_data[] PROGMEM = {
  0x50, 0x0B, 0x40, 0x0B, 0x50, 0x50, 0x93, 0xA4, 0xA5, 0x81, 0xBF, 0xB2, 0x05, 0x94, 0xA5, 0x82,
  0x2D, 0xFB, 0x20, 0x54, 0xA6, 0x82, 0x2D, 0xFB, 0x20, 0x5D, 0x0D, 0x03, 0x50, 0x2A, 0x0B, 0x20,
  0x5D, 0x0D, 0x6B, 0x0B, 0x20, 0x5D, 0x6C, 0x0B, 0x20, 0x5C, 0x6D, 0x0B, 0x20, 0x5B, 0x6E, 0x0B,
  0x20, 0x5A, 0x6F, 0x0B, 0x20, 0x59, 0x60, 0xBF, 0x0B, 0x20, 0x36, 0x01, 0x0D, 0xF0, 0xB7, 0x20,
  0x10, 0xDF, 0x0B, 0x72, 0x01, 0x0D, 0xC8, 0x2D, 0xDF, 0xB7, 0x20, 0x7C, 0x83, 0x72, 0xDF, 0xB7,
  0x10, 0x7C, 0x84, 0x70, 0x2D, 0xFB, 0x70, 0x4C, 0x04, 0x28, 0x22, 0xDF, 0x57, 0x71, 0x81, 0x17,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_power_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_power_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_power 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_24_notification_power_data[] PROGMEM = {
  0x20, 0x0B, 0x40, 0x0B, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x20, 0x40, 0xDF, 0x98, 0x1D, 0x4D,
  0xFB, 0x0D, 0x80, 0xF0, 0xF0, 0xBF, 0xB8, 0x1B, 0x1D, 0xF9, 0x83, 0xD1, 0x01, 0xDE, 0x0D, 0x01,
  0x30, 0x10, 0xDC, 0x0D, 0x01, 0x50, 0x7C, 0x07, 0x60, 0x7C, 0x07, 0x60, 0x4C, 0x04, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_power() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 17, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_power_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_priority_high 24x24, 4-bit Alpha,  RLE, 23 bytes.
static const unsigned char ic_round_24_notification_priority_high_data[] PROGMEM = {
  0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0xFF, 0xFF, 0xC0, 0xDA, 0x83, 0xD4, 0xDD, 0x47, 0x18, 0x34, 0xDD,
  0x4D, 0xA0, 0x0D, 0xA8, 0x3D, 0x4D, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_priority_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 3, 13, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_priority_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_running_with_errors 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_24_notification_running_with_errors_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xCA, 0x47, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x1E, 0x08, 0x50, 0x8A, 0x06, 0x4F, 0x04, 0x30, 0x4A, 0x04, 0x5E, 0x07, 0x48, 0x1D, 0xF6, 0x6D,
  0x07, 0x48, 0x15, 0xFC, 0x7C, 0x07, 0x58, 0x19, 0xF6, 0x7B, 0x07, 0x68, 0x1D, 0xF2, 0x7A, 0x07,
  0x58, 0x1B, 0xBE, 0x97, 0x19, 0x07, 0x6A, 0x0E, 0x97, 0x10, 0x77, 0xA8, 0x1D, 0xF2, 0x77, 0x1A,
  0x81, 0x9F, 0x67, 0x71, 0xA8, 0x15, 0xFC, 0x77, 0x1A, 0x18, 0x1D, 0xF6, 0x77, 0xA1, 0x04, 0xA0,
  0x47, 0x30, 0x42, 0x00, 0xB2, 0x08, 0xA0, 0x67, 0x10, 0x69, 0x70, 0x8A, 0x81, 0xC6, 0x22, 0x81,
  0x26, 0xCA, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x20, 0x0B, 0x68, 0x65, 0x9D, 0xEF, 0xDA, 0x54,
  0x00, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_running_with_errors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_running_with_errors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sd_card_alert 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_notification_sd_card_alert_data[] PROGMEM = {
  0x50, 0x60, 0xEF, 0x0D, 0x04, 0x40, 0x7F, 0xB0, 0xD3, 0x07, 0xFD, 0x20, 0x7F, 0xE1, 0x07, 0xFF,
  0x06, 0xFF, 0x90, 0xEE, 0x00, 0x3F, 0xF2, 0xFF, 0x2F, 0xF2, 0xFF, 0x00, 0x38, 0x0D, 0x2F, 0x2F,
  0xF2, 0x80, 0xE3, 0xF0, 0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sd_card_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_sd_card_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sd_card 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_24_notification_sd_card_data[] PROGMEM = {
  0x50, 0x60, 0xEF, 0x0D, 0x04, 0x40, 0x7F, 0xB0, 0xD3, 0x07, 0xA8, 0x63, 0x3F, 0x33, 0xF3, 0x3A,
  0x20, 0x7B, 0x29, 0x29, 0x2A, 0x10, 0x7C, 0x29, 0x29, 0x2A, 0x06, 0xD8, 0x63, 0x3F, 0x33, 0xF3,
  0x3A, 0x0E, 0x80, 0xAF, 0x3F, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sd_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_sd_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sim_card_alert 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_24_notification_sim_card_alert_data[] PROGMEM = {
  0x50, 0x60, 0xEF, 0x0D, 0x04, 0x40, 0x7F, 0xB0, 0xD3, 0x07, 0xFD, 0x20, 0x7F, 0xE1, 0x07, 0xFF,
  0x06, 0xFF, 0x90, 0xEE, 0x00, 0x3F, 0xF2, 0xFF, 0x2F, 0xF2, 0xFF, 0x00, 0x38, 0x0D, 0x2F, 0x00,
  0x3F, 0xF0, 0x03, 0x80, 0xE3, 0xF0, 0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sim_card_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_sim_card_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sms_failed 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_24_notification_sms_failed_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x5F, 0x00, 0x3F, 0xFC, 0x2F, 0xFC,
  0x2F, 0xFC, 0x00, 0x38, 0x0E, 0x6F, 0x2F, 0xFC, 0x28, 0x09, 0x80, 0xF0, 0xDF, 0xFC, 0x0D, 0x04,
  0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sms_failed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_sms_failed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sms 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_24_notification_sms_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x09, 0xC5, 0xF2, 0xA2, 0xA2, 0xFB, 0x2A,
  0x2A, 0x28, 0x09, 0xF0, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x90,
  0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_sms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_support_agent 24x24, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_round_24_notification_support_agent_data[] PROGMEM = {
  0x68, 0x64, 0x9D, 0xEE, 0xD9, 0x47, 0x30, 0x20, 0xBB, 0x00, 0xEB, 0x0B, 0x02, 0x78, 0x43, 0xEF,
  0xD6, 0x12, 0x84, 0x16, 0xDF, 0xE3, 0x58, 0x96, 0x2E, 0xFA, 0x06, 0xAE, 0xEC, 0x70, 0x9F, 0xE2,
  0x48, 0x6B, 0xFA, 0x1C, 0xF8, 0x7B, 0x83, 0xD2, 0x9F, 0xB3, 0x83, 0x3F, 0xE1, 0xCA, 0x81, 0x30,
  0xAB, 0x83, 0xD1, 0xDF, 0x32, 0x82, 0x8F, 0x86, 0xA0, 0x93, 0x08, 0xB8, 0x27, 0x7F, 0x82, 0x84,
  0xCF, 0x3B, 0xFB, 0x58, 0x51, 0x8C, 0xC2, 0xFC, 0x28, 0x3E, 0xF1, 0xE9, 0x74, 0x98, 0x1E, 0x04,
  0xA1, 0x82, 0x20, 0xBB, 0x40, 0x0B, 0x3A, 0x05, 0x0D, 0xA3, 0x00, 0xB4, 0x00, 0xB3, 0xA0, 0xDB,
  0x77, 0xE7, 0x7B, 0x0D, 0xA7, 0x7A, 0x82, 0xD4, 0xDB, 0x77, 0xA0, 0x57, 0x73, 0xA7, 0x30, 0xBF,
  0x90, 0xD7, 0x30, 0xBF, 0x0D, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_support_agent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_support_agent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sync_disabled 24x24, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_round_24_notification_sync_disabled_data[] PROGMEM = {
  0x02, 0x07, 0x30, 0x20, 0x34, 0xD8, 0x22, 0x9F, 0xB2, 0x06, 0x0E, 0x4C, 0x84, 0x70, 0x2D, 0xFB,
  0x20, 0x34, 0xB0, 0xD3, 0x82, 0x2E, 0xFB, 0x6A, 0x81, 0xEF, 0x82, 0x01, 0xB0, 0xB5, 0x90, 0x70,
  0x2A, 0x86, 0x20, 0x8F, 0xAD, 0xFB, 0x40, 0x22, 0x89, 0x18, 0xF8, 0x0C, 0xF3, 0x2D, 0xFB, 0x68,
  0x92, 0x3F, 0xC0, 0xEF, 0x10, 0x2D, 0xFB, 0x69, 0x81, 0xE0, 0xE9, 0x38, 0x22, 0xDF, 0xB5, 0x98,
  0x3E, 0x0C, 0xF3, 0x38, 0x22, 0xDF, 0xB3, 0x85, 0x3F, 0xC0, 0x8F, 0x82, 0x84, 0x20, 0x2D, 0xFB,
  0x28, 0x34, 0xF8, 0x02, 0xA0, 0x20, 0x79, 0x28, 0x22, 0xDF, 0xB2, 0x06, 0x02, 0x28, 0x18, 0xFE,
  0xA3, 0x82, 0x2D, 0xFB, 0x60, 0xDB, 0x40, 0x8A, 0x0B, 0x40, 0x7C, 0x48, 0x3E, 0xFE, 0xFB, 0x20,
  0x2C, 0x0E, 0x48, 0x43, 0x22, 0xDF, 0x97, 0x78, 0x12, 0xC7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sync_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 19, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_sync_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sync_lock 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_24_notification_sync_lock_data[] PROGMEM = {
  0x40, 0x02, 0x40, 0xBC, 0x0B, 0x48, 0x18, 0xFE, 0x4D, 0x0B, 0x30, 0xAA, 0x07, 0x4B, 0x0B, 0x48,
  0x28, 0xFE, 0x35, 0xA8, 0x1E, 0xF8, 0x20, 0x1A, 0x03, 0x6A, 0x03, 0xA8, 0x32, 0x08, 0xF9, 0x78,
  0x90, 0xBB, 0x09, 0xF8, 0x0C, 0xF3, 0x73, 0x85, 0x3F, 0xC0, 0xEF, 0x17, 0x49, 0x81, 0xE0, 0xE9,
  0x77, 0x18, 0x1C, 0xF3, 0x77, 0x84, 0x8F, 0x90, 0xBB, 0x68, 0x44, 0xDD, 0x40, 0x2A, 0x03, 0xA6,
  0x82, 0xD3, 0x3D, 0x28, 0x18, 0xFE, 0xA6, 0x92, 0x93, 0x0B, 0xB5, 0x0B, 0xC0, 0x0B, 0xD5, 0xE0,
  0xBC, 0x0B, 0x5E, 0x74, 0xE7, 0x40, 0xBC, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sync_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_sync_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sync 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_24_notification_sync_data[] PROGMEM = {
  0x70, 0x27, 0x70, 0x79, 0x76, 0x07, 0xA7, 0x50, 0x7B, 0x82, 0xEC, 0x82, 0x71, 0x07, 0xF0, 0x97,
  0x10, 0x7A, 0x10, 0x30, 0x8A, 0x0B, 0x71, 0x07, 0x93, 0x86, 0x2D, 0xF9, 0x01, 0x71, 0x40, 0x24,
  0x02, 0xA8, 0x22, 0x8F, 0x67, 0x38, 0x48, 0xF8, 0xCF, 0x37, 0x38, 0x23, 0xFC, 0xE9, 0x75, 0x90,
  0x0E, 0x97, 0x59, 0x82, 0xEC, 0xF3, 0x73, 0x84, 0x3F, 0xC8, 0xF8, 0x73, 0x82, 0x6F, 0x82, 0xA0,
  0x24, 0x02, 0x48, 0x61, 0x71, 0x09, 0xFD, 0x23, 0x90, 0x77, 0x10, 0xBA, 0x08, 0x03, 0x1A, 0x07,
  0x71, 0x09, 0xF0, 0x77, 0x18, 0x22, 0x8C, 0xEB, 0x07, 0x75, 0xA0, 0x77, 0x69, 0x07, 0x77, 0x02,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sync() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_sync_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_sync_problem 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_24_notification_sync_problem_data[] PROGMEM = {
  0x40, 0x20, 0x36, 0x0E, 0xC0, 0x23, 0x81, 0x7F, 0xE6, 0xC0, 0x73, 0x0A, 0xA0, 0x76, 0xB0, 0xD3,
  0x82, 0x8F, 0xE3, 0x30, 0x0B, 0x2A, 0x83, 0xEF, 0x80, 0x1A, 0x03, 0x4A, 0x29, 0x07, 0x02, 0xA8,
  0x22, 0x8F, 0x95, 0xA2, 0x02, 0x28, 0x48, 0xF8, 0xCF, 0x35, 0xA5, 0x84, 0x3F, 0xCE, 0xF1, 0x5A,
  0x69, 0x00, 0xE9, 0x60, 0x0B, 0x58, 0x41, 0xFE, 0xCF, 0x37, 0x58, 0x43, 0xFC, 0x8F, 0x82, 0x02,
  0x72, 0x82, 0x9F, 0x82, 0xA0, 0x20, 0x79, 0x2A, 0x40, 0x3A, 0x83, 0x10, 0x8F, 0xEA, 0x2A, 0x38,
  0x23, 0xEF, 0x83, 0x0D, 0xB6, 0x07, 0xA0, 0xA3, 0x07, 0xC6, 0x81, 0xEF, 0x73, 0x02, 0xC0, 0xE6,
  0x03, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_sync_problem() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_sync_problem_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_system_update 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_24_notification_system_update_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC4, 0x00,
  0xB4, 0xC4, 0xA4, 0xC4, 0xA4, 0xC4, 0xA4, 0xC4, 0xA4, 0xC1, 0x02, 0xE0, 0x21, 0xC2, 0x07, 0xC0,
  0x72, 0xC3, 0x07, 0xA0, 0x73, 0xC4, 0x00, 0x74, 0xC7, 0x3C, 0x73, 0xFF, 0xFF, 0xA0, 0xDF, 0xD8,
  0x1D, 0x4D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_system_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_system_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_tap_and_play 24x24, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_24_notification_tap_and_play_data[] PROGMEM = {
  0x30, 0x40, 0xDF, 0xB0, 0xD0, 0x43, 0x0D, 0xFD, 0x0D, 0x3F, 0xF3, 0xFF, 0x3A, 0x73, 0xA3, 0xA7,
  0x3A, 0x3A, 0x73, 0xA3, 0xA7, 0x3A, 0x3A, 0x73, 0xA3, 0x08, 0x0D, 0x73, 0xA7, 0x71, 0xA8, 0x2A,
  0xDA, 0x67, 0x4A, 0x0B, 0xB0, 0xE0, 0x77, 0x2A, 0x18, 0x12, 0x5B, 0xA0, 0xC0, 0x17, 0xA4, 0x83,
  0x3D, 0xFD, 0x16, 0xA8, 0x7A, 0xC7, 0x10, 0x1B, 0xFC, 0x6A, 0x0C, 0xA8, 0x5E, 0x40, 0x1D, 0xF7,
  0x5A, 0x10, 0x40, 0xBA, 0x83, 0x40, 0x3F, 0xE2, 0x0D, 0xC3, 0x89, 0x07, 0xFE, 0x10, 0xBF, 0x60,
  0x8C, 0x0D, 0x08, 0x28, 0x7B, 0xF7, 0x05, 0xFA, 0x04, 0xB0, 0xDA, 0x89, 0x18, 0x04, 0xFC, 0x02,
  0xFD, 0x02, 0xA0, 0xD0, 0x4A, 0x0D, 0x20, 0xC0, 0xA2, 0x00, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_tap_and_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_tap_and_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_time_to_leave 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_24_notification_time_to_leave_data[] PROGMEM = {
  0x20, 0x70, 0xEF, 0xB0, 0xE0, 0x73, 0x81, 0x1F, 0xC8, 0x06, 0x78, 0x1C, 0xF1, 0x28, 0x16, 0xF2,
  0x73, 0x81, 0x2F, 0x62, 0x00, 0xC7, 0x58, 0x4C, 0xC0, 0x2F, 0x77, 0x58, 0x47, 0xF2, 0x7F, 0x27,
  0x58, 0x22, 0xF7, 0xCF, 0xFA, 0x0C, 0xFF, 0xE8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x7C, 0x3F, 0x93,
  0xC8, 0x17, 0x07, 0xF9, 0x81, 0x70, 0x78, 0x0E, 0x7F, 0x75, 0xB8, 0x18, 0xE8, 0x75, 0x81, 0x8E,
  0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_time_to_leave() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_time_to_leave_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_tv_off 24x24, 4-bit Alpha,  RLE, 126 bytes.
static const unsigned char ic_round_24_notification_tv_off_data[] PROGMEM = {
  0x60, 0x40, 0x76, 0x07, 0x04, 0x60, 0x10, 0x54, 0x81, 0x1C, 0x74, 0x81, 0x7C, 0x16, 0x81, 0x7F,
  0xB4, 0x81, 0x1C, 0x72, 0x81, 0x7C, 0x17, 0x82, 0x1D, 0xFB, 0x48, 0x41, 0xC7, 0x7C, 0x17, 0x10,
  0x40, 0xEA, 0x0B, 0x20, 0x5F, 0xD8, 0x1D, 0x4D, 0xC0, 0xB2, 0x05, 0xFD, 0x0D, 0xA8, 0x33, 0x2D,
  0xFB, 0x75, 0x03, 0xC2, 0x82, 0x2D, 0xFB, 0x75, 0xC3, 0x82, 0x2D, 0xFB, 0x74, 0xC4, 0x82, 0x2D,
  0xFB, 0x73, 0xC5, 0x82, 0x2D, 0xFB, 0x72, 0xC6, 0x82, 0x2D, 0xFB, 0x71, 0xC7, 0x82, 0x2D, 0xFB,
  0x7C, 0x71, 0x82, 0x2D, 0xFB, 0x6C, 0x72, 0x82, 0x2D, 0xFB, 0x5C, 0x73, 0x82, 0x2D, 0xFB, 0x4C,
  0x74, 0x82, 0x2D, 0xFB, 0x3C, 0x03, 0x74, 0x82, 0x2D, 0xFB, 0x28, 0x15, 0xFD, 0xFF, 0xB0, 0xB2,
  0x81, 0x44, 0xDF, 0xFB, 0x0B, 0x77, 0x58, 0x22, 0xDF, 0x57, 0x75, 0x81, 0x17, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_tv_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_notification_tv_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_vibration 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_24_notification_vibration_data[] PROGMEM = {
  0x60, 0x8F, 0xB0, 0x87, 0x5F, 0xD7, 0x5A, 0x71, 0xA7, 0x5A, 0x71, 0xA7, 0x20, 0x0B, 0x1A, 0x71,
  0xA1, 0x00, 0xB6, 0xA1, 0xA7, 0x1A, 0x1A, 0x30, 0x0B, 0x1A, 0x1A, 0x71, 0xA1, 0xA1, 0x00, 0xBA,
  0x1A, 0x1A, 0x71, 0xA1, 0xA1, 0xC1, 0xA1, 0xA7, 0x1A, 0x1A, 0x1C, 0x1A, 0x1A, 0x71, 0xA1, 0xA1,
  0xC1, 0xA1, 0xA7, 0x1A, 0x1A, 0x1A, 0x00, 0xB1, 0xA1, 0xA7, 0x1A, 0x1A, 0x10, 0x0B, 0x3A, 0x1A,
  0x71, 0xA1, 0xA6, 0x00, 0xB1, 0xA7, 0x1A, 0x10, 0x0B, 0x72, 0xA7, 0x1A, 0x75, 0xA7, 0x1A, 0x75,
  0xFD, 0x75, 0x08, 0xFB, 0x08, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_vibration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_vibration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_video_chat 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_notification_video_chat_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x1F, 0x03, 0x60, 0x3F, 0xD7, 0x19,
  0x0C, 0xFB, 0x71, 0x07, 0x1F, 0xB7, 0x3F, 0xB7, 0x3F, 0xB7, 0x10, 0x71, 0xFB, 0x71, 0x90, 0xCF,
  0xB0, 0x36, 0x03, 0x80, 0xF6, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73,
  0x00, 0x57, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_video_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_notification_video_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_voice_chat 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_24_notification_voice_chat_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x0F, 0x03, 0x60, 0x3F, 0xD7, 0x19,
  0x81, 0xD4, 0x5F, 0x97, 0x10, 0xC0, 0x12, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x71, 0x0C, 0x01, 0x2F,
  0x97, 0x19, 0x81, 0xD4, 0x5F, 0x90, 0x36, 0x03, 0x80, 0xF7, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0,
  0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_voice_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_voice_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_vpn_lock 24x24, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_round_24_notification_vpn_lock_data[] PROGMEM = {
  0x77, 0x28, 0x24, 0xDD, 0x47, 0x85, 0x59, 0xDE, 0xFD, 0xA3, 0x82, 0xD3, 0x3D, 0x50, 0x40, 0xDF,
  0x39, 0x29, 0x40, 0x8F, 0xA2, 0x0B, 0xC0, 0xB2, 0x08, 0xFA, 0x0D, 0x2E, 0x10, 0x4F, 0xA0, 0xD0,
  0x42, 0xE1, 0x0D, 0xF6, 0xE0, 0x5F, 0x96, 0x0B, 0xC0, 0xB0, 0x9F, 0x0B, 0x75, 0x81, 0xDF, 0xAB,
  0x77, 0x18, 0x2E, 0xF0, 0x7A, 0x75, 0x98, 0x1E, 0x0E, 0x92, 0x07, 0xF0, 0xB5, 0x98, 0x3E, 0x0D,
  0xF2, 0x20, 0x7F, 0x48, 0x52, 0xFD, 0x09, 0xF6, 0x30, 0x7E, 0x48, 0x56, 0xF9, 0x05, 0xFC, 0x4E,
  0x48, 0x1C, 0xF5, 0x28, 0x1D, 0xF6, 0x30, 0xDE, 0x83, 0xD4, 0x6F, 0xD3, 0x04, 0xA0, 0x42, 0x04,
  0x0D, 0xE8, 0x2E, 0xEF, 0x44, 0x08, 0xA0, 0x63, 0xF9, 0x08, 0x60, 0x8A, 0x81, 0xC6, 0x2F, 0x08,
  0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x74, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_vpn_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_vpn_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_wc 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_24_notification_wc_data[] PROGMEM = {
  0x28, 0x1A, 0xEA, 0x68, 0x1A, 0xEA, 0x40, 0x6B, 0x06, 0x40, 0x6B, 0x06, 0x30, 0x6B, 0x06, 0x40,
  0x6B, 0x06, 0x48, 0x1A, 0xEA, 0x68, 0x1A, 0xEA, 0x77, 0x60, 0x40, 0xDB, 0x0D, 0x04, 0x48, 0x1A,
  0xFA, 0x30, 0xDD, 0x0D, 0x30, 0x7B, 0x07, 0x2F, 0x30, 0xCB, 0x0C, 0x2F, 0x20, 0x2D, 0x02, 0x1F,
  0x20, 0x7D, 0x07, 0x1F, 0x20, 0xCD, 0x0C, 0x1F, 0x10, 0x2F, 0x81, 0x24, 0xBB, 0x82, 0xB4, 0x07,
  0xF8, 0x17, 0x07, 0xB0, 0x72, 0x06, 0xF8, 0x15, 0x07, 0xB0, 0x75, 0xB4, 0x07, 0xB0, 0x75, 0xB4,
  0x07, 0xB0, 0x75, 0xB4, 0x07, 0xB0, 0x75, 0xB4, 0x07, 0xB0, 0x75, 0xB4, 0x04, 0xB0, 0x45, 0x81,
  0xBF, 0xB3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_wc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_notification_wc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_wifi_off 24x24, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_round_24_notification_wifi_off_data[] PROGMEM = {
  0x18, 0x14, 0xD4, 0x77, 0x50, 0x5A, 0x04, 0x77, 0x50, 0x8A, 0x04, 0x28, 0x53, 0x57, 0x76, 0x41,
  0x73, 0x08, 0xA8, 0x24, 0x01, 0xCD, 0x81, 0xC7, 0x16, 0x01, 0x09, 0xB8, 0x24, 0x01, 0xCF, 0x08,
  0x40, 0x40, 0xED, 0x85, 0x40, 0x15, 0x58, 0xCC, 0x82, 0xD4, 0x03, 0xB8, 0x1E, 0x88, 0xA0, 0x45,
  0x81, 0x28, 0xEB, 0x00, 0x3A, 0x0B, 0x01, 0x20, 0x8A, 0x04, 0x60, 0x20, 0xBA, 0x82, 0x30, 0x45,
  0x40, 0x30, 0xDA, 0x04, 0x20, 0x14, 0x05, 0x04, 0x60, 0x30, 0xCD, 0x83, 0x40, 0x19, 0x37, 0x20,
  0x2F, 0x98, 0x34, 0x01, 0xC2, 0x71, 0x03, 0xA8, 0x3D, 0x62, 0x08, 0xA8, 0x24, 0x01, 0x17, 0x20,
  0x40, 0x65, 0x08, 0xA0, 0x47, 0x72, 0x82, 0x22, 0x08, 0xA0, 0x47, 0x60, 0x30, 0xEA, 0x81, 0xE3,
  0x8A, 0x04, 0x75, 0x05, 0xC8, 0x14, 0x08, 0xA0, 0x47, 0x50, 0x7A, 0x07, 0x38, 0x18, 0xFD, 0x76,
  0x00, 0x55, 0x05, 0x04, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_notification_wifi 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_24_notification_wifi_data[] PROGMEM = {
  0x78, 0x61, 0x56, 0x77, 0x65, 0x17, 0x48, 0x11, 0x7C, 0xF9, 0x81, 0xD7, 0x17, 0x09, 0xFF, 0x09,
  0x01, 0x30, 0x40, 0xDC, 0x86, 0xC8, 0x65, 0x56, 0x8C, 0xC8, 0x2D, 0x40, 0x3B, 0x81, 0xE8, 0x27,
  0x18, 0x12, 0x8E, 0xB0, 0x03, 0xA0, 0xB0, 0x27, 0x50, 0x20, 0xBA, 0x82, 0x30, 0x45, 0x48, 0x63,
  0x8B, 0xDD, 0xB8, 0x34, 0x05, 0x04, 0x60, 0x30, 0xCF, 0x90, 0xC0, 0x37, 0x20, 0x2F, 0xD0, 0x27,
  0x10, 0x3A, 0x81, 0xD6, 0x22, 0x81, 0x26, 0xDA, 0x03, 0x72, 0x04, 0x06, 0x71, 0x05, 0x04, 0x77,
  0x10, 0x02, 0x77, 0x40, 0x30, 0xEA, 0x0E, 0x03, 0x77, 0x20, 0x5C, 0x04, 0x77, 0x30, 0x7A, 0x07,
  0x77, 0x50, 0x05, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_notification_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_notification_wifi_data, Alpha4(color::Black));
  return value;
}
