#include "hardware.h"

using namespace roo_display;

// Image file ic_round_24_hardware_adf_scanner 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_24_hardware_adf_scanner_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x10, 0xDF, 0xB0, 0xD7, 0x1A, 0x71, 0xA7, 0x1A, 0x71, 0xA7,
  0x1A, 0x71, 0xA7, 0x1A, 0x71, 0xA7, 0x1A, 0x71, 0xA7, 0x1A, 0x71, 0xA5, 0x08, 0x0D, 0xFF, 0x82,
  0xD8, 0x08, 0xFF, 0xC0, 0x80, 0xDF, 0xFC, 0x0D, 0xFF, 0x90, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xFA,
  0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_adf_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_adf_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_browser_not_supported 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_24_hardware_browser_not_supported_data[] PROGMEM = {
  0x10, 0x27, 0x73, 0x84, 0x8F, 0x60, 0x1D, 0xFC, 0x81, 0xD4, 0x2A, 0x82, 0x60, 0x1D, 0xFC, 0x0D,
  0x1B, 0x06, 0x75, 0xA1, 0xA8, 0x1E, 0xF6, 0x74, 0xA1, 0xA8, 0x23, 0xEF, 0x67, 0x3A, 0x1A, 0x18,
  0x23, 0xEF, 0x67, 0x2A, 0x1A, 0x28, 0x23, 0xEF, 0x67, 0x1A, 0x1A, 0x38, 0x23, 0xEF, 0x67, 0xA1,
  0xA4, 0x82, 0x3E, 0xF6, 0x6A, 0x1A, 0x58, 0x23, 0xEF, 0x65, 0xA1, 0xA6, 0x82, 0x3E, 0xF6, 0x4A,
  0x1A, 0x78, 0x23, 0xEF, 0x63, 0xA1, 0xA7, 0x18, 0x23, 0xEF, 0x62, 0x0D, 0x91, 0xA7, 0x28, 0x73,
  0xEF, 0x60, 0x1D, 0x0D, 0xFF, 0x84, 0x60, 0x10, 0x4D, 0xFF, 0x06, 0x77, 0x28, 0x23, 0xEF, 0x27,
  0x72, 0x03, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_browser_not_supported() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 20, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_browser_not_supported_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_browser_updated 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_hardware_browser_updated_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xB2, 0x00, 0xB6, 0x0D, 0xF9, 0x0B, 0x2A, 0x6A, 0x73, 0xA6, 0xA7, 0x3A, 0x6A,
  0x73, 0xA6, 0xA7, 0x3A, 0x6A, 0x73, 0xA6, 0xA7, 0x05, 0xE0, 0x53, 0xA7, 0x05, 0xE0, 0x53, 0xA7,
  0x10, 0x7C, 0x07, 0x4A, 0x72, 0x07, 0xA0, 0x73, 0x0C, 0x0B, 0xA7, 0x30, 0x05, 0x4C, 0x77, 0x2A,
  0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x44, 0x07, 0xFB, 0x07, 0x71, 0x0E, 0xFB, 0x0E,
  0x71, 0x08, 0xFB, 0x08, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_browser_updated() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_browser_updated_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_cast_connected 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_round_24_hardware_cast_connected_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4A, 0x00,
  0xB2, 0x0B, 0xFD, 0x0B, 0x2A, 0x40, 0xCF, 0xE2, 0xA5, 0x03, 0x0B, 0xFC, 0x2A, 0x82, 0xAD, 0xA6,
  0x30, 0x60, 0xEF, 0xA2, 0xA0, 0xBB, 0x0E, 0x07, 0x20, 0x30, 0xEF, 0x92, 0xA1, 0x81, 0x25, 0xBA,
  0x83, 0xC1, 0x03, 0xEF, 0x2A, 0x48, 0x53, 0xDF, 0xD1, 0x06, 0xF2, 0xA8, 0x2A, 0xC7, 0x12, 0x81,
  0xBF, 0xC2, 0x0B, 0xE2, 0xA0, 0xCA, 0x0E, 0x04, 0x28, 0x3D, 0xF7, 0x03, 0xE2, 0xA1, 0x04, 0x0B,
  0xA8, 0x34, 0x03, 0xFE, 0x20, 0xCC, 0x0B, 0x2A, 0x38, 0x67, 0xFE, 0x10, 0xBF, 0x67, 0x2A, 0x0E,
  0x08, 0x28, 0x5B, 0xF7, 0x05, 0xFA, 0x71, 0x03, 0xC8, 0x78, 0x04, 0xFC, 0x02, 0xFD, 0x20, 0xBF,
  0x0D, 0xA0, 0xE2, 0x0C, 0x0A, 0x20, 0xB0, 0xA2, 0x0B, 0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_cast_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_cast_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_cast_for_education 24x24, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_round_24_hardware_cast_for_education_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x73, 0x81, 0x7C,
  0x75, 0xA0, 0x0B, 0x71, 0x05, 0x0D, 0xB0, 0xD0, 0x53, 0xA7, 0x10, 0x20, 0xCF, 0x0C, 0x02, 0x1A,
  0x71, 0x02, 0x0C, 0xF0, 0xC0, 0x21, 0xA8, 0x2A, 0xDA, 0x66, 0x05, 0x0D, 0xB0, 0xD0, 0x53, 0xA0,
  0xBB, 0x0E, 0x07, 0x48, 0x59, 0x27, 0xC7, 0x29, 0x3A, 0x18, 0x12, 0x5B, 0xA0, 0xC0, 0x12, 0x85,
  0xEF, 0x83, 0x8F, 0xE3, 0xA4, 0x86, 0x3D, 0xFD, 0x10, 0x4D, 0xB0, 0xD0, 0x43, 0xA8, 0x2A, 0xC7,
  0x12, 0x81, 0xBF, 0xC3, 0x81, 0x7C, 0x75, 0xA0, 0xCA, 0x0E, 0x04, 0x28, 0x1D, 0xF7, 0x73, 0xA1,
  0x04, 0x0B, 0xA8, 0x34, 0x03, 0xFE, 0x73, 0xA3, 0x86, 0x7F, 0xE1, 0x0B, 0xF6, 0x72, 0xA0, 0xD0,
  0x82, 0x85, 0xBF, 0x70, 0x5F, 0xA7, 0x10, 0x3C, 0x87, 0x80, 0x4F, 0xC0, 0x2F, 0xD2, 0x0B, 0xF0,
  0xDA, 0x0D, 0x20, 0xC0, 0xA2, 0x0B, 0x0A, 0x20, 0xBE, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_cast_for_education() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_cast_for_education_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_cast 24x24, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_round_24_hardware_cast_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4A, 0x00,
  0xB7, 0x74, 0xA7, 0x76, 0xA7, 0x76, 0xA8, 0x2A, 0xDA, 0x67, 0x72, 0xA0, 0xBB, 0x0E, 0x07, 0x77,
  0xA1, 0x81, 0x25, 0xBA, 0x0C, 0x01, 0x75, 0xA4, 0x83, 0x3D, 0xFD, 0x17, 0x4A, 0x82, 0xAC, 0x71,
  0x28, 0x1B, 0xFC, 0x74, 0xA0, 0xCA, 0x0E, 0x04, 0x28, 0x1D, 0xF7, 0x73, 0xA1, 0x04, 0x0B, 0xA8,
  0x34, 0x03, 0xFE, 0x73, 0xA3, 0x86, 0x7F, 0xE1, 0x0B, 0xF6, 0x72, 0xA0, 0xD0, 0x82, 0x85, 0xBF,
  0x70, 0x5F, 0xA7, 0x10, 0x3C, 0x87, 0x80, 0x4F, 0xC0, 0x2F, 0xD2, 0x0B, 0xF0, 0xDA, 0x0D, 0x20,
  0xC0, 0xA2, 0x0B, 0x0A, 0x20, 0xBE, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_cast() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_cast_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_computer 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_24_hardware_computer_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x40, 0xDF, 0xFC, 0x0D, 0x4A, 0x03, 0x77, 0x03, 0xA4, 0xA7,
  0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72,
  0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA0, 0x37, 0x70, 0x3A, 0x40, 0xDF, 0xFC, 0x0D, 0x40,
  0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x20, 0xBF, 0xFF, 0x90, 0x0B, 0xFF, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_computer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_computer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_connected_tv 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_24_hardware_connected_tv_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x18,
  0x2B, 0xC8, 0x27, 0x4C, 0x18, 0x36, 0xAE, 0xF9, 0x73, 0xC4, 0x81, 0x8F, 0xB7, 0x2C, 0x18, 0x5B,
  0xA4, 0x05, 0xF9, 0x71, 0xC1, 0x86, 0x6D, 0xF7, 0x08, 0xF2, 0x7C, 0x38, 0x49, 0xF4, 0x1E, 0x87,
  0xC1, 0x86, 0xD4, 0x0D, 0xB0, 0xAC, 0x7C, 0x19, 0x85, 0xD0, 0x6B, 0x06, 0xB7, 0xC7, 0x72, 0xA0,
  0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04, 0x6F, 0x97, 0x50, 0xBE, 0x0B, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_connected_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_connected_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_desktop_mac 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_24_hardware_desktop_mac_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x48, 0x0D,
  0x2F, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x47, 0x10, 0x5C, 0x05, 0x77, 0x10, 0x10,
  0xEC, 0x0E, 0x01, 0x77, 0x09, 0xE0, 0x97, 0x70, 0x8E, 0x08, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_desktop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_desktop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_desktop_windows 24x24, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_24_hardware_desktop_windows_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77,
  0x4C, 0x03, 0x77, 0x20, 0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x47, 0x2C, 0x77,
  0x4C, 0x77, 0x20, 0xBE, 0x0B, 0x77, 0x0B, 0xE0, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_desktop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_desktop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_developer_board_off 24x24, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_round_24_hardware_developer_board_off_data[] PROGMEM = {
  0x03, 0x04, 0x77, 0x58, 0x1C, 0xF7, 0x20, 0xAF, 0xC0, 0xD0, 0x42, 0x05, 0xA0, 0x72, 0x0A, 0xFC,
  0x0D, 0x3B, 0x07, 0x75, 0xA3, 0xC0, 0x77, 0x4A, 0x3A, 0x05, 0xA0, 0x72, 0x81, 0x60, 0xBA, 0x0B,
  0x2B, 0x0B, 0x1A, 0x10, 0x5A, 0x07, 0x3C, 0x2B, 0x0B, 0x1A, 0x2B, 0x07, 0x20, 0xAA, 0x0B, 0x2A,
  0x3A, 0x2C, 0x07, 0x7A, 0x3A, 0x20, 0xBC, 0x07, 0x20, 0xA0, 0xB2, 0xB0, 0xB1, 0xA5, 0x05, 0xA0,
  0x72, 0x0A, 0x2B, 0x0B, 0x1A, 0x20, 0xBE, 0x07, 0x4A, 0x3A, 0x2D, 0x05, 0xA0, 0x73, 0xA3, 0xA2,
  0xD1, 0xB0, 0x72, 0x0A, 0xA0, 0xB1, 0xA2, 0x0B, 0xB8, 0x1B, 0x0B, 0xB0, 0x72, 0x81, 0xAF, 0xB1,
  0xA7, 0x30, 0x5A, 0x07, 0x5A, 0x74, 0x05, 0xA0, 0x74, 0x0D, 0xFF, 0xA0, 0x73, 0x04, 0x0D, 0xFF,
  0xA0, 0x77, 0x74, 0x05, 0xA0, 0x47, 0x74, 0x81, 0x5C, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_developer_board_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_developer_board_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_developer_board 24x24, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_24_hardware_developer_board_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x0D, 0x04, 0x20, 0xDF, 0xFA, 0x0D, 0x2A, 0x03, 0x75, 0x03, 0xA2, 0xA7, 0x7A,
  0x2A, 0x20, 0xEB, 0x81, 0xE0, 0xEA, 0x0E, 0x2B, 0x0B, 0xA2, 0xD1, 0xC2, 0xB0, 0xBA, 0x2D, 0x10,
  0xEA, 0x0E, 0x2A, 0x2A, 0x2D, 0x7A, 0x2A, 0x20, 0xEB, 0x81, 0xE0, 0xEA, 0x0E, 0x2B, 0x0B, 0xA7,
  0x1C, 0x2B, 0x0B, 0xA2, 0x0E, 0xB0, 0xE1, 0xC2, 0xA2, 0xA2, 0xD1, 0xC2, 0xA2, 0xA2, 0xD1, 0xC2,
  0xB0, 0xBA, 0x20, 0xEB, 0x81, 0xE0, 0xEA, 0x0E, 0x2B, 0x0B, 0xA7, 0x7A, 0x2A, 0x03, 0x75, 0x03,
  0xA2, 0x0D, 0xFF, 0xA0, 0xD2, 0x04, 0x0D, 0xFF, 0x0D, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_developer_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_developer_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_device_hub 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_hardware_device_hub_data[] PROGMEM = {
  0x78, 0x28, 0xDE, 0x87, 0x60, 0x8C, 0x08, 0x75, 0x0D, 0xC0, 0xE7, 0x50, 0xEC, 0x0E, 0x75, 0x08,
  0xC0, 0x87, 0x60, 0x8A, 0x08, 0x77, 0x1A, 0x77, 0x2A, 0x77, 0x2A, 0x77, 0x10, 0x7A, 0x07, 0x76,
  0x07, 0xC0, 0x77, 0x40, 0x7A, 0x00, 0x4A, 0x07, 0x72, 0x07, 0xA0, 0x52, 0x05, 0xA0, 0x74, 0x0B,
  0xD0, 0x54, 0x05, 0xD0, 0xBD, 0x06, 0x60, 0x6F, 0xB7, 0x1F, 0xB7, 0x1D, 0x0B, 0xB0, 0xB7, 0x10,
  0xBB, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_device_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_device_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_devices_other 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_24_hardware_devices_other_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xB0, 0xB2, 0x0D, 0xFF, 0xC0, 0xB2, 0xA0, 0x37, 0x75, 0xA7, 0x76, 0xA7, 0x50,
  0xAE, 0x0A, 0xA7, 0x5F, 0xB7, 0x5A, 0x4C, 0x75, 0xA4, 0xC6, 0x0B, 0xA0, 0xB2, 0xA4, 0xC6, 0xC2,
  0xA4, 0xC5, 0x84, 0x8F, 0x99, 0xF8, 0x1A, 0x4C, 0x50, 0xD0, 0x92, 0x09, 0x0D, 0x1A, 0x4C, 0x50,
  0xD0, 0x92, 0x09, 0x0D, 0x1A, 0x4C, 0x03, 0x48, 0x48, 0xF9, 0x9F, 0x81, 0xA4, 0xA0, 0xDC, 0x0B,
  0x2C, 0x2F, 0x90, 0x40, 0xDB, 0x0B, 0x20, 0xBA, 0x0B, 0x20, 0xAE, 0x0A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_devices_other() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_devices_other_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_device_unknown 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_24_hardware_device_unknown_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC4, 0x00, 0x34, 0xC2, 0x03,
  0x0D, 0xA0, 0xD0, 0x32, 0xC1, 0x86, 0x1E, 0xF8, 0x8F, 0xE1, 0x1C, 0x18, 0x14, 0xF6, 0x28, 0x17,
  0xF6, 0x1C, 0x20, 0x23, 0x81, 0x5F, 0x71, 0xC5, 0x82, 0x1D, 0xE2, 0x1C, 0x48, 0x21, 0xEE, 0x42,
  0xC4, 0x81, 0xAF, 0x53, 0xC4, 0x07, 0x09, 0x4C, 0x73, 0xC4, 0xA4, 0xC4, 0xA4, 0xC7, 0x3F, 0xFF,
  0xFA, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_device_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_device_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_dock 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_24_hardware_dock_data[] PROGMEM = {
  0x04, 0x0D, 0xF9, 0x81, 0xD4, 0xDF, 0xB0, 0xDF, 0xFF, 0xD7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7,
  0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xFF, 0xFD, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0x90,
  0xD0, 0x47, 0x77, 0x50, 0xBE, 0x0B, 0x40, 0xBE, 0x0B, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_dock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 17, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_dock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_earbuds_battery 24x24, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_24_hardware_earbuds_battery_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x28, 0x33, 0xBE, 0xC5, 0x50, 0x0E, 0x20, 0xDA, 0x87, 0xD0, 0x2E, 0xD8, 0xBF,
  0x52, 0x0B, 0xC0, 0xBB, 0x83, 0xD0, 0x8E, 0x12, 0x0B, 0x0C, 0x2F, 0x98, 0x3D, 0x40, 0xBB, 0x30,
  0x79, 0x2F, 0x07, 0x30, 0x0B, 0x30, 0x79, 0x2F, 0x07, 0x30, 0x0B, 0x30, 0x79, 0x2F, 0x07, 0x30,
  0x0B, 0x30, 0x79, 0x2F, 0x07, 0x30, 0x0B, 0x30, 0x79, 0x2F, 0x07, 0x38, 0x3B, 0xB0, 0x4D, 0xA2,
  0xE0, 0xC0, 0xB2, 0x83, 0x1E, 0x90, 0xDB, 0x2E, 0x87, 0x5F, 0xB8, 0xDE, 0x20, 0xDA, 0x0D, 0x2E,
  0x18, 0x35, 0xCE, 0xB3, 0x28, 0x24, 0xDD, 0x42, 0x0B, 0xC0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_earbuds_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 21, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_earbuds_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_earbuds 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_24_hardware_earbuds_data[] PROGMEM = {
  0x18, 0x27, 0xDE, 0x85, 0x84, 0x4B, 0xEE, 0xB4, 0x20, 0x7C, 0x08, 0x30, 0x8E, 0x81, 0x80, 0xDC,
  0x0D, 0x20, 0x4A, 0x82, 0x71, 0x17, 0xA0, 0x4D, 0x0E, 0x28, 0x1B, 0xF7, 0x48, 0x17, 0xFB, 0xD0,
  0x82, 0x81, 0xEF, 0x14, 0x81, 0x1F, 0xEB, 0x0D, 0x07, 0x3A, 0x6C, 0x6A, 0x6C, 0x6A, 0x6C, 0x6A,
  0x6C, 0x6A, 0x6C, 0x6A, 0x6C, 0x6A, 0x6C, 0x6A, 0x30, 0x70, 0xDB, 0x81, 0xEF, 0x14, 0x81, 0x1F,
  0xE2, 0x08, 0xD8, 0x1B, 0xF7, 0x48, 0x17, 0xFB, 0x20, 0xED, 0x04, 0xA8, 0x27, 0x11, 0x7A, 0x04,
  0x20, 0xEC, 0x81, 0xD0, 0x8E, 0x08, 0x30, 0x8C, 0x07, 0x28, 0x44, 0xBE, 0xEB, 0x45, 0x82, 0x8E,
  0xD7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_earbuds() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_earbuds_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_gamepad 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_24_hardware_gamepad_data[] PROGMEM = {
  0x70, 0xBC, 0x0B, 0x77, 0xE7, 0x7E, 0x77, 0xE7, 0x7E, 0x77, 0x0D, 0xC0, 0xD7, 0x70, 0x10, 0xDA,
  0x0D, 0x01, 0x70, 0xBC, 0x89, 0x0D, 0x10, 0x1D, 0xD1, 0x01, 0xDC, 0x0B, 0xE8, 0x6D, 0x10, 0x11,
  0x01, 0xDF, 0xE0, 0xD0, 0x12, 0x01, 0x0D, 0xFF, 0x0D, 0x01, 0x20, 0x10, 0xDF, 0xE8, 0x6D, 0x10,
  0x11, 0x02, 0xDE, 0x0B, 0xC8, 0x90, 0xD1, 0x01, 0xDD, 0x10, 0x2D, 0xC0, 0xC7, 0x01, 0x0D, 0xA0,
  0xD0, 0x17, 0x70, 0xDC, 0x0D, 0x77, 0xE7, 0x7E, 0x77, 0xE7, 0x7E, 0x77, 0x0B, 0xC0, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_gamepad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_gamepad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_headphones_battery 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_24_hardware_headphones_battery_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEC, 0x67, 0x00, 0xE3, 0x89, 0x01, 0xCF, 0xC9, 0x9C, 0xFC, 0x13, 0x0B, 0xC8,
  0x3B, 0x0C, 0xE5, 0x48, 0x15, 0xEC, 0x3E, 0x81, 0x6F, 0x56, 0x81, 0x5F, 0x62, 0xE0, 0x0C, 0x71,
  0x00, 0xC2, 0xE0, 0xE0, 0x97, 0x10, 0x90, 0xE2, 0xF0, 0x77, 0x10, 0x79, 0x2F, 0x90, 0xD0, 0x44,
  0x04, 0x0D, 0xA2, 0xFA, 0x0D, 0x40, 0xDB, 0x2F, 0xB4, 0xC2, 0xE0, 0xDA, 0x0D, 0x40, 0xDA, 0x0D,
  0x2E, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x42, 0x0B, 0xC0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_headphones_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 21, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_headphones_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_headphones 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_24_hardware_headphones_data[] PROGMEM = {
  0x58, 0x64, 0x9D, 0xEE, 0xD9, 0x47, 0x10, 0x20, 0xBF, 0x90, 0xB0, 0x25, 0x84, 0x3E, 0xFE, 0x72,
  0x28, 0x42, 0x7E, 0xFE, 0x33, 0x82, 0x2E, 0xFA, 0x71, 0x82, 0xAF, 0xE2, 0x28, 0x1B, 0xFA, 0x73,
  0x85, 0xAF, 0xB0, 0x4F, 0xE7, 0x58, 0x4E, 0xF4, 0x9F, 0x77, 0x58, 0x47, 0xF9, 0xDF, 0x27, 0x58,
  0x22, 0xFD, 0xE9, 0x77, 0x90, 0xEA, 0x77, 0xE0, 0xD0, 0x46, 0x04, 0x0D, 0xFA, 0x0D, 0x60, 0xDF,
  0xC6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6E, 0x0D, 0xC0, 0xD6, 0x0D, 0xC8, 0x1D, 0x4D, 0xA0, 0xD0, 0x46,
  0x04, 0x0D, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_headphones() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_headphones_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_headset_mic 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_24_hardware_headset_mic_data[] PROGMEM = {
  0x58, 0x63, 0x9C, 0xFE, 0xC9, 0x37, 0x10, 0x10, 0xBF, 0x90, 0xB0, 0x25, 0x84, 0x2D, 0xFE, 0x72,
  0x28, 0x42, 0x7E, 0xFE, 0x33, 0x83, 0x1D, 0xFB, 0x17, 0x82, 0xAF, 0xE2, 0x28, 0x1A, 0xFB, 0x73,
  0x86, 0xAF, 0xB0, 0x2F, 0xE1, 0x74, 0x84, 0xEF, 0x48, 0xF8, 0x75, 0x84, 0x7F, 0x9C, 0xF3, 0x75,
  0x84, 0x2F, 0xDE, 0xF1, 0x76, 0x90, 0xEA, 0x77, 0xC7, 0x7E, 0x0D, 0x04, 0x60, 0x40, 0xDF, 0xA0,
  0xD6, 0x0D, 0xFC, 0x6F, 0xD6, 0xFD, 0x6E, 0x0D, 0xD6, 0xE0, 0x8C, 0x0D, 0x60, 0xDD, 0x18, 0x38,
  0xDF, 0xD4, 0x60, 0x40, 0xDC, 0x77, 0x29, 0x0D, 0x72, 0x0B, 0xF0, 0x87, 0x20, 0xBD, 0x0D, 0x08,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_headset_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_headset_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_headset_off 24x24, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_round_24_hardware_headset_off_data[] PROGMEM = {
  0x03, 0x04, 0x58, 0x64, 0x9D, 0xFE, 0xD9, 0x46, 0x81, 0xCF, 0x72, 0x01, 0x0B, 0xF9, 0x0B, 0x02,
  0x40, 0x5A, 0x07, 0x28, 0x2A, 0xE7, 0x22, 0x84, 0x27, 0xEF, 0xE3, 0x40, 0x5A, 0x07, 0x73, 0x82,
  0xAF, 0xE2, 0x40, 0x5A, 0x07, 0x73, 0x81, 0xAF, 0xB4, 0x03, 0xB0, 0x77, 0x38, 0x1E, 0xF4, 0x38,
  0x19, 0xFB, 0xA0, 0x77, 0x28, 0x17, 0xF9, 0x38, 0x2C, 0xF2, 0x5A, 0x07, 0x71, 0x81, 0x2F, 0xD3,
  0x0E, 0x92, 0x05, 0xA0, 0x77, 0x19, 0x0E, 0x3A, 0x30, 0x5A, 0x07, 0x7A, 0x3C, 0x81, 0xD4, 0x5A,
  0x07, 0x20, 0x30, 0xDC, 0x3D, 0x81, 0xD0, 0x5A, 0x07, 0x20, 0xAC, 0x3E, 0x20, 0x5A, 0x07, 0x20,
  0xAB, 0x3E, 0x30, 0x5A, 0x07, 0x20, 0xAA, 0x3E, 0x40, 0x5A, 0x07, 0x20, 0xA9, 0x3E, 0x50, 0x5A,
  0x07, 0x20, 0xA3, 0x0D, 0xC0, 0xD6, 0x0D, 0xA0, 0x75, 0x04, 0x0D, 0xA0, 0xD0, 0x46, 0x04, 0x0D,
  0xA0, 0x77, 0x74, 0x05, 0xA0, 0x77, 0x50, 0xBF, 0x90, 0x47, 0x40, 0xBE, 0x81, 0xDC, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_headset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_headset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_headset 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_24_hardware_headset_data[] PROGMEM = {
  0x58, 0x63, 0x9C, 0xFE, 0xC9, 0x37, 0x10, 0x10, 0xBF, 0x90, 0xB0, 0x25, 0x84, 0x2D, 0xFE, 0x72,
  0x28, 0x42, 0x7E, 0xFE, 0x33, 0x83, 0x1D, 0xFB, 0x17, 0x82, 0xAF, 0xE2, 0x28, 0x1A, 0xFB, 0x73,
  0x86, 0xAF, 0xB0, 0x2F, 0xE1, 0x74, 0x84, 0xEF, 0x48, 0xF8, 0x75, 0x84, 0x7F, 0x9C, 0xF3, 0x75,
  0x84, 0x2F, 0xDE, 0xF1, 0x76, 0x90, 0xEA, 0x77, 0xC7, 0x7E, 0x0D, 0x04, 0x60, 0x40, 0xDF, 0xA0,
  0xD6, 0x0D, 0xFC, 0x6F, 0xD6, 0xFD, 0x6E, 0x0D, 0xD6, 0xD0, 0xD0, 0x8C, 0x0D, 0x60, 0xDC, 0x85,
  0x80, 0x8D, 0xFD, 0x46, 0x83, 0x4D, 0xFD, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_headset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_headset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_home_max 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_24_hardware_home_max_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xC8, 0x4E, 0x1A, 0xFB, 0x17, 0x78, 0x51,
  0xBF, 0xAD, 0xF1, 0x77, 0x28, 0x11, 0xFD, 0xA7, 0x74, 0xC7, 0x74, 0xC7, 0x74, 0xC7, 0x74, 0xC7,
  0x74, 0xA8, 0x1D, 0xF1, 0x77, 0x28, 0x51, 0xFD, 0xAF, 0xB1, 0x77, 0x84, 0x1B, 0xFA, 0x1E, 0xFF,
  0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xF8, 0x1D, 0xA1, 0x70, 0xBF, 0x90, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_home_max() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_round_24_hardware_home_max_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_home_mini 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_24_hardware_home_mini_data[] PROGMEM = {
  0x58, 0x25, 0x9C, 0xDA, 0x82, 0xEC, 0xA5, 0x71, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x50, 0xBA, 0x82,
  0xB7, 0x31, 0x28, 0x21, 0x37, 0xBA, 0x0B, 0x38, 0x2B, 0xFD, 0x37, 0x38, 0x73, 0xDF, 0xA0, 0x5F,
  0xE1, 0x75, 0x85, 0x1E, 0xF4, 0xBF, 0x67, 0x78, 0x46, 0xFA, 0xEF, 0x17, 0x78, 0x21, 0xFE, 0xEF,
  0xFC, 0x0E, 0x0C, 0xFF, 0xC8, 0x2C, 0x7F, 0xB7, 0x78, 0x5B, 0xF8, 0x1E, 0xF8, 0x75, 0x84, 0x8F,
  0xE1, 0x05, 0xA8, 0x1B, 0x41, 0x68, 0x11, 0x4B, 0xA0, 0x53, 0x05, 0x0E, 0xFD, 0x0E, 0x05, 0x58,
  0x21, 0x7C, 0xEE, 0x82, 0xEB, 0x71, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_home_mini() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 18), Box(0, 0, 23, 23),
      ic_round_24_hardware_home_mini_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_alt 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_24_hardware_keyboard_alt_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xD8, 0x0D, 0x4F, 0x2A, 0x2A, 0x2A, 0x2F, 0x92,
  0xA2, 0xA2, 0xA2, 0x80, 0xE0, 0xF2, 0xA2, 0xA2, 0xA2, 0xF9, 0x2A, 0x2A, 0x2A, 0x28, 0x0E, 0x3F,
  0x02, 0x60, 0x28, 0x0D, 0x7F, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_arrow_down 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_round_24_hardware_keyboard_arrow_down_data[] PROGMEM = {
  0x81, 0x5D, 0x56, 0x82, 0x5D, 0x55, 0xA0, 0x54, 0x05, 0xA8, 0x15, 0x07, 0xA0, 0x52, 0x05, 0xA0,
  0x73, 0x07, 0xA0, 0x05, 0xA0, 0x75, 0x07, 0xC0, 0x77, 0x07, 0xA0, 0x77, 0x20, 0x05, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 9, 17, 15), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_arrow_left 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_round_24_hardware_keyboard_arrow_left_data[] PROGMEM = {
  0x50, 0x05, 0x48, 0x17, 0xFD, 0x30, 0x7A, 0x05, 0x20, 0x7A, 0x05, 0x20, 0x7A, 0x05, 0x20, 0x5A,
  0x05, 0x30, 0x5A, 0x05, 0x40, 0x7A, 0x05, 0x40, 0x7A, 0x05, 0x40, 0x7A, 0x05, 0x48, 0x17, 0xFD,
  0x50, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 14, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_arrow_right 24x24, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_round_24_hardware_keyboard_arrow_right_data[] PROGMEM = {
  0x00, 0x55, 0x81, 0xDF, 0x74, 0x05, 0xA0, 0x74, 0x05, 0xA0, 0x74, 0x05, 0xA0, 0x74, 0x05, 0xA0,
  0x53, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x72, 0x05, 0xA0, 0x72, 0x05, 0xA0, 0x73, 0x81, 0xDF, 0x74,
  0x00, 0x55,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 6, 15, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_arrow_up 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_round_24_hardware_keyboard_arrow_up_data[] PROGMEM = {
  0x50, 0x05, 0x72, 0x07, 0xA0, 0x77, 0x07, 0xC0, 0x75, 0x07, 0xA0, 0x05, 0xA0, 0x73, 0x07, 0xA0,
  0x52, 0x05, 0xA8, 0x17, 0x05, 0xA0, 0x54, 0x05, 0xA8, 0x25, 0x5D, 0x56, 0x81, 0x5D, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 17, 14), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_backspace 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_24_hardware_keyboard_backspace_data[] PROGMEM = {
  0x50, 0x05, 0x77, 0x18, 0x17, 0xFD, 0x77, 0x07, 0xA0, 0x57, 0x60, 0x7A, 0x05, 0x76, 0x07, 0xA0,
  0x57, 0x60, 0x5F, 0xFA, 0x0B, 0x05, 0xFF, 0xA8, 0x1B, 0x07, 0xA0, 0x57, 0x71, 0x07, 0xA0, 0x57,
  0x71, 0x07, 0xA0, 0x57, 0x71, 0x81, 0x7F, 0xD7, 0x72, 0x00, 0x57, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_backspace() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 20, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_backspace_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_capslock 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_24_hardware_keyboard_capslock_data[] PROGMEM = {
  0x48, 0x21, 0xBB, 0x17, 0x01, 0x0C, 0xA0, 0xC0, 0x15, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x38, 0x96,
  0x1C, 0xFC, 0x11, 0xCF, 0xC1, 0x01, 0xCF, 0xC1, 0x28, 0x71, 0xCF, 0xC1, 0x7F, 0xC1, 0x48, 0x51,
  0xCF, 0x71, 0x71, 0x68, 0x11, 0x71, 0x80, 0xC0, 0x00, 0xBF, 0xB0, 0x0B, 0xFB, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_capslock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 17, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_capslock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_command_key 24x24, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_24_hardware_keyboard_command_key_data[] PROGMEM = {
  0x18, 0x34, 0xCE, 0xC4, 0x68, 0x54, 0xCE, 0xC4, 0x04, 0xD0, 0x44, 0x04, 0xD8, 0x64, 0xCF, 0x70,
  0x7F, 0xC4, 0x86, 0xCF, 0x70, 0x7F, 0xCE, 0x93, 0xA4, 0xA3, 0x98, 0x2E, 0xCF, 0x72, 0xA4, 0xA2,
  0x82, 0x7F, 0xC4, 0xFF, 0xA8, 0x24, 0x04, 0xCF, 0xD0, 0xC0, 0x46, 0xA4, 0xA7, 0x3A, 0x4A, 0x73,
  0xA4, 0xA7, 0x3A, 0x4A, 0x60, 0x40, 0xCF, 0xD8, 0x2C, 0x40, 0x4F, 0xFA, 0x82, 0x4C, 0xF7, 0x2A,
  0x4A, 0x28, 0x27, 0xFC, 0xE9, 0x3A, 0x4A, 0x39, 0x86, 0xEC, 0xF7, 0x07, 0xFC, 0x48, 0x6C, 0xF7,
  0x07, 0xFC, 0x4D, 0x04, 0x40, 0x4D, 0x85, 0x40, 0x4C, 0xEC, 0x46, 0x83, 0x4C, 0xEC, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_command_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_command_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_control_key 24x24, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_24_hardware_keyboard_control_key_data[] PROGMEM = {
  0x60, 0x05, 0x74, 0x07, 0xA0, 0x77, 0x20, 0x7C, 0x07, 0x70, 0x7A, 0x00, 0x5A, 0x07, 0x50, 0x7A,
  0x05, 0x20, 0x5A, 0x07, 0x30, 0x7A, 0x05, 0x40, 0x5A, 0x81, 0x70, 0x5A, 0x05, 0x60, 0x5A, 0x82,
  0x55, 0xD5, 0x71, 0x81, 0x5D, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_control_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 18, 12), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_control_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_double_arrow_down 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_hardware_keyboard_double_arrow_down_data[] PROGMEM = {
  0x81, 0x17, 0x16, 0x85, 0x17, 0x17, 0xFC, 0x14, 0x87, 0x1C, 0xF7, 0x1C, 0xFC, 0x12, 0x89, 0x61,
  0xCF, 0xC1, 0x01, 0xCF, 0xC1, 0x1C, 0xFC, 0x13, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x50, 0x10, 0xCA,
  0x0C, 0x01, 0x78, 0x21, 0xBB, 0x14, 0x81, 0x5D, 0x56, 0x82, 0x5D, 0x55, 0xA0, 0x54, 0x05, 0xA8,
  0x15, 0x07, 0xA0, 0x52, 0x05, 0xA0, 0x73, 0x07, 0xA0, 0x05, 0xA0, 0x75, 0x07, 0xC0, 0x77, 0x07,
  0xA0, 0x77, 0x20, 0x05, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_double_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 5, 17, 18), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_double_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_double_arrow_left 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_24_hardware_keyboard_double_arrow_left_data[] PROGMEM = {
  0x50, 0x05, 0x48, 0x11, 0x71, 0x48, 0x17, 0xFD, 0x38, 0x21, 0xCF, 0x73, 0x07, 0xA0, 0x52, 0x83,
  0x1C, 0xFC, 0x12, 0x07, 0xA0, 0x52, 0x83, 0x1C, 0xFC, 0x12, 0x07, 0xA0, 0x52, 0x83, 0x1C, 0xFC,
  0x12, 0x05, 0xA0, 0x53, 0x82, 0xBF, 0xC1, 0x30, 0x5A, 0x05, 0x38, 0x2B, 0xFC, 0x14, 0x07, 0xA0,
  0x52, 0x83, 0x1C, 0xFC, 0x14, 0x07, 0xA0, 0x52, 0x83, 0x1C, 0xFC, 0x14, 0x07, 0xA0, 0x52, 0x83,
  0x1C, 0xFC, 0x14, 0x81, 0x7F, 0xD3, 0x82, 0x1C, 0xF7, 0x50, 0x05, 0x48, 0x11, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_double_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 18, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_double_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_double_arrow_right 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_24_hardware_keyboard_double_arrow_right_data[] PROGMEM = {
  0x81, 0x17, 0x14, 0x00, 0x55, 0x82, 0x7F, 0xC1, 0x38, 0x1D, 0xF7, 0x48, 0x31, 0xCF, 0xC1, 0x20,
  0x5A, 0x07, 0x48, 0x31, 0xCF, 0xC1, 0x20, 0x5A, 0x07, 0x48, 0x31, 0xCF, 0xC1, 0x20, 0x5A, 0x07,
  0x48, 0x21, 0xCF, 0xB3, 0x05, 0xA0, 0x53, 0x82, 0x1C, 0xFB, 0x30, 0x5A, 0x05, 0x28, 0x31, 0xCF,
  0xC1, 0x20, 0x5A, 0x07, 0x28, 0x31, 0xCF, 0xC1, 0x20, 0x5A, 0x07, 0x28, 0x31, 0xCF, 0xC1, 0x20,
  0x5A, 0x07, 0x38, 0x27, 0xFC, 0x13, 0x81, 0xDF, 0x74, 0x81, 0x17, 0x14, 0x00, 0x55,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_double_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 18, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_double_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_double_arrow_up 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_24_hardware_keyboard_double_arrow_up_data[] PROGMEM = {
  0x50, 0x05, 0x72, 0x07, 0xA0, 0x77, 0x07, 0xC0, 0x75, 0x07, 0xA0, 0x05, 0xA0, 0x73, 0x07, 0xA0,
  0x52, 0x05, 0xA8, 0x17, 0x05, 0xA0, 0x54, 0x05, 0xA8, 0x25, 0x5D, 0x56, 0x81, 0x5D, 0x54, 0x82,
  0x1B, 0xB1, 0x70, 0x10, 0xCA, 0x0C, 0x01, 0x58, 0x61, 0xCF, 0xCC, 0xFC, 0x13, 0x89, 0x61, 0xCF,
  0xC1, 0x1C, 0xFC, 0x10, 0x1C, 0xFC, 0x12, 0x87, 0x1C, 0xFC, 0x17, 0xFC, 0x14, 0x85, 0x1C, 0xF7,
  0x17, 0x16, 0x81, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_double_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 5, 17, 18), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_double_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_hide 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_hardware_keyboard_hide_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDF, 0xFF, 0xA2, 0x92, 0x92, 0x92, 0x92, 0xE2,
  0x92, 0x92, 0x92, 0x92, 0xFF, 0xFD, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x28,
  0x0D, 0x5F, 0x03, 0x60, 0x3F, 0xD0, 0x36, 0x03, 0xE0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D,
  0x04, 0x80, 0xD2, 0x00, 0x2E, 0x02, 0x76, 0x07, 0xC0, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x73, 0x00,
  0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_hide() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_hide_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_option_key 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_24_hardware_keyboard_option_key_data[] PROGMEM = {
  0x0B, 0xC0, 0xC0, 0x25, 0x0B, 0xC0, 0x0B, 0xD0, 0xD5, 0x0B, 0xC0, 0xB5, 0x81, 0xDF, 0x67, 0x71,
  0x82, 0x4F, 0xE1, 0x77, 0x18, 0x1A, 0xF9, 0x77, 0x10, 0x2A, 0x02, 0x77, 0x18, 0x18, 0xFB, 0x77,
  0x28, 0x1E, 0xF5, 0x77, 0x18, 0x16, 0xFD, 0x77, 0x28, 0x1C, 0xF7, 0x77, 0x18, 0x23, 0xFE, 0x17,
  0x71, 0x81, 0xAF, 0x97, 0x71, 0x01, 0x0E, 0xD0, 0xB7, 0x40, 0x40, 0xDC, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_option_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 20, 18), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_option_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_24_hardware_keyboard_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDF, 0xFF, 0xA2, 0x92, 0x92, 0x92, 0x92, 0xE2,
  0x92, 0x92, 0x92, 0x92, 0xFF, 0xFD, 0x29, 0x29, 0x29, 0x29, 0x2E, 0x29, 0x29, 0x29, 0x29, 0x28,
  0x0D, 0x5F, 0x03, 0x60, 0x3F, 0xD0, 0x36, 0x03, 0xE0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 18), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_return 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_24_hardware_keyboard_return_data[] PROGMEM = {
  0x50, 0x05, 0x77, 0x28, 0x17, 0xFD, 0x73, 0x00, 0xB3, 0x07, 0xA0, 0x57, 0x3A, 0x20, 0x7A, 0x05,
  0x74, 0xA1, 0x07, 0xA0, 0x57, 0x5A, 0x05, 0xFF, 0xC0, 0x5F, 0xFB, 0x81, 0xB0, 0x7A, 0x05, 0x77,
  0x20, 0x7A, 0x05, 0x77, 0x20, 0x7A, 0x05, 0x77, 0x28, 0x17, 0xFD, 0x77, 0x30, 0x05, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_return() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 20, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_return_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_tab 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_24_hardware_keyboard_tab_data[] PROGMEM = {
  0x74, 0x00, 0x56, 0x00, 0xB7, 0x48, 0x1D, 0xF7, 0x5A, 0x74, 0x05, 0xA0, 0x74, 0xA7, 0x50, 0x5A,
  0x07, 0x3A, 0x76, 0x05, 0xA0, 0x72, 0xA0, 0xBF, 0xFA, 0x05, 0x1A, 0x0B, 0xFF, 0xA0, 0x51, 0xA7,
  0x60, 0x5A, 0x07, 0x2A, 0x75, 0x05, 0xA0, 0x73, 0xA7, 0x40, 0x5A, 0x07, 0x4A, 0x74, 0x81, 0xDF,
  0x75, 0xA7, 0x40, 0x05, 0x60, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_tab() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 21, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_tab_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_keyboard_voice 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_24_hardware_keyboard_voice_data[] PROGMEM = {
  0x58, 0x28, 0xDD, 0x87, 0x20, 0x8C, 0x08, 0x71, 0x0D, 0xC0, 0xD7, 0x1E, 0x71, 0xE7, 0x1E, 0x71,
  0xE7, 0x1E, 0x71, 0xE4, 0x0B, 0x08, 0x20, 0xDC, 0x0D, 0x28, 0x29, 0xBB, 0xE2, 0x08, 0xC0, 0x82,
  0x98, 0x2C, 0x6F, 0x62, 0x82, 0x8D, 0xD8, 0x28, 0x56, 0xF7, 0x0D, 0xF4, 0x68, 0x14, 0xFD, 0x28,
  0x32, 0xEF, 0x92, 0x28, 0x32, 0x9F, 0xE2, 0x30, 0x10, 0xBE, 0x0B, 0x02, 0x60, 0x30, 0x8A, 0x08,
  0x03, 0x73, 0xA7, 0x5A, 0x75, 0x00, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_keyboard_voice() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_keyboard_voice_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_laptop_chromebook 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_24_hardware_laptop_chromebook_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x40, 0xDF, 0xFC, 0x0D, 0x4A, 0x03, 0x77, 0x03, 0xA4, 0xA7,
  0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72,
  0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xFF, 0xE4, 0xFF, 0xE4, 0xF9, 0x02,
  0x20, 0x2F, 0x92, 0x0B, 0xFF, 0xF9, 0x00, 0xBF, 0xFF, 0x90, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_laptop_chromebook() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_laptop_chromebook_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_laptop_mac 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_hardware_laptop_mac_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x40, 0xDF, 0xFC, 0x0D, 0x4A, 0x03, 0x77, 0x03, 0xA4, 0xA7,
  0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72,
  0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA0, 0x37, 0x70, 0x3A, 0x40, 0xDF,
  0xFC, 0x0D, 0x40, 0x40, 0xDF, 0x00, 0x3F, 0x0D, 0x04, 0x20, 0xDF, 0xB0, 0x03, 0xFB, 0x81, 0xD4,
  0xDF, 0xFE, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_laptop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_laptop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_laptop 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_24_hardware_laptop_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x40, 0xDF, 0xFC, 0x0D, 0x4A, 0x03, 0x77, 0x03, 0xA4, 0xA7,
  0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72,
  0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA0, 0x37, 0x70, 0x3A, 0x40, 0xDF, 0xFC, 0x0D, 0x40,
  0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x20, 0xBF, 0xFF, 0x90, 0x0B, 0xFF, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_laptop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_laptop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_laptop_windows 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_hardware_laptop_windows_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x40, 0xDF, 0xFC, 0x0D, 0x4A, 0x03, 0x77, 0x03, 0xA4, 0xA7,
  0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72,
  0xA4, 0xA7, 0x72, 0xA4, 0xA7, 0x72, 0xA4, 0xA0, 0x37, 0x70, 0x3A, 0x40, 0xDF, 0xFC, 0x0D, 0x40,
  0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x6F, 0xFA, 0x40, 0xBF, 0xFF, 0x90, 0x0B, 0xFF, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_laptop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_laptop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_memory 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_24_hardware_memory_data[] PROGMEM = {
  0x60, 0x0B, 0x20, 0x0B, 0x75, 0xA2, 0xA7, 0x10, 0x40, 0xDF, 0xB0, 0xD0, 0x44, 0x0D, 0xFD, 0x0D,
  0x4A, 0x03, 0x71, 0x03, 0xA4, 0xA7, 0x3A, 0x20, 0xBB, 0x20, 0xBC, 0x0B, 0x2B, 0x00, 0xBB, 0x2E,
  0x2B, 0x0B, 0x2A, 0x2A, 0x2A, 0x2A, 0x4A, 0x2A, 0x2A, 0x2A, 0x20, 0xBB, 0x2E, 0x2B, 0x00, 0xBB,
  0x20, 0xBC, 0x0B, 0x2B, 0x0B, 0x2A, 0x73, 0xA4, 0xA0, 0x37, 0x10, 0x3A, 0x40, 0xDF, 0xD0, 0xD4,
  0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x71, 0xA2, 0xA7, 0x50, 0x0B, 0x20, 0x0B, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_memory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_memory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_monitor 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_hardware_monitor_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77,
  0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2A, 0x0D,
  0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x44, 0x07, 0xFB, 0x07, 0x71, 0x0E, 0xFB, 0x0E, 0x71,
  0x08, 0xFB, 0x08, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_mouse 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_hardware_mouse_data[] PROGMEM = {
  0x48, 0x12, 0x8C, 0x28, 0x1C, 0x82, 0x70, 0x8B, 0x2B, 0x08, 0x50, 0xBC, 0x2C, 0x0B, 0x30, 0x9D,
  0x2D, 0x81, 0x90, 0x2E, 0x2E, 0x02, 0x08, 0xE2, 0xE0, 0x80, 0xCE, 0x2E, 0x0C, 0x0E, 0xE2, 0xE0,
  0xE7, 0x77, 0x74, 0x80, 0xF4, 0xF0, 0xEF, 0xF0, 0xE0, 0xCF, 0xF0, 0xC0, 0x8F, 0xF0, 0x80, 0x2F,
  0xF8, 0x12, 0x09, 0xFD, 0x09, 0x30, 0xBF, 0xB0, 0xB5, 0x09, 0xF9, 0x09, 0x78, 0x62, 0x8C, 0xEE,
  0xC8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_mouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_mouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_phone_android 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_24_hardware_phone_android_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0x98, 0x2D, 0x80, 0x8F, 0xD0, 0x80, 0xDF, 0xD0, 0xDA, 0x73, 0xC7, 0x3C, 0x73,
  0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7,
  0x3F, 0xFF, 0xFA, 0x0D, 0xC0, 0x22, 0x02, 0xC0, 0xD0, 0x8F, 0xD8, 0x28, 0x08, 0xDF, 0x90, 0xD0,
  0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_phone_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_phone_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_phone_iphone 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_24_hardware_phone_iphone_data[] PROGMEM = {
  0x01, 0x0B, 0xFA, 0x81, 0xB1, 0xBF, 0xC0, 0xBF, 0xF9, 0x72, 0xC7, 0x2C, 0x72, 0xC7, 0x2C, 0x72,
  0xC7, 0x2C, 0x72, 0xC7, 0x2C, 0x72, 0xC7, 0x2C, 0x72, 0xC7, 0x2C, 0x72, 0xC7, 0x2F, 0xFE, 0x81,
  0x70, 0x7F, 0xB3, 0xD0, 0xBC, 0x81, 0x70, 0x7C, 0x81, 0xB1, 0xBF, 0xA0, 0xB0, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_phone_iphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 17, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_phone_iphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_phonelink_off 24x24, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_round_24_hardware_phonelink_off_data[] PROGMEM = {
  0x18, 0x1B, 0xD2, 0x77, 0x78, 0x2A, 0xFD, 0x27, 0x77, 0x85, 0xCF, 0xD2, 0x02, 0xEF, 0xD0, 0xB4,
  0x0D, 0xA8, 0x3D, 0x20, 0x2E, 0xFC, 0x0B, 0x4A, 0x82, 0xBF, 0xD2, 0x77, 0x4A, 0x18, 0x2B, 0xFD,
  0x27, 0x73, 0xA2, 0x82, 0xBF, 0xD2, 0x60, 0xBE, 0x0B, 0x2A, 0x38, 0x2B, 0xFD, 0x25, 0xF9, 0x2A,
  0x48, 0x2B, 0xFD, 0x24, 0xA4, 0xA2, 0xA5, 0x82, 0xBF, 0xD2, 0x3A, 0x4A, 0x2A, 0x68, 0x2B, 0xFD,
  0x22, 0x0E, 0x94, 0xA2, 0xA7, 0x85, 0xBF, 0xD2, 0x02, 0xE4, 0xA2, 0xA7, 0x18, 0x4B, 0xFD, 0x20,
  0x24, 0xA2, 0xA7, 0x28, 0x2B, 0xFD, 0x25, 0xA2, 0xA7, 0x38, 0x2B, 0xFD, 0x24, 0xA0, 0x8F, 0xFA,
  0x83, 0xD2, 0x02, 0xEA, 0x0E, 0xFF, 0xB8, 0x5D, 0x20, 0x2E, 0xF8, 0xFF, 0xC8, 0x3D, 0x20, 0x2A,
  0x77, 0x48, 0x1B, 0xFD, 0x77, 0x71, 0x00, 0xA3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_phonelink_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_phonelink_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_phonelink 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_24_hardware_phonelink_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFB, 0x0B, 0x40, 0xDF, 0xFC, 0x0B, 0x4A, 0x03, 0x77, 0x7A, 0x77, 0x71, 0xA7,
  0x50, 0xBE, 0x0B, 0x2A, 0x75, 0xF9, 0x2A, 0x75, 0xA4, 0xA2, 0xA7, 0x5A, 0x4A, 0x2A, 0x75, 0xA4,
  0xA2, 0xA7, 0x5A, 0x4A, 0x2A, 0x75, 0xA4, 0xA2, 0xA7, 0x5A, 0x4A, 0x2A, 0x75, 0xA4, 0xA0, 0x8F,
  0xD0, 0x82, 0xF9, 0x0E, 0xFD, 0x0E, 0x2F, 0x90, 0x8F, 0xD0, 0x82, 0x0B, 0xE0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_phonelink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_phonelink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_point_of_sale 24x24, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_24_hardware_point_of_sale_data[] PROGMEM = {
  0x30, 0x40, 0xDF, 0xB0, 0xD0, 0x46, 0x0D, 0xFD, 0x0D, 0x6A, 0x01, 0x71, 0x01, 0xA6, 0xA0, 0x17,
  0x10, 0x1A, 0x60, 0xDF, 0xD0, 0xD6, 0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x77, 0x75, 0x01, 0x0C, 0xFB,
  0x0C, 0x01, 0x60, 0xAF, 0xD0, 0xA5, 0x01, 0xB8, 0x62, 0x2F, 0x22, 0xF2, 0x2B, 0x01, 0x40, 0x8F,
  0xF0, 0x84, 0x0E, 0xB8, 0x62, 0x2F, 0x22, 0xF2, 0x2B, 0x0E, 0x30, 0x6F, 0xFA, 0x06, 0x20, 0xDC,
  0x86, 0x22, 0xF2, 0x2F, 0x22, 0xC8, 0x1D, 0x05, 0xFF, 0xC0, 0x50, 0xCF, 0xFC, 0x0C, 0x77, 0x6F,
  0xFE, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_point_of_sale() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_point_of_sale_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_power_input 24x24, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_round_24_hardware_power_input_data[] PROGMEM = {
  0x0B, 0xFF, 0xB0, 0x0B, 0xFF, 0xB0, 0xB8, 0x0C, 0x20, 0x0B, 0xB0, 0xB2, 0x0B, 0xB0, 0xB2, 0x0B,
  0xB0, 0x0B, 0xB0, 0xB2, 0x0B, 0xB0, 0xB2, 0x0B, 0xB0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_power_input() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 9, 20, 14), Box(0, 0, 23, 23),
      ic_round_24_hardware_power_input_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_router 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_24_hardware_router_data[] PROGMEM = {
  0x72, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x72, 0x89, 0x04, 0xEC, 0x74, 0x47, 0xCE, 0x47, 0x18, 0x90,
  0x65, 0x06, 0x99, 0x60, 0x66, 0x73, 0x84, 0xDD, 0x88, 0xDD, 0x75, 0x03, 0x40, 0x27, 0x77, 0x74,
  0x00, 0xB7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA4, 0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D,
  0xFF, 0xF2, 0x98, 0x17, 0x07, 0x92, 0xFA, 0x29, 0x81, 0x70, 0x79, 0x2F, 0xFF, 0xB0, 0xDF, 0xFA,
  0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_router() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_router_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_scanner 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_24_hardware_scanner_data[] PROGMEM = {
  0x18, 0x18, 0x72, 0x77, 0x01, 0xB8, 0x1C, 0x61, 0x75, 0x81, 0x39, 0xEB, 0x0A, 0x05, 0x76, 0x05,
  0x0B, 0xB8, 0x1E, 0x93, 0x75, 0x81, 0x16, 0xCB, 0x81, 0xD7, 0x27, 0x58, 0x12, 0x8D, 0xB0, 0xB0,
  0x67, 0x68, 0x13, 0x9E, 0xA8, 0x1A, 0x4D, 0xFF, 0xA0, 0xD8, 0x0C, 0x1F, 0x2A, 0x03, 0x71, 0x03,
  0xC2, 0xA0, 0x37, 0x10, 0x3F, 0xFE, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_security 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_24_hardware_security_data[] PROGMEM = {
  0x78, 0x25, 0xAA, 0x57, 0x50, 0x60, 0xDC, 0x0D, 0x06, 0x78, 0x11, 0x8E, 0xA0, 0xD0, 0x6C, 0x81,
  0xE8, 0x12, 0x01, 0x0A, 0xB0, 0xB0, 0x42, 0xF8, 0x1A, 0x1C, 0xA0, 0x90, 0x24, 0xF9, 0x0C, 0xA0,
  0x16, 0xFC, 0x7F, 0xC7, 0xFC, 0x7F, 0xC7, 0xFA, 0x0E, 0x97, 0xF9, 0x0E, 0x0D, 0xF9, 0x68, 0x21,
  0xFD, 0xBF, 0x96, 0x82, 0x4F, 0xB7, 0xF9, 0x68, 0x29, 0xF7, 0x2F, 0x95, 0x84, 0x1E, 0xF2, 0x0A,
  0xF5, 0x81, 0x9F, 0xA2, 0x02, 0xF4, 0x04, 0xA0, 0x23, 0x07, 0xE3, 0x82, 0x3E, 0xF7, 0x50, 0xAD,
  0x28, 0x25, 0xEF, 0xA7, 0x09, 0xC0, 0x40, 0xBA, 0x09, 0x72, 0x06, 0x0E, 0xC0, 0xE0, 0x67, 0x48,
  0x41, 0x7C, 0xC7, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_security() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_security_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_sim_card 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_24_hardware_sim_card_data[] PROGMEM = {
  0x50, 0x60, 0xEF, 0x0D, 0x04, 0x40, 0x7F, 0xB0, 0xD3, 0x07, 0xFD, 0x20, 0x7F, 0xE1, 0x07, 0xFF,
  0x06, 0xFF, 0x90, 0xE8, 0x0D, 0x6F, 0x00, 0x3A, 0x00, 0x3A, 0x00, 0x3E, 0x2A, 0x00, 0x3A, 0x2E,
  0x2E, 0x2E, 0x00, 0x3E, 0x00, 0x3F, 0xB0, 0x03, 0xFF, 0x2F, 0xB0, 0x03, 0xA2, 0xA0, 0x03, 0xE0,
  0x03, 0xA0, 0x03, 0xA0, 0x03, 0xFF, 0xD0, 0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_sim_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_sim_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_smart_display 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_24_hardware_smart_display_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x3F, 0x81, 0xD6, 0xCF, 0xFB, 0x07,
  0x20, 0x60, 0xEF, 0xF9, 0x07, 0x30, 0x10, 0xBF, 0xF0, 0x75, 0x08, 0xFE, 0x07, 0x50, 0x8F, 0xE0,
  0x73, 0x01, 0x0B, 0xFF, 0x07, 0x20, 0x60, 0xEF, 0xF9, 0x81, 0xD6, 0xC8, 0x0D, 0x6F, 0x0D, 0xFF,
  0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_smart_display() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_smart_display_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_smartphone 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_24_hardware_smartphone_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C,
  0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3F, 0xFF,
  0xFA, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_smartphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_smartphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_smart_screen 24x24, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_24_hardware_smart_screen_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDD, 0x75, 0xFB, 0x75, 0xFB, 0x75, 0xFB, 0x75,
  0xFB, 0x18, 0x90, 0x38, 0x08, 0x33, 0x80, 0x83, 0x1F, 0xB1, 0x89, 0x03, 0x80, 0x83, 0x38, 0x08,
  0x31, 0xFB, 0x75, 0xFB, 0x75, 0xFB, 0x75, 0xFB, 0x75, 0xD0, 0xDF, 0xFE, 0x81, 0xD4, 0xDF, 0xFC,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_smart_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_round_24_hardware_smart_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_smart_toy 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_24_hardware_smart_toy_data[] PROGMEM = {
  0x72, 0x82, 0x8D, 0xD8, 0x77, 0x30, 0x8C, 0x08, 0x77, 0x20, 0xDC, 0x0D, 0x74, 0x04, 0x0D, 0xFD,
  0x0D, 0x04, 0x60, 0xDF, 0xF0, 0xD6, 0xFF, 0xA6, 0xFF, 0xA4, 0x08, 0x0D, 0xFF, 0xA8, 0x2D, 0x80,
  0x8D, 0x82, 0xD2, 0x2D, 0xA8, 0x2D, 0x22, 0xDD, 0x08, 0x0D, 0xD0, 0x82, 0x08, 0xA0, 0x82, 0x08,
  0xD0, 0x0D, 0xD8, 0x2D, 0x22, 0xDA, 0x82, 0xD2, 0x2D, 0xD0, 0xD0, 0x8F, 0xFE, 0x82, 0x80, 0x8D,
  0xFF, 0xA0, 0xD0, 0x84, 0xC0, 0x36, 0x03, 0xC6, 0xC0, 0x36, 0x03, 0xC6, 0xFF, 0xA6, 0xFF, 0xA6,
  0x0D, 0xFF, 0x0D, 0x60, 0x40, 0xDF, 0xD0, 0xD0, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_smart_toy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_smart_toy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_speaker_group 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_24_hardware_speaker_group_data[] PROGMEM = {
  0x40, 0x50, 0xEF, 0x90, 0xE0, 0x54, 0x0E, 0xFB, 0x0E, 0x4C, 0x82, 0xB1, 0x1B, 0xC4, 0xC0, 0x12,
  0x01, 0xC0, 0x0B, 0x2C, 0x01, 0x20, 0x1E, 0x2C, 0x82, 0xB1, 0x1B, 0xE2, 0xFF, 0x2C, 0x82, 0xD9,
  0x9D, 0xE2, 0xB0, 0x74, 0x07, 0xD2, 0xA8, 0x69, 0x06, 0xDD, 0x60, 0x9C, 0x2A, 0x00, 0x3C, 0x00,
  0x3C, 0x2A, 0x10, 0x6C, 0x06, 0x1C, 0x2A, 0x00, 0x3C, 0x00, 0x3C, 0x2A, 0x86, 0x90, 0x6D, 0xD6,
  0x09, 0xC2, 0xB0, 0x74, 0x07, 0xD2, 0xC8, 0x2D, 0x99, 0xDE, 0x20, 0xEF, 0xB0, 0xEA, 0x20, 0x50,
  0xEF, 0x90, 0xE0, 0x5A, 0x77, 0xA0, 0x37, 0x60, 0xDF, 0xB0, 0xB4, 0x04, 0x0D, 0xFA, 0x0B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_speaker_group() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_speaker_group_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_speaker 24x24, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_24_hardware_speaker_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDD, 0x82, 0xB1, 0x1B, 0xFB, 0x01, 0x20, 0x1F, 0xB0,
  0x12, 0x01, 0xFB, 0x82, 0xB1, 0x1B, 0x80, 0xC1, 0xF0, 0xA0, 0x32, 0x03, 0x0A, 0xF0, 0x76, 0x07,
  0xD0, 0xA2, 0x82, 0x8D, 0xD8, 0x20, 0xAC, 0x81, 0x30, 0x8C, 0x81, 0x80, 0x3C, 0x20, 0xDC, 0x0D,
  0x2C, 0x20, 0xDC, 0x0D, 0x2C, 0x81, 0x30, 0x8C, 0x81, 0x80, 0x3C, 0x0A, 0x28, 0x28, 0xDD, 0x82,
  0x0A, 0xD0, 0x76, 0x07, 0xF0, 0xA0, 0x32, 0x03, 0x0A, 0xC0, 0xDF, 0xD8, 0x1D, 0x4D, 0xFB, 0x0D,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_speaker() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 21), Box(0, 0, 23, 23),
      ic_round_24_hardware_speaker_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_start 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_24_hardware_start_data[] PROGMEM = {
  0x00, 0xB7, 0x40, 0x05, 0x5A, 0x74, 0x81, 0xDF, 0x74, 0xA7, 0x40, 0x5A, 0x07, 0x3A, 0x75, 0x05,
  0xA0, 0x72, 0xA7, 0x60, 0x5A, 0x07, 0x1A, 0x20, 0xBF, 0xF0, 0x5A, 0x20, 0xBF, 0xF0, 0x5A, 0x76,
  0x05, 0xA0, 0x71, 0xA7, 0x50, 0x5A, 0x07, 0x2A, 0x74, 0x05, 0xA0, 0x73, 0xA7, 0x48, 0x1D, 0xF7,
  0x40, 0x0B, 0x74, 0x00, 0x55,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_start() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 21, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_start_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_tablet_android 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_24_hardware_tablet_android_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xD8, 0x2D, 0x80, 0x8F, 0xFA, 0x08, 0x0D, 0xFF, 0xA8, 0x1D, 0xFB, 0x77, 0x0B,
  0xA0, 0xB7, 0x70, 0xBA, 0x0B, 0x77, 0x0B, 0xA0, 0xB7, 0x70, 0xBA, 0x0B, 0x77, 0x0B, 0xA0, 0xB7,
  0x70, 0xBA, 0x0B, 0x77, 0x0B, 0xA0, 0xB7, 0x70, 0xBA, 0x0B, 0x77, 0x0B, 0xA0, 0xB7, 0x70, 0xBA,
  0x0B, 0x77, 0x0B, 0xA0, 0xB7, 0x70, 0xBA, 0x0B, 0x77, 0x0B, 0xA0, 0xB7, 0x70, 0xBA, 0x0B, 0x77,
  0x0B, 0xA0, 0xB7, 0x70, 0xB8, 0x0C, 0x1F, 0x0D, 0xE0, 0x22, 0x02, 0xE0, 0xD0, 0x8F, 0xFA, 0x82,
  0x80, 0x8D, 0xFD, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_tablet_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 20, 23), Box(0, 0, 23, 23),
      ic_round_24_hardware_tablet_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_tablet_mac 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_24_hardware_tablet_mac_data[] PROGMEM = {
  0x01, 0x0B, 0xFF, 0x98, 0x1B, 0x1B, 0xFF, 0xB0, 0xBF, 0xFF, 0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C,
  0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C,
  0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1C, 0x77, 0x1F, 0xFF, 0xF9, 0x81, 0x70, 0x7F, 0xFA,
  0x3F, 0x90, 0xBF, 0x81, 0x70, 0x7F, 0x81, 0xB1, 0xBF, 0xF9, 0x0B, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_tablet_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 20, 23), Box(0, 0, 23, 23),
      ic_round_24_hardware_tablet_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_tablet 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_24_hardware_tablet_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDC, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77,
  0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77,
  0xC0, 0xDF, 0xFE, 0x81, 0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_tablet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_tablet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_toys 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_24_hardware_toys_data[] PROGMEM = {
  0x60, 0x40, 0xCE, 0x0C, 0x04, 0x68, 0x31, 0xBA, 0x02, 0xFB, 0x02, 0x48, 0x61, 0xCF, 0xB0, 0x8F,
  0xA2, 0xA2, 0x81, 0xAF, 0x84, 0x0B, 0xA8, 0x3C, 0x1D, 0xF3, 0x2A, 0x28, 0x13, 0xFD, 0x48, 0x5B,
  0xBC, 0xFD, 0xFD, 0x3A, 0x38, 0x1D, 0xF3, 0x50, 0x10, 0xCA, 0x08, 0x3A, 0x38, 0x18, 0xF8, 0x50,
  0x20, 0xAF, 0xF0, 0x90, 0x12, 0x02, 0x0E, 0xFF, 0xA8, 0x2E, 0x20, 0xAF, 0xFC, 0x81, 0xA0, 0xEF,
  0xFC, 0x81, 0xE0, 0xEF, 0xFC, 0x81, 0xE0, 0xAF, 0xFC, 0x82, 0xA0, 0x2E, 0xA0, 0x03, 0xF9, 0x00,
  0x3A, 0x0E, 0x02, 0x28, 0x32, 0xEF, 0x33, 0xF9, 0x83, 0x33, 0xFE, 0x24, 0x08, 0xC0, 0x84, 0x08,
  0xC0, 0x86, 0x82, 0x8E, 0xE8, 0x68, 0x28, 0xEE, 0x83,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_toys() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_hardware_toys_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_tv 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_24_hardware_tv_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77,
  0x4C, 0x03, 0x77, 0x20, 0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x47, 0xF9, 0x77,
  0x0B, 0xE0, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_hardware_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_videogame_asset_off 24x24, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_24_hardware_videogame_asset_off_data[] PROGMEM = {
  0x10, 0x90, 0x67, 0x74, 0x01, 0xA0, 0x77, 0x74, 0x05, 0xA0, 0x77, 0x73, 0x04, 0x0E, 0xA0, 0x72,
  0x0A, 0xFB, 0x82, 0xD4, 0x0D, 0xC0, 0x72, 0x0A, 0xFB, 0x0D, 0x1E, 0x07, 0x20, 0xAF, 0xB1, 0xF0,
  0x72, 0x0A, 0xB8, 0x17, 0x07, 0xB1, 0xD0, 0x5A, 0x07, 0x20, 0xAA, 0x3B, 0x1B, 0x03, 0x20, 0x5A,
  0x07, 0x28, 0x3A, 0xF7, 0x07, 0xB1, 0xB0, 0x33, 0x05, 0xA0, 0x72, 0x0A, 0xE1, 0xD2, 0xC0, 0x72,
  0x0A, 0xD1, 0xD0, 0x03, 0xD0, 0x72, 0x0A, 0xC1, 0xFE, 0x07, 0x20, 0xAB, 0x10, 0xDF, 0xE0, 0x72,
  0x84, 0xAF, 0xD0, 0x4D, 0xFE, 0x07, 0x20, 0x90, 0x47, 0x70, 0x5A, 0x07, 0x77, 0x40, 0x5A, 0x07,
  0x77, 0x40, 0x5A, 0x06, 0x77, 0x48, 0x15, 0xF9, 0x77, 0x50, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_videogame_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_videogame_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_videogame_asset 24x24, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_24_hardware_videogame_asset_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDD, 0x00, 0x3F, 0xFE, 0x2F, 0xB8, 0x17, 0x07,
  0xF2, 0xFB, 0x3C, 0x03, 0x60, 0x3F, 0x81, 0x70, 0x7C, 0x03, 0x60, 0x3B, 0x81, 0x70, 0x7F, 0xC2,
  0xE3, 0xFC, 0x2E, 0x81, 0x70, 0x7F, 0xC0, 0x03, 0xFF, 0x90, 0xDF, 0xFE, 0x81, 0xD4, 0xDF, 0xFC,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_videogame_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 22, 17), Box(0, 0, 23, 23),
      ic_round_24_hardware_videogame_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_watch_off 24x24, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_24_hardware_watch_off_data[] PROGMEM = {
  0x71, 0x0A, 0xC0, 0xA7, 0x09, 0x06, 0x40, 0x6E, 0x06, 0x50, 0x1A, 0x07, 0x30, 0xBE, 0x0B, 0x60,
  0x5A, 0x07, 0x20, 0x9F, 0x01, 0x60, 0x5A, 0x07, 0x20, 0xAE, 0x06, 0x70, 0x5A, 0x07, 0x20, 0x32,
  0x03, 0x0A, 0xA0, 0x57, 0x06, 0xA0, 0x76, 0x82, 0x7F, 0xE1, 0x60, 0x7B, 0x07, 0x68, 0x1A, 0xF7,
  0x68, 0x1C, 0xF9, 0xA0, 0x75, 0x81, 0x3F, 0xC6, 0x82, 0xEF, 0x05, 0xA0, 0x75, 0x90, 0xE6, 0x0E,
  0x92, 0x05, 0xA0, 0x74, 0x90, 0xE6, 0x81, 0xCF, 0x32, 0x05, 0xA0, 0x72, 0x81, 0x3F, 0xC6, 0x81,
  0x7F, 0xA3, 0x05, 0xA0, 0x72, 0x0A, 0x07, 0x68, 0x21, 0xEF, 0x73, 0x05, 0xA0, 0x77, 0x30, 0x5A,
  0x0A, 0x03, 0x20, 0x8A, 0x07, 0x73, 0x06, 0xFA, 0x07, 0x72, 0x01, 0xFB, 0x07, 0x72, 0x0B, 0xE0,
  0xB0, 0x5A, 0x07, 0x71, 0x06, 0xE8, 0x16, 0x05, 0xA0, 0x67, 0x10, 0xAC, 0x0A, 0x38, 0x15, 0xF9,
  0x77, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_watch_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_hardware_watch_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_hardware_watch 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_round_24_hardware_watch_data[] PROGMEM = {
  0x40, 0x80, 0xEC, 0x0E, 0x08, 0x70, 0x3F, 0x90, 0x36, 0x06, 0xF9, 0x06, 0x60, 0x9F, 0x90, 0x96,
  0x0B, 0xF9, 0x0B, 0x60, 0xEF, 0x90, 0xE5, 0x0A, 0xA0, 0x80, 0x32, 0x03, 0x08, 0xA0, 0xB3, 0x82,
  0x8F, 0xD2, 0x68, 0x42, 0xDF, 0x80, 0x2A, 0x02, 0x71, 0x02, 0xA8, 0x22, 0x8F, 0x87, 0x38, 0x48,
  0xF8, 0xCF, 0x37, 0x38, 0x23, 0xFC, 0xE9, 0x75, 0x90, 0x0E, 0x97, 0x59, 0x82, 0xEC, 0xF3, 0x73,
  0x84, 0x3F, 0xC8, 0xF8, 0x73, 0x82, 0x8F, 0x82, 0xA0, 0x27, 0x10, 0x2A, 0x84, 0x20, 0x8F, 0xD2,
  0x68, 0x22, 0xDF, 0x83, 0x0A, 0xA0, 0x80, 0x32, 0x03, 0x08, 0xA0, 0xB5, 0x0E, 0xF9, 0x0E, 0x60,
  0xBF, 0x90, 0xB6, 0x09, 0xF9, 0x09, 0x60, 0x6F, 0x90, 0x66, 0x03, 0xF9, 0x03, 0x70, 0x80, 0xEC,
  0x0E, 0x08, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_hardware_watch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 19, 23), Box(0, 0, 23, 23),
      ic_round_24_hardware_watch_data, Alpha4(color::Black));
  return value;
}
