#include "communication.h"

using namespace roo_display;

// Image file ic_round_24_communication_3p 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_communication_3p_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x4F, 0x82, 0xB1, 0x1B, 0xFF, 0xA0,
  0x12, 0x01, 0xFF, 0xA0, 0x12, 0x01, 0xFF, 0xA8, 0x2B, 0x11, 0xBF, 0xFF, 0xFE, 0x81, 0xE7, 0x22,
  0x81, 0x27, 0xEF, 0xD0, 0x46, 0x04, 0xFD, 0x71, 0x80, 0xF5, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0,
  0x77, 0x72, 0xA0, 0x77, 0x73, 0x00, 0x57, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_3p() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_3p_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_add_ic_call 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_24_communication_add_ic_call_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xC0, 0x17, 0x00, 0xB3, 0x0D, 0xC0, 0x97, 0xA3, 0x0E, 0xC0, 0xC7, 0xA3, 0x0B,
  0xC0, 0xE4, 0x0B, 0xE0, 0xB0, 0x9D, 0x40, 0xBE, 0x0B, 0x05, 0xC0, 0xB7, 0xA3, 0x01, 0xB0, 0xC0,
  0x17, 0xA4, 0x82, 0xAF, 0xD1, 0x71, 0x00, 0xB4, 0x82, 0x3F, 0xE1, 0x77, 0x18, 0x1A, 0xF9, 0x77,
  0x18, 0x21, 0xEF, 0x67, 0x71, 0x05, 0xA0, 0x47, 0x71, 0x07, 0xA0, 0x63, 0x85, 0x1B, 0xFE, 0xC9,
  0x15, 0x07, 0xA8, 0x2A, 0x11, 0xCD, 0x0C, 0x68, 0x34, 0xEF, 0xED, 0xF7, 0x01, 0x0A, 0xFA, 0x72,
  0x03, 0x0A, 0xE0, 0xD7, 0x58, 0x45, 0x9B, 0xED, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_add_ic_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_add_ic_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_alternate_email 24x24, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_round_24_communication_alternate_email_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xDF, 0xCA, 0x47, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x6D, 0x73,
  0x01, 0x37, 0xDA, 0x07, 0x50, 0x8A, 0x07, 0x71, 0x07, 0xA0, 0x73, 0x04, 0xA0, 0x47, 0x30, 0x5A,
  0x03, 0x28, 0x1D, 0xF7, 0x38, 0x44, 0xBE, 0xFA, 0x43, 0x85, 0x7F, 0xC0, 0x5F, 0xD3, 0x07, 0xE0,
  0x63, 0x84, 0xDF, 0x49, 0xF7, 0x20, 0x4A, 0x82, 0x71, 0x17, 0xA0, 0x32, 0x84, 0x7F, 0x8D, 0xF3,
  0x28, 0x1B, 0xF7, 0x48, 0x17, 0xFA, 0x28, 0x23, 0xFC, 0xE9, 0x38, 0x1E, 0xF1, 0x48, 0x11, 0xFD,
  0x28, 0x41, 0xFE, 0xEF, 0x12, 0x81, 0xEF, 0x14, 0x01, 0xA3, 0xA8, 0x1C, 0xF3, 0x28, 0x1B, 0xF7,
  0x40, 0x7A, 0x3A, 0x81, 0xAF, 0x62, 0x04, 0xA8, 0x27, 0x11, 0x7B, 0x86, 0x80, 0x8F, 0xC4, 0xFD,
  0x30, 0x8E, 0x0B, 0xD8, 0x35, 0x0D, 0xF7, 0x38, 0x92, 0x4B, 0xEE, 0xB4, 0x05, 0xCF, 0xC5, 0x20,
  0x4A, 0x04, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x30, 0x7A, 0x82, 0xD7, 0x31, 0x77, 0x03, 0x0C, 0xF9,
  0x0B, 0x74, 0x82, 0x48, 0xCE, 0xC0, 0xB5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_alternate_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_alternate_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_app_registration 24x24, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_round_24_communication_app_registration_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x42, 0x84, 0x4D, 0xD4, 0x0D, 0xA0, 0xD2, 0x0D, 0xA0, 0xD2,
  0x0D, 0xA8, 0x1D, 0x0D, 0xA0, 0xD2, 0x0D, 0xA0, 0xD2, 0x0D, 0xA8, 0x4D, 0x04, 0xDD, 0x42, 0x82,
  0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x47, 0x77, 0x77, 0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x44, 0x82,
  0x9B, 0x0D, 0xA0, 0xD2, 0x0D, 0xA0, 0xD3, 0x83, 0x1D, 0xFB, 0xDA, 0x0D, 0x20, 0xDA, 0x08, 0x28,
  0x79, 0x82, 0xD9, 0x4D, 0xD4, 0x28, 0x14, 0xD8, 0x20, 0x9A, 0x08, 0x01, 0x74, 0x09, 0xB0, 0x97,
  0x40, 0x9B, 0x09, 0x38, 0x24, 0xDD, 0x44, 0x09, 0xB0, 0x94, 0x0D, 0xA0, 0xD3, 0x09, 0xB0, 0x95,
  0x0D, 0xA0, 0xD3, 0xB0, 0x96, 0x82, 0x4D, 0xD4, 0x38, 0x1E, 0xF9, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_app_registration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_app_registration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_business 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_24_communication_business_data[] PROGMEM = {
  0x04, 0x0D, 0xE0, 0xD0, 0x47, 0x30, 0xDF, 0x90, 0xD7, 0x3A, 0x2A, 0x2A, 0x73, 0xA2, 0xA2, 0xA7,
  0x3F, 0xFC, 0x0D, 0x04, 0xFF, 0xD0, 0xDA, 0x2A, 0x2A, 0x70, 0x3C, 0x2A, 0x2A, 0x71, 0xFF, 0x2A,
  0x2F, 0xF2, 0xA2, 0xC2, 0xA2, 0xA7, 0x1C, 0x2A, 0x2A, 0x71, 0xFF, 0x2A, 0x2F, 0xF2, 0xA2, 0xC2,
  0xA2, 0xA7, 0x1C, 0x2A, 0x2A, 0x70, 0x3A, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_call_end 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_communication_call_end_data[] PROGMEM = {
  0x68, 0x31, 0x59, 0xCD, 0xA8, 0x2D, 0xC9, 0x57, 0x40, 0x30, 0xBF, 0xD0, 0x90, 0x26, 0x02, 0x0B,
  0xB8, 0x2B, 0x62, 0x12, 0x82, 0x13, 0x7C, 0xB0, 0xA0, 0x13, 0x05, 0x0E, 0xC0, 0x47, 0x10, 0x6C,
  0x82, 0xD4, 0x07, 0xE0, 0x47, 0x10, 0x6E, 0x05, 0x0D, 0xE0, 0x37, 0x10, 0x5E, 0x00, 0xBD, 0x0C,
  0x72, 0x01, 0x0D, 0xD8, 0x19, 0x1D, 0xB0, 0xA7, 0x40, 0x10, 0xCB, 0x0B, 0x28, 0x21, 0xBD, 0x77,
  0x78, 0x18, 0xD9, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_call_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 7, 23, 15), Box(0, 0, 23, 23),
      ic_round_24_communication_call_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_call_made 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_communication_call_made_data[] PROGMEM = {
  0x50, 0xBF, 0x90, 0xB5, 0x0B, 0xFA, 0x73, 0x01, 0x0C, 0xB7, 0x28, 0x21, 0xCF, 0xCA, 0x71, 0x83,
  0x1C, 0xFC, 0x1A, 0x78, 0x31, 0xCF, 0xC1, 0x1A, 0x68, 0x31, 0xCF, 0xC1, 0x2A, 0x58, 0x31, 0xCF,
  0xC1, 0x3A, 0x48, 0x31, 0xCF, 0xC1, 0x4A, 0x38, 0x31, 0xCF, 0xC1, 0x50, 0x0B, 0x28, 0x31, 0xCF,
  0xC1, 0x72, 0x83, 0x1C, 0xFC, 0x17, 0x28, 0x31, 0xCF, 0xC1, 0x73, 0x82, 0x7F, 0xC1, 0x74, 0x81,
  0x17, 0x17, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_call_made() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 18, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_call_made_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_call_merge 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_24_communication_call_merge_data[] PROGMEM = {
  0x50, 0x01, 0x72, 0x82, 0x1D, 0xD1, 0x70, 0x10, 0xDA, 0x0D, 0x01, 0x50, 0x10, 0xDC, 0x0D, 0x01,
  0x40, 0xAE, 0x0A, 0x7A, 0x73, 0xA7, 0x3A, 0x73, 0xA7, 0x3A, 0x72, 0x01, 0xA7, 0x18, 0x21, 0xCF,
  0xC7, 0x86, 0x1C, 0xFC, 0x10, 0x11, 0x38, 0x96, 0x1C, 0xFC, 0x10, 0x1C, 0xC1, 0x01, 0xCF, 0xC1,
  0x28, 0x71, 0xCF, 0xC1, 0xBF, 0xC1, 0x48, 0x51, 0xCF, 0xBA, 0xB1, 0x68, 0x11, 0xBA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_call_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 17, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_call_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_call_missed_outgoing 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_communication_call_missed_outgoing_data[] PROGMEM = {
  0x81, 0x17, 0x17, 0x0B, 0xE8, 0x3B, 0x7F, 0xC1, 0x60, 0xBF, 0x83, 0x1C, 0xFC, 0x17, 0x10, 0x10,
  0xCB, 0x18, 0x31, 0xCF, 0xC1, 0x68, 0x21, 0xCF, 0xCA, 0x28, 0x31, 0xCF, 0xC1, 0x48, 0x31, 0xCF,
  0xC1, 0xA3, 0x83, 0x1C, 0xFC, 0x12, 0x83, 0x1C, 0xFC, 0x11, 0xA4, 0x89, 0x01, 0xCF, 0xC1, 0x1C,
  0xFC, 0x12, 0xA5, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x30, 0x0B, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x76,
  0x82, 0x1B, 0xB1, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_call_missed_outgoing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 16), Box(0, 0, 23, 23),
      ic_round_24_communication_call_missed_outgoing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_call_missed 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_communication_call_missed_data[] PROGMEM = {
  0x0B, 0xE0, 0xB7, 0x81, 0x17, 0x1F, 0x0B, 0x68, 0x21, 0xCF, 0x7B, 0x0C, 0x01, 0x71, 0x83, 0x1C,
  0xFC, 0x1A, 0x82, 0xCF, 0xC1, 0x68, 0x31, 0xCF, 0xC1, 0x1A, 0x83, 0x1C, 0xFC, 0x14, 0x83, 0x1C,
  0xFC, 0x12, 0xA1, 0x83, 0x1C, 0xFC, 0x12, 0x83, 0x1C, 0xFC, 0x13, 0xA2, 0x89, 0x01, 0xCF, 0xC1,
  0x1C, 0xFC, 0x14, 0x00, 0xB3, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x74, 0x01, 0x0C, 0xA0, 0xC0, 0x17,
  0x68, 0x21, 0xBB, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_call_missed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 16), Box(0, 0, 23, 23),
      ic_round_24_communication_call_missed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_call 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_24_communication_call_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xC0, 0x27, 0x50, 0xDC, 0x0A, 0x75, 0x0D, 0xC0, 0xC7, 0x50, 0xBC, 0x0E, 0x75,
  0x09, 0xD7, 0x50, 0x5C, 0x0B, 0x76, 0xB0, 0xC0, 0x17, 0x68, 0x2A, 0xFD, 0x17, 0x78, 0x23, 0xFE,
  0x17, 0x71, 0x81, 0xAF, 0xA7, 0x71, 0x82, 0x1E, 0xF6, 0x77, 0x10, 0x4A, 0x05, 0x77, 0x10, 0x7A,
  0x06, 0x38, 0x51, 0xBF, 0xEC, 0xA2, 0x50, 0x7A, 0x82, 0xA1, 0x1C, 0xD0, 0xC6, 0x83, 0x4E, 0xFE,
  0xDF, 0x70, 0x10, 0xAF, 0xA7, 0x20, 0x30, 0xAE, 0x0D, 0x75, 0x84, 0x59, 0xBE, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_call_received 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_communication_call_received_data[] PROGMEM = {
  0x75, 0x81, 0x17, 0x17, 0x48, 0x21, 0xCF, 0x77, 0x38, 0x31, 0xCF, 0xC1, 0x72, 0x83, 0x1C, 0xFC,
  0x17, 0x28, 0x31, 0xCF, 0xC1, 0x20, 0x0B, 0x58, 0x31, 0xCF, 0xC1, 0x3A, 0x48, 0x31, 0xCF, 0xC1,
  0x4A, 0x38, 0x31, 0xCF, 0xC1, 0x5A, 0x28, 0x31, 0xCF, 0xC1, 0x6A, 0x18, 0x31, 0xCF, 0xC1, 0x7A,
  0x83, 0x1C, 0xFC, 0x17, 0x1A, 0x82, 0xCF, 0xC1, 0x72, 0xB0, 0xC0, 0x17, 0x3F, 0xA0, 0xB5, 0x0B,
  0xF9, 0x0B, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_call_received() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 19, 18), Box(0, 0, 23, 23),
      ic_round_24_communication_call_received_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_call_split 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_communication_call_split_data[] PROGMEM = {
  0x0E, 0xC0, 0x24, 0x02, 0xC0, 0xEC, 0x07, 0x60, 0x7F, 0x0E, 0x01, 0x60, 0x10, 0xED, 0x82, 0xEF,
  0xC1, 0x48, 0x21, 0xCF, 0xEB, 0x84, 0x71, 0xCF, 0xC1, 0x28, 0x61, 0xCF, 0xC1, 0x7F, 0x22, 0x89,
  0x01, 0xCF, 0xC1, 0x04, 0xFC, 0x12, 0x02, 0x48, 0x61, 0xCF, 0xC1, 0x04, 0x17, 0x28, 0x21, 0xCF,
  0xB7, 0x60, 0x1A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0x00, 0xB7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_call_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_call_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_cancel_presentation 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_24_communication_cancel_presentation_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x58, 0x11, 0x71, 0x28, 0x11, 0x71, 0x5C, 0x58, 0x67, 0xFC, 0x11, 0xCF, 0x75, 0xC5, 0x86,
  0x1C, 0xFC, 0xCF, 0xC1, 0x5C, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x6C, 0x60, 0x10, 0xCA, 0x0C, 0x01,
  0x6C, 0x58, 0x61, 0xCF, 0xCC, 0xFC, 0x15, 0xC5, 0x86, 0x7F, 0xC1, 0x1C, 0xF7, 0x5C, 0x58, 0x11,
  0x71, 0x28, 0x11, 0x71, 0x5C, 0x77, 0x4C, 0x77, 0x4C, 0x03, 0x77, 0x20, 0x3A, 0x0D, 0xFF, 0xE8,
  0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_cancel_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_cancel_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_cell_tower 24x24, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_round_24_communication_cell_tower_data[] PROGMEM = {
  0x20, 0x70, 0x57, 0x50, 0x50, 0x73, 0x81, 0x5F, 0x97, 0x58, 0x19, 0xF5, 0x28, 0x3D, 0xE1, 0x03,
  0x71, 0x89, 0x33, 0x01, 0xED, 0x05, 0xF7, 0x09, 0xF1, 0x68, 0x93, 0x1F, 0x90, 0x7F, 0x5A, 0xF1,
  0x2F, 0xB2, 0x81, 0x15, 0x53, 0x89, 0x5C, 0xF2, 0x1F, 0xAD, 0xD0, 0x6F, 0x40, 0x1D, 0xA8, 0x97,
  0xD1, 0x04, 0xF6, 0x0D, 0xDE, 0xB0, 0x9F, 0x10, 0x6C, 0x89, 0x65, 0x01, 0xF9, 0x0B, 0xEE, 0xB0,
  0x9F, 0x10, 0x6C, 0x89, 0x75, 0x01, 0xF9, 0x0B, 0xED, 0xD0, 0x6F, 0x40, 0x1D, 0xA0, 0xD2, 0x89,
  0x24, 0xF6, 0x0D, 0xDA, 0xF1, 0x2F, 0xC2, 0x0C, 0xA0, 0xC2, 0x8D, 0x3B, 0xF2, 0x1F, 0xA5, 0xF7,
  0x09, 0xF1, 0x2F, 0xCC, 0xF2, 0x1F, 0x90, 0x7F, 0x50, 0xDE, 0x10, 0x30, 0x7F, 0x77, 0xF7, 0x02,
  0x01, 0xEE, 0x28, 0x15, 0xF9, 0x38, 0x4C, 0xF2, 0x2F, 0xD3, 0x81, 0x9F, 0x53, 0x07, 0x05, 0x28,
  0x12, 0xFC, 0x28, 0x1C, 0xF2, 0x20, 0x50, 0x77, 0x18, 0x17, 0xF7, 0x28, 0x17, 0xF7, 0x75, 0x0C,
  0xE0, 0xD7, 0x40, 0x2F, 0x90, 0x27, 0x38, 0x17, 0xF7, 0x48, 0x17, 0xF7, 0x73, 0x81, 0x6E, 0x24,
  0x81, 0x1E, 0x65,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_cell_tower() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_cell_tower_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_cell_wifi 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_24_communication_cell_wifi_data[] PROGMEM = {
  0x38, 0x65, 0x9D, 0xEF, 0xDA, 0x57, 0x10, 0x40, 0xDB, 0x81, 0xDD, 0xEA, 0x0D, 0x05, 0x50, 0x6A,
  0x0A, 0x03, 0x40, 0x30, 0x9A, 0x07, 0x48, 0x15, 0xC3, 0x28, 0x21, 0x44, 0x22, 0x81, 0x3B, 0x67,
  0x03, 0x0B, 0xC0, 0xC0, 0x45, 0x06, 0x05, 0x38, 0x4E, 0xFB, 0x88, 0xBA, 0x40, 0x8A, 0x30, 0x40,
  0x34, 0x03, 0x05, 0x30, 0x8B, 0x58, 0x23, 0x9A, 0x34, 0x08, 0xC5, 0x05, 0xA0, 0x73, 0x08, 0xA0,
  0x4A, 0x60, 0x40, 0x53, 0x08, 0xA0, 0x41, 0xA7, 0x30, 0x8B, 0x2A, 0x72, 0x08, 0xC2, 0xA7, 0x10,
  0x8D, 0x2A, 0x70, 0x7E, 0x2A, 0x60, 0x7F, 0x2A, 0x50, 0x7F, 0x92, 0xA4, 0x07, 0xFA, 0x2A, 0x30,
  0x5F, 0xF3, 0x05, 0xFE, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_cell_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_cell_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_chat_bubble_outline 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_24_communication_chat_bubble_outline_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77,
  0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77,
  0x2C, 0x05, 0xFF, 0xA0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x00, 0x57,
  0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_chat_bubble_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_chat_bubble_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_chat_bubble 24x24, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_round_24_communication_chat_bubble_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0B, 0xF7, 0xF0, 0xDF, 0xFC, 0x0D, 0x04,
  0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_chat_bubble() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_chat_bubble_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_chat 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_24_communication_chat_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x0F, 0x03, 0x73, 0x03, 0xF9, 0x03,
  0x73, 0x03, 0xFF, 0xFF, 0x03, 0x73, 0x03, 0xF9, 0x03, 0x73, 0x03, 0xFF, 0xFF, 0x03, 0x60, 0x3F,
  0xD0, 0x36, 0x03, 0x80, 0xF7, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73,
  0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_clear_all 24x24, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_round_24_communication_clear_all_data[] PROGMEM = {
  0x40, 0xBF, 0xD0, 0xB4, 0x0B, 0xFD, 0x0B, 0x80, 0xC2, 0x00, 0xBF, 0xD0, 0xB4, 0x0B, 0xFD, 0x0B,
  0x80, 0xC2, 0x00, 0xBF, 0xD0, 0xB4, 0x0B, 0xFD, 0x0B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_clear_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 16), Box(0, 0, 23, 23),
      ic_round_24_communication_clear_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_comment 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_communication_comment_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x0F, 0x03, 0x73, 0x03, 0xF9, 0x03,
  0x73, 0x03, 0xFF, 0xFF, 0x03, 0x73, 0x03, 0xF9, 0x03, 0x73, 0x03, 0xFF, 0xFF, 0x03, 0x73, 0x03,
  0xF9, 0x03, 0x73, 0x03, 0x80, 0xD0, 0xF0, 0xDF, 0xFD, 0x04, 0x0D, 0xFF, 0xC7, 0x72, 0x07, 0xB7,
  0x73, 0x07, 0xA7, 0x74, 0x07, 0x97, 0x75, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_comments_disabled 24x24, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_24_communication_comments_disabled_data[] PROGMEM = {
  0x03, 0x04, 0x20, 0xAF, 0xF8, 0x3D, 0x4C, 0xF7, 0x20, 0xAF, 0xF0, 0xD0, 0x5A, 0x07, 0x20, 0xAF,
  0xF1, 0xB0, 0x72, 0x0A, 0xFE, 0x1C, 0x07, 0x73, 0x03, 0xC1, 0xD0, 0x77, 0x20, 0x3C, 0x1E, 0x07,
  0x20, 0xAF, 0xB1, 0xC0, 0x7A, 0x07, 0x70, 0x3C, 0x1C, 0x03, 0x05, 0xA0, 0x76, 0x03, 0xC1, 0xFA,
  0x07, 0x20, 0xAF, 0x1C, 0x03, 0x20, 0x5A, 0x07, 0x40, 0x3C, 0x1C, 0x03, 0x30, 0x5A, 0x07, 0x30,
  0x3C, 0x1F, 0xD0, 0x72, 0x0A, 0xC1, 0xFE, 0x07, 0x20, 0xAB, 0x10, 0xDF, 0xE0, 0x72, 0x0A, 0xA1,
  0x04, 0x0D, 0xFE, 0x07, 0x20, 0xA9, 0x77, 0x05, 0xA0, 0x72, 0x0A, 0x77, 0x10, 0x5A, 0x07, 0x77,
  0x40, 0x5A, 0x07, 0x77, 0x40, 0x5A, 0x04, 0x77, 0x48, 0x15, 0xC3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_comments_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_comments_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_contact_emergency 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_24_communication_contact_emergency_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xF9, 0x0D, 0x80, 0xC5, 0xF0, 0x06, 0xFF, 0xE8, 0x48,
  0x42, 0x24, 0x8F, 0xB8, 0x27, 0x11, 0x7C, 0x0A, 0x01, 0x20, 0x10, 0xAF, 0xA0, 0x74, 0x07, 0xB0,
  0xB0, 0x12, 0x01, 0x0A, 0xFA, 0x01, 0x40, 0x1B, 0x84, 0x84, 0x22, 0x48, 0xFA, 0x01, 0x40, 0x1D,
  0x00, 0x6F, 0xC0, 0x74, 0x07, 0xFF, 0xD8, 0x27, 0x11, 0x78, 0x0C, 0x6F, 0x86, 0xD6, 0x31, 0x13,
  0x6D, 0xFF, 0x90, 0x77, 0x10, 0x7F, 0xE0, 0x47, 0x30, 0x4F, 0xC0, 0x77, 0x50, 0x7F, 0x90, 0xDF,
  0xFF, 0x98, 0x1D, 0x4D, 0xFF, 0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_contact_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_contact_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_contact_mail 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_24_communication_contact_mail_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xF9, 0x0D, 0xFF, 0xFF, 0xA8, 0x27, 0x11, 0x7C, 0x01,
  0x60, 0x1F, 0x07, 0x40, 0x7B, 0x10, 0xA0, 0x12, 0x01, 0x0A, 0x1F, 0x01, 0x40, 0x1B, 0x18, 0x45,
  0xC5, 0x5C, 0x51, 0xF0, 0x14, 0x01, 0xB2, 0x82, 0x1A, 0xA1, 0x2F, 0x07, 0x40, 0x7B, 0x71, 0xF9,
  0x82, 0x71, 0x17, 0xC0, 0x16, 0x01, 0xFF, 0xFF, 0xD0, 0x0E, 0xFF, 0xD0, 0x90, 0x53, 0x81, 0x15,
  0x9F, 0xF0, 0xC0, 0x17, 0x10, 0x10, 0xCF, 0xD0, 0x27, 0x30, 0x2F, 0xD7, 0x5F, 0xFF, 0xFE, 0x0D,
  0xFF, 0xF9, 0x81, 0xD4, 0xDF, 0xFE, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_contact_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_contact_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_contact_phone 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_24_communication_contact_phone_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xF9, 0x0D, 0xFF, 0xFF, 0xA8, 0x27, 0x11, 0x7F, 0x90,
  0x70, 0x8F, 0xA0, 0x74, 0x07, 0xE0, 0x82, 0x08, 0xF9, 0x01, 0x40, 0x1D, 0x0D, 0x30, 0x6F, 0x90,
  0x14, 0x01, 0xD0, 0x72, 0x03, 0x0E, 0xF9, 0x07, 0x40, 0x7D, 0x03, 0x04, 0xFD, 0x82, 0x71, 0x17,
  0xE0, 0x10, 0x7F, 0xFF, 0x90, 0x10, 0x7F, 0xE0, 0x0E, 0xF0, 0x30, 0x4F, 0xB0, 0x90, 0x53, 0x81,
  0x15, 0x9C, 0x07, 0x20, 0x30, 0xED, 0x0C, 0x01, 0x71, 0x01, 0x0C, 0xA0, 0xD3, 0x06, 0xD0, 0x27,
  0x30, 0x2B, 0x08, 0x20, 0x8D, 0x75, 0xC0, 0x70, 0x8F, 0xFF, 0xF0, 0xDF, 0xFF, 0x98, 0x1D, 0x4D,
  0xFF, 0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_contact_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_contact_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_contacts 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_24_communication_contacts_data[] PROGMEM = {
  0x20, 0xBF, 0xF0, 0xB4, 0x0B, 0xFF, 0x0B, 0x80, 0xC6, 0x00, 0x40, 0xDF, 0xFA, 0x81, 0xD4, 0xDF,
  0xFC, 0x0D, 0xFA, 0x00, 0xDF, 0xFB, 0x06, 0x20, 0x6F, 0xF9, 0x0D, 0x40, 0xDF, 0xF0, 0xD4, 0x0D,
  0xFF, 0x90, 0x62, 0x06, 0xFF, 0xB0, 0x0D, 0xFF, 0xFF, 0xF8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xFC,
  0x08, 0x71, 0x08, 0xFB, 0x73, 0xFB, 0x73, 0xFF, 0xFC, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0,
  0xD0, 0x48, 0x0C, 0x60, 0x0B, 0xFF, 0x0B, 0x40, 0xBF, 0xF0, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 23), Box(0, 0, 23, 23),
      ic_round_24_communication_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_co_present 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_24_communication_co_present_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x77, 0x4C, 0x38, 0x41, 0xAD, 0xDA, 0x17,
  0x2C, 0x20, 0x10, 0xEC, 0x0E, 0x01, 0x71, 0xC2, 0x0A, 0xE0, 0xA7, 0x1C, 0x20, 0xDE, 0x0D, 0x71,
  0xC2, 0x0D, 0xE0, 0xD7, 0x1C, 0x20, 0xAE, 0x0A, 0x71, 0xC2, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x1A,
  0x58, 0x41, 0xAD, 0xDA, 0x17, 0x2A, 0x77, 0x6A, 0x38, 0x23, 0x8B, 0xDA, 0x82, 0xDB, 0x83, 0x7A,
  0x10, 0x50, 0xCF, 0xB0, 0xC0, 0x55, 0xA0, 0x6F, 0xF0, 0x64, 0xA0, 0xDF, 0xF0, 0xD4, 0xFF, 0xC4,
  0x90, 0xDF, 0xFA, 0x40, 0xD0, 0x4F, 0xFA, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_co_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_co_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_desktop_access_disabled 24x24, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_round_24_communication_desktop_access_disabled_data[] PROGMEM = {
  0x00, 0x17, 0x77, 0x84, 0xDE, 0x30, 0x1D, 0xFF, 0x98, 0x7D, 0x48, 0xFE, 0x30, 0x1D, 0xFF, 0x90,
  0xD1, 0xA0, 0xE0, 0x37, 0x71, 0x03, 0xA1, 0xB0, 0xE0, 0x37, 0x71, 0xA1, 0xA8, 0x29, 0xFE, 0x37,
  0x7A, 0x1A, 0x18, 0x29, 0xFE, 0x37, 0x6A, 0x1A, 0x28, 0x29, 0xFE, 0x37, 0x5A, 0x1A, 0x38, 0x29,
  0xFE, 0x37, 0x4A, 0x1A, 0x48, 0x29, 0xFE, 0x37, 0x3A, 0x1A, 0x58, 0x29, 0xFE, 0x37, 0x2A, 0x1A,
  0x68, 0x29, 0xFE, 0x37, 0x1A, 0x1A, 0x78, 0x29, 0xFE, 0x37, 0xA1, 0xA7, 0x18, 0x29, 0xFE, 0x36,
  0xA1, 0xA0, 0x37, 0x18, 0x29, 0xFE, 0x34, 0x03, 0xA1, 0x0D, 0xFE, 0x83, 0xE3, 0x01, 0xDA, 0x82,
  0xD0, 0x4D, 0xFE, 0x85, 0xE3, 0x01, 0xDD, 0x47, 0x3C, 0x18, 0x29, 0xFE, 0x37, 0x7C, 0x28, 0x29,
  0xFE, 0x37, 0x40, 0xBE, 0x84, 0xB0, 0x9F, 0xE3, 0x73, 0x0B, 0xE0, 0xB2, 0x82, 0x9F, 0xE3, 0x77,
  0x68, 0x19, 0xFC, 0x77, 0x70, 0x60, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_desktop_access_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 22, 23), Box(0, 0, 23, 23),
      ic_round_24_communication_desktop_access_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_dialer_sip 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_24_communication_dialer_sip_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xC0, 0x13, 0x89, 0x0E, 0xFD, 0x0D, 0x0E, 0xFE, 0xDC, 0x09, 0x39, 0x39, 0x19,
  0x19, 0x0E, 0xC0, 0xC3, 0x81, 0xEF, 0xE1, 0x91, 0xA0, 0xE0, 0xBC, 0x0E, 0x59, 0x19, 0x19, 0x20,
  0x9D, 0x38, 0x5D, 0xFE, 0x0D, 0x0D, 0x20, 0x5C, 0x0B, 0x75, 0x01, 0xB0, 0xC0, 0x17, 0x68, 0x2A,
  0xFD, 0x17, 0x78, 0x23, 0xFE, 0x17, 0x71, 0x81, 0xAF, 0x97, 0x71, 0x82, 0x1E, 0xF6, 0x77, 0x10,
  0x5A, 0x04, 0x77, 0x10, 0x7A, 0x06, 0x38, 0x51, 0xBF, 0xEC, 0x91, 0x50, 0x7A, 0x82, 0xA1, 0x1C,
  0xD0, 0xC6, 0x83, 0x4E, 0xFE, 0xDF, 0x70, 0x10, 0xAF, 0xA7, 0x20, 0x30, 0xAE, 0x0D, 0x75, 0x84,
  0x59, 0xBE, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_dialer_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_dialer_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_dialpad 24x24, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_round_24_communication_dialpad_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x42, 0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20,
  0xDA, 0x00, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x83, 0xD4, 0xDD, 0x42, 0x82, 0x4D, 0xD4,
  0x28, 0x24, 0xDD, 0x47, 0x77, 0x74, 0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x42, 0x83, 0x4D, 0xD4,
  0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x00, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x83,
  0xD4, 0xDD, 0x42, 0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x47, 0x77, 0x74, 0x82, 0x4D, 0xD4, 0x28,
  0x24, 0xDD, 0x42, 0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x00, 0xDA, 0x0D,
  0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x83, 0xD4, 0xDD, 0x42, 0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x48,
  0x0C, 0x20, 0x82, 0x4D, 0xD4, 0x75, 0x0D, 0xA0, 0xD7, 0x50, 0xDA, 0x0D, 0x75, 0x82, 0x4D, 0xD4,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_dialpad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_dialpad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_document_scanner 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_24_communication_document_scanner_data[] PROGMEM = {
  0x0B, 0xB0, 0xB7, 0x30, 0xBB, 0x0B, 0xC0, 0xB7, 0x30, 0xBE, 0x77, 0x2C, 0x10, 0x40, 0xDF, 0xB0,
  0xD0, 0x41, 0xA8, 0x2B, 0xB0, 0xDF, 0xD8, 0x2D, 0x0B, 0xB3, 0xFF, 0x6F, 0xF6, 0xC0, 0x34, 0x03,
  0xC6, 0xC0, 0x34, 0x03, 0xC6, 0xFF, 0x6C, 0x03, 0x40, 0x3C, 0x6C, 0x03, 0x40, 0x3C, 0x6F, 0xF6,
  0xC0, 0x34, 0x03, 0xC6, 0xC0, 0x34, 0x03, 0xC6, 0xFF, 0x6F, 0xF3, 0x82, 0xBB, 0x0D, 0xFD, 0x82,
  0xD0, 0xBB, 0xA1, 0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x1C, 0x77, 0x2E, 0x0B, 0x73, 0x0B, 0xC0, 0xBB,
  0x0B, 0x73, 0x0B, 0xB0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_document_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_document_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_domain_disabled 24x24, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_round_24_communication_domain_disabled_data[] PROGMEM = {
  0x81, 0x4C, 0x47, 0x75, 0x85, 0x6F, 0xE4, 0x01, 0xDB, 0x0D, 0x04, 0x74, 0x85, 0x9F, 0xE4, 0x01,
  0xDB, 0x0D, 0x75, 0xA8, 0x2E, 0x40, 0x12, 0xA7, 0x5B, 0x0E, 0x04, 0x3A, 0x75, 0xC8, 0x3E, 0x40,
  0x1D, 0xFA, 0x0D, 0x04, 0x2D, 0x83, 0xE4, 0x01, 0xDF, 0xA0, 0xD2, 0xA2, 0xA8, 0x2E, 0x40, 0x17,
  0x03, 0xA2, 0xA2, 0xB0, 0xE0, 0x47, 0x2A, 0x2F, 0x90, 0xE0, 0x44, 0xA2, 0xA2, 0xFA, 0x0E, 0x04,
  0x3A, 0x2A, 0x2A, 0x2A, 0x2A, 0x0E, 0x04, 0x6A, 0x2A, 0x2A, 0x2B, 0x0E, 0x04, 0x5A, 0x2F, 0xD0,
  0xE0, 0x44, 0xA2, 0xFE, 0x0E, 0x04, 0x3A, 0x2A, 0x2A, 0x2A, 0x28, 0x29, 0xFE, 0x42, 0x0D, 0x92,
  0xA2, 0xA2, 0xA3, 0x85, 0x9F, 0xE4, 0x01, 0xD2, 0x0D, 0xFF, 0x98, 0x2E, 0x40, 0x12, 0x04, 0x0D,
  0xFF, 0x90, 0xE0, 0x47, 0x75, 0x82, 0x9F, 0xE3, 0x77, 0x58, 0x19, 0xFC, 0x77, 0x60, 0x60, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_domain_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 21, 23), Box(0, 0, 23, 23),
      ic_round_24_communication_domain_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_domain_verification 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_24_communication_domain_verification_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xC2, 0xF7, 0x7C, 0x77, 0xC7, 0x18, 0x11,
  0xCE, 0x3C, 0x78, 0x21, 0xCF, 0xD3, 0xC3, 0x86, 0xDA, 0x01, 0xCF, 0xD1, 0x3C, 0x38, 0x5E, 0xFB,
  0xCF, 0xD1, 0x4C, 0x30, 0x20, 0xEA, 0x0D, 0x01, 0x5C, 0x48, 0x22, 0xDD, 0x16, 0xC7, 0x7C, 0x03,
  0x75, 0x03, 0xA0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_domain_verification() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_domain_verification_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_duo 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_24_communication_duo_data[] PROGMEM = {
  0x68, 0x25, 0x9D, 0xEF, 0x90, 0xD0, 0x44, 0x04, 0x0D, 0xFE, 0x0D, 0x30, 0x7F, 0xFA, 0x20, 0x7F,
  0xFB, 0x10, 0x3F, 0xFC, 0x10, 0xCF, 0xFC, 0x04, 0xFF, 0xD0, 0x9C, 0x79, 0x0E, 0x05, 0xD0, 0xCC,
  0x70, 0xA0, 0x11, 0xD0, 0xEC, 0x73, 0xFB, 0x73, 0xC0, 0xE0, 0xDC, 0x70, 0xA0, 0x11, 0xC0, 0xD0,
  0xAC, 0x79, 0x0E, 0x05, 0xC0, 0x90, 0x5F, 0xFC, 0x81, 0x50, 0xDF, 0xFA, 0x0D, 0x20, 0x5F, 0xFA,
  0x04, 0x30, 0x9F, 0xF0, 0x75, 0x09, 0xFD, 0x07, 0x70, 0x50, 0xDF, 0x90, 0xC0, 0x47, 0x38, 0x65,
  0xAD, 0xFE, 0xC9, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_duo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_duo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_email 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_24_communication_email_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x0C, 0x0D, 0xFD, 0x0D, 0x0C, 0xC8, 0x11,
  0x08, 0xFB, 0x81, 0x80, 0x1C, 0x83, 0xA1, 0x03, 0xCE, 0x83, 0xC3, 0x01, 0xAD, 0x0E, 0x06, 0x20,
  0x60, 0xEA, 0x0E, 0x06, 0x20, 0x60, 0xEF, 0x98, 0x90, 0xC3, 0x01, 0xAA, 0x10, 0x3C, 0xFD, 0x08,
  0x40, 0x8F, 0xF9, 0x82, 0xD5, 0x5D, 0x80, 0x9D, 0x0F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0,
  0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_forum 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_communication_forum_data[] PROGMEM = {
  0x04, 0x0D, 0xFC, 0x0D, 0x04, 0x50, 0xDF, 0xE0, 0xD5, 0xFF, 0x95, 0xFF, 0x95, 0xFF, 0x92, 0x90,
  0xD0, 0x4F, 0xF9, 0x2A, 0x0D, 0xFF, 0x92, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF, 0xB0, 0xD2, 0xFF, 0xA0,
  0xD0, 0x42, 0xE0, 0x77, 0x6D, 0x07, 0x76, 0x03, 0xC0, 0x72, 0xFF, 0xA0, 0x73, 0x0D, 0xFF, 0x94,
  0x04, 0x0D, 0xFF, 0x77, 0x20, 0x7B, 0x77, 0x30, 0x7A, 0x77, 0x40, 0x79, 0x77, 0x50, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_forum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_forum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_forward_to_inbox 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_24_communication_forward_to_inbox_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x2D, 0x40, 0xDF, 0xFC, 0x0D, 0x1A, 0x0A, 0x01, 0x75, 0x01, 0x0A, 0xA1,
  0xB0, 0xE0, 0x67, 0x30, 0x60, 0xEB, 0x1A, 0x83, 0x4D, 0xFC, 0x36, 0x83, 0x3C, 0xFD, 0x4A, 0x1A,
  0x20, 0x8A, 0x08, 0x40, 0x8A, 0x08, 0x2A, 0x1A, 0x38, 0x90, 0x3C, 0xFD, 0x44, 0xDF, 0xC3, 0x3A,
  0x1A, 0x50, 0x60, 0xEA, 0x0E, 0x06, 0x5A, 0x1A, 0x68, 0x21, 0x77, 0x16, 0xA1, 0xA7, 0x75, 0xA7,
  0x75, 0xA7, 0x71, 0x02, 0x3A, 0x77, 0x19, 0x07, 0x2A, 0x77, 0x1A, 0x81, 0x70, 0xDF, 0xB2, 0x0B,
  0xE8, 0x17, 0x4D, 0xFA, 0x20, 0xBE, 0x07, 0x77, 0x3A, 0x07, 0x77, 0x49, 0x07, 0x77, 0x50, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_forward_to_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_forward_to_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_hourglass_bottom 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_communication_hourglass_bottom_data[] PROGMEM = {
  0x04, 0x0D, 0xF9, 0x81, 0xD4, 0xDF, 0xB0, 0xDA, 0x03, 0x60, 0x3C, 0x71, 0xC7, 0x1A, 0x81, 0xEF,
  0x26, 0x85, 0x2F, 0xE6, 0xFD, 0x14, 0x87, 0x1D, 0xF6, 0x07, 0xFD, 0x12, 0x82, 0x1D, 0xF7, 0x38,
  0x67, 0xFD, 0x11, 0xDF, 0x75, 0x84, 0x7F, 0xDD, 0xF7, 0x60, 0x7C, 0x07, 0x50, 0x7E, 0x07, 0x30,
  0x7F, 0x98, 0x17, 0x06, 0xFB, 0x06, 0x0E, 0xFB, 0x0E, 0x80, 0xC0, 0xF0, 0xDF, 0xB8, 0x1D, 0x4D,
  0xF9, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_hourglass_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 17, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_hourglass_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_hourglass_top 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_24_communication_hourglass_top_data[] PROGMEM = {
  0x04, 0x0D, 0xF9, 0x81, 0xD4, 0xDF, 0xB0, 0xD8, 0x0C, 0x0F, 0x0E, 0xFB, 0x0E, 0x06, 0xFB, 0x81,
  0x60, 0x7F, 0x90, 0x73, 0x07, 0xE0, 0x75, 0x07, 0xC0, 0x76, 0x84, 0x7F, 0xDD, 0xF7, 0x58, 0x67,
  0xFD, 0x11, 0xDF, 0x73, 0x82, 0x7F, 0xD1, 0x28, 0x71, 0xDF, 0x70, 0x6F, 0xD1, 0x48, 0x51, 0xDF,
  0x6E, 0xF2, 0x68, 0x12, 0xFE, 0xA7, 0x1C, 0x71, 0xC0, 0x36, 0x03, 0xA0, 0xDF, 0xB8, 0x1D, 0x4D,
  0xF9, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_hourglass_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 17, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_hourglass_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_hub 24x24, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_round_24_communication_hub_data[] PROGMEM = {
  0x73, 0x82, 0x8D, 0xD8, 0x77, 0x50, 0x8C, 0x08, 0x77, 0x40, 0xDC, 0x0D, 0x77, 0x40, 0xEC, 0x0E,
  0x77, 0x40, 0x8C, 0x08, 0x77, 0x58, 0x28, 0xEE, 0x87, 0x48, 0x21, 0x66, 0x16, 0x00, 0xB6, 0x85,
  0x16, 0x61, 0x03, 0xEA, 0x0E, 0x03, 0x50, 0x0B, 0x50, 0x30, 0xEA, 0x81, 0xE3, 0xBC, 0x0B, 0x30,
  0x30, 0xBA, 0x0A, 0x03, 0x30, 0xBC, 0x0B, 0x0E, 0xD8, 0x11, 0x05, 0xE8, 0x14, 0x01, 0xD0, 0xE0,
  0xBE, 0x0C, 0x0E, 0xE0, 0xE0, 0xCE, 0x81, 0xB3, 0xEA, 0x82, 0xE4, 0x6C, 0xF9, 0x82, 0xD7, 0x5E,
  0xA8, 0x5E, 0x30, 0x16, 0x61, 0x20, 0x7F, 0x90, 0x72, 0x82, 0x16, 0x61, 0x71, 0x05, 0xF9, 0x05,
  0x77, 0x10, 0xEE, 0x0E, 0x77, 0x20, 0x8E, 0x08, 0x77, 0x18, 0x90, 0x3E, 0xCA, 0xEE, 0xAB, 0xE3,
  0x74, 0x84, 0x8D, 0xDE, 0xD1, 0x48, 0x41, 0xDE, 0xDD, 0x87, 0x08, 0xC0, 0x96, 0x09, 0xC0, 0x86,
  0x0D, 0xC0, 0xE6, 0x0E, 0xC0, 0xD6, 0x0D, 0xC0, 0xD6, 0x0D, 0xC0, 0xD6, 0x08, 0xC0, 0x86, 0x08,
  0xC0, 0x87, 0x82, 0x8D, 0xD8, 0x71, 0x82, 0x8D, 0xD8, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 23, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_import_contacts 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_24_communication_import_contacts_data[] PROGMEM = {
  0x28, 0x51, 0x56, 0x75, 0x41, 0x48, 0x51, 0x57, 0x76, 0x51, 0x20, 0x30, 0xCF, 0x82, 0xC4, 0x4C,
  0xF8, 0x1C, 0x3D, 0xFD, 0x87, 0xEB, 0x97, 0x9B, 0xEF, 0xDF, 0xC0, 0xB0, 0x46, 0x01, 0xFE, 0x72,
  0xFE, 0x72, 0xFE, 0x72, 0xFE, 0x72, 0xFE, 0x72, 0xFE, 0x72, 0xFE, 0x72, 0xFE, 0x72, 0xFE, 0x72,
  0xFE, 0x71, 0x01, 0xA0, 0xEF, 0xB1, 0x89, 0x12, 0x7B, 0xDF, 0xDC, 0xDF, 0xE9, 0xFB, 0x0B, 0xFA,
  0x83, 0x90, 0x45, 0x22, 0x82, 0x12, 0x5A, 0xA8, 0x2A, 0x52, 0x12, 0x81, 0x25, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_import_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_import_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_import_export 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_24_communication_import_export_data[] PROGMEM = {
  0x30, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x20, 0x7C, 0x07, 0x70, 0x2E, 0x02, 0x72, 0xA7, 0x5A, 0x75,
  0xA7, 0x5A, 0x40, 0x0B, 0x6A, 0x4A, 0x6A, 0x4A, 0x60, 0x0B, 0x4A, 0x75, 0xA7, 0x5A, 0x75, 0xA7,
  0x20, 0x2E, 0x02, 0x70, 0x7C, 0x07, 0x72, 0x07, 0xA0, 0x77, 0x40, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_import_export() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_import_export_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_invert_colors_off 24x24, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_round_24_communication_invert_colors_off_data[] PROGMEM = {
  0x73, 0x00, 0x57, 0x20, 0x90, 0x66, 0x08, 0xA0, 0x77, 0x01, 0xA0, 0x74, 0x08, 0xC0, 0x87, 0x05,
  0xA0, 0x72, 0x05, 0xA0, 0x4B, 0x08, 0x70, 0x5A, 0x07, 0x20, 0x90, 0x41, 0xC0, 0x87, 0x05, 0xA0,
  0x74, 0xD0, 0x87, 0x09, 0xA0, 0x73, 0xE0, 0x65, 0x01, 0x0E, 0xB0, 0x72, 0x0A, 0xD0, 0xE0, 0x14,
  0x82, 0x7F, 0xA5, 0xA0, 0x72, 0x0A, 0xD0, 0x74, 0x83, 0xCF, 0x40, 0x5A, 0x07, 0x20, 0xAC, 0x0C,
  0x48, 0x1E, 0xF1, 0x20, 0x5A, 0x07, 0x20, 0xAB, 0x0E, 0x40, 0xE9, 0x40, 0x5A, 0x07, 0x20, 0xAA,
  0x0E, 0x48, 0x1D, 0xF3, 0x40, 0x5A, 0x07, 0x28, 0x1A, 0xFD, 0x48, 0x19, 0xF8, 0x5B, 0x07, 0x20,
  0xA0, 0x94, 0x82, 0x3F, 0xE2, 0x4C, 0x07, 0x20, 0x15, 0x82, 0x9F, 0xD2, 0x3D, 0x07, 0x71, 0x0B,
  0xA0, 0x80, 0x31, 0xE0, 0x77, 0x10, 0x9F, 0x90, 0xAA, 0x07, 0x71, 0x89, 0x02, 0x8C, 0xEF, 0xC9,
  0x20, 0x5A, 0x06, 0x77, 0x38, 0x15, 0xF9, 0x77, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_invert_colors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_invert_colors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_key_off 24x24, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_round_24_communication_key_off_data[] PROGMEM = {
  0x10, 0x90, 0x67, 0x75, 0x01, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x73,
  0x01, 0x0C, 0xB0, 0x77, 0x72, 0x0C, 0xD0, 0x77, 0x70, 0x6B, 0x07, 0x05, 0xA0, 0x77, 0x60, 0xBA,
  0x07, 0x20, 0x5A, 0x07, 0x20, 0xAF, 0x81, 0x70, 0xEA, 0x01, 0x30, 0x5A, 0x07, 0x20, 0xAF, 0x05,
  0x0E, 0xA0, 0x14, 0x05, 0xA0, 0x72, 0x0A, 0xE0, 0x50, 0xCA, 0x07, 0x40, 0x7B, 0x07, 0x20, 0xAC,
  0x81, 0x70, 0x6B, 0x82, 0x71, 0x17, 0xD0, 0x72, 0x07, 0xA0, 0x73, 0x0C, 0xF9, 0x0C, 0x05, 0xA0,
  0x72, 0x00, 0x54, 0x01, 0x0C, 0xE8, 0x2C, 0x10, 0x5A, 0x07, 0x72, 0x84, 0x6C, 0xEE, 0xC6, 0x40,
  0x5A, 0x07, 0x77, 0x50, 0x5A, 0x07, 0x77, 0x50, 0x5A, 0x07, 0x77, 0x50, 0x5A, 0x06, 0x77, 0x58,
  0x15, 0xF9, 0x77, 0x60, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_key 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_24_communication_key_data[] PROGMEM = {
  0x38, 0x46, 0xBE, 0xEC, 0x67, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x75, 0x0C, 0xF9, 0x0C, 0x74, 0x06,
  0xB8, 0x27, 0x11, 0x7B, 0x06, 0x73, 0x0B, 0xA0, 0x74, 0x07, 0xFC, 0x81, 0x70, 0xEA, 0x01, 0x40,
  0x1F, 0xD0, 0x50, 0xEA, 0x01, 0x40, 0x1F, 0xD0, 0x50, 0xCA, 0x07, 0x40, 0x7F, 0xC8, 0x17, 0x06,
  0xB8, 0x27, 0x11, 0x7B, 0x05, 0x07, 0xA0, 0x07, 0xA0, 0x73, 0x0C, 0xF9, 0x0C, 0x20, 0x05, 0x20,
  0x05, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x84, 0x6C, 0xEE, 0xB5, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 22, 17), Box(0, 0, 23, 23),
      ic_round_24_communication_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_list_alt 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_24_communication_list_alt_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0xBF, 0xFE, 0x77, 0xC7, 0x7C, 0x2A, 0x20, 0xBC, 0x0B, 0x2C, 0x2A, 0x20, 0xBC,
  0x0B, 0x2C, 0x77, 0xC7, 0x7C, 0x2A, 0x20, 0xBC, 0x0B, 0x2C, 0x2A, 0x20, 0xBC, 0x0B, 0x2C, 0x77,
  0xC7, 0x7C, 0x2A, 0x20, 0xBC, 0x0B, 0x2C, 0x2A, 0x20, 0xBC, 0x0B, 0x2C, 0x77, 0xC7, 0x7F, 0xFE,
  0x0B, 0xFF, 0xA0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_list_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_list_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_live_help 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_24_communication_live_help_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0xE8, 0x4D, 0x51, 0x15, 0xDF, 0xC0, 0xD0, 0x14,
  0x01, 0x0D, 0xFB, 0x86, 0x50, 0x4D, 0xD4, 0x05, 0xFB, 0x81, 0x41, 0xEA, 0x81, 0xD0, 0x1F, 0xF9,
  0x81, 0xD0, 0x1F, 0xF9, 0x81, 0x40, 0x6F, 0xF8, 0x25, 0x03, 0xEF, 0xE8, 0x29, 0x02, 0xEF, 0xF8,
  0x13, 0x0B, 0xFF, 0x90, 0x30, 0x28, 0x0E, 0x0F, 0x2F, 0xFA, 0x2F, 0x90, 0xDF, 0xFA, 0x81, 0xD4,
  0xDF, 0xF0, 0xD0, 0x46, 0x07, 0xC0, 0x77, 0x60, 0x7A, 0x07, 0x77, 0x10, 0x05, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_live_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_live_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_location_off 24x24, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_round_24_communication_location_off_data[] PROGMEM = {
  0x68, 0x61, 0x7C, 0xEE, 0xC7, 0x14, 0x81, 0x29, 0x22, 0x04, 0x0E, 0xE0, 0xE0, 0x53, 0x85, 0x7F,
  0xD2, 0x02, 0xEF, 0x90, 0x53, 0x85, 0xBF, 0xD2, 0x02, 0xEF, 0x0E, 0x01, 0x38, 0x90, 0xBF, 0xD2,
  0x02, 0xD9, 0x9E, 0xC0, 0x74, 0x82, 0xDF, 0xD2, 0x40, 0x20, 0xEB, 0x0C, 0x40, 0xEA, 0x0D, 0x02,
  0x40, 0x9B, 0x0E, 0x40, 0xEB, 0x0D, 0x02, 0x30, 0x9B, 0x0E, 0x40, 0xCC, 0x0D, 0x02, 0x20, 0xDB,
  0x0C, 0x40, 0x8D, 0x83, 0xD2, 0x03, 0xEA, 0x08, 0x40, 0x3E, 0x85, 0xD2, 0x03, 0xEF, 0x25, 0x0A,
  0xE8, 0x3D, 0x20, 0x3A, 0x60, 0x3F, 0x0D, 0x02, 0x72, 0x0B, 0xF0, 0xD0, 0x27, 0x10, 0x2F, 0x90,
  0xD0, 0x27, 0x10, 0x7E, 0x82, 0xDF, 0xD2, 0x71, 0x0B, 0xC8, 0x4B, 0x0B, 0xFD, 0x27, 0x01, 0x0E,
  0xA0, 0xE0, 0x12, 0x81, 0xBF, 0x97, 0x10, 0x4A, 0x04, 0x40, 0x70, 0x27, 0x20, 0x04, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_location_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_location_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_location_on 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_24_communication_location_on_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x50, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x81,
  0x90, 0x2F, 0xF0, 0x20, 0x8F, 0xF0, 0x80, 0xCD, 0x82, 0xB1, 0x1B, 0xD0, 0xC0, 0xED, 0x01, 0x20,
  0x1D, 0x0E, 0xE0, 0x12, 0x01, 0xE0, 0xDD, 0x82, 0xB1, 0x1B, 0xD0, 0xD0, 0x9F, 0xF0, 0x90, 0x2F,
  0xF8, 0x12, 0x0A, 0xFD, 0x0A, 0x20, 0x10, 0xEF, 0xB0, 0xE0, 0x13, 0x05, 0xFB, 0x05, 0x50, 0x8F,
  0x90, 0x87, 0x0A, 0xE0, 0xA7, 0x20, 0xAC, 0x0A, 0x74, 0x0A, 0xA0, 0xA7, 0x60, 0x07, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_location_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_location_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_mail_lock 24x24, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_24_communication_mail_lock_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x42, 0x0D, 0xFF, 0xC0, 0xD2, 0xA0, 0xC0, 0xDF, 0xD0, 0xD0, 0xCA,
  0x2A, 0x81, 0x10, 0x8F, 0xB8, 0x18, 0x01, 0xA2, 0xA8, 0x3A, 0x10, 0x3C, 0xE8, 0x3C, 0x30, 0x1A,
  0xA2, 0xB0, 0xE0, 0x62, 0x06, 0x0E, 0xA0, 0xE0, 0x62, 0x06, 0x0E, 0xB2, 0xD8, 0x93, 0xC3, 0x01,
  0xAA, 0x10, 0x3C, 0xFA, 0x34, 0xF0, 0x84, 0x08, 0xA0, 0x66, 0xF9, 0x82, 0xD7, 0x7D, 0xA0, 0xA2,
  0x82, 0x4D, 0xD4, 0x1F, 0xF0, 0x32, 0x82, 0xD3, 0x3D, 0x1F, 0xF3, 0x92, 0x91, 0xFF, 0x20, 0xBC,
  0x0B, 0xFF, 0x2F, 0xFE, 0x2E, 0x0D, 0xFE, 0x2E, 0x04, 0x0D, 0xFD, 0x20, 0xBC, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_mail_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_mail_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_mail_outline 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_24_communication_mail_outline_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x0A, 0x01, 0x75, 0x01, 0x0A, 0xD0, 0xE0,
  0x67, 0x30, 0x60, 0xED, 0x83, 0x4D, 0xFC, 0x36, 0x83, 0x3C, 0xFD, 0x4C, 0x20, 0x8A, 0x08, 0x40,
  0x8A, 0x08, 0x2C, 0x38, 0x90, 0x3C, 0xFD, 0x44, 0xDF, 0xC3, 0x3C, 0x50, 0x60, 0xEA, 0x0E, 0x06,
  0x5C, 0x68, 0x21, 0x77, 0x16, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC0, 0x37, 0x70,
  0x3A, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_mail_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_mail_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_mark_chat_read 24x24, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_24_communication_mark_chat_read_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x2D, 0x40, 0xDF, 0xFC, 0x0D, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F,
  0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F, 0xE8, 0x1E, 0x72, 0x20, 0x20, 0x71, 0xFD, 0x0A, 0x71, 0xFC,
  0x0A, 0x72, 0xFB, 0x0E, 0x78, 0x11, 0x82, 0xFB, 0x07, 0x68, 0x21, 0xDF, 0x7F, 0xB8, 0x22, 0x02,
  0x62, 0x82, 0x1D, 0xFC, 0x1F, 0xB2, 0x85, 0xAF, 0xA2, 0xDF, 0xC2, 0xFB, 0x20, 0x30, 0xEB, 0x0C,
  0x3B, 0x07, 0x72, 0x82, 0x3E, 0xFC, 0x4A, 0x07, 0x74, 0x02, 0x07, 0x59, 0x07, 0x77, 0x50, 0x77,
  0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_mark_chat_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_mark_chat_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_mark_chat_unread 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_24_communication_mark_chat_unread_data[] PROGMEM = {
  0x77, 0x18, 0x28, 0xDD, 0x87, 0x71, 0x08, 0xC8, 0x18, 0x4D, 0xFB, 0x20, 0xDC, 0x00, 0xDF, 0xC2,
  0x0D, 0xC0, 0xDF, 0xD8, 0x13, 0x08, 0xC0, 0x8F, 0xD0, 0xA2, 0x82, 0x8D, 0xD8, 0x1F, 0xE0, 0x76,
  0xFF, 0x84, 0xA3, 0x01, 0x4B, 0x80, 0xAD, 0x7F, 0x0D, 0xFF, 0xC0, 0xD0, 0x4B, 0x07, 0x77, 0x2A,
  0x07, 0x77, 0x39, 0x07, 0x77, 0x40, 0x77, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_mark_chat_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_mark_chat_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_mark_email_read 24x24, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_round_24_communication_mark_email_read_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x2D, 0x40, 0xDF, 0xFC, 0x0D, 0x1A, 0x0C, 0x0D, 0xFD, 0x0D, 0x0C, 0xA1,
  0xA8, 0x11, 0x08, 0xFB, 0x81, 0x80, 0x1A, 0x1A, 0x83, 0xA1, 0x03, 0xCE, 0x83, 0xC3, 0x01, 0xAA,
  0x1B, 0x0E, 0x06, 0x20, 0x60, 0xEA, 0x0E, 0x06, 0x20, 0x60, 0xEB, 0x1D, 0x89, 0x0C, 0x30, 0x1A,
  0xA1, 0x03, 0xCD, 0x1F, 0x08, 0x40, 0x8F, 0x1F, 0x98, 0x6D, 0x55, 0xDF, 0xE7, 0x22, 0x02, 0x07,
  0x1F, 0xD0, 0xA7, 0x1F, 0xC0, 0xA7, 0x2F, 0xB0, 0xE7, 0x81, 0x18, 0x2F, 0xB0, 0x76, 0x82, 0x1D,
  0xF7, 0xFB, 0x82, 0x20, 0x26, 0x28, 0x41, 0xDF, 0xC0, 0xDF, 0xA2, 0x85, 0xAF, 0xA2, 0xDF, 0xC2,
  0x04, 0x0D, 0xF9, 0x20, 0x30, 0xEB, 0x0C, 0x77, 0x28, 0x23, 0xEF, 0xC7, 0x74, 0x02, 0x07, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_mark_email_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_mark_email_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_mark_email_unread 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_24_communication_mark_email_unread_data[] PROGMEM = {
  0x77, 0x18, 0x28, 0xDD, 0x87, 0x71, 0x08, 0xC8, 0x18, 0x4D, 0xFB, 0x20, 0xDC, 0x00, 0xDF, 0xC2,
  0x0D, 0xC0, 0xDA, 0x0C, 0x0D, 0xF9, 0x81, 0x40, 0x8C, 0x08, 0xA8, 0x11, 0x08, 0xF0, 0xB2, 0x82,
  0x8D, 0xD8, 0x1A, 0x83, 0xA1, 0x03, 0xCE, 0x05, 0x6B, 0x0E, 0x06, 0x20, 0x60, 0xEA, 0x0E, 0x06,
  0x28, 0x33, 0x11, 0x4B, 0xD8, 0x90, 0xC3, 0x01, 0xAA, 0x10, 0x3C, 0xFD, 0x08, 0x40, 0x8F, 0xF9,
  0x82, 0xD5, 0x5D, 0x80, 0x9D, 0x0F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_mark_email_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_mark_email_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_mark_unread_chat_alt 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_24_communication_mark_unread_chat_alt_data[] PROGMEM = {
  0x77, 0x18, 0x28, 0xDD, 0x87, 0x71, 0x08, 0xC8, 0x18, 0x4D, 0xFB, 0x20, 0xDC, 0x00, 0xDF, 0xC2,
  0x0D, 0xC0, 0xDF, 0xD8, 0x14, 0x08, 0xC0, 0x8F, 0xD0, 0xB2, 0x82, 0x8D, 0xD8, 0x1C, 0x03, 0x77,
  0x1C, 0x03, 0x75, 0x81, 0x14, 0xBF, 0xFF, 0xB0, 0x37, 0x30, 0x3F, 0x90, 0x37, 0x30, 0x3F, 0xFF,
  0xF0, 0x36, 0x03, 0xFD, 0x03, 0x60, 0x38, 0x0F, 0x7F, 0x0D, 0xFF, 0xC0, 0xD0, 0x4B, 0x07, 0x77,
  0x2A, 0x07, 0x77, 0x30, 0x05, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_mark_unread_chat_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_mark_unread_chat_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_message 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_24_communication_message_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x0F, 0x03, 0x73, 0x03, 0xF9, 0x03,
  0x73, 0x03, 0xFF, 0xFF, 0x03, 0x73, 0x03, 0xF9, 0x03, 0x73, 0x03, 0xFF, 0xFF, 0x03, 0x73, 0x03,
  0xF9, 0x03, 0x73, 0x03, 0x80, 0xF3, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77,
  0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_message() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_message_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_mobile_screen_share 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_24_communication_mobile_screen_share_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C,
  0x50, 0x20, 0x53, 0xC5, 0x81, 0x5F, 0x62, 0xC3, 0x07, 0x0E, 0xB0, 0x61, 0xC2, 0x09, 0xD0, 0x61,
  0xC1, 0x85, 0x4E, 0x95, 0x6F, 0x62, 0xC1, 0x07, 0x01, 0x20, 0x20, 0x53, 0xC7, 0x3C, 0x73, 0xC7,
  0x3C, 0x73, 0xFF, 0xFF, 0xA0, 0xDF, 0xD8, 0x1D, 0x4D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_mobile_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_mobile_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_more_time 24x24, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_24_communication_more_time_data[] PROGMEM = {
  0x77, 0x20, 0x0B, 0x77, 0x5A, 0x71, 0x84, 0x49, 0xDE, 0xEC, 0x5A, 0x60, 0x20, 0xBE, 0x20, 0xBE,
  0x0B, 0x28, 0x73, 0xEF, 0xE7, 0x20, 0x13, 0x20, 0xBE, 0x84, 0xB0, 0x2E, 0xFA, 0x74, 0xA4, 0x81,
  0xBF, 0xA4, 0x0C, 0x05, 0x6A, 0x38, 0x14, 0xFE, 0x59, 0x07, 0x60, 0x0B, 0x38, 0x19, 0xF7, 0x59,
  0x07, 0x74, 0x81, 0xDF, 0x25, 0x90, 0x77, 0x40, 0xE9, 0x69, 0x07, 0x6A, 0x30, 0xE9, 0x68, 0x1E,
  0xB2, 0x59, 0x0E, 0x38, 0x1D, 0xF2, 0x58, 0x24, 0xDF, 0x73, 0x81, 0x2F, 0xD3, 0x81, 0x9F, 0x77,
  0x81, 0x8F, 0xD2, 0x81, 0x7F, 0x93, 0x81, 0x4F, 0xE7, 0x10, 0x20, 0x82, 0x81, 0xEF, 0x44, 0x81,
  0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x58, 0x22, 0xEF, 0xA7, 0x18, 0x2A, 0xFE, 0x26, 0x84, 0x3E, 0xFE,
  0x72, 0x28, 0x42, 0x7E, 0xFE, 0x37, 0x10, 0x20, 0xBF, 0x90, 0xB0, 0x27, 0x48, 0x64, 0x9D, 0xEE,
  0xD9, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_more_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_more_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_nat 24x24, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_round_24_communication_nat_data[] PROGMEM = {
  0x48, 0x2A, 0xDA, 0x57, 0x74, 0x0C, 0xB0, 0xD0, 0x57, 0x73, 0x81, 0x26, 0xCA, 0x08, 0x77, 0x50,
  0x6A, 0x08, 0x77, 0x50, 0x4A, 0x05, 0x77, 0x58, 0x16, 0xFD, 0x77, 0x68, 0x1C, 0xF5, 0x72, 0x82,
  0x8D, 0xE8, 0x68, 0x16, 0xFA, 0x40, 0x93, 0x08, 0xC0, 0x85, 0x81, 0x2F, 0xD4, 0x98, 0x5C, 0x20,
  0xDF, 0x33, 0xE2, 0xF9, 0x84, 0xE4, 0xDF, 0x33, 0xE2, 0xF9, 0x81, 0xE4, 0x8C, 0x08, 0x58, 0x12,
  0xFD, 0x49, 0x0C, 0x02, 0x28, 0x28, 0xDE, 0x86, 0x81, 0x6F, 0xA4, 0x09, 0x77, 0x81, 0xCF, 0x57,
  0x74, 0x81, 0x6F, 0xD7, 0x74, 0x04, 0xA0, 0x47, 0x73, 0x06, 0xA0, 0x87, 0x71, 0x81, 0x26, 0xCA,
  0x08, 0x77, 0x10, 0xCB, 0x0D, 0x04, 0x77, 0x28, 0x2A, 0xDA, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_nat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_nat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_no_sim 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_24_communication_no_sim_data[] PROGMEM = {
  0x70, 0x7F, 0x0D, 0x04, 0x30, 0xA0, 0x73, 0x07, 0xFA, 0x0D, 0x28, 0x21, 0xEF, 0x82, 0x09, 0xFB,
  0x30, 0x4A, 0x08, 0x20, 0x9F, 0xA4, 0x04, 0xA0, 0x82, 0x09, 0xF9, 0x5B, 0x08, 0x20, 0x9F, 0x5C,
  0x08, 0x20, 0x9E, 0x5D, 0x08, 0x20, 0x9D, 0x5E, 0x08, 0x20, 0x9C, 0x5F, 0x08, 0x20, 0x9B, 0x5F,
  0x90, 0x82, 0x09, 0xA5, 0xFA, 0x08, 0x20, 0x99, 0x5F, 0xB0, 0x82, 0x09, 0x5F, 0xC0, 0x87, 0xFD,
  0x08, 0x6F, 0xE0, 0x85, 0x0D, 0xFE, 0x08, 0x40, 0x40, 0xDF, 0xB0, 0xDA, 0x07, 0x77, 0x28, 0x14,
  0xFA, 0x77, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_pause_presentation 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_24_communication_pause_presentation_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x60, 0x0B, 0x20, 0x0B, 0x6C, 0x6A, 0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x6A,
  0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x60, 0x0B, 0x20, 0x0B, 0x6C, 0x77, 0x4C, 0x77,
  0x4C, 0x03, 0x77, 0x20, 0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_pause_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_pause_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_person_add_disabled 24x24, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_round_24_communication_person_add_disabled_data[] PROGMEM = {
  0x81, 0x3B, 0x37, 0x76, 0x82, 0x6F, 0xE3, 0x77, 0x68, 0x29, 0xFE, 0x37, 0x84, 0x1A, 0xDD, 0xA1,
  0x78, 0x29, 0xFE, 0x35, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x82, 0x9F, 0xE3, 0x40, 0xAE, 0x0A, 0x71,
  0xA0, 0xE0, 0x33, 0x0D, 0xE0, 0xD7, 0x1B, 0x0E, 0x03, 0x20, 0xDE, 0x0D, 0x71, 0xA8, 0x59, 0xFE,
  0x30, 0x1D, 0xD0, 0xA5, 0x0B, 0xF8, 0x3E, 0x30, 0x1D, 0xB0, 0xE0, 0x15, 0x0B, 0xF9, 0x86, 0xE3,
  0x01, 0xDD, 0xA1, 0x72, 0xA3, 0x82, 0x9F, 0xE3, 0x77, 0xA4, 0x82, 0x9F, 0xE3, 0x76, 0x00, 0xB4,
  0x83, 0x2D, 0xFE, 0x32, 0x81, 0x87, 0x27, 0x40, 0x30, 0xBC, 0x86, 0xE3, 0x01, 0xDF, 0xB3, 0x71,
  0x04, 0xF8, 0x3E, 0x30, 0x1D, 0xA0, 0x47, 0x0D, 0xF9, 0x85, 0xE3, 0x01, 0xDF, 0xD7, 0xFB, 0x83,
  0xE3, 0x01, 0xD9, 0x70, 0xBF, 0xB8, 0x3E, 0x30, 0x19, 0x77, 0x38, 0x29, 0xFE, 0x37, 0x76, 0x82,
  0x9F, 0xE3, 0x77, 0x68, 0x19, 0xFB, 0x77, 0x70, 0x60, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_person_add_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 22, 23), Box(0, 0, 23, 23),
      ic_round_24_communication_person_add_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_person_search 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_24_communication_person_search_data[] PROGMEM = {
  0x58, 0x41, 0xAD, 0xDA, 0x17, 0x60, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x0A, 0xE0, 0xA7, 0x50, 0xDE,
  0x0D, 0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xAE, 0x0A, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x68, 0x41,
  0xAD, 0xDA, 0x17, 0x76, 0x84, 0x2A, 0xEE, 0xA1, 0x76, 0x02, 0x0E, 0xC0, 0xE0, 0x15, 0x89, 0x52,
  0x7A, 0xDE, 0x30, 0xAF, 0xB1, 0x1B, 0xF9, 0x30, 0x30, 0xBD, 0x28, 0x1E, 0xF1, 0x28, 0x11, 0xFE,
  0x20, 0x4F, 0x28, 0x1E, 0xF1, 0x28, 0x11, 0xFE, 0x20, 0xDF, 0x89, 0x03, 0x0A, 0xFB, 0x11, 0xBF,
  0x92, 0xF9, 0x82, 0x80, 0x2E, 0xD8, 0x2C, 0x10, 0xBF, 0x98, 0x91, 0x30, 0x2A, 0xDD, 0x9D, 0xFC,
  0x17, 0x72, 0x82, 0x1D, 0xF7, 0x77, 0x38, 0x11, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_person_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_person_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_phone_disabled 24x24, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_round_24_communication_phone_disabled_data[] PROGMEM = {
  0x10, 0x90, 0x67, 0x40, 0x20, 0xBA, 0x81, 0xD4, 0x1A, 0x07, 0x73, 0x09, 0xC8, 0x1D, 0x05, 0xA0,
  0x77, 0x20, 0xCC, 0x0E, 0x20, 0x5A, 0x07, 0x71, 0x0E, 0xC0, 0xC3, 0x05, 0xA0, 0x77, 0xD0, 0x94,
  0x05, 0xA0, 0x76, 0x0B, 0xC0, 0x55, 0x05, 0xA0, 0x75, 0x01, 0x0C, 0xB0, 0x16, 0x05, 0xA0, 0x75,
  0x82, 0x1D, 0xFB, 0x71, 0x05, 0xA0, 0x74, 0x82, 0x1E, 0xF3, 0x72, 0x05, 0xA0, 0x73, 0x81, 0xAF,
  0xB7, 0x40, 0x5A, 0x07, 0x28, 0x1A, 0xE1, 0x75, 0x05, 0xA0, 0x72, 0x03, 0x58, 0x51, 0x9C, 0xEF,
  0xB1, 0x20, 0x5A, 0x07, 0x70, 0xCD, 0x82, 0xC1, 0x1A, 0xB0, 0x76, 0xF8, 0x3D, 0xEF, 0xE8, 0xA0,
  0x75, 0xFA, 0x82, 0xB1, 0x05, 0xA0, 0x74, 0x0D, 0xE0, 0xA0, 0x34, 0x05, 0xA0, 0x73, 0x85, 0x4D,
  0xEC, 0x95, 0x17, 0x05, 0xA0, 0x67, 0x73, 0x81, 0x5F, 0x97, 0x74, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_phone_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_phone_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_phone_enabled 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_24_communication_phone_enabled_data[] PROGMEM = {
  0x75, 0x02, 0x0B, 0xA0, 0xD0, 0x47, 0x50, 0x9C, 0x0D, 0x75, 0x0C, 0xC0, 0xE7, 0x50, 0xEC, 0x0B,
  0x75, 0xD0, 0x97, 0x50, 0xBC, 0x05, 0x75, 0x01, 0x0C, 0xB0, 0x17, 0x68, 0x21, 0xDF, 0xA7, 0x78,
  0x21, 0xEF, 0x37, 0x78, 0x1A, 0xFA, 0x77, 0x82, 0x6F, 0xE2, 0x76, 0x04, 0xA0, 0x53, 0x85, 0x19,
  0xCE, 0xFB, 0x13, 0x06, 0xA0, 0x74, 0x0C, 0xD8, 0x2C, 0x11, 0xAA, 0x07, 0x5F, 0x83, 0xDE, 0xFE,
  0x56, 0xFA, 0x0A, 0x02, 0x70, 0xDE, 0x0A, 0x03, 0x72, 0x85, 0x4D, 0xEB, 0x95, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_phone_enabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_phone_enabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_phonelink_erase 24x24, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_24_communication_phonelink_erase_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xB0, 0xD0, 0x44, 0x0D, 0xFD, 0x0D, 0x4F, 0xF4, 0xA7, 0x3A, 0x40, 0x0B, 0x73,
  0xA7, 0x72, 0xA0, 0x03, 0x60, 0x03, 0x6A, 0x81, 0x8F, 0x44, 0x81, 0x4F, 0x86, 0xA1, 0x81, 0xAF,
  0x42, 0x81, 0x4F, 0xA7, 0xA2, 0x84, 0xAF, 0x44, 0xFA, 0x71, 0xA3, 0x0A, 0xA0, 0xA7, 0x2A, 0x30,
  0x5A, 0x05, 0x72, 0xA2, 0x84, 0x4F, 0xAA, 0xF4, 0x71, 0xA1, 0x81, 0x4F, 0xA2, 0x81, 0xAF, 0x47,
  0xA8, 0x14, 0xFA, 0x48, 0x1A, 0xF4, 0x6A, 0x07, 0x09, 0x60, 0x90, 0x76, 0xA7, 0x72, 0xA4, 0x00,
  0xB7, 0x3A, 0x4A, 0x73, 0xA4, 0xFF, 0x40, 0xDF, 0xD0, 0xD4, 0x04, 0x0D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_phonelink_erase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_phonelink_erase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_phonelink_lock 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_24_communication_phonelink_lock_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x20, 0xDF, 0xD0, 0xD2, 0xFF, 0x2F, 0xF2, 0xFF, 0x2A, 0x73, 0xA2,
  0xA7, 0x7A, 0x72, 0x82, 0x4D, 0xD4, 0x1A, 0x72, 0x82, 0xD3, 0x3D, 0x1A, 0x72, 0x92, 0x91, 0xA7,
  0x10, 0xBC, 0x0B, 0xA7, 0x1F, 0x97, 0x1F, 0x97, 0x1F, 0x97, 0x10, 0xBC, 0x0B, 0xA7, 0x7A, 0x73,
  0xA2, 0xFF, 0x2F, 0xF2, 0xFF, 0x20, 0xDF, 0xD0, 0xD2, 0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_phonelink_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_phonelink_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_phonelink_ring 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_24_communication_phonelink_ring_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x60, 0xDF, 0xD0, 0xD6, 0xFF, 0x6A, 0x73, 0xA6, 0xA7, 0x3A, 0x6A,
  0x73, 0xA6, 0xA7, 0x3A, 0x6A, 0x73, 0xA3, 0x07, 0x0B, 0x1A, 0x73, 0xA3, 0x81, 0x4F, 0x5A, 0x73,
  0xA1, 0x83, 0x86, 0x0C, 0xBA, 0x73, 0xA1, 0x83, 0xBC, 0x09, 0xDA, 0x73, 0xA1, 0x83, 0xBC, 0x0A,
  0xDA, 0x73, 0xA1, 0x83, 0x75, 0x0D, 0xAA, 0x73, 0xA3, 0x81, 0x5F, 0x4A, 0x73, 0xA3, 0x06, 0x09,
  0x1A, 0x73, 0xA6, 0xA7, 0x3A, 0x6A, 0x73, 0xA6, 0xA7, 0x3A, 0x6F, 0xF6, 0x0D, 0xFD, 0x0D, 0x60,
  0x40, 0xDF, 0xB0, 0xD0, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_phonelink_ring() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_phonelink_ring_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_phonelink_setup 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_round_24_communication_phonelink_setup_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xB0, 0xD0, 0x44, 0x0D, 0xFD, 0x0D, 0x4F, 0xF4, 0xA7, 0x3A, 0x40, 0x0B, 0x73,
  0xA7, 0x72, 0xA3, 0x04, 0xA0, 0x47, 0x2A, 0x18, 0x15, 0x2A, 0xA8, 0x1A, 0x26, 0x7A, 0x05, 0xF9,
  0x05, 0x6A, 0x0B, 0xA8, 0x2B, 0x11, 0xBA, 0x0A, 0x6A, 0x82, 0x1D, 0xF1, 0x28, 0x21, 0xFD, 0x16,
  0xA8, 0x21, 0xDF, 0x12, 0x82, 0x1F, 0xD1, 0x6A, 0x0B, 0xA8, 0x2B, 0x11, 0xBA, 0x0A, 0x6A, 0x05,
  0xF9, 0x04, 0x6A, 0x18, 0x16, 0x2A, 0xA8, 0x1A, 0x25, 0x7A, 0x30, 0x4A, 0x04, 0x72, 0xA7, 0x72,
  0xA4, 0x00, 0xB7, 0x3A, 0x4A, 0x73, 0xA4, 0xFF, 0x40, 0xDF, 0xD0, 0xD4, 0x04, 0x0D, 0xFB, 0x0D,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_phonelink_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_phonelink_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_phone 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_24_communication_phone_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xC0, 0x27, 0x50, 0xDC, 0x0A, 0x75, 0x0D, 0xC0, 0xC7, 0x50, 0xBC, 0x0E, 0x75,
  0x09, 0xD7, 0x50, 0x5C, 0x0B, 0x76, 0xB0, 0xC0, 0x17, 0x68, 0x2A, 0xFD, 0x17, 0x78, 0x23, 0xFE,
  0x17, 0x71, 0x81, 0xAF, 0xA7, 0x71, 0x82, 0x1E, 0xF6, 0x77, 0x10, 0x4A, 0x05, 0x77, 0x10, 0x7A,
  0x06, 0x38, 0x51, 0xBF, 0xEC, 0xA2, 0x50, 0x7A, 0x82, 0xA1, 0x1C, 0xD0, 0xC6, 0x83, 0x4E, 0xFE,
  0xDF, 0x70, 0x10, 0xAF, 0xA7, 0x20, 0x30, 0xAE, 0x0D, 0x75, 0x84, 0x59, 0xBE, 0xD4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_portable_wifi_off 24x24, 4-bit Alpha,  RLE, 172 bytes.
static const unsigned char ic_round_24_communication_portable_wifi_off_data[] PROGMEM = {
  0x10, 0x14, 0x86, 0x5A, 0xDF, 0xED, 0x95, 0x68, 0x16, 0xF8, 0x20, 0x7F, 0x90, 0xD0, 0x44, 0x03,
  0xA0, 0x82, 0x81, 0x87, 0x22, 0x81, 0x26, 0xCA, 0x08, 0x40, 0x4A, 0x08, 0x72, 0x06, 0xA0, 0x83,
  0x04, 0xB0, 0x82, 0x83, 0x5E, 0xEC, 0x62, 0x04, 0xA0, 0x42, 0x81, 0xDF, 0x9A, 0x08, 0x20, 0x9B,
  0x89, 0x2C, 0x10, 0x6F, 0xD0, 0x5F, 0xC0, 0x5A, 0x08, 0x28, 0x31, 0x5D, 0xFC, 0x28, 0x6C, 0xF5,
  0xAF, 0x60, 0x5B, 0x08, 0x38, 0x95, 0x1D, 0xF6, 0x06, 0xF9, 0xDF, 0x20, 0xBF, 0x9A, 0x08, 0x38,
  0x65, 0xFC, 0x02, 0xFD, 0xE9, 0x28, 0x2E, 0xF1, 0x4A, 0x08, 0x28, 0x11, 0xFE, 0x29, 0x00, 0xE9,
  0x20, 0xE9, 0x20, 0xDA, 0x08, 0x20, 0x90, 0xE2, 0x98, 0x91, 0xEC, 0xF2, 0x0C, 0xF5, 0x04, 0xDA,
  0x08, 0x28, 0x93, 0x50, 0x2F, 0xDA, 0xF7, 0x06, 0xFD, 0x12, 0x04, 0xA0, 0x83, 0x84, 0x7F, 0xA4,
  0xFC, 0x28, 0x1C, 0xF8, 0x30, 0x4A, 0x08, 0x28, 0x91, 0x8F, 0x50, 0xDF, 0x70, 0x1A, 0x44, 0x04,
  0xA0, 0x82, 0x07, 0x20, 0x4A, 0x04, 0x71, 0x04, 0xA0, 0x85, 0x08, 0xA0, 0x47, 0x10, 0x4A, 0x08,
  0x58, 0x18, 0xF8, 0x72, 0x04, 0xA0, 0x65, 0x01, 0x74, 0x81, 0x4E, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_portable_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_portable_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_present_to_all 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_24_communication_present_to_all_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x03, 0x77, 0x20, 0x3C, 0x77, 0x4C, 0x77,
  0x4C, 0x71, 0x00, 0x77, 0x1C, 0x70, 0x7A, 0x07, 0x7C, 0x60, 0x7C, 0x07, 0x6C, 0x50, 0x7E, 0x07,
  0x5C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x77, 0x4C, 0x77, 0x4C, 0x03, 0x77, 0x20,
  0x3A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_present_to_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_present_to_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_print_disabled 24x24, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_round_24_communication_print_disabled_data[] PROGMEM = {
  0x81, 0x4D, 0x47, 0x75, 0x05, 0xA0, 0x42, 0x09, 0xFB, 0x0B, 0x50, 0x8A, 0x82, 0x40, 0x1C, 0xFB,
  0x60, 0x8A, 0x82, 0x40, 0x1C, 0xFA, 0x70, 0x8A, 0x82, 0x40, 0x1C, 0xF0, 0xB7, 0x10, 0x8A, 0x04,
  0x77, 0x30, 0x80, 0xEB, 0x82, 0x40, 0x1C, 0xF0, 0xD0, 0x83, 0x08, 0xE8, 0x24, 0x01, 0xCF, 0x90,
  0x82, 0x0D, 0xF8, 0x24, 0x01, 0xCC, 0x82, 0x33, 0xFD, 0x2F, 0xA8, 0x24, 0x01, 0xCB, 0x00, 0x3A,
  0x2F, 0xB8, 0x24, 0x01, 0xCE, 0x2F, 0xC8, 0x24, 0x01, 0xCD, 0x2E, 0x30, 0x8A, 0x82, 0x40, 0x1C,
  0xC2, 0x0D, 0xD4, 0x08, 0xA8, 0x24, 0x01, 0xCA, 0x0D, 0x20, 0x40, 0xDC, 0x50, 0x8A, 0x84, 0x40,
  0x1C, 0xD4, 0x6A, 0x60, 0x8A, 0x04, 0x73, 0xA0, 0x36, 0x0A, 0xA0, 0x47, 0x20, 0xDF, 0xD0, 0x47,
  0x10, 0x40, 0xDF, 0x90, 0xD0, 0xAA, 0x04, 0x77, 0x50, 0x8A, 0x04, 0x77, 0x58, 0x18, 0xFC, 0x77,
  0x60, 0x50, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_print_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 21, 23), Box(0, 0, 23, 23),
      ic_round_24_communication_print_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_qr_code_2 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_24_communication_qr_code_2_data[] PROGMEM = {
  0x0B, 0xC0, 0xB3, 0xA1, 0x0B, 0xC8, 0x4B, 0xFB, 0x77, 0xB9, 0x3A, 0x19, 0x82, 0xB7, 0x7B, 0xA8,
  0x27, 0x88, 0x79, 0x1A, 0x39, 0x82, 0x78, 0x87, 0xA8, 0x27, 0x88, 0x79, 0x1A, 0x39, 0x82, 0x78,
  0x87, 0xA8, 0x2B, 0x77, 0xB9, 0x1C, 0x19, 0x84, 0xB7, 0x7B, 0xFB, 0xC0, 0xB1, 0xC1, 0x0B, 0xC0,
  0xB7, 0x74, 0xA2, 0xE4, 0xA2, 0xA2, 0xE4, 0xA4, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA7,
  0x1A, 0x6A, 0x0B, 0xC0, 0xB2, 0xA6, 0xB8, 0x2B, 0x77, 0xB9, 0x2A, 0x2C, 0x29, 0x82, 0x78, 0x87,
  0x92, 0xA2, 0xC2, 0x98, 0x27, 0x88, 0x79, 0x2A, 0x4A, 0x29, 0x82, 0xB7, 0x7B, 0x94, 0xA2, 0xC0,
  0xBC, 0x0B, 0x4A, 0x2C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_qr_code_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_qr_code_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_qr_code 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_24_communication_qr_code_data[] PROGMEM = {
  0x04, 0x0D, 0xC0, 0xD0, 0x42, 0x04, 0x0D, 0xC8, 0x1D, 0x4D, 0xE0, 0xD2, 0x0D, 0xE0, 0xDA, 0x4A,
  0x2A, 0x4C, 0x4A, 0x2A, 0x4C, 0x4A, 0x2A, 0x4C, 0x4A, 0x2A, 0x4A, 0x0D, 0xE0, 0xD2, 0x0D, 0xE8,
  0x1D, 0x4D, 0xC0, 0xD0, 0x42, 0x04, 0x0D, 0xC0, 0xD0, 0x48, 0x0C, 0x00, 0x04, 0x0D, 0xC0, 0xD0,
  0x42, 0x00, 0xE2, 0x00, 0xE2, 0x0D, 0xE0, 0xD2, 0x00, 0xE2, 0x00, 0xE2, 0xA4, 0xA4, 0x00, 0xE2,
  0x00, 0xEA, 0x4A, 0x40, 0x0E, 0x20, 0x0E, 0xA4, 0xA2, 0x00, 0xE2, 0x00, 0xE2, 0xA4, 0xA2, 0x00,
  0xE2, 0x00, 0xE2, 0x0D, 0xE0, 0xD4, 0x00, 0xE2, 0x82, 0xEE, 0x4D, 0xC0, 0xD0, 0x44, 0x00, 0xE2,
  0x00, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_qr_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_qr_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_qr_code_scanner 24x24, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_round_24_communication_qr_code_scanner_data[] PROGMEM = {
  0x0B, 0xB0, 0xB7, 0x30, 0xBB, 0x0B, 0xC0, 0xB7, 0x30, 0xBE, 0x77, 0x2C, 0x1E, 0x2E, 0x1A, 0x86,
  0xBB, 0x0F, 0xB7, 0x7B, 0x92, 0x98, 0x6B, 0x77, 0xBF, 0x0B, 0xB3, 0x90, 0x72, 0x07, 0x92, 0x90,
  0x72, 0x07, 0x96, 0x90, 0x72, 0x07, 0x92, 0x90, 0x72, 0x07, 0x96, 0x98, 0x2B, 0x77, 0xB9, 0x29,
  0x82, 0xB7, 0x7B, 0x96, 0xE2, 0xE8, 0x0D, 0x20, 0xE2, 0x98, 0x27, 0x0F, 0x77, 0x98, 0x2B, 0x77,
  0xB9, 0x28, 0x02, 0x76, 0x90, 0x72, 0x07, 0x93, 0x82, 0x7F, 0x07, 0x96, 0x90, 0x72, 0x07, 0x92,
  0x98, 0x27, 0x0F, 0x74, 0x86, 0xBB, 0x0F, 0xB7, 0x7B, 0x92, 0x80, 0x27, 0x10, 0x0B, 0xA1, 0xE3,
  0x82, 0x7F, 0x07, 0x91, 0xC7, 0x72, 0xE0, 0xB7, 0x30, 0xBC, 0x0B, 0xB0, 0xB7, 0x30, 0xBB, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_qr_code_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_qr_code_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_read_more 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_24_communication_read_more_data[] PROGMEM = {
  0x60, 0x24, 0x0B, 0xF0, 0xB6, 0x90, 0x73, 0x0B, 0xF0, 0xB6, 0xA0, 0x77, 0x73, 0xB0, 0x77, 0x30,
  0xBF, 0xA0, 0x73, 0x0B, 0xC0, 0x0B, 0xFA, 0x07, 0x30, 0xBC, 0x0B, 0x6B, 0x07, 0x77, 0x2A, 0x07,
  0x77, 0x39, 0x07, 0x30, 0xBF, 0x0B, 0x60, 0x24, 0x0B, 0xF0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_read_more() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 16), Box(0, 0, 23, 23),
      ic_round_24_communication_read_more_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_ring_volume 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_24_communication_ring_volume_data[] PROGMEM = {
  0x74, 0x00, 0xC7, 0x77, 0x1A, 0x77, 0x71, 0xA7, 0x78, 0x14, 0x91, 0x5A, 0x58, 0x11, 0x94, 0x68,
  0x29, 0xFC, 0x14, 0x00, 0xC4, 0x82, 0x1C, 0xF9, 0x68, 0x21, 0xCF, 0xC7, 0x38, 0x2C, 0xFC, 0x17,
  0x82, 0x1C, 0xF4, 0x71, 0x82, 0x4F, 0xC1, 0x73, 0x04, 0x73, 0x04, 0x80, 0xF1, 0x08, 0x25, 0x9C,
  0xDA, 0x83, 0xDC, 0x95, 0x17, 0x30, 0x20, 0xAF, 0xD0, 0xA0, 0x36, 0x01, 0x0A, 0xB8, 0x2C, 0x73,
  0x12, 0x82, 0x12, 0x6B, 0xB0, 0xB0, 0x23, 0x04, 0x0E, 0xC0, 0x67, 0x10, 0x4C, 0x82, 0xE5, 0x05,
  0xE0, 0x67, 0x10, 0x4E, 0x07, 0x0C, 0xE0, 0x57, 0x10, 0x3E, 0x0D, 0x09, 0xD0, 0xD0, 0x17, 0x20,
  0xCD, 0x81, 0xA0, 0xCB, 0x0B, 0x01, 0x74, 0x0A, 0xB0, 0xD0, 0x12, 0x81, 0xAD, 0x87, 0x78, 0x27,
  0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_ring_volume() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_ring_volume_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_rss_feed 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_24_communication_rss_feed_data[] PROGMEM = {
  0x82, 0x27, 0x41, 0x75, 0x0D, 0xB8, 0x1D, 0x71, 0x72, 0x0C, 0xE0, 0x80, 0x17, 0x82, 0x15, 0x8C,
  0xC0, 0xE0, 0x47, 0x30, 0x20, 0x8C, 0x06, 0x74, 0x02, 0x0B, 0xB0, 0x64, 0x82, 0x5B, 0x83, 0x40,
  0x9B, 0x04, 0x30, 0xEB, 0x0C, 0x03, 0x30, 0x9A, 0x0E, 0x01, 0x20, 0x9D, 0x06, 0x30, 0xBA, 0x08,
  0x38, 0x11, 0x7D, 0xB0, 0x62, 0x02, 0xB0, 0x15, 0x09, 0xB0, 0x32, 0x08, 0xA0, 0x72, 0x03, 0x04,
  0x20, 0x9A, 0x0C, 0x20, 0x2A, 0x81, 0xD0, 0x7A, 0x0C, 0x20, 0xDA, 0x03, 0x20, 0xCA, 0x01, 0x0E,
  0xB8, 0x14, 0x07, 0xA0, 0x82, 0x08, 0xA0, 0x40, 0xCB, 0x81, 0x30, 0x1A, 0x0B, 0x20, 0x5A, 0x83,
  0x63, 0xCE, 0x73, 0x81, 0x9E, 0x52, 0x82, 0x1C, 0xD2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_rss_feed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_rss_feed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_rtt 24x24, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_round_24_communication_rtt_data[] PROGMEM = {
  0x70, 0x70, 0xEF, 0xA0, 0xB0, 0x16, 0x02, 0xFD, 0x08, 0x20, 0xCA, 0x0E, 0x05, 0xA8, 0x1A, 0x9A,
  0xA8, 0x1B, 0x9A, 0xA0, 0x92, 0x0D, 0xA0, 0xB0, 0x8A, 0x81, 0x10, 0x5A, 0x81, 0x30, 0x3A, 0x07,
  0x68, 0x1A, 0xFE, 0x20, 0x7A, 0x81, 0x10, 0x5A, 0x04, 0x68, 0x1C, 0xFC, 0x28, 0x19, 0xFE, 0x20,
  0x7A, 0x81, 0x20, 0x7B, 0x82, 0x48, 0xF6, 0x28, 0x1C, 0xFB, 0x28, 0x13, 0xFC, 0x20, 0x7B, 0x02,
  0x58, 0x1E, 0xF9, 0x77, 0x20, 0x1A, 0x06, 0x77, 0x20, 0x4A, 0x04, 0x60, 0x10, 0xDC, 0x0D, 0x30,
  0x6A, 0x02, 0x60, 0x10, 0xDC, 0x0A, 0x30, 0x9A, 0x77, 0x38, 0x1B, 0xFC, 0x77, 0x38, 0x1D, 0xFA,
  0x70, 0x8D, 0x03, 0x3A, 0x07, 0x70, 0x9D, 0x82, 0x11, 0x8A, 0xA0, 0xC0, 0x77, 0x60, 0xAE, 0x06,
  0x75, 0x05, 0x0E, 0xC0, 0xE0, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_rtt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_rtt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_screen_share 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_24_communication_screen_share_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x40, 0xDF, 0xFC, 0x0D, 0x4F, 0xFE, 0x4F, 0xC0, 0x7F, 0x94,
  0xFC, 0x10, 0x6F, 0x4F, 0x98, 0x1D, 0x73, 0x20, 0x5E, 0x4F, 0x09, 0x60, 0x6D, 0x4E, 0x09, 0x70,
  0xBD, 0x4D, 0x87, 0xD0, 0x15, 0x9A, 0x01, 0xCE, 0x4D, 0x81, 0x76, 0xEB, 0x01, 0x0D, 0xF4, 0xD0,
  0xAD, 0x0D, 0xF9, 0x4F, 0xFE, 0x40, 0xDF, 0xFC, 0x0D, 0x40, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x20,
  0xBF, 0xFF, 0x90, 0x0B, 0xFF, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_send_time_extension 24x24, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_24_communication_send_time_extension_data[] PROGMEM = {
  0x78, 0x13, 0x73, 0x77, 0x20, 0x6B, 0x06, 0x77, 0x10, 0xDB, 0x0D, 0x72, 0x04, 0x0D, 0xFE, 0x0D,
  0x04, 0x30, 0xDF, 0xF9, 0x0D, 0x3F, 0xFB, 0x3F, 0xFB, 0x3F, 0x90, 0xEF, 0x93, 0x0D, 0xF8, 0x11,
  0x7E, 0xE4, 0x02, 0x0C, 0xD2, 0x81, 0x17, 0xEC, 0x50, 0x3D, 0x48, 0x11, 0x7E, 0xA6, 0xD2, 0x0B,
  0x03, 0x28, 0x11, 0x7E, 0x50, 0x3D, 0x2A, 0x0B, 0x03, 0x20, 0x14, 0x02, 0x0C, 0xD2, 0xC0, 0xB0,
  0x34, 0x0D, 0xF2, 0xE0, 0xB0, 0x32, 0xF9, 0x28, 0x21, 0x59, 0xDC, 0x0B, 0x03, 0xF9, 0x28, 0x21,
  0x59, 0xDC, 0x0B, 0x03, 0xE0, 0xC0, 0x32, 0xE0, 0xB0, 0x32, 0x0D, 0xD0, 0x23, 0xC0, 0xB0, 0x34,
  0x04, 0x0D, 0xB0, 0xD4, 0xA0, 0xB0, 0x37, 0x72, 0x0B, 0x03, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_send_time_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_send_time_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_sentiment_satisfied_alt 24x24, 4-bit Alpha,  RLE, 156 bytes.
static const unsigned char ic_round_24_communication_sentiment_satisfied_alt_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x67, 0x58, 0x56, 0xFD, 0x05, 0xFC, 0x28, 0x18, 0xE8, 0x48, 0x18, 0xE8,
  0x28, 0x4C, 0xF5, 0xAF, 0x62, 0x81, 0xEF, 0xE4, 0x81, 0xEF, 0xE2, 0x84, 0x6F, 0x9D, 0xF2, 0x28,
  0x18, 0xE8, 0x48, 0x18, 0xE8, 0x28, 0x22, 0xFD, 0xE9, 0x77, 0x29, 0x00, 0xE9, 0x77, 0x29, 0x82,
  0xED, 0xF2, 0x30, 0x17, 0x38, 0x42, 0xFD, 0xAF, 0x62, 0x81, 0xAD, 0x14, 0x81, 0x1D, 0xA2, 0x84,
  0x6F, 0x95, 0xFC, 0x28, 0x90, 0x3E, 0xD5, 0x11, 0x5D, 0xE3, 0x28, 0x5C, 0xF5, 0x0D, 0xF6, 0x20,
  0x30, 0xDC, 0x0D, 0x03, 0x28, 0x16, 0xFD, 0x20, 0x4A, 0x04, 0x38, 0x24, 0x66, 0x43, 0x04, 0xA0,
  0x43, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x50, 0x8A, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCA, 0x08,
  0x70, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_sentiment_satisfied_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_sentiment_satisfied_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_sip 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_24_communication_sip_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0F, 0x3F, 0x03, 0x38, 0x42, 0xF3, 0x3F,
  0x33, 0x03, 0xE1, 0x82, 0x37, 0x7A, 0x92, 0x91, 0x81, 0x37, 0x31, 0xE1, 0x82, 0x13, 0x37, 0x92,
  0x91, 0x81, 0x37, 0x31, 0xE8, 0x27, 0x33, 0x11, 0x92, 0x94, 0x03, 0xE8, 0x2A, 0x77, 0x31, 0x92,
  0x91, 0x07, 0xFA, 0x02, 0x38, 0x53, 0xF3, 0x3F, 0x2A, 0x80, 0xF6, 0xF0, 0xDF, 0xFC, 0x81, 0xD4,
  0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_speaker_phone 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_24_communication_speaker_phone_data[] PROGMEM = {
  0x48, 0x66, 0xAD, 0xEE, 0xDA, 0x66, 0x07, 0x0E, 0xF9, 0x0E, 0x07, 0x20, 0x10, 0xCA, 0x81, 0xB5,
  0x22, 0x81, 0x25, 0xBA, 0x84, 0xC1, 0x3F, 0xD3, 0x71, 0x84, 0x3D, 0xF3, 0x02, 0x28, 0x11, 0x8C,
  0xA8, 0x1C, 0x81, 0x20, 0x24, 0x03, 0x0E, 0xE0, 0xE0, 0x36, 0x89, 0x05, 0xFB, 0x41, 0x14, 0xBF,
  0x58, 0x0C, 0x30, 0x0B, 0xE0, 0xB7, 0x1F, 0x97, 0x19, 0x69, 0x71, 0x96, 0x97, 0x19, 0x69, 0x71,
  0x96, 0x97, 0x19, 0x69, 0x71, 0x96, 0x97, 0x19, 0x69, 0x71, 0x96, 0x97, 0x1F, 0x97, 0x10, 0xBE,
  0x0B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_speaker_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_speaker_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_spoke 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_24_communication_spoke_data[] PROGMEM = {
  0x68, 0x41, 0xAD, 0xDA, 0x17, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x73, 0x0A, 0xE0, 0xA7, 0x30, 0xDE,
  0x0D, 0x73, 0x0D, 0xE0, 0xD7, 0x30, 0xAE, 0x0A, 0x73, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x48, 0x41,
  0xAD, 0xDA, 0x18, 0x0C, 0x70, 0x84, 0x1A, 0xDD, 0xA1, 0x48, 0x71, 0xAD, 0xDA, 0x10, 0x1E, 0xC0,
  0xE0, 0x12, 0x01, 0x0E, 0xC8, 0x1E, 0x1A, 0xE0, 0xA2, 0x0A, 0xE0, 0xA0, 0xDE, 0x0D, 0x20, 0xDE,
  0x00, 0xDE, 0x0D, 0x20, 0xDE, 0x0D, 0x0A, 0xE0, 0xA2, 0x0A, 0xE8, 0x1A, 0x1E, 0xC0, 0xE0, 0x12,
  0x01, 0x0E, 0xC8, 0x7E, 0x10, 0x1A, 0xDD, 0xA1, 0x48, 0x41, 0xAD, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_spoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_spoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_stay_current_landscape 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_24_communication_stay_current_landscape_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDC, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77,
  0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xC0, 0xDF, 0xFE, 0x81,
  0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_stay_current_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_round_24_communication_stay_current_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_stay_current_portrait 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_24_communication_stay_current_portrait_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C,
  0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3F, 0xFF,
  0xFA, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_stay_current_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_stay_current_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_stay_primary_landscape 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_24_communication_stay_primary_landscape_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDC, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77,
  0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xC0, 0xDF, 0xFE, 0x81,
  0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_stay_primary_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_round_24_communication_stay_primary_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_stay_primary_portrait 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_24_communication_stay_primary_portrait_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C,
  0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3F, 0xFF,
  0xFA, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_stay_primary_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_stay_primary_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_stop_screen_share 24x24, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_round_24_communication_stop_screen_share_data[] PROGMEM = {
  0x18, 0x13, 0xE6, 0x77, 0x70, 0x3A, 0x06, 0x77, 0x70, 0x9A, 0x06, 0x20, 0xAF, 0xC0, 0xD0, 0x44,
  0x0D, 0xB0, 0x62, 0x0A, 0xFC, 0x0D, 0x4D, 0x06, 0x20, 0xAF, 0xC4, 0xE0, 0x62, 0x81, 0xAF, 0xBF,
  0x94, 0xF0, 0x62, 0x81, 0xA0, 0x6F, 0x4F, 0x90, 0x64, 0x05, 0xE4, 0xFA, 0x06, 0x40, 0x6D, 0x4E,
  0x09, 0x05, 0xA0, 0x63, 0x0B, 0xD4, 0xD8, 0x2D, 0x01, 0xAA, 0x06, 0x20, 0xAD, 0x4D, 0x81, 0x77,
  0xEC, 0x06, 0x20, 0xAC, 0x4D, 0x0B, 0xF0, 0x62, 0x0A, 0xB4, 0xFF, 0x06, 0x20, 0xAA, 0x40, 0xDF,
  0xF0, 0x62, 0x0A, 0x0D, 0x40, 0x40, 0xDF, 0xF0, 0x62, 0x03, 0x20, 0xBF, 0xFC, 0x06, 0x28, 0x1A,
  0xBB, 0xFF, 0xD0, 0x62, 0x07, 0x77, 0x40, 0x5A, 0x06, 0x77, 0x78, 0x15, 0xFB, 0x77, 0x71, 0x02,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_stop_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_stop_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_swap_calls 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_24_communication_swap_calls_data[] PROGMEM = {
  0x48, 0x41, 0x9D, 0xE9, 0x15, 0x00, 0x76, 0x01, 0x0E, 0xC0, 0xD0, 0x13, 0x07, 0xA0, 0x75, 0x86,
  0x9F, 0xB1, 0x1B, 0xF9, 0x20, 0x7C, 0x07, 0x48, 0x1D, 0xF2, 0x28, 0x31, 0xFD, 0x02, 0xE0, 0x23,
  0xA4, 0xA4, 0xA6, 0xA4, 0xA4, 0xA6, 0xA4, 0xA4, 0xA6, 0xA4, 0xA4, 0xA6, 0xA4, 0xA4, 0xA6, 0xA4,
  0xA4, 0xA6, 0xA4, 0xA4, 0xA3, 0x02, 0xE8, 0x32, 0x0D, 0xF1, 0x28, 0x12, 0xFD, 0x40, 0x7C, 0x07,
  0x28, 0x69, 0xFB, 0x11, 0xBF, 0x95, 0x07, 0xA0, 0x73, 0x01, 0x0D, 0xC0, 0xE0, 0x16, 0x00, 0x75,
  0x84, 0x19, 0xED, 0x91, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_swap_calls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_round_24_communication_swap_calls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_textsms 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_24_communication_textsms_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x09, 0xC5, 0xF2, 0xA2, 0xA2, 0xFB, 0x2A,
  0x2A, 0x28, 0x09, 0xF0, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x90,
  0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_textsms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_round_24_communication_textsms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_unsubscribe 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_24_communication_unsubscribe_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x82, 0xD4, 0x0D, 0xFF, 0xA0, 0xD1, 0xA0, 0x0B, 0xFB, 0x00, 0xBA, 0x1A, 0x82,
  0x10, 0x3B, 0xE8, 0x2B, 0x30, 0x1A, 0x1A, 0x0B, 0x03, 0x20, 0x30, 0xBA, 0x0B, 0x03, 0x20, 0x30,
  0xBA, 0x1C, 0x0B, 0x03, 0x20, 0x03, 0x20, 0x30, 0xBC, 0x1E, 0x0B, 0x03, 0x20, 0x30, 0xBE, 0x1F,
  0x90, 0x0D, 0xF9, 0x1F, 0xE8, 0x3E, 0x97, 0xAE, 0x1F, 0xD0, 0x86, 0xFC, 0x85, 0x80, 0x4C, 0xEC,
  0x41, 0xFB, 0x81, 0xE0, 0x4D, 0x04, 0x0D, 0xFA, 0x81, 0x90, 0xCD, 0x81, 0xC4, 0xDF, 0x98, 0x28,
  0x0E, 0x93, 0x09, 0x0E, 0x75, 0x0C, 0xD0, 0xC7, 0x50, 0x4D, 0x04, 0x76, 0x83, 0x4C, 0xEC, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_unsubscribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 19), Box(0, 0, 23, 23),
      ic_round_24_communication_unsubscribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_voicemail 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_24_communication_voicemail_data[] PROGMEM = {
  0x28, 0x52, 0x9D, 0xFD, 0x92, 0x68, 0x52, 0x9D, 0xFD, 0x92, 0x30, 0x40, 0xED, 0x0E, 0x04, 0x40,
  0x40, 0xED, 0x89, 0x4E, 0x40, 0x1E, 0xFA, 0x30, 0x3A, 0xFE, 0x12, 0x89, 0x41, 0xEF, 0xA3, 0x03,
  0xAF, 0xE1, 0x9F, 0xA5, 0x81, 0xAF, 0x92, 0x81, 0x9F, 0xA5, 0x84, 0xAF, 0x9D, 0xF3, 0x58, 0x13,
  0xFD, 0x28, 0x1D, 0xF3, 0x58, 0x13, 0xFD, 0xA7, 0xA2, 0xA7, 0xA8, 0x1D, 0xF3, 0x58, 0x13, 0xFD,
  0x28, 0x1D, 0xF3, 0x58, 0x43, 0xFD, 0x9F, 0xA5, 0x81, 0xAF, 0x92, 0x81, 0x9F, 0xA5, 0x89, 0x4A,
  0xF9, 0x1E, 0xFA, 0x30, 0x3A, 0xFE, 0x22, 0x89, 0x42, 0xEF, 0xA3, 0x03, 0xAF, 0xE1, 0x04, 0xEF,
  0xFC, 0x0E, 0x04, 0x38, 0x12, 0x9D, 0xFF, 0x81, 0xD9, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_voicemail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 23, 16), Box(0, 0, 23, 23),
      ic_round_24_communication_voicemail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_vpn_key_off 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_round_24_communication_vpn_key_off_data[] PROGMEM = {
  0x10, 0x90, 0x67, 0x75, 0x01, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x73,
  0x01, 0x0C, 0xB0, 0x77, 0x72, 0x0C, 0xD0, 0x77, 0x70, 0x6F, 0x07, 0x76, 0x0B, 0xB8, 0x1B, 0x15,
  0xA0, 0x72, 0x0A, 0xF8, 0x1D, 0x4E, 0xB0, 0x12, 0x05, 0xA0, 0x72, 0x0A, 0xF0, 0xD0, 0xEB, 0x01,
  0x20, 0x1B, 0x07, 0x20, 0xAE, 0x0D, 0x0C, 0xB8, 0x2B, 0x11, 0xBC, 0x07, 0x20, 0xAC, 0x81, 0xD4,
  0x6F, 0xD0, 0x72, 0x0A, 0xB3, 0x0C, 0xF9, 0x0C, 0x05, 0xA0, 0x72, 0x0A, 0xA3, 0x01, 0x0C, 0xE8,
  0x2C, 0x10, 0x5A, 0x07, 0x20, 0xA0, 0xD5, 0x84, 0x6C, 0xEE, 0xC6, 0x40, 0x5A, 0x07, 0x20, 0x37,
  0x72, 0x05, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x67, 0x75, 0x81, 0x5F, 0x97,
  0x76, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_vpn_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 22), Box(0, 0, 23, 23),
      ic_round_24_communication_vpn_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_vpn_key 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_24_communication_vpn_key_data[] PROGMEM = {
  0x38, 0x46, 0xBE, 0xEC, 0x67, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x75, 0x0C, 0xF9, 0x0C, 0x74, 0x06,
  0xFB, 0x06, 0x73, 0x0B, 0xB8, 0x2B, 0x11, 0xBF, 0xD8, 0x1D, 0x4E, 0xB0, 0x12, 0x01, 0xFE, 0x0D,
  0x0E, 0xB0, 0x12, 0x01, 0xFE, 0x0D, 0x0C, 0xB8, 0x2B, 0x11, 0xBF, 0xD8, 0x1D, 0x46, 0xFB, 0x05,
  0x4C, 0x30, 0xCF, 0x90, 0xC5, 0xC3, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0x0D, 0xA0, 0xD5, 0x84, 0x6C,
  0xEE, 0xB5, 0x78, 0x24, 0xDD, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_vpn_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 22, 17), Box(0, 0, 23, 23),
      ic_round_24_communication_vpn_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_24_communication_wifi_calling 24x24, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_round_24_communication_wifi_calling_data[] PROGMEM = {
  0x04, 0x0D, 0xA0, 0xB0, 0x13, 0x89, 0x11, 0x6B, 0xDF, 0xEB, 0x61, 0x0D, 0xC0, 0x92, 0x06, 0x0E,
  0xF8, 0x1E, 0x6E, 0xC0, 0xC2, 0x08, 0xFA, 0x08, 0x0C, 0xC0, 0xE3, 0x0B, 0xF8, 0x1B, 0x09, 0xD3,
  0x01, 0x0E, 0xD8, 0x2E, 0x10, 0x6C, 0x0B, 0x40, 0x3D, 0x03, 0x20, 0x1B, 0x0C, 0x01, 0x50, 0x7B,
  0x07, 0x48, 0x2B, 0xFD, 0x17, 0x81, 0xAF, 0xA5, 0x82, 0x4F, 0xE1, 0x71, 0x0A, 0x78, 0x1A, 0xF9,
  0x77, 0x20, 0x2A, 0x06, 0x77, 0x20, 0x5A, 0x04, 0x77, 0x20, 0x8A, 0x06, 0x38, 0x51, 0xBF, 0xEC,
  0x91, 0x60, 0x7A, 0x82, 0x91, 0x1C, 0xD0, 0xB7, 0x05, 0xA0, 0xE0, 0xDE, 0x0E, 0x71, 0x02, 0x0A,
  0xFA, 0x73, 0x04, 0x0B, 0xE0, 0xD7, 0x58, 0x51, 0x69, 0xCE, 0xD4, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_24_communication_wifi_calling() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 20), Box(0, 0, 23, 23),
      ic_round_24_communication_wifi_calling_data, Alpha4(color::Black));
  return value;
}
