#include "editor.h"

using namespace roo_display;

// Image file ic_round_18_editor_add_chart 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_editor_add_chart_data[] PROGMEM = {
  0x10, 0x28, 0x01, 0x30, 0x23, 0x02, 0x20, 0x2E, 0x0B, 0x20, 0x50, 0xE2, 0x04, 0x97, 0x08, 0xA8,
  0x1E, 0x24, 0x94, 0x87, 0x44, 0x02, 0x9F, 0x50, 0x49, 0x40, 0x0A, 0x20, 0x20, 0x82, 0x86, 0x4F,
  0x05, 0x70, 0xAA, 0x68, 0x64, 0xF0, 0x9B, 0x0A, 0xA4, 0x8F, 0x1B, 0x24, 0xF0, 0x9B, 0x0A, 0xA0,
  0x97, 0x0F, 0x44, 0xF0, 0x9B, 0x0A, 0xA0, 0xB9, 0x0F, 0x44, 0xF0, 0x9B, 0x0A, 0xA0, 0xB9, 0x0F,
  0x44, 0xF0, 0x34, 0x04, 0x40, 0x43, 0x0F, 0x44, 0x97, 0x39, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28,
  0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_add_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_add_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_add_comment 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_editor_add_comment_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3E, 0x00, 0xCE, 0x00, 0x3E, 0x00,
  0x5E, 0x00, 0x3E, 0x00, 0x5E, 0x00, 0x3B, 0x0E, 0x60, 0xEB, 0x00, 0x3C, 0x84, 0xB9, 0x33, 0x9B,
  0xC0, 0x03, 0xE0, 0x05, 0xE0, 0x03, 0xE0, 0x09, 0xE0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x10, 0x3A,
  0x09, 0x80, 0x67, 0x83, 0x40, 0x3F, 0x77, 0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_add_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_add_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_align_horizontal_center 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_editor_align_horizontal_center_data[] PROGMEM = {
  0x60, 0x03, 0x75, 0x00, 0xB7, 0x50, 0x0B, 0x75, 0x00, 0xB6, 0x04, 0x80, 0x1B, 0x00, 0xE8, 0x01,
  0xB0, 0x40, 0xAF, 0xD0, 0xA0, 0x28, 0x01, 0x70, 0x0D, 0x80, 0x17, 0x02, 0x60, 0x0B, 0x75, 0x00,
  0xB7, 0x20, 0xF7, 0x00, 0xD0, 0xF7, 0x50, 0x6F, 0x90, 0x64, 0x89, 0x02, 0xAB, 0xBE, 0xEB, 0xBA,
  0x27, 0x10, 0x0B, 0x75, 0x00, 0xB7, 0x50, 0x0B, 0x75, 0x00, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_align_horizontal_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_align_horizontal_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_align_horizontal_left 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_editor_align_horizontal_left_data[] PROGMEM = {
  0x01, 0x05, 0x77, 0x07, 0x97, 0x70, 0x79, 0x77, 0x07, 0x97, 0x78, 0x37, 0xF0, 0x2A, 0x80, 0x5B,
  0x84, 0xA2, 0x7F, 0x06, 0xFC, 0x06, 0x07, 0x92, 0x80, 0x77, 0x10, 0x79, 0x77, 0x07, 0x97, 0x70,
  0x79, 0x28, 0x02, 0x70, 0x35, 0x82, 0x7F, 0x06, 0xE0, 0xE5, 0x83, 0x7F, 0x02, 0xA8, 0x01, 0xB0,
  0x75, 0x07, 0x97, 0x70, 0x79, 0x77, 0x07, 0x97, 0x70, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_align_horizontal_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_align_horizontal_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_align_horizontal_right 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_editor_align_horizontal_right_data[] PROGMEM = {
  0x77, 0x05, 0x01, 0x77, 0x90, 0x77, 0x79, 0x07, 0x77, 0x98, 0x17, 0x2A, 0x80, 0x5B, 0x84, 0xA2,
  0x0F, 0x76, 0xFC, 0x82, 0x60, 0xF7, 0x18, 0x07, 0x72, 0x90, 0x77, 0x79, 0x07, 0x77, 0x90, 0x75,
  0x03, 0x80, 0x27, 0x29, 0x07, 0x50, 0xEE, 0x82, 0x60, 0xF7, 0x50, 0x78, 0x01, 0xB8, 0x3A, 0x20,
  0xF7, 0x77, 0x90, 0x77, 0x79, 0x07, 0x77, 0x90, 0x77, 0x70, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_align_horizontal_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_align_horizontal_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_align_vertical_bottom 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_editor_align_vertical_bottom_data[] PROGMEM = {
  0x40, 0x20, 0x67, 0x78, 0x1A, 0xF7, 0x76, 0x81, 0xBF, 0x77, 0x68, 0x1B, 0xF7, 0x76, 0x81, 0xBF,
  0x77, 0x68, 0x1B, 0xF7, 0x28, 0x13, 0xE7, 0x71, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB7, 0x18, 0x1B,
  0xF7, 0x28, 0x17, 0xFB, 0x71, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB7, 0x18, 0x1B, 0xF7, 0x28, 0x17,
  0xFB, 0x71, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB7, 0x18, 0x1A, 0xF7, 0x28, 0x17, 0xFA, 0x71, 0x02,
  0x06, 0x40, 0x60, 0x27, 0x76, 0x05, 0xFF, 0x05, 0x01, 0x80, 0x92, 0x70, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_align_vertical_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_align_vertical_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_align_vertical_center 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_editor_align_vertical_center_data[] PROGMEM = {
  0x48, 0x14, 0xA2, 0x76, 0x81, 0xBF, 0x77, 0x68, 0x1B, 0xF7, 0x30, 0x60, 0x27, 0x18, 0x1B, 0xF7,
  0x28, 0x17, 0xFA, 0x71, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB7, 0x18, 0x1B, 0xF7, 0x28, 0x17, 0xFB,
  0x48, 0xB6, 0x4B, 0xBB, 0xEF, 0xDB, 0xBD, 0xFE, 0xBB, 0xB3, 0x4B, 0xBB, 0xEF, 0xDB, 0xBD, 0xFE,
  0xBB, 0xB3, 0x48, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0x71, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB7, 0x18,
  0x1B, 0xF7, 0x28, 0x17, 0xFA, 0x71, 0x81, 0xBF, 0x73, 0x06, 0x02, 0x71, 0x81, 0xBF, 0x77, 0x68,
  0x14, 0xA2, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_align_vertical_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_align_vertical_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_align_vertical_top 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_editor_align_vertical_top_data[] PROGMEM = {
  0x01, 0x80, 0x92, 0x70, 0x10, 0x5F, 0xF0, 0x57, 0x76, 0x02, 0x06, 0x40, 0x60, 0x27, 0x18, 0x1A,
  0xF7, 0x28, 0x17, 0xFA, 0x71, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB7, 0x18, 0x1B, 0xF7, 0x28, 0x17,
  0xFB, 0x71, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xB7, 0x18, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0x71, 0x81,
  0xBF, 0x72, 0x81, 0x7F, 0xB7, 0x18, 0x1B, 0xF7, 0x28, 0x13, 0xE7, 0x71, 0x81, 0xBF, 0x77, 0x68,
  0x1B, 0xF7, 0x76, 0x81, 0xBF, 0x77, 0x68, 0x1A, 0xF7, 0x76, 0x02, 0x06, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_align_vertical_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_align_vertical_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_area_chart 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_editor_area_chart_data[] PROGMEM = {
  0x68, 0x18, 0xC3, 0x73, 0x06, 0xB0, 0x64, 0x00, 0x12, 0x03, 0xD8, 0x7B, 0x98, 0x04, 0xE6, 0x1E,
  0xF9, 0x00, 0x4A, 0x84, 0xEF, 0xE4, 0x3D, 0xC8, 0x24, 0x06, 0xEA, 0x04, 0x20, 0x10, 0xBB, 0x89,
  0x24, 0x10, 0x2C, 0x80, 0xBE, 0x50, 0x8A, 0x82, 0x44, 0xD3, 0x20, 0x7B, 0x84, 0x80, 0x5E, 0x44,
  0xA0, 0x70, 0x3D, 0x83, 0xB1, 0x23, 0x4F, 0xB8, 0x2D, 0x20, 0x3F, 0xC8, 0x2E, 0x20, 0x48, 0x06,
  0x50, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_area_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_area_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_attach_file 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_editor_attach_file_data[] PROGMEM = {
  0x30, 0x26, 0x83, 0x6E, 0xFE, 0x43, 0x84, 0x2F, 0x83, 0xAE, 0x38, 0x9C, 0x06, 0xE0, 0x60, 0xF4,
  0x32, 0x7D, 0x3F, 0x1F, 0x5B, 0x97, 0xD3, 0xF1, 0xF5, 0xB9, 0x7D, 0x3F, 0x1F, 0x5B, 0x97, 0xD3,
  0xF1, 0xF5, 0xB9, 0x7D, 0x3F, 0x1F, 0x5B, 0x97, 0xD3, 0xF1, 0xF5, 0xB9, 0x7D, 0x3F, 0x2F, 0x5B,
  0x96, 0xE1, 0xEE, 0xE1, 0xC8, 0x2F, 0x42, 0x72, 0x3F, 0x40, 0x9E, 0x63, 0x5E, 0xB3, 0x08, 0x0E,
  0xA0, 0x90, 0x15, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_attach_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 12, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_attach_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_attach_money 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_editor_attach_money_data[] PROGMEM = {
  0x20, 0x01, 0x50, 0x09, 0x48, 0x27, 0xEE, 0x82, 0x87, 0x8F, 0x99, 0xF8, 0x0D, 0x92, 0x84, 0x22,
  0x0B, 0xD4, 0x48, 0x31, 0xCF, 0xD6, 0x48, 0x24, 0xAF, 0xA5, 0x83, 0x7F, 0x2E, 0x72, 0x87, 0x5F,
  0x3A, 0xFA, 0x8E, 0xD2, 0x83, 0x7E, 0xE9, 0x13, 0x0A, 0x09, 0x50, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_attach_money() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_attach_money_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_auto_graph 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_editor_auto_graph_data[] PROGMEM = {
  0x50, 0x57, 0x78, 0x18, 0xF3, 0x75, 0x09, 0xB0, 0x37, 0x58, 0x18, 0xF3, 0x20, 0x20, 0x97, 0x30,
  0x52, 0x82, 0x2E, 0xF9, 0x28, 0x36, 0x80, 0x6A, 0x68, 0x68, 0xE3, 0x05, 0xF6, 0x4A, 0x09, 0x68,
  0x32, 0x04, 0xF8, 0x20, 0x70, 0xB3, 0x81, 0xBD, 0x22, 0x81, 0x3E, 0xA7, 0x86, 0xBE, 0xCD, 0x22,
  0xEB, 0x78, 0x6B, 0xE2, 0x1C, 0xDD, 0xC7, 0x81, 0xBE, 0x22, 0x82, 0x1C, 0xD1, 0x68, 0x1B, 0xE2,
  0x76, 0x07, 0x02, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_auto_graph() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_auto_graph_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_bar_chart 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_editor_bar_chart_data[] PROGMEM = {
  0x50, 0x03, 0x72, 0x03, 0xA0, 0x37, 0x10, 0x5A, 0x05, 0x71, 0x05, 0xA0, 0x55, 0x82, 0xA9, 0x05,
  0xA0, 0x54, 0x05, 0xA0, 0x40, 0x5A, 0x05, 0x40, 0x6A, 0x04, 0x05, 0xA8, 0x45, 0x1C, 0xD1, 0x6A,
  0x04, 0x05, 0xA0, 0x50, 0x4A, 0x05, 0x06, 0xA0, 0x40, 0x5A, 0x05, 0x04, 0xA0, 0x06, 0xA0, 0x40,
  0x5A, 0x05, 0x04, 0xA0, 0x60, 0x4A, 0x02, 0x03, 0xA0, 0x30, 0x2A, 0x82, 0x40, 0x43, 0x20, 0x03,
  0x20, 0x30, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_bar_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_bar_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_all 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_editor_border_all_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x94, 0x00, 0xA4, 0x90, 0x04, 0x94, 0x00,
  0xA4, 0x90, 0x04, 0x94, 0x00, 0xA4, 0x90, 0x04, 0x94, 0x00, 0xA4, 0x98, 0xB4, 0x44, 0xF9, 0x99,
  0x9D, 0xD9, 0x99, 0x9F, 0x44, 0xF9, 0x99, 0x9D, 0xD9, 0x99, 0x9F, 0x44, 0x94, 0x00, 0xA4, 0x90,
  0x04, 0x94, 0x00, 0xA4, 0x90, 0x04, 0x94, 0x00, 0xA4, 0x90, 0x04, 0x94, 0x00, 0xA4, 0x90, 0x40,
  0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_bottom 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_editor_border_bottom_data[] PROGMEM = {
  0x8B, 0x21, 0x40, 0x23, 0x03, 0x30, 0x32, 0x04, 0x14, 0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x47,
  0x70, 0x20, 0x64, 0x00, 0x44, 0x82, 0x62, 0x4E, 0x40, 0x09, 0x40, 0xE0, 0x47, 0x78, 0xB2, 0x29,
  0x04, 0x80, 0x66, 0x08, 0x40, 0x92, 0x3B, 0x05, 0x90, 0x77, 0x09, 0x50, 0xB3, 0x77, 0x03, 0x0B,
  0x40, 0x07, 0x48, 0x2B, 0x32, 0x94, 0x00, 0x64, 0x09, 0x02, 0x77, 0x02, 0xFD, 0x02, 0x18, 0x09,
  0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_clear 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_editor_border_clear_data[] PROGMEM = {
  0x8B, 0x21, 0x40, 0x23, 0x03, 0x30, 0x32, 0x04, 0x14, 0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x47,
  0x70, 0x20, 0x64, 0x00, 0x44, 0x82, 0x62, 0x4E, 0x40, 0x09, 0x40, 0xE0, 0x47, 0x78, 0xB2, 0x29,
  0x04, 0x80, 0x66, 0x08, 0x40, 0x92, 0x3B, 0x05, 0x90, 0x77, 0x09, 0x50, 0xB3, 0x77, 0x03, 0x0B,
  0x40, 0x07, 0x48, 0x2B, 0x32, 0x94, 0x00, 0x64, 0x09, 0x02, 0x77, 0x8B, 0x24, 0xF0, 0x7D, 0x0A,
  0xA0, 0xD7, 0x0F, 0x41, 0x40, 0x23, 0x03, 0x30, 0x32, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_color 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_editor_border_color_data[] PROGMEM = {
  0x72, 0x82, 0x1D, 0xE3, 0x75, 0x83, 0x1D, 0xFE, 0x27, 0x28, 0x52, 0xC2, 0x1D, 0xF3, 0x71, 0x85,
  0x2D, 0xFE, 0x21, 0x57, 0x10, 0x20, 0xDB, 0x0E, 0x72, 0x02, 0x0D, 0xC0, 0x67, 0x10, 0x20, 0xDC,
  0x06, 0x71, 0x01, 0x0D, 0xC0, 0x67, 0x20, 0x6C, 0x06, 0x73, 0x06, 0xB0, 0x67, 0x48, 0x22, 0x99,
  0x57, 0x77, 0x60, 0x30, 0x88, 0x06, 0x90, 0x80, 0x32, 0x0E, 0xFD, 0x81, 0xE0, 0x2F, 0xF8, 0x22,
  0x08, 0xEF, 0xB0, 0xE0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_color() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_editor_border_color_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_horizontal 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_editor_border_horizontal_data[] PROGMEM = {
  0x8B, 0x21, 0x40, 0x23, 0x03, 0x30, 0x32, 0x04, 0x14, 0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x47,
  0x70, 0x20, 0x64, 0x00, 0x44, 0x82, 0x62, 0x4E, 0x40, 0x09, 0x40, 0xE0, 0x47, 0x70, 0x18, 0x09,
  0x09, 0x00, 0x18, 0x09, 0x0B, 0x01, 0x77, 0x03, 0x0B, 0x40, 0x07, 0x48, 0x2B, 0x32, 0x94, 0x00,
  0x64, 0x09, 0x02, 0x77, 0x8B, 0x24, 0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x41, 0x40, 0x23, 0x03,
  0x30, 0x32, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_horizontal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_horizontal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_inner 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_editor_border_inner_data[] PROGMEM = {
  0x8B, 0x21, 0x40, 0x23, 0x01, 0x10, 0x32, 0x04, 0x14, 0xF0, 0x7D, 0x09, 0x90, 0xD7, 0x0F, 0x46,
  0x00, 0xA6, 0x02, 0x06, 0x40, 0x0A, 0x48, 0x26, 0x24, 0xE4, 0x00, 0xA4, 0x0E, 0x04, 0x60, 0x0A,
  0x60, 0x18, 0x01, 0x90, 0x0D, 0x80, 0x19, 0x00, 0x18, 0x01, 0xB0, 0x0E, 0x80, 0x1B, 0x01, 0x60,
  0x0A, 0x60, 0x30, 0xB4, 0x00, 0xA4, 0x82, 0xB3, 0x29, 0x40, 0x0A, 0x40, 0x90, 0x26, 0x00, 0xA6,
  0x8B, 0x24, 0xF0, 0x7D, 0x09, 0x90, 0xD7, 0x0F, 0x41, 0x40, 0x23, 0x01, 0x10, 0x32, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_inner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_inner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_left 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_editor_border_left_data[] PROGMEM = {
  0x18, 0xB2, 0x20, 0x23, 0x03, 0x30, 0x32, 0x04, 0x14, 0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x44,
  0x97, 0x50, 0x49, 0x40, 0x04, 0x48, 0x16, 0x24, 0x94, 0x00, 0x94, 0x81, 0xE4, 0x49, 0x75, 0x8B,
  0x34, 0xF0, 0x48, 0x06, 0x60, 0x84, 0x09, 0x24, 0xF0, 0x59, 0x07, 0x70, 0x95, 0x0B, 0x34, 0x97,
  0x50, 0x49, 0x40, 0x07, 0x48, 0x1B, 0x34, 0x94, 0x00, 0x64, 0x81, 0x92, 0x49, 0x75, 0x8B, 0x24,
  0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x40, 0x20, 0x23, 0x03, 0x30, 0x32, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_outer 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_editor_border_outer_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x40, 0x04, 0x49,
  0x00, 0x49, 0x40, 0x09, 0x49, 0x00, 0x49, 0x73, 0x98, 0xB4, 0x44, 0xF0, 0x48, 0x06, 0x60, 0x84,
  0x0F, 0x44, 0xF0, 0x59, 0x07, 0x70, 0x95, 0x0F, 0x44, 0x97, 0x39, 0x00, 0x49, 0x40, 0x07, 0x49,
  0x00, 0x49, 0x40, 0x06, 0x49, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63,
  0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_outer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_outer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_right 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_editor_border_right_data[] PROGMEM = {
  0x8B, 0x21, 0x40, 0x23, 0x03, 0x30, 0x32, 0x02, 0x04, 0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x47,
  0x59, 0x81, 0x42, 0x94, 0x00, 0x64, 0x98, 0x14, 0x3B, 0x40, 0x07, 0x49, 0x04, 0x75, 0x98, 0xB3,
  0x43, 0xB0, 0x59, 0x07, 0x70, 0x95, 0x0F, 0x42, 0x90, 0x48, 0x06, 0x60, 0x84, 0x0F, 0x47, 0x59,
  0x81, 0x44, 0xE4, 0x00, 0x94, 0x98, 0x14, 0x26, 0x40, 0x04, 0x49, 0x04, 0x75, 0x98, 0xB2, 0x44,
  0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x41, 0x40, 0x23, 0x03, 0x30, 0x32, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_style 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_editor_border_style_data[] PROGMEM = {
  0x10, 0x28, 0x07, 0x31, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x50, 0x49, 0x73, 0x81, 0x92, 0x49, 0x73,
  0x81, 0xB3, 0x49, 0x75, 0x04, 0x97, 0x38, 0x1B, 0x34, 0x97, 0x38, 0x19, 0x24, 0x97, 0x50, 0x49,
  0x73, 0x81, 0xE4, 0x49, 0x73, 0x81, 0x62, 0x49, 0x75, 0x8B, 0x24, 0xF0, 0x9B, 0x0B, 0x90, 0xE6,
  0x0F, 0x40, 0x20, 0x23, 0x03, 0x20, 0x42, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_style() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_style_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_top 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_editor_border_top_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x27, 0x70, 0x20, 0x74, 0x05, 0x04, 0x48, 0x27, 0x23, 0xD4,
  0x09, 0x08, 0x40, 0xD0, 0x37, 0x78, 0xB2, 0x3A, 0x06, 0x70, 0x76, 0x09, 0x40, 0xA3, 0x3A, 0x06,
  0x70, 0x76, 0x09, 0x40, 0xA3, 0x77, 0x03, 0x0D, 0x40, 0x90, 0x84, 0x82, 0xD3, 0x27, 0x40, 0x50,
  0x44, 0x07, 0x02, 0x77, 0x8B, 0x24, 0xF0, 0x9B, 0x0B, 0x90, 0xE6, 0x0F, 0x41, 0x40, 0x23, 0x03,
  0x20, 0x42, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_border_vertical 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_editor_border_vertical_data[] PROGMEM = {
  0x8B, 0x21, 0x40, 0x23, 0x01, 0x10, 0x42, 0x04, 0x14, 0xF0, 0x9B, 0x0B, 0x80, 0xE6, 0x0F, 0x46,
  0x0B, 0x09, 0x60, 0x20, 0x74, 0x0B, 0x09, 0x48, 0x27, 0x23, 0xD4, 0x0B, 0x09, 0x40, 0xD0, 0x36,
  0x0B, 0x09, 0x68, 0xB2, 0x3A, 0x06, 0x70, 0xB9, 0x09, 0x40, 0xA3, 0x3A, 0x06, 0x70, 0xB9, 0x09,
  0x40, 0xA3, 0x60, 0xB0, 0x96, 0x03, 0x0D, 0x40, 0xB0, 0x94, 0x82, 0xD3, 0x27, 0x40, 0xB0, 0x94,
  0x07, 0x02, 0x60, 0xB0, 0x96, 0x8B, 0x24, 0xF0, 0x9B, 0x0B, 0x80, 0xE6, 0x0F, 0x41, 0x40, 0x23,
  0x01, 0x10, 0x42, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_border_vertical() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_border_vertical_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_bubble_chart 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_editor_bubble_chart_data[] PROGMEM = {
  0x72, 0x81, 0x13, 0x17, 0x30, 0x10, 0xBB, 0x08, 0x72, 0x0B, 0xD0, 0x87, 0x03, 0xF7, 0x06, 0xF0,
  0x26, 0x03, 0xF2, 0x85, 0x2A, 0xD9, 0x10, 0xCD, 0x08, 0x20, 0xDB, 0x82, 0xA0, 0x1C, 0xB0, 0x92,
  0x03, 0xD3, 0x81, 0x24, 0x13, 0x02, 0xC8, 0x4E, 0x01, 0x9A, 0x25, 0x09, 0xB8, 0x16, 0x0C, 0xA0,
  0xC6, 0x81, 0x47, 0x32, 0x0E, 0xB7, 0x40, 0x7A, 0x08, 0x75, 0x00, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_bubble_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_bubble_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_candlestick_chart 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_editor_candlestick_chart_data[] PROGMEM = {
  0x20, 0x26, 0x02, 0x40, 0xC0, 0x74, 0x07, 0x0C, 0x38, 0x26, 0xEB, 0x53, 0x08, 0x0C, 0x20, 0x5C,
  0x01, 0x20, 0x80, 0xC2, 0x06, 0xC8, 0x61, 0x08, 0xDE, 0xA1, 0x6C, 0x00, 0x1C, 0x00, 0x6C, 0x00,
  0x1C, 0x00, 0x6C, 0x00, 0x1C, 0x00, 0x6C, 0x00, 0x1C, 0x00, 0x6C, 0x86, 0x10, 0x8D, 0xEA, 0x15,
  0xC0, 0x12, 0x08, 0x0C, 0x38, 0x26, 0xEB, 0x53, 0x08, 0x0C, 0x40, 0xC0, 0x74, 0x07, 0x0C, 0x40,
  0x26, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_candlestick_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_candlestick_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_checklist 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_editor_checklist_data[] PROGMEM = {
  0x40, 0x10, 0x97, 0x58, 0x11, 0xDD, 0x72, 0x84, 0xC9, 0x1D, 0xD1, 0x28, 0x92, 0x89, 0x99, 0x98,
  0x04, 0xFE, 0xD1, 0x38, 0x91, 0xAB, 0xBB, 0xBA, 0x10, 0x39, 0x17, 0x77, 0x72, 0x81, 0x3B, 0x17,
  0x10, 0x22, 0x81, 0x3E, 0xB7, 0x28, 0x3C, 0xB3, 0xEB, 0x38, 0x91, 0xAB, 0xBB, 0xBA, 0x12, 0xEF,
  0xB4, 0x84, 0x89, 0x99, 0x98, 0x20, 0x20, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_checklist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_checklist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_checklist_rtl 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_editor_checklist_rtl_data[] PROGMEM = {
  0x76, 0x04, 0x07, 0x75, 0x8A, 0x74, 0xF9, 0x08, 0x99, 0x99, 0x80, 0x1F, 0x54, 0xF9, 0x01, 0xAB,
  0xBB, 0xBA, 0x20, 0x8A, 0x09, 0x75, 0x06, 0x07, 0x77, 0x77, 0x30, 0x60, 0x97, 0x20, 0x22, 0x89,
  0x76, 0xF7, 0x1A, 0xBB, 0xBB, 0xA0, 0x1F, 0x86, 0xF7, 0x28, 0x48, 0x99, 0x99, 0x82, 0x06, 0xA0,
  0x77, 0x50, 0x40, 0x53,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_checklist_rtl() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_checklist_rtl_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_data_array 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_editor_data_array_data[] PROGMEM = {
  0x18, 0x14, 0x55, 0x48, 0x35, 0x54, 0x04, 0xA0, 0xE0, 0x12, 0x01, 0x0E, 0xA8, 0x14, 0x6E, 0x71,
  0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71,
  0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x81, 0xE6, 0x4A, 0x0E,
  0x01, 0x20, 0x10, 0xEA, 0x83, 0x40, 0x45, 0x54, 0x81, 0x55, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_data_array() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_data_array_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_data_object 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_editor_data_object_data[] PROGMEM = {
  0x38, 0x11, 0x55, 0x48, 0x15, 0x51, 0x58, 0x31, 0xEF, 0xE1, 0x28, 0x31, 0xEF, 0xE1, 0x48, 0x15,
  0xF1, 0x68, 0x11, 0xF5, 0x40, 0x60, 0xE7, 0x10, 0xE0, 0x63, 0x81, 0x3B, 0xC7, 0x18, 0x6C, 0xB3,
  0x01, 0xFD, 0x37, 0x18, 0x63, 0xDF, 0x11, 0xFD, 0x37, 0x18, 0x63, 0xDF, 0x10, 0x3B, 0xC7, 0x18,
  0x1C, 0xB3, 0x30, 0x60, 0xE7, 0x10, 0xE0, 0x64, 0x81, 0x5F, 0x16, 0x81, 0x1F, 0x54, 0x83, 0x1E,
  0xFE, 0x12, 0x83, 0x1E, 0xFE, 0x15, 0x81, 0x15, 0x54, 0x81, 0x55, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_data_object() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_data_object_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_drag_handle 18x18, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_round_18_editor_drag_handle_data[] PROGMEM = {
  0x18, 0x06, 0x31, 0x04, 0xFB, 0x04, 0x18, 0x06, 0x12, 0x80, 0x61, 0x10, 0x4F, 0xB0, 0x41, 0x80,
  0x63, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_drag_handle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 14, 11), Box(0, 0, 17, 17),
      ic_round_18_editor_drag_handle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_draw 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_editor_draw_data[] PROGMEM = {
  0x28, 0x12, 0x31, 0x72, 0x0A, 0xB0, 0x77, 0x18, 0x29, 0x41, 0x89, 0x38, 0x16, 0xD7, 0x48, 0x13,
  0xCD, 0x30, 0x9A, 0x8A, 0x07, 0x02, 0xAF, 0xA1, 0x07, 0x70, 0x9F, 0xC1, 0xEC, 0x42, 0x07, 0xA8,
  0x57, 0x09, 0x43, 0xF5, 0x20, 0x7C, 0x06, 0x38, 0x2A, 0x90, 0x7D, 0x04, 0x50, 0x7D, 0x04, 0x50,
  0x7D, 0x82, 0x40, 0xB5, 0x20, 0x4D, 0x04, 0x20, 0x90, 0xD2, 0x06, 0xC0, 0x42, 0x81, 0x3C, 0xB2,
  0x06, 0xB0, 0x42, 0x82, 0xEF, 0xC1, 0x28, 0x21, 0x33, 0x23, 0x03, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_draw() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_draw_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_edit_note 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_editor_edit_note_data[] PROGMEM = {
  0x18, 0x03, 0x70, 0x45, 0x02, 0x80, 0x3D, 0x08, 0x77, 0x50, 0x10, 0xA8, 0x02, 0xB0, 0x65, 0x01,
  0x80, 0x39, 0x06, 0x30, 0x70, 0x17, 0x48, 0x73, 0xEB, 0x2D, 0xDD, 0xDC, 0x48, 0x90, 0xBB, 0x45,
  0x07, 0x77, 0x76, 0x30, 0xBA, 0x04, 0x72, 0x0B, 0xA0, 0x67, 0x20, 0xBA, 0x06, 0x73, 0xA0, 0x67,
  0x40, 0x30, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_edit_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_edit_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_align_center 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_editor_format_align_center_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x27, 0x73, 0x02, 0x80, 0x27, 0x02, 0x60, 0x58, 0x02, 0xD0,
  0x57, 0x73, 0x01, 0x80, 0x90, 0x90, 0x01, 0x80, 0x90, 0x90, 0x17, 0x73, 0x05, 0x80, 0x2D, 0x05,
  0x60, 0x28, 0x02, 0x70, 0x27, 0x73, 0x02, 0xFD, 0x02, 0x18, 0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_align_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_align_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_align_justify 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_editor_format_align_justify_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x27, 0x71, 0x80, 0x90, 0x71, 0x02, 0x80, 0x90, 0xD0, 0x27,
  0x70, 0x18, 0x09, 0x09, 0x00, 0x18, 0x09, 0x09, 0x01, 0x77, 0x02, 0x80, 0x90, 0xD0, 0x21, 0x80,
  0x90, 0x77, 0x71, 0x02, 0xFD, 0x02, 0x18, 0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_align_justify() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_align_justify_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_align_left 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_editor_format_align_left_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x27, 0x71, 0x80, 0x47, 0x03, 0x40, 0x28, 0x04, 0xD0, 0x77,
  0x74, 0x01, 0x80, 0x90, 0x90, 0x01, 0x80, 0x90, 0x90, 0x17, 0x70, 0x28, 0x04, 0xD0, 0x75, 0x80,
  0x47, 0x03, 0x77, 0x40, 0x2F, 0xD0, 0x21, 0x80, 0x90, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_align_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_align_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_align_right 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_editor_format_align_right_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x27, 0x74, 0x03, 0x80, 0x47, 0x50, 0x78, 0x04, 0xD0, 0x27,
  0x70, 0x18, 0x09, 0x09, 0x00, 0x18, 0x09, 0x09, 0x01, 0x77, 0x40, 0x78, 0x04, 0xD0, 0x24, 0x03,
  0x80, 0x47, 0x77, 0x10, 0x2F, 0xD0, 0x21, 0x80, 0x90, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_align_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_align_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_bold 18x18, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_18_editor_format_bold_data[] PROGMEM = {
  0x18, 0x00, 0x50, 0x22, 0x07, 0xD8, 0x93, 0x70, 0x9F, 0x63, 0x5D, 0xF1, 0x9F, 0x42, 0x89, 0x29,
  0xF3, 0x9F, 0x85, 0x6E, 0xC0, 0x9D, 0x89, 0x35, 0x09, 0xF6, 0x34, 0xBF, 0x49, 0xF4, 0x28, 0x92,
  0x4F, 0x99, 0xF6, 0x34, 0xBF, 0x67, 0xD8, 0x6C, 0x10, 0x67, 0x77, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_bold() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 12, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_format_bold_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_clear 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_editor_format_clear_data[] PROGMEM = {
  0x0E, 0x07, 0x74, 0x83, 0x6F, 0x70, 0x28, 0x02, 0x70, 0x62, 0x83, 0x6F, 0x70, 0x9E, 0x04, 0x28,
  0x46, 0xF7, 0x09, 0xD8, 0x00, 0x34, 0x83, 0x6F, 0x70, 0x37, 0x28, 0x16, 0xF7, 0x73, 0x05, 0xA0,
  0x77, 0x28, 0x3C, 0xF8, 0xF7, 0x78, 0x53, 0xFB, 0x06, 0xF7, 0x68, 0x18, 0xF4, 0x28, 0x16, 0xF7,
  0x50, 0x20, 0x64, 0x81, 0x6F, 0x77, 0x48, 0x16, 0xF7, 0x74, 0x06, 0x0E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_color_fill 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_editor_format_color_fill_data[] PROGMEM = {
  0x30, 0x50, 0x67, 0x78, 0x15, 0xF7, 0x77, 0x81, 0x6F, 0x77, 0x68, 0x22, 0xEF, 0x77, 0x48, 0x42,
  0xEB, 0x6F, 0x77, 0x28, 0x12, 0xEB, 0x28, 0x16, 0xF7, 0x78, 0x11, 0xEB, 0x48, 0x16, 0xF6, 0x68,
  0x13, 0xFC, 0x80, 0x1B, 0x0E, 0x09, 0x70, 0x7E, 0x83, 0xC1, 0x05, 0x15, 0x07, 0xC8, 0x4C, 0x10,
  0x3F, 0xA6, 0x07, 0xA0, 0xC0, 0x12, 0x0A, 0xA0, 0x26, 0x81, 0x69, 0x13, 0x0B, 0xA0, 0x27, 0x58,
  0x11, 0x85, 0x77, 0x50, 0x30, 0x88, 0x06, 0x90, 0x80, 0x32, 0x0E, 0xFD, 0x81, 0xE0, 0x2F, 0xF8,
  0x22, 0x08, 0xEF, 0xB0, 0xE0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_color_fill() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_editor_format_color_fill_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_color_reset 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_editor_format_color_reset_data[] PROGMEM = {
  0x60, 0x09, 0x50, 0xE0, 0x73, 0x08, 0xA0, 0x74, 0x83, 0x6F, 0x70, 0x4C, 0x06, 0x48, 0x36, 0xF7,
  0x09, 0xC0, 0x44, 0x83, 0x8F, 0x70, 0x9B, 0x0E, 0x03, 0x30, 0xCA, 0x81, 0x70, 0x9B, 0x0C, 0x20,
  0x2C, 0x81, 0x70, 0x9B, 0x81, 0x30, 0x5D, 0x81, 0x70, 0x9A, 0x81, 0x50, 0x5E, 0x85, 0x70, 0x9F,
  0x50, 0x1F, 0x82, 0x70, 0x91, 0x20, 0xAF, 0x07, 0x40, 0x10, 0xDF, 0x07, 0x40, 0x10, 0x9C, 0x82,
  0xA7, 0xF7, 0x68, 0x13, 0x31, 0x20, 0x60, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_color_reset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_color_reset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_color_text 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_editor_format_color_text_data[] PROGMEM = {
  0x70, 0x02, 0x76, 0x82, 0x1E, 0xE1, 0x75, 0x82, 0x7E, 0xE7, 0x75, 0x82, 0xD9, 0x9D, 0x74, 0x84,
  0x3F, 0x33, 0xF3, 0x73, 0x09, 0x0D, 0x20, 0xD0, 0x97, 0x38, 0x4E, 0xED, 0xDE, 0xE7, 0x28, 0x65,
  0xF6, 0x55, 0x6F, 0x57, 0x10, 0xB0, 0xC4, 0x0C, 0x0B, 0x71, 0x07, 0x04, 0x40, 0x40, 0x78, 0x0C,
  0x10, 0x03, 0x08, 0x80, 0x69, 0x08, 0x03, 0x20, 0xEF, 0xD8, 0x1E, 0x02, 0xFF, 0x82, 0x20, 0x8E,
  0xFB, 0x0E, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_color_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_editor_format_color_text_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_indent_decrease 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_editor_format_indent_decrease_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x27, 0x76, 0x04, 0x80, 0x27, 0x70, 0x98, 0x02, 0xD0, 0x22,
  0x0B, 0x05, 0x74, 0x81, 0xBF, 0x62, 0x07, 0x80, 0x29, 0x83, 0x10, 0xBF, 0x62, 0x07, 0x80, 0x29,
  0x01, 0x20, 0xB0, 0x57, 0x72, 0x09, 0x80, 0x2D, 0x02, 0x60, 0x48, 0x02, 0x77, 0x71, 0x02, 0xFD,
  0x02, 0x18, 0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_indent_decrease() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_indent_decrease_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_indent_increase 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_editor_format_indent_increase_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x27, 0x76, 0x04, 0x80, 0x27, 0x70, 0x98, 0x02, 0xD8, 0x22,
  0x4C, 0x17, 0x48, 0x14, 0xFC, 0x30, 0x78, 0x02, 0x98, 0x21, 0x4F, 0xC3, 0x07, 0x80, 0x29, 0x82,
  0x14, 0xC1, 0x77, 0x30, 0x98, 0x02, 0xD0, 0x26, 0x04, 0x80, 0x27, 0x77, 0x10, 0x2F, 0xD0, 0x21,
  0x80, 0x90, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_indent_increase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_indent_increase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_italic 18x18, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_round_18_editor_format_italic_data[] PROGMEM = {
  0x30, 0x28, 0x01, 0x54, 0x0A, 0xD0, 0x63, 0x84, 0x25, 0xBF, 0x95, 0x60, 0x0E, 0x78, 0x15, 0xF9,
  0x78, 0x1B, 0xF3, 0x68, 0x12, 0xFC, 0x78, 0x18, 0xF6, 0x70, 0x0E, 0x68, 0x45, 0x8F, 0xC5, 0x23,
  0x06, 0xD0, 0xA4, 0x80, 0x15, 0x02, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_italic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_format_italic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_line_spacing 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_editor_format_line_spacing_data[] PROGMEM = {
  0x20, 0x17, 0x68, 0x16, 0xF6, 0x30, 0x58, 0x02, 0x71, 0x04, 0xB0, 0x52, 0x0B, 0x80, 0x1D, 0x85,
  0xC1, 0x15, 0xF5, 0x17, 0x48, 0x12, 0xF2, 0x75, 0x81, 0x2F, 0x23, 0x08, 0x80, 0x29, 0x28, 0x12,
  0xF2, 0x30, 0x88, 0x02, 0x92, 0x81, 0x2F, 0x27, 0x48, 0x31, 0x5F, 0x51, 0x73, 0x05, 0xB0, 0x42,
  0x0B, 0x80, 0x1D, 0x84, 0xC1, 0x06, 0xF6, 0x30, 0x58, 0x02, 0x73, 0x01, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_line_spacing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_format_line_spacing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_list_bulleted 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_editor_format_list_bulleted_data[] PROGMEM = {
  0x82, 0x48, 0x02, 0x80, 0x57, 0x18, 0x28, 0xD0, 0x58, 0x05, 0xD0, 0x27, 0x77, 0x78, 0x26, 0xA0,
  0x48, 0x05, 0x98, 0x31, 0x6A, 0x04, 0x80, 0x59, 0x01, 0x77, 0x77, 0x82, 0x8D, 0x05, 0x80, 0x5D,
  0x83, 0x24, 0x80, 0x28, 0x05, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_list_bulleted() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_format_list_bulleted_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_list_numbered 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_editor_format_list_numbered_data[] PROGMEM = {
  0x05, 0x76, 0x82, 0x92, 0x04, 0x80, 0x57, 0x83, 0x28, 0x20, 0x78, 0x05, 0xD0, 0x30, 0x17, 0x60,
  0x50, 0x37, 0x58, 0x28, 0x80, 0x68, 0x05, 0xA8, 0x33, 0xC4, 0x06, 0x80, 0x5A, 0x81, 0x35, 0x47,
  0x50, 0x30, 0x27, 0x58, 0x27, 0xB0, 0x78, 0x05, 0xD8, 0x33, 0x6B, 0x04, 0x80, 0x57, 0x81, 0x25,
  0x47, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_list_numbered() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_format_list_numbered_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_list_numbered_rtl 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_editor_format_list_numbered_rtl_data[] PROGMEM = {
  0x75, 0x82, 0x32, 0x01, 0x80, 0x57, 0x84, 0x50, 0x39, 0x02, 0x80, 0x5D, 0x09, 0x20, 0x97, 0x70,
  0x27, 0x68, 0x23, 0x50, 0x28, 0x05, 0xA8, 0x47, 0x03, 0xC1, 0x28, 0x05, 0xA8, 0x27, 0x07, 0x97,
  0x68, 0x12, 0x51, 0x75, 0x82, 0x23, 0x02, 0x80, 0x5D, 0x84, 0x90, 0x3B, 0x41, 0x80, 0x57, 0x83,
  0x50, 0x2B, 0x47, 0x58, 0x13, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_list_numbered_rtl() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_format_list_numbered_rtl_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_paint 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_editor_format_paint_data[] PROGMEM = {
  0x10, 0x28, 0x03, 0x34, 0x04, 0xF9, 0x07, 0x30, 0x6F, 0x98, 0x3D, 0x98, 0x06, 0xF9, 0x83, 0xDB,
  0xF4, 0x5F, 0x98, 0x28, 0x0F, 0x41, 0x80, 0x43, 0x29, 0x04, 0x40, 0x48, 0x01, 0x58, 0x16, 0xF4,
  0x30, 0x2F, 0x0E, 0x02, 0x30, 0x3A, 0x06, 0x72, 0x03, 0xA0, 0x67, 0x20, 0x3A, 0x06, 0x72, 0x03,
  0xA0, 0x67, 0x20, 0x3A, 0x06, 0x72, 0x03, 0xA0, 0x67, 0x20, 0x2A, 0x05, 0x73, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_paint() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_format_paint_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_quote 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_editor_format_quote_data[] PROGMEM = {
  0x83, 0x18, 0x99, 0x62, 0x84, 0x69, 0x98, 0x15, 0xC0, 0x01, 0xC0, 0x50, 0x6C, 0x00, 0x1C, 0x00,
  0x6C, 0x00, 0x1C, 0x82, 0x62, 0xDD, 0xA8, 0x51, 0x0B, 0xDE, 0xF6, 0x28, 0x13, 0xFC, 0x48, 0x1D,
  0xF1, 0x28, 0x19, 0xF4, 0x38, 0x15, 0xF9, 0x30, 0x30, 0x74, 0x81, 0x18, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_quote() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 14, 12), Box(0, 0, 17, 17),
      ic_round_18_editor_format_quote_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_shapes 18x18, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_round_18_editor_format_shapes_data[] PROGMEM = {
  0x20, 0xF1, 0x71, 0x0F, 0x13, 0x0E, 0xB0, 0x36, 0x03, 0xB8, 0x6E, 0x01, 0xF6, 0x3E, 0xA8, 0x02,
  0x78, 0x92, 0xAE, 0x36, 0xF1, 0x1F, 0x30, 0xEE, 0x80, 0x2D, 0x85, 0xEE, 0x03, 0xF1, 0x1C, 0x05,
  0x60, 0x5C, 0x84, 0x10, 0x3A, 0xD5, 0x30, 0x05, 0x38, 0x25, 0xDA, 0x33, 0x08, 0x0C, 0x40, 0x0D,
  0x40, 0xC0, 0x84, 0x08, 0x0C, 0x38, 0x25, 0x99, 0x53, 0x0C, 0x08, 0x40, 0x80, 0xC3, 0x82, 0xB4,
  0x4B, 0x30, 0xC0, 0x84, 0x08, 0x0C, 0x28, 0x41, 0xFD, 0xDF, 0x12, 0x0C, 0x08, 0x40, 0x80, 0xC2,
  0x84, 0x79, 0x11, 0x97, 0x20, 0xC0, 0x84, 0x08, 0x0C, 0x20, 0x60, 0x22, 0x02, 0x06, 0x20, 0xC0,
  0x83, 0x82, 0x3A, 0xD5, 0x71, 0x84, 0x5D, 0xA3, 0x01, 0xC0, 0x56, 0x05, 0xC8, 0x51, 0x1F, 0x30,
  0xEE, 0x80, 0x2D, 0x89, 0x2E, 0xE0, 0x3F, 0x11, 0xF6, 0x3E, 0xA8, 0x02, 0x78, 0x6A, 0xE3, 0x6F,
  0x10, 0xEB, 0x03, 0x60, 0x3B, 0x0E, 0x30, 0xF1, 0x71, 0x0F, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_shapes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_editor_format_shapes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_size 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_editor_format_size_data[] PROGMEM = {
  0x60, 0x28, 0x03, 0x50, 0x47, 0x0A, 0xF9, 0x01, 0x68, 0x72, 0x55, 0x7F, 0xB5, 0x54, 0x73, 0x81,
  0x3F, 0x95, 0x84, 0xAB, 0xBB, 0xB9, 0x28, 0x13, 0xF9, 0x40, 0x10, 0xDC, 0x0D, 0x28, 0x13, 0xF9,
  0x70, 0xE0, 0xD4, 0x81, 0x3F, 0x97, 0x0E, 0x0D, 0x48, 0x13, 0xF9, 0x70, 0xE0, 0xD4, 0x81, 0x3F,
  0x97, 0x0E, 0x0D, 0x48, 0x13, 0xF9, 0x70, 0xD0, 0xC4, 0x81, 0x2F, 0x87, 0x03, 0x02, 0x50, 0x40,
  0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_size() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_format_size_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_strikethrough 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_editor_format_strikethrough_data[] PROGMEM = {
  0x48, 0x04, 0x57, 0x06, 0xF9, 0x06, 0x70, 0xF5, 0x00, 0xE0, 0xF5, 0x74, 0x00, 0xD7, 0x70, 0x08,
  0x77, 0x72, 0x01, 0x0E, 0xFD, 0x82, 0xE1, 0x04, 0x80, 0x90, 0x50, 0x47, 0x10, 0x03, 0x77, 0x00,
  0xD7, 0x70, 0x0D, 0x77, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_strikethrough() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_format_strikethrough_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_textdirection_l_to_r 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_editor_format_textdirection_l_to_r_data[] PROGMEM = {
  0x58, 0x01, 0x36, 0x07, 0xE0, 0x74, 0x03, 0xB8, 0x29, 0x3F, 0x55, 0x06, 0xB8, 0x28, 0x1F, 0x35,
  0x03, 0xB8, 0x28, 0x1F, 0x36, 0x08, 0xA8, 0x28, 0x1F, 0x37, 0x18, 0x3C, 0x81, 0xF3, 0x71, 0x83,
  0xC8, 0x1F, 0x37, 0x18, 0x3C, 0x81, 0xF3, 0x71, 0x83, 0x74, 0x0A, 0x17, 0x60, 0x20, 0x42, 0x80,
  0x51, 0x82, 0x7F, 0x43, 0xFC, 0x0E, 0x18, 0x05, 0x18, 0x17, 0xF4, 0x73, 0x02, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_textdirection_l_to_r() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_textdirection_l_to_r_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_textdirection_r_to_l 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_editor_format_textdirection_r_to_l_data[] PROGMEM = {
  0x48, 0x01, 0x36, 0x07, 0xE0, 0x74, 0x03, 0xB8, 0x29, 0x3F, 0x55, 0x06, 0xB8, 0x28, 0x1F, 0x35,
  0x03, 0xB8, 0x28, 0x1F, 0x36, 0x08, 0xA8, 0x28, 0x1F, 0x37, 0x18, 0x3C, 0x81, 0xF3, 0x71, 0x83,
  0xC8, 0x1F, 0x37, 0x18, 0x3C, 0x81, 0xF3, 0x71, 0x83, 0x74, 0x0A, 0x15, 0x04, 0x02, 0x73, 0x81,
  0x4F, 0x78, 0x05, 0x11, 0x0E, 0xFC, 0x82, 0x34, 0xF7, 0x80, 0x51, 0x20, 0x40, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_textdirection_r_to_l() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_textdirection_r_to_l_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_format_underlined 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_editor_format_underlined_data[] PROGMEM = {
  0x10, 0x20, 0x14, 0x01, 0x02, 0x20, 0xE0, 0xA4, 0x0A, 0x0E, 0x29, 0x0B, 0x40, 0xB9, 0x29, 0x0B,
  0x40, 0xB9, 0x29, 0x0B, 0x40, 0xB9, 0x29, 0x0B, 0x40, 0xB9, 0x29, 0x0B, 0x40, 0xC9, 0x28, 0x1D,
  0xE1, 0x28, 0x11, 0xED, 0x28, 0x67, 0xFC, 0x44, 0xCF, 0x63, 0x0A, 0xC0, 0x95, 0x82, 0x37, 0x73,
  0x76, 0x05, 0xF9, 0x05, 0x18, 0x04, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_format_underlined() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_format_underlined_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_functions 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_editor_functions_data[] PROGMEM = {
  0x18, 0x02, 0x50, 0x10, 0x7E, 0x07, 0x05, 0xA8, 0x90, 0x85, 0x55, 0x10, 0x5F, 0xD2, 0x58, 0x24,
  0xED, 0x25, 0x81, 0x3E, 0xC5, 0x81, 0x3E, 0xC4, 0x82, 0x4E, 0xD2, 0x38, 0x25, 0xFD, 0x23, 0x05,
  0xA8, 0x48, 0x55, 0x51, 0x7E, 0x07, 0x18, 0x02, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_functions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 12, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_functions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_height 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_round_18_editor_height_data[] PROGMEM = {
  0x20, 0x0B, 0x30, 0xBA, 0x81, 0xB0, 0xAC, 0x85, 0xB3, 0x3E, 0xE3, 0x32, 0x00, 0xD4, 0x00, 0xD4,
  0x00, 0xD4, 0x00, 0xD2, 0x85, 0x33, 0xEE, 0x33, 0xBC, 0x81, 0xB0, 0xBA, 0x0B, 0x30, 0x0B, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_height() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 11, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_height_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_hexagon 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_editor_hexagon_data[] PROGMEM = {
  0x30, 0x18, 0x02, 0x30, 0x15, 0x01, 0x0E, 0xE0, 0xE0, 0x14, 0x09, 0xF9, 0x09, 0x30, 0x3F, 0xB0,
  0x32, 0x0B, 0xFB, 0x81, 0xB0, 0x5F, 0xD0, 0x50, 0xDF, 0xD0, 0x0D, 0xFD, 0x0D, 0x05, 0xFD, 0x81,
  0x50, 0xBF, 0xB0, 0xB2, 0x03, 0xFB, 0x03, 0x30, 0x9F, 0x90, 0x94, 0x01, 0x0E, 0xE0, 0xE0, 0x15,
  0x01, 0x80, 0x23, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_hexagon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_hexagon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_highlight 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_editor_highlight_data[] PROGMEM = {
  0x50, 0x09, 0x73, 0x00, 0x85, 0x0D, 0x07, 0x71, 0x82, 0x7D, 0x6B, 0x71, 0x0B, 0x06, 0x77, 0x04,
  0x80, 0x2B, 0x04, 0x40, 0x9E, 0x09, 0x40, 0x9E, 0x09, 0x40, 0x8E, 0x08, 0x40, 0x10, 0xCC, 0x0C,
  0x01, 0x50, 0x10, 0xDA, 0x0D, 0x01, 0x70, 0xCA, 0x0C, 0x71, 0x0C, 0xA0, 0xC7, 0x10, 0x8A, 0x08,
  0x72, 0x00, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_highlight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_highlight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_horizontal_distribute 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_editor_horizontal_distribute_data[] PROGMEM = {
  0x01, 0x05, 0x75, 0x81, 0x51, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07,
  0x95, 0x00, 0x85, 0x90, 0x07, 0x94, 0x01, 0xA0, 0x14, 0x90, 0x07, 0x94, 0x01, 0xA0, 0x14, 0x90,
  0x07, 0x94, 0x01, 0xA0, 0x14, 0x90, 0x07, 0x94, 0x01, 0xA0, 0x14, 0x90, 0x07, 0x94, 0x01, 0xA0,
  0x14, 0x90, 0x07, 0x94, 0x01, 0xA0, 0x14, 0x90, 0x07, 0x95, 0x00, 0x85, 0x90, 0x07, 0x97, 0x59,
  0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x81, 0x71, 0x57, 0x50, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_horizontal_distribute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_horizontal_distribute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_horizontal_rule 18x18, 4-bit Alpha,  RLE, 11 bytes.
static const unsigned char ic_round_18_editor_horizontal_rule_data[] PROGMEM = {
  0x01, 0x0C, 0x80, 0x6D, 0x82, 0xC1, 0x1C, 0x80, 0x6D, 0x0C, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_horizontal_rule() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 15, 9), Box(0, 0, 17, 17),
      ic_round_18_editor_horizontal_rule_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_chart_outlined 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_editor_insert_chart_outlined_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x40, 0x04, 0x49,
  0x00, 0x49, 0x40, 0x0A, 0x49, 0x87, 0x44, 0xF0, 0x57, 0x0A, 0xA4, 0x98, 0x74, 0x4F, 0x09, 0xB0,
  0xAA, 0x49, 0x87, 0x44, 0xF0, 0x9B, 0x0A, 0xA4, 0x98, 0xD2, 0x44, 0xF0, 0x9B, 0x0A, 0xA0, 0xA8,
  0x0F, 0x44, 0xF0, 0x9B, 0x0A, 0xA0, 0xB9, 0x0F, 0x44, 0xF0, 0x34, 0x04, 0x40, 0x43, 0x0F, 0x44,
  0x97, 0x39, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_chart_outlined() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_chart_outlined_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_chart 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_editor_insert_chart_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4D, 0x00, 0xBD, 0x00, 0x4D,
  0x00, 0x5D, 0x00, 0x4A, 0x83, 0xA8, 0xF5, 0x5D, 0x00, 0x4A, 0x83, 0x63, 0xF5, 0x5D, 0x00, 0x4A,
  0x83, 0x63, 0xF5, 0x5D, 0x00, 0x4A, 0x86, 0x63, 0xF5, 0x5F, 0x57, 0xA0, 0x04, 0xA8, 0x66, 0x3F,
  0x55, 0xF3, 0x6A, 0x00, 0x4A, 0x86, 0xBA, 0xFB, 0xBF, 0xAB, 0xA0, 0x04, 0xFD, 0x04, 0x02, 0xFD,
  0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_comment 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_editor_insert_comment_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3A, 0x0D, 0x80, 0x47, 0x0D, 0xA0,
  0x03, 0xA0, 0xA0, 0x28, 0x02, 0x10, 0x20, 0xAA, 0x00, 0x3F, 0xF0, 0x03, 0xA0, 0x97, 0x10, 0x9A,
  0x00, 0x3A, 0x0E, 0x80, 0x49, 0x0E, 0xA0, 0x03, 0xD0, 0xA8, 0x01, 0x70, 0xDA, 0x00, 0x3D, 0x07,
  0x80, 0x13, 0x0B, 0xA0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x30, 0x48, 0x06, 0x70, 0x9A, 0x03,
  0x76, 0x81, 0x7F, 0x37, 0x70, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_drive_file 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_editor_insert_drive_file_data[] PROGMEM = {
  0x10, 0x18, 0x01, 0x30, 0x24, 0x02, 0xF0, 0x73, 0x06, 0xD8, 0x2D, 0x4F, 0x72, 0x06, 0xD8, 0x5D,
  0x04, 0xF7, 0x06, 0xD0, 0xE2, 0x82, 0x4F, 0x46, 0xE8, 0x4D, 0xBB, 0xE6, 0x6F, 0xB0, 0x06, 0xFB,
  0x00, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x6F, 0xB0, 0x06, 0xFB, 0x06,
  0x02, 0xFB, 0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_drive_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_drive_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_emoticon 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_editor_insert_emoticon_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBA, 0x81, 0xA2, 0xAA, 0x81, 0xA2, 0xAA, 0x0B, 0x2B, 0x81, 0x70, 0x6A, 0x81,
  0x60, 0x7B, 0x10, 0x2C, 0x0B, 0xC0, 0xBC, 0x00, 0x2F, 0xF0, 0x21, 0xB0, 0xE8, 0x02, 0x70, 0xEB,
  0x20, 0xBB, 0x05, 0x40, 0x5B, 0x0B, 0x20, 0x3C, 0x82, 0xB7, 0x7B, 0xC0, 0x33, 0x09, 0xFB, 0x09,
  0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_emoticon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_emoticon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_invitation 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_editor_insert_invitation_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x48, 0x94, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x02, 0xFD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF2, 0x80, 0x41, 0x82, 0x2F, 0x44, 0x95,
  0x0F, 0x12, 0x90, 0x04, 0x95, 0xB8, 0x38, 0x0F, 0x44, 0x95, 0xB8, 0x39, 0x0F, 0x44, 0x95, 0xB8,
  0x39, 0x0F, 0x44, 0x95, 0x89, 0x06, 0x77, 0x30, 0xF4, 0x4F, 0x28, 0x04, 0x18, 0x32, 0xF4, 0x1E,
  0xFB, 0x82, 0xE1, 0x01, 0x80, 0x63, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_invitation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_invitation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_link 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_editor_insert_link_data[] PROGMEM = {
  0x38, 0x26, 0x99, 0x82, 0x82, 0x89, 0x96, 0x48, 0x42, 0xDE, 0xBB, 0xA2, 0x84, 0xAB, 0xBE, 0xD2,
  0x28, 0x1C, 0xB1, 0x71, 0x85, 0x1B, 0xC0, 0x1F, 0x32, 0x84, 0x59, 0x99, 0x95, 0x28, 0x44, 0xF1,
  0x1F, 0x42, 0x84, 0x59, 0x99, 0x95, 0x28, 0x44, 0xF1, 0x0C, 0xB7, 0x30, 0xB0, 0xC2, 0x84, 0x2D,
  0xEB, 0xBA, 0x28, 0x4A, 0xBB, 0xED, 0x23, 0x83, 0x16, 0x99, 0x82, 0x83, 0x89, 0x96, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_link() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_link_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_page_break 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_editor_insert_page_break_data[] PROGMEM = {
  0x30, 0x18, 0x01, 0x30, 0x27, 0x10, 0x2F, 0x07, 0x70, 0x6D, 0x82, 0xD4, 0xF7, 0x60, 0x6D, 0x83,
  0xD0, 0x4F, 0x75, 0x06, 0xD0, 0xE2, 0x81, 0x4F, 0x44, 0x06, 0xE8, 0x3D, 0xBB, 0xE6, 0x40, 0x6F,
  0xB0, 0x64, 0x06, 0xFB, 0x06, 0x30, 0xF1, 0x30, 0x01, 0x30, 0xF1, 0x10, 0x1B, 0x81, 0x40, 0xAA,
  0x81, 0xA0, 0x4B, 0x01, 0x10, 0xF3, 0x28, 0x21, 0x33, 0x12, 0x0F, 0x33, 0x05, 0x80, 0x6D, 0x05,
  0x40, 0x6F, 0xB0, 0x64, 0x06, 0xFB, 0x06, 0x40, 0x2F, 0xB0, 0x25, 0x01, 0x80, 0x43, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_page_break() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_page_break_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_insert_photo 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_editor_insert_photo_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4E, 0x0D, 0x07, 0xC0, 0x04, 0xB8, 0x49, 0x9F, 0x30, 0x8B, 0x00,
  0x4A, 0x0B, 0x20, 0x53, 0x0B, 0xA0, 0x04, 0xA0, 0xB8, 0x02, 0x50, 0xBA, 0x00, 0x4F, 0xD0, 0x40,
  0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_insert_photo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_insert_photo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_linear_scale 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_editor_linear_scale_data[] PROGMEM = {
  0x73, 0x82, 0x58, 0x61, 0x73, 0x85, 0x1C, 0xEC, 0xEE, 0x22, 0x81, 0x5B, 0x74, 0x81, 0x9D, 0x12,
  0x82, 0xBC, 0x01, 0xB8, 0x4A, 0x99, 0x9E, 0x73, 0x82, 0x3F, 0x11, 0xB8, 0x4A, 0x99, 0x9E, 0x73,
  0x85, 0x3F, 0x10, 0x5B, 0x74, 0x81, 0x9D, 0x12, 0x0B, 0x0C, 0x72, 0x85, 0x1C, 0xEC, 0xEE, 0x27,
  0x48, 0x25, 0x86, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_linear_scale() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_editor_linear_scale_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_line_axis 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_editor_line_axis_data[] PROGMEM = {
  0x48, 0x18, 0xB2, 0x73, 0x83, 0xAE, 0xCE, 0x34, 0x01, 0x03, 0x28, 0x5A, 0xE3, 0x0B, 0xE3, 0x38,
  0x4C, 0xC0, 0xAE, 0x33, 0x89, 0x3B, 0xE3, 0x0B, 0xE2, 0x9E, 0x30, 0x25, 0x28, 0x90, 0xBE, 0xBE,
  0x30, 0x73, 0x04, 0xA0, 0xA2, 0x81, 0xDF, 0x64, 0x89, 0x14, 0xF9, 0x4F, 0xA6, 0xFC, 0xE3, 0x28,
  0x14, 0xF9, 0x28, 0x91, 0x4E, 0xF7, 0x0A, 0xE3, 0x4F, 0x94, 0x02, 0x03, 0x38, 0x2A, 0xDC, 0x97,
  0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_line_axis() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_line_axis_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_margin 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_editor_margin_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4A, 0x86, 0xBA, 0xFB, 0xBF,
  0xAB, 0xA0, 0x04, 0xA8, 0x6A, 0x8F, 0x99, 0xF8, 0xAA, 0x00, 0x4F, 0xD0, 0x04, 0xA8, 0x6D, 0xCF,
  0xCC, 0xFC, 0xDA, 0x00, 0x4A, 0x86, 0x97, 0xF8, 0x8F, 0x79, 0xA0, 0x04, 0xFD, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_margin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_margin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_merge_type 18x18, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_round_18_editor_merge_type_data[] PROGMEM = {
  0x40, 0x0B, 0x70, 0xBA, 0x0B, 0x50, 0xBC, 0x0B, 0x48, 0x43, 0x3B, 0xB3, 0x36, 0x00, 0xA7, 0x10,
  0x0A, 0x71, 0x0A, 0x0B, 0x71, 0x81, 0x5F, 0x85, 0x84, 0x8A, 0x05, 0xF8, 0x38, 0x18, 0xF5, 0x28,
  0x55, 0xF8, 0x01, 0xF5, 0x48, 0x15, 0xF1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_merge_type() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_merge_type_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_mode_comment 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_18_editor_mode_comment_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F,
  0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF,
  0x81, 0x30, 0x48, 0x06, 0x70, 0x9A, 0x03, 0x76, 0x81, 0x7F, 0x37, 0x70, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_mode_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_mode_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_mode_edit_outline 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_editor_mode_edit_outline_data[] PROGMEM = {
  0x73, 0x00, 0x17, 0x48, 0x23, 0xEE, 0x37, 0x38, 0x31, 0xDF, 0xE1, 0x78, 0x53, 0xD2, 0x1D, 0xE1,
  0x68, 0x53, 0xEF, 0xE2, 0x13, 0x60, 0x30, 0xEB, 0x0D, 0x70, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x30,
  0xEB, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x20, 0xEB,
  0x0E, 0x03, 0x70, 0x4B, 0x0E, 0x03, 0x71, 0x04, 0xA0, 0xE0, 0x37, 0x28, 0x21, 0x33, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_mode_edit_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_mode_edit_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_mode_edit 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_editor_mode_edit_data[] PROGMEM = {
  0x73, 0x00, 0x17, 0x48, 0x23, 0xEE, 0x37, 0x38, 0x31, 0xDF, 0xE1, 0x78, 0x53, 0xD2, 0x1D, 0xE1,
  0x68, 0x53, 0xEF, 0xE2, 0x13, 0x60, 0x30, 0xEB, 0x0D, 0x70, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x30,
  0xEB, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x20, 0xEB,
  0x0E, 0x03, 0x70, 0x4B, 0x0E, 0x03, 0x71, 0x04, 0xA0, 0xE0, 0x37, 0x28, 0x21, 0x33, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_mode_edit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_mode_edit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_mode 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_editor_mode_data[] PROGMEM = {
  0x73, 0x00, 0x17, 0x48, 0x23, 0xEE, 0x37, 0x38, 0x31, 0xDF, 0xE1, 0x78, 0x53, 0xD2, 0x1D, 0xE1,
  0x68, 0x53, 0xEF, 0xE2, 0x13, 0x60, 0x30, 0xEB, 0x0D, 0x70, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x30,
  0xEB, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x30, 0xEB, 0x0E, 0x03, 0x60, 0x20, 0xEB,
  0x0E, 0x03, 0x70, 0x4B, 0x0E, 0x03, 0x71, 0x04, 0xA0, 0xE0, 0x37, 0x28, 0x21, 0x33, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_monetization_on 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_editor_monetization_on_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9C, 0x00, 0xCC, 0x09,
  0x30, 0x3C, 0x82, 0xB2, 0x2B, 0xC0, 0x32, 0x0B, 0xB8, 0x3E, 0x08, 0x81, 0xC0, 0xB2, 0xC8, 0x1C,
  0x0E, 0xF1, 0x02, 0xD8, 0x25, 0x06, 0xDD, 0x00, 0x2E, 0x82, 0xC5, 0x0C, 0xC0, 0x21, 0xC0, 0xE0,
  0xAA, 0x04, 0x08, 0xC2, 0x0B, 0xB8, 0x4D, 0x07, 0x81, 0xBB, 0x0B, 0x20, 0x3C, 0x82, 0xB3, 0x2A,
  0xC0, 0x33, 0x09, 0xC0, 0x0C, 0xC0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74,
  0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_monetization_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_monetization_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_money_off_csred 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_editor_money_off_csred_data[] PROGMEM = {
  0x60, 0x01, 0x50, 0xE0, 0x74, 0x00, 0x95, 0x81, 0x6F, 0x72, 0x82, 0x7E, 0xE8, 0x58, 0x76, 0xF7,
  0x08, 0x99, 0xF8, 0x58, 0x16, 0xF7, 0x30, 0x02, 0x68, 0x16, 0xF7, 0x74, 0x81, 0x6F, 0x77, 0x48,
  0x16, 0xF7, 0x74, 0x81, 0x6F, 0x77, 0x18, 0x4E, 0x70, 0x6F, 0x77, 0x85, 0xAF, 0xA8, 0xEF, 0x77,
  0x85, 0x7E, 0xE9, 0x7F, 0x77, 0x0A, 0x09, 0x28, 0x16, 0xF7, 0x60, 0x01, 0x30, 0x60, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_money_off_csred() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_money_off_csred_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_money_off 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_editor_money_off_data[] PROGMEM = {
  0x60, 0x01, 0x50, 0xE0, 0x74, 0x00, 0x95, 0x81, 0x6F, 0x72, 0x82, 0x7E, 0xE8, 0x58, 0x76, 0xF7,
  0x08, 0x99, 0xF8, 0x58, 0x16, 0xF7, 0x30, 0x02, 0x68, 0x16, 0xF7, 0x74, 0x81, 0x6F, 0x77, 0x48,
  0x16, 0xF7, 0x74, 0x81, 0x6F, 0x77, 0x18, 0x4E, 0x70, 0x6F, 0x77, 0x85, 0xAF, 0xA8, 0xEF, 0x77,
  0x85, 0x7E, 0xE9, 0x7F, 0x77, 0x0A, 0x09, 0x28, 0x16, 0xF7, 0x60, 0x01, 0x30, 0x60, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_money_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_money_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_move_down 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_editor_move_down_data[] PROGMEM = {
  0x48, 0x92, 0x35, 0x55, 0x10, 0x35, 0x55, 0x54, 0x30, 0x30, 0xDC, 0x05, 0x01, 0xE8, 0x42, 0x02,
  0xEC, 0x34, 0x81, 0x1F, 0x32, 0x84, 0x2F, 0x30, 0xAD, 0x68, 0x91, 0x1F, 0x63, 0x35, 0xF3, 0x0F,
  0x67, 0x0E, 0xC8, 0x3E, 0x11, 0xF4, 0x71, 0x80, 0x01, 0x30, 0xD0, 0x77, 0x18, 0x00, 0x13, 0x84,
  0x7E, 0x20, 0x79, 0x30, 0xEC, 0x0E, 0x01, 0x28, 0x6B, 0xE8, 0x8F, 0xA0, 0x1E, 0x03, 0x30, 0x60,
  0xCB, 0x03, 0x01, 0xE0, 0x35, 0x83, 0x6F, 0x60, 0x1E, 0x02, 0x50, 0x05, 0x38, 0x43, 0x55, 0x55,
  0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_move_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_move_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_move_up 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_editor_move_up_data[] PROGMEM = {
  0x50, 0x05, 0x38, 0x43, 0x55, 0x55, 0x46, 0x83, 0x6F, 0x60, 0x1E, 0x02, 0x30, 0x60, 0xCB, 0x03,
  0x01, 0xE0, 0x32, 0x86, 0xBE, 0x88, 0xFA, 0x01, 0xE8, 0x63, 0x07, 0xE2, 0x07, 0x93, 0x0E, 0xC8,
  0x3E, 0x10, 0xD7, 0x71, 0x80, 0x01, 0x28, 0x11, 0xF4, 0x71, 0x80, 0x01, 0x39, 0x06, 0x70, 0xEC,
  0x83, 0xE1, 0x0A, 0xD6, 0x89, 0x31, 0xF6, 0x33, 0x5F, 0x30, 0x2E, 0xC3, 0x48, 0x11, 0xF3, 0x28,
  0x12, 0xF3, 0x20, 0x30, 0xDC, 0x05, 0x01, 0xE0, 0x24, 0x89, 0x23, 0x55, 0x51, 0x03, 0x55, 0x55,
  0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_move_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_move_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_multiline_chart 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_editor_multiline_chart_data[] PROGMEM = {
  0x38, 0x34, 0x67, 0x51, 0x58, 0x52, 0x08, 0xEF, 0xDD, 0xA0, 0xB0, 0x22, 0x84, 0xBC, 0xBE, 0x71,
  0x38, 0x74, 0xCF, 0x59, 0xE3, 0x31, 0x20, 0x20, 0x43, 0x08, 0xA0, 0x44, 0x82, 0x2E, 0xF8, 0x28,
  0x16, 0xFE, 0x48, 0x91, 0x2E, 0xB6, 0xF8, 0x4F, 0x8E, 0x72, 0x81, 0x2E, 0xB2, 0x06, 0xA8, 0x69,
  0x08, 0xD0, 0x2E, 0xB4, 0x05, 0x07, 0x28, 0x34, 0xF1, 0xCB, 0x73, 0x81, 0x70, 0x27, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_multiline_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_multiline_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_notes 18x18, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_round_18_editor_notes_data[] PROGMEM = {
  0x02, 0xFD, 0x02, 0x18, 0x09, 0x03, 0x77, 0x10, 0x18, 0x09, 0x09, 0x00, 0x18, 0x09, 0x09, 0x01,
  0x77, 0x18, 0x03, 0x30, 0x15, 0x02, 0xF0, 0xA5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_notes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_editor_notes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_numbers 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_editor_numbers_data[] PROGMEM = {
  0x40, 0x10, 0x32, 0x01, 0x03, 0x60, 0x80, 0xB2, 0x08, 0x0C, 0x60, 0xC0, 0x82, 0x0C, 0x08, 0x28,
  0xA6, 0x1A, 0xBB, 0xFD, 0xBB, 0xFD, 0xBA, 0x09, 0x9C, 0xF9, 0x9B, 0xF9, 0x98, 0x30, 0x80, 0xC2,
  0x08, 0x0C, 0x60, 0xC0, 0x82, 0x0B, 0x08, 0x38, 0x91, 0x23, 0x4F, 0x73, 0x4F, 0x83, 0x21, 0xFC,
  0x0F, 0x18, 0x49, 0xC1, 0x19, 0xD0, 0xF1, 0x30, 0xC0, 0x82, 0x0B, 0x09, 0x60, 0x30, 0x12, 0x03,
  0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_numbers() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_numbers_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_padding 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_editor_padding_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4A, 0x86, 0xBA, 0xFB, 0xBF,
  0xAB, 0xA0, 0x04, 0xA8, 0x6A, 0x8F, 0x99, 0xF8, 0xAA, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02,
  0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_padding() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_padding_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_pentagon 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_editor_pentagon_data[] PROGMEM = {
  0x58, 0x23, 0xBB, 0x37, 0x20, 0x7C, 0x07, 0x60, 0x20, 0xCE, 0x0C, 0x02, 0x30, 0x60, 0xEF, 0x98,
  0x2E, 0x60, 0x9F, 0xD0, 0x90, 0xDF, 0xD0, 0xD0, 0x9F, 0xD0, 0x90, 0x3F, 0xD8, 0x13, 0x0D, 0xFB,
  0x0D, 0x20, 0x8F, 0xB0, 0x82, 0x03, 0xFB, 0x03, 0x30, 0xDF, 0x90, 0xD4, 0x06, 0xF9, 0x06, 0x58,
  0x04, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_pentagon() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_pentagon_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_pie_chart_outline 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_editor_pie_chart_outline_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x5B, 0xB6, 0xBF, 0x95, 0x81,
  0x9F, 0x52, 0x00, 0xA2, 0x81, 0x6F, 0x93, 0x81, 0x3F, 0x53, 0x00, 0xA3, 0x81, 0x6F, 0x32, 0x00,
  0xB4, 0x00, 0xA4, 0x00, 0xB2, 0x90, 0x54, 0x00, 0xA4, 0x84, 0x6F, 0x02, 0xF3, 0x48, 0x92, 0xAD,
  0x99, 0x99, 0xBF, 0x22, 0xF3, 0x48, 0x92, 0xAD, 0x99, 0x99, 0xBF, 0x20, 0xF5, 0x40, 0x0A, 0x40,
  0x69, 0x20, 0x0B, 0x40, 0x0A, 0x40, 0x0B, 0x28, 0x13, 0xF5, 0x30, 0x0A, 0x38, 0x16, 0xF3, 0x38,
  0x19, 0xF5, 0x20, 0x0A, 0x28, 0x16, 0xF9, 0x58, 0x90, 0x9F, 0xB5, 0xBB, 0x6B, 0xF9, 0x70, 0x30,
  0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_pie_chart_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_pie_chart_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_pie_chart 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_editor_pie_chart_data[] PROGMEM = {
  0x48, 0x64, 0xBF, 0x55, 0xFB, 0x46, 0x09, 0xB0, 0x05, 0xB0, 0x94, 0x09, 0xC0, 0x05, 0xC0, 0x92,
  0x04, 0xD0, 0x05, 0xD8, 0x14, 0x0B, 0xD0, 0x05, 0xD0, 0xB1, 0xE0, 0x05, 0xE0, 0x2E, 0x05, 0x01,
  0x80, 0x25, 0x02, 0xE0, 0x50, 0x18, 0x02, 0x51, 0xE0, 0x05, 0xE1, 0x0B, 0xD0, 0x05, 0xD8, 0x1B,
  0x04, 0xD0, 0x05, 0xD0, 0x42, 0x09, 0xC0, 0x05, 0xC0, 0x94, 0x09, 0xB0, 0x05, 0xB0, 0x96, 0x86,
  0x4B, 0xF5, 0x5F, 0xB3, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_pie_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_pie_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_polyline 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_editor_polyline_data[] PROGMEM = {
  0x68, 0x12, 0x33, 0x73, 0x03, 0xB0, 0x97, 0x20, 0x5B, 0x0A, 0x72, 0x05, 0xB0, 0xA7, 0x28, 0x39,
  0xFD, 0xD5, 0x71, 0x81, 0x7F, 0x47, 0x18, 0x34, 0x57, 0xF6, 0x71, 0x03, 0xB0, 0xC7, 0x20, 0x4B,
  0x0B, 0x72, 0x04, 0xB0, 0xC0, 0x17, 0x28, 0x49, 0xBB, 0xEE, 0x77, 0x48, 0x90, 0x18, 0xFD, 0x56,
  0xDD, 0xC1, 0x60, 0x10, 0x9D, 0x04, 0x71, 0x02, 0x0D, 0xB0, 0x47, 0x20, 0xAB, 0x03, 0x73, 0x81,
  0x33, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_polyline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_polyline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_post_add 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_editor_post_add_data[] PROGMEM = {
  0x72, 0x00, 0x17, 0x40, 0x60, 0x73, 0x8B, 0x16, 0x77, 0x77, 0x60, 0x7A, 0xB7, 0x15, 0xB5, 0x55,
  0x54, 0x05, 0x9A, 0x51, 0x67, 0x70, 0x50, 0x72, 0x86, 0x67, 0x07, 0xBB, 0xB8, 0x50, 0x60, 0x72,
  0x0F, 0x12, 0x04, 0x06, 0x28, 0x91, 0x67, 0x07, 0xDD, 0xD9, 0x06, 0x72, 0x89, 0x16, 0x70, 0x13,
  0x33, 0x20, 0x67, 0x28, 0x91, 0x67, 0x06, 0xBB, 0xB7, 0x06, 0x72, 0x06, 0x07, 0x70, 0x60, 0x72,
  0x05, 0x0C, 0x80, 0x37, 0x0B, 0x06, 0x38, 0x05, 0x53,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_post_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_post_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_publish 18x18, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_18_editor_publish_data[] PROGMEM = {
  0x18, 0x04, 0x31, 0x05, 0xF9, 0x05, 0x77, 0x00, 0x27, 0x82, 0x2E, 0xE2, 0x50, 0x20, 0xEA, 0x0E,
  0x02, 0x30, 0x20, 0xEC, 0x0E, 0x02, 0x20, 0xA0, 0xDC, 0x0D, 0x0A, 0x40, 0xCA, 0x0C, 0x60, 0xCA,
  0x0C, 0x60, 0xCA, 0x0C, 0x60, 0xCA, 0x0C, 0x68, 0x23, 0x55, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_publish() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_publish_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_query_stats 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_editor_query_stats_data[] PROGMEM = {
  0x77, 0x06, 0x09, 0x76, 0x81, 0x2F, 0x77, 0x60, 0xB0, 0xC7, 0x20, 0x90, 0x72, 0x81, 0x6F, 0x27,
  0x10, 0x5A, 0x82, 0x52, 0xE7, 0x58, 0x90, 0x82, 0x01, 0xE9, 0x9A, 0x7B, 0x58, 0x48, 0xFD, 0x1A,
  0xD7, 0x28, 0x93, 0x3F, 0x7D, 0xDF, 0x40, 0x6D, 0xDA, 0x13, 0x89, 0x3C, 0xB0, 0x2E, 0xA0, 0x6F,
  0x86, 0xDC, 0x28, 0x16, 0xF2, 0x50, 0xD0, 0x82, 0x84, 0x3F, 0x20, 0xB8, 0x60, 0xE0, 0x62, 0x81,
  0x2F, 0x37, 0x28, 0x4A, 0xD3, 0x2A, 0xE7, 0x30, 0x10, 0xCA, 0x81, 0xEF, 0x77, 0x48, 0x42, 0x30,
  0x7F, 0x67, 0x70, 0x60, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_query_stats() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_query_stats_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_rectangle 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_editor_rectangle_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0,
  0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81,
  0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_rectangle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_rectangle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_scatter_plot 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_editor_scatter_plot_data[] PROGMEM = {
  0x50, 0x01, 0x74, 0x09, 0xA0, 0xB7, 0x20, 0x5C, 0x08, 0x71, 0x08, 0xC0, 0xB7, 0x10, 0x5C, 0x08,
  0x72, 0x09, 0xA0, 0xB7, 0x10, 0x20, 0x40, 0xF1, 0x71, 0x07, 0xA0, 0xE0, 0x47, 0x10, 0x1C, 0x0E,
  0x71, 0x03, 0xD2, 0x83, 0x2C, 0xFD, 0x42, 0x0E, 0xB0, 0xC2, 0x0C, 0xB8, 0x6E, 0x10, 0x3D, 0xFB,
  0x22, 0xD0, 0x37, 0x10, 0xDC, 0x01, 0x71, 0x04, 0x0E, 0xA0, 0x67, 0x40, 0x30, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_scatter_plot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_scatter_plot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_schema 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_editor_schema_data[] PROGMEM = {
  0x10, 0x20, 0xF3, 0x71, 0x04, 0xC0, 0x67, 0x06, 0xC0, 0x87, 0x06, 0xC0, 0x87, 0x84, 0x2C, 0xEF,
  0xD3, 0x72, 0x09, 0x0B, 0x72, 0x03, 0x0E, 0xB8, 0x15, 0x06, 0xB8, 0x1E, 0x26, 0xC8, 0x1C, 0x9D,
  0xC0, 0x40, 0x6C, 0x81, 0xC9, 0xDC, 0x81, 0x43, 0xEB, 0x81, 0x50, 0x6B, 0x0E, 0x02, 0x20, 0x90,
  0xB7, 0x38, 0x25, 0xBD, 0x57, 0x10, 0x5C, 0x07, 0x70, 0x6C, 0x08, 0x70, 0x5C, 0x08, 0x78, 0x41,
  0x99, 0x99, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_schema() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_schema_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_score 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_editor_score_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4A, 0x85, 0xC2, 0x0E, 0x2B,
  0x6B, 0x00, 0x4A, 0x85, 0xD4, 0x0E, 0x12, 0xDB, 0x00, 0x4A, 0x85, 0xA2, 0x7F, 0x16, 0x9B, 0x00,
  0x4A, 0x89, 0x2D, 0x77, 0xF9, 0xEA, 0xFE, 0xF4, 0x4B, 0x0D, 0x0E, 0xC8, 0x35, 0x2F, 0x44, 0xA8,
  0x2B, 0x01, 0xDA, 0x89, 0x65, 0x0B, 0xF4, 0x4F, 0xB0, 0x53, 0x1D, 0x50, 0xBA, 0x86, 0x44, 0xF2,
  0x5F, 0xE3, 0x20, 0xBB, 0x82, 0x44, 0xFE, 0xB8, 0x1E, 0x6B, 0xC0, 0x40, 0x2F, 0xD8, 0x12, 0x02,
  0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_shape_line 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_editor_shape_line_data[] PROGMEM = {
  0x18, 0x36, 0xDF, 0xD6, 0x60, 0x01, 0x30, 0x6D, 0x06, 0x40, 0x9A, 0x07, 0x20, 0xDD, 0x0D, 0x30,
  0x2C, 0x01, 0x1F, 0x30, 0x2C, 0x81, 0x10, 0xDD, 0x0D, 0x30, 0x7B, 0x09, 0x20, 0x6D, 0x06, 0x28,
  0x37, 0xF7, 0x22, 0x48, 0x36, 0xDF, 0xD6, 0x28, 0x17, 0xF7, 0x76, 0x81, 0x7F, 0x77, 0x68, 0x17,
  0xF7, 0x76, 0x81, 0x7F, 0x73, 0x80, 0x03, 0x48, 0x32, 0x27, 0xF7, 0x30, 0xEC, 0x0D, 0x20, 0x9B,
  0x07, 0x30, 0x3E, 0x00, 0x1C, 0x02, 0x30, 0x3E, 0x00, 0x1C, 0x02, 0x30, 0x3E, 0x81, 0x10, 0x7A,
  0x09, 0x40, 0x3E, 0x01, 0x20, 0x01, 0x60, 0xDC, 0x0C, 0x75, 0x80, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_shape_line() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_editor_shape_line_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_short_text 18x18, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_round_18_editor_short_text_data[] PROGMEM = {
  0x18, 0x06, 0x31, 0x04, 0xFB, 0x04, 0x18, 0x06, 0x12, 0x80, 0x21, 0x50, 0x4E, 0x0A, 0x58, 0x02,
  0x30, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_short_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 14, 11), Box(0, 0, 17, 17),
      ic_round_18_editor_short_text_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_show_chart 18x18, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_18_editor_show_chart_data[] PROGMEM = {
  0x76, 0x02, 0x75, 0x0B, 0x0C, 0x74, 0x81, 0x9E, 0x34, 0x02, 0x04, 0x48, 0x18, 0xF4, 0x48, 0x22,
  0xEF, 0x82, 0x81, 0x6F, 0x64, 0x87, 0x2E, 0xB6, 0xF8, 0x4F, 0x74, 0x81, 0x2E, 0xB2, 0x06, 0xA0,
  0x94, 0x81, 0x2E, 0xB4, 0x05, 0x07, 0x50, 0xC0, 0xB7, 0x50, 0x27, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_show_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_show_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_space_bar 18x18, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_round_18_editor_space_bar_data[] PROGMEM = {
  0x03, 0x09, 0x71, 0x82, 0x93, 0x6E, 0x71, 0x81, 0xE6, 0x69, 0x80, 0x47, 0x90, 0x60, 0x28, 0x06,
  0xB0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_space_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 14, 10), Box(0, 0, 17, 17),
      ic_round_18_editor_space_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_square 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_editor_square_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F,
  0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_square() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_square_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_stacked_line_chart 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_editor_stacked_line_chart_data[] PROGMEM = {
  0x76, 0x81, 0x2A, 0x17, 0x58, 0x11, 0xDD, 0x75, 0x82, 0x1C, 0xE2, 0x60, 0x70, 0x94, 0x81, 0xBF,
  0x36, 0x08, 0xA0, 0xB2, 0x83, 0xAF, 0x50, 0x24, 0x89, 0x38, 0xFA, 0x7F, 0xB9, 0xF6, 0x08, 0xF1,
  0x28, 0x18, 0xFA, 0x20, 0x7A, 0x83, 0x80, 0x7F, 0x82, 0x89, 0x37, 0xFA, 0x01, 0x20, 0x68, 0x05,
  0xFA, 0x28, 0x61, 0xFA, 0x02, 0xDF, 0x42, 0x81, 0x4F, 0xB4, 0x89, 0x22, 0x02, 0xDE, 0xDF, 0x42,
  0xEC, 0x15, 0x89, 0x02, 0xDE, 0x41, 0xDF, 0xED, 0x15, 0x82, 0x2D, 0xE4, 0x28, 0x21, 0xDE, 0x26,
  0x81, 0xDE, 0x45, 0x01, 0x70, 0xA0, 0x47, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_stacked_line_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_stacked_line_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_strikethrough_s 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_editor_strikethrough_s_data[] PROGMEM = {
  0x68, 0x21, 0x45, 0x17, 0x40, 0x50, 0xEB, 0x06, 0x73, 0x84, 0xEC, 0x33, 0xBD, 0x73, 0x03, 0x01,
  0x73, 0x04, 0x80, 0x90, 0x58, 0x24, 0x01, 0xEF, 0xD0, 0xE0, 0x17, 0x77, 0x48, 0x12, 0x94, 0x71,
  0x81, 0x2B, 0x22, 0x81, 0x1F, 0x87, 0x18, 0x62, 0xED, 0x43, 0xAF, 0x57, 0x20, 0x50, 0xEB, 0x09,
  0x74, 0x82, 0x15, 0x52, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_strikethrough_s() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_strikethrough_s_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_subscript 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_editor_subscript_data[] PROGMEM = {
  0x10, 0x44, 0x04, 0x69, 0x08, 0x20, 0x89, 0x68, 0x47, 0xF2, 0x2F, 0x77, 0x82, 0xDB, 0xBC, 0x71,
  0x03, 0xA0, 0x37, 0x10, 0x5A, 0x04, 0x71, 0x82, 0xDB, 0xBD, 0x78, 0x49, 0xE2, 0x2E, 0x92, 0x84,
  0x31, 0x02, 0xF7, 0x28, 0x77, 0xF2, 0x4B, 0xE1, 0x17, 0x48, 0x47, 0x10, 0x5C, 0x27, 0x18, 0x16,
  0xA6, 0x72, 0x82, 0x6B, 0x91, 0x72, 0x00, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_subscript() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_subscript_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_superscript 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_editor_superscript_data[] PROGMEM = {
  0x71, 0x81, 0x13, 0x27, 0x28, 0x23, 0x9D, 0x17, 0x18, 0x51, 0x7D, 0x20, 0x71, 0x28, 0x41, 0x70,
  0x79, 0x42, 0x0E, 0x0A, 0x28, 0x94, 0xAE, 0x06, 0xDB, 0x10, 0x5F, 0x44, 0xF5, 0x20, 0x03, 0x38,
  0x2B, 0xDD, 0xB7, 0x10, 0x2A, 0x02, 0x71, 0x07, 0xA0, 0x67, 0x84, 0x1E, 0x99, 0xE1, 0x68, 0x4B,
  0xE1, 0x1E, 0xB5, 0x81, 0x3F, 0x52, 0x81, 0x5F, 0x35, 0x04, 0x40, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_superscript() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_superscript_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_table_chart 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_editor_table_chart_data[] PROGMEM = {
  0x10, 0x28, 0x07, 0x38, 0x11, 0x02, 0xFD, 0x81, 0xE1, 0x4F, 0xE0, 0x30, 0x4F, 0xE0, 0x31, 0x80,
  0x91, 0x11, 0x89, 0x62, 0x99, 0x90, 0x58, 0x88, 0x41, 0x99, 0x91, 0x4B, 0x10, 0xAB, 0x08, 0x01,
  0xB0, 0x30, 0x4B, 0x10, 0xAB, 0x08, 0x01, 0xB0, 0x30, 0x4B, 0x10, 0xAB, 0x08, 0x01, 0xB0, 0x30,
  0x4B, 0x10, 0xAB, 0x08, 0x01, 0xB0, 0x30, 0x4B, 0x10, 0xAB, 0x08, 0x01, 0xB0, 0x30, 0x4B, 0x10,
  0xAB, 0x08, 0x01, 0xB0, 0x30, 0x2B, 0x10, 0xAB, 0x08, 0x01, 0xA8, 0x96, 0xE1, 0x02, 0x33, 0x03,
  0x44, 0x42, 0x03, 0x31, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_table_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_table_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_table_rows 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_18_editor_table_rows_data[] PROGMEM = {
  0x10, 0x38, 0x06, 0x58, 0x13, 0x02, 0xFD, 0x00, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x20,
  0x28, 0x06, 0x58, 0x12, 0x02, 0xFD, 0x00, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x65, 0x02, 0x20, 0x28,
  0x06, 0x38, 0x12, 0x02, 0xFD, 0x00, 0x2F, 0xD8, 0x12, 0x03, 0x80, 0x65, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_table_rows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_table_rows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_text_decrease 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_editor_text_decrease_data[] PROGMEM = {
  0x30, 0x50, 0x37, 0x48, 0x25, 0xFE, 0x17, 0x38, 0x2B, 0xBE, 0x67, 0x28, 0x31, 0xF5, 0xAC, 0x72,
  0x84, 0x7E, 0x04, 0xF2, 0x28, 0x01, 0x91, 0x84, 0xDA, 0x12, 0xE8, 0x28, 0x01, 0x90, 0x3D, 0x0D,
  0x78, 0x69, 0xE3, 0x33, 0x6F, 0x46, 0x0E, 0x08, 0x40, 0xD0, 0x96, 0x05, 0x01, 0x40, 0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_text_decrease() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_text_decrease_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_text_fields 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_editor_text_fields_data[] PROGMEM = {
  0x10, 0x48, 0x03, 0x50, 0x26, 0x01, 0xF9, 0x0A, 0x78, 0x74, 0x55, 0xBF, 0x75, 0x52, 0x73, 0x81,
  0x9F, 0x37, 0x68, 0x19, 0xF3, 0x28, 0x49, 0xBB, 0xBB, 0xA5, 0x81, 0x9F, 0x32, 0x0D, 0xC0, 0xD0,
  0x14, 0x81, 0x9F, 0x34, 0x0D, 0x0E, 0x78, 0x19, 0xF3, 0x40, 0xD0, 0xE7, 0x81, 0x9F, 0x34, 0x0D,
  0x0E, 0x78, 0x19, 0xF3, 0x40, 0xD0, 0xE7, 0x81, 0x8F, 0x24, 0x0C, 0x0D, 0x70, 0x10, 0x45, 0x02,
  0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_text_fields() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_text_fields_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_text_increase 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_editor_text_increase_data[] PROGMEM = {
  0x30, 0x50, 0x37, 0x48, 0x25, 0xFE, 0x17, 0x38, 0x2B, 0xBE, 0x65, 0x09, 0x38, 0x31, 0xF5, 0xAC,
  0x48, 0x12, 0xF2, 0x28, 0x47, 0xE0, 0x4F, 0x22, 0x89, 0x29, 0xAF, 0xA9, 0x0D, 0xA1, 0x2E, 0x82,
  0x84, 0x9A, 0xFA, 0x93, 0xD0, 0xD3, 0x89, 0x22, 0xF2, 0x09, 0xE3, 0x33, 0x6F, 0x43, 0x09, 0x20,
  0xE0, 0x84, 0x0D, 0x09, 0x60, 0x50, 0x14, 0x00, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_text_increase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_text_increase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_title 18x18, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_round_18_editor_title_data[] PROGMEM = {
  0x18, 0x04, 0x51, 0x06, 0xF9, 0x85, 0x60, 0x55, 0x5E, 0xE0, 0xF5, 0x50, 0x0D, 0x71, 0x00, 0xD7,
  0x10, 0x0D, 0x71, 0x00, 0xD7, 0x10, 0x0D, 0x71, 0x00, 0xD7, 0x10, 0x0D, 0x71, 0x00, 0xD7, 0x10,
  0x07, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_title() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_editor_title_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_type_specimen 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_editor_type_specimen_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x7F, 0xC8, 0x33, 0x06, 0x07, 0xC0, 0xE0, 0x9D,
  0x83, 0x33, 0xF2, 0x7C, 0x81, 0x60, 0xBC, 0x83, 0x33, 0xF2, 0x7C, 0x81, 0x19, 0x5C, 0x83, 0x33,
  0xF2, 0x7B, 0x83, 0xA5, 0xE1, 0xEB, 0x83, 0x33, 0xF2, 0x7B, 0x83, 0x42, 0x30, 0x9B, 0x83, 0x33,
  0xF2, 0x7A, 0x84, 0xD1, 0xBB, 0x93, 0xB8, 0x33, 0x3F, 0x27, 0xA0, 0xC0, 0x8B, 0x05, 0xB8, 0x33,
  0x3F, 0x27, 0xFC, 0x83, 0x33, 0xF2, 0x6F, 0xC8, 0x41, 0x3F, 0x20, 0x68, 0x05, 0x78, 0x34, 0x03,
  0xF3, 0x80, 0x51, 0x50, 0xEF, 0xB0, 0x65, 0x80, 0x63, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_type_specimen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_type_specimen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_vertical_align_bottom 18x18, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_round_18_editor_vertical_align_bottom_data[] PROGMEM = {
  0x50, 0x01, 0x73, 0x00, 0x97, 0x30, 0x0A, 0x73, 0x00, 0xA7, 0x30, 0x0A, 0x73, 0x00, 0xA7, 0x30,
  0x0A, 0x72, 0x82, 0x1B, 0xB1, 0x71, 0x0E, 0xA0, 0xD7, 0x18, 0x22, 0xEE, 0x27, 0x20, 0x02, 0x77,
  0x30, 0x4F, 0xB0, 0x41, 0x80, 0x63, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_vertical_align_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_vertical_align_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_vertical_align_center 18x18, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_round_18_editor_vertical_align_center_data[] PROGMEM = {
  0x50, 0x09, 0x73, 0x00, 0xA7, 0x28, 0x27, 0xCC, 0x77, 0x10, 0xAA, 0x0A, 0x72, 0x00, 0xA7, 0x73,
  0x01, 0x80, 0x67, 0x01, 0x03, 0x80, 0x6D, 0x03, 0x77, 0x30, 0x0A, 0x72, 0x0A, 0xA0, 0xA7, 0x18,
  0x27, 0xCC, 0x77, 0x20, 0x0A, 0x73, 0x00, 0x95,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_vertical_align_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_vertical_align_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_vertical_align_top 18x18, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_round_18_editor_vertical_align_top_data[] PROGMEM = {
  0x18, 0x06, 0x31, 0x04, 0xFB, 0x04, 0x77, 0x30, 0x02, 0x72, 0x82, 0x2E, 0xE2, 0x71, 0x0D, 0xA0,
  0xE7, 0x18, 0x21, 0xBB, 0x17, 0x20, 0x0A, 0x73, 0x00, 0xA7, 0x30, 0x0A, 0x73, 0x00, 0xA7, 0x30,
  0x0A, 0x73, 0x00, 0x97, 0x30, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_vertical_align_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_editor_vertical_align_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_vertical_distribute 18x18, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_round_18_editor_vertical_distribute_data[] PROGMEM = {
  0x01, 0x80, 0x92, 0x70, 0x10, 0x5F, 0xF0, 0x58, 0x09, 0x81, 0x08, 0x02, 0x17, 0x20, 0x8E, 0x08,
  0x71, 0x08, 0xE0, 0x87, 0x28, 0x02, 0x18, 0x09, 0x81, 0x00, 0x5F, 0xF0, 0x50, 0x18, 0x09, 0x27,
  0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_vertical_distribute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_editor_vertical_distribute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_editor_wrap_text 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_editor_wrap_text_data[] PROGMEM = {
  0x18, 0x06, 0x52, 0x03, 0xFB, 0x03, 0x77, 0x77, 0x80, 0x55, 0x02, 0x20, 0x4F, 0xB0, 0x77, 0x48,
  0x17, 0xF1, 0x60, 0x13, 0x89, 0x71, 0xF3, 0x03, 0x33, 0x02, 0xD7, 0x34, 0xAE, 0x04, 0xB0, 0x10,
  0x9C, 0x0D, 0x03, 0x70, 0xA0, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_editor_wrap_text() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_editor_wrap_text_data, Alpha4(color::Black));
  return value;
}
