#include "av.h"

using namespace roo_display;

// Image file ic_round_18_av_10k 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_av_10k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x89,
  0x64, 0x4F, 0xA3, 0xC6, 0x35, 0xD7, 0x8C, 0xF4, 0x4A, 0x86, 0x5A, 0x3C, 0x1C, 0x13, 0xA0, 0x04,
  0xA8, 0x66, 0xA3, 0xC1, 0xC1, 0x3A, 0x00, 0x4A, 0x89, 0x29, 0xC6, 0x35, 0xD7, 0x8C, 0xF4, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_10k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_10k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_1k_plus 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_av_1k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x86, 0x93, 0xD6, 0xC8, 0xFC, 0xA0, 0x04, 0xB8, 0x91, 0x4C, 0x12, 0xCA, 0x19, 0xF4, 0x4B,
  0x89, 0x14, 0xC1, 0x2C, 0xA1, 0x9F, 0x44, 0xB8, 0x57, 0xD6, 0xC8, 0xFC, 0xA0, 0x04, 0xFD, 0x00,
  0x4F, 0xD0, 0x04, 0xFD, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_1k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_1k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_1k 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_av_1k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4B, 0x84, 0x84, 0xE6, 0xB9, 0xB0, 0x04, 0xB8, 0x4E, 0x2D, 0x02, 0xDB, 0x00, 0x4C, 0x83, 0x3D,
  0x02, 0xDB, 0x00, 0x4C, 0x83, 0x6E, 0x6B, 0x9B, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0,
  0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_1k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_1k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_2k_plus 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_av_2k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x86, 0x43, 0x8A, 0xA6, 0xFC, 0xA0, 0x04, 0xA8, 0xB0, 0x74, 0x58, 0x16, 0xA1, 0x9F, 0x44,
  0xFE, 0x05, 0xB8, 0x16, 0xA1, 0x9F, 0x44, 0xA8, 0x64, 0x38, 0xAA, 0x6F, 0xCA, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_2k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_2k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_2k 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_av_2k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x85, 0xE3, 0x39, 0x9B, 0x6B, 0x00, 0x4B, 0x84, 0x63, 0x66, 0x18, 0xB0, 0x04, 0xA8, 0x5D,
  0x15, 0xC6, 0x18, 0xB0, 0x04, 0xA8, 0x5E, 0x33, 0xA9, 0xB6, 0xB0, 0x04, 0xFD, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_2k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_2k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_3k_plus 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_av_3k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x86, 0x43, 0x8A, 0xA6, 0xFC, 0xA0, 0x04, 0xA8, 0x92, 0xD4, 0x58, 0x16, 0xA1, 0x9F, 0x44,
  0xA8, 0x92, 0xD4, 0x58, 0x16, 0xA1, 0x9F, 0x44, 0xA8, 0x64, 0x38, 0xAA, 0x6F, 0xCA, 0x00, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_3k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_3k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_3k 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_av_3k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x85, 0xE3, 0x39, 0x9B, 0x6B, 0x00, 0x4B, 0x84, 0xC4, 0x66, 0x18, 0xB0, 0x04, 0xB8, 0x4C,
  0x46, 0x61, 0x8B, 0x00, 0x4A, 0x85, 0xE3, 0x39, 0x9B, 0x6B, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_3k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_3k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_4k_plus 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_av_4k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x89,
  0x24, 0x4F, 0xAB, 0x7D, 0x9B, 0x6F, 0xCA, 0x8B, 0x44, 0x4F, 0x79, 0x4C, 0x61, 0x8A, 0x19, 0xF4,
  0x4F, 0x91, 0x06, 0x61, 0x8A, 0x19, 0xF4, 0x4B, 0x85, 0x7D, 0x9B, 0x6F, 0xCA, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_4k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_4k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_4k 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_av_4k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x86, 0x9C, 0x6E, 0xE6, 0xAB, 0xA0, 0x04, 0xA8, 0x66, 0xA3, 0xDD, 0x12, 0xEA, 0x00, 0x4A,
  0x86, 0x81, 0x03, 0xD1, 0x2E, 0xA0, 0x04, 0xC8, 0x46, 0xEE, 0x6A, 0xBA, 0x00, 0x4F, 0xD0, 0x04,
  0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_4k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_4k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_5g 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_round_18_av_5g_data[] PROGMEM = {
  0x8F, 0x24, 0xBB, 0xA0, 0x7B, 0xBB, 0x47, 0x83, 0x30, 0xE3, 0x33, 0x07, 0xA7, 0x40, 0xD0, 0x77,
  0x22, 0x77, 0xD1, 0xD0, 0x7A, 0x70, 0x33, 0xD1, 0xE3, 0x38, 0x74, 0xBB, 0x80, 0x7B, 0xBA, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_5g() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 13, 11), Box(0, 0, 17, 17),
      ic_round_18_av_5g_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_5k_plus 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_av_5k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x89,
  0x24, 0x4F, 0xA3, 0x3E, 0x6C, 0x8F, 0xCA, 0x8C, 0x64, 0x4F, 0x73, 0x6E, 0x12, 0xCA, 0x19, 0xF4,
  0x4F, 0xC5, 0x1C, 0x12, 0xCA, 0x19, 0xF4, 0x4F, 0xA3, 0x3D, 0x6C, 0x8F, 0xCA, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_5k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_5k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_5k 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_av_5k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x85, 0xE3, 0x3A, 0x9B, 0x6B, 0x00, 0x4A, 0x85, 0xD1, 0x5C, 0x61, 0x8B, 0x00, 0x4B, 0x84,
  0x63, 0x66, 0x18, 0xB0, 0x04, 0xA8, 0x5E, 0x33, 0x99, 0xB6, 0xB0, 0x04, 0xFD, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_5k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_5k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_6k_plus 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_av_6k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x86, 0x43, 0x8A, 0xA6, 0xFC, 0xA8, 0xB4, 0x44, 0xFE, 0x05, 0xB8, 0x16, 0xA1, 0x9F, 0x44,
  0xFE, 0x15, 0x58, 0x16, 0xA1, 0x9F, 0x44, 0xA8, 0x64, 0x38, 0xAA, 0x6F, 0xCA, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_6k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_6k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_6k 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_av_6k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x85, 0xE3, 0x3A, 0x9B, 0x6B, 0x00, 0x4A, 0x85, 0xD1, 0x5C, 0x61, 0x8B, 0x00, 0x4A, 0x85,
  0xD1, 0x46, 0x61, 0x8B, 0x00, 0x4A, 0x85, 0xE3, 0x39, 0x9B, 0x6B, 0x00, 0x4F, 0xD0, 0x04, 0xFD,
  0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_6k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_6k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_7k_plus 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_av_7k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x89,
  0x24, 0x4F, 0xD3, 0x3A, 0x8C, 0x6F, 0xCA, 0x00, 0x4A, 0x89, 0x2D, 0x5B, 0x51, 0xAA, 0x19, 0xF4,
  0x4B, 0x89, 0x12, 0xF5, 0x1A, 0xA1, 0x9F, 0x44, 0xA8, 0x6D, 0x7F, 0x8C, 0x6F, 0xCA, 0x00, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_7k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_7k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_7k 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_av_7k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x85, 0xE3, 0x38, 0x9B, 0x6B, 0x00, 0x4B, 0x84, 0xD6, 0x96, 0x18, 0xB0, 0x04, 0xC8, 0x33,
  0xE6, 0x18, 0xB0, 0x04, 0xC8, 0x36, 0xF9, 0xB6, 0xB0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD,
  0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_7k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_7k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_8k_plus 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_av_8k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x86, 0x43, 0x8A, 0xA6, 0xFC, 0xA8, 0xB4, 0x44, 0xFE, 0x17, 0x58, 0x16, 0xA1, 0x9F, 0x44,
  0xFE, 0x17, 0x58, 0x16, 0xA1, 0x9F, 0x44, 0xA8, 0x64, 0x38, 0xAA, 0x6F, 0xCA, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_8k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_8k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_8k 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_av_8k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x85, 0xE3, 0x39, 0x9B, 0x6B, 0x00, 0x4A, 0x85, 0xD2, 0x66, 0x61, 0x8B, 0x00, 0x4A, 0x85,
  0xD2, 0x66, 0x61, 0x8B, 0x00, 0x4A, 0x85, 0xE3, 0x39, 0x9B, 0x6B, 0x00, 0x4F, 0xD0, 0x04, 0xFD,
  0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_8k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_8k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_9k_plus 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_av_9k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x86, 0x43, 0x8A, 0xA6, 0xFC, 0xA8, 0x96, 0x44, 0xFE, 0x15, 0x58, 0x16, 0xA1, 0x9F, 0x44,
  0xA8, 0x92, 0x74, 0x58, 0x16, 0xA1, 0x9F, 0x44, 0xA8, 0x64, 0x38, 0xAA, 0x6F, 0xCA, 0x00, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_9k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_9k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_9k 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_av_9k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x85, 0xE3, 0x39, 0x9B, 0x6B, 0x00, 0x4A, 0x85, 0xD1, 0x46, 0x61, 0x8B, 0x00, 0x4B, 0x84,
  0x63, 0x66, 0x18, 0xB0, 0x04, 0xA8, 0x5E, 0x33, 0x99, 0xB6, 0xB0, 0x04, 0xFD, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_9k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_9k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_add_to_queue 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_av_add_to_queue_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x24, 0x00, 0x44, 0x84, 0x2F, 0x33, 0xF2, 0x40, 0x0A, 0x48, 0x42, 0xF3, 0x3F, 0x22, 0x84, 0x49,
  0xDD, 0x94, 0x28, 0x42, 0xF3, 0x3F, 0x22, 0x84, 0x6B, 0xEE, 0xB6, 0x28, 0x42, 0xF3, 0x3F, 0x24,
  0x00, 0xA4, 0x84, 0x2F, 0x33, 0xF2, 0x40, 0x06, 0x48, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3,
  0x19, 0x80, 0x90, 0xD9, 0x85, 0x10, 0x47, 0x77, 0xDC, 0x83, 0xD7, 0x77, 0x46, 0x09, 0xC0, 0x97,
  0x48, 0x00, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_add_to_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_av_add_to_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_airplay 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_av_airplay_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x24, 0x00,
  0x94, 0x89, 0x02, 0xF3, 0x1F, 0xDD, 0x30, 0xAA, 0x89, 0x3A, 0x03, 0xDD, 0xF1, 0x04, 0x77, 0x1A,
  0xC8, 0x3A, 0x17, 0x74, 0x50, 0x2E, 0x02, 0x72, 0x80, 0x23, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_airplay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_av_airplay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_album 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_av_album_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xC8, 0x2C, 0x77, 0xCC, 0x03, 0x20, 0xBB, 0x07, 0x40, 0x7B, 0x0B, 0x2B, 0x0C, 0x60, 0xCB, 0x10,
  0x2B, 0x07, 0x20, 0x08, 0x20, 0x7B, 0x00, 0x2B, 0x07, 0x20, 0x08, 0x20, 0x7B, 0x02, 0x1B, 0x0C,
  0x60, 0xCB, 0x20, 0xBB, 0x07, 0x40, 0x7B, 0x0B, 0x20, 0x3C, 0x82, 0xC7, 0x7C, 0xC0, 0x33, 0x09,
  0xFB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_album() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_album_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_art_track 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_av_art_track_data[] PROGMEM = {
  0x10, 0x28, 0x05, 0x52, 0x03, 0x20, 0x42, 0x0E, 0xFA, 0x86, 0x80, 0xE5, 0x3F, 0x11, 0xFB, 0x86,
  0xA0, 0xE6, 0x3F, 0x11, 0xFB, 0x86, 0xA0, 0xE6, 0x3F, 0x11, 0xFB, 0x86, 0xA0, 0xE6, 0x3F, 0x11,
  0xFB, 0x86, 0xA0, 0xE6, 0x3F, 0x11, 0xB8, 0x2D, 0xFE, 0x5B, 0x86, 0xA0, 0xE6, 0x3F, 0x11, 0xA8,
  0x4E, 0x18, 0x30, 0x7A, 0x86, 0xA0, 0xE6, 0x3F, 0x11, 0xA0, 0x88, 0x01, 0x38, 0x90, 0xDF, 0xA0,
  0xE6, 0x3F, 0x11, 0xFB, 0x87, 0xA0, 0xE6, 0x3F, 0x10, 0xEF, 0xA8, 0x78, 0x0E, 0x53, 0xF1, 0x02,
  0x80, 0x55, 0x20, 0x32, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_art_track() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_av_art_track_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_audio_file 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_av_audio_file_data[] PROGMEM = {
  0x10, 0x18, 0x01, 0x30, 0x24, 0x02, 0xF0, 0x73, 0x06, 0xD8, 0x2D, 0x4F, 0x72, 0x06, 0xD8, 0x5D,
  0x04, 0xF7, 0x06, 0xD0, 0xE2, 0x82, 0x4F, 0x46, 0xE8, 0x4D, 0xBB, 0xE6, 0x6F, 0xB0, 0x06, 0xD8,
  0x15, 0x13, 0xA0, 0x06, 0xD1, 0x01, 0x03, 0xA0, 0x06, 0xB8, 0x1E, 0xE1, 0xC0, 0x06, 0xA0, 0xB2,
  0x01, 0xC0, 0x06, 0xA0, 0x52, 0x01, 0xC0, 0x06, 0xA0, 0x92, 0x06, 0xC0, 0x06, 0xB0, 0xB0, 0xAD,
  0x06, 0x02, 0xFB, 0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_audio_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_av_audio_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_av_timer 18x18, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_round_18_av_av_timer_data[] PROGMEM = {
  0x71, 0x02, 0x77, 0x08, 0xA0, 0xB0, 0x37, 0x01, 0x38, 0x4A, 0xB5, 0xBF, 0x95, 0x81, 0x8F, 0x72,
  0x00, 0xA2, 0x81, 0x5F, 0x93, 0x86, 0x3F, 0xAF, 0x70, 0x22, 0x38, 0x15, 0xF4, 0x28, 0x4A, 0xB0,
  0x7F, 0x76, 0x00, 0xB2, 0x90, 0x52, 0x81, 0x7F, 0x75, 0x8C, 0x45, 0xF0, 0x2F, 0x33, 0xC1, 0x7F,
  0x50, 0x1C, 0x33, 0xF2, 0x2F, 0x33, 0xC1, 0x05, 0x40, 0x1C, 0x33, 0xF2, 0x0F, 0x57, 0x30, 0x69,
  0x20, 0x0B, 0x40, 0x01, 0x40, 0xB0, 0xA2, 0x81, 0x4F, 0x53, 0x00, 0xC3, 0x81, 0x5F, 0x33, 0x81,
  0x9F, 0x52, 0x00, 0x32, 0x81, 0x5E, 0x75, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x77, 0x03, 0x0B,
  0xB8, 0x1E, 0xA3, 0x74, 0x02, 0x01, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_av_timer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_av_timer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_branding_watermark 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_av_branding_watermark_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3E, 0x84,
  0xA9, 0x99, 0x9D, 0xA0, 0x03, 0xD0, 0xB5, 0x01, 0xA0, 0x03, 0xD0, 0xA6, 0xA0, 0x03, 0xD0, 0xA6,
  0xA0, 0x03, 0xD0, 0xB5, 0x02, 0xA0, 0x03, 0xE8, 0x4E, 0xDD, 0xDD, 0xEA, 0x03, 0x01, 0xFF, 0x81,
  0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_branding_watermark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_branding_watermark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_call_to_action 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_av_call_to_action_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0,
  0x03, 0xFF, 0x00, 0x3B, 0x0E, 0x80, 0x2D, 0x0E, 0xB0, 0x03, 0xA0, 0xA7, 0x10, 0xAA, 0x00, 0x3A,
  0x0A, 0x71, 0x0A, 0xA0, 0x03, 0xB8, 0x04, 0xDB, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05,
  0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_call_to_action() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_call_to_action_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_closed_caption_disabled 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_18_av_closed_caption_disabled_data[] PROGMEM = {
  0x03, 0x05, 0x76, 0x83, 0x7F, 0x70, 0x5F, 0x98, 0x6E, 0x40, 0xCF, 0x70, 0x5F, 0x98, 0x1B, 0x0B,
  0xA8, 0x17, 0x05, 0xF8, 0x1B, 0x0B, 0xB8, 0x57, 0x05, 0xFC, 0xBB, 0xA8, 0xA3, 0xB0, 0xBF, 0x89,
  0xF7, 0x03, 0x01, 0x08, 0xFB, 0x0B, 0xF7, 0x5A, 0x8B, 0x77, 0x01, 0xFD, 0xEF, 0xB0, 0xBF, 0x75,
  0xFD, 0xF7, 0x05, 0xDE, 0xFB, 0x0B, 0xF8, 0x01, 0x0D, 0xF7, 0x28, 0x38, 0xFB, 0x0B, 0xA8, 0x1B,
  0xBC, 0xB8, 0x57, 0x06, 0xFB, 0x0B, 0xFA, 0x84, 0x70, 0x6B, 0x0B, 0xFB, 0x84, 0x70, 0x30, 0x4E,
  0xFB, 0x07, 0x76, 0x81, 0x9F, 0x57, 0x60, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_closed_caption_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_closed_caption_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_closed_caption_off 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_av_closed_caption_off_data[] PROGMEM = {
  0x10, 0x38, 0x06, 0x58, 0x13, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4A, 0x81, 0xED, 0xEA, 0x81,
  0xED, 0xEA, 0x82, 0x44, 0xFD, 0x30, 0x0C, 0x38, 0xC0, 0xDF, 0x44, 0xFC, 0x2F, 0xCE, 0xA3, 0xFC,
  0xEF, 0x44, 0xFC, 0x2F, 0xCE, 0xA3, 0xFC, 0xEF, 0x44, 0xFD, 0x30, 0x0C, 0x38, 0x2D, 0xF4, 0x4A,
  0x81, 0xED, 0xEA, 0x81, 0xED, 0xEA, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x03, 0x80, 0x65,
  0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_closed_caption_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_av_closed_caption_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_closed_caption 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_av_closed_caption_data[] PROGMEM = {
  0x10, 0x38, 0x06, 0x58, 0x13, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4A, 0x81, 0xED, 0xEA, 0x81,
  0xED, 0xEA, 0x82, 0x44, 0xFD, 0x30, 0x0C, 0x38, 0xC0, 0xDF, 0x44, 0xFC, 0x2F, 0xCE, 0xA3, 0xFC,
  0xEF, 0x44, 0xFC, 0x2F, 0xCE, 0xA3, 0xFC, 0xEF, 0x44, 0xFD, 0x30, 0x0C, 0x38, 0x2D, 0xF4, 0x4A,
  0x81, 0xED, 0xEA, 0x81, 0xED, 0xEA, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x03, 0x80, 0x65,
  0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_closed_caption() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_av_closed_caption_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_control_camera 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_av_control_camera_data[] PROGMEM = {
  0x60, 0x80, 0x97, 0x48, 0x2A, 0xEE, 0xA7, 0x28, 0x49, 0xE3, 0x3E, 0x97, 0x10, 0x60, 0x32, 0x03,
  0x06, 0x60, 0x90, 0x62, 0x00, 0x22, 0x06, 0x09, 0x38, 0x3A, 0xE3, 0x09, 0xA8, 0x91, 0x90, 0x3E,
  0xA0, 0x9E, 0x30, 0x2C, 0x89, 0x02, 0x03, 0xE8, 0x8E, 0x30, 0x2C, 0x89, 0x12, 0x03, 0xE9, 0x0A,
  0xE3, 0x09, 0xA8, 0x39, 0x03, 0xEA, 0x30, 0x90, 0x62, 0x00, 0x22, 0x06, 0x09, 0x60, 0x60, 0x32,
  0x03, 0x06, 0x71, 0x84, 0x9E, 0x33, 0xE9, 0x72, 0x82, 0xAE, 0xEA, 0x74, 0x09, 0x08, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_control_camera() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_control_camera_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_equalizer 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_av_equalizer_data[] PROGMEM = {
  0x50, 0x03, 0x72, 0x03, 0xA0, 0x37, 0x10, 0x5A, 0x05, 0x71, 0x05, 0xA0, 0x57, 0x10, 0x5A, 0x82,
  0x50, 0x9A, 0x50, 0x5A, 0x05, 0x04, 0xA8, 0x45, 0x1D, 0xC1, 0x5A, 0x05, 0x04, 0xA0, 0x60, 0x5A,
  0x04, 0x05, 0xA0, 0x50, 0x4A, 0x00, 0x6A, 0x04, 0x05, 0xA0, 0x50, 0x4A, 0x00, 0x6A, 0x04, 0x05,
  0xA0, 0x50, 0x4A, 0x06, 0x04, 0xA0, 0x20, 0x3A, 0x03, 0x02, 0xA8, 0x24, 0x04, 0x32, 0x00, 0x32,
  0x03, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_equalizer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_av_equalizer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_explicit 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_av_explicit_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4C, 0x83, 0x75, 0x56, 0xEB,
  0x00, 0x4B, 0x84, 0xB0, 0x33, 0x4E, 0xB0, 0x04, 0xB8, 0x1B, 0x0D, 0xE0, 0x04, 0xB8, 0x4B, 0x05,
  0x56, 0xEB, 0x00, 0x4B, 0x84, 0xB0, 0x55, 0x6E, 0xB0, 0x04, 0xB8, 0x1B, 0x0D, 0xE0, 0x04, 0xB8,
  0x4B, 0x03, 0x34, 0xEB, 0x00, 0x4C, 0x83, 0x75, 0x56, 0xEB, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8,
  0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_explicit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_explicit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_fast_forward 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_av_fast_forward_data[] PROGMEM = {
  0x02, 0x07, 0x60, 0x80, 0x14, 0x82, 0x4F, 0xD3, 0x38, 0x21, 0xFE, 0x53, 0x04, 0xB8, 0x29, 0x10,
  0x1B, 0x82, 0xB1, 0x04, 0xC8, 0x1D, 0x31, 0xC8, 0x1E, 0x54, 0xC8, 0x1D, 0x31, 0xC8, 0x1E, 0x64,
  0xB8, 0x29, 0x10, 0x1B, 0x85, 0xB2, 0x04, 0xFD, 0x33, 0x82, 0x1F, 0xE5, 0x30, 0x20, 0x76, 0x08,
  0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_fast_forward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_av_fast_forward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_fast_rewind 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_av_fast_rewind_data[] PROGMEM = {
  0x40, 0x10, 0x86, 0x07, 0x02, 0x38, 0x25, 0xEF, 0x13, 0x85, 0x3D, 0xF4, 0x02, 0xBB, 0x82, 0x10,
  0x19, 0xB8, 0x14, 0x6E, 0xC8, 0x11, 0x3D, 0xC8, 0x14, 0x6E, 0xC8, 0x11, 0x3D, 0xC8, 0x24, 0x02,
  0xBB, 0x82, 0x10, 0x19, 0xB0, 0x43, 0x82, 0x5E, 0xF1, 0x38, 0x23, 0xDF, 0x44, 0x01, 0x08, 0x60,
  0x70, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_fast_rewind() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_av_fast_rewind_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_featured_play_list 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_av_featured_play_list_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xA8, 0x5C, 0x43, 0x33,
  0x38, 0xD0, 0x03, 0xA0, 0xC8, 0x01, 0x50, 0x9D, 0x00, 0x3A, 0x85, 0xD8, 0x77, 0x77, 0xBD, 0x00,
  0x3A, 0x0A, 0x80, 0x11, 0x06, 0xD0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF,
  0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_featured_play_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_featured_play_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_featured_video 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_av_featured_video_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3A, 0x84, 0xED, 0xDD, 0xDE, 0xE0, 0x03,
  0xA0, 0x25, 0x0B, 0xD0, 0x03, 0xA6, 0x0A, 0xD0, 0x03, 0xA6, 0x0A, 0xD0, 0x03, 0xA0, 0x15, 0x0B,
  0xD0, 0x03, 0xA8, 0x4D, 0x99, 0x99, 0xAE, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81,
  0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_featured_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_featured_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_fiber_dvr 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_av_fiber_dvr_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3A, 0x89,
  0x0A, 0x35, 0xD8, 0x8B, 0x34, 0xCA, 0x00, 0x3A, 0x89, 0x07, 0x84, 0xB3, 0x3B, 0x24, 0x8A, 0x00,
  0x3A, 0x89, 0x07, 0x84, 0xC3, 0x3C, 0x21, 0xEA, 0x00, 0x3A, 0x89, 0x0A, 0x35, 0xF9, 0x9D, 0x79,
  0xDA, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_fiber_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_fiber_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_fiber_manual_record 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_round_18_av_fiber_manual_record_data[] PROGMEM = {
  0x38, 0x22, 0x66, 0x25, 0x09, 0xC0, 0x93, 0x09, 0xE8, 0x19, 0x02, 0xF9, 0x02, 0x06, 0xF9, 0x00,
  0x6F, 0x90, 0x60, 0x2F, 0x98, 0x12, 0x09, 0xE0, 0x93, 0x09, 0xC0, 0x95, 0x82, 0x26, 0x62, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_fiber_manual_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_av_fiber_manual_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_fiber_new 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_av_fiber_new_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x89, 0x80, 0x33,
  0xFB, 0x79, 0xC6, 0x36, 0xD7, 0xFA, 0xBF, 0x33, 0xF9, 0x03, 0xA3, 0x58, 0xC4, 0x57, 0x9F, 0x33,
  0xF9, 0x30, 0xA3, 0x58, 0xC4, 0x26, 0x9F, 0x33, 0xFB, 0xA6, 0xD6, 0x36, 0xD3, 0x33, 0xBF, 0x33,
  0xFF, 0x00, 0x3F, 0xF0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_fiber_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_fiber_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_fiber_pin 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_av_fiber_pin_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3A, 0x89,
  0x0A, 0x35, 0xFA, 0xAE, 0x5B, 0xAA, 0x00, 0x3A, 0x89, 0x07, 0x84, 0xC8, 0x8C, 0x03, 0x7A, 0x00,
  0x3A, 0x89, 0x07, 0x13, 0xE8, 0x8C, 0x30, 0x7A, 0x00, 0x3A, 0x0A, 0x0B, 0xA8, 0x4A, 0xAD, 0x78,
  0xAA, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_fiber_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_fiber_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_fiber_smart_record 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_av_fiber_smart_record_data[] PROGMEM = {
  0x38, 0x90, 0x5B, 0xED, 0x92, 0x01, 0xA5, 0x50, 0xAD, 0x84, 0xE3, 0x1A, 0xF9, 0x30, 0x7F, 0x84,
  0xE1, 0x04, 0xE7, 0x20, 0xEF, 0x90, 0x62, 0x82, 0x8E, 0x02, 0xFA, 0x0A, 0x28, 0x23, 0xF1, 0x2F,
  0xA0, 0xA2, 0x83, 0x3F, 0x10, 0xEF, 0x90, 0x62, 0x08, 0x0E, 0x20, 0x7F, 0x84, 0xE1, 0x04, 0xF7,
  0x30, 0xAD, 0x84, 0xE3, 0x1A, 0xF9, 0x58, 0x90, 0x5B, 0xED, 0x92, 0x01, 0xA5, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_fiber_smart_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_av_fiber_smart_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_forward_10 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_av_forward_10_data[] PROGMEM = {
  0x70, 0xA0, 0x17, 0x38, 0x32, 0x5F, 0xD1, 0x70, 0x40, 0xDC, 0x05, 0x68, 0x57, 0xFA, 0x30, 0xF7,
  0x68, 0x14, 0xF7, 0x30, 0x37, 0x0C, 0x0A, 0x74, 0x89, 0x01, 0xF4, 0x07, 0xD0, 0xCD, 0x84, 0x81,
  0x4F, 0x12, 0x83, 0xC1, 0xD3, 0xA4, 0x81, 0x3F, 0x12, 0x89, 0x2C, 0x1E, 0x6A, 0x01, 0xF2, 0x0E,
  0x52, 0x89, 0x27, 0x0A, 0xB6, 0x05, 0xF1, 0x0A, 0xC7, 0x10, 0xC0, 0xA2, 0x81, 0x1E, 0x96, 0x81,
  0x9F, 0x23, 0x89, 0x04, 0xEC, 0x63, 0x36, 0xDE, 0x45, 0x81, 0x19, 0xEB, 0x0A, 0x02, 0x72, 0x00,
  0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_forward_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_forward_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_forward_30 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_av_forward_30_data[] PROGMEM = {
  0x70, 0xA0, 0x17, 0x38, 0x32, 0x5F, 0xD1, 0x70, 0x40, 0xDC, 0x05, 0x68, 0x57, 0xFA, 0x30, 0xF7,
  0x68, 0x14, 0xF7, 0x30, 0x37, 0x0C, 0x0A, 0x74, 0x89, 0x11, 0xF4, 0x0D, 0xD6, 0x6D, 0xD1, 0x38,
  0x91, 0x4F, 0x10, 0x1A, 0x88, 0x5B, 0x23, 0x8B, 0x53, 0xF1, 0x03, 0xB8, 0x87, 0xC2, 0x1F, 0x20,
  0xE5, 0x0B, 0xB5, 0x5B, 0xB1, 0x5F, 0x10, 0xAC, 0x71, 0x0C, 0x0A, 0x28, 0x11, 0xE9, 0x68, 0x19,
  0xF2, 0x38, 0x90, 0x4E, 0xC6, 0x33, 0x6D, 0xE4, 0x58, 0x11, 0x9E, 0xB0, 0xA0, 0x27, 0x20, 0x01,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_forward_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_forward_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_forward_5 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_av_forward_5_data[] PROGMEM = {
  0x70, 0xA0, 0x17, 0x38, 0x32, 0x5F, 0xD1, 0x70, 0x40, 0xDC, 0x05, 0x68, 0x57, 0xFA, 0x30, 0xF7,
  0x68, 0x14, 0xF7, 0x30, 0x37, 0x0C, 0x0A, 0x74, 0x81, 0x1F, 0x42, 0x82, 0x4D, 0xD3, 0x58, 0x14,
  0xF1, 0x28, 0x25, 0xB7, 0x25, 0x81, 0x3F, 0x12, 0x82, 0x19, 0xC5, 0x28, 0x41, 0xF2, 0x0E, 0x52,
  0x82, 0x2B, 0xB2, 0x28, 0x45, 0xF1, 0x0A, 0xC7, 0x10, 0xC0, 0xA2, 0x81, 0x1E, 0x96, 0x81, 0x9F,
  0x23, 0x89, 0x04, 0xEC, 0x63, 0x36, 0xDE, 0x45, 0x81, 0x19, 0xEB, 0x0A, 0x02, 0x72, 0x00, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_forward_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_forward_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_games 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_av_games_data[] PROGMEM = {
  0x68, 0x22, 0x33, 0x27, 0x40, 0x2C, 0x02, 0x73, 0x03, 0xC0, 0x37, 0x30, 0x3C, 0x03, 0x73, 0x03,
  0xC0, 0x36, 0x84, 0x23, 0x33, 0x09, 0xA8, 0x69, 0x03, 0x33, 0x20, 0x1C, 0x84, 0x90, 0x77, 0x09,
  0xC0, 0x10, 0x3D, 0x07, 0x20, 0x7D, 0x00, 0x3D, 0x07, 0x20, 0x7D, 0x03, 0x01, 0xC8, 0x49, 0x07,
  0x70, 0x9C, 0x86, 0x10, 0x23, 0x33, 0x09, 0xA8, 0x49, 0x02, 0x33, 0x26, 0x03, 0xC0, 0x37, 0x30,
  0x3C, 0x03, 0x73, 0x03, 0xC0, 0x37, 0x30, 0x2C, 0x02, 0x74, 0x82, 0x23, 0x32, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_games() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_games_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_hd 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_av_hd_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3B, 0x86,
  0x9C, 0x6E, 0xE4, 0x3B, 0xB0, 0x03, 0xB8, 0x66, 0x51, 0xDD, 0x29, 0x6B, 0x00, 0x3B, 0x86, 0x65,
  0x1D, 0xD2, 0x96, 0xB0, 0x03, 0xB8, 0x69, 0xC6, 0xEE, 0x43, 0xBB, 0x00, 0x3F, 0xF0, 0x03, 0xFF,
  0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_hd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_hd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_hearing_disabled 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_av_hearing_disabled_data[] PROGMEM = {
  0x01, 0x40, 0x03, 0x20, 0x10, 0x33, 0x89, 0x29, 0x70, 0x5D, 0xAA, 0xD8, 0x2D, 0x33, 0x82, 0xB7,
  0x31, 0x38, 0x28, 0xA4, 0xB3, 0x89, 0x21, 0xF7, 0x06, 0x71, 0x0B, 0x3C, 0x22, 0x89, 0x24, 0x9B,
  0x74, 0xEA, 0x06, 0x78, 0x55, 0x87, 0xB7, 0x4C, 0x05, 0x88, 0x55, 0x81, 0x2C, 0x72, 0x82, 0x95,
  0xA3, 0x78, 0x4B, 0x70, 0xC1, 0xD7, 0x28, 0x3B, 0x70, 0x96, 0x71, 0x83, 0x3D, 0xB7, 0x27, 0x28,
  0x3C, 0x30, 0xB7, 0x50, 0x52, 0x04, 0x0B, 0x30, 0xB0, 0x74, 0x83, 0x7D, 0xAD, 0x24, 0x0B, 0x07,
  0x40, 0x10, 0x37, 0x09, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_hearing_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_hearing_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_hearing 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_av_hearing_data[] PROGMEM = {
  0x20, 0x20, 0x14, 0x02, 0x68, 0x41, 0xE7, 0x03, 0xCB, 0x09, 0x01, 0x38, 0x92, 0x8D, 0x05, 0xFA,
  0x43, 0x6D, 0xD1, 0x28, 0x3E, 0x71, 0xE8, 0x48, 0xA7, 0x1D, 0xA0, 0x3F, 0x26, 0xE0, 0x1C, 0xF8,
  0x05, 0xF1, 0x4F, 0x08, 0xB0, 0x6B, 0x28, 0x79, 0x14, 0xF1, 0x8D, 0x03, 0xA0, 0xD4, 0x89, 0x01,
  0xF4, 0x3F, 0x30, 0x47, 0x25, 0x84, 0xCA, 0x0B, 0xD3, 0x71, 0x85, 0x4F, 0x41, 0xBF, 0x67, 0x10,
  0x80, 0x52, 0x81, 0x7F, 0x47, 0x50, 0xA0, 0xC7, 0x58, 0x14, 0xF2, 0x20, 0x57, 0x28, 0x3C, 0xB3,
  0x9E, 0x72, 0x83, 0x2D, 0xFE, 0x57, 0x40, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_hearing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_hearing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_high_quality 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_av_high_quality_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3B, 0x86,
  0x9C, 0x6E, 0xE4, 0x39, 0xB0, 0x03, 0xB8, 0x66, 0x51, 0xDD, 0x29, 0x6B, 0x00, 0x3B, 0x86, 0x65,
  0x1D, 0xD2, 0x96, 0xB0, 0x03, 0xB8, 0x69, 0xC6, 0xEE, 0x31, 0x9B, 0x00, 0x3F, 0x90, 0xD0, 0x9C,
  0x00, 0x3F, 0xF0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_high_quality() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_high_quality_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_interpreter_mode 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_av_interpreter_mode_data[] PROGMEM = {
  0x58, 0x53, 0x51, 0x01, 0x54, 0x73, 0x09, 0xA8, 0x13, 0x3E, 0xA0, 0xB7, 0x10, 0x3A, 0x81, 0xD0,
  0xBC, 0x05, 0x70, 0x5A, 0x81, 0xC0, 0xDC, 0x06, 0x78, 0x41, 0xEF, 0xE0, 0x8C, 0x02, 0x71, 0x89,
  0x24, 0xCE, 0x40, 0x9E, 0xD5, 0x05, 0x87, 0x50, 0x13, 0x81, 0xCF, 0x23, 0x85, 0x29, 0xB1, 0x07,
  0xCA, 0x0E, 0x28, 0x1C, 0xF3, 0x20, 0x8A, 0x81, 0x52, 0xEC, 0x85, 0xD0, 0x89, 0xE4, 0x61, 0xB0,
  0x10, 0x8E, 0x85, 0x18, 0x75, 0xB1, 0x1B, 0x10, 0x9E, 0x82, 0xA0, 0x5A, 0x30, 0xF5, 0x10, 0x38,
  0x03, 0x58, 0x12, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_interpreter_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_av_interpreter_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_library_add_check 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_av_library_add_check_data[] PROGMEM = {
  0x48, 0x05, 0x34, 0x08, 0xFA, 0x03, 0x30, 0x9F, 0xA8, 0x34, 0x14, 0x09, 0xE8, 0x68, 0xCF, 0x44,
  0x90, 0x9D, 0x89, 0x17, 0x4E, 0xF4, 0x49, 0x09, 0xFE, 0xA8, 0x17, 0x4E, 0xA8, 0x91, 0x44, 0x90,
  0x9F, 0x85, 0x74, 0xEB, 0x83, 0x44, 0x90, 0x9A, 0x81, 0x64, 0xEC, 0x83, 0x44, 0x90, 0x9F, 0xA8,
  0x34, 0x49, 0x09, 0xFA, 0x83, 0x44, 0x90, 0x28, 0x04, 0x98, 0x28, 0x04, 0x97, 0x50, 0x30, 0xD8,
  0x04, 0x90, 0x44, 0x80, 0x53, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_library_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_library_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_library_add 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_av_library_add_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x7F, 0xC8, 0x33, 0x06, 0x07, 0xC0, 0xE0, 0x9D,
  0x83, 0x33, 0xF2, 0x7C, 0x0A, 0x1D, 0x83, 0x33, 0xF2, 0x7C, 0x0A, 0x1D, 0x83, 0x33, 0xF2, 0x7A,
  0x05, 0x50, 0x9A, 0x83, 0x33, 0xF2, 0x7A, 0x85, 0xD9, 0x60, 0x99, 0xEA, 0x83, 0x33, 0xF2, 0x7C,
  0x0A, 0x1D, 0x83, 0x33, 0xF2, 0x7C, 0x0D, 0x05, 0xD8, 0x33, 0x3F, 0x27, 0xFC, 0x83, 0x33, 0xF2,
  0x6F, 0xC8, 0x41, 0x3F, 0x20, 0x68, 0x05, 0x78, 0x34, 0x03, 0xF3, 0x80, 0x51, 0x50, 0xEF, 0xB0,
  0x65, 0x80, 0x63, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_library_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_library_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_library_books 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_av_library_books_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x7F, 0xC8, 0x33, 0x06, 0x07, 0xA0, 0xB8, 0x01,
  0x70, 0xDA, 0x83, 0x33, 0xF2, 0x7A, 0x85, 0x71, 0x11, 0x12, 0xAA, 0x83, 0x33, 0xF2, 0x7A, 0x0D,
  0x80, 0x1B, 0x0E, 0xA8, 0x33, 0x3F, 0x27, 0xA0, 0x45, 0x09, 0xA8, 0x33, 0x3F, 0x27, 0xB8, 0x01,
  0xDB, 0x83, 0x33, 0xF2, 0x7A, 0x05, 0x20, 0x5D, 0x83, 0x33, 0xF2, 0x7A, 0x82, 0xC9, 0x9C, 0xD8,
  0x33, 0x3F, 0x27, 0xFC, 0x83, 0x33, 0xF2, 0x6F, 0xC8, 0x41, 0x3F, 0x20, 0x68, 0x05, 0x78, 0x34,
  0x03, 0xF3, 0x80, 0x51, 0x50, 0xEF, 0xB0, 0x65, 0x80, 0x63, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_library_books() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_library_books_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_library_music 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_av_library_music_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x7F, 0xC8, 0x33, 0x06, 0x07, 0xD0, 0x92, 0x0B,
  0xA8, 0x33, 0x3F, 0x27, 0xD8, 0x25, 0x12, 0xCA, 0x83, 0x33, 0xF2, 0x7D, 0x05, 0x0B, 0xC8, 0x33,
  0x3F, 0x27, 0xB8, 0x2E, 0xA4, 0xBC, 0x83, 0x33, 0xF2, 0x7A, 0x0E, 0x01, 0x20, 0xBC, 0x83, 0x33,
  0xF2, 0x7A, 0x0A, 0x30, 0xCC, 0x83, 0x33, 0xF2, 0x7A, 0x82, 0xE2, 0x03, 0xD8, 0x33, 0x3F, 0x27,
  0xB0, 0xE0, 0xCE, 0x83, 0x33, 0xF2, 0x6F, 0xC8, 0x41, 0x3F, 0x20, 0x68, 0x05, 0x78, 0x34, 0x03,
  0xF3, 0x80, 0x51, 0x50, 0xEF, 0xB0, 0x65, 0x80, 0x63, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_library_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_library_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_loop 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_av_loop_data[] PROGMEM = {
  0x60, 0xA0, 0x17, 0x18, 0x32, 0x5F, 0xC1, 0x50, 0x20, 0xBC, 0x05, 0x48, 0x52, 0xED, 0x40, 0xF7,
  0x50, 0xB0, 0xD3, 0x03, 0x58, 0x12, 0xF4, 0x68, 0x21, 0xE2, 0x59, 0x71, 0x90, 0x05, 0x97, 0x19,
  0x82, 0x52, 0xE1, 0x68, 0x14, 0xF2, 0x50, 0x33, 0x0D, 0x0B, 0x58, 0x57, 0xF0, 0x4D, 0xE2, 0x40,
  0x5C, 0x0B, 0x02, 0x58, 0x31, 0xDF, 0x52, 0x71, 0x01, 0x0A, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_loop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_av_loop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_lyrics 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_18_av_lyrics_data[] PROGMEM = {
  0x77, 0x0F, 0x12, 0x80, 0x43, 0x02, 0x30, 0xAA, 0x10, 0xEF, 0xA0, 0x52, 0x82, 0xAB, 0x33, 0xFB,
  0x07, 0x28, 0x2A, 0xA0, 0x3A, 0x89, 0x5B, 0x77, 0x77, 0x8F, 0x90, 0x37, 0xCA, 0x03, 0xA8, 0x78,
  0x11, 0x11, 0x3F, 0x16, 0xB8, 0x1A, 0x03, 0xF9, 0x81, 0xD0, 0xCB, 0x81, 0x90, 0x3A, 0x07, 0x48,
  0x21, 0xE0, 0xAB, 0x81, 0x70, 0x3A, 0x89, 0x2C, 0x99, 0x99, 0xAF, 0x41, 0xBE, 0xA2, 0x03, 0xA8,
  0x2B, 0x77, 0xDB, 0x0E, 0x03, 0x50, 0x3A, 0x82, 0x93, 0x3D, 0xC0, 0x95, 0x03, 0xFB, 0x09, 0x50,
  0x3F, 0xB0, 0x75, 0x03, 0xA0, 0x98, 0x02, 0x70, 0x66, 0x81, 0x3F, 0x77, 0x70, 0x30, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_lyrics() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_av_lyrics_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_mic_none 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_av_mic_none_data[] PROGMEM = {
  0x40, 0x01, 0x70, 0x8A, 0x08, 0x58, 0x42, 0xF7, 0x7F, 0x24, 0x84, 0x3F, 0x11, 0xF3, 0x48, 0x43,
  0xF1, 0x1F, 0x34, 0x84, 0x3F, 0x11, 0xF3, 0x48, 0x43, 0xF1, 0x1F, 0x32, 0x8C, 0x04, 0x13, 0xF2,
  0x2F, 0x31, 0x4C, 0x90, 0xEC, 0xCE, 0x09, 0xC7, 0xE1, 0x3A, 0xA3, 0x1E, 0x70, 0xDD, 0x32, 0x81,
  0x3D, 0xD2, 0x86, 0x1B, 0xFE, 0xEF, 0xB1, 0x48, 0x23, 0xCC, 0x37, 0x00, 0x97, 0x10, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_mic_none() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_av_mic_none_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_mic_off 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_av_mic_off_data[] PROGMEM = {
  0x70, 0x01, 0x70, 0x24, 0x08, 0xA0, 0x85, 0x81, 0x1E, 0x72, 0x02, 0xC0, 0x25, 0x83, 0x6F, 0x70,
  0x3C, 0x03, 0x68, 0x36, 0xF7, 0x09, 0xB0, 0x37, 0x83, 0x6F, 0x70, 0x9A, 0x03, 0x71, 0x85, 0x6F,
  0x70, 0x9F, 0x37, 0x89, 0x04, 0x16, 0xF7, 0x09, 0x31, 0x45, 0x84, 0xC9, 0x06, 0xF7, 0x20, 0x80,
  0xC5, 0x89, 0x07, 0xE1, 0x06, 0xF7, 0x08, 0x76, 0x85, 0xDD, 0x30, 0x6F, 0x77, 0x18, 0x31, 0xBF,
  0xEE, 0xA0, 0x77, 0x28, 0x53, 0xCC, 0x36, 0xF7, 0x72, 0x00, 0x92, 0x81, 0x6F, 0x77, 0x10, 0x01,
  0x38, 0x16, 0xE2, 0x76, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_mic_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_mic_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_mic 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_av_mic_data[] PROGMEM = {
  0x40, 0x01, 0x70, 0x8A, 0x08, 0x50, 0x2C, 0x02, 0x40, 0x3C, 0x03, 0x40, 0x3C, 0x03, 0x40, 0x3C,
  0x03, 0x40, 0x3C, 0x03, 0x28, 0x14, 0x13, 0xC8, 0x53, 0x14, 0xC9, 0x0E, 0xA8, 0xA0, 0xE0, 0x9C,
  0x7E, 0x13, 0xAA, 0x31, 0xE7, 0x0D, 0xD3, 0x28, 0x13, 0xDD, 0x28, 0x61, 0xBF, 0xEE, 0xFB, 0x14,
  0x82, 0x3C, 0xC3, 0x70, 0x09, 0x71, 0x00, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_av_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_missed_video_call 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_av_missed_video_call_data[] PROGMEM = {
  0x10, 0x38, 0x04, 0x50, 0x44, 0x02, 0xFB, 0x05, 0x30, 0x4F, 0xB0, 0x73, 0x04, 0xFB, 0x83, 0x71,
  0xC2, 0x4A, 0x81, 0x83, 0xAD, 0x83, 0x8C, 0xF3, 0x4A, 0x81, 0x60, 0xBA, 0x08, 0x0E, 0xC0, 0x30,
  0x4A, 0x84, 0xCD, 0x2B, 0x74, 0xD0, 0x30, 0x4C, 0x81, 0xD1, 0x4B, 0x83, 0x8C, 0xF3, 0x4D, 0x0E,
  0xC8, 0x37, 0x1B, 0x24, 0xFB, 0x07, 0x30, 0x2F, 0xB0, 0x54, 0x03, 0x80, 0x45, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_missed_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_missed_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_movie 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_av_movie_data[] PROGMEM = {
  0x10, 0x30, 0x52, 0x89, 0x25, 0x10, 0x52, 0x04, 0x55, 0x30, 0x1A, 0x87, 0x70, 0xAA, 0x08, 0xC0,
  0x6B, 0x01, 0x03, 0xA8, 0x90, 0xE1, 0x3F, 0x21, 0xE4, 0x0D, 0xA0, 0x03, 0xB8, 0x7C, 0xBF, 0xDB,
  0xED, 0xBD, 0xA0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00,
  0x3F, 0xF0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_movie() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_movie_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_music_video 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_av_music_video_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x25, 0x81, 0x59, 0x42, 0x84, 0x2F,
  0x33, 0xF2, 0x58, 0x1E, 0xB6, 0x28, 0x42, 0xF3, 0x3F, 0x25, 0x0D, 0x48, 0x42, 0xF3, 0x3F, 0x25,
  0x0D, 0x48, 0x42, 0xF3, 0x3F, 0x22, 0x82, 0x2C, 0xED, 0x48, 0x42, 0xF3, 0x3F, 0x22, 0x09, 0xA0,
  0xD4, 0x84, 0x2F, 0x33, 0xF2, 0x20, 0x7A, 0x0A, 0x48, 0x42, 0xF3, 0x3F, 0x23, 0x06, 0x07, 0x58,
  0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_music_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_music_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_new_releases 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_av_new_releases_data[] PROGMEM = {
  0x50, 0x03, 0x20, 0x03, 0x72, 0x03, 0xA0, 0x0C, 0xA0, 0x37, 0x02, 0x0C, 0xE0, 0xC0, 0x24, 0x03,
  0x0E, 0xFB, 0x0E, 0x03, 0x20, 0x6D, 0x00, 0xBD, 0x06, 0x20, 0x5D, 0x00, 0x5D, 0x05, 0x20, 0xBD,
  0x00, 0x5D, 0x81, 0xB0, 0x8E, 0x00, 0x5E, 0x00, 0x8E, 0x00, 0x8E, 0x81, 0x80, 0xBF, 0xD0, 0xB2,
  0x05, 0xD0, 0x09, 0xD0, 0x52, 0x06, 0xD0, 0x0B, 0xD0, 0x62, 0x03, 0x0E, 0xFB, 0x0E, 0x03, 0x40,
  0x20, 0xCE, 0x0C, 0x02, 0x70, 0x3A, 0x00, 0xCA, 0x03, 0x72, 0x00, 0x32, 0x00, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_new_releases() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_new_releases_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_note 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_av_note_data[] PROGMEM = {
  0x10, 0x38, 0x05, 0x50, 0x44, 0x01, 0xFA, 0x81, 0xDF, 0x73, 0x03, 0xFA, 0x82, 0xA4, 0xF7, 0x20,
  0x3F, 0xA8, 0x5A, 0x04, 0xF7, 0x03, 0xFA, 0x0C, 0x28, 0x24, 0xF2, 0x3F, 0xB8, 0x4E, 0xDD, 0xE3,
  0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09,
  0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_not_interested 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_18_av_not_interested_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0xA6, 0x81, 0x5F, 0x93, 0x83, 0x3F, 0xAF, 0x76, 0x81, 0x5F, 0x32, 0x84, 0xBB, 0x07, 0xF7,
  0x60, 0x0B, 0x29, 0x05, 0x28, 0x17, 0xF7, 0x58, 0x45, 0xF0, 0x2F, 0x33, 0x81, 0x7F, 0x74, 0x84,
  0x3F, 0x22, 0xF3, 0x48, 0x17, 0xF7, 0x38, 0x43, 0xF2, 0x0F, 0x55, 0x81, 0x7F, 0x72, 0x05, 0x92,
  0x00, 0xB6, 0x84, 0x7F, 0x70, 0xBB, 0x28, 0x13, 0xF5, 0x68, 0x37, 0xFA, 0xF3, 0x38, 0x19, 0xF5,
  0x68, 0x1A, 0xF9, 0x58, 0x90, 0x9F, 0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74,
  0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_not_interested() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_not_interested_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_pause_circle_filled 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_av_pause_circle_filled_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x23, 0x01,
  0x0D, 0xFB, 0x0D, 0x01, 0x20, 0x9F, 0xD0, 0x92, 0xC8, 0x4D, 0x1D, 0xD1, 0xDC, 0x10, 0x5C, 0x84,
  0xB0, 0xBB, 0x0B, 0xC0, 0x50, 0x6C, 0x84, 0xB0, 0xBB, 0x0B, 0xC0, 0x06, 0xC8, 0x4B, 0x0B, 0xB0,
  0xBC, 0x06, 0x05, 0xC8, 0x4B, 0x0B, 0xB0, 0xBC, 0x05, 0x1C, 0x84, 0xD1, 0xDD, 0x1D, 0xC2, 0x09,
  0xFD, 0x09, 0x20, 0x10, 0xDF, 0xB0, 0xD0, 0x13, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0x9E,
  0x09, 0x01, 0x72, 0x82, 0x57, 0x75, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_pause_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_pause_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_pause_circle_outline 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_round_18_av_pause_circle_outline_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x20, 0x0B, 0x20, 0x10, 0x82,
  0x08, 0x01, 0x20, 0x0B, 0x29, 0x05, 0x28, 0x43, 0xF1, 0x1F, 0x32, 0x84, 0x5F, 0x02, 0xF3, 0x28,
  0x43, 0xF1, 0x1F, 0x32, 0x84, 0x3F, 0x22, 0xF3, 0x28, 0x43, 0xF1, 0x1F, 0x32, 0x84, 0x3F, 0x20,
  0xF5, 0x28, 0x43, 0xF1, 0x1F, 0x32, 0x05, 0x92, 0x00, 0xB2, 0x01, 0x08, 0x20, 0x80, 0x12, 0x00,
  0xB2, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x38, 0x19, 0xF5, 0x68, 0x15, 0xF9, 0x58, 0x90, 0x9F,
  0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_pause_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_pause_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_pause_circle 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_av_pause_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBB, 0x0E, 0x06, 0xA0, 0x60, 0xEB, 0x0B, 0x2C, 0x84, 0xB0, 0xDD, 0x0B, 0xC1,
  0x02, 0xC8, 0x4B, 0x0D, 0xD0, 0xBC, 0x00, 0x2C, 0x84, 0xB0, 0xDD, 0x0B, 0xC0, 0x21, 0xC8, 0x4B,
  0x0D, 0xD0, 0xBC, 0x20, 0xBB, 0x0E, 0x06, 0xA0, 0x60, 0xEB, 0x0B, 0x20, 0x3F, 0xD0, 0x33, 0x09,
  0xFB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_pause_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_pause_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_pause 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_av_pause_data[] PROGMEM = {
  0x10, 0x40, 0x34, 0x82, 0x34, 0x05, 0xA0, 0x12, 0x01, 0xA0, 0x50, 0x7A, 0x03, 0x20, 0x3A, 0x00,
  0x7A, 0x03, 0x20, 0x3A, 0x00, 0x7A, 0x03, 0x20, 0x3A, 0x00, 0x7A, 0x03, 0x20, 0x3A, 0x00, 0x7A,
  0x03, 0x20, 0x3A, 0x00, 0x7A, 0x03, 0x20, 0x3A, 0x00, 0x7A, 0x03, 0x20, 0x3A, 0x00, 0x7A, 0x03,
  0x20, 0x3A, 0x07, 0x05, 0xA0, 0x12, 0x01, 0xA8, 0x25, 0x04, 0x34, 0x03, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_pause() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_av_pause_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_play_arrow 18x18, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_round_18_av_play_arrow_data[] PROGMEM = {
  0x04, 0x02, 0x68, 0x1A, 0xF8, 0x50, 0xAA, 0x0D, 0x03, 0x30, 0xAC, 0x09, 0x20, 0xAD, 0x81, 0xD3,
  0xAD, 0x81, 0xD3, 0xAC, 0x09, 0x20, 0xAA, 0x0D, 0x03, 0x38, 0x1A, 0xF8, 0x50, 0x40, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_play_arrow() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_av_play_arrow_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_play_circle_filled 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_av_play_circle_filled_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x23, 0x01,
  0x0D, 0xFB, 0x0D, 0x01, 0x20, 0x9F, 0xD0, 0x92, 0xD8, 0x18, 0x5E, 0xE1, 0x05, 0xD8, 0x27, 0x02,
  0xCD, 0x05, 0x06, 0xD0, 0x73, 0x0A, 0xC0, 0x06, 0xD0, 0x73, 0x0A, 0xC0, 0x60, 0x5D, 0x82, 0x70,
  0x2C, 0xD0, 0x51, 0xD8, 0x18, 0x5E, 0xE2, 0x09, 0xFD, 0x09, 0x20, 0x10, 0xDF, 0xB0, 0xD0, 0x13,
  0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0x9E, 0x09, 0x01, 0x72, 0x82, 0x57, 0x75, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_play_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_play_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_play_circle_outline 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_18_av_play_circle_outline_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x20, 0x0B, 0x30, 0x80, 0x55,
  0x00, 0xB2, 0x90, 0x53, 0x82, 0xCF, 0xA1, 0x38, 0x45, 0xF0, 0x2F, 0x33, 0x0C, 0xA0, 0xE0, 0x52,
  0x84, 0x3F, 0x22, 0xF3, 0x30, 0xCA, 0x0E, 0x05, 0x28, 0x43, 0xF2, 0x0F, 0x53, 0x82, 0xCF, 0xA1,
  0x30, 0x59, 0x20, 0x0B, 0x30, 0x80, 0x55, 0x00, 0xB2, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x38,
  0x19, 0xF5, 0x68, 0x15, 0xF9, 0x58, 0x90, 0x9F, 0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_play_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_play_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_play_circle 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_av_play_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBC, 0x07, 0x0A, 0xE0, 0xB2, 0xD8, 0x23, 0x04, 0xDD, 0x10, 0x2D, 0x03, 0x30,
  0xAC, 0x00, 0x2D, 0x03, 0x30, 0xAC, 0x02, 0x1D, 0x82, 0x30, 0x4D, 0xD2, 0x0B, 0xC0, 0x70, 0xAE,
  0x0B, 0x20, 0x3F, 0xD0, 0x33, 0x09, 0xFB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0,
  0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_play_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_play_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_play_disabled 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_av_play_disabled_data[] PROGMEM = {
  0x10, 0x27, 0x68, 0x11, 0xE7, 0x76, 0x84, 0x6F, 0x70, 0x22, 0x73, 0x84, 0x6F, 0x70, 0x88, 0x73,
  0x85, 0x6F, 0x70, 0x9D, 0x37, 0x28, 0x56, 0xF7, 0x09, 0xF9, 0x72, 0x86, 0xBF, 0x70, 0x9F, 0xD3,
  0x70, 0xAA, 0x83, 0x70, 0x9D, 0x37, 0x0A, 0xB0, 0x77, 0x30, 0xAA, 0x81, 0xDF, 0x77, 0x28, 0x5A,
  0xF8, 0x06, 0xF7, 0x71, 0x04, 0x02, 0x38, 0x16, 0xF7, 0x76, 0x81, 0x6F, 0x77, 0x68, 0x16, 0xE2,
  0x76, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_play_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_play_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_playlist_add_check_circle 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_av_playlist_add_check_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xA8, 0x4B, 0x55, 0x56, 0xDC, 0x03, 0x20, 0xBA, 0x84, 0xA3, 0x33, 0x4D, 0xC0, 0xB2, 0xB8, 0x3D,
  0x99, 0x9A, 0xE1, 0x02, 0xB0, 0x84, 0x0C, 0xD0, 0x02, 0xC0, 0xDD, 0x0C, 0x0E, 0xA0, 0x21, 0xB8,
  0x17, 0x07, 0xB8, 0x1A, 0x09, 0xA2, 0x0B, 0xA8, 0x6E, 0xBE, 0xF1, 0x50, 0x6A, 0x0B, 0x20, 0x3E,
  0x81, 0x90, 0x6B, 0x03, 0x30, 0x9E, 0x0E, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_playlist_add_check_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_playlist_add_check_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_playlist_add_check 18x18, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_18_av_playlist_add_check_data[] PROGMEM = {
  0x18, 0x03, 0x70, 0x45, 0x02, 0x80, 0x3D, 0x08, 0x77, 0x50, 0x10, 0xA8, 0x02, 0xB0, 0x65, 0x01,
  0x80, 0x39, 0x06, 0x40, 0x27, 0x58, 0x6C, 0xC2, 0xDD, 0xDD, 0xC2, 0x89, 0x29, 0x10, 0xCD, 0x20,
  0x77, 0x77, 0x62, 0x83, 0xDD, 0xCD, 0x27, 0x28, 0x21, 0xCD, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_playlist_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_av_playlist_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_playlist_add_circle 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_av_playlist_add_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xA8, 0x4B, 0x55, 0x56, 0xDC, 0x03, 0x20, 0xBA, 0x84, 0xA3, 0x33, 0x4D, 0xC0, 0xB2, 0xB8, 0x3D,
  0x99, 0x9A, 0xE1, 0x02, 0xB0, 0x84, 0x81, 0xCC, 0xDB, 0x00, 0x2C, 0x0D, 0xB8, 0x2E, 0x35, 0xEA,
  0x02, 0x1B, 0x81, 0x70, 0x7A, 0x30, 0x2A, 0x20, 0xBA, 0x81, 0xEB, 0xEA, 0x84, 0xC2, 0x4D, 0xFB,
  0x20, 0x3F, 0x90, 0xA0, 0xBA, 0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC,
  0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_playlist_add_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_playlist_add_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_playlist_add 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_av_playlist_add_data[] PROGMEM = {
  0x18, 0x03, 0x70, 0x46, 0x02, 0x80, 0x3D, 0x08, 0x77, 0x70, 0x10, 0xA8, 0x02, 0xB8, 0x26, 0x0A,
  0x13, 0x01, 0x80, 0x39, 0x82, 0x61, 0xF4, 0x75, 0x81, 0x1F, 0x43, 0x8B, 0x32, 0xDD, 0xDD, 0xC0,
  0xBD, 0xDF, 0xED, 0xC1, 0x07, 0x77, 0x76, 0x05, 0x78, 0xF9, 0x76, 0x73, 0x81, 0x1F, 0x47, 0x69,
  0x04, 0x76, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_playlist_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_playlist_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_playlist_play 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_18_av_playlist_play_data[] PROGMEM = {
  0x18, 0x03, 0x70, 0x45, 0x02, 0x80, 0x3D, 0x08, 0x77, 0x50, 0x10, 0xA8, 0x02, 0xB0, 0x65, 0x01,
  0x80, 0x39, 0x06, 0x77, 0x58, 0x42, 0xDD, 0xDD, 0xC3, 0x81, 0x4E, 0x53, 0x80, 0x07, 0x06, 0x30,
  0x4A, 0x0B, 0x01, 0x72, 0x04, 0xB0, 0x97, 0x20, 0x4A, 0x07, 0x73, 0x81, 0x3B, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_playlist_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_av_playlist_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_playlist_remove 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_18_av_playlist_remove_data[] PROGMEM = {
  0x18, 0x03, 0x70, 0x44, 0x02, 0x80, 0x3D, 0x08, 0x77, 0x30, 0x10, 0xA8, 0x02, 0xB0, 0x64, 0x01,
  0x80, 0x39, 0x06, 0x77, 0x38, 0x42, 0xDD, 0xDD, 0xC2, 0x89, 0x18, 0x60, 0x4A, 0x07, 0x77, 0x76,
  0x28, 0x36, 0xF9, 0xEA, 0x72, 0x81, 0x9F, 0xC7, 0x28, 0x34, 0xEC, 0xF7, 0x71, 0x83, 0xAA, 0x07,
  0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_playlist_remove() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_av_playlist_remove_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_queue_music 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_av_queue_music_data[] PROGMEM = {
  0x18, 0x03, 0x70, 0x42, 0x83, 0x67, 0x70, 0x28, 0x03, 0xD8, 0x58, 0x05, 0xFD, 0xC1, 0x73, 0x06,
  0x0E, 0x30, 0x28, 0x03, 0xB8, 0x27, 0x06, 0xE3, 0x01, 0x80, 0x37, 0x82, 0x40, 0x6E, 0x48, 0x01,
  0x14, 0x06, 0x0E, 0x30, 0x2C, 0x0E, 0x20, 0xAA, 0x0E, 0x48, 0x00, 0x38, 0x12, 0x06, 0xB0, 0xE7,
  0x30, 0x7B, 0x0D, 0x73, 0x01, 0x0D, 0xA0, 0x57, 0x48, 0x11, 0x52, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_queue_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_queue_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_queue_play_next 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_18_av_queue_play_next_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x01, 0x20, 0x10, 0xEF, 0xD8, 0x4E, 0x10, 0x3F, 0x27, 0x38, 0x52, 0xF3,
  0x03, 0xF2, 0x40, 0x04, 0x48, 0x52, 0xF3, 0x03, 0xF2, 0x40, 0x0A, 0x48, 0x52, 0xF3, 0x03, 0xF2,
  0x28, 0x44, 0x9D, 0xD9, 0x42, 0x85, 0x2F, 0x30, 0x3F, 0x22, 0x84, 0x6B, 0xEE, 0xB6, 0x28, 0x51,
  0xD1, 0x03, 0xF2, 0x40, 0x0A, 0x71, 0x81, 0x3F, 0x24, 0x00, 0x64, 0x08, 0x06, 0x28, 0x13, 0xF2,
  0x73, 0x83, 0x6F, 0x60, 0x19, 0x80, 0x5D, 0x05, 0x28, 0x77, 0xF5, 0x04, 0x77, 0x7D, 0xB8, 0x1D,
  0x72, 0x28, 0x15, 0xF6, 0x50, 0x9B, 0x0B, 0x38, 0x15, 0xF8, 0x70, 0xF3, 0x01, 0x30, 0x90, 0x82,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_queue_play_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_av_queue_play_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_queue 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_av_queue_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x7F, 0xC8, 0x33, 0x06, 0x07, 0xC0, 0xE0, 0x9D,
  0x83, 0x33, 0xF2, 0x7C, 0x0A, 0x1D, 0x83, 0x33, 0xF2, 0x7C, 0x0A, 0x1D, 0x83, 0x33, 0xF2, 0x7A,
  0x05, 0x50, 0x9A, 0x83, 0x33, 0xF2, 0x7A, 0x85, 0xD9, 0x60, 0x99, 0xEA, 0x83, 0x33, 0xF2, 0x7C,
  0x0A, 0x1D, 0x83, 0x33, 0xF2, 0x7C, 0x0D, 0x05, 0xD8, 0x33, 0x3F, 0x27, 0xFC, 0x83, 0x33, 0xF2,
  0x6F, 0xC8, 0x41, 0x3F, 0x20, 0x68, 0x05, 0x78, 0x34, 0x03, 0xF3, 0x80, 0x51, 0x50, 0xEF, 0xB0,
  0x65, 0x80, 0x63, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_radio 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_av_radio_data[] PROGMEM = {
  0x72, 0x81, 0x5B, 0xE7, 0x38, 0x44, 0x9E, 0xFB, 0x47, 0x85, 0x28, 0xDF, 0xC6, 0x17, 0x05, 0x0C,
  0xB0, 0xC8, 0x03, 0x98, 0x35, 0x01, 0xFC, 0x80, 0x6B, 0x84, 0xCF, 0x23, 0xF2, 0x71, 0x86, 0x84,
  0x2F, 0x33, 0xF8, 0x80, 0x47, 0x84, 0xEB, 0x8F, 0x33, 0xFF, 0x00, 0x3A, 0x81, 0xD6, 0x8F, 0xA0,
  0x03, 0xA0, 0x32, 0x08, 0xF9, 0x00, 0x3A, 0x02, 0x20, 0x6F, 0x90, 0x03, 0xA8, 0x2A, 0x23, 0xDF,
  0x90, 0x03, 0xFF, 0x81, 0x30, 0xEF, 0xD0, 0xE3, 0x80, 0x90, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_radio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_radio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_recent_actors 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_18_av_recent_actors_data[] PROGMEM = {
  0x10, 0x28, 0x05, 0x52, 0x03, 0x20, 0x42, 0x0E, 0xFA, 0x86, 0x80, 0xE5, 0x3F, 0x11, 0xC8, 0x19,
  0x7C, 0xB8, 0x6A, 0x0E, 0x63, 0xF1, 0x1B, 0x06, 0x30, 0xCA, 0x86, 0xA0, 0xE6, 0x3F, 0x11, 0xB0,
  0x13, 0x07, 0xA8, 0x6A, 0x0E, 0x63, 0xF1, 0x1B, 0x04, 0x30, 0xAA, 0x86, 0xA0, 0xE6, 0x3F, 0x11,
  0xB8, 0x2D, 0x42, 0x7B, 0x86, 0xA0, 0xE6, 0x3F, 0x11, 0xC8, 0x1D, 0xDE, 0xB8, 0x92, 0xA0, 0xE6,
  0x3F, 0x11, 0xFE, 0x61, 0x38, 0x93, 0x29, 0xFA, 0x0E, 0x63, 0xF1, 0x1F, 0x57, 0x89, 0x0B, 0xA0,
  0xE6, 0x3F, 0x10, 0xEF, 0xA8, 0x78, 0x0E, 0x53, 0xF1, 0x02, 0x80, 0x55, 0x20, 0x32, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_recent_actors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_av_recent_actors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_remove_from_queue 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_av_remove_from_queue_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x22, 0x84, 0x49, 0x99, 0x94, 0x28,
  0x42, 0xF3, 0x3F, 0x22, 0x84, 0x6B, 0xBB, 0xB6, 0x28, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3,
  0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x19, 0x80, 0x90, 0xD9, 0x85, 0x10,
  0x47, 0x77, 0xDC, 0x83, 0xD7, 0x77, 0x46, 0x09, 0xC0, 0x97, 0x48, 0x00, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_remove_from_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_av_remove_from_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_repeat_one_on 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_18_av_repeat_one_on_data[] PROGMEM = {
  0x28, 0x09, 0x21, 0x30, 0xCF, 0xF8, 0x1C, 0x01, 0xFC, 0x0C, 0x0B, 0xB0, 0x01, 0xB8, 0x04, 0xD8,
  0x18, 0x0A, 0xA0, 0x01, 0xA0, 0xB7, 0x4A, 0x00, 0x1A, 0x09, 0x18, 0x03, 0xD8, 0x18, 0x0A, 0xA0,
  0x01, 0xA0, 0x91, 0xF0, 0xC0, 0xBB, 0x00, 0x1A, 0x0A, 0x01, 0xB0, 0x60, 0x5F, 0x00, 0x1F, 0x0E,
  0x01, 0xF0, 0x01, 0xF9, 0x01, 0xF0, 0x01, 0xF9, 0x06, 0xB0, 0x10, 0xAA, 0x00, 0x1B, 0x0B, 0x0C,
  0xF1, 0x09, 0xA0, 0x01, 0xA8, 0x1A, 0x08, 0x80, 0x3D, 0x10, 0x9A, 0x00, 0x1A, 0x74, 0x0B, 0xA0,
  0x01, 0xA8, 0x1A, 0x08, 0x80, 0x4D, 0xB0, 0x01, 0xB0, 0xB0, 0xCF, 0xC8, 0x11, 0x0C, 0xFF, 0x0C,
  0x38, 0x09, 0x21, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_repeat_one_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_av_repeat_one_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_repeat_one 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_av_repeat_one_data[] PROGMEM = {
  0x72, 0x02, 0x04, 0x28, 0x04, 0x18, 0x27, 0xF4, 0x4F, 0xB8, 0x1E, 0x6E, 0x80, 0x31, 0x83, 0x7F,
  0x46, 0xE7, 0x83, 0x24, 0x05, 0xD3, 0x00, 0x97, 0x30, 0x10, 0xD7, 0x40, 0xD7, 0x40, 0x93, 0x83,
  0xD5, 0x04, 0x27, 0x83, 0xE6, 0x4F, 0x78, 0x03, 0x18, 0x1E, 0x6E, 0xFB, 0x82, 0x44, 0xF7, 0x80,
  0x41, 0x20, 0x40, 0x27, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_repeat_one() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_av_repeat_one_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_repeat_on 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_av_repeat_on_data[] PROGMEM = {
  0x28, 0x09, 0x21, 0x30, 0xCF, 0xF8, 0x1C, 0x01, 0xFC, 0x0C, 0x0B, 0xB0, 0x01, 0xB8, 0x04, 0xD8,
  0x18, 0x0A, 0xA0, 0x01, 0xA0, 0xB7, 0x4A, 0x00, 0x1A, 0x09, 0x18, 0x03, 0xD8, 0x18, 0x0A, 0xA0,
  0x01, 0xA0, 0x91, 0xF0, 0xC0, 0xBB, 0x00, 0x1A, 0x0A, 0x01, 0xFD, 0x00, 0x1F, 0xFA, 0x00, 0x1F,
  0xFA, 0x00, 0x1F, 0xD0, 0x10, 0xAA, 0x00, 0x1B, 0x0B, 0x0C, 0xF1, 0x09, 0xA0, 0x01, 0xA8, 0x1A,
  0x08, 0x80, 0x3D, 0x10, 0x9A, 0x00, 0x1A, 0x74, 0x0B, 0xA0, 0x01, 0xA8, 0x1A, 0x08, 0x80, 0x4D,
  0xB0, 0x01, 0xB0, 0xB0, 0xCF, 0xC8, 0x11, 0x0C, 0xFF, 0x0C, 0x38, 0x09, 0x21, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_repeat_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_av_repeat_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_repeat 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_18_av_repeat_data[] PROGMEM = {
  0x72, 0x02, 0x04, 0x28, 0x04, 0x18, 0x27, 0xF4, 0x4F, 0xB8, 0x1E, 0x6E, 0x80, 0x31, 0x83, 0x7F,
  0x46, 0xE7, 0x83, 0x24, 0x05, 0xD8, 0x0D, 0x00, 0x83, 0xD5, 0x04, 0x27, 0x83, 0xE6, 0x4F, 0x78,
  0x03, 0x18, 0x1E, 0x6E, 0xFB, 0x82, 0x44, 0xF7, 0x80, 0x41, 0x20, 0x40, 0x27, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_repeat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_av_repeat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_replay_10 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_av_replay_10_data[] PROGMEM = {
  0x50, 0x10, 0x97, 0x48, 0x31, 0xDF, 0x52, 0x72, 0x05, 0xC0, 0xD0, 0x47, 0x18, 0x58, 0xE0, 0x3A,
  0xF6, 0x71, 0x02, 0x38, 0x17, 0xF3, 0x75, 0x00, 0xB5, 0x89, 0x0D, 0x85, 0xDD, 0x20, 0x5F, 0x14,
  0x89, 0x23, 0xA6, 0x6A, 0x30, 0x2F, 0x33, 0xE2, 0x8A, 0x53, 0xA6, 0x9B, 0x30, 0x2F, 0x31, 0xF4,
  0x01, 0x53, 0xBB, 0x10, 0x6E, 0x20, 0x0B, 0x71, 0x0D, 0x0A, 0x28, 0x13, 0xF9, 0x68, 0x1A, 0xE1,
  0x38, 0x90, 0x5F, 0xC6, 0x33, 0x6D, 0xE3, 0x50, 0x20, 0xAB, 0x81, 0xE9, 0x17, 0x20, 0x01, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_replay_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_replay_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_replay_30 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_av_replay_30_data[] PROGMEM = {
  0x50, 0x10, 0x97, 0x48, 0x31, 0xDF, 0x52, 0x72, 0x05, 0xC0, 0xD0, 0x47, 0x18, 0x58, 0xE0, 0x3A,
  0xF6, 0x71, 0x02, 0x38, 0x17, 0xF3, 0x75, 0x00, 0xB5, 0x89, 0x0D, 0xD6, 0x6D, 0xD1, 0x5F, 0x14,
  0x89, 0x21, 0xA8, 0x85, 0xB2, 0x2F, 0x33, 0xE2, 0x8A, 0x53, 0xB8, 0x87, 0xC2, 0x2F, 0x31, 0xF4,
  0x0B, 0xB5, 0x5B, 0xB1, 0x6E, 0x20, 0x0B, 0x71, 0x0D, 0x0A, 0x28, 0x13, 0xF9, 0x68, 0x1A, 0xE1,
  0x38, 0x90, 0x5F, 0xC6, 0x33, 0x6D, 0xE3, 0x50, 0x20, 0xAB, 0x81, 0xE9, 0x17, 0x20, 0x01, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_replay_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_replay_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_replay_5 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_av_replay_5_data[] PROGMEM = {
  0x50, 0x10, 0x97, 0x48, 0x31, 0xDF, 0x52, 0x72, 0x05, 0xC0, 0xD0, 0x47, 0x18, 0x58, 0xE0, 0x3A,
  0xF6, 0x71, 0x02, 0x38, 0x17, 0xF3, 0x75, 0x00, 0xB6, 0x82, 0x4D, 0xD3, 0x28, 0x15, 0xF1, 0x58,
  0x25, 0xB7, 0x22, 0x83, 0x2F, 0x33, 0xE3, 0x82, 0x19, 0xC5, 0x28, 0x42, 0xF3, 0x1F, 0x42, 0x82,
  0x2B, 0xB2, 0x20, 0x60, 0xE2, 0x00, 0xB7, 0x10, 0xD0, 0xA2, 0x81, 0x3F, 0x96, 0x81, 0xAE, 0x13,
  0x89, 0x05, 0xFC, 0x63, 0x36, 0xDE, 0x35, 0x02, 0x0A, 0xB8, 0x1E, 0x91, 0x72, 0x00, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_replay_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_replay_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_replay_circle_filled 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_av_replay_circle_filled_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xB0, 0xAC, 0x09, 0x50, 0x9B, 0x06, 0x1D,
  0x09, 0x30, 0x3B, 0x09, 0x30, 0x40, 0xCB, 0x03, 0x20, 0xBB, 0x85, 0xE3, 0x08, 0x30, 0xBA, 0x0B,
  0x2D, 0x0E, 0x07, 0xA0, 0x40, 0x2B, 0x10, 0x2F, 0xA8, 0x1B, 0x0D, 0xA0, 0x02, 0xA8, 0x1E, 0x5E,
  0xC8, 0x1C, 0x0C, 0xA0, 0x21, 0xA8, 0x1E, 0x08, 0xC8, 0x19, 0x0E, 0xA2, 0x0B, 0xA8, 0x16, 0x0A,
  0xA8, 0x1A, 0x07, 0xA0, 0xB2, 0x03, 0xB8, 0x15, 0x01, 0x20, 0x6B, 0x03, 0x30, 0x9B, 0x82, 0xC9,
  0x9D, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_replay_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_replay_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_replay 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_av_replay_data[] PROGMEM = {
  0x50, 0x10, 0x97, 0x48, 0x31, 0xDF, 0x52, 0x72, 0x05, 0xC0, 0xD0, 0x47, 0x18, 0x58, 0xE0, 0x3A,
  0xF6, 0x71, 0x02, 0x38, 0x17, 0xF3, 0x75, 0x00, 0xB7, 0x58, 0x15, 0xF1, 0x74, 0x83, 0x2F, 0x33,
  0xE7, 0x28, 0x42, 0xF3, 0x1F, 0x47, 0x10, 0x60, 0xE2, 0x00, 0xB7, 0x10, 0xD0, 0xA2, 0x81, 0x3F,
  0x96, 0x81, 0xAE, 0x13, 0x89, 0x05, 0xFC, 0x63, 0x36, 0xDE, 0x35, 0x02, 0x0A, 0xB8, 0x1E, 0x91,
  0x72, 0x00, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_replay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_av_replay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_sd 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_av_sd_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3B, 0x86,
  0x93, 0x4E, 0xE3, 0x3B, 0xB0, 0x03, 0xB8, 0x66, 0x67, 0xED, 0x29, 0x6B, 0x00, 0x3B, 0x86, 0xA8,
  0x1E, 0xD2, 0x96, 0xB0, 0x03, 0xB8, 0x69, 0x34, 0xEE, 0x33, 0xBB, 0x00, 0x3F, 0xF0, 0x03, 0xFF,
  0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_sd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_sd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_shuffle_on 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_round_18_av_shuffle_on_data[] PROGMEM = {
  0x28, 0x09, 0x21, 0x30, 0xCF, 0xF8, 0x1C, 0x01, 0xFF, 0xA0, 0x01, 0xB0, 0xEE, 0x82, 0xC9, 0x9D,
  0xA0, 0x01, 0xA8, 0x1E, 0x08, 0xD0, 0xB2, 0x09, 0xA0, 0x01, 0xB8, 0x18, 0x08, 0xC0, 0x82, 0x09,
  0xA0, 0x01, 0xC8, 0x18, 0x08, 0xA8, 0x38, 0x08, 0xBC, 0xA0, 0x01, 0xD8, 0x48, 0x5F, 0x80, 0x8D,
  0x00, 0x1F, 0x81, 0x80, 0x8E, 0x00, 0x1E, 0x81, 0x80, 0x8F, 0x00, 0x1D, 0x84, 0x80, 0x8F, 0x58,
  0xD0, 0x01, 0xC8, 0x18, 0x08, 0xA8, 0x38, 0x08, 0xBD, 0xA0, 0x01, 0xB8, 0x18, 0x08, 0xC0, 0x82,
  0x09, 0xA0, 0x01, 0xA8, 0x1E, 0x08, 0xD0, 0xB2, 0x09, 0xA0, 0x01, 0xFB, 0x82, 0xC9, 0x9D, 0xA0,
  0x01, 0xFF, 0xA8, 0x11, 0x0C, 0xFF, 0x0C, 0x38, 0x09, 0x21, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_shuffle_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_av_shuffle_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_shuffle 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_av_shuffle_data[] PROGMEM = {
  0x78, 0x42, 0x55, 0x1F, 0x75, 0x04, 0xA8, 0x26, 0x7F, 0x74, 0x07, 0xA8, 0x36, 0x07, 0xF7, 0x28,
  0x37, 0xF7, 0x42, 0x28, 0x47, 0x90, 0x7F, 0x77, 0x81, 0x7F, 0x77, 0x81, 0x7F, 0x77, 0x84, 0x7F,
  0x70, 0x97, 0x48, 0x17, 0xF7, 0x28, 0x67, 0xF6, 0x42, 0x7F, 0x74, 0x07, 0xA8, 0x16, 0xF7, 0x50,
  0x4A, 0x06, 0x78, 0x22, 0x55, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_shuffle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_av_shuffle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_skip_next 18x18, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_round_18_av_skip_next_data[] PROGMEM = {
  0x71, 0x82, 0x41, 0x46, 0x68, 0x4D, 0x77, 0xFB, 0x24, 0x81, 0xD7, 0x7B, 0x07, 0x38, 0x1D, 0x77,
  0xC8, 0x4C, 0x20, 0xD7, 0x7C, 0x84, 0xC2, 0x0D, 0x77, 0xB0, 0x73, 0x84, 0xD7, 0x7F, 0xB2, 0x48,
  0x2D, 0x74, 0x66, 0x0D, 0x07, 0x71, 0x04, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_skip_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_av_skip_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_skip_previous 18x18, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_round_18_av_skip_previous_data[] PROGMEM = {
  0x01, 0x04, 0x71, 0x07, 0x0D, 0x68, 0x26, 0x47, 0xD4, 0x84, 0x2B, 0xF7, 0x7D, 0x30, 0x7B, 0x84,
  0x77, 0xD0, 0x2C, 0xC8, 0x47, 0x7D, 0x02, 0xCC, 0x81, 0x77, 0xD3, 0x07, 0xB8, 0x17, 0x7D, 0x48,
  0x42, 0xBF, 0x77, 0xD6, 0x82, 0x64, 0x14, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_skip_previous() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_av_skip_previous_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_slow_motion_video 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_av_slow_motion_video_data[] PROGMEM = {
  0x38, 0x64, 0xBF, 0x33, 0xFB, 0x46, 0x82, 0x1F, 0xB5, 0x28, 0x26, 0xCF, 0x94, 0x81, 0x10, 0x16,
  0x81, 0x6F, 0x92, 0x81, 0x4F, 0x17, 0x18, 0x45, 0xF4, 0x0B, 0xB3, 0x08, 0x05, 0x58, 0x3C, 0xB0,
  0xE5, 0x38, 0x2C, 0xFA, 0x13, 0x82, 0x6F, 0x03, 0x40, 0xCA, 0x0E, 0x05, 0x28, 0x23, 0xF2, 0x34,
  0x0C, 0xA0, 0xE0, 0x52, 0x83, 0x3F, 0x2E, 0x53, 0x82, 0xCF, 0xA1, 0x38, 0x36, 0xF0, 0xBB, 0x30,
  0x80, 0x55, 0x84, 0xCB, 0x04, 0xF1, 0x71, 0x81, 0x5F, 0x42, 0x81, 0x10, 0x26, 0x81, 0x6F, 0x94,
  0x82, 0x1F, 0xB5, 0x28, 0x26, 0xCF, 0x96, 0x86, 0x3B, 0xE3, 0x3F, 0xB4, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_slow_motion_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_av_slow_motion_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_snooze 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_av_snooze_data[] PROGMEM = {
  0x20, 0x10, 0x67, 0x10, 0x60, 0x13, 0x81, 0x1C, 0xD2, 0x82, 0x25, 0x52, 0x28, 0x90, 0xDC, 0x10,
  0x1C, 0xD2, 0x4D, 0xC8, 0x90, 0xD4, 0x2D, 0xC1, 0x4D, 0x27, 0xF9, 0x82, 0x72, 0xD4, 0x20, 0x4F,
  0xB0, 0x44, 0x0C, 0xFB, 0x0C, 0x30, 0x1C, 0x82, 0x61, 0x16, 0xC0, 0x12, 0x04, 0xD8, 0x1B, 0x2B,
  0xC0, 0x42, 0x03, 0xC8, 0x29, 0x09, 0xDC, 0x03, 0x20, 0x1C, 0x82, 0x83, 0x37, 0xC0, 0x13, 0x0B,
  0xFB, 0x0B, 0x40, 0x20, 0xEF, 0x90, 0xE0, 0x25, 0x04, 0x0E, 0xE0, 0xE0, 0x47, 0x81, 0x2A, 0xEA,
  0x81, 0xEA, 0x27, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_snooze() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_snooze_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_sort_by_alpha 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_av_sort_by_alpha_data[] PROGMEM = {
  0x60, 0x0A, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x03, 0x07, 0x48, 0x35, 0x99, 0x97, 0x38, 0x1D, 0xF7,
  0x38, 0x91, 0x7B, 0xBD, 0xF2, 0x04, 0xF9, 0xD5, 0x81, 0x1D, 0xA2, 0x83, 0xAB, 0x2F, 0x34, 0x0B,
  0x0C, 0x28, 0x41, 0xFA, 0x5E, 0x93, 0x81, 0x8E, 0x22, 0x84, 0x6F, 0xDD, 0xEE, 0x28, 0x15, 0xF4,
  0x30, 0xB0, 0xA2, 0x89, 0x21, 0xF4, 0x0D, 0xD9, 0x99, 0x15, 0x23, 0x87, 0x62, 0x05, 0x99, 0x99,
  0x17, 0x75, 0x07, 0xA0, 0x77, 0x40, 0x0A, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_sort_by_alpha() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_sort_by_alpha_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_speed 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_av_speed_data[] PROGMEM = {
  0x68, 0x22, 0x55, 0x37, 0x30, 0x60, 0xDC, 0x0E, 0x03, 0x78, 0x2B, 0xF8, 0x22, 0x03, 0x04, 0x78,
  0x1A, 0xE3, 0x58, 0x21, 0x50, 0x13, 0x81, 0x5F, 0x35, 0x84, 0x5E, 0x80, 0xC5, 0x20, 0x0B, 0x48,
  0x21, 0xAF, 0xD2, 0x0A, 0x0C, 0x29, 0x05, 0x30, 0x10, 0xDA, 0x03, 0x28, 0x45, 0xF1, 0x2F, 0x33,
  0x04, 0xA0, 0x83, 0x84, 0x3F, 0x22, 0xF3, 0x40, 0x08, 0x48, 0x43, 0xF2, 0x0E, 0x77, 0x30, 0x60,
  0xE2, 0x09, 0xFD, 0x09, 0x38, 0x09, 0x05, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_speed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_speed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_stop_circle 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_av_stop_circle_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x50, 0x5F, 0x90, 0x53, 0x03, 0xFB, 0x03,
  0x20, 0xBA, 0x84, 0x83, 0x33, 0x38, 0xA8, 0x1B, 0x01, 0xB0, 0x44, 0x04, 0xB0, 0x10, 0x3B, 0x04,
  0x40, 0x4B, 0x00, 0x3B, 0x04, 0x40, 0x4B, 0x03, 0x01, 0xB0, 0x44, 0x04, 0xB8, 0x11, 0x0B, 0xA8,
  0x48, 0x33, 0x33, 0x8A, 0x0B, 0x20, 0x3F, 0xB0, 0x33, 0x05, 0xF9, 0x05, 0x50, 0x30, 0xBC, 0x0B,
  0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_stop_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_stop_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_stop 18x18, 4-bit Alpha,  RLE, 23 bytes.
static const unsigned char ic_round_18_av_stop_data[] PROGMEM = {
  0x18, 0x66, 0x99, 0x99, 0x60, 0x6E, 0x06, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x90,
  0x6E, 0x86, 0x60, 0x69, 0x99, 0x96, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 12, 12), Box(0, 0, 17, 17),
      ic_round_18_av_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_subscriptions 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_av_subscriptions_data[] PROGMEM = {
  0x58, 0x02, 0x37, 0x20, 0x7E, 0x07, 0x72, 0x80, 0x21, 0x70, 0x3F, 0xB0, 0x35, 0x80, 0x65, 0x40,
  0x78, 0x09, 0x0B, 0x81, 0x70, 0x2F, 0xF0, 0x20, 0x3D, 0x0E, 0x0D, 0xF0, 0x03, 0xD8, 0x1A, 0x08,
  0xE0, 0x03, 0xD0, 0xA2, 0x03, 0x0C, 0xC0, 0x03, 0xD0, 0xA3, 0x07, 0xC0, 0x03, 0xD8, 0x2A, 0x01,
  0xAD, 0x00, 0x3D, 0x81, 0xC6, 0xEE, 0x00, 0x3F, 0xF8, 0x13, 0x0E, 0xFD, 0x0E, 0x38, 0x09, 0x03,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_subscriptions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_subscriptions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_subtitles 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_av_subtitles_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3A, 0x82,
  0xEC, 0xFC, 0x80, 0x19, 0x0E, 0xA0, 0x03, 0xA8, 0x29, 0x4F, 0x55, 0x0A, 0xA0, 0x03, 0xFF, 0x00,
  0x3A, 0x0C, 0x80, 0x15, 0x82, 0x9F, 0x9C, 0xA0, 0x03, 0xA8, 0x90, 0xC4, 0x33, 0x33, 0x8F, 0x8C,
  0xA0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_subtitles() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_subtitles_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_surround_sound 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_av_surround_sound_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3B, 0x0E, 0xE0, 0xEB, 0x00, 0x3A, 0x89,
  0x0C, 0x0D, 0xFD, 0xDF, 0xD0, 0xCA, 0x00, 0x3A, 0x82, 0x53, 0xF6, 0x28, 0x26, 0xF3, 0x5A, 0x00,
  0x3A, 0x81, 0x28, 0xD4, 0x81, 0xD8, 0x2A, 0x00, 0x3A, 0x81, 0x28, 0xD4, 0x81, 0xD8, 0x2A, 0x00,
  0x3A, 0x82, 0x53, 0xF6, 0x28, 0x26, 0xF3, 0x5A, 0x00, 0x3A, 0x89, 0x0C, 0x0D, 0xFD, 0xDF, 0xD0,
  0xCA, 0x00, 0x3B, 0x0E, 0xE0, 0xEB, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_surround_sound() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_surround_sound_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_video_call 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_av_video_call_data[] PROGMEM = {
  0x10, 0x38, 0x04, 0x50, 0x44, 0x02, 0xFB, 0x05, 0x30, 0x4F, 0xB0, 0x73, 0x04, 0xC0, 0x80, 0x6C,
  0x83, 0x71, 0xC2, 0x4C, 0x06, 0x03, 0xC8, 0x38, 0xCF, 0x34, 0xA8, 0x49, 0x52, 0x15, 0x7D, 0x03,
  0x04, 0xA8, 0x49, 0x52, 0x15, 0x7D, 0x03, 0x04, 0xC0, 0x60, 0x3C, 0x83, 0x8C, 0xF3, 0x4C, 0x08,
  0x06, 0xC8, 0x37, 0x1B, 0x24, 0xFB, 0x07, 0x30, 0x2F, 0xB0, 0x54, 0x03, 0x80, 0x45, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_videocam_off 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_av_videocam_off_data[] PROGMEM = {
  0x06, 0x05, 0x76, 0x83, 0x7F, 0x60, 0x28, 0x01, 0x50, 0x44, 0x02, 0xA8, 0x16, 0x0A, 0xD0, 0x53,
  0x04, 0xB8, 0x16, 0x0A, 0xC0, 0x73, 0x04, 0xC8, 0x16, 0x0A, 0xB8, 0x37, 0x1C, 0x24, 0xD8, 0x16,
  0x0A, 0xA8, 0x38, 0xCF, 0x34, 0xE8, 0x16, 0x0A, 0xC0, 0x30, 0x4F, 0x81, 0x60, 0xAB, 0x03, 0x04,
  0xF9, 0x85, 0x60, 0x4C, 0xF3, 0x4F, 0xA8, 0x46, 0x01, 0xB2, 0x4F, 0xB0, 0x63, 0x02, 0xFC, 0x06,
  0x30, 0x38, 0x04, 0x58, 0x24, 0x8F, 0x67, 0x68, 0x17, 0xF5, 0x76, 0x06, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_videocam_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_videocam_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_videocam 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_av_videocam_data[] PROGMEM = {
  0x10, 0x38, 0x04, 0x50, 0x44, 0x02, 0xFB, 0x05, 0x30, 0x4F, 0xB0, 0x73, 0x04, 0xFB, 0x83, 0x71,
  0xC2, 0x4F, 0xB8, 0x38, 0xCF, 0x34, 0xFE, 0x03, 0x04, 0xFE, 0x03, 0x04, 0xFB, 0x83, 0x8C, 0xF3,
  0x4F, 0xB8, 0x37, 0x1B, 0x24, 0xFB, 0x07, 0x30, 0x2F, 0xB0, 0x54, 0x03, 0x80, 0x45, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_videocam() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_videocam_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_video_file 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_av_video_file_data[] PROGMEM = {
  0x10, 0x18, 0x01, 0x30, 0x24, 0x02, 0xF0, 0x73, 0x06, 0xD8, 0x2D, 0x4F, 0x72, 0x06, 0xD8, 0x5D,
  0x04, 0xF7, 0x06, 0xD0, 0xE2, 0x82, 0x4F, 0x46, 0xE8, 0x4D, 0xBB, 0xE6, 0x6F, 0xB0, 0x06, 0xFB,
  0x00, 0x6A, 0x05, 0x30, 0xA0, 0xEA, 0x00, 0x6A, 0x04, 0x30, 0x10, 0x5A, 0x00, 0x6A, 0x04, 0x30,
  0x10, 0x5A, 0x00, 0x6A, 0x05, 0x30, 0xA0, 0xEA, 0x00, 0x6F, 0xB0, 0x06, 0xFB, 0x06, 0x02, 0xFB,
  0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_video_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_av_video_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_video_label 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_av_video_label_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38,
  0x42, 0xF3, 0x3F, 0x58, 0x06, 0x38, 0x25, 0xF3, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81,
  0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_video_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_video_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_video_library 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_av_video_library_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x7F, 0xC8, 0x33, 0x06, 0x07, 0xFC, 0x83, 0x33,
  0xF2, 0x7B, 0x81, 0x92, 0xBD, 0x83, 0x33, 0xF2, 0x7B, 0x08, 0x20, 0x50, 0xEB, 0x83, 0x33, 0xF2,
  0x7B, 0x08, 0x30, 0x1B, 0x83, 0x33, 0xF2, 0x7B, 0x08, 0x20, 0x10, 0xBB, 0x83, 0x33, 0xF2, 0x7B,
  0x82, 0x80, 0x6E, 0xC8, 0x33, 0x3F, 0x27, 0xB0, 0xD0, 0xCE, 0x83, 0x33, 0xF2, 0x7F, 0xC8, 0x33,
  0x3F, 0x26, 0xFC, 0x84, 0x13, 0xF2, 0x06, 0x80, 0x57, 0x83, 0x40, 0x3F, 0x38, 0x05, 0x15, 0x0E,
  0xFB, 0x06, 0x58, 0x06, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_video_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_video_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_video_settings 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_av_video_settings_data[] PROGMEM = {
  0x10, 0x48, 0x09, 0x05, 0x04, 0x20, 0x20, 0xE8, 0x09, 0x07, 0x83, 0xE2, 0x03, 0xA7, 0x58, 0x3A,
  0x30, 0x3A, 0x40, 0x57, 0x83, 0xA3, 0x03, 0xA4, 0x81, 0xCC, 0x25, 0x83, 0xA3, 0x03, 0xA4, 0x0C,
  0xA0, 0x74, 0x01, 0x20, 0x30, 0xA4, 0x0C, 0xA0, 0x73, 0x00, 0x12, 0x03, 0x0A, 0x48, 0x1C, 0xC2,
  0x28, 0x21, 0x0F, 0xB2, 0x03, 0x0A, 0x40, 0x54, 0x0D, 0x0E, 0xA8, 0x2E, 0x93, 0xA7, 0x18, 0x71,
  0xCF, 0x59, 0xF8, 0x2E, 0x80, 0x27, 0x06, 0x28, 0x6B, 0xF3, 0x8F, 0x70, 0x48, 0x03, 0x52, 0x0D,
  0xC0, 0xA7, 0x48, 0x42, 0x1F, 0xB1, 0x17, 0x60, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_video_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_av_video_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_volume_down 18x18, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_round_18_av_volume_down_data[] PROGMEM = {
  0x48, 0x12, 0xEA, 0x68, 0x91, 0x2E, 0xFC, 0x07, 0x03, 0xBB, 0xEA, 0x83, 0xC0, 0xD8, 0x7D, 0x83,
  0xC0, 0xDD, 0x7D, 0x86, 0xC0, 0xDD, 0x3B, 0xBE, 0xA8, 0x2C, 0x0D, 0x83, 0x84, 0x2E, 0xFC, 0x07,
  0x58, 0x12, 0xEA, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_volume_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 13, 12), Box(0, 0, 17, 17),
      ic_round_18_av_volume_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_volume_mute 18x18, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_round_18_av_volume_mute_data[] PROGMEM = {
  0x48, 0x13, 0xE8, 0x38, 0x63, 0xEF, 0xA4, 0xBB, 0xEA, 0x0A, 0x09, 0xD0, 0xA0, 0x9D, 0x83, 0xA4,
  0xBB, 0xEA, 0x0A, 0x38, 0x23, 0xEF, 0xA4, 0x81, 0x3E, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_volume_mute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 11, 12), Box(0, 0, 17, 17),
      ic_round_18_av_volume_mute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_volume_off 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_av_volume_off_data[] PROGMEM = {
  0x0E, 0x07, 0x68, 0x16, 0xB2, 0x38, 0x16, 0xF7, 0x58, 0x22, 0xCF, 0x53, 0x84, 0x6F, 0x70, 0x7D,
  0x38, 0x18, 0xF3, 0x38, 0xA0, 0x6F, 0x70, 0x90, 0x61, 0x0C, 0xB0, 0x1A, 0xBE, 0xF7, 0x28, 0x5A,
  0xB0, 0x5F, 0x14, 0xD8, 0x77, 0x07, 0xF1, 0x1F, 0x34, 0xE8, 0x91, 0x70, 0x91, 0x1F, 0x31, 0xAB,
  0xDC, 0x07, 0x28, 0x15, 0xF1, 0x30, 0x10, 0xCA, 0x84, 0x6F, 0x70, 0x7A, 0x58, 0x71, 0xCD, 0x06,
  0xF7, 0x01, 0x72, 0x82, 0x2D, 0xF7, 0x73, 0x83, 0x7B, 0x8F, 0x77, 0x50, 0x60, 0xE1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_volume_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_av_volume_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_volume_up 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_av_volume_up_data[] PROGMEM = {
  0x71, 0x81, 0x6B, 0x27, 0x48, 0x22, 0xCF, 0x56, 0x81, 0x1C, 0xD3, 0x81, 0x8F, 0x34, 0x01, 0x0C,
  0xA1, 0x89, 0x06, 0x10, 0xCB, 0x01, 0xAB, 0xDB, 0x18, 0x5A, 0xB0, 0x5F, 0x14, 0xE1, 0x85, 0xAF,
  0x11, 0xF3, 0x4E, 0x18, 0x90, 0xAF, 0x11, 0xF3, 0x1A, 0xBD, 0xB1, 0x84, 0xAB, 0x05, 0xF1, 0x30,
  0x10, 0xCA, 0x18, 0x36, 0x10, 0xCB, 0x58, 0x11, 0xCD, 0x38, 0x18, 0xF3, 0x72, 0x82, 0x2C, 0xF5,
  0x73, 0x81, 0x7B, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_volume_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_av_volume_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_web_asset_off 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_av_web_asset_off_data[] PROGMEM = {
  0x05, 0x06, 0x77, 0x83, 0x5F, 0x70, 0x18, 0x05, 0x58, 0x13, 0x01, 0xA8, 0x17, 0x09, 0xFA, 0x01,
  0x03, 0xB8, 0x17, 0x09, 0xF9, 0x85, 0x33, 0xF5, 0x7F, 0x71, 0x80, 0x23, 0x89, 0x05, 0xF3, 0x3F,
  0x20, 0x6F, 0x76, 0x84, 0x2F, 0x33, 0xF2, 0x28, 0x16, 0xF7, 0x58, 0x42, 0xF3, 0x3F, 0x23, 0x81,
  0x6F, 0x74, 0x84, 0x2F, 0x33, 0xF2, 0x48, 0x16, 0xF7, 0x38, 0x42, 0xF3, 0x3F, 0x25, 0x81, 0x6F,
  0x72, 0x84, 0x2F, 0x33, 0xF2, 0x68, 0x66, 0xF7, 0x02, 0xF3, 0x1F, 0xC8, 0x47, 0x08, 0x10, 0x38,
  0x05, 0x58, 0x17, 0xF7, 0x77, 0x81, 0x6F, 0x67, 0x70, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_web_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_av_web_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_web_asset 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_av_web_asset_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF8, 0x23, 0x3F, 0x58, 0x06, 0x38,
  0x45, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42,
  0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3,
  0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_web_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_web_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_av_web 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_av_web_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x82, 0x33, 0xF5,
  0x80, 0x23, 0x89, 0x06, 0xF5, 0x35, 0xF3, 0x3F, 0x26, 0x89, 0x03, 0xF2, 0x02, 0xF3, 0x3F, 0x88,
  0x02, 0x78, 0x90, 0x9F, 0x20, 0x2F, 0x33, 0xFC, 0x80, 0x2B, 0x89, 0x0C, 0xF2, 0x02, 0xF3, 0x3F,
  0x26, 0x89, 0x03, 0xF2, 0x02, 0xF3, 0x3F, 0x26, 0x86, 0x3F, 0x20, 0x2F, 0x31, 0xFF, 0x81, 0x10,
  0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_av_web() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_av_web_data, Alpha4(color::Black));
  return value;
}
