#include "action.h"

using namespace roo_display;

// Image file ic_round_18_action_123 18x18, 4-bit Alpha,  RLE, 25 bytes.
static const unsigned char ic_round_18_action_123_data[] PROGMEM = {
  0x8A, 0x03, 0xB4, 0x08, 0xB9, 0x07, 0xBA, 0x08, 0x60, 0x59, 0xD2, 0x87, 0x7E, 0x07, 0x60, 0xCA,
  0x62, 0x89, 0x37, 0xE0, 0x54, 0x08, 0xB9, 0x07, 0xBA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_123() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 13, 10), Box(0, 0, 17, 17),
      ic_round_18_action_123_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_3d_rotation 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_action_3d_rotation_data[] PROGMEM = {
  0x70, 0x17, 0x60, 0x30, 0xEA, 0x81, 0xEA, 0x47, 0x38, 0x69, 0xFE, 0x6B, 0xFA, 0x17, 0x20, 0x90,
  0xD2, 0x82, 0x4D, 0xC1, 0x72, 0x03, 0x38, 0x11, 0xDA, 0x77, 0x81, 0x4F, 0x47, 0x70, 0xB0, 0xA5,
  0x85, 0xBB, 0x56, 0xBB, 0x12, 0x06, 0x0E, 0x58, 0x52, 0xB8, 0x86, 0xC2, 0x28, 0x23, 0xDD, 0x33,
  0x85, 0x2B, 0x88, 0x6C, 0x24, 0x0E, 0x06, 0x38, 0x5B, 0xB5, 0x6B, 0xB1, 0x40, 0xA0, 0xB7, 0x78,
  0x14, 0xF4, 0x77, 0x81, 0xAD, 0x13, 0x03, 0x72, 0x82, 0x1C, 0xD4, 0x20, 0xD0, 0x97, 0x28, 0x61,
  0xAF, 0xB6, 0xEF, 0x97, 0x38, 0x14, 0xAE, 0xA0, 0xE0, 0x37, 0x60, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_3d_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_3d_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_abc 18x18, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_round_18_action_abc_data[] PROGMEM = {
  0x8D, 0x64, 0xBB, 0x23, 0xBB, 0x32, 0xBB, 0x46, 0x8A, 0x45, 0xCC, 0x44, 0xA2, 0x16, 0xEE, 0x45,
  0xCC, 0x44, 0xA2, 0x14, 0x56, 0x23, 0xBB, 0x32, 0xBB, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_abc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 14, 10), Box(0, 0, 17, 17),
      ic_round_18_action_abc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_accessibility_new 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_accessibility_new_data[] PROGMEM = {
  0x48, 0x22, 0xDD, 0x27, 0x10, 0x8A, 0x08, 0x71, 0x03, 0xA0, 0x34, 0x04, 0x02, 0x30, 0x01, 0x38,
  0x12, 0x4E, 0xA8, 0x4D, 0xBB, 0xBB, 0xDA, 0x83, 0xE0, 0x25, 0x9C, 0x81, 0x95, 0x24, 0x03, 0xC0,
  0x36, 0x03, 0xC0, 0x36, 0x03, 0xC0, 0x36, 0x84, 0x3F, 0xBB, 0xF3, 0x68, 0x43, 0xF1, 0x1F, 0x36,
  0x84, 0x3F, 0x11, 0xF3, 0x68, 0x43, 0xF1, 0x1F, 0x36, 0x84, 0x3F, 0x11, 0xF3, 0x70, 0x12, 0x01,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_accessibility_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_accessibility_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_accessibility 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_accessibility_data[] PROGMEM = {
  0x58, 0x22, 0xDD, 0x27, 0x30, 0x8A, 0x08, 0x73, 0x03, 0xA0, 0x37, 0x40, 0x01, 0x60, 0x10, 0xA8,
  0x06, 0xB8, 0x5A, 0x11, 0x99, 0x9B, 0xC8, 0x3B, 0x99, 0x91, 0x40, 0x3C, 0x03, 0x71, 0x03, 0xC0,
  0x37, 0x10, 0x3C, 0x03, 0x71, 0x84, 0x3F, 0xBB, 0xF3, 0x71, 0x84, 0x3F, 0x11, 0xF3, 0x71, 0x84,
  0x3F, 0x11, 0xF3, 0x71, 0x84, 0x3F, 0x11, 0xF3, 0x71, 0x84, 0x3F, 0x11, 0xF3, 0x72, 0x01, 0x20,
  0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_accessibility() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_accessibility_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_accessible_forward 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_accessible_forward_data[] PROGMEM = {
  0x72, 0x81, 0xAE, 0x57, 0x10, 0x3A, 0x0C, 0x71, 0x82, 0x1D, 0xF7, 0x68, 0x01, 0x15, 0x03, 0xD0,
  0x55, 0x82, 0xBB, 0x3D, 0xA0, 0x45, 0x81, 0x10, 0x5A, 0x0B, 0x48, 0x37, 0xD3, 0x0D, 0xA0, 0x23,
  0x83, 0xAE, 0x71, 0x7A, 0x09, 0x38, 0x12, 0xF4, 0x20, 0xCA, 0x83, 0xCB, 0x90, 0x59, 0x38, 0x90,
  0x49, 0x99, 0x9F, 0x53, 0xF3, 0x30, 0x60, 0x42, 0x89, 0x0E, 0x60, 0xBD, 0x43, 0x9F, 0x32, 0x83,
  0xE6, 0x01, 0xAA, 0x0D, 0x04, 0x30, 0xD0, 0x54, 0x02, 0x50, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_accessible_forward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_accessible_forward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_accessible 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_accessible_data[] PROGMEM = {
  0x58, 0x18, 0xE7, 0x71, 0x01, 0xB7, 0x28, 0x1B, 0xFA, 0x73, 0x03, 0x73, 0x81, 0x9F, 0x87, 0x20,
  0xDA, 0x08, 0x71, 0x85, 0xDF, 0xEE, 0xD9, 0x32, 0x8A, 0x07, 0xD3, 0xDF, 0xC1, 0x8C, 0x50, 0xAE,
  0x71, 0xDF, 0xC4, 0x81, 0x2F, 0x42, 0x86, 0xCF, 0xEB, 0xB9, 0x05, 0x93, 0x89, 0x03, 0x99, 0x99,
  0xF5, 0x3F, 0x33, 0x06, 0x04, 0x28, 0x90, 0xE6, 0x0B, 0xD4, 0x39, 0xF3, 0x28, 0x3E, 0x60, 0x1A,
  0xA0, 0xD0, 0x43, 0x0E, 0x06, 0x40, 0x25, 0x03, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_accessible() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_accessible_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_account_balance 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_account_balance_data[] PROGMEM = {
  0x68, 0x25, 0xCC, 0x57, 0x30, 0x50, 0xDC, 0x0D, 0x05, 0x60, 0x50, 0xDF, 0x90, 0xD0, 0x53, 0x0C,
  0xFD, 0x81, 0xC0, 0x1F, 0xF8, 0x11, 0x02, 0x80, 0x90, 0x30, 0x23, 0x03, 0x09, 0x30, 0x06, 0x30,
  0x90, 0x34, 0x06, 0x0E, 0x30, 0x0A, 0x30, 0xE0, 0x64, 0x06, 0x0E, 0x30, 0x0A, 0x30, 0xE0, 0x64,
  0x06, 0x0E, 0x30, 0x0A, 0x30, 0xE0, 0x64, 0x06, 0x0E, 0x30, 0x0A, 0x30, 0xE0, 0x64, 0x04, 0x0D,
  0x30, 0x09, 0x30, 0xD0, 0x47, 0x74, 0x01, 0xFF, 0x01, 0x18, 0x09, 0x23, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_account_balance() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_account_balance_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_account_balance_wallet 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_account_balance_wallet_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x30, 0x22, 0x02, 0xFD, 0x81, 0x20, 0x4F, 0xD8, 0x14, 0x04, 0xC0, 0xD0, 0x17,
  0x10, 0x4C, 0x81, 0xA0, 0xA8, 0x02, 0xB0, 0x10, 0x4C, 0x0A, 0x1B, 0x0E, 0xB0, 0x30, 0x4C, 0x0A,
  0x1A, 0x81, 0x30, 0xDA, 0x03, 0x04, 0xC0, 0xA1, 0xA8, 0x13, 0x0D, 0xA0, 0x30, 0x4C, 0x0A, 0x1B,
  0x0E, 0xB0, 0x30, 0x4C, 0x81, 0xA0, 0xA8, 0x02, 0xB0, 0x10, 0x4C, 0x0D, 0x01, 0x71, 0x04, 0xFD,
  0x81, 0x40, 0x2F, 0xD0, 0x22, 0x02, 0x80, 0x63, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_account_balance_wallet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_account_balance_wallet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_account_box 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_account_box_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4C, 0x07, 0x20, 0x7C, 0x00,
  0x4B, 0x09, 0x40, 0x9B, 0x00, 0x4B, 0x05, 0x40, 0x5B, 0x00, 0x4B, 0x07, 0x40, 0x7B, 0x00, 0x4B,
  0x0E, 0x02, 0x20, 0x20, 0xEB, 0x00, 0x4D, 0x00, 0xBD, 0x00, 0x4B, 0x84, 0xA6, 0x44, 0x6A, 0xB8,
  0x34, 0x4F, 0xA1, 0x68, 0x51, 0xAF, 0x44, 0xF1, 0x71, 0x82, 0x1F, 0x42, 0xFD, 0x81, 0x20, 0x28,
  0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_account_box() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_account_box_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_account_circle 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_account_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xC0, 0x72, 0x07, 0xC0, 0x32, 0x0B, 0xB0, 0x94, 0x09, 0xB0, 0xB2, 0xC0, 0x54, 0x05, 0xC1, 0x02,
  0xC0, 0x74, 0x07, 0xC0, 0x02, 0xC0, 0xE0, 0x22, 0x02, 0x0E, 0xC0, 0x21, 0xE0, 0x0B, 0xE2, 0x0B,
  0xB8, 0x4A, 0x64, 0x46, 0xAB, 0x0B, 0x28, 0x23, 0xFB, 0x16, 0x82, 0x1B, 0xF3, 0x38, 0x19, 0xF5,
  0x68, 0x15, 0xF9, 0x58, 0x90, 0x9F, 0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74,
  0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_account_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_account_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_add_card 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_add_card_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x03, 0x20, 0x1F, 0xF8, 0x31, 0x03, 0xF2, 0x73, 0x85, 0x2F, 0x30, 0x3F,
  0xC8, 0x06, 0xB8, 0x3C, 0xF3, 0x03, 0xFF, 0x81, 0x30, 0x3F, 0xF8, 0x33, 0x03, 0xF2, 0x77, 0x81,
  0x3F, 0x27, 0x30, 0x40, 0x52, 0x81, 0x3F, 0x27, 0x30, 0x90, 0xB2, 0x81, 0x3F, 0x27, 0x18, 0x53,
  0x5B, 0xD5, 0x41, 0xF9, 0x81, 0x90, 0xAC, 0x81, 0xC0, 0x38, 0x03, 0x50, 0x33, 0x09, 0x0B, 0x77,
  0x10, 0x80, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_add_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_action_add_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_addchart 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_action_addchart_data[] PROGMEM = {
  0x10, 0x28, 0x01, 0x30, 0x23, 0x02, 0x20, 0x2E, 0x0B, 0x20, 0x50, 0xE2, 0x04, 0x97, 0x08, 0xA8,
  0x1E, 0x24, 0x94, 0x87, 0x44, 0x02, 0x9F, 0x50, 0x49, 0x40, 0x0A, 0x20, 0x20, 0x82, 0x86, 0x4F,
  0x05, 0x70, 0xAA, 0x68, 0x64, 0xF0, 0x9B, 0x0A, 0xA4, 0x8F, 0x1B, 0x24, 0xF0, 0x9B, 0x0A, 0xA0,
  0x97, 0x0F, 0x44, 0xF0, 0x9B, 0x0A, 0xA0, 0xB9, 0x0F, 0x44, 0xF0, 0x9B, 0x0A, 0xA0, 0xB9, 0x0F,
  0x44, 0xF0, 0x34, 0x04, 0x40, 0x43, 0x0F, 0x44, 0x97, 0x39, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28,
  0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_addchart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_addchart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_add_home 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_add_home_data[] PROGMEM = {
  0x48, 0x23, 0xCC, 0x37, 0x20, 0x6C, 0x06, 0x70, 0xAE, 0x0A, 0x40, 0x10, 0xDF, 0x90, 0xD0, 0x12,
  0x05, 0xFB, 0x05, 0x20, 0x6F, 0x98, 0x1A, 0x93, 0x20, 0x6E, 0x0B, 0x01, 0x50, 0x6D, 0x87, 0xB0,
  0x6D, 0xFD, 0x60, 0x6D, 0x01, 0x06, 0xA0, 0xBA, 0x00, 0x6C, 0x81, 0xA0, 0xDA, 0x01, 0xA0, 0xD0,
  0x6C, 0x82, 0x90, 0xFA, 0x38, 0x1A, 0xF3, 0xC8, 0x1A, 0x0D, 0xA0, 0x1A, 0x87, 0xD0, 0x23, 0x33,
  0x30, 0x6A, 0x0B, 0xA0, 0x67, 0x18, 0x36, 0xDF, 0xD6, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_add_home() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_add_home_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_add_shopping_cart 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_action_add_shopping_cart_data[] PROGMEM = {
  0x02, 0x03, 0x50, 0x09, 0x5A, 0x0A, 0x40, 0x0A, 0x58, 0x91, 0x16, 0xF2, 0x08, 0x9D, 0xD9, 0x82,
  0x01, 0x28, 0x91, 0xD8, 0x0A, 0xBE, 0xEB, 0xA0, 0x49, 0x20, 0x70, 0xE3, 0x00, 0xA3, 0x00, 0xB2,
  0x81, 0x1F, 0x62, 0x00, 0x92, 0x81, 0x2F, 0x43, 0x09, 0x0C, 0x60, 0x90, 0xD4, 0x81, 0x3F, 0x98,
  0x01, 0x70, 0xE0, 0x64, 0x05, 0x98, 0x02, 0xD0, 0xA5, 0x0E, 0x09, 0x74, 0x81, 0x1F, 0xC8, 0x04,
  0xB0, 0x23, 0x05, 0x80, 0x59, 0x01, 0x30, 0x05, 0x60, 0x05, 0x30, 0x4A, 0x03, 0x40, 0x3A, 0x04,
  0x28, 0x22, 0xFE, 0x14, 0x82, 0x1E, 0xF2, 0x30, 0x01, 0x60, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_add_shopping_cart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_add_shopping_cart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_add_task 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_round_18_action_add_task_data[] PROGMEM = {
  0x68, 0x25, 0x76, 0x57, 0x30, 0x10, 0x9D, 0x0E, 0x07, 0x78, 0x93, 0x2D, 0xF9, 0x31, 0x13, 0x97,
  0x04, 0xB3, 0x82, 0x1D, 0xD3, 0x78, 0x14, 0xEC, 0x38, 0x19, 0xF3, 0x78, 0x24, 0xEC, 0x12, 0x81,
  0x1F, 0x97, 0x82, 0x4E, 0xC1, 0x38, 0x15, 0xF4, 0x68, 0x24, 0xEC, 0x14, 0x07, 0x92, 0x04, 0x02,
  0x28, 0x24, 0xEC, 0x15, 0x06, 0x92, 0x85, 0xCE, 0x24, 0xEC, 0x12, 0x00, 0x92, 0x89, 0x05, 0xF3,
  0x02, 0xDE, 0xEC, 0x13, 0x00, 0xB2, 0x81, 0x1F, 0x92, 0x82, 0x2D, 0xC1, 0x28, 0x90, 0x9B, 0xEE,
  0xB9, 0x09, 0xF3, 0x78, 0x91, 0x9B, 0xEE, 0xB9, 0x01, 0xDD, 0x27, 0x10, 0x0B, 0x48, 0x32, 0xDF,
  0x83, 0x20, 0x30, 0x42, 0x00, 0x95, 0x01, 0x09, 0xD0, 0xE7, 0x58, 0x35, 0x77, 0x51, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_add_task() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_add_task_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_add_to_drive 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_action_add_to_drive_data[] PROGMEM = {
  0x68, 0x00, 0x30, 0x17, 0x50, 0xCB, 0x0B, 0x73, 0x81, 0x43, 0x3C, 0x04, 0x72, 0x82, 0xDC, 0x09,
  0xB0, 0xD7, 0x10, 0x7A, 0x81, 0x61, 0xEB, 0x07, 0x60, 0x10, 0xEA, 0x81, 0xE0, 0x7B, 0x0E, 0x01,
  0x50, 0x9B, 0x85, 0xE1, 0x0D, 0xF8, 0x35, 0x03, 0xC0, 0x62, 0x04, 0x03, 0x20, 0x14, 0x0B, 0xB0,
  0xC6, 0x81, 0x4F, 0x12, 0x01, 0x0E, 0xB8, 0x23, 0x3B, 0xB2, 0x83, 0x15, 0xF2, 0x12, 0x07, 0xA8,
  0x5A, 0x0B, 0xFE, 0x04, 0xD0, 0x12, 0x82, 0xDE, 0x15, 0xB1, 0x84, 0x13, 0x7F, 0x43, 0x38, 0x26,
  0x70, 0xDB, 0x06, 0x28, 0x14, 0xF1, 0x68, 0x41, 0x33, 0x33, 0x22, 0x01, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_add_to_drive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_action_add_to_drive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_admin_panel_settings 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_admin_panel_settings_data[] PROGMEM = {
  0x40, 0x02, 0x71, 0x04, 0x0A, 0xA0, 0xC0, 0x54, 0x01, 0x0C, 0xE0, 0xD0, 0x32, 0x06, 0xF9, 0x09,
  0x20, 0x6F, 0x90, 0x92, 0x05, 0xD8, 0x2E, 0x61, 0x12, 0x03, 0xC8, 0x4E, 0x3A, 0xEC, 0x42, 0x0E,
  0xB8, 0x76, 0xAF, 0x1A, 0xE1, 0x08, 0xB8, 0x52, 0xEF, 0xAE, 0xF5, 0x20, 0xCA, 0x85, 0x3C, 0x71,
  0x3E, 0x33, 0x86, 0xAF, 0xA4, 0xC8, 0xA9, 0x58, 0x42, 0x40, 0x15, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_admin_panel_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_admin_panel_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_ads_click 18x18, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_round_18_action_ads_click_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x89,
  0x29, 0xF5, 0x02, 0x66, 0x20, 0x5E, 0x93, 0x89, 0x43, 0xF5, 0x09, 0xFE, 0xEF, 0x90, 0x5F, 0x32,
  0x84, 0xBB, 0x09, 0xE4, 0x28, 0x44, 0xE9, 0x0B, 0xB2, 0x98, 0x25, 0x2F, 0x44, 0x89, 0x14, 0xF2,
  0x5F, 0x02, 0xF3, 0x6E, 0x68, 0x90, 0xA5, 0x3F, 0x22, 0xF3, 0x6E, 0x38, 0x17, 0x83, 0x28, 0x71,
  0x92, 0x0F, 0x52, 0xF4, 0x20, 0x8A, 0x81, 0xD9, 0x43, 0x86, 0xBB, 0x09, 0xE4, 0x03, 0xC0, 0xD0,
  0x22, 0x87, 0x3F, 0x50, 0xAF, 0xA0, 0xDA, 0x0D, 0x58, 0x92, 0x9F, 0x50, 0x25, 0x09, 0xFD, 0xFB,
  0x58, 0x92, 0x9F, 0xB5, 0x30, 0x4D, 0x0B, 0xFB, 0x50, 0x30, 0xBA, 0x81, 0x90, 0x22, 0x81, 0xBF,
  0x57, 0x02, 0x01, 0x50, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_ads_click() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_ads_click_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_alarm_add 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_action_alarm_add_data[] PROGMEM = {
  0x20, 0x10, 0x67, 0x10, 0x60, 0x13, 0x8A, 0x31, 0xCE, 0x10, 0x25, 0x52, 0x01, 0xEC, 0x10, 0x1C,
  0xE3, 0x4D, 0xC8, 0x90, 0xD4, 0x3E, 0xC1, 0x5E, 0x37, 0xF9, 0x82, 0x73, 0xE5, 0x20, 0x4F, 0xB0,
  0x44, 0x0C, 0xC0, 0x09, 0xC0, 0xC3, 0x01, 0xD0, 0x05, 0xD0, 0x12, 0x04, 0xB8, 0x49, 0x31, 0x13,
  0x9B, 0x04, 0x20, 0x3B, 0x84, 0xB5, 0x11, 0x5B, 0xB0, 0x32, 0x01, 0xD0, 0x05, 0xD0, 0x13, 0x0B,
  0xC0, 0x0B, 0xC0, 0xB4, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x50, 0x40, 0xEE, 0x0E, 0x04, 0x78, 0x12,
  0xAE, 0xA8, 0x1E, 0xA2, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_alarm_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_alarm_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_alarm_off 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_action_alarm_off_data[] PROGMEM = {
  0x05, 0x06, 0x73, 0x06, 0x01, 0x28, 0x15, 0xF7, 0x38, 0x22, 0x55, 0x22, 0x89, 0x0D, 0xC1, 0x01,
  0xDF, 0x70, 0x7C, 0x89, 0x3D, 0x42, 0xDC, 0x14, 0xD7, 0xF7, 0x09, 0xD8, 0x27, 0x2D, 0x42, 0x04,
  0xA8, 0x17, 0x09, 0xD0, 0x44, 0x0C, 0xB8, 0x17, 0x09, 0xC0, 0xC3, 0x01, 0xD8, 0x17, 0x09, 0xC0,
  0x12, 0x04, 0xE8, 0x17, 0x09, 0xB0, 0x42, 0x03, 0xF8, 0x17, 0x09, 0xA0, 0x32, 0x01, 0xF9, 0x83,
  0x70, 0x9F, 0x13, 0x0A, 0xF9, 0x81, 0x70, 0x54, 0x02, 0x0E, 0xF9, 0x07, 0x60, 0x40, 0xEE, 0x81,
  0xEF, 0x76, 0x81, 0x19, 0xEA, 0x84, 0xE9, 0x16, 0xF6, 0x71, 0x00, 0x14, 0x00, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_alarm_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_alarm_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_alarm_on 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_action_alarm_on_data[] PROGMEM = {
  0x20, 0x10, 0x67, 0x10, 0x60, 0x13, 0x81, 0x1C, 0xD2, 0x82, 0x25, 0x52, 0x28, 0x90, 0xDC, 0x10,
  0x1C, 0xD2, 0x4D, 0xC8, 0x90, 0xD4, 0x2D, 0xC1, 0x4D, 0x27, 0xF9, 0x82, 0x72, 0xD4, 0x20, 0x4F,
  0xB0, 0x44, 0x0C, 0xF8, 0x29, 0xEF, 0xC3, 0x01, 0xF8, 0x15, 0x0D, 0xA0, 0x12, 0x04, 0xB8, 0x47,
  0xDF, 0x50, 0xBB, 0x04, 0x20, 0x3B, 0x83, 0x22, 0x50, 0xBC, 0x03, 0x20, 0x1B, 0x82, 0xD2, 0x0B,
  0xD0, 0x13, 0x0B, 0xC0, 0xED, 0x0B, 0x40, 0x20, 0xEF, 0x90, 0xE0, 0x25, 0x04, 0x0E, 0xE0, 0xE0,
  0x47, 0x81, 0x2A, 0xEA, 0x81, 0xEA, 0x27, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_alarm_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_alarm_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_alarm 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_action_alarm_data[] PROGMEM = {
  0x20, 0x10, 0x67, 0x10, 0x60, 0x13, 0x81, 0x1C, 0xD2, 0x82, 0x25, 0x52, 0x28, 0x90, 0xDC, 0x10,
  0x1C, 0xD2, 0x4D, 0xC8, 0x90, 0xD4, 0x2D, 0xC1, 0x4D, 0x27, 0xF9, 0x82, 0x72, 0xD4, 0x20, 0x4C,
  0x00, 0xAC, 0x04, 0x40, 0xCC, 0x00, 0x5C, 0x0C, 0x30, 0x1D, 0x00, 0x5D, 0x01, 0x20, 0x4D, 0x81,
  0x52, 0xEC, 0x04, 0x20, 0x3D, 0x82, 0xD1, 0x3E, 0xB0, 0x32, 0x01, 0xE8, 0x1C, 0x18, 0xB0, 0x13,
  0x0B, 0xE0, 0xEB, 0x0B, 0x40, 0x20, 0xEF, 0x90, 0xE0, 0x25, 0x04, 0x0E, 0xE0, 0xE0, 0x47, 0x81,
  0x2A, 0xEA, 0x81, 0xEA, 0x27, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_all_inbox 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_all_inbox_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x70, 0xD8, 0x04, 0x18, 0x63, 0xF3, 0x06, 0x07,
  0xD7, 0x18, 0x62, 0xF3, 0x3F, 0x27, 0xD7, 0x18, 0x62, 0xF3, 0x3F, 0x27, 0xD7, 0x18, 0x62, 0xF3,
  0x3F, 0x27, 0xD7, 0x18, 0xA5, 0x2F, 0x33, 0xF2, 0x7F, 0xDD, 0xB1, 0x04, 0xCD, 0xDF, 0x33, 0xF2,
  0x7C, 0x81, 0xD9, 0xEC, 0x83, 0x33, 0xF2, 0x7F, 0xC8, 0x33, 0x3F, 0x27, 0xFC, 0x83, 0x33, 0xF2,
  0x6F, 0xC8, 0x41, 0x3F, 0x20, 0x68, 0x05, 0x78, 0x34, 0x03, 0xF3, 0x80, 0x51, 0x50, 0xEF, 0xB0,
  0x65, 0x80, 0x63, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_all_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_all_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_all_out 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_action_all_out_data[] PROGMEM = {
  0x10, 0xF3, 0x60, 0xF3, 0x10, 0x3B, 0x02, 0x40, 0x2B, 0x03, 0x04, 0x93, 0x82, 0x26, 0x62, 0x39,
  0x00, 0x49, 0x28, 0x49, 0xFE, 0xEF, 0x92, 0x98, 0x54, 0x02, 0x09, 0xE4, 0x28, 0x34, 0xE9, 0x02,
  0x38, 0x12, 0xF4, 0x48, 0x14, 0xF2, 0x40, 0x60, 0xE6, 0x0E, 0x06, 0x40, 0x60, 0xE6, 0x0E, 0x06,
  0x48, 0x12, 0xF4, 0x48, 0x14, 0xF2, 0x38, 0x32, 0x09, 0xE4, 0x28, 0x54, 0xE9, 0x02, 0x04, 0x92,
  0x84, 0x9F, 0xEE, 0xF9, 0x29, 0x00, 0x49, 0x38, 0x22, 0x66, 0x23, 0x90, 0x40, 0x3B, 0x02, 0x40,
  0x2B, 0x03, 0x10, 0xF3, 0x60, 0xF3, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_all_out() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_all_out_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_analytics 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_analytics_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0x90, 0xA0, 0xBA, 0x00,
  0x4F, 0x90, 0x30, 0x6A, 0x00, 0x4D, 0x83, 0xDD, 0xF3, 0x6A, 0x00, 0x4D, 0x83, 0x77, 0xF3, 0x6A,
  0x00, 0x4A, 0x08, 0x05, 0xC0, 0x30, 0x6A, 0x00, 0x4A, 0x86, 0x63, 0xF6, 0x6F, 0x36, 0xA0, 0x04,
  0xA8, 0x66, 0x3F, 0x55, 0xF3, 0x6A, 0x00, 0x4A, 0x86, 0xBA, 0xFB, 0xBF, 0xAB, 0xA0, 0x04, 0xFD,
  0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_analytics() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_analytics_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_anchor 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_anchor_data[] PROGMEM = {
  0x60, 0x06, 0x74, 0x0C, 0xA0, 0xC7, 0x28, 0x42, 0xF6, 0x6F, 0x27, 0x18, 0x41, 0xFC, 0xCF, 0x17,
  0x28, 0x25, 0xEE, 0x57, 0x28, 0x42, 0x3C, 0xC3, 0x27, 0x10, 0xDC, 0x0D, 0x71, 0x84, 0x23, 0xCC,
  0x32, 0x40, 0x60, 0x14, 0x00, 0xB4, 0x83, 0x16, 0xBE, 0x43, 0x00, 0xB3, 0x84, 0x4E, 0xBA, 0xFD,
  0x30, 0x0B, 0x38, 0x4D, 0xFA, 0x7F, 0x43, 0x00, 0xB3, 0x85, 0x4F, 0x71, 0xDD, 0x32, 0x00, 0xB2,
  0x89, 0x73, 0xDD, 0x10, 0x2D, 0xF9, 0x3C, 0xC4, 0x9F, 0xD2, 0x38, 0x11, 0x8E, 0xC8, 0x1E, 0x81,
  0x78, 0x24, 0x76, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_anchor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_anchor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_android 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_action_android_data[] PROGMEM = {
  0x20, 0x30, 0x67, 0x10, 0x60, 0x35, 0x0D, 0x01, 0x60, 0x10, 0xD6, 0x89, 0x06, 0xA4, 0x89, 0x98,
  0x49, 0x66, 0x04, 0xF9, 0x04, 0x50, 0x7F, 0xB0, 0x73, 0x05, 0xFD, 0x86, 0x50, 0x1E, 0xFA, 0x0D,
  0xC8, 0x5D, 0x0A, 0xFE, 0x18, 0xA8, 0x1D, 0x6E, 0xC8, 0x1E, 0x6D, 0xA0, 0x80, 0xCF, 0xF0, 0xC8,
  0x09, 0x47,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_announcement 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_action_announcement_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3E, 0x00, 0x7E, 0x00, 0x3E, 0x00,
  0x5E, 0x00, 0x3E, 0x00, 0x5E, 0x00, 0x3E, 0x00, 0x5E, 0x00, 0x3E, 0x00, 0x7E, 0x00, 0x3F, 0xF0,
  0x03, 0xE0, 0x06, 0xE0, 0x03, 0xE0, 0x0E, 0xE0, 0x03, 0xFF, 0x01, 0x03, 0xA0, 0x98, 0x06, 0x78,
  0x34, 0x03, 0xF7, 0x76, 0x01, 0x05, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_announcement() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_announcement_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_api 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_action_api_data[] PROGMEM = {
  0x70, 0x07, 0x76, 0x0B, 0xA0, 0xB7, 0x40, 0xBC, 0x0B, 0x72, 0x86, 0x2E, 0xFD, 0xDF, 0xE2, 0x78,
  0x90, 0x20, 0x3C, 0x11, 0xC3, 0x02, 0x58, 0x1B, 0xE3, 0x68, 0x13, 0xEB, 0x30, 0xBA, 0x0C, 0x60,
  0xCA, 0x81, 0xB0, 0x7A, 0x0D, 0x01, 0x20, 0x0D, 0x20, 0x10, 0xDA, 0x00, 0x7A, 0x0D, 0x01, 0x20,
  0x0D, 0x20, 0x10, 0xDA, 0x81, 0x70, 0xBA, 0x0C, 0x60, 0xCA, 0x0B, 0x38, 0x1B, 0xE3, 0x68, 0x13,
  0xEB, 0x58, 0x90, 0x20, 0x3C, 0x11, 0xC3, 0x02, 0x78, 0x62, 0xEF, 0xDD, 0xFE, 0x27, 0x20, 0xBC,
  0x0B, 0x74, 0x0B, 0xA0, 0xB7, 0x60, 0x07, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_api() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_api_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_app_blocking 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_app_blocking_data[] PROGMEM = {
  0x28, 0x04, 0x14, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x20, 0x6F, 0xB0, 0x62, 0x06, 0xFB, 0x06, 0x20,
  0x69, 0x80, 0x47, 0x90, 0x62, 0x06, 0x0E, 0x71, 0x05, 0x02, 0x20, 0x60, 0xE7, 0x85, 0x59, 0x81,
  0x06, 0xE6, 0x86, 0x7F, 0x56, 0xD0, 0x6E, 0x68, 0x6D, 0x7C, 0x19, 0x56, 0xE6, 0x86, 0xD0, 0x6C,
  0xA5, 0x6E, 0x68, 0x67, 0xB4, 0xBD, 0x06, 0xE7, 0x85, 0x59, 0x81, 0x06, 0xE7, 0x10, 0x50, 0x22,
  0x06, 0x98, 0x04, 0x79, 0x06, 0x20, 0x6F, 0xB0, 0x62, 0x06, 0xFB, 0x06, 0x20, 0x20, 0xEF, 0x90,
  0xE0, 0x24, 0x80, 0x41, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_app_blocking() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_app_blocking_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_app_shortcut 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_action_app_shortcut_data[] PROGMEM = {
  0x28, 0x04, 0x14, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x20, 0x6F, 0xB0, 0x62, 0x06, 0xFB, 0x06, 0x20,
  0x69, 0x80, 0x47, 0x90, 0x62, 0x06, 0x0E, 0x71, 0x84, 0x52, 0x20, 0x6E, 0x60, 0x22, 0x83, 0x2D,
  0x76, 0xE6, 0x0D, 0x03, 0x28, 0x27, 0x16, 0xE4, 0x83, 0x3A, 0xFD, 0x63, 0x06, 0x0E, 0x48, 0x33,
  0xAF, 0xD6, 0x30, 0x60, 0xE6, 0x0D, 0x03, 0x28, 0x27, 0x16, 0xE6, 0x02, 0x28, 0x32, 0xD7, 0x6E,
  0x71, 0x83, 0x52, 0x20, 0x69, 0x80, 0x47, 0x90, 0x62, 0x06, 0xFB, 0x06, 0x20, 0x6F, 0xB0, 0x62,
  0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x48, 0x04, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_app_shortcut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_app_shortcut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_arrow_circle_down 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_arrow_circle_down_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x18, 0x63, 0xBD, 0x99, 0xDB, 0x35, 0x81, 0x5C, 0x34, 0x81, 0x3C, 0x53,
  0x81, 0x3C, 0x16, 0x81, 0x1C, 0x32, 0x0B, 0x03, 0x30, 0x03, 0x38, 0x33, 0xB0, 0x1C, 0x40, 0x06,
  0x48, 0x2C, 0x13, 0xA4, 0x00, 0x64, 0x82, 0xA3, 0x3A, 0x20, 0x30, 0xEA, 0x0E, 0x03, 0x28, 0x2A,
  0x31, 0xC3, 0x82, 0x3E, 0xE3, 0x38, 0x3C, 0x10, 0xB3, 0x30, 0x03, 0x30, 0x30, 0xB2, 0x81, 0x3C,
  0x16, 0x81, 0x1C, 0x33, 0x81, 0x5C, 0x34, 0x81, 0x3C, 0x55, 0x86, 0x3B, 0xD9, 0x9D, 0xB3, 0x71,
  0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_arrow_circle_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_arrow_circle_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_arrow_circle_left 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_arrow_circle_left_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBF, 0xD0, 0xB2, 0xD0, 0xB0, 0x1F, 0x10, 0x2C, 0x0C, 0x28, 0x15, 0x5A, 0xC0,
  0x02, 0xC0, 0xC2, 0x81, 0x55, 0xAC, 0x02, 0x1D, 0x0B, 0x01, 0xF2, 0x0B, 0xFD, 0x0B, 0x20, 0x3F,
  0xD0, 0x33, 0x09, 0xFB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_arrow_circle_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_arrow_circle_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_arrow_circle_right 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_arrow_circle_right_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBF, 0xD0, 0xB2, 0xF0, 0x10, 0xBD, 0x10, 0x2C, 0x81, 0xA5, 0x52, 0x0C, 0xC0,
  0x02, 0xC8, 0x1A, 0x55, 0x20, 0xCC, 0x02, 0x1F, 0x01, 0x0B, 0xD2, 0x0B, 0xFD, 0x0B, 0x20, 0x3F,
  0xD0, 0x33, 0x09, 0xFB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_arrow_circle_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_arrow_circle_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_arrow_circle_up 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_arrow_circle_up_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x18, 0x63, 0xBD, 0x99, 0xDB, 0x35, 0x81, 0x5C, 0x34, 0x81, 0x3C, 0x53,
  0x81, 0x3C, 0x16, 0x81, 0x1C, 0x32, 0x0B, 0x03, 0x30, 0x03, 0x38, 0x33, 0xB0, 0x1C, 0x38, 0x23,
  0xEE, 0x33, 0x82, 0xC1, 0x3A, 0x20, 0x30, 0xEA, 0x0E, 0x03, 0x28, 0x2A, 0x33, 0xA4, 0x00, 0x64,
  0x82, 0xA3, 0x1C, 0x40, 0x06, 0x48, 0x3C, 0x10, 0xB3, 0x30, 0x03, 0x30, 0x30, 0xB2, 0x81, 0x3C,
  0x16, 0x81, 0x1C, 0x33, 0x81, 0x5C, 0x34, 0x81, 0x3C, 0x55, 0x86, 0x3B, 0xD9, 0x9D, 0xB3, 0x71,
  0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_arrow_circle_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_arrow_circle_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_arrow_outward 18x18, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_18_action_arrow_outward_data[] PROGMEM = {
  0x01, 0x80, 0x47, 0x01, 0x04, 0x80, 0x2D, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x83, 0x7F, 0x7D, 0x74,
  0x84, 0x7F, 0x70, 0xD7, 0x38, 0x17, 0xF7, 0x20, 0xD0, 0x72, 0x81, 0x7F, 0x73, 0x84, 0xD7, 0x07,
  0xF7, 0x48, 0x3D, 0x77, 0xF7, 0x58, 0x2D, 0x7F, 0x76, 0x04, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_arrow_outward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_action_arrow_outward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_arrow_right_alt 18x18, 4-bit Alpha,  RLE, 17 bytes.
static const unsigned char ic_round_18_action_arrow_right_alt_data[] PROGMEM = {
  0x71, 0x82, 0x4C, 0x12, 0x80, 0x39, 0x82, 0xBF, 0xC2, 0x80, 0x39, 0x81, 0xBF, 0xC7, 0x18, 0x14,
  0xC1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_arrow_right_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 13, 10), Box(0, 0, 17, 17),
      ic_round_18_action_arrow_right_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_article 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_article_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4A, 0x0B, 0x80, 0x25, 0x0B,
  0xA0, 0x04, 0xA0, 0xA8, 0x02, 0x30, 0xAA, 0x00, 0x4F, 0xD0, 0x04, 0xA0, 0xB8, 0x02, 0x50, 0xBA,
  0x00, 0x4A, 0x0B, 0x80, 0x25, 0x0B, 0xA0, 0x04, 0xFD, 0x00, 0x4A, 0x84, 0xA3, 0x33, 0x38, 0xC0,
  0x04, 0xA8, 0x4B, 0x55, 0x55, 0xAC, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63,
  0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_article() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_article_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_aspect_ratio 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_aspect_ratio_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x51, 0x3F, 0x20, 0x11, 0x78, 0x52, 0xF3, 0x3F,
  0x2C, 0xA0, 0x86, 0x87, 0x2F, 0x33, 0xF2, 0xE8, 0x37, 0x86, 0x2F, 0x33, 0xF2, 0xE6, 0x68, 0x90,
  0x14, 0x2F, 0x33, 0xF2, 0x41, 0x68, 0x66, 0xE2, 0xF3, 0x3F, 0x27, 0x87, 0x38, 0xE2, 0xF3, 0x3F,
  0x26, 0x08, 0xA8, 0x5C, 0x2F, 0x33, 0xF2, 0x78, 0x51, 0x10, 0x2F, 0x31, 0xFF, 0x81, 0x10, 0x38,
  0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_aspect_ratio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_aspect_ratio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_assessment 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_assessment_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4D, 0x00, 0xBD, 0x00, 0x4D,
  0x00, 0x5D, 0x00, 0x4A, 0x83, 0xA8, 0xF5, 0x5D, 0x00, 0x4A, 0x83, 0x63, 0xF5, 0x5D, 0x00, 0x4A,
  0x83, 0x63, 0xF5, 0x5D, 0x00, 0x4A, 0x86, 0x63, 0xF5, 0x5F, 0x57, 0xA0, 0x04, 0xA8, 0x66, 0x3F,
  0x55, 0xF3, 0x6A, 0x00, 0x4A, 0x86, 0xBA, 0xFB, 0xBF, 0xAB, 0xA0, 0x04, 0xFD, 0x04, 0x02, 0xFD,
  0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_assessment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_assessment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_assignment_ind 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_assignment_ind_data[] PROGMEM = {
  0x58, 0x21, 0x88, 0x16, 0x89, 0x42, 0x33, 0x3A, 0xEE, 0xA3, 0x33, 0x20, 0x2D, 0x00, 0xCD, 0x02,
  0x04, 0xFD, 0x00, 0x4C, 0x07, 0x20, 0x7C, 0x00, 0x4B, 0x09, 0x40, 0x9B, 0x00, 0x4B, 0x05, 0x40,
  0x5B, 0x00, 0x4B, 0x07, 0x40, 0x7B, 0x00, 0x4B, 0x0E, 0x02, 0x20, 0x20, 0xEB, 0x00, 0x4D, 0x00,
  0xBD, 0x00, 0x4B, 0x84, 0xA6, 0x44, 0x6A, 0xB8, 0x34, 0x4F, 0xA1, 0x68, 0x51, 0xAF, 0x44, 0xF1,
  0x71, 0x82, 0x1F, 0x42, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_assignment_ind() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_assignment_ind_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_assignment_late 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_assignment_late_data[] PROGMEM = {
  0x58, 0x21, 0x88, 0x16, 0x89, 0x42, 0x33, 0x3A, 0xEE, 0xA3, 0x33, 0x20, 0x2D, 0x00, 0xCD, 0x02,
  0x04, 0xFD, 0x00, 0x4D, 0x00, 0xBD, 0x00, 0x4D, 0x00, 0x5D, 0x00, 0x4D, 0x00, 0x5D, 0x00, 0x4D,
  0x00, 0x5D, 0x00, 0x4D, 0x00, 0x8D, 0x00, 0x4F, 0xD0, 0x04, 0xD0, 0x09, 0xD0, 0x04, 0xD0, 0x0B,
  0xD0, 0x04, 0xFD, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_assignment_late() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_assignment_late_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_assignment 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_assignment_data[] PROGMEM = {
  0x58, 0x21, 0x88, 0x16, 0x89, 0x42, 0x33, 0x3A, 0xEE, 0xA3, 0x33, 0x20, 0x2D, 0x00, 0xCD, 0x02,
  0x04, 0xFD, 0x00, 0x4A, 0x0B, 0x80, 0x25, 0x0B, 0xA0, 0x04, 0xA0, 0xA8, 0x02, 0x30, 0xAA, 0x00,
  0x4F, 0xD0, 0x04, 0xA0, 0xB8, 0x02, 0x50, 0xBA, 0x00, 0x4A, 0x0B, 0x80, 0x25, 0x0B, 0xA0, 0x04,
  0xFD, 0x00, 0x4A, 0x84, 0xA3, 0x33, 0x38, 0xC0, 0x04, 0xA8, 0x4B, 0x55, 0x55, 0xAC, 0x00, 0x4F,
  0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_assignment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_assignment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_assignment_returned 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_action_assignment_returned_data[] PROGMEM = {
  0x58, 0x21, 0x88, 0x16, 0x89, 0x42, 0x33, 0x3A, 0xEE, 0xA3, 0x33, 0x20, 0x2D, 0x00, 0xCD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xD0, 0x0A, 0xD0, 0x04, 0xD0, 0x05, 0xD0, 0x04, 0xD0, 0x05,
  0xD0, 0x04, 0xC0, 0x12, 0x01, 0xC0, 0x04, 0xC0, 0xB2, 0x0B, 0xC0, 0x04, 0xD0, 0x0C, 0xD0, 0x04,
  0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_assignment_returned() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_assignment_returned_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_assignment_return 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_assignment_return_data[] PROGMEM = {
  0x58, 0x21, 0x88, 0x16, 0x89, 0x42, 0x33, 0x3A, 0xEE, 0xA3, 0x33, 0x20, 0x2D, 0x00, 0xCD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4C, 0x0B, 0x01, 0xE0, 0x04, 0xB0, 0xC2, 0x81,
  0x55, 0xAB, 0x00, 0x4B, 0x0C, 0x28, 0x15, 0x5A, 0xB0, 0x04, 0xC0, 0xB0, 0x1E, 0x00, 0x4F, 0xD0,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_assignment_return() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_assignment_return_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_assignment_turned_in 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_assignment_turned_in_data[] PROGMEM = {
  0x58, 0x21, 0x88, 0x16, 0x89, 0x42, 0x33, 0x3A, 0xEE, 0xA3, 0x33, 0x20, 0x2D, 0x00, 0xCD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xF9, 0x0A, 0xB0, 0x04, 0xF8, 0x15, 0x0D, 0xA0, 0x04, 0xB0,
  0x9A, 0x81, 0x50, 0xBB, 0x00, 0x4A, 0x84, 0xE0, 0x45, 0x0B, 0xC0, 0x04, 0xB0, 0xC2, 0x0B, 0xD0,
  0x04, 0xC0, 0x0D, 0xE0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63,
  0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_assignment_turned_in() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_assignment_turned_in_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_assured_workload 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_18_action_assured_workload_data[] PROGMEM = {
  0x68, 0x25, 0xCC, 0x57, 0x40, 0x50, 0xDC, 0x0D, 0x05, 0x70, 0x50, 0xDF, 0x90, 0xD0, 0x54, 0x0C,
  0xFD, 0x0C, 0x20, 0x1F, 0xF0, 0x12, 0x02, 0x80, 0x90, 0x30, 0x24, 0x03, 0x09, 0x30, 0x06, 0x30,
  0x90, 0x35, 0x06, 0x0E, 0x30, 0x0A, 0x30, 0xE0, 0x65, 0x06, 0x0E, 0x30, 0x0A, 0x30, 0xE0, 0x55,
  0x06, 0x0E, 0x30, 0x0A, 0x38, 0x12, 0x01, 0x40, 0x60, 0xE3, 0x00, 0xA3, 0x83, 0x4C, 0xF9, 0x12,
  0x04, 0x0D, 0x30, 0x08, 0x20, 0x5B, 0x0D, 0x0E, 0x74, 0x06, 0xA8, 0x2A, 0x2F, 0x1F, 0xA8, 0x54,
  0x5B, 0x22, 0xDE, 0x18, 0x05, 0x38, 0x51, 0x2F, 0x9D, 0xFB, 0x75, 0x09, 0xB0, 0x37, 0x68, 0x19,
  0xD4, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_assured_workload() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_action_assured_workload_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_autorenew 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_action_autorenew_data[] PROGMEM = {
  0x60, 0xA0, 0x17, 0x18, 0x32, 0x5F, 0xC1, 0x50, 0x20, 0xBC, 0x05, 0x48, 0x52, 0xED, 0x40, 0xF7,
  0x50, 0xB0, 0xD3, 0x03, 0x58, 0x12, 0xF4, 0x68, 0x21, 0xE2, 0x59, 0x71, 0x90, 0x05, 0x97, 0x19,
  0x82, 0x52, 0xE1, 0x68, 0x14, 0xF2, 0x50, 0x33, 0x0D, 0x0B, 0x58, 0x57, 0xF0, 0x4D, 0xE2, 0x40,
  0x5C, 0x0B, 0x02, 0x58, 0x31, 0xDF, 0x52, 0x71, 0x01, 0x0A, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_autorenew() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_autorenew_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_backup 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_action_backup_data[] PROGMEM = {
  0x68, 0x21, 0x44, 0x17, 0x30, 0x10, 0xAC, 0x09, 0x01, 0x71, 0x0C, 0xE0, 0xC7, 0x06, 0xF9, 0x07,
  0x48, 0x12, 0x9E, 0xB0, 0x0B, 0xB0, 0xC3, 0x03, 0x0E, 0xC0, 0xA2, 0x0A, 0xB8, 0x2C, 0x60, 0xCD,
  0x02, 0x20, 0x2D, 0x07, 0xF0, 0x05, 0xE0, 0x0E, 0xE0, 0x0A, 0xF0, 0x9F, 0xF8, 0x1C, 0x0B, 0xFD,
  0x0D, 0x02, 0x20, 0x38, 0x06, 0x50, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_backup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_backup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_backup_table 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_action_backup_table_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x70, 0xD8, 0x04, 0x18, 0x63, 0xF3, 0x06, 0x07,
  0xD7, 0x18, 0x62, 0xF3, 0x3F, 0x27, 0xD7, 0x18, 0x62, 0xF3, 0x3F, 0x27, 0xD7, 0x18, 0x52, 0xF3,
  0x3F, 0x27, 0xFC, 0x8A, 0x43, 0x3F, 0x27, 0xE5, 0x55, 0x8F, 0x65, 0x57, 0xF3, 0x3F, 0x27, 0xD3,
  0x05, 0x93, 0x86, 0x2F, 0x33, 0xF2, 0x7D, 0x30, 0x59, 0x38, 0x62, 0xF3, 0x3F, 0x27, 0xD3, 0x05,
  0x93, 0x8A, 0x62, 0xF3, 0x3F, 0x26, 0xFD, 0xDD, 0xEF, 0xDD, 0xDD, 0xF1, 0x3F, 0x20, 0x68, 0x05,
  0x78, 0x34, 0x03, 0xF3, 0x80, 0x51, 0x50, 0xEF, 0xB0, 0x65, 0x80, 0x63, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_backup_table() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_backup_table_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_balance 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_action_balance_data[] PROGMEM = {
  0x70, 0x01, 0x76, 0x07, 0xA0, 0x77, 0x89, 0x42, 0xDD, 0xDD, 0xF8, 0x8F, 0xDD, 0xDD, 0x23, 0x89,
  0x27, 0xC7, 0x7D, 0xCC, 0xD7, 0x7C, 0x74, 0x05, 0x0E, 0x28, 0x22, 0xDD, 0x22, 0x0E, 0x05, 0x48,
  0x1C, 0xB5, 0x20, 0x0A, 0x28, 0x15, 0xBC, 0x38, 0x23, 0xB2, 0xC2, 0x00, 0xA2, 0x82, 0xC2, 0xB3,
  0x28, 0xB4, 0xA4, 0x0B, 0x30, 0xAA, 0x03, 0xB0, 0x4A, 0x01, 0xE5, 0x59, 0x90, 0xAA, 0x09, 0x95,
  0x5E, 0x20, 0xDB, 0x84, 0x70, 0xAA, 0x07, 0xB0, 0xD2, 0x82, 0x18, 0xA6, 0x20, 0x0A, 0x28, 0x26,
  0xA8, 0x17, 0x10, 0x0A, 0x77, 0x00, 0xA7, 0x01, 0xFF, 0x01, 0x18, 0x09, 0x23, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_balance() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_balance_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_batch_prediction 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_action_batch_prediction_data[] PROGMEM = {
  0x38, 0x00, 0x35, 0x84, 0x59, 0x99, 0x95, 0x30, 0x18, 0x02, 0x70, 0x12, 0x03, 0x80, 0x25, 0x82,
  0x30, 0x2A, 0x80, 0x2B, 0x81, 0xA2, 0x7A, 0x82, 0xC4, 0x4C, 0xA8, 0x37, 0x7F, 0xE1, 0x28, 0x51,
  0xEF, 0x77, 0xFC, 0x48, 0x2C, 0xF7, 0x7A, 0x01, 0x20, 0x1A, 0x00, 0x7A, 0x0B, 0x20, 0xBA, 0x00,
  0x7B, 0x00, 0x7B, 0x00, 0x7B, 0x00, 0xAB, 0x07, 0x06, 0xB0, 0x0D, 0xB0, 0x61, 0x80, 0x43, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_batch_prediction() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_action_batch_prediction_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_bookmark_added 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_bookmark_added_data[] PROGMEM = {
  0x18, 0x01, 0x30, 0x15, 0x05, 0xD0, 0x13, 0x81, 0x7E, 0x7C, 0x86, 0xE0, 0x4A, 0x8F, 0x67, 0xD8,
  0x51, 0x2E, 0xF6, 0x07, 0xD8, 0x29, 0x02, 0x42, 0x07, 0xE0, 0x90, 0x13, 0x07, 0xF9, 0x07, 0x20,
  0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7B, 0x00,
  0xAB, 0x07, 0x28, 0x24, 0xC7, 0x12, 0x82, 0x17, 0xC4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_bookmark_added() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_bookmark_added_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_bookmark_add 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_action_bookmark_add_data[] PROGMEM = {
  0x18, 0x01, 0x30, 0x12, 0x06, 0x20, 0x5D, 0x85, 0x10, 0x4F, 0x40, 0x7C, 0x81, 0xE0, 0x6B, 0x06,
  0x07, 0xD8, 0x51, 0x04, 0xF4, 0x07, 0xD0, 0x92, 0x06, 0x20, 0x7E, 0x09, 0x01, 0x30, 0x7F, 0x90,
  0x72, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07,
  0xB0, 0x0A, 0xB0, 0x72, 0x82, 0x4C, 0x71, 0x28, 0x21, 0x7C, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_bookmark_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_bookmark_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_bookmark_border 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_bookmark_border_data[] PROGMEM = {
  0x10, 0x78, 0x04, 0xB8, 0x37, 0x02, 0xFE, 0x80, 0x2B, 0x84, 0xEF, 0x23, 0xF4, 0x68, 0x44, 0xF3,
  0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68,
  0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x8A, 0x03, 0xF3,
  0x3F, 0x31, 0x7D, 0xD7, 0x13, 0xF3, 0x3F, 0xBA, 0x00, 0xBA, 0x86, 0xBF, 0x33, 0xFE, 0x82, 0x28,
  0x52, 0x8E, 0xF3, 0x26, 0x71, 0x06, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_bookmark_border() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_bookmark_border_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_bookmark 18x18, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_round_18_action_bookmark_data[] PROGMEM = {
  0x18, 0x04, 0x31, 0x05, 0xF9, 0x05, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x07, 0xF9, 0x00, 0x7F, 0x90,
  0x07, 0xF9, 0x00, 0x7F, 0x90, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x07, 0xF9, 0x00, 0x7B, 0x00, 0xAB,
  0x83, 0x74, 0xC7, 0x12, 0x82, 0x17, 0xC4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_bookmark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_action_bookmark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_bookmark_remove 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_action_bookmark_remove_data[] PROGMEM = {
  0x18, 0x01, 0x30, 0x15, 0x05, 0xD8, 0x51, 0x01, 0x11, 0x07, 0xC8, 0x1E, 0x06, 0xB0, 0x60, 0x7D,
  0x85, 0x10, 0x11, 0x10, 0x7D, 0x09, 0x50, 0x7E, 0x09, 0x01, 0x30, 0x7F, 0x90, 0x72, 0x07, 0xF9,
  0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xB0, 0x0A, 0xB0,
  0x72, 0x82, 0x4C, 0x71, 0x28, 0x21, 0x7C, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_bookmark_remove() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_bookmark_remove_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_bookmarks 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_bookmarks_data[] PROGMEM = {
  0x20, 0x28, 0x04, 0x30, 0x13, 0x09, 0xF9, 0x0E, 0x01, 0x28, 0x04, 0x18, 0x32, 0xF4, 0x05, 0x80,
  0x27, 0x06, 0x29, 0x00, 0x4F, 0x98, 0x37, 0x0F, 0x46, 0xF9, 0x83, 0x90, 0xF4, 0x6F, 0x98, 0x39,
  0x0F, 0x46, 0xF9, 0x83, 0x90, 0xF4, 0x6F, 0x98, 0x39, 0x0F, 0x46, 0xF9, 0x83, 0x90, 0xF4, 0x6F,
  0x98, 0x39, 0x0F, 0x46, 0xF9, 0x83, 0x90, 0xF4, 0x6F, 0x98, 0x39, 0x0F, 0x46, 0xF9, 0x83, 0x90,
  0xF4, 0x6A, 0x82, 0xE8, 0x7D, 0xA8, 0x59, 0x03, 0x11, 0x95, 0x48, 0x14, 0x93, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_bookmarks() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_bookmarks_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_book_online 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_book_online_data[] PROGMEM = {
  0x28, 0x04, 0x32, 0x01, 0x0E, 0xF9, 0x81, 0xE1, 0x3F, 0xB0, 0x03, 0xFB, 0x82, 0x33, 0xF9, 0x80,
  0x27, 0x84, 0x9F, 0x33, 0xF3, 0x68, 0x53, 0xF3, 0x3F, 0x3C, 0xC8, 0x5C, 0x3F, 0x33, 0xF3, 0xA0,
  0x0C, 0xA8, 0xB4, 0x3F, 0x33, 0xF3, 0xAF, 0xDD, 0xF9, 0x3F, 0x33, 0xF3, 0x8F, 0xDD, 0xF9, 0x3F,
  0x33, 0xF3, 0xA0, 0x0C, 0xA8, 0x53, 0xF3, 0x3F, 0x3C, 0xC8, 0x5C, 0x3F, 0x33, 0xF3, 0x68, 0x43,
  0xF3, 0x3F, 0x98, 0x02, 0x78, 0x29, 0xF3, 0x3F, 0xB0, 0x03, 0xFB, 0x81, 0x31, 0xEF, 0x90, 0xE0,
  0x12, 0x80, 0x43, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_book_online() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_action_book_online_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_book 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_action_book_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x38, 0x11, 0x02, 0xFB, 0x02, 0x06, 0xC8, 0x2A, 0x99, 0xBA, 0x00, 0x6C, 0x01,
  0x20, 0x4A, 0x00, 0x6C, 0x01, 0x20, 0x4A, 0x00, 0x6C, 0x01, 0x20, 0x4A, 0x00, 0x6C, 0x01, 0x20,
  0x4A, 0x00, 0x6C, 0x82, 0x7A, 0x99, 0xA0, 0x06, 0xFB, 0x00, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x6F,
  0xB0, 0x06, 0xFB, 0x00, 0x6F, 0xB0, 0x60, 0x2F, 0xB8, 0x12, 0x01, 0x80, 0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_book() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_book_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_browse_gallery 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_action_browse_gallery_data[] PROGMEM = {
  0x58, 0x13, 0x32, 0x75, 0x81, 0x19, 0xEB, 0x0D, 0x06, 0x28, 0x24, 0xE8, 0x13, 0x02, 0x0D, 0xF0,
  0xA2, 0x82, 0x6D, 0xD1, 0x20, 0xDB, 0x0D, 0x08, 0xC0, 0x72, 0x83, 0x1C, 0xD0, 0x7C, 0x09, 0x1C,
  0x0E, 0x01, 0x28, 0x21, 0xF6, 0xCC, 0x09, 0x1D, 0x06, 0x38, 0x19, 0xBE, 0xC8, 0x1A, 0x0D, 0xC0,
  0x83, 0x81, 0x6E, 0xEC, 0x82, 0xE3, 0x1D, 0xB0, 0x83, 0x81, 0x6E, 0xCD, 0x81, 0xE3, 0x4B, 0x06,
  0x38, 0x19, 0xB7, 0xE0, 0xE0, 0xDA, 0x0E, 0x01, 0x28, 0x31, 0xF6, 0x0D, 0xFA, 0x07, 0x28, 0x11,
  0xCD, 0x20, 0x20, 0xDF, 0x0A, 0x28, 0x26, 0xDD, 0x13, 0x81, 0x19, 0xEB, 0x0D, 0x06, 0x28, 0x24,
  0xE8, 0x17, 0x81, 0x33, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_browse_gallery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_action_browse_gallery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_bug_report 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_bug_report_data[] PROGMEM = {
  0x28, 0x13, 0xD3, 0x28, 0x13, 0xD3, 0x58, 0x4B, 0xE6, 0x6E, 0xB6, 0x07, 0xC0, 0x64, 0x03, 0x05,
  0xE8, 0x25, 0x30, 0x4F, 0xB8, 0xE0, 0x40, 0x1A, 0xFC, 0x22, 0xCF, 0xA1, 0x02, 0xBD, 0xFE, 0x88,
  0xEF, 0xDB, 0x21, 0x9D, 0xFD, 0x66, 0xDF, 0xD9, 0x10, 0x3A, 0xFD, 0x44, 0xDF, 0xA3, 0x04, 0xFB,
  0x04, 0x20, 0x10, 0xEC, 0x0E, 0x01, 0x50, 0x40, 0xDA, 0x0D, 0x04, 0x71, 0x00, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_bug_report() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_bug_report_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_build_circle 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_build_circle_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x50, 0x5F, 0x90, 0x53, 0x03, 0xB0, 0x0E,
  0xD0, 0x32, 0x0B, 0xB8, 0x18, 0x06, 0xC8, 0x1B, 0x01, 0xB8, 0x36, 0xF5, 0x0C, 0xC0, 0x10, 0x3B,
  0x10, 0x32, 0x0B, 0xC0, 0x03, 0xB0, 0x83, 0x05, 0xC0, 0x30, 0x1C, 0x83, 0xED, 0x30, 0x6B, 0x81,
  0x10, 0xBD, 0x81, 0xE3, 0x8A, 0x0B, 0x20, 0x3F, 0xB0, 0x33, 0x05, 0xF9, 0x05, 0x50, 0x30, 0xBC,
  0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_build_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_build_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_build 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_action_build_data[] PROGMEM = {
  0x48, 0x13, 0x31, 0x72, 0x0D, 0xB0, 0x97, 0x10, 0x40, 0xEB, 0x0B, 0x58, 0x3D, 0x40, 0x4E, 0xB0,
  0x43, 0x84, 0x3F, 0xE4, 0x1D, 0xB0, 0x83, 0x04, 0xA0, 0xE0, 0xDC, 0x09, 0x30, 0x1F, 0x90, 0x74,
  0x09, 0xF0, 0xD0, 0x24, 0x0B, 0xF0, 0xD0, 0x24, 0x83, 0x59, 0x97, 0xDB, 0x0D, 0x02, 0x70, 0x20,
  0xDB, 0x0B, 0x71, 0x02, 0x0D, 0xA0, 0xD7, 0x28, 0x22, 0xBC, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_build() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_build_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_cached 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_cached_data[] PROGMEM = {
  0x58, 0x22, 0x55, 0x27, 0x30, 0xEB, 0x0B, 0x02, 0x71, 0x01, 0x28, 0x24, 0xDE, 0x23, 0x01, 0x05,
  0x70, 0xD0, 0xB2, 0x82, 0x1D, 0xF7, 0x68, 0x34, 0xF2, 0x0A, 0xB0, 0x36, 0x90, 0x52, 0x05, 0x96,
  0x03, 0xB8, 0x3A, 0x02, 0xF4, 0x68, 0x27, 0xFC, 0x12, 0x0B, 0x0D, 0x70, 0x50, 0x13, 0x82, 0x2E,
  0xD4, 0x20, 0x17, 0x10, 0x20, 0xBB, 0x0E, 0x73, 0x82, 0x25, 0x42, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_cached() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_cached_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_calendar_month 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_calendar_month_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x48, 0x94, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x02, 0xFD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF2, 0x80, 0x41, 0x8B, 0x62, 0xF4, 0x4F,
  0x03, 0x40, 0x33, 0x04, 0x30, 0xF4, 0x4F, 0x05, 0x70, 0x66, 0x07, 0x50, 0xF4, 0x49, 0x73, 0x98,
  0xB6, 0x44, 0xF0, 0x57, 0x06, 0x60, 0x75, 0x0F, 0x44, 0xF0, 0x23, 0x03, 0x30, 0x32, 0x0F, 0x44,
  0xF2, 0x80, 0x41, 0x83, 0x2F, 0x41, 0xEF, 0xB8, 0x2E, 0x10, 0x18, 0x06, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_calendar_month() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_calendar_month_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_calendar_today 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_action_calendar_today_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x48, 0x94, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x02, 0xFD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF2, 0x80, 0x41, 0x82, 0x2F, 0x44, 0x97,
  0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x82,
  0x44, 0xF2, 0x80, 0x41, 0x83, 0x2F, 0x41, 0xEF, 0xB8, 0x2E, 0x10, 0x18, 0x06, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_calendar_today() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_calendar_today_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_calendar_view_day 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_action_calendar_view_day_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x27, 0x71, 0x06, 0x80, 0x69, 0x81, 0x60, 0x3F, 0xD0, 0x30,
  0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x04, 0x03, 0xFD, 0x81, 0x30, 0x68, 0x06,
  0x90, 0x67, 0x71, 0x02, 0xFD, 0x02, 0x18, 0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_calendar_view_day() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_calendar_view_day_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_calendar_view_month 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_action_calendar_view_month_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x22, 0x0D, 0x07, 0x20, 0x70, 0xD2,
  0x84, 0x2F, 0x33, 0xF2, 0x20, 0xD0, 0x72, 0x07, 0x0D, 0x28, 0x42, 0xF3, 0x3F, 0x22, 0x0D, 0x07,
  0x20, 0x70, 0xD2, 0x8C, 0x42, 0xF3, 0x3F, 0xA9, 0x9E, 0xC9, 0x9C, 0xE9, 0x9A, 0xF3, 0x3F, 0xA9,
  0x9E, 0xC9, 0x9C, 0xE9, 0x9A, 0xF3, 0x3F, 0x22, 0x0D, 0x07, 0x20, 0x70, 0xD2, 0x84, 0x2F, 0x33,
  0xF2, 0x20, 0xD0, 0x72, 0x07, 0x0D, 0x28, 0x42, 0xF3, 0x3F, 0x22, 0x0D, 0x07, 0x20, 0x70, 0xD2,
  0x82, 0x2F, 0x31, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_calendar_view_month() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_calendar_view_month_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_calendar_view_week 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_calendar_view_week_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0xA8, 0x01, 0x3F, 0x20, 0xE6, 0x0A, 0xA0, 0x6E,
  0x02, 0xF3, 0x3F, 0x20, 0xE6, 0x0A, 0xA0, 0x6E, 0x02, 0xF3, 0x3F, 0x20, 0xE6, 0x0A, 0xA0, 0x6E,
  0x02, 0xF3, 0x3F, 0x20, 0xE6, 0x0A, 0xA0, 0x6E, 0x02, 0xF3, 0x3F, 0x20, 0xE6, 0x0A, 0xA0, 0x6E,
  0x02, 0xF3, 0x3F, 0x20, 0xE6, 0x0A, 0xA0, 0x6E, 0x02, 0xF3, 0x3F, 0x20, 0xE6, 0x0A, 0xA0, 0x6E,
  0x02, 0xF3, 0x3F, 0x20, 0xE6, 0x0A, 0xA0, 0x6E, 0x02, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90,
  0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_calendar_view_week() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_calendar_view_week_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_camera_enhance 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_camera_enhance_data[] PROGMEM = {
  0x68, 0x00, 0x37, 0x40, 0xCC, 0x0C, 0x68, 0x24, 0x77, 0xAE, 0x84, 0xA7, 0x74, 0x01, 0xFF, 0x01,
  0x03, 0xE0, 0x0D, 0xE0, 0x03, 0xC0, 0xD0, 0x32, 0x03, 0x0D, 0xC0, 0x03, 0xC8, 0x43, 0x05, 0x50,
  0x3C, 0x00, 0x3B, 0x86, 0xE0, 0x6E, 0xE6, 0x0E, 0xB0, 0x03, 0xB8, 0x6E, 0x03, 0xCC, 0x30, 0xEB,
  0x00, 0x3C, 0x84, 0x50, 0x44, 0x05, 0xC0, 0x03, 0xC0, 0xE0, 0x62, 0x06, 0x0E, 0xC0, 0x03, 0xFF,
  0x81, 0x31, 0xEF, 0xD8, 0x2E, 0x10, 0x18, 0x09, 0x03, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_camera_enhance() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_camera_enhance_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_cancel_schedule_send 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_18_action_cancel_schedule_send_data[] PROGMEM = {
  0x82, 0x1E, 0x92, 0x77, 0x01, 0xB0, 0xB0, 0x47, 0x50, 0x1D, 0x0D, 0x06, 0x73, 0x01, 0xF8, 0x1E,
  0x81, 0x71, 0x0B, 0x0E, 0xF9, 0x0F, 0xB0, 0x66, 0x82, 0x26, 0x9D, 0xB8, 0x5A, 0x42, 0x49, 0xD2,
  0x48, 0x22, 0x69, 0xDA, 0x06, 0x58, 0x43, 0xD1, 0x0B, 0xED, 0x0A, 0x78, 0x17, 0x81, 0xF0, 0x52,
  0x86, 0xD4, 0xC2, 0x01, 0xD1, 0xD8, 0x1D, 0xE2, 0x28, 0x14, 0xF7, 0x30, 0xE0, 0x1B, 0x83, 0xB4,
  0x0A, 0x42, 0x89, 0x1C, 0x7D, 0x20, 0x1D, 0x1E, 0x92, 0x30, 0x60, 0x92, 0x81, 0x20, 0x22, 0x05,
  0x09, 0x71, 0x0D, 0x03, 0x58, 0x11, 0xD2, 0x71, 0x87, 0x2D, 0x71, 0x01, 0x6D, 0x47, 0x38, 0x51,
  0x8D, 0xED, 0x92, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_cancel_schedule_send() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_action_cancel_schedule_send_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_card_giftcard 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_action_card_giftcard_data[] PROGMEM = {
  0x50, 0x01, 0x20, 0x01, 0x72, 0x07, 0xA0, 0x06, 0xA0, 0x77, 0x18, 0x1E, 0x89, 0xA8, 0x19, 0x8E,
  0x58, 0x44, 0x77, 0xFB, 0xCA, 0x8B, 0x0C, 0xBF, 0x77, 0x40, 0x1F, 0xDD, 0xDD, 0xFD, 0xDF, 0xDD,
  0xDD, 0xF1, 0x3F, 0x22, 0x84, 0x6F, 0x33, 0xF6, 0x28, 0x90, 0x2F, 0x33, 0xF2, 0x02, 0xF7, 0x28,
  0x93, 0x7F, 0x20, 0x2F, 0x33, 0xF2, 0x01, 0x74, 0x87, 0x71, 0x02, 0xF3, 0x3F, 0x27, 0x38, 0x42,
  0xF3, 0x3F, 0x58, 0x06, 0x38, 0x25, 0xF3, 0x3F, 0xF8, 0x23, 0x3F, 0xA8, 0x06, 0x98, 0x4A, 0xF3,
  0x3F, 0x27, 0x38, 0x32, 0xF3, 0x1E, 0xFD, 0x82, 0xE1, 0x01, 0x80, 0x90, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_card_giftcard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_card_giftcard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_card_membership 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_card_membership_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x3E, 0x03, 0xF3, 0x80, 0x61, 0x84, 0x3F, 0x33, 0xF2, 0x73,
  0x84, 0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x82,
  0x2F, 0x33, 0x98, 0x09, 0x0D, 0x90, 0x03, 0x98, 0x09, 0x0D, 0x98, 0x23, 0x3F, 0x27, 0x38, 0x42,
  0xF3, 0x2F, 0xC8, 0x06, 0xB8, 0x7C, 0xF2, 0x05, 0x99, 0x9D, 0xC8, 0x3D, 0x99, 0x95, 0x60, 0xAC,
  0x0A, 0x73, 0x84, 0xAF, 0xBB, 0xFA, 0x73, 0x07, 0x06, 0x20, 0x60, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_card_membership() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_card_membership_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_card_travel 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_action_card_travel_data[] PROGMEM = {
  0x58, 0x42, 0x33, 0x33, 0x27, 0x20, 0x5E, 0x05, 0x71, 0x86, 0x9C, 0x11, 0x11, 0xC9, 0x58, 0xC3,
  0x47, 0x7C, 0xD7, 0x77, 0x7D, 0xC7, 0x74, 0x01, 0xFD, 0xDE, 0xFD, 0xDD, 0xDF, 0xED, 0xDF, 0x13,
  0xF2, 0x08, 0xA4, 0x87, 0xA8, 0x02, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42,
  0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x58, 0x06, 0x38, 0x25, 0xF3, 0x3F, 0xF8, 0x23, 0x3F,
  0xA8, 0x06, 0x98, 0x4A, 0xF3, 0x3F, 0x27, 0x38, 0x32, 0xF3, 0x1E, 0xFD, 0x82, 0xE1, 0x01, 0x80,
  0x90, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_card_travel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_card_travel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_change_history 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_action_change_history_data[] PROGMEM = {
  0x60, 0x09, 0x74, 0x04, 0xA0, 0x47, 0x38, 0x2D, 0xAA, 0xD7, 0x28, 0x49, 0xE1, 0x1E, 0x97, 0x81,
  0x4F, 0x52, 0x81, 0x5F, 0x46, 0x0D, 0x0A, 0x40, 0xA0, 0xD5, 0x81, 0x9E, 0x14, 0x81, 0x1E, 0x93,
  0x81, 0x4F, 0x56, 0x81, 0x5F, 0x42, 0x0D, 0x0A, 0x71, 0x82, 0xAD, 0x09, 0xFD, 0x08, 0x03, 0x80,
  0x90, 0x50, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_change_history() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_change_history_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_check_circle_outline 18x18, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_18_action_check_circle_outline_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x20, 0x0B, 0x70, 0x42, 0x00,
  0xB2, 0x90, 0x56, 0x89, 0x0A, 0xF1, 0x05, 0xF0, 0x2F, 0x32, 0x06, 0x28, 0x1A, 0xF4, 0x28, 0x93,
  0x3F, 0x22, 0xF3, 0x01, 0xEB, 0xAF, 0x43, 0x84, 0x3F, 0x20, 0xF5, 0x28, 0x23, 0xEF, 0x44, 0x05,
  0x92, 0x00, 0xB3, 0x01, 0x02, 0x50, 0x0B, 0x28, 0x13, 0xF5, 0x71, 0x81, 0x5F, 0x33, 0x81, 0x9F,
  0x56, 0x81, 0x5F, 0x95, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37,
  0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_check_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_check_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_check_circle 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_action_check_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBF, 0x90, 0xAB, 0x0B, 0x2F, 0x98, 0x15, 0x0D, 0xB1, 0x02, 0xC0, 0x9A, 0x81,
  0x50, 0xBC, 0x00, 0x2B, 0x84, 0xE0, 0x45, 0x0B, 0xD0, 0x21, 0xC0, 0xC2, 0x0B, 0xE2, 0x0B, 0xC0,
  0x0D, 0xE0, 0xB2, 0x03, 0xFD, 0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC,
  0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_check_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_check_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_chrome_reader_mode 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_action_chrome_reader_mode_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0x0A, 0x48, 0x22, 0xF3, 0x3F, 0x87,
  0xA0, 0xAB, 0x82, 0xF3, 0x3F, 0x87, 0xA0, 0x99, 0x72, 0xF3, 0x3F, 0x87, 0xA0, 0x99, 0x72, 0xF3,
  0x3F, 0x87, 0xA0, 0x99, 0x72, 0xF3, 0x3F, 0x87, 0xA0, 0x99, 0x72, 0xF3, 0x3F, 0x87, 0xA0, 0xAB,
  0x82, 0xF3, 0x3F, 0x0A, 0x48, 0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_chrome_reader_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_chrome_reader_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_circle_notifications 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_action_circle_notifications_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9C, 0x00, 0xCC, 0x09,
  0x30, 0x3C, 0x82, 0xD2, 0x2D, 0xC0, 0x32, 0x0B, 0xB0, 0xC4, 0x0C, 0xB0, 0xB2, 0xC0, 0x64, 0x06,
  0xC1, 0x02, 0xC0, 0x44, 0x04, 0xC0, 0x02, 0xC0, 0x44, 0x04, 0xC0, 0x21, 0xB0, 0xB0, 0x14, 0x01,
  0x0B, 0xB2, 0x0B, 0xA0, 0xB8, 0x02, 0x30, 0xBA, 0x0B, 0x20, 0x3D, 0x00, 0x9D, 0x03, 0x30, 0x9C,
  0x00, 0x7C, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_circle_notifications() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_circle_notifications_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_class 18x18, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_round_18_action_class_data[] PROGMEM = {
  0x02, 0x80, 0x67, 0x02, 0x0D, 0xFB, 0x81, 0xDF, 0x73, 0x0B, 0xF0, 0x73, 0x0B, 0xF0, 0x73, 0x0B,
  0xF0, 0x73, 0x0B, 0xF0, 0x73, 0x0B, 0xF8, 0x38, 0x9E, 0x7B, 0x80, 0x99, 0x2F, 0x0D, 0xFB, 0x0D,
  0x02, 0x80, 0x67, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_class() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_class_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_close_fullscreen 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_action_close_fullscreen_data[] PROGMEM = {
  0x77, 0x01, 0x77, 0x81, 0x8F, 0x17, 0x58, 0x18, 0xF8, 0x72, 0x84, 0xB7, 0x08, 0xF8, 0x73, 0xA8,
  0x1C, 0xF8, 0x74, 0xB0, 0xB7, 0x5C, 0x07, 0x74, 0x0D, 0xB0, 0xC6, 0x0C, 0xB0, 0xD7, 0x40, 0x7C,
  0x75, 0x0C, 0xB7, 0x48, 0x18, 0xFB, 0xA7, 0x38, 0x48, 0xF8, 0x07, 0xB7, 0x28, 0x18, 0xF8, 0x75,
  0x81, 0x1F, 0x87, 0x70, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_close_fullscreen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_close_fullscreen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_code_off 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_code_off_data[] PROGMEM = {
  0x0E, 0x07, 0x75, 0x81, 0x6F, 0x76, 0x01, 0x58, 0x16, 0xF7, 0x50, 0xD0, 0xA5, 0x81, 0xCF, 0x74,
  0x81, 0x3E, 0xA3, 0x83, 0xAE, 0x8F, 0x74, 0x89, 0x13, 0xEA, 0x09, 0xE3, 0x06, 0xF7, 0x48, 0x43,
  0xE9, 0x9E, 0x32, 0x81, 0x6F, 0x73, 0x85, 0x3E, 0x90, 0xAE, 0x32, 0x85, 0x6F, 0x70, 0x2E, 0xA3,
  0x81, 0xAE, 0x32, 0x83, 0x6F, 0x70, 0x65, 0x0A, 0x0D, 0x38, 0x16, 0xF7, 0x70, 0x14, 0x81, 0x6F,
  0x77, 0x58, 0x16, 0xF7, 0x75, 0x06, 0x0E, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_code_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_code_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_code 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_action_code_data[] PROGMEM = {
  0x40, 0x14, 0x01, 0x70, 0xA0, 0xD4, 0x0D, 0x0A, 0x58, 0x1A, 0xE3, 0x48, 0x13, 0xEA, 0x38, 0x1A,
  0xE3, 0x68, 0x53, 0xEA, 0x09, 0xE3, 0x71, 0x84, 0x3E, 0x88, 0xE3, 0x71, 0x85, 0x3E, 0x90, 0xAE,
  0x36, 0x81, 0x3E, 0xA3, 0x81, 0xAE, 0x34, 0x81, 0x3E, 0xA5, 0x0A, 0x0D, 0x40, 0xD0, 0xA7, 0x01,
  0x40, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_comment_bank 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_comment_bank_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xF8, 0x3E, 0x99, 0x9C, 0xA0, 0x03, 0xF0, 0xD3,
  0x07, 0xA0, 0x03, 0xF0, 0xD3, 0x07, 0xA0, 0x03, 0xF0, 0xD3, 0x07, 0xA0, 0x03, 0xF0, 0xD3, 0x07,
  0xA0, 0x03, 0xF8, 0x3E, 0x6B, 0x7B, 0xA0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F,
  0xF0, 0x10, 0x3A, 0x09, 0x80, 0x67, 0x83, 0x40, 0x3F, 0x77, 0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_comment_bank() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_comment_bank_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_commit 18x18, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_18_action_commit_data[] PROGMEM = {
  0x58, 0x23, 0x77, 0x37, 0x28, 0x47, 0xFD, 0xDF, 0x77, 0x81, 0x3F, 0x62, 0x81, 0x6F, 0x33, 0x0F,
  0x90, 0xC0, 0xD4, 0x0D, 0x0C, 0x80, 0x29, 0x0C, 0x0D, 0x40, 0xD0, 0xC0, 0xF9, 0x38, 0x13, 0xF6,
  0x28, 0x16, 0xF3, 0x78, 0x47, 0xFD, 0xDF, 0x77, 0x28, 0x23, 0x77, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_commit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_action_commit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_commute 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_commute_data[] PROGMEM = {
  0x28, 0x52, 0x55, 0x55, 0x41, 0x71, 0x0B, 0xF0, 0x66, 0x81, 0x2F, 0x78, 0x02, 0x50, 0x46, 0x81,
  0x3F, 0x24, 0x08, 0x80, 0x1B, 0x84, 0xA2, 0x03, 0xF2, 0x38, 0x93, 0x2F, 0xA9, 0x99, 0x9D, 0x90,
  0x3F, 0x23, 0x07, 0x0E, 0x58, 0x28, 0xD0, 0x3C, 0x04, 0x0B, 0xF9, 0x89, 0x12, 0x3F, 0x6A, 0xF4,
  0xCF, 0xBE, 0xA8, 0x94, 0xBE, 0xF3, 0x2F, 0xBD, 0xF4, 0xCF, 0x3C, 0xA8, 0x44, 0xBF, 0x30, 0x9B,
  0x04, 0x0C, 0xF9, 0x03, 0x20, 0x6A, 0x81, 0x4C, 0xB8, 0x01, 0x78, 0x18, 0xF2, 0x28, 0x44, 0x55,
  0x13, 0x16, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_commute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_commute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_compare_arrows 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_action_compare_arrows_data[] PROGMEM = {
  0x72, 0x02, 0x77, 0x09, 0x0C, 0x76, 0x08, 0xA8, 0x01, 0xD0, 0x17, 0x81, 0x3E, 0xD8, 0x01, 0x57,
  0x20, 0x30, 0x87, 0x50, 0x80, 0x37, 0x28, 0x01, 0x58, 0x1D, 0xE3, 0x70, 0x18, 0x01, 0xDA, 0x08,
  0x76, 0x0C, 0x09, 0x77, 0x02, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_compare_arrows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_compare_arrows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_compress 18x18, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_18_action_compress_data[] PROGMEM = {
  0x50, 0x09, 0x72, 0x82, 0x5C, 0xC5, 0x71, 0x0B, 0xA0, 0xB7, 0x20, 0x0B, 0x77, 0x30, 0x38, 0x06,
  0xB0, 0x30, 0x18, 0x06, 0x70, 0x01, 0x80, 0x67, 0x01, 0x03, 0x80, 0x6B, 0x03, 0x77, 0x30, 0x0B,
  0x72, 0x0B, 0xA0, 0xB7, 0x18, 0x25, 0xCC, 0x57, 0x20, 0x09, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_compress() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_compress_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_contactless 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_contactless_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x50, 0x5F, 0x90, 0x53, 0x03, 0xE0, 0xEB,
  0x03, 0x20, 0xBC, 0x82, 0xCF, 0x4C, 0xA8, 0x1B, 0x01, 0xB8, 0x4B, 0xF4, 0xC8, 0x7B, 0x01, 0x03,
  0xB8, 0x43, 0xD7, 0x9B, 0x5B, 0x00, 0x3B, 0x84, 0x3D, 0x79, 0xB5, 0xB0, 0x30, 0x1B, 0x84, 0xBF,
  0x4B, 0x87, 0xB8, 0x11, 0x0B, 0xC8, 0x2C, 0xF4, 0xCA, 0x0B, 0x20, 0x3E, 0x0E, 0xB0, 0x33, 0x05,
  0xF9, 0x05, 0x50, 0x30, 0xBC, 0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_contactless() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_contactless_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_contact_page 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_18_action_contact_page_data[] PROGMEM = {
  0x02, 0x80, 0x27, 0x04, 0x40, 0xDF, 0x07, 0x3F, 0xA0, 0x72, 0xFB, 0x07, 0x1F, 0xC0, 0x7F, 0xC0,
  0xED, 0x00, 0x9F, 0xA0, 0x92, 0x09, 0xF9, 0x09, 0x20, 0x9F, 0xA0, 0x09, 0xF9, 0x84, 0xE7, 0x44,
  0x7E, 0xE0, 0x34, 0x03, 0xE8, 0x02, 0x7F, 0xF9, 0x0D, 0xFB, 0x0D, 0x02, 0x80, 0x67, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_contact_page() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_contact_page_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_contact_support 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_contact_support_data[] PROGMEM = {
  0x60, 0x02, 0x72, 0x81, 0x2A, 0xEA, 0x81, 0xEA, 0x25, 0x04, 0x0E, 0xE0, 0xE0, 0x43, 0x02, 0x0E,
  0xA8, 0x2E, 0x98, 0xEA, 0x0E, 0x02, 0x20, 0xBB, 0x0F, 0x40, 0x3B, 0x81, 0xB0, 0x1C, 0x81, 0xDF,
  0xE1, 0xC0, 0x10, 0x3E, 0x04, 0x06, 0xC0, 0x30, 0x4D, 0x09, 0x03, 0xD0, 0x30, 0x1D, 0x00, 0xDD,
  0x81, 0x10, 0xCC, 0x00, 0x8C, 0x0B, 0x20, 0x4C, 0x00, 0x9C, 0x04, 0x30, 0x7F, 0x90, 0x95, 0x04,
  0x0D, 0xD0, 0x97, 0x10, 0x20, 0x5A, 0x08, 0x74, 0x0D, 0x04, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_contact_support() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_contact_support_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_copyright 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_18_action_copyright_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x52, 0x80, 0x01, 0x28, 0x15, 0xF3, 0x20, 0x0B, 0x20,
  0x2C, 0x02, 0x20, 0x0B, 0x29, 0x05, 0x28, 0x43, 0xF5, 0x4E, 0x22, 0x84, 0x5F, 0x02, 0xF3, 0x28,
  0x13, 0xF1, 0x58, 0x43, 0xF2, 0x2F, 0x32, 0x81, 0x3F, 0x15, 0x84, 0x3F, 0x20, 0xF5, 0x28, 0x43,
  0xF5, 0x4E, 0x22, 0x05, 0x92, 0x00, 0xB2, 0x02, 0xC0, 0x22, 0x00, 0xB2, 0x81, 0x3F, 0x52, 0x80,
  0x01, 0x28, 0x15, 0xF3, 0x38, 0x19, 0xF5, 0x68, 0x15, 0xF9, 0x58, 0x90, 0x9F, 0xB5, 0x33, 0x5B,
  0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_copyright() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_copyright_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_credit_card_off 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_action_credit_card_off_data[] PROGMEM = {
  0x05, 0x06, 0x77, 0x83, 0x5F, 0x70, 0x18, 0x05, 0x58, 0x13, 0x01, 0xA8, 0x17, 0x09, 0xFA, 0x01,
  0x03, 0xB8, 0x17, 0x09, 0xF9, 0x85, 0x33, 0xF5, 0x7F, 0x71, 0x80, 0x23, 0x89, 0x05, 0xF3, 0x3F,
  0x20, 0x6F, 0x76, 0x84, 0x2F, 0x33, 0xF2, 0x28, 0x16, 0xF7, 0x58, 0x22, 0xF3, 0x3F, 0x81, 0x70,
  0x9C, 0x00, 0x3F, 0x98, 0x17, 0x09, 0xB0, 0x03, 0xFA, 0x81, 0x70, 0x9A, 0x00, 0x3F, 0xB8, 0x47,
  0x09, 0xF3, 0x1F, 0xC8, 0x47, 0x08, 0x10, 0x38, 0x05, 0x58, 0x17, 0xF7, 0x77, 0x81, 0x6F, 0x67,
  0x70, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_credit_card_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_credit_card_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_credit_card 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_action_credit_card_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0xC8,
  0x06, 0xB8, 0x2C, 0xF3, 0x3F, 0xF0, 0x03, 0xFF, 0x82, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2,
  0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x82, 0x2F, 0x31, 0xFF, 0x81,
  0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_credit_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_credit_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_css 18x18, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_round_18_action_css_data[] PROGMEM = {
  0x8D, 0x64, 0xBB, 0x23, 0xBB, 0x32, 0xBB, 0x46, 0x82, 0x05, 0xB6, 0x14, 0xB6, 0x16, 0x82, 0x01,
  0x6B, 0x51, 0x6A, 0x64, 0xBB, 0x23, 0xBB, 0x32, 0xBB, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_css() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 14, 10), Box(0, 0, 17, 17),
      ic_round_18_action_css_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_currency_exchange 18x18, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_round_18_action_currency_exchange_data[] PROGMEM = {
  0x58, 0x14, 0xAE, 0xA8, 0x1E, 0xA3, 0x71, 0x89, 0x41, 0xAF, 0xB6, 0x44, 0x7C, 0xFA, 0x11, 0x93,
  0x82, 0x1C, 0xD3, 0x68, 0x44, 0xEC, 0x4F, 0x12, 0x81, 0xAD, 0x13, 0x00, 0x73, 0x87, 0x1E, 0xDF,
  0x10, 0x4F, 0x43, 0x09, 0xA8, 0x3A, 0x01, 0x9C, 0xA8, 0x21, 0x0A, 0xB3, 0x89, 0x15, 0xE3, 0x2A,
  0x12, 0xBB, 0xB9, 0x20, 0xE0, 0x63, 0x81, 0x6E, 0x17, 0x30, 0xD0, 0x34, 0x82, 0xBF, 0xA3, 0x77,
  0x18, 0x23, 0xAF, 0x43, 0x03, 0x0D, 0x70, 0x01, 0x20, 0x90, 0xA3, 0x06, 0x0E, 0x28, 0x91, 0x9B,
  0xBB, 0x27, 0xD3, 0x1C, 0x83, 0x82, 0xBA, 0x01, 0xA8, 0x3C, 0x91, 0x0A, 0xA0, 0xB0, 0x12, 0x87,
  0x4F, 0x40, 0x1F, 0xDE, 0x13, 0x00, 0x73, 0x81, 0x1D, 0xA2, 0x84, 0x1F, 0x4C, 0xD4, 0x68, 0x23,
  0xDC, 0x13, 0x89, 0x49, 0x11, 0xAF, 0xC7, 0x44, 0x6B, 0xFA, 0x17, 0x18, 0x13, 0xAE, 0xA8, 0x1E,
  0xA4, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_currency_exchange() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_currency_exchange_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_dangerous 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_action_dangerous_data[] PROGMEM = {
  0x48, 0x42, 0x33, 0x33, 0x27, 0x06, 0xE0, 0x65, 0x06, 0xF9, 0x06, 0x30, 0x6F, 0xB8, 0x16, 0x02,
  0xB0, 0xA0, 0x9A, 0x09, 0x0A, 0xB0, 0x20, 0x4B, 0x84, 0x90, 0x88, 0x09, 0xB0, 0x04, 0xC0, 0x82,
  0x08, 0xC0, 0x04, 0xC0, 0x82, 0x08, 0xC0, 0x04, 0xB8, 0x49, 0x08, 0x80, 0x9B, 0x04, 0x02, 0xB0,
  0xA0, 0x9A, 0x09, 0x0A, 0xB8, 0x12, 0x06, 0xFB, 0x06, 0x30, 0x6F, 0x90, 0x65, 0x06, 0xE0, 0x67,
  0x84, 0x23, 0x33, 0x32, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_dangerous() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_dangerous_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_dashboard_customize 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_dashboard_customize_data[] PROGMEM = {
  0x18, 0x00, 0x30, 0x22, 0x85, 0x23, 0x33, 0x30, 0x3D, 0x2D, 0x03, 0x04, 0xD0, 0x01, 0xD0, 0x04,
  0xD0, 0x01, 0xD0, 0x04, 0xD0, 0x01, 0xD0, 0x40, 0x2C, 0x0E, 0x20, 0xEC, 0x02, 0x20, 0xF1, 0x40,
  0xF1, 0x40, 0xF1, 0x72, 0x02, 0xC0, 0xE4, 0x0E, 0x03, 0x20, 0x4D, 0x01, 0x28, 0x42, 0xF5, 0x10,
  0x4D, 0x81, 0x10, 0xEC, 0x02, 0x04, 0xD8, 0x71, 0x03, 0x4F, 0x73, 0x03, 0xD4, 0x90, 0x33, 0x80,
  0x03, 0x02, 0x40, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_dashboard_customize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_dashboard_customize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_dashboard 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_dashboard_data[] PROGMEM = {
  0x18, 0x00, 0x30, 0x22, 0x85, 0x23, 0x33, 0x30, 0x3D, 0x2D, 0x03, 0x04, 0xD0, 0x01, 0xD0, 0x04,
  0xD0, 0x11, 0xD0, 0x30, 0x4D, 0x87, 0x10, 0x23, 0x33, 0x30, 0x4D, 0x01, 0x70, 0x4D, 0x89, 0x61,
  0x0B, 0xDD, 0xDC, 0x11, 0xCD, 0xDD, 0xB0, 0x1D, 0x04, 0x70, 0x1D, 0x87, 0x40, 0x33, 0x33, 0x20,
  0x1D, 0x04, 0x03, 0xD1, 0x01, 0xD0, 0x04, 0xD0, 0x01, 0xD0, 0x40, 0x3D, 0x2D, 0x85, 0x30, 0x33,
  0x33, 0x22, 0x02, 0x80, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_dashboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_dashboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_data_exploration 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_data_exploration_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBF, 0x84, 0x53, 0x4C, 0xFB, 0x2F, 0x90, 0x62, 0x07, 0xA1, 0x02, 0xB0, 0xC0,
  0x7B, 0x05, 0x20, 0x7A, 0x00, 0x2A, 0x89, 0x0C, 0x10, 0x4E, 0x50, 0xB5, 0xAA, 0x89, 0x13, 0x0F,
  0xC1, 0x3B, 0x01, 0x0B, 0xD8, 0x90, 0x30, 0x81, 0x3E, 0xFC, 0x3B, 0xE0, 0x32, 0x03, 0x0E, 0xFC,
  0x03, 0x20, 0x8F, 0xB8, 0x1C, 0xF3, 0x30, 0x8F, 0x98, 0x2D, 0x1F, 0x34, 0x03, 0x0A, 0xF9, 0x0E,
  0x71, 0x02, 0x80, 0x23, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_data_exploration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_data_exploration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_data_thresholding 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_data_thresholding_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0x90, 0xD0, 0xEA, 0x00,
  0x4C, 0x84, 0xEA, 0xFB, 0x08, 0xA0, 0x04, 0xB8, 0x4E, 0x20, 0x50, 0x5B, 0x00, 0x4A, 0x84, 0xE2,
  0x27, 0x05, 0xC0, 0x04, 0xA8, 0x39, 0x2D, 0xFB, 0xD0, 0x04, 0xFD, 0x8D, 0x24, 0x4F, 0xCF, 0xCF,
  0xDE, 0xDD, 0xEC, 0xF4, 0x4F, 0xB7, 0x8A, 0x5D, 0x4D, 0x4C, 0xF4, 0x4F, 0x78, 0xA5, 0xD4, 0xD4,
  0xC7, 0xF4, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_data_thresholding() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_data_thresholding_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_date_range 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_date_range_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x48, 0x94, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x02, 0xFD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF2, 0x80, 0x41, 0x8B, 0x62, 0xF4, 0x4F,
  0x06, 0x90, 0x88, 0x09, 0x60, 0xF4, 0x4F, 0x01, 0x20, 0x11, 0x02, 0x10, 0xF4, 0x49, 0x73, 0x90,
  0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x98, 0x24, 0x4F, 0x28, 0x04, 0x18, 0x32, 0xF4, 0x1E, 0xFB,
  0x82, 0xE1, 0x01, 0x80, 0x63, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_date_range() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_date_range_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_delete_forever 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_action_delete_forever_data[] PROGMEM = {
  0x48, 0x00, 0x35, 0x81, 0x55, 0x9C, 0x83, 0x95, 0x50, 0x3F, 0xB0, 0x31, 0x80, 0x61, 0x20, 0x7F,
  0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7A, 0x82, 0x7E, 0xE7, 0xA0, 0x72, 0x89, 0x07, 0xFE, 0x13,
  0x31, 0xEF, 0x72, 0x07, 0xA0, 0xC2, 0x0C, 0xA0, 0x72, 0x07, 0xA8, 0x23, 0x11, 0x3A, 0x07, 0x28,
  0x90, 0x7F, 0xE5, 0xDD, 0x5E, 0xF7, 0x20, 0x7F, 0x90, 0x72, 0x05, 0xF9, 0x05, 0x38, 0x04, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_delete_forever() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_delete_forever_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_delete_outline 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_delete_outline_data[] PROGMEM = {
  0x38, 0x42, 0xBB, 0xBB, 0x23, 0x01, 0x0E, 0xF9, 0x82, 0xE1, 0x06, 0x80, 0x47, 0x06, 0x30, 0x98,
  0x02, 0xB0, 0x93, 0x89, 0x06, 0xFD, 0xBB, 0xBB, 0xDF, 0x62, 0x07, 0x96, 0x90, 0x72, 0x07, 0x96,
  0x90, 0x72, 0x07, 0x96, 0x90, 0x72, 0x07, 0x96, 0x90, 0x72, 0x07, 0x96, 0x90, 0x72, 0x07, 0x96,
  0x90, 0x72, 0x07, 0x96, 0x90, 0x72, 0x89, 0x06, 0xFD, 0xBB, 0xBB, 0xDF, 0x63, 0x09, 0x80, 0x2B,
  0x09, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_delete_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_delete_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_delete 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_round_18_action_delete_data[] PROGMEM = {
  0x48, 0x00, 0x35, 0x81, 0x55, 0x9C, 0x83, 0x95, 0x50, 0x3F, 0xB0, 0x31, 0x80, 0x61, 0x20, 0x7F,
  0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72,
  0x07, 0xF9, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x5F, 0x90, 0x53, 0x80, 0x43,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_delete() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_delete_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_density_large 18x18, 4-bit Alpha,  RLE, 16 bytes.
static const unsigned char ic_round_18_action_density_large_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x28, 0x0A, 0x90, 0x00, 0x2F, 0xD0, 0x21, 0x80, 0x90, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_density_large() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_density_large_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_density_medium 18x18, 4-bit Alpha,  RLE, 27 bytes.
static const unsigned char ic_round_18_action_density_medium_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x28, 0x0E, 0x40, 0x01, 0x80, 0x90, 0x90, 0x01, 0x80, 0x90,
  0x90, 0x18, 0x0E, 0x40, 0x02, 0xFD, 0x02, 0x18, 0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_density_medium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_density_medium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_density_small 18x18, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_18_action_density_small_data[] PROGMEM = {
  0x01, 0x80, 0x90, 0xB0, 0x01, 0x80, 0x90, 0x90, 0x17, 0x77, 0x70, 0x10, 0xA8, 0x06, 0xB8, 0x1A,
  0x11, 0x80, 0x90, 0x90, 0x17, 0x77, 0x70, 0x18, 0x09, 0x09, 0x81, 0x11, 0xA8, 0x06, 0xB0, 0xA0,
  0x17, 0x77, 0x70, 0x18, 0x09, 0x09, 0x00, 0x18, 0x09, 0x0B, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_density_small() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_density_small_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_description 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_description_data[] PROGMEM = {
  0x10, 0x18, 0x01, 0x30, 0x24, 0x02, 0xF0, 0x73, 0x06, 0xD8, 0x2D, 0x4F, 0x72, 0x06, 0xD8, 0x5D,
  0x04, 0xF7, 0x06, 0xD0, 0xE2, 0x82, 0x4F, 0x46, 0xE8, 0x4D, 0xBB, 0xE6, 0x6F, 0xB0, 0x06, 0xFB,
  0x00, 0x6A, 0x84, 0xB7, 0x77, 0x7B, 0xA0, 0x06, 0xA8, 0x49, 0x33, 0x33, 0x9A, 0x00, 0x6F, 0xB0,
  0x06, 0xA8, 0x48, 0x11, 0x11, 0x8A, 0x00, 0x6A, 0x84, 0xC7, 0x77, 0x7C, 0xA0, 0x06, 0xFB, 0x06,
  0x02, 0xFB, 0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_description() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_description_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_disabled_by_default 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_disabled_by_default_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD0, 0xA0, 0xBF, 0xD0, 0x0B, 0xA0, 0xE0, 0xAC, 0x0A,
  0x0E, 0xA0, 0x0B, 0xA8, 0x1A, 0x06, 0xA8, 0x16, 0x0A, 0xA0, 0x0B, 0xB8, 0x46, 0x06, 0x60, 0x6B,
  0x00, 0xBC, 0x06, 0x20, 0x6C, 0x00, 0xBC, 0x06, 0x20, 0x6C, 0x00, 0xBB, 0x84, 0x60, 0x66, 0x06,
  0xB0, 0x0B, 0xA8, 0x1A, 0x06, 0xA8, 0x16, 0x0A, 0xA0, 0x0B, 0xA0, 0xE0, 0xAC, 0x0A, 0x0E, 0xA0,
  0x0B, 0xFD, 0x0B, 0x0A, 0xFD, 0x81, 0xA2, 0xA8, 0x06, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_disabled_by_default() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_disabled_by_default_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_disabled_visible 18x18, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_round_18_action_disabled_visible_data[] PROGMEM = {
  0x70, 0x02, 0x75, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x18, 0x90, 0x9F, 0xB5, 0x33, 0x5B, 0xF9, 0x68,
  0x19, 0xFA, 0x68, 0x15, 0xE9, 0x48, 0x33, 0xFA, 0xF7, 0x68, 0x15, 0xF3, 0x38, 0x4B, 0xB0, 0x7F,
  0x76, 0x00, 0xB3, 0x90, 0x52, 0x81, 0x7F, 0x75, 0x05, 0x92, 0x81, 0x2F, 0x33, 0x81, 0x7F, 0x74,
  0x85, 0x2F, 0x20, 0x2F, 0x34, 0x06, 0x05, 0x50, 0x13, 0x90, 0x65, 0x81, 0x19, 0xEA, 0x0C, 0x06,
  0x30, 0xB0, 0xC4, 0x89, 0x43, 0xEF, 0xC5, 0x6E, 0xFB, 0x10, 0x4F, 0x52, 0x01, 0x0E, 0xA8, 0x24,
  0xEB, 0x7A, 0x09, 0x28, 0x49, 0xF5, 0x01, 0xEA, 0x82, 0x4F, 0xC7, 0xA0, 0xB3, 0x89, 0x49, 0xFB,
  0x05, 0xEF, 0xB4, 0x5E, 0xFC, 0x14, 0x84, 0x4B, 0xB0, 0x3A, 0xB0, 0xE0, 0x87, 0x60, 0x20, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_disabled_visible() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_disabled_visible_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_display_settings 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_action_display_settings_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x27, 0x89, 0x02, 0x50, 0x2F, 0x33, 0xF2, 0x58, 0x01, 0xA8, 0x91, 0x84, 0xD5, 0x2F, 0x33, 0xF2,
  0x18, 0x01, 0x38, 0x93, 0x24, 0xA1, 0x2F, 0x33, 0xF2, 0x08, 0x45, 0x89, 0x21, 0x02, 0xF3, 0x3F,
  0x26, 0xE4, 0xB8, 0x01, 0xD8, 0x90, 0x72, 0xF3, 0x3F, 0x20, 0x73, 0x78, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x22, 0xF3, 0x19, 0x80, 0x90, 0xD9, 0x85, 0x10, 0x47, 0x77, 0xDC, 0x83, 0xD7, 0x77, 0x46,
  0x0A, 0xC0, 0xA7, 0x38, 0x42, 0x33, 0x33, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_display_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_display_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_dns 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_action_dns_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x3F, 0xD0, 0x30, 0x4F, 0xD0, 0x04, 0xA0, 0x20, 0x6F, 0x90, 0x04, 0xA0,
  0x60, 0xAF, 0x90, 0x04, 0xFD, 0x81, 0x42, 0xEF, 0xB0, 0xE0, 0x22, 0x80, 0x61, 0x20, 0x2F, 0xD0,
  0x20, 0x4F, 0xD0, 0x04, 0xA0, 0x50, 0x9F, 0x90, 0x04, 0xA0, 0x30, 0x8F, 0x90, 0x04, 0xFD, 0x04,
  0x03, 0xFD, 0x81, 0x30, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_dns() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_dns_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_done_all 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_action_done_all_data[] PROGMEM = {
  0x71, 0x03, 0x02, 0x20, 0x40, 0x17, 0x85, 0x5F, 0x60, 0x7F, 0x36, 0x85, 0x4F, 0x90, 0x7F, 0x62,
  0x02, 0x38, 0x51, 0x17, 0x07, 0xF6, 0x28, 0x91, 0x4F, 0x50, 0x7E, 0x30, 0x7F, 0x64, 0x87, 0x9F,
  0x50, 0xBE, 0x9F, 0x66, 0x85, 0x9F, 0x30, 0xBF, 0x67, 0x10, 0x13, 0x01, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_done_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_action_done_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_done_outline 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_action_done_outline_data[] PROGMEM = {
  0x72, 0x82, 0x4E, 0xB1, 0x72, 0x83, 0x4F, 0xAD, 0xC7, 0x18, 0x54, 0xF9, 0x08, 0xF1, 0x28, 0x91,
  0x8B, 0x20, 0x4F, 0x90, 0x6F, 0x72, 0x89, 0x1A, 0xEC, 0xE6, 0xF9, 0x06, 0xF7, 0x28, 0x91, 0x1F,
  0x70, 0xCF, 0x90, 0x6F, 0x74, 0x87, 0x9F, 0x40, 0x70, 0x6F, 0x76, 0x85, 0x9F, 0x40, 0x6F, 0x77,
  0x18, 0x39, 0xF9, 0xF7, 0x73, 0x81, 0x9F, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_done_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_done_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_done 18x18, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_round_18_action_done_data[] PROGMEM = {
  0x71, 0x03, 0x01, 0x78, 0x15, 0xF5, 0x68, 0x15, 0xF8, 0x20, 0x13, 0x81, 0x5F, 0x82, 0x85, 0x5E,
  0x30, 0x5F, 0x84, 0x83, 0xBE, 0x7F, 0x86, 0x81, 0xBF, 0x87, 0x10, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_done() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 13, 12), Box(0, 0, 17, 17),
      ic_round_18_action_done_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_donut_large 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_action_donut_large_data[] PROGMEM = {
  0x48, 0x63, 0xBF, 0x54, 0xFB, 0x46, 0x08, 0xA8, 0x2D, 0x33, 0xDA, 0x09, 0x48, 0x28, 0xFE, 0x44,
  0x82, 0x4D, 0xF9, 0x28, 0x23, 0xFD, 0x16, 0x86, 0x1D, 0xF4, 0x0B, 0xF5, 0x71, 0x84, 0x3F, 0xB0,
  0xFD, 0x73, 0x83, 0xDF, 0x2F, 0xB7, 0x38, 0x33, 0x52, 0xFB, 0x73, 0x83, 0x35, 0x0F, 0xD7, 0x38,
  0x4D, 0xF0, 0xBF, 0x47, 0x18, 0x63, 0xFB, 0x03, 0xFD, 0x16, 0x82, 0x1D, 0xF4, 0x28, 0x28, 0xFE,
  0x44, 0x82, 0x4D, 0xF9, 0x40, 0x8A, 0x82, 0xD3, 0x3D, 0xA0, 0x96, 0x86, 0x3B, 0xF5, 0x4F, 0xB4,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_donut_large() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_donut_large_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_donut_small 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_donut_small_data[] PROGMEM = {
  0x48, 0x63, 0xBF, 0x54, 0xFB, 0x46, 0x08, 0xB0, 0x50, 0x4B, 0x09, 0x40, 0x8C, 0x05, 0x04, 0xC0,
  0x92, 0x03, 0xD0, 0x50, 0x4D, 0x81, 0x40, 0xBD, 0x05, 0x04, 0xD0, 0xB1, 0xD0, 0x62, 0x06, 0xD0,
  0x2C, 0x0D, 0x48, 0x01, 0x50, 0x2C, 0x0D, 0x48, 0x01, 0x51, 0xD0, 0x62, 0x06, 0xD1, 0x0B, 0xD0,
  0x50, 0x4D, 0x81, 0xB0, 0x3D, 0x05, 0x04, 0xD0, 0x42, 0x08, 0xC0, 0x50, 0x4C, 0x09, 0x40, 0x8B,
  0x05, 0x04, 0xB0, 0x96, 0x86, 0x3B, 0xF5, 0x4F, 0xB4, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_donut_small() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_donut_small_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_drag_indicator 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_action_drag_indicator_data[] PROGMEM = {
  0x10, 0x50, 0x22, 0x84, 0x25, 0x07, 0xFE, 0x28, 0x4E, 0xF7, 0x6F, 0xD2, 0x84, 0xDF, 0x60, 0x31,
  0x20, 0x10, 0x32, 0x04, 0x01, 0x28, 0x41, 0x40, 0x6F, 0xE2, 0x84, 0xEF, 0x66, 0xFE, 0x28, 0x4E,
  0xF6, 0x04, 0x12, 0x01, 0x04, 0x20, 0x30, 0x12, 0x84, 0x13, 0x06, 0xFD, 0x28, 0x4D, 0xF6, 0x7F,
  0xE2, 0x84, 0xEF, 0x70, 0x52, 0x20, 0x20, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_drag_indicator() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 12, 14), Box(0, 0, 17, 17),
      ic_round_18_action_drag_indicator_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_dynamic_form 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_dynamic_form_data[] PROGMEM = {
  0x02, 0x0D, 0xE8, 0x1B, 0x0B, 0xC0, 0x30, 0x7F, 0x81, 0xB0, 0xBB, 0x84, 0xD0, 0x7F, 0xB7, 0xC8,
  0x1B, 0x0B, 0xB8, 0x17, 0x07, 0xA0, 0xEC, 0x81, 0xB0, 0xBB, 0x81, 0x50, 0x3F, 0x81, 0xB0, 0xBC,
  0x81, 0x20, 0x18, 0x02, 0x38, 0x22, 0x02, 0x6A, 0x0A, 0x20, 0x18, 0x04, 0x30, 0x10, 0x3A, 0x81,
  0x30, 0x3F, 0xA8, 0x23, 0x3F, 0xC2, 0x07, 0xA0, 0xEE, 0x82, 0x33, 0xF5, 0x28, 0x27, 0xFB, 0x7E,
  0x81, 0x33, 0xD3, 0x07, 0xFA, 0x81, 0x31, 0x43, 0x02, 0x0D, 0xF9, 0x03, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_dynamic_form() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_dynamic_form_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_eco 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_action_eco_data[] PROGMEM = {
  0x72, 0x81, 0x24, 0x15, 0x81, 0x59, 0xCB, 0x03, 0x20, 0x10, 0x8F, 0x82, 0x20, 0x2E, 0xF9, 0x20,
  0xCF, 0x98, 0x1C, 0x03, 0xC0, 0xA0, 0xEB, 0x81, 0x90, 0x6B, 0x07, 0x0B, 0xC8, 0x15, 0x04, 0xA0,
  0x70, 0x6D, 0x28, 0x31, 0xFB, 0x0E, 0xC0, 0x83, 0x81, 0x73, 0x5C, 0x0D, 0x01, 0x50, 0x9B, 0x0C,
  0x02, 0x68, 0x21, 0x55, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_eco() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_eco_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_edit_calendar 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_action_edit_calendar_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x58, 0x92, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x20, 0x2F, 0xD8,
  0x12, 0x04, 0xFD, 0x81, 0x40, 0x4F, 0xD8, 0x14, 0x04, 0xFD, 0x83, 0x40, 0x4F, 0x28, 0x04, 0x18,
  0x32, 0xF4, 0x04, 0x97, 0x60, 0x49, 0x73, 0x82, 0x2A, 0x24, 0x97, 0x28, 0x32, 0x3E, 0xA4, 0x97,
  0x18, 0x42, 0xEC, 0x32, 0x49, 0x78, 0xA1, 0x2E, 0xFE, 0x20, 0x4F, 0x21, 0x11, 0x10, 0x2E, 0xFE,
  0x22, 0x01, 0x0E, 0xC8, 0x48, 0x0E, 0xFE, 0x24, 0x89, 0x01, 0x33, 0x33, 0x21, 0xFE, 0x27, 0x50,
  0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_edit_calendar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_edit_calendar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_edit_off 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_edit_off_data[] PROGMEM = {
  0x73, 0x00, 0x12, 0x0E, 0x07, 0x78, 0x63, 0xEE, 0x30, 0x6F, 0x76, 0x87, 0x1D, 0xFE, 0x10, 0x6F,
  0x73, 0x85, 0x3D, 0x21, 0xDE, 0x12, 0x89, 0x16, 0xF7, 0x02, 0xEF, 0xE2, 0x13, 0x48, 0x36, 0xF7,
  0x09, 0xA0, 0xD7, 0x85, 0x8F, 0x70, 0x9E, 0x36, 0x03, 0x0E, 0xA8, 0x17, 0x02, 0x60, 0x30, 0xEC,
  0x07, 0x60, 0x30, 0xEB, 0x82, 0xE8, 0xF7, 0x40, 0x20, 0xEB, 0x84, 0xE3, 0x06, 0xF7, 0x30, 0x4B,
  0x0E, 0x03, 0x38, 0x16, 0xF7, 0x20, 0x4A, 0x0E, 0x03, 0x58, 0x16, 0xF7, 0x28, 0x13, 0x32, 0x70,
  0x60, 0xE1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_edit_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_edit_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_eject 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_round_18_action_eject_data[] PROGMEM = {
  0x40, 0x0A, 0x70, 0x5A, 0x05, 0x50, 0x10, 0xEA, 0x0E, 0x01, 0x40, 0xAC, 0x0A, 0x30, 0x5E, 0x05,
  0x20, 0x88, 0x02, 0xB0, 0x87, 0x40, 0x48, 0x04, 0xD0, 0x40, 0x18, 0x04, 0x70, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_eject() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_action_eject_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_euro_symbol 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_euro_symbol_data[] PROGMEM = {
  0x78, 0x11, 0x33, 0x71, 0x04, 0x0C, 0xC0, 0xA0, 0x14, 0x87, 0x7F, 0xA4, 0x12, 0x6D, 0xD3, 0x81,
  0x5F, 0x56, 0x89, 0x02, 0x03, 0x3D, 0xB3, 0x33, 0x14, 0x02, 0xF0, 0xA5, 0x81, 0x18, 0xD8, 0x00,
  0x15, 0x87, 0x17, 0xBE, 0x77, 0x77, 0x44, 0x87, 0x2B, 0xCF, 0xCB, 0xBB, 0x77, 0x0D, 0x09, 0x74,
  0x81, 0x5F, 0x66, 0x02, 0x48, 0x77, 0xFA, 0x41, 0x26, 0xDD, 0x50, 0x40, 0xCC, 0x0A, 0x01, 0x78,
  0x11, 0x33, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_euro_symbol() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_euro_symbol_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_event 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_event_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x48, 0x94, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x02, 0xFD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF2, 0x80, 0x41, 0x82, 0x2F, 0x44, 0x95,
  0x0F, 0x12, 0x90, 0x04, 0x95, 0xB8, 0x38, 0x0F, 0x44, 0x95, 0xB8, 0x39, 0x0F, 0x44, 0x95, 0xB8,
  0x39, 0x0F, 0x44, 0x95, 0x89, 0x06, 0x77, 0x30, 0xF4, 0x4F, 0x28, 0x04, 0x18, 0x32, 0xF4, 0x1E,
  0xFB, 0x82, 0xE1, 0x01, 0x80, 0x63, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_event() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_event_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_event_repeat 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_action_event_repeat_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x68, 0x92, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x30, 0x2F, 0xD0,
  0x22, 0x04, 0xFD, 0x04, 0x20, 0x4F, 0xD0, 0x42, 0x04, 0xFD, 0x04, 0x28, 0x14, 0xF2, 0x80, 0x41,
  0x81, 0x2F, 0x42, 0x04, 0x97, 0x30, 0x70, 0x22, 0x04, 0x97, 0x82, 0x10, 0x12, 0x30, 0x49, 0x68,
  0x72, 0xB9, 0xDB, 0xD6, 0x04, 0x96, 0x82, 0x3F, 0xD2, 0x28, 0x1B, 0x54, 0x97, 0x81, 0x77, 0x32,
  0x83, 0x1C, 0x4F, 0x28, 0x00, 0x17, 0x18, 0x1D, 0x1E, 0xD8, 0x16, 0x0D, 0x48, 0x23, 0xB0, 0x18,
  0x01, 0x38, 0x71, 0x07, 0xB1, 0x03, 0xC3, 0x73, 0x83, 0x6D, 0xEB, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_event_repeat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_action_event_repeat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_event_seat 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_action_event_seat_data[] PROGMEM = {
  0x48, 0x02, 0x37, 0x06, 0xE0, 0x66, 0x09, 0xE0, 0x96, 0x09, 0xE0, 0x96, 0x09, 0xE0, 0x96, 0x09,
  0xE0, 0x93, 0x82, 0x1C, 0x39, 0xE8, 0x69, 0x3C, 0x11, 0xC3, 0x88, 0x02, 0xD8, 0x28, 0x3C, 0x12,
  0x01, 0x80, 0x43, 0x01, 0x30, 0x2F, 0xB0, 0x22, 0x06, 0x0E, 0x80, 0x41, 0x0E, 0x06, 0x20, 0x60,
  0xE7, 0x10, 0xE0, 0x62, 0x05, 0x0E, 0x71, 0x0E, 0x05, 0x30, 0x27, 0x10, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_event_seat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_event_seat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_exit_to_app 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_exit_to_app_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40,
  0x39, 0x73, 0x98, 0x14, 0x01, 0x40, 0xD0, 0x44, 0x90, 0x40, 0x18, 0x01, 0x98, 0x1E, 0xF4, 0x39,
  0x04, 0x01, 0x80, 0x19, 0x81, 0xEF, 0x43, 0x98, 0x14, 0x01, 0x40, 0xD0, 0x44, 0x90, 0x40, 0x39,
  0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63,
  0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_exit_to_app() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_exit_to_app_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_expand 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_action_expand_data[] PROGMEM = {
  0x18, 0x06, 0x31, 0x04, 0xFB, 0x04, 0x18, 0x06, 0x16, 0x00, 0x17, 0x28, 0x21, 0xDD, 0x17, 0x10,
  0xDA, 0x0D, 0x71, 0x82, 0x3B, 0xB3, 0x72, 0x00, 0xA7, 0x30, 0x0A, 0x72, 0x82, 0x3B, 0xB3, 0x71,
  0x0D, 0xA0, 0xD7, 0x18, 0x21, 0xDD, 0x17, 0x20, 0x01, 0x68, 0x06, 0x11, 0x04, 0xFB, 0x04, 0x18,
  0x06, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_expand() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_expand_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_explore_off 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_action_explore_off_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x04, 0x0B, 0xC0, 0xB0, 0x35, 0x82, 0xE7, 0x09, 0xF0, 0x94, 0x83, 0x6F, 0x70,
  0x9F, 0x09, 0x30, 0x4A, 0x81, 0x70, 0x9B, 0x0B, 0x0D, 0xA0, 0x32, 0x0B, 0xB8, 0x57, 0x08, 0x82,
  0x0B, 0xA0, 0xB2, 0xD0, 0x73, 0x02, 0xC1, 0x02, 0xC8, 0x1E, 0xF7, 0x20, 0x8C, 0x00, 0x2C, 0x84,
  0x86, 0xF7, 0x08, 0xC0, 0x21, 0xC8, 0x52, 0x06, 0xF7, 0x09, 0xB2, 0x0B, 0xA8, 0x91, 0xB0, 0x28,
  0xEF, 0x70, 0x9F, 0xB2, 0x03, 0xA0, 0xD0, 0xBD, 0x82, 0x70, 0x94, 0x30, 0x9F, 0xA0, 0x76, 0x09,
  0xFA, 0x07, 0x60, 0x30, 0xBC, 0x82, 0xB4, 0x6E, 0x72, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_explore_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_explore_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_explore 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_explore_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xF9, 0x0B, 0x0D, 0xA0, 0x32, 0x0B, 0xD8, 0x3E, 0x82, 0x0B, 0xA0, 0xB2, 0xD0, 0x83, 0x02, 0xC1,
  0x02, 0xC8, 0x4E, 0x08, 0x80, 0x8C, 0x00, 0x2C, 0x84, 0x80, 0x88, 0x0E, 0xC0, 0x21, 0xC0, 0x23,
  0x08, 0xD2, 0x0B, 0xA8, 0x3B, 0x02, 0x8E, 0xD0, 0xB2, 0x03, 0xA0, 0xD0, 0xBF, 0x90, 0x33, 0x09,
  0xFB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_explore() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_explore_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_extension_off 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_18_action_extension_off_data[] PROGMEM = {
  0x58, 0x24, 0xEE, 0x47, 0x28, 0x13, 0x3C, 0xA8, 0x3C, 0x33, 0x32, 0x28, 0x2E, 0x70, 0x9F, 0xA8,
  0x52, 0x07, 0xF7, 0x09, 0xF9, 0x81, 0x40, 0x4A, 0x81, 0x70, 0x9F, 0x81, 0x40, 0x4B, 0x81, 0x70,
  0x9E, 0x82, 0x40, 0x16, 0xB8, 0x17, 0x09, 0xD0, 0xC0, 0x42, 0x09, 0xB8, 0x17, 0x09, 0xD0, 0xE2,
  0x09, 0xC8, 0x17, 0x09, 0xC8, 0x1E, 0x16, 0xE8, 0x17, 0x09, 0xA8, 0x1C, 0x44, 0xF9, 0x85, 0x70,
  0x9F, 0x40, 0x4F, 0xA8, 0x47, 0x09, 0x40, 0x4D, 0x00, 0x9B, 0x83, 0x70, 0x10, 0x2C, 0x06, 0x20,
  0x6B, 0x07, 0x30, 0x20, 0xF3, 0x48, 0x23, 0x37, 0xE2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_extension_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_extension_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_extension 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_extension_data[] PROGMEM = {
  0x58, 0x24, 0xEE, 0x47, 0x83, 0x23, 0x33, 0xCA, 0x83, 0xC3, 0x33, 0x22, 0x02, 0xFD, 0x81, 0x20,
  0x4F, 0xD8, 0x14, 0x04, 0xFD, 0x81, 0x40, 0x4F, 0xD8, 0x24, 0x01, 0x6F, 0xC0, 0xC0, 0x42, 0x09,
  0xFC, 0x0E, 0x20, 0x9F, 0xC8, 0x1E, 0x16, 0xFC, 0x81, 0xC4, 0x4F, 0xD8, 0x14, 0x04, 0xFD, 0x81,
  0x40, 0x4D, 0x00, 0x9D, 0x81, 0x40, 0x2C, 0x06, 0x20, 0x6C, 0x02, 0x20, 0x20, 0xF3, 0x40, 0xF3,
  0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_face 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_action_face_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9B, 0x0E, 0xE0, 0x93,
  0x03, 0xB8, 0x1E, 0x19, 0xE0, 0x32, 0x0B, 0xB0, 0x42, 0x04, 0x0B, 0xC0, 0xB2, 0xA0, 0xE0, 0x46,
  0x89, 0x22, 0x16, 0xF0, 0x2F, 0x81, 0x04, 0x12, 0x01, 0x04, 0x28, 0x42, 0xF2, 0x2F, 0x32, 0x90,
  0x82, 0x08, 0x92, 0x84, 0x3F, 0x20, 0xF5, 0x20, 0x30, 0x12, 0x01, 0x03, 0x20, 0x59, 0x20, 0x0B,
  0x73, 0x00, 0xB2, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x38, 0x19, 0xF5, 0x68, 0x15, 0xE9, 0x58,
  0x90, 0x9F, 0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_face() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_face_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_face_unlock 18x18, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_round_18_action_face_unlock_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x50, 0x20, 0xDB, 0x85, 0x51, 0x39, 0xFD,
  0x23, 0x86, 0x1D, 0xD7, 0xFE, 0xE4, 0x28, 0x23, 0xDD, 0x12, 0x89, 0x49, 0xF3, 0xDD, 0x1C, 0xFA,
  0x31, 0x3F, 0x92, 0x98, 0x2A, 0xBF, 0x32, 0x08, 0x0E, 0xD1, 0x05, 0xA0, 0xE0, 0x45, 0x89, 0x24,
  0x67, 0x7F, 0x56, 0xF9, 0x20, 0x14, 0x01, 0x28, 0x21, 0xF6, 0x69, 0x28, 0x11, 0xF8, 0x28, 0x18,
  0xF1, 0x29, 0x82, 0x65, 0xF3, 0x20, 0x80, 0x32, 0x03, 0x08, 0x28, 0x43, 0xF5, 0x0F, 0x87, 0x30,
  0x89, 0x28, 0x19, 0xF2, 0x71, 0x81, 0x2F, 0x92, 0x82, 0x1D, 0xD2, 0x68, 0x22, 0xDD, 0x13, 0x83,
  0x2D, 0xF8, 0x32, 0x83, 0x38, 0xFD, 0x25, 0x01, 0x09, 0xE0, 0x90, 0x17, 0x28, 0x25, 0x77, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_face_unlock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_face_unlock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_fact_check 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_fact_check_data[] PROGMEM = {
  0x10, 0x48, 0x06, 0x58, 0x14, 0x03, 0xFD, 0x03, 0x04, 0xFD, 0x85, 0x44, 0xFB, 0x33, 0x4F, 0x85,
  0x44, 0xFE, 0xBB, 0xCC, 0x0B, 0xA8, 0x54, 0x4F, 0xC7, 0x78, 0xA8, 0x1E, 0x83, 0xA8, 0x92, 0x44,
  0xFC, 0x77, 0x8F, 0xC1, 0x3E, 0xA8, 0x54, 0x4F, 0xEB, 0xBC, 0xA0, 0xC0, 0xEB, 0x85, 0x44, 0xFB,
  0x33, 0x4F, 0x00, 0x4F, 0xD0, 0x40, 0x3F, 0xD8, 0x13, 0x04, 0x80, 0x65, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_fact_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_fact_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_favorite_border 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_action_favorite_border_data[] PROGMEM = {
  0x28, 0x31, 0x89, 0x94, 0x28, 0x34, 0x99, 0x81, 0x38, 0xA1, 0x4F, 0xEC, 0xEF, 0x99, 0xFE, 0xCE,
  0xF4, 0x01, 0xEB, 0x12, 0x07, 0xA0, 0x72, 0x85, 0x1B, 0xE1, 0x5F, 0x34, 0x00, 0x64, 0x84, 0x3F,
  0x56, 0xF1, 0x73, 0x84, 0x1F, 0x73, 0xF4, 0x73, 0x84, 0x4F, 0x50, 0xEB, 0x73, 0x0B, 0x0E, 0x28,
  0x15, 0xF7, 0x71, 0x81, 0x7F, 0x53, 0x81, 0xAF, 0x56, 0x81, 0x5F, 0xA5, 0x81, 0xBF, 0x54, 0x81,
  0x5F, 0xB7, 0x81, 0xBF, 0x62, 0x81, 0x6F, 0xB7, 0x28, 0x4A, 0xF7, 0x7F, 0xA7, 0x40, 0x9A, 0x09,
  0x76, 0x00, 0x57,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_favorite_border() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_favorite_border_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_favorite 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_action_favorite_data[] PROGMEM = {
  0x38, 0x11, 0x33, 0x48, 0x13, 0x31, 0x50, 0x8B, 0x82, 0xD4, 0x3C, 0xB0, 0x83, 0x07, 0xFD, 0x08,
  0x20, 0xEF, 0xD8, 0x1E, 0x02, 0xFF, 0x02, 0x01, 0xFF, 0x81, 0x10, 0xBF, 0xD0, 0xC2, 0x02, 0xFD,
  0x03, 0x30, 0x7F, 0xB0, 0x75, 0x08, 0xF9, 0x09, 0x70, 0x8E, 0x08, 0x72, 0x07, 0xC0, 0x77, 0x40,
  0x6A, 0x06, 0x76, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_favorite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_favorite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_fax 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_fax_data[] PROGMEM = {
  0x68, 0x01, 0x50, 0x27, 0x20, 0x8D, 0x0E, 0x60, 0x12, 0x00, 0xA3, 0x81, 0x3F, 0x24, 0x89, 0x3A,
  0xFC, 0x0A, 0xB3, 0x33, 0x6F, 0x53, 0x20, 0x2B, 0x05, 0x0A, 0xF9, 0x81, 0xB0, 0x3B, 0x06, 0x0A,
  0xFA, 0x02, 0x03, 0xB8, 0x76, 0xA3, 0x01, 0xB3, 0xB3, 0xA0, 0x03, 0xB8, 0x76, 0xA3, 0x01, 0xEB,
  0xEB, 0xA0, 0x03, 0xB8, 0x76, 0xA3, 0x01, 0xA2, 0xA2, 0xA0, 0x03, 0xB8, 0x76, 0xAD, 0xDD, 0xFE,
  0xFE, 0xA0, 0x30, 0x2B, 0x05, 0x0A, 0xFA, 0x85, 0x10, 0xCF, 0xE1, 0x48, 0x04, 0x50, 0x33, 0x03,
  0x01, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_fax() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_fax_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_feedback 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_action_feedback_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3E, 0x00, 0x7E, 0x00, 0x3E, 0x00,
  0x5E, 0x00, 0x3E, 0x00, 0x5E, 0x00, 0x3E, 0x00, 0x5E, 0x00, 0x3E, 0x00, 0x7E, 0x00, 0x3F, 0xF0,
  0x03, 0xE0, 0x06, 0xE0, 0x03, 0xE0, 0x0E, 0xE0, 0x03, 0xFF, 0x01, 0x03, 0xA0, 0x98, 0x06, 0x78,
  0x34, 0x03, 0xF7, 0x76, 0x01, 0x05, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_feedback() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_feedback_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_file_present 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_action_file_present_data[] PROGMEM = {
  0x10, 0x18, 0x01, 0x30, 0x24, 0x02, 0xF0, 0x73, 0x06, 0xD8, 0x2D, 0x4F, 0x72, 0x06, 0xD8, 0x5D,
  0x04, 0xF7, 0x06, 0xD0, 0xD2, 0x82, 0x4F, 0x46, 0xA8, 0x96, 0xB5, 0x8F, 0xBB, 0xBE, 0x66, 0xFE,
  0x03, 0x0B, 0xC8, 0x66, 0x6F, 0xD0, 0xC1, 0x8C, 0x89, 0x06, 0x6F, 0xD0, 0xC1, 0x87, 0x6A, 0x89,
  0x06, 0x6F, 0xD0, 0xC1, 0x85, 0x4A, 0x89, 0x06, 0x6F, 0xD0, 0xB8, 0xC5, 0x5A, 0x00, 0x6A, 0x84,
  0x15, 0xFC, 0x08, 0xA0, 0x06, 0xA0, 0xB3, 0x03, 0xB0, 0x06, 0xB8, 0x1D, 0xAB, 0xC0, 0x60, 0x2F,
  0xB8, 0x12, 0x01, 0x80, 0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_file_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_file_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_filter_alt_off 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_action_filter_alt_off_data[] PROGMEM = {
  0x82, 0xE7, 0x01, 0x80, 0x45, 0x84, 0x16, 0xF7, 0x09, 0xE8, 0x6E, 0x20, 0x6F, 0x70, 0x9D, 0x05,
  0x38, 0x36, 0xF7, 0x09, 0xB0, 0x85, 0x85, 0x6F, 0x70, 0x9F, 0xA7, 0x83, 0x6F, 0x70, 0x77, 0x28,
  0x16, 0xF7, 0x74, 0x81, 0xDF, 0x77, 0x30, 0xDA, 0x07, 0x72, 0x83, 0xDD, 0x6F, 0x77, 0x18, 0x4D,
  0xD0, 0x6F, 0x77, 0x00, 0x22, 0x81, 0x6F, 0x77, 0x40, 0x60, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_filter_alt_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_filter_alt_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_filter_alt 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_action_filter_alt_data[] PROGMEM = {
  0x01, 0x80, 0x65, 0x81, 0x12, 0xEF, 0x98, 0x2E, 0x20, 0x5F, 0x90, 0x53, 0x08, 0xE0, 0x85, 0x0A,
  0xC0, 0xA7, 0x0C, 0xA0, 0xC7, 0x18, 0x22, 0xEE, 0x27, 0x20, 0x0D, 0x73, 0x00, 0xD7, 0x30, 0x0D,
  0x73, 0x00, 0xD7, 0x30, 0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_filter_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_filter_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_find_in_page 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_find_in_page_data[] PROGMEM = {
  0x10, 0x18, 0x02, 0x34, 0x02, 0xF0, 0x73, 0x06, 0xF9, 0x07, 0x20, 0x6F, 0xA8, 0x17, 0x06, 0xFB,
  0x04, 0x06, 0xFB, 0x00, 0x6B, 0x82, 0xA4, 0x4A, 0xB0, 0x06, 0xA8, 0x4B, 0x04, 0x40, 0xBA, 0x00,
  0x6A, 0x05, 0x03, 0xA0, 0x30, 0x5A, 0x00, 0x6A, 0x06, 0x02, 0xA0, 0x20, 0x6A, 0x00, 0x6A, 0x84,
  0xD0, 0x11, 0x05, 0xA0, 0x06, 0xB8, 0x7D, 0x88, 0x80, 0x6F, 0x66, 0xF0, 0xA1, 0x0F, 0x6F, 0x90,
  0xA2, 0x02, 0xFA, 0x09, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_find_in_page() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_find_in_page_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_find_replace 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_action_find_replace_data[] PROGMEM = {
  0x38, 0x21, 0x45, 0x27, 0x08, 0xC8, 0x1A, 0x88, 0x38, 0x18, 0xF6, 0x28, 0x25, 0xEF, 0x93, 0x0E,
  0x06, 0x30, 0x5A, 0x09, 0x30, 0x14, 0x82, 0x13, 0x31, 0x77, 0x05, 0xA0, 0x93, 0x81, 0x2E, 0x12,
  0x06, 0xA0, 0x52, 0x81, 0x2C, 0xD3, 0x89, 0x06, 0xCB, 0xFD, 0xCF, 0xDF, 0x75, 0x86, 0x48, 0x84,
  0x07, 0xF7, 0x73, 0x81, 0x7F, 0x67, 0x30, 0x70, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_find_replace() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_find_replace_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_fingerprint 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_18_action_fingerprint_data[] PROGMEM = {
  0x58, 0x21, 0x22, 0x17, 0x89, 0x01, 0x8D, 0xEC, 0xCE, 0xD8, 0x14, 0x89, 0x0A, 0x82, 0x35, 0x53,
  0x27, 0xA4, 0x89, 0x02, 0xAD, 0xA8, 0x8A, 0xDA, 0x23, 0x8E, 0x46, 0xD5, 0x15, 0x88, 0x51, 0x5D,
  0x60, 0x4C, 0x05, 0xD8, 0x55, 0x8D, 0x50, 0xC4, 0x61, 0x6B, 0x16, 0xAA, 0x61, 0xB6, 0x16, 0x01,
  0xD1, 0xB9, 0x33, 0x9B, 0x1D, 0x12, 0x89, 0x28, 0x66, 0x95, 0xDD, 0x58, 0x76, 0x82, 0x89, 0x2B,
  0x2C, 0x2D, 0x11, 0xD2, 0xC2, 0xB2, 0x89, 0x2C, 0x1D, 0x3A, 0x57, 0x94, 0x22, 0xB2, 0x89, 0x2A,
  0x4D, 0x1D, 0x2C, 0x3D, 0x7C, 0x52, 0x89, 0x14, 0x6A, 0x4B, 0x49, 0x93, 0x73, 0x58, 0x73, 0xC3,
  0xD4, 0x6C, 0xDB, 0x68, 0x47, 0x83, 0xCD, 0x67, 0x60, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_fingerprint() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_fingerprint_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_fit_screen 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_fit_screen_data[] PROGMEM = {
  0x18, 0x13, 0x55, 0x71, 0x83, 0x55, 0x30, 0x1B, 0x03, 0x60, 0x3B, 0x82, 0x13, 0xF2, 0x73, 0x86,
  0x2F, 0x32, 0xF1, 0x19, 0x80, 0x2B, 0x87, 0x91, 0x1F, 0x20, 0x10, 0x7F, 0x98, 0x17, 0x01, 0x40,
  0x7F, 0x90, 0x76, 0x07, 0xF9, 0x07, 0x48, 0x11, 0x07, 0xF9, 0x87, 0x70, 0x10, 0x2F, 0x11, 0x98,
  0x02, 0xB8, 0x69, 0x11, 0xF2, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x1B, 0x03, 0x60, 0x3B, 0x83, 0x10,
  0x35, 0x57, 0x18, 0x15, 0x53, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_fit_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_fit_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_flaky 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_action_flaky_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x50, 0x5F, 0x90, 0x53, 0x84, 0x3F, 0xDC,
  0xCD, 0xB8, 0x18, 0xD3, 0x28, 0x4B, 0xFC, 0x22, 0xDA, 0x84, 0x70, 0x4B, 0x01, 0xA8, 0x4C, 0x22,
  0xDF, 0x73, 0x81, 0xD1, 0x3A, 0x83, 0xDD, 0xCD, 0x74, 0x81, 0xA3, 0x3D, 0x07, 0x28, 0x41, 0x20,
  0xA3, 0x1C, 0x89, 0x17, 0x03, 0x1C, 0x50, 0xD1, 0x0B, 0xA0, 0x72, 0x84, 0xBD, 0x50, 0x3B, 0x28,
  0x13, 0xF8, 0x48, 0x33, 0x01, 0xD3, 0x38, 0x15, 0xD3, 0x48, 0x13, 0xD5, 0x58, 0x63, 0xBC, 0xAA,
  0xDB, 0x37, 0x18, 0x21, 0x33, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_flaky() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_flaky_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_flight_land 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_action_flight_land_data[] PROGMEM = {
  0x50, 0x08, 0x75, 0x0C, 0x0E, 0x71, 0x02, 0x38, 0x1C, 0xF5, 0x60, 0x40, 0xE3, 0x81, 0xCF, 0xA6,
  0x86, 0x4F, 0x71, 0x0C, 0xFE, 0x60, 0x4B, 0x0C, 0x0E, 0xA0, 0x45, 0x02, 0x0C, 0xE8, 0x1C, 0x62,
  0x58, 0x21, 0x59, 0xDD, 0x0D, 0x08, 0x78, 0x12, 0x7B, 0xC0, 0x37, 0x38, 0x14, 0x88, 0x77, 0x77,
  0x10, 0x2F, 0xD0, 0x21, 0x80, 0x90, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_flight_land() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_flight_land_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_flight_takeoff 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_action_flight_takeoff_data[] PROGMEM = {
  0x30, 0x80, 0x37, 0x58, 0x1E, 0xF5, 0x74, 0x06, 0xA0, 0x77, 0x40, 0xCA, 0x09, 0x38, 0x14, 0x85,
  0x40, 0x3B, 0x00, 0xBC, 0x84, 0x89, 0x02, 0x6E, 0xE8, 0x3D, 0x64, 0xFE, 0xD8, 0x2E, 0xA6, 0x23,
  0x0A, 0xB8, 0x1B, 0x73, 0x78, 0x11, 0x84, 0x80, 0xC2, 0x00, 0x2F, 0xD0, 0x21, 0x80, 0x90, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_flight_takeoff() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_flight_takeoff_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_flip_to_back 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_flip_to_back_data[] PROGMEM = {
  0x48, 0x72, 0x03, 0x20, 0x42, 0x02, 0x48, 0x91, 0x6B, 0x0B, 0x90, 0xE6, 0x0F, 0x27, 0x78, 0x31,
  0x70, 0x45, 0x78, 0x56, 0x24, 0xF0, 0x8A, 0x78, 0x1E, 0x44, 0x97, 0x58, 0x34, 0xF0, 0x57, 0x78,
  0x59, 0x24, 0xF0, 0x68, 0x78, 0x1B, 0x34, 0x97, 0x58, 0xB3, 0x4F, 0x05, 0x80, 0x87, 0x0A, 0x50,
  0xB2, 0x4F, 0x01, 0x50, 0x65, 0x08, 0x40, 0x60, 0x49, 0x75, 0x02, 0xFA, 0x07, 0x40, 0x28, 0x04,
  0x30, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_flip_to_back() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_flip_to_back_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_flip_to_front 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_action_flip_to_front_data[] PROGMEM = {
  0x48, 0x04, 0x30, 0x24, 0x06, 0xFA, 0x02, 0x30, 0x90, 0xB7, 0x98, 0x44, 0x29, 0x09, 0xB7, 0x98,
  0x44, 0x3B, 0x09, 0xB7, 0x90, 0x43, 0x09, 0x0B, 0x79, 0x84, 0x43, 0xB0, 0x9B, 0x79, 0x84, 0x42,
  0x90, 0x9B, 0x79, 0x04, 0x30, 0x90, 0xB7, 0x98, 0x44, 0x4E, 0x08, 0xE8, 0x03, 0xB9, 0x84, 0x32,
  0x60, 0x18, 0x80, 0x39, 0x06, 0x77, 0x18, 0x91, 0x2F, 0x06, 0xE0, 0x9B, 0x0B, 0x94, 0x89, 0x02,
  0x02, 0x40, 0x23, 0x03, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_flip_to_front() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_flip_to_front_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_flutter_dash 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_18_action_flutter_dash_data[] PROGMEM = {
  0x78, 0x12, 0x74, 0x74, 0x84, 0x16, 0xDF, 0xB1, 0x72, 0x86, 0x6B, 0x41, 0x14, 0xB6, 0x68, 0x92,
  0xAA, 0x85, 0x62, 0x26, 0x58, 0xAA, 0x38, 0x94, 0x9F, 0xBB, 0x64, 0xBB, 0x46, 0xBB, 0xF9, 0x2A,
  0x89, 0x09, 0x69, 0xB1, 0x1D, 0x76, 0x9A, 0x10, 0x2A, 0x89, 0x07, 0x4C, 0xF3, 0x3F, 0xC4, 0x7A,
  0x02, 0x1A, 0x89, 0x05, 0xB3, 0x57, 0x55, 0x3B, 0x5A, 0x28, 0x94, 0x5B, 0xC4, 0x67, 0xF7, 0x7A,
  0x4C, 0xB5, 0x38, 0x45, 0xB0, 0x6C, 0x34, 0x0B, 0x05, 0x58, 0x1B, 0x25, 0x50, 0x10, 0xB6, 0x81,
  0x2B, 0x54, 0x81, 0x5B, 0x27, 0x18, 0x4A, 0xCA, 0xBE, 0x67, 0x38, 0x54, 0xA3, 0x06, 0xC4, 0x73,
  0x84, 0x7E, 0x20, 0xCE, 0x73, 0x84, 0x3A, 0x30, 0x33, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_flutter_dash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_flutter_dash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_free_cancellation 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_action_free_cancellation_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x48, 0x94, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x02, 0xFD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF2, 0x80, 0x41, 0x89, 0x02, 0xF4, 0x4F,
  0x06, 0x56, 0x55, 0x98, 0x34, 0x4F, 0x06, 0xA0, 0x65, 0x84, 0xA2, 0x4F, 0x06, 0xA0, 0x57, 0x85,
  0x4F, 0x07, 0x67, 0x65, 0x81, 0xBB, 0x49, 0x60, 0x72, 0x84, 0xBE, 0x34, 0xF2, 0x80, 0x11, 0x86,
  0xEB, 0xBE, 0x30, 0x1E, 0xC8, 0x4D, 0x03, 0xEE, 0x33, 0x84, 0x13, 0x33, 0x31, 0x20, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_free_cancellation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_free_cancellation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_gavel 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_action_gavel_data[] PROGMEM = {
  0x58, 0x12, 0x94, 0x73, 0x0A, 0xA0, 0x57, 0x82, 0x24, 0x0C, 0xA0, 0x56, 0x85, 0x8F, 0x40, 0xCF,
  0xD4, 0x87, 0x26, 0x09, 0xF4, 0x0C, 0x84, 0x85, 0xBF, 0x60, 0x9F, 0x46, 0x09, 0xA8, 0x36, 0x09,
  0xF4, 0x60, 0xBA, 0x83, 0x60, 0x9F, 0x46, 0x81, 0xAF, 0x82, 0x81, 0x9F, 0x47, 0x48, 0x19, 0xF4,
  0x74, 0x81, 0x9F, 0x47, 0x48, 0x19, 0xC4, 0xF0, 0x85, 0x80, 0x33, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_gavel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_gavel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_generating_tokens 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_action_generating_tokens_data[] PROGMEM = {
  0x76, 0x04, 0x77, 0x81, 0x5F, 0x34, 0x84, 0x5A, 0xCB, 0x82, 0x20, 0x7B, 0x82, 0x40, 0x1C, 0xE0,
  0x72, 0x81, 0x8F, 0x52, 0x0D, 0xF9, 0x06, 0x20, 0x72, 0x07, 0xA8, 0x3E, 0xBB, 0xBC, 0xA0, 0xE0,
  0x14, 0x0D, 0xA8, 0x3A, 0x10, 0x13, 0xB0, 0x54, 0xD0, 0x10, 0x8C, 0x08, 0x4D, 0x01, 0x08, 0xC0,
  0x84, 0x0D, 0xC0, 0x10, 0x8C, 0x05, 0x40, 0x7C, 0x07, 0x0C, 0xB0, 0xE0, 0x15, 0x0D, 0xF9, 0x06,
  0x20, 0x73, 0x01, 0x0C, 0xE0, 0x72, 0x81, 0x8F, 0x54, 0x84, 0x5A, 0xCB, 0x82, 0x20, 0x7B, 0x04,
  0x75, 0x81, 0x5F, 0x37, 0x70, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_generating_tokens() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_generating_tokens_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_get_app 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_action_get_app_data[] PROGMEM = {
  0x38, 0x22, 0x33, 0x26, 0x0C, 0xA0, 0xC6, 0x0C, 0xA0, 0xC6, 0x0C, 0xA0, 0xC6, 0x0C, 0xA0, 0xC4,
  0x81, 0x9B, 0xEA, 0x81, 0xEB, 0x82, 0x03, 0x0E, 0xC0, 0xE0, 0x33, 0x03, 0x0E, 0xA0, 0xE0, 0x35,
  0x82, 0x3E, 0xE3, 0x70, 0x03, 0x77, 0x05, 0xF9, 0x05, 0x01, 0x80, 0x45, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_get_app() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_action_get_app_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_gif_box 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_gif_box_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x00,
  0x4A, 0x86, 0x63, 0x8A, 0xA8, 0x34, 0xA8, 0x92, 0x44, 0xFE, 0x2D, 0xE8, 0x85, 0x4A, 0xA8, 0x92,
  0x44, 0xFE, 0x2B, 0x68, 0x85, 0x5C, 0xA0, 0x04, 0xA8, 0x56, 0x3A, 0xAA, 0x8D, 0xB0, 0x04, 0xFD,
  0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_gif_box() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_gif_box_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_gif 18x18, 4-bit Alpha,  RLE, 19 bytes.
static const unsigned char ic_round_18_action_gif_data[] PROGMEM = {
  0x8C, 0x06, 0xBB, 0x09, 0x1B, 0xB4, 0x96, 0x10, 0xD3, 0xC4, 0x09, 0x6B, 0x1D, 0x3D, 0x70, 0x6B,
  0xB0, 0x91, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_gif() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 7, 13, 10), Box(0, 0, 17, 17),
      ic_round_18_action_gif_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_grade 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_action_grade_data[] PROGMEM = {
  0x60, 0x08, 0x75, 0x00, 0xD7, 0x40, 0x3A, 0x03, 0x73, 0x08, 0xA0, 0x85, 0x84, 0x3B, 0xBB, 0xBE,
  0xA8, 0x6E, 0xBB, 0xBB, 0x30, 0x8F, 0xB0, 0x83, 0x05, 0x0E, 0xE0, 0xE0, 0x55, 0x02, 0x0E, 0xC0,
  0xE0, 0x27, 0x0E, 0xC0, 0xE7, 0x04, 0xE0, 0x46, 0x86, 0x9F, 0xD3, 0x3D, 0xF9, 0x68, 0x1E, 0xB1,
  0x28, 0x11, 0xBE, 0x60, 0x46, 0x04, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_grade() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_grade_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_grading 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_action_grading_data[] PROGMEM = {
  0x02, 0x80, 0x45, 0x02, 0x03, 0x80, 0x47, 0x03, 0x73, 0x05, 0x80, 0x4D, 0x05, 0x73, 0x02, 0x80,
  0x47, 0x00, 0x28, 0x04, 0x70, 0x27, 0x38, 0x35, 0xDD, 0xD5, 0x30, 0x50, 0x16, 0x8A, 0x32, 0x6C,
  0x03, 0x77, 0x73, 0x0D, 0xC1, 0x02, 0x55, 0x52, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_grading() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_action_grading_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_group_work 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_group_work_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xC8, 0x2D, 0x11, 0xDC, 0x03, 0x20, 0xBC, 0x0B, 0x20, 0xBC, 0x0B, 0x2E, 0x00, 0x7E, 0x10, 0x2F,
  0xF0, 0x02, 0xB8, 0x1B, 0x8E, 0xA8, 0x1E, 0x8B, 0xB0, 0x21, 0xB2, 0x06, 0xA0, 0x62, 0xB2, 0x0B,
  0xA8, 0x13, 0x09, 0xA8, 0x19, 0x03, 0xA0, 0xB2, 0x03, 0xB0, 0xEC, 0x0E, 0xB0, 0x33, 0x09, 0xFB,
  0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_group_work() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_group_work_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_g_translate 18x18, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_18_action_g_translate_data[] PROGMEM = {
  0x28, 0x00, 0x37, 0x40, 0xEC, 0x06, 0x72, 0x03, 0xD0, 0xB7, 0x20, 0x3E, 0x80, 0x37, 0x81, 0x40,
  0x3A, 0x83, 0x97, 0xAF, 0x98, 0x02, 0x58, 0x90, 0xD1, 0x3F, 0x54, 0x96, 0xEA, 0x68, 0xD4, 0xA3,
  0x3D, 0x1F, 0xC9, 0x9E, 0x39, 0x73, 0x30, 0xA3, 0x3C, 0x2F, 0xB7, 0x0F, 0xA7, 0x7D, 0x70, 0xA3,
  0x3F, 0x37, 0xC6, 0x5F, 0xD5, 0x39, 0x28, 0x94, 0xA3, 0x3F, 0xE6, 0x37, 0xEF, 0xEB, 0xC1, 0x28,
  0x1A, 0x33, 0xF9, 0x81, 0xDC, 0x22, 0x81, 0xA3, 0x1F, 0x98, 0x79, 0x2C, 0x20, 0xA3, 0x04, 0x80,
  0x17, 0x87, 0xEF, 0xD0, 0x23, 0x0A, 0x37, 0x81, 0x8F, 0xC4, 0x0A, 0x03, 0x78, 0x63, 0xFC, 0xBB,
  0xBB, 0xD7, 0x28, 0x02, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_g_translate() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_g_translate_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_help_center 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_help_center_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD0, 0xA0, 0xBC, 0x82, 0xE8, 0x8D, 0xC0, 0x0B, 0xB8,
  0x4D, 0x11, 0x10, 0xDB, 0x00, 0xBB, 0x84, 0xD6, 0xEF, 0x17, 0xB0, 0x0B, 0xE8, 0x1E, 0x18, 0xB0,
  0x0B, 0xD8, 0x1E, 0x23, 0xC0, 0x0B, 0xD8, 0x17, 0x1E, 0xC0, 0x0B, 0xD0, 0xB0, 0xAD, 0x00, 0xBD,
  0x00, 0xCD, 0x00, 0xBD, 0x00, 0x2D, 0x00, 0xBD, 0x00, 0xBD, 0x0B, 0x0A, 0xFD, 0x81, 0xA2, 0xA8,
  0x06, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_help_center() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_help_center_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_help_outline 18x18, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_round_18_action_help_outline_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x94, 0x1D, 0xD2, 0x01, 0x66, 0x10, 0x2D, 0xD1, 0x28, 0x49, 0xF2, 0x03, 0xEA, 0x84,
  0xE3, 0x02, 0xF9, 0x29, 0x08, 0x28, 0x4B, 0xD2, 0x2D, 0xB2, 0x84, 0x8F, 0x05, 0xF3, 0x20, 0x40,
  0x22, 0x08, 0x0E, 0x28, 0x23, 0xF5, 0x69, 0x68, 0x12, 0xDA, 0x39, 0x00, 0x69, 0x58, 0x12, 0xEB,
  0x49, 0x82, 0x65, 0xF3, 0x40, 0x90, 0xE4, 0x84, 0x3F, 0x50, 0xF8, 0x40, 0x20, 0x34, 0x08, 0x92,
  0x81, 0x9F, 0x23, 0x00, 0xB3, 0x81, 0x2F, 0x92, 0x82, 0x1D, 0xD2, 0x20, 0x05, 0x28, 0x22, 0xDD,
  0x13, 0x83, 0x2D, 0xF8, 0x32, 0x83, 0x38, 0xFD, 0x25, 0x01, 0x09, 0xE0, 0x90, 0x17, 0x28, 0x25,
  0x77, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_help_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_help_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_help 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_help_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9B, 0x82, 0xE8, 0x8D,
  0xB0, 0x93, 0x03, 0xB8, 0x4D, 0x11, 0x10, 0xDB, 0x03, 0x20, 0xBB, 0x84, 0xD6, 0xEF, 0x17, 0xB0,
  0xB2, 0xF8, 0x1D, 0x08, 0xC1, 0x02, 0xE8, 0x1E, 0x23, 0xD0, 0x02, 0xE8, 0x17, 0x1E, 0xD0, 0x21,
  0xE0, 0xB0, 0xAE, 0x20, 0xBD, 0x00, 0xDD, 0x0B, 0x20, 0x3D, 0x00, 0x3D, 0x03, 0x30, 0x9C, 0x00,
  0xBC, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_hide_source 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_18_action_hide_source_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x04, 0x0B, 0xC0, 0xB0, 0x35, 0x89, 0x2E, 0x70, 0x9C, 0x63, 0x35, 0xBF, 0x94,
  0x81, 0x6F, 0x77, 0x81, 0x5F, 0x93, 0x04, 0xA0, 0x77, 0x81, 0x5F, 0x32, 0x83, 0xBB, 0x6F, 0x77,
  0x00, 0xB2, 0x98, 0x35, 0x06, 0xF7, 0x68, 0x45, 0xF0, 0x2F, 0x32, 0x81, 0x6F, 0x75, 0x84, 0x3F,
  0x22, 0xF3, 0x38, 0x16, 0xF7, 0x48, 0x43, 0xF2, 0x0F, 0x54, 0x81, 0x6F, 0x73, 0x05, 0x92, 0x0A,
  0x0B, 0x58, 0x16, 0xF7, 0x20, 0x0B, 0x28, 0x14, 0xF5, 0x58, 0x46, 0xF7, 0x09, 0x43, 0x81, 0x8F,
  0x55, 0x81, 0x6F, 0x76, 0x86, 0x8F, 0xB5, 0x33, 0x6C, 0xA0, 0x76, 0x04, 0x0A, 0xC8, 0x2B, 0x36,
  0xE7, 0x20, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_hide_source() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_hide_source_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_highlight_alt 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_highlight_alt_data[] PROGMEM = {
  0x18, 0xB1, 0x20, 0x23, 0x03, 0x30, 0x32, 0x02, 0x02, 0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x27,
  0x70, 0x20, 0x77, 0x38, 0x29, 0x23, 0xD7, 0x30, 0xB0, 0x37, 0x70, 0x30, 0xA4, 0x84, 0x8D, 0xDD,
  0xDB, 0x20, 0x30, 0xA4, 0x0D, 0xC0, 0xC7, 0x10, 0xDB, 0x0C, 0x01, 0x20, 0x30, 0xD4, 0x0D, 0xB0,
  0x73, 0x02, 0x07, 0x48, 0x4D, 0xFC, 0x8F, 0x67, 0x18, 0x93, 0xBC, 0x10, 0x7F, 0x60, 0x2F, 0x07,
  0xD6, 0x07, 0x0D, 0x28, 0x22, 0x02, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_highlight_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_highlight_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_highlight_off 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_highlight_off_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xB0, 0xCC, 0x0C, 0xB0, 0x32, 0x0B, 0xA8, 0x1C, 0x08, 0xA8, 0x18, 0x0C, 0xA0, 0xB2, 0xC8, 0x48,
  0x08, 0x80, 0x8C, 0x10, 0x2D, 0x08, 0x20, 0x8D, 0x00, 0x2D, 0x08, 0x20, 0x8D, 0x02, 0x1C, 0x84,
  0x80, 0x88, 0x08, 0xC2, 0x0B, 0xA8, 0x1C, 0x08, 0xA8, 0x18, 0x0C, 0xA0, 0xB2, 0x03, 0xB0, 0xCC,
  0x0C, 0xB0, 0x33, 0x09, 0xFB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40,
  0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_highlight_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_highlight_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_history 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_action_history_data[] PROGMEM = {
  0x68, 0x11, 0x33, 0x73, 0x03, 0x0B, 0xC0, 0xB0, 0x26, 0x89, 0x05, 0xFB, 0x41, 0x14, 0xBE, 0x54,
  0x81, 0x3F, 0x82, 0x00, 0x42, 0x81, 0x8E, 0x23, 0x00, 0xB3, 0x00, 0xA3, 0x00, 0xB2, 0x81, 0x1F,
  0x43, 0x00, 0xA3, 0x05, 0x92, 0x81, 0x3F, 0x13, 0x0A, 0x0C, 0x38, 0x21, 0xF3, 0x8B, 0x04, 0x28,
  0x13, 0xEA, 0x28, 0x51, 0xF3, 0x0B, 0xF8, 0x48, 0x53, 0xE6, 0x05, 0xF1, 0x20, 0x56, 0x01, 0x20,
  0x0B, 0x50, 0x46, 0x81, 0x8F, 0x34, 0x89, 0x03, 0xFB, 0x41, 0x15, 0xBF, 0x56, 0x03, 0x0B, 0xC0,
  0xB0, 0x37, 0x28, 0x21, 0x33, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_history() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_history_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_history_toggle_off 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_history_toggle_off_data[] PROGMEM = {
  0x58, 0x21, 0x22, 0x17, 0x28, 0x47, 0xD5, 0x5D, 0x76, 0x05, 0x0A, 0x60, 0xA0, 0x54, 0x0A, 0x01,
  0x60, 0x10, 0xA3, 0x07, 0x40, 0x03, 0x48, 0x27, 0x01, 0xD4, 0x06, 0x07, 0x48, 0x2D, 0x11, 0x54,
  0x06, 0x07, 0x48, 0x25, 0x11, 0x54, 0x06, 0x0A, 0x48, 0x25, 0x11, 0xD5, 0x81, 0x7C, 0x32, 0x82,
  0xD1, 0x07, 0x60, 0x20, 0x42, 0x07, 0x30, 0xA0, 0x16, 0x01, 0x0A, 0x40, 0x50, 0xA6, 0x0A, 0x05,
  0x68, 0x47, 0xD5, 0x5D, 0x77, 0x28, 0x21, 0x22, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_history_toggle_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_history_toggle_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_hls_off 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_action_hls_off_data[] PROGMEM = {
  0x0E, 0x07, 0x74, 0x81, 0x6F, 0x77, 0x48, 0x16, 0xF7, 0x74, 0x81, 0x6F, 0x77, 0x28, 0x34, 0x59,
  0xF7, 0x38, 0x91, 0x2B, 0xB4, 0x06, 0xBC, 0xAF, 0x72, 0x89, 0x24, 0xB6, 0x10, 0x6B, 0xC4, 0x6F,
  0x72, 0x89, 0x66, 0xA6, 0x04, 0x56, 0x20, 0xAF, 0x70, 0x8B, 0x47, 0x81, 0x6F, 0x77, 0x48, 0x16,
  0xF7, 0x74, 0x81, 0x6F, 0x77, 0x48, 0x16, 0xF7, 0x74, 0x06, 0x0E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_hls_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_hls_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_hls 18x18, 4-bit Alpha,  RLE, 27 bytes.
static const unsigned char ic_round_18_action_hls_data[] PROGMEM = {
  0x84, 0x45, 0x62, 0x09, 0x28, 0x90, 0x2B, 0xB4, 0x6B, 0xC4, 0x0D, 0x28, 0xB2, 0x4B, 0x61, 0x6B,
  0xC4, 0x0D, 0x10, 0x16, 0xA6, 0x45, 0x62, 0x09, 0xB3, 0x2B, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_hls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 14, 10), Box(0, 0, 17, 17),
      ic_round_18_action_hls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_home 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_action_home_data[] PROGMEM = {
  0x48, 0x23, 0xCC, 0x37, 0x06, 0xC0, 0x65, 0x0A, 0xE0, 0xA2, 0x01, 0x0D, 0xF9, 0x81, 0xD1, 0x5F,
  0xB0, 0x50, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x6B, 0x82, 0xCB, 0xBC, 0xB0, 0x06, 0xB0, 0x32, 0x03,
  0xB0, 0x06, 0xB0, 0x32, 0x03, 0xB0, 0x06, 0xB0, 0x32, 0x03, 0xB0, 0x60, 0x3B, 0x03, 0x20, 0x3B,
  0x83, 0x30, 0x23, 0x34, 0x81, 0x33, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_home() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_home_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_horizontal_split 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_18_action_horizontal_split_data[] PROGMEM = {
  0x18, 0x09, 0x07, 0x10, 0x28, 0x09, 0x0D, 0x02, 0x77, 0x02, 0x80, 0x90, 0xB0, 0x20, 0x18, 0x09,
  0x07, 0x01, 0x28, 0x06, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD8, 0x14, 0x06, 0x80,
  0x67, 0x06, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_horizontal_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_horizontal_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_hotel_class 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_hotel_class_data[] PROGMEM = {
  0x68, 0x36, 0xA0, 0x97, 0x74, 0x83, 0xBE, 0x09, 0xC7, 0x30, 0x1A, 0x82, 0x44, 0xD1, 0x72, 0x06,
  0xA0, 0x97, 0x84, 0x2B, 0xBB, 0xBE, 0xA8, 0x4E, 0xBB, 0xBB, 0x43, 0x07, 0xFB, 0x09, 0x50, 0x40,
  0xEF, 0x83, 0x60, 0x6F, 0x53, 0x02, 0x0D, 0xC8, 0x4E, 0x30, 0x9F, 0x75, 0x0D, 0xD8, 0x21, 0x7F,
  0x45, 0x03, 0xE8, 0x26, 0x2F, 0x35, 0x89, 0x17, 0xFE, 0x42, 0xDF, 0xB0, 0xD8, 0x58, 0x1C, 0xC1,
  0x38, 0x3A, 0xF0, 0x8D, 0x50, 0x46, 0x04, 0x20, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_hotel_class() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_hotel_class_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_hourglass_disabled 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_hourglass_disabled_data[] PROGMEM = {
  0x01, 0x38, 0x02, 0x34, 0x89, 0x19, 0x70, 0x8C, 0x99, 0x99, 0xC8, 0x48, 0x2B, 0x74, 0x44, 0x04,
  0x09, 0x50, 0xB0, 0x75, 0x04, 0x09, 0x60, 0xB0, 0x73, 0x81, 0x1C, 0x47, 0x84, 0xB7, 0x01, 0xC6,
  0x72, 0x82, 0xB7, 0x36, 0x73, 0x81, 0x6F, 0x77, 0x38, 0x36, 0xC1, 0xB7, 0x71, 0x81, 0x4C, 0x12,
  0x0B, 0x07, 0x70, 0x90, 0x44, 0x0B, 0x07, 0x60, 0x90, 0x44, 0x81, 0x4F, 0x75, 0x89, 0x08, 0xC9,
  0x99, 0x9C, 0x8B, 0x75, 0x80, 0x23, 0x20, 0x90, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_hourglass_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_hourglass_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_hourglass_empty 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_hourglass_empty_data[] PROGMEM = {
  0x18, 0x06, 0x31, 0x04, 0xFB, 0x89, 0x24, 0x05, 0xF2, 0x11, 0x11, 0x2F, 0x52, 0x81, 0x4F, 0x14,
  0x81, 0x1F, 0x42, 0x81, 0x3F, 0x14, 0x81, 0x1F, 0x32, 0x81, 0x1F, 0x54, 0x81, 0x5F, 0x13, 0x81,
  0xAD, 0x22, 0x81, 0x2D, 0xA4, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x48, 0x61, 0xCF, 0xCC, 0xFC, 0x14,
  0x81, 0xAD, 0x22, 0x81, 0x2D, 0xA3, 0x81, 0x1F, 0x54, 0x81, 0x5F, 0x12, 0x81, 0x3F, 0x14, 0x81,
  0x1F, 0x32, 0x81, 0x4F, 0x14, 0x81, 0x1F, 0x42, 0x89, 0x25, 0xF2, 0x11, 0x11, 0x2F, 0x50, 0x4F,
  0xB0, 0x41, 0x80, 0x63, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_hourglass_empty() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_hourglass_empty_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_hourglass_full 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_action_hourglass_full_data[] PROGMEM = {
  0x18, 0x06, 0x31, 0x04, 0xFB, 0x81, 0x40, 0x5F, 0x90, 0x52, 0x04, 0xF9, 0x04, 0x20, 0x3F, 0x90,
  0x32, 0x01, 0xF9, 0x01, 0x30, 0xAE, 0x0A, 0x40, 0x10, 0xCC, 0x0C, 0x01, 0x40, 0x10, 0xCC, 0x0C,
  0x01, 0x40, 0xAE, 0x0A, 0x30, 0x1F, 0x90, 0x12, 0x03, 0xF9, 0x03, 0x20, 0x4F, 0x90, 0x42, 0x05,
  0xF9, 0x81, 0x50, 0x4F, 0xB0, 0x41, 0x80, 0x63, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_hourglass_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_hourglass_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_html 18x18, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_round_18_action_html_data[] PROGMEM = {
  0x8E, 0x71, 0x74, 0x56, 0xBB, 0x0B, 0xBB, 0xB5, 0x62, 0x03, 0xDA, 0x70, 0xB4, 0x0E, 0x4B, 0x77,
  0x94, 0x03, 0xDA, 0x70, 0xA3, 0x0D, 0x28, 0x67, 0x96, 0x01, 0x74, 0x50, 0x71, 0x09, 0x28, 0x34,
  0x56, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_html() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 16, 10), Box(0, 0, 17, 17),
      ic_round_18_action_html_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_http 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_round_18_action_http_data[] PROGMEM = {
  0x8E, 0x12, 0x65, 0x47, 0xBA, 0x0B, 0xB6, 0x5B, 0xB1, 0x4C, 0xB6, 0x0C, 0x20, 0x4B, 0x07, 0xBD,
  0x34, 0xCB, 0x60, 0xC1, 0x03, 0xA0, 0x7A, 0x70, 0x26, 0x54, 0x08, 0x28, 0x31, 0x70, 0x54, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_http() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 16, 10), Box(0, 0, 17, 17),
      ic_round_18_action_http_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_https 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_action_https_data[] PROGMEM = {
  0x50, 0x02, 0x71, 0x03, 0x0D, 0xA0, 0xD0, 0x35, 0x86, 0x2E, 0xC5, 0x5C, 0xE2, 0x48, 0x18, 0xE1,
  0x28, 0x11, 0xE8, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x20, 0x8F, 0xB0, 0x8F, 0xFF,
  0xF9, 0x00, 0xDF, 0xA0, 0xB2, 0x0B, 0xF9, 0x08, 0x20, 0x8F, 0x98, 0x2E, 0x66, 0xEF, 0xFF, 0xF0,
  0xDF, 0xB0, 0xD0, 0x28, 0x06, 0x70, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_https() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_https_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_important_devices 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_18_action_important_devices_data[] PROGMEM = {
  0x10, 0x18, 0x06, 0x30, 0x23, 0x01, 0x0E, 0xFC, 0x03, 0x28, 0x13, 0xF2, 0x72, 0x0E, 0x06, 0x28,
  0x13, 0xF2, 0x30, 0x10, 0x44, 0x0E, 0x05, 0x28, 0x13, 0xF2, 0x30, 0x60, 0x94, 0x02, 0x38, 0x43,
  0xF2, 0x01, 0xCA, 0x0D, 0x03, 0x68, 0x13, 0xF2, 0x20, 0x1A, 0x89, 0x14, 0x01, 0xCD, 0xDC, 0x03,
  0xF2, 0x28, 0x94, 0x48, 0x67, 0x04, 0xF8, 0x8F, 0x33, 0xF2, 0x78, 0x74, 0xF0, 0x2F, 0x32, 0xFC,
  0x80, 0x1B, 0x8A, 0x68, 0x04, 0xF0, 0x2F, 0x30, 0x59, 0x99, 0x9D, 0xE6, 0x04, 0xF0, 0x2F, 0x36,
  0x08, 0x0B, 0x28, 0x44, 0xF0, 0x2F, 0x35, 0x08, 0xA8, 0x1B, 0x03, 0xC0, 0x15, 0x82, 0x13, 0x32,
  0x20, 0xF3, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_important_devices() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_important_devices_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_info_outline 18x18, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_18_action_info_outline_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x28, 0x19, 0xF2, 0x30, 0x08, 0x38, 0x12, 0xF9,
  0x29, 0x08, 0x40, 0x08, 0x48, 0x48, 0xF0, 0x5F, 0x37, 0x38, 0x23, 0xF5, 0x69, 0x50, 0x06, 0x59,
  0x00, 0x69, 0x50, 0x0B, 0x59, 0x82, 0x65, 0xF3, 0x40, 0x0B, 0x48, 0x43, 0xF5, 0x0F, 0x84, 0x00,
  0xB4, 0x08, 0x92, 0x81, 0x9F, 0x23, 0x00, 0x63, 0x81, 0x2F, 0x92, 0x82, 0x1D, 0xD2, 0x68, 0x22,
  0xDD, 0x13, 0x83, 0x2D, 0xF8, 0x32, 0x83, 0x38, 0xFD, 0x25, 0x01, 0x09, 0xE0, 0x90, 0x17, 0x28,
  0x25, 0x77, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_info_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_info_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_info 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_action_info_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xD0, 0x0B, 0xD0, 0x32, 0x0B, 0xD0, 0x09, 0xD0, 0xB2, 0xFF, 0x10, 0x2E, 0x00, 0x8E, 0x00, 0x2E,
  0x00, 0x5E, 0x02, 0x1E, 0x00, 0x5E, 0x20, 0xBD, 0x00, 0x5D, 0x0B, 0x20, 0x3D, 0x00, 0xBD, 0x03,
  0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_info() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_info_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_input 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_input_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x2F, 0x17,
  0x38, 0x32, 0xF3, 0x01, 0x50, 0xD0, 0x44, 0x81, 0x2F, 0x31, 0x80, 0x29, 0x81, 0xEF, 0x43, 0x81,
  0x2F, 0x31, 0x80, 0x29, 0x81, 0xEF, 0x43, 0x83, 0x2F, 0x30, 0x15, 0x0D, 0x04, 0x48, 0x42, 0xF3,
  0x2F, 0x17, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90,
  0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_input() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_input_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_install_desktop 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_action_install_desktop_data[] PROGMEM = {
  0x10, 0x18, 0x03, 0x32, 0x00, 0x13, 0x01, 0x0E, 0xE0, 0xD2, 0x09, 0x0A, 0x38, 0x13, 0xF2, 0x71,
  0x09, 0x0B, 0x38, 0x13, 0xF2, 0x71, 0x09, 0x0B, 0x38, 0x13, 0xF2, 0x68, 0x90, 0x98, 0x9B, 0x7A,
  0x03, 0xF2, 0x68, 0x90, 0x5F, 0xEE, 0xF6, 0x03, 0xF2, 0x70, 0x5A, 0x06, 0x28, 0x13, 0xF2, 0x71,
  0x86, 0x44, 0x01, 0x03, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x73, 0x82, 0x2F, 0x31, 0x98, 0x09,
  0x0D, 0x98, 0x51, 0x04, 0x77, 0x7D, 0xC8, 0x3D, 0x77, 0x74, 0x60, 0xAC, 0x0A, 0x73, 0x84, 0x23,
  0x33, 0x32, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_install_desktop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_install_desktop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_install_mobile 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_action_install_mobile_data[] PROGMEM = {
  0x28, 0x02, 0x16, 0x02, 0x0E, 0xD0, 0xC6, 0x06, 0xE0, 0xC2, 0x02, 0x30, 0x6E, 0x0C, 0x20, 0xE0,
  0x52, 0x06, 0x98, 0x01, 0x70, 0x62, 0x0E, 0x06, 0x20, 0x60, 0xE7, 0x10, 0xE0, 0x62, 0x06, 0x0E,
  0x68, 0x6C, 0x4E, 0x6A, 0x66, 0xE6, 0x86, 0xAE, 0xFE, 0xE2, 0x6E, 0x78, 0x5A, 0xFE, 0x20, 0x6E,
  0x71, 0x06, 0x02, 0x20, 0x60, 0xE7, 0x50, 0x60, 0xE7, 0x10, 0x30, 0x12, 0x06, 0x0E, 0x71, 0x0E,
  0x06, 0x20, 0x69, 0x80, 0x47, 0x90, 0x62, 0x06, 0xFB, 0x06, 0x20, 0x6F, 0xB0, 0x62, 0x02, 0x0E,
  0xF9, 0x0E, 0x02, 0x48, 0x04, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_install_mobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_install_mobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_integration_instructions 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_integration_instructions_data[] PROGMEM = {
  0x58, 0x21, 0x88, 0x16, 0x89, 0x42, 0x33, 0x3A, 0xEE, 0xA3, 0x33, 0x20, 0x2D, 0x00, 0xCD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xC0, 0xEA, 0x0E, 0xC0, 0x04, 0xB0, 0x60, 0x2A, 0x02, 0x06,
  0xB0, 0x04, 0xA8, 0x16, 0x09, 0xA8, 0x19, 0x06, 0xA0, 0x04, 0xA8, 0x16, 0x09, 0xA8, 0x19, 0x06,
  0xA0, 0x04, 0xB0, 0x60, 0x2A, 0x02, 0x06, 0xB0, 0x04, 0xC0, 0xEA, 0x0E, 0xC0, 0x04, 0xFD, 0x00,
  0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_integration_instructions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_integration_instructions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_invert_colors 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_action_invert_colors_data[] PROGMEM = {
  0x50, 0x0A, 0x72, 0x82, 0xAE, 0xFA, 0x78, 0x1A, 0xE4, 0xA0, 0xA5, 0x81, 0x9F, 0x41, 0xB0, 0x93,
  0x81, 0x8F, 0x42, 0xC8, 0x38, 0x02, 0xF7, 0x3D, 0x81, 0x27, 0xE4, 0xD8, 0x17, 0x9C, 0x4D, 0x81,
  0x98, 0xD4, 0xD8, 0x28, 0x4F, 0x23, 0xD8, 0x24, 0x0D, 0xC3, 0xC0, 0xD2, 0x83, 0x2E, 0xD5, 0x2B,
  0x0E, 0x02, 0x30, 0x20, 0xAC, 0x0A, 0x02, 0x68, 0x21, 0x33, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_invert_colors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_invert_colors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_javascript 18x18, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_round_18_action_javascript_data[] PROGMEM = {
  0x28, 0x48, 0x05, 0xBB, 0x12, 0x8A, 0x4C, 0x18, 0x96, 0x08, 0x5C, 0x13, 0x6D, 0x26, 0xBB, 0x05,
  0xBB, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_javascript() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 7, 12, 10), Box(0, 0, 17, 17),
      ic_round_18_action_javascript_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_join_full 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_join_full_data[] PROGMEM = {
  0x28, 0x35, 0xBD, 0xD9, 0x28, 0x39, 0xDD, 0xB5, 0x30, 0x9C, 0x82, 0x84, 0x48, 0xC8, 0x19, 0x06,
  0xC8, 0x4D, 0x2E, 0xE2, 0xDC, 0x06, 0x0D, 0xC0, 0x08, 0xA0, 0x08, 0xC0, 0xDD, 0x05, 0x0B, 0xA0,
  0xB0, 0x5F, 0xB0, 0x50, 0xBA, 0x0B, 0x05, 0xD0, 0xDC, 0x00, 0x8A, 0x00, 0x8C, 0x0D, 0x06, 0xC8,
  0x4D, 0x2E, 0xE2, 0xDC, 0x81, 0x60, 0x9C, 0x82, 0x84, 0x48, 0xC0, 0x93, 0x83, 0x5B, 0xDD, 0x92,
  0x83, 0x9D, 0xDB, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_join_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_join_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_join_inner 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_join_inner_data[] PROGMEM = {
  0x28, 0x35, 0xBD, 0xD9, 0x28, 0x39, 0xDD, 0xB5, 0x38, 0xA0, 0x9F, 0xB7, 0x76, 0x44, 0x67, 0x7B,
  0xF9, 0x06, 0xF5, 0x38, 0x21, 0xEE, 0x13, 0x83, 0x5F, 0x6D, 0x94, 0x08, 0xA0, 0x84, 0x82, 0x9D,
  0xF5, 0x40, 0xBA, 0x0B, 0x40, 0x5A, 0x05, 0x40, 0xBA, 0x0B, 0x48, 0x25, 0xFD, 0x94, 0x08, 0xA0,
  0x84, 0x83, 0x9D, 0x6F, 0x53, 0x82, 0x1E, 0xE1, 0x38, 0xA0, 0x5F, 0x60, 0x9F, 0xB7, 0x76, 0x44,
  0x67, 0x7B, 0xF9, 0x38, 0x35, 0xBD, 0xD9, 0x28, 0x39, 0xDE, 0xB5, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_join_inner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_join_inner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_join_left 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_join_left_data[] PROGMEM = {
  0x28, 0x35, 0xBD, 0xD9, 0x28, 0x39, 0xDD, 0xB5, 0x30, 0x9C, 0x89, 0x18, 0x44, 0x67, 0x7B, 0xF9,
  0x06, 0xC8, 0x3D, 0x2E, 0xE1, 0x38, 0x25, 0xF6, 0xDC, 0x00, 0x8A, 0x08, 0x40, 0x90, 0xDD, 0x05,
  0x0B, 0xA0, 0xB4, 0x05, 0xE0, 0x50, 0xBA, 0x0B, 0x48, 0x15, 0xFD, 0xC0, 0x08, 0xA0, 0x84, 0x81,
  0x9D, 0x6C, 0x83, 0xD2, 0xEE, 0x13, 0x83, 0x5F, 0x60, 0x9C, 0x87, 0x84, 0x46, 0x77, 0xBF, 0x93,
  0x83, 0x5B, 0xDD, 0x92, 0x83, 0x9D, 0xEB, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_join_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_join_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_join_right 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_join_right_data[] PROGMEM = {
  0x28, 0x35, 0xBD, 0xD9, 0x28, 0x39, 0xDD, 0xB5, 0x38, 0x79, 0xFB, 0x77, 0x64, 0x48, 0xC8, 0x39,
  0x06, 0xF5, 0x38, 0x31, 0xEE, 0x2D, 0xC8, 0x16, 0xD9, 0x40, 0x8A, 0x00, 0x8C, 0x81, 0xDF, 0x54,
  0x0B, 0xA0, 0xB0, 0x5E, 0x05, 0x40, 0xBA, 0x0B, 0x05, 0xD0, 0xD0, 0x94, 0x08, 0xA0, 0x08, 0xC8,
  0x2D, 0x6F, 0x53, 0x83, 0x1E, 0xE2, 0xDC, 0x89, 0x16, 0x09, 0xFB, 0x77, 0x64, 0x48, 0xC0, 0x93,
  0x83, 0x5B, 0xDD, 0x92, 0x83, 0x9D, 0xDB, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_join_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_join_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_label_important_outline 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_label_important_outline_data[] PROGMEM = {
  0x02, 0x80, 0x33, 0x02, 0x4F, 0xA0, 0x83, 0x81, 0x9F, 0x58, 0x01, 0x38, 0x19, 0xF4, 0x28, 0x11,
  0xEB, 0x68, 0x1D, 0xD1, 0x28, 0x15, 0xF7, 0x58, 0x13, 0xFA, 0x38, 0x1A, 0xF2, 0x58, 0x17, 0xF5,
  0x28, 0x1A, 0xF2, 0x58, 0x57, 0xF5, 0x05, 0xF7, 0x58, 0x53, 0xFA, 0x01, 0xEB, 0x68, 0x5D, 0xD1,
  0x09, 0xF5, 0x80, 0x13, 0x81, 0x9F, 0x42, 0xFA, 0x08, 0x30, 0x28, 0x03, 0x30, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_label_important_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_label_important_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_label_important 18x18, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_round_18_action_label_important_data[] PROGMEM = {
  0x01, 0x80, 0x27, 0x06, 0x30, 0x5F, 0x07, 0x30, 0xBF, 0x04, 0x20, 0x10, 0xDE, 0x0E, 0x02, 0x20,
  0x3F, 0x0C, 0x20, 0x3F, 0x82, 0xC0, 0x1D, 0xE8, 0x2E, 0x20, 0xBF, 0x81, 0x40, 0x5F, 0x07, 0x20,
  0x18, 0x02, 0x70, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_label_important() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 14, 13), Box(0, 0, 17, 17),
      ic_round_18_action_label_important_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_label_off 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_label_off_data[] PROGMEM = {
  0x0E, 0x07, 0x74, 0x89, 0x06, 0xF7, 0x02, 0x77, 0x77, 0x54, 0x83, 0x8F, 0x70, 0x9C, 0x07, 0x30,
  0x6A, 0x81, 0x70, 0x9C, 0x04, 0x20, 0x6B, 0x81, 0x70, 0x9B, 0x82, 0xE2, 0x06, 0xC8, 0x17, 0x09,
  0xB8, 0x1B, 0x06, 0xD8, 0x17, 0x09, 0xA8, 0x1B, 0x06, 0xE8, 0x57, 0x09, 0xE2, 0x06, 0xF8, 0x17,
  0x02, 0x20, 0x4F, 0x90, 0x74, 0x05, 0x80, 0x27, 0x81, 0x9F, 0x77, 0x48, 0x16, 0xF7, 0x74, 0x06,
  0x0E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_label_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_label_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_label_outline 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_action_label_outline_data[] PROGMEM = {
  0x18, 0x05, 0x15, 0x06, 0xFA, 0x0D, 0x03, 0x38, 0x1B, 0xF6, 0x80, 0x33, 0x00, 0xD3, 0x00, 0xB7,
  0x18, 0x13, 0xF9, 0x20, 0x0B, 0x72, 0x84, 0x7F, 0x50, 0xBB, 0x73, 0x83, 0xCE, 0x1B, 0xB7, 0x38,
  0x3A, 0xF1, 0xBB, 0x72, 0x84, 0x6F, 0x60, 0xBB, 0x71, 0x81, 0x2F, 0xA2, 0x81, 0xBE, 0x58, 0x03,
  0x38, 0x1C, 0xE1, 0x20, 0x7F, 0xA0, 0xE0, 0x44, 0x02, 0x80, 0x43, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_label_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_label_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_label 18x18, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_18_action_label_data[] PROGMEM = {
  0x10, 0x58, 0x02, 0x70, 0x53, 0x04, 0xF9, 0x07, 0x20, 0x6F, 0xA8, 0x14, 0x06, 0xFA, 0x81, 0xE2,
  0x6F, 0xB0, 0xB0, 0x6F, 0xB0, 0xB0, 0x6F, 0xA8, 0x1E, 0x26, 0xFA, 0x81, 0x40, 0x4F, 0x90, 0x73,
  0x05, 0x80, 0x27, 0x05, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 13), Box(0, 0, 17, 17),
      ic_round_18_action_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_language 18x18, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_round_18_action_language_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0xDC, 0xCD, 0xBF, 0x95, 0x89,
  0x29, 0xF5, 0x1F, 0x55, 0xF1, 0x5F, 0x93, 0x83, 0x3F, 0x50, 0x59, 0x29, 0x83, 0x50, 0x5F, 0x32,
  0x89, 0x4B, 0xFB, 0xBD, 0xFB, 0xBF, 0xDB, 0xBF, 0xB2, 0x98, 0x97, 0xB9, 0x9D, 0xD9, 0x9D, 0xD9,
  0x9B, 0xF0, 0x2F, 0x32, 0x00, 0xA2, 0x00, 0xA2, 0x84, 0x3F, 0x22, 0xF3, 0x20, 0x0A, 0x20, 0x0A,
  0x28, 0x97, 0x3F, 0x20, 0xFB, 0x99, 0xDD, 0x99, 0xDD, 0x99, 0xB9, 0x28, 0x94, 0xBF, 0xBB, 0xDF,
  0xBB, 0xFD, 0xBB, 0xFB, 0x28, 0x33, 0xF5, 0x05, 0x92, 0x98, 0x35, 0x05, 0xF3, 0x38, 0x92, 0x9F,
  0x51, 0xF5, 0x5F, 0x15, 0xF9, 0x58, 0x90, 0x9F, 0xBD, 0xCC, 0xDB, 0xF9, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_language() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_language_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_launch 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_launch_data[] PROGMEM = {
  0x18, 0x42, 0x33, 0x33, 0x22, 0x84, 0x13, 0x33, 0x02, 0xD0, 0xD2, 0x05, 0xB0, 0x04, 0x97, 0x10,
  0xAA, 0x00, 0x49, 0x78, 0x47, 0xFA, 0xF4, 0x49, 0x68, 0x57, 0xF7, 0x05, 0x14, 0x95, 0x81, 0x7F,
  0x74, 0x04, 0x94, 0x81, 0x7F, 0x75, 0x04, 0x93, 0x81, 0x7F, 0x74, 0x81, 0xD3, 0x49, 0x28, 0x14,
  0xF7, 0x59, 0x00, 0x49, 0x20, 0x10, 0x46, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40,
  0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_launch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_launch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_leaderboard 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_leaderboard_data[] PROGMEM = {
  0x68, 0x29, 0xBB, 0x97, 0x40, 0x1C, 0x01, 0x73, 0x01, 0xC0, 0x17, 0x30, 0x1C, 0x01, 0x60, 0xF3,
  0x10, 0x1C, 0x01, 0x50, 0x6B, 0x08, 0x01, 0xC0, 0x15, 0x07, 0xB0, 0x90, 0x1C, 0x85, 0x14, 0xBB,
  0xB3, 0x7B, 0x09, 0x01, 0xC0, 0x10, 0x9B, 0x00, 0x7B, 0x09, 0x01, 0xC0, 0x10, 0x9B, 0x00, 0x7B,
  0x09, 0x01, 0xC0, 0x10, 0x9B, 0x00, 0x7B, 0x09, 0x01, 0xC0, 0x10, 0x9B, 0x00, 0x7B, 0x09, 0x01,
  0xC0, 0x10, 0x9B, 0x00, 0x7B, 0x09, 0x01, 0xC0, 0x10, 0x9B, 0x89, 0x77, 0x3B, 0xBB, 0x40, 0x9B,
  0xB9, 0x04, 0xBB, 0xB3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_leaderboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_leaderboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lightbulb_circle 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_lightbulb_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9B, 0x82, 0xD9, 0x9D,
  0xB0, 0x93, 0x03, 0xB0, 0x94, 0x09, 0xB0, 0x32, 0x0B, 0xA0, 0xC6, 0x0C, 0xA0, 0xB2, 0xB0, 0x86,
  0x08, 0xB1, 0x02, 0xB0, 0x66, 0x06, 0xB0, 0x02, 0xB0, 0xB6, 0x0B, 0xB0, 0x21, 0xC8, 0x46, 0x33,
  0x33, 0x6C, 0x20, 0xBB, 0x84, 0xE7, 0x77, 0x7E, 0xB0, 0xB2, 0x03, 0xB8, 0x4E, 0x99, 0x99, 0xEB,
  0x03, 0x30, 0x9C, 0x00, 0x5C, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40,
  0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lightbulb_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_lightbulb_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lightbulb_outline 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_action_lightbulb_outline_data[] PROGMEM = {
  0x48, 0x23, 0x77, 0x36, 0x02, 0x0C, 0xC0, 0xC0, 0x23, 0x89, 0x02, 0xEE, 0x51, 0x15, 0xEE, 0x22,
  0x81, 0xBE, 0x24, 0x85, 0x2E, 0xB0, 0x1F, 0x86, 0x84, 0x8F, 0x13, 0xF4, 0x68, 0x44, 0xF3, 0x2F,
  0x56, 0x84, 0x5F, 0x20, 0xDB, 0x60, 0xB0, 0xD2, 0x81, 0x6F, 0x74, 0x81, 0x7F, 0x63, 0x81, 0x9F,
  0x62, 0x81, 0x6F, 0x95, 0x90, 0x72, 0x07, 0x96, 0xE6, 0x84, 0x57, 0x77, 0x75, 0x77, 0x40, 0x3C,
  0x03, 0x78, 0x26, 0x77, 0x64,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lightbulb_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_lightbulb_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lightbulb 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_action_lightbulb_data[] PROGMEM = {
  0x50, 0x02, 0x71, 0x08, 0x0E, 0xA0, 0xE0, 0x84, 0x01, 0x0C, 0xE0, 0xC0, 0x12, 0x09, 0xF9, 0x81,
  0x90, 0x1F, 0xB0, 0x10, 0x5F, 0xB0, 0x05, 0xFB, 0x05, 0x03, 0xFB, 0x81, 0x30, 0xDF, 0x90, 0xD2,
  0x03, 0xF9, 0x03, 0x30, 0x48, 0x02, 0xB0, 0x45, 0x84, 0x25, 0x55, 0x52, 0x60, 0x7C, 0x07, 0x71,
  0x00, 0x17, 0x28, 0x22, 0xEE, 0x27, 0x20, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lightbulb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_lightbulb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_line_style 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_action_line_style_data[] PROGMEM = {
  0x01, 0x80, 0x90, 0x50, 0x10, 0x4F, 0xD0, 0x04, 0xFD, 0x04, 0x18, 0x09, 0x03, 0x28, 0x01, 0x52,
  0x80, 0x15, 0x10, 0x2D, 0x00, 0x3D, 0x02, 0x77, 0x8B, 0x21, 0x99, 0x60, 0x39, 0x93, 0x06, 0x99,
  0x11, 0xAB, 0x70, 0x4B, 0xB4, 0x07, 0xBA, 0x17, 0x78, 0xB1, 0x2C, 0x04, 0xA0, 0x77, 0x0A, 0x40,
  0xC2, 0x04, 0x01, 0x30, 0x22, 0x03, 0x10, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_line_style() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_line_style_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_line_weight 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_action_line_weight_data[] PROGMEM = {
  0x10, 0x48, 0x06, 0x58, 0x14, 0x03, 0xFD, 0x00, 0x3F, 0xD0, 0x31, 0x80, 0x90, 0x32, 0x04, 0x80,
  0x65, 0x81, 0x40, 0x3F, 0xD8, 0x12, 0x06, 0x80, 0x67, 0x06, 0x28, 0x09, 0x03, 0x10, 0x2F, 0xD0,
  0x31, 0x80, 0x90, 0x11, 0x01, 0x80, 0x90, 0x70, 0x11, 0x80, 0x90, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_line_weight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_line_weight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_list 18x18, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_18_action_list_data[] PROGMEM = {
  0x82, 0x17, 0x03, 0x80, 0x59, 0x83, 0x11, 0x90, 0x48, 0x05, 0xB0, 0x17, 0x78, 0x21, 0x80, 0x48,
  0x05, 0x98, 0x31, 0x18, 0x04, 0x80, 0x59, 0x01, 0x77, 0x82, 0x19, 0x04, 0x80, 0x5B, 0x83, 0x11,
  0x70, 0x38, 0x05, 0x90, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_action_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lock_clock 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_18_action_lock_clock_data[] PROGMEM = {
  0x30, 0x10, 0xBA, 0x0B, 0x01, 0x71, 0x84, 0xDC, 0x55, 0xCD, 0x78, 0x16, 0xE1, 0x28, 0x11, 0xE6,
  0x60, 0x80, 0xB4, 0x0B, 0x08, 0x60, 0x90, 0xB4, 0x0B, 0x09, 0x58, 0x90, 0x8D, 0xEB, 0xBB, 0xBE,
  0xD8, 0x30, 0x5F, 0xB0, 0x52, 0x06, 0xE8, 0x3E, 0xA9, 0xA5, 0x20, 0x6D, 0x0A, 0x01, 0x60, 0x6C,
  0x85, 0xA0, 0x5D, 0xFE, 0x72, 0x06, 0xC0, 0x10, 0x4A, 0x0D, 0xA8, 0x17, 0x06, 0xB8, 0x1C, 0x0C,
  0xA0, 0x20, 0xEA, 0x10, 0x6B, 0x81, 0xA0, 0xEA, 0x03, 0x0B, 0xA0, 0x20, 0x6B, 0x81, 0xC0, 0xCA,
  0x0D, 0x03, 0xA1, 0x02, 0xC0, 0x20, 0x4D, 0x07, 0x28, 0x91, 0x13, 0x33, 0x10, 0x5D, 0xFE, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lock_clock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_lock_clock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lock_open 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_lock_open_data[] PROGMEM = {
  0x30, 0x20, 0xBA, 0x0A, 0x01, 0x68, 0x4D, 0xC5, 0x5D, 0xD5, 0x81, 0x6E, 0x12, 0x81, 0x1E, 0x54,
  0x02, 0x04, 0x40, 0xC0, 0x87, 0x30, 0xB0, 0x93, 0x08, 0x80, 0x2B, 0x83, 0xED, 0x80, 0x5F, 0xB0,
  0x50, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x6B, 0x82, 0xD1, 0x1D, 0xB0, 0x06, 0xB0, 0xB2, 0x0B, 0xB0,
  0x06, 0xC0, 0x08, 0xC0, 0x06, 0xFB, 0x00, 0x6F, 0xB0, 0x60, 0x2F, 0xB8, 0x12, 0x01, 0x80, 0x43,
  0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lock_open() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_lock_open_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lock_outline 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_lock_outline_data[] PROGMEM = {
  0x50, 0x02, 0x71, 0x03, 0x0D, 0xA0, 0xD0, 0x35, 0x86, 0x2E, 0xC5, 0x5C, 0xE2, 0x48, 0x18, 0xE1,
  0x28, 0x11, 0xE8, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x40, 0x0B, 0x20, 0x8F, 0xB8, 0x18, 0xFD,
  0x80, 0x47, 0x0D, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x30, 0x01, 0x30, 0x7A, 0x07, 0x20, 0x3A, 0x03,
  0x20, 0x7A, 0x07, 0x20, 0x6A, 0x06, 0x20, 0x7A, 0x07, 0x30, 0x09, 0x30, 0x7A, 0x07, 0x71, 0x07,
  0xA0, 0xA7, 0x18, 0x1A, 0xFD, 0xFB, 0x0D, 0x02, 0x80, 0x67, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lock_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_lock_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lock_person 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_action_lock_person_data[] PROGMEM = {
  0x30, 0x10, 0xBA, 0x0B, 0x01, 0x71, 0x84, 0xDC, 0x55, 0xCD, 0x78, 0x16, 0xE1, 0x28, 0x11, 0xE6,
  0x60, 0x80, 0xB4, 0x0B, 0x08, 0x60, 0x90, 0xB4, 0x0B, 0x09, 0x58, 0x90, 0x8D, 0xEB, 0xBB, 0xBE,
  0xD8, 0x30, 0x5F, 0xB0, 0x52, 0x06, 0xF8, 0x2E, 0xA9, 0x32, 0x06, 0xE0, 0x96, 0x06, 0xD8, 0x79,
  0x06, 0xDD, 0xD6, 0x06, 0xC8, 0x90, 0xE0, 0x6F, 0x50, 0x5F, 0x66, 0xC8, 0x90, 0xA0, 0xDF, 0x30,
  0x3F, 0xD6, 0xC0, 0x91, 0xA8, 0x1D, 0x8D, 0xA0, 0x6C, 0x89, 0x0A, 0x0D, 0xB5, 0x35, 0xBD, 0x2C,
  0x8A, 0x4E, 0x16, 0xA1, 0x01, 0xA6, 0x01, 0x33, 0x33, 0x10, 0x6D, 0xDD, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lock_person() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_lock_person_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lock 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_action_lock_data[] PROGMEM = {
  0x30, 0x10, 0xBA, 0x0B, 0x01, 0x68, 0x4D, 0xC5, 0x5C, 0xD5, 0x81, 0x6E, 0x12, 0x81, 0x1E, 0x64,
  0x08, 0x0B, 0x40, 0xB0, 0x84, 0x09, 0x0B, 0x40, 0xB0, 0x93, 0x89, 0x28, 0xDE, 0xBB, 0xBB, 0xED,
  0x80, 0x5F, 0xB0, 0x50, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x6B, 0x82, 0xD1, 0x1D, 0xB0, 0x06, 0xB0,
  0xB2, 0x0B, 0xB0, 0x06, 0xC0, 0x08, 0xC0, 0x06, 0xFB, 0x00, 0x6F, 0xB0, 0x60, 0x2F, 0xB8, 0x12,
  0x01, 0x80, 0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_lock_reset 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_action_lock_reset_data[] PROGMEM = {
  0x68, 0x11, 0x33, 0x73, 0x03, 0x0B, 0xC0, 0xB0, 0x26, 0x89, 0x05, 0xFB, 0x51, 0x15, 0xBE, 0x54,
  0x81, 0x3F, 0x86, 0x81, 0x8E, 0x23, 0x00, 0xB3, 0x00, 0x83, 0x00, 0xB2, 0x81, 0x1F, 0x42, 0x82,
  0x46, 0x64, 0x20, 0x49, 0x28, 0x13, 0xF1, 0x28, 0x2A, 0xBB, 0xA2, 0x82, 0x1F, 0x38, 0xB0, 0x41,
  0xC2, 0x85, 0x1F, 0x30, 0xCF, 0x82, 0xC2, 0x81, 0x4F, 0x12, 0x05, 0x38, 0x29, 0xBB, 0x92, 0x00,
  0xB5, 0x04, 0x68, 0x18, 0xF3, 0x48, 0x90, 0x3F, 0xB4, 0x11, 0x4B, 0xF5, 0x60, 0x30, 0xBC, 0x0B,
  0x03, 0x72, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_lock_reset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_lock_reset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_login 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_login_data[] PROGMEM = {
  0x78, 0x01, 0x50, 0x47, 0x18, 0x56, 0x77, 0x77, 0xC3, 0x75, 0x09, 0x04, 0x60, 0xA0, 0x34, 0x09,
  0x04, 0x68, 0x12, 0xD3, 0x38, 0x19, 0x41, 0x80, 0x27, 0x81, 0xAE, 0x32, 0x81, 0x94, 0x18, 0x02,
  0x78, 0x1A, 0xE3, 0x20, 0x90, 0x46, 0x81, 0x2D, 0x33, 0x09, 0x04, 0x60, 0xA0, 0x34, 0x09, 0x04,
  0x75, 0x09, 0x04, 0x78, 0x56, 0x77, 0x77, 0xC3, 0x78, 0x01, 0x50, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_login() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_login_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_logout 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_action_logout_data[] PROGMEM = {
  0x18, 0x42, 0x33, 0x33, 0x26, 0x02, 0xD0, 0xD6, 0x04, 0x97, 0x40, 0x49, 0x74, 0x04, 0x97, 0x40,
  0x49, 0x71, 0x82, 0x5B, 0x04, 0x93, 0x87, 0x69, 0x99, 0x9B, 0xFB, 0x49, 0x38, 0x76, 0x99, 0x99,
  0xBF, 0xB4, 0x97, 0x18, 0x25, 0xB0, 0x49, 0x74, 0x04, 0x97, 0x40, 0x49, 0x74, 0x02, 0xD0, 0xD7,
  0x84, 0x23, 0x33, 0x32, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_logout() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_logout_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_loyalty 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_loyalty_data[] PROGMEM = {
  0x28, 0x01, 0x30, 0x27, 0x20, 0xEE, 0x0A, 0x70, 0x3A, 0x00, 0xEC, 0x0A, 0x68, 0x33, 0xFE, 0x01,
  0xD0, 0xA5, 0x83, 0x3F, 0xE1, 0x2E, 0x0A, 0x40, 0x3F, 0xC0, 0xA3, 0x03, 0xFD, 0x0A, 0x20, 0x2C,
  0x85, 0xE3, 0x3D, 0x52, 0xDA, 0x0A, 0x20, 0xAB, 0x0A, 0x50, 0x8B, 0x02, 0x20, 0xAA, 0x0E, 0x03,
  0x30, 0x10, 0xDA, 0x0B, 0x40, 0xAA, 0x83, 0xE3, 0x01, 0xDA, 0x0C, 0x60, 0xAA, 0x81, 0xE8, 0xDA,
  0x0C, 0x71, 0x0A, 0xD0, 0xC7, 0x30, 0xAB, 0x0C, 0x75, 0x81, 0xAF, 0xB7, 0x70, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_loyalty() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_loyalty_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_manage_accounts 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_manage_accounts_data[] PROGMEM = {
  0x58, 0x14, 0x51, 0x74, 0x0B, 0xA0, 0xE0, 0x37, 0x20, 0x5C, 0x0B, 0x72, 0x06, 0xC0, 0xD7, 0x20,
  0x2C, 0x08, 0x73, 0x82, 0x5D, 0xE9, 0x28, 0x11, 0xD4, 0x71, 0x87, 0x10, 0x36, 0xBF, 0xC6, 0x52,
  0x89, 0x54, 0xAE, 0xFC, 0x09, 0xFD, 0x6B, 0xFC, 0x0A, 0xC8, 0x90, 0xA0, 0x1F, 0x50, 0x1F, 0x42,
  0xD8, 0x90, 0xB0, 0x5F, 0x90, 0x6F, 0x82, 0xD8, 0x2E, 0x18, 0xDB, 0x82, 0xCB, 0x04, 0x80, 0x15,
  0x02, 0x28, 0x13, 0xF6, 0x76, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_manage_accounts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_manage_accounts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_manage_history 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_round_18_action_manage_history_data[] PROGMEM = {
  0x10, 0x23, 0x82, 0x13, 0x31, 0x78, 0x34, 0xF0, 0x3B, 0xC0, 0xB0, 0x35, 0x89, 0x24, 0xF6, 0xFB,
  0x41, 0x14, 0xBF, 0x54, 0x04, 0xA8, 0x3A, 0x10, 0x44, 0x28, 0x18, 0xF3, 0x30, 0x3C, 0x81, 0x1A,
  0xA3, 0x00, 0xB4, 0x85, 0x23, 0x32, 0x0A, 0xA3, 0x81, 0x4F, 0x17, 0x10, 0xA0, 0xC3, 0x81, 0x1F,
  0x32, 0x81, 0x2D, 0x13, 0x81, 0x3E, 0xA7, 0x81, 0x1F, 0x54, 0x03, 0x09, 0x20, 0x20, 0x94, 0x0B,
  0x0C, 0x68, 0x91, 0x22, 0xAF, 0x82, 0x10, 0x3F, 0x85, 0x85, 0xCF, 0xD9, 0xEF, 0x92, 0x83, 0x5F,
  0xC5, 0x12, 0x85, 0x5F, 0x30, 0x5F, 0x23, 0x89, 0x33, 0xBF, 0xE1, 0x05, 0xF3, 0x06, 0xF2, 0x58,
  0x61, 0x31, 0x0C, 0xFE, 0xBA, 0x09, 0x72, 0x85, 0x11, 0x9F, 0x61, 0x17, 0x40, 0x20, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_manage_history() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_action_manage_history_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_mark_as_unread 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_mark_as_unread_data[] PROGMEM = {
  0x60, 0x17, 0x68, 0x33, 0xAF, 0xC5, 0x72, 0x87, 0x4B, 0xFC, 0x6A, 0xFD, 0x66, 0x82, 0xBF, 0xB4,
  0x38, 0x32, 0x9F, 0xE2, 0x38, 0x12, 0xF4, 0x76, 0x83, 0x3F, 0x21, 0x98, 0x05, 0xB8, 0x47, 0x03,
  0xF2, 0x7F, 0xC8, 0x62, 0x3F, 0x27, 0xE3, 0x8C, 0x8A, 0x7E, 0x65, 0xF3, 0x3F, 0x27, 0xF6, 0x02,
  0xAE, 0x70, 0x1A, 0xF3, 0x3F, 0x27, 0xA0, 0xD0, 0x53, 0x07, 0x0E, 0xA8, 0x33, 0x2F, 0x27, 0xC8,
  0x1B, 0x8D, 0xC8, 0x33, 0x05, 0x17, 0xFC, 0x03, 0x30, 0x7F, 0xC0, 0x33, 0x05, 0xFB, 0x0E, 0x01,
  0x48, 0x06, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_mark_as_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_mark_as_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_markunread_mailbox 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_action_markunread_mailbox_data[] PROGMEM = {
  0x48, 0x00, 0x30, 0x27, 0x30, 0x7C, 0x0D, 0x73, 0x07, 0xC0, 0xD7, 0x38, 0x47, 0xE7, 0x77, 0x67,
  0x30, 0x70, 0xD7, 0x58, 0x47, 0xBD, 0xD0, 0x98, 0x03, 0xB8, 0x17, 0x02, 0xB8, 0x1D, 0x0C, 0xF9,
  0x02, 0x03, 0xB8, 0x1D, 0x0C, 0xF9, 0x00, 0x3B, 0x81, 0xE3, 0xEF, 0x90, 0x03, 0xFF, 0x00, 0x3F,
  0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x81, 0x30, 0xEF, 0xD0, 0xE3, 0x80, 0x90, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_markunread_mailbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_markunread_mailbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_maximize 18x18, 4-bit Alpha,  RLE, 7 bytes.
static const unsigned char ic_round_18_action_maximize_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x2F, 0xD0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_maximize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 3), Box(0, 0, 17, 17),
      ic_round_18_action_maximize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_mediation 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_mediation_data[] PROGMEM = {
  0x18, 0x25, 0xEF, 0x77, 0x30, 0x1C, 0x02, 0x72, 0x01, 0xC0, 0x97, 0x30, 0xAA, 0x82, 0xCE, 0xD1,
  0x72, 0x84, 0x44, 0x01, 0xDC, 0x72, 0x00, 0x22, 0x81, 0x3F, 0x57, 0x08, 0xA0, 0x92, 0x0B, 0x0A,
  0x38, 0x27, 0xA0, 0x1C, 0x89, 0x1A, 0x9C, 0xE9, 0x99, 0xCF, 0xA1, 0xC8, 0x92, 0xA9, 0xCE, 0x99,
  0x9C, 0xFA, 0x08, 0xA0, 0x92, 0x0B, 0x0A, 0x30, 0x70, 0xA3, 0x01, 0x02, 0x28, 0x13, 0xF5, 0x71,
  0x84, 0x44, 0x01, 0xDC, 0x71, 0x0A, 0xA8, 0x2C, 0xED, 0x17, 0x01, 0xC0, 0x97, 0x20, 0x1C, 0x02,
  0x73, 0x82, 0x6E, 0xF7, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_mediation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_mediation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_minimize 18x18, 4-bit Alpha,  RLE, 7 bytes.
static const unsigned char ic_round_18_action_minimize_data[] PROGMEM = {
  0x07, 0xE0, 0x70, 0x18, 0x02, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_minimize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 14, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_action_minimize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_model_training 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_model_training_data[] PROGMEM = {
  0x60, 0xA7, 0x28, 0x22, 0x5F, 0xA6, 0x84, 0x2B, 0xC9, 0xFB, 0x58, 0x12, 0xD5, 0x20, 0xB2, 0x05,
  0x02, 0x20, 0xB0, 0x56, 0x83, 0x5B, 0x02, 0xC2, 0x82, 0x3A, 0xA3, 0x28, 0x2C, 0x25, 0x92, 0x0E,
  0xA0, 0xE2, 0x84, 0x94, 0x49, 0x02, 0xC8, 0x42, 0x09, 0x42, 0xC2, 0x0D, 0xA0, 0xD2, 0x85, 0xC2,
  0x0B, 0x50, 0x3A, 0x82, 0x30, 0x4A, 0x20, 0x20, 0x52, 0x00, 0x72, 0x05, 0x02, 0x60, 0x05, 0x73,
  0x00, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_model_training() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_model_training_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_network_ping 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_action_network_ping_data[] PROGMEM = {
  0x02, 0x73, 0x84, 0x37, 0x20, 0xCB, 0x71, 0x02, 0xA8, 0x3E, 0x02, 0xEB, 0x70, 0x5B, 0x83, 0x20,
  0x2E, 0xB6, 0x0B, 0xA0, 0x93, 0x81, 0x2E, 0xB4, 0x81, 0xBE, 0x26, 0x81, 0x2E, 0xB2, 0x81, 0xBE,
  0x27, 0x18, 0x42, 0xEB, 0xBE, 0x27, 0x0F, 0x30, 0x6A, 0x06, 0x0F, 0x34, 0x04, 0xFB, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_network_ping() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_action_network_ping_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_new_label 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_action_new_label_data[] PROGMEM = {
  0x10, 0x58, 0x02, 0x70, 0x53, 0x04, 0xF9, 0x07, 0x20, 0x6F, 0xA8, 0x44, 0x03, 0x9A, 0xDE, 0x0E,
  0x02, 0x40, 0xBE, 0x0B, 0x28, 0x2D, 0x33, 0xCD, 0x86, 0xB1, 0x4F, 0x72, 0x0C, 0xB8, 0x1E, 0x2B,
  0xC1, 0x08, 0xB0, 0x42, 0x84, 0x2F, 0x61, 0x08, 0xA0, 0x74, 0x0C, 0x02, 0x28, 0x14, 0x75, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_new_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 13), Box(0, 0, 17, 17),
      ic_round_18_action_new_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_next_plan 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_next_plan_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x50, 0x5F, 0x90, 0x53, 0x03, 0xFB, 0x03,
  0x20, 0xBF, 0xB8, 0x1B, 0x01, 0xC8, 0x4E, 0xBB, 0xEF, 0xEA, 0x01, 0x03, 0xB8, 0x58, 0x15, 0x51,
  0x66, 0xA0, 0x03, 0xA8, 0x1A, 0x3E, 0xA8, 0x1A, 0x06, 0xA0, 0x30, 0x1A, 0x0D, 0x0E, 0xB8, 0x1A,
  0x9B, 0xA8, 0x11, 0x0B, 0xFB, 0x0B, 0x20, 0x3F, 0xB0, 0x33, 0x05, 0xF9, 0x05, 0x50, 0x30, 0xBC,
  0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_next_plan() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_next_plan_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_nightlight_round 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_action_nightlight_round_data[] PROGMEM = {
  0x60, 0xF1, 0x40, 0x60, 0xCA, 0x0C, 0x20, 0x10, 0xCB, 0x09, 0x30, 0xCB, 0x0A, 0x30, 0x8B, 0x0E,
  0x40, 0xEB, 0x07, 0x30, 0x4C, 0x03, 0x30, 0x7C, 0x01, 0x30, 0x6C, 0x01, 0x30, 0x4C, 0x03, 0x4C,
  0x07, 0x40, 0x8B, 0x0E, 0x50, 0xCB, 0x0A, 0x40, 0x10, 0xCB, 0x09, 0x50, 0x60, 0xCA, 0x0B, 0x68,
  0x11, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_nightlight_round() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 12, 16), Box(0, 0, 17, 17),
      ic_round_18_action_nightlight_round_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_no_accounts 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_round_18_action_no_accounts_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x86, 0x81, 0x5F, 0x93, 0x87, 0x3F, 0xBF, 0x40, 0xAE, 0x82, 0x81, 0x5F, 0x32, 0x89, 0x0B,
  0xB0, 0x9F, 0x40, 0xBF, 0x52, 0x00, 0xB2, 0x90, 0x52, 0x84, 0xBF, 0x40, 0xB9, 0x28, 0x45, 0xF0,
  0x2F, 0x32, 0x07, 0xA8, 0x14, 0x04, 0x28, 0x43, 0xF2, 0x2F, 0x33, 0x0C, 0xA0, 0x43, 0x84, 0x3F,
  0x20, 0xF5, 0x48, 0x23, 0x9F, 0x42, 0x05, 0x92, 0x00, 0xB2, 0x82, 0x59, 0xBB, 0xA8, 0x24, 0x0B,
  0xB2, 0x82, 0x3F, 0x8E, 0xF8, 0x18, 0xF3, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30,
  0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_no_accounts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_no_accounts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_noise_aware 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_round_18_action_noise_aware_data[] PROGMEM = {
  0x38, 0x62, 0x50, 0x88, 0x05, 0x26, 0x04, 0x08, 0x40, 0x80, 0x44, 0x06, 0x04, 0x28, 0x23, 0x65,
  0x12, 0x04, 0x06, 0x28, 0x92, 0x53, 0x08, 0xFE, 0xFE, 0x30, 0x35, 0x48, 0x54, 0xF5, 0x01, 0xCB,
  0x48, 0x3E, 0x30, 0x8D, 0x40, 0x12, 0x81, 0x3E, 0x12, 0x07, 0x0D, 0x20, 0x70, 0xA4, 0x00, 0x12,
  0x85, 0x2F, 0x80, 0xEF, 0x23, 0x81, 0x1E, 0x32, 0x83, 0x5F, 0x63, 0x53, 0x03, 0x0E, 0x58, 0x37,
  0xE0, 0x52, 0x50, 0x50, 0x32, 0x86, 0x1E, 0xEF, 0x50, 0x35, 0x20, 0x60, 0x43, 0x81, 0x27, 0x42,
  0x04, 0x06, 0x40, 0x40, 0x84, 0x08, 0x04, 0x68, 0x62, 0x50, 0x88, 0x05, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_noise_aware() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_noise_aware_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_noise_control_off 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_18_action_noise_control_off_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0A, 0xC0, 0xA0, 0x27, 0x18, 0x66, 0xB5, 0x33, 0x5B, 0x67, 0x38, 0x23,
  0x65, 0x17, 0x03, 0x06, 0x28, 0x48, 0xFE, 0xFE, 0x32, 0x06, 0x03, 0x28, 0x90, 0xAB, 0x04, 0xF5,
  0x01, 0xCA, 0x20, 0xB0, 0xA2, 0x98, 0x25, 0x08, 0xD4, 0x01, 0x28, 0x75, 0xF0, 0x2F, 0x30, 0x7D,
  0x20, 0x70, 0xA3, 0x89, 0x43, 0xF2, 0x2F, 0x30, 0x2F, 0x80, 0xEF, 0x22, 0x84, 0x3F, 0x20, 0xF5,
  0x28, 0x35, 0xF6, 0x35, 0x30, 0x59, 0x20, 0xA0, 0xB3, 0x83, 0x7E, 0x05, 0x22, 0x0B, 0x0A, 0x20,
  0x30, 0x63, 0x83, 0x1E, 0xEF, 0x52, 0x06, 0x02, 0x71, 0x81, 0x27, 0x47, 0x38, 0x66, 0xB5, 0x33,
  0x5B, 0x67, 0x10, 0x20, 0xAC, 0x0A, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_noise_control_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_noise_control_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_not_accessible 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_not_accessible_data[] PROGMEM = {
  0x50, 0x02, 0x50, 0x53, 0x02, 0xA0, 0x24, 0x0B, 0x07, 0x20, 0x3A, 0x03, 0x50, 0xB0, 0x72, 0x00,
  0x37, 0x83, 0xB7, 0x06, 0x67, 0x18, 0x3B, 0x74, 0xE9, 0x71, 0x84, 0xB7, 0x39, 0xC5, 0x48, 0x72,
  0xB3, 0xE7, 0x03, 0x81, 0x28, 0x51, 0xD4, 0x0D, 0xF7, 0x50, 0x50, 0x82, 0x82, 0x6B, 0xD7, 0x40,
  0x60, 0x73, 0x82, 0x14, 0xB7, 0x38, 0x12, 0xC1, 0x28, 0x39, 0x60, 0xB7, 0x38, 0x35, 0xDA, 0xC9,
  0x30, 0xB0, 0x53, 0x81, 0x13, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_not_accessible() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_not_accessible_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_note_add 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_note_add_data[] PROGMEM = {
  0x10, 0x18, 0x01, 0x30, 0x24, 0x02, 0xF0, 0x73, 0x06, 0xD8, 0x2D, 0x4F, 0x72, 0x06, 0xD8, 0x5D,
  0x04, 0xF7, 0x06, 0xE8, 0x41, 0x04, 0xF4, 0x6E, 0x84, 0xEB, 0xBE, 0x66, 0xFB, 0x00, 0x6C, 0x00,
  0x8C, 0x00, 0x6C, 0x00, 0x5C, 0x00, 0x6A, 0x08, 0x01, 0x20, 0x10, 0x8A, 0x00, 0x6A, 0x84, 0xC7,
  0x22, 0x7C, 0xA0, 0x06, 0xC0, 0x05, 0xC0, 0x06, 0xC0, 0x0C, 0xC0, 0x06, 0xFB, 0x06, 0x02, 0xFB,
  0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_note_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_note_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_not_started 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_not_started_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x50, 0x5F, 0x90, 0x53, 0x03, 0xFB, 0x03,
  0x20, 0xBB, 0x81, 0x8E, 0xDC, 0x81, 0xB0, 0x1C, 0x82, 0x3D, 0x06, 0xC0, 0x10, 0x3C, 0x03, 0x0D,
  0x20, 0x30, 0xEA, 0x00, 0x3C, 0x03, 0x0D, 0x20, 0x30, 0xEA, 0x03, 0x01, 0xC8, 0x23, 0xD0, 0x6C,
  0x81, 0x10, 0xBB, 0x81, 0x8E, 0xDC, 0x0B, 0x20, 0x3F, 0xB0, 0x33, 0x05, 0xF9, 0x05, 0x50, 0x30,
  0xBC, 0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_not_started() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_not_started_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_offline_bolt 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_action_offline_bolt_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xC0, 0xEB, 0x09, 0x50, 0x9D, 0x08, 0xC0,
  0x93, 0x03, 0xD0, 0x90, 0x6D, 0x03, 0x20, 0xBC, 0x81, 0xE1, 0x6D, 0x0B, 0x2D, 0x83, 0x80, 0x5D,
  0xEC, 0x10, 0x2C, 0x0E, 0x01, 0x30, 0x8C, 0x00, 0x2C, 0x08, 0x30, 0x10, 0xEC, 0x02, 0x1C, 0x83,
  0xED, 0x70, 0x8D, 0x20, 0xBD, 0x81, 0x81, 0xEC, 0x0B, 0x20, 0x3D, 0x00, 0x8D, 0x03, 0x30, 0x9C,
  0x09, 0x0E, 0xC0, 0x95, 0x09, 0xB0, 0xEC, 0x09, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_offline_bolt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_offline_bolt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_offline_pin 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_offline_pin_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xF9, 0x0C, 0xB0, 0x32, 0x0B, 0xF0, 0x40, 0x1B, 0x0B, 0x2C, 0x84, 0x5B, 0xF4, 0x0B, 0xC1, 0x02,
  0xC8, 0x35, 0x03, 0x0B, 0xD0, 0x02, 0xD8, 0x15, 0x1B, 0xE0, 0x21, 0xFF, 0x20, 0xBB, 0x84, 0x93,
  0x33, 0x39, 0xB0, 0xB2, 0x03, 0xB8, 0x4B, 0x55, 0x55, 0xBB, 0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09,
  0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_offline_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_offline_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_on_device_training 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_on_device_training_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x40, 0x13, 0x82, 0xE6, 0x6E, 0x28, 0x24, 0x9E, 0x12, 0x87, 0xE6, 0x6E, 0x07,
  0xB4, 0x83, 0x8A, 0x1E, 0x66, 0xE1, 0xC0, 0x44, 0x0B, 0x2E, 0x66, 0xE5, 0x83, 0xA8, 0xB5, 0x39,
  0x5E, 0x66, 0xE3, 0xB2, 0xEE, 0x2B, 0x3E, 0x66, 0xE0, 0x40, 0x55, 0x04, 0x0E, 0x66, 0xE3, 0x00,
  0x53, 0x81, 0xE6, 0x69, 0x80, 0x47, 0x90, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x2E, 0xF9, 0x0E,
  0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_on_device_training() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_action_on_device_training_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_online_prediction 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_online_prediction_data[] PROGMEM = {
  0x20, 0x27, 0x10, 0x13, 0x03, 0x0C, 0x71, 0x0C, 0x03, 0x28, 0xA1, 0xB3, 0xA2, 0x29, 0x92, 0x2A,
  0x4B, 0x01, 0xC3, 0xB0, 0xDA, 0x89, 0x1D, 0x0C, 0x2D, 0x13, 0x96, 0x73, 0xC8, 0x91, 0x37, 0x6A,
  0x33, 0x96, 0x70, 0xEA, 0x89, 0x2E, 0x07, 0x6A, 0x31, 0xC3, 0xB0, 0x4A, 0x8A, 0x14, 0x0C, 0x2C,
  0x10, 0xB3, 0xA2, 0x09, 0x90, 0x2A, 0x3B, 0x20, 0x30, 0xC3, 0x00, 0x33, 0x0C, 0x03, 0x30, 0x13,
  0x00, 0x33, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_online_prediction() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_online_prediction_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_opacity 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_opacity_data[] PROGMEM = {
  0x50, 0x0A, 0x72, 0x82, 0xAE, 0xEA, 0x78, 0x4A, 0xE4, 0x4E, 0xA5, 0x81, 0x9F, 0x42, 0x81, 0x4F,
  0x93, 0x81, 0x8F, 0x44, 0x85, 0x4F, 0x80, 0x2F, 0x76, 0x83, 0x6F, 0x27, 0xE7, 0x18, 0x2E, 0x79,
  0xC8, 0x04, 0x18, 0x1C, 0x98, 0xFB, 0x08, 0x04, 0xFB, 0x81, 0x40, 0xDF, 0x90, 0xD2, 0x02, 0x0E,
  0xE0, 0xE0, 0x23, 0x02, 0x0A, 0xC0, 0xA0, 0x26, 0x82, 0x13, 0x31, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_opacity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_opacity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_open_in_browser 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_open_in_browser_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x82, 0x44, 0xF6, 0x80, 0x45, 0x82,
  0x6F, 0x44, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x94, 0x00, 0x54, 0x90, 0x04, 0x93, 0x06,
  0xA0, 0x63, 0x90, 0x04, 0x93, 0x82, 0xBE, 0xEB, 0x39, 0x00, 0x49, 0x40, 0x0A, 0x49, 0x00, 0x49,
  0x40, 0x0A, 0x49, 0x00, 0x49, 0x40, 0x0A, 0x49, 0x04, 0x02, 0xC8, 0x21, 0x99, 0x1C, 0x89, 0x42,
  0x02, 0x33, 0x30, 0x11, 0x03, 0x33, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_open_in_browser() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_open_in_browser_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_open_in_full 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_open_in_full_data[] PROGMEM = {
  0x72, 0x83, 0xAB, 0xBB, 0x67, 0x20, 0xDB, 0x0B, 0x72, 0x02, 0x0E, 0xA0, 0xB7, 0x28, 0x38, 0xFE,
  0xFB, 0x71, 0x84, 0x8F, 0x81, 0xDA, 0x78, 0x18, 0xF8, 0x73, 0x81, 0x8F, 0x87, 0x38, 0x18, 0xF8,
  0x73, 0x81, 0x8F, 0x87, 0x84, 0xAD, 0x18, 0xF8, 0x71, 0x83, 0xBF, 0xEF, 0x87, 0x20, 0xBA, 0x0E,
  0x02, 0x72, 0x0B, 0xB0, 0xD7, 0x28, 0x36, 0xBB, 0xBA, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_open_in_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_open_in_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_open_in_new_off 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_open_in_new_off_data[] PROGMEM = {
  0x30, 0xF3, 0x02, 0x28, 0x71, 0x33, 0x30, 0xE7, 0x09, 0xA0, 0xD2, 0x05, 0xB8, 0x24, 0x7F, 0x77,
  0x0A, 0xA0, 0x04, 0xA0, 0x75, 0x89, 0x06, 0xFA, 0xF4, 0x4F, 0x7F, 0x73, 0x89, 0x66, 0xF7, 0x05,
  0x14, 0xF0, 0x6F, 0x70, 0x4F, 0x74, 0x04, 0x92, 0x83, 0x6F, 0x70, 0x45, 0x04, 0x93, 0x81, 0xAF,
  0x74, 0x81, 0xD3, 0x49, 0x28, 0x34, 0xFA, 0xF7, 0x39, 0x00, 0x49, 0x28, 0x41, 0x40, 0x6F, 0x72,
  0x90, 0x04, 0x96, 0x85, 0x6F, 0x70, 0x94, 0x49, 0x78, 0x46, 0xF7, 0x01, 0x2F, 0xC0, 0x72, 0x02,
  0x80, 0x53, 0x07, 0x0E, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_open_in_new_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_open_in_new_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_open_in_new 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_open_in_new_data[] PROGMEM = {
  0x18, 0x42, 0x33, 0x33, 0x22, 0x84, 0x13, 0x33, 0x02, 0xD0, 0xD2, 0x05, 0xB0, 0x04, 0x97, 0x10,
  0xAA, 0x00, 0x49, 0x78, 0x47, 0xFA, 0xF4, 0x49, 0x68, 0x57, 0xF7, 0x05, 0x14, 0x95, 0x81, 0x7F,
  0x74, 0x04, 0x94, 0x81, 0x7F, 0x75, 0x04, 0x93, 0x81, 0x7F, 0x74, 0x81, 0xD3, 0x49, 0x28, 0x14,
  0xF7, 0x59, 0x00, 0x49, 0x20, 0x10, 0x46, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40,
  0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_open_in_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_open_in_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_open_with 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_open_with_data[] PROGMEM = {
  0x70, 0x08, 0x76, 0x09, 0xA0, 0x97, 0x40, 0x8C, 0x08, 0x73, 0x06, 0x0A, 0xA0, 0xA0, 0x67, 0x40,
  0x5A, 0x05, 0x71, 0x08, 0x06, 0x20, 0x5A, 0x05, 0x20, 0x60, 0x83, 0x89, 0x69, 0xFA, 0x55, 0x23,
  0x32, 0x55, 0xAF, 0x90, 0x8D, 0x03, 0x20, 0x3D, 0x08, 0x09, 0xD0, 0x32, 0x03, 0xD8, 0x96, 0x80,
  0x9F, 0xA5, 0x52, 0x33, 0x25, 0x5A, 0xF9, 0x30, 0x90, 0x62, 0x05, 0xA0, 0x52, 0x06, 0x08, 0x71,
  0x05, 0xA0, 0x57, 0x40, 0x60, 0xAA, 0x0A, 0x06, 0x73, 0x08, 0xC0, 0x87, 0x40, 0x9A, 0x09, 0x76,
  0x00, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_open_with() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_open_with_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_outbond 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_outbond_data[] PROGMEM = {
  0x68, 0x24, 0x55, 0x37, 0x20, 0x10, 0x8D, 0x0E, 0x07, 0x60, 0x20, 0xDF, 0x90, 0xC0, 0x13, 0x01,
  0x0D, 0xFB, 0x0C, 0x30, 0x9F, 0xD8, 0x17, 0x01, 0xE0, 0x72, 0x03, 0xB8, 0x1E, 0x05, 0xE8, 0x2E,
  0x10, 0x1C, 0x03, 0x07, 0xE8, 0x26, 0x01, 0x1C, 0x05, 0x07, 0xD8, 0x36, 0x06, 0xE8, 0xC0, 0x06,
  0xC8, 0x17, 0x06, 0xF0, 0x40, 0x1C, 0x03, 0x07, 0xF9, 0x20, 0xAF, 0xD0, 0x82, 0x02, 0x0E, 0xFB,
  0x0D, 0x01, 0x30, 0x30, 0xEF, 0x90, 0xD0, 0x25, 0x02, 0x0A, 0xE0, 0x90, 0x17, 0x18, 0x41, 0x67,
  0x75, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_outbond() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_outbond_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_outbound 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_outbound_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x23, 0x01,
  0x0D, 0xFB, 0x0D, 0x01, 0x20, 0x9F, 0xD0, 0x92, 0xE0, 0x73, 0xC1, 0x05, 0xF0, 0x12, 0xC0, 0x50,
  0x6E, 0x81, 0x60, 0x11, 0xC0, 0x06, 0xD8, 0x36, 0x06, 0xF7, 0xC0, 0x60, 0x5C, 0x81, 0x70, 0x6F,
  0x05, 0x1C, 0x01, 0x07, 0xF9, 0x20, 0x9F, 0xD0, 0x92, 0x01, 0x0D, 0xFB, 0x0D, 0x01, 0x30, 0x20,
  0xDF, 0x90, 0xD0, 0x25, 0x01, 0x09, 0xE0, 0x90, 0x17, 0x28, 0x25, 0x77, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_outbound() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_outbound_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_outbox 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_outbox_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x40, 0x02, 0x49,
  0x00, 0x49, 0x38, 0x22, 0xEE, 0x23, 0x90, 0x04, 0x93, 0x0D, 0xA0, 0xE3, 0x90, 0x04, 0x93, 0x82,
  0x1B, 0xB1, 0x39, 0x83, 0x44, 0xF2, 0x12, 0x00, 0x72, 0x83, 0x12, 0xF4, 0x4B, 0x0E, 0x03, 0x20,
  0x30, 0xEB, 0x00, 0x4C, 0x82, 0xE6, 0x6E, 0xC0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8,
  0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_outbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_outbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_outlet 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_action_outlet_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x23, 0x01,
  0x0D, 0xFB, 0x0D, 0x01, 0x20, 0x9B, 0x06, 0x0C, 0xA0, 0xC0, 0x6B, 0x09, 0x2C, 0x10, 0x7A, 0x07,
  0x1C, 0x10, 0x5C, 0x10, 0x7A, 0x07, 0x1C, 0x05, 0x06, 0xC0, 0x20, 0xAA, 0x0A, 0x02, 0xC0, 0x06,
  0xFF, 0x06, 0x05, 0xE0, 0x09, 0xE0, 0x51, 0xD0, 0xA2, 0x0A, 0xD2, 0x09, 0xC0, 0x72, 0x07, 0xC0,
  0x92, 0x01, 0x0D, 0xB8, 0x2D, 0x77, 0xDB, 0x0D, 0x01, 0x30, 0x20, 0xDF, 0x90, 0xD0, 0x25, 0x01,
  0x09, 0xE0, 0x90, 0x17, 0x28, 0x25, 0x77, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_outlet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_outlet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_output 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_output_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x71, 0x83, 0x20,
  0x40, 0x49, 0x71, 0x0E, 0x0A, 0x20, 0x49, 0x71, 0x83, 0x3E, 0xA0, 0x49, 0x30, 0x68, 0x01, 0x98,
  0x2C, 0xF8, 0x49, 0x30, 0x68, 0x01, 0x98, 0x2C, 0xF9, 0x49, 0x71, 0x83, 0x3E, 0xA0, 0x49, 0x71,
  0x0E, 0x0A, 0x20, 0x49, 0x71, 0x83, 0x30, 0x40, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02,
  0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_output() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_output_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pageview 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_pageview_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3D, 0x81, 0x87, 0xAE, 0x00, 0x3C, 0x83,
  0x20, 0x30, 0x7D, 0x00, 0x3B, 0x85, 0x90, 0xDF, 0x90, 0xDC, 0x00, 0x3B, 0x07, 0x03, 0xA8, 0x1D,
  0x0C, 0xC0, 0x03, 0xB8, 0x4A, 0x09, 0xD5, 0x1D, 0x00, 0x3C, 0x06, 0x40, 0x8C, 0x00, 0x3D, 0x84,
  0xDB, 0xF8, 0x0C, 0xB0, 0x03, 0xFA, 0x0C, 0xC0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50,
  0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pageview() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_pageview_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_paid 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_paid_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9C, 0x00, 0x8C, 0x09,
  0x30, 0x3C, 0x05, 0x20, 0x50, 0xEB, 0x03, 0x20, 0xBB, 0x84, 0xA1, 0xCC, 0x4D, 0xB0, 0xB2, 0xC8,
  0x19, 0x1D, 0xF1, 0x02, 0xD8, 0x24, 0x05, 0xCD, 0x00, 0x2E, 0x82, 0xC5, 0x0A, 0xC0, 0x21, 0xC0,
  0xE0, 0xDA, 0x06, 0x04, 0xC2, 0x0B, 0xB8, 0x48, 0x1B, 0xD3, 0x6B, 0x0B, 0x20, 0x3C, 0x05, 0x20,
  0x30, 0xEB, 0x03, 0x30, 0x9C, 0x00, 0x8C, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0,
  0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_paid() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_paid_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pan_tool_alt 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_action_pan_tool_alt_data[] PROGMEM = {
  0x40, 0x30, 0x17, 0x18, 0x13, 0xFC, 0x71, 0x81, 0x5F, 0xD7, 0x18, 0x15, 0xFD, 0x71, 0x81, 0x5F,
  0xD7, 0x18, 0x15, 0xFD, 0x71, 0x05, 0xA8, 0x1D, 0xC5, 0x50, 0x5D, 0x0C, 0x03, 0x30, 0x5E, 0x83,
  0xB9, 0xFA, 0x9E, 0x81, 0xB3, 0xEF, 0x98, 0x28, 0x03, 0xEF, 0x06, 0x20, 0x30, 0xEE, 0x02, 0x30,
  0x18, 0x01, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pan_tool_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_pan_tool_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pan_tool 18x18, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_round_18_action_pan_tool_data[] PROGMEM = {
  0x78, 0x13, 0xE7, 0x77, 0x84, 0x6F, 0xC2, 0xEB, 0x72, 0x89, 0x13, 0x06, 0xFC, 0x4F, 0xE0, 0x22,
  0x58, 0x92, 0x7F, 0x86, 0xFC, 0x4F, 0xE1, 0xFE, 0x58, 0x90, 0x9F, 0xA6, 0xFC, 0x4F, 0xE2, 0xA0,
  0x14, 0x89, 0x09, 0xFA, 0x6F, 0xC4, 0xFE, 0x2A, 0x01, 0x48, 0x90, 0x9F, 0xA6, 0xFC, 0x4F, 0xE2,
  0xA0, 0x14, 0x89, 0x09, 0xFA, 0x6F, 0xC4, 0xFE, 0x2A, 0x01, 0x48, 0x29, 0xFE, 0xEA, 0x0E, 0xA0,
  0xDA, 0x01, 0x40, 0x9F, 0xC8, 0x41, 0x18, 0x70, 0x9F, 0xC0, 0x10, 0x7A, 0x0D, 0x0B, 0xFC, 0x01,
  0x03, 0xFF, 0x98, 0x11, 0x04, 0xFF, 0x01, 0x20, 0x4F, 0xE0, 0x13, 0x04, 0xFD, 0x50, 0x4F, 0xB0,
  0xB6, 0x04, 0x0E, 0xE8, 0x1E, 0xB1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pan_tool() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_action_pan_tool_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_payment 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_18_action_payment_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF8, 0x23, 0x3F, 0x58, 0x06, 0x38,
  0x45, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x3F, 0xF0, 0x03, 0xFF,
  0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_payment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_payment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pending_actions 18x18, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_18_action_pending_actions_data[] PROGMEM = {
  0x50, 0x02, 0x74, 0x09, 0xA0, 0x96, 0x89, 0x24, 0xBB, 0xBF, 0x99, 0xFB, 0xBB, 0x42, 0x81, 0xED,
  0xBA, 0x00, 0x9A, 0x81, 0xBD, 0xE2, 0x90, 0x71, 0xE1, 0x07, 0x92, 0x98, 0x17, 0x08, 0xC8, 0x18,
  0x07, 0x92, 0x90, 0x77, 0x10, 0x79, 0x29, 0x07, 0x71, 0x05, 0x0D, 0x29, 0x07, 0x75, 0x90, 0x75,
  0x83, 0x3B, 0xED, 0x72, 0x90, 0x74, 0x03, 0xA0, 0xBA, 0x82, 0xA0, 0xF7, 0x40, 0xBA, 0x05, 0x0D,
  0xA8, 0x13, 0xF7, 0x40, 0xEA, 0x05, 0x0C, 0xA8, 0x16, 0xF7, 0x40, 0xDA, 0x85, 0xD3, 0xDF, 0x5F,
  0x74, 0x07, 0xB8, 0x3D, 0xEE, 0x1D, 0xC8, 0x14, 0x0A, 0xB8, 0x7E, 0x40, 0x27, 0x77, 0x76, 0x28,
  0x23, 0x65, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pending_actions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_pending_actions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pending 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_pending_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x50, 0x5F, 0x90, 0x53, 0x03, 0xFB, 0x03,
  0x20, 0xBF, 0xB8, 0x1B, 0x01, 0xFD, 0x01, 0x03, 0xA8, 0x64, 0x8F, 0x66, 0xF8, 0x4A, 0x00, 0x3A,
  0x86, 0x48, 0xF6, 0x6F, 0x84, 0xA0, 0x30, 0x1F, 0xD8, 0x11, 0x0B, 0xFB, 0x0B, 0x20, 0x3F, 0xB0,
  0x33, 0x05, 0xF9, 0x05, 0x50, 0x30, 0xBC, 0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pending() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_pending_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_percent 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_percent_data[] PROGMEM = {
  0x20, 0x50, 0x37, 0x20, 0xCA, 0x08, 0x48, 0x57, 0xF0, 0x5F, 0x26, 0x93, 0x87, 0x7F, 0x70, 0x3F,
  0x6A, 0xE2, 0x81, 0x7F, 0x73, 0x86, 0x8F, 0xE5, 0x07, 0xF7, 0x71, 0x81, 0x7F, 0x77, 0x18, 0x17,
  0xF7, 0x71, 0x86, 0x7F, 0x70, 0x5E, 0xF8, 0x38, 0x17, 0xF7, 0x28, 0x7E, 0xA6, 0xF3, 0x07, 0xF7,
  0x39, 0x85, 0x62, 0xF5, 0x0F, 0x74, 0x08, 0xA0, 0xC7, 0x20, 0x30, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_percent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_percent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_perm_camera_mic 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_action_perm_camera_mic_data[] PROGMEM = {
  0x68, 0x00, 0x37, 0x40, 0xCC, 0x0C, 0x68, 0x24, 0x77, 0xAE, 0x84, 0xA7, 0x74, 0x01, 0xE0, 0x08,
  0xE0, 0x10, 0x3D, 0x0B, 0x20, 0xBD, 0x00, 0x3D, 0x0A, 0x20, 0xAD, 0x00, 0x3D, 0x0A, 0x20, 0xAD,
  0x00, 0x3A, 0x82, 0xA3, 0xFA, 0x28, 0x2A, 0xF3, 0xAA, 0x00, 0x3A, 0x89, 0x0C, 0x0B, 0xE5, 0x5E,
  0xB0, 0xCA, 0x00, 0x3B, 0x81, 0x51, 0xBA, 0x81, 0xB1, 0x5B, 0x00, 0x3B, 0x0E, 0x05, 0x40, 0x50,
  0xEB, 0x00, 0x3D, 0x82, 0xC3, 0x3C, 0xD8, 0x13, 0x1E, 0xD0, 0x50, 0x4D, 0x82, 0xE1, 0x01, 0x80,
  0x13, 0x00, 0x18, 0x01, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_perm_camera_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_perm_camera_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_perm_contact_calendar 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_action_perm_contact_calendar_data[] PROGMEM = {
  0x30, 0x02, 0x40, 0x02, 0x60, 0x90, 0xB4, 0x0B, 0x09, 0x48, 0x94, 0x35, 0xBD, 0x55, 0x55, 0xDB,
  0x53, 0x02, 0xFD, 0x02, 0x04, 0xD0, 0x0E, 0xD0, 0x04, 0xC0, 0x52, 0x05, 0xC0, 0x04, 0xB0, 0x84,
  0x08, 0xB0, 0x04, 0xB0, 0x54, 0x05, 0xB0, 0x04, 0xB0, 0x84, 0x08, 0xB0, 0x04, 0xB0, 0xE0, 0x42,
  0x04, 0x0E, 0xB0, 0x04, 0xD0, 0x0D, 0xD0, 0x04, 0xA8, 0x6E, 0x84, 0x22, 0x48, 0xEA, 0x82, 0x44,
  0xF9, 0x71, 0x84, 0x9F, 0x44, 0xF3, 0x80, 0x41, 0x83, 0x3F, 0x41, 0xEF, 0xB8, 0x2E, 0x10, 0x18,
  0x06, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_perm_contact_calendar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_perm_contact_calendar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_perm_data_setting 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_18_action_perm_data_setting_data[] PROGMEM = {
  0x76, 0x02, 0x01, 0x77, 0x81, 0x2E, 0x67, 0x68, 0x22, 0xEF, 0x67, 0x50, 0x20, 0xEA, 0x06, 0x74,
  0x02, 0x0E, 0xB0, 0x67, 0x30, 0x20, 0xEC, 0x06, 0x72, 0x02, 0x0E, 0xD0, 0x67, 0x10, 0x20, 0xEE,
  0x06, 0x70, 0x20, 0xEC, 0x82, 0xEA, 0x93, 0x60, 0x20, 0xEC, 0x09, 0x20, 0x16, 0x02, 0x0E, 0xC0,
  0x92, 0x81, 0x3F, 0x34, 0x02, 0x0E, 0xC8, 0x92, 0xE0, 0x69, 0xEF, 0xE9, 0x60, 0x2E, 0xD8, 0x91,
  0xA0, 0x9F, 0xA3, 0x9F, 0x92, 0xEE, 0x89, 0x08, 0x02, 0xF3, 0x03, 0xF2, 0x18, 0x03, 0x58, 0x73,
  0x08, 0xFA, 0x39, 0xF8, 0x73, 0x85, 0x79, 0xEF, 0xE9, 0x67, 0x58, 0x13, 0xF3, 0x77, 0x10, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_perm_data_setting() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_perm_data_setting_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_perm_device_information 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_action_perm_device_information_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x81, 0xE2, 0x6F, 0xB0, 0x06, 0xFB, 0x00, 0x69, 0x80, 0x47,
  0x98, 0x16, 0x6E, 0x30, 0x04, 0x38, 0x2E, 0x66, 0xE3, 0x00, 0x53, 0x82, 0xE6, 0x6E, 0x30, 0x01,
  0x38, 0x2E, 0x66, 0xE3, 0x00, 0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x2E, 0x66, 0xE3, 0x00,
  0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x2E, 0x66, 0xE3, 0x00, 0x43, 0x81, 0xE6, 0x69, 0x80,
  0x47, 0x90, 0x06, 0xFB, 0x00, 0x6F, 0xB8, 0x16, 0x2E, 0xF9, 0x0E, 0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_perm_device_information() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_action_perm_device_information_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_perm_identity 18x18, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_round_18_action_perm_identity_data[] PROGMEM = {
  0x50, 0x04, 0x71, 0x01, 0x0D, 0xA0, 0xD0, 0x16, 0x08, 0xC0, 0x86, 0x09, 0xC0, 0x96, 0x05, 0xC0,
  0x57, 0x82, 0x7D, 0xD7, 0x72, 0x00, 0x17, 0x81, 0x5B, 0xEA, 0x81, 0xEB, 0x53, 0x0C, 0xF9, 0x81,
  0xC0, 0x5F, 0xB0, 0x50, 0x6F, 0xB0, 0x60, 0x18, 0x06, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_perm_identity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_perm_identity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_perm_media 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_action_perm_media_data[] PROGMEM = {
  0x40, 0x10, 0xF3, 0x75, 0x02, 0xC0, 0xB7, 0x40, 0x6D, 0x0B, 0x80, 0x15, 0x03, 0x28, 0x16, 0x06,
  0xFD, 0x83, 0x11, 0xF3, 0x6F, 0xD8, 0x33, 0x1F, 0x36, 0xFD, 0x83, 0x31, 0xF3, 0x6B, 0x83, 0xEC,
  0xF9, 0x5C, 0x83, 0x31, 0xF3, 0x6B, 0x81, 0x50, 0xA2, 0x08, 0xB8, 0x33, 0x1F, 0x36, 0xA8, 0x5D,
  0x21, 0x11, 0x12, 0xB8, 0x33, 0x1F, 0x36, 0xFD, 0x83, 0x31, 0xF3, 0x5F, 0xD8, 0x42, 0x1F, 0x30,
  0x78, 0x06, 0x98, 0x35, 0x01, 0xF3, 0x77, 0x10, 0xDF, 0xD0, 0x43, 0x01, 0x80, 0x90, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_perm_media() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_perm_media_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_perm_phone_msg 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_perm_phone_msg_data[] PROGMEM = {
  0x10, 0xF3, 0x02, 0x20, 0x28, 0x01, 0x31, 0x03, 0xB0, 0xE2, 0x0E, 0xD0, 0x30, 0x2C, 0x04, 0x1E,
  0x04, 0x1C, 0x07, 0x1E, 0x81, 0x40, 0xBA, 0x0D, 0x01, 0x1E, 0x84, 0x30, 0x5F, 0xD1, 0x29, 0x83,
  0x83, 0x33, 0x23, 0x0D, 0x0A, 0x30, 0x37, 0x18, 0x14, 0xF5, 0x75, 0x81, 0x9E, 0x33, 0x81, 0x17,
  0x46, 0x84, 0xAE, 0x50, 0x1D, 0xA0, 0xE0, 0x25, 0x82, 0x9F, 0xAD, 0xC0, 0x46, 0x04, 0x0D, 0xD0,
  0x47, 0x10, 0x50, 0xBB, 0x03, 0x74, 0x02, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_perm_phone_msg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_perm_phone_msg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_perm_scan_wifi 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_action_perm_scan_wifi_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7C, 0xE8, 0x1C, 0x71, 0x50, 0x8F, 0xD0, 0x82, 0x01, 0x0D,
  0xE0, 0x0B, 0xE8, 0x1D, 0x14, 0xF0, 0x09, 0xF8, 0x14, 0x0B, 0xE0, 0x0D, 0xE0, 0xB3, 0x0B, 0xD0,
  0x05, 0xD0, 0xB5, 0x0B, 0xC0, 0x05, 0xC0, 0xB7, 0x0B, 0xB0, 0x09, 0xB0, 0xB7, 0x20, 0xBE, 0x0B,
  0x74, 0x0B, 0xC0, 0xB7, 0x60, 0xBA, 0x0B, 0x77, 0x10, 0x09, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_perm_scan_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_round_18_action_perm_scan_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pets 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_action_pets_data[] PROGMEM = {
  0x50, 0x30, 0x12, 0x01, 0x03, 0x72, 0x0A, 0xA0, 0x03, 0xA0, 0xA7, 0x1B, 0x00, 0x7B, 0x58, 0x23,
  0x84, 0xAA, 0x00, 0x3A, 0x82, 0xA4, 0x83, 0x20, 0xEA, 0x81, 0x33, 0x12, 0x81, 0x13, 0x3A, 0x81,
  0xE0, 0x2B, 0x05, 0x60, 0x5B, 0x83, 0x20, 0x8E, 0xA2, 0x82, 0x4C, 0xC5, 0x28, 0x1A, 0xE8, 0x60,
  0x3C, 0x03, 0x72, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x10, 0xBE, 0x0B, 0x70, 0x9F, 0x90, 0x95, 0x03,
  0xFB, 0x03, 0x40, 0x5F, 0xB0, 0x45, 0x0C, 0xA8, 0x2D, 0xBB, 0xDA, 0x0C, 0x70, 0x26, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pets() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_pets_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_php 18x18, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_round_18_action_php_data[] PROGMEM = {
  0x8C, 0x44, 0xBB, 0x23, 0x55, 0x32, 0xBB, 0x46, 0xCD, 0x45, 0xBB, 0x54, 0xDC, 0x66, 0xB7, 0x15,
  0xBB, 0x54, 0xC7, 0x14, 0x52, 0x84, 0x35, 0x53, 0x26, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_php() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 14, 10), Box(0, 0, 17, 17),
      ic_round_18_action_php_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_picture_in_picture_alt 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_action_picture_in_picture_alt_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0,
  0x03, 0xE8, 0x4A, 0x11, 0x11, 0x3A, 0x00, 0x3E, 0x08, 0x5A, 0x00, 0x3E, 0x08, 0x5A, 0x00, 0x3E,
  0x08, 0x40, 0x1A, 0x00, 0x3F, 0x80, 0x0D, 0x0E, 0xA0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90,
  0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_picture_in_picture_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_picture_in_picture_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_picture_in_picture 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_round_18_action_picture_in_picture_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0x80, 0x0D, 0x0E, 0xA0, 0x03, 0xE0,
  0x84, 0x01, 0xA0, 0x03, 0xE0, 0x85, 0xA0, 0x03, 0xE0, 0x85, 0xA0, 0x03, 0xE8, 0x4A, 0x11, 0x11,
  0x3A, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x30, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90,
  0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_picture_in_picture() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_picture_in_picture_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pinch 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_pinch_data[] PROGMEM = {
  0x50, 0xF1, 0x76, 0x83, 0x4B, 0xDF, 0x17, 0x68, 0x23, 0xDE, 0x17, 0x58, 0x33, 0xD3, 0xC1, 0x72,
  0x85, 0x40, 0x3D, 0x30, 0x42, 0x04, 0x05, 0x58, 0x31, 0xC3, 0xD3, 0x40, 0x1A, 0x01, 0x48, 0x21,
  0xED, 0x35, 0x01, 0xA0, 0x24, 0x83, 0x1F, 0xDB, 0x44, 0x01, 0xA0, 0x25, 0x0F, 0x15, 0x01, 0xA0,
  0x27, 0x60, 0x1A, 0x03, 0x01, 0x75, 0x01, 0xC0, 0xA0, 0x27, 0x30, 0x1E, 0x08, 0x78, 0x13, 0x01,
  0xF6, 0x82, 0x4F, 0xEA, 0xE0, 0xE7, 0x0A, 0xF9, 0x0C, 0x71, 0x0A, 0xF0, 0x97, 0x20, 0xAE, 0x04,
  0x73, 0x80, 0x11, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pinch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_pinch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pin_end 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_pin_end_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x23,
  0x82, 0x2B, 0xB7, 0x38, 0x42, 0xF3, 0x3F, 0x23, 0x05, 0xA0, 0x53, 0x84, 0x2F, 0x33, 0xF2, 0x38,
  0x25, 0xFE, 0xB3, 0x84, 0x2F, 0x33, 0xF2, 0x38, 0x31, 0x32, 0xE8, 0x58, 0x13, 0xF2, 0x68, 0x90,
  0x11, 0x07, 0x82, 0x03, 0xF2, 0x71, 0x09, 0xA8, 0x3E, 0x03, 0xF2, 0x71, 0x0C, 0xB0, 0x20, 0x1F,
  0x98, 0x1C, 0x06, 0xA0, 0xC2, 0x03, 0x80, 0x35, 0x04, 0x20, 0x30, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pin_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_pin_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pin_invoke 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_pin_invoke_data[] PROGMEM = {
  0x10, 0x38, 0x03, 0x50, 0x42, 0x03, 0x05, 0x20, 0x1F, 0x98, 0x1C, 0x06, 0xA8, 0x3C, 0x03, 0xF2,
  0x71, 0x0C, 0xB8, 0x22, 0x3F, 0x27, 0x10, 0x9A, 0x83, 0xE0, 0x3F, 0x23, 0x82, 0x15, 0x53, 0x28,
  0x57, 0x82, 0x03, 0xF2, 0x38, 0x22, 0xEF, 0xC6, 0x81, 0x3F, 0x23, 0x82, 0x1D, 0xFC, 0x38, 0x42,
  0xF3, 0x3F, 0x23, 0x82, 0xDC, 0x48, 0x38, 0x42, 0xF3, 0x3F, 0x23, 0x08, 0x01, 0x58, 0x42, 0xF3,
  0x3F, 0x27, 0x38, 0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pin_invoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_pin_invoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_plagiarism 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_plagiarism_data[] PROGMEM = {
  0x18, 0x03, 0x34, 0x05, 0xD8, 0x1E, 0xE9, 0x30, 0x6D, 0x82, 0xD3, 0xE9, 0x20, 0x6D, 0x85, 0xD0,
  0x3E, 0x90, 0x6D, 0x0E, 0x28, 0x23, 0xE4, 0x6E, 0x84, 0xCB, 0xBD, 0x66, 0xB8, 0x26, 0x25, 0xEB,
  0x00, 0x6A, 0x83, 0x76, 0xE7, 0x6B, 0x00, 0x6A, 0x83, 0x5B, 0xFD, 0x3B, 0x00, 0x6A, 0x83, 0xA3,
  0x94, 0x6B, 0x00, 0x6B, 0x83, 0xB7, 0x92, 0xAA, 0x00, 0x6E, 0x0E, 0x0D, 0xA0, 0x60, 0x5F, 0xB0,
  0x51, 0x80, 0x63, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_plagiarism() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_plagiarism_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_play_for_work 18x18, 4-bit Alpha,  RLE, 36 bytes.
static const unsigned char ic_round_18_action_play_for_work_data[] PROGMEM = {
  0x30, 0x03, 0x60, 0x0A, 0x60, 0x0A, 0x60, 0x0A, 0x58, 0x2C, 0xEE, 0xC4, 0x04, 0xA0, 0x43, 0x87,
  0x10, 0x44, 0x01, 0x06, 0xD4, 0x83, 0xD6, 0x2F, 0x92, 0x84, 0x9F, 0x20, 0x5E, 0xA0, 0xE0, 0x53,
  0x82, 0x14, 0x41, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_play_for_work() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 12, 14), Box(0, 0, 17, 17),
      ic_round_18_action_play_for_work_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_polymer 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_action_polymer_data[] PROGMEM = {
  0x38, 0x15, 0x53, 0x30, 0x10, 0xF5, 0x50, 0x7A, 0x03, 0x30, 0xBB, 0x07, 0x38, 0x21, 0xEF, 0x93,
  0x04, 0xA8, 0x2C, 0xFE, 0x12, 0x82, 0x9F, 0xE1, 0x38, 0x7D, 0xFC, 0x0E, 0xF9, 0x03, 0xA0, 0x73,
  0x07, 0xA8, 0x13, 0x06, 0xA8, 0x23, 0xCF, 0xD3, 0x82, 0x1E, 0xF9, 0x38, 0x4D, 0xFC, 0xCF, 0xD3,
  0x82, 0x9F, 0xE1, 0x38, 0x2D, 0xFC, 0x3A, 0x81, 0x60, 0x3A, 0x07, 0x30, 0x7A, 0x87, 0x30, 0x9F,
  0xE0, 0xCF, 0xD3, 0x02, 0xA0, 0x92, 0x82, 0x1E, 0xFC, 0xA0, 0x43, 0x82, 0xBF, 0xE1, 0x30, 0x7B,
  0x0B, 0x30, 0x5A, 0x07, 0x50, 0xF5, 0x01, 0x38, 0x14, 0x55, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_polymer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_polymer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_power_settings_new 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_power_settings_new_data[] PROGMEM = {
  0x60, 0x01, 0x75, 0x00, 0x97, 0x10, 0x50, 0x42, 0x00, 0xA2, 0x04, 0x05, 0x38, 0x13, 0xF6, 0x20,
  0x0A, 0x28, 0x17, 0xF3, 0x20, 0x0B, 0x30, 0x0A, 0x38, 0x4B, 0xB0, 0x1F, 0x43, 0x00, 0xA3, 0x84,
  0x4F, 0x13, 0xF1, 0x30, 0x0A, 0x38, 0x41, 0xF3, 0x3F, 0x13, 0x00, 0x73, 0x84, 0x1F, 0x31, 0xF4,
  0x71, 0x84, 0x4F, 0x10, 0xBB, 0x71, 0x00, 0xB2, 0x81, 0x3F, 0x86, 0x81, 0x8F, 0x33, 0x89, 0x05,
  0xFB, 0x51, 0x15, 0xBF, 0x55, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x18, 0x21, 0x33, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_power_settings_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_power_settings_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_pregnant_woman 18x18, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_round_18_action_pregnant_woman_data[] PROGMEM = {
  0x20, 0x25, 0x81, 0xAF, 0xC4, 0xB0, 0x13, 0x81, 0x7D, 0x85, 0x01, 0x48, 0x31, 0xCF, 0xD2, 0x20,
  0x8B, 0x0A, 0x20, 0xAB, 0x82, 0xE6, 0x0A, 0xD0, 0x10, 0xAD, 0x02, 0x0A, 0xD8, 0x52, 0x39, 0xEE,
  0x97, 0x30, 0x0D, 0x50, 0x0D, 0x50, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_pregnant_woman() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_action_pregnant_woman_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_preview 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_action_preview_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD0, 0xA0, 0xBF, 0xD8, 0x1B, 0xBC, 0x80, 0x63, 0x0C,
  0x0F, 0xB4, 0x00, 0x24, 0x80, 0x0B, 0x28, 0x48, 0xEE, 0xEE, 0x82, 0x80, 0x0B, 0x18, 0x94, 0xAF,
  0xA3, 0x3A, 0xFA, 0x0B, 0xBB, 0xB4, 0xA0, 0x3A, 0x03, 0xA8, 0xB2, 0x4B, 0xBB, 0xB1, 0xEF, 0x5A,
  0xA5, 0xFE, 0x1B, 0xBB, 0xB0, 0x3E, 0xE7, 0x7E, 0xE3, 0x18, 0x00, 0xB2, 0x84, 0x17, 0xAA, 0x71,
  0x28, 0x00, 0xB7, 0x38, 0x2B, 0xBA, 0xE8, 0x06, 0xB8, 0x2E, 0xA2, 0xA8, 0x06, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_preview() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_preview_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_print 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_print_data[] PROGMEM = {
  0x48, 0x04, 0x37, 0x05, 0xF9, 0x05, 0x60, 0x7F, 0x90, 0x76, 0x02, 0x80, 0x45, 0x02, 0x40, 0x40,
  0xA8, 0x06, 0xB8, 0x2A, 0x40, 0x1F, 0xF0, 0x10, 0x3F, 0xB0, 0xB0, 0x4A, 0x00, 0x3F, 0xB0, 0xE0,
  0xBA, 0x00, 0x3F, 0xF0, 0x30, 0x2B, 0x0D, 0x80, 0x23, 0x0D, 0xB8, 0x42, 0x07, 0x9C, 0xD6, 0x82,
  0xDC, 0x97, 0x40, 0x70, 0xD6, 0x0D, 0x07, 0x60, 0x5F, 0x90, 0x57, 0x80, 0x43, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_print() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_print_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_privacy_tip 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_round_18_action_privacy_tip_data[] PROGMEM = {
  0x48, 0x21, 0x77, 0x16, 0x02, 0x09, 0xC0, 0x90, 0x22, 0x01, 0x0B, 0xF9, 0x81, 0xB1, 0x6F, 0xB0,
  0x06, 0xC0, 0x0B, 0xC0, 0x06, 0xC0, 0x0E, 0xC0, 0x60, 0x5C, 0x00, 0xAC, 0x05, 0x03, 0xC0, 0x08,
  0xC0, 0x41, 0xC0, 0x08, 0xC8, 0x11, 0x0B, 0xB0, 0x0B, 0xB0, 0xB2, 0x03, 0xF9, 0x03, 0x30, 0x7E,
  0x07, 0x50, 0x6C, 0x06, 0x78, 0x22, 0x88, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_privacy_tip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_privacy_tip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_private_connectivity 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_private_connectivity_data[] PROGMEM = {
  0x48, 0x43, 0xAD, 0xDA, 0x37, 0x06, 0xA0, 0x0E, 0xA0, 0x65, 0x03, 0xA8, 0x2D, 0x33, 0xDA, 0x03,
  0x48, 0x90, 0x9F, 0xE6, 0x66, 0x6E, 0xF9, 0x28, 0x39, 0x9E, 0xFB, 0x48, 0xA1, 0xBF, 0xE9, 0x99,
  0x9E, 0xFB, 0x06, 0x60, 0xBF, 0xE9, 0x92, 0x81, 0x9F, 0xB4, 0x81, 0xBF, 0x94, 0x03, 0xA8, 0x00,
  0xBA, 0x03, 0x50, 0x6E, 0x06, 0x78, 0x43, 0xAD, 0xDA, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_private_connectivity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_private_connectivity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_production_quantity_limits 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_round_18_action_production_quantity_limits_data[] PROGMEM = {
  0x71, 0x00, 0x17, 0x81, 0x67, 0x24, 0x00, 0xA6, 0x82, 0x1E, 0xFA, 0x40, 0x0B, 0x71, 0x81, 0x7F,
  0x23, 0x00, 0xB4, 0x08, 0x03, 0x28, 0x11, 0xE9, 0x30, 0x03, 0x38, 0x15, 0xF4, 0x38, 0x18, 0xF1,
  0x70, 0xD0, 0xC4, 0x81, 0x1F, 0x82, 0x00, 0x82, 0x81, 0x6F, 0x45, 0x84, 0x9E, 0x10, 0x33, 0x20,
  0xD0, 0xB6, 0x89, 0x02, 0xFC, 0xBB, 0xBB, 0xCF, 0x36, 0x07, 0x98, 0x02, 0xB0, 0x67, 0x0E, 0x0A,
  0x76, 0x81, 0x2F, 0xC8, 0x03, 0xB0, 0xA0, 0x15, 0x07, 0x80, 0x4B, 0x0A, 0x01, 0x50, 0x30, 0x66,
  0x06, 0x03, 0x50, 0x1A, 0x09, 0x40, 0x9A, 0x01, 0x40, 0x1A, 0x09, 0x40, 0x9A, 0x01, 0x50, 0x30,
  0x66, 0x06, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_production_quantity_limits() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_production_quantity_limits_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_published_with_changes 18x18, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_round_18_action_published_with_changes_data[] PROGMEM = {
  0x28, 0x00, 0x13, 0x03, 0x01, 0x60, 0x10, 0xEA, 0x0B, 0x20, 0x2A, 0x09, 0x01, 0x50, 0x5A, 0x0B,
  0x38, 0x33, 0x9F, 0xD2, 0x38, 0x31, 0xDE, 0xEB, 0x58, 0x23, 0xED, 0x12, 0x83, 0x9F, 0x33, 0x86,
  0x81, 0x3F, 0x92, 0x90, 0x97, 0x87, 0x36, 0x09, 0xF1, 0x5F, 0x36, 0x86, 0x4E, 0xB0, 0x4F, 0x56,
  0x92, 0x04, 0x02, 0x28, 0xA1, 0x4E, 0xC1, 0x01, 0xF7, 0x7F, 0x10, 0xCE, 0x24, 0xEC, 0x13, 0x98,
  0x91, 0x65, 0xF4, 0x02, 0xDE, 0xEC, 0x13, 0x84, 0x3F, 0x51, 0xF9, 0x28, 0x22, 0xDC, 0x14, 0x09,
  0x92, 0x81, 0x9F, 0x36, 0x83, 0x83, 0x3F, 0x92, 0x82, 0x1D, 0xE3, 0x58, 0x3B, 0xEE, 0xD1, 0x38,
  0x32, 0xDF, 0x93, 0x30, 0xBA, 0x05, 0x50, 0x10, 0x9A, 0x02, 0x20, 0xBA, 0x0E, 0x01, 0x60, 0x10,
  0x33, 0x80, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_published_with_changes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_published_with_changes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_query_builder 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_query_builder_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9C, 0x00, 0xCC, 0x09,
  0x30, 0x3D, 0x00, 0x5D, 0x03, 0x20, 0xBD, 0x00, 0x5D, 0x0B, 0x2E, 0x00, 0x5E, 0x10, 0x2E, 0x05,
  0x03, 0xE0, 0x02, 0xE8, 0x1C, 0x04, 0xD0, 0x21, 0xF8, 0x1B, 0x04, 0xC2, 0x0B, 0xF8, 0x1B, 0x3E,
  0xA0, 0xB2, 0x03, 0xFD, 0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_query_builder() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_query_builder_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_question_answer 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_question_answer_data[] PROGMEM = {
  0x28, 0x04, 0x30, 0x26, 0x0E, 0xFA, 0x05, 0x40, 0x3F, 0xB0, 0x94, 0x03, 0xFB, 0x09, 0x40, 0x3F,
  0xB8, 0x49, 0x09, 0x50, 0x3F, 0xB0, 0x91, 0xA0, 0x20, 0x3F, 0xB0, 0x91, 0xA0, 0x03, 0xFB, 0x09,
  0x1A, 0x00, 0x3A, 0x0E, 0x80, 0x2D, 0x0C, 0x03, 0x1A, 0x83, 0x33, 0xFC, 0x17, 0x2A, 0x84, 0x32,
  0xC1, 0x07, 0x80, 0x4B, 0xA0, 0x34, 0x07, 0xFB, 0x03, 0x50, 0x68, 0x02, 0x70, 0x9A, 0x03, 0x76,
  0x81, 0x7F, 0x37, 0x70, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_question_answer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_question_answer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_question_mark 18x18, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_round_18_action_question_mark_data[] PROGMEM = {
  0x30, 0x03, 0x40, 0x60, 0xEA, 0x82, 0xE7, 0x04, 0xA0, 0x0A, 0xA8, 0x25, 0x3D, 0x52, 0x81, 0x6F,
  0xA5, 0x81, 0x4F, 0xB5, 0x81, 0xBF, 0x64, 0x81, 0xBF, 0xA4, 0x81, 0x8F, 0xB5, 0x81, 0xDF, 0x25,
  0x06, 0x07, 0x76, 0x82, 0x1C, 0xC1, 0x40, 0x4A, 0x04, 0x50, 0x09, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_question_mark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_action_question_mark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_quickreply 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_quickreply_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x3F, 0xD0, 0x30, 0x4F, 0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD,
  0x00, 0x4F, 0x98, 0x4B, 0x11, 0x10, 0x4F, 0x90, 0xA0, 0x6A, 0x0A, 0x04, 0xF9, 0x0A, 0x06, 0xA0,
  0x30, 0x4F, 0x98, 0x4A, 0x6F, 0xE3, 0x4A, 0x0A, 0x80, 0x19, 0x86, 0x65, 0xDF, 0xC4, 0xF7, 0x71,
  0x83, 0x1F, 0x44, 0x77, 0x20, 0x10, 0xB7, 0x50, 0x10, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_quickreply() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_quickreply_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_receipt 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_receipt_data[] PROGMEM = {
  0x89, 0x54, 0x9D, 0xAD, 0xBC, 0xCB, 0xDA, 0xD9, 0x34, 0xFD, 0x03, 0x04, 0xFD, 0x03, 0x04, 0xB8,
  0x02, 0xDB, 0x03, 0x04, 0xA0, 0x76, 0x07, 0xA0, 0x30, 0x4B, 0x80, 0x2B, 0xB0, 0x30, 0x4A, 0x0B,
  0x80, 0x25, 0x0B, 0xA0, 0x30, 0x4A, 0x0B, 0x80, 0x25, 0x0B, 0xA0, 0x30, 0x4B, 0x80, 0x2B, 0xB0,
  0x30, 0x4A, 0x07, 0x60, 0x7A, 0x03, 0x04, 0xB8, 0x02, 0xDB, 0x03, 0x04, 0xFD, 0x03, 0x04, 0xFD,
  0x89, 0x53, 0x49, 0xDA, 0xDB, 0xCB, 0xBC, 0xBD, 0xA3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_receipt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_receipt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_record_voice_over 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_record_voice_over_data[] PROGMEM = {
  0x75, 0x01, 0x07, 0x78, 0x15, 0x62, 0x48, 0x12, 0xF6, 0x50, 0xCA, 0x0E, 0x03, 0x28, 0x26, 0x09,
  0xD4, 0x05, 0xC0, 0xB2, 0x98, 0x25, 0x4F, 0x23, 0x06, 0xC0, 0xC2, 0x83, 0xE7, 0x3F, 0x23, 0x02,
  0x0E, 0xB0, 0x72, 0x81, 0xC2, 0x69, 0x58, 0x23, 0xBC, 0x75, 0x0D, 0x0A, 0x68, 0x11, 0x21, 0x48,
  0x13, 0xD1, 0x30, 0x50, 0xBC, 0x81, 0xD8, 0x16, 0x0B, 0xF9, 0x0E, 0x03, 0x40, 0x2F, 0xB0, 0x84,
  0x03, 0xFB, 0x09, 0x58, 0x06, 0x30, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_record_voice_over() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_record_voice_over_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_redeem 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_action_redeem_data[] PROGMEM = {
  0x50, 0x01, 0x20, 0x01, 0x72, 0x07, 0xA0, 0x06, 0xA0, 0x77, 0x18, 0x1E, 0x89, 0xA8, 0x19, 0x8E,
  0x58, 0x44, 0x77, 0xFB, 0xCA, 0x8B, 0x0C, 0xBF, 0x77, 0x40, 0x1F, 0xDD, 0xDD, 0xFD, 0xDF, 0xDD,
  0xDD, 0xF1, 0x3F, 0x22, 0x84, 0x6F, 0x33, 0xF6, 0x28, 0x90, 0x2F, 0x33, 0xF2, 0x02, 0xF7, 0x28,
  0x93, 0x7F, 0x20, 0x2F, 0x33, 0xF2, 0x01, 0x74, 0x87, 0x71, 0x02, 0xF3, 0x3F, 0x27, 0x38, 0x42,
  0xF3, 0x3F, 0x58, 0x06, 0x38, 0x25, 0xF3, 0x3F, 0xF8, 0x23, 0x3F, 0xA8, 0x06, 0x98, 0x4A, 0xF3,
  0x3F, 0x27, 0x38, 0x32, 0xF3, 0x1E, 0xFD, 0x82, 0xE1, 0x01, 0x80, 0x90, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_redeem() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_redeem_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_remove_done 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_remove_done_data[] PROGMEM = {
  0x10, 0xD0, 0x87, 0x58, 0x15, 0xF8, 0x75, 0x81, 0x5F, 0x87, 0x58, 0x15, 0xF8, 0x20, 0x30, 0x22,
  0x04, 0x01, 0x48, 0x90, 0x5F, 0x80, 0x86, 0x07, 0xF3, 0x58, 0x15, 0xF8, 0x28, 0x17, 0xF6, 0x20,
  0x23, 0x85, 0x15, 0xF8, 0x08, 0x62, 0x89, 0x04, 0xF5, 0x07, 0xE3, 0x5F, 0x85, 0x85, 0x9F, 0x50,
  0xBE, 0x9A, 0x08, 0x58, 0x90, 0x9F, 0x30, 0xBF, 0x65, 0xF8, 0x50, 0x13, 0x01, 0x28, 0x15, 0xF8,
  0x75, 0x81, 0x5F, 0x87, 0x50, 0x50, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_remove_done() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_remove_done_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_remove_shopping_cart 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_action_remove_shopping_cart_data[] PROGMEM = {
  0x05, 0x06, 0x76, 0x83, 0x5F, 0x70, 0x18, 0x05, 0x52, 0x83, 0x6F, 0x70, 0x9F, 0x90, 0x22, 0x83,
  0x8F, 0x70, 0x9E, 0x0B, 0x30, 0x1A, 0x81, 0x70, 0x9D, 0x04, 0x40, 0x9A, 0x81, 0x70, 0x9B, 0x0D,
  0x50, 0x3B, 0x81, 0x70, 0x9A, 0x06, 0x58, 0x75, 0xFD, 0xDF, 0x70, 0x8A, 0x60, 0xE0, 0x92, 0x81,
  0x6F, 0x77, 0x87, 0x1F, 0xCB, 0xBB, 0xEF, 0x77, 0x05, 0x80, 0x19, 0x81, 0xAF, 0x76, 0x00, 0x55,
  0x81, 0x6F, 0x74, 0x04, 0xA0, 0x34, 0x03, 0xA0, 0x73, 0x82, 0x2F, 0xE1, 0x40, 0x10, 0xEA, 0x06,
  0x30, 0x01, 0x68, 0x21, 0x15, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_remove_shopping_cart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_remove_shopping_cart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_reorder 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_18_action_reorder_data[] PROGMEM = {
  0x18, 0x09, 0x07, 0x10, 0x28, 0x09, 0x0D, 0x02, 0x77, 0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x18, 0x09,
  0x05, 0x28, 0x09, 0x05, 0x10, 0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x70, 0x28, 0x09, 0x0D, 0x02, 0x18,
  0x09, 0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_reorder() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_reorder_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_repartition 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_repartition_data[] PROGMEM = {
  0x10, 0x10, 0x97, 0x48, 0x11, 0xDD, 0x74, 0x0D, 0xFA, 0x85, 0xEB, 0x20, 0x6F, 0xC8, 0x03, 0x58,
  0x16, 0xBD, 0x28, 0x16, 0xF1, 0x78, 0x11, 0xF3, 0x74, 0x82, 0x5F, 0x22, 0x80, 0x6D, 0x90, 0x82,
  0x80, 0x57, 0x06, 0x03, 0x30, 0x28, 0x06, 0x38, 0x12, 0x03, 0xFD, 0x89, 0x63, 0x4F, 0x21, 0x9C,
  0x11, 0xC9, 0x12, 0xF4, 0x49, 0x20, 0x80, 0xC2, 0x0C, 0x08, 0x29, 0x04, 0x03, 0xFD, 0x03, 0x18,
  0x09, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_repartition() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_repartition_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_report_problem 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_report_problem_data[] PROGMEM = {
  0x70, 0x02, 0x76, 0x82, 0x1E, 0xE1, 0x75, 0x09, 0xA0, 0x97, 0x40, 0x3C, 0x03, 0x73, 0x0C, 0xC0,
  0xC7, 0x20, 0x6A, 0x00, 0x9A, 0x06, 0x70, 0x10, 0xEA, 0x00, 0x5A, 0x0E, 0x01, 0x60, 0x9B, 0x00,
  0x5B, 0x09, 0x50, 0x3C, 0x00, 0x9C, 0x03, 0x40, 0xCC, 0x00, 0xDC, 0x0C, 0x30, 0x6D, 0x00, 0x7D,
  0x82, 0x60, 0x1E, 0xFD, 0x81, 0xE1, 0x5F, 0xF0, 0x51, 0x80, 0x92, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_report_problem() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_report_problem_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_request_page 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_action_request_page_data[] PROGMEM = {
  0x02, 0x80, 0x27, 0x04, 0x40, 0xDF, 0x07, 0x3F, 0xA0, 0x72, 0xFB, 0x07, 0x1F, 0xC0, 0x7C, 0x82,
  0xC5, 0x5C, 0xB0, 0xEB, 0x0C, 0x40, 0xDE, 0x83, 0xB0, 0x8B, 0xCF, 0x0B, 0x40, 0xDF, 0x83, 0x87,
  0x50, 0xBE, 0x84, 0xE4, 0x32, 0x0B, 0xE8, 0x4E, 0x41, 0x14, 0xEF, 0x90, 0x0C, 0xFF, 0xB0, 0xDF,
  0xB0, 0xD0, 0x28, 0x06, 0x70, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_request_page() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_request_page_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_restore_from_trash 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_restore_from_trash_data[] PROGMEM = {
  0x48, 0x00, 0x35, 0x81, 0x55, 0x9C, 0x83, 0x95, 0x50, 0x3F, 0xB0, 0x31, 0x80, 0x61, 0x20, 0x7F,
  0x90, 0x72, 0x07, 0xF9, 0x07, 0x20, 0x7A, 0x82, 0xE3, 0x3E, 0xA0, 0x72, 0x07, 0xA0, 0x32, 0x03,
  0xA0, 0x72, 0x07, 0xA8, 0x2A, 0x33, 0xAA, 0x07, 0x20, 0x7B, 0x00, 0x5B, 0x07, 0x20, 0x7B, 0x00,
  0x6B, 0x07, 0x20, 0x7F, 0x90, 0x72, 0x05, 0xF9, 0x05, 0x38, 0x04, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_restore_from_trash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_restore_from_trash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_restore_page 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_restore_page_data[] PROGMEM = {
  0x10, 0x18, 0x02, 0x34, 0x02, 0xF0, 0x73, 0x06, 0xF9, 0x07, 0x20, 0x6F, 0xA8, 0x17, 0x06, 0xFB,
  0x87, 0x46, 0xFC, 0xEB, 0x66, 0xBB, 0x89, 0x06, 0x6F, 0xA1, 0x3A, 0xA3, 0x9A, 0x89, 0x06, 0x6F,
  0xA0, 0x2E, 0xFE, 0x1A, 0x00, 0x6F, 0x83, 0x3D, 0xF6, 0x6B, 0x0E, 0xA0, 0xE0, 0x2A, 0x00, 0x6A,
  0x84, 0xB2, 0x99, 0x2A, 0xA0, 0x06, 0xB8, 0x2C, 0x77, 0xCB, 0x00, 0x6F, 0xB0, 0x06, 0xFB, 0x06,
  0x02, 0xFB, 0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_restore_page() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_restore_page_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_restore 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_round_18_action_restore_data[] PROGMEM = {
  0x68, 0x11, 0x33, 0x73, 0x03, 0x0B, 0xC0, 0xB0, 0x26, 0x89, 0x05, 0xFB, 0x41, 0x14, 0xBE, 0x54,
  0x81, 0x3F, 0x82, 0x00, 0x42, 0x81, 0x8E, 0x23, 0x00, 0xB3, 0x00, 0xA3, 0x00, 0xB2, 0x81, 0x1F,
  0x43, 0x00, 0xA3, 0x05, 0x92, 0x81, 0x3F, 0x13, 0x0A, 0x0C, 0x38, 0x21, 0xF3, 0x8B, 0x04, 0x28,
  0x13, 0xEA, 0x28, 0x51, 0xF3, 0x0B, 0xF8, 0x48, 0x53, 0xE6, 0x05, 0xF1, 0x20, 0x56, 0x01, 0x20,
  0x0B, 0x50, 0x46, 0x81, 0x8F, 0x34, 0x89, 0x03, 0xFB, 0x41, 0x15, 0xBF, 0x56, 0x03, 0x0B, 0xC0,
  0xB0, 0x37, 0x28, 0x21, 0x33, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_restore() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_restore_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_rocket_launch 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_action_rocket_launch_data[] PROGMEM = {
  0x73, 0x82, 0x59, 0xB8, 0x71, 0x04, 0x0D, 0xB0, 0xB3, 0x83, 0x13, 0x10, 0x8D, 0x09, 0x28, 0x73,
  0xEF, 0x39, 0xFA, 0x7E, 0xA8, 0x75, 0x03, 0xEF, 0x76, 0xFE, 0x28, 0x90, 0x7F, 0xD0, 0x3E, 0xFD,
  0x2E, 0xA8, 0x91, 0x30, 0xAF, 0x40, 0x4C, 0xF5, 0x9C, 0x81, 0xEF, 0x84, 0x81, 0x20, 0xED, 0x09,
  0x70, 0x4B, 0x82, 0xE6, 0x31, 0x38, 0x91, 0x4A, 0x80, 0x4E, 0xA2, 0x7F, 0x32, 0x02, 0xB0, 0x82,
  0x83, 0x5D, 0xFE, 0x12, 0x08, 0xB8, 0x1A, 0x02, 0xA0, 0xE0, 0x33, 0x0D, 0xB0, 0x42, 0x81, 0xDE,
  0x34, 0x98, 0x1D, 0x82, 0x30, 0x40, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_rocket_launch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_rocket_launch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_rocket 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_rocket_data[] PROGMEM = {
  0x50, 0x05, 0x72, 0x03, 0xA0, 0x37, 0x10, 0xDA, 0x0D, 0x70, 0x4C, 0x04, 0x68, 0x49, 0xFD, 0xDF,
  0x96, 0x00, 0xC2, 0x00, 0xC6, 0x0D, 0x0B, 0x20, 0xB0, 0xD6, 0x84, 0xEF, 0xBA, 0xFE, 0x48, 0x1A,
  0x4D, 0xC8, 0x6D, 0x4A, 0x05, 0xF6, 0xAC, 0x86, 0xA6, 0xF5, 0x6F, 0x96, 0xC8, 0x67, 0x9F, 0x66,
  0xFD, 0x2C, 0x83, 0x2D, 0xF6, 0x6A, 0x84, 0x35, 0x55, 0x53, 0xA8, 0x26, 0x4B, 0x36, 0x81, 0x3B,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_rocket() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_rocket_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_room 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_room_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x30, 0x20, 0xDE, 0x0D, 0x02, 0x20, 0xDF, 0x98,
  0x1D, 0x06, 0xFB, 0x06, 0x0B, 0xC0, 0x07, 0xC0, 0xB0, 0xCB, 0x0A, 0x20, 0xAB, 0x0C, 0x09, 0xB8,
  0x2E, 0x22, 0xEB, 0x0B, 0x05, 0xFB, 0x81, 0x60, 0xDF, 0x90, 0xD2, 0x05, 0xF9, 0x05, 0x30, 0x9E,
  0x09, 0x50, 0xBC, 0x0B, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x71, 0x00, 0xA5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_room() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_room_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_rounded_corner 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_rounded_corner_data[] PROGMEM = {
  0x89, 0x11, 0x40, 0x23, 0x03, 0x33, 0x32, 0x38, 0x54, 0xF0, 0x7D, 0x0D, 0xC0, 0xB0, 0x17, 0x38,
  0x51, 0x6E, 0xB0, 0x27, 0x72, 0x83, 0x6F, 0x23, 0xD7, 0x28, 0x11, 0xF4, 0x75, 0x98, 0x14, 0x3A,
  0x73, 0x98, 0x14, 0x3A, 0x73, 0x0D, 0x04, 0x77, 0x03, 0x0D, 0x73, 0x82, 0xD3, 0x27, 0x73, 0x07,
  0x02, 0x77, 0x8B, 0x24, 0xF0, 0x7D, 0x0A, 0xA0, 0xD7, 0x0F, 0x41, 0x40, 0x23, 0x03, 0x30, 0x32,
  0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_rounded_corner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_rounded_corner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_rowing 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_rowing_data[] PROGMEM = {
  0x68, 0x1A, 0xE6, 0x71, 0x02, 0xA0, 0xD7, 0x28, 0x1C, 0xF8, 0x73, 0x03, 0x73, 0x81, 0xBF, 0x67,
  0x01, 0x0A, 0xA0, 0xA5, 0x82, 0x29, 0xED, 0xA0, 0xA5, 0x85, 0x5E, 0xE1, 0xDF, 0xA6, 0x84, 0x3E,
  0xB2, 0xDA, 0x58, 0x51, 0x63, 0xEB, 0x27, 0x48, 0x51, 0xDD, 0x33, 0xEB, 0x48, 0x21, 0xDC, 0x12,
  0x87, 0x3E, 0xB7, 0x10, 0x6C, 0x14, 0x04, 0xA0, 0xD0, 0x27, 0x01, 0xB0, 0xC7, 0x10, 0x7A, 0x07,
  0x72, 0x05, 0x06, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_rowing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_action_rowing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_rule 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_rule_data[] PROGMEM = {
  0x76, 0x81, 0x19, 0x17, 0x58, 0x31, 0xDE, 0x13, 0x80, 0x1B, 0x89, 0x1A, 0x10, 0xCB, 0x2D, 0xE3,
  0x03, 0x80, 0x1B, 0x82, 0xA1, 0x05, 0xA0, 0xE0, 0x37, 0x58, 0x15, 0xC3, 0x77, 0x77, 0x07, 0x04,
  0x20, 0x80, 0x27, 0x38, 0x6A, 0xF5, 0xBF, 0x30, 0x38, 0x01, 0xB0, 0xA0, 0x12, 0x0B, 0xA0, 0x52,
  0x03, 0x80, 0x1B, 0x0A, 0x01, 0x20, 0xBA, 0x05, 0x74, 0x84, 0xAF, 0x5B, 0xF3, 0x73, 0x07, 0x04,
  0x20, 0x80, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_rule() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_rule_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_satellite_alt 18x18, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_round_18_action_satellite_alt_data[] PROGMEM = {
  0x74, 0x82, 0x4E, 0xB1, 0x75, 0x84, 0x4F, 0xAD, 0xC1, 0x73, 0x04, 0xA8, 0x32, 0x2D, 0xC1, 0x72,
  0x86, 0xEA, 0x4D, 0x22, 0xDB, 0x72, 0x86, 0xDC, 0x14, 0xD2, 0xAE, 0x68, 0x91, 0x4D, 0x92, 0xDC,
  0x14, 0xEF, 0x45, 0x04, 0xB8, 0x5A, 0xDD, 0xC9, 0xF4, 0x60, 0xDC, 0x83, 0xB2, 0xDE, 0x47, 0x09,
  0xD0, 0x97, 0x83, 0x4E, 0xD2, 0xAC, 0x0D, 0x68, 0x54, 0xFA, 0xCD, 0xDB, 0xB8, 0x14, 0x01, 0x20,
  0x10, 0x4A, 0x8A, 0x44, 0x1C, 0xD2, 0x9D, 0x40, 0x1F, 0x34, 0xEE, 0xA2, 0xD4, 0x1C, 0xD3, 0x89,
  0x41, 0xBD, 0x09, 0xBB, 0xD2, 0x2D, 0x49, 0xE2, 0x89, 0x21, 0xFD, 0x32, 0xE6, 0x1C, 0xD2, 0x2A,
  0x04, 0x38, 0x33, 0x02, 0xDB, 0x28, 0x41, 0xCD, 0xAF, 0x44, 0x83, 0x49, 0xEB, 0x13, 0x82, 0x1B,
  0xE4, 0x48, 0x21, 0xFB, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_satellite_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_satellite_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_saved_search 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_saved_search_data[] PROGMEM = {
  0x48, 0x13, 0x31, 0x71, 0x05, 0x0E, 0xB0, 0x96, 0x86, 0x5F, 0x92, 0x26, 0xEB, 0x58, 0x7D, 0x90,
  0x16, 0x03, 0xF5, 0x38, 0x90, 0x3F, 0x36, 0xBD, 0x91, 0xC9, 0x38, 0x90, 0x3F, 0x10, 0xCF, 0x40,
  0xBA, 0x38, 0x90, 0x1F, 0x60, 0x96, 0x50, 0xE7, 0x48, 0x19, 0xE3, 0x28, 0x21, 0xAE, 0x15, 0x86,
  0xBF, 0xCA, 0xEE, 0xF7, 0x68, 0x64, 0x9A, 0x71, 0x6F, 0x77, 0x48, 0x16, 0xF7, 0x74, 0x81, 0x6F,
  0x77, 0x40, 0x60, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_saved_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_saved_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_savings 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_savings_data[] PROGMEM = {
  0x74, 0x02, 0x76, 0x08, 0xA0, 0x55, 0x85, 0x18, 0xCD, 0xDD, 0xEB, 0x03, 0x40, 0x20, 0xEF, 0xA0,
  0x74, 0x0B, 0xB8, 0x2B, 0x55, 0x9C, 0x82, 0x71, 0x01, 0xC8, 0x59, 0x33, 0x7F, 0xEE, 0xB0, 0x10,
  0x2F, 0xA0, 0x50, 0x7B, 0x03, 0x1F, 0xF8, 0x13, 0x0D, 0xFE, 0x81, 0x30, 0xAF, 0xD8, 0x2D, 0x10,
  0x6F, 0xC0, 0x33, 0x02, 0xFB, 0x0C, 0x50, 0xEF, 0xA0, 0x85, 0x08, 0xB8, 0x17, 0x0C, 0xB0, 0x36,
  0x0F, 0x32, 0x82, 0x13, 0x32, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_savings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_savings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_schedule 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_schedule_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9C, 0x00, 0xCC, 0x09,
  0x30, 0x3D, 0x00, 0x5D, 0x03, 0x20, 0xBD, 0x00, 0x5D, 0x0B, 0x2E, 0x00, 0x5E, 0x10, 0x2E, 0x05,
  0x03, 0xE0, 0x02, 0xE8, 0x1C, 0x04, 0xD0, 0x21, 0xF8, 0x1B, 0x04, 0xC2, 0x0B, 0xF8, 0x1B, 0x3E,
  0xA0, 0xB2, 0x03, 0xFD, 0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_schedule() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_schedule_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_schedule_send 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_schedule_send_data[] PROGMEM = {
  0x10, 0x17, 0x68, 0x24, 0xFA, 0x47, 0x40, 0x4B, 0x81, 0xD7, 0x17, 0x10, 0x4E, 0x0A, 0x04, 0x70,
  0x70, 0xCE, 0x0B, 0x02, 0x78, 0x42, 0x7C, 0xFC, 0x27, 0x28, 0x90, 0x27, 0xCC, 0x03, 0xBE, 0xC5,
  0x30, 0x70, 0xCB, 0x02, 0x03, 0xA0, 0xEA, 0x81, 0x60, 0x4C, 0x81, 0xD0, 0xBA, 0x02, 0xA8, 0x1E,
  0x04, 0xB8, 0x2D, 0x50, 0xEA, 0x02, 0x0C, 0xA8, 0x32, 0x4F, 0xA4, 0x30, 0xCA, 0x0C, 0x02, 0xA2,
  0x01, 0x50, 0x5D, 0x09, 0x72, 0x06, 0x0E, 0xA0, 0x97, 0x50, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_schedule_send() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_schedule_send_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_search_off 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_round_18_action_search_off_data[] PROGMEM = {
  0x48, 0x12, 0x44, 0x71, 0x84, 0xAB, 0x8A, 0xD3, 0x50, 0xA0, 0x63, 0x81, 0x3D, 0x13, 0x02, 0x0C,
  0x50, 0x07, 0x30, 0x10, 0x25, 0x03, 0x0A, 0x20, 0x22, 0x03, 0x40, 0x50, 0x82, 0x82, 0x6C, 0xB7,
  0x40, 0xC0, 0x33, 0x0C, 0x0D, 0x28, 0x33, 0x5C, 0xE3, 0x28, 0x91, 0x88, 0x69, 0x08, 0x82, 0x3D,
  0x37, 0x38, 0x13, 0xD3, 0x73, 0x03, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_search_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_action_search_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_search 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_search_data[] PROGMEM = {
  0x48, 0x13, 0x31, 0x71, 0x05, 0x0D, 0xB0, 0x96, 0x86, 0x5F, 0x92, 0x16, 0xEB, 0x50, 0xD0, 0x94,
  0x81, 0x3F, 0x43, 0x81, 0x3F, 0x35, 0x0C, 0x09, 0x38, 0x13, 0xF1, 0x50, 0xB0, 0xA3, 0x81, 0x1F,
  0x65, 0x0E, 0x07, 0x48, 0x19, 0xE3, 0x38, 0x1A, 0xE1, 0x58, 0x6B, 0xFC, 0xAE, 0xEF, 0x76, 0x86,
  0x59, 0xA7, 0x17, 0xF7, 0x74, 0x81, 0x7F, 0x77, 0x48, 0x17, 0xF6, 0x74, 0x07, 0x0D,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_segment 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_round_18_action_segment_data[] PROGMEM = {
  0x18, 0x09, 0x07, 0x10, 0x28, 0x09, 0x0D, 0x02, 0x77, 0x77, 0x50, 0x68, 0x03, 0x90, 0x15, 0x06,
  0x80, 0x39, 0x01, 0x77, 0x77, 0x50, 0x88, 0x03, 0xD0, 0x25, 0x04, 0x80, 0x37, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_segment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_segment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_send_and_archive 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_send_and_archive_data[] PROGMEM = {
  0x00, 0x17, 0x68, 0x24, 0xFA, 0x47, 0x40, 0x4B, 0x81, 0xD7, 0x17, 0x10, 0x4E, 0x0A, 0x04, 0x68,
  0x11, 0x7C, 0xE0, 0xB0, 0x27, 0x84, 0x27, 0xCF, 0xC2, 0x72, 0x89, 0x02, 0x7C, 0xC0, 0x3B, 0xEC,
  0x52, 0x81, 0x17, 0xCB, 0x02, 0x03, 0xA0, 0xDA, 0x81, 0x60, 0x4C, 0x81, 0xD0, 0xBA, 0x84, 0x2E,
  0xFE, 0x04, 0xB8, 0x95, 0xD5, 0x0E, 0xF9, 0x19, 0xEF, 0x24, 0xFA, 0x43, 0x83, 0xCF, 0xA0, 0x7A,
  0x10, 0x01, 0x50, 0x5A, 0x0D, 0xA0, 0x97, 0x20, 0x60, 0xEA, 0x09, 0x75, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_send_and_archive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_send_and_archive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_sensors_off 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_action_sensors_off_data[] PROGMEM = {
  0x10, 0xE0, 0x77, 0x78, 0x16, 0xF7, 0x71, 0x05, 0x07, 0x30, 0x4A, 0x07, 0x78, 0x14, 0xF4, 0x28,
  0x3B, 0xC6, 0xF7, 0x48, 0x35, 0x90, 0xBB, 0x29, 0x06, 0x03, 0xA0, 0x73, 0x89, 0x44, 0xF3, 0x5F,
  0x02, 0xF3, 0x6E, 0x6F, 0x73, 0x89, 0x4E, 0x63, 0xF2, 0x2F, 0x36, 0xE0, 0x6F, 0x72, 0x8A, 0x1E,
  0x63, 0xF2, 0x0F, 0x53, 0xF4, 0x06, 0xF7, 0x09, 0x35, 0x92, 0x83, 0xBB, 0x09, 0x52, 0x81, 0x6F,
  0x72, 0x00, 0xB2, 0x81, 0x4F, 0x45, 0x84, 0x6F, 0x70, 0x94, 0x30, 0x70, 0x56, 0x81, 0x6F, 0x77,
  0x78, 0x16, 0xF7, 0x77, 0x06, 0x0E, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_sensors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_sensors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_sensors 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_sensors_data[] PROGMEM = {
  0x20, 0x70, 0x57, 0x10, 0x50, 0x73, 0x81, 0x4F, 0x57, 0x18, 0x14, 0xF4, 0x28, 0x3B, 0xB0, 0x95,
  0x48, 0x35, 0x90, 0xBB, 0x29, 0x8A, 0x35, 0x3F, 0x40, 0x66, 0x04, 0xF3, 0x5F, 0x02, 0xF3, 0x6E,
  0x06, 0xA8, 0x94, 0x60, 0xE6, 0x3F, 0x22, 0xF3, 0x6E, 0x06, 0xA8, 0xA3, 0x60, 0xE6, 0x3F, 0x20,
  0xF5, 0x3F, 0x40, 0x66, 0x04, 0xF3, 0x59, 0x28, 0x3B, 0xB0, 0x95, 0x48, 0x35, 0x90, 0xBB, 0x28,
  0x14, 0xF4, 0x71, 0x81, 0x4F, 0x43, 0x07, 0x05, 0x71, 0x05, 0x07, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_sensors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_sensors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_accessibility 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_round_18_action_settings_accessibility_data[] PROGMEM = {
  0x58, 0x21, 0x99, 0x17, 0x30, 0x7A, 0x07, 0x73, 0x05, 0xA0, 0x56, 0x01, 0x40, 0x03, 0x48, 0x11,
  0x01, 0xA8, 0x6C, 0x99, 0x77, 0x99, 0xCA, 0x84, 0x10, 0x25, 0x8B, 0xC8, 0x2B, 0x85, 0x25, 0x03,
  0xC0, 0x37, 0x10, 0x3C, 0x03, 0x71, 0x03, 0xC0, 0x37, 0x18, 0x43, 0xFD, 0xDF, 0x37, 0x18, 0x43,
  0xF1, 0x1F, 0x37, 0x18, 0x43, 0xF1, 0x1F, 0x37, 0x18, 0x43, 0xF1, 0x1F, 0x37, 0x18, 0x43, 0xF1,
  0x1F, 0x37, 0x20, 0x42, 0x04, 0x77, 0x71, 0x86, 0x12, 0x01, 0x10, 0x21, 0x68, 0x66, 0x90, 0x88,
  0x09, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_accessibility() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_round_18_action_settings_accessibility_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_applications 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_action_settings_applications_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4D, 0x00, 0x9D, 0x00, 0x4B,
  0x84, 0xDC, 0x11, 0xCD, 0xB0, 0x04, 0xA0, 0xC2, 0x00, 0x32, 0x0C, 0xA0, 0x04, 0xB0, 0x03, 0xA0,
  0x03, 0xB0, 0x04, 0xB0, 0x40, 0x3A, 0x00, 0x3B, 0x00, 0x4A, 0x0C, 0x20, 0x03, 0x20, 0xCA, 0x00,
  0x4B, 0x84, 0xCC, 0x11, 0xCC, 0xB0, 0x04, 0xD0, 0x09, 0xD0, 0x04, 0xFD, 0x04, 0x02, 0xFD, 0x81,
  0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_applications() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_settings_applications_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_backup_restore 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_action_settings_backup_restore_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x38, 0x92, 0x4D, 0x7F, 0xB5, 0x11, 0x4B,
  0xF5, 0x20, 0x4A, 0x09, 0x68, 0x38, 0xF3, 0x04, 0xA0, 0xD7, 0x00, 0xB2, 0x0F, 0x32, 0x00, 0x33,
  0x81, 0x5F, 0x15, 0x03, 0xA0, 0x32, 0x84, 0x1F, 0x32, 0xD1, 0x20, 0x3A, 0x03, 0x28, 0x41, 0xF3,
  0x1F, 0x53, 0x00, 0x33, 0x84, 0x4F, 0x10, 0xBB, 0x71, 0x00, 0xB2, 0x81, 0x3F, 0x86, 0x81, 0x8F,
  0x33, 0x89, 0x05, 0xFC, 0x52, 0x14, 0xBF, 0x55, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x18, 0x21, 0x33,
  0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_backup_restore() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_settings_backup_restore_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_bluetooth 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_settings_bluetooth_data[] PROGMEM = {
  0x48, 0x19, 0xC1, 0x68, 0x5D, 0xFD, 0x10, 0xC4, 0x28, 0xA5, 0xD8, 0xDD, 0x19, 0xF4, 0x0D, 0x61,
  0xDB, 0x09, 0xF4, 0xD6, 0x4F, 0x92, 0x09, 0xA8, 0x1B, 0xF9, 0x40, 0x9A, 0x09, 0x50, 0x4A, 0x04,
  0x40, 0x4A, 0x81, 0xEF, 0x42, 0x8A, 0x14, 0xF9, 0xE7, 0x9F, 0x44, 0xF9, 0x0D, 0x60, 0xDC, 0xE9,
  0x28, 0x4D, 0x68, 0xF5, 0x33, 0x82, 0xDD, 0xF5, 0x58, 0x1C, 0xF5, 0x60, 0x20, 0x37, 0x68, 0x97,
  0x12, 0x01, 0x10, 0x21, 0x06, 0x90, 0x88, 0x09, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_bluetooth() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 12, 17), Box(0, 0, 17, 17),
      ic_round_18_action_settings_bluetooth_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_brightness 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_settings_brightness_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x05, 0x81, 0x20, 0x1F, 0xF0, 0x10, 0x3E, 0x00, 0xAE, 0x00, 0x3C, 0x07, 0x03,
  0x20, 0x30, 0x7C, 0x00, 0x3C, 0x04, 0x28, 0x1A, 0x14, 0xC0, 0x03, 0xB0, 0xA3, 0x98, 0x1A, 0x0A,
  0xB0, 0x03, 0xB0, 0xA3, 0x98, 0x1A, 0x0A, 0xB0, 0x03, 0xC0, 0x42, 0x81, 0xA1, 0x4C, 0x00, 0x3C,
  0x07, 0x03, 0x20, 0x30, 0x7C, 0x00, 0x3E, 0x00, 0xAE, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x28, 0x09,
  0x05, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_brightness() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_settings_brightness_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_cell 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_settings_cell_data[] PROGMEM = {
  0x02, 0x0E, 0xE8, 0x1E, 0x27, 0xF9, 0x00, 0x7F, 0x98, 0x17, 0x7E, 0x80, 0x29, 0x82, 0xE7, 0x7D,
  0x68, 0x2D, 0x77, 0xD6, 0x82, 0xD7, 0x7D, 0x68, 0x2D, 0x77, 0xD6, 0x82, 0xD7, 0x7D, 0x68, 0x2D,
  0x77, 0xD6, 0x82, 0xD7, 0x7D, 0x68, 0x2D, 0x77, 0xD8, 0x02, 0x38, 0x1D, 0x77, 0xF9, 0x00, 0x7F,
  0x90, 0x70, 0x5F, 0x90, 0x51, 0x80, 0x43, 0x28, 0x61, 0x20, 0x11, 0x02, 0x12, 0x86, 0x69, 0x08,
  0x80, 0x96, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_cell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 13, 17), Box(0, 0, 17, 17),
      ic_round_18_action_settings_cell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_ethernet 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_settings_ethernet_data[] PROGMEM = {
  0x40, 0x16, 0x01, 0x70, 0x90, 0xE6, 0x0E, 0x09, 0x58, 0x19, 0xF5, 0x68, 0x15, 0xF9, 0x38, 0x19,
  0xF5, 0x71, 0x8C, 0x65, 0xF9, 0x07, 0xF5, 0x04, 0x50, 0x44, 0x05, 0x40, 0x5F, 0x77, 0xF5, 0x04,
  0x50, 0x44, 0x05, 0x40, 0x5F, 0x70, 0x9F, 0x57, 0x18, 0x15, 0xF9, 0x38, 0x19, 0xF5, 0x68, 0x15,
  0xF9, 0x50, 0x90, 0xE6, 0x0E, 0x09, 0x70, 0x16, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_ethernet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_settings_ethernet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_input_antenna 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_action_settings_input_antenna_data[] PROGMEM = {
  0x48, 0x14, 0xAE, 0xA8, 0x1E, 0xA4, 0x68, 0x92, 0x1A, 0xFB, 0x64, 0x46, 0xBF, 0xA1, 0x38, 0x94,
  0x1C, 0xD4, 0x01, 0x44, 0x10, 0x4D, 0xC1, 0x28, 0x3A, 0xD1, 0x2A, 0xC8, 0x93, 0xA2, 0x1D, 0xA0,
  0x4F, 0x41, 0xDD, 0x42, 0x89, 0x24, 0xDD, 0x14, 0xF4, 0xAB, 0x0B, 0xD6, 0x8A, 0x7D, 0xB0, 0xBA,
  0xE6, 0x1F, 0x40, 0x1A, 0xA2, 0x04, 0xF1, 0x6E, 0xD3, 0x3D, 0x20, 0xAA, 0x0A, 0x28, 0x2D, 0x33,
  0xD6, 0x0A, 0xA0, 0xA7, 0x58, 0x21, 0xDD, 0x17, 0x60, 0x0A, 0x77, 0x00, 0xA7, 0x60, 0x6A, 0x06,
  0x74, 0x84, 0x6F, 0x77, 0xF6, 0x73, 0x0A, 0x07, 0x20, 0x70, 0xA5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_input_antenna() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_settings_input_antenna_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_input_component 18x18, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_round_18_action_settings_input_component_data[] PROGMEM = {
  0x20, 0x60, 0xB4, 0x00, 0x94, 0x0B, 0x06, 0x40, 0x80, 0xC4, 0x00, 0xA4, 0x0C, 0x08, 0x40, 0x80,
  0xC4, 0x00, 0xA4, 0x0C, 0x08, 0x38, 0xA0, 0x7B, 0xE7, 0x31, 0x7C, 0xC7, 0x13, 0x7E, 0xB7, 0x01,
  0xC0, 0x60, 0x3C, 0x03, 0x06, 0xC0, 0x01, 0xC0, 0x60, 0x3C, 0x03, 0x06, 0xC0, 0x01, 0xC0, 0x60,
  0x3C, 0x03, 0x06, 0xC0, 0x01, 0xC0, 0x60, 0x3C, 0x03, 0x06, 0xC0, 0x17, 0x74, 0x8A, 0x01, 0x99,
  0x99, 0x32, 0x99, 0x99, 0x23, 0x99, 0x99, 0x11, 0xC0, 0x50, 0x3C, 0x03, 0x05, 0xC2, 0x0A, 0xA8,
  0x2D, 0x10, 0xCA, 0x82, 0xC0, 0x1D, 0xA0, 0xA3, 0x81, 0xAD, 0x13, 0x00, 0xB3, 0x81, 0x1D, 0xA4,
  0x08, 0x0C, 0x40, 0x0A, 0x40, 0xC0, 0x84, 0x08, 0x0C, 0x40, 0x0A, 0x40, 0xC0, 0x84, 0x06, 0x0B,
  0x40, 0x09, 0x40, 0xB0, 0x62,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_input_component() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_settings_input_component_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_input_composite 18x18, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_round_18_action_settings_input_composite_data[] PROGMEM = {
  0x20, 0x60, 0xB4, 0x00, 0x94, 0x0B, 0x06, 0x40, 0x80, 0xC4, 0x00, 0xA4, 0x0C, 0x08, 0x40, 0x80,
  0xC4, 0x00, 0xA4, 0x0C, 0x08, 0x38, 0xA0, 0x7B, 0xE7, 0x31, 0x7C, 0xC7, 0x13, 0x7E, 0xB7, 0x01,
  0xC0, 0x60, 0x3C, 0x03, 0x06, 0xC0, 0x01, 0xC0, 0x60, 0x3C, 0x03, 0x06, 0xC0, 0x01, 0xC0, 0x60,
  0x3C, 0x03, 0x06, 0xC0, 0x01, 0xC0, 0x60, 0x3C, 0x03, 0x06, 0xC0, 0x17, 0x74, 0x8A, 0x01, 0x99,
  0x99, 0x32, 0x99, 0x99, 0x23, 0x99, 0x99, 0x11, 0xC0, 0x50, 0x3C, 0x03, 0x05, 0xC2, 0x0A, 0xA8,
  0x2D, 0x10, 0xCA, 0x82, 0xC0, 0x1D, 0xA0, 0xA3, 0x81, 0xAD, 0x13, 0x00, 0xB3, 0x81, 0x1D, 0xA4,
  0x08, 0x0C, 0x40, 0x0A, 0x40, 0xC0, 0x84, 0x08, 0x0C, 0x40, 0x0A, 0x40, 0xC0, 0x84, 0x06, 0x0B,
  0x40, 0x09, 0x40, 0xB0, 0x62,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_input_composite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_settings_input_composite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_input_hdmi 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_action_settings_input_hdmi_data[] PROGMEM = {
  0x20, 0x18, 0x02, 0x30, 0x13, 0x04, 0xF9, 0x04, 0x20, 0x70, 0xD8, 0x02, 0x10, 0xD0, 0x72, 0x8A,
  0x67, 0xD0, 0xA1, 0x1A, 0x0D, 0x70, 0x2C, 0xE9, 0xEA, 0xAE, 0x9E, 0xC2, 0x6F, 0xB0, 0x06, 0xFB,
  0x00, 0x6F, 0xB0, 0x06, 0xFB, 0x81, 0x61, 0xEF, 0x98, 0x2E, 0x10, 0x6F, 0x90, 0x63, 0x0C, 0xE0,
  0xC4, 0x03, 0xE0, 0x35, 0x0B, 0xC0, 0xB6, 0x0A, 0xC0, 0xA6, 0x84, 0x13, 0x33, 0x31, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_input_hdmi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_settings_input_hdmi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_input_svideo 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_round_18_action_settings_input_svideo_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x89,
  0x29, 0xF5, 0x03, 0x77, 0x30, 0x5F, 0x93, 0x81, 0x3F, 0x52, 0x0A, 0xA0, 0xA2, 0x81, 0x5F, 0x32,
  0x00, 0xB3, 0x82, 0x13, 0x31, 0x30, 0x0B, 0x29, 0x81, 0x50, 0x36, 0x89, 0x13, 0x05, 0xF0, 0x2F,
  0x36, 0xF3, 0x48, 0x91, 0x3F, 0x63, 0xF2, 0x2F, 0x31, 0x56, 0x86, 0x51, 0x3F, 0x20, 0xF5, 0x20,
  0x14, 0x01, 0x20, 0x59, 0x20, 0x0B, 0x29, 0x08, 0x20, 0x89, 0x20, 0x0B, 0x28, 0x43, 0xF5, 0x07,
  0x22, 0x84, 0x27, 0x05, 0xF3, 0x38, 0x19, 0xF5, 0x68, 0x15, 0xF9, 0x58, 0x90, 0x9F, 0xB5, 0x33,
  0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_input_svideo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_settings_input_svideo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_overscan 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_settings_overscan_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x24, 0x00, 0x24, 0x84, 0x2F, 0x33,
  0xF2, 0x40, 0x0A, 0x48, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x62, 0xF3, 0x3F, 0x26, 0x66, 0x89, 0x06,
  0x62, 0xF3, 0x3F, 0x26, 0x66, 0x86, 0x66, 0x2F, 0x33, 0xF2, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x40,
  0x0A, 0x48, 0x42, 0xF3, 0x3F, 0x24, 0x00, 0x24, 0x82, 0x2F, 0x31, 0xFF, 0x81, 0x10, 0x38, 0x09,
  0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_overscan() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_settings_overscan_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_phone 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_settings_phone_data[] PROGMEM = {
  0x10, 0xF3, 0x02, 0x72, 0x03, 0xB0, 0xE7, 0x20, 0x2C, 0x04, 0x72, 0xC0, 0x67, 0x20, 0xBA, 0x81,
  0xD1, 0x12, 0x02, 0x20, 0x22, 0x89, 0x35, 0xFD, 0x10, 0xC5, 0x0D, 0x40, 0xE2, 0x20, 0xD0, 0xA7,
  0x58, 0x14, 0xF5, 0x75, 0x81, 0x8E, 0x33, 0x81, 0x16, 0x46, 0x84, 0xAE, 0x50, 0x1D, 0xA0, 0xE0,
  0x25, 0x82, 0x8F, 0xAD, 0xC0, 0x46, 0x04, 0x0D, 0xD0, 0x47, 0x10, 0x50, 0xBB, 0x03, 0x74, 0x02,
  0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_settings_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_settings_data[] PROGMEM = {
  0x60, 0x03, 0x74, 0x08, 0xA0, 0x87, 0x30, 0xCA, 0x0C, 0x68, 0x27, 0x74, 0xBC, 0x84, 0xB4, 0x77,
  0x04, 0xFD, 0x04, 0x09, 0xC8, 0x2C, 0x66, 0xCC, 0x81, 0x92, 0xDA, 0x0C, 0x40, 0xCA, 0x82, 0xD2,
  0x05, 0xA0, 0x64, 0x06, 0xA0, 0x52, 0x05, 0xA0, 0x64, 0x06, 0xA8, 0x25, 0x02, 0xDA, 0x0C, 0x40,
  0xCA, 0x81, 0xD2, 0x9C, 0x82, 0xC6, 0x6C, 0xC0, 0x90, 0x4F, 0xD8, 0x44, 0x07, 0x74, 0xBC, 0x82,
  0xB4, 0x77, 0x60, 0xCA, 0x0C, 0x73, 0x08, 0xA0, 0x87, 0x40, 0x03, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_power 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_settings_power_data[] PROGMEM = {
  0x50, 0x09, 0x73, 0x00, 0xA6, 0x89, 0x03, 0xD1, 0x0A, 0xA0, 0x1D, 0x32, 0x0D, 0x0B, 0x20, 0x0A,
  0x28, 0x4B, 0xD0, 0x6E, 0x12, 0x00, 0xA2, 0x83, 0x1E, 0x6B, 0xA3, 0x00, 0xA3, 0x82, 0xAB, 0xC8,
  0x30, 0x08, 0x38, 0x28, 0xCB, 0x97, 0x18, 0x29, 0xB7, 0xE7, 0x18, 0x3E, 0x71, 0xE9, 0x68, 0x69,
  0xE1, 0x04, 0xFB, 0x32, 0x82, 0x3B, 0xF4, 0x30, 0x30, 0xCC, 0x0C, 0x03, 0x68, 0x22, 0x55, 0x27,
  0x74, 0x86, 0x12, 0x01, 0x10, 0x21, 0x48, 0x66, 0x90, 0x88, 0x09, 0x62,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_power() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_action_settings_power_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_remote 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_round_18_action_settings_remote_data[] PROGMEM = {
  0x28, 0x63, 0x9C, 0xFE, 0xC8, 0x23, 0x89, 0x49, 0xFC, 0x85, 0x58, 0xDF, 0x80, 0x4E, 0x56, 0x81,
  0x6E, 0x43, 0x84, 0x29, 0xCB, 0x81, 0x58, 0x51, 0xFD, 0x89, 0xDE, 0x60, 0x34, 0x03, 0x77, 0x48,
  0x47, 0xBB, 0xBB, 0x76, 0x0A, 0xC0, 0xA6, 0x84, 0xAF, 0x55, 0xFA, 0x68, 0x4A, 0xF8, 0x8F, 0xA6,
  0x0A, 0xC0, 0xA6, 0x0A, 0xC0, 0xA6, 0x0A, 0xC0, 0xA6, 0x0A, 0xC0, 0xA6, 0x0A, 0xC0, 0xA6, 0x0A,
  0xC0, 0xA7, 0x80, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_remote() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_round_18_action_settings_remote_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_settings_voice 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_settings_voice_data[] PROGMEM = {
  0x30, 0x6A, 0x06, 0x50, 0x1C, 0x01, 0x40, 0x3C, 0x03, 0x40, 0x3C, 0x03, 0x40, 0x3C, 0x03, 0x40,
  0x3C, 0x03, 0x28, 0x12, 0x13, 0xC8, 0x53, 0x12, 0xC8, 0x1E, 0xA8, 0xA0, 0xE1, 0x8C, 0x8D, 0x14,
  0xCC, 0x41, 0xD8, 0x1D, 0xC2, 0x28, 0x93, 0x2C, 0xD1, 0x02, 0xCF, 0xCC, 0xFC, 0x24, 0x82, 0x4C,
  0xC4, 0x70, 0x0A, 0x71, 0x00, 0x27, 0x71, 0x86, 0x12, 0x01, 0x10, 0x21, 0x28, 0x66, 0x90, 0x88,
  0x09, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_settings_voice() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 17), Box(0, 0, 17, 17),
      ic_round_18_action_settings_voice_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_shop_2 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_round_18_action_shop_2_data[] PROGMEM = {
  0x71, 0x80, 0x01, 0x76, 0x07, 0xC0, 0xE0, 0x37, 0x48, 0x5C, 0xA3, 0x33, 0xD7, 0x78, 0x91, 0x25,
  0x55, 0xDB, 0x55, 0x5E, 0xA0, 0xF5, 0x40, 0x6F, 0xE0, 0x13, 0x06, 0xFE, 0x83, 0x10, 0x81, 0x6D,
  0x05, 0x0C, 0xE8, 0x31, 0x1F, 0x36, 0xD2, 0x07, 0xD8, 0x31, 0x1F, 0x36, 0xD3, 0x07, 0xC8, 0x31,
  0x1F, 0x36, 0xD2, 0x06, 0x0E, 0xC8, 0x31, 0x1F, 0x36, 0xD0, 0x40, 0xBE, 0x83, 0x11, 0xF3, 0x6F,
  0xE8, 0x31, 0x1F, 0x34, 0xFD, 0x85, 0xE0, 0x1F, 0x30, 0x58, 0x07, 0x78, 0x33, 0x01, 0xF5, 0x80,
  0x71, 0x50, 0xDF, 0xD0, 0x45, 0x80, 0x90, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_shop_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_shop_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_shopping_bag 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_round_18_action_shopping_bag_data[] PROGMEM = {
  0x48, 0x21, 0x66, 0x17, 0x03, 0x0E, 0xA0, 0xE0, 0x36, 0x84, 0xBD, 0x22, 0xDB, 0x38, 0x93, 0x27,
  0x7F, 0xB7, 0x7B, 0xF7, 0x72, 0xDF, 0xB0, 0xDB, 0x10, 0x7A, 0x07, 0x1E, 0x10, 0x8A, 0x08, 0x1E,
  0x0D, 0xC0, 0xD8, 0x09, 0x87, 0xF0, 0xDF, 0xB0, 0xD0, 0x28, 0x06, 0x70, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_shopping_bag() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_shopping_bag_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_shopping_basket 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_shopping_basket_data[] PROGMEM = {
  0x70, 0x01, 0x77, 0x00, 0xD7, 0x68, 0x28, 0xEE, 0x97, 0x48, 0x43, 0xF6, 0x6F, 0x37, 0x30, 0xC0,
  0xB2, 0x0B, 0x0C, 0x58, 0x96, 0x8B, 0xBB, 0xCF, 0xDB, 0xBD, 0xFC, 0xBB, 0xB8, 0xFF, 0xA0, 0xBF,
  0xF0, 0xB0, 0x7E, 0x00, 0x9E, 0x07, 0x02, 0xD0, 0xB2, 0x0B, 0xD8, 0x12, 0x0D, 0xC0, 0xD2, 0x0D,
  0xC0, 0xD2, 0x08, 0xD0, 0x0E, 0xD0, 0x82, 0x03, 0xFD, 0x03, 0x30, 0xEF, 0xB0, 0xE4, 0x01, 0x80,
  0x63, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_shopping_basket() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_shopping_basket_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_shopping_cart_checkout 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_action_shopping_cart_checkout_data[] PROGMEM = {
  0x02, 0x03, 0x75, 0xA0, 0xA4, 0x07, 0x09, 0x58, 0x21, 0x6F, 0x22, 0x82, 0x15, 0xFA, 0x30, 0x12,
  0x82, 0xD8, 0x09, 0xC8, 0x13, 0x04, 0x92, 0x07, 0x0E, 0x28, 0x21, 0x5F, 0xA2, 0x00, 0xB2, 0x81,
  0x1F, 0x62, 0x07, 0x09, 0x28, 0x12, 0xF4, 0x30, 0x90, 0xC6, 0x09, 0x0D, 0x48, 0x13, 0xF9, 0x80,
  0x17, 0x0E, 0x06, 0x40, 0x59, 0x80, 0x2D, 0x0A, 0x50, 0xE0, 0x97, 0x48, 0x11, 0xFC, 0x80, 0x4B,
  0x02, 0x30, 0x58, 0x05, 0x90, 0x13, 0x00, 0x56, 0x00, 0x53, 0x04, 0xA0, 0x34, 0x03, 0xA0, 0x42,
  0x82, 0x2F, 0xE1, 0x48, 0x21, 0xEF, 0x23, 0x00, 0x16, 0x00, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_shopping_cart_checkout() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_shopping_cart_checkout_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_shopping_cart 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_shopping_cart_data[] PROGMEM = {
  0x02, 0x03, 0x76, 0xA0, 0xA7, 0x58, 0x21, 0x6F, 0x68, 0x06, 0x53, 0x0D, 0xFC, 0x02, 0x20, 0x7F,
  0xB0, 0xB3, 0x01, 0xFB, 0x04, 0x40, 0x9F, 0x90, 0xD5, 0x03, 0xF9, 0x06, 0x50, 0x59, 0x80, 0x2D,
  0x0A, 0x60, 0xE0, 0x97, 0x58, 0x11, 0xFC, 0x80, 0x4B, 0x02, 0x40, 0x58, 0x05, 0x90, 0x14, 0x00,
  0x56, 0x00, 0x54, 0x04, 0xA0, 0x34, 0x03, 0xA0, 0x43, 0x82, 0x2F, 0xE1, 0x48, 0x21, 0xEF, 0x24,
  0x00, 0x16, 0x00, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_shopping_cart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_shopping_cart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_shop 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_shop_data[] PROGMEM = {
  0x68, 0x22, 0x33, 0x27, 0x40, 0x7C, 0x07, 0x73, 0x84, 0xAA, 0x11, 0xAA, 0x58, 0x97, 0x17, 0x77,
  0x7D, 0xC7, 0x7C, 0xD7, 0x77, 0x71, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3D, 0x05, 0x08, 0xF0, 0x03,
  0xD8, 0x23, 0x03, 0xCD, 0x00, 0x3D, 0x03, 0x30, 0x8C, 0x00, 0x3D, 0x03, 0x20, 0x10, 0xBC, 0x00,
  0x3D, 0x82, 0x30, 0x6E, 0xD0, 0x03, 0xD0, 0x80, 0xBF, 0x00, 0x3F, 0xF8, 0x13, 0x1E, 0xFD, 0x82,
  0xE1, 0x01, 0x80, 0x90, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_shop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_shop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_shop_two 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_action_shop_two_data[] PROGMEM = {
  0x71, 0x83, 0x13, 0x33, 0x17, 0x50, 0x3D, 0x03, 0x74, 0x85, 0x7F, 0x33, 0x3F, 0x77, 0x28, 0x91,
  0x33, 0x9F, 0x33, 0x3F, 0x93, 0x35, 0x01, 0x0E, 0xFC, 0x0E, 0x01, 0x30, 0x3F, 0xE8, 0x33, 0x02,
  0x03, 0xD0, 0x50, 0xCE, 0x83, 0x33, 0xF3, 0x3D, 0x20, 0x50, 0xDC, 0x83, 0x33, 0xF3, 0x3D, 0x30,
  0x6C, 0x83, 0x33, 0xF3, 0x3D, 0x20, 0x8D, 0x83, 0x33, 0xF3, 0x3D, 0x03, 0x0C, 0xE8, 0x33, 0x3F,
  0x33, 0xFE, 0x83, 0x33, 0xF3, 0x1F, 0xE8, 0x41, 0x3F, 0x30, 0x38, 0x07, 0x78, 0x33, 0x03, 0xF6,
  0x77, 0x10, 0x1F, 0xE0, 0x14, 0x03, 0x80, 0x77, 0x03, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_shop_two() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_shop_two_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_smart_button 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_action_smart_button_data[] PROGMEM = {
  0x10, 0x98, 0x09, 0x0B, 0x81, 0x90, 0x69, 0x80, 0x90, 0xB9, 0x06, 0x07, 0x97, 0x59, 0x00, 0x79,
  0x71, 0x85, 0x1B, 0x50, 0xF7, 0x79, 0x78, 0x62, 0x2B, 0x50, 0xF7, 0x79, 0x70, 0xC0, 0x83, 0x98,
  0x90, 0x76, 0xFB, 0xBB, 0xB5, 0x1E, 0xA8, 0xA2, 0xB0, 0x8F, 0x60, 0x9B, 0xBB, 0xB5, 0x02, 0xDB,
  0x10, 0x89, 0x73, 0x05, 0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_smart_button() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_smart_button_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_source 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_action_source_data[] PROGMEM = {
  0x02, 0x0D, 0xC0, 0xC0, 0x17, 0x10, 0x7E, 0x0D, 0x80, 0x27, 0x81, 0x50, 0x7F, 0xF0, 0x50, 0x7F,
  0xF0, 0x07, 0xA0, 0xB8, 0x04, 0x70, 0xBA, 0x00, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x07, 0xFF, 0x00,
  0x7A, 0x0B, 0x80, 0x17, 0x0B, 0xD0, 0x07, 0xA0, 0x75, 0x07, 0xD0, 0x07, 0xFF, 0x00, 0x7F, 0xF8,
  0x17, 0x2D, 0xFD, 0x0D, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_source() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_source_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_space_dashboard 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_space_dashboard_data[] PROGMEM = {
  0x18, 0x32, 0x33, 0x32, 0x28, 0x52, 0x33, 0x32, 0x02, 0xD0, 0x02, 0xD0, 0x20, 0x4D, 0x00, 0x5D,
  0x00, 0x4D, 0x00, 0x5D, 0x00, 0x4D, 0x05, 0x04, 0xD0, 0x30, 0x4D, 0x87, 0x50, 0x79, 0x99, 0x70,
  0x4D, 0x05, 0x70, 0x4D, 0x81, 0x51, 0xCB, 0x81, 0xC1, 0x4D, 0x05, 0x04, 0xD0, 0x04, 0xD0, 0x05,
  0xD0, 0x04, 0xD0, 0x05, 0xD0, 0x04, 0xD0, 0x05, 0xD0, 0x40, 0x2D, 0x00, 0x2D, 0x85, 0x20, 0x23,
  0x33, 0x22, 0x83, 0x23, 0x33, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_space_dashboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_space_dashboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_spatial_audio_off 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_round_18_action_spatial_audio_off_data[] PROGMEM = {
  0x76, 0x00, 0x67, 0x71, 0x81, 0x6F, 0x27, 0x58, 0x36, 0x80, 0xD9, 0x68, 0x15, 0x62, 0x38, 0x35,
  0xF1, 0x8E, 0x50, 0xCA, 0x0E, 0x03, 0x39, 0x05, 0x04, 0x94, 0x05, 0xC0, 0xB3, 0x98, 0x24, 0x5F,
  0x13, 0x06, 0xC0, 0xC2, 0x83, 0x5F, 0x17, 0xE4, 0x02, 0x0E, 0xB0, 0x72, 0x83, 0x68, 0x0C, 0x95,
  0x82, 0x3B, 0xC7, 0x58, 0x16, 0xF2, 0x68, 0x11, 0x21, 0x50, 0x06, 0x40, 0x50, 0xBC, 0x81, 0xD8,
  0x17, 0x0B, 0xF9, 0x0E, 0x03, 0x50, 0x2F, 0xB0, 0x85, 0x01, 0x0E, 0xFA, 0x06, 0x60, 0x18, 0x05,
  0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_spatial_audio_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_action_spatial_audio_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_spatial_audio 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_spatial_audio_data[] PROGMEM = {
  0x72, 0x82, 0xE3, 0x3E, 0x75, 0x83, 0xD7, 0x1F, 0x67, 0x48, 0x49, 0xD0, 0x7F, 0x66, 0x89, 0x15,
  0x62, 0x02, 0xF7, 0x07, 0xFE, 0x40, 0xCA, 0x87, 0xE3, 0x06, 0xF8, 0x01, 0x33, 0x05, 0xC0, 0xB2,
  0x83, 0x6E, 0xD8, 0x33, 0x06, 0xC0, 0xC3, 0x82, 0x18, 0xDE, 0x30, 0x20, 0xEB, 0x07, 0x74, 0x82,
  0x3B, 0xC7, 0x76, 0x81, 0x12, 0x17, 0x30, 0x50, 0xBC, 0x81, 0xD8, 0x16, 0x0B, 0xF9, 0x0E, 0x03,
  0x40, 0x2F, 0xB0, 0x84, 0x03, 0xFB, 0x09, 0x58, 0x06, 0x30, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_spatial_audio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_spatial_audio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_spatial_tracking 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_action_spatial_tracking_data[] PROGMEM = {
  0x75, 0x08, 0x04, 0x76, 0x81, 0x5F, 0x37, 0x68, 0x3C, 0x90, 0xA4, 0x58, 0x15, 0x62, 0x28, 0x41,
  0xF4, 0x4F, 0x24, 0x0C, 0xA8, 0x6E, 0x30, 0x4F, 0x27, 0xC4, 0x05, 0xC8, 0x5B, 0x03, 0xF1, 0x7C,
  0x40, 0x6C, 0x86, 0xC0, 0x1F, 0x54, 0xF2, 0x30, 0x20, 0xEB, 0x07, 0x28, 0x3C, 0xA0, 0xA4, 0x48,
  0x23, 0xBC, 0x73, 0x81, 0x5F, 0x37, 0x81, 0x12, 0x14, 0x08, 0x04, 0x40, 0x50, 0xBC, 0x81, 0xD8,
  0x16, 0x0B, 0xF9, 0x0E, 0x03, 0x40, 0x2F, 0xB0, 0x84, 0x03, 0xFB, 0x09, 0x58, 0x06, 0x30, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_spatial_tracking() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_spatial_tracking_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_speaker_notes_off 18x18, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_round_18_action_speaker_notes_off_data[] PROGMEM = {
  0x38, 0x07, 0x32, 0x82, 0x56, 0x09, 0xFB, 0x85, 0xE0, 0x6F, 0x70, 0x9F, 0xB0, 0x03, 0xA8, 0x27,
  0x09, 0xB8, 0x01, 0x70, 0xDA, 0x00, 0x3B, 0x07, 0x18, 0x01, 0x10, 0x20, 0xAA, 0x00, 0x3C, 0x81,
  0x70, 0x9F, 0x00, 0x3A, 0x82, 0x97, 0xF7, 0x50, 0x9A, 0x00, 0x3A, 0x0E, 0x0D, 0xA8, 0x47, 0x03,
  0x99, 0xEA, 0x00, 0x3A, 0x86, 0xDA, 0xFB, 0xF7, 0x09, 0xC0, 0x03, 0xA8, 0x7B, 0x7F, 0x7A, 0xF7,
  0x09, 0xB0, 0x03, 0xFA, 0x81, 0x70, 0x9A, 0x00, 0x3F, 0xB8, 0x47, 0x09, 0xF1, 0x3A, 0x09, 0x80,
  0x27, 0x87, 0x9F, 0x70, 0x20, 0x3F, 0x77, 0x18, 0x16, 0xF7, 0x20, 0x10, 0x57, 0x38, 0x16, 0xF6,
  0x77, 0x00, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_speaker_notes_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_speaker_notes_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_speaker_notes 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_speaker_notes_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3A, 0x82, 0xDA, 0xFB, 0x80, 0x17,
  0x0D, 0xA0, 0x03, 0xA8, 0x90, 0xA6, 0xF7, 0x11, 0x11, 0x2A, 0xA0, 0x03, 0xFF, 0x00, 0x3A, 0x82,
  0x94, 0xF5, 0x50, 0x9A, 0x00, 0x3A, 0x82, 0xED, 0xFD, 0x80, 0x19, 0x0E, 0xA0, 0x03, 0xA8, 0x6D,
  0xAF, 0xA7, 0x77, 0xBC, 0x00, 0x3A, 0x86, 0xB7, 0xF7, 0x33, 0x39, 0xC0, 0x03, 0xFF, 0x00, 0x3F,
  0xF0, 0x10, 0x3A, 0x09, 0x80, 0x67, 0x83, 0x40, 0x3F, 0x77, 0x60, 0x10, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_speaker_notes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_speaker_notes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_spellcheck 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_spellcheck_data[] PROGMEM = {
  0x30, 0x20, 0x17, 0x28, 0x13, 0xFE, 0x72, 0x82, 0x9D, 0xF5, 0x71, 0x82, 0xE7, 0xAB, 0x78, 0x45,
  0xF1, 0x5F, 0x16, 0x00, 0xB2, 0x0E, 0x07, 0x58, 0x51, 0xFE, 0xDD, 0xFD, 0x58, 0x67, 0xF5, 0x55,
  0x7F, 0x34, 0x0C, 0x0A, 0x40, 0xD0, 0x92, 0x82, 0x16, 0x83, 0x48, 0x45, 0x60, 0x1D, 0xC4, 0x00,
  0x52, 0x82, 0x1D, 0xC1, 0x48, 0x56, 0xF6, 0x1D, 0xC1, 0x68, 0x37, 0xFE, 0xC1, 0x71, 0x81, 0x6A,
  0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_spellcheck() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_spellcheck_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_star_rate 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_action_star_rate_data[] PROGMEM = {
  0x40, 0x01, 0x71, 0x09, 0x0A, 0x71, 0x00, 0xE7, 0x04, 0xA0, 0x43, 0x0C, 0xF9, 0x81, 0xC1, 0xBE,
  0x0B, 0x01, 0x20, 0x9C, 0x09, 0x40, 0x8C, 0x08, 0x48, 0x4D, 0xFA, 0xAF, 0xD3, 0x81, 0x2E, 0x62,
  0x81, 0x6E, 0x23, 0x01, 0x40, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_star_rate() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 13), Box(0, 0, 17, 17),
      ic_round_18_action_star_rate_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_stars 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_stars_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x08, 0x50, 0x9F, 0xB0, 0x83, 0x03,
  0xD0, 0x09, 0xD0, 0x32, 0x0B, 0xD0, 0x04, 0xD0, 0xB2, 0xB8, 0x1D, 0x99, 0x28, 0x19, 0x9D, 0xB1,
  0x02, 0xB0, 0xB6, 0x0B, 0xB0, 0x02, 0xC0, 0xD0, 0x12, 0x01, 0x0D, 0xC0, 0x21, 0xC0, 0xE4, 0xD2,
  0x0B, 0xB8, 0x4B, 0x0A, 0xA0, 0xBB, 0x0B, 0x20, 0x3B, 0x0E, 0x0D, 0xA0, 0xD0, 0xEB, 0x03, 0x30,
  0x9F, 0xB0, 0x85, 0x09, 0xF9, 0x08, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_stars() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_stars_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_sticky_note_2 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_sticky_note_2_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD0, 0xA0, 0xBF, 0xD0, 0x0B, 0xFD, 0x00, 0xBA, 0x06,
  0x60, 0x6A, 0x00, 0xBA, 0x0C, 0x80, 0x27, 0x0C, 0xA0, 0x0B, 0xFD, 0x00, 0xBA, 0x06, 0x20, 0x2E,
  0x00, 0xBA, 0x89, 0x2C, 0x77, 0xAF, 0xD7, 0x77, 0xCB, 0xBF, 0x07, 0x28, 0x25, 0xF7, 0xBF, 0x85,
  0x70, 0x5F, 0x70, 0xBF, 0x82, 0x75, 0xF7, 0x20, 0xAF, 0x81, 0xCF, 0x73, 0x02, 0x0A, 0x80, 0x3B,
  0x07, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_sticky_note_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_sticky_note_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_store 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_action_store_data[] PROGMEM = {
  0x10, 0x38, 0x06, 0xD0, 0x32, 0x01, 0x80, 0x67, 0x01, 0x20, 0x28, 0x06, 0x90, 0x22, 0x0A, 0xFB,
  0x0A, 0x20, 0xEF, 0xB8, 0x1E, 0x02, 0xFD, 0x02, 0x05, 0xFD, 0x89, 0x45, 0x08, 0xF5, 0x55, 0xAE,
  0x55, 0x5F, 0x82, 0x06, 0x0E, 0x30, 0x60, 0xD3, 0x0E, 0x06, 0x20, 0x60, 0xE3, 0x06, 0x0D, 0x30,
  0xE0, 0x62, 0x05, 0xD0, 0xD3, 0x0E, 0x05, 0x38, 0x01, 0x50, 0x23, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_subject 18x18, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_round_18_action_subject_data[] PROGMEM = {
  0x01, 0x80, 0x67, 0x01, 0x03, 0x80, 0x6D, 0x03, 0x75, 0x03, 0x80, 0x6B, 0x03, 0x01, 0x80, 0x67,
  0x01, 0x18, 0x06, 0x11, 0x04, 0xFB, 0x04, 0x18, 0x06, 0x32, 0x80, 0x15, 0x03, 0x50, 0x3D, 0x0B,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_subject() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 13), Box(0, 0, 17, 17),
      ic_round_18_action_subject_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_subtitles_off 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_subtitles_off_data[] PROGMEM = {
  0x0B, 0x05, 0x18, 0x05, 0x58, 0x44, 0x04, 0xF5, 0x6F, 0xA0, 0x30, 0x4A, 0x05, 0x06, 0xF9, 0x00,
  0x4B, 0x05, 0x06, 0xF0, 0x04, 0xC0, 0x50, 0x6E, 0x00, 0x4D, 0x05, 0x06, 0xD0, 0x04, 0xE0, 0x50,
  0x6C, 0x8B, 0x54, 0x4E, 0xBB, 0xFD, 0xBD, 0x56, 0xBB, 0xE4, 0x4C, 0x34, 0xD7, 0x35, 0xE5, 0x03,
  0xC4, 0x4D, 0x80, 0x29, 0x86, 0xBF, 0x56, 0xF4, 0x3D, 0x80, 0x27, 0x0A, 0xA8, 0x35, 0x63, 0x04,
  0x80, 0x55, 0x0D, 0x05, 0x75, 0x01, 0x0B, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_subtitles_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_subtitles_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_supervised_user_circle 18x18, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_18_action_supervised_user_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9A, 0x00, 0xCE, 0x09,
  0x30, 0x3A, 0x04, 0x20, 0x5E, 0x03, 0x28, 0x1B, 0xFA, 0x48, 0x2A, 0xFD, 0xCA, 0x0B, 0x2A, 0x08,
  0x40, 0x90, 0xB2, 0x07, 0xA1, 0x02, 0xA0, 0xD3, 0x81, 0x1E, 0x62, 0x01, 0xA0, 0x02, 0xB8, 0x4C,
  0x66, 0xDF, 0xA2, 0x06, 0xA0, 0x21, 0xB8, 0x2E, 0xDD, 0xEA, 0x0C, 0x0B, 0xB2, 0x81, 0xBE, 0x33,
  0x86, 0x3E, 0xFC, 0xBE, 0xFB, 0x28, 0x13, 0xF5, 0x28, 0x22, 0xEB, 0x12, 0x81, 0x6F, 0x33, 0x84,
  0x9F, 0x50, 0xBC, 0x38, 0x16, 0xF9, 0x58, 0x90, 0x9F, 0xBF, 0x72, 0x5C, 0xF9, 0x70, 0x30, 0xBC,
  0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_supervised_user_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_supervised_user_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_supervisor_account 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_supervisor_account_data[] PROGMEM = {
  0x58, 0x14, 0x51, 0x75, 0x0B, 0xA0, 0xE0, 0x37, 0x30, 0x5C, 0x0B, 0x73, 0x06, 0xC0, 0xD7, 0x30,
  0x2C, 0x84, 0x80, 0x1A, 0xA2, 0x68, 0x25, 0xDE, 0x92, 0x09, 0xA0, 0xB7, 0x10, 0x13, 0x09, 0xA0,
  0xB4, 0x81, 0x4A, 0xEA, 0x85, 0xEB, 0x51, 0xAA, 0x23, 0x0A, 0xE0, 0x92, 0x00, 0x33, 0x02, 0xE8,
  0x2C, 0x06, 0xEA, 0x82, 0xE7, 0x03, 0xE0, 0x80, 0x1E, 0x02, 0x18, 0x02, 0x50, 0x31, 0x80, 0x25,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_supervisor_account() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_supervisor_account_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_support 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_round_18_action_support_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x58, 0x25, 0xD3, 0xBA, 0x82, 0xB3, 0xD5,
  0x38, 0x33, 0xD1, 0x04, 0xA8, 0x34, 0x01, 0xD3, 0x20, 0xB0, 0x32, 0x02, 0xA0, 0x32, 0x8A, 0x03,
  0xB0, 0x1F, 0xB4, 0x3D, 0x55, 0xD3, 0x4B, 0xF1, 0x3C, 0x05, 0x20, 0x5C, 0x00, 0x3C, 0x05, 0x20,
  0x5C, 0x8A, 0x03, 0x1F, 0xB4, 0x3D, 0x55, 0xD2, 0x4B, 0xF1, 0x0B, 0x32, 0x03, 0xA0, 0x32, 0x04,
  0x0B, 0x28, 0x33, 0xD1, 0x04, 0xA8, 0x34, 0x01, 0xD3, 0x38, 0x25, 0xD3, 0xBA, 0x82, 0xB3, 0xD5,
  0x50, 0x30, 0xBC, 0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_support() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_support_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swap_horizontal_circle 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_round_18_action_swap_horizontal_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9F, 0xB0, 0x93, 0x03,
  0xFD, 0x03, 0x20, 0xBF, 0x90, 0x50, 0xAA, 0x0B, 0x2E, 0x03, 0x40, 0xCA, 0x10, 0x2C, 0x85, 0xDF,
  0xC9, 0x92, 0x5B, 0x00, 0x2B, 0x85, 0x52, 0x99, 0xCF, 0xDC, 0x02, 0x1A, 0x0C, 0x40, 0x3E, 0x20,
  0xBA, 0x0A, 0x05, 0xF9, 0x0B, 0x20, 0x3F, 0xD0, 0x33, 0x09, 0xFB, 0x09, 0x50, 0x9F, 0x90, 0x97,
  0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swap_horizontal_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_swap_horizontal_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swap_horiz 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_action_swap_horiz_data[] PROGMEM = {
  0x74, 0x00, 0x17, 0x58, 0x17, 0xD1, 0x68, 0x6A, 0xDD, 0xDD, 0xEF, 0xC6, 0x86, 0x35, 0x55, 0x5A,
  0xF6, 0x74, 0x05, 0x06, 0x20, 0x60, 0x57, 0x48, 0x66, 0xFA, 0x55, 0x55, 0x36, 0x86, 0xCF, 0xED,
  0xDD, 0xDA, 0x68, 0x11, 0xD7, 0x75, 0x00, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swap_horiz() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_swap_horiz_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swap_vertical_circle 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_swap_vertical_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9B, 0x0C, 0xE0, 0x93,
  0x03, 0xB8, 0x1A, 0x05, 0xE0, 0x32, 0x0B, 0xB8, 0x25, 0x02, 0xDD, 0x0B, 0x2D, 0x10, 0xAF, 0x10,
  0x2D, 0x18, 0x1A, 0xC3, 0xD0, 0x02, 0xD8, 0x13, 0xCA, 0x1D, 0x02, 0x1F, 0x0A, 0x1D, 0x20, 0xBD,
  0x82, 0xD2, 0x05, 0xB0, 0xB2, 0x03, 0xE8, 0x15, 0x0A, 0xB0, 0x33, 0x09, 0xE0, 0xCB, 0x09, 0x50,
  0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swap_vertical_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_swap_vertical_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swap_vert 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_action_swap_vert_data[] PROGMEM = {
  0x18, 0x11, 0xC6, 0x60, 0x10, 0xDA, 0x06, 0x58, 0x31, 0x7E, 0xB5, 0x70, 0xE0, 0x67, 0x10, 0xE0,
  0x67, 0x10, 0xE0, 0x67, 0x10, 0xE0, 0x62, 0x04, 0x0A, 0x40, 0xA0, 0x42, 0x06, 0x0E, 0x71, 0x06,
  0x0E, 0x71, 0x06, 0x0E, 0x71, 0x06, 0x0E, 0x78, 0x35, 0xBE, 0x71, 0x50, 0x6A, 0x0D, 0x01, 0x68,
  0x16, 0xC1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swap_vert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_action_swap_vert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_down_alt 18x18, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_round_18_action_swipe_down_alt_data[] PROGMEM = {
  0x28, 0x21, 0x44, 0x13, 0x05, 0x0E, 0xA8, 0x3E, 0x50, 0x2E, 0xC8, 0x1E, 0x27, 0xE0, 0x70, 0x8E,
  0x08, 0x04, 0xE8, 0x14, 0x0A, 0xC0, 0xA3, 0x82, 0x6D, 0xD6, 0x50, 0x0A, 0x58, 0x21, 0xAA, 0x13,
  0x84, 0x4E, 0xDD, 0xE4, 0x30, 0xAA, 0x0A, 0x50, 0x90, 0x83,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_down_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 12, 15), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_down_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_down 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_round_18_action_swipe_down_data[] PROGMEM = {
  0x30, 0xB0, 0x27, 0x70, 0x50, 0xA7, 0x71, 0x0C, 0x02, 0x28, 0x15, 0xD5, 0x72, 0x01, 0x0C, 0x38,
  0x17, 0xFD, 0x72, 0x03, 0x0A, 0x30, 0x2A, 0x05, 0x71, 0x04, 0x09, 0x48, 0x1A, 0xFC, 0x78, 0x38,
  0x4B, 0x27, 0x20, 0x3A, 0x09, 0x0E, 0xA8, 0x6D, 0x60, 0x5D, 0xED, 0x33, 0x0C, 0xE0, 0xE2, 0x81,
  0x5E, 0x34, 0x05, 0xF0, 0x37, 0x20, 0xDE, 0x07, 0x71, 0x01, 0x09, 0xE0, 0xA6, 0x04, 0xFA, 0x06,
  0x60, 0x10, 0xAD, 0x81, 0xE8, 0x27, 0x28, 0x31, 0x7C, 0xD6, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_left_alt 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_action_swipe_left_alt_data[] PROGMEM = {
  0x78, 0x24, 0x87, 0x24, 0x04, 0x30, 0xAB, 0x0E, 0x05, 0x28, 0x3A, 0xE1, 0x06, 0xD8, 0x6E, 0x19,
  0xFC, 0x99, 0xDE, 0x85, 0x48, 0xFC, 0x99, 0xDE, 0x85, 0x40, 0xAE, 0x10, 0x6D, 0x0E, 0x01, 0x20,
  0x43, 0x0A, 0xB0, 0xE0, 0x57, 0x18, 0x24, 0x87, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_left_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 14, 12), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_left_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_left 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_swipe_left_data[] PROGMEM = {
  0x10, 0x12, 0x86, 0x5A, 0xED, 0xDD, 0xA4, 0x38, 0x42, 0xA2, 0xCA, 0x34, 0x87, 0x4A, 0xB1, 0x03,
  0xCD, 0x47, 0x18, 0x65, 0xD1, 0x3F, 0xB7, 0x22, 0x06, 0x03, 0x48, 0x91, 0x5B, 0x05, 0x55, 0x10,
  0x4F, 0xD5, 0x03, 0x68, 0x15, 0xFD, 0x75, 0x81, 0x5F, 0xD7, 0x58, 0x15, 0xFD, 0x75, 0x82, 0x5F,
  0xE1, 0x74, 0x05, 0xB8, 0x1E, 0x81, 0x71, 0x05, 0xD0, 0xE0, 0x55, 0x81, 0x10, 0x5E, 0x0C, 0x48,
  0x2A, 0xFD, 0xBE, 0x0A, 0x40, 0x10, 0xDF, 0x90, 0x85, 0x01, 0x0D, 0xF0, 0x56, 0x01, 0x0C, 0xD0,
  0xD0, 0x17, 0x18, 0x01, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 17), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_action_swipe_data[] PROGMEM = {
  0x48, 0x15, 0xBE, 0xA8, 0x1E, 0xB5, 0x48, 0x97, 0x37, 0x2C, 0xFD, 0x97, 0x79, 0xDF, 0xC2, 0x73,
  0x3A, 0x0E, 0x05, 0x60, 0x50, 0xEA, 0x00, 0x3A, 0x08, 0x20, 0x20, 0x64, 0x08, 0xA8, 0x90, 0x31,
  0x55, 0x51, 0x0B, 0xF6, 0x28, 0x31, 0x55, 0x51, 0x68, 0x1C, 0xF6, 0x76, 0x81, 0xCF, 0x67, 0x68,
  0x1C, 0xF6, 0x76, 0x82, 0xCF, 0x81, 0x75, 0x0C, 0xB0, 0xC0, 0x47, 0x30, 0xCD, 0x0C, 0x01, 0x58,
  0x22, 0x10, 0xCE, 0x05, 0x58, 0x2E, 0xFB, 0xDE, 0x03, 0x50, 0x6F, 0xA0, 0x16, 0x06, 0xF0, 0xE7,
  0x10, 0x6E, 0x08, 0x73, 0x80, 0x11, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_right_alt 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_action_swipe_right_alt_data[] PROGMEM = {
  0x28, 0x22, 0x78, 0x47, 0x10, 0x50, 0xEB, 0x0A, 0x30, 0x42, 0x01, 0x0E, 0xD8, 0x56, 0x01, 0xEA,
  0x04, 0xE8, 0x5D, 0x99, 0xCF, 0x84, 0xE8, 0x6D, 0x99, 0xCF, 0x91, 0xED, 0x83, 0x60, 0x1E, 0xA2,
  0x05, 0x0E, 0xB0, 0xA3, 0x04, 0x48, 0x22, 0x78, 0x47,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_right_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_right_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_right 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_swipe_right_data[] PROGMEM = {
  0x38, 0x64, 0xAD, 0xDD, 0xEA, 0x52, 0x01, 0x28, 0x21, 0xBA, 0x44, 0x87, 0x3A, 0xC2, 0xA2, 0x1D,
  0x57, 0x18, 0x44, 0xDC, 0x3B, 0x54, 0x06, 0x03, 0x28, 0x42, 0x7B, 0xF3, 0x34, 0x81, 0x4F, 0xD2,
  0x01, 0x0F, 0x56, 0x81, 0x5F, 0xD7, 0x58, 0x15, 0xFD, 0x75, 0x81, 0x5F, 0xD7, 0x58, 0x25, 0xFE,
  0x17, 0x40, 0x5B, 0x81, 0xE8, 0x17, 0x10, 0x5D, 0x0E, 0x05, 0x58, 0x11, 0x05, 0xE0, 0xC4, 0x82,
  0xAF, 0xDB, 0xE0, 0xA4, 0x01, 0x0D, 0xF9, 0x08, 0x50, 0x10, 0xDF, 0x05, 0x60, 0x10, 0xCD, 0x0D,
  0x01, 0x71, 0x80, 0x11, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 17), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_up_alt 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_action_swipe_up_alt_data[] PROGMEM = {
  0x28, 0x22, 0xDE, 0x23, 0x01, 0x0E, 0xA0, 0xE0, 0x12, 0x84, 0x3A, 0xBB, 0xA3, 0x40, 0x0A, 0x60,
  0x0A, 0x40, 0x20, 0xCA, 0x83, 0xC2, 0x01, 0xEC, 0x81, 0xE1, 0x6E, 0x06, 0x08, 0xE0, 0x80, 0x5E,
  0x81, 0x50, 0xCC, 0x0C, 0x28, 0x41, 0x9E, 0xE9, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_up_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 12, 13), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_up_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_up 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_swipe_up_data[] PROGMEM = {
  0x18, 0x13, 0xC2, 0x76, 0x83, 0x3D, 0xFD, 0x27, 0x58, 0x3A, 0x5B, 0x49, 0x76, 0x04, 0x09, 0x38,
  0x15, 0xD5, 0x72, 0x03, 0x0A, 0x38, 0x17, 0xFD, 0x72, 0x02, 0x0C, 0x30, 0x2A, 0x05, 0x72, 0x0D,
  0x01, 0x38, 0x1A, 0xFC, 0x72, 0x07, 0x08, 0x30, 0x3A, 0x09, 0x0E, 0xA0, 0xD0, 0x64, 0x0C, 0x01,
  0x30, 0xCE, 0x0E, 0x72, 0x05, 0xF0, 0x37, 0x20, 0xDE, 0x07, 0x71, 0x01, 0x09, 0xE0, 0xA6, 0x04,
  0xFA, 0x06, 0x60, 0x10, 0xAD, 0x81, 0xE8, 0x27, 0x28, 0x31, 0x7C, 0xD6, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_swipe_vertical 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_round_18_action_swipe_vertical_data[] PROGMEM = {
  0x10, 0xF3, 0x77, 0x18, 0x2A, 0xCF, 0x77, 0x78, 0x21, 0xCB, 0x77, 0x78, 0x2A, 0x66, 0x72, 0x81,
  0x5D, 0x57, 0x18, 0x33, 0xB0, 0x12, 0x28, 0x17, 0xFD, 0x71, 0x09, 0x05, 0x50, 0x2A, 0x05, 0x70,
  0xC0, 0x16, 0x81, 0xAF, 0xC7, 0x0D, 0x70, 0x3A, 0x09, 0x0E, 0xA8, 0x2D, 0x60, 0xD7, 0x10, 0xCE,
  0x82, 0xE0, 0xC1, 0x70, 0x5F, 0x81, 0x39, 0x57, 0x10, 0xDE, 0x84, 0x73, 0xB0, 0x12, 0x40, 0x10,
  0x9E, 0x84, 0xA0, 0xA6, 0x67, 0x20, 0x4F, 0xA8, 0x46, 0x01, 0xCB, 0x72, 0x01, 0x0A, 0xD8, 0x1E,
  0x82, 0x28, 0x2A, 0xCF, 0x74, 0x83, 0x17, 0xCD, 0x65, 0x0F, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_swipe_vertical() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_swipe_vertical_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_switch_access_shortcut_add 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_switch_access_shortcut_add_data[] PROGMEM = {
  0x70, 0xF3, 0x02, 0x73, 0x02, 0xB0, 0xE7, 0x01, 0x30, 0x5A, 0x0E, 0x60, 0x10, 0xA3, 0x82, 0x8E,
  0xFE, 0x58, 0x90, 0x5C, 0xF9, 0x12, 0xF6, 0x4E, 0x58, 0x51, 0x9E, 0x50, 0x8D, 0x73, 0x07, 0x20,
  0xC0, 0x87, 0x02, 0x03, 0x40, 0xE0, 0x67, 0x81, 0xBC, 0x13, 0x0E, 0x06, 0x48, 0x38, 0x80, 0x12,
  0x40, 0xC0, 0x83, 0x82, 0x8D, 0xD7, 0x20, 0x10, 0x82, 0x08, 0x0D, 0x38, 0x93, 0x9E, 0xE8, 0x02,
  0xAF, 0x60, 0x1F, 0x73, 0x09, 0x08, 0x28, 0x73, 0xBF, 0x81, 0x07, 0xF4, 0x70, 0x10, 0x94, 0x81,
  0x9F, 0x77, 0x60, 0x60, 0x94,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_switch_access_shortcut_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 17, 15), Box(0, 0, 17, 17),
      ic_round_18_action_switch_access_shortcut_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_switch_access_shortcut 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_switch_access_shortcut_data[] PROGMEM = {
  0x70, 0xF3, 0x02, 0x60, 0x2B, 0x0E, 0x30, 0x13, 0x05, 0xA0, 0xE2, 0x01, 0x0A, 0x38, 0xA5, 0x8E,
  0xFE, 0x05, 0xCF, 0x91, 0x2F, 0x64, 0xE0, 0x19, 0xE5, 0x08, 0xD6, 0x07, 0x20, 0xC0, 0x83, 0x02,
  0x03, 0x40, 0xE0, 0x63, 0x81, 0xBC, 0x13, 0x0E, 0x06, 0x30, 0x10, 0x24, 0x0C, 0x08, 0x50, 0x10,
  0x82, 0x08, 0x0D, 0x48, 0x62, 0xAF, 0x60, 0x1F, 0x73, 0x87, 0x3B, 0xF8, 0x10, 0x7F, 0x43, 0x01,
  0x09, 0x48, 0x19, 0xF7, 0x72, 0x06, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_switch_access_shortcut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 13, 15), Box(0, 0, 17, 17),
      ic_round_18_action_switch_access_shortcut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_sync_alt 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_round_18_action_sync_alt_data[] PROGMEM = {
  0x74, 0x00, 0x52, 0x80, 0x65, 0x83, 0xAF, 0x62, 0xEF, 0xC0, 0xD7, 0x48, 0x17, 0xD1, 0x74, 0x02,
  0x01, 0x20, 0x10, 0x27, 0x48, 0x11, 0xD7, 0x74, 0x0D, 0xFC, 0x83, 0xE2, 0x6F, 0xA8, 0x06, 0x52,
  0x00, 0x57, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_sync_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_sync_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_system_update_alt 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_system_update_alt_data[] PROGMEM = {
  0x18, 0x96, 0x35, 0x55, 0x50, 0x22, 0x05, 0x55, 0x53, 0x01, 0xC8, 0x4E, 0x1A, 0xA1, 0xEC, 0x82,
  0x13, 0xF2, 0x40, 0x0A, 0x48, 0x42, 0xF3, 0x3F, 0x24, 0x00, 0xA4, 0x84, 0x2F, 0x33, 0xF2, 0x40,
  0x0A, 0x48, 0x42, 0xF3, 0x3F, 0x24, 0x00, 0xA4, 0x84, 0x2F, 0x33, 0xF2, 0x30, 0xEA, 0x0E, 0x38,
  0x42, 0xF3, 0x3F, 0x23, 0x82, 0x3E, 0xE3, 0x38, 0x42, 0xF3, 0x3F, 0x24, 0x00, 0x34, 0x84, 0x2F,
  0x33, 0xF2, 0x73, 0x82, 0x2F, 0x31, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_system_update_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_system_update_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_table_view 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_round_18_action_table_view_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x3B, 0x0A, 0x02, 0x30, 0xA0, 0xE8, 0x03, 0xB0, 0xE0, 0xA3, 0x00, 0xB7, 0x00,
  0x53, 0x83, 0xBB, 0x02, 0xA8, 0x03, 0xB8, 0x6A, 0x2B, 0xB0, 0xAF, 0xC8, 0x01, 0xB8, 0x6C, 0xFA,
  0xBB, 0x0B, 0xD7, 0x86, 0xDB, 0xBB, 0x0B, 0xFC, 0x80, 0x1B, 0x8F, 0x1C, 0xFB, 0xBB, 0x0B, 0xEB,
  0xEE, 0xBE, 0xEB, 0xEB, 0xBB, 0x0B, 0xB0, 0xBB, 0x0B, 0xB0, 0xBB, 0xAE, 0x5B, 0xEB, 0xEE, 0xBE,
  0xEB, 0xEB, 0x2A, 0x5B, 0xEB, 0xEE, 0xBE, 0xEB, 0xEB, 0x38, 0x91, 0xBB, 0x0B, 0xB0, 0xBB, 0x0B,
  0xB3, 0x89, 0x1A, 0xEB, 0xEE, 0xBE, 0xEB, 0xEA, 0x30, 0x20, 0xA8, 0x03, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_table_view() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_table_view_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_tab 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_tab_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x25, 0x01, 0xE8, 0x23, 0x3F, 0x25,
  0x01, 0xE8, 0x23, 0x3F, 0x26, 0x0E, 0xD8, 0x23, 0x3F, 0x27, 0x0F, 0x18, 0x43, 0xF3, 0x3F, 0x27,
  0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38,
  0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_tab() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_tab_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_tab_unselected 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_tab_unselected_data[] PROGMEM = {
  0x18, 0x43, 0x52, 0x05, 0x21, 0x80, 0x25, 0x81, 0x30, 0x1A, 0x82, 0x70, 0xD6, 0x1F, 0x82, 0x13,
  0xF2, 0x5F, 0x81, 0x30, 0x36, 0xF8, 0x13, 0x15, 0x60, 0xDE, 0x82, 0x33, 0xF2, 0x68, 0x02, 0x17,
  0x78, 0x41, 0xC2, 0x2A, 0x17, 0x38, 0x41, 0x81, 0x2A, 0x17, 0x40, 0x37, 0x78, 0x96, 0x2F, 0x31,
  0xF2, 0x4E, 0x15, 0xE0, 0x6D, 0x07, 0xA8, 0x96, 0x10, 0x30, 0x16, 0x02, 0x60, 0x25, 0x02, 0x53,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_tab_unselected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_tab_unselected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_task_alt 18x18, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_round_18_action_task_alt_data[] PROGMEM = {
  0x68, 0x24, 0x56, 0x47, 0x30, 0x90, 0xED, 0x08, 0x68, 0x93, 0x2D, 0xF9, 0x40, 0x13, 0x87, 0x04,
  0xB3, 0x81, 0xDD, 0x37, 0x81, 0x4E, 0xC2, 0x81, 0x9F, 0x37, 0x82, 0x4E, 0xC1, 0x20, 0xE0, 0x97,
  0x82, 0x4E, 0xC1, 0x28, 0x14, 0xF4, 0x68, 0x64, 0xEC, 0x10, 0xB3, 0x69, 0x20, 0x40, 0x22, 0x82,
  0x4E, 0xC1, 0x29, 0x06, 0x07, 0x92, 0x85, 0xCE, 0x24, 0xEC, 0x13, 0x98, 0x91, 0x74, 0xF3, 0x02,
  0xDE, 0xEC, 0x13, 0x84, 0x4F, 0x41, 0xE9, 0x28, 0x22, 0xDC, 0x14, 0x09, 0x0E, 0x28, 0x19, 0xF3,
  0x71, 0x81, 0x3F, 0x82, 0x82, 0x1D, 0xD3, 0x68, 0x23, 0xED, 0x13, 0x83, 0x2D, 0xF9, 0x32, 0x83,
  0x39, 0xFD, 0x25, 0x01, 0x09, 0xD0, 0xE0, 0x87, 0x28, 0x31, 0x47, 0x64, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_task_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_task_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_terminal 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_terminal_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3F, 0xF8, 0x23, 0x3F, 0x58, 0x06, 0x38,
  0x75, 0xF3, 0x3F, 0x20, 0x61, 0x78, 0x90, 0x2F, 0x33, 0xF2, 0x0D, 0xC1, 0x68, 0x90, 0x2F, 0x33,
  0xF2, 0x01, 0xEA, 0x68, 0xA7, 0x2F, 0x33, 0xF2, 0x09, 0xF4, 0x01, 0x33, 0x30, 0x2F, 0x33, 0xF2,
  0x0B, 0x42, 0x0D, 0xB8, 0x56, 0x2F, 0x33, 0xF2, 0x58, 0x00, 0x11, 0x82, 0x2F, 0x31, 0xFF, 0x81,
  0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_terminal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_terminal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_text_rotate_up 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_text_rotate_up_data[] PROGMEM = {
  0x73, 0x0B, 0x0C, 0x73, 0x06, 0xA0, 0x87, 0x30, 0x90, 0xB6, 0x85, 0x17, 0xCA, 0x09, 0xB4, 0x87,
  0x5A, 0xFE, 0x82, 0x09, 0xB2, 0x84, 0x8E, 0xE9, 0x9B, 0x38, 0x90, 0x9B, 0x03, 0xFB, 0x10, 0x6B,
  0x30, 0x90, 0xB2, 0x84, 0x6D, 0xFB, 0xAB, 0x30, 0x90, 0xB4, 0x87, 0x39, 0xEE, 0x93, 0x09, 0xB7,
  0x84, 0x5B, 0x90, 0x9B, 0x74, 0x09, 0x0B, 0x74, 0x00, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_text_rotate_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_text_rotate_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_text_rotate_vertical 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_text_rotate_vertical_data[] PROGMEM = {
  0x10, 0x30, 0x25, 0x06, 0x02, 0x30, 0xB0, 0x94, 0x81, 0x6F, 0xC3, 0x0B, 0x09, 0x48, 0x2C, 0x9F,
  0x22, 0x0B, 0x09, 0x38, 0x32, 0xF2, 0xB8, 0x20, 0xB0, 0x93, 0x83, 0x8C, 0x05, 0xE2, 0x0B, 0x09,
  0x38, 0x7D, 0xC9, 0xAF, 0x40, 0xB9, 0x28, 0x94, 0x4F, 0x77, 0x7C, 0xA6, 0xEE, 0x50, 0x9B, 0x38,
  0x75, 0xF2, 0xDD, 0x10, 0x53, 0x48, 0x27, 0x01, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_text_rotate_vertical() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 13), Box(0, 0, 17, 17),
      ic_round_18_action_text_rotate_vertical_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_text_rotation_angledown 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_round_18_action_text_rotation_angledown_data[] PROGMEM = {
  0x71, 0x82, 0x29, 0xC2, 0x68, 0x43, 0xAF, 0xBF, 0x44, 0x87, 0x5C, 0xFA, 0x26, 0xD0, 0x12, 0x8A,
  0x1A, 0xFA, 0xF5, 0x0D, 0x60, 0xF7, 0x02, 0x10, 0x5F, 0xAE, 0x28, 0x16, 0xF7, 0x48, 0x15, 0xF8,
  0x38, 0x16, 0xF7, 0x38, 0x15, 0xF1, 0x48, 0x16, 0xF7, 0x20, 0xB0, 0x96, 0x83, 0x6F, 0x70, 0x27,
  0x18, 0x26, 0xF7, 0x17, 0x28, 0x26, 0xFE, 0x57, 0x28, 0x1E, 0xF5, 0x72, 0x00, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_text_rotation_angledown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_text_rotation_angledown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_text_rotation_angleup 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_round_18_action_text_rotation_angleup_data[] PROGMEM = {
  0x03, 0x06, 0x74, 0x83, 0xCF, 0xE8, 0x17, 0x18, 0x58, 0xB4, 0xCF, 0x92, 0x68, 0x31, 0xF3, 0x09,
  0xA8, 0xA6, 0xB1, 0x17, 0x71, 0x0A, 0xA6, 0xE4, 0x39, 0x11, 0xEF, 0x40, 0x3F, 0xE4, 0x48, 0x29,
  0xFD, 0x42, 0x0B, 0x0A, 0x48, 0x19, 0xF4, 0x48, 0x14, 0xF2, 0x28, 0x19, 0xF4, 0x68, 0x48, 0x20,
  0x9F, 0x47, 0x28, 0x19, 0xF4, 0x72, 0x81, 0x9F, 0x47, 0x28, 0x11, 0xE4, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_text_rotation_angleup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_text_rotation_angleup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_text_rotation_down 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_text_rotation_down_data[] PROGMEM = {
  0x10, 0x02, 0x74, 0x0B, 0x09, 0x74, 0x84, 0xB9, 0x09, 0xB5, 0x78, 0x7B, 0x90, 0x39, 0xEE, 0x93,
  0x40, 0xB0, 0x93, 0x84, 0xBA, 0xBF, 0xD6, 0x20, 0xB0, 0x93, 0x89, 0x0B, 0x60, 0x1B, 0xF3, 0x0B,
  0x93, 0x84, 0xB9, 0x9E, 0xE8, 0x28, 0x7B, 0x90, 0x28, 0xEF, 0xA5, 0x48, 0x5B, 0x90, 0xAC, 0x71,
  0x60, 0xB0, 0x97, 0x30, 0x8A, 0x06, 0x73, 0x0C, 0x0B, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_text_rotation_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_text_rotation_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_text_rotation_none 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_round_18_action_text_rotation_none_data[] PROGMEM = {
  0x50, 0x37, 0x38, 0x16, 0xF8, 0x72, 0x81, 0xDB, 0xE7, 0x18, 0x33, 0xF1, 0xE4, 0x78, 0x39, 0xA0,
  0x9A, 0x78, 0x4E, 0xB7, 0xAF, 0x15, 0x85, 0x5E, 0xBB, 0xBE, 0x65, 0x0B, 0x09, 0x30, 0x80, 0xC5,
  0x08, 0x03, 0x30, 0x20, 0xA7, 0x68, 0x16, 0x02, 0x80, 0x59, 0x90, 0xB0, 0x28, 0x05, 0xB9, 0x0C,
  0x73, 0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_text_rotation_none() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_text_rotation_none_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_theaters 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_theaters_data[] PROGMEM = {
  0x10, 0x22, 0x80, 0x03, 0x28, 0x42, 0x05, 0xE0, 0x9C, 0x83, 0x90, 0xE5, 0x6F, 0xB8, 0x36, 0x6F,
  0x5C, 0xC8, 0x6C, 0x5F, 0x66, 0xE1, 0xBC, 0x83, 0xB1, 0xE6, 0x6F, 0xB8, 0x36, 0x6E, 0x3B, 0xC8,
  0x6B, 0x3E, 0x66, 0xE3, 0xBC, 0x83, 0xB3, 0xE6, 0x6F, 0xB8, 0x36, 0x6E, 0x1B, 0xC8, 0x6B, 0x1E,
  0x66, 0xF5, 0xCC, 0x83, 0xC5, 0xF6, 0x6F, 0xB8, 0x36, 0x5E, 0x09, 0xC8, 0x49, 0x0E, 0x50, 0x22,
  0x80, 0x03, 0x20, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_theaters() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_theaters_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_thumb_down_off_alt 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_round_18_action_thumb_down_off_alt_data[] PROGMEM = {
  0x38, 0x04, 0x30, 0x12, 0x03, 0x01, 0x30, 0xAF, 0x98, 0x3D, 0x06, 0xFE, 0x28, 0x12, 0xF4, 0x68,
  0x24, 0xF1, 0x9A, 0x82, 0x10, 0x9D, 0x78, 0x24, 0xF1, 0x9A, 0x82, 0x10, 0xE7, 0x78, 0x24, 0xF1,
  0x9A, 0x82, 0x16, 0xE1, 0x78, 0x24, 0xF1, 0x9A, 0x81, 0x1D, 0x97, 0x18, 0x24, 0xF1, 0x9A, 0x81,
  0x1F, 0x57, 0x18, 0x24, 0xF1, 0x9A, 0x81, 0x1B, 0xE8, 0x01, 0x90, 0x72, 0x82, 0x4F, 0x18, 0xA8,
  0x71, 0x08, 0xBB, 0xBB, 0xE9, 0x28, 0x49, 0xE0, 0x19, 0x67, 0x84, 0xE6, 0x09, 0xF4, 0x73, 0x84,
  0x2F, 0x39, 0xF4, 0x74, 0x83, 0x5F, 0xAF, 0x47, 0x50, 0x7A, 0x04, 0x76, 0x81, 0x2B, 0x47, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_thumb_down_off_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_thumb_down_off_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_thumb_down 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_thumb_down_data[] PROGMEM = {
  0x38, 0x04, 0x30, 0x12, 0x03, 0x01, 0x30, 0xAF, 0x98, 0x3D, 0x06, 0xFE, 0x20, 0x2F, 0xB0, 0x10,
  0x9A, 0x81, 0x10, 0x9F, 0xB0, 0x10, 0x9A, 0x81, 0x10, 0xEF, 0xB0, 0x10, 0x9A, 0x01, 0x06, 0xFC,
  0x01, 0x09, 0xA0, 0x10, 0xDF, 0xC0, 0x10, 0x9A, 0x01, 0xFD, 0x01, 0x09, 0xA0, 0x10, 0xBF, 0xC0,
  0x10, 0x8A, 0x86, 0x10, 0x8B, 0xBB, 0xBE, 0xC8, 0x3E, 0x01, 0x96, 0x70, 0xEC, 0x04, 0x73, 0x02,
  0xC0, 0x47, 0x40, 0x5B, 0x04, 0x75, 0x07, 0xA0, 0x47, 0x68, 0x12, 0xA4, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_thumb_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_thumb_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_thumbs_up_down 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_thumbs_up_down_data[] PROGMEM = {
  0x30, 0x50, 0x67, 0x71, 0x81, 0x6F, 0xC7, 0x70, 0x6A, 0x0A, 0x76, 0x06, 0xB8, 0x3B, 0x55, 0x51,
  0x72, 0x0E, 0xF0, 0xD7, 0x2F, 0x90, 0xE7, 0x2F, 0x90, 0x97, 0x2F, 0x98, 0x24, 0x01, 0xA8, 0x01,
  0xB0, 0x6F, 0x0E, 0x20, 0x9F, 0xF0, 0x92, 0x0E, 0xF0, 0x68, 0x01, 0xB8, 0x2A, 0x10, 0x4F, 0x97,
  0x20, 0x9F, 0x97, 0x20, 0xEF, 0x97, 0x20, 0xDF, 0x0E, 0x72, 0x83, 0x15, 0x55, 0xBB, 0x06, 0x76,
  0x0A, 0xA0, 0x67, 0x78, 0x1C, 0xF6, 0x77, 0x10, 0x60, 0x53,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_thumbs_up_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_action_thumbs_up_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_thumb_up_off_alt 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_thumb_up_off_alt_data[] PROGMEM = {
  0x72, 0x81, 0x4A, 0x37, 0x60, 0x4A, 0x08, 0x75, 0x04, 0xB0, 0x57, 0x40, 0x4C, 0x02, 0x73, 0x04,
  0xC0, 0xE7, 0x83, 0x69, 0x10, 0xEC, 0x85, 0xEB, 0xBB, 0xB8, 0x11, 0xA0, 0x81, 0xFC, 0x0B, 0x01,
  0xA0, 0x91, 0xFD, 0x01, 0xA0, 0x91, 0xFC, 0x0D, 0x01, 0xA0, 0x91, 0xFC, 0x07, 0x01, 0xA0, 0x91,
  0xFB, 0x81, 0xE1, 0x1A, 0x09, 0x1F, 0xB8, 0x19, 0x01, 0xA0, 0x91, 0xFB, 0x02, 0x28, 0x3D, 0xF6,
  0x0D, 0xF9, 0x0A, 0x30, 0x10, 0x32, 0x01, 0x80, 0x43, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_thumb_up_off_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_thumb_up_off_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_thumb_up 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_thumb_up_data[] PROGMEM = {
  0x72, 0x81, 0x4A, 0x37, 0x60, 0x4A, 0x08, 0x75, 0x04, 0xB0, 0x57, 0x40, 0x4C, 0x02, 0x73, 0x04,
  0xC0, 0xE7, 0x83, 0x69, 0x10, 0xEC, 0x85, 0xEB, 0xBB, 0xB8, 0x11, 0xA0, 0x81, 0xFC, 0x0B, 0x01,
  0xA0, 0x91, 0xFD, 0x01, 0xA0, 0x91, 0xFC, 0x0D, 0x01, 0xA0, 0x91, 0xFC, 0x07, 0x01, 0xA0, 0x91,
  0xFB, 0x81, 0xE1, 0x1A, 0x09, 0x1F, 0xB8, 0x19, 0x01, 0xA0, 0x91, 0xFB, 0x02, 0x28, 0x3D, 0xF6,
  0x0D, 0xF9, 0x0A, 0x30, 0x10, 0x32, 0x01, 0x80, 0x43, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_thumb_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_thumb_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_timeline 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_action_timeline_data[] PROGMEM = {
  0x77, 0x06, 0x03, 0x58, 0x11, 0x83, 0x58, 0x17, 0xFE, 0x58, 0x19, 0xFE, 0x48, 0x21, 0xCF, 0xD4,
  0x02, 0x0E, 0xA0, 0x52, 0x82, 0x1C, 0xD3, 0x48, 0x91, 0x2D, 0xC2, 0x8F, 0x51, 0xCD, 0x24, 0x82,
  0x2D, 0xC1, 0x20, 0x8A, 0x0D, 0x02, 0x48, 0x23, 0xDC, 0x14, 0xA0, 0x84, 0x82, 0xDF, 0xC1, 0x58,
  0x16, 0x91, 0x48, 0x1E, 0xF7, 0x76, 0x03, 0x06, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_timeline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_timeline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_tips_and_updates 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_action_tips_and_updates_data[] PROGMEM = {
  0x75, 0x04, 0x02, 0x71, 0x02, 0x01, 0x48, 0x21, 0xCB, 0x14, 0x02, 0x0A, 0xB0, 0xD0, 0x62, 0x82,
  0x9F, 0xE8, 0x30, 0x30, 0xEE, 0x09, 0x20, 0x70, 0x64, 0x0D, 0xF9, 0x81, 0x60, 0x12, 0x81, 0x10,
  0x5F, 0xA0, 0xD3, 0x82, 0x3C, 0x58, 0xFB, 0x01, 0x38, 0x19, 0x19, 0xFB, 0x01, 0x50, 0x7F, 0xA0,
  0xE6, 0x01, 0xFA, 0x09, 0x70, 0x7F, 0x0D, 0x01, 0x71, 0x07, 0x80, 0x1B, 0x0A, 0x02, 0x73, 0x84,
  0x35, 0x55, 0x51, 0x74, 0x0B, 0xC0, 0x47, 0x50, 0xF1, 0x77, 0x81, 0x5F, 0xD7, 0x71, 0x01, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_tips_and_updates() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 17, 16), Box(0, 0, 17, 17),
      ic_round_18_action_tips_and_updates_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_toc 18x18, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_round_18_action_toc_data[] PROGMEM = {
  0x01, 0x80, 0x59, 0x83, 0x30, 0x71, 0x18, 0x05, 0xB8, 0x24, 0x09, 0x17, 0x70, 0x18, 0x05, 0x98,
  0x34, 0x08, 0x11, 0x80, 0x59, 0x82, 0x40, 0x81, 0x77, 0x01, 0x80, 0x5B, 0x83, 0x40, 0x91, 0x18,
  0x05, 0x98, 0x23, 0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_toc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_round_18_action_toc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_today 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_today_data[] PROGMEM = {
  0x30, 0x80, 0xA4, 0x0A, 0x08, 0x48, 0x94, 0x35, 0xBD, 0x55, 0x55, 0xDB, 0x53, 0x02, 0xFD, 0x02,
  0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x82, 0x44, 0xF2, 0x80, 0x41, 0x85, 0x2F, 0x44, 0xF0,
  0x40, 0xF7, 0x59, 0x83, 0x44, 0xF0, 0x9B, 0x59, 0x83, 0x44, 0xF0, 0x9B, 0x59, 0x83, 0x44, 0xF0,
  0x8A, 0x0E, 0x59, 0x00, 0x49, 0x73, 0x98, 0x24, 0x4F, 0x28, 0x04, 0x18, 0x32, 0xF4, 0x1E, 0xFB,
  0x82, 0xE1, 0x01, 0x80, 0x63, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_today() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_round_18_action_today_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_token 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_round_18_action_token_data[] PROGMEM = {
  0x60, 0x06, 0x73, 0x05, 0x0D, 0xA0, 0xD0, 0x56, 0x03, 0x0C, 0xE0, 0xC0, 0x33, 0x01, 0x0B, 0xF9,
  0x0B, 0x01, 0x28, 0x97, 0x40, 0x4C, 0xC6, 0x6C, 0xC4, 0x04, 0x01, 0xFB, 0x22, 0x00, 0x32, 0x83,
  0x2B, 0xF1, 0x1B, 0x04, 0x03, 0xA0, 0x30, 0x4B, 0x00, 0x1B, 0x05, 0x03, 0xA0, 0x30, 0x5B, 0x00,
  0x1B, 0x84, 0xC0, 0x33, 0x0C, 0xB0, 0x11, 0xC8, 0x2C, 0x22, 0xCC, 0x20, 0x9C, 0x00, 0x5C, 0x09,
  0x30, 0x30, 0xCA, 0x00, 0x5A, 0x0C, 0x03, 0x68, 0x45, 0xD5, 0x5D, 0x57, 0x30, 0x01, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_token() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_token_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_toll 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_round_18_action_toll_data[] PROGMEM = {
  0x71, 0x82, 0x35, 0x51, 0x68, 0x41, 0x9F, 0x33, 0xDC, 0x09, 0x01, 0x48, 0x92, 0xCE, 0x54, 0xFB,
  0x30, 0x16, 0xEC, 0x38, 0x47, 0xE2, 0x0E, 0xA5, 0x81, 0x2E, 0x82, 0x84, 0xE7, 0x05, 0xF1, 0x68,
  0x77, 0xE0, 0x1F, 0x30, 0x8D, 0x78, 0x73, 0xF2, 0x1F, 0x30, 0x8D, 0x78, 0x90, 0x3F, 0x20, 0xE7,
  0x05, 0xF1, 0x60, 0x70, 0xE2, 0x84, 0x7E, 0x20, 0xEA, 0x58, 0x12, 0xE8, 0x38, 0x92, 0xCE, 0x54,
  0xFB, 0x30, 0x16, 0xEC, 0x48, 0x41, 0x9F, 0x23, 0xDC, 0x09, 0x01, 0x73, 0x82, 0x35, 0x51, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_toll() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_toll_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_touch_app 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_touch_app_data[] PROGMEM = {
  0x28, 0x38, 0xEF, 0xD4, 0x58, 0x29, 0xFD, 0xBA, 0x03, 0x38, 0x61, 0xFB, 0x25, 0x2E, 0xB3, 0x86,
  0x3F, 0x5B, 0xF5, 0xAD, 0x38, 0x61, 0xF4, 0xCF, 0x6A, 0xB4, 0x85, 0x94, 0xCF, 0x69, 0x45, 0x83,
  0x1C, 0xF6, 0x27, 0x81, 0xCF, 0x67, 0x10, 0xCB, 0x0B, 0x03, 0x50, 0xCD, 0x81, 0xA0, 0x12, 0x0C,
  0xE8, 0x35, 0xEE, 0x9D, 0xE0, 0x40, 0x7F, 0xA8, 0x11, 0x07, 0xF0, 0xE3, 0x07, 0xE0, 0x94, 0x02,
  0x80, 0x13, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_touch_app() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_touch_app_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_tour 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_action_tour_data[] PROGMEM = {
  0x10, 0x17, 0x30, 0x50, 0xD7, 0x30, 0x69, 0x80, 0x65, 0x06, 0xFB, 0x0C, 0x06, 0xC0, 0x0E, 0xC0,
  0x50, 0x6B, 0x0D, 0x20, 0xDA, 0x81, 0xD0, 0x6B, 0x0B, 0x20, 0xBA, 0x81, 0xA0, 0x6C, 0x00, 0x9C,
  0x02, 0x06, 0xFB, 0x0A, 0x06, 0x98, 0x05, 0xB8, 0x1A, 0x6E, 0x73, 0x06, 0x0E, 0x73, 0x06, 0x0E,
  0x73, 0x06, 0x0E, 0x73, 0x05, 0x0D, 0x74, 0x01, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_tour() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_round_18_action_tour_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_track_changes 18x18, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_round_18_action_track_changes_data[] PROGMEM = {
  0x70, 0x27, 0x50, 0x30, 0xBA, 0x09, 0x73, 0x84, 0x8F, 0xB5, 0xBA, 0x72, 0x85, 0x8F, 0x50, 0x2C,
  0xA3, 0x05, 0x07, 0x38, 0x33, 0xF5, 0x0A, 0xA0, 0xA3, 0x81, 0x5F, 0x42, 0x89, 0x4B, 0xB0, 0xAE,
  0x4A, 0xA0, 0x59, 0x0B, 0xB2, 0x98, 0xA3, 0x52, 0xF4, 0x0A, 0xA0, 0x4F, 0x35, 0xF0, 0x2F, 0x36,
  0xE0, 0x2A, 0x89, 0x42, 0x0E, 0x63, 0xF2, 0x2F, 0x36, 0xE0, 0x2A, 0x8A, 0x32, 0x0E, 0x63, 0xF2,
  0x0F, 0x52, 0xF4, 0x03, 0x30, 0x4F, 0x26, 0x92, 0x84, 0xBB, 0x09, 0xE4, 0x28, 0x44, 0xE9, 0x0B,
  0xB2, 0x83, 0x3F, 0x50, 0x9A, 0x85, 0xEF, 0x90, 0x6F, 0x33, 0x89, 0x28, 0xF5, 0x02, 0x66, 0x20,
  0x6F, 0x85, 0x89, 0x08, 0xFB, 0x52, 0x26, 0xBF, 0x87, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x20,
  0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_track_changes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_track_changes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_transcribe 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_round_18_action_transcribe_data[] PROGMEM = {
  0x75, 0x08, 0x01, 0x68, 0x15, 0x62, 0x38, 0x18, 0xE1, 0x50, 0xCA, 0x0E, 0x03, 0x28, 0x2E, 0x71,
  0x53, 0x05, 0xC8, 0x5B, 0x03, 0xF2, 0x7E, 0x30, 0x6C, 0x85, 0xC0, 0x4F, 0x18, 0xC3, 0x02, 0x0E,
  0xB8, 0x57, 0x01, 0xF5, 0x3B, 0x48, 0x23, 0xBC, 0x73, 0x0B, 0x0C, 0x78, 0x11, 0x21, 0x38, 0x12,
  0xE2, 0x30, 0x50, 0xBC, 0x81, 0xD8, 0x15, 0x0B, 0xF9, 0x0E, 0x03, 0x30, 0x2F, 0xB0, 0x83, 0x03,
  0xFB, 0x09, 0x48, 0x06, 0x30, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_transcribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_transcribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_translate 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_round_18_action_translate_data[] PROGMEM = {
  0x50, 0x17, 0x71, 0x0D, 0x05, 0x72, 0x89, 0x24, 0x55, 0x55, 0xE9, 0x55, 0x55, 0x14, 0x0D, 0xFB,
  0x06, 0x74, 0x81, 0x3F, 0x37, 0x20, 0x80, 0x32, 0x0B, 0x0C, 0x73, 0x84, 0xAE, 0x17, 0xF3, 0x20,
  0x10, 0x37, 0x82, 0xDD, 0xF6, 0x38, 0x1E, 0xF3, 0x68, 0x16, 0xFD, 0x38, 0x25, 0xEC, 0x95, 0x83,
  0x4F, 0xBE, 0xB2, 0x82, 0xB9, 0x6E, 0x48, 0x93, 0x4F, 0xA0, 0x3D, 0x21, 0xF4, 0x1F, 0x52, 0x81,
  0x3F, 0x95, 0x84, 0x7F, 0x43, 0xCB, 0x20, 0x30, 0x76, 0x0D, 0xD0, 0x17, 0x18, 0x13, 0xF3, 0x30,
  0xE0, 0x77, 0x10, 0x60, 0xD4, 0x09, 0x0A, 0x72, 0x01, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_translate() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_translate_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_trending_down 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_round_18_action_trending_down_data[] PROGMEM = {
  0x09, 0x05, 0x76, 0x81, 0x8F, 0x54, 0x01, 0x71, 0x81, 0x8F, 0x52, 0x82, 0x3E, 0xD2, 0x78, 0x78,
  0xF5, 0x3E, 0xAC, 0xD2, 0x78, 0x91, 0x8F, 0xEA, 0x01, 0xCD, 0x20, 0x25, 0x07, 0x08, 0x38, 0x41,
  0xCD, 0x5E, 0x37, 0x30, 0x10, 0xCA, 0x03, 0x73, 0x03, 0x0E, 0xA0, 0x37, 0x38, 0x35, 0x99, 0x91,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_trending_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_action_trending_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_trending_flat 18x18, 4-bit Alpha,  RLE, 17 bytes.
static const unsigned char ic_round_18_action_trending_flat_data[] PROGMEM = {
  0x74, 0x82, 0x7A, 0x01, 0x80, 0x69, 0x82, 0xCF, 0xA1, 0x80, 0x69, 0x81, 0xCF, 0xA7, 0x40, 0x70,
  0xA1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_trending_flat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 15, 10), Box(0, 0, 17, 17),
      ic_round_18_action_trending_flat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_trending_up 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_18_action_trending_up_data[] PROGMEM = {
  0x73, 0x04, 0x0F, 0x77, 0x40, 0x4B, 0x03, 0x74, 0x0C, 0xA0, 0x34, 0x06, 0x07, 0x48, 0x3B, 0xE7,
  0xF3, 0x30, 0x7A, 0x09, 0x28, 0x3B, 0xE3, 0x03, 0x38, 0x77, 0xF6, 0x4F, 0x9B, 0xE3, 0x58, 0x17,
  0xF6, 0x28, 0x24, 0xFE, 0x35, 0x81, 0x7F, 0x64, 0x02, 0x01, 0x60, 0xA0, 0x67, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_trending_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 12), Box(0, 0, 17, 17),
      ic_round_18_action_trending_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_troubleshoot 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_round_18_action_troubleshoot_data[] PROGMEM = {
  0x68, 0x13, 0x31, 0x73, 0x09, 0xC0, 0xA0, 0x17, 0x87, 0xCE, 0x72, 0x15, 0xDE, 0x25, 0x82, 0x9E,
  0x47, 0x40, 0x0C, 0x59, 0x82, 0x78, 0xF2, 0x38, 0x13, 0xF3, 0x48, 0x53, 0x0C, 0xA6, 0x4A, 0x20,
  0xE0, 0x62, 0x89, 0x3C, 0xDD, 0xDD, 0x4A, 0xBC, 0x50, 0xD7, 0x40, 0x01, 0x28, 0x5E, 0xD2, 0xD3,
  0xF4, 0x40, 0xA0, 0xD2, 0x08, 0x05, 0x20, 0xA0, 0xD5, 0x82, 0x1D, 0xC3, 0x28, 0x22, 0xAF, 0x96,
  0x89, 0x02, 0xBF, 0xED, 0xFC, 0x8F, 0x77, 0x82, 0x36, 0x63, 0x28, 0x16, 0xF7, 0x76, 0x81, 0x6F,
  0x67, 0x60, 0x60, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_troubleshoot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_troubleshoot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_try 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_round_18_action_try_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x1E, 0x03, 0xFF, 0x00, 0x3E, 0x00, 0xEE, 0x00, 0x3E, 0x00,
  0x5E, 0x00, 0x3D, 0x0A, 0x20, 0xAD, 0x00, 0x3C, 0x03, 0x40, 0x3C, 0x00, 0x3C, 0x0D, 0x05, 0x20,
  0x50, 0xCC, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0xBE, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x01,
  0x03, 0xA0, 0x98, 0x06, 0x78, 0x34, 0x03, 0xF7, 0x76, 0x01, 0x05, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_try() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_try_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_turned_in_not 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_round_18_action_turned_in_not_data[] PROGMEM = {
  0x10, 0x78, 0x04, 0xB8, 0x37, 0x02, 0xFE, 0x80, 0x2B, 0x84, 0xEF, 0x23, 0xF4, 0x68, 0x44, 0xF3,
  0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68,
  0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x8A, 0x03, 0xF3,
  0x3F, 0x31, 0x7D, 0xD7, 0x13, 0xF3, 0x3F, 0xBA, 0x00, 0xBA, 0x86, 0xBF, 0x33, 0xFE, 0x82, 0x28,
  0x52, 0x8E, 0xF3, 0x26, 0x71, 0x06, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_turned_in_not() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_turned_in_not_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_turned_in 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_round_18_action_turned_in_data[] PROGMEM = {
  0x10, 0x78, 0x04, 0xB8, 0x17, 0x02, 0xFB, 0x02, 0x03, 0xFB, 0x00, 0x3F, 0xB0, 0x03, 0xFB, 0x00,
  0x3F, 0xB0, 0x03, 0xFB, 0x00, 0x3F, 0xB0, 0x03, 0xFB, 0x00, 0x3F, 0xB0, 0x03, 0xFB, 0x00, 0x3C,
  0x00, 0xBC, 0x84, 0x33, 0xFE, 0x82, 0x28, 0x52, 0x8E, 0xF3, 0x26, 0x71, 0x06, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_turned_in() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_turned_in_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_unfold_less_double 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_round_18_action_unfold_less_double_data[] PROGMEM = {
  0x05, 0x04, 0x28, 0x90, 0x45, 0x7F, 0x55, 0xF7, 0x09, 0xA0, 0x83, 0x00, 0x72, 0x09, 0x0A, 0x28,
  0x93, 0xA9, 0x3E, 0xAA, 0xE3, 0x03, 0xEE, 0x33, 0x00, 0x17, 0x72, 0x00, 0x13, 0x89, 0x33, 0xEE,
  0x30, 0x3E, 0xAA, 0xE3, 0x9A, 0x20, 0xA0, 0x92, 0x00, 0x73, 0x08, 0xA8, 0x90, 0x80, 0x7F, 0x55,
  0xF7, 0x54, 0x20, 0x40, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_unfold_less_double() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 11, 17), Box(0, 0, 17, 17),
      ic_round_18_action_unfold_less_double_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_unfold_more_double 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_round_18_action_unfold_more_double_data[] PROGMEM = {
  0x20, 0x05, 0x30, 0x7A, 0x89, 0x07, 0x06, 0xF6, 0x6F, 0x66, 0x52, 0x8A, 0x45, 0x60, 0x1B, 0xC1,
  0x01, 0xCD, 0xDC, 0x19, 0xD2, 0x2D, 0x91, 0x12, 0x00, 0x17, 0x50, 0x01, 0x28, 0xA4, 0x11, 0x9D,
  0x22, 0xD9, 0x1C, 0xDD, 0xC1, 0x01, 0xCB, 0x10, 0x65, 0x28, 0x90, 0x56, 0x6F, 0x66, 0xF6, 0x07,
  0xA0, 0x73, 0x00, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_unfold_more_double() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 11, 17), Box(0, 0, 17, 17),
      ic_round_18_action_unfold_more_double_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_unpublished 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_round_18_action_unpublished_data[] PROGMEM = {
  0x58, 0x41, 0x57, 0x74, 0x15, 0x03, 0x05, 0x20, 0x9E, 0x09, 0x01, 0x38, 0x37, 0xF7, 0x05, 0xF0,
  0xD0, 0x23, 0x83, 0x9F, 0x70, 0x5F, 0x0D, 0x01, 0x20, 0x9A, 0x81, 0x70, 0x5F, 0x81, 0x90, 0x1C,
  0x81, 0x70, 0x5A, 0x0B, 0x09, 0xB0, 0x10, 0x5D, 0x84, 0x70, 0x5B, 0x04, 0xB0, 0x50, 0x7B, 0x82,
  0xAD, 0xF7, 0x20, 0x30, 0xEB, 0x00, 0x7B, 0x85, 0x31, 0xCF, 0x70, 0x5C, 0x07, 0x05, 0xB8, 0x6D,
  0x11, 0x9F, 0x70, 0x5B, 0x05, 0x01, 0xC8, 0x1D, 0x13, 0xA8, 0x17, 0x05, 0xA8, 0x11, 0x09, 0xFA,
  0x82, 0x70, 0x59, 0x20, 0x10, 0xDF, 0xA0, 0x75, 0x02, 0x0D, 0xFA, 0x07, 0x50, 0x10, 0x9E, 0x82,
  0x99, 0xF5, 0x68, 0x31, 0x47, 0x74, 0x30, 0x70, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_unpublished() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_unpublished_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_update_disabled 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_round_18_action_update_disabled_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x15, 0x83, 0xE7, 0x01, 0xBC, 0x8A, 0x5B, 0x30, 0x10, 0x6F, 0x70, 0x75, 0x11,
  0x4B, 0xF7, 0xD4, 0x08, 0xF7, 0x20, 0x04, 0x20, 0x9A, 0x87, 0x40, 0xBD, 0xF7, 0x07, 0xA2, 0x0D,
  0xA8, 0x74, 0x1F, 0x46, 0xF7, 0x04, 0x20, 0xF3, 0x18, 0x54, 0xF1, 0x06, 0xF7, 0x78, 0x14, 0xF1,
  0x28, 0x16, 0xF7, 0x38, 0x41, 0xD2, 0x1F, 0x43, 0x81, 0x6F, 0x72, 0x84, 0x4F, 0x10, 0xBB, 0x48,
  0x46, 0xF7, 0x07, 0xB2, 0x81, 0x2F, 0x84, 0x83, 0x6F, 0x70, 0x13, 0x89, 0x05, 0xFB, 0x41, 0x15,
  0xDF, 0x75, 0x02, 0x0B, 0xC8, 0x2B, 0x8F, 0x76, 0x82, 0x13, 0x31, 0x20, 0x60, 0xE1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_update_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_update_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_update 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_action_update_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x82, 0xB3, 0x01, 0x38, 0x96, 0x5F, 0xB4, 0x11, 0x5B,
  0xF7, 0xD4, 0x03, 0xF8, 0x20, 0x04, 0x20, 0x9A, 0x82, 0x40, 0xBB, 0x30, 0x0A, 0x20, 0xDA, 0x82,
  0x41, 0xF5, 0x30, 0x0A, 0x20, 0xF3, 0x18, 0x13, 0xF1, 0x30, 0xA0, 0xC6, 0x81, 0x3F, 0x13, 0x81,
  0x3E, 0xA2, 0x84, 0x1D, 0x21, 0xF4, 0x48, 0x90, 0x3E, 0x60, 0x5F, 0x10, 0xBB, 0x50, 0x12, 0x00,
  0xB2, 0x81, 0x3F, 0x86, 0x81, 0x8F, 0x33, 0x89, 0x05, 0xFB, 0x41, 0x25, 0xCF, 0x55, 0x03, 0x0B,
  0xC0, 0xB0, 0x37, 0x18, 0x21, 0x33, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_upgrade 18x18, 4-bit Alpha,  RLE, 29 bytes.
static const unsigned char ic_round_18_action_upgrade_data[] PROGMEM = {
  0x20, 0x01, 0x38, 0x51, 0xDD, 0x10, 0x1D, 0xA8, 0x6D, 0x12, 0x39, 0x93, 0x22, 0x00, 0x64, 0x00,
  0x64, 0x00, 0x64, 0x00, 0x32, 0x89, 0x23, 0x55, 0x55, 0x34, 0x77, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_upgrade() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 11, 13), Box(0, 0, 17, 17),
      ic_round_18_action_upgrade_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_verified 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_verified_data[] PROGMEM = {
  0x48, 0x46, 0x82, 0x28, 0x67, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x81, 0x48, 0xDE, 0x81, 0xD8, 0x42,
  0x0B, 0xFB, 0x0B, 0x20, 0xAF, 0x0E, 0xA0, 0xA2, 0x0D, 0xE0, 0xA0, 0x2A, 0x81, 0xD0, 0xBE, 0x81,
  0xA2, 0xDB, 0x00, 0xBB, 0x83, 0x8F, 0xA2, 0xDC, 0x81, 0xB0, 0xDA, 0x82, 0x73, 0x2D, 0xC0, 0xC2,
  0x0A, 0xB0, 0x90, 0xDD, 0x0A, 0x20, 0xBF, 0xB0, 0xB2, 0x81, 0x48, 0xDE, 0x81, 0xC8, 0x44, 0x01,
  0x0E, 0xC0, 0xE0, 0x17, 0x84, 0x68, 0x22, 0x86, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_verified() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_verified_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_verified_user 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_verified_user_data[] PROGMEM = {
  0x38, 0x43, 0x9E, 0xE9, 0x34, 0x07, 0x0D, 0xE8, 0x2D, 0x70, 0xAF, 0xB0, 0xA0, 0xDF, 0xB0, 0x0D,
  0xF0, 0xEA, 0x00, 0xDE, 0x06, 0x1A, 0x0D, 0x0C, 0xA8, 0x48, 0xDF, 0x60, 0x9A, 0x0C, 0x0B, 0xA8,
  0x32, 0x26, 0x09, 0xB0, 0xB0, 0x8A, 0x82, 0xE2, 0x09, 0xC0, 0x80, 0x2B, 0x0E, 0x0D, 0xD8, 0x12,
  0x0A, 0xF9, 0x0A, 0x20, 0x10, 0xEE, 0x0E, 0x01, 0x30, 0x20, 0xDC, 0x0D, 0x02, 0x50, 0x10, 0x9A,
  0x09, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_verified_user() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_round_18_action_verified_user_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_vertical_split 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_vertical_split_data[] PROGMEM = {
  0x18, 0x00, 0x70, 0x62, 0x89, 0x45, 0x77, 0x76, 0x02, 0xDD, 0xDD, 0xC0, 0x1D, 0x04, 0x70, 0x1D,
  0x81, 0x42, 0xEB, 0x81, 0xD0, 0x1D, 0x87, 0x40, 0x55, 0x55, 0x40, 0x1D, 0x87, 0x40, 0x55, 0x55,
  0x40, 0x1D, 0x81, 0x42, 0xEB, 0x81, 0xD0, 0x1D, 0x04, 0x70, 0x1D, 0x87, 0x42, 0xDD, 0xDD, 0xC0,
  0x1D, 0x85, 0x40, 0x77, 0x77, 0x62, 0x83, 0x57, 0x77, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_vertical_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_vertical_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_agenda 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_round_18_action_view_agenda_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x04, 0xFD, 0x81,
  0x41, 0xDF, 0xB0, 0xD0, 0x12, 0x80, 0x61, 0x48, 0x06, 0x12, 0x01, 0x0D, 0xFB, 0x81, 0xD1, 0x4F,
  0xD0, 0x04, 0xFD, 0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_agenda() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_view_agenda_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_array 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_round_18_action_view_array_data[] PROGMEM = {
  0x82, 0x17, 0x33, 0x80, 0x27, 0x86, 0x33, 0x71, 0x4F, 0x79, 0xE8, 0x69, 0x7F, 0x44, 0xF7, 0x9E,
  0x86, 0x97, 0xF4, 0x4F, 0x79, 0xE8, 0x69, 0x7F, 0x44, 0xF7, 0x9E, 0x86, 0x97, 0xF4, 0x4F, 0x79,
  0xE8, 0x69, 0x7F, 0x44, 0xF7, 0x9E, 0x86, 0x97, 0xF4, 0x4F, 0x79, 0xE8, 0x69, 0x7F, 0x44, 0xF7,
  0x9E, 0x86, 0x97, 0xF4, 0x17, 0x33, 0x80, 0x27, 0x82, 0x33, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_array() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_view_array_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_carousel 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_view_carousel_data[] PROGMEM = {
  0x40, 0x38, 0x02, 0x70, 0x35, 0x82, 0x11, 0x09, 0xE8, 0x49, 0x01, 0x10, 0x2A, 0x07, 0x09, 0xE0,
  0x90, 0x7A, 0x02, 0x03, 0xA0, 0x70, 0x9E, 0x09, 0x07, 0xA0, 0x03, 0xA0, 0x70, 0x9E, 0x09, 0x07,
  0xA0, 0x03, 0xA0, 0x70, 0x9E, 0x09, 0x07, 0xA0, 0x03, 0xA0, 0x70, 0x9E, 0x09, 0x07, 0xA0, 0x30,
  0x2A, 0x07, 0x09, 0xE0, 0x90, 0x7A, 0x84, 0x20, 0x11, 0x09, 0xE8, 0x29, 0x01, 0x15, 0x03, 0x80,
  0x27, 0x03, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_carousel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_round_18_action_view_carousel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_column 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_round_18_action_view_column_data[] PROGMEM = {
  0x89, 0x51, 0x77, 0x71, 0x57, 0x75, 0x17, 0x77, 0x14, 0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB0, 0x04,
  0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB0, 0x04, 0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB0, 0x04, 0xB0, 0x40,
  0xCA, 0x0C, 0x04, 0xB0, 0x04, 0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB0, 0x04, 0xB0, 0x40, 0xCA, 0x0C,
  0x04, 0xB0, 0x04, 0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB0, 0x04, 0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB8,
  0x95, 0x41, 0x77, 0x71, 0x57, 0x75, 0x17, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_column() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_view_column_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_comfy_alt 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_view_comfy_alt_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3B, 0x86, 0xA5, 0x5E, 0xE5, 0x5A, 0xB0,
  0x03, 0xB0, 0x62, 0x00, 0xD2, 0x06, 0xB0, 0x03, 0xB0, 0x62, 0x00, 0xE2, 0x06, 0xB0, 0x03, 0xB8,
  0x1E, 0xDD, 0xA8, 0x1D, 0xDE, 0xB0, 0x03, 0xB8, 0x1E, 0xDD, 0xA8, 0x1D, 0xDE, 0xB0, 0x03, 0xB0,
  0x62, 0x00, 0xE2, 0x06, 0xB0, 0x03, 0xB0, 0x62, 0x00, 0xD2, 0x06, 0xB0, 0x03, 0xB8, 0x6A, 0x55,
  0xEE, 0x55, 0xAB, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_comfy_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_view_comfy_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_compact_alt 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_view_compact_alt_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3C, 0x84, 0xDD, 0xEE, 0xDD, 0xC0, 0x03,
  0xB0, 0xD2, 0x00, 0x72, 0x0D, 0xB0, 0x03, 0xB0, 0xD2, 0x00, 0x62, 0x0D, 0xB0, 0x03, 0xB8, 0x6E,
  0x77, 0xBB, 0x77, 0xEB, 0x00, 0x3B, 0x86, 0xE7, 0x7B, 0xB7, 0x7E, 0xB0, 0x03, 0xB0, 0xD2, 0x00,
  0x62, 0x0D, 0xB0, 0x03, 0xB0, 0xD2, 0x00, 0x72, 0x0D, 0xB0, 0x03, 0xC8, 0x4D, 0xDE, 0xED, 0xDC,
  0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_compact_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_view_compact_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_cozy 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_view_cozy_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF0, 0x10, 0x3B, 0x86, 0xD9, 0x9D, 0xD9, 0x9D, 0xB0,
  0x03, 0xB0, 0x92, 0x00, 0xA2, 0x09, 0xB0, 0x03, 0xB0, 0x92, 0x00, 0xA2, 0x09, 0xB0, 0x03, 0xB8,
  0x6D, 0x99, 0xEE, 0x99, 0xDB, 0x00, 0x3B, 0x86, 0xD9, 0x9E, 0xE9, 0x9D, 0xB0, 0x03, 0xB0, 0x92,
  0x00, 0xA2, 0x09, 0xB0, 0x03, 0xB0, 0x92, 0x00, 0xA2, 0x09, 0xB0, 0x03, 0xB8, 0x6D, 0x99, 0xDD,
  0x99, 0xDB, 0x03, 0x01, 0xFF, 0x81, 0x10, 0x38, 0x09, 0x05, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_cozy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_view_cozy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_day 18x18, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_round_18_action_view_day_data[] PROGMEM = {
  0x18, 0x09, 0x05, 0x10, 0x20, 0xEF, 0xB0, 0xE0, 0x27, 0x71, 0x07, 0x80, 0x6B, 0x81, 0x70, 0x3F,
  0xD0, 0x30, 0x4F, 0xD0, 0x04, 0xFD, 0x04, 0x03, 0xFD, 0x81, 0x30, 0x78, 0x06, 0xB0, 0x77, 0x71,
  0x02, 0x0E, 0xFB, 0x0E, 0x02, 0x18, 0x09, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_day() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_view_day_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_headline 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_round_18_action_view_headline_data[] PROGMEM = {
  0x01, 0x80, 0x67, 0x01, 0x03, 0x80, 0x6D, 0x03, 0x75, 0x03, 0xFB, 0x03, 0x18, 0x06, 0x52, 0x80,
  0x65, 0x10, 0x3F, 0xB0, 0x37, 0x50, 0x38, 0x06, 0xD0, 0x30, 0x18, 0x06, 0x70, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_headline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 13), Box(0, 0, 17, 17),
      ic_round_18_action_view_headline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_in_ar 18x18, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_round_18_action_view_in_ar_data[] PROGMEM = {
  0x30, 0x17, 0x30, 0x14, 0x82, 0x5E, 0xF5, 0x71, 0x82, 0x5F, 0xE5, 0x28, 0x1E, 0xA3, 0x73, 0x85,
  0x3A, 0xE0, 0x1F, 0x34, 0x82, 0x4C, 0xC4, 0x48, 0x33, 0xF1, 0x06, 0x38, 0x62, 0xBF, 0xAA, 0xFB,
  0x23, 0x06, 0x58, 0x29, 0xFC, 0x32, 0x82, 0x3C, 0xF9, 0x78, 0x25, 0xFE, 0x44, 0x82, 0x4E, 0xF5,
  0x68, 0x92, 0x6F, 0xAF, 0xA1, 0x1A, 0xFA, 0xF6, 0x68, 0x92, 0x6E, 0x04, 0xDE, 0xED, 0x40, 0xE6,
  0x60, 0x60, 0xE3, 0x00, 0xB3, 0x0E, 0x06, 0x60, 0x60, 0xE3, 0x00, 0xA3, 0x0E, 0x06, 0x68, 0x15,
  0xF5, 0x20, 0x0A, 0x28, 0x15, 0xF5, 0x78, 0x90, 0x8F, 0xC3, 0xAA, 0x3C, 0xF8, 0x50, 0x63, 0x86,
  0x2B, 0xFE, 0xEF, 0xB2, 0x38, 0x36, 0x01, 0xF3, 0x48, 0x24, 0xCC, 0x44, 0x85, 0x3F, 0x10, 0xEA,
  0x37, 0x38, 0x13, 0xAE, 0x28, 0x25, 0xEF, 0x57, 0x18, 0x25, 0xFE, 0x54, 0x01, 0x73, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_in_ar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_round_18_action_view_in_ar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_kanban 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_round_18_action_view_kanban_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4A, 0x86, 0xBA, 0xFB, 0xBF,
  0xAB, 0xA0, 0x04, 0xA8, 0x66, 0x3F, 0x55, 0xF3, 0x6A, 0x00, 0x4A, 0x86, 0x63, 0xF5, 0x5F, 0x36,
  0xA0, 0x04, 0xA8, 0x66, 0x3F, 0x77, 0xF3, 0x6A, 0x00, 0x4A, 0x06, 0x03, 0xC0, 0x30, 0x6A, 0x00,
  0x4A, 0x06, 0x03, 0xC0, 0x80, 0xAA, 0x00, 0x4A, 0x06, 0x03, 0xF9, 0x00, 0x4A, 0x0B, 0x0A, 0xF9,
  0x00, 0x4F, 0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_kanban() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_view_kanban_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_list 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_view_list_data[] PROGMEM = {
  0x83, 0x17, 0x72, 0x48, 0x04, 0x70, 0x10, 0x4A, 0x06, 0x0A, 0xF9, 0x84, 0x43, 0xDD, 0x48, 0x80,
  0x4D, 0x84, 0x30, 0x33, 0x01, 0x80, 0x43, 0x10, 0x4A, 0x05, 0x0A, 0xF9, 0x00, 0x4A, 0x05, 0x0A,
  0xF9, 0x84, 0x40, 0x33, 0x01, 0x80, 0x43, 0x18, 0x33, 0xDD, 0x48, 0x80, 0x4D, 0x03, 0x04, 0xA0,
  0x60, 0xAF, 0x98, 0x44, 0x17, 0x72, 0x48, 0x04, 0x70, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_view_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_module 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_round_18_action_view_module_data[] PROGMEM = {
  0x89, 0x51, 0x77, 0x71, 0x57, 0x75, 0x17, 0x77, 0x14, 0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB0, 0x04,
  0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB0, 0x04, 0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB8, 0xB4, 0x41, 0x77,
  0x71, 0x57, 0x75, 0x17, 0x77, 0x11, 0x77, 0x71, 0x57, 0x75, 0x17, 0x77, 0x14, 0xB0, 0x40, 0xCA,
  0x0C, 0x04, 0xB0, 0x04, 0xB0, 0x40, 0xCA, 0x0C, 0x04, 0xB0, 0x04, 0xB0, 0x40, 0xCA, 0x0C, 0x04,
  0xB8, 0x95, 0x41, 0x77, 0x71, 0x57, 0x75, 0x17, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_module() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_view_module_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_quilt 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_action_view_quilt_data[] PROGMEM = {
  0x84, 0x17, 0x77, 0x15, 0x80, 0x37, 0x01, 0x04, 0xB0, 0x40, 0xCF, 0x00, 0x4B, 0x04, 0x0C, 0xF0,
  0x04, 0xB0, 0x40, 0xCF, 0x00, 0x4B, 0x04, 0x05, 0x80, 0x37, 0x01, 0x04, 0xB8, 0x91, 0x45, 0x77,
  0x51, 0x77, 0x71, 0x4B, 0x04, 0x0C, 0xA0, 0xC0, 0x4B, 0x00, 0x4B, 0x04, 0x0C, 0xA0, 0xC0, 0x4B,
  0x00, 0x4B, 0x04, 0x0C, 0xA0, 0xC0, 0x4B, 0x89, 0x54, 0x17, 0x77, 0x15, 0x77, 0x51, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_quilt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_view_quilt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_sidebar 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_action_view_sidebar_data[] PROGMEM = {
  0x01, 0x80, 0x45, 0x84, 0x31, 0x55, 0x14, 0xF9, 0x0A, 0x06, 0xA0, 0x04, 0xF9, 0x0A, 0x06, 0xA0,
  0x04, 0xF9, 0x84, 0xA2, 0x99, 0x14, 0xF9, 0x84, 0xA2, 0x77, 0x14, 0xF9, 0x0A, 0x06, 0xA0, 0x04,
  0xF9, 0x0A, 0x06, 0xA0, 0x04, 0xF9, 0x84, 0xA2, 0x77, 0x14, 0xF9, 0x84, 0xA2, 0x99, 0x14, 0xF9,
  0x0A, 0x06, 0xA0, 0x04, 0xF9, 0x0A, 0x06, 0xA0, 0x40, 0x18, 0x04, 0x58, 0x33, 0x15, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_sidebar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_view_sidebar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_stream 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_round_18_action_view_stream_data[] PROGMEM = {
  0x10, 0x58, 0x06, 0x78, 0x15, 0x03, 0xFD, 0x03, 0x04, 0xFD, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28,
  0x06, 0x50, 0x22, 0x02, 0x80, 0x65, 0x81, 0x20, 0x2F, 0xD0, 0x20, 0x4F, 0xD0, 0x40, 0x3F, 0xD8,
  0x13, 0x05, 0x80, 0x67, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_stream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_round_18_action_view_stream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_timeline 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_round_18_action_view_timeline_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0xFD, 0x00, 0x4F, 0x85, 0x75, 0x5C, 0xF4,
  0x4F, 0x85, 0x53, 0x3B, 0xF4, 0x4F, 0xD0, 0x04, 0xC8, 0x29, 0x55, 0x9C, 0x00, 0x4C, 0x82, 0x95,
  0x59, 0xC0, 0x04, 0xFD, 0x85, 0x44, 0xFB, 0x33, 0x5F, 0x85, 0x44, 0xFC, 0x55, 0x7F, 0x00, 0x4F,
  0xD0, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_timeline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_view_timeline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_view_week 18x18, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_round_18_action_view_week_data[] PROGMEM = {
  0x18, 0x13, 0x55, 0x28, 0x21, 0x55, 0x12, 0x83, 0x55, 0x30, 0x1B, 0x81, 0x80, 0xCA, 0x81, 0xC0,
  0x8B, 0x01, 0x03, 0xB8, 0x1A, 0x0E, 0xA8, 0x1E, 0x0A, 0xB0, 0x03, 0xB8, 0x1A, 0x0E, 0xA8, 0x1E,
  0x0A, 0xB0, 0x03, 0xB8, 0x1A, 0x0E, 0xA8, 0x1E, 0x0A, 0xB0, 0x03, 0xB8, 0x1A, 0x0E, 0xA8, 0x1E,
  0x0A, 0xB0, 0x03, 0xB8, 0x1A, 0x0E, 0xA8, 0x1E, 0x0A, 0xB0, 0x03, 0xB8, 0x1A, 0x0E, 0xA8, 0x1E,
  0x0A, 0xB0, 0x03, 0xB8, 0x1A, 0x0E, 0xA8, 0x1E, 0x0A, 0xB0, 0x03, 0xB8, 0x1A, 0x0E, 0xA8, 0x1E,
  0x0A, 0xB0, 0x30, 0x1B, 0x81, 0x80, 0xCA, 0x81, 0xC0, 0x8B, 0x83, 0x10, 0x35, 0x52, 0x82, 0x15,
  0x51, 0x28, 0x15, 0x53, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_view_week() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_view_week_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_visibility_off 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_round_18_action_visibility_off_data[] PROGMEM = {
  0x10, 0xE0, 0x73, 0x82, 0x35, 0x52, 0x78, 0x36, 0xF7, 0x08, 0xC8, 0x1E, 0x92, 0x58, 0x5A, 0xF7,
  0x09, 0xEE, 0xC0, 0x53, 0x07, 0xB0, 0x73, 0x04, 0x0E, 0xB8, 0x17, 0x03, 0xD8, 0x37, 0x04, 0x14,
  0xC0, 0x30, 0xCB, 0x86, 0xE6, 0xF7, 0x04, 0x0E, 0xB0, 0x0C, 0xB8, 0x3E, 0x0A, 0xF7, 0x20, 0xEB,
  0x0C, 0x03, 0xC8, 0x54, 0x1A, 0xF7, 0x09, 0xB8, 0x13, 0x07, 0xB8, 0x90, 0xE4, 0x06, 0xF7, 0x09,
  0xF7, 0x30, 0x5C, 0x00, 0xEA, 0x81, 0x70, 0x45, 0x81, 0x29, 0xEC, 0x81, 0xEF, 0x77, 0x28, 0x62,
  0x55, 0x30, 0x6F, 0x77, 0x70, 0x60, 0xE2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_visibility_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_visibility_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_visibility 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_round_18_action_visibility_data[] PROGMEM = {
  0x68, 0x22, 0x55, 0x27, 0x28, 0x12, 0x9E, 0xC8, 0x1E, 0x92, 0x50, 0x5C, 0x00, 0xEC, 0x05, 0x30,
  0x7B, 0x0E, 0x04, 0x20, 0x40, 0xEB, 0x81, 0x70, 0x3C, 0x84, 0x41, 0xAA, 0x14, 0xC0, 0x30, 0xCB,
  0x81, 0xE0, 0xAA, 0x81, 0xA0, 0xEB, 0x00, 0xCB, 0x81, 0xE0, 0xAA, 0x81, 0xA0, 0xEB, 0x0C, 0x03,
  0xC8, 0x44, 0x1A, 0xA1, 0x4C, 0x81, 0x30, 0x7B, 0x0E, 0x04, 0x20, 0x40, 0xEB, 0x07, 0x30, 0x5C,
  0x00, 0xEC, 0x05, 0x58, 0x12, 0x9E, 0xC8, 0x1E, 0x92, 0x72, 0x82, 0x25, 0x52, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_visibility() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_visibility_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_voice_over_off 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_round_18_action_voice_over_off_data[] PROGMEM = {
  0x10, 0xE0, 0x77, 0x28, 0x12, 0xE2, 0x28, 0x56, 0xF7, 0x02, 0x62, 0x50, 0xD0, 0xA3, 0x89, 0x36,
  0xF7, 0x09, 0xE3, 0x02, 0xD1, 0x6E, 0x48, 0x48, 0xF7, 0x09, 0xB2, 0x83, 0xE6, 0x3F, 0x23, 0x06,
  0xA8, 0x17, 0x06, 0x28, 0x3E, 0x73, 0xF2, 0x30, 0x20, 0xEA, 0x07, 0x28, 0x21, 0xF3, 0x59, 0x58,
  0x33, 0xBD, 0xF7, 0x40, 0xA0, 0xB6, 0x83, 0x12, 0x7F, 0x73, 0x90, 0x53, 0x05, 0x0B, 0xE0, 0x72,
  0x01, 0x30, 0xBF, 0xA0, 0x74, 0x02, 0xFC, 0x07, 0x30, 0x3F, 0xB8, 0x1D, 0xF7, 0x38, 0x06, 0x38,
  0x12, 0x6E, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_voice_over_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_voice_over_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_watch_later 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_round_18_action_watch_later_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9C, 0x00, 0xCC, 0x09,
  0x30, 0x3D, 0x00, 0x5D, 0x03, 0x20, 0xBD, 0x00, 0x5D, 0x0B, 0x2E, 0x00, 0x5E, 0x10, 0x2E, 0x05,
  0x03, 0xE0, 0x02, 0xE8, 0x1C, 0x04, 0xD0, 0x21, 0xF8, 0x1B, 0x04, 0xC2, 0x0B, 0xF8, 0x1B, 0x3E,
  0xA0, 0xB2, 0x03, 0xFD, 0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_watch_later() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_watch_later_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_webhook 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_round_18_action_webhook_data[] PROGMEM = {
  0x71, 0x02, 0x76, 0x08, 0xA0, 0xE0, 0x77, 0x38, 0x58, 0xE6, 0x37, 0xF6, 0x72, 0x85, 0xE6, 0x16,
  0x08, 0xD7, 0x18, 0x61, 0xF3, 0x5F, 0x50, 0x37, 0x28, 0x3E, 0x80, 0xCC, 0x74, 0x84, 0x6F, 0x54,
  0xF4, 0x78, 0x92, 0x41, 0x06, 0xF4, 0x0C, 0xED, 0xB4, 0x38, 0x46, 0xF5, 0x1E, 0xA2, 0x84, 0x3B,
  0x8A, 0xF5, 0x28, 0x4E, 0x90, 0xAE, 0x14, 0x89, 0x21, 0x08, 0xE0, 0x2F, 0x36, 0xF6, 0x3D, 0x8A,
  0x06, 0x3F, 0x20, 0xF5, 0x17, 0x08, 0xD5, 0x55, 0x72, 0x59, 0x28, 0x94, 0xAD, 0x41, 0x6F, 0x70,
  0x35, 0x14, 0xDA, 0x20, 0x10, 0xAB, 0x08, 0x20, 0x6B, 0x0A, 0x01, 0x48, 0x11, 0x31, 0x48, 0x11,
  0x31, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_webhook() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_webhook_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_width_full 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_width_full_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x31, 0x3F, 0x2E, 0xF9, 0x86, 0xE2, 0xF3, 0x3F,
  0x2E, 0xF9, 0x86, 0xE2, 0xF3, 0x3F, 0x2E, 0xF9, 0x86, 0xE2, 0xF3, 0x3F, 0x2E, 0xF9, 0x86, 0xE2,
  0xF3, 0x3F, 0x2E, 0xF9, 0x86, 0xE2, 0xF3, 0x3F, 0x2E, 0xF9, 0x86, 0xE2, 0xF3, 0x3F, 0x2E, 0xF9,
  0x86, 0xE2, 0xF3, 0x3F, 0x2E, 0xF9, 0x83, 0xE2, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50,
  0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_width_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_width_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_width_normal 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_round_18_action_width_normal_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x22, 0x0A, 0xC0, 0xA2, 0x84, 0x2F,
  0x33, 0xF2, 0x20, 0xAC, 0x0A, 0x28, 0x42, 0xF3, 0x3F, 0x22, 0x0A, 0xC0, 0xA2, 0x84, 0x2F, 0x33,
  0xF2, 0x20, 0xAC, 0x0A, 0x28, 0x42, 0xF3, 0x3F, 0x22, 0x0A, 0xC0, 0xA2, 0x84, 0x2F, 0x33, 0xF2,
  0x20, 0xAC, 0x0A, 0x28, 0x42, 0xF3, 0x3F, 0x22, 0x0A, 0xC0, 0xA2, 0x84, 0x2F, 0x33, 0xF2, 0x20,
  0xAC, 0x0A, 0x28, 0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_width_normal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_width_normal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_width_wide 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_width_wide_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x31, 0x3F, 0x27, 0xF9, 0x86, 0x72, 0xF3, 0x3F,
  0x27, 0xF9, 0x86, 0x72, 0xF3, 0x3F, 0x27, 0xF9, 0x86, 0x72, 0xF3, 0x3F, 0x27, 0xF9, 0x86, 0x72,
  0xF3, 0x3F, 0x27, 0xF9, 0x86, 0x72, 0xF3, 0x3F, 0x27, 0xF9, 0x86, 0x72, 0xF3, 0x3F, 0x27, 0xF9,
  0x86, 0x72, 0xF3, 0x3F, 0x27, 0xF9, 0x83, 0x72, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90, 0x50,
  0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_width_wide() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_round_18_action_width_wide_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_wifi_protected_setup 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_round_18_action_wifi_protected_setup_data[] PROGMEM = {
  0x48, 0x44, 0x55, 0x55, 0x14, 0x0D, 0xB0, 0x93, 0x81, 0x40, 0xDB, 0x02, 0x28, 0x26, 0x80, 0xDB,
  0x0B, 0x28, 0x4E, 0x80, 0xDA, 0xEA, 0x86, 0x23, 0xFB, 0x07, 0x03, 0xA0, 0x04, 0xA8, 0x63, 0x07,
  0x0B, 0xF3, 0x2A, 0x84, 0xEA, 0xD0, 0x8E, 0x20, 0xCB, 0x82, 0xD0, 0x86, 0x20, 0x2B, 0x81, 0xD0,
  0x43, 0x09, 0xB0, 0xD4, 0x84, 0x15, 0x55, 0x54, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_wifi_protected_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_round_18_action_wifi_protected_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_work_history 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_round_18_action_work_history_data[] PROGMEM = {
  0x68, 0x22, 0x33, 0x27, 0x40, 0x7C, 0x07, 0x73, 0x84, 0xAA, 0x11, 0xAA, 0x68, 0x96, 0x47, 0x77,
  0xDC, 0x77, 0xCD, 0x77, 0x74, 0x01, 0xFF, 0x01, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xF9, 0x86,
  0xEA, 0x9A, 0xEF, 0x33, 0xF0, 0xA0, 0x14, 0x81, 0x83, 0x3E, 0x85, 0xA0, 0x5D, 0xFE, 0x72, 0x03,
  0xE0, 0x10, 0x4A, 0x0C, 0xA8, 0x17, 0x03, 0xD8, 0x1C, 0x0C, 0xA0, 0x20, 0xEA, 0x10, 0x3D, 0x81,
  0xA0, 0xEA, 0x03, 0x0B, 0xA8, 0x12, 0x1E, 0xC8, 0x1C, 0x0C, 0xA8, 0x1D, 0x2E, 0x92, 0x01, 0x80,
  0x13, 0x10, 0x4D, 0x07, 0x73, 0x83, 0x5D, 0xFE, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_work_history() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_work_history_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_work_off 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_round_18_action_work_off_data[] PROGMEM = {
  0x68, 0x22, 0x33, 0x26, 0x05, 0x06, 0x30, 0x7C, 0x07, 0x58, 0x15, 0xF7, 0x28, 0x4A, 0xA1, 0x1A,
  0xA6, 0x89, 0x69, 0xF7, 0x07, 0xC7, 0x7C, 0xD7, 0x77, 0x40, 0x1B, 0x81, 0x70, 0x9F, 0x90, 0x10,
  0x3C, 0x81, 0x70, 0x9F, 0x00, 0x3D, 0x81, 0x70, 0x9E, 0x00, 0x3E, 0x81, 0x70, 0x9D, 0x00, 0x3F,
  0x81, 0x70, 0x9C, 0x00, 0x3F, 0x98, 0x17, 0x09, 0xB0, 0x03, 0xFA, 0x81, 0x70, 0x9A, 0x00, 0x3F,
  0xB8, 0x47, 0x09, 0xF3, 0x3F, 0xC8, 0x47, 0x09, 0x31, 0xEF, 0xC0, 0x73, 0x01, 0x80, 0x63, 0x81,
  0x7F, 0x67, 0x70, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_work_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_round_18_action_work_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_work_outline 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_round_18_action_work_outline_data[] PROGMEM = {
  0x58, 0x42, 0x77, 0x77, 0x27, 0x30, 0xDC, 0x0D, 0x73, 0x90, 0x72, 0x07, 0x96, 0x89, 0x65, 0x77,
  0x7F, 0xB7, 0x7B, 0xF7, 0x77, 0x50, 0x5F, 0xF8, 0x25, 0x7F, 0x27, 0x38, 0x22, 0xF7, 0x79, 0x75,
  0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07,
  0x97, 0x59, 0x00, 0x79, 0x75, 0x98, 0x27, 0x6F, 0xD8, 0x06, 0xB8, 0x3D, 0xF6, 0x09, 0x80, 0x90,
  0xB0, 0x91,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_work_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_work_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_work 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_round_18_action_work_data[] PROGMEM = {
  0x68, 0x22, 0x33, 0x27, 0x40, 0x7C, 0x07, 0x73, 0x84, 0xAA, 0x11, 0xAA, 0x68, 0x96, 0x47, 0x77,
  0xDC, 0x77, 0xCD, 0x77, 0x74, 0x01, 0xFF, 0x01, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00,
  0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xF8, 0x13, 0x1E, 0xFD, 0x82,
  0xE1, 0x01, 0x80, 0x90, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_work() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_round_18_action_work_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_wysiwyg 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_round_18_action_wysiwyg_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x81, 0xA2, 0xAF, 0xD0, 0xA0, 0xBF, 0xD8, 0x1B, 0xBC, 0x80, 0x63, 0x0C,
  0x0F, 0xB7, 0x38, 0x00, 0xB1, 0x03, 0x80, 0x27, 0x86, 0x30, 0xBB, 0xBB, 0x08, 0xE0, 0x81, 0x80,
  0x0B, 0x73, 0x80, 0x0B, 0x18, 0x33, 0x77, 0x73, 0x48, 0x00, 0xB1, 0x08, 0xB0, 0x84, 0x80, 0x0B,
  0x73, 0x80, 0x0B, 0x73, 0x82, 0xBB, 0xAE, 0x80, 0x6B, 0x82, 0xEA, 0x2A, 0x80, 0x6B, 0x0A, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_wysiwyg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_round_18_action_wysiwyg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_youtube_searched_for 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_round_18_action_youtube_searched_for_data[] PROGMEM = {
  0x50, 0x03, 0x73, 0x06, 0x0E, 0xB0, 0x87, 0x86, 0x7F, 0x82, 0x16, 0xEA, 0x58, 0x11, 0xE8, 0x48,
  0x14, 0xF3, 0x48, 0x14, 0xF1, 0x50, 0xD0, 0x83, 0x83, 0x5D, 0xFB, 0x14, 0x0D, 0x08, 0x38, 0x21,
  0xCF, 0x94, 0x81, 0x2F, 0x54, 0x01, 0x06, 0x48, 0x11, 0xBD, 0x71, 0x85, 0xAB, 0xBE, 0xEF, 0x57,
  0x86, 0x49, 0x96, 0x08, 0xF5, 0x75, 0x81, 0x8F, 0x57, 0x58, 0x18, 0xF5, 0x75, 0x08, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_youtube_searched_for() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_round_18_action_youtube_searched_for_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_zoom_in 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_round_18_action_zoom_in_data[] PROGMEM = {
  0x48, 0x13, 0x31, 0x71, 0x05, 0x0E, 0xB0, 0x96, 0x86, 0x5F, 0x92, 0x16, 0xEB, 0x58, 0x7D, 0x90,
  0x48, 0x03, 0xF5, 0x38, 0x90, 0x3F, 0x34, 0xBE, 0x60, 0xC9, 0x38, 0x90, 0x3F, 0x19, 0xEF, 0xC1,
  0xBA, 0x38, 0x41, 0xF6, 0x06, 0xC2, 0x0E, 0x07, 0x48, 0x79, 0xE3, 0x01, 0x0A, 0xE1, 0x58, 0x6B,
  0xFC, 0xAE, 0xEF, 0x76, 0x86, 0x49, 0xA7, 0x16, 0xF7, 0x74, 0x81, 0x6F, 0x77, 0x48, 0x16, 0xF7,
  0x74, 0x06, 0x0D,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_zoom_in() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_zoom_in_data, Alpha4(color::Black));
  return value;
}

// Image file ic_round_18_action_zoom_out 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_round_18_action_zoom_out_data[] PROGMEM = {
  0x48, 0x13, 0x31, 0x71, 0x05, 0x0E, 0xB0, 0x96, 0x86, 0x5F, 0x92, 0x16, 0xEB, 0x50, 0xD0, 0x94,
  0x81, 0x3F, 0x53, 0x89, 0x03, 0xF3, 0x27, 0x75, 0x0C, 0x93, 0x89, 0x03, 0xF1, 0x5D, 0xDB, 0x0B,
  0xA3, 0x81, 0x1F, 0x65, 0x0E, 0x07, 0x48, 0x19, 0xE3, 0x38, 0x1A, 0xE1, 0x58, 0x6B, 0xFC, 0xAE,
  0xEF, 0x76, 0x86, 0x49, 0xA7, 0x16, 0xF7, 0x74, 0x81, 0x6F, 0x77, 0x48, 0x16, 0xF7, 0x74, 0x06,
  0x0D,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_round_18_action_zoom_out() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 14, 14), Box(0, 0, 17, 17),
      ic_round_18_action_zoom_out_data, Alpha4(color::Black));
  return value;
}
