#include "maps.h"

using namespace roo_display;

// Image file ic_outlined_48_maps_360 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_outlined_48_maps_360_data[] PROGMEM = {
  0x75, 0x82, 0x36, 0x8B, 0x0F, 0xDA, 0x0F, 0xD8, 0x2B, 0x86, 0x37, 0x76, 0x81, 0x27, 0xBF, 0xFC,
  0x81, 0xB7, 0x27, 0x70, 0x50, 0xBF, 0xFF, 0xB0, 0xB0, 0x57, 0x30, 0x30, 0xCF, 0xFF, 0xF0, 0xC0,
  0x37, 0x09, 0xF9, 0x85, 0xD9, 0x74, 0x21, 0x12, 0x85, 0x11, 0x24, 0x79, 0xDF, 0x90, 0x95, 0x0B,
  0xE8, 0x1B, 0x51, 0x77, 0x28, 0x11, 0x5B, 0xE0, 0xB3, 0x0A, 0xD0, 0x90, 0x27, 0x77, 0x10, 0x20,
  0x9D, 0x81, 0xA0, 0x4C, 0x0C, 0x02, 0x77, 0x75, 0x02, 0x0C, 0xC0, 0x40, 0xAB, 0x0C, 0x77, 0x77,
  0x20, 0xCB, 0x0A, 0x0D, 0xB0, 0x27, 0x77, 0x72, 0x02, 0xB0, 0xD0, 0xEB, 0x02, 0x72, 0x07, 0x77,
  0x60, 0x2B, 0x0E, 0x0B, 0xB0, 0xB7, 0x29, 0x07, 0x77, 0x50, 0xBB, 0x0B, 0x04, 0xC0, 0xC0, 0x27,
  0xA0, 0x77, 0x72, 0x02, 0x0C, 0xC8, 0x15, 0x0A, 0xD0, 0x90, 0x25, 0xB0, 0x77, 0x60, 0x20, 0x9D,
  0x0A, 0x30, 0xBE, 0x81, 0xB6, 0x12, 0xC0, 0x77, 0x28, 0x11, 0x5B, 0xE0, 0xB5, 0x09, 0xF9, 0x0D,
  0x0A, 0xD0, 0x77, 0x1F, 0x90, 0x97, 0x04, 0x0D, 0xFF, 0x07, 0x7E, 0x0D, 0x04, 0x73, 0x05, 0x0B,
  0xFE, 0x07, 0x6C, 0x0C, 0x05, 0x77, 0x81, 0x27, 0xBF, 0xB0, 0x76, 0x98, 0x1B, 0x72, 0x77, 0x60,
  0x30, 0x6E, 0x07, 0x77, 0x77, 0x5D, 0x07, 0x77, 0x77, 0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80,
  0xC0, 0x0A, 0x07, 0x80, 0xC1, 0x09, 0x07, 0x80, 0xC2, 0x00, 0x77, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_360() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 14, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_360_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_add_business 48x48, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_outlined_48_maps_add_business_data[] PROGMEM = {
  0x2F, 0xFF, 0xFA, 0x77, 0xFF, 0xFF, 0xA7, 0x7F, 0xFF, 0xFA, 0x77, 0xFF, 0xFF, 0xA8, 0x09, 0xC1,
  0x00, 0x1F, 0xFF, 0xFA, 0x01, 0x75, 0x04, 0xFF, 0xFF, 0xA0, 0x47, 0x50, 0x7F, 0xFF, 0xFA, 0x07,
  0x75, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x50, 0xDB, 0x02, 0x77, 0x71, 0x02, 0xB0, 0xD7, 0x40, 0x1B,
  0x0E, 0x77, 0x73, 0x0E, 0xB0, 0x17, 0x30, 0x4B, 0x0C, 0x77, 0x73, 0x0C, 0xB0, 0x47, 0x30, 0x7B,
  0x09, 0x77, 0x73, 0x09, 0xB0, 0x77, 0x30, 0xAB, 0x05, 0x77, 0x73, 0x05, 0xB0, 0xA7, 0x30, 0xDB,
  0x02, 0x77, 0x73, 0x02, 0xB0, 0xD7, 0x3F, 0xFF, 0xFE, 0x73, 0xFF, 0xFF, 0xE7, 0x3F, 0xFF, 0xFE,
  0x73, 0xFF, 0xFF, 0xE7, 0x5C, 0x73, 0xC7, 0x1C, 0x77, 0xC7, 0x3C, 0x71, 0xC7, 0x7C, 0x73, 0xC7,
  0x1C, 0x2C, 0x71, 0xC7, 0x3C, 0x71, 0xC2, 0xC7, 0x1C, 0x73, 0xC7, 0x1C, 0x2C, 0x71, 0xC7, 0x3C,
  0x71, 0xC2, 0xC7, 0x1C, 0x73, 0xC7, 0x7C, 0x71, 0xC7, 0x3C, 0x77, 0xC7, 0x1F, 0xFC, 0x71, 0xFF,
  0xA2, 0xFF, 0xC7, 0x1F, 0xFA, 0x2F, 0xFC, 0x71, 0xFF, 0xA2, 0xFF, 0xC7, 0x1F, 0xFA, 0x77, 0x77,
  0x6C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_add_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_add_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_add_location_alt 48x48, 4-bit Alpha,  RLE, 306 bytes.
static const unsigned char ic_outlined_48_maps_add_location_alt_data[] PROGMEM = {
  0x77, 0x77, 0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76, 0xC7, 0x73, 0x85, 0x49, 0xBD,
  0xEF, 0xD7, 0x3C, 0x77, 0x81, 0x19, 0xEF, 0x73, 0xC7, 0x60, 0x8F, 0xB4, 0xFF, 0xA5, 0x01, 0x0C,
  0xFC, 0x4F, 0xFA, 0x40, 0x30, 0xED, 0x82, 0xD8, 0x42, 0x20, 0x14, 0xFF, 0xA3, 0x01, 0x0E, 0xC0,
  0xD0, 0x57, 0x4F, 0xFA, 0x30, 0xCC, 0x09, 0x77, 0x5C, 0x71, 0x07, 0xC0, 0x77, 0x76, 0xC7, 0x01,
  0x0E, 0xB0, 0xA7, 0x77, 0xC7, 0x09, 0xB0, 0xD7, 0x77, 0x1C, 0x70, 0xEB, 0x06, 0x77, 0x71, 0xC6,
  0x03, 0xB0, 0xD7, 0x77, 0x2C, 0x60, 0x8B, 0x09, 0x71, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x50, 0xBB,
  0x05, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x40, 0xCB, 0x02, 0x70, 0xAE, 0x0A, 0x77, 0x40, 0xEB,
  0x01, 0x70, 0xDE, 0x0D, 0x77, 0x4C, 0x71, 0x0D, 0xE0, 0xD7, 0x1C, 0x60, 0xDB, 0x01, 0x70, 0xAE,
  0x0A, 0x70, 0x1B, 0x0D, 0x60, 0xCB, 0x04, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x70, 0x4B, 0x0C, 0x60,
  0x9B, 0x08, 0x71, 0x84, 0x1A, 0xDD, 0xA1, 0x71, 0x08, 0xB0, 0x96, 0x04, 0xB0, 0xD7, 0x77, 0x10,
  0xDB, 0x04, 0x70, 0xEB, 0x04, 0x77, 0x60, 0x4B, 0x0E, 0x71, 0x09, 0xB0, 0xC7, 0x76, 0x0C, 0xB0,
  0x97, 0x10, 0x2C, 0x05, 0x77, 0x40, 0x5C, 0x02, 0x72, 0x0A, 0xB0, 0xD0, 0x17, 0x72, 0x01, 0x0D,
  0xB0, 0xA7, 0x30, 0x10, 0xEB, 0x0A, 0x77, 0x20, 0xAB, 0x0E, 0x01, 0x74, 0x07, 0xC0, 0x57, 0x70,
  0x5C, 0x07, 0x76, 0x0C, 0xB0, 0xE0, 0x37, 0x50, 0x30, 0xEB, 0x0C, 0x77, 0x02, 0x0E, 0xB0, 0xD0,
  0x17, 0x30, 0x10, 0xDB, 0x0E, 0x02, 0x77, 0x10, 0x5C, 0x0C, 0x73, 0x0C, 0xC0, 0x57, 0x73, 0x08,
  0xC0, 0xB7, 0x10, 0xBC, 0x08, 0x77, 0x50, 0xAC, 0x0A, 0x60, 0xAC, 0x0A, 0x77, 0x70, 0xBC, 0x0A,
  0x40, 0xAC, 0x0B, 0x77, 0x71, 0x01, 0x0C, 0xC0, 0xB2, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x20, 0x10,
  0xCC, 0x00, 0xBC, 0x0C, 0x01, 0x77, 0x74, 0x01, 0x0C, 0xF9, 0x0C, 0x01, 0x77, 0x76, 0x01, 0x0C,
  0xE0, 0xC0, 0x17, 0x77, 0x72, 0x0B, 0xC0, 0xB7, 0x77, 0x75, 0x0A, 0xA0, 0xA7, 0x77, 0x77, 0x00,
  0x87, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_add_location_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_add_location_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_add_location 48x48, 4-bit Alpha,  RLE, 298 bytes.
static const unsigned char ic_outlined_48_maps_add_location_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x10, 0x8F, 0xFA, 0x08, 0x75, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x30, 0xED, 0x82, 0xD8,
  0x42, 0x28, 0x22, 0x48, 0xDD, 0x0E, 0x03, 0x70, 0x10, 0xEC, 0x0D, 0x05, 0x73, 0x05, 0x0D, 0xC0,
  0xE0, 0x16, 0x0C, 0xC0, 0x97, 0x70, 0x9C, 0x0C, 0x50, 0x7C, 0x07, 0x77, 0x20, 0x7C, 0x07, 0x30,
  0x10, 0xEB, 0x0A, 0x7C, 0x70, 0xAB, 0x0E, 0x01, 0x20, 0x9B, 0x0D, 0x71, 0xC7, 0x10, 0xDB, 0x09,
  0x20, 0xEB, 0x06, 0x71, 0xC7, 0x10, 0x6B, 0x81, 0xE0, 0x3B, 0x0D, 0x72, 0xC7, 0x20, 0xDB, 0x03,
  0x08, 0xB0, 0x97, 0x2C, 0x72, 0x09, 0xB0, 0x80, 0xBB, 0x05, 0x72, 0xC7, 0x20, 0x5B, 0x0B, 0x0C,
  0xB0, 0x23, 0xFF, 0xA3, 0x02, 0xB0, 0xD0, 0xEB, 0x01, 0x3F, 0xFA, 0x30, 0x1B, 0x0E, 0xC4, 0xFF,
  0xA4, 0xC0, 0xDB, 0x01, 0x3F, 0xFA, 0x30, 0x1B, 0x0D, 0x0C, 0xB0, 0x47, 0x2C, 0x72, 0x04, 0xB0,
  0xC0, 0x9B, 0x08, 0x72, 0xC7, 0x20, 0x8B, 0x09, 0x04, 0xB0, 0xD7, 0x2C, 0x72, 0x0D, 0xB8, 0x14,
  0x0E, 0xB0, 0x47, 0x1C, 0x71, 0x04, 0xB0, 0xE2, 0x09, 0xB0, 0xC7, 0x1C, 0x71, 0x0C, 0xB0, 0x92,
  0x02, 0xC0, 0x57, 0xC7, 0x05, 0xC0, 0x23, 0x0A, 0xB0, 0xD0, 0x17, 0x72, 0x01, 0x0D, 0xB0, 0xA4,
  0x01, 0x0E, 0xB0, 0xA7, 0x72, 0x0A, 0xB0, 0xE0, 0x15, 0x07, 0xC0, 0x57, 0x70, 0x5C, 0x07, 0x70,
  0xCB, 0x0E, 0x03, 0x75, 0x03, 0x0E, 0xB0, 0xC7, 0x10, 0x20, 0xEB, 0x0D, 0x01, 0x73, 0x01, 0x0D,
  0xB0, 0xE0, 0x27, 0x20, 0x5C, 0x0C, 0x73, 0x0C, 0xC0, 0x57, 0x40, 0x8C, 0x0B, 0x71, 0x0B, 0xC0,
  0x87, 0x60, 0xAC, 0x0A, 0x60, 0xAC, 0x0A, 0x77, 0x10, 0xBC, 0x0A, 0x40, 0xAC, 0x0B, 0x77, 0x20,
  0x10, 0xCC, 0x0B, 0x20, 0xBC, 0x0C, 0x01, 0x77, 0x30, 0x10, 0xCC, 0x00, 0xBC, 0x0C, 0x01, 0x77,
  0x50, 0x10, 0xCF, 0x90, 0xC0, 0x17, 0x77, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x30, 0xBC, 0x0B,
  0x77, 0x76, 0x0A, 0xA0, 0xA7, 0x77, 0x71, 0x00, 0x87, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_add_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_add_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_add_road 48x48, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_outlined_48_maps_add_road_data[] PROGMEM = {
  0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6,
  0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6,
  0xC7, 0x77, 0x3C, 0x6C, 0x77, 0x73, 0xC6, 0xC7, 0x77, 0x3C, 0x6C, 0x77, 0x73, 0xC6, 0xC7, 0x3C,
  0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C,
  0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x77, 0x6C, 0x73, 0xC7, 0x76, 0xC7, 0x77, 0x76,
  0xC7, 0x77, 0x76, 0xC7, 0x77, 0x3C, 0x6C, 0x77, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C,
  0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x73, 0xC6, 0xC7, 0x3C, 0x4F, 0xFE, 0x73, 0xC4,
  0xFF, 0xE7, 0x3C, 0x4F, 0xFE, 0x73, 0xC4, 0xFF, 0xA7, 0x77, 0x7C, 0x77, 0x77, 0x6C, 0x77, 0x77,
  0x6C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_add_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_add_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_agriculture 48x48, 4-bit Alpha,  RLE, 326 bytes.
static const unsigned char ic_outlined_48_maps_agriculture_data[] PROGMEM = {
  0x77, 0x73, 0x02, 0x80, 0xC6, 0x08, 0x13, 0xE8, 0x80, 0xC4, 0x08, 0x23, 0xEF, 0xA8, 0x0C, 0x30,
  0x82, 0x3E, 0xFA, 0x80, 0xC3, 0x08, 0x23, 0xEF, 0xA8, 0x0C, 0x30, 0x03, 0x0E, 0xA0, 0xC0, 0x18,
  0x0C, 0x10, 0x86, 0x3E, 0xFA, 0xCF, 0xC1, 0x77, 0x77, 0x78, 0x52, 0xEF, 0xA0, 0x1C, 0xFF, 0x81,
  0xDA, 0x17, 0x77, 0x08, 0x0A, 0x30, 0x1F, 0xFA, 0x0E, 0x01, 0x60, 0x40, 0xDE, 0x81, 0xDA, 0x17,
  0x2F, 0xFB, 0x0A, 0x60, 0xDF, 0xA0, 0xE0, 0x17, 0x1F, 0xFB, 0x0D, 0x60, 0xDF, 0xB0, 0xA7, 0x1C,
  0x73, 0xC6, 0x04, 0x0D, 0xFA, 0x0D, 0x71, 0xC7, 0x3C, 0x77, 0x74, 0x01, 0xB0, 0xE7, 0x3C, 0x77,
  0x74, 0x05, 0xB0, 0xC7, 0x3C, 0x72, 0x85, 0x9D, 0xEE, 0xD9, 0x37, 0x10, 0x10, 0xDB, 0x08, 0x73,
  0xC6, 0x82, 0x4D, 0x3A, 0xD8, 0x14, 0x74, 0x48, 0x11, 0x5D, 0xC0, 0x27, 0x3C, 0x50, 0x8A, 0x00,
  0xBC, 0x0E, 0x04, 0xFD, 0x09, 0x74, 0xC4, 0x08, 0xFF, 0xF9, 0x0B, 0x75, 0xC3, 0x04, 0xD0, 0x80,
  0x32, 0x03, 0x08, 0xFC, 0x09, 0x76, 0xC3, 0x07, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xD8, 0x2E, 0xC8,
  0x27, 0x7C, 0x28, 0x13, 0x44, 0xA0, 0x27, 0x10, 0x2A, 0x0B, 0x03, 0x77, 0x83, 0x17, 0xCE, 0xEC,
  0x28, 0x39, 0xFE, 0xF8, 0x73, 0x83, 0x8F, 0xBA, 0x97, 0x50, 0x40, 0xEF, 0x92, 0x0D, 0xB0, 0x37,
  0x30, 0x3F, 0xFF, 0xD8, 0x14, 0x0E, 0xB7, 0x5F, 0xFF, 0xD8, 0x1E, 0x1E, 0xB7, 0x5F, 0xFD, 0x82,
  0x71, 0x17, 0xC0, 0x70, 0xDB, 0x03, 0x73, 0x03, 0xFF, 0xC0, 0x74, 0x07, 0xB8, 0x4C, 0x9A, 0xBF,
  0x87, 0x38, 0x38, 0xFE, 0xF9, 0x73, 0x0E, 0xB0, 0x14, 0x01, 0xB8, 0x2E, 0x03, 0xBA, 0x02, 0x71,
  0x02, 0xA8, 0x14, 0x43, 0x73, 0x0E, 0xB0, 0x14, 0x01, 0xB8, 0x1E, 0x0D, 0xB0, 0xD0, 0x26, 0x02,
  0x0D, 0xB0, 0x77, 0x40, 0xCB, 0x07, 0x40, 0x7B, 0x81, 0xC0, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D,
  0x04, 0x74, 0x07, 0xC8, 0x27, 0x11, 0x7C, 0x07, 0x20, 0x8F, 0xF0, 0x87, 0x50, 0x10, 0xEF, 0xB0,
  0xE0, 0x13, 0x08, 0xA0, 0x40, 0xEC, 0x00, 0xBA, 0x08, 0x77, 0x05, 0xFB, 0x05, 0x58, 0x14, 0x74,
  0xD8, 0x2A, 0x3D, 0x47, 0x72, 0x05, 0x0E, 0xE0, 0xE0, 0x57, 0x18, 0x53, 0x9D, 0xEE, 0xD9, 0x77,
  0x68, 0x61, 0x7C, 0xEE, 0xC7, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_agriculture() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 45, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_agriculture_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_airlines 48x48, 4-bit Alpha,  RLE, 255 bytes.
static const unsigned char ic_outlined_48_maps_airlines_data[] PROGMEM = {
  0x77, 0x70, 0x5F, 0xFB, 0x0E, 0x77, 0x60, 0x10, 0xEF, 0xFB, 0x0B, 0x77, 0x60, 0xBF, 0xFC, 0x08,
  0x77, 0x50, 0x6F, 0xFD, 0x05, 0x77, 0x40, 0x20, 0xEB, 0x0B, 0x74, 0x0E, 0xB0, 0x27, 0x74, 0x0B,
  0xB0, 0xE0, 0x17, 0x30, 0x1B, 0x0E, 0x77, 0x40, 0x7C, 0x05, 0x74, 0x04, 0xB0, 0xC7, 0x73, 0x02,
  0xC0, 0xA7, 0x50, 0x7B, 0x09, 0x77, 0x30, 0xCB, 0x0E, 0x01, 0x75, 0x0A, 0xB0, 0x67, 0x72, 0x08,
  0xC0, 0x47, 0x60, 0xDB, 0x03, 0x77, 0x10, 0x3C, 0x09, 0x28, 0x44, 0xBE, 0xEB, 0x46, 0xC7, 0x72,
  0x0D, 0xB0, 0xD2, 0x08, 0xE0, 0x84, 0x03, 0xB0, 0xD7, 0x71, 0x09, 0xC8, 0x14, 0x04, 0xF9, 0x04,
  0x30, 0x6B, 0x0A, 0x77, 0x04, 0xC0, 0x82, 0x0B, 0xF9, 0x0B, 0x30, 0x9B, 0x07, 0x76, 0x01, 0x0D,
  0xB0, 0xD3, 0x0E, 0xF9, 0x0E, 0x30, 0xCB, 0x04, 0x76, 0x0A, 0xC0, 0x33, 0x0E, 0xF9, 0x0E, 0x30,
  0xEB, 0x01, 0x75, 0x05, 0xC0, 0x74, 0x0B, 0xF9, 0x0B, 0x20, 0x2B, 0x0E, 0x75, 0x01, 0x0E, 0xB0,
  0xC5, 0x04, 0xF9, 0x04, 0x20, 0x5B, 0x0B, 0x75, 0x0B, 0xC0, 0x26, 0x08, 0xE0, 0x83, 0x08, 0xB0,
  0x87, 0x40, 0x6C, 0x06, 0x71, 0x84, 0x4B, 0xEE, 0xB4, 0x40, 0xBB, 0x05, 0x73, 0x02, 0x0E, 0xB0,
  0xB7, 0x75, 0x0E, 0xB0, 0x27, 0x30, 0xBB, 0x0E, 0x01, 0x77, 0x40, 0x1B, 0x0E, 0x73, 0x07, 0xC0,
  0x57, 0x75, 0x04, 0xB0, 0xC7, 0x20, 0x2C, 0x0A, 0x77, 0x60, 0x7B, 0x09, 0x72, 0x0C, 0xB0, 0xE0,
  0x17, 0x76, 0x0A, 0xB0, 0x67, 0x10, 0x8C, 0x04, 0x77, 0x70, 0xDB, 0x03, 0x70, 0x3C, 0x09, 0x77,
  0x71, 0xC7, 0x10, 0xDB, 0x0D, 0x77, 0x71, 0x03, 0xB0, 0xD7, 0x09, 0xFF, 0xFF, 0xB0, 0xA6, 0x04,
  0xFF, 0xFF, 0xC0, 0x75, 0x01, 0x0D, 0xFF, 0xFF, 0xC0, 0x45, 0x0A, 0xFF, 0xFF, 0xD0, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_airlines() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_airlines_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_airline_stops 48x48, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_outlined_48_maps_airline_stops_data[] PROGMEM = {
  0x77, 0x73, 0xFF, 0x77, 0x73, 0xFF, 0x77, 0x73, 0xFF, 0x77, 0x73, 0xFF, 0x98, 0x3D, 0xCA, 0x74,
  0x77, 0x73, 0x01, 0x0B, 0xFD, 0x81, 0xEA, 0x47, 0x76, 0x05, 0x0E, 0xFF, 0xA0, 0xD0, 0x47, 0x73,
  0x09, 0xFF, 0xE0, 0xB0, 0x27, 0x60, 0x10, 0xBD, 0x0B, 0xC1, 0x83, 0x13, 0x59, 0xEE, 0x0E, 0x05,
  0x74, 0x02, 0x0D, 0xC0, 0xE0, 0x51, 0xC6, 0x03, 0x0A, 0xE0, 0x97, 0x20, 0x20, 0xDC, 0x0C, 0x02,
  0x2C, 0x71, 0x02, 0x0B, 0xD0, 0x97, 0x01, 0x0D, 0xC0, 0xA4, 0xC7, 0x30, 0x6D, 0x09, 0x60, 0xBC,
  0x09, 0x5C, 0x74, 0x03, 0x0D, 0xC0, 0x64, 0x08, 0xC0, 0xA6, 0xC7, 0x50, 0x20, 0xEC, 0x03, 0x20,
  0x3C, 0x0B, 0x7C, 0x76, 0x03, 0x0E, 0xB0, 0xC2, 0x0D, 0xB0, 0xD0, 0x17, 0x77, 0x40, 0x5C, 0x05,
  0x06, 0xC0, 0x37, 0x77, 0x60, 0xBB, 0x00, 0xDB, 0x09, 0x77, 0x77, 0x01, 0x0E, 0xE0, 0xE0, 0x17,
  0x77, 0x71, 0x09, 0xE0, 0x87, 0x77, 0x72, 0x02, 0xE0, 0x27, 0x77, 0x73, 0x0C, 0xC0, 0xC7, 0x77,
  0x74, 0x08, 0xC0, 0x77, 0x77, 0x74, 0x04, 0xC0, 0x47, 0x77, 0x74, 0x01, 0xC0, 0x17, 0x77, 0x71,
  0xFD, 0x77, 0x75, 0xFD, 0x77, 0x75, 0xFD, 0x77, 0x75, 0xFD, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_airline_stops() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 41, 37), Box(0, 0, 47, 47),
      ic_outlined_48_maps_airline_stops_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_alt_route 48x48, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_outlined_48_maps_alt_route_data[] PROGMEM = {
  0x70, 0x07, 0x77, 0x40, 0x07, 0x76, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x40, 0x7C, 0x07,
  0x77, 0x07, 0xC0, 0x77, 0x20, 0x7E, 0x07, 0x75, 0x07, 0xE0, 0x77, 0x07, 0xF9, 0x07, 0x73, 0x07,
  0xF9, 0x07, 0x50, 0x7F, 0xB0, 0x77, 0x10, 0x7F, 0xB0, 0x73, 0x07, 0xFD, 0x07, 0x60, 0x7F, 0xD8,
  0x17, 0x07, 0xFF, 0x07, 0x40, 0x7F, 0xF0, 0x76, 0x0E, 0xB0, 0x17, 0x71, 0xB0, 0xE7, 0x50, 0xDB,
  0x01, 0x77, 0x01, 0xB0, 0xD7, 0x50, 0xCB, 0x03, 0x77, 0x03, 0xB0, 0xC7, 0x58, 0x3A, 0xFC, 0x81,
  0x77, 0x05, 0xB0, 0xA7, 0x50, 0x20, 0x17, 0x73, 0x08, 0xB0, 0x77, 0x77, 0x73, 0x0C, 0xB0, 0x57,
  0x78, 0x21, 0x48, 0x17, 0x50, 0x1C, 0x01, 0x76, 0x09, 0xB0, 0x87, 0x50, 0x8B, 0x0B, 0x77, 0x05,
  0xC0, 0x27, 0x30, 0x2C, 0x05, 0x77, 0x10, 0xDB, 0x0C, 0x73, 0x0C, 0xB0, 0xD7, 0x72, 0x05, 0xC0,
  0x47, 0x10, 0xBC, 0x05, 0x77, 0x30, 0xAA, 0x05, 0x71, 0x0B, 0xC0, 0xA7, 0x75, 0x0C, 0x05, 0x30,
  0x40, 0x12, 0x01, 0x0C, 0xC0, 0xC7, 0x77, 0x38, 0x15, 0xFC, 0x20, 0xCC, 0x0C, 0x01, 0x77, 0x72,
  0x05, 0xB0, 0x0A, 0xC0, 0xB7, 0x77, 0x40, 0xBF, 0x90, 0xB7, 0x77, 0x60, 0xCE, 0x0C, 0x77, 0x77,
  0x02, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x71, 0x08, 0xC0, 0x87, 0x77, 0x72, 0x04, 0xC0, 0x47, 0x77,
  0x72, 0x01, 0xC0, 0x17, 0x77, 0x73, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7,
  0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77,
  0x74, 0xC7, 0x77, 0x74, 0xC7, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_alt_route() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_alt_route_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_atm 48x48, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_outlined_48_maps_atm_data[] PROGMEM = {
  0x04, 0x0D, 0xE0, 0xD0, 0x42, 0xFD, 0x30, 0x40, 0xDF, 0xA8, 0x1D, 0x4D, 0xF9, 0x0D, 0x2F, 0xD3,
  0x0D, 0xFC, 0x0D, 0xFB, 0x2F, 0xD3, 0xFF, 0xA4, 0xB6, 0x07, 0xA0, 0x77, 0xB2, 0xB2, 0xE4, 0xB6,
  0x07, 0xA0, 0x77, 0xB2, 0xB2, 0xE4, 0xB6, 0x07, 0xA0, 0x77, 0xB2, 0xB2, 0xFE, 0x60, 0x7A, 0x07,
  0x7B, 0x2B, 0x2F, 0xE6, 0x07, 0xA0, 0x77, 0xB2, 0xB2, 0xFE, 0x60, 0x7A, 0x07, 0x7B, 0x2B, 0x2E,
  0x4B, 0x60, 0x7A, 0x07, 0x7B, 0x2B, 0x2E, 0x4B, 0x60, 0x7A, 0x07, 0x7B, 0x7E, 0x4B, 0x60, 0x7A,
  0x07, 0x7B, 0x7B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_atm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 18, 43, 29), Box(0, 0, 47, 47),
      ic_outlined_48_maps_atm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_attractions 48x48, 4-bit Alpha,  RLE, 401 bytes.
static const unsigned char ic_outlined_48_maps_attractions_data[] PROGMEM = {
  0x77, 0x18, 0x41, 0xAE, 0xEA, 0x17, 0x77, 0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x70, 0x9E,
  0x0A, 0x77, 0x75, 0x81, 0x15, 0xEE, 0x81, 0xE5, 0x17, 0x77, 0x10, 0x30, 0xAF, 0xD0, 0xA0, 0x37,
  0x74, 0x01, 0x0A, 0xFF, 0xA0, 0xA0, 0x17, 0x71, 0x05, 0x0E, 0xB8, 0x2A, 0x52, 0xEC, 0x82, 0xE2,
  0x5B, 0xB0, 0xE0, 0x57, 0x60, 0x7B, 0x0B, 0x02, 0x38, 0x42, 0xAE, 0xEA, 0x23, 0x03, 0x0B, 0xB0,
  0x77, 0x83, 0x19, 0xDE, 0xCB, 0x06, 0x77, 0x20, 0x7B, 0x83, 0xCE, 0xD9, 0x12, 0x0C, 0xD0, 0xE0,
  0x47, 0x74, 0x05, 0xE8, 0x1C, 0x07, 0xE0, 0xC7, 0x76, 0x0C, 0xE0, 0x70, 0xCF, 0x01, 0x77, 0x40,
  0x1F, 0x00, 0xCF, 0x01, 0x77, 0x40, 0x1F, 0x0C, 0x07, 0xE0, 0xC7, 0x84, 0x48, 0xBB, 0x84, 0x70,
  0xCE, 0x81, 0x71, 0xCD, 0x04, 0x50, 0x20, 0xCE, 0x0C, 0x02, 0x50, 0x3D, 0x82, 0xC1, 0x06, 0xB0,
  0xB0, 0x35, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x58, 0x13, 0xBE, 0xA0, 0x62, 0x09, 0xA0, 0x37, 0x0D,
  0xFB, 0x0C, 0x70, 0x4A, 0x09, 0x20, 0xCA, 0x70, 0x6C, 0x82, 0x72, 0x28, 0xC0, 0x56, 0x01, 0xA0,
  0xC2, 0x81, 0xDF, 0xD7, 0x0B, 0xB0, 0x64, 0x08, 0xB0, 0xA7, 0xA0, 0xD2, 0x81, 0xEF, 0xD7, 0x0D,
  0xB0, 0x14, 0x02, 0xB0, 0xD7, 0x81, 0xEF, 0xE2, 0x81, 0xEF, 0xD7, 0x0D, 0xB5, 0x02, 0xB0, 0xD7,
  0x81, 0xEF, 0xE2, 0x81, 0xDF, 0xE7, 0x0B, 0xB0, 0x64, 0x07, 0xB0, 0xB7, 0xA0, 0xD2, 0x0C, 0xA0,
  0x16, 0x07, 0xB8, 0x3E, 0x60, 0x16, 0xC0, 0x66, 0x03, 0xA0, 0xC2, 0x09, 0xA0, 0x56, 0x01, 0x0E,
  0xFB, 0x0D, 0x70, 0x7A, 0x09, 0x20, 0x6A, 0x81, 0xEB, 0x35, 0x08, 0xFB, 0x07, 0x50, 0x30, 0xBB,
  0x82, 0x60, 0x1C, 0xD0, 0x34, 0x0E, 0xFB, 0x0C, 0x40, 0x3D, 0x81, 0xC1, 0x7E, 0x0C, 0x30, 0x6B,
  0x84, 0x9A, 0xCD, 0xAA, 0xB0, 0x43, 0x0C, 0xE0, 0x70, 0xCF, 0x01, 0x20, 0xDA, 0x0D, 0x60, 0xEA,
  0x0B, 0x20, 0x1F, 0x00, 0xCF, 0x81, 0x10, 0x4B, 0x06, 0x60, 0x8B, 0x81, 0x20, 0x1F, 0x0C, 0x07,
  0xE0, 0xD2, 0x0B, 0xA0, 0xE7, 0x01, 0xB8, 0x29, 0x01, 0xEE, 0x81, 0x70, 0xCE, 0x0B, 0x04, 0xB0,
  0x87, 0x10, 0xAB, 0x03, 0x0D, 0xE8, 0x6D, 0x10, 0x19, 0xDE, 0xCF, 0x01, 0x71, 0x03, 0xF8, 0x3C,
  0xED, 0x91, 0x70, 0x7D, 0x0B, 0x28, 0x42, 0xAE, 0xEA, 0x22, 0x0C, 0xD0, 0x77, 0x60, 0x50, 0xEC,
  0x81, 0xE9, 0xEC, 0x81, 0xE9, 0xEC, 0x0E, 0x05, 0x77, 0x10, 0xEF, 0xFC, 0x0D, 0x77, 0x10, 0x6B,
  0x0C, 0xFD, 0x0C, 0xB0, 0x57, 0x70, 0xDA, 0x0D, 0x20, 0x50, 0xEE, 0x0E, 0x05, 0x20, 0xEA, 0x0C,
  0x76, 0x05, 0xB0, 0x63, 0x09, 0xE0, 0x93, 0x08, 0xB0, 0x37, 0x50, 0xBA, 0x0E, 0x40, 0x10, 0xEC,
  0x0E, 0x01, 0x30, 0x1B, 0x0A, 0x74, 0x03, 0xB0, 0x85, 0x84, 0x1A, 0xEE, 0xA1, 0x50, 0x9B, 0x02,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_attractions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_attractions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_badge 48x48, 4-bit Alpha,  RLE, 217 bytes.
static const unsigned char ic_outlined_48_maps_badge_data[] PROGMEM = {
  0x77, 0x18, 0x11, 0xAD, 0xC8, 0x1D, 0xA1, 0x77, 0x77, 0x10, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x77,
  0x70, 0xAF, 0xB0, 0xA7, 0x77, 0x70, 0xDF, 0xB0, 0xD7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7,
  0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x71, 0x81,
  0x1A, 0xDF, 0xF4, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xA4, 0xFF, 0xA8, 0x1E, 0x1A, 0xFF, 0xB4,
  0xFF, 0xB0, 0xA0, 0xDF, 0xFB, 0x4F, 0xFB, 0x0D, 0xC7, 0x30, 0xDF, 0xB0, 0xD7, 0x3F, 0x97, 0x30,
  0xAF, 0xB0, 0xA7, 0x3F, 0x97, 0x30, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x3F, 0x97, 0x48, 0x11, 0xAD,
  0xC8, 0x1D, 0xA1, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x71, 0x82, 0x8D, 0xD8,
  0x71, 0xF9, 0x4F, 0x97, 0x08, 0xC0, 0x87, 0xF9, 0x4F, 0x97, 0x0D, 0xC0, 0xD7, 0xF9, 0x4F, 0x97,
  0x0D, 0xC0, 0xD7, 0x75, 0xF9, 0x70, 0x8C, 0x08, 0x77, 0x5F, 0x97, 0x18, 0x28, 0xDD, 0x87, 0x76,
  0xF9, 0x77, 0x6F, 0x94, 0xF9, 0x78, 0x42, 0x57, 0x75, 0x27, 0xF9, 0x4F, 0x95, 0x06, 0x0D, 0xE0,
  0xD0, 0x65, 0xF9, 0x4F, 0x94, 0x07, 0xFB, 0x07, 0x77, 0x2F, 0x94, 0x0D, 0xFB, 0x0D, 0x77, 0x2F,
  0x94, 0xFD, 0x77, 0x2F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4C, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84,
  0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_badge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_badge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_bakery_dining 48x48, 4-bit Alpha,  RLE, 325 bytes.
static const unsigned char ic_outlined_48_maps_bakery_dining_data[] PROGMEM = {
  0x77, 0x28, 0x12, 0x9E, 0xE8, 0x1E, 0x92, 0x77, 0x77, 0x30, 0x40, 0xEF, 0xB0, 0xE0, 0x47, 0x77,
  0x71, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x74, 0x82, 0x48, 0xAB, 0xFF, 0x82, 0xB9, 0x84, 0x77,
  0x58, 0x11, 0x7D, 0xF0, 0x86, 0x07, 0xF8, 0x1D, 0x71, 0x77, 0x01, 0x09, 0xFB, 0x05, 0x60, 0x4F,
  0xB0, 0x90, 0x17, 0x40, 0x20, 0xEF, 0xC0, 0x66, 0x06, 0xFC, 0x0E, 0x01, 0x73, 0x0C, 0xD8, 0x2E,
  0x95, 0xCB, 0x08, 0x60, 0x7B, 0x82, 0xC5, 0x9E, 0xD0, 0xC7, 0x20, 0x2C, 0x0C, 0x06, 0x30, 0x6B,
  0x09, 0x60, 0x9B, 0x06, 0x28, 0x11, 0x6C, 0xC0, 0x27, 0x10, 0x5B, 0x0B, 0x50, 0x5B, 0x0A, 0x60,
  0xAB, 0x04, 0x50, 0xBB, 0x05, 0x71, 0x05, 0xB0, 0xB5, 0x03, 0xB0, 0xC6, 0x0B, 0xB0, 0x35, 0x0B,
  0xB0, 0x57, 0x10, 0x2C, 0x02, 0x40, 0x2B, 0x0D, 0x60, 0xDB, 0x01, 0x40, 0x2C, 0x02, 0x71, 0x05,
  0xC0, 0x85, 0xC6, 0x0E, 0xB5, 0x08, 0xC0, 0x57, 0x10, 0xDC, 0x0E, 0x50, 0xEB, 0x01, 0x5B, 0x0E,
  0x50, 0xEC, 0x0C, 0x70, 0x5E, 0x05, 0x40, 0xDB, 0x02, 0x40, 0x2B, 0x0D, 0x40, 0x5E, 0x05, 0x60,
  0xDE, 0x0B, 0x40, 0xCB, 0x03, 0x40, 0x3B, 0x0B, 0x40, 0xCE, 0x0D, 0x50, 0x6F, 0x90, 0x23, 0x0A,
  0xB0, 0x54, 0x05, 0xB0, 0xA3, 0x02, 0xF9, 0x06, 0x40, 0xEB, 0x08, 0x0B, 0xB0, 0x83, 0x09, 0xB0,
  0x64, 0x06, 0xB0, 0x93, 0x09, 0xB0, 0xB0, 0x9B, 0x0E, 0x30, 0x7B, 0x81, 0xE1, 0x5B, 0x0E, 0x30,
  0x7B, 0x08, 0x40, 0x7B, 0x07, 0x30, 0xEB, 0x81, 0x51, 0xEB, 0x07, 0x20, 0xEB, 0x08, 0x20, 0xEB,
  0x05, 0x20, 0x6B, 0x09, 0x40, 0x9B, 0x06, 0x20, 0x5B, 0x0E, 0x20, 0x8B, 0x81, 0xE0, 0x7B, 0x0E,
  0x01, 0x20, 0x8B, 0x0B, 0x20, 0x5B, 0x0A, 0x40, 0xAB, 0x04, 0x20, 0xCB, 0x08, 0x20, 0x10, 0xEB,
  0x07, 0x0C, 0xB0, 0x73, 0x02, 0xC8, 0x12, 0x03, 0xB0, 0xC4, 0x0C, 0xB8, 0x13, 0x02, 0xC0, 0x23,
  0x07, 0xB0, 0xCC, 0x01, 0x20, 0x10, 0x7F, 0xFF, 0xD0, 0x70, 0x12, 0x01, 0xC0, 0xEB, 0x82, 0x51,
  0x7E, 0xFF, 0xFF, 0x82, 0xE7, 0x15, 0xB0, 0xE0, 0xA8, 0x0C, 0x6F, 0x0B, 0x03, 0x80, 0xC6, 0xF8,
  0x13, 0x05, 0xE0, 0xE0, 0x77, 0x77, 0x30, 0x70, 0xEE, 0x06, 0x38, 0x43, 0xAE, 0xEB, 0x67, 0x77,
  0x78, 0x46, 0xCF, 0xDA, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_bakery_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_outlined_48_maps_bakery_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_beenhere 48x48, 4-bit Alpha,  RLE, 289 bytes.
static const unsigned char ic_outlined_48_maps_beenhere_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x19, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x10, 0x30, 0x74,
  0xF9, 0x77, 0x78, 0x23, 0xEF, 0x73, 0xF9, 0x77, 0x60, 0x30, 0xEB, 0x07, 0x2F, 0x97, 0x75, 0x03,
  0x0E, 0xC0, 0x72, 0xF9, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x3F, 0x97, 0x73, 0x03, 0x0E, 0xC0, 0x74,
  0xF9, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x5F, 0x97, 0x71, 0x03, 0x0E, 0xC0, 0x76, 0xF9, 0x40, 0x70,
  0x37, 0x10, 0x30, 0xEC, 0x07, 0x7F, 0x93, 0x82, 0x7F, 0xE3, 0x60, 0x30, 0xEC, 0x07, 0x71, 0xF9,
  0x20, 0x7B, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x07, 0x72, 0xF9, 0x20, 0x7C, 0x0E, 0x03, 0x20, 0x30,
  0xEC, 0x07, 0x73, 0xF9, 0x30, 0x7C, 0x82, 0xE3, 0x3E, 0xC0, 0x77, 0x4F, 0x94, 0x07, 0xC0, 0x0E,
  0xC0, 0x77, 0x5F, 0x95, 0x07, 0xF9, 0x07, 0x76, 0xF9, 0x60, 0x7E, 0x07, 0x77, 0xF9, 0x70, 0x7C,
  0x07, 0x77, 0x1F, 0x97, 0x10, 0x7A, 0x07, 0x77, 0x2F, 0x97, 0x20, 0x07, 0x77, 0x3C, 0x0E, 0xB0,
  0xC0, 0x27, 0x77, 0x30, 0x20, 0xCB, 0x0D, 0x09, 0xD0, 0x77, 0x77, 0x10, 0x7D, 0x81, 0x91, 0xDD,
  0x0C, 0x02, 0x77, 0x40, 0x20, 0xCD, 0x83, 0xD1, 0x01, 0xAE, 0x07, 0x77, 0x20, 0x7E, 0x0A, 0x01,
  0x40, 0x50, 0xED, 0x0C, 0x02, 0x75, 0x02, 0x0C, 0xD0, 0xE0, 0x57, 0x01, 0x0A, 0xE0, 0x77, 0x30,
  0x7E, 0x0A, 0x01, 0x73, 0x05, 0x0E, 0xD0, 0xC0, 0x26, 0x02, 0x0C, 0xD0, 0xE0, 0x57, 0x60, 0x10,
  0xAE, 0x07, 0x40, 0x7E, 0x0A, 0x01, 0x77, 0x20, 0x50, 0xED, 0x82, 0xC2, 0x2C, 0xD0, 0xE0, 0x57,
  0x75, 0x01, 0x0A, 0xFD, 0x0A, 0x01, 0x77, 0x71, 0x05, 0x0E, 0xF9, 0x0E, 0x05, 0x77, 0x74, 0x01,
  0x0A, 0xE0, 0xA0, 0x17, 0x77, 0x70, 0x50, 0xEA, 0x0E, 0x05, 0x77, 0x77, 0x38, 0x21, 0xAA, 0x17,
  0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_beenhere() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_beenhere_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_bike_scooter 48x48, 4-bit Alpha,  RLE, 356 bytes.
static const unsigned char ic_outlined_48_maps_bike_scooter_data[] PROGMEM = {
  0x77, 0x71, 0xF9, 0x81, 0xE9, 0x18, 0x0C, 0x10, 0xFB, 0x0D, 0x01, 0x77, 0x6F, 0x90, 0xD0, 0x86,
  0xFC, 0x09, 0x77, 0x6F, 0xB0, 0xB5, 0xFC, 0x0E, 0x77, 0x6F, 0xC0, 0x57, 0x50, 0xDB, 0x05, 0x77,
  0x5F, 0xC0, 0xB7, 0x50, 0x8B, 0x0B, 0x77, 0x75, 0x02, 0xB0, 0xE7, 0x50, 0x2C, 0x01, 0x77, 0x75,
  0x0E, 0xB0, 0x27, 0x50, 0xCB, 0x06, 0x77, 0x75, 0x0A, 0xB0, 0x67, 0x50, 0x6B, 0x0C, 0x77, 0x75,
  0x07, 0xB0, 0x97, 0x50, 0x1C, 0x02, 0x77, 0x74, 0x03, 0xB8, 0x1D, 0x01, 0xFF, 0xB8, 0x2E, 0xDA,
  0x57, 0x77, 0xC8, 0x11, 0x0D, 0xFF, 0xE0, 0xD0, 0x57, 0x75, 0x0C, 0xB8, 0x14, 0x09, 0xFF, 0xF9,
  0x09, 0x77, 0x40, 0x8B, 0x81, 0x80, 0x6F, 0xFF, 0xA0, 0x97, 0x73, 0x05, 0xB0, 0xB7, 0x20, 0x4F,
  0x83, 0xE1, 0x38, 0xEC, 0x05, 0x77, 0x20, 0x1C, 0x72, 0x0D, 0xB0, 0x0D, 0xB0, 0x52, 0x02, 0x0D,
  0xB0, 0xD7, 0x73, 0x0D, 0xB0, 0x37, 0x04, 0xC0, 0x20, 0x7B, 0x0B, 0x30, 0x20, 0xEB, 0x05, 0x77,
  0x20, 0xAB, 0x07, 0x70, 0x9B, 0x81, 0x80, 0x2C, 0x01, 0x30, 0x8B, 0x0A, 0x77, 0x10, 0x10, 0xAB,
  0x81, 0xA0, 0x4F, 0xA0, 0x32, 0x0C, 0xB0, 0x73, 0x02, 0xB0, 0xD7, 0x60, 0x10, 0x9D, 0x0E, 0x2F,
  0xA3, 0x06, 0xA0, 0xC0, 0x54, 0xB0, 0xE7, 0x50, 0x50, 0xEF, 0x81, 0x20, 0xCF, 0x93, 0x81, 0x18,
  0x26, 0xB0, 0xE7, 0x40, 0x6F, 0xA8, 0x15, 0x08, 0xF9, 0x03, 0x73, 0x03, 0xB0, 0xC7, 0x30, 0x5D,
  0x81, 0xC6, 0x27, 0x20, 0xAB, 0x08, 0x73, 0x08, 0xB0, 0x97, 0x20, 0x10, 0xEC, 0x06, 0x75, 0x05,
  0xB0, 0xE0, 0x27, 0x10, 0x20, 0xEB, 0x04, 0x72, 0x09, 0xC0, 0x42, 0x84, 0x6C, 0xEE, 0xC6, 0x60,
  0xDB, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x0C, 0x72, 0x01, 0xC8, 0x26, 0x01, 0xCE, 0x0C, 0x01, 0x40,
  0x5D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x03, 0x72, 0x06, 0xB0, 0xC2, 0x0C, 0xF9, 0x0C, 0x50, 0x9F,
  0xF0, 0x67, 0x30, 0xAB, 0x81, 0x60, 0x6F, 0xB0, 0x65, 0x09, 0xFD, 0x07, 0x3F, 0xD8, 0x12, 0x0C,
  0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x60, 0x50, 0xDF, 0x90, 0xC0, 0x34, 0xFD, 0x20, 0xEB, 0x01, 0x20,
  0x1B, 0x0E, 0x71, 0x86, 0x5A, 0xDF, 0xDD, 0x94, 0x6F, 0xD2, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7,
  0x77, 0x1F, 0xD2, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x80, 0xC0, 0x00, 0x6F, 0xB0, 0x68, 0x0C,
  0x10, 0x0C, 0xF9, 0x0C, 0x80, 0xC2, 0x00, 0x10, 0xCE, 0x0C, 0x01, 0x80, 0xC4, 0x08, 0x46, 0xCE,
  0xEC, 0x67, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_bike_scooter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_bike_scooter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_breakfast_dining 48x48, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_outlined_48_maps_breakfast_dining_data[] PROGMEM = {
  0x48, 0x22, 0x8C, 0xEF, 0xFF, 0xB8, 0x2E, 0xC8, 0x27, 0x09, 0xFF, 0xFF, 0xC0, 0x95, 0x0B, 0xFF,
  0xFF, 0xE0, 0xB3, 0x09, 0x80, 0xC0, 0xF8, 0x19, 0x02, 0xC8, 0x1D, 0x51, 0x77, 0x73, 0x81, 0x15,
  0xDC, 0x02, 0x08, 0xB0, 0xD0, 0x17, 0x77, 0x70, 0x10, 0xDB, 0x08, 0x0C, 0xB0, 0x57, 0x77, 0x72,
  0x05, 0xB0, 0xC0, 0xEB, 0x01, 0x77, 0x77, 0x20, 0x1B, 0x00, 0xEB, 0x01, 0x77, 0x77, 0x20, 0x1B,
  0x0E, 0x0C, 0xB0, 0x57, 0x77, 0x72, 0x05, 0xB0, 0xC0, 0x8B, 0x0D, 0x01, 0x77, 0x77, 0x01, 0x0D,
  0xB0, 0x80, 0x2C, 0x0D, 0x03, 0x77, 0x75, 0x04, 0x0D, 0xC8, 0x12, 0x08, 0xD0, 0xA7, 0x38, 0x24,
  0xDD, 0x47, 0x30, 0xAD, 0x08, 0x30, 0xAD, 0x72, 0x05, 0xC0, 0x57, 0x2D, 0x0B, 0x50, 0x7C, 0x71,
  0x05, 0xE0, 0x57, 0x1C, 0x08, 0x7C, 0x70, 0x5F, 0x90, 0x57, 0xC7, 0x1C, 0x60, 0x5F, 0xB0, 0x56,
  0xC7, 0x1C, 0x50, 0x5D, 0x00, 0x5D, 0x05, 0x5C, 0x71, 0xC4, 0x05, 0xD0, 0x52, 0x05, 0xD0, 0x44,
  0xC7, 0x1C, 0x40, 0xDC, 0x05, 0x40, 0x5C, 0x0D, 0x4C, 0x71, 0xC4, 0x0D, 0xC0, 0x54, 0x05, 0xC0,
  0xD4, 0xC7, 0x1C, 0x40, 0x4D, 0x05, 0x20, 0x5D, 0x05, 0x4C, 0x71, 0xC5, 0x05, 0xD0, 0x05, 0xD0,
  0x55, 0xC7, 0x1C, 0x60, 0x5F, 0xB0, 0x56, 0xC7, 0x1C, 0x70, 0x5F, 0x90, 0x57, 0xC7, 0x1C, 0x71,
  0x05, 0xE0, 0x57, 0x1C, 0x71, 0xC7, 0x20, 0x5C, 0x05, 0x72, 0xC7, 0x1C, 0x73, 0x82, 0x4D, 0xD4,
  0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77,
  0x73, 0xC7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0x10, 0xEF,
  0xFF, 0xF0, 0xE0, 0x17, 0x28, 0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_breakfast_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_breakfast_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_brunch_dining 48x48, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_outlined_48_maps_brunch_dining_data[] PROGMEM = {
  0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xC4, 0xC7,
  0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C,
  0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77,
  0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77,
  0x70, 0xEB, 0x4B, 0x0E, 0x77, 0x77, 0x0D, 0xB0, 0x32, 0x02, 0xB0, 0xD7, 0x77, 0x70, 0xAB, 0x07,
  0x20, 0x6B, 0x0A, 0x77, 0x77, 0x05, 0xB0, 0xD2, 0x0D, 0xB0, 0x67, 0x77, 0x70, 0x10, 0xEB, 0x08,
  0x07, 0xC0, 0x17, 0x3F, 0x97, 0x40, 0x8F, 0x90, 0x97, 0x4F, 0x97, 0x50, 0xDE, 0x0E, 0x01, 0x74,
  0xF9, 0x75, 0x02, 0x0E, 0xD0, 0x37, 0x5F, 0x97, 0x60, 0x4C, 0x06, 0x30, 0xBF, 0xFF, 0xD0, 0xB4,
  0xC4, 0xFF, 0xFF, 0x4C, 0x4F, 0xFF, 0xF4, 0xC4, 0xFF, 0xFF, 0x4C, 0x80, 0xC0, 0x0C, 0x80, 0xC0,
  0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x4F, 0xFF, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4,
  0xF9, 0x0C, 0xFF, 0xFD, 0x0C, 0x4F, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_brunch_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_brunch_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_bus_alert 48x48, 4-bit Alpha,  RLE, 308 bytes.
static const unsigned char ic_outlined_48_maps_bus_alert_data[] PROGMEM = {
  0x77, 0x77, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x77, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77,
  0x71, 0x08, 0xFD, 0x08, 0x77, 0x76, 0x08, 0xFF, 0x08, 0x72, 0x84, 0x47, 0x9B, 0xDD, 0xE0, 0x23,
  0x04, 0xF2, 0xF0, 0x45, 0x05, 0x0B, 0xFD, 0x0C, 0x40, 0xDF, 0x2F, 0x0D, 0x30, 0x40, 0xDF, 0xF0,
  0x73, 0x05, 0xF9, 0x2F, 0x98, 0x15, 0x05, 0xFF, 0xA0, 0x43, 0x09, 0xF9, 0x2F, 0x98, 0x19, 0x2E,
  0xD8, 0x4C, 0x86, 0x42, 0x17, 0x20, 0xDF, 0x92, 0xF9, 0x0D, 0x09, 0xC0, 0x90, 0x17, 0x71, 0x0E,
  0xF9, 0x2F, 0x90, 0xE0, 0xDF, 0xFB, 0x40, 0xEF, 0x92, 0xF9, 0x00, 0xEF, 0xFB, 0x01, 0x30, 0xDF,
  0x92, 0xF9, 0x0D, 0xFF, 0xC0, 0x33, 0x09, 0xFF, 0xC0, 0x9F, 0xFC, 0x07, 0x30, 0x5F, 0xFC, 0x05,
  0xC7, 0x75, 0x0D, 0xF2, 0xF0, 0xD1, 0xC7, 0x75, 0x04, 0xF2, 0xF0, 0x41, 0xC7, 0x76, 0x08, 0xFF,
  0x08, 0x2C, 0x77, 0x70, 0x8F, 0xD0, 0x83, 0xC7, 0x77, 0x10, 0x40, 0xDF, 0x90, 0xD0, 0x44, 0xC7,
  0x77, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56, 0xFF, 0xF9, 0x0B, 0x01, 0x77, 0x4F, 0xFF, 0xA0, 0xD0,
  0x37, 0x73, 0xFF, 0xFC, 0x0A, 0x02, 0x77, 0x1F, 0xFF, 0xE8, 0x2C, 0x74, 0x27, 0x4C, 0x77, 0x73,
  0xC7, 0x3C, 0x77, 0x73, 0xC7, 0x3C, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x83, 0xC7, 0x3C,
  0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82, 0xC7, 0x3C, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2,
  0xC7, 0x3C, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xC7, 0x3C, 0x81, 0x10, 0x8C, 0x08, 0x71,
  0x08, 0xC8, 0x18, 0x01, 0xC7, 0x30, 0xEB, 0x05, 0x28, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x82,
  0x05, 0xB0, 0xE7, 0x30, 0xCB, 0x0D, 0x01, 0x77, 0x60, 0x10, 0xDB, 0x0C, 0x73, 0x07, 0xC8, 0x1D,
  0x51, 0x77, 0x28, 0x11, 0x5D, 0xC0, 0x77, 0x30, 0x10, 0xEF, 0xFF, 0xF0, 0xE0, 0x17, 0x40, 0x4F,
  0xFF, 0xF0, 0x47, 0x6F, 0xFF, 0xF7, 0x7F, 0xFF, 0xF7, 0x7E, 0x77, 0x2E, 0x77, 0xE7, 0x72, 0xE7,
  0x70, 0xDC, 0x0D, 0x77, 0x20, 0xDC, 0x0D, 0x77, 0x04, 0x0D, 0xA0, 0xD0, 0x47, 0x72, 0x04, 0x0D,
  0xA0, 0xD0, 0x47, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_bus_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_bus_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_car_crash 48x48, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_outlined_48_maps_car_crash_data[] PROGMEM = {
  0x77, 0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x77, 0x20, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77,
  0x60, 0x8F, 0xD0, 0x87, 0x77, 0x40, 0x8F, 0xF0, 0x87, 0x77, 0x20, 0x4F, 0x2F, 0x04, 0x77, 0x71,
  0x0D, 0xF2, 0xF0, 0xD6, 0x08, 0x0E, 0xFA, 0x07, 0x30, 0x5F, 0x92, 0xF9, 0x05, 0x40, 0x8F, 0xC0,
  0x33, 0x09, 0xF9, 0x2F, 0x90, 0x94, 0x0E, 0xFC, 0x01, 0x30, 0xDF, 0x92, 0xF9, 0x0D, 0x30, 0x5F,
  0xD4, 0x0E, 0xF9, 0x2F, 0x90, 0xE3, 0x0A, 0xB0, 0x87, 0x50, 0xEF, 0x92, 0xF9, 0x0E, 0x20, 0x1C,
  0x02, 0x75, 0x0D, 0xF9, 0x2F, 0x90, 0xD2, 0x06, 0xB0, 0xC7, 0x60, 0x9F, 0xFC, 0x09, 0x20, 0xBB,
  0x07, 0x76, 0x05, 0xFF, 0xC8, 0x15, 0x01, 0xC0, 0x27, 0x70, 0xDF, 0x2F, 0x0D, 0x20, 0x6B, 0x0C,
  0x77, 0x10, 0x4F, 0x2F, 0x04, 0x20, 0xCF, 0xF9, 0x09, 0x40, 0x8F, 0xF0, 0x82, 0x02, 0xFF, 0xB0,
  0x34, 0x08, 0xFD, 0x08, 0x30, 0x7F, 0xFB, 0x0D, 0x01, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x44, 0x0C,
  0xFF, 0xC0, 0xB6, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x6C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x38,
  0x28, 0xDD, 0x87, 0x77, 0x30, 0x24, 0xC2, 0x08, 0xC0, 0x87, 0x58, 0x38, 0xC7, 0x42, 0x38, 0x13,
  0x7B, 0x94, 0xC2, 0x0D, 0xC0, 0xD7, 0x50, 0xEC, 0x0E, 0x2C, 0x4C, 0x20, 0xDC, 0x0D, 0x75, 0x0D,
  0xC0, 0xD2, 0xC4, 0xC2, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2C, 0x4C, 0x38, 0x28, 0xDD, 0x87,
  0x78, 0x28, 0xDD, 0x83, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0x80, 0xC0, 0xF4, 0x80,
  0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0xE7, 0x77, 0x3E, 0x4E, 0x77, 0x73, 0xE4, 0x0D,
  0xC0, 0xD7, 0x77, 0x30, 0xDC, 0x0D, 0x40, 0x40, 0xDA, 0x0D, 0x04, 0x77, 0x73, 0x04, 0x0D, 0xA0,
  0xD0, 0x44,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_car_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 45, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_car_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_car_rental 48x48, 4-bit Alpha,  RLE, 187 bytes.
static const unsigned char ic_outlined_48_maps_car_rental_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEB, 0x57, 0x76, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x74, 0x0C, 0xF9, 0x0C, 0x77,
  0x30, 0x6F, 0xB0, 0x67, 0x72, 0x0C, 0xB8, 0x2B, 0x11, 0xBF, 0xFE, 0x0E, 0xB0, 0x12, 0x01, 0xFF,
  0xE0, 0xEB, 0x01, 0x20, 0x1F, 0xFE, 0x0C, 0xB8, 0x2B, 0x11, 0xBF, 0xFE, 0x06, 0xFB, 0x06, 0x73,
  0xC3, 0x0C, 0xF9, 0x0C, 0x74, 0xC3, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x4C, 0x58, 0x46, 0xCE, 0xEB,
  0x57, 0x6C, 0x80, 0x9E, 0x20, 0x0A, 0xFF, 0xC0, 0xA7, 0x09, 0xFF, 0xE0, 0x95, 0x01, 0xFF, 0xF9,
  0x01, 0x40, 0x5F, 0xFF, 0x90, 0x54, 0x0B, 0xB0, 0x77, 0x70, 0x7B, 0x0B, 0x30, 0x1C, 0x02, 0x77,
  0x02, 0xC0, 0x12, 0x05, 0xB0, 0xC7, 0x72, 0x0C, 0xB0, 0x52, 0x0B, 0xB0, 0x77, 0x72, 0x07, 0xB8,
  0x1A, 0x01, 0xFF, 0xFD, 0x01, 0x05, 0xFF, 0xFD, 0x05, 0x0A, 0xFF, 0xFD, 0x0A, 0xFF, 0xFF, 0xC7,
  0x76, 0xF9, 0x28, 0x24, 0xDD, 0x47, 0x18, 0x24, 0xDD, 0x42, 0xF9, 0x20, 0xDA, 0x0D, 0x71, 0x0D,
  0xA0, 0xD2, 0xF9, 0x20, 0xDA, 0x0D, 0x71, 0x0D, 0xA0, 0xD2, 0xF9, 0x28, 0x24, 0xDD, 0x47, 0x18,
  0x24, 0xDD, 0x42, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6C, 0x0E, 0xA0, 0xE7,
  0x76, 0x0E, 0xA8, 0x3E, 0x7E, 0xE7, 0x77, 0x68, 0x27, 0xFE, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_car_rental() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_car_rental_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_car_repair 48x48, 4-bit Alpha,  RLE, 156 bytes.
static const unsigned char ic_outlined_48_maps_car_repair_data[] PROGMEM = {
  0x60, 0xAF, 0xFC, 0x0A, 0x74, 0x09, 0xFF, 0xE0, 0x97, 0x20, 0x1F, 0xFF, 0x90, 0x17, 0x10, 0x5F,
  0xFF, 0x90, 0x57, 0x10, 0xBB, 0x07, 0x77, 0x07, 0xB0, 0xB7, 0x01, 0xC0, 0x27, 0x70, 0x2C, 0x01,
  0x60, 0x5B, 0x0C, 0x77, 0x20, 0xCB, 0x05, 0x60, 0xBB, 0x07, 0x77, 0x20, 0x7B, 0x0B, 0x50, 0x1F,
  0xFF, 0xD0, 0x14, 0x05, 0xFF, 0xFD, 0x05, 0x40, 0xAF, 0xFF, 0xD0, 0xA4, 0xFF, 0xFF, 0x4C, 0x77,
  0x6C, 0x4C, 0x28, 0x24, 0xDD, 0x47, 0x18, 0x24, 0xDD, 0x42, 0xC4, 0xC2, 0x0D, 0xA0, 0xD7, 0x10,
  0xDA, 0x0D, 0x2C, 0x4C, 0x20, 0xDA, 0x0D, 0x71, 0x0D, 0xA0, 0xD2, 0xC4, 0xC2, 0x82, 0x4D, 0xD4,
  0x71, 0x82, 0x4D, 0xD4, 0x2C, 0x4C, 0x77, 0x6C, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4,
  0xFF, 0xFF, 0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6C, 0x40, 0xEA, 0x0E, 0x77, 0x60, 0xEA, 0x0E, 0x48,
  0x27, 0xEE, 0x77, 0x76, 0x82, 0x7F, 0xE7, 0x80, 0xF6, 0x08, 0x09, 0xF4, 0xF7, 0x7C, 0x77, 0x77,
  0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_car_repair() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_car_repair_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_castle 48x48, 4-bit Alpha,  RLE, 184 bytes.
static const unsigned char ic_outlined_48_maps_castle_data[] PROGMEM = {
  0x71, 0xC4, 0xC4, 0xC4, 0xC7, 0x72, 0xC4, 0xC4, 0xC4, 0xC7, 0x72, 0xC4, 0xC4, 0xC4, 0xC7, 0x72,
  0xC4, 0xC4, 0xC4, 0xC7, 0x72, 0xFF, 0xFF, 0x77, 0x2F, 0xFF, 0xF7, 0x72, 0xFF, 0xFF, 0x77, 0x2F,
  0xFF, 0xF7, 0x72, 0xC7, 0x76, 0xC7, 0x72, 0xC7, 0x76, 0xC7, 0x72, 0xC7, 0x76, 0xC7, 0x72, 0xC7,
  0x76, 0xC7, 0x1C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C,
  0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xFB, 0x4C, 0x4C,
  0x4F, 0xFF, 0xB7, 0x76, 0xFF, 0xFB, 0x77, 0x6F, 0xFA, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9,
  0x77, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0xF9, 0x76, 0x09, 0xF9, 0x09, 0x76, 0xF9, 0x75, 0x0B,
  0xFB, 0x0B, 0x75, 0xF9, 0x74, 0x09, 0xFD, 0x09, 0x74, 0xF9, 0x73, 0x02, 0xC8, 0x4D, 0x51, 0x15,
  0xDC, 0x02, 0x73, 0xF9, 0x73, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x3F, 0x97, 0x30,
  0xCB, 0x05, 0x60, 0x5B, 0x0C, 0x73, 0xF9, 0x73, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x3F, 0x97,
  0x3C, 0x71, 0xC7, 0x3F, 0x97, 0x3C, 0x71, 0xC7, 0x3F, 0xFF, 0x97, 0x18, 0x0C, 0x0F, 0x71, 0x80,
  0xC0, 0xF7, 0x18, 0x0C, 0x0F, 0x71, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_castle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_castle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_category 48x48, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_outlined_48_maps_category_data[] PROGMEM = {
  0x77, 0x30, 0x04, 0x80, 0xC0, 0x00, 0x0D, 0x77, 0x77, 0x70, 0x8A, 0x08, 0x77, 0x77, 0x50, 0x2C,
  0x02, 0x77, 0x77, 0x40, 0xBC, 0x0B, 0x77, 0x77, 0x30, 0x5E, 0x05, 0x77, 0x77, 0x10, 0x10, 0xEE,
  0x0E, 0x01, 0x77, 0x77, 0x09, 0xF9, 0x09, 0x77, 0x76, 0x03, 0xC0, 0x07, 0xC0, 0x37, 0x77, 0x50,
  0xCB, 0x0D, 0x20, 0xDB, 0x0C, 0x77, 0x74, 0x06, 0xC0, 0x42, 0x04, 0xC0, 0x67, 0x77, 0x20, 0x10,
  0xEB, 0x0A, 0x40, 0xAB, 0x0E, 0x01, 0x77, 0x71, 0x09, 0xB0, 0xE0, 0x14, 0x01, 0x0E, 0xB0, 0x97,
  0x77, 0x03, 0xC0, 0x66, 0x06, 0xC0, 0x37, 0x76, 0x0D, 0xFF, 0xA0, 0xD7, 0x75, 0x07, 0xFF, 0xC0,
  0x77, 0x73, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x17, 0x72, 0x0A, 0xFF, 0xE0, 0xA8, 0x0A, 0xE6, 0x08,
  0x64, 0x9D, 0xEE, 0xD9, 0x45, 0xFF, 0xA7, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x3F, 0xFA, 0x60, 0x30,
  0xEF, 0xB0, 0xE0, 0x32, 0xFF, 0xA5, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x1F, 0xFA, 0x50, 0xBC, 0x0A,
  0x03, 0x20, 0x30, 0xAC, 0x0B, 0x1C, 0x71, 0xC4, 0x04, 0xC0, 0x76, 0x07, 0xC0, 0x4C, 0x71, 0xC4,
  0x09, 0xB0, 0xA7, 0x10, 0xAB, 0x09, 0xC7, 0x1C, 0x40, 0xDB, 0x03, 0x71, 0x03, 0xB0, 0xDC, 0x71,
  0xC4, 0x0E, 0xB7, 0x3B, 0x0E, 0xC7, 0x1C, 0x40, 0xEB, 0x73, 0xB0, 0xEC, 0x71, 0xC4, 0x0D, 0xB0,
  0x37, 0x10, 0x3B, 0x0D, 0xC7, 0x1C, 0x40, 0x9B, 0x0A, 0x71, 0x0A, 0xB0, 0x9C, 0x71, 0xC4, 0x04,
  0xC0, 0x76, 0x07, 0xC0, 0x4F, 0xFA, 0x50, 0xBC, 0x0A, 0x03, 0x20, 0x30, 0xAC, 0x0B, 0x1F, 0xFA,
  0x50, 0x20, 0xEF, 0xD0, 0xE0, 0x21, 0xFF, 0xA6, 0x03, 0x0E, 0xFB, 0x0E, 0x03, 0x2F, 0xFA, 0x70,
  0x20, 0xBF, 0x90, 0xB0, 0x27, 0x77, 0x78, 0x64, 0x9D, 0xEE, 0xD9, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_category() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_category_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_celebration 48x48, 4-bit Alpha,  RLE, 382 bytes.
static const unsigned char ic_outlined_48_maps_celebration_data[] PROGMEM = {
  0x77, 0x73, 0x08, 0x09, 0x80, 0xC4, 0x00, 0x8A, 0x09, 0x80, 0xC3, 0x00, 0x9B, 0x09, 0x80, 0xC3,
  0x00, 0x9B, 0x08, 0x77, 0x77, 0x20, 0x70, 0x97, 0x09, 0xB0, 0x37, 0x77, 0x70, 0x7A, 0x08, 0x70,
  0xAA, 0x09, 0x77, 0x77, 0x09, 0xB0, 0x36, 0x03, 0xA0, 0xC7, 0x77, 0x71, 0x0B, 0xA0, 0x96, 0x03,
  0xA0, 0xC5, 0x84, 0x39, 0xCC, 0x93, 0x77, 0x40, 0x3A, 0x0C, 0x60, 0xBA, 0x09, 0x40, 0x8E, 0x08,
  0x77, 0x30, 0x3A, 0x0C, 0x50, 0x9B, 0x03, 0x30, 0x9F, 0x90, 0x97, 0x72, 0x0B, 0xA0, 0x94, 0x09,
  0xB0, 0x83, 0x09, 0xB8, 0x2B, 0x33, 0xAA, 0x08, 0x77, 0x10, 0x9B, 0x03, 0x30, 0x9B, 0x09, 0x30,
  0x9B, 0x09, 0x40, 0x90, 0x87, 0x72, 0x07, 0xA0, 0x83, 0x09, 0xB0, 0x93, 0x09, 0xB0, 0x97, 0x73,
  0x02, 0x07, 0x50, 0x70, 0x93, 0x09, 0xB0, 0x93, 0x09, 0xB0, 0x97, 0x74, 0x81, 0x8F, 0x77, 0x10,
  0x9B, 0x09, 0x30, 0x9B, 0x09, 0x77, 0x50, 0xDA, 0x07, 0x60, 0x9B, 0x09, 0x30, 0x9B, 0x09, 0x77,
  0x50, 0x3C, 0x07, 0x50, 0x7A, 0x09, 0x30, 0x9B, 0x09, 0x77, 0x60, 0x9D, 0x07, 0x50, 0x70, 0x93,
  0x09, 0xB0, 0x97, 0x77, 0x0E, 0xE0, 0x77, 0x10, 0x9B, 0x09, 0x77, 0x70, 0x5F, 0x90, 0x76, 0x09,
  0xB0, 0x93, 0x84, 0x39, 0xCC, 0x93, 0x76, 0x0A, 0xB0, 0xB0, 0xEC, 0x07, 0x50, 0x7A, 0x09, 0x30,
  0x8E, 0x08, 0x74, 0x01, 0xC8, 0x13, 0x3E, 0xC0, 0x75, 0x07, 0x09, 0x30, 0x9F, 0x90, 0x97, 0x30,
  0x6B, 0x0D, 0x20, 0x30, 0xEC, 0x07, 0x71, 0x09, 0xB8, 0x2B, 0x33, 0xAB, 0x09, 0x72, 0x0B, 0xB0,
  0x73, 0x03, 0x0E, 0xC0, 0x76, 0x09, 0xB0, 0x94, 0x09, 0xB0, 0x97, 0x01, 0xC0, 0x24, 0x03, 0x0E,
  0xC0, 0x75, 0x07, 0xA0, 0x96, 0x09, 0xA0, 0x97, 0x07, 0xB0, 0xC6, 0x03, 0x0E, 0xC0, 0x75, 0x07,
  0x09, 0x71, 0x00, 0x97, 0x10, 0xCB, 0x06, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x72, 0x02, 0xC0, 0x17,
  0x10, 0x30, 0xEC, 0x07, 0x77, 0x71, 0x08, 0xB0, 0xB7, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x70, 0xDB,
  0x05, 0x73, 0x03, 0x0B, 0xD0, 0x77, 0x75, 0x03, 0xB0, 0xE7, 0x18, 0x12, 0x7D, 0xF9, 0x07, 0x77,
  0x40, 0x9B, 0x09, 0x58, 0x11, 0x6C, 0xFA, 0x81, 0xD8, 0x27, 0x74, 0x0E, 0xB0, 0x43, 0x05, 0x0B,
  0xFA, 0x81, 0xE9, 0x37, 0x76, 0x05, 0xB8, 0x3E, 0x04, 0x9E, 0xFA, 0x0A, 0x05, 0x77, 0x72, 0x0A,
  0xB0, 0xD0, 0xEF, 0xA8, 0x1B, 0x61, 0x77, 0x73, 0x01, 0xFD, 0x81, 0xC7, 0x17, 0x77, 0x60, 0x6F,
  0xA8, 0x1D, 0x82, 0x77, 0x77, 0x20, 0xBE, 0x81, 0xE9, 0x37, 0x77, 0x74, 0x01, 0xD0, 0xA0, 0x57,
  0x77, 0x77, 0x07, 0xA8, 0x1B, 0x61, 0x80, 0xC1, 0x08, 0x19, 0x71, 0x80, 0xC4, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_celebration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 46, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_celebration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_church 48x48, 4-bit Alpha,  RLE, 248 bytes.
static const unsigned char ic_outlined_48_maps_church_data[] PROGMEM = {
  0x77, 0x4C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x77, 0x77, 0x4F, 0xD7, 0x77,
  0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x74, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00,
  0xC7, 0x77, 0x76, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x77, 0x72, 0x03, 0x0B, 0xF9, 0x0B, 0x03, 0x77,
  0x75, 0x03, 0x0B, 0xFD, 0x0B, 0x03, 0x77, 0x71, 0x03, 0x0B, 0xE8, 0x2B, 0x33, 0xBE, 0x0B, 0x03,
  0x77, 0x40, 0x30, 0xBE, 0x0C, 0x04, 0x40, 0x40, 0xCE, 0x0B, 0x03, 0x77, 0x2E, 0x0C, 0x04, 0x71,
  0x04, 0x0C, 0xE7, 0x72, 0xC0, 0xC0, 0x57, 0x50, 0x40, 0xCC, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C,
  0x68, 0x28, 0xDD, 0x86, 0xC7, 0x72, 0xC5, 0x08, 0xC0, 0x85, 0xC7, 0x72, 0xC5, 0x0D, 0xC0, 0xD5,
  0xC7, 0x71, 0x05, 0xC5, 0x0D, 0xC0, 0xD5, 0xC0, 0x57, 0x50, 0x60, 0xDD, 0x50, 0x8C, 0x08, 0x5D,
  0x0D, 0x06, 0x78, 0x11, 0x8E, 0xE0, 0xE6, 0x82, 0x8D, 0xD8, 0x60, 0xEE, 0x81, 0xE8, 0x12, 0x03,
  0x0A, 0xF8, 0x1E, 0x71, 0x77, 0x30, 0x70, 0xDF, 0x0A, 0x03, 0xF0, 0xC0, 0x57, 0x77, 0x10, 0x50,
  0xCF, 0xD0, 0xB0, 0x47, 0x50, 0x02, 0x75, 0x04, 0x0B, 0xFA, 0x03, 0x74, 0x81, 0x19, 0xEA, 0x81,
  0xE9, 0x17, 0x40, 0x2F, 0x97, 0x40, 0x20, 0xEE, 0x0E, 0x02, 0x74, 0xF9, 0x74, 0x0D, 0xF9, 0x0D,
  0x74, 0xF9, 0x73, 0x07, 0xFB, 0x07, 0x73, 0xF9, 0x73, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x73,
  0xF9, 0x73, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x3F, 0x97, 0x3C, 0x4C, 0x73, 0xF9, 0x73, 0xC4,
  0xC7, 0x3F, 0x97, 0x3C, 0x4C, 0x73, 0xF9, 0x73, 0xC4, 0xC7, 0x3F, 0xFF, 0x94, 0x80, 0xC0, 0xF4,
  0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_church() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_church_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_cleaning_services 48x48, 4-bit Alpha,  RLE, 208 bytes.
static const unsigned char ic_outlined_48_maps_cleaning_services_data[] PROGMEM = {
  0x76, 0x81, 0x1A, 0xDC, 0x81, 0xDA, 0x17, 0x77, 0x40, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x77, 0x30,
  0xAF, 0xB0, 0xA7, 0x77, 0x30, 0xDF, 0xB0, 0xD7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77,
  0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C,
  0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73,
  0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7,
  0x74, 0x82, 0x59, 0xDE, 0xFF, 0xA8, 0x2E, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x47,
  0x08, 0xFF, 0xFF, 0x08, 0x50, 0x8F, 0xFF, 0xFA, 0x08, 0x30, 0x4D, 0x08, 0x03, 0x77, 0x40, 0x30,
  0x8D, 0x04, 0x20, 0xDB, 0x0D, 0x03, 0x77, 0x71, 0x03, 0x0D, 0xB8, 0x1D, 0x05, 0xC0, 0x37, 0x77,
  0x30, 0x3C, 0x05, 0x09, 0xB0, 0x87, 0x77, 0x50, 0x8B, 0x09, 0x0D, 0xB0, 0x37, 0x77, 0x50, 0x3B,
  0x0D, 0x0E, 0xB7, 0x77, 0x7B, 0x0E, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x94, 0x82, 0x4D, 0xD4,
  0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x4F, 0x94, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D,
  0xA0, 0xD4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F,
  0x94, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0x80, 0xAA, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_cleaning_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_cleaning_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_compass_calibration 48x48, 4-bit Alpha,  RLE, 317 bytes.
static const unsigned char ic_outlined_48_maps_compass_calibration_data[] PROGMEM = {
  0x76, 0x84, 0x37, 0x9B, 0xDD, 0xA8, 0x4D, 0xDB, 0x97, 0x37, 0x77, 0x28, 0x15, 0xAE, 0xFF, 0x81,
  0xEA, 0x57, 0x73, 0x81, 0x18, 0xEF, 0xFE, 0x81, 0xE8, 0x17, 0x60, 0x80, 0xEF, 0xFF, 0xB0, 0xE0,
  0x87, 0x30, 0x50, 0xDF, 0x84, 0xEA, 0x74, 0x31, 0x28, 0x41, 0x34, 0x7A, 0xEF, 0x0D, 0x05, 0x70,
  0x9E, 0x81, 0xE9, 0x37, 0x78, 0x13, 0x9E, 0xE0, 0xA4, 0x02, 0x0D, 0xD0, 0xD0, 0x67, 0x76, 0x06,
  0x0D, 0xD8, 0x3D, 0x20, 0x3E, 0xD0, 0x87, 0x77, 0x30, 0x8D, 0x81, 0xE3, 0xAD, 0x03, 0x77, 0x75,
  0x03, 0xD8, 0x1A, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x30, 0x10, 0xCC, 0x0B, 0x30, 0xBC, 0x0C, 0x78,
  0x90, 0x47, 0xAB, 0xCC, 0xBA, 0x74, 0x60, 0x10, 0xCC, 0x0B, 0x50, 0xBC, 0x0C, 0x38, 0x13, 0x9E,
  0xFB, 0x81, 0xE9, 0x32, 0x01, 0x0C, 0xC0, 0xB7, 0x0B, 0xC8, 0x1C, 0x3A, 0xFF, 0xA8, 0x1A, 0x3C,
  0xC0, 0xB7, 0x20, 0xBF, 0xFF, 0xF0, 0xB7, 0x40, 0xBF, 0x98, 0x90, 0xE9, 0x64, 0x32, 0x46, 0x9E,
  0xF9, 0x0B, 0x76, 0x0B, 0xD0, 0xC0, 0x47, 0x30, 0x40, 0xCD, 0x0B, 0x77, 0x10, 0xBA, 0x0E, 0x05,
  0x77, 0x05, 0x0E, 0xA0, 0xB7, 0x73, 0x81, 0xBC, 0x27, 0x72, 0x81, 0x1C, 0xB7, 0x77, 0x48, 0x65,
  0x9D, 0xEE, 0xD9, 0x57, 0x77, 0x72, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x76, 0x08, 0xFD, 0x08,
  0x77, 0x74, 0x08, 0xFF, 0x08, 0x77, 0x72, 0x04, 0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x47, 0x77,
  0x10, 0xDB, 0x0D, 0x03, 0x60, 0x30, 0xDB, 0x0D, 0x77, 0x70, 0x5C, 0x03, 0x71, 0x03, 0xC0, 0x57,
  0x76, 0x09, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0x77, 0x60, 0xDB, 0x03, 0x73, 0x03, 0xB0, 0xD7, 0x76,
  0x0E, 0xB7, 0x5B, 0x0E, 0x77, 0x60, 0xEB, 0x75, 0xB0, 0xE7, 0x76, 0x0D, 0xB0, 0x37, 0x30, 0x3B,
  0x0D, 0x77, 0x60, 0x9B, 0x08, 0x73, 0x08, 0xB0, 0x97, 0x76, 0x05, 0xC0, 0x37, 0x10, 0x3C, 0x05,
  0x77, 0x70, 0xDB, 0x0D, 0x03, 0x60, 0x30, 0xDB, 0x0D, 0x77, 0x71, 0x04, 0xD0, 0x80, 0x32, 0x03,
  0x08, 0xD0, 0x47, 0x77, 0x20, 0x8F, 0xF0, 0x87, 0x77, 0x40, 0x8F, 0xD0, 0x87, 0x77, 0x60, 0x40,
  0xDF, 0x90, 0xD0, 0x47, 0x77, 0x72, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_compass_calibration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_compass_calibration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_connecting_airports 48x48, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_outlined_48_maps_connecting_airports_data[] PROGMEM = {
  0x68, 0x23, 0xBB, 0x17, 0x77, 0x71, 0xA0, 0x87, 0x77, 0x71, 0x0B, 0xA0, 0x27, 0x77, 0x70, 0x6A,
  0x0B, 0x77, 0x77, 0x02, 0xB0, 0x57, 0x77, 0x70, 0xCA, 0x0D, 0x77, 0x77, 0x08, 0xB0, 0x87, 0x75,
  0x81, 0xDF, 0x55, 0x03, 0xC0, 0x27, 0x74, 0x82, 0x8F, 0xE2, 0x50, 0xEB, 0x0A, 0x77, 0x40, 0x3F,
  0xFD, 0x0D, 0x04, 0x74, 0x0E, 0xFF, 0xD0, 0xD7, 0x40, 0xEF, 0xFD, 0x0D, 0x73, 0x03, 0xFF, 0xD0,
  0xD0, 0x47, 0x38, 0x28, 0xFE, 0x25, 0x0E, 0xB0, 0xA7, 0x74, 0x81, 0xDF, 0x55, 0x03, 0xC0, 0x27,
  0x77, 0x50, 0x8B, 0x08, 0x77, 0x76, 0x0C, 0xA0, 0xD7, 0x38, 0x21, 0xBB, 0x37, 0x60, 0x2B, 0x05,
  0x73, 0x08, 0xA7, 0x70, 0x6A, 0x0B, 0x73, 0x02, 0xA0, 0xB7, 0x70, 0xBA, 0x02, 0x73, 0x0B, 0xA0,
  0x67, 0x7A, 0x08, 0x73, 0x05, 0xB0, 0x27, 0x68, 0x23, 0xBB, 0x17, 0x30, 0xDA, 0x0C, 0x77, 0x76,
  0x08, 0xB0, 0x87, 0x77, 0x50, 0x2C, 0x03, 0x58, 0x15, 0xFD, 0x77, 0x40, 0xAB, 0x0E, 0x58, 0x22,
  0xEF, 0x87, 0x30, 0x40, 0xDF, 0xFD, 0x03, 0x73, 0x0D, 0xFF, 0xD0, 0xE7, 0x40, 0xDF, 0xFD, 0x0E,
  0x74, 0x04, 0x0D, 0xFF, 0xD0, 0x37, 0x74, 0x0A, 0xB0, 0xE5, 0x82, 0x2E, 0xF8, 0x77, 0x40, 0x2C,
  0x03, 0x58, 0x15, 0xFD, 0x77, 0x50, 0x8B, 0x08, 0x77, 0x77, 0x0D, 0xA0, 0xC7, 0x77, 0x70, 0x5B,
  0x02, 0x77, 0x77, 0x0B, 0xA0, 0x67, 0x77, 0x70, 0x2A, 0x0B, 0x77, 0x77, 0x10, 0x8A, 0x77, 0x77,
  0x18, 0x21, 0xBB, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_connecting_airports() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 5, 39, 42), Box(0, 0, 47, 47),
      ic_outlined_48_maps_connecting_airports_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_crisis_alert 48x48, 4-bit Alpha,  RLE, 486 bytes.
static const unsigned char ic_outlined_48_maps_crisis_alert_data[] PROGMEM = {
  0x77, 0x38, 0x44, 0xBE, 0xEB, 0x47, 0x77, 0x75, 0x08, 0xE0, 0x87, 0x77, 0x73, 0x04, 0xF9, 0x04,
  0x77, 0x77, 0x20, 0xBF, 0x90, 0xB7, 0x77, 0x72, 0x0E, 0xF9, 0x0E, 0x77, 0x77, 0x20, 0xEF, 0x90,
  0xE7, 0x77, 0x38, 0x11, 0x81, 0x30, 0xDF, 0x90, 0xD3, 0x81, 0x18, 0x17, 0x73, 0x82, 0x5E, 0xF4,
  0x30, 0xAF, 0x90, 0xA3, 0x82, 0x4F, 0xE5, 0x77, 0x10, 0x8B, 0x07, 0x30, 0x6F, 0x90, 0x63, 0x07,
  0xB0, 0x87, 0x60, 0xBC, 0x0A, 0x30, 0x3F, 0x90, 0x23, 0x0A, 0xC0, 0xB7, 0x40, 0xAD, 0x06, 0x40,
  0xEE, 0x0E, 0x40, 0x6D, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x25, 0x0A, 0xE0, 0xA5, 0x02, 0x0D, 0xC0,
  0x97, 0x04, 0xC0, 0xC0, 0x16, 0x06, 0xE0, 0x66, 0x01, 0x0C, 0xC0, 0x45, 0x01, 0x0E, 0xB0, 0xD0,
  0x17, 0x01, 0xE0, 0x17, 0x01, 0x0D, 0xB0, 0xE0, 0x14, 0x08, 0xC0, 0x24, 0x04, 0x40, 0xCC, 0x0C,
  0x40, 0x44, 0x02, 0xC0, 0x83, 0x01, 0xC0, 0x74, 0x81, 0x5F, 0x53, 0x07, 0xC0, 0x73, 0x81, 0x5F,
  0x54, 0x07, 0xC0, 0x12, 0x07, 0xB0, 0xD4, 0x04, 0xA0, 0x93, 0x02, 0xC0, 0x23, 0x09, 0xA0, 0x44,
  0x0D, 0xB0, 0x72, 0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xA0, 0xE7, 0x50, 0xEA, 0x0E, 0x01, 0x30, 0x6B,
  0x81, 0xD0, 0x3B, 0x0E, 0x40, 0x9C, 0x01, 0x73, 0x01, 0xC0, 0x94, 0x0E, 0xB0, 0x30, 0x6B, 0x0A,
  0x30, 0x1C, 0x06, 0x75, 0x06, 0xC0, 0x13, 0x0A, 0xB0, 0x60, 0xAB, 0x06, 0x30, 0x6B, 0x0C, 0x48,
  0x41, 0xAD, 0xDA, 0x14, 0x0C, 0xB0, 0x63, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x30, 0xAB, 0x06, 0x30,
  0x10, 0xEC, 0x0E, 0x01, 0x30, 0x6B, 0x0A, 0x30, 0x3B, 0x0C, 0x0D, 0xB0, 0x13, 0x0C, 0xB0, 0x23,
  0x0A, 0xE0, 0xA3, 0x02, 0xB0, 0xC3, 0x01, 0xB0, 0xD0, 0xEB, 0x40, 0xEB, 0x40, 0xDE, 0x0D, 0x4B,
  0x0E, 0x4B, 0x0E, 0xC4, 0x0E, 0xB4, 0x0D, 0xE0, 0xD4, 0xB0, 0xE4, 0xC0, 0xEB, 0x02, 0x30, 0xDB,
  0x02, 0x30, 0xAE, 0x0A, 0x30, 0x2B, 0x0D, 0x30, 0x2B, 0x0E, 0x0C, 0xB0, 0x33, 0x0B, 0xB0, 0x63,
  0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x06, 0xB0, 0xB3, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x30, 0x6B, 0x0C,
  0x48, 0x41, 0xAD, 0xDA, 0x14, 0x0C, 0xB0, 0x63, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x30, 0x1C, 0x06,
  0x75, 0x06, 0xC0, 0x13, 0x0B, 0xB0, 0x70, 0x3C, 0x40, 0x9C, 0x04, 0x73, 0x04, 0xC0, 0x94, 0xC8,
  0x13, 0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C, 0x0E, 0x01, 0x30, 0x6B, 0x0D, 0x20,
  0x8B, 0x0D, 0x40, 0x4D, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x04, 0x40, 0xDB, 0x08, 0x20, 0x1C,
  0x07, 0x40, 0x6F, 0xFA, 0x06, 0x40, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x40, 0x40, 0xEF, 0xD0, 0xE0,
  0x44, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xD0, 0x14, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x40, 0x10,
  0xDB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x50, 0x10,
  0xCC, 0x05, 0x70, 0x9C, 0x0D, 0x03, 0x77, 0x40, 0x30, 0xDC, 0x09, 0x72, 0x0A, 0xD0, 0x77, 0x72,
  0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0D, 0x06, 0x75, 0x06, 0x0D, 0xD0, 0xA7, 0x60, 0x9F, 0x82, 0xB6,
  0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10,
  0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A,
  0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_crisis_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_crisis_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_delivery_dining 48x48, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_outlined_48_maps_delivery_dining_data[] PROGMEM = {
  0x77, 0x73, 0xE8, 0x1D, 0xA1, 0x77, 0x77, 0x3F, 0x90, 0xE0, 0x17, 0x5F, 0xB7, 0x1F, 0xA0, 0xA7,
  0x5F, 0xB7, 0x1F, 0xA0, 0xD7, 0x5F, 0xB7, 0x7C, 0x75, 0xFB, 0x77, 0xC8, 0x0C, 0x00, 0xC8, 0x0C,
  0x00, 0xC7, 0x38, 0x22, 0x8C, 0xEF, 0x97, 0x7C, 0x72, 0x09, 0xFD, 0x76, 0x03, 0xC7, 0x10, 0xBF,
  0xE7, 0x50, 0x10, 0xDB, 0x0E, 0x70, 0x9F, 0xF7, 0x50, 0xBC, 0x05, 0x60, 0x2C, 0x81, 0xD5, 0x14,
  0xC7, 0x40, 0x8C, 0x08, 0x70, 0x8B, 0x0D, 0x01, 0x6C, 0x73, 0x05, 0xC0, 0xB7, 0x10, 0xCB, 0x05,
  0x7C, 0x72, 0x03, 0x0E, 0xB0, 0xD0, 0x17, 0x10, 0xEB, 0x01, 0x7C, 0x71, 0x01, 0x0D, 0xB0, 0xE0,
  0x37, 0x2C, 0x71, 0xC7, 0x10, 0xBC, 0x86, 0x50, 0x6C, 0xEE, 0xC6, 0x3C, 0x71, 0xC7, 0x08, 0xC8,
  0x18, 0x1C, 0xE0, 0xC0, 0x11, 0xFF, 0xFE, 0x81, 0xB0, 0xCF, 0x90, 0xC1, 0xFF, 0xFD, 0x81, 0xD1,
  0x6F, 0xB0, 0x6F, 0xFF, 0xC8, 0x2E, 0x30, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xCF, 0xFF, 0xC0, 0x52,
  0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE4, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x50, 0xEB, 0x01, 0x20,
  0x1B, 0x0E, 0x40, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x50, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC4,
  0x06, 0xFB, 0x06, 0x75, 0x06, 0xFB, 0x06, 0x50, 0xCF, 0x90, 0xC7, 0x70, 0xCF, 0x90, 0xC6, 0x01,
  0x0C, 0xE0, 0xC0, 0x17, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x71, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x48,
  0x46, 0xCE, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_delivery_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_outlined_48_maps_delivery_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_departure_board 48x48, 4-bit Alpha,  RLE, 375 bytes.
static const unsigned char ic_outlined_48_maps_departure_board_data[] PROGMEM = {
  0x77, 0x74, 0x89, 0x03, 0x8B, 0xDF, 0xED, 0xB7, 0x37, 0x77, 0x74, 0x05, 0x0D, 0xFB, 0x0D, 0x05,
  0x77, 0x77, 0x02, 0x0C, 0xFF, 0x0C, 0x02, 0x77, 0x74, 0x04, 0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x77,
  0x20, 0x4E, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAE, 0x03, 0x77, 0x70, 0x20, 0xEC, 0x0A, 0x02, 0x71,
  0x02, 0x0A, 0xC0, 0xE0, 0x27, 0x18, 0x52, 0x68, 0xAB, 0xDE, 0xFB, 0x07, 0x4B, 0x50, 0x7C, 0x0C,
  0x58, 0x11, 0x7D, 0xFF, 0xA0, 0x75, 0xB6, 0x07, 0xC0, 0x53, 0x05, 0x0E, 0xFF, 0xB0, 0xA6, 0xB7,
  0x0A, 0xB0, 0xD2, 0x06, 0xFF, 0xD0, 0x26, 0xB7, 0x02, 0xC0, 0x30, 0x2D, 0x85, 0xEB, 0x75, 0x31,
  0x13, 0x08, 0xB0, 0xA7, 0xB7, 0x10, 0xAB, 0x07, 0x09, 0xB0, 0xE0, 0x67, 0x30, 0xBB, 0x05, 0x7B,
  0x71, 0x05, 0xB0, 0xB0, 0xDF, 0xFD, 0x02, 0x7B, 0x71, 0x02, 0xB0, 0xD0, 0xEF, 0xFD, 0x71, 0xB7,
  0x2B, 0x0E, 0xFF, 0xE7, 0x1B, 0x03, 0x71, 0xB0, 0xEF, 0xFE, 0x02, 0x7C, 0x09, 0x01, 0x50, 0x2B,
  0x0D, 0xC7, 0x50, 0xBB, 0x05, 0x70, 0x40, 0xDB, 0x0E, 0x07, 0x40, 0x5B, 0x0B, 0xC7, 0x50, 0x8B,
  0x0A, 0x72, 0x07, 0x0E, 0xB0, 0xD0, 0x32, 0x0A, 0xB0, 0x7C, 0x75, 0x03, 0xC0, 0x27, 0x20, 0x10,
  0xAB, 0x81, 0x50, 0x2C, 0x03, 0xC7, 0x60, 0xCB, 0x0A, 0x74, 0x81, 0x4D, 0xB2, 0x0A, 0xB0, 0xC1,
  0xC7, 0x60, 0x5C, 0x07, 0x75, 0x81, 0x10, 0x7C, 0x05, 0x1C, 0x77, 0x0C, 0xC0, 0x77, 0x50, 0x7C,
  0x0B, 0x2F, 0xFF, 0xB0, 0xA0, 0x27, 0x10, 0x20, 0xAC, 0x0E, 0x01, 0x2F, 0xFF, 0xD8, 0x1A, 0x52,
  0x28, 0x12, 0x5A, 0xD0, 0xE0, 0x43, 0x80, 0xC2, 0xF0, 0xE0, 0x34, 0x80, 0xC1, 0xF0, 0xB0, 0x15,
  0xC7, 0x75, 0x05, 0x0C, 0xFB, 0x0C, 0x05, 0x7C, 0x77, 0x78, 0x13, 0x7B, 0xC8, 0x1B, 0x73, 0x72,
  0xC3, 0x82, 0x8D, 0xD8, 0x73, 0x82, 0x8D, 0xD8, 0x3C, 0x75, 0xC2, 0x08, 0xC0, 0x87, 0x10, 0x8C,
  0x08, 0x2C, 0x75, 0xC2, 0x0D, 0xC0, 0xD7, 0x10, 0xDC, 0x0D, 0x2C, 0x75, 0xC2, 0x0D, 0xC0, 0xD7,
  0x10, 0xDC, 0x0D, 0x2C, 0x75, 0xC2, 0x08, 0xC0, 0x87, 0x10, 0x8C, 0x08, 0x2C, 0x75, 0xC3, 0x82,
  0x8D, 0xD8, 0x73, 0x82, 0x8D, 0xD8, 0x3C, 0x75, 0x0E, 0xB0, 0x27, 0x77, 0x10, 0x2B, 0x0E, 0x75,
  0x0C, 0xB0, 0xB7, 0x77, 0x10, 0xBB, 0x0C, 0x75, 0x06, 0xFF, 0xFF, 0xA0, 0x67, 0x60, 0xCF, 0xFF,
  0xF0, 0xC7, 0x70, 0x1F, 0xFF, 0xF0, 0x17, 0x71, 0xFF, 0xFF, 0x77, 0x2E, 0x77, 0x2E, 0x77, 0x2E,
  0x77, 0x2E, 0x77, 0x20, 0xDC, 0x0D, 0x77, 0x20, 0xDC, 0x0D, 0x77, 0x20, 0x40, 0xDA, 0x0D, 0x04,
  0x77, 0x20, 0x40, 0xDA, 0x0D, 0x04, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_departure_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_departure_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_design_services 48x48, 4-bit Alpha,  RLE, 422 bytes.
static const unsigned char ic_outlined_48_maps_design_services_data[] PROGMEM = {
  0x77, 0x76, 0x81, 0x16, 0x57, 0x58, 0x31, 0x9C, 0xC7, 0x77, 0x20, 0x10, 0xDA, 0x0A, 0x73, 0x03,
  0x0E, 0xC0, 0xC0, 0x17, 0x60, 0x10, 0xDC, 0x0A, 0x71, 0x03, 0x0E, 0xE0, 0xD0, 0x17, 0x40, 0x10,
  0xDE, 0x0A, 0x60, 0x30, 0xEF, 0x90, 0xD0, 0x17, 0x20, 0x10, 0xDF, 0x90, 0xA4, 0x03, 0x0E, 0xC0,
  0x70, 0xAC, 0x0D, 0x01, 0x70, 0x10, 0xDC, 0x0A, 0x0D, 0xC0, 0xA2, 0x01, 0x0E, 0xC0, 0x62, 0x0A,
  0xC0, 0xD0, 0x15, 0x01, 0x0D, 0xC8, 0x2A, 0x01, 0xDC, 0x81, 0xA0, 0x9C, 0x07, 0x40, 0xDC, 0x0D,
  0x01, 0x30, 0x10, 0xDC, 0x0A, 0x30, 0x10, 0xDC, 0x05, 0x0D, 0xB0, 0x74, 0x07, 0xE8, 0x3D, 0x10,
  0x1D, 0xD0, 0x64, 0x0A, 0xC0, 0x60, 0xCB, 0x0A, 0x30, 0x7F, 0x98, 0x1D, 0x3D, 0xF0, 0x62, 0x0A,
  0xC8, 0x1D, 0x18, 0xC0, 0xA2, 0x07, 0xB0, 0xE0, 0xBF, 0xF0, 0x60, 0xAC, 0x0D, 0x01, 0x20, 0xDC,
  0x0A, 0x28, 0x47, 0xFE, 0x30, 0xAF, 0x81, 0xA4, 0xEF, 0x90, 0xD0, 0x13, 0x01, 0x0D, 0xC0, 0xA2,
  0x06, 0x03, 0x30, 0xAD, 0x0A, 0x20, 0x40, 0xEE, 0x0D, 0x01, 0x50, 0x10, 0xDC, 0x0A, 0x50, 0x20,
  0xDC, 0x0A, 0x40, 0x4D, 0x0D, 0x01, 0x70, 0x10, 0xDC, 0x0A, 0x30, 0x20, 0xDC, 0x0A, 0x50, 0xAC,
  0x0D, 0x01, 0x72, 0x01, 0x0D, 0xC8, 0x2A, 0x02, 0xDC, 0x0A, 0x50, 0xAC, 0x0D, 0x01, 0x74, 0x01,
  0x0D, 0xC0, 0xA0, 0xDC, 0x0A, 0x50, 0xAC, 0x0D, 0x01, 0x76, 0x01, 0x0D, 0xF9, 0x0A, 0x50, 0xAC,
  0x0D, 0x01, 0x77, 0x10, 0x10, 0xDE, 0x0A, 0x50, 0xAD, 0x03, 0x77, 0x30, 0x3D, 0x0A, 0x50, 0xAE,
  0x0D, 0x01, 0x77, 0x10, 0x10, 0xDC, 0x0A, 0x50, 0xAF, 0x90, 0xD0, 0x17, 0x60, 0x10, 0xDC, 0x0A,
  0x50, 0xAC, 0x0D, 0x0B, 0xC0, 0xD0, 0x17, 0x40, 0x10, 0xDC, 0x0A, 0x50, 0xAC, 0x82, 0xD1, 0x0A,
  0xC0, 0xD0, 0x17, 0x20, 0x10, 0xDC, 0x0A, 0x50, 0xAC, 0x0D, 0x01, 0x30, 0xBC, 0x0D, 0x01, 0x70,
  0x10, 0xDC, 0x0A, 0x50, 0xAC, 0x0D, 0x01, 0x30, 0x30, 0xED, 0x0D, 0x01, 0x50, 0x10, 0xDC, 0x0A,
  0x50, 0xAD, 0x0A, 0x30, 0x30, 0xEF, 0x0D, 0x01, 0x30, 0x10, 0xDC, 0x0A, 0x50, 0xAF, 0x0A, 0x20,
  0x7C, 0x0C, 0xC0, 0xD2, 0x01, 0x0D, 0xC0, 0xA5, 0x0A, 0xFA, 0x0A, 0x20, 0x7A, 0x81, 0x60, 0xAC,
  0x81, 0x80, 0xDC, 0x0A, 0x50, 0xAC, 0x81, 0xD3, 0xDC, 0x0A, 0x20, 0x70, 0x63, 0x0A, 0xB0, 0xC1,
  0xC0, 0xA5, 0x0A, 0xC8, 0x3D, 0x10, 0x1D, 0xC0, 0xA6, 0x07, 0xB0, 0xD1, 0xC5, 0x0A, 0xC0, 0xD0,
  0x13, 0x01, 0x0D, 0xC0, 0xA4, 0x07, 0xC0, 0x91, 0xC4, 0x0A, 0xC0, 0xD0, 0x15, 0x01, 0x0D, 0xC0,
  0xA2, 0x07, 0xC0, 0xE0, 0x11, 0xC3, 0x0A, 0xC0, 0xD0, 0x17, 0x01, 0x0D, 0xC0, 0xA0, 0x7C, 0x0E,
  0x03, 0x2F, 0xC0, 0xD0, 0x17, 0x20, 0x10, 0xDF, 0x90, 0xE0, 0x33, 0xFB, 0x0D, 0x01, 0x74, 0x01,
  0x0D, 0xE0, 0xE0, 0x34, 0xFA, 0x0D, 0x01, 0x76, 0x01, 0x0C, 0xC0, 0xE0, 0x35, 0xF9, 0x0D, 0x01,
  0x77, 0x28, 0x37, 0xCD, 0x91, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_design_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 5, 42, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_design_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_diamond 48x48, 4-bit Alpha,  RLE, 287 bytes.
static const unsigned char ic_outlined_48_maps_diamond_data[] PROGMEM = {
  0x50, 0x3F, 0xFF, 0xF0, 0x37, 0x30, 0xBF, 0xFF, 0xF0, 0xB7, 0x20, 0x3F, 0xFF, 0xFA, 0x03, 0x71,
  0x0B, 0xFF, 0xFF, 0xA0, 0xB7, 0x03, 0xC0, 0x34, 0x07, 0xB0, 0xE4, 0x0E, 0xB0, 0x74, 0x03, 0xC0,
  0x36, 0x0B, 0xB0, 0xB5, 0x0E, 0xB0, 0x74, 0x07, 0xB0, 0xE5, 0x0B, 0xB0, 0xB5, 0x03, 0xC0, 0x34,
  0x07, 0xB0, 0xE6, 0x0E, 0xB0, 0x74, 0x03, 0xC0, 0x34, 0x0B, 0xB0, 0xB5, 0x0E, 0xB0, 0x76, 0x07,
  0xB0, 0xE5, 0x0B, 0xB0, 0xB3, 0x03, 0xC0, 0x34, 0x07, 0xB0, 0xE7, 0x10, 0xEB, 0x07, 0x40, 0x3C,
  0x03, 0x20, 0xBB, 0x0B, 0x50, 0xEB, 0x07, 0x71, 0x07, 0xB0, 0xE5, 0x0B, 0xB8, 0x1B, 0x03, 0x80,
  0xC2, 0xF0, 0x30, 0xB8, 0x0C, 0x2F, 0x0B, 0x09, 0x80, 0xC2, 0xF8, 0x19, 0x0B, 0x80, 0xC0, 0xF0,
  0xB2, 0x01, 0x0D, 0xC0, 0x47, 0x3C, 0x73, 0x04, 0xC0, 0xD0, 0x13, 0x02, 0x0E, 0xB0, 0xE0, 0x27,
  0x2C, 0x72, 0x02, 0x0E, 0xB0, 0xE0, 0x25, 0x04, 0xC0, 0xD0, 0x17, 0x1C, 0x71, 0x01, 0x0D, 0xC0,
  0x47, 0x06, 0xC0, 0xB7, 0x1C, 0x71, 0x0B, 0xC0, 0x67, 0x20, 0x9C, 0x09, 0x7C, 0x70, 0x9C, 0x09,
  0x74, 0x0B, 0xC0, 0x76, 0xC6, 0x07, 0xC0, 0xB7, 0x50, 0x10, 0xDC, 0x04, 0x5C, 0x50, 0x4C, 0x0D,
  0x01, 0x76, 0x02, 0x0E, 0xB0, 0xE0, 0x24, 0xC4, 0x02, 0x0E, 0xB0, 0xE0, 0x27, 0x71, 0x04, 0xC0,
  0xD0, 0x13, 0xC3, 0x01, 0x0D, 0xC0, 0x47, 0x73, 0x06, 0xC0, 0xB3, 0xC3, 0x0B, 0xC0, 0x67, 0x75,
  0x09, 0xC0, 0x92, 0xC2, 0x09, 0xC0, 0x97, 0x77, 0x0B, 0xC0, 0x71, 0xC1, 0x07, 0xC0, 0xB7, 0x77,
  0x10, 0x10, 0xDC, 0x04, 0xC0, 0x4C, 0x0D, 0x01, 0x77, 0x72, 0x02, 0x0E, 0xB0, 0xEC, 0x0E, 0xB0,
  0xE0, 0x27, 0x77, 0x40, 0x4F, 0xD0, 0x47, 0x77, 0x60, 0x6F, 0xB0, 0x67, 0x77, 0x71, 0x09, 0xF9,
  0x09, 0x77, 0x77, 0x30, 0xBE, 0x0B, 0x77, 0x77, 0x40, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x77, 0x50,
  0x20, 0xEA, 0x0E, 0x02, 0x77, 0x77, 0x70, 0x4A, 0x04, 0x80, 0xC1, 0x00, 0x06, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_diamond() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_diamond_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_dinner_dining 48x48, 4-bit Alpha,  RLE, 203 bytes.
static const unsigned char ic_outlined_48_maps_dinner_dining_data[] PROGMEM = {
  0x2F, 0xF0, 0xC0, 0x77, 0x77, 0x3F, 0xFA, 0x0B, 0x77, 0x72, 0xFF, 0xB0, 0x77, 0x77, 0x3B, 0x2B,
  0x4B, 0x0C, 0x77, 0x71, 0x00, 0x7B, 0x00, 0x7B, 0x80, 0x07, 0xC8, 0x09, 0x67, 0x48, 0x0C, 0x0F,
  0x48, 0x0C, 0x0F, 0x40, 0x07, 0xB0, 0x07, 0xB8, 0x00, 0x7C, 0x80, 0x96, 0x76, 0xB2, 0xB4, 0xB0,
  0xC7, 0x77, 0x1F, 0xFB, 0x07, 0x77, 0x71, 0xFF, 0xA0, 0xB7, 0x77, 0x2F, 0xF0, 0xC0, 0x77, 0x77,
  0x5B, 0x2B, 0x77, 0x77, 0x4B, 0x2B, 0x77, 0x77, 0x4B, 0x2B, 0x77, 0x77, 0x4B, 0x2B, 0x77, 0x77,
  0x4B, 0x2B, 0x77, 0x77, 0x4B, 0x2B, 0x77, 0x77, 0x4B, 0x2B, 0x72, 0x86, 0x6A, 0xDF, 0xED, 0xA5,
  0x77, 0x1B, 0x2B, 0x70, 0x70, 0xEF, 0x90, 0xE0, 0x77, 0x6B, 0x2B, 0x50, 0x10, 0xCF, 0xD0, 0xC0,
  0x17, 0x4B, 0x2B, 0x40, 0x10, 0xDF, 0xF0, 0xD0, 0x17, 0x3B, 0x2B, 0x40, 0xCC, 0x86, 0xE8, 0x31,
  0x02, 0x7E, 0xC0, 0xB7, 0x3B, 0x2B, 0x30, 0x7C, 0x0B, 0x71, 0x0A, 0xC0, 0x77, 0x2B, 0x06, 0x0B,
  0xB8, 0x2B, 0x61, 0xEB, 0x0A, 0x73, 0x0A, 0xB0, 0xE7, 0x2F, 0xF0, 0xE0, 0x17, 0x40, 0xEB, 0x05,
  0x71, 0xFF, 0xFF, 0xB0, 0x97, 0x08, 0xFF, 0xFF, 0xB0, 0xD6, 0x04, 0xFF, 0xFF, 0xC0, 0xE6, 0x0B,
  0xFF, 0xFF, 0xC0, 0xE8, 0x09, 0xA0, 0x00, 0x78, 0x0C, 0x2F, 0x81, 0x70, 0x78, 0x0C, 0x0F, 0x07,
  0x30, 0x7F, 0xFF, 0xFE, 0x07, 0x50, 0x7F, 0xFF, 0xFC, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_dinner_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_dinner_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_bike 48x48, 4-bit Alpha,  RLE, 440 bytes.
static const unsigned char ic_outlined_48_maps_directions_bike_data[] PROGMEM = {
  0x77, 0x77, 0x84, 0x1A, 0xDD, 0xA1, 0x80, 0xC5, 0x00, 0x10, 0xEC, 0x0E, 0x01, 0x80, 0xC4, 0x00,
  0xAE, 0x0A, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x0D, 0x80, 0xC4, 0x00, 0xAE,
  0x0A, 0x80, 0xC4, 0x00, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x77, 0x68, 0x93, 0x2B, 0xEE, 0xA3, 0x01,
  0xAD, 0xDA, 0x17, 0x77, 0x76, 0x02, 0x0E, 0xD0, 0x78, 0x0C, 0x30, 0x02, 0x0E, 0xF0, 0x78, 0x0C,
  0x10, 0x02, 0x0E, 0xFA, 0x07, 0x77, 0x77, 0x70, 0x20, 0xEF, 0xC0, 0x77, 0x77, 0x75, 0x02, 0x0E,
  0xFE, 0x09, 0x77, 0x77, 0x30, 0x20, 0xEF, 0x90, 0xE0, 0x7D, 0x0B, 0x03, 0x77, 0x77, 0x10, 0xDF,
  0x98, 0x2E, 0x20, 0x4E, 0x82, 0xB6, 0x21, 0x77, 0x73, 0x05, 0xF9, 0x0E, 0x02, 0x30, 0x30, 0xEF,
  0x90, 0x37, 0x77, 0x20, 0x8F, 0x0E, 0x02, 0x50, 0x20, 0xBF, 0x03, 0x77, 0x72, 0x07, 0xE0, 0xE0,
  0x27, 0x10, 0x50, 0xDD, 0x03, 0x77, 0x72, 0x02, 0xE0, 0xE0, 0x27, 0x38, 0x42, 0x7B, 0xDE, 0x37,
  0x77, 0x30, 0x40, 0xED, 0x0D, 0x02, 0x80, 0xC4, 0x00, 0x30, 0xED, 0x0D, 0x01, 0x77, 0x77, 0x18,
  0x65, 0xAD, 0xEE, 0xDA, 0x53, 0x02, 0x0D, 0xD0, 0xD0, 0x17, 0x18, 0x65, 0xAD, 0xEE, 0xDA, 0x57,
  0x30, 0x50, 0xDF, 0x90, 0xD0, 0x52, 0x01, 0x0C, 0xD0, 0xC6, 0x05, 0x0D, 0xF9, 0x0D, 0x05, 0x70,
  0x9F, 0xD0, 0x93, 0x0A, 0xD5, 0x09, 0xFD, 0x09, 0x50, 0x9B, 0x81, 0xE7, 0x32, 0x81, 0x37, 0xEB,
  0x09, 0x30, 0x8C, 0x40, 0x9B, 0x81, 0xE7, 0x32, 0x81, 0x37, 0xEB, 0x09, 0x30, 0x5B, 0x0B, 0x01,
  0x60, 0x10, 0xBB, 0x05, 0x3C, 0x30, 0x5B, 0x0B, 0x01, 0x60, 0x10, 0xBB, 0x05, 0x20, 0xDA, 0x0B,
  0x73, 0x0B, 0xA0, 0xD3, 0xC3, 0x0D, 0xA0, 0xB7, 0x30, 0xBA, 0x81, 0xD0, 0x5A, 0x0E, 0x01, 0x73,
  0x01, 0x0E, 0xA0, 0x52, 0xC2, 0x05, 0xA0, 0xE0, 0x17, 0x30, 0x10, 0xEA, 0x05, 0x0A, 0xA0, 0x77,
  0x50, 0x7A, 0x0A, 0x2C, 0x20, 0xAA, 0x07, 0x75, 0x07, 0xA0, 0xA0, 0xDA, 0x03, 0x75, 0x03, 0xA0,
  0xD2, 0xC2, 0x0D, 0xA0, 0x37, 0x50, 0x3A, 0x0D, 0x0E, 0xA7, 0x7A, 0x0E, 0x2C, 0x20, 0xEA, 0x77,
  0xA0, 0x0E, 0xA7, 0x7A, 0x0E, 0x2C, 0x20, 0xEA, 0x77, 0xA0, 0xE0, 0xDA, 0x03, 0x75, 0x03, 0xA0,
  0xD2, 0xC2, 0x0D, 0xA0, 0x37, 0x50, 0x3A, 0x0D, 0x0A, 0xA0, 0x77, 0x50, 0x7A, 0x0A, 0x2C, 0x20,
  0xAA, 0x07, 0x75, 0x07, 0xA0, 0xA0, 0x5A, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xA0, 0x52, 0xC2, 0x05,
  0xA0, 0xE0, 0x17, 0x30, 0x10, 0xEA, 0x81, 0x50, 0xDA, 0x0B, 0x73, 0x0B, 0xA0, 0xD7, 0x30, 0xDA,
  0x0B, 0x73, 0x0B, 0xA0, 0xD2, 0x05, 0xB0, 0xB0, 0x16, 0x01, 0x0B, 0xB0, 0x57, 0x30, 0x5B, 0x0B,
  0x01, 0x60, 0x10, 0xBB, 0x05, 0x30, 0x9B, 0x81, 0xE7, 0x32, 0x81, 0x37, 0xEB, 0x09, 0x75, 0x09,
  0xB8, 0x1E, 0x73, 0x28, 0x13, 0x7E, 0xB0, 0x95, 0x09, 0xFD, 0x09, 0x77, 0x09, 0xFD, 0x09, 0x70,
  0x50, 0xDF, 0x90, 0xD0, 0x57, 0x72, 0x05, 0x0D, 0xF9, 0x0D, 0x05, 0x73, 0x86, 0x5A, 0xDE, 0xED,
  0xA5, 0x77, 0x68, 0x65, 0xAD, 0xEE, 0xDA, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 47, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_boat_filled 48x48, 4-bit Alpha,  RLE, 347 bytes.
static const unsigned char ic_outlined_48_maps_directions_boat_filled_data[] PROGMEM = {
  0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77,
  0xFD, 0x77, 0x58, 0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xF0, 0xE0,
  0x17, 0x10, 0xAF, 0xFF, 0xFA, 0x0A, 0x71, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x1C, 0x77, 0x73, 0xC7,
  0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x72, 0x84, 0x27,
  0xDD, 0x72, 0x72, 0xC7, 0x1C, 0x68, 0x13, 0x8D, 0xE8, 0x1D, 0x83, 0x6C, 0x71, 0xC3, 0x81, 0x38,
  0xDF, 0xD8, 0x1D, 0x83, 0x3C, 0x71, 0xC8, 0x13, 0x8D, 0xFF, 0xC8, 0x1D, 0x83, 0xC7, 0x1F, 0xF8,
  0x2B, 0x55, 0xBF, 0xF6, 0x04, 0x09, 0xFB, 0x81, 0xEA, 0x56, 0x05, 0x0A, 0xFC, 0x09, 0x04, 0x20,
  0x40, 0xEF, 0xA8, 0x1E, 0xA5, 0x75, 0x81, 0x5A, 0xEF, 0xA8, 0x1E, 0x4D, 0xF8, 0x1E, 0x95, 0x77,
  0x48, 0x15, 0xAE, 0xF0, 0xD0, 0xEC, 0x81, 0xE9, 0x47, 0x77, 0x38, 0x15, 0x9E, 0xC0, 0xE0, 0xAB,
  0x09, 0x77, 0x77, 0x20, 0x9B, 0x0A, 0x05, 0xB0, 0xC7, 0x77, 0x72, 0x0C, 0xB0, 0x60, 0x1C, 0x01,
  0x77, 0x77, 0x01, 0xC8, 0x11, 0x0C, 0xB0, 0x55, 0x00, 0x77, 0x70, 0x07, 0x50, 0x5B, 0x0C, 0x20,
  0x8B, 0x09, 0x40, 0x5A, 0x05, 0x75, 0x05, 0xA0, 0x54, 0x09, 0xB0, 0x82, 0x03, 0xB0, 0xE3, 0x04,
  0xC0, 0x47, 0x30, 0x4C, 0x04, 0x30, 0xEB, 0x03, 0x30, 0xEB, 0x82, 0x30, 0x3E, 0xC0, 0xE0, 0x37,
  0x10, 0x30, 0xEC, 0x82, 0xE3, 0x03, 0xB0, 0xE4, 0x0A, 0xB8, 0x17, 0x4E, 0xE0, 0xE0, 0x46, 0x04,
  0x0E, 0xE8, 0x1E, 0x47, 0xB0, 0xA4, 0x05, 0xB0, 0xEF, 0xB0, 0xA0, 0x32, 0x03, 0x09, 0xFB, 0x0E,
  0xB0, 0x54, 0x01, 0xF9, 0x00, 0x7F, 0xF0, 0x07, 0xF9, 0x01, 0x50, 0xCE, 0x06, 0x20, 0x6F, 0xD0,
  0x62, 0x06, 0xE0, 0xC6, 0x08, 0xC0, 0xC0, 0x24, 0x02, 0x0C, 0xF9, 0x0C, 0x02, 0x40, 0x20, 0xCC,
  0x08, 0x68, 0x33, 0xEC, 0x93, 0x71, 0x86, 0x39, 0xCE, 0xEC, 0x93, 0x71, 0x83, 0x39, 0xCE, 0x38,
  0x0E, 0x20, 0x00, 0x57, 0x70, 0x05, 0x77, 0x60, 0x30, 0xBA, 0x0B, 0x04, 0x73, 0x04, 0x0B, 0xA0,
  0xB0, 0x37, 0x78, 0x21, 0x48, 0xCE, 0x89, 0x0D, 0x85, 0x31, 0x13, 0x58, 0xDE, 0x82, 0xC8, 0x41,
  0x58, 0x09, 0xA6, 0xF8, 0x2A, 0x33, 0xAF, 0xD8, 0x2A, 0x33, 0xAF, 0xF9, 0x83, 0xDC, 0x95, 0x15,
  0x89, 0x05, 0x8B, 0xDE, 0xED, 0xB8, 0x55, 0x83, 0x15, 0x9C, 0xDD,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_boat_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_boat_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_boat 48x48, 4-bit Alpha,  RLE, 348 bytes.
static const unsigned char ic_outlined_48_maps_directions_boat_data[] PROGMEM = {
  0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xC4, 0xC7, 0x77,
  0x7C, 0x4C, 0x77, 0x58, 0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xF0,
  0xE0, 0x17, 0x10, 0xAF, 0xFF, 0xFA, 0x0A, 0x71, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x1C, 0x77, 0x73,
  0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x72, 0x84,
  0x27, 0xDD, 0x72, 0x72, 0xC7, 0x1C, 0x68, 0x13, 0x8D, 0xE8, 0x1D, 0x83, 0x6C, 0x71, 0xC3, 0x81,
  0x38, 0xDF, 0xD8, 0x1D, 0x83, 0x3C, 0x71, 0xC8, 0x13, 0x8D, 0xFF, 0xC8, 0x1D, 0x83, 0xC7, 0x1F,
  0xF8, 0x2B, 0x55, 0xBF, 0xF6, 0x04, 0x09, 0xFB, 0x81, 0xEA, 0x55, 0x81, 0x15, 0xAF, 0xC0, 0x90,
  0x42, 0x04, 0x0E, 0xFA, 0x81, 0xEA, 0x57, 0x58, 0x15, 0xAE, 0xFA, 0x81, 0xE4, 0xDF, 0x81, 0xE9,
  0x47, 0x74, 0x81, 0x5A, 0xEF, 0x0D, 0x0E, 0xC8, 0x1E, 0x94, 0x77, 0x73, 0x81, 0x5A, 0xEC, 0x0D,
  0x0A, 0xB0, 0x97, 0x77, 0x72, 0x09, 0xB0, 0x90, 0x5B, 0x0C, 0x77, 0x77, 0x20, 0xCB, 0x05, 0x01,
  0xC0, 0x17, 0x77, 0x70, 0x1C, 0x81, 0x10, 0xCB, 0x05, 0x50, 0x07, 0x77, 0x00, 0x75, 0x05, 0xB0,
  0xC2, 0x08, 0xB0, 0x94, 0x05, 0xA0, 0x57, 0x50, 0x5A, 0x05, 0x40, 0x9B, 0x07, 0x20, 0x3B, 0x0E,
  0x30, 0x4C, 0x04, 0x73, 0x04, 0xC0, 0x43, 0x0E, 0xB0, 0x33, 0x0E, 0xB8, 0x23, 0x03, 0xEC, 0x0E,
  0x03, 0x71, 0x03, 0x0E, 0xC8, 0x2E, 0x30, 0x3B, 0x0E, 0x40, 0xAB, 0x81, 0x75, 0xEE, 0x0E, 0x04,
  0x60, 0x40, 0xEE, 0x81, 0xE4, 0x7B, 0x0A, 0x40, 0x5B, 0x0E, 0xFB, 0x84, 0xA4, 0x11, 0x4A, 0xFB,
  0x0E, 0xB0, 0x54, 0x01, 0xF9, 0x00, 0x7F, 0xF0, 0x07, 0xF9, 0x01, 0x50, 0xCE, 0x06, 0x20, 0x6F,
  0xD0, 0x62, 0x06, 0xE0, 0xC6, 0x08, 0xC0, 0xC0, 0x24, 0x02, 0x0C, 0xF9, 0x0C, 0x02, 0x40, 0x20,
  0xCC, 0x08, 0x68, 0x33, 0xEC, 0x93, 0x71, 0x86, 0x39, 0xCE, 0xEC, 0x93, 0x71, 0x83, 0x39, 0xCE,
  0x38, 0x0E, 0x20, 0x00, 0x57, 0x70, 0x05, 0x77, 0x60, 0x30, 0xBA, 0x0B, 0x04, 0x73, 0x04, 0x0B,
  0xA0, 0xB0, 0x37, 0x78, 0x21, 0x48, 0xCE, 0x89, 0x0D, 0x85, 0x31, 0x13, 0x58, 0xDE, 0x82, 0xC8,
  0x41, 0x58, 0x09, 0xA6, 0xF8, 0x2A, 0x33, 0xAF, 0xD8, 0x2A, 0x33, 0xAF, 0xF9, 0x83, 0xDC, 0x95,
  0x15, 0x89, 0x05, 0x8B, 0xDE, 0xED, 0xB8, 0x55, 0x83, 0x15, 0x9C, 0xDD,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_boat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_boat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_bus_filled 48x48, 4-bit Alpha,  RLE, 200 bytes.
static const unsigned char ic_outlined_48_maps_directions_bus_filled_data[] PROGMEM = {
  0x78, 0x45, 0x79, 0xBD, 0xDE, 0x85, 0xED, 0xBA, 0x86, 0x27, 0x30, 0x50, 0xBF, 0xFE, 0x81, 0xD8,
  0x15, 0x04, 0x0D, 0xFF, 0xFB, 0x0E, 0x06, 0x30, 0x5F, 0xFF, 0xF8, 0x27, 0x01, 0xED, 0x84, 0xC8,
  0x64, 0x21, 0x68, 0x51, 0x13, 0x57, 0xAE, 0xD0, 0x20, 0x8C, 0x09, 0x01, 0x77, 0x50, 0x60, 0xEB,
  0x09, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xEF, 0xFF, 0xFA, 0x0E, 0x80, 0x98, 0x0F, 0x77, 0x73, 0xF9,
  0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0x80, 0xA8,
  0x4F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x83, 0xF9,
  0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xF9,
  0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xF9, 0x81, 0x10, 0x8C, 0x08, 0x71, 0x08, 0xC8, 0x18,
  0x01, 0xC0, 0xEB, 0x05, 0x28, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x82, 0x05, 0xB0, 0xE0, 0xCB,
  0x0D, 0x01, 0x77, 0x60, 0x10, 0xDB, 0x0C, 0x07, 0xC8, 0x1D, 0x51, 0x77, 0x28, 0x11, 0x5D, 0xC8,
  0x17, 0x1E, 0xFF, 0xFF, 0x82, 0xE1, 0x04, 0xFF, 0xFF, 0x04, 0x3F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4E,
  0x77, 0x2E, 0x4E, 0x77, 0x2E, 0x40, 0xDC, 0x0D, 0x77, 0x20, 0xDC, 0x0D, 0x40, 0x40, 0xDA, 0x0D,
  0x04, 0x77, 0x20, 0x40, 0xDA, 0x0D, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_bus_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_bus_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_bus 48x48, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_outlined_48_maps_directions_bus_data[] PROGMEM = {
  0x68, 0x52, 0x68, 0xAB, 0xDE, 0xE8, 0x5E, 0xDB, 0xA8, 0x62, 0x72, 0x81, 0x17, 0xDF, 0xFE, 0x81,
  0xD8, 0x15, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x06, 0x30, 0x6F, 0xFF, 0xF8, 0x17, 0x02, 0xD8, 0x5E,
  0xB7, 0x53, 0x11, 0x68, 0x51, 0x13, 0x57, 0xBE, 0xD0, 0x20, 0x9B, 0x0E, 0x06, 0x77, 0x60, 0x60,
  0xEB, 0x09, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xEF, 0xFF, 0xFA, 0x0E, 0x80, 0x98, 0x0F, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0x80,
  0xA8, 0x4F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x83,
  0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2,
  0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82,
  0xF9, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x83, 0xC0, 0xEB, 0x02, 0x77, 0x71, 0x02, 0xB0,
  0xE0, 0xCB, 0x0B, 0x77, 0x71, 0x0B, 0xB0, 0xC0, 0x6F, 0xFF, 0xFA, 0x81, 0x60, 0xCF, 0xFF, 0xF0,
  0xC2, 0x01, 0xFF, 0xFF, 0x01, 0x3F, 0xFF, 0xF4, 0xE7, 0x72, 0xE4, 0xE7, 0x72, 0xE4, 0x0D, 0xC0,
  0xD7, 0x72, 0x0D, 0xC0, 0xD4, 0x04, 0x0D, 0xA0, 0xD0, 0x47, 0x72, 0x04, 0x0D, 0xA0, 0xD0, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_bus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_bus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_car_filled 48x48, 4-bit Alpha,  RLE, 172 bytes.
static const unsigned char ic_outlined_48_maps_directions_car_filled_data[] PROGMEM = {
  0x50, 0x80, 0xEF, 0xFF, 0x90, 0xE0, 0x87, 0x20, 0x8F, 0xFF, 0xD0, 0x87, 0x10, 0xEF, 0xFF, 0xD0,
  0xE7, 0x05, 0xFF, 0xFF, 0x05, 0x60, 0xAB, 0x08, 0x77, 0x60, 0x8B, 0x0A, 0x50, 0x1C, 0x02, 0x77,
  0x60, 0x3C, 0x01, 0x40, 0x6B, 0x0C, 0x77, 0x71, 0x0D, 0xB0, 0x64, 0x0B, 0xB0, 0x77, 0x77, 0x10,
  0x7B, 0x0B, 0x30, 0x1C, 0x02, 0x77, 0x71, 0x02, 0xC0, 0x12, 0x06, 0xB0, 0xC7, 0x77, 0x30, 0xCB,
  0x06, 0x20, 0xCF, 0xFF, 0xFC, 0x81, 0xC0, 0x2F, 0xFF, 0xFE, 0x02, 0x07, 0xFF, 0xFF, 0xE0, 0x70,
  0xCF, 0xFF, 0xFE, 0x0C, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82,
  0x8D, 0xD8, 0x3F, 0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F, 0x92, 0x0D, 0xC0, 0xD7, 0x50,
  0xDC, 0x0D, 0x2F, 0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F, 0x92, 0x08, 0xC0, 0x87, 0x50,
  0x8C, 0x08, 0x2F, 0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x78, 0x0A, 0xA6, 0xF7, 0x77, 0x3F, 0xD7, 0x77, 0x3E, 0x0D, 0xC0, 0xD7, 0x77, 0x30, 0xDC,
  0x81, 0xD4, 0xDA, 0x0D, 0x04, 0x77, 0x73, 0x04, 0x0D, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_car_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_car_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_car 48x48, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_outlined_48_maps_directions_car_data[] PROGMEM = {
  0x50, 0x80, 0xEF, 0xFF, 0x90, 0xE0, 0x87, 0x20, 0x8F, 0xFF, 0xD0, 0x87, 0x10, 0xEF, 0xFF, 0xD0,
  0xE7, 0x05, 0xFF, 0xFF, 0x05, 0x60, 0xAB, 0x08, 0x77, 0x60, 0x8B, 0x0A, 0x50, 0x1C, 0x02, 0x77,
  0x60, 0x3C, 0x01, 0x40, 0x6B, 0x0C, 0x77, 0x71, 0x0D, 0xB0, 0x64, 0x0B, 0xB0, 0x77, 0x77, 0x10,
  0x7B, 0x0B, 0x30, 0x1C, 0x02, 0x77, 0x71, 0x02, 0xC0, 0x12, 0x06, 0xB0, 0xC7, 0x77, 0x30, 0xCB,
  0x06, 0x20, 0xCB, 0x0D, 0x80, 0xA4, 0xB0, 0xDB, 0x81, 0xC0, 0x2F, 0xFF, 0xFE, 0x02, 0x07, 0xFF,
  0xFF, 0xE0, 0x70, 0xCF, 0xFF, 0xFE, 0x0C, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x93, 0x82, 0x8D,
  0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F, 0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F, 0x92, 0x0D,
  0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F, 0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F, 0x92, 0x08,
  0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F, 0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x78, 0x0A, 0xA6, 0xF7, 0x77, 0x3F, 0xD7, 0x77, 0x3E, 0x0D, 0xC0, 0xD7,
  0x77, 0x30, 0xDC, 0x81, 0xD4, 0xDA, 0x0D, 0x04, 0x77, 0x73, 0x04, 0x0D, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_car() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_car_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions 48x48, 4-bit Alpha,  RLE, 417 bytes.
static const unsigned char ic_outlined_48_maps_directions_data[] PROGMEM = {
  0x77, 0x58, 0x41, 0x9D, 0xDA, 0x18, 0x0C, 0x10, 0x03, 0x0E, 0xC0, 0xE0, 0x37, 0x77, 0x77, 0x03,
  0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x75, 0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x30, 0x30, 0xEC,
  0x00, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x76,
  0x03, 0x0E, 0xC0, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x60, 0x7C, 0x0E,
  0x03, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x70, 0x30, 0xEC, 0x07,
  0x73, 0x07, 0xC0, 0xE0, 0x37, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x50, 0x7C, 0x0E, 0x03, 0x77, 0x30,
  0x30, 0xEC, 0x07, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xC0,
  0xE0, 0x37, 0x60, 0x30, 0xEC, 0x07, 0x76, 0x07, 0x40, 0x7C, 0x0E, 0x03, 0x74, 0x03, 0x0E, 0xC0,
  0x77, 0x79, 0x07, 0x40, 0x7C, 0x0E, 0x03, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0xA0, 0x74, 0x07,
  0xC0, 0xE0, 0x37, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0xB0, 0x74, 0x07, 0xC0, 0xE0, 0x35, 0x03, 0x0E,
  0xC0, 0x77, 0x73, 0xC0, 0x74, 0x07, 0xC0, 0xE0, 0x33, 0x03, 0x0E, 0xC0, 0x76, 0x04, 0x0D, 0xFF,
  0x90, 0x74, 0x07, 0xC8, 0x3E, 0x30, 0x1E, 0xC0, 0x77, 0x0D, 0xFF, 0xB0, 0x74, 0x07, 0xC8, 0x1E,
  0x1A, 0xC0, 0x77, 0x1F, 0xFC, 0x07, 0x50, 0x7C, 0x0A, 0x0D, 0xB0, 0x77, 0x2F, 0xFB, 0x07, 0x70,
  0x7B, 0x00, 0xDB, 0x08, 0x72, 0xC7, 0x1C, 0x07, 0x71, 0x07, 0xB0, 0xD0, 0x9C, 0x08, 0x71, 0xC7,
  0x1B, 0x07, 0x71, 0x07, 0xC8, 0x19, 0x1E, 0xC0, 0x87, 0xC7, 0x1A, 0x07, 0x71, 0x07, 0xC8, 0x3E,
  0x10, 0x3E, 0xC0, 0x86, 0xC7, 0x19, 0x07, 0x71, 0x07, 0xC0, 0xE0, 0x33, 0x03, 0x0E, 0xC0, 0x85,
  0xC7, 0x10, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x50, 0x30, 0xEC, 0x08, 0x4C, 0x77, 0x20, 0x7C, 0x0E,
  0x03, 0x70, 0x30, 0xEC, 0x08, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x20, 0x30, 0xEC, 0x08, 0x77,
  0x60, 0x7C, 0x0E, 0x03, 0x74, 0x03, 0x0E, 0xC0, 0x87, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x60, 0x30,
  0xEC, 0x08, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x10, 0x30, 0xEC, 0x08, 0x77, 0x07, 0xC0, 0xE0,
  0x37, 0x73, 0x03, 0x0E, 0xC0, 0x87, 0x50, 0x7C, 0x0E, 0x03, 0x77, 0x50, 0x30, 0xEC, 0x08, 0x73,
  0x07, 0xC0, 0xE0, 0x37, 0x77, 0x03, 0x0E, 0xC0, 0x87, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x72, 0x03,
  0x0E, 0xC0, 0x86, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0x30, 0xEC, 0x08, 0x40, 0x7C, 0x0E, 0x03,
  0x77, 0x76, 0x03, 0x0E, 0xC0, 0x82, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x80,
  0x7C, 0x0E, 0x03, 0x77, 0x77, 0x30, 0x30, 0xEF, 0x90, 0xE0, 0x37, 0x77, 0x75, 0x03, 0x0E, 0xE0,
  0xE0, 0x37, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0xE0, 0x38, 0x0C, 0x10, 0x84, 0x29, 0xDD, 0x91, 0x77,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_railway_filled 48x48, 4-bit Alpha,  RLE, 184 bytes.
static const unsigned char ic_outlined_48_maps_directions_railway_filled_data[] PROGMEM = {
  0x78, 0x45, 0x79, 0xBD, 0xDE, 0x85, 0xED, 0xBA, 0x86, 0x27, 0x30, 0x50, 0xBF, 0xFE, 0x81, 0xD8,
  0x15, 0x04, 0x0D, 0xFF, 0xFB, 0x0E, 0x06, 0x30, 0x5F, 0xFF, 0xF8, 0x27, 0x01, 0xED, 0x84, 0xC8,
  0x64, 0x21, 0x68, 0x51, 0x13, 0x57, 0xAE, 0xD0, 0x20, 0x8C, 0x09, 0x01, 0x77, 0x50, 0x60, 0xEB,
  0x09, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xEF, 0xFF, 0xFA, 0x0E, 0x80, 0x98, 0x0F, 0x77, 0x73, 0xF9,
  0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0x80, 0xA8,
  0x4F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x73, 0x82, 0x8D, 0xD8, 0x73, 0xF9, 0x72, 0x08, 0xC0,
  0x87, 0x2F, 0x97, 0x20, 0xDC, 0x0D, 0x72, 0xF9, 0x72, 0x0D, 0xC0, 0xD7, 0x2F, 0x97, 0x20, 0x8C,
  0x08, 0x72, 0xC0, 0xEB, 0x01, 0x72, 0x82, 0x8D, 0xD8, 0x72, 0x01, 0xB0, 0xE0, 0xCB, 0x07, 0x77,
  0x71, 0x07, 0xB0, 0xC0, 0x7C, 0x07, 0x01, 0x77, 0x40, 0x10, 0x7C, 0x81, 0x71, 0xEF, 0xFF, 0xF8,
  0x2E, 0x10, 0x5F, 0xFF, 0xF0, 0x53, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x58, 0x21, 0x7C, 0xEF,
  0xFC, 0x82, 0xEC, 0x71, 0x71, 0x01, 0x0A, 0xFF, 0xC0, 0xA0, 0x17, 0x20, 0x50, 0xEF, 0xFE, 0x0E,
  0x05, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_railway_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_railway_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_railway 48x48, 4-bit Alpha,  RLE, 197 bytes.
static const unsigned char ic_outlined_48_maps_directions_railway_data[] PROGMEM = {
  0x68, 0x52, 0x68, 0xAB, 0xDE, 0xE8, 0x5E, 0xDB, 0xA8, 0x62, 0x72, 0x81, 0x17, 0xDF, 0xFE, 0x81,
  0xD8, 0x15, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x06, 0x30, 0x6F, 0xFF, 0xF8, 0x17, 0x02, 0xD8, 0x5E,
  0xB8, 0x53, 0x11, 0x68, 0x51, 0x13, 0x57, 0xAE, 0xD0, 0x20, 0x9B, 0x0E, 0x06, 0x77, 0x60, 0x60,
  0xEB, 0x09, 0x0D, 0xB0, 0x57, 0x77, 0x10, 0x5B, 0x0D, 0x0E, 0xB7, 0x77, 0x20, 0x1B, 0x0E, 0x80,
  0xA8, 0x0F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0x80, 0xA8, 0x4F, 0x77, 0x73, 0xF9, 0x72, 0x84, 0x1A, 0xDD, 0xA1, 0x72, 0xF9,
  0x71, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x1F, 0x97, 0x10, 0xAE, 0x0A, 0x71, 0xF9, 0x71, 0x0D, 0xE0,
  0xD7, 0x1F, 0x97, 0x10, 0xDE, 0x0D, 0x71, 0xF9, 0x71, 0x0A, 0xE0, 0xA7, 0x1C, 0x0E, 0xB0, 0x17,
  0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x01, 0xB0, 0xE0, 0xCB, 0x07, 0x71, 0x84, 0x1A, 0xDD, 0xA1, 0x71,
  0x07, 0xB0, 0xC0, 0x7C, 0x07, 0x01, 0x77, 0x40, 0x10, 0x7C, 0x81, 0x71, 0xEF, 0xFF, 0xF8, 0x2E,
  0x10, 0x5F, 0xFF, 0xF0, 0x53, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x58, 0x21, 0x7C, 0xEF, 0xFC,
  0x82, 0xEC, 0x71, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40, 0x7F, 0xFE, 0x07, 0x72, 0x07, 0xFF, 0xF9,
  0x07, 0x71, 0xFF, 0xFB, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_railway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_railway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_run 48x48, 4-bit Alpha,  RLE, 236 bytes.
static const unsigned char ic_outlined_48_maps_directions_run_data[] PROGMEM = {
  0x77, 0x58, 0x42, 0xAE, 0xEA, 0x17, 0x77, 0x50, 0x20, 0xEC, 0x0E, 0x01, 0x77, 0x74, 0x0A, 0xE0,
  0x97, 0x77, 0x40, 0xEE, 0x0D, 0x77, 0x74, 0x0E, 0xE0, 0xD7, 0x77, 0x40, 0xAE, 0x09, 0x77, 0x74,
  0x01, 0x0E, 0xC0, 0xD0, 0x17, 0x77, 0x58, 0x41, 0x9D, 0xD9, 0x18, 0x0E, 0x40, 0x85, 0x17, 0xCF,
  0xEA, 0x17, 0x77, 0x30, 0x30, 0x9E, 0x0D, 0x01, 0x77, 0x70, 0x50, 0xCF, 0xA0, 0xB7, 0x74, 0x81,
  0x17, 0xEF, 0xD0, 0x57, 0x72, 0x0A, 0xFF, 0x90, 0xE0, 0x17, 0x71, 0xF0, 0xEF, 0xA0, 0x97, 0x71,
  0xC8, 0x2E, 0x82, 0x8F, 0xB0, 0x67, 0x7C, 0x30, 0xBF, 0xC0, 0x67, 0x6C, 0x30, 0xEF, 0xD0, 0xA0,
  0x27, 0x4C, 0x20, 0x2F, 0x0D, 0x06, 0xE8, 0x2A, 0x53, 0x17, 0xC2, 0x05, 0xF8, 0x1A, 0x05, 0xFA,
  0x7C, 0x20, 0x8F, 0x07, 0x20, 0x30, 0xCF, 0x7C, 0x20, 0xBF, 0x04, 0x40, 0x60, 0xCD, 0x7C, 0x20,
  0xEF, 0x01, 0x68, 0x32, 0x7A, 0xCD, 0x75, 0x02, 0xF0, 0xD7, 0x77, 0x30, 0x5F, 0x90, 0x57, 0x77,
  0x20, 0x8F, 0xA0, 0x67, 0x77, 0x10, 0xBF, 0xB0, 0x67, 0x77, 0x0E, 0xB0, 0xA0, 0x9E, 0x07, 0x77,
  0x50, 0x2C, 0x81, 0x60, 0x9E, 0x72, 0x83, 0x8D, 0xA6, 0x35, 0x05, 0xC0, 0x32, 0x08, 0xD7, 0x20,
  0xBD, 0x83, 0xC9, 0x63, 0x8B, 0x0E, 0x40, 0x7C, 0x72, 0x0E, 0xFE, 0x0B, 0x5C, 0x71, 0x01, 0xFF,
  0x08, 0x5C, 0x72, 0x83, 0x14, 0x7A, 0xEF, 0xA0, 0x45, 0xC7, 0x78, 0x31, 0x47, 0xAE, 0xC0, 0x15,
  0xC7, 0x75, 0x82, 0x14, 0x79, 0x6C, 0x77, 0x77, 0x1C, 0x77, 0x77, 0x1C, 0x77, 0x77, 0x1C, 0x77,
  0x77, 0x1C, 0x77, 0x77, 0x1C, 0x77, 0x77, 0x1C, 0x77, 0x77, 0x1C, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_run() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_run_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_subway_filled 48x48, 4-bit Alpha,  RLE, 203 bytes.
static const unsigned char ic_outlined_48_maps_directions_subway_filled_data[] PROGMEM = {
  0x78, 0x45, 0x79, 0xBD, 0xDE, 0x85, 0xED, 0xBA, 0x86, 0x27, 0x30, 0x50, 0xBF, 0xFE, 0x81, 0xD8,
  0x15, 0x04, 0x0D, 0xFF, 0xFB, 0x0E, 0x06, 0x30, 0x5F, 0xFF, 0xF8, 0x27, 0x01, 0xED, 0x84, 0xC8,
  0x64, 0x21, 0x68, 0x51, 0x13, 0x57, 0xAE, 0xD0, 0x20, 0x8C, 0x09, 0x01, 0x77, 0x50, 0x60, 0xEB,
  0x09, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xEF, 0xFF, 0xFA, 0x0E, 0x80, 0x98, 0x0F, 0x73, 0xC7, 0x3F,
  0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C,
  0x73, 0x80, 0xA8, 0x4F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28,
  0xDD, 0x83, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D,
  0xC0, 0xD2, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08,
  0xC0, 0x82, 0xC0, 0xEB, 0x01, 0x28, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x82, 0x01, 0xB0, 0xE0,
  0xCB, 0x07, 0x77, 0x71, 0x07, 0xB0, 0xC0, 0x7C, 0x07, 0x01, 0x77, 0x40, 0x10, 0x7C, 0x81, 0x71,
  0xEF, 0xFF, 0xF8, 0x2E, 0x10, 0x5F, 0xFF, 0xF0, 0x53, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x58,
  0x21, 0x7C, 0xEF, 0xFC, 0x82, 0xEC, 0x71, 0x71, 0x01, 0x0A, 0xFF, 0xC0, 0xA0, 0x17, 0x20, 0x50,
  0xEF, 0xFE, 0x0E, 0x05, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_subway_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_subway_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_subway 48x48, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_outlined_48_maps_directions_subway_data[] PROGMEM = {
  0x78, 0x45, 0x79, 0xBD, 0xDE, 0x85, 0xED, 0xBA, 0x86, 0x27, 0x30, 0x50, 0xBF, 0xFE, 0x81, 0xD8,
  0x15, 0x04, 0x0D, 0xFF, 0xFB, 0x0E, 0x06, 0x30, 0x5F, 0xFF, 0xF8, 0x27, 0x01, 0xED, 0x84, 0xC8,
  0x64, 0x21, 0x68, 0x51, 0x13, 0x57, 0xBE, 0xD0, 0x20, 0x8C, 0x09, 0x01, 0x77, 0x50, 0x60, 0xEB,
  0x09, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xEF, 0xFF, 0xFA, 0x0E, 0x80, 0x98, 0x0F, 0x73, 0xC7, 0x3F,
  0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C,
  0x73, 0x80, 0xA8, 0x4F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28,
  0xDD, 0x83, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D,
  0xC0, 0xD2, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08,
  0xC0, 0x82, 0xC0, 0xEB, 0x01, 0x28, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x82, 0x01, 0xB0, 0xE0,
  0xCB, 0x07, 0x77, 0x71, 0x07, 0xB0, 0xC0, 0x7C, 0x07, 0x01, 0x77, 0x40, 0x10, 0x7C, 0x81, 0x71,
  0xEF, 0xFF, 0xF8, 0x2E, 0x10, 0x5F, 0xFF, 0xF0, 0x53, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x58,
  0x21, 0x7C, 0xEF, 0xFC, 0x82, 0xEC, 0x71, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40, 0x7F, 0xFE, 0x07,
  0x72, 0x07, 0xFF, 0xF9, 0x07, 0x71, 0xFF, 0xFB, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_subway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_subway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_transit_filled 48x48, 4-bit Alpha,  RLE, 203 bytes.
static const unsigned char ic_outlined_48_maps_directions_transit_filled_data[] PROGMEM = {
  0x78, 0x45, 0x79, 0xBD, 0xDE, 0x85, 0xED, 0xBA, 0x86, 0x27, 0x30, 0x50, 0xBF, 0xFE, 0x81, 0xD8,
  0x15, 0x04, 0x0D, 0xFF, 0xFB, 0x0E, 0x06, 0x30, 0x5F, 0xFF, 0xF8, 0x27, 0x01, 0xED, 0x84, 0xC8,
  0x64, 0x21, 0x68, 0x51, 0x13, 0x57, 0xAE, 0xD0, 0x20, 0x8C, 0x09, 0x01, 0x77, 0x50, 0x60, 0xEB,
  0x09, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xEF, 0xFF, 0xFA, 0x0E, 0x80, 0x98, 0x0F, 0x73, 0xC7, 0x3F,
  0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C,
  0x73, 0x80, 0xA8, 0x4F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28,
  0xDD, 0x83, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D,
  0xC0, 0xD2, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08,
  0xC0, 0x82, 0xC0, 0xEB, 0x01, 0x28, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x82, 0x01, 0xB0, 0xE0,
  0xCB, 0x07, 0x77, 0x71, 0x07, 0xB0, 0xC0, 0x7C, 0x07, 0x01, 0x77, 0x40, 0x10, 0x7C, 0x81, 0x71,
  0xEF, 0xFF, 0xF8, 0x2E, 0x10, 0x5F, 0xFF, 0xF0, 0x53, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x58,
  0x21, 0x7C, 0xEF, 0xFC, 0x82, 0xEC, 0x71, 0x71, 0x01, 0x0A, 0xFF, 0xC0, 0xA0, 0x17, 0x20, 0x50,
  0xEF, 0xFE, 0x0E, 0x05, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_transit_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_transit_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_transit 48x48, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_outlined_48_maps_directions_transit_data[] PROGMEM = {
  0x78, 0x45, 0x79, 0xBD, 0xDE, 0x85, 0xED, 0xBA, 0x86, 0x27, 0x30, 0x50, 0xBF, 0xFE, 0x81, 0xD8,
  0x15, 0x04, 0x0D, 0xFF, 0xFB, 0x0E, 0x06, 0x30, 0x5F, 0xFF, 0xF8, 0x27, 0x01, 0xED, 0x84, 0xC8,
  0x64, 0x21, 0x68, 0x51, 0x13, 0x57, 0xBE, 0xD0, 0x20, 0x8C, 0x09, 0x01, 0x77, 0x50, 0x60, 0xEB,
  0x09, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xEF, 0xFF, 0xFA, 0x0E, 0x80, 0x98, 0x0F, 0x73, 0xC7, 0x3F,
  0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C,
  0x73, 0x80, 0xA8, 0x4F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28,
  0xDD, 0x83, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D,
  0xC0, 0xD2, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08,
  0xC0, 0x82, 0xC0, 0xEB, 0x01, 0x28, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x82, 0x01, 0xB0, 0xE0,
  0xCB, 0x07, 0x77, 0x71, 0x07, 0xB0, 0xC0, 0x7C, 0x07, 0x01, 0x77, 0x40, 0x10, 0x7C, 0x81, 0x71,
  0xEF, 0xFF, 0xF8, 0x2E, 0x10, 0x5F, 0xFF, 0xF0, 0x53, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x58,
  0x21, 0x7C, 0xEF, 0xFC, 0x82, 0xEC, 0x71, 0x72, 0x07, 0xFF, 0xC0, 0x77, 0x40, 0x7F, 0xFE, 0x07,
  0x72, 0x07, 0xFF, 0xF9, 0x07, 0x71, 0xFF, 0xFB, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_transit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_transit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_directions_walk 48x48, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_outlined_48_maps_directions_walk_data[] PROGMEM = {
  0x75, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x40, 0xAE, 0x0A, 0x77,
  0x40, 0xDE, 0x0D, 0x77, 0x40, 0xDE, 0x0D, 0x77, 0x40, 0xAE, 0x0A, 0x77, 0x40, 0x10, 0xEC, 0x0E,
  0x01, 0x77, 0x58, 0x41, 0xAD, 0xDA, 0x18, 0x0C, 0x70, 0x84, 0x6B, 0xFD, 0x91, 0x77, 0x38, 0x12,
  0x8E, 0xD0, 0xD0, 0x17, 0x70, 0x40, 0xBF, 0xA0, 0xB7, 0x48, 0x11, 0x7D, 0xFD, 0x05, 0x72, 0x09,
  0x0E, 0xFF, 0x0D, 0x72, 0xF0, 0xEF, 0xA0, 0x97, 0x1C, 0x82, 0xE9, 0x38, 0xFB, 0x06, 0x7C, 0x30,
  0xBF, 0xC0, 0x66, 0xC3, 0x0E, 0xFD, 0x09, 0x01, 0x4C, 0x20, 0x2F, 0x0D, 0x07, 0xE8, 0x2A, 0x53,
  0x1C, 0x20, 0x5F, 0x81, 0xA0, 0x6F, 0xE2, 0x08, 0xF0, 0x72, 0x03, 0x0C, 0xFC, 0x20, 0xBF, 0x04,
  0x40, 0x60, 0xDF, 0xA2, 0x0E, 0xF0, 0x16, 0x83, 0x38, 0xBC, 0xE5, 0x01, 0xF0, 0xD7, 0x73, 0x05,
  0xF9, 0x05, 0x77, 0x20, 0x8F, 0xA0, 0x57, 0x71, 0x0B, 0xFB, 0x06, 0x77, 0x0E, 0xB0, 0x0A, 0xE0,
  0x77, 0x50, 0x1C, 0x81, 0x70, 0x9E, 0x75, 0x04, 0xC0, 0x32, 0x08, 0xD7, 0x50, 0x8C, 0x40, 0x8C,
  0x75, 0x0B, 0xB0, 0xC5, 0xC7, 0x50, 0xEB, 0x08, 0x5C, 0x74, 0x01, 0xC0, 0x55, 0xC7, 0x40, 0x4C,
  0x01, 0x5C, 0x74, 0x07, 0xB0, 0xD6, 0xC7, 0x40, 0xBB, 0x0A, 0x6C, 0x74, 0x0E, 0xB0, 0x66, 0xC7,
  0x30, 0x1C, 0x03, 0x6C, 0x73, 0x04, 0xB0, 0xE7, 0xC7, 0x30, 0x7B, 0x0B, 0x7C, 0x73, 0x0A, 0xB0,
  0x87, 0xC7, 0x30, 0xDB, 0x04, 0x7C, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_directions_walk() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 3, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_directions_walk_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_dry_cleaning 48x48, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_outlined_48_maps_dry_cleaning_data[] PROGMEM = {
  0x77, 0x18, 0x46, 0xBE, 0xEC, 0x67, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x06, 0xFB, 0x06, 0x77, 0x73, 0x0B, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x77, 0x73,
  0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x77, 0x30, 0xEB, 0x01, 0x77, 0x77, 0x30, 0xCB, 0x0B, 0x01,
  0x77, 0x77, 0x20, 0x6D, 0x0D, 0x04, 0x77, 0x77, 0x10, 0xCD, 0x0D, 0x77, 0x77, 0x10, 0x10, 0xCD,
  0x77, 0x77, 0x30, 0x6C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x20, 0x60, 0xDC, 0x0D, 0x07, 0x77, 0x74,
  0x81, 0x18, 0xEF, 0x98, 0x1E, 0x81, 0x77, 0x60, 0x30, 0xAF, 0xF0, 0xA0, 0x37, 0x72, 0x04, 0x0B,
  0xF9, 0x00, 0x9F, 0x90, 0xC0, 0x57, 0x50, 0x60, 0xDF, 0x81, 0xE7, 0x12, 0x81, 0x17, 0xEF, 0x0D,
  0x06, 0x78, 0x11, 0x8E, 0xF0, 0xC0, 0x57, 0x10, 0x50, 0xCF, 0x81, 0xE8, 0x13, 0x04, 0x0E, 0xF0,
  0xB0, 0x47, 0x50, 0x40, 0xBF, 0x82, 0xE4, 0x02, 0xF0, 0x90, 0x27, 0x72, 0x02, 0x09, 0xF0, 0x20,
  0xAC, 0x81, 0xE7, 0x17, 0x76, 0x81, 0x17, 0xEC, 0x0A, 0x0E, 0xB0, 0x73, 0xFF, 0xE3, 0x07, 0xB0,
  0x0E, 0xB0, 0x33, 0xFF, 0xE3, 0x03, 0xB0, 0xE0, 0xCF, 0xFF, 0xFE, 0x0C, 0x05, 0xFF, 0xFF, 0xE8,
  0x15, 0x09, 0xFB, 0x75, 0xFB, 0x09, 0x30, 0x50, 0xCF, 0x97, 0x5F, 0x90, 0xC0, 0x57, 0x3C, 0x75,
  0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72,
  0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2F, 0xFE, 0x77, 0x2F, 0xFE, 0x77,
  0x2F, 0xFE, 0x77, 0x2F, 0xFE, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_dry_cleaning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_dry_cleaning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_edit_attributes 48x48, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_outlined_48_maps_edit_attributes_data[] PROGMEM = {
  0x58, 0x13, 0x9D, 0xFF, 0xFB, 0x81, 0xD9, 0x37, 0x10, 0x10, 0xAF, 0xFF, 0xFA, 0x0A, 0x01, 0x50,
  0x10, 0xDF, 0xFF, 0xFC, 0x0D, 0x01, 0x40, 0xCF, 0xFF, 0xFE, 0x0C, 0x30, 0x8C, 0x0B, 0x03, 0x77,
  0x73, 0x03, 0x0B, 0xC8, 0x28, 0x01, 0xEB, 0x0A, 0x73, 0x81, 0x1A, 0x17, 0x71, 0x0A, 0xB8, 0x1E,
  0x16, 0xB0, 0xD7, 0x38, 0x21, 0xCF, 0xA7, 0x72, 0x0D, 0xB0, 0x60, 0xAB, 0x07, 0x72, 0x83, 0x1C,
  0xFC, 0x17, 0x72, 0x07, 0xB0, 0xA0, 0xDB, 0x82, 0x20, 0x41, 0x58, 0x31, 0xCF, 0xC1, 0x77, 0x30,
  0x2B, 0x0D, 0x0E, 0xB1, 0x82, 0x5F, 0xC1, 0x38, 0x31, 0xCF, 0xC1, 0x77, 0x5B, 0x00, 0xEB, 0x18,
  0x91, 0x1D, 0xFC, 0x10, 0x1C, 0xFC, 0x17, 0x76, 0xB0, 0xE0, 0xDB, 0x89, 0x12, 0x01, 0xDF, 0xC2,
  0xCF, 0xC1, 0x77, 0x60, 0x2B, 0x0D, 0x0A, 0xB0, 0x72, 0x01, 0x0D, 0xB0, 0xC0, 0x17, 0x77, 0x07,
  0xB0, 0xA0, 0x6B, 0x0D, 0x38, 0x31, 0xDF, 0xC1, 0x77, 0x71, 0x0D, 0xB8, 0x16, 0x1E, 0xB0, 0xA3,
  0x81, 0x1A, 0x17, 0x77, 0x10, 0xAB, 0x82, 0xE1, 0x08, 0xC0, 0xB0, 0x37, 0x77, 0x30, 0x30, 0xBC,
  0x08, 0x30, 0xCF, 0xFF, 0xFE, 0x0C, 0x40, 0x10, 0xDF, 0xFF, 0xFC, 0x0D, 0x01, 0x50, 0x10, 0xAF,
  0xFF, 0xFA, 0x0A, 0x01, 0x71, 0x81, 0x39, 0xDF, 0xFF, 0xB8, 0x1D, 0x93, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_edit_attributes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 14, 43, 33), Box(0, 0, 47, 47),
      ic_outlined_48_maps_edit_attributes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_edit_location_alt 48x48, 4-bit Alpha,  RLE, 323 bytes.
static const unsigned char ic_outlined_48_maps_edit_location_alt_data[] PROGMEM = {
  0x77, 0x77, 0x18, 0x29, 0xEB, 0x17, 0x77, 0x71, 0x0B, 0xB0, 0xC0, 0x17, 0x48, 0x90, 0x49, 0xBD,
  0xEE, 0xDB, 0x85, 0x70, 0xBC, 0x0B, 0x71, 0x81, 0x19, 0xEF, 0xA0, 0x95, 0x04, 0x20, 0xBB, 0x0E,
  0x70, 0x8F, 0xC0, 0x95, 0x81, 0xBF, 0x52, 0x0B, 0xA0, 0x95, 0x01, 0x0C, 0xFC, 0x09, 0x50, 0xBB,
  0x05, 0x20, 0x0B, 0x50, 0x30, 0xED, 0x82, 0xD8, 0x41, 0x20, 0x15, 0x0B, 0xD0, 0x57, 0x01, 0x0E,
  0xC0, 0xD0, 0x57, 0x40, 0xBF, 0x04, 0x60, 0xCC, 0x0A, 0x75, 0x0B, 0xF0, 0xB6, 0x07, 0xC0, 0x87,
  0x50, 0xBF, 0x0B, 0x60, 0x10, 0xEB, 0x09, 0x75, 0x0B, 0xF0, 0xB7, 0x09, 0xB0, 0xD7, 0x50, 0xBF,
  0x0B, 0x71, 0x0E, 0xB0, 0x57, 0x40, 0xBF, 0x0B, 0x71, 0x03, 0xB0, 0xE7, 0x40, 0xBF, 0x0B, 0x50,
  0x90, 0x42, 0x08, 0xB0, 0x97, 0x30, 0xBF, 0x0B, 0x58, 0x19, 0xF8, 0x20, 0xBB, 0x04, 0x72, 0x0B,
  0xF0, 0xB5, 0x09, 0xA0, 0xB2, 0x0D, 0xB0, 0x27, 0x2F, 0x0B, 0x50, 0x2B, 0x0D, 0x20, 0xEB, 0x01,
  0x72, 0xE0, 0xB6, 0x01, 0xB0, 0xE2, 0xC7, 0x3D, 0x0B, 0x71, 0xC2, 0x0D, 0xB0, 0x17, 0x2C, 0x0B,
  0x71, 0x01, 0xB0, 0xD2, 0x0C, 0xB0, 0x47, 0x77, 0x10, 0x4B, 0x0C, 0x20, 0x9B, 0x08, 0x77, 0x71,
  0x08, 0xB0, 0x92, 0x04, 0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x04, 0x30, 0xEB, 0x04, 0x77, 0x60, 0x4B,
  0x0E, 0x40, 0x9B, 0x0C, 0x77, 0x60, 0xCB, 0x09, 0x40, 0x2C, 0x05, 0x77, 0x40, 0x5C, 0x02, 0x50,
  0xAB, 0x0E, 0x01, 0x77, 0x20, 0x10, 0xEB, 0x0A, 0x60, 0x10, 0xEB, 0x0A, 0x77, 0x20, 0xAB, 0x0E,
  0x01, 0x70, 0x7C, 0x06, 0x77, 0x06, 0xC0, 0x77, 0x20, 0xCC, 0x03, 0x75, 0x03, 0xC0, 0xC7, 0x30,
  0x20, 0xEB, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xB0, 0xE0, 0x27, 0x40, 0x5C, 0x0C, 0x73, 0x0C, 0xC0,
  0x57, 0x60, 0x8C, 0x0B, 0x71, 0x0B, 0xC0, 0x87, 0x71, 0x0A, 0xC0, 0xA6, 0x0A, 0xC0, 0xA7, 0x73,
  0x0B, 0xC0, 0xA4, 0x0A, 0xC0, 0xB7, 0x74, 0x01, 0x0C, 0xC0, 0xB2, 0x0B, 0xC0, 0xC0, 0x17, 0x75,
  0x01, 0x0C, 0xC0, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x01, 0x0C, 0xF9, 0x0C, 0x01, 0x77, 0x72, 0x01,
  0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x50, 0xBC, 0x0B, 0x77, 0x77, 0x10, 0xAA, 0x0A, 0x77, 0x77, 0x30,
  0x08, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_edit_location_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_edit_location_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_edit_location 48x48, 4-bit Alpha,  RLE, 375 bytes.
static const unsigned char ic_outlined_48_maps_edit_location_data[] PROGMEM = {
  0x77, 0x75, 0x83, 0x1A, 0xEC, 0x47, 0x77, 0x70, 0x20, 0xDC, 0x06, 0x76, 0x87, 0x48, 0xBD, 0xEF,
  0xDB, 0x14, 0x02, 0x0D, 0xE0, 0x67, 0x28, 0x11, 0x9E, 0xF0, 0x54, 0x02, 0x0D, 0xF9, 0x04, 0x70,
  0x80, 0xEF, 0x90, 0x54, 0x02, 0x0D, 0xFA, 0x0C, 0x50, 0x10, 0xCF, 0xA0, 0x54, 0x02, 0x0D, 0xB0,
  0xEE, 0x0E, 0x40, 0x30, 0xED, 0x82, 0xD8, 0x42, 0x50, 0x20, 0xDB, 0x81, 0x51, 0xDD, 0x0A, 0x30,
  0x10, 0xDC, 0x0D, 0x05, 0x71, 0x02, 0x0D, 0xB0, 0x52, 0x01, 0x0D, 0xB0, 0xD0, 0x13, 0x0C, 0xC0,
  0xA7, 0x20, 0x20, 0xDB, 0x05, 0x30, 0x5B, 0x0D, 0x02, 0x30, 0x7C, 0x08, 0x72, 0x02, 0x0D, 0xB0,
  0x53, 0x05, 0xB0, 0xD0, 0x23, 0x01, 0x0E, 0xB0, 0xA7, 0x20, 0x20, 0xDB, 0x05, 0x30, 0x5B, 0x0D,
  0x02, 0x40, 0x9B, 0x0D, 0x72, 0x02, 0x0D, 0xB0, 0x53, 0x05, 0xB0, 0xD0, 0x25, 0x0E, 0xB0, 0x67,
  0x10, 0x20, 0xDB, 0x05, 0x30, 0x5B, 0x0D, 0x02, 0x50, 0x3B, 0x0E, 0x71, 0x02, 0x0D, 0xB0, 0x53,
  0x05, 0xB0, 0xD0, 0x26, 0x08, 0xB0, 0x97, 0x02, 0x0D, 0xB0, 0x53, 0x05, 0xB0, 0xD0, 0x24, 0x01,
  0x20, 0xBB, 0x05, 0x70, 0xDB, 0x05, 0x30, 0x5B, 0x0D, 0x02, 0x40, 0x40, 0xB2, 0x0C, 0xB0, 0x27,
  0xB0, 0x63, 0x05, 0xB0, 0xD0, 0x24, 0x81, 0x4F, 0xD2, 0x0E, 0xB0, 0x17, 0xB0, 0x12, 0x05, 0xB0,
  0xD0, 0x24, 0x04, 0xA0, 0xE2, 0xC7, 0x1B, 0x81, 0x10, 0x4B, 0x0D, 0x02, 0x5C, 0x20, 0xDB, 0x01,
  0x7F, 0x90, 0xD0, 0x25, 0x01, 0xB0, 0xD2, 0x0C, 0xB0, 0x47, 0xF0, 0xD0, 0x26, 0x03, 0xB0, 0xC2,
  0x09, 0xB0, 0x87, 0xE0, 0xD0, 0x27, 0x08, 0xB0, 0x92, 0x04, 0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x04,
  0x3C, 0x04, 0x77, 0x60, 0x4C, 0x40, 0x9B, 0x0B, 0x77, 0x60, 0xBB, 0x09, 0x40, 0x2C, 0x05, 0x77,
  0x40, 0x5C, 0x02, 0x50, 0xAB, 0x0D, 0x77, 0x40, 0xDB, 0x0A, 0x60, 0x10, 0xEB, 0x0A, 0x77, 0x20,
  0x9B, 0x0E, 0x01, 0x70, 0x7C, 0x05, 0x77, 0x05, 0xC0, 0x77, 0x20, 0xCB, 0x0E, 0x02, 0x75, 0x02,
  0x0E, 0xB0, 0xC7, 0x30, 0x20, 0xEB, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xB0, 0xE0, 0x27, 0x40, 0x5C,
  0x0C, 0x73, 0x0C, 0xC0, 0x57, 0x60, 0x8C, 0x0B, 0x71, 0x0B, 0xC0, 0x87, 0x71, 0x0A, 0xC0, 0xA6,
  0x0A, 0xC0, 0xA7, 0x73, 0x0C, 0xC0, 0xA4, 0x0A, 0xC0, 0xC7, 0x74, 0x01, 0x0C, 0xC0, 0xB2, 0x0B,
  0xC0, 0xC0, 0x17, 0x75, 0x01, 0x0C, 0xC0, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x01, 0x0C, 0xF9, 0x0C,
  0x01, 0x77, 0x72, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x50, 0xBC, 0x0B, 0x77, 0x77, 0x10, 0xAA,
  0x0A, 0x77, 0x77, 0x30, 0x08, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_edit_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_edit_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_edit_road 48x48, 4-bit Alpha,  RLE, 208 bytes.
static const unsigned char ic_outlined_48_maps_edit_road_data[] PROGMEM = {
  0xC7, 0x1C, 0x71, 0xC7, 0x3C, 0x71, 0xC7, 0x1C, 0x73, 0xC7, 0x1C, 0x71, 0xC7, 0x3C, 0x71, 0xC7,
  0x1C, 0x73, 0xC7, 0x1C, 0x71, 0xC7, 0x3C, 0x71, 0xC7, 0x1C, 0x73, 0xC7, 0x1C, 0x71, 0xC7, 0x3C,
  0x71, 0xC7, 0x1C, 0x73, 0xC7, 0x76, 0xC7, 0x3C, 0x77, 0x6C, 0x73, 0xC7, 0x76, 0xC7, 0x3C, 0x77,
  0x6C, 0x73, 0xC7, 0x1C, 0x71, 0xB0, 0x47, 0x3C, 0x71, 0xC7, 0x1A, 0x04, 0x74, 0xC7, 0x1C, 0x71,
  0x90, 0x44, 0x83, 0x1A, 0xEC, 0x53, 0xC7, 0x1C, 0x71, 0x04, 0x40, 0x20, 0xDC, 0x06, 0x2C, 0x71,
  0xC7, 0x50, 0x20, 0xDE, 0x06, 0x1C, 0x71, 0xC7, 0x40, 0x20, 0xDF, 0x90, 0x5C, 0x71, 0xC7, 0x30,
  0x20, 0xDF, 0xA0, 0xDC, 0x71, 0xC7, 0x20, 0x20, 0xDF, 0xB0, 0xEC, 0x77, 0x60, 0x20, 0xDB, 0x00,
  0x6E, 0x0A, 0xC7, 0x75, 0x02, 0x0D, 0xB0, 0x62, 0x06, 0xC0, 0xD0, 0x1C, 0x77, 0x40, 0x20, 0xDB,
  0x06, 0x30, 0x6B, 0x0D, 0x02, 0x1C, 0x77, 0x30, 0x20, 0xDB, 0x06, 0x30, 0x6B, 0x0D, 0x02, 0x2C,
  0x71, 0xC4, 0x02, 0x0D, 0xB0, 0x63, 0x06, 0xB0, 0xD0, 0x23, 0xC7, 0x1C, 0x40, 0xDB, 0x06, 0x30,
  0x6B, 0x0D, 0x02, 0x4C, 0x71, 0xC4, 0xB0, 0x73, 0x06, 0xB0, 0xD0, 0x25, 0xC7, 0x1C, 0x4B, 0x01,
  0x20, 0x6B, 0x0D, 0x02, 0x6C, 0x71, 0xC4, 0xB8, 0x13, 0x17, 0xB0, 0xD0, 0x27, 0xC7, 0x1C, 0x4F,
  0x90, 0xD0, 0x27, 0x1C, 0x71, 0xC4, 0xF0, 0xD0, 0x27, 0x2C, 0x71, 0xC4, 0xE0, 0xD0, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_edit_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 45, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_edit_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_egg_alt 48x48, 4-bit Alpha,  RLE, 372 bytes.
static const unsigned char ic_outlined_48_maps_egg_alt_data[] PROGMEM = {
  0x73, 0x83, 0x16, 0xAC, 0xEA, 0x83, 0xDC, 0xA6, 0x17, 0x77, 0x50, 0x30, 0xAF, 0xD0, 0xB0, 0x37,
  0x77, 0x20, 0x9F, 0xFA, 0x09, 0x77, 0x60, 0x20, 0xDF, 0xFC, 0x0D, 0x02, 0x77, 0x30, 0x20, 0xED,
  0x82, 0xC7, 0x31, 0x28, 0x21, 0x37, 0xCD, 0x0D, 0x01, 0x77, 0x20, 0xDC, 0x0C, 0x04, 0x73, 0x03,
  0x0C, 0xC0, 0xD0, 0x17, 0x70, 0xAC, 0x0A, 0x77, 0x09, 0xC0, 0xB7, 0x60, 0x4C, 0x09, 0x77, 0x20,
  0x9C, 0x07, 0x75, 0x0C, 0xB0, 0xC7, 0x74, 0x0B, 0xC0, 0x27, 0x30, 0x4C, 0x03, 0x77, 0x40, 0x10,
  0xEB, 0x0B, 0x73, 0x0A, 0xB0, 0xB7, 0x76, 0x05, 0xC0, 0x67, 0x20, 0xEB, 0x04, 0x77, 0x70, 0xAB,
  0x0E, 0x01, 0x70, 0x3B, 0x0E, 0x77, 0x71, 0x01, 0x0E, 0xB0, 0xB7, 0x07, 0xB0, 0xA7, 0x48, 0x61,
  0x7C, 0xEE, 0xC7, 0x14, 0x06, 0xC0, 0x96, 0x0A, 0xB0, 0x67, 0x30, 0x50, 0xEE, 0x0E, 0x05, 0x40,
  0xBC, 0x07, 0x50, 0xCB, 0x03, 0x72, 0x05, 0xFB, 0x05, 0x30, 0x10, 0xDC, 0x07, 0x40, 0xDB, 0x02,
  0x71, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x30, 0x20, 0xEC, 0x06, 0x30, 0xEB, 0x01, 0x71, 0x07, 0xFD,
  0x07, 0x40, 0x30, 0xEC, 0x04, 0x2C, 0x72, 0x0C, 0xFD, 0x0C, 0x50, 0x30, 0xEB, 0x0E, 0x01, 0x1C,
  0x72, 0x0E, 0xFD, 0x0E, 0x60, 0x4C, 0x81, 0x90, 0xDB, 0x01, 0x71, 0x0E, 0xFD, 0x0E, 0x70, 0x7C,
  0x01, 0x0C, 0xB0, 0x47, 0x10, 0xCF, 0xD0, 0xC7, 0x10, 0xCB, 0x06, 0x09, 0xB0, 0x87, 0x10, 0x7F,
  0xD0, 0x77, 0x10, 0x6B, 0x0A, 0x05, 0xB0, 0xE7, 0x10, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x10, 0x3B,
  0x81, 0xC0, 0xEB, 0x07, 0x71, 0x05, 0xFB, 0x05, 0x72, 0x01, 0xB8, 0x1E, 0x08, 0xB0, 0xE0, 0x27,
  0x10, 0x50, 0xEE, 0x0E, 0x05, 0x74, 0xC1, 0x01, 0x0E, 0xB0, 0xD0, 0x27, 0x18, 0x61, 0x7C, 0xEE,
  0xC7, 0x17, 0x5B, 0x0E, 0x20, 0x5C, 0x0E, 0x05, 0x77, 0x75, 0x02, 0xB0, 0xD3, 0x08, 0xD0, 0xB0,
  0x37, 0x77, 0x30, 0x4B, 0x0B, 0x40, 0x9E, 0x82, 0xD8, 0x42, 0x77, 0x60, 0x9B, 0x08, 0x50, 0x6F,
  0xC8, 0x1C, 0x71, 0x77, 0x10, 0xEB, 0x04, 0x60, 0x20, 0xAF, 0xC0, 0xE0, 0x67, 0x60, 0x7B, 0x0E,
  0x72, 0x03, 0x0A, 0xFC, 0x09, 0x74, 0x02, 0x0E, 0xB0, 0x77, 0x48, 0x31, 0x58, 0xCD, 0xF0, 0x97,
  0x20, 0x10, 0xDB, 0x0E, 0x01, 0x77, 0x38, 0x11, 0x6E, 0xC0, 0x97, 0x03, 0x0D, 0xC0, 0x57, 0x76,
  0x02, 0x0D, 0xC8, 0x5C, 0x62, 0x01, 0x39, 0xD0, 0x97, 0x77, 0x10, 0x20, 0xDF, 0xF0, 0xA7, 0x77,
  0x30, 0x20, 0xDF, 0xD0, 0x97, 0x77, 0x60, 0x9F, 0xA0, 0xD0, 0x37, 0x77, 0x71, 0x87, 0x27, 0xBE,
  0xFE, 0xC9, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_egg_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_egg_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_egg 48x48, 4-bit Alpha,  RLE, 271 bytes.
static const unsigned char ic_outlined_48_maps_egg_data[] PROGMEM = {
  0x74, 0x84, 0x7C, 0xEE, 0xC7, 0x77, 0x60, 0x50, 0xEE, 0x0E, 0x05, 0x77, 0x30, 0x8F, 0xB0, 0x77,
  0x71, 0x09, 0xFD, 0x07, 0x76, 0x07, 0xD8, 0x27, 0x12, 0x7D, 0x07, 0x74, 0x04, 0xC0, 0xD0, 0x24,
  0x02, 0x0D, 0xC0, 0x37, 0x20, 0x10, 0xEB, 0x0E, 0x02, 0x60, 0x20, 0xEB, 0x0D, 0x72, 0x09, 0xC0,
  0x37, 0x10, 0x3C, 0x09, 0x70, 0x2C, 0x07, 0x73, 0x07, 0xC0, 0x26, 0x0A, 0xB0, 0xC7, 0x50, 0xCB,
  0x0A, 0x50, 0x3C, 0x04, 0x75, 0x04, 0xC0, 0x34, 0x09, 0xB0, 0xB7, 0x70, 0xBB, 0x09, 0x40, 0xEB,
  0x04, 0x77, 0x04, 0xB0, 0xE3, 0x05, 0xB0, 0xD7, 0x72, 0x0D, 0xB0, 0x52, 0x0B, 0xB0, 0x77, 0x72,
  0x07, 0xB0, 0xB2, 0xC0, 0x17, 0x72, 0x01, 0xC1, 0x03, 0xB0, 0xC7, 0x74, 0x0C, 0xB0, 0x30, 0x7B,
  0x09, 0x77, 0x40, 0x9B, 0x07, 0x0A, 0xB8, 0x45, 0x04, 0xDD, 0x47, 0x60, 0x5B, 0x0A, 0x0C, 0xB8,
  0x13, 0x0D, 0xA0, 0xD7, 0x60, 0x3B, 0x0C, 0x0D, 0xB8, 0x12, 0x0E, 0xB7, 0x60, 0x2B, 0x0D, 0x0E,
  0xB2, 0x0D, 0xB0, 0x27, 0x6B, 0x00, 0xEB, 0x20, 0xBB, 0x06, 0x76, 0xB0, 0xE0, 0xDB, 0x81, 0x20,
  0x6B, 0x0D, 0x75, 0x02, 0xB0, 0xD0, 0xBB, 0x81, 0x50, 0x1C, 0x0A, 0x74, 0x05, 0xB0, 0xB0, 0x7B,
  0x0A, 0x20, 0x8C, 0x81, 0xD6, 0x27, 0x10, 0xAB, 0x07, 0x03, 0xC0, 0x22, 0x0C, 0xF0, 0xD0, 0x44,
  0x02, 0xC8, 0x13, 0x0D, 0xB0, 0xA2, 0x01, 0x0C, 0xF0, 0xD4, 0x0A, 0xB0, 0xD2, 0x05, 0xC0, 0x73,
  0x08, 0xE0, 0xD3, 0x07, 0xC0, 0x53, 0x0C, 0xC0, 0x73, 0x85, 0x17, 0xBD, 0xED, 0x42, 0x07, 0xC0,
  0xC4, 0x02, 0x0E, 0xC0, 0xA0, 0x27, 0x10, 0x20, 0xAC, 0x0E, 0x02, 0x50, 0x3E, 0x81, 0xA5, 0x22,
  0x81, 0x25, 0xAE, 0x03, 0x70, 0x30, 0xEF, 0xFA, 0x0E, 0x03, 0x72, 0x02, 0x0C, 0xFF, 0x0C, 0x02,
  0x75, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x77, 0x28, 0x90, 0x37, 0xBD, 0xEE, 0xDB, 0x73, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_egg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_egg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_electrical_services 48x48, 4-bit Alpha,  RLE, 191 bytes.
static const unsigned char ic_outlined_48_maps_electrical_services_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0x82, 0xEC, 0x71, 0x77, 0x72, 0x0D, 0xFC, 0x0E, 0x05, 0x77, 0x71, 0x0D, 0xFE,
  0x05, 0x77, 0x70, 0x40, 0xDF, 0xD0, 0xE0, 0x17, 0x77, 0x71, 0x01, 0x07, 0xC0, 0x77, 0x77, 0x73,
  0x07, 0xB0, 0xC7, 0x77, 0x73, 0x01, 0xB0, 0xE7, 0x77, 0x73, 0x01, 0xB0, 0xE7, 0x77, 0x73, 0x07,
  0xB0, 0xC7, 0x77, 0x71, 0x01, 0x07, 0xC0, 0x77, 0x77, 0x18, 0x22, 0x8C, 0xEF, 0x90, 0xE0, 0x17,
  0x77, 0x09, 0xFD, 0x05, 0x77, 0x70, 0xBF, 0xC0, 0xE0, 0x57, 0x77, 0x09, 0xFA, 0x82, 0xEC, 0x71,
  0x77, 0x70, 0x2C, 0x81, 0xD5, 0x17, 0x77, 0x70, 0x8B, 0x0D, 0x01, 0x77, 0x77, 0x20, 0xCB, 0x05,
  0x77, 0x81, 0x1A, 0xDE, 0x71, 0x0E, 0xB0, 0x17, 0x60, 0x10, 0xEF, 0x97, 0x10, 0xEB, 0x01, 0x76,
  0x0A, 0xFA, 0x2C, 0x81, 0xD4, 0xCB, 0x05, 0x76, 0x0D, 0xFA, 0x2D, 0x0D, 0x08, 0xB0, 0xD0, 0x17,
  0x1F, 0xF2, 0xD0, 0xD0, 0x2C, 0x81, 0xD5, 0x16, 0xFF, 0x2C, 0x82, 0xD4, 0x09, 0xFB, 0x2F, 0xF7,
  0x30, 0xBF, 0xA2, 0xFF, 0x74, 0x09, 0xF9, 0x2F, 0xF7, 0x58, 0x22, 0x8C, 0xEC, 0x2F, 0xF7, 0x77,
  0x1F, 0xF2, 0xC0, 0xD0, 0x47, 0x7F, 0xF2, 0xD0, 0xD7, 0x74, 0x0D, 0xFA, 0x2D, 0x0D, 0x77, 0x40,
  0xAF, 0xA2, 0xC0, 0xD0, 0x47, 0x74, 0x01, 0x0E, 0xF9, 0x77, 0x76, 0x81, 0x1A, 0xDE, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_electrical_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_electrical_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_electric_bike 48x48, 4-bit Alpha,  RLE, 381 bytes.
static const unsigned char ic_outlined_48_maps_electric_bike_data[] PROGMEM = {
  0x77, 0x73, 0xD8, 0x1E, 0xB3, 0x80, 0xC4, 0x0F, 0x90, 0x48, 0x0C, 0x30, 0xF9, 0x0D, 0x80, 0xC3,
  0x0F, 0xA0, 0x48, 0x0C, 0x70, 0x09, 0xB0, 0x98, 0x0C, 0x70, 0x03, 0xB0, 0xE7, 0x77, 0x7F, 0xB6,
  0x0D, 0xB0, 0x57, 0x77, 0x6F, 0xB6, 0x08, 0xB0, 0xB7, 0x77, 0x6F, 0xB6, 0x02, 0xC0, 0x17, 0x77,
  0x5F, 0xB7, 0x0C, 0xB0, 0x77, 0x77, 0x71, 0x04, 0xB0, 0xE7, 0x20, 0x6B, 0x0C, 0x77, 0x77, 0x20,
  0xEB, 0x04, 0x71, 0x01, 0xC0, 0x27, 0x73, 0x86, 0x49, 0xDD, 0xFD, 0xA5, 0x40, 0x9F, 0xFD, 0x82,
  0xED, 0xA5, 0x73, 0x03, 0x0C, 0xF9, 0x0D, 0x05, 0x20, 0x3F, 0xFF, 0xA0, 0xD0, 0x57, 0x07, 0xFD,
  0x09, 0x20, 0xDF, 0xFF, 0xB0, 0x95, 0x07, 0xFF, 0x81, 0x90, 0x7F, 0xFF, 0xC0, 0x93, 0x04, 0xD8,
  0x48, 0x30, 0x13, 0x9D, 0x05, 0x02, 0xC0, 0x14, 0x04, 0xF8, 0x2E, 0x13, 0x8D, 0x05, 0x20, 0xCB,
  0x0D, 0x02, 0x60, 0x20, 0xEB, 0x81, 0xD0, 0xBB, 0x07, 0x40, 0xDB, 0x00, 0xDB, 0x05, 0x20, 0x20,
  0xDB, 0x81, 0xD0, 0x4B, 0x0E, 0x02, 0x71, 0x03, 0xC0, 0x50, 0x6B, 0x0D, 0x30, 0x5C, 0x02, 0x07,
  0xB0, 0xB3, 0x02, 0x0E, 0xB0, 0x50, 0x9B, 0x08, 0x73, 0x09, 0xB0, 0xA0, 0x1C, 0x03, 0x20, 0x9B,
  0x81, 0x80, 0x2C, 0x01, 0x30, 0x8B, 0x0A, 0x0C, 0xB0, 0x35, 0xFF, 0xF9, 0x03, 0x20, 0xCB, 0x07,
  0x30, 0x3B, 0x0D, 0x0E, 0xB6, 0xFF, 0xF9, 0x30, 0x6A, 0x0C, 0x05, 0x4B, 0x00, 0xEB, 0x6F, 0xFF,
  0x93, 0x81, 0x18, 0x26, 0xB0, 0xE0, 0xDB, 0x03, 0x5F, 0xFF, 0x90, 0x37, 0x30, 0x3B, 0x0C, 0x0A,
  0xB0, 0x87, 0x30, 0x9B, 0x0A, 0x71, 0x0A, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0x05, 0xB0, 0xE0, 0x27,
  0x10, 0x3C, 0x05, 0x71, 0x05, 0xB0, 0xE0, 0x27, 0x10, 0x20, 0xEB, 0x81, 0x40, 0xDB, 0x0D, 0x02,
  0x60, 0x20, 0xEB, 0x0D, 0x73, 0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xC2, 0x05, 0xD8, 0x48,
  0x30, 0x13, 0x9D, 0x05, 0x73, 0x05, 0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x33, 0x09, 0xFF, 0x09,
  0x75, 0x09, 0xFF, 0x06, 0x50, 0x9F, 0xD0, 0x97, 0x70, 0x9F, 0xD0, 0x77, 0x05, 0x0D, 0xF9, 0x0D,
  0x05, 0x77, 0x20, 0x50, 0xDF, 0x90, 0xC0, 0x37, 0x38, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x76, 0x86,
  0x5A, 0xDF, 0xDD, 0x94, 0x80, 0x9F, 0x00, 0x0B, 0x03, 0x80, 0xD2, 0x0A, 0x0B, 0x03, 0x80, 0xD0,
  0x0C, 0x0B, 0x03, 0x80, 0xC6, 0x0E, 0x0B, 0x03, 0x77, 0x77, 0x40, 0x30, 0xBF, 0xF0, 0xB0, 0x37,
  0x77, 0x74, 0x03, 0x0B, 0xFF, 0x0B, 0x03, 0x77, 0x77, 0x40, 0x30, 0xBE, 0x80, 0xC6, 0x00, 0x30,
  0xBC, 0x80, 0xD0, 0x00, 0x30, 0xBA, 0x80, 0xD2, 0x00, 0x30, 0xB7, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_electric_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 47, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_electric_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_electric_car 48x48, 4-bit Alpha,  RLE, 228 bytes.
static const unsigned char ic_outlined_48_maps_electric_car_data[] PROGMEM = {
  0x50, 0x80, 0xEF, 0xFF, 0x90, 0xE0, 0x87, 0x20, 0x8F, 0xFF, 0xD0, 0x87, 0x10, 0xEF, 0xFF, 0xD0,
  0xE7, 0x05, 0xFF, 0xFF, 0x05, 0x60, 0xAB, 0x08, 0x77, 0x60, 0x8B, 0x0A, 0x50, 0x1C, 0x02, 0x77,
  0x60, 0x3C, 0x01, 0x40, 0x6B, 0x0C, 0x77, 0x71, 0x0D, 0xB0, 0x64, 0x0B, 0xB0, 0x77, 0x77, 0x10,
  0x7B, 0x0B, 0x30, 0x1C, 0x02, 0x77, 0x71, 0x02, 0xC0, 0x12, 0x06, 0xB0, 0xC7, 0x77, 0x30, 0xCB,
  0x06, 0x20, 0xCB, 0x0D, 0x80, 0xA4, 0xB0, 0xDB, 0x81, 0xC0, 0x2F, 0xFF, 0xFE, 0x02, 0x07, 0xFF,
  0xFF, 0xE0, 0x70, 0xCF, 0xFF, 0xFE, 0x0C, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x93, 0x82, 0x8D,
  0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F, 0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F, 0x92, 0x0D,
  0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F, 0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F, 0x92, 0x08,
  0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F, 0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x78, 0x0A, 0xA6, 0xF7, 0x77, 0x3F, 0xD7, 0x77, 0x3E, 0x0D, 0xC0, 0xD7,
  0x77, 0x30, 0xDC, 0x81, 0xD4, 0xDA, 0x0D, 0x04, 0x77, 0x73, 0x04, 0x0D, 0xA0, 0xD0, 0x48, 0x09,
  0xA4, 0x00, 0xB0, 0x37, 0x77, 0x76, 0xA0, 0xB0, 0x37, 0x77, 0x74, 0xC0, 0xB0, 0x37, 0x77, 0x72,
  0xE0, 0xB0, 0x37, 0x76, 0x03, 0x0B, 0xFF, 0x0B, 0x03, 0x77, 0x60, 0x30, 0xBF, 0xF0, 0xB0, 0x37,
  0x76, 0x03, 0x0B, 0xE7, 0x77, 0x72, 0x03, 0x0B, 0xC7, 0x77, 0x74, 0x03, 0x0B, 0xA7, 0x77, 0x76,
  0x03, 0x0B, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_electric_car() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_electric_car_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_electric_moped 48x48, 4-bit Alpha,  RLE, 266 bytes.
static const unsigned char ic_outlined_48_maps_electric_moped_data[] PROGMEM = {
  0x77, 0x73, 0xE8, 0x1D, 0xA1, 0x77, 0x77, 0x3F, 0x90, 0xE0, 0x17, 0x5F, 0xB7, 0x1F, 0xA0, 0xA7,
  0x5F, 0xB7, 0x1F, 0xA0, 0xD7, 0x5F, 0xB7, 0x7C, 0x75, 0xFB, 0x77, 0xC8, 0x0C, 0x00, 0xC8, 0x0C,
  0x00, 0xC7, 0x38, 0x22, 0x8C, 0xEF, 0x97, 0x7C, 0x72, 0x09, 0xFD, 0x76, 0x03, 0xC7, 0x10, 0xBF,
  0xE7, 0x50, 0x10, 0xDB, 0x0E, 0x70, 0x9F, 0xF7, 0x50, 0xBC, 0x05, 0x60, 0x2C, 0x81, 0xD5, 0x14,
  0xC7, 0x40, 0x8C, 0x08, 0x70, 0x8B, 0x0D, 0x01, 0x6C, 0x73, 0x05, 0xC0, 0xB7, 0x10, 0xCB, 0x05,
  0x7C, 0x72, 0x03, 0x0E, 0xB0, 0xD0, 0x17, 0x10, 0xEB, 0x01, 0x7C, 0x71, 0x01, 0x0D, 0xB0, 0xE0,
  0x37, 0x2C, 0x71, 0xC7, 0x10, 0xBC, 0x86, 0x50, 0x6C, 0xEE, 0xC6, 0x3C, 0x71, 0xC7, 0x08, 0xC8,
  0x18, 0x1C, 0xE0, 0xC0, 0x11, 0xFF, 0xFE, 0x81, 0xB0, 0xCF, 0x90, 0xC1, 0xFF, 0xFD, 0x81, 0xD1,
  0x6F, 0xB0, 0x6F, 0xFF, 0xC8, 0x2E, 0x30, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xCF, 0xFF, 0xC0, 0x52,
  0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE4, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x50, 0xEB, 0x01, 0x20,
  0x1B, 0x0E, 0x40, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x50, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC4,
  0x06, 0xFB, 0x06, 0x75, 0x06, 0xFB, 0x06, 0x50, 0xCF, 0x90, 0xC7, 0x70, 0xCF, 0x90, 0xC6, 0x01,
  0x0C, 0xE0, 0xC0, 0x17, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x71, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x48,
  0x46, 0xCE, 0xEC, 0x68, 0x09, 0xC1, 0x00, 0xB0, 0x38, 0x0C, 0x20, 0xA0, 0xB0, 0x38, 0x0C, 0x00,
  0xC0, 0xB0, 0x37, 0x77, 0x76, 0xE0, 0xB0, 0x37, 0x77, 0x30, 0x30, 0xBF, 0xF0, 0xB0, 0x37, 0x77,
  0x30, 0x30, 0xBF, 0xF0, 0xB0, 0x37, 0x77, 0x30, 0x30, 0xBE, 0x77, 0x77, 0x60, 0x30, 0xBC, 0x80,
  0xC0, 0x00, 0x30, 0xBA, 0x80, 0xC2, 0x00, 0x30, 0xB7, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_electric_moped() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_electric_moped_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_electric_rickshaw 48x48, 4-bit Alpha,  RLE, 275 bytes.
static const unsigned char ic_outlined_48_maps_electric_rickshaw_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xEB, 0x37, 0x60, 0x10, 0xEF, 0xFF, 0xF9, 0x04, 0x75, 0x0A,
  0xFF, 0xFF, 0xA0, 0xE0, 0x27, 0x40, 0xDF, 0xFF, 0xFB, 0x0D, 0x01, 0x73, 0xC7, 0x1C, 0x73, 0xF0,
  0xB7, 0x3C, 0x71, 0xC7, 0x3F, 0x90, 0x97, 0x2C, 0x71, 0xC7, 0x3C, 0x0B, 0xC0, 0x67, 0x1C, 0x71,
  0xC7, 0x3C, 0x01, 0x0D, 0xC0, 0x47, 0xC7, 0x1C, 0x73, 0xC1, 0x02, 0x0E, 0xB0, 0xE0, 0x26, 0xC7,
  0x1C, 0x73, 0xC2, 0x04, 0xC0, 0xD0, 0x15, 0xFF, 0xF9, 0x4C, 0x30, 0x7C, 0x0B, 0x5F, 0xFF, 0x94,
  0xC4, 0x09, 0xC0, 0x64, 0xFF, 0xF9, 0x4F, 0xE0, 0xC4, 0xFF, 0xF9, 0x4F, 0xF4, 0xC7, 0x1C, 0x73,
  0xFF, 0x4C, 0x71, 0xC7, 0x3F, 0xF4, 0xC3, 0x83, 0x5B, 0xEE, 0xCC, 0x73, 0xC5, 0x06, 0xC0, 0x53,
  0xC1, 0x01, 0x0C, 0xFA, 0x73, 0xC3, 0x01, 0x0C, 0xE0, 0xC0, 0x11, 0xC1, 0x0C, 0xFB, 0x73, 0xC3,
  0x0C, 0xF9, 0x0C, 0x1C, 0x06, 0xFC, 0x73, 0xC2, 0x06, 0xFB, 0x05, 0x0D, 0xF8, 0x2B, 0x11, 0xBF,
  0xFF, 0xB8, 0x2B, 0x11, 0xBB, 0x0B, 0x0A, 0xF0, 0x12, 0x01, 0xFF, 0xFB, 0x01, 0x20, 0x1B, 0x81,
  0xE1, 0xEE, 0x01, 0x20, 0x1F, 0xFF, 0xB0, 0x12, 0x01, 0xC1, 0x81, 0x1A, 0xDC, 0x82, 0xB1, 0x1B,
  0xFF, 0xFB, 0x82, 0xB1, 0x1B, 0xB0, 0xC4, 0x05, 0xFB, 0x05, 0x77, 0x20, 0x5F, 0xB0, 0x65, 0x0C,
  0xF9, 0x0C, 0x77, 0x40, 0xBF, 0x90, 0xC6, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x74, 0x01, 0x0C, 0xE0,
  0xC0, 0x17, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x18, 0x45, 0xBE, 0xEC, 0x68, 0x09, 0xD3, 0x00,
  0xB0, 0x38, 0x0C, 0x60, 0xA0, 0xB0, 0x38, 0x0C, 0x40, 0xC0, 0xB0, 0x38, 0x0C, 0x20, 0xE0, 0xB0,
  0x37, 0x77, 0x70, 0x30, 0xBF, 0xF0, 0xB0, 0x37, 0x77, 0x70, 0x30, 0xBF, 0xF0, 0xB0, 0x37, 0x77,
  0x70, 0x30, 0xBE, 0x80, 0xC2, 0x00, 0x30, 0xBC, 0x80, 0xC4, 0x00, 0x30, 0xBA, 0x80, 0xC6, 0x00,
  0x30, 0xB7, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_electric_rickshaw() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_electric_rickshaw_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_electric_scooter 48x48, 4-bit Alpha,  RLE, 298 bytes.
static const unsigned char ic_outlined_48_maps_electric_scooter_data[] PROGMEM = {
  0x77, 0x6F, 0x90, 0xD0, 0x87, 0x77, 0x72, 0xFB, 0x0C, 0x77, 0x77, 0x1F, 0xC0, 0x67, 0x77, 0x7F,
  0xC0, 0xB7, 0x77, 0x77, 0x01, 0xB0, 0xE8, 0x0C, 0x00, 0x0D, 0xB0, 0x37, 0x77, 0x77, 0x0A, 0xB0,
  0x67, 0x77, 0x77, 0x06, 0xB0, 0xA7, 0x77, 0x77, 0x03, 0xB0, 0xD8, 0x0C, 0x00, 0x0E, 0xB0, 0x17,
  0x77, 0x77, 0x0B, 0xB0, 0x57, 0x77, 0x77, 0x08, 0xB0, 0x87, 0x77, 0x77, 0x04, 0xB0, 0xC7, 0x77,
  0x77, 0x01, 0xC8, 0x0C, 0x00, 0x0D, 0xB0, 0x37, 0x77, 0x77, 0x09, 0xB0, 0x77, 0x77, 0x76, 0x01,
  0x0A, 0xB0, 0xA7, 0x77, 0x74, 0x01, 0x09, 0xD0, 0xE7, 0x77, 0x73, 0x05, 0x0E, 0xF0, 0x27, 0x77,
  0x71, 0x06, 0xFA, 0x05, 0x77, 0x77, 0x05, 0xD8, 0x1C, 0x62, 0x77, 0x77, 0x20, 0x10, 0xEC, 0x06,
  0x76, 0x84, 0x6B, 0xEE, 0xC6, 0x77, 0x09, 0xC0, 0x42, 0x84, 0x6C, 0xEE, 0xC6, 0x40, 0x10, 0xCE,
  0x0C, 0x01, 0x74, 0x01, 0xC8, 0x26, 0x01, 0xCE, 0x0C, 0x01, 0x20, 0xCF, 0x90, 0xC7, 0x40, 0x6B,
  0x0C, 0x20, 0xCF, 0x98, 0x1C, 0x06, 0xFB, 0x06, 0x73, 0x0A, 0xB8, 0x16, 0x06, 0xFB, 0x06, 0x0B,
  0xB8, 0x2B, 0x11, 0xBF, 0xFC, 0x81, 0x20, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC0, 0xEB, 0x01, 0x20,
  0x1F, 0xFC, 0x20, 0xEB, 0x01, 0x20, 0x1B, 0x00, 0xEB, 0x01, 0x20, 0x1F, 0xFC, 0x20, 0xEB, 0x01,
  0x20, 0x1B, 0x0E, 0x0C, 0xB8, 0x2B, 0x11, 0xBF, 0xFC, 0x20, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC0,
  0x6F, 0xB0, 0x57, 0x72, 0x06, 0xFB, 0x81, 0x60, 0xCF, 0x90, 0xC7, 0x74, 0x0C, 0xF9, 0x0C, 0x20,
  0x10, 0xCE, 0x0C, 0x01, 0x77, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x48, 0x46, 0xCE, 0xEB, 0x57, 0x77,
  0x18, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x0B, 0x03, 0x80, 0xC2, 0x0A, 0x0B, 0x03, 0x80, 0xC0, 0x0C,
  0x0B, 0x03, 0x77, 0x77, 0x6E, 0x0B, 0x03, 0x77, 0x73, 0x03, 0x0B, 0xFF, 0x0B, 0x03, 0x77, 0x73,
  0x03, 0x0B, 0xFF, 0x0B, 0x03, 0x77, 0x73, 0x03, 0x0B, 0xE7, 0x77, 0x76, 0x03, 0x0B, 0xC8, 0x0C,
  0x00, 0x03, 0x0B, 0xA8, 0x0C, 0x20, 0x03, 0x0B, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_electric_scooter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_electric_scooter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_emergency 48x48, 4-bit Alpha,  RLE, 367 bytes.
static const unsigned char ic_outlined_48_maps_emergency_data[] PROGMEM = {
  0x77, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x77, 0x0D, 0xFB, 0x0D, 0x77, 0x77, 0xFD, 0x77, 0x77,
  0xFD, 0x77, 0x77, 0xC4, 0xC7, 0x75, 0x81, 0x36, 0x26, 0xC4, 0xC6, 0x81, 0x26, 0x37, 0x20, 0x4B,
  0x08, 0x01, 0x4C, 0x4C, 0x40, 0x10, 0x8B, 0x04, 0x71, 0x0D, 0xC0, 0xE0, 0x63, 0xC4, 0xC3, 0x06,
  0x0E, 0xC0, 0xD7, 0x07, 0xF0, 0xC0, 0x41, 0xC4, 0xC1, 0x04, 0x0C, 0xF0, 0x75, 0x01, 0x0E, 0xFA,
  0x0A, 0xC4, 0xC0, 0xAF, 0xA0, 0xE0, 0x14, 0x09, 0xB8, 0x1E, 0x7E, 0xFA, 0x4F, 0xA8, 0x1E, 0x7E,
  0xB0, 0x93, 0x03, 0xC8, 0x26, 0x01, 0x9F, 0x94, 0xF9, 0x82, 0x91, 0x06, 0xC0, 0x32, 0x0B, 0xB0,
  0xD4, 0x03, 0x0C, 0xE4, 0xE0, 0xB0, 0x34, 0x0C, 0xB8, 0x1B, 0x04, 0xC0, 0x56, 0x05, 0x0D, 0xC4,
  0xC0, 0xD0, 0x56, 0x05, 0xC0, 0x40, 0x8C, 0x0E, 0x07, 0x70, 0x8B, 0x4A, 0x0E, 0x07, 0x70, 0x70,
  0xEC, 0x08, 0x03, 0xE0, 0xD0, 0x56, 0x81, 0x29, 0x84, 0x81, 0x89, 0x16, 0x05, 0x0D, 0xE8, 0x23,
  0x03, 0xCE, 0x0B, 0x02, 0x77, 0x40, 0x30, 0xBE, 0x0C, 0x03, 0x40, 0x60, 0xEE, 0x09, 0x01, 0x77,
  0x01, 0x09, 0xE0, 0xE0, 0x67, 0x10, 0x8E, 0x0E, 0x06, 0x75, 0x07, 0x0E, 0xE0, 0x87, 0x40, 0x20,
  0xBE, 0x0B, 0x73, 0x0C, 0xE0, 0xB0, 0x27, 0x50, 0x20, 0xBE, 0x0C, 0x73, 0x0B, 0xE0, 0xB0, 0x27,
  0x40, 0x8E, 0x0E, 0x07, 0x75, 0x06, 0x0E, 0xE0, 0x87, 0x10, 0x60, 0xEE, 0x09, 0x01, 0x77, 0x01,
  0x09, 0xE0, 0xE0, 0x64, 0x03, 0x0C, 0xE0, 0xB0, 0x37, 0x74, 0x02, 0x0B, 0xE8, 0x2C, 0x30, 0x3E,
  0x0D, 0x05, 0x68, 0x11, 0x98, 0x48, 0x18, 0x91, 0x60, 0x50, 0xDE, 0x03, 0x08, 0xC0, 0xE0, 0x77,
  0x07, 0x0E, 0xA4, 0xA0, 0xE0, 0x77, 0x07, 0x0E, 0xC0, 0x80, 0x4C, 0x05, 0x60, 0x50, 0xDC, 0x4C,
  0x0D, 0x05, 0x60, 0x5C, 0x81, 0x40, 0xBB, 0x0C, 0x40, 0x30, 0xBE, 0x4E, 0x0B, 0x03, 0x40, 0xCB,
  0x0B, 0x20, 0x3C, 0x82, 0x60, 0x19, 0xF9, 0x4F, 0x98, 0x29, 0x10, 0x6C, 0x03, 0x30, 0x9B, 0x81,
  0xE7, 0xEF, 0xA4, 0xFA, 0x81, 0xE7, 0xEB, 0x09, 0x40, 0x10, 0xEF, 0xA0, 0xAC, 0x4C, 0x0A, 0xFA,
  0x0E, 0x01, 0x50, 0x7F, 0x0C, 0x04, 0x1C, 0x4C, 0x10, 0x40, 0xCF, 0x07, 0x70, 0xDC, 0x0E, 0x06,
  0x3C, 0x4C, 0x30, 0x60, 0xEC, 0x0D, 0x71, 0x04, 0xB0, 0x80, 0x14, 0xC4, 0xC4, 0x01, 0x08, 0xB0,
  0x47, 0x28, 0x13, 0x62, 0x6C, 0x4C, 0x68, 0x12, 0x63, 0x77, 0x5C, 0x4C, 0x77, 0x77, 0xFD, 0x77,
  0x77, 0xFD, 0x77, 0x77, 0x0D, 0xFB, 0x0D, 0x77, 0x77, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_emergency_recording 48x48, 4-bit Alpha,  RLE, 232 bytes.
static const unsigned char ic_outlined_48_maps_emergency_recording_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xF0, 0xE0, 0x17, 0x10,
  0xAF, 0xFF, 0xFA, 0x0A, 0x71, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77,
  0x73, 0xC7, 0x07, 0xC7, 0x3C, 0x73, 0xC6, 0x07, 0xD7, 0x3C, 0x73, 0xC5, 0x07, 0xE7, 0x3C, 0x73,
  0xC4, 0x08, 0xF3, 0x81, 0x39, 0x14, 0xC4, 0x81, 0x19, 0x33, 0xC3, 0x08, 0xF9, 0x38, 0x2C, 0xFE,
  0x73, 0xC3, 0x82, 0x7E, 0xFC, 0x3C, 0x20, 0x8F, 0xA2, 0x06, 0xC0, 0xD0, 0x51, 0xC1, 0x05, 0x0D,
  0xC0, 0x62, 0xC1, 0x08, 0xFB, 0x20, 0xBE, 0x0B, 0xC0, 0xBE, 0x0B, 0x2C, 0x08, 0xFC, 0x30, 0x60,
  0xEF, 0xF0, 0xE0, 0x63, 0xFF, 0xA4, 0x01, 0x08, 0xFD, 0x08, 0x01, 0x4F, 0xFA, 0x60, 0x20, 0xBF,
  0x90, 0xB0, 0x26, 0xFF, 0xA6, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x6F, 0xFA, 0x40, 0x10, 0x8F, 0xD0,
  0x80, 0x14, 0xFF, 0xA3, 0x06, 0x0E, 0xFF, 0x0E, 0x06, 0x3F, 0xFA, 0x20, 0xBE, 0x0B, 0xC0, 0xBE,
  0x0B, 0x2C, 0x08, 0xFC, 0x20, 0x6C, 0x0D, 0x05, 0x1C, 0x10, 0x50, 0xDC, 0x06, 0x2C, 0x10, 0x8F,
  0xB3, 0x82, 0xCF, 0xE7, 0x3C, 0x38, 0x27, 0xEF, 0xC3, 0xC2, 0x08, 0xFA, 0x38, 0x13, 0x91, 0x4C,
  0x48, 0x11, 0x93, 0x3C, 0x30, 0x8F, 0x97, 0x3C, 0x73, 0xC4, 0x08, 0xF7, 0x3C, 0x73, 0xC5, 0x07,
  0xE7, 0x3C, 0x73, 0xC6, 0x07, 0xD7, 0x77, 0x3C, 0x70, 0x7C, 0x77, 0x73, 0xC7, 0x10, 0xDF, 0xFF,
  0xFA, 0x0D, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0x10, 0xEF, 0xFF, 0xF0, 0xE0, 0x17, 0x28,
  0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_emergency_recording() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_emergency_recording_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_emergency_share 48x48, 4-bit Alpha,  RLE, 345 bytes.
static const unsigned char ic_outlined_48_maps_emergency_share_data[] PROGMEM = {
  0x73, 0x83, 0x48, 0xAD, 0xDA, 0x83, 0xED, 0xA8, 0x47, 0x73, 0x81, 0x4A, 0xEF, 0xE0, 0xA0, 0x47,
  0x50, 0x40, 0xCF, 0xFC, 0x0C, 0x05, 0x71, 0x02, 0x0B, 0xFF, 0xF9, 0x0B, 0x02, 0x50, 0x50, 0xEE,
  0x83, 0xE9, 0x53, 0x22, 0x83, 0x23, 0x59, 0xEE, 0x0E, 0x05, 0x30, 0x8E, 0x0A, 0x04, 0x75, 0x03,
  0x0A, 0xE8, 0x17, 0x04, 0xD0, 0xB0, 0x37, 0x72, 0x03, 0x0B, 0xD8, 0x14, 0x07, 0xB0, 0x67, 0x76,
  0x06, 0xB0, 0x83, 0x81, 0x7E, 0x46, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x36, 0x81, 0x4E, 0x85,
  0x01, 0x50, 0x50, 0xDF, 0xB0, 0xD0, 0x55, 0x01, 0x73, 0x02, 0x0C, 0xFF, 0x0C, 0x02, 0x76, 0x03,
  0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x50, 0x7D, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAD, 0x07, 0x76, 0x07,
  0xA0, 0xA0, 0x27, 0x10, 0x20, 0xAA, 0x07, 0x77, 0x10, 0x70, 0x67, 0x50, 0x60, 0x78, 0x09, 0xD7,
  0x08, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x77, 0x60, 0x20, 0x9F, 0xB0, 0x90, 0x27, 0x73, 0x05,
  0x0E, 0xFD, 0x0E, 0x05, 0x77, 0x10, 0x7F, 0xFA, 0x07, 0x76, 0x05, 0xD8, 0x1C, 0x62, 0x28, 0x12,
  0x6C, 0xD0, 0x57, 0x40, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x17, 0x30, 0x9C, 0x03, 0x73,
  0x03, 0xC0, 0x97, 0x20, 0x1C, 0x06, 0x75, 0x06, 0xC0, 0x17, 0x10, 0x6B, 0x0C, 0x77, 0x0C, 0xB0,
  0x67, 0x10, 0xAB, 0x07, 0x58, 0x28, 0xDD, 0x85, 0x07, 0xB0, 0xA7, 0x10, 0xCB, 0x03, 0x40, 0x8C,
  0x08, 0x40, 0x3B, 0x0C, 0x71, 0x0E, 0xB0, 0x14, 0x0D, 0xC0, 0xD4, 0x01, 0xB0, 0xE7, 0x1C, 0x50,
  0xDC, 0x0D, 0x5C, 0x71, 0x0D, 0xB0, 0x24, 0x08, 0xC0, 0x84, 0x02, 0xB0, 0xD7, 0x10, 0xBB, 0x06,
  0x58, 0x28, 0xDD, 0x85, 0x06, 0xB0, 0xB7, 0x10, 0x6B, 0x0C, 0x77, 0x0C, 0xB0, 0x67, 0x10, 0x1C,
  0x04, 0x75, 0x04, 0xC0, 0x17, 0x20, 0xAB, 0x0D, 0x75, 0x0D, 0xB0, 0xA7, 0x30, 0x2C, 0x08, 0x73,
  0x08, 0xC0, 0x27, 0x40, 0x9C, 0x04, 0x71, 0x04, 0xC0, 0x97, 0x50, 0x10, 0xDB, 0x0E, 0x02, 0x60,
  0x20, 0xEB, 0x0D, 0x01, 0x76, 0x03, 0xC0, 0xD0, 0x14, 0x01, 0x0D, 0xC0, 0x37, 0x71, 0x07, 0xC0,
  0xC4, 0x0C, 0xC0, 0x77, 0x73, 0x09, 0xC8, 0x2C, 0x11, 0xCC, 0x09, 0x77, 0x50, 0xBC, 0x00, 0xCC,
  0x0B, 0x77, 0x70, 0xBF, 0x90, 0xB7, 0x77, 0x20, 0xBE, 0x0B, 0x77, 0x74, 0x0B, 0xC0, 0xB7, 0x77,
  0x60, 0xAA, 0x0A, 0x77, 0x77, 0x10, 0x08, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_emergency_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 0, 39, 47), Box(0, 0, 47, 47),
      ic_outlined_48_maps_emergency_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_ev_station 48x48, 4-bit Alpha,  RLE, 238 bytes.
static const unsigned char ic_outlined_48_maps_ev_station_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFD, 0x81, 0xDA, 0x17, 0x70, 0x10, 0xEF, 0xFA, 0x0E, 0x01, 0x30, 0x50, 0x97,
  0x10, 0xAF, 0xFC, 0x0A, 0x20, 0x5A, 0x09, 0x70, 0xDF, 0xFC, 0x0D, 0x20, 0x9B, 0x09, 0x6C, 0x75,
  0xC3, 0x09, 0xB0, 0x95, 0xC7, 0x5C, 0x40, 0x9B, 0x09, 0x4C, 0x70, 0x44, 0xC5, 0x09, 0xB0, 0x93,
  0xC7, 0x0C, 0x4C, 0x50, 0x40, 0xEB, 0x09, 0x2C, 0x60, 0x59, 0x4C, 0x40, 0x7E, 0x08, 0x1C, 0x60,
  0xD9, 0x4C, 0x30, 0x4F, 0x90, 0x4C, 0x50, 0x6A, 0x4C, 0x30, 0xBA, 0x82, 0xB1, 0x1B, 0xA0, 0xBC,
  0x50, 0xDA, 0x4C, 0x30, 0xEA, 0x01, 0x20, 0x1A, 0x0E, 0xC4, 0x07, 0xB4, 0xC3, 0x0E, 0xA0, 0x12,
  0x01, 0xF3, 0x01, 0x0E, 0xB4, 0xC3, 0x0B, 0xA8, 0x2B, 0x11, 0xBF, 0x30, 0x8C, 0x4C, 0x30, 0x4F,
  0xE2, 0x01, 0x0E, 0xC4, 0xC4, 0x08, 0xFD, 0x20, 0x9F, 0x90, 0xBC, 0x58, 0x34, 0xBE, 0xEB, 0xF1,
  0x02, 0xFA, 0x02, 0xC7, 0x3F, 0x10, 0xAF, 0x90, 0x81, 0xE8, 0x1D, 0xA1, 0x5F, 0x03, 0xF9, 0x0E,
  0x01, 0x1F, 0x90, 0xE0, 0x14, 0xF0, 0xBF, 0x90, 0x62, 0xFA, 0x0A, 0x4F, 0x4C, 0x0D, 0x3C, 0x3A,
  0x0D, 0x4F, 0x4C, 0x04, 0x3C, 0x3B, 0x4F, 0x4B, 0x0B, 0x4C, 0x3B, 0x4F, 0x4B, 0x02, 0x4C, 0x3B,
  0x4F, 0x4A, 0x08, 0x5C, 0x3B, 0x4F, 0x49, 0x0E, 0x01, 0x5C, 0x3B, 0x4F, 0x49, 0x06, 0x6C, 0x3B,
  0x4F, 0x40, 0xD7, 0xC3, 0xB4, 0xF4, 0x04, 0x7C, 0x3B, 0x4F, 0x75, 0xC3, 0xB4, 0xF7, 0x5C, 0x30,
  0xEA, 0x01, 0x20, 0x1A, 0x0E, 0xFF, 0xE3, 0x0B, 0xA8, 0x2B, 0x11, 0xBA, 0x0B, 0xFF, 0xE3, 0x04,
  0xF9, 0x04, 0xFF, 0xE4, 0x08, 0xE0, 0x81, 0xFF, 0xE5, 0x84, 0x4B, 0xEE, 0xB4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_ev_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 40, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_ev_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_factory 48x48, 4-bit Alpha,  RLE, 200 bytes.
static const unsigned char ic_outlined_48_maps_factory_data[] PROGMEM = {
  0x77, 0x77, 0x30, 0x1E, 0x01, 0x77, 0x77, 0x40, 0x2E, 0x02, 0x77, 0x77, 0x40, 0x4E, 0x04, 0x77,
  0x77, 0x40, 0x6E, 0x06, 0x77, 0x77, 0x40, 0x8E, 0x08, 0x77, 0x77, 0x40, 0xAE, 0x0A, 0x77, 0x77,
  0x40, 0xCE, 0x0C, 0x77, 0x77, 0x40, 0xEE, 0x0E, 0x77, 0x77, 0x30, 0x1F, 0x90, 0x17, 0x77, 0x72,
  0x02, 0xF9, 0x02, 0x75, 0x05, 0x0C, 0x71, 0x06, 0x0C, 0x60, 0x4F, 0x90, 0x47, 0x28, 0x11, 0x7E,
  0xA5, 0x81, 0x39, 0xEA, 0x60, 0x6F, 0x90, 0x67, 0x03, 0x09, 0xD3, 0x06, 0x0C, 0xD6, 0x08, 0xF9,
  0x08, 0x50, 0x50, 0xCF, 0x81, 0x39, 0xEF, 0x60, 0xAF, 0x90, 0xA2, 0x81, 0x17, 0xEF, 0xFD, 0x60,
  0xCF, 0x98, 0x1C, 0x39, 0xFF, 0xF9, 0x60, 0xEF, 0x90, 0xEF, 0x90, 0xA0, 0x3F, 0x81, 0xD7, 0x1F,
  0xFF, 0xC8, 0x1E, 0x81, 0x2D, 0x0A, 0x04, 0x3F, 0xFF, 0xB0, 0x65, 0xA8, 0x1D, 0x71, 0x5F, 0xFF,
  0xB6, 0x0A, 0x04, 0x71, 0xFF, 0xFB, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x97, 0x77, 0x74, 0xF9, 0x6C, 0x4C, 0x4C, 0x6F, 0x96, 0xC4, 0xC4, 0xC6, 0xF9, 0x6C, 0x4C, 0x4C,
  0x6F, 0x96, 0xC4, 0xC4, 0xC6, 0xF9, 0x6C, 0x4C, 0x4C, 0x6F, 0x96, 0xC4, 0xC4, 0xC6, 0xF9, 0x6C,
  0x4C, 0x4C, 0x6F, 0x96, 0xC4, 0xC4, 0xC6, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0x80, 0xAC, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_factory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_factory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_fastfood 48x48, 4-bit Alpha,  RLE, 276 bytes.
static const unsigned char ic_outlined_48_maps_fastfood_data[] PROGMEM = {
  0x77, 0x77, 0x2C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80,
  0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77, 0x77, 0x20, 0xEF, 0xFF, 0x90, 0xE7, 0x76,
  0x0C, 0xFF, 0xF9, 0x0D, 0x77, 0x60, 0xBF, 0xFF, 0x90, 0xB7, 0x76, 0x09, 0xFF, 0xF9, 0x0A, 0x80,
  0xC3, 0x00, 0x7B, 0x08, 0x80, 0xC3, 0x00, 0x8B, 0x07, 0x80, 0xC3, 0x00, 0xAB, 0x05, 0x80, 0xC3,
  0x00, 0xBB, 0x03, 0x72, 0x83, 0x37, 0xAD, 0xDA, 0x83, 0xDD, 0xA7, 0x37, 0x74, 0x0D, 0xB0, 0x26,
  0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x1C, 0x60, 0x70, 0xEF, 0xFA, 0x0E, 0x07, 0x76, 0x01,
  0xB0, 0xE4, 0x01, 0x0C, 0xFF, 0xE0, 0xC0, 0x17, 0x40, 0x2B, 0x0D, 0x30, 0x20, 0xDD, 0x83, 0xEA,
  0x63, 0x12, 0x83, 0x13, 0x6A, 0xED, 0x0D, 0x02, 0x73, 0x04, 0xB0, 0xB3, 0x0C, 0xC0, 0xE0, 0x67,
  0x50, 0x60, 0xEC, 0x0C, 0x73, 0x05, 0xB0, 0xA2, 0x08, 0xC0, 0xA7, 0x72, 0x0A, 0xC0, 0x87, 0x20,
  0x7B, 0x08, 0x20, 0xEB, 0x0A, 0x77, 0x40, 0xAB, 0x0E, 0x72, 0x08, 0xB8, 0x17, 0x06, 0xFF, 0xFF,
  0x06, 0x71, 0x0A, 0xB8, 0x15, 0x0B, 0xFF, 0xFF, 0x0A, 0x71, 0x0B, 0xB8, 0x13, 0x0D, 0xFF, 0xFF,
  0x0C, 0x71, 0x0D, 0xB0, 0x21, 0xFF, 0xFF, 0x90, 0xE7, 0x1C, 0x80, 0xC3, 0x00, 0x1B, 0x0E, 0x80,
  0xC3, 0x00, 0x2B, 0x0D, 0x80, 0xC3, 0x00, 0x4B, 0x0B, 0x80, 0xC3, 0x00, 0x5B, 0x0A, 0x2F, 0xFF,
  0xFA, 0x70, 0x7B, 0x08, 0x2F, 0xFF, 0xFA, 0x70, 0x8B, 0x07, 0x2F, 0xFF, 0xFA, 0x70, 0xAB, 0x05,
  0x2F, 0xFF, 0xFA, 0x70, 0xBB, 0x03, 0x80, 0xC3, 0x00, 0xDB, 0x02, 0x80, 0xC3, 0x0C, 0x80, 0xC3,
  0x00, 0x1B, 0x0E, 0x80, 0xC3, 0x00, 0x2B, 0x0D, 0x3F, 0xFF, 0xFA, 0x4E, 0x0B, 0x3F, 0xFF, 0xFA,
  0x4E, 0x08, 0x30, 0xDF, 0xFF, 0xF0, 0xD4, 0xD0, 0xE0, 0x23, 0x04, 0x0D, 0xFF, 0xFD, 0x0D, 0x04,
  0x4C, 0x0B, 0x03, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_fastfood() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_fastfood_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_festival 48x48, 4-bit Alpha,  RLE, 369 bytes.
static const unsigned char ic_outlined_48_maps_festival_data[] PROGMEM = {
  0x77, 0x70, 0x08, 0x80, 0xC5, 0x00, 0x9A, 0x09, 0x80, 0xC3, 0x00, 0xAC, 0x0A, 0x80, 0xC0, 0x00,
  0x20, 0xCE, 0x0C, 0x02, 0x77, 0x77, 0x50, 0x40, 0xEF, 0x90, 0xE0, 0x47, 0x77, 0x73, 0x07, 0xD0,
  0x0C, 0xD0, 0x77, 0x77, 0x70, 0x20, 0xCD, 0x0A, 0x20, 0xAD, 0x0C, 0x02, 0x77, 0x74, 0x05, 0x0E,
  0xD0, 0x74, 0x07, 0xD0, 0xE0, 0x57, 0x77, 0x10, 0x20, 0xBD, 0x0D, 0x03, 0x60, 0x30, 0xDD, 0x0B,
  0x02, 0x77, 0x50, 0x7E, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xE0, 0x77, 0x72, 0x05, 0x0D, 0xD0, 0xE0,
  0x67, 0x50, 0x60, 0xED, 0x0D, 0x05, 0x75, 0x05, 0x0C, 0xE0, 0xB0, 0x27, 0x70, 0x20, 0xBE, 0x0C,
  0x05, 0x71, 0x06, 0x0C, 0xE0, 0xE0, 0x57, 0x74, 0x05, 0x0E, 0xE0, 0xC0, 0x63, 0x81, 0x39, 0xEF,
  0x08, 0x77, 0x71, 0x08, 0xF8, 0x1E, 0x93, 0x80, 0xAD, 0x4F, 0x0E, 0xB0, 0x14, 0x01, 0xC0, 0x14,
  0x01, 0xC0, 0x14, 0x01, 0xC0, 0x14, 0x01, 0xB0, 0xE0, 0xBB, 0x07, 0x40, 0x7C, 0x07, 0x40, 0x7C,
  0x07, 0x40, 0x7C, 0x07, 0x40, 0x7B, 0x0B, 0x07, 0xC8, 0x27, 0x11, 0x7E, 0x82, 0x71, 0x17, 0xE8,
  0x27, 0x11, 0x7E, 0x82, 0x71, 0x17, 0xC8, 0x17, 0x0E, 0x80, 0xC4, 0xF0, 0xE2, 0x04, 0x80, 0xC4,
  0xF0, 0x43, 0x04, 0x0E, 0xE8, 0x2E, 0x44, 0xEE, 0x82, 0xE5, 0x5E, 0xE8, 0x2E, 0x55, 0xEE, 0x0E,
  0x04, 0x60, 0xAB, 0x81, 0xD7, 0x12, 0x05, 0xB8, 0x2E, 0xC7, 0x12, 0x82, 0x17, 0xCE, 0xB0, 0x52,
  0x81, 0x18, 0xDB, 0x0A, 0x71, 0x08, 0xB0, 0x64, 0x06, 0xB0, 0x97, 0x10, 0x9B, 0x05, 0x40, 0x7B,
  0x08, 0x71, 0x09, 0xB0, 0x54, 0x07, 0xB0, 0x87, 0x10, 0x8B, 0x06, 0x40, 0x6B, 0x09, 0x71, 0x09,
  0xB0, 0x44, 0x08, 0xB0, 0x77, 0x10, 0x7B, 0x07, 0x40, 0x5B, 0x09, 0x71, 0x0A, 0xB0, 0x44, 0x09,
  0xB0, 0x67, 0x10, 0x6B, 0x08, 0x40, 0x4B, 0x0A, 0x71, 0x0C, 0xB0, 0x34, 0x0A, 0xB0, 0x57, 0x10,
  0x5B, 0x0A, 0x40, 0x3B, 0x0C, 0x71, 0x0D, 0xB0, 0x24, 0x0B, 0xB0, 0x47, 0x10, 0x4B, 0x0B, 0x40,
  0x2B, 0x0D, 0x71, 0xC5, 0x0D, 0xB0, 0x27, 0x10, 0x2B, 0x0D, 0x5C, 0x70, 0x1B, 0x0D, 0x5C, 0x01,
  0x71, 0x01, 0xB0, 0xE5, 0x0E, 0xB0, 0x16, 0x04, 0xB0, 0xA4, 0x01, 0xB0, 0xE7, 0x30, 0xEB, 0x01,
  0x40, 0xCB, 0x04, 0x60, 0x7B, 0x08, 0x40, 0x3B, 0x0D, 0x73, 0x0D, 0xB0, 0x24, 0x09, 0xB0, 0x76,
  0x0A, 0xB0, 0x64, 0x04, 0xB0, 0xB7, 0x30, 0xBB, 0x04, 0x40, 0x6B, 0x0A, 0x60, 0xD8, 0x0C, 0x0F,
  0x0D, 0x50, 0x38, 0x0C, 0x2F, 0x03, 0x40, 0x88, 0x0C, 0x2F, 0x08, 0x40, 0xD8, 0x0C, 0x2F, 0x0D,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_festival() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_festival_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_fire_hydrant_alt 48x48, 4-bit Alpha,  RLE, 249 bytes.
static const unsigned char ic_outlined_48_maps_fire_hydrant_alt_data[] PROGMEM = {
  0x76, 0x82, 0x17, 0xAD, 0xA8, 0x2D, 0xA7, 0x17, 0x77, 0x30, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0x77,
  0x05, 0x0E, 0xFD, 0x0E, 0x05, 0x77, 0x50, 0x6F, 0xFA, 0x06, 0x77, 0x30, 0x5D, 0x86, 0xD7, 0x31,
  0x13, 0x7D, 0xD0, 0x57, 0x71, 0x01, 0x0E, 0xC0, 0x77, 0x10, 0x7C, 0x0E, 0x01, 0x77, 0x09, 0xC0,
  0x47, 0x30, 0x4C, 0x09, 0x76, 0x01, 0xC0, 0x77, 0x50, 0x7C, 0x01, 0x71, 0xFF, 0xFF, 0xC4, 0xFF,
  0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC7, 0x1C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x5C,
  0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC4, 0x86, 0x17, 0xCE, 0xEC, 0x71,
  0x4C, 0x78, 0x11, 0xAD, 0xE3, 0x05, 0x0E, 0xE0, 0xE0, 0x53, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0x92,
  0x05, 0xFB, 0x05, 0x2F, 0x98, 0x1E, 0x1A, 0xFA, 0x10, 0x10, 0xEF, 0xB0, 0xE0, 0x11, 0xFA, 0x0A,
  0x0D, 0xFA, 0x10, 0x7C, 0x82, 0x71, 0x17, 0xC0, 0x71, 0xFA, 0x0D, 0xC7, 0x0C, 0xB0, 0x74, 0x07,
  0xB0, 0xC7, 0xF9, 0x70, 0xEB, 0x01, 0x40, 0x1B, 0x0E, 0x7F, 0x97, 0x0E, 0xB0, 0x14, 0x01, 0xB0,
  0xE7, 0xF9, 0x70, 0xCB, 0x07, 0x40, 0x7B, 0x0C, 0x7C, 0x0D, 0xFA, 0x10, 0x7C, 0x82, 0x71, 0x17,
  0xC0, 0x71, 0xFA, 0x0D, 0x0A, 0xFA, 0x10, 0x10, 0xEF, 0xB0, 0xE0, 0x11, 0xFA, 0x81, 0xA1, 0xEF,
  0x92, 0x05, 0xFB, 0x05, 0x2F, 0x98, 0x4E, 0x10, 0x1A, 0xDE, 0x30, 0x50, 0xEE, 0x0E, 0x05, 0x3E,
  0x81, 0xDA, 0x17, 0xC4, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x4C, 0x75, 0xC7, 0x72, 0xC7, 0x5C, 0x77,
  0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x1F, 0xFF, 0xFC, 0x4F,
  0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_fire_hydrant_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_fire_hydrant_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_fire_truck 48x48, 4-bit Alpha,  RLE, 247 bytes.
static const unsigned char ic_outlined_48_maps_fire_truck_data[] PROGMEM = {
  0x77, 0x77, 0x20, 0x40, 0xDA, 0x0D, 0x04, 0x80, 0xC2, 0x00, 0xDC, 0x0D, 0x80, 0xC2, 0x0E, 0x80,
  0xC2, 0x0E, 0x71, 0xFF, 0xE3, 0x81, 0x1A, 0xDF, 0xC8, 0x1E, 0xB3, 0x4F, 0xFE, 0x20, 0x10, 0xEF,
  0xF9, 0x0E, 0x03, 0x3F, 0xFE, 0x20, 0xAF, 0xFB, 0x0C, 0x5B, 0x30, 0x7A, 0x07, 0x3B, 0x40, 0xDF,
  0xFC, 0x02, 0x4B, 0x30, 0x7A, 0x07, 0x3B, 0x4C, 0x74, 0x0B, 0xB0, 0x74, 0xB3, 0x07, 0xA0, 0x73,
  0xB4, 0xC7, 0x40, 0x5B, 0x0D, 0x4B, 0x30, 0x7A, 0x07, 0x3B, 0x4C, 0x74, 0x01, 0xC0, 0x21, 0xFF,
  0xE2, 0xC7, 0x50, 0xBB, 0x07, 0x1F, 0xFE, 0x2C, 0x75, 0x05, 0xB0, 0xD1, 0xFF, 0xE2, 0xC7, 0x50,
  0x1C, 0x02, 0x77, 0x71, 0xC7, 0x60, 0xBB, 0x07, 0x77, 0x71, 0xC7, 0x60, 0x5B, 0x0C, 0x80, 0xAE,
  0x0F, 0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77,
  0xF9, 0x58, 0x46, 0xCE, 0xEC, 0x67, 0xC3, 0x84, 0x6C, 0xEE, 0xC6, 0x5F, 0x93, 0x01, 0x0C, 0xE0,
  0xC0, 0x15, 0xC1, 0x01, 0x0C, 0xE0, 0xC0, 0x13, 0xC0, 0xD8, 0x0C, 0x7F, 0x0A, 0x80, 0xC7, 0xF0,
  0x10, 0xEF, 0x98, 0x2B, 0x11, 0xBF, 0xFA, 0x82, 0xB1, 0x1B, 0xFB, 0x18, 0x11, 0xAD, 0xE0, 0x12,
  0x01, 0xFF, 0xA0, 0x12, 0x01, 0xFB, 0x60, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x71, 0x0E, 0xB0, 0x12,
  0x01, 0xB0, 0xE7, 0x50, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x10, 0xCB, 0x82, 0xB1, 0x1B, 0xB0,
  0xC7, 0x50, 0x6F, 0xB0, 0x67, 0x10, 0x6F, 0xB0, 0x67, 0x60, 0xCF, 0x90, 0xC7, 0x30, 0xCF, 0x90,
  0xC7, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x73, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x72, 0x84, 0x6C, 0xEE,
  0xC6, 0x77, 0x84, 0x6C, 0xEE, 0xC6, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_fire_truck() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_fire_truck_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_flight_class 48x48, 4-bit Alpha,  RLE, 146 bytes.
static const unsigned char ic_outlined_48_maps_flight_class_data[] PROGMEM = {
  0xC7, 0x48, 0x11, 0xAD, 0xC8, 0x1D, 0xA1, 0x1C, 0x73, 0x01, 0x0E, 0xF9, 0x0E, 0x01, 0xC7, 0x30,
  0xAF, 0xB0, 0xAC, 0x73, 0x0D, 0xFB, 0x0D, 0xC7, 0x3C, 0x4F, 0x97, 0x3C, 0x4F, 0x97, 0x3C, 0x4F,
  0x97, 0x3C, 0x4C, 0x0D, 0xB0, 0x27, 0x2C, 0x4C, 0x08, 0xB0, 0x77, 0x2C, 0x4C, 0x03, 0xB0, 0xC7,
  0x2C, 0x4C, 0x10, 0xEB, 0x01, 0x71, 0xC4, 0xC1, 0x0A, 0xB0, 0x67, 0x1C, 0x4C, 0x10, 0x5B, 0x0B,
  0x71, 0xC4, 0xC1, 0x01, 0xC7, 0x10, 0xDF, 0xB0, 0xD2, 0x0B, 0xB0, 0x57, 0x0A, 0xFB, 0x0A, 0x20,
  0x7B, 0x0A, 0x70, 0x10, 0xEF, 0x90, 0xE0, 0x12, 0x02, 0xB0, 0xE7, 0x18, 0x11, 0xAD, 0xC8, 0x1D,
  0xA1, 0x40, 0xDB, 0x04, 0x77, 0x70, 0x8B, 0x09, 0x77, 0x70, 0x3B, 0x0D, 0x77, 0x71, 0x0E, 0xB0,
  0x37, 0x77, 0x0A, 0xB0, 0x87, 0x77, 0x05, 0xB0, 0xD7, 0x77, 0x01, 0xFF, 0xF5, 0x0A, 0xFF, 0xE5,
  0x02, 0x0E, 0xFF, 0xD6, 0x81, 0x2A, 0xEF, 0xFB, 0x80, 0xE6, 0x0F, 0xFE, 0x6F, 0xFE, 0x6F, 0xFE,
  0x6F, 0xFE,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_flight_class() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 8, 35, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_flight_class_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_flight 48x48, 4-bit Alpha,  RLE, 207 bytes.
static const unsigned char ic_outlined_48_maps_flight_data[] PROGMEM = {
  0x77, 0x38, 0x28, 0xDD, 0x87, 0x77, 0x75, 0x08, 0xC0, 0x87, 0x77, 0x74, 0x0D, 0xC0, 0xD7, 0x77,
  0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74,
  0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7,
  0x77, 0x72, 0x01, 0x0A, 0xE0, 0xA0, 0x17, 0x77, 0x60, 0x60, 0xEF, 0x90, 0xE0, 0x67, 0x77, 0x30,
  0x30, 0xCF, 0xD0, 0xC0, 0x37, 0x77, 0x08, 0xFF, 0xA0, 0x87, 0x74, 0x04, 0x0D, 0xFF, 0xC0, 0xD0,
  0x47, 0x70, 0x10, 0xAF, 0xFF, 0x90, 0xA0, 0x17, 0x40, 0x60, 0xEF, 0xFF, 0xB0, 0xE0, 0x67, 0x10,
  0x30, 0xCF, 0xFF, 0xF0, 0xC0, 0x35, 0x08, 0xFF, 0xFF, 0xC0, 0x82, 0x04, 0x0D, 0xFC, 0x81, 0xB7,
  0x2E, 0x81, 0x27, 0xBF, 0xC0, 0xD0, 0x4F, 0xB8, 0x1B, 0x61, 0x3E, 0x38, 0x11, 0x6B, 0xFF, 0xA8,
  0x1E, 0xA5, 0x7E, 0x78, 0x15, 0xAE, 0xFA, 0x81, 0xD9, 0x47, 0x3E, 0x73, 0x81, 0x49, 0xDB, 0x81,
  0xD8, 0x37, 0x6E, 0x76, 0x81, 0x38, 0xD7, 0x72, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77,
  0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x74, 0xE7, 0x77, 0x73, 0x09, 0xE0, 0x97, 0x77, 0x70, 0x20,
  0xCF, 0x90, 0xC0, 0x27, 0x77, 0x40, 0x50, 0xEF, 0xB0, 0xE0, 0x57, 0x77, 0x3F, 0xF7, 0x77, 0x3B,
  0x86, 0xEB, 0x62, 0x26, 0xBE, 0xB7, 0x77, 0x38, 0x1D, 0x84, 0x71, 0x81, 0x48, 0xD7, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_flight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_flight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_forest 48x48, 4-bit Alpha,  RLE, 345 bytes.
static const unsigned char ic_outlined_48_maps_forest_data[] PROGMEM = {
  0x77, 0x30, 0x05, 0x73, 0x00, 0x57, 0x77, 0x75, 0x82, 0x1E, 0xE1, 0x71, 0x82, 0x1E, 0xE1, 0x77,
  0x77, 0x40, 0xBA, 0x0B, 0x71, 0x0B, 0xA0, 0xB7, 0x77, 0x73, 0x07, 0xC0, 0x66, 0x06, 0xC0, 0x77,
  0x77, 0x71, 0x02, 0xE0, 0x24, 0x02, 0xE0, 0x27, 0x77, 0x70, 0xCE, 0x0C, 0x40, 0xCE, 0x0C, 0x77,
  0x76, 0x08, 0xF9, 0x08, 0x20, 0x8F, 0x90, 0x87, 0x77, 0x40, 0x3C, 0x00, 0x9C, 0x00, 0x3C, 0x00,
  0x9C, 0x03, 0x77, 0x72, 0x01, 0x0D, 0xB0, 0xD2, 0x0D, 0xB0, 0x0D, 0xB0, 0xD2, 0x0D, 0xB0, 0xD0,
  0x17, 0x77, 0x10, 0xAC, 0x03, 0x20, 0x3F, 0x90, 0x32, 0x03, 0xC0, 0xA7, 0x77, 0x05, 0xC0, 0x84,
  0x08, 0xE0, 0x84, 0x08, 0xC0, 0x57, 0x75, 0x01, 0x0E, 0xB0, 0xC6, 0x0C, 0xC0, 0xC6, 0x0C, 0xB0,
  0xE0, 0x17, 0x74, 0x0B, 0xB0, 0xE0, 0x26, 0x02, 0x0E, 0xB0, 0xB6, 0x02, 0x0E, 0xB0, 0xB7, 0x73,
  0x07, 0xC0, 0x67, 0x10, 0x6C, 0x06, 0x60, 0x6C, 0x07, 0x77, 0x10, 0x2C, 0x0B, 0x73, 0x0B, 0xC0,
  0x26, 0x0B, 0xC0, 0x27, 0x70, 0xCB, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xB0, 0xC6, 0x01, 0x0E, 0xB0,
  0xC7, 0x60, 0x8F, 0x0B, 0x60, 0xBF, 0x08, 0x30, 0xBF, 0x08, 0x74, 0x03, 0xF0, 0xE0, 0x16, 0x01,
  0x0E, 0xF0, 0x32, 0x01, 0x0E, 0xF0, 0x37, 0x20, 0x10, 0xDF, 0x06, 0x71, 0x06, 0xF0, 0xD0, 0x12,
  0x06, 0xF0, 0xD0, 0x17, 0x10, 0xAF, 0x0C, 0x73, 0x0C, 0xF0, 0xA3, 0x0C, 0xF0, 0xA7, 0x40, 0x9C,
  0x02, 0x73, 0x02, 0xC0, 0x96, 0x02, 0xC0, 0x97, 0x60, 0x3C, 0x07, 0x75, 0x07, 0xC0, 0x46, 0x07,
  0xC0, 0x37, 0x50, 0xDB, 0x0C, 0x77, 0x0C, 0xB0, 0xD7, 0x0C, 0xB0, 0xD7, 0x40, 0x8C, 0x03, 0x77,
  0x03, 0xC0, 0x86, 0x03, 0xC0, 0x87, 0x20, 0x3C, 0x08, 0x77, 0x20, 0x8C, 0x03, 0x60, 0x8C, 0x03,
  0x71, 0x0C, 0xB0, 0xD7, 0x74, 0x0D, 0xB0, 0xC7, 0x0D, 0xB0, 0xC7, 0x07, 0xC0, 0x47, 0x74, 0x04,
  0xC0, 0x76, 0x04, 0xC0, 0x75, 0x02, 0x0E, 0xB0, 0x97, 0x76, 0x09, 0xC0, 0x26, 0x09, 0xB0, 0xE0,
  0x24, 0x0B, 0x80, 0xC6, 0xF0, 0xB3, 0x06, 0x80, 0xD0, 0xF8, 0x26, 0x01, 0xE8, 0x0D, 0x0F, 0x81,
  0xE1, 0xA8, 0x0D, 0x2F, 0x0A, 0x77, 0xF9, 0x4F, 0x97, 0x77, 0x7F, 0x94, 0xF9, 0x77, 0x77, 0xF9,
  0x4F, 0x97, 0x77, 0x7F, 0x94, 0xF9, 0x77, 0x77, 0xF9, 0x4F, 0x97, 0x77, 0x7F, 0x94, 0xF9, 0x77,
  0x77, 0xF9, 0x4F, 0x97, 0x77, 0x7F, 0x94, 0xF9, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_forest() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 47, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_forest_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_fork_left 48x48, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_outlined_48_maps_fork_left_data[] PROGMEM = {
  0x77, 0x50, 0x07, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7C, 0x07, 0x77, 0x70, 0x7E, 0x07,
  0x77, 0x50, 0x7F, 0x90, 0x77, 0x73, 0x07, 0xFB, 0x07, 0x77, 0x10, 0x7F, 0xD0, 0x77, 0x60, 0x7C,
  0x0E, 0xC0, 0xEC, 0x07, 0x75, 0x07, 0xB0, 0xE0, 0x3C, 0x03, 0x0E, 0xB0, 0x77, 0x68, 0x27, 0xFE,
  0x31, 0xC1, 0x82, 0x3E, 0xF7, 0x77, 0x10, 0x70, 0x32, 0xC2, 0x03, 0x07, 0x77, 0x6C, 0x76, 0x00,
  0x77, 0x2C, 0x75, 0x07, 0xA0, 0x77, 0x1C, 0x74, 0x07, 0xC0, 0x77, 0xC7, 0x30, 0x7C, 0x0E, 0x03,
  0x7C, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x1C, 0x71, 0x07, 0xC8, 0x2E, 0x42, 0x27, 0xC7, 0x07, 0xFB,
  0x81, 0xD9, 0x43, 0xC6, 0x07, 0xFF, 0x0D, 0x05, 0x1C, 0x60, 0x7F, 0xFA, 0x0A, 0xC7, 0x07, 0xE8,
  0x2D, 0xBC, 0xEF, 0xB7, 0x10, 0x7C, 0x0E, 0x03, 0x30, 0x20, 0x8F, 0x97, 0x20, 0x7C, 0x0E, 0x03,
  0x40, 0x20, 0xCE, 0x73, 0x07, 0xC0, 0xE0, 0x34, 0x01, 0x0C, 0xD7, 0x40, 0x7C, 0x07, 0x50, 0x2D,
  0x75, 0x07, 0xA0, 0x77, 0x09, 0xC7, 0x60, 0x07, 0x71, 0x03, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7,
  0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_fork_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 35, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_fork_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_fork_right 48x48, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_outlined_48_maps_fork_right_data[] PROGMEM = {
  0x70, 0x07, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7C, 0x07, 0x77, 0x70, 0x7E, 0x07, 0x77,
  0x50, 0x7F, 0x90, 0x77, 0x73, 0x07, 0xFB, 0x07, 0x77, 0x10, 0x7F, 0xD0, 0x77, 0x60, 0x7C, 0x0E,
  0xC0, 0xEC, 0x07, 0x75, 0x07, 0xB0, 0xE0, 0x3C, 0x03, 0x0E, 0xB0, 0x77, 0x68, 0x27, 0xFE, 0x31,
  0xC1, 0x82, 0x3E, 0xF7, 0x77, 0x10, 0x70, 0x32, 0xC2, 0x03, 0x07, 0x77, 0x6C, 0x77, 0x73, 0xC7,
  0x20, 0x07, 0x76, 0xC7, 0x10, 0x7A, 0x07, 0x75, 0xC7, 0x07, 0xC0, 0x77, 0x4C, 0x70, 0x30, 0xEC,
  0x07, 0x73, 0xC7, 0x10, 0x30, 0xEC, 0x07, 0x72, 0xC7, 0x82, 0x22, 0x4E, 0xC0, 0x77, 0x1C, 0x38,
  0x14, 0x9D, 0xFB, 0x07, 0x7C, 0x10, 0x50, 0xDF, 0xF0, 0x76, 0xC0, 0xAF, 0xFA, 0x07, 0x6F, 0xB8,
  0x2E, 0xCB, 0xDE, 0x07, 0x7F, 0x90, 0x80, 0x23, 0x03, 0x0E, 0xC0, 0x77, 0x1E, 0x0C, 0x02, 0x40,
  0x30, 0xEC, 0x07, 0x72, 0xD0, 0xC0, 0x14, 0x03, 0x0E, 0xC0, 0x77, 0x3D, 0x02, 0x50, 0x7C, 0x07,
  0x74, 0xC0, 0x97, 0x07, 0xA0, 0x77, 0x5C, 0x03, 0x71, 0x00, 0x77, 0x6C, 0x77, 0x73, 0xC7, 0x77,
  0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_fork_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 6, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_fork_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_fort 48x48, 4-bit Alpha,  RLE, 244 bytes.
static const unsigned char ic_outlined_48_maps_fort_data[] PROGMEM = {
  0xC4, 0xC4, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xC4,
  0xF9, 0x4C, 0x4C, 0x4C, 0x4C, 0x4F, 0xFF, 0xB4, 0x80, 0xC4, 0xF4, 0x80, 0xC4, 0xF4, 0x80, 0xC4,
  0xF4, 0xFF, 0xE0, 0x7C, 0x0E, 0x03, 0x60, 0x30, 0xEC, 0x07, 0x40, 0x7C, 0x0E, 0x03, 0x60, 0x30,
  0xEC, 0x81, 0x70, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x07, 0x60, 0x7C, 0x0E, 0x03, 0x40, 0x30,
  0xEC, 0x07, 0x30, 0x7C, 0x0E, 0x40, 0xEC, 0x07, 0x71, 0x07, 0xC0, 0xE4, 0x0E, 0xC0, 0x75, 0x07,
  0xC4, 0xC0, 0x77, 0x30, 0x7C, 0x4C, 0x07, 0x7C, 0x4C, 0x75, 0xC4, 0xC7, 0x1C, 0x4C, 0x75, 0xC4,
  0xC7, 0x1C, 0x4F, 0xFE, 0x4C, 0x71, 0xC4, 0xFF, 0xE4, 0xC7, 0x1C, 0x4F, 0xFE, 0x4C, 0x71, 0xC4,
  0xFF, 0xE4, 0xC7, 0x1C, 0x77, 0x77, 0xC7, 0x1C, 0x77, 0x77, 0xC7, 0x1C, 0x77, 0x77, 0xC7, 0x1C,
  0x77, 0x77, 0xC7, 0x1C, 0x73, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x73, 0xC7, 0x1C, 0x72, 0x09, 0xF9,
  0x09, 0x72, 0xC7, 0x07, 0xC7, 0x10, 0xBF, 0xB0, 0xB7, 0x1C, 0x07, 0x50, 0x7C, 0x0E, 0x70, 0x9F,
  0xD0, 0x97, 0x0E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x36, 0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02,
  0x60, 0x30, 0xEC, 0x81, 0x70, 0x7C, 0x0E, 0x03, 0x70, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08,
  0x70, 0x30, 0xEC, 0x07, 0xC0, 0xE0, 0x37, 0x10, 0xCB, 0x05, 0x60, 0x5B, 0x0C, 0x71, 0x03, 0x0E,
  0xF9, 0x03, 0x72, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x20, 0x3F, 0x97, 0x3C, 0x71, 0xC7, 0x3F,
  0x97, 0x3C, 0x71, 0xC7, 0x3F, 0xFF, 0x97, 0x18, 0x0C, 0x0F, 0x71, 0x80, 0xC0, 0xF7, 0x18, 0x0C,
  0x0F, 0x71, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_fort() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_fort_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_hail 48x48, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_outlined_48_maps_hail_data[] PROGMEM = {
  0x76, 0x84, 0x1A, 0xDD, 0xA1, 0x7C, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x15, 0x01, 0xB0, 0xE7, 0x50,
  0xAE, 0x0A, 0x50, 0x2B, 0x0C, 0x75, 0x0D, 0xE0, 0xD5, 0x05, 0xB0, 0xA7, 0x50, 0xDE, 0x0D, 0x50,
  0xAB, 0x07, 0x75, 0x0A, 0xE0, 0xA4, 0x01, 0xC0, 0x27, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x40, 0xAB,
  0x0C, 0x77, 0x84, 0x1A, 0xDD, 0xA1, 0x40, 0x9C, 0x04, 0x77, 0x71, 0x02, 0x0C, 0xC0, 0xA7, 0x76,
  0x81, 0x25, 0xAD, 0x0D, 0x01, 0x76, 0x83, 0x48, 0xBD, 0xEF, 0xA0, 0xD0, 0x17, 0x48, 0x11, 0x8E,
  0xFE, 0x09, 0x75, 0x07, 0x0E, 0xFE, 0x09, 0x02, 0x74, 0x01, 0x0B, 0xFF, 0x97, 0x60, 0xCF, 0xFA,
  0x75, 0x0A, 0xFF, 0xB7, 0x40, 0x5C, 0x0E, 0x06, 0xFD, 0x74, 0x0D, 0xB0, 0xD0, 0x21, 0xFD, 0x73,
  0x03, 0xC0, 0x32, 0xFD, 0x73, 0x07, 0xB0, 0xA3, 0xFD, 0x73, 0x0B, 0xB0, 0x53, 0xFD, 0x73, 0x0D,
  0xB0, 0x23, 0xFD, 0x73, 0x0E, 0xB0, 0x13, 0xFD, 0x73, 0xC4, 0xFD, 0x77, 0x4F, 0xD7, 0x74, 0xFD,
  0x77, 0x4F, 0xD7, 0x74, 0xFD, 0x71, 0xE4, 0xC4, 0xC7, 0x1E, 0x4C, 0x4C, 0x71, 0xE4, 0xC4, 0xC7,
  0x1E, 0x4C, 0x4C, 0x71, 0xE4, 0xC4, 0xC7, 0x1E, 0x4C, 0x4C, 0x71, 0xE4, 0xC4, 0xC7, 0x1E, 0x4C,
  0x4C, 0x71, 0xE4, 0xC4, 0xC7, 0x1E, 0x4C, 0x4C, 0x71, 0xE4, 0xC4, 0xC7, 0x1E, 0x4C, 0x4C, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_hail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 37, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_hail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_handyman 48x48, 4-bit Alpha,  RLE, 430 bytes.
static const unsigned char ic_outlined_48_maps_handyman_data[] PROGMEM = {
  0x77, 0x74, 0x81, 0x2B, 0x18, 0x0C, 0x00, 0x82, 0x2D, 0xFB, 0x77, 0x30, 0x90, 0x27, 0x72, 0x02,
  0x0D, 0xA0, 0xD7, 0x72, 0x82, 0xBF, 0xE2, 0x77, 0x02, 0x0D, 0xB0, 0xD7, 0x71, 0x0B, 0xB0, 0xE0,
  0x27, 0x50, 0x20, 0xDC, 0x0D, 0x20, 0x70, 0x17, 0x30, 0xBD, 0x0E, 0x02, 0x73, 0x02, 0x0D, 0xD8,
  0x4D, 0x09, 0xFC, 0x17, 0x10, 0xBF, 0x0E, 0x02, 0x71, 0x02, 0x0D, 0xE0, 0xD0, 0x9B, 0x0C, 0x01,
  0x60, 0xAF, 0xA0, 0xE0, 0x27, 0x03, 0x0E, 0xFD, 0x0C, 0x01, 0x50, 0x40, 0xEF, 0xA0, 0xA7, 0x10,
  0x38, 0x01, 0x70, 0xDF, 0x0C, 0x01, 0x50, 0x40, 0xEF, 0x90, 0xA7, 0x60, 0x8F, 0xA0, 0xC0, 0x15,
  0x04, 0x0E, 0xF0, 0xA7, 0x50, 0x8F, 0xC0, 0xC0, 0x15, 0x04, 0x0E, 0xE0, 0xE0, 0x47, 0x30, 0x20,
  0xEF, 0xD0, 0xC6, 0x04, 0x0E, 0xE0, 0xE0, 0x47, 0x30, 0x30, 0xEF, 0xD0, 0x96, 0x04, 0x0F, 0xBC,
  0x0E, 0x04, 0x73, 0x07, 0xFE, 0x01, 0x72, 0x06, 0xC0, 0xE0, 0x47, 0x10, 0x5F, 0xF0, 0x57, 0x30,
  0x6C, 0x0E, 0x04, 0x60, 0x5F, 0xA0, 0xCD, 0x07, 0x74, 0x06, 0xC0, 0xE0, 0x44, 0x05, 0xD0, 0x80,
  0xEA, 0x81, 0x80, 0x8C, 0x06, 0x75, 0x06, 0xC0, 0xE0, 0x42, 0x05, 0xD8, 0x35, 0x03, 0xE8, 0x30,
  0x8B, 0x02, 0x76, 0x06, 0xC8, 0x1E, 0x45, 0xD0, 0x53, 0x02, 0x58, 0x18, 0xFA, 0x77, 0x10, 0x6C,
  0x0E, 0xD0, 0x57, 0x40, 0x70, 0x17, 0x72, 0x06, 0xF9, 0x05, 0x77, 0x77, 0x30, 0x6E, 0x05, 0x77,
  0x77, 0x40, 0x4D, 0x05, 0x77, 0x77, 0x80, 0x03, 0x06, 0xD0, 0x54, 0x81, 0x13, 0x37, 0x77, 0x08,
  0xFA, 0x05, 0x40, 0x10, 0xDA, 0x07, 0x77, 0x50, 0x8F, 0xA0, 0x54, 0x01, 0x0D, 0xC0, 0x77, 0x73,
  0x08, 0xFA, 0x06, 0x40, 0x10, 0xDE, 0x07, 0x77, 0x10, 0x8C, 0x0D, 0x08, 0xC0, 0x43, 0x01, 0x0D,
  0xA0, 0x80, 0xEC, 0x07, 0x76, 0x08, 0xC8, 0x2D, 0x20, 0x8B, 0x04, 0x20, 0x10, 0xDA, 0x82, 0x70,
  0x3E, 0xC0, 0x77, 0x40, 0x8C, 0x83, 0xD2, 0x02, 0xEB, 0x04, 0x20, 0x4B, 0x83, 0xD1, 0x03, 0xEC,
  0x07, 0x72, 0x08, 0xC8, 0x3D, 0x20, 0x2E, 0xC0, 0x32, 0x04, 0xC8, 0x3D, 0x10, 0x3E, 0xC0, 0x77,
  0x08, 0xC8, 0x3D, 0x20, 0x2E, 0xC0, 0x84, 0x09, 0xC8, 0x3D, 0x10, 0x3E, 0xC0, 0x75, 0x08, 0xC8,
  0x3D, 0x20, 0x2E, 0xC0, 0x86, 0x09, 0xC8, 0x3D, 0x10, 0x3E, 0xC0, 0x73, 0x08, 0xC8, 0x3D, 0x20,
  0x2E, 0xC0, 0x87, 0x10, 0x9C, 0x83, 0xD1, 0x03, 0xEC, 0x81, 0x70, 0x7C, 0x83, 0xD2, 0x02, 0xEC,
  0x08, 0x73, 0x09, 0xC8, 0x3D, 0x10, 0x3E, 0xC0, 0x60, 0xEC, 0x82, 0x20, 0x2E, 0xC0, 0x87, 0x50,
  0x9C, 0x82, 0xD1, 0x03, 0xC0, 0xD0, 0xCC, 0x81, 0x82, 0xEC, 0x08, 0x77, 0x09, 0xC8, 0x1D, 0x29,
  0xC8, 0x1B, 0x2E, 0xFA, 0x08, 0x77, 0x20, 0x9F, 0xA8, 0x3D, 0x10, 0x2E, 0xF0, 0x87, 0x74, 0x09,
  0xF0, 0xD0, 0x13, 0x02, 0x0E, 0xD0, 0x87, 0x76, 0x09, 0xD0, 0xD0, 0x15, 0x02, 0x0E, 0xB0, 0x87,
  0x77, 0x10, 0x9B, 0x0D, 0x01, 0x78, 0x22, 0xCE, 0x77, 0x77, 0x38, 0x28, 0xEB, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_handyman() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_handyman_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_hardware 48x48, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_outlined_48_maps_hardware_data[] PROGMEM = {
  0x68, 0x25, 0x9D, 0xEF, 0xD5, 0x07, 0xC4, 0x04, 0x0D, 0xFF, 0xA4, 0x07, 0xD3, 0x08, 0xFF, 0xC3,
  0x07, 0xE2, 0x08, 0xFF, 0xD2, 0x07, 0xF1, 0x04, 0xD0, 0x90, 0x37, 0x2C, 0x10, 0x7F, 0x91, 0x0D,
  0xB0, 0xD0, 0x37, 0x4C, 0x07, 0xFA, 0x05, 0xFE, 0x4F, 0xF0, 0x9F, 0xE4, 0xFF, 0x0D, 0xFE, 0x4F,
  0xF0, 0xEF, 0xE4, 0xFF, 0x73, 0xC4, 0xC0, 0x7F, 0xA7, 0x3C, 0x4C, 0x10, 0x7F, 0x97, 0x3C, 0x4C,
  0x20, 0x7F, 0x73, 0xC4, 0xC3, 0x07, 0xE7, 0x3C, 0x4C, 0x40, 0x7D, 0x73, 0xC4, 0xC5, 0x07, 0xC7,
  0x3F, 0xD7, 0x76, 0xFD, 0x77, 0x6F, 0xD7, 0x76, 0xFD, 0x77, 0x6C, 0x4C, 0x77, 0x6C, 0x4C, 0x77,
  0x6C, 0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6C,
  0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6C, 0x4C, 0x77, 0x6F, 0xD7,
  0x76, 0xFD, 0x77, 0x60, 0xDF, 0xB0, 0xD7, 0x76, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_hardware() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_hardware_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_home_repair_service 48x48, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_outlined_48_maps_home_repair_service_data[] PROGMEM = {
  0x74, 0x81, 0x1A, 0xDF, 0xD8, 0x1D, 0xA1, 0x77, 0x70, 0x10, 0xEF, 0xFA, 0x0E, 0x01, 0x77, 0x60,
  0xAF, 0xFC, 0x0A, 0x77, 0x60, 0xDF, 0xFC, 0x0D, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77,
  0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x74, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x84, 0xDA, 0x10, 0x1E,
  0x80, 0xC0, 0xF8, 0x1E, 0x1A, 0x80, 0xC2, 0xF0, 0xA0, 0xD8, 0x0C, 0x2F, 0x0D, 0xC7, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xF9,
  0x4C, 0x77, 0x2C, 0x48, 0x0A, 0xC4, 0xF4, 0xC7, 0x72, 0xC4, 0xF9, 0x4C, 0x77, 0x2C, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x48, 0x0A, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_home_repair_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_home_repair_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_hotel 48x48, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_outlined_48_maps_hotel_data[] PROGMEM = {
  0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC7, 0x72, 0xFF, 0xA8,
  0x2E, 0xC8, 0x24, 0xC7, 0x72, 0xFF, 0xE0, 0x93, 0xC5, 0x84, 0x6C, 0xEE, 0xC6, 0x5F, 0xFF, 0x0B,
  0x2C, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x3F, 0xFF, 0x90, 0x91, 0xC3, 0x0C, 0xF9, 0x0C, 0x3C, 0x75,
  0x81, 0x15, 0xDC, 0x02, 0xC2, 0x06, 0xFB, 0x06, 0x2C, 0x77, 0x01, 0x0D, 0xB0, 0x8C, 0x20, 0xCB,
  0x82, 0xB1, 0x1B, 0xB0, 0xC2, 0xC7, 0x71, 0x05, 0xB0, 0xCC, 0x20, 0xEB, 0x01, 0x20, 0x1B, 0x0E,
  0x2C, 0x77, 0x10, 0x1B, 0x0E, 0xC2, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE2, 0xC7, 0x72, 0xF9, 0x20,
  0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC2, 0xC7, 0x72, 0xF9, 0x20, 0x6F, 0xB0, 0x62, 0xC7, 0x72, 0xF9,
  0x30, 0xCF, 0x90, 0xC3, 0xC7, 0x72, 0xF9, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x3C, 0x77, 0x2F, 0x95,
  0x84, 0x6C, 0xEE, 0xC6, 0x5C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C, 0x77, 0x28,
  0x0A, 0xE4, 0xF8, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F,
  0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_hotel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_hotel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_hvac 48x48, 4-bit Alpha,  RLE, 238 bytes.
static const unsigned char ic_outlined_48_maps_hvac_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x28, 0x90, 0x16,
  0xAD, 0xEE, 0xDA, 0x61, 0x72, 0xF9, 0x70, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0xF9, 0x60, 0x40, 0xEF,
  0xD0, 0xE0, 0x46, 0xF9, 0x50, 0x6F, 0xFA, 0x06, 0x5F, 0x94, 0x04, 0xD8, 0x1D, 0x62, 0x28, 0x12,
  0x6D, 0xD0, 0x44, 0xF9, 0x30, 0x10, 0xEC, 0x07, 0x71, 0x07, 0xC0, 0xE0, 0x13, 0xF9, 0x30, 0x9F,
  0xFE, 0x09, 0x3F, 0x92, 0x01, 0xFF, 0xF9, 0x01, 0x2F, 0x92, 0x06, 0xB0, 0xD7, 0x70, 0xDB, 0x06,
  0x2F, 0x92, 0x0B, 0xB0, 0x77, 0x70, 0x7B, 0x0B, 0x2F, 0x92, 0x0D, 0xB0, 0x37, 0x70, 0x3B, 0x0D,
  0x2F, 0x92, 0x0E, 0xFF, 0xF9, 0x0E, 0x2F, 0x92, 0x0E, 0xFF, 0xF9, 0x0E, 0x2F, 0x92, 0x0D, 0xB0,
  0x37, 0x70, 0x3B, 0x0D, 0x2F, 0x92, 0x0B, 0xB0, 0x77, 0x70, 0x7B, 0x0B, 0x2F, 0x92, 0x06, 0xB0,
  0xD7, 0x70, 0xDB, 0x06, 0x2F, 0x92, 0x01, 0xFF, 0xF9, 0x01, 0x2F, 0x93, 0x09, 0xFF, 0xE0, 0x93,
  0xF9, 0x30, 0x10, 0xEC, 0x07, 0x71, 0x07, 0xC0, 0xE0, 0x13, 0xF9, 0x40, 0x4D, 0x81, 0xD6, 0x22,
  0x81, 0x26, 0xDD, 0x04, 0x4F, 0x95, 0x06, 0xFF, 0xA0, 0x65, 0xF9, 0x60, 0x40, 0xEF, 0xD0, 0xE0,
  0x46, 0xF9, 0x70, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0xF9, 0x72, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA6,
  0x17, 0x2F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE,
  0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_hvac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_hvac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_icecream 48x48, 4-bit Alpha,  RLE, 326 bytes.
static const unsigned char ic_outlined_48_maps_icecream_data[] PROGMEM = {
  0x76, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x27, 0x77, 0x30, 0x30, 0xBF, 0xB0, 0xB0, 0x37, 0x77,
  0x08, 0xFF, 0x08, 0x77, 0x50, 0xBF, 0xFA, 0x0B, 0x77, 0x30, 0xBD, 0x81, 0xB6, 0x22, 0x81, 0x26,
  0xBD, 0x0B, 0x77, 0x10, 0x8C, 0x0D, 0x03, 0x71, 0x03, 0x0D, 0xC0, 0x87, 0x60, 0x3C, 0x0B, 0x75,
  0x0B, 0xC0, 0x37, 0x50, 0xBB, 0x0D, 0x01, 0x75, 0x01, 0x0D, 0xB0, 0xB7, 0x40, 0x2C, 0x03, 0x77,
  0x03, 0xC0, 0x27, 0x30, 0x7B, 0x0B, 0x77, 0x20, 0xBB, 0x07, 0x72, 0x02, 0x0D, 0xB0, 0x57, 0x72,
  0x05, 0xB0, 0xD0, 0x27, 0x09, 0xD0, 0x27, 0x72, 0x02, 0xD0, 0x95, 0x0B, 0xE7, 0x74, 0xE0, 0xB3,
  0x09, 0xE0, 0xC7, 0x74, 0x0C, 0xE8, 0x19, 0x02, 0xC0, 0xD0, 0x57, 0x77, 0x10, 0x50, 0xDC, 0x02,
  0x08, 0xB0, 0xD0, 0x17, 0x77, 0x30, 0x10, 0xDB, 0x08, 0x0C, 0xB0, 0x57, 0x77, 0x50, 0x5B, 0x0B,
  0x0E, 0xB0, 0x17, 0x77, 0x50, 0x1B, 0x00, 0xEB, 0x01, 0x77, 0x75, 0x01, 0xB0, 0xE0, 0xCB, 0x05,
  0x77, 0x75, 0x05, 0xB0, 0xC0, 0x8B, 0x0D, 0x01, 0x58, 0x1B, 0xC3, 0x71, 0x81, 0x3C, 0xB5, 0x01,
  0x0D, 0xB0, 0x80, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xB8, 0x1B, 0x52, 0x28, 0x12, 0x5B, 0xB8, 0x4D,
  0x51, 0x15, 0xDC, 0x81, 0x20, 0x9F, 0xFF, 0xFC, 0x09, 0x30, 0xBF, 0xFF, 0xFA, 0x0B, 0x50, 0x9F,
  0xFD, 0x0E, 0xF9, 0x09, 0x78, 0x22, 0x8C, 0xEC, 0x89, 0x2E, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0xDC,
  0x82, 0xEC, 0x82, 0x75, 0x01, 0x0E, 0xB0, 0x77, 0x10, 0x6C, 0x01, 0x77, 0x30, 0x7B, 0x0E, 0x01,
  0x70, 0xDB, 0x08, 0x77, 0x50, 0xEB, 0x08, 0x60, 0x6B, 0x0E, 0x01, 0x77, 0x50, 0x7C, 0x01, 0x50,
  0xEB, 0x08, 0x77, 0x70, 0xDB, 0x09, 0x40, 0x7B, 0x0E, 0x01, 0x77, 0x70, 0x6C, 0x02, 0x30, 0xEB,
  0x08, 0x77, 0x72, 0x0D, 0xB0, 0xA2, 0x07, 0xB0, 0xE0, 0x17, 0x77, 0x20, 0x5C, 0x81, 0x21, 0xEB,
  0x07, 0x77, 0x74, 0x0C, 0xB0, 0xA0, 0x7B, 0x0E, 0x77, 0x75, 0x04, 0xC0, 0xEB, 0x07, 0x77, 0x76,
  0x0C, 0xE0, 0xE7, 0x77, 0x70, 0x4E, 0x07, 0x77, 0x77, 0x10, 0xBC, 0x0E, 0x77, 0x77, 0x20, 0x3C,
  0x06, 0x77, 0x77, 0x30, 0xAA, 0x0D, 0x77, 0x77, 0x40, 0x2A, 0x06, 0x77, 0x77, 0x50, 0xA0, 0xD7,
  0x77, 0x76, 0x02, 0x05, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_icecream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_icecream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_kebab_dining 48x48, 4-bit Alpha,  RLE, 315 bytes.
static const unsigned char ic_outlined_48_maps_kebab_dining_data[] PROGMEM = {
  0x60, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x18,
  0x14, 0xBE, 0xE8, 0x1E, 0xB4, 0x71, 0x81, 0x4B, 0xEE, 0x81, 0xEB, 0x43, 0x08, 0xFD, 0x08, 0x60,
  0x8F, 0xD8, 0x18, 0x04, 0xFF, 0x04, 0x40, 0x4F, 0xF0, 0x40, 0xBF, 0xF0, 0xB4, 0x0B, 0xFF, 0x0B,
  0x0E, 0xB0, 0x36, 0x03, 0xB0, 0xE4, 0x0E, 0xB0, 0x36, 0x03, 0xB0, 0x0E, 0xB0, 0x36, 0x03, 0xB0,
  0xE4, 0x0E, 0xB0, 0x36, 0x03, 0xB0, 0xE0, 0xBF, 0xF0, 0xB4, 0x0B, 0xFF, 0x0B, 0x04, 0xFF, 0x04,
  0x40, 0x4F, 0xF8, 0x14, 0x08, 0xFD, 0x08, 0x60, 0x8F, 0xD0, 0x83, 0x81, 0x4B, 0xEE, 0x81, 0xEB,
  0x47, 0x18, 0x14, 0xBE, 0xE8, 0x1E, 0xB4, 0x71, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x50,
  0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x6F, 0xFA, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF,
  0xFC, 0x4F, 0xFE, 0x71, 0xC4, 0xC7, 0x1F, 0x97, 0x1C, 0x4C, 0x71, 0xFF, 0xE4, 0xFF, 0xFF, 0xC4,
  0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xA6, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x50,
  0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x71, 0x81, 0x4B, 0xEE, 0x81, 0xEB, 0x47, 0x18, 0x14, 0xBE,
  0xE8, 0x1E, 0xB4, 0x30, 0x8F, 0xD0, 0x86, 0x08, 0xFD, 0x81, 0x80, 0x4F, 0xF0, 0x44, 0x04, 0xFF,
  0x04, 0x0B, 0xFF, 0x0B, 0x40, 0xBF, 0xF0, 0xB0, 0xEB, 0x03, 0x60, 0x3B, 0x0E, 0x40, 0xEB, 0x03,
  0x60, 0x3B, 0x00, 0xEB, 0x03, 0x60, 0x3B, 0x0E, 0x40, 0xEB, 0x03, 0x60, 0x3B, 0x0E, 0x0B, 0xFF,
  0x0B, 0x40, 0xBF, 0xF0, 0xB0, 0x4F, 0xF0, 0x44, 0x04, 0xFF, 0x81, 0x40, 0x8F, 0xD0, 0x86, 0x08,
  0xFD, 0x08, 0x38, 0x14, 0xBE, 0xE8, 0x1E, 0xB4, 0x71, 0x81, 0x4B, 0xEE, 0x81, 0xEB, 0x47, 0x10,
  0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A,
  0x07, 0x77, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x07,
  0x77, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x07, 0x77,
  0x20, 0x7A, 0x07, 0x75, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_kebab_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_kebab_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_layers_clear 48x48, 4-bit Alpha,  RLE, 424 bytes.
static const unsigned char ic_outlined_48_maps_layers_clear_data[] PROGMEM = {
  0x20, 0x18, 0x0C, 0x30, 0x81, 0x1D, 0x98, 0x0C, 0x10, 0x01, 0x0D, 0xA0, 0x98, 0x0C, 0x00, 0x0B,
  0xC0, 0x97, 0x60, 0x09, 0x77, 0x60, 0x20, 0xDC, 0x09, 0x73, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x75,
  0x02, 0x0D, 0xC0, 0x97, 0x10, 0x40, 0xEC, 0x0E, 0x04, 0x77, 0x50, 0x20, 0xDC, 0x09, 0x60, 0x7F,
  0x90, 0x77, 0x75, 0x02, 0x0D, 0xC0, 0x95, 0x0A, 0xFA, 0x0B, 0x01, 0x77, 0x40, 0x20, 0xDC, 0x09,
  0x50, 0xAA, 0x00, 0x7D, 0x0D, 0x03, 0x77, 0x40, 0x20, 0xDC, 0x09, 0x50, 0x90, 0x32, 0x03, 0x0E,
  0xD0, 0x67, 0x74, 0x02, 0x0D, 0xC0, 0x97, 0x20, 0x10, 0xBD, 0x09, 0x77, 0x40, 0x20, 0xDC, 0x09,
  0x73, 0x08, 0xD0, 0xC0, 0x17, 0x72, 0x04, 0x0E, 0xD0, 0x97, 0x30, 0x50, 0xEC, 0x0E, 0x04, 0x77,
  0x07, 0xF9, 0x09, 0x73, 0x02, 0x0D, 0xD0, 0x77, 0x40, 0x10, 0xBF, 0xB0, 0x97, 0x40, 0xAD, 0x0B,
  0x01, 0x71, 0x03, 0x0D, 0xD8, 0x17, 0x2D, 0xC0, 0x97, 0x40, 0x7D, 0x0D, 0x03, 0x60, 0x6D, 0x0E,
  0x03, 0x20, 0x20, 0xDC, 0x09, 0x74, 0x03, 0x0E, 0xD0, 0x65, 0x06, 0xD0, 0xE0, 0x33, 0x02, 0x0D,
  0xC0, 0x97, 0x30, 0x30, 0xED, 0x06, 0x60, 0x30, 0xDD, 0x07, 0x30, 0x20, 0xDC, 0x09, 0x71, 0x07,
  0xD0, 0xD0, 0x37, 0x10, 0x10, 0xBD, 0x0A, 0x30, 0x20, 0xDC, 0x09, 0x60, 0xAD, 0x0B, 0x01, 0x74,
  0x07, 0xD0, 0xD0, 0x22, 0x02, 0x0D, 0xC0, 0x95, 0x0A, 0xC0, 0x77, 0x70, 0x40, 0xEC, 0x0E, 0x05,
  0x20, 0x20, 0xDC, 0x09, 0x58, 0x2A, 0xFE, 0x47, 0x72, 0x01, 0x0C, 0xD0, 0x82, 0x02, 0x0D, 0xC0,
  0x95, 0x08, 0x01, 0x77, 0x50, 0x9D, 0x83, 0xB1, 0x02, 0xDC, 0x09, 0x77, 0x60, 0x25, 0x06, 0xD8,
  0x3E, 0x30, 0x2E, 0xC0, 0x97, 0x02, 0x72, 0x82, 0x1C, 0xF6, 0x50, 0x30, 0xDD, 0x00, 0x7E, 0x09,
  0x58, 0x24, 0xFC, 0x16, 0x04, 0x0E, 0xB0, 0x95, 0x01, 0x0B, 0xFE, 0x09, 0x58, 0x2B, 0xFE, 0x45,
  0x07, 0xD0, 0xC0, 0x25, 0x07, 0xF9, 0x0E, 0xC0, 0x95, 0x81, 0xBF, 0x86, 0x04, 0x0E, 0xC0, 0xE0,
  0x45, 0x04, 0x0E, 0xC8, 0x2E, 0x42, 0xDC, 0x09, 0x50, 0x37, 0x10, 0x20, 0xCD, 0x07, 0x50, 0x10,
  0xCA, 0x0C, 0x01, 0x20, 0x20, 0xDC, 0x09, 0x77, 0x10, 0x9D, 0x0B, 0x01, 0x50, 0x09, 0x50, 0x3D,
  0x09, 0x77, 0x10, 0x6D, 0x0D, 0x03, 0x73, 0x03, 0x0D, 0xE0, 0x97, 0x71, 0x03, 0x0D, 0xD0, 0x67,
  0x10, 0x6F, 0xA0, 0x97, 0x71, 0x01, 0x0B, 0xD0, 0x96, 0x0A, 0xD0, 0xB0, 0xDC, 0x09, 0x77, 0x20,
  0x8D, 0x0C, 0x02, 0x20, 0x20, 0xCD, 0x82, 0x80, 0x2D, 0xC0, 0x97, 0x72, 0x04, 0x0E, 0xC8, 0x2E,
  0x45, 0xEC, 0x0E, 0x04, 0x30, 0x20, 0xDC, 0x09, 0x77, 0x20, 0x20, 0xCF, 0xB0, 0xC0, 0x25, 0x02,
  0x0D, 0xC0, 0x97, 0x73, 0x09, 0xF9, 0x09, 0x71, 0x02, 0x0D, 0xC0, 0x97, 0x73, 0x06, 0xE0, 0x67,
  0x30, 0x20, 0xDB, 0x0D, 0x01, 0x77, 0x30, 0x30, 0xDA, 0x0D, 0x03, 0x75, 0x83, 0x2D, 0xFD, 0x17,
  0x75, 0x82, 0x1B, 0xB1, 0x77, 0x81, 0x2B, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_layers_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 44, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_layers_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_layers 48x48, 4-bit Alpha,  RLE, 336 bytes.
static const unsigned char ic_outlined_48_maps_layers_data[] PROGMEM = {
  0x77, 0x30, 0x09, 0x77, 0x77, 0x40, 0x10, 0xCA, 0x0C, 0x01, 0x77, 0x77, 0x10, 0x40, 0xEC, 0x0E,
  0x04, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x73, 0x01, 0x0B, 0xFB, 0x0B, 0x01, 0x77, 0x70, 0x30,
  0xDD, 0x00, 0x7D, 0x0D, 0x03, 0x77, 0x50, 0x6D, 0x0E, 0x03, 0x20, 0x30, 0xED, 0x06, 0x77, 0x30,
  0x9D, 0x0B, 0x01, 0x40, 0x10, 0xBD, 0x09, 0x77, 0x01, 0x0C, 0xD0, 0x87, 0x10, 0x8D, 0x0C, 0x01,
  0x74, 0x04, 0x0E, 0xC0, 0xE0, 0x57, 0x30, 0x50, 0xEC, 0x0E, 0x04, 0x72, 0x07, 0xD0, 0xD0, 0x27,
  0x50, 0x20, 0xDD, 0x07, 0x60, 0x10, 0xBD, 0x0A, 0x77, 0x20, 0xAD, 0x0B, 0x01, 0x30, 0x30, 0xDD,
  0x07, 0x77, 0x40, 0x7D, 0x82, 0xD3, 0x06, 0xD0, 0xE0, 0x37, 0x76, 0x03, 0x0E, 0xD0, 0x06, 0xD0,
  0xE0, 0x37, 0x76, 0x03, 0x0E, 0xC8, 0x3E, 0x50, 0x3D, 0xD0, 0x77, 0x74, 0x07, 0xD0, 0xD0, 0x33,
  0x01, 0x0B, 0xD0, 0xA7, 0x72, 0x0A, 0xD0, 0xA0, 0x16, 0x07, 0xD0, 0xD0, 0x27, 0x50, 0x20, 0xDD,
  0x07, 0x72, 0x04, 0x0E, 0xC0, 0xE0, 0x57, 0x30, 0x50, 0xEC, 0x0E, 0x04, 0x74, 0x01, 0x0C, 0xD0,
  0x87, 0x10, 0x8D, 0x0C, 0x01, 0x77, 0x09, 0xD0, 0xB0, 0x14, 0x01, 0x0B, 0xD0, 0x97, 0x40, 0x25,
  0x06, 0xD0, 0xE0, 0x32, 0x03, 0x0E, 0xC0, 0xE0, 0x55, 0x02, 0x48, 0x21, 0xCF, 0x65, 0x03, 0x0D,
  0xD0, 0x07, 0xD0, 0xD0, 0x35, 0x85, 0x6F, 0xC1, 0x04, 0xEB, 0x09, 0x50, 0x10, 0xBF, 0xB0, 0xB0,
  0x15, 0x0A, 0xB8, 0x1E, 0x47, 0xD0, 0xC0, 0x25, 0x07, 0xF9, 0x07, 0x50, 0x20, 0xCD, 0x82, 0x70,
  0x4E, 0xC0, 0xE0, 0x45, 0x04, 0x0E, 0xC0, 0xE0, 0x45, 0x05, 0x0E, 0xC0, 0xE0, 0x43, 0x02, 0x0C,
  0xD0, 0x75, 0x01, 0x0C, 0xA0, 0xC0, 0x15, 0x08, 0xD0, 0xC0, 0x26, 0x09, 0xD0, 0xB0, 0x15, 0x00,
  0x95, 0x01, 0x0B, 0xD0, 0x97, 0x20, 0x6D, 0x0D, 0x03, 0x73, 0x03, 0x0D, 0xD0, 0x67, 0x40, 0x30,
  0xDD, 0x06, 0x71, 0x06, 0xD0, 0xD0, 0x37, 0x60, 0x10, 0xBD, 0x09, 0x60, 0xAD, 0x0B, 0x01, 0x77,
  0x20, 0x8D, 0x0C, 0x02, 0x20, 0x20, 0xCD, 0x08, 0x77, 0x50, 0x40, 0xEC, 0x82, 0xE4, 0x5E, 0xC0,
  0xE0, 0x47, 0x77, 0x02, 0x0C, 0xFB, 0x0C, 0x02, 0x77, 0x73, 0x09, 0xF9, 0x09, 0x77, 0x76, 0x06,
  0xE0, 0x67, 0x77, 0x71, 0x03, 0x0D, 0xA0, 0xD0, 0x37, 0x77, 0x73, 0x82, 0x1B, 0xB1, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_layers() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_layers_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_liquor 48x48, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_outlined_48_maps_liquor_data[] PROGMEM = {
  0x77, 0x71, 0x04, 0x0D, 0xE0, 0xD0, 0x47, 0x77, 0x70, 0xDF, 0x90, 0xD7, 0x77, 0x7F, 0xB7, 0x77,
  0x7F, 0xB7, 0x77, 0x7C, 0x2C, 0x77, 0x77, 0xC2, 0xC7, 0x77, 0x7F, 0xB7, 0x77, 0x7F, 0xB6, 0xFD,
  0x73, 0xFB, 0x6F, 0xD7, 0x3F, 0xB6, 0xFD, 0x73, 0xC2, 0xC6, 0xFD, 0x72, 0x04, 0xB0, 0xD2, 0x0D,
  0xB0, 0x45, 0xC4, 0xC7, 0x81, 0x27, 0xEB, 0x09, 0x20, 0x9B, 0x81, 0xE8, 0x23, 0xC4, 0xC5, 0x03,
  0x0C, 0xE0, 0x22, 0x02, 0xE0, 0xC0, 0x31, 0xC4, 0xC4, 0x02, 0x0E, 0xE0, 0x64, 0x06, 0xE0, 0xE0,
  0x3C, 0x4C, 0x40, 0xAD, 0x0D, 0x05, 0x60, 0x50, 0xED, 0x0B, 0xC4, 0xC4, 0x0E, 0xB0, 0xB0, 0x57,
  0x30, 0x50, 0xBB, 0x0E, 0xC4, 0xC4, 0xC7, 0x7F, 0xFA, 0x4C, 0x77, 0xFF, 0xA4, 0xC7, 0x7F, 0xFA,
  0x4F, 0xFF, 0xFE, 0x4F, 0xFF, 0xD4, 0xC4, 0xFF, 0xFD, 0x4C, 0x4F, 0xFF, 0x90, 0xEB, 0x01, 0x20,
  0x1B, 0x0E, 0x4C, 0x77, 0xC0, 0xBB, 0x82, 0xB1, 0x1B, 0xB0, 0xB4, 0xC7, 0x7C, 0x05, 0xFB, 0x05,
  0x4C, 0x77, 0xC1, 0x0C, 0xF9, 0x0C, 0x5C, 0x77, 0xC1, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0xFF, 0xF9,
  0x30, 0x5C, 0x05, 0x7F, 0xFF, 0x94, 0xC7, 0x1F, 0xFF, 0x94, 0xC7, 0x1F, 0xFF, 0x94, 0xC7, 0x1C,
  0x77, 0xC4, 0xC7, 0x1C, 0x77, 0xC4, 0xC7, 0x1C, 0x77, 0xC4, 0xC7, 0x1C, 0x77, 0xFF, 0xA4, 0x0D,
  0xFF, 0xE0, 0xDF, 0xD4, 0x0A, 0xFF, 0xE0, 0xAF, 0xD4, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x1F, 0xD5,
  0x81, 0x1A, 0xDF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_liquor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_liquor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_activity 48x48, 4-bit Alpha,  RLE, 242 bytes.
static const unsigned char ic_outlined_48_maps_local_activity_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x10,
  0x03, 0x77, 0x1F, 0x97, 0x71, 0x00, 0x97, 0x71, 0xF9, 0x77, 0x10, 0x0E, 0x77, 0x1F, 0x90, 0x87,
  0x60, 0x5A, 0x05, 0x76, 0x08, 0xFA, 0x0B, 0x75, 0x0B, 0xA0, 0xB7, 0x50, 0xBF, 0xC0, 0x87, 0x30,
  0x2C, 0x02, 0x73, 0x08, 0xE8, 0x11, 0x5D, 0xC0, 0x23, 0x85, 0x33, 0x55, 0x67, 0xBC, 0x85, 0xB7,
  0x65, 0x43, 0x23, 0x02, 0xC8, 0x1D, 0x51, 0x20, 0x10, 0xDB, 0x08, 0x30, 0xAF, 0xFA, 0x0A, 0x30,
  0x8B, 0x0D, 0x01, 0x50, 0x5B, 0x0C, 0x40, 0x7F, 0xF0, 0x74, 0x0C, 0xB0, 0x56, 0x01, 0xB0, 0xE5,
  0x04, 0x0E, 0xFB, 0x0E, 0x04, 0x50, 0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x60, 0x20, 0xDF, 0x90, 0xD0,
  0x26, 0x0E, 0xB0, 0x16, 0x05, 0xB0, 0xC7, 0x03, 0xF9, 0x03, 0x70, 0xCB, 0x05, 0x50, 0x10, 0xDB,
  0x08, 0x70, 0x6F, 0x90, 0x67, 0x08, 0xB0, 0xD0, 0x12, 0x81, 0x15, 0xDC, 0x02, 0x70, 0xAF, 0x90,
  0xA7, 0x02, 0xC8, 0x1D, 0x51, 0xE0, 0x87, 0x10, 0xEB, 0x00, 0x8B, 0x0E, 0x71, 0x08, 0xFC, 0x0B,
  0x71, 0x03, 0xA0, 0xC0, 0x32, 0x03, 0x0C, 0xA0, 0x37, 0x10, 0xBF, 0xA0, 0x87, 0x28, 0x17, 0xF7,
  0x68, 0x17, 0xF7, 0x72, 0x08, 0xF9, 0x73, 0x07, 0x02, 0x71, 0x02, 0x07, 0x73, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D,
  0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81,
  0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_activity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_activity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_airport 48x48, 4-bit Alpha,  RLE, 214 bytes.
static const unsigned char ic_outlined_48_maps_local_airport_data[] PROGMEM = {
  0x77, 0x48, 0x28, 0xDD, 0x87, 0x77, 0x77, 0x08, 0xC0, 0x87, 0x77, 0x76, 0x0D, 0xC0, 0xD7, 0x77,
  0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76,
  0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7,
  0x77, 0x74, 0x02, 0x0A, 0xE0, 0xA0, 0x27, 0x77, 0x71, 0x08, 0xFB, 0x08, 0x77, 0x75, 0x05, 0x0D,
  0xFD, 0x0D, 0x05, 0x77, 0x71, 0x02, 0x0B, 0xFF, 0xA0, 0xB0, 0x27, 0x74, 0x01, 0x09, 0xFF, 0xE0,
  0x90, 0x17, 0x71, 0x06, 0x0E, 0xFF, 0xF9, 0x0E, 0x06, 0x75, 0x03, 0x0C, 0xFF, 0xFD, 0x0C, 0x03,
  0x71, 0x01, 0x09, 0xFF, 0xFF, 0xA0, 0x90, 0x15, 0x07, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x72, 0x04,
  0x0D, 0xFD, 0x81, 0xB6, 0x2E, 0x81, 0x26, 0xBF, 0xD0, 0xD0, 0x4F, 0xB8, 0x1E, 0x95, 0x4E, 0x48,
  0x15, 0x9E, 0xFF, 0xB8, 0x1C, 0x73, 0x7E, 0x78, 0x13, 0x7C, 0xFB, 0x82, 0xEA, 0x51, 0x73, 0xE7,
  0x38, 0x21, 0x5A, 0xEB, 0x81, 0xD8, 0x47, 0x7E, 0x77, 0x81, 0x48, 0xD7, 0x73, 0xE7, 0x77, 0x76,
  0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x74, 0x02,
  0x0A, 0xE0, 0xA0, 0x27, 0x77, 0x71, 0x07, 0xFB, 0x07, 0x77, 0x75, 0x04, 0x0D, 0xFD, 0x0D, 0x04,
  0x77, 0x73, 0xFF, 0xA7, 0x77, 0x3C, 0x86, 0xD9, 0x51, 0x15, 0x9D, 0xC7, 0x77, 0x38, 0x2D, 0x95,
  0x17, 0x18, 0x21, 0x59, 0xD7, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_airport() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_airport_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_atm 48x48, 4-bit Alpha,  RLE, 149 bytes.
static const unsigned char ic_outlined_48_maps_local_atm_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0xC7,
  0x7F, 0x97, 0x7C, 0x77, 0xF9, 0x73, 0x04, 0x0D, 0xFB, 0x73, 0xF9, 0x73, 0x0D, 0xFC, 0x73, 0xF9,
  0x73, 0xFD, 0x73, 0xF9, 0x73, 0xFD, 0x73, 0xF9, 0x73, 0xC7, 0x74, 0xF9, 0x73, 0xC7, 0x74, 0xF9,
  0x73, 0xFB, 0x0D, 0x04, 0x73, 0xF9, 0x73, 0xFC, 0x0D, 0x73, 0xF9, 0x73, 0x0D, 0xFC, 0x73, 0xF9,
  0x73, 0x04, 0x0D, 0xFB, 0x73, 0xF9, 0x77, 0x4C, 0x73, 0xF9, 0x77, 0x4C, 0x73, 0xF9, 0x73, 0xFD,
  0x73, 0xF9, 0x73, 0xFD, 0x73, 0xF9, 0x73, 0xFC, 0x0D, 0x73, 0xF9, 0x73, 0xFB, 0x0D, 0x04, 0x73,
  0xF9, 0x77, 0xC7, 0x7F, 0x97, 0x7C, 0x77, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8,
  0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xEF,
  0xFF, 0xFC, 0x81, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_atm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_atm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_bar 48x48, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_outlined_48_maps_local_bar_data[] PROGMEM = {
  0x80, 0xA9, 0x4F, 0x08, 0xC0, 0xB7, 0x77, 0x30, 0xBC, 0x81, 0x80, 0xAC, 0x09, 0x77, 0x71, 0x09,
  0xC0, 0xA3, 0x0B, 0xC0, 0x87, 0x76, 0x08, 0xC0, 0xB4, 0x01, 0x0C, 0xC0, 0x67, 0x74, 0x06, 0xC0,
  0xC0, 0x15, 0x01, 0x0D, 0xFF, 0xFD, 0x0D, 0x01, 0x70, 0x20, 0xEF, 0xFF, 0xB0, 0xE0, 0x27, 0x20,
  0x3F, 0xFF, 0xB0, 0x37, 0x40, 0x5F, 0xFF, 0x90, 0x57, 0x60, 0x6C, 0x0C, 0x01, 0x71, 0x01, 0x0C,
  0xC0, 0x67, 0x71, 0x08, 0xC0, 0xB7, 0x10, 0xBC, 0x08, 0x77, 0x30, 0xAC, 0x0A, 0x60, 0xAC, 0x0A,
  0x77, 0x50, 0xBC, 0x08, 0x40, 0x8C, 0x0B, 0x77, 0x60, 0x10, 0xCC, 0x07, 0x20, 0x7C, 0x0C, 0x01,
  0x77, 0x70, 0x10, 0xDC, 0x00, 0x5C, 0x0D, 0x01, 0x77, 0x72, 0x02, 0x0E, 0xF9, 0x0E, 0x02, 0x77,
  0x74, 0x03, 0xF9, 0x03, 0x77, 0x76, 0x05, 0xE0, 0x57, 0x77, 0x71, 0x06, 0xC0, 0x67, 0x77, 0x73,
  0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7,
  0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x1F, 0xFF, 0xB7,
  0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_cafe 48x48, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_outlined_48_maps_local_cafe_data[] PROGMEM = {
  0x4F, 0xFF, 0xFC, 0x81, 0xEA, 0x15, 0xFF, 0xFF, 0xE0, 0xE0, 0x14, 0xFF, 0xFF, 0xF0, 0xA4, 0xFF,
  0xFF, 0xF0, 0xD4, 0xC7, 0x76, 0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xC7,
  0x76, 0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xC7, 0x76, 0xFC, 0x0D, 0x4C,
  0x77, 0x6F, 0xC0, 0xA4, 0xC7, 0x76, 0xFB, 0x0E, 0x01, 0x4C, 0x77, 0x6F, 0x98, 0x1E, 0xA1, 0x5C,
  0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C,
  0x75, 0xC7, 0x76, 0xC7, 0x50, 0xEB, 0x01, 0x77, 0x40, 0x1B, 0x0E, 0x75, 0x0C, 0xB0, 0x57, 0x74,
  0x05, 0xB0, 0xC7, 0x50, 0x8B, 0x0D, 0x01, 0x77, 0x20, 0x10, 0xDB, 0x08, 0x75, 0x02, 0xC8, 0x1D,
  0x51, 0x75, 0x81, 0x15, 0xDC, 0x02, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0xBF, 0xFF, 0x90,
  0xB7, 0x73, 0x09, 0xFF, 0xE0, 0x97, 0x75, 0x82, 0x28, 0xCE, 0xFD, 0x82, 0xEC, 0x82, 0x80, 0xAD,
  0x00, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_cafe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_cafe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_car_wash 48x48, 4-bit Alpha,  RLE, 265 bytes.
static const unsigned char ic_outlined_48_maps_local_car_wash_data[] PROGMEM = {
  0x70, 0x01, 0x71, 0x00, 0x17, 0x10, 0x01, 0x77, 0x00, 0xB7, 0x10, 0x0B, 0x71, 0x00, 0xB7, 0x60,
  0x7A, 0x07, 0x60, 0x7A, 0x07, 0x60, 0x7A, 0x07, 0x74, 0x01, 0x0E, 0xA0, 0xE0, 0x14, 0x01, 0x0E,
  0xA0, 0xE0, 0x14, 0x01, 0x0E, 0xA0, 0xE0, 0x17, 0x30, 0x9C, 0x08, 0x40, 0x9C, 0x08, 0x40, 0x9C,
  0x08, 0x73, 0x0E, 0xC0, 0xD4, 0x0E, 0xC0, 0xD4, 0x0E, 0xC0, 0xD7, 0x30, 0xDC, 0x0D, 0x40, 0xDC,
  0x0D, 0x40, 0xDC, 0x0D, 0x73, 0x08, 0xC0, 0x84, 0x08, 0xC0, 0x84, 0x08, 0xC0, 0x87, 0x48, 0x28,
  0xDD, 0x86, 0x82, 0x8D, 0xD8, 0x68, 0x28, 0xDD, 0x88, 0x0A, 0xA7, 0x00, 0x80, 0xEF, 0xFF, 0x90,
  0xE0, 0x87, 0x20, 0x8F, 0xFF, 0xD0, 0x87, 0x10, 0xEF, 0xFF, 0xD0, 0xE7, 0x05, 0xFF, 0xFF, 0x05,
  0x60, 0xAB, 0x08, 0x77, 0x60, 0x8B, 0x0A, 0x50, 0x1C, 0x02, 0x77, 0x60, 0x3C, 0x01, 0x40, 0x6B,
  0x0C, 0x77, 0x71, 0x0D, 0xB0, 0x64, 0x0B, 0xB0, 0x77, 0x77, 0x10, 0x7B, 0x0B, 0x30, 0x1C, 0x02,
  0x77, 0x71, 0x02, 0xC0, 0x12, 0x06, 0xB0, 0xC7, 0x77, 0x30, 0xCB, 0x06, 0x20, 0xCF, 0xFF, 0xFC,
  0x81, 0xC0, 0x2F, 0xFF, 0xFE, 0x02, 0x07, 0xFF, 0xFF, 0xE0, 0x70, 0xCF, 0xFF, 0xFE, 0x0C, 0xC0,
  0x17, 0x77, 0x50, 0x1F, 0x97, 0x77, 0x7F, 0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F,
  0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F, 0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F,
  0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F, 0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F,
  0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x78, 0x0A,
  0xA6, 0xF7, 0x77, 0x3F, 0xD7, 0x77, 0x3E, 0x0D, 0xC0, 0xD7, 0x77, 0x30, 0xDC, 0x81, 0xD4, 0xDA,
  0x0D, 0x04, 0x77, 0x73, 0x04, 0x0D, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_car_wash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_car_wash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_convenience_store 48x48, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_outlined_48_maps_local_convenience_store_data[] PROGMEM = {
  0x6F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5F, 0xFF, 0xF7, 0x5C, 0x77, 0x6C, 0x75,
  0xC7, 0x76, 0xC6, 0xFB, 0x2E, 0x4A, 0x2A, 0x2F, 0xFE, 0x2E, 0x4A, 0x2A, 0x2F, 0xFE, 0x6A, 0x4A,
  0x2A, 0x2F, 0xFE, 0x6A, 0x4A, 0x2A, 0x2F, 0xF7, 0x1E, 0x4E, 0x71, 0xF9, 0x71, 0xE4, 0xE7, 0x1F,
  0x97, 0x1A, 0x75, 0xA7, 0x1F, 0x97, 0x1A, 0x75, 0xA7, 0x1F, 0x97, 0x1E, 0x71, 0xA7, 0x1F, 0x97,
  0x1E, 0x71, 0xA7, 0x1F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9,
  0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1C, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xC7, 0x1F, 0x97, 0x1C,
  0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xC7, 0x1F, 0xFE, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC,
  0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_convenience_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_convenience_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_dining 48x48, 4-bit Alpha,  RLE, 283 bytes.
static const unsigned char ic_outlined_48_maps_local_dining_data[] PROGMEM = {
  0x77, 0x77, 0x18, 0x44, 0x79, 0xB9, 0x56, 0x08, 0x05, 0x77, 0x72, 0x06, 0x0D, 0xE0, 0xE0, 0x43,
  0x05, 0xA0, 0x57, 0x76, 0x01, 0x0C, 0xFB, 0x04, 0x20, 0xDB, 0x05, 0x77, 0x40, 0x30, 0xDF, 0xC8,
  0x1D, 0x02, 0xD0, 0x57, 0x72, 0x02, 0x0E, 0xFE, 0x05, 0x06, 0xE0, 0x57, 0x71, 0x0C, 0xFF, 0x09,
  0x07, 0xF0, 0x57, 0x60, 0x6F, 0xF9, 0x0A, 0x06, 0xF9, 0x05, 0x75, 0x0D, 0xFF, 0x90, 0xA0, 0x4F,
  0xA0, 0x57, 0x30, 0x4F, 0xFA, 0x81, 0x70, 0xEF, 0xA0, 0x57, 0x20, 0x7F, 0xFA, 0x81, 0x30, 0x7F,
  0xB0, 0x57, 0x10, 0xAF, 0xF9, 0x0D, 0x30, 0xCF, 0xB0, 0x57, 0x0A, 0xFF, 0x90, 0x53, 0x01, 0x0D,
  0xFB, 0x05, 0x60, 0x8F, 0xF0, 0xB5, 0x01, 0x0D, 0xFB, 0x05, 0x50, 0x5F, 0xE0, 0xD0, 0x16, 0x01,
  0x0D, 0xFB, 0x05, 0x40, 0x6F, 0xD0, 0xD0, 0x27, 0x10, 0x10, 0xDF, 0xA0, 0x53, 0x05, 0xFD, 0x0B,
  0x01, 0x73, 0x01, 0x0D, 0xF0, 0x53, 0x05, 0xFC, 0x0D, 0x05, 0x76, 0x01, 0x0D, 0xD0, 0x53, 0x05,
  0xD8, 0x55, 0x48, 0x99, 0x73, 0x77, 0x20, 0x10, 0xDB, 0x05, 0x30, 0x5D, 0x05, 0x77, 0x73, 0x82,
  0x1D, 0xF5, 0x30, 0x5D, 0x05, 0x77, 0x75, 0x01, 0x05, 0x30, 0x5E, 0x05, 0x77, 0x77, 0x20, 0x5F,
  0x90, 0x57, 0x77, 0x70, 0x5F, 0xB0, 0x57, 0x77, 0x50, 0x5D, 0x00, 0x5D, 0x05, 0x77, 0x73, 0x05,
  0xD0, 0x52, 0x05, 0xD0, 0x57, 0x77, 0x10, 0x5D, 0x05, 0x40, 0x5D, 0x05, 0x77, 0x60, 0x5D, 0x05,
  0x60, 0x5D, 0x05, 0x77, 0x40, 0x5D, 0x05, 0x71, 0x05, 0xD0, 0x57, 0x72, 0x05, 0xD0, 0x57, 0x30,
  0x5D, 0x05, 0x77, 0x05, 0xD0, 0x47, 0x50, 0x5D, 0x05, 0x75, 0x05, 0xD0, 0x47, 0x70, 0x5D, 0x05,
  0x73, 0x05, 0xD0, 0x47, 0x72, 0x05, 0xD0, 0x57, 0x10, 0x5D, 0x04, 0x77, 0x40, 0x5D, 0x05, 0x60,
  0x4D, 0x04, 0x77, 0x60, 0x5D, 0x04, 0x60, 0xCB, 0x04, 0x77, 0x71, 0x05, 0xB0, 0xC7, 0x18, 0x1C,
  0xF4, 0x77, 0x73, 0x81, 0x5F, 0xC7, 0x30, 0x37, 0x77, 0x50, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 43, 42), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_drink 48x48, 4-bit Alpha,  RLE, 320 bytes.
static const unsigned char ic_outlined_48_maps_local_drink_data[] PROGMEM = {
  0x0E, 0xFF, 0xFF, 0xE0, 0xE0, 0xCF, 0xFF, 0xFE, 0x0C, 0x0B, 0xFF, 0xFF, 0xE0, 0xB0, 0x9F, 0xFF,
  0xFE, 0x09, 0x07, 0xB0, 0x77, 0x77, 0x50, 0x8B, 0x07, 0x06, 0xB0, 0x97, 0x77, 0x50, 0x9B, 0x06,
  0x04, 0xB0, 0xB7, 0x77, 0x50, 0xBB, 0x04, 0x02, 0xB0, 0xD7, 0x77, 0x50, 0xDB, 0x02, 0x01, 0xB0,
  0xE7, 0x77, 0x50, 0xEB, 0x81, 0x10, 0xEB, 0x01, 0x77, 0x73, 0x01, 0xB0, 0xE2, 0x0D, 0xB0, 0x27,
  0x77, 0x30, 0x2B, 0x0D, 0x20, 0xBB, 0x04, 0x77, 0x73, 0x04, 0xB0, 0xB2, 0x09, 0xFF, 0xFF, 0xC0,
  0x92, 0x07, 0xFF, 0xFF, 0xC0, 0x72, 0x06, 0xFF, 0xFF, 0xC0, 0x62, 0x04, 0xFF, 0xFF, 0xC0, 0x42,
  0x02, 0xB0, 0xC7, 0x77, 0x30, 0xDB, 0x02, 0x20, 0x1B, 0x0E, 0x74, 0x00, 0x47, 0x40, 0xEB, 0x01,
  0x30, 0xEB, 0x73, 0x82, 0x2E, 0xE2, 0x72, 0x01, 0xB0, 0xE4, 0x0D, 0xB0, 0x27, 0x20, 0xCA, 0x0C,
  0x72, 0x02, 0xB0, 0xD4, 0x0B, 0xB0, 0x47, 0x10, 0x8C, 0x08, 0x71, 0x04, 0xB0, 0xB4, 0x09, 0xB0,
  0x67, 0x04, 0xE0, 0x47, 0x06, 0xB0, 0x94, 0x08, 0xB0, 0x77, 0x0D, 0xE0, 0xD7, 0x07, 0xB0, 0x84,
  0x06, 0xB0, 0x96, 0x07, 0xF9, 0x07, 0x60, 0x9B, 0x06, 0x40, 0x4B, 0x0B, 0x60, 0xEB, 0x08, 0x09,
  0xB0, 0xE6, 0x0B, 0xB0, 0x44, 0x02, 0xB0, 0xC5, 0x06, 0xB8, 0x2E, 0x11, 0xEB, 0x06, 0x50, 0xDB,
  0x02, 0x40, 0x1B, 0x0E, 0x50, 0xBB, 0x07, 0x20, 0x7B, 0x0B, 0x50, 0xEB, 0x01, 0x50, 0xEB, 0x50,
  0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x40, 0x1B, 0x0E, 0x60, 0xDB, 0x02, 0x40, 0xEB, 0x01, 0x20, 0x1B,
  0x0E, 0x40, 0x2B, 0x0D, 0x60, 0xBB, 0x04, 0x40, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC4, 0x04, 0xB0,
  0xB6, 0x09, 0xB0, 0x64, 0x06, 0xFB, 0x06, 0x40, 0x6B, 0x09, 0x60, 0x8B, 0x07, 0x50, 0xCF, 0x90,
  0xC5, 0x07, 0xB0, 0x86, 0x06, 0xB0, 0x95, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0x09, 0xB0, 0x66, 0x04,
  0xB0, 0xB7, 0x84, 0x6C, 0xEE, 0xC6, 0x70, 0xBB, 0x04, 0x60, 0x3B, 0x0C, 0x77, 0x60, 0xCB, 0x03,
  0x60, 0x1B, 0x0E, 0x77, 0x60, 0xEB, 0x01, 0x70, 0xEF, 0xFF, 0xD0, 0xE7, 0x10, 0xAF, 0xFF, 0xD0,
  0xA7, 0x10, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x28, 0x11, 0xAE, 0xFF, 0xE8, 0x1E, 0xA1, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_drink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_drink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_fire_department 48x48, 4-bit Alpha,  RLE, 317 bytes.
static const unsigned char ic_outlined_48_maps_local_fire_department_data[] PROGMEM = {
  0x77, 0x02, 0x0B, 0x77, 0x77, 0x10, 0x8A, 0x77, 0x76, 0x02, 0x0C, 0xB7, 0x77, 0x50, 0x50, 0xEC,
  0x77, 0x74, 0x08, 0xE7, 0x77, 0x30, 0xAF, 0x77, 0x72, 0x0B, 0xF9, 0x77, 0x71, 0x0A, 0xC0, 0xD0,
  0xEB, 0x01, 0x77, 0x60, 0x9C, 0x81, 0xD2, 0xBB, 0x08, 0x68, 0x16, 0xA1, 0x73, 0x06, 0xC8, 0x2D,
  0x10, 0x6C, 0x05, 0x40, 0x5A, 0x0D, 0x03, 0x71, 0x02, 0x0E, 0xB0, 0xD0, 0x13, 0x0D, 0xC8, 0x2B,
  0x77, 0xBC, 0x0E, 0x04, 0x70, 0xCB, 0x0E, 0x02, 0x40, 0x4F, 0xE0, 0xE0, 0x25, 0x06, 0xC0, 0x56,
  0x05, 0xFE, 0x0D, 0x50, 0xDB, 0x0A, 0x71, 0x02, 0x0B, 0xE0, 0xC0, 0x8C, 0x08, 0x30, 0x6C, 0x01,
  0x73, 0x84, 0x26, 0x88, 0x62, 0x20, 0x9C, 0x02, 0x20, 0xCB, 0x08, 0x77, 0x60, 0xDB, 0x81, 0x90,
  0x2C, 0x02, 0x77, 0x60, 0x5B, 0x81, 0xE0, 0x6B, 0x0B, 0x77, 0x71, 0x0D, 0xB0, 0x50, 0x9B, 0x07,
  0x77, 0x71, 0x08, 0xB0, 0x90, 0xCB, 0x03, 0x73, 0x00, 0x77, 0x30, 0x4B, 0x0C, 0x0D, 0xB0, 0x17,
  0x20, 0x8A, 0x08, 0x72, 0x02, 0xB0, 0xD0, 0xEB, 0x72, 0x08, 0xC0, 0x87, 0x2B, 0x00, 0xEB, 0x71,
  0x08, 0xE0, 0x87, 0x1B, 0x0E, 0x0D, 0xB0, 0x26, 0x08, 0xF9, 0x08, 0x60, 0x2B, 0x0D, 0x0B, 0xB0,
  0x45, 0x08, 0xC0, 0x0E, 0xC0, 0x95, 0x04, 0xB0, 0xB0, 0x9B, 0x09, 0x40, 0x5C, 0x82, 0xE2, 0x2E,
  0xC0, 0x74, 0x09, 0xB0, 0x90, 0x4B, 0x0E, 0x30, 0x10, 0xEB, 0x0E, 0x02, 0x20, 0x20, 0xDC, 0x01,
  0x30, 0xEB, 0x81, 0x40, 0xEB, 0x06, 0x20, 0x7B, 0x0E, 0x02, 0x40, 0x20, 0xEB, 0x07, 0x20, 0x6B,
  0x0E, 0x20, 0x9B, 0x82, 0xE1, 0x0C, 0xB0, 0x66, 0x06, 0xB8, 0x2C, 0x01, 0xEB, 0x09, 0x20, 0x10,
  0xEB, 0x81, 0xA0, 0xEB, 0x01, 0x60, 0x1B, 0x81, 0xE0, 0xAB, 0x0E, 0x01, 0x30, 0x7C, 0x09, 0x0E,
  0xB0, 0x16, 0x01, 0xB0, 0xE0, 0x9C, 0x07, 0x50, 0xCF, 0x90, 0x56, 0x05, 0xF9, 0x0C, 0x60, 0x10,
  0xDF, 0x0D, 0x60, 0xDF, 0x0D, 0x01, 0x70, 0x20, 0xDF, 0x84, 0xD5, 0x11, 0x5D, 0xF0, 0xD0, 0x27,
  0x20, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x75, 0x07, 0x0E, 0xFF, 0x0E, 0x07, 0x77, 0x18, 0x11, 0x9E,
  0xFB, 0x81, 0xE9, 0x17, 0x75, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_fire_department() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_fire_department_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_florist 48x48, 4-bit Alpha,  RLE, 426 bytes.
static const unsigned char ic_outlined_48_maps_local_florist_data[] PROGMEM = {
  0x77, 0x18, 0x46, 0xBE, 0xEB, 0x67, 0x77, 0x70, 0x10, 0xDE, 0x0D, 0x01, 0x77, 0x74, 0x01, 0x0D,
  0xF9, 0x0D, 0x01, 0x77, 0x72, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x77, 0x50, 0x60, 0xDE, 0x82, 0x91,
  0x19, 0xE0, 0xD0, 0x67, 0x70, 0x10, 0xCF, 0x0D, 0x40, 0xDF, 0x0C, 0x01, 0x75, 0x0B, 0xF9, 0x0B,
  0x40, 0xBF, 0x90, 0xB7, 0x40, 0x5D, 0x0D, 0xB0, 0xD4, 0x0D, 0xB0, 0xDD, 0x05, 0x73, 0x0B, 0xB8,
  0x3B, 0x10, 0x3D, 0xA8, 0x2B, 0xEE, 0xBA, 0x83, 0xC3, 0x01, 0xBB, 0x0B, 0x73, 0x0D, 0xB0, 0x23,
  0x01, 0x0E, 0xE0, 0xE0, 0x13, 0x02, 0xB0, 0xD7, 0x30, 0xEB, 0x01, 0x30, 0xCF, 0x90, 0xB3, 0x01,
  0xB0, 0xE7, 0x30, 0xCB, 0x08, 0x20, 0x6F, 0xB0, 0x52, 0x08, 0xB0, 0xC7, 0x30, 0x7C, 0x81, 0xB3,
  0xBF, 0xB8, 0x1B, 0x3B, 0xC0, 0x77, 0x40, 0xDF, 0xFF, 0x90, 0xD7, 0x50, 0xDF, 0xFF, 0x90, 0xD7,
  0x40, 0x7C, 0x81, 0xB3, 0xBF, 0xB8, 0x1B, 0x3B, 0xC0, 0x77, 0x30, 0xCB, 0x08, 0x20, 0x6F, 0xB0,
  0x62, 0x08, 0xB0, 0xC7, 0x30, 0xEB, 0x01, 0x30, 0xCF, 0x90, 0xC3, 0x01, 0xB0, 0xE7, 0x30, 0xEB,
  0x02, 0x30, 0x10, 0xEE, 0x0E, 0x01, 0x30, 0x2B, 0x0D, 0x73, 0x0B, 0xB8, 0x3B, 0x10, 0x3D, 0xA8,
  0x2B, 0xEE, 0xBA, 0x83, 0xD3, 0x01, 0xBB, 0x0B, 0x73, 0x05, 0xD0, 0xEB, 0x0D, 0x40, 0xDB, 0x0D,
  0xD0, 0x57, 0x40, 0xBF, 0x90, 0xB4, 0x0B, 0xF9, 0x0B, 0x75, 0x01, 0x0C, 0xF0, 0xD4, 0x0D, 0xF0,
  0xC0, 0x17, 0x70, 0x60, 0xDE, 0x82, 0x91, 0x19, 0xE0, 0xD0, 0x67, 0x18, 0x4D, 0xDB, 0x95, 0x15,
  0x01, 0x09, 0xFB, 0x09, 0x01, 0x58, 0x21, 0x59, 0xB0, 0xFD, 0xD0, 0xB0, 0x44, 0x01, 0x0D, 0xF9,
  0x0D, 0x01, 0x40, 0x40, 0xBD, 0x0D, 0x0B, 0xF0, 0xB0, 0x33, 0x01, 0x0D, 0xE0, 0xD0, 0x13, 0x03,
  0x0B, 0xF0, 0xB0, 0x9F, 0xA0, 0x84, 0x84, 0x6B, 0xEE, 0xB6, 0x40, 0x8F, 0xA0, 0x90, 0x5F, 0xB0,
  0xB0, 0x17, 0x30, 0x10, 0xBF, 0xB0, 0x50, 0x1C, 0x05, 0x0A, 0xD0, 0xC0, 0x17, 0x10, 0x10, 0xCD,
  0x0A, 0x05, 0xC8, 0x11, 0x0B, 0xB8, 0x2A, 0x03, 0xDC, 0x0B, 0x71, 0x0B, 0xC8, 0x2D, 0x30, 0xAB,
  0x0B, 0x20, 0x4C, 0x82, 0x30, 0x1B, 0xC0, 0x86, 0x08, 0xC8, 0x2B, 0x10, 0x3C, 0x04, 0x30, 0xBB,
  0x0D, 0x01, 0x20, 0xBC, 0x03, 0x40, 0x3C, 0x0B, 0x20, 0x10, 0xDB, 0x0B, 0x40, 0x3C, 0x0B, 0x20,
  0x10, 0xDB, 0x0B, 0x40, 0xBB, 0x0D, 0x01, 0x20, 0xBC, 0x03, 0x50, 0x8C, 0x82, 0xB1, 0x03, 0xC0,
  0x42, 0x04, 0xC8, 0x23, 0x01, 0xBC, 0x08, 0x70, 0xBC, 0x82, 0xD3, 0x0A, 0xB0, 0xB2, 0x0B, 0xB8,
  0x2A, 0x03, 0xDC, 0x0B, 0x71, 0x01, 0x0C, 0xD0, 0xA0, 0x5C, 0x00, 0x1C, 0x05, 0x0A, 0xD0, 0xC0,
  0x17, 0x20, 0x10, 0xBF, 0xB0, 0x05, 0xFB, 0x0B, 0x01, 0x75, 0x08, 0xFA, 0x00, 0x9F, 0xA0, 0x87,
  0x71, 0x03, 0x0B, 0xF0, 0x0B, 0xF0, 0xB0, 0x37, 0x74, 0x04, 0x0B, 0xD0, 0x0D, 0xD0, 0xB0, 0x47,
  0x77, 0x18, 0x92, 0x15, 0x9B, 0xDD, 0xDD, 0xB9, 0x51, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_florist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_florist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_gas_station 48x48, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_outlined_48_maps_local_gas_station_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFD, 0x81, 0xDA, 0x17, 0x70, 0x10, 0xEF, 0xFA, 0x0E, 0x01, 0x30, 0x50, 0x97,
  0x10, 0xAF, 0xFC, 0x0A, 0x20, 0x5A, 0x09, 0x70, 0xDF, 0xFC, 0x0D, 0x20, 0x9B, 0x09, 0x6C, 0x75,
  0xC3, 0x09, 0xB0, 0x95, 0xC7, 0x5C, 0x40, 0x9B, 0x09, 0x4C, 0x75, 0xC5, 0x09, 0xB0, 0x93, 0xC7,
  0x5C, 0x50, 0x40, 0xEB, 0x09, 0x2C, 0x75, 0xC4, 0x07, 0xE0, 0x81, 0xC7, 0x5C, 0x30, 0x4F, 0x90,
  0x4C, 0x75, 0xC3, 0x0B, 0xA8, 0x2B, 0x11, 0xBA, 0x0B, 0xC7, 0x5C, 0x30, 0xEA, 0x01, 0x20, 0x1A,
  0x0E, 0xC7, 0x5C, 0x30, 0xEA, 0x01, 0x20, 0x1F, 0x75, 0xC3, 0x0B, 0xA8, 0x2B, 0x11, 0xBF, 0xFF,
  0xA3, 0x04, 0xFF, 0xFF, 0x94, 0x08, 0xFF, 0xFF, 0x58, 0x34, 0xBE, 0xEB, 0xFF, 0xFA, 0x73, 0xF7,
  0x5E, 0x81, 0xDA, 0x15, 0xF7, 0x5F, 0x90, 0xE0, 0x14, 0xF7, 0x5F, 0xA0, 0xA4, 0xF7, 0x5C, 0x3A,
  0x0D, 0x4F, 0x75, 0xC3, 0xB4, 0xF7, 0x5C, 0x3B, 0x4F, 0x75, 0xC3, 0xB4, 0xF7, 0x5C, 0x3B, 0x4F,
  0x75, 0xC3, 0xB4, 0xF7, 0x5C, 0x3B, 0x4F, 0x75, 0xC3, 0xB4, 0xF7, 0x5C, 0x3B, 0x4F, 0x75, 0xC3,
  0xB4, 0xF7, 0x5C, 0x30, 0xEA, 0x01, 0x20, 0x1A, 0x0E, 0xFF, 0xE3, 0x0B, 0xA8, 0x2B, 0x11, 0xBA,
  0x0B, 0xFF, 0xE3, 0x04, 0xF9, 0x04, 0xFF, 0xE4, 0x08, 0xE0, 0x81, 0xFF, 0xE5, 0x84, 0x4B, 0xEE,
  0xB4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_gas_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 40, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_gas_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_grocery_store 48x48, 4-bit Alpha,  RLE, 251 bytes.
static const unsigned char ic_outlined_48_maps_local_grocery_store_data[] PROGMEM = {
  0xE0, 0xB7, 0x77, 0x75, 0xF0, 0x37, 0x77, 0x74, 0xF0, 0xB7, 0x77, 0x74, 0xF9, 0x02, 0x77, 0x77,
  0x70, 0xBF, 0xFF, 0xFD, 0x0D, 0x04, 0x40, 0x4F, 0xFF, 0xFE, 0x0D, 0x50, 0xCF, 0xFF, 0xFD, 0x0D,
  0x50, 0x5F, 0xFF, 0xFD, 0x07, 0x60, 0xDB, 0x08, 0x77, 0x72, 0x0A, 0xB0, 0xD7, 0x06, 0xB0, 0xE0,
  0x17, 0x77, 0x03, 0xC0, 0x57, 0x10, 0xDB, 0x07, 0x77, 0x70, 0xBB, 0x0C, 0x72, 0x06, 0xB0, 0xE7,
  0x76, 0x04, 0xC0, 0x37, 0x30, 0xEB, 0x07, 0x77, 0x50, 0xDB, 0x0A, 0x74, 0x07, 0xB0, 0xD7, 0x74,
  0x06, 0xC0, 0x27, 0x40, 0x10, 0xEB, 0x06, 0x77, 0x30, 0xEB, 0x09, 0x76, 0x08, 0xB0, 0xD7, 0x72,
  0x08, 0xB0, 0xE0, 0x17, 0x60, 0x1C, 0x05, 0x77, 0x01, 0x0E, 0xB0, 0x77, 0x71, 0x09, 0xB0, 0xC7,
  0x70, 0x9B, 0x0D, 0x77, 0x20, 0x2F, 0xFF, 0x90, 0x67, 0x73, 0x0E, 0xFF, 0xE0, 0xC7, 0x73, 0x08,
  0xFF, 0xE0, 0xE0, 0x37, 0x72, 0x01, 0x0E, 0xFF, 0xC8, 0x1E, 0xB3, 0x77, 0x30, 0x9B, 0x0D, 0x77,
  0x77, 0x60, 0x3C, 0x05, 0x77, 0x77, 0x60, 0xAB, 0x0C, 0x77, 0x77, 0x70, 0xEB, 0x04, 0x77, 0x77,
  0x70, 0xEF, 0xFF, 0xE7, 0x50, 0xAF, 0xFF, 0xE7, 0x50, 0x20, 0xEF, 0xFF, 0xD7, 0x68, 0x12, 0xAE,
  0xFF, 0xFB, 0x80, 0x9B, 0x10, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x84, 0x1A, 0xDD, 0xA1, 0x76, 0x01,
  0x0E, 0xC0, 0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x09, 0xE0, 0xA7, 0x50, 0x9E, 0x0A,
  0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xDE, 0x0D, 0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xDE, 0x0D, 0x75, 0x09,
  0xE0, 0xA7, 0x50, 0x9E, 0x0A, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x50, 0x10, 0xEC, 0x0E, 0x01,
  0x76, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x84, 0x1A, 0xDD, 0xA1, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_grocery_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_grocery_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_hospital 48x48, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_outlined_48_maps_local_hospital_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x19, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x4E, 0x74, 0xF9, 0x74, 0xE7, 0x4F, 0x97, 0x4E, 0x74, 0xF9, 0x74, 0xE7, 0x4F,
  0x97, 0x4E, 0x74, 0xF9, 0x74, 0xE7, 0x4F, 0x97, 0x4E, 0x74, 0xF9, 0x4F, 0xFE, 0x4F, 0x94, 0xFF,
  0xE4, 0xF9, 0x4F, 0xFE, 0x4F, 0x94, 0xFF, 0xE4, 0xF9, 0x4F, 0xFE, 0x4F, 0x94, 0xFF, 0xE4, 0xF9,
  0x74, 0xE7, 0x4F, 0x97, 0x4E, 0x74, 0xF9, 0x74, 0xE7, 0x4F, 0x97, 0x4E, 0x74, 0xF9, 0x74, 0xE7,
  0x4F, 0x97, 0x4E, 0x74, 0xF9, 0x74, 0xE7, 0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77,
  0x7F, 0x97, 0x77, 0x7C, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF,
  0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_hospital() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_hospital_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_hotel 48x48, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_outlined_48_maps_local_hotel_data[] PROGMEM = {
  0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC7, 0x72, 0xFF, 0xA8,
  0x2E, 0xC8, 0x24, 0xC7, 0x72, 0xFF, 0xE0, 0x93, 0xC5, 0x84, 0x6C, 0xEE, 0xC6, 0x5F, 0xFF, 0x0B,
  0x2C, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x3F, 0xFF, 0x90, 0x91, 0xC3, 0x0C, 0xF9, 0x0C, 0x3C, 0x75,
  0x81, 0x15, 0xDC, 0x02, 0xC2, 0x06, 0xFB, 0x06, 0x2C, 0x77, 0x01, 0x0D, 0xB0, 0x8C, 0x20, 0xCB,
  0x82, 0xB1, 0x1B, 0xB0, 0xC2, 0xC7, 0x71, 0x05, 0xB0, 0xCC, 0x20, 0xEB, 0x01, 0x20, 0x1B, 0x0E,
  0x2C, 0x77, 0x10, 0x1B, 0x0E, 0xC2, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE2, 0xC7, 0x72, 0xF9, 0x20,
  0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC2, 0xC7, 0x72, 0xF9, 0x20, 0x6F, 0xB0, 0x62, 0xC7, 0x72, 0xF9,
  0x30, 0xCF, 0x90, 0xC3, 0xC7, 0x72, 0xF9, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x3C, 0x77, 0x2F, 0x95,
  0x84, 0x6C, 0xEE, 0xC6, 0x5C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C, 0x77, 0x28,
  0x0A, 0xE4, 0xF8, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F,
  0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_hotel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_hotel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_laundry_service 48x48, 4-bit Alpha,  RLE, 250 bytes.
static const unsigned char ic_outlined_48_maps_local_laundry_service_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFB, 0x84, 0xD9, 0x10, 0x1E, 0xFF, 0xFF, 0x81, 0xE1, 0xAF, 0xFF, 0xFA,
  0x0A, 0x0D, 0xFF, 0xFF, 0xA0, 0xDC, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x28, 0x24, 0xDD, 0x42,
  0x82, 0x4D, 0xD4, 0x75, 0xF9, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x75, 0xF9, 0x20, 0xDA, 0x0D,
  0x20, 0xDA, 0x0D, 0x75, 0xF9, 0x28, 0x24, 0xDD, 0x42, 0x82, 0x4D, 0xD4, 0x75, 0xF9, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x71, 0x86, 0x59, 0xDE, 0xED, 0x95,
  0x71, 0xF9, 0x60, 0x40, 0xDF, 0x90, 0xD0, 0x46, 0xF9, 0x50, 0x8F, 0xD0, 0x85, 0xF9, 0x40, 0x8F,
  0xF0, 0x84, 0xF9, 0x30, 0x4F, 0xFA, 0x04, 0x3F, 0x93, 0x0D, 0xFD, 0x09, 0x0E, 0xA0, 0xD3, 0xF9,
  0x20, 0x5F, 0xD8, 0x17, 0x05, 0xB0, 0x52, 0xF9, 0x20, 0x9F, 0xC0, 0x73, 0x0C, 0xA0, 0x92, 0xF9,
  0x20, 0xDF, 0xB0, 0x74, 0x08, 0xA0, 0xD2, 0xF9, 0x20, 0xEF, 0xA0, 0x75, 0x05, 0xA0, 0xE2, 0xF9,
  0x20, 0xEF, 0x90, 0x76, 0x05, 0xA0, 0xE2, 0xF9, 0x20, 0xDF, 0x07, 0x70, 0x8A, 0x0D, 0x2F, 0x92,
  0x09, 0xE0, 0x77, 0x10, 0xCA, 0x09, 0x2F, 0x92, 0x05, 0xD0, 0x77, 0x10, 0x5B, 0x05, 0x2F, 0x93,
  0x0D, 0xB0, 0x97, 0x10, 0x20, 0xEA, 0x0D, 0x3F, 0x93, 0x04, 0xB0, 0xE0, 0x56, 0x05, 0x0E, 0xB0,
  0x43, 0xF9, 0x40, 0x8C, 0x84, 0xC8, 0x55, 0x8C, 0xC0, 0x84, 0xF9, 0x50, 0x8F, 0xD0, 0x85, 0xF9,
  0x60, 0x40, 0xDF, 0x90, 0xD0, 0x46, 0xF9, 0x71, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x71, 0xF9, 0x77,
  0x73, 0xF9, 0x77, 0x73, 0xC0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF,
  0xFF, 0x84, 0xE1, 0x01, 0xAE, 0xFF, 0xFB, 0x81, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_laundry_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_laundry_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_library 48x48, 4-bit Alpha,  RLE, 302 bytes.
static const unsigned char ic_outlined_48_maps_local_library_data[] PROGMEM = {
  0x77, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0x76, 0x09, 0xF9, 0x09, 0x77, 0x74, 0x0B, 0xFB, 0x0B,
  0x77, 0x72, 0x09, 0xFD, 0x09, 0x77, 0x70, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x27, 0x76, 0x08,
  0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x76, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0x76, 0x0E,
  0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x76, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x76, 0x0C, 0xB0, 0x56,
  0x05, 0xB0, 0xC7, 0x76, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x76, 0x02, 0xC8, 0x4D,
  0x51, 0x15, 0xDC, 0x02, 0x77, 0x70, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xBF, 0xB0, 0xB7, 0x59, 0x84,
  0xED, 0xB9, 0x62, 0x60, 0x9F, 0x90, 0x96, 0x84, 0x26, 0x9B, 0xDE, 0xF9, 0x81, 0xD8, 0x34, 0x86,
  0x28, 0xCE, 0xEC, 0x82, 0x48, 0x13, 0x8D, 0xFF, 0xB0, 0xC0, 0x57, 0x50, 0x50, 0xCF, 0xFF, 0x90,
  0xC0, 0x37, 0x10, 0x30, 0xCF, 0xFA, 0x81, 0x7B, 0xEF, 0x09, 0x60, 0x9F, 0x81, 0xEB, 0x7F, 0x93,
  0x04, 0x0B, 0xE0, 0xD0, 0x32, 0x03, 0x0D, 0xE0, 0xB0, 0x43, 0xF9, 0x50, 0x20, 0x9D, 0x82, 0xE5,
  0x5E, 0xD0, 0x90, 0x25, 0xF9, 0x70, 0x30, 0xCF, 0xB0, 0xC0, 0x37, 0xF9, 0x72, 0x08, 0xF9, 0x09,
  0x72, 0xF9, 0x73, 0x05, 0xE0, 0x67, 0x3F, 0x97, 0x40, 0x30, 0xEA, 0x0E, 0x03, 0x74, 0xF9, 0x75,
  0x82, 0x3E, 0xE3, 0x75, 0xF9, 0x76, 0x00, 0x27, 0x6F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x98, 0x2A, 0x74, 0x17, 0x77, 0x81, 0x36, 0x9F,
  0xD8, 0x1B, 0x61, 0x77, 0x81, 0x16, 0xBF, 0xFD, 0x0B, 0x04, 0x73, 0x03, 0x0B, 0xFF, 0xFB, 0x0C,
  0x04, 0x60, 0x40, 0xCF, 0xE1, 0x84, 0x11, 0x46, 0x9C, 0xF9, 0x0B, 0x01, 0x20, 0x10, 0xAF, 0x98,
  0x4D, 0x96, 0x41, 0x17, 0x18, 0x11, 0x6C, 0xE8, 0x2E, 0x66, 0xEE, 0x81, 0xC6, 0x17, 0x73, 0x03,
  0x0A, 0xFD, 0x0A, 0x03, 0x77, 0x71, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x77, 0x75, 0x05, 0x0E, 0xC0,
  0xE0, 0x57, 0x77, 0x71, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x77, 0x74, 0x00, 0xA7, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 44), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_mall 48x48, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_outlined_48_maps_local_mall_data[] PROGMEM = {
  0x77, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x75, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x72, 0x08,
  0xFD, 0x08, 0x77, 0x70, 0x8F, 0xF0, 0x87, 0x75, 0x04, 0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x47,
  0x74, 0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xD7, 0x73, 0x05, 0xC0, 0x27, 0x10, 0x2C, 0x05,
  0x77, 0x20, 0x9B, 0x08, 0x73, 0x08, 0xB0, 0x97, 0x72, 0x0D, 0xB0, 0x37, 0x30, 0x3B, 0x0D, 0x77,
  0x20, 0xEB, 0x75, 0xB0, 0xE7, 0x28, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF,
  0xC8, 0x1E, 0x1A, 0xFF, 0xFF, 0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77,
  0x7F, 0x94, 0x0E, 0xB7, 0x5B, 0x0E, 0x4F, 0x94, 0x0D, 0xB0, 0x37, 0x30, 0x3B, 0x0D, 0x4F, 0x94,
  0x09, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0x4F, 0x94, 0x05, 0xC0, 0x27, 0x10, 0x2C, 0x05, 0x4F, 0x95,
  0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xD5, 0xF9, 0x50, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D,
  0x04, 0x5F, 0x96, 0x08, 0xFF, 0x08, 0x6F, 0x97, 0x08, 0xFD, 0x08, 0x7F, 0x97, 0x10, 0x40, 0xDF,
  0x90, 0xD0, 0x47, 0x1F, 0x97, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x3F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77,
  0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_mall() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_mall_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_movies 48x48, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_outlined_48_maps_local_movies_data[] PROGMEM = {
  0xC4, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0xFA, 0x71,
  0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xA4, 0xC7, 0x1C, 0x4F, 0x94, 0xC7,
  0x1C, 0x4F, 0x94, 0xC7, 0x1C, 0x4F, 0x94, 0xC7, 0x1C, 0x4F, 0xFA, 0x71, 0xFF, 0xFB, 0x71, 0xFF,
  0xFB, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xA4, 0xC7, 0x1C, 0x4F, 0x94, 0xC7, 0x1C, 0x4F, 0x94, 0xC7,
  0x1C, 0x4F, 0x94, 0xC7, 0x1C, 0x4F, 0xFA, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB,
  0x71, 0xFF, 0xA4, 0xC7, 0x1C, 0x4F, 0x94, 0xC7, 0x1C, 0x4F, 0x94, 0xC7, 0x1C, 0x4F, 0x94, 0xC7,
  0x1C, 0x4F, 0xFA, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xA4, 0xFF,
  0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_movies() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_movies_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_offer 48x48, 4-bit Alpha,  RLE, 321 bytes.
static const unsigned char ic_outlined_48_maps_local_offer_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEA, 0x27, 0x75, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x37, 0x74, 0x0A,
  0xFF, 0xE0, 0xE0, 0x37, 0x73, 0x0D, 0xFF, 0xF0, 0xE0, 0x37, 0x72, 0xC7, 0x70, 0x7C, 0x0E, 0x03,
  0x77, 0x1C, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0xC3, 0x82, 0x8D, 0xD8, 0x72, 0x07, 0xC0, 0xE0,
  0x37, 0x6C, 0x20, 0x8C, 0x08, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x5C, 0x20, 0xDC, 0x0D, 0x73, 0x07,
  0xC0, 0xE0, 0x37, 0x4C, 0x20, 0xDC, 0x0D, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x3C, 0x20, 0x8C, 0x08,
  0x75, 0x07, 0xC0, 0xE0, 0x37, 0x2C, 0x38, 0x28, 0xDD, 0x87, 0x70, 0x7C, 0x0E, 0x03, 0x71, 0xC7,
  0x77, 0x10, 0x7C, 0x0E, 0x03, 0x7C, 0x77, 0x72, 0x07, 0xC0, 0xE0, 0x36, 0xC7, 0x77, 0x30, 0x7C,
  0x0E, 0x03, 0x5C, 0x77, 0x74, 0x07, 0xC0, 0xE0, 0x34, 0xC7, 0x77, 0x50, 0x7C, 0x0E, 0x03, 0x3C,
  0x77, 0x76, 0x07, 0xC0, 0xE0, 0x32, 0x0E, 0xB0, 0x77, 0x77, 0x60, 0x7C, 0x82, 0xE3, 0x0A, 0xC0,
  0x77, 0x77, 0x60, 0x7C, 0x82, 0xE2, 0x2E, 0xC0, 0x77, 0x77, 0x60, 0x7C, 0x82, 0xA0, 0x3E, 0xC0,
  0x77, 0x77, 0x60, 0x7B, 0x0E, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x75, 0x08, 0xB0, 0xE3, 0x03, 0x0E,
  0xC0, 0x77, 0x77, 0x30, 0x7C, 0x0A, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x25,
  0x03, 0x0E, 0xC0, 0x77, 0x76, 0x07, 0xC0, 0xE0, 0x37, 0x03, 0x0E, 0xC0, 0x77, 0x74, 0x07, 0xC0,
  0xE0, 0x37, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x74, 0x03, 0x0E, 0xC0, 0x77,
  0x70, 0x7C, 0x0E, 0x03, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x50, 0x7C, 0x0E, 0x03, 0x77, 0x10, 0x30,
  0xEC, 0x07, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x10, 0x7C, 0x0E, 0x03,
  0x77, 0x50, 0x30, 0xEC, 0x07, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x40, 0x7C,
  0x0E, 0x03, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0x30, 0xEC,
  0x00, 0x7C, 0x0E, 0x03, 0x77, 0x76, 0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x10, 0x30, 0xEE,
  0x0E, 0x03, 0x77, 0x77, 0x30, 0x30, 0xEC, 0x0E, 0x03, 0x77, 0x77, 0x58, 0x42, 0xAE, 0xEA, 0x27,
  0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_offer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_offer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_parking 48x48, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_outlined_48_maps_local_parking_data[] PROGMEM = {
  0xFF, 0x83, 0xED, 0xA6, 0x17, 0xFF, 0xD0, 0x90, 0x15, 0xFF, 0xE0, 0xE0, 0x44, 0xFF, 0xF9, 0x06,
  0x3F, 0xFF, 0xA0, 0x42, 0xFF, 0xFA, 0x0E, 0x01, 0x1F, 0xFF, 0xB0, 0x91, 0xFF, 0xFC, 0x01, 0xF9,
  0x70, 0x30, 0xAF, 0x90, 0x6F, 0x97, 0x20, 0x8F, 0x0B, 0xF9, 0x73, 0x0E, 0xE0, 0xDF, 0x97, 0x30,
  0xAE, 0x0E, 0xF9, 0x73, 0x0A, 0xE0, 0xEF, 0x97, 0x30, 0xEE, 0x0D, 0xF9, 0x72, 0x08, 0xF0, 0xBF,
  0x97, 0x03, 0x0A, 0xF9, 0x06, 0xFF, 0xFC, 0x01, 0xFF, 0xFB, 0x09, 0x1F, 0xFF, 0xA0, 0xE0, 0x11,
  0xFF, 0xFA, 0x04, 0x2F, 0xFF, 0x90, 0x63, 0xFF, 0xE0, 0xE0, 0x44, 0xFF, 0xD0, 0x90, 0x15, 0xFF,
  0x83, 0xED, 0xA6, 0x17, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77,
  0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F, 0x97, 0x74, 0xF9, 0x77, 0x4F,
  0x97, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_parking() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 6, 37, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_parking_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_pharmacy 48x48, 4-bit Alpha,  RLE, 233 bytes.
static const unsigned char ic_outlined_48_maps_local_pharmacy_data[] PROGMEM = {
  0x77, 0x77, 0x81, 0xC8, 0x37, 0x77, 0x74, 0x03, 0xB0, 0xC0, 0x67, 0x77, 0x72, 0x09, 0xC0, 0xB7,
  0x77, 0x72, 0x0E, 0xC0, 0x57, 0x77, 0x71, 0x05, 0xC0, 0xE7, 0x77, 0x72, 0x0A, 0xC0, 0x97, 0x77,
  0x71, 0x01, 0xD0, 0x47, 0x77, 0x71, 0x06, 0xC0, 0xD5, 0x80, 0xA9, 0x4F, 0x0C, 0xB0, 0x57, 0x77,
  0x50, 0x5B, 0x0C, 0x07, 0xB0, 0xB7, 0x77, 0x50, 0xBB, 0x07, 0x02, 0xC0, 0x17, 0x77, 0x30, 0x1C,
  0x81, 0x20, 0xCB, 0x05, 0x77, 0x73, 0x05, 0xB0, 0xC2, 0x07, 0xB0, 0xB7, 0x3C, 0x73, 0x0B, 0xB0,
  0x72, 0x02, 0xC0, 0x17, 0x2C, 0x72, 0x01, 0xC0, 0x23, 0x0C, 0xB0, 0x57, 0x2C, 0x72, 0x05, 0xB0,
  0xC4, 0x07, 0xB0, 0xB7, 0x2C, 0x72, 0x0B, 0xB0, 0x74, 0x02, 0xC0, 0x17, 0x1C, 0x71, 0x01, 0xC0,
  0x25, 0x0C, 0xB0, 0x57, 0x1C, 0x71, 0x05, 0xB0, 0xC6, 0x07, 0xB0, 0xB2, 0xFF, 0xA2, 0x0B, 0xB0,
  0x76, 0x02, 0xC0, 0x11, 0xFF, 0xA1, 0x01, 0xC0, 0x26, 0x02, 0xC0, 0x11, 0xFF, 0xA1, 0x01, 0xC0,
  0x26, 0x07, 0xB0, 0xB2, 0xFF, 0xA2, 0x0B, 0xB0, 0x76, 0x0C, 0xB0, 0x57, 0x1C, 0x71, 0x05, 0xB0,
  0xC5, 0x02, 0xC0, 0x17, 0x1C, 0x71, 0x01, 0xC0, 0x24, 0x07, 0xB0, 0xB7, 0x2C, 0x72, 0x0B, 0xB0,
  0x74, 0x0C, 0xB0, 0x57, 0x2C, 0x72, 0x05, 0xB0, 0xC3, 0x02, 0xC0, 0x17, 0x2C, 0x72, 0x01, 0xC0,
  0x22, 0x07, 0xB0, 0xB7, 0x3C, 0x73, 0x0B, 0xB0, 0x72, 0x0C, 0xB0, 0x57, 0x77, 0x30, 0x5B, 0x81,
  0xC0, 0x2C, 0x01, 0x77, 0x73, 0x01, 0xC0, 0x20, 0x7B, 0x0B, 0x77, 0x75, 0x0B, 0xB0, 0x70, 0xCB,
  0x05, 0x77, 0x75, 0x05, 0xB0, 0xC8, 0x0A, 0x94, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_pharmacy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_pharmacy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_phone 48x48, 4-bit Alpha,  RLE, 232 bytes.
static const unsigned char ic_outlined_48_maps_local_phone_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xD0, 0x47, 0x77, 0x40, 0xDF, 0xA0, 0xD7, 0x77, 0x4F, 0xC7, 0x77, 0x40, 0xEF,
  0xB0, 0x17, 0x77, 0x30, 0xDB, 0x01, 0x20, 0xDB, 0x03, 0x77, 0x73, 0x0C, 0xB0, 0x42, 0x0B, 0xB0,
  0x47, 0x77, 0x30, 0xAB, 0x06, 0x20, 0x9B, 0x07, 0x77, 0x73, 0x07, 0xB0, 0x82, 0x06, 0xB0, 0xB7,
  0x77, 0x30, 0x5B, 0x0B, 0x20, 0x2B, 0x0E, 0x77, 0x73, 0x02, 0xC2, 0x05, 0xC0, 0x27, 0x77, 0x30,
  0xDB, 0x04, 0x05, 0xD0, 0x17, 0x77, 0x30, 0x9B, 0x0C, 0xD0, 0x57, 0x77, 0x40, 0x5F, 0x90, 0x57,
  0x77, 0x60, 0xEE, 0x05, 0x77, 0x77, 0x09, 0xD0, 0x57, 0x77, 0x71, 0x03, 0xC0, 0x77, 0x77, 0x73,
  0x0B, 0xB0, 0xB7, 0x77, 0x73, 0x03, 0xC0, 0x57, 0x77, 0x73, 0x0B, 0xB0, 0xD0, 0x17, 0x77, 0x72,
  0x02, 0xC0, 0xA7, 0x77, 0x73, 0x07, 0xC0, 0x67, 0x77, 0x73, 0x0C, 0xC0, 0x37, 0x77, 0x72, 0x02,
  0x0E, 0xB0, 0xE0, 0x37, 0x77, 0x72, 0x05, 0xC0, 0xE0, 0x37, 0x40, 0x10, 0x27, 0x73, 0x06, 0xC0,
  0xE0, 0x37, 0x28, 0x75, 0xEF, 0xEB, 0x74, 0x21, 0x75, 0x08, 0xD0, 0x67, 0x05, 0xFB, 0x0D, 0x04,
  0x73, 0x08, 0xD0, 0xA0, 0x14, 0x05, 0xFD, 0x0D, 0x74, 0x06, 0xD0, 0xD0, 0x52, 0x05, 0xFF, 0x75,
  0x05, 0x0E, 0xD0, 0xB0, 0x7D, 0x84, 0x53, 0x69, 0xBD, 0xC7, 0x60, 0x20, 0xCF, 0xB0, 0x56, 0xC7,
  0x71, 0x07, 0xF9, 0x0C, 0x04, 0x6C, 0x77, 0x20, 0x20, 0xBF, 0xA8, 0x3B, 0x86, 0x42, 0xC7, 0x74,
  0x03, 0x0B, 0xFF, 0xA7, 0x76, 0x81, 0x39, 0xEF, 0xE7, 0x77, 0x28, 0x15, 0x9D, 0xFA, 0x0D, 0x77,
  0x75, 0x89, 0x02, 0x58, 0xAC, 0xDD, 0xFD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_pizza 48x48, 4-bit Alpha,  RLE, 325 bytes.
static const unsigned char ic_outlined_48_maps_local_pizza_data[] PROGMEM = {
  0x74, 0x84, 0x15, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x85, 0x17, 0x75, 0x81, 0x16, 0xCF, 0xF8, 0x1C,
  0x61, 0x77, 0x01, 0x09, 0xFF, 0xE0, 0x90, 0x17, 0x40, 0x7F, 0xFF, 0xA0, 0xE0, 0x77, 0x10, 0x30,
  0xCF, 0x83, 0xD8, 0x43, 0x12, 0x83, 0x13, 0x48, 0xDF, 0x0C, 0x03, 0x50, 0x50, 0xED, 0x81, 0xE7,
  0x17, 0x58, 0x11, 0x7E, 0xD0, 0xE0, 0x53, 0x07, 0xD0, 0xE0, 0x67, 0x74, 0x06, 0x0E, 0xD8, 0x17,
  0x07, 0xD0, 0xA0, 0x12, 0x82, 0x8D, 0xD8, 0x77, 0x01, 0x0A, 0xD0, 0x70, 0xAC, 0x06, 0x30, 0x8C,
  0x08, 0x77, 0x10, 0x6C, 0x0A, 0x02, 0xC0, 0x73, 0x0D, 0xC0, 0xD7, 0x71, 0x07, 0xC8, 0x12, 0x08,
  0xB0, 0xE0, 0x12, 0x0D, 0xC0, 0xD7, 0x70, 0x10, 0xEB, 0x08, 0x20, 0x10, 0xEB, 0x09, 0x20, 0x8C,
  0x08, 0x77, 0x09, 0xB0, 0xE0, 0x13, 0x07, 0xC0, 0x22, 0x82, 0x8D, 0xD8, 0x77, 0x02, 0xC0, 0x75,
  0x0D, 0xB0, 0xA7, 0x76, 0x0A, 0xB0, 0xD6, 0x05, 0xC0, 0x47, 0x74, 0x04, 0xC0, 0x57, 0x0B, 0xB0,
  0xC7, 0x74, 0x0C, 0xB0, 0xB7, 0x10, 0x3C, 0x05, 0x77, 0x20, 0x5C, 0x03, 0x72, 0x09, 0xB0, 0xD7,
  0x72, 0x0D, 0xB0, 0x97, 0x30, 0x10, 0xEB, 0x07, 0x77, 0x07, 0xB0, 0xE0, 0x17, 0x40, 0x8B, 0x0E,
  0x01, 0x48, 0x28, 0xDD, 0x84, 0x01, 0x0E, 0xB0, 0x87, 0x60, 0xEB, 0x09, 0x30, 0x8C, 0x08, 0x30,
  0x9B, 0x0E, 0x77, 0x06, 0xC0, 0x32, 0x0D, 0xC0, 0xD2, 0x03, 0xC0, 0x67, 0x71, 0x0C, 0xB0, 0xB2,
  0x0D, 0xC0, 0xD2, 0x0B, 0xB0, 0xC7, 0x72, 0x04, 0xC8, 0x14, 0x08, 0xC8, 0x18, 0x04, 0xC0, 0x47,
  0x73, 0x0B, 0xB0, 0xD2, 0x82, 0x8D, 0xD8, 0x20, 0xDB, 0x0B, 0x77, 0x40, 0x2C, 0x06, 0x60, 0x6C,
  0x02, 0x77, 0x50, 0x9B, 0x0E, 0x01, 0x40, 0x10, 0xEB, 0x09, 0x77, 0x60, 0x10, 0xEB, 0x08, 0x40,
  0x8B, 0x0E, 0x01, 0x77, 0x70, 0x7C, 0x02, 0x20, 0x2C, 0x07, 0x77, 0x72, 0x0D, 0xB0, 0xA2, 0x0A,
  0xB0, 0xD7, 0x77, 0x30, 0x5C, 0x00, 0x3C, 0x05, 0x77, 0x74, 0x0B, 0xB0, 0x0C, 0xB0, 0xB7, 0x77,
  0x50, 0x3F, 0x90, 0x37, 0x77, 0x60, 0xAE, 0x0A, 0x77, 0x77, 0x01, 0xE0, 0x17, 0x77, 0x71, 0x08,
  0xC0, 0x87, 0x77, 0x73, 0x0E, 0xA0, 0xE7, 0x77, 0x74, 0x06, 0xA0, 0x67, 0x77, 0x75, 0x00, 0xC7,
  0x77, 0x76, 0x00, 0x47, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_pizza() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_pizza_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_play 48x48, 4-bit Alpha,  RLE, 242 bytes.
static const unsigned char ic_outlined_48_maps_local_play_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x10,
  0x03, 0x77, 0x1F, 0x97, 0x71, 0x00, 0x97, 0x71, 0xF9, 0x77, 0x10, 0x0E, 0x77, 0x1F, 0x90, 0x87,
  0x60, 0x5A, 0x05, 0x76, 0x08, 0xFA, 0x0B, 0x75, 0x0B, 0xA0, 0xB7, 0x50, 0xBF, 0xC0, 0x87, 0x30,
  0x2C, 0x02, 0x73, 0x08, 0xE8, 0x11, 0x5D, 0xC0, 0x23, 0x85, 0x33, 0x55, 0x67, 0xBC, 0x85, 0xB7,
  0x65, 0x43, 0x23, 0x02, 0xC8, 0x1D, 0x51, 0x20, 0x10, 0xDB, 0x08, 0x30, 0xAF, 0xFA, 0x0A, 0x30,
  0x8B, 0x0D, 0x01, 0x50, 0x5B, 0x0C, 0x40, 0x7F, 0xF0, 0x74, 0x0C, 0xB0, 0x56, 0x01, 0xB0, 0xE5,
  0x04, 0x0E, 0xFB, 0x0E, 0x04, 0x50, 0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x60, 0x20, 0xDF, 0x90, 0xD0,
  0x26, 0x0E, 0xB0, 0x16, 0x05, 0xB0, 0xC7, 0x03, 0xF9, 0x03, 0x70, 0xCB, 0x05, 0x50, 0x10, 0xDB,
  0x08, 0x70, 0x6F, 0x90, 0x67, 0x08, 0xB0, 0xD0, 0x12, 0x81, 0x15, 0xDC, 0x02, 0x70, 0xAF, 0x90,
  0xA7, 0x02, 0xC8, 0x1D, 0x51, 0xE0, 0x87, 0x10, 0xEB, 0x00, 0x8B, 0x0E, 0x71, 0x08, 0xFC, 0x0B,
  0x71, 0x03, 0xA0, 0xC0, 0x32, 0x03, 0x0C, 0xA0, 0x37, 0x10, 0xBF, 0xA0, 0x87, 0x28, 0x17, 0xF7,
  0x68, 0x17, 0xF7, 0x72, 0x08, 0xF9, 0x73, 0x07, 0x02, 0x71, 0x02, 0x07, 0x73, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D,
  0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81,
  0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_police 48x48, 4-bit Alpha,  RLE, 361 bytes.
static const unsigned char ic_outlined_48_maps_local_police_data[] PROGMEM = {
  0x77, 0x28, 0x25, 0xCC, 0x57, 0x77, 0x72, 0x06, 0x0D, 0xC0, 0xD0, 0x67, 0x77, 0x48, 0x11, 0x8E,
  0xF9, 0x81, 0xE8, 0x17, 0x76, 0x03, 0x0A, 0xFF, 0x0A, 0x03, 0x77, 0x20, 0x50, 0xCF, 0x90, 0x09,
  0xF9, 0x0C, 0x05, 0x75, 0x06, 0x0D, 0xF8, 0x1E, 0x71, 0x28, 0x11, 0x7E, 0xF0, 0xD0, 0x67, 0x81,
  0x18, 0xEF, 0x0C, 0x05, 0x71, 0x05, 0x0C, 0xF8, 0x1E, 0x81, 0x20, 0x30, 0xAF, 0x90, 0xA0, 0x47,
  0x50, 0x40, 0xAF, 0x90, 0xA0, 0x3F, 0x90, 0x90, 0x27, 0x72, 0x02, 0x09, 0xFE, 0x81, 0xE7, 0x17,
  0x76, 0x81, 0x17, 0xEF, 0xA0, 0x57, 0x50, 0x03, 0x75, 0x05, 0xF9, 0x76, 0x00, 0x97, 0x6F, 0x97,
  0x58, 0x21, 0xEE, 0x17, 0x5F, 0x97, 0x50, 0x7A, 0x07, 0x75, 0xF9, 0x75, 0x0D, 0xA0, 0xD7, 0x5F,
  0x97, 0x40, 0x4C, 0x04, 0x74, 0xF9, 0x74, 0x0B, 0xC0, 0xB7, 0x4F, 0x94, 0x85, 0x13, 0x45, 0x78,
  0x9E, 0x85, 0x98, 0x75, 0x43, 0x14, 0xF9, 0x30, 0x7F, 0xFE, 0x06, 0x3F, 0x94, 0x05, 0x0E, 0xFF,
  0xA0, 0xE0, 0x44, 0xC0, 0xEB, 0x50, 0x30, 0xEF, 0xF0, 0xD0, 0x35, 0xB0, 0xE0, 0xDB, 0x01, 0x50,
  0x20, 0xDF, 0xD0, 0xC0, 0x15, 0x01, 0xB0, 0xD0, 0xCB, 0x03, 0x60, 0x10, 0xBF, 0xB0, 0xB7, 0x03,
  0xB0, 0xC0, 0xAB, 0x04, 0x70, 0x1F, 0xB0, 0x17, 0x04, 0xB0, 0xA0, 0x8B, 0x08, 0x70, 0x4F, 0xB0,
  0x47, 0x08, 0xB0, 0x80, 0x4B, 0x0C, 0x70, 0x8F, 0xB0, 0x87, 0x0C, 0xB0, 0x41, 0xC0, 0x16, 0x0B,
  0xFB, 0x0B, 0x60, 0x1C, 0x20, 0xCB, 0x06, 0x6C, 0x82, 0xB2, 0x2B, 0xC6, 0x06, 0xB0, 0xC2, 0x07,
  0xB0, 0xD5, 0x03, 0xA0, 0xD0, 0x54, 0x05, 0x0D, 0xA0, 0x35, 0x0D, 0xB0, 0x72, 0x01, 0x0E, 0xB0,
  0x44, 0x81, 0x7F, 0x87, 0x18, 0x18, 0xF7, 0x40, 0x4B, 0x0E, 0x01, 0x30, 0x9B, 0x0C, 0x40, 0x70,
  0x27, 0x30, 0x20, 0x74, 0x0C, 0xB0, 0x94, 0x02, 0xC0, 0x77, 0x76, 0x07, 0xC0, 0x25, 0x09, 0xB0,
  0xE0, 0x27, 0x74, 0x02, 0x0E, 0xB0, 0x97, 0x0D, 0xB0, 0xD7, 0x74, 0x0D, 0xB0, 0xD7, 0x10, 0x5C,
  0x0B, 0x77, 0x20, 0xBC, 0x05, 0x72, 0x09, 0xC0, 0xA7, 0x70, 0xAC, 0x09, 0x74, 0x0B, 0xC0, 0xC0,
  0x17, 0x30, 0x10, 0xCC, 0x0B, 0x76, 0x0C, 0xC0, 0xD0, 0x57, 0x10, 0x50, 0xDC, 0x0C, 0x77, 0x01,
  0x0C, 0xD0, 0xA0, 0x24, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x72, 0x0A, 0xE8, 0x2B, 0x55, 0xBE, 0x0A,
  0x77, 0x50, 0x7F, 0xF0, 0x77, 0x77, 0x02, 0x0A, 0xFB, 0x0A, 0x02, 0x77, 0x73, 0x04, 0x0C, 0xE0,
  0xC0, 0x47, 0x77, 0x78, 0x42, 0x7C, 0xC7, 0x27, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_police() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_police_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_post_office 48x48, 4-bit Alpha,  RLE, 199 bytes.
static const unsigned char ic_outlined_48_maps_local_post_office_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x0A, 0x01, 0x77, 0x77, 0x01, 0x0A, 0xFA, 0x0E, 0x06,
  0x77, 0x75, 0x06, 0x0E, 0xFD, 0x0C, 0x03, 0x77, 0x71, 0x03, 0x0C, 0xFF, 0xA0, 0x87, 0x76, 0x08,
  0xFE, 0x04, 0x0D, 0xC0, 0xD0, 0x47, 0x72, 0x04, 0x0D, 0xC0, 0xD0, 0x4F, 0x92, 0x08, 0xD0, 0xA0,
  0x17, 0x50, 0x10, 0xAD, 0x08, 0x2F, 0x93, 0x03, 0x0C, 0xC0, 0xE0, 0x67, 0x30, 0x60, 0xEC, 0x0C,
  0x03, 0x3F, 0x95, 0x06, 0x0E, 0xC0, 0xC0, 0x36, 0x03, 0x0C, 0xC0, 0xE0, 0x65, 0xF9, 0x60, 0x10,
  0xAD, 0x08, 0x40, 0x8D, 0x0A, 0x01, 0x6F, 0x97, 0x10, 0x40, 0xDC, 0x82, 0xD4, 0x4D, 0xC0, 0xD0,
  0x47, 0x1F, 0x97, 0x30, 0x8F, 0xB0, 0x87, 0x3F, 0x97, 0x40, 0x30, 0xCE, 0x0C, 0x03, 0x74, 0xF9,
  0x76, 0x06, 0x0E, 0xA0, 0xE0, 0x67, 0x6F, 0x97, 0x78, 0x21, 0xAA, 0x17, 0x7F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C,
  0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_post_office() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_post_office_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_printshop 48x48, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_outlined_48_maps_local_printshop_data[] PROGMEM = {
  0x71, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xC7,
  0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7,
  0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x48, 0x16, 0xCE, 0xFF, 0xFF, 0x81, 0xEC, 0x64, 0x01, 0x0C,
  0xFF, 0xFF, 0xE0, 0xC0, 0x12, 0x0C, 0x80, 0xC0, 0xF8, 0x1C, 0x06, 0x80, 0xC2, 0xF0, 0x60, 0xCB,
  0x0B, 0x01, 0x77, 0x77, 0x01, 0x0B, 0xB0, 0xC0, 0xEB, 0x01, 0x77, 0x74, 0x84, 0x4D, 0xD4, 0x01,
  0xB0, 0xEC, 0x77, 0x75, 0x0D, 0xA0, 0xD2, 0xF9, 0x77, 0x75, 0x0D, 0xA0, 0xD2, 0xF9, 0x77, 0x75,
  0x82, 0x4D, 0xD4, 0x2F, 0x97, 0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9,
  0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xFF, 0xA7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7,
  0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xD7, 0x1C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77,
  0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7,
  0x72, 0xFF, 0xFB, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_printshop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_printshop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_see 48x48, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_outlined_48_maps_local_see_data[] PROGMEM = {
  0x76, 0x07, 0xFD, 0x07, 0x77, 0x74, 0x05, 0xFF, 0x05, 0x77, 0x72, 0x04, 0xFF, 0xA0, 0x47, 0x77,
  0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x48, 0x11, 0xAD, 0xFC, 0x04, 0x71, 0x04, 0xFC, 0x84, 0xDA,
  0x10, 0x1E, 0xFD, 0x05, 0x73, 0x05, 0xFD, 0x81, 0xE1, 0xAF, 0xD0, 0x77, 0x50, 0x7F, 0xD0, 0xA0,
  0xDF, 0xC0, 0x87, 0x70, 0x8F, 0xC0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x75, 0x86,
  0x59, 0xDE, 0xED, 0x95, 0x75, 0xF9, 0x73, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0xF9, 0x72, 0x08,
  0xFD, 0x08, 0x72, 0xF9, 0x71, 0x08, 0xD8, 0x2C, 0x99, 0xCD, 0x08, 0x71, 0xF9, 0x70, 0x4C, 0x0A,
  0x02, 0x40, 0x20, 0xAC, 0x04, 0x7F, 0x97, 0x0D, 0xB0, 0x77, 0x10, 0x7B, 0x0D, 0x7F, 0x96, 0x05,
  0xB0, 0xA7, 0x30, 0xAB, 0x05, 0x6F, 0x96, 0x09, 0xB0, 0x27, 0x30, 0x2B, 0x09, 0x6F, 0x96, 0x0D,
  0xA0, 0xC7, 0x50, 0xCA, 0x0D, 0x6F, 0x96, 0x0E, 0xA0, 0xA7, 0x50, 0xAA, 0x0E, 0x6F, 0x96, 0x0E,
  0xA0, 0xA7, 0x50, 0xAA, 0x0E, 0x6F, 0x96, 0x0D, 0xA0, 0xC7, 0x50, 0xCA, 0x0D, 0x6F, 0x96, 0x09,
  0xB0, 0x27, 0x30, 0x2B, 0x09, 0x6F, 0x96, 0x05, 0xB0, 0xA7, 0x30, 0xAB, 0x05, 0x6F, 0x97, 0x0D,
  0xB0, 0x77, 0x10, 0x7B, 0x0D, 0x7F, 0x97, 0x04, 0xC0, 0xA0, 0x24, 0x02, 0x0A, 0xC0, 0x47, 0xF9,
  0x71, 0x08, 0xD8, 0x2C, 0x99, 0xCD, 0x08, 0x71, 0xF9, 0x72, 0x08, 0xFD, 0x08, 0x72, 0xF9, 0x73,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0xF9, 0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x75, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E,
  0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_see() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_see_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_shipping 48x48, 4-bit Alpha,  RLE, 198 bytes.
static const unsigned char ic_outlined_48_maps_local_shipping_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x75, 0x01, 0x0E, 0xFF, 0xFF, 0xA7, 0x50, 0xAF, 0xFF, 0xFB, 0x75,
  0x0D, 0xFF, 0xFF, 0xB7, 0x5C, 0x77, 0x73, 0xC7, 0x5C, 0x77, 0x73, 0xC7, 0x5C, 0x77, 0x73, 0xC7,
  0x5C, 0x77, 0x73, 0xC7, 0x5C, 0x77, 0x73, 0xFB, 0x05, 0x5C, 0x77, 0x73, 0xFB, 0x0E, 0x02, 0x4C,
  0x77, 0x73, 0xFC, 0x0C, 0x4C, 0x77, 0x73, 0xC5, 0x09, 0xA0, 0x93, 0xC7, 0x77, 0x3C, 0x60, 0xCA,
  0x05, 0x2C, 0x77, 0x73, 0xC6, 0x83, 0x1E, 0xFE, 0x21, 0xC7, 0x77, 0x3C, 0x70, 0x4A, 0x0C, 0x1C,
  0x77, 0x73, 0xC7, 0x10, 0x7A, 0x09, 0xC7, 0x77, 0x3F, 0xFE, 0x77, 0x73, 0xFF, 0xE7, 0x77, 0x3F,
  0xFE, 0x77, 0x73, 0xFF, 0xE3, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x1F, 0xFE, 0x10, 0x10, 0xCE, 0x0C,
  0x01, 0x76, 0x80, 0x9D, 0x4F, 0x82, 0xB1, 0x1B, 0xFF, 0xE8, 0x2B, 0x11, 0xBF, 0xFA, 0x01, 0x20,
  0x1F, 0xFE, 0x01, 0x20, 0x1F, 0x94, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x50, 0xEB, 0x01, 0x20,
  0x1B, 0x0E, 0x71, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x75, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C,
  0x71, 0x06, 0xFB, 0x06, 0x75, 0x06, 0xFB, 0x06, 0x72, 0x0C, 0xF9, 0x0C, 0x77, 0x0C, 0xF9, 0x0C,
  0x73, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x75, 0x84, 0x6C, 0xEE, 0xC6,
  0x77, 0x48, 0x46, 0xCE, 0xEC, 0x67,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_shipping() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_shipping_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_local_taxi 48x48, 4-bit Alpha,  RLE, 186 bytes.
static const unsigned char ic_outlined_48_maps_local_taxi_data[] PROGMEM = {
  0x75, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x30, 0x80, 0xEF, 0xFF,
  0x90, 0xE0, 0x87, 0x20, 0x8F, 0xFF, 0xD0, 0x87, 0x10, 0xEF, 0xFF, 0xD0, 0xE7, 0x05, 0xFF, 0xFF,
  0x05, 0x60, 0xAB, 0x08, 0x77, 0x60, 0x8B, 0x0A, 0x50, 0x1C, 0x02, 0x77, 0x60, 0x3C, 0x01, 0x40,
  0x6B, 0x0C, 0x77, 0x71, 0x0D, 0xB0, 0x64, 0x0B, 0xB0, 0x77, 0x77, 0x10, 0x7B, 0x0B, 0x30, 0x1C,
  0x02, 0x77, 0x71, 0x02, 0xC0, 0x12, 0x06, 0xB0, 0xC7, 0x77, 0x30, 0xCB, 0x06, 0x20, 0xCF, 0xFF,
  0xFC, 0x81, 0xC0, 0x2F, 0xFF, 0xFE, 0x02, 0x07, 0xFF, 0xFF, 0xE0, 0x70, 0xCF, 0xFF, 0xFE, 0x0C,
  0xC0, 0x17, 0x77, 0x50, 0x1F, 0x97, 0x77, 0x7F, 0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8,
  0x3F, 0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F, 0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D,
  0x2F, 0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F, 0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08,
  0x2F, 0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x78,
  0x0A, 0xA6, 0xF7, 0x77, 0x3F, 0xD7, 0x77, 0x3E, 0x0D, 0xC0, 0xD7, 0x77, 0x30, 0xDC, 0x81, 0xD4,
  0xDA, 0x0D, 0x04, 0x77, 0x73, 0x04, 0x0D, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_local_taxi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_local_taxi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_lunch_dining 48x48, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_outlined_48_maps_lunch_dining_data[] PROGMEM = {
  0x74, 0x86, 0x14, 0x79, 0xBD, 0xDE, 0xA8, 0x6E, 0xDD, 0xB9, 0x74, 0x17, 0x75, 0x81, 0x38, 0xCF,
  0xFC, 0x81, 0xD9, 0x37, 0x70, 0x50, 0xCF, 0xFF, 0xB0, 0xD0, 0x67, 0x30, 0x20, 0xCF, 0xFF, 0xF0,
  0xD0, 0x37, 0x06, 0xF9, 0x85, 0xB8, 0x64, 0x32, 0x13, 0x85, 0x12, 0x36, 0x8B, 0xEF, 0x07, 0x50,
  0x7E, 0x0A, 0x04, 0x77, 0x40, 0x40, 0x9E, 0x07, 0x30, 0x4D, 0x09, 0x01, 0x77, 0x71, 0x01, 0x09,
  0xD0, 0x42, 0x0D, 0xB0, 0xE0, 0x47, 0x77, 0x50, 0x40, 0xEB, 0x81, 0xD0, 0x5C, 0x04, 0x77, 0x77,
  0x03, 0xC0, 0x50, 0xAB, 0x0A, 0x77, 0x77, 0x20, 0x8B, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xE8,
  0x09, 0xE3, 0xF8, 0x09, 0xE7, 0x08, 0x64, 0xBE, 0xFE, 0xC7, 0x15, 0x81, 0x29, 0xDA, 0x81, 0xD9,
  0x25, 0x86, 0x17, 0xCE, 0xFE, 0xA4, 0x40, 0x40, 0xCF, 0x84, 0xE7, 0x20, 0x3A, 0xF9, 0x84, 0xA3,
  0x01, 0x7E, 0xF8, 0x1C, 0x61, 0x80, 0x9A, 0x0F, 0x84, 0xA3, 0x02, 0x7E, 0xF8, 0x4D, 0x50, 0x15,
  0xCF, 0x84, 0xE7, 0x10, 0x3A, 0xD8, 0x1D, 0x92, 0x68, 0x57, 0xCE, 0xFE, 0xB5, 0x68, 0x65, 0xAD,
  0xFE, 0xC7, 0x15, 0x81, 0x29, 0xC9, 0x80, 0x9E, 0x40, 0x80, 0xAC, 0x0F, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8,
  0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_lunch_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_lunch_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_map 48x48, 4-bit Alpha,  RLE, 223 bytes.
static const unsigned char ic_outlined_48_maps_map_data[] PROGMEM = {
  0x72, 0x84, 0x27, 0xCC, 0x71, 0x77, 0x38, 0x21, 0x7D, 0xB6, 0x81, 0x27, 0xCE, 0x81, 0xB6, 0x17,
  0x50, 0x40, 0xAC, 0x38, 0x12, 0x7C, 0xFD, 0x0B, 0x05, 0x78, 0x12, 0x8E, 0xE8, 0x11, 0x7C, 0xFF,
  0xC0, 0xA0, 0x52, 0x05, 0x0B, 0xFA, 0x0D, 0xFF, 0xF9, 0x00, 0xEF, 0xFC, 0x81, 0xB6, 0x1C, 0x81,
  0x17, 0xCF, 0xE0, 0xE0, 0x9F, 0x98, 0x1B, 0x61, 0x3C, 0x38, 0x12, 0x7D, 0xF9, 0x0B, 0x05, 0x2F,
  0x96, 0xC6, 0x03, 0x08, 0xC0, 0x80, 0x24, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9,
  0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9,
  0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9,
  0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9,
  0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9,
  0x6C, 0x71, 0xC6, 0xF9, 0x6C, 0x71, 0xC6, 0xF9, 0x40, 0x10, 0x7C, 0x08, 0x03, 0x6C, 0x6F, 0x92,
  0x05, 0x0B, 0xF9, 0x81, 0xD7, 0x23, 0xC3, 0x81, 0x16, 0xBF, 0x90, 0x80, 0xEF, 0xE8, 0x1C, 0x71,
  0xC8, 0x11, 0x6B, 0xFF, 0xC0, 0x0E, 0xFF, 0xF9, 0x0D, 0xFA, 0x0B, 0x05, 0x20, 0x50, 0xAF, 0xFC,
  0x81, 0xC7, 0x1E, 0x81, 0xE8, 0x27, 0x05, 0x0B, 0xFD, 0x81, 0xC7, 0x23, 0xC0, 0xA0, 0x47, 0x58,
  0x11, 0x6B, 0xE8, 0x1C, 0x72, 0x68, 0x2B, 0xD7, 0x17, 0x73, 0x84, 0x17, 0xCC, 0x72, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_map_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_maps_ugc 48x48, 4-bit Alpha,  RLE, 349 bytes.
static const unsigned char ic_outlined_48_maps_maps_ugc_data[] PROGMEM = {
  0x77, 0x28, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D,
  0x81, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x75, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57,
  0x73, 0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x71, 0x0A, 0xD0, 0xE0, 0x67,
  0x50, 0x60, 0xED, 0x0A, 0x76, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0x9C, 0x0E, 0x03,
  0x77, 0x40, 0x30, 0xEC, 0x09, 0x72, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x57, 0x01,
  0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x60, 0x9C, 0x03, 0x77, 0x73, 0x03,
  0xC0, 0x95, 0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x40, 0x8B, 0x0E, 0x75, 0xC7, 0x50, 0xEB,
  0x08, 0x40, 0xDB, 0x06, 0x75, 0xC7, 0x50, 0x6B, 0x0D, 0x30, 0x3C, 0x76, 0xC7, 0x6C, 0x03, 0x20,
  0x7B, 0x0B, 0x76, 0xC7, 0x60, 0xBB, 0x07, 0x20, 0xAB, 0x06, 0x76, 0xC7, 0x60, 0x6B, 0x0A, 0x20,
  0xCB, 0x03, 0x76, 0xC7, 0x60, 0x3B, 0x0C, 0x20, 0xEB, 0x02, 0x7F, 0xFA, 0x70, 0x2B, 0x0E, 0x2C,
  0x71, 0xFF, 0xA7, 0x1C, 0x2C, 0x71, 0xFF, 0xA7, 0x1C, 0x20, 0xEB, 0x01, 0x7F, 0xFA, 0x70, 0x2B,
  0x0E, 0x20, 0xCB, 0x03, 0x76, 0xC7, 0x60, 0x3B, 0x0C, 0x20, 0xAB, 0x06, 0x76, 0xC7, 0x60, 0x6B,
  0x0A, 0x20, 0x7B, 0x0A, 0x76, 0xC7, 0x60, 0xBB, 0x07, 0x20, 0x2B, 0x0E, 0x76, 0xC7, 0x6C, 0x03,
  0x30, 0xDB, 0x06, 0x75, 0xC7, 0x50, 0x6B, 0x0D, 0x40, 0x7B, 0x0B, 0x75, 0xC7, 0x50, 0xEB, 0x08,
  0x40, 0x2B, 0x0D, 0x77, 0x76, 0x07, 0xC0, 0x14, 0x05, 0xB0, 0xC7, 0x77, 0x50, 0x3C, 0x09, 0x50,
  0x9B, 0x08, 0x77, 0x74, 0x01, 0x0E, 0xB0, 0xE0, 0x15, 0x0E, 0xB0, 0x37, 0x77, 0x30, 0x10, 0xCC,
  0x05, 0x50, 0x3B, 0x0E, 0x77, 0x73, 0x03, 0x0E, 0xC0, 0x96, 0x07, 0xB0, 0xA7, 0x77, 0x20, 0x7D,
  0x0A, 0x70, 0xCB, 0x05, 0x38, 0x43, 0x8C, 0xDB, 0x67, 0x50, 0x60, 0xED, 0x0A, 0x70, 0x1C, 0x82,
  0x25, 0xAE, 0xE8, 0x3E, 0xA6, 0x31, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x71, 0x05, 0xFF, 0xFF, 0xA0,
  0xE0, 0x57, 0x20, 0xAF, 0xFF, 0xF9, 0x09, 0x01, 0x73, 0x0E, 0xF9, 0x84, 0xE9, 0x52, 0x7D, 0xFD,
  0x81, 0xD8, 0x17, 0x40, 0x4E, 0x81, 0xC7, 0x36, 0x83, 0x27, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37,
  0x70, 0x8A, 0x82, 0xEA, 0x51, 0x77, 0x77, 0x78, 0x1B, 0x84, 0x80, 0xC3, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_maps_ugc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_maps_ugc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_medical_information 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_outlined_48_maps_medical_information_data[] PROGMEM = {
  0x77, 0x18, 0x11, 0xAD, 0xC8, 0x1D, 0xA1, 0x77, 0x77, 0x10, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x77,
  0x70, 0xAF, 0xB0, 0xA7, 0x77, 0x70, 0xDF, 0xB0, 0xD7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7,
  0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x71, 0x81,
  0x1A, 0xDF, 0xF4, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xA4, 0xFF, 0xA8, 0x1E, 0x1A, 0xFF, 0xB4,
  0xFF, 0xB0, 0xA0, 0xDF, 0xFB, 0x4F, 0xFB, 0x0D, 0xC7, 0x30, 0xDF, 0xB0, 0xD7, 0x3F, 0x97, 0x30,
  0xAF, 0xB0, 0xA7, 0x3F, 0x97, 0x30, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x3F, 0x97, 0x48, 0x11, 0xAD,
  0xC8, 0x1D, 0xA1, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x6C, 0x77, 0x71, 0xF9,
  0x6C, 0x77, 0x71, 0xF9, 0x6C, 0x71, 0xFD, 0x2F, 0x96, 0xC7, 0x1F, 0xD2, 0xF9, 0x2F, 0xD4, 0xFD,
  0x2F, 0x92, 0xFD, 0x77, 0x4F, 0x92, 0xFD, 0x77, 0x4F, 0x92, 0xFD, 0x77, 0x4F, 0x96, 0xC7, 0x1F,
  0x96, 0xF9, 0x6C, 0x71, 0xF9, 0x6F, 0x96, 0xC7, 0x1F, 0x96, 0xF9, 0x6C, 0x77, 0x71, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F,
  0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_medical_information() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_medical_information_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_medical_services 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_outlined_48_maps_medical_services_data[] PROGMEM = {
  0x76, 0x81, 0x1A, 0xDF, 0x98, 0x1D, 0xA1, 0x77, 0x74, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x73,
  0x0A, 0xFF, 0x0A, 0x77, 0x73, 0x0D, 0xFF, 0x0D, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C,
  0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x76, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x84, 0xDA,
  0x10, 0x1E, 0x80, 0xC0, 0xF8, 0x1E, 0x1A, 0x80, 0xC2, 0xF0, 0xA0, 0xD8, 0x0C, 0x2F, 0x0D, 0xC7,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x7C, 0x77,
  0xF9, 0x77, 0xC7, 0x7F, 0x97, 0x7C, 0x77, 0xF9, 0x77, 0xC7, 0x7F, 0x97, 0x7C, 0x77, 0xF9, 0x77,
  0xC7, 0x7F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9,
  0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x7C, 0x77, 0xF9, 0x77, 0xC7, 0x7F, 0x97, 0x7C, 0x77, 0xF9, 0x77,
  0xC7, 0x7F, 0x97, 0x7C, 0x77, 0xF9, 0x77, 0xC7, 0x7F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81,
  0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_medical_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_medical_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_menu_book 48x48, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_outlined_48_maps_menu_book_data[] PROGMEM = {
  0x48, 0x41, 0x68, 0xBD, 0xDA, 0x84, 0xDD, 0xB8, 0x61, 0x71, 0x84, 0x16, 0x8B, 0xDD, 0xA8, 0x4D,
  0xDB, 0x85, 0x16, 0x06, 0x0B, 0xFF, 0x0B, 0x06, 0x40, 0x60, 0xBF, 0xF0, 0xC0, 0x62, 0x05, 0x0D,
  0xFF, 0xC8, 0x2D, 0x45, 0xDF, 0xFC, 0x0D, 0x04, 0x80, 0x98, 0x3F, 0x83, 0xC9, 0x53, 0x12, 0x84,
  0x12, 0x46, 0xAD, 0xFF, 0xFF, 0x81, 0xC6, 0x17, 0x6F, 0xFF, 0xD0, 0xB0, 0x37, 0x72, 0xFF, 0xFD,
  0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x48, 0x42, 0x69, 0xBD, 0xEA, 0x82, 0xED, 0xB9, 0x2F,
  0xFF, 0xD2, 0x08, 0x0D, 0xFD, 0x2F, 0xFF, 0xD2, 0xFF, 0x2F, 0xFF, 0xD2, 0xA8, 0x4E, 0xA6, 0x41,
  0x12, 0x82, 0x12, 0x46, 0x2F, 0xFF, 0xD2, 0x0B, 0x04, 0x77, 0xFF, 0xFD, 0x58, 0x91, 0x14, 0x68,
  0x99, 0x99, 0x86, 0x42, 0xFF, 0xFD, 0x28, 0x13, 0x8D, 0xFC, 0x2F, 0xFF, 0xD2, 0xFF, 0x2F, 0xFF,
  0xD2, 0xB8, 0x91, 0xEB, 0x97, 0x55, 0x55, 0x79, 0xB2, 0xFF, 0xFD, 0x29, 0x09, 0x04, 0x76, 0xFF,
  0xFD, 0x20, 0x14, 0x86, 0x13, 0x35, 0x53, 0x31, 0x3F, 0xFF, 0xD3, 0x82, 0x38, 0xBE, 0xF9, 0x0E,
  0x2F, 0xFF, 0xD2, 0x0D, 0xFE, 0x2F, 0xFF, 0xD2, 0xD8, 0x6E, 0xCB, 0xAA, 0xBC, 0xE9, 0x2F, 0xFF,
  0xD2, 0x98, 0x2E, 0x94, 0x17, 0x10, 0x12, 0xFF, 0xFD, 0x20, 0x67, 0x71, 0xFF, 0xFD, 0x77, 0x4F,
  0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x58, 0x32, 0x69, 0xCD, 0xA8, 0x4D, 0xDB, 0x85, 0x1F, 0xFF, 0xD2,
  0x81, 0x38, 0xD8, 0x0C, 0x3F, 0x03, 0x0B, 0x80, 0x98, 0x1F, 0x83, 0xC8, 0x52, 0x12, 0x84, 0x11,
  0x36, 0x9D, 0xFA, 0x83, 0xC9, 0x53, 0x12, 0x84, 0x12, 0x46, 0x9E, 0xC8, 0x3D, 0xFC, 0x61, 0x76,
  0x81, 0x38, 0xEB, 0x81, 0xC6, 0x17, 0x68, 0x43, 0xAF, 0xD1, 0x27, 0x74, 0x82, 0x1A, 0xB3, 0x77,
  0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_menu_book() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 9, 45, 42), Box(0, 0, 47, 47),
      ic_outlined_48_maps_menu_book_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_merge 48x48, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_outlined_48_maps_merge_data[] PROGMEM = {
  0x76, 0x00, 0x77, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x72, 0x07, 0xC0, 0x77, 0x77, 0x07, 0xE0, 0x77,
  0x75, 0x07, 0xF9, 0x07, 0x77, 0x30, 0x7F, 0xB0, 0x77, 0x71, 0x07, 0xFD, 0x07, 0x76, 0x07, 0xC0,
  0xEC, 0x0E, 0xC0, 0x77, 0x50, 0x7B, 0x0E, 0x03, 0xC0, 0x30, 0xEB, 0x07, 0x76, 0x82, 0x7F, 0xE3,
  0x1C, 0x18, 0x23, 0xEF, 0x77, 0x71, 0x07, 0x03, 0x2C, 0x20, 0x30, 0x77, 0x76, 0xC7, 0x77, 0x3C,
  0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x20, 0x1C,
  0x01, 0x77, 0x71, 0x03, 0xC0, 0x37, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x71, 0x0D, 0xC0, 0xD7, 0x77,
  0x08, 0xE0, 0x87, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x30, 0x5F, 0xB0, 0x57, 0x71, 0x05, 0xD0, 0x05,
  0xD0, 0x57, 0x60, 0x5D, 0x05, 0x20, 0x5D, 0x05, 0x74, 0x05, 0xD0, 0x54, 0x05, 0xD0, 0x57, 0x20,
  0x5D, 0x05, 0x60, 0x5D, 0x05, 0x70, 0x5D, 0x05, 0x71, 0x05, 0xD0, 0x55, 0x05, 0xD0, 0x57, 0x30,
  0x5D, 0x05, 0x30, 0x5D, 0x05, 0x75, 0x05, 0xD8, 0x15, 0x05, 0xD0, 0x57, 0x70, 0x5D, 0x05, 0x0A,
  0xC0, 0x57, 0x72, 0x05, 0xC8, 0x1A, 0x0A, 0xA0, 0x57, 0x74, 0x05, 0xA0, 0xA3, 0x0A, 0x05, 0x77,
  0x60, 0x50, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_minor_crash 48x48, 4-bit Alpha,  RLE, 251 bytes.
static const unsigned char ic_outlined_48_maps_minor_crash_data[] PROGMEM = {
  0x77, 0x2C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x71, 0x0A, 0x05, 0x71,
  0xC7, 0x10, 0x50, 0xA7, 0x40, 0xAA, 0x05, 0x7C, 0x70, 0x5A, 0x0A, 0x72, 0x0A, 0xC0, 0x56, 0xC6,
  0x05, 0xC0, 0xA7, 0x10, 0x5D, 0x05, 0x5C, 0x50, 0x5D, 0x05, 0x72, 0x05, 0xD0, 0x54, 0xC4, 0x05,
  0xD0, 0x57, 0x40, 0x5D, 0x05, 0x3C, 0x30, 0x5D, 0x05, 0x76, 0x05, 0xC0, 0x57, 0x30, 0x5C, 0x05,
  0x77, 0x10, 0x5A, 0x05, 0x75, 0x05, 0xA0, 0x57, 0x73, 0x00, 0x57, 0x70, 0x05, 0x80, 0x9E, 0x60,
  0x08, 0x0E, 0xFF, 0xF9, 0x0E, 0x08, 0x72, 0x08, 0xFF, 0xFD, 0x08, 0x71, 0x0E, 0xFF, 0xFD, 0x0E,
  0x70, 0x5F, 0xFF, 0xF0, 0x56, 0x0A, 0xB0, 0x87, 0x76, 0x08, 0xB0, 0xA5, 0x01, 0xC0, 0x27, 0x76,
  0x03, 0xC0, 0x14, 0x06, 0xB0, 0xC7, 0x77, 0x10, 0xDB, 0x06, 0x40, 0xBB, 0x07, 0x77, 0x71, 0x07,
  0xB0, 0xB3, 0x01, 0xC0, 0x27, 0x77, 0x10, 0x2C, 0x01, 0x20, 0x6B, 0x0C, 0x77, 0x73, 0x0C, 0xB0,
  0x62, 0x0C, 0xFF, 0xFF, 0xC8, 0x1C, 0x02, 0xFF, 0xFF, 0xE0, 0x20, 0x7F, 0xFF, 0xFE, 0x07, 0x0C,
  0xFF, 0xFF, 0xE0, 0xCC, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x78, 0x28,
  0xDD, 0x83, 0xF9, 0x20, 0x8C, 0x08, 0x75, 0x08, 0xC0, 0x82, 0xF9, 0x20, 0xDC, 0x0D, 0x75, 0x0D,
  0xC0, 0xD2, 0xF9, 0x20, 0xDC, 0x0D, 0x75, 0x0D, 0xC0, 0xD2, 0xF9, 0x20, 0x8C, 0x08, 0x75, 0x08,
  0xC0, 0x82, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x78, 0x28, 0xDD, 0x83, 0xF9, 0x77, 0x77, 0xF9, 0x77,
  0x77, 0x80, 0xAA, 0x6F, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xE0, 0xDC, 0x0D, 0x77, 0x73, 0x0D, 0xC8,
  0x1D, 0x4D, 0xA0, 0xD0, 0x47, 0x77, 0x30, 0x40, 0xDA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_minor_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 41, 47), Box(0, 0, 47, 47),
      ic_outlined_48_maps_minor_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_miscellaneous_services 48x48, 4-bit Alpha,  RLE, 305 bytes.
static const unsigned char ic_outlined_48_maps_miscellaneous_services_data[] PROGMEM = {
  0x73, 0x0B, 0xD0, 0xE0, 0x17, 0x77, 0x74, 0xF0, 0x37, 0x77, 0x73, 0x02, 0xF0, 0x67, 0x77, 0x73,
  0x04, 0xF0, 0x87, 0x77, 0x38, 0x11, 0xA6, 0x30, 0x20, 0xBF, 0x0D, 0x04, 0x38, 0x15, 0xA3, 0x77,
  0x30, 0x9A, 0x81, 0xE9, 0x8F, 0xC8, 0x1A, 0x8E, 0xA0, 0xD7, 0x72, 0x03, 0xFF, 0xFA, 0x07, 0x77,
  0x10, 0xCF, 0xFF, 0xA0, 0xE0, 0x17, 0x60, 0x5F, 0xFF, 0xC0, 0x97, 0x60, 0xDF, 0xFF, 0xD0, 0x17,
  0x50, 0x7F, 0xB8, 0x3A, 0x30, 0x28, 0xFB, 0x0A, 0x77, 0x04, 0x0E, 0xF0, 0x95, 0x05, 0xF9, 0x07,
  0x77, 0x20, 0x20, 0xED, 0x0E, 0x70, 0xBE, 0x04, 0x77, 0x40, 0xDD, 0x0B, 0x70, 0x7E, 0x01, 0x77,
  0x40, 0xDD, 0x0B, 0x70, 0x7E, 0x01, 0x77, 0x30, 0x10, 0xDD, 0x0E, 0x70, 0xBE, 0x04, 0x77, 0x20,
  0x40, 0xEF, 0x09, 0x50, 0x5F, 0x90, 0x77, 0x70, 0x7F, 0xB8, 0x3A, 0x30, 0x28, 0xFB, 0x0A, 0x76,
  0x0D, 0xFF, 0xFD, 0x01, 0x75, 0x05, 0xFF, 0xFC, 0x09, 0x77, 0x0C, 0xFF, 0xFA, 0x0E, 0x01, 0x77,
  0x03, 0xFF, 0xFA, 0x07, 0x77, 0x20, 0x9B, 0x09, 0x08, 0xFC, 0x81, 0xA8, 0xEA, 0x0D, 0x40, 0xEB,
  0x07, 0x71, 0x82, 0x1A, 0x61, 0x20, 0x20, 0xBF, 0x0D, 0x04, 0x38, 0x15, 0xA3, 0x30, 0x1C, 0x09,
  0x77, 0x10, 0x4F, 0x08, 0x60, 0x20, 0x12, 0x04, 0xC0, 0xC3, 0x02, 0x74, 0x02, 0xF0, 0x56, 0x82,
  0xDF, 0xA8, 0xE8, 0x3C, 0x7C, 0xF6, 0x74, 0xF0, 0x35, 0x08, 0xFF, 0x0E, 0x01, 0x73, 0x0B, 0xD0,
  0xE0, 0x14, 0x02, 0xFF, 0xA0, 0x97, 0x77, 0x10, 0x4E, 0x82, 0xD6, 0x49, 0xE0, 0xC7, 0x77, 0x20,
  0x30, 0xDB, 0x0E, 0x01, 0x30, 0x8C, 0x0A, 0x77, 0x74, 0x06, 0xB0, 0xA4, 0x02, 0xB0, 0xE7, 0x77,
  0x50, 0x6B, 0x0A, 0x40, 0x2B, 0x0E, 0x77, 0x74, 0x04, 0x0E, 0xB0, 0xE0, 0x23, 0x09, 0xC0, 0xA7,
  0x77, 0x20, 0x4E, 0x82, 0xE7, 0x6A, 0xE0, 0xC7, 0x77, 0x10, 0x10, 0xEF, 0xF9, 0x09, 0x77, 0x72,
  0x07, 0xFF, 0x0E, 0x01, 0x77, 0x73, 0x83, 0xDE, 0x87, 0xED, 0x83, 0xC6, 0xBF, 0x67, 0x77, 0x40,
  0x13, 0x04, 0xC0, 0xC3, 0x02, 0x77, 0x77, 0x20, 0x1C, 0x0A, 0x77, 0x77, 0x78, 0x3C, 0xDD, 0xD6,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_miscellaneous_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_miscellaneous_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_mode_of_travel 48x48, 4-bit Alpha,  RLE, 330 bytes.
static const unsigned char ic_outlined_48_maps_mode_of_travel_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x77, 0x58, 0x11, 0x9E, 0xFB, 0x81, 0xE9, 0x17,
  0x77, 0x10, 0x8F, 0xFA, 0x08, 0x77, 0x50, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x77, 0x20, 0x30, 0xED,
  0x82, 0xD8, 0x42, 0x28, 0x22, 0x48, 0xDD, 0x0E, 0x03, 0x77, 0x01, 0x0E, 0xC0, 0xD0, 0x57, 0x30,
  0x50, 0xDC, 0x0E, 0x01, 0x76, 0x0C, 0xC0, 0x97, 0x70, 0x9C, 0x0C, 0x75, 0x07, 0xC0, 0x77, 0x72,
  0x07, 0xC0, 0x77, 0x30, 0x10, 0xEB, 0x0A, 0x77, 0x40, 0xAB, 0x0E, 0x01, 0x72, 0x09, 0xB0, 0xD7,
  0x76, 0x0D, 0xB0, 0x97, 0x20, 0xEB, 0x06, 0x77, 0x60, 0x6B, 0x0E, 0x71, 0x03, 0xB0, 0xD7, 0x77,
  0x10, 0xDB, 0x03, 0x70, 0x8B, 0x09, 0x77, 0x40, 0x70, 0x32, 0x09, 0xB0, 0x83, 0x03, 0x07, 0x20,
  0xBB, 0x05, 0x77, 0x38, 0x47, 0xFE, 0x30, 0x5B, 0x0B, 0x28, 0x43, 0xEF, 0x70, 0xCB, 0x02, 0x77,
  0x20, 0x7B, 0x81, 0xE3, 0x2B, 0x82, 0xD0, 0x3E, 0xB0, 0x70, 0xEB, 0x01, 0x77, 0x20, 0x7C, 0x0E,
  0x04, 0xB8, 0x1E, 0x3E, 0xC0, 0x7C, 0x77, 0x40, 0x7C, 0x0E, 0xC0, 0xEC, 0x81, 0x70, 0xDB, 0x01,
  0x77, 0x40, 0x7F, 0xD0, 0x72, 0x0C, 0xB0, 0x47, 0x75, 0x07, 0xFB, 0x07, 0x30, 0x9B, 0x08, 0x77,
  0x60, 0x7F, 0x90, 0x74, 0x04, 0xB0, 0xD7, 0x77, 0x07, 0xE0, 0x76, 0x0E, 0xB0, 0x47, 0x77, 0x07,
  0xC0, 0x77, 0x09, 0xB0, 0xC7, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x02, 0xC0, 0x57, 0x77, 0x10, 0x07,
  0x73, 0x0A, 0xB0, 0xD0, 0x17, 0x68, 0x44, 0xBE, 0xEB, 0x47, 0x70, 0x10, 0xEB, 0x0A, 0x75, 0x07,
  0xE0, 0x77, 0x70, 0x7C, 0x05, 0x73, 0x04, 0xF9, 0x04, 0x77, 0x0C, 0xB0, 0xE0, 0x37, 0x20, 0xBF,
  0x90, 0xB7, 0x70, 0x20, 0xEB, 0x0D, 0x01, 0x71, 0x0E, 0xF9, 0x0E, 0x77, 0x10, 0x5C, 0x0C, 0x71,
  0x0E, 0xF9, 0x0E, 0x77, 0x20, 0x8C, 0x0B, 0x70, 0xBF, 0x90, 0xB7, 0x73, 0x0A, 0xC0, 0xA6, 0x0B,
  0xF9, 0x04, 0x77, 0x40, 0xBC, 0x0A, 0x40, 0xAF, 0x90, 0x87, 0x75, 0x01, 0x0C, 0xC0, 0xB2, 0x0B,
  0xC0, 0xFE, 0x0B, 0x04, 0x77, 0x70, 0x10, 0xCC, 0x00, 0xBC, 0x0C, 0x01, 0x77, 0x75, 0x01, 0x0C,
  0xF9, 0x0C, 0x01, 0x77, 0x77, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x73, 0x0B, 0xC0, 0xB7, 0x77,
  0x76, 0x0A, 0xA0, 0xA8, 0x0C, 0x00, 0x00, 0x87, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_mode_of_travel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 46, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_mode_of_travel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_money 48x48, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_outlined_48_maps_money_data[] PROGMEM = {
  0x80, 0xAC, 0x0F, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x2C, 0x20, 0x40, 0xDE, 0x0D, 0x04, 0x20, 0x40, 0xDE, 0x0D, 0x04, 0x2F, 0x92, 0xC2, 0x0D,
  0xF9, 0x0D, 0x20, 0xDF, 0x90, 0xD2, 0xF9, 0x2C, 0x2F, 0xB2, 0xFB, 0x2F, 0x92, 0xC2, 0xFB, 0x2F,
  0xB2, 0xF9, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2F, 0x92, 0xC2, 0xC2, 0xC2, 0xC2, 0xC2, 0xF9, 0x2C,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2F, 0x92, 0xC2, 0xC2, 0xC2, 0xC2, 0xC2, 0xF9, 0x2C, 0x2C, 0x2C, 0x2C,
  0x2C, 0x2F, 0x92, 0xC2, 0xC2, 0xC2, 0xC2, 0xC2, 0xF9, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2F, 0x92,
  0xC2, 0xC2, 0xC2, 0xC2, 0xC2, 0xF9, 0x2C, 0x2F, 0xB2, 0xFB, 0x2F, 0x92, 0xC2, 0xFB, 0x2F, 0xB2,
  0xF9, 0x2C, 0x20, 0xDF, 0x90, 0xD2, 0x0D, 0xF9, 0x0D, 0x2F, 0x92, 0xC2, 0x04, 0x0D, 0xE0, 0xD0,
  0x42, 0x04, 0x0D, 0xE0, 0xD0, 0x42, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0x80, 0xAC, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_money() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_money_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_moped 48x48, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_outlined_48_maps_moped_data[] PROGMEM = {
  0x77, 0x73, 0xE8, 0x1D, 0xA1, 0x77, 0x77, 0x3F, 0x90, 0xE0, 0x17, 0x5F, 0xB7, 0x1F, 0xA0, 0xA7,
  0x5F, 0xB7, 0x1F, 0xA0, 0xD7, 0x5F, 0xB7, 0x7C, 0x75, 0xFB, 0x77, 0xC8, 0x0C, 0x00, 0xC8, 0x0C,
  0x00, 0xC7, 0x38, 0x22, 0x8C, 0xEF, 0x97, 0x7C, 0x72, 0x09, 0xFD, 0x76, 0x03, 0xC7, 0x10, 0xBF,
  0xE7, 0x50, 0x10, 0xDB, 0x0E, 0x70, 0x9F, 0xF7, 0x50, 0xBC, 0x05, 0x60, 0x2C, 0x81, 0xD5, 0x14,
  0xC7, 0x40, 0x8C, 0x08, 0x70, 0x8B, 0x0D, 0x01, 0x6C, 0x73, 0x05, 0xC0, 0xB7, 0x10, 0xCB, 0x05,
  0x7C, 0x72, 0x03, 0x0E, 0xB0, 0xD0, 0x17, 0x10, 0xEB, 0x01, 0x7C, 0x71, 0x01, 0x0D, 0xB0, 0xE0,
  0x37, 0x2C, 0x71, 0xC7, 0x10, 0xBC, 0x86, 0x50, 0x6C, 0xEE, 0xC6, 0x3C, 0x71, 0xC7, 0x08, 0xC8,
  0x18, 0x1C, 0xE0, 0xC0, 0x11, 0xFF, 0xFE, 0x81, 0xB0, 0xCF, 0x90, 0xC1, 0xFF, 0xFD, 0x81, 0xD1,
  0x6F, 0xB0, 0x6F, 0xFF, 0xC8, 0x2E, 0x30, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xCF, 0xFF, 0xC0, 0x52,
  0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE4, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x50, 0xEB, 0x01, 0x20,
  0x1B, 0x0E, 0x40, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x50, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC4,
  0x06, 0xFB, 0x06, 0x75, 0x06, 0xFB, 0x06, 0x50, 0xCF, 0x90, 0xC7, 0x70, 0xCF, 0x90, 0xC6, 0x01,
  0x0C, 0xE0, 0xC0, 0x17, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x71, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x48,
  0x46, 0xCE, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_moped() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_outlined_48_maps_moped_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_mosque 48x48, 4-bit Alpha,  RLE, 320 bytes.
static const unsigned char ic_outlined_48_maps_mosque_data[] PROGMEM = {
  0x77, 0x71, 0x82, 0x1A, 0xA1, 0x80, 0xC7, 0x00, 0x50, 0xEA, 0x0E, 0x05, 0x80, 0xC4, 0x00, 0x10,
  0xAE, 0x0A, 0x01, 0x80, 0xC1, 0x00, 0x50, 0xEF, 0x90, 0xE0, 0x57, 0x77, 0x76, 0x01, 0x0A, 0xFD,
  0x0A, 0x01, 0x77, 0x77, 0x30, 0x40, 0xED, 0x82, 0xC2, 0x2C, 0xD0, 0xE0, 0x47, 0x74, 0x00, 0x77,
  0x20, 0x7E, 0x07, 0x40, 0x7E, 0x07, 0x72, 0x00, 0x75, 0x06, 0xA0, 0x67, 0x05, 0xD0, 0xC0, 0x26,
  0x02, 0x0C, 0xD0, 0x57, 0x06, 0xA0, 0x63, 0x03, 0xC0, 0x35, 0x01, 0x0E, 0xC0, 0x77, 0x30, 0x7C,
  0x0E, 0x01, 0x50, 0x3C, 0x03, 0x20, 0xDC, 0x0D, 0x50, 0x7B, 0x0E, 0x03, 0x75, 0x03, 0x0E, 0xB0,
  0x75, 0x0D, 0xC8, 0x1D, 0x08, 0xE0, 0x74, 0x0C, 0xB0, 0x67, 0x70, 0x6B, 0x0C, 0x40, 0x8E, 0x07,
  0x0D, 0xE0, 0xC4, 0x0E, 0xB0, 0x17, 0x70, 0x1B, 0x0E, 0x40, 0xDE, 0x0C, 0x0E, 0xE0, 0xE4, 0x0E,
  0xB0, 0x17, 0x70, 0x1B, 0x0E, 0x40, 0xEE, 0x0E, 0x0A, 0xE0, 0xA4, 0x0C, 0xB0, 0x47, 0x70, 0x4B,
  0x0C, 0x40, 0xAE, 0x81, 0xA2, 0xEC, 0x0E, 0x02, 0x40, 0x9B, 0x0C, 0x77, 0x0C, 0xB0, 0x94, 0x02,
  0x0E, 0xC8, 0x2E, 0x20, 0x1C, 0x01, 0x50, 0x2C, 0x81, 0xC4, 0x17, 0x18, 0x11, 0x4C, 0xC0, 0x25,
  0x01, 0xC0, 0x13, 0xC5, 0x02, 0x0A, 0xFF, 0xF9, 0x09, 0x02, 0x5C, 0x4C, 0x40, 0x20, 0xEF, 0xFF,
  0xB0, 0xE0, 0x24, 0xC4, 0xC4, 0x0A, 0xFF, 0xFD, 0x0A, 0x4C, 0x4C, 0x40, 0xEF, 0xFF, 0xD0, 0xE4,
  0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4,
  0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xFD, 0x77, 0x6F, 0xD4, 0xFD, 0x77, 0x6F, 0xD4, 0xFD, 0x78, 0x46,
  0xCE, 0xEC, 0x67, 0xFD, 0x4F, 0xD5, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0xFD, 0x4C, 0x76, 0x0C, 0xF9,
  0x0C, 0x76, 0xC4, 0xC7, 0x50, 0x6F, 0xB0, 0x67, 0x5C, 0x4C, 0x75, 0x0C, 0xB8, 0x2B, 0x11, 0xBB,
  0x0C, 0x75, 0xC4, 0xC7, 0x50, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x75, 0xC4, 0xC7, 0x5C, 0x4C, 0x75,
  0xC4, 0xC7, 0x5C, 0x4C, 0x75, 0xC4, 0xC7, 0x5C, 0x4C, 0x75, 0xC4, 0xC7, 0x5C, 0x4C, 0x75, 0xC4,
  0xFF, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xFF, 0xE2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_mosque() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_mosque_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_moving 48x48, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_outlined_48_maps_moving_data[] PROGMEM = {
  0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0x40, 0x5F,
  0x77, 0x77, 0x30, 0x5F, 0x97, 0x77, 0x72, 0x05, 0xFA, 0x77, 0x77, 0x10, 0x5D, 0x05, 0xC7, 0x70,
  0x01, 0x75, 0x05, 0xD0, 0x51, 0xC7, 0x48, 0x12, 0xAE, 0xA0, 0xE0, 0x87, 0x20, 0x5D, 0x05, 0x2C,
  0x73, 0x05, 0x0E, 0xE0, 0xC0, 0x16, 0x05, 0xD0, 0x53, 0xC7, 0x20, 0x5F, 0xA0, 0xD0, 0x14, 0x05,
  0xD0, 0x54, 0xC7, 0x10, 0x5D, 0x00, 0xEC, 0x0D, 0x01, 0x20, 0x5D, 0x05, 0x77, 0x20, 0x5D, 0x05,
  0x20, 0xAC, 0x81, 0xE8, 0xAD, 0x05, 0x77, 0x20, 0x5D, 0x05, 0x40, 0xAF, 0xB0, 0x57, 0x72, 0x05,
  0xD0, 0x56, 0x0A, 0xF9, 0x04, 0x77, 0x20, 0x5D, 0x05, 0x71, 0x07, 0x0E, 0xC0, 0xC0, 0x37, 0x72,
  0x05, 0xD0, 0x57, 0x38, 0x31, 0x57, 0x73, 0x77, 0x30, 0x5D, 0x05, 0x77, 0x77, 0x40, 0x5D, 0x05,
  0x77, 0x77, 0x40, 0x5D, 0x05, 0x77, 0x77, 0x50, 0xAC, 0x05, 0x77, 0x77, 0x70, 0xAA, 0x05, 0x80,
  0xC1, 0x00, 0xA0, 0x58, 0x0C, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_moving() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 12, 43, 35), Box(0, 0, 47, 47),
      ic_outlined_48_maps_moving_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_multiple_stop 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_outlined_48_maps_multiple_stop_data[] PROGMEM = {
  0x77, 0x77, 0x07, 0x77, 0x77, 0x79, 0x07, 0x77, 0x77, 0x6A, 0x07, 0x77, 0x77, 0x5B, 0x07, 0x77,
  0x77, 0x4C, 0x07, 0x77, 0x77, 0x3D, 0x07, 0x68, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x4F, 0xF0,
  0x75, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0xFF, 0x90, 0x74, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4,
  0xFF, 0x90, 0x74, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0xFF, 0x07, 0x77, 0x77, 0x1D, 0x07,
  0x77, 0x77, 0x2C, 0x07, 0x77, 0x77, 0x3B, 0x07, 0x77, 0x77, 0x4A, 0x07, 0x77, 0x77, 0x59, 0x07,
  0x77, 0x77, 0x60, 0x77, 0x70, 0x77, 0x77, 0x76, 0x07, 0x97, 0x77, 0x75, 0x07, 0xA7, 0x77, 0x74,
  0x07, 0xB7, 0x77, 0x73, 0x07, 0xC7, 0x77, 0x72, 0x07, 0xD7, 0x77, 0x71, 0x07, 0xFF, 0x48, 0x24,
  0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x40, 0x7F, 0xF9, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40, 0x7F,
  0xF9, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x50, 0x7F, 0xF4, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD,
  0x46, 0x07, 0xD7, 0x77, 0x73, 0x07, 0xC7, 0x77, 0x74, 0x07, 0xB7, 0x77, 0x75, 0x07, 0xA7, 0x77,
  0x76, 0x07, 0x97, 0x77, 0x77, 0x07, 0x77, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_multiple_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_multiple_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_museum 48x48, 4-bit Alpha,  RLE, 216 bytes.
static const unsigned char ic_outlined_48_maps_museum_data[] PROGMEM = {
  0x77, 0x48, 0x21, 0xAA, 0x17, 0x77, 0x77, 0x03, 0x0D, 0xA0, 0xD0, 0x37, 0x77, 0x75, 0x08, 0xE0,
  0x87, 0x77, 0x72, 0x02, 0x0C, 0xF9, 0x0C, 0x02, 0x77, 0x76, 0x06, 0xFD, 0x06, 0x77, 0x73, 0x01,
  0x0B, 0xFF, 0x0B, 0x01, 0x77, 0x70, 0x50, 0xEF, 0xFA, 0x0E, 0x05, 0x77, 0x40, 0x10, 0xAF, 0xFE,
  0x0A, 0x01, 0x77, 0x10, 0x30, 0xDF, 0xFF, 0x90, 0xD0, 0x37, 0x60, 0x8F, 0xFF, 0xD0, 0x87, 0x30,
  0x20, 0xCF, 0xFF, 0xF0, 0xC0, 0x27, 0x06, 0xFF, 0xFF, 0xC0, 0x64, 0x01, 0x0B, 0xFF, 0xFF, 0xE8,
  0x3B, 0x10, 0x5E, 0x80, 0xC0, 0xF0, 0xE0, 0x5F, 0x97, 0x77, 0x3F, 0xFA, 0x77, 0x73, 0xFF, 0xA7,
  0x77, 0x3F, 0xFA, 0x77, 0x73, 0xF9, 0x4C, 0x4C, 0x05, 0x60, 0x5C, 0x4C, 0x71, 0xC4, 0xC0, 0xE0,
  0x14, 0x01, 0x0E, 0xC4, 0xC7, 0x1C, 0x4D, 0x0A, 0x40, 0xAD, 0x4C, 0x71, 0xC4, 0xE0, 0x52, 0x05,
  0xE4, 0xC7, 0x1C, 0x4E, 0x82, 0xE1, 0x1E, 0xE4, 0xC7, 0x1C, 0x4F, 0x00, 0xAF, 0x4C, 0x71, 0xC4,
  0xC0, 0xAE, 0x0A, 0xC4, 0xC7, 0x1C, 0x4C, 0x01, 0x0E, 0xC0, 0xE0, 0x1C, 0x4C, 0x71, 0xC4, 0xC1,
  0x05, 0xC0, 0x51, 0xC4, 0xC7, 0x1C, 0x4C, 0x20, 0xAA, 0x0A, 0x2C, 0x4C, 0x71, 0xC4, 0xC2, 0x82,
  0x1E, 0xE1, 0x2C, 0x4C, 0x71, 0xC4, 0xC3, 0x00, 0x53, 0xC4, 0xC7, 0x1C, 0x4C, 0x71, 0xC4, 0xC7,
  0x1C, 0x4C, 0x71, 0xC4, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x1C, 0x77, 0x73,
  0xC7, 0x1C, 0x77, 0x73, 0xC4, 0x80, 0xAB, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_museum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_museum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_my_location 48x48, 4-bit Alpha,  RLE, 355 bytes.
static const unsigned char ic_outlined_48_maps_my_location_data[] PROGMEM = {
  0x77, 0x6C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC0, 0x08, 0x21, 0x58,
  0xCC, 0x82, 0xC8, 0x51, 0x77, 0x77, 0x20, 0x50, 0xBF, 0xD0, 0xB0, 0x57, 0x77, 0x50, 0x30, 0xCF,
  0xFA, 0x0C, 0x03, 0x77, 0x72, 0x09, 0xFF, 0xE0, 0x97, 0x76, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22,
  0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x73, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C,
  0x01, 0x77, 0x20, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x71, 0x09, 0xC0, 0xB0, 0x17,
  0x72, 0x01, 0x0B, 0xC0, 0x97, 0x60, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x75, 0x0C, 0xB0, 0xD0,
  0x17, 0x76, 0x01, 0x0D, 0xB0, 0xC7, 0x40, 0x5C, 0x03, 0x78, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x03,
  0xC0, 0x57, 0x30, 0xBB, 0x0A, 0x70, 0x9F, 0x90, 0x97, 0x0A, 0xB0, 0xB7, 0x20, 0x1C, 0x02, 0x60,
  0xBF, 0xB0, 0xB6, 0x02, 0xC0, 0x17, 0x10, 0x5B, 0x0C, 0x60, 0x9F, 0xD0, 0x96, 0x0C, 0xB0, 0x57,
  0x10, 0x9B, 0x07, 0x50, 0x2F, 0xF0, 0x25, 0x07, 0xB0, 0x97, 0x10, 0xCB, 0x03, 0x50, 0x8F, 0xF0,
  0x85, 0x03, 0xB0, 0xC4, 0xF9, 0x02, 0x50, 0xCF, 0xF0, 0xC5, 0x02, 0xFF, 0xA6, 0x0E, 0xFF, 0x0E,
  0x6F, 0xFA, 0x60, 0xEF, 0xF0, 0xE6, 0xFF, 0xA0, 0x25, 0x0C, 0xFF, 0x0C, 0x50, 0x2F, 0x94, 0x0C,
  0xB0, 0x35, 0x08, 0xFF, 0x08, 0x50, 0x3B, 0x0C, 0x71, 0x09, 0xB0, 0x75, 0x02, 0xFF, 0x02, 0x50,
  0x7B, 0x09, 0x71, 0x05, 0xB0, 0xC6, 0x09, 0xFD, 0x09, 0x60, 0xCB, 0x05, 0x71, 0x01, 0xC0, 0x26,
  0x0B, 0xFB, 0x0B, 0x60, 0x2C, 0x01, 0x72, 0x0B, 0xB0, 0xA7, 0x09, 0xF9, 0x09, 0x70, 0xAB, 0x0B,
  0x73, 0x05, 0xC0, 0x37, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x70, 0x3C, 0x05, 0x74, 0x0C, 0xB0, 0xD0,
  0x17, 0x76, 0x01, 0x0D, 0xB0, 0xC7, 0x50, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x76, 0x09, 0xC0,
  0xB0, 0x17, 0x72, 0x01, 0x0B, 0xC0, 0x97, 0x71, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B,
  0x77, 0x20, 0x10, 0xCD, 0x0A, 0x02, 0x73, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x73, 0x01, 0x0B, 0xE8,
  0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x76, 0x09, 0xFF, 0xE0, 0x97, 0x77, 0x20,
  0x30, 0xCF, 0xFA, 0x0C, 0x03, 0x77, 0x75, 0x05, 0x0B, 0xFD, 0x0B, 0x05, 0x77, 0x77, 0x28, 0x21,
  0x58, 0xCC, 0x82, 0xC8, 0x51, 0x80, 0xC0, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4,
  0x0C, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_my_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_my_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_navigation 48x48, 4-bit Alpha,  RLE, 257 bytes.
static const unsigned char ic_outlined_48_maps_navigation_data[] PROGMEM = {
  0x77, 0x00, 0x37, 0x77, 0x70, 0x09, 0x77, 0x76, 0x82, 0x1E, 0xE1, 0x77, 0x75, 0x06, 0xA0, 0x67,
  0x77, 0x50, 0xDA, 0x0D, 0x77, 0x74, 0x03, 0xC0, 0x37, 0x77, 0x30, 0xAC, 0x0A, 0x77, 0x72, 0x01,
  0xE0, 0x17, 0x77, 0x10, 0x7E, 0x07, 0x77, 0x71, 0x0D, 0xE0, 0xD7, 0x77, 0x04, 0xB0, 0x0E, 0xB0,
  0x47, 0x76, 0x0B, 0xB0, 0x09, 0xB0, 0xB7, 0x75, 0x02, 0xC0, 0x03, 0xC0, 0x27, 0x74, 0x08, 0xB0,
  0xC2, 0x0C, 0xB0, 0x87, 0x74, 0x0E, 0xB0, 0x52, 0x05, 0xB0, 0xE7, 0x73, 0x05, 0xB0, 0xE4, 0x0E,
  0xB0, 0x57, 0x72, 0x0B, 0xB0, 0x84, 0x08, 0xB0, 0xB7, 0x71, 0x02, 0xC0, 0x24, 0x02, 0xC0, 0x27,
  0x70, 0x9B, 0x0B, 0x60, 0xBB, 0x09, 0x77, 0x0E, 0xB0, 0x56, 0x05, 0xB0, 0xE7, 0x60, 0x6B, 0x0D,
  0x71, 0x0D, 0xB0, 0x67, 0x50, 0xCB, 0x07, 0x71, 0x07, 0xB0, 0xC7, 0x40, 0x3C, 0x01, 0x71, 0x01,
  0xC0, 0x37, 0x30, 0x9B, 0x0A, 0x73, 0x0A, 0xB0, 0x97, 0x20, 0x1C, 0x04, 0x73, 0x04, 0xC0, 0x17,
  0x10, 0x7B, 0x0D, 0x75, 0x0D, 0xB0, 0x77, 0x10, 0xDB, 0x07, 0x75, 0x07, 0xB0, 0xD7, 0x04, 0xB0,
  0xE0, 0x15, 0x00, 0x25, 0x01, 0x0E, 0xB0, 0x46, 0x0A, 0xB0, 0x94, 0x04, 0x0B, 0xA0, 0xB0, 0x44,
  0x09, 0xB0, 0xA5, 0x01, 0xC0, 0x32, 0x06, 0x0C, 0xE0, 0xC0, 0x62, 0x03, 0xC0, 0x14, 0x07, 0xB8,
  0x2C, 0x17, 0xEF, 0xB8, 0x2E, 0x71, 0xCB, 0x07, 0x40, 0xDB, 0x0D, 0xFF, 0xA0, 0xDB, 0x0D, 0x30,
  0x5F, 0xC8, 0x2A, 0x33, 0xAF, 0xC0, 0x52, 0x0B, 0xF9, 0x81, 0xE8, 0x14, 0x81, 0x18, 0xEF, 0x98,
  0x1B, 0x02, 0xF0, 0xD0, 0x67, 0x30, 0x60, 0xDF, 0x02, 0x08, 0xD0, 0xB0, 0x47, 0x70, 0x40, 0xBD,
  0x08, 0x0D, 0xB0, 0x90, 0x37, 0x74, 0x03, 0x09, 0xB8, 0x3D, 0x2C, 0x81, 0x77, 0x71, 0x82, 0x18,
  0xC2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_navigation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 38, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_navigation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_near_me_disabled 48x48, 4-bit Alpha,  RLE, 372 bytes.
static const unsigned char ic_outlined_48_maps_near_me_disabled_data[] PROGMEM = {
  0x28, 0x14, 0xE3, 0x80, 0xC0, 0x00, 0x4A, 0x0E, 0x03, 0x77, 0x77, 0x60, 0x2C, 0x0E, 0x03, 0x77,
  0x77, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x75, 0x81, 0x16, 0x95, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x20,
  0x50, 0xAA, 0x06, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x58, 0x13, 0x9E, 0xC0, 0x17, 0x07, 0xC0, 0xE0,
  0x37, 0x71, 0x81, 0x17, 0xDE, 0x0A, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x50, 0x50, 0xBF, 0xA0, 0x57,
  0x30, 0x7C, 0x0E, 0x03, 0x71, 0x81, 0x39, 0xEF, 0xB0, 0xE7, 0x50, 0x7C, 0x0E, 0x03, 0x50, 0x70,
  0xDF, 0xE0, 0x97, 0x60, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEE, 0x81, 0xC6, 0x2C, 0x03, 0x77, 0x07,
  0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xA8, 0x1D, 0x82, 0x20, 0x6B, 0x0D, 0x77, 0x20, 0x9C, 0x0E, 0x03,
  0x48, 0x13, 0x94, 0x50, 0xCB, 0x07, 0x77, 0x06, 0x0B, 0xE0, 0xE0, 0x37, 0x30, 0x2C, 0x01, 0x74,
  0x04, 0x0A, 0xFB, 0x0E, 0x03, 0x72, 0x08, 0xB0, 0xB7, 0x28, 0x12, 0x8D, 0xF9, 0x0E, 0xC0, 0xE0,
  0x37, 0x10, 0xDB, 0x05, 0x71, 0x0C, 0xFA, 0x82, 0xB5, 0x07, 0xC0, 0xE0, 0x36, 0x04, 0xB0, 0xE7,
  0x2F, 0x81, 0xD7, 0x14, 0x07, 0xC0, 0xE0, 0x35, 0x0A, 0xB0, 0x97, 0x2F, 0x90, 0xA0, 0x45, 0x07,
  0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xA0, 0x37, 0x20, 0x60, 0xCF, 0x98, 0x1D, 0x71, 0x30, 0x7C, 0x0E,
  0x03, 0x48, 0x13, 0xED, 0x75, 0x81, 0x39, 0xEF, 0x90, 0xA0, 0x42, 0x07, 0xC0, 0xE0, 0x34, 0x03,
  0x07, 0x77, 0x10, 0x60, 0xCF, 0x98, 0x2D, 0x71, 0x7C, 0x0E, 0x03, 0x77, 0x71, 0x81, 0x39, 0xEF,
  0x81, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x73, 0x06, 0x0C, 0xD0, 0xD2, 0x07, 0xC0, 0xE0, 0x37, 0x77,
  0x40, 0x30, 0x9C, 0x04, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x75, 0x09, 0xB0, 0xA3, 0x07, 0xC0, 0xE0,
  0x37, 0x77, 0x40, 0x3C, 0x01, 0x30, 0xEC, 0x0E, 0x03, 0x77, 0x74, 0x0C, 0xB0, 0x72, 0x05, 0xE0,
  0xE0, 0x37, 0x77, 0x30, 0x6B, 0x0D, 0x20, 0xBF, 0x0E, 0x03, 0x77, 0x73, 0x0E, 0xB0, 0x40, 0x1C,
  0x09, 0xC0, 0xE0, 0x37, 0x77, 0x20, 0x9B, 0x0A, 0x07, 0xB8, 0x1B, 0x07, 0xC0, 0xE0, 0x37, 0x77,
  0x10, 0x3C, 0x0D, 0xB0, 0x62, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x10, 0xCF, 0x01, 0x30, 0x7C, 0x0E,
  0x03, 0x77, 0x70, 0x6E, 0x0A, 0x50, 0x7C, 0x0E, 0x03, 0x77, 0x70, 0xED, 0x04, 0x60, 0x7C, 0x0E,
  0x03, 0x77, 0x60, 0x9C, 0x0D, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x75, 0x03, 0xC0, 0x87, 0x20, 0x7C,
  0x0E, 0x77, 0x60, 0xCB, 0x02, 0x73, 0x07, 0xB0, 0x47, 0x76, 0x06, 0xA0, 0xC7, 0x58, 0x17, 0xF4,
  0x80, 0xC2, 0x00, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_near_me_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 44, 42), Box(0, 0, 47, 47),
      ic_outlined_48_maps_near_me_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_near_me 48x48, 4-bit Alpha,  RLE, 259 bytes.
static const unsigned char ic_outlined_48_maps_near_me_data[] PROGMEM = {
  0x77, 0x77, 0x60, 0x50, 0x97, 0x77, 0x73, 0x83, 0x18, 0xEF, 0x57, 0x77, 0x71, 0x04, 0x0A, 0xB0,
  0xE7, 0x77, 0x68, 0x11, 0x6D, 0xD0, 0x87, 0x77, 0x48, 0x12, 0x9E, 0xF0, 0x17, 0x77, 0x20, 0x50,
  0xBF, 0xA0, 0xA7, 0x77, 0x81, 0x18, 0xEF, 0xC0, 0x47, 0x75, 0x04, 0x0A, 0xF9, 0x0D, 0x0C, 0xB0,
  0xD7, 0x74, 0x06, 0x0D, 0xF9, 0x82, 0xB4, 0x0D, 0xB0, 0x67, 0x71, 0x81, 0x29, 0xEF, 0x81, 0xE8,
  0x22, 0x04, 0xB0, 0xE0, 0x17, 0x60, 0x50, 0xBF, 0x90, 0xC0, 0x65, 0x0B, 0xB0, 0x97, 0x48, 0x11,
  0x7D, 0xF9, 0x0A, 0x03, 0x60, 0x2C, 0x02, 0x72, 0x03, 0x0A, 0xF9, 0x81, 0xD7, 0x17, 0x10, 0x8B,
  0x0B, 0x71, 0x06, 0x0C, 0xF9, 0x0B, 0x05, 0x74, 0x0E, 0xB0, 0x55, 0x81, 0x28, 0xEF, 0x81, 0xE8,
  0x27, 0x50, 0x6B, 0x0D, 0x6F, 0x90, 0xC0, 0x67, 0x71, 0x0C, 0xB0, 0x76, 0xF9, 0x81, 0xE9, 0x37,
  0x60, 0x3C, 0x01, 0x68, 0x13, 0x9E, 0xF9, 0x81, 0xC6, 0x17, 0x30, 0xAB, 0x0A, 0x73, 0x05, 0x0B,
  0xFA, 0x0A, 0x04, 0x70, 0x1C, 0x03, 0x75, 0x81, 0x28, 0xEF, 0x90, 0xC6, 0x07, 0xB0, 0xC7, 0x72,
  0x04, 0x0A, 0xF0, 0x45, 0x0D, 0xB0, 0x67, 0x74, 0x81, 0x17, 0xDC, 0x0A, 0x40, 0x5B, 0x0E, 0x77,
  0x71, 0x05, 0xC0, 0x13, 0x0B, 0xB0, 0x87, 0x77, 0x20, 0xDB, 0x06, 0x20, 0x2C, 0x02, 0x77, 0x72,
  0x07, 0xB0, 0xC2, 0x09, 0xB0, 0xB7, 0x77, 0x30, 0x1C, 0x81, 0x30, 0xEB, 0x04, 0x77, 0x74, 0x0A,
  0xB0, 0x90, 0x6B, 0x0D, 0x77, 0x75, 0x05, 0xB0, 0xE0, 0xDB, 0x07, 0x77, 0x76, 0x0E, 0xF0, 0x17,
  0x77, 0x60, 0x8E, 0x09, 0x77, 0x77, 0x02, 0xE0, 0x37, 0x77, 0x71, 0x0C, 0xC0, 0xC7, 0x77, 0x72,
  0x06, 0xC0, 0x57, 0x77, 0x73, 0x0E, 0xA0, 0xE7, 0x77, 0x74, 0x09, 0xA0, 0x87, 0x77, 0x74, 0x03,
  0xA0, 0x27, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_near_me() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_near_me_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_nightlife 48x48, 4-bit Alpha,  RLE, 198 bytes.
static const unsigned char ic_outlined_48_maps_nightlife_data[] PROGMEM = {
  0x0A, 0xFF, 0xFD, 0x0A, 0x4F, 0xB0, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x14, 0xFB, 0x10, 0x5F, 0xFF,
  0xB0, 0x55, 0xFB, 0x20, 0xAF, 0xFF, 0x90, 0xA6, 0xFB, 0x20, 0x10, 0xEB, 0x05, 0x75, 0x05, 0xB0,
  0xE0, 0x16, 0xFB, 0x30, 0x5B, 0x0E, 0x01, 0x73, 0x01, 0x0E, 0xB0, 0x57, 0xFB, 0x40, 0xAB, 0x0B,
  0x73, 0x0B, 0xB0, 0xA7, 0x1C, 0x73, 0x01, 0x0E, 0xB0, 0x67, 0x10, 0x7B, 0x0E, 0x01, 0x71, 0xC7,
  0x40, 0x5F, 0xFA, 0x05, 0x72, 0xC7, 0x50, 0xAF, 0xF0, 0xA7, 0x3C, 0x75, 0x01, 0x0E, 0xFD, 0x0E,
  0x01, 0x73, 0xC7, 0x60, 0x5F, 0xD0, 0x57, 0x4C, 0x77, 0x0A, 0xFB, 0x0A, 0x75, 0xC7, 0x70, 0x10,
  0xEF, 0x90, 0xE0, 0x17, 0x5C, 0x77, 0x10, 0x5F, 0x90, 0x57, 0x6C, 0x77, 0x20, 0xAE, 0x0A, 0x77,
  0xC7, 0x72, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x7C, 0x77, 0x30, 0x5C, 0x05, 0x77, 0x1C, 0x77, 0x4C,
  0x74, 0x83, 0x6C, 0xEE, 0xCC, 0x77, 0x4C, 0x72, 0x01, 0x0C, 0xFA, 0x77, 0x4C, 0x72, 0x0C, 0xFB,
  0x77, 0x4C, 0x71, 0x06, 0xFC, 0x77, 0x4C, 0x71, 0x0C, 0xFC, 0x77, 0x4C, 0x71, 0x0E, 0xFC, 0x77,
  0x4C, 0x71, 0x0E, 0xFB, 0x0E, 0x77, 0x4C, 0x71, 0x0C, 0xFB, 0x0C, 0x77, 0xFD, 0x40, 0x6F, 0xB0,
  0x67, 0x7F, 0xD5, 0x0C, 0xF9, 0x0C, 0x77, 0x1F, 0xD5, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x71, 0xFD,
  0x78, 0x46, 0xCE, 0xEC, 0x67, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_nightlife() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_nightlife_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_no_crash 48x48, 4-bit Alpha,  RLE, 257 bytes.
static const unsigned char ic_outlined_48_maps_no_crash_data[] PROGMEM = {
  0x77, 0x73, 0x06, 0x08, 0x77, 0x77, 0x50, 0x6A, 0x08, 0x77, 0x77, 0x30, 0x6C, 0x08, 0x77, 0x77,
  0x10, 0x6C, 0x0E, 0x03, 0x77, 0x71, 0x02, 0x05, 0x40, 0x6C, 0x0E, 0x03, 0x77, 0x71, 0x82, 0x2E,
  0xF6, 0x20, 0x6C, 0x0E, 0x03, 0x77, 0x71, 0x02, 0x0E, 0xB0, 0x06, 0xC0, 0xE0, 0x37, 0x77, 0x20,
  0x40, 0xEF, 0x90, 0xE0, 0x37, 0x77, 0x40, 0x40, 0xEE, 0x0E, 0x03, 0x77, 0x76, 0x04, 0x0E, 0xC0,
  0xE0, 0x37, 0x77, 0x71, 0x04, 0x0E, 0xA0, 0xE0, 0x37, 0x77, 0x73, 0x82, 0x4E, 0xE3, 0x77, 0x77,
  0x50, 0x40, 0x38, 0x09, 0xF6, 0x00, 0x80, 0xEF, 0xFF, 0x90, 0xE0, 0x87, 0x20, 0x8F, 0xFF, 0xD0,
  0x87, 0x10, 0xEF, 0xFF, 0xD0, 0xE7, 0x05, 0xFF, 0xFF, 0x05, 0x60, 0xAB, 0x08, 0x77, 0x60, 0x8B,
  0x0A, 0x50, 0x1C, 0x02, 0x77, 0x60, 0x3C, 0x01, 0x40, 0x6B, 0x0C, 0x77, 0x71, 0x0D, 0xB0, 0x64,
  0x0B, 0xB0, 0x77, 0x77, 0x10, 0x7B, 0x0B, 0x30, 0x1C, 0x02, 0x77, 0x71, 0x02, 0xC0, 0x12, 0x06,
  0xB0, 0xC7, 0x77, 0x30, 0xCB, 0x06, 0x20, 0xCF, 0xFF, 0xFC, 0x81, 0xC0, 0x2F, 0xFF, 0xFE, 0x02,
  0x07, 0xFF, 0xFF, 0xE0, 0x70, 0xCF, 0xFF, 0xFE, 0x0C, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x93,
  0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3F, 0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F,
  0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F, 0x92, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2F,
  0x92, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2F, 0x93, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8,
  0x3F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x78, 0x0A, 0xA6, 0xF7, 0x77, 0x3F, 0xD7, 0x77, 0x3E, 0x0D,
  0xC0, 0xD7, 0x77, 0x30, 0xDC, 0x81, 0xD4, 0xDA, 0x0D, 0x04, 0x77, 0x73, 0x04, 0x0D, 0xA0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_no_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 41, 47), Box(0, 0, 47, 47),
      ic_outlined_48_maps_no_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_no_meals 48x48, 4-bit Alpha,  RLE, 312 bytes.
static const unsigned char ic_outlined_48_maps_no_meals_data[] PROGMEM = {
  0x20, 0x20, 0x77, 0x2C, 0x4C, 0x75, 0x82, 0x5A, 0xDE, 0x38, 0x22, 0xEF, 0x77, 0x1C, 0x4C, 0x73,
  0x06, 0x0E, 0xC2, 0x02, 0x0E, 0xB0, 0x77, 0xC4, 0xC7, 0x10, 0x10, 0xBE, 0x20, 0x30, 0xEC, 0x07,
  0x6C, 0x4C, 0x70, 0x10, 0xCF, 0x30, 0x30, 0xEC, 0x07, 0x50, 0xCB, 0x4C, 0x70, 0xAF, 0x94, 0x03,
  0x0E, 0xC0, 0x75, 0x0C, 0xA4, 0xC6, 0x04, 0xFA, 0x50, 0x30, 0xEC, 0x07, 0x50, 0xC9, 0x4C, 0x60,
  0xBF, 0xA6, 0x03, 0xD0, 0x75, 0x0C, 0x4C, 0x60, 0xEF, 0xA7, 0xE0, 0x77, 0x2C, 0x6F, 0xB7, 0xF0,
  0x77, 0x1C, 0x6F, 0xB7, 0xF9, 0x07, 0x7C, 0x6F, 0xB7, 0xC0, 0xEC, 0x07, 0x6C, 0x6F, 0xB7, 0xC0,
  0x30, 0xEC, 0x07, 0x50, 0xCB, 0x6F, 0xB7, 0xC1, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xA6, 0xFB, 0x70,
  0xEF, 0xC0, 0x75, 0x0C, 0x0E, 0x6F, 0xB7, 0x0C, 0xFD, 0x07, 0x50, 0x96, 0xFB, 0x70, 0x8F, 0xE0,
  0x77, 0x4F, 0xB7, 0x02, 0xFF, 0x07, 0x73, 0xFB, 0x71, 0x09, 0xFF, 0x07, 0x72, 0xFB, 0x72, 0x0B,
  0xFF, 0x07, 0x71, 0xFB, 0x73, 0x09, 0xFF, 0x07, 0x7F, 0xB7, 0x48, 0x22, 0x8C, 0xED, 0x0C, 0x0E,
  0xC0, 0x76, 0xFB, 0x77, 0x1C, 0x20, 0x30, 0xEC, 0x07, 0x5F, 0xB7, 0x71, 0xC3, 0x03, 0x0E, 0xC0,
  0x74, 0xFB, 0x77, 0x1C, 0x40, 0x30, 0xEC, 0x07, 0x72, 0xC7, 0x71, 0xC5, 0x03, 0x0E, 0xC0, 0x77,
  0x1C, 0x77, 0x1C, 0x60, 0x30, 0xEC, 0x07, 0x7C, 0x77, 0x1C, 0x70, 0x30, 0xEC, 0x07, 0x6C, 0x77,
  0x1C, 0x71, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB7, 0x71, 0xC7, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xCA,
  0x77, 0x1C, 0x73, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0x97, 0x71, 0xC7, 0x40, 0x30, 0xEC, 0x07, 0x50,
  0xC7, 0x71, 0xC7, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x6C, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x75, 0xC7,
  0x70, 0x30, 0xEC, 0x07, 0x77, 0x4C, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x3C, 0x77, 0x20, 0x30,
  0xEC, 0x07, 0x77, 0x2C, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x1C, 0x77, 0x40, 0x30, 0xEC, 0x07,
  0x77, 0xC7, 0x75, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x10, 0x03, 0x0E, 0xA0, 0xE0, 0x28, 0x0C, 0x20,
  0x82, 0x3E, 0xE2, 0x80, 0xC4, 0x00, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_no_meals() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 43, 46), Box(0, 0, 47, 47),
      ic_outlined_48_maps_no_meals_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_not_listed_location 48x48, 4-bit Alpha,  RLE, 343 bytes.
static const unsigned char ic_outlined_48_maps_not_listed_location_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x10, 0x8F, 0xFA, 0x08, 0x75, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x30, 0xED, 0x82, 0xD8,
  0x42, 0x28, 0x22, 0x48, 0xDD, 0x0E, 0x03, 0x70, 0x10, 0xEC, 0x0D, 0x05, 0x73, 0x05, 0x0D, 0xC0,
  0xE0, 0x16, 0x0C, 0xC0, 0x97, 0x70, 0x9C, 0x0C, 0x50, 0x7C, 0x07, 0x77, 0x20, 0x7C, 0x07, 0x30,
  0x10, 0xEB, 0x0A, 0x68, 0x56, 0xCE, 0xEC, 0x81, 0x50, 0xAB, 0x0E, 0x01, 0x20, 0x9B, 0x0D, 0x50,
  0x10, 0xCE, 0x0E, 0x04, 0x50, 0xDB, 0x09, 0x20, 0xEB, 0x06, 0x50, 0xCF, 0x90, 0xE0, 0x24, 0x06,
  0xB8, 0x1E, 0x03, 0xB0, 0xD5, 0x06, 0xB8, 0x2D, 0x87, 0xDB, 0x09, 0x50, 0xDB, 0x03, 0x08, 0xB0,
  0x95, 0x0C, 0xA0, 0xC4, 0x0D, 0xA0, 0xD5, 0x09, 0xB0, 0x80, 0xBB, 0x05, 0x50, 0xEA, 0x06, 0x40,
  0x9B, 0x50, 0x5B, 0x0B, 0x0C, 0xB0, 0x27, 0x60, 0xCA, 0x0D, 0x50, 0x2B, 0x0D, 0x0E, 0xB0, 0x17,
  0x50, 0x8B, 0x07, 0x50, 0x1B, 0x0E, 0xC7, 0x50, 0x8B, 0x0D, 0x7C, 0x0D, 0xB0, 0x17, 0x30, 0x7B,
  0x0E, 0x02, 0x60, 0x1B, 0x0D, 0x0C, 0xB0, 0x47, 0x20, 0x3B, 0x0E, 0x02, 0x70, 0x4B, 0x0C, 0x09,
  0xB0, 0x87, 0x20, 0x8B, 0x05, 0x71, 0x08, 0xB0, 0x90, 0x4B, 0x0D, 0x72, 0x0B, 0xB7, 0x20, 0xDB,
  0x81, 0x40, 0xEB, 0x04, 0x71, 0x0B, 0xA0, 0xE7, 0x10, 0x4B, 0x0E, 0x20, 0x9B, 0x0C, 0x77, 0x60,
  0xCB, 0x09, 0x20, 0x2C, 0x05, 0x77, 0x40, 0x5C, 0x02, 0x30, 0xAB, 0x0D, 0x01, 0x68, 0x24, 0xDD,
  0x46, 0x01, 0x0D, 0xB0, 0xA4, 0x01, 0x0E, 0xB0, 0xA6, 0x0D, 0xA0, 0xD6, 0x0A, 0xB0, 0xE0, 0x15,
  0x07, 0xC0, 0x55, 0x0D, 0xA0, 0xD5, 0x05, 0xC0, 0x77, 0x0C, 0xB0, 0xE0, 0x34, 0x82, 0x4D, 0xD4,
  0x40, 0x30, 0xEB, 0x0C, 0x71, 0x02, 0x0E, 0xB0, 0xD0, 0x17, 0x30, 0x10, 0xDB, 0x0E, 0x02, 0x72,
  0x05, 0xC0, 0xC7, 0x30, 0xCC, 0x05, 0x74, 0x08, 0xC0, 0xB7, 0x10, 0xBC, 0x08, 0x76, 0x0A, 0xC0,
  0xA6, 0x0A, 0xC0, 0xA7, 0x71, 0x0B, 0xC0, 0xA4, 0x0A, 0xC0, 0xB7, 0x72, 0x01, 0x0C, 0xC0, 0xB2,
  0x0B, 0xC0, 0xC0, 0x17, 0x73, 0x01, 0x0C, 0xC0, 0x0B, 0xC0, 0xC0, 0x17, 0x75, 0x01, 0x0C, 0xF9,
  0x0C, 0x01, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x73, 0x0B, 0xC0, 0xB7, 0x77, 0x60, 0xAA,
  0x0A, 0x77, 0x77, 0x10, 0x08, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_not_listed_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_not_listed_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_no_transfer 48x48, 4-bit Alpha,  RLE, 303 bytes.
static const unsigned char ic_outlined_48_maps_no_transfer_data[] PROGMEM = {
  0x74, 0x85, 0x25, 0x8A, 0xBD, 0xDE, 0x85, 0xED, 0xBA, 0x86, 0x27, 0x40, 0x25, 0x81, 0x18, 0xDF,
  0xFE, 0x81, 0xD8, 0x17, 0x81, 0x4F, 0x75, 0x0C, 0xFF, 0xFA, 0x0E, 0x06, 0x50, 0x4B, 0x07, 0x50,
  0xCF, 0xFF, 0xB0, 0x74, 0x0E, 0xC0, 0x75, 0x85, 0xBB, 0x85, 0x32, 0x16, 0x85, 0x11, 0x35, 0x7B,
  0xED, 0x02, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x73, 0x06, 0x0E, 0xB0, 0x94, 0x03, 0x0E, 0xC0, 0x75,
  0x0C, 0xFF, 0xF9, 0x0D, 0x50, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFF, 0x0E, 0x60, 0x30, 0xEC, 0x07,
  0x50, 0xCF, 0xFF, 0x70, 0x3D, 0x07, 0x50, 0xCF, 0xFE, 0x71, 0xE0, 0x77, 0x77, 0xC7, 0x1F, 0x07,
  0x77, 0x6C, 0x71, 0xF9, 0x07, 0x77, 0x5C, 0x71, 0xC0, 0xEC, 0x07, 0x77, 0x4C, 0x71, 0xC0, 0x30,
  0xEC, 0x07, 0x77, 0x3C, 0x71, 0xC1, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0xC7, 0x1F, 0xD0, 0x75, 0x0C,
  0xFE, 0x71, 0xFE, 0x07, 0x50, 0xCF, 0xD7, 0x1F, 0xF0, 0x75, 0x0C, 0xFC, 0x71, 0xFF, 0x90, 0x75,
  0x0C, 0xFB, 0x71, 0xC6, 0x03, 0x0E, 0xC0, 0x77, 0x4C, 0x71, 0xC7, 0x03, 0x0E, 0xC0, 0x77, 0x3C,
  0x71, 0xC3, 0x85, 0x8D, 0xD8, 0x03, 0xEC, 0x07, 0x72, 0xC7, 0x1C, 0x20, 0x8C, 0x82, 0x80, 0x3E,
  0xC0, 0x77, 0x1C, 0x71, 0xC2, 0x0D, 0xC0, 0xD2, 0x03, 0x0E, 0xC0, 0x77, 0xC7, 0x1C, 0x20, 0xDC,
  0x0D, 0x30, 0x30, 0xEC, 0x07, 0x6C, 0x71, 0xC2, 0x08, 0xC0, 0x84, 0x03, 0x0E, 0xC0, 0x75, 0x0C,
  0xB7, 0x1C, 0x38, 0x28, 0xDD, 0x86, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xA7, 0x10, 0xEB, 0x02, 0x76,
  0x03, 0x0E, 0xC0, 0x75, 0x0C, 0x0E, 0x71, 0x0C, 0xB0, 0xB7, 0x70, 0x30, 0xEC, 0x07, 0x50, 0x87,
  0x10, 0x6F, 0xFF, 0xC0, 0x77, 0x70, 0xCF, 0xFF, 0xC0, 0x77, 0x60, 0x1F, 0xFF, 0xD0, 0x77, 0x6F,
  0xFF, 0xE0, 0x77, 0x5E, 0x77, 0x2E, 0x07, 0x74, 0xE7, 0x72, 0xF0, 0x77, 0x30, 0xDC, 0x0D, 0x77,
  0x20, 0xDF, 0x07, 0x72, 0x04, 0x0D, 0xA0, 0xD0, 0x47, 0x72, 0x04, 0x0D, 0xF0, 0x77, 0x77, 0x76,
  0x03, 0x0E, 0xC0, 0x27, 0x77, 0x76, 0x03, 0x0E, 0xA0, 0x48, 0x0C, 0x00, 0x81, 0x3E, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_no_transfer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_maps_no_transfer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_park 48x48, 4-bit Alpha,  RLE, 256 bytes.
static const unsigned char ic_outlined_48_maps_park_data[] PROGMEM = {
  0x77, 0x30, 0x05, 0x77, 0x77, 0x58, 0x21, 0xEE, 0x17, 0x77, 0x74, 0x0B, 0xA0, 0xB7, 0x77, 0x73,
  0x06, 0xC0, 0x77, 0x77, 0x71, 0x02, 0x0E, 0xD0, 0x27, 0x77, 0x70, 0xCE, 0x0C, 0x77, 0x76, 0x08,
  0xF9, 0x08, 0x77, 0x74, 0x03, 0xC0, 0xA0, 0x9C, 0x03, 0x77, 0x73, 0x0D, 0xB8, 0x2D, 0x10, 0xDB,
  0x0D, 0x01, 0x77, 0x71, 0x09, 0xC0, 0x42, 0x03, 0xC0, 0xA7, 0x77, 0x04, 0xC0, 0x94, 0x08, 0xC0,
  0x57, 0x75, 0x01, 0x0E, 0xB0, 0xD6, 0x0C, 0xB0, 0xE0, 0x17, 0x74, 0x0A, 0xC0, 0x36, 0x02, 0x0E,
  0xB0, 0xB7, 0x73, 0x05, 0xC0, 0x77, 0x10, 0x6C, 0x07, 0x77, 0x10, 0x20, 0xEB, 0x0C, 0x73, 0x0B,
  0xC0, 0x27, 0x70, 0xBB, 0x0E, 0x02, 0x73, 0x01, 0x0E, 0xB0, 0xC7, 0x60, 0x7F, 0x0E, 0x01, 0x40,
  0x2F, 0x90, 0x87, 0x40, 0x2F, 0x90, 0x66, 0x07, 0xF9, 0x03, 0x73, 0x0C, 0xF0, 0xB7, 0x10, 0xCF,
  0x0D, 0x01, 0x71, 0x08, 0xF0, 0xE0, 0x27, 0x10, 0x2F, 0x90, 0xA7, 0x40, 0x5C, 0x07, 0x73, 0x07,
  0xC0, 0x57, 0x60, 0x10, 0xEB, 0x0C, 0x75, 0x0C, 0xB0, 0xE0, 0x17, 0x50, 0x9C, 0x02, 0x75, 0x02,
  0xC0, 0xA7, 0x40, 0x4C, 0x07, 0x77, 0x07, 0xC0, 0x57, 0x30, 0xDB, 0x0C, 0x77, 0x20, 0xCB, 0x0E,
  0x01, 0x71, 0x08, 0xC0, 0x37, 0x72, 0x02, 0xC0, 0xA7, 0x03, 0xC0, 0x87, 0x74, 0x07, 0xC0, 0x56,
  0x0D, 0xB0, 0xD7, 0x76, 0x0C, 0xB0, 0xE0, 0x14, 0x08, 0xFF, 0xFF, 0xA0, 0xA3, 0x03, 0xFF, 0xFF,
  0xC0, 0x52, 0x0C, 0xFF, 0xFF, 0xC8, 0x1E, 0x17, 0xFF, 0xFF, 0xE0, 0xA7, 0x70, 0xEE, 0x0E, 0x77,
  0x77, 0x0E, 0xE0, 0xE7, 0x77, 0x70, 0xEE, 0x0E, 0x77, 0x77, 0x0E, 0xE0, 0xE7, 0x77, 0x70, 0xEE,
  0x0E, 0x77, 0x77, 0x0E, 0xE0, 0xE7, 0x77, 0x70, 0xEE, 0x0E, 0x77, 0x77, 0x0E, 0xE0, 0xE7, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_park() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_park_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_pedal_bike 48x48, 4-bit Alpha,  RLE, 325 bytes.
static const unsigned char ic_outlined_48_maps_pedal_bike_data[] PROGMEM = {
  0x77, 0x73, 0xD8, 0x1E, 0xB3, 0x80, 0xC4, 0x0F, 0x90, 0x48, 0x0C, 0x30, 0xF9, 0x0D, 0x80, 0xC3,
  0x0F, 0xA0, 0x48, 0x0C, 0x70, 0x09, 0xB0, 0x98, 0x0C, 0x70, 0x03, 0xB0, 0xE7, 0x77, 0x7F, 0xB6,
  0x0D, 0xB0, 0x57, 0x77, 0x6F, 0xB6, 0x08, 0xB0, 0xB7, 0x77, 0x6F, 0xB6, 0x02, 0xC0, 0x17, 0x77,
  0x5F, 0xB7, 0x0C, 0xB0, 0x77, 0x77, 0x71, 0x04, 0xB0, 0xE7, 0x20, 0x6B, 0x0C, 0x77, 0x77, 0x20,
  0xEB, 0x04, 0x71, 0x01, 0xC0, 0x27, 0x73, 0x86, 0x49, 0xDD, 0xFD, 0xA5, 0x40, 0x9F, 0xFE, 0x81,
  0xDA, 0x57, 0x30, 0x30, 0xCF, 0x90, 0xD0, 0x52, 0x03, 0xFF, 0xFA, 0x0D, 0x05, 0x70, 0x7F, 0xD0,
  0x92, 0x0D, 0xFF, 0xFB, 0x09, 0x50, 0x7F, 0xF8, 0x19, 0x07, 0xFF, 0xFC, 0x09, 0x30, 0x4D, 0x84,
  0x83, 0x01, 0x39, 0xD0, 0x50, 0x2C, 0x01, 0x40, 0x4F, 0x83, 0xE1, 0x38, 0xEC, 0x05, 0x20, 0xCB,
  0x0D, 0x02, 0x60, 0x20, 0xEB, 0x81, 0xD0, 0xBB, 0x07, 0x40, 0xDB, 0x00, 0xDB, 0x05, 0x20, 0x20,
  0xDB, 0x81, 0xD0, 0x4B, 0x0E, 0x02, 0x71, 0x03, 0xC0, 0x50, 0x6B, 0x0D, 0x30, 0x5C, 0x02, 0x07,
  0xB0, 0xB3, 0x02, 0x0E, 0xB0, 0x50, 0x9B, 0x08, 0x73, 0x09, 0xB0, 0xA0, 0x1C, 0x03, 0x20, 0x9B,
  0x81, 0x80, 0x2C, 0x01, 0x30, 0x8B, 0x0A, 0x0C, 0xB0, 0x35, 0xFF, 0xF9, 0x03, 0x20, 0xCB, 0x07,
  0x30, 0x2B, 0x0D, 0x0E, 0xB6, 0xFF, 0xF9, 0x30, 0x6A, 0x0C, 0x05, 0x4B, 0x00, 0xEB, 0x6F, 0xFF,
  0x93, 0x81, 0x18, 0x26, 0xB0, 0xE0, 0xDB, 0x03, 0x5F, 0xFF, 0x90, 0x37, 0x30, 0x3B, 0x0C, 0x0A,
  0xB0, 0x87, 0x30, 0x9B, 0x0A, 0x71, 0x0A, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0x05, 0xB0, 0xE0, 0x27,
  0x10, 0x3C, 0x05, 0x71, 0x05, 0xB0, 0xE0, 0x27, 0x10, 0x20, 0xEB, 0x81, 0x40, 0xDB, 0x0D, 0x02,
  0x60, 0x20, 0xEB, 0x0D, 0x73, 0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xC2, 0x05, 0xD8, 0x48,
  0x30, 0x13, 0x9D, 0x05, 0x73, 0x05, 0xD0, 0x80, 0x32, 0x03, 0x08, 0xD0, 0x33, 0x09, 0xFF, 0x09,
  0x75, 0x09, 0xFF, 0x06, 0x50, 0x9F, 0xD0, 0x97, 0x70, 0x9F, 0xD0, 0x77, 0x05, 0x0D, 0xF9, 0x0D,
  0x05, 0x77, 0x20, 0x50, 0xDF, 0x90, 0xC0, 0x37, 0x38, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x76, 0x86,
  0x5A, 0xDF, 0xDD, 0x94, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_pedal_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_pedal_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_person_pin_circle 48x48, 4-bit Alpha,  RLE, 339 bytes.
static const unsigned char ic_outlined_48_maps_person_pin_circle_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x10, 0x8F, 0xFA, 0x08, 0x75, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x30, 0xED, 0x82, 0xD8,
  0x42, 0x28, 0x22, 0x48, 0xDD, 0x0E, 0x03, 0x70, 0x10, 0xEC, 0x0D, 0x05, 0x73, 0x05, 0x0D, 0xC0,
  0xE0, 0x16, 0x0C, 0xC0, 0x97, 0x70, 0x9C, 0x0C, 0x50, 0x7C, 0x07, 0x77, 0x20, 0x7C, 0x07, 0x30,
  0x10, 0xEB, 0x0A, 0x68, 0x41, 0xAD, 0xDA, 0x16, 0x0A, 0xB0, 0xE0, 0x12, 0x09, 0xB0, 0xD6, 0x01,
  0x0E, 0xC0, 0xE0, 0x16, 0x0D, 0xB0, 0x92, 0x0E, 0xB0, 0x66, 0x0A, 0xE0, 0xA6, 0x06, 0xB8, 0x1E,
  0x03, 0xB0, 0xD7, 0x0D, 0xE0, 0xD7, 0x0D, 0xB0, 0x30, 0x8B, 0x09, 0x70, 0xDE, 0x0D, 0x70, 0x9B,
  0x08, 0x0B, 0xB0, 0x57, 0x0A, 0xE0, 0xA7, 0x05, 0xB0, 0xB0, 0xCB, 0x02, 0x70, 0x10, 0xEC, 0x0E,
  0x01, 0x70, 0x2B, 0x0D, 0x0E, 0xB0, 0x17, 0x18, 0x41, 0xAD, 0xDA, 0x17, 0x10, 0x1B, 0x0E, 0xC7,
  0x77, 0x3C, 0x0D, 0xB0, 0x17, 0x77, 0x10, 0x1B, 0x0D, 0x0C, 0xB0, 0x46, 0x89, 0x02, 0x6A, 0xDF,
  0xED, 0xA6, 0x26, 0x04, 0xB0, 0xC0, 0x9B, 0x08, 0x40, 0x30, 0xBF, 0xB0, 0xB0, 0x34, 0x08, 0xB0,
  0x90, 0x4B, 0x0D, 0x30, 0x4F, 0xF0, 0x43, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x42, 0x0D, 0xFF, 0x0D,
  0x20, 0x4B, 0x0E, 0x20, 0x9B, 0x0C, 0x20, 0xBF, 0xF0, 0xB2, 0x0C, 0xB0, 0x92, 0x02, 0xC0, 0x52,
  0x0A, 0xFD, 0x0A, 0x20, 0x5C, 0x02, 0x30, 0xAB, 0x0D, 0x01, 0x20, 0x50, 0xEF, 0x90, 0xE0, 0x52,
  0x01, 0x0D, 0xB0, 0xA4, 0x01, 0x0E, 0xB0, 0xA4, 0x86, 0x5A, 0xCE, 0xEC, 0xA5, 0x40, 0xAB, 0x0E,
  0x01, 0x50, 0x7C, 0x05, 0x77, 0x05, 0xC0, 0x77, 0x0C, 0xB0, 0xE0, 0x37, 0x50, 0x30, 0xEB, 0x0C,
  0x71, 0x02, 0x0E, 0xB0, 0xD0, 0x17, 0x30, 0x10, 0xDB, 0x0E, 0x02, 0x72, 0x05, 0xC0, 0xC7, 0x30,
  0xCC, 0x05, 0x74, 0x08, 0xC0, 0xB7, 0x10, 0xBC, 0x08, 0x76, 0x0A, 0xC0, 0xA6, 0x0A, 0xC0, 0xA7,
  0x71, 0x0B, 0xC0, 0xA4, 0x0A, 0xC0, 0xB7, 0x72, 0x01, 0x0C, 0xC0, 0xB2, 0x0B, 0xC0, 0xC0, 0x17,
  0x73, 0x01, 0x0C, 0xC0, 0x0B, 0xC0, 0xC0, 0x17, 0x75, 0x01, 0x0C, 0xF9, 0x0C, 0x01, 0x77, 0x70,
  0x10, 0xCE, 0x0C, 0x01, 0x77, 0x73, 0x0B, 0xC0, 0xB7, 0x77, 0x60, 0xAA, 0x0A, 0x77, 0x77, 0x10,
  0x08, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_person_pin_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_person_pin_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_person_pin 48x48, 4-bit Alpha,  RLE, 269 bytes.
static const unsigned char ic_outlined_48_maps_person_pin_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x48, 0x46, 0xCE,
  0xEC, 0x67, 0x4F, 0x97, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x72, 0xF9, 0x72, 0x0C, 0xF9, 0x0C, 0x72,
  0xF9, 0x71, 0x06, 0xFB, 0x06, 0x71, 0xF9, 0x71, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x71, 0xF9,
  0x71, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x1F, 0x97, 0x10, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x71,
  0xF9, 0x71, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x71, 0xF9, 0x71, 0x06, 0xFB, 0x06, 0x71, 0xF9,
  0x72, 0x0C, 0xF9, 0x0C, 0x72, 0xF9, 0x72, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x2F, 0x97, 0x48, 0x46,
  0xCE, 0xEC, 0x67, 0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x18, 0x31, 0x59, 0xBD, 0xA8,
  0x3D, 0xB9, 0x51, 0x71, 0xF9, 0x60, 0x40, 0xAF, 0xD0, 0xA0, 0x46, 0xF9, 0x40, 0x20, 0xBF, 0xFA,
  0x0B, 0x02, 0x4F, 0x93, 0x04, 0x0E, 0xFF, 0xC0, 0xE0, 0x43, 0xF9, 0x20, 0x10, 0xED, 0x82, 0xC8,
  0x41, 0x28, 0x21, 0x48, 0xCD, 0x0E, 0x01, 0x2F, 0x92, 0x0A, 0xC0, 0xA0, 0x37, 0x30, 0x30, 0xAC,
  0x09, 0x2F, 0x92, 0x0E, 0xFF, 0xF9, 0x0D, 0x2F, 0x92, 0xFF, 0xFB, 0x2F, 0x92, 0xFF, 0xFB, 0x2F,
  0x92, 0xFF, 0xFB, 0x2F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C, 0x0D, 0xFD, 0x0E, 0x03, 0x60, 0x30,
  0xEF, 0xD0, 0xD0, 0xAF, 0xE0, 0xE0, 0x34, 0x03, 0x0E, 0xFE, 0x81, 0xA1, 0xEF, 0xE0, 0xE0, 0x32,
  0x03, 0x0E, 0xFE, 0x84, 0xE1, 0x01, 0xAD, 0xFD, 0x82, 0xE3, 0x3E, 0xFD, 0x81, 0xDA, 0x17, 0x60,
  0x7C, 0x00, 0xEC, 0x07, 0x77, 0x74, 0x07, 0xF9, 0x07, 0x77, 0x76, 0x07, 0xE0, 0x77, 0x77, 0x71,
  0x07, 0xC0, 0x77, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x75, 0x00, 0x77, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_person_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_person_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_pest_control 48x48, 4-bit Alpha,  RLE, 301 bytes.
static const unsigned char ic_outlined_48_maps_pest_control_data[] PROGMEM = {
  0x73, 0x02, 0x77, 0x02, 0x77, 0x58, 0x13, 0xEB, 0x75, 0x81, 0xBE, 0x37, 0x73, 0x03, 0x0E, 0xA0,
  0xB7, 0x30, 0xBA, 0x0E, 0x03, 0x77, 0x20, 0xBC, 0x82, 0xB3, 0x8C, 0xA8, 0x2C, 0x83, 0xBC, 0x0B,
  0x77, 0x30, 0xCF, 0xFA, 0x0C, 0x77, 0x50, 0xCF, 0xF0, 0xC7, 0x77, 0x0D, 0xFD, 0x0D, 0x77, 0x70,
  0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x27, 0x76, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87,
  0x76, 0x0C, 0xB8, 0x6A, 0x9D, 0xEE, 0xD9, 0xAB, 0x0C, 0x77, 0x60, 0xEF, 0xF0, 0xE7, 0x76, 0x0E,
  0xFF, 0x0E, 0x76, 0x07, 0x02, 0x40, 0x10, 0xEF, 0xF0, 0xE0, 0x14, 0x02, 0x07, 0x50, 0x4A, 0x08,
  0x30, 0xBC, 0x86, 0xE8, 0x31, 0x13, 0x8E, 0xC0, 0xB3, 0x08, 0xA0, 0x44, 0x0D, 0xB8, 0x1E, 0x57,
  0xC0, 0xB0, 0x16, 0x01, 0x0B, 0xC8, 0x17, 0x5D, 0xB0, 0xD3, 0x05, 0xFB, 0x0B, 0x73, 0x0B, 0xFB,
  0x05, 0x30, 0x50, 0xDF, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xF0, 0xD0, 0x56, 0x07, 0x0E, 0xD0, 0x54,
  0xC4, 0x05, 0xE0, 0x77, 0x20, 0x10, 0xBB, 0x0D, 0x5C, 0x50, 0xDB, 0x0B, 0x01, 0x74, 0x08, 0xB0,
  0x85, 0xC5, 0x08, 0xB0, 0x87, 0x50, 0xBB, 0x04, 0x5C, 0x50, 0x4B, 0x0B, 0x6F, 0xB0, 0x15, 0xC5,
  0x01, 0xFF, 0xE6, 0xC6, 0xFF, 0xE6, 0xC6, 0xFF, 0xE0, 0x15, 0xC5, 0x01, 0xFB, 0x60, 0xBB, 0x04,
  0x5C, 0x50, 0x4B, 0x0B, 0x75, 0x08, 0xB0, 0x85, 0xC5, 0x08, 0xB0, 0x87, 0x40, 0x20, 0xBB, 0x0D,
  0x5C, 0x50, 0xDB, 0x0B, 0x01, 0x72, 0x08, 0xE0, 0x54, 0xC4, 0x05, 0xD0, 0xE0, 0x76, 0x05, 0x0E,
  0xF0, 0xD0, 0x17, 0x30, 0x10, 0xDF, 0x0D, 0x05, 0x30, 0x5F, 0xB0, 0xB7, 0x30, 0xBF, 0xB0, 0x53,
  0x0C, 0xB8, 0x1D, 0x57, 0xC0, 0xB0, 0x16, 0x01, 0x0B, 0xC8, 0x17, 0x5E, 0xB0, 0xD4, 0x82, 0x4F,
  0xE7, 0x30, 0xBC, 0x86, 0xE8, 0x31, 0x13, 0x8E, 0xC0, 0xB3, 0x08, 0xA0, 0x45, 0x06, 0x01, 0x40,
  0x10, 0xCF, 0xF0, 0xC0, 0x14, 0x02, 0x07, 0x76, 0x01, 0x0B, 0xFD, 0x0B, 0x01, 0x77, 0x71, 0x06,
  0x0E, 0xF9, 0x0E, 0x06, 0x77, 0x75, 0x81, 0x5A, 0xDA, 0x81, 0xDA, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_pest_control() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 5, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_pest_control_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_pest_control_rodent 48x48, 4-bit Alpha,  RLE, 317 bytes.
static const unsigned char ic_outlined_48_maps_pest_control_rodent_data[] PROGMEM = {
  0x73, 0x04, 0x0D, 0xB8, 0x1E, 0xB4, 0x77, 0x77, 0x40, 0xDF, 0x08, 0x77, 0x77, 0x30, 0xDF, 0x90,
  0x47, 0x77, 0x72, 0x04, 0x0D, 0xF0, 0xB7, 0x77, 0x77, 0x03, 0xB0, 0xE7, 0x77, 0x77, 0x03, 0xB0,
  0xE7, 0x77, 0x58, 0x25, 0x9D, 0xEF, 0xA0, 0xB7, 0x77, 0x30, 0x40, 0xDF, 0xE0, 0x47, 0x77, 0x20,
  0x8F, 0xF0, 0x87, 0x77, 0x20, 0x8F, 0xD8, 0x1E, 0xB4, 0x77, 0x72, 0x04, 0xD0, 0x80, 0x37, 0x77,
  0x74, 0x0D, 0xB0, 0xD0, 0x27, 0x77, 0x75, 0x05, 0xC0, 0x27, 0x28, 0x23, 0x8B, 0xDA, 0x89, 0x0D,
  0xA6, 0x8C, 0xED, 0xC8, 0x37, 0x20, 0x9B, 0x08, 0x71, 0x02, 0x0B, 0xFF, 0xA0, 0xA0, 0x27, 0x0D,
  0xB0, 0x37, 0x06, 0xFF, 0xD0, 0xE0, 0x26, 0x0E, 0xB7, 0x07, 0xFF, 0xF0, 0xE0, 0x25, 0x0E, 0xB0,
  0x15, 0x05, 0xD8, 0x2C, 0x72, 0xCC, 0x0B, 0x04, 0x20, 0x30, 0xAC, 0x0A, 0x50, 0xDB, 0x03, 0x40,
  0x10, 0xEC, 0x06, 0x20, 0x3C, 0x07, 0x60, 0x7C, 0x03, 0x40, 0x9B, 0x09, 0x40, 0x9C, 0x03, 0x30,
  0x9B, 0x0B, 0x71, 0x0A, 0xB0, 0x84, 0x05, 0xC0, 0x32, 0x01, 0xC0, 0x64, 0x0D, 0xB0, 0x47, 0x10,
  0x3B, 0x0C, 0x50, 0xDB, 0x82, 0xE3, 0x07, 0xB0, 0xC5, 0x0E, 0xB7, 0x3B, 0x0D, 0x50, 0x4D, 0x0A,
  0x0C, 0xB0, 0x65, 0x0E, 0xB7, 0x20, 0x1B, 0x0D, 0x60, 0x8F, 0xA0, 0x25, 0x0D, 0xB0, 0x37, 0x10,
  0x4B, 0x0E, 0x03, 0x60, 0x8F, 0x96, 0x09, 0xB0, 0xA7, 0x10, 0x7C, 0x0E, 0x04, 0x60, 0x40, 0xDE,
  0x60, 0x4C, 0x03, 0x71, 0x09, 0xD0, 0x47, 0x81, 0x59, 0xEB, 0x02, 0x60, 0xBA, 0x07, 0x73, 0x07,
  0xC0, 0xE0, 0x17, 0x10, 0xAB, 0x06, 0x68, 0x12, 0xE7, 0x68, 0x24, 0xDD, 0x42, 0x06, 0xC0, 0x67,
  0x10, 0x6B, 0x0C, 0x70, 0x17, 0x0D, 0xA0, 0xD3, 0x08, 0xB0, 0xC7, 0x10, 0x1C, 0x06, 0x77, 0x0D,
  0xA0, 0xD3, 0x01, 0xB0, 0xE7, 0x20, 0x9B, 0x0E, 0x04, 0x76, 0x82, 0x4D, 0xD4, 0x30, 0x1B, 0x0E,
  0x72, 0x01, 0x0E, 0xC0, 0x67, 0x75, 0x06, 0xB0, 0xB7, 0x30, 0x5D, 0x81, 0xC7, 0x27, 0x70, 0x10,
  0x6C, 0x07, 0x74, 0x06, 0xFF, 0xFD, 0x0E, 0x76, 0x05, 0x0E, 0xFF, 0xFB, 0x04, 0x77, 0x01, 0x09,
  0xFF, 0xF0, 0xE0, 0x57, 0x73, 0x83, 0x16, 0xAD, 0xEF, 0xE8, 0x2E, 0xC7, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_pest_control_rodent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_pest_control_rodent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_pin_drop 48x48, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_outlined_48_maps_pin_drop_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x72, 0x05, 0x0C, 0xFB, 0x0C, 0x05, 0x75, 0x01,
  0x0C, 0xFF, 0x0C, 0x01, 0x72, 0x04, 0x0E, 0xFF, 0xA0, 0xE0, 0x47, 0x04, 0xE8, 0x1A, 0x52, 0x28,
  0x12, 0x5A, 0xE0, 0x45, 0x02, 0x0E, 0xC0, 0xA0, 0x27, 0x10, 0x20, 0xAC, 0x0E, 0x02, 0x40, 0xCC,
  0x06, 0x75, 0x06, 0xC0, 0xC3, 0x05, 0xC0, 0x67, 0x70, 0x6C, 0x06, 0x20, 0xDB, 0x0A, 0x77, 0x20,
  0xAB, 0x81, 0xD0, 0x3C, 0x01, 0x77, 0x20, 0x1C, 0x03, 0x08, 0xB0, 0xA6, 0x84, 0x1A, 0xDE, 0xA2,
  0x60, 0xAB, 0x08, 0x0B, 0xB0, 0x55, 0x01, 0x0E, 0xC0, 0xE0, 0x25, 0x05, 0xB0, 0xB0, 0xDB, 0x02,
  0x50, 0xAE, 0x0A, 0x50, 0x2B, 0x0D, 0x0E, 0xB0, 0x15, 0x0D, 0xE0, 0xE6, 0xB0, 0xEC, 0x60, 0xDE,
  0x0E, 0x6C, 0x0D, 0xB0, 0x15, 0x0A, 0xE0, 0xA5, 0x01, 0xB0, 0xD0, 0xCB, 0x04, 0x50, 0x10, 0xEC,
  0x0E, 0x02, 0x50, 0x4B, 0x0C, 0x08, 0xB0, 0x96, 0x84, 0x1A, 0xDE, 0xA2, 0x60, 0x9B, 0x08, 0x04,
  0xB0, 0xE0, 0x17, 0x72, 0x01, 0x0E, 0xB8, 0x14, 0x0D, 0xB0, 0x77, 0x72, 0x07, 0xB0, 0xD2, 0x07,
  0xB0, 0xE0, 0x17, 0x70, 0x10, 0xEB, 0x07, 0x20, 0x10, 0xEB, 0x0B, 0x77, 0x0B, 0xB0, 0xE0, 0x13,
  0x05, 0xC0, 0x77, 0x50, 0x7C, 0x05, 0x50, 0xBC, 0x04, 0x73, 0x04, 0xC0, 0xB6, 0x01, 0x0E, 0xB0,
  0xE0, 0x37, 0x10, 0x30, 0xEB, 0x0E, 0x01, 0x70, 0x3C, 0x0E, 0x03, 0x60, 0x30, 0xEC, 0x03, 0x72,
  0x06, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x67, 0x40, 0x7D, 0x05, 0x20, 0x5D, 0x07, 0x76, 0x07,
  0xD0, 0x07, 0xD0, 0x77, 0x71, 0x07, 0xFB, 0x07, 0x77, 0x30, 0x5F, 0x90, 0x57, 0x75, 0x04, 0x0E,
  0xC0, 0xE0, 0x47, 0x77, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x77, 0x30, 0x09, 0x80, 0x98, 0x10, 0x80,
  0x9D, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_pin_drop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_pin_drop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_place 48x48, 4-bit Alpha,  RLE, 311 bytes.
static const unsigned char ic_outlined_48_maps_place_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x10, 0x8F, 0xFA, 0x08, 0x75, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x30, 0xED, 0x82, 0xD8,
  0x42, 0x28, 0x22, 0x48, 0xDD, 0x0E, 0x03, 0x70, 0x10, 0xEC, 0x0D, 0x05, 0x73, 0x05, 0x0D, 0xC0,
  0xE0, 0x16, 0x0C, 0xC0, 0x97, 0x70, 0x9C, 0x0C, 0x50, 0x7C, 0x07, 0x77, 0x20, 0x7C, 0x07, 0x30,
  0x10, 0xEB, 0x0A, 0x77, 0x40, 0xAB, 0x0E, 0x01, 0x20, 0x9B, 0x0D, 0x77, 0x60, 0xDB, 0x09, 0x20,
  0xEB, 0x06, 0x77, 0x60, 0x6B, 0x81, 0xE0, 0x3B, 0x0D, 0x77, 0x71, 0x0D, 0xB0, 0x30, 0x8B, 0x09,
  0x71, 0x84, 0x1A, 0xDD, 0xA1, 0x71, 0x09, 0xB0, 0x80, 0xBB, 0x05, 0x70, 0x10, 0xEC, 0x0E, 0x01,
  0x70, 0x5B, 0x0B, 0x0C, 0xB0, 0x27, 0x0A, 0xE0, 0xA7, 0x02, 0xB0, 0xD0, 0xEB, 0x01, 0x70, 0xDE,
  0x0D, 0x70, 0x1B, 0x0E, 0xC7, 0x10, 0xDE, 0x0D, 0x71, 0xC0, 0xDB, 0x01, 0x70, 0xAE, 0x0A, 0x70,
  0x1B, 0x0D, 0x0C, 0xB0, 0x47, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x04, 0xB0, 0xC0, 0x9B, 0x08, 0x71,
  0x84, 0x1A, 0xDD, 0xA1, 0x71, 0x08, 0xB0, 0x90, 0x4B, 0x0D, 0x77, 0x71, 0x0D, 0xB8, 0x14, 0x0E,
  0xB0, 0x47, 0x76, 0x04, 0xB0, 0xE2, 0x09, 0xB0, 0xC7, 0x76, 0x0C, 0xB0, 0x92, 0x02, 0xC0, 0x57,
  0x74, 0x05, 0xC0, 0x23, 0x0A, 0xB0, 0xD0, 0x17, 0x72, 0x01, 0x0D, 0xB0, 0xA4, 0x01, 0x0E, 0xB0,
  0xA7, 0x72, 0x0A, 0xB0, 0xE0, 0x15, 0x07, 0xC0, 0x57, 0x70, 0x5C, 0x07, 0x70, 0xCB, 0x0E, 0x03,
  0x75, 0x03, 0x0E, 0xB0, 0xC7, 0x10, 0x20, 0xEB, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xB0, 0xE0, 0x27,
  0x20, 0x5C, 0x0C, 0x73, 0x0C, 0xC0, 0x57, 0x40, 0x8C, 0x0B, 0x71, 0x0B, 0xC0, 0x87, 0x60, 0xAC,
  0x0A, 0x60, 0xAC, 0x0A, 0x77, 0x10, 0xBC, 0x0A, 0x40, 0xAC, 0x0B, 0x77, 0x20, 0x10, 0xCC, 0x0B,
  0x20, 0xBC, 0x0C, 0x01, 0x77, 0x30, 0x10, 0xCC, 0x00, 0xBC, 0x0C, 0x01, 0x77, 0x50, 0x10, 0xCF,
  0x90, 0xC0, 0x17, 0x77, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x30, 0xBC, 0x0B, 0x77, 0x76, 0x0A,
  0xA0, 0xA7, 0x77, 0x71, 0x00, 0x87, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_place() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_place_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_plumbing 48x48, 4-bit Alpha,  RLE, 291 bytes.
static const unsigned char ic_outlined_48_maps_plumbing_data[] PROGMEM = {
  0x77, 0x72, 0x81, 0x57, 0x57, 0x77, 0x71, 0x03, 0x0D, 0xB0, 0xD0, 0x37, 0x77, 0x50, 0x30, 0xED,
  0x0E, 0x03, 0x77, 0x73, 0x03, 0x0E, 0xF0, 0xE0, 0x37, 0x77, 0x10, 0x30, 0xEF, 0xA0, 0xE0, 0x37,
  0x76, 0x03, 0x0E, 0xFC, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEF, 0xE0, 0xE0, 0x27, 0x48, 0x28, 0xDB,
  0x42, 0x0A, 0xF0, 0x8F, 0x0A, 0x73, 0x0A, 0xC0, 0x52, 0x0B, 0xD8, 0x14, 0x04, 0xF0, 0x17, 0x10,
  0x1E, 0x05, 0x20, 0xBB, 0x04, 0x30, 0x4E, 0x03, 0x71, 0x02, 0xF0, 0x52, 0x81, 0xBF, 0x45, 0x04,
  0xD0, 0x47, 0x20, 0xCF, 0x05, 0x28, 0x23, 0x01, 0x24, 0x04, 0xC0, 0x17, 0x20, 0x20, 0xEF, 0x05,
  0x28, 0x21, 0xCD, 0x24, 0x04, 0xA0, 0xC7, 0x40, 0x20, 0xEF, 0x81, 0x51, 0xCA, 0x0D, 0x02, 0x48,
  0x14, 0xF3, 0x72, 0x83, 0x42, 0x02, 0xEF, 0x0D, 0xC0, 0xD0, 0x24, 0x01, 0x72, 0x85, 0x4E, 0xE2,
  0x02, 0xEF, 0xD0, 0xD0, 0x27, 0x50, 0x40, 0xEA, 0x83, 0xE2, 0x02, 0xEF, 0xD0, 0xD0, 0x27, 0x30,
  0x40, 0xEC, 0x83, 0xE2, 0x02, 0xEF, 0xD0, 0xD7, 0x20, 0x40, 0xEE, 0x0D, 0x20, 0x3F, 0xE0, 0x37,
  0x02, 0x0E, 0xF8, 0x24, 0x01, 0xCF, 0xD0, 0xE0, 0x17, 0x0B, 0xF8, 0x24, 0x01, 0xCF, 0xB8, 0x26,
  0x58, 0x27, 0x10, 0xDE, 0x82, 0x40, 0x1C, 0xFB, 0x06, 0x75, 0x09, 0xD8, 0x24, 0x01, 0xCF, 0xB0,
  0x67, 0x60, 0x10, 0xDA, 0x83, 0xE4, 0x01, 0xCF, 0xB0, 0x67, 0x72, 0x84, 0x45, 0x10, 0x1C, 0xFB,
  0x06, 0x77, 0x60, 0x10, 0xCF, 0xB0, 0x67, 0x76, 0x01, 0x0C, 0xFB, 0x06, 0x77, 0x60, 0x10, 0xCF,
  0xB0, 0x67, 0x76, 0x01, 0x0C, 0xFB, 0x06, 0x77, 0x60, 0x10, 0xCF, 0xB0, 0x67, 0x76, 0x01, 0x0C,
  0xFB, 0x06, 0x77, 0x60, 0x10, 0xCF, 0xB0, 0x67, 0x76, 0x01, 0x0C, 0xFB, 0x06, 0x77, 0x70, 0xAF,
  0xB0, 0x67, 0x77, 0x01, 0xFB, 0x06, 0x77, 0x71, 0x04, 0xFA, 0x06, 0x77, 0x72, 0x01, 0xF9, 0x06,
  0x77, 0x74, 0x0B, 0xE0, 0x67, 0x77, 0x50, 0x10, 0xCB, 0x0E, 0x05, 0x77, 0x77, 0x18, 0x24, 0x76,
  0x17, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_plumbing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 40, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_plumbing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_railway_alert 48x48, 4-bit Alpha,  RLE, 292 bytes.
static const unsigned char ic_outlined_48_maps_railway_alert_data[] PROGMEM = {
  0x77, 0x77, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x77, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77,
  0x71, 0x08, 0xFD, 0x08, 0x77, 0x76, 0x08, 0xFF, 0x08, 0x72, 0x84, 0x47, 0x9B, 0xDD, 0xE0, 0x23,
  0x04, 0xF2, 0xF0, 0x45, 0x05, 0x0B, 0xFD, 0x0C, 0x40, 0xDF, 0x2F, 0x0D, 0x30, 0x40, 0xDF, 0xF0,
  0x73, 0x05, 0xF9, 0x2F, 0x98, 0x15, 0x05, 0xFF, 0xA0, 0x43, 0x09, 0xF9, 0x2F, 0x98, 0x19, 0x2E,
  0xD8, 0x4C, 0x86, 0x42, 0x17, 0x20, 0xDF, 0x92, 0xF9, 0x0D, 0x09, 0xC0, 0x90, 0x17, 0x71, 0x0E,
  0xF9, 0x2F, 0x90, 0xE0, 0xDF, 0xFB, 0x40, 0xEF, 0x92, 0xF9, 0x00, 0xEF, 0xFB, 0x01, 0x30, 0xDF,
  0x92, 0xF9, 0x0D, 0xFF, 0xC0, 0x33, 0x09, 0xFF, 0xC0, 0x9F, 0xFC, 0x07, 0x30, 0x5F, 0xFC, 0x05,
  0xC7, 0x75, 0x0D, 0xF2, 0xF0, 0xD1, 0xC7, 0x75, 0x04, 0xF2, 0xF0, 0x41, 0xC7, 0x76, 0x08, 0xFF,
  0x08, 0x2C, 0x77, 0x70, 0x8F, 0xD0, 0x83, 0xC7, 0x77, 0x10, 0x40, 0xDF, 0x90, 0xD0, 0x44, 0xC7,
  0x77, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56, 0xFF, 0xF9, 0x0B, 0x01, 0x77, 0x4F, 0xFF, 0xA0, 0xD0,
  0x37, 0x73, 0xFF, 0xFC, 0x0A, 0x02, 0x77, 0x1F, 0xFF, 0xE8, 0x2C, 0x74, 0x27, 0x4C, 0x77, 0x73,
  0xC7, 0x3C, 0x77, 0x73, 0xC7, 0x3C, 0x73, 0x82, 0x8D, 0xD8, 0x73, 0xC7, 0x3C, 0x72, 0x08, 0xC0,
  0x87, 0x2C, 0x73, 0xC7, 0x20, 0xDC, 0x0D, 0x72, 0xC7, 0x3C, 0x72, 0x0D, 0xC0, 0xD7, 0x2C, 0x73,
  0xC7, 0x20, 0x8C, 0x08, 0x72, 0xC7, 0x30, 0xEB, 0x01, 0x72, 0x82, 0x8D, 0xD8, 0x72, 0x01, 0xB0,
  0xE7, 0x30, 0xCB, 0x07, 0x77, 0x71, 0x07, 0xB0, 0xC7, 0x30, 0x7C, 0x07, 0x01, 0x77, 0x40, 0x10,
  0x7C, 0x07, 0x73, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x74, 0x05, 0xFF, 0xFF, 0x05, 0x76, 0x05,
  0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x77, 0x18, 0x21, 0x7C, 0xEF, 0xFC, 0x82, 0xEC, 0x71, 0x77, 0x40,
  0x10, 0xAF, 0xFC, 0x0A, 0x01, 0x77, 0x50, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x4F, 0xFF, 0xB7,
  0x74, 0xFF, 0xFB, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_railway_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_railway_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_ramen_dining 48x48, 4-bit Alpha,  RLE, 245 bytes.
static const unsigned char ic_outlined_48_maps_ramen_dining_data[] PROGMEM = {
  0x77, 0x77, 0x48, 0x62, 0x45, 0x79, 0xBC, 0xE7, 0x77, 0x18, 0x71, 0x24, 0x67, 0x9B, 0xDE, 0xFA,
  0x76, 0x87, 0x12, 0x46, 0x79, 0xBD, 0xEF, 0xFC, 0x48, 0x71, 0x24, 0x67, 0x9B, 0xDE, 0xFF, 0xC8,
  0x7E, 0xDB, 0x97, 0x64, 0x21, 0x4F, 0xFC, 0x87, 0xED, 0xB9, 0x76, 0x42, 0x17, 0x6F, 0xA0, 0xEB,
  0x83, 0x76, 0x42, 0x17, 0x77, 0x1B, 0x09, 0x07, 0xB0, 0x11, 0xB7, 0x77, 0x6B, 0x2B, 0x2B, 0x77,
  0x76, 0xB2, 0xB2, 0xB7, 0x77, 0x68, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x4B, 0x2B,
  0x2B, 0x77, 0x76, 0xB2, 0xB2, 0xB7, 0x77, 0x6B, 0x2B, 0x2B, 0x77, 0x76, 0xB2, 0xB2, 0xB7, 0x77,
  0x6B, 0x2B, 0x2B, 0x77, 0x76, 0xB2, 0xB2, 0xB7, 0x77, 0x6B, 0x2B, 0x2B, 0x77, 0x76, 0xB2, 0xB2,
  0xB7, 0x77, 0x20, 0xE8, 0x0C, 0x2F, 0x0E, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xC8, 0x0C, 0x2F, 0x0C,
  0x08, 0x80, 0xC2, 0xF0, 0x80, 0x5B, 0x0D, 0x77, 0x77, 0x20, 0xDB, 0x81, 0x51, 0xEB, 0x05, 0x77,
  0x77, 0x06, 0xB8, 0x2E, 0x10, 0x9B, 0x0D, 0x77, 0x77, 0x0D, 0xB0, 0x92, 0x02, 0xC0, 0x97, 0x77,
  0x50, 0x9C, 0x02, 0x30, 0x8C, 0x05, 0x77, 0x73, 0x06, 0xC0, 0x85, 0x0D, 0xC0, 0x57, 0x77, 0x10,
  0x5C, 0x0D, 0x60, 0x3D, 0x08, 0x77, 0x60, 0x8D, 0x03, 0x70, 0x5D, 0x0B, 0x03, 0x77, 0x20, 0x20,
  0xBD, 0x05, 0x72, 0x05, 0xE0, 0xB0, 0x37, 0x50, 0x30, 0xAE, 0x05, 0x74, 0x03, 0x0E, 0xE0, 0xC0,
  0x67, 0x10, 0x60, 0xCE, 0x0E, 0x03, 0x76, 0x01, 0x0A, 0xF7, 0x1F, 0x0A, 0x01, 0x77, 0x20, 0x40,
  0xCD, 0x71, 0xD0, 0xC0, 0x47, 0x76, 0x04, 0xFF, 0xA0, 0x47, 0x77, 0x2F, 0xFA, 0x77, 0x73, 0xFF,
  0xA7, 0x77, 0x3F, 0xFA, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_ramen_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_ramen_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_ramp_left 48x48, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_outlined_48_maps_ramp_left_data[] PROGMEM = {
  0x70, 0x07, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x10, 0x7E, 0x07, 0x76, 0x07,
  0xF9, 0x07, 0x74, 0x07, 0xFB, 0x07, 0x72, 0x07, 0xFD, 0x07, 0x70, 0x7C, 0x0E, 0xC0, 0xEC, 0x07,
  0x60, 0x7B, 0x0E, 0x03, 0xC0, 0x30, 0xEB, 0x07, 0x78, 0x27, 0xFE, 0x31, 0xC1, 0x82, 0x3E, 0xF7,
  0x72, 0x07, 0x03, 0x2C, 0x20, 0x30, 0x77, 0x7C, 0x77, 0x4C, 0x77, 0x4C, 0x02, 0x77, 0x3C, 0x04,
  0x77, 0x3C, 0x07, 0x77, 0x3C, 0x0D, 0x77, 0x3D, 0x03, 0x77, 0x2D, 0x0A, 0x77, 0x2E, 0x03, 0x77,
  0x1E, 0x0C, 0x77, 0x1F, 0x09, 0x77, 0xF9, 0x06, 0x76, 0xC0, 0xDC, 0x06, 0x75, 0xC0, 0x20, 0xEC,
  0x06, 0x74, 0xC1, 0x04, 0xD0, 0x97, 0x3C, 0x20, 0x4D, 0x0B, 0x01, 0x71, 0xC3, 0x04, 0x0E, 0xC0,
  0xE0, 0x67, 0xC4, 0x02, 0x0D, 0xD0, 0xA6, 0xC5, 0x01, 0x0B, 0xB0, 0xD0, 0x26, 0xC7, 0x82, 0x6E,
  0xD2, 0x7C, 0x71, 0x01, 0x02, 0x71, 0xC7, 0x74, 0xC7, 0x74, 0xC7, 0x74, 0xC7, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_ramp_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(16, 6, 37, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_ramp_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_ramp_right 48x48, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_outlined_48_maps_ramp_right_data[] PROGMEM = {
  0x76, 0x00, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x71, 0x07, 0xE0, 0x77, 0x60,
  0x7F, 0x90, 0x77, 0x40, 0x7F, 0xB0, 0x77, 0x20, 0x7F, 0xD0, 0x77, 0x07, 0xC0, 0xEC, 0x0E, 0xC0,
  0x76, 0x07, 0xB0, 0xE0, 0x3C, 0x03, 0x0E, 0xB0, 0x77, 0x82, 0x7F, 0xE3, 0x1C, 0x18, 0x23, 0xEF,
  0x77, 0x20, 0x70, 0x32, 0xC2, 0x03, 0x07, 0x77, 0xC7, 0x74, 0xC7, 0x73, 0x02, 0xC7, 0x73, 0x04,
  0xC7, 0x73, 0x07, 0xC7, 0x73, 0x0D, 0xC7, 0x72, 0x03, 0xD7, 0x72, 0x0A, 0xD7, 0x71, 0x03, 0xE7,
  0x71, 0x0C, 0xE7, 0x70, 0x9F, 0x76, 0x06, 0xF9, 0x75, 0x06, 0xC0, 0xDC, 0x74, 0x06, 0xC0, 0xE0,
  0x2C, 0x73, 0x09, 0xD0, 0x41, 0xC7, 0x10, 0x10, 0xBD, 0x04, 0x2C, 0x70, 0x60, 0xEC, 0x0E, 0x04,
  0x3C, 0x60, 0xAD, 0x0D, 0x02, 0x4C, 0x60, 0x20, 0xDB, 0x0B, 0x01, 0x5C, 0x78, 0x22, 0xDE, 0x67,
  0xC7, 0x10, 0x20, 0x17, 0x1C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_ramp_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 31, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_ramp_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_rate_review 48x48, 4-bit Alpha,  RLE, 202 bytes.
static const unsigned char ic_outlined_48_maps_rate_review_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x71, 0x81, 0x6D, 0x57, 0x7F, 0x97, 0x70, 0x6B, 0x05, 0x76, 0xF9, 0x76, 0x06, 0xD0,
  0x57, 0x5F, 0x97, 0x50, 0x6F, 0x05, 0x74, 0xF9, 0x74, 0x06, 0xF9, 0x0E, 0x74, 0xF9, 0x73, 0x06,
  0xFA, 0x07, 0x74, 0xF9, 0x72, 0x06, 0xFA, 0x07, 0x75, 0xF9, 0x71, 0x06, 0xFA, 0x07, 0x76, 0xF9,
  0x70, 0x6F, 0xA0, 0x77, 0x7F, 0x96, 0x06, 0xFA, 0x07, 0x77, 0x1F, 0x95, 0x06, 0xFA, 0x07, 0x77,
  0x2F, 0x94, 0x06, 0xFA, 0x07, 0x77, 0x3F, 0x94, 0xFA, 0x07, 0x77, 0x4F, 0x94, 0xF9, 0x07, 0x30,
  0x7F, 0xC4, 0xF9, 0x4F, 0x06, 0x30, 0x7F, 0xD4, 0xF9, 0x4E, 0x06, 0x30, 0x7F, 0xE4, 0xF9, 0x4D,
  0x06, 0x30, 0x7F, 0xF4, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x10, 0x30, 0xEF, 0xFF, 0xFC, 0x0D, 0xC0, 0x30, 0xEF, 0xFF, 0xFD, 0x0A, 0xC0,
  0xEF, 0xFF, 0xFD, 0x0E, 0x01, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77, 0x4E, 0x07,
  0x77, 0x77, 0x5D, 0x07, 0x77, 0x77, 0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0, 0x0A, 0x07,
  0x80, 0xC1, 0x09, 0x07, 0x80, 0xC2, 0x00, 0x78, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_rate_review() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_rate_review_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_remove_road 48x48, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_outlined_48_maps_remove_road_data[] PROGMEM = {
  0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5,
  0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5,
  0xC7, 0x77, 0x3C, 0x5C, 0x77, 0x73, 0xC5, 0xC7, 0x77, 0x3C, 0x5C, 0x77, 0x73, 0xC5, 0xC7, 0x3C,
  0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C,
  0x73, 0xC5, 0xC7, 0x3C, 0x73, 0xC5, 0xC7, 0x3C, 0x77, 0x5C, 0x73, 0xC7, 0x75, 0xC7, 0x77, 0x75,
  0xC7, 0x77, 0x75, 0xC7, 0x77, 0x0A, 0x05, 0x60, 0x50, 0xA2, 0xC7, 0x76, 0x0A, 0xA0, 0x54, 0x05,
  0xA0, 0xA1, 0xC7, 0x3C, 0x50, 0xAC, 0x05, 0x20, 0x5C, 0x0A, 0xC7, 0x3C, 0x50, 0x5D, 0x00, 0x5D,
  0x05, 0xC7, 0x3C, 0x60, 0x5F, 0xB0, 0x51, 0xC7, 0x3C, 0x70, 0x5F, 0x90, 0x52, 0xC7, 0x3C, 0x71,
  0x05, 0xE0, 0x53, 0xC7, 0x3C, 0x71, 0x05, 0xE0, 0x53, 0xC7, 0x3C, 0x70, 0x5F, 0x90, 0x52, 0xC7,
  0x3C, 0x60, 0x5F, 0xB0, 0x57, 0x77, 0x30, 0x5D, 0x00, 0x5D, 0x05, 0x77, 0x72, 0x0A, 0xC0, 0x52,
  0x05, 0xC0, 0xA7, 0x77, 0x30, 0xAA, 0x05, 0x40, 0x5A, 0x0A, 0x77, 0x75, 0x0A, 0x05, 0x60, 0x50,
  0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_remove_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 44, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_remove_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_restaurant_menu 48x48, 4-bit Alpha,  RLE, 283 bytes.
static const unsigned char ic_outlined_48_maps_restaurant_menu_data[] PROGMEM = {
  0x77, 0x77, 0x18, 0x44, 0x79, 0xB9, 0x56, 0x08, 0x05, 0x77, 0x72, 0x06, 0x0D, 0xE0, 0xE0, 0x43,
  0x05, 0xA0, 0x57, 0x76, 0x01, 0x0C, 0xFB, 0x04, 0x20, 0xDB, 0x05, 0x77, 0x40, 0x30, 0xDF, 0xC8,
  0x1D, 0x02, 0xD0, 0x57, 0x72, 0x02, 0x0E, 0xFE, 0x05, 0x06, 0xE0, 0x57, 0x71, 0x0C, 0xFF, 0x09,
  0x07, 0xF0, 0x57, 0x60, 0x6F, 0xF9, 0x0A, 0x06, 0xF9, 0x05, 0x75, 0x0D, 0xFF, 0x90, 0xA0, 0x4F,
  0xA0, 0x57, 0x30, 0x4F, 0xFA, 0x81, 0x70, 0xEF, 0xA0, 0x57, 0x20, 0x7F, 0xFA, 0x81, 0x30, 0x7F,
  0xB0, 0x57, 0x10, 0xAF, 0xF9, 0x0D, 0x30, 0xCF, 0xB0, 0x57, 0x0A, 0xFF, 0x90, 0x53, 0x01, 0x0D,
  0xFB, 0x05, 0x60, 0x8F, 0xF0, 0xB5, 0x01, 0x0D, 0xFB, 0x05, 0x50, 0x5F, 0xE0, 0xD0, 0x16, 0x01,
  0x0D, 0xFB, 0x05, 0x40, 0x6F, 0xD0, 0xD0, 0x27, 0x10, 0x10, 0xDF, 0xA0, 0x53, 0x05, 0xFD, 0x0B,
  0x01, 0x73, 0x01, 0x0D, 0xF0, 0x53, 0x05, 0xFC, 0x0D, 0x05, 0x76, 0x01, 0x0D, 0xD0, 0x53, 0x05,
  0xD8, 0x55, 0x48, 0x99, 0x73, 0x77, 0x20, 0x10, 0xDB, 0x05, 0x30, 0x5D, 0x05, 0x77, 0x73, 0x82,
  0x1D, 0xF5, 0x30, 0x5D, 0x05, 0x77, 0x75, 0x01, 0x05, 0x30, 0x5E, 0x05, 0x77, 0x77, 0x20, 0x5F,
  0x90, 0x57, 0x77, 0x70, 0x5F, 0xB0, 0x57, 0x77, 0x50, 0x5D, 0x00, 0x5D, 0x05, 0x77, 0x73, 0x05,
  0xD0, 0x52, 0x05, 0xD0, 0x57, 0x77, 0x10, 0x5D, 0x05, 0x40, 0x5D, 0x05, 0x77, 0x60, 0x5D, 0x05,
  0x60, 0x5D, 0x05, 0x77, 0x40, 0x5D, 0x05, 0x71, 0x05, 0xD0, 0x57, 0x72, 0x05, 0xD0, 0x57, 0x30,
  0x5D, 0x05, 0x77, 0x05, 0xD0, 0x47, 0x50, 0x5D, 0x05, 0x75, 0x05, 0xD0, 0x47, 0x70, 0x5D, 0x05,
  0x73, 0x05, 0xD0, 0x47, 0x72, 0x05, 0xD0, 0x57, 0x10, 0x5D, 0x04, 0x77, 0x40, 0x5D, 0x05, 0x60,
  0x4D, 0x04, 0x77, 0x60, 0x5D, 0x04, 0x60, 0xCB, 0x04, 0x77, 0x71, 0x05, 0xB0, 0xC7, 0x18, 0x1C,
  0xF4, 0x77, 0x73, 0x81, 0x5F, 0xC7, 0x30, 0x37, 0x77, 0x50, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_restaurant_menu() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 43, 42), Box(0, 0, 47, 47),
      ic_outlined_48_maps_restaurant_menu_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_restaurant 48x48, 4-bit Alpha,  RLE, 172 bytes.
static const unsigned char ic_outlined_48_maps_restaurant_data[] PROGMEM = {
  0xC4, 0xC4, 0xC7, 0x58, 0x25, 0xAD, 0xEC, 0x4C, 0x4C, 0x73, 0x06, 0x0E, 0xF9, 0x4C, 0x4C, 0x71,
  0x01, 0x0B, 0xFB, 0x4C, 0x4C, 0x70, 0x10, 0xCF, 0xC4, 0xC4, 0xC7, 0x0A, 0xFD, 0x4C, 0x4C, 0x60,
  0x4F, 0xE4, 0xC4, 0xC6, 0x0B, 0xFE, 0x4C, 0x4C, 0x60, 0xEF, 0xE4, 0xC4, 0xC6, 0xFF, 0x4C, 0x4C,
  0x6F, 0xF4, 0xC4, 0xC6, 0xFF, 0x4C, 0x4C, 0x6F, 0xF4, 0xC4, 0xC6, 0xFF, 0x4C, 0x4C, 0x6F, 0xB0,
  0xEF, 0xFC, 0x0E, 0x6F, 0xB0, 0xCF, 0xFC, 0x0C, 0x6F, 0xB0, 0x8F, 0xFC, 0x08, 0x6F, 0xB0, 0x2F,
  0xFC, 0x02, 0x6F, 0xB1, 0x09, 0xFF, 0xA0, 0x97, 0xFB, 0x20, 0xBF, 0xF0, 0xB7, 0x1F, 0xB3, 0x09,
  0xFD, 0x09, 0x72, 0xFB, 0x48, 0x22, 0x8C, 0xEC, 0x82, 0xEC, 0x82, 0x73, 0xFB, 0x71, 0xC7, 0x7F,
  0xB7, 0x1C, 0x77, 0xFB, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C,
  0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C,
  0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7,
  0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_restaurant() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_restaurant_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_roundabout_left 48x48, 4-bit Alpha,  RLE, 238 bytes.
static const unsigned char ic_outlined_48_maps_roundabout_left_data[] PROGMEM = {
  0x77, 0x72, 0x89, 0x01, 0x6B, 0xDE, 0xED, 0xA6, 0x17, 0x77, 0x70, 0x10, 0x9F, 0xB0, 0x90, 0x17,
  0x77, 0x40, 0x50, 0xEF, 0xD0, 0xE0, 0x47, 0x77, 0x20, 0x6F, 0xFA, 0x06, 0x73, 0x00, 0x77, 0x20,
  0x5D, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x04, 0x71, 0x07, 0xA0, 0x77, 0x01, 0x0E, 0xB0, 0xE0,
  0x67, 0x10, 0x6C, 0x0E, 0x01, 0x60, 0x7C, 0x07, 0x60, 0x9B, 0x0E, 0x04, 0x73, 0x04, 0xC0, 0x95,
  0x07, 0xC0, 0xE0, 0x35, 0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x30, 0x7C, 0x0E, 0x03, 0x60, 0x6B,
  0x0C, 0x77, 0x0C, 0xB0, 0x62, 0x07, 0xC0, 0xE0, 0x37, 0x0B, 0xB0, 0x67, 0x70, 0x6B, 0x81, 0xB0,
  0x7F, 0xFC, 0x02, 0x77, 0x02, 0xB0, 0xD0, 0x7F, 0xFC, 0x0C, 0x77, 0x2B, 0x0E, 0x07, 0xFF, 0xC0,
  0x37, 0x72, 0xB8, 0x1E, 0x07, 0xFF, 0x81, 0xEB, 0x37, 0x72, 0x02, 0xB0, 0xD2, 0x07, 0xC0, 0xE0,
  0x37, 0x77, 0x50, 0x6B, 0x0B, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0x74, 0x0C, 0xB0, 0x64, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x20, 0x6C, 0x01, 0x50, 0x7C, 0x07, 0x77, 0x71, 0x04, 0x0E, 0xB0, 0x97, 0x07,
  0xA0, 0x77, 0x77, 0x10, 0x60, 0xEB, 0x0E, 0x01, 0x71, 0x00, 0x77, 0x76, 0x81, 0x26, 0xCD, 0x05,
  0x77, 0x77, 0x10, 0x30, 0xCF, 0x06, 0x77, 0x77, 0x10, 0x3F, 0x0E, 0x05, 0x77, 0x77, 0x20, 0xBE,
  0x09, 0x01, 0x77, 0x77, 0x30, 0xEB, 0x81, 0xB6, 0x17, 0x77, 0x75, 0xC8, 0x0C, 0x00, 0xC8, 0x0C,
  0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00,
  0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_roundabout_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_roundabout_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_roundabout_right 48x48, 4-bit Alpha,  RLE, 236 bytes.
static const unsigned char ic_outlined_48_maps_roundabout_right_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x77, 0x77, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x77, 0x74,
  0x04, 0x0E, 0xFD, 0x0E, 0x05, 0x77, 0x72, 0x06, 0xFF, 0xA0, 0x67, 0x77, 0x04, 0xD8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xD0, 0x57, 0x20, 0x07, 0x71, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x60, 0xEB, 0x0E,
  0x01, 0x70, 0x7A, 0x07, 0x70, 0x9C, 0x04, 0x73, 0x04, 0x0E, 0xB0, 0x96, 0x07, 0xC0, 0x75, 0x01,
  0xC0, 0x67, 0x50, 0x6C, 0x01, 0x50, 0x30, 0xEC, 0x07, 0x40, 0x6B, 0x0C, 0x77, 0x0C, 0xB0, 0x66,
  0x03, 0x0E, 0xC0, 0x73, 0x0B, 0xB0, 0x67, 0x70, 0x6B, 0x0A, 0x70, 0x30, 0xEC, 0x07, 0x20, 0xDB,
  0x02, 0x77, 0x02, 0xFF, 0xC8, 0x17, 0x0E, 0xB7, 0x72, 0x0C, 0xFF, 0xC0, 0x70, 0xEB, 0x77, 0x20,
  0x3F, 0xFC, 0x07, 0x0D, 0xB0, 0x27, 0x72, 0x81, 0x3B, 0xEF, 0xF8, 0x17, 0x0B, 0xB0, 0x67, 0x77,
  0x50, 0x30, 0xEC, 0x07, 0x20, 0x6B, 0x0C, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x73, 0x01, 0xC0, 0x67,
  0x77, 0x20, 0x30, 0xEC, 0x07, 0x50, 0x9B, 0x0E, 0x04, 0x77, 0x71, 0x07, 0xC0, 0x76, 0x01, 0x0E,
  0xB0, 0xE0, 0x67, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x05, 0xD8, 0x1C, 0x62, 0x77, 0x60, 0x07, 0x73,
  0x06, 0xF0, 0xC0, 0x37, 0x77, 0x73, 0x05, 0x0E, 0xF0, 0x37, 0x77, 0x73, 0x01, 0x09, 0xE0, 0xB7,
  0x77, 0x75, 0x81, 0x16, 0xBB, 0x0E, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80,
  0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0,
  0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x77, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_roundabout_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_roundabout_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_route 48x48, 4-bit Alpha,  RLE, 279 bytes.
static const unsigned char ic_outlined_48_maps_route_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEC, 0x67, 0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x20, 0x10, 0xCE, 0x0C, 0x01,
  0x71, 0x09, 0xF9, 0x09, 0x71, 0x0C, 0xF9, 0x0C, 0x70, 0xBF, 0xB0, 0xB6, 0x06, 0xFB, 0x06, 0x50,
  0x9F, 0xD0, 0x95, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x40, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0,
  0x24, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE4, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x84, 0x0E,
  0xB0, 0x12, 0x01, 0xB0, 0xE4, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC4, 0x0B, 0xB8, 0x2B, 0x11, 0xBB,
  0x0B, 0x40, 0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x40, 0x5F, 0xB0, 0x54, 0xC7, 0x1C, 0x50, 0xCF, 0x90,
  0xC5, 0xC7, 0x1C, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x5C, 0x71, 0xC7, 0x05, 0xC0, 0x57, 0xC7, 0x1C,
  0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71,
  0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7,
  0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C,
  0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x70, 0x5C, 0x05, 0x7C, 0x71, 0xC5, 0x01,
  0x0C, 0xE0, 0xC0, 0x15, 0xC7, 0x1C, 0x50, 0xCF, 0x90, 0xC5, 0xC7, 0x1C, 0x40, 0x5F, 0xB0, 0x54,
  0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE4, 0x0B, 0xB8, 0x2B, 0x11, 0xBB, 0x0B, 0x40, 0xCB, 0x05, 0x60,
  0x5B, 0x0C, 0x40, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x40, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08,
  0x40, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x40, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x24, 0x0C, 0xB8,
  0x2B, 0x11, 0xBB, 0x0C, 0x50, 0x9F, 0xD0, 0x95, 0x06, 0xFB, 0x06, 0x60, 0xBF, 0xB0, 0xB7, 0x0C,
  0xF9, 0x0C, 0x71, 0x09, 0xF9, 0x09, 0x71, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x28, 0x62, 0x8C, 0xEE,
  0xC8, 0x27, 0x48, 0x46, 0xCE, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_route() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_route_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_run_circle 48x48, 4-bit Alpha,  RLE, 394 bytes.
static const unsigned char ic_outlined_48_maps_run_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0D, 0x06, 0x75, 0x06,
  0x0D, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x37, 0x74,
  0x03, 0x0D, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x48, 0x24, 0xDD, 0x45, 0x01, 0x0C, 0xC0, 0x55,
  0x01, 0x0E, 0xB0, 0xD0, 0x17, 0x50, 0xDA, 0x0D, 0x60, 0x10, 0xDB, 0x0E, 0x01, 0x40, 0x9C, 0x03,
  0x76, 0x0D, 0xA0, 0xD7, 0x03, 0xC0, 0x93, 0x01, 0xC0, 0x77, 0x78, 0x24, 0xDD, 0x47, 0x10, 0x7C,
  0x01, 0x20, 0x8B, 0x0D, 0x77, 0x01, 0x03, 0x75, 0x0D, 0xB0, 0x82, 0x0D, 0xB0, 0x67, 0x50, 0x50,
  0xBA, 0x0A, 0x74, 0x06, 0xB8, 0x1D, 0x03, 0xC7, 0x38, 0x13, 0x9E, 0xD0, 0x67, 0x4C, 0x03, 0x07,
  0xB0, 0xB7, 0x20, 0xDB, 0x0B, 0xC0, 0xE0, 0x17, 0x30, 0xBB, 0x07, 0x0A, 0xB0, 0x67, 0x2A, 0x81,
  0x72, 0x1B, 0x82, 0xDF, 0xD2, 0x72, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x72, 0xA2, 0x04, 0xB8, 0x41,
  0xCF, 0xE6, 0x17, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x72, 0xA2, 0x07, 0xA8, 0x2C, 0x01, 0x9B, 0x70,
  0x2B, 0x0E, 0xC7, 0x3A, 0x20, 0xAA, 0x0A, 0x38, 0x13, 0xAE, 0x71, 0xF9, 0x77, 0x0D, 0xA0, 0x77,
  0x7C, 0x0E, 0xB0, 0x27, 0x50, 0x1B, 0x0A, 0x76, 0x02, 0xB0, 0xE0, 0xCB, 0x03, 0x75, 0x84, 0x4F,
  0xDE, 0xF8, 0x75, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x75, 0x82, 0x7F, 0x84, 0xA0, 0x77, 0x40, 0x6B,
  0x0A, 0x07, 0xB0, 0xB6, 0x82, 0x59, 0x63, 0x28, 0x3A, 0xF5, 0x05, 0xA7, 0x40, 0xBB, 0x07, 0x03,
  0xC6, 0x0A, 0xC8, 0x2C, 0xEF, 0x22, 0xA7, 0x4C, 0x81, 0x30, 0xDB, 0x06, 0x58, 0x22, 0x69, 0xCB,
  0x0E, 0x3A, 0x73, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xD7, 0x38, 0x13, 0x67, 0x3A, 0x73, 0x0D, 0xB0,
  0x82, 0x01, 0xC0, 0x77, 0x71, 0xA7, 0x20, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x77, 0xA7, 0x10, 0x3C,
  0x09, 0x40, 0x10, 0xEB, 0x0D, 0x01, 0x76, 0xA7, 0x01, 0x0D, 0xB0, 0xE0, 0x15, 0x05, 0xC0, 0xC0,
  0x17, 0x5A, 0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0D, 0x03, 0x77, 0x40, 0x30, 0xDC, 0x09, 0x72,
  0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0D, 0x06, 0x75, 0x06, 0x0D, 0xD0, 0xA7,
  0x60, 0x9F, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E,
  0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17,
  0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_run_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_run_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_safety_check 48x48, 4-bit Alpha,  RLE, 329 bytes.
static const unsigned char ic_outlined_48_maps_safety_check_data[] PROGMEM = {
  0x76, 0x84, 0x16, 0xCC, 0x61, 0x77, 0x73, 0x04, 0x0A, 0xE0, 0xA0, 0x47, 0x75, 0x81, 0x28, 0xEF,
  0xB8, 0x1E, 0x82, 0x76, 0x81, 0x16, 0xCF, 0xFA, 0x81, 0xC6, 0x17, 0x10, 0x40, 0xAF, 0xA8, 0x2D,
  0x77, 0xDF, 0xA0, 0xA0, 0x43, 0x81, 0x28, 0xEF, 0x98, 0x1E, 0x93, 0x48, 0x13, 0x9E, 0xF9, 0x81,
  0xE8, 0x2F, 0xA0, 0xB0, 0x57, 0x30, 0x50, 0xBF, 0xF9, 0x81, 0xD7, 0x17, 0x78, 0x11, 0x7D, 0xFB,
  0x09, 0x03, 0x77, 0x60, 0x30, 0x9F, 0x97, 0x77, 0x3F, 0x97, 0x18, 0x65, 0x9D, 0xEE, 0xD9, 0x57,
  0x1F, 0x96, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x6F, 0x95, 0x08, 0xFD, 0x08, 0x5F, 0x94, 0x08, 0xFF,
  0x08, 0x4F, 0x93, 0x04, 0xF2, 0xF0, 0x43, 0xF9, 0x30, 0xDF, 0x2F, 0x0D, 0x3F, 0x92, 0x05, 0xF9,
  0x2F, 0x90, 0x52, 0xF9, 0x20, 0x9F, 0x92, 0xF9, 0x09, 0x2F, 0x92, 0x0D, 0xF9, 0x2F, 0x90, 0xD2,
  0xC0, 0xDB, 0x81, 0x10, 0xEF, 0x92, 0x0E, 0xF8, 0x1E, 0x01, 0xB0, 0xD0, 0xCB, 0x81, 0x20, 0xEF,
  0x98, 0x22, 0x02, 0xEE, 0x81, 0xE0, 0x2B, 0x0C, 0x0B, 0xB8, 0x14, 0x0D, 0xF9, 0x83, 0xE2, 0x02,
  0xED, 0x81, 0xD0, 0x4B, 0x0B, 0x08, 0xB8, 0x18, 0x09, 0xFA, 0x83, 0xE2, 0x02, 0xEC, 0x81, 0x90,
  0x8B, 0x08, 0x04, 0xB8, 0x1C, 0x05, 0xFB, 0x82, 0xE2, 0x09, 0xC8, 0x15, 0x0C, 0xB0, 0x41, 0xC8,
  0x11, 0x0D, 0xFB, 0x0E, 0x09, 0xC8, 0x1D, 0x01, 0xC2, 0x0C, 0xB8, 0x17, 0x04, 0xFF, 0xA8, 0x14,
  0x07, 0xB0, 0xC2, 0x05, 0xB0, 0xD2, 0x08, 0xFF, 0x08, 0x20, 0xDB, 0x05, 0x30, 0xEB, 0x06, 0x20,
  0x8F, 0xD0, 0x82, 0x06, 0xB0, 0xE4, 0x08, 0xB0, 0xE0, 0x12, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x20,
  0x10, 0xEB, 0x08, 0x40, 0x10, 0xEB, 0x0A, 0x48, 0x65, 0x9D, 0xEE, 0xD9, 0x54, 0x0A, 0xB0, 0xE0,
  0x15, 0x05, 0xC0, 0x77, 0x70, 0x7C, 0x05, 0x70, 0xBC, 0x05, 0x75, 0x05, 0xC0, 0xB7, 0x10, 0x10,
  0xEC, 0x06, 0x73, 0x06, 0xC0, 0xE0, 0x17, 0x20, 0x30, 0xEC, 0x08, 0x71, 0x08, 0xC0, 0xE0, 0x37,
  0x40, 0x4D, 0x0D, 0x04, 0x40, 0x40, 0xDD, 0x04, 0x76, 0x04, 0x0E, 0xD8, 0x2C, 0x55, 0xCD, 0x0E,
  0x04, 0x77, 0x10, 0x20, 0xDF, 0xD0, 0xD0, 0x27, 0x74, 0x08, 0xFB, 0x08, 0x77, 0x70, 0x20, 0xAE,
  0x0A, 0x02, 0x77, 0x73, 0x84, 0x17, 0xCC, 0x71, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_safety_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_safety_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_sailing 48x48, 4-bit Alpha,  RLE, 334 bytes.
static const unsigned char ic_outlined_48_maps_sailing_data[] PROGMEM = {
  0x77, 0x78, 0x1C, 0x92, 0x80, 0xC1, 0x00, 0x8A, 0x09, 0x77, 0x77, 0x40, 0x53, 0x04, 0xB0, 0xD0,
  0x37, 0x77, 0x71, 0x01, 0x0E, 0x30, 0x1D, 0x05, 0x77, 0x77, 0x0B, 0x94, 0x0D, 0xD0, 0x67, 0x77,
  0x50, 0x6A, 0x40, 0xAE, 0x05, 0x77, 0x73, 0x02, 0x0E, 0xA4, 0x08, 0xF0, 0x47, 0x77, 0x20, 0xCB,
  0x40, 0x5F, 0x90, 0x37, 0x77, 0x08, 0xC4, 0x04, 0xB0, 0xEC, 0x0D, 0x01, 0x77, 0x50, 0x3D, 0x40,
  0x2B, 0x0D, 0x05, 0xC0, 0xA7, 0x75, 0x0D, 0xD4, 0x01, 0xB8, 0x1E, 0x08, 0xC0, 0x57, 0x73, 0x09,
  0xE5, 0xB0, 0xE2, 0x0C, 0xB0, 0xE0, 0x17, 0x71, 0x04, 0xF5, 0xC2, 0x02, 0xC0, 0x87, 0x70, 0x10,
  0xEF, 0x5C, 0x30, 0x7C, 0x01, 0x76, 0x0A, 0xF9, 0x5B, 0x0E, 0x40, 0xDB, 0x08, 0x75, 0x06, 0xC0,
  0x7C, 0x40, 0x1B, 0x0E, 0x40, 0x6B, 0x0E, 0x74, 0x02, 0x0E, 0xB0, 0xC1, 0xC4, 0x02, 0xB0, 0xC5,
  0x0D, 0xB0, 0x67, 0x30, 0xBB, 0x0E, 0x02, 0x1C, 0x40, 0x4B, 0x0B, 0x50, 0x7B, 0x0B, 0x72, 0x07,
  0xC0, 0x62, 0xC4, 0x06, 0xB0, 0x95, 0x02, 0xC0, 0x17, 0x03, 0xC0, 0xA3, 0xC4, 0x08, 0xB0, 0x76,
  0x0D, 0xB0, 0x57, 0x0C, 0xB0, 0xE0, 0x13, 0xC4, 0x0B, 0xB0, 0x46, 0x08, 0xB0, 0x86, 0x08, 0xFE,
  0x40, 0xEF, 0xF0, 0xA5, 0x04, 0xFF, 0x30, 0x3F, 0xF9, 0x0D, 0x40, 0x10, 0xDF, 0xF3, 0x07, 0xFF,
  0x90, 0xE4, 0x0A, 0xFF, 0x93, 0x0C, 0xFF, 0xA8, 0x09, 0xE6, 0x00, 0xD8, 0x0C, 0x2F, 0x0D, 0x08,
  0x80, 0xC2, 0xF0, 0x80, 0x28, 0x0C, 0x2F, 0x81, 0x20, 0xA8, 0x0C, 0x0F, 0x0A, 0x20, 0x20, 0xEF,
  0xFF, 0xFE, 0x0E, 0x02, 0x30, 0x5C, 0x00, 0x7F, 0xB0, 0x07, 0xFB, 0x00, 0x7C, 0x05, 0x58, 0x26,
  0xFE, 0x52, 0x05, 0x0E, 0xE0, 0xE0, 0x52, 0x05, 0x0E, 0xE0, 0xE0, 0x52, 0x82, 0x5E, 0xF6, 0x70,
  0x35, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x48, 0x61, 0x7C, 0xEE, 0xC7, 0x15, 0x03, 0x80, 0x9A, 0x60,
  0x82, 0x2A, 0xA2, 0x71, 0x82, 0x2A, 0xA2, 0x71, 0x82, 0x2A, 0xA2, 0x72, 0x81, 0x25, 0xAC, 0x86,
  0xA6, 0x21, 0x12, 0x6A, 0xC8, 0x6A, 0x62, 0x11, 0x26, 0xAC, 0x81, 0xA5, 0x23, 0x80, 0x9A, 0x3F,
  0x0B, 0x0A, 0xFB, 0x00, 0xAF, 0xB0, 0xA0, 0xBF, 0xB8, 0x2D, 0xB7, 0x22, 0x89, 0x01, 0x7A, 0xCE,
  0xEC, 0xA7, 0x12, 0x89, 0x01, 0x7A, 0xCE, 0xEC, 0xA7, 0x12, 0x82, 0x27, 0xBD, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_sailing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_sailing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_satellite 48x48, 4-bit Alpha,  RLE, 214 bytes.
static const unsigned char ic_outlined_48_maps_satellite_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x92, 0xD0, 0x12, 0x07,
  0xA0, 0xE7, 0x7F, 0x92, 0xC0, 0xD3, 0x08, 0xA0, 0xD7, 0x7F, 0x92, 0xC0, 0x73, 0x0C, 0xA0, 0xB7,
  0x7F, 0x92, 0xB0, 0xB3, 0x03, 0xB0, 0x67, 0x7F, 0x92, 0x90, 0xD0, 0x74, 0x0B, 0xB0, 0x17, 0x7F,
  0x92, 0x01, 0x50, 0x7B, 0x09, 0x77, 0x1F, 0x97, 0x07, 0xB0, 0xE0, 0x17, 0x71, 0xF9, 0x50, 0x30,
  0xBC, 0x04, 0x77, 0x2F, 0x92, 0x81, 0x78, 0xDD, 0x06, 0x77, 0x3F, 0x92, 0xE0, 0xE0, 0x47, 0x74,
  0xF9, 0x2D, 0x09, 0x01, 0x77, 0x5F, 0x92, 0x83, 0xED, 0xA6, 0x17, 0x77, 0xF9, 0x77, 0x30, 0x50,
  0xC7, 0x2F, 0x97, 0x72, 0x82, 0x2E, 0xF9, 0x71, 0xF9, 0x70, 0x20, 0x37, 0x0C, 0xB0, 0x57, 0xF9,
  0x68, 0x21, 0xDD, 0x15, 0x0A, 0xC0, 0xE0, 0x26, 0xF9, 0x60, 0xAA, 0x0C, 0x40, 0x6E, 0x0C, 0x6F,
  0x95, 0x07, 0xC0, 0xA2, 0x03, 0xF9, 0x09, 0x5F, 0x94, 0x04, 0xE8, 0x17, 0x1D, 0xFA, 0x05, 0x4F,
  0x93, 0x01, 0x0E, 0xF0, 0xCF, 0xB0, 0xE0, 0x23, 0xF9, 0x30, 0xCF, 0xFE, 0x0C, 0x3F, 0x92, 0x09,
  0xFF, 0xF9, 0x09, 0x2F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_satellite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_satellite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_screen_rotation_alt 48x48, 4-bit Alpha,  RLE, 268 bytes.
static const unsigned char ic_outlined_48_maps_screen_rotation_alt_data[] PROGMEM = {
  0x77, 0x83, 0x2A, 0xED, 0x87, 0x77, 0x76, 0x05, 0xD0, 0xD0, 0x17, 0x77, 0x73, 0x05, 0xF0, 0xD0,
  0x17, 0x77, 0x71, 0x05, 0xFA, 0x0D, 0x01, 0x77, 0x76, 0x05, 0xD0, 0x50, 0xAC, 0x0D, 0x01, 0x77,
  0x74, 0x05, 0xD0, 0x52, 0x0A, 0xC0, 0xD0, 0x17, 0x71, 0xC4, 0x05, 0xD0, 0x54, 0x0A, 0xC0, 0xD0,
  0x17, 0x7C, 0x30, 0x5D, 0x05, 0x60, 0xAC, 0x0D, 0x01, 0x76, 0xC2, 0x05, 0xD0, 0x57, 0x10, 0xAC,
  0x0D, 0x01, 0x75, 0xC1, 0x05, 0xD0, 0x57, 0x30, 0xAC, 0x0D, 0x01, 0x74, 0xC0, 0x5D, 0x05, 0x75,
  0x0A, 0xC0, 0xD0, 0x17, 0x3F, 0xA0, 0x57, 0x70, 0xAC, 0x0D, 0x01, 0x72, 0xF9, 0x05, 0x77, 0x20,
  0xAC, 0x0D, 0x01, 0x71, 0xF0, 0x57, 0x74, 0x0A, 0xC0, 0xD0, 0x17, 0xFD, 0x77, 0x10, 0xAC, 0x0D,
  0x01, 0x6F, 0xD7, 0x72, 0x0A, 0xC0, 0xD0, 0x15, 0xFD, 0x77, 0x30, 0xAC, 0x0D, 0x01, 0x4F, 0xD7,
  0x74, 0x0A, 0xC0, 0xD0, 0x18, 0x0A, 0xC2, 0x00, 0x10, 0xDC, 0x0A, 0x77, 0x4F, 0xD4, 0x01, 0x0D,
  0xC0, 0xA7, 0x73, 0xFD, 0x50, 0x10, 0xDC, 0x0A, 0x77, 0x2F, 0xD6, 0x01, 0x0D, 0xC0, 0xA7, 0x71,
  0xFD, 0x70, 0x10, 0xDC, 0x0A, 0x77, 0x40, 0x5F, 0x71, 0x01, 0x0D, 0xC0, 0xA7, 0x72, 0x05, 0xF9,
  0x72, 0x01, 0x0D, 0xC0, 0xA7, 0x70, 0x5F, 0xA7, 0x30, 0x10, 0xDC, 0x0A, 0x75, 0x05, 0xD0, 0x5C,
  0x74, 0x01, 0x0D, 0xC0, 0xA7, 0x30, 0x5D, 0x05, 0x1C, 0x75, 0x01, 0x0D, 0xC0, 0xA7, 0x10, 0x5D,
  0x05, 0x2C, 0x76, 0x01, 0x0D, 0xC0, 0xA6, 0x05, 0xD0, 0x53, 0xC7, 0x70, 0x10, 0xDC, 0x0A, 0x40,
  0x5D, 0x05, 0x4C, 0x77, 0x10, 0x10, 0xDC, 0x0A, 0x20, 0x5D, 0x05, 0x77, 0x74, 0x01, 0x0D, 0xC0,
  0xA0, 0x5D, 0x05, 0x77, 0x76, 0x01, 0x0D, 0xFA, 0x05, 0x77, 0x77, 0x10, 0x10, 0xDF, 0x05, 0x77,
  0x77, 0x30, 0x10, 0xDD, 0x05, 0x77, 0x77, 0x68, 0x38, 0xDE, 0xA2, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_screen_rotation_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_screen_rotation_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_set_meal 48x48, 4-bit Alpha,  RLE, 238 bytes.
static const unsigned char ic_outlined_48_maps_set_meal_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x97, 0x18, 0x93, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x85, 0x17, 0x71, 0xF9, 0x60, 0x30, 0xAF,
  0xE0, 0xA0, 0x37, 0x81, 0x29, 0xC9, 0x2F, 0x94, 0x02, 0x0B, 0xFF, 0xB0, 0xB0, 0x24, 0x08, 0xC2,
  0xF9, 0x30, 0x6F, 0xFF, 0x06, 0x20, 0x8D, 0x2F, 0x92, 0x09, 0xFF, 0xFA, 0x09, 0x02, 0xE2, 0xF9,
  0x10, 0x9F, 0xFF, 0xC0, 0xDE, 0x2F, 0x91, 0x09, 0xFF, 0xFC, 0x0D, 0xE2, 0xF9, 0x20, 0x9F, 0xFF,
  0xA0, 0x90, 0x2E, 0x2F, 0x93, 0x06, 0xFF, 0xF0, 0x62, 0x08, 0xD2, 0xF9, 0x40, 0x20, 0xBF, 0xFB,
  0x0B, 0x02, 0x40, 0x8C, 0x2F, 0x96, 0x03, 0x0A, 0xFE, 0x0A, 0x03, 0x78, 0x12, 0x9C, 0x92, 0xF9,
  0x71, 0x83, 0x14, 0x8B, 0xDA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x1F, 0x98, 0x0C, 0x00, 0xF9, 0x80,
  0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E,
  0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x18, 0x09, 0xD5, 0x08, 0x96,
  0x11, 0x23, 0x35, 0x56, 0x77, 0x99, 0xBB, 0xCD, 0x72, 0x89, 0x71, 0x12, 0x33, 0x55, 0x77, 0x89,
  0x9B, 0xBC, 0xDD, 0xFF, 0xC7, 0x18, 0x0C, 0x0F, 0x01, 0x70, 0xEF, 0xFD, 0x89, 0x6E, 0xDD, 0xBB,
  0xA9, 0x97, 0x75, 0x54, 0x33, 0x17, 0x18, 0xA0, 0xDE, 0xDD, 0xBB, 0x99, 0x87, 0x75, 0x54, 0x33,
  0x11, 0x80, 0x9D, 0x60, 0x80, 0xC0, 0xF7, 0x18, 0x0C, 0x0F, 0x71, 0x80, 0xC0, 0xF4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_set_meal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_set_meal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_signpost 48x48, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_outlined_48_maps_signpost_data[] PROGMEM = {
  0x77, 0x2C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x4F, 0xFF, 0xF0, 0x77,
  0xFF, 0xFF, 0x90, 0x76, 0xFF, 0xFF, 0xA0, 0x75, 0xFF, 0xFF, 0xB0, 0x74, 0xC7, 0x77, 0x10, 0x30,
  0xEC, 0x07, 0x3C, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x72, 0xC7, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x2C,
  0x77, 0x71, 0x03, 0x0E, 0xC0, 0x73, 0xFF, 0xFF, 0xB0, 0x74, 0xFF, 0xFF, 0xA0, 0x75, 0xFF, 0xFF,
  0x90, 0x76, 0xFF, 0xFF, 0x07, 0x77, 0x7C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C,
  0x77, 0x70, 0x7F, 0xFF, 0xF6, 0x07, 0xFF, 0xFF, 0x95, 0x07, 0xFF, 0xFF, 0xA4, 0x07, 0xFF, 0xFF,
  0xB3, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x1C, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x72, 0xC2, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x2C, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0x71, 0xC4, 0x07, 0xFF, 0xFF, 0xB5, 0x07,
  0xFF, 0xFF, 0xA6, 0x07, 0xFF, 0xFF, 0x97, 0x07, 0xFF, 0xFF, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77,
  0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77,
  0x4C, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_signpost() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_signpost_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_snowmobile 48x48, 4-bit Alpha,  RLE, 296 bytes.
static const unsigned char ic_outlined_48_maps_snowmobile_data[] PROGMEM = {
  0x77, 0x71, 0xE0, 0x88, 0x0C, 0x50, 0xF0, 0xA8, 0x0C, 0x40, 0xF9, 0x0B, 0x80, 0xC3, 0x0F, 0xA0,
  0xC0, 0x18, 0x0C, 0x50, 0x01, 0x0C, 0xC0, 0xD0, 0x28, 0x0C, 0x50, 0x03, 0xD0, 0xE0, 0x38, 0x0C,
  0x30, 0x05, 0x0E, 0xE0, 0xE0, 0x38, 0x0C, 0x10, 0x09, 0xFA, 0x0E, 0x04, 0x77, 0x87, 0x3E, 0xCB,
  0x97, 0x54, 0x27, 0x40, 0x20, 0xCD, 0x00, 0x8D, 0x05, 0x76, 0x0B, 0xFA, 0x89, 0x1E, 0xCB, 0x97,
  0x54, 0x20, 0x5E, 0xC0, 0xE0, 0x42, 0x06, 0xD0, 0x57, 0x40, 0x3F, 0xFF, 0xB0, 0xB0, 0x14, 0x05,
  0xD0, 0x67, 0x30, 0xBF, 0xFF, 0xA0, 0x87, 0x05, 0xD0, 0x57, 0x10, 0x3C, 0x85, 0x66, 0x79, 0xBC,
  0xEF, 0xC0, 0xE0, 0x47, 0x20, 0x40, 0xEC, 0x05, 0x70, 0xBB, 0x0D, 0x03, 0x78, 0x91, 0x13, 0x56,
  0x89, 0xBC, 0xEB, 0x17, 0x40, 0x30, 0xEC, 0x04, 0x50, 0x3E, 0x81, 0xE9, 0x57, 0x77, 0x60, 0x30,
  0xEB, 0x0E, 0x02, 0x40, 0xBF, 0xB8, 0x1B, 0x61, 0x77, 0x73, 0x03, 0x0E, 0xB0, 0xC4, 0x81, 0x27,
  0xBF, 0xC8, 0x1C, 0x83, 0x77, 0x71, 0x0B, 0xB0, 0xE7, 0x18, 0x15, 0x9E, 0xFB, 0x81, 0xE9, 0x57,
  0x71, 0x82, 0x15, 0x9E, 0xC0, 0xA7, 0x40, 0x30, 0x9F, 0xFF, 0xFD, 0x0E, 0x02, 0x74, 0x06, 0x0E,
  0xFF, 0xFF, 0xC0, 0xD0, 0x37, 0x30, 0x50, 0xDE, 0x82, 0xD6, 0x9E, 0xFF, 0xF9, 0x0D, 0x07, 0x73,
  0x04, 0x0C, 0xE0, 0xE0, 0x64, 0x81, 0x38, 0xDF, 0xFB, 0x0A, 0x03, 0x73, 0x01, 0x0B, 0xE0, 0xE0,
  0x77, 0x10, 0x1B, 0x0E, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x20, 0x20, 0xEE, 0x08, 0x01, 0x72, 0x05,
  0xB0, 0xC7, 0x20, 0x7C, 0x0E, 0x03, 0x71, 0x0A, 0xD0, 0xA0, 0x27, 0x30, 0x10, 0xDB, 0x08, 0x73,
  0x07, 0xC0, 0xE0, 0x32, 0x01, 0xB0, 0x0E, 0xB0, 0xB0, 0x37, 0x38, 0x11, 0x5D, 0xC0, 0x27, 0x40,
  0x7C, 0x82, 0xE3, 0x1B, 0xB0, 0xC0, 0xEF, 0xFF, 0x09, 0x7F, 0xFB, 0x06, 0x0A, 0xFF, 0xE0, 0xB7,
  0x1F, 0xFA, 0x82, 0xC0, 0x2E, 0xFF, 0xC0, 0x97, 0x2F, 0xF9, 0x0C, 0x01, 0x28, 0x12, 0xAE, 0xFD,
  0x82, 0xEC, 0x82, 0x73, 0xFD, 0x81, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_snowmobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 10, 47, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_snowmobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_sos 48x48, 4-bit Alpha,  RLE, 165 bytes.
static const unsigned char ic_outlined_48_maps_sos_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xF9, 0x48, 0x11, 0xAD, 0xE8, 0x1D, 0xA1, 0x58, 0x11, 0xAD, 0xF9, 0x01, 0x0E,
  0xFB, 0x30, 0x10, 0xEF, 0xB0, 0xE0, 0x13, 0x01, 0x0E, 0xFB, 0x0A, 0xFC, 0x30, 0xAF, 0xD0, 0xA3,
  0x0A, 0xFC, 0x0D, 0xFC, 0x30, 0xDF, 0xD0, 0xD3, 0x0D, 0xFF, 0x97, 0x4C, 0x6C, 0x3C, 0x71, 0xC7,
  0x4C, 0x6C, 0x3C, 0x71, 0xC7, 0x4C, 0x6C, 0x3C, 0x71, 0xC7, 0x4C, 0x6C, 0x3C, 0x71, 0x0D, 0xF8,
  0x1D, 0xA1, 0x4C, 0x6C, 0x30, 0xDF, 0x83, 0xDA, 0x10, 0xAF, 0xA0, 0xE0, 0x13, 0xC6, 0xC3, 0x0A,
  0xFA, 0x82, 0xE1, 0x1E, 0xFA, 0x0A, 0x3C, 0x6C, 0x30, 0x10, 0xEF, 0xA8, 0x3A, 0x01, 0xAD, 0xF0,
  0xD3, 0xC6, 0xC4, 0x81, 0x1A, 0xDF, 0x0D, 0x71, 0xC3, 0xC6, 0xC7, 0x4C, 0x71, 0xC3, 0xC6, 0xC7,
  0x4C, 0x71, 0xC3, 0xC6, 0xC7, 0x4C, 0x71, 0xC3, 0xC6, 0xC7, 0x4F, 0xF9, 0x0D, 0x30, 0xDF, 0xD0,
  0xD3, 0xFC, 0x0D, 0xFC, 0x0A, 0x30, 0xAF, 0xD0, 0xA3, 0xFC, 0x0A, 0xFB, 0x0E, 0x01, 0x30, 0x10,
  0xEF, 0xB0, 0xE0, 0x13, 0xFB, 0x0E, 0x01, 0xF9, 0x81, 0xDA, 0x15, 0x81, 0x1A, 0xDE, 0x81, 0xDA,
  0x14, 0xF9, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_sos() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 14, 45, 33), Box(0, 0, 47, 47),
      ic_outlined_48_maps_sos_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_soup_kitchen 48x48, 4-bit Alpha,  RLE, 335 bytes.
static const unsigned char ic_outlined_48_maps_soup_kitchen_data[] PROGMEM = {
  0x77, 0x77, 0x85, 0x5B, 0xEF, 0xC7, 0x17, 0x77, 0x72, 0x0A, 0xE0, 0xD0, 0x37, 0x77, 0x70, 0x9F,
  0x90, 0xE0, 0x17, 0x77, 0x50, 0x3F, 0xB0, 0x97, 0x77, 0x50, 0x9B, 0x82, 0xD2, 0x08, 0xB0, 0xE7,
  0x77, 0x50, 0xCB, 0x04, 0x30, 0xEB, 0x02, 0x77, 0x74, 0x0D, 0xB0, 0x23, 0x0C, 0xB0, 0x27, 0x77,
  0x4C, 0x40, 0xDB, 0x01, 0x77, 0x73, 0x01, 0xB0, 0xE4, 0x82, 0x8A, 0xCE, 0x77, 0x74, 0x03, 0xB0,
  0xC7, 0x50, 0x7A, 0x08, 0x38, 0x2E, 0xFE, 0x12, 0x07, 0xA0, 0x84, 0x04, 0xB0, 0xB7, 0x50, 0xCA,
  0x02, 0x20, 0x5A, 0x0A, 0x30, 0xCA, 0x02, 0x40, 0x6B, 0x09, 0x75, 0x0E, 0xA3, 0x07, 0xA0, 0x83,
  0x0E, 0xA5, 0x08, 0xB0, 0x77, 0x50, 0xDA, 0x02, 0x20, 0x5A, 0x09, 0x30, 0xDA, 0x01, 0x40, 0x9B,
  0x06, 0x75, 0x09, 0xA0, 0x62, 0x01, 0xA0, 0xD3, 0x09, 0xA0, 0x64, 0x0B, 0xB0, 0x47, 0x50, 0x3A,
  0x0B, 0x30, 0xBA, 0x03, 0x20, 0x3A, 0x0B, 0x40, 0xCB, 0x03, 0x76, 0x0D, 0xA0, 0x12, 0x06, 0xA0,
  0x93, 0x0D, 0xA0, 0x13, 0x0E, 0xB0, 0x17, 0x60, 0x8A, 0x06, 0x20, 0x1A, 0x0E, 0x30, 0x8A, 0x06,
  0x3C, 0x77, 0x04, 0xA0, 0xB3, 0x0B, 0xA0, 0x32, 0x03, 0xA0, 0xB2, 0x02, 0xB0, 0xD7, 0x70, 0x1A,
  0x0E, 0x30, 0x8A, 0x06, 0x3A, 0x0E, 0x20, 0x3B, 0x0B, 0x77, 0x1A, 0x0E, 0x30, 0x8A, 0x07, 0x3A,
  0x0E, 0x20, 0x5B, 0x0A, 0x77, 0x03, 0xA0, 0xC3, 0x0A, 0xA0, 0x42, 0x03, 0xA0, 0xC2, 0x07, 0xB0,
  0x87, 0x70, 0x8A, 0x07, 0x28, 0x21, 0xEF, 0xE3, 0x08, 0xA0, 0x72, 0x08, 0xB0, 0x77, 0x77, 0x75,
  0x0A, 0xB0, 0x57, 0x77, 0x75, 0x0C, 0xB0, 0x37, 0x77, 0x75, 0x0D, 0xB0, 0x27, 0x30, 0x40, 0xDF,
  0xFF, 0xC7, 0x40, 0xDF, 0xFF, 0xC0, 0xE7, 0x40, 0xEF, 0xFF, 0xC0, 0xB7, 0x40, 0xAF, 0xFF, 0xC0,
  0x87, 0x40, 0x6B, 0x0D, 0x77, 0x20, 0x10, 0xEB, 0x03, 0x75, 0x0E, 0xB0, 0x77, 0x71, 0x08, 0xB0,
  0xD7, 0x60, 0x8C, 0x03, 0x76, 0x04, 0xC0, 0x67, 0x60, 0x10, 0xDB, 0x0E, 0x03, 0x74, 0x04, 0x0E,
  0xB0, 0xC7, 0x71, 0x04, 0xD0, 0x77, 0x20, 0x7D, 0x03, 0x77, 0x20, 0x7D, 0x87, 0xD8, 0x31, 0x01,
  0x38, 0xED, 0x05, 0x77, 0x40, 0x7F, 0xFB, 0x06, 0x77, 0x60, 0x40, 0xEF, 0xE0, 0xD0, 0x37, 0x77,
  0x18, 0x11, 0x7E, 0xFA, 0x0E, 0x07, 0x77, 0x76, 0x87, 0x59, 0xCD, 0xFD, 0xC9, 0x47, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_soup_kitchen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_soup_kitchen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_stadium 48x48, 4-bit Alpha,  RLE, 303 bytes.
static const unsigned char ic_outlined_48_maps_stadium_data[] PROGMEM = {
  0x77, 0x40, 0xB0, 0x38, 0x0C, 0x20, 0xA0, 0xB0, 0x37, 0x76, 0x0B, 0x03, 0x77, 0xC0, 0xB0, 0x37,
  0x10, 0xB0, 0x37, 0x1A, 0x0B, 0x03, 0x75, 0xE0, 0xB0, 0x36, 0xA0, 0xB0, 0x36, 0xC0, 0xB0, 0x37,
  0x3E, 0x0B, 0x03, 0x6C, 0x0B, 0x03, 0x4E, 0x0B, 0x03, 0x71, 0xC0, 0xB0, 0x37, 0x1E, 0x0B, 0x03,
  0x2E, 0x0B, 0x03, 0x71, 0xA0, 0xB0, 0x37, 0x3E, 0x0B, 0x03, 0x2C, 0x0B, 0x03, 0x73, 0x0B, 0x03,
  0x75, 0xC0, 0xB0, 0x34, 0xA0, 0xB0, 0x37, 0x77, 0x5A, 0x0B, 0x03, 0x60, 0xB0, 0x37, 0x77, 0x70,
  0xB0, 0x37, 0x71, 0x84, 0x13, 0x68, 0x9B, 0x0F, 0xDC, 0x0F, 0xD8, 0x4B, 0x98, 0x63, 0x17, 0x78,
  0x21, 0x6A, 0xDF, 0xFF, 0x98, 0x2D, 0xA6, 0x17, 0x10, 0x50, 0xBF, 0xFF, 0xFA, 0x0B, 0x05, 0x40,
  0x30, 0xDF, 0xFF, 0xFE, 0x82, 0xD3, 0x04, 0xF9, 0x86, 0xEC, 0x97, 0x53, 0x21, 0x68, 0x61, 0x23,
  0x57, 0x9C, 0xEF, 0x90, 0x40, 0xCD, 0x81, 0xC7, 0x37, 0x77, 0x18, 0x13, 0x7C, 0xD0, 0xCE, 0x81,
  0xB7, 0x37, 0x77, 0x18, 0x13, 0x7B, 0xFF, 0xA8, 0x6C, 0x97, 0x54, 0x21, 0x14, 0x86, 0x11, 0x24,
  0x57, 0x9C, 0x80, 0xE2, 0xF0, 0xCF, 0xFF, 0xFA, 0x0B, 0xF9, 0x18, 0x21, 0x6A, 0xDF, 0xFF, 0x98,
  0x2D, 0xA6, 0x11, 0xF9, 0x58, 0x41, 0x46, 0x89, 0xB0, 0xFD, 0xC0, 0xFD, 0x84, 0xB9, 0x86, 0x41,
  0x5F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x3F, 0xD7, 0x3F, 0x97, 0x3F, 0xD7, 0x3F, 0x97, 0x3F,
  0xD7, 0x3F, 0x97, 0x3F, 0xD7, 0x3F, 0x97, 0x3C, 0x4C, 0x73, 0xF9, 0x09, 0x01, 0x71, 0xC4, 0xC7,
  0x10, 0x10, 0x9C, 0x0D, 0xD8, 0x1C, 0x73, 0x5C, 0x4C, 0x58, 0x13, 0x7C, 0xD0, 0xD0, 0x4F, 0xA8,
  0x2C, 0x97, 0x5C, 0x4C, 0x82, 0x57, 0x9C, 0xFA, 0x82, 0x40, 0x4D, 0xFF, 0x94, 0xFF, 0x90, 0xD0,
  0x44, 0x05, 0x0C, 0xFE, 0x4F, 0xE0, 0xC0, 0x57, 0x18, 0x22, 0x6A, 0xEF, 0xA4, 0xFA, 0x82, 0xEA,
  0x62, 0x77, 0x86, 0x14, 0x68, 0xAB, 0xDD, 0x94, 0x98, 0x6D, 0xDB, 0xA8, 0x64, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_stadium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_stadium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_store_mall_directory 48x48, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_outlined_48_maps_store_mall_directory_data[] PROGMEM = {
  0x2F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x80, 0x98, 0x70, 0x01,
  0xFF, 0xFF, 0xC0, 0x12, 0x04, 0xFF, 0xFF, 0xC0, 0x42, 0x07, 0xFF, 0xFF, 0xC0, 0x72, 0x0A, 0xFF,
  0xFF, 0xC0, 0xA2, 0x0D, 0xB0, 0x27, 0x77, 0x30, 0x2B, 0x81, 0xD0, 0x1B, 0x0E, 0x77, 0x75, 0x0E,
  0xB0, 0x10, 0x4B, 0x0C, 0x77, 0x75, 0x0C, 0xB0, 0x40, 0x7B, 0x09, 0x77, 0x75, 0x09, 0xB0, 0x70,
  0xAB, 0x05, 0x77, 0x75, 0x05, 0xB0, 0xA0, 0xDB, 0x02, 0x77, 0x75, 0x02, 0xB0, 0xD8, 0x0A, 0x94,
  0xF2, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71,
  0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71,
  0xC4, 0xFF, 0xE7, 0x1C, 0x4F, 0xFE, 0x71, 0xC4, 0xFF, 0xE7, 0x1C, 0x4F, 0xFE, 0x71, 0xC2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_store_mall_directory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_store_mall_directory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_straight 48x48, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_48_maps_straight_data[] PROGMEM = {
  0x70, 0x07, 0x76, 0x07, 0xA0, 0x77, 0x40, 0x7C, 0x07, 0x72, 0x07, 0xE0, 0x77, 0x07, 0xF9, 0x07,
  0x50, 0x7F, 0xB0, 0x73, 0x07, 0xFD, 0x81, 0x70, 0x7C, 0x0E, 0xC0, 0xEC, 0x00, 0x7B, 0x0E, 0x03,
  0xC0, 0x30, 0xEB, 0x84, 0x70, 0x7F, 0xE3, 0x1C, 0x18, 0x23, 0xEF, 0x73, 0x07, 0x03, 0x2C, 0x20,
  0x30, 0x77, 0x1C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75,
  0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7,
  0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_straight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(16, 6, 31, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_straight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_streetview 48x48, 4-bit Alpha,  RLE, 250 bytes.
static const unsigned char ic_outlined_48_maps_streetview_data[] PROGMEM = {
  0x77, 0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x77, 0x20, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77,
  0x60, 0x8F, 0xD0, 0x87, 0x77, 0x40, 0x8F, 0xF0, 0x83, 0x81, 0x1A, 0xDF, 0xF0, 0x32, 0x04, 0xFF,
  0xA8, 0x24, 0x01, 0xEF, 0xF9, 0x0C, 0x30, 0xDF, 0xFA, 0x81, 0xD0, 0xAF, 0xFA, 0x07, 0x20, 0x5F,
  0xFC, 0x05, 0x0D, 0xFF, 0xA0, 0x42, 0x0A, 0xFF, 0xC0, 0xAF, 0xFB, 0x01, 0x20, 0xDF, 0xFC, 0x0D,
  0xFF, 0xB3, 0x0E, 0xFF, 0xC0, 0xEF, 0xFB, 0x30, 0xEF, 0xFC, 0x0E, 0xFF, 0xB0, 0x22, 0x0D, 0xFF,
  0xC0, 0xDF, 0xFB, 0x04, 0x20, 0xAF, 0xFC, 0x0A, 0xFF, 0xB0, 0x82, 0x05, 0xFF, 0xC0, 0x5F, 0xFB,
  0x0D, 0x30, 0xDF, 0xFA, 0x0D, 0x1F, 0xFC, 0x04, 0x20, 0x4F, 0xFA, 0x04, 0x1F, 0xFC, 0x0C, 0x30,
  0x8F, 0xF0, 0x82, 0xFF, 0xD0, 0x63, 0x08, 0xFD, 0x08, 0x3F, 0xFE, 0x04, 0x30, 0x40, 0xDF, 0x90,
  0xD0, 0x44, 0xFF, 0xE0, 0x75, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x6F, 0xFD, 0x07, 0x77, 0x6F, 0xFC,
  0x07, 0x77, 0x7F, 0xFB, 0x07, 0x77, 0x71, 0xFF, 0xA0, 0x77, 0x89, 0x21, 0x59, 0xCD, 0xEE, 0xDB,
  0x95, 0x14, 0xFF, 0x90, 0x76, 0x04, 0x0B, 0xFD, 0x4F, 0xF0, 0x75, 0x03, 0x0C, 0xFF, 0x4F, 0xE0,
  0x75, 0x08, 0xFF, 0xA4, 0xFD, 0x07, 0x50, 0x8F, 0xFB, 0x4F, 0xC0, 0x76, 0x0D, 0xFF, 0xB4, 0xFB,
  0x07, 0x7F, 0xFC, 0x4F, 0xA0, 0x77, 0x1F, 0xFC, 0x4F, 0x90, 0x77, 0x2F, 0xFC, 0x4F, 0x07, 0x73,
  0xFF, 0xC4, 0xE0, 0x77, 0x4F, 0xFC, 0x4D, 0x07, 0x75, 0xFF, 0xC4, 0xC0, 0x77, 0x6F, 0xFC, 0x40,
  0xEA, 0x07, 0x77, 0xFF, 0xB0, 0xD4, 0x81, 0xAF, 0x77, 0x71, 0xFF, 0xB0, 0xA4, 0x02, 0x07, 0x77,
  0x2F, 0xFA, 0x0E, 0x01, 0x77, 0x71, 0xFF, 0x81, 0xDA, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_streetview() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_streetview_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_subway 48x48, 4-bit Alpha,  RLE, 279 bytes.
static const unsigned char ic_outlined_48_maps_subway_data[] PROGMEM = {
  0x74, 0x84, 0x47, 0x9B, 0xDD, 0xE8, 0x4D, 0xDB, 0x97, 0x47, 0x75, 0x06, 0x0B, 0xFF, 0xE0, 0xB0,
  0x67, 0x70, 0x70, 0xEF, 0xFF, 0xB0, 0xE0, 0x77, 0x30, 0x20, 0xCF, 0xFF, 0xF0, 0xC0, 0x27, 0x03,
  0x0E, 0xE8, 0x3D, 0x86, 0x43, 0x0F, 0x14, 0x84, 0x12, 0x46, 0x8D, 0xE0, 0xE0, 0x35, 0x02, 0x0E,
  0xC8, 0x1E, 0x72, 0x77, 0x48, 0x12, 0x7E, 0xC0, 0xE0, 0x24, 0x0D, 0xC0, 0x97, 0x77, 0x30, 0x9C,
  0x0D, 0x30, 0x7C, 0x06, 0x77, 0x75, 0x06, 0xC0, 0x72, 0x0E, 0xB0, 0x96, 0x84, 0x27, 0x9C, 0xDE,
  0xB8, 0x5E, 0xDD, 0xB9, 0x72, 0x60, 0x9B, 0x81, 0xE0, 0x5B, 0x0E, 0x50, 0x50, 0xDF, 0xFA, 0x0D,
  0x05, 0x50, 0xEB, 0x05, 0x09, 0xB0, 0x84, 0x08, 0xFF, 0xE0, 0x84, 0x08, 0xB0, 0x90, 0xCB, 0x03,
  0x30, 0x5F, 0xFF, 0x90, 0x53, 0x03, 0xB0, 0xC0, 0xEB, 0x01, 0x30, 0xBF, 0xFF, 0x90, 0xB3, 0x01,
  0xB0, 0xEC, 0x40, 0xEF, 0xFF, 0x90, 0xE4, 0xF9, 0x4A, 0x77, 0x6A, 0x4F, 0x94, 0xA7, 0x76, 0xA4,
  0xF9, 0x4A, 0x77, 0x6A, 0x4F, 0x94, 0xA7, 0x76, 0xA4, 0xF9, 0x4A, 0x77, 0x6A, 0x4F, 0x94, 0xA7,
  0x76, 0xA4, 0xF9, 0x4A, 0x77, 0x6A, 0x4F, 0x94, 0xA7, 0x76, 0xA4, 0xF9, 0x4A, 0x77, 0x6A, 0x4F,
  0x94, 0xA7, 0x76, 0xA4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4B, 0x82, 0xB1,
  0x1B, 0xFB, 0x82, 0xB1, 0x1B, 0xB4, 0xF9, 0x40, 0xEA, 0x01, 0x20, 0x1F, 0xB0, 0x12, 0x01, 0xA0,
  0xE4, 0xF9, 0x40, 0xCA, 0x01, 0x20, 0x1F, 0xB0, 0x12, 0x01, 0xA0, 0xC4, 0xF9, 0x40, 0x6A, 0x82,
  0xB1, 0x1B, 0xFB, 0x82, 0xB1, 0x1B, 0xA0, 0x64, 0xF9, 0x50, 0xCF, 0xFE, 0x0C, 0x5F, 0x95, 0x01,
  0x0C, 0xFF, 0xC0, 0xC0, 0x15, 0xF9, 0x78, 0x16, 0xBE, 0xFD, 0x81, 0xEB, 0x67, 0xF9, 0x71, 0x04,
  0xB0, 0xC6, 0x0C, 0xB0, 0x47, 0x1F, 0x97, 0x04, 0xB0, 0xC7, 0x10, 0xCB, 0x04, 0x7F, 0x97, 0xB0,
  0xC7, 0x30, 0xCB, 0x78, 0x0A, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_subway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_subway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_synagogue 48x48, 4-bit Alpha,  RLE, 280 bytes.
static const unsigned char ic_outlined_48_maps_synagogue_data[] PROGMEM = {
  0x77, 0x70, 0x08, 0x80, 0xC5, 0x00, 0xAA, 0x0A, 0x77, 0x72, 0x84, 0x6C, 0xEE, 0xC6, 0x72, 0x01,
  0x0C, 0xC0, 0xC0, 0x17, 0x28, 0x46, 0xCE, 0xEC, 0x64, 0x01, 0x0C, 0xE0, 0xC0, 0x16, 0x02, 0x0D,
  0xE0, 0xD0, 0x26, 0x01, 0x0C, 0xE0, 0xC0, 0x12, 0x0C, 0xF9, 0x0C, 0x50, 0x40, 0xEF, 0x90, 0xE0,
  0x45, 0x0C, 0xF9, 0x81, 0xC0, 0x6F, 0xB0, 0x63, 0x06, 0xD0, 0x0A, 0xD0, 0x63, 0x06, 0xFB, 0x06,
  0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x20, 0x8D, 0x08, 0x20, 0x8D, 0x08, 0x20, 0xCB, 0x82, 0xB1,
  0x1B, 0xB0, 0xC0, 0xEB, 0x01, 0x20, 0x1B, 0x81, 0xE0, 0xAD, 0x06, 0x40, 0x6D, 0x81, 0xA0, 0xEB,
  0x01, 0x20, 0x1B, 0x0E, 0xC4, 0xC0, 0xCC, 0x0E, 0x04, 0x60, 0x40, 0xEC, 0x0C, 0xC4, 0xF9, 0x4F,
  0x90, 0xD0, 0x27, 0x10, 0x20, 0xDF, 0x94, 0xFF, 0xD0, 0xC0, 0x17, 0x30, 0x10, 0xCF, 0xFF, 0xF9,
  0x0A, 0x58, 0x28, 0xDD, 0x85, 0x0A, 0xFF, 0xFE, 0x08, 0x50, 0x8C, 0x08, 0x50, 0x8F, 0xFF, 0xC0,
  0x66, 0x0D, 0xC0, 0xD6, 0x06, 0xFF, 0xA4, 0xC7, 0x0D, 0xC0, 0xD7, 0xC4, 0xF9, 0x4C, 0x70, 0x8C,
  0x08, 0x7C, 0x4F, 0x94, 0xC7, 0x18, 0x28, 0xDD, 0x87, 0x1C, 0x4F, 0x94, 0xC7, 0x76, 0xC4, 0xF9,
  0x4C, 0x77, 0x6C, 0x4F, 0x94, 0xC7, 0x76, 0xC4, 0xF9, 0x4C, 0x78, 0x46, 0xCE, 0xEC, 0x67, 0xC4,
  0xF9, 0x4C, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x5C, 0x4F, 0x94, 0xC5, 0x0C, 0xF9, 0x0C, 0x5C, 0x4F,
  0x94, 0xC4, 0x06, 0xFB, 0x06, 0x4C, 0x4F, 0x94, 0xC4, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x4C,
  0x4F, 0x94, 0xC4, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4C, 0x4F,
  0x94, 0xC4, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xC4,
  0xF9, 0x4C, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xC4, 0xFF, 0xFB, 0x48, 0x0C, 0x4F,
  0x48, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x4F, 0xFE,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_synagogue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_synagogue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_takeout_dining 48x48, 4-bit Alpha,  RLE, 248 bytes.
static const unsigned char ic_outlined_48_maps_takeout_dining_data[] PROGMEM = {
  0x76, 0x07, 0xFD, 0x07, 0x77, 0x74, 0x07, 0xFF, 0x07, 0x77, 0x72, 0x06, 0xFF, 0xA0, 0x67, 0x77,
  0x06, 0xFF, 0xC0, 0x67, 0x75, 0x06, 0xC0, 0xE0, 0x37, 0x10, 0x30, 0xEC, 0x06, 0x77, 0x30, 0x6C,
  0x0E, 0x03, 0x73, 0x03, 0x0E, 0xC0, 0x67, 0x30, 0x90, 0x53, 0x06, 0xC0, 0xE0, 0x27, 0x50, 0x30,
  0xEC, 0x06, 0x30, 0x40, 0x83, 0x09, 0xA8, 0x15, 0x06, 0xC0, 0xE0, 0x27, 0x70, 0x20, 0xEC, 0x86,
  0x60, 0x4E, 0xF8, 0x09, 0xC0, 0x6C, 0x0D, 0x02, 0x77, 0x20, 0x20, 0xDC, 0x04, 0x0E, 0xB0, 0x80,
  0x5F, 0xA0, 0x27, 0x74, 0x03, 0xFA, 0x81, 0x60, 0x5F, 0x90, 0x27, 0x74, 0x02, 0xF9, 0x05, 0x30,
  0x4F, 0x03, 0x77, 0x40, 0x3F, 0x05, 0x50, 0x40, 0xEF, 0xFF, 0xFB, 0x04, 0x70, 0x30, 0xEF, 0xFF,
  0xF0, 0xE0, 0x47, 0x20, 0x30, 0xEF, 0xFF, 0xD0, 0xE0, 0x37, 0x40, 0x7F, 0xFF, 0xD0, 0x87, 0x50,
  0x6B, 0x09, 0x77, 0x40, 0x8B, 0x06, 0x75, 0x05, 0xB0, 0xA7, 0x74, 0x09, 0xB0, 0x57, 0x50, 0x4B,
  0x0B, 0x77, 0x40, 0xAB, 0x04, 0x75, 0x03, 0xB0, 0xC7, 0x74, 0x0B, 0xB0, 0x37, 0x50, 0x2B, 0x0D,
  0x77, 0x40, 0xDB, 0x02, 0x75, 0x01, 0xB0, 0xE7, 0x74, 0x0E, 0xB0, 0x17, 0x6C, 0x77, 0x4C, 0x77,
  0x0E, 0xB0, 0x17, 0x72, 0x01, 0xB0, 0xE7, 0x70, 0xDB, 0x02, 0x77, 0x20, 0x2B, 0x0D, 0x77, 0x0B,
  0xB0, 0x37, 0x72, 0x03, 0xB0, 0xB7, 0x70, 0xAB, 0x05, 0x77, 0x20, 0x4B, 0x0A, 0x77, 0x09, 0xB0,
  0x67, 0x72, 0x05, 0xB0, 0x97, 0x70, 0x8B, 0x07, 0x77, 0x20, 0x6B, 0x08, 0x77, 0x07, 0xB0, 0x87,
  0x72, 0x07, 0xB0, 0x77, 0x70, 0x6F, 0xFF, 0xB0, 0x67, 0x70, 0x5F, 0xFF, 0xB0, 0x57, 0x70, 0x3F,
  0xFF, 0xB0, 0x37, 0x70, 0x2F, 0xFF, 0xB0, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_takeout_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_takeout_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_taxi_alert 48x48, 4-bit Alpha,  RLE, 282 bytes.
static const unsigned char ic_outlined_48_maps_taxi_alert_data[] PROGMEM = {
  0x77, 0x77, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x77, 0x77, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77,
  0x71, 0x08, 0xFD, 0x08, 0x77, 0x76, 0x08, 0xFF, 0x08, 0x77, 0x74, 0x04, 0xF2, 0xF0, 0x47, 0x77,
  0x30, 0xDF, 0x2F, 0x0D, 0x76, 0xE0, 0x73, 0x05, 0xF9, 0x2F, 0x90, 0x57, 0x5E, 0x03, 0x30, 0x9F,
  0x92, 0xF9, 0x09, 0x75, 0xE0, 0x13, 0x0D, 0xF9, 0x2F, 0x90, 0xD7, 0x5E, 0x40, 0xEF, 0x92, 0xF9,
  0x0E, 0x50, 0x80, 0xEF, 0xC4, 0x0E, 0xF9, 0x2F, 0x90, 0xE4, 0x08, 0xFE, 0x01, 0x30, 0xDF, 0x92,
  0xF9, 0x0D, 0x40, 0xEF, 0xE0, 0x33, 0x09, 0xFF, 0xC0, 0x93, 0x05, 0xFF, 0x07, 0x30, 0x5F, 0xFC,
  0x05, 0x30, 0xAB, 0x08, 0x77, 0x10, 0xDF, 0x2F, 0x0D, 0x30, 0x1C, 0x02, 0x77, 0x10, 0x4F, 0x2F,
  0x04, 0x30, 0x6B, 0x0C, 0x77, 0x30, 0x8F, 0xF0, 0x84, 0x0B, 0xB0, 0x77, 0x74, 0x08, 0xFD, 0x08,
  0x40, 0x1C, 0x02, 0x77, 0x50, 0x40, 0xDF, 0x90, 0xD0, 0x45, 0x06, 0xB0, 0xC7, 0x77, 0x18, 0x65,
  0x9D, 0xEE, 0xD9, 0x57, 0x0C, 0xFF, 0xE0, 0xB0, 0x17, 0x74, 0x02, 0xFF, 0xF9, 0x0D, 0x03, 0x77,
  0x30, 0x7F, 0xFF, 0xB0, 0xA0, 0x27, 0x71, 0x0C, 0xFF, 0xFD, 0x82, 0xC7, 0x42, 0x28, 0x11, 0x46,
  0x6C, 0x77, 0x77, 0xC6, 0xC7, 0x77, 0x7C, 0x6C, 0x38, 0x28, 0xDD, 0x87, 0x78, 0x28, 0xDD, 0x83,
  0xC6, 0xC2, 0x08, 0xC0, 0x87, 0x50, 0x8C, 0x08, 0x2C, 0x6C, 0x20, 0xDC, 0x0D, 0x75, 0x0D, 0xC0,
  0xD2, 0xC6, 0xC2, 0x0D, 0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2C, 0x6C, 0x20, 0x8C, 0x08, 0x75, 0x08,
  0xC0, 0x82, 0xC6, 0xC3, 0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3C, 0x6C, 0x77, 0x77, 0xC6,
  0xC7, 0x77, 0x7C, 0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F, 0x68, 0x0C, 0x0F, 0x6E,
  0x77, 0x73, 0xE6, 0xE7, 0x77, 0x3E, 0x60, 0xDC, 0x0D, 0x77, 0x73, 0x0D, 0xC0, 0xD6, 0x04, 0x0D,
  0xA0, 0xD0, 0x47, 0x77, 0x30, 0x40, 0xDA, 0x0D, 0x04, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_taxi_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_taxi_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_temple_buddhist 48x48, 4-bit Alpha,  RLE, 282 bytes.
static const unsigned char ic_outlined_48_maps_temple_buddhist_data[] PROGMEM = {
  0x77, 0x70, 0x05, 0x80, 0xC5, 0x08, 0x22, 0xEE, 0x28, 0x0C, 0x40, 0x0C, 0xA0, 0xC8, 0x0C, 0x30,
  0x09, 0xC0, 0x98, 0x0C, 0x10, 0x05, 0xE0, 0x57, 0x77, 0x77, 0x02, 0x0E, 0xE0, 0xE0, 0x27, 0x77,
  0x76, 0x0C, 0xB0, 0x0E, 0xB0, 0xC7, 0x77, 0x75, 0x09, 0xC0, 0x05, 0xC0, 0x97, 0x76, 0x0E, 0xB0,
  0x16, 0x05, 0xC0, 0x92, 0x09, 0xC0, 0x56, 0x01, 0xB0, 0xE7, 0x10, 0xDB, 0x05, 0x50, 0x20, 0xEB,
  0x0C, 0x40, 0xCB, 0x0E, 0x02, 0x50, 0x5B, 0x0D, 0x71, 0x09, 0xB0, 0xD0, 0x14, 0x0C, 0xB0, 0xE0,
  0x24, 0x02, 0x0E, 0xB0, 0xC4, 0x01, 0x0D, 0xB0, 0x97, 0x10, 0x2C, 0x83, 0xD5, 0x10, 0x9C, 0x05,
  0x60, 0x5C, 0x83, 0x90, 0x15, 0xDC, 0x02, 0x72, 0x09, 0xFF, 0xFF, 0xC0, 0x97, 0x40, 0xBF, 0xFF,
  0xFA, 0x0B, 0x76, 0x08, 0xFF, 0xFF, 0x08, 0x77, 0x10, 0x20, 0x8F, 0xFF, 0xB0, 0x80, 0x27, 0x10,
  0xEB, 0x01, 0x5C, 0x77, 0x2C, 0x50, 0x1B, 0x0E, 0x0D, 0xB0, 0x55, 0xC7, 0x72, 0xC5, 0x05, 0xB0,
  0xD0, 0x9B, 0x0D, 0x01, 0x4C, 0x77, 0x2C, 0x40, 0x10, 0xDB, 0x09, 0x02, 0xC8, 0x1D, 0x51, 0x2C,
  0x77, 0x2C, 0x28, 0x11, 0x5D, 0xC8, 0x12, 0x09, 0x80, 0xC4, 0xF0, 0x93, 0x0B, 0x80, 0xC2, 0xF0,
  0xB5, 0x08, 0x80, 0xC0, 0xF0, 0x87, 0x02, 0x08, 0xFF, 0xFF, 0xC0, 0x80, 0x27, 0x3C, 0x77, 0x73,
  0xC7, 0x5C, 0x77, 0x73, 0xC7, 0x5C, 0x77, 0x73, 0xC7, 0x5C, 0x77, 0x73, 0xC7, 0x5C, 0x72, 0x84,
  0x6C, 0xEE, 0xC6, 0x72, 0xC7, 0x5C, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x7C, 0x75, 0xC7, 0x0C, 0xF9,
  0x0C, 0x7C, 0x75, 0xC6, 0x06, 0xFB, 0x06, 0x6C, 0x75, 0xC6, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C,
  0x6C, 0x75, 0xC6, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE6, 0xC7, 0x5C, 0x6C, 0x4C, 0x6C, 0x75, 0xC6,
  0xC4, 0xC6, 0xC7, 0x5C, 0x6C, 0x4C, 0x6C, 0x75, 0xC6, 0xC4, 0xC6, 0xC7, 0x5F, 0xF4, 0xFF, 0x75,
  0xFF, 0x4F, 0xF7, 0x5F, 0xF4, 0xFF, 0x75, 0xFF, 0x4F, 0xF6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_temple_buddhist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_temple_buddhist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_temple_hindu 48x48, 4-bit Alpha,  RLE, 218 bytes.
static const unsigned char ic_outlined_48_maps_temple_hindu_data[] PROGMEM = {
  0x77, 0xB0, 0xE4, 0xC7, 0x77, 0x7B, 0x0E, 0x4C, 0x77, 0x77, 0xB0, 0xE4, 0xC7, 0x77, 0x7B, 0x0E,
  0x4C, 0x77, 0x76, 0x02, 0xFD, 0x02, 0x77, 0x75, 0x06, 0xFD, 0x07, 0x77, 0x75, 0x0B, 0xFD, 0x0B,
  0x77, 0x75, 0xFF, 0x01, 0x77, 0x73, 0x05, 0xB0, 0xC6, 0x0C, 0xB0, 0x57, 0x77, 0x30, 0x9B, 0x08,
  0x60, 0x8B, 0x0A, 0x77, 0x73, 0x0E, 0xB0, 0x36, 0x03, 0xB0, 0xE7, 0x77, 0x20, 0x3B, 0x0E, 0x71,
  0x0E, 0xB0, 0x37, 0x77, 0x10, 0x8F, 0xFA, 0x08, 0x77, 0x71, 0x0D, 0xFF, 0xA0, 0xD7, 0x77, 0x02,
  0xFF, 0xC0, 0x27, 0x76, 0x06, 0xFF, 0xC0, 0x77, 0x76, 0x0B, 0xB0, 0x67, 0x30, 0x6B, 0x0B, 0x77,
  0x50, 0x1C, 0x02, 0x73, 0x02, 0xC0, 0x17, 0x74, 0x05, 0xB0, 0xC7, 0x50, 0xCB, 0x05, 0x77, 0x40,
  0xAB, 0x08, 0x75, 0x08, 0xB0, 0xA7, 0x2C, 0x50, 0xEF, 0xFE, 0x0E, 0x5F, 0x94, 0x03, 0xFF, 0xF9,
  0x03, 0x4F, 0x94, 0x08, 0xFF, 0xF9, 0x08, 0x4F, 0x94, 0x0D, 0xFF, 0xF9, 0x0D, 0x4F, 0xFA, 0x77,
  0x2F, 0xFF, 0xA0, 0xB7, 0x72, 0x0B, 0xFF, 0xF9, 0x06, 0x77, 0x20, 0x6F, 0xFF, 0x90, 0x27, 0x72,
  0x02, 0xFF, 0x97, 0x3F, 0xD7, 0x3F, 0x97, 0x3F, 0xD7, 0x3F, 0x97, 0x3F, 0xD7, 0x3F, 0x97, 0x3F,
  0xD7, 0x3F, 0x97, 0x3C, 0x4C, 0x73, 0xF9, 0x73, 0xC4, 0xC7, 0x3F, 0x97, 0x3C, 0x4C, 0x73, 0xF9,
  0x73, 0xC4, 0xC7, 0x3F, 0x97, 0x3C, 0x4C, 0x73, 0xF9, 0x73, 0xC4, 0xC7, 0x3F, 0xFF, 0x94, 0x80,
  0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_temple_hindu() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_temple_hindu_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_terrain 48x48, 4-bit Alpha,  RLE, 198 bytes.
static const unsigned char ic_outlined_48_maps_terrain_data[] PROGMEM = {
  0x77, 0x74, 0x00, 0x58, 0x0C, 0x50, 0x82, 0x2E, 0xE2, 0x80, 0xC4, 0x00, 0xCA, 0x0C, 0x80, 0xC3,
  0x00, 0x9C, 0x09, 0x80, 0xC1, 0x00, 0x5E, 0x05, 0x77, 0x77, 0x70, 0x20, 0xEE, 0x0E, 0x02, 0x77,
  0x77, 0x60, 0xCB, 0x00, 0xEB, 0x0C, 0x77, 0x77, 0x50, 0x9C, 0x00, 0x5C, 0x09, 0x77, 0x77, 0x30,
  0x5C, 0x09, 0x20, 0x9C, 0x05, 0x77, 0x70, 0x20, 0x36, 0x02, 0x0E, 0xB0, 0xC4, 0x0C, 0xB0, 0xE0,
  0x27, 0x76, 0x81, 0xCD, 0x15, 0x0C, 0xB0, 0xE0, 0x24, 0x02, 0x0E, 0xB0, 0xC7, 0x75, 0x09, 0xA0,
  0xB4, 0x03, 0xC0, 0x56, 0x05, 0xC0, 0x97, 0x73, 0x05, 0xC0, 0x74, 0x07, 0xA0, 0x97, 0x10, 0x9C,
  0x05, 0x77, 0x10, 0x20, 0xED, 0x03, 0x40, 0xB0, 0xD7, 0x30, 0xCB, 0x0E, 0x02, 0x77, 0x0C, 0xE0,
  0xD0, 0x13, 0x01, 0x02, 0x73, 0x02, 0x0E, 0xB0, 0xC7, 0x60, 0x9F, 0x90, 0xB7, 0x72, 0x05, 0xC0,
  0x97, 0x40, 0x5C, 0x09, 0x08, 0xC0, 0x77, 0x72, 0x09, 0xC0, 0x57, 0x20, 0x20, 0xEB, 0x0C, 0x20,
  0xBC, 0x03, 0x77, 0x20, 0xCB, 0x0E, 0x02, 0x71, 0x0C, 0xB0, 0xE0, 0x22, 0x01, 0x0E, 0xB0, 0xD0,
  0x17, 0x71, 0x02, 0x0E, 0xB0, 0xC7, 0x09, 0xC0, 0x54, 0x04, 0xC0, 0xA7, 0x72, 0x05, 0xC0, 0x95,
  0x05, 0x80, 0xC2, 0xF0, 0x53, 0x02, 0x0E, 0x80, 0xC2, 0xF0, 0xE0, 0x22, 0x0C, 0x80, 0xC4, 0xF8,
  0x1C, 0x09, 0x80, 0xC6, 0xF0, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_terrain() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 12, 45, 35), Box(0, 0, 47, 47),
      ic_outlined_48_maps_terrain_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_theater_comedy 48x48, 4-bit Alpha,  RLE, 305 bytes.
static const unsigned char ic_outlined_48_maps_theater_comedy_data[] PROGMEM = {
  0x77, 0x6F, 0xFF, 0xB7, 0x76, 0xFF, 0xFB, 0x77, 0x6F, 0xFF, 0xB7, 0x76, 0xFF, 0xFB, 0x77, 0x6C,
  0x77, 0x2C, 0x77, 0x6C, 0x77, 0x2C, 0x77, 0x6C, 0x77, 0x2C, 0x77, 0x6C, 0x28, 0x24, 0xDD, 0x44,
  0x82, 0x4D, 0xD4, 0x2C, 0x77, 0x6C, 0x20, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x2C, 0x77, 0x6C, 0x20,
  0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x2C, 0x77, 0x6C, 0x28, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x2C,
  0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0F, 0xFF, 0xF5, 0x84, 0x6C, 0xEE, 0xB6, 0x5B,
  0x0E, 0xFF, 0xFB, 0x30, 0x10, 0xCE, 0x0C, 0x30, 0x2B, 0x0D, 0xFF, 0xFB, 0x30, 0xAF, 0x90, 0x92,
  0x06, 0xB0, 0xBF, 0xFF, 0xB3, 0x0A, 0x80, 0x4B, 0x0A, 0x20, 0xCB, 0x06, 0xC7, 0x72, 0xC7, 0x70,
  0x6C, 0x01, 0xC7, 0x72, 0xC7, 0x60, 0x4C, 0x09, 0x1C, 0x77, 0x2C, 0x30, 0x77, 0x10, 0x6C, 0x0E,
  0x01, 0x1C, 0x28, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x2C, 0x39, 0x81, 0xD6, 0x22, 0x81, 0x26,
  0xCD, 0x04, 0x2C, 0x20, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x2C, 0x3F, 0xE0, 0x63, 0xC2, 0x0D, 0xA0,
  0xD4, 0x0D, 0xA0, 0xD2, 0xC3, 0xFC, 0x0E, 0x04, 0x4C, 0x28, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4,
  0x2C, 0x3F, 0xB0, 0x90, 0x15, 0xC7, 0x72, 0xC3, 0x89, 0x01, 0x6B, 0xCE, 0xED, 0xA6, 0x17, 0xC7,
  0x72, 0xC7, 0x76, 0xC7, 0x72, 0xC7, 0x76, 0x0E, 0xB3, 0x0D, 0xF9, 0x0D, 0x3B, 0x0E, 0x77, 0x60,
  0xDB, 0x02, 0x20, 0x7F, 0x90, 0x72, 0x02, 0xB0, 0xD7, 0x76, 0x0B, 0xB0, 0x63, 0x09, 0xE0, 0x93,
  0x06, 0xB0, 0xB7, 0x76, 0x06, 0xB0, 0xC4, 0x84, 0x28, 0xAA, 0x82, 0x40, 0xCB, 0x06, 0x77, 0x60,
  0x1C, 0x06, 0x75, 0x06, 0xC0, 0x17, 0x77, 0x09, 0xC0, 0x47, 0x30, 0x4C, 0x09, 0x77, 0x71, 0x01,
  0x0E, 0xC0, 0x67, 0x10, 0x6C, 0x0E, 0x01, 0x77, 0x72, 0x04, 0xD8, 0x1C, 0x62, 0x28, 0x12, 0x6C,
  0xD0, 0x47, 0x77, 0x40, 0x6F, 0xFA, 0x06, 0x77, 0x76, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x77, 0x77,
  0x10, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0x77, 0x74, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA6, 0x17, 0x77,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_theater_comedy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_theater_comedy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_tire_repair 48x48, 4-bit Alpha,  RLE, 387 bytes.
static const unsigned char ic_outlined_48_maps_tire_repair_data[] PROGMEM = {
  0x77, 0x77, 0x28, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x77, 0x76, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x58,
  0x11, 0xAD, 0xFD, 0x81, 0xDA, 0x17, 0x10, 0x8F, 0xD0, 0x83, 0x01, 0x0E, 0xFF, 0xA0, 0xE0, 0x16,
  0x08, 0xFF, 0x08, 0x20, 0xAF, 0xFC, 0x0A, 0x50, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x81, 0x40,
  0xDF, 0xFC, 0x0D, 0x50, 0xDB, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x0D, 0x1D, 0x0E, 0x03, 0x60, 0x30,
  0xED, 0x40, 0x5C, 0x02, 0x60, 0xF2, 0xC0, 0x5E, 0x0E, 0x03, 0x40, 0x30, 0xEE, 0x40, 0x9B, 0x08,
  0x58, 0x46, 0xCF, 0x20, 0x8B, 0x09, 0xF0, 0xE4, 0x0E, 0xF4, 0x0D, 0xB0, 0x33, 0x04, 0x0E, 0xA0,
  0xC2, 0x03, 0xB0, 0xDF, 0x94, 0xF9, 0x40, 0xEB, 0x40, 0xDB, 0x06, 0x3B, 0x0E, 0xC0, 0x7B, 0x4B,
  0x07, 0xC4, 0x0E, 0xB4, 0x0D, 0xA0, 0xE4, 0xB0, 0xEC, 0x10, 0x7A, 0x4A, 0x07, 0x1C, 0x40, 0xDB,
  0x03, 0x38, 0x24, 0xDD, 0x43, 0x03, 0xB0, 0xDC, 0x20, 0x79, 0x49, 0x07, 0x2C, 0x40, 0xAB, 0x08,
  0x73, 0x08, 0xB0, 0xAC, 0x30, 0x74, 0x07, 0x3C, 0x40, 0x5C, 0x02, 0x71, 0x02, 0xC0, 0x5C, 0x03,
  0x73, 0x03, 0xC5, 0x0D, 0xB0, 0xD0, 0x26, 0x02, 0x0D, 0xB0, 0xD1, 0xC0, 0xE0, 0x37, 0x10, 0x30,
  0xEC, 0x50, 0x5D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x05, 0x1D, 0x0E, 0x03, 0x60, 0x30, 0xED, 0x60,
  0x8F, 0xF0, 0x82, 0xE0, 0xE0, 0x34, 0x03, 0x0E, 0xE7, 0x08, 0xFD, 0x08, 0x3F, 0x0E, 0x40, 0xEF,
  0x71, 0x05, 0x0D, 0xF9, 0x0D, 0x05, 0x4F, 0x94, 0xF9, 0x73, 0xF9, 0x6C, 0x07, 0xB4, 0xB0, 0x7C,
  0x73, 0xF9, 0x6C, 0x10, 0x7A, 0x4A, 0x07, 0x1C, 0x73, 0xF9, 0x6C, 0x20, 0x79, 0x49, 0x07, 0x2C,
  0x83, 0xCE, 0xEC, 0x67, 0xC7, 0x1C, 0x30, 0x74, 0x07, 0x3F, 0xA0, 0xC0, 0x15, 0xC7, 0x1C, 0x03,
  0x73, 0x03, 0xFB, 0x0C, 0x5C, 0x71, 0xC0, 0xE0, 0x37, 0x10, 0x30, 0xEF, 0xC0, 0x64, 0xC7, 0x1D,
  0x0E, 0x03, 0x60, 0x30, 0xED, 0x82, 0xB1, 0x1B, 0xB0, 0xC4, 0xC7, 0x1E, 0x0E, 0x03, 0x40, 0x30,
  0xEE, 0x01, 0x20, 0x1B, 0x0E, 0x4C, 0x71, 0xF0, 0xE4, 0x0E, 0xF4, 0xC4, 0xC7, 0x1F, 0x94, 0xF9,
  0x4C, 0x4C, 0x71, 0xC0, 0x7B, 0x4B, 0x07, 0xC4, 0xC4, 0xC7, 0x1C, 0x10, 0x7A, 0x4A, 0x07, 0x1C,
  0x4C, 0x4C, 0x71, 0xC2, 0x07, 0x94, 0x90, 0x72, 0xC4, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x1C,
  0x30, 0x74, 0x07, 0x3C, 0x40, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x10, 0xDF, 0xFC, 0x0D, 0x40,
  0x6F, 0xB0, 0x67, 0x10, 0xAF, 0xFC, 0x0A, 0x50, 0xCF, 0x90, 0xC7, 0x20, 0x10, 0xEF, 0xFA, 0x0E,
  0x01, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x73, 0x81, 0x1A, 0xDF, 0xD8, 0x1D, 0xA1, 0x71, 0x84, 0x6C,
  0xEE, 0xC6, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_tire_repair() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_tire_repair_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_traffic 48x48, 4-bit Alpha,  RLE, 217 bytes.
static const unsigned char ic_outlined_48_maps_traffic_data[] PROGMEM = {
  0x60, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x75, 0x0D, 0xFF, 0xC0, 0xD7, 0x5F, 0xFE, 0x75, 0xFF, 0xE6,
  0x0E, 0xFA, 0x75, 0xFA, 0x0E, 0x0C, 0xFA, 0x75, 0xFA, 0x0C, 0x08, 0xFA, 0x48, 0x28, 0xDD, 0x84,
  0xFA, 0x08, 0x02, 0xFA, 0x30, 0x8C, 0x08, 0x3F, 0xA8, 0x12, 0x08, 0xF9, 0x30, 0xDC, 0x0D, 0x3F,
  0x90, 0x83, 0x0B, 0xF3, 0x0D, 0xC0, 0xD3, 0xF0, 0xB5, 0x08, 0xE3, 0x08, 0xC0, 0x83, 0xE0, 0x87,
  0x02, 0x08, 0xC4, 0x82, 0x8D, 0xD8, 0x4C, 0x08, 0x02, 0x73, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x60,
  0xEF, 0xA7, 0x5F, 0xA0, 0xE0, 0xCF, 0xA4, 0x82, 0x8D, 0xD8, 0x4F, 0xA0, 0xC0, 0x8F, 0xA3, 0x08,
  0xC0, 0x83, 0xFA, 0x08, 0x02, 0xFA, 0x30, 0xDC, 0x0D, 0x3F, 0xA8, 0x12, 0x08, 0xF9, 0x30, 0xDC,
  0x0D, 0x3F, 0x90, 0x83, 0x0B, 0xF3, 0x08, 0xC0, 0x83, 0xF0, 0xB5, 0x08, 0xE4, 0x82, 0x8D, 0xD8,
  0x4E, 0x08, 0x70, 0x20, 0x8C, 0x75, 0xC0, 0x80, 0x27, 0x3C, 0x75, 0xC7, 0x5C, 0x75, 0xC6, 0x0E,
  0xFA, 0x48, 0x28, 0xDD, 0x84, 0xFA, 0x0E, 0x0C, 0xFA, 0x30, 0x8C, 0x08, 0x3F, 0xA0, 0xC0, 0x8F,
  0xA3, 0x0D, 0xC0, 0xD3, 0xFA, 0x08, 0x02, 0xFA, 0x30, 0xDC, 0x0D, 0x3F, 0xA8, 0x12, 0x08, 0xF9,
  0x30, 0x8C, 0x08, 0x3F, 0x90, 0x83, 0x0B, 0xF4, 0x82, 0x8D, 0xD8, 0x4F, 0x0B, 0x50, 0x8E, 0x75,
  0xE0, 0x87, 0x02, 0x08, 0xC7, 0x5C, 0x08, 0x02, 0x73, 0xFF, 0xE7, 0x5F, 0xFE, 0x75, 0x0D, 0xFF,
  0xC0, 0xD7, 0x50, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_traffic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_traffic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_train 48x48, 4-bit Alpha,  RLE, 209 bytes.
static const unsigned char ic_outlined_48_maps_train_data[] PROGMEM = {
  0x78, 0x45, 0x79, 0xBD, 0xDE, 0x84, 0xDD, 0xB9, 0x75, 0x74, 0x05, 0x0B, 0xFF, 0xE0, 0xB0, 0x56,
  0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x30, 0x5F, 0xFF, 0xF8, 0x25, 0x01, 0xED, 0x84, 0xC8, 0x64,
  0x21, 0x68, 0x41, 0x24, 0x68, 0xCD, 0x81, 0xE1, 0x8C, 0x09, 0x01, 0x77, 0x40, 0x10, 0x9C, 0x08,
  0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xEF, 0xFF, 0xFA, 0x0E, 0x80, 0x98, 0x0F, 0x73, 0xC7, 0x3F, 0x97,
  0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73,
  0x80, 0xA8, 0x4F, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x38, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD,
  0x83, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0, 0x82, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0,
  0xD2, 0xF9, 0x20, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD2, 0xF9, 0x20, 0x8C, 0x08, 0x71, 0x08, 0xC0,
  0x82, 0xC0, 0xEB, 0x01, 0x28, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x82, 0x01, 0xB0, 0xE0, 0xCB,
  0x07, 0x77, 0x71, 0x07, 0xB0, 0xC0, 0x7C, 0x07, 0x01, 0x77, 0x40, 0x10, 0x7C, 0x81, 0x71, 0xEF,
  0xFF, 0xF8, 0x2E, 0x10, 0x5F, 0xFF, 0xF0, 0x53, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x05, 0x58, 0x21,
  0x7C, 0xEF, 0xFC, 0x82, 0xEC, 0x71, 0x72, 0x07, 0xC0, 0x77, 0x10, 0x7C, 0x07, 0x74, 0x07, 0xC0,
  0x77, 0x30, 0x7C, 0x07, 0x72, 0x07, 0xC0, 0x77, 0x50, 0x7C, 0x07, 0x71, 0xC0, 0x77, 0x70, 0x7C,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_train() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_train_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_tram 48x48, 4-bit Alpha,  RLE, 172 bytes.
static const unsigned char ic_outlined_48_maps_tram_data[] PROGMEM = {
  0x4F, 0xFE, 0x71, 0xFF, 0xE7, 0x1F, 0xFE, 0x77, 0x30, 0xBB, 0x03, 0x77, 0x71, 0x03, 0xB0, 0xB7,
  0x77, 0x20, 0xBB, 0x03, 0x77, 0x28, 0x42, 0x69, 0xBD, 0xDE, 0x84, 0xDD, 0xB9, 0x62, 0x71, 0x06,
  0x0C, 0xFF, 0xC0, 0xC0, 0x64, 0x01, 0x0C, 0xFF, 0xF9, 0x0C, 0x01, 0x20, 0xCF, 0xFF, 0xB8, 0x1C,
  0x06, 0xD8, 0x3A, 0x64, 0x21, 0x68, 0x31, 0x24, 0x6A, 0xD0, 0x60, 0xCB, 0x0B, 0x01, 0x77, 0x20,
  0x10, 0xBB, 0x0C, 0x0E, 0xFF, 0xFD, 0x0E, 0x80, 0x9A, 0x4F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x4F,
  0x70, 0x8C, 0x08, 0x7F, 0x97, 0x0D, 0xC0, 0xD7, 0xC0, 0xEB, 0x01, 0x60, 0xEC, 0x0E, 0x60, 0x1B,
  0x0E, 0x0C, 0xB0, 0xB0, 0x28, 0x01, 0x10, 0x9C, 0x09, 0x80, 0x11, 0x02, 0x0B, 0xB0, 0xC0, 0x6F,
  0xFF, 0xD8, 0x16, 0x0C, 0xFF, 0xFB, 0x0C, 0x20, 0x10, 0xCF, 0xFF, 0x90, 0xC0, 0x14, 0x06, 0x0B,
  0xFF, 0xC0, 0xB0, 0x67, 0x07, 0xC0, 0x77, 0x10, 0x7C, 0x07, 0x70, 0x7C, 0x07, 0x73, 0x07, 0xC0,
  0x75, 0x07, 0xC0, 0x77, 0x50, 0x7C, 0x07, 0x4C, 0x07, 0x77, 0x07, 0xC2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_tram() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_tram_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_transfer_within_a_station 48x48, 4-bit Alpha,  RLE, 296 bytes.
static const unsigned char ic_outlined_48_maps_transfer_within_a_station_data[] PROGMEM = {
  0x75, 0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x77, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x77, 0x40, 0xAE,
  0x0A, 0x77, 0x77, 0x40, 0xDE, 0x0D, 0x77, 0x77, 0x40, 0xDE, 0x0D, 0x77, 0x77, 0x40, 0xAE, 0x0A,
  0x77, 0x77, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x77, 0x58, 0x41, 0xAD, 0xDA, 0x18, 0x09, 0x83,
  0x08, 0x44, 0xAE, 0xEA, 0x27, 0x77, 0x73, 0x81, 0x17, 0xDD, 0x0E, 0x02, 0x77, 0x77, 0x03, 0x0A,
  0xFA, 0x0B, 0x77, 0x75, 0x06, 0x0C, 0xFD, 0x05, 0x77, 0x72, 0x09, 0x0E, 0xFF, 0x0D, 0x77, 0x72,
  0xF0, 0xEF, 0xA0, 0x97, 0x77, 0x1D, 0x81, 0xA3, 0x9F, 0xB0, 0x67, 0x77, 0xC0, 0x12, 0x0C, 0xFC,
  0x07, 0x77, 0x6C, 0x3F, 0xE0, 0xA0, 0x27, 0x74, 0xC2, 0x03, 0xF8, 0x1E, 0x3E, 0xD8, 0x2A, 0x53,
  0x17, 0x7C, 0x20, 0x6F, 0x82, 0xB0, 0x3E, 0xF9, 0x77, 0xC2, 0x09, 0xF0, 0x82, 0x02, 0x0B, 0xF7,
  0x7C, 0x20, 0xCF, 0x05, 0x40, 0x50, 0xCD, 0x77, 0xC2, 0xF9, 0x02, 0x68, 0x32, 0x8B, 0xCE, 0x77,
  0x50, 0x3F, 0x97, 0x77, 0x73, 0x06, 0xF9, 0x09, 0x76, 0x01, 0x77, 0x20, 0x9F, 0xA0, 0x97, 0x40,
  0x20, 0xD7, 0x72, 0x0C, 0xFB, 0x09, 0x72, 0x02, 0x0D, 0x97, 0x72, 0x0E, 0xB0, 0x90, 0xBE, 0x09,
  0x70, 0x20, 0xDA, 0x77, 0x10, 0x2C, 0x81, 0x50, 0xAE, 0x60, 0x10, 0xDF, 0xF4, 0x05, 0xC0, 0x22,
  0x09, 0xD6, 0x0B, 0xFF, 0x94, 0x08, 0xB0, 0xE4, 0x08, 0xC6, 0x01, 0x0D, 0xFF, 0x40, 0xBB, 0x0B,
  0x5C, 0x70, 0x20, 0xDA, 0x77, 0x10, 0xEB, 0x07, 0x5C, 0x71, 0x02, 0x0D, 0x97, 0x70, 0x2C, 0x04,
  0x5C, 0x72, 0x02, 0x0D, 0x60, 0x77, 0x05, 0xC0, 0x15, 0xC7, 0x30, 0x16, 0x90, 0x76, 0x08, 0xB0,
  0xD6, 0xC7, 0x73, 0xA0, 0x75, 0x0B, 0xB0, 0x96, 0xC6, 0x80, 0x77, 0xB0, 0x74, 0x0E, 0xB0, 0x66,
  0xC6, 0xFF, 0x90, 0x72, 0x01, 0xC0, 0x26, 0xC6, 0xFF, 0x90, 0x72, 0x04, 0xB0, 0xE7, 0xC6, 0x80,
  0x77, 0xB0, 0x73, 0x07, 0xB0, 0xB7, 0xC7, 0x73, 0xA0, 0x74, 0x0A, 0xB0, 0x87, 0xC7, 0x73, 0x90,
  0x75, 0x0D, 0xB0, 0x47, 0xC7, 0x73, 0x07, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_transfer_within_a_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_transfer_within_a_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_transit_enterexit 48x48, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_outlined_48_maps_transit_enterexit_data[] PROGMEM = {
  0x77, 0x50, 0x80, 0x77, 0x77, 0x09, 0xA0, 0x77, 0x75, 0x09, 0xC0, 0x67, 0x73, 0x09, 0xE0, 0x6E,
  0x72, 0x0A, 0xF0, 0x8E, 0x71, 0x0A, 0xF0, 0x91, 0xE7, 0x0A, 0xF0, 0x92, 0xE6, 0x0B, 0xF0, 0x93,
  0xE5, 0x0B, 0xF0, 0x94, 0xE4, 0x0B, 0xF0, 0x95, 0xE2, 0x01, 0x0C, 0xF0, 0xA6, 0xE1, 0x01, 0x0C,
  0xF0, 0xA7, 0xE0, 0x10, 0xCF, 0x0A, 0x71, 0xE0, 0xDF, 0x0A, 0x72, 0xFE, 0x0B, 0x73, 0xFD, 0x0B,
  0x74, 0xFC, 0x0B, 0x75, 0xFB, 0x0B, 0x76, 0xFF, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xFF,
  0xE4, 0xFF, 0xE4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_transit_enterexit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 12, 35, 35), Box(0, 0, 47, 47),
      ic_outlined_48_maps_transit_enterexit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_trip_origin 48x48, 4-bit Alpha,  RLE, 289 bytes.
static const unsigned char ic_outlined_48_maps_trip_origin_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFC, 0x82, 0xD9, 0x42, 0x28, 0x22, 0x49, 0xDF, 0xC0, 0x55, 0x01,
  0x0E, 0xFA, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xFA, 0x0E, 0x01, 0x40, 0x9F, 0xA0, 0xA7, 0x70, 0xAF,
  0xA0, 0x93, 0x01, 0xFA, 0x08, 0x77, 0x20, 0x8F, 0xA0, 0x12, 0x08, 0xF9, 0x0A, 0x77, 0x40, 0xAF,
  0x90, 0x82, 0x0D, 0xF0, 0xD7, 0x76, 0x0D, 0xF8, 0x1D, 0x03, 0xF9, 0x06, 0x77, 0x60, 0x6F, 0x90,
  0x30, 0x7F, 0x0D, 0x77, 0x71, 0x0D, 0xF0, 0x70, 0xAF, 0x09, 0x77, 0x71, 0x09, 0xF0, 0xA0, 0xCF,
  0x04, 0x77, 0x71, 0x04, 0xF0, 0xC0, 0xEF, 0x02, 0x77, 0x71, 0x02, 0xF0, 0xEF, 0x97, 0x77, 0x3F,
  0xFA, 0x77, 0x73, 0xF9, 0x0E, 0xF0, 0x27, 0x77, 0x10, 0x2F, 0x0E, 0x0C, 0xF0, 0x47, 0x77, 0x10,
  0x4F, 0x0C, 0x0A, 0xF0, 0x97, 0x77, 0x10, 0x9F, 0x0A, 0x07, 0xF0, 0xD7, 0x77, 0x10, 0xDF, 0x07,
  0x03, 0xF9, 0x06, 0x77, 0x60, 0x6F, 0x98, 0x13, 0x0D, 0xF0, 0xD7, 0x76, 0x0D, 0xF0, 0xD2, 0x08,
  0xF9, 0x0A, 0x77, 0x40, 0xAF, 0x90, 0x82, 0x01, 0xFA, 0x08, 0x77, 0x20, 0x8F, 0xA0, 0x13, 0x09,
  0xFA, 0x0A, 0x77, 0x0A, 0xFA, 0x09, 0x40, 0x10, 0xEF, 0xA0, 0xD0, 0x67, 0x30, 0x60, 0xDF, 0xA0,
  0xE0, 0x15, 0x05, 0xFC, 0x82, 0xD9, 0x42, 0x28, 0x22, 0x49, 0xDF, 0xC0, 0x57, 0x09, 0xFF, 0xFF,
  0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0,
  0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76,
  0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_trip_origin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_maps_trip_origin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_turn_left 48x48, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_outlined_48_maps_turn_left_data[] PROGMEM = {
  0x70, 0x07, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7C, 0x07, 0x77, 0x70, 0x7C, 0x0E, 0x03,
  0x77, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x60, 0x7F, 0xFF, 0x98, 0x3D,
  0xA1, 0x07, 0xFF, 0xFC, 0x81, 0xE1, 0x7F, 0xFF, 0xD8, 0x1A, 0x07, 0xFF, 0xFC, 0x0D, 0x20, 0x7C,
  0x0E, 0x03, 0x77, 0x1C, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0xC4, 0x07, 0xC0, 0xE0, 0x37, 0x6C, 0x50,
  0x7C, 0x07, 0x76, 0xC6, 0x07, 0xA0, 0x77, 0x7C, 0x70, 0x07, 0x77, 0x1C, 0x77, 0x73, 0xC7, 0x77,
  0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C,
  0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_turn_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 33, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_turn_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_turn_right 48x48, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_outlined_48_maps_turn_right_data[] PROGMEM = {
  0x77, 0x50, 0x07, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7C, 0x07, 0x77, 0x71, 0x03, 0x0E,
  0xC0, 0x77, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x73, 0x81, 0x1A, 0xDF,
  0xFF, 0x98, 0x27, 0x01, 0xEF, 0xFF, 0xC0, 0x70, 0xAF, 0xFF, 0xD0, 0x70, 0xDF, 0xFF, 0xC0, 0x71,
  0xC7, 0x71, 0x03, 0x0E, 0xC0, 0x72, 0xC7, 0x70, 0x30, 0xEC, 0x07, 0x3C, 0x76, 0x03, 0x0E, 0xC0,
  0x74, 0xC7, 0x60, 0x7C, 0x07, 0x5C, 0x77, 0x07, 0xA0, 0x76, 0xC7, 0x71, 0x00, 0x77, 0xC7, 0x77,
  0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C,
  0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_turn_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 12, 41, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_turn_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_turn_sharp_left 48x48, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_outlined_48_maps_turn_sharp_left_data[] PROGMEM = {
  0x70, 0x07, 0x77, 0x76, 0x07, 0xA0, 0x77, 0x77, 0x40, 0x7C, 0x07, 0x77, 0x72, 0x07, 0xE0, 0x77,
  0x77, 0x07, 0xF9, 0x07, 0x77, 0x50, 0x7F, 0xB0, 0x77, 0x73, 0x07, 0xFD, 0x07, 0x77, 0x10, 0x7C,
  0x0E, 0xC0, 0xEC, 0x07, 0x77, 0x07, 0xB0, 0xE0, 0x3C, 0x03, 0x0E, 0xB0, 0x77, 0x71, 0x82, 0x7F,
  0xE3, 0x1C, 0x18, 0x23, 0xEF, 0x77, 0x73, 0x07, 0x03, 0x2C, 0x20, 0x30, 0x77, 0x77, 0x1C, 0x77,
  0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75,
  0xC7, 0x77, 0x5C, 0x77, 0x75, 0x0D, 0xFF, 0xD8, 0x1D, 0xA1, 0x70, 0xAF, 0xFF, 0x0E, 0x01, 0x60,
  0x10, 0xEF, 0xFF, 0x0A, 0x78, 0x11, 0xAD, 0xFF, 0xD0, 0xD7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77,
  0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C,
  0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_turn_sharp_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 35, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_turn_sharp_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_turn_sharp_right 48x48, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_outlined_48_maps_turn_sharp_right_data[] PROGMEM = {
  0x77, 0x70, 0x07, 0x77, 0x76, 0x07, 0xA0, 0x77, 0x77, 0x40, 0x7C, 0x07, 0x77, 0x72, 0x07, 0xE0,
  0x77, 0x77, 0x07, 0xF9, 0x07, 0x77, 0x50, 0x7F, 0xB0, 0x77, 0x73, 0x07, 0xFD, 0x07, 0x77, 0x10,
  0x7C, 0x0E, 0xC0, 0xEC, 0x07, 0x77, 0x07, 0xB0, 0xE0, 0x3C, 0x03, 0x0E, 0xB0, 0x77, 0x71, 0x82,
  0x7F, 0xE3, 0x1C, 0x18, 0x23, 0xEF, 0x77, 0x73, 0x07, 0x03, 0x2C, 0x20, 0x30, 0x77, 0x77, 0x1C,
  0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77,
  0x75, 0xC7, 0x77, 0x5C, 0x78, 0x11, 0xAD, 0xFF, 0xD0, 0xD6, 0x01, 0x0E, 0xFF, 0xF0, 0xA6, 0x0A,
  0xFF, 0xF0, 0xE0, 0x16, 0x0D, 0xFF, 0xD8, 0x1D, 0xA1, 0x7C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77,
  0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75,
  0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_turn_sharp_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_turn_sharp_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_turn_slight_left 48x48, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_outlined_48_maps_turn_slight_left_data[] PROGMEM = {
  0xFC, 0x04, 0x6F, 0xC0, 0x46, 0xFC, 0x04, 0x6F, 0xC0, 0x46, 0xF0, 0x47, 0x3F, 0x90, 0x47, 0x2F,
  0xA0, 0x47, 0x1C, 0x05, 0xD0, 0x47, 0xC1, 0x05, 0xD0, 0x46, 0xC2, 0x05, 0xD0, 0x45, 0xC3, 0x05,
  0xD0, 0x44, 0x80, 0x05, 0x40, 0x5D, 0x04, 0x75, 0x05, 0xD0, 0x47, 0x50, 0x5D, 0x04, 0x75, 0x05,
  0xD0, 0x27, 0x50, 0x5C, 0x0B, 0x76, 0x05, 0xB0, 0xE7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C,
  0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_turn_slight_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 8, 29, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_turn_slight_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_turn_slight_right 48x48, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_48_maps_turn_slight_right_data[] PROGMEM = {
  0x60, 0x4F, 0xC6, 0x04, 0xFC, 0x60, 0x4F, 0xC6, 0x04, 0xFC, 0x73, 0x04, 0xF7, 0x20, 0x4F, 0x97,
  0x10, 0x4F, 0xA7, 0x04, 0xD0, 0x5C, 0x60, 0x4D, 0x05, 0x1C, 0x50, 0x4D, 0x05, 0x2C, 0x40, 0x4D,
  0x05, 0x3C, 0x30, 0x4D, 0x05, 0x48, 0x00, 0x52, 0x04, 0xD0, 0x57, 0x30, 0x4D, 0x05, 0x73, 0x02,
  0xD0, 0x57, 0x40, 0xBC, 0x05, 0x75, 0x0E, 0xB0, 0x57, 0x6C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C,
  0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_turn_slight_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(18, 8, 35, 39), Box(0, 0, 47, 47),
      ic_outlined_48_maps_turn_slight_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_two_wheeler 48x48, 4-bit Alpha,  RLE, 275 bytes.
static const unsigned char ic_outlined_48_maps_two_wheeler_data[] PROGMEM = {
  0x77, 0x4F, 0xA0, 0x58, 0x0C, 0x20, 0xFB, 0x05, 0x80, 0xC1, 0x0F, 0xC0, 0x57, 0x10, 0x30, 0xB7,
  0x77, 0x5F, 0xD0, 0x55, 0x03, 0x0B, 0xA7, 0x77, 0x75, 0x05, 0xD0, 0x52, 0x03, 0x0B, 0xC7, 0x77,
  0x76, 0x05, 0xD0, 0x70, 0xBE, 0x77, 0x77, 0x70, 0x5F, 0xD8, 0x0C, 0x00, 0x05, 0xFC, 0x71, 0xFB,
  0x07, 0x72, 0x03, 0x0B, 0xFE, 0x05, 0x75, 0xFC, 0x07, 0x60, 0x30, 0xBF, 0xFA, 0x05, 0x74, 0xFD,
  0x07, 0x30, 0x30, 0xBF, 0xFD, 0x05, 0x73, 0xFE, 0x81, 0x73, 0xBF, 0xFF, 0x90, 0x57, 0x68, 0x22,
  0x8C, 0xEF, 0xFF, 0xB0, 0x90, 0x5D, 0x83, 0xEE, 0xC8, 0x27, 0x09, 0xFF, 0xFE, 0x82, 0xE1, 0x05,
  0xFA, 0x09, 0x50, 0xBF, 0xFF, 0xF0, 0x62, 0x0A, 0xFB, 0x0B, 0x30, 0x9F, 0xFF, 0xF0, 0xD2, 0x08,
  0xFD, 0x81, 0x90, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xFF, 0xD8, 0x14, 0x02, 0xC8, 0x4D, 0x51, 0x15,
  0xDC, 0x02, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xFF, 0xB0, 0xB2, 0x08, 0xB0, 0xD0, 0x14, 0x01,
  0x0D, 0xB0, 0x80, 0xCB, 0x05, 0x60, 0x5F, 0xFB, 0x02, 0x20, 0xCB, 0x05, 0x60, 0x5B, 0x0C, 0x0E,
  0xB0, 0x16, 0x01, 0xFF, 0xA0, 0x83, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0x0E, 0xB0, 0x16, 0x01, 0xB0,
  0xE0, 0x7F, 0xB0, 0xE0, 0x13, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE0, 0xCB, 0x05, 0x60, 0x5B, 0x81,
  0xC0, 0x7F, 0xA0, 0x64, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC0, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB,
  0x08, 0x20, 0x7F, 0x0D, 0x50, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08, 0x02, 0xC8, 0x4D, 0x51,
  0x15, 0xDC, 0x02, 0x30, 0x7E, 0x04, 0x50, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC8, 0x12, 0x09, 0xFD,
  0x09, 0x77, 0x40, 0x9F, 0xD0, 0x93, 0x0B, 0xFB, 0x0B, 0x77, 0x60, 0xBF, 0xB0, 0xB5, 0x09, 0xF9,
  0x09, 0x77, 0x71, 0x09, 0xF9, 0x09, 0x78, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x77, 0x38, 0x62, 0x8C,
  0xEE, 0xC8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_two_wheeler() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 10, 47, 37), Box(0, 0, 47, 47),
      ic_outlined_48_maps_two_wheeler_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_u_turn_left 48x48, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_outlined_48_maps_u_turn_left_data[] PROGMEM = {
  0x76, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA6, 0x17, 0x74, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x77, 0x10,
  0x40, 0xEF, 0xD0, 0xE0, 0x47, 0x60, 0x6F, 0xFA, 0x06, 0x74, 0x04, 0xD8, 0x1C, 0x62, 0x28, 0x12,
  0x6C, 0xD0, 0x47, 0x20, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x17, 0x10, 0x9C, 0x04, 0x73,
  0x04, 0xC0, 0x97, 0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x60, 0x6B, 0x0C, 0x77, 0x0C, 0xB0, 0x66,
  0x0B, 0xB0, 0x67, 0x70, 0x6B, 0x0B, 0x60, 0xDB, 0x02, 0x77, 0x02, 0xB0, 0xD6, 0x0E, 0xB7, 0x72,
  0xB0, 0xE6, 0xC7, 0x72, 0xC6, 0xC7, 0x72, 0xC6, 0xC7, 0x72, 0xC6, 0xC7, 0x72, 0xC6, 0xC7, 0x72,
  0xC2, 0x07, 0x03, 0x2C, 0x20, 0x30, 0x77, 0x5C, 0x18, 0x27, 0xFE, 0x31, 0xC1, 0x82, 0x3E, 0xF7,
  0x74, 0xC0, 0x7B, 0x0E, 0x03, 0xC0, 0x30, 0xEB, 0x07, 0x73, 0xC0, 0x7C, 0x0E, 0xC0, 0xEC, 0x07,
  0x73, 0xC1, 0x07, 0xFD, 0x07, 0x74, 0xC2, 0x07, 0xFB, 0x07, 0x75, 0xC3, 0x07, 0xF9, 0x07, 0x76,
  0xC4, 0x07, 0xE0, 0x77, 0x7C, 0x50, 0x7C, 0x07, 0x77, 0x1C, 0x60, 0x7A, 0x07, 0x77, 0x2C, 0x70,
  0x07, 0x77, 0x3C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7,
  0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_u_turn_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 35, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_u_turn_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_u_turn_right 48x48, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_outlined_48_maps_u_turn_right_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x77, 0x40, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0x71, 0x04,
  0x0E, 0xFD, 0x0E, 0x04, 0x76, 0x06, 0xFF, 0xA0, 0x67, 0x40, 0x4D, 0x81, 0xC6, 0x22, 0x81, 0x26,
  0xCD, 0x04, 0x72, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C, 0x0E, 0x01, 0x71, 0x09, 0xC0, 0x47, 0x30,
  0x4C, 0x09, 0x70, 0x1C, 0x06, 0x75, 0x06, 0xC0, 0x16, 0x06, 0xB0, 0xC7, 0x70, 0xCB, 0x06, 0x60,
  0xBB, 0x06, 0x77, 0x06, 0xB0, 0xB6, 0x0D, 0xB0, 0x27, 0x70, 0x2B, 0x0D, 0x60, 0xEB, 0x77, 0x2B,
  0x0E, 0x6C, 0x77, 0x2C, 0x6C, 0x77, 0x2C, 0x6C, 0x77, 0x2C, 0x6C, 0x77, 0x2C, 0x6C, 0x77, 0x2C,
  0x6C, 0x75, 0x07, 0x03, 0x2C, 0x20, 0x30, 0x72, 0xC7, 0x48, 0x27, 0xFE, 0x31, 0xC1, 0x82, 0x3E,
  0xF7, 0x1C, 0x73, 0x07, 0xB0, 0xE0, 0x3C, 0x03, 0x0E, 0xB0, 0x7C, 0x73, 0x07, 0xC0, 0xEC, 0x0E,
  0xC0, 0x7C, 0x74, 0x07, 0xFD, 0x07, 0x1C, 0x75, 0x07, 0xFB, 0x07, 0x2C, 0x76, 0x07, 0xF9, 0x07,
  0x3C, 0x77, 0x07, 0xE0, 0x74, 0xC7, 0x71, 0x07, 0xC0, 0x75, 0xC7, 0x72, 0x07, 0xA0, 0x76, 0xC7,
  0x73, 0x00, 0x77, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75, 0xC7, 0x77, 0x5C,
  0x77, 0x75, 0xC7, 0x77, 0x5C, 0x77, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_u_turn_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_u_turn_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_volunteer_activism 48x48, 4-bit Alpha,  RLE, 337 bytes.
static const unsigned char ic_outlined_48_maps_volunteer_activism_data[] PROGMEM = {
  0x77, 0x78, 0x53, 0x9D, 0xFD, 0xA5, 0x48, 0x55, 0xAD, 0xFD, 0x93, 0x77, 0x72, 0x08, 0xF8, 0x2B,
  0x11, 0xBF, 0x08, 0x77, 0x70, 0x8F, 0xA0, 0x0D, 0xFA, 0x08, 0x77, 0x50, 0x3F, 0xFF, 0x90, 0x37,
  0x74, 0x09, 0xB8, 0x3D, 0x40, 0x3B, 0xE8, 0x3A, 0x30, 0x4D, 0xB0, 0x97, 0x74, 0x0D, 0xB0, 0x44,
  0x0A, 0xC0, 0xA4, 0x04, 0xB0, 0xD7, 0x74, 0xC6, 0x0C, 0xA0, 0xC6, 0xC7, 0x74, 0x0D, 0xB0, 0x35,
  0x82, 0x1D, 0xD1, 0x50, 0x3B, 0x0D, 0x77, 0x40, 0xAB, 0x0A, 0x60, 0x03, 0x60, 0xAB, 0x0A, 0x77,
  0x40, 0x3C, 0x04, 0x75, 0x04, 0xC0, 0x37, 0x75, 0x0B, 0xB0, 0xE0, 0x27, 0x30, 0x20, 0xEB, 0x0B,
  0x77, 0x60, 0x2C, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xC0, 0x27, 0x77, 0x06, 0xC0, 0xC7, 0x01, 0x0C,
  0xC0, 0x67, 0x77, 0x20, 0x9C, 0x0B, 0x60, 0xBC, 0x09, 0x77, 0x74, 0x0B, 0xC0, 0xB4, 0x0B, 0xC0,
  0xB7, 0x77, 0x60, 0xCC, 0x82, 0xC1, 0x1C, 0xC0, 0xC7, 0x77, 0x70, 0x10, 0xCC, 0x00, 0xCC, 0x0C,
  0x01, 0x77, 0x77, 0x20, 0xCF, 0x90, 0xC7, 0xFF, 0xA8, 0x1C, 0x61, 0x70, 0xBE, 0x0B, 0x71, 0xFF,
  0xD0, 0xA0, 0x46, 0x0A, 0xC0, 0xA7, 0x2F, 0xFF, 0x81, 0xE8, 0x24, 0x09, 0xA0, 0x97, 0x3F, 0xFF,
  0xB8, 0x1C, 0x61, 0x20, 0x08, 0x74, 0xC4, 0xC3, 0x81, 0x17, 0xDF, 0xA0, 0xA0, 0x47, 0x6C, 0x4C,
  0x68, 0x13, 0x9E, 0xF9, 0x0A, 0x75, 0xC4, 0xC7, 0x20, 0x50, 0xBF, 0x0B, 0x74, 0xC4, 0xC7, 0x48,
  0x11, 0x7C, 0xD0, 0x57, 0x3C, 0x4C, 0x68, 0x16, 0x94, 0x50, 0x30, 0xBB, 0x0B, 0x73, 0xC4, 0xC6,
  0x0C, 0xA8, 0x5E, 0x94, 0x21, 0x01, 0xB0, 0xE7, 0x3C, 0x4C, 0x50, 0x2F, 0xFC, 0x81, 0xEC, 0x63,
  0xC4, 0xC5, 0x07, 0xFF, 0xF0, 0xC0, 0x11, 0xC4, 0xC6, 0x81, 0x49, 0xEF, 0xFD, 0x0C, 0x1C, 0x4C,
  0x72, 0x82, 0x49, 0xCE, 0xFF, 0xA0, 0x6C, 0x4C, 0x77, 0x73, 0x01, 0x0B, 0xB0, 0xCC, 0x4C, 0x82,
  0xD9, 0x51, 0x77, 0x58, 0x12, 0x7C, 0xB0, 0xEC, 0x4F, 0x98, 0x1C, 0x73, 0x76, 0x81, 0x38, 0xDF,
  0xC4, 0xFC, 0x82, 0xEA, 0x62, 0x68, 0x14, 0x9D, 0xFF, 0xFF, 0xD8, 0x4D, 0x94, 0x5A, 0xEF, 0xB8,
  0x1B, 0x72, 0xFD, 0x81, 0x38, 0xCF, 0xFF, 0x81, 0xB6, 0x13, 0xFD, 0x38, 0x21, 0x59, 0xEF, 0xE8,
  0x1E, 0xA5, 0x7F, 0xD7, 0x81, 0x37, 0xBF, 0x81, 0xD9, 0x47, 0x77, 0x75, 0x84, 0x49, 0xDD, 0x83,
  0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_volunteer_activism() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 43, 44), Box(0, 0, 47, 47),
      ic_outlined_48_maps_volunteer_activism_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_warehouse 48x48, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_outlined_48_maps_warehouse_data[] PROGMEM = {
  0x77, 0x48, 0x26, 0xCC, 0x67, 0x77, 0x75, 0x81, 0x39, 0xEC, 0x81, 0xE9, 0x37, 0x77, 0x70, 0x60,
  0xCF, 0xB0, 0xC0, 0x67, 0x77, 0x28, 0x13, 0x9E, 0xFF, 0x81, 0xE9, 0x37, 0x74, 0x06, 0x0C, 0xF9,
  0x82, 0xD7, 0x7D, 0xF9, 0x0C, 0x06, 0x76, 0x81, 0x39, 0xEF, 0x90, 0xA0, 0x44, 0x04, 0x0A, 0xF9,
  0x81, 0xE9, 0x37, 0x10, 0x60, 0xCF, 0x98, 0x1D, 0x71, 0x71, 0x81, 0x17, 0xDF, 0x90, 0xC0, 0x63,
  0x81, 0x39, 0xEF, 0x90, 0xA0, 0x47, 0x70, 0x40, 0xAF, 0x98, 0x1E, 0x93, 0xF9, 0x81, 0xD7, 0x17,
  0x74, 0x81, 0x17, 0xDF, 0xF0, 0xA0, 0x47, 0x77, 0x30, 0x40, 0xAF, 0xB0, 0x70, 0x17, 0x77, 0x70,
  0x10, 0x7F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x97, 0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9,
  0x4F, 0xFF, 0xB4, 0xF9, 0x4C, 0x77, 0x2C, 0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xF9, 0x4C, 0x77, 0x2C,
  0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xF9, 0x4C, 0x77, 0x2C, 0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xF9, 0x4C,
  0x6C, 0x6C, 0x4F, 0x94, 0xC6, 0xC6, 0xC4, 0xF9, 0x4C, 0x6C, 0x6C, 0x4F, 0x94, 0xC6, 0xC6, 0xC4,
  0xF9, 0x4C, 0x77, 0x2C, 0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xFF, 0xA2, 0xC4, 0xC2, 0xFF, 0xFB, 0x2C,
  0x4C, 0x2F, 0xFF, 0xB2, 0xC4, 0xC2, 0xFF, 0xFB, 0x2C, 0x4C, 0x2F, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_warehouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_warehouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_wine_bar 48x48, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_outlined_48_maps_wine_bar_data[] PROGMEM = {
  0x80, 0x9C, 0x0F, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97,
  0x72, 0x80, 0xE0, 0xF0, 0xEF, 0xFF, 0x90, 0xE0, 0xDF, 0xFF, 0x90, 0xD0, 0xBB, 0x07, 0x77, 0x07,
  0xB0, 0xB0, 0x6B, 0x0D, 0x77, 0x0D, 0xB0, 0x60, 0x1C, 0x06, 0x75, 0x06, 0xC8, 0x11, 0x09, 0xC0,
  0x47, 0x30, 0x4C, 0x09, 0x20, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x13, 0x05, 0xD8, 0x1C,
  0x62, 0x28, 0x12, 0x6C, 0xD0, 0x55, 0x06, 0xFF, 0xA0, 0x67, 0x05, 0x0E, 0xFD, 0x0E, 0x05, 0x72,
  0x01, 0x09, 0xFB, 0x09, 0x01, 0x75, 0x81, 0x16, 0xAC, 0x81, 0xA6, 0x17, 0x73, 0xC7, 0x76, 0xC7,
  0x76, 0xC7, 0x76, 0xC7, 0x76, 0xC7, 0x76, 0xC7, 0x76, 0xC7, 0x76, 0xC7, 0x7F, 0xFA, 0x71, 0xFF,
  0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_wine_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 6, 35, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_wine_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_wrong_location 48x48, 4-bit Alpha,  RLE, 343 bytes.
static const unsigned char ic_outlined_48_maps_wrong_location_data[] PROGMEM = {
  0x77, 0x74, 0x0B, 0x05, 0x60, 0x50, 0xB7, 0x77, 0x50, 0xBA, 0x05, 0x40, 0x5A, 0x0B, 0x77, 0x73,
  0x0B, 0xC0, 0x52, 0x05, 0xC0, 0xB7, 0x48, 0x54, 0x9B, 0xDE, 0xFD, 0x50, 0x5D, 0x00, 0x5D, 0x05,
  0x71, 0x81, 0x19, 0xEF, 0x60, 0x5F, 0xB0, 0x57, 0x10, 0x8F, 0xB7, 0x05, 0xF9, 0x05, 0x70, 0x10,
  0xCF, 0xC7, 0x10, 0x5E, 0x05, 0x70, 0x30, 0xED, 0x82, 0xD8, 0x42, 0x20, 0x17, 0x10, 0x5E, 0x05,
  0x60, 0x10, 0xEC, 0x0D, 0x05, 0x77, 0x05, 0xF9, 0x05, 0x50, 0xCC, 0x09, 0x77, 0x10, 0x5F, 0xB0,
  0x53, 0x07, 0xC0, 0x77, 0x71, 0x05, 0xD0, 0x05, 0xD8, 0x25, 0x01, 0xEB, 0x0A, 0x77, 0x20, 0xBC,
  0x05, 0x20, 0x5C, 0x81, 0xB0, 0x9B, 0x0D, 0x77, 0x40, 0xBA, 0x05, 0x40, 0x5A, 0x0B, 0x20, 0xEB,
  0x06, 0x77, 0x50, 0xB0, 0x56, 0x05, 0x0B, 0x20, 0x3B, 0x0D, 0x77, 0x77, 0x40, 0x8B, 0x09, 0x71,
  0x84, 0x1A, 0xDD, 0xA1, 0x77, 0x40, 0xBB, 0x05, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x30, 0xDB,
  0x02, 0x70, 0xAE, 0x0A, 0x77, 0x30, 0xEB, 0x01, 0x70, 0xDE, 0x0D, 0x77, 0x3C, 0x71, 0x0D, 0xE0,
  0xD7, 0x1C, 0x50, 0xDB, 0x01, 0x70, 0xAE, 0x0A, 0x70, 0x1B, 0x0D, 0x50, 0xCB, 0x04, 0x70, 0x10,
  0xEC, 0x0E, 0x01, 0x70, 0x4B, 0x0C, 0x50, 0x9B, 0x08, 0x71, 0x84, 0x1A, 0xDD, 0xA1, 0x71, 0x08,
  0xB0, 0x95, 0x04, 0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x04, 0x60, 0xEB, 0x04, 0x77, 0x60, 0x4B, 0x0E,
  0x70, 0x9B, 0x0C, 0x77, 0x60, 0xCB, 0x09, 0x70, 0x2C, 0x05, 0x77, 0x40, 0x5C, 0x02, 0x71, 0x0A,
  0xB0, 0xD0, 0x17, 0x72, 0x01, 0x0D, 0xB0, 0xA7, 0x20, 0x10, 0xEB, 0x0A, 0x77, 0x20, 0xAB, 0x0E,
  0x01, 0x73, 0x07, 0xC0, 0x57, 0x70, 0x5C, 0x07, 0x75, 0x0C, 0xB0, 0xE0, 0x37, 0x50, 0x30, 0xEB,
  0x0C, 0x76, 0x02, 0x0E, 0xB0, 0xD0, 0x17, 0x30, 0x10, 0xDB, 0x0E, 0x02, 0x77, 0x05, 0xC0, 0xC7,
  0x30, 0xCC, 0x05, 0x77, 0x20, 0x8C, 0x0B, 0x71, 0x0B, 0xC0, 0x87, 0x74, 0x0A, 0xC0, 0xA6, 0x0A,
  0xC0, 0xA7, 0x76, 0x0B, 0xC0, 0xA4, 0x0A, 0xC0, 0xB7, 0x77, 0x01, 0x0C, 0xC0, 0xB2, 0x0B, 0xC0,
  0xC0, 0x17, 0x77, 0x10, 0x10, 0xCC, 0x00, 0xBC, 0x0C, 0x01, 0x77, 0x73, 0x01, 0x0C, 0xF9, 0x0C,
  0x01, 0x77, 0x75, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x71, 0x0B, 0xC0, 0xB7, 0x77, 0x74, 0x0A,
  0xA0, 0xA7, 0x77, 0x76, 0x00, 0x87, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_wrong_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 3, 44, 45), Box(0, 0, 47, 47),
      ic_outlined_48_maps_wrong_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_zoom_in_map 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_outlined_48_maps_zoom_in_map_data[] PROGMEM = {
  0x20, 0xA0, 0x57, 0x77, 0x72, 0x05, 0x0A, 0x30, 0xAA, 0x05, 0x4C, 0x75, 0xC4, 0x05, 0xA8, 0x1A,
  0x0A, 0xC0, 0x53, 0xC7, 0x5C, 0x30, 0x5C, 0x0A, 0x05, 0xD0, 0x52, 0xC7, 0x5C, 0x20, 0x5D, 0x81,
  0x50, 0x5D, 0x05, 0x1C, 0x75, 0xC1, 0x05, 0xD0, 0x53, 0x05, 0xD0, 0x5C, 0x75, 0xC0, 0x5D, 0x05,
  0x50, 0x5F, 0xA7, 0x5F, 0xA0, 0x57, 0x05, 0xF9, 0x75, 0xF9, 0x05, 0x72, 0x05, 0xF7, 0x5F, 0x05,
  0x6F, 0xD7, 0x5F, 0xD2, 0xFD, 0x75, 0xFD, 0x2F, 0xD7, 0x5F, 0xD2, 0xFD, 0x75, 0xFD, 0x80, 0xF8,
  0x60, 0xFD, 0x75, 0xFD, 0x2F, 0xD7, 0x5F, 0xD2, 0xFD, 0x75, 0xFD, 0x2F, 0xD7, 0x5F, 0xD6, 0x05,
  0xF7, 0x5F, 0x05, 0x72, 0x05, 0xF9, 0x75, 0xF9, 0x05, 0x70, 0x5F, 0xA7, 0x5F, 0xA0, 0x55, 0x05,
  0xD0, 0x5C, 0x75, 0xC0, 0x5D, 0x05, 0x30, 0x5D, 0x05, 0x1C, 0x75, 0xC1, 0x05, 0xD8, 0x15, 0x05,
  0xD0, 0x52, 0xC7, 0x5C, 0x20, 0x5D, 0x05, 0x0A, 0xC0, 0x53, 0xC7, 0x5C, 0x30, 0x5C, 0x81, 0xA0,
  0xAA, 0x05, 0x4C, 0x75, 0xC4, 0x05, 0xA0, 0xA3, 0x0A, 0x05, 0x77, 0x77, 0x20, 0x50, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_zoom_in_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 42, 42), Box(0, 0, 47, 47),
      ic_outlined_48_maps_zoom_in_map_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_maps_zoom_out_map 48x48, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_outlined_48_maps_zoom_out_map_data[] PROGMEM = {
  0xFC, 0x07, 0x75, 0x07, 0xFF, 0xF0, 0x77, 0x70, 0x7F, 0xFD, 0x07, 0x77, 0x20, 0x7F, 0xFB, 0x07,
  0x77, 0x40, 0x7F, 0xF9, 0x0A, 0x77, 0x60, 0xAF, 0xF9, 0x05, 0x77, 0x40, 0x5F, 0xFB, 0x05, 0x77,
  0x20, 0x5F, 0xE0, 0xAD, 0x05, 0x77, 0x05, 0xD0, 0xAF, 0x81, 0x70, 0x5D, 0x05, 0x75, 0x05, 0xD8,
  0x15, 0x07, 0xD0, 0x73, 0x05, 0xD0, 0x57, 0x30, 0x5D, 0x05, 0x30, 0x7B, 0x07, 0x50, 0x5C, 0x0D,
  0x73, 0x0D, 0xC0, 0x55, 0x81, 0x7F, 0x77, 0x05, 0xA0, 0xD0, 0x27, 0x30, 0x20, 0xDA, 0x05, 0x70,
  0x77, 0x28, 0x15, 0xD2, 0x75, 0x81, 0x2D, 0x58, 0x0D, 0xE6, 0x08, 0x15, 0xD2, 0x75, 0x81, 0x2D,
  0x57, 0x20, 0x77, 0x05, 0xA0, 0xD0, 0x27, 0x30, 0x20, 0xDA, 0x05, 0x78, 0x17, 0xF7, 0x50, 0x5C,
  0x0D, 0x73, 0x0D, 0xC0, 0x55, 0x07, 0xB0, 0x73, 0x05, 0xD0, 0x57, 0x30, 0x5D, 0x05, 0x30, 0x7D,
  0x81, 0x70, 0x5D, 0x05, 0x75, 0x05, 0xD8, 0x15, 0x07, 0xF0, 0xAD, 0x05, 0x77, 0x05, 0xD0, 0xAF,
  0xE0, 0x57, 0x72, 0x05, 0xFF, 0xB0, 0x57, 0x74, 0x05, 0xFF, 0x90, 0xA7, 0x76, 0x0A, 0xFF, 0x90,
  0x77, 0x74, 0x07, 0xFF, 0xB0, 0x77, 0x72, 0x07, 0xFF, 0xD0, 0x77, 0x70, 0x7F, 0xFF, 0x07, 0x75,
  0x07, 0xFC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_maps_zoom_out_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_maps_zoom_out_map_data, Alpha4(color::Black));
  return value;
}
