#include "device.h"

using namespace roo_display;

// Image file ic_outlined_48_device_1x_mobiledata 48x48, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_outlined_48_device_1x_mobiledata_data[] PROGMEM = {
  0xF9, 0x50, 0x5C, 0x04, 0x50, 0x9B, 0x0E, 0x01, 0xF9, 0x60, 0xBB, 0x0D, 0x40, 0x3C, 0x06, 0x1F,
  0x96, 0x02, 0xC0, 0x73, 0x0C, 0xB0, 0xC2, 0xF9, 0x70, 0x8C, 0x81, 0x20, 0x6C, 0x03, 0x6C, 0x71,
  0x0E, 0xB8, 0x1B, 0x1E, 0xB0, 0x97, 0xC7, 0x10, 0x5C, 0x0C, 0xB0, 0xE0, 0x17, 0xC7, 0x20, 0xBF,
  0x06, 0x71, 0xC7, 0x20, 0x2E, 0x0C, 0x72, 0xC7, 0x30, 0x8D, 0x03, 0x72, 0xC7, 0x30, 0x2C, 0x0C,
  0x73, 0xC7, 0x30, 0x9D, 0x04, 0x72, 0xC7, 0x20, 0x3E, 0x0D, 0x72, 0xC7, 0x20, 0xCF, 0x07, 0x71,
  0xC7, 0x10, 0x6C, 0x0B, 0xB0, 0xE0, 0x27, 0xC7, 0x01, 0x0E, 0xB8, 0x19, 0x0E, 0xB0, 0xA7, 0xC7,
  0x09, 0xB8, 0x2E, 0x10, 0x5C, 0x04, 0x6C, 0x60, 0x3C, 0x06, 0x30, 0xBB, 0x0D, 0x6C, 0x60, 0xCB,
  0x0C, 0x40, 0x2C, 0x07, 0x5C, 0x50, 0x6C, 0x03, 0x50, 0x8B, 0x0E, 0x02, 0x4C, 0x40, 0x10, 0xEB,
  0x09, 0x60, 0x10, 0xEB, 0x0A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_1x_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 14, 37, 33), Box(0, 0, 47, 47),
      ic_outlined_48_device_1x_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_30fps 48x48, 4-bit Alpha,  RLE, 169 bytes.
static const unsigned char ic_outlined_48_device_30fps_data[] PROGMEM = {
  0xFD, 0x81, 0xEC, 0x67, 0x18, 0x16, 0xCE, 0xF9, 0x81, 0xEC, 0x63, 0xFF, 0x90, 0xC0, 0x14, 0x01,
  0x0C, 0xFF, 0x0C, 0x01, 0x1F, 0xFA, 0x0C, 0x40, 0xCF, 0xFA, 0x0C, 0x1F, 0xFB, 0x06, 0x20, 0x6F,
  0xFC, 0x06, 0xFF, 0xB0, 0xC2, 0x0C, 0xFF, 0xC0, 0xCF, 0xFB, 0x0E, 0x20, 0xEF, 0xFC, 0x0E, 0x75,
  0xE2, 0xE7, 0x1E, 0x75, 0xE2, 0xE7, 0x1E, 0x75, 0xE2, 0xE7, 0x1E, 0x75, 0xE2, 0xE7, 0x1E, 0x75,
  0xD0, 0xD2, 0xE7, 0x1E, 0x2F, 0xF9, 0x09, 0x2E, 0x71, 0xE2, 0xFF, 0x0D, 0x3E, 0x71, 0xE2, 0xFD,
  0x0D, 0x09, 0x4E, 0x71, 0xE2, 0xFD, 0x0D, 0x09, 0x4E, 0x71, 0xE2, 0xFF, 0x0D, 0x3E, 0x71, 0xE2,
  0xFF, 0x90, 0x92, 0xE7, 0x1E, 0x75, 0xD0, 0xD2, 0xE7, 0x1E, 0x75, 0xE2, 0xE7, 0x1E, 0x75, 0xE2,
  0xE7, 0x1E, 0x75, 0xE2, 0xE7, 0x1E, 0x75, 0xE2, 0xE7, 0x1F, 0xFF, 0xA0, 0xE2, 0x0E, 0xFF, 0xC0,
  0xEF, 0xFB, 0x0C, 0x20, 0xCF, 0xFC, 0x0C, 0xFF, 0xB0, 0x62, 0x06, 0xFF, 0xC0, 0x6F, 0xFA, 0x0C,
  0x40, 0xCF, 0xFA, 0x0C, 0x1F, 0xF9, 0x0C, 0x01, 0x40, 0x10, 0xCF, 0xF0, 0xC0, 0x11, 0xFD, 0x81,
  0xEC, 0x67, 0x18, 0x16, 0xCE, 0xF9, 0x81, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_30fps() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_outlined_48_device_30fps_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_3g_mobiledata 48x48, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_outlined_48_device_3g_mobiledata_data[] PROGMEM = {
  0xFB, 0x81, 0xDA, 0x16, 0x81, 0x1A, 0xDF, 0xB8, 0x1D, 0xA1, 0x1F, 0xD0, 0xE0, 0x14, 0x01, 0x0E,
  0xFF, 0x0E, 0x01, 0xFE, 0x0A, 0x40, 0xAF, 0xFA, 0x0A, 0xFE, 0x0D, 0x40, 0xDF, 0xFA, 0x0D, 0x73,
  0xC4, 0xC7, 0x77, 0x3C, 0x4C, 0x77, 0x73, 0xC4, 0xC7, 0x77, 0x3B, 0x0D, 0x4C, 0x77, 0x2F, 0xC0,
  0x84, 0xC5, 0xFA, 0x2F, 0xA0, 0xD0, 0x85, 0xC5, 0xFA, 0x2F, 0xA0, 0xD0, 0x85, 0xC5, 0xFA, 0x2F,
  0xC0, 0x84, 0xC5, 0xFA, 0x73, 0xB0, 0xD4, 0xC7, 0x3C, 0x73, 0xC4, 0xC7, 0x3C, 0x73, 0xC4, 0xC7,
  0x3C, 0x73, 0xC4, 0xC7, 0x3F, 0xFB, 0x0D, 0x40, 0xDF, 0xFA, 0x0D, 0xFE, 0x0A, 0x40, 0xAF, 0xFA,
  0x0A, 0xFD, 0x0E, 0x01, 0x40, 0x10, 0xEF, 0xF0, 0xE0, 0x1F, 0xB8, 0x1D, 0xA1, 0x68, 0x11, 0xAD,
  0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_3g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 14, 41, 33), Box(0, 0, 47, 47),
      ic_outlined_48_device_3g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_4g_mobiledata 48x48, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_outlined_48_device_4g_mobiledata_data[] PROGMEM = {
  0xC4, 0xC7, 0x81, 0x1A, 0xDF, 0xB8, 0x1D, 0xA1, 0x1C, 0x4C, 0x60, 0x10, 0xEF, 0xF0, 0xE0, 0x1C,
  0x4C, 0x60, 0xAF, 0xFA, 0x0A, 0xC4, 0xC6, 0x0D, 0xFF, 0xA0, 0xDC, 0x4C, 0x6C, 0x77, 0xC4, 0xC6,
  0xC7, 0x7C, 0x4C, 0x6C, 0x77, 0xC4, 0xC6, 0xC7, 0x7C, 0x4C, 0x6C, 0x6F, 0xD4, 0xC6, 0xC6, 0xFF,
  0xFB, 0x2C, 0x6F, 0xFF, 0xB2, 0xC6, 0xFF, 0xFB, 0x2C, 0x73, 0xFF, 0xE2, 0xC7, 0x3C, 0x71, 0xC6,
  0xC7, 0x3C, 0x71, 0xC6, 0xC7, 0x3C, 0x71, 0xC6, 0x0D, 0xFF, 0xA0, 0xD7, 0x1C, 0x60, 0xAF, 0xFA,
  0x0A, 0x71, 0xC6, 0x01, 0x0E, 0xFF, 0x0E, 0x01, 0x71, 0xC7, 0x81, 0x1A, 0xDF, 0xB8, 0x1D, 0xA1,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_4g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 14, 41, 33), Box(0, 0, 47, 47),
      ic_outlined_48_device_4g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_4g_plus_mobiledata 48x48, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_outlined_48_device_4g_plus_mobiledata_data[] PROGMEM = {
  0xC4, 0xC5, 0x81, 0x1A, 0xDF, 0x98, 0x1D, 0xA1, 0x77, 0x1C, 0x4C, 0x40, 0x10, 0xEF, 0xD0, 0xE0,
  0x17, 0x7C, 0x4C, 0x40, 0xAF, 0xF0, 0xA7, 0x7C, 0x4C, 0x40, 0xDF, 0xF0, 0xD7, 0x7C, 0x4C, 0x4C,
  0x77, 0x4C, 0x4C, 0x4C, 0x4C, 0x77, 0x4C, 0x4C, 0x4C, 0x4C, 0x77, 0x4C, 0x4C, 0x4C, 0x4C, 0x77,
  0x4C, 0x4C, 0x4C, 0x4C, 0x4F, 0x92, 0xFF, 0xA4, 0xC4, 0xC4, 0xF9, 0x2F, 0xFF, 0xD2, 0xC4, 0xF9,
  0x2F, 0xFF, 0xD2, 0xC4, 0xF9, 0x2F, 0xFF, 0xD2, 0xC7, 0x1C, 0x6C, 0x4F, 0xF2, 0xC7, 0x1C, 0x6C,
  0x75, 0xC4, 0xC7, 0x1C, 0x6C, 0x75, 0xC4, 0xC7, 0x1C, 0x6C, 0x75, 0xC4, 0x0D, 0xFF, 0x0D, 0x77,
  0x71, 0xC4, 0x0A, 0xFF, 0x0A, 0x77, 0x71, 0xC4, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x71, 0xC5,
  0x81, 0x1A, 0xDF, 0x98, 0x1D, 0xA1, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_4g_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 14, 47, 33), Box(0, 0, 47, 47),
      ic_outlined_48_device_4g_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_60fps 48x48, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_outlined_48_device_60fps_data[] PROGMEM = {
  0x38, 0x16, 0xCE, 0xFB, 0x78, 0x16, 0xCE, 0xF9, 0x81, 0xEC, 0x64, 0x01, 0x0C, 0xFE, 0x50, 0x10,
  0xCF, 0xF0, 0xC0, 0x12, 0x0C, 0xFF, 0x50, 0xCF, 0xFA, 0x81, 0xC0, 0x6F, 0xF9, 0x40, 0x6F, 0xFC,
  0x06, 0x0C, 0xFF, 0x94, 0x0C, 0xFF, 0xC0, 0xC0, 0xEF, 0xF9, 0x40, 0xEF, 0xFC, 0x0E, 0xE7, 0x7E,
  0x71, 0xFD, 0x77, 0xE7, 0x1F, 0xD7, 0x7E, 0x71, 0xFD, 0x77, 0xE7, 0x1F, 0xFC, 0x81, 0xEC, 0x65,
  0xE7, 0x1F, 0xFF, 0x0C, 0x01, 0x3E, 0x71, 0xFF, 0xF9, 0x0C, 0x3E, 0x71, 0xFF, 0xFA, 0x06, 0x2E,
  0x71, 0xFF, 0xFA, 0x0C, 0x2E, 0x71, 0xFF, 0xFA, 0x0E, 0x2E, 0x71, 0xFD, 0x6E, 0x2E, 0x71, 0xFD,
  0x6E, 0x2E, 0x71, 0xFD, 0x6E, 0x2E, 0x71, 0xFD, 0x6E, 0x2E, 0x71, 0xFD, 0x6E, 0x2E, 0x71, 0xFD,
  0x6E, 0x2E, 0x71, 0xE0, 0xEF, 0xFA, 0x0E, 0x20, 0xEF, 0xFC, 0x0E, 0x0C, 0xFF, 0xA0, 0xC2, 0x0C,
  0xFF, 0xC0, 0xC0, 0x6F, 0xFA, 0x06, 0x20, 0x6F, 0xFC, 0x81, 0x60, 0xCF, 0xF0, 0xC4, 0x0C, 0xFF,
  0xA0, 0xC2, 0x01, 0x0C, 0xFD, 0x0C, 0x01, 0x40, 0x10, 0xCF, 0xF0, 0xC0, 0x14, 0x81, 0x6C, 0xEE,
  0x81, 0xEC, 0x67, 0x18, 0x16, 0xCE, 0xF9, 0x81, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_60fps() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 43, 37), Box(0, 0, 47, 47),
      ic_outlined_48_device_60fps_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_access_alarm 48x48, 4-bit Alpha,  RLE, 398 bytes.
static const unsigned char ic_outlined_48_device_access_alarm_data[] PROGMEM = {
  0x72, 0x01, 0x77, 0x60, 0x17, 0x73, 0x0A, 0x0C, 0x77, 0x60, 0xC0, 0xA7, 0x70, 0x10, 0xCA, 0x0A,
  0x77, 0x40, 0xAA, 0x0C, 0x01, 0x74, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xC0, 0xD0, 0x37, 0x20,
  0x50, 0xEC, 0x0C, 0x01, 0x77, 0x20, 0x10, 0xCC, 0x0E, 0x05, 0x70, 0x7D, 0x0A, 0x48, 0x92, 0x15,
  0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x40, 0xAD, 0x07, 0x50, 0xAD, 0x07, 0x30, 0x40, 0xBF, 0xD0, 0xB0,
  0x43, 0x08, 0xD0, 0xA2, 0x01, 0x0C, 0xD0, 0x52, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x32, 0x05, 0xD8,
  0x1C, 0x1B, 0xC0, 0xE0, 0x32, 0x08, 0xFF, 0xE0, 0x82, 0x03, 0x0E, 0xC8, 0x1B, 0x2E, 0xA8, 0x3C,
  0x10, 0x1B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE8, 0x3B, 0x10, 0x2C, 0xA8, 0x4E, 0x20,
  0x4F, 0xA2, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x28, 0x1B, 0xF4, 0x30,
  0x33, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x30, 0x37, 0x08, 0xC0, 0xB0, 0x17, 0x72,
  0x01, 0x0B, 0xC0, 0x87, 0x20, 0x3C, 0x0B, 0x71, 0xB7, 0x20, 0xBC, 0x03, 0x71, 0x0B, 0xB0, 0xD0,
  0x17, 0x1B, 0x72, 0x01, 0x0D, 0xB0, 0xB7, 0x04, 0xC0, 0x37, 0x2B, 0x73, 0x03, 0xC0, 0x46, 0x0B,
  0xB0, 0xA7, 0x3B, 0x74, 0x0A, 0xB0, 0xB5, 0x01, 0xC0, 0x27, 0x3B, 0x74, 0x02, 0xC0, 0x14, 0x05,
  0xB0, 0xC7, 0x4B, 0x75, 0x0C, 0xB0, 0x54, 0x09, 0xB0, 0x77, 0x4B, 0x75, 0x07, 0xB0, 0x94, 0x0B,
  0xB0, 0x37, 0x4B, 0x75, 0x03, 0xB0, 0xB4, 0x0D, 0xB0, 0x27, 0x4B, 0x75, 0x02, 0xB0, 0xD4, 0x0E,
  0xB7, 0x5B, 0x76, 0xB0, 0xE4, 0x0E, 0xB7, 0x5B, 0x03, 0x75, 0xB0, 0xE4, 0x0D, 0xB0, 0x27, 0x4C,
  0x09, 0x01, 0x72, 0x02, 0xB0, 0xD4, 0x0B, 0xB0, 0x37, 0x40, 0x40, 0xDB, 0x0E, 0x06, 0x71, 0x03,
  0xB0, 0xB4, 0x09, 0xB0, 0x77, 0x60, 0x7C, 0x0C, 0x03, 0x60, 0x7B, 0x09, 0x40, 0x5B, 0x0C, 0x77,
  0x02, 0x0A, 0xC0, 0x90, 0x14, 0x0C, 0xB0, 0x54, 0x01, 0xC0, 0x27, 0x71, 0x04, 0x0D, 0xB0, 0xB3,
  0x02, 0xC0, 0x15, 0x0B, 0xB0, 0xA7, 0x73, 0x07, 0xA0, 0x33, 0x0A, 0xB0, 0xB6, 0x04, 0xC0, 0x37,
  0x73, 0x02, 0x06, 0x30, 0x3C, 0x04, 0x70, 0xCB, 0x0D, 0x01, 0x77, 0x60, 0x10, 0xDB, 0x0B, 0x71,
  0x03, 0xC0, 0xB7, 0x76, 0x0B, 0xC0, 0x37, 0x20, 0x8C, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBC, 0x08,
  0x74, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x75, 0x01, 0x0D, 0xD0, 0xA0, 0x27, 0x30,
  0x20, 0xAD, 0x0C, 0x01, 0x76, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE0, 0xB0,
  0x17, 0x72, 0x08, 0xFF, 0xE0, 0x87, 0x75, 0x03, 0x0C, 0xFF, 0xA0, 0xB0, 0x37, 0x77, 0x10, 0x50,
  0xBF, 0xD0, 0xB0, 0x47, 0x77, 0x58, 0x92, 0x15, 0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_access_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_access_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_access_alarms 48x48, 4-bit Alpha,  RLE, 390 bytes.
static const unsigned char ic_outlined_48_device_access_alarms_data[] PROGMEM = {
  0x77, 0x77, 0x20, 0x27, 0x73, 0x09, 0x0B, 0x77, 0x58, 0x21, 0xDB, 0x17, 0x60, 0x10, 0xBA, 0x0A,
  0x77, 0x40, 0xCA, 0x0D, 0x02, 0x74, 0x02, 0x0D, 0xC0, 0x77, 0x72, 0x08, 0xC0, 0xE0, 0x47, 0x20,
  0x50, 0xEC, 0x0C, 0x01, 0x77, 0x30, 0xAD, 0x06, 0x70, 0x7D, 0x0A, 0x48, 0x92, 0x15, 0x9B, 0xDE,
  0xED, 0xB9, 0x51, 0x40, 0x8D, 0x08, 0x50, 0xAD, 0x08, 0x30, 0x50, 0xBF, 0xD0, 0xB0, 0x53, 0x06,
  0xD0, 0xA2, 0x01, 0x0C, 0xC0, 0xE0, 0x52, 0x04, 0x0C, 0xFF, 0xA0, 0xC0, 0x42, 0x04, 0x0E, 0xC8,
  0x1C, 0x1B, 0xC0, 0xD0, 0x32, 0x09, 0xFF, 0xE0, 0x92, 0x02, 0x0D, 0xC8, 0x1B, 0x2E, 0xA8, 0x3C,
  0x10, 0x1B, 0xE8, 0x2C, 0x73, 0x22, 0x82, 0x23, 0x7C, 0xE8, 0x3B, 0x10, 0x1B, 0xA8, 0x4E, 0x20,
  0x3E, 0xA2, 0x01, 0x0D, 0xD0, 0x90, 0x27, 0x30, 0x20, 0x9D, 0x0D, 0x01, 0x28, 0x19, 0xE3, 0x30,
  0x23, 0x0B, 0xC0, 0xD0, 0x27, 0x70, 0x20, 0xDC, 0x0B, 0x30, 0x27, 0x09, 0xC0, 0xB7, 0x74, 0x0B,
  0xC0, 0x97, 0x20, 0x4C, 0x0B, 0x71, 0xB7, 0x20, 0xBC, 0x04, 0x71, 0x0C, 0xB0, 0xD7, 0x2B, 0x73,
  0x0D, 0xB0, 0xC7, 0x05, 0xC0, 0x27, 0x2B, 0x73, 0x02, 0xC0, 0x56, 0x0B, 0xB0, 0x97, 0x3B, 0x74,
  0x09, 0xB0, 0xB5, 0x01, 0xC0, 0x27, 0x3B, 0x74, 0x02, 0xC0, 0x14, 0x05, 0xB0, 0xC7, 0x4B, 0x75,
  0x0C, 0xB0, 0x54, 0x09, 0xB0, 0x77, 0x4B, 0x75, 0x07, 0xB0, 0x94, 0x0B, 0xB0, 0x37, 0x4B, 0x75,
  0x03, 0xB0, 0xB4, 0x0D, 0xB0, 0x27, 0x4B, 0x75, 0x02, 0xB0, 0xD4, 0x0E, 0xB7, 0x5B, 0x76, 0xB0,
  0xE4, 0x0E, 0xB7, 0x5B, 0x02, 0x75, 0xB0, 0xE4, 0x0D, 0xB0, 0x27, 0x4C, 0x07, 0x73, 0x02, 0xB0,
  0xD4, 0x0B, 0xB0, 0x37, 0x40, 0x40, 0xDB, 0x0D, 0x04, 0x71, 0x03, 0xB0, 0xB4, 0x09, 0xB0, 0x77,
  0x60, 0x8C, 0x0A, 0x02, 0x60, 0x7B, 0x09, 0x40, 0x5B, 0x0C, 0x77, 0x02, 0x0B, 0xC0, 0x75, 0x0C,
  0xB0, 0x54, 0x01, 0xC0, 0x27, 0x71, 0x06, 0x0E, 0xB0, 0xB3, 0x02, 0xC0, 0x15, 0x0B, 0xB0, 0x97,
  0x72, 0x01, 0x09, 0xA0, 0x43, 0x09, 0xB0, 0xB6, 0x05, 0xC0, 0x27, 0x73, 0x03, 0x07, 0x30, 0x2C,
  0x05, 0x70, 0xCB, 0x0D, 0x77, 0x71, 0x0D, 0xB0, 0xC7, 0x10, 0x4C, 0x0B, 0x77, 0x60, 0xBC, 0x04,
  0x72, 0x09, 0xC0, 0xB7, 0x74, 0x0B, 0xC0, 0x97, 0x40, 0xBC, 0x0D, 0x02, 0x77, 0x02, 0x0D, 0xC0,
  0xB7, 0x50, 0x10, 0xDD, 0x09, 0x02, 0x73, 0x02, 0x09, 0xD0, 0xD0, 0x17, 0x60, 0x10, 0xBE, 0x82,
  0xC7, 0x32, 0x28, 0x22, 0x37, 0xCE, 0x0B, 0x01, 0x77, 0x20, 0x9F, 0xFE, 0x09, 0x77, 0x50, 0x40,
  0xCF, 0xFA, 0x0C, 0x04, 0x77, 0x71, 0x05, 0x0B, 0xFD, 0x0B, 0x05, 0x77, 0x75, 0x89, 0x21, 0x59,
  0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_access_alarms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_access_alarms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_access_time_filled 48x48, 4-bit Alpha,  RLE, 253 bytes.
static const unsigned char ic_outlined_48_device_access_time_filled_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0B, 0xFF, 0xFD, 0x0A, 0x74, 0x0B, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0x94, 0xFF, 0x90, 0x93, 0x01, 0xFF, 0xA4, 0xFF, 0xA0, 0x12, 0x08, 0xFF, 0xA4, 0xFF,
  0xA0, 0x82, 0x0D, 0xFF, 0xA4, 0xFF, 0xA8, 0x1D, 0x03, 0xFF, 0xB4, 0xFF, 0xB0, 0x30, 0x7F, 0xFB,
  0x4F, 0xFB, 0x07, 0x0A, 0xFF, 0xB4, 0xFF, 0xB0, 0xA0, 0xCF, 0xFB, 0x4F, 0xFB, 0x0C, 0x0E, 0xFF,
  0xB4, 0xFF, 0xB0, 0xEF, 0xFC, 0x40, 0xAF, 0xFF, 0xFF, 0x50, 0xAF, 0xFA, 0x0E, 0xFF, 0xB0, 0xA5,
  0x0A, 0xFF, 0x0E, 0x0C, 0xFF, 0xC0, 0xA5, 0x0A, 0xFE, 0x0C, 0x0A, 0xFF, 0xD0, 0xA5, 0x0A, 0xFD,
  0x0A, 0x07, 0xFF, 0xE0, 0xA5, 0x0A, 0xFC, 0x07, 0x03, 0xFF, 0xF0, 0xA5, 0x0A, 0xFB, 0x81, 0x30,
  0xDF, 0xFF, 0x0A, 0x50, 0xCF, 0x90, 0xD2, 0x08, 0xFF, 0xF9, 0x0A, 0x30, 0x7F, 0xA0, 0x82, 0x01,
  0xFF, 0xFA, 0x81, 0xA0, 0x7F, 0xB0, 0x13, 0x09, 0xFF, 0xFA, 0x0C, 0xFB, 0x09, 0x40, 0x10, 0xEF,
  0xFF, 0xFC, 0x0E, 0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0B,
  0xFF, 0xFF, 0x0A, 0x74, 0x0B, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50,
  0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD,
  0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCE, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_access_time_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_access_time_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_access_time 48x48, 4-bit Alpha,  RLE, 343 bytes.
static const unsigned char ic_outlined_48_device_access_time_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xBD, 0x0D, 0x06, 0x75, 0x06,
  0x0D, 0xD0, 0xA7, 0x40, 0xBD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x37, 0x74,
  0x03, 0x0D, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xD0, 0x17, 0x77, 0x10, 0x10, 0xDB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x73, 0xB7, 0x40, 0x3C, 0x09,
  0x30, 0x1C, 0x07, 0x74, 0xB7, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0D, 0x75, 0xB7, 0x60, 0xDB, 0x08,
  0x20, 0xDB, 0x06, 0x75, 0xB7, 0x60, 0x6B, 0x81, 0xD0, 0x3C, 0x76, 0xB7, 0x7C, 0x03, 0x07, 0xB0,
  0xB7, 0x6B, 0x77, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x76, 0xB7, 0x70, 0x6B, 0x0A, 0x0C, 0xB0, 0x37,
  0x6B, 0x77, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x76, 0xB7, 0x70, 0x2B, 0x0E, 0xC7, 0x7B, 0x77, 0x1F,
  0x97, 0x7B, 0x03, 0x77, 0xC0, 0xEB, 0x02, 0x76, 0xC0, 0x90, 0x17, 0x40, 0x2B, 0x0E, 0x0C, 0xB0,
  0x37, 0x60, 0x40, 0xDB, 0x0E, 0x06, 0x73, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x77, 0x10, 0x7C, 0x0C,
  0x03, 0x71, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x77, 0x20, 0x20, 0xAC, 0x09, 0x01, 0x60, 0xBB, 0x07,
  0x03, 0xC7, 0x74, 0x04, 0x0D, 0xB0, 0xE0, 0x65, 0xC8, 0x13, 0x0D, 0xB0, 0x67, 0x75, 0x07, 0xB0,
  0x94, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xD7, 0x76, 0x82, 0x2A, 0xE1, 0x40, 0xDB, 0x08, 0x20, 0x1C,
  0x07, 0x77, 0x70, 0x14, 0x07, 0xC0, 0x13, 0x09, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x09, 0x40, 0x10,
  0xEB, 0x0D, 0x01, 0x77, 0x71, 0x01, 0x0D, 0xB0, 0xE0, 0x15, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01,
  0x0C, 0xC0, 0x57, 0x09, 0xC0, 0xD0, 0x37, 0x74, 0x03, 0x0D, 0xC0, 0x97, 0x20, 0xBD, 0x07, 0x77,
  0x20, 0x7D, 0x0A, 0x74, 0x0B, 0xD0, 0xD0, 0x67, 0x50, 0x60, 0xDD, 0x0A, 0x76, 0x09, 0xF8, 0x2B,
  0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01,
  0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37,
  0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_access_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_access_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_add_alarm 48x48, 4-bit Alpha,  RLE, 377 bytes.
static const unsigned char ic_outlined_48_device_add_alarm_data[] PROGMEM = {
  0x72, 0x01, 0x77, 0x60, 0x17, 0x73, 0x0A, 0x0C, 0x77, 0x60, 0xC0, 0xA7, 0x70, 0x10, 0xCA, 0x0A,
  0x77, 0x40, 0xAA, 0x0C, 0x01, 0x74, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xC0, 0xD0, 0x37, 0x20,
  0x50, 0xEC, 0x0C, 0x01, 0x77, 0x20, 0x10, 0xCC, 0x0E, 0x05, 0x70, 0x7D, 0x0A, 0x48, 0x92, 0x15,
  0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x40, 0xAD, 0x07, 0x50, 0xAD, 0x07, 0x30, 0x40, 0xBF, 0xD0, 0xB0,
  0x43, 0x08, 0xD0, 0xA2, 0x01, 0x0C, 0xD0, 0x52, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x32, 0x05, 0xD8,
  0x1C, 0x1B, 0xC0, 0xE0, 0x32, 0x08, 0xFF, 0xE0, 0x82, 0x03, 0x0E, 0xC8, 0x1B, 0x2E, 0xA8, 0x3C,
  0x10, 0x1B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE8, 0x3B, 0x10, 0x2C, 0xA8, 0x4E, 0x20,
  0x4F, 0xA2, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x28, 0x1B, 0xF4, 0x30,
  0x33, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x30, 0x37, 0x08, 0xC0, 0xB0, 0x17, 0x72,
  0x01, 0x0B, 0xC0, 0x87, 0x20, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x71, 0x0B, 0xB0, 0xD0, 0x17,
  0x76, 0x01, 0x0D, 0xB0, 0xB7, 0x04, 0xC0, 0x37, 0x2C, 0x72, 0x03, 0xC0, 0x46, 0x0B, 0xB0, 0xA7,
  0x3C, 0x73, 0x0A, 0xB0, 0xB5, 0x01, 0xC0, 0x27, 0x3C, 0x73, 0x02, 0xC0, 0x14, 0x05, 0xB0, 0xC7,
  0x4C, 0x74, 0x0C, 0xB0, 0x54, 0x09, 0xB0, 0x77, 0x4C, 0x74, 0x07, 0xB0, 0x94, 0x0B, 0xB0, 0x37,
  0x4C, 0x74, 0x03, 0xB0, 0xB4, 0x0D, 0xB0, 0x25, 0xFF, 0xA5, 0x02, 0xB0, 0xD4, 0x0E, 0xB6, 0xFF,
  0xA6, 0xB0, 0xE4, 0x0E, 0xB6, 0xFF, 0xA6, 0xB0, 0xE4, 0x0D, 0xB0, 0x25, 0xFF, 0xA5, 0x02, 0xB0,
  0xD4, 0x0B, 0xB0, 0x37, 0x4C, 0x74, 0x03, 0xB0, 0xB4, 0x09, 0xB0, 0x77, 0x4C, 0x74, 0x07, 0xB0,
  0x94, 0x05, 0xB0, 0xC7, 0x4C, 0x74, 0x0C, 0xB0, 0x54, 0x01, 0xC0, 0x27, 0x3C, 0x73, 0x02, 0xC0,
  0x15, 0x0B, 0xB0, 0xA7, 0x3C, 0x73, 0x0A, 0xB0, 0xB6, 0x04, 0xC0, 0x37, 0x2C, 0x72, 0x03, 0xC0,
  0x47, 0x0C, 0xB0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xB0, 0xB7, 0x10, 0x3C, 0x0B, 0x77, 0x60, 0xBC,
  0x03, 0x72, 0x08, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xC0, 0x87, 0x40, 0xBC, 0x0D, 0x03, 0x77,
  0x03, 0x0D, 0xC0, 0xB7, 0x50, 0x10, 0xDD, 0x0A, 0x02, 0x73, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x60,
  0x10, 0xBE, 0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE, 0x0B, 0x01, 0x77, 0x20, 0x8F, 0xFE, 0x08,
  0x77, 0x50, 0x30, 0xCF, 0xFA, 0x0B, 0x03, 0x77, 0x71, 0x05, 0x0B, 0xFD, 0x0B, 0x04, 0x77, 0x75,
  0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_add_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_add_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_add_to_home_screen 48x48, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_outlined_48_device_add_to_home_screen_data[] PROGMEM = {
  0x78, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0x91, 0x70, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x16, 0x0A, 0xFF,
  0xFD, 0x0A, 0x60, 0xDF, 0xFF, 0xD0, 0xD6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF, 0x6F, 0xFF,
  0xF6, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7,
  0x77, 0x72, 0xC4, 0xFF, 0x75, 0xC4, 0xFF, 0x75, 0xC4, 0xFF, 0x75, 0xC4, 0xFF, 0x75, 0xC7, 0x30,
  0x5F, 0x75, 0xC7, 0x20, 0x5F, 0x97, 0x5C, 0x71, 0x05, 0xFA, 0x75, 0xC7, 0x05, 0xD0, 0x5C, 0x75,
  0xC6, 0x05, 0xD0, 0x51, 0xC7, 0x5C, 0x50, 0x5D, 0x05, 0x2C, 0x75, 0xC4, 0x05, 0xD0, 0x53, 0xC7,
  0x5C, 0x30, 0x5D, 0x05, 0x4C, 0x75, 0xC2, 0x05, 0xD0, 0x55, 0xC7, 0x5C, 0x10, 0x5D, 0x05, 0x6C,
  0x75, 0xC0, 0x5D, 0x05, 0x77, 0x72, 0xC0, 0xAC, 0x05, 0x77, 0x73, 0xC1, 0x0A, 0xA0, 0x57, 0x77,
  0x4C, 0x20, 0xA0, 0x57, 0x77, 0x5C, 0x77, 0x77, 0x2C, 0x77, 0x77, 0x2C, 0x6C, 0x77, 0x6C, 0x6C,
  0x77, 0x6C, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF, 0x60, 0xDF, 0xFF, 0xD0,
  0xD6, 0x0A, 0xFF, 0xFD, 0x0A, 0x60, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x81, 0x1A, 0xDF, 0xFE,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_add_to_home_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 39, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_add_to_home_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_ad_units 48x48, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_outlined_48_device_ad_units_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x92, 0xFF, 0xA2, 0xF9, 0x2F, 0xFA, 0x2F, 0x92, 0xFF, 0xA2, 0xF9, 0x2F, 0xFA, 0x2F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9,
  0x77, 0x6C, 0x0D, 0xFF, 0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10,
  0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_ad_units() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_ad_units_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_airplanemode_active 48x48, 4-bit Alpha,  RLE, 214 bytes.
static const unsigned char ic_outlined_48_device_airplanemode_active_data[] PROGMEM = {
  0x77, 0x48, 0x28, 0xDD, 0x87, 0x77, 0x77, 0x08, 0xC0, 0x87, 0x77, 0x76, 0x0D, 0xC0, 0xD7, 0x77,
  0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76,
  0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7,
  0x77, 0x74, 0x02, 0x0A, 0xE0, 0xA0, 0x27, 0x77, 0x71, 0x08, 0xFB, 0x08, 0x77, 0x75, 0x05, 0x0D,
  0xFD, 0x0D, 0x05, 0x77, 0x71, 0x02, 0x0B, 0xFF, 0xA0, 0xB0, 0x27, 0x74, 0x01, 0x09, 0xFF, 0xE0,
  0x90, 0x17, 0x71, 0x06, 0x0E, 0xFF, 0xF9, 0x0E, 0x06, 0x75, 0x03, 0x0C, 0xFF, 0xFD, 0x0C, 0x03,
  0x71, 0x01, 0x09, 0xFF, 0xFF, 0xA0, 0x90, 0x15, 0x07, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x72, 0x04,
  0x0D, 0xFD, 0x81, 0xB6, 0x2E, 0x81, 0x26, 0xBF, 0xD0, 0xD0, 0x4F, 0xB8, 0x1E, 0x95, 0x4E, 0x48,
  0x15, 0x9E, 0xFF, 0xB8, 0x1C, 0x73, 0x7E, 0x78, 0x13, 0x7C, 0xFB, 0x82, 0xEA, 0x51, 0x73, 0xE7,
  0x38, 0x21, 0x5A, 0xEB, 0x81, 0xD8, 0x47, 0x7E, 0x77, 0x81, 0x48, 0xD7, 0x73, 0xE7, 0x77, 0x76,
  0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x76, 0xE7, 0x77, 0x74, 0x02,
  0x0A, 0xE0, 0xA0, 0x27, 0x77, 0x71, 0x07, 0xFB, 0x07, 0x77, 0x75, 0x04, 0x0D, 0xFD, 0x0D, 0x04,
  0x77, 0x73, 0xFF, 0xA7, 0x77, 0x3C, 0x86, 0xD9, 0x51, 0x15, 0x9D, 0xC7, 0x77, 0x38, 0x2D, 0x95,
  0x17, 0x18, 0x21, 0x59, 0xD7, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_airplanemode_active() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_airplanemode_active_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_airplanemode_inactive 48x48, 4-bit Alpha,  RLE, 327 bytes.
static const unsigned char ic_outlined_48_device_airplanemode_inactive_data[] PROGMEM = {
  0x77, 0x58, 0x28, 0xDD, 0x87, 0x76, 0x02, 0x77, 0x10, 0x8C, 0x08, 0x77, 0x48, 0x14, 0xF7, 0x77,
  0x0D, 0xC0, 0xD7, 0x73, 0x04, 0xB0, 0x77, 0x6E, 0x77, 0x30, 0xEC, 0x07, 0x75, 0xE7, 0x73, 0x03,
  0x0E, 0xC0, 0x77, 0x4E, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x73, 0xE7, 0x75, 0x03, 0x0E, 0xC0, 0x77,
  0x2E, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x71, 0xE7, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0xE7, 0x77, 0x10,
  0x30, 0xEC, 0x07, 0x6E, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xD7, 0x77, 0x30, 0x30, 0xEC,
  0x07, 0x50, 0xCC, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB7, 0x77, 0x50, 0x30, 0xEC, 0x07,
  0x50, 0xCA, 0x0A, 0x02, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB0, 0x87, 0x77, 0x40, 0x30,
  0xEC, 0x07, 0x50, 0xCB, 0x0D, 0x05, 0x77, 0x72, 0x03, 0x0C, 0xD0, 0x75, 0x0C, 0xC0, 0xB0, 0x27,
  0x75, 0x01, 0x09, 0xF9, 0x07, 0x50, 0xCD, 0x09, 0x01, 0x77, 0x20, 0x60, 0xEF, 0xB0, 0x75, 0x0C,
  0xD0, 0xE0, 0x67, 0x60, 0x30, 0xCF, 0xE0, 0x75, 0x0C, 0xE0, 0xC0, 0x37, 0x20, 0x10, 0xAF, 0xFA,
  0x07, 0x50, 0xCF, 0x09, 0x01, 0x60, 0x70, 0xEF, 0xFC, 0x07, 0x50, 0xCF, 0x0E, 0x07, 0x30, 0x40,
  0xDF, 0xD8, 0x1B, 0x62, 0xE0, 0x75, 0x0C, 0xF9, 0x0D, 0x04, 0x1F, 0xB8, 0x1E, 0x95, 0x4F, 0x07,
  0x50, 0xCF, 0xA1, 0xF8, 0x1C, 0x73, 0x7F, 0x90, 0x75, 0x07, 0x0C, 0xF1, 0xB8, 0x2E, 0xA5, 0x17,
  0x3F, 0xA0, 0x76, 0x82, 0x15, 0xAE, 0xB1, 0x81, 0xD8, 0x47, 0x7F, 0xB0, 0x77, 0x28, 0x14, 0x8D,
  0x77, 0x4E, 0x0E, 0xC0, 0x77, 0x77, 0x71, 0xE0, 0x30, 0xEC, 0x07, 0x77, 0x77, 0xE1, 0x03, 0x0E,
  0xC0, 0x77, 0x77, 0x6E, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x75, 0xE3, 0x03, 0x0E, 0xC0, 0x77, 0x77,
  0x4E, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x71, 0x02, 0x0A, 0xE0, 0xA0, 0x23, 0x03, 0x0E, 0xC0, 0x77,
  0x76, 0x07, 0xFB, 0x07, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x30, 0x40, 0xDF, 0xD0, 0xD0, 0x42, 0x03,
  0x0E, 0xC0, 0x77, 0x72, 0xFF, 0xA3, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0xC8, 0x6D, 0x95, 0x11, 0x59,
  0xDC, 0x40, 0x30, 0xEC, 0x02, 0x77, 0x82, 0xD9, 0x51, 0x71, 0x82, 0x15, 0x9D, 0x50, 0x30, 0xEA,
  0x04, 0x80, 0xC1, 0x08, 0x13, 0xE4, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_airplanemode_inactive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 43, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_airplanemode_inactive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_airplane_ticket 48x48, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_outlined_48_device_airplane_ticket_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4E, 0xB2, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE2, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xEC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x76, 0x02, 0x77, 0x4F, 0x90, 0x87, 0x30, 0xBA, 0x07, 0x77, 0x3F,
  0xA0, 0xB7, 0x20, 0x9B, 0x08, 0x77, 0x2F, 0xB0, 0x87, 0x10, 0x10, 0xEB, 0x09, 0x77, 0x1C, 0x81,
  0x15, 0xDC, 0x02, 0x71, 0x07, 0xC0, 0xA7, 0x7C, 0x20, 0x10, 0xDB, 0x08, 0x72, 0x0D, 0xC0, 0xB7,
  0x6C, 0x30, 0x5B, 0x0C, 0x72, 0x04, 0xD0, 0xB6, 0x00, 0x14, 0xC3, 0x01, 0xB0, 0xE7, 0x30, 0xBD,
  0x84, 0xC1, 0x15, 0x9D, 0xA0, 0x63, 0xC3, 0x01, 0xB0, 0xE7, 0x30, 0x2E, 0x0E, 0xE0, 0xD3, 0xC3,
  0x05, 0xB0, 0xC2, 0x82, 0x3B, 0xB1, 0x50, 0xAF, 0xD0, 0xA3, 0xC2, 0x01, 0x0D, 0xB0, 0x82, 0x87,
  0x1E, 0xFD, 0x32, 0x6A, 0xEF, 0xC8, 0x1D, 0x81, 0x3C, 0x81, 0x15, 0xDC, 0x02, 0x30, 0x7F, 0xF8,
  0x2E, 0xA6, 0x16, 0xFB, 0x08, 0x50, 0xDF, 0xA8, 0x2E, 0xB7, 0x27, 0x3F, 0xA0, 0xB6, 0x04, 0xE8,
  0x1C, 0x83, 0x77, 0xF9, 0x08, 0x71, 0x83, 0xBF, 0xD9, 0x57, 0x74, 0xF9, 0x72, 0x00, 0x17, 0x77,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8,
  0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF,
  0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_airplane_ticket() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_airplane_ticket_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_air 48x48, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_outlined_48_device_air_data[] PROGMEM = {
  0x77, 0x72, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x77, 0x77, 0x30, 0x50, 0xEE, 0x0E, 0x05, 0x77, 0x77,
  0x10, 0x5F, 0xB0, 0x57, 0x77, 0x60, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x77, 0x50, 0x7C, 0x82, 0x71,
  0x17, 0xC0, 0x77, 0x77, 0x50, 0xCB, 0x07, 0x40, 0x7B, 0x0C, 0x77, 0x75, 0x0E, 0xB0, 0x14, 0x01,
  0xB0, 0xE7, 0x77, 0x77, 0x01, 0xB0, 0xE7, 0x77, 0x77, 0x07, 0xB0, 0xC7, 0x77, 0x75, 0x01, 0x07,
  0xC0, 0x76, 0xFF, 0xFF, 0xC0, 0xE0, 0x16, 0xFF, 0xFF, 0xC0, 0x57, 0xFF, 0xFF, 0xA0, 0xE0, 0x57,
  0x1F, 0xFF, 0xE8, 0x2E, 0xC7, 0x18, 0x09, 0xA5, 0x0F, 0xFF, 0xFD, 0x82, 0xEC, 0x71, 0x38, 0x0C,
  0x0F, 0x0E, 0x05, 0x28, 0x0C, 0x2F, 0x05, 0x18, 0x0C, 0x2F, 0x0E, 0x01, 0x77, 0x77, 0x50, 0x10,
  0x7C, 0x07, 0x77, 0x77, 0x70, 0x7B, 0x0C, 0xFF, 0xD8, 0x1E, 0xC6, 0x76, 0x01, 0xB0, 0xEF, 0xFF,
  0x90, 0xC0, 0x17, 0x40, 0x1B, 0x0E, 0xFF, 0xFA, 0x0C, 0x74, 0x07, 0xB0, 0xCF, 0xFF, 0xB0, 0x67,
  0x10, 0x10, 0x7C, 0x07, 0x77, 0x50, 0x10, 0xBB, 0x0C, 0x71, 0xD0, 0xE0, 0x17, 0x76, 0x01, 0xB0,
  0xE7, 0x1D, 0x05, 0x77, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x1B, 0x0E, 0x05, 0x77, 0x10, 0xCB,
  0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x18, 0x2E, 0xC7, 0x17, 0x72, 0x06, 0xFB, 0x06, 0x77, 0x77, 0x10,
  0xCF, 0x90, 0xC7, 0x77, 0x72, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x74, 0x84, 0x6C, 0xEE, 0xC6,
  0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_air() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_air_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_aod 48x48, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_outlined_48_device_aod_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x92,
  0xFF, 0xA2, 0xF9, 0x2F, 0xFA, 0x2F, 0x92, 0xFF, 0xA2, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x94, 0xFD, 0x4F, 0x94, 0xFD, 0x4F, 0x94, 0xFD, 0x4F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97,
  0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x4F, 0x77, 0x6F,
  0x97, 0x76, 0xC0, 0xDF, 0xFF, 0xD0, 0xD0, 0xAF, 0xFF, 0xD8, 0x1A, 0x1E, 0xFF, 0xFB, 0x84, 0xE1,
  0x01, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_aod() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_aod_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_0_bar 48x48, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_48_device_battery_0_bar_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0x80, 0xD0, 0xF0, 0xDF, 0xFC, 0x81,
  0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_1_bar 48x48, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_48_device_battery_1_bar_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0x80, 0x9F, 0x0F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_2_bar 48x48, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_48_device_battery_2_bar_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0x80, 0xB9, 0x0F, 0x0D, 0xFF, 0xC8,
  0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_3_bar 48x48, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_outlined_48_device_battery_3_bar_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0x80, 0xCB, 0x0F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_4_bar 48x48, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_outlined_48_device_battery_4_bar_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0x80, 0xDD, 0x0F, 0x0D, 0xFF, 0xC8,
  0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_5_bar 48x48, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_outlined_48_device_battery_5_bar_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0x80, 0xEF, 0x0F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_5_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_5_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_6_bar 48x48, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_outlined_48_device_battery_6_bar_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0xF9, 0x75, 0x80, 0x98, 0x90, 0xF0, 0xDF, 0xFC,
  0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_6_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_6_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_alert 48x48, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_48_device_battery_alert_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x81, 0x1A, 0xEF, 0xF8, 0x2E, 0xA1, 0xAF, 0xFC,
  0x0A, 0x0E, 0xFF, 0xC0, 0xE8, 0x0A, 0xA0, 0xF4, 0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA4,
  0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA4, 0x80, 0x9B, 0x4F, 0x4F, 0xFA, 0x4F,
  0xFA, 0x4F, 0xFA, 0x48, 0x09, 0xD0, 0xF0, 0xEF, 0xFC, 0x0E, 0x0A, 0xFF, 0xC8, 0x2A, 0x1A, 0xEF,
  0xF8, 0x1E, 0xA1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_charging_full 48x48, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_outlined_48_device_battery_charging_full_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x81, 0x1A, 0xEF, 0xF8, 0x2E, 0xA1, 0xAF, 0xFC,
  0x0A, 0x0E, 0xFF, 0xC0, 0xE8, 0x09, 0x83, 0xF0, 0xBF, 0xFD, 0x03, 0xFF, 0xC0, 0xA1, 0xFF, 0xC0,
  0x21, 0xFF, 0xB0, 0x92, 0xFF, 0xA0, 0xE0, 0x12, 0xFF, 0xA0, 0x83, 0xFF, 0x90, 0xE0, 0x13, 0xFF,
  0x90, 0x74, 0xFF, 0x0D, 0x5F, 0xF0, 0x65, 0xFE, 0x0D, 0x72, 0x04, 0xFA, 0x05, 0x72, 0x0C, 0xF9,
  0x0C, 0x72, 0x05, 0xFA, 0x04, 0x72, 0x0D, 0xFE, 0x50, 0x6F, 0xF5, 0x0D, 0xFF, 0x40, 0x7F, 0xF9,
  0x30, 0x10, 0xEF, 0xF9, 0x30, 0x8F, 0xFA, 0x20, 0x10, 0xEF, 0xFA, 0x20, 0x9F, 0xFB, 0x10, 0x2F,
  0xFC, 0x10, 0xAF, 0xFC, 0x03, 0xFF, 0xD0, 0xBF, 0xFF, 0xFB, 0x0E, 0xFF, 0xC0, 0xE0, 0xAF, 0xFC,
  0x82, 0xA1, 0xAE, 0xFF, 0x81, 0xEA, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_charging_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_charging_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_full 48x48, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_outlined_48_device_battery_full_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x81, 0x1A, 0xEF, 0xF8, 0x2E, 0xA1, 0xAF, 0xFC,
  0x0A, 0x0E, 0xFF, 0xC0, 0xE8, 0x09, 0x9A, 0x4F, 0x0E, 0xFF, 0xC0, 0xE0, 0xAF, 0xFC, 0x82, 0xA1,
  0xAE, 0xFF, 0x81, 0xEA, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_saver 48x48, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_outlined_48_device_battery_saver_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0,
  0xD8, 0x0B, 0x94, 0xF4, 0xFF, 0xA4, 0xFF, 0xA4, 0xFF, 0xA4, 0xFD, 0x75, 0xF9, 0x75, 0xF9, 0x75,
  0xF9, 0x75, 0xFD, 0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0xFA, 0x48, 0x0B, 0x94, 0xF0, 0xDF, 0xFC, 0x81,
  0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_saver() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_saver_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_std 48x48, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_outlined_48_device_battery_std_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x81, 0x1A, 0xEF, 0xF8, 0x2E, 0xA1, 0xAF, 0xFC,
  0x0A, 0x0E, 0xFF, 0xC0, 0xE8, 0x09, 0x9A, 0x4F, 0x0E, 0xFF, 0xC0, 0xE0, 0xAF, 0xFC, 0x82, 0xA1,
  0xAE, 0xFF, 0x81, 0xEA, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_std() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_std_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_battery_unknown 48x48, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_outlined_48_device_battery_unknown_data[] PROGMEM = {
  0x6F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x96, 0x81, 0x1A, 0xEF, 0xF8, 0x2E, 0xA1, 0xAF, 0xFC,
  0x0A, 0x0E, 0xFF, 0xC0, 0xE8, 0x09, 0xC7, 0xF0, 0x80, 0x32, 0x03, 0x08, 0xFD, 0x0D, 0x02, 0x60,
  0x20, 0xDF, 0xB0, 0x27, 0x10, 0x2F, 0xA0, 0x83, 0x82, 0x8D, 0xD8, 0x30, 0x8F, 0x90, 0x32, 0x08,
  0xC0, 0x82, 0x03, 0xF9, 0x30, 0xDC, 0x0D, 0x3F, 0xFA, 0x0D, 0x3F, 0xFA, 0x08, 0x20, 0x4F, 0xF9,
  0x0B, 0x30, 0xBF, 0xF0, 0xB3, 0x08, 0xFF, 0x0C, 0x30, 0x7F, 0xF9, 0x02, 0x20, 0x5F, 0xF9, 0x0A,
  0x30, 0xEF, 0xF9, 0x07, 0x20, 0x48, 0x0E, 0x4F, 0x4F, 0xFA, 0x4F, 0xFA, 0x4F, 0xFA, 0x48, 0x09,
  0xD0, 0xF0, 0xEF, 0xFC, 0x0E, 0x0A, 0xFF, 0xC8, 0x2A, 0x1A, 0xEF, 0xF8, 0x1E, 0xA1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_battery_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_battery_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_bloodtype 48x48, 4-bit Alpha,  RLE, 294 bytes.
static const unsigned char ic_outlined_48_device_bloodtype_data[] PROGMEM = {
  0x77, 0x10, 0x08, 0x77, 0x77, 0x10, 0xAA, 0x0A, 0x77, 0x76, 0x0B, 0xC0, 0xB7, 0x77, 0x30, 0x10,
  0xCE, 0x0C, 0x01, 0x77, 0x70, 0x10, 0xCF, 0x90, 0xC0, 0x17, 0x75, 0x01, 0x0C, 0xC0, 0x0B, 0xC0,
  0xC0, 0x17, 0x73, 0x01, 0x0C, 0xC0, 0xB2, 0x0B, 0xC0, 0xC0, 0x17, 0x72, 0x0B, 0xC0, 0xA4, 0x0A,
  0xC0, 0xB7, 0x71, 0x0A, 0xC0, 0xA6, 0x0A, 0xC0, 0xA7, 0x60, 0x8C, 0x0B, 0x71, 0x0B, 0xC0, 0x87,
  0x40, 0x5C, 0x0C, 0x73, 0x0C, 0xC0, 0x57, 0x20, 0x20, 0xEB, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xB0,
  0xE0, 0x27, 0x10, 0xCB, 0x0E, 0x03, 0x75, 0x03, 0x0E, 0xB0, 0xC7, 0x07, 0xC0, 0x57, 0x70, 0x5C,
  0x07, 0x50, 0x10, 0xEB, 0x0A, 0x6C, 0x60, 0xAB, 0x0E, 0x01, 0x40, 0xAB, 0x0D, 0x01, 0x6C, 0x60,
  0x10, 0xDB, 0x0A, 0x30, 0x2C, 0x05, 0x7C, 0x70, 0x5C, 0x02, 0x20, 0x9B, 0x0C, 0x71, 0xC7, 0x10,
  0xCB, 0x09, 0x20, 0xEB, 0x04, 0x4F, 0xD4, 0x04, 0xB8, 0x1E, 0x04, 0xB0, 0xD5, 0xFD, 0x50, 0xDB,
  0x04, 0x09, 0xB0, 0x85, 0xFD, 0x50, 0x8B, 0x09, 0x0C, 0xB0, 0x45, 0xFD, 0x50, 0x4B, 0x0C, 0x0D,
  0xB0, 0x17, 0x2C, 0x72, 0x01, 0xB0, 0xDC, 0x73, 0xC7, 0x3C, 0x0E, 0xB0, 0x17, 0x2C, 0x72, 0x01,
  0xB0, 0xE0, 0xCB, 0x02, 0x72, 0xC7, 0x20, 0x2B, 0x0D, 0x0B, 0xB0, 0x57, 0x77, 0x10, 0x5B, 0x0B,
  0x08, 0xB0, 0x97, 0x77, 0x10, 0x9B, 0x08, 0x03, 0xB0, 0xD5, 0xFD, 0x50, 0xDB, 0x81, 0x30, 0xEB,
  0x06, 0x4F, 0xD4, 0x06, 0xB0, 0xE2, 0x09, 0xB0, 0xD4, 0xFD, 0x40, 0xDB, 0x09, 0x20, 0x10, 0xEB,
  0x0A, 0x3F, 0xD3, 0x0A, 0xB0, 0xE0, 0x13, 0x07, 0xC0, 0x77, 0x72, 0x07, 0xC0, 0x75, 0x0C, 0xC0,
  0x97, 0x70, 0x9C, 0x0C, 0x60, 0x10, 0xEC, 0x0D, 0x05, 0x73, 0x05, 0x0D, 0xC0, 0xE0, 0x17, 0x03,
  0x0E, 0xD8, 0x2D, 0x84, 0x22, 0x82, 0x24, 0x8D, 0xD0, 0xE0, 0x37, 0x20, 0x10, 0xCF, 0xFC, 0x0C,
  0x01, 0x75, 0x08, 0xFF, 0xA0, 0x87, 0x71, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77, 0x58, 0x90,
  0x49, 0xBD, 0xEE, 0xDB, 0x94, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_bloodtype() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_bloodtype_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_bluetooth_connected 48x48, 4-bit Alpha,  RLE, 265 bytes.
static const unsigned char ic_outlined_48_device_bluetooth_connected_data[] PROGMEM = {
  0x77, 0x2A, 0x07, 0x77, 0x77, 0x5B, 0x07, 0x77, 0x77, 0x4C, 0x07, 0x77, 0x77, 0x3D, 0x07, 0x77,
  0x77, 0x2E, 0x07, 0x77, 0x77, 0x1F, 0x07, 0x77, 0x40, 0xA0, 0x57, 0x1F, 0x90, 0x77, 0x72, 0x0A,
  0xA0, 0x57, 0xC0, 0xEC, 0x07, 0x77, 0x0A, 0xC0, 0x56, 0xC0, 0x30, 0xEC, 0x07, 0x76, 0x05, 0xD0,
  0x55, 0xC1, 0x03, 0x0E, 0xC0, 0x77, 0x60, 0x5D, 0x05, 0x4C, 0x20, 0x30, 0xEC, 0x07, 0x76, 0x05,
  0xD0, 0x53, 0xC3, 0x07, 0xD0, 0x27, 0x60, 0x5D, 0x05, 0x2C, 0x20, 0x5D, 0x05, 0x77, 0x10, 0x5D,
  0x05, 0x1C, 0x10, 0x5D, 0x05, 0x77, 0x30, 0x5D, 0x05, 0xC0, 0x5D, 0x05, 0x77, 0x50, 0x5F, 0xF0,
  0x57, 0x60, 0x07, 0x60, 0x5F, 0xD0, 0x56, 0x00, 0x75, 0x07, 0xA0, 0x76, 0x05, 0xFB, 0x05, 0x60,
  0x7A, 0x07, 0x30, 0x7C, 0x07, 0x60, 0x5F, 0x90, 0x56, 0x07, 0xC8, 0x17, 0x07, 0xE0, 0x76, 0x05,
  0xE0, 0x56, 0x07, 0xE0, 0x07, 0xE0, 0x76, 0x05, 0xE0, 0x56, 0x07, 0xE8, 0x17, 0x07, 0xC0, 0x76,
  0x05, 0xF9, 0x05, 0x60, 0x7C, 0x07, 0x30, 0x7A, 0x07, 0x60, 0x5F, 0xB0, 0x56, 0x07, 0xA0, 0x75,
  0x00, 0x76, 0x05, 0xFD, 0x05, 0x60, 0x07, 0x76, 0x05, 0xFF, 0x05, 0x77, 0x50, 0x5D, 0x05, 0xC0,
  0x5D, 0x05, 0x77, 0x30, 0x5D, 0x05, 0x1C, 0x10, 0x5D, 0x05, 0x77, 0x10, 0x5D, 0x05, 0x2C, 0x20,
  0x5D, 0x05, 0x76, 0x05, 0xD0, 0x53, 0xC3, 0x07, 0xD0, 0x27, 0x40, 0x5D, 0x05, 0x4C, 0x20, 0x30,
  0xEC, 0x07, 0x74, 0x05, 0xD0, 0x55, 0xC1, 0x03, 0x0E, 0xC0, 0x77, 0x50, 0xAC, 0x05, 0x6C, 0x03,
  0x0E, 0xC0, 0x77, 0x70, 0xAA, 0x05, 0x7C, 0x0E, 0xC0, 0x77, 0x72, 0x0A, 0x05, 0x71, 0xF9, 0x07,
  0x77, 0x76, 0xF0, 0x77, 0x77, 0x7E, 0x07, 0x77, 0x77, 0x1D, 0x07, 0x77, 0x77, 0x2C, 0x07, 0x77,
  0x77, 0x3B, 0x07, 0x77, 0x77, 0x4A, 0x07, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_bluetooth_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_bluetooth_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_bluetooth_disabled 48x48, 4-bit Alpha,  RLE, 246 bytes.
static const unsigned char ic_outlined_48_device_bluetooth_disabled_data[] PROGMEM = {
  0x77, 0xA0, 0x77, 0x77, 0x71, 0xB0, 0x77, 0x77, 0x7C, 0x07, 0x77, 0x76, 0xD0, 0x77, 0x70, 0xA0,
  0x57, 0x3E, 0x07, 0x75, 0x0A, 0xA0, 0x57, 0x2F, 0x07, 0x73, 0x0A, 0xC0, 0x57, 0x1F, 0x90, 0x77,
  0x20, 0x5D, 0x05, 0x7C, 0x0E, 0xC0, 0x77, 0x20, 0x5D, 0x05, 0x6C, 0x03, 0x0E, 0xC0, 0x77, 0x20,
  0x5D, 0x05, 0x5C, 0x10, 0x30, 0xEC, 0x07, 0x72, 0x05, 0xD0, 0x54, 0x08, 0xB2, 0x03, 0x0E, 0xC0,
  0x87, 0x20, 0x5D, 0x05, 0x40, 0x8A, 0x30, 0x7D, 0x02, 0x72, 0x05, 0xD0, 0x54, 0x08, 0x92, 0x05,
  0xD0, 0x57, 0x40, 0x5D, 0x05, 0x48, 0x18, 0x05, 0xD0, 0x57, 0x60, 0x5D, 0x05, 0x40, 0x2D, 0x05,
  0x77, 0x10, 0x5D, 0x05, 0x40, 0x8B, 0x05, 0x77, 0x30, 0x5D, 0x05, 0x48, 0x18, 0xF5, 0x77, 0x50,
  0x5D, 0x05, 0x40, 0x27, 0x77, 0x05, 0xD0, 0x57, 0x77, 0x50, 0x5D, 0x05, 0x77, 0x74, 0x05, 0xE0,
  0x57, 0x77, 0x20, 0x5F, 0x90, 0x57, 0x77, 0x05, 0xFB, 0x05, 0x77, 0x50, 0x5F, 0xD0, 0x57, 0x73,
  0x05, 0xFF, 0x05, 0x77, 0x10, 0x5D, 0x05, 0xC0, 0x5D, 0x05, 0x76, 0x05, 0xD0, 0x51, 0xC1, 0x05,
  0xD0, 0x57, 0x40, 0x5D, 0x05, 0x2C, 0x20, 0x5D, 0x05, 0x72, 0x05, 0xD0, 0x53, 0xC3, 0x07, 0xD0,
  0x57, 0x05, 0xD0, 0x54, 0xC2, 0x03, 0x0E, 0xE0, 0x55, 0x05, 0xD0, 0x55, 0xC1, 0x03, 0x0E, 0xF9,
  0x05, 0x40, 0xAC, 0x05, 0x6C, 0x03, 0x0E, 0xC0, 0xAD, 0x05, 0x40, 0xAA, 0x05, 0x7C, 0x0E, 0xC8,
  0x17, 0x05, 0xD0, 0x54, 0x0A, 0x05, 0x71, 0xF9, 0x07, 0x30, 0x5C, 0x0A, 0x77, 0xF0, 0x75, 0x05,
  0xA0, 0xA7, 0x71, 0xE0, 0x77, 0x05, 0x0A, 0x77, 0x2D, 0x07, 0x77, 0x75, 0xC0, 0x77, 0x77, 0x6B,
  0x07, 0x77, 0x77, 0xA0, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_bluetooth_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_bluetooth_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_bluetooth_drive 48x48, 4-bit Alpha,  RLE, 278 bytes.
static const unsigned char ic_outlined_48_device_bluetooth_drive_data[] PROGMEM = {
  0x77, 0x77, 0x50, 0xA0, 0xB8, 0x0C, 0x20, 0x81, 0xAF, 0xB8, 0x0C, 0x10, 0x0A, 0xA0, 0xB7, 0x77,
  0x73, 0x0B, 0x03, 0x30, 0xAB, 0x0B, 0x77, 0x77, 0x18, 0x26, 0xFE, 0x32, 0x84, 0xAF, 0x6D, 0xFB,
  0x77, 0x77, 0x18, 0x92, 0x9F, 0xE3, 0x0A, 0xF4, 0x2E, 0xFB, 0x77, 0x77, 0x18, 0x91, 0x9F, 0xE3,
  0xAF, 0x49, 0xFE, 0x37, 0x77, 0x72, 0x87, 0x9F, 0xED, 0xFC, 0xFE, 0x36, 0x08, 0x0E, 0xFF, 0xD5,
  0x09, 0xC0, 0xE0, 0x36, 0x08, 0xFF, 0xF6, 0x09, 0xA0, 0xE0, 0x37, 0x0E, 0xFF, 0xF6, 0x09, 0xA0,
  0xE0, 0x36, 0x05, 0xFF, 0xF9, 0x50, 0x9C, 0x0E, 0x03, 0x50, 0xAB, 0x08, 0x77, 0x71, 0x87, 0x9F,
  0xED, 0xFC, 0xFE, 0x33, 0x01, 0xC0, 0x27, 0x77, 0x89, 0x19, 0xFE, 0x3A, 0xF4, 0x9F, 0xE3, 0x20,
  0x6B, 0x0C, 0x77, 0x78, 0x79, 0xFE, 0x30, 0xAF, 0x42, 0xA0, 0xA2, 0x0B, 0xB0, 0x77, 0x76, 0x82,
  0x6F, 0xE3, 0x28, 0x4A, 0xF6, 0xDF, 0xB2, 0x01, 0xC0, 0x27, 0x77, 0x0A, 0x03, 0x30, 0xAB, 0x0B,
  0x30, 0x6B, 0x0C, 0x77, 0x76, 0x0A, 0xA0, 0xB4, 0x0C, 0xFF, 0xFB, 0x78, 0x1A, 0xFB, 0x40, 0x2F,
  0xFF, 0xC7, 0x0A, 0x0B, 0x50, 0x7F, 0xFF, 0xC7, 0x70, 0xCF, 0xFF, 0xC7, 0x7C, 0x77, 0x77, 0xC4,
  0xC7, 0x77, 0x7C, 0x4C, 0x38, 0x28, 0xDD, 0x87, 0x78, 0x28, 0xDD, 0x83, 0xC4, 0xC2, 0x08, 0xC0,
  0x87, 0x50, 0x8C, 0x08, 0x2C, 0x4C, 0x20, 0xDC, 0x0D, 0x75, 0x0D, 0xC0, 0xD2, 0xC4, 0xC2, 0x0D,
  0xC0, 0xD7, 0x50, 0xDC, 0x0D, 0x2C, 0x4C, 0x20, 0x8C, 0x08, 0x75, 0x08, 0xC0, 0x82, 0xC4, 0xC3,
  0x82, 0x8D, 0xD8, 0x77, 0x82, 0x8D, 0xD8, 0x3C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x48,
  0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x4E, 0x77, 0x73, 0xE4, 0xE7,
  0x77, 0x3E, 0x40, 0xDC, 0x0D, 0x77, 0x73, 0x0D, 0xC0, 0xD4, 0x04, 0x0D, 0xA0, 0xD0, 0x47, 0x77,
  0x30, 0x40, 0xDA, 0x0D, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_bluetooth_drive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_bluetooth_drive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_bluetooth 48x48, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_outlined_48_device_bluetooth_data[] PROGMEM = {
  0x75, 0xA0, 0x77, 0x77, 0x2B, 0x07, 0x77, 0x71, 0xC0, 0x77, 0x77, 0xD0, 0x77, 0x76, 0xE0, 0x77,
  0x75, 0xF0, 0x77, 0x10, 0xA0, 0x57, 0x1F, 0x90, 0x76, 0x0A, 0xA0, 0x57, 0xC0, 0xEC, 0x07, 0x40,
  0xAC, 0x05, 0x6C, 0x03, 0x0E, 0xC0, 0x73, 0x05, 0xD0, 0x55, 0xC1, 0x03, 0x0E, 0xC0, 0x73, 0x05,
  0xD0, 0x54, 0xC2, 0x03, 0x0E, 0xC0, 0x73, 0x05, 0xD0, 0x53, 0xC3, 0x07, 0xD0, 0x23, 0x05, 0xD0,
  0x52, 0xC2, 0x05, 0xD0, 0x55, 0x05, 0xD0, 0x51, 0xC1, 0x05, 0xD0, 0x57, 0x05, 0xD0, 0x5C, 0x05,
  0xD0, 0x57, 0x20, 0x5F, 0xF0, 0x57, 0x40, 0x5F, 0xD0, 0x57, 0x60, 0x5F, 0xB0, 0x57, 0x71, 0x05,
  0xF9, 0x05, 0x77, 0x30, 0x5E, 0x05, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x30, 0x5F, 0x90, 0x57, 0x71,
  0x05, 0xFB, 0x05, 0x76, 0x05, 0xFD, 0x05, 0x74, 0x05, 0xFF, 0x05, 0x72, 0x05, 0xD0, 0x5C, 0x05,
  0xD0, 0x57, 0x05, 0xD0, 0x51, 0xC1, 0x05, 0xD0, 0x55, 0x05, 0xD0, 0x52, 0xC2, 0x05, 0xD0, 0x53,
  0x05, 0xD0, 0x53, 0xC3, 0x07, 0xD8, 0x12, 0x05, 0xD0, 0x54, 0xC2, 0x03, 0x0E, 0xC8, 0x17, 0x05,
  0xD0, 0x55, 0xC1, 0x03, 0x0E, 0xC0, 0x72, 0x0A, 0xC0, 0x56, 0xC0, 0x30, 0xEC, 0x07, 0x40, 0xAA,
  0x05, 0x7C, 0x0E, 0xC0, 0x76, 0x0A, 0x05, 0x71, 0xF9, 0x07, 0x77, 0x3F, 0x07, 0x77, 0x4E, 0x07,
  0x77, 0x5D, 0x07, 0x77, 0x6C, 0x07, 0x77, 0x7B, 0x07, 0x77, 0x71, 0xA0, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_bluetooth() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 35, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_bluetooth_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_bluetooth_searching 48x48, 4-bit Alpha,  RLE, 313 bytes.
static const unsigned char ic_outlined_48_device_bluetooth_searching_data[] PROGMEM = {
  0x75, 0xA0, 0x77, 0x77, 0x75, 0xB0, 0x77, 0x77, 0x74, 0xC0, 0x77, 0x77, 0x73, 0xD0, 0x77, 0x77,
  0x72, 0xE0, 0x77, 0x77, 0x71, 0xF0, 0x77, 0x74, 0x0A, 0x05, 0x71, 0xF9, 0x07, 0x77, 0x20, 0xAA,
  0x05, 0x7C, 0x0E, 0xC0, 0x77, 0x70, 0xAC, 0x05, 0x6C, 0x03, 0x0E, 0xC0, 0x77, 0x60, 0x5D, 0x05,
  0x5C, 0x10, 0x30, 0xEC, 0x07, 0x71, 0x02, 0x01, 0x30, 0x5D, 0x05, 0x4C, 0x20, 0x30, 0xEC, 0x07,
  0x68, 0x12, 0xD9, 0x40, 0x5D, 0x05, 0x3C, 0x30, 0x7D, 0x02, 0x40, 0x20, 0xDA, 0x02, 0x40, 0x5D,
  0x05, 0x2C, 0x20, 0x5D, 0x05, 0x50, 0x3B, 0x08, 0x50, 0x5D, 0x05, 0x1C, 0x10, 0x5D, 0x05, 0x70,
  0xBA, 0x0E, 0x60, 0x5D, 0x05, 0xC0, 0x5D, 0x05, 0x71, 0x06, 0xB0, 0x46, 0x05, 0xFF, 0x05, 0x40,
  0x10, 0x23, 0x01, 0xB0, 0x77, 0x05, 0xFD, 0x05, 0x48, 0x11, 0xD7, 0x40, 0xDA, 0x0A, 0x71, 0x05,
  0xFB, 0x05, 0x48, 0x21, 0xDF, 0xB4, 0x0A, 0xA0, 0xD7, 0x20, 0x5F, 0x90, 0x54, 0x01, 0x0D, 0xA0,
  0xD4, 0x09, 0xA0, 0xE7, 0x30, 0x5E, 0x05, 0x40, 0x10, 0xDB, 0x0E, 0x40, 0x8B, 0x73, 0x05, 0xE0,
  0x54, 0x02, 0x0D, 0xB0, 0xE4, 0x08, 0xB7, 0x20, 0x5F, 0x90, 0x54, 0x02, 0x0D, 0xA0, 0xD4, 0x09,
  0xA0, 0xD7, 0x10, 0x5F, 0xB0, 0x54, 0x82, 0x2D, 0xFB, 0x40, 0xAA, 0x0C, 0x70, 0x5F, 0xD0, 0x54,
  0x81, 0x2D, 0x74, 0x0D, 0xA0, 0x96, 0x05, 0xFF, 0x05, 0x40, 0x02, 0x30, 0x1B, 0x06, 0x50, 0x5D,
  0x05, 0xC0, 0x5D, 0x05, 0x71, 0x06, 0xB0, 0x24, 0x05, 0xD0, 0x51, 0xC1, 0x05, 0xD0, 0x57, 0x0C,
  0xA0, 0xC4, 0x05, 0xD0, 0x52, 0xC2, 0x05, 0xD0, 0x55, 0x03, 0xB0, 0x63, 0x05, 0xD0, 0x53, 0xC3,
  0x07, 0xD0, 0x24, 0x82, 0x1D, 0xFE, 0x30, 0x5D, 0x05, 0x4C, 0x20, 0x30, 0xEC, 0x07, 0x68, 0x11,
  0xD6, 0x20, 0x5D, 0x05, 0x5C, 0x10, 0x30, 0xEC, 0x07, 0x71, 0x01, 0x30, 0xAC, 0x05, 0x6C, 0x03,
  0x0E, 0xC0, 0x77, 0x70, 0xAA, 0x05, 0x7C, 0x0E, 0xC0, 0x77, 0x72, 0x0A, 0x05, 0x71, 0xF9, 0x07,
  0x77, 0x76, 0xF0, 0x77, 0x77, 0x7E, 0x07, 0x77, 0x77, 0x1D, 0x07, 0x77, 0x77, 0x2C, 0x07, 0x77,
  0x77, 0x3B, 0x07, 0x77, 0x77, 0x4A, 0x07, 0x77, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_bluetooth_searching() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_bluetooth_searching_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_brightness_auto 48x48, 4-bit Alpha,  RLE, 377 bytes.
static const unsigned char ic_outlined_48_device_brightness_auto_data[] PROGMEM = {
  0x77, 0x71, 0x00, 0x38, 0x0C, 0x70, 0x82, 0x3E, 0xE3, 0x80, 0xC5, 0x00, 0x30, 0xEA, 0x0E, 0x03,
  0x80, 0xC3, 0x00, 0x30, 0xEC, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x77,
  0x70, 0x30, 0xEF, 0x90, 0xE0, 0x37, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x08, 0xC0, 0xE0, 0x37, 0x77,
  0x2F, 0xF0, 0x82, 0x08, 0xFF, 0x77, 0xFE, 0x08, 0x40, 0x8F, 0xE7, 0x7F, 0xD0, 0x86, 0x08, 0xFD,
  0x77, 0xFC, 0x08, 0x71, 0x08, 0xFC, 0x77, 0xC7, 0x77, 0x3C, 0x77, 0xC7, 0x77, 0x3C, 0x77, 0xC7,
  0x20, 0x2C, 0x02, 0x72, 0xC7, 0x7C, 0x72, 0x08, 0xC0, 0x87, 0x2C, 0x77, 0xC7, 0x20, 0xDC, 0x0D,
  0x72, 0xC7, 0x60, 0x3C, 0x71, 0x03, 0xE0, 0x37, 0x1C, 0x03, 0x74, 0x03, 0x0E, 0xC7, 0x10, 0x9A,
  0x00, 0xDA, 0x09, 0x71, 0xC0, 0xE0, 0x37, 0x20, 0x30, 0xEC, 0x08, 0x71, 0x0E, 0xA0, 0x08, 0xA0,
  0xE7, 0x10, 0x8C, 0x0E, 0x03, 0x70, 0x30, 0xEC, 0x08, 0x71, 0x04, 0xB0, 0x03, 0xB0, 0x47, 0x10,
  0x8C, 0x0E, 0x03, 0x50, 0x30, 0xEC, 0x08, 0x72, 0x0A, 0xA0, 0xD2, 0x0D, 0xA0, 0xA7, 0x20, 0x8C,
  0x0E, 0x03, 0x30, 0x30, 0xEC, 0x08, 0x73, 0x0E, 0xA0, 0x92, 0x09, 0xA0, 0xE7, 0x30, 0x8C, 0x83,
  0xE3, 0x03, 0xEC, 0x08, 0x73, 0x05, 0xB0, 0x42, 0x04, 0xB0, 0x57, 0x30, 0x8C, 0x82, 0xE3, 0x3E,
  0xC0, 0x87, 0x30, 0xBA, 0x0E, 0x40, 0xEA, 0x0B, 0x73, 0x08, 0xC8, 0x3E, 0x30, 0x3E, 0xC0, 0x87,
  0x10, 0x1B, 0x84, 0xEB, 0xBB, 0xBE, 0xB0, 0x17, 0x10, 0x8C, 0x0E, 0x03, 0x30, 0x30, 0xEC, 0x08,
  0x70, 0x6F, 0xD0, 0x67, 0x08, 0xC0, 0xE0, 0x35, 0x03, 0x0E, 0xC0, 0x86, 0x0C, 0xFD, 0x0C, 0x60,
  0x8C, 0x0E, 0x03, 0x70, 0x30, 0xEC, 0x08, 0x40, 0x2B, 0x09, 0x60, 0x9B, 0x02, 0x40, 0x8C, 0x0E,
  0x03, 0x72, 0x03, 0x0E, 0xC4, 0x07, 0xB0, 0x46, 0x04, 0xB0, 0x74, 0xC0, 0xE0, 0x37, 0x40, 0x3C,
  0x40, 0xDA, 0x0E, 0x71, 0x0E, 0xA0, 0xD4, 0xC0, 0x37, 0x6C, 0x30, 0x3B, 0x08, 0x71, 0x08, 0xB0,
  0x33, 0xC7, 0x7C, 0x77, 0x73, 0xC7, 0x7C, 0x77, 0x73, 0xC7, 0x7C, 0x77, 0x73, 0xC7, 0x7C, 0x77,
  0x73, 0xC7, 0x7F, 0xC0, 0x87, 0x10, 0x8F, 0xC7, 0x7F, 0xD0, 0x86, 0x08, 0xFD, 0x77, 0xFE, 0x08,
  0x40, 0x8F, 0xE7, 0x7F, 0xF0, 0x82, 0x08, 0xFF, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x08, 0xC0, 0xE0,
  0x37, 0x77, 0x75, 0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x70, 0x30, 0xEE, 0x0E, 0x03, 0x80,
  0xC1, 0x00, 0x30, 0xEC, 0x0E, 0x03, 0x80, 0xC3, 0x00, 0x30, 0xEA, 0x0E, 0x03, 0x80, 0xC5, 0x08,
  0x23, 0xEE, 0x38, 0x0C, 0x70, 0x00, 0x37, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_brightness_auto() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 46, 46), Box(0, 0, 47, 47),
      ic_outlined_48_device_brightness_auto_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_brightness_high 48x48, 4-bit Alpha,  RLE, 447 bytes.
static const unsigned char ic_outlined_48_device_brightness_high_data[] PROGMEM = {
  0x77, 0x71, 0x00, 0x38, 0x0C, 0x70, 0x82, 0x3E, 0xE3, 0x80, 0xC5, 0x00, 0x30, 0xEA, 0x0E, 0x03,
  0x80, 0xC3, 0x00, 0x30, 0xEC, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x77,
  0x70, 0x30, 0xEF, 0x90, 0xE0, 0x37, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x08, 0xC0, 0xE0, 0x37, 0x77,
  0x2F, 0xF0, 0x82, 0x08, 0xFF, 0x77, 0xFE, 0x08, 0x40, 0x8F, 0xE7, 0x7F, 0xD0, 0x86, 0x08, 0xFD,
  0x77, 0xFC, 0x08, 0x71, 0x08, 0xFC, 0x77, 0xC7, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA6, 0x17, 0xC7,
  0x7C, 0x50, 0x10, 0x9F, 0xB0, 0x90, 0x15, 0xC7, 0x7C, 0x40, 0x40, 0xEF, 0xD0, 0xE0, 0x44, 0xC7,
  0x7C, 0x30, 0x6F, 0xFA, 0x06, 0x3C, 0x77, 0xC2, 0x04, 0xD8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xD0,
  0x42, 0xC7, 0x60, 0x3C, 0x10, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x11, 0xC0, 0x37, 0x40,
  0x30, 0xEC, 0x10, 0x9C, 0x04, 0x73, 0x04, 0xC0, 0x91, 0xC0, 0xE0, 0x37, 0x20, 0x30, 0xEC, 0x08,
  0x01, 0xC0, 0x63, 0x84, 0x4B, 0xEE, 0xB4, 0x30, 0x6C, 0x01, 0x08, 0xC0, 0xE0, 0x37, 0x03, 0x0E,
  0xC8, 0x18, 0x06, 0xB0, 0xC3, 0x08, 0xE0, 0x83, 0x0C, 0xB8, 0x16, 0x08, 0xC0, 0xE0, 0x35, 0x03,
  0x0E, 0xC0, 0x82, 0x0B, 0xB0, 0x62, 0x04, 0xF9, 0x04, 0x20, 0x6B, 0x0B, 0x20, 0x8C, 0x0E, 0x03,
  0x30, 0x30, 0xEC, 0x08, 0x30, 0xDB, 0x02, 0x20, 0xBF, 0x90, 0xB2, 0x02, 0xB0, 0xD3, 0x08, 0xC8,
  0x3E, 0x30, 0x3E, 0xC0, 0x84, 0x0E, 0xB3, 0x0E, 0xF9, 0x0E, 0x3B, 0x0E, 0x40, 0x8C, 0x82, 0xE3,
  0x3E, 0xC0, 0x84, 0x0E, 0xB3, 0x0E, 0xF9, 0x0E, 0x3B, 0x0E, 0x40, 0x8C, 0x83, 0xE3, 0x03, 0xEC,
  0x08, 0x30, 0xDB, 0x02, 0x20, 0xBF, 0x90, 0xB2, 0x02, 0xB0, 0xD3, 0x08, 0xC0, 0xE0, 0x33, 0x03,
  0x0E, 0xC0, 0x82, 0x0B, 0xB0, 0x62, 0x04, 0xF9, 0x04, 0x20, 0x6B, 0x0B, 0x20, 0x8C, 0x0E, 0x03,
  0x50, 0x30, 0xEC, 0x81, 0x80, 0x6B, 0x0C, 0x30, 0x8E, 0x08, 0x30, 0xCB, 0x81, 0x60, 0x8C, 0x0E,
  0x03, 0x70, 0x30, 0xEC, 0x08, 0x01, 0xC0, 0x63, 0x84, 0x4B, 0xEE, 0xB4, 0x30, 0x6C, 0x01, 0x08,
  0xC0, 0xE0, 0x37, 0x20, 0x30, 0xEC, 0x10, 0x9C, 0x04, 0x73, 0x04, 0xC0, 0x91, 0xC0, 0xE0, 0x37,
  0x40, 0x3C, 0x10, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x11, 0xC0, 0x37, 0x6C, 0x20, 0x4D,
  0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x04, 0x2C, 0x77, 0xC3, 0x06, 0xFF, 0xA0, 0x63, 0xC7, 0x7C,
  0x40, 0x40, 0xEF, 0xD0, 0xE0, 0x44, 0xC7, 0x7C, 0x50, 0x10, 0x9F, 0xB0, 0x90, 0x15, 0xC7, 0x7C,
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x7C, 0x77, 0xFC, 0x08, 0x71, 0x08, 0xFC, 0x77, 0xFD,
  0x08, 0x60, 0x8F, 0xD7, 0x7F, 0xE0, 0x84, 0x08, 0xFE, 0x77, 0xFF, 0x08, 0x20, 0x8F, 0xF7, 0x77,
  0x20, 0x30, 0xEC, 0x00, 0x8C, 0x0E, 0x03, 0x77, 0x77, 0x50, 0x30, 0xEF, 0x90, 0xE0, 0x37, 0x77,
  0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x38, 0x0C, 0x10, 0x03, 0x0E, 0xC0, 0xE0, 0x38, 0x0C, 0x30, 0x03,
  0x0E, 0xA0, 0xE0, 0x38, 0x0C, 0x50, 0x82, 0x3E, 0xE3, 0x80, 0xC7, 0x00, 0x03, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_brightness_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 46, 46), Box(0, 0, 47, 47),
      ic_outlined_48_device_brightness_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_brightness_low 48x48, 4-bit Alpha,  RLE, 417 bytes.
static const unsigned char ic_outlined_48_device_brightness_low_data[] PROGMEM = {
  0x77, 0x71, 0x00, 0x38, 0x0C, 0x70, 0x82, 0x3E, 0xE3, 0x80, 0xC5, 0x00, 0x30, 0xEA, 0x0E, 0x03,
  0x80, 0xC3, 0x00, 0x30, 0xEC, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x77,
  0x70, 0x30, 0xEF, 0x90, 0xE0, 0x37, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x08, 0xC0, 0xE0, 0x37, 0x77,
  0x2F, 0xF0, 0x82, 0x08, 0xFF, 0x77, 0xFE, 0x08, 0x40, 0x8F, 0xE7, 0x7F, 0xD0, 0x86, 0x08, 0xFD,
  0x77, 0xFC, 0x08, 0x71, 0x08, 0xFC, 0x77, 0xC7, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA6, 0x17, 0xC7,
  0x7C, 0x50, 0x10, 0x9F, 0xB0, 0x90, 0x15, 0xC7, 0x7C, 0x40, 0x40, 0xEF, 0xD0, 0xE0, 0x44, 0xC7,
  0x7C, 0x30, 0x6F, 0xFA, 0x06, 0x3C, 0x77, 0xC2, 0x04, 0xD8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xD0,
  0x42, 0xC7, 0x60, 0x3C, 0x10, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x11, 0xC0, 0x37, 0x40,
  0x30, 0xEC, 0x10, 0x9C, 0x04, 0x73, 0x04, 0xC0, 0x91, 0xC0, 0xE0, 0x37, 0x20, 0x30, 0xEC, 0x08,
  0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x08, 0xC0, 0xE0, 0x37, 0x03, 0x0E, 0xC8, 0x18, 0x06, 0xB0,
  0xC7, 0x70, 0xCB, 0x81, 0x60, 0x8C, 0x0E, 0x03, 0x50, 0x30, 0xEC, 0x08, 0x20, 0xBB, 0x06, 0x77,
  0x06, 0xB0, 0xB2, 0x08, 0xC0, 0xE0, 0x33, 0x03, 0x0E, 0xC0, 0x83, 0x0D, 0xB0, 0x27, 0x70, 0x2B,
  0x0D, 0x30, 0x8C, 0x83, 0xE3, 0x03, 0xEC, 0x08, 0x40, 0xEB, 0x77, 0x2B, 0x0E, 0x40, 0x8C, 0x82,
  0xE3, 0x3E, 0xC0, 0x84, 0x0E, 0xB7, 0x72, 0xB0, 0xE4, 0x08, 0xC8, 0x3E, 0x30, 0x3E, 0xC0, 0x83,
  0x0D, 0xB0, 0x27, 0x70, 0x2B, 0x0D, 0x30, 0x8C, 0x0E, 0x03, 0x30, 0x30, 0xEC, 0x08, 0x20, 0xBB,
  0x06, 0x77, 0x06, 0xB0, 0xB2, 0x08, 0xC0, 0xE0, 0x35, 0x03, 0x0E, 0xC8, 0x18, 0x06, 0xB0, 0xC7,
  0x70, 0xCB, 0x81, 0x60, 0x8C, 0x0E, 0x03, 0x70, 0x30, 0xEC, 0x08, 0x01, 0xC0, 0x67, 0x50, 0x6C,
  0x01, 0x08, 0xC0, 0xE0, 0x37, 0x20, 0x30, 0xEC, 0x10, 0x9C, 0x04, 0x73, 0x04, 0xC0, 0x91, 0xC0,
  0xE0, 0x37, 0x40, 0x3C, 0x10, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x11, 0xC0, 0x37, 0x6C,
  0x20, 0x4D, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x04, 0x2C, 0x77, 0xC3, 0x06, 0xFF, 0xA0, 0x63,
  0xC7, 0x7C, 0x40, 0x40, 0xEF, 0xD0, 0xE0, 0x44, 0xC7, 0x7C, 0x50, 0x10, 0x9F, 0xB0, 0x90, 0x15,
  0xC7, 0x7C, 0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x7C, 0x77, 0xFC, 0x08, 0x71, 0x08, 0xFC,
  0x77, 0xFD, 0x08, 0x60, 0x8F, 0xD7, 0x7F, 0xE0, 0x84, 0x08, 0xFE, 0x77, 0xFF, 0x08, 0x20, 0x8F,
  0xF7, 0x77, 0x20, 0x30, 0xEC, 0x00, 0x8C, 0x0E, 0x03, 0x77, 0x77, 0x50, 0x30, 0xEF, 0x90, 0xE0,
  0x37, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x38, 0x0C, 0x10, 0x03, 0x0E, 0xC0, 0xE0, 0x38, 0x0C,
  0x30, 0x03, 0x0E, 0xA0, 0xE0, 0x38, 0x0C, 0x50, 0x82, 0x3E, 0xE3, 0x80, 0xC7, 0x00, 0x03, 0x77,
  0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_brightness_low() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 46, 46), Box(0, 0, 47, 47),
      ic_outlined_48_device_brightness_low_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_brightness_medium 48x48, 4-bit Alpha,  RLE, 345 bytes.
static const unsigned char ic_outlined_48_device_brightness_medium_data[] PROGMEM = {
  0x77, 0x71, 0x00, 0x38, 0x0C, 0x70, 0x82, 0x3E, 0xE3, 0x80, 0xC5, 0x00, 0x30, 0xEA, 0x0E, 0x03,
  0x80, 0xC3, 0x00, 0x30, 0xEC, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x77,
  0x70, 0x30, 0xEF, 0x90, 0xE0, 0x37, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x08, 0xC0, 0xE0, 0x37, 0x77,
  0x2F, 0xF0, 0x82, 0x08, 0xFF, 0x77, 0xFE, 0x08, 0x40, 0x8F, 0xE7, 0x7F, 0xD0, 0x86, 0x08, 0xFD,
  0x77, 0xFC, 0x08, 0x71, 0x08, 0xFC, 0x77, 0xC7, 0x58, 0x3E, 0xDA, 0x61, 0x7C, 0x77, 0xC7, 0x5D,
  0x09, 0x01, 0x5C, 0x77, 0xC7, 0x5E, 0x0E, 0x04, 0x4C, 0x77, 0xC7, 0x5F, 0x90, 0x63, 0xC7, 0x7C,
  0x75, 0xFA, 0x04, 0x2C, 0x76, 0x03, 0xC7, 0x5F, 0xA0, 0xE0, 0x11, 0xC0, 0x37, 0x40, 0x30, 0xEC,
  0x75, 0xFB, 0x09, 0x1C, 0x0E, 0x03, 0x72, 0x03, 0x0E, 0xC0, 0x87, 0x5F, 0xC0, 0x10, 0x8C, 0x0E,
  0x03, 0x70, 0x30, 0xEC, 0x08, 0x76, 0xFC, 0x81, 0x60, 0x8C, 0x0E, 0x03, 0x50, 0x30, 0xEC, 0x08,
  0x77, 0xFC, 0x0B, 0x20, 0x8C, 0x0E, 0x03, 0x30, 0x30, 0xEC, 0x08, 0x77, 0x1F, 0xC0, 0xD3, 0x08,
  0xC8, 0x3E, 0x30, 0x3E, 0xC0, 0x87, 0x72, 0xFC, 0x0E, 0x40, 0x8C, 0x82, 0xE3, 0x3E, 0xC0, 0x87,
  0x72, 0xFC, 0x0E, 0x40, 0x8C, 0x83, 0xE3, 0x03, 0xEC, 0x08, 0x77, 0x1F, 0xC0, 0xD3, 0x08, 0xC0,
  0xE0, 0x33, 0x03, 0x0E, 0xC0, 0x87, 0x7F, 0xC0, 0xB2, 0x08, 0xC0, 0xE0, 0x35, 0x03, 0x0E, 0xC0,
  0x87, 0x6F, 0xC8, 0x16, 0x08, 0xC0, 0xE0, 0x37, 0x03, 0x0E, 0xC0, 0x87, 0x5F, 0xC0, 0x10, 0x8C,
  0x0E, 0x03, 0x72, 0x03, 0x0E, 0xC7, 0x5F, 0xB0, 0x91, 0xC0, 0xE0, 0x37, 0x40, 0x3C, 0x75, 0xFA,
  0x0E, 0x01, 0x1C, 0x03, 0x76, 0xC7, 0x5F, 0xA0, 0x42, 0xC7, 0x7C, 0x75, 0xF9, 0x06, 0x3C, 0x77,
  0xC7, 0x5E, 0x0E, 0x04, 0x4C, 0x77, 0xC7, 0x5D, 0x09, 0x01, 0x5C, 0x77, 0xC7, 0x58, 0x3E, 0xDA,
  0x61, 0x7C, 0x77, 0xFC, 0x08, 0x71, 0x08, 0xFC, 0x77, 0xFD, 0x08, 0x60, 0x8F, 0xD7, 0x7F, 0xE0,
  0x84, 0x08, 0xFE, 0x77, 0xFF, 0x08, 0x20, 0x8F, 0xF7, 0x77, 0x20, 0x30, 0xEC, 0x00, 0x8C, 0x0E,
  0x03, 0x77, 0x77, 0x50, 0x30, 0xEF, 0x90, 0xE0, 0x37, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0xE0, 0x38,
  0x0C, 0x10, 0x03, 0x0E, 0xC0, 0xE0, 0x38, 0x0C, 0x30, 0x03, 0x0E, 0xA0, 0xE0, 0x38, 0x0C, 0x50,
  0x82, 0x3E, 0xE3, 0x80, 0xC7, 0x00, 0x03, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_brightness_medium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 46, 46), Box(0, 0, 47, 47),
      ic_outlined_48_device_brightness_medium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_cable 48x48, 4-bit Alpha,  RLE, 223 bytes.
static const unsigned char ic_outlined_48_device_cable_data[] PROGMEM = {
  0x71, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x73, 0x04, 0x0D, 0xC0, 0xD0, 0x47, 0x20, 0x9F, 0x90, 0x97,
  0x20, 0xDE, 0x0D, 0x71, 0x0B, 0xFB, 0x0B, 0x71, 0xF9, 0x70, 0x9F, 0xD0, 0x97, 0xF9, 0x60, 0x2C,
  0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x24, 0xFD, 0x40, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08, 0x4F,
  0xD4, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC4, 0xFD, 0x40, 0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x4F, 0xD4,
  0xC7, 0x1C, 0x4F, 0xD4, 0xC7, 0x1C, 0x4F, 0xD4, 0xC7, 0x1C, 0x4F, 0xD4, 0xC7, 0x1C, 0x4F, 0xD4,
  0xC7, 0x1C, 0x40, 0xDF, 0xB0, 0xD4, 0xC7, 0x1C, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x44, 0xC7, 0x1C,
  0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71,
  0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7,
  0x1C, 0x40, 0x40, 0xDF, 0x90, 0xD0, 0x44, 0xC7, 0x1C, 0x40, 0xDF, 0xB0, 0xD4, 0xC7, 0x1C, 0x4F,
  0xD4, 0xC7, 0x1C, 0x4F, 0xD4, 0xC7, 0x1C, 0x4F, 0xD4, 0xC7, 0x1C, 0x4F, 0xD4, 0xC7, 0x1C, 0x4F,
  0xD4, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE4, 0xFD, 0x40, 0xCB, 0x05, 0x60, 0x5B, 0x0C, 0x4F, 0xD4,
  0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x84, 0xFD, 0x40, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0,
  0x26, 0xF9, 0x70, 0x9F, 0xD0, 0x97, 0xF9, 0x71, 0x0B, 0xFB, 0x0B, 0x71, 0x0D, 0xE0, 0xD7, 0x20,
  0x9F, 0x90, 0x97, 0x20, 0x40, 0xDC, 0x0D, 0x04, 0x73, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_cable() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_cable_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_cameraswitch 48x48, 4-bit Alpha,  RLE, 396 bytes.
static const unsigned char ic_outlined_48_device_cameraswitch_data[] PROGMEM = {
  0x77, 0x48, 0x34, 0x8A, 0xCE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x76, 0x06, 0xFE, 0x81, 0xC7,
  0x17, 0x77, 0x74, 0x06, 0xFF, 0x81, 0xE9, 0x17, 0x77, 0x73, 0x06, 0xFF, 0x90, 0xE0, 0x77, 0x77,
  0x73, 0x06, 0xD8, 0x27, 0x68, 0xCF, 0x0D, 0x02, 0x77, 0x77, 0x20, 0x6C, 0x0E, 0x04, 0x28, 0x12,
  0x7D, 0xD0, 0xE0, 0x57, 0x77, 0x72, 0x06, 0xC0, 0xE0, 0x44, 0x06, 0x0E, 0xD0, 0x77, 0x77, 0x72,
  0x06, 0xC0, 0x85, 0x01, 0x09, 0xD0, 0x77, 0x77, 0x72, 0x06, 0xA0, 0x97, 0x10, 0x6D, 0x05, 0x77,
  0x77, 0x20, 0x60, 0x97, 0x30, 0x40, 0xEC, 0x03, 0x80, 0xC6, 0x00, 0x4C, 0x0D, 0x80, 0xC7, 0x00,
  0x5C, 0x09, 0x77, 0x71, 0x07, 0xF9, 0x07, 0x74, 0x08, 0xC0, 0x27, 0x76, 0x07, 0xFB, 0x07, 0x74,
  0x0E, 0xB0, 0xA7, 0x71, 0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x16, 0x05, 0xC0, 0x17, 0x60, 0x10,
  0xEF, 0xFE, 0x0E, 0x01, 0x60, 0xCB, 0x07, 0x76, 0x0A, 0xF0, 0xE0, 0x34, 0x03, 0x0E, 0xF0, 0xA6,
  0x06, 0xB0, 0xD7, 0x60, 0xDE, 0x0E, 0x03, 0x60, 0x30, 0xEE, 0x0D, 0x60, 0x1C, 0x02, 0x75, 0xC7,
  0x72, 0xC7, 0x0A, 0xB0, 0x67, 0x5C, 0x77, 0x2C, 0x70, 0x7B, 0x09, 0x75, 0xC5, 0x84, 0x1A, 0xDD,
  0xA1, 0x5C, 0x70, 0x4B, 0x0C, 0x75, 0xC4, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0xC7, 0x01, 0xB0, 0xE7,
  0x5C, 0x40, 0xAE, 0x0A, 0x4C, 0x77, 0x73, 0xC4, 0x0D, 0xE0, 0xD4, 0xC7, 0x77, 0x3C, 0x40, 0xDE,
  0x0D, 0x4C, 0x77, 0x73, 0xC4, 0x0A, 0xE0, 0xA4, 0xC7, 0x50, 0xEB, 0x01, 0x7C, 0x40, 0x10, 0xEC,
  0x0E, 0x01, 0x4C, 0x75, 0x0C, 0xB0, 0x47, 0xC5, 0x84, 0x1A, 0xDD, 0xA1, 0x5C, 0x75, 0x09, 0xB0,
  0x77, 0xC7, 0x72, 0xC7, 0x50, 0x6B, 0x0A, 0x7C, 0x77, 0x2C, 0x75, 0x02, 0xC0, 0x16, 0x0D, 0xFF,
  0xF9, 0x0D, 0x76, 0x0D, 0xB0, 0x66, 0x0A, 0xFF, 0xF9, 0x0A, 0x76, 0x07, 0xB0, 0xC6, 0x01, 0x0E,
  0xFF, 0xE0, 0xE0, 0x17, 0x60, 0x1C, 0x05, 0x68, 0x11, 0xAD, 0xFF, 0xA8, 0x1D, 0xA1, 0x77, 0x10,
  0xAB, 0x0E, 0x80, 0xC7, 0x00, 0x2C, 0x08, 0x80, 0xC7, 0x00, 0x9C, 0x05, 0x80, 0xC7, 0x00, 0xDC,
  0x04, 0x80, 0xC6, 0x00, 0x3C, 0x0E, 0x04, 0x73, 0x09, 0x06, 0x77, 0x77, 0x20, 0x5D, 0x06, 0x71,
  0x09, 0xA0, 0x67, 0x77, 0x72, 0x07, 0xD0, 0x90, 0x15, 0x08, 0xC0, 0x67, 0x77, 0x72, 0x07, 0xD0,
  0xE0, 0x64, 0x04, 0x0E, 0xC0, 0x67, 0x77, 0x72, 0x05, 0x0E, 0xD8, 0x1D, 0x72, 0x20, 0x40, 0xEC,
  0x06, 0x77, 0x77, 0x20, 0x20, 0xDF, 0x82, 0xC8, 0x67, 0xD0, 0x67, 0x77, 0x73, 0x07, 0x0E, 0xFF,
  0x90, 0x67, 0x77, 0x73, 0x81, 0x19, 0xEF, 0xF0, 0x67, 0x77, 0x74, 0x81, 0x17, 0xCF, 0xE0, 0x67,
  0x77, 0x76, 0x84, 0x15, 0x8B, 0xDE, 0xA8, 0x3E, 0xCA, 0x84, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_cameraswitch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 47, 47), Box(0, 0, 47, 47),
      ic_outlined_48_device_cameraswitch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_credit_score 48x48, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_outlined_48_device_credit_score_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0x80, 0xD8, 0x4F, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C,
  0x77, 0x77, 0x40, 0x40, 0x92, 0xC7, 0x77, 0x73, 0x04, 0xA0, 0x91, 0xC7, 0x77, 0x72, 0x04, 0xC0,
  0x9C, 0x77, 0x77, 0x10, 0x4D, 0x05, 0xC7, 0x77, 0x70, 0x4D, 0x05, 0x1C, 0x77, 0x20, 0x17, 0x30,
  0x4D, 0x05, 0x2C, 0x77, 0x18, 0x19, 0xD2, 0x71, 0x04, 0xD0, 0x53, 0xC7, 0x70, 0x9A, 0x0D, 0x02,
  0x60, 0x4D, 0x05, 0x4C, 0x76, 0x05, 0xC0, 0xD0, 0x24, 0x04, 0xD0, 0x55, 0x0D, 0xFE, 0x40, 0x9C,
  0x0D, 0x02, 0x20, 0x4D, 0x05, 0x60, 0xAF, 0xE5, 0x09, 0xC8, 0x1D, 0x24, 0xD0, 0x57, 0x01, 0x0E,
  0xFD, 0x60, 0x9C, 0x0D, 0xD0, 0x57, 0x28, 0x11, 0xAE, 0xFB, 0x70, 0x9F, 0x90, 0x57, 0x77, 0x73,
  0x09, 0xE0, 0x57, 0x77, 0x75, 0x09, 0xC0, 0x57, 0x77, 0x77, 0x09, 0xA0, 0x58, 0x0C, 0x10, 0x09,
  0x05, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_credit_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_credit_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_dark_mode 48x48, 4-bit Alpha,  RLE, 286 bytes.
static const unsigned char ic_outlined_48_device_dark_mode_data[] PROGMEM = {
  0x75, 0x87, 0x15, 0x9B, 0xDE, 0xFD, 0x47, 0x77, 0x40, 0x40, 0xBF, 0x04, 0x77, 0x73, 0x03, 0x0B,
  0xF9, 0x06, 0x77, 0x73, 0x08, 0xFA, 0x0B, 0x77, 0x72, 0x01, 0x0B, 0xFB, 0x03, 0x77, 0x71, 0x01,
  0x0C, 0xD0, 0x90, 0x7B, 0x0D, 0x77, 0x72, 0x0B, 0xC8, 0x2D, 0x30, 0x8B, 0x08, 0x77, 0x71, 0x08,
  0xC0, 0xB3, 0x0A, 0xB0, 0x57, 0x77, 0x03, 0xC0, 0xB4, 0x0B, 0xB0, 0x47, 0x77, 0x0B, 0xB0, 0xD0,
  0x14, 0x0B, 0xB0, 0x37, 0x76, 0x04, 0xC0, 0x35, 0x0A, 0xB0, 0x57, 0x76, 0x0B, 0xB0, 0x96, 0x08,
  0xB0, 0x87, 0x75, 0x01, 0xC0, 0x26, 0x05, 0xB0, 0xC7, 0x75, 0x05, 0xB0, 0xB7, 0x1C, 0x03, 0x77,
  0x40, 0x9B, 0x07, 0x71, 0x0A, 0xB0, 0xB7, 0x74, 0x0B, 0xB0, 0x37, 0x10, 0x3C, 0x06, 0x77, 0x20,
  0x30, 0xDB, 0x01, 0x72, 0x0A, 0xC0, 0x47, 0x78, 0x14, 0xDE, 0xB7, 0x30, 0x20, 0xEC, 0x06, 0x75,
  0x82, 0x6F, 0xEE, 0xB7, 0x40, 0x4D, 0x0B, 0x03, 0x71, 0x03, 0x0B, 0xA0, 0xE0, 0xDB, 0x02, 0x74,
  0x05, 0xE8, 0x6C, 0x75, 0x34, 0x58, 0xDC, 0x0D, 0x0B, 0xB0, 0x37, 0x50, 0x40, 0xEF, 0xFA, 0x0B,
  0x09, 0xB0, 0x77, 0x60, 0x20, 0xAF, 0xF9, 0x09, 0x05, 0xB0, 0xC7, 0x71, 0x03, 0x0A, 0xFE, 0x05,
  0x01, 0xC0, 0x27, 0x73, 0x86, 0x58, 0x9B, 0xBB, 0x87, 0xC8, 0x11, 0x0B, 0xB0, 0xA7, 0x77, 0x30,
  0x9B, 0x0B, 0x20, 0x4C, 0x03, 0x77, 0x71, 0x03, 0xC0, 0x43, 0x0B, 0xB0, 0xD0, 0x17, 0x77, 0x0D,
  0xB0, 0xB4, 0x03, 0xC0, 0xB7, 0x76, 0x0B, 0xC0, 0x35, 0x08, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B,
  0xC0, 0x87, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x71, 0x01, 0x0C, 0xD0, 0xA0, 0x27,
  0x30, 0x20, 0x9D, 0x0C, 0x01, 0x72, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x13, 0x7B, 0xE0,
  0xB0, 0x17, 0x50, 0x8F, 0xFE, 0x08, 0x77, 0x10, 0x30, 0xBF, 0xFA, 0x0B, 0x03, 0x77, 0x40, 0x40,
  0xBF, 0xD0, 0xB0, 0x47, 0x77, 0x18, 0x92, 0x15, 0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_dark_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_dark_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_data_saver_off 48x48, 4-bit Alpha,  RLE, 301 bytes.
static const unsigned char ic_outlined_48_device_data_saver_off_data[] PROGMEM = {
  0x77, 0x82, 0x36, 0x9C, 0x48, 0x2C, 0x96, 0x37, 0x77, 0x48, 0x11, 0x7D, 0xC4, 0xC8, 0x1D, 0x71,
  0x77, 0x70, 0x8F, 0x4F, 0x08, 0x77, 0x40, 0x40, 0xDF, 0x94, 0xF9, 0x0D, 0x04, 0x77, 0x10, 0x8F,
  0xB4, 0xFB, 0x08, 0x76, 0x0A, 0xFC, 0x4F, 0xC0, 0x97, 0x40, 0xBF, 0xA8, 0x1C, 0x84, 0x48, 0x14,
  0x8C, 0xFA, 0x0A, 0x72, 0x08, 0xF9, 0x0A, 0x03, 0x73, 0x03, 0x0A, 0xF9, 0x07, 0x70, 0x4F, 0x0D,
  0x04, 0x77, 0x04, 0x0D, 0xF0, 0x45, 0x01, 0x0E, 0xE0, 0xB7, 0x74, 0x0B, 0xE0, 0xE0, 0x14, 0x08,
  0xE0, 0xB7, 0x76, 0x0B, 0xE0, 0x73, 0x01, 0x0E, 0xD0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xD0, 0xE0,
  0x12, 0x08, 0xE0, 0x37, 0x77, 0x10, 0x3E, 0x07, 0x20, 0xDD, 0x0A, 0x77, 0x73, 0x0A, 0xD8, 0x1D,
  0x02, 0xE0, 0x27, 0x77, 0x30, 0x2E, 0x02, 0x06, 0xD0, 0xC7, 0x77, 0x50, 0xCD, 0x06, 0x0A, 0xD0,
  0x77, 0x77, 0x50, 0x7D, 0x0A, 0x0B, 0xD0, 0x37, 0x77, 0x50, 0x3D, 0x0B, 0x0D, 0xD0, 0x27, 0x77,
  0x50, 0x2D, 0x0D, 0x0E, 0xD7, 0x77, 0x7D, 0x0E, 0xE7, 0x77, 0x7E, 0x0E, 0xD0, 0x27, 0x77, 0x50,
  0x2D, 0x0E, 0x0C, 0xD0, 0x37, 0x77, 0x50, 0x3D, 0x0C, 0x0A, 0xD0, 0x77, 0x77, 0x50, 0x7D, 0x0A,
  0x07, 0xD0, 0xC7, 0x77, 0x50, 0xCD, 0x07, 0x03, 0xE0, 0x27, 0x77, 0x40, 0x50, 0xDC, 0x81, 0x20,
  0xDD, 0x0A, 0x77, 0x76, 0x08, 0xA0, 0xD2, 0x08, 0xE0, 0x37, 0x77, 0x68, 0x12, 0xA7, 0x20, 0x1E,
  0x0D, 0x01, 0x77, 0x77, 0x40, 0x9E, 0x0B, 0x77, 0x68, 0x1C, 0xD4, 0x72, 0x01, 0x0E, 0xE0, 0xB0,
  0x17, 0x73, 0x0C, 0xB0, 0xB0, 0x27, 0x10, 0x5F, 0x0D, 0x03, 0x77, 0x04, 0x0D, 0xE0, 0x87, 0x10,
  0x9F, 0x90, 0xA0, 0x27, 0x30, 0x20, 0x9F, 0x90, 0x87, 0x20, 0xBF, 0xA8, 0x2C, 0x74, 0x22, 0x82,
  0x24, 0x7C, 0xFA, 0x0A, 0x74, 0x0B, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x08, 0x77, 0x10,
  0x50, 0xEF, 0xFE, 0x0E, 0x04, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x08, 0x77, 0x78, 0x11, 0x8D, 0xFD,
  0x81, 0xD7, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCE, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_data_saver_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_data_saver_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_data_saver_on 48x48, 4-bit Alpha,  RLE, 309 bytes.
static const unsigned char ic_outlined_48_device_data_saver_on_data[] PROGMEM = {
  0x77, 0x82, 0x36, 0x9C, 0x48, 0x2C, 0x96, 0x37, 0x77, 0x48, 0x11, 0x7D, 0xC4, 0xC8, 0x1D, 0x71,
  0x77, 0x70, 0x8F, 0x4F, 0x08, 0x77, 0x40, 0x40, 0xDF, 0x94, 0xF9, 0x0D, 0x04, 0x77, 0x10, 0x8F,
  0xB4, 0xFB, 0x08, 0x76, 0x0A, 0xFC, 0x4F, 0xC0, 0x97, 0x40, 0xBF, 0xA8, 0x1C, 0x84, 0x48, 0x14,
  0x8C, 0xFA, 0x0A, 0x72, 0x08, 0xF9, 0x0A, 0x03, 0x73, 0x03, 0x0A, 0xF9, 0x07, 0x70, 0x4F, 0x0D,
  0x04, 0x77, 0x04, 0x0D, 0xF0, 0x45, 0x01, 0x0E, 0xE0, 0xB7, 0x74, 0x0B, 0xE0, 0xE0, 0x14, 0x08,
  0xE0, 0xB7, 0x76, 0x0B, 0xE0, 0x73, 0x01, 0x0E, 0xD0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xD0, 0xE0,
  0x12, 0x08, 0xE0, 0x37, 0x2C, 0x72, 0x03, 0xE0, 0x72, 0x0D, 0xD0, 0xA7, 0x3C, 0x73, 0x0A, 0xD8,
  0x1D, 0x02, 0xE0, 0x27, 0x3C, 0x73, 0x02, 0xE0, 0x20, 0x6D, 0x0C, 0x74, 0xC7, 0x40, 0xCD, 0x06,
  0x0A, 0xD0, 0x77, 0x4C, 0x74, 0x07, 0xD0, 0xA0, 0xBD, 0x03, 0x74, 0xC7, 0x40, 0x3D, 0x0B, 0x0D,
  0xD0, 0x25, 0xFF, 0xA5, 0x02, 0xD0, 0xD0, 0xED, 0x6F, 0xFA, 0x6D, 0x0E, 0xE6, 0xFF, 0xA6, 0xE0,
  0xED, 0x02, 0x5F, 0xFA, 0x50, 0x2D, 0x0E, 0x0C, 0xD0, 0x37, 0x4C, 0x74, 0x03, 0xD0, 0xC0, 0xAD,
  0x07, 0x74, 0xC7, 0x40, 0x7D, 0x0A, 0x07, 0xD0, 0xC7, 0x4C, 0x74, 0x0C, 0xD0, 0x70, 0x3E, 0x02,
  0x73, 0xC7, 0x40, 0x50, 0xDC, 0x81, 0x20, 0xDD, 0x0A, 0x73, 0xC7, 0x60, 0x8A, 0x0D, 0x20, 0x8E,
  0x03, 0x72, 0xC7, 0x78, 0x12, 0xA7, 0x20, 0x1E, 0x0D, 0x01, 0x77, 0x77, 0x40, 0x9E, 0x0B, 0x77,
  0x68, 0x1C, 0xD4, 0x72, 0x01, 0x0E, 0xE0, 0xB0, 0x17, 0x73, 0x0C, 0xB0, 0xB0, 0x27, 0x10, 0x5F,
  0x0D, 0x03, 0x77, 0x04, 0x0D, 0xE0, 0x87, 0x10, 0x9F, 0x90, 0xA0, 0x27, 0x30, 0x20, 0x9F, 0x90,
  0x87, 0x20, 0xBF, 0xA8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xFA, 0x0A, 0x74, 0x0B, 0xFF, 0xFD,
  0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x08, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x04, 0x77, 0x30, 0x10,
  0x9F, 0xFC, 0x08, 0x77, 0x78, 0x11, 0x8D, 0xFD, 0x81, 0xD7, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCE,
  0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_data_saver_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_data_saver_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_dataset_linked 48x48, 4-bit Alpha,  RLE, 253 bytes.
static const unsigned char ic_outlined_48_device_dataset_linked_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x17, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x16, 0x0A,
  0xFF, 0xFF, 0xE0, 0xA6, 0x0D, 0xFF, 0xFF, 0xE0, 0xD6, 0xC7, 0x77, 0x7C, 0x6C, 0x77, 0x77, 0xC6,
  0xC7, 0x77, 0x7C, 0x6C, 0x77, 0x77, 0xC6, 0xC4, 0xF9, 0x4F, 0x94, 0xC6, 0xC4, 0xF9, 0x4F, 0x94,
  0xC6, 0xC4, 0xF9, 0x4F, 0x94, 0xC6, 0xC4, 0xF9, 0x4F, 0x94, 0xC6, 0xC4, 0xF9, 0x4F, 0x94, 0xC6,
  0xC4, 0xF9, 0x4F, 0x94, 0xC6, 0xC4, 0xF9, 0x4F, 0x94, 0xC6, 0xC4, 0xF9, 0x4F, 0x94, 0xC6, 0xC7,
  0x77, 0x7C, 0x6C, 0x77, 0x77, 0xC6, 0xC7, 0x77, 0x73, 0x01, 0x6C, 0x80, 0xC2, 0x0C, 0x4E, 0x0B,
  0x77, 0x76, 0xC4, 0xD0, 0x97, 0x77, 0x7C, 0x4C, 0x0B, 0x58, 0x22, 0x8C, 0xEC, 0x4C, 0x82, 0xEC,
  0x82, 0x4C, 0x4B, 0x0D, 0x50, 0x9F, 0x94, 0xF9, 0x09, 0x3C, 0x4B, 0x06, 0x40, 0xBF, 0xA4, 0xFA,
  0x0B, 0x2C, 0x4A, 0x0D, 0x40, 0x9F, 0xB4, 0xFB, 0x09, 0x1C, 0x4A, 0x09, 0x30, 0x2C, 0x81, 0xD5,
  0x17, 0x58, 0x11, 0x5D, 0xC0, 0x2C, 0x4A, 0x04, 0x30, 0x8B, 0x0D, 0x01, 0x77, 0x20, 0x10, 0xDB,
  0x08, 0xC7, 0x30, 0xCB, 0x05, 0x3F, 0xD3, 0x05, 0xB0, 0xCC, 0x73, 0x0E, 0xB0, 0x13, 0xFD, 0x30,
  0x1B, 0x0E, 0xC7, 0x30, 0xEB, 0x01, 0x3F, 0xD3, 0x01, 0xB0, 0xEC, 0x73, 0x0C, 0xB0, 0x53, 0xFD,
  0x30, 0x5B, 0x0C, 0x0D, 0xFA, 0x04, 0x30, 0x8B, 0x0D, 0x01, 0x77, 0x20, 0x10, 0xDB, 0x08, 0x0A,
  0xFA, 0x08, 0x30, 0x2C, 0x81, 0xD5, 0x17, 0x58, 0x11, 0x5D, 0xC8, 0x12, 0x1E, 0xF9, 0x0D, 0x40,
  0x9F, 0xB4, 0xFB, 0x09, 0x28, 0x11, 0xAD, 0xF0, 0x54, 0x0B, 0xFA, 0x4F, 0xA0, 0xB7, 0x75, 0x09,
  0xF9, 0x4F, 0x90, 0x97, 0x77, 0x82, 0x28, 0xCE, 0xC4, 0xC8, 0x2E, 0xC8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_dataset_linked() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 47, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_dataset_linked_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_dataset 48x48, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_outlined_48_device_dataset_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9,
  0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F,
  0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9,
  0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F,
  0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7C, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84,
  0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_dataset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_dataset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_data_usage 48x48, 4-bit Alpha,  RLE, 301 bytes.
static const unsigned char ic_outlined_48_device_data_usage_data[] PROGMEM = {
  0x77, 0x82, 0x36, 0x9C, 0x48, 0x2C, 0x96, 0x37, 0x77, 0x48, 0x11, 0x7D, 0xC4, 0xC8, 0x1D, 0x71,
  0x77, 0x70, 0x8F, 0x4F, 0x08, 0x77, 0x40, 0x40, 0xDF, 0x94, 0xF9, 0x0D, 0x04, 0x77, 0x10, 0x8F,
  0xB4, 0xFB, 0x08, 0x76, 0x0A, 0xFC, 0x4F, 0xC0, 0x97, 0x40, 0xBF, 0xA8, 0x1C, 0x84, 0x48, 0x14,
  0x8C, 0xFA, 0x0A, 0x72, 0x08, 0xF9, 0x0A, 0x03, 0x73, 0x03, 0x0A, 0xF9, 0x07, 0x70, 0x4F, 0x0D,
  0x04, 0x77, 0x04, 0x0D, 0xF0, 0x45, 0x01, 0x0E, 0xE0, 0xB7, 0x74, 0x0B, 0xE0, 0xE0, 0x14, 0x08,
  0xE0, 0xB7, 0x76, 0x0B, 0xE0, 0x73, 0x01, 0x0E, 0xD0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xD0, 0xE0,
  0x12, 0x08, 0xE0, 0x37, 0x77, 0x10, 0x3E, 0x07, 0x20, 0xDD, 0x0A, 0x77, 0x73, 0x0A, 0xD8, 0x1D,
  0x02, 0xE0, 0x27, 0x77, 0x30, 0x2E, 0x02, 0x06, 0xD0, 0xC7, 0x77, 0x50, 0xCD, 0x06, 0x0A, 0xD0,
  0x77, 0x77, 0x50, 0x7D, 0x0A, 0x0B, 0xD0, 0x37, 0x77, 0x50, 0x3D, 0x0B, 0x0D, 0xD0, 0x27, 0x77,
  0x50, 0x2D, 0x0D, 0x0E, 0xD7, 0x77, 0x7D, 0x0E, 0xE7, 0x77, 0x7E, 0x0E, 0xD0, 0x27, 0x77, 0x50,
  0x2D, 0x0E, 0x0C, 0xD0, 0x37, 0x77, 0x50, 0x3D, 0x0C, 0x0A, 0xD0, 0x77, 0x77, 0x50, 0x7D, 0x0A,
  0x07, 0xD0, 0xC7, 0x77, 0x50, 0xCD, 0x07, 0x03, 0xE0, 0x27, 0x77, 0x40, 0x50, 0xDC, 0x81, 0x20,
  0xDD, 0x0A, 0x77, 0x76, 0x08, 0xA0, 0xD2, 0x08, 0xE0, 0x37, 0x77, 0x68, 0x12, 0xA7, 0x20, 0x1E,
  0x0D, 0x01, 0x77, 0x77, 0x40, 0x9E, 0x0B, 0x77, 0x68, 0x1C, 0xD4, 0x72, 0x01, 0x0E, 0xE0, 0xB0,
  0x17, 0x73, 0x0C, 0xB0, 0xB0, 0x27, 0x10, 0x5F, 0x0D, 0x03, 0x77, 0x04, 0x0D, 0xE0, 0x87, 0x10,
  0x9F, 0x90, 0xA0, 0x27, 0x30, 0x20, 0x9F, 0x90, 0x87, 0x20, 0xBF, 0xA8, 0x2C, 0x74, 0x22, 0x82,
  0x24, 0x7C, 0xFA, 0x0A, 0x74, 0x0B, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x08, 0x77, 0x10,
  0x50, 0xEF, 0xFE, 0x0E, 0x04, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x08, 0x77, 0x78, 0x11, 0x8D, 0xFD,
  0x81, 0xD7, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCE, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_data_usage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_data_usage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_developer_mode 48x48, 4-bit Alpha,  RLE, 241 bytes.
static const unsigned char ic_outlined_48_device_developer_mode_data[] PROGMEM = {
  0x38, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0x91, 0x50, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x14, 0x0A, 0xFF,
  0xFD, 0x0A, 0x40, 0xDF, 0xFF, 0xD0, 0xD4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF,
  0xF4, 0xC7, 0x76, 0xC4, 0xC7, 0x76, 0xC4, 0xC7, 0x76, 0xC4, 0xC7, 0x76, 0xC8, 0x0C, 0x60, 0x81,
  0x7C, 0x17, 0x38, 0x11, 0xC7, 0x77, 0x10, 0x7A, 0x0C, 0x73, 0x0C, 0xA0, 0x77, 0x60, 0x7C, 0x0B,
  0x71, 0x0B, 0xC0, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x0E,
  0x03, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x50, 0x30, 0xEC, 0x07, 0x50, 0x7C,
  0x0E, 0x03, 0x77, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x72, 0x03, 0x0E, 0xC8, 0x17,
  0x07, 0xC0, 0xE0, 0x37, 0x74, 0x03, 0x0E, 0xC0, 0x07, 0xC0, 0xE0, 0x37, 0x74, 0x03, 0x0E, 0xC8,
  0x17, 0x07, 0xC0, 0xE0, 0x37, 0x72, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x70, 0x30,
  0xEC, 0x07, 0x50, 0x7C, 0x0E, 0x03, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x30,
  0x30, 0xEC, 0x07, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x10, 0x30, 0xEC, 0x07, 0x74, 0x07, 0xC0, 0xB7,
  0x10, 0xBC, 0x07, 0x76, 0x07, 0xA0, 0xC7, 0x30, 0xCA, 0x07, 0x77, 0x18, 0x17, 0xC1, 0x73, 0x81,
  0x1C, 0x78, 0x0C, 0x60, 0xC7, 0x76, 0xC4, 0xC7, 0x76, 0xC4, 0xC7, 0x76, 0xC4, 0xC7, 0x76, 0xC4,
  0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0xFF, 0xFF, 0x4F, 0xFF, 0xF4, 0x0D, 0xFF, 0xFD, 0x0D, 0x40, 0xAF,
  0xFF, 0xD0, 0xA4, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x58, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_developer_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_developer_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_devices_fold 48x48, 4-bit Alpha,  RLE, 207 bytes.
static const unsigned char ic_outlined_48_device_devices_fold_data[] PROGMEM = {
  0x77, 0x72, 0x84, 0x4A, 0xEE, 0xA2, 0x77, 0x77, 0x40, 0x60, 0xDD, 0x0E, 0x02, 0x77, 0x77, 0x81,
  0x28, 0xEF, 0x90, 0xA7, 0x77, 0x60, 0x7F, 0xC0, 0xE7, 0x3C, 0x4C, 0x40, 0x5F, 0x0A, 0x03, 0xFB,
  0x81, 0xDA, 0x11, 0xC4, 0xC4, 0x0C, 0xC8, 0x1E, 0x71, 0x2F, 0xD0, 0xE0, 0x1C, 0x4C, 0x4C, 0x05,
  0x5F, 0xE0, 0xAC, 0x4C, 0x4C, 0x6F, 0xE0, 0xD7, 0x72, 0xC6, 0xC6, 0xC7, 0x72, 0xC6, 0xC6, 0xC7,
  0x72, 0xC6, 0xC6, 0xC7, 0x72, 0xC6, 0xC6, 0xF9, 0x75, 0xC6, 0xC6, 0xF9, 0x75, 0xC6, 0xC6, 0xF9,
  0x75, 0xC6, 0xC6, 0xF9, 0x75, 0xC6, 0xC6, 0xC7, 0x72, 0xC6, 0xC6, 0xC7, 0x72, 0xC6, 0xC6, 0xC7,
  0x72, 0xC6, 0xC6, 0xC7, 0x72, 0xC6, 0xC6, 0xF9, 0x75, 0xC6, 0xC6, 0xF9, 0x75, 0xC6, 0xC6, 0xF9,
  0x75, 0xC6, 0xC6, 0xF9, 0x75, 0xC6, 0xC6, 0xC7, 0x72, 0xC6, 0xC6, 0xC7, 0x72, 0xC6, 0xC6, 0xC7,
  0x72, 0xC6, 0xC6, 0xC7, 0x72, 0xC6, 0xC6, 0xF9, 0x75, 0xC6, 0xC6, 0xF9, 0x75, 0xC6, 0xC6, 0xF9,
  0x75, 0xC6, 0xC6, 0xF9, 0x75, 0xC5, 0x06, 0xC6, 0xC7, 0x72, 0xC2, 0x81, 0x28, 0xEC, 0x0C, 0x6C,
  0x77, 0x2C, 0x04, 0x0A, 0xF0, 0x56, 0xC7, 0x72, 0xFC, 0x0E, 0x06, 0x7C, 0x77, 0x2F, 0xA8, 0x1E,
  0x71, 0x71, 0xF9, 0x4C, 0x40, 0xDF, 0xFF, 0x90, 0xDC, 0x4C, 0x40, 0xAF, 0xFF, 0x90, 0xAC, 0x4C,
  0x40, 0x10, 0xEF, 0xFE, 0x0E, 0x01, 0xC4, 0xC5, 0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_devices_fold() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_devices_fold_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_devices 48x48, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_outlined_48_device_devices_data[] PROGMEM = {
  0x58, 0x11, 0xAD, 0x80, 0xC0, 0xF7, 0x10, 0x10, 0xE8, 0x0C, 0x2F, 0x71, 0x0A, 0x80, 0xC3, 0xF7,
  0x10, 0xD8, 0x0C, 0x3F, 0x71, 0xC8, 0x0D, 0x00, 0xC8, 0x0D, 0x00, 0xC8, 0x0D, 0x00, 0xC8, 0x0D,
  0x00, 0xC7, 0x77, 0x30, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0xC7, 0x77, 0x30, 0xDF, 0xF0, 0xD4, 0xC7,
  0x77, 0x3F, 0xFA, 0x4C, 0x77, 0x73, 0xFF, 0xA4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C,
  0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71,
  0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4,
  0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7,
  0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xC4, 0xC7, 0x77, 0x3C, 0x71, 0xFF, 0xFF, 0xC4,
  0x80, 0xD0, 0xF4, 0x80, 0xD0, 0xF4, 0x80, 0xD0, 0xF4, 0x80, 0xD0, 0xF4, 0x0D, 0xFF, 0x0D, 0xFF,
  0xFF, 0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_devices() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_devices_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_device_thermostat 48x48, 4-bit Alpha,  RLE, 140 bytes.
static const unsigned char ic_outlined_48_device_device_thermostat_data[] PROGMEM = {
  0x78, 0x46, 0xCE, 0xEC, 0x67, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x73, 0x0C, 0xF9, 0x0C, 0x72, 0x06,
  0xFB, 0x06, 0x71, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x71, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7,
  0x1C, 0x4C, 0x71, 0xC4, 0xC7, 0x1C, 0x2E, 0x71, 0xC2, 0xE7, 0x1C, 0x4C, 0x71, 0xC4, 0xC7, 0x1C,
  0x4C, 0x71, 0xC4, 0xC7, 0x1C, 0x2E, 0x71, 0xC2, 0xE7, 0x1C, 0x4C, 0x71, 0xC4, 0xC7, 0x1F, 0xD7,
  0x1F, 0xD7, 0x1F, 0xD7, 0x1F, 0xD7, 0x08, 0xFD, 0x08, 0x50, 0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0,
  0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x04, 0xFF, 0xC0, 0x40, 0xAF, 0xFC, 0x0A, 0x0C, 0xFF, 0xC0, 0xC0,
  0xEF, 0xFC, 0x00, 0xEF, 0xFC, 0x0E, 0x0D, 0xFF, 0xC0, 0xD0, 0x9F, 0xFC, 0x09, 0x05, 0xFF, 0xC8,
  0x15, 0x0D, 0xFF, 0xA0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_device_thermostat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_device_thermostat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_discount 48x48, 4-bit Alpha,  RLE, 414 bytes.
static const unsigned char ic_outlined_48_device_discount_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFD, 0x81, 0xEC, 0x57, 0x73, 0x01, 0x0E, 0xFF, 0xB0, 0x87, 0x72, 0x0A, 0xFF,
  0xD0, 0x87, 0x71, 0x0D, 0xFF, 0xE0, 0x87, 0x7C, 0x75, 0x02, 0x0E, 0xC0, 0x87, 0x6C, 0x76, 0x02,
  0x0E, 0xC0, 0x87, 0x5C, 0x28, 0x31, 0xBE, 0xB1, 0x70, 0x20, 0xEC, 0x08, 0x74, 0xC2, 0x0B, 0xB0,
  0xB7, 0x10, 0x20, 0xEC, 0x08, 0x73, 0xC2, 0x0E, 0xB0, 0xE7, 0x20, 0x20, 0xEC, 0x08, 0x72, 0xC2,
  0x0B, 0xB0, 0xB7, 0x30, 0x20, 0xEC, 0x08, 0x71, 0xC2, 0x83, 0x1B, 0xEB, 0x17, 0x40, 0x20, 0xEC,
  0x08, 0x7C, 0x77, 0x50, 0x20, 0xEC, 0x08, 0x6C, 0x77, 0x60, 0x20, 0xEC, 0x08, 0x5C, 0x77, 0x70,
  0x20, 0xEC, 0x08, 0x4C, 0x77, 0x71, 0x02, 0x0E, 0xC0, 0x83, 0xC7, 0x77, 0x20, 0x20, 0xEC, 0x08,
  0x20, 0xEB, 0x02, 0x77, 0x72, 0x02, 0x0E, 0xC8, 0x18, 0x0C, 0xB0, 0xE0, 0x27, 0x77, 0x20, 0x20,
  0xEC, 0x00, 0x5C, 0x0E, 0x02, 0x77, 0x72, 0x02, 0x0E, 0xB8, 0x1C, 0x08, 0xC0, 0xE0, 0x27, 0x77,
  0x20, 0x3B, 0x0E, 0x20, 0x8C, 0x0E, 0x02, 0x77, 0x70, 0x10, 0xCB, 0x0C, 0x30, 0x8C, 0x0E, 0x02,
  0x77, 0x50, 0x10, 0xCC, 0x06, 0x02, 0x30, 0x8C, 0x0E, 0x02, 0x77, 0x30, 0x10, 0xCC, 0x82, 0xA0,
  0xE2, 0x30, 0x8C, 0x0E, 0x02, 0x77, 0x10, 0x10, 0xCC, 0x0A, 0x29, 0x0E, 0x02, 0x30, 0x8C, 0x0E,
  0x02, 0x76, 0x01, 0x0C, 0xC0, 0xA3, 0xA0, 0xE0, 0x23, 0x08, 0xC0, 0xE0, 0x27, 0x40, 0x10, 0xCC,
  0x0A, 0x40, 0xEA, 0x0E, 0x02, 0x30, 0x8C, 0x0E, 0x02, 0x72, 0x01, 0x0C, 0xC0, 0xA5, 0x0C, 0xB0,
  0xE0, 0x23, 0x08, 0xC0, 0xE0, 0x27, 0x01, 0x0C, 0xC0, 0xA3, 0x82, 0x1C, 0x55, 0xC0, 0xE0, 0x23,
  0x08, 0xC0, 0xE0, 0x25, 0x01, 0x0C, 0xC0, 0xA3, 0x84, 0x1C, 0xFC, 0x08, 0xC0, 0xE0, 0x23, 0x08,
  0xC0, 0xE0, 0x23, 0x01, 0x0C, 0xC0, 0xA3, 0x01, 0x0C, 0xA0, 0xE2, 0x08, 0xC0, 0xE0, 0x23, 0x08,
  0xC8, 0x3E, 0x20, 0x1C, 0xC0, 0xA3, 0x01, 0x0C, 0xB0, 0xC3, 0x08, 0xC0, 0xE0, 0x23, 0x08, 0xC8,
  0x1E, 0x3C, 0xC0, 0xA3, 0x01, 0x0C, 0xC0, 0x64, 0x08, 0xC0, 0xE0, 0x23, 0x08, 0xFA, 0x0A, 0x30,
  0x10, 0xCC, 0x0A, 0x60, 0x8C, 0x0E, 0x02, 0x30, 0x8F, 0x0A, 0x30, 0x10, 0xCC, 0x0B, 0x71, 0x08,
  0xC0, 0xE0, 0x23, 0x08, 0xD0, 0xA3, 0x01, 0x0C, 0xC0, 0xB7, 0x30, 0x8C, 0x0E, 0x02, 0x38, 0x35,
  0xCE, 0xC6, 0x30, 0x10, 0xCC, 0x0B, 0x75, 0x08, 0xC0, 0xE0, 0x27, 0x20, 0x10, 0xCC, 0x0B, 0x77,
  0x08, 0xC0, 0xE0, 0x27, 0x01, 0x0C, 0xC0, 0xB7, 0x72, 0x08, 0xC0, 0xE0, 0x25, 0x01, 0x0C, 0xC0,
  0xB7, 0x74, 0x08, 0xC0, 0xE0, 0x23, 0x01, 0x0C, 0xC0, 0xB7, 0x76, 0x08, 0xC8, 0x3E, 0x20, 0x1C,
  0xC0, 0xB7, 0x77, 0x10, 0x8C, 0x81, 0xE3, 0xCC, 0x0B, 0x77, 0x73, 0x08, 0xFA, 0x0B, 0x77, 0x75,
  0x08, 0xF0, 0xB7, 0x77, 0x70, 0x8D, 0x0A, 0x77, 0x77, 0x28, 0x34, 0xCE, 0xC6, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_discount() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_discount_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_do_not_disturb_on_total_silence 48x48, 4-bit Alpha,  RLE, 391 bytes.
static const unsigned char ic_outlined_48_device_do_not_disturb_on_total_silence_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x15, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xB6, 0x15, 0x01,
  0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0, 0xE0, 0x14, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x40, 0x10, 0xEB,
  0x0E, 0x01, 0x40, 0x9C, 0x03, 0x40, 0x40, 0xEF, 0xD0, 0xE0, 0x54, 0x03, 0xC0, 0x93, 0x01, 0xC0,
  0x74, 0x06, 0xFF, 0xA0, 0x74, 0x07, 0xC0, 0x12, 0x08, 0xB0, 0xE4, 0x04, 0xFF, 0xC0, 0x54, 0x0E,
  0xB0, 0x82, 0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x13, 0x06, 0xB8, 0x1D, 0x03, 0xC4,
  0x09, 0xFF, 0xE0, 0x94, 0xC0, 0x30, 0x7B, 0x0B, 0x30, 0x1F, 0xFF, 0x90, 0x13, 0x0B, 0xB0, 0x70,
  0xAB, 0x06, 0x30, 0x6F, 0xFF, 0x90, 0x63, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x30, 0xBF, 0xFF, 0x90,
  0xB3, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x30, 0xDD, 0x75, 0xD0, 0xD3, 0x02, 0xB0, 0xEC, 0x40, 0xED,
  0x75, 0xD0, 0xE4, 0xF9, 0x40, 0xED, 0x75, 0xD0, 0xE4, 0xC0, 0xEB, 0x02, 0x30, 0xDD, 0x75, 0xD0,
  0xD3, 0x02, 0xB0, 0xE0, 0xCB, 0x03, 0x30, 0xBF, 0xFF, 0x90, 0xB3, 0x03, 0xB0, 0xC0, 0xAB, 0x06,
  0x30, 0x6F, 0xFF, 0x90, 0x63, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x30, 0x1F, 0xFF, 0x90, 0x13, 0x0B,
  0xB0, 0x70, 0x3C, 0x40, 0x9F, 0xFE, 0x09, 0x4C, 0x81, 0x30, 0xDB, 0x06, 0x30, 0x10, 0xEF, 0xFC,
  0x0E, 0x01, 0x30, 0x6B, 0x0D, 0x20, 0x8B, 0x0E, 0x40, 0x4F, 0xFC, 0x04, 0x40, 0xEB, 0x08, 0x20,
  0x1C, 0x07, 0x40, 0x6F, 0xFA, 0x06, 0x40, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x40, 0x40, 0xEF, 0xD0,
  0xE0, 0x44, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xE0, 0x14, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x40,
  0x10, 0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x50,
  0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC, 0x09, 0x72, 0x0A, 0xD0, 0x77,
  0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0E, 0x06, 0x75, 0x06, 0x0E, 0xD0, 0xA7, 0x60, 0x9F, 0x82,
  0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30,
  0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33,
  0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_do_not_disturb_on_total_silence() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_do_not_disturb_on_total_silence_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_dvr 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_outlined_48_device_dvr_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x4C, 0x2F, 0xFF, 0x94,
  0xF9, 0x4C, 0x2F, 0xFF, 0x94, 0xF9, 0x4C, 0x2F, 0xFF, 0x94, 0xF9, 0x4C, 0x2F, 0xFF, 0x94, 0xF9,
  0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x4C, 0x2F,
  0xFF, 0x94, 0xF9, 0x4C, 0x2F, 0xFF, 0x94, 0xF9, 0x4C, 0x2F, 0xFF, 0x94, 0xF9, 0x4C, 0x2F, 0xFF,
  0x94, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9,
  0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A,
  0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x17, 0x71, 0xFF, 0xA7,
  0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_edgesensor_high 48x48, 4-bit Alpha,  RLE, 224 bytes.
static const unsigned char ic_outlined_48_device_edgesensor_high_data[] PROGMEM = {
  0x76, 0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xD9, 0x17, 0x77, 0x40, 0x10, 0xEF, 0xFE, 0x0E, 0x01, 0x77,
  0x73, 0x0A, 0xFF, 0xF9, 0x0A, 0x77, 0x73, 0x0D, 0xFF, 0xF9, 0x0D, 0x77, 0x73, 0xC7, 0x72, 0xC7,
  0x77, 0x3C, 0x77, 0x2C, 0x77, 0x73, 0xFF, 0xFB, 0x77, 0x73, 0xFF, 0xFB, 0x77, 0x73, 0xFF, 0xFB,
  0x77, 0x73, 0xFF, 0xFB, 0x77, 0x4C, 0x2C, 0x77, 0x2C, 0x71, 0xC6, 0xC2, 0xC7, 0x72, 0xC7, 0x1C,
  0x6C, 0x2C, 0x77, 0x2C, 0x71, 0xC6, 0xC2, 0xC7, 0x72, 0xC7, 0x1C, 0x6C, 0x2C, 0x77, 0x2C, 0x71,
  0xC6, 0xC2, 0xC7, 0x72, 0xC7, 0x1F, 0x92, 0xC2, 0xC7, 0x72, 0xC2, 0xC2, 0xF9, 0x2C, 0x2C, 0x77,
  0x2C, 0x2C, 0x2F, 0x92, 0xC2, 0xC7, 0x72, 0xC2, 0xC2, 0xF9, 0x2C, 0x2C, 0x77, 0x2C, 0x2C, 0x2F,
  0x92, 0xC2, 0xC7, 0x72, 0xC2, 0xC2, 0xF9, 0x2C, 0x2C, 0x77, 0x2C, 0x2C, 0x2F, 0x92, 0xC2, 0xC7,
  0x72, 0xC2, 0xC2, 0xF9, 0x2C, 0x2C, 0x77, 0x2C, 0x2C, 0x2F, 0x97, 0x1C, 0x77, 0x2C, 0x2C, 0x6C,
  0x71, 0xC7, 0x72, 0xC2, 0xC6, 0xC7, 0x1C, 0x77, 0x2C, 0x2C, 0x6C, 0x71, 0xC7, 0x72, 0xC2, 0xC6,
  0xC7, 0x1C, 0x77, 0x2C, 0x2C, 0x6C, 0x71, 0xC7, 0x72, 0xC2, 0xC7, 0x74, 0xFF, 0xFB, 0x77, 0x73,
  0xFF, 0xFB, 0x77, 0x73, 0xFF, 0xFB, 0x77, 0x73, 0xFF, 0xFB, 0x77, 0x73, 0xC7, 0x72, 0xC7, 0x77,
  0x3C, 0x77, 0x2C, 0x77, 0x73, 0x0D, 0xFF, 0xF9, 0x0D, 0x77, 0x73, 0x0A, 0xFF, 0xF9, 0x0A, 0x77,
  0x73, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x17, 0x77, 0x48, 0x11, 0xAD, 0xFF, 0xA8, 0x1D, 0xA1, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_edgesensor_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 47, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_edgesensor_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_edgesensor_low 48x48, 4-bit Alpha,  RLE, 187 bytes.
static const unsigned char ic_outlined_48_device_edgesensor_low_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFA, 0x81, 0xD9, 0x17, 0x73, 0x01, 0x0E, 0xFF, 0xE0, 0xE0, 0x17, 0x72,
  0x0A, 0xFF, 0xF9, 0x0A, 0x77, 0x20, 0xDF, 0xFF, 0x90, 0xD7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7,
  0x72, 0xC7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7,
  0x1C, 0x4C, 0x77, 0x2C, 0x71, 0xC4, 0xC7, 0x72, 0xC7, 0x1C, 0x4C, 0x77, 0x2C, 0x71, 0xC4, 0xC7,
  0x72, 0xC7, 0x1C, 0x4C, 0x77, 0x2C, 0x71, 0xC4, 0xC7, 0x72, 0xC7, 0x1C, 0x4C, 0x77, 0x2C, 0x4F,
  0x94, 0xC7, 0x72, 0xC4, 0xF9, 0x4C, 0x77, 0x2C, 0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xF9, 0x4C, 0x77,
  0x2C, 0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xF9, 0x4C, 0x77, 0x2C, 0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xC7,
  0x1C, 0x77, 0x2C, 0x4C, 0x71, 0xC7, 0x72, 0xC4, 0xC7, 0x1C, 0x77, 0x2C, 0x4C, 0x71, 0xC7, 0x72,
  0xC4, 0xC7, 0x1C, 0x77, 0x2C, 0x4C, 0x71, 0xC7, 0x72, 0xC4, 0xC7, 0x1F, 0xFF, 0xB7, 0x72, 0xFF,
  0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C,
  0x77, 0x20, 0xDF, 0xFF, 0x90, 0xD7, 0x72, 0x0A, 0xFF, 0xF9, 0x0A, 0x77, 0x20, 0x10, 0xEF, 0xFE,
  0x0E, 0x01, 0x77, 0x38, 0x11, 0xAD, 0xFF, 0xA8, 0x1D, 0xA1, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_edgesensor_low() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_edgesensor_low_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_e_mobiledata 48x48, 4-bit Alpha,  RLE, 20 bytes.
static const unsigned char ic_outlined_48_device_e_mobiledata_data[] PROGMEM = {
  0x80, 0x98, 0x0F, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x58, 0x09, 0x80, 0xF7, 0x5C, 0x75, 0xC7, 0x5C,
  0x75, 0x80, 0xF4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_e_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(16, 14, 31, 33), Box(0, 0, 47, 47),
      ic_outlined_48_device_e_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_flashlight_off 48x48, 4-bit Alpha,  RLE, 269 bytes.
static const unsigned char ic_outlined_48_device_flashlight_off_data[] PROGMEM = {
  0x72, 0xFF, 0xFB, 0x72, 0x02, 0x6F, 0xFF, 0xB7, 0x18, 0x14, 0xF7, 0x50, 0xCF, 0xFF, 0xA7, 0x04,
  0xB0, 0x75, 0x0C, 0xFF, 0xF9, 0x70, 0xEC, 0x07, 0x77, 0x72, 0xC7, 0x03, 0x0E, 0xC0, 0x77, 0x77,
  0x1C, 0x71, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xD7, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFC,
  0x73, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xB7, 0x40, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFA, 0x75,
  0x03, 0x0E, 0xC0, 0x77, 0x73, 0xC7, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x10, 0x7C, 0x77, 0x03, 0x0E,
  0xC0, 0x77, 0x60, 0x2C, 0x0A, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x75, 0x0C, 0xB0, 0xE0, 0x17, 0x72,
  0x03, 0x0E, 0xC0, 0x77, 0x30, 0x7C, 0x05, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x71, 0x02, 0xC0, 0xA7,
  0x76, 0x03, 0x0E, 0xC0, 0x77, 0x0C, 0xB0, 0xE0, 0x17, 0x77, 0x03, 0xD0, 0x76, 0xC0, 0x57, 0x77,
  0x2E, 0x07, 0x50, 0xCB, 0x77, 0x73, 0xF0, 0x75, 0x0C, 0xA7, 0x77, 0x3F, 0x90, 0x75, 0x0C, 0x97,
  0x77, 0x3C, 0x0E, 0xC0, 0x75, 0x0C, 0x77, 0x73, 0xC0, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x1C, 0x10,
  0x30, 0xEC, 0x07, 0x77, 0x77, 0xC2, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x6C, 0x30, 0x30, 0xEC, 0x07,
  0x77, 0x75, 0xC4, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x4C, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x73, 0xC6,
  0x03, 0x0E, 0xC0, 0x77, 0x77, 0x2C, 0x70, 0x3D, 0x07, 0x77, 0x71, 0xC7, 0x1E, 0x07, 0x77, 0x7C,
  0x71, 0xF0, 0x77, 0x76, 0xC7, 0x1F, 0x90, 0x77, 0x75, 0xC7, 0x1C, 0x0E, 0xC0, 0x77, 0x74, 0xC7,
  0x1C, 0x03, 0x0E, 0xC0, 0x77, 0x73, 0xC7, 0x1C, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x2F, 0xFA, 0x20,
  0x30, 0xEC, 0x07, 0x77, 0x1F, 0xFA, 0x30, 0x30, 0xEC, 0x07, 0x77, 0xFF, 0xA4, 0x03, 0x0E, 0xC0,
  0x27, 0x6F, 0xFA, 0x50, 0x30, 0xEA, 0x04, 0x80, 0xC0, 0x08, 0x13, 0xE4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_flashlight_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_flashlight_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_flashlight_on 48x48, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_outlined_48_device_flashlight_on_data[] PROGMEM = {
  0x80, 0x9C, 0x0F, 0x77, 0x2F, 0x97, 0x72, 0x80, 0x9C, 0x4F, 0x77, 0x2F, 0x90, 0x77, 0x70, 0x7C,
  0x0A, 0xC0, 0x27, 0x50, 0x2C, 0x81, 0xA1, 0xEB, 0x0C, 0x75, 0x0C, 0xB8, 0x2E, 0x10, 0x5C, 0x07,
  0x73, 0x07, 0xC0, 0x53, 0x0A, 0xC0, 0x27, 0x10, 0x2C, 0x0A, 0x40, 0x10, 0xEB, 0x0C, 0x71, 0x0C,
  0xB0, 0xE0, 0x15, 0x05, 0xC7, 0x1C, 0x05, 0x7C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7,
  0x1C, 0x28, 0x28, 0xDD, 0x82, 0xC7, 0x1C, 0x10, 0x8C, 0x08, 0x1C, 0x71, 0xC1, 0x0D, 0xC0, 0xD1,
  0xC7, 0x1C, 0x10, 0xDC, 0x0D, 0x1C, 0x71, 0xC1, 0x08, 0xC0, 0x81, 0xC7, 0x1C, 0x28, 0x28, 0xDD,
  0x82, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71,
  0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xC7, 0x1F, 0xFA, 0x71,
  0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_flashlight_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 4, 35, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_flashlight_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_flourescent 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_outlined_48_device_flourescent_data[] PROGMEM = {
  0x77, 0x1C, 0x77, 0x77, 0x2C, 0x77, 0x77, 0x2C, 0x77, 0x77, 0x2C, 0x77, 0x77, 0x2C, 0x77, 0x30,
  0x70, 0x27, 0x4C, 0x74, 0x03, 0x06, 0x38, 0x27, 0xFE, 0x27, 0x77, 0x38, 0x43, 0xEF, 0x70, 0x7B,
  0x0E, 0x02, 0x77, 0x71, 0x03, 0x0E, 0xB0, 0x70, 0x8C, 0x0E, 0x02, 0x77, 0x60, 0x20, 0xEC, 0x81,
  0x70, 0x8B, 0x0A, 0x77, 0x71, 0x0A, 0xB0, 0x73, 0x81, 0x8F, 0xA7, 0x77, 0x38, 0x1A, 0xF8, 0x50,
  0x57, 0x77, 0x50, 0x58, 0x09, 0x86, 0x0F, 0xFF, 0xF6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF,
  0x6C, 0x77, 0x6C, 0x6C, 0x77, 0x6C, 0x6C, 0x77, 0x6C, 0x6C, 0x77, 0x6C, 0x6F, 0xFF, 0xF6, 0xFF,
  0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF, 0x80, 0x98, 0x60, 0x02, 0x77, 0x75, 0x02, 0x58, 0x15, 0xF7,
  0x77, 0x73, 0x81, 0x7F, 0x53, 0x05, 0xB0, 0x77, 0x77, 0x10, 0x7B, 0x81, 0x50, 0x5D, 0x02, 0x77,
  0x60, 0x2D, 0x05, 0x0A, 0xC0, 0x57, 0x77, 0x10, 0x5C, 0x81, 0xA0, 0xAA, 0x05, 0x77, 0x73, 0x05,
  0xA0, 0xA3, 0x0A, 0x04, 0x74, 0xC7, 0x40, 0x50, 0xA7, 0x73, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72,
  0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_flourescent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 40, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_flourescent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_fluorescent 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_outlined_48_device_fluorescent_data[] PROGMEM = {
  0x77, 0x1C, 0x77, 0x77, 0x2C, 0x77, 0x77, 0x2C, 0x77, 0x77, 0x2C, 0x77, 0x77, 0x2C, 0x77, 0x30,
  0x70, 0x27, 0x4C, 0x74, 0x03, 0x06, 0x38, 0x27, 0xFE, 0x27, 0x77, 0x38, 0x43, 0xEF, 0x70, 0x7B,
  0x0E, 0x02, 0x77, 0x71, 0x03, 0x0E, 0xB0, 0x70, 0x8C, 0x0E, 0x02, 0x77, 0x60, 0x20, 0xEC, 0x81,
  0x70, 0x8B, 0x0A, 0x77, 0x71, 0x0A, 0xB0, 0x73, 0x81, 0x8F, 0xA7, 0x77, 0x38, 0x1A, 0xF8, 0x50,
  0x57, 0x77, 0x50, 0x58, 0x09, 0x86, 0x0F, 0xFF, 0xF6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF,
  0x6C, 0x77, 0x6C, 0x6C, 0x77, 0x6C, 0x6C, 0x77, 0x6C, 0x6C, 0x77, 0x6C, 0x6F, 0xFF, 0xF6, 0xFF,
  0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF, 0x80, 0x98, 0x60, 0x02, 0x77, 0x75, 0x02, 0x58, 0x15, 0xF7,
  0x77, 0x73, 0x81, 0x7F, 0x53, 0x05, 0xB0, 0x77, 0x77, 0x10, 0x7B, 0x81, 0x50, 0x5D, 0x02, 0x77,
  0x60, 0x2D, 0x05, 0x0A, 0xC0, 0x57, 0x77, 0x10, 0x5C, 0x81, 0xA0, 0xAA, 0x05, 0x77, 0x73, 0x05,
  0xA0, 0xA3, 0x0A, 0x04, 0x74, 0xC7, 0x40, 0x50, 0xA7, 0x73, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72,
  0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_fluorescent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 40, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_fluorescent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_fmd_bad 48x48, 4-bit Alpha,  RLE, 296 bytes.
static const unsigned char ic_outlined_48_device_fmd_bad_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x10, 0x8F, 0xFA, 0x08, 0x75, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x30, 0xED, 0x82, 0xD8,
  0x42, 0x28, 0x22, 0x48, 0xDD, 0x0E, 0x03, 0x70, 0x10, 0xEC, 0x0D, 0x05, 0x73, 0x05, 0x0D, 0xC0,
  0xE0, 0x16, 0x0C, 0xC0, 0x97, 0x70, 0x9C, 0x0C, 0x50, 0x7C, 0x07, 0x77, 0x20, 0x7C, 0x07, 0x30,
  0x10, 0xEB, 0x0A, 0x7C, 0x70, 0xAB, 0x0E, 0x01, 0x20, 0x9B, 0x0D, 0x71, 0xC7, 0x10, 0xDB, 0x09,
  0x20, 0xEB, 0x06, 0x71, 0xC7, 0x10, 0x6B, 0x81, 0xE0, 0x3B, 0x0D, 0x72, 0xC7, 0x20, 0xDB, 0x03,
  0x08, 0xB0, 0x97, 0x2C, 0x72, 0x09, 0xB0, 0x80, 0xBB, 0x05, 0x72, 0xC7, 0x20, 0x5B, 0x0B, 0x0D,
  0xB0, 0x27, 0x2C, 0x72, 0x02, 0xB0, 0xC0, 0xEB, 0x01, 0x72, 0xC7, 0x20, 0x1B, 0x0E, 0xC7, 0x3C,
  0x73, 0xC0, 0xDB, 0x01, 0x72, 0xC7, 0x20, 0x1B, 0x0D, 0x0C, 0xB0, 0x47, 0x77, 0x10, 0x4B, 0x0C,
  0x09, 0xB0, 0x87, 0x77, 0x10, 0x8B, 0x09, 0x04, 0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x81, 0x40, 0xEB,
  0x04, 0x77, 0x60, 0x4B, 0x0E, 0x20, 0x9B, 0x0C, 0x71, 0xC7, 0x10, 0xCB, 0x09, 0x20, 0x2C, 0x05,
  0x7C, 0x70, 0x5C, 0x02, 0x30, 0xAB, 0x0E, 0x01, 0x6C, 0x60, 0x10, 0xDB, 0x0A, 0x40, 0x10, 0xEB,
  0x0A, 0x6C, 0x60, 0xAB, 0x0E, 0x01, 0x50, 0x7C, 0x05, 0x77, 0x05, 0xC0, 0x77, 0x0C, 0xB0, 0xE0,
  0x37, 0x50, 0x30, 0xEB, 0x0C, 0x71, 0x02, 0x0E, 0xB0, 0xD0, 0x17, 0x30, 0x10, 0xDB, 0x0E, 0x02,
  0x72, 0x05, 0xC0, 0xC7, 0x30, 0xCC, 0x05, 0x74, 0x08, 0xC0, 0xB7, 0x10, 0xBC, 0x08, 0x76, 0x0A,
  0xC0, 0xB6, 0x0B, 0xC0, 0xA7, 0x71, 0x0B, 0xC0, 0xA4, 0x0A, 0xC0, 0xB7, 0x72, 0x01, 0x0C, 0xC0,
  0xB2, 0x0B, 0xC0, 0xC0, 0x17, 0x73, 0x01, 0x0C, 0xC0, 0x0B, 0xC0, 0xC0, 0x17, 0x75, 0x01, 0x0C,
  0xF9, 0x0C, 0x01, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x73, 0x0B, 0xC0, 0xB7, 0x77, 0x60,
  0xAA, 0x0A, 0x77, 0x77, 0x10, 0x08, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_fmd_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_fmd_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_fmd_good 48x48, 4-bit Alpha,  RLE, 311 bytes.
static const unsigned char ic_outlined_48_device_fmd_good_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x10, 0x8F, 0xFA, 0x08, 0x75, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x20, 0x30, 0xED, 0x82, 0xD8,
  0x42, 0x28, 0x22, 0x48, 0xDD, 0x0E, 0x03, 0x70, 0x10, 0xEC, 0x0D, 0x05, 0x73, 0x05, 0x0D, 0xC0,
  0xE0, 0x16, 0x0C, 0xC0, 0x97, 0x70, 0x9C, 0x0C, 0x50, 0x7C, 0x07, 0x77, 0x20, 0x7C, 0x07, 0x30,
  0x10, 0xEB, 0x0A, 0x77, 0x40, 0xAB, 0x0E, 0x01, 0x20, 0x9B, 0x0D, 0x77, 0x60, 0xDB, 0x09, 0x20,
  0xEB, 0x06, 0x77, 0x60, 0x6B, 0x81, 0xE0, 0x3B, 0x0D, 0x77, 0x71, 0x0D, 0xB0, 0x30, 0x8B, 0x09,
  0x71, 0x84, 0x1A, 0xDD, 0xA1, 0x71, 0x09, 0xB0, 0x80, 0xBB, 0x05, 0x70, 0x10, 0xEC, 0x0E, 0x01,
  0x70, 0x5B, 0x0B, 0x0C, 0xB0, 0x27, 0x0A, 0xE0, 0xA7, 0x02, 0xB0, 0xD0, 0xEB, 0x01, 0x70, 0xDE,
  0x0D, 0x70, 0x1B, 0x0E, 0xC7, 0x10, 0xDE, 0x0D, 0x71, 0xC0, 0xDB, 0x01, 0x70, 0xAE, 0x0A, 0x70,
  0x1B, 0x0D, 0x0C, 0xB0, 0x47, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x04, 0xB0, 0xC0, 0x9B, 0x08, 0x71,
  0x84, 0x1A, 0xDD, 0xA1, 0x71, 0x08, 0xB0, 0x90, 0x4B, 0x0D, 0x77, 0x71, 0x0D, 0xB8, 0x14, 0x0E,
  0xB0, 0x47, 0x76, 0x04, 0xB0, 0xE2, 0x09, 0xB0, 0xC7, 0x76, 0x0C, 0xB0, 0x92, 0x02, 0xC0, 0x57,
  0x74, 0x05, 0xC0, 0x23, 0x0A, 0xB0, 0xD0, 0x17, 0x72, 0x01, 0x0D, 0xB0, 0xA4, 0x01, 0x0E, 0xB0,
  0xA7, 0x72, 0x0A, 0xB0, 0xE0, 0x15, 0x07, 0xC0, 0x57, 0x70, 0x5C, 0x07, 0x70, 0xCB, 0x0E, 0x03,
  0x75, 0x03, 0x0E, 0xB0, 0xC7, 0x10, 0x20, 0xEB, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xB0, 0xE0, 0x27,
  0x20, 0x5C, 0x0C, 0x73, 0x0C, 0xC0, 0x57, 0x40, 0x8C, 0x0B, 0x71, 0x0B, 0xC0, 0x87, 0x60, 0xAC,
  0x0A, 0x60, 0xAC, 0x0A, 0x77, 0x10, 0xBC, 0x0A, 0x40, 0xAC, 0x0B, 0x77, 0x20, 0x10, 0xCC, 0x0B,
  0x20, 0xBC, 0x0C, 0x01, 0x77, 0x30, 0x10, 0xCC, 0x00, 0xBC, 0x0C, 0x01, 0x77, 0x50, 0x10, 0xCF,
  0x90, 0xC0, 0x17, 0x77, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x30, 0xBC, 0x0B, 0x77, 0x76, 0x0A,
  0xA0, 0xA7, 0x77, 0x71, 0x00, 0x87, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_fmd_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_fmd_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_g_mobiledata 48x48, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_48_device_g_mobiledata_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFB, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0x81, 0xE1, 0xAF, 0xFA, 0x0A, 0x0D, 0xFF,
  0xA0, 0xDC, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x73, 0xF9,
  0x73, 0xF9, 0x73, 0xF9, 0x73, 0xC0, 0xDF, 0xFA, 0x0D, 0x0A, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0x84,
  0xE1, 0x01, 0xAD, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 14, 31, 33), Box(0, 0, 47, 47),
      ic_outlined_48_device_g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_gpp_bad 48x48, 4-bit Alpha,  RLE, 296 bytes.
static const unsigned char ic_outlined_48_device_gpp_bad_data[] PROGMEM = {
  0x76, 0x84, 0x16, 0xCC, 0x61, 0x77, 0x73, 0x04, 0x0A, 0xE0, 0xA0, 0x47, 0x75, 0x81, 0x28, 0xEF,
  0xB8, 0x1E, 0x82, 0x76, 0x81, 0x16, 0xCF, 0xFA, 0x81, 0xC6, 0x17, 0x10, 0x40, 0xAF, 0xA8, 0x2D,
  0x77, 0xDF, 0xA0, 0xA0, 0x43, 0x81, 0x28, 0xEF, 0x98, 0x1E, 0x93, 0x48, 0x13, 0x9E, 0xF9, 0x81,
  0xE8, 0x2F, 0xA0, 0xB0, 0x57, 0x30, 0x50, 0xBF, 0xF9, 0x81, 0xD7, 0x17, 0x78, 0x11, 0x7D, 0xFB,
  0x09, 0x03, 0x77, 0x60, 0x30, 0x9F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97,
  0x77, 0x3F, 0x97, 0x0A, 0x05, 0x60, 0x50, 0xA7, 0xF9, 0x60, 0xAA, 0x05, 0x40, 0x5A, 0x0A, 0x6F,
  0x95, 0x0A, 0xC0, 0x52, 0x05, 0xC0, 0xA5, 0xF9, 0x50, 0x5D, 0x00, 0x5D, 0x05, 0x5F, 0x96, 0x05,
  0xFB, 0x05, 0x6F, 0x97, 0x05, 0xF9, 0x05, 0x7C, 0x0D, 0xB0, 0x17, 0x05, 0xE0, 0x57, 0x01, 0xB0,
  0xD0, 0xCB, 0x02, 0x70, 0x5E, 0x05, 0x70, 0x2B, 0x0C, 0x0B, 0xB0, 0x46, 0x05, 0xF9, 0x05, 0x60,
  0x4B, 0x0B, 0x08, 0xB0, 0x85, 0x05, 0xFB, 0x05, 0x50, 0x8B, 0x08, 0x04, 0xB0, 0xC4, 0x05, 0xD0,
  0x05, 0xD0, 0x54, 0x0C, 0xB0, 0x41, 0xC0, 0x13, 0x0A, 0xC0, 0x52, 0x05, 0xC0, 0xA3, 0x01, 0xC2,
  0x0C, 0xB0, 0x74, 0x0A, 0xA0, 0x54, 0x05, 0xA0, 0xA4, 0x07, 0xB0, 0xC2, 0x05, 0xB0, 0xD5, 0x0A,
  0x05, 0x60, 0x50, 0xA5, 0x0D, 0xB0, 0x53, 0x0E, 0xB0, 0x67, 0x74, 0x06, 0xB0, 0xE4, 0x08, 0xB0,
  0xE0, 0x17, 0x72, 0x01, 0x0E, 0xB0, 0x84, 0x01, 0x0E, 0xB0, 0xA7, 0x72, 0x0A, 0xB0, 0xE0, 0x15,
  0x05, 0xC0, 0x77, 0x70, 0x7C, 0x05, 0x70, 0xBC, 0x05, 0x75, 0x05, 0xC0, 0xB7, 0x10, 0x10, 0xEC,
  0x06, 0x73, 0x06, 0xC0, 0xE0, 0x17, 0x20, 0x30, 0xEC, 0x08, 0x71, 0x08, 0xC0, 0xE0, 0x37, 0x40,
  0x4D, 0x0D, 0x04, 0x40, 0x40, 0xDD, 0x04, 0x76, 0x04, 0x0E, 0xD8, 0x2C, 0x55, 0xCD, 0x0E, 0x04,
  0x77, 0x10, 0x20, 0xDF, 0xD0, 0xD0, 0x27, 0x74, 0x08, 0xFB, 0x08, 0x77, 0x70, 0x20, 0xAE, 0x0A,
  0x02, 0x77, 0x73, 0x84, 0x17, 0xCC, 0x71, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_gpp_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_gpp_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_gpp_good 48x48, 4-bit Alpha,  RLE, 302 bytes.
static const unsigned char ic_outlined_48_device_gpp_good_data[] PROGMEM = {
  0x76, 0x84, 0x16, 0xCC, 0x61, 0x77, 0x73, 0x04, 0x0A, 0xE0, 0xA0, 0x47, 0x75, 0x81, 0x28, 0xEF,
  0xB8, 0x1E, 0x82, 0x76, 0x81, 0x16, 0xCF, 0xFA, 0x81, 0xC6, 0x17, 0x10, 0x40, 0xAF, 0xA8, 0x2D,
  0x88, 0xDF, 0xA0, 0xA0, 0x43, 0x81, 0x28, 0xEF, 0x98, 0x1E, 0x94, 0x48, 0x14, 0x9E, 0xF9, 0x81,
  0xE8, 0x2F, 0xA0, 0xA0, 0x57, 0x30, 0x50, 0xAF, 0xF9, 0x0B, 0x05, 0x77, 0x20, 0x50, 0xBF, 0xB0,
  0x60, 0x17, 0x76, 0x01, 0x06, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77,
  0x73, 0xF9, 0x77, 0x38, 0x13, 0xC1, 0x4F, 0x97, 0x72, 0x83, 0x3E, 0xFD, 0x13, 0xF9, 0x77, 0x10,
  0x30, 0xEB, 0x0D, 0x3F, 0x97, 0x70, 0x30, 0xEC, 0x07, 0x3F, 0x95, 0x08, 0x01, 0x60, 0x30, 0xEC,
  0x07, 0x4F, 0x94, 0x82, 0xAF, 0xD1, 0x40, 0x30, 0xEC, 0x07, 0x5C, 0x0D, 0xB0, 0x12, 0x0A, 0xB0,
  0xD0, 0x12, 0x03, 0x0E, 0xC0, 0x75, 0x01, 0xB0, 0xD0, 0xCB, 0x02, 0x20, 0xAC, 0x82, 0xD1, 0x3E,
  0xC0, 0x76, 0x02, 0xB0, 0xC0, 0xBB, 0x04, 0x30, 0xAC, 0x0D, 0x0E, 0xC0, 0x77, 0x04, 0xB0, 0xB0,
  0x8B, 0x08, 0x40, 0xAF, 0x90, 0x77, 0x10, 0x8B, 0x08, 0x04, 0xB0, 0xC5, 0x0A, 0xE0, 0x77, 0x20,
  0xCB, 0x04, 0x1C, 0x01, 0x50, 0xAC, 0x07, 0x72, 0x01, 0xC2, 0x0C, 0xB0, 0x76, 0x0A, 0xA0, 0x77,
  0x30, 0x7B, 0x0C, 0x20, 0x5B, 0x0D, 0x70, 0xA0, 0x77, 0x40, 0xDB, 0x05, 0x30, 0xEB, 0x06, 0x77,
  0x40, 0x6B, 0x0E, 0x40, 0x8B, 0x0E, 0x01, 0x77, 0x20, 0x10, 0xEB, 0x08, 0x40, 0x10, 0xEB, 0x0A,
  0x77, 0x20, 0xAB, 0x0E, 0x01, 0x50, 0x5C, 0x07, 0x77, 0x07, 0xC0, 0x57, 0x0B, 0xC0, 0x57, 0x50,
  0x5C, 0x0B, 0x71, 0x01, 0x0E, 0xC0, 0x67, 0x30, 0x6C, 0x0E, 0x01, 0x72, 0x03, 0x0E, 0xC0, 0x87,
  0x10, 0x8C, 0x0E, 0x03, 0x74, 0x04, 0xD0, 0xD0, 0x44, 0x04, 0x0D, 0xD0, 0x47, 0x60, 0x40, 0xED,
  0x82, 0xC5, 0x5C, 0xD0, 0xE0, 0x47, 0x71, 0x02, 0x0D, 0xFD, 0x0D, 0x02, 0x77, 0x40, 0x8F, 0xB0,
  0x87, 0x77, 0x02, 0x0A, 0xE0, 0xA0, 0x27, 0x77, 0x38, 0x41, 0x7C, 0xC7, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_gpp_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_gpp_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_gpp_maybe 48x48, 4-bit Alpha,  RLE, 260 bytes.
static const unsigned char ic_outlined_48_device_gpp_maybe_data[] PROGMEM = {
  0x76, 0x84, 0x16, 0xCC, 0x61, 0x77, 0x73, 0x04, 0x0A, 0xE0, 0xA0, 0x47, 0x75, 0x81, 0x28, 0xEF,
  0xB8, 0x1E, 0x82, 0x76, 0x81, 0x16, 0xCF, 0xFA, 0x81, 0xC6, 0x17, 0x10, 0x40, 0xAF, 0xA8, 0x2D,
  0x77, 0xDF, 0xA0, 0xA0, 0x43, 0x81, 0x28, 0xEF, 0x98, 0x1E, 0x93, 0x48, 0x13, 0x9E, 0xF9, 0x81,
  0xE8, 0x2F, 0xA0, 0xB0, 0x57, 0x30, 0x50, 0xBF, 0xF9, 0x81, 0xD7, 0x17, 0x78, 0x11, 0x7D, 0xFB,
  0x09, 0x03, 0x77, 0x60, 0x30, 0x9F, 0x97, 0x77, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F,
  0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C,
  0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xC0, 0xDB, 0x01, 0x72, 0xC7, 0x20, 0x1B, 0x0D,
  0x0C, 0xB0, 0x27, 0x77, 0x10, 0x2B, 0x0C, 0x0B, 0xB0, 0x47, 0x77, 0x10, 0x4B, 0x0B, 0x08, 0xB0,
  0x87, 0x77, 0x10, 0x8B, 0x08, 0x04, 0xB0, 0xC7, 0x77, 0x10, 0xCB, 0x04, 0x1C, 0x01, 0x71, 0xC7,
  0x10, 0x1C, 0x20, 0xCB, 0x07, 0x71, 0xC7, 0x10, 0x7B, 0x0C, 0x20, 0x5B, 0x0D, 0x71, 0xC7, 0x10,
  0xDB, 0x05, 0x30, 0xEB, 0x06, 0x7C, 0x70, 0x6B, 0x0E, 0x40, 0x8B, 0x0E, 0x01, 0x77, 0x20, 0x10,
  0xEB, 0x08, 0x40, 0x10, 0xEB, 0x0A, 0x77, 0x20, 0xAB, 0x0E, 0x01, 0x50, 0x5C, 0x07, 0x77, 0x07,
  0xC0, 0x57, 0x0B, 0xC0, 0x57, 0x50, 0x5C, 0x0B, 0x71, 0x01, 0x0E, 0xC0, 0x67, 0x30, 0x6C, 0x0E,
  0x01, 0x72, 0x03, 0x0E, 0xC0, 0x87, 0x10, 0x8C, 0x0E, 0x03, 0x74, 0x04, 0xD0, 0xD0, 0x44, 0x04,
  0x0D, 0xD0, 0x47, 0x60, 0x40, 0xED, 0x82, 0xC5, 0x5C, 0xD0, 0xE0, 0x47, 0x71, 0x02, 0x0D, 0xFD,
  0x0D, 0x02, 0x77, 0x40, 0x8F, 0xB0, 0x87, 0x77, 0x02, 0x0A, 0xE0, 0xA0, 0x27, 0x77, 0x38, 0x41,
  0x7C, 0xC7, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_gpp_maybe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_gpp_maybe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_gps_fixed 48x48, 4-bit Alpha,  RLE, 355 bytes.
static const unsigned char ic_outlined_48_device_gps_fixed_data[] PROGMEM = {
  0x77, 0x6C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC0, 0x08, 0x21, 0x58,
  0xCC, 0x82, 0xC8, 0x51, 0x77, 0x77, 0x20, 0x50, 0xBF, 0xD0, 0xB0, 0x57, 0x77, 0x50, 0x30, 0xCF,
  0xFA, 0x0C, 0x03, 0x77, 0x72, 0x09, 0xFF, 0xE0, 0x97, 0x76, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22,
  0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x73, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C,
  0x01, 0x77, 0x20, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x71, 0x09, 0xC0, 0xB0, 0x17,
  0x72, 0x01, 0x0B, 0xC0, 0x97, 0x60, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x75, 0x0C, 0xB0, 0xD0,
  0x17, 0x76, 0x01, 0x0D, 0xB0, 0xC7, 0x40, 0x5C, 0x03, 0x78, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x03,
  0xC0, 0x57, 0x30, 0xBB, 0x0A, 0x70, 0x9F, 0x90, 0x97, 0x0A, 0xB0, 0xB7, 0x20, 0x1C, 0x02, 0x60,
  0xBF, 0xB0, 0xB6, 0x02, 0xC0, 0x17, 0x10, 0x5B, 0x0C, 0x60, 0x9F, 0xD0, 0x96, 0x0C, 0xB0, 0x57,
  0x10, 0x9B, 0x07, 0x50, 0x2F, 0xF0, 0x25, 0x07, 0xB0, 0x97, 0x10, 0xCB, 0x03, 0x50, 0x8F, 0xF0,
  0x85, 0x03, 0xB0, 0xC4, 0xF9, 0x02, 0x50, 0xCF, 0xF0, 0xC5, 0x02, 0xFF, 0xA6, 0x0E, 0xFF, 0x0E,
  0x6F, 0xFA, 0x60, 0xEF, 0xF0, 0xE6, 0xFF, 0xA0, 0x25, 0x0C, 0xFF, 0x0C, 0x50, 0x2F, 0x94, 0x0C,
  0xB0, 0x35, 0x08, 0xFF, 0x08, 0x50, 0x3B, 0x0C, 0x71, 0x09, 0xB0, 0x75, 0x02, 0xFF, 0x02, 0x50,
  0x7B, 0x09, 0x71, 0x05, 0xB0, 0xC6, 0x09, 0xFD, 0x09, 0x60, 0xCB, 0x05, 0x71, 0x01, 0xC0, 0x26,
  0x0B, 0xFB, 0x0B, 0x60, 0x2C, 0x01, 0x72, 0x0B, 0xB0, 0xA7, 0x09, 0xF9, 0x09, 0x70, 0xAB, 0x0B,
  0x73, 0x05, 0xC0, 0x37, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x70, 0x3C, 0x05, 0x74, 0x0C, 0xB0, 0xD0,
  0x17, 0x76, 0x01, 0x0D, 0xB0, 0xC7, 0x50, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x76, 0x09, 0xC0,
  0xB0, 0x17, 0x72, 0x01, 0x0B, 0xC0, 0x97, 0x71, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B,
  0x77, 0x20, 0x10, 0xCD, 0x0A, 0x02, 0x73, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x73, 0x01, 0x0B, 0xE8,
  0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x76, 0x09, 0xFF, 0xE0, 0x97, 0x77, 0x20,
  0x30, 0xCF, 0xFA, 0x0C, 0x03, 0x77, 0x75, 0x05, 0x0B, 0xFD, 0x0B, 0x05, 0x77, 0x77, 0x28, 0x21,
  0x58, 0xCC, 0x82, 0xC8, 0x51, 0x80, 0xC0, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4,
  0x0C, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_gps_fixed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_gps_fixed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_gps_not_fixed 48x48, 4-bit Alpha,  RLE, 319 bytes.
static const unsigned char ic_outlined_48_device_gps_not_fixed_data[] PROGMEM = {
  0x77, 0x6C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC0, 0x08, 0x21, 0x58,
  0xCC, 0x82, 0xC8, 0x51, 0x77, 0x77, 0x20, 0x50, 0xBF, 0xD0, 0xB0, 0x57, 0x77, 0x50, 0x30, 0xCF,
  0xFA, 0x0C, 0x03, 0x77, 0x72, 0x09, 0xFF, 0xE0, 0x97, 0x76, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22,
  0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x73, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C,
  0x01, 0x77, 0x20, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x71, 0x09, 0xC0, 0xB0, 0x17,
  0x72, 0x01, 0x0B, 0xC0, 0x97, 0x60, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x75, 0x0C, 0xB0, 0xD0,
  0x17, 0x76, 0x01, 0x0D, 0xB0, 0xC7, 0x40, 0x5C, 0x03, 0x77, 0x71, 0x03, 0xC0, 0x57, 0x30, 0xBB,
  0x0A, 0x77, 0x73, 0x0A, 0xB0, 0xB7, 0x20, 0x1C, 0x02, 0x77, 0x73, 0x02, 0xC0, 0x17, 0x10, 0x5B,
  0x0C, 0x77, 0x75, 0x0C, 0xB0, 0x57, 0x10, 0x9B, 0x07, 0x77, 0x75, 0x07, 0xB0, 0x97, 0x10, 0xCB,
  0x03, 0x77, 0x75, 0x03, 0xB0, 0xC4, 0xF9, 0x02, 0x77, 0x75, 0x02, 0xFF, 0xA7, 0x77, 0x7F, 0xFA,
  0x77, 0x77, 0xFF, 0xA0, 0x27, 0x77, 0x50, 0x2F, 0x94, 0x0C, 0xB0, 0x37, 0x77, 0x50, 0x3B, 0x0C,
  0x71, 0x09, 0xB0, 0x77, 0x77, 0x50, 0x7B, 0x09, 0x71, 0x05, 0xB0, 0xC7, 0x77, 0x50, 0xCB, 0x05,
  0x71, 0x01, 0xC0, 0x27, 0x77, 0x30, 0x2C, 0x01, 0x72, 0x0B, 0xB0, 0xA7, 0x77, 0x30, 0xAB, 0x0B,
  0x73, 0x05, 0xC0, 0x37, 0x77, 0x10, 0x3C, 0x05, 0x74, 0x0C, 0xB0, 0xD0, 0x17, 0x76, 0x01, 0x0D,
  0xB0, 0xC7, 0x50, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x76, 0x09, 0xC0, 0xB0, 0x17, 0x72, 0x01,
  0x0B, 0xC0, 0x97, 0x71, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x77, 0x20, 0x10, 0xCD,
  0x0A, 0x02, 0x73, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x73, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22, 0x82,
  0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x76, 0x09, 0xFF, 0xE0, 0x97, 0x77, 0x20, 0x30, 0xCF, 0xFA, 0x0C,
  0x03, 0x77, 0x75, 0x05, 0x0B, 0xFD, 0x0B, 0x05, 0x77, 0x77, 0x28, 0x21, 0x58, 0xCC, 0x82, 0xC8,
  0x51, 0x80, 0xC0, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_gps_not_fixed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_gps_not_fixed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_gps_off 48x48, 4-bit Alpha,  RLE, 394 bytes.
static const unsigned char ic_outlined_48_device_gps_off_data[] PROGMEM = {
  0x77, 0x6C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77, 0x75, 0x01, 0x76, 0xC7, 0x77, 0x48, 0x11,
  0xD9, 0x71, 0x82, 0x16, 0x8C, 0xC8, 0x2C, 0x85, 0x17, 0x76, 0x01, 0x0D, 0xA0, 0x95, 0x02, 0x0A,
  0xFD, 0x0B, 0x05, 0x77, 0x40, 0xBC, 0x09, 0x50, 0xAF, 0xF0, 0xC0, 0x37, 0x72, 0x02, 0x0D, 0xC0,
  0x95, 0x0A, 0xFF, 0x90, 0x97, 0x72, 0x02, 0x0D, 0xC0, 0x95, 0x82, 0x87, 0x31, 0x28, 0x22, 0x47,
  0xCE, 0x0B, 0x01, 0x77, 0x10, 0x20, 0xDC, 0x09, 0x77, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x71, 0x02,
  0xD0, 0x97, 0x71, 0x03, 0x0D, 0xC0, 0xB7, 0x71, 0x08, 0xE0, 0x97, 0x71, 0x01, 0x0B, 0xC0, 0x97,
  0x60, 0x3F, 0x90, 0x97, 0x72, 0x0B, 0xC0, 0x37, 0x50, 0xCB, 0x00, 0xDC, 0x09, 0x77, 0x10, 0x10,
  0xDB, 0x0C, 0x74, 0x04, 0xC8, 0x13, 0x2D, 0xC0, 0x97, 0x71, 0x03, 0xC0, 0x57, 0x30, 0xBB, 0x09,
  0x20, 0x20, 0xDC, 0x09, 0x77, 0x10, 0xAB, 0x0B, 0x72, 0x01, 0xC0, 0x23, 0x02, 0x0D, 0xC0, 0x97,
  0x70, 0x2C, 0x01, 0x71, 0x06, 0xB0, 0xB5, 0x02, 0x0D, 0xC0, 0x97, 0x70, 0xCB, 0x05, 0x71, 0x09,
  0xB0, 0x76, 0x02, 0x0D, 0xC0, 0x97, 0x60, 0x7B, 0x09, 0x71, 0x0C, 0xB0, 0x37, 0x02, 0x0D, 0xC0,
  0x97, 0x50, 0x3B, 0x0C, 0x4F, 0x90, 0x17, 0x10, 0x20, 0xDC, 0x09, 0x74, 0x02, 0xFF, 0xA7, 0x30,
  0x20, 0xDC, 0x09, 0x74, 0xFF, 0xA7, 0x40, 0x20, 0xDC, 0x09, 0x73, 0xFF, 0xA0, 0x27, 0x40, 0x20,
  0xDC, 0x09, 0x71, 0x01, 0xF9, 0x40, 0xCB, 0x03, 0x75, 0x02, 0x0D, 0xC0, 0x97, 0x03, 0xB0, 0xC7,
  0x10, 0x9B, 0x07, 0x76, 0x02, 0x0D, 0xC0, 0x96, 0x07, 0xB0, 0x97, 0x10, 0x5B, 0x0C, 0x77, 0x02,
  0x0D, 0xC0, 0x95, 0x08, 0xB0, 0x57, 0x10, 0x1C, 0x02, 0x77, 0x02, 0x0D, 0xC0, 0x95, 0x0A, 0xA0,
  0x17, 0x20, 0xBB, 0x0A, 0x77, 0x10, 0x20, 0xDC, 0x09, 0x50, 0x0A, 0x73, 0x05, 0xC0, 0x37, 0x71,
  0x02, 0x0D, 0xC0, 0x95, 0x02, 0x74, 0x0C, 0xB0, 0xD0, 0x17, 0x71, 0x02, 0x0D, 0xC0, 0x97, 0x72,
  0x03, 0xC0, 0xB7, 0x72, 0x02, 0x0D, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xB0, 0x17, 0x71, 0x02, 0x0D,
  0xC0, 0x97, 0x72, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDD, 0x09, 0x77, 0x10, 0x10, 0xCD, 0x0A,
  0x02, 0x73, 0x02, 0x09, 0xF9, 0x09, 0x77, 0x10, 0x10, 0xBE, 0x82, 0xC7, 0x42, 0x28, 0x21, 0x37,
  0xBF, 0xC0, 0x97, 0x72, 0x09, 0xFF, 0xE8, 0x18, 0x2D, 0xC0, 0x97, 0x72, 0x03, 0x0C, 0xFF, 0xA0,
  0xC0, 0x32, 0x02, 0x0D, 0xB0, 0xD0, 0x17, 0x73, 0x05, 0x0B, 0xFD, 0x0B, 0x04, 0x58, 0x32, 0xDF,
  0xD1, 0x77, 0x68, 0x21, 0x58, 0xCC, 0x82, 0xC9, 0x61, 0x71, 0x81, 0x2B, 0x17, 0x77, 0x4C, 0x80,
  0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_gps_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_gps_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_graphic_eq 48x48, 4-bit Alpha,  RLE, 149 bytes.
static const unsigned char ic_outlined_48_device_graphic_eq_data[] PROGMEM = {
  0x77, 0x2C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77,
  0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x73, 0xC4, 0xC4, 0xC7, 0x72, 0xC4, 0xC4, 0xC7,
  0x72, 0xC4, 0xC4, 0xC7, 0x72, 0xC4, 0xC4, 0xC7, 0x72, 0xC4, 0xC4, 0xC7, 0x72, 0xC4, 0xC4, 0xC7,
  0x72, 0xC4, 0xC4, 0xC7, 0x72, 0xC4, 0xC4, 0xC7, 0x1C, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4,
  0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F, 0x94,
  0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xC7, 0x1C, 0x4C, 0x4C,
  0x77, 0x2C, 0x4C, 0x4C, 0x77, 0x2C, 0x4C, 0x4C, 0x77, 0x2C, 0x4C, 0x4C, 0x77, 0x2C, 0x4C, 0x4C,
  0x77, 0x2C, 0x4C, 0x4C, 0x77, 0x2C, 0x4C, 0x4C, 0x77, 0x2C, 0x4C, 0x4C, 0x77, 0x73, 0xC7, 0x77,
  0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74,
  0xC7, 0x77, 0x74, 0xC7, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_graphic_eq() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_graphic_eq_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_grid_3x3 48x48, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_outlined_48_device_grid_3x3_data[] PROGMEM = {
  0x71, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x72, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x72, 0xC7,
  0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x72, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x18, 0x09, 0xF4, 0xF7,
  0x1C, 0x71, 0xC7, 0x72, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x72, 0xC7, 0x1C, 0x77, 0x2C, 0x71,
  0xC7, 0x72, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x72, 0xC7, 0x1C, 0x71, 0x80, 0x9F, 0x4F, 0x71,
  0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x72, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x72, 0xC7, 0x1C,
  0x77, 0x2C, 0x71, 0xC7, 0x72, 0xC7, 0x1C, 0x77, 0x2C, 0x71, 0xC7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_grid_3x3() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_grid_3x3_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_grid_4x4 48x48, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_outlined_48_device_grid_4x4_data[] PROGMEM = {
  0x6C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C,
  0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC6, 0x80, 0xAB, 0x4F, 0x6C, 0x71,
  0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7,
  0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C,
  0x71, 0xC6, 0x80, 0xAB, 0x4F, 0x6C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71,
  0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7,
  0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC6, 0x80, 0xAB, 0x4F, 0x6C, 0x71, 0xC7, 0x1C,
  0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71,
  0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_grid_4x4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_grid_4x4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_grid_goldenratio 48x48, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_outlined_48_device_grid_goldenratio_data[] PROGMEM = {
  0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4,
  0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77,
  0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C,
  0x77, 0x80, 0xAB, 0x4F, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C,
  0x4C, 0x77, 0x80, 0xAB, 0x4F, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77,
  0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C,
  0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77,
  0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_grid_goldenratio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_grid_goldenratio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_hdr_auto 48x48, 4-bit Alpha,  RLE, 405 bytes.
static const unsigned char ic_outlined_48_device_hdr_auto_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x02, 0xC0, 0x27, 0x01, 0x0C, 0xC0, 0x55, 0x01,
  0x0E, 0xB0, 0xE0, 0x17, 0x10, 0x8C, 0x08, 0x71, 0x01, 0x0E, 0xB0, 0xE0, 0x14, 0x09, 0xC0, 0x37,
  0x20, 0xDC, 0x0D, 0x72, 0x03, 0xC0, 0x93, 0x01, 0xC0, 0x77, 0x20, 0x4E, 0x04, 0x72, 0x07, 0xC0,
  0x12, 0x08, 0xB0, 0xE7, 0x30, 0xAA, 0x0B, 0x0C, 0xA0, 0xA7, 0x30, 0xEB, 0x08, 0x20, 0xDB, 0x06,
  0x72, 0x01, 0xB0, 0x06, 0xA0, 0xE7, 0x30, 0x6B, 0x81, 0xD0, 0x3C, 0x73, 0x06, 0xB0, 0x01, 0xB0,
  0x67, 0x3C, 0x03, 0x07, 0xB0, 0xB7, 0x30, 0xCA, 0x0A, 0x20, 0xBA, 0x0C, 0x73, 0x0B, 0xB0, 0x70,
  0xAB, 0x06, 0x72, 0x02, 0xB0, 0x52, 0x05, 0xB0, 0x27, 0x20, 0x6B, 0x0A, 0x0C, 0xB0, 0x37, 0x20,
  0x8A, 0x0E, 0x40, 0xEA, 0x08, 0x72, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x72, 0x0E, 0xA0, 0x94, 0x0A,
  0xA0, 0xD7, 0x20, 0x2B, 0x0E, 0xC7, 0x20, 0x4B, 0x04, 0x40, 0x4B, 0x04, 0x72, 0xF9, 0x72, 0x0A,
  0xA0, 0xE6, 0x0E, 0xA0, 0xA7, 0x2C, 0x0E, 0xB0, 0x27, 0x01, 0xC8, 0x02, 0xDB, 0x0E, 0x71, 0x02,
  0xB0, 0xE0, 0xCB, 0x03, 0x70, 0x6F, 0xF0, 0x67, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x70, 0xCF, 0xF0,
  0xC7, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x60, 0x2B, 0x0A, 0x80, 0x45, 0x0A, 0xB0, 0x26, 0x0B, 0xB0,
  0x70, 0x3C, 0x60, 0x8B, 0x02, 0x71, 0x02, 0xB0, 0x86, 0xC8, 0x13, 0x0D, 0xB0, 0x65, 0x0E, 0xA0,
  0xC7, 0x30, 0xCA, 0x0D, 0x50, 0x6B, 0x0D, 0x20, 0x8B, 0x0E, 0x40, 0x4B, 0x06, 0x73, 0x07, 0xB0,
  0x44, 0x0E, 0xB0, 0x82, 0x01, 0xC0, 0x73, 0x0A, 0xB0, 0x17, 0x30, 0x1B, 0x0A, 0x30, 0x7C, 0x01,
  0x30, 0x9C, 0x81, 0x30, 0x1B, 0x0B, 0x75, 0x0B, 0xB8, 0x11, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xCC,
  0x05, 0x70, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC, 0x09, 0x72, 0x0A, 0xD0, 0x77, 0x72, 0x07,
  0xD0, 0xA7, 0x40, 0xAD, 0x0E, 0x06, 0x75, 0x06, 0x0E, 0xD0, 0xA7, 0x60, 0x9F, 0x82, 0xB6, 0x32,
  0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F,
  0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD,
  0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_hdr_auto() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_hdr_auto_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_hdr_auto_select 48x48, 4-bit Alpha,  RLE, 308 bytes.
static const unsigned char ic_outlined_48_device_hdr_auto_select_data[] PROGMEM = {
  0x77, 0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x80, 0xC0, 0x00, 0x10, 0x9F, 0xB0, 0x90, 0x17,
  0x77, 0x75, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x77, 0x77, 0x30, 0x6F, 0xFA, 0x06, 0x77, 0x77, 0x10,
  0x4F, 0x08, 0x20, 0x8F, 0x04, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0x22, 0x03, 0xF0, 0xE0, 0x17, 0x77,
  0x50, 0x9F, 0x0C, 0x40, 0xCF, 0x09, 0x77, 0x74, 0x01, 0xF9, 0x84, 0x60, 0x55, 0x06, 0xF9, 0x01,
  0x77, 0x73, 0x06, 0xF9, 0x84, 0x10, 0xBB, 0x01, 0xF9, 0x06, 0x77, 0x73, 0x0B, 0xF8, 0x1A, 0x01,
  0xA8, 0x11, 0x0A, 0xF0, 0xB7, 0x77, 0x30, 0xDF, 0x81, 0x40, 0x6A, 0x81, 0x60, 0x4F, 0x0D, 0x77,
  0x73, 0x0E, 0xE0, 0xE2, 0x0C, 0xA0, 0xC2, 0x0E, 0xE0, 0xE7, 0x77, 0x30, 0xEE, 0x08, 0x28, 0x00,
  0x52, 0x08, 0xE0, 0xE7, 0x77, 0x30, 0xDE, 0x02, 0x71, 0x03, 0xE0, 0xD7, 0x77, 0x30, 0xBD, 0x0C,
  0x28, 0x01, 0x90, 0x82, 0x0C, 0xD0, 0xB7, 0x77, 0x30, 0x6D, 0x81, 0x60, 0x3E, 0x81, 0x30, 0x6D,
  0x06, 0x77, 0x73, 0x01, 0xD8, 0x11, 0x08, 0xE8, 0x18, 0x01, 0xD0, 0x17, 0x77, 0x40, 0x9B, 0x0A,
  0x20, 0xDE, 0x0D, 0x20, 0xAB, 0x09, 0x77, 0x75, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x17, 0x77, 0x60,
  0x4F, 0xFC, 0x04, 0x77, 0x77, 0x10, 0x6F, 0xFA, 0x06, 0x77, 0x77, 0x30, 0x40, 0xEF, 0xD0, 0xE0,
  0x47, 0x77, 0x75, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x80, 0xC0, 0x08, 0x90, 0x16, 0xAD, 0xEE, 0xDA,
  0x61, 0x80, 0xB9, 0x70, 0xB4, 0xB3, 0xF0, 0xD0, 0x74, 0xF0, 0xD0, 0x77, 0x6B, 0x4B, 0x3F, 0xA0,
  0x73, 0xFA, 0x07, 0x5B, 0x4B, 0x4B, 0x3F, 0xA0, 0xD3, 0xFA, 0x0D, 0x5B, 0x4B, 0x4B, 0x3B, 0x4B,
  0x3B, 0x4B, 0x5B, 0x4F, 0xB3, 0xB4, 0xB3, 0xB4, 0xB5, 0xB4, 0xFB, 0x3B, 0x4B, 0x3F, 0xA0, 0xE1,
  0xFF, 0xF3, 0xB4, 0xB3, 0xFA, 0x07, 0x1F, 0xF4, 0xB3, 0xB4, 0xB3, 0xF9, 0x09, 0x2F, 0xF4, 0xB3,
  0xB4, 0xB3, 0xB2, 0x08, 0xA0, 0x76, 0xB4, 0xB4, 0xB3, 0xFA, 0x0D, 0x3B, 0x20, 0x2A, 0x0E, 0x6B,
  0x4B, 0x4B, 0x3F, 0xA0, 0x73, 0xB3, 0x0A, 0xA0, 0x55, 0xB4, 0xB4, 0xB3, 0xF0, 0xD0, 0x74, 0xB3,
  0x03, 0xA0, 0xC5, 0xB4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_hdr_auto_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 47, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_hdr_auto_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_hdr_off_select 48x48, 4-bit Alpha,  RLE, 337 bytes.
static const unsigned char ic_outlined_48_device_hdr_off_select_data[] PROGMEM = {
  0x75, 0x01, 0x68, 0x21, 0x7A, 0xEA, 0x82, 0xDB, 0x71, 0x77, 0x77, 0x28, 0x13, 0xE7, 0x50, 0xBF,
  0xA0, 0x90, 0x17, 0x77, 0x60, 0x30, 0xEA, 0x07, 0x50, 0xCF, 0xA0, 0xE0, 0x47, 0x77, 0x50, 0xDC,
  0x07, 0x50, 0xCF, 0xB0, 0x67, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x58, 0x43, 0x10, 0x36, 0xDD, 0x04,
  0x77, 0x74, 0x03, 0x0E, 0xC0, 0x77, 0x30, 0x6C, 0x0E, 0x01, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x77,
  0x30, 0x4C, 0x09, 0x77, 0x74, 0x01, 0xE0, 0x77, 0x30, 0x6C, 0x01, 0x77, 0x73, 0x06, 0xF0, 0x77,
  0x30, 0xDB, 0x07, 0x77, 0x73, 0x0A, 0xF9, 0x07, 0x72, 0x06, 0xB0, 0xB7, 0x77, 0x30, 0xDB, 0x06,
  0x0E, 0xC0, 0x77, 0x10, 0x3B, 0x0D, 0x77, 0x73, 0xC8, 0x11, 0x3E, 0xC0, 0x77, 0x01, 0xC7, 0x77,
  0x3C, 0x82, 0x10, 0x3E, 0xC0, 0x76, 0x01, 0xC7, 0x77, 0x30, 0xDB, 0x03, 0x20, 0x30, 0xEC, 0x07,
  0x50, 0x3B, 0x0D, 0x77, 0x73, 0x0B, 0xB0, 0x63, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xA0, 0xA7, 0x77,
  0x30, 0x7B, 0x0D, 0x40, 0x30, 0xEC, 0x07, 0x58, 0x1C, 0xF6, 0x77, 0x73, 0x01, 0xC0, 0x64, 0x03,
  0x0E, 0xC0, 0x75, 0x0B, 0x01, 0x77, 0x74, 0x09, 0xC0, 0x44, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x73,
  0x01, 0x0E, 0xC0, 0x64, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x73, 0x04, 0xD8, 0x4D, 0x63, 0x01, 0x6D,
  0x07, 0x77, 0x77, 0x30, 0x6F, 0xFA, 0x07, 0x77, 0x77, 0x30, 0x40, 0xEF, 0xF9, 0x07, 0x77, 0x77,
  0x30, 0x10, 0x9F, 0xB0, 0xEC, 0x07, 0x77, 0x77, 0x48, 0x21, 0x7B, 0xDA, 0x84, 0xEA, 0x71, 0x3E,
  0xB0, 0xE0, 0x18, 0x0C, 0x60, 0x83, 0x3E, 0xFE, 0x38, 0x0D, 0x00, 0x81, 0x3D, 0x38, 0x09, 0xD2,
  0x0B, 0x4B, 0x3F, 0x0D, 0x07, 0x4F, 0x0D, 0x07, 0x76, 0xB4, 0xB3, 0xFA, 0x07, 0x3F, 0xA0, 0x75,
  0xB4, 0xB4, 0xB3, 0xFA, 0x0D, 0x3F, 0xA0, 0xD5, 0xB4, 0xB4, 0xB3, 0xB4, 0xB3, 0xB4, 0xB5, 0xB4,
  0xFB, 0x3B, 0x4B, 0x3B, 0x4B, 0x5B, 0x4F, 0xB3, 0xB4, 0xB3, 0xFA, 0x0E, 0x1F, 0xFF, 0x3B, 0x4B,
  0x3F, 0xA0, 0x71, 0xFF, 0x4B, 0x3B, 0x4B, 0x3F, 0x90, 0x92, 0xFF, 0x4B, 0x3B, 0x4B, 0x3B, 0x20,
  0x8A, 0x07, 0x6B, 0x4B, 0x4B, 0x3F, 0xA0, 0xD3, 0xB2, 0x02, 0xA0, 0xE6, 0xB4, 0xB4, 0xB3, 0xFA,
  0x07, 0x3B, 0x30, 0xAA, 0x05, 0x5B, 0x4B, 0x4B, 0x3F, 0x0D, 0x07, 0x4B, 0x30, 0x3A, 0x0C, 0x5B,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_hdr_off_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 47, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_hdr_off_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_hdr_on_select 48x48, 4-bit Alpha,  RLE, 293 bytes.
static const unsigned char ic_outlined_48_device_hdr_on_select_data[] PROGMEM = {
  0x77, 0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x80, 0xC0, 0x00, 0x10, 0x9F, 0xB0, 0x90, 0x17,
  0x77, 0x75, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x77, 0x77, 0x30, 0x6F, 0xFA, 0x06, 0x77, 0x77, 0x10,
  0x4D, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x04, 0x77, 0x76, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C,
  0x0E, 0x01, 0x77, 0x75, 0x09, 0xC0, 0x47, 0x30, 0x4C, 0x09, 0x77, 0x74, 0x01, 0xC0, 0x67, 0x50,
  0x6C, 0x01, 0x77, 0x73, 0x06, 0xB0, 0xC7, 0x70, 0xCB, 0x06, 0x77, 0x73, 0x0B, 0xB0, 0x67, 0x70,
  0x6B, 0x0B, 0x77, 0x73, 0x0D, 0xB0, 0x27, 0x70, 0x2B, 0x0D, 0x77, 0x73, 0x0E, 0xB7, 0x72, 0xB0,
  0xE7, 0x77, 0x30, 0xEB, 0x77, 0x2B, 0x0E, 0x77, 0x73, 0x0D, 0xB0, 0x27, 0x70, 0x2B, 0x0D, 0x77,
  0x73, 0x0B, 0xB0, 0x67, 0x70, 0x6B, 0x0B, 0x77, 0x73, 0x06, 0xB0, 0xC7, 0x70, 0xCB, 0x06, 0x77,
  0x73, 0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x77, 0x74, 0x09, 0xC0, 0x47, 0x30, 0x4C, 0x09, 0x77,
  0x75, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C, 0x0E, 0x01, 0x77, 0x76, 0x04, 0xD8, 0x1C, 0x62, 0x28,
  0x12, 0x6C, 0xD0, 0x47, 0x77, 0x71, 0x06, 0xFF, 0xA0, 0x67, 0x77, 0x73, 0x04, 0x0E, 0xFD, 0x0E,
  0x04, 0x77, 0x77, 0x50, 0x10, 0x9F, 0xB0, 0x90, 0x18, 0x0C, 0x00, 0x89, 0x01, 0x6A, 0xDE, 0xED,
  0xA6, 0x18, 0x0B, 0x97, 0x0B, 0x4B, 0x3F, 0x0D, 0x07, 0x4F, 0x0D, 0x07, 0x76, 0xB4, 0xB3, 0xFA,
  0x07, 0x3F, 0xA0, 0x75, 0xB4, 0xB4, 0xB3, 0xFA, 0x0D, 0x3F, 0xA0, 0xD5, 0xB4, 0xB4, 0xB3, 0xB4,
  0xB3, 0xB4, 0xB5, 0xB4, 0xFB, 0x3B, 0x4B, 0x3B, 0x4B, 0x5B, 0x4F, 0xB3, 0xB4, 0xB3, 0xFA, 0x0E,
  0x1F, 0xFF, 0x3B, 0x4B, 0x3F, 0xA0, 0x71, 0xFF, 0x4B, 0x3B, 0x4B, 0x3F, 0x90, 0x92, 0xFF, 0x4B,
  0x3B, 0x4B, 0x3B, 0x20, 0x8A, 0x07, 0x6B, 0x4B, 0x4B, 0x3F, 0xA0, 0xD3, 0xB2, 0x02, 0xA0, 0xE6,
  0xB4, 0xB4, 0xB3, 0xFA, 0x07, 0x3B, 0x30, 0xAA, 0x05, 0x5B, 0x4B, 0x4B, 0x3F, 0x0D, 0x07, 0x4B,
  0x30, 0x3A, 0x0C, 0x5B, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_hdr_on_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 47, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_hdr_on_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_h_mobiledata 48x48, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_outlined_48_device_h_mobiledata_data[] PROGMEM = {
  0xC7, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x58,
  0x09, 0xA4, 0xF7, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F, 0x97, 0x5F,
  0x97, 0x5C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_h_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 14, 33, 33), Box(0, 0, 47, 47),
      ic_outlined_48_device_h_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_h_plus_mobiledata 48x48, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_outlined_48_device_h_plus_mobiledata_data[] PROGMEM = {
  0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x5C,
  0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xFF, 0xE4,
  0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xA7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C,
  0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x71, 0xC4, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7,
  0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_h_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 14, 43, 33), Box(0, 0, 47, 47),
      ic_outlined_48_device_h_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_lan 48x48, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_outlined_48_device_lan_data[] PROGMEM = {
  0x73, 0xFF, 0xA7, 0x76, 0xFF, 0xA7, 0x76, 0xFF, 0xA7, 0x76, 0xFF, 0xA7, 0x76, 0xC7, 0x1C, 0x77,
  0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71,
  0xC7, 0x76, 0xFF, 0xA7, 0x76, 0xFF, 0xA7, 0x76, 0xFF, 0xA7, 0x76, 0xFF, 0xA7, 0x77, 0x5C, 0x77,
  0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x77, 0x71, 0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x75,
  0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x75, 0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7,
  0x5C, 0x77, 0x2C, 0x6F, 0xFA, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFE,
  0x71, 0xC4, 0xC7, 0x1F, 0x97, 0x1C, 0x4C, 0x71, 0xF9, 0x71, 0xC4, 0xC7, 0x1F, 0x97, 0x1C, 0x4C,
  0x71, 0xF9, 0x71, 0xC4, 0xC7, 0x1F, 0x97, 0x1C, 0x4C, 0x71, 0xFF, 0xE4, 0xFF, 0xFF, 0xC4, 0xFF,
  0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_lan() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_lan_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_lens_blur 48x48, 4-bit Alpha,  RLE, 285 bytes.
static const unsigned char ic_outlined_48_device_lens_blur_data[] PROGMEM = {
  0x77, 0x00, 0xB6, 0x00, 0xB7, 0x77, 0x70, 0x0B, 0x60, 0x0B, 0x80, 0xA8, 0x10, 0x82, 0x4D, 0xD4,
  0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x47, 0x30, 0xDA, 0x0D, 0x40, 0xDA,
  0x0D, 0x40, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x73, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0,
  0xD4, 0x0D, 0xA0, 0xD7, 0x38, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82,
  0x4D, 0xD4, 0x80, 0xA8, 0x00, 0x82, 0x8D, 0xD8, 0x48, 0x28, 0xDD, 0x87, 0x74, 0x82, 0x4D, 0xD4,
  0x30, 0x8C, 0x08, 0x20, 0x8C, 0x08, 0x38, 0x24, 0xDD, 0x45, 0x00, 0xB3, 0x0D, 0xA0, 0xD3, 0x0D,
  0xC0, 0xD2, 0x0D, 0xC0, 0xD3, 0x0D, 0xA0, 0xD3, 0x80, 0x0B, 0x30, 0xDA, 0x0D, 0x30, 0xDC, 0x0D,
  0x20, 0xDC, 0x0D, 0x30, 0xDA, 0x0D, 0x30, 0x0B, 0x58, 0x24, 0xDD, 0x43, 0x08, 0xC0, 0x82, 0x08,
  0xC0, 0x83, 0x82, 0x4D, 0xD4, 0x77, 0x48, 0x28, 0xDD, 0x84, 0x82, 0x8D, 0xD8, 0x80, 0x9C, 0x20,
  0x82, 0x8D, 0xD8, 0x48, 0x28, 0xDD, 0x87, 0x74, 0x82, 0x4D, 0xD4, 0x30, 0x8C, 0x08, 0x20, 0x8C,
  0x08, 0x38, 0x24, 0xDD, 0x45, 0x00, 0xB3, 0x0D, 0xA0, 0xD3, 0x0D, 0xC0, 0xD2, 0x0D, 0xC0, 0xD3,
  0x0D, 0xA0, 0xD3, 0x80, 0x0B, 0x30, 0xDA, 0x0D, 0x30, 0xDC, 0x0D, 0x20, 0xDC, 0x0D, 0x30, 0xDA,
  0x0D, 0x30, 0x0B, 0x58, 0x24, 0xDD, 0x43, 0x08, 0xC0, 0x82, 0x08, 0xC0, 0x83, 0x82, 0x4D, 0xD4,
  0x77, 0x48, 0x28, 0xDD, 0x84, 0x82, 0x8D, 0xD8, 0x80, 0xA8, 0x00, 0x82, 0x4D, 0xD4, 0x48, 0x24,
  0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x47, 0x30, 0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x40,
  0xDA, 0x0D, 0x40, 0xDA, 0x0D, 0x73, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D, 0xA0, 0xD4, 0x0D,
  0xA0, 0xD7, 0x38, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4, 0x48, 0x24, 0xDD, 0x44, 0x82, 0x4D, 0xD4,
  0x80, 0xA8, 0x10, 0x00, 0xB6, 0x00, 0xB7, 0x77, 0x70, 0x0B, 0x60, 0x0B, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_lens_blur() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 42, 42), Box(0, 0, 47, 47),
      ic_outlined_48_device_lens_blur_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_light_mode 48x48, 4-bit Alpha,  RLE, 337 bytes.
static const unsigned char ic_outlined_48_device_light_mode_data[] PROGMEM = {
  0x77, 0x68, 0x24, 0xDD, 0x48, 0x0C, 0x40, 0x0D, 0xA0, 0xD8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC8,
  0x0C, 0x40, 0xC8, 0x0C, 0x40, 0xC7, 0x77, 0x68, 0x11, 0x52, 0x73, 0x0D, 0xA0, 0xD7, 0x38, 0x12,
  0x51, 0x76, 0x01, 0x0E, 0xA0, 0x57, 0x28, 0x24, 0xDD, 0x47, 0x20, 0x5A, 0x0E, 0x01, 0x75, 0x05,
  0xC0, 0x57, 0x76, 0x05, 0xC0, 0x57, 0x50, 0x2D, 0x03, 0x77, 0x40, 0x3D, 0x02, 0x76, 0x05, 0xC0,
  0x97, 0x74, 0x09, 0xC0, 0x57, 0x71, 0x05, 0xB0, 0x67, 0x74, 0x07, 0xB0, 0x57, 0x73, 0x81, 0x39,
  0x76, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x68, 0x16, 0x93, 0x77, 0x74, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
  0x77, 0x77, 0x30, 0x8F, 0xD0, 0x87, 0x77, 0x71, 0x08, 0xFF, 0x08, 0x77, 0x76, 0x04, 0xD0, 0x80,
  0x32, 0x03, 0x08, 0xD0, 0x47, 0x77, 0x50, 0xDB, 0x0D, 0x03, 0x60, 0x30, 0xDB, 0x0D, 0x77, 0x74,
  0x05, 0xC0, 0x37, 0x10, 0x3C, 0x05, 0x77, 0x73, 0x09, 0xB0, 0x87, 0x30, 0x8B, 0x09, 0x75, 0x04,
  0x0D, 0xC0, 0xD0, 0x44, 0x0D, 0xB0, 0x37, 0x30, 0x3B, 0x0D, 0x40, 0x40, 0xDC, 0x81, 0xD4, 0xDE,
  0x0D, 0x40, 0xEB, 0x75, 0xB0, 0xE4, 0x0D, 0xE0, 0x0D, 0xE0, 0xD4, 0x0E, 0xB7, 0x5B, 0x0E, 0x40,
  0xDE, 0x81, 0xD4, 0xDC, 0x0D, 0x04, 0x40, 0xDB, 0x03, 0x73, 0x03, 0xB0, 0xD4, 0x04, 0x0D, 0xC0,
  0xD0, 0x47, 0x50, 0x9B, 0x08, 0x73, 0x08, 0xB0, 0x97, 0x77, 0x30, 0x5C, 0x03, 0x71, 0x03, 0xC0,
  0x57, 0x77, 0x40, 0xDB, 0x0D, 0x03, 0x60, 0x30, 0xDB, 0x0D, 0x77, 0x75, 0x04, 0xD0, 0x80, 0x32,
  0x03, 0x08, 0xD0, 0x47, 0x77, 0x60, 0x8F, 0xF0, 0x87, 0x77, 0x71, 0x08, 0xFD, 0x08, 0x77, 0x77,
  0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x77, 0x48, 0x13, 0x97, 0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
  0x81, 0x79, 0x37, 0x73, 0x05, 0xB0, 0x77, 0x74, 0x07, 0xB0, 0x57, 0x71, 0x05, 0xC0, 0x97, 0x74,
  0x09, 0xC0, 0x57, 0x60, 0x2D, 0x03, 0x77, 0x40, 0x3D, 0x02, 0x75, 0x05, 0xC0, 0x57, 0x76, 0x05,
  0xC0, 0x57, 0x50, 0x10, 0xEA, 0x05, 0x72, 0x82, 0x4D, 0xD4, 0x72, 0x05, 0xA0, 0xE0, 0x17, 0x68,
  0x11, 0x52, 0x73, 0x0D, 0xA0, 0xD7, 0x38, 0x12, 0x51, 0x77, 0x76, 0xC8, 0x0C, 0x40, 0xC8, 0x0C,
  0x40, 0xC8, 0x0C, 0x40, 0xC8, 0x0C, 0x40, 0x0D, 0xA0, 0xD8, 0x0C, 0x40, 0x82, 0x4D, 0xD4, 0x77,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_light_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_light_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_location_disabled 48x48, 4-bit Alpha,  RLE, 394 bytes.
static const unsigned char ic_outlined_48_device_location_disabled_data[] PROGMEM = {
  0x77, 0x6C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77, 0x75, 0x01, 0x76, 0xC7, 0x77, 0x48, 0x11,
  0xD9, 0x71, 0x82, 0x16, 0x8C, 0xC8, 0x2C, 0x85, 0x17, 0x76, 0x01, 0x0D, 0xA0, 0x95, 0x02, 0x0A,
  0xFD, 0x0B, 0x05, 0x77, 0x40, 0xBC, 0x09, 0x50, 0xAF, 0xF0, 0xC0, 0x37, 0x72, 0x02, 0x0D, 0xC0,
  0x95, 0x0A, 0xFF, 0x90, 0x97, 0x72, 0x02, 0x0D, 0xC0, 0x95, 0x82, 0x87, 0x31, 0x28, 0x22, 0x47,
  0xCE, 0x0B, 0x01, 0x77, 0x10, 0x20, 0xDC, 0x09, 0x77, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x71, 0x02,
  0xD0, 0x97, 0x71, 0x03, 0x0D, 0xC0, 0xB7, 0x71, 0x08, 0xE0, 0x97, 0x71, 0x01, 0x0B, 0xC0, 0x97,
  0x60, 0x3F, 0x90, 0x97, 0x72, 0x0B, 0xC0, 0x37, 0x50, 0xCB, 0x00, 0xDC, 0x09, 0x77, 0x10, 0x10,
  0xDB, 0x0C, 0x74, 0x04, 0xC8, 0x13, 0x2D, 0xC0, 0x97, 0x71, 0x03, 0xC0, 0x57, 0x30, 0xBB, 0x09,
  0x20, 0x20, 0xDC, 0x09, 0x77, 0x10, 0xAB, 0x0B, 0x72, 0x01, 0xC0, 0x23, 0x02, 0x0D, 0xC0, 0x97,
  0x70, 0x2C, 0x01, 0x71, 0x06, 0xB0, 0xB5, 0x02, 0x0D, 0xC0, 0x97, 0x70, 0xCB, 0x05, 0x71, 0x09,
  0xB0, 0x76, 0x02, 0x0D, 0xC0, 0x97, 0x60, 0x7B, 0x09, 0x71, 0x0C, 0xB0, 0x37, 0x02, 0x0D, 0xC0,
  0x97, 0x50, 0x3B, 0x0C, 0x4F, 0x90, 0x17, 0x10, 0x20, 0xDC, 0x09, 0x74, 0x02, 0xFF, 0xA7, 0x30,
  0x20, 0xDC, 0x09, 0x74, 0xFF, 0xA7, 0x40, 0x20, 0xDC, 0x09, 0x73, 0xFF, 0xA0, 0x27, 0x40, 0x20,
  0xDC, 0x09, 0x71, 0x01, 0xF9, 0x40, 0xCB, 0x03, 0x75, 0x02, 0x0D, 0xC0, 0x97, 0x03, 0xB0, 0xC7,
  0x10, 0x9B, 0x07, 0x76, 0x02, 0x0D, 0xC0, 0x96, 0x07, 0xB0, 0x97, 0x10, 0x5B, 0x0C, 0x77, 0x02,
  0x0D, 0xC0, 0x95, 0x08, 0xB0, 0x57, 0x10, 0x1C, 0x02, 0x77, 0x02, 0x0D, 0xC0, 0x95, 0x0A, 0xA0,
  0x17, 0x20, 0xBB, 0x0A, 0x77, 0x10, 0x20, 0xDC, 0x09, 0x50, 0x0A, 0x73, 0x05, 0xC0, 0x37, 0x71,
  0x02, 0x0D, 0xC0, 0x95, 0x02, 0x74, 0x0C, 0xB0, 0xD0, 0x17, 0x71, 0x02, 0x0D, 0xC0, 0x97, 0x72,
  0x03, 0xC0, 0xB7, 0x72, 0x02, 0x0D, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0xB0, 0x17, 0x71, 0x02, 0x0D,
  0xC0, 0x97, 0x72, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDD, 0x09, 0x77, 0x10, 0x10, 0xCD, 0x0A,
  0x02, 0x73, 0x02, 0x09, 0xF9, 0x09, 0x77, 0x10, 0x10, 0xBE, 0x82, 0xC7, 0x42, 0x28, 0x21, 0x37,
  0xBF, 0xC0, 0x97, 0x72, 0x09, 0xFF, 0xE8, 0x18, 0x2D, 0xC0, 0x97, 0x72, 0x03, 0x0C, 0xFF, 0xA0,
  0xC0, 0x32, 0x02, 0x0D, 0xB0, 0xD0, 0x17, 0x73, 0x05, 0x0B, 0xFD, 0x0B, 0x04, 0x58, 0x32, 0xDF,
  0xD1, 0x77, 0x68, 0x21, 0x58, 0xCC, 0x82, 0xC9, 0x61, 0x71, 0x81, 0x2B, 0x17, 0x77, 0x4C, 0x80,
  0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_location_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_location_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_location_searching 48x48, 4-bit Alpha,  RLE, 319 bytes.
static const unsigned char ic_outlined_48_device_location_searching_data[] PROGMEM = {
  0x77, 0x6C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC0, 0x08, 0x21, 0x58,
  0xCC, 0x82, 0xC8, 0x51, 0x77, 0x77, 0x20, 0x50, 0xBF, 0xD0, 0xB0, 0x57, 0x77, 0x50, 0x30, 0xCF,
  0xFA, 0x0C, 0x03, 0x77, 0x72, 0x09, 0xFF, 0xE0, 0x97, 0x76, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22,
  0x82, 0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x73, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C,
  0x01, 0x77, 0x20, 0xBC, 0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x71, 0x09, 0xC0, 0xB0, 0x17,
  0x72, 0x01, 0x0B, 0xC0, 0x97, 0x60, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x75, 0x0C, 0xB0, 0xD0,
  0x17, 0x76, 0x01, 0x0D, 0xB0, 0xC7, 0x40, 0x5C, 0x03, 0x77, 0x71, 0x03, 0xC0, 0x57, 0x30, 0xBB,
  0x0A, 0x77, 0x73, 0x0A, 0xB0, 0xB7, 0x20, 0x1C, 0x02, 0x77, 0x73, 0x02, 0xC0, 0x17, 0x10, 0x5B,
  0x0C, 0x77, 0x75, 0x0C, 0xB0, 0x57, 0x10, 0x9B, 0x07, 0x77, 0x75, 0x07, 0xB0, 0x97, 0x10, 0xCB,
  0x03, 0x77, 0x75, 0x03, 0xB0, 0xC4, 0xF9, 0x02, 0x77, 0x75, 0x02, 0xFF, 0xA7, 0x77, 0x7F, 0xFA,
  0x77, 0x77, 0xFF, 0xA0, 0x27, 0x77, 0x50, 0x2F, 0x94, 0x0C, 0xB0, 0x37, 0x77, 0x50, 0x3B, 0x0C,
  0x71, 0x09, 0xB0, 0x77, 0x77, 0x50, 0x7B, 0x09, 0x71, 0x05, 0xB0, 0xC7, 0x77, 0x50, 0xCB, 0x05,
  0x71, 0x01, 0xC0, 0x27, 0x77, 0x30, 0x2C, 0x01, 0x72, 0x0B, 0xB0, 0xA7, 0x77, 0x30, 0xAB, 0x0B,
  0x73, 0x05, 0xC0, 0x37, 0x77, 0x10, 0x3C, 0x05, 0x74, 0x0C, 0xB0, 0xD0, 0x17, 0x76, 0x01, 0x0D,
  0xB0, 0xC7, 0x50, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x76, 0x09, 0xC0, 0xB0, 0x17, 0x72, 0x01,
  0x0B, 0xC0, 0x97, 0x71, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x77, 0x20, 0x10, 0xCD,
  0x0A, 0x02, 0x73, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x73, 0x01, 0x0B, 0xE8, 0x2C, 0x74, 0x22, 0x82,
  0x24, 0x7C, 0xE0, 0xB0, 0x17, 0x76, 0x09, 0xFF, 0xE0, 0x97, 0x77, 0x20, 0x30, 0xCF, 0xFA, 0x0C,
  0x03, 0x77, 0x75, 0x05, 0x0B, 0xFD, 0x0B, 0x05, 0x77, 0x77, 0x28, 0x21, 0x58, 0xCC, 0x82, 0xC8,
  0x51, 0x80, 0xC0, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x80, 0xC4, 0x0C, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_location_searching() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_location_searching_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_lte_mobiledata 48x48, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_outlined_48_device_lte_mobiledata_data[] PROGMEM = {
  0xC6, 0xFD, 0x2F, 0xF6, 0xFD, 0x2F, 0xF6, 0xFD, 0x2F, 0xF6, 0xFD, 0x2F, 0xF7, 0x3C, 0x6C, 0x6C,
  0x73, 0xC6, 0xC6, 0xC7, 0x3C, 0x6F, 0xF7, 0x3C, 0x6F, 0xF7, 0x3C, 0x6F, 0xF7, 0x3C, 0x6F, 0xF7,
  0x3C, 0x6C, 0x6C, 0x73, 0xC6, 0xC6, 0xFB, 0x4C, 0x6F, 0xFE, 0x4C, 0x6F, 0xFE, 0x4C, 0x6F, 0xFE,
  0x4C, 0x6F, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_lte_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 16, 41, 31), Box(0, 0, 47, 47),
      ic_outlined_48_device_lte_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_lte_plus_mobiledata 48x48, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_48_device_lte_plus_mobiledata_data[] PROGMEM = {
  0xC4, 0xFD, 0x2F, 0xB7, 0x7C, 0x4F, 0xD2, 0xFB, 0x77, 0xC4, 0xFD, 0x2F, 0xB6, 0xC4, 0xC4, 0xFD,
  0x2F, 0xB6, 0xC4, 0xC7, 0x1C, 0x6C, 0x75, 0xC4, 0xC7, 0x1C, 0x6C, 0x75, 0xC4, 0xC7, 0x1C, 0x6F,
  0xB2, 0xFF, 0xA7, 0x1C, 0x6F, 0xB2, 0xFF, 0xA7, 0x1C, 0x6F, 0xB2, 0xFF, 0xA7, 0x1C, 0x6F, 0xB2,
  0xFF, 0xA7, 0x1C, 0x6C, 0x75, 0xC4, 0xC7, 0x1C, 0x6C, 0x75, 0xC4, 0xFB, 0x2C, 0x6F, 0xB6, 0xC4,
  0xFB, 0x2C, 0x6F, 0xB6, 0xC4, 0xFB, 0x2C, 0x6F, 0xB7, 0x7F, 0xB2, 0xC6, 0xFB, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_lte_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 16, 47, 31), Box(0, 0, 47, 47),
      ic_outlined_48_device_lte_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_macro_off 48x48, 4-bit Alpha,  RLE, 460 bytes.
static const unsigned char ic_outlined_48_device_macro_off_data[] PROGMEM = {
  0x77, 0x48, 0x46, 0xBE, 0xEB, 0x67, 0x77, 0x74, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x77, 0x71, 0x01,
  0x0D, 0xF9, 0x0D, 0x77, 0x20, 0x27, 0x40, 0x10, 0x9F, 0xB0, 0x80, 0x17, 0x68, 0x14, 0xF7, 0x70,
  0x60, 0xDE, 0x82, 0x91, 0x19, 0xE0, 0xC0, 0x67, 0x20, 0x4B, 0x07, 0x50, 0x8F, 0x0D, 0x40, 0xDF,
  0x0B, 0x01, 0x70, 0xEC, 0x07, 0x50, 0xCE, 0x0B, 0x40, 0xBF, 0x90, 0xB7, 0x03, 0x0E, 0xC0, 0x75,
  0x81, 0xCF, 0xDB, 0x0D, 0x40, 0xDB, 0x0D, 0xD0, 0x57, 0x03, 0x0E, 0xC0, 0x75, 0x82, 0x10, 0x3D,
  0xA8, 0x2B, 0xEE, 0xBA, 0x83, 0xC3, 0x01, 0xBB, 0x0A, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x01, 0x0E,
  0xE0, 0xE0, 0x13, 0x02, 0xB0, 0xD7, 0x20, 0x30, 0xEC, 0x07, 0x60, 0xCF, 0x90, 0xB3, 0x01, 0xB0,
  0xE7, 0x30, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xA0, 0x52, 0x08, 0xB0, 0xB7, 0x40, 0x30, 0xEC, 0x07,
  0x58, 0x4C, 0xFB, 0x11, 0xBB, 0x81, 0xB3, 0xBC, 0x07, 0x75, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0x01,
  0x20, 0x1F, 0xA0, 0xD7, 0x70, 0x30, 0xEC, 0x07, 0x71, 0x01, 0xFA, 0x0D, 0x77, 0x10, 0x7D, 0x07,
  0x60, 0x10, 0xBB, 0x81, 0xB3, 0xBC, 0x06, 0x77, 0x0C, 0xE0, 0x74, 0x01, 0x0C, 0xC0, 0x62, 0x08,
  0xB0, 0xB7, 0x70, 0xEF, 0x07, 0x40, 0x10, 0xCA, 0x0C, 0x30, 0x1B, 0x0E, 0x77, 0x0E, 0xF9, 0x07,
  0x48, 0x21, 0xCE, 0x13, 0x02, 0xB0, 0xD7, 0x70, 0xBF, 0xA0, 0x74, 0x85, 0x1C, 0xD3, 0x01, 0xBB,
  0x0A, 0x77, 0x05, 0xFB, 0x07, 0x48, 0x21, 0xCF, 0xDD, 0x05, 0x77, 0x10, 0xBF, 0xB0, 0x74, 0x01,
  0x0C, 0xD0, 0xB7, 0x72, 0x01, 0x0C, 0xFB, 0x07, 0x40, 0x10, 0xCB, 0x0B, 0x01, 0x77, 0x40, 0x60,
  0xDF, 0xA0, 0x74, 0x82, 0x1C, 0xC6, 0x75, 0x84, 0xDD, 0xB9, 0x51, 0x50, 0x10, 0x9F, 0x07, 0x72,
  0x83, 0x16, 0x9C, 0xD9, 0x40, 0xDD, 0x0B, 0x04, 0x40, 0x10, 0xDF, 0x07, 0x60, 0x40, 0xBD, 0x0E,
  0x40, 0xBF, 0x0B, 0x03, 0x30, 0x10, 0xDF, 0x07, 0x50, 0xCE, 0x0C, 0x40, 0x9F, 0xA0, 0x84, 0x81,
  0x6B, 0xED, 0x07, 0x50, 0xCD, 0x09, 0x40, 0x5F, 0xB0, 0xB0, 0x15, 0x03, 0x0E, 0xC0, 0x75, 0x0C,
  0xC0, 0x64, 0x01, 0xC0, 0x50, 0xAD, 0x0C, 0x01, 0x50, 0x30, 0xEC, 0x07, 0x50, 0xCB, 0x01, 0x50,
  0xBB, 0x82, 0xA0, 0x3D, 0xC0, 0xB6, 0x03, 0x0E, 0xC0, 0x75, 0x81, 0xCF, 0xB6, 0x04, 0xC8, 0x23,
  0x01, 0xBC, 0x08, 0x60, 0x9D, 0x07, 0x50, 0xC0, 0x57, 0x0B, 0xB0, 0xD0, 0x12, 0x0B, 0xC0, 0x34,
  0x03, 0xF0, 0x77, 0x60, 0x3C, 0x0B, 0x20, 0x10, 0xDB, 0x0B, 0x40, 0xCF, 0x90, 0x77, 0x60, 0x8C,
  0x82, 0xB1, 0x03, 0xC0, 0x42, 0x04, 0xC0, 0x60, 0xEC, 0x07, 0x76, 0x0B, 0xC8, 0x2D, 0x30, 0xAB,
  0x0B, 0x20, 0xBB, 0x81, 0x90, 0x6D, 0x07, 0x75, 0x01, 0x0C, 0xD0, 0xA0, 0x5C, 0x00, 0x1C, 0x05,
  0x09, 0xF0, 0x77, 0x50, 0x10, 0xBF, 0xB0, 0x05, 0xFF, 0x07, 0x76, 0x08, 0xFA, 0x00, 0x9F, 0xA0,
  0x90, 0xEC, 0x07, 0x76, 0x03, 0x0B, 0xF0, 0xB0, 0xCF, 0x83, 0xC3, 0x03, 0xEC, 0x07, 0x77, 0x04,
  0x0B, 0xD0, 0x0D, 0xD0, 0xB0, 0x44, 0x03, 0x0E, 0xC0, 0x27, 0x71, 0x89, 0x21, 0x59, 0xBD, 0xDE,
  0xDC, 0x95, 0x17, 0x03, 0x0E, 0xA0, 0x48, 0x0C, 0x00, 0x81, 0x3E, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_macro_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_macro_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_media_bluetooth_off 48x48, 4-bit Alpha,  RLE, 333 bytes.
static const unsigned char ic_outlined_48_device_media_bluetooth_off_data[] PROGMEM = {
  0x20, 0x28, 0x0C, 0x30, 0x81, 0x4F, 0x77, 0x4F, 0xD7, 0x70, 0x4B, 0x07, 0x73, 0xFD, 0x77, 0x0E,
  0xC0, 0x77, 0x2F, 0xD7, 0x70, 0x30, 0xEC, 0x07, 0x71, 0xFD, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x7F,
  0xD7, 0x72, 0x03, 0x0E, 0xC0, 0x76, 0xFD, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xC7, 0x74,
  0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFB, 0x77, 0x50, 0x30, 0xEC, 0x07, 0x50, 0xC9, 0x77, 0x77, 0x03,
  0x0E, 0xC0, 0x75, 0x0C, 0x77, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x30, 0xEC, 0x07,
  0x77, 0x77, 0x70, 0x30, 0xEC, 0x07, 0x77, 0x39, 0x09, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x2A,
  0x09, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x1B, 0x09, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x71, 0x02,
  0x5C, 0x09, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x68, 0x17, 0xF5, 0x4A, 0x0E, 0xA0, 0x97, 0x72, 0x03,
  0xD0, 0x75, 0x0C, 0xA0, 0x53, 0xA0, 0x50, 0xBA, 0x09, 0x77, 0x2E, 0x07, 0x50, 0xCA, 0x05, 0x2A,
  0x81, 0x50, 0xBA, 0x09, 0x77, 0x1F, 0x07, 0x50, 0xCA, 0x05, 0x1A, 0x81, 0x52, 0xDA, 0x05, 0x78,
  0x62, 0x8C, 0xEE, 0xC8, 0x2F, 0x90, 0x75, 0x0C, 0xA0, 0x6A, 0x07, 0x0D, 0xA0, 0x57, 0x08, 0xFD,
  0x0E, 0xC0, 0x75, 0x0C, 0xF0, 0x57, 0x0B, 0xFE, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xD0, 0x57, 0x08,
  0xFF, 0x10, 0x30, 0xEC, 0x07, 0x50, 0xCB, 0x05, 0x70, 0x2F, 0xF9, 0x20, 0x30, 0xEC, 0x07, 0x50,
  0xCA, 0x05, 0x70, 0x8F, 0xF9, 0x30, 0x30, 0xEC, 0x07, 0x50, 0xCA, 0x05, 0x60, 0xCF, 0xF9, 0x40,
  0x30, 0xEC, 0x07, 0x50, 0xCA, 0x05, 0x50, 0xEF, 0xF9, 0x50, 0x30, 0xEC, 0x07, 0x50, 0xCA, 0x05,
  0x40, 0xEF, 0xF0, 0xE6, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xA0, 0x53, 0x0C, 0xFF, 0x0C, 0x70, 0x5D,
  0x07, 0x58, 0x1C, 0xF9, 0x30, 0x8F, 0xF0, 0x86, 0x01, 0x0D, 0xE0, 0x75, 0x07, 0x40, 0x2F, 0xF0,
  0x27, 0x82, 0x7F, 0x7E, 0xC0, 0x77, 0x30, 0x8F, 0xD0, 0x97, 0x28, 0x22, 0x03, 0xEC, 0x07, 0x73,
  0x0B, 0xFB, 0x0B, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x30, 0x8F, 0x90, 0x97, 0x71, 0x03, 0x0E, 0xC0,
  0x77, 0x38, 0x62, 0x8C, 0xEE, 0xD8, 0x27, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E,
  0xC0, 0x27, 0x77, 0x77, 0x03, 0x0E, 0xA0, 0x48, 0x0C, 0x10, 0x81, 0x3E, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_media_bluetooth_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 43, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_media_bluetooth_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_media_bluetooth_on 48x48, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_outlined_48_device_media_bluetooth_on_data[] PROGMEM = {
  0x75, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73,
  0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xFD, 0x77, 0x73, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7,
  0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x59, 0x09, 0x77, 0x4C, 0x75, 0xA0, 0x97, 0x73, 0xC7, 0x5B,
  0x09, 0x77, 0x2C, 0x60, 0x25, 0xC0, 0x97, 0x71, 0xC5, 0x81, 0x7F, 0x54, 0xA0, 0xEA, 0x09, 0x77,
  0xC4, 0x01, 0x0D, 0xA0, 0x53, 0xA0, 0x50, 0xBA, 0x09, 0x76, 0xC5, 0x02, 0x0D, 0xA0, 0x52, 0xA8,
  0x15, 0x0B, 0xA0, 0x97, 0x5C, 0x60, 0x20, 0xDA, 0x05, 0x1A, 0x81, 0x52, 0xDA, 0x05, 0x48, 0x62,
  0x8C, 0xEE, 0xC8, 0x1C, 0x70, 0x20, 0xDA, 0x06, 0xA0, 0x70, 0xDA, 0x05, 0x40, 0x8F, 0xD7, 0x10,
  0x20, 0xDF, 0x05, 0x40, 0xBF, 0xE7, 0x20, 0x20, 0xDD, 0x05, 0x40, 0x8F, 0xF7, 0x30, 0x20, 0xDB,
  0x05, 0x40, 0x2F, 0xF9, 0x73, 0x02, 0x0D, 0xB0, 0x54, 0x08, 0xFF, 0x97, 0x20, 0x20, 0xDD, 0x05,
  0x30, 0xCF, 0xF9, 0x71, 0x02, 0x0D, 0xF0, 0x52, 0x0E, 0xFF, 0x97, 0x02, 0x0D, 0xA0, 0x6A, 0x07,
  0x0D, 0xA8, 0x15, 0x0E, 0xFF, 0x0E, 0x60, 0x20, 0xDA, 0x05, 0x1A, 0x81, 0x52, 0xDA, 0x05, 0x0C,
  0xFF, 0x0C, 0x50, 0x20, 0xDA, 0x05, 0x2A, 0x81, 0x50, 0xBA, 0x09, 0x08, 0xFF, 0x08, 0x50, 0xDA,
  0x05, 0x3A, 0x05, 0x0B, 0xA8, 0x19, 0x02, 0xFF, 0x02, 0x58, 0x16, 0xF5, 0x4A, 0x0E, 0xA0, 0x93,
  0x08, 0xFD, 0x09, 0x70, 0x25, 0xC0, 0x95, 0x0B, 0xFB, 0x0B, 0x77, 0xB0, 0x97, 0x08, 0xF9, 0x09,
  0x77, 0x1A, 0x09, 0x72, 0x86, 0x28, 0xCE, 0xED, 0x82, 0x77, 0x29, 0x0A, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_media_bluetooth_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_media_bluetooth_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_medication_liquid 48x48, 4-bit Alpha,  RLE, 165 bytes.
static const unsigned char ic_outlined_48_device_medication_liquid_data[] PROGMEM = {
  0x2F, 0xFF, 0xB7, 0x74, 0xFF, 0xFB, 0x77, 0x4F, 0xFF, 0xB7, 0x74, 0xFF, 0xFB, 0x80, 0x9C, 0x00,
  0xFF, 0xFF, 0x58, 0x44, 0xBE, 0xEB, 0x43, 0xFF, 0xFF, 0x40, 0x7E, 0x07, 0x2F, 0xFF, 0xF3, 0x05,
  0xF9, 0x05, 0x1F, 0xFF, 0xF3, 0x0E, 0xF9, 0x0E, 0x1F, 0xFF, 0xF2, 0x06, 0xFB, 0x06, 0xFF, 0xFF,
  0x20, 0xAF, 0xB0, 0xAF, 0xFF, 0xF2, 0x0D, 0xFB, 0x0D, 0xFC, 0x6F, 0xC2, 0x0E, 0xFB, 0x0E, 0xFC,
  0x6F, 0xC2, 0x0E, 0xFB, 0x0E, 0xFC, 0x6F, 0xC2, 0x0C, 0xFB, 0x0C, 0xFC, 0x6F, 0xC2, 0x0A, 0xFB,
  0x0A, 0xFC, 0x6F, 0xC2, 0x05, 0xFB, 0x05, 0xE7, 0x72, 0xE3, 0x0D, 0xF9, 0x0D, 0x1E, 0x77, 0x2E,
  0x30, 0x4F, 0x90, 0x41, 0xE7, 0x72, 0xE4, 0x06, 0xE0, 0x62, 0xE7, 0x72, 0xE5, 0x03, 0xC0, 0x33,
  0xE7, 0x72, 0xE6, 0xC4, 0xE7, 0x72, 0xE6, 0xC4, 0xFC, 0x6F, 0xC6, 0xC4, 0xFC, 0x6F, 0xC6, 0xC4,
  0xFC, 0x6F, 0xC6, 0xC4, 0xFC, 0x6F, 0xC6, 0xC4, 0xFC, 0x6F, 0xC6, 0xC4, 0xFF, 0xFF, 0x6C, 0x4F,
  0xFF, 0xF6, 0xC4, 0xFF, 0xFF, 0x6C, 0x4F, 0xFF, 0xF6, 0xC4, 0xFF, 0xFF, 0x6C, 0x4F, 0xFF, 0xF6,
  0xC4, 0xFF, 0xFF, 0x6C, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_medication_liquid() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_medication_liquid_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_medication 48x48, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_outlined_48_device_medication_data[] PROGMEM = {
  0x2F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF, 0xFB, 0x80, 0xE7, 0x08, 0x11, 0xAD, 0xFF,
  0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A, 0x0D, 0xFF, 0xFD, 0x0D,
  0xC7, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x7E, 0x7F, 0x97, 0xE7, 0xF9, 0x7E, 0x7F, 0x97,
  0xE7, 0xF9, 0x7E, 0x7F, 0x92, 0xFF, 0xA2, 0xF9, 0x2F, 0xFA, 0x2F, 0x92, 0xFF, 0xA2, 0xF9, 0x2F,
  0xFA, 0x2F, 0x92, 0xFF, 0xA2, 0xF9, 0x2F, 0xFA, 0x2F, 0x97, 0xE7, 0xF9, 0x7E, 0x7F, 0x97, 0xE7,
  0xF9, 0x7E, 0x7F, 0x97, 0xE7, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6C, 0x0D, 0xFF, 0xFD,
  0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81, 0xDA,
  0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_medication() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_medication_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_mobiledata_off 48x48, 4-bit Alpha,  RLE, 316 bytes.
static const unsigned char ic_outlined_48_device_mobiledata_off_data[] PROGMEM = {
  0x20, 0x28, 0x0C, 0x20, 0x81, 0x4F, 0x77, 0x77, 0x10, 0x07, 0x75, 0x04, 0xB0, 0x77, 0x76, 0x07,
  0xA0, 0x77, 0x40, 0xEC, 0x07, 0x77, 0x40, 0x7C, 0x07, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0x07,
  0xE0, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x07, 0xF9, 0x07, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x50,
  0x7F, 0xB0, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x73, 0x07, 0xFD, 0x07, 0x73, 0x03, 0x0E, 0xC0, 0x77,
  0x10, 0x7C, 0x0E, 0xC0, 0xEC, 0x07, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x07, 0xB0, 0xE0, 0x3C, 0x03,
  0x0E, 0xB0, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x78, 0x27, 0xFE, 0x31, 0xC1, 0x82, 0x3E, 0xF7, 0x76,
  0x03, 0x0E, 0xC0, 0x77, 0x07, 0x03, 0x2C, 0x20, 0x30, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x3C,
  0x77, 0x60, 0x30, 0xEC, 0x07, 0x72, 0xC7, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x1C, 0x77, 0x71, 0x03,
  0x0E, 0xC0, 0x77, 0xC7, 0x77, 0x20, 0x3D, 0x07, 0x6C, 0x77, 0x73, 0xE0, 0x75, 0x0C, 0xB7, 0x77,
  0x3F, 0x07, 0x50, 0xCA, 0x77, 0x73, 0xF9, 0x07, 0x50, 0xC9, 0x77, 0x73, 0xC0, 0xEC, 0x07, 0x50,
  0xC7, 0x77, 0x3C, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x71, 0xC1, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x7C,
  0x20, 0x30, 0xEC, 0x07, 0x77, 0x76, 0xC3, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x5C, 0x40, 0x30, 0xEC,
  0x07, 0x77, 0x70, 0x70, 0x32, 0xC2, 0x83, 0x37, 0x03, 0xEC, 0x07, 0x77, 0x58, 0x27, 0xFE, 0x31,
  0xC1, 0x85, 0x3E, 0xF7, 0x03, 0xEC, 0x07, 0x77, 0x30, 0x7B, 0x0E, 0x03, 0xC0, 0x30, 0xEB, 0x82,
  0x70, 0x3E, 0xC0, 0x77, 0x72, 0x07, 0xC0, 0xEC, 0x0E, 0xC0, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x72,
  0x07, 0xFD, 0x07, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x20, 0x7F, 0xB0, 0x76, 0x03, 0x0E, 0xC0, 0x77,
  0x72, 0x07, 0xF9, 0x07, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xE0, 0x77, 0x30, 0x30, 0xEC,
  0x07, 0x77, 0x20, 0x7C, 0x07, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x70, 0x30,
  0xEC, 0x07, 0x77, 0x20, 0x07, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x60, 0x30, 0xEC, 0x02,
  0x77, 0x77, 0x60, 0x30, 0xEA, 0x04, 0x80, 0xC0, 0x08, 0x13, 0xE4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_mobiledata_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_mobiledata_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_mobile_friendly 48x48, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_outlined_48_device_mobile_friendly_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x10,
  0xAF, 0xFF, 0xD0, 0xA7, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x1F, 0xFF, 0xF7, 0x1F, 0xFF, 0xF7, 0x1C,
  0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x77, 0x74, 0xC7,
  0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x75, 0x08, 0x04, 0x74, 0xC7, 0x74, 0x08, 0xA0, 0x47, 0x3C,
  0x77, 0x30, 0x8C, 0x02, 0x72, 0xC7, 0x72, 0x08, 0xC0, 0x77, 0x3C, 0x77, 0x10, 0x8C, 0x07, 0x74,
  0xC7, 0x70, 0x8C, 0x07, 0x75, 0xC7, 0x60, 0x8C, 0x07, 0x76, 0xC2, 0x0B, 0x08, 0x71, 0x08, 0xC0,
  0x77, 0x7C, 0x10, 0xBA, 0x08, 0x60, 0x8C, 0x07, 0x77, 0x1C, 0x05, 0xC0, 0x84, 0x08, 0xC0, 0x77,
  0x72, 0xC1, 0x07, 0xC0, 0x82, 0x08, 0xC0, 0x77, 0x73, 0xC2, 0x07, 0xC0, 0x08, 0xC0, 0x77, 0x74,
  0xC3, 0x07, 0xF9, 0x07, 0x77, 0x5C, 0x40, 0x7E, 0x07, 0x77, 0x6C, 0x50, 0x7C, 0x07, 0x77, 0x7C,
  0x60, 0x7A, 0x07, 0x77, 0x71, 0xC7, 0x00, 0x77, 0x77, 0x2C, 0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C,
  0x77, 0x77, 0x4C, 0x77, 0x77, 0x4C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76,
  0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x71,
  0x0A, 0xFF, 0xFD, 0x0A, 0x71, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF, 0xFE,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_mobile_friendly() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_mobile_friendly_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_mobile_off 48x48, 4-bit Alpha,  RLE, 293 bytes.
static const unsigned char ic_outlined_48_device_mobile_off_data[] PROGMEM = {
  0x71, 0x81, 0x2A, 0xEF, 0xFE, 0x81, 0xDA, 0x17, 0x70, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x10,
  0x15, 0x0A, 0xFF, 0xFC, 0x0A, 0x78, 0x11, 0xD9, 0x50, 0xAF, 0xFF, 0xB0, 0xD6, 0x01, 0x0D, 0xA0,
  0x95, 0x0A, 0xFF, 0xFB, 0x60, 0xBC, 0x09, 0x50, 0xAF, 0xFF, 0xA6, 0x02, 0x0D, 0xC0, 0x95, 0x0A,
  0xFF, 0xF9, 0x70, 0x20, 0xDC, 0x09, 0x50, 0xAF, 0xFF, 0x71, 0x02, 0x0D, 0xC0, 0x97, 0x77, 0x1C,
  0x72, 0x02, 0x0D, 0xC0, 0x97, 0x77, 0xC7, 0x30, 0x20, 0xDC, 0x09, 0x77, 0x6C, 0x74, 0x02, 0x0D,
  0xC0, 0x97, 0x75, 0xC7, 0x50, 0x2D, 0x09, 0x77, 0x4C, 0x76, 0xE0, 0x97, 0x73, 0xC7, 0x6F, 0x09,
  0x77, 0x2C, 0x76, 0xF9, 0x09, 0x77, 0x1C, 0x76, 0xC0, 0xDC, 0x09, 0x77, 0xC7, 0x6C, 0x02, 0x0D,
  0xC0, 0x97, 0x6C, 0x76, 0xC1, 0x02, 0x0D, 0xC0, 0x97, 0x5C, 0x76, 0xC2, 0x02, 0x0D, 0xC0, 0x97,
  0x4C, 0x76, 0xC3, 0x02, 0x0D, 0xC0, 0x97, 0x3C, 0x76, 0xC4, 0x02, 0x0D, 0xC0, 0x97, 0x2C, 0x76,
  0xC5, 0x02, 0x0D, 0xC0, 0x97, 0x1C, 0x76, 0xC6, 0x02, 0x0D, 0xC0, 0x97, 0xC7, 0x6C, 0x70, 0x20,
  0xDC, 0x09, 0x6C, 0x76, 0xC7, 0x10, 0x20, 0xDC, 0x09, 0x50, 0xAB, 0x76, 0xC7, 0x20, 0x20, 0xDC,
  0x09, 0x50, 0xAA, 0x76, 0xC7, 0x30, 0x20, 0xDC, 0x09, 0x50, 0xA9, 0x76, 0xC7, 0x40, 0x20, 0xDC,
  0x09, 0x50, 0xA7, 0x6C, 0x75, 0x02, 0x0D, 0xC0, 0x97, 0x74, 0xC7, 0x60, 0x20, 0xDC, 0x09, 0x77,
  0x3C, 0x77, 0x02, 0x0D, 0xC0, 0x97, 0x72, 0xC7, 0x71, 0x02, 0x0D, 0xC0, 0x97, 0x71, 0xC7, 0x72,
  0x02, 0x0D, 0xC0, 0x97, 0x7C, 0x77, 0x30, 0x20, 0xDC, 0x09, 0x76, 0xC7, 0x74, 0x02, 0x0D, 0xC0,
  0x97, 0x5F, 0xFF, 0xF9, 0x09, 0x74, 0xFF, 0xFF, 0xA0, 0x97, 0x3F, 0xFF, 0xFB, 0x09, 0x72, 0xFF,
  0xFF, 0xC0, 0x97, 0x10, 0xDF, 0xFF, 0xD0, 0xE0, 0xDC, 0x09, 0x70, 0xAF, 0xFF, 0xD8, 0x19, 0x2D,
  0xB0, 0xC7, 0x01, 0x0E, 0xFF, 0xFB, 0x85, 0xE1, 0x02, 0xDF, 0xC7, 0x28, 0x11, 0xAD, 0xFF, 0xE8,
  0x1E, 0x91, 0x30, 0x20, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_mobile_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_mobile_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_mode_night 48x48, 4-bit Alpha,  RLE, 293 bytes.
static const unsigned char ic_outlined_48_device_mode_night_data[] PROGMEM = {
  0x48, 0x33, 0x6A, 0xDD, 0xA8, 0x3D, 0xCA, 0x73, 0x77, 0x18, 0x11, 0x7D, 0xFD, 0x81, 0xD8, 0x17,
  0x40, 0x70, 0xEF, 0xFB, 0x09, 0x01, 0x72, 0x01, 0x0A, 0xFF, 0xC0, 0xE0, 0x57, 0x30, 0x6D, 0x06,
  0x28, 0x22, 0x36, 0xBF, 0x09, 0x73, 0x05, 0x0E, 0xB0, 0xE0, 0x26, 0x06, 0x0E, 0xD0, 0xA7, 0x30,
  0x5C, 0x0C, 0x71, 0x07, 0xD0, 0xA7, 0x30, 0x6C, 0x06, 0x71, 0x03, 0x0E, 0xC0, 0x97, 0x30, 0xAB,
  0x0E, 0x01, 0x71, 0x01, 0x0C, 0xC0, 0x57, 0x20, 0x10, 0xEB, 0x08, 0x72, 0x01, 0x0E, 0xB0, 0xE0,
  0x17, 0x20, 0x6B, 0x0E, 0x73, 0x03, 0xC0, 0x97, 0x30, 0xDB, 0x06, 0x73, 0x07, 0xC0, 0x17, 0x20,
  0x7B, 0x0B, 0x74, 0x0E, 0xB0, 0x87, 0x20, 0x2C, 0x01, 0x73, 0x06, 0xB0, 0xD7, 0x30, 0xCB, 0x05,
  0x74, 0xC0, 0x37, 0x20, 0x8B, 0x08, 0x74, 0x0B, 0xB0, 0x77, 0x20, 0x5B, 0x0A, 0x74, 0x06, 0xB0,
  0xA7, 0x20, 0x2B, 0x0B, 0x74, 0x03, 0xB0, 0xC7, 0x20, 0x1B, 0x0D, 0x74, 0x02, 0xB0, 0xE7, 0x3B,
  0x0E, 0x75, 0xC7, 0x3C, 0x75, 0xC7, 0x20, 0x1B, 0x0E, 0x74, 0x02, 0xB0, 0xE7, 0x20, 0x2B, 0x0D,
  0x74, 0x03, 0xB0, 0xC7, 0x20, 0x5B, 0x0B, 0x74, 0x06, 0xB0, 0xA7, 0x20, 0x8B, 0x08, 0x74, 0x0B,
  0xB0, 0x77, 0x20, 0xCB, 0x05, 0x74, 0xC0, 0x37, 0x10, 0x2C, 0x01, 0x73, 0x06, 0xB0, 0xD7, 0x20,
  0x7B, 0x0B, 0x74, 0x0E, 0xB0, 0x87, 0x20, 0xDB, 0x06, 0x73, 0x07, 0xC0, 0x17, 0x10, 0x6B, 0x0E,
  0x73, 0x03, 0xC0, 0x97, 0x10, 0x10, 0xEB, 0x08, 0x72, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x10, 0xAB,
  0x0E, 0x01, 0x71, 0x01, 0x0C, 0xC0, 0x57, 0x10, 0x6C, 0x06, 0x71, 0x03, 0x0E, 0xC0, 0x97, 0x10,
  0x5C, 0x0C, 0x71, 0x07, 0xD0, 0xA7, 0x10, 0x50, 0xEB, 0x0E, 0x02, 0x60, 0x60, 0xED, 0x0A, 0x71,
  0x06, 0xD0, 0x62, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x01, 0x0A, 0xFF, 0xC0, 0xE0, 0x57, 0x10, 0x70,
  0xEF, 0xFB, 0x09, 0x01, 0x73, 0x81, 0x17, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x18, 0x33, 0x6A, 0xDD,
  0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_mode_night() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 38, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_mode_night_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_mode_standby 48x48, 4-bit Alpha,  RLE, 350 bytes.
static const unsigned char ic_outlined_48_device_mode_standby_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x08, 0xFF, 0xC0, 0x80, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x08, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x87, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x08, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x87, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x8C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x83,
  0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x77, 0x77, 0x0E, 0xB0, 0x82, 0x0D,
  0xB0, 0x67, 0x77, 0x70, 0x6B, 0x81, 0xD0, 0x3C, 0x75, 0x84, 0x6C, 0xEE, 0xC6, 0x75, 0xC0, 0x30,
  0x7B, 0x0B, 0x73, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x30, 0xBB, 0x07, 0x0A, 0xB0, 0x67, 0x30, 0xCF,
  0x90, 0xC7, 0x30, 0x6B, 0x0A, 0x0C, 0xB0, 0x37, 0x20, 0x6F, 0xB0, 0x67, 0x20, 0x3B, 0x0C, 0x0E,
  0xB0, 0x27, 0x20, 0xCF, 0xB0, 0xC7, 0x20, 0x2B, 0x0E, 0xC7, 0x30, 0xEF, 0xB0, 0xE7, 0x3F, 0x97,
  0x30, 0xEF, 0xB0, 0xE7, 0x3C, 0x0E, 0xB0, 0x27, 0x20, 0xCF, 0xB0, 0xC7, 0x20, 0x2B, 0x0E, 0x0C,
  0xB0, 0x37, 0x20, 0x6F, 0xB0, 0x67, 0x20, 0x3B, 0x0C, 0x0A, 0xB0, 0x67, 0x30, 0xCF, 0x90, 0xC7,
  0x30, 0x6B, 0x0A, 0x07, 0xB0, 0xB7, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x73, 0x0B, 0xB0, 0x70, 0x3C,
  0x75, 0x84, 0x6C, 0xEE, 0xC6, 0x75, 0xC8, 0x13, 0x0D, 0xB0, 0x67, 0x77, 0x70, 0x6B, 0x0D, 0x20,
  0x8B, 0x0E, 0x77, 0x77, 0x0E, 0xB0, 0x82, 0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x30, 0x8C,
  0x03, 0x77, 0x73, 0x03, 0xC0, 0x84, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E,
  0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xCC, 0x05, 0x70, 0x8C, 0x0E, 0x03, 0x77, 0x40,
  0x30, 0xEC, 0x08, 0x72, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0E, 0x06, 0x75,
  0x06, 0x0E, 0xD0, 0xA7, 0x60, 0x8F, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x08, 0x77, 0x10,
  0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x8F, 0xFC, 0x08, 0x01, 0x77, 0x68, 0x11, 0x8D,
  0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_mode_standby() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_mode_standby_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_monitor_heart 48x48, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_outlined_48_device_monitor_heart_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x48,
  0x24, 0xCC, 0x37, 0x3F, 0x97, 0x73, 0x01, 0x0E, 0xA0, 0xE7, 0x3F, 0x97, 0x73, 0x07, 0xC0, 0x77,
  0x2F, 0x97, 0x73, 0x0E, 0xC0, 0xE7, 0x2C, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x77, 0x40, 0xEE, 0x0E,
  0x77, 0x77, 0x30, 0x7B, 0x00, 0xEB, 0x07, 0x77, 0x77, 0x20, 0xEB, 0x00, 0x7B, 0x0E, 0x74, 0xFD,
  0x0D, 0x04, 0x40, 0x7B, 0x0E, 0x20, 0xEF, 0xFF, 0xE0, 0xE4, 0x0E, 0xB0, 0x72, 0x07, 0xFF, 0xFF,
  0x07, 0x20, 0x7B, 0x0E, 0x40, 0xEF, 0xFF, 0xE0, 0xE2, 0x0E, 0xB0, 0x74, 0x04, 0x0D, 0xFD, 0x74,
  0x0E, 0xB0, 0x07, 0xB0, 0xE7, 0x77, 0x72, 0x07, 0xB0, 0x0E, 0xB0, 0x77, 0x77, 0x73, 0x0E, 0xE0,
  0xE7, 0x77, 0x74, 0x07, 0xE0, 0x77, 0x76, 0xC7, 0x20, 0xEC, 0x0E, 0x77, 0x3F, 0x97, 0x20, 0x7C,
  0x07, 0x77, 0x3F, 0x97, 0x20, 0x10, 0xEA, 0x0E, 0x77, 0x4F, 0x97, 0x38, 0x24, 0xDD, 0x47, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8,
  0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_monitor_heart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_monitor_heart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_monitor_weight 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_outlined_48_device_monitor_weight_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x48, 0x46, 0xCE,
  0xEC, 0x67, 0x4F, 0x97, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x72, 0xF9, 0x72, 0x0C, 0xF9, 0x0C, 0x72,
  0xF9, 0x71, 0x06, 0xFB, 0x06, 0x71, 0xF9, 0x71, 0x0C, 0xFB, 0x0C, 0x71, 0xF9, 0x71, 0x0E, 0x92,
  0x92, 0x92, 0x90, 0xE7, 0x1F, 0x97, 0x10, 0xE9, 0x29, 0x29, 0x29, 0x0E, 0x71, 0xF9, 0x71, 0x0C,
  0xFB, 0x0C, 0x71, 0xF9, 0x71, 0x06, 0xFB, 0x06, 0x71, 0xF9, 0x72, 0x0C, 0xF9, 0x0C, 0x72, 0xF9,
  0x72, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x2F, 0x97, 0x48, 0x46, 0xCE, 0xEC, 0x67, 0x4F, 0x97, 0x77,
  0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F,
  0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE,
  0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_monitor_weight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_monitor_weight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_nearby_error 48x48, 4-bit Alpha,  RLE, 392 bytes.
static const unsigned char ic_outlined_48_device_nearby_error_data[] PROGMEM = {
  0x77, 0x38, 0x41, 0xAE, 0xEA, 0x17, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0xE0, 0x37, 0x77, 0x73, 0x03,
  0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x71, 0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x77, 0x76, 0x03, 0x0E, 0xFB,
  0x0E, 0x03, 0x77, 0x74, 0x03, 0x0E, 0xD0, 0x0E, 0xD0, 0xE0, 0x37, 0x77, 0x20, 0x30, 0xED, 0x82,
  0xE2, 0x2E, 0xD0, 0xE0, 0x37, 0x77, 0x03, 0x0E, 0xD0, 0xE0, 0x22, 0x02, 0x0E, 0xD0, 0xE0, 0x37,
  0x75, 0x03, 0x0E, 0xD0, 0xE0, 0x24, 0x02, 0x0E, 0xD0, 0xE0, 0x37, 0x73, 0x03, 0x0E, 0xD0, 0xE0,
  0x26, 0x02, 0x0E, 0xD0, 0xE0, 0x37, 0x71, 0x03, 0x0E, 0xD0, 0xE0, 0x27, 0x10, 0x20, 0xED, 0x0E,
  0x77, 0x03, 0x0E, 0xD0, 0xE0, 0x24, 0x00, 0x54, 0x02, 0x0E, 0xD7, 0x60, 0x30, 0xED, 0x0E, 0x02,
  0x40, 0x5A, 0x05, 0x40, 0x20, 0xEC, 0x75, 0x03, 0x0E, 0xD0, 0xE0, 0x24, 0x05, 0xC0, 0x54, 0x02,
  0x0E, 0xB7, 0x40, 0x30, 0xED, 0x0E, 0x02, 0x40, 0x5E, 0x05, 0x40, 0x20, 0xEA, 0x73, 0x03, 0x0E,
  0xD0, 0xE0, 0x24, 0x05, 0xF9, 0x05, 0x40, 0x20, 0xE9, 0x72, 0x03, 0x0E, 0xD0, 0xE0, 0x24, 0x05,
  0xFB, 0x05, 0x40, 0x20, 0xE4, 0xC0, 0x10, 0xED, 0x0E, 0x02, 0x40, 0x5F, 0xD0, 0x54, 0x02, 0x4C,
  0x0A, 0xD0, 0xE0, 0x24, 0x05, 0xFF, 0x05, 0x71, 0xC0, 0xEC, 0x0E, 0x02, 0x40, 0x5F, 0xFA, 0x05,
  0x7C, 0x0E, 0xC0, 0xE0, 0x34, 0x05, 0xFF, 0xA0, 0x57, 0xC0, 0xAD, 0x0E, 0x03, 0x40, 0x5F, 0xF0,
  0x57, 0x1C, 0x01, 0x0E, 0xD0, 0xE0, 0x34, 0x05, 0xFD, 0x05, 0x40, 0x34, 0xC1, 0x03, 0x0E, 0xD0,
  0xE0, 0x34, 0x05, 0xFB, 0x05, 0x40, 0x30, 0xE4, 0xC2, 0x03, 0x0E, 0xD0, 0xE0, 0x34, 0x05, 0xF9,
  0x05, 0x40, 0x30, 0xE9, 0x4C, 0x30, 0x30, 0xED, 0x0E, 0x03, 0x40, 0x5E, 0x05, 0x40, 0x30, 0xEA,
  0x4C, 0x40, 0x30, 0xED, 0x0E, 0x03, 0x40, 0x5C, 0x05, 0x40, 0x30, 0xEB, 0x4C, 0x50, 0x30, 0xED,
  0x0E, 0x03, 0x40, 0x5A, 0x05, 0x40, 0x30, 0xEC, 0x4C, 0x60, 0x30, 0xED, 0x0E, 0x03, 0x40, 0x05,
  0x40, 0x30, 0xED, 0x4C, 0x70, 0x30, 0xED, 0x0E, 0x03, 0x71, 0x03, 0x0E, 0xD0, 0xE4, 0xC7, 0x10,
  0x30, 0xED, 0x0E, 0x03, 0x60, 0x30, 0xED, 0x0E, 0x03, 0x4C, 0x72, 0x03, 0x0E, 0xD0, 0xE0, 0x34,
  0x03, 0x0E, 0xD0, 0xE0, 0x35, 0xC7, 0x30, 0x30, 0xED, 0x0E, 0x03, 0x20, 0x30, 0xED, 0x0E, 0x03,
  0x77, 0x70, 0x30, 0xED, 0x82, 0xE3, 0x3E, 0xD0, 0xE0, 0x37, 0x77, 0x20, 0x30, 0xED, 0x00, 0xED,
  0x0E, 0x03, 0x77, 0x74, 0x03, 0x0E, 0xFB, 0x0E, 0x03, 0x77, 0x76, 0x03, 0x0E, 0xF9, 0x0E, 0x03,
  0x73, 0xC7, 0x71, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x4C, 0x77, 0x20, 0x30, 0xEC, 0x0E, 0x03, 0x75,
  0xC7, 0x73, 0x84, 0x19, 0xDD, 0x91, 0x76, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_nearby_error() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_nearby_error_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_nearby_off 48x48, 4-bit Alpha,  RLE, 482 bytes.
static const unsigned char ic_outlined_48_device_nearby_off_data[] PROGMEM = {
  0x77, 0x48, 0x41, 0x9D, 0xD9, 0x17, 0x75, 0x02, 0x77, 0x03, 0x0E, 0xC0, 0xE0, 0x37, 0x73, 0x81,
  0x4F, 0x77, 0x50, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x10, 0x4B, 0x07, 0x73, 0x03, 0x0E, 0xF9, 0x0E,
  0x03, 0x77, 0x0E, 0xC0, 0x77, 0x10, 0x30, 0xEF, 0xB0, 0xE0, 0x37, 0x60, 0x30, 0xEC, 0x07, 0x60,
  0x30, 0xED, 0x00, 0xED, 0x0E, 0x03, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0B, 0xD8, 0x2E, 0x22, 0xED,
  0x0E, 0x03, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB0, 0xE0, 0x22, 0x02, 0x0E, 0xD0, 0xE0, 0x37,
  0x60, 0x30, 0xEC, 0x07, 0x58, 0x2C, 0xFE, 0x24, 0x02, 0x0E, 0xD0, 0xE0, 0x37, 0x60, 0x30, 0xEC,
  0x07, 0x48, 0x11, 0xB2, 0x60, 0x20, 0xED, 0x0E, 0x03, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x60, 0x20,
  0xED, 0x0E, 0x03, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x00, 0x54, 0x02, 0x0E, 0xD0, 0xE0, 0x37, 0x50,
  0x30, 0xED, 0x07, 0x50, 0x4A, 0x05, 0x40, 0x20, 0xED, 0x0E, 0x03, 0x73, 0x03, 0x0E, 0xF0, 0x74,
  0x01, 0x0C, 0xA0, 0x54, 0x02, 0x0E, 0xD0, 0xE0, 0x37, 0x10, 0x30, 0xEF, 0xA0, 0x74, 0x01, 0x0C,
  0xA0, 0x54, 0x02, 0x0E, 0xD0, 0xE0, 0x36, 0x03, 0x0E, 0xD0, 0x0E, 0xC0, 0x74, 0x01, 0x0C, 0xA0,
  0x54, 0x02, 0x0E, 0xD0, 0xE0, 0x34, 0x03, 0x0E, 0xD8, 0x2E, 0x23, 0xEC, 0x07, 0x40, 0x10, 0xCA,
  0x05, 0x40, 0x20, 0xED, 0x0E, 0x03, 0x20, 0x10, 0xED, 0x0E, 0x02, 0x20, 0x30, 0xEC, 0x07, 0x40,
  0x10, 0xCA, 0x05, 0x40, 0x20, 0xED, 0x82, 0xE1, 0x0A, 0xD0, 0xE0, 0x24, 0x07, 0xD0, 0x74, 0x01,
  0x0C, 0xA0, 0x54, 0x02, 0x0E, 0xD8, 0x1A, 0x0D, 0xC0, 0xE0, 0x24, 0x05, 0xF0, 0x74, 0x01, 0x0C,
  0xA0, 0x54, 0x02, 0x0E, 0xC8, 0x1E, 0x0D, 0xC0, 0xE0, 0x24, 0x05, 0xF9, 0x07, 0x48, 0x21, 0xCF,
  0x54, 0x02, 0x0E, 0xC8, 0x1E, 0x09, 0xD0, 0xE0, 0x24, 0x05, 0xF9, 0x07, 0x40, 0x10, 0x44, 0x02,
  0x0E, 0xD8, 0x2A, 0x01, 0xED, 0x0E, 0x02, 0x40, 0x5F, 0x90, 0x77, 0x10, 0x20, 0xED, 0x0E, 0x01,
  0x20, 0x30, 0xED, 0x0E, 0x02, 0x40, 0x5F, 0x90, 0x76, 0x02, 0x0E, 0xD0, 0xE0, 0x34, 0x03, 0x0E,
  0xD0, 0xE0, 0x24, 0x05, 0xF9, 0x07, 0x50, 0xAD, 0x0E, 0x03, 0x60, 0x30, 0xED, 0x0E, 0x02, 0x40,
  0x5F, 0x90, 0x75, 0x0C, 0xB0, 0xE0, 0x37, 0x10, 0x30, 0xED, 0x0E, 0x02, 0x40, 0x5F, 0x90, 0x75,
  0x82, 0xCF, 0xE3, 0x73, 0x03, 0x0E, 0xD0, 0xE0, 0x24, 0x05, 0xA0, 0x80, 0xEC, 0x07, 0x50, 0xB0,
  0x37, 0x50, 0x30, 0xED, 0x0E, 0x02, 0x48, 0x35, 0x50, 0x3E, 0xC0, 0x77, 0x75, 0x03, 0x0E, 0xD0,
  0xE0, 0x27, 0x03, 0x0E, 0xC0, 0x77, 0x75, 0x03, 0x0E, 0xD0, 0xE0, 0x26, 0x02, 0x0E, 0xD0, 0x77,
  0x75, 0x03, 0x0E, 0xD0, 0xE0, 0x24, 0x02, 0x0E, 0xF0, 0x77, 0x75, 0x03, 0x0E, 0xD0, 0xE0, 0x22,
  0x02, 0x0E, 0xFA, 0x07, 0x77, 0x50, 0x30, 0xED, 0x82, 0xE2, 0x2E, 0xD0, 0x0E, 0xC0, 0x77, 0x75,
  0x03, 0x0E, 0xD0, 0x0E, 0xD8, 0x2E, 0x33, 0xEC, 0x07, 0x77, 0x50, 0x30, 0xEF, 0xB0, 0xE0, 0x32,
  0x03, 0x0E, 0xC0, 0x77, 0x75, 0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x50,
  0x30, 0xEE, 0x0E, 0x03, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x50, 0x30, 0xEC, 0x0E, 0x03, 0x71, 0x03,
  0x0E, 0xC0, 0x27, 0x75, 0x84, 0x19, 0xDD, 0x91, 0x73, 0x03, 0x0E, 0xA0, 0x48, 0x0C, 0x10, 0x81,
  0x3E, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_nearby_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 43, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_nearby_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_network_cell 48x48, 4-bit Alpha,  RLE, 185 bytes.
static const unsigned char ic_outlined_48_device_network_cell_data[] PROGMEM = {
  0x80, 0xC3, 0x00, 0x78, 0x0C, 0x20, 0x07, 0x98, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x00, 0x07, 0xB7,
  0x77, 0x77, 0x07, 0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xE7, 0x77, 0x74, 0x07, 0xF7,
  0x77, 0x73, 0x07, 0xF9, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0xC7, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x3C,
  0x77, 0x77, 0x07, 0xC0, 0xE0, 0x31, 0xC7, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x2C, 0x77, 0x75, 0x07,
  0xC0, 0xE0, 0x33, 0xC7, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x4C, 0x77, 0x73, 0x07, 0xD0, 0x35, 0xC7,
  0x77, 0x20, 0x7E, 0x6C, 0x77, 0x71, 0x07, 0xF6, 0xC7, 0x77, 0x07, 0xF9, 0x6C, 0x77, 0x60, 0x7F,
  0xA6, 0xC7, 0x75, 0x07, 0xFB, 0x6C, 0x77, 0x40, 0x7F, 0xC6, 0xC7, 0x73, 0x07, 0xFD, 0x6C, 0x77,
  0x20, 0x7F, 0xE6, 0xC7, 0x71, 0x07, 0xFF, 0x6C, 0x77, 0x07, 0xFF, 0x96, 0xC7, 0x60, 0x7F, 0xFA,
  0x6C, 0x75, 0x07, 0xFF, 0xB6, 0xC7, 0x40, 0x7F, 0xFC, 0x6C, 0x73, 0x07, 0xFF, 0xD6, 0xC7, 0x20,
  0x7F, 0xFE, 0x6C, 0x71, 0x07, 0xFF, 0xF6, 0xC7, 0x07, 0xFF, 0xF9, 0x6C, 0x60, 0x7F, 0xFF, 0xA6,
  0xC5, 0x07, 0xFF, 0xFB, 0x6C, 0x40, 0x7F, 0xFF, 0xC6, 0xC3, 0x07, 0x80, 0xC0, 0xF2, 0x07, 0x80,
  0xC1, 0xF1, 0x07, 0x80, 0xC2, 0xF0, 0x78, 0x0C, 0x3F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_network_cell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_network_cell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_network_wifi_1_bar 48x48, 4-bit Alpha,  RLE, 297 bytes.
static const unsigned char ic_outlined_48_device_network_wifi_1_bar_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0x98, 0x4E, 0xB8, 0x53, 0x13, 0x85, 0x13, 0x45,
  0x8B, 0xEF, 0x90, 0xA0, 0x27, 0x40, 0x70, 0xEE, 0x81, 0xD8, 0x37, 0x72, 0x81, 0x38, 0xDE, 0x0E,
  0x07, 0x71, 0x01, 0x0C, 0xE0, 0xB0, 0x47, 0x77, 0x10, 0x40, 0xBE, 0x0C, 0x01, 0x50, 0x40, 0xED,
  0x0B, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xD0, 0xE0, 0x43, 0x06, 0xD0, 0xD0, 0x57, 0x77, 0x72, 0x05,
  0x0D, 0xD8, 0x16, 0x07, 0xD0, 0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xD0, 0x07, 0xD0, 0x37, 0x77,
  0x76, 0x03, 0xD8, 0x17, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x70, 0x30, 0xEC,
  0x07, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77,
  0x73, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x60,
  0x7C, 0x0E, 0x03, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x40, 0x30,
  0xEC, 0x07, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x50, 0x7C, 0x0E,
  0x03, 0x28, 0x23, 0x8B, 0xDA, 0x82, 0xDB, 0x83, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x70, 0x7C, 0x81,
  0xE7, 0xDF, 0xB8, 0x1D, 0x7E, 0xC0, 0x77, 0x77, 0x20, 0x7F, 0xFF, 0x90, 0x77, 0x77, 0x40, 0x7F,
  0xFE, 0x07, 0x77, 0x76, 0x07, 0xFF, 0xC0, 0x77, 0x77, 0x71, 0x07, 0xFF, 0xA0, 0x77, 0x77, 0x73,
  0x07, 0xFF, 0x07, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0x77, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x80, 0xC1,
  0x00, 0x7F, 0x90, 0x78, 0x0C, 0x30, 0x07, 0xE0, 0x78, 0x0C, 0x50, 0x07, 0xC0, 0x78, 0x0C, 0x70,
  0x07, 0xA0, 0x78, 0x0D, 0x10, 0x00, 0x77, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_network_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_network_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_network_wifi_2_bar 48x48, 4-bit Alpha,  RLE, 289 bytes.
static const unsigned char ic_outlined_48_device_network_wifi_2_bar_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0x98, 0x4E, 0xB8, 0x53, 0x13, 0x85, 0x13, 0x45,
  0x8B, 0xEF, 0x90, 0xA0, 0x27, 0x40, 0x70, 0xEE, 0x81, 0xD8, 0x37, 0x72, 0x81, 0x38, 0xDE, 0x0E,
  0x07, 0x71, 0x01, 0x0C, 0xE0, 0xB0, 0x47, 0x77, 0x10, 0x40, 0xBE, 0x0C, 0x01, 0x50, 0x40, 0xED,
  0x0B, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xD0, 0xE0, 0x43, 0x06, 0xD0, 0xE0, 0x57, 0x77, 0x72, 0x05,
  0x0D, 0xD8, 0x16, 0x07, 0xD0, 0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xD0, 0x07, 0xD0, 0x37, 0x77,
  0x76, 0x03, 0xD8, 0x17, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x70, 0x30, 0xEC,
  0x07, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77,
  0x73, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x58, 0x31, 0x69, 0xCD, 0xA8, 0x3D, 0xC9,
  0x61, 0x50, 0x30, 0xEC, 0x07, 0x76, 0x07, 0xC0, 0xE0, 0x32, 0x05, 0x0B, 0xFD, 0x0B, 0x05, 0x20,
  0x30, 0xEC, 0x07, 0x77, 0x10, 0x7C, 0x81, 0xE6, 0xCF, 0xFA, 0x81, 0xC6, 0xEC, 0x07, 0x77, 0x30,
  0x7F, 0xFF, 0xF0, 0x77, 0x75, 0x07, 0xFF, 0xFD, 0x07, 0x77, 0x70, 0x7F, 0xFF, 0xB0, 0x77, 0x77,
  0x20, 0x7F, 0xFF, 0x90, 0x77, 0x77, 0x40, 0x7F, 0xFE, 0x07, 0x77, 0x76, 0x07, 0xFF, 0xC0, 0x77,
  0x77, 0x71, 0x07, 0xFF, 0xA0, 0x77, 0x77, 0x73, 0x07, 0xFF, 0x07, 0x77, 0x77, 0x50, 0x7F, 0xD0,
  0x77, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x80, 0xC1, 0x00, 0x7F, 0x90, 0x78, 0x0C, 0x30, 0x07, 0xE0,
  0x78, 0x0C, 0x50, 0x07, 0xC0, 0x78, 0x0C, 0x70, 0x07, 0xA0, 0x78, 0x0D, 0x10, 0x00, 0x77, 0x77,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_network_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_network_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_network_wifi_3_bar 48x48, 4-bit Alpha,  RLE, 281 bytes.
static const unsigned char ic_outlined_48_device_network_wifi_3_bar_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0x98, 0x4E, 0xB8, 0x53, 0x13, 0x85, 0x13, 0x45,
  0x8B, 0xEF, 0x90, 0xA0, 0x27, 0x40, 0x70, 0xEE, 0x81, 0xD8, 0x37, 0x72, 0x81, 0x38, 0xDE, 0x0E,
  0x07, 0x71, 0x01, 0x0C, 0xE0, 0xB0, 0x47, 0x77, 0x10, 0x40, 0xBE, 0x0C, 0x01, 0x50, 0x40, 0xED,
  0x0B, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xD0, 0xE0, 0x43, 0x06, 0xD0, 0xD0, 0x57, 0x77, 0x72, 0x05,
  0x0D, 0xD8, 0x16, 0x07, 0xD0, 0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xD0, 0x07, 0xD0, 0x37, 0x77,
  0x76, 0x03, 0xD8, 0x17, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0,
  0xE0, 0x37, 0x28, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0x07,
  0xC0, 0xE0, 0x35, 0x03, 0x09, 0xFF, 0x09, 0x03, 0x50, 0x30, 0xEC, 0x07, 0x70, 0x7C, 0x0E, 0x03,
  0x20, 0x40, 0xCF, 0xFC, 0x0C, 0x04, 0x20, 0x30, 0xEC, 0x07, 0x72, 0x07, 0xC8, 0x1E, 0x5A, 0xFF,
  0xF9, 0x81, 0xA5, 0xEC, 0x07, 0x74, 0x07, 0xFF, 0xFF, 0xE0, 0x77, 0x60, 0x7F, 0xFF, 0xFC, 0x07,
  0x77, 0x10, 0x7F, 0xFF, 0xFA, 0x07, 0x77, 0x30, 0x7F, 0xFF, 0xF0, 0x77, 0x75, 0x07, 0xFF, 0xFD,
  0x07, 0x77, 0x70, 0x7F, 0xFF, 0xB0, 0x77, 0x77, 0x20, 0x7F, 0xFF, 0x90, 0x77, 0x77, 0x40, 0x7F,
  0xFE, 0x07, 0x77, 0x76, 0x07, 0xFF, 0xC0, 0x77, 0x77, 0x71, 0x07, 0xFF, 0xA0, 0x77, 0x77, 0x73,
  0x07, 0xFF, 0x07, 0x77, 0x77, 0x50, 0x7F, 0xD0, 0x77, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x80, 0xC1,
  0x00, 0x7F, 0x90, 0x78, 0x0C, 0x30, 0x07, 0xE0, 0x78, 0x0C, 0x50, 0x07, 0xC0, 0x78, 0x0C, 0x70,
  0x07, 0xA0, 0x78, 0x0D, 0x10, 0x00, 0x77, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_network_wifi_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_network_wifi_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_network_wifi 48x48, 4-bit Alpha,  RLE, 273 bytes.
static const unsigned char ic_outlined_48_device_network_wifi_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0x98, 0x4E, 0xB8, 0x53, 0x13, 0x85, 0x13, 0x45,
  0x8B, 0xEF, 0x90, 0xA0, 0x27, 0x40, 0x70, 0xEE, 0x81, 0xD8, 0x37, 0x72, 0x81, 0x38, 0xDE, 0x0E,
  0x07, 0x71, 0x01, 0x0C, 0xE0, 0xB0, 0x47, 0x77, 0x10, 0x40, 0xBE, 0x0C, 0x01, 0x50, 0x40, 0xED,
  0x0B, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xD0, 0xE0, 0x43, 0x06, 0xD0, 0xD0, 0x57, 0x18, 0x41, 0x58,
  0xBC, 0xDA, 0x84, 0xDC, 0xB8, 0x51, 0x71, 0x05, 0x0D, 0xD8, 0x16, 0x07, 0xD0, 0xA0, 0x16, 0x81,
  0x18, 0xCF, 0xF8, 0x1D, 0x81, 0x60, 0x10, 0xAD, 0x00, 0x7D, 0x03, 0x50, 0x30, 0xAF, 0xFE, 0x0A,
  0x04, 0x50, 0x3D, 0x81, 0x70, 0x7C, 0x0E, 0x03, 0x20, 0x20, 0xBF, 0xFF, 0xB0, 0xB0, 0x22, 0x03,
  0x0E, 0xC0, 0x73, 0x07, 0xC8, 0x2E, 0x37, 0xEF, 0xFF, 0xE8, 0x17, 0x4E, 0xC0, 0x75, 0x07, 0x80,
  0xC4, 0xF0, 0x77, 0x07, 0x80, 0xC2, 0xF0, 0x77, 0x20, 0x78, 0x0C, 0x0F, 0x07, 0x74, 0x07, 0xFF,
  0xFF, 0xE0, 0x77, 0x60, 0x7F, 0xFF, 0xFC, 0x07, 0x77, 0x10, 0x7F, 0xFF, 0xFA, 0x07, 0x77, 0x30,
  0x7F, 0xFF, 0xF0, 0x77, 0x75, 0x07, 0xFF, 0xFD, 0x07, 0x77, 0x70, 0x7F, 0xFF, 0xB0, 0x77, 0x77,
  0x20, 0x7F, 0xFF, 0x90, 0x77, 0x77, 0x40, 0x7F, 0xFE, 0x07, 0x77, 0x76, 0x07, 0xFF, 0xC0, 0x77,
  0x77, 0x71, 0x07, 0xFF, 0xA0, 0x77, 0x77, 0x73, 0x07, 0xFF, 0x07, 0x77, 0x77, 0x50, 0x7F, 0xD0,
  0x77, 0x77, 0x77, 0x07, 0xFB, 0x07, 0x80, 0xC1, 0x00, 0x7F, 0x90, 0x78, 0x0C, 0x30, 0x07, 0xE0,
  0x78, 0x0C, 0x50, 0x07, 0xC0, 0x78, 0x0C, 0x70, 0x07, 0xA0, 0x78, 0x0D, 0x10, 0x00, 0x77, 0x77,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_network_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_network_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_nfc 48x48, 4-bit Alpha,  RLE, 207 bytes.
static const unsigned char ic_outlined_48_device_nfc_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x4F, 0x93, 0x81, 0x1A, 0xDF, 0xB4, 0xF9, 0x4F, 0x92, 0x01, 0x0E,
  0xFD, 0x4F, 0x94, 0xF9, 0x20, 0xAF, 0xE4, 0xF9, 0x4F, 0x92, 0x0D, 0xFE, 0x4F, 0x94, 0xC6, 0xC6,
  0xC4, 0xF9, 0x4C, 0x6C, 0x6C, 0x4F, 0x94, 0xC6, 0xC6, 0xC4, 0xF9, 0x4C, 0x6C, 0x6C, 0x4F, 0x94,
  0xC5, 0x01, 0xC0, 0x15, 0xC4, 0xF9, 0x4C, 0x40, 0x20, 0xEC, 0x0E, 0x02, 0x4C, 0x4F, 0x94, 0xC4,
  0x0A, 0xE0, 0xA4, 0xC4, 0xF9, 0x4C, 0x40, 0xEE, 0x0E, 0x4C, 0x4F, 0x94, 0xC4, 0x0D, 0xE0, 0xD4,
  0xC4, 0xF9, 0x4C, 0x40, 0xAE, 0x0A, 0x4C, 0x4F, 0x94, 0xC4, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0xC4,
  0xF9, 0x4C, 0x58, 0x41, 0xAD, 0xDA, 0x15, 0xC4, 0xF9, 0x4C, 0x77, 0x2C, 0x4F, 0x94, 0xC7, 0x72,
  0xC4, 0xF9, 0x4C, 0x77, 0x2C, 0x4F, 0x94, 0xC7, 0x72, 0xC4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77,
  0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2,
  0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_nfc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_nfc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_nightlight 48x48, 4-bit Alpha,  RLE, 293 bytes.
static const unsigned char ic_outlined_48_device_nightlight_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDD, 0xA6, 0x37, 0x71, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x71,
  0x73, 0x01, 0x09, 0xFF, 0xB0, 0xE0, 0x77, 0x10, 0x50, 0xEF, 0xFC, 0x0A, 0x01, 0x70, 0x9F, 0x82,
  0xB6, 0x32, 0x20, 0x6D, 0x06, 0x71, 0x0A, 0xD0, 0xE0, 0x66, 0x02, 0x0E, 0xB0, 0xE0, 0x57, 0x10,
  0xAD, 0x07, 0x71, 0x0C, 0xC0, 0x57, 0x10, 0x9C, 0x0E, 0x03, 0x71, 0x06, 0xC0, 0x67, 0x10, 0x5C,
  0x0C, 0x01, 0x71, 0x01, 0x0E, 0xB0, 0xA7, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x72, 0x08, 0xB0, 0xE0,
  0x17, 0x10, 0x9C, 0x03, 0x73, 0x0E, 0xB0, 0x67, 0x10, 0x1C, 0x07, 0x73, 0x06, 0xB0, 0xD7, 0x20,
  0x8B, 0x0E, 0x74, 0x0B, 0xB0, 0x77, 0x20, 0xDB, 0x06, 0x73, 0x01, 0xC0, 0x27, 0x10, 0x3C, 0x74,
  0x05, 0xB0, 0xC7, 0x20, 0x7B, 0x0B, 0x74, 0x08, 0xB0, 0x87, 0x20, 0xAB, 0x06, 0x74, 0x0B, 0xB0,
  0x57, 0x20, 0xCB, 0x03, 0x74, 0x0D, 0xB0, 0x27, 0x20, 0xEB, 0x02, 0x74, 0x0E, 0xB0, 0x17, 0x2C,
  0x75, 0xC7, 0x3C, 0x75, 0x0E, 0xB7, 0x30, 0xEB, 0x02, 0x74, 0x0D, 0xB0, 0x17, 0x20, 0xCB, 0x03,
  0x74, 0x0B, 0xB0, 0x27, 0x20, 0xAB, 0x06, 0x74, 0x0A, 0xB0, 0x57, 0x20, 0x7B, 0x0B, 0x74, 0x08,
  0xB0, 0x87, 0x20, 0x3C, 0x74, 0x05, 0xB0, 0xC7, 0x30, 0xDB, 0x06, 0x73, 0x01, 0xC0, 0x27, 0x20,
  0x8B, 0x0E, 0x74, 0x0B, 0xB0, 0x77, 0x20, 0x1C, 0x07, 0x73, 0x06, 0xB0, 0xD7, 0x30, 0x9C, 0x03,
  0x73, 0x0E, 0xB0, 0x67, 0x20, 0x10, 0xEB, 0x0E, 0x01, 0x72, 0x08, 0xB0, 0xE0, 0x17, 0x20, 0x5C,
  0x0C, 0x01, 0x71, 0x01, 0x0E, 0xB0, 0xA7, 0x30, 0x9C, 0x0E, 0x03, 0x71, 0x06, 0xC0, 0x67, 0x30,
  0xAD, 0x07, 0x71, 0x0C, 0xC0, 0x57, 0x30, 0xAD, 0x0E, 0x06, 0x60, 0x20, 0xEB, 0x0E, 0x05, 0x73,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x06, 0xD0, 0x67, 0x30, 0x50, 0xEF, 0xFC, 0x0A, 0x01, 0x72, 0x01,
  0x09, 0xFF, 0xB0, 0xE0, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD7, 0x17, 0x71, 0x83, 0x37, 0xAC,
  0xDA, 0x83, 0xDD, 0xA6, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_nightlight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 37, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_nightlight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_note_alt 48x48, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_outlined_48_device_note_alt_data[] PROGMEM = {
  0x77, 0x18, 0x45, 0xBE, 0xEB, 0x57, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x75, 0x0C, 0xF9,
  0x0C, 0x77, 0x74, 0x05, 0xC0, 0x09, 0xC0, 0x57, 0x68, 0x11, 0xAD, 0xFD, 0x09, 0x20, 0x9F, 0xD8,
  0x4D, 0xA1, 0x01, 0xEF, 0xF0, 0x92, 0x09, 0xFF, 0x81, 0xE1, 0xAF, 0xFA, 0x00, 0x9F, 0xFA, 0x0A,
  0x0D, 0xFF, 0xFF, 0xE0, 0xDC, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77,
  0xF9, 0x77, 0x58, 0x1A, 0xD2, 0x6F, 0x97, 0x74, 0x0B, 0xA0, 0xE0, 0x25, 0xF9, 0x77, 0x30, 0x6C,
  0x0E, 0x02, 0x4F, 0x97, 0x74, 0x08, 0xC0, 0xD4, 0xF9, 0x77, 0x10, 0xB0, 0x92, 0x08, 0xB0, 0xA4,
  0xF9, 0x77, 0x0B, 0xA0, 0x92, 0x81, 0x8F, 0xB5, 0xF9, 0x76, 0x0B, 0xC0, 0x92, 0x06, 0x6F, 0x97,
  0x50, 0xBE, 0x09, 0x71, 0xF9, 0x74, 0x0B, 0xF0, 0xA7, 0x1F, 0x97, 0x30, 0xBF, 0x0A, 0x72, 0xF9,
  0x72, 0x0B, 0xF0, 0xA7, 0x3F, 0x97, 0x10, 0xBF, 0x0A, 0x74, 0xF9, 0x70, 0xBF, 0x0A, 0x75, 0xF9,
  0x60, 0xBF, 0x0A, 0x76, 0xF9, 0x50, 0xBF, 0x0A, 0x77, 0xF9, 0x40, 0xBF, 0x0A, 0x77, 0x1F, 0x94,
  0xF0, 0xA7, 0x72, 0xF9, 0x4E, 0x0A, 0x77, 0x3F, 0x94, 0xD0, 0xA7, 0x74, 0xF9, 0x4C, 0x0A, 0x77,
  0x5F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C, 0x0D, 0xFF, 0xFF,
  0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_note_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_note_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_password 48x48, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_outlined_48_device_password_data[] PROGMEM = {
  0x30, 0x08, 0x20, 0x08, 0x73, 0x00, 0x82, 0x00, 0x87, 0x30, 0x08, 0x20, 0x08, 0x40, 0x10, 0xEA,
  0x00, 0x2A, 0x0E, 0x01, 0x60, 0x10, 0xEA, 0x00, 0x2A, 0x0E, 0x01, 0x60, 0x10, 0xEA, 0x00, 0x2A,
  0x0E, 0x01, 0x30, 0xBA, 0x00, 0xBA, 0x0B, 0x71, 0x0B, 0xA0, 0x0B, 0xA0, 0xB7, 0x10, 0xBA, 0x00,
  0xBA, 0x0B, 0x40, 0x2E, 0x02, 0x71, 0x02, 0xE0, 0x27, 0x10, 0x2E, 0x02, 0x20, 0xF7, 0x0D, 0xC0,
  0xD0, 0xF7, 0x40, 0xF7, 0x0D, 0xC0, 0xD0, 0xF7, 0x40, 0xF7, 0x0D, 0xC0, 0xD0, 0xF7, 0xFD, 0x4F,
  0xD4, 0xFF, 0xFB, 0x4F, 0xD4, 0xFD, 0x0F, 0x70, 0xDC, 0x0D, 0x0F, 0x74, 0x0F, 0x70, 0xDC, 0x0D,
  0x0F, 0x74, 0x0F, 0x70, 0xDC, 0x0D, 0x0F, 0x72, 0x03, 0xE0, 0x37, 0x10, 0x3E, 0x03, 0x71, 0x03,
  0xE0, 0x34, 0x0C, 0xA0, 0x0A, 0xA0, 0xC7, 0x10, 0xCA, 0x00, 0xAA, 0x0C, 0x71, 0x0C, 0xA0, 0x0A,
  0xA0, 0xC3, 0x01, 0x0D, 0xA0, 0x02, 0xA0, 0xD0, 0x16, 0x01, 0x0D, 0xA0, 0x02, 0xA0, 0xD0, 0x16,
  0x01, 0x0D, 0xA0, 0x02, 0xA0, 0xD0, 0x14, 0x06, 0x07, 0x20, 0x70, 0x67, 0x30, 0x60, 0x72, 0x07,
  0x06, 0x73, 0x06, 0x07, 0x20, 0x70, 0x68, 0x0D, 0xC1, 0x08, 0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x48,
  0x0C, 0x4F, 0x48, 0x0C, 0x4F, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_password() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 14, 45, 37), Box(0, 0, 47, 47),
      ic_outlined_48_device_password_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_pattern 48x48, 4-bit Alpha,  RLE, 280 bytes.
static const unsigned char ic_outlined_48_device_pattern_data[] PROGMEM = {
  0x18, 0x41, 0xAD, 0xDA, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x68, 0x71, 0xAD, 0xDA, 0x10, 0x1E, 0xC0,
  0xE0, 0x14, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC8, 0x1E, 0x1A, 0xE0, 0xA4, 0x0A, 0xE0,
  0xA4, 0x0A, 0xE0, 0xA0, 0xDE, 0x0D, 0x40, 0xDE, 0x0D, 0x40, 0xDE, 0x00, 0xDE, 0x0D, 0x40, 0xDE,
  0x0D, 0x40, 0xEE, 0x0D, 0x0A, 0xE0, 0xA4, 0x0A, 0xE0, 0xA3, 0x05, 0xF8, 0x1A, 0x1E, 0xC0, 0xE0,
  0x14, 0x01, 0x0E, 0xC0, 0xE0, 0x12, 0x05, 0xF8, 0x7E, 0x10, 0x1A, 0xDD, 0xA1, 0x68, 0x41, 0xAD,
  0xDA, 0x12, 0x05, 0xD8, 0x2E, 0xDA, 0x17, 0x77, 0x05, 0xD0, 0x57, 0x77, 0x30, 0x5D, 0x05, 0x77,
  0x73, 0x05, 0xD0, 0x57, 0x77, 0x30, 0x5D, 0x05, 0x72, 0x84, 0x1A, 0xDD, 0xA1, 0x68, 0x21, 0xAD,
  0xED, 0x05, 0x28, 0x71, 0xAD, 0xDA, 0x10, 0x1E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xF0, 0x52, 0x01,
  0x0E, 0xC8, 0x1E, 0x1A, 0xE0, 0xA4, 0x0A, 0xF0, 0x53, 0x0A, 0xE0, 0xA0, 0xDE, 0x0D, 0x40, 0xDE,
  0x0E, 0x40, 0xDE, 0x00, 0xDE, 0x0D, 0x40, 0xEE, 0x0D, 0x40, 0xDE, 0x0D, 0x0A, 0xE0, 0xA3, 0x05,
  0xF0, 0xA4, 0x0A, 0xE8, 0x1A, 0x1E, 0xC0, 0xE0, 0x12, 0x05, 0xF0, 0xE0, 0x14, 0x01, 0x0E, 0xC8,
  0x7E, 0x10, 0x1A, 0xDD, 0xA1, 0x20, 0x5D, 0x82, 0xED, 0xA1, 0x68, 0x41, 0xAD, 0xDA, 0x17, 0x20,
  0x5D, 0x05, 0x77, 0x73, 0x05, 0xD0, 0x57, 0x77, 0x30, 0x5D, 0x05, 0x77, 0x73, 0x05, 0xD0, 0x57,
  0x77, 0x82, 0x1A, 0xDE, 0xD0, 0x52, 0x84, 0x2A, 0xEE, 0xA2, 0x68, 0x72, 0xAE, 0xD9, 0x10, 0x1E,
  0xF0, 0x52, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x02, 0x0E, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF, 0xA0, 0x90,
  0xDF, 0xFF, 0xFA, 0x00, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xC0, 0xE0,
  0x14, 0x01, 0x0E, 0xC0, 0xE0, 0x24, 0x01, 0x0E, 0xC8, 0x7E, 0x10, 0x1A, 0xDE, 0xA2, 0x68, 0x41,
  0xAE, 0xEA, 0x26, 0x84, 0x2A, 0xED, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_pattern() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_pattern_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_phishing 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_outlined_48_device_phishing_data[] PROGMEM = {
  0x77, 0x6C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77,
  0x3C, 0x77, 0x73, 0xC7, 0x77, 0x20, 0x5C, 0x05, 0x77, 0x60, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x40,
  0xCF, 0x90, 0xC7, 0x73, 0x05, 0xFB, 0x05, 0x77, 0x20, 0xBB, 0x82, 0xB1, 0x1B, 0xB0, 0xB7, 0x72,
  0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE0, 0x77, 0x71, 0x0E, 0xB0, 0x12, 0x01, 0xB8, 0x1E, 0xF7, 0x77,
  0x0B, 0xB8, 0x2B, 0x11, 0xBB, 0x0B, 0xA0, 0x77, 0x60, 0x5F, 0xB0, 0x5B, 0x07, 0x76, 0x0C, 0xF9,
  0x0C, 0x1C, 0x07, 0x75, 0x01, 0x0C, 0xE0, 0xC0, 0x11, 0xD0, 0x77, 0x60, 0x5C, 0x05, 0x3E, 0x07,
  0x76, 0xC4, 0xF0, 0x77, 0x5C, 0x4F, 0x90, 0x77, 0x4C, 0x4C, 0x0E, 0xC0, 0x77, 0x3C, 0x4C, 0x03,
  0x0E, 0xB0, 0x77, 0x3C, 0x4C, 0x18, 0x23, 0xEF, 0x77, 0x4C, 0x40, 0xEB, 0x20, 0x30, 0x77, 0x5B,
  0x0E, 0x40, 0xDB, 0x02, 0x77, 0x02, 0xB0, 0xD4, 0x0B, 0xB0, 0x67, 0x70, 0x6B, 0x0B, 0x40, 0x6B,
  0x0C, 0x77, 0x0C, 0xB0, 0x64, 0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x50, 0x9C, 0x04, 0x73, 0x04,
  0xC0, 0x96, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C, 0x0E, 0x01, 0x70, 0x4D, 0x81, 0xC6, 0x22, 0x81,
  0x26, 0xCD, 0x04, 0x72, 0x06, 0xFF, 0xA0, 0x67, 0x40, 0x40, 0xEF, 0xD0, 0xE0, 0x47, 0x60, 0x10,
  0x9F, 0xB0, 0x90, 0x17, 0x72, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA6, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_phishing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_phishing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_pin 48x48, 4-bit Alpha,  RLE, 230 bytes.
static const unsigned char ic_outlined_48_device_pin_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x48, 0x23, 0xDF, 0x44,
  0x84, 0x3B, 0xFE, 0xB3, 0x58, 0x43, 0xBE, 0xEA, 0x23, 0xF9, 0x30, 0x8B, 0x04, 0x30, 0x3E, 0x03,
  0x30, 0x4D, 0x0E, 0x01, 0x2F, 0x92, 0x0B, 0xC0, 0x43, 0x86, 0xAF, 0xC3, 0x3D, 0xFA, 0x38, 0x67,
  0xEA, 0x12, 0xDF, 0x72, 0xF9, 0x28, 0x15, 0xE5, 0xA0, 0x44, 0x04, 0x02, 0x28, 0x17, 0xFC, 0x40,
  0x13, 0x81, 0xBF, 0x82, 0xF9, 0x30, 0x11, 0xA0, 0x47, 0x18, 0x1A, 0xFA, 0x58, 0x11, 0x37, 0xA0,
  0x32, 0xF9, 0x5A, 0x04, 0x70, 0x5A, 0x03, 0x50, 0x4B, 0x06, 0x3F, 0x95, 0xA0, 0x46, 0x05, 0xA0,
  0x86, 0x84, 0x3B, 0xDF, 0xE3, 0x2F, 0x95, 0xA0, 0x45, 0x05, 0xA0, 0x97, 0x38, 0x19, 0xFC, 0x2F,
  0x95, 0xA0, 0x44, 0x05, 0xA0, 0x96, 0x81, 0x4A, 0x12, 0x04, 0xA2, 0xF9, 0x5A, 0x04, 0x30, 0x5A,
  0x09, 0x78, 0x6D, 0xFB, 0x33, 0xCF, 0xC2, 0xF9, 0x5A, 0x04, 0x30, 0xCF, 0x30, 0x5E, 0x05, 0x2F,
  0x95, 0xA0, 0x43, 0x0C, 0xF4, 0x84, 0x4B, 0xFE, 0xB4, 0x3F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C, 0x0D,
  0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD,
  0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_play_lesson 48x48, 4-bit Alpha,  RLE, 269 bytes.
static const unsigned char ic_outlined_48_device_play_lesson_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xF0, 0xE0, 0x17, 0x10,
  0xAF, 0xFF, 0xFA, 0x0A, 0x71, 0x0D, 0xFF, 0xFF, 0xA0, 0xD7, 0x1C, 0x4F, 0xB7, 0x3C, 0x71, 0xC4,
  0xFB, 0x73, 0xC7, 0x1C, 0x4F, 0xB7, 0x3C, 0x71, 0xC4, 0xFB, 0x73, 0xC7, 0x1C, 0x4F, 0xB7, 0x3C,
  0x71, 0xC4, 0xFB, 0x73, 0xC7, 0x1C, 0x4F, 0xB7, 0x3C, 0x71, 0xC4, 0xFB, 0x73, 0xC7, 0x1C, 0x4F,
  0xB7, 0x3C, 0x71, 0xC4, 0xFB, 0x73, 0xC7, 0x1C, 0x4F, 0xB7, 0x3C, 0x71, 0xC4, 0xB8, 0x2D, 0x44,
  0xDB, 0x73, 0xC7, 0x1C, 0x4A, 0x07, 0x40, 0x7A, 0x73, 0xC7, 0x1C, 0x40, 0xA0, 0x26, 0x02, 0x0A,
  0x73, 0xC7, 0x1C, 0x77, 0x73, 0x01, 0x20, 0x17, 0x1C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80,
  0xC0, 0x0C, 0x77, 0x71, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x6C, 0x77, 0x60, 0x40, 0xDF, 0x90, 0xD0,
  0x44, 0xC7, 0x75, 0x08, 0xFD, 0x08, 0x3C, 0x77, 0x40, 0x8F, 0xF0, 0x82, 0xC7, 0x73, 0x04, 0xFF,
  0xA0, 0x41, 0xC7, 0x73, 0x0D, 0xD0, 0x80, 0x9F, 0xA0, 0xD1, 0xC7, 0x72, 0x05, 0xE8, 0x27, 0x03,
  0xDF, 0x90, 0x5C, 0x77, 0x20, 0x9E, 0x07, 0x30, 0x7F, 0x09, 0xC7, 0x72, 0x0D, 0xE0, 0x74, 0x02,
  0x0B, 0xD0, 0xDC, 0x77, 0x20, 0xEE, 0x07, 0x60, 0x50, 0xEB, 0x0E, 0xC7, 0x72, 0x0E, 0xE0, 0x76,
  0x05, 0x0E, 0xB0, 0xEC, 0x77, 0x20, 0xDE, 0x07, 0x40, 0x20, 0xBD, 0x0D, 0xC7, 0x72, 0x09, 0xE0,
  0x73, 0x07, 0xF0, 0x9C, 0x77, 0x20, 0x5E, 0x82, 0x70, 0x3D, 0xF9, 0x05, 0x0D, 0xFF, 0x90, 0xC4,
  0x0D, 0xD0, 0x80, 0x9F, 0xA8, 0x1D, 0x0A, 0xFF, 0xA0, 0x23, 0x04, 0xFF, 0xA8, 0x24, 0x01, 0xEF,
  0xF9, 0x09, 0x40, 0x8F, 0xF0, 0x83, 0x81, 0x1A, 0xDF, 0xF0, 0x34, 0x08, 0xFD, 0x08, 0x77, 0x76,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x77, 0x28, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_play_lesson() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_play_lesson_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_price_change 48x48, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_outlined_48_device_price_change_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x71, 0xC7,
  0x76, 0xF9, 0x71, 0xC7, 0x76, 0xF9, 0x40, 0x40, 0xDF, 0xB7, 0x00, 0x77, 0xF9, 0x40, 0xDF, 0xC6,
  0x07, 0xA0, 0x76, 0xF9, 0x4F, 0xD5, 0x07, 0xC0, 0x75, 0xF9, 0x4F, 0xD4, 0x07, 0xE0, 0x74, 0xF9,
  0x4C, 0x77, 0x73, 0xF9, 0x4C, 0x77, 0x73, 0xF9, 0x4F, 0xB0, 0xD0, 0x47, 0x72, 0xF9, 0x4F, 0xC0,
  0xD7, 0x72, 0xF9, 0x40, 0xDF, 0xC7, 0x72, 0xF9, 0x40, 0x40, 0xDF, 0xB7, 0x72, 0xF9, 0x75, 0xC7,
  0x72, 0xF9, 0x75, 0xC7, 0x72, 0xF9, 0x4F, 0xD4, 0x05, 0x80, 0x27, 0x05, 0x4F, 0x94, 0xFD, 0x40,
  0x10, 0xDC, 0x0D, 0x01, 0x4F, 0x94, 0xFC, 0x0D, 0x50, 0x10, 0xDA, 0x0D, 0x01, 0x5F, 0x94, 0xFB,
  0x0D, 0x04, 0x68, 0x21, 0xDD, 0x16, 0xF9, 0x71, 0xC7, 0x40, 0x01, 0x7F, 0x97, 0x1C, 0x77, 0x6F,
  0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81,
  0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAE, 0xFF, 0xFF, 0xC8, 0x1E, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_price_change() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_price_change_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_price_check 48x48, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_outlined_48_device_price_check_data[] PROGMEM = {
  0x5C, 0x77, 0x77, 0x2C, 0x77, 0x74, 0x04, 0x0D, 0xFD, 0x77, 0x60, 0xDF, 0xE7, 0x76, 0xFF, 0x77,
  0x6F, 0xF7, 0x76, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xFD,
  0x0D, 0x04, 0x77, 0x6F, 0xE0, 0xD7, 0x76, 0x0D, 0xFE, 0x77, 0x60, 0x40, 0xDF, 0xD7, 0x77, 0x72,
  0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7, 0x76, 0xFF, 0x77, 0x6F, 0xF7, 0x72,
  0x04, 0x09, 0x2F, 0xE0, 0xD7, 0x71, 0x04, 0xA0, 0x91, 0xFD, 0x0D, 0x04, 0x77, 0x04, 0xC0, 0x95,
  0xC7, 0x74, 0x04, 0xD0, 0x55, 0xC7, 0x73, 0x04, 0xD0, 0x57, 0x71, 0x01, 0x73, 0x04, 0xD0, 0x57,
  0x71, 0x81, 0x9D, 0x27, 0x10, 0x4D, 0x05, 0x77, 0x10, 0x9A, 0x0D, 0x02, 0x60, 0x4D, 0x05, 0x77,
  0x10, 0x5C, 0x0D, 0x02, 0x40, 0x4D, 0x05, 0x77, 0x30, 0x9C, 0x0D, 0x02, 0x20, 0x4D, 0x05, 0x77,
  0x50, 0x9C, 0x81, 0xD2, 0x4D, 0x05, 0x77, 0x70, 0x9C, 0x0D, 0xD0, 0x57, 0x77, 0x20, 0x9F, 0x90,
  0x57, 0x77, 0x40, 0x9E, 0x05, 0x77, 0x76, 0x09, 0xC0, 0x57, 0x77, 0x71, 0x09, 0xA0, 0x57, 0x77,
  0x73, 0x09, 0x05, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_price_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_price_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_punch_clock 48x48, 4-bit Alpha,  RLE, 259 bytes.
static const unsigned char ic_outlined_48_device_punch_clock_data[] PROGMEM = {
  0x6F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5F, 0xFF, 0xB7, 0x5C, 0x77, 0x2C, 0x75,
  0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72, 0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xC7, 0x72,
  0xC7, 0x81, 0x1A, 0xDF, 0xFF, 0xF8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xFC, 0x81, 0xE1, 0xAF, 0xFF,
  0xFE, 0x0A, 0x0D, 0xFF, 0xFF, 0xE0, 0xDC, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x73, 0x86, 0x59,
  0xDE, 0xED, 0x95, 0x73, 0xF9, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x71, 0xF9, 0x70, 0x8F, 0xD0,
  0x87, 0xF9, 0x60, 0x8B, 0x81, 0xE7, 0x22, 0x81, 0x27, 0xEB, 0x08, 0x6F, 0x95, 0x04, 0xB0, 0xA7,
  0x10, 0xAB, 0x04, 0x5F, 0x95, 0x0D, 0xA0, 0xA4, 0xA4, 0x0A, 0xA0, 0xD5, 0xF9, 0x40, 0x5A, 0x0E,
  0x5A, 0x50, 0xEA, 0x05, 0x4F, 0x94, 0x09, 0xA0, 0x75, 0xA5, 0x07, 0xA0, 0x94, 0xF9, 0x40, 0xDA,
  0x02, 0x5A, 0x50, 0x2A, 0x0D, 0x4F, 0x94, 0x0E, 0xA6, 0xA0, 0x15, 0xA0, 0xE4, 0xF9, 0x40, 0xEA,
  0x68, 0x2C, 0xFC, 0x14, 0xA0, 0xE4, 0xF9, 0x40, 0xDA, 0x02, 0x58, 0x31, 0xCF, 0xC1, 0x20, 0x2A,
  0x0D, 0x4F, 0x94, 0x09, 0xA0, 0x76, 0x82, 0x1C, 0xF6, 0x20, 0x7A, 0x09, 0x4F, 0x94, 0x05, 0xA0,
  0xE7, 0x01, 0x06, 0x30, 0xEA, 0x05, 0x4F, 0x95, 0x0D, 0xA0, 0xA7, 0x30, 0xAA, 0x0D, 0x5F, 0x95,
  0x04, 0xB0, 0xA7, 0x10, 0xAB, 0x04, 0x5F, 0x96, 0x08, 0xB8, 0x1E, 0x72, 0x28, 0x12, 0x7E, 0xB0,
  0x86, 0xF9, 0x70, 0x8F, 0xD0, 0x87, 0xF9, 0x71, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x71, 0xF9, 0x73,
  0x86, 0x59, 0xDE, 0xED, 0x95, 0x73, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xC0, 0xDF, 0xFF, 0xFE,
  0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8,
  0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_punch_clock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_punch_clock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_quiz 48x48, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_outlined_48_device_quiz_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0xC7, 0x77, 0x3C, 0x71, 0xC7,
  0x77, 0x3C, 0x71, 0xC7, 0x28, 0x56, 0xCF, 0xEC, 0x71, 0x71, 0xC7, 0x1C, 0x70, 0x10, 0xCE, 0x0D,
  0x03, 0x7F, 0x94, 0xC7, 0x0C, 0xB0, 0xE0, 0xDB, 0x0D, 0x7F, 0x94, 0xC6, 0x06, 0xA0, 0xE0, 0x42,
  0x03, 0x0E, 0xA0, 0x66, 0xF9, 0x4C, 0x68, 0x23, 0xAF, 0x54, 0x07, 0xA0, 0x96, 0xF9, 0x4C, 0x71,
  0x01, 0x50, 0x5A, 0x0A, 0x6F, 0x94, 0xC7, 0x70, 0xAA, 0x07, 0x6F, 0x94, 0xC7, 0x60, 0x6A, 0x0E,
  0x01, 0x6F, 0x94, 0xC7, 0x50, 0x6B, 0x05, 0x7F, 0x94, 0xC7, 0x40, 0x5B, 0x06, 0x71, 0xF9, 0x4C,
  0x73, 0x01, 0x0E, 0xA0, 0x77, 0x2F, 0x94, 0xC7, 0x30, 0x5A, 0x0C, 0x73, 0xF9, 0x4C, 0x73, 0x07,
  0xA0, 0x97, 0x3F, 0x94, 0xC7, 0x38, 0x24, 0x99, 0x57, 0x3F, 0x94, 0xC7, 0x77, 0x3F, 0x94, 0xC7,
  0x40, 0x01, 0x74, 0xF9, 0x4C, 0x73, 0x07, 0xA0, 0x77, 0x3F, 0x94, 0xC7, 0x3C, 0x73, 0xF9, 0x4C,
  0x73, 0x0E, 0xA0, 0xE7, 0x3F, 0x94, 0xC7, 0x38, 0x24, 0xDD, 0x47, 0x3F, 0x94, 0xC7, 0x77, 0x3F,
  0x94, 0xC7, 0x77, 0x3F, 0x94, 0x0D, 0xFF, 0xFF, 0xA0, 0xDC, 0x40, 0xAF, 0xFF, 0xFA, 0x0A, 0xC4,
  0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0xC5, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x1C, 0x80,
  0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x00, 0xDF, 0xFF, 0xFB, 0x71, 0x0A,
  0xFF, 0xFF, 0xB7, 0x10, 0x10, 0xEF, 0xFF, 0xFA, 0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xF7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_quiz() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_quiz_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_radar 48x48, 4-bit Alpha,  RLE, 453 bytes.
static const unsigned char ic_outlined_48_device_radar_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x15, 0x89, 0x01, 0x6A, 0xCE, 0xEC, 0xA5, 0x15, 0x01,
  0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0, 0xE0, 0x14, 0x01, 0x09, 0xFB, 0x08, 0x01, 0x40, 0x10, 0xEB,
  0x0E, 0x01, 0x40, 0x9C, 0x03, 0x40, 0x40, 0xEF, 0xD0, 0xE0, 0x34, 0x03, 0xC0, 0x93, 0x01, 0xC0,
  0x74, 0x06, 0xFF, 0xA0, 0x54, 0x07, 0xC0, 0x12, 0x08, 0xB0, 0xE4, 0x05, 0xD8, 0x6D, 0x72, 0x11,
  0x37, 0xDD, 0x03, 0x40, 0xEB, 0x08, 0x20, 0xDB, 0x06, 0x30, 0x10, 0xEC, 0x06, 0x71, 0x07, 0xC0,
  0xE0, 0x13, 0x06, 0xB8, 0x1D, 0x03, 0xC4, 0x09, 0xC0, 0x47, 0x30, 0x5C, 0x08, 0x4C, 0x03, 0x07,
  0xB0, 0xB3, 0x02, 0xC0, 0x67, 0x50, 0x7C, 0x01, 0x30, 0xBB, 0x07, 0x0A, 0xB0, 0x63, 0x07, 0xB0,
  0xC4, 0x84, 0x19, 0xDE, 0x91, 0x40, 0xDB, 0x05, 0x30, 0x6B, 0x0A, 0x0C, 0xB0, 0x33, 0x0B, 0xB0,
  0x63, 0x01, 0x0E, 0xC0, 0xE0, 0x23, 0x07, 0xB0, 0xA3, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x30, 0xDB,
  0x02, 0x30, 0xAE, 0x0A, 0x30, 0x3B, 0x0C, 0x30, 0x2B, 0x0E, 0xC4, 0xC4, 0x0E, 0xE0, 0xE3, 0x01,
  0xB0, 0xE4, 0xF9, 0x4C, 0x40, 0xEE, 0x0E, 0x30, 0x1B, 0x0E, 0x4B, 0x00, 0xEB, 0x02, 0x30, 0xDB,
  0x01, 0x30, 0xAF, 0x05, 0x20, 0x3B, 0x0D, 0x30, 0x1B, 0x0D, 0x0C, 0xB0, 0x33, 0x0B, 0xB0, 0x53,
  0x01, 0x0E, 0xF8, 0x15, 0x07, 0xB0, 0xA3, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x30, 0x7B, 0x0C, 0x48,
  0x22, 0xAE, 0xED, 0x05, 0x0D, 0xB0, 0x63, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x30, 0x2C, 0x05, 0x70,
  0x5F, 0xA0, 0x13, 0x0A, 0xB0, 0x60, 0x3C, 0x40, 0xAB, 0x0E, 0x03, 0x70, 0x5F, 0x09, 0x40, 0xEB,
  0x81, 0x20, 0xDB, 0x06, 0x30, 0x20, 0xEB, 0x0E, 0x05, 0x70, 0x5D, 0x0E, 0x01, 0x30, 0x6B, 0x0D,
  0x20, 0x8B, 0x0E, 0x40, 0x5D, 0x81, 0xC5, 0x22, 0x81, 0x26, 0xDE, 0x05, 0x30, 0xDB, 0x07, 0x20,
  0x1C, 0x07, 0x40, 0x7F, 0xFD, 0x81, 0x50, 0x8B, 0x0E, 0x01, 0x30, 0x9C, 0x03, 0x40, 0x50, 0xEF,
  0xD0, 0xED, 0x07, 0xC0, 0x84, 0x01, 0x0E, 0xB0, 0xE0, 0x14, 0x02, 0x09, 0xFB, 0x81, 0x91, 0x5F,
  0x90, 0xD0, 0x15, 0x05, 0xC0, 0xC0, 0x15, 0x82, 0x27, 0xBD, 0xA8, 0x2D, 0xB7, 0x13, 0x05, 0xF0,
  0x47, 0x09, 0xC0, 0xE0, 0x37, 0x74, 0x08, 0xD0, 0x87, 0x20, 0xAD, 0x07, 0x77, 0x20, 0x8D, 0x0A,
  0x74, 0x0A, 0xD0, 0xE0, 0x67, 0x50, 0x70, 0xDD, 0x0A, 0x76, 0x09, 0xF8, 0x2B, 0x63, 0x22, 0x83,
  0x13, 0x6A, 0xEE, 0x08, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0D, 0x04, 0x77, 0x30, 0x10, 0x9F, 0xFB,
  0x81, 0xE8, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x71, 0x77, 0x74, 0x89, 0x23, 0x7A, 0xCD,
  0xFE, 0xDB, 0xA6, 0x27, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_radar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_radar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_remember_me 48x48, 4-bit Alpha,  RLE, 187 bytes.
static const unsigned char ic_outlined_48_device_remember_me_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x84, 0x6C, 0xEE, 0xC6, 0x7F, 0x95, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0xF9, 0x50, 0xCF, 0x90,
  0xC5, 0xF9, 0x40, 0x6F, 0xB0, 0x64, 0xF9, 0x40, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC4, 0xF9, 0x40,
  0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x4F, 0x94, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE4, 0xF9, 0x40, 0xCB,
  0x82, 0xB1, 0x1B, 0xB0, 0xC4, 0xF9, 0x40, 0x6F, 0xB0, 0x64, 0xF9, 0x50, 0xCF, 0x90, 0xC5, 0xF9,
  0x50, 0x10, 0xCE, 0x0C, 0x01, 0x5F, 0x97, 0x84, 0x6C, 0xEE, 0xC6, 0x7F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x94, 0x83, 0x47, 0xAD, 0xDA, 0x83, 0xDD, 0xA7, 0x44, 0xF9, 0x18, 0x13, 0xAE, 0xFD, 0x81,
  0xEA, 0x31, 0xF9, 0x0C, 0xFF, 0xC0, 0xC8, 0x0C, 0x4F, 0x83, 0xD9, 0x62, 0x12, 0x83, 0x12, 0x69,
  0xDF, 0xF0, 0xA0, 0x47, 0x50, 0x40, 0xAF, 0xB0, 0xB0, 0x37, 0x72, 0x03, 0x0B, 0xF9, 0x77, 0x68,
  0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6C, 0x0D, 0xFF, 0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1,
  0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_remember_me() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_remember_me_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_reset_tv 48x48, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_outlined_48_device_reset_tv_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x74, 0x03, 0x76, 0xF9, 0x77, 0x38, 0x17, 0xF7, 0x75, 0xF9, 0x77, 0x20, 0x7B, 0x07,
  0x74, 0xF9, 0x77, 0x10, 0x7C, 0x0E, 0x01, 0x77, 0xC7, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x1C, 0x76,
  0x07, 0xC0, 0xE0, 0x37, 0x72, 0xC7, 0x50, 0x7C, 0x0E, 0x03, 0x77, 0x3C, 0x74, 0x07, 0xFF, 0xE8,
  0x1D, 0xA1, 0x1C, 0x73, 0x07, 0xFF, 0xFA, 0x0E, 0x01, 0xC7, 0x30, 0x7F, 0xFF, 0xB0, 0xAC, 0x74,
  0x07, 0xFF, 0xFA, 0x0D, 0xC7, 0x50, 0x7C, 0x0E, 0x03, 0x76, 0xF9, 0x76, 0x07, 0xC0, 0xE0, 0x37,
  0x5F, 0x97, 0x70, 0x7C, 0x0E, 0x03, 0x74, 0xF9, 0x77, 0x10, 0x7C, 0x0E, 0x01, 0x73, 0xF9, 0x77,
  0x20, 0x7B, 0x07, 0x74, 0xF9, 0x77, 0x38, 0x17, 0xF7, 0x75, 0xF9, 0x77, 0x40, 0x37, 0x6F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80,
  0xC2, 0xF8, 0x19, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x17,
  0x6F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x77, 0x3F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_reset_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_reset_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_restart_alt 48x48, 4-bit Alpha,  RLE, 266 bytes.
static const unsigned char ic_outlined_48_device_restart_alt_data[] PROGMEM = {
  0x77, 0x00, 0x77, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x60, 0x7C, 0x07, 0x77, 0x74, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0x73, 0x07, 0xE8, 0x3E, 0xDB, 0x94, 0x77, 0x50,
  0x7F, 0xD8, 0x1E, 0x91, 0x77, 0x20, 0x7F, 0xF0, 0xE0, 0x77, 0x72, 0x07, 0xFF, 0x90, 0xC0, 0x17,
  0x20, 0x15, 0x07, 0xC8, 0x4E, 0x32, 0x49, 0xDD, 0x0D, 0x02, 0x78, 0x11, 0xD7, 0x50, 0x7C, 0x0E,
  0x03, 0x30, 0x60, 0xDC, 0x0D, 0x01, 0x60, 0xCA, 0x07, 0x50, 0x7C, 0x07, 0x50, 0xAC, 0x0C, 0x50,
  0x7C, 0x04, 0x50, 0x7A, 0x07, 0x70, 0x8C, 0x07, 0x30, 0x10, 0xEB, 0x0A, 0x70, 0x07, 0x72, 0x0A,
  0xB0, 0xE0, 0x12, 0x09, 0xB0, 0xD7, 0x76, 0x0D, 0xB0, 0x92, 0x0E, 0xB0, 0x67, 0x76, 0x06, 0xB8,
  0x1E, 0x04, 0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x04, 0x09, 0xB0, 0x97, 0x77, 0x10, 0x9B, 0x09, 0x0B,
  0xB0, 0x47, 0x77, 0x10, 0x4B, 0x0B, 0x0D, 0xB0, 0x27, 0x77, 0x10, 0x2B, 0x0D, 0x0E, 0xB7, 0x77,
  0x3B, 0x00, 0xEB, 0x77, 0x73, 0xB0, 0xE0, 0xDB, 0x02, 0x77, 0x71, 0x02, 0xB0, 0xD0, 0xBB, 0x04,
  0x77, 0x71, 0x04, 0xB0, 0xB0, 0x8B, 0x08, 0x77, 0x71, 0x08, 0xB0, 0x80, 0x4B, 0x0D, 0x77, 0x71,
  0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x57, 0x76, 0x05, 0xB0, 0xE2, 0x08, 0xB0, 0xD0, 0x17, 0x74, 0x01,
  0x0D, 0xB0, 0x82, 0x01, 0xC0, 0xA7, 0x74, 0x0A, 0xC0, 0x13, 0x08, 0xC0, 0x97, 0x72, 0x09, 0xC0,
  0x85, 0x0C, 0xC0, 0xA0, 0x17, 0x50, 0x10, 0xAC, 0x0C, 0x60, 0x10, 0xEC, 0x0D, 0x06, 0x73, 0x06,
  0x0D, 0xC0, 0xE0, 0x17, 0x02, 0x0D, 0xD8, 0x1D, 0x84, 0x48, 0x14, 0x8D, 0xD0, 0xD0, 0x27, 0x20,
  0x10, 0xCF, 0x4F, 0x0C, 0x01, 0x75, 0x07, 0xE4, 0xE0, 0x77, 0x71, 0x81, 0x18, 0xEB, 0x4B, 0x81,
  0xE8, 0x17, 0x75, 0x81, 0x48, 0xB4, 0x81, 0xB8, 0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_restart_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 5, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_restart_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_reviews 48x48, 4-bit Alpha,  RLE, 217 bytes.
static const unsigned char ic_outlined_48_device_reviews_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x10,
  0x03, 0x77, 0x1F, 0x97, 0x71, 0x00, 0xA7, 0x71, 0xF9, 0x77, 0x02, 0xA0, 0x27, 0x7F, 0x97, 0x70,
  0x9A, 0x09, 0x77, 0xF9, 0x76, 0x01, 0xC0, 0x17, 0x6F, 0x97, 0x60, 0x8C, 0x08, 0x76, 0xF9, 0x76,
  0x0E, 0xC0, 0xE7, 0x6F, 0x97, 0x38, 0x11, 0x8E, 0xE8, 0x1E, 0x81, 0x73, 0xF9, 0x71, 0x02, 0x09,
  0xFD, 0x09, 0x02, 0x71, 0xF9, 0x60, 0x30, 0xAF, 0xFA, 0x0A, 0x03, 0x6F, 0x96, 0x03, 0x0A, 0xFF,
  0xA0, 0xA0, 0x36, 0xF9, 0x71, 0x02, 0x09, 0xFD, 0x09, 0x02, 0x71, 0xF9, 0x73, 0x81, 0x18, 0xEE,
  0x81, 0xE8, 0x17, 0x3F, 0x97, 0x60, 0xEC, 0x0E, 0x76, 0xF9, 0x76, 0x08, 0xC0, 0x87, 0x6F, 0x97,
  0x60, 0x1C, 0x01, 0x76, 0xF9, 0x77, 0x09, 0xA0, 0x97, 0x7F, 0x97, 0x70, 0x2A, 0x02, 0x77, 0xF9,
  0x77, 0x10, 0x0A, 0x77, 0x1F, 0x97, 0x71, 0x00, 0x37, 0x71, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77,
  0x74, 0xF9, 0x10, 0x30, 0xEF, 0xFF, 0xFC, 0x0D, 0xC0, 0x30, 0xEF, 0xFF, 0xFD, 0x0A, 0xC0, 0xEF,
  0xFF, 0xFD, 0x0E, 0x01, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77, 0x4E, 0x07, 0x77,
  0x77, 0x5D, 0x07, 0x77, 0x77, 0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0, 0x0A, 0x07, 0x80,
  0xC1, 0x09, 0x07, 0x80, 0xC2, 0x00, 0x78, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_reviews() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_reviews_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_r_mobiledata 48x48, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_outlined_48_device_r_mobiledata_data[] PROGMEM = {
  0xFB, 0x81, 0xEA, 0x11, 0xFD, 0x0E, 0x01, 0xFE, 0x0A, 0xFE, 0x0D, 0xC6, 0xF9, 0x6F, 0x98, 0x02,
  0x5F, 0xFB, 0x0D, 0xFE, 0x07, 0xFD, 0x0B, 0x1C, 0x0F, 0x90, 0xAB, 0x0C, 0x2C, 0x40, 0xDB, 0x01,
  0x1C, 0x40, 0x7B, 0x07, 0x1C, 0x40, 0x1B, 0x0E, 0x1C, 0x50, 0x9B, 0x05, 0xC5, 0x03, 0xB0, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_r_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 17, 19), Box(0, 0, 47, 47),
      ic_outlined_48_device_r_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_rsvp 48x48, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_outlined_48_device_rsvp_data[] PROGMEM = {
  0xF0, 0xE0, 0x83, 0x04, 0x0D, 0xF2, 0x0D, 0xA0, 0x22, 0x02, 0xA0, 0xD1, 0xF0, 0xD0, 0x81, 0xFA,
  0x08, 0x20, 0xDF, 0x92, 0x08, 0xA0, 0x62, 0x06, 0xA0, 0x81, 0xFA, 0x08, 0xFA, 0x0D, 0x2F, 0xA2,
  0x04, 0xA0, 0xB2, 0x0B, 0xA0, 0x41, 0xFA, 0x0D, 0xB4, 0xB2, 0xB7, 0x20, 0xEA, 0x2A, 0x0E, 0x2B,
  0x4E, 0x4B, 0x2B, 0x80, 0x07, 0x06, 0x40, 0xAA, 0x00, 0x4A, 0x0A, 0x2B, 0x4F, 0xD0, 0xE2, 0xF9,
  0x0A, 0x30, 0x6A, 0x00, 0x9A, 0x06, 0x2F, 0xA0, 0xDF, 0xA0, 0x82, 0x0D, 0xF9, 0x30, 0x1A, 0x00,
  0xDA, 0x01, 0x2F, 0xA0, 0x8F, 0x90, 0x93, 0x02, 0x80, 0x17, 0xB4, 0x0C, 0xC0, 0xC3, 0xF0, 0xD0,
  0x81, 0xB2, 0x07, 0xA0, 0x77, 0x2B, 0x40, 0x8C, 0x08, 0x3B, 0x7B, 0x20, 0x1A, 0x0E, 0x3F, 0xA4,
  0x03, 0xC0, 0x33, 0xB7, 0xB3, 0x09, 0xA0, 0x52, 0xF9, 0x0D, 0x50, 0xEA, 0x0E, 0x4B, 0x7B, 0x30,
  0x3A, 0x0C, 0x2F, 0x0D, 0x04, 0x50, 0x9A, 0x09, 0x4B, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_rsvp() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 18, 45, 29), Box(0, 0, 47, 47),
      ic_outlined_48_device_rsvp_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_screen_lock_landscape 48x48, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_outlined_48_device_screen_lock_landscape_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDF, 0x97, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x48,
  0x41, 0xAD, 0xDA, 0x17, 0x4F, 0xFA, 0x73, 0x86, 0x1E, 0xFA, 0xAF, 0xE1, 0x73, 0xFF, 0xA7, 0x38,
  0x1A, 0xF3, 0x28, 0x13, 0xFA, 0x73, 0xFF, 0xA7, 0x30, 0xD0, 0xA4, 0x0A, 0x0D, 0x73, 0xFF, 0xA7,
  0x39, 0x09, 0x40, 0x99, 0x73, 0xFF, 0xA7, 0x39, 0x09, 0x40, 0x99, 0x73, 0xFF, 0xA7, 0x10, 0x40,
  0xDF, 0x90, 0xD0, 0x47, 0x1F, 0xFA, 0x71, 0x0D, 0xFB, 0x0D, 0x71, 0xFF, 0xA7, 0x1F, 0xD7, 0x1F,
  0xFA, 0x71, 0xFD, 0x71, 0xFF, 0xA7, 0x1F, 0xD7, 0x1F, 0xFA, 0x71, 0xFD, 0x71, 0xFF, 0xA7, 0x1F,
  0xD7, 0x1F, 0xFA, 0x71, 0xFD, 0x71, 0xFF, 0xA7, 0x10, 0xDF, 0xB0, 0xD7, 0x1F, 0xFA, 0x71, 0x04,
  0x0D, 0xF9, 0x0D, 0x04, 0x71, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xF9, 0x0D, 0x80, 0xC6,
  0xF0, 0xD0, 0xA8, 0x0C, 0x6F, 0x81, 0xA1, 0xE8, 0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC0,
  0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_screen_lock_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_outlined_48_device_screen_lock_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_screen_lock_portrait 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_outlined_48_device_screen_lock_portrait_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0xA1, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0x9E, 0x0F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x78, 0x41, 0xAD, 0xDA, 0x17, 0xF9, 0x68, 0x61, 0xEF, 0xAA,
  0xFE, 0x16, 0xF9, 0x68, 0x1A, 0xF3, 0x28, 0x13, 0xFA, 0x6F, 0x96, 0x0D, 0x0A, 0x40, 0xA0, 0xD6,
  0xF9, 0x69, 0x09, 0x40, 0x99, 0x6F, 0x96, 0x90, 0x94, 0x09, 0x96, 0xF9, 0x40, 0x40, 0xDF, 0x90,
  0xD0, 0x44, 0xF9, 0x40, 0xDF, 0xB0, 0xD4, 0xF9, 0x4F, 0xD4, 0xF9, 0x4F, 0xD4, 0xF9, 0x4F, 0xD4,
  0xF9, 0x4F, 0xD4, 0xF9, 0x4F, 0xD4, 0xF9, 0x4F, 0xD4, 0xF9, 0x40, 0xDF, 0xB0, 0xD4, 0xF9, 0x40,
  0x40, 0xDF, 0x90, 0xD0, 0x44, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x0F, 0x0D, 0xFF, 0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1,
  0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_screen_lock_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_screen_lock_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_screen_lock_rotation 48x48, 4-bit Alpha,  RLE, 461 bytes.
static const unsigned char ic_outlined_48_device_screen_lock_rotation_data[] PROGMEM = {
  0x77, 0x38, 0x12, 0x52, 0x75, 0x84, 0x3B, 0xEE, 0xB5, 0x77, 0x73, 0x09, 0xB0, 0x77, 0x38, 0x66,
  0xFE, 0xBA, 0xEF, 0x97, 0x77, 0x10, 0xAD, 0x08, 0x71, 0x82, 0x3F, 0xC1, 0x38, 0x1A, 0xF6, 0x77,
  0x60, 0xAF, 0x08, 0x78, 0x19, 0xF2, 0x50, 0x0D, 0x77, 0x50, 0xAF, 0xA0, 0x86, 0x0D, 0x0C, 0x60,
  0x99, 0x77, 0x40, 0xAC, 0x81, 0xD4, 0xEC, 0x08, 0x50, 0xD0, 0xA6, 0x81, 0x7F, 0x17, 0x72, 0x0A,
  0xC8, 0x3D, 0x10, 0x2E, 0xC0, 0x32, 0x03, 0x0D, 0xFB, 0x0E, 0x05, 0x77, 0x0A, 0xC0, 0xD0, 0x13,
  0x02, 0x0E, 0xA0, 0x53, 0x0C, 0xFD, 0x0E, 0x76, 0x0A, 0xC0, 0xD0, 0x15, 0x81, 0x2D, 0x54, 0x0D,
  0xFE, 0x01, 0x74, 0x0A, 0xC0, 0xD0, 0x17, 0x60, 0xDF, 0xE0, 0x17, 0x30, 0xAC, 0x0D, 0x01, 0x77,
  0x0D, 0xFE, 0x01, 0x72, 0x0A, 0xC0, 0xD0, 0x17, 0x71, 0x0D, 0xFE, 0x01, 0x71, 0x0A, 0xC0, 0xD0,
  0x17, 0x72, 0x0D, 0xFE, 0x01, 0x70, 0xAC, 0x0D, 0x01, 0x77, 0x30, 0xDF, 0xE0, 0x16, 0x08, 0xC0,
  0xD0, 0x17, 0x74, 0x0D, 0xFE, 0x01, 0x50, 0x1C, 0x0D, 0x01, 0x77, 0x50, 0xDF, 0xE0, 0x15, 0x03,
  0xC0, 0x67, 0x76, 0x0C, 0xFD, 0x0E, 0x70, 0xEC, 0x04, 0x77, 0x50, 0x30, 0xDF, 0xB0, 0xE0, 0x57,
  0x05, 0xD0, 0x48, 0x0C, 0x40, 0x05, 0xD0, 0x48, 0x0C, 0x40, 0x05, 0xD0, 0x47, 0x77, 0x60, 0x57,
  0x50, 0x5D, 0x04, 0x77, 0x74, 0x81, 0x9F, 0x87, 0x50, 0x5D, 0x04, 0x77, 0x72, 0x09, 0xB0, 0x87,
  0x50, 0x5D, 0x04, 0x77, 0x70, 0x10, 0xEC, 0x08, 0x30, 0xCA, 0x02, 0x50, 0x5D, 0x04, 0x77, 0x70,
  0x20, 0xEC, 0x08, 0x20, 0xAA, 0x05, 0x60, 0x5D, 0x04, 0x77, 0x70, 0x20, 0xEC, 0x81, 0x80, 0x8A,
  0x07, 0x70, 0x5D, 0x04, 0x77, 0x70, 0x20, 0xEC, 0x03, 0x05, 0xA0, 0xC7, 0x10, 0x5D, 0x04, 0x77,
  0x70, 0x3C, 0x06, 0x01, 0xB0, 0x17, 0x10, 0x5D, 0x04, 0x77, 0x60, 0xBC, 0x81, 0x40, 0xBA, 0x06,
  0x72, 0x05, 0xD0, 0x47, 0x74, 0x0B, 0xC0, 0xB2, 0x06, 0xA0, 0xD7, 0x30, 0x5D, 0x04, 0x77, 0x20,
  0xBC, 0x0C, 0x01, 0x30, 0xEA, 0x04, 0x73, 0x05, 0xD0, 0x47, 0x70, 0xBC, 0x0C, 0x01, 0x40, 0x8A,
  0x0D, 0x74, 0x05, 0xD0, 0x47, 0x50, 0xBC, 0x0C, 0x01, 0x50, 0x10, 0xEA, 0x07, 0x74, 0x05, 0xD0,
  0x47, 0x30, 0xBC, 0x0C, 0x01, 0x70, 0x7B, 0x03, 0x74, 0x05, 0xD0, 0x47, 0x10, 0xBC, 0x0C, 0x01,
  0x72, 0x0C, 0xA0, 0xD0, 0x17, 0x40, 0x5D, 0x04, 0x60, 0xBC, 0x0C, 0x01, 0x73, 0x02, 0x0E, 0xA0,
  0xC0, 0x17, 0x40, 0x5D, 0x04, 0x40, 0xBC, 0x0C, 0x01, 0x75, 0x04, 0xB0, 0xC0, 0x17, 0x40, 0x5D,
  0x04, 0x20, 0xBC, 0x0C, 0x01, 0x77, 0x06, 0xB0, 0xD0, 0x35, 0x06, 0x01, 0x40, 0x5D, 0x05, 0x0B,
  0xC0, 0xC0, 0x17, 0x72, 0x06, 0xC0, 0x73, 0x82, 0x7F, 0xC1, 0x40, 0x5F, 0xA0, 0xC0, 0x17, 0x74,
  0x04, 0x0E, 0xB8, 0x1D, 0x57, 0xB0, 0xC0, 0x14, 0x05, 0xF0, 0xC0, 0x17, 0x76, 0x02, 0x0C, 0xFA,
  0x0C, 0x01, 0x40, 0x5D, 0x0C, 0x01, 0x77, 0x72, 0x07, 0x0E, 0xF9, 0x0C, 0x01, 0x40, 0x50, 0xEA,
  0x0B, 0x01, 0x77, 0x74, 0x81, 0x18, 0xEF, 0x0C, 0x01, 0x48, 0x11, 0x53, 0x77, 0x77, 0x18, 0x11,
  0x6C, 0xE0, 0xC0, 0x18, 0x0C, 0x20, 0x87, 0x15, 0x8B, 0xDE, 0xFC, 0x17, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_screen_lock_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 45, 47), Box(0, 0, 47, 47),
      ic_outlined_48_device_screen_lock_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_screen_rotation 48x48, 4-bit Alpha,  RLE, 512 bytes.
static const unsigned char ic_outlined_48_device_screen_rotation_data[] PROGMEM = {
  0x77, 0x71, 0x87, 0x1C, 0xFE, 0xDB, 0x85, 0x18, 0x0C, 0x40, 0x01, 0x0C, 0xE8, 0x1C, 0x61, 0x77,
  0x77, 0x38, 0x13, 0x51, 0x40, 0x10, 0xCF, 0x81, 0xE8, 0x17, 0x77, 0x70, 0xAB, 0x06, 0x40, 0x10,
  0xCF, 0x90, 0xE0, 0x77, 0x77, 0x50, 0xBD, 0x07, 0x40, 0x10, 0xCF, 0xA0, 0xC0, 0x27, 0x77, 0x20,
  0xBB, 0x0D, 0xB0, 0x74, 0x01, 0x0C, 0xB8, 0x17, 0x5D, 0xB0, 0xE0, 0x47, 0x77, 0x0B, 0xB8, 0x17,
  0x0B, 0xB0, 0x74, 0x82, 0x1C, 0xF7, 0x30, 0x7C, 0x06, 0x77, 0x50, 0xBB, 0x07, 0x30, 0xBB, 0x07,
  0x40, 0x10, 0x65, 0x03, 0x0D, 0xB0, 0x67, 0x73, 0x0B, 0xB0, 0x75, 0x0B, 0xB0, 0x77, 0x40, 0x10,
  0xCB, 0x04, 0x77, 0x10, 0xBB, 0x07, 0x70, 0xBB, 0x07, 0x74, 0x01, 0x0C, 0xA0, 0xE0, 0x27, 0x60,
  0xBB, 0x07, 0x72, 0x0B, 0xB0, 0x77, 0x40, 0x10, 0xDA, 0x0C, 0x75, 0x0B, 0xB0, 0x77, 0x40, 0xBB,
  0x07, 0x74, 0x03, 0xB0, 0x77, 0x30, 0xBB, 0x07, 0x76, 0x0B, 0xB0, 0x77, 0x40, 0x7A, 0x0E, 0x01,
  0x71, 0x0B, 0xB0, 0x77, 0x71, 0x0B, 0xB0, 0x77, 0x40, 0xDA, 0x08, 0x70, 0xBB, 0x07, 0x77, 0x30,
  0xBB, 0x07, 0x73, 0x04, 0xA0, 0xE6, 0x0B, 0xB0, 0x77, 0x75, 0x0B, 0xB0, 0x77, 0x30, 0xDA, 0x06,
  0x40, 0xAB, 0x07, 0x77, 0x70, 0xBB, 0x07, 0x72, 0x06, 0xA0, 0xB3, 0x03, 0xB0, 0x77, 0x77, 0x20,
  0xBB, 0x07, 0x71, 0x01, 0xB0, 0x12, 0x05, 0xA0, 0xD7, 0x77, 0x40, 0xBB, 0x07, 0x71, 0x0C, 0xA0,
  0x52, 0x01, 0xB0, 0xB7, 0x77, 0x40, 0xBB, 0x07, 0x70, 0x7A, 0x08, 0x30, 0x6B, 0x0B, 0x77, 0x74,
  0x0B, 0xB0, 0x76, 0x05, 0xA0, 0xA4, 0x07, 0xB0, 0xB7, 0x77, 0x40, 0xBB, 0x07, 0x50, 0x2A, 0x0C,
  0x50, 0x7B, 0x0B, 0x77, 0x74, 0x0B, 0xB0, 0x77, 0x70, 0x7B, 0x0B, 0x77, 0x74, 0x0B, 0xB0, 0x77,
  0x70, 0x7B, 0x0B, 0x77, 0x74, 0x0B, 0xB0, 0x77, 0x70, 0x7B, 0x0B, 0x77, 0x74, 0x0B, 0xB0, 0x75,
  0x0C, 0xA0, 0x25, 0x07, 0xB0, 0xB7, 0x77, 0x40, 0xBB, 0x07, 0x40, 0xAA, 0x05, 0x60, 0x7B, 0x0B,
  0x77, 0x74, 0x0B, 0xB0, 0x63, 0x08, 0xA0, 0x77, 0x07, 0xB0, 0xB7, 0x77, 0x40, 0xBB, 0x01, 0x20,
  0x5A, 0x0C, 0x71, 0x07, 0xB0, 0xB7, 0x77, 0x40, 0xDA, 0x05, 0x20, 0x1B, 0x01, 0x71, 0x07, 0xB0,
  0xB7, 0x77, 0x20, 0x7B, 0x03, 0x30, 0xBA, 0x06, 0x72, 0x07, 0xB0, 0xB7, 0x77, 0x07, 0xB0, 0xA4,
  0x06, 0xA0, 0xD7, 0x30, 0x7B, 0x0B, 0x77, 0x50, 0x7B, 0x0B, 0x60, 0xEA, 0x04, 0x73, 0x07, 0xB0,
  0xB7, 0x73, 0x07, 0xB0, 0xB7, 0x08, 0xA0, 0xD7, 0x40, 0x7B, 0x0B, 0x77, 0x10, 0x7B, 0x0B, 0x71,
  0x01, 0x0E, 0xA0, 0x77, 0x40, 0x7B, 0x0B, 0x76, 0x07, 0xB0, 0xB7, 0x30, 0x7B, 0x03, 0x74, 0x07,
  0xB0, 0xB7, 0x40, 0x7B, 0x0B, 0x75, 0x0C, 0xA0, 0xD0, 0x17, 0x40, 0x7B, 0x0B, 0x72, 0x07, 0xB0,
  0xB7, 0x60, 0x20, 0xEA, 0x0C, 0x01, 0x74, 0x07, 0xB0, 0xB7, 0x07, 0xB0, 0xB7, 0x71, 0x04, 0xB0,
  0xC0, 0x17, 0x40, 0x7B, 0x0B, 0x50, 0x7B, 0x0B, 0x77, 0x30, 0x6B, 0x0D, 0x03, 0x50, 0x60, 0x14,
  0x07, 0xB0, 0xB3, 0x07, 0xB0, 0xB7, 0x75, 0x06, 0xC0, 0x73, 0x82, 0x7F, 0xC1, 0x40, 0x7B, 0x81,
  0xB0, 0x7B, 0x0B, 0x77, 0x70, 0x40, 0xEB, 0x81, 0xD5, 0x7B, 0x0C, 0x01, 0x40, 0x7B, 0x0D, 0xB0,
  0xB7, 0x77, 0x20, 0x20, 0xCF, 0xA0, 0xC0, 0x14, 0x07, 0xD0, 0xB7, 0x77, 0x50, 0x70, 0xEF, 0x90,
  0xC0, 0x14, 0x06, 0xB0, 0xA7, 0x77, 0x78, 0x11, 0x8E, 0xF0, 0xC0, 0x14, 0x81, 0x15, 0x37, 0x77,
  0x73, 0x81, 0x16, 0xCE, 0x0C, 0x01, 0x80, 0xC4, 0x08, 0x71, 0x58, 0xBD, 0xEF, 0xC1, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_screen_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 47, 47), Box(0, 0, 47, 47),
      ic_outlined_48_device_screen_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_screen_search_desktop 48x48, 4-bit Alpha,  RLE, 224 bytes.
static const unsigned char ic_outlined_48_device_screen_search_desktop_data[] PROGMEM = {
  0x38, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x50, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x40,
  0xA8, 0x0C, 0x2F, 0x0A, 0x40, 0xD8, 0x0C, 0x2F, 0x0D, 0x4C, 0x77, 0x77, 0x4C, 0x4C, 0x77, 0x77,
  0x4C, 0x4C, 0x77, 0x77, 0x4C, 0x4C, 0x74, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x76, 0xC4, 0xC7, 0x30,
  0x50, 0xEE, 0x0E, 0x04, 0x75, 0xC4, 0xC7, 0x20, 0x5F, 0xB0, 0x47, 0x4C, 0x4C, 0x71, 0x01, 0x0E,
  0xA8, 0x4D, 0x51, 0x15, 0xDA, 0x0E, 0x01, 0x73, 0xC4, 0xC7, 0x10, 0x8A, 0x0D, 0x01, 0x40, 0x10,
  0xDA, 0x07, 0x73, 0xC4, 0xC7, 0x10, 0xCA, 0x05, 0x60, 0x5A, 0x0C, 0x73, 0xC4, 0xC7, 0x10, 0xEA,
  0x01, 0x60, 0x1A, 0x0E, 0x73, 0xC4, 0xC7, 0x10, 0xEA, 0x01, 0x60, 0x1A, 0x0D, 0x73, 0xC4, 0xC7,
  0x10, 0xCA, 0x05, 0x60, 0x5A, 0x0C, 0x73, 0xC4, 0xC7, 0x10, 0x8A, 0x0D, 0x01, 0x40, 0x10, 0xDA,
  0x06, 0x73, 0xC4, 0xC7, 0x10, 0x10, 0xEA, 0x84, 0xD5, 0x11, 0x5D, 0xB7, 0x4C, 0x4C, 0x72, 0x05,
  0xFC, 0x09, 0x73, 0xC4, 0xC7, 0x30, 0x50, 0xEF, 0xB0, 0x97, 0x2C, 0x4C, 0x74, 0x81, 0x18, 0xCA,
  0x82, 0xC7, 0x19, 0xB0, 0x97, 0x1C, 0x4C, 0x77, 0x60, 0x9B, 0x09, 0x7C, 0x4C, 0x77, 0x70, 0x9A,
  0x08, 0x7C, 0x4C, 0x77, 0x71, 0x09, 0x08, 0x71, 0xC4, 0xC7, 0x77, 0x74, 0xC4, 0xC7, 0x77, 0x74,
  0xC4, 0x0D, 0x80, 0xC2, 0xF0, 0xD4, 0x0A, 0x80, 0xC2, 0xF0, 0x94, 0x01, 0x0E, 0x80, 0xC0, 0xF0,
  0xE0, 0x15, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x18, 0x09, 0xA7, 0x08, 0x0A, 0xD4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_screen_search_desktop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_screen_search_desktop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_screenshot_monitor 48x48, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_outlined_48_device_screenshot_monitor_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x2F, 0x97,
  0x77, 0x1F, 0x92, 0xF9, 0x77, 0x71, 0xF9, 0x2F, 0x97, 0x77, 0x1F, 0x92, 0xB7, 0x77, 0x6F, 0x92,
  0xB7, 0x77, 0x6F, 0x92, 0xB7, 0x77, 0x6F, 0x92, 0xB7, 0x77, 0x6F, 0x92, 0xB7, 0x77, 0x6F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x6B,
  0x2F, 0x97, 0x77, 0x6B, 0x2F, 0x97, 0x77, 0x6B, 0x2F, 0x97, 0x77, 0x6B, 0x2F, 0x97, 0x77, 0x6B,
  0x2F, 0x97, 0x77, 0x1F, 0x92, 0xF9, 0x77, 0x71, 0xF9, 0x2F, 0x97, 0x77, 0x1F, 0x92, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E,
  0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x17, 0x6F, 0xFA, 0x77, 0x73,
  0xFF, 0xA7, 0x77, 0x3F, 0xFA, 0x77, 0x73, 0xFF, 0xA7, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_screenshot_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_screenshot_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_screenshot 48x48, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_outlined_48_device_screenshot_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x92, 0xF9, 0x73, 0xF9, 0x2F, 0x97, 0x3F, 0x92, 0xF9, 0x73, 0xF9, 0x2B, 0x77, 0x1F, 0x92, 0xB7,
  0x71, 0xF9, 0x2B, 0x77, 0x1F, 0x92, 0xB7, 0x71, 0xF9, 0x2B, 0x77, 0x1F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x71, 0xB2, 0xF9, 0x77, 0x1B, 0x2F, 0x97, 0x71, 0xB2,
  0xF9, 0x77, 0x1B, 0x2F, 0x97, 0x71, 0xB2, 0xF9, 0x73, 0xF9, 0x2F, 0x97, 0x3F, 0x92, 0xF9, 0x73,
  0xF9, 0x2F, 0x97, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6C, 0x0D, 0xFF,
  0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81,
  0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_screenshot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_screenshot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_sd_storage 48x48, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_outlined_48_device_sd_storage_data[] PROGMEM = {
  0x74, 0x07, 0xFF, 0xA8, 0x1D, 0xA1, 0x74, 0x07, 0xFF, 0xD0, 0xE0, 0x17, 0x20, 0x7F, 0xFF, 0x0A,
  0x71, 0x07, 0xFF, 0xF9, 0x0D, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0xC6, 0x07, 0xC0, 0xE0, 0x37, 0x71,
  0xC5, 0x07, 0xC0, 0xE0, 0x37, 0x72, 0xC4, 0x07, 0xC0, 0xE0, 0x37, 0x73, 0xC3, 0x07, 0xC0, 0xE0,
  0x37, 0x74, 0xC2, 0x07, 0xC0, 0xE0, 0x37, 0x75, 0xC1, 0x07, 0xC0, 0xE0, 0x32, 0xC2, 0xC2, 0xC2,
  0xC0, 0x7C, 0x0E, 0x03, 0x3C, 0x2C, 0x2C, 0x2F, 0x90, 0xE0, 0x34, 0xC2, 0xC2, 0xC2, 0xF9, 0x03,
  0x5C, 0x2C, 0x2C, 0x2F, 0x96, 0xC2, 0xC2, 0xC2, 0xF9, 0x6C, 0x2C, 0x2C, 0x2F, 0x96, 0xC2, 0xC2,
  0xC2, 0xF9, 0x6C, 0x2C, 0x2C, 0x2F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97,
  0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77,
  0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F,
  0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3C, 0x0D, 0xFF, 0xFF, 0xA0,
  0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1, 0xEF, 0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_sd_storage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_sd_storage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_security_update_good 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_outlined_48_device_security_update_good_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x02, 0x05, 0x4F, 0x97, 0x68, 0x22, 0xDF,
  0x63, 0xF9, 0x75, 0x02, 0x0D, 0xB0, 0x62, 0xF9, 0x74, 0x02, 0x0D, 0xC0, 0x92, 0xF9, 0x50, 0x34,
  0x02, 0x0D, 0xC0, 0x93, 0xF9, 0x48, 0x1A, 0xE4, 0x20, 0x20, 0xDC, 0x09, 0x4F, 0x93, 0x0A, 0xA8,
  0x2E, 0x42, 0xDC, 0x09, 0x5F, 0x92, 0x04, 0xC0, 0xE0, 0xDC, 0x09, 0x6F, 0x93, 0x06, 0xF9, 0x09,
  0x7F, 0x94, 0x06, 0xE0, 0x97, 0x1F, 0x95, 0x06, 0xC0, 0x97, 0x2F, 0x96, 0x06, 0xA0, 0x97, 0x3F,
  0x97, 0x06, 0x09, 0x74, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0x80, 0x9E, 0x4F, 0x77, 0x6F, 0x97, 0x76, 0xC0, 0xDF, 0xFF, 0xD0, 0xD0, 0xAF,
  0xFF, 0xD8, 0x1A, 0x1E, 0xFF, 0xFB, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_security_update_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_security_update_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_security_update 48x48, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_outlined_48_device_security_update_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9,
  0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x40, 0x70, 0x32, 0xC2, 0x03, 0x07, 0x4F, 0x93, 0x82,
  0x7F, 0xE3, 0x1C, 0x18, 0x23, 0xEF, 0x73, 0xF9, 0x20, 0x7B, 0x0E, 0x03, 0xC0, 0x30, 0xEB, 0x07,
  0x2F, 0x92, 0x07, 0xC0, 0xEC, 0x0E, 0xC0, 0x72, 0xF9, 0x30, 0x7F, 0xD0, 0x73, 0xF9, 0x40, 0x7F,
  0xB0, 0x74, 0xF9, 0x50, 0x7F, 0x90, 0x75, 0xF9, 0x60, 0x7E, 0x07, 0x6F, 0x97, 0x07, 0xC0, 0x77,
  0xF9, 0x71, 0x07, 0xA0, 0x77, 0x1F, 0x97, 0x20, 0x07, 0x72, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x4F, 0x77, 0x6F, 0x97, 0x76, 0xC0, 0xDF, 0xFF, 0xD0, 0xD0,
  0xAF, 0xFF, 0xD8, 0x1A, 0x1E, 0xFF, 0xFB, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_security_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_security_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_security_update_warning 48x48, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_outlined_48_device_security_update_warning_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C,
  0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9,
  0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97,
  0x76, 0xF9, 0x77, 0x6F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71,
  0xC7, 0x1F, 0x97, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6C, 0x0D, 0xFF,
  0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81,
  0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_security_update_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_security_update_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_sell 48x48, 4-bit Alpha,  RLE, 305 bytes.
static const unsigned char ic_outlined_48_device_sell_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x81, 0xEB, 0x57, 0x75, 0x01, 0x0E, 0xFF, 0xD0, 0x77, 0x74, 0x0A, 0xFF,
  0xF0, 0x77, 0x73, 0x0D, 0xFF, 0xF9, 0x07, 0x77, 0x2C, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0xC7,
  0x71, 0x03, 0x0E, 0xC0, 0x77, 0x7C, 0x38, 0x28, 0xDD, 0x87, 0x20, 0x30, 0xEC, 0x07, 0x76, 0xC2,
  0x08, 0xC0, 0x87, 0x20, 0x30, 0xEC, 0x07, 0x75, 0xC2, 0x0D, 0xC0, 0xD7, 0x30, 0x30, 0xEC, 0x07,
  0x74, 0xC2, 0x0D, 0xC0, 0xD7, 0x40, 0x30, 0xEC, 0x07, 0x73, 0xC2, 0x08, 0xC0, 0x87, 0x50, 0x30,
  0xEC, 0x07, 0x72, 0xC3, 0x82, 0x8D, 0xD8, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x1C, 0x77, 0x71, 0x03,
  0x0E, 0xC0, 0x77, 0xC7, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x6C, 0x77, 0x73, 0x03, 0x0E, 0xC0, 0x75,
  0xC7, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x4C, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x73, 0xC7, 0x77, 0x60,
  0x30, 0xEC, 0x07, 0x20, 0xEB, 0x03, 0x77, 0x76, 0x03, 0x0E, 0xC8, 0x17, 0x0B, 0xB0, 0xE0, 0x37,
  0x77, 0x60, 0x30, 0xEC, 0x00, 0x4C, 0x0E, 0x03, 0x77, 0x76, 0x03, 0x0E, 0xB8, 0x1B, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x60, 0x4B, 0x0E, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x75, 0x0C, 0xB0, 0xD3, 0x07,
  0xC0, 0xE0, 0x37, 0x77, 0x30, 0xCC, 0x07, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x71, 0x0C, 0xC0, 0xB6,
  0x07, 0xC0, 0xE0, 0x37, 0x76, 0x0C, 0xC0, 0xB7, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x40, 0xCC, 0x0B,
  0x73, 0x07, 0xC0, 0xE0, 0x37, 0x72, 0x0C, 0xC0, 0xB7, 0x50, 0x7C, 0x0E, 0x03, 0x77, 0x0C, 0xC0,
  0xB7, 0x70, 0x7C, 0x0E, 0x03, 0x75, 0x0C, 0xC0, 0xB7, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x30, 0xCC,
  0x0B, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x71, 0x0C, 0xC0, 0xB7, 0x76, 0x07, 0xC0, 0xE0, 0x36, 0x0C,
  0xC0, 0xB7, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x40, 0xCC, 0x0B, 0x77, 0x73, 0x07, 0xC0, 0xE0, 0x32,
  0x0C, 0xC0, 0xB7, 0x77, 0x50, 0x7C, 0x81, 0xE4, 0xCC, 0x0B, 0x77, 0x77, 0x07, 0xFA, 0x0B, 0x77,
  0x77, 0x20, 0x7F, 0x0B, 0x77, 0x77, 0x40, 0x7D, 0x0B, 0x77, 0x77, 0x68, 0x34, 0xBE, 0xC7, 0x77,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_sell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_sell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_send_to_mobile 48x48, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_outlined_48_device_send_to_mobile_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0xFF, 0xE8, 0x1D, 0xA1, 0x70, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x16, 0x0A, 0xFF,
  0xFD, 0x0A, 0x60, 0xDF, 0xFF, 0xD0, 0xD6, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC6, 0xFF, 0xFF, 0x6F,
  0xFF, 0xF6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC6, 0xC7, 0x77, 0x72,
  0xC7, 0x77, 0x72, 0xC7, 0x77, 0x00, 0x77, 0xC7, 0x76, 0x07, 0xA0, 0x76, 0xC7, 0x75, 0x07, 0xC0,
  0x75, 0xC7, 0x75, 0x03, 0x0E, 0xC0, 0x74, 0xC7, 0x76, 0x03, 0x0E, 0xC0, 0x73, 0xC7, 0x77, 0x03,
  0x0E, 0xC0, 0x72, 0xC7, 0x5F, 0xFA, 0x07, 0x1C, 0x75, 0xFF, 0xB0, 0x7C, 0x75, 0xFF, 0xB0, 0x7C,
  0x75, 0xFF, 0xA0, 0x71, 0xC7, 0x77, 0x03, 0x0E, 0xC0, 0x72, 0xC7, 0x76, 0x03, 0x0E, 0xC0, 0x73,
  0xC7, 0x75, 0x03, 0x0E, 0xC0, 0x74, 0xC7, 0x75, 0x07, 0xC0, 0x75, 0xC7, 0x76, 0x07, 0xA0, 0x76,
  0xC7, 0x77, 0x00, 0x77, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC6,
  0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC6,
  0x0D, 0xFF, 0xFD, 0x0D, 0x60, 0xAF, 0xFF, 0xD0, 0xA6, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x78,
  0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_send_to_mobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_send_to_mobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_settings_suggest 48x48, 4-bit Alpha,  RLE, 428 bytes.
static const unsigned char ic_outlined_48_device_settings_suggest_data[] PROGMEM = {
  0x77, 0x77, 0x50, 0x03, 0x80, 0xC5, 0x00, 0x0A, 0x80, 0xC4, 0x00, 0x2A, 0x02, 0x80, 0xC3, 0x00,
  0x9A, 0x09, 0x80, 0xC2, 0x00, 0x10, 0xEA, 0x0E, 0x01, 0x77, 0x77, 0x78, 0x12, 0x9E, 0xC8, 0x1E,
  0x92, 0x77, 0x77, 0x30, 0x30, 0xAF, 0xB0, 0xA0, 0x37, 0x77, 0x71, 0x03, 0x0A, 0xFB, 0x0A, 0x03,
  0x76, 0x01, 0xFB, 0x01, 0x68, 0x12, 0x9E, 0xC8, 0x1E, 0x92, 0x77, 0x10, 0x2F, 0xB0, 0x27, 0x10,
  0x10, 0xEA, 0x0E, 0x01, 0x77, 0x30, 0x4F, 0xB0, 0x47, 0x20, 0x9A, 0x09, 0x75, 0x02, 0x50, 0x6F,
  0xB0, 0x65, 0x02, 0x30, 0x2A, 0x02, 0x75, 0x82, 0xCE, 0x82, 0x20, 0x9B, 0x07, 0x20, 0x7B, 0x09,
  0x28, 0x22, 0x8E, 0xC4, 0x00, 0xA7, 0x50, 0x6C, 0x00, 0xAC, 0x05, 0x20, 0x5C, 0x0A, 0x0B, 0xC0,
  0x63, 0x00, 0x37, 0x40, 0x10, 0xEF, 0xB0, 0x32, 0x03, 0xFB, 0x0E, 0x01, 0x77, 0x10, 0x8F, 0xB0,
  0xE0, 0x12, 0x01, 0x0D, 0xFB, 0x08, 0x77, 0x02, 0xC0, 0xEC, 0x0C, 0x04, 0x60, 0x40, 0xCC, 0x0D,
  0xC0, 0x27, 0x60, 0xBB, 0x84, 0xD0, 0x3A, 0xF9, 0x73, 0x84, 0x8F, 0x93, 0x0D, 0xB0, 0xB7, 0x50,
  0x4C, 0x05, 0x30, 0x13, 0x84, 0x6C, 0xEE, 0xC6, 0x70, 0x4C, 0x04, 0x40, 0x03, 0x50, 0xDC, 0x04,
  0x50, 0x10, 0xCE, 0x0C, 0x01, 0x50, 0x4C, 0x0D, 0x40, 0x0A, 0x40, 0x20, 0xDD, 0x07, 0x40, 0xCF,
  0x90, 0xC4, 0x07, 0xD0, 0xD0, 0x22, 0x02, 0xA0, 0x24, 0x01, 0x0B, 0xD0, 0xA2, 0x06, 0xFB, 0x06,
  0x20, 0xAD, 0x0B, 0x01, 0x20, 0x20, 0xBA, 0x0B, 0x02, 0x50, 0x7C, 0x0A, 0x20, 0xCB, 0x82, 0xB1,
  0x1B, 0xB0, 0xC2, 0x09, 0xC0, 0x72, 0x03, 0x0A, 0xE0, 0xA0, 0x34, 0x08, 0xB0, 0x82, 0x0E, 0xB0,
  0x12, 0x01, 0xB0, 0xE2, 0x08, 0xB0, 0x83, 0x03, 0x0A, 0xE0, 0xA0, 0x34, 0x08, 0xB0, 0x82, 0x0E,
  0xB0, 0x12, 0x01, 0xB0, 0xE2, 0x08, 0xB0, 0x85, 0x02, 0x0B, 0xA0, 0xB0, 0x25, 0x07, 0xC0, 0xA2,
  0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x20, 0xAC, 0x07, 0x50, 0x2A, 0x02, 0x40, 0x10, 0xBD, 0x0A,
  0x20, 0x6F, 0xB0, 0x62, 0x09, 0xD0, 0xB0, 0x14, 0x00, 0xA4, 0x02, 0x0D, 0xD0, 0x84, 0x0C, 0xF9,
  0x0C, 0x40, 0x7D, 0x0D, 0x02, 0x30, 0x03, 0x50, 0xDC, 0x04, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x50,
  0x3C, 0x0D, 0x74, 0x04, 0xC0, 0x57, 0x84, 0x6C, 0xEE, 0xC6, 0x70, 0x5C, 0x04, 0x75, 0x0B, 0xB8,
  0x4D, 0x03, 0x9F, 0x87, 0x38, 0x48, 0xF9, 0x30, 0xDB, 0x0B, 0x76, 0x02, 0xC0, 0xDC, 0x0C, 0x04,
  0x60, 0x40, 0xCC, 0x0D, 0xC0, 0x27, 0x70, 0x8F, 0xB0, 0xD0, 0x12, 0x01, 0x0D, 0xFB, 0x08, 0x77,
  0x10, 0x10, 0xEF, 0xB0, 0x32, 0x03, 0xFB, 0x0E, 0x01, 0x77, 0x20, 0x6C, 0x0B, 0x0A, 0xC0, 0x52,
  0x05, 0xC0, 0x0A, 0xC0, 0x67, 0x74, 0x82, 0xCE, 0x82, 0x20, 0x9B, 0x07, 0x20, 0x7B, 0x09, 0x28,
  0x21, 0x8E, 0xC7, 0x75, 0x02, 0x50, 0x6F, 0xB0, 0x65, 0x01, 0x77, 0x74, 0x04, 0xFB, 0x04, 0x77,
  0x77, 0x30, 0x2F, 0xB0, 0x27, 0x77, 0x73, 0x01, 0xFB, 0x01, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_settings_suggest() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_settings_suggest_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_settings_system_daydream 48x48, 4-bit Alpha,  RLE, 245 bytes.
static const unsigned char ic_outlined_48_device_settings_system_daydream_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x77, 0x86, 0x39, 0xCE, 0xFD, 0x93, 0x77, 0xF9, 0x75, 0x01, 0x0B,
  0xF9, 0x0B, 0x02, 0x75, 0xF9, 0x74, 0x03, 0x0E, 0xFB, 0x0E, 0x03, 0x74, 0xF9, 0x73, 0x01, 0x0D,
  0xFD, 0x0E, 0x02, 0x73, 0xF9, 0x71, 0x81, 0x28, 0xDC, 0x84, 0xB4, 0x11, 0x4B, 0xC0, 0xB7, 0x3F,
  0x97, 0x09, 0xE0, 0x86, 0x08, 0xC0, 0x37, 0x2F, 0x96, 0x0B, 0xE0, 0xB7, 0x10, 0xBB, 0x81, 0xD7,
  0x17, 0xF9, 0x50, 0x9F, 0x03, 0x71, 0x05, 0xD0, 0xE0, 0x46, 0xF9, 0x40, 0x2C, 0x0D, 0x05, 0x75,
  0xF0, 0x55, 0xF9, 0x40, 0x8B, 0x0D, 0x01, 0x76, 0x0D, 0xE0, 0xE0, 0x14, 0xF9, 0x40, 0xCB, 0x05,
  0x77, 0x20, 0x10, 0x7C, 0x07, 0x4F, 0x94, 0x0E, 0xB0, 0x17, 0x74, 0x07, 0xB0, 0xC4, 0xF9, 0x40,
  0xEB, 0x01, 0x77, 0x40, 0x1B, 0x0E, 0x4F, 0x94, 0x0C, 0xB0, 0x57, 0x74, 0x01, 0xB0, 0xE4, 0xF9,
  0x40, 0x8B, 0x0D, 0x01, 0x77, 0x30, 0x7B, 0x0C, 0x4F, 0x94, 0x02, 0xC8, 0x1D, 0x51, 0x76, 0x01,
  0x07, 0xC0, 0x74, 0xF9, 0x50, 0x9F, 0xFF, 0xB0, 0xE0, 0x14, 0xF9, 0x60, 0xBF, 0xFF, 0xA0, 0x55,
  0xF9, 0x70, 0x9F, 0xFE, 0x0E, 0x05, 0x6F, 0x97, 0x18, 0x22, 0x8C, 0xEF, 0xE8, 0x2E, 0xC7, 0x17,
  0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xD8,
  0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8,
  0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_settings_system_daydream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_settings_system_daydream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_share_location 48x48, 4-bit Alpha,  RLE, 378 bytes.
static const unsigned char ic_outlined_48_device_share_location_data[] PROGMEM = {
  0x77, 0x82, 0x26, 0x9B, 0x48, 0x2C, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x6C, 0xB0, 0xE4, 0x0E, 0xB8,
  0x1D, 0x81, 0x77, 0x70, 0x80, 0xED, 0x0E, 0x40, 0xEE, 0x08, 0x01, 0x77, 0x30, 0x30, 0xDF, 0x0E,
  0x40, 0xEF, 0x0E, 0x04, 0x77, 0x10, 0x7F, 0x81, 0xA7, 0x34, 0x82, 0x36, 0xAE, 0xE0, 0x57, 0x60,
  0x9D, 0x81, 0xD7, 0x17, 0x40, 0x60, 0xDB, 0x0A, 0x76, 0x09, 0xD0, 0x87, 0x72, 0x81, 0x7F, 0xA7,
  0x60, 0x7C, 0x0E, 0x03, 0x77, 0x40, 0x25, 0x05, 0x70, 0x3C, 0x0D, 0x02, 0x77, 0x73, 0x81, 0x9F,
  0x56, 0x0D, 0xB0, 0xE0, 0x17, 0x77, 0x30, 0x9A, 0x0E, 0x01, 0x40, 0x7C, 0x04, 0x71, 0x86, 0x28,
  0xCE, 0xEC, 0x82, 0x71, 0x02, 0xC0, 0x94, 0x0E, 0xB0, 0x87, 0x10, 0x9F, 0x90, 0x97, 0x10, 0x7C,
  0x01, 0x20, 0x7B, 0x0E, 0x71, 0x0B, 0xFB, 0x0B, 0x71, 0x0D, 0xB0, 0x82, 0x0C, 0xB0, 0x77, 0x09,
  0xFD, 0x09, 0x70, 0x5B, 0x81, 0xD0, 0x1C, 0x01, 0x60, 0x2F, 0xF0, 0x27, 0x0E, 0xB0, 0x30, 0x5B,
  0x0B, 0x70, 0x8E, 0x00, 0xCE, 0x08, 0x70, 0x9B, 0x07, 0x09, 0xB0, 0x77, 0x0C, 0xD0, 0x62, 0x06,
  0xD0, 0xC7, 0x06, 0xB0, 0x0A, 0xB0, 0x47, 0x0E, 0xC0, 0xE4, 0x0E, 0xC0, 0xE7, 0x03, 0xB0, 0xD0,
  0xCB, 0x03, 0x7E, 0x4E, 0x75, 0x0D, 0xB0, 0x17, 0x0D, 0xD8, 0x2A, 0x11, 0xAD, 0x0D, 0x75, 0x0D,
  0xB0, 0x17, 0x09, 0xFF, 0x09, 0x75, 0x0C, 0xB0, 0x37, 0x02, 0xFF, 0x02, 0x75, 0x0A, 0xB0, 0x47,
  0x10, 0xAF, 0xD0, 0xA7, 0x10, 0x3B, 0x0D, 0x09, 0xB0, 0x77, 0x10, 0x10, 0xEF, 0xB0, 0xE0, 0x17,
  0x10, 0x6B, 0x0A, 0x05, 0xB0, 0xB7, 0x20, 0x5F, 0xB0, 0x57, 0x20, 0x9B, 0x07, 0x01, 0xC0, 0x17,
  0x20, 0x8F, 0x90, 0x87, 0x30, 0xEB, 0x81, 0x30, 0xCB, 0x07, 0x73, 0x0A, 0xE0, 0xA7, 0x30, 0x5B,
  0x0D, 0x20, 0x7B, 0x0E, 0x74, 0x0A, 0xC0, 0xA7, 0x40, 0xDB, 0x08, 0x30, 0xEB, 0x08, 0x74, 0x0A,
  0xA0, 0xA7, 0x40, 0x7C, 0x01, 0x30, 0x7C, 0x04, 0x74, 0x00, 0x87, 0x40, 0x2C, 0x09, 0x50, 0xDB,
  0x0E, 0x01, 0x77, 0x73, 0x09, 0xA0, 0xE0, 0x15, 0x03, 0xC0, 0xD0, 0x27, 0x77, 0x38, 0x19, 0xF5,
  0x70, 0x7C, 0x0E, 0x03, 0x77, 0x40, 0x25, 0x05, 0x72, 0x09, 0xD0, 0x87, 0x72, 0x81, 0x7F, 0xA7,
  0x71, 0x09, 0xD8, 0x1D, 0x71, 0x74, 0x06, 0x0D, 0xB0, 0xA7, 0x71, 0x07, 0xF8, 0x1A, 0x73, 0x48,
  0x23, 0x6A, 0xEE, 0x05, 0x77, 0x10, 0x30, 0xDF, 0x0E, 0x40, 0xEF, 0x0E, 0x04, 0x77, 0x40, 0x80,
  0xED, 0x0E, 0x40, 0xEE, 0x08, 0x01, 0x77, 0x68, 0x11, 0x6C, 0xB0, 0xE4, 0x0E, 0xB8, 0x1D, 0x81,
  0x77, 0x74, 0x82, 0x26, 0x9B, 0x48, 0x2C, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_share_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_share_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_shortcut 48x48, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_outlined_48_device_shortcut_data[] PROGMEM = {
  0x77, 0x72, 0x00, 0x77, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x77, 0x72,
  0x03, 0x0E, 0xC0, 0x77, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x77,
  0x77, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x72, 0x03, 0x0E,
  0xC0, 0x77, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x18, 0x25, 0x9D, 0xEF, 0xFF, 0xB0, 0x75, 0x04,
  0x0D, 0xFF, 0xFF, 0x90, 0x73, 0x08, 0xFF, 0xFF, 0xB0, 0x72, 0x08, 0xFF, 0xFF, 0xB0, 0x72, 0x04,
  0xD0, 0x80, 0x37, 0x74, 0x03, 0x0E, 0xC0, 0x73, 0x0D, 0xB0, 0xD0, 0x37, 0x75, 0x03, 0x0E, 0xC0,
  0x73, 0x05, 0xC0, 0x37, 0x75, 0x03, 0x0E, 0xC0, 0x74, 0x09, 0xB0, 0x87, 0x75, 0x03, 0x0E, 0xC0,
  0x75, 0x0D, 0xB0, 0x37, 0x74, 0x03, 0x0E, 0xC0, 0x76, 0x0E, 0xB7, 0x74, 0x03, 0x0E, 0xC0, 0x77,
  0xC7, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x1C, 0x77, 0x30, 0x7C, 0x07, 0x72, 0xC7, 0x74, 0x07, 0xA0,
  0x77, 0x3C, 0x77, 0x50, 0x07, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7, 0x77, 0x74, 0xC7,
  0x77, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_shortcut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 10, 41, 37), Box(0, 0, 47, 47),
      ic_outlined_48_device_shortcut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_0_bar 48x48, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_0_bar_data[] PROGMEM = {
  0x80, 0xC3, 0x00, 0x78, 0x0C, 0x20, 0x07, 0x98, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x00, 0x07, 0xB7,
  0x77, 0x77, 0x07, 0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xE7, 0x77, 0x74, 0x07, 0xF7,
  0x77, 0x73, 0x07, 0xF9, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0xC7, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x3C,
  0x77, 0x77, 0x07, 0xC0, 0xE0, 0x31, 0xC7, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x2C, 0x77, 0x75, 0x07,
  0xC0, 0xE0, 0x33, 0xC7, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x4C, 0x77, 0x73, 0x07, 0xC0, 0xE0, 0x35,
  0xC7, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x6C, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0xC7, 0x77, 0x07,
  0xC0, 0xE0, 0x37, 0x1C, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x72, 0xC7, 0x75, 0x07, 0xC0, 0xE0, 0x37,
  0x3C, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x74, 0xC7, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x5C, 0x77, 0x20,
  0x7C, 0x0E, 0x03, 0x76, 0xC7, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x7C, 0x77, 0x07, 0xC0, 0xE0, 0x37,
  0x71, 0xC7, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x2C, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x73, 0xC7, 0x40,
  0x7C, 0x0E, 0x03, 0x77, 0x4C, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x75, 0xC7, 0x20, 0x7C, 0x0E, 0x03,
  0x77, 0x6C, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0xC7, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x1C, 0x60,
  0x7C, 0x0E, 0x03, 0x77, 0x72, 0xC5, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x3C, 0x40, 0x7C, 0x0E, 0x03,
  0x77, 0x74, 0xC3, 0x07, 0x80, 0xC0, 0xF2, 0x07, 0x80, 0xC1, 0xF1, 0x07, 0x80, 0xC2, 0xF0, 0x78,
  0x0C, 0x3F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_4_bar 48x48, 4-bit Alpha,  RLE, 165 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_4_bar_data[] PROGMEM = {
  0x80, 0xC3, 0x00, 0x78, 0x0C, 0x20, 0x07, 0x98, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x00, 0x07, 0xB7,
  0x77, 0x77, 0x07, 0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xE7, 0x77, 0x74, 0x07, 0xF7,
  0x77, 0x73, 0x07, 0xF9, 0x77, 0x77, 0x20, 0x7F, 0xA7, 0x77, 0x71, 0x07, 0xFB, 0x77, 0x77, 0x07,
  0xFC, 0x77, 0x76, 0x07, 0xFD, 0x77, 0x75, 0x07, 0xFE, 0x77, 0x74, 0x07, 0xFF, 0x77, 0x73, 0x07,
  0xFF, 0x97, 0x77, 0x20, 0x7F, 0xFA, 0x77, 0x71, 0x07, 0xFF, 0xB7, 0x77, 0x07, 0xFF, 0xC7, 0x76,
  0x07, 0xFF, 0xD7, 0x75, 0x07, 0xFF, 0xE7, 0x74, 0x07, 0xFF, 0xF7, 0x73, 0x07, 0xFF, 0xF9, 0x77,
  0x20, 0x7F, 0xFF, 0xA7, 0x71, 0x07, 0xFF, 0xFB, 0x77, 0x07, 0xFF, 0xFC, 0x76, 0x07, 0xFF, 0xFD,
  0x75, 0x07, 0xFF, 0xFE, 0x74, 0x07, 0xFF, 0xFF, 0x73, 0x07, 0xFF, 0xFF, 0x97, 0x20, 0x7F, 0xFF,
  0xFA, 0x71, 0x07, 0xFF, 0xFF, 0xB7, 0x07, 0xFF, 0xFF, 0xC6, 0x07, 0xFF, 0xFF, 0xD5, 0x07, 0xFF,
  0xFF, 0xE4, 0x07, 0xFF, 0xFF, 0xF3, 0x07, 0x80, 0xC0, 0xF2, 0x07, 0x80, 0xC1, 0xF1, 0x07, 0x80,
  0xC2, 0xF0, 0x78, 0x0C, 0x3F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_alt_1_bar 48x48, 4-bit Alpha,  RLE, 3 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_alt_1_bar_data[] PROGMEM = {
  0x80, 0x98, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_alt_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 28, 15, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_alt_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_alt_2_bar 48x48, 4-bit Alpha,  RLE, 33 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_alt_2_bar_data[] PROGMEM = {
  0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5F, 0xD6,
  0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD, 0x6F, 0xD6, 0xFD,
  0x6E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_alt_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 18, 27, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_alt_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_alt 48x48, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_alt_data[] PROGMEM = {
  0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77,
  0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x75, 0xE6, 0xE7, 0x5E, 0x6E, 0x75, 0xE6,
  0xE7, 0x5E, 0x6E, 0x75, 0xE6, 0xE7, 0x5E, 0x6E, 0x75, 0xE6, 0xE7, 0x5E, 0x6E, 0x75, 0xE6, 0xE7,
  0x5E, 0x6F, 0xD6, 0xE6, 0xFD, 0x6E, 0x6F, 0xD6, 0xE6, 0xFD, 0x6E, 0x6F, 0xD6, 0xE6, 0xFD, 0x6E,
  0x6F, 0xD6, 0xE6, 0xFD, 0x6E, 0x6F, 0xD6, 0xE6, 0xFD, 0x6E, 0x6F, 0xD6, 0xE6, 0xFD, 0x6E, 0x6E,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 8, 39, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_connected_no_internet_0_bar 48x48, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_connected_no_internet_0_bar_data[] PROGMEM = {
  0x80, 0xC3, 0x00, 0x78, 0x0C, 0x20, 0x07, 0x98, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x00, 0x07, 0xB7,
  0x77, 0x77, 0x07, 0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xE7, 0x77, 0x74, 0x07, 0xF7,
  0x77, 0x73, 0x07, 0xF9, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0xC7, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x3C,
  0x77, 0x77, 0x07, 0xC0, 0xE0, 0x31, 0xC7, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x7C,
  0x0E, 0x03, 0x77, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x77,
  0x40, 0x7C, 0x0E, 0x03, 0x6C, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0xC7, 0x77, 0x07, 0xC0, 0xE0,
  0x37, 0x1C, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x72, 0xC7, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x3C, 0x77,
  0x40, 0x7C, 0x0E, 0x03, 0x74, 0xC7, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x5C, 0x77, 0x20, 0x7C, 0x0E,
  0x03, 0x76, 0xC7, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x7C, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x71, 0xC7,
  0x60, 0x7C, 0x0E, 0x03, 0x77, 0x2C, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x73, 0xC7, 0x40, 0x7C, 0x0E,
  0x03, 0x77, 0x4C, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x75, 0xC7, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x6C,
  0x71, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0xC7, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x74, 0x07, 0xC0, 0xE0,
  0x37, 0x77, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x74, 0x07,
  0xFF, 0xFF, 0x4C, 0x20, 0x7F, 0xFF, 0xF9, 0x4C, 0x10, 0x7F, 0xFF, 0xFA, 0x4C, 0x07, 0xFF, 0xFF,
  0xB4, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_connected_no_internet_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_connected_no_internet_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_connected_no_internet_4_bar 48x48, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_connected_no_internet_4_bar_data[] PROGMEM = {
  0x80, 0xC3, 0x00, 0x78, 0x0C, 0x20, 0x07, 0x98, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x00, 0x07, 0xB7,
  0x77, 0x77, 0x07, 0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xE7, 0x77, 0x74, 0x07, 0xF7,
  0x77, 0x73, 0x07, 0xF9, 0x77, 0x77, 0x20, 0x7F, 0xA7, 0x77, 0x71, 0x07, 0xFB, 0x77, 0x77, 0x07,
  0xFC, 0x77, 0x76, 0x07, 0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xE7, 0x77, 0x74, 0x07,
  0xF7, 0x77, 0x73, 0x07, 0xF9, 0x4C, 0x77, 0x71, 0x07, 0xFA, 0x4C, 0x77, 0x70, 0x7F, 0xB4, 0xC7,
  0x76, 0x07, 0xFC, 0x4C, 0x77, 0x50, 0x7F, 0xD4, 0xC7, 0x74, 0x07, 0xFE, 0x4C, 0x77, 0x30, 0x7F,
  0xF4, 0xC7, 0x72, 0x07, 0xFF, 0x94, 0xC7, 0x71, 0x07, 0xFF, 0xA4, 0xC7, 0x70, 0x7F, 0xFB, 0x4C,
  0x76, 0x07, 0xFF, 0xC4, 0xC7, 0x50, 0x7F, 0xFD, 0x4C, 0x74, 0x07, 0xFF, 0xE4, 0xC7, 0x30, 0x7F,
  0xFF, 0x4C, 0x72, 0x07, 0xFF, 0xF9, 0x4C, 0x71, 0x07, 0xFF, 0xFA, 0x4C, 0x70, 0x7F, 0xFF, 0xB7,
  0x70, 0x7F, 0xFF, 0xC7, 0x60, 0x7F, 0xFF, 0xD7, 0x50, 0x7F, 0xFF, 0xE7, 0x40, 0x7F, 0xFF, 0xF4,
  0xC2, 0x07, 0xFF, 0xFF, 0x94, 0xC1, 0x07, 0xFF, 0xFF, 0xA4, 0xC0, 0x7F, 0xFF, 0xFB, 0x4C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_connected_no_internet_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_connected_no_internet_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_nodata 48x48, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_nodata_data[] PROGMEM = {
  0x80, 0xC3, 0x00, 0x78, 0x0C, 0x20, 0x07, 0x98, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x00, 0x07, 0xB7,
  0x77, 0x77, 0x07, 0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xE7, 0x77, 0x74, 0x07, 0xF7,
  0x77, 0x73, 0x07, 0xF9, 0x77, 0x77, 0x20, 0x7F, 0xA7, 0x77, 0x71, 0x07, 0xFB, 0x77, 0x77, 0x07,
  0xFC, 0x77, 0x76, 0x07, 0xFD, 0x77, 0x75, 0x07, 0xFE, 0x77, 0x74, 0x07, 0xFF, 0x77, 0x73, 0x07,
  0xFF, 0x97, 0x77, 0x20, 0x7F, 0xFA, 0x77, 0x71, 0x07, 0xFF, 0xB7, 0x77, 0x07, 0xFF, 0xC7, 0x76,
  0x07, 0xFF, 0xD7, 0x75, 0x07, 0xFF, 0xE7, 0x74, 0x07, 0xFF, 0xF7, 0x73, 0x07, 0xC7, 0x77, 0x76,
  0x07, 0xD7, 0x77, 0x75, 0x07, 0xE4, 0x0A, 0x05, 0x60, 0x50, 0xA7, 0x74, 0x07, 0xF3, 0x0A, 0xA0,
  0x54, 0x05, 0xA0, 0xA7, 0x72, 0x07, 0xF9, 0x20, 0xAC, 0x05, 0x20, 0x5C, 0x0A, 0x77, 0x07, 0xFA,
  0x20, 0x5D, 0x00, 0x5D, 0x05, 0x76, 0x07, 0xFB, 0x30, 0x5F, 0xB0, 0x57, 0x60, 0x7F, 0xC4, 0x05,
  0xF9, 0x05, 0x76, 0x07, 0xFD, 0x50, 0x5E, 0x05, 0x76, 0x07, 0xFE, 0x50, 0x5E, 0x05, 0x75, 0x07,
  0xFF, 0x40, 0x5F, 0x90, 0x57, 0x30, 0x7F, 0xF9, 0x30, 0x5F, 0xB0, 0x57, 0x10, 0x7F, 0xFA, 0x20,
  0x5D, 0x00, 0x5D, 0x05, 0x60, 0x7F, 0xFB, 0x20, 0xAC, 0x05, 0x20, 0x5C, 0x0A, 0x50, 0x7F, 0xFC,
  0x30, 0xAA, 0x05, 0x40, 0x5A, 0x0A, 0x50, 0x7F, 0xFD, 0x40, 0xA0, 0x56, 0x05, 0x0A, 0x50, 0x7F,
  0xFE, 0x77, 0x40, 0x7F, 0xFF, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_nodata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_nodata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_no_sim 48x48, 4-bit Alpha,  RLE, 255 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_no_sim_data[] PROGMEM = {
  0x77, 0x07, 0xFF, 0x81, 0xDA, 0x17, 0x10, 0x47, 0x30, 0x7F, 0xFB, 0x0E, 0x01, 0x68, 0x16, 0xF9,
  0x71, 0x07, 0xFF, 0xD0, 0xA5, 0x06, 0xB0, 0x96, 0x07, 0xFF, 0xE0, 0xD5, 0x0D, 0xC0, 0x95, 0x0B,
  0xB0, 0xE0, 0x37, 0x5C, 0x50, 0x20, 0xDC, 0x09, 0x58, 0x2B, 0xFE, 0x37, 0x6C, 0x60, 0x20, 0xDC,
  0x09, 0x50, 0xA0, 0x37, 0x7C, 0x70, 0x20, 0xDC, 0x09, 0x77, 0x6C, 0x71, 0x02, 0x0D, 0xC0, 0x97,
  0x75, 0xC7, 0x20, 0x2D, 0x09, 0x77, 0x4C, 0x73, 0xE0, 0x97, 0x73, 0xC7, 0x3F, 0x09, 0x77, 0x2C,
  0x73, 0xF9, 0x09, 0x77, 0x1C, 0x73, 0xC0, 0xEC, 0x09, 0x77, 0xC7, 0x3C, 0x02, 0x0E, 0xC0, 0x97,
  0x6C, 0x73, 0xC1, 0x02, 0x0E, 0xC0, 0x97, 0x5C, 0x73, 0xC2, 0x02, 0x0E, 0xC0, 0x97, 0x4C, 0x73,
  0xC3, 0x02, 0x0E, 0xC0, 0x97, 0x3C, 0x73, 0xC4, 0x02, 0x0E, 0xC0, 0x97, 0x2C, 0x73, 0xC5, 0x02,
  0x0E, 0xC0, 0x97, 0x1C, 0x73, 0xC6, 0x02, 0x0E, 0xC0, 0x97, 0xC7, 0x3C, 0x70, 0x20, 0xEC, 0x09,
  0x6C, 0x73, 0xC7, 0x10, 0x20, 0xDC, 0x09, 0x50, 0xAB, 0x73, 0xC7, 0x20, 0x20, 0xDC, 0x09, 0x50,
  0xAA, 0x73, 0xC7, 0x30, 0x20, 0xDC, 0x09, 0x50, 0xA9, 0x73, 0xC7, 0x40, 0x20, 0xDC, 0x09, 0x50,
  0xA7, 0x3C, 0x75, 0x02, 0x0D, 0xC0, 0x97, 0x71, 0xC7, 0x60, 0x20, 0xDC, 0x09, 0x77, 0xC7, 0x70,
  0x20, 0xDC, 0x09, 0x76, 0xC7, 0x71, 0x02, 0x0D, 0xC0, 0x97, 0x5C, 0x77, 0x20, 0x20, 0xDC, 0x09,
  0x74, 0xC7, 0x73, 0x02, 0x0D, 0xC0, 0x97, 0x30, 0xDF, 0xFF, 0xE0, 0x97, 0x20, 0xAF, 0xFF, 0xF0,
  0x97, 0x10, 0x10, 0xEF, 0xFF, 0xF0, 0x97, 0x18, 0x11, 0xAD, 0xFF, 0xFE, 0x09, 0x77, 0x77, 0x40,
  0x20, 0xDC, 0x04, 0x77, 0x77, 0x40, 0x20, 0xDA, 0x06, 0x77, 0x77, 0x68, 0x12, 0xD6, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_null 48x48, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_null_data[] PROGMEM = {
  0x80, 0xC3, 0x00, 0x78, 0x0C, 0x20, 0x07, 0x98, 0x0C, 0x10, 0x07, 0xA8, 0x0C, 0x00, 0x07, 0xB7,
  0x77, 0x77, 0x07, 0xC7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x75, 0x07, 0xE7, 0x77, 0x74, 0x07, 0xF7,
  0x77, 0x73, 0x07, 0xF9, 0x77, 0x77, 0x20, 0x7C, 0x0E, 0xC7, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x3C,
  0x77, 0x77, 0x07, 0xC0, 0xE0, 0x31, 0xC7, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x2C, 0x77, 0x75, 0x07,
  0xC0, 0xE0, 0x33, 0xC7, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x4C, 0x77, 0x73, 0x07, 0xC0, 0xE0, 0x35,
  0xC7, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x6C, 0x77, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0xC7, 0x77, 0x07,
  0xC0, 0xE0, 0x37, 0x1C, 0x77, 0x60, 0x7C, 0x0E, 0x03, 0x72, 0xC7, 0x75, 0x07, 0xC0, 0xE0, 0x37,
  0x3C, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x74, 0xC7, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x5C, 0x77, 0x20,
  0x7C, 0x0E, 0x03, 0x76, 0xC7, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x7C, 0x77, 0x07, 0xC0, 0xE0, 0x37,
  0x71, 0xC7, 0x60, 0x7C, 0x0E, 0x03, 0x77, 0x2C, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x73, 0xC7, 0x40,
  0x7C, 0x0E, 0x03, 0x77, 0x4C, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x75, 0xC7, 0x20, 0x7C, 0x0E, 0x03,
  0x77, 0x6C, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0xC7, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x1C, 0x60,
  0x7C, 0x0E, 0x03, 0x77, 0x72, 0xC5, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x3C, 0x40, 0x7C, 0x0E, 0x03,
  0x77, 0x74, 0xC3, 0x07, 0x80, 0xC0, 0xF2, 0x07, 0x80, 0xC1, 0xF1, 0x07, 0x80, 0xC2, 0xF0, 0x78,
  0x0C, 0x3F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_null() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_null_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_cellular_off 48x48, 4-bit Alpha,  RLE, 277 bytes.
static const unsigned char ic_outlined_48_device_signal_cellular_off_data[] PROGMEM = {
  0x80, 0xC3, 0x00, 0x78, 0x0C, 0x50, 0x07, 0x98, 0x0C, 0x40, 0x07, 0xA8, 0x0C, 0x30, 0x07, 0xB8,
  0x0C, 0x20, 0x07, 0xC8, 0x0C, 0x10, 0x07, 0xD7, 0x30, 0x17, 0x77, 0x40, 0x7E, 0x72, 0x81, 0x1D,
  0x97, 0x77, 0x20, 0x7F, 0x71, 0x01, 0x0D, 0xA0, 0x97, 0x77, 0x07, 0xF9, 0x71, 0x0B, 0xC0, 0x97,
  0x75, 0x07, 0xFA, 0x71, 0x02, 0x0D, 0xC0, 0x97, 0x73, 0x07, 0xFB, 0x72, 0x02, 0x0D, 0xC0, 0x97,
  0x71, 0x07, 0xFC, 0x73, 0x02, 0x0D, 0xC0, 0x97, 0x60, 0x7F, 0xD7, 0x40, 0x20, 0xDC, 0x09, 0x74,
  0x07, 0xFE, 0x75, 0x02, 0x0D, 0xC0, 0x97, 0x20, 0x7F, 0xF7, 0x60, 0x20, 0xDC, 0x09, 0x70, 0x7F,
  0xF9, 0x77, 0x02, 0x0D, 0xC0, 0x95, 0x05, 0xFF, 0xA7, 0x71, 0x02, 0x0D, 0xC0, 0x95, 0x0B, 0xFF,
  0x97, 0x72, 0x02, 0x0D, 0xC0, 0x95, 0x0B, 0xFF, 0x77, 0x30, 0x20, 0xDC, 0x09, 0x50, 0xAF, 0xE7,
  0x74, 0x02, 0x0D, 0xC0, 0x95, 0x0A, 0xFD, 0x77, 0x50, 0x20, 0xDC, 0x09, 0x50, 0xAF, 0xC7, 0x76,
  0x08, 0xD0, 0x95, 0x0A, 0xFB, 0x77, 0x50, 0x7F, 0x09, 0x50, 0xAF, 0xA7, 0x74, 0x07, 0xFA, 0x09,
  0x50, 0xAF, 0x97, 0x73, 0x07, 0xFC, 0x09, 0x50, 0xAF, 0x77, 0x20, 0x7F, 0xE0, 0x95, 0x0A, 0xE7,
  0x71, 0x07, 0xFF, 0x90, 0x95, 0x0A, 0xD7, 0x70, 0x7F, 0xFB, 0x09, 0x50, 0xAC, 0x76, 0x07, 0xFF,
  0xD0, 0x95, 0x0A, 0xB7, 0x50, 0x7F, 0xFF, 0x09, 0x50, 0xAA, 0x74, 0x07, 0xFF, 0xFA, 0x09, 0x50,
  0xA9, 0x73, 0x07, 0xFF, 0xFC, 0x09, 0x50, 0xA7, 0x20, 0x7F, 0xFF, 0xE0, 0x97, 0x60, 0x7F, 0xFF,
  0xF9, 0x09, 0x74, 0x07, 0xFF, 0xFF, 0xB0, 0x97, 0x20, 0x7F, 0xFF, 0xFD, 0x09, 0x70, 0x7F, 0xFF,
  0xFF, 0x09, 0x50, 0x78, 0x0C, 0x1F, 0x09, 0x30, 0x78, 0x0C, 0x3F, 0x09, 0x80, 0xC1, 0x00, 0x20,
  0xDC, 0x09, 0x80, 0xC1, 0x00, 0x20, 0xDB, 0x0D, 0x01, 0x80, 0xC1, 0x08, 0x32, 0xDF, 0xD1, 0x80,
  0xC3, 0x08, 0x12, 0xB1, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_cellular_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 44, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_cellular_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_0_bar 48x48, 4-bit Alpha,  RLE, 315 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_0_bar_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0x98, 0x4E, 0xB8, 0x53, 0x13, 0x85, 0x13, 0x45,
  0x8B, 0xEF, 0x90, 0xA0, 0x27, 0x40, 0x70, 0xEE, 0x81, 0xD8, 0x37, 0x72, 0x81, 0x38, 0xDE, 0x0E,
  0x07, 0x71, 0x01, 0x0C, 0xE0, 0xB0, 0x47, 0x77, 0x10, 0x40, 0xBE, 0x0C, 0x01, 0x50, 0x40, 0xED,
  0x0B, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xD0, 0xE0, 0x43, 0x06, 0xD0, 0xD0, 0x57, 0x77, 0x72, 0x05,
  0x0D, 0xD8, 0x16, 0x07, 0xD0, 0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xD0, 0x07, 0xD0, 0x37, 0x77,
  0x76, 0x03, 0xD8, 0x17, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x70, 0x30, 0xEC,
  0x07, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77,
  0x73, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x60,
  0x7C, 0x0E, 0x03, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x40, 0x30,
  0xEC, 0x07, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x50, 0x7C, 0x0E,
  0x03, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x50, 0x30, 0xEC, 0x07, 0x77,
  0x72, 0x07, 0xC0, 0xE0, 0x37, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x10,
  0x30, 0xEC, 0x07, 0x77, 0x76, 0x07, 0xC0, 0xE0, 0x36, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x71, 0x07,
  0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x73, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC0,
  0x77, 0x77, 0x75, 0x07, 0xC8, 0x2E, 0x33, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x7C, 0x00, 0xEC, 0x07,
  0x80, 0xC1, 0x00, 0x7F, 0x90, 0x78, 0x0C, 0x30, 0x07, 0xE0, 0x78, 0x0C, 0x50, 0x07, 0xC0, 0x78,
  0x0C, 0x70, 0x07, 0xA0, 0x78, 0x0D, 0x10, 0x00, 0x77, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_4_bar_lock 48x48, 4-bit Alpha,  RLE, 246 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_4_bar_lock_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0xFF, 0xFC, 0x0A, 0x02, 0x74, 0x07, 0x0E, 0xFF,
  0xFF, 0xE0, 0xE0, 0x77, 0x10, 0x10, 0xC8, 0x0C, 0x2F, 0x0C, 0x01, 0x50, 0x40, 0xE8, 0x0C, 0x4F,
  0x0E, 0x04, 0x30, 0x68, 0x0D, 0x0F, 0x81, 0x60, 0x78, 0x0D, 0x2F, 0x00, 0x78, 0x0D, 0x2F, 0x81,
  0x70, 0x78, 0x0D, 0x0F, 0x07, 0x30, 0x78, 0x0C, 0x6F, 0x07, 0x50, 0x78, 0x0C, 0x4F, 0x07, 0x70,
  0x7F, 0xFF, 0xF9, 0x81, 0xD7, 0x27, 0x72, 0x07, 0xFF, 0xFE, 0x07, 0x77, 0x60, 0x7F, 0xFF, 0xC0,
  0x57, 0x77, 0x10, 0x7F, 0xFF, 0xA0, 0x87, 0x77, 0x30, 0x7F, 0xFF, 0x0E, 0x68, 0x41, 0xAD, 0xDA,
  0x17, 0x70, 0x7F, 0xFE, 0x08, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x07, 0xFF, 0xD0, 0x45, 0x86,
  0xAF, 0xB1, 0x1B, 0xFA, 0x77, 0x10, 0x7F, 0xFC, 0x02, 0x58, 0x1D, 0xF1, 0x28, 0x11, 0xFD, 0x77,
  0x20, 0x7F, 0xFB, 0x01, 0x5A, 0x4A, 0x77, 0x30, 0x7F, 0xFA, 0x01, 0x5A, 0x4A, 0x77, 0x40, 0x7F,
  0xF9, 0x01, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x73, 0x07, 0xFF, 0x01, 0x30, 0xDF, 0xB0, 0xD7,
  0x74, 0x07, 0xFE, 0x01, 0x3F, 0xD7, 0x75, 0x07, 0xFD, 0x01, 0x3F, 0xD7, 0x76, 0x07, 0xFB, 0x07,
  0x4F, 0xD7, 0x77, 0x07, 0xF9, 0x07, 0x5F, 0xD7, 0x77, 0x10, 0x7E, 0x07, 0x6F, 0xD7, 0x77, 0x20,
  0x7C, 0x07, 0x7F, 0xD7, 0x77, 0x30, 0x7A, 0x07, 0x71, 0x0D, 0xFB, 0x0D, 0x77, 0x74, 0x00, 0x77,
  0x20, 0x40, 0xDF, 0x90, 0xD0, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_4_bar_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_4_bar_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_4_bar 48x48, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_4_bar_data[] PROGMEM = {
  0x77, 0x18, 0x52, 0x58, 0xBB, 0xDD, 0xB8, 0x4D, 0xCB, 0x85, 0x27, 0x77, 0x58, 0x21, 0x6B, 0xEF,
  0xFA, 0x82, 0xEB, 0x61, 0x77, 0x58, 0x11, 0x7C, 0xFF, 0xFB, 0x81, 0xC6, 0x17, 0x78, 0x12, 0x9E,
  0xFF, 0xFF, 0x81, 0xE9, 0x27, 0x30, 0x20, 0xAF, 0xFF, 0xFE, 0x09, 0x02, 0x70, 0x88, 0x0C, 0x2F,
  0x08, 0x40, 0x40, 0xD8, 0x0C, 0x4F, 0x82, 0xD4, 0x09, 0x80, 0xD0, 0xF0, 0x90, 0xC8, 0x0D, 0x0F,
  0x81, 0xC2, 0xE8, 0x0C, 0x6F, 0x82, 0xE2, 0x04, 0x80, 0xC6, 0xF0, 0x43, 0x07, 0x80, 0xC4, 0xF0,
  0x75, 0x0A, 0x80, 0xC2, 0xF0, 0xA7, 0x0C, 0x80, 0xC0, 0xF0, 0xC7, 0x10, 0x20, 0xEF, 0xFF, 0xFE,
  0x0E, 0x02, 0x72, 0x04, 0xFF, 0xFF, 0xE0, 0x47, 0x40, 0x7F, 0xFF, 0xFC, 0x07, 0x76, 0x0A, 0xFF,
  0xFF, 0xA0, 0xA7, 0x71, 0x0C, 0xFF, 0xFF, 0x0C, 0x77, 0x20, 0x10, 0xEF, 0xFF, 0xD0, 0xE0, 0x17,
  0x73, 0x04, 0xFF, 0xFD, 0x04, 0x77, 0x50, 0x6F, 0xFF, 0xB0, 0x67, 0x77, 0x09, 0xFF, 0xF9, 0x09,
  0x77, 0x72, 0x0C, 0xFF, 0xE0, 0xC7, 0x77, 0x30, 0x10, 0xEF, 0xFC, 0x0E, 0x01, 0x77, 0x74, 0x03,
  0xFF, 0xC0, 0x37, 0x77, 0x60, 0x6F, 0xFA, 0x06, 0x77, 0x77, 0x10, 0x9F, 0xF0, 0x97, 0x77, 0x73,
  0x0C, 0xFD, 0x0C, 0x77, 0x77, 0x40, 0x10, 0xEF, 0xB0, 0xE0, 0x17, 0x77, 0x75, 0x03, 0xFB, 0x03,
  0x77, 0x77, 0x70, 0x6F, 0x90, 0x68, 0x0C, 0x10, 0x09, 0xE0, 0x98, 0x0C, 0x30, 0x0C, 0xC0, 0xC8,
  0x0C, 0x40, 0x01, 0x0D, 0xA0, 0xD0, 0x18, 0x0C, 0x50, 0x03, 0xA0, 0x38, 0x0C, 0x70, 0x00, 0x67,
  0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 46, 42), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_bad 48x48, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_bad_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0xFF, 0xFC, 0x0A, 0x02, 0x74, 0x07, 0x0E, 0xFF,
  0xFF, 0xE0, 0xE0, 0x77, 0x10, 0x10, 0xC8, 0x0C, 0x2F, 0x0C, 0x01, 0x50, 0x40, 0xE8, 0x0C, 0x4F,
  0x0E, 0x04, 0x30, 0x68, 0x0D, 0x0F, 0x81, 0x60, 0x78, 0x0D, 0x2F, 0x00, 0x78, 0x0D, 0x2F, 0x81,
  0x70, 0x78, 0x0D, 0x0F, 0x07, 0x30, 0x78, 0x0C, 0x6F, 0x07, 0x50, 0x78, 0x0C, 0x4F, 0x07, 0x70,
  0x78, 0x0C, 0x2F, 0x07, 0x72, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0x7F, 0xFB, 0x77, 0x77, 0x30,
  0x7F, 0xFA, 0x77, 0x77, 0x40, 0x7F, 0xF9, 0x77, 0x77, 0x50, 0x7F, 0xF7, 0x77, 0x76, 0x07, 0xFE,
  0x60, 0xA0, 0x56, 0x05, 0x0A, 0x77, 0x50, 0x7F, 0xD5, 0x0A, 0xA0, 0x54, 0x05, 0xA0, 0xA7, 0x75,
  0x07, 0xFC, 0x40, 0xAC, 0x05, 0x20, 0x5C, 0x0A, 0x77, 0x50, 0x7F, 0xB4, 0x05, 0xD0, 0x05, 0xD0,
  0x57, 0x76, 0x07, 0xFA, 0x50, 0x5F, 0xB0, 0x57, 0x77, 0x10, 0x7F, 0x96, 0x05, 0xF9, 0x05, 0x77,
  0x73, 0x07, 0xF7, 0x05, 0xE0, 0x57, 0x77, 0x50, 0x7E, 0x70, 0x5E, 0x05, 0x77, 0x76, 0x07, 0xD6,
  0x05, 0xF9, 0x05, 0x77, 0x76, 0x07, 0xC5, 0x05, 0xFB, 0x05, 0x77, 0x76, 0x07, 0xB4, 0x05, 0xD0,
  0x05, 0xD0, 0x57, 0x77, 0x60, 0x7A, 0x40, 0xAC, 0x05, 0x20, 0x5C, 0x0A, 0x77, 0x77, 0x07, 0x95,
  0x0A, 0xA0, 0x54, 0x05, 0xA0, 0xA7, 0x77, 0x72, 0x07, 0x60, 0xA0, 0x56, 0x05, 0x0A, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_connected_no_internet_4 48x48, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_connected_no_internet_4_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0xFF, 0xFC, 0x0A, 0x02, 0x74, 0x07, 0x0E, 0xFF,
  0xFF, 0xE0, 0xE0, 0x77, 0x10, 0x10, 0xC8, 0x0C, 0x2F, 0x0C, 0x01, 0x50, 0x40, 0xE8, 0x0C, 0x4F,
  0x0E, 0x04, 0x30, 0x68, 0x0D, 0x0F, 0x81, 0x60, 0x78, 0x0D, 0x2F, 0x00, 0x78, 0x0D, 0x2F, 0x81,
  0x70, 0x78, 0x0D, 0x0F, 0x07, 0x30, 0x78, 0x0C, 0x6F, 0x07, 0x50, 0x78, 0x0C, 0x4F, 0x07, 0x70,
  0x78, 0x0C, 0x2F, 0x07, 0x72, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0x7F, 0xFB, 0x77, 0x77, 0x30,
  0x7F, 0xFA, 0x77, 0x77, 0x40, 0x7F, 0xF9, 0x77, 0x77, 0x50, 0x7F, 0xF7, 0x77, 0x76, 0x07, 0xFE,
  0x60, 0xA0, 0x56, 0x05, 0x0A, 0x77, 0x50, 0x7F, 0xD5, 0x0A, 0xA0, 0x54, 0x05, 0xA0, 0xA7, 0x75,
  0x07, 0xFC, 0x40, 0xAC, 0x05, 0x20, 0x5C, 0x0A, 0x77, 0x50, 0x7F, 0xB4, 0x05, 0xD0, 0x05, 0xD0,
  0x57, 0x76, 0x07, 0xFA, 0x50, 0x5F, 0xB0, 0x57, 0x77, 0x10, 0x7F, 0x96, 0x05, 0xF9, 0x05, 0x77,
  0x73, 0x07, 0xF7, 0x05, 0xE0, 0x57, 0x77, 0x50, 0x7E, 0x70, 0x5E, 0x05, 0x77, 0x76, 0x07, 0xD6,
  0x05, 0xF9, 0x05, 0x77, 0x76, 0x07, 0xC5, 0x05, 0xFB, 0x05, 0x77, 0x76, 0x07, 0xB4, 0x05, 0xD0,
  0x05, 0xD0, 0x57, 0x77, 0x60, 0x7A, 0x40, 0xAC, 0x05, 0x20, 0x5C, 0x0A, 0x77, 0x77, 0x07, 0x95,
  0x0A, 0xA0, 0x54, 0x05, 0xA0, 0xA7, 0x77, 0x72, 0x07, 0x60, 0xA0, 0x56, 0x05, 0x0A, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_connected_no_internet_4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_connected_no_internet_4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_off 48x48, 4-bit Alpha,  RLE, 316 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_off_data[] PROGMEM = {
  0x50, 0x18, 0x0D, 0x00, 0x81, 0x2D, 0xA8, 0x0C, 0x60, 0x02, 0x0D, 0xA0, 0xA8, 0x0C, 0x50, 0x0B,
  0xC0, 0xA8, 0x0C, 0x40, 0x01, 0x0D, 0xC0, 0xA5, 0x85, 0x15, 0x8A, 0xCD, 0xDB, 0x84, 0xDC, 0xB8,
  0x52, 0x77, 0x50, 0x10, 0xDC, 0x0A, 0x50, 0x9F, 0xF8, 0x2E, 0xB6, 0x17, 0x72, 0x01, 0x0D, 0xC0,
  0xA5, 0x09, 0xFF, 0xB8, 0x1C, 0x61, 0x77, 0x03, 0xD0, 0xA5, 0x09, 0xFF, 0xC8, 0x1E, 0x92, 0x73,
  0x02, 0x09, 0xF0, 0xA5, 0x09, 0xFF, 0xE0, 0x90, 0x27, 0x08, 0xFB, 0x0A, 0x50, 0x9F, 0xFF, 0x08,
  0x40, 0x40, 0xDF, 0xD0, 0xA5, 0x09, 0xFF, 0xF8, 0x2D, 0x40, 0x9F, 0xF9, 0x0A, 0x50, 0x9F, 0xFF,
  0x90, 0x90, 0xCF, 0xFA, 0x0A, 0x50, 0x9F, 0xFF, 0x81, 0xC2, 0xEF, 0xFA, 0x0A, 0x50, 0x9F, 0xFD,
  0x82, 0xE2, 0x04, 0xFF, 0xB0, 0xA5, 0x09, 0xFF, 0xC0, 0x43, 0x07, 0xFF, 0xB0, 0xA5, 0x09, 0xFF,
  0xA0, 0x75, 0x0A, 0xFF, 0xB0, 0xA5, 0x09, 0xFF, 0x0A, 0x70, 0xCF, 0xFB, 0x0A, 0x50, 0x9F, 0xD0,
  0xC7, 0x10, 0x20, 0xEF, 0xFB, 0x0A, 0x50, 0x9F, 0xB0, 0xE0, 0x27, 0x20, 0x4F, 0xFC, 0x0A, 0x50,
  0x9F, 0xA0, 0x47, 0x40, 0x7F, 0xFC, 0x0A, 0x50, 0x9F, 0x07, 0x76, 0x0A, 0xFF, 0xC0, 0xA5, 0x09,
  0xD0, 0xA7, 0x71, 0x0C, 0xFF, 0xC0, 0xA5, 0x09, 0xB0, 0xC7, 0x72, 0x01, 0x0E, 0xFF, 0xC0, 0xA5,
  0x82, 0x9F, 0xE2, 0x77, 0x30, 0x4F, 0xFD, 0x0A, 0x50, 0x90, 0x47, 0x75, 0x06, 0xFF, 0xD0, 0xA7,
  0x77, 0x50, 0x9F, 0xFD, 0x0A, 0x77, 0x75, 0x0C, 0xFF, 0xD0, 0xA7, 0x77, 0x40, 0x10, 0xEF, 0xFD,
  0x0A, 0x77, 0x74, 0x03, 0xFF, 0xE0, 0xA7, 0x77, 0x40, 0x6F, 0xFE, 0x0A, 0x77, 0x74, 0x09, 0xFF,
  0x0A, 0x0D, 0xC0, 0xA7, 0x77, 0x40, 0xCF, 0xD8, 0x2C, 0x01, 0xDC, 0x0A, 0x77, 0x73, 0x01, 0x0E,
  0xFB, 0x0E, 0x01, 0x20, 0x10, 0xDC, 0x0A, 0x77, 0x73, 0x03, 0xFB, 0x03, 0x40, 0x10, 0xDC, 0x0A,
  0x77, 0x73, 0x06, 0xF9, 0x06, 0x60, 0x10, 0xDB, 0x0C, 0x77, 0x74, 0x09, 0xE0, 0x97, 0x18, 0x31,
  0xDF, 0xC1, 0x77, 0x75, 0x0C, 0xC0, 0xC7, 0x38, 0x11, 0xA1, 0x77, 0x76, 0x01, 0x0D, 0xA0, 0xD0,
  0x18, 0x0C, 0x50, 0x03, 0xA0, 0x38, 0x0C, 0x70, 0x00, 0x67, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 46, 42), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_statusbar_4_bar 48x48, 4-bit Alpha,  RLE, 205 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_statusbar_4_bar_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0xFF, 0xFC, 0x0A, 0x02, 0x74, 0x07, 0x0E, 0xFF,
  0xFF, 0xE0, 0xE0, 0x77, 0x10, 0x10, 0xC8, 0x0C, 0x2F, 0x0C, 0x01, 0x50, 0x40, 0xE8, 0x0C, 0x4F,
  0x0E, 0x04, 0x30, 0x68, 0x0D, 0x0F, 0x81, 0x60, 0x78, 0x0D, 0x2F, 0x00, 0x78, 0x0D, 0x2F, 0x81,
  0x70, 0x78, 0x0D, 0x0F, 0x07, 0x30, 0x78, 0x0C, 0x6F, 0x07, 0x50, 0x78, 0x0C, 0x4F, 0x07, 0x70,
  0x78, 0x0C, 0x2F, 0x07, 0x72, 0x07, 0x80, 0xC0, 0xF0, 0x77, 0x40, 0x7F, 0xFF, 0xFE, 0x07, 0x76,
  0x07, 0xFF, 0xFF, 0xC0, 0x77, 0x71, 0x07, 0xFF, 0xFF, 0xA0, 0x77, 0x73, 0x07, 0xFF, 0xFF, 0x07,
  0x77, 0x50, 0x7F, 0xFF, 0xD0, 0x77, 0x77, 0x07, 0xFF, 0xFB, 0x07, 0x77, 0x72, 0x07, 0xFF, 0xF9,
  0x07, 0x77, 0x74, 0x07, 0xFF, 0xE0, 0x77, 0x77, 0x60, 0x7F, 0xFC, 0x07, 0x77, 0x77, 0x10, 0x7F,
  0xFA, 0x07, 0x77, 0x77, 0x30, 0x7F, 0xF0, 0x77, 0x77, 0x75, 0x07, 0xFD, 0x07, 0x77, 0x77, 0x70,
  0x7F, 0xB0, 0x78, 0x0C, 0x10, 0x07, 0xF9, 0x07, 0x80, 0xC3, 0x00, 0x7E, 0x07, 0x80, 0xC5, 0x00,
  0x7C, 0x07, 0x80, 0xC7, 0x00, 0x7A, 0x07, 0x80, 0xD1, 0x00, 0x07, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_statusbar_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_statusbar_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_statusbar_connected_no_internet_4 48x48, 4-bit Alpha,  RLE, 200 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_statusbar_connected_no_internet_4_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x76, 0x81, 0x59, 0xDF,
  0xFA, 0x81, 0xD9, 0x47, 0x77, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x92, 0x77, 0x20, 0x30, 0xAF,
  0xFF, 0xF0, 0xB0, 0x37, 0x50, 0x20, 0xAF, 0xFF, 0xFC, 0x0A, 0x02, 0x72, 0x07, 0x0E, 0xFF, 0xFF,
  0xE0, 0xE0, 0x76, 0x01, 0x0C, 0x80, 0xC2, 0xF0, 0xC0, 0x13, 0x04, 0x0E, 0x80, 0xC4, 0xF8, 0x2E,
  0x40, 0x6F, 0xFF, 0xFC, 0x75, 0x07, 0xFF, 0xFF, 0xD7, 0x50, 0x7F, 0xFF, 0xFD, 0x76, 0x07, 0xFF,
  0xFF, 0xC7, 0x70, 0x7F, 0xFF, 0xFB, 0x4C, 0x70, 0x7F, 0xFF, 0xFA, 0x4C, 0x71, 0x07, 0xFF, 0xFF,
  0x94, 0xC7, 0x20, 0x7F, 0xFF, 0xF4, 0xC7, 0x30, 0x7F, 0xFF, 0xE4, 0xC7, 0x40, 0x7F, 0xFF, 0xD4,
  0xC7, 0x50, 0x7F, 0xFF, 0xC4, 0xC7, 0x60, 0x7F, 0xFF, 0xB4, 0xC7, 0x70, 0x7F, 0xFF, 0xA4, 0xC7,
  0x71, 0x07, 0xFF, 0xF9, 0x4C, 0x77, 0x20, 0x7F, 0xFF, 0x4C, 0x77, 0x30, 0x7F, 0xFE, 0x4C, 0x77,
  0x40, 0x7F, 0xFC, 0x07, 0x77, 0x76, 0x07, 0xFF, 0xA0, 0x77, 0x77, 0x71, 0x07, 0xFF, 0x07, 0x77,
  0x77, 0x30, 0x7F, 0xD0, 0x77, 0x77, 0x75, 0x07, 0xFB, 0x07, 0x71, 0xC7, 0x77, 0x20, 0x7F, 0x90,
  0x77, 0x2C, 0x77, 0x73, 0x07, 0xE0, 0x77, 0x3C, 0x77, 0x74, 0x07, 0xC0, 0x77, 0x4C, 0x77, 0x75,
  0x07, 0xA0, 0x78, 0x0C, 0x70, 0x00, 0x77, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_statusbar_connected_no_internet_4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_statusbar_connected_no_internet_4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_signal_wifi_statusbar_null 48x48, 4-bit Alpha,  RLE, 315 bytes.
static const unsigned char ic_outlined_48_device_signal_wifi_statusbar_null_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0x98, 0x4E, 0xB8, 0x53, 0x13, 0x85, 0x13, 0x45,
  0x8B, 0xEF, 0x90, 0xA0, 0x27, 0x40, 0x70, 0xEE, 0x81, 0xD8, 0x37, 0x72, 0x81, 0x38, 0xDE, 0x0E,
  0x07, 0x71, 0x01, 0x0C, 0xE0, 0xB0, 0x47, 0x77, 0x10, 0x40, 0xBE, 0x0C, 0x01, 0x50, 0x40, 0xED,
  0x0B, 0x03, 0x77, 0x75, 0x03, 0x0B, 0xD0, 0xE0, 0x43, 0x06, 0xD0, 0xD0, 0x57, 0x77, 0x72, 0x05,
  0x0D, 0xD8, 0x16, 0x07, 0xD0, 0xA0, 0x17, 0x77, 0x74, 0x01, 0x0A, 0xD0, 0x07, 0xD0, 0x37, 0x77,
  0x76, 0x03, 0xD8, 0x17, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x74, 0x03, 0x0E, 0xC0, 0x73, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x70, 0x30, 0xEC,
  0x07, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77,
  0x73, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x60,
  0x7C, 0x0E, 0x03, 0x77, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x40, 0x30,
  0xEC, 0x07, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x50, 0x7C, 0x0E,
  0x03, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x07, 0xC0, 0xE0, 0x37, 0x50, 0x30, 0xEC, 0x07, 0x77,
  0x72, 0x07, 0xC0, 0xE0, 0x37, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x10,
  0x30, 0xEC, 0x07, 0x77, 0x76, 0x07, 0xC0, 0xE0, 0x36, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x71, 0x07,
  0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x73, 0x07, 0xC0, 0xE0, 0x32, 0x03, 0x0E, 0xC0,
  0x77, 0x77, 0x75, 0x07, 0xC8, 0x2E, 0x33, 0xEC, 0x07, 0x77, 0x77, 0x70, 0x7C, 0x00, 0xEC, 0x07,
  0x80, 0xC1, 0x00, 0x7F, 0x90, 0x78, 0x0C, 0x30, 0x07, 0xE0, 0x78, 0x0C, 0x50, 0x07, 0xC0, 0x78,
  0x0C, 0x70, 0x07, 0xA0, 0x78, 0x0D, 0x10, 0x00, 0x77, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_signal_wifi_statusbar_null() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_signal_wifi_statusbar_null_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_sim_card_download 48x48, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_outlined_48_device_sim_card_download_data[] PROGMEM = {
  0x74, 0x07, 0xFF, 0xA8, 0x1D, 0xA1, 0x74, 0x07, 0xFF, 0xD0, 0xE0, 0x17, 0x20, 0x7F, 0xFF, 0x0A,
  0x71, 0x07, 0xFF, 0xF9, 0x0D, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0xC6, 0x07, 0xC0, 0xE0, 0x37, 0x71,
  0xC5, 0x07, 0xC0, 0xE0, 0x37, 0x72, 0xC4, 0x07, 0xC0, 0xE0, 0x37, 0x73, 0xC3, 0x07, 0xC0, 0xE0,
  0x37, 0x74, 0xC2, 0x07, 0xC0, 0xE0, 0x37, 0x75, 0xC1, 0x07, 0xC0, 0xE0, 0x37, 0x76, 0xC0, 0x7C,
  0x0E, 0x03, 0x77, 0x7F, 0x90, 0xE0, 0x37, 0x77, 0x1F, 0x90, 0x37, 0x77, 0x2F, 0x97, 0x3C, 0x73,
  0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x73, 0xC7, 0x3F, 0x97, 0x3C, 0x73, 0xF9, 0x60,
  0x70, 0x32, 0xC2, 0x03, 0x07, 0x6F, 0x95, 0x82, 0x7F, 0xE3, 0x1C, 0x18, 0x23, 0xEF, 0x75, 0xF9,
  0x40, 0x7B, 0x0E, 0x03, 0xC0, 0x30, 0xEB, 0x07, 0x4F, 0x94, 0x07, 0xC0, 0xEC, 0x0E, 0xC0, 0x74,
  0xF9, 0x50, 0x7F, 0xD0, 0x75, 0xF9, 0x60, 0x7F, 0xB0, 0x76, 0xF9, 0x70, 0x7F, 0x90, 0x77, 0xF9,
  0x71, 0x07, 0xE0, 0x77, 0x1F, 0x97, 0x20, 0x7C, 0x07, 0x72, 0xF9, 0x73, 0x07, 0xA0, 0x77, 0x3F,
  0x97, 0x40, 0x07, 0x74, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xC0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A,
  0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_sim_card_download() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_sim_card_download_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_splitscreen 48x48, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_outlined_48_device_splitscreen_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0x81, 0xE1, 0xAF, 0xFF, 0xFA,
  0x0A, 0x0D, 0xFF, 0xFF, 0xA0, 0xDC, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77,
  0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0xC0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0xFF,
  0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x18, 0x09, 0xF6, 0x08, 0x11, 0xAD, 0xFF, 0xFB,
  0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0x81, 0xE1, 0xAF, 0xFF, 0xFA, 0x0A, 0x0D, 0xFF, 0xFF, 0xA0,
  0xDC, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9,
  0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xC0, 0xDF,
  0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01, 0xAD, 0xFF,
  0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_splitscreen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_splitscreen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_sports_score 48x48, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_outlined_48_device_sports_score_data[] PROGMEM = {
  0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4F, 0xD4, 0xC4,
  0xC4, 0xF9, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4F, 0x94,
  0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xFD, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4,
  0xF9, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4F, 0x94, 0xC4,
  0xC4, 0xF9, 0x4C, 0x4C, 0x4F, 0x97, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7,
  0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77,
  0x3C, 0x77, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_sports_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 8, 37, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_sports_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_ssid_chart 48x48, 4-bit Alpha,  RLE, 256 bytes.
static const unsigned char ic_outlined_48_device_ssid_chart_data[] PROGMEM = {
  0x77, 0x77, 0x70, 0x97, 0x77, 0x75, 0x03, 0x0D, 0x97, 0x77, 0x74, 0x07, 0xB7, 0x77, 0x72, 0x01,
  0x0B, 0xC7, 0x18, 0x12, 0xC3, 0x77, 0x40, 0x40, 0xED, 0x70, 0x6A, 0x0E, 0x03, 0x77, 0x20, 0x8D,
  0x0E, 0x04, 0x50, 0x10, 0xAC, 0x0E, 0x03, 0x76, 0x02, 0x0C, 0xD0, 0xB0, 0x15, 0x03, 0x0D, 0xE0,
  0xE0, 0x37, 0x40, 0x50, 0xED, 0x07, 0x60, 0x7F, 0xA0, 0xE0, 0x37, 0x20, 0xAD, 0x0D, 0x03, 0x50,
  0x10, 0xBD, 0x0B, 0x08, 0xC0, 0xE0, 0x36, 0x03, 0x0D, 0xD0, 0xA6, 0x05, 0x0E, 0xD0, 0x72, 0x07,
  0xC0, 0xE0, 0x34, 0x07, 0xD0, 0xE0, 0x57, 0xD0, 0xD0, 0x34, 0x07, 0xC8, 0x3E, 0x30, 0x1B, 0xD0,
  0xC0, 0x27, 0x1C, 0x0A, 0x01, 0x60, 0x7C, 0x81, 0xE6, 0xED, 0x08, 0x73, 0xB0, 0x67, 0x20, 0x7F,
  0xA0, 0xE0, 0x47, 0x49, 0x0D, 0x03, 0x74, 0x07, 0xF0, 0xB0, 0x17, 0x50, 0x97, 0x70, 0x7D, 0x07,
  0x77, 0x77, 0x20, 0x7A, 0x0D, 0x03, 0x77, 0x77, 0x40, 0x70, 0x98, 0x0E, 0x50, 0x81, 0x2C, 0xA7,
  0x77, 0x74, 0x06, 0x0E, 0xA0, 0xA7, 0x77, 0x71, 0x01, 0x0A, 0xD0, 0xB7, 0x77, 0x60, 0x40, 0xDF,
  0x0B, 0x77, 0x75, 0xFB, 0x0C, 0x77, 0x74, 0xC8, 0x1B, 0x3C, 0xC0, 0xC0, 0x17, 0x50, 0x20, 0xDF,
  0xD0, 0x72, 0x01, 0x0C, 0xC0, 0xC0, 0x17, 0x30, 0x50, 0xEF, 0xC0, 0xD0, 0x35, 0x0B, 0xC0, 0xD0,
  0x17, 0x10, 0x7F, 0xD0, 0x97, 0x10, 0xBC, 0x0D, 0x01, 0x60, 0xBF, 0xE7, 0x30, 0xBC, 0x0D, 0x02,
  0x30, 0x20, 0xDD, 0x06, 0x77, 0x50, 0xAC, 0x83, 0xD2, 0x04, 0xEC, 0x0D, 0x03, 0x77, 0x70, 0xAC,
  0x0E, 0x08, 0xD0, 0xB0, 0x17, 0x77, 0x20, 0x9F, 0xA0, 0x97, 0x77, 0x50, 0x9F, 0x06, 0x77, 0x77,
  0x09, 0xC0, 0xD0, 0x37, 0x77, 0x72, 0x08, 0xA0, 0xB0, 0x17, 0x77, 0x74, 0x08, 0x09, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_ssid_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_ssid_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_storage 48x48, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_outlined_48_device_storage_data[] PROGMEM = {
  0x80, 0x9A, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x09, 0xD4, 0xF8,
  0x0A, 0xB4, 0x08, 0x09, 0xA0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80,
  0x9D, 0x4F, 0x80, 0xAB, 0x40, 0x80, 0x9A, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C,
  0x0F, 0x48, 0x09, 0xD4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_storage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_storage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_storm 48x48, 4-bit Alpha,  RLE, 400 bytes.
static const unsigned char ic_outlined_48_device_storm_data[] PROGMEM = {
  0x20, 0xAB, 0x08, 0x77, 0x77, 0x50, 0xEB, 0x03, 0x77, 0x77, 0x40, 0x3B, 0x0D, 0x77, 0x77, 0x50,
  0x7B, 0x09, 0x77, 0x77, 0x50, 0xAB, 0x06, 0x71, 0x89, 0x04, 0x8B, 0xDD, 0xED, 0xB8, 0x47, 0x71,
  0x0D, 0xB0, 0x25, 0x81, 0x18, 0xEF, 0xB8, 0x1E, 0x81, 0x75, 0xC5, 0x08, 0xFF, 0x90, 0xE0, 0x77,
  0x30, 0x2B, 0x0D, 0x30, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x71, 0x03, 0xB0, 0xC2, 0x02, 0x0D, 0xD8,
  0x90, 0xD8, 0x42, 0x10, 0x24, 0x8E, 0xD0, 0xD0, 0x27, 0x04, 0xB8, 0x2A, 0x01, 0xEC, 0x0D, 0x05,
  0x73, 0x05, 0x0E, 0xC0, 0xE0, 0x16, 0x05, 0xB8, 0x1A, 0x0C, 0xC0, 0xA0, 0x17, 0x50, 0x10, 0xAC,
  0x0B, 0x60, 0x5B, 0x0A, 0x07, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x75, 0x04, 0xB0, 0xC0, 0xEB, 0x0A,
  0x58, 0x62, 0x8C, 0xEE, 0xC8, 0x25, 0x0A, 0xC0, 0x24, 0x04, 0xF0, 0xD0, 0x14, 0x09, 0xF9, 0x09,
  0x40, 0x10, 0xDB, 0x09, 0x40, 0x3F, 0x05, 0x40, 0xBF, 0xB0, 0xB4, 0x05, 0xC0, 0x24, 0xE0, 0xE4,
  0x09, 0xFD, 0x09, 0x40, 0xDB, 0x09, 0x40, 0xED, 0x08, 0x30, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0,
  0x23, 0x08, 0xB0, 0xE4, 0x0B, 0xD0, 0x43, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x83, 0x04,
  0xC0, 0x53, 0x08, 0xD0, 0x13, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC3, 0x02, 0xC0, 0xB3, 0x04, 0xD0,
  0x13, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE4, 0xD4, 0xD4, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE3, 0x01,
  0xD0, 0x43, 0x0B, 0xC0, 0x23, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC3, 0x01, 0xD0, 0x83, 0x05, 0xC0,
  0x43, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x83, 0x04, 0xD0, 0xB4, 0x0E, 0xB0, 0x83, 0x02,
  0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02, 0x30, 0x8D, 0x0E, 0x40, 0x9B, 0x0D, 0x40, 0x9F, 0xD0, 0x94,
  0x0E, 0xE4, 0x02, 0xC0, 0x54, 0x0B, 0xFB, 0x0B, 0x40, 0x5F, 0x02, 0x40, 0x9B, 0x0D, 0x01, 0x40,
  0x9F, 0x90, 0x94, 0x01, 0x0D, 0xF0, 0x44, 0x02, 0xC0, 0xA5, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x50,
  0xAB, 0x0E, 0x0C, 0xB0, 0x45, 0x07, 0xC0, 0x97, 0x72, 0x09, 0xC0, 0x70, 0xAB, 0x05, 0x60, 0xBC,
  0x0A, 0x01, 0x75, 0x01, 0x0A, 0xC8, 0x1C, 0x0A, 0xB0, 0x56, 0x01, 0x0E, 0xC0, 0xE0, 0x57, 0x30,
  0x50, 0xDC, 0x82, 0xE1, 0x0A, 0xB0, 0x47, 0x02, 0x0D, 0xD8, 0x90, 0xE8, 0x42, 0x01, 0x24, 0x8D,
  0xD0, 0xD0, 0x22, 0x0B, 0xB0, 0x37, 0x10, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x30, 0xDB, 0x02, 0x73,
  0x07, 0x0E, 0xFF, 0x90, 0x85, 0xC7, 0x58, 0x11, 0x8E, 0xFB, 0x81, 0xE8, 0x15, 0x02, 0xB0, 0xD7,
  0x71, 0x89, 0x04, 0x8A, 0xDE, 0xDD, 0xB8, 0x47, 0x10, 0x5B, 0x0A, 0x77, 0x77, 0x50, 0x9B, 0x07,
  0x77, 0x77, 0x50, 0xDB, 0x03, 0x77, 0x77, 0x40, 0x3B, 0x0E, 0x77, 0x77, 0x50, 0x8B, 0x0A, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_storm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 42, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_storm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_summarize 48x48, 4-bit Alpha,  RLE, 172 bytes.
static const unsigned char ic_outlined_48_device_summarize_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE0, 0x77, 0x40, 0x10, 0xEF, 0xFF, 0xA0, 0x77, 0x30, 0x9F, 0xFF, 0xC0,
  0x77, 0x20, 0xDF, 0xFF, 0xD0, 0x77, 0x1C, 0x77, 0x4E, 0x07, 0x7C, 0x77, 0x4F, 0x07, 0x6C, 0x77,
  0x4F, 0x90, 0x75, 0xC7, 0x74, 0xFA, 0x07, 0x4C, 0x48, 0x24, 0xDD, 0x47, 0x3F, 0xB0, 0x73, 0xC4,
  0x0D, 0xA0, 0xD7, 0x3F, 0xC0, 0x72, 0xC4, 0x0D, 0xA0, 0xD7, 0x3F, 0xD0, 0x71, 0xC4, 0x82, 0x4D,
  0xD4, 0x73, 0xFE, 0x07, 0xC7, 0x74, 0xFF, 0xC7, 0x74, 0xFF, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F,
  0x94, 0x82, 0x4D, 0xD4, 0x77, 0x6F, 0x94, 0x0D, 0xA0, 0xD7, 0x76, 0xF9, 0x40, 0xDA, 0x0D, 0x77,
  0x6F, 0x94, 0x82, 0x4D, 0xD4, 0x77, 0x6F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F,
  0x97, 0x77, 0x7F, 0x94, 0x82, 0x4D, 0xD4, 0x77, 0x6F, 0x94, 0x0D, 0xA0, 0xD7, 0x76, 0xF9, 0x40,
  0xDA, 0x0D, 0x77, 0x6F, 0x94, 0x82, 0x4D, 0xD4, 0x77, 0x6F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F,
  0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1,
  0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAE, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_summarize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_summarize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_system_security_update_good 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_outlined_48_device_system_security_update_good_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x02, 0x05, 0x4F, 0x97, 0x68, 0x22, 0xDF,
  0x63, 0xF9, 0x75, 0x02, 0x0D, 0xB0, 0x62, 0xF9, 0x74, 0x02, 0x0D, 0xC0, 0x92, 0xF9, 0x50, 0x34,
  0x02, 0x0D, 0xC0, 0x93, 0xF9, 0x48, 0x1A, 0xE4, 0x20, 0x20, 0xDC, 0x09, 0x4F, 0x93, 0x0A, 0xA8,
  0x2E, 0x42, 0xDC, 0x09, 0x5F, 0x92, 0x04, 0xC0, 0xE0, 0xDC, 0x09, 0x6F, 0x93, 0x06, 0xF9, 0x09,
  0x7F, 0x94, 0x06, 0xE0, 0x97, 0x1F, 0x95, 0x06, 0xC0, 0x97, 0x2F, 0x96, 0x06, 0xA0, 0x97, 0x3F,
  0x97, 0x06, 0x09, 0x74, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0x80, 0x9E, 0x4F, 0x77, 0x6F, 0x97, 0x76, 0xC0, 0xDF, 0xFF, 0xD0, 0xD0, 0xAF,
  0xFF, 0xD8, 0x1A, 0x1E, 0xFF, 0xFB, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_system_security_update_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_system_security_update_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_system_security_update 48x48, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_outlined_48_device_system_security_update_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9,
  0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x40, 0x70, 0x32, 0xC2, 0x03, 0x07, 0x4F, 0x93, 0x82,
  0x7F, 0xE3, 0x1C, 0x18, 0x23, 0xEF, 0x73, 0xF9, 0x20, 0x7B, 0x0E, 0x03, 0xC0, 0x30, 0xEB, 0x07,
  0x2F, 0x92, 0x07, 0xC0, 0xEC, 0x0E, 0xC0, 0x72, 0xF9, 0x30, 0x7F, 0xD0, 0x73, 0xF9, 0x40, 0x7F,
  0xB0, 0x74, 0xF9, 0x50, 0x7F, 0x90, 0x75, 0xF9, 0x60, 0x7E, 0x07, 0x6F, 0x97, 0x07, 0xC0, 0x77,
  0xF9, 0x71, 0x07, 0xA0, 0x77, 0x1F, 0x97, 0x20, 0x07, 0x72, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x4F, 0x77, 0x6F, 0x97, 0x76, 0xC0, 0xDF, 0xFF, 0xD0, 0xD0,
  0xAF, 0xFF, 0xD8, 0x1A, 0x1E, 0xFF, 0xFB, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_system_security_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_system_security_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_system_security_update_warning 48x48, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_outlined_48_device_system_security_update_warning_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x1A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0xC7, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C,
  0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9,
  0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97,
  0x76, 0xF9, 0x77, 0x6F, 0x97, 0x1C, 0x71, 0xF9, 0x71, 0xC7, 0x1F, 0x97, 0x1C, 0x71, 0xF9, 0x71,
  0xC7, 0x1F, 0x97, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE4, 0xF7, 0x76, 0xF9, 0x77, 0x6C, 0x0D, 0xFF,
  0xFD, 0x0D, 0x0A, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE, 0x81,
  0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_system_security_update_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_device_system_security_update_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_task 48x48, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_outlined_48_device_task_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xA0, 0x77, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x09, 0xFF, 0xF0, 0x77,
  0x20, 0xDF, 0xFF, 0x90, 0x77, 0x1C, 0x77, 0xE0, 0x77, 0xC7, 0x7F, 0x07, 0x6C, 0x77, 0xF9, 0x07,
  0x5C, 0x77, 0xFA, 0x07, 0x4C, 0x77, 0xFB, 0x07, 0x3C, 0x77, 0xFC, 0x07, 0x2C, 0x77, 0xFD, 0x07,
  0x1C, 0x77, 0xFE, 0x07, 0xC7, 0x7F, 0xFC, 0x77, 0xFF, 0xC7, 0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97,
  0x77, 0x3F, 0x97, 0x77, 0x3F, 0x97, 0x73, 0x81, 0x4D, 0x24, 0xF9, 0x77, 0x20, 0x4A, 0x0D, 0x02,
  0x3F, 0x97, 0x71, 0x04, 0xC0, 0xD3, 0xF9, 0x77, 0x04, 0xD0, 0x53, 0xF9, 0x50, 0x90, 0x26, 0x04,
  0xD0, 0x54, 0xF9, 0x48, 0x2B, 0xFD, 0x24, 0x04, 0xD0, 0x55, 0xF9, 0x30, 0xBB, 0x0D, 0x02, 0x20,
  0x4D, 0x05, 0x6F, 0x93, 0x09, 0xC8, 0x1D, 0x24, 0xD0, 0x57, 0xF9, 0x40, 0x9C, 0x0E, 0xD0, 0x57,
  0x1F, 0x95, 0x09, 0xF9, 0x05, 0x72, 0xF9, 0x60, 0x9E, 0x05, 0x73, 0xF9, 0x70, 0x9C, 0x05, 0x74,
  0xF9, 0x71, 0x09, 0xA0, 0x57, 0x5F, 0x97, 0x20, 0x90, 0x57, 0x6F, 0x97, 0x77, 0x3F, 0x97, 0x77,
  0x3F, 0x97, 0x77, 0x3F, 0x97, 0x77, 0x3C, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81,
  0xA1, 0xEF, 0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xEF, 0xFF, 0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_task() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_task_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_thermostat 48x48, 4-bit Alpha,  RLE, 140 bytes.
static const unsigned char ic_outlined_48_device_thermostat_data[] PROGMEM = {
  0x78, 0x46, 0xCE, 0xEC, 0x67, 0x50, 0x10, 0xCE, 0x0C, 0x01, 0x73, 0x0C, 0xF9, 0x0C, 0x72, 0x06,
  0xFB, 0x06, 0x71, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x71, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7,
  0x1C, 0x2E, 0x71, 0xC2, 0xE7, 0x1C, 0x4C, 0x71, 0xC4, 0xC7, 0x1C, 0x4C, 0x71, 0xC4, 0xC7, 0x1C,
  0x2E, 0x71, 0xC2, 0xE7, 0x1C, 0x4C, 0x71, 0xC4, 0xC7, 0x1C, 0x4C, 0x71, 0xC4, 0xC7, 0x1F, 0xD7,
  0x1F, 0xD7, 0x1F, 0xD7, 0x1F, 0xD7, 0x08, 0xFD, 0x08, 0x50, 0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0,
  0x42, 0x0D, 0xFF, 0xA8, 0x1D, 0x04, 0xFF, 0xC0, 0x40, 0xAF, 0xFC, 0x0A, 0x0C, 0xFF, 0xC0, 0xC0,
  0xEF, 0xFC, 0x00, 0xEF, 0xFC, 0x0E, 0x0D, 0xFF, 0xC0, 0xD0, 0x9F, 0xFC, 0x09, 0x05, 0xFF, 0xC8,
  0x15, 0x0D, 0xFF, 0xA0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87,
  0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_thermostat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 4, 33, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_thermostat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_timer_10_select 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_outlined_48_device_timer_10_select_data[] PROGMEM = {
  0xFB, 0x58, 0x16, 0xCE, 0xE8, 0x1E, 0xC6, 0x77, 0x3F, 0xB3, 0x01, 0x0C, 0xFD, 0x0C, 0x01, 0x77,
  0x1F, 0xB3, 0x0C, 0xFF, 0x0C, 0x77, 0x1F, 0xB2, 0x06, 0xFF, 0xA0, 0x67, 0x7F, 0xB2, 0x0C, 0xFF,
  0xA0, 0xC7, 0x7F, 0xB2, 0x0E, 0xFF, 0xA0, 0xE7, 0x74, 0xE2, 0xE6, 0xE7, 0x74, 0xE2, 0xE6, 0xE7,
  0x74, 0xE2, 0xE6, 0xE7, 0x74, 0xE2, 0xE6, 0xE7, 0x74, 0xE2, 0xE6, 0xE7, 0x74, 0xE2, 0xE6, 0xE7,
  0x74, 0xE2, 0xE6, 0xE3, 0x08, 0x0D, 0xFA, 0x4E, 0x2E, 0x6E, 0x20, 0x8F, 0xC4, 0xE2, 0xE6, 0xE2,
  0x0D, 0xFC, 0x4E, 0x2E, 0x6E, 0x2F, 0xD4, 0xE2, 0xE6, 0xE2, 0xC7, 0x5E, 0x2E, 0x6E, 0x2C, 0x75,
  0xE2, 0xE6, 0xE2, 0xFA, 0x0D, 0x08, 0x5E, 0x2E, 0x6E, 0x20, 0xDF, 0xB0, 0x84, 0xE2, 0xE6, 0xE2,
  0x08, 0xFB, 0x0D, 0x4E, 0x2E, 0x6E, 0x30, 0x80, 0xDF, 0xA4, 0xE2, 0x0E, 0xFF, 0xA0, 0xE7, 0x3C,
  0x4E, 0x20, 0xCF, 0xFA, 0x0C, 0x73, 0xC4, 0xE2, 0x06, 0xFF, 0xA0, 0x62, 0xFD, 0x4E, 0x30, 0xCF,
  0xF0, 0xC3, 0xFC, 0x0D, 0x4E, 0x30, 0x10, 0xCF, 0xD0, 0xC0, 0x13, 0xFC, 0x08, 0x4E, 0x58, 0x16,
  0xCE, 0xE8, 0x1E, 0xC6, 0x5F, 0xA0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_timer_10_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_outlined_48_device_timer_10_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_timer_3_select 48x48, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_outlined_48_device_timer_3_select_data[] PROGMEM = {
  0xFD, 0x81, 0xEC, 0x67, 0x75, 0xFF, 0x90, 0xC0, 0x17, 0x73, 0xFF, 0xA0, 0xC7, 0x73, 0xFF, 0xB0,
  0x67, 0x72, 0xFF, 0xB0, 0xC7, 0x72, 0xFF, 0xB0, 0xE7, 0x77, 0x7E, 0x77, 0x77, 0xE7, 0x77, 0x7E,
  0x77, 0x77, 0xE7, 0x77, 0x7D, 0x0D, 0x77, 0x2F, 0xFB, 0x09, 0x77, 0x2F, 0xFA, 0x0D, 0x60, 0x80,
  0xDF, 0xFF, 0xA0, 0xD0, 0x96, 0x08, 0xFF, 0xFC, 0x0D, 0x09, 0x60, 0xDF, 0xFF, 0xE0, 0xD5, 0xFF,
  0xFF, 0x90, 0x94, 0xC7, 0x76, 0xD0, 0xD4, 0xC7, 0x76, 0xE4, 0xFA, 0x0D, 0x08, 0x76, 0xE4, 0x0D,
  0xFB, 0x08, 0x75, 0xE4, 0x08, 0xFB, 0x0D, 0x75, 0xE5, 0x08, 0x0D, 0xFF, 0xFD, 0x0E, 0x75, 0xFF,
  0xF0, 0xC7, 0x5F, 0xFF, 0x06, 0x4F, 0xFF, 0xF0, 0xC5, 0xFC, 0x0D, 0xFF, 0x90, 0xC0, 0x15, 0xFC,
  0x08, 0xFD, 0x81, 0xEC, 0x67, 0xFA, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_timer_3_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 10, 41, 37), Box(0, 0, 47, 47),
      ic_outlined_48_device_timer_3_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_tungsten 48x48, 4-bit Alpha,  RLE, 231 bytes.
static const unsigned char ic_outlined_48_device_tungsten_data[] PROGMEM = {
  0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xC4, 0xC7, 0x77,
  0x7C, 0x4C, 0x77, 0x77, 0xC4, 0xC7, 0x77, 0x7C, 0x4C, 0x77, 0x77, 0xC8, 0x2D, 0xEE, 0xDC, 0x77,
  0x77, 0xFD, 0x77, 0x76, 0x07, 0xFD, 0x07, 0x77, 0x74, 0x07, 0xFF, 0x07, 0x77, 0x72, 0x03, 0xD0,
  0x80, 0x32, 0x03, 0x08, 0xD0, 0x37, 0x77, 0x10, 0xDB, 0x0D, 0x03, 0x60, 0x30, 0xDB, 0x0D, 0x77,
  0x70, 0x4C, 0x03, 0x71, 0x03, 0xC0, 0x47, 0x76, 0x0A, 0xB0, 0x87, 0x30, 0x8B, 0x0A, 0x73, 0xE4,
  0x0C, 0xB0, 0x37, 0x30, 0x3B, 0x0C, 0x4F, 0xD4, 0x0E, 0xB7, 0x5B, 0x0E, 0x4F, 0xD4, 0x0E, 0xB7,
  0x5B, 0x0E, 0x4F, 0xD4, 0x0D, 0xB0, 0x37, 0x30, 0x3B, 0x0D, 0x4E, 0x73, 0x09, 0xB0, 0x87, 0x30,
  0x8B, 0x09, 0x77, 0x60, 0x5C, 0x03, 0x71, 0x03, 0xC0, 0x57, 0x77, 0x0D, 0xB0, 0xD0, 0x36, 0x03,
  0x0D, 0xB0, 0xD7, 0x77, 0x10, 0x4D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x04, 0x77, 0x72, 0x08, 0xFF,
  0x08, 0x77, 0x74, 0x08, 0xFD, 0x08, 0x77, 0x76, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x77, 0x71, 0x81,
  0x5E, 0x35, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x58, 0x12, 0xE5, 0x77, 0x10, 0x5A, 0x0E, 0x03, 0x77,
  0x20, 0x20, 0xEA, 0x05, 0x76, 0x05, 0xC0, 0xE7, 0x72, 0x0E, 0xC0, 0x57, 0x40, 0x5D, 0x05, 0x77,
  0x20, 0x5D, 0x05, 0x73, 0x05, 0xC0, 0x57, 0x74, 0x05, 0xC0, 0x57, 0x40, 0x5A, 0x05, 0x71, 0xC7,
  0x10, 0x5A, 0x05, 0x76, 0x00, 0x57, 0x2C, 0x72, 0x00, 0x57, 0x77, 0x4C, 0x80, 0xC0, 0x0C, 0x80,
  0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_tungsten() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_tungsten_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_usb_off 48x48, 4-bit Alpha,  RLE, 307 bytes.
static const unsigned char ic_outlined_48_device_usb_off_data[] PROGMEM = {
  0x77, 0x60, 0x05, 0x77, 0x60, 0x27, 0x72, 0x82, 0x2E, 0xE2, 0x77, 0x48, 0x14, 0xF7, 0x77, 0x10,
  0xCA, 0x0C, 0x77, 0x30, 0x4B, 0x07, 0x76, 0x09, 0xC0, 0x97, 0x72, 0x0E, 0xC0, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x10, 0x30, 0xEC, 0x07, 0x72, 0x02, 0x0E, 0xE0, 0xE0, 0x27, 0x71, 0x03, 0x0E, 0xC0,
  0x77, 0x10, 0xCF, 0x90, 0xC7, 0x72, 0x03, 0x0E, 0xC0, 0x76, 0x09, 0xFB, 0x09, 0x77, 0x20, 0x30,
  0xEC, 0x07, 0x72, 0xC7, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x1C, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77,
  0xC7, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x6C, 0x77, 0x73, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB4, 0xF9,
  0x75, 0x02, 0x0E, 0xD0, 0x75, 0x0C, 0xA4, 0xF9, 0x75, 0x0A, 0xF0, 0x75, 0x0C, 0x94, 0xF9, 0x75,
  0x0E, 0xF9, 0x07, 0x50, 0xC4, 0xF9, 0x75, 0x0E, 0xFA, 0x07, 0x72, 0xF9, 0x75, 0x0A, 0xFB, 0x07,
  0x71, 0xF9, 0x75, 0x02, 0x0E, 0xC0, 0x0E, 0xC0, 0x77, 0xF9, 0x76, 0x01, 0xC8, 0x11, 0x3E, 0xC0,
  0x76, 0xF9, 0x77, 0xC2, 0x03, 0x0E, 0xC0, 0x77, 0xC7, 0x72, 0xC3, 0x03, 0x0E, 0xC0, 0x76, 0xC7,
  0x72, 0xC4, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB7, 0x72, 0xC5, 0x03, 0xD0, 0x75, 0x0C, 0xA7, 0x72,
  0x0D, 0xFF, 0x90, 0x75, 0x0C, 0x0E, 0x77, 0x20, 0xAF, 0xFA, 0x07, 0x50, 0x77, 0x72, 0x01, 0x0E,
  0xFF, 0xA0, 0x77, 0x77, 0x18, 0x11, 0xAE, 0xFF, 0x90, 0x77, 0x77, 0x72, 0xC0, 0x30, 0xEC, 0x07,
  0x77, 0x77, 0x1C, 0x10, 0x30, 0xEC, 0x07, 0x77, 0x77, 0xC2, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x6C,
  0x30, 0x30, 0xEC, 0x07, 0x77, 0x74, 0x01, 0xC0, 0x13, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x20, 0x20,
  0xEC, 0x0E, 0x02, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x71, 0x0A, 0xE0, 0xA4, 0x03, 0x0E, 0xC0, 0x77,
  0x77, 0x0E, 0xE0, 0xE5, 0x03, 0x0E, 0xC0, 0x77, 0x76, 0x0D, 0xE0, 0xD6, 0x03, 0x0E, 0xC0, 0x77,
  0x75, 0x0A, 0xE0, 0xA7, 0x03, 0x0E, 0xC0, 0x77, 0x74, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x10, 0x30,
  0xEB, 0x0E, 0x02, 0x77, 0x48, 0x41, 0xAD, 0xDA, 0x17, 0x38, 0x33, 0xEF, 0xE4, 0x80, 0xC0, 0x08,
  0x13, 0xE4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_usb_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_usb_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_usb 48x48, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_outlined_48_device_usb_data[] PROGMEM = {
  0x77, 0x00, 0x57, 0x77, 0x58, 0x22, 0xEE, 0x27, 0x77, 0x40, 0xCA, 0x0C, 0x77, 0x73, 0x09, 0xC0,
  0x97, 0x77, 0x10, 0x5E, 0x05, 0x77, 0x60, 0x20, 0xEE, 0x0E, 0x02, 0x77, 0x50, 0xCF, 0x90, 0xC7,
  0x74, 0x09, 0xFB, 0x09, 0x77, 0x7C, 0x77, 0x74, 0xC7, 0x77, 0x4C, 0x77, 0x18, 0x21, 0x44, 0x16,
  0xC7, 0x70, 0x8C, 0x08, 0x5C, 0x4F, 0x91, 0x08, 0xE0, 0x84, 0xC4, 0xF9, 0x01, 0xF9, 0x01, 0x3C,
  0x4F, 0x90, 0x4F, 0x90, 0x43, 0xC4, 0xF9, 0x05, 0xF9, 0x05, 0x3C, 0x4F, 0x90, 0x1F, 0x90, 0x13,
  0xC4, 0xF9, 0x10, 0x8E, 0x08, 0x4C, 0x4F, 0x92, 0x07, 0xC0, 0x75, 0xC4, 0xF9, 0x3C, 0x6C, 0x6C,
  0x5C, 0x6C, 0x6C, 0x5C, 0x6C, 0x6C, 0x5C, 0x6C, 0x6C, 0x50, 0xDF, 0xFF, 0x90, 0xD5, 0x0A, 0xFF,
  0xF9, 0x0A, 0x50, 0x10, 0xEF, 0xFE, 0x0E, 0x01, 0x68, 0x11, 0xAE, 0xFF, 0xA8, 0x1E, 0xA1, 0x77,
  0x2C, 0x77, 0x74, 0xC7, 0x77, 0x4C, 0x77, 0x74, 0xC7, 0x77, 0x4C, 0x77, 0x74, 0xC7, 0x77, 0x30,
  0x8C, 0x08, 0x77, 0x71, 0x08, 0xE0, 0x87, 0x76, 0x01, 0xF9, 0x01, 0x77, 0x50, 0x5F, 0x90, 0x57,
  0x75, 0x04, 0xF9, 0x04, 0x77, 0x50, 0x1F, 0x90, 0x17, 0x76, 0x08, 0xE0, 0x87, 0x77, 0x10, 0x8C,
  0x08, 0x77, 0x73, 0x82, 0x14, 0x41, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_usb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 2, 37, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_usb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wallpaper 48x48, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_outlined_48_device_wallpaper_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0x4F, 0xF8, 0x4D, 0xA1, 0x01, 0xEF, 0xFA, 0x4F, 0xFA, 0x81, 0xE1, 0xAF,
  0xFB, 0x4F, 0xFB, 0x0A, 0x0D, 0xFF, 0xB4, 0xFF, 0xB0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x78, 0x28, 0xDD, 0x87, 0xF9, 0x77, 0x60, 0x8C, 0x08, 0x6F, 0x97, 0x76, 0x0D, 0xC0, 0xD6, 0xF9,
  0x77, 0x60, 0xDC, 0x0D, 0x6F, 0x97, 0x76, 0x08, 0xC0, 0x86, 0xF9, 0x77, 0x78, 0x28, 0xDD, 0x87,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC8, 0x0A, 0xB4, 0x0C, 0x74, 0x00, 0x67, 0x75, 0xF9,
  0x73, 0x03, 0xA0, 0x37, 0x74, 0xF9, 0x72, 0x01, 0x0D, 0xA0, 0xD0, 0x16, 0x00, 0x57, 0x2F, 0x97,
  0x20, 0xBC, 0x0C, 0x58, 0x22, 0xEE, 0x27, 0x1F, 0x97, 0x10, 0x9E, 0x09, 0x40, 0xCA, 0x0C, 0x71,
  0xF9, 0x70, 0x6F, 0x90, 0x62, 0x09, 0xC0, 0x97, 0xF9, 0x60, 0x3F, 0xB0, 0x30, 0x5E, 0x05, 0x6F,
  0x95, 0x01, 0x0D, 0xFB, 0x00, 0xEE, 0x0E, 0x02, 0x5F, 0x95, 0x0B, 0xFF, 0xE0, 0xC5, 0xF9, 0x40,
  0x9F, 0xFF, 0x90, 0x94, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xC0, 0xDF, 0xFB, 0x4F, 0xFB, 0x0D, 0x0A, 0xFF, 0xB4, 0xFF, 0xB8, 0x1A, 0x1E, 0xFF,
  0xA4, 0xFF, 0xA8, 0x4E, 0x10, 0x1A, 0xDF, 0xF4, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wallpaper() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_wallpaper_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_water 48x48, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_outlined_48_device_water_data[] PROGMEM = {
  0x38, 0x64, 0xBE, 0xFE, 0xC7, 0x15, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x25, 0x86, 0x17, 0xCE, 0xFD,
  0xA5, 0x40, 0x40, 0xCF, 0x84, 0xE7, 0x20, 0x3A, 0xF9, 0x84, 0xA3, 0x01, 0x7E, 0xF8, 0x1C, 0x51,
  0x80, 0xC3, 0xF0, 0xE8, 0x0C, 0x3F, 0x0E, 0xC8, 0x4A, 0x30, 0x27, 0xEF, 0x84, 0xC5, 0x01, 0x5C,
  0xF8, 0x4E, 0x71, 0x03, 0xAB, 0x83, 0xEF, 0xD9, 0x25, 0x86, 0x17, 0xCE, 0xFE, 0xB5, 0x68, 0x65,
  0xAE, 0xFE, 0xC7, 0x15, 0x82, 0x29, 0xDE, 0x80, 0x99, 0x70, 0x86, 0x4B, 0xEF, 0xEC, 0x71, 0x58,
  0x12, 0x9D, 0xA8, 0x1D, 0x92, 0x58, 0x61, 0x7C, 0xEF, 0xDA, 0x54, 0x04, 0x0C, 0xF8, 0x4E, 0x72,
  0x03, 0xAF, 0x98, 0x4A, 0x30, 0x17, 0xEF, 0x81, 0xC5, 0x18, 0x0C, 0x3F, 0x0E, 0x80, 0xC3, 0xF0,
  0xEC, 0x84, 0xA3, 0x02, 0x7E, 0xF8, 0x4C, 0x50, 0x15, 0xCF, 0x84, 0xE7, 0x10, 0x3A, 0xB8, 0x3E,
  0xFD, 0x92, 0x58, 0x61, 0x7C, 0xEF, 0xEB, 0x56, 0x86, 0x5A, 0xEF, 0xEC, 0x71, 0x58, 0x22, 0x9D,
  0xE8, 0x09, 0x97, 0x08, 0x64, 0xBE, 0xFE, 0xC7, 0x15, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x36, 0x85,
  0x7C, 0xEF, 0xEB, 0x54, 0x04, 0x0C, 0xF8, 0x4E, 0x72, 0x03, 0xAF, 0x98, 0x4A, 0x30, 0x17, 0xEF,
  0x81, 0xC5, 0x18, 0x09, 0xA0, 0xF8, 0x4A, 0x30, 0x27, 0xEF, 0x84, 0xC5, 0x01, 0x5C, 0xF8, 0x4E,
  0x71, 0x03, 0xAD, 0x81, 0xD9, 0x25, 0x86, 0x17, 0xCE, 0xFE, 0xB4, 0x68, 0x65, 0xAE, 0xFE, 0xC7,
  0x15, 0x81, 0x29, 0xD9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_water() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 14, 43, 35), Box(0, 0, 47, 47),
      ic_outlined_48_device_water_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_widgets 48x48, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_outlined_48_device_widgets_data[] PROGMEM = {
  0x77, 0x76, 0x05, 0x80, 0xC1, 0x08, 0x1B, 0xF6, 0x77, 0x77, 0x70, 0xBB, 0x06, 0x72, 0xFF, 0xA7,
  0x10, 0xBD, 0x06, 0x71, 0xFF, 0xA7, 0x0B, 0xF0, 0x67, 0xFF, 0xA6, 0x0B, 0xFA, 0x06, 0x6F, 0xFA,
  0x50, 0xBC, 0x81, 0xC5, 0xEC, 0x07, 0x5C, 0x71, 0xC4, 0x0B, 0xC8, 0x3C, 0x10, 0x3E, 0xC0, 0x74,
  0xC7, 0x1C, 0x30, 0xBC, 0x0C, 0x01, 0x30, 0x30, 0xEC, 0x07, 0x3C, 0x71, 0xC2, 0x0B, 0xC0, 0xC0,
  0x15, 0x03, 0x0E, 0xC0, 0x72, 0xC7, 0x1C, 0x10, 0xBC, 0x0C, 0x01, 0x70, 0x30, 0xEC, 0x07, 0x1C,
  0x71, 0xC0, 0xBC, 0x0D, 0x01, 0x72, 0x04, 0xD0, 0x5C, 0x71, 0xC0, 0x30, 0xEC, 0x07, 0x72, 0x0B,
  0xC0, 0xB1, 0xC7, 0x1C, 0x10, 0x30, 0xEC, 0x07, 0x70, 0xBC, 0x0B, 0x2C, 0x71, 0xC2, 0x03, 0x0E,
  0xC0, 0x75, 0x0B, 0xC0, 0xB3, 0xFF, 0xA3, 0x03, 0x0E, 0xC0, 0x73, 0x0B, 0xC0, 0xB4, 0xFF, 0xA4,
  0x03, 0x0E, 0xC8, 0x17, 0x0B, 0xC0, 0xB5, 0xFF, 0xA5, 0x03, 0x0E, 0xC0, 0xDC, 0x0B, 0x6F, 0xFA,
  0x60, 0x30, 0xEF, 0x0B, 0x77, 0x77, 0x20, 0x30, 0xED, 0x0B, 0x77, 0x77, 0x40, 0x30, 0xEB, 0x0B,
  0x77, 0x77, 0x68, 0x23, 0xEF, 0xB8, 0x0C, 0x00, 0x03, 0x0B, 0x74, 0xFF, 0xA4, 0xFF, 0xA3, 0xFF,
  0xA4, 0xFF, 0xA3, 0xFF, 0xA4, 0xFF, 0xA3, 0xFF, 0xA4, 0xFF, 0xA3, 0xC7, 0x1C, 0x4C, 0x71, 0xC3,
  0xC7, 0x1C, 0x4C, 0x71, 0xC3, 0xC7, 0x1C, 0x4C, 0x71, 0xC3, 0xC7, 0x1C, 0x4C, 0x71, 0xC3, 0xC7,
  0x1C, 0x4C, 0x71, 0xC3, 0xC7, 0x1C, 0x4C, 0x71, 0xC3, 0xC7, 0x1C, 0x4C, 0x71, 0xC3, 0xC7, 0x1C,
  0x4C, 0x71, 0xC3, 0xFF, 0xA4, 0xFF, 0xA3, 0xFF, 0xA4, 0xFF, 0xA3, 0xFF, 0xA4, 0xFF, 0xA3, 0xFF,
  0xA4, 0xFF, 0xA3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_widgets() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 44, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_widgets_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_1_bar 48x48, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_outlined_48_device_wifi_1_bar_data[] PROGMEM = {
  0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x54, 0x04, 0x0D, 0xF9, 0x82, 0xD4, 0x08, 0xFD, 0x08, 0x07, 0xFD,
  0x81, 0x70, 0x7F, 0xB0, 0x73, 0x07, 0xF9, 0x07, 0x50, 0x7E, 0x07, 0x70, 0x7C, 0x07, 0x72, 0x07,
  0xA0, 0x77, 0x40, 0x07, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(17, 32, 30, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_2_bar 48x48, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_outlined_48_device_wifi_2_bar_data[] PROGMEM = {
  0x73, 0x83, 0x48, 0xAD, 0xDA, 0x83, 0xDD, 0xA8, 0x47, 0x73, 0x81, 0x4A, 0xEF, 0xD8, 0x1E, 0xA4,
  0x75, 0x04, 0x0C, 0xFF, 0xC0, 0xC0, 0x47, 0x10, 0x10, 0xBF, 0xFF, 0x90, 0xB0, 0x25, 0x04, 0x0E,
  0xFF, 0xFB, 0x0E, 0x05, 0x30, 0x7F, 0xFF, 0xF8, 0x17, 0x04, 0xFB, 0x82, 0xB6, 0x32, 0x28, 0x22,
  0x36, 0xBF, 0xB8, 0x14, 0x07, 0xE0, 0xE0, 0x67, 0x50, 0x60, 0xEE, 0x07, 0x30, 0x7C, 0x07, 0x77,
  0x20, 0x7C, 0x07, 0x58, 0x27, 0xFE, 0x37, 0x74, 0x82, 0x3E, 0xF7, 0x70, 0x60, 0x27, 0x76, 0x01,
  0x06, 0x80, 0xD4, 0x08, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x77, 0x10, 0x40, 0xDF, 0x90, 0xD0, 0x47,
  0x75, 0x08, 0xFD, 0x08, 0x77, 0x40, 0x7F, 0xD0, 0x77, 0x75, 0x07, 0xFB, 0x07, 0x77, 0x70, 0x7F,
  0x90, 0x77, 0x77, 0x20, 0x7E, 0x07, 0x77, 0x74, 0x07, 0xC0, 0x77, 0x77, 0x60, 0x7A, 0x07, 0x77,
  0x77, 0x10, 0x07, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 20, 39, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_calling_3 48x48, 4-bit Alpha,  RLE, 316 bytes.
static const unsigned char ic_outlined_48_device_wifi_calling_3_data[] PROGMEM = {
  0x04, 0x0D, 0xF9, 0x0E, 0x08, 0x73, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB8, 0x47, 0x0D, 0xFC, 0x03,
  0x68, 0x11, 0x9E, 0xFB, 0x81, 0xE8, 0x14, 0x0E, 0xFC, 0x06, 0x50, 0x80, 0xEF, 0xF0, 0xE0, 0x73,
  0x0C, 0xFC, 0x0A, 0x30, 0x10, 0xCC, 0x82, 0xD8, 0x42, 0x28, 0x22, 0x48, 0xDC, 0x82, 0xB1, 0x0A,
  0xB0, 0x43, 0x03, 0xB0, 0xD2, 0x01, 0x0D, 0xB0, 0xC0, 0x37, 0x30, 0x40, 0xCB, 0x81, 0xD1, 0x9B,
  0x07, 0x4C, 0x30, 0x8A, 0x06, 0x77, 0x07, 0xA8, 0x17, 0x06, 0xB0, 0xA4, 0x0D, 0xB0, 0x33, 0x07,
  0x03, 0x48, 0x65, 0xAD, 0xEE, 0xD9, 0x54, 0x04, 0x07, 0x20, 0x3B, 0x0D, 0x40, 0x9B, 0x07, 0x70,
  0x50, 0xDF, 0x90, 0xD0, 0x47, 0x0E, 0xB0, 0x23, 0x07, 0xB0, 0xA6, 0x08, 0xFD, 0x07, 0x60, 0xAB,
  0x07, 0x20, 0x30, 0xEB, 0x0B, 0x60, 0x8A, 0x81, 0xD7, 0x22, 0x81, 0x27, 0xEA, 0x06, 0x60, 0x6B,
  0x82, 0xC0, 0x3E, 0xC0, 0x57, 0x08, 0x09, 0x71, 0x0A, 0x06, 0x70, 0x1C, 0x06, 0x0E, 0xC0, 0x77,
  0x77, 0x70, 0xAF, 0x90, 0x77, 0x58, 0x42, 0xAE, 0xEA, 0x27, 0x40, 0x5F, 0x08, 0x76, 0x07, 0xC0,
  0x67, 0x50, 0xDD, 0x08, 0x77, 0x10, 0x8A, 0x07, 0x76, 0x06, 0xC0, 0x87, 0x73, 0x08, 0x07, 0x77,
  0x10, 0xDB, 0x0A, 0x77, 0x77, 0x60, 0x6C, 0x05, 0x77, 0x77, 0x60, 0xCB, 0x0E, 0x01, 0x77, 0x77,
  0x50, 0x2C, 0x0A, 0x77, 0x77, 0x60, 0x7C, 0x08, 0x77, 0x77, 0x60, 0xCC, 0x06, 0x77, 0x77, 0x50,
  0x10, 0xDC, 0x05, 0x74, 0x83, 0x5B, 0x96, 0x37, 0x73, 0x02, 0x0E, 0xC0, 0x67, 0x20, 0x6E, 0x82,
  0xC9, 0x63, 0x76, 0x04, 0xD0, 0x87, 0x06, 0xFC, 0x08, 0x76, 0x05, 0xD0, 0xA0, 0x14, 0x06, 0xFD,
  0x0E, 0x77, 0x04, 0x0E, 0xC0, 0xE0, 0x52, 0x06, 0xC8, 0x2E, 0x79, 0xCE, 0x77, 0x10, 0x20, 0xDD,
  0x0A, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0xC7, 0x72, 0x01, 0x0C, 0xFA, 0x0E, 0x03, 0x6C, 0x77, 0x40,
  0x7F, 0x90, 0x67, 0xC7, 0x75, 0x02, 0x0C, 0xF8, 0x1C, 0x72, 0x4C, 0x77, 0x70, 0x60, 0xDF, 0x98,
  0x2D, 0xA7, 0x4C, 0x77, 0x72, 0x06, 0x0D, 0xFF, 0x77, 0x74, 0x04, 0x0A, 0xFD, 0x77, 0x76, 0x82,
  0x16, 0xAE, 0xF0, 0xD7, 0x77, 0x73, 0x86, 0x26, 0x9A, 0xCE, 0xD4, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_calling_3() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 44, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_calling_3_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_channel 48x48, 4-bit Alpha,  RLE, 327 bytes.
static const unsigned char ic_outlined_48_device_wifi_channel_data[] PROGMEM = {
  0x77, 0x72, 0x83, 0x19, 0xEE, 0x97, 0x77, 0x72, 0x01, 0x0D, 0xC0, 0xC0, 0x17, 0x77, 0x70, 0xBE,
  0x0A, 0x77, 0x76, 0x05, 0xF9, 0x05, 0x77, 0x75, 0x0C, 0xB0, 0x0A, 0xB0, 0xC7, 0x77, 0x40, 0x3B,
  0x82, 0xE1, 0x1E, 0xB0, 0x47, 0x77, 0x30, 0xAB, 0x08, 0x20, 0x8B, 0x0A, 0x77, 0x73, 0x0E, 0xB0,
  0x22, 0x02, 0xB0, 0xE7, 0x77, 0x20, 0x4B, 0x0C, 0x40, 0xCB, 0x05, 0x77, 0x71, 0x09, 0xB0, 0x84,
  0x08, 0xB0, 0x97, 0x48, 0x28, 0xDD, 0x87, 0x0D, 0xB0, 0x34, 0x03, 0xB0, 0xD7, 0x30, 0xBC, 0x0B,
  0x50, 0x1C, 0x6C, 0x02, 0x71, 0x09, 0xE0, 0x94, 0x05, 0xB0, 0xB6, 0x0B, 0xB0, 0x57, 0x03, 0xF9,
  0x03, 0x30, 0x8B, 0x08, 0x60, 0x8B, 0x08, 0x70, 0xCB, 0x00, 0xCB, 0x0B, 0x30, 0xBB, 0x05, 0x60,
  0x5B, 0x0B, 0x60, 0x3C, 0x00, 0x2C, 0x03, 0x20, 0xDB, 0x02, 0x60, 0x2B, 0x0E, 0x60, 0xAB, 0x0A,
  0x20, 0xAB, 0x0A, 0x2B, 0x0E, 0x71, 0x0E, 0xB0, 0x14, 0x01, 0xC0, 0x32, 0x03, 0xC1, 0x03, 0xB0,
  0xC7, 0x10, 0xCB, 0x04, 0x40, 0x5B, 0x0D, 0x40, 0xDB, 0x00, 0x5B, 0x09, 0x71, 0x0A, 0xB0, 0x64,
  0x0A, 0xB0, 0x74, 0x07, 0xB0, 0xA0, 0x8B, 0x07, 0x71, 0x07, 0xB0, 0x94, 0x0E, 0xB0, 0x24, 0x03,
  0xB0, 0xE0, 0xBB, 0x89, 0x05, 0x04, 0xBE, 0xEB, 0x30, 0x5B, 0x0B, 0x30, 0x3B, 0x0D, 0x60, 0xDF,
  0x03, 0x08, 0xE0, 0x80, 0x3B, 0x0D, 0x30, 0x8B, 0x09, 0x60, 0x9F, 0x09, 0xF9, 0x09, 0xB0, 0xE3,
  0x0C, 0xB0, 0x56, 0x05, 0xFF, 0xF0, 0x12, 0xC0, 0x16, 0x01, 0xFB, 0x82, 0xD3, 0x3D, 0xF8, 0x13,
  0x03, 0xB0, 0xC7, 0x10, 0xCF, 0xA0, 0x22, 0x02, 0xF8, 0x14, 0x06, 0xB0, 0x97, 0x10, 0x9F, 0x90,
  0x74, 0x07, 0xE8, 0x15, 0x0A, 0xB0, 0x67, 0x10, 0x6F, 0x0D, 0x60, 0xED, 0x81, 0x70, 0xDB, 0x02,
  0x71, 0x03, 0xF0, 0x76, 0x07, 0xD0, 0x81, 0xC7, 0x3E, 0x0E, 0x01, 0x60, 0x10, 0xEC, 0x09, 0x03,
  0xB0, 0xC7, 0x30, 0xCD, 0x09, 0x71, 0x09, 0xC0, 0xB0, 0x5B, 0x0A, 0x73, 0x0A, 0xD0, 0x37, 0x10,
  0x4C, 0x0B, 0x08, 0xB0, 0x77, 0x30, 0x7C, 0x0E, 0x73, 0x0E, 0xB0, 0xC0, 0xAB, 0x05, 0x73, 0x05,
  0xC0, 0xA7, 0x30, 0x9B, 0x0D, 0x0C, 0xB0, 0x37, 0x30, 0x3C, 0x06, 0x73, 0x05, 0xB0, 0x0E, 0xB0,
  0x17, 0x30, 0x1C, 0x02, 0x73, 0x01, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_channel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_channel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_find 48x48, 4-bit Alpha,  RLE, 344 bytes.
static const unsigned char ic_outlined_48_device_wifi_find_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0x98, 0x5E, 0xB8, 0x53, 0x11, 0x28, 0x51, 0x13,
  0x58, 0xBE, 0xF9, 0x0A, 0x02, 0x74, 0x07, 0x0E, 0xE8, 0x1E, 0x84, 0x77, 0x28, 0x13, 0x8E, 0xE0,
  0xE0, 0x77, 0x10, 0x10, 0xCE, 0x0C, 0x05, 0x77, 0x71, 0x04, 0x0B, 0xE0, 0xC0, 0x15, 0x04, 0x0E,
  0xD0, 0xC0, 0x47, 0x77, 0x50, 0x30, 0xBD, 0x0E, 0x04, 0x30, 0x6D, 0x0E, 0x05, 0x77, 0x77, 0x20,
  0x50, 0xED, 0x81, 0x60, 0x7D, 0x0A, 0x01, 0x77, 0x77, 0x40, 0x10, 0xAD, 0x00, 0x7D, 0x03, 0x77,
  0x77, 0x70, 0x6C, 0x81, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x77, 0x78, 0x24, 0xEF, 0x73, 0x07, 0xC0,
  0xE0, 0x37, 0x77, 0x86, 0x28, 0xDE, 0xED, 0x82, 0x60, 0x30, 0x65, 0x07, 0xC0, 0xE0, 0x37, 0x75,
  0x09, 0xF9, 0x09, 0x76, 0x07, 0xC0, 0xE0, 0x37, 0x73, 0x0B, 0xFB, 0x0B, 0x76, 0x07, 0xC0, 0xE0,
  0x37, 0x71, 0x09, 0xFD, 0x09, 0x76, 0x07, 0xC0, 0xE0, 0x37, 0x60, 0x2C, 0x84, 0xD5, 0x11, 0x5D,
  0xC0, 0x27, 0x60, 0x7C, 0x0E, 0x03, 0x75, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x70,
  0x7C, 0x0E, 0x03, 0x74, 0x0D, 0xB0, 0x56, 0x05, 0xB0, 0xD7, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x30,
  0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x72, 0x0E, 0xB0, 0x16, 0x01, 0xB0,
  0xE7, 0x73, 0x07, 0xC0, 0xE0, 0x37, 0x10, 0xDB, 0x05, 0x60, 0x5B, 0x0C, 0x77, 0x40, 0x7C, 0x0E,
  0x03, 0x70, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08, 0x77, 0x50, 0x7C, 0x0E, 0x03, 0x60, 0x2C,
  0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x27, 0x76, 0x07, 0xC0, 0xE0, 0x36, 0x09, 0xFE, 0x05, 0x77, 0x70,
  0x7C, 0x0E, 0x03, 0x60, 0xBF, 0xE0, 0x57, 0x77, 0x07, 0xC0, 0xE0, 0x36, 0x09, 0xFE, 0x05, 0x77,
  0x70, 0x7C, 0x0E, 0x03, 0x68, 0x72, 0x8D, 0xEE, 0xC8, 0x25, 0xD0, 0x57, 0x77, 0x07, 0xC0, 0xE0,
  0x37, 0x70, 0x5D, 0x05, 0x77, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x05, 0xC0, 0xA7, 0x77, 0x10, 0x7C,
  0x0E, 0x03, 0x77, 0x05, 0xA0, 0xA7, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x10, 0x50, 0xA7, 0x77, 0x50,
  0x7A, 0x07, 0x80, 0xD1, 0x00, 0x07, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_find() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_find_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_lock 48x48, 4-bit Alpha,  RLE, 246 bytes.
static const unsigned char ic_outlined_48_device_wifi_lock_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0xFF, 0xFC, 0x0A, 0x02, 0x74, 0x07, 0x0E, 0xFF,
  0xFF, 0xE0, 0xE0, 0x77, 0x10, 0x10, 0xC8, 0x0C, 0x2F, 0x0C, 0x01, 0x50, 0x40, 0xE8, 0x0C, 0x4F,
  0x0E, 0x04, 0x30, 0x68, 0x0D, 0x0F, 0x81, 0x60, 0x78, 0x0D, 0x2F, 0x00, 0x78, 0x0D, 0x2F, 0x81,
  0x70, 0x78, 0x0D, 0x0F, 0x07, 0x30, 0x78, 0x0C, 0x6F, 0x07, 0x50, 0x78, 0x0C, 0x4F, 0x07, 0x70,
  0x7F, 0xFF, 0xF9, 0x81, 0xD7, 0x27, 0x72, 0x07, 0xFF, 0xFE, 0x07, 0x77, 0x60, 0x7F, 0xFF, 0xC0,
  0x57, 0x77, 0x10, 0x7F, 0xFF, 0xA0, 0x87, 0x77, 0x30, 0x7F, 0xFF, 0x0E, 0x68, 0x41, 0xAD, 0xDA,
  0x17, 0x70, 0x7F, 0xFE, 0x08, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x07, 0xFF, 0xD0, 0x45, 0x86,
  0xAF, 0xB1, 0x1B, 0xFA, 0x77, 0x10, 0x7F, 0xFC, 0x02, 0x58, 0x1D, 0xF1, 0x28, 0x11, 0xFD, 0x77,
  0x20, 0x7F, 0xFB, 0x01, 0x5A, 0x4A, 0x77, 0x30, 0x7F, 0xFA, 0x01, 0x5A, 0x4A, 0x77, 0x40, 0x7F,
  0xF9, 0x01, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x73, 0x07, 0xFF, 0x01, 0x30, 0xDF, 0xB0, 0xD7,
  0x74, 0x07, 0xFE, 0x01, 0x3F, 0xD7, 0x75, 0x07, 0xFD, 0x01, 0x3F, 0xD7, 0x76, 0x07, 0xFB, 0x07,
  0x4F, 0xD7, 0x77, 0x07, 0xF9, 0x07, 0x5F, 0xD7, 0x77, 0x10, 0x7E, 0x07, 0x6F, 0xD7, 0x77, 0x20,
  0x7C, 0x07, 0x7F, 0xD7, 0x77, 0x30, 0x7A, 0x07, 0x71, 0x0D, 0xFB, 0x0D, 0x77, 0x74, 0x00, 0x77,
  0x20, 0x40, 0xDF, 0x90, 0xD0, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_password 48x48, 4-bit Alpha,  RLE, 337 bytes.
static const unsigned char ic_outlined_48_device_wifi_password_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDD, 0xA8, 0x5D, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x15, 0x9D,
  0xFF, 0xA8, 0x1D, 0x95, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xFF, 0x98, 0x1E, 0x93, 0x77, 0x40, 0x30,
  0xAF, 0xFF, 0xF0, 0xA0, 0x37, 0x70, 0x20, 0xAF, 0xFF, 0xFC, 0x0A, 0x02, 0x74, 0x07, 0x0E, 0xFF,
  0xFF, 0xE0, 0xE0, 0x77, 0x10, 0x10, 0xCF, 0xD8, 0x4C, 0x86, 0x31, 0x12, 0x84, 0x11, 0x36, 0x8C,
  0xFD, 0x0C, 0x01, 0x50, 0x40, 0xEF, 0xB0, 0xA0, 0x57, 0x72, 0x05, 0x0A, 0xFB, 0x0E, 0x04, 0x30,
  0x6F, 0xA8, 0x1E, 0x71, 0x77, 0x68, 0x11, 0x7E, 0xFA, 0x81, 0x60, 0x7F, 0xA0, 0x77, 0x77, 0x50,
  0x7F, 0xA0, 0x07, 0xF0, 0xB0, 0x27, 0x77, 0x70, 0x20, 0xBF, 0x81, 0x70, 0x7D, 0x07, 0x77, 0x77,
  0x40, 0x7D, 0x07, 0x30, 0x7A, 0x0E, 0x03, 0x74, 0x83, 0x48, 0xAD, 0xDA, 0x83, 0xDD, 0xA8, 0x47,
  0x40, 0x30, 0xEA, 0x07, 0x58, 0x17, 0xD2, 0x72, 0x81, 0x4A, 0xEF, 0xD8, 0x1E, 0xA4, 0x72, 0x81,
  0x2D, 0x77, 0x72, 0x04, 0x0C, 0xFF, 0xC0, 0xC0, 0x47, 0x77, 0x30, 0x20, 0xBF, 0xFF, 0x90, 0xB0,
  0x17, 0x77, 0x05, 0x0E, 0xFF, 0xFB, 0x0E, 0x04, 0x77, 0x50, 0x7F, 0xFF, 0xF0, 0x77, 0x73, 0x04,
  0xFB, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0xB0, 0x47, 0x73, 0x07, 0xE0, 0xE0, 0x67, 0x50,
  0x60, 0xEE, 0x07, 0x77, 0x50, 0x7C, 0x07, 0x77, 0x20, 0x7C, 0x07, 0x77, 0x78, 0x27, 0xFE, 0x37,
  0x74, 0x82, 0x3E, 0xF7, 0x77, 0x72, 0x06, 0x01, 0x77, 0x60, 0x20, 0x68, 0x09, 0x94, 0x08, 0x65,
  0x9D, 0xEE, 0xD9, 0x57, 0x48, 0x41, 0xAD, 0xDA, 0x17, 0x77, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x71,
  0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x75, 0x08, 0xFD, 0x08, 0x78, 0x6A, 0xFB, 0x11, 0xBF, 0xA7, 0x75,
  0x07, 0xFD, 0x07, 0x78, 0x1D, 0xF1, 0x28, 0x11, 0xFD, 0x77, 0x60, 0x7F, 0xB0, 0x77, 0x1A, 0x4A,
  0x77, 0x70, 0x7F, 0x90, 0x77, 0x2A, 0x4A, 0x77, 0x71, 0x07, 0xE0, 0x77, 0x10, 0x40, 0xDF, 0x90,
  0xD0, 0x47, 0x77, 0x07, 0xC0, 0x77, 0x20, 0xDF, 0xB0, 0xD7, 0x77, 0x10, 0x7A, 0x07, 0x73, 0xFD,
  0x77, 0x72, 0x00, 0x77, 0x4F, 0xD8, 0x0C, 0x00, 0xFD, 0x80, 0xC0, 0x0F, 0xD8, 0x0C, 0x00, 0xFD,
  0x80, 0xC0, 0x0F, 0xD8, 0x0C, 0x00, 0x0D, 0xFB, 0x0D, 0x80, 0xC0, 0x00, 0x40, 0xDF, 0x90, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_password() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 47), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_password_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_tethering_error 48x48, 4-bit Alpha,  RLE, 336 bytes.
static const unsigned char ic_outlined_48_device_wifi_tethering_error_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDD, 0xA6, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x80, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x47, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x83, 0x13, 0x6A, 0xEE, 0x09, 0x76, 0x0A, 0xD0, 0xD0, 0x67, 0x50,
  0x60, 0xDD, 0x0A, 0x74, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x20, 0x9C, 0x0D, 0x03, 0x77,
  0x40, 0x20, 0xDC, 0x08, 0x70, 0x5C, 0x0C, 0x01, 0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x50,
  0x10, 0xCC, 0x04, 0x50, 0x10, 0xEB, 0x0D, 0x01, 0x40, 0x10, 0x9F, 0xB0, 0x90, 0x14, 0x01, 0x0D,
  0xB0, 0xE0, 0x14, 0x09, 0xC0, 0x34, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x76, 0x01, 0xC0, 0x74, 0x06,
  0xFF, 0xA0, 0x67, 0x50, 0x8B, 0x0D, 0x40, 0x4D, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x04, 0x74,
  0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C, 0x0E, 0x01, 0x72, 0x03, 0xC4, 0x09, 0xC0,
  0x47, 0x30, 0x4C, 0x09, 0x5C, 0x07, 0xB0, 0xB3, 0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x4C, 0x0A,
  0xB0, 0x63, 0x06, 0xB0, 0xC4, 0x84, 0x1A, 0xDD, 0xA1, 0x40, 0xCB, 0x06, 0x4C, 0x0C, 0xB0, 0x33,
  0x0B, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x06, 0xB0, 0xB4, 0xC0, 0xEB, 0x02, 0x30, 0xDB,
  0x02, 0x30, 0xAE, 0x0A, 0x30, 0x2B, 0x0D, 0x4F, 0x94, 0x0E, 0xB4, 0x0D, 0xE0, 0xD4, 0xB0, 0xE4,
  0xF9, 0x40, 0xEB, 0x40, 0xEE, 0x0E, 0x4B, 0x0E, 0x4C, 0x0E, 0xB0, 0x23, 0x0D, 0xB0, 0x23, 0x0A,
  0xE0, 0xA3, 0x02, 0xB0, 0xD4, 0xC0, 0xCB, 0x03, 0x30, 0xBB, 0x06, 0x30, 0x20, 0xEC, 0x0E, 0x02,
  0x30, 0x6B, 0x0B, 0x4C, 0x0A, 0xB0, 0x63, 0x06, 0xB0, 0xC4, 0x84, 0x2A, 0xEE, 0xA2, 0x40, 0xCB,
  0x06, 0x4C, 0x07, 0xB0, 0xB3, 0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x4C, 0x03, 0xC4, 0x09, 0xC0,
  0x27, 0x30, 0x2C, 0x09, 0x5C, 0x10, 0xDB, 0x06, 0x30, 0x10, 0xEA, 0x07, 0x75, 0x07, 0xA0, 0xE0,
  0x17, 0x30, 0x8B, 0x0E, 0x48, 0x14, 0xF7, 0x77, 0x81, 0x7F, 0x47, 0x40, 0x1C, 0x07, 0x40, 0x37,
  0x72, 0x03, 0x76, 0x09, 0xC0, 0x37, 0x77, 0x76, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x6C, 0x30,
  0x5C, 0x06, 0x77, 0x76, 0xC4, 0x09, 0xA0, 0x77, 0x77, 0x7C, 0x50, 0xA0, 0x77, 0x77, 0x71, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_tethering_error() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_tethering_error_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_tethering_error_rounded 48x48, 4-bit Alpha,  RLE, 336 bytes.
static const unsigned char ic_outlined_48_device_wifi_tethering_error_rounded_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDD, 0xA6, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x80, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x47, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x83, 0x13, 0x6A, 0xEE, 0x09, 0x76, 0x0A, 0xD0, 0xD0, 0x67, 0x50,
  0x60, 0xDD, 0x0A, 0x74, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x20, 0x9C, 0x0D, 0x03, 0x77,
  0x40, 0x20, 0xDC, 0x08, 0x70, 0x5C, 0x0C, 0x01, 0x58, 0x90, 0x16, 0xAD, 0xEE, 0xDA, 0x61, 0x50,
  0x10, 0xCC, 0x04, 0x50, 0x10, 0xEB, 0x0D, 0x01, 0x40, 0x10, 0x9F, 0xB0, 0x90, 0x14, 0x01, 0x0D,
  0xB0, 0xE0, 0x14, 0x09, 0xC0, 0x34, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x76, 0x01, 0xC0, 0x74, 0x06,
  0xFF, 0xA0, 0x67, 0x50, 0x8B, 0x0D, 0x40, 0x4D, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x04, 0x74,
  0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C, 0x0E, 0x01, 0x72, 0x03, 0xC4, 0x09, 0xC0,
  0x47, 0x30, 0x4C, 0x09, 0x5C, 0x07, 0xB0, 0xB3, 0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x4C, 0x0A,
  0xB0, 0x63, 0x06, 0xB0, 0xC4, 0x84, 0x1A, 0xDD, 0xA1, 0x40, 0xCB, 0x06, 0x4C, 0x0C, 0xB0, 0x33,
  0x0B, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x06, 0xB0, 0xB4, 0xC0, 0xEB, 0x02, 0x30, 0xDB,
  0x02, 0x30, 0xAE, 0x0A, 0x30, 0x2B, 0x0D, 0x4F, 0x94, 0x0E, 0xB4, 0x0D, 0xE0, 0xD4, 0xB0, 0xE4,
  0xF9, 0x40, 0xEB, 0x40, 0xEE, 0x0E, 0x4B, 0x0E, 0x4C, 0x0E, 0xB0, 0x23, 0x0D, 0xB0, 0x23, 0x0A,
  0xE0, 0xA3, 0x02, 0xB0, 0xD4, 0xC0, 0xCB, 0x03, 0x30, 0xBB, 0x06, 0x30, 0x20, 0xEC, 0x0E, 0x02,
  0x30, 0x6B, 0x0B, 0x4C, 0x0A, 0xB0, 0x63, 0x06, 0xB0, 0xC4, 0x84, 0x2A, 0xEE, 0xA2, 0x40, 0xCB,
  0x06, 0x4C, 0x07, 0xB0, 0xB3, 0x01, 0xC0, 0x67, 0x50, 0x6C, 0x01, 0x4C, 0x03, 0xC4, 0x09, 0xC0,
  0x27, 0x30, 0x2C, 0x09, 0x5C, 0x10, 0xDB, 0x06, 0x30, 0x10, 0xEA, 0x07, 0x75, 0x07, 0xA0, 0xE0,
  0x17, 0x30, 0x8B, 0x0E, 0x48, 0x14, 0xF7, 0x77, 0x81, 0x7F, 0x47, 0x40, 0x1C, 0x07, 0x40, 0x37,
  0x72, 0x03, 0x76, 0x09, 0xC0, 0x37, 0x77, 0x76, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x6C, 0x30,
  0x5C, 0x06, 0x77, 0x76, 0xC4, 0x09, 0xA0, 0x77, 0x77, 0x7C, 0x50, 0xA0, 0x77, 0x77, 0x71, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_tethering_error_rounded() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_tethering_error_rounded_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_tethering_off 48x48, 4-bit Alpha,  RLE, 442 bytes.
static const unsigned char ic_outlined_48_device_wifi_tethering_off_data[] PROGMEM = {
  0x20, 0x28, 0x0C, 0x30, 0x81, 0x4F, 0x77, 0x48, 0x33, 0x7A, 0xDD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
  0x04, 0xB0, 0x77, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x74, 0x0E, 0xC0, 0x75, 0x06, 0xFF, 0xC0,
  0x90, 0x17, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFC, 0x0E, 0x05, 0x72, 0x03, 0x0E, 0xC0, 0x75,
  0x85, 0xCF, 0xEA, 0x63, 0x12, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x20, 0x30, 0xEC, 0x07, 0x50, 0x57,
  0x50, 0x60, 0xDD, 0x0A, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x75, 0x07, 0xD0, 0xA7, 0x20, 0x30, 0xEC,
  0x07, 0x77, 0x50, 0x30, 0xDC, 0x09, 0x71, 0x04, 0xE0, 0x75, 0x87, 0x4A, 0xDF, 0xED, 0xA6, 0x15,
  0x01, 0x0C, 0xC0, 0x57, 0x0D, 0xF0, 0x75, 0x0C, 0xF0, 0x90, 0x14, 0x01, 0x0D, 0xB0, 0xE0, 0x15,
  0x08, 0xC0, 0xEC, 0x07, 0x50, 0xCF, 0x0E, 0x04, 0x40, 0x3C, 0x09, 0x40, 0x10, 0xEB, 0x81, 0x83,
  0xEC, 0x07, 0x50, 0xCF, 0x90, 0x64, 0x07, 0xC0, 0x13, 0x07, 0xB0, 0xD2, 0x03, 0x0E, 0xC0, 0x76,
  0x81, 0x26, 0xCD, 0x04, 0x40, 0xDB, 0x08, 0x30, 0xDB, 0x06, 0x30, 0x5D, 0x07, 0x71, 0x06, 0xC0,
  0xE0, 0x13, 0x06, 0xB0, 0xD2, 0x02, 0xB0, 0xE0, 0x13, 0x09, 0xE0, 0x77, 0x10, 0x4C, 0x09, 0x4C,
  0x81, 0x30, 0x6B, 0x0A, 0x30, 0x1F, 0x90, 0x77, 0x10, 0x6C, 0x01, 0x30, 0xBB, 0x81, 0x70, 0xAB,
  0x06, 0x30, 0x7B, 0x0D, 0x0E, 0xC0, 0x77, 0x10, 0xCB, 0x06, 0x30, 0x6B, 0x81, 0xA0, 0xCB, 0x03,
  0x30, 0xAB, 0x81, 0x73, 0xEC, 0x07, 0x70, 0x6B, 0x0B, 0x30, 0x3B, 0x81, 0xC0, 0xDB, 0x01, 0x30,
  0xDB, 0x82, 0x20, 0x3E, 0xC0, 0x76, 0x02, 0xB0, 0xD3, 0x02, 0xB8, 0x1E, 0x0E, 0xB4, 0x0E, 0xB3,
  0x03, 0xD0, 0x76, 0xB0, 0xE4, 0xC1, 0xC4, 0x0E, 0xB4, 0x0E, 0xD0, 0x75, 0x0C, 0xA0, 0xE4, 0xB8,
  0x1E, 0x0E, 0xB0, 0x23, 0x0D, 0xB0, 0x23, 0x0A, 0xE0, 0x75, 0x81, 0xCF, 0xD3, 0x01, 0xB8, 0x1D,
  0x0C, 0xB0, 0x33, 0x0B, 0xB0, 0x63, 0x02, 0x0E, 0xE0, 0x75, 0x0C, 0x0A, 0x30, 0x3B, 0x81, 0xC0,
  0xAB, 0x06, 0x30, 0x6B, 0x0C, 0x48, 0x12, 0xAE, 0xD0, 0x75, 0x04, 0x30, 0x6B, 0x81, 0xA0, 0x7B,
  0x0B, 0x30, 0x1C, 0x06, 0x60, 0x30, 0xEC, 0x07, 0x71, 0x0A, 0xB8, 0x17, 0x03, 0xC4, 0x09, 0xC0,
  0x26, 0x03, 0x0E, 0xC0, 0x77, 0x0E, 0xB0, 0x32, 0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xA0, 0x77, 0x10,
  0x30, 0xEC, 0x07, 0x50, 0x6B, 0x0D, 0x30, 0x8B, 0x0E, 0x48, 0x14, 0xF7, 0x73, 0x03, 0x0E, 0xC0,
  0x75, 0x0C, 0xA0, 0x83, 0x01, 0xC0, 0x74, 0x03, 0x75, 0x03, 0x0E, 0xC0, 0x75, 0x81, 0xCE, 0x14,
  0x09, 0xC0, 0x37, 0x73, 0x03, 0x0E, 0xC0, 0x75, 0x06, 0x50, 0x10, 0xEB, 0x0E, 0x01, 0x77, 0x30,
  0x30, 0xEC, 0x07, 0x74, 0x05, 0xC0, 0x67, 0x74, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0x9A, 0x07, 0x77,
  0x60, 0x30, 0xEC, 0x07, 0x74, 0x0A, 0x07, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03,
  0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x77, 0x03, 0x0E, 0xC0, 0x27, 0x77,
  0x77, 0x03, 0x0E, 0xA0, 0x48, 0x0C, 0x10, 0x81, 0x3E, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_tethering_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 43, 44), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_tethering_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_device_wifi_tethering 48x48, 4-bit Alpha,  RLE, 437 bytes.
static const unsigned char ic_outlined_48_device_wifi_tethering_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0D, 0x06, 0x75, 0x06,
  0x0D, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x37, 0x74,
  0x03, 0x0D, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x15, 0x89, 0x01, 0x6A, 0xDE, 0xED, 0xA6, 0x15, 0x01,
  0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0, 0xD0, 0x14, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x40, 0x10, 0xDB,
  0x0E, 0x01, 0x40, 0x9C, 0x03, 0x40, 0x40, 0xEF, 0xD0, 0xE0, 0x44, 0x03, 0xC0, 0x93, 0x01, 0xC0,
  0x74, 0x06, 0xFF, 0xA0, 0x64, 0x07, 0xC0, 0x12, 0x08, 0xB0, 0xD4, 0x04, 0xD8, 0x1C, 0x62, 0x28,
  0x12, 0x6C, 0xD0, 0x44, 0x0D, 0xB0, 0x82, 0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C,
  0x0E, 0x01, 0x30, 0x6B, 0x81, 0xD0, 0x3C, 0x40, 0x9C, 0x04, 0x73, 0x04, 0xC0, 0x94, 0xC0, 0x30,
  0x7B, 0x0B, 0x30, 0x1C, 0x06, 0x75, 0x06, 0xC0, 0x13, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x30, 0x6B,
  0x0C, 0x48, 0x41, 0xAD, 0xDA, 0x14, 0x0C, 0xB0, 0x63, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x30, 0xBB,
  0x06, 0x30, 0x10, 0xEC, 0x0E, 0x01, 0x30, 0x6B, 0x0B, 0x30, 0x3B, 0x0C, 0x0E, 0xB0, 0x23, 0x0D,
  0xB0, 0x23, 0x0A, 0xE0, 0xA3, 0x02, 0xB0, 0xD3, 0x02, 0xB0, 0xEC, 0x40, 0xEB, 0x40, 0xDE, 0x0D,
  0x4B, 0x0E, 0x4C, 0x0E, 0xB4, 0x0E, 0xB0, 0x13, 0x0D, 0xE0, 0xD3, 0x01, 0xB0, 0xE4, 0xB0, 0xE0,
  0xDB, 0x01, 0x30, 0xDB, 0x03, 0x30, 0xAE, 0x0A, 0x30, 0x3B, 0x0D, 0x30, 0x1B, 0x0D, 0x0C, 0xB0,
  0x33, 0x0B, 0xB0, 0x73, 0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x07, 0xB0, 0xB3, 0x03, 0xB0, 0xC0, 0xAB,
  0x06, 0x30, 0x7B, 0x0D, 0x48, 0x41, 0xAD, 0xDA, 0x14, 0x0D, 0xB0, 0x73, 0x06, 0xB0, 0xA0, 0x7B,
  0x0A, 0x30, 0x1C, 0x07, 0x75, 0x07, 0xC0, 0x13, 0x0A, 0xB0, 0x70, 0x3B, 0x0E, 0x40, 0x9C, 0x04,
  0x73, 0x04, 0xC0, 0x94, 0x0E, 0xB8, 0x13, 0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0x77, 0x10, 0x7C,
  0x0E, 0x01, 0x30, 0x6B, 0x0D, 0x20, 0x8B, 0x0D, 0x40, 0x5C, 0x0A, 0x71, 0x0A, 0xC0, 0x54, 0x0D,
  0xB0, 0x82, 0x01, 0x0E, 0xB0, 0x74, 0x06, 0xA0, 0xE0, 0x17, 0x10, 0x10, 0xEA, 0x06, 0x40, 0x7B,
  0x0E, 0x01, 0x30, 0x8C, 0x02, 0x48, 0x15, 0xE7, 0x73, 0x81, 0x7E, 0x54, 0x02, 0xC0, 0x84, 0x01,
  0x0E, 0xB0, 0xD0, 0x14, 0x01, 0x75, 0x01, 0x40, 0x10, 0xDB, 0x0E, 0x01, 0x50, 0x4C, 0x0C, 0x01,
  0x77, 0x60, 0x10, 0xCC, 0x04, 0x70, 0x8C, 0x0D, 0x02, 0x77, 0x40, 0x30, 0xDC, 0x08, 0x72, 0x0A,
  0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAC, 0x09, 0x77, 0x20, 0x9C, 0x0A, 0x76, 0x08, 0xA0,
  0xE0, 0x17, 0x72, 0x01, 0x0E, 0xA0, 0x87, 0x71, 0x81, 0x4E, 0x67, 0x74, 0x81, 0x7D, 0x47, 0x73,
  0x01, 0x77, 0x60, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_device_wifi_tethering() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_device_wifi_tethering_data, Alpha4(color::Black));
  return value;
}
