#include "communication.h"

using namespace roo_display;

// Image file ic_outlined_48_communication_3p 48x48, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_outlined_48_communication_3p_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x76, 0x84, 0x1A, 0xDD, 0xA1, 0x76, 0xF9, 0x75, 0x01, 0x0E, 0xC0,
  0xE0, 0x17, 0x5F, 0x97, 0x50, 0xAE, 0x0A, 0x75, 0xF9, 0x75, 0x0D, 0xE0, 0xD7, 0x5F, 0x97, 0x50,
  0xDE, 0x0D, 0x75, 0xF9, 0x75, 0x0A, 0xE0, 0xA7, 0x5F, 0x97, 0x50, 0x10, 0xEC, 0x0E, 0x01, 0x75,
  0xF9, 0x76, 0x84, 0x1A, 0xDD, 0xA1, 0x76, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x74,
  0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x27, 0x4F, 0x97, 0x20, 0x30, 0xCF, 0xB0, 0xC0, 0x37, 0x2F,
  0x97, 0x10, 0x3F, 0xF0, 0x37, 0x1F, 0x97, 0x10, 0xBF, 0xF0, 0xB7, 0x1F, 0x97, 0x10, 0xEF, 0xF0,
  0xE7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x10, 0x30, 0xEF, 0xFF, 0xFC, 0x0D, 0xC0, 0x30, 0xEF, 0xFF, 0xFD,
  0x0A, 0xC0, 0xEF, 0xFF, 0xFD, 0x0E, 0x01, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77,
  0x4E, 0x07, 0x77, 0x77, 0x5D, 0x07, 0x77, 0x77, 0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0,
  0x0A, 0x07, 0x80, 0xC1, 0x09, 0x07, 0x80, 0xC2, 0x00, 0x78, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_3p() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_3p_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_add_ic_call 48x48, 4-bit Alpha,  RLE, 255 bytes.
static const unsigned char ic_outlined_48_communication_add_ic_call_data[] PROGMEM = {
  0x28, 0x03, 0x17, 0x73, 0x80, 0x01, 0x60, 0x5F, 0xA0, 0x57, 0x71, 0xC6, 0x0E, 0xFA, 0x0E, 0x77,
  0x1C, 0x6F, 0xC7, 0x71, 0xC6, 0x0E, 0xB0, 0xFD, 0xC0, 0x17, 0x7C, 0x60, 0xDB, 0x02, 0x20, 0xDB,
  0x03, 0x77, 0xC6, 0x0C, 0xB0, 0x42, 0x0B, 0xB0, 0x47, 0x18, 0x02, 0x1C, 0x80, 0x21, 0x0A, 0xB0,
  0x62, 0x09, 0xB0, 0x87, 0x1F, 0xFA, 0x07, 0xB0, 0x82, 0x06, 0xB0, 0xB7, 0x1F, 0xFA, 0x05, 0xB0,
  0xB2, 0x02, 0xC7, 0x1F, 0xFA, 0x01, 0xC2, 0x07, 0xC0, 0x27, 0x80, 0x2D, 0xC8, 0x02, 0xD1, 0x0D,
  0xB0, 0x40, 0x7C, 0x0E, 0x77, 0xC7, 0x09, 0xB0, 0xDC, 0x0E, 0x03, 0x77, 0xC7, 0x04, 0xF0, 0xE0,
  0x37, 0x71, 0xC7, 0x10, 0xED, 0x0E, 0x03, 0x77, 0x2C, 0x71, 0x08, 0xC0, 0xE0, 0x37, 0x73, 0xC7,
  0x10, 0x2C, 0x06, 0x77, 0x48, 0x00, 0xD7, 0x20, 0xAB, 0x0C, 0x77, 0x77, 0x30, 0x3C, 0x06, 0x77,
  0x77, 0x30, 0xAB, 0x0E, 0x01, 0x77, 0x77, 0x20, 0x10, 0xEB, 0x0B, 0x77, 0x77, 0x30, 0x6C, 0x07,
  0x77, 0x77, 0x30, 0xBC, 0x05, 0x77, 0x77, 0x20, 0x10, 0xEC, 0x04, 0x77, 0x77, 0x20, 0x4C, 0x0E,
  0x04, 0x74, 0x81, 0x24, 0x17, 0x72, 0x05, 0xD0, 0x57, 0x20, 0x6B, 0x84, 0xD9, 0x64, 0x31, 0x74,
  0x06, 0xD0, 0x87, 0x06, 0xFC, 0x05, 0x73, 0x06, 0xD0, 0xB0, 0x24, 0x06, 0xFD, 0x0E, 0x74, 0x05,
  0xD0, 0xE0, 0x62, 0x06, 0xFF, 0x75, 0x03, 0x0D, 0xD0, 0xD0, 0x8C, 0x85, 0xE3, 0x14, 0x79, 0xBC,
  0x76, 0x01, 0x0B, 0xFA, 0x0E, 0x03, 0x6C, 0x77, 0x10, 0x60, 0xEF, 0x81, 0xC5, 0x15, 0xC7, 0x72,
  0x01, 0x09, 0xFA, 0x83, 0xD9, 0x75, 0x3C, 0x77, 0x40, 0x20, 0x9F, 0xFA, 0x77, 0x68, 0x11, 0x7D,
  0xFE, 0x77, 0x72, 0x81, 0x38, 0xCF, 0xA0, 0xD7, 0x77, 0x68, 0x74, 0x68, 0xBB, 0xDD, 0xC3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_add_ic_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 5, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_add_ic_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_alternate_email 48x48, 4-bit Alpha,  RLE, 380 bytes.
static const unsigned char ic_outlined_48_communication_alternate_email_data[] PROGMEM = {
  0x77, 0x50, 0x01, 0x77, 0x77, 0x58, 0x24, 0x8C, 0xEC, 0x82, 0xEC, 0x84, 0x77, 0x74, 0x81, 0x29,
  0xEF, 0xD8, 0x1E, 0x92, 0x77, 0x60, 0x20, 0xAF, 0xFC, 0x0A, 0x02, 0x77, 0x30, 0x60, 0xEF, 0xA0,
  0x0E, 0xFA, 0x0E, 0x06, 0x77, 0x10, 0xAE, 0x82, 0xE9, 0x52, 0x48, 0x22, 0x59, 0xEE, 0x0A, 0x75,
  0x01, 0x0C, 0xD0, 0xD0, 0x57, 0x50, 0x50, 0xDD, 0x0C, 0x01, 0x73, 0x0B, 0xD0, 0x77, 0x72, 0x07,
  0xD0, 0xB7, 0x20, 0xAC, 0x0E, 0x03, 0x77, 0x40, 0x30, 0xEC, 0x0A, 0x70, 0x6C, 0x0C, 0x01, 0x77,
  0x60, 0x10, 0xCC, 0x06, 0x50, 0x10, 0xEB, 0x0E, 0x01, 0x77, 0x71, 0x01, 0x0E, 0xB0, 0xE0, 0x14,
  0x09, 0xC0, 0x37, 0x18, 0x16, 0xBE, 0xA8, 0x1E, 0xB6, 0x71, 0x03, 0xC0, 0x93, 0x02, 0xC0, 0x77,
  0x06, 0x0E, 0xF9, 0x0E, 0x06, 0x70, 0x7C, 0x02, 0x20, 0x8B, 0x0E, 0x70, 0x9F, 0xD0, 0x97, 0x0E,
  0xB0, 0x82, 0x0E, 0xB0, 0x66, 0x09, 0xE0, 0x0E, 0xE0, 0x96, 0x06, 0xB8, 0x1E, 0x03, 0xC6, 0x05,
  0xC8, 0x1E, 0x71, 0x28, 0x11, 0x7E, 0xC0, 0x56, 0xC0, 0x30, 0x7B, 0x0B, 0x60, 0xDB, 0x0D, 0x01,
  0x60, 0x10, 0xDB, 0x0D, 0x60, 0xBB, 0x07, 0x0A, 0xB0, 0x65, 0x05, 0xB0, 0xE0, 0x27, 0x10, 0x20,
  0xEB, 0x05, 0x50, 0x6B, 0x0A, 0x0D, 0xB0, 0x35, 0x0A, 0xB0, 0x87, 0x30, 0x8B, 0x0A, 0x50, 0x3B,
  0x0D, 0x0E, 0xB0, 0x25, 0x0D, 0xB0, 0x27, 0x30, 0x2B, 0x0D, 0x50, 0x2B, 0x0E, 0xC6, 0x0E, 0xB7,
  0x5B, 0x0E, 0x6F, 0x90, 0x15, 0x0E, 0xB7, 0x5C, 0x6C, 0x0E, 0xB0, 0x25, 0x0D, 0xB0, 0x37, 0x30,
  0x3C, 0x6C, 0x0C, 0xB0, 0x45, 0x09, 0xB0, 0x97, 0x30, 0x9C, 0x6C, 0x0A, 0xB0, 0x75, 0x04, 0xC0,
  0x37, 0x10, 0x3D, 0x02, 0x40, 0x2B, 0x0E, 0x06, 0xB0, 0xC6, 0x0C, 0xB0, 0xE0, 0x46, 0x04, 0x0E,
  0xD0, 0x94, 0x09, 0xB0, 0xB0, 0x2C, 0x01, 0x50, 0x4D, 0x84, 0xA5, 0x22, 0x5A, 0xF9, 0x82, 0x93,
  0x39, 0xC8, 0x16, 0x0D, 0xB0, 0x86, 0x07, 0xFF, 0xFC, 0x0D, 0x20, 0x7B, 0x0E, 0x01, 0x60, 0x6F,
  0xD0, 0x06, 0xFB, 0x03, 0x20, 0x10, 0xEB, 0x09, 0x70, 0x30, 0xCF, 0x90, 0xC0, 0x32, 0x05, 0x0E,
  0xE0, 0xD0, 0x34, 0x08, 0xC0, 0x57, 0x18, 0x63, 0x8B, 0xDD, 0xB8, 0x35, 0x85, 0x16, 0xBD, 0xDA,
  0x67, 0x0D, 0xC0, 0x37, 0x77, 0x76, 0x04, 0xC0, 0xE0, 0x37, 0x77, 0x76, 0x07, 0xD0, 0x67, 0x77,
  0x76, 0x09, 0xD0, 0xA0, 0x27, 0x77, 0x75, 0x09, 0xE0, 0x80, 0x27, 0x77, 0x74, 0x07, 0xF8, 0x3D,
  0x85, 0x32, 0x80, 0x61, 0x77, 0x40, 0x30, 0xDF, 0xFE, 0x77, 0x60, 0x70, 0xEF, 0xFC, 0x77, 0x71,
  0x06, 0x0C, 0xFF, 0xA7, 0x77, 0x38, 0x21, 0x58, 0xB8, 0x09, 0x0D, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_alternate_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_alternate_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_app_registration 48x48, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_outlined_48_communication_app_registration_data[] PROGMEM = {
  0xF9, 0x4F, 0x94, 0xF9, 0x2F, 0x94, 0xF9, 0x4F, 0x92, 0xF9, 0x4F, 0x94, 0xF9, 0x2F, 0x94, 0xF9,
  0x4F, 0x92, 0xF9, 0x4F, 0x94, 0xF9, 0x2F, 0x94, 0xF9, 0x4F, 0x92, 0xF9, 0x4F, 0x94, 0xF9, 0x2F,
  0x94, 0xF9, 0x4F, 0x98, 0x0A, 0x86, 0x0F, 0x94, 0xF9, 0x72, 0x81, 0xAD, 0x22, 0xF9, 0x4F, 0x97,
  0x10, 0xBA, 0x0E, 0x02, 0x1F, 0x94, 0xF9, 0x70, 0x6C, 0x0E, 0x02, 0xF9, 0x4F, 0x97, 0x10, 0x8C,
  0x0D, 0xF9, 0x4F, 0x08, 0x50, 0xB0, 0x92, 0x08, 0xB0, 0xAF, 0x94, 0xE0, 0x85, 0x0B, 0xA0, 0x92,
  0x81, 0x8F, 0xB1, 0xF9, 0x4D, 0x08, 0x50, 0xBC, 0x09, 0x20, 0x62, 0xF9, 0x4C, 0x08, 0x50, 0xBE,
  0x09, 0x77, 0x74, 0x0B, 0xF0, 0xA7, 0x77, 0x30, 0xBF, 0x0A, 0x77, 0x73, 0x0B, 0xF0, 0xA7, 0x77,
  0x30, 0xBF, 0x0A, 0x7F, 0x97, 0x20, 0xBF, 0x0A, 0x71, 0xF9, 0x71, 0x0B, 0xF0, 0xA7, 0x2F, 0x97,
  0x0B, 0xF0, 0xA7, 0x3F, 0x96, 0x0B, 0xF0, 0xA7, 0x4F, 0x96, 0xF0, 0xA7, 0x5F, 0x96, 0xE0, 0xA7,
  0x6F, 0x96, 0xD0, 0xA7, 0x7F, 0x96, 0xC0, 0xA7, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_app_registration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 41, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_app_registration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_business 48x48, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_outlined_48_communication_business_data[] PROGMEM = {
  0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x76, 0xC4, 0xC4, 0xC7, 0x76,
  0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xC7, 0x76, 0xC4, 0xC4, 0xC7, 0x76, 0x80, 0xAC, 0x0F, 0x4C,
  0x4C, 0x77, 0x2F, 0x94, 0xC4, 0xC7, 0x72, 0xF9, 0x4C, 0x4C, 0x77, 0x2F, 0x94, 0xC4, 0xC7, 0x72,
  0xFF, 0xFF, 0x4C, 0x4F, 0xFF, 0xF4, 0xC4, 0xFF, 0xFF, 0x4C, 0x4F, 0xFF, 0xF4, 0xC4, 0xF9, 0x4C,
  0x4C, 0x77, 0x2F, 0x94, 0xC4, 0xC7, 0x72, 0xF9, 0x4C, 0x4C, 0x77, 0x2F, 0x94, 0xC4, 0xC7, 0x72,
  0xFF, 0xFF, 0x4C, 0x4F, 0xFF, 0xF4, 0xC4, 0xFF, 0xFF, 0x4C, 0x4F, 0xFF, 0xF4, 0xC4, 0xF9, 0x4C,
  0x4C, 0x77, 0x2F, 0x94, 0xC4, 0xC7, 0x72, 0xF9, 0x4C, 0x4C, 0x77, 0x2F, 0x94, 0xC4, 0xC7, 0x72,
  0x80, 0xAC, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_call_end 48x48, 4-bit Alpha,  RLE, 209 bytes.
static const unsigned char ic_outlined_48_communication_call_end_data[] PROGMEM = {
  0x77, 0x28, 0x52, 0x58, 0xAC, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x14, 0x9D,
  0xFF, 0xA8, 0x1D, 0x94, 0x77, 0x72, 0x81, 0x29, 0xEF, 0xFF, 0x98, 0x1E, 0x92, 0x77, 0x40, 0x30,
  0xBF, 0xFF, 0xF0, 0xB0, 0x37, 0x70, 0x20, 0xAF, 0x98, 0x4E, 0xB8, 0x53, 0x14, 0x84, 0x13, 0x58,
  0xBE, 0xF9, 0x0A, 0x02, 0x74, 0x08, 0xF9, 0x0D, 0x03, 0x77, 0x20, 0x40, 0xDF, 0x90, 0x87, 0x10,
  0x20, 0xCF, 0xA0, 0xC7, 0x74, 0x0C, 0xFA, 0x0C, 0x02, 0x50, 0x50, 0xED, 0x0C, 0x06, 0xB0, 0xC7,
  0x74, 0x0C, 0xB0, 0x60, 0xCD, 0x0E, 0x05, 0x30, 0x7D, 0x82, 0xD5, 0x03, 0xB0, 0xC7, 0x74, 0x0C,
  0xB8, 0x23, 0x05, 0xDD, 0x81, 0x70, 0x7D, 0x0A, 0x01, 0x20, 0x3B, 0x0C, 0x77, 0x40, 0xCB, 0x03,
  0x20, 0x10, 0xAD, 0x07, 0x0E, 0xC0, 0x64, 0x06, 0xB0, 0xC7, 0x74, 0x0C, 0xB0, 0x64, 0x06, 0xC0,
  0xE0, 0xCC, 0x08, 0x20, 0x20, 0xBC, 0x0C, 0x77, 0x40, 0xCC, 0x0B, 0x02, 0x20, 0x8C, 0x81, 0xC2,
  0xEC, 0x81, 0x85, 0xED, 0x08, 0x77, 0x40, 0x9D, 0x81, 0xE5, 0x8C, 0x83, 0xE2, 0x02, 0xEF, 0xB0,
  0x87, 0x76, 0x08, 0xFB, 0x0E, 0x02, 0x30, 0x20, 0xEF, 0x0B, 0x02, 0x77, 0x71, 0x02, 0x0B, 0xF0,
  0xE0, 0x25, 0x02, 0x0E, 0xD0, 0x67, 0x77, 0x50, 0x6D, 0x0E, 0x02, 0x70, 0x20, 0xEA, 0x0E, 0x03,
  0x77, 0x77, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x28, 0x22, 0x98, 0x17, 0x77, 0x72, 0x82, 0x19, 0x92,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_call_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 14, 47, 31), Box(0, 0, 47, 47),
      ic_outlined_48_communication_call_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_call_made 48x48, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_outlined_48_communication_call_made_data[] PROGMEM = {
  0x73, 0xFF, 0xE7, 0x3F, 0xFE, 0x73, 0xFF, 0xE7, 0x3F, 0xFE, 0x77, 0x71, 0x05, 0xF7, 0x77, 0x05,
  0xF9, 0x77, 0x60, 0x5F, 0xA7, 0x75, 0x05, 0xD0, 0x5C, 0x77, 0x40, 0x5D, 0x05, 0x1C, 0x77, 0x30,
  0x5D, 0x05, 0x2C, 0x77, 0x20, 0x5D, 0x05, 0x3C, 0x77, 0x10, 0x5D, 0x05, 0x4C, 0x77, 0x05, 0xD0,
  0x55, 0xC7, 0x60, 0x5D, 0x05, 0x6C, 0x75, 0x05, 0xD0, 0x57, 0xC7, 0x40, 0x5D, 0x05, 0x71, 0xC7,
  0x30, 0x5D, 0x05, 0x72, 0xC7, 0x20, 0x5D, 0x05, 0x73, 0xC7, 0x10, 0x5D, 0x05, 0x74, 0xC7, 0x05,
  0xD0, 0x57, 0x5C, 0x60, 0x5D, 0x05, 0x77, 0x71, 0x05, 0xD0, 0x57, 0x77, 0x10, 0x5D, 0x05, 0x77,
  0x71, 0x05, 0xD0, 0x57, 0x77, 0x10, 0x5D, 0x05, 0x77, 0x71, 0x05, 0xD0, 0x57, 0x77, 0x10, 0x5D,
  0x05, 0x77, 0x72, 0x0A, 0xC0, 0x57, 0x77, 0x40, 0xAA, 0x05, 0x77, 0x76, 0x0A, 0x05, 0x77, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_call_made() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 10, 37, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_call_made_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_call_merge 48x48, 4-bit Alpha,  RLE, 140 bytes.
static const unsigned char ic_outlined_48_communication_call_merge_data[] PROGMEM = {
  0x75, 0x00, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x70, 0x7C, 0x07, 0x77, 0x50, 0x7E, 0x07, 0x77,
  0x30, 0x7F, 0x90, 0x77, 0x71, 0x07, 0xFB, 0x07, 0x76, 0x07, 0xFD, 0x07, 0x74, 0x07, 0xFF, 0x07,
  0x72, 0x07, 0xFF, 0xA0, 0x77, 0x71, 0xC7, 0x77, 0x1C, 0x77, 0x71, 0xC7, 0x77, 0x1C, 0x77, 0x71,
  0xC7, 0x77, 0x1C, 0x77, 0x71, 0xC7, 0x77, 0x1C, 0x77, 0x71, 0xC7, 0x77, 0x1C, 0x77, 0x71, 0xC7,
  0x77, 0x05, 0xC7, 0x76, 0x05, 0xD7, 0x75, 0x05, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x57, 0x74, 0x05,
  0xD0, 0x55, 0x00, 0x57, 0x40, 0x5D, 0x05, 0x50, 0x5A, 0x05, 0x72, 0x05, 0xD0, 0x55, 0x05, 0xC0,
  0x57, 0x05, 0xD0, 0x56, 0x05, 0xD0, 0x55, 0x05, 0xD0, 0x57, 0x10, 0x5D, 0x05, 0x30, 0x5D, 0x05,
  0x73, 0x05, 0xD8, 0x15, 0x05, 0xD0, 0x57, 0x50, 0x5D, 0x00, 0x5C, 0x05, 0x77, 0x05, 0xC8, 0x15,
  0x05, 0xA0, 0x57, 0x72, 0x05, 0xA0, 0x53, 0x00, 0x57, 0x74, 0x00, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_call_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(11, 7, 36, 40), Box(0, 0, 47, 47),
      ic_outlined_48_communication_call_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_call_missed_outgoing 48x48, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_outlined_48_communication_call_missed_outgoing_data[] PROGMEM = {
  0x20, 0xA0, 0x57, 0x72, 0xFF, 0xA1, 0x0A, 0xA0, 0x57, 0x71, 0xFF, 0xA0, 0xAC, 0x05, 0x77, 0xFF,
  0xA0, 0x5D, 0x05, 0x76, 0xFF, 0xA1, 0x05, 0xD0, 0x57, 0x76, 0x05, 0xF2, 0x05, 0xD0, 0x57, 0x74,
  0x05, 0xF9, 0x30, 0x5D, 0x05, 0x77, 0x20, 0x5F, 0xA4, 0x05, 0xD0, 0x57, 0x70, 0x5D, 0x05, 0xC5,
  0x05, 0xD0, 0x57, 0x50, 0x5D, 0x05, 0x1C, 0x60, 0x5D, 0x05, 0x73, 0x05, 0xD0, 0x52, 0xC7, 0x05,
  0xD0, 0x57, 0x10, 0x5D, 0x05, 0x3C, 0x71, 0x05, 0xD0, 0x56, 0x05, 0xD0, 0x54, 0xC7, 0x20, 0x5D,
  0x05, 0x40, 0x5D, 0x05, 0x5C, 0x73, 0x05, 0xD0, 0x52, 0x05, 0xD0, 0x56, 0xC7, 0x40, 0x5D, 0x00,
  0x5D, 0x05, 0x7C, 0x75, 0x05, 0xFB, 0x05, 0x71, 0xC7, 0x60, 0x5F, 0x90, 0x57, 0x77, 0x60, 0x5E,
  0x05, 0x77, 0x77, 0x10, 0x5C, 0x05, 0x77, 0x77, 0x30, 0x5A, 0x05, 0x77, 0x77, 0x50, 0x05, 0x77,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_call_missed_outgoing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 14, 41, 34), Box(0, 0, 47, 47),
      ic_outlined_48_communication_call_missed_outgoing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_call_missed 48x48, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_outlined_48_communication_call_missed_data[] PROGMEM = {
  0xFF, 0xA7, 0x72, 0x05, 0x0A, 0x2F, 0xFA, 0x77, 0x10, 0x5A, 0x0A, 0x1F, 0xFA, 0x77, 0x05, 0xC0,
  0xAF, 0xFA, 0x76, 0x05, 0xD0, 0x5F, 0x05, 0x77, 0x60, 0x5D, 0x05, 0x1F, 0x90, 0x57, 0x74, 0x05,
  0xD0, 0x52, 0xFA, 0x05, 0x77, 0x20, 0x5D, 0x05, 0x3C, 0x05, 0xD0, 0x57, 0x70, 0x5D, 0x05, 0x4C,
  0x10, 0x5D, 0x05, 0x75, 0x05, 0xD0, 0x55, 0xC2, 0x05, 0xD0, 0x57, 0x30, 0x5D, 0x05, 0x6C, 0x30,
  0x5D, 0x05, 0x71, 0x05, 0xD0, 0x57, 0xC4, 0x05, 0xD0, 0x56, 0x05, 0xD0, 0x57, 0x1C, 0x50, 0x5D,
  0x05, 0x40, 0x5D, 0x05, 0x72, 0xC6, 0x05, 0xD0, 0x52, 0x05, 0xD0, 0x57, 0x3C, 0x70, 0x5D, 0x00,
  0x5D, 0x05, 0x74, 0xC7, 0x10, 0x5F, 0xB0, 0x57, 0x77, 0x40, 0x5F, 0x90, 0x57, 0x77, 0x60, 0x5E,
  0x05, 0x77, 0x77, 0x10, 0x5C, 0x05, 0x77, 0x77, 0x30, 0x5A, 0x05, 0x77, 0x77, 0x50, 0x05, 0x77,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_call_missed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 14, 41, 34), Box(0, 0, 47, 47),
      ic_outlined_48_communication_call_missed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_call 48x48, 4-bit Alpha,  RLE, 232 bytes.
static const unsigned char ic_outlined_48_communication_call_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xD0, 0x47, 0x77, 0x40, 0xDF, 0xA0, 0xD7, 0x77, 0x4F, 0xC7, 0x77, 0x40, 0xEF,
  0xB0, 0x17, 0x77, 0x30, 0xDB, 0x01, 0x20, 0xDB, 0x03, 0x77, 0x73, 0x0C, 0xB0, 0x42, 0x0B, 0xB0,
  0x47, 0x77, 0x30, 0xAB, 0x06, 0x20, 0x9B, 0x07, 0x77, 0x73, 0x07, 0xB0, 0x82, 0x06, 0xB0, 0xB7,
  0x77, 0x30, 0x5B, 0x0B, 0x20, 0x2B, 0x0E, 0x77, 0x73, 0x02, 0xC2, 0x05, 0xC0, 0x27, 0x77, 0x30,
  0xDB, 0x04, 0x05, 0xD0, 0x17, 0x77, 0x30, 0x9B, 0x0C, 0xD0, 0x57, 0x77, 0x40, 0x5F, 0x90, 0x57,
  0x77, 0x60, 0xEE, 0x05, 0x77, 0x77, 0x09, 0xD0, 0x57, 0x77, 0x71, 0x03, 0xC0, 0x77, 0x77, 0x73,
  0x0B, 0xB0, 0xB7, 0x77, 0x73, 0x03, 0xC0, 0x57, 0x77, 0x73, 0x0B, 0xB0, 0xD0, 0x17, 0x77, 0x72,
  0x02, 0xC0, 0xA7, 0x77, 0x73, 0x07, 0xC0, 0x67, 0x77, 0x73, 0x0C, 0xC0, 0x37, 0x77, 0x72, 0x02,
  0x0E, 0xB0, 0xE0, 0x37, 0x77, 0x72, 0x05, 0xC0, 0xE0, 0x37, 0x40, 0x10, 0x27, 0x73, 0x06, 0xC0,
  0xE0, 0x37, 0x28, 0x75, 0xEF, 0xEB, 0x74, 0x21, 0x75, 0x08, 0xD0, 0x67, 0x05, 0xFB, 0x0D, 0x04,
  0x73, 0x08, 0xD0, 0xA0, 0x14, 0x05, 0xFD, 0x0D, 0x74, 0x06, 0xD0, 0xD0, 0x52, 0x05, 0xFF, 0x75,
  0x05, 0x0E, 0xD0, 0xB0, 0x7D, 0x84, 0x53, 0x69, 0xBD, 0xC7, 0x60, 0x20, 0xCF, 0xB0, 0x56, 0xC7,
  0x71, 0x07, 0xF9, 0x0C, 0x04, 0x6C, 0x77, 0x20, 0x20, 0xBF, 0xA8, 0x3B, 0x86, 0x42, 0xC7, 0x74,
  0x03, 0x0B, 0xFF, 0xA7, 0x76, 0x81, 0x39, 0xEF, 0xE7, 0x77, 0x28, 0x15, 0x9D, 0xFA, 0x0D, 0x77,
  0x75, 0x89, 0x02, 0x58, 0xAC, 0xDD, 0xFD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_call_received 48x48, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_outlined_48_communication_call_received_data[] PROGMEM = {
  0x77, 0x75, 0x05, 0x0A, 0x77, 0x76, 0x05, 0xA0, 0xA7, 0x77, 0x40, 0x5C, 0x0A, 0x77, 0x72, 0x05,
  0xD0, 0x57, 0x77, 0x10, 0x5D, 0x05, 0x77, 0x71, 0x05, 0xD0, 0x57, 0x77, 0x10, 0x5D, 0x05, 0x77,
  0x71, 0x05, 0xD0, 0x57, 0x77, 0x10, 0x5D, 0x05, 0x77, 0x71, 0x05, 0xD0, 0x56, 0xC7, 0x50, 0x5D,
  0x05, 0x7C, 0x74, 0x05, 0xD0, 0x57, 0x1C, 0x73, 0x05, 0xD0, 0x57, 0x2C, 0x72, 0x05, 0xD0, 0x57,
  0x3C, 0x71, 0x05, 0xD0, 0x57, 0x4C, 0x70, 0x5D, 0x05, 0x75, 0xC6, 0x05, 0xD0, 0x57, 0x6C, 0x50,
  0x5D, 0x05, 0x77, 0xC4, 0x05, 0xD0, 0x57, 0x71, 0xC3, 0x05, 0xD0, 0x57, 0x72, 0xC2, 0x05, 0xD0,
  0x57, 0x73, 0xC1, 0x05, 0xD0, 0x57, 0x74, 0xC0, 0x5D, 0x05, 0x77, 0x5F, 0xA0, 0x57, 0x76, 0xF9,
  0x05, 0x77, 0x7F, 0x05, 0x77, 0x71, 0xFF, 0xE7, 0x3F, 0xFE, 0x73, 0xFF, 0xE7, 0x3F, 0xFE, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_call_received() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 8, 39, 37), Box(0, 0, 47, 47),
      ic_outlined_48_communication_call_received_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_call_split 48x48, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_outlined_48_communication_call_split_data[] PROGMEM = {
  0xFC, 0x07, 0x71, 0x07, 0xFF, 0xF0, 0x77, 0x30, 0x7F, 0xFD, 0x07, 0x75, 0x07, 0xFF, 0xB0, 0x77,
  0x70, 0x7F, 0xF9, 0x0A, 0x77, 0x20, 0xAF, 0xF9, 0x05, 0x77, 0x05, 0xFF, 0xB0, 0x57, 0x50, 0x5F,
  0xE0, 0xAD, 0x05, 0x73, 0x05, 0xD0, 0xAF, 0x81, 0x70, 0x5D, 0x05, 0x71, 0x05, 0xD8, 0x15, 0x07,
  0xD0, 0x73, 0x05, 0xD0, 0x56, 0x05, 0xD0, 0x53, 0x07, 0xB0, 0x75, 0x05, 0xD0, 0x55, 0x0D, 0xC0,
  0x55, 0x81, 0x7F, 0x77, 0x05, 0xD0, 0x54, 0x02, 0x0D, 0xA0, 0x57, 0x07, 0x72, 0x05, 0xD0, 0x54,
  0x81, 0x2D, 0x57, 0x75, 0x05, 0xD0, 0x57, 0x77, 0x50, 0x5D, 0x05, 0x77, 0x75, 0x05, 0xD7, 0x77,
  0x60, 0x5C, 0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77,
  0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x77, 0x7C,
  0x77, 0x77, 0xC7, 0x77, 0x7C, 0x77, 0x77, 0xC7, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_call_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_call_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_cancel_presentation 48x48, 4-bit Alpha,  RLE, 220 bytes.
static const unsigned char ic_outlined_48_communication_cancel_presentation_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x75, 0x0B, 0x06, 0x71,
  0x06, 0x0B, 0x75, 0xF9, 0x74, 0x0B, 0xA0, 0x66, 0x06, 0xA0, 0xB7, 0x4F, 0x97, 0x30, 0xAC, 0x06,
  0x40, 0x6C, 0x0A, 0x73, 0xF9, 0x73, 0x03, 0x0E, 0xC0, 0x62, 0x06, 0xC0, 0xE0, 0x37, 0x3F, 0x97,
  0x40, 0x30, 0xEC, 0x00, 0x6C, 0x0E, 0x03, 0x74, 0xF9, 0x75, 0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x75,
  0xF9, 0x76, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x6F, 0x97, 0x70, 0x3E, 0x03, 0x77, 0xF9, 0x77, 0x06,
  0xE0, 0x67, 0x7F, 0x97, 0x60, 0x6F, 0x90, 0x67, 0x6F, 0x97, 0x50, 0x6C, 0x00, 0xEC, 0x06, 0x75,
  0xF9, 0x74, 0x06, 0xC8, 0x2E, 0x33, 0xEC, 0x06, 0x74, 0xF9, 0x73, 0x06, 0xC0, 0xE0, 0x32, 0x03,
  0x0E, 0xC0, 0x67, 0x3F, 0x97, 0x30, 0x8B, 0x0E, 0x03, 0x40, 0x30, 0xEB, 0x08, 0x73, 0xF9, 0x74,
  0x82, 0x8F, 0xE3, 0x68, 0x23, 0xEF, 0x87, 0x4F, 0x97, 0x50, 0x80, 0x37, 0x10, 0x30, 0x87, 0x5F,
  0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C,
  0x00, 0xF9, 0x80, 0xC0, 0x0C, 0x0D, 0x80, 0xC6, 0xF0, 0xD0, 0xA8, 0x0C, 0x6F, 0x81, 0xA1, 0xE8,
  0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_cancel_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_cancel_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_cell_tower 48x48, 4-bit Alpha,  RLE, 440 bytes.
static const unsigned char ic_outlined_48_communication_cell_tower_data[] PROGMEM = {
  0x50, 0xB0, 0x77, 0x77, 0x50, 0x70, 0xB7, 0x20, 0x8A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x97, 0x05,
  0xB0, 0xD7, 0x77, 0x30, 0xDB, 0x05, 0x60, 0xEA, 0x0E, 0x02, 0x77, 0x73, 0x02, 0x0E, 0xA0, 0xE5,
  0x07, 0xB0, 0x53, 0x02, 0x77, 0x40, 0x23, 0x05, 0xB0, 0x73, 0x01, 0x0E, 0xA0, 0xB3, 0x81, 0x2E,
  0x77, 0x72, 0x81, 0x7E, 0x23, 0x0B, 0xA0, 0xE0, 0x12, 0x08, 0xB0, 0x32, 0x01, 0x0D, 0xA0, 0x77,
  0x70, 0x7A, 0x0D, 0x30, 0x3B, 0x08, 0x20, 0xCA, 0x0B, 0x30, 0x8B, 0x08, 0x77, 0x09, 0xB0, 0x83,
  0x0B, 0xA8, 0x1C, 0x02, 0xB0, 0x52, 0x02, 0xB0, 0xB7, 0x72, 0x0B, 0xA0, 0xE0, 0x12, 0x05, 0xB0,
  0x20, 0x6B, 0x01, 0x20, 0x8B, 0x02, 0x58, 0x44, 0xBE, 0xEB, 0x45, 0x03, 0xB0, 0x72, 0x01, 0xB0,
  0x60, 0xAA, 0x0C, 0x30, 0xDA, 0x0A, 0x50, 0x8E, 0x08, 0x50, 0xBA, 0x0B, 0x30, 0xCA, 0x0A, 0x0B,
  0xA0, 0x92, 0x01, 0xB0, 0x54, 0x04, 0xF9, 0x04, 0x40, 0x6B, 0x30, 0x9A, 0x0B, 0x0D, 0xA0, 0x82,
  0x03, 0xB0, 0x24, 0x0B, 0xF9, 0x0B, 0x40, 0x2B, 0x03, 0x20, 0x8A, 0x0D, 0x0E, 0xA0, 0x62, 0x05,
  0xB5, 0x0E, 0xF9, 0x0E, 0x5B, 0x05, 0x20, 0x6A, 0x00, 0xEA, 0x06, 0x20, 0x5B, 0x50, 0xEF, 0x90,
  0xE5, 0xB0, 0x52, 0x06, 0xB0, 0xDA, 0x08, 0x20, 0x3B, 0x02, 0x40, 0xBF, 0x90, 0xB4, 0x02, 0xB0,
  0x32, 0x08, 0xA0, 0xE0, 0xBA, 0x09, 0x20, 0x1B, 0x06, 0x40, 0x4F, 0x90, 0x44, 0x05, 0xB0, 0x12,
  0x09, 0xA0, 0xD0, 0xAA, 0x0C, 0x30, 0xDA, 0x0B, 0x50, 0x8E, 0x08, 0x50, 0xAA, 0x0D, 0x30, 0xCA,
  0x0A, 0x06, 0xB0, 0x12, 0x08, 0xB0, 0x34, 0x07, 0xE0, 0x74, 0x02, 0xB0, 0x82, 0x01, 0xB0, 0x70,
  0x2B, 0x05, 0x20, 0x2B, 0x0B, 0x40, 0xDE, 0x0D, 0x40, 0xBB, 0x02, 0x20, 0x5B, 0x81, 0x40, 0xCA,
  0x0B, 0x30, 0x8B, 0x09, 0x20, 0x2B, 0x00, 0xCB, 0x02, 0x20, 0x8B, 0x08, 0x30, 0xBA, 0x0E, 0x20,
  0x8B, 0x03, 0x20, 0x10, 0xDA, 0x07, 0x20, 0x7B, 0x00, 0x7B, 0x07, 0x20, 0x7A, 0x0D, 0x01, 0x20,
  0x3B, 0x09, 0x20, 0x10, 0xEA, 0x0B, 0x38, 0x12, 0xE7, 0x30, 0xDB, 0x00, 0x2B, 0x0D, 0x38, 0x17,
  0xE2, 0x30, 0xBB, 0x02, 0x30, 0x7B, 0x05, 0x30, 0x23, 0x02, 0xB0, 0xC2, 0x0C, 0xB0, 0x23, 0x02,
  0x30, 0x5B, 0x0A, 0x50, 0xEA, 0x0E, 0x02, 0x60, 0x7B, 0x07, 0x20, 0x7B, 0x07, 0x60, 0x20, 0xEB,
  0x02, 0x50, 0x5B, 0x0D, 0x60, 0xCB, 0x02, 0x20, 0x2B, 0x0C, 0x60, 0xDB, 0x06, 0x70, 0x9A, 0x07,
  0x50, 0x2B, 0x0C, 0x40, 0xCB, 0x02, 0x50, 0x7A, 0x0A, 0x72, 0x0B, 0x07, 0x60, 0x7B, 0x07, 0x40,
  0x7B, 0x07, 0x60, 0x70, 0xC7, 0x74, 0x0C, 0xB0, 0x24, 0x02, 0xB0, 0xC7, 0x77, 0x40, 0x2B, 0x0C,
  0x60, 0xCB, 0x02, 0x77, 0x73, 0x07, 0xFF, 0x07, 0x77, 0x73, 0x0C, 0xFF, 0x0C, 0x77, 0x72, 0x02,
  0xFF, 0xA0, 0x27, 0x77, 0x10, 0x7F, 0xFA, 0x07, 0x77, 0x71, 0x0C, 0xB0, 0x27, 0x10, 0x2B, 0x0C,
  0x77, 0x70, 0x2B, 0x0C, 0x73, 0x0C, 0xB0, 0x27, 0x76, 0x07, 0xB0, 0x77, 0x30, 0x7B, 0x07, 0x77,
  0x60, 0xCB, 0x02, 0x73, 0x02, 0xB0, 0xC7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_cell_tower() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_cell_tower_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_cell_wifi 48x48, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_outlined_48_communication_cell_wifi_data[] PROGMEM = {
  0x71, 0x89, 0x23, 0x7A, 0xBD, 0xEE, 0xDB, 0xA6, 0x27, 0x77, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81,
  0x77, 0x20, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x76, 0x05, 0x0E, 0xF8, 0x4D, 0xCB, 0xAC, 0xDF, 0x0E,
  0x05, 0x74, 0x09, 0xD8, 0x2E, 0xA5, 0x16, 0x82, 0x15, 0xAE, 0xD0, 0x97, 0x20, 0xAD, 0x08, 0x01,
  0x75, 0x01, 0x08, 0xD0, 0xB7, 0x10, 0x7B, 0x0B, 0x01, 0x77, 0x20, 0x10, 0xBB, 0x08, 0x78, 0x38,
  0x07, 0xF8, 0x68, 0x62, 0x79, 0xAA, 0x97, 0x26, 0x81, 0x8F, 0x87, 0x08, 0x92, 0x03, 0x50, 0x60,
  0xDF, 0x90, 0xD0, 0x65, 0x03, 0x70, 0x8A, 0x60, 0x30, 0xDF, 0xD0, 0xD0, 0x37, 0x30, 0x8B, 0x50,
  0x6F, 0xFA, 0x06, 0x71, 0x08, 0xC5, 0x07, 0xC8, 0x1A, 0x41, 0x28, 0x11, 0x4A, 0xC0, 0x77, 0x08,
  0xD6, 0x82, 0x7F, 0xC2, 0x71, 0x82, 0x2C, 0xF7, 0x70, 0x8E, 0x70, 0x57, 0x50, 0x57, 0x08, 0xF7,
  0x58, 0x23, 0x66, 0x37, 0x40, 0x8F, 0x97, 0x30, 0x20, 0xCC, 0x0C, 0x02, 0x71, 0x08, 0xC0, 0xDC,
  0x73, 0x07, 0xE0, 0x77, 0x08, 0xC0, 0xD0, 0x2C, 0x74, 0x07, 0xC0, 0x77, 0x08, 0xC0, 0xD0, 0x21,
  0xC7, 0x50, 0x7A, 0x07, 0x70, 0x8C, 0x0D, 0x02, 0x2C, 0x76, 0x00, 0x77, 0x08, 0xD0, 0x23, 0xC7,
  0x77, 0x08, 0xE4, 0xC7, 0x76, 0x08, 0xF4, 0xC7, 0x75, 0x08, 0xF9, 0x4C, 0x77, 0x40, 0x8F, 0xA4,
  0xC7, 0x73, 0x08, 0xFB, 0x4C, 0x77, 0x20, 0x8F, 0xC4, 0xC7, 0x71, 0x08, 0xFD, 0x4C, 0x77, 0x08,
  0xFE, 0x4C, 0x76, 0x08, 0xFF, 0x4C, 0x75, 0x07, 0xFF, 0x94, 0xC7, 0x40, 0x7F, 0xFA, 0x4C, 0x73,
  0x07, 0xFF, 0xB4, 0xC7, 0x20, 0x7F, 0xFC, 0x4C, 0x71, 0x07, 0xFF, 0xD4, 0xC7, 0x07, 0xFF, 0xFF,
  0x60, 0x7F, 0xFF, 0xF9, 0x50, 0x7F, 0xFF, 0xFA, 0x40, 0x7F, 0xFF, 0xFB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_cell_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 6, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_cell_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_chat_bubble_outline 48x48, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_outlined_48_communication_chat_bubble_outline_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x30, 0x7F, 0xFF, 0xFB, 0x0D,
  0xC2, 0x07, 0xFF, 0xFF, 0xC0, 0xAC, 0x10, 0x7F, 0xFF, 0xFC, 0x0E, 0x01, 0xC0, 0x7F, 0xFF, 0xFB,
  0x81, 0xDA, 0x11, 0xF0, 0x77, 0x77, 0x74, 0xE0, 0x77, 0x77, 0x75, 0xD0, 0x77, 0x77, 0x76, 0xC0,
  0x77, 0x77, 0x77, 0xB0, 0x78, 0x0C, 0x00, 0xA0, 0x78, 0x0C, 0x10, 0x90, 0x78, 0x0C, 0x20, 0x07,
  0x80, 0xC3, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_chat_bubble_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_chat_bubble_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_chat_bubble 48x48, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_outlined_48_communication_chat_bubble_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x09, 0xFC, 0x3F, 0x0D, 0x80, 0xC3, 0xF0, 0xA8, 0x0C,
  0x2F, 0x0E, 0x01, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77, 0x4E, 0x07, 0x77, 0x77,
  0x5D, 0x07, 0x77, 0x77, 0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0, 0x0A, 0x07, 0x80, 0xC1,
  0x09, 0x07, 0x80, 0xC2, 0x00, 0x78, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_chat_bubble() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_chat_bubble_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_chat 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_outlined_48_communication_chat_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4,
  0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9,
  0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x4F, 0xFA, 0x75, 0xF9, 0x4F, 0xFA, 0x75, 0xF9, 0x4F, 0xFA, 0x75, 0xF9, 0x4F,
  0xFA, 0x75, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x10, 0x30, 0xEF, 0xFF, 0xFC, 0x0D, 0xC0, 0x30, 0xEF, 0xFF, 0xFD, 0x0A, 0xC0, 0xEF, 0xFF,
  0xFD, 0x0E, 0x01, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77, 0x4E, 0x07, 0x77, 0x77,
  0x5D, 0x07, 0x77, 0x77, 0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0, 0x0A, 0x07, 0x80, 0xC1,
  0x09, 0x07, 0x80, 0xC2, 0x00, 0x78, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_clear_all 48x48, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_outlined_48_communication_clear_all_data[] PROGMEM = {
  0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x80, 0xAA, 0x00, 0xFF,
  0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x80, 0xAA, 0x00, 0xFF, 0xFF, 0x71,
  0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71, 0xFF, 0xFF, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_clear_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 14, 41, 33), Box(0, 0, 47, 47),
      ic_outlined_48_communication_clear_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_comment 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_outlined_48_communication_comment_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x09, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4,
  0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9,
  0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xC0, 0xDF, 0xFF, 0xFC, 0x0E, 0x03, 0x1C, 0x0A, 0xFF, 0xFF, 0xD0, 0xE0, 0x3C, 0x01, 0x0E, 0xFF,
  0xFF, 0xD0, 0xEC, 0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF7, 0x77, 0x74, 0x07, 0xF7, 0x77, 0x75, 0x07,
  0xE7, 0x77, 0x76, 0x07, 0xD7, 0x77, 0x77, 0x07, 0xC8, 0x0C, 0x00, 0x07, 0xB8, 0x0C, 0x10, 0x07,
  0xA8, 0x0C, 0x20, 0x07, 0x98, 0x0C, 0x30, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_comments_disabled 48x48, 4-bit Alpha,  RLE, 298 bytes.
static const unsigned char ic_outlined_48_communication_comments_disabled_data[] PROGMEM = {
  0x20, 0x20, 0x75, 0x0C, 0xFF, 0xFF, 0x98, 0x1D, 0xA1, 0x28, 0x22, 0xEF, 0x75, 0x0C, 0xFF, 0xFF,
  0xA8, 0x2E, 0x12, 0xEB, 0x07, 0x50, 0xCF, 0xFF, 0xFA, 0x81, 0xA3, 0xEC, 0x07, 0x50, 0xCF, 0xFF,
  0xF9, 0x82, 0xD0, 0x3E, 0xC0, 0x77, 0x77, 0x73, 0xC2, 0x03, 0xD0, 0x77, 0x77, 0x72, 0xC3, 0xE0,
  0x77, 0x77, 0x71, 0xC3, 0xF0, 0x77, 0x77, 0x7C, 0x3F, 0x90, 0x75, 0x0C, 0xFF, 0xB4, 0xC3, 0xC0,
  0xEC, 0x07, 0x50, 0xCF, 0xFA, 0x4C, 0x3C, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0x94, 0xC3, 0xC1,
  0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0x4C, 0x3C, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x72, 0xC3, 0xC3,
  0x03, 0x0E, 0xC0, 0x77, 0x77, 0x1C, 0x3C, 0x4E, 0x07, 0x50, 0xCF, 0xC4, 0xC3, 0xC4, 0xF0, 0x75,
  0x0C, 0xFB, 0x4C, 0x3C, 0x4F, 0x90, 0x75, 0x0C, 0xFA, 0x4C, 0x3C, 0x4F, 0xA0, 0x75, 0x0C, 0xF9,
  0x4C, 0x3C, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x73, 0xC3, 0xC7, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x2C,
  0x3C, 0x4F, 0xD0, 0x75, 0x0C, 0xD4, 0xC3, 0xC4, 0xFE, 0x07, 0x50, 0xCC, 0x4C, 0x3C, 0x4F, 0xF0,
  0x75, 0x0C, 0xB4, 0xC3, 0xC4, 0xFF, 0x90, 0x75, 0x0C, 0xA4, 0xC3, 0xC7, 0x70, 0x30, 0xEC, 0x07,
  0x74, 0xC3, 0xC7, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x3C, 0x3C, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x72,
  0xC3, 0xC7, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x1C, 0x30, 0xDF, 0xFF, 0xE0, 0x75, 0x0C, 0xD3, 0x0A,
  0xFF, 0xFF, 0x07, 0x50, 0xCC, 0x30, 0x10, 0xEF, 0xFF, 0xF0, 0x75, 0x0C, 0xB4, 0x81, 0x1A, 0xDF,
  0xFF, 0xE0, 0x75, 0x0C, 0xA7, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0x97, 0x77, 0x72, 0x03,
  0x0E, 0xC0, 0x75, 0x0C, 0x77, 0x77, 0x30, 0x30, 0xEC, 0x07, 0x80, 0xC1, 0x00, 0x30, 0xEC, 0x07,
  0x80, 0xC1, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC1, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC1, 0x00, 0x30,
  0xEC, 0x07, 0x80, 0xC1, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC1, 0x00, 0x30, 0xEA, 0x0E, 0x02, 0x80,
  0xC2, 0x08, 0x23, 0xEE, 0x28, 0x0C, 0x40, 0x03, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_comments_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 43, 46), Box(0, 0, 47, 47),
      ic_outlined_48_communication_comments_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_contact_emergency 48x48, 4-bit Alpha,  RLE, 301 bytes.
static const unsigned char ic_outlined_48_communication_contact_emergency_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC4, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0D, 0x0F, 0x81, 0xE1, 0xA8, 0x0D,
  0x2F, 0x0A, 0x0D, 0x80, 0xD2, 0xF0, 0xDC, 0x80, 0xC4, 0x0F, 0x98, 0x0C, 0x40, 0xF9, 0x77, 0x77,
  0x20, 0x7A, 0x07, 0x6F, 0x97, 0x77, 0x60, 0x12, 0x07, 0xA0, 0x72, 0x01, 0x3F, 0x97, 0x77, 0x68,
  0x2D, 0xB2, 0x7A, 0x82, 0x72, 0xBD, 0x3F, 0x97, 0x77, 0x50, 0x7B, 0x0D, 0xA0, 0xDB, 0x07, 0x2F,
  0x97, 0x48, 0x46, 0xCE, 0xEC, 0x67, 0x20, 0x7F, 0xB0, 0x72, 0xF9, 0x72, 0x01, 0x0C, 0xE0, 0xC0,
  0x17, 0x10, 0x20, 0xBE, 0x0B, 0x02, 0x3F, 0x97, 0x20, 0xCF, 0x90, 0xC7, 0x10, 0x20, 0xBE, 0x0B,
  0x02, 0x3F, 0x97, 0x10, 0x6F, 0xB0, 0x66, 0x07, 0xFB, 0x07, 0x2F, 0x97, 0x10, 0xCB, 0x82, 0xB1,
  0x1B, 0xB0, 0xC6, 0x07, 0xB0, 0xDA, 0x0D, 0xB0, 0x72, 0xF9, 0x71, 0x0E, 0xB0, 0x12, 0x01, 0xB0,
  0xE7, 0x82, 0xDB, 0x27, 0xA8, 0x27, 0x2B, 0xD3, 0xF9, 0x71, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7,
  0x01, 0x20, 0x7A, 0x07, 0x20, 0x13, 0xF9, 0x71, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x73, 0x07,
  0xA0, 0x76, 0xF9, 0x71, 0x06, 0xFB, 0x06, 0x77, 0x6F, 0x97, 0x20, 0xCF, 0x90, 0xC7, 0x77, 0xF9,
  0x72, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0xF9, 0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x72, 0xF9,
  0x80, 0xC4, 0x0F, 0x98, 0x0C, 0x40, 0xF9, 0x72, 0x82, 0x58, 0xCD, 0xA8, 0x2D, 0xC8, 0x57, 0x77,
  0xF9, 0x68, 0x11, 0x9E, 0xFB, 0x81, 0xE9, 0x17, 0x74, 0xF9, 0x50, 0x8F, 0xFA, 0x08, 0x77, 0x3F,
  0x93, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x71, 0xF9, 0x20, 0x20, 0xDD, 0x82, 0xE9, 0x42, 0x28,
  0x22, 0x49, 0xED, 0x0D, 0x02, 0x77, 0xF9, 0x10, 0x10, 0xDC, 0x0E, 0x06, 0x73, 0x06, 0x0E, 0xC0,
  0xD0, 0x17, 0x6F, 0x91, 0x0C, 0xC0, 0xA0, 0x17, 0x50, 0x10, 0xAC, 0x0C, 0x76, 0xF9, 0x07, 0xC0,
  0x97, 0x72, 0x09, 0xC0, 0x77, 0x5C, 0x0D, 0x80, 0xD2, 0xF0, 0xD0, 0xA8, 0x0D, 0x2F, 0x81, 0x91,
  0xE8, 0x0D, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC4, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_contact_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_contact_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_contact_mail 48x48, 4-bit Alpha,  RLE, 271 bytes.
static const unsigned char ic_outlined_48_communication_contact_mail_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC4, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0D, 0x0F, 0x81, 0xE1, 0xA8, 0x0D,
  0x2F, 0x0A, 0x0D, 0x80, 0xD2, 0xF0, 0xDC, 0x80, 0xC4, 0x0F, 0x98, 0x0C, 0x40, 0xF9, 0x74, 0x84,
  0x6C, 0xEE, 0xC6, 0x7F, 0xF2, 0xF9, 0x72, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0xFF, 0x2F, 0x97, 0x20,
  0xCF, 0x90, 0xC5, 0xA0, 0x50, 0xEE, 0x0E, 0x05, 0xA2, 0xF9, 0x71, 0x06, 0xFB, 0x06, 0x4A, 0x10,
  0x10, 0xBC, 0x0B, 0x01, 0x1A, 0x2F, 0x97, 0x10, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC4, 0xA8, 0x2A,
  0x10, 0x6A, 0x82, 0x60, 0x1A, 0xA2, 0xF9, 0x71, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE4, 0xB8, 0x6D,
  0x30, 0x22, 0x03, 0xDB, 0x2F, 0x97, 0x10, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x4D, 0x08, 0x20, 0x8D,
  0x2F, 0x97, 0x10, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC4, 0xE0, 0x0C, 0xE2, 0xF9, 0x71, 0x06, 0xFB,
  0x06, 0x4F, 0xF2, 0xF9, 0x72, 0x0C, 0xF9, 0x0C, 0x5F, 0xF2, 0xF9, 0x72, 0x01, 0x0C, 0xE0, 0xC0,
  0x17, 0x77, 0xF9, 0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x72, 0xF9, 0x80, 0xC4, 0x0F, 0x98, 0x0C,
  0x40, 0xF9, 0x72, 0x89, 0x05, 0x8B, 0xDE, 0xED, 0xB8, 0x57, 0x77, 0xF9, 0x60, 0x40, 0xAF, 0xD0,
  0xA0, 0x47, 0x74, 0xF9, 0x40, 0x20, 0xBF, 0xFA, 0x0B, 0x02, 0x77, 0x2F, 0x93, 0x03, 0x0E, 0xFF,
  0xC0, 0xE0, 0x37, 0x71, 0xF9, 0x20, 0x10, 0xED, 0x82, 0xC8, 0x41, 0x28, 0x21, 0x48, 0xCD, 0x0E,
  0x01, 0x77, 0xF9, 0x20, 0x9C, 0x0B, 0x03, 0x73, 0x03, 0x0B, 0xC0, 0x97, 0x7F, 0x92, 0x0E, 0xFF,
  0xF9, 0x0D, 0x77, 0xF9, 0x2F, 0xFF, 0xB7, 0x7F, 0x92, 0xFF, 0xFB, 0x77, 0xF9, 0x2F, 0xFF, 0xB7,
  0x7F, 0x98, 0x0C, 0x40, 0xF9, 0x80, 0xC4, 0x0C, 0x0D, 0x80, 0xD2, 0xF0, 0xD0, 0xA8, 0x0D, 0x2F,
  0x81, 0x91, 0xE8, 0x0D, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC4, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_contact_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_contact_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_contact_phone 48x48, 4-bit Alpha,  RLE, 302 bytes.
static const unsigned char ic_outlined_48_communication_contact_phone_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC4, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0D, 0x0F, 0x81, 0xE1, 0xA8, 0x0D,
  0x2F, 0x0A, 0x0D, 0x80, 0xD2, 0xF0, 0xDC, 0x80, 0xC4, 0x0F, 0x98, 0x0C, 0x40, 0xF9, 0x74, 0x84,
  0x6C, 0xEE, 0xC6, 0x77, 0x20, 0x80, 0x75, 0xF9, 0x72, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x60, 0x9A,
  0x07, 0x4F, 0x97, 0x20, 0xCF, 0x90, 0xC7, 0x50, 0x7C, 0x07, 0x3F, 0x97, 0x10, 0x6F, 0xB0, 0x67,
  0x30, 0x4E, 0x07, 0x2F, 0x97, 0x10, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x30, 0xDE, 0x09, 0x2F,
  0x97, 0x10, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x72, 0x07, 0xE0, 0xC3, 0xF9, 0x71, 0x0E, 0xB0, 0x12,
  0x01, 0xB0, 0xE7, 0x20, 0xDD, 0x0E, 0x02, 0x3F, 0x97, 0x10, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7,
  0x10, 0x3E, 0x05, 0x4F, 0x97, 0x10, 0x6F, 0xB0, 0x67, 0x10, 0x8A, 0x08, 0x71, 0xF9, 0x72, 0x0C,
  0xF9, 0x0C, 0x72, 0x0B, 0xA0, 0x47, 0x1F, 0x97, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x72, 0x0D, 0xA0,
  0x27, 0x1F, 0x97, 0x48, 0x46, 0xCE, 0xEC, 0x67, 0x40, 0xEA, 0x72, 0xF9, 0x77, 0x77, 0x0E, 0xA7,
  0x2F, 0x97, 0x77, 0x70, 0xDA, 0x02, 0x71, 0xF9, 0x72, 0x89, 0x05, 0x8B, 0xDE, 0xED, 0xB8, 0x57,
  0x20, 0xBA, 0x04, 0x71, 0xF9, 0x60, 0x40, 0xAF, 0xD0, 0xA0, 0x46, 0x08, 0xA0, 0x87, 0x1F, 0x94,
  0x02, 0x0B, 0xFF, 0xA0, 0xB0, 0x24, 0x03, 0xE0, 0x54, 0xF9, 0x30, 0x30, 0xEF, 0xFC, 0x0E, 0x03,
  0x40, 0xDD, 0x0E, 0x02, 0x3F, 0x92, 0x01, 0x0E, 0xD8, 0x2C, 0x84, 0x12, 0x82, 0x14, 0x8C, 0xD0,
  0xE0, 0x13, 0x07, 0xE0, 0xC3, 0xF9, 0x20, 0x9C, 0x0B, 0x03, 0x73, 0x03, 0x0B, 0xC0, 0x94, 0x0D,
  0xE0, 0x92, 0xF9, 0x20, 0xEF, 0xFF, 0x90, 0xD4, 0x04, 0xE0, 0x72, 0xF9, 0x2F, 0xFF, 0xB5, 0x07,
  0xC0, 0x73, 0xF9, 0x2F, 0xFF, 0xB6, 0x09, 0xA0, 0x74, 0xF9, 0x2F, 0xFF, 0xB7, 0x08, 0x07, 0x5F,
  0x98, 0x0C, 0x40, 0xF9, 0x80, 0xC4, 0x0C, 0x0D, 0x80, 0xD2, 0xF0, 0xD0, 0xA8, 0x0D, 0x2F, 0x81,
  0x91, 0xE8, 0x0D, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC4, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_contact_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_contact_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_contacts 48x48, 4-bit Alpha,  RLE, 231 bytes.
static const unsigned char ic_outlined_48_communication_contacts_data[] PROGMEM = {
  0x4F, 0xFF, 0xFC, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC, 0x71, 0xFF, 0xFF, 0xC8, 0x0A, 0xC1,
  0x08, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x76, 0x84,
  0x4B, 0xEE, 0xB4, 0x76, 0xF9, 0x75, 0x08, 0xE0, 0x87, 0x5F, 0x97, 0x40, 0x4F, 0x90, 0x47, 0x4F,
  0x97, 0x40, 0xBA, 0x82, 0xB1, 0x1B, 0xA0, 0xB7, 0x4F, 0x97, 0x40, 0xEA, 0x01, 0x20, 0x1A, 0x0E,
  0x74, 0xF9, 0x74, 0x0E, 0xA0, 0x12, 0x01, 0xA0, 0xE7, 0x4F, 0x97, 0x40, 0xBA, 0x82, 0xB1, 0x1B,
  0xA0, 0xB7, 0x4F, 0x97, 0x40, 0x4F, 0x90, 0x47, 0x4F, 0x97, 0x50, 0x8E, 0x08, 0x75, 0xF9, 0x76,
  0x84, 0x4B, 0xEE, 0xB4, 0x76, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x74, 0x82, 0x37,
  0xBD, 0xA8, 0x2D, 0xB7, 0x37, 0x4F, 0x97, 0x20, 0x60, 0xDF, 0xB0, 0xD0, 0x67, 0x2F, 0x97, 0x02,
  0x0D, 0xFF, 0x0D, 0x02, 0x7F, 0x96, 0x01, 0x0E, 0xB8, 0x2E, 0x95, 0x22, 0x82, 0x25, 0x9E, 0xB0,
  0xE0, 0x16, 0xF9, 0x60, 0x9A, 0x0E, 0x06, 0x73, 0x06, 0x0E, 0xA0, 0x96, 0xF9, 0x60, 0xDF, 0xFC,
  0x0D, 0x6F, 0x96, 0xFF, 0xE6, 0xF9, 0x6F, 0xFE, 0x6F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C,
  0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x80, 0xAC, 0x10, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC, 0x71,
  0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 43, 47), Box(0, 0, 47, 47),
      ic_outlined_48_communication_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_co_present 48x48, 4-bit Alpha,  RLE, 272 bytes.
static const unsigned char ic_outlined_48_communication_co_present_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x71, 0x86,
  0x28, 0xCE, 0xEC, 0x82, 0x77, 0x6F, 0x97, 0x09, 0xF9, 0x09, 0x77, 0x5F, 0x96, 0x0B, 0xFB, 0x0B,
  0x77, 0x4F, 0x95, 0x09, 0xFD, 0x09, 0x77, 0x3F, 0x94, 0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02,
  0x77, 0x2F, 0x94, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x72, 0xF9, 0x40, 0xCB, 0x05,
  0x60, 0x5B, 0x0C, 0x77, 0x2F, 0x94, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x72, 0xF9, 0x40, 0xEB,
  0x01, 0x60, 0x1B, 0x0E, 0x77, 0x2F, 0x94, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0x72, 0xF9, 0x40,
  0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08, 0x77, 0x2F, 0x94, 0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC,
  0x02, 0x77, 0x2F, 0x95, 0x09, 0xFD, 0x09, 0x77, 0x3F, 0x96, 0x0B, 0xFB, 0x0B, 0x77, 0x4C, 0x74,
  0x09, 0xF9, 0x09, 0x77, 0x5C, 0x75, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0x6C, 0x80, 0xC4, 0x0C,
  0x80, 0xC4, 0x0C, 0x72, 0x84, 0x26, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x86, 0x27, 0x73, 0xC6, 0x81,
  0x49, 0xEF, 0xF8, 0x1E, 0x94, 0x77, 0xC4, 0x07, 0x0D, 0xFF, 0xE0, 0xD0, 0x77, 0x5C, 0x20, 0x50,
  0xEF, 0xFF, 0xB0, 0xE0, 0x57, 0x3C, 0x10, 0x7F, 0x84, 0xEA, 0x74, 0x21, 0x28, 0x41, 0x24, 0x7A,
  0xEF, 0x07, 0x72, 0xC0, 0x3D, 0x81, 0xE9, 0x47, 0x78, 0x14, 0x9E, 0xD0, 0x37, 0x1C, 0x09, 0xB8,
  0x1E, 0x71, 0x77, 0x48, 0x11, 0x7E, 0xB0, 0x97, 0x1C, 0x0D, 0xB0, 0x47, 0x77, 0x10, 0x4B, 0x0D,
  0x71, 0xF9, 0x77, 0x73, 0xC7, 0x1B, 0x0D, 0xC7, 0x77, 0x3C, 0x71, 0xB0, 0xAF, 0xFF, 0xFC, 0x71,
  0xA0, 0xE0, 0x1F, 0xFF, 0xFC, 0x71, 0x81, 0xDA, 0x11, 0xFF, 0xFF, 0xC7, 0x5F, 0xFF, 0xFC, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_co_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_co_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_desktop_access_disabled 48x48, 4-bit Alpha,  RLE, 333 bytes.
static const unsigned char ic_outlined_48_communication_desktop_access_disabled_data[] PROGMEM = {
  0x20, 0x40, 0x18, 0x0C, 0x70, 0x82, 0x4F, 0xD1, 0x40, 0x6F, 0xFF, 0xFC, 0x83, 0xD9, 0x10, 0x4B,
  0x0D, 0x01, 0x40, 0x6F, 0xFF, 0xFD, 0x81, 0xE1, 0xAC, 0x0D, 0x01, 0x40, 0x6F, 0xFF, 0xFD, 0x81,
  0x90, 0xAC, 0x0D, 0x01, 0x40, 0x6F, 0xFF, 0xFC, 0x0D, 0x2D, 0x0D, 0x01, 0x77, 0x77, 0x5C, 0x2E,
  0x0D, 0x01, 0x77, 0x77, 0x4C, 0x2F, 0x0D, 0x01, 0x77, 0x77, 0x3C, 0x2F, 0x90, 0xD0, 0x17, 0x77,
  0x72, 0xC2, 0xC0, 0xAC, 0x0D, 0x01, 0x77, 0x77, 0x1C, 0x2C, 0x10, 0xAC, 0x0D, 0x01, 0x77, 0x77,
  0xC2, 0xC2, 0x0A, 0xC0, 0xD0, 0x17, 0x77, 0x6C, 0x2C, 0x30, 0xAC, 0x0D, 0x01, 0x77, 0x75, 0xC2,
  0xC4, 0x0A, 0xC0, 0xD0, 0x17, 0x77, 0x4C, 0x2C, 0x50, 0xAC, 0x0D, 0x01, 0x77, 0x73, 0xC2, 0xC6,
  0x0A, 0xC0, 0xD0, 0x17, 0x77, 0x2C, 0x2C, 0x70, 0xAC, 0x0D, 0x01, 0x77, 0x71, 0xC2, 0xC7, 0x10,
  0xAC, 0x0D, 0x01, 0x77, 0x7C, 0x2C, 0x72, 0x0A, 0xC0, 0xD0, 0x17, 0x76, 0xC2, 0xC7, 0x30, 0xAC,
  0x0D, 0x01, 0x77, 0x5C, 0x2C, 0x74, 0x0A, 0xC0, 0xD0, 0x17, 0x74, 0xC2, 0xC7, 0x50, 0xAC, 0x0D,
  0x01, 0x77, 0x3C, 0x2C, 0x76, 0x0A, 0xC0, 0xD0, 0x17, 0x72, 0xC2, 0xC7, 0x70, 0xAC, 0x0D, 0x01,
  0x77, 0x1C, 0x2C, 0x77, 0x10, 0xAC, 0x0D, 0x01, 0x77, 0xC2, 0xC7, 0x72, 0x0A, 0xC0, 0xD0, 0x17,
  0x6C, 0x2C, 0x77, 0x30, 0xAC, 0x0D, 0x01, 0x75, 0xC2, 0xC7, 0x74, 0x0A, 0xC0, 0xD0, 0x17, 0x4C,
  0x2C, 0x77, 0x50, 0xAC, 0x0D, 0x01, 0x73, 0xC2, 0x0D, 0xFF, 0xFF, 0x0D, 0x01, 0x40, 0x6F, 0x0D,
  0x20, 0xAF, 0xFF, 0xF9, 0x0D, 0x01, 0x40, 0x6E, 0x09, 0x20, 0x10, 0xEF, 0xFF, 0xF9, 0x0D, 0x01,
  0x40, 0x6C, 0x0E, 0x01, 0x38, 0x11, 0xAE, 0xFF, 0xFF, 0x0D, 0x01, 0x48, 0x36, 0xFD, 0x91, 0x77,
  0x7F, 0x92, 0x0A, 0xC0, 0xD0, 0x17, 0x77, 0x71, 0xF9, 0x30, 0xAC, 0x0D, 0x01, 0x77, 0x77, 0xF9,
  0x40, 0xAC, 0x0D, 0x01, 0x77, 0x76, 0xF9, 0x50, 0xAC, 0x0D, 0x01, 0x77, 0x71, 0xFF, 0xA2, 0x0A,
  0xC0, 0xD0, 0x17, 0x77, 0xFF, 0xA3, 0x0A, 0xC0, 0xD0, 0x17, 0x76, 0xFF, 0xA4, 0x0A, 0xC0, 0xD0,
  0x17, 0x75, 0xFF, 0xA5, 0x0A, 0xC0, 0xD0, 0x18, 0x0C, 0x40, 0x0A, 0xC0, 0xD0, 0x18, 0x0C, 0x40,
  0x0A, 0xC0, 0x48, 0x0C, 0x50, 0x0A, 0xA0, 0x48, 0x0C, 0x70, 0x0A, 0x04, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_desktop_access_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 45, 47), Box(0, 0, 47, 47),
      ic_outlined_48_communication_desktop_access_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_dialer_sip 48x48, 4-bit Alpha,  RLE, 248 bytes.
static const unsigned char ic_outlined_48_communication_dialer_sip_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xD0, 0x47, 0xE2, 0xA2, 0xE0, 0xDF, 0xA0, 0xD7, 0xE2, 0xA2, 0xFF, 0xB7, 0xA6,
  0xA2, 0xA2, 0xA0, 0xEF, 0xB0, 0x16, 0xA6, 0xA2, 0xA2, 0xA0, 0xDB, 0x01, 0x20, 0xDB, 0x03, 0x6E,
  0x2A, 0x2E, 0x0C, 0xB0, 0x42, 0x0B, 0xB0, 0x46, 0xE2, 0xA2, 0xE0, 0xAB, 0x06, 0x20, 0x9B, 0x07,
  0x73, 0xA2, 0xA2, 0xA4, 0x07, 0xB0, 0x82, 0x06, 0xB0, 0xB7, 0x3A, 0x2A, 0x2A, 0x40, 0x5B, 0x0B,
  0x20, 0x2B, 0x0E, 0x6E, 0x2A, 0x2A, 0x40, 0x2C, 0x20, 0x5C, 0x02, 0x5E, 0x2A, 0x2A, 0x50, 0xDB,
  0x04, 0x05, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x9B, 0x0C, 0xD0, 0x47, 0x77, 0x40, 0x5F, 0x90, 0x57,
  0x77, 0x60, 0xEE, 0x05, 0x77, 0x77, 0x09, 0xD0, 0x57, 0x77, 0x71, 0x03, 0xC0, 0x77, 0x77, 0x73,
  0x0B, 0xB0, 0xC7, 0x77, 0x73, 0x03, 0xC0, 0x57, 0x77, 0x73, 0x0B, 0xB0, 0xE0, 0x17, 0x77, 0x72,
  0x02, 0xC0, 0xA7, 0x77, 0x73, 0x07, 0xC0, 0x67, 0x77, 0x73, 0x0C, 0xC0, 0x47, 0x77, 0x72, 0x02,
  0x0E, 0xB0, 0xE0, 0x37, 0x77, 0x72, 0x05, 0xC0, 0xE0, 0x37, 0x40, 0x10, 0x37, 0x73, 0x06, 0xC0,
  0xE0, 0x47, 0x28, 0x75, 0xEF, 0xEB, 0x74, 0x31, 0x75, 0x08, 0xD0, 0x67, 0x05, 0xFB, 0x0D, 0x04,
  0x73, 0x08, 0xD0, 0xA0, 0x14, 0x05, 0xFD, 0x0D, 0x74, 0x06, 0xD0, 0xE0, 0x52, 0x05, 0xFF, 0x75,
  0x05, 0x0E, 0xD0, 0xC0, 0x7D, 0x84, 0x53, 0x69, 0xBD, 0xC7, 0x60, 0x20, 0xCF, 0xB0, 0x56, 0xC7,
  0x71, 0x07, 0xF9, 0x0C, 0x04, 0x6C, 0x77, 0x20, 0x20, 0xBF, 0xA8, 0x3B, 0x86, 0x42, 0xC7, 0x74,
  0x03, 0x0B, 0xFF, 0xA7, 0x76, 0x81, 0x39, 0xEF, 0xE7, 0x77, 0x28, 0x15, 0x9D, 0xFA, 0x0D, 0x77,
  0x75, 0x89, 0x02, 0x58, 0xAC, 0xDD, 0xFD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_dialer_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_dialer_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_dialpad 48x48, 4-bit Alpha,  RLE, 311 bytes.
static const unsigned char ic_outlined_48_communication_dialpad_data[] PROGMEM = {
  0x18, 0x41, 0xAD, 0xDA, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x68, 0x71, 0xAD, 0xDA, 0x10, 0x1E, 0xC0,
  0xE0, 0x14, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC8, 0x1E, 0x1A, 0xE0, 0xA4, 0x0A, 0xE0,
  0xA4, 0x0A, 0xE0, 0xA0, 0xDE, 0x0D, 0x40, 0xDE, 0x0D, 0x40, 0xDE, 0x00, 0xDE, 0x0D, 0x40, 0xDE,
  0x0D, 0x40, 0xDE, 0x0D, 0x0A, 0xE0, 0xA4, 0x0A, 0xE0, 0xA4, 0x0A, 0xE8, 0x1A, 0x1E, 0xC0, 0xE0,
  0x14, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC8, 0x7E, 0x10, 0x1A, 0xDD, 0xA1, 0x68, 0x41,
  0xAD, 0xDA, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x80, 0x9F, 0x60, 0x84, 0x1A, 0xDD, 0xA1, 0x68, 0x41,
  0xAD, 0xDA, 0x16, 0x87, 0x1A, 0xDD, 0xA1, 0x01, 0xEC, 0x0E, 0x01, 0x40, 0x10, 0xEC, 0x0E, 0x01,
  0x40, 0x10, 0xEC, 0x81, 0xE1, 0xAE, 0x0A, 0x40, 0xAE, 0x0A, 0x40, 0xAE, 0x0A, 0x0D, 0xE0, 0xD4,
  0x0D, 0xE0, 0xD4, 0x0D, 0xE0, 0x0D, 0xE0, 0xD4, 0x0D, 0xE0, 0xD4, 0x0D, 0xE0, 0xD0, 0xAE, 0x0A,
  0x40, 0xAE, 0x0A, 0x40, 0xAE, 0x81, 0xA1, 0xEC, 0x0E, 0x01, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x40,
  0x10, 0xEC, 0x87, 0xE1, 0x01, 0xAD, 0xDA, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x68, 0x41, 0xAD, 0xDA,
  0x18, 0x09, 0xF6, 0x08, 0x41, 0xAD, 0xDA, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x68, 0x71, 0xAD, 0xDA,
  0x10, 0x1E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC8, 0x1E, 0x1A, 0xE0,
  0xA4, 0x0A, 0xE0, 0xA4, 0x0A, 0xE0, 0xA0, 0xDE, 0x0D, 0x40, 0xDE, 0x0D, 0x40, 0xDE, 0x00, 0xDE,
  0x0D, 0x40, 0xDE, 0x0D, 0x40, 0xDE, 0x0D, 0x0A, 0xE0, 0xA4, 0x0A, 0xE0, 0xA4, 0x0A, 0xE8, 0x1A,
  0x1E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC0, 0xE0, 0x14, 0x01, 0x0E, 0xC8, 0x7E, 0x10, 0x1A, 0xDD,
  0xA1, 0x68, 0x41, 0xAD, 0xDA, 0x16, 0x84, 0x1A, 0xDD, 0xA1, 0x80, 0xA9, 0x20, 0x84, 0x1A, 0xDD,
  0xA1, 0x77, 0x74, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0xAE, 0x0A, 0x77, 0x73, 0x0D, 0xE0,
  0xD7, 0x77, 0x30, 0xDE, 0x0D, 0x77, 0x73, 0x0A, 0xE0, 0xA7, 0x77, 0x30, 0x10, 0xEC, 0x0E, 0x01,
  0x77, 0x74, 0x84, 0x1A, 0xDD, 0xA1, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_dialpad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_dialpad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_document_scanner 48x48, 4-bit Alpha,  RLE, 185 bytes.
static const unsigned char ic_outlined_48_communication_document_scanner_data[] PROGMEM = {
  0xFB, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xF7, 0x77, 0x74, 0xF9,
  0x77, 0x77, 0x4F, 0x93, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x13, 0xF9, 0x20, 0x10, 0xEF, 0xFF,
  0xB0, 0xE0, 0x12, 0xF9, 0x20, 0xAF, 0xFF, 0xD0, 0xA2, 0xF9, 0x20, 0xDF, 0xFF, 0xD0, 0xD2, 0xC6,
  0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC4, 0xFD,
  0x4C, 0x75, 0xC4, 0xFD, 0x4C, 0x75, 0xC4, 0xFD, 0x4C, 0x75, 0xC4, 0xFD, 0x4C, 0x75, 0xC7, 0x76,
  0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC4, 0xFD, 0x4C, 0x75, 0xC4, 0xFD, 0x4C, 0x75, 0xC4, 0xFD, 0x4C,
  0x75, 0xC4, 0xFD, 0x4C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC4, 0xFD, 0x4C, 0x75,
  0xC4, 0xFD, 0x4C, 0x75, 0xC4, 0xFD, 0x4C, 0x75, 0xC4, 0xFD, 0x4C, 0x75, 0xC7, 0x76, 0xC7, 0x5C,
  0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x6C, 0x20, 0xDF, 0xFF, 0xD0, 0xD2, 0xF9,
  0x20, 0xAF, 0xFF, 0xD0, 0xA2, 0xF9, 0x20, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x12, 0xF9, 0x38, 0x11,
  0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x3F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0xF7, 0x76, 0xFF,
  0xE7, 0x76, 0xFF, 0xE7, 0x76, 0xFF, 0xE7, 0x76, 0xFB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_document_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_document_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_domain_disabled 48x48, 4-bit Alpha,  RLE, 291 bytes.
static const unsigned char ic_outlined_48_communication_domain_disabled_data[] PROGMEM = {
  0x20, 0x40, 0x18, 0x0C, 0x60, 0x82, 0x4F, 0xD1, 0x80, 0xC4, 0x00, 0x4B, 0x0D, 0x01, 0x80, 0xC3,
  0x00, 0xAC, 0x0D, 0x01, 0x40, 0x6F, 0xD7, 0x77, 0x10, 0xAC, 0x0D, 0x01, 0x40, 0x6F, 0xC7, 0x77,
  0x20, 0xAC, 0x0D, 0x01, 0x40, 0x6F, 0xB7, 0x77, 0x30, 0xAC, 0x0D, 0x01, 0x40, 0x6F, 0xA7, 0x77,
  0x4D, 0x0D, 0x01, 0x40, 0x64, 0xC7, 0x77, 0x4E, 0x0D, 0x01, 0x71, 0xC7, 0x77, 0x4F, 0x0D, 0x01,
  0x7C, 0x77, 0x74, 0xF9, 0x0D, 0x01, 0x6C, 0x77, 0x74, 0xFA, 0x0D, 0x01, 0x40, 0x6F, 0xFF, 0xB5,
  0xFB, 0x0D, 0x01, 0x40, 0x6F, 0xFF, 0xA5, 0xFC, 0x0D, 0x01, 0x40, 0x6F, 0xFF, 0x95, 0xFD, 0x0D,
  0x01, 0x40, 0x6F, 0xFF, 0x5C, 0x4D, 0x0D, 0x01, 0x40, 0x67, 0x72, 0xC5, 0xC4, 0xE0, 0xD0, 0x17,
  0x76, 0xC5, 0xC4, 0xF0, 0xD0, 0x17, 0x75, 0xC5, 0xC4, 0xF9, 0x0D, 0x01, 0x77, 0x4C, 0x5F, 0xFB,
  0x0D, 0x01, 0x72, 0xC4, 0xC5, 0xFF, 0xC0, 0xD0, 0x17, 0x1C, 0x4C, 0x5F, 0xFD, 0x0D, 0x01, 0x7C,
  0x4C, 0x5F, 0xFE, 0x0D, 0x01, 0x6C, 0x4C, 0x5C, 0x4C, 0x4D, 0x0D, 0x01, 0x76, 0xC5, 0xC4, 0xC4,
  0xE0, 0xD0, 0x17, 0x5C, 0x5C, 0x4C, 0x4F, 0x0D, 0x01, 0x74, 0xC5, 0xC4, 0xC4, 0xF9, 0x0D, 0x01,
  0x73, 0xC5, 0xFF, 0xFC, 0x0D, 0x01, 0x72, 0xC5, 0xFF, 0xFD, 0x0D, 0x01, 0x71, 0xC5, 0xFF, 0xFE,
  0x0D, 0x01, 0x7C, 0x5F, 0xFF, 0xF0, 0xD0, 0x16, 0xC5, 0xC4, 0xC4, 0xC4, 0x0A, 0xC0, 0xD0, 0x15,
  0xC5, 0xC4, 0xC4, 0xC5, 0x0A, 0xC0, 0xD0, 0x14, 0x06, 0xB5, 0xC4, 0xC4, 0xC6, 0x0A, 0xC0, 0xD0,
  0x14, 0x06, 0xA5, 0xC4, 0xC4, 0xC7, 0x0A, 0xC0, 0xD0, 0x14, 0x06, 0x95, 0xFF, 0xFF, 0xD0, 0xD0,
  0x14, 0x06, 0x5F, 0xFF, 0xFE, 0x0D, 0x01, 0x72, 0xFF, 0xFF, 0xF0, 0xD0, 0x17, 0x18, 0x0C, 0x0F,
  0x0D, 0x01, 0x80, 0xC3, 0x00, 0xAC, 0x0D, 0x01, 0x80, 0xC3, 0x00, 0xAC, 0x0D, 0x01, 0x80, 0xC3,
  0x00, 0xAC, 0x0D, 0x01, 0x80, 0xC3, 0x00, 0xAC, 0x04, 0x80, 0xC4, 0x00, 0xAA, 0x04, 0x80, 0xC6,
  0x00, 0xA0, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_domain_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 44, 47), Box(0, 0, 47, 47),
      ic_outlined_48_communication_domain_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_domain_verification 48x48, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_outlined_48_communication_domain_verification_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAA, 0x0F, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77,
  0x77, 0xF9, 0x77, 0x58, 0x13, 0xC1, 0x6F, 0x97, 0x74, 0x83, 0x3E, 0xFD, 0x15, 0xF9, 0x77, 0x30,
  0x30, 0xEB, 0x0D, 0x5F, 0x97, 0x72, 0x03, 0x0E, 0xC0, 0x75, 0xF9, 0x70, 0x80, 0x16, 0x03, 0x0E,
  0xC0, 0x76, 0xF9, 0x68, 0x2A, 0xFD, 0x14, 0x03, 0x0E, 0xC0, 0x77, 0xF9, 0x50, 0xAB, 0x0D, 0x01,
  0x20, 0x30, 0xEC, 0x07, 0x71, 0xF9, 0x50, 0xAC, 0x82, 0xD1, 0x3E, 0xC0, 0x77, 0x2F, 0x96, 0x0A,
  0xC0, 0xD0, 0xEC, 0x07, 0x73, 0xF9, 0x70, 0xAF, 0x90, 0x77, 0x4F, 0x97, 0x10, 0xAE, 0x07, 0x75,
  0xF9, 0x72, 0x0A, 0xC0, 0x77, 0x6F, 0x97, 0x30, 0xAA, 0x07, 0x77, 0xF9, 0x74, 0x0A, 0x07, 0x77,
  0x1F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7C, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF,
  0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_domain_verification() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_domain_verification_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_duo 48x48, 4-bit Alpha,  RLE, 228 bytes.
static const unsigned char ic_outlined_48_communication_duo_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDF, 0xFB, 0x81, 0xDA, 0x17, 0x58, 0x11, 0x7D, 0xFF, 0xFB, 0x0E, 0x01,
  0x73, 0x08, 0x0E, 0xFF, 0xFE, 0x0A, 0x71, 0x04, 0x0D, 0xFF, 0xFF, 0x90, 0xD7, 0x07, 0xFF, 0xFF,
  0xC6, 0x09, 0xFF, 0xFF, 0xD5, 0x09, 0xFF, 0xFF, 0xE4, 0x07, 0xFF, 0xFF, 0xF3, 0x03, 0x80, 0xC0,
  0xF3, 0x0D, 0x80, 0xC0, 0xF2, 0x06, 0x80, 0xC1, 0xF2, 0x0E, 0x80, 0xC1, 0xF1, 0x06, 0x80, 0xC2,
  0xF1, 0x0B, 0x80, 0xC2, 0xF0, 0x1F, 0xA7, 0x7C, 0x0E, 0x05, 0xFB, 0x05, 0xFA, 0x77, 0xB0, 0xA0,
  0x11, 0xFB, 0x09, 0xFA, 0x77, 0x90, 0xE0, 0x53, 0xFB, 0x0B, 0xFA, 0x77, 0x0A, 0x01, 0x4F, 0xB0,
  0xDF, 0xA7, 0x76, 0xFB, 0x0E, 0xFA, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xB0, 0xDF, 0xA7, 0x76, 0xFA,
  0x0E, 0x0C, 0xFA, 0x77, 0x0A, 0x01, 0x4F, 0xA0, 0xC0, 0xAF, 0xA7, 0x79, 0x0E, 0x05, 0x3F, 0xA0,
  0xA0, 0x8F, 0xA7, 0x7B, 0x0A, 0x01, 0x1F, 0xA0, 0x70, 0x3F, 0xA7, 0x7C, 0x0E, 0x05, 0xFA, 0x81,
  0x30, 0xE8, 0x0C, 0x0F, 0x0D, 0x20, 0x98, 0x0C, 0x0F, 0x08, 0x20, 0x28, 0x0C, 0x0F, 0x01, 0x30,
  0x9F, 0xFF, 0xFE, 0x08, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0D, 0x60, 0x6F, 0xFF, 0xFC, 0x04, 0x70,
  0x9F, 0xFF, 0xFA, 0x08, 0x72, 0x0B, 0xFF, 0xFF, 0x09, 0x73, 0x01, 0x0B, 0xFF, 0xFD, 0x09, 0x76,
  0x09, 0xFF, 0xFB, 0x07, 0x77, 0x10, 0x60, 0xEF, 0xFE, 0x0D, 0x03, 0x77, 0x30, 0x10, 0x9F, 0xFB,
  0x0E, 0x07, 0x77, 0x78, 0x12, 0x9E, 0xFD, 0x0C, 0x06, 0x77, 0x75, 0x89, 0x23, 0x8A, 0xCD, 0xFE,
  0xDB, 0x95, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_duo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_duo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_email 48x48, 4-bit Alpha,  RLE, 199 bytes.
static const unsigned char ic_outlined_48_communication_email_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x0A, 0x01, 0x77, 0x77, 0x01, 0x0A, 0xFA, 0x0E, 0x06,
  0x77, 0x75, 0x06, 0x0E, 0xFD, 0x0C, 0x03, 0x77, 0x71, 0x03, 0x0C, 0xFF, 0xA0, 0x87, 0x76, 0x08,
  0xFE, 0x04, 0x0D, 0xC0, 0xD0, 0x47, 0x72, 0x04, 0x0D, 0xC0, 0xD0, 0x4F, 0x92, 0x08, 0xD0, 0xA0,
  0x17, 0x50, 0x10, 0xAD, 0x08, 0x2F, 0x93, 0x03, 0x0C, 0xC0, 0xE0, 0x67, 0x30, 0x60, 0xEC, 0x0C,
  0x03, 0x3F, 0x95, 0x06, 0x0E, 0xC0, 0xC0, 0x36, 0x03, 0x0C, 0xC0, 0xE0, 0x65, 0xF9, 0x60, 0x10,
  0xAD, 0x08, 0x40, 0x8D, 0x0A, 0x01, 0x6F, 0x97, 0x10, 0x40, 0xDC, 0x82, 0xD4, 0x4D, 0xC0, 0xD0,
  0x47, 0x1F, 0x97, 0x30, 0x8F, 0xB0, 0x87, 0x3F, 0x97, 0x40, 0x30, 0xCE, 0x0C, 0x03, 0x74, 0xF9,
  0x76, 0x06, 0x0E, 0xA0, 0xE0, 0x67, 0x6F, 0x97, 0x78, 0x21, 0xAA, 0x17, 0x7F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C,
  0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_forum 48x48, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_outlined_48_communication_forum_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFD, 0x0D, 0x04, 0x73, 0x0D, 0xFF, 0xFF, 0x0D, 0x73, 0xFF, 0xFF, 0xA7, 0x3F,
  0xFF, 0xFA, 0x73, 0xC7, 0x77, 0x1C, 0x73, 0xC7, 0x77, 0x1C, 0x73, 0xC7, 0x77, 0x1C, 0x73, 0xC7,
  0x77, 0x1C, 0x73, 0xC7, 0x77, 0x1C, 0x4C, 0x0D, 0x04, 0xC7, 0x77, 0x1C, 0x4D, 0x0D, 0xC7, 0x77,
  0x1C, 0x4F, 0xB7, 0x77, 0x1C, 0x4F, 0xB7, 0x77, 0x1C, 0x4F, 0xB7, 0x77, 0x1C, 0x4F, 0xB7, 0x77,
  0x1C, 0x4F, 0xB7, 0x77, 0x1C, 0x4F, 0xB7, 0x77, 0x1C, 0x4F, 0xB7, 0x77, 0x1C, 0x4F, 0xB1, 0x03,
  0x0E, 0xFF, 0xFA, 0x4F, 0xB0, 0x30, 0xEF, 0xFF, 0xB4, 0xFB, 0x0E, 0xFF, 0xFB, 0x0D, 0x4F, 0xFF,
  0xFE, 0x0D, 0x04, 0x4F, 0xE0, 0x77, 0x77, 0x5F, 0xD0, 0x77, 0x77, 0x6F, 0xC0, 0x77, 0x77, 0x7F,
  0xB0, 0x77, 0x77, 0x71, 0xFA, 0x07, 0x4F, 0xFF, 0xFE, 0x07, 0x5F, 0xFF, 0xFD, 0x07, 0x6F, 0xFF,
  0xFC, 0x07, 0x7F, 0xFF, 0xFC, 0x71, 0x0D, 0xFF, 0xFF, 0xB7, 0x10, 0x40, 0xDF, 0xFF, 0xFA, 0x77,
  0x77, 0x40, 0x7F, 0x77, 0x77, 0x50, 0x7E, 0x77, 0x77, 0x60, 0x7D, 0x77, 0x77, 0x70, 0x7C, 0x80,
  0xC0, 0x00, 0x7B, 0x80, 0xC1, 0x00, 0x7A, 0x80, 0xC2, 0x00, 0x79, 0x80, 0xC3, 0x00, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_forum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_forum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_forward_to_inbox 48x48, 4-bit Alpha,  RLE, 241 bytes.
static const unsigned char ic_outlined_48_communication_forward_to_inbox_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x30, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x20,
  0xA8, 0x0C, 0x2F, 0x0A, 0x20, 0xD8, 0x0C, 0x2F, 0x0D, 0x2C, 0x0A, 0x01, 0x77, 0x77, 0x01, 0x0A,
  0xC2, 0xD0, 0xE0, 0x67, 0x77, 0x50, 0x60, 0xED, 0x2F, 0x0C, 0x03, 0x77, 0x71, 0x03, 0x0C, 0xF2,
  0xFA, 0x08, 0x77, 0x60, 0x8F, 0xA2, 0xC0, 0x40, 0xDC, 0x0D, 0x04, 0x77, 0x20, 0x40, 0xDC, 0x0D,
  0x04, 0xC2, 0xC2, 0x08, 0xD0, 0xA0, 0x17, 0x50, 0x10, 0xAD, 0x08, 0x2C, 0x2C, 0x30, 0x30, 0xCC,
  0x0E, 0x06, 0x73, 0x06, 0x0E, 0xC0, 0xC0, 0x33, 0xC2, 0xC5, 0x06, 0x0E, 0xC0, 0xC0, 0x36, 0x03,
  0x0C, 0xC0, 0xE0, 0x65, 0xC2, 0xC6, 0x01, 0x0A, 0xD0, 0x84, 0x08, 0xD0, 0xA0, 0x16, 0xC2, 0xC7,
  0x10, 0x40, 0xDC, 0x82, 0xD4, 0x4D, 0xC0, 0xD0, 0x47, 0x1C, 0x2C, 0x73, 0x08, 0xFB, 0x08, 0x73,
  0xC2, 0xC7, 0x40, 0x30, 0xCE, 0x0C, 0x03, 0x74, 0xC2, 0xC7, 0x60, 0x60, 0xEA, 0x0E, 0x06, 0x76,
  0xC2, 0xC7, 0x78, 0x21, 0xAA, 0x17, 0x7C, 0x2C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x80, 0xC2,
  0x0C, 0x80, 0xC2, 0x0C, 0x77, 0x77, 0x20, 0x77, 0xC7, 0x77, 0x72, 0x90, 0x76, 0xC7, 0x77, 0x72,
  0xA0, 0x75, 0xC7, 0x77, 0x72, 0xB0, 0x74, 0xC7, 0x77, 0x72, 0xC0, 0x73, 0xC7, 0x77, 0x72, 0xD0,
  0x72, 0x0D, 0xFF, 0xF4, 0xFF, 0x81, 0x70, 0xAF, 0xFF, 0x4F, 0xF9, 0x81, 0x71, 0xEF, 0xFE, 0x4F,
  0xF9, 0x83, 0x70, 0x1A, 0xDF, 0xFC, 0x4F, 0xF0, 0x77, 0x77, 0x77, 0xD0, 0x78, 0x0C, 0x00, 0xC0,
  0x78, 0x0C, 0x10, 0xB0, 0x78, 0x0C, 0x20, 0xA0, 0x78, 0x0C, 0x30, 0x90, 0x78, 0x0C, 0x40, 0x07,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_forward_to_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 45, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_forward_to_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_hourglass_bottom 48x48, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_48_communication_hourglass_bottom_data[] PROGMEM = {
  0x80, 0x9C, 0x0F, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97,
  0x72, 0xF9, 0x77, 0x2F, 0x90, 0x77, 0x70, 0x7C, 0x07, 0xC0, 0x77, 0x50, 0x7C, 0x81, 0x70, 0x7C,
  0x07, 0x73, 0x07, 0xC0, 0x73, 0x07, 0xC0, 0x77, 0x10, 0x7C, 0x07, 0x50, 0x7C, 0x07, 0x60, 0x7C,
  0x07, 0x70, 0x7C, 0x07, 0x40, 0x7C, 0x07, 0x72, 0x07, 0xC0, 0x72, 0x07, 0xC0, 0x77, 0x40, 0x7C,
  0x00, 0x7C, 0x07, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x07, 0xF9, 0x07, 0x76, 0x07, 0xFB, 0x07, 0x74,
  0x07, 0xFD, 0x07, 0x72, 0x07, 0xFF, 0x07, 0x70, 0x7F, 0xFA, 0x07, 0x50, 0x7F, 0xFC, 0x07, 0x30,
  0x7F, 0xFE, 0x81, 0x70, 0x8F, 0xFF, 0x90, 0x78, 0x0C, 0xB4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_hourglass_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 4, 35, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_hourglass_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_hourglass_top 48x48, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_48_communication_hourglass_top_data[] PROGMEM = {
  0x80, 0xCB, 0x4F, 0x07, 0xFF, 0xF9, 0x81, 0x80, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFC, 0x07, 0x50,
  0x7F, 0xFA, 0x07, 0x70, 0x7F, 0xF0, 0x77, 0x20, 0x7F, 0xD0, 0x77, 0x40, 0x7F, 0xB0, 0x77, 0x60,
  0x7F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x60, 0x7C, 0x00, 0x7C, 0x07, 0x74, 0x07, 0xC0, 0x72,
  0x07, 0xC0, 0x77, 0x20, 0x7C, 0x07, 0x40, 0x7C, 0x07, 0x70, 0x7C, 0x07, 0x60, 0x7C, 0x07, 0x50,
  0x7C, 0x07, 0x71, 0x07, 0xC0, 0x73, 0x07, 0xC0, 0x77, 0x30, 0x7C, 0x81, 0x70, 0x7C, 0x07, 0x75,
  0x07, 0xC0, 0x7C, 0x07, 0x77, 0x07, 0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x2F, 0x97, 0x72,
  0xF9, 0x77, 0x2F, 0x97, 0x72, 0xF9, 0x77, 0x28, 0x09, 0xC0, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_hourglass_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 4, 35, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_hourglass_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_hub 48x48, 4-bit Alpha,  RLE, 477 bytes.
static const unsigned char ic_outlined_48_communication_hub_data[] PROGMEM = {
  0x77, 0x78, 0x46, 0xCE, 0xEC, 0x68, 0x0C, 0x40, 0x01, 0x0C, 0xE0, 0xC0, 0x18, 0x0C, 0x20, 0x0C,
  0xF9, 0x0C, 0x80, 0xC1, 0x00, 0x6F, 0xB0, 0x68, 0x0C, 0x00, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C,
  0x80, 0xC0, 0x00, 0xEB, 0x01, 0x20, 0x1B, 0x0E, 0x80, 0xC0, 0x00, 0xEB, 0x01, 0x20, 0x1B, 0x0E,
  0x80, 0xC0, 0x00, 0xBB, 0x82, 0xB1, 0x1B, 0xB0, 0xB8, 0x0C, 0x00, 0x05, 0xFB, 0x05, 0x80, 0xC1,
  0x00, 0xCF, 0x90, 0xC8, 0x0C, 0x20, 0x01, 0x0C, 0xE0, 0xC0, 0x18, 0x0C, 0x40, 0x05, 0x0D, 0xA0,
  0xD0, 0x58, 0x0C, 0x70, 0x07, 0xA0, 0x87, 0x77, 0x48, 0x46, 0xCE, 0xEC, 0x67, 0x60, 0x7A, 0x08,
  0x76, 0x84, 0x6C, 0xEE, 0xC6, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x74, 0x07, 0xA0, 0x87, 0x40, 0x10,
  0xCE, 0x0C, 0x01, 0x20, 0xCF, 0x90, 0xC7, 0x40, 0x7A, 0x08, 0x74, 0x0C, 0xF9, 0x81, 0xC0, 0x6F,
  0xB0, 0x67, 0x18, 0x13, 0x8D, 0xA8, 0x1D, 0x93, 0x71, 0x06, 0xFB, 0x06, 0x0C, 0xB8, 0x2B, 0x11,
  0xBB, 0x0C, 0x60, 0x20, 0xBF, 0x90, 0xB0, 0x26, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x0E, 0xB0,
  0x12, 0x01, 0xB0, 0xE5, 0x03, 0x0E, 0xFB, 0x0E, 0x03, 0x50, 0xEB, 0x01, 0x20, 0x1B, 0x00, 0xEB,
  0x01, 0x20, 0x1C, 0x06, 0x01, 0x20, 0x10, 0xEF, 0xD0, 0xE0, 0x22, 0x01, 0x06, 0xC0, 0x12, 0x01,
  0xB0, 0xE0, 0xCB, 0x82, 0xB1, 0x1B, 0xE8, 0x1B, 0x6B, 0xC0, 0xA0, 0x32, 0x03, 0x0A, 0xC8, 0x1B,
  0x6B, 0xE8, 0x2B, 0x11, 0xBB, 0x0C, 0x06, 0xFF, 0xD0, 0x76, 0x07, 0xFF, 0xD8, 0x16, 0x0C, 0xF9,
  0x81, 0xC6, 0xBE, 0x0A, 0x71, 0x0A, 0xE8, 0x1B, 0x6C, 0xF9, 0x0C, 0x20, 0x10, 0xCE, 0x0C, 0x01,
  0x28, 0x11, 0x6E, 0xB0, 0x37, 0x10, 0x3B, 0x81, 0xE6, 0x12, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x84,
  0x6C, 0xEE, 0xC6, 0x60, 0xEB, 0x73, 0xB0, 0xE6, 0x84, 0x6B, 0xEE, 0xB6, 0x77, 0x40, 0xEB, 0x73,
  0xB0, 0xE7, 0x77, 0x72, 0x0C, 0xB0, 0x37, 0x10, 0x3B, 0x0C, 0x77, 0x77, 0x20, 0x9B, 0x0A, 0x71,
  0x0A, 0xB0, 0x97, 0x77, 0x72, 0x03, 0xC0, 0x76, 0x07, 0xC0, 0x37, 0x77, 0x73, 0x0B, 0xC0, 0xA0,
  0x32, 0x03, 0x0A, 0xC0, 0xB7, 0x77, 0x74, 0x02, 0x0E, 0xFD, 0x0E, 0x01, 0x77, 0x77, 0x40, 0x20,
  0xEF, 0xD0, 0xE0, 0x27, 0x77, 0x74, 0x0D, 0xFF, 0x0D, 0x01, 0x77, 0x77, 0x20, 0xAA, 0x89, 0x2E,
  0x23, 0x9C, 0xEE, 0xC9, 0x32, 0xEA, 0x0B, 0x77, 0x73, 0x84, 0x6C, 0xEE, 0xCA, 0xB0, 0x47, 0x30,
  0x5B, 0x84, 0xAC, 0xEE, 0xC6, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x87, 0x50, 0x8F, 0x90, 0xC0, 0x17,
  0x70, 0xCF, 0x90, 0xE7, 0x70, 0xEF, 0x90, 0xC7, 0x60, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67,
  0x50, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x50, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x50, 0xEB,
  0x01, 0x20, 0x1B, 0x0E, 0x75, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x50, 0xEB, 0x01, 0x20, 0x1B,
  0x0E, 0x75, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x50, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x50,
  0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x50, 0x6F, 0xB0, 0x67, 0x50, 0x6F, 0xB0, 0x67, 0x60, 0xCF,
  0x90, 0xC7, 0x70, 0xCF, 0x90, 0xC7, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x01, 0x0C, 0xE0, 0xC0,
  0x17, 0x72, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x48, 0x46, 0xCE, 0xEC, 0x67, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 47, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_import_contacts 48x48, 4-bit Alpha,  RLE, 195 bytes.
static const unsigned char ic_outlined_48_communication_import_contacts_data[] PROGMEM = {
  0x48, 0x41, 0x68, 0xBD, 0xDA, 0x84, 0xDD, 0xB8, 0x61, 0x71, 0x84, 0x16, 0x8B, 0xDD, 0xA8, 0x4D,
  0xDB, 0x85, 0x16, 0x06, 0x0B, 0xFF, 0x0B, 0x06, 0x40, 0x60, 0xBF, 0xF0, 0xC0, 0x62, 0x05, 0x0D,
  0xFF, 0xC8, 0x2D, 0x45, 0xDF, 0xFC, 0x0D, 0x04, 0x80, 0x98, 0x3F, 0x83, 0xC9, 0x53, 0x12, 0x84,
  0x12, 0x46, 0xAD, 0xFF, 0xFF, 0x81, 0xC6, 0x17, 0x6F, 0xFF, 0xD0, 0xB0, 0x37, 0x72, 0xFF, 0xFD,
  0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F,
  0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7,
  0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF,
  0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77,
  0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x58, 0x32, 0x69, 0xCD, 0xA8, 0x4D, 0xDB, 0x85, 0x1F, 0xFF,
  0xD2, 0x81, 0x38, 0xD8, 0x0C, 0x3F, 0x03, 0x0B, 0x80, 0x98, 0x1F, 0x83, 0xC8, 0x52, 0x12, 0x84,
  0x11, 0x36, 0x9D, 0xFA, 0x83, 0xC9, 0x53, 0x12, 0x84, 0x12, 0x46, 0x9E, 0xC8, 0x3D, 0xFC, 0x61,
  0x76, 0x81, 0x38, 0xEB, 0x81, 0xC6, 0x17, 0x68, 0x43, 0xAF, 0xD1, 0x27, 0x74, 0x82, 0x1A, 0xB3,
  0x77, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_import_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 9, 45, 42), Box(0, 0, 47, 47),
      ic_outlined_48_communication_import_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_import_export 48x48, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_outlined_48_communication_import_export_data[] PROGMEM = {
  0x70, 0x07, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x20, 0x7C, 0x07, 0x77, 0x70, 0x7E, 0x07, 0x77,
  0x50, 0x7F, 0x90, 0x77, 0x73, 0x07, 0xFB, 0x07, 0x77, 0x10, 0x7F, 0xD0, 0x77, 0x60, 0x8F, 0xF0,
  0x87, 0x74, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77,
  0x73, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x75,
  0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7,
  0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x40, 0x8F, 0xF0, 0x87, 0x60, 0x7F, 0xD0, 0x77,
  0x71, 0x07, 0xFB, 0x07, 0x77, 0x30, 0x7F, 0x90, 0x77, 0x75, 0x07, 0xE0, 0x77, 0x77, 0x07, 0xC0,
  0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x74, 0x00, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_import_export() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 6, 37, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_import_export_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_invert_colors_off 48x48, 4-bit Alpha,  RLE, 348 bytes.
static const unsigned char ic_outlined_48_communication_invert_colors_off_data[] PROGMEM = {
  0x77, 0x60, 0x07, 0x77, 0x60, 0x27, 0x72, 0x08, 0xA0, 0x87, 0x74, 0x81, 0x4F, 0x77, 0x70, 0x8C,
  0x08, 0x77, 0x20, 0x4B, 0x07, 0x75, 0x08, 0xE0, 0x87, 0x71, 0x0E, 0xC0, 0x77, 0x30, 0x8F, 0x90,
  0x87, 0x70, 0x30, 0xEC, 0x07, 0x71, 0x09, 0xC0, 0xED, 0x09, 0x77, 0x03, 0x0E, 0xC0, 0x76, 0x09,
  0xC0, 0xE0, 0x2E, 0x09, 0x77, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB0, 0xE0, 0x21, 0xF0, 0x97, 0x70,
  0x30, 0xEC, 0x07, 0x58, 0x2C, 0xFE, 0x22, 0xF9, 0x09, 0x77, 0x03, 0x0E, 0xC0, 0x75, 0x0A, 0x02,
  0x3F, 0xA0, 0x97, 0x70, 0x30, 0xEC, 0x07, 0x72, 0xFB, 0x0A, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x1F,
  0xC0, 0x97, 0x70, 0x30, 0xEC, 0x07, 0x7F, 0xD0, 0x77, 0x60, 0x3E, 0x07, 0x6F, 0xE0, 0x47, 0x50,
  0xDF, 0x07, 0x50, 0xCF, 0xD0, 0xC7, 0x40, 0x6C, 0x0E, 0xC0, 0x75, 0x0C, 0xFD, 0x05, 0x73, 0x0D,
  0xB8, 0x18, 0x3E, 0xC0, 0x75, 0x0C, 0xFC, 0x0D, 0x72, 0x03, 0xC8, 0x21, 0x03, 0xEC, 0x07, 0x50,
  0xCF, 0xC0, 0x27, 0x10, 0x7B, 0x0A, 0x30, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xB0, 0x77, 0x10, 0xBB,
  0x05, 0x40, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xA0, 0xB7, 0x10, 0xDB, 0x02, 0x50, 0x30, 0xEC, 0x07,
  0x50, 0xCF, 0x90, 0xC7, 0x10, 0xEB, 0x70, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0x0E, 0x71, 0xC7, 0x10,
  0x30, 0xEC, 0x07, 0x50, 0xCF, 0x71, 0x0D, 0xB0, 0x17, 0x10, 0x30, 0xEC, 0x07, 0x50, 0xCD, 0x0E,
  0x71, 0x0C, 0xB0, 0x37, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xCC, 0x0C, 0x71, 0x09, 0xB0, 0x87, 0x30,
  0x3D, 0x07, 0x50, 0xCB, 0x09, 0x71, 0x05, 0xB0, 0xD7, 0x4E, 0x07, 0x50, 0xCA, 0x05, 0x72, 0xC0,
  0x47, 0x3F, 0x07, 0x58, 0x1C, 0xF1, 0x72, 0x0A, 0xB0, 0xD7, 0x3F, 0x90, 0x75, 0x07, 0x73, 0x02,
  0xC0, 0x97, 0x2F, 0xA0, 0x77, 0x72, 0x09, 0xC0, 0x77, 0x1F, 0xB0, 0x77, 0x72, 0x0D, 0xC0, 0x97,
  0xFC, 0x07, 0x77, 0x10, 0x20, 0xEC, 0x0D, 0x05, 0x5F, 0xD0, 0x77, 0x71, 0x03, 0x0E, 0xD8, 0x2D,
  0x84, 0x21, 0xFE, 0x07, 0x77, 0x10, 0x20, 0xCF, 0xFF, 0xA0, 0x77, 0x72, 0x08, 0xFF, 0xA8, 0x17,
  0x3E, 0xC0, 0x77, 0x72, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x82, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x48,
  0x90, 0x49, 0xBD, 0xEF, 0xDC, 0x85, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x77, 0x60, 0x30, 0xEC, 0x02,
  0x77, 0x77, 0x60, 0x30, 0xEA, 0x04, 0x80, 0xC0, 0x08, 0x13, 0xE4, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_invert_colors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_communication_invert_colors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_key_off 48x48, 4-bit Alpha,  RLE, 360 bytes.
static const unsigned char ic_outlined_48_communication_key_off_data[] PROGMEM = {
  0x30, 0x28, 0x0D, 0x00, 0x81, 0x4F, 0x78, 0x0C, 0x60, 0x04, 0xB0, 0x78, 0x0C, 0x50, 0x0E, 0xC0,
  0x78, 0x0C, 0x40, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x40, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x40, 0x03,
  0x0E, 0xC0, 0x78, 0x0C, 0x40, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x40, 0x05, 0xD0, 0x78, 0x0C, 0x20,
  0x05, 0x0E, 0xE0, 0x78, 0x0C, 0x00, 0x06, 0xFA, 0x07, 0x77, 0x77, 0x60, 0x5D, 0x0D, 0x0E, 0xC0,
  0x77, 0x77, 0x74, 0x01, 0x0E, 0xB8, 0x3E, 0x70, 0x3E, 0xC0, 0x77, 0x77, 0x73, 0x09, 0xC0, 0x43,
  0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xB0, 0x75, 0x01, 0xC0, 0x65, 0x03, 0x0E, 0xC0, 0x75, 0x0C,
  0xFF, 0xB0, 0x74, 0x07, 0xB0, 0xD4, 0x81, 0x1A, 0xDE, 0x07, 0x50, 0xCF, 0xFB, 0x07, 0x30, 0xBB,
  0x06, 0x30, 0x10, 0xEF, 0xA0, 0x75, 0x0C, 0xFF, 0xB0, 0x72, 0x0D, 0xB0, 0x33, 0x0A, 0xFC, 0x07,
  0x77, 0x30, 0x30, 0xEC, 0x81, 0x70, 0xEB, 0x01, 0x30, 0xDF, 0x0E, 0xC0, 0x77, 0x73, 0x03, 0x0E,
  0xC0, 0x70, 0xEB, 0x40, 0xDE, 0x81, 0xD3, 0xEC, 0x07, 0x77, 0x20, 0x30, 0xEC, 0x07, 0x0D, 0xB0,
  0x23, 0x0A, 0xE8, 0x2A, 0x03, 0xEC, 0x07, 0x71, 0x00, 0x94, 0x03, 0x0E, 0xC8, 0x17, 0x0B, 0xB0,
  0x63, 0x01, 0x0E, 0xC0, 0xE0, 0x12, 0x03, 0x0E, 0xC0, 0x75, 0x02, 0x0C, 0xA8, 0x3C, 0x20, 0x3E,
  0xC0, 0x72, 0x06, 0xB0, 0xC4, 0x84, 0x1A, 0xDD, 0xA1, 0x40, 0xDD, 0x07, 0x50, 0xCB, 0x81, 0xE7,
  0xEC, 0x07, 0x30, 0x1C, 0x06, 0x75, 0x07, 0xF0, 0x75, 0x0C, 0xF9, 0x07, 0x50, 0x9C, 0x04, 0x73,
  0x04, 0x0E, 0xF9, 0x07, 0x50, 0xCE, 0x07, 0x60, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC8, 0x1E, 0x5E,
  0xC0, 0x75, 0x0C, 0xC0, 0x77, 0x10, 0x4D, 0x86, 0xC6, 0x20, 0x13, 0x6D, 0xD8, 0x25, 0x03, 0xEC,
  0x07, 0x40, 0x10, 0xCA, 0x07, 0x73, 0x06, 0xFF, 0xA0, 0x63, 0x03, 0x0E, 0xC0, 0x75, 0x09, 0x07,
  0x75, 0x04, 0x0E, 0xFD, 0x0E, 0x05, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x50, 0x10, 0x9F, 0xB0, 0x90,
  0x17, 0x03, 0x0E, 0xC0, 0x77, 0x76, 0x89, 0x01, 0x6A, 0xDE, 0xFD, 0xA7, 0x17, 0x30, 0x30, 0xEC,
  0x07, 0x80, 0xC4, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC4, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC4, 0x00,
  0x30, 0xEC, 0x07, 0x80, 0xC4, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC4, 0x00, 0x30, 0xEC, 0x07, 0x80,
  0xC4, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC4, 0x00, 0x30, 0xEB, 0x0E, 0x02, 0x80, 0xC4, 0x08, 0x33,
  0xEF, 0xE4, 0x80, 0xC6, 0x08, 0x13, 0xE4, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 47, 44), Box(0, 0, 47, 47),
      ic_outlined_48_communication_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_key 48x48, 4-bit Alpha,  RLE, 196 bytes.
static const unsigned char ic_outlined_48_communication_key_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEF, 0xDA, 0x71, 0x77, 0x77, 0x40, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0x77,
  0x71, 0x04, 0x0E, 0xFD, 0x0E, 0x05, 0x77, 0x76, 0x06, 0xFF, 0xA0, 0x67, 0x77, 0x40, 0x4F, 0xFC,
  0x05, 0x77, 0x72, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x17, 0x77, 0x10, 0x9F, 0x08, 0x03, 0x20, 0x30,
  0x8F, 0x09, 0x77, 0x70, 0x1E, 0x0D, 0x03, 0x60, 0x30, 0xDE, 0x01, 0x77, 0x60, 0x6E, 0x03, 0x71,
  0x03, 0xFF, 0xFA, 0x07, 0x30, 0xBD, 0x08, 0x73, 0x08, 0xFF, 0xFA, 0x08, 0x20, 0xDD, 0x03, 0x73,
  0x03, 0xFF, 0xFB, 0x81, 0x80, 0xED, 0x75, 0xFF, 0xFC, 0x08, 0x0E, 0xD7, 0x5F, 0xFF, 0xC0, 0x60,
  0xDD, 0x03, 0x73, 0x03, 0xFF, 0xFB, 0x81, 0x60, 0xBD, 0x08, 0x73, 0x08, 0xFF, 0xFA, 0x06, 0x20,
  0x6E, 0x03, 0x71, 0x03, 0xFF, 0xFA, 0x07, 0x30, 0x1E, 0x0D, 0x03, 0x60, 0x30, 0xDE, 0x01, 0x07,
  0xE0, 0x07, 0xE0, 0x75, 0x09, 0xF0, 0x80, 0x32, 0x03, 0x08, 0xF0, 0x92, 0x07, 0xC0, 0x72, 0x07,
  0xC0, 0x76, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x13, 0x07, 0xA0, 0x74, 0x07, 0xA0, 0x77, 0x10, 0x4F,
  0xFC, 0x05, 0x50, 0x07, 0x60, 0x07, 0x73, 0x06, 0xFF, 0xA0, 0x67, 0x77, 0x60, 0x40, 0xEF, 0xD0,
  0xE0, 0x57, 0x77, 0x71, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x77, 0x77, 0x48, 0x90, 0x16, 0xAD, 0xEF,
  0xDA, 0x71, 0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 12, 45, 35), Box(0, 0, 47, 47),
      ic_outlined_48_communication_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_list_alt 48x48, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_outlined_48_communication_list_alt_data[] PROGMEM = {
  0x05, 0x0E, 0xFF, 0xFF, 0xC8, 0x1E, 0x5E, 0xFF, 0xFF, 0xE0, 0xE8, 0x09, 0x90, 0xF7, 0x77, 0x7F,
  0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x94, 0xC4, 0xFD, 0x4F, 0x94, 0xC4, 0xFD,
  0x4F, 0x94, 0xC4, 0xFD, 0x4F, 0x94, 0xC4, 0xFD, 0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97,
  0x77, 0x7F, 0x97, 0x77, 0x7F, 0x94, 0xC4, 0xFD, 0x4F, 0x94, 0xC4, 0xFD, 0x4F, 0x94, 0xC4, 0xFD,
  0x4F, 0x94, 0xC4, 0xFD, 0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77,
  0x7F, 0x94, 0xC4, 0xFD, 0x4F, 0x94, 0xC4, 0xFD, 0x4F, 0x94, 0xC4, 0xFD, 0x4F, 0x94, 0xC4, 0xFD,
  0x4F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x77, 0x78, 0x09, 0x90, 0xF0,
  0xEF, 0xFF, 0xFE, 0x81, 0xE5, 0xEF, 0xFF, 0xFC, 0x0E, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_list_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_list_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_live_help 48x48, 4-bit Alpha,  RLE, 235 bytes.
static const unsigned char ic_outlined_48_communication_live_help_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0xC7, 0x77, 0x7F, 0x97, 0x77, 0x7F, 0x97, 0x38, 0x62, 0x8C,
  0xEE, 0xC8, 0x27, 0x3F, 0x97, 0x20, 0x9F, 0x90, 0x97, 0x2F, 0x97, 0x10, 0xBF, 0xB0, 0xB7, 0x1F,
  0x97, 0x09, 0xFD, 0x09, 0x7F, 0x96, 0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02, 0x6F, 0x96, 0x08,
  0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x86, 0xF9, 0x60, 0xCB, 0x05, 0x60, 0x5B, 0x0C, 0x6F, 0x96,
  0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE6, 0xF9, 0x77, 0x30, 0x1B, 0x0E, 0x6F, 0x97, 0x73, 0x06, 0xB0,
  0xB6, 0xF9, 0x77, 0x20, 0x30, 0xEB, 0x05, 0x6F, 0x97, 0x71, 0x05, 0xC0, 0xA7, 0xF9, 0x77, 0x07,
  0xC0, 0xB7, 0x1F, 0x97, 0x60, 0x7C, 0x09, 0x72, 0xF9, 0x75, 0x02, 0xC0, 0x97, 0x3F, 0x97, 0x50,
  0x9B, 0x0C, 0x74, 0xF9, 0x75, 0x0D, 0xB0, 0x47, 0x4F, 0x97, 0x5C, 0x01, 0x74, 0xF9, 0x77, 0x77,
  0xF9, 0x77, 0x77, 0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x5C, 0x75, 0xF9, 0x75, 0xC7, 0x5F, 0x97, 0x5C,
  0x75, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xC0, 0xDF, 0xD0, 0xE0, 0x36, 0x03, 0x0E, 0xFD, 0x0D,
  0x0A, 0xFE, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xE8, 0x1A, 0x1E, 0xFE, 0x0E, 0x03, 0x20, 0x30, 0xEF,
  0xE8, 0x4E, 0x10, 0x1A, 0xDF, 0xD8, 0x2E, 0x33, 0xEF, 0xD8, 0x1D, 0xA1, 0x76, 0x07, 0xC0, 0x0E,
  0xC0, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x77, 0x60, 0x7E, 0x07, 0x77, 0x77, 0x10, 0x7C, 0x07,
  0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x77, 0x50, 0x07, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_live_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_live_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_location_off 48x48, 4-bit Alpha,  RLE, 374 bytes.
static const unsigned char ic_outlined_48_communication_location_off_data[] PROGMEM = {
  0x77, 0x18, 0x90, 0x37, 0xBD, 0xEE, 0xDB, 0x73, 0x77, 0x01, 0x73, 0x05, 0x0C, 0xFB, 0x0D, 0x05,
  0x74, 0x81, 0x1D, 0x97, 0x01, 0x0C, 0xFF, 0x0C, 0x02, 0x71, 0x01, 0x0D, 0xA0, 0x95, 0x03, 0x0E,
  0xFF, 0xA0, 0xE0, 0x37, 0x0B, 0xC0, 0x95, 0x0A, 0xC8, 0x1A, 0x52, 0x28, 0x12, 0x5A, 0xE0, 0x36,
  0x02, 0x0D, 0xC0, 0x95, 0x82, 0xAF, 0xB2, 0x71, 0x02, 0x0A, 0xC0, 0xE0, 0x26, 0x02, 0x0D, 0xC0,
  0x95, 0x05, 0x75, 0x07, 0xC0, 0xC7, 0x02, 0x0D, 0xC0, 0x97, 0x74, 0x07, 0xC0, 0x57, 0x02, 0x0D,
  0xC0, 0x97, 0x74, 0x0A, 0xB0, 0xD7, 0x10, 0x20, 0xDC, 0x09, 0x68, 0x43, 0xBE, 0xEB, 0x45, 0x02,
  0xC0, 0x37, 0x10, 0x20, 0xDC, 0x09, 0x50, 0xBD, 0x08, 0x50, 0xAB, 0x07, 0x72, 0x0B, 0xD0, 0x95,
  0x0B, 0xD0, 0x44, 0x05, 0xB0, 0xB7, 0x20, 0xDE, 0x09, 0x50, 0xBC, 0x0B, 0x40, 0x2B, 0x0D, 0x72,
  0xF9, 0x09, 0x50, 0xBB, 0x0E, 0x5B, 0x0E, 0x72, 0x0E, 0xB0, 0xEC, 0x09, 0x50, 0xBA, 0x0E, 0x5B,
  0x0E, 0x72, 0x0D, 0xB0, 0x50, 0xDC, 0x09, 0x58, 0x1B, 0xFB, 0x40, 0x2B, 0x0D, 0x72, 0x0B, 0xB8,
  0x15, 0x2D, 0xC0, 0x95, 0x0A, 0x03, 0x40, 0x5B, 0x0B, 0x72, 0x08, 0xB8, 0x29, 0x02, 0xDC, 0x09,
  0x73, 0x08, 0xB0, 0x77, 0x20, 0x4B, 0x0E, 0x20, 0x20, 0xDC, 0x09, 0x72, 0x0D, 0xB0, 0x47, 0x30,
  0xEB, 0x04, 0x20, 0x20, 0xDC, 0x09, 0x70, 0x4B, 0x0E, 0x74, 0x09, 0xB0, 0xB3, 0x02, 0x0D, 0xC0,
  0x96, 0x0A, 0xB0, 0x97, 0x40, 0x3C, 0x02, 0x30, 0x20, 0xDC, 0x09, 0x50, 0xAB, 0x03, 0x75, 0x0C,
  0xB0, 0xA4, 0x02, 0x0D, 0xC0, 0x95, 0x81, 0xBF, 0xB7, 0x60, 0x4C, 0x03, 0x40, 0x20, 0xDC, 0x09,
  0x50, 0xB0, 0x47, 0x70, 0xCB, 0x0B, 0x50, 0x20, 0xDC, 0x09, 0x77, 0x60, 0x4C, 0x05, 0x50, 0x20,
  0xDC, 0x09, 0x77, 0x60, 0xBB, 0x0E, 0x01, 0x50, 0x20, 0xDC, 0x09, 0x77, 0x50, 0x2C, 0x09, 0x60,
  0x20, 0xDC, 0x09, 0x77, 0x50, 0x8C, 0x03, 0x60, 0x5D, 0x09, 0x77, 0x50, 0xDB, 0x0D, 0x60, 0xDE,
  0x09, 0x77, 0x40, 0x4C, 0x09, 0x40, 0x8F, 0x90, 0x97, 0x74, 0x09, 0xC0, 0x52, 0x04, 0xC0, 0xA0,
  0xDC, 0x09, 0x77, 0x40, 0xDB, 0x82, 0xE2, 0x1E, 0xB8, 0x2D, 0x02, 0xDC, 0x09, 0x77, 0x30, 0x3C,
  0x00, 0xCC, 0x03, 0x20, 0x20, 0xDC, 0x09, 0x77, 0x30, 0x7F, 0x90, 0x74, 0x02, 0x0D, 0xC0, 0x97,
  0x73, 0x0A, 0xE0, 0xA6, 0x02, 0x0D, 0xB0, 0xD0, 0x17, 0x72, 0x01, 0x0D, 0xC0, 0xD0, 0x17, 0x83,
  0x2D, 0xFD, 0x17, 0x74, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x28, 0x12, 0xB1, 0x77, 0x60, 0x4A, 0x04,
  0x77, 0x77, 0x60, 0x06, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_location_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 40, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_location_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_location_on 48x48, 4-bit Alpha,  RLE, 283 bytes.
static const unsigned char ic_outlined_48_communication_location_on_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDE, 0xED, 0xB7, 0x37, 0x72, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x75, 0x02,
  0x0C, 0xFF, 0x0C, 0x02, 0x72, 0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x37, 0x03, 0xE8, 0x1A, 0x52, 0x28,
  0x12, 0x5A, 0xE0, 0x35, 0x02, 0x0E, 0xC0, 0xA0, 0x27, 0x10, 0x20, 0xAC, 0x0E, 0x02, 0x40, 0xCC,
  0x07, 0x75, 0x07, 0xC0, 0xC3, 0x05, 0xC0, 0x77, 0x70, 0x7C, 0x05, 0x20, 0xDB, 0x0A, 0x77, 0x20,
  0xAB, 0x81, 0xD0, 0x3C, 0x02, 0x58, 0x44, 0xBE, 0xEB, 0x45, 0x02, 0xC0, 0x30, 0x7B, 0x0A, 0x50,
  0x8E, 0x08, 0x50, 0xAB, 0x07, 0x0B, 0xB0, 0x54, 0x04, 0xF9, 0x04, 0x40, 0x5B, 0x0B, 0x0D, 0xB0,
  0x24, 0x0B, 0xF9, 0x0B, 0x40, 0x2B, 0x0D, 0x0E, 0xB5, 0x0E, 0xF9, 0x0E, 0x5B, 0x00, 0xEB, 0x50,
  0xEF, 0x90, 0xE5, 0xB0, 0xE0, 0xDB, 0x02, 0x40, 0xBF, 0x90, 0xB4, 0x02, 0xB0, 0xD0, 0xBB, 0x05,
  0x40, 0x4F, 0x90, 0x44, 0x05, 0xB0, 0xB0, 0x8B, 0x09, 0x50, 0x8E, 0x08, 0x50, 0x9B, 0x08, 0x04,
  0xB0, 0xD6, 0x84, 0x4B, 0xEE, 0xB4, 0x60, 0xDB, 0x81, 0x40, 0xEB, 0x04, 0x77, 0x20, 0x4B, 0x0E,
  0x20, 0x9B, 0x0B, 0x77, 0x20, 0xAB, 0x09, 0x20, 0x3C, 0x02, 0x77, 0x02, 0xC0, 0x33, 0x0C, 0xB0,
  0xA7, 0x70, 0x9B, 0x0C, 0x40, 0x4C, 0x02, 0x75, 0x02, 0xC0, 0x45, 0x0C, 0xB0, 0xB7, 0x50, 0xAB,
  0x0C, 0x60, 0x4C, 0x05, 0x73, 0x04, 0xC0, 0x47, 0x0B, 0xB0, 0xE0, 0x17, 0x20, 0xDB, 0x0B, 0x71,
  0x02, 0xC0, 0x97, 0x10, 0x8C, 0x02, 0x72, 0x08, 0xC0, 0x36, 0x03, 0xC0, 0x87, 0x40, 0xDB, 0x0D,
  0x60, 0xCB, 0x0D, 0x75, 0x04, 0xC0, 0x94, 0x08, 0xC0, 0x47, 0x60, 0x9C, 0x05, 0x20, 0x4C, 0x09,
  0x77, 0x10, 0xDB, 0x82, 0xE2, 0x1E, 0xB0, 0xD7, 0x72, 0x03, 0xC0, 0x0C, 0xC0, 0x37, 0x73, 0x07,
  0xF9, 0x07, 0x77, 0x50, 0xAE, 0x0A, 0x77, 0x60, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x70, 0x20, 0xEA,
  0x0E, 0x02, 0x77, 0x72, 0x04, 0xA0, 0x47, 0x77, 0x40, 0x06, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_location_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_location_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mail_lock 48x48, 4-bit Alpha,  RLE, 238 bytes.
static const unsigned char ic_outlined_48_communication_mail_lock_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x50, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x40,
  0x98, 0x0C, 0x2F, 0x0A, 0x40, 0xD8, 0x0C, 0x2F, 0x0D, 0x4C, 0x0A, 0x01, 0x77, 0x77, 0x01, 0x0A,
  0xC4, 0xD0, 0xE0, 0x67, 0x77, 0x50, 0x60, 0xED, 0x4F, 0x0C, 0x03, 0x77, 0x71, 0x03, 0x0C, 0xF4,
  0xFA, 0x08, 0x77, 0x60, 0x8F, 0xA4, 0xC0, 0x40, 0xDC, 0x0D, 0x04, 0x77, 0x20, 0x40, 0xDC, 0x0D,
  0x04, 0xC4, 0xC2, 0x08, 0xD0, 0xA0, 0x17, 0x50, 0x10, 0xAD, 0x08, 0x2C, 0x4C, 0x30, 0x30, 0xCC,
  0x0E, 0x06, 0x73, 0x06, 0x0E, 0xC0, 0xC0, 0x33, 0xC4, 0xC5, 0x06, 0x0E, 0xC0, 0xC0, 0x36, 0x03,
  0x0C, 0xC0, 0xE0, 0x65, 0xC4, 0xC6, 0x01, 0x0A, 0xD0, 0x84, 0x08, 0xD0, 0xA0, 0x17, 0x7C, 0x71,
  0x04, 0x0D, 0xC8, 0x2D, 0x44, 0xDC, 0x0D, 0x04, 0x77, 0x2C, 0x73, 0x08, 0xFB, 0x08, 0x77, 0x4C,
  0x74, 0x03, 0x0C, 0xE0, 0xC0, 0x37, 0x75, 0xC7, 0x60, 0x60, 0xEA, 0x0E, 0x06, 0x75, 0x84, 0x1A,
  0xDD, 0xA1, 0x3C, 0x77, 0x82, 0x1A, 0xA1, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x12, 0xC7, 0x77, 0x72,
  0x86, 0xAF, 0xB1, 0x1B, 0xFA, 0x2C, 0x77, 0x77, 0x28, 0x1D, 0xF1, 0x28, 0x11, 0xFD, 0x2C, 0x77,
  0x77, 0x2A, 0x4A, 0x2C, 0x77, 0x77, 0x2A, 0x4A, 0x2C, 0x77, 0x77, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
  0xC7, 0x77, 0x70, 0xDF, 0xB0, 0xDC, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF,
  0xA7, 0x77, 0x7F, 0xD0, 0xDF, 0xFF, 0xE4, 0xFD, 0x0A, 0xFF, 0xFE, 0x4F, 0xD0, 0x10, 0xEF, 0xFF,
  0xD4, 0x0D, 0xFB, 0x83, 0xD0, 0x1A, 0xDF, 0xFF, 0xB4, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mail_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 47, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mail_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mail_outline 48x48, 4-bit Alpha,  RLE, 199 bytes.
static const unsigned char ic_outlined_48_communication_mail_outline_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x0A, 0x01, 0x77, 0x77, 0x01, 0x0A, 0xFA, 0x0E, 0x06,
  0x77, 0x75, 0x06, 0x0E, 0xFD, 0x0C, 0x03, 0x77, 0x71, 0x03, 0x0C, 0xFF, 0xA0, 0x87, 0x76, 0x08,
  0xFE, 0x04, 0x0D, 0xC0, 0xD0, 0x47, 0x72, 0x04, 0x0D, 0xC0, 0xD0, 0x4F, 0x92, 0x08, 0xD0, 0xA0,
  0x17, 0x50, 0x10, 0xAD, 0x08, 0x2F, 0x93, 0x03, 0x0C, 0xC0, 0xE0, 0x67, 0x30, 0x60, 0xEC, 0x0C,
  0x03, 0x3F, 0x95, 0x06, 0x0E, 0xC0, 0xC0, 0x36, 0x03, 0x0C, 0xC0, 0xE0, 0x65, 0xF9, 0x60, 0x10,
  0xAD, 0x08, 0x40, 0x8D, 0x0A, 0x01, 0x6F, 0x97, 0x10, 0x40, 0xDC, 0x82, 0xD4, 0x4D, 0xC0, 0xD0,
  0x47, 0x1F, 0x97, 0x30, 0x8F, 0xB0, 0x87, 0x3F, 0x97, 0x40, 0x30, 0xCE, 0x0C, 0x03, 0x74, 0xF9,
  0x76, 0x06, 0x0E, 0xA0, 0xE0, 0x67, 0x6F, 0x97, 0x78, 0x21, 0xAA, 0x17, 0x7F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C,
  0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mail_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mail_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mail 48x48, 4-bit Alpha,  RLE, 199 bytes.
static const unsigned char ic_outlined_48_communication_mail_data[] PROGMEM = {
  0x18, 0x12, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA2, 0x02, 0xE8, 0x0C, 0x0F, 0x81, 0xE2, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0E, 0x80, 0xC2, 0xF0, 0xEC, 0x0A, 0x01, 0x77, 0x77, 0x01, 0x0A, 0xFA, 0x0E, 0x06,
  0x77, 0x75, 0x06, 0x0E, 0xFD, 0x0C, 0x03, 0x77, 0x71, 0x03, 0x0C, 0xFF, 0xA0, 0x87, 0x76, 0x08,
  0xFE, 0x04, 0x0D, 0xC0, 0xD0, 0x47, 0x72, 0x04, 0x0D, 0xC0, 0xD0, 0x4F, 0x92, 0x08, 0xD0, 0xA0,
  0x17, 0x50, 0x10, 0xAD, 0x08, 0x2F, 0x93, 0x03, 0x0C, 0xC0, 0xE0, 0x67, 0x30, 0x60, 0xEC, 0x0C,
  0x03, 0x3F, 0x95, 0x06, 0x0E, 0xC0, 0xC0, 0x36, 0x03, 0x0C, 0xC0, 0xE0, 0x65, 0xF9, 0x60, 0x10,
  0xAD, 0x08, 0x40, 0x8D, 0x0A, 0x01, 0x6F, 0x97, 0x10, 0x40, 0xDC, 0x82, 0xD4, 0x4D, 0xC0, 0xD0,
  0x47, 0x1F, 0x97, 0x30, 0x8F, 0xB0, 0x87, 0x3F, 0x97, 0x40, 0x30, 0xCE, 0x0C, 0x03, 0x74, 0xF9,
  0x76, 0x06, 0x0E, 0xA0, 0xE0, 0x67, 0x6F, 0x97, 0x78, 0x21, 0xAA, 0x17, 0x7F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77,
  0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C,
  0x0E, 0x80, 0xC2, 0xF0, 0xE0, 0xA8, 0x0C, 0x2F, 0x81, 0xA2, 0xE8, 0x0C, 0x0F, 0x84, 0xE2, 0x02,
  0xAE, 0xFF, 0xFF, 0xC8, 0x1E, 0xA2, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mark_chat_read 48x48, 4-bit Alpha,  RLE, 214 bytes.
static const unsigned char ic_outlined_48_communication_mark_chat_read_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x30, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x20,
  0xA8, 0x0C, 0x2F, 0x0A, 0x20, 0xD8, 0x0C, 0x2F, 0x0D, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77,
  0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77,
  0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77,
  0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77, 0x4C, 0x2C, 0x77, 0x77,
  0x4C, 0x2C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x77, 0x77,
  0x60, 0x70, 0xB2, 0xC7, 0x77, 0x75, 0x07, 0xA0, 0xB1, 0xC7, 0x77, 0x74, 0x07, 0xC0, 0xBC, 0x77,
  0x77, 0x30, 0x7C, 0x0E, 0x03, 0xC7, 0x77, 0x81, 0x1A, 0x16, 0x07, 0xC0, 0xE0, 0x31, 0xC7, 0x76,
  0x83, 0x1D, 0xFC, 0x14, 0x07, 0xC0, 0xE0, 0x32, 0xFF, 0xE3, 0x01, 0x0D, 0xB0, 0xC0, 0x12, 0x07,
  0xC0, 0xE0, 0x33, 0xFF, 0xE4, 0x0B, 0xC8, 0x1C, 0x17, 0xC0, 0xE0, 0x34, 0xFF, 0xE5, 0x0B, 0xC0,
  0xDC, 0x0E, 0x03, 0x5F, 0xFE, 0x60, 0xBF, 0x0E, 0x03, 0x6F, 0x07, 0x77, 0x50, 0xBD, 0x0E, 0x03,
  0x7E, 0x07, 0x77, 0x70, 0xBB, 0x0E, 0x03, 0x71, 0xD0, 0x77, 0x77, 0x28, 0x2B, 0xFE, 0x37, 0x2C,
  0x07, 0x77, 0x74, 0x0B, 0x03, 0x73, 0xB0, 0x78, 0x0C, 0x20, 0xA0, 0x78, 0x0C, 0x30, 0x90, 0x78,
  0x0C, 0x40, 0x07, 0x80, 0xC5, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mark_chat_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mark_chat_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mark_chat_unread 48x48, 4-bit Alpha,  RLE, 200 bytes.
static const unsigned char ic_outlined_48_communication_mark_chat_unread_data[] PROGMEM = {
  0x77, 0x77, 0x38, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x72,
  0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x6F, 0xB8, 0x36, 0x01, 0xAD, 0xFF, 0xE0, 0x23, 0x0C, 0xFB,
  0x81, 0xC1, 0xEF, 0xFF, 0x94, 0x0E, 0xFB, 0x0E, 0x0A, 0xFF, 0xFA, 0x40, 0xEF, 0xB0, 0xE0, 0xDF,
  0xFF, 0xA0, 0x23, 0x0C, 0xFB, 0x0C, 0xC7, 0x77, 0x30, 0x6F, 0xB0, 0x6C, 0x77, 0x74, 0x0C, 0xF9,
  0x0C, 0x1C, 0x77, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x11, 0xC7, 0x77, 0x68, 0x46, 0xCE, 0xEC, 0x63,
  0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC7, 0x77, 0x76, 0x02, 0x0B, 0xC7, 0x77, 0x74, 0x05, 0x0A,
  0xE7, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77,
  0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9,
  0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x48, 0x0C, 0x7F, 0x0D, 0x80, 0xC3, 0xF0, 0xA8, 0x0C,
  0x2F, 0x0E, 0x01, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77, 0x4E, 0x07, 0x77, 0x77,
  0x5D, 0x07, 0x77, 0x77, 0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0, 0x0A, 0x07, 0x80, 0xC1,
  0x09, 0x07, 0x80, 0xC2, 0x00, 0x78, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mark_chat_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mark_chat_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mark_email_read 48x48, 4-bit Alpha,  RLE, 267 bytes.
static const unsigned char ic_outlined_48_communication_mark_email_read_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x30, 0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x20,
  0x98, 0x0C, 0x2F, 0x0A, 0x20, 0xD8, 0x0C, 0x2F, 0x0D, 0x2C, 0x0A, 0x01, 0x77, 0x77, 0x01, 0x0A,
  0xC2, 0xD0, 0xE0, 0x67, 0x77, 0x50, 0x60, 0xED, 0x2F, 0x0C, 0x03, 0x77, 0x71, 0x03, 0x0C, 0xF2,
  0xFA, 0x08, 0x77, 0x60, 0x8F, 0xA2, 0xC0, 0x40, 0xDC, 0x0D, 0x04, 0x77, 0x20, 0x40, 0xDC, 0x0D,
  0x04, 0xC2, 0xC2, 0x08, 0xD0, 0xA0, 0x17, 0x50, 0x10, 0xAD, 0x08, 0x2C, 0x2C, 0x30, 0x30, 0xCC,
  0x0E, 0x06, 0x73, 0x06, 0x0E, 0xC0, 0xC0, 0x33, 0xC2, 0xC5, 0x06, 0x0E, 0xC0, 0xC0, 0x36, 0x03,
  0x0C, 0xC0, 0xE0, 0x65, 0xC2, 0xC6, 0x01, 0x0A, 0xD0, 0x84, 0x08, 0xD0, 0xA0, 0x16, 0xC2, 0xC7,
  0x10, 0x40, 0xDC, 0x82, 0xD4, 0x4D, 0xC0, 0xD0, 0x47, 0x1C, 0x2C, 0x73, 0x08, 0xFB, 0x08, 0x73,
  0xC2, 0xC7, 0x40, 0x30, 0xCE, 0x0C, 0x03, 0x74, 0xC2, 0xC7, 0x60, 0x60, 0xEA, 0x0E, 0x06, 0x76,
  0xC2, 0xC7, 0x78, 0x21, 0xAA, 0x17, 0x7C, 0x2C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x80, 0xC2,
  0x0C, 0x80, 0xC2, 0x0C, 0x77, 0x77, 0x60, 0x70, 0xB2, 0xC7, 0x77, 0x75, 0x07, 0xA0, 0xB1, 0xC7,
  0x77, 0x74, 0x07, 0xC0, 0xBC, 0x77, 0x77, 0x30, 0x7C, 0x0E, 0x03, 0xC7, 0x77, 0x01, 0x09, 0x70,
  0x7C, 0x0E, 0x03, 0x1C, 0x77, 0x68, 0x21, 0xDF, 0xB5, 0x07, 0xC0, 0xE0, 0x32, 0x0D, 0xFF, 0xD3,
  0x01, 0x0D, 0xB0, 0xB3, 0x07, 0xC0, 0xE0, 0x33, 0x0A, 0xFF, 0xD4, 0x0B, 0xC8, 0x1B, 0x07, 0xC0,
  0xE0, 0x34, 0x01, 0x0E, 0xFF, 0xC5, 0x0B, 0xC0, 0xDC, 0x0E, 0x03, 0x68, 0x11, 0xAD, 0xFF, 0xA6,
  0x0B, 0xF0, 0xE0, 0x37, 0x77, 0x75, 0x0B, 0xD0, 0xE0, 0x37, 0x77, 0x77, 0x0B, 0xB0, 0xE0, 0x38,
  0x0C, 0x10, 0x82, 0xBF, 0xE3, 0x80, 0xC3, 0x00, 0xB0, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mark_email_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mark_email_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mark_email_unread 48x48, 4-bit Alpha,  RLE, 233 bytes.
static const unsigned char ic_outlined_48_communication_mark_email_unread_data[] PROGMEM = {
  0x77, 0x77, 0x38, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x72,
  0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x6F, 0xB8, 0x36, 0x01, 0xAD, 0xFF, 0xE0, 0x23, 0x0C, 0xFB,
  0x81, 0xC1, 0xEF, 0xFF, 0x94, 0x0E, 0xFB, 0x0E, 0x09, 0xFF, 0xFA, 0x40, 0xEF, 0xB0, 0xE0, 0xDF,
  0xFF, 0xA0, 0x23, 0x0C, 0xFB, 0x0C, 0xC0, 0xA0, 0x17, 0x77, 0x10, 0x6F, 0xB0, 0x6D, 0x0E, 0x06,
  0x77, 0x71, 0x0C, 0xF9, 0x0C, 0x1F, 0x0C, 0x03, 0x77, 0x60, 0x10, 0xCE, 0x0C, 0x01, 0x1F, 0xA0,
  0x87, 0x77, 0x84, 0x6C, 0xEE, 0xC6, 0x3C, 0x04, 0x0D, 0xC0, 0xD0, 0x47, 0x77, 0x7C, 0x20, 0x8D,
  0x0A, 0x01, 0x75, 0x01, 0x05, 0x75, 0xC3, 0x03, 0x0C, 0xC0, 0xE0, 0x67, 0x38, 0x36, 0xEF, 0xB2,
  0x71, 0x02, 0x0B, 0xC5, 0x06, 0x0E, 0xC0, 0xC0, 0x36, 0x03, 0x0C, 0xC0, 0xE0, 0x35, 0x05, 0x0A,
  0xE6, 0x01, 0x0A, 0xD0, 0x84, 0x08, 0xD0, 0xA0, 0x16, 0xF9, 0x71, 0x04, 0x0D, 0xC8, 0x2D, 0x44,
  0xDC, 0x0D, 0x04, 0x71, 0xF9, 0x73, 0x08, 0xFB, 0x08, 0x73, 0xF9, 0x74, 0x03, 0x0C, 0xE0, 0xC0,
  0x37, 0x4F, 0x97, 0x60, 0x60, 0xEA, 0x0E, 0x06, 0x76, 0xF9, 0x77, 0x82, 0x1A, 0xA1, 0x77, 0xF9,
  0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8,
  0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mark_email_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mark_email_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mark_unread_chat_alt 48x48, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_outlined_48_communication_mark_unread_chat_alt_data[] PROGMEM = {
  0x77, 0x77, 0x38, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x72,
  0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x6F, 0xB8, 0x36, 0x01, 0xAD, 0xFF, 0xE0, 0x23, 0x0C, 0xFB,
  0x81, 0xC1, 0xEF, 0xFF, 0x94, 0x0E, 0xFB, 0x0E, 0x0A, 0xFF, 0xFA, 0x40, 0xEF, 0xB0, 0xE0, 0xDF,
  0xFF, 0xA0, 0x13, 0x0C, 0xFB, 0x0C, 0xC7, 0x77, 0x30, 0x6F, 0xB0, 0x6C, 0x77, 0x74, 0x0C, 0xF9,
  0x0C, 0x1C, 0x77, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x11, 0xC7, 0x77, 0x68, 0x46, 0xCE, 0xEC, 0x63,
  0xC4, 0xFF, 0xC0, 0x77, 0x6C, 0x4F, 0xFD, 0x07, 0x75, 0xC4, 0xFF, 0xE0, 0xB0, 0x27, 0x10, 0x20,
  0xBC, 0x4F, 0xFF, 0x90, 0xA0, 0x54, 0x05, 0x0A, 0xE7, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x94,
  0xFF, 0xFB, 0x4F, 0x94, 0xFF, 0xFB, 0x4F, 0x94, 0xFF, 0xFB, 0x4F, 0x94, 0xFF, 0xFB, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x94, 0xFF, 0xA7, 0x5F, 0x94, 0xFF, 0xA7, 0x5F, 0x94, 0xFF,
  0xA7, 0x5F, 0x94, 0xFF, 0xA7, 0x5F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x48, 0x0C, 0x7F, 0x0D, 0x80, 0xC3, 0xF0, 0xA8, 0x0C, 0x2F, 0x0E, 0x01, 0x80,
  0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77, 0x4E, 0x07, 0x77, 0x77, 0x5D, 0x07, 0x77, 0x77,
  0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0, 0x0A, 0x07, 0x80, 0xC1, 0x09, 0x07, 0x80, 0xC2,
  0x00, 0x78, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mark_unread_chat_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mark_unread_chat_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_message 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_outlined_48_communication_message_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4,
  0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9,
  0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F, 0xFF, 0xB4, 0xF9, 0x4F,
  0xFF, 0xB4, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x10, 0x30, 0xEF, 0xFF, 0xFC, 0x0D, 0xC0, 0x30, 0xEF, 0xFF, 0xFD, 0x0A, 0xC0, 0xEF, 0xFF,
  0xFD, 0x0E, 0x01, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x1F, 0x07, 0x77, 0x77, 0x4E, 0x07, 0x77, 0x77,
  0x5D, 0x07, 0x77, 0x77, 0x6C, 0x07, 0x77, 0x77, 0x7B, 0x07, 0x80, 0xC0, 0x0A, 0x07, 0x80, 0xC1,
  0x09, 0x07, 0x80, 0xC2, 0x00, 0x78, 0x0C, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_message() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_message_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_mobile_screen_share 48x48, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_outlined_48_communication_mobile_screen_share_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xE8, 0x4E, 0xA2, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x2A, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0E, 0x80, 0x9E, 0x0F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x74, 0x04, 0x02, 0x7F, 0x97,
  0x48, 0x16, 0xE3, 0x6F, 0x97, 0x48, 0x26, 0xFE, 0x45, 0xF9, 0x72, 0x81, 0x14, 0xAB, 0x05, 0x4F,
  0x97, 0x03, 0x0A, 0xF0, 0x63, 0xF9, 0x60, 0x9F, 0xB0, 0x72, 0xF9, 0x50, 0xBF, 0xC0, 0x72, 0xF9,
  0x40, 0xAF, 0xC0, 0x63, 0xF9, 0x30, 0x5B, 0x83, 0xEB, 0x97, 0xAB, 0x05, 0x4F, 0x93, 0x82, 0xDF,
  0xC5, 0x48, 0x26, 0xFE, 0x45, 0xF9, 0x28, 0x14, 0xE7, 0x68, 0x16, 0xE3, 0x6F, 0x92, 0x09, 0x04,
  0x70, 0x40, 0x37, 0xF9, 0x20, 0x37, 0x73, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97,
  0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x68, 0x09, 0xE0, 0xF0, 0xDF, 0xFF, 0xD0, 0xD0,
  0x9F, 0xFF, 0xD8, 0x19, 0x1D, 0xFF, 0xFB, 0x84, 0xD1, 0x01, 0x9D, 0xFF, 0xE8, 0x1D, 0x91, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_mobile_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_mobile_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_more_time 48x48, 4-bit Alpha,  RLE, 298 bytes.
static const unsigned char ic_outlined_48_communication_more_time_data[] PROGMEM = {
  0x77, 0x77, 0x4C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x77, 0x48, 0x90, 0x15,
  0x9B, 0xDE, 0xFD, 0xC9, 0x73, 0xC7, 0x72, 0x05, 0x0B, 0xFB, 0x73, 0xC7, 0x70, 0x40, 0xCF, 0xD4,
  0xFF, 0xA7, 0x09, 0xFF, 0x4F, 0xFA, 0x50, 0x10, 0xBE, 0x82, 0xC7, 0x32, 0x28, 0x11, 0x37, 0x4F,
  0xFA, 0x40, 0x10, 0xDD, 0x09, 0x02, 0x76, 0xFF, 0xA4, 0x0B, 0xC0, 0xD0, 0x27, 0x77, 0xC7, 0x20,
  0x9C, 0x0B, 0x77, 0x72, 0xC7, 0x10, 0x4C, 0x0B, 0x71, 0xB7, 0x6C, 0x71, 0x0C, 0xB0, 0xD7, 0x2B,
  0x76, 0xC7, 0x05, 0xC0, 0x27, 0x2B, 0x76, 0xC7, 0x0B, 0xB0, 0x97, 0x3B, 0x76, 0xC6, 0x01, 0xC0,
  0x27, 0x3B, 0x77, 0x72, 0x05, 0xB0, 0xC7, 0x4B, 0x77, 0x72, 0x09, 0xB0, 0x77, 0x4B, 0x77, 0x72,
  0x0B, 0xB0, 0x37, 0x4B, 0x77, 0x72, 0x0D, 0xB0, 0x27, 0x4B, 0x75, 0x01, 0xB0, 0xE6, 0x0E, 0xB7,
  0x5B, 0x76, 0xC6, 0x0E, 0xB7, 0x5B, 0x02, 0x75, 0xB0, 0xE6, 0x0D, 0xB0, 0x27, 0x4C, 0x07, 0x73,
  0x02, 0xB0, 0xD6, 0x0B, 0xB0, 0x37, 0x40, 0x40, 0xDB, 0x0D, 0x04, 0x71, 0x03, 0xB0, 0xB6, 0x09,
  0xB0, 0x77, 0x60, 0x8C, 0x0A, 0x02, 0x60, 0x7B, 0x09, 0x60, 0x5B, 0x0C, 0x77, 0x02, 0x0B, 0xC0,
  0x75, 0x0C, 0xB0, 0x56, 0x01, 0xC0, 0x27, 0x71, 0x06, 0x0E, 0xB0, 0xB3, 0x02, 0xC0, 0x17, 0x0B,
  0xB0, 0x97, 0x72, 0x01, 0x09, 0xA0, 0x43, 0x09, 0xB0, 0xB7, 0x10, 0x5C, 0x02, 0x77, 0x30, 0x30,
  0x73, 0x02, 0xC0, 0x57, 0x20, 0xCB, 0x0D, 0x77, 0x71, 0x0D, 0xB0, 0xC7, 0x30, 0x4C, 0x0B, 0x77,
  0x60, 0xBC, 0x04, 0x74, 0x09, 0xC0, 0xB7, 0x74, 0x0B, 0xC0, 0x97, 0x60, 0xBC, 0x0D, 0x02, 0x77,
  0x02, 0x0D, 0xC0, 0xB7, 0x70, 0x10, 0xDD, 0x09, 0x02, 0x73, 0x02, 0x09, 0xD0, 0xD0, 0x17, 0x71,
  0x01, 0x0B, 0xE8, 0x2C, 0x73, 0x22, 0x82, 0x23, 0x7C, 0xE0, 0xB0, 0x17, 0x74, 0x09, 0xFF, 0xE0,
  0x97, 0x77, 0x04, 0x0C, 0xFF, 0xA0, 0xC0, 0x47, 0x77, 0x30, 0x50, 0xBF, 0xD0, 0xB0, 0x57, 0x77,
  0x78, 0x92, 0x15, 0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_more_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_more_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_nat 48x48, 4-bit Alpha,  RLE, 282 bytes.
static const unsigned char ic_outlined_48_communication_nat_data[] PROGMEM = {
  0x71, 0x84, 0xED, 0xBA, 0x62, 0x80, 0xC2, 0x0E, 0x81, 0xD7, 0x17, 0x77, 0x77, 0xF9, 0x81, 0xE8,
  0x17, 0x77, 0x75, 0xFB, 0x0E, 0x04, 0x77, 0x77, 0x58, 0x22, 0x36, 0xBF, 0x08, 0x80, 0xC1, 0x00,
  0x60, 0xDD, 0x0A, 0x80, 0xC2, 0x00, 0x7D, 0x09, 0x80, 0xC2, 0x00, 0x30, 0xDC, 0x08, 0x80, 0xC2,
  0x00, 0x10, 0xCC, 0x04, 0x80, 0xC2, 0x00, 0x10, 0xDB, 0x0D, 0x80, 0xC3, 0x00, 0x3C, 0x08, 0x80,
  0xC3, 0x00, 0x7C, 0x01, 0x80, 0xC3, 0x00, 0xDB, 0x07, 0x80, 0xC3, 0x00, 0x6B, 0x0D, 0x77, 0x68,
  0x46, 0xCE, 0xEB, 0x57, 0x7C, 0x03, 0x71, 0x09, 0x71, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x50, 0xBB,
  0x06, 0x71, 0x90, 0xC0, 0x26, 0x0C, 0xF9, 0x0C, 0x75, 0x06, 0xB0, 0x97, 0x1A, 0x0E, 0x05, 0x40,
  0x6F, 0xB0, 0x57, 0x40, 0x3B, 0x0C, 0x71, 0xC0, 0x93, 0x0C, 0xB8, 0x2B, 0x11, 0xBF, 0xD3, 0x02,
  0xFF, 0xB8, 0x2C, 0x20, 0xEB, 0x01, 0x20, 0x1F, 0xD4, 0xFF, 0xC8, 0x1E, 0x5E, 0xB0, 0x12, 0x01,
  0xFD, 0x4F, 0xFC, 0x81, 0xE5, 0xCB, 0x82, 0xB1, 0x1B, 0xFD, 0x30, 0x2F, 0xFB, 0x82, 0xC2, 0x06,
  0xFB, 0x05, 0x74, 0x03, 0xB0, 0xC7, 0x1C, 0x09, 0x40, 0xCF, 0x90, 0xC7, 0x50, 0x6B, 0x09, 0x71,
  0xA0, 0xE0, 0x55, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x50, 0xBB, 0x06, 0x71, 0x90, 0xC0, 0x27, 0x18,
  0x46, 0xCE, 0xEB, 0x57, 0x7C, 0x03, 0x71, 0x09, 0x77, 0x77, 0x10, 0x6B, 0x0D, 0x80, 0xC3, 0x00,
  0xDB, 0x07, 0x80, 0xC2, 0x00, 0x7C, 0x01, 0x80, 0xC1, 0x00, 0x3C, 0x08, 0x80, 0xC1, 0x00, 0x10,
  0xDB, 0x0D, 0x80, 0xC1, 0x00, 0x10, 0xCC, 0x04, 0x80, 0xC0, 0x00, 0x30, 0xDC, 0x08, 0x80, 0xC0,
  0x00, 0x7D, 0x09, 0x77, 0x77, 0x70, 0x60, 0xDD, 0x0A, 0x77, 0x77, 0x38, 0x22, 0x36, 0xBF, 0x08,
  0x77, 0x77, 0x3F, 0xB0, 0xE0, 0x47, 0x77, 0x74, 0xF9, 0x81, 0xE8, 0x17, 0x77, 0x75, 0xE8, 0x1D,
  0x71, 0x77, 0x77, 0x78, 0x4E, 0xDB, 0xA6, 0x27, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_nat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_nat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_no_sim 48x48, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_outlined_48_communication_no_sim_data[] PROGMEM = {
  0x77, 0x07, 0xFF, 0x81, 0xDA, 0x17, 0x10, 0x47, 0x30, 0x7F, 0xFB, 0x0E, 0x01, 0x68, 0x16, 0xF9,
  0x71, 0x07, 0xFF, 0xD0, 0xA5, 0x06, 0xB0, 0x96, 0x07, 0xFF, 0xE0, 0xD5, 0x0D, 0xC0, 0x95, 0x0A,
  0xB0, 0xE0, 0x37, 0x5C, 0x50, 0x20, 0xDC, 0x09, 0x58, 0x2A, 0xFE, 0x37, 0x6C, 0x60, 0x20, 0xDC,
  0x09, 0x50, 0x90, 0x37, 0x7C, 0x70, 0x20, 0xDC, 0x09, 0x77, 0x6C, 0x71, 0x02, 0x0D, 0xC0, 0x97,
  0x75, 0xC7, 0x20, 0x20, 0xEC, 0x09, 0x77, 0x4C, 0x73, 0xE0, 0x97, 0x73, 0xC7, 0x3F, 0x09, 0x77,
  0x2C, 0x73, 0xF9, 0x09, 0x77, 0x1C, 0x73, 0xC0, 0xDC, 0x09, 0x77, 0xC7, 0x3C, 0x02, 0x0D, 0xC0,
  0x97, 0x6C, 0x73, 0xC1, 0x02, 0x0D, 0xC0, 0x97, 0x5C, 0x73, 0xC2, 0x02, 0x0D, 0xC0, 0x97, 0x4C,
  0x73, 0xC3, 0x02, 0x0D, 0xC0, 0x97, 0x3C, 0x73, 0xC4, 0x02, 0x0D, 0xC0, 0x97, 0x2C, 0x73, 0xC5,
  0x02, 0x0D, 0xC0, 0x97, 0x1C, 0x73, 0xC6, 0x02, 0x0D, 0xC0, 0x97, 0xC7, 0x3C, 0x70, 0x20, 0xDC,
  0x09, 0x6C, 0x73, 0xC7, 0x10, 0x20, 0xDC, 0x09, 0x50, 0xAB, 0x73, 0xC7, 0x20, 0x20, 0xDC, 0x09,
  0x50, 0xAA, 0x73, 0xC7, 0x30, 0x20, 0xDC, 0x09, 0x50, 0xA9, 0x73, 0xC7, 0x40, 0x20, 0xDC, 0x09,
  0x50, 0xA7, 0x3C, 0x75, 0x02, 0x0D, 0xC0, 0x97, 0x71, 0xC7, 0x60, 0x20, 0xDC, 0x09, 0x77, 0xC7,
  0x70, 0x20, 0xDC, 0x09, 0x76, 0xC7, 0x71, 0x02, 0x0D, 0xC0, 0x97, 0x5C, 0x77, 0x20, 0x20, 0xDC,
  0x09, 0x74, 0xC7, 0x73, 0x02, 0x0D, 0xC0, 0x97, 0x30, 0xDF, 0xFF, 0xE0, 0x97, 0x20, 0xAF, 0xFF,
  0xF0, 0x97, 0x10, 0x10, 0xEF, 0xFF, 0xF0, 0x97, 0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x1E, 0xAD, 0xC0,
  0x97, 0x77, 0x74, 0x02, 0x0D, 0xC0, 0x47, 0x77, 0x74, 0x02, 0x0D, 0xA0, 0x67, 0x77, 0x76, 0x81,
  0x2D, 0x62,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 6, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_communication_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_pause_presentation 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_outlined_48_communication_pause_presentation_data[] PROGMEM = {
  0x18, 0x12, 0xAE, 0x80, 0xC0, 0xF8, 0x4E, 0xA2, 0x02, 0xE8, 0x0C, 0x4F, 0x81, 0xE2, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0E, 0x80, 0xC6, 0xF0, 0xEC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x75, 0xC4, 0xC7, 0x5F,
  0x97, 0x5C, 0x4C, 0x75, 0xF9, 0x75, 0xC4, 0xC7, 0x5F, 0x97, 0x5C, 0x4C, 0x75, 0xF9, 0x75, 0xC4,
  0xC7, 0x5F, 0x97, 0x5C, 0x4C, 0x75, 0xF9, 0x75, 0xC4, 0xC7, 0x5F, 0x97, 0x5C, 0x4C, 0x75, 0xF9,
  0x75, 0xC4, 0xC7, 0x5F, 0x97, 0x5C, 0x4C, 0x75, 0xF9, 0x75, 0xC4, 0xC7, 0x5F, 0x97, 0x5C, 0x4C,
  0x75, 0xF9, 0x75, 0xC4, 0xC7, 0x5F, 0x97, 0x5C, 0x4C, 0x75, 0xF9, 0x75, 0xC4, 0xC7, 0x5F, 0x97,
  0x5C, 0x4C, 0x75, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C,
  0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x09, 0x80, 0xC6,
  0xF8, 0x19, 0x1D, 0x80, 0xC4, 0xF8, 0x4D, 0x10, 0x19, 0xD8, 0x0C, 0x0F, 0x81, 0xD9, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_pause_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_pause_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_person_add_disabled 48x48, 4-bit Alpha,  RLE, 388 bytes.
static const unsigned char ic_outlined_48_communication_person_add_disabled_data[] PROGMEM = {
  0x20, 0x30, 0x18, 0x0C, 0x70, 0x82, 0x4F, 0xC1, 0x80, 0xC5, 0x00, 0x4B, 0x0C, 0x01, 0x80, 0xC4,
  0x00, 0xAC, 0x0C, 0x01, 0x80, 0xC4, 0x00, 0xBC, 0x0C, 0x01, 0x80, 0xC4, 0x00, 0xBC, 0x0C, 0x01,
  0x77, 0x38, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x71, 0x0B, 0xC0, 0xC0, 0x17, 0x71, 0x09, 0xF9, 0x09,
  0x77, 0x10, 0xBC, 0x0C, 0x01, 0x76, 0x0B, 0xFB, 0x0B, 0x77, 0x10, 0xBC, 0x0C, 0x01, 0x74, 0x09,
  0xFD, 0x09, 0x77, 0x10, 0xBC, 0x0C, 0x01, 0x72, 0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02, 0x77,
  0x10, 0xBC, 0x0C, 0x01, 0x71, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x72, 0xD0, 0xC0,
  0x17, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0x72, 0xE0, 0xC0, 0x16, 0x0E, 0xB0, 0x46, 0x01, 0xB0,
  0xE7, 0x72, 0xF0, 0xC0, 0x15, 0x0E, 0xB0, 0xE0, 0x35, 0x01, 0xB0, 0xE7, 0x72, 0xF9, 0x0C, 0x01,
  0x40, 0x6C, 0x0E, 0x03, 0x40, 0x5B, 0x0C, 0x77, 0x2C, 0x0B, 0xC0, 0xC0, 0x14, 0x06, 0xC0, 0xE0,
  0x32, 0x01, 0x0D, 0xB0, 0x87, 0x72, 0xC1, 0x0B, 0xC0, 0xC0, 0x14, 0x06, 0xC8, 0x2E, 0x45, 0xDC,
  0x02, 0x73, 0xFF, 0xB0, 0xC0, 0x14, 0x06, 0xFB, 0x09, 0x74, 0xFF, 0xC0, 0xC0, 0x14, 0x06, 0xF9,
  0x0B, 0x75, 0xFF, 0xD0, 0xC0, 0x14, 0x06, 0xE0, 0x97, 0x6F, 0xFE, 0x0C, 0x01, 0x48, 0x46, 0xEE,
  0xC8, 0x27, 0x76, 0xC6, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x71, 0xC7, 0x0B, 0xC0, 0xC0, 0x17, 0x77,
  0x7C, 0x71, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x6C, 0x72, 0x0B, 0xC0, 0xC0, 0x17, 0x77, 0x5C, 0x73,
  0x0B, 0xC0, 0xC0, 0x14, 0x82, 0x27, 0x51, 0x77, 0x3C, 0x71, 0x81, 0x28, 0xDD, 0x0C, 0x01, 0x40,
  0x6A, 0x81, 0xC7, 0x27, 0x77, 0x30, 0x50, 0xCF, 0xA0, 0xC0, 0x14, 0x06, 0xC0, 0xB0, 0x47, 0x76,
  0x02, 0x0C, 0xFD, 0x0C, 0x01, 0x40, 0x6D, 0x0B, 0x02, 0x77, 0x30, 0x40, 0xEE, 0x82, 0xEA, 0x6B,
  0xC0, 0xC0, 0x14, 0x06, 0xD0, 0xE0, 0x37, 0x71, 0x02, 0x0E, 0xD0, 0xA0, 0x44, 0x0B, 0xC0, 0xC0,
  0x14, 0x06, 0xD0, 0xE0, 0x17, 0x70, 0xAC, 0x0A, 0x02, 0x70, 0xBC, 0x0C, 0x01, 0x40, 0x6D, 0x09,
  0x77, 0x0E, 0xB0, 0x67, 0x30, 0xBC, 0x0C, 0x01, 0x40, 0x6C, 0x0D, 0x77, 0xFF, 0xF0, 0xC0, 0x14,
  0x06, 0xC7, 0x7F, 0xFF, 0x90, 0xC0, 0x14, 0x06, 0xB7, 0x7F, 0xFF, 0xA0, 0xC0, 0x14, 0x06, 0xA7,
  0x7F, 0xFF, 0xB0, 0xC0, 0x14, 0x06, 0x97, 0x77, 0x76, 0x0B, 0xC0, 0xC0, 0x18, 0x0C, 0x40, 0x0B,
  0xC0, 0xC0, 0x18, 0x0C, 0x40, 0x0B, 0xC0, 0xC0, 0x18, 0x0C, 0x40, 0x0B, 0xC0, 0xC0, 0x18, 0x0C,
  0x40, 0x0B, 0xC0, 0xC0, 0x18, 0x0C, 0x40, 0x0B, 0xC0, 0x48, 0x0C, 0x50, 0x0B, 0xA0, 0x48, 0x0C,
  0x70, 0x0A, 0x04, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_person_add_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 45, 47), Box(0, 0, 47, 47),
      ic_outlined_48_communication_person_add_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_person_search 48x48, 4-bit Alpha,  RLE, 282 bytes.
static const unsigned char ic_outlined_48_communication_person_search_data[] PROGMEM = {
  0x75, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0x77, 0x30, 0x9F, 0x90, 0x97, 0x77, 0x71, 0x0B, 0xFB,
  0x0B, 0x77, 0x76, 0x09, 0xFD, 0x09, 0x77, 0x74, 0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02, 0x77,
  0x73, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x77, 0x30, 0xCB, 0x05, 0x60, 0x5B, 0x0C,
  0x77, 0x73, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x77, 0x30, 0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x77,
  0x73, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0x77, 0x30, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08,
  0x77, 0x73, 0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02, 0x77, 0x74, 0x09, 0xFD, 0x09, 0x77, 0x76,
  0x0B, 0xFB, 0x0B, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x97, 0x77, 0x73, 0x86, 0x28, 0xCE, 0xEC, 0x82,
  0x80, 0xD0, 0x08, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x77, 0x73, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x10,
  0xBF, 0xB0, 0xB7, 0x77, 0x60, 0x9F, 0xD0, 0x97, 0x78, 0x61, 0x48, 0xAC, 0xDF, 0x83, 0x02, 0xC8,
  0x4D, 0x51, 0x15, 0xDC, 0x02, 0x73, 0x81, 0x27, 0xCF, 0x04, 0x30, 0x8B, 0x0D, 0x01, 0x40, 0x10,
  0xDB, 0x08, 0x71, 0x04, 0x0B, 0xFB, 0x02, 0x30, 0xCB, 0x05, 0x60, 0x5B, 0x0C, 0x60, 0x10, 0xBF,
  0xD4, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE5, 0x04, 0x0E, 0xF8, 0x3B, 0x85, 0x21, 0x50, 0xEB, 0x01,
  0x60, 0x1B, 0x0E, 0x40, 0x20, 0xED, 0x0B, 0x05, 0x74, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC4, 0x0A,
  0xC0, 0xA0, 0x27, 0x60, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08, 0x40, 0xEB, 0x06, 0x77, 0x10,
  0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x14, 0xFF, 0xA0, 0xD4, 0x09, 0xFE, 0x05, 0x4F, 0xFB, 0x06,
  0x40, 0xBF, 0xE0, 0x53, 0xFF, 0xB0, 0xD0, 0x14, 0x09, 0xFE, 0x05, 0x2F, 0xFC, 0x0A, 0x58, 0x72,
  0x8C, 0xEE, 0xC8, 0x15, 0xD0, 0x57, 0x77, 0x76, 0x05, 0xD0, 0x57, 0x77, 0x76, 0x05, 0xC0, 0xA7,
  0x77, 0x77, 0x05, 0xA0, 0xA8, 0x0C, 0x10, 0x05, 0x0A, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_person_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_person_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_phone_disabled 48x48, 4-bit Alpha,  RLE, 354 bytes.
static const unsigned char ic_outlined_48_communication_phone_disabled_data[] PROGMEM = {
  0x20, 0x28, 0x0C, 0x20, 0x81, 0x4F, 0x77, 0x77, 0x30, 0x40, 0xDF, 0x82, 0xD4, 0x04, 0xB0, 0x77,
  0x77, 0x20, 0xDF, 0xA8, 0x1D, 0x0E, 0xC0, 0x77, 0x77, 0x1F, 0xC1, 0x03, 0x0E, 0xC0, 0x77, 0x76,
  0x01, 0xFB, 0x0E, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x50, 0x3B, 0x0D, 0x20, 0x1B, 0x0D, 0x30, 0x30,
  0xEC, 0x07, 0x77, 0x40, 0x4B, 0x0B, 0x20, 0x4B, 0x0C, 0x40, 0x30, 0xEC, 0x07, 0x77, 0x30, 0x7B,
  0x09, 0x20, 0x6B, 0x0A, 0x50, 0x30, 0xEC, 0x07, 0x77, 0x20, 0xBB, 0x06, 0x20, 0x8B, 0x08, 0x60,
  0x30, 0xEC, 0x07, 0x77, 0x10, 0xEB, 0x02, 0x20, 0xBB, 0x05, 0x70, 0x30, 0xEC, 0x07, 0x76, 0x02,
  0xC0, 0x52, 0xC0, 0x27, 0x10, 0x30, 0xEC, 0x07, 0x75, 0x01, 0xD0, 0x50, 0x4B, 0x0E, 0x73, 0x03,
  0x0E, 0xC0, 0x77, 0x50, 0x5D, 0x0C, 0xB0, 0x97, 0x40, 0x30, 0xEC, 0x07, 0x75, 0x05, 0xF9, 0x04,
  0x75, 0x03, 0x0E, 0xC0, 0x77, 0x50, 0x5E, 0x0E, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x50, 0x5D, 0x09,
  0x77, 0x10, 0x30, 0xEC, 0x07, 0x75, 0x07, 0xC0, 0x37, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x40, 0xBB,
  0x0B, 0x77, 0x40, 0x30, 0xEC, 0x07, 0x72, 0x05, 0xC0, 0x37, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x01,
  0x0D, 0xB0, 0xB7, 0x77, 0x03, 0x0E, 0xC0, 0x76, 0x0A, 0xC0, 0x27, 0x77, 0x10, 0x30, 0xEC, 0x07,
  0x50, 0xCB, 0x07, 0x77, 0x73, 0x03, 0x0E, 0xC0, 0x74, 0x82, 0x1C, 0xFC, 0x77, 0x75, 0x03, 0x0E,
  0xC0, 0x74, 0x81, 0x1B, 0x27, 0x75, 0x02, 0x01, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x58, 0x71, 0x24,
  0x7B, 0xEF, 0xE5, 0x60, 0x30, 0xEC, 0x07, 0x77, 0x10, 0x40, 0xDF, 0xB0, 0x56, 0x03, 0xD0, 0x77,
  0x70, 0xDF, 0xD0, 0x54, 0x01, 0x0A, 0xE0, 0x77, 0x6F, 0xF0, 0x52, 0x05, 0x0D, 0xF9, 0x07, 0x75,
  0xC8, 0x4D, 0xB9, 0x63, 0x5D, 0x07, 0x0B, 0xD0, 0x0E, 0xC0, 0x77, 0x4C, 0x60, 0x5F, 0xB8, 0x2C,
  0x23, 0xEC, 0x07, 0x73, 0xC6, 0x04, 0x0C, 0xF9, 0x07, 0x30, 0x30, 0xEC, 0x07, 0x72, 0xC8, 0x32,
  0x46, 0x8B, 0xFA, 0x0B, 0x02, 0x50, 0x30, 0xEC, 0x07, 0x71, 0xFF, 0xA0, 0xB0, 0x37, 0x10, 0x30,
  0xEC, 0x07, 0x7F, 0xE8, 0x1E, 0x93, 0x74, 0x03, 0x0E, 0xC0, 0x76, 0x0D, 0xFA, 0x81, 0xE9, 0x57,
  0x71, 0x03, 0x0E, 0xC0, 0x75, 0x89, 0x04, 0xDF, 0xED, 0xCA, 0x85, 0x27, 0x75, 0x03, 0x0E, 0xC0,
  0x77, 0x77, 0x76, 0x03, 0x0E, 0xC0, 0x27, 0x77, 0x76, 0x03, 0x0E, 0xA0, 0x48, 0x0C, 0x00, 0x81,
  0x3E, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_phone_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 42, 44), Box(0, 0, 47, 47),
      ic_outlined_48_communication_phone_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_phone_enabled 48x48, 4-bit Alpha,  RLE, 234 bytes.
static const unsigned char ic_outlined_48_communication_phone_enabled_data[] PROGMEM = {
  0x77, 0x74, 0x04, 0x0D, 0xF0, 0xD0, 0x47, 0x77, 0x40, 0xDF, 0xA0, 0xD7, 0x77, 0x4F, 0xC7, 0x77,
  0x30, 0x1F, 0xB0, 0xE7, 0x77, 0x30, 0x3B, 0x0D, 0x20, 0x1B, 0x0D, 0x77, 0x73, 0x04, 0xB0, 0xB2,
  0x04, 0xB0, 0xC7, 0x77, 0x30, 0x7B, 0x09, 0x20, 0x6B, 0x0A, 0x77, 0x73, 0x0B, 0xB0, 0x62, 0x08,
  0xB0, 0x77, 0x77, 0x30, 0xEB, 0x02, 0x20, 0xBB, 0x05, 0x77, 0x72, 0x02, 0xC0, 0x52, 0xC0, 0x27,
  0x77, 0x20, 0x1D, 0x05, 0x04, 0xB0, 0xD7, 0x77, 0x40, 0x5D, 0x0C, 0xB0, 0x97, 0x77, 0x50, 0x5F,
  0x90, 0x57, 0x77, 0x60, 0x5E, 0x0E, 0x77, 0x77, 0x10, 0x5D, 0x09, 0x77, 0x77, 0x20, 0x7C, 0x03,
  0x77, 0x77, 0x20, 0xBB, 0x0B, 0x77, 0x77, 0x20, 0x5C, 0x03, 0x77, 0x77, 0x10, 0x10, 0xDB, 0x0B,
  0x77, 0x77, 0x20, 0xAC, 0x02, 0x77, 0x77, 0x10, 0x6C, 0x07, 0x77, 0x77, 0x10, 0x3C, 0x0C, 0x77,
  0x77, 0x10, 0x30, 0xEB, 0x0E, 0x02, 0x77, 0x10, 0x20, 0x17, 0x40, 0x30, 0xEC, 0x05, 0x73, 0x87,
  0x12, 0x47, 0xBE, 0xFE, 0x57, 0x20, 0x30, 0xEC, 0x06, 0x71, 0x04, 0x0D, 0xFB, 0x05, 0x70, 0x6D,
  0x08, 0x72, 0x0D, 0xFD, 0x05, 0x40, 0x10, 0xAD, 0x08, 0x73, 0xFF, 0x05, 0x20, 0x50, 0xDD, 0x06,
  0x74, 0xC8, 0x4D, 0xB9, 0x63, 0x5D, 0x07, 0x0B, 0xD0, 0xE0, 0x57, 0x5C, 0x60, 0x5F, 0xB0, 0xC0,
  0x27, 0x6C, 0x60, 0x40, 0xCF, 0x90, 0x77, 0x71, 0xC8, 0x32, 0x46, 0x8B, 0xFA, 0x0B, 0x02, 0x77,
  0x2F, 0xFA, 0x0B, 0x03, 0x77, 0x4F, 0xE8, 0x1E, 0x93, 0x77, 0x60, 0xDF, 0xA8, 0x1D, 0x95, 0x77,
  0x72, 0x89, 0x04, 0xDF, 0xDD, 0xCA, 0x85, 0x27, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_phone_enabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_phone_enabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_phonelink_erase 48x48, 4-bit Alpha,  RLE, 298 bytes.
static const unsigned char ic_outlined_48_communication_phonelink_erase_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x10,
  0xAF, 0xFF, 0xD0, 0xA7, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x1F, 0xFF, 0xF7, 0x1F, 0xFF, 0xF7, 0x1C,
  0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x77, 0x74, 0xC7,
  0x77, 0x74, 0xC1, 0x00, 0x27, 0x70, 0x02, 0x76, 0xC8, 0x22, 0xEE, 0x27, 0x58, 0x22, 0xEE, 0x27,
  0x5C, 0x0B, 0xA0, 0xE0, 0x27, 0x30, 0x20, 0xEA, 0x0B, 0x75, 0xC0, 0x10, 0xCA, 0x0E, 0x02, 0x71,
  0x02, 0x0E, 0xA0, 0xC0, 0x17, 0x5C, 0x10, 0x10, 0xCA, 0x0E, 0x02, 0x60, 0x20, 0xEA, 0x0C, 0x01,
  0x76, 0xC2, 0x01, 0x0C, 0xA0, 0xE0, 0x24, 0x02, 0x0E, 0xA0, 0xC0, 0x17, 0x7C, 0x30, 0x10, 0xCA,
  0x0E, 0x02, 0x20, 0x20, 0xEA, 0x0C, 0x01, 0x77, 0x1C, 0x40, 0x10, 0xCA, 0x82, 0xE2, 0x2E, 0xA0,
  0xC0, 0x17, 0x72, 0xC5, 0x01, 0x0C, 0xA0, 0x0E, 0xA0, 0xC0, 0x17, 0x73, 0xC6, 0x01, 0x0C, 0xC0,
  0xC0, 0x17, 0x74, 0xC7, 0x04, 0xC0, 0x47, 0x75, 0xC6, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x74, 0xC5,
  0x02, 0x0E, 0xA0, 0x0C, 0xA0, 0xE0, 0x27, 0x73, 0xC4, 0x02, 0x0E, 0xA8, 0x2C, 0x11, 0xCA, 0x0E,
  0x02, 0x77, 0x2C, 0x30, 0x20, 0xEA, 0x0C, 0x01, 0x20, 0x10, 0xCA, 0x0E, 0x02, 0x77, 0x1C, 0x20,
  0x20, 0xEA, 0x0C, 0x01, 0x40, 0x10, 0xCA, 0x0E, 0x02, 0x77, 0xC1, 0x02, 0x0E, 0xA0, 0xC0, 0x16,
  0x01, 0x0C, 0xA0, 0xE0, 0x27, 0x6C, 0x02, 0x0E, 0xA0, 0xC0, 0x17, 0x10, 0x10, 0xCA, 0x0E, 0x02,
  0x75, 0xC0, 0xBA, 0x0C, 0x01, 0x73, 0x01, 0x0C, 0xA0, 0xB7, 0x5C, 0x82, 0x1C, 0xC1, 0x75, 0x82,
  0x1C, 0xC1, 0x75, 0xC1, 0x00, 0x17, 0x70, 0x01, 0x76, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x6C,
  0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1F, 0xFF, 0xF7, 0x1F, 0xFF,
  0xF7, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x10, 0xAF, 0xFF, 0xD0, 0xA7, 0x10, 0x10, 0xEF, 0xFF, 0xB0,
  0xE0, 0x17, 0x28, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_phonelink_erase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_phonelink_erase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_phonelink_lock 48x48, 4-bit Alpha,  RLE, 193 bytes.
static const unsigned char ic_outlined_48_communication_phonelink_lock_data[] PROGMEM = {
  0x78, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x70, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x16, 0x0A, 0xFF,
  0xFD, 0x0A, 0x60, 0xDF, 0xFF, 0xD0, 0xD6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0xC7, 0x76, 0xC6, 0xC7,
  0x76, 0xC6, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC5, 0x84, 0x6A,
  0xEE, 0xB6, 0x77, 0x5C, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x3C, 0x30, 0xBA, 0x82, 0xC7, 0x7C,
  0xA0, 0xB7, 0x73, 0xC2, 0x04, 0xA0, 0x94, 0x09, 0xA0, 0x47, 0x72, 0xC2, 0x08, 0xA0, 0x14, 0x01,
  0xA0, 0x87, 0x72, 0xC2, 0x09, 0xA6, 0xA0, 0x97, 0x72, 0xC2, 0x09, 0xA6, 0xA0, 0x97, 0x72, 0xC2,
  0x09, 0xA6, 0xA0, 0x97, 0x72, 0xC0, 0x10, 0xBF, 0xD0, 0xB0, 0x17, 0x7C, 0x0B, 0xFF, 0x0A, 0x77,
  0xFF, 0xD0, 0xE7, 0x7F, 0xFE, 0x77, 0xFF, 0xE7, 0x7F, 0xFE, 0x77, 0xFF, 0xE7, 0x7F, 0xFE, 0x77,
  0xFF, 0xE7, 0x7C, 0x0E, 0xFF, 0x97, 0x7C, 0x0A, 0xFF, 0x0B, 0x77, 0xC0, 0x10, 0xBF, 0xC8, 0x1E,
  0xA1, 0x77, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x72, 0xC6, 0xC7, 0x76, 0xC6, 0xC7, 0x76, 0xC6, 0xC7,
  0x76, 0xC6, 0xC7, 0x76, 0xC6, 0xFF, 0xFF, 0x6F, 0xFF, 0xF6, 0x0D, 0xFF, 0xFD, 0x0D, 0x60, 0xAF,
  0xFF, 0xD0, 0xA6, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x78, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_phonelink_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_phonelink_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_phonelink_ring 48x48, 4-bit Alpha,  RLE, 240 bytes.
static const unsigned char ic_outlined_48_communication_phonelink_ring_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x1D, 0xA1, 0x76, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x75, 0x0A,
  0xFF, 0xFD, 0x0A, 0x75, 0x0D, 0xFF, 0xFD, 0x0D, 0x75, 0xFF, 0xFF, 0x75, 0xFF, 0xFF, 0x75, 0xC7,
  0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7,
  0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x70, 0x10, 0x33, 0xC7, 0x76, 0xC6,
  0x82, 0x1C, 0xE2, 0x2C, 0x77, 0x6C, 0x60, 0x8A, 0x0D, 0x2C, 0x77, 0x6C, 0x70, 0xDA, 0x07, 0x1C,
  0x77, 0x6C, 0x30, 0x13, 0x04, 0xA0, 0xE1, 0xC7, 0x76, 0xC2, 0x81, 0x1C, 0xA3, 0x0B, 0xA0, 0x5C,
  0x77, 0x6C, 0x20, 0xCA, 0x03, 0x20, 0x6A, 0x0A, 0xC7, 0x76, 0xC2, 0x08, 0xA0, 0x92, 0x03, 0xA0,
  0xCC, 0x77, 0x6C, 0x20, 0x4A, 0x0B, 0x20, 0x2A, 0x0D, 0xC7, 0x76, 0xC2, 0x05, 0xA0, 0xB2, 0x02,
  0xA0, 0xDC, 0x77, 0x6C, 0x20, 0xAA, 0x08, 0x20, 0x4A, 0x0C, 0xC7, 0x76, 0xC2, 0x0A, 0xA0, 0x32,
  0x08, 0xA0, 0x9C, 0x77, 0x6C, 0x30, 0xA0, 0x83, 0x0D, 0xA0, 0x5C, 0x77, 0x6C, 0x70, 0x6A, 0x0E,
  0x1C, 0x77, 0x6C, 0x60, 0x20, 0xEA, 0x06, 0x1C, 0x77, 0x6C, 0x60, 0x8A, 0x0C, 0x2C, 0x77, 0x6C,
  0x78, 0x1A, 0xD1, 0x2C, 0x77, 0x6C, 0x71, 0x02, 0x3C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C,
  0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C, 0x75, 0xC7, 0x76, 0xC7, 0x5C, 0x77, 0x6C,
  0x75, 0xFF, 0xFF, 0x75, 0xFF, 0xFF, 0x75, 0x0D, 0xFF, 0xFD, 0x0D, 0x75, 0x0A, 0xFF, 0xFD, 0x0A,
  0x75, 0x01, 0x0E, 0xFF, 0xFB, 0x0E, 0x01, 0x76, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x17, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_phonelink_ring() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_phonelink_ring_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_phonelink_setup 48x48, 4-bit Alpha,  RLE, 242 bytes.
static const unsigned char ic_outlined_48_communication_phonelink_setup_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFE, 0x81, 0xDA, 0x17, 0x20, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x10,
  0xAF, 0xFF, 0xD0, 0xA7, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x1F, 0xFF, 0xF7, 0x1F, 0xFF, 0xF7, 0x1C,
  0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x77, 0x74, 0xC7,
  0x77, 0x74, 0xC7, 0x06, 0xC0, 0x67, 0x75, 0xC7, 0x0B, 0xC0, 0xB7, 0x75, 0xC7, 0x0E, 0xC0, 0xE7,
  0x75, 0xC2, 0x83, 0xAC, 0x73, 0xAE, 0x83, 0xB3, 0x7C, 0xA7, 0x7C, 0x10, 0x5F, 0xFA, 0x05, 0x76,
  0xC1, 0x0D, 0xFF, 0xA0, 0xD7, 0x6C, 0x07, 0xE8, 0x4D, 0x51, 0x15, 0xDE, 0x07, 0x75, 0xC0, 0x5D,
  0x0D, 0x01, 0x40, 0x10, 0xDD, 0x05, 0x75, 0xC1, 0x05, 0x0E, 0xB0, 0x56, 0x05, 0xB0, 0xE0, 0x47,
  0x6C, 0x20, 0x9B, 0x01, 0x60, 0x1B, 0x08, 0x77, 0xC2, 0x08, 0xB0, 0x16, 0x01, 0xB0, 0x87, 0x7C,
  0x10, 0x50, 0xEB, 0x05, 0x60, 0x5B, 0x0E, 0x05, 0x76, 0xC0, 0x5D, 0x0D, 0x01, 0x40, 0x10, 0xDD,
  0x05, 0x75, 0xC0, 0x7E, 0x84, 0xD5, 0x11, 0x5D, 0xE0, 0x67, 0x5C, 0x10, 0xDF, 0xFA, 0x0D, 0x76,
  0xC1, 0x05, 0xFF, 0xA0, 0x57, 0x6C, 0x28, 0x3A, 0xC7, 0x3A, 0xE8, 0x3A, 0x37, 0xC9, 0x77, 0xC7,
  0x0E, 0xC0, 0xE7, 0x75, 0xC7, 0x0B, 0xC0, 0xB7, 0x75, 0xC7, 0x06, 0xC0, 0x67, 0x75, 0xC7, 0x77,
  0x74, 0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x6C, 0x71, 0xC7, 0x76, 0xC7, 0x1C, 0x77, 0x6C, 0x71,
  0xC7, 0x76, 0xC7, 0x1F, 0xFF, 0xF7, 0x1F, 0xFF, 0xF7, 0x10, 0xDF, 0xFF, 0xD0, 0xD7, 0x10, 0xAF,
  0xFF, 0xD0, 0xA7, 0x10, 0x10, 0xEF, 0xFF, 0xB0, 0xE0, 0x17, 0x28, 0x11, 0xAD, 0xFF, 0xE8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_phonelink_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_phonelink_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_phone 48x48, 4-bit Alpha,  RLE, 232 bytes.
static const unsigned char ic_outlined_48_communication_phone_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xD0, 0x47, 0x77, 0x40, 0xDF, 0xA0, 0xD7, 0x77, 0x4F, 0xC7, 0x77, 0x40, 0xEF,
  0xB0, 0x17, 0x77, 0x30, 0xDB, 0x01, 0x20, 0xDB, 0x03, 0x77, 0x73, 0x0C, 0xB0, 0x42, 0x0B, 0xB0,
  0x47, 0x77, 0x30, 0xAB, 0x06, 0x20, 0x9B, 0x07, 0x77, 0x73, 0x07, 0xB0, 0x82, 0x06, 0xB0, 0xB7,
  0x77, 0x30, 0x5B, 0x0B, 0x20, 0x2B, 0x0E, 0x77, 0x73, 0x02, 0xC2, 0x05, 0xC0, 0x27, 0x77, 0x30,
  0xDB, 0x04, 0x05, 0xD0, 0x17, 0x77, 0x30, 0x9B, 0x0C, 0xD0, 0x57, 0x77, 0x40, 0x5F, 0x90, 0x57,
  0x77, 0x60, 0xEE, 0x05, 0x77, 0x77, 0x09, 0xD0, 0x57, 0x77, 0x71, 0x03, 0xC0, 0x77, 0x77, 0x73,
  0x0B, 0xB0, 0xB7, 0x77, 0x73, 0x03, 0xC0, 0x57, 0x77, 0x73, 0x0B, 0xB0, 0xD0, 0x17, 0x77, 0x72,
  0x02, 0xC0, 0xA7, 0x77, 0x73, 0x07, 0xC0, 0x67, 0x77, 0x73, 0x0C, 0xC0, 0x37, 0x77, 0x72, 0x02,
  0x0E, 0xB0, 0xE0, 0x37, 0x77, 0x72, 0x05, 0xC0, 0xE0, 0x37, 0x40, 0x10, 0x27, 0x73, 0x06, 0xC0,
  0xE0, 0x37, 0x28, 0x75, 0xEF, 0xEB, 0x74, 0x21, 0x75, 0x08, 0xD0, 0x67, 0x05, 0xFB, 0x0D, 0x04,
  0x73, 0x08, 0xD0, 0xA0, 0x14, 0x05, 0xFD, 0x0D, 0x74, 0x06, 0xD0, 0xD0, 0x52, 0x05, 0xFF, 0x75,
  0x05, 0x0E, 0xD0, 0xB0, 0x7D, 0x84, 0x53, 0x69, 0xBD, 0xC7, 0x60, 0x20, 0xCF, 0xB0, 0x56, 0xC7,
  0x71, 0x07, 0xF9, 0x0C, 0x04, 0x6C, 0x77, 0x20, 0x20, 0xBF, 0xA8, 0x3B, 0x86, 0x42, 0xC7, 0x74,
  0x03, 0x0B, 0xFF, 0xA7, 0x76, 0x81, 0x39, 0xEF, 0xE7, 0x77, 0x28, 0x15, 0x9D, 0xFA, 0x0D, 0x77,
  0x75, 0x89, 0x02, 0x58, 0xAC, 0xDD, 0xFD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_portable_wifi_off 48x48, 4-bit Alpha,  RLE, 453 bytes.
static const unsigned char ic_outlined_48_communication_portable_wifi_off_data[] PROGMEM = {
  0x20, 0x17, 0x48, 0x32, 0x69, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77, 0x18, 0x11, 0xD9, 0x78, 0x11,
  0x7D, 0xFD, 0x81, 0xD8, 0x17, 0x40, 0x10, 0xDA, 0x09, 0x50, 0x40, 0xEF, 0xFB, 0x09, 0x01, 0x72,
  0x0B, 0xC0, 0x95, 0x0B, 0xFF, 0xC0, 0xE0, 0x57, 0x10, 0x20, 0xDC, 0x09, 0x58, 0x5B, 0xFE, 0xA6,
  0x31, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x71, 0x02, 0x0D, 0xC0, 0x95, 0x05, 0x75, 0x06, 0x0D, 0xD0,
  0xA7, 0x10, 0x20, 0xDC, 0x09, 0x77, 0x50, 0x7D, 0x0A, 0x71, 0x02, 0x0E, 0xC0, 0x97, 0x75, 0x03,
  0x0D, 0xC0, 0x97, 0x04, 0xE0, 0x95, 0x87, 0x3A, 0xDF, 0xED, 0xA6, 0x15, 0x01, 0x0C, 0xC0, 0x56,
  0x0D, 0xF0, 0x95, 0x0A, 0xF0, 0x90, 0x14, 0x01, 0x0D, 0xB0, 0xE0, 0x14, 0x08, 0xC0, 0xEC, 0x09,
  0x50, 0xAF, 0x0E, 0x04, 0x40, 0x3C, 0x09, 0x30, 0x10, 0xEB, 0x81, 0x72, 0xEC, 0x09, 0x50, 0xAF,
  0x90, 0x64, 0x07, 0xC0, 0x12, 0x07, 0xB0, 0xD2, 0x02, 0x0E, 0xC0, 0x96, 0x81, 0x26, 0xCD, 0x04,
  0x40, 0xDB, 0x08, 0x20, 0xDB, 0x06, 0x30, 0x4D, 0x09, 0x71, 0x06, 0xC0, 0xE0, 0x13, 0x06, 0xB8,
  0x1D, 0x02, 0xB0, 0xE4, 0x09, 0xE0, 0x97, 0x10, 0x4C, 0x09, 0x4C, 0x03, 0x06, 0xB0, 0xA3, 0x01,
  0xF9, 0x09, 0x71, 0x06, 0xC0, 0x13, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x30, 0x7B, 0x00, 0xDC, 0x09,
  0x71, 0x0C, 0xB0, 0x63, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x30, 0xAB, 0x81, 0x72, 0xDC, 0x09, 0x70,
  0x6B, 0x0B, 0x30, 0x3B, 0x0C, 0x0D, 0xB0, 0x13, 0x0D, 0xB8, 0x23, 0x02, 0xDC, 0x09, 0x60, 0x2B,
  0x0D, 0x30, 0x2B, 0x00, 0xEB, 0x40, 0xEB, 0x01, 0x20, 0x2D, 0x09, 0x6B, 0x0E, 0x4C, 0x0E, 0xB4,
  0x0E, 0xB0, 0x13, 0x0D, 0xD0, 0x95, 0x0B, 0xA0, 0xE4, 0xB0, 0xE0, 0xDB, 0x01, 0x30, 0xDB, 0x03,
  0x30, 0xAE, 0x09, 0x58, 0x1A, 0xFD, 0x30, 0x1B, 0x0D, 0x0C, 0xB0, 0x33, 0x0B, 0xB0, 0x73, 0x01,
  0x0E, 0xE0, 0x95, 0x00, 0xA3, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x30, 0x7B, 0x0D, 0x48, 0x11, 0xAD,
  0xD0, 0x95, 0x03, 0x30, 0x6B, 0x09, 0x07, 0xB0, 0xA3, 0x01, 0xC0, 0x76, 0x02, 0x0D, 0xC0, 0x97,
  0x10, 0xBB, 0x06, 0x03, 0xB0, 0xE4, 0x09, 0xC0, 0x46, 0x02, 0x0D, 0xC0, 0x96, 0x01, 0xC8, 0x12,
  0x0D, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0x76, 0x02, 0x0D, 0xC0, 0x95, 0x06, 0xB0, 0xD2, 0x08, 0xB0,
  0xD4, 0x05, 0xC0, 0xA7, 0x02, 0x0D, 0xC0, 0x95, 0x0B, 0xA0, 0x72, 0x01, 0x0E, 0xB0, 0x74, 0x06,
  0xA0, 0xE0, 0x17, 0x10, 0x20, 0xDC, 0x09, 0x58, 0x1B, 0xE1, 0x30, 0x8C, 0x02, 0x48, 0x15, 0xE7,
  0x73, 0x02, 0x0D, 0xC0, 0x95, 0x04, 0x40, 0x10, 0xEB, 0x0D, 0x01, 0x40, 0x17, 0x50, 0x20, 0xDC,
  0x09, 0x73, 0x04, 0xC0, 0xC0, 0x17, 0x73, 0x02, 0x0D, 0xC0, 0x97, 0x30, 0x8C, 0x0D, 0x02, 0x77,
  0x30, 0x20, 0xDC, 0x09, 0x73, 0x0A, 0xD0, 0x77, 0x73, 0x02, 0x0D, 0xC0, 0x97, 0x30, 0xAC, 0x09,
  0x77, 0x40, 0x20, 0xDC, 0x09, 0x73, 0x08, 0xA0, 0xE0, 0x17, 0x75, 0x02, 0x0D, 0xC0, 0x97, 0x38,
  0x14, 0xE6, 0x77, 0x70, 0x20, 0xDB, 0x0D, 0x01, 0x73, 0x01, 0x77, 0x72, 0x83, 0x2D, 0xFD, 0x18,
  0x0C, 0x00, 0x81, 0x2B, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_portable_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 42), Box(0, 0, 47, 47),
      ic_outlined_48_communication_portable_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_present_to_all 48x48, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_outlined_48_communication_present_to_all_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0x80, 0xC0, 0xF8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x77, 0x30, 0x07, 0x77,
  0x3F, 0x97, 0x72, 0x07, 0xA0, 0x77, 0x72, 0xF9, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x1F, 0x97, 0x70,
  0x7E, 0x07, 0x77, 0xF9, 0x76, 0x07, 0xF9, 0x07, 0x76, 0xF9, 0x75, 0x07, 0xFB, 0x07, 0x75, 0xF9,
  0x74, 0x07, 0xFD, 0x07, 0x74, 0xF9, 0x73, 0x07, 0xFF, 0x07, 0x73, 0xF9, 0x77, 0xF9, 0x77, 0xF9,
  0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9,
  0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x80, 0xC0, 0x0F, 0x98,
  0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00,
  0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10,
  0x1A, 0xE8, 0x0C, 0x0F, 0x81, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_present_to_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_present_to_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_print_disabled 48x48, 4-bit Alpha,  RLE, 352 bytes.
static const unsigned char ic_outlined_48_communication_print_disabled_data[] PROGMEM = {
  0x20, 0x60, 0x38, 0x0C, 0x60, 0x82, 0x7F, 0xE3, 0x80, 0xC4, 0x00, 0x7B, 0x0E, 0x03, 0x80, 0xC3,
  0x00, 0x8C, 0x0E, 0x03, 0x50, 0xEF, 0xFF, 0xA7, 0x30, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xFF,
  0x97, 0x40, 0x7C, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xFF, 0x75, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E,
  0xFF, 0xE7, 0x60, 0x7C, 0x0E, 0x03, 0x40, 0x37, 0x72, 0xC7, 0x70, 0x7C, 0x0E, 0x03, 0x77, 0x6C,
  0x77, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x5C, 0x77, 0x20, 0x7C, 0x0E, 0x03, 0x77, 0x4C, 0x77, 0x30,
  0x7C, 0x0E, 0x03, 0x77, 0x3C, 0x77, 0x40, 0x7C, 0x0E, 0x03, 0x77, 0x2C, 0x77, 0x28, 0x16, 0xCE,
  0xD0, 0xE0, 0x34, 0x03, 0x0E, 0xFF, 0x98, 0x1E, 0xC6, 0x72, 0x01, 0x0C, 0xFA, 0x0E, 0x03, 0x40,
  0x30, 0xEF, 0xFB, 0x0C, 0x01, 0x70, 0xCF, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xFF, 0xB0, 0xC6, 0x06,
  0xFE, 0x0E, 0x03, 0x40, 0x30, 0xEF, 0xFB, 0x06, 0x50, 0xCB, 0x0B, 0x01, 0x40, 0x7C, 0x0E, 0x03,
  0x77, 0x30, 0x10, 0xBB, 0x0C, 0x50, 0xEB, 0x01, 0x60, 0x7C, 0x0E, 0x03, 0x75, 0x84, 0x4D, 0xD4,
  0x01, 0xB0, 0xE5, 0xC7, 0x10, 0x7C, 0x0E, 0x03, 0x74, 0x0D, 0xA0, 0xD2, 0xC5, 0xC7, 0x20, 0x7C,
  0x0E, 0x03, 0x73, 0x0D, 0xA0, 0xD2, 0xC5, 0xC7, 0x30, 0x7C, 0x0E, 0x03, 0x72, 0x82, 0x4E, 0xE4,
  0x2C, 0x5C, 0x74, 0x07, 0xC0, 0xE0, 0x37, 0x7C, 0x5C, 0x4F, 0xE0, 0xE0, 0x34, 0x03, 0x0E, 0xB4,
  0xC5, 0xC4, 0xFF, 0x0E, 0x03, 0x40, 0x30, 0xEA, 0x4C, 0x5C, 0x4F, 0xF9, 0x0E, 0x03, 0x40, 0x30,
  0xE9, 0x4C, 0x5C, 0x4F, 0xFA, 0x0E, 0x03, 0x40, 0x30, 0xE4, 0xC5, 0xFD, 0x71, 0x07, 0xC0, 0xE0,
  0x34, 0x03, 0x0E, 0xF5, 0xFD, 0x72, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xE5, 0xFD, 0x73, 0x07,
  0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xD5, 0xFD, 0x74, 0x07, 0xC0, 0xE0, 0x34, 0x03, 0x0E, 0xC7, 0x6C,
  0x75, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x1C, 0x76, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0xC7, 0x70, 0x7C,
  0x0E, 0x03, 0x77, 0x6C, 0x77, 0x10, 0x7C, 0x0E, 0x03, 0x77, 0x5F, 0xFF, 0xC0, 0xE0, 0x37, 0x74,
  0xFF, 0xFD, 0x0E, 0x03, 0x77, 0x3F, 0xFF, 0xE0, 0xE0, 0x37, 0x72, 0xFF, 0xFF, 0x0E, 0x03, 0x80,
  0xC3, 0x00, 0x7C, 0x0E, 0x03, 0x80, 0xC3, 0x00, 0x7C, 0x0E, 0x03, 0x80, 0xC3, 0x00, 0x7C, 0x0E,
  0x03, 0x80, 0xC3, 0x00, 0x7C, 0x05, 0x80, 0xC4, 0x00, 0x7A, 0x05, 0x80, 0xC6, 0x00, 0x70, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_print_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 44, 47), Box(0, 0, 47, 47),
      ic_outlined_48_communication_print_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_qr_code_2 48x48, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_outlined_48_communication_qr_code_2_data[] PROGMEM = {
  0xFD, 0x6C, 0x2F, 0xFF, 0xB6, 0xC2, 0xFF, 0xFB, 0x6C, 0x2F, 0xF9, 0x6B, 0x6C, 0x2B, 0x6E, 0x18,
  0x23, 0x77, 0x31, 0xB2, 0xC6, 0xB1, 0x82, 0x37, 0x73, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x2C, 0x6B,
  0x10, 0x7A, 0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x2C, 0x6B, 0x10, 0x7A, 0x07, 0x1E, 0x18, 0x23,
  0x77, 0x31, 0xB2, 0xC6, 0xB1, 0x82, 0x37, 0x73, 0x1E, 0x6B, 0x2F, 0x92, 0xB6, 0xFF, 0x92, 0xF9,
  0x2F, 0xFF, 0xB2, 0xF9, 0x2F, 0xFF, 0xB2, 0xF9, 0x2F, 0xD8, 0x09, 0x84, 0x0C, 0x4F, 0xD7, 0x1C,
  0x4C, 0x4F, 0xD7, 0x1C, 0x4C, 0x4F, 0xD7, 0x1C, 0x4C, 0x4F, 0xD7, 0x1C, 0x71, 0xC4, 0xC4, 0xF9,
  0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC4, 0xC4, 0xC4, 0xF9, 0x4C, 0x4C, 0x4C, 0x4F, 0x94, 0xC7, 0x72,
  0xC7, 0x5C, 0x77, 0x2C, 0x75, 0xFF, 0xA4, 0xC7, 0x5F, 0xFA, 0x4C, 0x75, 0xFF, 0xA4, 0xC4, 0xF9,
  0x4B, 0x6B, 0x4C, 0x4F, 0x94, 0xB1, 0x82, 0x37, 0x73, 0x1B, 0x4C, 0x4F, 0x94, 0xB1, 0x07, 0xA0,
  0x71, 0xB4, 0xC4, 0xF9, 0x4B, 0x10, 0x7A, 0x07, 0x1B, 0x4C, 0x71, 0xC4, 0xB1, 0x82, 0x37, 0x73,
  0x1B, 0x4C, 0x71, 0xC4, 0xB6, 0xB7, 0x1C, 0x4F, 0xFE, 0x71, 0xC4, 0xFF, 0xE7, 0x1C, 0x4F, 0xFE,
  0x71, 0xC4, 0xF9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_qr_code_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_qr_code_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_qr_code 48x48, 4-bit Alpha,  RLE, 130 bytes.
static const unsigned char ic_outlined_48_communication_qr_code_data[] PROGMEM = {
  0xFF, 0xA4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xFF, 0xC4, 0xFF, 0xE7, 0x1C, 0x4C, 0x71,
  0xF9, 0x71, 0xC4, 0xC7, 0x1F, 0x97, 0x1C, 0x4C, 0x71, 0xF9, 0x71, 0xC4, 0xC7, 0x1F, 0x97, 0x1C,
  0x4C, 0x71, 0xF9, 0x71, 0xC4, 0xC7, 0x1F, 0x97, 0x1C, 0x4C, 0x71, 0xF9, 0x71, 0xC4, 0xC7, 0x1F,
  0xFE, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFA, 0x80, 0xA9, 0x40, 0xFF,
  0xA4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xFF, 0xA4, 0xC4, 0xC4, 0xC7,
  0x1C, 0x71, 0xC4, 0xF9, 0x71, 0xC7, 0x1C, 0x4F, 0x97, 0x1C, 0x71, 0xC4, 0xF9, 0x71, 0xC7, 0x1C,
  0x4F, 0x97, 0x1C, 0x4C, 0x4C, 0x4C, 0x71, 0xC4, 0xC4, 0xC4, 0xC7, 0x1C, 0x4C, 0x4C, 0x4C, 0x71,
  0xC4, 0xC4, 0xC4, 0xFF, 0xA7, 0x1C, 0x4F, 0xFE, 0x71, 0xC4, 0xFF, 0xE7, 0x1C, 0x4F, 0xFE, 0x71,
  0xC4, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_qr_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_qr_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_qr_code_scanner 48x48, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_outlined_48_communication_qr_code_scanner_data[] PROGMEM = {
  0xFB, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xF7, 0x77, 0x74, 0xF9,
  0x77, 0x77, 0x4F, 0x92, 0xFD, 0x4F, 0xD2, 0xF9, 0x2F, 0xD4, 0xFD, 0x2F, 0x92, 0xFD, 0x4F, 0xD2,
  0xF9, 0x2B, 0x6B, 0x4B, 0x6B, 0x2C, 0x6B, 0x6B, 0x4B, 0x6B, 0x75, 0xB6, 0xB4, 0xB6, 0xB7, 0x5B,
  0x6B, 0x4B, 0x6B, 0x75, 0xB6, 0xB4, 0xB6, 0xB7, 0x5B, 0x6B, 0x4B, 0x6B, 0x75, 0xFD, 0x4F, 0xD7,
  0x5F, 0xD4, 0xFD, 0x75, 0xFD, 0x4F, 0xD8, 0x0A, 0xD0, 0x0F, 0xD4, 0xB3, 0xB7, 0x71, 0xFD, 0x4B,
  0x3B, 0x77, 0x1F, 0xD4, 0xB3, 0xB7, 0x71, 0xB6, 0xB7, 0xB3, 0xB7, 0x5B, 0x6B, 0x7B, 0x3B, 0x75,
  0xB6, 0xB7, 0xB3, 0xB7, 0x5B, 0x6B, 0x4B, 0x3B, 0x77, 0x1B, 0x6B, 0x4B, 0x3B, 0x72, 0xC2, 0xB6,
  0xB4, 0xB3, 0xB5, 0xF9, 0x2F, 0xD7, 0xB3, 0xB2, 0xF9, 0x2F, 0xD7, 0xB3, 0xB2, 0xF9, 0x2F, 0xD7,
  0xB3, 0xB2, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xFF, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE,
  0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_qr_code_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_qr_code_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_read_more 48x48, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_48_communication_read_more_data[] PROGMEM = {
  0x75, 0x07, 0x72, 0xFF, 0xC7, 0x59, 0x07, 0x71, 0xFF, 0xC7, 0x5A, 0x07, 0x7F, 0xFC, 0x75, 0xB0,
  0x76, 0xFF, 0xC7, 0x5C, 0x07, 0x77, 0x77, 0x7D, 0x07, 0x77, 0x77, 0x6E, 0x07, 0x77, 0x77, 0x5F,
  0x07, 0x77, 0x6F, 0xFE, 0x07, 0x7F, 0xFF, 0xFD, 0x07, 0x6F, 0xFF, 0xFD, 0x07, 0x6F, 0xFF, 0xFC,
  0x07, 0x7F, 0xD7, 0x5F, 0x07, 0x77, 0x77, 0x4E, 0x07, 0x77, 0x77, 0x5D, 0x07, 0x77, 0x77, 0x6C,
  0x07, 0x77, 0x77, 0x7B, 0x07, 0x6F, 0xFC, 0x75, 0xA0, 0x77, 0xFF, 0xC7, 0x59, 0x07, 0x71, 0xFF,
  0xC7, 0x50, 0x77, 0x2F, 0xFC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_read_more() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 14, 43, 33), Box(0, 0, 47, 47),
      ic_outlined_48_communication_read_more_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_ring_volume 48x48, 4-bit Alpha,  RLE, 318 bytes.
static const unsigned char ic_outlined_48_communication_ring_volume_data[] PROGMEM = {
  0x77, 0x71, 0xC8, 0x0D, 0x00, 0xC8, 0x0D, 0x00, 0xC8, 0x0D, 0x00, 0xC8, 0x0D, 0x00, 0xC7, 0x77,
  0x72, 0x01, 0x76, 0xC7, 0x60, 0x17, 0x71, 0x81, 0x4F, 0x57, 0x5C, 0x75, 0x81, 0x5E, 0x47, 0x60,
  0x4B, 0x05, 0x74, 0xC7, 0x40, 0x5B, 0x04, 0x74, 0x01, 0x0E, 0xC0, 0x57, 0x3C, 0x73, 0x05, 0xC0,
  0xE0, 0x17, 0x40, 0x4D, 0x05, 0x72, 0xC7, 0x20, 0x5D, 0x04, 0x76, 0x04, 0xD0, 0x57, 0x76, 0x05,
  0xD0, 0x47, 0x71, 0x04, 0xD0, 0x57, 0x74, 0x05, 0xD0, 0x47, 0x73, 0x04, 0xD0, 0x47, 0x72, 0x04,
  0xD0, 0x47, 0x75, 0x04, 0xB0, 0xC0, 0x17, 0x72, 0x01, 0x0C, 0xB0, 0x47, 0x77, 0x82, 0x4F, 0xC1,
  0x77, 0x48, 0x21, 0xCF, 0x47, 0x77, 0x20, 0x40, 0x17, 0x76, 0x01, 0x04, 0x80, 0xBB, 0x00, 0x85,
  0x25, 0x8A, 0xCD, 0xEA, 0x85, 0xED, 0xCA, 0x85, 0x27, 0x77, 0x71, 0x81, 0x49, 0xDF, 0xFA, 0x81,
  0xD9, 0x47, 0x77, 0x28, 0x12, 0x9E, 0xFF, 0xF9, 0x81, 0xE9, 0x27, 0x74, 0x03, 0x0B, 0xFF, 0xFF,
  0x0B, 0x03, 0x77, 0x02, 0x0A, 0xF9, 0x84, 0xEB, 0x85, 0x31, 0x48, 0x41, 0x35, 0x8B, 0xEF, 0x90,
  0xA0, 0x27, 0x40, 0x8F, 0x90, 0xD0, 0x47, 0x72, 0x03, 0x0D, 0xF9, 0x08, 0x71, 0x02, 0x0C, 0xFA,
  0x0C, 0x77, 0x40, 0xCF, 0xA0, 0xC0, 0x25, 0x05, 0x0E, 0xD0, 0xC0, 0x6B, 0x0C, 0x77, 0x40, 0xCB,
  0x06, 0x0B, 0xD0, 0xE0, 0x53, 0x07, 0xD8, 0x2D, 0x50, 0x2B, 0x0C, 0x77, 0x40, 0xCB, 0x82, 0x30,
  0x5D, 0xD8, 0x17, 0x07, 0xD0, 0xA0, 0x12, 0x02, 0xB0, 0xC7, 0x74, 0x0C, 0xB0, 0x32, 0x01, 0x0A,
  0xD0, 0x70, 0xEC, 0x06, 0x40, 0x6B, 0x0C, 0x77, 0x40, 0xCB, 0x07, 0x40, 0x6C, 0x0E, 0x0C, 0xC0,
  0x82, 0x01, 0x0B, 0xC0, 0xC7, 0x74, 0x0C, 0xC0, 0xB0, 0x22, 0x08, 0xC8, 0x1C, 0x2E, 0xC8, 0x18,
  0x5E, 0xD0, 0x87, 0x74, 0x08, 0xD8, 0x1E, 0x58, 0xC8, 0x3E, 0x20, 0x2E, 0xFB, 0x08, 0x77, 0x60,
  0x8F, 0xB0, 0xE0, 0x23, 0x02, 0x0E, 0xF0, 0xB0, 0x27, 0x77, 0x10, 0x20, 0xBF, 0x0E, 0x02, 0x50,
  0x20, 0xED, 0x06, 0x77, 0x75, 0x06, 0xD0, 0xE0, 0x27, 0x02, 0x0E, 0xA0, 0xE0, 0x37, 0x77, 0x70,
  0x30, 0xEA, 0x0E, 0x02, 0x72, 0x82, 0x29, 0x91, 0x77, 0x77, 0x28, 0x21, 0x89, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_ring_volume() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 47, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_ring_volume_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_rss_feed 48x48, 4-bit Alpha,  RLE, 229 bytes.
static const unsigned char ic_outlined_48_communication_rss_feed_data[] PROGMEM = {
  0x01, 0x77, 0x77, 0x3B, 0x83, 0xEB, 0x96, 0x27, 0x77, 0x3F, 0x98, 0x1E, 0x94, 0x77, 0x7F, 0xC8,
  0x1D, 0x71, 0x77, 0x4F, 0xE0, 0xE0, 0x87, 0x73, 0xFF, 0x90, 0xD0, 0x57, 0x71, 0x83, 0x89, 0xAC,
  0xEF, 0xD0, 0xB0, 0x17, 0x74, 0x82, 0x26, 0xAE, 0xFA, 0x0D, 0x03, 0x77, 0x70, 0x60, 0xCF, 0xA0,
  0x57, 0x77, 0x10, 0x40, 0xCF, 0x90, 0x77, 0x77, 0x20, 0x60, 0xEF, 0x07, 0x77, 0x72, 0x02, 0x0C,
  0xF0, 0x57, 0x18, 0x3B, 0xB9, 0x74, 0x74, 0x09, 0xF0, 0x37, 0xE0, 0xA0, 0x47, 0x20, 0x8E, 0x0D,
  0x01, 0x6F, 0x90, 0xD0, 0x57, 0x10, 0x8E, 0x0B, 0x6F, 0xB0, 0xB0, 0x27, 0x09, 0xE0, 0x55, 0xFC,
  0x0E, 0x05, 0x70, 0xCD, 0x0D, 0x50, 0xDF, 0xD0, 0x76, 0x02, 0x0E, 0xD0, 0x86, 0x82, 0x15, 0xAE,
  0xF9, 0x07, 0x60, 0x6D, 0x0E, 0x01, 0x72, 0x07, 0x0E, 0xF0, 0x56, 0x0C, 0xD0, 0x77, 0x30, 0x10,
  0xBE, 0x0E, 0x02, 0x50, 0x4D, 0x0D, 0x75, 0x09, 0xE0, 0xB6, 0x0C, 0xD0, 0x47, 0x50, 0x9E, 0x05,
  0x50, 0x6D, 0x09, 0x48, 0x33, 0x8A, 0x71, 0x40, 0xBD, 0x0D, 0x60, 0xEC, 0x0E, 0x30, 0x8C, 0x0E,
  0x05, 0x30, 0x10, 0xED, 0x04, 0x50, 0xAD, 0x81, 0x20, 0x5E, 0x0E, 0x01, 0x30, 0x7D, 0x0A, 0x50,
  0x6D, 0x81, 0x60, 0xBF, 0x07, 0x40, 0xED, 0x50, 0x2D, 0x81, 0x90, 0xEF, 0x0A, 0x40, 0xAD, 0x04,
  0x50, 0xEC, 0x81, 0xB0, 0xCF, 0x08, 0x40, 0x5D, 0x07, 0x50, 0xCC, 0x81, 0xE0, 0x8F, 0x03, 0x40,
  0x1D, 0x09, 0x50, 0xAD, 0x20, 0xCD, 0x08, 0x6D, 0x0B, 0x50, 0x9D, 0x38, 0x38, 0xCE, 0xB5, 0x70,
  0xEC, 0x0B, 0x50, 0x8D, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_rss_feed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_rss_feed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_rtt 48x48, 4-bit Alpha,  RLE, 258 bytes.
static const unsigned char ic_outlined_48_communication_rtt_data[] PROGMEM = {
  0x77, 0xFF, 0xFC, 0x0E, 0x76, 0x02, 0xFF, 0xFC, 0x0B, 0x76, 0x05, 0xFF, 0xFC, 0x09, 0x76, 0x07,
  0xFF, 0xFC, 0x07, 0x30, 0x1F, 0x81, 0xE0, 0xAF, 0xFF, 0xC0, 0x43, 0x03, 0xF8, 0x1B, 0x0C, 0xC8,
  0x47, 0x11, 0x11, 0x7C, 0x84, 0xB1, 0x11, 0x13, 0xD0, 0x23, 0x06, 0xF8, 0x19, 0x0E, 0xC0, 0x44,
  0x08, 0xC0, 0x84, 0x04, 0xD4, 0x08, 0xF0, 0x70, 0x1D, 0x01, 0x40, 0xBC, 0x06, 0x40, 0x7C, 0x0C,
  0x76, 0x04, 0xC0, 0xE5, 0x0D, 0xC0, 0x34, 0x09, 0xC0, 0xA7, 0x60, 0x6C, 0x0C, 0x5D, 0x01, 0x40,
  0xBC, 0x08, 0x76, 0x09, 0xC0, 0xA4, 0x03, 0xC0, 0xE5, 0x0E, 0xC0, 0x57, 0x60, 0xBC, 0x07, 0x40,
  0x5C, 0x0B, 0x40, 0x1D, 0x03, 0x30, 0x4F, 0x81, 0xA0, 0xDC, 0x05, 0x40, 0x8C, 0x09, 0x40, 0x3D,
  0x40, 0x7F, 0x08, 0x1D, 0x02, 0x40, 0xAC, 0x07, 0x40, 0x6C, 0x0D, 0x40, 0x9F, 0x06, 0x18, 0x01,
  0x15, 0x0C, 0xC0, 0x45, 0x80, 0x11, 0x40, 0xBF, 0x03, 0x74, 0xD0, 0x27, 0x77, 0x75, 0x02, 0xD7,
  0x77, 0x76, 0x04, 0xC0, 0xC7, 0x77, 0x76, 0x07, 0xC0, 0xA7, 0x77, 0x76, 0x09, 0xC0, 0x87, 0x70,
  0x3F, 0xC0, 0xC7, 0x0B, 0xC0, 0x57, 0x70, 0x5F, 0xC0, 0x97, 0x0E, 0xC0, 0x37, 0x70, 0x8F, 0xC0,
  0x76, 0x01, 0xD7, 0x71, 0x0A, 0xFC, 0x05, 0x60, 0x3C, 0x0D, 0x77, 0x77, 0x60, 0x6C, 0x0B, 0x77,
  0x77, 0x60, 0x8C, 0x09, 0x77, 0x77, 0x60, 0xBC, 0x06, 0x77, 0x77, 0x60, 0xDC, 0x04, 0x77, 0x07,
  0xFC, 0x08, 0x7D, 0x01, 0x77, 0x09, 0xFC, 0x06, 0x60, 0x2C, 0x0E, 0x77, 0x10, 0xBF, 0xC0, 0x32,
  0x80, 0x01, 0x06, 0xC0, 0xD8, 0x00, 0x17, 0x40, 0xEF, 0xC8, 0x11, 0x02, 0xFF, 0x05, 0x77, 0x73,
  0x05, 0xFF, 0x03, 0x77, 0x73, 0x07, 0xFF, 0x77, 0x74, 0x09, 0xFE, 0x0D, 0x77, 0x74, 0x0C, 0xFE,
  0x0B, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_rtt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_rtt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_screen_share 48x48, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_outlined_48_communication_screen_share_data[] PROGMEM = {
  0x58, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0x80, 0xC0, 0xF0, 0xE0, 0x17,
  0x10, 0xA8, 0x0C, 0x2F, 0x0A, 0x71, 0x0D, 0x80, 0xC2, 0xF0, 0xD7, 0x1C, 0x77, 0x77, 0x4C, 0x71,
  0xC7, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x40, 0x87, 0x6C, 0x71, 0xC7, 0x74, 0x90, 0x97, 0x5C, 0x71,
  0xC7, 0x74, 0xA0, 0xA7, 0x4C, 0x71, 0xC7, 0x74, 0xB0, 0xB7, 0x3C, 0x71, 0xC7, 0x71, 0x81, 0x26,
  0x9C, 0x0B, 0x72, 0xC7, 0x1C, 0x76, 0x06, 0x0C, 0xF9, 0x0C, 0x01, 0x7C, 0x71, 0xC7, 0x40, 0x30,
  0xDF, 0xC0, 0xD0, 0x16, 0xC7, 0x1C, 0x73, 0x06, 0xFF, 0x0B, 0x6C, 0x71, 0xC7, 0x20, 0x6F, 0xF0,
  0xC0, 0x16, 0xC7, 0x1C, 0x71, 0x03, 0xFF, 0x0B, 0x71, 0xC7, 0x1C, 0x71, 0x0D, 0xD8, 0x2D, 0xA9,
  0x9C, 0x0B, 0x72, 0xC7, 0x1C, 0x70, 0x6B, 0x0A, 0x04, 0x5B, 0x0A, 0x73, 0xC7, 0x1C, 0x78, 0x2D,
  0xFA, 0x27, 0xA0, 0x97, 0x4C, 0x71, 0xC6, 0x81, 0x4F, 0x67, 0x29, 0x08, 0x75, 0xC7, 0x1C, 0x60,
  0x90, 0x47, 0x30, 0x77, 0x6C, 0x71, 0xC6, 0x04, 0x77, 0x74, 0xC7, 0x1C, 0x77, 0x77, 0x4C, 0x71,
  0xC7, 0x77, 0x74, 0xC7, 0x10, 0xD8, 0x0C, 0x2F, 0x0D, 0x71, 0x0A, 0x80, 0xC2, 0xF0, 0x97, 0x10,
  0x10, 0xE8, 0x0C, 0x0F, 0x0E, 0x01, 0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x15, 0x80,
  0xAF, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 8, 47, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_send_time_extension 48x48, 4-bit Alpha,  RLE, 280 bytes.
static const unsigned char ic_outlined_48_communication_send_time_extension_data[] PROGMEM = {
  0x77, 0x84, 0x4B, 0xEE, 0xB4, 0x77, 0x77, 0x50, 0x8E, 0x08, 0x77, 0x77, 0x30, 0x4F, 0x90, 0x47,
  0x77, 0x72, 0x0B, 0xF9, 0x0B, 0x77, 0x77, 0x20, 0xEB, 0x00, 0x3B, 0x0E, 0x77, 0x58, 0x11, 0x9D,
  0xFD, 0x2F, 0xD8, 0x1D, 0xA1, 0x70, 0x10, 0xEF, 0xF2, 0xFF, 0x0E, 0x01, 0x60, 0x9F, 0xF9, 0x2F,
  0xF9, 0x0A, 0x60, 0xDF, 0xF9, 0x2F, 0xF9, 0x0D, 0x6C, 0x77, 0x75, 0xC6, 0xC7, 0x77, 0x5C, 0x6C,
  0x77, 0x75, 0xC6, 0xC7, 0x77, 0x5C, 0x6C, 0x07, 0x01, 0x77, 0x73, 0xC6, 0xD0, 0xE0, 0x47, 0x77,
  0x2C, 0x6F, 0x05, 0x77, 0x71, 0xC6, 0x09, 0x0B, 0xE0, 0x37, 0x77, 0xC7, 0x20, 0x7C, 0x0C, 0x77,
  0x7C, 0x73, 0x05, 0xC0, 0x47, 0x76, 0xC7, 0x40, 0xAB, 0x09, 0x77, 0x6C, 0x74, 0x03, 0xB0, 0xC7,
  0x76, 0xC7, 0x5B, 0x0E, 0x73, 0x0B, 0x03, 0x71, 0x0B, 0xB7, 0x5B, 0x0E, 0x73, 0xA0, 0xB0, 0x37,
  0x04, 0x0B, 0x97, 0x40, 0x3B, 0x0D, 0x73, 0xC0, 0xB0, 0x37, 0x04, 0x74, 0x09, 0xB0, 0x97, 0x3E,
  0x0B, 0x03, 0x77, 0x20, 0x4C, 0x04, 0x73, 0xF9, 0x0B, 0x03, 0x76, 0x07, 0xC0, 0xC7, 0x4F, 0xB0,
  0xB0, 0x37, 0x10, 0x90, 0xBE, 0x03, 0x74, 0xFD, 0x0B, 0x03, 0x6F, 0x05, 0x75, 0xFF, 0x0B, 0x03,
  0x4D, 0x0E, 0x04, 0x68, 0x13, 0x9C, 0x48, 0x21, 0x59, 0xDF, 0xD0, 0xB0, 0x32, 0xC0, 0x70, 0x15,
  0x03, 0x0B, 0xB7, 0x18, 0x21, 0x59, 0xDF, 0xB0, 0xB0, 0x3C, 0x60, 0x5D, 0x71, 0x82, 0x15, 0x9D,
  0xFB, 0x0B, 0x03, 0xC5, 0x04, 0xE4, 0x82, 0x15, 0x9D, 0xFD, 0x0B, 0x03, 0x2C, 0x40, 0x10, 0xEC,
  0x0A, 0x04, 0x4F, 0xF0, 0xB0, 0x34, 0xC4, 0x07, 0xC0, 0x56, 0xFD, 0x0B, 0x03, 0x60, 0xDF, 0xC0,
  0x77, 0xFB, 0x0B, 0x03, 0x71, 0x0A, 0xFB, 0x0E, 0x71, 0xF9, 0x0B, 0x03, 0x73, 0x01, 0x0E, 0xFA,
  0x0B, 0x71, 0xE0, 0xB0, 0x37, 0x68, 0x11, 0xAD, 0xF0, 0x97, 0x1C, 0x0B, 0x03, 0x77, 0x77, 0x6A,
  0x0B, 0x03, 0x80, 0xC0, 0x00, 0xB0, 0x37, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_send_time_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 45, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_send_time_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_sentiment_satisfied_alt 48x48, 4-bit Alpha,  RLE, 381 bytes.
static const unsigned char ic_outlined_48_communication_sentiment_satisfied_alt_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xBD, 0x0D, 0x06, 0x75, 0x06,
  0x0D, 0xD0, 0xA7, 0x40, 0xBD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xD0, 0x37, 0x74,
  0x03, 0x0D, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xD0, 0x17, 0x77, 0x10, 0x10, 0xDB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x93,
  0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0D, 0x58, 0x28, 0xDD, 0x87, 0x38, 0x28,
  0xDD, 0x85, 0x0D, 0xB0, 0x82, 0x0D, 0xB0, 0x64, 0x08, 0xC0, 0x87, 0x10, 0x8C, 0x08, 0x40, 0x6B,
  0x81, 0xD0, 0x3C, 0x50, 0xDC, 0x0D, 0x71, 0x0D, 0xC0, 0xD5, 0xC0, 0x30, 0x7B, 0x0B, 0x50, 0xDC,
  0x0D, 0x71, 0x0D, 0xC0, 0xD5, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x50, 0x8C, 0x08, 0x71, 0x08, 0xC0,
  0x85, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x68, 0x28, 0xDD, 0x87, 0x38, 0x28, 0xDD, 0x86, 0x03, 0xB0,
  0xC0, 0xEB, 0x02, 0x77, 0x77, 0x20, 0x2B, 0x0E, 0xC7, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4C, 0x0E,
  0xB0, 0x27, 0x77, 0x72, 0x02, 0xB0, 0xE0, 0xCB, 0x03, 0x77, 0x77, 0x20, 0x3B, 0x0C, 0x0A, 0xB0,
  0x67, 0x77, 0x72, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x50, 0xEA, 0x07, 0x75, 0x07, 0xA0, 0xE5, 0x0B,
  0xB0, 0x70, 0x3C, 0x50, 0x7B, 0x04, 0x73, 0x04, 0xB0, 0x75, 0xC8, 0x13, 0x0D, 0xB0, 0x65, 0x0C,
  0xB0, 0x77, 0x10, 0x7B, 0x0C, 0x50, 0x6B, 0x0D, 0x20, 0x8B, 0x0D, 0x50, 0x10, 0xDB, 0x86, 0xD6,
  0x31, 0x13, 0x6D, 0xB0, 0xD0, 0x15, 0x0D, 0xB0, 0x82, 0x01, 0xC0, 0x75, 0x01, 0x0C, 0xFD, 0x0C,
  0x01, 0x50, 0x7C, 0x01, 0x30, 0x9C, 0x03, 0x60, 0x70, 0xEF, 0x90, 0xE0, 0x76, 0x03, 0xC0, 0x94,
  0x01, 0x0E, 0xB0, 0xD0, 0x17, 0x81, 0x6A, 0xDA, 0x81, 0xDA, 0x67, 0x01, 0x0D, 0xB0, 0xE0, 0x15,
  0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x57, 0x09, 0xC0, 0xD0, 0x37, 0x74, 0x03, 0x0D,
  0xC0, 0x97, 0x20, 0xBD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x74, 0x0B, 0xD0, 0xD0, 0x67, 0x50, 0x60,
  0xDD, 0x0A, 0x76, 0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x71, 0x05, 0x0E,
  0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8,
  0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_sentiment_satisfied_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_sentiment_satisfied_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_sip 48x48, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_outlined_48_communication_sip_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x20, 0x40, 0xDF, 0x92,
  0xC2, 0xF9, 0x0D, 0x04, 0x2F, 0x92, 0x0D, 0xFA, 0x2C, 0x2F, 0xA0, 0xD2, 0xF9, 0x2F, 0xB2, 0xC2,
  0xFB, 0x2F, 0x92, 0xB7, 0x2C, 0x2B, 0x4B, 0x2F, 0x92, 0xB8, 0x01, 0x70, 0x63, 0xC2, 0xB4, 0xB2,
  0xF9, 0x2F, 0xA0, 0xA2, 0xC2, 0xFB, 0x2F, 0x92, 0x0A, 0xFA, 0x2C, 0x2F, 0xA0, 0xD2, 0xF9, 0x30,
  0x68, 0x01, 0x7B, 0x2C, 0x2F, 0x90, 0xD0, 0x42, 0xF9, 0x72, 0xB2, 0xC2, 0xB7, 0x2F, 0x92, 0xFB,
  0x2C, 0x2B, 0x72, 0xF9, 0x2F, 0xA0, 0xD2, 0xC2, 0xB7, 0x2F, 0x92, 0xF9, 0x0D, 0x04, 0x2C, 0x2B,
  0x72, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9,
  0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xC0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8, 0x1A,
  0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_speaker_phone 48x48, 4-bit Alpha,  RLE, 218 bytes.
static const unsigned char ic_outlined_48_communication_speaker_phone_data[] PROGMEM = {
  0x73, 0x83, 0x48, 0xAD, 0xDA, 0x83, 0xDD, 0xA8, 0x47, 0x73, 0x81, 0x4A, 0xEF, 0xD8, 0x1E, 0xA4,
  0x75, 0x04, 0x0C, 0xFF, 0xC0, 0xC0, 0x47, 0x10, 0x10, 0xAF, 0xFF, 0x90, 0xA0, 0x15, 0x04, 0x0E,
  0xE8, 0x3E, 0x95, 0x32, 0x28, 0x32, 0x35, 0x9E, 0xE0, 0xE0, 0x43, 0x07, 0xE0, 0xA0, 0x37, 0x50,
  0x30, 0xAE, 0x81, 0x70, 0x3D, 0x0B, 0x03, 0x77, 0x20, 0x30, 0xBD, 0x81, 0x30, 0x6B, 0x06, 0x77,
  0x60, 0x6B, 0x06, 0x38, 0x16, 0xE4, 0x68, 0x90, 0x37, 0xBD, 0xEE, 0xDB, 0x73, 0x68, 0x14, 0xE6,
  0x50, 0x15, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x50, 0x17, 0x30, 0x20, 0xCF, 0xF0, 0xC0, 0x27, 0x60,
  0x40, 0xEF, 0xFA, 0x0E, 0x04, 0x75, 0x09, 0xD8, 0x6A, 0x63, 0x11, 0x36, 0xAD, 0x09, 0x76, 0x09,
  0xA0, 0xA0, 0x27, 0x10, 0x20, 0xAA, 0x09, 0x77, 0x10, 0x90, 0x77, 0x50, 0x70, 0x98, 0x09, 0xD4,
  0x00, 0x20, 0xCF, 0xD0, 0xC0, 0x27, 0x72, 0x0C, 0xFF, 0x0C, 0x77, 0x2F, 0xFA, 0x77, 0x2F, 0xFA,
  0x77, 0x2A, 0x75, 0xA7, 0x72, 0xA7, 0x5A, 0x77, 0x2A, 0x75, 0xA7, 0x72, 0xA7, 0x5A, 0x77, 0x2A,
  0x75, 0xA7, 0x72, 0xA7, 0x5A, 0x77, 0x2A, 0x75, 0xA7, 0x72, 0xA7, 0x5A, 0x77, 0x2A, 0x75, 0xA7,
  0x72, 0xA7, 0x5A, 0x77, 0x2A, 0x75, 0xA7, 0x72, 0xA7, 0x5A, 0x77, 0x2A, 0x75, 0xA7, 0x72, 0xA7,
  0x5A, 0x77, 0x2A, 0x75, 0xA7, 0x72, 0xA7, 0x5A, 0x77, 0x2F, 0xFA, 0x77, 0x2F, 0xFA, 0x77, 0x20,
  0xCF, 0xF0, 0xC7, 0x72, 0x02, 0x0C, 0xFD, 0x0C, 0x02, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_speaker_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_speaker_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_spoke 48x48, 4-bit Alpha,  RLE, 282 bytes.
static const unsigned char ic_outlined_48_communication_spoke_data[] PROGMEM = {
  0x77, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0x76, 0x09, 0xF9, 0x09, 0x77, 0x74, 0x0B, 0xFB, 0x0B,
  0x77, 0x72, 0x09, 0xFD, 0x09, 0x77, 0x70, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x27, 0x76, 0x08,
  0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x76, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0x76, 0x0E,
  0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x76, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE7, 0x76, 0x0C, 0xB0, 0x56,
  0x05, 0xB0, 0xC7, 0x76, 0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x76, 0x02, 0xC8, 0x4D,
  0x51, 0x15, 0xDC, 0x02, 0x77, 0x70, 0x9F, 0xD0, 0x97, 0x77, 0x20, 0xBF, 0xB0, 0xB7, 0x77, 0x40,
  0x9F, 0x90, 0x97, 0x77, 0x68, 0x62, 0x8C, 0xEE, 0xC8, 0x28, 0x0A, 0xB6, 0x08, 0x62, 0x8C, 0xEE,
  0xC8, 0x27, 0x58, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x73, 0x09, 0xF9, 0x09, 0x50,
  0xBF, 0xB0, 0xB7, 0x10, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x09, 0x60, 0x9F, 0xD8, 0x19, 0x02, 0xC8,
  0x4D, 0x51, 0x15, 0xDC, 0x02, 0x40, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC0, 0x20, 0x8B, 0x0D, 0x01,
  0x40, 0x10, 0xDB, 0x08, 0x40, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08, 0x0C, 0xB0, 0x56, 0x05,
  0xB0, 0xC4, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC0, 0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x40, 0xEB, 0x01,
  0x60, 0x1B, 0x00, 0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x40, 0xEB, 0x01, 0x60, 0x1B, 0x0E, 0x0C, 0xB0,
  0x56, 0x05, 0xB0, 0xC4, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC0, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB,
  0x08, 0x40, 0x8B, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08, 0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02,
  0x40, 0x2C, 0x84, 0xD5, 0x11, 0x5D, 0xC8, 0x12, 0x09, 0xFD, 0x09, 0x60, 0x9F, 0xD0, 0x93, 0x0B,
  0xFB, 0x0B, 0x71, 0x0B, 0xFB, 0x0B, 0x50, 0x9F, 0x90, 0x97, 0x30, 0x9F, 0x90, 0x97, 0x86, 0x28,
  0xCE, 0xEC, 0x82, 0x75, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_spoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_spoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_stay_current_landscape 48x48, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_outlined_48_communication_stay_current_landscape_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0x98, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDF, 0x97, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77,
  0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA,
  0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77,
  0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7,
  0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xF9, 0x0D, 0x80, 0xC6,
  0xF0, 0xD0, 0xA8, 0x0C, 0x6F, 0x81, 0xA1, 0xE8, 0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC0,
  0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_stay_current_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_outlined_48_communication_stay_current_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_stay_current_portrait 48x48, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_outlined_48_communication_stay_current_portrait_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x19, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0x9E, 0x0F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x0F, 0x0D,
  0xFF, 0xFD, 0x0D, 0x09, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_stay_current_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_stay_current_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_stay_primary_landscape 48x48, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_outlined_48_communication_stay_primary_landscape_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0x98, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDF, 0x97, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77,
  0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA,
  0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77,
  0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7,
  0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xF9, 0x0D, 0x80, 0xC6,
  0xF0, 0xD0, 0xA8, 0x0C, 0x6F, 0x81, 0xA1, 0xE8, 0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC0,
  0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_stay_primary_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_outlined_48_communication_stay_primary_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_stay_primary_portrait 48x48, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_outlined_48_communication_stay_primary_portrait_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xE8, 0x4D, 0x91, 0x01, 0xEF, 0xFF, 0xB8, 0x1E, 0x19, 0xFF, 0xFD, 0x0A,
  0x0D, 0xFF, 0xFD, 0x0D, 0x80, 0x9E, 0x0F, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76,
  0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9,
  0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77,
  0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F,
  0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0xF9, 0x77, 0x6F, 0x97, 0x76, 0x80, 0x9E, 0x0F, 0x0D,
  0xFF, 0xFD, 0x0D, 0x09, 0xFF, 0xFD, 0x81, 0xA1, 0xEF, 0xFF, 0xB8, 0x4E, 0x10, 0x1A, 0xDF, 0xFE,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_stay_primary_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 2, 37, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_stay_primary_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_stop_screen_share 48x48, 4-bit Alpha,  RLE, 328 bytes.
static const unsigned char ic_outlined_48_communication_stop_screen_share_data[] PROGMEM = {
  0x40, 0x50, 0x68, 0x0D, 0x10, 0x05, 0xA0, 0x68, 0x0C, 0x70, 0x05, 0xC0, 0x68, 0x0C, 0x60, 0x04,
  0xD0, 0x68, 0x0C, 0x60, 0x04, 0xD0, 0x68, 0x0C, 0x60, 0x04, 0xD0, 0x64, 0x01, 0x0D, 0xFF, 0xFA,
  0x81, 0xD9, 0x17, 0x20, 0x20, 0xED, 0x06, 0x40, 0x10, 0xDF, 0xFF, 0xB0, 0xE0, 0x17, 0x10, 0xAF,
  0x06, 0x40, 0x10, 0xDF, 0xFF, 0xB0, 0x97, 0x10, 0xEF, 0x90, 0x64, 0x01, 0x0D, 0xFF, 0xFA, 0x0D,
  0x71, 0xC0, 0x4D, 0x06, 0x77, 0x74, 0xC7, 0x1C, 0x10, 0x4D, 0x06, 0x77, 0x73, 0xC7, 0x1C, 0x20,
  0x4D, 0x06, 0x72, 0x08, 0x76, 0xC7, 0x1C, 0x30, 0x4D, 0x06, 0x71, 0x90, 0x97, 0x5C, 0x71, 0xC4,
  0x04, 0xD0, 0x67, 0xA0, 0xA7, 0x4C, 0x71, 0xC5, 0x04, 0xD0, 0x66, 0xB0, 0xB7, 0x3C, 0x71, 0xC6,
  0x04, 0xD0, 0x65, 0x0D, 0xB0, 0xB7, 0x2C, 0x71, 0xC7, 0x04, 0xD0, 0x64, 0x01, 0x0D, 0xB0, 0xC0,
  0x17, 0xC7, 0x1C, 0x71, 0x04, 0x0E, 0xC0, 0x64, 0x01, 0x0D, 0xB0, 0xD0, 0x16, 0xC7, 0x1C, 0x72,
  0x04, 0xD0, 0x64, 0x01, 0x0C, 0xB0, 0xB6, 0xC7, 0x1C, 0x72, 0x05, 0xE0, 0x64, 0x83, 0x1C, 0xFC,
  0x16, 0xC7, 0x1C, 0x71, 0x03, 0xF9, 0x06, 0x40, 0x10, 0x97, 0x1C, 0x71, 0xC7, 0x10, 0xCF, 0xA0,
  0x67, 0x6C, 0x71, 0xC7, 0x06, 0xB8, 0x1A, 0x54, 0xD0, 0x67, 0x5C, 0x71, 0xC7, 0x82, 0xDF, 0xB2,
  0x30, 0x4D, 0x06, 0x74, 0xC7, 0x1C, 0x68, 0x14, 0xF7, 0x60, 0x4D, 0x06, 0x73, 0xC7, 0x1C, 0x60,
  0x90, 0x57, 0x10, 0x4D, 0x06, 0x72, 0xC7, 0x1C, 0x60, 0x47, 0x30, 0x4D, 0x06, 0x71, 0xC7, 0x1C,
  0x77, 0x40, 0x4D, 0x06, 0x7C, 0x71, 0xC7, 0x75, 0x04, 0xD0, 0x66, 0xC7, 0x10, 0xDF, 0xFF, 0xF9,
  0x06, 0x50, 0xCA, 0x0E, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0x64, 0x82, 0x1C, 0xFA, 0x71, 0x01, 0x0E,
  0xFF, 0xFF, 0xA0, 0x64, 0x81, 0x1B, 0x27, 0x28, 0x11, 0x9D, 0xFF, 0xFF, 0x90, 0x67, 0x38, 0x0C,
  0x2F, 0x06, 0x40, 0x10, 0xC8, 0x0C, 0x6F, 0x06, 0x40, 0x10, 0xC8, 0x0C, 0x6F, 0x06, 0x40, 0x10,
  0xC8, 0x0C, 0x6F, 0x06, 0x40, 0x10, 0xC8, 0x0C, 0x00, 0x04, 0x0E, 0xC0, 0x68, 0x0C, 0x60, 0x04,
  0x0E, 0xC0, 0x68, 0x0C, 0x60, 0x04, 0x0E, 0xC0, 0x38, 0x0C, 0x60, 0x04, 0x0E, 0xA0, 0x98, 0x0D,
  0x00, 0x81, 0x4E, 0x98, 0x0D, 0x20, 0x02, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_stop_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 47, 45), Box(0, 0, 47, 47),
      ic_outlined_48_communication_stop_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_swap_calls 48x48, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_outlined_48_communication_swap_calls_data[] PROGMEM = {
  0x73, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x76, 0x00, 0x77, 0x72, 0x09, 0xF9, 0x09, 0x74, 0x07, 0xA0,
  0x77, 0x70, 0xBF, 0xB0, 0xB7, 0x20, 0x7C, 0x07, 0x75, 0x09, 0xFD, 0x09, 0x70, 0x7E, 0x07, 0x73,
  0x02, 0xC8, 0x4D, 0x51, 0x15, 0xDC, 0x02, 0x50, 0x7F, 0x90, 0x77, 0x20, 0x8B, 0x0D, 0x01, 0x40,
  0x10, 0xDB, 0x08, 0x40, 0x7F, 0xB0, 0x77, 0x10, 0xCB, 0x05, 0x60, 0x5B, 0x0C, 0x30, 0x7F, 0xD0,
  0x77, 0x0E, 0xB0, 0x16, 0x01, 0xB0, 0xE2, 0x07, 0xFF, 0x07, 0x6C, 0x71, 0xC7, 0x1C, 0x75, 0xC7,
  0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C,
  0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71,
  0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7, 0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC7,
  0x5C, 0x71, 0xC7, 0x1C, 0x75, 0xC7, 0x1C, 0x71, 0xC6, 0x07, 0xFF, 0x07, 0x20, 0xEB, 0x01, 0x60,
  0x1B, 0x0E, 0x70, 0x7F, 0xD0, 0x73, 0x0C, 0xB0, 0x56, 0x05, 0xB0, 0xC7, 0x10, 0x7F, 0xB0, 0x74,
  0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0x87, 0x20, 0x7F, 0x90, 0x75, 0x02, 0xC8, 0x4D, 0x51,
  0x15, 0xDC, 0x02, 0x73, 0x07, 0xE0, 0x77, 0x09, 0xFD, 0x09, 0x75, 0x07, 0xC0, 0x77, 0x20, 0xBF,
  0xB0, 0xB7, 0x70, 0x7A, 0x07, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x20, 0x07, 0x76, 0x86, 0x28, 0xCE,
  0xEC, 0x82, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_swap_calls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 37), Box(0, 0, 47, 47),
      ic_outlined_48_communication_swap_calls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_textsms 48x48, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_outlined_48_communication_textsms_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDC, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77,
  0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x6C, 0x4C, 0x4C, 0x6F, 0x96, 0xC4,
  0xC4, 0xC6, 0xF9, 0x6C, 0x4C, 0x4C, 0x6F, 0x96, 0xC4, 0xC4, 0xC6, 0xF9, 0x77, 0x77, 0x4F, 0x97,
  0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74,
  0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x74, 0xF9, 0x30,
  0x7F, 0xFF, 0xFB, 0x0D, 0xC2, 0x07, 0xFF, 0xFF, 0xC0, 0xAC, 0x10, 0x7F, 0xFF, 0xFC, 0x0E, 0x01,
  0xC0, 0x7F, 0xFF, 0xFB, 0x81, 0xDA, 0x11, 0xF0, 0x77, 0x77, 0x74, 0xE0, 0x77, 0x77, 0x75, 0xD0,
  0x77, 0x77, 0x76, 0xC0, 0x77, 0x77, 0x77, 0xB0, 0x78, 0x0C, 0x00, 0xA0, 0x78, 0x0C, 0x10, 0x90,
  0x78, 0x0C, 0x20, 0x07, 0x80, 0xC3, 0x00,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_textsms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_outlined_48_communication_textsms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_unsubscribe 48x48, 4-bit Alpha,  RLE, 221 bytes.
static const unsigned char ic_outlined_48_communication_unsubscribe_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x81, 0xD9, 0x13, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x12, 0x0A,
  0xFF, 0xFF, 0xE0, 0x92, 0x0D, 0xFF, 0xFF, 0xE0, 0xD2, 0xC0, 0xB0, 0x37, 0x77, 0x30, 0x40, 0xBC,
  0x2E, 0x0B, 0x03, 0x77, 0x60, 0x30, 0xBE, 0x2F, 0x90, 0xB0, 0x37, 0x72, 0x03, 0x0B, 0xF9, 0x2F,
  0xB0, 0xB0, 0x37, 0x50, 0x30, 0xBF, 0xB2, 0xC0, 0x30, 0xBE, 0x0B, 0x03, 0x71, 0x03, 0x0B, 0xE0,
  0xB0, 0x3C, 0x2C, 0x20, 0x30, 0xBE, 0x0B, 0x03, 0x40, 0x30, 0xBE, 0x0B, 0x03, 0x2C, 0x2C, 0x40,
  0x30, 0xBE, 0x82, 0xB3, 0x3B, 0xE0, 0xB0, 0x34, 0xC2, 0xC6, 0x03, 0x0B, 0xFD, 0x0B, 0x03, 0x6C,
  0x2C, 0x71, 0x03, 0x0B, 0xF9, 0x0B, 0x03, 0x71, 0xC2, 0xC7, 0x30, 0x30, 0xBC, 0x0B, 0x03, 0x73,
  0xC2, 0xC7, 0x58, 0x23, 0xBB, 0x37, 0x5C, 0x2C, 0x77, 0x77, 0xC2, 0xC7, 0x77, 0x7C, 0x2C, 0x77,
  0x77, 0xC2, 0xC7, 0x77, 0x7C, 0x2C, 0x77, 0x77, 0xC2, 0xC7, 0x77, 0x28, 0x31, 0x7C, 0xEE, 0xC2,
  0xC7, 0x77, 0x10, 0x40, 0xEF, 0x92, 0xC7, 0x77, 0x04, 0xFB, 0x04, 0x1C, 0x77, 0x60, 0x10, 0xDF,
  0xB8, 0x1E, 0x1D, 0x80, 0xC0, 0xF0, 0x70, 0xA8, 0x0C, 0x0F, 0x81, 0xC1, 0xEF, 0xFF, 0xC7, 0x1A,
  0x83, 0xE0, 0x1A, 0xDF, 0xFF, 0xA7, 0x1A, 0x0E, 0x77, 0x73, 0x0B, 0xFD, 0x0C, 0x77, 0x73, 0x07,
  0xFD, 0x07, 0x77, 0x73, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x74, 0x04, 0xFB, 0x04, 0x77, 0x76,
  0x04, 0x0E, 0xE0, 0xE0, 0x47, 0x77, 0x71, 0x86, 0x17, 0xCE, 0xEC, 0x71, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_unsubscribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 43, 39), Box(0, 0, 47, 47),
      ic_outlined_48_communication_unsubscribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_voicemail 48x48, 4-bit Alpha,  RLE, 267 bytes.
static const unsigned char ic_outlined_48_communication_voicemail_data[] PROGMEM = {
  0x68, 0x90, 0x15, 0xAD, 0xEE, 0xDA, 0x51, 0x77, 0x28, 0x90, 0x15, 0xAD, 0xEE, 0xDA, 0x51, 0x74,
  0x07, 0x0E, 0xF9, 0x0E, 0x07, 0x77, 0x07, 0x0E, 0xF9, 0x0E, 0x07, 0x71, 0x01, 0x0C, 0xFD, 0x0C,
  0x01, 0x73, 0x01, 0x0C, 0xFD, 0x0C, 0x01, 0x50, 0x10, 0xDF, 0xF0, 0xD0, 0x17, 0x10, 0x10, 0xDF,
  0xF0, 0xD0, 0x14, 0x0C, 0xC8, 0x1E, 0x72, 0x28, 0x12, 0x7E, 0xC0, 0xC7, 0x10, 0xCC, 0x81, 0xE7,
  0x22, 0x81, 0x27, 0xEC, 0x0C, 0x30, 0x7C, 0x0A, 0x71, 0x0A, 0xC0, 0x76, 0x07, 0xC0, 0xA7, 0x10,
  0xAC, 0x82, 0x70, 0x1E, 0xB0, 0xA7, 0x30, 0xAB, 0x0E, 0x01, 0x40, 0x10, 0xEB, 0x0A, 0x73, 0x0A,
  0xB8, 0x1E, 0x15, 0xB0, 0xE7, 0x50, 0xEB, 0x05, 0x40, 0x5B, 0x0E, 0x75, 0x0E, 0xB0, 0x50, 0xAB,
  0x07, 0x75, 0x07, 0xB0, 0xA4, 0x0A, 0xB0, 0x77, 0x50, 0x7B, 0x0A, 0x0D, 0xB0, 0x27, 0x50, 0x2B,
  0x0D, 0x40, 0xDB, 0x02, 0x75, 0x02, 0xB0, 0xD0, 0xEB, 0x77, 0xB0, 0xE4, 0x0E, 0xB7, 0x7B, 0x00,
  0xEB, 0x77, 0xB0, 0xE4, 0x0E, 0xB7, 0x7B, 0x0E, 0x0D, 0xB0, 0x27, 0x50, 0x2B, 0x0D, 0x40, 0xDB,
  0x02, 0x75, 0x02, 0xB0, 0xD0, 0xAB, 0x07, 0x75, 0x07, 0xB0, 0xA4, 0x0A, 0xB0, 0x77, 0x50, 0x7B,
  0x0A, 0x05, 0xB0, 0xE7, 0x50, 0xEB, 0x06, 0x40, 0x6B, 0x0E, 0x75, 0x0E, 0xB8, 0x15, 0x1E, 0xB0,
  0xA7, 0x30, 0xAB, 0x0E, 0x60, 0xEB, 0x0A, 0x73, 0x0A, 0xB8, 0x2E, 0x10, 0x7C, 0x0A, 0x71, 0x0A,
  0xC0, 0x76, 0x07, 0xC0, 0xA7, 0x10, 0xAC, 0x07, 0x30, 0xCC, 0x81, 0xE7, 0x22, 0x81, 0x27, 0xEC,
  0x0C, 0x71, 0x0C, 0xC8, 0x1E, 0x72, 0x28, 0x12, 0x7E, 0xC0, 0xC4, 0x01, 0x0D, 0x80, 0xC4, 0xF0,
  0xD0, 0x15, 0x01, 0x0C, 0x80, 0xC2, 0xF0, 0xC0, 0x17, 0x10, 0x70, 0xEF, 0xFF, 0xFE, 0x0E, 0x07,
  0x74, 0x83, 0x15, 0xAD, 0xEF, 0xFF, 0xD8, 0x3E, 0xDA, 0x51, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_voicemail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 12, 47, 33), Box(0, 0, 47, 47),
      ic_outlined_48_communication_voicemail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_vpn_key_off 48x48, 4-bit Alpha,  RLE, 325 bytes.
static const unsigned char ic_outlined_48_communication_vpn_key_off_data[] PROGMEM = {
  0x30, 0x28, 0x0C, 0x60, 0x81, 0x4F, 0x78, 0x0C, 0x40, 0x04, 0xB0, 0x78, 0x0C, 0x30, 0x0E, 0xC0,
  0x78, 0x0C, 0x20, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x20, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x20, 0x03,
  0x0E, 0xC0, 0x78, 0x0C, 0x20, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x20, 0x05, 0xD0, 0x78, 0x0C, 0x00,
  0x05, 0x0E, 0xE0, 0x77, 0x77, 0x76, 0x06, 0xFA, 0x07, 0x77, 0x77, 0x40, 0x5D, 0x0D, 0x0E, 0xC0,
  0x77, 0x77, 0x72, 0x01, 0x0E, 0xB8, 0x3E, 0x70, 0x3E, 0xC0, 0x77, 0x77, 0x71, 0x09, 0xC0, 0x43,
  0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xF0, 0x1C, 0x06, 0x50, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFE,
  0x07, 0xB0, 0xD4, 0x81, 0x1A, 0xDE, 0x07, 0x50, 0xCF, 0xFD, 0x0B, 0xB0, 0x63, 0x01, 0x0E, 0xFA,
  0x07, 0x50, 0xCF, 0xFC, 0x0D, 0xB0, 0x33, 0x0A, 0xFC, 0x07, 0x77, 0x5C, 0x0E, 0xB0, 0x13, 0x0D,
  0xF0, 0xEC, 0x07, 0x77, 0x4C, 0x0E, 0xB4, 0x0D, 0xE8, 0x1D, 0x3E, 0xC0, 0x77, 0x73, 0xC0, 0xDB,
  0x02, 0x30, 0xAE, 0x82, 0xA0, 0x3E, 0xC0, 0x77, 0x72, 0xC0, 0xBB, 0x06, 0x30, 0x10, 0xEC, 0x0E,
  0x01, 0x20, 0x30, 0xEC, 0x07, 0x50, 0xC9, 0x4F, 0x90, 0x6B, 0x0C, 0x48, 0x41, 0xAD, 0xDA, 0x14,
  0x0C, 0xD0, 0x75, 0x0C, 0x4F, 0x90, 0x1C, 0x06, 0x75, 0x06, 0xF0, 0x77, 0x2F, 0x91, 0x09, 0xC0,
  0x47, 0x30, 0x5F, 0xA0, 0x77, 0x1F, 0x91, 0x01, 0x0E, 0xC0, 0x67, 0x10, 0x6C, 0x81, 0xE4, 0xEC,
  0x07, 0x7C, 0x60, 0x4D, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x82, 0x50, 0x3E, 0xC0, 0x76, 0xC7,
  0x06, 0xFF, 0xA0, 0x63, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0xB7, 0x10, 0x40, 0xEF, 0xD0, 0xE0, 0x55,
  0x03, 0x0E, 0xC0, 0x75, 0x07, 0xA7, 0x20, 0x10, 0x9F, 0xB0, 0x90, 0x17, 0x03, 0x0E, 0xC0, 0x75,
  0x07, 0x97, 0x48, 0x90, 0x16, 0xAD, 0xEF, 0xDA, 0x71, 0x73, 0x03, 0x0E, 0xC0, 0x75, 0x07, 0x77,
  0x77, 0x40, 0x30, 0xEC, 0x07, 0x80, 0xC2, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC2, 0x00, 0x30, 0xEC,
  0x07, 0x80, 0xC2, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC2, 0x00, 0x30, 0xEC, 0x07, 0x80, 0xC2, 0x00,
  0x30, 0xEC, 0x07, 0x80, 0xC2, 0x00, 0x30, 0xEC, 0x02, 0x80, 0xC2, 0x00, 0x30, 0xEA, 0x04, 0x80,
  0xC4, 0x08, 0x13, 0xE4, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_vpn_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 45, 44), Box(0, 0, 47, 47),
      ic_outlined_48_communication_vpn_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_vpn_key 48x48, 4-bit Alpha,  RLE, 274 bytes.
static const unsigned char ic_outlined_48_communication_vpn_key_data[] PROGMEM = {
  0x72, 0x89, 0x03, 0x7B, 0xDE, 0xFD, 0xB8, 0x38, 0x0C, 0x00, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x77,
  0x77, 0x40, 0x10, 0xBF, 0xF0, 0xC0, 0x27, 0x77, 0x71, 0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x47, 0x77,
  0x60, 0x3E, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAD, 0x0E, 0x04, 0x77, 0x74, 0x01, 0x0E, 0xC0, 0xA0,
  0x27, 0x10, 0x10, 0xAC, 0x0E, 0x02, 0x77, 0x73, 0x0B, 0xC0, 0x77, 0x50, 0x6C, 0x0C, 0x77, 0x72,
  0x05, 0xC0, 0x77, 0x70, 0x6C, 0x05, 0x77, 0x71, 0x0D, 0xB0, 0xA5, 0x84, 0x6C, 0xEE, 0xC6, 0x50,
  0xAF, 0xFF, 0xC0, 0x3C, 0x02, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x30, 0x1F, 0xFF, 0xC0, 0x7B, 0x0A,
  0x40, 0xCF, 0x90, 0xC4, 0x0A, 0xFF, 0xFB, 0x0B, 0xB0, 0x53, 0x06, 0xFB, 0x06, 0x30, 0x4F, 0xFF,
  0xB0, 0xDB, 0x02, 0x30, 0xCB, 0x82, 0xB1, 0x1B, 0xB0, 0xC7, 0x77, 0x3C, 0x0E, 0xB4, 0x0E, 0xB0,
  0x12, 0x01, 0xB0, 0xE7, 0x77, 0x3C, 0x0E, 0xB4, 0x0E, 0xB0, 0x12, 0x01, 0xB0, 0xE7, 0x77, 0x3C,
  0x0D, 0xB0, 0x23, 0x0C, 0xB8, 0x2B, 0x11, 0xBB, 0x0C, 0x77, 0x73, 0xC0, 0xBB, 0x05, 0x30, 0x6F,
  0xB0, 0x63, 0x04, 0xFD, 0x4F, 0x90, 0x7B, 0x0A, 0x40, 0xCF, 0x90, 0xC4, 0x0A, 0xFD, 0x4F, 0x90,
  0x3C, 0x02, 0x30, 0x10, 0xCE, 0x0C, 0x01, 0x30, 0x1F, 0xE4, 0xF9, 0x10, 0xDB, 0x0A, 0x58, 0x46,
  0xCE, 0xEC, 0x65, 0x0A, 0xFE, 0x4F, 0x91, 0x05, 0xC0, 0x77, 0x70, 0x6C, 0x05, 0x5C, 0x4C, 0x60,
  0xBC, 0x07, 0x75, 0x06, 0xC0, 0xC6, 0xC4, 0xC6, 0x01, 0x0E, 0xC0, 0xA0, 0x27, 0x10, 0x10, 0xAC,
  0x0E, 0x02, 0x6C, 0x4C, 0x70, 0x3E, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAE, 0x04, 0x7C, 0x4C, 0x71,
  0x03, 0x0E, 0xFF, 0xA0, 0xE0, 0x47, 0x1F, 0xD7, 0x20, 0x10, 0xBF, 0xF0, 0xC0, 0x27, 0x2F, 0xD7,
  0x40, 0x50, 0xDF, 0xB0, 0xD0, 0x57, 0x4F, 0xD7, 0x68, 0x90, 0x37, 0xBD, 0xEF, 0xDB, 0x83, 0x76,
  0xFD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_vpn_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 10, 47, 37), Box(0, 0, 47, 47),
      ic_outlined_48_communication_vpn_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_48_communication_wifi_calling 48x48, 4-bit Alpha,  RLE, 289 bytes.
static const unsigned char ic_outlined_48_communication_wifi_calling_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xD0, 0x47, 0x38, 0x31, 0x59, 0xCD, 0xA8, 0x3D, 0xC9, 0x51, 0x50, 0xDF, 0xA0,
  0xD7, 0x10, 0x40, 0xAF, 0xD0, 0xA0, 0x43, 0xFC, 0x60, 0x20, 0xBF, 0xFA, 0x82, 0xB2, 0x0E, 0xFB,
  0x01, 0x40, 0x7F, 0xFE, 0x07, 0x0D, 0xB0, 0x12, 0x0D, 0xB0, 0x34, 0x08, 0xFF, 0xE0, 0x80, 0xCB,
  0x04, 0x20, 0xBB, 0x04, 0x50, 0xBF, 0xFC, 0x81, 0xB0, 0xAB, 0x06, 0x20, 0x9B, 0x07, 0x50, 0x10,
  0xDF, 0xFA, 0x82, 0xD1, 0x07, 0xB0, 0x82, 0x06, 0xB0, 0xB6, 0x03, 0xFF, 0xA0, 0x32, 0x05, 0xB0,
  0xB2, 0x02, 0xB0, 0xE7, 0x06, 0xFF, 0x06, 0x30, 0x2C, 0x20, 0x5C, 0x02, 0x70, 0x9F, 0xD0, 0x95,
  0x0D, 0xB0, 0x40, 0x5D, 0x01, 0x71, 0x0C, 0xFB, 0x0C, 0x60, 0x9B, 0x0C, 0xD0, 0x57, 0x20, 0x20,
  0xEF, 0x90, 0xE0, 0x26, 0x05, 0xF9, 0x05, 0x74, 0x04, 0xF9, 0x04, 0x71, 0x0E, 0xE0, 0x57, 0x60,
  0x7E, 0x07, 0x72, 0x09, 0xD0, 0x57, 0x71, 0x0B, 0xC0, 0xB7, 0x30, 0x3C, 0x07, 0x77, 0x20, 0x10,
  0xDA, 0x0D, 0x01, 0x74, 0x0B, 0xB0, 0xB7, 0x73, 0x03, 0xA0, 0x37, 0x50, 0x3C, 0x05, 0x77, 0x30,
  0x06, 0x77, 0x0B, 0xB0, 0xD0, 0x17, 0x77, 0x74, 0x02, 0xC0, 0xA7, 0x77, 0x75, 0x07, 0xC0, 0x67,
  0x77, 0x75, 0x0C, 0xC0, 0x37, 0x77, 0x74, 0x02, 0x0E, 0xB0, 0xE0, 0x37, 0x77, 0x74, 0x05, 0xC0,
  0xE0, 0x37, 0x40, 0x10, 0x27, 0x75, 0x06, 0xC0, 0xE0, 0x37, 0x28, 0x75, 0xEF, 0xEB, 0x74, 0x21,
  0x77, 0x08, 0xD0, 0x67, 0x05, 0xFB, 0x0D, 0x04, 0x75, 0x08, 0xD0, 0xA0, 0x14, 0x05, 0xFD, 0x0D,
  0x76, 0x06, 0xD0, 0xD0, 0x52, 0x05, 0xFF, 0x77, 0x05, 0x0E, 0xD0, 0xB0, 0x7D, 0x84, 0x53, 0x6A,
  0xCD, 0xC7, 0x71, 0x02, 0x0C, 0xFB, 0x05, 0x6C, 0x77, 0x30, 0x7F, 0x90, 0xC0, 0x46, 0xC7, 0x74,
  0x02, 0x0B, 0xFA, 0x83, 0xB8, 0x64, 0x2C, 0x77, 0x60, 0x30, 0xBF, 0xFA, 0x77, 0x71, 0x81, 0x39,
  0xEF, 0xE7, 0x77, 0x48, 0x15, 0x9D, 0xFA, 0x0D, 0x77, 0x77, 0x89, 0x02, 0x58, 0xAC, 0xDD, 0xFD,
  0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_48_communication_wifi_calling() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 43, 41), Box(0, 0, 47, 47),
      ic_outlined_48_communication_wifi_calling_data, Alpha4(color::Black));
  return value;
}
