#include "device.h"

using namespace roo_display;

// Image file ic_outlined_18_device_1x_mobiledata 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_outlined_18_device_1x_mobiledata_data[] PROGMEM = {
  0x89, 0x63, 0x99, 0x20, 0x19, 0x30, 0x39, 0x24, 0xBF, 0x42, 0x83, 0xAD, 0x0C, 0xB3, 0x90, 0x42,
  0x83, 0x2F, 0xBF, 0x33, 0x90, 0x43, 0x81, 0x8F, 0x94, 0x90, 0x43, 0x81, 0x8F, 0x94, 0x90, 0x42,
  0x83, 0x2F, 0xBF, 0x33, 0x90, 0x42, 0x83, 0xAD, 0x0C, 0xB3, 0x89, 0x09, 0x20, 0x19, 0x30, 0x39,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_1x_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 14, 12), Box(0, 0, 17, 17),
      ic_outlined_18_device_1x_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_30fps 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_outlined_18_device_30fps_data[] PROGMEM = {
  0x84, 0x27, 0x77, 0x71, 0x28, 0x56, 0x77, 0x72, 0x04, 0xC8, 0x1D, 0x0B, 0xC8, 0x96, 0xE1, 0x13,
  0x33, 0xBF, 0x1F, 0xD3, 0x39, 0xF4, 0x48, 0x3A, 0xF0, 0xFC, 0x28, 0x92, 0x7F, 0x40, 0xBD, 0xDE,
  0x70, 0xFC, 0x28, 0x92, 0x7F, 0x40, 0xBD, 0xDE, 0x70, 0xFC, 0x28, 0x17, 0xF4, 0x48, 0x3A, 0xF0,
  0xFC, 0x28, 0xA0, 0x7F, 0x41, 0x33, 0x3B, 0xF1, 0xFD, 0x33, 0x9F, 0x44, 0xC8, 0x1D, 0x0B, 0xC8,
  0x6E, 0x12, 0x77, 0x77, 0x12, 0x83, 0x67, 0x77, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_30fps() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_outlined_18_device_30fps_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_3g_mobiledata 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_outlined_18_device_3g_mobiledata_data[] PROGMEM = {
  0x8F, 0x25, 0xBB, 0x80, 0x7B, 0xBA, 0x21, 0x33, 0xD1, 0xE3, 0x33, 0x10, 0x47, 0xB0, 0xD1, 0x77,
  0x30, 0x47, 0xB0, 0xD1, 0x7A, 0x71, 0x33, 0xD1, 0xE3, 0x38, 0x75, 0xBB, 0x80, 0x7B, 0xBA, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_3g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 13, 11), Box(0, 0, 17, 17),
      ic_outlined_18_device_3g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_4g_mobiledata 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_outlined_18_device_4g_mobiledata_data[] PROGMEM = {
  0x8D, 0x24, 0x50, 0x82, 0x07, 0xBB, 0xA2, 0x67, 0x0A, 0x30, 0xE3, 0x33, 0x16, 0x70, 0xA3, 0x0D,
  0x17, 0x73, 0x5D, 0xDE, 0xD1, 0xD1, 0x7A, 0x73, 0x86, 0xA3, 0x0E, 0x33, 0x87, 0x38, 0x68, 0x20,
  0x7B, 0xBA, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_4g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 13, 11), Box(0, 0, 17, 17),
      ic_outlined_18_device_4g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_4g_plus_mobiledata 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_outlined_18_device_4g_plus_mobiledata_data[] PROGMEM = {
  0x89, 0x12, 0x80, 0x54, 0x05, 0xBB, 0xB4, 0x58, 0x91, 0x3A, 0x07, 0x60, 0xC5, 0x33, 0x22, 0x09,
  0x28, 0xB6, 0x3A, 0x07, 0x60, 0xC1, 0x77, 0x53, 0x8E, 0x71, 0x2D, 0xDE, 0xE4, 0xC1, 0x79, 0xA3,
  0x8E, 0x71, 0x38, 0x67, 0x60, 0xC5, 0x36, 0xA2, 0x09, 0x58, 0x65, 0x40, 0x5B, 0xBB, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_4g_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 16, 11), Box(0, 0, 17, 17),
      ic_outlined_18_device_4g_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_60fps 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_outlined_18_device_60fps_data[] PROGMEM = {
  0x18, 0x36, 0x77, 0x75, 0x28, 0x56, 0x77, 0x72, 0x04, 0xC8, 0x1A, 0x0B, 0xC8, 0xA1, 0xE1, 0x4F,
  0x93, 0x32, 0x0F, 0xD3, 0x39, 0xF4, 0x4F, 0x74, 0x90, 0xC2, 0x89, 0x27, 0xF4, 0x4F, 0xED, 0xDB,
  0x0F, 0xC2, 0x89, 0x27, 0xF4, 0x4F, 0xED, 0xEF, 0x1F, 0xC2, 0x89, 0x27, 0xF4, 0x4F, 0x70, 0xAF,
  0x1F, 0xC2, 0x8A, 0x07, 0xF4, 0x4F, 0x93, 0xBF, 0x1F, 0xD3, 0x39, 0xF4, 0x4D, 0x01, 0x0B, 0xC8,
  0x6E, 0x10, 0x67, 0x77, 0x52, 0x83, 0x67, 0x77, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_60fps() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_outlined_18_device_60fps_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_access_alarm 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_outlined_18_device_access_alarm_data[] PROGMEM = {
  0x30, 0x30, 0x16, 0x01, 0x03, 0x58, 0x16, 0xFA, 0x68, 0x1A, 0xF5, 0x38, 0xC3, 0x8F, 0xB1, 0x7C,
  0xEE, 0xC7, 0x1B, 0xF8, 0x03, 0xF8, 0x4E, 0xFB, 0x88, 0xBF, 0xE4, 0x8F, 0x30, 0x23, 0xFC, 0x24,
  0x83, 0x2C, 0xF3, 0x23, 0x00, 0xD3, 0x0B, 0x05, 0x30, 0x0D, 0x38, 0x15, 0xF4, 0x30, 0xB0, 0x53,
  0x81, 0x4F, 0x52, 0x09, 0x0E, 0x40, 0xB0, 0x54, 0x0E, 0x09, 0x20, 0xB0, 0xC4, 0x0B, 0x05, 0x40,
  0xC0, 0xB2, 0x0A, 0x0C, 0x48, 0x18, 0xE6, 0x30, 0xC0, 0xA2, 0x81, 0x7F, 0x14, 0x85, 0x3C, 0xC1,
  0x1F, 0x72, 0x81, 0x2F, 0x86, 0x83, 0x60, 0x8F, 0x23, 0x81, 0x9F, 0x56, 0x81, 0x5F, 0x85, 0x82,
  0xBF, 0xA3, 0x28, 0x23, 0xAF, 0xB7, 0x07, 0x0E, 0xC0, 0xE0, 0x77, 0x38, 0x24, 0x77, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_access_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_access_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_access_alarms 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_outlined_18_device_access_alarms_data[] PROGMEM = {
  0x30, 0x30, 0x16, 0x02, 0x04, 0x58, 0x15, 0xFA, 0x68, 0x1A, 0xF6, 0x38, 0xC3, 0x8F, 0xB1, 0x7C,
  0xEE, 0xC7, 0x1A, 0xF8, 0x03, 0xF8, 0x4E, 0xFB, 0x88, 0xBF, 0xE4, 0x8F, 0x30, 0x23, 0xFC, 0x24,
  0x83, 0x2C, 0xF3, 0x23, 0x00, 0xD3, 0x0B, 0x05, 0x30, 0x0D, 0x38, 0x15, 0xF4, 0x30, 0xB0, 0x53,
  0x81, 0x4F, 0x52, 0x09, 0x0E, 0x40, 0xB0, 0x54, 0x0E, 0x09, 0x20, 0xB0, 0xC4, 0x0B, 0x05, 0x40,
  0xC0, 0xB2, 0x0A, 0x0C, 0x48, 0x18, 0xD5, 0x30, 0xC0, 0xA2, 0x81, 0x7F, 0x14, 0x85, 0x4D, 0xB1,
  0x1F, 0x72, 0x81, 0x2F, 0x86, 0x83, 0x70, 0x8F, 0x23, 0x81, 0x9F, 0x56, 0x81, 0x5F, 0x95, 0x82,
  0xBF, 0xA3, 0x28, 0x23, 0xAF, 0xB7, 0x07, 0x0E, 0xC0, 0xE0, 0x77, 0x38, 0x24, 0x77, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_access_alarms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_access_alarms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_access_time_filled 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_device_access_time_filled_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xF9, 0x09, 0x50, 0x9C, 0x00, 0xAC, 0x09,
  0x30, 0x3D, 0x00, 0x5D, 0x03, 0x20, 0xBD, 0x00, 0x5D, 0x0B, 0x2E, 0x00, 0x5E, 0x10, 0x2E, 0x05,
  0x03, 0xE0, 0x02, 0xE8, 0x1B, 0x04, 0xD0, 0x21, 0xF8, 0x1B, 0x04, 0xC2, 0x0B, 0xF8, 0x1B, 0x1C,
  0xA0, 0xB2, 0x03, 0xFD, 0x03, 0x30, 0x9F, 0xB0, 0x95, 0x09, 0xF9, 0x09, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_access_time_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_access_time_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_access_time 18x18, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_outlined_18_device_access_time_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x28, 0x19, 0xF2, 0x30, 0x80, 0x43, 0x85, 0x2F,
  0x90, 0x1F, 0x84, 0x0B, 0x05, 0x48, 0x48, 0xF0, 0x5F, 0x34, 0x0B, 0x05, 0x48, 0x23, 0xF5, 0x69,
  0x50, 0xB0, 0x55, 0x90, 0x06, 0x95, 0x81, 0xAB, 0x24, 0x98, 0x26, 0x5F, 0x35, 0x81, 0x7E, 0x82,
  0x84, 0x3F, 0x51, 0xF8, 0x68, 0x32, 0xA8, 0x08, 0x92, 0x81, 0x9F, 0x27, 0x18, 0x12, 0xF9, 0x28,
  0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x38, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F, 0xD2, 0x50, 0x10,
  0x9E, 0x09, 0x01, 0x72, 0x82, 0x57, 0x75, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_access_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_access_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_add_alarm 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_outlined_18_device_add_alarm_data[] PROGMEM = {
  0x30, 0x30, 0x16, 0x01, 0x03, 0x58, 0x16, 0xFA, 0x68, 0x1A, 0xF5, 0x38, 0xC3, 0x8F, 0xB1, 0x7C,
  0xEE, 0xC7, 0x1B, 0xF8, 0x03, 0xF8, 0x4E, 0xFB, 0x88, 0xBF, 0xE4, 0x8F, 0x30, 0x23, 0xFC, 0x24,
  0x83, 0x2C, 0xF3, 0x23, 0x00, 0xD3, 0x00, 0x23, 0x00, 0xD3, 0x81, 0x5F, 0x43, 0x00, 0xB3, 0x81,
  0x4F, 0x52, 0x09, 0x0E, 0x40, 0x0B, 0x40, 0xE0, 0x92, 0x0B, 0x0C, 0x2E, 0x20, 0xC0, 0xB2, 0x0A,
  0x0C, 0x28, 0x47, 0x7D, 0xD7, 0x72, 0x0C, 0x0A, 0x28, 0x17, 0xF1, 0x30, 0x0B, 0x38, 0x11, 0xF7,
  0x28, 0x12, 0xF8, 0x30, 0x08, 0x38, 0x18, 0xF2, 0x38, 0x19, 0xF5, 0x68, 0x15, 0xF8, 0x58, 0x2B,
  0xFA, 0x32, 0x82, 0x3A, 0xFB, 0x70, 0x70, 0xEC, 0x0E, 0x07, 0x73, 0x82, 0x47, 0x74, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_add_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_add_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_add_to_home_screen 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_18_device_add_to_home_screen_data[] PROGMEM = {
  0x30, 0x18, 0x04, 0x33, 0x03, 0xFA, 0x0B, 0x20, 0x7F, 0xB2, 0x07, 0x98, 0x03, 0xB0, 0xD9, 0x20,
  0x30, 0x77, 0x07, 0x97, 0x48, 0x27, 0xF0, 0x3D, 0x48, 0x57, 0xF0, 0x17, 0x7D, 0xA4, 0x07, 0x93,
  0x81, 0x8F, 0xD9, 0x40, 0x79, 0x28, 0x28, 0xF8, 0x79, 0x48, 0x67, 0xF0, 0x8F, 0x80, 0x79, 0x48,
  0x37, 0xF7, 0xF8, 0x20, 0x10, 0x34, 0x82, 0x7F, 0x17, 0x72, 0x07, 0x92, 0x03, 0x07, 0x70, 0x79,
  0x20, 0x79, 0x80, 0x3B, 0x0D, 0x92, 0x07, 0xFB, 0x20, 0x3F, 0xA0, 0xB3, 0x01, 0x80, 0x43, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_add_to_home_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_add_to_home_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_ad_units 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_outlined_18_device_ad_units_data[] PROGMEM = {
  0x28, 0x04, 0x32, 0x01, 0x0E, 0xF9, 0x83, 0xE1, 0x3F, 0x68, 0x02, 0x38, 0x26, 0xF3, 0x3F, 0xB8,
  0x23, 0x3F, 0x98, 0x02, 0x78, 0x49, 0xF3, 0x3F, 0x38, 0x02, 0xB8, 0x43, 0xF3, 0x3F, 0x38, 0x02,
  0xB8, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F,
  0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x98,
  0x02, 0x78, 0x29, 0xF3, 0x3F, 0xB8, 0x23, 0x3F, 0x68, 0x02, 0x38, 0x36, 0xF3, 0x1E, 0xF9, 0x0E,
  0x01, 0x28, 0x04, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_ad_units() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_ad_units_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_airplanemode_active 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_outlined_18_device_airplanemode_active_data[] PROGMEM = {
  0x60, 0x01, 0x75, 0x00, 0xC7, 0x50, 0x0D, 0x75, 0x00, 0xD7, 0x50, 0x0D, 0x74, 0x06, 0xA0, 0x67,
  0x10, 0x10, 0xBC, 0x0B, 0x01, 0x50, 0x60, 0xEE, 0x0E, 0x06, 0x28, 0x97, 0x1B, 0xFB, 0x61, 0xDD,
  0x16, 0xBF, 0xB1, 0x36, 0x13, 0x00, 0xD3, 0x81, 0x16, 0x36, 0x00, 0xD7, 0x48, 0x22, 0xEE, 0x27,
  0x28, 0x42, 0xEE, 0xEE, 0x27, 0x10, 0x10, 0x22, 0x02, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_airplanemode_active() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_airplanemode_active_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_airplanemode_inactive 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_device_airplanemode_inactive_data[] PROGMEM = {
  0x02, 0x50, 0x01, 0x60, 0xA0, 0x74, 0x00, 0xC7, 0x0B, 0x07, 0x30, 0x0D, 0x71, 0x0B, 0x07, 0x20,
  0x0D, 0x72, 0x83, 0xB7, 0x0D, 0xD7, 0x38, 0x3B, 0x74, 0xE6, 0x71, 0x86, 0x1B, 0xF7, 0x4E, 0xB1,
  0x50, 0x60, 0xEB, 0x83, 0x74, 0xEE, 0x62, 0x89, 0x71, 0xBF, 0xB6, 0x1D, 0xF7, 0x3B, 0xFB, 0x13,
  0x61, 0x38, 0x6D, 0xEB, 0x70, 0x16, 0x36, 0x83, 0xDD, 0x0B, 0x77, 0x18, 0x52, 0xEE, 0x20, 0xB7,
  0x68, 0x72, 0xEE, 0xEE, 0x20, 0xB7, 0x50, 0x10, 0x22, 0x02, 0x01, 0x20, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_airplanemode_inactive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_airplanemode_inactive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_airplane_ticket 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_outlined_18_device_airplane_ticket_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x05, 0x81, 0x20, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x33,
  0x05, 0x03, 0x58, 0x52, 0xF3, 0x1D, 0xE1, 0x28, 0x16, 0xE4, 0x48, 0x12, 0xF3, 0x20, 0xE0, 0x63,
  0x87, 0xCF, 0x51, 0x51, 0x2F, 0x32, 0x84, 0xE6, 0x26, 0x07, 0xC8, 0x90, 0x52, 0xF3, 0x1D, 0xE1,
  0x0C, 0xA8, 0x1D, 0x84, 0x28, 0x42, 0xF3, 0x3F, 0x32, 0x81, 0x35, 0x15, 0x84, 0x2F, 0x33, 0xF2,
  0x73, 0x82, 0x2F, 0x31, 0xFF, 0x81, 0x10, 0x28, 0x09, 0x05, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_airplane_ticket() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_airplane_ticket_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_air 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_device_air_data[] PROGMEM = {
  0x73, 0x03, 0x02, 0x76, 0x0B, 0xA0, 0xA7, 0x48, 0x46, 0xE3, 0x4F, 0x37, 0x38, 0x41, 0x10, 0x1F,
  0x52, 0x02, 0x80, 0x6B, 0x00, 0xD3, 0x01, 0x80, 0x69, 0x08, 0x01, 0x30, 0x18, 0x09, 0x07, 0x04,
  0x20, 0x28, 0x09, 0x0D, 0x90, 0x92, 0x80, 0x33, 0x58, 0x25, 0xF1, 0x3F, 0x0D, 0x02, 0x38, 0x15,
  0xF1, 0x18, 0x02, 0x18, 0x12, 0xCA, 0x28, 0x13, 0xF9, 0x68, 0x39, 0xD2, 0xBA, 0x20, 0x20, 0x47,
  0x83, 0x2E, 0xFE, 0x37, 0x60, 0x30, 0x17,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_air() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_air_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_aod 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_outlined_18_device_aod_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x81, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE7,
  0x18, 0x96, 0xE6, 0x6E, 0x09, 0xDD, 0xDD, 0x90, 0xE6, 0x6E, 0x28, 0x00, 0x12, 0x82, 0xE6, 0x6E,
  0x28, 0x29, 0xCC, 0x92, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x71, 0x81, 0xE6, 0x69, 0x80,
  0x47, 0x90, 0x06, 0x98, 0x04, 0xD9, 0x81, 0x66, 0xE8, 0x04, 0x38, 0x2E, 0x62, 0xEF, 0x90, 0xE0,
  0x22, 0x80, 0x41, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_aod() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_aod_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_0_bar 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_outlined_18_device_battery_0_bar_data[] PROGMEM = {
  0x28, 0x21, 0x33, 0x14, 0x05, 0xA0, 0x52, 0x81, 0x4D, 0xEA, 0x89, 0x3E, 0xD4, 0x9D, 0x77, 0x77,
  0xD9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B,
  0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0x91,
  0xB9, 0x9C, 0x11, 0x11, 0xC9, 0x7E, 0x07, 0x18, 0x02, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_1_bar 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_device_battery_1_bar_data[] PROGMEM = {
  0x28, 0x21, 0x33, 0x14, 0x05, 0xA0, 0x52, 0x81, 0x4D, 0xEA, 0x89, 0x3E, 0xD4, 0x9D, 0x77, 0x77,
  0xD9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B,
  0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x81, 0xB9, 0x9E, 0x00, 0x9E,
  0x09, 0x07, 0xE0, 0x71, 0x80, 0x23, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_2_bar 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_outlined_18_device_battery_2_bar_data[] PROGMEM = {
  0x28, 0x21, 0x33, 0x14, 0x05, 0xA0, 0x52, 0x81, 0x4D, 0xEA, 0x89, 0x3E, 0xD4, 0x9D, 0x77, 0x77,
  0xD9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B,
  0x48, 0x2B, 0x99, 0xB4, 0x89, 0x1B, 0x99, 0xC3, 0x33, 0x3C, 0x99, 0xE0, 0x09, 0xE0, 0x09, 0xE0,
  0x90, 0x7E, 0x07, 0x18, 0x02, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_3_bar 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_outlined_18_device_battery_3_bar_data[] PROGMEM = {
  0x28, 0x21, 0x33, 0x14, 0x05, 0xA0, 0x52, 0x81, 0x4D, 0xEA, 0x89, 0x3E, 0xD4, 0x9D, 0x77, 0x77,
  0xD9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B,
  0x48, 0x91, 0xB9, 0x9E, 0x99, 0x99, 0xE9, 0x9E, 0x00, 0x9E, 0x00, 0x9E, 0x00, 0x9E, 0x09, 0x07,
  0xE0, 0x71, 0x80, 0x23, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_4_bar 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_outlined_18_device_battery_4_bar_data[] PROGMEM = {
  0x28, 0x21, 0x33, 0x14, 0x05, 0xA0, 0x52, 0x81, 0x4D, 0xEA, 0x89, 0x3E, 0xD4, 0x9D, 0x77, 0x77,
  0xD9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x81, 0xB9, 0x9E,
  0x00, 0x9E, 0x00, 0x9E, 0x00, 0x9E, 0x00, 0x9E, 0x00, 0x9E, 0x09, 0x07, 0xE0, 0x71, 0x80, 0x23,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_5_bar 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_outlined_18_device_battery_5_bar_data[] PROGMEM = {
  0x28, 0x21, 0x33, 0x14, 0x05, 0xA0, 0x52, 0x81, 0x4D, 0xEA, 0x89, 0x3E, 0xD4, 0x9D, 0x77, 0x77,
  0xD9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x89, 0x1B, 0x99, 0xD5, 0x55, 0x5D, 0x99, 0xE0, 0x09, 0xE0,
  0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x90, 0x7E, 0x07, 0x18, 0x02, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_5_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_5_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_6_bar 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_outlined_18_device_battery_6_bar_data[] PROGMEM = {
  0x28, 0x21, 0x33, 0x14, 0x05, 0xA0, 0x52, 0x81, 0x4D, 0xEA, 0x89, 0x3E, 0xD4, 0x9D, 0x77, 0x77,
  0xD9, 0x9B, 0x48, 0x91, 0xB9, 0x9E, 0xBB, 0xBB, 0xE9, 0x9E, 0x00, 0x9E, 0x00, 0x9E, 0x00, 0x9E,
  0x00, 0x9E, 0x00, 0x9E, 0x00, 0x9E, 0x00, 0x9E, 0x09, 0x07, 0xE0, 0x71, 0x80, 0x23, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_6_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_6_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_alert 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_outlined_18_device_battery_alert_data[] PROGMEM = {
  0x28, 0x23, 0x77, 0x34, 0x07, 0xA0, 0x72, 0x08, 0xE0, 0x80, 0xBE, 0x00, 0xBE, 0x00, 0xBA, 0x00,
  0xCA, 0x00, 0xBA, 0x00, 0x3A, 0x00, 0xBA, 0x00, 0x3A, 0x00, 0xBA, 0x00, 0x3A, 0x00, 0xBA, 0x00,
  0x9A, 0x00, 0xBE, 0x00, 0xBA, 0x00, 0x3A, 0x00, 0xBA, 0x00, 0x9A, 0x00, 0xBE, 0x00, 0xBE, 0x0B,
  0x02, 0x80, 0x27, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_charging_full 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_outlined_18_device_battery_charging_full_data[] PROGMEM = {
  0x28, 0x23, 0x77, 0x34, 0x07, 0xA0, 0x72, 0x08, 0xE0, 0x80, 0xBE, 0x00, 0xBB, 0x0D, 0xA0, 0x0B,
  0xB0, 0x5A, 0x00, 0xBA, 0x08, 0x03, 0xA8, 0x4B, 0xBF, 0xE1, 0x3A, 0x89, 0x2B, 0xBF, 0x70, 0x15,
  0xEB, 0xBE, 0x22, 0x82, 0x5F, 0xBB, 0xA8, 0x43, 0x0D, 0xFB, 0xBA, 0x03, 0x06, 0xA0, 0x0B, 0xA0,
  0x40, 0xEA, 0x00, 0xBA, 0x0B, 0xB0, 0x0B, 0xE0, 0xB0, 0x28, 0x02, 0x70, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_charging_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_charging_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_full 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_outlined_18_device_battery_full_data[] PROGMEM = {
  0x28, 0x23, 0x77, 0x34, 0x07, 0xA0, 0x72, 0x08, 0xE0, 0x80, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00,
  0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00,
  0xBE, 0x0B, 0x02, 0x80, 0x27, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_saver 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_outlined_18_device_battery_saver_data[] PROGMEM = {
  0x28, 0x21, 0x33, 0x14, 0x05, 0xA0, 0x52, 0x81, 0x4D, 0xEA, 0x82, 0xED, 0x49, 0xE0, 0x09, 0xE0,
  0x09, 0xE0, 0x09, 0xA0, 0x07, 0xA8, 0x91, 0x99, 0xEB, 0x33, 0xBE, 0x99, 0xB4, 0x89, 0x1B, 0x99,
  0xFD, 0x44, 0xDF, 0x99, 0xA0, 0x07, 0xA0, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x90, 0x7E, 0x07,
  0x18, 0x02, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_saver() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_saver_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_std 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_outlined_18_device_battery_std_data[] PROGMEM = {
  0x28, 0x23, 0x77, 0x34, 0x07, 0xA0, 0x72, 0x08, 0xE0, 0x80, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00,
  0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00, 0xBE, 0x00,
  0xBE, 0x0B, 0x02, 0x80, 0x27, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_std() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_std_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_battery_unknown 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_outlined_18_device_battery_unknown_data[] PROGMEM = {
  0x28, 0x23, 0x77, 0x34, 0x07, 0xA0, 0x72, 0x08, 0xE0, 0x80, 0xBE, 0x00, 0xBE, 0x8A, 0x2B, 0xBF,
  0x91, 0x19, 0xFB, 0xBE, 0x0A, 0xA0, 0xEB, 0xBE, 0xBA, 0x82, 0x1C, 0xBB, 0xB8, 0x35, 0x4F, 0xBB,
  0xA8, 0x49, 0x1E, 0xFB, 0xBA, 0x00, 0xDA, 0x00, 0xBA, 0x00, 0x3A, 0x00, 0xBA, 0x00, 0x9A, 0x00,
  0xBE, 0x00, 0xBE, 0x0B, 0x02, 0x80, 0x27, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_battery_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_battery_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_bloodtype 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_outlined_18_device_bloodtype_data[] PROGMEM = {
  0x50, 0x0B, 0x71, 0x84, 0x1C, 0xEE, 0xC1, 0x68, 0x4B, 0xD2, 0x2D, 0xB5, 0x81, 0xAE, 0x22, 0x81,
  0x2E, 0xA3, 0x89, 0x05, 0xF4, 0x02, 0x20, 0x4F, 0x52, 0x0E, 0x09, 0x20, 0x0A, 0x28, 0xB3, 0x9E,
  0x06, 0xE1, 0x29, 0xDD, 0x92, 0x1E, 0x6A, 0xB0, 0x29, 0xDD, 0x92, 0x0A, 0xAC, 0x83, 0x00, 0xA3,
  0x82, 0x8C, 0xBB, 0x30, 0x02, 0x38, 0xA7, 0xBB, 0x6F, 0x23, 0xDD, 0xDD, 0x32, 0xF6, 0x0D, 0xC3,
  0x77, 0x77, 0x3C, 0xD2, 0x89, 0x02, 0xDE, 0x73, 0x37, 0xED, 0x23, 0x81, 0x19, 0xEA, 0x81, 0xE9,
  0x17, 0x00, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_bloodtype() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_bloodtype_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_bluetooth_connected 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_outlined_18_device_bluetooth_connected_data[] PROGMEM = {
  0x60, 0x50, 0x17, 0x58, 0x1B, 0xD1, 0x70, 0x13, 0x82, 0xBF, 0xD1, 0x58, 0x11, 0xD8, 0x28, 0x3B,
  0xDE, 0xD1, 0x58, 0x90, 0x8F, 0x80, 0xBB, 0x3F, 0xD1, 0x58, 0x68, 0xF8, 0xBB, 0x8F, 0x84, 0x03,
  0x20, 0x8C, 0x08, 0x28, 0x33, 0x04, 0xFB, 0x20, 0x8A, 0x08, 0x28, 0x4B, 0xF4, 0x4F, 0xB2, 0x08,
  0xA0, 0x82, 0x83, 0xBF, 0x40, 0x32, 0x08, 0xC0, 0x82, 0x03, 0x48, 0x68, 0xF8, 0xBB, 0x8F, 0x85,
  0x89, 0x08, 0xF8, 0x0B, 0xB3, 0xFD, 0x13, 0x81, 0x1D, 0x82, 0x83, 0xBD, 0xED, 0x15, 0x01, 0x38,
  0x2B, 0xFD, 0x17, 0x38, 0x1B, 0xD1, 0x74, 0x05, 0x01, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_bluetooth_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_bluetooth_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_bluetooth_disabled 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_device_bluetooth_disabled_data[] PROGMEM = {
  0x50, 0x50, 0x17, 0x38, 0x1B, 0xD1, 0x40, 0x60, 0x83, 0x82, 0xBF, 0xD1, 0x38, 0x18, 0xF8, 0x28,
  0x3B, 0xDE, 0xD1, 0x38, 0x90, 0x8F, 0x80, 0x7B, 0x3F, 0xD1, 0x38, 0x68, 0xF8, 0x04, 0x8F, 0x85,
  0x84, 0x8F, 0x80, 0x88, 0x78, 0x18, 0xF8, 0x72, 0x08, 0xA0, 0x87, 0x08, 0xC0, 0x85, 0x86, 0x8F,
  0x8B, 0xB8, 0xF8, 0x38, 0x58, 0xF8, 0x0B, 0xB3, 0xA8, 0x38, 0x01, 0xD8, 0x28, 0x7B, 0xDE, 0xD9,
  0xF8, 0x01, 0x38, 0x5B, 0xFD, 0x10, 0x86, 0x58, 0x1B, 0xD1, 0x72, 0x05, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_bluetooth_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_bluetooth_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_bluetooth_drive 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_outlined_18_device_bluetooth_drive_data[] PROGMEM = {
  0x75, 0x04, 0x02, 0x75, 0x82, 0x17, 0xC2, 0x73, 0x83, 0x1B, 0x96, 0xB2, 0x01, 0x80, 0x27, 0x83,
  0x60, 0x1D, 0xB3, 0x0C, 0x0E, 0x80, 0x1D, 0x89, 0x0A, 0x02, 0xEC, 0x10, 0x3F, 0x36, 0x86, 0x1B,
  0x86, 0xB0, 0x9D, 0x72, 0x84, 0x7C, 0x10, 0xEE, 0x80, 0x2D, 0x0A, 0x28, 0x43, 0x10, 0x3F, 0x88,
  0x02, 0x70, 0x62, 0x86, 0x73, 0x03, 0xF2, 0x97, 0x48, 0x91, 0x5B, 0x0E, 0x60, 0x3F, 0x29, 0x84,
  0x87, 0x5C, 0x0E, 0x60, 0x3F, 0x78, 0x05, 0x59, 0x81, 0x60, 0x3F, 0xD8, 0x36, 0x03, 0xF9, 0x71,
  0x81, 0x6F, 0x62, 0x03, 0x01, 0x71, 0x81, 0x13, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_bluetooth_drive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_bluetooth_drive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_bluetooth 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_outlined_18_device_bluetooth_data[] PROGMEM = {
  0x50, 0x50, 0x17, 0x28, 0x1B, 0xD1, 0x40, 0x13, 0x82, 0xBF, 0xD1, 0x28, 0x11, 0xD8, 0x28, 0x3B,
  0xDE, 0xD1, 0x28, 0x90, 0x8F, 0x80, 0xBB, 0x3F, 0xD1, 0x28, 0x68, 0xF8, 0xBB, 0x8F, 0x84, 0x08,
  0xC0, 0x86, 0x08, 0xA0, 0x87, 0x08, 0xA0, 0x86, 0x08, 0xC0, 0x84, 0x86, 0x8F, 0x8B, 0xB8, 0xF8,
  0x28, 0x93, 0x8F, 0x80, 0xBB, 0x3F, 0xD1, 0x1D, 0x82, 0x83, 0xBD, 0xED, 0x12, 0x01, 0x38, 0x2B,
  0xFD, 0x17, 0x81, 0xBD, 0x17, 0x10, 0x50, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_bluetooth() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 13, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_bluetooth_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_bluetooth_searching 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_outlined_18_device_bluetooth_searching_data[] PROGMEM = {
  0x40, 0x10, 0x57, 0x58, 0x13, 0xF7, 0x71, 0x01, 0x20, 0x3A, 0x07, 0x68, 0x76, 0xD2, 0x03, 0xFC,
  0xF7, 0x58, 0x90, 0x2D, 0xD2, 0x3F, 0x3A, 0xF7, 0x20, 0x92, 0x89, 0x32, 0xDD, 0x6F, 0x6D, 0xE2,
  0x01, 0xF4, 0x20, 0x20, 0xDB, 0x85, 0xE2, 0x04, 0x0B, 0x83, 0x89, 0x12, 0xDF, 0xD2, 0x0B, 0xA0,
  0x9A, 0x38, 0x91, 0x2D, 0xFD, 0x20, 0xBA, 0x09, 0xA2, 0x02, 0x0D, 0xB8, 0xB5, 0xE2, 0x04, 0x0B,
  0x80, 0x2D, 0xD6, 0xF6, 0xDE, 0x20, 0x1F, 0x32, 0xDD, 0x23, 0xF3, 0xAF, 0x72, 0x89, 0x18, 0x06,
  0xD2, 0x03, 0xFC, 0xF7, 0x60, 0x12, 0x03, 0xA0, 0x77, 0x38, 0x13, 0xF7, 0x74, 0x01, 0x05, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_bluetooth_searching() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_bluetooth_searching_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_brightness_auto 18x18, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_outlined_18_device_brightness_auto_data[] PROGMEM = {
  0x71, 0x00, 0x17, 0x71, 0x82, 0x1D, 0xD1, 0x76, 0x84, 0x1D, 0xEE, 0xD1, 0x72, 0xC8, 0x2E, 0x33,
  0xEC, 0x69, 0x82, 0xB7, 0x73, 0x28, 0x23, 0x77, 0xB9, 0x69, 0x07, 0x30, 0x0A, 0x30, 0x79, 0x58,
  0x11, 0xF7, 0x20, 0x3A, 0x03, 0x28, 0x17, 0xF1, 0x38, 0x21, 0xDE, 0x32, 0x82, 0x8B, 0xB8, 0x28,
  0x73, 0xED, 0x10, 0x1D, 0xE3, 0x38, 0x2D, 0x66, 0xD3, 0x86, 0x3E, 0xD1, 0x1D, 0xE3, 0x28, 0x44,
  0xF9, 0x9F, 0x42, 0x8A, 0x33, 0xED, 0x10, 0x1D, 0xE3, 0x09, 0xD7, 0x7D, 0x90, 0x3E, 0xD1, 0x38,
  0x41, 0xF7, 0x0E, 0x62, 0x84, 0x6E, 0x07, 0xF1, 0x59, 0x07, 0x71, 0x07, 0x96, 0x98, 0x2B, 0x77,
  0x32, 0x82, 0x37, 0x7B, 0x96, 0xC8, 0x2E, 0x33, 0xEC, 0x72, 0x84, 0x1D, 0xEE, 0xD1, 0x76, 0x82,
  0x1D, 0xD1, 0x77, 0x10, 0x01, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_brightness_auto() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_brightness_auto_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_brightness_high 18x18, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_outlined_18_device_brightness_high_data[] PROGMEM = {
  0x71, 0x00, 0x17, 0x71, 0x82, 0x1D, 0xD1, 0x76, 0x84, 0x1D, 0xEE, 0xD1, 0x72, 0xC8, 0x2E, 0x33,
  0xEC, 0x69, 0x89, 0x0B, 0x77, 0x56, 0x65, 0x77, 0xB9, 0x69, 0x81, 0x70, 0x9C, 0x81, 0x90, 0x79,
  0x58, 0x94, 0x1F, 0x79, 0xF7, 0x11, 0x7F, 0x97, 0xF1, 0x38, 0xA7, 0x1D, 0xE5, 0xF7, 0x2B, 0xB2,
  0x7F, 0x5E, 0xD1, 0x01, 0xDE, 0x36, 0xF1, 0xBA, 0x89, 0x6B, 0x1F, 0x63, 0xED, 0x11, 0xDE, 0x36,
  0xF1, 0xBA, 0x8A, 0x7B, 0x1F, 0x63, 0xED, 0x10, 0x1D, 0xE5, 0xF7, 0x2B, 0xB2, 0x7F, 0x5E, 0xD1,
  0x38, 0x94, 0x1F, 0x79, 0xF7, 0x11, 0x7F, 0x97, 0xF1, 0x59, 0x81, 0x70, 0x9C, 0x81, 0x90, 0x79,
  0x69, 0x89, 0x0B, 0x77, 0x56, 0x65, 0x77, 0xB9, 0x6C, 0x82, 0xE3, 0x3E, 0xC7, 0x28, 0x41, 0xDE,
  0xED, 0x17, 0x68, 0x21, 0xDD, 0x17, 0x71, 0x00, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_brightness_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_brightness_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_brightness_low 18x18, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_outlined_18_device_brightness_low_data[] PROGMEM = {
  0x71, 0x00, 0x17, 0x71, 0x82, 0x1D, 0xD1, 0x76, 0x84, 0x1D, 0xEE, 0xD1, 0x72, 0xC8, 0x2E, 0x33,
  0xEC, 0x69, 0x89, 0x0B, 0x77, 0x56, 0x65, 0x77, 0xB9, 0x69, 0x81, 0x70, 0x9C, 0x81, 0x90, 0x79,
  0x58, 0x94, 0x1F, 0x79, 0xF7, 0x11, 0x7F, 0x97, 0xF1, 0x38, 0x41, 0xDE, 0x5F, 0x74, 0x89, 0x47,
  0xF5, 0xED, 0x10, 0x1D, 0xE3, 0x6F, 0x14, 0x89, 0x41, 0xF6, 0x3E, 0xD1, 0x1D, 0xE3, 0x6F, 0x14,
  0x89, 0x41, 0xF6, 0x3E, 0xD1, 0x01, 0xDE, 0x5F, 0x74, 0x84, 0x7F, 0x5E, 0xD1, 0x38, 0x94, 0x1F,
  0x79, 0xF7, 0x11, 0x7F, 0x97, 0xF1, 0x59, 0x81, 0x70, 0x9C, 0x81, 0x90, 0x79, 0x69, 0x89, 0x0B,
  0x77, 0x56, 0x65, 0x77, 0xB9, 0x6C, 0x82, 0xE3, 0x3E, 0xC7, 0x28, 0x41, 0xDE, 0xED, 0x17, 0x68,
  0x21, 0xDD, 0x17, 0x71, 0x00, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_brightness_low() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_brightness_low_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_brightness_medium 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_outlined_18_device_brightness_medium_data[] PROGMEM = {
  0x71, 0x00, 0x17, 0x71, 0x82, 0x1D, 0xD1, 0x76, 0x84, 0x1D, 0xEE, 0xD1, 0x72, 0xC8, 0x2E, 0x33,
  0xEC, 0x69, 0x89, 0x0B, 0x77, 0x30, 0x65, 0x77, 0xB9, 0x69, 0x07, 0x4A, 0x81, 0x90, 0x79, 0x58,
  0x11, 0xF7, 0x4B, 0x82, 0x97, 0xF1, 0x38, 0x21, 0xDE, 0x34, 0xC8, 0x75, 0xED, 0x10, 0x1D, 0xE3,
  0x5C, 0x87, 0x63, 0xED, 0x11, 0xDE, 0x35, 0xC8, 0x90, 0x63, 0xED, 0x10, 0x1D, 0xE3, 0x4C, 0x82,
  0x5E, 0xD1, 0x38, 0x11, 0xF7, 0x4B, 0x82, 0x97, 0xF1, 0x59, 0x07, 0x4A, 0x81, 0x90, 0x79, 0x69,
  0x89, 0x0B, 0x77, 0x30, 0x65, 0x77, 0xB9, 0x6C, 0x82, 0xE3, 0x3E, 0xC7, 0x28, 0x41, 0xDE, 0xED,
  0x17, 0x68, 0x21, 0xDD, 0x17, 0x71, 0x00, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_brightness_medium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_brightness_medium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_cable 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_outlined_18_device_cable_data[] PROGMEM = {
  0x40, 0x03, 0x40, 0x03, 0x50, 0xCA, 0x0B, 0x20, 0x3A, 0x05, 0x38, 0x57, 0xE3, 0x3E, 0x73, 0xC0,
  0x42, 0x0B, 0x09, 0x28, 0x1A, 0xA3, 0xC0, 0x42, 0x0B, 0x09, 0x28, 0x1A, 0xA3, 0xC0, 0x42, 0x0B,
  0x09, 0x28, 0x2A, 0xA1, 0xEB, 0x02, 0x20, 0xB0, 0x92, 0x00, 0xA2, 0x0A, 0x0B, 0x40, 0xB0, 0xA2,
  0x00, 0xA2, 0x09, 0x0B, 0x20, 0x2B, 0x82, 0xE1, 0xAA, 0x20, 0x90, 0xB2, 0x04, 0xC8, 0x13, 0xAA,
  0x20, 0x90, 0xB2, 0x04, 0xC8, 0x13, 0xAA, 0x20, 0x90, 0xB2, 0x04, 0xC8, 0x53, 0x7E, 0x33, 0xE7,
  0x30, 0x5A, 0x03, 0x20, 0xBA, 0x0C, 0x50, 0x03, 0x40, 0x03, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_cable() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_cable_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_cameraswitch 18x18, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_outlined_18_device_cameraswitch_data[] PROGMEM = {
  0x68, 0x51, 0xCF, 0xED, 0x94, 0x75, 0x86, 0x3E, 0xE8, 0xCF, 0xC2, 0x74, 0x86, 0x3E, 0x80, 0x3C,
  0xE4, 0x74, 0x03, 0x01, 0x38, 0x1A, 0xE2, 0x71, 0x82, 0x47, 0x74, 0x40, 0x0C, 0x68, 0x67, 0xAF,
  0xDD, 0xFA, 0x72, 0x81, 0x2F, 0x44, 0x82, 0x6E, 0xB7, 0x28, 0x27, 0xBE, 0x62, 0x0B, 0x0A, 0x40,
  0x70, 0xD2, 0x00, 0x32, 0x0D, 0x07, 0x20, 0x70, 0xD4, 0x82, 0x7D, 0x03, 0xA8, 0x23, 0x0D, 0x73,
  0x00, 0x13, 0x82, 0x7D, 0x03, 0xA8, 0x23, 0x0D, 0x74, 0x0D, 0x07, 0x20, 0x70, 0xD2, 0x00, 0x32,
  0x0D, 0x07, 0x40, 0xA0, 0xB2, 0x06, 0x0E, 0x80, 0x2B, 0x0E, 0x06, 0x48, 0x14, 0xF2, 0x20, 0x78,
  0x02, 0x90, 0x76, 0x00, 0xC7, 0x72, 0x81, 0x2E, 0xA3, 0x01, 0x03, 0x74, 0x86, 0x4E, 0xC3, 0x08,
  0xE3, 0x74, 0x86, 0x2C, 0xFC, 0x8E, 0xE3, 0x75, 0x85, 0x49, 0xDE, 0xFC, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_cameraswitch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_cameraswitch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_credit_score 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_outlined_18_device_credit_score_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0xC8,
  0x06, 0xB8, 0x2C, 0xF3, 0x3F, 0xF0, 0x03, 0xFF, 0x82, 0x33, 0xF2, 0x76, 0x81, 0x3F, 0x27, 0x38,
  0x42, 0x80, 0x3F, 0x27, 0x28, 0x52, 0xEB, 0x03, 0xF2, 0x40, 0x80, 0x52, 0x81, 0x2E, 0xB2, 0x01,
  0xC8, 0x64, 0x09, 0xF5, 0x2E, 0xB4, 0x83, 0x35, 0x55, 0x12, 0x82, 0x9F, 0xEB, 0x76, 0x09, 0x0B,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_credit_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_credit_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_dark_mode 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_device_dark_mode_data[] PROGMEM = {
  0x58, 0x11, 0x33, 0x72, 0x03, 0x0B, 0xA0, 0x37, 0x18, 0x35, 0xFC, 0xDA, 0x71, 0x84, 0x3F, 0x80,
  0xE6, 0x71, 0x0B, 0x0C, 0x20, 0xE0, 0x77, 0x81, 0x1F, 0x52, 0x0A, 0x0C, 0x78, 0x13, 0xF1, 0x28,
  0x13, 0xF8, 0x40, 0xF3, 0x90, 0x13, 0x89, 0x16, 0xFC, 0x76, 0xAF, 0x31, 0xF4, 0x48, 0x90, 0x3A,
  0xEE, 0xDF, 0x10, 0xBB, 0x71, 0x0C, 0x0B, 0x28, 0x13, 0xF8, 0x68, 0x18, 0xF3, 0x38, 0x90, 0x5F,
  0xB4, 0x12, 0x5C, 0xF5, 0x50, 0x30, 0xBC, 0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_dark_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_dark_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_data_saver_off 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_outlined_18_device_data_saver_off_data[] PROGMEM = {
  0x48, 0x64, 0xBF, 0x55, 0xFB, 0x47, 0x09, 0xA8, 0x2D, 0x33, 0xDA, 0x09, 0x58, 0x29, 0xFD, 0x44,
  0x82, 0x4D, 0xF9, 0x38, 0x24, 0xFD, 0x16, 0x82, 0x1D, 0xF4, 0x28, 0x1B, 0xF4, 0x71, 0x81, 0x4F,
  0xB2, 0x90, 0xD7, 0x38, 0x4D, 0xF0, 0x2F, 0xA7, 0x38, 0x4A, 0xF2, 0x2F, 0xA7, 0x38, 0x4A, 0xF2,
  0x0F, 0xD7, 0x30, 0xD9, 0x28, 0x1B, 0xF3, 0x72, 0x06, 0x09, 0x28, 0x23, 0xFD, 0x16, 0x81, 0x18,
  0x14, 0x82, 0x9F, 0xD3, 0x48, 0x23, 0xDF, 0x85, 0x09, 0xA8, 0x2D, 0x9A, 0xDA, 0x08, 0x70, 0x30,
  0xBC, 0x0A, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_data_saver_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_data_saver_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_data_saver_on 18x18, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_outlined_18_device_data_saver_on_data[] PROGMEM = {
  0x48, 0x64, 0xBF, 0x55, 0xFB, 0x47, 0x09, 0xA8, 0x2D, 0x33, 0xDA, 0x09, 0x58, 0x29, 0xFD, 0x44,
  0x82, 0x4D, 0xF9, 0x38, 0x24, 0xFD, 0x12, 0x00, 0x12, 0x82, 0x1D, 0xF4, 0x28, 0x1B, 0xF4, 0x30,
  0x0A, 0x38, 0x14, 0xFB, 0x29, 0x0D, 0x40, 0x0A, 0x48, 0xC4, 0xDF, 0x02, 0xFA, 0x01, 0x99, 0xDD,
  0x99, 0x10, 0xAF, 0x22, 0xFA, 0x01, 0x99, 0xDD, 0x99, 0x10, 0xAF, 0x20, 0xFD, 0x40, 0x0A, 0x40,
  0xD9, 0x28, 0x1B, 0xF3, 0x30, 0x0A, 0x40, 0x60, 0x92, 0x82, 0x3F, 0xD1, 0x20, 0x01, 0x28, 0x11,
  0x81, 0x48, 0x29, 0xFD, 0x34, 0x82, 0x3D, 0xF8, 0x50, 0x9A, 0x82, 0xD9, 0xAD, 0xA0, 0x87, 0x03,
  0x0B, 0xC0, 0xA0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_data_saver_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_data_saver_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_dataset_linked 18x18, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_outlined_18_device_dataset_linked_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x30, 0x23, 0x02, 0xFD, 0x02, 0x20, 0x49, 0x73, 0x90, 0x42, 0x84, 0x4F, 0x05,
  0x99, 0x28, 0x49, 0x95, 0x0F, 0x42, 0x82, 0x4F, 0x09, 0xA0, 0x01, 0xA8, 0x29, 0x0F, 0x42, 0x82,
  0x4F, 0x09, 0xA0, 0x01, 0xA8, 0x29, 0x0F, 0x42, 0x04, 0x92, 0x00, 0x12, 0x00, 0x12, 0x90, 0x42,
  0x04, 0x91, 0x0F, 0x16, 0x07, 0x02, 0x28, 0x44, 0xF0, 0x9F, 0x82, 0x84, 0x33, 0x02, 0x31, 0x28,
  0x54, 0xF0, 0x99, 0x08, 0xA8, 0x1E, 0x0B, 0xA8, 0xA1, 0xA0, 0x4F, 0x05, 0x15, 0xF6, 0x21, 0x01,
  0x15, 0xE9, 0x49, 0x38, 0x92, 0xBA, 0x04, 0xBB, 0xB7, 0x07, 0xE2, 0xA8, 0xB3, 0xE0, 0xAA, 0x04,
  0x99, 0x96, 0x07, 0xD0, 0x23, 0x30, 0x5F, 0x83, 0x30, 0x23, 0x6E, 0x86, 0x87, 0x6E, 0xFE, 0x0B,
  0xFE, 0x87, 0x28, 0x31, 0x10, 0x11, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_dataset_linked() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_dataset_linked_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_dataset 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_18_device_dataset_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x85, 0x44, 0xF0, 0x59, 0x92,
  0x89, 0x09, 0x95, 0x0F, 0x44, 0xF0, 0x9A, 0x00, 0x1A, 0x86, 0x90, 0xF4, 0x4F, 0x09, 0xA0, 0x01,
  0xA8, 0x39, 0x0F, 0x44, 0x92, 0x00, 0x12, 0x00, 0x12, 0x90, 0x04, 0x92, 0x00, 0x12, 0x00, 0x12,
  0x98, 0x34, 0x4F, 0x09, 0xA0, 0x01, 0xA8, 0x69, 0x0F, 0x44, 0xF0, 0x9A, 0x00, 0x1A, 0x89, 0x09,
  0x0F, 0x44, 0xF0, 0x59, 0x92, 0x85, 0x99, 0x50, 0xF4, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12,
  0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_dataset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_dataset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_data_usage 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_outlined_18_device_data_usage_data[] PROGMEM = {
  0x58, 0x41, 0x41, 0x14, 0x17, 0x10, 0x10, 0x9A, 0x00, 0x3A, 0x09, 0x01, 0x50, 0x20, 0xDB, 0x00,
  0x3B, 0x0D, 0x02, 0x30, 0x10, 0xDA, 0x06, 0x01, 0x20, 0x10, 0x6A, 0x0D, 0x01, 0x28, 0x29, 0xFE,
  0x36, 0x84, 0x3E, 0xF9, 0x01, 0xA0, 0x77, 0x10, 0x7A, 0x01, 0x05, 0xA7, 0x3A, 0x82, 0x57, 0xFD,
  0x73, 0x84, 0xDF, 0x76, 0xFC, 0x73, 0x84, 0xCF, 0x65, 0xFE, 0x73, 0x82, 0xEF, 0x41, 0xA0, 0x67,
  0x20, 0x40, 0xC2, 0x82, 0x9F, 0xE2, 0x60, 0x30, 0x74, 0x83, 0x1D, 0xFE, 0x64, 0x82, 0x6E, 0xFB,
  0x40, 0x20, 0xDA, 0x82, 0xEC, 0xCE, 0xA0, 0xD0, 0x25, 0x01, 0x09, 0xD0, 0xE0, 0x97, 0x38, 0x25,
  0x76, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_data_usage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_data_usage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_developer_mode 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_device_developer_mode_data[] PROGMEM = {
  0x28, 0x04, 0x32, 0x01, 0x0E, 0xF9, 0x81, 0xE1, 0x3F, 0xB8, 0x23, 0x3F, 0xC8, 0x02, 0xB8, 0x4C,
  0xF3, 0x3F, 0x36, 0x85, 0x3F, 0x31, 0x31, 0x34, 0x82, 0x31, 0x31, 0x28, 0x17, 0xF3, 0x28, 0x13,
  0xF7, 0x38, 0x17, 0xF9, 0x48, 0x59, 0xF7, 0x07, 0xF9, 0x68, 0x49, 0xF7, 0x7F, 0x96, 0x85, 0x9F,
  0x70, 0x7F, 0x94, 0x81, 0x9F, 0x73, 0x81, 0x7F, 0x32, 0x81, 0x3F, 0x72, 0x82, 0x13, 0x13, 0x48,
  0x53, 0x13, 0x13, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0xC8, 0x02, 0xB8, 0x2C, 0xF3, 0x3F, 0xB8, 0x13,
  0x1E, 0xF9, 0x0E, 0x01, 0x28, 0x04, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_developer_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_developer_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_devices_fold 18x18, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_outlined_18_device_devices_fold_data[] PROGMEM = {
  0x78, 0x21, 0x9F, 0xC6, 0x8A, 0x74, 0x01, 0x40, 0x4E, 0xE8, 0xF5, 0x33, 0x10, 0x3F, 0x26, 0xE0,
  0xBB, 0x03, 0xC0, 0xE0, 0x16, 0x89, 0x3C, 0x80, 0x3F, 0x20, 0x2F, 0x31, 0x71, 0x38, 0x93, 0xC8,
  0x03, 0xF2, 0x02, 0xF3, 0x2D, 0x13, 0x89, 0x0C, 0x80, 0x3F, 0x20, 0x2F, 0x36, 0x89, 0x3C, 0x80,
  0x3F, 0x20, 0x2F, 0x32, 0xA1, 0x38, 0x93, 0xC8, 0x03, 0xF2, 0x02, 0xF3, 0x2A, 0x13, 0x89, 0x0C,
  0x80, 0x3F, 0x20, 0x2F, 0x36, 0x89, 0x3C, 0x80, 0x3F, 0x20, 0x2F, 0x32, 0xD1, 0x38, 0x93, 0xC8,
  0x03, 0xF2, 0x02, 0xF3, 0x17, 0x13, 0x83, 0xC9, 0x7E, 0xD2, 0x81, 0x2F, 0x36, 0x82, 0xCF, 0xE7,
  0x38, 0x90, 0x2F, 0x33, 0xF2, 0x6E, 0x09, 0xF8, 0x5E, 0x10, 0x40, 0x14, 0x28, 0x03, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_devices_fold() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_devices_fold_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_devices 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_device_devices_data[] PROGMEM = {
  0x10, 0x20, 0xDF, 0xE0, 0x72, 0x07, 0x98, 0x09, 0x17, 0x03, 0x20, 0x79, 0x77, 0x20, 0x79, 0x72,
  0x0C, 0xC8, 0x1C, 0x07, 0x97, 0x29, 0x85, 0xB7, 0x7B, 0xF0, 0x79, 0x72, 0x90, 0x72, 0x82, 0x7F,
  0x07, 0x97, 0x29, 0x07, 0x28, 0x27, 0xF0, 0x79, 0x72, 0x90, 0x72, 0x82, 0x7F, 0x07, 0x97, 0x29,
  0x07, 0x28, 0x27, 0xF3, 0x99, 0x80, 0x33, 0x85, 0x10, 0xF9, 0x33, 0x9F, 0xC0, 0x71, 0xFF, 0xA8,
  0x17, 0x0C, 0xC0, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_devices() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_devices_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_device_thermostat 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_outlined_18_device_device_thermostat_data[] PROGMEM = {
  0x30, 0x01, 0x50, 0x8A, 0x08, 0x38, 0x42, 0xF7, 0x7F, 0x22, 0x84, 0x3F, 0x18, 0xF3, 0x28, 0x43,
  0xF1, 0x6F, 0x32, 0x84, 0x3F, 0x1B, 0xF3, 0x28, 0x43, 0xF1, 0x5F, 0x32, 0x84, 0x3F, 0xDD, 0xF3,
  0x20, 0x4C, 0x04, 0x20, 0xCC, 0x81, 0xC0, 0x6E, 0x06, 0x08, 0xE0, 0x80, 0x6E, 0x81, 0x61, 0xEC,
  0x83, 0xE1, 0x02, 0xCA, 0x0C, 0x02, 0x40, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_device_thermostat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_device_thermostat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_discount 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_outlined_18_device_discount_data[] PROGMEM = {
  0x28, 0x01, 0x17, 0x01, 0x0D, 0xD0, 0x96, 0x87, 0x4F, 0x43, 0x33, 0x6F, 0x95, 0x83, 0x4F, 0x0A,
  0x62, 0x81, 0x4F, 0x94, 0x83, 0x4F, 0x0B, 0x73, 0x81, 0x4F, 0x93, 0x04, 0x97, 0x81, 0x4F, 0x92,
  0x81, 0x4F, 0x17, 0x86, 0x4F, 0x90, 0x1D, 0xC1, 0x78, 0x65, 0xF3, 0x02, 0xDC, 0x16, 0x87, 0xBE,
  0x14, 0x42, 0xDC, 0x14, 0x89, 0x1B, 0xE2, 0x03, 0xF4, 0x2D, 0xC1, 0x28, 0xA1, 0xBE, 0x23, 0x10,
  0x9F, 0x42, 0xDC, 0x1B, 0xE2, 0x3E, 0x32, 0x89, 0x19, 0xF4, 0x2D, 0xFE, 0x23, 0xEA, 0x48, 0x79,
  0xF4, 0x17, 0x23, 0xEA, 0x68, 0x59, 0xF4, 0x03, 0xEA, 0x71, 0x83, 0x9F, 0x7E, 0xA7, 0x38, 0x19,
  0xFA, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_discount() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_discount_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_do_not_disturb_on_total_silence 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_outlined_18_device_do_not_disturb_on_total_silence_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x89,
  0x29, 0xF5, 0x02, 0x66, 0x20, 0x5F, 0x93, 0x83, 0x3F, 0x50, 0x9C, 0x83, 0x90, 0x5F, 0x32, 0x82,
  0xBB, 0x09, 0xE8, 0x29, 0x0B, 0xB2, 0x90, 0x50, 0x2F, 0x98, 0x62, 0x5F, 0x02, 0xF3, 0x6A, 0x82,
  0x75, 0x57, 0xA8, 0x66, 0x3F, 0x22, 0xF3, 0x6A, 0x82, 0x75, 0x57, 0xA8, 0x66, 0x3F, 0x20, 0xF5,
  0x2F, 0x90, 0x20, 0x59, 0x28, 0x2B, 0xB0, 0x9E, 0x82, 0x90, 0xBB, 0x28, 0x33, 0xF5, 0x09, 0xC8,
  0x39, 0x05, 0xF3, 0x38, 0x92, 0x9F, 0x50, 0x26, 0x62, 0x05, 0xF9, 0x58, 0x90, 0x9F, 0xB5, 0x33,
  0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_do_not_disturb_on_total_silence() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_do_not_disturb_on_total_silence_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_dvr 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_outlined_18_device_dvr_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x87, 0x3F, 0x33, 0xF3, 0x3F, 0x3F, 0x98, 0x90, 0x33, 0xF3, 0x3F, 0x31,
  0x71, 0x80, 0x47, 0x85, 0x13, 0xF3, 0x3F, 0x37, 0x58, 0x73, 0xF3, 0x3F, 0x33, 0xF3, 0xF9, 0x89,
  0x03, 0x3F, 0x33, 0xF3, 0x17, 0x18, 0x04, 0x78, 0x51, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33,
  0xF6, 0x80, 0x90, 0x38, 0x36, 0xF3, 0x1E, 0xFF, 0x0E, 0x01, 0x28, 0x00, 0x3E, 0x80, 0x03, 0x71,
  0x80, 0x2B, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_edgesensor_high 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_18_device_edgesensor_high_data[] PROGMEM = {
  0x50, 0x18, 0x02, 0x30, 0x17, 0x20, 0x4F, 0x90, 0x47, 0x10, 0x70, 0xD8, 0x02, 0x10, 0xD0, 0x77,
  0x10, 0x7F, 0x90, 0x76, 0x82, 0x75, 0x7E, 0x80, 0x25, 0x0E, 0x07, 0x20, 0x30, 0x92, 0x82, 0xB9,
  0x7D, 0x60, 0xD0, 0x72, 0x86, 0x5F, 0xC4, 0xB9, 0x7D, 0x68, 0x3D, 0x77, 0x95, 0xA8, 0x35, 0xB9,
  0x7D, 0x68, 0x3D, 0x79, 0xB5, 0xA8, 0x35, 0xB9, 0x7D, 0x68, 0x3D, 0x79, 0xB5, 0xA8, 0x35, 0x97,
  0x7D, 0x68, 0x6D, 0x79, 0xB4, 0xCF, 0x52, 0x07, 0x0D, 0x68, 0x2D, 0x79, 0xB2, 0x09, 0x03, 0x20,
  0x70, 0xE8, 0x02, 0x58, 0x2E, 0x75, 0x76, 0x07, 0xF9, 0x07, 0x71, 0x07, 0x0D, 0x80, 0x21, 0x0D,
  0x07, 0x71, 0x04, 0xF9, 0x04, 0x72, 0x01, 0x80, 0x23, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_edgesensor_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_edgesensor_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_edgesensor_low 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_outlined_18_device_edgesensor_low_data[] PROGMEM = {
  0x40, 0x18, 0x02, 0x30, 0x17, 0x04, 0xF9, 0x04, 0x60, 0x70, 0xD8, 0x02, 0x10, 0xD0, 0x76, 0x07,
  0xF9, 0x07, 0x38, 0x31, 0x91, 0x7E, 0x80, 0x25, 0x0E, 0x07, 0x38, 0x33, 0xF2, 0x7D, 0x60, 0xD0,
  0x73, 0x83, 0x3F, 0x27, 0xD6, 0x89, 0x0D, 0x71, 0xC2, 0x3F, 0x27, 0xD6, 0x89, 0x0D, 0x72, 0xF3,
  0x3F, 0x27, 0xD6, 0x89, 0x0D, 0x72, 0xF3, 0x2C, 0x17, 0xD6, 0x83, 0xD7, 0x2F, 0x33, 0x07, 0x0D,
  0x68, 0x3D, 0x72, 0xF3, 0x30, 0x70, 0xE8, 0x02, 0x58, 0x3E, 0x71, 0x91, 0x30, 0x7F, 0x90, 0x76,
  0x07, 0x0D, 0x80, 0x21, 0x0D, 0x07, 0x60, 0x4F, 0x90, 0x47, 0x01, 0x80, 0x23, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_edgesensor_low() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_edgesensor_low_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_e_mobiledata 18x18, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_outlined_18_device_e_mobiledata_data[] PROGMEM = {
  0x89, 0x46, 0x99, 0x99, 0x6A, 0xEB, 0xBB, 0x8A, 0xA4, 0x89, 0x4A, 0xD9, 0x99, 0x6A, 0xD9, 0x99,
  0x6A, 0xA4, 0x89, 0x2A, 0xEB, 0xBB, 0x86, 0x99, 0x99, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_e_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 5, 11, 12), Box(0, 0, 17, 17),
      ic_outlined_18_device_e_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_flashlight_off 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_outlined_18_device_flashlight_off_data[] PROGMEM = {
  0x30, 0x18, 0x04, 0x30, 0x13, 0x81, 0x20, 0x6F, 0x90, 0x72, 0x81, 0x1E, 0x71, 0x80, 0x31, 0x0D,
  0x07, 0x38, 0x36, 0xF7, 0x09, 0xE0, 0x74, 0x81, 0x6F, 0x71, 0x80, 0x15, 0x0E, 0x07, 0x58, 0x16,
  0xF7, 0x48, 0x13, 0xF5, 0x68, 0x1A, 0xF7, 0x30, 0xD0, 0xA7, 0x86, 0x1E, 0xF7, 0x05, 0xE1, 0x71,
  0x84, 0xAE, 0xF7, 0x04, 0x72, 0x83, 0xAA, 0x6F, 0x77, 0x38, 0x4A, 0xA0, 0x6F, 0x77, 0x20, 0x0A,
  0x28, 0x1A, 0xF7, 0x71, 0x00, 0xA2, 0x82, 0xAE, 0xF7, 0x78, 0x7A, 0xA1, 0x1A, 0xA6, 0xF7, 0x60,
  0xAC, 0x83, 0xA0, 0x6E, 0x25, 0x84, 0x23, 0x33, 0x32, 0x20, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_flashlight_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_flashlight_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_flashlight_on 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_outlined_18_device_flashlight_on_data[] PROGMEM = {
  0x01, 0x80, 0x43, 0x01, 0x07, 0xF9, 0x81, 0x77, 0xD8, 0x02, 0x18, 0x1D, 0x77, 0xF9, 0x81, 0x77,
  0xE8, 0x02, 0x58, 0x3E, 0x75, 0xF4, 0x48, 0x44, 0xF5, 0x0A, 0xD4, 0x0D, 0x0A, 0x28, 0x11, 0xE8,
  0x28, 0x18, 0xE1, 0x38, 0x4A, 0xA4, 0x4A, 0xA4, 0x84, 0xAA, 0xCC, 0xAA, 0x48, 0x4A, 0xA1, 0x1A,
  0xA4, 0x00, 0xA2, 0x00, 0xA4, 0x00, 0xA2, 0x00, 0xA4, 0x84, 0xAA, 0x11, 0xAA, 0x40, 0xAC, 0x0A,
  0x48, 0x42, 0x33, 0x33, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_flashlight_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 13, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_flashlight_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_flourescent 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_outlined_18_device_flourescent_data[] PROGMEM = {
  0x50, 0x02, 0x73, 0x00, 0xA6, 0x01, 0x30, 0x0A, 0x38, 0x31, 0x09, 0xD1, 0x68, 0x31, 0xD9, 0x19,
  0x71, 0x81, 0x91, 0x18, 0x06, 0x30, 0x10, 0x6F, 0xB8, 0x16, 0x6E, 0x80, 0x41, 0x82, 0xE6, 0x6E,
  0x80, 0x41, 0x81, 0xE6, 0x6F, 0xB0, 0x60, 0x18, 0x06, 0x38, 0x11, 0x19, 0x71, 0x83, 0x91, 0x9D,
  0x16, 0x83, 0x1D, 0x90, 0x13, 0x00, 0xA3, 0x01, 0x60, 0x0A, 0x73, 0x00, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_flourescent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_flourescent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_fluorescent 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_outlined_18_device_fluorescent_data[] PROGMEM = {
  0x50, 0x02, 0x73, 0x00, 0xA6, 0x01, 0x30, 0x0A, 0x38, 0x31, 0x09, 0xD1, 0x68, 0x31, 0xD9, 0x19,
  0x71, 0x81, 0x91, 0x18, 0x06, 0x30, 0x10, 0x6F, 0xB8, 0x16, 0x6E, 0x80, 0x41, 0x82, 0xE6, 0x6E,
  0x80, 0x41, 0x81, 0xE6, 0x6F, 0xB0, 0x60, 0x18, 0x06, 0x38, 0x11, 0x19, 0x71, 0x83, 0x91, 0x9D,
  0x16, 0x83, 0x1D, 0x90, 0x13, 0x00, 0xA3, 0x01, 0x60, 0x0A, 0x73, 0x00, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_fluorescent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_fluorescent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_fmd_bad 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_outlined_18_device_fmd_bad_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x38, 0x90, 0x2D, 0xE7, 0x33, 0x7E, 0xD2, 0x28,
  0x94, 0xDC, 0x10, 0x55, 0x01, 0xCD, 0x06, 0xF2, 0x20, 0x0A, 0x28, 0x32, 0xF6, 0xBB, 0x30, 0x0A,
  0x38, 0x2B, 0xBC, 0x83, 0x00, 0xA3, 0x82, 0x8C, 0xAA, 0x30, 0x01, 0x38, 0x3B, 0xA6, 0xE1, 0x20,
  0x05, 0x28, 0x41, 0xE6, 0x0E, 0x92, 0x00, 0x82, 0x09, 0x0E, 0x28, 0x15, 0xF4, 0x48, 0x14, 0xF5,
  0x38, 0x1A, 0xE2, 0x28, 0x12, 0xEA, 0x58, 0x4B, 0xD2, 0x2D, 0xB6, 0x84, 0x1C, 0xEE, 0xC1, 0x71,
  0x00, 0xB5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_fmd_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_fmd_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_fmd_good 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_device_fmd_good_data[] PROGMEM = {
  0x50, 0x02, 0x78, 0x11, 0x9E, 0xA8, 0x1E, 0x91, 0x38, 0x90, 0x2D, 0xE7, 0x33, 0x7E, 0xD2, 0x28,
  0x1D, 0xC1, 0x48, 0x51, 0xCD, 0x06, 0xF2, 0x68, 0x32, 0xF6, 0xBB, 0x30, 0x08, 0x38, 0x2B, 0xBC,
  0x82, 0x04, 0xA0, 0x42, 0x82, 0x8C, 0xAA, 0x28, 0x21, 0xDD, 0x12, 0x83, 0xBA, 0x6E, 0x16, 0x84,
  0x1E, 0x60, 0xE9, 0x60, 0x90, 0xE2, 0x81, 0x5F, 0x44, 0x81, 0x4F, 0x53, 0x81, 0xAE, 0x22, 0x81,
  0x2E, 0xA5, 0x84, 0xBD, 0x22, 0xDB, 0x68, 0x41, 0xCE, 0xEC, 0x17, 0x10, 0x0B, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_fmd_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_fmd_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_g_mobiledata 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_outlined_18_device_g_mobiledata_data[] PROGMEM = {
  0x89, 0x61, 0x89, 0x99, 0x81, 0x8E, 0xBB, 0xBB, 0x79, 0xB5, 0x09, 0x0B, 0x28, 0x3D, 0xD9, 0x9B,
  0x28, 0x37, 0xCA, 0x9B, 0x38, 0x96, 0xAA, 0x8E, 0xBB, 0xBE, 0x91, 0x89, 0x99, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 11, 12), Box(0, 0, 17, 17),
      ic_outlined_18_device_g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_gpp_bad 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_outlined_18_device_gpp_bad_data[] PROGMEM = {
  0x38, 0x43, 0x9E, 0xE9, 0x33, 0x89, 0x61, 0x7D, 0xFC, 0x66, 0xCF, 0xD7, 0x1D, 0xE9, 0x34, 0x84,
  0x39, 0xED, 0xD7, 0x71, 0x82, 0x7D, 0xD7, 0x20, 0x32, 0x03, 0x28, 0x96, 0x7D, 0xD7, 0x03, 0xF6,
  0x6F, 0x30, 0x7D, 0xC8, 0x20, 0x6A, 0x06, 0x28, 0x28, 0xCB, 0xA2, 0x06, 0xA0, 0x62, 0x8A, 0x1A,
  0xB8, 0xD0, 0x3F, 0x66, 0xF3, 0x0D, 0x82, 0xF5, 0x03, 0x28, 0x73, 0x05, 0xF2, 0x0A, 0xD1, 0x48,
  0x11, 0xDA, 0x28, 0x21, 0xEC, 0x12, 0x82, 0x1C, 0xE1, 0x38, 0x62, 0xDE, 0x77, 0xED, 0x25, 0x01,
  0x09, 0xA0, 0x90, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_gpp_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_gpp_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_gpp_good 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_18_device_gpp_good_data[] PROGMEM = {
  0x38, 0x43, 0x9E, 0xE9, 0x33, 0x89, 0x61, 0x7D, 0xFC, 0x66, 0xCF, 0xD7, 0x1D, 0xE9, 0x34, 0x84,
  0x39, 0xED, 0xD7, 0x71, 0x82, 0x7D, 0xD7, 0x68, 0x43, 0x07, 0xDD, 0x75, 0x8A, 0x78, 0xF1, 0x7D,
  0xC8, 0x09, 0x10, 0x8F, 0x50, 0x8C, 0xBA, 0x1D, 0xD9, 0xF5, 0x28, 0x7A, 0xB8, 0xD0, 0x1D, 0xF5,
  0x38, 0x6D, 0x82, 0xF5, 0x01, 0x43, 0x85, 0x5F, 0x20, 0xAD, 0x14, 0x81, 0x1D, 0xA2, 0x82, 0x1E,
  0xC1, 0x28, 0x21, 0xCE, 0x13, 0x86, 0x2D, 0xE7, 0x7E, 0xD2, 0x50, 0x10, 0x9A, 0x09, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_gpp_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_gpp_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_gpp_maybe 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_outlined_18_device_gpp_maybe_data[] PROGMEM = {
  0x38, 0x43, 0x9E, 0xE9, 0x33, 0x89, 0x61, 0x7D, 0xFC, 0x66, 0xCF, 0xD7, 0x1D, 0xE9, 0x34, 0x84,
  0x39, 0xED, 0xD7, 0x30, 0x06, 0x38, 0x27, 0xDD, 0x73, 0x00, 0xA3, 0x82, 0x7D, 0xD7, 0x30, 0x0A,
  0x38, 0x27, 0xDC, 0x83, 0x00, 0xA3, 0x82, 0x8C, 0xBA, 0x71, 0x82, 0xAB, 0x8D, 0x30, 0x06, 0x38,
  0x3D, 0x82, 0xF5, 0x20, 0x07, 0x28, 0x55, 0xF2, 0x0A, 0xD1, 0x48, 0x11, 0xDA, 0x28, 0x21, 0xEC,
  0x12, 0x82, 0x1C, 0xE1, 0x38, 0x62, 0xDE, 0x77, 0xED, 0x25, 0x01, 0x09, 0xA0, 0x90, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_gpp_maybe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_gpp_maybe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_gps_fixed 18x18, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_outlined_18_device_gps_fixed_data[] PROGMEM = {
  0x71, 0x00, 0x27, 0x72, 0x00, 0xB7, 0x78, 0x43, 0x8E, 0xE8, 0x37, 0x38, 0x90, 0x1B, 0xFE, 0xCC,
  0xEF, 0xB1, 0x78, 0x21, 0xDE, 0x64, 0x82, 0x6E, 0xD1, 0x68, 0x1B, 0xE2, 0x68, 0x12, 0xEB, 0x58,
  0x13, 0xF6, 0x28, 0x28, 0xDD, 0x82, 0x81, 0x6F, 0x34, 0x08, 0x0E, 0x20, 0x8C, 0x08, 0x20, 0xE0,
  0x82, 0x82, 0x2B, 0xEC, 0x20, 0xDC, 0x0D, 0x28, 0x6C, 0xEB, 0x22, 0xBE, 0xC2, 0x0D, 0xC0, 0xD2,
  0x82, 0xCE, 0xB2, 0x20, 0x80, 0xE2, 0x08, 0xC0, 0x82, 0x0E, 0x08, 0x48, 0x13, 0xF6, 0x28, 0x28,
  0xDD, 0x82, 0x81, 0x6F, 0x35, 0x81, 0xBE, 0x26, 0x81, 0x2E, 0xB6, 0x82, 0x1D, 0xE6, 0x48, 0x26,
  0xED, 0x17, 0x89, 0x01, 0xBF, 0xEC, 0xCE, 0xFB, 0x17, 0x38, 0x43, 0x8E, 0xE8, 0x37, 0x70, 0x0B,
  0x77, 0x20, 0x02, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_gps_fixed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_gps_fixed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_gps_not_fixed 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_outlined_18_device_gps_not_fixed_data[] PROGMEM = {
  0x71, 0x00, 0x27, 0x72, 0x00, 0xB7, 0x78, 0x43, 0x8E, 0xE8, 0x37, 0x38, 0x90, 0x1B, 0xFE, 0xCC,
  0xEF, 0xB1, 0x78, 0x21, 0xDE, 0x64, 0x82, 0x6E, 0xD1, 0x68, 0x1B, 0xE2, 0x68, 0x12, 0xEB, 0x58,
  0x13, 0xF6, 0x71, 0x81, 0x6F, 0x34, 0x08, 0x0E, 0x73, 0x0E, 0x08, 0x28, 0x22, 0xBE, 0xC7, 0x38,
  0x6C, 0xEB, 0x22, 0xBE, 0xC7, 0x38, 0x2C, 0xEB, 0x22, 0x08, 0x0E, 0x73, 0x0E, 0x08, 0x48, 0x13,
  0xF6, 0x71, 0x81, 0x6F, 0x35, 0x81, 0xBE, 0x26, 0x81, 0x2E, 0xB6, 0x82, 0x1D, 0xE6, 0x48, 0x26,
  0xED, 0x17, 0x89, 0x01, 0xBF, 0xEC, 0xCE, 0xFB, 0x17, 0x38, 0x43, 0x8E, 0xE8, 0x37, 0x70, 0x0B,
  0x77, 0x20, 0x02, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_gps_not_fixed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_gps_not_fixed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_gps_off 18x18, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_outlined_18_device_gps_off_data[] PROGMEM = {
  0x71, 0x00, 0x27, 0x72, 0x00, 0xB7, 0x30, 0x20, 0x82, 0x84, 0x38, 0xEE, 0x83, 0x71, 0x89, 0x26,
  0xFA, 0x03, 0xEC, 0xCE, 0xFB, 0x17, 0x81, 0x7F, 0xA5, 0x82, 0x6E, 0xD1, 0x60, 0xAA, 0x0A, 0x58,
  0x12, 0xEB, 0x58, 0x43, 0xF7, 0x7F, 0xA5, 0x81, 0x6F, 0x34, 0x07, 0x92, 0x81, 0x7F, 0xA5, 0x0E,
  0x08, 0x28, 0x22, 0xBE, 0xC3, 0x81, 0x7F, 0xA4, 0x86, 0xCE, 0xB2, 0x2B, 0xEC, 0x48, 0x17, 0xFA,
  0x38, 0x2C, 0xEB, 0x22, 0x08, 0x0E, 0x58, 0x17, 0xFA, 0x20, 0xE0, 0x84, 0x81, 0x3F, 0x65, 0x84,
  0x7F, 0xA0, 0x33, 0x58, 0x1B, 0xE2, 0x58, 0x17, 0xFA, 0x78, 0x21, 0xDE, 0x64, 0x07, 0xA0, 0xA7,
  0x84, 0x1B, 0xFE, 0xCC, 0xA8, 0x2A, 0x7F, 0x87, 0x18, 0x43, 0x8E, 0xE7, 0x32, 0x06, 0x02, 0x73,
  0x00, 0xB7, 0x72, 0x00, 0x27, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_gps_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_gps_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_graphic_eq 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_outlined_18_device_graphic_eq_data[] PROGMEM = {
  0x60, 0x05, 0x75, 0x00, 0xB7, 0x50, 0x0B, 0x72, 0x86, 0x55, 0x0B, 0xB0, 0x55, 0x68, 0x6B, 0xB0,
  0xBB, 0x0B, 0xB6, 0x86, 0xBB, 0x0B, 0xB0, 0xBB, 0x38, 0xE6, 0x55, 0x0B, 0xB0, 0xBB, 0x0B, 0xB0,
  0x55, 0xBB, 0x0B, 0xB0, 0xBB, 0x0B, 0xB0, 0xBB, 0xBB, 0x0B, 0xB0, 0xBB, 0x0B, 0xB0, 0xBB, 0x55,
  0x0B, 0xB0, 0xBB, 0x0B, 0xB0, 0x55, 0x38, 0x6B, 0xB0, 0xBB, 0x0B, 0xB6, 0x86, 0xBB, 0x0B, 0xB0,
  0xBB, 0x68, 0x65, 0x50, 0xBB, 0x05, 0x57, 0x20, 0x0B, 0x75, 0x00, 0xB7, 0x50, 0x05, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_graphic_eq() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_graphic_eq_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_grid_3x3 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_outlined_18_device_grid_3x3_data[] PROGMEM = {
  0x30, 0x40, 0x32, 0x03, 0x04, 0x60, 0x0A, 0x20, 0x0A, 0x60, 0x0A, 0x20, 0x0A, 0x38, 0xA6, 0x4B,
  0xBE, 0xEB, 0xBE, 0xEB, 0xB4, 0x39, 0x9D, 0xD9, 0x9D, 0xD9, 0x93, 0x30, 0x0A, 0x20, 0x0A, 0x60,
  0x0A, 0x20, 0x0A, 0x38, 0xA6, 0x39, 0x9D, 0xD9, 0x9D, 0xD9, 0x93, 0x4B, 0xBE, 0xEB, 0xBE, 0xEB,
  0xB4, 0x30, 0x0A, 0x20, 0x0A, 0x60, 0x0A, 0x20, 0x0A, 0x60, 0x40, 0x32, 0x03, 0x04, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_grid_3x3() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_grid_3x3_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_grid_4x4 18x18, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_outlined_18_device_grid_4x4_data[] PROGMEM = {
  0x30, 0x30, 0x12, 0x00, 0x22, 0x01, 0x03, 0x60, 0xE0, 0x62, 0x00, 0xA2, 0x06, 0x0E, 0x60, 0xE0,
  0x62, 0x00, 0xA2, 0x06, 0x0E, 0x30, 0x3F, 0xF8, 0x97, 0x31, 0x55, 0xF9, 0x55, 0xCC, 0x55, 0x9F,
  0x55, 0x13, 0x0E, 0x06, 0x20, 0x0A, 0x20, 0x60, 0xE6, 0x0E, 0x06, 0x20, 0x0A, 0x20, 0x60, 0xE3,
  0x8B, 0x61, 0x99, 0xFB, 0x99, 0xDD, 0x99, 0xBF, 0x99, 0x11, 0x99, 0xFB, 0x99, 0xDD, 0x99, 0xBF,
  0x99, 0x13, 0x0E, 0x06, 0x20, 0x0A, 0x20, 0x60, 0xE6, 0x0E, 0x06, 0x20, 0x0A, 0x20, 0x60, 0xE3,
  0x89, 0x71, 0x55, 0xF9, 0x55, 0xCC, 0x55, 0x9F, 0x55, 0x13, 0xFF, 0x03, 0x30, 0xE0, 0x62, 0x00,
  0xA2, 0x06, 0x0E, 0x60, 0xE0, 0x62, 0x00, 0xA2, 0x06, 0x0E, 0x60, 0x30, 0x12, 0x00, 0x22, 0x01,
  0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_grid_4x4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_grid_4x4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_grid_goldenratio 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_outlined_18_device_grid_goldenratio_data[] PROGMEM = {
  0x50, 0x10, 0x32, 0x03, 0x01, 0x73, 0x84, 0x3F, 0x11, 0xF3, 0x73, 0x84, 0x3F, 0x11, 0xF3, 0x73,
  0x84, 0x3F, 0x11, 0xF3, 0x73, 0x84, 0x3F, 0x11, 0xF3, 0x68, 0x00, 0x38, 0x92, 0x6F, 0x55, 0xF6,
  0x33, 0x33, 0x03, 0xFF, 0x89, 0x23, 0x01, 0x11, 0x15, 0xF3, 0x3F, 0x58, 0x00, 0x12, 0x80, 0x01,
  0x89, 0x25, 0xF3, 0x3F, 0x51, 0x11, 0x10, 0x3F, 0xF8, 0x92, 0x30, 0x33, 0x33, 0x6F, 0x55, 0xF6,
  0x80, 0x03, 0x68, 0x43, 0xF1, 0x1F, 0x37, 0x38, 0x43, 0xF1, 0x1F, 0x37, 0x38, 0x43, 0xF1, 0x1F,
  0x37, 0x38, 0x43, 0xF1, 0x1F, 0x37, 0x30, 0x10, 0x32, 0x03, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_grid_goldenratio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_grid_goldenratio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_hdr_auto 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_outlined_18_device_hdr_auto_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x52, 0x00, 0x62, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x52, 0x01, 0xA0, 0x12, 0x81, 0x5F, 0x32,
  0x00, 0xB3, 0x82, 0x7C, 0xC7, 0x30, 0x0B, 0x29, 0x05, 0x38, 0x2D, 0x66, 0xD3, 0x84, 0x5F, 0x02,
  0xF3, 0x28, 0x43, 0xF1, 0x1F, 0x32, 0x84, 0x3F, 0x22, 0xF3, 0x28, 0x49, 0xE9, 0x9E, 0x92, 0x84,
  0x3F, 0x20, 0xF5, 0x28, 0x4E, 0xA7, 0x79, 0xE2, 0x05, 0x92, 0x82, 0xBB, 0x05, 0x94, 0x98, 0x25,
  0x0B, 0xB2, 0x83, 0x3F, 0x56, 0x74, 0x83, 0x76, 0x5F, 0x33, 0x81, 0x9F, 0x56, 0x81, 0x5F, 0x95,
  0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_hdr_auto() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_hdr_auto_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_hdr_auto_select 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_18_device_hdr_auto_select_data[] PROGMEM = {
  0x71, 0x00, 0x17, 0x70, 0x40, 0xDA, 0x0D, 0x04, 0x74, 0x03, 0xA0, 0x0A, 0xA0, 0x37, 0x30, 0xBA,
  0x00, 0x4A, 0x0B, 0x73, 0x86, 0xEF, 0xB7, 0x7C, 0xFE, 0x73, 0x86, 0xEF, 0x63, 0x36, 0xFE, 0x73,
  0x81, 0x9F, 0x5A, 0x81, 0x5F, 0x97, 0x30, 0x10, 0xDC, 0x0D, 0x01, 0x74, 0x84, 0x18, 0xCC, 0x81,
  0x77, 0x73, 0x89, 0x03, 0x11, 0x30, 0x33, 0x30, 0x20, 0xF3, 0x28, 0x61, 0x10, 0xF5, 0x4F, 0x1B,
  0x05, 0x08, 0xB8, 0xD4, 0x50, 0xC8, 0x0F, 0xCC, 0xF1, 0xF4, 0xC8, 0x8D, 0x7E, 0x89, 0xEC, 0x9F,
  0xBB, 0xF1, 0xF6, 0xC8, 0x8F, 0xEF, 0x4B, 0xED, 0xBF, 0x54, 0xF1, 0xB8, 0xB1, 0x48, 0xC1, 0xF6,
  0x0C, 0x80, 0x31, 0x13, 0x03, 0x32, 0x02, 0x30, 0x32, 0x03, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_hdr_auto_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_hdr_auto_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_hdr_off_select 18x18, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_outlined_18_device_hdr_off_select_data[] PROGMEM = {
  0x71, 0x02, 0x01, 0x75, 0x82, 0x49, 0x05, 0xA0, 0xD0, 0x47, 0x38, 0x74, 0xF9, 0x02, 0x3A, 0xF3,
  0x73, 0x81, 0xCF, 0x93, 0x00, 0xB7, 0x39, 0x81, 0x9F, 0x92, 0x05, 0x0E, 0x73, 0x86, 0xE6, 0x4F,
  0x90, 0x4E, 0x73, 0x86, 0x9D, 0x14, 0xF9, 0x03, 0x73, 0x85, 0x1D, 0xD8, 0xBF, 0x97, 0x58, 0x51,
  0x8C, 0xD9, 0xF8, 0x77, 0x20, 0x40, 0x15, 0x89, 0x03, 0x11, 0x30, 0x33, 0x30, 0x20, 0xF3, 0x28,
  0x61, 0x10, 0xF5, 0x4F, 0x1B, 0x05, 0x08, 0xB8, 0xD4, 0x50, 0xC8, 0x0F, 0xCC, 0xF1, 0xF4, 0xC8,
  0x8D, 0x7E, 0x89, 0xEC, 0x9F, 0xBB, 0xF1, 0xF6, 0xC8, 0x8F, 0xEF, 0x4B, 0xED, 0xBF, 0x54, 0xF1,
  0xB8, 0xB1, 0x48, 0xC1, 0xF6, 0x0C, 0x80, 0x31, 0x13, 0x03, 0x32, 0x02, 0x30, 0x32, 0x03, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_hdr_off_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_hdr_off_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_hdr_on_select 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_outlined_18_device_hdr_on_select_data[] PROGMEM = {
  0x71, 0x00, 0x17, 0x70, 0x40, 0xDA, 0x0D, 0x04, 0x74, 0x86, 0x3F, 0xA3, 0x3A, 0xF3, 0x73, 0x00,
  0xB4, 0x00, 0xB7, 0x30, 0xE0, 0x54, 0x05, 0x0E, 0x73, 0x0E, 0x06, 0x40, 0x60, 0xE7, 0x38, 0x19,
  0xD1, 0x28, 0x11, 0xD9, 0x73, 0x86, 0x1D, 0xD8, 0x8D, 0xD1, 0x74, 0x84, 0x18, 0xCC, 0x81, 0x77,
  0x73, 0x89, 0x03, 0x11, 0x30, 0x33, 0x30, 0x20, 0xF3, 0x28, 0x61, 0x10, 0xF5, 0x4F, 0x1B, 0x05,
  0x08, 0xB8, 0xD4, 0x50, 0xC8, 0x0F, 0xCC, 0xF1, 0xF4, 0xC8, 0x8D, 0x7E, 0x89, 0xEC, 0x9F, 0xBB,
  0xF1, 0xF6, 0xC8, 0x8F, 0xEF, 0x4B, 0xED, 0xBF, 0x54, 0xF1, 0xB8, 0xB1, 0x48, 0xC1, 0xF6, 0x0C,
  0x80, 0x31, 0x13, 0x03, 0x32, 0x02, 0x30, 0x32, 0x03, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_hdr_on_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_hdr_on_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_h_mobiledata 18x18, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_outlined_18_device_h_mobiledata_data[] PROGMEM = {
  0x05, 0x07, 0x48, 0x27, 0x59, 0xB4, 0x82, 0xB9, 0x9B, 0x48, 0xA2, 0xB9, 0x9E, 0x99, 0x99, 0xE9,
  0x9E, 0x99, 0x99, 0xE9, 0x9B, 0x48, 0x2B, 0x99, 0xB4, 0x82, 0xB9, 0x57, 0x40, 0x70, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_h_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 5, 12, 12), Box(0, 0, 17, 17),
      ic_outlined_18_device_h_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_h_plus_mobiledata 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_outlined_18_device_h_plus_mobiledata_data[] PROGMEM = {
  0x03, 0x09, 0x40, 0x50, 0x76, 0x06, 0x0E, 0x40, 0x80, 0xC2, 0x00, 0x22, 0x06, 0x0E, 0x40, 0x80,
  0xC2, 0x0B, 0x09, 0x28, 0xB4, 0x6F, 0x99, 0x99, 0xCC, 0x29, 0xDD, 0x91, 0x6F, 0x99, 0x99, 0xCC,
  0x29, 0xDD, 0x91, 0x6E, 0x40, 0x80, 0xC2, 0x0B, 0x09, 0x20, 0x60, 0xE4, 0x08, 0x0C, 0x20, 0x02,
  0x20, 0x30, 0x94, 0x05, 0x07, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_h_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 16, 12), Box(0, 0, 17, 17),
      ic_outlined_18_device_h_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_lan 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_device_lan_data[] PROGMEM = {
  0x48, 0x42, 0x33, 0x33, 0x27, 0x10, 0xAC, 0x0A, 0x71, 0x84, 0xAA, 0x11, 0xAA, 0x71, 0x00, 0xA2,
  0x00, 0xA7, 0x10, 0xAC, 0x0A, 0x71, 0x84, 0x23, 0xBB, 0x32, 0x73, 0x00, 0xA7, 0x18, 0x90, 0x29,
  0x99, 0xDD, 0x99, 0x92, 0x48, 0x90, 0x4F, 0xA9, 0x99, 0x9A, 0xF4, 0x48, 0x14, 0xF1, 0x48, 0x11,
  0xF4, 0x28, 0x41, 0x37, 0xF4, 0x32, 0x85, 0x34, 0xF7, 0x31, 0x4D, 0x00, 0x1D, 0x00, 0x49, 0x28,
  0x43, 0xF1, 0x1F, 0x32, 0x98, 0x96, 0x44, 0xF2, 0x15, 0xF1, 0x1F, 0x51, 0x2F, 0x44, 0xD0, 0x01,
  0xD0, 0x40, 0x18, 0x01, 0x32, 0x80, 0x13, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_lan() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_lan_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_lens_blur 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_outlined_18_device_lens_blur_data[] PROGMEM = {
  0x50, 0x52, 0x05, 0x77, 0x79, 0x86, 0x31, 0xF2, 0x2F, 0x13, 0x94, 0x03, 0x20, 0x32, 0x03, 0x20,
  0x34, 0x01, 0x20, 0x62, 0x06, 0x20, 0x12, 0x89, 0x45, 0x0F, 0x36, 0xF6, 0x6F, 0x63, 0xF0, 0x52,
  0x02, 0x28, 0x27, 0x11, 0x72, 0x02, 0x40, 0x22, 0x82, 0x71, 0x17, 0x20, 0x22, 0x89, 0x45, 0x0F,
  0x36, 0xF6, 0x6F, 0x63, 0xF0, 0x52, 0x01, 0x20, 0x62, 0x06, 0x20, 0x14, 0x03, 0x20, 0x32, 0x03,
  0x20, 0x34, 0x98, 0x63, 0x1F, 0x22, 0xF1, 0x39, 0x77, 0x70, 0x52, 0x05, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_lens_blur() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_lens_blur_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_light_mode 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_outlined_18_device_light_mode_data[] PROGMEM = {
  0x70, 0x09, 0x77, 0x00, 0xA7, 0x20, 0x30, 0x53, 0x00, 0x83, 0x05, 0x03, 0x48, 0x15, 0xF6, 0x68,
  0x16, 0xF5, 0x58, 0x90, 0x65, 0x03, 0x77, 0x30, 0x56, 0x71, 0x84, 0x7F, 0xDD, 0xF7, 0x72, 0x81,
  0x3F, 0x62, 0x81, 0x6F, 0x34, 0x84, 0x89, 0x80, 0x7D, 0x48, 0x92, 0xD7, 0x08, 0x98, 0x89, 0x80,
  0x7D, 0x48, 0x4D, 0x70, 0x89, 0x84, 0x81, 0x3F, 0x62, 0x81, 0x6F, 0x37, 0x28, 0x47, 0xFD, 0xDF,
  0x77, 0x18, 0x90, 0x65, 0x03, 0x77, 0x30, 0x56, 0x58, 0x15, 0xF6, 0x68, 0x16, 0xF5, 0x40, 0x30,
  0x53, 0x00, 0x83, 0x05, 0x03, 0x72, 0x00, 0xA7, 0x70, 0x09, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_light_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_light_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_location_disabled 18x18, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_outlined_18_device_location_disabled_data[] PROGMEM = {
  0x71, 0x00, 0x27, 0x72, 0x00, 0xB7, 0x30, 0x20, 0x82, 0x84, 0x38, 0xEE, 0x83, 0x71, 0x89, 0x26,
  0xFA, 0x03, 0xEC, 0xCE, 0xFB, 0x17, 0x81, 0x7F, 0xA5, 0x82, 0x6E, 0xD1, 0x60, 0xAA, 0x0A, 0x58,
  0x12, 0xEB, 0x58, 0x43, 0xF7, 0x7F, 0xA5, 0x81, 0x6F, 0x34, 0x07, 0x92, 0x81, 0x7F, 0xA5, 0x0E,
  0x08, 0x28, 0x22, 0xBE, 0xC3, 0x81, 0x7F, 0xA4, 0x86, 0xCE, 0xB2, 0x2B, 0xEC, 0x48, 0x17, 0xFA,
  0x38, 0x2C, 0xEB, 0x22, 0x08, 0x0E, 0x58, 0x17, 0xFA, 0x20, 0xE0, 0x84, 0x81, 0x3F, 0x65, 0x84,
  0x7F, 0xA0, 0x33, 0x58, 0x1B, 0xE2, 0x58, 0x17, 0xFA, 0x78, 0x21, 0xDE, 0x64, 0x07, 0xA0, 0xA7,
  0x84, 0x1B, 0xFE, 0xCC, 0xA8, 0x2A, 0x7F, 0x87, 0x18, 0x43, 0x8E, 0xE7, 0x32, 0x06, 0x02, 0x73,
  0x00, 0xB7, 0x72, 0x00, 0x27, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_location_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_location_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_location_searching 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_outlined_18_device_location_searching_data[] PROGMEM = {
  0x71, 0x00, 0x27, 0x72, 0x00, 0xB7, 0x78, 0x43, 0x8E, 0xE8, 0x37, 0x38, 0x90, 0x1B, 0xFE, 0xCC,
  0xEF, 0xB1, 0x78, 0x21, 0xDE, 0x64, 0x82, 0x6E, 0xD1, 0x68, 0x1B, 0xE2, 0x68, 0x12, 0xEB, 0x58,
  0x13, 0xF6, 0x71, 0x81, 0x6F, 0x34, 0x08, 0x0E, 0x73, 0x0E, 0x08, 0x28, 0x22, 0xBE, 0xC7, 0x38,
  0x6C, 0xEB, 0x22, 0xBE, 0xC7, 0x38, 0x2C, 0xEB, 0x22, 0x08, 0x0E, 0x73, 0x0E, 0x08, 0x48, 0x13,
  0xF6, 0x71, 0x81, 0x6F, 0x35, 0x81, 0xBE, 0x26, 0x81, 0x2E, 0xB6, 0x82, 0x1D, 0xE6, 0x48, 0x26,
  0xED, 0x17, 0x89, 0x01, 0xBF, 0xEC, 0xCE, 0xFB, 0x17, 0x38, 0x43, 0x8E, 0xE8, 0x37, 0x70, 0x0B,
  0x77, 0x20, 0x02, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_location_searching() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_location_searching_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_lte_mobiledata 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_outlined_18_device_lte_mobiledata_data[] PROGMEM = {
  0x03, 0x0B, 0x28, 0x91, 0x8B, 0xBB, 0x93, 0xBB, 0xB3, 0x49, 0x28, 0x91, 0x6A, 0xFB, 0x74, 0xF9,
  0x92, 0x49, 0x38, 0x90, 0x1F, 0x30, 0x4F, 0x99, 0x24, 0x93, 0x8C, 0x31, 0xF3, 0x04, 0xF9, 0x92,
  0x4F, 0x99, 0x21, 0xF3, 0x04, 0xF9, 0x92, 0x3B, 0xBB, 0x31, 0xB2, 0x03, 0xBB, 0xB3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_lte_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 15, 11), Box(0, 0, 17, 17),
      ic_outlined_18_device_lte_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_lte_plus_mobiledata 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_outlined_18_device_lte_plus_mobiledata_data[] PROGMEM = {
  0x89, 0x31, 0xB2, 0x4B, 0xBB, 0xB1, 0xBB, 0xB7, 0x28, 0x96, 0x31, 0x01, 0xF3, 0x39, 0xEC, 0x91,
  0xFB, 0x95, 0x28, 0x4E, 0x60, 0x1F, 0x32, 0x0C, 0x08, 0x29, 0x89, 0x1B, 0x95, 0x49, 0xFC, 0x91,
  0xF3, 0x20, 0xC0, 0x82, 0x98, 0x95, 0xB9, 0x54, 0x9F, 0xC9, 0x1F, 0xB9, 0x4C, 0x82, 0x98, 0x1B,
  0x95, 0x28, 0x90, 0xE6, 0x01, 0xBB, 0xB5, 0x96, 0x20, 0xFB, 0x07, 0x20, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_lte_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 17, 11), Box(0, 0, 17, 17),
      ic_outlined_18_device_lte_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_macro_off 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_outlined_18_device_macro_off_data[] PROGMEM = {
  0x60, 0x7A, 0x07, 0x60, 0x22, 0x86, 0x5B, 0xF8, 0x8F, 0xA5, 0x38, 0x93, 0x1E, 0x70, 0x9B, 0xE6,
  0x6E, 0xAF, 0x43, 0x81, 0x6F, 0x72, 0x0B, 0xA8, 0x2B, 0x0D, 0x84, 0x89, 0x16, 0xF7, 0x09, 0x44,
  0xFB, 0xF5, 0x58, 0x90, 0x8F, 0x70, 0x28, 0xF6, 0xE6, 0x50, 0x7A, 0x85, 0x70, 0x9A, 0x0D, 0x85,
  0x02, 0x0E, 0xA8, 0x47, 0x09, 0xFE, 0x26, 0x86, 0x15, 0xEF, 0x70, 0x51, 0x48, 0xB3, 0x3F, 0xC6,
  0x03, 0xAF, 0x70, 0x2C, 0xF3, 0x01, 0xFD, 0xFB, 0x10, 0x6F, 0x70, 0x9F, 0x12, 0x83, 0xAC, 0x3D,
  0xB2, 0x83, 0xCF, 0x70, 0x53, 0x89, 0x12, 0xE9, 0x3F, 0x55, 0xF9, 0xF7, 0x58, 0x64, 0xED, 0xEB,
  0xBE, 0xDA, 0x07, 0x58, 0x91, 0x2A, 0xEE, 0xEE, 0xA2, 0x6E, 0x27, 0x00, 0x24, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_macro_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_macro_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_media_bluetooth_off 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_outlined_18_device_media_bluetooth_off_data[] PROGMEM = {
  0x50, 0x18, 0x00, 0x36, 0x04, 0x30, 0x3B, 0x0C, 0x58, 0x11, 0xEA, 0x20, 0x3B, 0x0C, 0x68, 0x73,
  0xEA, 0x02, 0xF6, 0x54, 0x78, 0x43, 0xEA, 0x05, 0x17, 0x38, 0x13, 0xEA, 0x50, 0x40, 0x76, 0x81,
  0x3E, 0xA2, 0x83, 0x71, 0x6E, 0x86, 0x89, 0x05, 0xFA, 0x05, 0xC7, 0x8E, 0x32, 0x82, 0x4D, 0xFE,
  0xA8, 0x1A, 0x05, 0xA0, 0x62, 0x01, 0x0E, 0xC8, 0x55, 0xEA, 0x05, 0xD1, 0x20, 0x3D, 0x89, 0x01,
  0x3E, 0xA0, 0x5C, 0x10, 0x1C, 0x0D, 0x28, 0x4B, 0xFA, 0x05, 0x22, 0x06, 0xA0, 0xE0, 0x42, 0x82,
  0x13, 0xEA, 0x50, 0x10, 0x36, 0x81, 0x3E, 0xA7, 0x68, 0x13, 0xC1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_media_bluetooth_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_media_bluetooth_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_media_bluetooth_on 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_outlined_18_device_media_bluetooth_on_data[] PROGMEM = {
  0x40, 0x18, 0x00, 0x37, 0x20, 0x3B, 0x0C, 0x72, 0x03, 0xB0, 0xC7, 0x28, 0x33, 0xF6, 0x54, 0x72,
  0x81, 0x3F, 0x17, 0x48, 0x13, 0xF1, 0x30, 0x40, 0x76, 0x87, 0x3F, 0x10, 0x71, 0x6E, 0x85, 0x89,
  0x73, 0xF1, 0x05, 0xC7, 0x8E, 0x30, 0x4D, 0xFE, 0xF1, 0x20, 0x5A, 0x82, 0x60, 0x1E, 0xC0, 0x13,
  0x83, 0xCE, 0x10, 0x3D, 0x01, 0x28, 0x4B, 0xCC, 0xC1, 0x1C, 0x0D, 0x28, 0x6A, 0x66, 0xBD, 0x20,
  0x6A, 0x0E, 0x04, 0x28, 0x31, 0x06, 0xD2, 0x30, 0x10, 0x36, 0x00, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_media_bluetooth_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_media_bluetooth_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_medication_liquid 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_outlined_18_device_medication_liquid_data[] PROGMEM = {
  0x10, 0x18, 0x03, 0x40, 0x37, 0x04, 0xF0, 0xC7, 0x77, 0x10, 0x3F, 0xA8, 0x5A, 0x06, 0xED, 0x23,
  0xFA, 0x0A, 0x01, 0xB0, 0xC0, 0x3B, 0x81, 0xD3, 0x7B, 0x0A, 0x05, 0xC0, 0x3B, 0x81, 0xD0, 0x5B,
  0x0A, 0x04, 0xC0, 0x3A, 0x58, 0x38, 0xFA, 0x0E, 0xA0, 0xA0, 0x3A, 0x89, 0x44, 0x30, 0x13, 0xAF,
  0xA0, 0x3E, 0xB1, 0x3B, 0x81, 0xD0, 0x5B, 0x0A, 0x28, 0x2C, 0x80, 0x3B, 0x81, 0xE5, 0x9B, 0x0A,
  0x28, 0x2C, 0x80, 0x3F, 0xA0, 0xA2, 0x82, 0xC8, 0x03, 0xFA, 0x0A, 0x20, 0xC0, 0x82, 0x80, 0x53,
  0x02, 0x20, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_medication_liquid() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_medication_liquid_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_medication 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_device_medication_data[] PROGMEM = {
  0x18, 0x04, 0x42, 0xF9, 0x74, 0x09, 0xF9, 0x81, 0x9E, 0x88, 0x02, 0x38, 0x28, 0xEE, 0x62, 0x00,
  0xA2, 0x82, 0x6E, 0xE6, 0x20, 0x0D, 0x28, 0x36, 0xEE, 0x6A, 0xC8, 0x5A, 0x6E, 0xE6, 0x8B, 0xA8,
  0x4B, 0x86, 0xEE, 0x62, 0x00, 0xD2, 0x82, 0x6E, 0xE6, 0x20, 0x08, 0x28, 0x26, 0xEE, 0x66, 0x81,
  0x6E, 0xBF, 0x90, 0xB1, 0x80, 0x43, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_medication() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_medication_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_mobiledata_off 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_18_device_mobiledata_off_data[] PROGMEM = {
  0x10, 0x27, 0x10, 0x14, 0x81, 0x1E, 0x76, 0x81, 0x2E, 0x74, 0x81, 0x6F, 0x74, 0x02, 0x0E, 0xA0,
  0x74, 0x81, 0x6F, 0x73, 0x84, 0xBB, 0xFB, 0xF2, 0x48, 0x16, 0xF7, 0x28, 0x31, 0x0F, 0x51, 0x68,
  0x17, 0xF7, 0x39, 0x05, 0x70, 0x5A, 0x07, 0x29, 0x05, 0x78, 0x65, 0xF6, 0xF7, 0x09, 0x57, 0x86,
  0x5F, 0x06, 0xF7, 0x01, 0x60, 0x10, 0x59, 0x28, 0x16, 0xF7, 0x68, 0x90, 0x2E, 0xBF, 0xBB, 0x06,
  0xF7, 0x60, 0x8A, 0x0E, 0x03, 0x28, 0x16, 0xF7, 0x68, 0x18, 0xE3, 0x48, 0x16, 0xF7, 0x60, 0x16,
  0x81, 0x6E, 0x27, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_mobiledata_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_mobiledata_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_mobile_friendly 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_device_mobile_friendly_data[] PROGMEM = {
  0x40, 0x28, 0x03, 0x30, 0x24, 0x07, 0xFA, 0x07, 0x30, 0xBF, 0xA0, 0xB3, 0x00, 0xB7, 0x00, 0xB3,
  0x00, 0x57, 0x00, 0xB7, 0x01, 0x40, 0x0B, 0x68, 0x13, 0xE5, 0x30, 0x0B, 0x58, 0x13, 0xEB, 0x48,
  0x2B, 0xB1, 0x82, 0x81, 0x3E, 0xB5, 0x86, 0xBB, 0x4F, 0x93, 0xEB, 0x68, 0x2B, 0xB0, 0x4A, 0x0B,
  0x70, 0x0B, 0x20, 0x40, 0xA7, 0x10, 0x0B, 0x75, 0x00, 0xB3, 0x00, 0x57, 0x00, 0xB3, 0x00, 0xB7,
  0x00, 0xB3, 0x0B, 0xFA, 0x0B, 0x30, 0x7F, 0xA0, 0x74, 0x02, 0x80, 0x33, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_mobile_friendly() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_mobile_friendly_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_mobile_off 18x18, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_outlined_18_device_mobile_off_data[] PROGMEM = {
  0x48, 0x04, 0x37, 0x0B, 0xF9, 0x0E, 0x01, 0x28, 0x38, 0xC1, 0x1D, 0xF9, 0x03, 0x28, 0x43, 0xEC,
  0x11, 0xA8, 0x01, 0xB8, 0x1C, 0xF3, 0x38, 0x23, 0xEC, 0x16, 0x81, 0x3F, 0x34, 0x82, 0x5F, 0xC1,
  0x58, 0x13, 0xF3, 0x40, 0x3A, 0x0C, 0x01, 0x48, 0x13, 0xF3, 0x48, 0x43, 0xF7, 0xEC, 0x13, 0x81,
  0x3F, 0x34, 0x85, 0x3F, 0x33, 0xEC, 0x12, 0x81, 0x3F, 0x34, 0x89, 0x23, 0xF3, 0x03, 0xEC, 0x10,
  0x3F, 0x34, 0x81, 0x3F, 0x32, 0x85, 0x3E, 0xC1, 0x1D, 0x34, 0x81, 0x3F, 0x33, 0x84, 0x3E, 0xC1,
  0x12, 0x48, 0x13, 0xF3, 0x48, 0x23, 0xEC, 0x15, 0x81, 0x3F, 0x35, 0x82, 0x3E, 0xC1, 0x48, 0x13,
  0xFC, 0x80, 0x2B, 0x82, 0xDF, 0xC1, 0x30, 0x3F, 0xC0, 0xC0, 0x12, 0x01, 0x0E, 0xF9, 0x82, 0xE4,
  0xE3, 0x48, 0x04, 0x30, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_mobile_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_mobile_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_mode_night 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_outlined_18_device_mode_night_data[] PROGMEM = {
  0x38, 0x11, 0x21, 0x68, 0x11, 0x9E, 0xB0, 0xC0, 0x55, 0x87, 0x7F, 0xA2, 0x5A, 0xFB, 0x14, 0x81,
  0x7F, 0x32, 0x81, 0x3D, 0xB5, 0x00, 0xB3, 0x81, 0x2E, 0x74, 0x81, 0x4F, 0x23, 0x08, 0x0E, 0x59,
  0x06, 0x38, 0x12, 0xF3, 0x40, 0xD0, 0x74, 0x90, 0x54, 0x0D, 0x07, 0x49, 0x05, 0x49, 0x06, 0x38,
  0x12, 0xF3, 0x38, 0x14, 0xF2, 0x30, 0x80, 0xE4, 0x00, 0xB3, 0x81, 0x2E, 0x73, 0x81, 0x7F, 0x32,
  0x81, 0x3D, 0xB3, 0x87, 0x7F, 0xA2, 0x5A, 0xFB, 0x12, 0x81, 0x19, 0xEB, 0x0C, 0x05, 0x78, 0x11,
  0x21, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_mode_night() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_mode_night_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_mode_standby 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_outlined_18_device_mode_standby_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x20, 0x0B, 0x40, 0x02, 0x40,
  0x0B, 0x29, 0x05, 0x30, 0x9A, 0x09, 0x38, 0x45, 0xF0, 0x2F, 0x32, 0x02, 0xC0, 0x22, 0x84, 0x3F,
  0x22, 0xF3, 0x20, 0x2C, 0x02, 0x28, 0x43, 0xF2, 0x0F, 0x53, 0x09, 0xA0, 0x93, 0x05, 0x92, 0x00,
  0xB4, 0x00, 0x24, 0x00, 0xB2, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x38, 0x19, 0xF5, 0x68, 0x15,
  0xF9, 0x58, 0x90, 0x9F, 0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_mode_standby() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_mode_standby_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_monitor_heart 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_outlined_18_device_monitor_heart_data[] PROGMEM = {
  0x10, 0x28, 0x09, 0x05, 0x82, 0x20, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x26, 0x01, 0x38, 0x42, 0xF3,
  0x3F, 0x25, 0x81, 0x6E, 0x22, 0x83, 0x2F, 0x30, 0x36, 0x81, 0xEF, 0xA3, 0x8C, 0x23, 0x01, 0x99,
  0x99, 0x80, 0x7E, 0x6F, 0x99, 0x99, 0x11, 0x99, 0x99, 0xF6, 0xE7, 0x08, 0x99, 0x99, 0x10, 0x33,
  0x81, 0xAF, 0xE6, 0x83, 0x30, 0x3F, 0x22, 0x81, 0x2F, 0x65, 0x84, 0x2F, 0x33, 0xF2, 0x30, 0x16,
  0x83, 0x2F, 0x31, 0xEF, 0xD8, 0x2E, 0x10, 0x28, 0x09, 0x05, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_monitor_heart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_monitor_heart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_monitor_weight 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_device_monitor_weight_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x94, 0x00, 0x64, 0x90, 0x04, 0x93, 0x0C,
  0xA0, 0xC3, 0x90, 0x04, 0x92, 0x84, 0x29, 0xBB, 0x92, 0x29, 0x00, 0x49, 0x28, 0x41, 0xDE, 0xED,
  0x12, 0x90, 0x04, 0x93, 0x82, 0x5D, 0xD5, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_monitor_weight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_monitor_weight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_nearby_error 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_outlined_18_device_nearby_error_data[] PROGMEM = {
  0x70, 0x01, 0x76, 0x82, 0x4E, 0xE4, 0x74, 0x04, 0xC0, 0x47, 0x20, 0x4A, 0x00, 0x4A, 0x04, 0x70,
  0x4A, 0x04, 0x20, 0x4A, 0x03, 0x50, 0x4A, 0x86, 0x40, 0x99, 0x04, 0xF7, 0x40, 0x4A, 0x81, 0x40,
  0x9A, 0x89, 0x39, 0x04, 0x71, 0xC2, 0x1E, 0xF4, 0x09, 0xC0, 0x92, 0x87, 0x2F, 0x31, 0xEF, 0x40,
  0x9C, 0x09, 0x28, 0x32, 0xF3, 0x04, 0xA8, 0x14, 0x09, 0xA8, 0x59, 0x04, 0x72, 0xF3, 0x20, 0x4A,
  0x89, 0x14, 0x09, 0x90, 0x4F, 0x72, 0xF3, 0x30, 0x4A, 0x04, 0x20, 0x4A, 0x82, 0x32, 0xF3, 0x40,
  0x4A, 0x00, 0x4A, 0x83, 0x40, 0x17, 0x15, 0x04, 0xC0, 0x43, 0x02, 0x78, 0x24, 0xEE, 0x43, 0x81,
  0x2F, 0x37, 0x00, 0x15, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_nearby_error() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_nearby_error_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_nearby_off 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_18_device_nearby_off_data[] PROGMEM = {
  0x70, 0x01, 0x71, 0x02, 0x48, 0x24, 0xEE, 0x46, 0x81, 0x1E, 0x72, 0x04, 0xC0, 0x46, 0x86, 0x6F,
  0x70, 0x8F, 0x44, 0xA0, 0x46, 0x83, 0x6F, 0x70, 0x22, 0x04, 0xA0, 0x45, 0x04, 0xA8, 0x47, 0x05,
  0x90, 0x4A, 0x04, 0x30, 0x4A, 0x86, 0x9F, 0x70, 0x99, 0x04, 0xA8, 0xA6, 0x40, 0x1E, 0xF4, 0x0C,
  0xF7, 0x09, 0x90, 0x4F, 0xE1, 0x1E, 0xF4, 0x09, 0xA8, 0x90, 0x70, 0x50, 0x4F, 0xE1, 0x04, 0xA8,
  0x14, 0x09, 0xA8, 0x17, 0x03, 0xA0, 0x43, 0x04, 0xA8, 0x74, 0x09, 0xCF, 0x70, 0x84, 0x50, 0x4A,
  0x04, 0x28, 0x19, 0xF7, 0x71, 0x04, 0xA0, 0x04, 0xB0, 0x77, 0x10, 0x4C, 0x82, 0x46, 0xF7, 0x71,
  0x82, 0x4E, 0xE4, 0x28, 0x16, 0xE2, 0x71, 0x00, 0x14, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_nearby_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_nearby_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_network_cell 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_device_network_cell_data[] PROGMEM = {
  0x76, 0x07, 0x03, 0x75, 0x81, 0x7F, 0x37, 0x40, 0x7A, 0x03, 0x73, 0x83, 0x7F, 0x8F, 0x37, 0x28,
  0x47, 0xF6, 0x2F, 0x37, 0x18, 0x57, 0xFA, 0x02, 0xF3, 0x70, 0x7A, 0x83, 0x90, 0x2F, 0x36, 0x07,
  0xB8, 0x39, 0x02, 0xF3, 0x50, 0x7C, 0x83, 0x90, 0x2F, 0x34, 0x07, 0xD8, 0x39, 0x02, 0xF3, 0x30,
  0x7E, 0x83, 0x90, 0x2F, 0x32, 0x07, 0xF8, 0x59, 0x02, 0xF3, 0x07, 0xF9, 0x84, 0xA1, 0x3F, 0x37,
  0xFE, 0x80, 0x93, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_network_cell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_network_cell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_network_wifi_1_bar 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_device_network_wifi_1_bar_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x58, 0x94, 0x7E, 0xE9, 0x52, 0x11,
  0x25, 0x9E, 0xE7, 0x28, 0x22, 0xCE, 0x77, 0x38, 0x57, 0xEC, 0x2A, 0xF4, 0x75, 0x85, 0x4F, 0xA0,
  0xBE, 0x27, 0x38, 0x12, 0xEB, 0x38, 0x1B, 0xE2, 0x71, 0x81, 0x2E, 0xB5, 0x81, 0xBE, 0x26, 0x81,
  0x2E, 0xB7, 0x89, 0x0B, 0xE2, 0x48, 0x84, 0x2E, 0xB7, 0x20, 0xBE, 0x0B, 0x74, 0x0B, 0xC0, 0xB7,
  0x60, 0xBA, 0x0B, 0x77, 0x10, 0x0B, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_network_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_network_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_network_wifi_2_bar 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_device_network_wifi_2_bar_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x58, 0x94, 0x7E, 0xE9, 0x52, 0x11,
  0x25, 0x9E, 0xE7, 0x28, 0x22, 0xCE, 0x77, 0x38, 0x57, 0xEC, 0x2A, 0xF4, 0x75, 0x85, 0x4F, 0xA0,
  0xBE, 0x27, 0x38, 0x12, 0xEB, 0x38, 0x1B, 0xE2, 0x71, 0x81, 0x2E, 0xB5, 0x89, 0x2B, 0xE2, 0x4B,
  0xEE, 0xB4, 0x2E, 0xB7, 0x0B, 0xF9, 0x0B, 0x72, 0x0B, 0xE0, 0xB7, 0x40, 0xBC, 0x0B, 0x76, 0x0B,
  0xA0, 0xB7, 0x71, 0x00, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_network_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_network_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_network_wifi_3_bar 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_device_network_wifi_3_bar_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x58, 0x94, 0x7E, 0xE9, 0x52, 0x11,
  0x25, 0x9E, 0xE7, 0x28, 0x22, 0xCE, 0x77, 0x38, 0x57, 0xEC, 0x2A, 0xF4, 0x75, 0x85, 0x4F, 0xA0,
  0xBE, 0x23, 0x82, 0x24, 0x42, 0x38, 0x12, 0xEB, 0x38, 0x3B, 0xE2, 0x5D, 0xC8, 0x3D, 0x52, 0xEB,
  0x50, 0xBF, 0xB0, 0xB7, 0x0B, 0xF9, 0x0B, 0x72, 0x0B, 0xE0, 0xB7, 0x40, 0xBC, 0x0B, 0x76, 0x0B,
  0xA0, 0xB7, 0x71, 0x00, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_network_wifi_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_network_wifi_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_network_wifi 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_device_network_wifi_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x58, 0x94, 0x7E, 0xE9, 0x52, 0x11,
  0x25, 0x9E, 0xE7, 0x28, 0x22, 0xCE, 0x77, 0x38, 0x57, 0xEC, 0x2A, 0xF4, 0x38, 0x44, 0x89, 0x98,
  0x43, 0x87, 0x4F, 0xA0, 0xBE, 0x24, 0xDE, 0x83, 0xD4, 0x2E, 0xB3, 0x0B, 0x0E, 0xFB, 0x0E, 0x0B,
  0x50, 0xBF, 0xB0, 0xB7, 0x0B, 0xF9, 0x0B, 0x72, 0x0B, 0xE0, 0xB7, 0x40, 0xBC, 0x0B, 0x76, 0x0B,
  0xA0, 0xB7, 0x71, 0x00, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_network_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_network_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_nfc 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_outlined_18_device_nfc_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x07, 0x81, 0x50, 0x5F, 0xF0, 0x50, 0x79, 0x75, 0x98, 0xA3, 0x77, 0xF0, 0x37,
  0x73, 0x06, 0x77, 0x73, 0x0F, 0x77, 0xF0, 0x7A, 0x07, 0x09, 0xC8, 0x67, 0x0F, 0x77, 0xF0, 0x79,
  0x20, 0x0B, 0x29, 0x86, 0x70, 0xF7, 0x7F, 0x07, 0x92, 0x00, 0xC2, 0x98, 0x91, 0x70, 0xF7, 0x7F,
  0x07, 0xF0, 0x5A, 0x89, 0x45, 0x0F, 0x70, 0xF7, 0x7F, 0x07, 0xF0, 0x5A, 0x89, 0x15, 0x0F, 0x70,
  0xF7, 0x7F, 0x07, 0x92, 0x00, 0x52, 0x98, 0x67, 0x0F, 0x77, 0xF0, 0x79, 0x69, 0x86, 0x70, 0xF7,
  0x7F, 0x07, 0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x03, 0x80, 0x47, 0x83, 0x30, 0xF7, 0x79, 0x75, 0x90,
  0x70, 0x5F, 0xF8, 0x15, 0x05, 0x80, 0x90, 0x70, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_nfc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_nfc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_nightlight 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_outlined_18_device_nightlight_data[] PROGMEM = {
  0x70, 0x20, 0x17, 0x04, 0x0B, 0xC0, 0xA0, 0x23, 0x86, 0xAF, 0xA5, 0x38, 0xF8, 0x38, 0x1A, 0xE4,
  0x28, 0x12, 0xF8, 0x38, 0x15, 0xF4, 0x30, 0xA0, 0xC4, 0x0C, 0x09, 0x49, 0x06, 0x38, 0x11, 0xF4,
  0x38, 0x14, 0xF1, 0x38, 0x13, 0xF1, 0x30, 0x60, 0xE4, 0x81, 0x3F, 0x13, 0x06, 0x0E, 0x48, 0x11,
  0xF4, 0x38, 0x14, 0xF1, 0x40, 0xC0, 0x94, 0x90, 0x64, 0x81, 0x5F, 0x43, 0x0A, 0x0C, 0x58, 0x1A,
  0xE4, 0x28, 0x12, 0xF8, 0x58, 0x6A, 0xFA, 0x53, 0x8F, 0x85, 0x04, 0x0B, 0xC0, 0xA0, 0x27, 0x02,
  0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_nightlight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 13, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_nightlight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_note_alt 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_outlined_18_device_note_alt_data[] PROGMEM = {
  0x58, 0x21, 0x88, 0x16, 0x89, 0x42, 0x33, 0x3A, 0xEE, 0xA3, 0x33, 0x20, 0x2D, 0x00, 0xCD, 0x02,
  0x04, 0x97, 0x39, 0x00, 0x49, 0x70, 0x72, 0x90, 0x04, 0x96, 0x85, 0x3F, 0x70, 0xF4, 0x49, 0x58,
  0x1C, 0x73, 0x29, 0x00, 0x49, 0x38, 0x21, 0xCF, 0xC3, 0x90, 0x04, 0x92, 0x82, 0x1C, 0xFC, 0x49,
  0x87, 0x44, 0xF0, 0x1C, 0xFC, 0x14, 0x98, 0x64, 0x4F, 0x08, 0xFC, 0x15, 0x98, 0x54, 0x4F, 0x05,
  0x91, 0x69, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_note_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_note_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_password 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_outlined_18_device_password_data[] PROGMEM = {
  0x28, 0x15, 0x42, 0x28, 0x21, 0x44, 0x12, 0x81, 0x24, 0x53, 0x82, 0x4F, 0xE9, 0x20, 0x7A, 0x07,
  0x28, 0x49, 0xEF, 0x40, 0x1C, 0x06, 0x03, 0xC0, 0x30, 0x6C, 0x81, 0x10, 0x7A, 0x82, 0xA2, 0x19,
  0xA8, 0x29, 0x12, 0xAA, 0x07, 0x28, 0x23, 0xB8, 0x62, 0x82, 0x5A, 0xA5, 0x28, 0x26, 0x8B, 0x38,
  0x0E, 0x40, 0x02, 0x80, 0x92, 0xE0, 0x22, 0x01, 0x80, 0x92, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_password() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 5, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_password_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_pattern 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_outlined_18_device_pattern_data[] PROGMEM = {
  0x10, 0x40, 0x32, 0x00, 0x32, 0x82, 0x33, 0x04, 0xA0, 0x20, 0x3A, 0x03, 0x02, 0xA0, 0x03, 0xA0,
  0x02, 0xA0, 0x20, 0x7A, 0x82, 0x30, 0x22, 0x28, 0x42, 0x27, 0xF7, 0x22, 0x03, 0x02, 0x28, 0x63,
  0x8F, 0x62, 0x30, 0x3A, 0x02, 0x03, 0xA0, 0x70, 0x2A, 0x00, 0x3A, 0x02, 0x08, 0xA0, 0x02, 0xA8,
  0x63, 0x03, 0x27, 0xF8, 0x32, 0x02, 0x03, 0x28, 0x42, 0x7F, 0x72, 0x22, 0x82, 0x12, 0x03, 0xA0,
  0xE0, 0x9A, 0x84, 0x99, 0xEF, 0x34, 0xA0, 0x0B, 0xA0, 0x0B, 0xA8, 0x24, 0x04, 0x32, 0x00, 0x32,
  0x03, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_pattern() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_pattern_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_phishing 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_device_phishing_data[] PROGMEM = {
  0x60, 0x02, 0x70, 0x0A, 0x70, 0x0A, 0x70, 0xA0, 0xB6, 0x07, 0xA0, 0x85, 0x83, 0xE8, 0x7F, 0x44,
  0x84, 0xCD, 0xCD, 0x7B, 0x38, 0x52, 0xDD, 0x27, 0xFC, 0x38, 0x5A, 0xA0, 0x7E, 0xEC, 0x28, 0x5A,
  0xA0, 0x7D, 0x25, 0x28, 0x4A, 0xA0, 0x5F, 0x13, 0x0D, 0x08, 0x28, 0x5D, 0xB2, 0x29, 0xF2, 0x20,
  0x30, 0xDA, 0x0E, 0x04, 0x50, 0x20, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_phishing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 12, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_phishing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_pin 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_device_pin_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x98, 0x42, 0xF3, 0x3F, 0x22, 0xB2, 0x4B, 0x80, 0x9A, 0x22, 0xF3, 0x3F, 0x21, 0x93, 0x01,
  0xB0, 0x1A, 0x32, 0xF3, 0x3F, 0x20, 0x83, 0x0A, 0x30, 0x27, 0x52, 0xF3, 0x3F, 0x20, 0x72, 0x6B,
  0x90, 0x9B, 0x32, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x1F, 0xF8,
  0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_play_lesson 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_outlined_18_device_play_lesson_data[] PROGMEM = {
  0x10, 0x18, 0x05, 0x30, 0x13, 0x01, 0x0E, 0xFB, 0x02, 0x28, 0x24, 0xF2, 0xAB, 0x80, 0x01, 0x0E,
  0x06, 0x28, 0x24, 0xF0, 0x9B, 0x40, 0xE0, 0x62, 0x82, 0x4F, 0x09, 0xB4, 0x0E, 0x06, 0x28, 0x24,
  0xF0, 0x9B, 0x40, 0xE0, 0x62, 0x82, 0x4F, 0x09, 0xB4, 0x0E, 0x06, 0x28, 0x54, 0xF0, 0x76, 0x4B,
  0x40, 0x80, 0x32, 0x04, 0x97, 0x60, 0x49, 0x78, 0x56, 0xDF, 0xD6, 0x04, 0x96, 0x81, 0x6F, 0xEB,
  0x06, 0x04, 0x96, 0x86, 0xDF, 0x94, 0xDF, 0xD4, 0x96, 0xA8, 0xA4, 0x90, 0x2E, 0xF4, 0xF2, 0x11,
  0x11, 0x0D, 0xF9, 0x4D, 0xFD, 0x1E, 0xC8, 0x3E, 0x16, 0xFE, 0xB8, 0x16, 0x01, 0x80, 0x13, 0x85,
  0x10, 0x6D, 0xFD, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_play_lesson() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_play_lesson_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_price_change 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_outlined_18_device_price_change_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x22, 0x08, 0x04, 0x68, 0x91, 0x2F,
  0x33, 0xF2, 0x2A, 0xFD, 0xB2, 0x89, 0x12, 0x50, 0x2F, 0x33, 0xF2, 0x7E, 0x0F, 0x92, 0x89, 0x48,
  0x91, 0x2F, 0x33, 0xF2, 0x7E, 0x99, 0x65, 0x89, 0x02, 0xF3, 0x3F, 0x22, 0x99, 0xB9, 0x58, 0x90,
  0x2F, 0x33, 0xF2, 0x49, 0x9B, 0x92, 0x89, 0x48, 0x91, 0x2F, 0x33, 0xF2, 0x5B, 0xFD, 0x72, 0x87,
  0x25, 0x02, 0xF3, 0x3F, 0x22, 0x08, 0x04, 0x68, 0x22, 0xF3, 0x1F, 0xF8, 0x11, 0x03, 0x80, 0x90,
  0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_price_change() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_price_change_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_price_check 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_outlined_18_device_price_check_data[] PROGMEM = {
  0x20, 0x02, 0x72, 0x83, 0x5C, 0xC5, 0x26, 0x06, 0xC0, 0x66, 0x07, 0x0D, 0x73, 0x84, 0x7E, 0xBB,
  0xA2, 0x68, 0x42, 0x99, 0x9E, 0x67, 0x30, 0xD0, 0x66, 0x07, 0xC0, 0x56, 0x83, 0x25, 0xCC, 0x54,
  0x81, 0x5D, 0x12, 0x82, 0x22, 0x51, 0x28, 0x15, 0xF8, 0x58, 0x4D, 0xC1, 0x5F, 0x86, 0x83, 0x2D,
  0xDF, 0x87, 0x18, 0x12, 0xD8, 0x73, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_price_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_price_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_punch_clock 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_outlined_18_device_punch_clock_data[] PROGMEM = {
  0x28, 0x06, 0x14, 0x07, 0xF9, 0x07, 0x40, 0x70, 0xD8, 0x02, 0x30, 0xD0, 0x74, 0x07, 0x0D, 0x60,
  0xD0, 0x73, 0x81, 0x5B, 0xE8, 0x02, 0x78, 0x3E, 0xB5, 0x03, 0x98, 0x06, 0xD9, 0x03, 0x04, 0x94,
  0x00, 0x24, 0x90, 0x04, 0x92, 0x84, 0x3D, 0xBB, 0xD3, 0x29, 0x8D, 0x64, 0x4F, 0x01, 0xD2, 0x33,
  0x2D, 0x10, 0xF4, 0x4F, 0x06, 0x70, 0x66, 0x07, 0x60, 0xF4, 0x4F, 0x08, 0x50, 0x5B, 0x05, 0x80,
  0xF4, 0x4F, 0x05, 0x92, 0x86, 0x76, 0x95, 0x0F, 0x44, 0x92, 0x0C, 0x07, 0x20, 0x70, 0xC2, 0x90,
  0x04, 0x93, 0x82, 0x8D, 0xD8, 0x39, 0x82, 0x44, 0xF2, 0x80, 0x41, 0x83, 0x2F, 0x41, 0xEF, 0xB8,
  0x2E, 0x10, 0x18, 0x06, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_punch_clock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_punch_clock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_quiz 18x18, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_outlined_18_device_quiz_data[] PROGMEM = {
  0x40, 0x18, 0x05, 0x35, 0x04, 0xFB, 0x0E, 0x40, 0x70, 0xD8, 0x04, 0x18, 0x63, 0xF3, 0x17, 0x17,
  0xD2, 0x82, 0x1B, 0xD9, 0x28, 0x62, 0xF3, 0x3F, 0x27, 0xD2, 0x89, 0x46, 0x82, 0xD4, 0x02, 0xF3,
  0x3F, 0x27, 0xD5, 0x89, 0x1D, 0x30, 0x2F, 0x33, 0xF2, 0x7D, 0x40, 0xB0, 0x82, 0x86, 0x2F, 0x33,
  0xF2, 0x7D, 0x30, 0x20, 0xE3, 0x86, 0x2F, 0x33, 0xF2, 0x7D, 0x40, 0x23, 0x86, 0x2F, 0x33, 0xF2,
  0x7D, 0x30, 0x49, 0x38, 0x62, 0xF3, 0x3F, 0x27, 0xD4, 0x02, 0x38, 0x52, 0xF3, 0x3F, 0x26, 0x98,
  0x05, 0xD9, 0x84, 0x13, 0xF2, 0x06, 0x80, 0x57, 0x83, 0x40, 0x3F, 0x38, 0x06, 0x14, 0x0E, 0xFB,
  0x07, 0x58, 0x06, 0x30, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_quiz() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_quiz_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_radar 18x18, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_outlined_18_device_radar_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x89,
  0x29, 0xF5, 0x02, 0x66, 0x20, 0x5F, 0x93, 0x89, 0x43, 0xF5, 0x09, 0xFE, 0xEF, 0x90, 0x5F, 0x32,
  0x84, 0xBB, 0x09, 0xE4, 0x28, 0x44, 0xE9, 0x0B, 0xB2, 0x98, 0xA3, 0x52, 0xF4, 0x03, 0x30, 0x4F,
  0x25, 0xF0, 0x2F, 0x36, 0xE0, 0x3A, 0x89, 0x43, 0x0E, 0x63, 0xF2, 0x2F, 0x36, 0xE0, 0x3A, 0x8A,
  0x38, 0x0E, 0x63, 0xF2, 0x0F, 0x52, 0xF4, 0x03, 0x8F, 0xAF, 0x25, 0x92, 0x84, 0xBB, 0x09, 0xE4,
  0x28, 0x4A, 0xFC, 0x0B, 0xB2, 0x89, 0x43, 0xF5, 0x09, 0xFE, 0xEF, 0xCF, 0xAF, 0x33, 0x89, 0x29,
  0xF5, 0x02, 0x66, 0x20, 0xAF, 0x95, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x97, 0x03, 0x0B, 0xC0,
  0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_radar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_radar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_remember_me 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_outlined_18_device_remember_me_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x81, 0x66, 0xE2, 0x82, 0x17, 0x71, 0x28, 0x2E, 0x66, 0xE2, 0x82,
  0xDE, 0xED, 0x28, 0xB2, 0xE6, 0x6E, 0x03, 0xF3, 0x3F, 0x30, 0xE6, 0x6E, 0x01, 0xEB, 0xBE, 0x10,
  0xE6, 0x6E, 0x28, 0x24, 0xCC, 0x42, 0x82, 0xE6, 0x6E, 0x30, 0x02, 0x38, 0x4E, 0x66, 0xE5, 0xBC,
  0x83, 0xB5, 0xE6, 0x6A, 0x84, 0xA5, 0x33, 0x5A, 0xA8, 0x26, 0x6F, 0xA8, 0x02, 0x78, 0x2A, 0xF6,
  0x69, 0x80, 0x4D, 0x98, 0x16, 0x6E, 0x80, 0x43, 0x82, 0xE6, 0x2E, 0xF9, 0x0E, 0x02, 0x28, 0x04,
  0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_remember_me() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_remember_me_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_reset_tv 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_18_device_reset_tv_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F,
  0x25, 0x03, 0x01, 0x38, 0x42, 0xD2, 0x3F, 0x24, 0x81, 0x3E, 0x96, 0x81, 0x3F, 0x23, 0x03, 0x0E,
  0x98, 0x01, 0x98, 0x35, 0x03, 0xF2, 0x30, 0x6A, 0x80, 0x0B, 0x84, 0xCF, 0x23, 0xF2, 0x48, 0x16,
  0xF7, 0x38, 0x42, 0xF3, 0x3F, 0x25, 0x06, 0x03, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3,
  0x19, 0x80, 0x90, 0xD9, 0x85, 0x10, 0x47, 0x77, 0xDC, 0x83, 0xD7, 0x77, 0x46, 0x0A, 0xC0, 0xA7,
  0x38, 0x42, 0x33, 0x33, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_reset_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_reset_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_restart_alt 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_device_restart_alt_data[] PROGMEM = {
  0x50, 0x17, 0x38, 0x12, 0xD7, 0x71, 0x83, 0x2D, 0xF8, 0x47, 0x05, 0xA8, 0x2E, 0xFD, 0x33, 0x89,
  0x03, 0x90, 0x5F, 0x63, 0xCE, 0x32, 0x0C, 0x0B, 0x20, 0x50, 0x12, 0x84, 0xCC, 0x02, 0xF3, 0x68,
  0x24, 0xF2, 0x59, 0x71, 0x98, 0x25, 0x4F, 0x16, 0x84, 0x1F, 0x41, 0xF5, 0x68, 0x55, 0xF1, 0x09,
  0xD1, 0x48, 0x11, 0xD9, 0x28, 0x21, 0xDD, 0x62, 0x82, 0x6D, 0xD1, 0x48, 0x49, 0xE5, 0x5E, 0x97,
  0x10, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_restart_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_restart_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_reviews 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_outlined_18_device_reviews_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x3E, 0x03, 0xF3, 0x80, 0x61, 0x84, 0x3F, 0x33, 0xF2, 0x40,
  0x03, 0x48, 0x42, 0xF3, 0x3F, 0x24, 0x00, 0xA4, 0x84, 0x2F, 0x33, 0xF2, 0x30, 0x5A, 0x05, 0x38,
  0x72, 0xF3, 0x3F, 0x20, 0x2D, 0xC8, 0x7D, 0x20, 0x2F, 0x33, 0xF2, 0x20, 0x20, 0x9A, 0x09, 0x02,
  0x28, 0x42, 0xF3, 0x3F, 0x24, 0x00, 0xC4, 0x84, 0x2F, 0x33, 0xF2, 0x40, 0x05, 0x48, 0x42, 0xF3,
  0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x88, 0x07, 0xD9, 0x01, 0x03, 0xA0, 0x98, 0x06, 0x78, 0x34,
  0x03, 0xF7, 0x76, 0x03, 0x07, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_reviews() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_reviews_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_r_mobiledata 18x18, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_outlined_18_device_r_mobiledata_data[] PROGMEM = {
  0x18, 0x00, 0x32, 0x03, 0xC8, 0xC2, 0xE0, 0x3F, 0x31, 0x3F, 0x33, 0xF8, 0x78, 0xF2, 0x3F, 0xDD,
  0xF9, 0x03, 0xF2, 0x0E, 0x70, 0x3F, 0x20, 0x8D, 0x20, 0x13, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_r_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 7, 8), Box(0, 0, 17, 17),
      ic_outlined_18_device_r_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_rsvp 18x18, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_outlined_18_device_rsvp_data[] PROGMEM = {
  0x8E, 0x52, 0xBB, 0x34, 0xBB, 0x19, 0x05, 0x55, 0xBA, 0x03, 0xC9, 0x78, 0xB6, 0x07, 0x6C, 0x17,
  0x7B, 0x33, 0xDE, 0x22, 0x9E, 0x12, 0xEB, 0x07, 0xEC, 0x02, 0x86, 0x37, 0xB9, 0x28, 0x39, 0x40,
  0x54, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_rsvp() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 16, 10), Box(0, 0, 17, 17),
      ic_outlined_18_device_rsvp_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_screen_lock_landscape 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_outlined_18_device_screen_lock_landscape_data[] PROGMEM = {
  0x28, 0x09, 0x23, 0x20, 0x10, 0xEF, 0xF8, 0x1E, 0x13, 0xA0, 0xC8, 0x06, 0x30, 0xCA, 0x00, 0x3A,
  0x0B, 0x38, 0x22, 0xAA, 0x23, 0x0B, 0xA0, 0x03, 0xA0, 0xB3, 0x82, 0x72, 0x27, 0x30, 0xBA, 0x00,
  0x3A, 0x0B, 0x28, 0x41, 0xCB, 0xBC, 0x12, 0x0B, 0xA0, 0x03, 0xA0, 0xB2, 0x03, 0xC0, 0x32, 0x0B,
  0xA0, 0x03, 0xA0, 0xB2, 0x03, 0xC0, 0x32, 0x0B, 0xA0, 0x03, 0xA0, 0xB2, 0x02, 0x0E, 0xA0, 0xE0,
  0x22, 0x0B, 0xA0, 0x03, 0xA0, 0xC8, 0x06, 0x30, 0xCA, 0x81, 0x31, 0xEF, 0xF0, 0xE0, 0x12, 0x80,
  0x92, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_screen_lock_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_screen_lock_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_screen_lock_portrait 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_device_screen_lock_portrait_data[] PROGMEM = {
  0x28, 0x04, 0x32, 0x01, 0x0E, 0xF9, 0x81, 0xE1, 0x3F, 0xB8, 0x23, 0x3F, 0xC8, 0x02, 0xB8, 0x4C,
  0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0xD1, 0x3F, 0x33, 0xF3, 0x02, 0xAA, 0x20, 0x3F,
  0x33, 0xF3, 0x07, 0x22, 0x70, 0x3F, 0x33, 0xF3, 0x1C, 0xBB, 0xC1, 0x3F, 0x33, 0xF3, 0x3C, 0x86,
  0x33, 0xF3, 0x3F, 0x33, 0xC8, 0x73, 0x3F, 0x33, 0xF3, 0x2E, 0xA8, 0x6E, 0x23, 0xF3, 0x3F, 0x36,
  0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0xC8, 0x02, 0xB8, 0x2C, 0xF3, 0x3F, 0xB8, 0x13,
  0x1E, 0xF9, 0x0E, 0x01, 0x28, 0x04, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_screen_lock_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_screen_lock_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_screen_lock_rotation 18x18, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_outlined_18_device_screen_lock_rotation_data[] PROGMEM = {
  0x75, 0x01, 0x02, 0x71, 0x82, 0x2D, 0xC1, 0x28, 0x24, 0x96, 0x86, 0x86, 0x2E, 0xDE, 0xC1, 0x09,
  0x20, 0x95, 0x86, 0x2E, 0xD2, 0x3E, 0x34, 0xC0, 0x93, 0x82, 0x2E, 0xD2, 0x40, 0x7C, 0x0C, 0x28,
  0x22, 0xED, 0x25, 0x07, 0xC0, 0xC2, 0x81, 0xDE, 0x26, 0x06, 0xC0, 0xC2, 0x81, 0xBF, 0x46, 0x84,
  0x17, 0x77, 0x73, 0x38, 0x1B, 0xF4, 0x72, 0x82, 0x41, 0x03, 0x28, 0x1B, 0xF4, 0x78, 0x41, 0xEC,
  0x1C, 0x52, 0x81, 0xBF, 0x47, 0x83, 0x3E, 0xC9, 0x83, 0x81, 0xBF, 0x46, 0x84, 0x1D, 0xE3, 0xE1,
  0x38, 0x1B, 0xF4, 0x48, 0x51, 0xDE, 0x30, 0xB9, 0x48, 0x1B, 0xF4, 0x28, 0x21, 0xDE, 0x32, 0x81,
  0x2E, 0x74, 0x85, 0xBF, 0x41, 0xDE, 0x34, 0x89, 0x23, 0xE9, 0x19, 0x20, 0xBF, 0xDE, 0x36, 0x02,
  0x0B, 0xA8, 0x4D, 0x20, 0xBE, 0x37, 0x28, 0x34, 0x9D, 0xD2, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_screen_lock_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 16, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_screen_lock_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_screen_rotation 18x18, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_outlined_18_device_screen_rotation_data[] PROGMEM = {
  0x71, 0x83, 0x2D, 0xD9, 0x47, 0x38, 0x42, 0xDB, 0x12, 0xDA, 0x0B, 0x02, 0x78, 0x92, 0x2E, 0x7A,
  0xC1, 0x29, 0x19, 0xE3, 0x58, 0x12, 0xE7, 0x28, 0x1A, 0xC1, 0x38, 0x17, 0xE2, 0x38, 0x12, 0xE7,
  0x48, 0x1A, 0xC1, 0x30, 0x90, 0xB2, 0x81, 0x2E, 0x76, 0x81, 0xAC, 0x12, 0x84, 0x1E, 0x30, 0xD7,
  0x71, 0x81, 0xAC, 0x12, 0x83, 0x89, 0x0B, 0xA7, 0x28, 0x90, 0xAC, 0x10, 0x5C, 0x01, 0xCA, 0x72,
  0x89, 0x0A, 0xC1, 0x03, 0x30, 0x1C, 0xA7, 0x28, 0x90, 0xAC, 0x10, 0xC5, 0x01, 0xCA, 0x72, 0x83,
  0xAB, 0x09, 0x82, 0x81, 0x1C, 0xA7, 0x18, 0x47, 0xD0, 0x3E, 0x12, 0x81, 0x1C, 0xA6, 0x81, 0x7E,
  0x22, 0x0B, 0x09, 0x38, 0x11, 0xCA, 0x48, 0x17, 0xE2, 0x38, 0x12, 0xE7, 0x38, 0x11, 0xCA, 0x28,
  0x17, 0xE2, 0x58, 0x92, 0x3E, 0x91, 0x92, 0x1C, 0xA7, 0xE2, 0x70, 0x20, 0xBA, 0x84, 0xD2, 0x1B,
  0xD2, 0x73, 0x83, 0x49, 0xDD, 0x27, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_screen_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_screen_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_screen_search_desktop 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_outlined_18_device_screen_search_desktop_data[] PROGMEM = {
  0x20, 0x18, 0x09, 0x03, 0x01, 0x30, 0x10, 0xEF, 0xD0, 0xE0, 0x12, 0x81, 0x3F, 0x24, 0x03, 0x01,
  0x48, 0x12, 0xF3, 0x28, 0x13, 0xF2, 0x20, 0x10, 0xCA, 0x07, 0x38, 0x12, 0xF3, 0x28, 0x13, 0xF2,
  0x28, 0x48, 0xD2, 0x6F, 0x12, 0x81, 0x2F, 0x32, 0x81, 0x3F, 0x22, 0x84, 0x9B, 0x03, 0xF2, 0x28,
  0x12, 0xF3, 0x28, 0x13, 0xF2, 0x28, 0x44, 0xFC, 0xEF, 0x22, 0x81, 0x2F, 0x32, 0x81, 0x3F, 0x23,
  0x89, 0x04, 0x98, 0xCD, 0x20, 0x2F, 0x32, 0x81, 0x3F, 0x26, 0x85, 0x1A, 0x10, 0x2F, 0x32, 0x81,
  0x2F, 0x58, 0x06, 0x38, 0x15, 0xF2, 0x30, 0xCF, 0xD0, 0xC7, 0x76, 0x01, 0xFF, 0xA0, 0x11, 0x80,
  0x94, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_screen_search_desktop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_screen_search_desktop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_screenshot_monitor 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_outlined_18_device_screenshot_monitor_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x03, 0x82, 0x10, 0x1E, 0xFD, 0x83, 0xE1, 0x3F, 0x27, 0x38, 0x72, 0xF3, 0x3F,
  0x2E, 0xDA, 0x78, 0x52, 0xF3, 0x3F, 0x2D, 0x72, 0x85, 0x2F, 0x33, 0xF2, 0x87, 0x28, 0x42, 0xF3,
  0x3F, 0x27, 0x28, 0x56, 0x2F, 0x33, 0xF2, 0x72, 0x85, 0xD2, 0xF3, 0x3F, 0x27, 0x87, 0x79, 0xE2,
  0xF3, 0x3F, 0x27, 0x85, 0x23, 0x32, 0xF3, 0x19, 0x80, 0x90, 0xD9, 0x85, 0x10, 0x47, 0x77, 0xDC,
  0x83, 0xD7, 0x77, 0x46, 0x0A, 0xC0, 0xA7, 0x38, 0x42, 0x33, 0x33, 0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_screenshot_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_screenshot_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_screenshot 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_outlined_18_device_screenshot_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x85, 0x66, 0xE1, 0x99, 0x54, 0x86, 0xE6, 0x6E, 0x2C, 0x32, 0x48,
  0x4E, 0x66, 0xE2, 0xB6, 0x84, 0xE6, 0x6E, 0x01, 0x68, 0x2E, 0x66, 0xE6, 0x84, 0x10, 0xE6, 0x6E,
  0x68, 0x4B, 0x2E, 0x66, 0xE4, 0x86, 0x23, 0xC2, 0xE6, 0x6E, 0x48, 0x55, 0x99, 0x1E, 0x66, 0x98,
  0x04, 0x79, 0x00, 0x69, 0x80, 0x4D, 0x98, 0x16, 0x6E, 0x80, 0x43, 0x82, 0xE6, 0x2E, 0xF9, 0x0E,
  0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_screenshot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_screenshot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_sd_storage 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_outlined_18_device_sd_storage_data[] PROGMEM = {
  0x40, 0x58, 0x02, 0x70, 0x23, 0x07, 0xF0, 0xD2, 0x81, 0x7F, 0x95, 0x84, 0x7F, 0x07, 0xF9, 0x68,
  0x93, 0x7F, 0x7F, 0x93, 0xB2, 0xB5, 0x88, 0x7A, 0x89, 0x0A, 0x03, 0xF3, 0xF7, 0xBB, 0x7A, 0x89,
  0x07, 0x03, 0xF3, 0xF7, 0xBB, 0x7A, 0x89, 0x07, 0x01, 0x31, 0x31, 0x22, 0x7A, 0x07, 0x71, 0x07,
  0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77,
  0x18, 0x17, 0xFD, 0xFB, 0x0D, 0x02, 0x80, 0x67, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_sd_storage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_sd_storage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_security_update_good 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_outlined_18_device_security_update_good_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x81, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE5, 0x01, 0x28, 0x2E, 0x66,
  0xE4, 0x8B, 0x01, 0xD9, 0x0E, 0x66, 0xE0, 0x7A, 0x2D, 0xD1, 0x0E, 0x66, 0xE0, 0x3E, 0xFD, 0x12,
  0x82, 0xE6, 0x6E, 0x28, 0x13, 0xC1, 0x38, 0x2E, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE7, 0x18, 0x1E,
  0x66, 0x98, 0x04, 0x79, 0x00, 0x69, 0x80, 0x4D, 0x98, 0x16, 0x6E, 0x80, 0x43, 0x82, 0xE6, 0x2E,
  0xF9, 0x0E, 0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_security_update_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_security_update_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_security_update 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_outlined_18_device_security_update_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x81, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE3, 0x00, 0x73, 0x82, 0xE6,
  0x6E, 0x30, 0x0A, 0x38, 0xA1, 0xE6, 0x6E, 0x03, 0x9A, 0xA9, 0x30, 0xE6, 0x6E, 0x03, 0xEA, 0x85,
  0xE3, 0x0E, 0x66, 0xE2, 0x82, 0x3E, 0xE3, 0x28, 0x2E, 0x66, 0xE3, 0x00, 0x33, 0x82, 0xE6, 0x6E,
  0x71, 0x81, 0xE6, 0x69, 0x80, 0x47, 0x90, 0x06, 0x98, 0x04, 0xD9, 0x81, 0x66, 0xE8, 0x04, 0x38,
  0x2E, 0x62, 0xEF, 0x90, 0xE0, 0x22, 0x80, 0x41, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_security_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_security_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_security_update_warning 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_device_security_update_warning_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x81, 0x66, 0xE3, 0x00, 0x63, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38,
  0x2E, 0x66, 0xE3, 0x00, 0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x2E, 0x66, 0xE3, 0x00, 0xA3,
  0x82, 0xE6, 0x6E, 0x30, 0x03, 0x38, 0x2E, 0x66, 0xE3, 0x00, 0x73, 0x82, 0xE6, 0x6E, 0x30, 0x06,
  0x38, 0x1E, 0x66, 0x98, 0x04, 0x79, 0x00, 0x69, 0x80, 0x4D, 0x98, 0x16, 0x6E, 0x80, 0x43, 0x82,
  0xE6, 0x2E, 0xF9, 0x0E, 0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_security_update_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_security_update_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_sell 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_device_sell_data[] PROGMEM = {
  0x28, 0x01, 0x30, 0x27, 0x20, 0xEE, 0x0A, 0x78, 0x90, 0x3F, 0x32, 0x21, 0x14, 0xEA, 0x68, 0x33,
  0xF3, 0xED, 0x38, 0x14, 0xEA, 0x58, 0x33, 0xF3, 0xDD, 0x48, 0x14, 0xEA, 0x48, 0x13, 0xF2, 0x78,
  0x14, 0xEA, 0x38, 0x13, 0xF2, 0x71, 0x81, 0x4E, 0xA2, 0x81, 0x2F, 0x47, 0x28, 0x14, 0xEA, 0x28,
  0x1A, 0xE4, 0x72, 0x81, 0x6F, 0x22, 0x81, 0xAE, 0x47, 0x81, 0x2E, 0xB4, 0x81, 0xAE, 0x45, 0x81,
  0x2E, 0xC6, 0x81, 0xAE, 0x43, 0x81, 0x2E, 0xC7, 0x18, 0x5A, 0xE4, 0x02, 0xEC, 0x73, 0x83, 0xAE,
  0x6E, 0xC7, 0x58, 0x1A, 0xFB, 0x77, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_sell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_sell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_send_to_mobile 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_device_send_to_mobile_data[] PROGMEM = {
  0x28, 0x04, 0x13, 0x02, 0x0E, 0xF9, 0x83, 0xE2, 0x06, 0xE8, 0x04, 0x38, 0x2E, 0x60, 0x69, 0x80,
  0x4D, 0x98, 0x16, 0x06, 0x98, 0x04, 0x79, 0x82, 0x60, 0x6E, 0x71, 0x83, 0x52, 0x06, 0xE7, 0x10,
  0x62, 0x06, 0x0E, 0x78, 0x42, 0xEA, 0x06, 0xE4, 0x87, 0x19, 0x99, 0xCF, 0xA6, 0xE4, 0x87, 0x19,
  0x99, 0xCF, 0xA6, 0xE7, 0x84, 0x2E, 0xA0, 0x6E, 0x71, 0x06, 0x20, 0x60, 0xE7, 0x18, 0x25, 0x20,
  0x69, 0x80, 0x47, 0x98, 0x16, 0x06, 0x98, 0x04, 0xD9, 0x82, 0x60, 0x6E, 0x80, 0x43, 0x83, 0xE6,
  0x02, 0xEF, 0x90, 0xE0, 0x23, 0x80, 0x41, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_send_to_mobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 15, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_send_to_mobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_settings_suggest 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_outlined_18_device_settings_suggest_data[] PROGMEM = {
  0x75, 0x08, 0x01, 0x76, 0x82, 0x4E, 0x91, 0x50, 0x40, 0xF7, 0x20, 0x30, 0xDA, 0x08, 0x58, 0x3A,
  0xEE, 0xF1, 0x30, 0xD0, 0x43, 0x89, 0x25, 0xD7, 0xD9, 0x3F, 0x8B, 0xB0, 0x34, 0x89, 0x1D, 0xDF,
  0xB3, 0x08, 0xFC, 0xF4, 0x48, 0x92, 0x7F, 0x31, 0x2B, 0xC6, 0x10, 0xCD, 0x28, 0xB3, 0x50, 0x2C,
  0xE1, 0xCC, 0x9F, 0x3A, 0xF6, 0x19, 0xE5, 0x05, 0xF1, 0xF6, 0x0F, 0x6A, 0xB2, 0x89, 0x56, 0xD2,
  0x6F, 0xC1, 0xAF, 0xDE, 0x17, 0xFB, 0x28, 0x94, 0x30, 0x4F, 0x45, 0x26, 0x82, 0x51, 0xDA, 0x50,
  0xBA, 0x82, 0xE5, 0x1C, 0xB0, 0x25, 0x89, 0x02, 0x93, 0xCA, 0x4F, 0x46, 0x77, 0x20, 0xAB, 0x75,
  0x02, 0x0F, 0x37, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_settings_suggest() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_settings_suggest_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_settings_system_daydream 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_18_device_settings_system_daydream_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x48, 0x25, 0xAA, 0x54, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x48, 0xFD, 0xDF, 0x83,
  0x89, 0x13, 0xF3, 0x3F, 0x30, 0x3E, 0xF9, 0x28, 0x18, 0xF5, 0x28, 0x90, 0x3F, 0x33, 0xF3, 0x0D,
  0xC4, 0x30, 0x2A, 0x89, 0x19, 0x03, 0xF3, 0x3F, 0x33, 0xF4, 0x68, 0x92, 0x8F, 0x23, 0xF3, 0x3F,
  0x31, 0xF8, 0x68, 0x93, 0x5F, 0x23, 0xF3, 0x3F, 0x30, 0x9F, 0xC8, 0x01, 0xB9, 0x86, 0xC0, 0x3F,
  0x33, 0xF3, 0x20, 0x60, 0xA8, 0x01, 0xB8, 0x78, 0x10, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x32,
  0xFC, 0x80, 0x90, 0xB8, 0x3C, 0xF2, 0x07, 0x80, 0x92, 0xB0, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_settings_system_daydream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_settings_system_daydream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_share_location 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_outlined_18_device_share_location_data[] PROGMEM = {
  0x48, 0x64, 0xBF, 0x55, 0xFB, 0x46, 0x89, 0x09, 0xFB, 0x51, 0x16, 0xBF, 0x44, 0x81, 0x9F, 0x56,
  0x81, 0x30, 0x42, 0x81, 0x4F, 0x52, 0x82, 0x27, 0x72, 0x28, 0x43, 0xF4, 0x0B, 0xB2, 0x03, 0x0E,
  0xA0, 0xE0, 0x32, 0x83, 0xBB, 0x0F, 0x52, 0x84, 0xBF, 0xAA, 0xFB, 0x28, 0x36, 0xF2, 0xF3, 0x28,
  0x4D, 0xF3, 0x3F, 0xD2, 0x83, 0x15, 0x2F, 0x32, 0x84, 0x8F, 0xEE, 0xF9, 0x28, 0x31, 0x50, 0xF5,
  0x20, 0x10, 0xDA, 0x0D, 0x01, 0x28, 0x36, 0xF0, 0xBB, 0x38, 0x23, 0xEE, 0x33, 0x84, 0xBB, 0x04,
  0xF5, 0x30, 0x03, 0x38, 0x13, 0xF4, 0x28, 0x19, 0xF5, 0x68, 0x13, 0x04, 0x48, 0x90, 0x9F, 0xB5,
  0x11, 0x6B, 0xF4, 0x68, 0x64, 0xBF, 0x55, 0xFB, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_share_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_share_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_shortcut 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_outlined_18_device_shortcut_data[] PROGMEM = {
  0x71, 0x81, 0x3C, 0x17, 0x48, 0x21, 0xDC, 0x17, 0x48, 0x21, 0xDC, 0x13, 0x03, 0x09, 0x80, 0x2B,
  0x87, 0xDF, 0xC1, 0x06, 0xFB, 0x88, 0x01, 0x78, 0x1B, 0xFA, 0x20, 0xE0, 0x86, 0x81, 0x4E, 0xA2,
  0x81, 0x3F, 0x15, 0x81, 0x3E, 0xA3, 0x04, 0x96, 0x01, 0x08, 0x40, 0x49, 0x75, 0x02, 0x07, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_shortcut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_outlined_18_device_shortcut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_0_bar 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_0_bar_data[] PROGMEM = {
  0x76, 0x07, 0x03, 0x75, 0x81, 0x7F, 0x37, 0x40, 0x7A, 0x03, 0x73, 0x83, 0x7F, 0x8F, 0x37, 0x28,
  0x47, 0xF6, 0x2F, 0x37, 0x18, 0x57, 0xF6, 0x02, 0xF3, 0x78, 0x17, 0xF6, 0x28, 0x12, 0xF3, 0x68,
  0x17, 0xF6, 0x38, 0x12, 0xF3, 0x58, 0x17, 0xF6, 0x48, 0x12, 0xF3, 0x48, 0x17, 0xF6, 0x58, 0x12,
  0xF3, 0x38, 0x17, 0xF6, 0x68, 0x12, 0xF3, 0x28, 0x17, 0xF6, 0x78, 0x52, 0xF3, 0x07, 0xF8, 0x80,
  0x41, 0x82, 0x3F, 0x37, 0xFE, 0x80, 0x93, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_4_bar 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_4_bar_data[] PROGMEM = {
  0x77, 0x10, 0x17, 0x70, 0x07, 0x76, 0x81, 0x7F, 0x77, 0x50, 0x7A, 0x07, 0x74, 0x07, 0xB0, 0x77,
  0x30, 0x7C, 0x07, 0x72, 0x07, 0xD0, 0x77, 0x10, 0x7E, 0x07, 0x70, 0x7F, 0x07, 0x60, 0x7F, 0x90,
  0x75, 0x07, 0xFA, 0x07, 0x40, 0x7F, 0xB0, 0x73, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xD8, 0x17, 0x07,
  0xFE, 0x07, 0x01, 0x80, 0x92, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_alt_1_bar 18x18, 4-bit Alpha,  RLE, 11 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_alt_1_bar_data[] PROGMEM = {
  0x8A, 0x01, 0x10, 0x7F, 0x47, 0xF4, 0x7F, 0x47, 0xF4, 0x25, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_alt_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 6, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_alt_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_alt_2_bar 18x18, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_alt_2_bar_data[] PROGMEM = {
  0x40, 0x0A, 0x48, 0x2D, 0xD1, 0x12, 0x8B, 0x6D, 0xD7, 0xF4, 0x0D, 0xD7, 0xF4, 0x0D, 0xD7, 0xF4,
  0x0D, 0xD7, 0xF4, 0x0D, 0xD2, 0x51, 0x05, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_alt_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 9, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_alt_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_alt 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_alt_data[] PROGMEM = {
  0x72, 0x03, 0xA7, 0x20, 0x3A, 0x72, 0x03, 0xA5, 0x83, 0x23, 0x10, 0x3A, 0x58, 0x3B, 0xF7, 0x03,
  0xA5, 0x83, 0xBF, 0x70, 0x3A, 0x58, 0x3B, 0xF7, 0x03, 0xA8, 0x11, 0x77, 0x28, 0x3B, 0xF7, 0x03,
  0xA0, 0x3A, 0x28, 0x3B, 0xF7, 0x03, 0xA0, 0x3A, 0x28, 0x3B, 0xF7, 0x03, 0xA0, 0x3A, 0x28, 0x3B,
  0xF7, 0x03, 0xA0, 0x3A, 0x28, 0x3B, 0xF7, 0x03, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_connected_no_internet_0_bar 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_connected_no_internet_0_bar_data[] PROGMEM = {
  0x76, 0x07, 0x03, 0x75, 0x81, 0x7F, 0x37, 0x40, 0x7A, 0x03, 0x73, 0x83, 0x7F, 0x8F, 0x37, 0x28,
  0x47, 0xF6, 0x1B, 0x27, 0x18, 0x17, 0xF6, 0x74, 0x81, 0x7F, 0x62, 0x81, 0x2D, 0x26, 0x81, 0x7F,
  0x63, 0x81, 0x2F, 0x35, 0x81, 0x7F, 0x64, 0x81, 0x2F, 0x34, 0x81, 0x7F, 0x65, 0x81, 0x2F, 0x33,
  0x81, 0x7F, 0x66, 0x81, 0x2F, 0x32, 0x81, 0x7F, 0x67, 0x85, 0x17, 0x10, 0x7F, 0x88, 0x04, 0x11,
  0x81, 0x10, 0x7F, 0xB0, 0x70, 0x29, 0x80, 0x90, 0x38, 0x11, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_connected_no_internet_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_connected_no_internet_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_connected_no_internet_4_bar 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_connected_no_internet_4_bar_data[] PROGMEM = {
  0x76, 0x07, 0x03, 0x75, 0x81, 0x7F, 0x37, 0x40, 0x7A, 0x03, 0x73, 0x07, 0xB0, 0x37, 0x28, 0x47,
  0xFD, 0xBB, 0x27, 0x10, 0x7A, 0x07, 0x73, 0x07, 0xB8, 0x27, 0x2D, 0x26, 0x07, 0xC8, 0x27, 0x2F,
  0x35, 0x07, 0xD8, 0x27, 0x2F, 0x34, 0x07, 0xE8, 0x27, 0x2F, 0x33, 0x07, 0xF8, 0x27, 0x2F, 0x32,
  0x07, 0xF9, 0x84, 0x71, 0x81, 0x07, 0xFA, 0x83, 0x70, 0x20, 0x7F, 0xB0, 0x70, 0x29, 0x80, 0x90,
  0x38, 0x11, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_connected_no_internet_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_connected_no_internet_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_nodata 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_nodata_data[] PROGMEM = {
  0x76, 0x07, 0x03, 0x75, 0x81, 0x7F, 0x37, 0x40, 0x7A, 0x03, 0x73, 0x07, 0xB0, 0x37, 0x20, 0x7C,
  0x03, 0x71, 0x07, 0xD0, 0x37, 0x07, 0xE0, 0x36, 0x07, 0x98, 0x02, 0xD0, 0x25, 0x81, 0x7F, 0xD7,
  0x40, 0x7A, 0x85, 0xD0, 0xD7, 0x5D, 0x14, 0x07, 0xB8, 0x1D, 0x07, 0xA0, 0x84, 0x07, 0xC8, 0x1D,
  0x05, 0xA0, 0x73, 0x07, 0xD8, 0x7D, 0x0D, 0x87, 0xE1, 0x07, 0xE8, 0x1D, 0x01, 0x20, 0x12, 0x80,
  0x43, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_nodata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_nodata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_no_sim 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_no_sim_data[] PROGMEM = {
  0x50, 0x98, 0x01, 0xB0, 0x72, 0x0C, 0x08, 0x28, 0x96, 0xAF, 0xBB, 0xBB, 0xCF, 0x20, 0x8F, 0x80,
  0x55, 0x48, 0x13, 0xF3, 0x28, 0x19, 0xF8, 0x68, 0x13, 0xF3, 0x20, 0x3A, 0x08, 0x58, 0x13, 0xF3,
  0x28, 0x33, 0xFC, 0xF8, 0x48, 0x13, 0xF3, 0x28, 0x43, 0xF3, 0x9F, 0x83, 0x81, 0x3F, 0x32, 0x85,
  0x3F, 0x30, 0x9F, 0x82, 0x81, 0x3F, 0x32, 0x81, 0x3F, 0x32, 0x85, 0x9F, 0x80, 0x2F, 0x32, 0x81,
  0x3F, 0x33, 0x84, 0x9F, 0x80, 0x53, 0x28, 0x13, 0xF3, 0x48, 0x19, 0xF8, 0x48, 0x13, 0xF3, 0x58,
  0x18, 0xF8, 0x38, 0x12, 0xFC, 0x80, 0x2B, 0xA0, 0x83, 0x07, 0x80, 0x4B, 0x81, 0xCF, 0x87, 0x50,
  0x80, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_null 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_null_data[] PROGMEM = {
  0x77, 0x10, 0x17, 0x70, 0x07, 0x76, 0x81, 0x7F, 0x77, 0x50, 0x7A, 0x07, 0x74, 0x83, 0x7F, 0x9F,
  0x77, 0x38, 0x47, 0xF9, 0x0F, 0x77, 0x28, 0x17, 0xF9, 0x29, 0x07, 0x71, 0x81, 0x7F, 0x93, 0x90,
  0x77, 0x81, 0x7F, 0x94, 0x90, 0x76, 0x81, 0x7F, 0x95, 0x90, 0x75, 0x81, 0x7F, 0x96, 0x90, 0x74,
  0x81, 0x7F, 0x97, 0x90, 0x73, 0x81, 0x7F, 0x97, 0x19, 0x07, 0x28, 0x17, 0xF9, 0x72, 0x98, 0x17,
  0x07, 0xFE, 0x07, 0x01, 0x80, 0x92, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_null() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_null_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_cellular_off 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_outlined_18_device_signal_cellular_off_data[] PROGMEM = {
  0x76, 0x01, 0x09, 0x76, 0x81, 0x1D, 0xB3, 0x06, 0x01, 0x78, 0x21, 0xDF, 0xB2, 0x82, 0x2E, 0xC1,
  0x50, 0x10, 0xDA, 0x0B, 0x38, 0x23, 0xEC, 0x13, 0x01, 0x0D, 0xB0, 0xB4, 0x85, 0x3E, 0xC1, 0x01,
  0xDC, 0x0B, 0x58, 0x43, 0xEC, 0x11, 0xDC, 0x0B, 0x68, 0x43, 0xEC, 0x11, 0xDB, 0x0B, 0x68, 0x51,
  0xDF, 0xC1, 0x1D, 0xA0, 0xB5, 0x01, 0x0D, 0xB8, 0x4C, 0x11, 0xDF, 0xB4, 0x01, 0x0D, 0xD8, 0x3C,
  0x11, 0xDB, 0x30, 0x10, 0xDF, 0x82, 0xC1, 0x19, 0x20, 0x10, 0xDF, 0xA0, 0xC0, 0x12, 0x01, 0x0D,
  0xFC, 0x82, 0xC1, 0x09, 0x80, 0x90, 0xB8, 0x1E, 0xC1, 0x76, 0x81, 0x3E, 0x47, 0x70, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_cellular_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_cellular_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_0_bar 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_0_bar_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x58, 0x94, 0x7E, 0xE9, 0x52, 0x11,
  0x25, 0x9E, 0xE7, 0x28, 0x22, 0xCE, 0x77, 0x38, 0x57, 0xEC, 0x2A, 0xF4, 0x75, 0x85, 0x4F, 0xA0,
  0xBE, 0x27, 0x38, 0x12, 0xEB, 0x38, 0x1B, 0xE2, 0x71, 0x81, 0x2E, 0xB5, 0x81, 0xBE, 0x26, 0x81,
  0x2E, 0xB7, 0x81, 0xBE, 0x24, 0x81, 0x2E, 0xB7, 0x28, 0x1B, 0xE2, 0x28, 0x12, 0xEB, 0x74, 0x84,
  0xBE, 0x22, 0xEB, 0x76, 0x82, 0xBE, 0xEB, 0x77, 0x10, 0x0B, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_4_bar_lock 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_4_bar_lock_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x50, 0x70, 0xEF, 0xB0, 0xE0, 0x72,
  0x02, 0x0C, 0xFF, 0x81, 0xC2, 0xAF, 0xFA, 0x81, 0xA0, 0xBF, 0xF0, 0xB3, 0x0B, 0xFA, 0x82, 0xC8,
  0x77, 0x50, 0xBF, 0x82, 0x80, 0x65, 0x70, 0xBD, 0x84, 0xE0, 0x47, 0x93, 0x70, 0xBC, 0x84, 0xC0,
  0x87, 0x87, 0x71, 0x0B, 0xB0, 0xC0, 0x4C, 0x03, 0x71, 0x0B, 0xA0, 0xA0, 0x4C, 0x03, 0x72, 0x82,
  0xBB, 0x04, 0xC0, 0x37, 0x68, 0x00, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_4_bar_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_4_bar_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_4_bar 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_4_bar_data[] PROGMEM = {
  0x58, 0x64, 0x79, 0xBB, 0x97, 0x47, 0x81, 0x29, 0xEF, 0x98, 0x1E, 0x92, 0x30, 0x9F, 0xF8, 0x19,
  0x07, 0xFF, 0xA8, 0x17, 0x0B, 0xFF, 0x0B, 0x20, 0x10, 0xDF, 0xD0, 0xD0, 0x13, 0x02, 0x0E, 0xFB,
  0x0E, 0x02, 0x50, 0x5F, 0xB0, 0x57, 0x07, 0xF9, 0x07, 0x72, 0x0A, 0xE0, 0xA7, 0x40, 0xDC, 0x0D,
  0x75, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x60, 0x4A, 0x04, 0x77, 0x10, 0x07, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_bad 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_bad_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x50, 0x70, 0xEF, 0xB0, 0xE0, 0x72,
  0x02, 0x0C, 0xFF, 0x81, 0xC2, 0xAF, 0xFA, 0x81, 0xA0, 0xBF, 0xF0, 0xB3, 0x0B, 0xD0, 0xB8, 0x03,
  0x75, 0x0B, 0xC0, 0x87, 0x60, 0xBB, 0x85, 0x80, 0xB7, 0x3D, 0x17, 0x10, 0xBA, 0x84, 0x80, 0x7F,
  0xEB, 0x73, 0x86, 0xBF, 0x80, 0x3E, 0xF7, 0x74, 0x86, 0xB8, 0x0D, 0xB7, 0xF2, 0x74, 0x81, 0x40,
  0x12, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_connected_no_internet_4 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_connected_no_internet_4_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x50, 0x70, 0xEF, 0xB0, 0xE0, 0x72,
  0x02, 0x0C, 0xFF, 0x81, 0xC2, 0xAF, 0xFA, 0x81, 0xA0, 0xBF, 0xF0, 0xB3, 0x0B, 0xD0, 0xB8, 0x03,
  0x75, 0x0B, 0xC0, 0x87, 0x60, 0xBB, 0x85, 0x80, 0xB7, 0x3D, 0x17, 0x10, 0xBA, 0x84, 0x80, 0x7F,
  0xEB, 0x73, 0x86, 0xBF, 0x80, 0x3E, 0xF7, 0x74, 0x86, 0xB8, 0x0D, 0xB7, 0xF2, 0x74, 0x81, 0x40,
  0x12, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_connected_no_internet_4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_connected_no_internet_4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_off 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_off_data[] PROGMEM = {
  0x18, 0x11, 0xB2, 0x77, 0x18, 0x92, 0x2D, 0xE2, 0x04, 0xAB, 0xB9, 0x74, 0x78, 0x44, 0xFE, 0x20,
  0xBD, 0x81, 0xE9, 0x23, 0x09, 0xB8, 0x2E, 0x20, 0xBF, 0x81, 0x90, 0x7D, 0x82, 0xE2, 0x0B, 0xF8,
  0x17, 0x0B, 0xD8, 0x2E, 0x20, 0xBD, 0x0B, 0x20, 0x10, 0xDD, 0x82, 0xE2, 0x0B, 0xB0, 0xD0, 0x13,
  0x02, 0x0E, 0xD8, 0x5E, 0x20, 0xBF, 0xE2, 0x50, 0x5E, 0x83, 0xE2, 0x0B, 0x57, 0x07, 0xE0, 0xE0,
  0x27, 0x30, 0xAE, 0x0E, 0x02, 0x73, 0x0D, 0xC8, 0x2D, 0xDE, 0x27, 0x20, 0x20, 0xEA, 0x84, 0xE2,
  0x2D, 0xE2, 0x72, 0x04, 0xA0, 0x42, 0x81, 0x2A, 0x17, 0x30, 0x07, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_statusbar_4_bar 18x18, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_statusbar_4_bar_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x50, 0x70, 0xEF, 0xB0, 0xE0, 0x72,
  0x02, 0x0C, 0xFF, 0x81, 0xC2, 0xAF, 0xFA, 0x81, 0xA0, 0xBF, 0xF0, 0xB3, 0x0B, 0xFD, 0x0B, 0x50,
  0xBF, 0xB0, 0xB7, 0x0B, 0xF9, 0x0B, 0x72, 0x0B, 0xE0, 0xB7, 0x40, 0xBC, 0x0B, 0x76, 0x0B, 0xA0,
  0xB7, 0x71, 0x00, 0xB7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_statusbar_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_statusbar_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_statusbar_connected_no_internet_4 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_statusbar_connected_no_internet_4_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x50, 0x70, 0xEF, 0xB0, 0xE0, 0x72,
  0x02, 0x0C, 0xFF, 0x81, 0xC2, 0xAF, 0xD8, 0x5D, 0xBB, 0xB9, 0x0B, 0xFC, 0x07, 0x60, 0xBF, 0xB8,
  0x27, 0x2D, 0x24, 0x0B, 0xFA, 0x82, 0x72, 0xF3, 0x50, 0xBF, 0x98, 0x27, 0x2F, 0x36, 0x0B, 0xE8,
  0x3B, 0x02, 0xF3, 0x70, 0xBC, 0x0B, 0x28, 0x12, 0xF3, 0x71, 0x0B, 0xA0, 0xB3, 0x81, 0x18, 0x17,
  0x20, 0x0B, 0x50, 0x27, 0x72, 0x81, 0x2F, 0x37, 0x72, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_statusbar_connected_no_internet_4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_statusbar_connected_no_internet_4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_signal_wifi_statusbar_null 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_outlined_18_device_signal_wifi_statusbar_null_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x58, 0x94, 0x7E, 0xE9, 0x52, 0x11,
  0x25, 0x9E, 0xE7, 0x28, 0x22, 0xCE, 0x77, 0x38, 0x57, 0xEC, 0x2A, 0xF4, 0x75, 0x85, 0x4F, 0xA0,
  0xBE, 0x27, 0x38, 0x12, 0xEB, 0x38, 0x1B, 0xE2, 0x71, 0x81, 0x2E, 0xB5, 0x81, 0xBE, 0x26, 0x81,
  0x2E, 0xB7, 0x81, 0xBE, 0x24, 0x81, 0x2E, 0xB7, 0x28, 0x1B, 0xE2, 0x28, 0x12, 0xEB, 0x74, 0x84,
  0xBE, 0x22, 0xEB, 0x76, 0x82, 0xBE, 0xEB, 0x77, 0x10, 0x0B, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_signal_wifi_statusbar_null() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_signal_wifi_statusbar_null_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_sim_card_download 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_outlined_18_device_sim_card_download_data[] PROGMEM = {
  0x48, 0x02, 0x30, 0x14, 0x07, 0xF0, 0x22, 0x81, 0x7F, 0x68, 0x01, 0x18, 0x4E, 0x60, 0x7F, 0x66,
  0x83, 0xE6, 0x4F, 0x67, 0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x30, 0x07, 0x38, 0x2E, 0x66,
  0xE3, 0x00, 0xA3, 0x8A, 0x1E, 0x66, 0xE0, 0x4B, 0xBB, 0xB4, 0x0E, 0x66, 0xE0, 0x2E, 0xA8, 0x5E,
  0x20, 0xE6, 0x6E, 0x28, 0x22, 0xEE, 0x22, 0x82, 0xE6, 0x6E, 0x30, 0x02, 0x38, 0x2E, 0x66, 0xE7,
  0x18, 0x2E, 0x66, 0xE8, 0x04, 0x18, 0x1E, 0x62, 0xFB, 0x81, 0x20, 0x18, 0x04, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_sim_card_download() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_sim_card_download_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_splitscreen 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_device_splitscreen_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x38, 0x11, 0x02, 0xFB, 0x81, 0x26, 0xE8, 0x04, 0x18, 0x2E, 0x66, 0xE7, 0x18,
  0x2E, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE8, 0x04, 0x38, 0x2E, 0x62, 0xEF, 0x90, 0xE0, 0x22, 0x80,
  0x41, 0x48, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x82, 0xE6, 0x6E, 0x71,
  0x82, 0xE6, 0x6E, 0x71, 0x82, 0xE6, 0x6E, 0x80, 0x41, 0x81, 0xE6, 0x2F, 0xB8, 0x12, 0x01, 0x80,
  0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_splitscreen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_splitscreen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_sports_score 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_device_sports_score_data[] PROGMEM = {
  0x8A, 0x32, 0x40, 0x43, 0x06, 0x12, 0x57, 0xD0, 0xB8, 0x2E, 0x46, 0xE7, 0xA8, 0xB2, 0x37, 0xD0,
  0xB9, 0x07, 0xD3, 0x97, 0x4A, 0x56, 0xA7, 0xE5, 0x87, 0x5A, 0x56, 0x97, 0xA8, 0xB3, 0x37, 0xD0,
  0xB9, 0x07, 0xD0, 0xC8, 0x1F, 0x36, 0xE7, 0xD0, 0x43, 0x05, 0x12, 0x57, 0xD7, 0x10, 0x70, 0xD7,
  0x10, 0x70, 0xD7, 0x10, 0x20, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_sports_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_sports_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_ssid_chart 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_outlined_18_device_ssid_chart_data[] PROGMEM = {
  0x74, 0x81, 0x1B, 0x43, 0x08, 0x06, 0x58, 0x53, 0xDD, 0x20, 0x2C, 0xA0, 0x63, 0x89, 0x67, 0xFA,
  0x10, 0x3E, 0xC2, 0x7F, 0x61, 0xBF, 0x63, 0x04, 0x08, 0x38, 0x37, 0xFE, 0xD3, 0x73, 0x07, 0x09,
  0x71, 0x06, 0x03, 0x74, 0x82, 0xAF, 0xE3, 0x72, 0x84, 0x4E, 0x5B, 0xE3, 0x38, 0x54, 0xBB, 0xB3,
  0x21, 0x28, 0x90, 0xBE, 0x30, 0x7F, 0xB9, 0x92, 0x58, 0x3B, 0xEB, 0xF6, 0x73, 0x81, 0xBD, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_ssid_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_ssid_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_storage 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_outlined_18_device_storage_data[] PROGMEM = {
  0x82, 0x7F, 0xBD, 0xFC, 0x83, 0x77, 0xF0, 0x7F, 0xC8, 0x37, 0x7F, 0xBD, 0xFC, 0x07, 0x77, 0x20,
  0x38, 0x09, 0x27, 0x83, 0x37, 0xF3, 0x9F, 0xC8, 0x37, 0x7F, 0x39, 0xFC, 0x07, 0x03, 0x80, 0x92,
  0x70, 0x37, 0x72, 0x82, 0x7F, 0xBD, 0xFC, 0x83, 0x77, 0xF0, 0x7F, 0xC8, 0x37, 0x7F, 0xBD, 0xFC,
  0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_storage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_storage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_storm 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_outlined_18_device_storm_data[] PROGMEM = {
  0x10, 0x20, 0x37, 0x50, 0xB0, 0xA7, 0x59, 0x05, 0x28, 0x22, 0x55, 0x25, 0x83, 0x2F, 0x31, 0xBC,
  0x0B, 0x01, 0x38, 0x44, 0xF3, 0xED, 0x42, 0x82, 0x4D, 0xD1, 0x28, 0x92, 0x3F, 0xCD, 0x03, 0x99,
  0x30, 0xDB, 0x20, 0x1A, 0x89, 0x04, 0x3F, 0xCC, 0xF3, 0x4F, 0x42, 0x83, 0xEF, 0x09, 0xC2, 0x83,
  0xC9, 0x0F, 0xA2, 0x83, 0xAF, 0x09, 0xC2, 0x83, 0xC9, 0x0F, 0xE2, 0x89, 0x04, 0xF4, 0x3F, 0xCC,
  0xF3, 0x4A, 0x01, 0x28, 0x92, 0xBD, 0x03, 0x99, 0x30, 0xDC, 0xF3, 0x28, 0x21, 0xDD, 0x42, 0x84,
  0x4D, 0xE3, 0xF4, 0x30, 0x10, 0xBC, 0x83, 0xB1, 0x3F, 0x25, 0x82, 0x25, 0x52, 0x20, 0x59, 0x75,
  0x0A, 0x0B, 0x75, 0x03, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_storm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_storm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_summarize 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_device_summarize_data[] PROGMEM = {
  0x10, 0x28, 0x04, 0x34, 0x02, 0xFA, 0x07, 0x30, 0x49, 0x60, 0x3A, 0x07, 0x28, 0x34, 0xF0, 0x34,
  0x30, 0x3B, 0x85, 0x70, 0x4F, 0x04, 0x63, 0x03, 0xC0, 0x30, 0x49, 0x78, 0x90, 0x33, 0x4F, 0x44,
  0xF0, 0x45, 0x79, 0x84, 0x44, 0xF0, 0x45, 0x79, 0x00, 0x49, 0x73, 0x98, 0x44, 0x4F, 0x04, 0x67,
  0x98, 0x44, 0x4F, 0x03, 0x47, 0x90, 0x04, 0x97, 0x39, 0x04, 0x02, 0xFD, 0x81, 0x20, 0x28, 0x06,
  0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_summarize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_summarize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_system_security_update_good 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_outlined_18_device_system_security_update_good_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x81, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE5, 0x01, 0x28, 0x2E, 0x66,
  0xE4, 0x8B, 0x01, 0xD9, 0x0E, 0x66, 0xE0, 0x7A, 0x2D, 0xD1, 0x0E, 0x66, 0xE0, 0x3E, 0xFD, 0x12,
  0x82, 0xE6, 0x6E, 0x28, 0x13, 0xC1, 0x38, 0x2E, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE7, 0x18, 0x1E,
  0x66, 0x98, 0x04, 0x79, 0x00, 0x69, 0x80, 0x4D, 0x98, 0x16, 0x6E, 0x80, 0x43, 0x82, 0xE6, 0x2E,
  0xF9, 0x0E, 0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_system_security_update_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_system_security_update_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_system_security_update 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_outlined_18_device_system_security_update_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x81, 0x66, 0xE7, 0x18, 0x2E, 0x66, 0xE3, 0x00, 0x73, 0x82, 0xE6,
  0x6E, 0x30, 0x0A, 0x38, 0xA1, 0xE6, 0x6E, 0x03, 0x9A, 0xA9, 0x30, 0xE6, 0x6E, 0x03, 0xEA, 0x85,
  0xE3, 0x0E, 0x66, 0xE2, 0x82, 0x3E, 0xE3, 0x28, 0x2E, 0x66, 0xE3, 0x00, 0x33, 0x82, 0xE6, 0x6E,
  0x71, 0x81, 0xE6, 0x69, 0x80, 0x47, 0x90, 0x06, 0x98, 0x04, 0xD9, 0x81, 0x66, 0xE8, 0x04, 0x38,
  0x2E, 0x62, 0xEF, 0x90, 0xE0, 0x22, 0x80, 0x41, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_system_security_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_system_security_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_system_security_update_warning 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_device_system_security_update_warning_data[] PROGMEM = {
  0x28, 0x04, 0x12, 0x02, 0x0E, 0xF9, 0x82, 0xE2, 0x6E, 0x80, 0x43, 0x81, 0xE6, 0x69, 0x80, 0x4D,
  0x90, 0x06, 0x98, 0x04, 0x79, 0x81, 0x66, 0xE3, 0x00, 0x63, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38,
  0x2E, 0x66, 0xE3, 0x00, 0xA3, 0x82, 0xE6, 0x6E, 0x30, 0x0A, 0x38, 0x2E, 0x66, 0xE3, 0x00, 0xA3,
  0x82, 0xE6, 0x6E, 0x30, 0x03, 0x38, 0x2E, 0x66, 0xE3, 0x00, 0x73, 0x82, 0xE6, 0x6E, 0x30, 0x06,
  0x38, 0x1E, 0x66, 0x98, 0x04, 0x79, 0x00, 0x69, 0x80, 0x4D, 0x98, 0x16, 0x6E, 0x80, 0x43, 0x82,
  0xE6, 0x2E, 0xF9, 0x0E, 0x02, 0x28, 0x04, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_system_security_update_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_system_security_update_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_task 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_18_device_task_data[] PROGMEM = {
  0x10, 0x18, 0x02, 0x34, 0x02, 0xF0, 0x73, 0x85, 0x6E, 0x11, 0x11, 0x3A, 0x07, 0x20, 0x60, 0xE4,
  0x01, 0xB8, 0x27, 0x06, 0xE4, 0x01, 0xC8, 0x14, 0x6E, 0x50, 0xF3, 0x82, 0xE6, 0x6E, 0x71, 0x82,
  0xE6, 0x6E, 0x68, 0x46, 0x0E, 0x66, 0xE5, 0x8A, 0x7B, 0xE2, 0xE6, 0x6E, 0x1B, 0x40, 0xBE, 0x40,
  0xE6, 0x6E, 0x0B, 0xFC, 0xE4, 0x28, 0x2E, 0x66, 0xE2, 0x81, 0xBE, 0x43, 0x82, 0xE6, 0x6E, 0x30,
  0x34, 0x82, 0xE6, 0x6E, 0x80, 0x41, 0x81, 0xE6, 0x2F, 0xB8, 0x12, 0x01, 0x80, 0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_task() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_task_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_thermostat 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_outlined_18_device_thermostat_data[] PROGMEM = {
  0x30, 0x06, 0x50, 0xCA, 0x0C, 0x38, 0x43, 0xF6, 0x9F, 0x32, 0x84, 0x3F, 0x39, 0xF3, 0x28, 0x43,
  0xF3, 0x3F, 0x32, 0x84, 0x3F, 0x3C, 0xF3, 0x28, 0x43, 0xF3, 0x3F, 0x32, 0x84, 0x3F, 0xCC, 0xF3,
  0x20, 0x4C, 0x82, 0x40, 0x1D, 0xC8, 0x1D, 0x17, 0xE0, 0x70, 0xBE, 0x0B, 0x09, 0xE0, 0x90, 0x3E,
  0x81, 0x30, 0x7C, 0x07, 0x38, 0x22, 0x66, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_thermostat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 12, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_thermostat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_timer_10_select 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_18_device_timer_10_select_data[] PROGMEM = {
  0x10, 0xF7, 0x85, 0x30, 0x47, 0x77, 0x57, 0x01, 0xB0, 0x70, 0x5D, 0x07, 0x78, 0x91, 0x37, 0xF7,
  0x9F, 0x63, 0x5F, 0xA7, 0x18, 0x90, 0x4F, 0x79, 0xF3, 0x01, 0xFA, 0x71, 0x89, 0x64, 0xF7, 0x9F,
  0x30, 0x1F, 0xA2, 0xDD, 0xDD, 0x12, 0x89, 0x14, 0xF7, 0x9F, 0x30, 0x1F, 0xA6, 0x90, 0xF7, 0x38,
  0x95, 0x4F, 0x79, 0xF3, 0x01, 0xFA, 0x5F, 0xDD, 0xB3, 0x89, 0x64, 0xF7, 0x9F, 0x63, 0x5F, 0xA0,
  0x67, 0x9F, 0x12, 0x82, 0x4F, 0x75, 0xD8, 0x57, 0x5D, 0xDE, 0xF1, 0x28, 0x95, 0x27, 0x30, 0x47,
  0x77, 0x50, 0x37, 0x77, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_timer_10_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 17, 13), Box(0, 0, 17, 17),
      ic_outlined_18_device_timer_10_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_timer_3_select 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_outlined_18_device_timer_3_select_data[] PROGMEM = {
  0x83, 0x37, 0x77, 0x67, 0x06, 0xC0, 0xB6, 0x83, 0x13, 0x33, 0xD9, 0x73, 0x0C, 0x0E, 0x78, 0xA5,
  0xCD, 0xDE, 0x50, 0xBD, 0xDD, 0x50, 0xCD, 0xDE, 0x51, 0xF9, 0x77, 0x34, 0x8A, 0x3C, 0xE1, 0xFE,
  0xDC, 0x21, 0x33, 0x3D, 0xF0, 0x57, 0x7F, 0x66, 0xC8, 0x92, 0xB1, 0xDD, 0xDF, 0x53, 0x77, 0x76,
  0x20, 0xF7, 0x06, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_timer_3_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 13), Box(0, 0, 17, 17),
      ic_outlined_18_device_timer_3_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_tungsten 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_outlined_18_device_tungsten_data[] PROGMEM = {
  0x58, 0x41, 0x33, 0x33, 0x17, 0x30, 0x3C, 0x03, 0x73, 0x84, 0x3F, 0x11, 0xF3, 0x73, 0x84, 0x3F,
  0x99, 0xF3, 0x73, 0x84, 0x8F, 0xDD, 0xF8, 0x72, 0x81, 0x3F, 0x62, 0x81, 0x6F, 0x34, 0x84, 0x2A,
  0x60, 0x8D, 0x48, 0x92, 0xD8, 0x06, 0xA2, 0x2A, 0x60, 0x7D, 0x48, 0x4D, 0x70, 0x6A, 0x24, 0x81,
  0x3F, 0x62, 0x81, 0x6F, 0x37, 0x28, 0x47, 0xFD, 0xDF, 0x77, 0x18, 0x90, 0x51, 0x03, 0x77, 0x30,
  0x15, 0x58, 0x14, 0xF5, 0x68, 0x15, 0xF4, 0x50, 0x43, 0x00, 0x63, 0x04, 0x73, 0x00, 0xA7, 0x70,
  0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_tungsten() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_tungsten_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_usb_off 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_device_usb_off_data[] PROGMEM = {
  0x10, 0x25, 0x00, 0x96, 0x81, 0x1E, 0x73, 0x06, 0xA0, 0x66, 0x81, 0x6F, 0x72, 0x82, 0x7C, 0xC7,
  0x78, 0x16, 0xF7, 0x20, 0x0A, 0x72, 0x89, 0x09, 0xF7, 0x07, 0xA0, 0x8B, 0xB5, 0x0D, 0xA8, 0x57,
  0x04, 0x0B, 0xFE, 0x58, 0x38, 0xFA, 0xF7, 0x28, 0x1B, 0xFE, 0x58, 0x90, 0x4F, 0x16, 0xF7, 0x01,
  0xF4, 0x58, 0x90, 0x3F, 0xA9, 0xDF, 0x70, 0x93, 0x68, 0x57, 0xBB, 0xEE, 0xF7, 0x74, 0x83, 0xAA,
  0x6F, 0x77, 0x38, 0x4B, 0xB0, 0x6F, 0x77, 0x10, 0x3A, 0x83, 0x30, 0x6F, 0x77, 0x82, 0x2E, 0xE2,
  0x28, 0x16, 0xE2, 0x70, 0x01, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_usb_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_usb_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_usb 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_device_usb_data[] PROGMEM = {
  0x50, 0x08, 0x72, 0x04, 0xA0, 0x47, 0x18, 0x2A, 0xEE, 0xA7, 0x20, 0x0B, 0x68, 0x92, 0xAC, 0x40,
  0xBB, 0x08, 0xBB, 0x25, 0xA8, 0x4C, 0x0B, 0xB0, 0xBA, 0x89, 0x03, 0x2E, 0xF9, 0x0B, 0xB0, 0xBA,
  0x81, 0x30, 0x89, 0x28, 0xA0, 0xBB, 0x02, 0xF9, 0x10, 0x7F, 0x33, 0xCC, 0x33, 0xF7, 0x20, 0x3F,
  0x90, 0x33, 0x86, 0x13, 0x3C, 0xC3, 0x31, 0x70, 0x0B, 0x73, 0x00, 0xC7, 0x20, 0x7A, 0x07, 0x71,
  0x08, 0xA0, 0x87, 0x20, 0x08, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_usb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_usb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wallpaper 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_outlined_18_device_wallpaper_data[] PROGMEM = {
  0x10, 0x58, 0x01, 0x70, 0x01, 0x80, 0x17, 0x81, 0x50, 0x5E, 0x00, 0x3E, 0x05, 0x07, 0x97, 0x59,
  0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x81, 0x2A, 0x42, 0x90, 0x07, 0x97, 0x81, 0x6F, 0xA2, 0x90,
  0x07, 0x97, 0x10, 0x60, 0x22, 0x98, 0x17, 0x13, 0x75, 0x82, 0x31, 0x13, 0x75, 0x81, 0x31, 0x79,
  0x38, 0x12, 0xD2, 0x20, 0x23, 0x90, 0x07, 0x93, 0x85, 0xDF, 0xD0, 0x7E, 0x12, 0x90, 0x07, 0x92,
  0x0A, 0xB0, 0xCA, 0x0B, 0x29, 0x83, 0x77, 0xF0, 0x28, 0x04, 0x78, 0x32, 0x0F, 0x77, 0x97, 0x59,
  0x07, 0x05, 0xE0, 0x03, 0xE8, 0x15, 0x05, 0x80, 0x17, 0x00, 0x18, 0x01, 0x70, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wallpaper() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_wallpaper_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_water 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_device_water_data[] PROGMEM = {
  0x18, 0xC3, 0x6E, 0xFA, 0x38, 0xEE, 0x83, 0xAF, 0xE6, 0x03, 0xF8, 0x6D, 0xFE, 0x77, 0xEF, 0xD6,
  0x8F, 0x30, 0x10, 0x10, 0x24, 0x83, 0x20, 0x10, 0x12, 0x84, 0x7E, 0xFB, 0x49, 0xA8, 0xA5, 0x94,
  0xBF, 0xE7, 0x03, 0xE7, 0x5C, 0xFE, 0x66, 0xEF, 0xC5, 0x7E, 0x32, 0x89, 0x21, 0x20, 0x10, 0x11,
  0x01, 0x02, 0x12, 0x01, 0x08, 0xA8, 0x1C, 0x5A, 0xA8, 0x1A, 0x5C, 0xA8, 0xA0, 0x81, 0x3E, 0x63,
  0xBF, 0xD5, 0x5D, 0xFB, 0x36, 0xE3,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_water() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 12), Box(0, 0, 17, 17),
      ic_outlined_18_device_water_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_widgets 18x18, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_outlined_18_device_widgets_data[] PROGMEM = {
  0x73, 0x07, 0x40, 0x88, 0x01, 0xB0, 0x22, 0x81, 0xBF, 0xA3, 0x89, 0x3B, 0xEB, 0xBC, 0xF3, 0x0B,
  0xF9, 0xFA, 0x20, 0x0B, 0x28, 0x93, 0x3F, 0x4B, 0xF6, 0x06, 0xFA, 0x0B, 0xB2, 0x83, 0x3F, 0xBF,
  0x93, 0x8A, 0x19, 0xF7, 0xBC, 0x33, 0x6F, 0x4B, 0xF5, 0x05, 0xFB, 0x0B, 0xD8, 0x53, 0x0B, 0xF9,
  0xFB, 0x20, 0x28, 0x01, 0x30, 0x12, 0x81, 0xBF, 0xB3, 0x02, 0x80, 0x13, 0x89, 0x01, 0x13, 0x4B,
  0x43, 0x20, 0xBD, 0x00, 0x3D, 0x8A, 0x1B, 0x0B, 0xC3, 0x36, 0xF3, 0x3F, 0x63, 0x3C, 0xB0, 0xBB,
  0x28, 0x43, 0xF3, 0x3F, 0x32, 0x83, 0xBB, 0x0B, 0xB2, 0x84, 0x3F, 0x33, 0xF3, 0x28, 0xA1, 0xBB,
  0x0B, 0xEB, 0xBC, 0xF3, 0x3F, 0xCB, 0xBE, 0xB0, 0x88, 0x01, 0xB0, 0x02, 0x80, 0x1B, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_widgets() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_widgets_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_1_bar 18x18, 4-bit Alpha,  RLE, 12 bytes.
static const unsigned char ic_outlined_18_device_wifi_1_bar_data[] PROGMEM = {
  0x20, 0x03, 0x20, 0x40, 0xEA, 0x82, 0xE4, 0x0B, 0xA0, 0xB3, 0x00, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 11, 11, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_2_bar 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_outlined_18_device_wifi_2_bar_data[] PROGMEM = {
  0x28, 0x61, 0x59, 0xBB, 0x95, 0x13, 0x07, 0x0E, 0xE8, 0x6E, 0x70, 0x8F, 0xE7, 0x32, 0x86, 0x37,
  0xEF, 0x80, 0x81, 0x60, 0x10, 0x86, 0x00, 0x37, 0x10, 0x40, 0xEA, 0x0E, 0x04, 0x70, 0xBA, 0x0B,
  0x72, 0x00, 0xB5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_calling_3 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_18_device_wifi_calling_3_data[] PROGMEM = {
  0x10, 0xF3, 0x02, 0x48, 0x13, 0x31, 0x20, 0x3B, 0x0E, 0x28, 0xC0, 0x8D, 0xA9, 0xCB, 0x22, 0xF2,
  0x1F, 0x45, 0x81, 0x56, 0x24, 0x90, 0xF5, 0x1F, 0x60, 0x1D, 0x87, 0xC5, 0x28, 0x3B, 0xBD, 0xD1,
  0x38, 0x17, 0x92, 0x38, 0x25, 0xFD, 0x14, 0x06, 0x0B, 0x50, 0xD0, 0xA7, 0x58, 0x14, 0xF5, 0x75,
  0x81, 0x8E, 0x33, 0x81, 0x16, 0x46, 0x84, 0xAE, 0x50, 0x1D, 0xA0, 0xE0, 0x25, 0x87, 0x8F, 0xAD,
  0xD1, 0x2F, 0x46, 0x86, 0x4D, 0xFB, 0x53, 0xF4, 0x71, 0x05, 0x0B, 0xB0, 0x37, 0x40, 0x20, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_calling_3() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_calling_3_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_channel 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_outlined_18_device_wifi_channel_data[] PROGMEM = {
  0x72, 0x02, 0x01, 0x74, 0x82, 0x6F, 0xE1, 0x73, 0x82, 0xE9, 0xD8, 0x72, 0x83, 0x4F, 0x17, 0xE5,
  0x05, 0x08, 0x28, 0x48, 0xC0, 0x2F, 0x33, 0x85, 0x3F, 0xE9, 0x0C, 0x82, 0x0E, 0x06, 0x38, 0x5B,
  0xB5, 0xF2, 0xF5, 0x20, 0xB0, 0x92, 0x86, 0x1F, 0x50, 0xE9, 0xF3, 0x20, 0x90, 0xC2, 0x06, 0x0E,
  0x20, 0x9A, 0x83, 0x7E, 0xD9, 0xE2, 0x0A, 0x0B, 0x20, 0x5B, 0x07, 0x0B, 0xA2, 0x0D, 0x07, 0x20,
  0x2A, 0x87, 0xA0, 0x1E, 0xF1, 0x0F, 0x53, 0x81, 0xEF, 0x32, 0x84, 0x9F, 0x33, 0xF2, 0x30, 0xC0,
  0xD3, 0x83, 0x4F, 0x41, 0x34, 0x00, 0x24, 0x03, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_channel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_channel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_find 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_device_wifi_find_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x58, 0x94, 0x7E, 0xE9, 0x52, 0x11,
  0x25, 0x9E, 0xE7, 0x28, 0x22, 0xCE, 0x77, 0x38, 0x57, 0xEC, 0x2A, 0xF4, 0x75, 0x85, 0x4F, 0xA0,
  0xBE, 0x27, 0x84, 0x7B, 0x91, 0x3B, 0x38, 0x1B, 0xE2, 0x58, 0x3A, 0xE9, 0xDC, 0x68, 0x1B, 0xE2,
  0x49, 0x83, 0x50, 0x2F, 0x36, 0x81, 0xBE, 0x23, 0x84, 0xE7, 0x03, 0xF3, 0x78, 0x1B, 0xE2, 0x28,
  0x17, 0xFC, 0xA0, 0x37, 0x18, 0x91, 0xBE, 0x21, 0x04, 0x86, 0xBE, 0x37, 0x18, 0x2B, 0xEE, 0x74,
  0x0B, 0x0D, 0x72, 0x00, 0xB6, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_find() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_find_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_lock 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_device_wifi_lock_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x50, 0x70, 0xEF, 0xB0, 0xE0, 0x72,
  0x02, 0x0C, 0xFF, 0x81, 0xC2, 0xAF, 0xFA, 0x81, 0xA0, 0xBF, 0xF0, 0xB3, 0x0B, 0xFA, 0x82, 0xC8,
  0x77, 0x50, 0xBF, 0x82, 0x80, 0x65, 0x70, 0xBD, 0x84, 0xE0, 0x47, 0x93, 0x70, 0xBC, 0x84, 0xC0,
  0x87, 0x87, 0x71, 0x0B, 0xB0, 0xC0, 0x4C, 0x03, 0x71, 0x0B, 0xA0, 0xA0, 0x4C, 0x03, 0x72, 0x82,
  0xBB, 0x04, 0xC0, 0x37, 0x68, 0x00, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_password 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_outlined_18_device_wifi_password_data[] PROGMEM = {
  0x78, 0x22, 0x33, 0x27, 0x38, 0x11, 0x7B, 0xE8, 0x1B, 0x71, 0x50, 0x70, 0xEA, 0x84, 0xC9, 0x88,
  0x9C, 0xA0, 0xE0, 0x72, 0x84, 0x2C, 0xFE, 0x71, 0x68, 0x90, 0x17, 0xEF, 0xC2, 0xAF, 0x91, 0x73,
  0x84, 0x19, 0xFA, 0x05, 0x38, 0x61, 0x59, 0xBB, 0x95, 0x13, 0x05, 0x50, 0x70, 0xEE, 0x0E, 0x07,
  0x78, 0x38, 0xFE, 0x73, 0x28, 0x33, 0x7E, 0xF8, 0x70, 0x80, 0x16, 0x01, 0x08, 0x75, 0x00, 0x37,
  0x70, 0x40, 0xEA, 0x0E, 0x04, 0x28, 0x12, 0xB8, 0x71, 0x0B, 0xA0, 0xB3, 0x82, 0x81, 0x91, 0x71,
  0x00, 0xB3, 0x83, 0x1C, 0xAD, 0x67, 0x60, 0x7C, 0x76, 0x07, 0xC7, 0x60, 0x4B, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_password() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_password_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_tethering_error 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_outlined_18_device_wifi_tethering_error_data[] PROGMEM = {
  0x68, 0x21, 0x33, 0x17, 0x30, 0x50, 0xCC, 0x0C, 0x05, 0x78, 0x90, 0xAF, 0x94, 0x11, 0x4A, 0xF9,
  0x58, 0x92, 0xAE, 0x40, 0x47, 0x74, 0x04, 0xE9, 0x38, 0x94, 0x4F, 0x41, 0xBF, 0xDD, 0xFB, 0x14,
  0xB2, 0x28, 0x4B, 0xA0, 0xAD, 0x32, 0x81, 0x3D, 0xA5, 0x98, 0xA3, 0x53, 0xF3, 0x04, 0x40, 0x3F,
  0x32, 0xD2, 0x2F, 0x36, 0xE0, 0x3A, 0x89, 0x43, 0x0E, 0x62, 0xF3, 0x2F, 0x36, 0xE0, 0x2A, 0x8B,
  0x32, 0x0E, 0x62, 0xF3, 0x0E, 0x62, 0xF5, 0x01, 0x10, 0x5F, 0x22, 0xF3, 0x0A, 0xC0, 0x96, 0x48,
  0x90, 0x69, 0x01, 0x91, 0x03, 0xF6, 0x72, 0x81, 0x17, 0x12, 0x07, 0x06, 0x72, 0x81, 0x1D, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_tethering_error() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_tethering_error_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_tethering_error_rounded 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_outlined_18_device_wifi_tethering_error_rounded_data[] PROGMEM = {
  0x68, 0x21, 0x33, 0x17, 0x30, 0x50, 0xCC, 0x0C, 0x05, 0x78, 0x90, 0xAF, 0x94, 0x11, 0x4A, 0xF9,
  0x58, 0x92, 0xAE, 0x40, 0x47, 0x74, 0x04, 0xE9, 0x38, 0x94, 0x4F, 0x41, 0xBF, 0xDD, 0xFB, 0x14,
  0xB2, 0x28, 0x4B, 0xA0, 0xAD, 0x32, 0x81, 0x3D, 0xA5, 0x98, 0xA3, 0x53, 0xF3, 0x04, 0x40, 0x3F,
  0x32, 0xD2, 0x2F, 0x36, 0xE0, 0x3A, 0x89, 0x43, 0x0E, 0x62, 0xF3, 0x2F, 0x36, 0xE0, 0x2A, 0x8B,
  0x32, 0x0E, 0x62, 0xF3, 0x0E, 0x62, 0xF5, 0x01, 0x10, 0x5F, 0x22, 0xF3, 0x0A, 0xC0, 0x96, 0x48,
  0x90, 0x69, 0x01, 0x91, 0x03, 0xF6, 0x72, 0x81, 0x17, 0x12, 0x07, 0x06, 0x72, 0x81, 0x1D, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_tethering_error_rounded() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_tethering_error_rounded_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_tethering_off 18x18, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_outlined_18_device_wifi_tethering_off_data[] PROGMEM = {
  0x10, 0x24, 0x82, 0x13, 0x31, 0x68, 0x41, 0xE7, 0x02, 0xCC, 0x0C, 0x05, 0x58, 0x92, 0x6F, 0x70,
  0x64, 0x11, 0x49, 0xFA, 0x58, 0x92, 0xCF, 0x70, 0x18, 0x74, 0x04, 0xEA, 0x38, 0x94, 0x5F, 0x9F,
  0x70, 0x8D, 0xFB, 0x14, 0xF4, 0x28, 0x4B, 0xA0, 0xCF, 0x72, 0x84, 0x3D, 0xA0, 0xAB, 0x29, 0x84,
  0x53, 0xF9, 0xF7, 0x28, 0x95, 0x3F, 0x35, 0xF0, 0x2F, 0x26, 0xE0, 0x7F, 0x72, 0x89, 0x2E, 0x63,
  0xF2, 0x2F, 0x36, 0xE0, 0x2A, 0x8A, 0x07, 0x08, 0x63, 0xF1, 0x0E, 0x62, 0xF5, 0x01, 0x7F, 0x72,
  0x06, 0x92, 0x83, 0xAC, 0x09, 0x63, 0x84, 0x6F, 0x70, 0x7A, 0x28, 0x13, 0xF6, 0x68, 0x36, 0xF7,
  0x01, 0x30, 0x70, 0x67, 0x81, 0x6F, 0x77, 0x78, 0x16, 0xE2, 0x77, 0x01, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_tethering_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_tethering_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_device_wifi_tethering 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_outlined_18_device_wifi_tethering_data[] PROGMEM = {
  0x58, 0x44, 0x8A, 0xA8, 0x47, 0x18, 0x90, 0x3C, 0xFE, 0xCC, 0xEF, 0xC3, 0x58, 0x25, 0xFD, 0x54,
  0x82, 0x5D, 0xF5, 0x38, 0x12, 0xEB, 0x28, 0x26, 0xAA, 0x62, 0x81, 0xBE, 0x22, 0x8A, 0x4B, 0xE1,
  0x2D, 0xFD, 0xDF, 0xD2, 0x1E, 0xB0, 0x1F, 0x70, 0xCE, 0x32, 0x8B, 0x43, 0xEC, 0x07, 0xF1, 0x5F,
  0x23, 0xF5, 0x09, 0x90, 0x5F, 0x32, 0xF5, 0x7F, 0x06, 0xF0, 0x6A, 0x89, 0x46, 0x0F, 0x60, 0xF7,
  0x6F, 0x16, 0xF2, 0x3A, 0x8B, 0x43, 0x2F, 0x61, 0xF6, 0x3F, 0x41, 0xF9, 0x01, 0x10, 0x9F, 0x14,
  0xF3, 0x0D, 0xB0, 0x7F, 0x42, 0x84, 0x4F, 0x70, 0xBD, 0x28, 0x37, 0xF5, 0x05, 0x48, 0x35, 0x05,
  0xF6, 0x38, 0x1B, 0xF6, 0x68, 0x16, 0xFB, 0x50, 0x0A, 0x60, 0x0A, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_device_wifi_tethering() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_device_wifi_tethering_data, Alpha4(color::Black));
  return value;
}
