#include "communication.h"

using namespace roo_display;

// Image file ic_outlined_18_communication_3p 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_communication_3p_data[] PROGMEM = {
  0x28, 0x09, 0x03, 0x30, 0xEF, 0xD8, 0x3E, 0x03, 0xF3, 0x80, 0x61, 0x84, 0x3F, 0x33, 0xF2, 0x73,
  0x84, 0x2F, 0x33, 0xF2, 0x38, 0x21, 0xDD, 0x13, 0x84, 0x2F, 0x33, 0xF2, 0x30, 0x4A, 0x04, 0x38,
  0x42, 0xF3, 0x3F, 0x24, 0x00, 0x74, 0x84, 0x2F, 0x33, 0xF2, 0x38, 0x24, 0x77, 0x43, 0x84, 0x2F,
  0x33, 0xF2, 0x20, 0xAC, 0x0A, 0x28, 0x42, 0xF3, 0x3F, 0x22, 0x84, 0xAB, 0xBB, 0xBA, 0x28, 0x42,
  0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x88, 0x07, 0xD9, 0x01, 0x03, 0xA0, 0x98, 0x06, 0x78,
  0x34, 0x03, 0xF7, 0x76, 0x03, 0x07, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_3p() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_3p_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_add_ic_call 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_18_communication_add_ic_call_data[] PROGMEM = {
  0x83, 0x6B, 0xBB, 0x25, 0x0B, 0x05, 0x28, 0x3A, 0xEB, 0xF6, 0x59, 0x07, 0x28, 0x39, 0xD0, 0xE8,
  0x28, 0x92, 0x17, 0x7F, 0xB7, 0x57, 0xF1, 0xDB, 0x20, 0x3D, 0x84, 0xB3, 0xFC, 0xF7, 0x59, 0x07,
  0x38, 0x1D, 0xF7, 0x69, 0x07, 0x38, 0x16, 0xF3, 0x60, 0x30, 0x14, 0x0D, 0x0C, 0x75, 0x81, 0x3F,
  0xA7, 0x58, 0x16, 0xFA, 0x38, 0x38, 0xC8, 0x72, 0x48, 0x90, 0x6F, 0xD4, 0x9F, 0xCE, 0xFB, 0x50,
  0x30, 0xDA, 0x83, 0xB1, 0x0B, 0xB7, 0x06, 0x0D, 0xA8, 0x1E, 0xEB, 0x72, 0x83, 0x27, 0x8A, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_add_ic_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_add_ic_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_alternate_email 18x18, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_outlined_18_communication_alternate_email_data[] PROGMEM = {
  0x58, 0x41, 0x57, 0x75, 0x17, 0x10, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33,
  0x8F, 0xD2, 0x38, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x28, 0x19, 0xF3, 0x28, 0x26, 0xAA, 0x62,
  0x85, 0x3F, 0x90, 0x1F, 0x82, 0x84, 0xBF, 0xCC, 0xFB, 0x28, 0x90, 0x8F, 0x15, 0xF3, 0x06, 0xF5,
  0x28, 0x65, 0xF6, 0x03, 0xF5, 0x79, 0x20, 0xA0, 0xD4, 0x0D, 0x0A, 0x29, 0x07, 0x06, 0x92, 0x09,
  0x0D, 0x40, 0xD0, 0xB2, 0x98, 0x67, 0x4F, 0x30, 0x5F, 0x72, 0x89, 0x07, 0xFD, 0x02, 0xF6, 0x0F,
  0x92, 0x89, 0x5A, 0xFD, 0xDF, 0xCF, 0xDE, 0xE1, 0x08, 0xF3, 0x28, 0x75, 0x99, 0x50, 0x49, 0x82,
  0x28, 0x21, 0xDE, 0x37, 0x68, 0x42, 0xDF, 0x93, 0x17, 0x48, 0x11, 0x8E, 0xD0, 0xB7, 0x38, 0x44,
  0x67, 0x77, 0x54,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_alternate_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_alternate_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_app_registration 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_outlined_18_communication_app_registration_data[] PROGMEM = {
  0x89, 0x42, 0x66, 0x12, 0x66, 0x21, 0x66, 0x20, 0x6A, 0x04, 0x05, 0xA0, 0x50, 0x4A, 0x81, 0x60,
  0x6A, 0x04, 0x05, 0xA0, 0x50, 0x4A, 0x8A, 0x56, 0x01, 0x44, 0x11, 0x44, 0x11, 0x44, 0x10, 0x25,
  0x51, 0x25, 0x52, 0x28, 0x25, 0x80, 0x6A, 0x04, 0x05, 0xA8, 0x55, 0x02, 0x5F, 0x26, 0xA8, 0xA0,
  0x45, 0xFB, 0x05, 0xF5, 0x20, 0x25, 0x51, 0x25, 0x05, 0xA0, 0x52, 0x82, 0x14, 0x41, 0x20, 0x5A,
  0x05, 0x30, 0x6A, 0x81, 0x40, 0x5A, 0x05, 0x40, 0x6A, 0x83, 0x40, 0xDF, 0x55, 0x85, 0x26, 0x61,
  0x05, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_app_registration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_app_registration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_business 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_outlined_18_communication_business_data[] PROGMEM = {
  0x05, 0x80, 0x3B, 0x71, 0x85, 0x7F, 0xBD, 0xFB, 0xD9, 0x71, 0x85, 0x7F, 0x07, 0xF0, 0x79, 0x71,
  0x85, 0x7F, 0xBD, 0xFB, 0xD9, 0x80, 0x3B, 0x86, 0x57, 0xFB, 0xDF, 0xBD, 0x98, 0x02, 0xB9, 0x86,
  0x77, 0xF0, 0x7F, 0x07, 0x96, 0x98, 0xC6, 0x77, 0xFB, 0xDF, 0xBD, 0xFB, 0x50, 0xB5, 0x0F, 0x77,
  0xFB, 0xDF, 0xBD, 0xFB, 0x50, 0xB5, 0x0F, 0x77, 0xF0, 0x7F, 0x07, 0x96, 0x98, 0xC6, 0x77, 0xFB,
  0xDF, 0xBD, 0xFB, 0x50, 0xB5, 0x0F, 0x77, 0xFB, 0xDF, 0xBD, 0xFB, 0x50, 0xB5, 0x0F, 0x77, 0xF0,
  0x7F, 0x07, 0x96, 0x98, 0x67, 0x7F, 0xBD, 0xFB, 0xD9, 0x80, 0x2B, 0x90, 0x70, 0x58, 0x09, 0x2B,
  0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_call_end 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_communication_call_end_data[] PROGMEM = {
  0x58, 0x63, 0x79, 0xAA, 0x97, 0x37, 0x10, 0x70, 0xDA, 0x82, 0xDB, 0xBD, 0xA0, 0xD0, 0x74, 0x04,
  0x0D, 0xA0, 0xA0, 0x14, 0x01, 0x0A, 0xA8, 0x7D, 0x40, 0x6F, 0xC3, 0xE8, 0x68, 0x92, 0x8E, 0x3C,
  0xF6, 0xDF, 0x27, 0xF8, 0x68, 0x68, 0xF7, 0x2F, 0xD2, 0xEA, 0x0A, 0x01, 0x60, 0x10, 0xAA, 0x84,
  0xE2, 0x02, 0xC5, 0x73, 0x81, 0x6C, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_call_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 5, 17, 11), Box(0, 0, 17, 17),
      ic_outlined_18_communication_call_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_call_made 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_communication_call_made_data[] PROGMEM = {
  0x30, 0x18, 0x03, 0x30, 0x13, 0x03, 0xF0, 0x33, 0x84, 0x13, 0x33, 0x3B, 0xA0, 0x37, 0x83, 0x8F,
  0xBF, 0x36, 0x84, 0x8F, 0x83, 0xF3, 0x58, 0x58, 0xF8, 0x03, 0xF3, 0x48, 0x18, 0xF8, 0x28, 0x13,
  0xF3, 0x38, 0x18, 0xF8, 0x38, 0x13, 0xF3, 0x28, 0x18, 0xF8, 0x48, 0x51, 0x31, 0x08, 0xF8, 0x71,
  0x81, 0x8F, 0x87, 0x20, 0x60, 0x87, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_call_made() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_call_made_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_call_merge 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_outlined_18_communication_call_merge_data[] PROGMEM = {
  0x40, 0x01, 0x78, 0x21, 0xCC, 0x15, 0x01, 0x0C, 0xA0, 0xC0, 0x13, 0x01, 0x0C, 0xC0, 0xC0, 0x15,
  0x00, 0xB7, 0x10, 0x0B, 0x71, 0x00, 0xB7, 0x10, 0x0B, 0x78, 0x12, 0xEB, 0x68, 0x42, 0xDD, 0x20,
  0x13, 0x89, 0x32, 0xDD, 0x20, 0x7D, 0x20, 0x2D, 0xD2, 0x28, 0x52, 0xDD, 0x27, 0xD2, 0x48, 0x32,
  0xD7, 0x01, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_call_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_call_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_call_missed_outgoing 18x18, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_outlined_18_communication_call_missed_outgoing_data[] PROGMEM = {
  0x01, 0x07, 0x50, 0x28, 0x01, 0xB8, 0x28, 0x7F, 0x84, 0x02, 0x0F, 0xBA, 0x83, 0xB0, 0x8F, 0x86,
  0x08, 0xA0, 0xB2, 0x81, 0x8F, 0x84, 0x83, 0x8F, 0x8B, 0xB3, 0x81, 0x8F, 0x82, 0x84, 0x8F, 0x80,
  0xBB, 0x48, 0x48, 0xF8, 0x8F, 0x82, 0x00, 0xB5, 0x08, 0xA0, 0x83, 0x00, 0x26, 0x00, 0x86,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_call_missed_outgoing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_outlined_18_communication_call_missed_outgoing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_call_missed 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_outlined_18_communication_call_missed_data[] PROGMEM = {
  0x08, 0x80, 0x1B, 0x02, 0x58, 0x17, 0x1B, 0xA0, 0xFB, 0x02, 0x48, 0x28, 0xF7, 0xBA, 0x08, 0x68,
  0x78, 0xF8, 0x0B, 0xB8, 0xF8, 0x48, 0x18, 0xF8, 0x28, 0x4B, 0xB0, 0x8F, 0x82, 0x81, 0x8F, 0x83,
  0x00, 0xB2, 0x84, 0x8F, 0x88, 0xF8, 0x40, 0x02, 0x30, 0x8A, 0x08, 0x74, 0x00, 0x86,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_call_missed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_outlined_18_communication_call_missed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_call 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_communication_call_data[] PROGMEM = {
  0x83, 0x6B, 0xBB, 0x27, 0x28, 0x3A, 0xEB, 0xF6, 0x72, 0x83, 0x9D, 0x0E, 0x87, 0x28, 0x37, 0xF0,
  0xDB, 0x72, 0x83, 0x3F, 0xCF, 0x77, 0x38, 0x1D, 0xF8, 0x74, 0x81, 0x7F, 0x37, 0x50, 0xD0, 0xC7,
  0x58, 0x14, 0xFA, 0x75, 0x81, 0x6F, 0xA3, 0x83, 0x7B, 0x86, 0x24, 0x89, 0x06, 0xFC, 0x38, 0xFD,
  0xEF, 0xB5, 0x04, 0x0D, 0xA0, 0xC2, 0x0C, 0x0B, 0x70, 0x70, 0xDA, 0x81, 0xDE, 0xB7, 0x28, 0x33,
  0x79, 0xA6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_call_received 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_communication_call_received_data[] PROGMEM = {
  0x73, 0x08, 0x06, 0x72, 0x81, 0x8F, 0x87, 0x18, 0x58, 0xF8, 0x01, 0x31, 0x48, 0x18, 0xF8, 0x28,
  0x13, 0xF3, 0x38, 0x18, 0xF8, 0x38, 0x13, 0xF3, 0x28, 0x18, 0xF8, 0x48, 0x53, 0xF3, 0x08, 0xF8,
  0x58, 0x43, 0xF3, 0x8F, 0x86, 0x83, 0x3F, 0xBF, 0x87, 0x03, 0xA8, 0x4B, 0x33, 0x33, 0x13, 0x03,
  0xF0, 0x33, 0x01, 0x80, 0x33, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_call_received() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_call_received_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_call_split 18x18, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_outlined_18_communication_call_split_data[] PROGMEM = {
  0xB0, 0xD0, 0x12, 0x01, 0x0D, 0xD0, 0xE0, 0x14, 0x01, 0x0E, 0xB8, 0x1E, 0xF8, 0x48, 0x78, 0xFE,
  0xFD, 0x18, 0xF8, 0x28, 0x48, 0xF8, 0x1D, 0x12, 0x84, 0x8F, 0x80, 0x58, 0x20, 0x14, 0x81, 0x8F,
  0x77, 0x30, 0xC0, 0xB7, 0x30, 0x0B, 0x73, 0x00, 0xB7, 0x30, 0x0B, 0x73, 0x00, 0xB7, 0x30, 0x0B,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_call_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_call_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_cancel_presentation 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_outlined_18_communication_cancel_presentation_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x30, 0x70, 0x92, 0x09, 0x07, 0x38, 0x43, 0xF3,
  0x3F, 0x33, 0x84, 0x8F, 0x99, 0xF8, 0x38, 0x43, 0xF3, 0x3F, 0x34, 0x08, 0xA0, 0x84, 0x84, 0x3F,
  0x33, 0xF3, 0x40, 0x9A, 0x09, 0x48, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x9F, 0x88, 0xF9, 0x38, 0x43,
  0xF3, 0x3F, 0x33, 0x06, 0x07, 0x20, 0x70, 0x63, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33,
  0xF3, 0x75, 0x84, 0x3F, 0x32, 0xFC, 0x80, 0x90, 0xB8, 0x3C, 0xF2, 0x07, 0x80, 0x92, 0xB0, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_cancel_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_cancel_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_cell_tower 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_18_communication_cell_tower_data[] PROGMEM = {
  0x20, 0x60, 0x47, 0x10, 0x40, 0x63, 0x81, 0x2F, 0x77, 0x18, 0x17, 0xF2, 0x28, 0x3A, 0xC0, 0x74,
  0x48, 0x34, 0x70, 0xCA, 0x28, 0xA4, 0xE6, 0x1F, 0x70, 0x77, 0x07, 0xF1, 0x6E, 0x02, 0xF3, 0x5F,
  0x09, 0xA8, 0x94, 0x90, 0xF5, 0x3F, 0x22, 0xF2, 0x6E, 0x0B, 0xA8, 0x94, 0xB0, 0xE6, 0x2F, 0x20,
  0xF5, 0x3F, 0x34, 0xA8, 0x34, 0x3F, 0x35, 0x92, 0x89, 0x4C, 0xA0, 0xC8, 0x6E, 0xF4, 0x8C, 0x0A,
  0xC2, 0x89, 0x45, 0xF3, 0x10, 0xB9, 0xB9, 0x01, 0x3F, 0x53, 0x86, 0xB9, 0x01, 0xF4, 0x7D, 0x20,
  0x90, 0xB7, 0x84, 0x6E, 0x03, 0xF2, 0x73, 0x84, 0xBD, 0x77, 0xF6, 0x72, 0x85, 0x1F, 0xDD, 0xDE,
  0xA7, 0x20, 0x50, 0xE3, 0x06, 0x0E, 0x72, 0x02, 0x03, 0x40, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_cell_tower() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_cell_tower_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_cell_wifi 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_outlined_18_communication_cell_wifi_data[] PROGMEM = {
  0x48, 0x12, 0x33, 0x71, 0x81, 0x19, 0xEB, 0x81, 0xE9, 0x14, 0x89, 0x13, 0xED, 0x72, 0x12, 0x6D,
  0xE4, 0x38, 0x94, 0x39, 0x01, 0x69, 0x72, 0x09, 0x40, 0x11, 0x28, 0x55, 0xEE, 0xCE, 0xF6, 0x28,
  0x11, 0xC3, 0x20, 0x20, 0x83, 0x85, 0x72, 0x01, 0xCF, 0x34, 0x81, 0x5D, 0x72, 0x83, 0x1C, 0xEF,
  0x34, 0x89, 0x01, 0xA1, 0x01, 0xCD, 0x4F, 0x37, 0x85, 0x1C, 0xF7, 0x2F, 0x36, 0x01, 0x0C, 0xA8,
  0x27, 0x2F, 0x35, 0x01, 0x0C, 0xB8, 0x27, 0x2F, 0x34, 0x01, 0x0C, 0xC8, 0x27, 0x2F, 0x33, 0x01,
  0x0C, 0xD8, 0x28, 0x3F, 0x32, 0x01, 0x0C, 0xFA, 0x03, 0x20, 0x28, 0x06, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_cell_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_cell_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_chat_bubble_outline 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_outlined_18_communication_chat_bubble_outline_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x07, 0x81, 0x50, 0x5F, 0xF0, 0x50, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00,
  0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75,
  0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x98, 0x37, 0x7F, 0x1D, 0xFC, 0x83, 0x57, 0xFD, 0x98,
  0x06, 0x78, 0x35, 0x07, 0xF7, 0x76, 0x00, 0x77, 0x70, 0x17, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_chat_bubble_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_chat_bubble_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_chat_bubble 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_outlined_18_communication_chat_bubble_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x07, 0x81, 0x50, 0x5F, 0xF0, 0x50, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0,
  0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x7F, 0xF0, 0x07,
  0xFF, 0x05, 0x07, 0xA0, 0x98, 0x06, 0x78, 0x35, 0x07, 0xF7, 0x76, 0x00, 0x77, 0x70, 0x17, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_chat_bubble() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_chat_bubble_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_chat 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_outlined_18_communication_chat_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x07, 0x81, 0x50, 0x5F, 0xF0, 0x50, 0x79, 0x75, 0x98, 0x37, 0x7F, 0x03, 0x80,
  0x47, 0x86, 0x30, 0xF7, 0x7F, 0x07, 0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x01, 0x80, 0x43, 0x86, 0x10,
  0xF7, 0x7F, 0x07, 0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x01, 0x80, 0x43, 0x86, 0x10, 0xF7, 0x7F, 0x07,
  0xD0, 0x74, 0x98, 0x37, 0x7F, 0x03, 0x80, 0x17, 0x03, 0x49, 0x00, 0x79, 0x75, 0x98, 0x27, 0x7F,
  0x9F, 0xD0, 0x50, 0x7A, 0x09, 0x80, 0x67, 0x83, 0x50, 0x7F, 0x77, 0x60, 0x07, 0x77, 0x01, 0x77,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_clear_all 18x18, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_outlined_18_communication_clear_all_data[] PROGMEM = {
  0x30, 0x88, 0x05, 0xB0, 0x83, 0x08, 0x80, 0x5B, 0x08, 0x77, 0x10, 0x28, 0x06, 0xB0, 0x22, 0x02,
  0x80, 0x6B, 0x02, 0x77, 0x10, 0x88, 0x05, 0xB0, 0x83, 0x08, 0x80, 0x5B, 0x08, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_clear_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 15, 12), Box(0, 0, 17, 17),
      ic_outlined_18_communication_clear_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_comment 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_outlined_18_communication_comment_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x07, 0x81, 0x50, 0x5F, 0xF0, 0x50, 0x79, 0x75, 0x98, 0x37, 0x7F, 0x03, 0x80,
  0x47, 0x86, 0x30, 0xF7, 0x7F, 0x07, 0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x01, 0x80, 0x43, 0x86, 0x10,
  0xF7, 0x7F, 0x07, 0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x01, 0x80, 0x43, 0x86, 0x10, 0xF7, 0x7F, 0x07,
  0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x03, 0x80, 0x47, 0x83, 0x30, 0xF7, 0x79, 0x75, 0x90, 0x70, 0x5F,
  0xD8, 0x39, 0xF7, 0x05, 0x80, 0x67, 0x09, 0xA0, 0x77, 0x68, 0x17, 0xF7, 0x77, 0x00, 0x77, 0x71,
  0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_comments_disabled 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_outlined_18_communication_comments_disabled_data[] PROGMEM = {
  0x38, 0x07, 0x32, 0x82, 0x77, 0x09, 0xFB, 0x83, 0xE0, 0x6F, 0x71, 0x80, 0x51, 0x82, 0x3F, 0x33,
  0xA8, 0x17, 0x02, 0x80, 0x27, 0x89, 0x13, 0x2F, 0x33, 0xF8, 0xF7, 0x08, 0x80, 0x1D, 0x89, 0x06,
  0x2F, 0x33, 0xF2, 0x6F, 0x77, 0x85, 0x2F, 0x33, 0xF2, 0x7A, 0x81, 0x70, 0x9B, 0x8A, 0x57, 0x2F,
  0x33, 0xF2, 0x25, 0x7F, 0x70, 0x55, 0x52, 0x2F, 0x33, 0xF2, 0x38, 0x93, 0xBF, 0x70, 0x27, 0x32,
  0xF3, 0x3F, 0x23, 0x89, 0x39, 0xBF, 0x70, 0x85, 0x2F, 0x33, 0xF2, 0x58, 0x16, 0xF7, 0x28, 0x22,
  0xF3, 0x19, 0x80, 0x3D, 0xA8, 0x57, 0x02, 0xF3, 0x04, 0x80, 0x47, 0x84, 0x9F, 0x70, 0x93, 0x74,
  0x81, 0x6F, 0x77, 0x78, 0x16, 0xF7, 0x77, 0x06, 0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_comments_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_comments_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_contact_emergency 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_outlined_18_communication_contact_emergency_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x30, 0x10, 0xCF, 0xFA, 0x81, 0xCF, 0x57, 0x70, 0x5A, 0x05, 0x74, 0x08, 0x20,
  0x5A, 0x05, 0x38, 0x17, 0x94, 0x38, 0x46, 0x6E, 0x66, 0x5A, 0x05, 0x28, 0x39, 0xEB, 0xF3, 0x28,
  0x41, 0xCF, 0xC1, 0x5A, 0x05, 0x28, 0x3D, 0x70, 0xE7, 0x28, 0x46, 0xBE, 0xB6, 0x5A, 0x05, 0x28,
  0x3A, 0xEA, 0xF4, 0x40, 0xC2, 0x05, 0xA0, 0x52, 0x82, 0x19, 0xB6, 0x71, 0x05, 0xA0, 0x53, 0x81,
  0x33, 0x27, 0x10, 0x5A, 0x82, 0x51, 0x9E, 0xB0, 0xD0, 0x56, 0x05, 0xA8, 0x90, 0x7D, 0xD6, 0x21,
  0x39, 0xF9, 0x58, 0x15, 0xFC, 0xFF, 0xA0, 0xC0, 0x18, 0x09, 0x43, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_contact_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_contact_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_contact_mail 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_outlined_18_communication_contact_mail_data[] PROGMEM = {
  0x04, 0x80, 0x94, 0xB8, 0x14, 0xED, 0x80, 0x92, 0xB8, 0x2D, 0xEF, 0x73, 0x81, 0x16, 0x42, 0x85,
  0x37, 0x77, 0x75, 0x7A, 0x07, 0x20, 0x10, 0xEA, 0x87, 0x80, 0x79, 0xEF, 0x9B, 0x7A, 0x07, 0x28,
  0x93, 0x6F, 0x2A, 0xE0, 0x7C, 0x55, 0xAB, 0x7A, 0x07, 0x28, 0x93, 0x4F, 0xAD, 0xC0, 0x7F, 0xED,
  0xFB, 0x7A, 0x07, 0x38, 0x92, 0x8E, 0xC2, 0x01, 0x33, 0x33, 0x27, 0xA0, 0x73, 0x81, 0x13, 0x27,
  0x10, 0x7A, 0x82, 0x70, 0x5C, 0xB8, 0x1E, 0x91, 0x50, 0x7A, 0x89, 0x07, 0x6F, 0xC7, 0x45, 0x9F,
  0xD5, 0x07, 0xA0, 0x70, 0xBF, 0x90, 0x34, 0x07, 0xA0, 0x70, 0x58, 0x04, 0x70, 0x14, 0x82, 0x7F,
  0xED, 0x80, 0x92, 0xB8, 0x1D, 0xE4, 0x80, 0x94, 0xB0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_contact_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_contact_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_contact_phone 18x18, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_outlined_18_communication_contact_phone_data[] PROGMEM = {
  0x04, 0x80, 0x94, 0xB8, 0x14, 0xED, 0x80, 0x92, 0xB8, 0x2D, 0xEF, 0x73, 0x81, 0x16, 0x46, 0x81,
  0x30, 0x7A, 0x07, 0x20, 0x10, 0xEA, 0x08, 0x48, 0x2B, 0xF4, 0x7A, 0x07, 0x28, 0x36, 0xF2, 0xAE,
  0x30, 0x5A, 0x05, 0x07, 0xA0, 0x72, 0x83, 0x4F, 0xAD, 0xC3, 0x83, 0xBA, 0x60, 0x7A, 0x07, 0x38,
  0x28, 0xEC, 0x23, 0x0E, 0x03, 0x20, 0x7A, 0x07, 0x38, 0x11, 0x32, 0x40, 0xE0, 0x32, 0x07, 0xA8,
  0x27, 0x05, 0xCB, 0x87, 0xE9, 0x10, 0xBA, 0x60, 0x7A, 0x89, 0x27, 0x6F, 0xC7, 0x45, 0x9F, 0xD0,
  0x5A, 0x05, 0x07, 0xA0, 0x70, 0xBF, 0x98, 0x43, 0x0B, 0xF4, 0x7A, 0x07, 0x05, 0x80, 0x47, 0x01,
  0x28, 0x43, 0x07, 0xFE, 0xD8, 0x09, 0x2B, 0x81, 0xDE, 0x48, 0x09, 0x4B, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_contact_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_contact_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_contacts 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_outlined_18_communication_contacts_data[] PROGMEM = {
  0x2F, 0xD4, 0x80, 0x90, 0x77, 0x74, 0x02, 0x0D, 0xFD, 0x81, 0xD2, 0x79, 0x80, 0x90, 0x79, 0x00,
  0x79, 0x48, 0x21, 0x99, 0x14, 0x90, 0x07, 0x94, 0x82, 0xBA, 0xAB, 0x49, 0x00, 0x79, 0x48, 0x2C,
  0x77, 0xC4, 0x90, 0x07, 0x94, 0x82, 0x3D, 0xD3, 0x49, 0x00, 0x79, 0x50, 0x03, 0x59, 0x00, 0x79,
  0x38, 0x49, 0xEE, 0xEE, 0x93, 0x90, 0x07, 0x92, 0x86, 0x9E, 0x85, 0x58, 0xE8, 0x29, 0x00, 0x79,
  0x20, 0x88, 0x02, 0xB0, 0x82, 0x90, 0x07, 0x98, 0x09, 0x07, 0x98, 0x17, 0x2D, 0xFD, 0x0D, 0x02,
  0x77, 0x48, 0x09, 0x07, 0x4F, 0xD2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_co_present 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_outlined_18_communication_co_present_data[] PROGMEM = {
  0x10, 0x18, 0x09, 0x23, 0x01, 0x20, 0xDF, 0xF8, 0x3D, 0x01, 0xF3, 0x75, 0x84, 0x3F, 0x11, 0xF3,
  0x28, 0x16, 0x83, 0x78, 0x92, 0x3F, 0x11, 0xF3, 0x0C, 0xEC, 0xF6, 0x68, 0x92, 0x3F, 0x11, 0xF3,
  0x4F, 0x20, 0x8D, 0x68, 0x92, 0x3F, 0x11, 0xF3, 0x4F, 0x10, 0x7E, 0x68, 0x92, 0x3F, 0x11, 0xF3,
  0x0D, 0xC9, 0xE8, 0x68, 0x91, 0x3F, 0x11, 0xB2, 0x02, 0x9B, 0x77, 0x81, 0x3F, 0x14, 0x01, 0x0F,
  0x37, 0x81, 0x3F, 0x12, 0x06, 0x0C, 0xD0, 0xA0, 0x34, 0x89, 0x53, 0xF1, 0x0B, 0xFA, 0x42, 0x13,
  0x6C, 0xF5, 0x38, 0x43, 0xF1, 0x1F, 0x68, 0x03, 0x10, 0xB0, 0xA3, 0x82, 0x3D, 0x01, 0xFB, 0x0A,
  0x30, 0x01, 0x28, 0x06, 0x30, 0x26,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_co_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_co_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_desktop_access_disabled 18x18, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_outlined_18_communication_desktop_access_disabled_data[] PROGMEM = {
  0x82, 0x34, 0x02, 0x80, 0x90, 0x78, 0x53, 0x0B, 0xF4, 0x09, 0xFD, 0x01, 0x03, 0xA0, 0x47, 0x48,
  0x63, 0xF3, 0x3F, 0xEF, 0x47, 0x38, 0x73, 0xF3, 0x3F, 0x4B, 0xF4, 0x72, 0x89, 0x03, 0xF3, 0x3F,
  0x30, 0xBF, 0x47, 0x18, 0x43, 0xF3, 0x3F, 0x32, 0x81, 0xBF, 0x47, 0x84, 0x3F, 0x33, 0xF3, 0x38,
  0x1B, 0xF4, 0x68, 0x43, 0xF3, 0x3F, 0x34, 0x81, 0xBF, 0x45, 0x84, 0x3F, 0x33, 0xF3, 0x58, 0x1B,
  0xF4, 0x48, 0x43, 0xF3, 0x3F, 0x36, 0x81, 0xBF, 0x43, 0x82, 0x3F, 0x31, 0xFC, 0x81, 0x40, 0x9A,
  0x81, 0x10, 0x38, 0x01, 0x70, 0xBA, 0x85, 0xBC, 0xF4, 0x06, 0x37, 0x10, 0x7A, 0x83, 0x70, 0xBF,
  0x47, 0x2E, 0x18, 0x1B, 0xF4, 0x71, 0x80, 0x27, 0x28, 0x1B, 0xF4, 0x77, 0x20, 0xB0, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_desktop_access_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_desktop_access_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_dialer_sip 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_18_communication_dialer_sip_data[] PROGMEM = {
  0x83, 0x6B, 0xBB, 0x22, 0x89, 0x2B, 0xB2, 0x85, 0xB8, 0xAE, 0xBF, 0x62, 0x89, 0x2C, 0x31, 0xB7,
  0x6B, 0x9D, 0x0E, 0x82, 0x89, 0x27, 0xB3, 0xB7, 0x95, 0x7F, 0x0D, 0xB2, 0x89, 0x2B, 0xD3, 0xB7,
  0x30, 0x3F, 0xBF, 0x77, 0x38, 0x1D, 0xF8, 0x74, 0x81, 0x7F, 0x37, 0x50, 0xD0, 0xC7, 0x58, 0x14,
  0xFA, 0x75, 0x81, 0x6F, 0xA3, 0x83, 0x7B, 0x86, 0x24, 0x89, 0x06, 0xFC, 0x38, 0xFD, 0xEF, 0xB5,
  0x04, 0x0D, 0xA0, 0xC2, 0x0C, 0x0B, 0x70, 0x70, 0xDA, 0x81, 0xDE, 0xB7, 0x28, 0x33, 0x79, 0xA6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_dialer_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_dialer_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_dialpad 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_outlined_18_communication_dialpad_data[] PROGMEM = {
  0x10, 0x33, 0x00, 0x13, 0x85, 0x30, 0xBF, 0xB0, 0x3A, 0x89, 0x03, 0x0B, 0xFB, 0xEF, 0xE0, 0x6A,
  0x86, 0x60, 0xEF, 0xE4, 0xA4, 0x20, 0x09, 0x28, 0x14, 0xA4, 0x75, 0x81, 0x4A, 0x42, 0x00, 0x92,
  0x86, 0x4A, 0x4E, 0xFE, 0x06, 0xA8, 0x90, 0x60, 0xEF, 0xEB, 0xFB, 0x03, 0xA8, 0x53, 0x0B, 0xFB,
  0x03, 0x30, 0x01, 0x30, 0x32, 0x03, 0x30, 0x01, 0x38, 0x53, 0x0B, 0xFB, 0x03, 0xA8, 0x90, 0x30,
  0xBF, 0xBE, 0xFE, 0x06, 0xA8, 0x66, 0x0E, 0xFE, 0x4A, 0x42, 0x00, 0x92, 0x81, 0x4A, 0x47, 0x73,
  0x00, 0x97, 0x20, 0x6A, 0x06, 0x71, 0x03, 0xA0, 0x37, 0x20, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_dialpad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_dialpad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_document_scanner 18x18, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_outlined_18_communication_document_scanner_data[] PROGMEM = {
  0x10, 0xF1, 0x71, 0x0F, 0x11, 0x03, 0xB0, 0x66, 0x06, 0xB8, 0x43, 0x3F, 0x53, 0x16, 0x89, 0x01,
  0x35, 0xF3, 0x3F, 0x20, 0x48, 0x02, 0x58, 0x74, 0x02, 0xF3, 0x17, 0x15, 0xF9, 0x82, 0x51, 0x71,
  0x30, 0x70, 0xD6, 0x0D, 0x07, 0x68, 0x90, 0x7D, 0x09, 0xBB, 0x90, 0xD7, 0x68, 0x90, 0x7D, 0x07,
  0x99, 0x70, 0xD7, 0x68, 0x90, 0x7D, 0x07, 0x99, 0x70, 0xD7, 0x68, 0x90, 0x7D, 0x07, 0x99, 0x70,
  0xD7, 0x68, 0x90, 0x7D, 0x07, 0x99, 0x70, 0xD7, 0x68, 0x90, 0x7D, 0x09, 0xBB, 0x90, 0xD7, 0x60,
  0x70, 0xD6, 0x0D, 0x07, 0x38, 0x21, 0x71, 0x5F, 0x98, 0x75, 0x17, 0x13, 0xF2, 0x04, 0x80, 0x25,
  0x89, 0x04, 0x02, 0xF3, 0x3F, 0x53, 0x16, 0x84, 0x13, 0x5F, 0x33, 0xB0, 0x66, 0x06, 0xB0, 0x31,
  0x0F, 0x17, 0x10, 0xF1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_document_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_document_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_domain_disabled 18x18, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_outlined_18_communication_domain_disabled_data[] PROGMEM = {
  0x03, 0x04, 0x77, 0x18, 0x3B, 0xF4, 0x05, 0x80, 0x0B, 0x72, 0x85, 0xCF, 0x40, 0x9B, 0xD9, 0x72,
  0x07, 0xA0, 0x42, 0x07, 0x97, 0x20, 0x7B, 0x81, 0x40, 0x79, 0x80, 0x3B, 0x89, 0x05, 0x07, 0xFB,
  0xDF, 0x40, 0x98, 0x02, 0xB9, 0x84, 0x70, 0x7F, 0x07, 0xA0, 0x47, 0x98, 0x47, 0x07, 0xFB, 0xDB,
  0x04, 0x38, 0x95, 0xB5, 0x0F, 0x70, 0x7F, 0xBD, 0xFB, 0xDF, 0x42, 0x89, 0x3B, 0x50, 0xF7, 0x07,
  0xF0, 0x7F, 0x07, 0xA0, 0x44, 0x98, 0x77, 0x07, 0xFB, 0xDF, 0xBD, 0xB0, 0x43, 0x98, 0x94, 0x70,
  0x7F, 0xBD, 0xFB, 0xDF, 0xBD, 0xF4, 0x29, 0x87, 0x70, 0x7F, 0x07, 0xF0, 0x79, 0x28, 0xA0, 0xBF,
  0x40, 0x97, 0x07, 0xFB, 0xDF, 0xBD, 0xFB, 0xBC, 0xA8, 0x34, 0x02, 0x05, 0x80, 0x7B, 0x81, 0xDF,
  0x47, 0x71, 0x81, 0xBF, 0x47, 0x71, 0x0B, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_domain_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_domain_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_domain_verification 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_outlined_18_communication_domain_verification_data[] PROGMEM = {
  0x18, 0x06, 0x51, 0x05, 0xFB, 0x05, 0x06, 0xFB, 0x81, 0x66, 0x98, 0x04, 0x38, 0x29, 0x66, 0x76,
  0x84, 0x10, 0x76, 0x67, 0x58, 0x79, 0x80, 0x76, 0x67, 0x02, 0x20, 0x90, 0xA2, 0x87, 0x76, 0x67,
  0x08, 0xA9, 0xA3, 0x82, 0x76, 0x67, 0x20, 0x80, 0xA4, 0x82, 0x76, 0x67, 0x71, 0x82, 0x76, 0x5B,
  0x80, 0x47, 0x0B, 0x05, 0x18, 0x06, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_domain_verification() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_domain_verification_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_duo 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_18_communication_duo_data[] PROGMEM = {
  0x60, 0x58, 0x03, 0x70, 0x54, 0x01, 0x09, 0xFB, 0x05, 0x20, 0x20, 0xDF, 0xC0, 0x72, 0x0D, 0xFD,
  0x81, 0x70, 0x8F, 0xE8, 0x17, 0x0E, 0xA8, 0x6C, 0xBB, 0xBB, 0xDF, 0xEB, 0x07, 0x04, 0xB0, 0x34,
  0x81, 0x79, 0x4B, 0x07, 0x06, 0xB0, 0x36, 0x03, 0xB0, 0x07, 0xB0, 0x36, 0x03, 0xB0, 0x60, 0x5B,
  0x03, 0x48, 0x17, 0x94, 0xB0, 0x50, 0x1B, 0x86, 0xCB, 0xBB, 0xBD, 0xFE, 0xB2, 0x09, 0xFD, 0x09,
  0x20, 0x10, 0xDF, 0xB0, 0xD0, 0x13, 0x03, 0x0D, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0x9D, 0x0E, 0x08,
  0x72, 0x83, 0x15, 0x76, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_duo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_duo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_email 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_communication_email_data[] PROGMEM = {
  0x02, 0x0D, 0xFD, 0x83, 0xD2, 0x7F, 0xA8, 0x06, 0x78, 0x2A, 0xF7, 0x7A, 0x08, 0x71, 0x08, 0xA8,
  0x57, 0x7F, 0x4D, 0xD4, 0x48, 0x54, 0xDD, 0x4F, 0x77, 0x92, 0x86, 0x8F, 0xA1, 0x1A, 0xF8, 0x29,
  0x00, 0x79, 0x38, 0x43, 0xCE, 0xEC, 0x33, 0x90, 0x07, 0x95, 0x00, 0x65, 0x90, 0x07, 0x97, 0x59,
  0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x80, 0x90, 0x79, 0x81, 0x72, 0xDF, 0xD0,
  0xD0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_forum 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_outlined_18_communication_forum_data[] PROGMEM = {
  0x01, 0x80, 0x67, 0x03, 0x40, 0x7F, 0xB0, 0xB4, 0x07, 0x97, 0x10, 0x0B, 0x40, 0x79, 0x71, 0x85,
  0xBB, 0x05, 0x71, 0x79, 0x71, 0x85, 0xBB, 0x0B, 0xF7, 0x79, 0x71, 0x85, 0xBB, 0x0B, 0xF7, 0x79,
  0x71, 0x87, 0xBB, 0x0B, 0xF7, 0x7F, 0x58, 0x03, 0xB8, 0x5E, 0xB0, 0xBF, 0x77, 0xA0, 0xD8, 0x03,
  0xB8, 0x66, 0x0B, 0xF7, 0x7F, 0xB7, 0x38, 0x5B, 0xF7, 0x7B, 0x05, 0x80, 0x5B, 0x82, 0xEF, 0x73,
  0x20, 0x7F, 0xC0, 0x73, 0x01, 0x80, 0x47, 0x09, 0xA0, 0x77, 0x68, 0x17, 0xF7, 0x77, 0x00, 0x77,
  0x71, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_forum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_forum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_forward_to_inbox 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_outlined_18_communication_forward_to_inbox_data[] PROGMEM = {
  0x10, 0x48, 0x06, 0x58, 0x34, 0x03, 0xE8, 0x80, 0x47, 0x85, 0x8E, 0x34, 0xDD, 0x46, 0x89, 0x04,
  0xDD, 0x44, 0x92, 0xBA, 0x12, 0x86, 0x1A, 0xB2, 0x94, 0x49, 0x28, 0x46, 0xD5, 0x5D, 0x62, 0x82,
  0x94, 0x49, 0x38, 0x21, 0xAA, 0x13, 0x82, 0x94, 0x49, 0x73, 0x82, 0x94, 0x49, 0x73, 0x82, 0x73,
  0x49, 0x72, 0x03, 0x20, 0x40, 0x97, 0x28, 0x37, 0xB0, 0x3C, 0x80, 0x17, 0x87, 0x61, 0x77, 0xBF,
  0xB0, 0x48, 0x02, 0x58, 0x41, 0x55, 0xAF, 0x97, 0x40, 0x70, 0x97, 0x50, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_forward_to_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_forward_to_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_hourglass_bottom 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_outlined_18_communication_hourglass_bottom_data[] PROGMEM = {
  0x02, 0x80, 0x23, 0x89, 0x12, 0x9B, 0x99, 0x99, 0xB9, 0x94, 0x48, 0x24, 0x99, 0x44, 0x83, 0x49,
  0x5C, 0x12, 0x89, 0x01, 0xC5, 0x06, 0xC1, 0x1C, 0x63, 0x82, 0x6C, 0xC6, 0x40, 0x6A, 0x06, 0x30,
  0x6C, 0x81, 0x60, 0x5E, 0x05, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x90, 0x28, 0x02, 0x30, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_hourglass_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 12, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_hourglass_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_hourglass_top 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_outlined_18_communication_hourglass_top_data[] PROGMEM = {
  0x02, 0x80, 0x23, 0x02, 0x09, 0xE0, 0x09, 0xE0, 0x09, 0xE0, 0x90, 0x5E, 0x81, 0x50, 0x6C, 0x06,
  0x30, 0x6A, 0x06, 0x48, 0x26, 0xCC, 0x63, 0x89, 0x06, 0xC1, 0x1C, 0x60, 0x5C, 0x12, 0x83, 0x1C,
  0x59, 0x44, 0x82, 0x49, 0x94, 0x48, 0x91, 0x49, 0x9B, 0x99, 0x99, 0xB9, 0x28, 0x02, 0x30, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_hourglass_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 12, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_hourglass_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_hub 18x18, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_outlined_18_communication_hub_data[] PROGMEM = {
  0x78, 0x25, 0xDD, 0x57, 0x68, 0x41, 0xF9, 0x9F, 0x17, 0x58, 0x43, 0xF3, 0x3F, 0x37, 0x60, 0xCA,
  0x0C, 0x77, 0x10, 0x09, 0x71, 0x82, 0x3D, 0xF9, 0x40, 0x07, 0x48, 0x92, 0x9F, 0xD3, 0xCB, 0x6F,
  0x50, 0x1B, 0xA8, 0xB1, 0xB2, 0x05, 0xF6, 0xBC, 0xE7, 0x1E, 0xB4, 0xDC, 0x44, 0xCD, 0x4B, 0xE1,
  0x7E, 0x8A, 0x83, 0xE6, 0xBF, 0x22, 0x83, 0x2F, 0xB6, 0xEA, 0x85, 0x70, 0x46, 0x10, 0x49, 0x49,
  0x83, 0x40, 0x16, 0x46, 0x81, 0x1F, 0x72, 0x81, 0x7F, 0x17, 0x48, 0x49, 0xFD, 0xDF, 0x97, 0x28,
  0x92, 0x25, 0x5D, 0x48, 0x84, 0xD5, 0x52, 0x50, 0x3B, 0x06, 0x40, 0x6B, 0x03, 0x48, 0x3A, 0xB0,
  0xBA, 0x48, 0x3A, 0xB0, 0xBA, 0x48, 0x39, 0xD5, 0xD9, 0x48, 0x39, 0xD5, 0xD9, 0x48, 0x31, 0xCF,
  0xC1, 0x48, 0x31, 0xCF, 0xC1, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_import_contacts 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_communication_import_contacts_data[] PROGMEM = {
  0x28, 0x44, 0x79, 0x86, 0x32, 0x84, 0x36, 0x89, 0x74, 0x20, 0x20, 0xDE, 0x00, 0xCA, 0x0E, 0x0D,
  0xA8, 0x1D, 0x23, 0xF9, 0x81, 0xB5, 0x13, 0x82, 0x5F, 0x33, 0xF9, 0x68, 0x23, 0xF3, 0x3F, 0x96,
  0x82, 0x3F, 0x33, 0xF9, 0x68, 0x23, 0xF3, 0x3F, 0x96, 0x82, 0x3F, 0x33, 0xF9, 0x68, 0x23, 0xF3,
  0x3F, 0x96, 0x82, 0x3F, 0x33, 0xF9, 0x68, 0x23, 0xF3, 0x3F, 0x92, 0x86, 0x47, 0x75, 0x6F, 0x33,
  0xF9, 0x09, 0xF8, 0x93, 0x32, 0xB6, 0x20, 0x12, 0x6C, 0xD7, 0x32, 0x82, 0x15, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_import_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_import_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_import_export 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_outlined_18_communication_import_export_data[] PROGMEM = {
  0x20, 0x60, 0x17, 0x82, 0x7F, 0xD1, 0x50, 0x7B, 0x0D, 0x01, 0x48, 0x43, 0x3F, 0x93, 0x26, 0x90,
  0x77, 0x19, 0x07, 0x20, 0x30, 0x74, 0x90, 0x72, 0x07, 0x94, 0x90, 0x72, 0x07, 0x94, 0x07, 0x03,
  0x20, 0x79, 0x71, 0x07, 0x96, 0x84, 0x23, 0x9F, 0x33, 0x40, 0x10, 0xDB, 0x07, 0x58, 0x21, 0xDF,
  0x77, 0x01, 0x06, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_import_export() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 13, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_import_export_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_invert_colors_off 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_communication_invert_colors_off_data[] PROGMEM = {
  0x10, 0x25, 0x00, 0xA6, 0x81, 0x1E, 0x73, 0x82, 0xAE, 0xFA, 0x68, 0x56, 0xF7, 0x05, 0xE4, 0xA0,
  0xA6, 0x83, 0x6F, 0x70, 0x21, 0xB0, 0x96, 0x81, 0xAF, 0x72, 0xC0, 0x84, 0x85, 0x1E, 0xBF, 0x70,
  0x9C, 0x02, 0x38, 0x66, 0xE0, 0x6F, 0x70, 0x9B, 0x07, 0x30, 0x80, 0xB2, 0x83, 0x6F, 0x70, 0x9A,
  0x09, 0x30, 0x80, 0xD3, 0x85, 0x6F, 0x70, 0x9F, 0x83, 0x81, 0x4F, 0x23, 0xA8, 0x27, 0x09, 0x44,
  0x0D, 0x0C, 0x3B, 0x07, 0x68, 0x32, 0xED, 0x52, 0xC0, 0x76, 0x02, 0x0A, 0xC8, 0x29, 0x7F, 0x77,
  0x81, 0x13, 0x33, 0x81, 0x6E, 0x27, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_invert_colors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_invert_colors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_key_off 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_outlined_18_communication_key_off_data[] PROGMEM = {
  0x10, 0x27, 0x71, 0x81, 0x1E, 0x77, 0x71, 0x81, 0x6F, 0x77, 0x70, 0x6A, 0x07, 0x75, 0x84, 0x4F,
  0x86, 0xF7, 0x28, 0x03, 0x32, 0x87, 0xCA, 0x07, 0xEF, 0x70, 0x9E, 0x83, 0x70, 0xF5, 0x4C, 0x07,
  0x18, 0x01, 0x18, 0x46, 0xF7, 0xF5, 0x4B, 0x81, 0x7F, 0x72, 0x8B, 0x04, 0x40, 0x8F, 0x7C, 0xA0,
  0x7B, 0x50, 0xDF, 0x70, 0x8F, 0xCF, 0x60, 0x3F, 0x82, 0x89, 0x01, 0xAE, 0x8F, 0x70, 0x5E, 0x53,
  0x89, 0x15, 0xEF, 0xDF, 0xD3, 0x06, 0xF7, 0x78, 0x21, 0x47, 0x54, 0x81, 0x6F, 0x77, 0x71, 0x81,
  0x6F, 0x77, 0x71, 0x81, 0x6E, 0x27, 0x71, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_key 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_outlined_18_communication_key_data[] PROGMEM = {
  0x28, 0x21, 0x47, 0x47, 0x40, 0x50, 0xEB, 0x0D, 0x03, 0x71, 0x03, 0xA8, 0x4E, 0xCE, 0xFE, 0x17,
  0x81, 0xCF, 0xB2, 0x82, 0x1D, 0xFA, 0x80, 0x25, 0x1A, 0x03, 0x30, 0x7F, 0x90, 0x9A, 0x03, 0x30,
  0x7F, 0x98, 0x29, 0xCF, 0xB2, 0x89, 0x21, 0xDF, 0xA8, 0xFC, 0xBF, 0x90, 0x3A, 0x89, 0x1E, 0xCE,
  0xFE, 0x10, 0x61, 0x06, 0x30, 0x50, 0xEB, 0x0D, 0x03, 0x73, 0x82, 0x14, 0x74, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_outlined_18_communication_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_list_alt 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_communication_list_alt_data[] PROGMEM = {
  0x06, 0x80, 0x90, 0xB8, 0x16, 0xBE, 0x80, 0x6B, 0x0E, 0x0F, 0xB7, 0x38, 0x00, 0xB1, 0x8A, 0x48,
  0x80, 0x8B, 0xBB, 0x80, 0xBB, 0xBB, 0x08, 0x80, 0x8B, 0xBB, 0x81, 0x80, 0x0B, 0x73, 0x80, 0x0B,
  0x18, 0xA4, 0x88, 0x08, 0xBB, 0xB8, 0x0B, 0xBB, 0xB0, 0x88, 0x08, 0xBB, 0xB8, 0x18, 0x00, 0xB7,
  0x38, 0x00, 0xB1, 0x8A, 0x48, 0x80, 0x8B, 0xBB, 0x80, 0xBB, 0xBB, 0x08, 0x80, 0x8B, 0xBB, 0x81,
  0x80, 0x0B, 0x73, 0x0F, 0xB0, 0xE8, 0x06, 0xB8, 0x1E, 0xB6, 0x80, 0x90, 0xB0, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_list_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_list_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_live_help 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_18_communication_live_help_data[] PROGMEM = {
  0x10, 0x68, 0x06, 0x78, 0x16, 0x09, 0xFD, 0x81, 0x9B, 0xB4, 0x00, 0x24, 0x80, 0x0B, 0x20, 0x10,
  0xCA, 0x0C, 0x01, 0x28, 0x00, 0xB2, 0x84, 0xAE, 0x66, 0xEA, 0x28, 0x00, 0xB2, 0x0A, 0x06, 0x20,
  0x80, 0xE2, 0x80, 0x0B, 0x60, 0x0C, 0x28, 0x00, 0xB4, 0x82, 0x1C, 0xE2, 0x28, 0x00, 0xB4, 0x81,
  0x8F, 0x23, 0x80, 0x0B, 0x40, 0x50, 0x64, 0x80, 0x0B, 0x40, 0x08, 0x48, 0x00, 0xB4, 0x00, 0x84,
  0x0F, 0xB8, 0x3D, 0x77, 0x74, 0x28, 0x64, 0x77, 0x7D, 0xB4, 0xEC, 0x00, 0x5C, 0x0E, 0x04, 0x50,
  0xBA, 0x0B, 0x74, 0x00, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_live_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_live_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_location_off 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_outlined_18_communication_location_off_data[] PROGMEM = {
  0x68, 0x23, 0x77, 0x35, 0x83, 0x91, 0x02, 0xCC, 0x0C, 0x02, 0x28, 0x93, 0x3E, 0xC1, 0x1B, 0x51,
  0x15, 0xEE, 0x22, 0x82, 0x3E, 0xC1, 0x58, 0x12, 0xEB, 0x38, 0x92, 0x4F, 0xC1, 0x0C, 0xF5, 0x08,
  0xF1, 0x20, 0x3A, 0x87, 0xC1, 0x1D, 0xC0, 0x4F, 0x32, 0x89, 0x22, 0xF9, 0xEC, 0x11, 0x80, 0x5F,
  0x13, 0x84, 0xE9, 0x3E, 0xC1, 0x20, 0x90, 0xE4, 0x89, 0x09, 0xF1, 0x3E, 0xC1, 0x0C, 0x84, 0x89,
  0x02, 0xF8, 0x03, 0xEC, 0x11, 0x25, 0x86, 0x9F, 0x20, 0x3E, 0xC1, 0x68, 0x11, 0xEC, 0x28, 0x2C,
  0xFC, 0x16, 0x87, 0x5F, 0x78, 0xF8, 0xEC, 0x16, 0x09, 0xA8, 0x39, 0x03, 0xEC, 0x70, 0x0C, 0x30,
  0x30, 0x47, 0x00, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_location_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_location_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_location_on 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_outlined_18_communication_location_on_data[] PROGMEM = {
  0x48, 0x23, 0x77, 0x36, 0x02, 0x0C, 0xC0, 0xC0, 0x23, 0x89, 0x02, 0xEE, 0x51, 0x15, 0xEE, 0x22,
  0x81, 0xBE, 0x24, 0x87, 0x2E, 0xB0, 0x1F, 0x80, 0x5A, 0x89, 0x05, 0x08, 0xF1, 0x3F, 0x40, 0xCA,
  0x89, 0x0C, 0x04, 0xF3, 0x2F, 0x50, 0xAA, 0x89, 0x6A, 0x06, 0xF2, 0x0E, 0x90, 0x17, 0x71, 0x09,
  0xE2, 0x81, 0x9F, 0x14, 0x81, 0x1F, 0x92, 0x81, 0x2F, 0x84, 0x81, 0x8F, 0x23, 0x81, 0x9F, 0x22,
  0x81, 0x2F, 0x94, 0x81, 0x1E, 0xC2, 0x81, 0xCE, 0x15, 0x84, 0x5F, 0x87, 0xF5, 0x70, 0x9A, 0x09,
  0x72, 0x00, 0xC7, 0x30, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_location_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_location_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mail_lock 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_communication_mail_lock_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x03, 0x20, 0x1F, 0xF8, 0x41, 0x03, 0xFC, 0x47, 0x18, 0x91, 0x4C, 0xF3,
  0x03, 0xFC, 0xFA, 0x24, 0x89, 0x42, 0xAF, 0xCF, 0x30, 0x3F, 0x24, 0xDF, 0x82, 0x89, 0x18, 0xFD,
  0x41, 0x91, 0x03, 0xF2, 0x28, 0x47, 0xEE, 0xEE, 0x73, 0x84, 0x52, 0x03, 0xF2, 0x38, 0x21, 0x99,
  0x13, 0x85, 0x76, 0xB0, 0x3F, 0x27, 0x38, 0x5A, 0x4A, 0x33, 0xF2, 0x72, 0x07, 0xC8, 0x13, 0xF2,
  0x72, 0x07, 0xC0, 0x1F, 0xB0, 0x20, 0x7C, 0x10, 0x38, 0x05, 0x51, 0x02, 0x80, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mail_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mail_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mail_outline 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_communication_mail_outline_data[] PROGMEM = {
  0x02, 0x0D, 0xFD, 0x83, 0xD2, 0x7F, 0xA8, 0x06, 0x78, 0x2A, 0xF7, 0x7A, 0x08, 0x71, 0x08, 0xA8,
  0x57, 0x7F, 0x4D, 0xD4, 0x48, 0x54, 0xDD, 0x4F, 0x77, 0x92, 0x86, 0x8F, 0xA1, 0x1A, 0xF8, 0x29,
  0x00, 0x79, 0x38, 0x43, 0xCE, 0xEC, 0x33, 0x90, 0x07, 0x95, 0x00, 0x65, 0x90, 0x07, 0x97, 0x59,
  0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x80, 0x90, 0x79, 0x81, 0x72, 0xDF, 0xD0,
  0xD0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mail_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mail_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mail 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_communication_mail_data[] PROGMEM = {
  0x02, 0x0D, 0xFD, 0x83, 0xD2, 0x7F, 0xA8, 0x06, 0x78, 0x2A, 0xF7, 0x7A, 0x08, 0x71, 0x08, 0xA8,
  0x57, 0x7F, 0x4D, 0xD4, 0x48, 0x54, 0xDD, 0x4F, 0x77, 0x92, 0x86, 0x8F, 0xA1, 0x1A, 0xF8, 0x29,
  0x00, 0x79, 0x38, 0x43, 0xCE, 0xEC, 0x33, 0x90, 0x07, 0x95, 0x00, 0x65, 0x90, 0x07, 0x97, 0x59,
  0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x80, 0x90, 0x79, 0x81, 0x72, 0xDF, 0xD0,
  0xD0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mark_chat_read 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_outlined_18_communication_mark_chat_read_data[] PROGMEM = {
  0x18, 0x09, 0x03, 0x10, 0x30, 0xD8, 0x06, 0x98, 0x2D, 0x34, 0x97, 0x38, 0x29, 0x44, 0x97, 0x38,
  0x29, 0x44, 0x97, 0x38, 0x29, 0x44, 0x97, 0x38, 0x21, 0x14, 0x97, 0x50, 0x40, 0x97, 0x38, 0x21,
  0xA4, 0x97, 0x28, 0x31, 0xC6, 0x4A, 0x80, 0x13, 0x18, 0x54, 0x91, 0xC6, 0x04, 0xA0, 0xA0, 0xF9,
  0x28, 0x19, 0xE6, 0x28, 0x14, 0xF7, 0x70, 0x33, 0x04, 0x07, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mark_chat_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mark_chat_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mark_chat_unread 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_outlined_18_communication_mark_chat_unread_data[] PROGMEM = {
  0x74, 0x02, 0x38, 0x04, 0x31, 0x84, 0xCF, 0xC0, 0x3D, 0x80, 0x29, 0x08, 0x03, 0xB8, 0x13, 0x49,
  0x78, 0x51, 0xEF, 0xE1, 0x49, 0x71, 0x84, 0x15, 0x21, 0x49, 0x73, 0x82, 0x94, 0x49, 0x73, 0x82,
  0x94, 0x49, 0x73, 0x82, 0x94, 0x49, 0x73, 0x82, 0x94, 0x49, 0x73, 0x82, 0x94, 0x4A, 0x80, 0x63,
  0x81, 0xA4, 0x4A, 0x0A, 0x80, 0x49, 0x83, 0x80, 0x4F, 0x77, 0x40, 0x40, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mark_chat_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mark_chat_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mark_email_read 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_communication_mark_email_read_data[] PROGMEM = {
  0x10, 0x48, 0x06, 0x58, 0x34, 0x03, 0xE8, 0x80, 0x47, 0x85, 0x8E, 0x34, 0xDD, 0x46, 0x89, 0x04,
  0xDD, 0x44, 0x92, 0xBA, 0x12, 0x86, 0x1A, 0xB2, 0x94, 0x49, 0x28, 0x46, 0xD5, 0x5D, 0x62, 0x82,
  0x94, 0x49, 0x38, 0x21, 0xAA, 0x13, 0x82, 0x94, 0x49, 0x75, 0x04, 0x09, 0x75, 0x04, 0x09, 0x73,
  0x82, 0x2C, 0x49, 0x72, 0x83, 0x2D, 0x33, 0xC8, 0x01, 0x71, 0x83, 0x4C, 0x3D, 0x32, 0x04, 0x80,
  0x15, 0x28, 0x16, 0xE3, 0x75, 0x01, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mark_email_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mark_email_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mark_email_unread 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_communication_mark_email_unread_data[] PROGMEM = {
  0x74, 0x03, 0x30, 0x48, 0x03, 0x51, 0x85, 0xDF, 0xD0, 0x3E, 0x88, 0x01, 0x70, 0x60, 0x3B, 0x83,
  0x34, 0xDD, 0x46, 0x89, 0x0D, 0xFD, 0x04, 0x92, 0xBA, 0x12, 0x86, 0x17, 0x13, 0x21, 0x49, 0x28,
  0x46, 0xD5, 0x5D, 0x62, 0x82, 0x94, 0x49, 0x38, 0x21, 0xAA, 0x13, 0x82, 0x94, 0x49, 0x73, 0x82,
  0x94, 0x49, 0x73, 0x82, 0x94, 0x49, 0x73, 0x82, 0x94, 0x49, 0x73, 0x82, 0x94, 0x3C, 0x80, 0x67,
  0x82, 0xC3, 0x04, 0x80, 0x65, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mark_email_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mark_email_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mark_unread_chat_alt 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_outlined_18_communication_mark_unread_chat_alt_data[] PROGMEM = {
  0x74, 0x82, 0x3A, 0xA2, 0x38, 0x03, 0x38, 0x11, 0x1E, 0xA0, 0xD2, 0x0E, 0xF0, 0x50, 0x3C, 0x82,
  0x23, 0xF3, 0x80, 0x21, 0x10, 0x10, 0xEA, 0x84, 0xD0, 0x3F, 0x23, 0x80, 0x27, 0x89, 0x01, 0x29,
  0x92, 0x03, 0xF2, 0x68, 0x02, 0xD0, 0xB0, 0x22, 0x83, 0x42, 0x3F, 0x27, 0x38, 0x52, 0xF3, 0x3F,
  0x27, 0xF9, 0x86, 0x72, 0xF3, 0x3F, 0x22, 0x80, 0x45, 0x86, 0x22, 0xF3, 0x3F, 0x24, 0x80, 0x18,
  0x06, 0x38, 0x52, 0xF3, 0x3F, 0x26, 0x80, 0x1C, 0x09, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22,
  0xF3, 0x39, 0x80, 0x90, 0xD9, 0x01, 0x03, 0xA0, 0x98, 0x06, 0x78, 0x34, 0x03, 0xF7, 0x76, 0x03,
  0x07, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mark_unread_chat_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mark_unread_chat_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_message 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_outlined_18_communication_message_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x07, 0x81, 0x50, 0x5F, 0xF0, 0x50, 0x79, 0x75, 0x98, 0x37, 0x7F, 0x03, 0x80,
  0x47, 0x86, 0x30, 0xF7, 0x7F, 0x07, 0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x01, 0x80, 0x43, 0x86, 0x10,
  0xF7, 0x7F, 0x07, 0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x01, 0x80, 0x43, 0x86, 0x10, 0xF7, 0x7F, 0x07,
  0xF9, 0x86, 0x70, 0xF7, 0x7F, 0x03, 0x80, 0x47, 0x83, 0x30, 0xF7, 0x79, 0x75, 0x98, 0x27, 0x7F,
  0x9F, 0xD0, 0x50, 0x7A, 0x09, 0x80, 0x67, 0x83, 0x50, 0x7F, 0x77, 0x60, 0x07, 0x77, 0x01, 0x77,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_message() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_message_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_mobile_screen_share 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_communication_mobile_screen_share_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x38, 0x21, 0x01, 0xEF, 0x98, 0x1E, 0x13, 0xFB, 0x82, 0x33, 0xFC, 0x80, 0x2B,
  0x84, 0xCF, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3,
  0x3F, 0x33, 0x8A, 0x56, 0x60, 0x3F, 0x33, 0xF3, 0x01, 0x9E, 0xF7, 0x3F, 0x33, 0xF3, 0x1E, 0xB8,
  0xA2, 0x73, 0xF3, 0x3F, 0x38, 0x50, 0x66, 0x03, 0xF3, 0x3F, 0x31, 0x58, 0x43, 0xF3, 0x3F, 0x36,
  0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0xC8, 0x02, 0xB8, 0x2C, 0xF3, 0x3F, 0xB8, 0x13,
  0x0D, 0xF9, 0x0D, 0x01, 0x28, 0x04, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_mobile_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_mobile_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_more_time 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_outlined_18_communication_more_time_data[] PROGMEM = {
  0x73, 0x00, 0x26, 0x82, 0x36, 0x63, 0x20, 0x60, 0x74, 0x89, 0x62, 0xCB, 0x86, 0x81, 0x9B, 0xC9,
  0x20, 0x2D, 0x55, 0x86, 0x38, 0x93, 0x10, 0xA6, 0x20, 0x40, 0x63, 0x06, 0x07, 0x20, 0x10, 0xD3,
  0x05, 0x08, 0x40, 0x12, 0x04, 0x0A, 0x30, 0x50, 0x83, 0x06, 0x07, 0x20, 0x30, 0xB3, 0x81, 0x5B,
  0x12, 0x08, 0x06, 0x30, 0xD4, 0x84, 0x5D, 0x60, 0xB3, 0x30, 0x90, 0x85, 0x81, 0x45, 0xC5, 0x0C,
  0x08, 0x48, 0x16, 0xD2, 0x68, 0x59, 0xDB, 0xAD, 0xA2, 0x72, 0x81, 0x33, 0x16,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_more_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_more_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_nat 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_outlined_18_communication_nat_data[] PROGMEM = {
  0x30, 0x10, 0x37, 0x68, 0x24, 0xBD, 0x77, 0x78, 0x18, 0xC1, 0x76, 0x06, 0x0A, 0x77, 0x0B, 0x03,
  0x68, 0x15, 0xB7, 0x40, 0x50, 0x92, 0x8C, 0x34, 0x20, 0x1D, 0x3B, 0x97, 0x77, 0x2D, 0x77, 0xBF,
  0x71, 0xD3, 0xB9, 0x77, 0x72, 0xD7, 0x7B, 0xF7, 0x05, 0xB7, 0x40, 0x50, 0x92, 0x04, 0x02, 0x72,
  0x0B, 0x03, 0x75, 0x06, 0x0A, 0x75, 0x81, 0x8C, 0x17, 0x28, 0x24, 0xBD, 0x77, 0x40, 0x10, 0x37,
  0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_nat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_nat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_no_sim 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_outlined_18_communication_no_sim_data[] PROGMEM = {
  0x50, 0x98, 0x01, 0xB0, 0x72, 0x0C, 0x08, 0x28, 0x96, 0xAF, 0xBB, 0xBB, 0xCF, 0x20, 0x8F, 0x80,
  0x55, 0x48, 0x13, 0xF3, 0x28, 0x19, 0xF8, 0x68, 0x13, 0xF3, 0x20, 0x3A, 0x08, 0x58, 0x13, 0xF3,
  0x28, 0x33, 0xFB, 0xF8, 0x48, 0x13, 0xF3, 0x28, 0x43, 0xF3, 0x8F, 0x83, 0x81, 0x3F, 0x32, 0x85,
  0x3F, 0x30, 0x8F, 0x82, 0x81, 0x3F, 0x32, 0x81, 0x3F, 0x32, 0x85, 0x8F, 0x80, 0x2F, 0x32, 0x81,
  0x3F, 0x33, 0x84, 0x8F, 0x80, 0x53, 0x28, 0x13, 0xF3, 0x48, 0x18, 0xF8, 0x48, 0x13, 0xF3, 0x58,
  0x18, 0xF8, 0x38, 0x12, 0xFC, 0x80, 0x2B, 0xA0, 0x83, 0x07, 0x80, 0x5B, 0x90, 0x87, 0x50, 0x80,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_pause_presentation 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_outlined_18_communication_pause_presentation_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x3F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x33, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F, 0x33,
  0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84,
  0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F,
  0x33, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x32, 0xFC, 0x80, 0x90, 0xB8, 0x3C, 0xF2, 0x07, 0x80, 0x92,
  0xB0, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_pause_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_pause_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_person_add_disabled 18x18, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_outlined_18_communication_person_add_disabled_data[] PROGMEM = {
  0x03, 0x04, 0x77, 0x28, 0x1B, 0xF4, 0x77, 0x28, 0x1C, 0xF4, 0x58, 0x35, 0xDE, 0xA1, 0x68, 0x1C,
  0xF4, 0x38, 0x44, 0xFB, 0x8E, 0xC7, 0xA0, 0x42, 0x0A, 0x0D, 0x28, 0x16, 0xF2, 0x6B, 0x87, 0x40,
  0x8F, 0x80, 0x5F, 0x23, 0x83, 0x17, 0x7F, 0xCA, 0x85, 0x40, 0x9F, 0xAE, 0xC4, 0x03, 0xF8, 0x44,
  0x09, 0xEA, 0x17, 0x90, 0x72, 0x81, 0xCF, 0x47, 0x49, 0x07, 0x38, 0x4C, 0xF4, 0x01, 0x27, 0x83,
  0x31, 0x03, 0xBB, 0x83, 0x40, 0x9D, 0x77, 0x89, 0x24, 0xFD, 0x73, 0xCF, 0x40, 0x9F, 0xB6, 0x84,
  0xBE, 0x87, 0x78, 0xA8, 0x34, 0x09, 0xF3, 0x50, 0xBF, 0x98, 0x24, 0x09, 0x37, 0x68, 0x1C, 0xF4,
  0x77, 0x28, 0x1C, 0xF4, 0x77, 0x20, 0xB0, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_person_add_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_person_add_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_person_search 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_outlined_18_communication_person_search_data[] PROGMEM = {
  0x48, 0x15, 0x61, 0x71, 0x82, 0xA9, 0x7C, 0x70, 0x10, 0xC2, 0x09, 0x04, 0x78, 0x3D, 0x10, 0xC2,
  0x78, 0x24, 0xDD, 0x67, 0x20, 0x01, 0x78, 0x74, 0xBD, 0xB7, 0x3D, 0xDA, 0x28, 0x13, 0xC3, 0x38,
  0x93, 0xD2, 0x09, 0x50, 0x6A, 0x55, 0x51, 0xD2, 0x89, 0x47, 0x60, 0x37, 0x77, 0x72, 0x7C, 0x8E,
  0x57, 0x18, 0x33, 0x53, 0xD3, 0x73, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_person_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_person_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_phone_disabled 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_outlined_18_communication_phone_disabled_data[] PROGMEM = {
  0x04, 0x07, 0x71, 0x86, 0x2B, 0xBB, 0x69, 0xF7, 0x78, 0x76, 0xFB, 0xEA, 0x09, 0xF7, 0x68, 0x38,
  0xE0, 0xD9, 0x28, 0x19, 0xF7, 0x58, 0x3B, 0xD0, 0xF7, 0x38, 0x19, 0xF7, 0x48, 0x37, 0xFC, 0xF3,
  0x48, 0x19, 0xF7, 0x48, 0x18, 0xFD, 0x68, 0x19, 0xF7, 0x38, 0x13, 0xF7, 0x78, 0x19, 0xF7, 0x20,
  0xC0, 0xD7, 0x28, 0x49, 0xF7, 0x06, 0x43, 0x83, 0x26, 0x8B, 0x72, 0x81, 0x9F, 0x75, 0x86, 0xBF,
  0xED, 0xF8, 0x3C, 0xA0, 0x74, 0x0B, 0x0C, 0x20, 0xCA, 0x83, 0xD4, 0x9F, 0x73, 0x81, 0xBE, 0xDA,
  0x0D, 0x07, 0x38, 0x19, 0xF7, 0x28, 0x36, 0xB9, 0x73, 0x68, 0x19, 0xF7, 0x76, 0x09, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_phone_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_phone_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_phone_enabled 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_communication_phone_enabled_data[] PROGMEM = {
  0x72, 0x83, 0x2B, 0xBB, 0x67, 0x28, 0x36, 0xFB, 0xEA, 0x72, 0x83, 0x8E, 0x0D, 0x97, 0x28, 0x3B,
  0xD0, 0xF7, 0x72, 0x83, 0x7F, 0xCF, 0x37, 0x38, 0x18, 0xFD, 0x74, 0x81, 0x3F, 0x77, 0x40, 0xC0,
  0xD7, 0x48, 0x1A, 0xF4, 0x28, 0x32, 0x68, 0xB7, 0x38, 0x1A, 0xF6, 0x38, 0x90, 0xBF, 0xED, 0xF8,
  0x3C, 0xF6, 0x40, 0xB0, 0xC2, 0x0C, 0xA0, 0xD0, 0x45, 0x81, 0xBE, 0xDA, 0x0D, 0x07, 0x78, 0x36,
  0xA9, 0x73, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_phone_enabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_phone_enabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_phonelink_erase 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_communication_phonelink_erase_data[] PROGMEM = {
  0x40, 0x28, 0x03, 0x30, 0x24, 0x07, 0xFA, 0x07, 0x30, 0xBF, 0xA0, 0xB3, 0x00, 0xB7, 0x00, 0xB3,
  0x00, 0x57, 0x82, 0xBB, 0x22, 0x40, 0x02, 0x48, 0x3B, 0xB5, 0xE2, 0x28, 0x12, 0xE5, 0x48, 0x7B,
  0xB0, 0x6E, 0x22, 0xE6, 0x50, 0x0B, 0x28, 0x26, 0xEE, 0x66, 0x00, 0xB2, 0x82, 0x2E, 0xE2, 0x68,
  0x7B, 0xB0, 0x2E, 0x66, 0xE2, 0x58, 0x3B, 0xB2, 0xE6, 0x28, 0x16, 0xE2, 0x48, 0x2B, 0xB5, 0x64,
  0x06, 0x05, 0x40, 0x0B, 0x30, 0x05, 0x70, 0x0B, 0x30, 0x0B, 0x70, 0x0B, 0x30, 0xBF, 0xA0, 0xB3,
  0x07, 0xFA, 0x07, 0x40, 0x28, 0x03, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_phonelink_erase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_phonelink_erase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_phonelink_lock 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_outlined_18_communication_phonelink_lock_data[] PROGMEM = {
  0x30, 0x28, 0x03, 0x30, 0x23, 0x07, 0xFA, 0x07, 0x20, 0xBF, 0xA0, 0xB2, 0x00, 0xB7, 0x00, 0xB2,
  0x00, 0x57, 0x85, 0xBB, 0x02, 0xAA, 0x26, 0x85, 0xBB, 0x0D, 0x55, 0xD6, 0x82, 0xBB, 0x1D, 0x20,
  0xD0, 0x15, 0x86, 0xBB, 0x8F, 0xBB, 0xF8, 0x50, 0x0B, 0xE5, 0x00, 0xBE, 0x50, 0x0B, 0xE5, 0x86,
  0xBB, 0x7B, 0xBB, 0xB7, 0x50, 0x0B, 0x20, 0x05, 0x70, 0x0B, 0x20, 0x0B, 0x70, 0x0B, 0x20, 0xBF,
  0xA0, 0xB2, 0x07, 0xFA, 0x07, 0x30, 0x28, 0x03, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_phonelink_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 15, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_phonelink_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_phonelink_ring 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_outlined_18_communication_phonelink_ring_data[] PROGMEM = {
  0x10, 0x18, 0x04, 0x36, 0x03, 0xFA, 0x0B, 0x50, 0x7F, 0xB5, 0x07, 0x97, 0x07, 0x95, 0x07, 0x97,
  0x07, 0x95, 0x07, 0x97, 0x07, 0x95, 0x07, 0x97, 0x07, 0x92, 0x82, 0x7A, 0x07, 0x97, 0x86, 0x7F,
  0x05, 0x1E, 0x27, 0x97, 0x86, 0x7F, 0x1F, 0x1B, 0x57, 0x97, 0x86, 0x7F, 0x1F, 0x1B, 0x57, 0x97,
  0x86, 0x7F, 0x04, 0x2E, 0x27, 0x97, 0x07, 0x92, 0x82, 0x68, 0x07, 0x97, 0x07, 0x95, 0x07, 0x97,
  0x07, 0x95, 0x07, 0x97, 0x07, 0x95, 0x07, 0xFB, 0x50, 0x3F, 0xA0, 0xB6, 0x01, 0x80, 0x43, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_phonelink_ring() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_phonelink_ring_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_phonelink_setup 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_communication_phonelink_setup_data[] PROGMEM = {
  0x40, 0x28, 0x03, 0x30, 0x24, 0x07, 0xFA, 0x07, 0x30, 0xBF, 0xA0, 0xB3, 0x00, 0xB7, 0x00, 0xB3,
  0x00, 0x57, 0x00, 0xB3, 0x00, 0xB7, 0x83, 0xBB, 0x07, 0x7A, 0x07, 0x08, 0x58, 0x1B, 0xB6, 0xA0,
  0x09, 0xA0, 0x64, 0x83, 0xBB, 0x2E, 0x92, 0x81, 0x9E, 0x24, 0x83, 0xBB, 0x2E, 0x92, 0x81, 0x9E,
  0x24, 0x81, 0xBB, 0x6A, 0x00, 0x9A, 0x06, 0x48, 0x3B, 0xB0, 0x87, 0xA0, 0x07, 0x50, 0x0B, 0x30,
  0x0B, 0x70, 0x0B, 0x30, 0x05, 0x70, 0x0B, 0x30, 0x0B, 0x70, 0x0B, 0x30, 0xBF, 0xA0, 0xB3, 0x07,
  0xFA, 0x07, 0x40, 0x28, 0x03, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_phonelink_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_phonelink_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_phone 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_communication_phone_data[] PROGMEM = {
  0x83, 0x6B, 0xBB, 0x27, 0x28, 0x3A, 0xEB, 0xF6, 0x72, 0x83, 0x9D, 0x0E, 0x87, 0x28, 0x37, 0xF0,
  0xDB, 0x72, 0x83, 0x3F, 0xCF, 0x77, 0x38, 0x1D, 0xF8, 0x74, 0x81, 0x7F, 0x37, 0x50, 0xD0, 0xC7,
  0x58, 0x14, 0xFA, 0x75, 0x81, 0x6F, 0xA3, 0x83, 0x7B, 0x86, 0x24, 0x89, 0x06, 0xFC, 0x38, 0xFD,
  0xEF, 0xB5, 0x04, 0x0D, 0xA0, 0xC2, 0x0C, 0x0B, 0x70, 0x70, 0xDA, 0x81, 0xDE, 0xB7, 0x28, 0x33,
  0x79, 0xA6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_portable_wifi_off 18x18, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_outlined_18_communication_portable_wifi_off_data[] PROGMEM = {
  0x68, 0x24, 0x67, 0x56, 0x84, 0x2E, 0x40, 0x4E, 0xD0, 0x90, 0x14, 0x84, 0xBF, 0x40, 0x63, 0x28,
  0x33, 0x8F, 0xD2, 0x30, 0x1A, 0x89, 0x14, 0x01, 0x66, 0x20, 0x2D, 0xD1, 0x28, 0x59, 0xFC, 0xF4,
  0x09, 0xA8, 0xB4, 0x90, 0x2F, 0x90, 0x1F, 0x90, 0xEF, 0x40, 0x17, 0xF9, 0x08, 0xF0, 0x5F, 0x33,
  0xFE, 0xF4, 0x28, 0xB3, 0x7F, 0x23, 0xF5, 0x7F, 0x16, 0xF1, 0xCF, 0x40, 0x1F, 0x60, 0xF6, 0x6F,
  0x16, 0xF1, 0x5A, 0x8B, 0x44, 0x09, 0x60, 0xF6, 0x4F, 0x33, 0xF7, 0x05, 0xCF, 0x40, 0x13, 0xF4,
  0x1E, 0x90, 0xAF, 0x32, 0x84, 0xBF, 0x40, 0x6E, 0x28, 0x39, 0xF3, 0x09, 0x48, 0x3B, 0xF4, 0x04,
  0x38, 0x1D, 0xD3, 0x68, 0x1B, 0xF4, 0x48, 0x12, 0xDC, 0x78, 0x1B, 0xF4, 0x50, 0x27, 0x10, 0xB0,
  0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_portable_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_portable_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_present_to_all 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_communication_present_to_all_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x50, 0x07, 0x58, 0x43, 0xF3, 0x3F, 0x34, 0x07,
  0xA0, 0x74, 0x84, 0x3F, 0x33, 0xF3, 0x30, 0x7C, 0x07, 0x38, 0x43, 0xF3, 0x3F, 0x34, 0x07, 0xA0,
  0x74, 0x84, 0x3F, 0x33, 0xF3, 0x40, 0x7A, 0x07, 0x48, 0x43, 0xF3, 0x3F, 0x34, 0x07, 0xA0, 0x74,
  0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x32, 0xFC, 0x80, 0x90,
  0xB8, 0x3C, 0xF2, 0x07, 0x80, 0x92, 0xB0, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_present_to_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_present_to_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_print_disabled 18x18, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_outlined_18_communication_print_disabled_data[] PROGMEM = {
  0x04, 0x05, 0x77, 0x18, 0x3A, 0xF5, 0x04, 0x80, 0x4B, 0x05, 0x48, 0x3B, 0xF5, 0x08, 0x80, 0x2B,
  0x90, 0x75, 0x81, 0xBF, 0x57, 0x90, 0x76, 0x81, 0xBF, 0x56, 0x90, 0x75, 0x08, 0x0E, 0xA8, 0x15,
  0x07, 0xD0, 0xE0, 0x82, 0x8A, 0x04, 0xFA, 0x7B, 0xF5, 0x05, 0x77, 0x77, 0xAF, 0x40, 0x79, 0x38,
  0x1B, 0xF5, 0x38, 0x95, 0x2F, 0x2F, 0x70, 0x7F, 0x01, 0x34, 0xDF, 0x52, 0x89, 0x03, 0x50, 0xF7,
  0x07, 0xF0, 0x7D, 0x8B, 0x35, 0x07, 0x70, 0xF7, 0x07, 0xFB, 0xDF, 0x33, 0x3B, 0xF5, 0x05, 0xBF,
  0x70, 0x5B, 0xBD, 0x94, 0x85, 0xBF, 0x50, 0x7B, 0x54, 0x07, 0x95, 0x81, 0xBF, 0x57, 0x07, 0x98,
  0x01, 0xB0, 0xCA, 0x05, 0x60, 0x58, 0x04, 0xB8, 0x1D, 0xF5, 0x77, 0x18, 0x1B, 0xF5, 0x77, 0x10,
  0xA0, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_print_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 16, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_print_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_qr_code_2 18x18, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_outlined_18_communication_qr_code_2_data[] PROGMEM = {
  0x83, 0x8B, 0xBB, 0x82, 0x8B, 0x1B, 0x58, 0xBB, 0xB8, 0xB9, 0x79, 0xB1, 0x3B, 0x5B, 0x97, 0x9B,
  0xB6, 0xF6, 0xB7, 0x92, 0x8C, 0x7B, 0x6F, 0x6B, 0xB9, 0x59, 0xB7, 0xFB, 0x5B, 0x95, 0x9B, 0x8B,
  0xBB, 0x85, 0xBB, 0x58, 0xBB, 0xB8, 0x55, 0x05, 0x77, 0x75, 0x28, 0x61, 0x71, 0x0B, 0xB0, 0xBB,
  0x0B, 0x28, 0x13, 0xF3, 0x28, 0x53, 0xF3, 0x3F, 0x33, 0xA8, 0x7B, 0x0B, 0xB0, 0x17, 0x11, 0x80,
  0x17, 0x89, 0x25, 0x0B, 0xB8, 0xBB, 0xB8, 0x0B, 0xB4, 0x0F, 0xB8, 0x79, 0x79, 0xB0, 0xBB, 0x0B,
  0xA8, 0xC1, 0x30, 0xB6, 0xF6, 0xB0, 0xBB, 0x05, 0x9F, 0x30, 0xB9, 0x59, 0xB0, 0x25, 0xB2, 0x3F,
  0xC8, 0x8B, 0xBB, 0x82, 0x85, 0x2B, 0x22, 0xBB, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_qr_code_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_qr_code_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_qr_code 18x18, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_outlined_18_communication_qr_code_data[] PROGMEM = {
  0x02, 0x80, 0x05, 0x28, 0x00, 0x58, 0x92, 0x26, 0xB7, 0x7D, 0x11, 0xD7, 0x7B, 0x0F, 0x62, 0x82,
  0xB1, 0x1B, 0x28, 0x00, 0x62, 0x82, 0xB1, 0x1B, 0x20, 0xF6, 0x89, 0x1D, 0xBB, 0xE1, 0x1E, 0xBB,
  0xD6, 0x18, 0x00, 0x12, 0x80, 0x01, 0x28, 0x00, 0x12, 0x01, 0x48, 0x94, 0x6D, 0xBB, 0xE1, 0x1A,
  0x58, 0x74, 0x66, 0x28, 0x90, 0xB1, 0x05, 0x86, 0x61, 0x66, 0x28, 0xA3, 0xB1, 0x08, 0x67, 0x63,
  0x6B, 0x77, 0xD1, 0x07, 0x66, 0x63, 0x28, 0x00, 0x52, 0x83, 0x41, 0x33, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_qr_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_qr_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_qr_code_scanner 18x18, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_outlined_18_communication_qr_code_scanner_data[] PROGMEM = {
  0x83, 0x37, 0x77, 0x16, 0x84, 0x17, 0x77, 0x37, 0xB0, 0x36, 0x03, 0xB8, 0xC3, 0x77, 0xF1, 0x33,
  0x33, 0x11, 0x33, 0x33, 0x1F, 0x77, 0xF3, 0xFD, 0xDF, 0x33, 0xFD, 0xDF, 0x3F, 0x71, 0x33, 0xD2,
  0x82, 0xD3, 0x3D, 0x28, 0x2D, 0x33, 0x12, 0x03, 0x0D, 0x28, 0x2D, 0x33, 0xD2, 0x0D, 0x03, 0x48,
  0x92, 0x3F, 0xDD, 0xF3, 0x3F, 0xDD, 0xF3, 0x48, 0x92, 0x13, 0x33, 0x31, 0x13, 0x33, 0x31, 0x48,
  0x90, 0x13, 0x33, 0x31, 0x13, 0x03, 0x68, 0x91, 0x3F, 0xDD, 0xF3, 0x3C, 0x1D, 0x35, 0x03, 0x0D,
  0x28, 0x6D, 0x30, 0x1F, 0x0D, 0x32, 0x82, 0x13, 0x3D, 0x28, 0xC0, 0xD3, 0x3D, 0x0F, 0x10, 0x31,
  0x7F, 0x3F, 0xDD, 0xF3, 0x03, 0xD1, 0xC3, 0xF7, 0x7F, 0x13, 0x33, 0x31, 0x28, 0x53, 0x03, 0x1F,
  0x77, 0xB0, 0x36, 0x03, 0xB8, 0x47, 0x37, 0x77, 0x16, 0x83, 0x17, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_qr_code_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_qr_code_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_read_more 18x18, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_outlined_18_communication_read_more_data[] PROGMEM = {
  0x58, 0x13, 0x01, 0x80, 0x1A, 0x03, 0x50, 0xC0, 0x61, 0x80, 0x13, 0x18, 0xB2, 0x27, 0x77, 0x7D,
  0xF6, 0x02, 0x77, 0x72, 0x27, 0x77, 0x7D, 0xF6, 0x02, 0x77, 0x72, 0x50, 0xC0, 0x61, 0x80, 0x13,
  0x68, 0x13, 0x01, 0x80, 0x1A, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_read_more() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 15, 11), Box(0, 0, 17, 17),
      ic_outlined_18_communication_read_more_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_ring_volume 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_outlined_18_communication_ring_volume_data[] PROGMEM = {
  0x71, 0x00, 0x57, 0x72, 0x00, 0xB7, 0x40, 0x14, 0x00, 0xB4, 0x01, 0x58, 0x19, 0xE2, 0x30, 0x0B,
  0x38, 0x12, 0xD9, 0x48, 0x22, 0xDE, 0x22, 0x00, 0x22, 0x82, 0x2D, 0xD2, 0x58, 0x12, 0xD8, 0x68,
  0x18, 0xD2, 0x70, 0x17, 0x10, 0x17, 0x77, 0x58, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x72, 0x60, 0x20,
  0xAA, 0x84, 0xC9, 0x88, 0x9C, 0xA0, 0xA0, 0x23, 0x83, 0x7F, 0xEF, 0x86, 0x89, 0x28, 0xFD, 0xF7,
  0x0A, 0xF9, 0x0E, 0x86, 0x89, 0x28, 0xE0, 0x9F, 0xAB, 0xF5, 0xAF, 0x76, 0x89, 0x17, 0xFB, 0x5F,
  0xB0, 0xCF, 0xE6, 0x71, 0x82, 0x6E, 0xFC, 0x30, 0x80, 0x27, 0x30, 0x20, 0x82,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_ring_volume() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_ring_volume_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_rss_feed 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_communication_rss_feed_data[] PROGMEM = {
  0x82, 0x97, 0x51, 0x71, 0xC0, 0xB0, 0x36, 0x81, 0x79, 0xCB, 0x0A, 0x71, 0x02, 0x09, 0xA0, 0xC0,
  0x13, 0x05, 0x03, 0x38, 0x23, 0xEF, 0xC3, 0xA0, 0xE0, 0x72, 0x82, 0x2E, 0xFA, 0x20, 0xB0, 0xEA,
  0x82, 0xC1, 0x03, 0xA0, 0x33, 0x82, 0x5E, 0xFC, 0x28, 0x19, 0xFB, 0x28, 0x63, 0x02, 0xEF, 0x70,
  0x2A, 0x86, 0x1A, 0xFD, 0x05, 0xFE, 0x28, 0x2C, 0xF5, 0xEA, 0x89, 0x23, 0x0E, 0xF3, 0x09, 0xF8,
  0x7E, 0xA2, 0x85, 0xBF, 0x50, 0x7F, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_rss_feed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_rss_feed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_rtt 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_communication_rtt_data[] PROGMEM = {
  0x68, 0x05, 0x36, 0x0E, 0xF9, 0x28, 0x93, 0x57, 0x73, 0xFC, 0x7D, 0xF7, 0x7F, 0xD2, 0x89, 0x3A,
  0xDD, 0x6F, 0x70, 0xED, 0x01, 0xFA, 0x58, 0xB4, 0x7F, 0x41, 0xFA, 0x04, 0xF7, 0x01, 0xBB, 0x92,
  0x30, 0x4F, 0x80, 0x13, 0x10, 0x17, 0x75, 0x38, 0x17, 0xF5, 0x58, 0x01, 0x12, 0x81, 0x9F, 0x25,
  0x09, 0xC8, 0x21, 0x0C, 0xE6, 0x02, 0x80, 0x03, 0x29, 0x0C, 0x68, 0x00, 0x58, 0x34, 0x02, 0xF9,
  0x50, 0x1C, 0x84, 0x94, 0xAF, 0xB7, 0x73, 0x0A, 0xB0, 0xD7, 0x38, 0x00, 0x30, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_rtt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_rtt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_screen_share 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_outlined_18_communication_screen_share_data[] PROGMEM = {
  0x10, 0x20, 0xDF, 0xD0, 0xD0, 0x22, 0x07, 0x98, 0x09, 0x07, 0x90, 0x72, 0x07, 0x96, 0x00, 0x24,
  0x90, 0x72, 0x07, 0x96, 0x81, 0x4E, 0x23, 0x90, 0x72, 0x07, 0x94, 0x05, 0x0C, 0xA0, 0xE0, 0x32,
  0x90, 0x72, 0x07, 0x93, 0x06, 0xC0, 0xE0, 0x42, 0x90, 0x72, 0x07, 0x92, 0x85, 0x2E, 0x94, 0x6E,
  0x33, 0x90, 0x72, 0x07, 0x92, 0x05, 0x02, 0x20, 0x20, 0x34, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07,
  0x20, 0x5F, 0xF8, 0x35, 0x07, 0x7D, 0xFD, 0x81, 0xD7, 0x7F, 0xFC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_send_time_extension 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_outlined_18_communication_send_time_extension_data[] PROGMEM = {
  0x58, 0x24, 0xEE, 0x47, 0x89, 0x22, 0x33, 0x3C, 0xBB, 0xC3, 0x33, 0x22, 0x02, 0xD0, 0x08, 0xD8,
  0x12, 0x04, 0x97, 0x39, 0x81, 0x40, 0x49, 0x73, 0x98, 0x34, 0x04, 0xF8, 0x72, 0x98, 0x44, 0x01,
  0x6F, 0x67, 0x19, 0x04, 0x30, 0x90, 0xC7, 0x19, 0x04, 0x30, 0x90, 0xC3, 0x81, 0x1A, 0x32, 0x85,
  0xC4, 0x01, 0x6F, 0x63, 0x01, 0xA0, 0xA0, 0x33, 0x81, 0x4F, 0x84, 0x01, 0x0D, 0xB8, 0x2A, 0x30,
  0x49, 0x30, 0x06, 0x20, 0x40, 0xDB, 0x08, 0x04, 0x92, 0x83, 0x8F, 0x50, 0xAB, 0x82, 0xD6, 0x02,
  0xC8, 0x16, 0x01, 0xA0, 0xD0, 0x64, 0x02, 0x0F, 0x32, 0x81, 0x1D, 0x65,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_send_time_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 16, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_send_time_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_sentiment_satisfied_alt 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_outlined_18_communication_sentiment_satisfied_alt_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x28, 0x19, 0xF2, 0x71, 0x89, 0x12, 0xF9, 0x01,
  0xF8, 0x07, 0xE3, 0x28, 0x94, 0x3E, 0x70, 0x8F, 0x05, 0xF3, 0x09, 0xF5, 0x28, 0x65, 0xF9, 0x03,
  0xF5, 0x69, 0x30, 0x34, 0x03, 0x39, 0x00, 0x69, 0x75, 0x98, 0x56, 0x5F, 0x30, 0x54, 0x48, 0xA2,
  0x45, 0x03, 0xF5, 0x1F, 0x80, 0x3E, 0x71, 0x17, 0xE3, 0x08, 0x92, 0x84, 0x9F, 0x20, 0x3C, 0xA8,
  0x4C, 0x30, 0x2F, 0x92, 0x82, 0x1D, 0xD2, 0x68, 0x22, 0xDD, 0x13, 0x83, 0x2D, 0xF8, 0x32, 0x83,
  0x38, 0xFD, 0x25, 0x01, 0x09, 0xE0, 0x90, 0x17, 0x28, 0x25, 0x77, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_sentiment_satisfied_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_sentiment_satisfied_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_sip 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_communication_sip_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0xF4, 0x2F, 0x33, 0xF2, 0x3B, 0xB2, 0x55, 0x2B, 0xB3, 0x2F, 0x33, 0xF2, 0x7B, 0x70, 0x77,
  0x3B, 0x77, 0x2F, 0x33, 0xF2, 0x18, 0xD2, 0x77, 0x3E, 0xD3, 0x2F, 0x33, 0xF2, 0x5B, 0xA0, 0x55,
  0x28, 0x28, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x1F, 0xF8,
  0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_speaker_phone 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_communication_speaker_phone_data[] PROGMEM = {
  0x48, 0x21, 0x33, 0x16, 0x06, 0x0C, 0xC0, 0xC0, 0x62, 0x89, 0x52, 0xDF, 0xB6, 0x44, 0x6B, 0xFD,
  0x26, 0xD4, 0x20, 0x03, 0x28, 0x14, 0xD6, 0x30, 0x90, 0xEA, 0x0E, 0x09, 0x58, 0x67, 0xF9, 0x55,
  0x9F, 0x75, 0x02, 0x40, 0x26, 0x84, 0x47, 0x77, 0x74, 0x6D, 0x0E, 0x60, 0xB4, 0x0B, 0x60, 0xB4,
  0x0B, 0x60, 0xB4, 0x0B, 0x60, 0xB4, 0x0B, 0x60, 0xB4, 0x0B, 0x60, 0xB4, 0x0B, 0x6D, 0x0E, 0x68,
  0x44, 0x77, 0x77, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_speaker_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_speaker_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_spoke 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_communication_spoke_data[] PROGMEM = {
  0x60, 0x03, 0x74, 0x0B, 0xA0, 0xB7, 0x28, 0x47, 0xE3, 0x3E, 0x77, 0x10, 0x0A, 0x20, 0x0A, 0x71,
  0x84, 0x6F, 0x66, 0xF6, 0x72, 0x09, 0xA0, 0x97, 0x77, 0x76, 0x83, 0x4D, 0xFC, 0x22, 0x89, 0x22,
  0xCF, 0xD4, 0x01, 0xEA, 0x4C, 0xC2, 0x89, 0x1C, 0xC4, 0xAE, 0x13, 0xF1, 0x04, 0x92, 0x98, 0x91,
  0x40, 0x1F, 0x31, 0xF7, 0x1A, 0xD2, 0x86, 0xDA, 0x17, 0xF1, 0x06, 0xA0, 0xE0, 0x42, 0x04, 0x0E,
  0xA0, 0x63, 0x01, 0x03, 0x60, 0x30, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_spoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_communication_spoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_stay_current_landscape 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_outlined_18_communication_stay_current_landscape_data[] PROGMEM = {
  0x28, 0x09, 0x23, 0x20, 0x10, 0xEF, 0xF8, 0x1E, 0x13, 0xA0, 0xC8, 0x06, 0x30, 0xCA, 0x00, 0x3A,
  0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03,
  0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00,
  0x3A, 0x0C, 0x80, 0x63, 0x0C, 0xA8, 0x13, 0x1E, 0xFF, 0x0E, 0x01, 0x28, 0x09, 0x23, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_stay_current_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_stay_current_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_stay_current_portrait 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_communication_stay_current_portrait_data[] PROGMEM = {
  0x28, 0x04, 0x32, 0x01, 0x0E, 0xF9, 0x81, 0xE1, 0x3F, 0xB8, 0x23, 0x3F, 0xC8, 0x02, 0xB8, 0x4C,
  0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3,
  0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F,
  0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0xC8,
  0x02, 0xB8, 0x2C, 0xF3, 0x3F, 0xB8, 0x13, 0x1E, 0xF9, 0x0E, 0x01, 0x28, 0x04, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_stay_current_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_stay_current_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_stay_primary_landscape 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_outlined_18_communication_stay_primary_landscape_data[] PROGMEM = {
  0x28, 0x09, 0x23, 0x20, 0x10, 0xEF, 0xF8, 0x1E, 0x13, 0xA0, 0xC8, 0x06, 0x30, 0xCA, 0x00, 0x3A,
  0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03,
  0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00,
  0x3A, 0x0C, 0x80, 0x63, 0x0C, 0xA8, 0x13, 0x1E, 0xFF, 0x0E, 0x01, 0x28, 0x09, 0x23, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_stay_primary_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_stay_primary_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_stay_primary_portrait 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_communication_stay_primary_portrait_data[] PROGMEM = {
  0x28, 0x04, 0x32, 0x01, 0x0E, 0xF9, 0x81, 0xE1, 0x3F, 0xB8, 0x23, 0x3F, 0xC8, 0x02, 0xB8, 0x4C,
  0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3,
  0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F,
  0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0xC8,
  0x02, 0xB8, 0x2C, 0xF3, 0x3F, 0xB8, 0x13, 0x1E, 0xF9, 0x0E, 0x01, 0x28, 0x04, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_stay_primary_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_outlined_18_communication_stay_primary_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_stop_screen_share 18x18, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_outlined_18_communication_stop_screen_share_data[] PROGMEM = {
  0x10, 0x60, 0x37, 0x72, 0x81, 0xCE, 0x37, 0x71, 0x84, 0x3F, 0xE3, 0x0A, 0xF9, 0x0D, 0x02, 0x28,
  0x57, 0xFC, 0xE3, 0x06, 0x80, 0x37, 0x90, 0x72, 0x84, 0x7F, 0x1C, 0xE3, 0x20, 0x02, 0x49, 0x07,
  0x28, 0x91, 0x7F, 0x01, 0xCE, 0x30, 0x3E, 0x23, 0x90, 0x72, 0x07, 0x92, 0x86, 0x1C, 0xE3, 0x0A,
  0xE3, 0x29, 0x07, 0x20, 0x79, 0x38, 0x57, 0xFE, 0x30, 0x94, 0x29, 0x07, 0x20, 0x79, 0x28, 0x42,
  0xE8, 0xCE, 0x34, 0x90, 0x72, 0x07, 0x92, 0x85, 0x51, 0x01, 0xCE, 0x33, 0x90, 0x72, 0x07, 0x96,
  0x82, 0x1C, 0xE3, 0x29, 0x07, 0x20, 0x5F, 0xB8, 0x7E, 0x30, 0x95, 0x07, 0x7D, 0xFB, 0x83, 0xE3,
  0x03, 0x7F, 0xF8, 0x2E, 0x30, 0x97, 0x68, 0x21, 0xCE, 0x37, 0x71, 0x81, 0x1B, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_stop_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_stop_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_swap_calls 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_outlined_18_communication_swap_calls_data[] PROGMEM = {
  0x38, 0x31, 0xAE, 0xD5, 0x38, 0x11, 0xB1, 0x58, 0x92, 0xCE, 0x8B, 0xF4, 0x01, 0xDF, 0xD1, 0x38,
  0x12, 0xF6, 0x28, 0x2D, 0xA1, 0xDB, 0x0D, 0x01, 0x28, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3,
  0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3, 0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3,
  0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3, 0x48, 0x13, 0xF3, 0x20, 0x0B, 0x28, 0x13, 0xF3,
  0x28, 0x71, 0xBC, 0xFC, 0xB1, 0xAC, 0x28, 0x14, 0xF3, 0x30, 0x4B, 0x86, 0x40, 0x6F, 0x84, 0xDD,
  0x58, 0x14, 0xE4, 0x30, 0x9A, 0x0D, 0x03, 0x60, 0x15, 0x01, 0x03, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_swap_calls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_swap_calls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_textsms 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_outlined_18_communication_textsms_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x07, 0x81, 0x50, 0x5F, 0xF0, 0x50, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00,
  0x79, 0x75, 0x90, 0x07, 0x92, 0x86, 0x22, 0x02, 0x20, 0x22, 0x29, 0x00, 0x79, 0x28, 0x6B, 0xB0,
  0xBB, 0x0B, 0xB2, 0x90, 0x07, 0x92, 0x86, 0x22, 0x02, 0x20, 0x22, 0x29, 0x00, 0x79, 0x75, 0x90,
  0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x98, 0x37, 0x7F, 0x1D, 0xFC, 0x83, 0x57, 0xFD, 0x98, 0x06,
  0x78, 0x35, 0x07, 0xF7, 0x76, 0x00, 0x77, 0x70, 0x17, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_textsms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_textsms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_unsubscribe 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_outlined_18_communication_unsubscribe_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x82, 0xA2, 0x0A, 0x98, 0x06, 0xB9, 0x84, 0xA0, 0xBF, 0xD5, 0x68, 0x91,
  0x5D, 0xFB, 0x0B, 0xC9, 0xFD, 0x52, 0x8A, 0x65, 0xDF, 0x9C, 0xB0, 0xBB, 0x02, 0x9F, 0xDD, 0xF9,
  0x20, 0xBB, 0x0B, 0xB3, 0x82, 0x29, 0x92, 0x38, 0x3B, 0xB0, 0xBB, 0x73, 0x83, 0xBB, 0x0B, 0xB7,
  0x28, 0x43, 0xCB, 0x0B, 0xB7, 0x01, 0x0C, 0xA8, 0x2C, 0x0A, 0xE8, 0x03, 0xB0, 0xDC, 0x81, 0x42,
  0xA8, 0x03, 0xB8, 0x4E, 0x83, 0x3B, 0x77, 0x20, 0x6C, 0x03, 0x73, 0x82, 0x8E, 0xD6, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_unsubscribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_unsubscribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_voicemail 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_outlined_18_communication_voicemail_data[] PROGMEM = {
  0x28, 0x22, 0x56, 0x36, 0x82, 0x36, 0x52, 0x30, 0x7C, 0x0A, 0x40, 0xAC, 0x89, 0x07, 0x05, 0xF9,
  0x11, 0x7F, 0x82, 0x89, 0x08, 0xF7, 0x11, 0x9F, 0x5B, 0xC4, 0x08, 0x92, 0x90, 0x84, 0x82, 0xCB,
  0xE8, 0x48, 0x44, 0xF3, 0x3F, 0x44, 0x82, 0x8E, 0xCA, 0x48, 0x47, 0xF1, 0x1F, 0x74, 0x83, 0xAC,
  0x7F, 0x62, 0x81, 0x3E, 0xB2, 0x81, 0xBE, 0x32, 0x86, 0x6F, 0x70, 0xBF, 0xDC, 0xA8, 0x2D, 0xBB,
  0xDA, 0x82, 0xCD, 0xFB, 0x30, 0x50, 0x98, 0x06, 0xB0, 0x90, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_voicemail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 17, 12), Box(0, 0, 17, 17),
      ic_outlined_18_communication_voicemail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_vpn_key_off 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_outlined_18_communication_vpn_key_off_data[] PROGMEM = {
  0x10, 0x27, 0x71, 0x81, 0x1E, 0x77, 0x71, 0x81, 0x6F, 0x77, 0x70, 0x6A, 0x07, 0x75, 0x84, 0x4F,
  0x86, 0xF7, 0x74, 0x87, 0xCA, 0x07, 0xEF, 0x70, 0x58, 0x03, 0xB8, 0x21, 0xF5, 0x4C, 0x89, 0x37,
  0x06, 0x77, 0x77, 0x9F, 0x1F, 0x54, 0xB8, 0xB5, 0x7F, 0x70, 0x27, 0x07, 0x9F, 0x1C, 0xA0, 0x7B,
  0x50, 0xDF, 0x70, 0x91, 0xFC, 0xB1, 0x3F, 0x82, 0x84, 0x1A, 0xE8, 0xF7, 0x29, 0x04, 0x38, 0x94,
  0x5E, 0xFD, 0xFD, 0x30, 0x6F, 0x70, 0x94, 0x48, 0x21, 0x47, 0x54, 0x83, 0x6F, 0x70, 0x17, 0x68,
  0x16, 0xF7, 0x77, 0x18, 0x16, 0xE2, 0x77, 0x10, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_vpn_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_communication_vpn_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_vpn_key 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_outlined_18_communication_vpn_key_data[] PROGMEM = {
  0x48, 0x12, 0x31, 0x76, 0x06, 0x0E, 0xB0, 0xA0, 0x27, 0x38, 0x79, 0xFB, 0x64, 0x7E, 0xE2, 0x71,
  0x89, 0x05, 0xF8, 0x01, 0x30, 0x2D, 0xC8, 0x04, 0x38, 0x2B, 0xD0, 0x5A, 0x81, 0xC0, 0x5F, 0xA8,
  0x6E, 0x90, 0xDC, 0x6F, 0x61, 0x80, 0x33, 0x8A, 0x69, 0xFE, 0x90, 0xDC, 0x6F, 0x60, 0x33, 0x33,
  0x10, 0x39, 0xFB, 0xD0, 0x5A, 0x81, 0xC0, 0x5C, 0x07, 0x1B, 0x8B, 0x25, 0xF8, 0x01, 0x30, 0x2D,
  0xC3, 0x3F, 0x70, 0xF9, 0x30, 0x9F, 0xB6, 0x47, 0xEE, 0x22, 0x98, 0x29, 0x3F, 0x73, 0x06, 0x0E,
  0xB0, 0xA0, 0x23, 0xC0, 0x75, 0x81, 0x23, 0x15, 0x80, 0x03, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_vpn_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_vpn_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_communication_wifi_calling 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_outlined_18_communication_wifi_calling_data[] PROGMEM = {
  0x18, 0x15, 0x54, 0x48, 0x73, 0x54, 0x10, 0x4C, 0x7E, 0x28, 0x96, 0x3D, 0xA8, 0x9D, 0x82, 0xB0,
  0xB2, 0x01, 0xD2, 0x28, 0x5A, 0x60, 0xD0, 0xB4, 0x28, 0x34, 0xC0, 0x7A, 0x28, 0x1A, 0xB9, 0x48,
  0x17, 0xCC, 0x38, 0x14, 0xF1, 0x50, 0x90, 0x24, 0x0B, 0x0A, 0x74, 0x81, 0x2E, 0x73, 0x02, 0x01,
  0x68, 0x73, 0xE9, 0x17, 0xDC, 0xD5, 0x58, 0x22, 0xCE, 0xC2, 0x06, 0x07, 0x78, 0x45, 0xBD, 0x9B,
  0x77, 0x28, 0x21, 0x35, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_communication_wifi_calling() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_communication_wifi_calling_data, Alpha4(color::Black));
  return value;
}
