#include "av.h"

using namespace roo_display;

// Image file ic_outlined_18_av_10k 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_10k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8F, 0x04, 0x4F, 0x6B, 0x38, 0xB9, 0x28, 0x66, 0xF4, 0x4F, 0x1A, 0x4C, 0x3D, 0x3D,
  0xC1, 0xF4, 0x4F, 0x09, 0x4C, 0x3D, 0x3D, 0xC1, 0xF4, 0x4F, 0x07, 0x38, 0xB9, 0x28, 0x66, 0xF4,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_10k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_10k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_1k_plus 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_outlined_18_av_1k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8B, 0x44, 0x4F, 0x07, 0xB2, 0xA3, 0x90, 0x41, 0xF4, 0x4F, 0x01, 0xB3, 0xDD, 0x25,
  0xE8, 0xF4, 0x49, 0x28, 0x91, 0xA3, 0xDD, 0x25, 0xE8, 0xF4, 0x49, 0x28, 0x91, 0x82, 0xA3, 0x90,
  0x41, 0xF4, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12,
  0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_1k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_1k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_1k 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_1k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x00, 0x49, 0x28, 0x48, 0xB1, 0xA4, 0x72, 0x90, 0x04, 0x92, 0x84, 0x1C, 0x1E, 0xD1,
  0x29, 0x00, 0x49, 0x38, 0x3C, 0x1E, 0xD1, 0x29, 0x00, 0x49, 0x38, 0x39, 0x1A, 0x47, 0x29, 0x00,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_1k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_1k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_2k_plus 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_2k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8F, 0x04, 0x4F, 0x1B, 0xB6, 0x55, 0x92, 0x41, 0xF4, 0x4F, 0x08, 0xBA, 0x6D, 0x85,
  0xE8, 0xF4, 0x4F, 0x1E, 0x95, 0x6D, 0x85, 0xE8, 0xF4, 0x4F, 0x1B, 0xB7, 0x55, 0x92, 0x41, 0xF4,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_2k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_2k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_2k 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_outlined_18_av_2k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x89, 0x64, 0x4F, 0x01, 0xBB, 0x56, 0x4A, 0x10, 0xF4, 0x49, 0x28, 0x49, 0xB8, 0x8D,
  0x72, 0x98, 0x91, 0x44, 0xF0, 0x2E, 0x94, 0x8D, 0x72, 0x98, 0x96, 0x44, 0xF0, 0x1B, 0xB6, 0x64,
  0xA1, 0x0F, 0x44, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x04, 0x02, 0xFD, 0x81,
  0x20, 0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_2k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_2k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_3k_plus 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_3k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8F, 0x04, 0x4F, 0x1B, 0xB6, 0x55, 0x92, 0x41, 0xF4, 0x4F, 0x03, 0xBA, 0x6D, 0x85,
  0xE8, 0xF4, 0x4F, 0x03, 0xBA, 0x6D, 0x85, 0xE8, 0xF4, 0x4F, 0x1B, 0xB6, 0x55, 0x92, 0x41, 0xF4,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_3k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_3k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_3k 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_outlined_18_av_3k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x89, 0x64, 0x4F, 0x01, 0xBB, 0x56, 0x4A, 0x10, 0xF4, 0x49, 0x28, 0x43, 0xB8, 0x8D,
  0x72, 0x90, 0x04, 0x92, 0x84, 0x3B, 0x88, 0xD7, 0x29, 0x89, 0x64, 0x4F, 0x01, 0xBB, 0x56, 0x4A,
  0x10, 0xF4, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12,
  0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_3k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_3k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_4k_plus 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_av_4k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8D, 0x24, 0x4F, 0x64, 0x82, 0x74, 0xA1, 0x41, 0xF4, 0x4F, 0x86, 0xA3, 0x9D, 0x65,
  0xE8, 0xF4, 0x4F, 0x7D, 0xE9, 0x9D, 0x65, 0xE8, 0xF4, 0x49, 0x28, 0x91, 0x82, 0x74, 0xA1, 0x41,
  0xF4, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02,
  0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_4k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_4k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_4k 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_av_4k_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x82, 0xA2, 0xAE, 0x80, 0x6B, 0x82, 0xEA, 0xBB, 0x73, 0x80, 0x0B, 0x73,
  0x80, 0x0B, 0x18, 0xD0, 0x30, 0x31, 0x13, 0x02, 0x2B, 0xBB, 0xB1, 0xF0, 0xD3, 0x3D, 0x2E, 0x2B,
  0xBB, 0xB1, 0xF0, 0xD3, 0x3D, 0xC7, 0x0B, 0xBB, 0xB1, 0xC8, 0xA1, 0x3D, 0xC7, 0x0B, 0xBB, 0xB0,
  0x11, 0xD5, 0x3D, 0x2E, 0x28, 0x00, 0xB3, 0x85, 0x31, 0x13, 0x02, 0x28, 0x00, 0xB7, 0x38, 0x00,
  0xB7, 0x38, 0x2B, 0xBA, 0xE8, 0x06, 0xB8, 0x2E, 0xA2, 0xA8, 0x06, 0xB0, 0xA0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_4k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_4k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_5g 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_outlined_18_av_5g_data[] PROGMEM = {
  0x8F, 0x25, 0xBB, 0xB1, 0x7B, 0xBA, 0x27, 0x83, 0x30, 0xE3, 0x33, 0x17, 0xA7, 0x40, 0xD1, 0x77,
  0x33, 0x77, 0xD1, 0xD1, 0x7A, 0x71, 0x33, 0xD1, 0xE3, 0x38, 0x75, 0xBB, 0x80, 0x7B, 0xBA, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_5g() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 13, 11), Box(0, 0, 17, 17),
      ic_outlined_18_av_5g_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_5k_plus 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_5k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8F, 0x04, 0x4F, 0x6B, 0xB2, 0xA3, 0x90, 0x41, 0xF4, 0x4F, 0x8B, 0x91, 0xDD, 0x25,
  0xE8, 0xF4, 0x4F, 0x59, 0xD3, 0xDD, 0x25, 0xE8, 0xF4, 0x4F, 0x6B, 0xB1, 0xA3, 0x90, 0x41, 0xF4,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_5k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_5k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_5k 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_outlined_18_av_5k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8A, 0x74, 0x4F, 0x01, 0xBB, 0x66, 0x4A, 0x10, 0xF4, 0x4F, 0x02, 0xE9, 0x48, 0xD7,
  0x29, 0x89, 0x14, 0x4F, 0x01, 0x9B, 0x88, 0xD7, 0x29, 0x89, 0x64, 0x4F, 0x01, 0xBB, 0x56, 0x4A,
  0x10, 0xF4, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12,
  0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_5k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_5k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_6k_plus 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_6k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8F, 0x04, 0x4F, 0x1B, 0xB7, 0x55, 0x92, 0x41, 0xF4, 0x4F, 0x1E, 0x95, 0x6D, 0x85,
  0xE8, 0xF4, 0x4F, 0x1E, 0xBA, 0x6D, 0x85, 0xE8, 0xF4, 0x4F, 0x1B, 0xB6, 0x55, 0x92, 0x41, 0xF4,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_6k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_6k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_6k 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_outlined_18_av_6k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8A, 0x74, 0x4F, 0x01, 0xBB, 0x66, 0x4A, 0x10, 0xF4, 0x4F, 0x02, 0xE9, 0x48, 0xD7,
  0x29, 0x89, 0x14, 0x4F, 0x02, 0xEB, 0x88, 0xD7, 0x29, 0x89, 0x64, 0x4F, 0x01, 0xBB, 0x56, 0x4A,
  0x10, 0xF4, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12,
  0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_6k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_6k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_7k_plus 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_av_7k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8B, 0x44, 0x4F, 0x2B, 0xB5, 0x73, 0xA0, 0x41, 0xF4, 0x4F, 0x11, 0xA4, 0xAD, 0x55,
  0xE8, 0xF4, 0x49, 0x28, 0xA7, 0xD0, 0xAD, 0x55, 0xE8, 0xF4, 0x4F, 0x02, 0x70, 0x73, 0xA0, 0x41,
  0xF4, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02,
  0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_7k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_7k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_7k 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_av_7k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x89, 0x64, 0x4F, 0x01, 0xBB, 0x66, 0x4A, 0x10, 0xF4, 0x49, 0x28, 0x41, 0x86, 0x8D,
  0x72, 0x90, 0x04, 0x93, 0x83, 0xC1, 0x8D, 0x72, 0x90, 0x04, 0x92, 0x89, 0x11, 0x90, 0x64, 0xA1,
  0x0F, 0x44, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x04, 0x02, 0xFD, 0x81, 0x20,
  0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_7k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_7k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_8k_plus 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_8k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8F, 0x04, 0x4F, 0x1B, 0xB6, 0x55, 0x92, 0x41, 0xF4, 0x4F, 0x1E, 0x8A, 0x6D, 0x85,
  0xE8, 0xF4, 0x4F, 0x1E, 0x8A, 0x6D, 0x85, 0xE8, 0xF4, 0x4F, 0x1B, 0xB6, 0x55, 0x92, 0x41, 0xF4,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_8k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_8k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_8k 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_outlined_18_av_8k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8A, 0x74, 0x4F, 0x01, 0xBB, 0x56, 0x4A, 0x10, 0xF4, 0x4F, 0x02, 0xD9, 0x88, 0xD7,
  0x29, 0x89, 0x14, 0x4F, 0x02, 0xD9, 0x88, 0xD7, 0x29, 0x89, 0x64, 0x4F, 0x01, 0xBB, 0x56, 0x4A,
  0x10, 0xF4, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12,
  0x02, 0x80, 0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_8k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_8k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_9k_plus 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_9k_plus_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8F, 0x04, 0x4F, 0x1B, 0xB6, 0x55, 0x92, 0x41, 0xF4, 0x4F, 0x1E, 0xBA, 0x6D, 0x85,
  0xE8, 0xF4, 0x4F, 0x08, 0xBA, 0x6D, 0x85, 0xE8, 0xF4, 0x4F, 0x1B, 0xB6, 0x55, 0x92, 0x41, 0xF4,
  0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x02, 0x80,
  0x63, 0x02, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_9k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_9k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_9k 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_av_9k_data[] PROGMEM = {
  0x10, 0x28, 0x06, 0x38, 0x12, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04,
  0x97, 0x39, 0x8A, 0x74, 0x4F, 0x01, 0xBB, 0x56, 0x4A, 0x10, 0xF4, 0x4F, 0x02, 0xEB, 0x88, 0xD7,
  0x29, 0x00, 0x49, 0x28, 0x49, 0xB8, 0x8D, 0x72, 0x98, 0x96, 0x44, 0xF0, 0x1B, 0xB5, 0x64, 0xA1,
  0x0F, 0x44, 0x97, 0x39, 0x00, 0x49, 0x73, 0x90, 0x04, 0x97, 0x39, 0x04, 0x02, 0xFD, 0x81, 0x20,
  0x28, 0x06, 0x30, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_9k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_9k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_add_to_queue 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_outlined_18_av_add_to_queue_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x50, 0x08, 0x58, 0x43, 0xF3, 0x3F, 0x35, 0x00, 0xB5, 0x84, 0x3F, 0x33, 0xF3,
  0x38, 0x47, 0x7D, 0xD7, 0x73, 0x84, 0x3F, 0x33, 0xF3, 0x3E, 0x38, 0x43, 0xF3, 0x3F, 0x35, 0x00,
  0xB5, 0x84, 0x3F, 0x33, 0xF3, 0x50, 0x0B, 0x58, 0x43, 0xF3, 0x3F, 0x35, 0x00, 0x25, 0x84, 0x3F,
  0x33, 0xF6, 0x80, 0x90, 0x38, 0x36, 0xF3, 0x1E, 0xFF, 0x82, 0xE1, 0x01, 0x80, 0x03, 0xE8, 0x00,
  0x37, 0x18, 0x02, 0xB6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_add_to_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_add_to_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_airplay 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_av_airplay_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33,
  0xF3, 0x75, 0x87, 0x3F, 0x33, 0xF6, 0x33, 0x12, 0x00, 0x72, 0x86, 0x13, 0x36, 0xF3, 0x1E, 0xB8,
  0x13, 0x07, 0xA8, 0x17, 0x03, 0xB0, 0xE0, 0x12, 0x0F, 0x30, 0x10, 0x7C, 0x07, 0x01, 0x0F, 0x37,
  0x07, 0xE0, 0x77, 0x20, 0x18, 0x04, 0x70, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_airplay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_airplay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_album 18x18, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_outlined_18_av_album_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x28, 0x19, 0xF2, 0x30, 0x04, 0x38, 0x12, 0xF9,
  0x29, 0x08, 0x20, 0x30, 0xEA, 0x0E, 0x03, 0x28, 0x48, 0xF0, 0x5F, 0x32, 0x0E, 0xC0, 0xE2, 0x82,
  0x3F, 0x56, 0x92, 0x04, 0xA0, 0x09, 0xA0, 0x42, 0x90, 0x06, 0x92, 0x04, 0xA0, 0x09, 0xA0, 0x42,
  0x98, 0x26, 0x5F, 0x32, 0x0E, 0xC0, 0xE2, 0x84, 0x3F, 0x50, 0xF8, 0x20, 0x30, 0xEA, 0x0E, 0x03,
  0x20, 0x89, 0x28, 0x19, 0xF2, 0x30, 0x04, 0x38, 0x12, 0xF9, 0x28, 0x21, 0xDD, 0x26, 0x82, 0x2D,
  0xD1, 0x38, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F, 0xD2, 0x50, 0x10, 0x9E, 0x09, 0x01, 0x72, 0x82,
  0x57, 0x75, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_album() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_album_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_art_track 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_outlined_18_av_art_track_data[] PROGMEM = {
  0x10, 0x98, 0x01, 0xB8, 0x14, 0x05, 0x80, 0x1B, 0x05, 0x06, 0xE8, 0x1E, 0x05, 0x80, 0x1B, 0x05,
  0x07, 0xF7, 0x10, 0x7F, 0x10, 0x58, 0x01, 0xB8, 0x55, 0x7F, 0xDE, 0xC7, 0xA1, 0x05, 0x80, 0x1B,
  0x86, 0x57, 0xF3, 0x41, 0x0A, 0x97, 0x18, 0x90, 0x6E, 0xBB, 0xBB, 0xCE, 0x05, 0x80, 0x1B, 0x81,
  0x50, 0x98, 0x01, 0xB8, 0x14, 0x05, 0x80, 0x1B, 0x05,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_art_track() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 16, 12), Box(0, 0, 17, 17),
      ic_outlined_18_av_art_track_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_audio_file 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_outlined_18_av_audio_file_data[] PROGMEM = {
  0x10, 0x18, 0x02, 0x34, 0x02, 0xF0, 0x73, 0x85, 0x6E, 0x11, 0x11, 0x3A, 0x07, 0x20, 0x60, 0xE4,
  0x01, 0xB8, 0x27, 0x06, 0xE4, 0x01, 0xC8, 0x14, 0x6E, 0x50, 0xF3, 0x82, 0xE6, 0x6E, 0x71, 0x82,
  0xE6, 0x6E, 0x40, 0xFD, 0x83, 0x2E, 0x66, 0xE4, 0x98, 0x5D, 0xD2, 0xE6, 0x6E, 0x28, 0x11, 0x1D,
  0x38, 0x7E, 0x66, 0xE0, 0x4E, 0xFD, 0x38, 0x4E, 0x66, 0xE0, 0xAA, 0x0D, 0x38, 0x4E, 0x66, 0xE0,
  0x6A, 0x09, 0x38, 0x95, 0xE6, 0x6E, 0x11, 0x56, 0x21, 0x11, 0xE6, 0x2F, 0xB8, 0x12, 0x01, 0x80,
  0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_audio_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_audio_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_av_timer 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_outlined_18_av_av_timer_data[] PROGMEM = {
  0x68, 0x28, 0xA8, 0x36, 0x00, 0x12, 0x0B, 0xB0, 0xB0, 0x13, 0x89, 0x21, 0xDC, 0x10, 0xBB, 0x16,
  0xFD, 0x12, 0x85, 0xBE, 0xFC, 0x12, 0x22, 0x89, 0x13, 0xEB, 0x03, 0xF6, 0x4F, 0xC1, 0x48, 0x37,
  0xF3, 0x8E, 0x28, 0x24, 0xFC, 0x14, 0x98, 0x78, 0xAC, 0x38, 0x04, 0xFB, 0x28, 0x68, 0x3D, 0xAA,
  0xC3, 0x82, 0x00, 0x42, 0x84, 0x83, 0xCA, 0x8E, 0x73, 0x83, 0xE8, 0x3F, 0x67, 0x18, 0x56, 0xF3,
  0x0B, 0xE2, 0x20, 0x08, 0x28, 0x12, 0xEB, 0x28, 0x92, 0x1D, 0xE6, 0x03, 0x30, 0x6E, 0xD1, 0x38,
  0x90, 0x1B, 0xFE, 0xCC, 0xEF, 0xB1, 0x68, 0x43, 0x8A, 0xA8, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_av_timer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_av_timer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_branding_watermark 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_outlined_18_av_branding_watermark_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x50, 0xBE, 0x84, 0x3F, 0x33, 0xF3, 0x50, 0xBE, 0x84,
  0x3F, 0x33, 0xF3, 0x50, 0xBE, 0x84, 0x3F, 0x33, 0xF3, 0x50, 0xBE, 0x84, 0x3F, 0x33, 0xF3, 0x50,
  0x58, 0x02, 0x78, 0x43, 0xF3, 0x2F, 0xC8, 0x09, 0x0B, 0x83, 0xCF, 0x20, 0x78, 0x09, 0x2B, 0x07,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_branding_watermark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_branding_watermark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_call_to_action 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_outlined_18_av_call_to_action_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x85, 0x3F, 0x33,
  0xF3, 0x28, 0x06, 0xB8, 0x62, 0x3F, 0x33, 0xF3, 0x3F, 0xB8, 0x63, 0x3F, 0x33, 0xF3, 0x18, 0x06,
  0x78, 0x51, 0x3F, 0x32, 0xFC, 0x80, 0x90, 0xB8, 0x3C, 0xF2, 0x07, 0x80, 0x92, 0xB0, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_call_to_action() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_call_to_action_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_closed_caption_disabled 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_outlined_18_av_closed_caption_disabled_data[] PROGMEM = {
  0x04, 0x07, 0x76, 0x83, 0x9F, 0x70, 0x5F, 0x98, 0x6E, 0x40, 0xCF, 0x70, 0x48, 0x03, 0x78, 0x2D,
  0xB0, 0xBA, 0x07, 0x71, 0x86, 0xBB, 0x0B, 0xB9, 0xF7, 0x30, 0xF3, 0x18, 0x4B, 0xB0, 0xBB, 0x7A,
  0x8B, 0x77, 0x01, 0xED, 0xE6, 0xBB, 0x0B, 0xB7, 0x99, 0xF7, 0x03, 0x02, 0x1B, 0xB0, 0xBB, 0x79,
  0x0B, 0xF7, 0x28, 0xB4, 0x21, 0xBB, 0x0B, 0xB6, 0xED, 0xFB, 0xF7, 0x04, 0x6B, 0xB0, 0xBB, 0x03,
  0x33, 0x09, 0xF7, 0x28, 0x3B, 0xB0, 0xBB, 0x68, 0x79, 0xF7, 0x05, 0xB0, 0xBD, 0x80, 0x37, 0x86,
  0xEF, 0x70, 0x30, 0x4E, 0xFB, 0x07, 0x76, 0x81, 0x9F, 0x77, 0x60, 0x90, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_closed_caption_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_closed_caption_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_closed_caption_off 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_av_closed_caption_off_data[] PROGMEM = {
  0x10, 0x38, 0x06, 0x58, 0x13, 0x02, 0xFD, 0x02, 0x04, 0x97, 0x39, 0x00, 0x49, 0x10, 0xF1, 0x20,
  0xF1, 0x19, 0x82, 0x44, 0xF2, 0xB0, 0x03, 0xB8, 0xC0, 0x2F, 0x44, 0xF3, 0xD0, 0x21, 0x4B, 0x03,
  0x1F, 0x44, 0xF3, 0xD0, 0x21, 0x4B, 0x03, 0x1F, 0x44, 0xF2, 0xB0, 0x03, 0xB8, 0x22, 0xF4, 0x49,
  0x10, 0xF1, 0x20, 0xF1, 0x19, 0x00, 0x49, 0x73, 0x90, 0x40, 0x2F, 0xD8, 0x12, 0x03, 0x80, 0x65,
  0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_closed_caption_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_closed_caption_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_closed_caption 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_av_closed_caption_data[] PROGMEM = {
  0x04, 0x0E, 0xFB, 0x82, 0xE4, 0xBD, 0x80, 0x67, 0x0D, 0x0F, 0xB7, 0x38, 0x00, 0xB1, 0x0F, 0x32,
  0x0F, 0x31, 0x80, 0x0B, 0x8E, 0x26, 0xED, 0xF3, 0x3F, 0xDE, 0x6B, 0xBB, 0xB7, 0x90, 0x31, 0x3D,
  0x02, 0x1B, 0xBB, 0xB7, 0x90, 0x31, 0x3D, 0x02, 0x1B, 0xBB, 0xB6, 0xED, 0xF3, 0x3F, 0xDE, 0x68,
  0x00, 0xB1, 0x0F, 0x32, 0x0F, 0x31, 0x80, 0x0B, 0x73, 0x0F, 0xB0, 0xD8, 0x06, 0x78, 0x2D, 0xB4,
  0xEF, 0xB0, 0xE0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_closed_caption() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_closed_caption_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_control_camera 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_outlined_18_av_control_camera_data[] PROGMEM = {
  0x70, 0x01, 0x76, 0x82, 0x1D, 0xD1, 0x74, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x38, 0x44, 0xF9, 0x9F,
  0x47, 0x40, 0x32, 0x03, 0x71, 0x01, 0x04, 0x30, 0x02, 0x30, 0x40, 0x13, 0x84, 0x1D, 0xF3, 0x09,
  0xA8, 0x93, 0x90, 0x3F, 0xD1, 0x01, 0xDF, 0x90, 0x2C, 0x89, 0x22, 0x09, 0xFD, 0x11, 0xDF, 0x90,
  0x2C, 0x89, 0x32, 0x09, 0xFD, 0x10, 0x1D, 0xF3, 0x09, 0xA8, 0x49, 0x03, 0xFD, 0x13, 0x01, 0x04,
  0x30, 0x02, 0x30, 0x40, 0x17, 0x10, 0x32, 0x03, 0x74, 0x84, 0x4F, 0x99, 0xF4, 0x73, 0x01, 0x0D,
  0xA0, 0xD0, 0x17, 0x48, 0x21, 0xDD, 0x17, 0x60, 0x01, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_control_camera() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_control_camera_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_equalizer 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_outlined_18_av_equalizer_data[] PROGMEM = {
  0x40, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x71, 0x0F, 0x34,
  0x07, 0xA0, 0x71, 0xB4, 0x07, 0xA0, 0x71, 0xE1, 0x07, 0xA0, 0x71, 0xE1, 0x07, 0xA0, 0x71, 0xE1,
  0x07, 0xA0, 0x71, 0xE1, 0x07, 0xA0, 0x71, 0xE1, 0x07, 0xA0, 0x71, 0xE1, 0x07, 0xA0, 0x71, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_equalizer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_equalizer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_explicit 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_outlined_18_av_explicit_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x82, 0xA2, 0xAE, 0x80, 0x6B, 0x82, 0xEA, 0xBB, 0x73, 0x80, 0x0B, 0x28,
  0x42, 0xBB, 0xBB, 0x22, 0x80, 0x0B, 0x28, 0x43, 0xFC, 0xBB, 0x22, 0x80, 0x0B, 0x28, 0x13, 0xF3,
  0x58, 0x00, 0xB2, 0x84, 0x3F, 0xCB, 0xB2, 0x28, 0x00, 0xB2, 0x84, 0x3F, 0xCB, 0xB2, 0x28, 0x00,
  0xB2, 0x81, 0x3F, 0x35, 0x80, 0x0B, 0x28, 0x43, 0xFC, 0xBB, 0x22, 0x80, 0x0B, 0x28, 0x42, 0xBB,
  0xBB, 0x22, 0x80, 0x0B, 0x73, 0x82, 0xBB, 0xAE, 0x80, 0x6B, 0x82, 0xEA, 0x2A, 0x80, 0x6B, 0x0A,
  0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_explicit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_explicit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_fast_forward 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_outlined_18_av_fast_forward_data[] PROGMEM = {
  0x02, 0x50, 0x01, 0x59, 0x06, 0x48, 0x13, 0xD4, 0x4A, 0x0B, 0x01, 0x20, 0x3A, 0x08, 0x39, 0x8E,
  0x0C, 0xEE, 0x50, 0x3F, 0xBF, 0xC2, 0x0F, 0x72, 0xCF, 0x94, 0xF3, 0x4D, 0xF6, 0xF7, 0x2C, 0xF9,
  0x4F, 0x34, 0xDF, 0x6F, 0xCE, 0xE5, 0x03, 0xFB, 0xFC, 0x21, 0xA0, 0xB0, 0x12, 0x03, 0xA0, 0x83,
  0x90, 0x64, 0x81, 0x3D, 0x44, 0x02, 0x50, 0x01, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_fast_forward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 15, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_fast_forward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_fast_rewind 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_outlined_18_av_fast_rewind_data[] PROGMEM = {
  0x50, 0x01, 0x50, 0x24, 0x81, 0x4D, 0x34, 0x06, 0x93, 0x08, 0xA0, 0x32, 0x01, 0x0B, 0xA1, 0x8E,
  0x02, 0xCF, 0xBF, 0x30, 0x5E, 0xEC, 0xF6, 0xFD, 0x43, 0xF4, 0x9F, 0xC2, 0x7F, 0x6F, 0xD4, 0x3F,
  0x49, 0xFC, 0x27, 0xF0, 0x2C, 0xFB, 0xF3, 0x05, 0xEE, 0xC9, 0x30, 0x8A, 0x03, 0x20, 0x10, 0xBA,
  0x48, 0x14, 0xD3, 0x40, 0x69, 0x50, 0x01, 0x50, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_fast_rewind() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 14, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_fast_rewind_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_featured_play_list 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_outlined_18_av_featured_play_list_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x85,
  0x3F, 0x33, 0xF3, 0x28, 0x02, 0xB0, 0x54, 0x85, 0x3F, 0x33, 0xF3, 0x28, 0x02, 0xB0, 0x54, 0x85,
  0x3F, 0x33, 0xF3, 0x18, 0x02, 0x70, 0x34, 0x85, 0x3F, 0x33, 0xF3, 0x3E, 0x07, 0x48, 0x43, 0xF3,
  0x3F, 0x37, 0x58, 0x43, 0xF3, 0x3F, 0x37, 0x58, 0x43, 0xF3, 0x3F, 0x37, 0x58, 0x43, 0xF3, 0x3F,
  0x37, 0x58, 0x43, 0xF3, 0x3F, 0x37, 0x58, 0x43, 0xF3, 0x2F, 0xC8, 0x09, 0x0B, 0x83, 0xCF, 0x20,
  0x78, 0x09, 0x2B, 0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_featured_play_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_featured_play_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_featured_video 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_outlined_18_av_featured_video_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x80, 0x27,
  0x05, 0x58, 0x43, 0xF3, 0x3F, 0x3E, 0x0B, 0x58, 0x43, 0xF3, 0x3F, 0x3E, 0x0B, 0x58, 0x43, 0xF3,
  0x3F, 0x3E, 0x0B, 0x58, 0x43, 0xF3, 0x3F, 0x3E, 0x0B, 0x58, 0x43, 0xF3, 0x3F, 0x38, 0x02, 0xB0,
  0x85, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75,
  0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x32, 0xFC, 0x80, 0x90, 0xB8, 0x3C, 0xF2, 0x07, 0x80,
  0x92, 0xB0, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_featured_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_featured_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_fiber_dvr 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_outlined_18_av_fiber_dvr_data[] PROGMEM = {
  0x8E, 0x02, 0x33, 0x10, 0x30, 0x12, 0x03, 0x33, 0x0B, 0xED, 0xD0, 0xB5, 0x88, 0x0F, 0xDE, 0x9B,
  0x51, 0xF0, 0x7A, 0xD4, 0x0F, 0x79, 0xBB, 0x51, 0xF0, 0x2F, 0xE2, 0x98, 0x5C, 0xF5, 0xBE, 0xDD,
  0x20, 0xD0, 0xA2, 0x98, 0x51, 0xA6, 0x23, 0x31, 0x20, 0x20, 0x12, 0x82, 0x30, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_fiber_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 15, 11), Box(0, 0, 17, 17),
      ic_outlined_18_av_fiber_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_fiber_manual_record 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_outlined_18_av_fiber_manual_record_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEC, 0x64, 0x89, 0x01, 0xCF, 0xC9, 0x9C, 0xFC, 0x12, 0x81, 0xCE, 0x54, 0x85,
  0x5E, 0xC0, 0x6F, 0x56, 0x83, 0x5F, 0x6C, 0xC7, 0x18, 0x2C, 0xCE, 0x97, 0x18, 0x29, 0xEE, 0x97,
  0x18, 0x29, 0xEC, 0xC7, 0x18, 0x3C, 0xC6, 0xF5, 0x68, 0x55, 0xF6, 0x0C, 0xE5, 0x48, 0x15, 0xEC,
  0x28, 0x90, 0x1C, 0xFC, 0x99, 0xCF, 0xC1, 0x48, 0x46, 0xCE, 0xEC, 0x63,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_fiber_manual_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_fiber_manual_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_fiber_new 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_outlined_18_av_fiber_new_data[] PROGMEM = {
  0x89, 0x01, 0x20, 0x21, 0x33, 0x31, 0x32, 0x89, 0x82, 0x21, 0x5E, 0x28, 0x5D, 0xCB, 0x3C, 0x24,
  0x85, 0x5E, 0xC9, 0x5D, 0x97, 0x2C, 0x59, 0x85, 0x59, 0xCE, 0x5D, 0x97, 0x2C, 0x59, 0x85, 0x58,
  0x2E, 0x5D, 0xCB, 0x2F, 0xEE, 0xE5, 0x12, 0x02, 0x13, 0x33, 0x02, 0x0F, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_fiber_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 15, 11), Box(0, 0, 17, 17),
      ic_outlined_18_av_fiber_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_fiber_pin 18x18, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_outlined_18_av_fiber_pin_data[] PROGMEM = {
  0x0F, 0x32, 0x8D, 0x02, 0x10, 0x21, 0x03, 0xFD, 0xE9, 0x0B, 0x50, 0xBB, 0x0E, 0xF7, 0x9B, 0x0B,
  0x50, 0xBE, 0x6E, 0xFC, 0xB4, 0x0B, 0x50, 0xB5, 0xEA, 0x01, 0x38, 0x6B, 0x50, 0xB2, 0x6F, 0x34,
  0x82, 0x21, 0x02, 0x20, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_fiber_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 14, 11), Box(0, 0, 17, 17),
      ic_outlined_18_av_fiber_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_fiber_smart_record 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_outlined_18_av_fiber_smart_record_data[] PROGMEM = {
  0x38, 0x51, 0x8C, 0xFE, 0xB4, 0x28, 0x12, 0x71, 0x58, 0x94, 0x3E, 0xFB, 0x8A, 0xDF, 0xA0, 0x3F,
  0xE2, 0x38, 0x22, 0xED, 0x34, 0x86, 0x8F, 0x90, 0x2D, 0xE1, 0x28, 0x1A, 0xE2, 0x68, 0x59, 0xF2,
  0x01, 0xE9, 0x29, 0x08, 0x78, 0x11, 0xF8, 0x28, 0x48, 0xF0, 0x3F, 0x57, 0x10, 0xD0, 0xA2, 0x84,
  0x5F, 0x23, 0xF5, 0x71, 0x0D, 0x0A, 0x28, 0x45, 0xF2, 0x0F, 0x87, 0x81, 0x1F, 0x82, 0x08, 0x92,
  0x81, 0xAE, 0x26, 0x85, 0x9F, 0x20, 0x1E, 0x92, 0x82, 0x2E, 0xD3, 0x48, 0x68, 0xF9, 0x02, 0xDE,
  0x13, 0x89, 0x43, 0xEF, 0xB8, 0xAD, 0xFA, 0x03, 0xFE, 0x25, 0x85, 0x18, 0xCF, 0xEB, 0x42, 0x81,
  0x27, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_fiber_smart_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_fiber_smart_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_forward_10 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_outlined_18_av_forward_10_data[] PROGMEM = {
  0x60, 0xB7, 0x49, 0x0B, 0x72, 0x03, 0xA0, 0xB5, 0x02, 0x0A, 0xD0, 0x73, 0x83, 0x3E, 0xE8, 0x5A,
  0x0B, 0x38, 0x21, 0xED, 0x22, 0x90, 0xB4, 0x81, 0x8F, 0x33, 0x0B, 0x50, 0xD0, 0xB4, 0x01, 0x02,
  0x49, 0x89, 0x38, 0x01, 0xB2, 0x97, 0x30, 0x23, 0xEA, 0x28, 0x90, 0x72, 0x93, 0x50, 0xAE, 0xBD,
  0x28, 0x91, 0x72, 0x7A, 0x30, 0xDB, 0x4F, 0x86, 0x86, 0x8F, 0x40, 0xAF, 0x91, 0x28, 0x21, 0x9F,
  0xA3, 0x09, 0xA0, 0x0D, 0xA0, 0x95, 0x84, 0x28, 0xAA, 0x82, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_forward_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_forward_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_forward_30 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_outlined_18_av_forward_30_data[] PROGMEM = {
  0x60, 0xB7, 0x49, 0x0B, 0x72, 0x03, 0xA0, 0xB5, 0x02, 0x0A, 0xD0, 0x73, 0x83, 0x3E, 0xE8, 0x5A,
  0x0B, 0x38, 0x21, 0xED, 0x22, 0x90, 0xB4, 0x81, 0x8F, 0x33, 0x0B, 0x50, 0xD0, 0xB2, 0x03, 0x20,
  0x34, 0x98, 0x93, 0x80, 0x46, 0x88, 0x75, 0x02, 0x3E, 0xA2, 0x8A, 0x57, 0x69, 0x27, 0x0A, 0xEB,
  0xD0, 0x58, 0x76, 0x94, 0x0D, 0xB4, 0xF8, 0x68, 0x68, 0xF4, 0x0A, 0xF9, 0x12, 0x82, 0x19, 0xFA,
  0x30, 0x9A, 0x00, 0xDA, 0x09, 0x58, 0x42, 0x8A, 0xA8, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_forward_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_forward_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_forward_5 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_outlined_18_av_forward_5_data[] PROGMEM = {
  0x60, 0xA7, 0x49, 0x0A, 0x72, 0x03, 0xA0, 0xA5, 0x02, 0x0A, 0xD0, 0x73, 0x83, 0x4E, 0xE8, 0x5A,
  0x0A, 0x38, 0x21, 0xEC, 0x22, 0x90, 0xA4, 0x81, 0x8F, 0x23, 0x0A, 0x50, 0xD0, 0xB3, 0x03, 0x04,
  0x59, 0x08, 0x30, 0xA0, 0x63, 0x82, 0x23, 0xE9, 0x30, 0x70, 0xA3, 0x82, 0xAD, 0xBD, 0x30, 0x90,
  0xA3, 0x83, 0xEA, 0x5F, 0x76, 0x86, 0x8F, 0x40, 0xAF, 0x91, 0x28, 0x21, 0x9F, 0x93, 0x09, 0xA0,
  0xC0, 0xDA, 0x08, 0x58, 0x43, 0x8A, 0xA8, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_forward_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_forward_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_games 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_outlined_18_av_games_data[] PROGMEM = {
  0x58, 0x41, 0x77, 0x77, 0x17, 0x30, 0x3C, 0x03, 0x73, 0x84, 0x3F, 0x33, 0xF3, 0x73, 0x84, 0x3F,
  0x33, 0xF3, 0x73, 0x84, 0x2F, 0xBB, 0xF2, 0x58, 0x51, 0x33, 0x32, 0x05, 0xA8, 0x65, 0x02, 0x33,
  0x31, 0x7C, 0x84, 0x50, 0x55, 0x05, 0xC8, 0x67, 0x7F, 0x33, 0xBF, 0x52, 0x89, 0x45, 0xFB, 0x33,
  0xF7, 0x7F, 0x33, 0xBF, 0x52, 0x86, 0x5F, 0xB3, 0x3F, 0x77, 0xC8, 0x45, 0x05, 0x50, 0x5C, 0x86,
  0x71, 0x33, 0x32, 0x05, 0xA8, 0x55, 0x02, 0x33, 0x31, 0x58, 0x42, 0xFB, 0xBF, 0x27, 0x38, 0x43,
  0xF3, 0x3F, 0x37, 0x38, 0x43, 0xF3, 0x3F, 0x37, 0x30, 0x3C, 0x03, 0x73, 0x84, 0x17, 0x77, 0x71,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_games() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_games_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_hd 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_av_hd_data[] PROGMEM = {
  0x02, 0x0A, 0x80, 0x6B, 0x82, 0xA2, 0xAE, 0x80, 0x6B, 0x82, 0xEA, 0xBB, 0x73, 0x80, 0x0B, 0x73,
  0x80, 0x0B, 0x89, 0x92, 0x12, 0x03, 0x11, 0x33, 0x30, 0xBB, 0xBB, 0x79, 0x0D, 0x33, 0xFD, 0xE6,
  0xBB, 0xBB, 0x7B, 0x5E, 0x33, 0xD0, 0x97, 0xBB, 0xBB, 0x7E, 0xBF, 0x33, 0xD0, 0x97, 0xBB, 0xBB,
  0x79, 0x0D, 0x33, 0xFD, 0xE6, 0xBB, 0xBB, 0x12, 0x03, 0x11, 0x0F, 0x31, 0x80, 0x0B, 0x73, 0x80,
  0x0B, 0x73, 0x82, 0xBB, 0xAE, 0x80, 0x6B, 0x82, 0xEA, 0x2A, 0x80, 0x6B, 0x0A, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_hd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_hd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_hearing_disabled 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_av_hearing_disabled_data[] PROGMEM = {
  0x02, 0x40, 0x03, 0x20, 0x20, 0x43, 0x89, 0x2A, 0x70, 0x5D, 0xBA, 0xD8, 0x2D, 0x23, 0x82, 0xB7,
  0x31, 0x38, 0x28, 0xA4, 0xB3, 0x89, 0x21, 0xF7, 0x06, 0x71, 0x0B, 0x3C, 0x22, 0x89, 0x24, 0xAB,
  0x74, 0xEA, 0x06, 0x79, 0x42, 0x89, 0x21, 0x10, 0xB7, 0x4C, 0x05, 0x88, 0x55, 0x81, 0x2C, 0x72,
  0x82, 0x95, 0xA3, 0x78, 0x4B, 0x70, 0xC1, 0xD7, 0x28, 0x3B, 0x70, 0x96, 0x71, 0x83, 0x3D, 0xB7,
  0x27, 0x28, 0x3C, 0x30, 0xB7, 0x50, 0x72, 0x04, 0x0B, 0x30, 0xB0, 0x74, 0x83, 0x7D, 0xAD, 0x24,
  0x0B, 0x07, 0x40, 0x20, 0x37, 0x0A, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_hearing_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_hearing_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_hearing 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_outlined_18_av_hearing_data[] PROGMEM = {
  0x20, 0xB0, 0x42, 0x83, 0x15, 0x75, 0x14, 0x83, 0x8F, 0x40, 0x8D, 0x08, 0x28, 0xA2, 0x1E, 0x90,
  0x9F, 0xA3, 0x03, 0xAF, 0x90, 0x6F, 0x23, 0xF8, 0x20, 0x12, 0x85, 0x8F, 0x39, 0xD0, 0x99, 0x28,
  0x1B, 0xFB, 0x29, 0x86, 0x9B, 0xC0, 0xBC, 0x04, 0xB8, 0x91, 0x40, 0x98, 0xAC, 0x09, 0xD0, 0x2B,
  0x02, 0x38, 0x90, 0x8E, 0x06, 0xF2, 0x04, 0x84, 0x48, 0x43, 0xF5, 0x0E, 0xB7, 0x28, 0x4C, 0xD0,
  0x5F, 0xA7, 0x18, 0x53, 0xF7, 0x06, 0xFB, 0x71, 0x04, 0x38, 0x14, 0xF9, 0x75, 0x81, 0x9F, 0x12,
  0x06, 0x05, 0x78, 0x52, 0xFA, 0x14, 0xF8, 0x71, 0x06, 0xB0, 0xC7, 0x38, 0x12, 0x65, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_hearing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_hearing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_high_quality 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_av_high_quality_data[] PROGMEM = {
  0x04, 0x0E, 0xFB, 0x82, 0xE4, 0xBD, 0x80, 0x67, 0x0D, 0x0F, 0xB7, 0x38, 0x00, 0xB8, 0x99, 0x51,
  0x20, 0x31, 0x03, 0x33, 0x0B, 0xBB, 0xB7, 0x90, 0xD3, 0x3F, 0xDE, 0x6B, 0xBB, 0xB7, 0xB5, 0xE3,
  0x3D, 0x09, 0x7B, 0xBB, 0xB7, 0xEB, 0xF3, 0x3D, 0x09, 0x7B, 0xBB, 0xB7, 0x90, 0xD3, 0x3F, 0xDE,
  0x6B, 0xBB, 0xB1, 0x20, 0x31, 0x03, 0xE5, 0x18, 0x00, 0xB7, 0x85, 0x51, 0x0B, 0xBB, 0xD8, 0x06,
  0x78, 0x2D, 0xB4, 0xEF, 0xB0, 0xE0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_high_quality() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_high_quality_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_interpreter_mode 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_outlined_18_av_interpreter_mode_data[] PROGMEM = {
  0x58, 0x53, 0x51, 0x01, 0x54, 0x73, 0x09, 0xA8, 0x13, 0x3E, 0xA0, 0xB7, 0x10, 0x3A, 0x86, 0xD0,
  0xBB, 0x03, 0xF5, 0x70, 0x5A, 0x82, 0xC0, 0xD7, 0x20, 0xE0, 0x67, 0x89, 0x11, 0xEF, 0xE0, 0x8E,
  0x69, 0xF2, 0x71, 0x89, 0x24, 0xCE, 0x40, 0x9E, 0xD5, 0x05, 0x87, 0x50, 0x13, 0x81, 0xCF, 0x23,
  0x85, 0x29, 0xB1, 0x07, 0xCB, 0x28, 0x1C, 0xF3, 0x20, 0x8A, 0x89, 0x45, 0x2E, 0xFA, 0x64, 0x31,
  0x99, 0xE5, 0x71, 0xB8, 0x21, 0x8D, 0x15, 0x84, 0x87, 0x5B, 0x11, 0xB1, 0x09, 0xE8, 0x29, 0x05,
  0xA3, 0x0F, 0x51, 0x03, 0x80, 0x35, 0x81, 0x20, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_interpreter_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_interpreter_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_library_add_check 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_av_library_add_check_data[] PROGMEM = {
  0x48, 0x05, 0x34, 0x08, 0x0B, 0x80, 0x39, 0x0D, 0x03, 0x30, 0x90, 0x47, 0x85, 0x94, 0x25, 0x09,
  0x45, 0x87, 0x73, 0x94, 0x49, 0x09, 0x44, 0x89, 0x17, 0xB0, 0x94, 0x49, 0x09, 0x41, 0x20, 0x70,
  0xB2, 0x89, 0x19, 0x44, 0x90, 0x94, 0x89, 0x7B, 0x38, 0x90, 0x94, 0x49, 0x09, 0x40, 0x9B, 0x48,
  0x59, 0x44, 0x90, 0x94, 0x78, 0x59, 0x44, 0x90, 0x97, 0x80, 0x33, 0x84, 0xA4, 0x49, 0x02, 0x80,
  0x49, 0x82, 0x80, 0x49, 0x75, 0x03, 0x0D, 0x80, 0x49, 0x05, 0x48, 0x05, 0x30, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_library_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_library_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_library_add 18x18, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_outlined_18_av_library_add_data[] PROGMEM = {
  0x40, 0x58, 0x05, 0x70, 0x54, 0x05, 0xFC, 0x05, 0x30, 0x79, 0x72, 0x98, 0x37, 0x37, 0x07, 0x93,
  0x81, 0x17, 0x13, 0x98, 0x37, 0x7F, 0x07, 0x93, 0x81, 0x3F, 0x33, 0x98, 0xA6, 0x77, 0xF0, 0x7F,
  0x01, 0x36, 0xF6, 0x31, 0x0F, 0x77, 0xF0, 0x7F, 0x07, 0xD8, 0xA6, 0x70, 0xF7, 0x7F, 0x07, 0xF0,
  0x13, 0x6F, 0x63, 0x10, 0xF7, 0x7F, 0x07, 0x93, 0x81, 0x3F, 0x33, 0x98, 0x37, 0x7F, 0x07, 0x93,
  0x81, 0x17, 0x13, 0x98, 0x37, 0x7F, 0x07, 0x97, 0x29, 0x83, 0x77, 0xF0, 0x5F, 0xC0, 0x50, 0x79,
  0x20, 0x58, 0x05, 0x78, 0x15, 0x07, 0x97, 0x70, 0x5F, 0xC0, 0x74, 0x05, 0x80, 0x67, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_library_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_library_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_library_books 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_outlined_18_av_library_books_data[] PROGMEM = {
  0x40, 0x58, 0x05, 0x70, 0x54, 0x05, 0xFC, 0x05, 0x30, 0x79, 0x72, 0x98, 0x67, 0x37, 0x07, 0xF0,
  0x38, 0x01, 0x78, 0x91, 0x30, 0xF7, 0x7F, 0x07, 0xF0, 0x7D, 0x89, 0x17, 0x0F, 0x77, 0xF0, 0x7F,
  0x01, 0x80, 0x13, 0x89, 0x11, 0x0F, 0x77, 0xF0, 0x7F, 0x07, 0xD8, 0x91, 0x70, 0xF7, 0x7F, 0x07,
  0xF0, 0x18, 0x01, 0x38, 0x91, 0x10, 0xF7, 0x7F, 0x07, 0xF0, 0x7A, 0x07, 0x49, 0x89, 0x17, 0x7F,
  0x07, 0xF0, 0x37, 0x73, 0x49, 0x83, 0x77, 0xF0, 0x79, 0x72, 0x98, 0x37, 0x7F, 0x05, 0xFC, 0x05,
  0x07, 0x92, 0x05, 0x80, 0x57, 0x81, 0x50, 0x79, 0x77, 0x05, 0xFC, 0x07, 0x40, 0x58, 0x06, 0x70,
  0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_library_books() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_library_books_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_library_music 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_outlined_18_av_library_music_data[] PROGMEM = {
  0x40, 0x58, 0x05, 0x70, 0x54, 0x05, 0xFC, 0x05, 0x30, 0x79, 0x48, 0x91, 0x13, 0x31, 0x0F, 0x73,
  0x70, 0x79, 0x40, 0x7A, 0x86, 0x70, 0xF7, 0x7F, 0x07, 0x94, 0x89, 0x17, 0x63, 0x10, 0xF7, 0x7F,
  0x07, 0x94, 0x07, 0x03, 0x39, 0x83, 0x77, 0xF0, 0x79, 0x28, 0x23, 0x79, 0x33, 0x98, 0x67, 0x7F,
  0x07, 0xF0, 0x3B, 0x03, 0x39, 0x86, 0x77, 0xF0, 0x7F, 0x06, 0xB0, 0x33, 0x98, 0x91, 0x77, 0xF0,
  0x7F, 0x02, 0xEF, 0xC4, 0x98, 0x37, 0x7F, 0x07, 0x93, 0x03, 0x59, 0x83, 0x77, 0xF0, 0x5F, 0xC0,
  0x50, 0x79, 0x20, 0x58, 0x05, 0x78, 0x15, 0x07, 0x97, 0x70, 0x5F, 0xC0, 0x74, 0x05, 0x80, 0x67,
  0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_library_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_library_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_loop 18x18, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_outlined_18_av_loop_data[] PROGMEM = {
  0x50, 0xB7, 0x30, 0xB9, 0x72, 0x0A, 0xA8, 0x1E, 0xC6, 0x60, 0x4A, 0x83, 0x9C, 0xFC, 0x15, 0x04,
  0x92, 0x84, 0x5E, 0xC0, 0x59, 0x30, 0x43, 0x83, 0x5F, 0x6B, 0xC7, 0x18, 0x2C, 0xCE, 0x87, 0x18,
  0x29, 0xEE, 0x97, 0x18, 0x28, 0xEC, 0xC7, 0x18, 0x3C, 0xB6, 0xF5, 0x30, 0x43, 0x84, 0x95, 0x0C,
  0xE5, 0x29, 0x04, 0x58, 0x31, 0xCF, 0xC9, 0xA0, 0x46, 0x81, 0x6C, 0xEA, 0x0A, 0x72, 0x90, 0xB7,
  0x30, 0xB5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_loop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_loop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_lyrics 18x18, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_outlined_18_av_lyrics_data[] PROGMEM = {
  0x77, 0x0F, 0x12, 0x80, 0x43, 0x02, 0x30, 0xAA, 0x10, 0xEF, 0xA0, 0x52, 0x84, 0xAB, 0x33, 0xF3,
  0x80, 0x31, 0x0C, 0x08, 0x28, 0x5A, 0xA0, 0x3F, 0x23, 0x80, 0x17, 0x18, 0x96, 0x60, 0x37, 0xCA,
  0x03, 0xF2, 0x6D, 0xDD, 0xDB, 0x20, 0x6B, 0x83, 0xA0, 0x3F, 0x27, 0x10, 0xCB, 0x84, 0x90, 0x3F,
  0x27, 0xC0, 0xD2, 0x0A, 0xB8, 0x97, 0x70, 0x3F, 0x22, 0x55, 0x55, 0x40, 0x11, 0xBE, 0xA2, 0x85,
  0x3F, 0x24, 0x88, 0x13, 0x0A, 0x03, 0x58, 0x53, 0xF2, 0x6C, 0xC2, 0x30, 0xB0, 0x95, 0x81, 0x3F,
  0x27, 0x0B, 0x09, 0x58, 0x13, 0xF8, 0x80, 0x3D, 0x90, 0x75, 0x03, 0xA0, 0x98, 0x02, 0x70, 0x66,
  0x81, 0x3F, 0x77, 0x70, 0x30, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_lyrics() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_lyrics_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_mic_none 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_av_mic_none_data[] PROGMEM = {
  0x50, 0x06, 0x72, 0x0C, 0xA0, 0xC7, 0x84, 0x3F, 0x66, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84,
  0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x97, 0x2B, 0x33,
  0xF6, 0x6F, 0x33, 0xB2, 0x0F, 0x80, 0xCA, 0x81, 0xC0, 0x89, 0x28, 0x90, 0xAE, 0x20, 0x66, 0x02,
  0xEA, 0x28, 0x90, 0x1E, 0xE5, 0x11, 0x5E, 0xE1, 0x30, 0x20, 0xCC, 0x0C, 0x02, 0x68, 0x22, 0xDD,
  0x27, 0x20, 0x0B, 0x73, 0x00, 0x85,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_mic_none() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_mic_none_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_mic_off 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_outlined_18_av_mic_off_data[] PROGMEM = {
  0x60, 0x06, 0x60, 0x20, 0x83, 0x82, 0xCE, 0xEC, 0x58, 0x90, 0x6F, 0xA0, 0x1E, 0x33, 0xF3, 0x58,
  0x77, 0xFA, 0x03, 0x11, 0xF3, 0x68, 0x17, 0xFA, 0x28, 0x11, 0xF3, 0x78, 0x57, 0xFA, 0x01, 0xE3,
  0x71, 0x84, 0x7F, 0xA0, 0x33, 0x58, 0x22, 0xB1, 0x3A, 0x0A, 0x28, 0x11, 0xB2, 0x39, 0x81, 0x40,
  0xCA, 0x83, 0xA0, 0x1E, 0x13, 0x09, 0x0C, 0x28, 0x46, 0x9F, 0xA0, 0x14, 0x82, 0x1D, 0xC4, 0x28,
  0x19, 0xFA, 0x70, 0xAC, 0x81, 0xBF, 0xA7, 0x18, 0x5C, 0xC1, 0x07, 0xFA, 0x70, 0x0B, 0x38, 0x17,
  0xF9, 0x60, 0x08, 0x40, 0x60, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_mic_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_mic_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_mic 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_outlined_18_av_mic_data[] PROGMEM = {
  0x50, 0x06, 0x72, 0x0C, 0xA0, 0xC7, 0x03, 0xC0, 0x36, 0x03, 0xC0, 0x36, 0x03, 0xC0, 0x36, 0x03,
  0xC0, 0x36, 0x03, 0xC0, 0x33, 0x82, 0x2B, 0x33, 0xC8, 0x73, 0x3B, 0x20, 0xF8, 0x0C, 0xA8, 0x1C,
  0x08, 0x92, 0x89, 0x0A, 0xE2, 0x06, 0x60, 0x2E, 0xA2, 0x89, 0x01, 0xEE, 0x51, 0x15, 0xEE, 0x13,
  0x02, 0x0C, 0xC0, 0xC0, 0x26, 0x82, 0x2D, 0xD2, 0x72, 0x00, 0xB7, 0x30, 0x08, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_missed_video_call 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_outlined_18_av_missed_video_call_data[] PROGMEM = {
  0x03, 0x80, 0x57, 0x03, 0x30, 0xBF, 0xA8, 0x4B, 0x01, 0x8B, 0xB8, 0x00, 0x13, 0x89, 0x1B, 0xB1,
  0xCB, 0xBB, 0x7F, 0xB9, 0x38, 0x90, 0xBC, 0xCF, 0xBB, 0xB7, 0xCA, 0x28, 0x13, 0xBB, 0xB0, 0xFB,
  0x86, 0x75, 0x7A, 0x3C, 0x1B, 0xB0, 0xFB, 0x89, 0x01, 0x10, 0x7D, 0x10, 0xBC, 0xC9, 0x0F, 0xB4,
  0x01, 0x28, 0x4B, 0xB1, 0xCB, 0xBF, 0xA8, 0x3B, 0x01, 0x83, 0x80, 0x57, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_missed_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_missed_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_movie 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_outlined_18_av_movie_data[] PROGMEM = {
  0x89, 0x32, 0xDE, 0x10, 0xBB, 0x01, 0xE7, 0x03, 0xA0, 0x07, 0xA8, 0xB6, 0x70, 0x3F, 0x30, 0x7E,
  0x10, 0xBF, 0x77, 0xFA, 0xE1, 0x0B, 0xB0, 0x1E, 0x70, 0x3F, 0x77, 0xF2, 0xFD, 0x83, 0x77, 0xF0,
  0x68, 0x06, 0x79, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97,
  0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x98, 0x09, 0x07, 0x98, 0x17, 0x2D, 0xFD, 0x0D, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_movie() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_movie_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_music_video 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_outlined_18_av_music_video_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x60, 0xF7,
  0x05, 0x28, 0x43, 0xF3, 0x3F, 0x36, 0xB0, 0xB2, 0x84, 0x3F, 0x33, 0xF3, 0x69, 0x07, 0x48, 0x43,
  0xF3, 0x3F, 0x36, 0x90, 0x74, 0x84, 0x3F, 0x33, 0xF3, 0x69, 0x07, 0x48, 0x43, 0xF3, 0x3F, 0x33,
  0x83, 0x3C, 0xEF, 0x74, 0x84, 0x3F, 0x33, 0xF3, 0x30, 0xCB, 0x07, 0x48, 0x43, 0xF3, 0x3F, 0x33,
  0x0E, 0xB0, 0x64, 0x84, 0x3F, 0x33, 0xF3, 0x30, 0x8A, 0x0E, 0x01, 0x48, 0x43, 0xF3, 0x3F, 0x34,
  0x81, 0x46, 0x15, 0x84, 0x3F, 0x32, 0xFC, 0x80, 0x90, 0xB8, 0x3C, 0xF2, 0x07, 0x80, 0x92, 0xB0,
  0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_music_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_music_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_new_releases 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_18_av_new_releases_data[] PROGMEM = {
  0x50, 0x90, 0x62, 0x06, 0x09, 0x72, 0x05, 0xA0, 0x0E, 0xA0, 0x56, 0x89, 0x21, 0x5D, 0xC3, 0xAA,
  0x3C, 0xD5, 0x13, 0x09, 0xA0, 0xE0, 0x34, 0x03, 0x0E, 0xA0, 0x92, 0x81, 0x8F, 0x33, 0x00, 0x83,
  0x81, 0x3F, 0x82, 0x07, 0x94, 0x00, 0xB4, 0x98, 0x37, 0x01, 0xDE, 0x40, 0x0B, 0x48, 0x4E, 0xD1,
  0xCE, 0x34, 0x00, 0xB4, 0x84, 0x3E, 0xCC, 0xE3, 0x40, 0x08, 0x48, 0x43, 0xEC, 0x1D, 0xE7, 0x38,
  0x3E, 0xD1, 0x07, 0x94, 0x00, 0x84, 0x90, 0x72, 0x81, 0x8F, 0x33, 0x00, 0x83, 0x81, 0x3F, 0x82,
  0x09, 0xA0, 0xE0, 0x34, 0x03, 0x0E, 0xA0, 0x93, 0x89, 0x21, 0x5D, 0xC3, 0xAA, 0x3C, 0xD5, 0x16,
  0x05, 0xA0, 0x0E, 0xA0, 0x57, 0x20, 0x90, 0x62, 0x06, 0x09, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_new_releases() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_new_releases_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_note 18x18, 4-bit Alpha,  RLE, 57 bytes.
static const unsigned char ic_outlined_18_av_note_data[] PROGMEM = {
  0x02, 0x0D, 0xFA, 0x07, 0x40, 0x79, 0x80, 0x47, 0x81, 0xDF, 0x73, 0x07, 0x97, 0x10, 0xBA, 0x07,
  0x20, 0x79, 0x71, 0x0B, 0xB8, 0x17, 0x07, 0x97, 0x10, 0xBC, 0x05, 0x07, 0x97, 0x18, 0x52, 0x33,
  0x3F, 0x77, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59, 0x00, 0x79, 0x75, 0x90, 0x07,
  0x98, 0x09, 0x07, 0x98, 0x17, 0x2D, 0xFD, 0x0D, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_not_interested 18x18, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_outlined_18_av_not_interested_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x21, 0xDF, 0xA6, 0x82, 0x2D, 0xD1, 0x28, 0x39, 0xFA, 0xF8, 0x68, 0x12, 0xF9, 0x29,
  0x83, 0x80, 0x8F, 0x86, 0x84, 0x8F, 0x05, 0xF3, 0x28, 0x18, 0xF8, 0x58, 0x23, 0xF5, 0x69, 0x48,
  0x18, 0xF8, 0x59, 0x00, 0x69, 0x58, 0x18, 0xF8, 0x49, 0x82, 0x65, 0xF3, 0x58, 0x18, 0xF8, 0x28,
  0x43, 0xF5, 0x0F, 0x86, 0x83, 0x8F, 0x80, 0x89, 0x28, 0x19, 0xF2, 0x68, 0x38, 0xFA, 0xF9, 0x28,
  0x21, 0xDD, 0x26, 0x82, 0xAF, 0xD1, 0x38, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F, 0xD2, 0x50, 0x10,
  0x9E, 0x09, 0x01, 0x72, 0x82, 0x57, 0x75, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_not_interested() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_not_interested_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_pause_circle_filled 18x18, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_outlined_18_av_pause_circle_filled_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x23, 0x01,
  0x0D, 0xFB, 0x0D, 0x01, 0x20, 0x9F, 0xD0, 0x92, 0xC8, 0x4B, 0x0B, 0xB0, 0xBC, 0x10, 0x5C, 0x84,
  0xB0, 0xBB, 0x0B, 0xC0, 0x50, 0x6C, 0x84, 0xB0, 0xBB, 0x0B, 0xC0, 0x06, 0xC8, 0x4B, 0x0B, 0xB0,
  0xBC, 0x06, 0x05, 0xC8, 0x4B, 0x0B, 0xB0, 0xBC, 0x05, 0x1C, 0x84, 0xB0, 0xBB, 0x0B, 0xC2, 0x09,
  0xFD, 0x09, 0x20, 0x10, 0xDF, 0xB0, 0xD0, 0x13, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0x9E,
  0x09, 0x01, 0x72, 0x82, 0x57, 0x75, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_pause_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_pause_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_pause_circle_outline 18x18, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_outlined_18_av_pause_circle_outline_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x28, 0x19, 0xF2, 0x71, 0x81, 0x2F, 0x92, 0x90,
  0x82, 0x84, 0x3F, 0x33, 0xF3, 0x28, 0x48, 0xF0, 0x5F, 0x32, 0x84, 0x3F, 0x33, 0xF3, 0x28, 0x23,
  0xF5, 0x69, 0x38, 0x43, 0xF3, 0x3F, 0x33, 0x90, 0x06, 0x93, 0x84, 0x3F, 0x33, 0xF3, 0x39, 0x82,
  0x65, 0xF3, 0x28, 0x43, 0xF3, 0x3F, 0x32, 0x84, 0x3F, 0x50, 0xF8, 0x28, 0x43, 0xF3, 0x3F, 0x32,
  0x08, 0x92, 0x81, 0x9F, 0x27, 0x18, 0x12, 0xF9, 0x28, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x38,
  0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F, 0xD2, 0x50, 0x10, 0x9E, 0x09, 0x01, 0x72, 0x82, 0x57, 0x75,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_pause_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_pause_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_pause_circle 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_outlined_18_av_pause_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x20, 0x0B, 0x28, 0x42, 0xA1,
  0x1A, 0x22, 0x00, 0xB2, 0x90, 0x52, 0x84, 0x3F, 0x11, 0xF3, 0x28, 0x45, 0xF0, 0x2F, 0x32, 0x84,
  0x3F, 0x11, 0xF3, 0x28, 0x43, 0xF2, 0x2F, 0x32, 0x84, 0x3F, 0x11, 0xF3, 0x28, 0x43, 0xF2, 0x0F,
  0x52, 0x84, 0x3F, 0x11, 0xF3, 0x20, 0x59, 0x20, 0x0B, 0x28, 0x42, 0xA1, 0x1A, 0x22, 0x00, 0xB2,
  0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x38, 0x19, 0xF5, 0x68, 0x15, 0xF9, 0x58, 0x90, 0x9F, 0xB5,
  0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_pause_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_pause_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_pause 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_outlined_18_av_pause_data[] PROGMEM = {
  0x82, 0x13, 0x31, 0x28, 0x31, 0x33, 0x17, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA8, 0x37, 0x13, 0x31, 0x28, 0x21, 0x33, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_pause() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_pause_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_play_arrow 18x18, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_outlined_18_av_play_arrow_data[] PROGMEM = {
  0x0D, 0x04, 0x6A, 0x0A, 0x01, 0x49, 0x82, 0xCF, 0xE5, 0x39, 0x87, 0x72, 0xBF, 0xB2, 0x0F, 0x72,
  0x84, 0x6E, 0xF7, 0xF7, 0x28, 0x97, 0x6E, 0xF7, 0xF7, 0x2B, 0xFB, 0x20, 0xFC, 0xFE, 0x53, 0xA0,
  0xA0, 0x14, 0x0D, 0x04, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_play_arrow() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 13, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_play_arrow_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_play_circle_filled 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_outlined_18_av_play_circle_filled_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x50, 0x20, 0xDF, 0x90, 0xD0, 0x23, 0x01,
  0x0D, 0xFB, 0x0D, 0x01, 0x20, 0x9C, 0x0E, 0xF0, 0x92, 0xD8, 0x17, 0x5E, 0xE1, 0x05, 0xD8, 0x27,
  0x02, 0xCD, 0x05, 0x06, 0xD0, 0x73, 0x09, 0xC0, 0x06, 0xD0, 0x73, 0x09, 0xC0, 0x60, 0x5D, 0x82,
  0x70, 0x2C, 0xD0, 0x51, 0xD8, 0x17, 0x5E, 0xE2, 0x09, 0xC0, 0xEF, 0x09, 0x20, 0x10, 0xDF, 0xB0,
  0xD0, 0x13, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x50, 0x10, 0x9E, 0x09, 0x01, 0x72, 0x82, 0x57, 0x75,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_play_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_play_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_play_circle_outline 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_outlined_18_av_play_circle_outline_data[] PROGMEM = {
  0x68, 0x25, 0x77, 0x57, 0x20, 0x10, 0x9E, 0x09, 0x01, 0x58, 0x32, 0xDF, 0x83, 0x28, 0x33, 0x8F,
  0xD2, 0x38, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x28, 0x19, 0xF2, 0x20, 0x15, 0x81, 0x2F, 0x92,
  0x90, 0x83, 0x07, 0x09, 0x58, 0x48, 0xF0, 0x5F, 0x33, 0x82, 0x7F, 0xC2, 0x38, 0x23, 0xF5, 0x69,
  0x40, 0x7A, 0x0E, 0x05, 0x39, 0x00, 0x69, 0x40, 0x7A, 0x0E, 0x05, 0x39, 0x82, 0x65, 0xF3, 0x38,
  0x27, 0xFC, 0x23, 0x84, 0x3F, 0x50, 0xF8, 0x30, 0x70, 0x95, 0x08, 0x92, 0x81, 0x9F, 0x22, 0x01,
  0x58, 0x12, 0xF9, 0x28, 0x21, 0xDD, 0x26, 0x82, 0x2D, 0xD1, 0x38, 0x32, 0xDF, 0x83, 0x28, 0x33,
  0x8F, 0xD2, 0x50, 0x10, 0x9E, 0x09, 0x01, 0x72, 0x82, 0x57, 0x75, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_play_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_play_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_play_circle 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_outlined_18_av_play_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x20, 0x0B, 0x30, 0xA0, 0x55,
  0x00, 0xB2, 0x90, 0x53, 0x82, 0xCF, 0xA1, 0x38, 0x45, 0xF0, 0x2F, 0x33, 0x0C, 0xA0, 0xE0, 0x62,
  0x84, 0x3F, 0x22, 0xF3, 0x30, 0xCA, 0x0E, 0x06, 0x28, 0x43, 0xF2, 0x0F, 0x53, 0x82, 0xCF, 0xA1,
  0x30, 0x59, 0x20, 0x0B, 0x30, 0xA0, 0x55, 0x00, 0xB2, 0x81, 0x3F, 0x57, 0x18, 0x15, 0xF3, 0x38,
  0x19, 0xF5, 0x68, 0x15, 0xF9, 0x58, 0x90, 0x9F, 0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B,
  0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_play_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_play_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_play_disabled 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_av_play_disabled_data[] PROGMEM = {
  0x10, 0x27, 0x68, 0x11, 0xE7, 0x76, 0x84, 0x6F, 0x70, 0x52, 0x73, 0x84, 0x6F, 0x70, 0x88, 0x73,
  0x85, 0x6F, 0x70, 0x9D, 0x37, 0x28, 0x56, 0xF7, 0x09, 0xF9, 0x72, 0x86, 0xBF, 0x70, 0x9F, 0xD4,
  0x78, 0x6A, 0xEF, 0x70, 0x9D, 0x47, 0x83, 0xAA, 0x7F, 0x77, 0x38, 0x4A, 0xDE, 0xDF, 0x77, 0x28,
  0x5A, 0xF8, 0x06, 0xF7, 0x71, 0x07, 0x02, 0x38, 0x16, 0xF7, 0x76, 0x81, 0x6F, 0x77, 0x68, 0x16,
  0xE2, 0x76, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_play_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_play_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_playlist_add_check_circle 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_outlined_18_av_playlist_add_check_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x87, 0x3F, 0x55, 0x99, 0x99, 0x32, 0x81, 0x5F, 0x32, 0x87, 0xBB,
  0x07, 0xBB, 0xBB, 0x43, 0x00, 0xB2, 0x98, 0x65, 0x03, 0x55, 0x55, 0x23, 0x86, 0x5F, 0x02, 0xF3,
  0x09, 0xC0, 0x53, 0x84, 0x3F, 0x22, 0xF3, 0x10, 0xF1, 0x48, 0xA1, 0x41, 0x3F, 0x20, 0xF5, 0x09,
  0xFA, 0x02, 0x05, 0xF7, 0x59, 0x28, 0x94, 0xBB, 0x02, 0x32, 0x1E, 0xAF, 0x90, 0xBB, 0x28, 0x13,
  0xF5, 0x48, 0x56, 0xF9, 0x05, 0xF3, 0x38, 0x19, 0xF5, 0x48, 0x33, 0x05, 0xF9, 0x58, 0x90, 0x9F,
  0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_playlist_add_check_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_playlist_add_check_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_playlist_add_check 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_outlined_18_av_playlist_add_check_data[] PROGMEM = {
  0x02, 0x80, 0x37, 0x06, 0x50, 0x38, 0x03, 0xD0, 0xA7, 0x75, 0x03, 0x80, 0x3A, 0x08, 0x50, 0x38,
  0x03, 0xA0, 0x84, 0x04, 0x75, 0x81, 0xCD, 0x48, 0x01, 0xD8, 0x71, 0x2B, 0x10, 0xCD, 0x22, 0x80,
  0x17, 0x18, 0x41, 0xDD, 0xCD, 0x27, 0x28, 0x21, 0xDD, 0x27, 0x40, 0x10, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_playlist_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_playlist_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_playlist_add_circle 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_outlined_18_av_playlist_add_circle_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x89, 0x09, 0xFB, 0x53, 0x35, 0xBF, 0x95, 0x81,
  0x9F, 0x56, 0x81, 0x5F, 0x93, 0x87, 0x3F, 0x55, 0x99, 0x99, 0x32, 0x81, 0x5F, 0x32, 0x87, 0xBB,
  0x07, 0xBB, 0xBB, 0x43, 0x00, 0xB2, 0x98, 0x65, 0x03, 0x55, 0x55, 0x23, 0x86, 0x5F, 0x02, 0xF3,
  0x09, 0xC8, 0x90, 0x55, 0x40, 0x3F, 0x22, 0xF3, 0x10, 0xF1, 0x28, 0x96, 0x1C, 0xA1, 0x3F, 0x20,
  0xF5, 0x09, 0xFA, 0x01, 0xB0, 0xE0, 0x59, 0x28, 0x4B, 0xB0, 0x23, 0x22, 0x84, 0x3C, 0xA3, 0xBB,
  0x28, 0x13, 0xF5, 0x68, 0x37, 0x55, 0xF3, 0x38, 0x19, 0xF5, 0x68, 0x15, 0xF9, 0x58, 0x90, 0x9F,
  0xB5, 0x33, 0x5B, 0xF9, 0x70, 0x30, 0xBC, 0x0B, 0x03, 0x74, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_playlist_add_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_playlist_add_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_playlist_add 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_outlined_18_av_playlist_add_data[] PROGMEM = {
  0x02, 0x80, 0x37, 0x06, 0x60, 0x38, 0x03, 0xD0, 0xA7, 0x77, 0x03, 0x80, 0x3A, 0x82, 0x80, 0xB3,
  0x30, 0x38, 0x03, 0xA8, 0x28, 0x1F, 0x47, 0x58, 0x11, 0xF4, 0x30, 0x48, 0x01, 0xD8, 0x90, 0x1D,
  0xDD, 0xFE, 0xDD, 0x22, 0x80, 0x17, 0x18, 0x67, 0x78, 0xF9, 0x77, 0x17, 0x28, 0x11, 0xF4, 0x75,
  0x81, 0x1F, 0x47, 0x60, 0x50, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_playlist_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_playlist_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_playlist_play 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_outlined_18_av_playlist_play_data[] PROGMEM = {
  0x02, 0x80, 0x37, 0x06, 0x50, 0x38, 0x03, 0xD0, 0xA7, 0x75, 0x03, 0x80, 0x3A, 0x08, 0x50, 0x38,
  0x03, 0xA0, 0x87, 0x70, 0x20, 0x13, 0x04, 0x80, 0x1D, 0x01, 0x28, 0x14, 0xE5, 0x20, 0x28, 0x01,
  0x73, 0x04, 0xA0, 0xB0, 0x17, 0x20, 0x4B, 0x0B, 0x72, 0x04, 0xA0, 0x77, 0x38, 0x14, 0xB2, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_playlist_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_playlist_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_playlist_remove 18x18, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_outlined_18_av_playlist_remove_data[] PROGMEM = {
  0x02, 0x80, 0x37, 0x06, 0x50, 0x48, 0x03, 0xD0, 0xA7, 0x75, 0x03, 0x80, 0x3B, 0x09, 0x50, 0x28,
  0x03, 0x90, 0x77, 0x75, 0x04, 0x80, 0x1D, 0x87, 0x10, 0xB7, 0x04, 0xC1, 0x28, 0x01, 0x72, 0x83,
  0x7F, 0x9E, 0xA7, 0x38, 0x19, 0xFC, 0x73, 0x83, 0x4E, 0xCF, 0x77, 0x28, 0x4C, 0xA0, 0x7E, 0x17,
  0x10, 0x13, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_playlist_remove() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_playlist_remove_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_queue_music 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_outlined_18_av_queue_music_data[] PROGMEM = {
  0x02, 0x80, 0x37, 0x86, 0x60, 0x37, 0x77, 0x13, 0x80, 0x3D, 0x85, 0xA0, 0x6F, 0xDD, 0x27, 0x30,
  0x60, 0xE3, 0x03, 0x80, 0x3C, 0x82, 0x90, 0x6E, 0x30, 0x28, 0x03, 0x88, 0x26, 0x06, 0xE4, 0x80,
  0x11, 0x40, 0x60, 0xE3, 0x04, 0xD8, 0x11, 0x0A, 0xA0, 0xE3, 0x01, 0x80, 0x13, 0x10, 0x6B, 0x0E,
  0x73, 0x07, 0xB0, 0xD7, 0x30, 0x10, 0xEA, 0x06, 0x74, 0x81, 0x15, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_queue_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_queue_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_queue_play_next 18x18, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_outlined_18_av_queue_play_next_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x50, 0x08, 0x58, 0x43, 0xF3, 0x3F, 0x35, 0x00, 0xB5, 0x84, 0x3F, 0x33, 0xF3,
  0x38, 0x47, 0x7D, 0xD7, 0x73, 0x84, 0x3F, 0x33, 0xF3, 0x3E, 0x38, 0x43, 0xF3, 0x3F, 0x35, 0x00,
  0xB5, 0x84, 0x2B, 0x23, 0xF3, 0x50, 0x0B, 0x40, 0x90, 0x12, 0x81, 0x3F, 0x35, 0x00, 0x23, 0x86,
  0x3F, 0xD1, 0x03, 0xF6, 0x80, 0x63, 0x85, 0x14, 0xFD, 0x11, 0xEF, 0xC8, 0x57, 0x07, 0xFB, 0x01,
  0x80, 0x03, 0xE8, 0x43, 0x14, 0xFD, 0x16, 0x80, 0x2B, 0x18, 0x23, 0xFD, 0x17, 0x71, 0x09, 0x01,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_queue_play_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_queue_play_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_queue 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_outlined_18_av_queue_data[] PROGMEM = {
  0x40, 0x58, 0x05, 0x70, 0x54, 0x05, 0xFC, 0x05, 0x30, 0x79, 0x38, 0x11, 0x31, 0x39, 0x83, 0x73,
  0x70, 0x79, 0x38, 0x13, 0xF3, 0x39, 0x83, 0x77, 0xF0, 0x79, 0x38, 0x13, 0xF3, 0x39, 0x8A, 0x57,
  0x7F, 0x07, 0xF1, 0x33, 0x6F, 0x63, 0x31, 0xF7, 0x7F, 0x07, 0xF3, 0xF8, 0xA5, 0x3F, 0x77, 0xF0,
  0x7F, 0x13, 0x36, 0xF6, 0x33, 0x1F, 0x77, 0xF0, 0x79, 0x38, 0x13, 0xF3, 0x39, 0x83, 0x77, 0xF0,
  0x79, 0x38, 0x13, 0xF3, 0x39, 0x83, 0x77, 0xF0, 0x79, 0x38, 0x11, 0x31, 0x39, 0x83, 0x77, 0xF0,
  0x5F, 0xC0, 0x50, 0x79, 0x20, 0x58, 0x05, 0x78, 0x15, 0x07, 0x97, 0x70, 0x5F, 0xC0, 0x74, 0x05,
  0x80, 0x67, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_radio 18x18, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_outlined_18_av_radio_data[] PROGMEM = {
  0x73, 0x01, 0x76, 0x82, 0x4A, 0xF3, 0x72, 0x84, 0x17, 0xDF, 0xB5, 0x71, 0x84, 0x39, 0xFE, 0x82,
  0x71, 0x05, 0x0C, 0xA0, 0xD0, 0x88, 0x03, 0x78, 0x15, 0x05, 0xFF, 0x05, 0x07, 0x97, 0x28, 0x43,
  0x10, 0xF7, 0x79, 0x72, 0x98, 0x37, 0x0F, 0x77, 0x98, 0x05, 0xB9, 0x83, 0xDB, 0xF7, 0x79, 0x80,
  0x90, 0xB9, 0x00, 0x79, 0x20, 0x06, 0x71, 0x98, 0x37, 0x7F, 0x09, 0xA0, 0x97, 0x98, 0x37, 0x7F,
  0x0C, 0xA0, 0xC7, 0x98, 0x37, 0x7F, 0x06, 0xA0, 0x67, 0x90, 0x07, 0x92, 0x00, 0x17, 0x19, 0x07,
  0x05, 0xFF, 0x81, 0x50, 0x58, 0x09, 0x07, 0x05, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_radio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_radio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_recent_actors 18x18, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_outlined_18_av_recent_actors_data[] PROGMEM = {
  0x18, 0x06, 0x31, 0x85, 0x13, 0x11, 0x31, 0x3F, 0xB8, 0x90, 0x33, 0xF3, 0x3F, 0x33, 0xF6, 0x80,
  0x23, 0x8B, 0x66, 0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x30, 0x2D, 0xD2, 0x03, 0xF3, 0x3F, 0x33, 0xF3,
  0x3F, 0x30, 0x6A, 0x8B, 0x66, 0x03, 0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x30, 0x1B, 0xB1, 0x03, 0xF3,
  0x3F, 0x33, 0xF3, 0x3F, 0x36, 0x8B, 0x53, 0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x32, 0xAD, 0xDA, 0x23,
  0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x3D, 0xC8, 0x93, 0xD3, 0xF3, 0x3F, 0x33, 0xF3, 0x3F, 0x68, 0x02,
  0x38, 0x90, 0x6F, 0x33, 0xF3, 0x3F, 0x33, 0xFB, 0x85, 0x33, 0xF3, 0x3F, 0x31, 0x80, 0x63, 0x18,
  0x41, 0x31, 0x13, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_recent_actors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_recent_actors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_remove_from_queue 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_outlined_18_av_remove_from_queue_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x02, 0x73,
  0x84, 0x3F, 0x33, 0xF3, 0x3E, 0x38, 0x43, 0xF3, 0x3F, 0x37, 0x58, 0x43, 0xF3, 0x3F, 0x37, 0x58,
  0x43, 0xF3, 0x3F, 0x37, 0x58, 0x43, 0xF3, 0x3F, 0x68, 0x09, 0x03, 0x83, 0x6F, 0x31, 0xEF, 0xF8,
  0x2E, 0x10, 0x18, 0x00, 0x3E, 0x80, 0x03, 0x71, 0x80, 0x2B, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_remove_from_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_remove_from_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_repeat_one_on 18x18, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_outlined_18_av_repeat_one_on_data[] PROGMEM = {
  0x28, 0x09, 0x21, 0x30, 0xCF, 0xB0, 0xEB, 0x81, 0xC0, 0x1F, 0xB8, 0x1D, 0x1A, 0xB0, 0x01, 0xA0,
  0xE8, 0x04, 0xD8, 0x14, 0x0A, 0xA0, 0x01, 0xA0, 0x97, 0x48, 0x2E, 0xF1, 0x1A, 0x09, 0x18, 0x03,
  0xD8, 0x14, 0x0A, 0xA0, 0x01, 0xA0, 0x91, 0xE8, 0x1D, 0x1A, 0xB0, 0x01, 0xA0, 0x91, 0xB0, 0x05,
  0xA0, 0xEC, 0x00, 0x1A, 0x0E, 0x0D, 0xB0, 0xD0, 0x1F, 0x00, 0x1F, 0x90, 0x1B, 0x0D, 0x0E, 0xA0,
  0x01, 0xC0, 0xEB, 0x05, 0xB1, 0x09, 0xA0, 0x01, 0xB8, 0x1A, 0x1D, 0xE1, 0x09, 0xA0, 0x01, 0xA8,
  0x1A, 0x04, 0x80, 0x3D, 0x10, 0x9A, 0x82, 0x11, 0xFE, 0x74, 0x09, 0xA0, 0x01, 0xA8, 0x1A, 0x04,
  0x80, 0x4D, 0x0E, 0xA0, 0x01, 0xB8, 0x1A, 0x1D, 0xFB, 0x81, 0x10, 0xCB, 0x0E, 0xFB, 0x0C, 0x38,
  0x09, 0x21, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_repeat_one_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_av_repeat_one_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_repeat_one 18x18, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_outlined_18_av_repeat_one_data[] PROGMEM = {
  0x73, 0x01, 0x76, 0x03, 0x0B, 0x30, 0x18, 0x04, 0x38, 0x16, 0xFB, 0x20, 0x3F, 0xC8, 0x37, 0x03,
  0xF6, 0x80, 0x23, 0x81, 0x6F, 0xB2, 0x81, 0x3F, 0x32, 0x01, 0x02, 0x20, 0x30, 0xB3, 0x85, 0x3F,
  0x30, 0x4E, 0xB2, 0x01, 0x48, 0x51, 0x31, 0x01, 0x8B, 0x75, 0x05, 0x0B, 0x28, 0x11, 0x31, 0x40,
  0x12, 0x05, 0x0B, 0x28, 0x13, 0xF3, 0x30, 0xB0, 0x32, 0x01, 0x02, 0x28, 0x13, 0xF3, 0x28, 0x1B,
  0xF6, 0x80, 0x23, 0x83, 0x6F, 0x30, 0x7F, 0xC0, 0x32, 0x81, 0xBF, 0x68, 0x04, 0x30, 0x13, 0x0B,
  0x03, 0x76, 0x01, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_repeat_one() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_repeat_one_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_repeat_on 18x18, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_outlined_18_av_repeat_on_data[] PROGMEM = {
  0x28, 0x09, 0x21, 0x30, 0xCF, 0xB0, 0xEB, 0x81, 0xC0, 0x1F, 0xB8, 0x1D, 0x1A, 0xB0, 0x01, 0xA0,
  0xE8, 0x04, 0xD8, 0x14, 0x0A, 0xA0, 0x01, 0xA0, 0x97, 0x48, 0x2E, 0xF1, 0x1A, 0x09, 0x18, 0x03,
  0xD8, 0x14, 0x0A, 0xA0, 0x01, 0xA0, 0x91, 0xE8, 0x1D, 0x1A, 0xB0, 0x01, 0xA0, 0x91, 0xF0, 0xEC,
  0x00, 0x1A, 0x0E, 0x0D, 0xFD, 0x00, 0x1F, 0xD0, 0xD0, 0xEA, 0x00, 0x1C, 0x0E, 0xF1, 0x09, 0xA0,
  0x01, 0xB8, 0x1A, 0x1D, 0xE1, 0x09, 0xA0, 0x01, 0xA8, 0x1A, 0x04, 0x80, 0x3D, 0x10, 0x9A, 0x82,
  0x11, 0xFE, 0x74, 0x09, 0xA0, 0x01, 0xA8, 0x1A, 0x04, 0x80, 0x4D, 0x0E, 0xA0, 0x01, 0xB8, 0x1A,
  0x1D, 0xFB, 0x81, 0x10, 0xCB, 0x0E, 0xFB, 0x0C, 0x38, 0x09, 0x21, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_repeat_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_av_repeat_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_repeat 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_outlined_18_av_repeat_data[] PROGMEM = {
  0x73, 0x01, 0x76, 0x03, 0x0B, 0x30, 0x18, 0x04, 0x38, 0x16, 0xFB, 0x20, 0x3F, 0xC8, 0x37, 0x03,
  0xF6, 0x80, 0x23, 0x81, 0x6F, 0xB2, 0x81, 0x3F, 0x36, 0x03, 0x0B, 0x38, 0x13, 0xF3, 0x60, 0x14,
  0x81, 0x13, 0x17, 0x76, 0x81, 0x13, 0x14, 0x01, 0x68, 0x13, 0xF3, 0x30, 0xB0, 0x36, 0x81, 0x3F,
  0x32, 0x81, 0xBF, 0x68, 0x02, 0x38, 0x36, 0xF3, 0x07, 0xFC, 0x03, 0x28, 0x1B, 0xF6, 0x80, 0x43,
  0x01, 0x30, 0xB0, 0x37, 0x60, 0x17, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_repeat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 15, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_repeat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_replay_10 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_outlined_18_av_replay_10_data[] PROGMEM = {
  0x50, 0xB7, 0x30, 0xB9, 0x72, 0x0B, 0xA0, 0x37, 0x07, 0xD0, 0xA0, 0x25, 0x0B, 0xA8, 0x35, 0x8E,
  0xE3, 0x50, 0xB9, 0x28, 0x22, 0xDE, 0x15, 0x0B, 0x38, 0x13, 0xF8, 0x58, 0x11, 0x02, 0x28, 0x96,
  0xBC, 0x32, 0x01, 0xB2, 0x98, 0x30, 0x8E, 0xE9, 0x28, 0x90, 0x72, 0x94, 0x50, 0xAE, 0xBD, 0x28,
  0x91, 0x72, 0x7A, 0x20, 0xDA, 0x4F, 0x86, 0x86, 0x8F, 0x40, 0xAF, 0x91, 0x28, 0x21, 0x9F, 0x93,
  0x09, 0xA0, 0x0D, 0xA0, 0x95, 0x84, 0x28, 0xAA, 0x82, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_replay_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_replay_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_replay_30 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_outlined_18_av_replay_30_data[] PROGMEM = {
  0x50, 0xB7, 0x30, 0xB9, 0x72, 0x0B, 0xA0, 0x37, 0x07, 0xD0, 0xA0, 0x25, 0x0B, 0xA8, 0x35, 0x8E,
  0xE3, 0x50, 0xB9, 0x28, 0x22, 0xDE, 0x15, 0x0B, 0x38, 0x13, 0xF8, 0x40, 0x32, 0x03, 0x28, 0x96,
  0xBD, 0x32, 0x03, 0x68, 0x87, 0x50, 0x8F, 0xEA, 0x28, 0xA5, 0x76, 0x92, 0x70, 0xAE, 0xBD, 0x04,
  0x97, 0x69, 0x40, 0xDB, 0x4F, 0x86, 0x86, 0x8F, 0x40, 0xAF, 0x91, 0x28, 0x21, 0x9F, 0xA3, 0x09,
  0xA0, 0x0D, 0xA0, 0x95, 0x84, 0x28, 0xAA, 0x82, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_replay_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_replay_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_replay_5 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_av_replay_5_data[] PROGMEM = {
  0x50, 0xB7, 0x30, 0xB9, 0x72, 0x0B, 0xA0, 0x37, 0x07, 0xD0, 0xA0, 0x25, 0x0B, 0xA8, 0x35, 0x8E,
  0xE3, 0x50, 0xB9, 0x28, 0x22, 0xDE, 0x15, 0x0B, 0x38, 0x13, 0xF8, 0x50, 0x03, 0x38, 0x2B, 0xD3,
  0x23, 0x0A, 0x06, 0x38, 0x28, 0xFE, 0xA3, 0x06, 0x0A, 0x38, 0x2A, 0xEB, 0xD3, 0x09, 0x0A, 0x38,
  0x3D, 0xB4, 0xF8, 0x68, 0x68, 0xF4, 0x0A, 0xF9, 0x12, 0x82, 0x19, 0xFA, 0x30, 0x9A, 0x00, 0xDA,
  0x09, 0x58, 0x42, 0x8A, 0xA8, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_replay_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_replay_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_replay_circle_filled 18x18, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_outlined_18_av_replay_circle_filled_data[] PROGMEM = {
  0x70, 0x02, 0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x09, 0xB0, 0x06, 0xB0, 0x95, 0x09, 0xB8, 0x16,
  0x0A, 0xC0, 0x93, 0x03, 0xB0, 0x83, 0x04, 0x0C, 0xB0, 0x32, 0x0B, 0xB8, 0x5E, 0x30, 0x63, 0x0B,
  0xA0, 0xB2, 0xD8, 0x4E, 0x34, 0xF4, 0x2B, 0x10, 0x2E, 0x84, 0xEE, 0xFC, 0x0D, 0xA0, 0x02, 0xA8,
  0x1D, 0x3D, 0xC8, 0x1D, 0x0C, 0xA0, 0x21, 0xA8, 0x1E, 0x08, 0xC8, 0x18, 0x0E, 0xA2, 0x0B, 0xA8,
  0x17, 0x0A, 0xA8, 0x1A, 0x07, 0xA0, 0xB2, 0x03, 0xB0, 0x64, 0x06, 0xB0, 0x33, 0x09, 0xB8, 0x2C,
  0x99, 0xCB, 0x09, 0x50, 0x9F, 0x90, 0x97, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x40, 0x02, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_replay_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_replay_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_replay 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_outlined_18_av_replay_data[] PROGMEM = {
  0x50, 0xB7, 0x30, 0xB9, 0x72, 0x0B, 0xA0, 0x37, 0x07, 0xD0, 0xA0, 0x25, 0x0B, 0xA8, 0x35, 0x8E,
  0xE3, 0x50, 0xB9, 0x28, 0x22, 0xDE, 0x15, 0x0B, 0x38, 0x13, 0xF8, 0x73, 0x82, 0xBD, 0x32, 0x71,
  0x82, 0x8F, 0xEA, 0x71, 0x82, 0xAE, 0xBD, 0x71, 0x83, 0xDB, 0x4F, 0x86, 0x86, 0x8F, 0x40, 0xAF,
  0x91, 0x28, 0x21, 0x9F, 0xA3, 0x09, 0xA0, 0x0D, 0xA0, 0x95, 0x84, 0x28, 0xAA, 0x82, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_replay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_replay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_sd 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_outlined_18_av_sd_data[] PROGMEM = {
  0x10, 0x38, 0x09, 0x05, 0x81, 0x30, 0x1F, 0xF8, 0x21, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27,
  0x38, 0x98, 0x42, 0xF3, 0x3F, 0x20, 0x6B, 0xB0, 0x1B, 0xB4, 0x02, 0xF3, 0x3F, 0x20, 0x98, 0x80,
  0x1C, 0x69, 0x02, 0xF3, 0x3F, 0x20, 0x47, 0xD1, 0x1C, 0x69, 0x02, 0xF3, 0x3F, 0x20, 0x6B, 0xB0,
  0x1B, 0xB4, 0x02, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x1F, 0xF8,
  0x11, 0x03, 0x80, 0x90, 0x50, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_sd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_sd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_shuffle_on 18x18, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_outlined_18_av_shuffle_on_data[] PROGMEM = {
  0x28, 0x09, 0x21, 0x30, 0xCF, 0xF8, 0x1C, 0x01, 0xFF, 0xA0, 0x01, 0xB0, 0xDD, 0x83, 0xE9, 0x99,
  0xDA, 0x00, 0x1A, 0x81, 0xD0, 0x8C, 0x0C, 0x30, 0x9A, 0x00, 0x1B, 0x81, 0x80, 0x8C, 0x08, 0x20,
  0x9A, 0x00, 0x1C, 0x81, 0x80, 0x8A, 0x83, 0x80, 0x80, 0x9A, 0x00, 0x1D, 0x87, 0x85, 0xF8, 0x08,
  0xFB, 0xDA, 0x00, 0x1F, 0x81, 0x80, 0x8E, 0x00, 0x1E, 0x81, 0x80, 0x8F, 0x00, 0x1D, 0x87, 0x80,
  0x8F, 0x58, 0xFB, 0xDA, 0x00, 0x1C, 0x81, 0x80, 0x8A, 0x83, 0x80, 0x80, 0x9A, 0x00, 0x1B, 0x81,
  0x80, 0x8C, 0x08, 0x20, 0x9A, 0x00, 0x1A, 0x81, 0xD0, 0x8C, 0x0C, 0x30, 0x9A, 0x00, 0x1B, 0x0D,
  0xD8, 0x3E, 0x99, 0x9D, 0xA0, 0x01, 0xFF, 0xA8, 0x11, 0x0C, 0xFF, 0x0C, 0x38, 0x09, 0x21, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_shuffle_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 17, 17), Box(0, 0, 17, 17),
      ic_outlined_18_av_shuffle_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_shuffle 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_outlined_18_av_shuffle_data[] PROGMEM = {
  0x06, 0x08, 0x60, 0x9B, 0x81, 0x8F, 0x86, 0x0C, 0xA1, 0x81, 0x8F, 0x84, 0x81, 0x8F, 0xC9, 0x28,
  0x18, 0xF8, 0x28, 0x38, 0xF8, 0x09, 0x38, 0x48, 0x50, 0x8F, 0x87, 0x18, 0x18, 0xF8, 0x71, 0x81,
  0x8F, 0x87, 0x18, 0x48, 0xF8, 0x05, 0x85, 0x81, 0x8F, 0x82, 0x87, 0x8F, 0x80, 0x90, 0x8F, 0x84,
  0x85, 0x8F, 0xCF, 0x8F, 0x86, 0x0C, 0xA0, 0x60, 0x86, 0x09, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_shuffle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 14, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_shuffle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_skip_next 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_outlined_18_av_skip_next_data[] PROGMEM = {
  0x02, 0x78, 0x37, 0x37, 0xC2, 0x59, 0x83, 0x77, 0xFE, 0x54, 0x98, 0x57, 0x7F, 0xBF, 0xA1, 0x29,
  0x8B, 0x17, 0x7F, 0x07, 0xFD, 0x40, 0xF7, 0x7F, 0x07, 0xFD, 0x40, 0xF7, 0x7F, 0xBF, 0xA1, 0x29,
  0x83, 0x77, 0xFE, 0x54, 0x98, 0x27, 0x7C, 0x25, 0x90, 0x70, 0x27, 0x07, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_skip_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_skip_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_skip_previous 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_outlined_18_av_skip_previous_data[] PROGMEM = {
  0x03, 0x07, 0x70, 0x20, 0x79, 0x58, 0x22, 0xC7, 0x79, 0x48, 0x35, 0xEF, 0x77, 0x92, 0x8B, 0x11,
  0xAF, 0xBF, 0x77, 0xF0, 0x4D, 0xF7, 0x0F, 0x77, 0xF0, 0x4D, 0xF7, 0x0F, 0x77, 0x92, 0x85, 0x1A,
  0xFB, 0xF7, 0x79, 0x48, 0x35, 0xEF, 0x77, 0x95, 0x83, 0x2C, 0x73, 0x77, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_skip_previous() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_skip_previous_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_slow_motion_video 18x18, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_outlined_18_av_slow_motion_video_data[] PROGMEM = {
  0x58, 0x41, 0x51, 0x14, 0x17, 0x10, 0x10, 0x9A, 0x00, 0x3A, 0x09, 0x01, 0x68, 0x26, 0xF9, 0x32,
  0x83, 0x38, 0xFD, 0x23, 0x82, 0x16, 0x01, 0x68, 0x22, 0xDD, 0x12, 0x81, 0x9F, 0x12, 0x01, 0x58,
  0x52, 0xF9, 0x01, 0xF9, 0x30, 0x70, 0x95, 0x84, 0x8F, 0x15, 0xF3, 0x38, 0x27, 0xFC, 0x23, 0x83,
  0x3F, 0x51, 0x34, 0x07, 0xA0, 0xE0, 0x53, 0x98, 0x17, 0x13, 0x40, 0x7A, 0x0E, 0x05, 0x39, 0x82,
  0x75, 0xF3, 0x38, 0x27, 0xFC, 0x23, 0x84, 0x3F, 0x51, 0xF9, 0x30, 0x70, 0x95, 0x85, 0x8F, 0x10,
  0x9F, 0x12, 0x01, 0x58, 0x12, 0xF9, 0x28, 0x21, 0x60, 0x16, 0x82, 0x2D, 0xD1, 0x48, 0x26, 0xF9,
  0x32, 0x83, 0x38, 0xFD, 0x25, 0x01, 0x09, 0xA0, 0x03, 0xA0, 0x90, 0x17, 0x18, 0x41, 0x51, 0x14,
  0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_slow_motion_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_slow_motion_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_snooze 18x18, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_outlined_18_av_snooze_data[] PROGMEM = {
  0x30, 0x30, 0x26, 0x02, 0x03, 0x58, 0x16, 0xFA, 0x68, 0x1A, 0xF6, 0x38, 0xC3, 0x8F, 0xB1, 0x7C,
  0xEE, 0xC7, 0x1B, 0xF8, 0x03, 0xF8, 0x4E, 0xFB, 0x88, 0xBF, 0xE4, 0x8F, 0x30, 0x23, 0xFC, 0x24,
  0x83, 0x2C, 0xF3, 0x23, 0x89, 0x2D, 0xD1, 0x13, 0x33, 0x31, 0x1D, 0xD3, 0x83, 0x5F, 0x40, 0x3C,
  0x83, 0x30, 0x4F, 0x52, 0x09, 0x0E, 0x28, 0x31, 0x34, 0xDD, 0x30, 0xE0, 0x92, 0x0B, 0x0C, 0x48,
  0x19, 0xE1, 0x30, 0xC0, 0xB2, 0x0A, 0x0C, 0x38, 0x17, 0xE3, 0x40, 0xC0, 0xA2, 0x89, 0x47, 0xF1,
  0x02, 0xFE, 0xBB, 0x20, 0x1F, 0x72, 0x89, 0x42, 0xF8, 0x02, 0xBB, 0xBB, 0x20, 0x8F, 0x23, 0x81,
  0x8F, 0x56, 0x81, 0x5F, 0x85, 0x82, 0xBF, 0xA3, 0x28, 0x23, 0xAF, 0xB7, 0x07, 0x0E, 0xC0, 0xE0,
  0x77, 0x38, 0x24, 0x77, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_snooze() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_snooze_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_sort_by_alpha 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_outlined_18_av_sort_by_alpha_data[] PROGMEM = {
  0x71, 0x01, 0x77, 0x81, 0x5E, 0x37, 0x60, 0xF7, 0x72, 0x01, 0x03, 0x48, 0x02, 0x34, 0x81, 0xBF,
  0x13, 0x80, 0x0D, 0x81, 0xEF, 0x32, 0x82, 0x2F, 0xD7, 0x68, 0x11, 0xDA, 0x38, 0x28, 0xB5, 0xD6,
  0x81, 0xAD, 0x13, 0x83, 0xD5, 0x0E, 0x44, 0x81, 0x5F, 0x43, 0x04, 0x0E, 0x20, 0x90, 0xA3, 0x81,
  0x1E, 0x94, 0x85, 0xAE, 0xBB, 0xDF, 0x12, 0x0B, 0x0D, 0x48, 0x92, 0x1F, 0x97, 0x77, 0xD7, 0x06,
  0xF3, 0x40, 0x70, 0xD4, 0x89, 0x27, 0xD0, 0xEF, 0xDD, 0xDD, 0x52, 0x24, 0x01, 0x03, 0x18, 0x02,
  0x30, 0x17, 0x0F, 0x77, 0x68, 0x15, 0xE3, 0x77, 0x01, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_sort_by_alpha() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_sort_by_alpha_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_speed 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_outlined_18_av_speed_data[] PROGMEM = {
  0x48, 0x61, 0x7C, 0xDD, 0xB7, 0x17, 0x87, 0x6E, 0xFB, 0x99, 0xBF, 0x86, 0x82, 0x7F, 0xB1, 0x60,
  0x34, 0x81, 0x4F, 0x97, 0x82, 0x96, 0x02, 0x20, 0xC0, 0xD6, 0x89, 0x04, 0xDB, 0x06, 0xC0, 0x2F,
  0x65, 0x89, 0x19, 0xFE, 0x20, 0x6F, 0x25, 0xF2, 0x30, 0x20, 0xDA, 0x06, 0x28, 0x41, 0xF5, 0x7F,
  0x13, 0x06, 0xA0, 0xB4, 0x98, 0x27, 0x6F, 0x13, 0x82, 0x2D, 0xD2, 0x38, 0x42, 0xF5, 0x2F, 0x67,
  0x38, 0x45, 0xF2, 0x0C, 0xD8, 0x06, 0x70, 0xD0, 0xC2, 0x03, 0x0E, 0xFB, 0x0E, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_speed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_speed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_stop_circle 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_outlined_18_av_stop_circle_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x58, 0x90, 0x5F, 0xB4, 0x11, 0x4B, 0xF5,
  0x38, 0x13, 0xF8, 0x68, 0x18, 0xF3, 0x28, 0xA0, 0xBB, 0x08, 0xBB, 0xBB, 0x80, 0xBB, 0x01, 0xF4,
  0x0A, 0xC8, 0x90, 0xA0, 0x4F, 0x13, 0xF1, 0x0A, 0xC8, 0x90, 0xA0, 0x1F, 0x33, 0xF1, 0x0A, 0xC8,
  0x90, 0xA0, 0x1F, 0x31, 0xF4, 0x0A, 0xC8, 0xA0, 0xA0, 0x4F, 0x10, 0xBB, 0x08, 0xBB, 0xBB, 0x80,
  0xBB, 0x28, 0x13, 0xF8, 0x68, 0x18, 0xF3, 0x38, 0x90, 0x5F, 0xB4, 0x11, 0x4B, 0xF5, 0x50, 0x30,
  0xBC, 0x0B, 0x03, 0x71, 0x82, 0x13, 0x31, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_stop_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_stop_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_stop 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_outlined_18_av_stop_data[] PROGMEM = {
  0x03, 0x80, 0x47, 0x03, 0x07, 0xF9, 0x00, 0x79, 0x69, 0x00, 0x79, 0x69, 0x00, 0x79, 0x69, 0x00,
  0x79, 0x69, 0x00, 0x79, 0x69, 0x00, 0x79, 0x69, 0x00, 0x7F, 0x90, 0x70, 0x38, 0x04, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_subscriptions 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_subscriptions_data[] PROGMEM = {
  0x30, 0x38, 0x04, 0x70, 0x36, 0x07, 0xF9, 0x07, 0x77, 0x78, 0x09, 0x07, 0x4F, 0xD7, 0x75, 0x05,
  0x80, 0x90, 0x78, 0x15, 0x05, 0xFF, 0x05, 0x07, 0x94, 0x02, 0x79, 0x00, 0x79, 0x48, 0x17, 0xD5,
  0x59, 0x00, 0x79, 0x40, 0x7A, 0x0C, 0x04, 0x39, 0x00, 0x79, 0x40, 0x7A, 0x0C, 0x04, 0x39, 0x00,
  0x79, 0x48, 0x17, 0xD5, 0x59, 0x00, 0x79, 0x40, 0x27, 0x90, 0x70, 0x5F, 0xF8, 0x15, 0x05, 0x80,
  0x90, 0x70, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_subscriptions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_subscriptions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_subtitles 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_subtitles_data[] PROGMEM = {
  0x02, 0x0D, 0xFD, 0x81, 0xD2, 0x79, 0x80, 0x90, 0x79, 0x00, 0x79, 0x75, 0x90, 0x07, 0x97, 0x59,
  0x86, 0x77, 0xF0, 0x37, 0x03, 0x80, 0x17, 0x89, 0x13, 0x0F, 0x77, 0xF0, 0x7F, 0x07, 0xD8, 0x37,
  0x0F, 0x77, 0x97, 0x59, 0x83, 0x77, 0xF0, 0x38, 0x01, 0x78, 0x91, 0x30, 0x73, 0x0F, 0x77, 0xF0,
  0x7D, 0x86, 0x70, 0xF7, 0x0F, 0x77, 0x97, 0x59, 0x00, 0x79, 0x80, 0x90, 0x79, 0x81, 0x72, 0xDF,
  0xD0, 0xD0, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_subtitles() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_subtitles_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_surround_sound 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_outlined_18_av_surround_sound_data[] PROGMEM = {
  0x02, 0x0D, 0xFD, 0x81, 0xD2, 0x79, 0x80, 0x90, 0x79, 0x00, 0x79, 0x20, 0x66, 0x06, 0x29, 0x89,
  0xC0, 0x77, 0xF0, 0x9E, 0x02, 0x88, 0x20, 0xD9, 0x0F, 0x77, 0xF0, 0xE6, 0x2E, 0xEE, 0xE2, 0x6E,
  0x0F, 0x77, 0xF3, 0xF2, 0x8E, 0x11, 0xE8, 0x2F, 0x3F, 0x77, 0xF3, 0xF2, 0x8E, 0x11, 0xE8, 0x2F,
  0x3F, 0x77, 0xF0, 0xE6, 0x2E, 0xEE, 0xE2, 0x6E, 0x0F, 0x77, 0xF0, 0x9D, 0x02, 0x88, 0x20, 0xE9,
  0x0F, 0x77, 0x92, 0x06, 0x60, 0x62, 0x90, 0x07, 0x98, 0x09, 0x07, 0x98, 0x17, 0x2D, 0xFD, 0x0D,
  0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_surround_sound() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_surround_sound_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_video_call 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_outlined_18_av_video_call_data[] PROGMEM = {
  0x03, 0x80, 0x57, 0x03, 0x30, 0xBF, 0xA8, 0x4B, 0x01, 0x8B, 0xB2, 0x81, 0x13, 0x12, 0x82, 0xBB,
  0x1C, 0x0F, 0xB2, 0x81, 0x3F, 0x32, 0x89, 0x5B, 0xCC, 0xFB, 0xBB, 0x08, 0xCF, 0xC8, 0x0B, 0xB0,
  0xFB, 0x18, 0x58, 0xCF, 0xC8, 0x0B, 0xB0, 0xFB, 0x28, 0x13, 0xF3, 0x28, 0x1B, 0xCC, 0x90, 0xFB,
  0x28, 0x11, 0x31, 0x28, 0x4B, 0xB1, 0xCB, 0xBF, 0xA8, 0x3B, 0x01, 0x83, 0x80, 0x57, 0x03, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_videocam_off 18x18, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_outlined_18_av_videocam_off_data[] PROGMEM = {
  0x10, 0x57, 0x68, 0x13, 0xFA, 0x76, 0x81, 0x7F, 0xA7, 0x58, 0x23, 0xDF, 0xA2, 0x80, 0x07, 0x03,
  0x40, 0xBB, 0x82, 0xA0, 0x3E, 0xA8, 0x91, 0xB0, 0x18, 0x0B, 0xB0, 0x7F, 0xA3, 0x86, 0xBB, 0x1C,
  0xB0, 0xBB, 0x28, 0x17, 0xFA, 0x28, 0x6B, 0xCC, 0xFB, 0x0B, 0xB3, 0x84, 0x7F, 0xA0, 0x3E, 0xA8,
  0x2B, 0x0B, 0xB4, 0x89, 0x17, 0xFA, 0x03, 0xEF, 0xB0, 0xBB, 0x58, 0x90, 0x7F, 0xA0, 0x3E, 0xB0,
  0xBB, 0x68, 0x67, 0xFA, 0x03, 0xA0, 0xBF, 0xB8, 0x3A, 0x01, 0x03, 0x80, 0x57, 0x81, 0x8F, 0xA7,
  0x68, 0x17, 0xF8, 0x76, 0x06, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_videocam_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_videocam_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_videocam 18x18, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_outlined_18_av_videocam_data[] PROGMEM = {
  0x03, 0x80, 0x57, 0x03, 0x30, 0xBF, 0xA8, 0x4B, 0x01, 0x8B, 0xB7, 0x82, 0xBB, 0x1C, 0x0F, 0xB7,
  0x81, 0xBC, 0xC9, 0x0F, 0xB7, 0x0B, 0xB0, 0xFB, 0x70, 0xBB, 0x0F, 0xB7, 0x81, 0xBC, 0xC9, 0x0F,
  0xB7, 0x84, 0xBB, 0x1C, 0xBB, 0xFA, 0x83, 0xB0, 0x18, 0x38, 0x05, 0x70, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_videocam() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_outlined_18_av_videocam_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_video_file 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_outlined_18_av_video_file_data[] PROGMEM = {
  0x10, 0x18, 0x02, 0x34, 0x02, 0xF0, 0x73, 0x85, 0x6E, 0x11, 0x11, 0x3A, 0x07, 0x20, 0x60, 0xE4,
  0x01, 0xB8, 0x27, 0x06, 0xE4, 0x01, 0xC8, 0x14, 0x6E, 0x50, 0xF3, 0x82, 0xE6, 0x6E, 0x71, 0x82,
  0xE6, 0x6E, 0x71, 0x84, 0xE6, 0x6E, 0x09, 0xB8, 0x74, 0x30, 0xE6, 0x6E, 0x0A, 0xB8, 0x7D, 0xA0,
  0xE6, 0x6E, 0x0A, 0xB8, 0x7E, 0xA0, 0xE6, 0x6E, 0x0A, 0xB8, 0x55, 0x30, 0xE6, 0x6E, 0x71, 0x82,
  0xE6, 0x6E, 0x80, 0x41, 0x81, 0xE6, 0x2F, 0xB8, 0x12, 0x01, 0x80, 0x43, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_video_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_video_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_video_label 18x18, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_outlined_18_av_video_label_data[] PROGMEM = {
  0x10, 0x78, 0x09, 0x2B, 0x83, 0x70, 0x2F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x23, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33,
  0xF3, 0x75, 0x82, 0x3F, 0x33, 0xFF, 0xA0, 0x03, 0xFF, 0xA0, 0x30, 0x2F, 0xFA, 0x81, 0x20, 0x78,
  0x09, 0x2B, 0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_video_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_video_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_video_library 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_outlined_18_av_video_library_data[] PROGMEM = {
  0x40, 0x58, 0x05, 0x70, 0x54, 0x05, 0xFC, 0x05, 0x30, 0x79, 0x72, 0x98, 0x37, 0x37, 0x07, 0x93,
  0x07, 0x59, 0x83, 0x77, 0xF0, 0x79, 0x39, 0x0B, 0x01, 0x39, 0x83, 0x77, 0xF0, 0x79, 0x3A, 0x0E,
  0x04, 0x29, 0x83, 0x77, 0xF0, 0x79, 0x3C, 0x86, 0x20, 0xF7, 0x7F, 0x07, 0x93, 0xA0, 0xE0, 0x42,
  0x98, 0x37, 0x7F, 0x07, 0x93, 0x90, 0xB0, 0x13, 0x98, 0x37, 0x7F, 0x07, 0x93, 0x07, 0x59, 0x83,
  0x77, 0xF0, 0x79, 0x72, 0x98, 0x37, 0x7F, 0x05, 0xFC, 0x05, 0x07, 0x92, 0x05, 0x80, 0x57, 0x81,
  0x50, 0x79, 0x77, 0x05, 0xFC, 0x07, 0x40, 0x58, 0x06, 0x70, 0x33,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_video_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_video_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_video_settings 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_outlined_18_av_video_settings_data[] PROGMEM = {
  0x10, 0x48, 0x09, 0x05, 0x04, 0x20, 0x20, 0xD8, 0x09, 0x07, 0x83, 0xD2, 0x03, 0xA7, 0x58, 0x3A,
  0x30, 0x3A, 0x40, 0x57, 0x83, 0xA3, 0x03, 0xA4, 0x81, 0xCC, 0x25, 0x83, 0xA3, 0x03, 0xA4, 0x0C,
  0xA0, 0x74, 0x01, 0x20, 0x30, 0xA4, 0x0C, 0xA0, 0x73, 0x00, 0x12, 0x03, 0x0A, 0x48, 0x1C, 0xC2,
  0x28, 0x21, 0x0F, 0xB2, 0x03, 0x0A, 0x40, 0x54, 0x0D, 0x0E, 0xA8, 0x2E, 0x93, 0xA7, 0x18, 0x71,
  0xCF, 0x59, 0xF8, 0x2D, 0x80, 0x27, 0x06, 0x28, 0x6B, 0xF3, 0x8F, 0x70, 0x48, 0x03, 0x52, 0x0D,
  0xC0, 0xA7, 0x48, 0x42, 0x1F, 0xB1, 0x17, 0x60, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_video_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 17, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_video_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_volume_down 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_outlined_18_av_volume_down_data[] PROGMEM = {
  0x60, 0x10, 0x57, 0x18, 0x11, 0xD7, 0x78, 0x21, 0xDF, 0x73, 0x89, 0x21, 0x33, 0x4D, 0xEF, 0x70,
  0xA0, 0x3B, 0x8B, 0x4E, 0x3F, 0x70, 0xF7, 0x3F, 0x63, 0x10, 0xF7, 0x0F, 0xC3, 0xF6, 0x31, 0x0F,
  0x70, 0xFC, 0x3B, 0x89, 0x7E, 0x3F, 0x70, 0xF7, 0x13, 0x34, 0xDE, 0xF7, 0x0A, 0x58, 0x21, 0xDF,
  0x77, 0x18, 0x11, 0xD7, 0x72, 0x01, 0x05, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_volume_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 13, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_volume_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_volume_mute 18x18, 4-bit Alpha,  RLE, 34 bytes.
static const unsigned char ic_outlined_18_av_volume_mute_data[] PROGMEM = {
  0x60, 0x75, 0x07, 0x94, 0x07, 0xA8, 0x62, 0x33, 0x8F, 0xEF, 0xBB, 0x8A, 0x09, 0x7F, 0xBC, 0x33,
  0x07, 0xFB, 0xC3, 0x30, 0x7F, 0xBB, 0x87, 0x97, 0xF2, 0x33, 0x8F, 0xE9, 0x40, 0x7A, 0x50, 0x79,
  0x60, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_volume_mute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 11, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_volume_mute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_volume_off 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_outlined_18_av_volume_off_data[] PROGMEM = {
  0x02, 0x07, 0x60, 0x03, 0x48, 0x17, 0xF8, 0x38, 0x47, 0x07, 0xFB, 0x13, 0x83, 0x8F, 0x80, 0x29,
  0x28, 0x26, 0xED, 0x13, 0x83, 0x8F, 0x80, 0x53, 0x89, 0x03, 0xEB, 0x02, 0x33, 0xCF, 0x82, 0x85,
  0x64, 0x07, 0xF3, 0xBB, 0x84, 0xCF, 0x80, 0x4E, 0x29, 0x8A, 0x38, 0xBC, 0x33, 0x0A, 0xF8, 0x05,
  0x40, 0xCA, 0xBC, 0x33, 0x07, 0xA0, 0x83, 0x81, 0xCA, 0xBB, 0x84, 0x97, 0xF8, 0xF8, 0x29, 0x89,
  0x58, 0x23, 0x38, 0xFE, 0xF0, 0x8F, 0x80, 0x53, 0x40, 0x7A, 0x28, 0x18, 0xF8, 0x70, 0x79, 0x20,
  0x6A, 0x08, 0x78, 0x67, 0x07, 0xFA, 0x9F, 0x77, 0x10, 0x03, 0x20, 0x70, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_volume_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_volume_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_volume_up 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_outlined_18_av_volume_up_data[] PROGMEM = {
  0x71, 0x00, 0x37, 0x38, 0x47, 0x07, 0xFB, 0x17, 0x07, 0x92, 0x82, 0x6E, 0xD1, 0x50, 0x7A, 0x38,
  0xA1, 0x3E, 0xB0, 0x23, 0x38, 0xFE, 0xF0, 0x64, 0x07, 0xF3, 0xBB, 0x84, 0x97, 0xF0, 0x7E, 0x29,
  0x8B, 0x48, 0xBC, 0x33, 0x07, 0xF0, 0x7F, 0x40, 0xCA, 0xBC, 0x33, 0x07, 0xF0, 0x7F, 0x40, 0xCA,
  0xBB, 0x84, 0x97, 0xF0, 0x7E, 0x29, 0x89, 0x58, 0x23, 0x38, 0xFE, 0xF0, 0x63, 0x07, 0xF3, 0x40,
  0x7A, 0x38, 0x13, 0xEB, 0x60, 0x79, 0x28, 0x26, 0xED, 0x17, 0x84, 0x70, 0x7F, 0xB1, 0x73, 0x00,
  0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_volume_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_outlined_18_av_volume_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_web_asset_off 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_outlined_18_av_web_asset_off_data[] PROGMEM = {
  0x00, 0x77, 0x78, 0x36, 0xF7, 0x01, 0x80, 0x55, 0x81, 0x30, 0x1A, 0x81, 0x70, 0x9F, 0xA0, 0x10,
  0x3B, 0x81, 0x70, 0x9F, 0x98, 0x53, 0x3F, 0x57, 0xF7, 0x18, 0x02, 0x38, 0x90, 0x5F, 0x33, 0xF2,
  0x06, 0xF7, 0x68, 0x42, 0xF3, 0x3F, 0x22, 0x81, 0x6F, 0x75, 0x84, 0x2F, 0x33, 0xF2, 0x38, 0x16,
  0xF7, 0x48, 0x42, 0xF3, 0x3F, 0x24, 0x81, 0x6F, 0x73, 0x84, 0x2F, 0x33, 0xF2, 0x58, 0x16, 0xF7,
  0x28, 0x42, 0xF3, 0x3F, 0x26, 0x86, 0x6F, 0x70, 0x2F, 0x31, 0xFC, 0x84, 0x70, 0x81, 0x03, 0x80,
  0x55, 0x81, 0x7F, 0x77, 0x78, 0x16, 0xF7, 0x77, 0x06, 0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_web_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_outlined_18_av_web_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_web_asset 18x18, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_outlined_18_av_web_asset_data[] PROGMEM = {
  0x04, 0x0E, 0xFB, 0x81, 0xE4, 0xBF, 0xD0, 0x0B, 0xFD, 0x0F, 0xB7, 0x38, 0x00, 0xB7, 0x38, 0x00,
  0xB7, 0x38, 0x00, 0xB7, 0x38, 0x00, 0xB7, 0x38, 0x00, 0xB7, 0x38, 0x00, 0xB7, 0x30, 0xFB, 0x0D,
  0x80, 0x67, 0x82, 0xDB, 0x4E, 0xFB, 0x0E, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_web_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_web_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_outlined_18_av_web 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_outlined_18_av_web_data[] PROGMEM = {
  0x02, 0x0D, 0xFD, 0x81, 0xD2, 0x7F, 0xF0, 0x07, 0xFF, 0x00, 0x79, 0x80, 0x3B, 0x86, 0xCF, 0xDB,
  0xBF, 0x77, 0x97, 0x81, 0x1F, 0x52, 0x90, 0x07, 0x97, 0x81, 0x1F, 0x52, 0x90, 0x07, 0x98, 0x03,
  0x98, 0x1A, 0xF5, 0x29, 0x00, 0x79, 0x80, 0x4D, 0x90, 0x52, 0x90, 0x07, 0x97, 0x81, 0x1F, 0x52,
  0x90, 0x07, 0x97, 0x81, 0x1F, 0x52, 0x90, 0x07, 0x98, 0x03, 0x78, 0x78, 0xFA, 0x77, 0xF7, 0x2D,
  0xFD, 0x0D, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_outlined_18_av_web() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_outlined_18_av_web_data, Alpha4(color::Black));
  return value;
}
