#include "av.h"

using namespace roo_display;

// Image file ic_filled_48_av_10k 48x48, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_filled_48_av_10k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCB, 0x7F, 0x6A, 0x0B, 0x01, 0x50, 0x10, 0xBB, 0x3A,
  0x0E, 0x02, 0x20, 0x5E, 0x6A, 0x01, 0x70, 0x1B, 0x3A, 0x05, 0x20, 0x20, 0xEE, 0x6A, 0x72, 0xB3,
  0x90, 0x83, 0x0C, 0xFB, 0x3A, 0x3B, 0x3B, 0x30, 0xB3, 0x09, 0xFC, 0x3A, 0x3B, 0x3B, 0x30, 0x12,
  0x05, 0xFD, 0x3A, 0x3B, 0x3B, 0x50, 0x20, 0xEF, 0xD3, 0xA3, 0xB3, 0xB5, 0x02, 0x0E, 0xFD, 0x3A,
  0x3B, 0x3B, 0x30, 0x12, 0x05, 0xFD, 0x3A, 0x3B, 0x3B, 0x30, 0xB3, 0x09, 0xFC, 0x3A, 0x72, 0xB3,
  0x90, 0x83, 0x0C, 0xFB, 0x3A, 0x01, 0x70, 0x1B, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xA3, 0xA0, 0xB0,
  0x15, 0x01, 0x0B, 0xB3, 0xA0, 0xE0, 0x22, 0x05, 0x80, 0xCB, 0x7F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0,
  0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA,
  0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_10k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_10k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_1k_plus 48x48, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_filled_48_av_1k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x2F, 0x6B, 0x3A, 0x0E, 0x02, 0x20, 0x5F, 0xFB,
  0x6B, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xFB, 0x6B, 0x39, 0x08, 0x30, 0xCC, 0x2F, 0xF9, 0x3B, 0x30,
  0xB3, 0x09, 0xD2, 0xFF, 0x93, 0xB3, 0x01, 0x20, 0x5E, 0x2F, 0xF9, 0x3B, 0x50, 0x20, 0xEB, 0x71,
  0xFD, 0x3B, 0x50, 0x20, 0xEB, 0x71, 0xFD, 0x3B, 0x30, 0x12, 0x05, 0xE2, 0xFF, 0x93, 0xB3, 0x0B,
  0x30, 0x9D, 0x2F, 0xF9, 0x3B, 0x39, 0x08, 0x30, 0xCC, 0x2F, 0xF9, 0x3B, 0x3A, 0x05, 0x20, 0x20,
  0xEF, 0xFE, 0x3B, 0x3A, 0x0E, 0x02, 0x20, 0x58, 0x0C, 0xC7, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A,
  0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_1k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_1k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_1k 48x48, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_filled_48_av_1k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x5F, 0x6C, 0x3A, 0x0E, 0x02, 0x20, 0x5F, 0xFA,
  0x6C, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xFA, 0x6C, 0x39, 0x08, 0x30, 0xCF, 0xFE, 0x3C, 0x30, 0xB3,
  0x09, 0xFF, 0xF3, 0xC3, 0x01, 0x20, 0x5F, 0xFF, 0x93, 0xC5, 0x02, 0x0E, 0xFF, 0xF9, 0x3C, 0x50,
  0x20, 0xEF, 0xFF, 0x93, 0xC3, 0x01, 0x20, 0x5F, 0xFF, 0x93, 0xC3, 0x0B, 0x30, 0x9F, 0xFF, 0x3C,
  0x39, 0x08, 0x30, 0xCF, 0xFE, 0x3C, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xFD, 0x3C, 0x3A, 0x0E, 0x02,
  0x20, 0x58, 0x0C, 0xC3, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF,
  0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_1k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_1k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_2k_plus 48x48, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_filled_48_av_2k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x0F, 0x70, 0x10, 0xBB, 0x3A, 0x0E, 0x02, 0x20,
  0x5F, 0xF7, 0x10, 0x1B, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xF7, 0x2B, 0x39, 0x08, 0x30, 0xCC, 0x2F,
  0xF9, 0x3B, 0x30, 0xB3, 0x09, 0xD2, 0xFF, 0x93, 0xB3, 0x01, 0x20, 0x5E, 0x2F, 0xA0, 0xB0, 0x16,
  0x01, 0xB5, 0x02, 0x0E, 0xB7, 0x1E, 0x01, 0x60, 0x10, 0xBB, 0x50, 0x20, 0xEB, 0x71, 0xE3, 0xFA,
  0x30, 0x12, 0x05, 0xE2, 0xFA, 0x3F, 0xA3, 0x0B, 0x30, 0x9D, 0x2F, 0xA7, 0x2B, 0x39, 0x08, 0x30,
  0xCC, 0x2F, 0xA7, 0x2B, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xF7, 0x2B, 0x3A, 0x0E, 0x02, 0x20, 0x58,
  0x0C, 0xC6, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8,
  0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_2k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_2k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_2k 48x48, 4-bit Alpha,  RLE, 131 bytes.
static const unsigned char ic_filled_48_av_2k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x3F, 0x70, 0x10, 0xBC, 0x3A, 0x0E, 0x02, 0x20,
  0x5F, 0xE7, 0x10, 0x1C, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xE7, 0x2C, 0x39, 0x08, 0x30, 0xCF, 0xFE,
  0x3C, 0x30, 0xB3, 0x09, 0xFF, 0xF3, 0xC3, 0x01, 0x20, 0x5F, 0xFA, 0x0B, 0x01, 0x60, 0x1C, 0x50,
  0x20, 0xEF, 0xFA, 0x01, 0x60, 0x10, 0xBC, 0x50, 0x20, 0xEF, 0xFA, 0x3F, 0xB3, 0x01, 0x20, 0x5F,
  0xFA, 0x3F, 0xB3, 0x0B, 0x30, 0x9F, 0xF9, 0x72, 0xC3, 0x90, 0x83, 0x0C, 0xFF, 0x72, 0xC3, 0xA0,
  0x52, 0x02, 0x0E, 0xFE, 0x72, 0xC3, 0xA0, 0xE0, 0x22, 0x05, 0x80, 0xCC, 0x2F, 0x0D, 0xFF, 0xFF,
  0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_2k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_2k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_3k_plus 48x48, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_filled_48_av_3k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x0F, 0x70, 0x10, 0xBB, 0x3A, 0x0E, 0x02, 0x20,
  0x5F, 0xF7, 0x10, 0x1B, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xF7, 0x2B, 0x39, 0x08, 0x30, 0xCC, 0x2F,
  0xF9, 0x3B, 0x30, 0xB3, 0x09, 0xD2, 0xFF, 0x93, 0xB3, 0x01, 0x20, 0x5E, 0x2F, 0xC7, 0xB5, 0x02,
  0x0E, 0xB7, 0x1F, 0x97, 0xB5, 0x02, 0x0E, 0xB7, 0x1F, 0xD3, 0xB3, 0x01, 0x20, 0x5E, 0x2F, 0xF9,
  0x3B, 0x30, 0xB3, 0x09, 0xD2, 0xFA, 0x72, 0xB3, 0x90, 0x83, 0x0C, 0xC2, 0xFA, 0x71, 0x01, 0xB3,
  0xA0, 0x52, 0x02, 0x0E, 0xFF, 0x70, 0x10, 0xBB, 0x3A, 0x0E, 0x02, 0x20, 0x58, 0x0C, 0xC6, 0xF0,
  0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A,
  0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_3k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_3k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_3k 48x48, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_filled_48_av_3k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x3F, 0x70, 0x10, 0xBC, 0x3A, 0x0E, 0x02, 0x20,
  0x5F, 0xE7, 0x10, 0x1C, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xE7, 0x2C, 0x39, 0x08, 0x30, 0xCF, 0xFE,
  0x3C, 0x30, 0xB3, 0x09, 0xFF, 0xF3, 0xC3, 0x01, 0x20, 0x5F, 0xFC, 0x7C, 0x50, 0x20, 0xEF, 0xFC,
  0x7C, 0x50, 0x20, 0xEF, 0xFF, 0x93, 0xC3, 0x01, 0x20, 0x5F, 0xFF, 0x93, 0xC3, 0x0B, 0x30, 0x9F,
  0xF9, 0x72, 0xC3, 0x90, 0x83, 0x0C, 0xFF, 0x71, 0x01, 0xC3, 0xA0, 0x52, 0x02, 0x0E, 0xFE, 0x70,
  0x10, 0xBC, 0x3A, 0x0E, 0x02, 0x20, 0x58, 0x0C, 0xC2, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF,
  0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_3k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_3k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_4k_plus 48x48, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_filled_48_av_4k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x0F, 0x3B, 0x3B, 0x3A, 0x0E, 0x02, 0x20, 0x5F,
  0xF3, 0xB3, 0xB3, 0xA0, 0x52, 0x02, 0x0E, 0xFF, 0x3B, 0x3B, 0x39, 0x08, 0x30, 0xCC, 0x2F, 0xA3,
  0xB3, 0xB3, 0x0B, 0x30, 0x9D, 0x2F, 0xA3, 0xB3, 0xB3, 0x01, 0x20, 0x5E, 0x2F, 0xA3, 0xB3, 0xB5,
  0x02, 0x0E, 0xB7, 0x1E, 0x74, 0x95, 0x02, 0x0E, 0xB7, 0x1E, 0x74, 0x93, 0x01, 0x20, 0x5E, 0x2F,
  0xA7, 0x49, 0x30, 0xB3, 0x09, 0xD2, 0xFF, 0x93, 0xB3, 0x90, 0x83, 0x0C, 0xC2, 0xFF, 0x93, 0xB3,
  0xA0, 0x52, 0x02, 0x0E, 0xFF, 0xE3, 0xB3, 0xA0, 0xE0, 0x22, 0x05, 0x80, 0xCC, 0x6F, 0x0D, 0xFF,
  0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF,
  0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_4k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_4k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_4k 48x48, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_filled_48_av_4k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x3F, 0x3B, 0x3C, 0x3A, 0x0E, 0x02, 0x20, 0x5F,
  0xE3, 0xB3, 0xC3, 0xA0, 0x52, 0x02, 0x0E, 0xFE, 0x3B, 0x3C, 0x39, 0x08, 0x30, 0xCF, 0xF3, 0xB3,
  0xC3, 0x0B, 0x30, 0x9F, 0xF9, 0x3B, 0x3C, 0x30, 0x12, 0x05, 0xFF, 0xA3, 0xB3, 0xC5, 0x02, 0x0E,
  0xFF, 0xA7, 0x4A, 0x50, 0x20, 0xEF, 0xFA, 0x74, 0xA3, 0x01, 0x20, 0x5F, 0xFA, 0x74, 0xA3, 0x0B,
  0x30, 0x9F, 0xFF, 0x3C, 0x39, 0x08, 0x30, 0xCF, 0xFE, 0x3C, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xFD,
  0x3C, 0x3A, 0x0E, 0x02, 0x20, 0x58, 0x0C, 0xC2, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF,
  0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_4k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_4k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_5g 48x48, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_filled_48_av_5g_data[] PROGMEM = {
  0xFF, 0x58, 0x11, 0xAD, 0xFB, 0x81, 0xDA, 0x11, 0xFF, 0x40, 0x10, 0xEF, 0xF0, 0xE0, 0x1F, 0xF4,
  0x0A, 0xFF, 0xA0, 0xAF, 0xF4, 0x0D, 0xFF, 0xA0, 0xDC, 0x77, 0xC7, 0x7C, 0x77, 0xC7, 0x7C, 0x77,
  0xC7, 0x7C, 0x77, 0xC7, 0x7F, 0xB8, 0x1D, 0xA1, 0x5C, 0x6F, 0xFE, 0x0E, 0x01, 0x4C, 0x6F, 0xFF,
  0x0A, 0x4C, 0x6F, 0xFF, 0x0D, 0x4C, 0x6F, 0x97, 0x3C, 0x4C, 0x73, 0xC7, 0x3C, 0x4C, 0x73, 0xC7,
  0x3C, 0x4C, 0x73, 0xC7, 0x3C, 0x4C, 0x73, 0xFF, 0xB0, 0xD4, 0x0D, 0xFF, 0xA0, 0xDF, 0xE0, 0xA4,
  0x0A, 0xFF, 0xA0, 0xAF, 0xD0, 0xE0, 0x14, 0x01, 0x0E, 0xFF, 0x0E, 0x01, 0xFB, 0x81, 0xDA, 0x16,
  0x81, 0x1A, 0xDF, 0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_5g() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 14, 41, 33), Box(0, 0, 47, 47),
      ic_filled_48_av_5g_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_5k_plus 48x48, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_filled_48_av_5k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x0F, 0x72, 0xB3, 0xA0, 0xE0, 0x22, 0x05, 0xFF,
  0x72, 0xB3, 0xA0, 0x52, 0x02, 0x0E, 0xFF, 0x72, 0xB3, 0x90, 0x83, 0x0C, 0xC2, 0xFA, 0x3F, 0xA3,
  0x0B, 0x30, 0x9D, 0x2F, 0xA3, 0xFA, 0x30, 0x12, 0x05, 0xE2, 0xFA, 0x70, 0x10, 0xBB, 0x50, 0x20,
  0xEB, 0x71, 0xE7, 0x10, 0x1B, 0x50, 0x20, 0xEB, 0x71, 0xFD, 0x3B, 0x30, 0x12, 0x05, 0xE2, 0xFF,
  0x93, 0xB3, 0x0B, 0x30, 0x9D, 0x2F, 0xA7, 0x2B, 0x39, 0x08, 0x30, 0xCC, 0x2F, 0xA7, 0x10, 0x1B,
  0x3A, 0x05, 0x20, 0x20, 0xEF, 0xF7, 0x01, 0x0B, 0xB3, 0xA0, 0xE0, 0x22, 0x05, 0x80, 0xCC, 0x6F,
  0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_5k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_5k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_5k 48x48, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_filled_48_av_5k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x3F, 0x72, 0xC3, 0xA0, 0xE0, 0x22, 0x05, 0xFE,
  0x72, 0xC3, 0xA0, 0x52, 0x02, 0x0E, 0xFE, 0x72, 0xC3, 0x90, 0x83, 0x0C, 0xFF, 0x3F, 0xB3, 0x0B,
  0x30, 0x9F, 0xF9, 0x3F, 0xB3, 0x01, 0x20, 0x5F, 0xFA, 0x70, 0x10, 0xBC, 0x50, 0x20, 0xEF, 0xFA,
  0x71, 0x01, 0xC5, 0x02, 0x0E, 0xFF, 0xF9, 0x3C, 0x30, 0x12, 0x05, 0xFF, 0xF9, 0x3C, 0x30, 0xB3,
  0x09, 0xFF, 0x97, 0x2C, 0x39, 0x08, 0x30, 0xCF, 0xF7, 0x10, 0x1C, 0x3A, 0x05, 0x20, 0x20, 0xEF,
  0xE7, 0x01, 0x0B, 0xC3, 0xA0, 0xE0, 0x22, 0x05, 0x80, 0xCC, 0x2F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0,
  0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA,
  0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_5k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_5k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_6k_plus 48x48, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_filled_48_av_6k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x0F, 0x0B, 0x01, 0x7B, 0x3A, 0x0E, 0x02, 0x20,
  0x5F, 0xF0, 0x17, 0x1B, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xF7, 0x2B, 0x39, 0x08, 0x30, 0xCC, 0x2F,
  0xA3, 0xFA, 0x30, 0xB3, 0x09, 0xD2, 0xFA, 0x3F, 0xA3, 0x01, 0x20, 0x5E, 0x2F, 0xA7, 0x01, 0x0B,
  0xB5, 0x02, 0x0E, 0xB7, 0x1E, 0x71, 0x01, 0xB5, 0x02, 0x0E, 0xB7, 0x1E, 0x3B, 0x3B, 0x30, 0x12,
  0x05, 0xE2, 0xFA, 0x3B, 0x3B, 0x30, 0xB3, 0x09, 0xD2, 0xFA, 0x3B, 0x3B, 0x39, 0x08, 0x30, 0xCC,
  0x2F, 0xA0, 0x17, 0x01, 0xB3, 0xA0, 0x52, 0x02, 0x0E, 0xFF, 0x0B, 0x01, 0x50, 0x10, 0xBB, 0x3A,
  0x0E, 0x02, 0x20, 0x58, 0x0C, 0xC6, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A,
  0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_6k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_6k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_6k 48x48, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_filled_48_av_6k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x3F, 0x0B, 0x01, 0x7C, 0x3A, 0x0E, 0x02, 0x20,
  0x5F, 0xE0, 0x17, 0x1C, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xE7, 0x2C, 0x39, 0x08, 0x30, 0xCF, 0xF3,
  0xFB, 0x30, 0xB3, 0x09, 0xFF, 0x93, 0xFB, 0x30, 0x12, 0x05, 0xFF, 0xA7, 0x01, 0x0B, 0xC5, 0x02,
  0x0E, 0xFF, 0xA7, 0x10, 0x1C, 0x50, 0x20, 0xEF, 0xFA, 0x3B, 0x3C, 0x30, 0x12, 0x05, 0xFF, 0xA3,
  0xB3, 0xC3, 0x0B, 0x30, 0x9F, 0xF9, 0x3B, 0x3C, 0x39, 0x08, 0x30, 0xCF, 0xF0, 0x17, 0x01, 0xC3,
  0xA0, 0x52, 0x02, 0x0E, 0xFE, 0x0B, 0x01, 0x50, 0x10, 0xBC, 0x3A, 0x0E, 0x02, 0x20, 0x58, 0x0C,
  0xC2, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E,
  0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_6k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_6k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_7k_plus 48x48, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_filled_48_av_7k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x0F, 0x70, 0x10, 0xBB, 0x3A, 0x0E, 0x02, 0x20,
  0x5F, 0xF7, 0x10, 0x1B, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xF7, 0x10, 0x1B, 0x39, 0x08, 0x30, 0xCC,
  0x2F, 0xF0, 0x12, 0x05, 0xB3, 0x0B, 0x30, 0x9D, 0x2F, 0xE0, 0xC3, 0x0A, 0xB3, 0x01, 0x20, 0x5E,
  0x2F, 0xE0, 0x73, 0x0E, 0xB5, 0x02, 0x0E, 0xB7, 0x1F, 0xB0, 0x22, 0x04, 0xC5, 0x02, 0x0E, 0xB7,
  0x1F, 0xA0, 0xD3, 0x09, 0xC3, 0x01, 0x20, 0x5E, 0x2F, 0xD0, 0x83, 0x0E, 0xC3, 0x0B, 0x30, 0x9D,
  0x2F, 0xD0, 0x42, 0x03, 0xD3, 0x90, 0x83, 0x0C, 0xC2, 0xFC, 0x0E, 0x30, 0x8D, 0x3A, 0x05, 0x20,
  0x20, 0xEF, 0xFA, 0x0A, 0x30, 0xDD, 0x3A, 0x0E, 0x02, 0x20, 0x58, 0x0C, 0xC6, 0xF0, 0xDF, 0xFF,
  0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF,
  0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_7k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_7k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_7k 48x48, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_filled_48_av_7k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x3F, 0x70, 0x10, 0xBC, 0x3A, 0x0E, 0x02, 0x20,
  0x5F, 0xE7, 0x10, 0x1C, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xE7, 0x10, 0x1C, 0x39, 0x08, 0x30, 0xCF,
  0xFD, 0x01, 0x20, 0x5C, 0x30, 0xB3, 0x09, 0xFF, 0xD0, 0xC3, 0x0A, 0xC3, 0x01, 0x20, 0x5F, 0xFE,
  0x07, 0x30, 0xEC, 0x50, 0x20, 0xEF, 0xFE, 0x02, 0x20, 0x4D, 0x50, 0x20, 0xEF, 0xFD, 0x0D, 0x30,
  0x9D, 0x30, 0x12, 0x05, 0xFF, 0xD0, 0x83, 0x0E, 0xD3, 0x0B, 0x30, 0x9F, 0xFC, 0x04, 0x20, 0x3E,
  0x39, 0x08, 0x30, 0xCF, 0xFA, 0x0E, 0x30, 0x8E, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xF9, 0x0A, 0x30,
  0xDE, 0x3A, 0x0E, 0x02, 0x20, 0x58, 0x0C, 0xC2, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF,
  0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_7k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_7k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_8k_plus 48x48, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_filled_48_av_8k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x0F, 0x0B, 0x01, 0x50, 0x10, 0xBB, 0x3A, 0x0E,
  0x02, 0x20, 0x5F, 0xF0, 0x17, 0x01, 0xB3, 0xA0, 0x52, 0x02, 0x0E, 0xFF, 0x3B, 0x3B, 0x39, 0x08,
  0x30, 0xCC, 0x2F, 0xA3, 0xB3, 0xB3, 0x0B, 0x30, 0x9D, 0x2F, 0xA3, 0xB3, 0xB3, 0x01, 0x20, 0x5E,
  0x2F, 0xA7, 0x2B, 0x50, 0x20, 0xEB, 0x71, 0xE7, 0x2B, 0x50, 0x20, 0xEB, 0x71, 0xE3, 0xB3, 0xB3,
  0x01, 0x20, 0x5E, 0x2F, 0xA3, 0xB3, 0xB3, 0x0B, 0x30, 0x9D, 0x2F, 0xA3, 0xB3, 0xB3, 0x90, 0x83,
  0x0C, 0xC2, 0xFA, 0x01, 0x70, 0x1B, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xF0, 0xB0, 0x15, 0x01, 0x0B,
  0xB3, 0xA0, 0xE0, 0x22, 0x05, 0x80, 0xCC, 0x6F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE,
  0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_8k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_8k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_8k 48x48, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_filled_48_av_8k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x3F, 0x0B, 0x01, 0x50, 0x10, 0xBC, 0x3A, 0x0E,
  0x02, 0x20, 0x5F, 0xE0, 0x17, 0x01, 0xC3, 0xA0, 0x52, 0x02, 0x0E, 0xFE, 0x3B, 0x3C, 0x39, 0x08,
  0x30, 0xCF, 0xF3, 0xB3, 0xC3, 0x0B, 0x30, 0x9F, 0xF9, 0x3B, 0x3C, 0x30, 0x12, 0x05, 0xFF, 0xA7,
  0x2C, 0x50, 0x20, 0xEF, 0xFA, 0x72, 0xC5, 0x02, 0x0E, 0xFF, 0xA3, 0xB3, 0xC3, 0x01, 0x20, 0x5F,
  0xFA, 0x3B, 0x3C, 0x30, 0xB3, 0x09, 0xFF, 0x93, 0xB3, 0xC3, 0x90, 0x83, 0x0C, 0xFF, 0x01, 0x70,
  0x1C, 0x3A, 0x05, 0x20, 0x20, 0xEF, 0xE0, 0xB0, 0x15, 0x01, 0x0B, 0xC3, 0xA0, 0xE0, 0x22, 0x05,
  0x80, 0xCC, 0x2F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC,
  0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_8k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_8k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_9k_plus 48x48, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_filled_48_av_9k_plus_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x0F, 0x0B, 0x01, 0x50, 0x10, 0xBB, 0x3A, 0x0E,
  0x02, 0x20, 0x5F, 0xF0, 0x17, 0x01, 0xB3, 0xA0, 0x52, 0x02, 0x0E, 0xFF, 0x3B, 0x3B, 0x39, 0x08,
  0x30, 0xCC, 0x2F, 0xA3, 0xB3, 0xB3, 0x0B, 0x30, 0x9D, 0x2F, 0xA3, 0xB3, 0xB3, 0x01, 0x20, 0x5E,
  0x2F, 0xA0, 0x17, 0x1B, 0x50, 0x20, 0xEB, 0x71, 0xE0, 0xB0, 0x17, 0xB5, 0x02, 0x0E, 0xB7, 0x1F,
  0xD3, 0xB3, 0x01, 0x20, 0x5E, 0x2F, 0xF9, 0x3B, 0x30, 0xB3, 0x09, 0xD2, 0xFA, 0x72, 0xB3, 0x90,
  0x83, 0x0C, 0xC2, 0xFA, 0x71, 0x01, 0xB3, 0xA0, 0x52, 0x02, 0x0E, 0xFF, 0x70, 0x10, 0xBB, 0x3A,
  0x0E, 0x02, 0x20, 0x58, 0x0C, 0xC6, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A,
  0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_9k_plus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_9k_plus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_9k 48x48, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_filled_48_av_9k_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x3F, 0x0B, 0x01, 0x50, 0x10, 0xBC, 0x3A, 0x0E,
  0x02, 0x20, 0x5F, 0xE0, 0x17, 0x01, 0xC3, 0xA0, 0x52, 0x02, 0x0E, 0xFE, 0x3B, 0x3C, 0x39, 0x08,
  0x30, 0xCF, 0xF3, 0xB3, 0xC3, 0x0B, 0x30, 0x9F, 0xF9, 0x3B, 0x3C, 0x30, 0x12, 0x05, 0xFF, 0xA0,
  0x17, 0x1C, 0x50, 0x20, 0xEF, 0xFA, 0x0B, 0x01, 0x7C, 0x50, 0x20, 0xEF, 0xFF, 0x93, 0xC3, 0x01,
  0x20, 0x5F, 0xFF, 0x93, 0xC3, 0x0B, 0x30, 0x9F, 0xF9, 0x72, 0xC3, 0x90, 0x83, 0x0C, 0xFF, 0x71,
  0x01, 0xC3, 0xA0, 0x52, 0x02, 0x0E, 0xFE, 0x70, 0x10, 0xBC, 0x3A, 0x0E, 0x02, 0x20, 0x58, 0x0C,
  0xC2, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8, 0x4E,
  0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_9k() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_9k_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_add_to_queue 48x48, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_filled_48_av_add_to_queue_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C,
  0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9,
  0x73, 0xFF, 0xA7, 0x3F, 0x97, 0x3F, 0xFA, 0x73, 0xF9, 0x73, 0xFF, 0xA7, 0x3F, 0x97, 0x3F, 0xFA,
  0x73, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97,
  0x72, 0xC7, 0x72, 0xF9, 0x77, 0x2C, 0x77, 0x2F, 0x97, 0x72, 0xC7, 0x72, 0xF9, 0x80, 0xC0, 0x0F,
  0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A,
  0x80, 0xC6, 0xF8, 0x19, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA,
  0x17, 0x71, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_add_to_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_add_to_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_airplay 48x48, 4-bit Alpha,  RLE, 180 bytes.
static const unsigned char ic_filled_48_av_airplay_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98,
  0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00,
  0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80,
  0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F,
  0x98, 0x0C, 0x00, 0xF9, 0x77, 0x30, 0x07, 0x77, 0x3F, 0x97, 0x72, 0x07, 0xA0, 0x77, 0x72, 0xC0,
  0xDF, 0xC7, 0x07, 0xC0, 0x77, 0xFC, 0x0D, 0x0A, 0xFC, 0x60, 0x7E, 0x07, 0x6F, 0xC8, 0x1A, 0x1E,
  0xFB, 0x50, 0x7F, 0x90, 0x75, 0xFB, 0x84, 0xE1, 0x01, 0xAD, 0xF9, 0x40, 0x7F, 0xB0, 0x74, 0xF9,
  0x81, 0xDA, 0x17, 0x72, 0x07, 0xFD, 0x07, 0x77, 0x77, 0x10, 0x7F, 0xF0, 0x77, 0x77, 0x60, 0x7F,
  0xFA, 0x07, 0x77, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x77, 0x20, 0x7F, 0xFE, 0x07, 0x77, 0x70, 0x7F,
  0xFF, 0x90, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_airplay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_airplay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_album 48x48, 4-bit Alpha,  RLE, 289 bytes.
static const unsigned char ic_filled_48_av_album_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0xFF, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF, 0xF0, 0x12, 0x08,
  0xFD, 0x0D, 0x03, 0x71, 0x03, 0x0D, 0xFD, 0x08, 0x20, 0xDF, 0xC0, 0xB0, 0x17, 0x30, 0x10, 0xBF,
  0xC8, 0x1D, 0x03, 0xFC, 0x0D, 0x01, 0x75, 0x01, 0x0D, 0xFC, 0x03, 0x07, 0xFC, 0x03, 0x77, 0x03,
  0xFC, 0x07, 0x0A, 0xFB, 0x0B, 0x77, 0x20, 0xBF, 0xB0, 0xA0, 0xCF, 0xB0, 0x67, 0x72, 0x06, 0xFB,
  0x0C, 0x0E, 0xFB, 0x02, 0x68, 0x24, 0xDD, 0x46, 0x02, 0xFB, 0x0E, 0xFC, 0x70, 0xDA, 0x0D, 0x7F,
  0xFF, 0x97, 0x0D, 0xA0, 0xD7, 0xFC, 0x0E, 0xFB, 0x02, 0x68, 0x24, 0xDD, 0x46, 0x02, 0xFB, 0x0E,
  0x0C, 0xFB, 0x06, 0x77, 0x20, 0x6F, 0xB0, 0xC0, 0xAF, 0xB0, 0xB7, 0x72, 0x0B, 0xFB, 0x0A, 0x07,
  0xFC, 0x03, 0x77, 0x03, 0xFC, 0x07, 0x03, 0xFC, 0x0D, 0x01, 0x75, 0x01, 0x0D, 0xFC, 0x81, 0x30,
  0xDF, 0xC0, 0xB0, 0x17, 0x30, 0x10, 0xBF, 0xC0, 0xD2, 0x08, 0xFD, 0x0D, 0x03, 0x71, 0x03, 0x0D,
  0xFD, 0x08, 0x20, 0x1F, 0xF8, 0x1B, 0x62, 0x28, 0x12, 0x6B, 0xFF, 0x01, 0x30, 0x9F, 0xFF, 0xFE,
  0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E, 0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF,
  0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB,
  0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77,
  0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73,
  0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_album() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_album_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_art_track 48x48, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_filled_48_av_art_track_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFD, 0x81, 0xDA, 0x15, 0xFF, 0xA0, 0x10, 0xEF, 0xFA, 0x0E, 0x01, 0x4F, 0xFA,
  0x0A, 0xFF, 0xC0, 0xA4, 0xFF, 0xA0, 0xDF, 0xFC, 0x0D, 0x48, 0x0C, 0x0F, 0x77, 0x6F, 0xFE, 0x77,
  0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x77, 0x6F, 0xFE, 0x48, 0x0C, 0x0F, 0x4F, 0xFF, 0xE8, 0x1E, 0x5E,
  0xE4, 0xFF, 0xF9, 0x0C, 0xC8, 0x15, 0x05, 0xE4, 0xFF, 0xF8, 0x1B, 0x0A, 0xA0, 0x83, 0x09, 0xD7,
  0x76, 0xC0, 0xD0, 0x12, 0x0C, 0x0B, 0x50, 0xCC, 0x77, 0x6C, 0x03, 0x30, 0x01, 0x50, 0x20, 0xEB,
  0x77, 0x6B, 0x06, 0x75, 0x05, 0xB7, 0x76, 0x0D, 0xFF, 0xC0, 0xD4, 0xFF, 0xA0, 0xAF, 0xFC, 0x0A,
  0x4F, 0xFA, 0x01, 0x0E, 0xFF, 0xA0, 0xE0, 0x14, 0xFF, 0xA1, 0x81, 0x1A, 0xDF, 0xD8, 0x1D, 0xA1,
  0x5F, 0xFA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_art_track() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 14, 43, 33), Box(0, 0, 47, 47),
      ic_filled_48_av_art_track_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_audio_file 48x48, 4-bit Alpha,  RLE, 156 bytes.
static const unsigned char ic_filled_48_av_audio_file_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xA0, 0x77, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x09, 0xFF, 0xF0, 0x77,
  0x20, 0xDF, 0xFB, 0x07, 0xC0, 0x77, 0x1F, 0xFC, 0x10, 0x7C, 0x07, 0x7F, 0xFC, 0x20, 0x7C, 0x07,
  0x6F, 0xFC, 0x30, 0x7C, 0x07, 0x5F, 0xFC, 0x40, 0x7C, 0x07, 0x4F, 0xFC, 0x50, 0x7C, 0x07, 0x3F,
  0xFC, 0x60, 0x7C, 0x07, 0x2F, 0xFC, 0x70, 0x7C, 0x07, 0x1F, 0xFC, 0x71, 0x07, 0xC0, 0x7F, 0xFC,
  0x72, 0x07, 0xFF, 0xF9, 0x73, 0x07, 0x80, 0xA9, 0x7F, 0x71, 0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x71,
  0xFF, 0xFB, 0x71, 0xFF, 0xFB, 0x2F, 0xFF, 0xFA, 0x2F, 0xFF, 0xFA, 0x2F, 0xFF, 0xC8, 0x38, 0x30,
  0x28, 0x2F, 0xFF, 0xB0, 0x37, 0xFF, 0xFA, 0x08, 0x71, 0xFF, 0xFA, 0x03, 0x71, 0xFF, 0xFA, 0x72,
  0xFF, 0xFA, 0x03, 0x70, 0x3F, 0xFF, 0xA0, 0x87, 0x08, 0xFF, 0xFB, 0x03, 0x50, 0x3F, 0xFF, 0xD8,
  0x38, 0x30, 0x38, 0x80, 0x99, 0x4F, 0x0D, 0xFF, 0xFF, 0xA0, 0xD0, 0xAF, 0xFF, 0xFA, 0x81, 0xA1,
  0xEF, 0xFF, 0xF8, 0x4E, 0x10, 0x1A, 0xEF, 0xFF, 0xB8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_audio_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_audio_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_av_timer 48x48, 4-bit Alpha,  RLE, 335 bytes.
static const unsigned char ic_filled_48_av_av_timer_data[] PROGMEM = {
  0x77, 0x2A, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x77, 0xF9, 0x0B, 0x04, 0x77, 0x75, 0xFB, 0x0B, 0x03,
  0x77, 0x10, 0x27, 0x1F, 0xD0, 0x87, 0x58, 0x21, 0xBE, 0x37, 0xC8, 0x14, 0x8C, 0xE0, 0xB0, 0x17,
  0x20, 0x10, 0xCA, 0x0E, 0x03, 0x6C, 0x30, 0x30, 0xAD, 0x0C, 0x01, 0x71, 0x0B, 0xC0, 0xE0, 0x35,
  0xC5, 0x04, 0x0D, 0xC0, 0xB7, 0x08, 0xE0, 0xE0, 0x34, 0xC7, 0x0B, 0xC0, 0x85, 0x03, 0xF9, 0x0E,
  0x03, 0x77, 0x10, 0xBC, 0x03, 0x40, 0xCB, 0x0D, 0x08, 0xC0, 0xE0, 0x37, 0x70, 0x10, 0xDB, 0x0B,
  0x30, 0x5C, 0x81, 0x30, 0x7C, 0x0E, 0x03, 0x77, 0x03, 0xC0, 0x42, 0x0B, 0xB0, 0x93, 0x07, 0xC0,
  0xE0, 0x37, 0x70, 0xAB, 0x81, 0xB0, 0x1C, 0x02, 0x40, 0x7C, 0x0E, 0x03, 0x76, 0x02, 0xC0, 0x10,
  0x6B, 0x0B, 0x60, 0x7C, 0x0E, 0x03, 0x76, 0x0C, 0xB0, 0x50, 0x9B, 0x07, 0x70, 0x7C, 0x0E, 0x03,
  0x75, 0x07, 0xB0, 0x90, 0xCB, 0x03, 0x71, 0x07, 0xC0, 0xE0, 0x37, 0x40, 0x3B, 0x0B, 0x0E, 0xB8,
  0x42, 0x04, 0xDD, 0x44, 0x07, 0xC0, 0xE0, 0x35, 0x84, 0x4D, 0xD4, 0x02, 0xB0, 0xDC, 0x20, 0xDA,
  0x0D, 0x50, 0x7C, 0x07, 0x50, 0xDA, 0x0D, 0x2B, 0x00, 0xEB, 0x20, 0xDA, 0x0D, 0x60, 0x7A, 0x07,
  0x60, 0xDA, 0x0D, 0x2B, 0x0E, 0x0D, 0xB8, 0x42, 0x04, 0xDD, 0x47, 0x00, 0x77, 0x84, 0x4D, 0xD4,
  0x02, 0xB0, 0xD0, 0xBB, 0x03, 0x77, 0x75, 0x03, 0xB0, 0xB0, 0x9B, 0x07, 0x77, 0x75, 0x07, 0xB0,
  0x90, 0x5B, 0x0C, 0x77, 0x75, 0x0C, 0xB0, 0x50, 0x1C, 0x02, 0x77, 0x73, 0x02, 0xC8, 0x11, 0x0B,
  0xB0, 0xA7, 0x77, 0x30, 0xAB, 0x0B, 0x20, 0x4C, 0x03, 0x77, 0x71, 0x03, 0xC0, 0x43, 0x0C, 0xB0,
  0xD0, 0x17, 0x18, 0x24, 0xDD, 0x47, 0x10, 0x10, 0xDB, 0x0B, 0x40, 0x3C, 0x0B, 0x71, 0x0D, 0xA0,
  0xD7, 0x10, 0xBC, 0x03, 0x50, 0x8C, 0x0B, 0x01, 0x60, 0xDA, 0x0D, 0x60, 0x10, 0xBC, 0x08, 0x70,
  0xBC, 0x0D, 0x03, 0x58, 0x24, 0xDD, 0x45, 0x03, 0x0D, 0xC0, 0xB7, 0x10, 0x10, 0xDD, 0x0A, 0x02,
  0x73, 0x02, 0x0A, 0xD0, 0xC0, 0x17, 0x20, 0x10, 0xBE, 0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE,
  0x0B, 0x01, 0x75, 0x08, 0xFF, 0xE0, 0x87, 0x71, 0x03, 0x0C, 0xFF, 0xA0, 0xB0, 0x37, 0x74, 0x05,
  0x0B, 0xFD, 0x0B, 0x04, 0x77, 0x71, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_av_timer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_av_timer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_branding_watermark 48x48, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_filled_48_av_branding_watermark_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xD8, 0x09, 0xBA, 0x2F, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF,
  0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77,
  0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF,
  0xD7, 0x74, 0xC0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8,
  0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_branding_watermark() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_branding_watermark_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_call_to_action 48x48, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_filled_48_av_call_to_action_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xD8, 0x09, 0xF9, 0x0F, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00,
  0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xD8,
  0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8,
  0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_call_to_action() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_call_to_action_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_closed_caption_disabled 48x48, 4-bit Alpha,  RLE, 260 bytes.
static const unsigned char ic_filled_48_av_closed_caption_disabled_data[] PROGMEM = {
  0x20, 0x28, 0x0C, 0x20, 0x81, 0x4F, 0x78, 0x0C, 0x00, 0x04, 0xB0, 0x77, 0x77, 0x77, 0x0E, 0xC0,
  0x75, 0x0C, 0xFF, 0xFA, 0x81, 0xDA, 0x12, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xFF, 0xFB, 0x0E, 0x01,
  0x20, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFF, 0xB0, 0xA3, 0x03, 0xD0, 0x75, 0x0C, 0xFF, 0xFA, 0x0D,
  0x4E, 0x07, 0x50, 0xCF, 0xFF, 0xA4, 0xF0, 0x75, 0x0C, 0xFF, 0xF9, 0x4F, 0x90, 0x75, 0x0C, 0xFF,
  0xF4, 0xFA, 0x07, 0x50, 0xCF, 0xFE, 0x4F, 0xB0, 0x75, 0x0C, 0xFF, 0xD4, 0xFC, 0x07, 0x50, 0xCF,
  0xFC, 0x4E, 0x0C, 0x0E, 0xC0, 0x75, 0x82, 0xCF, 0xB1, 0x60, 0x10, 0xBE, 0x4E, 0x81, 0x23, 0xEC,
  0x07, 0x50, 0xC0, 0x17, 0x10, 0x1E, 0x4E, 0x20, 0x30, 0xEC, 0x07, 0x77, 0x1E, 0x4E, 0x3E, 0x07,
  0x7C, 0x3E, 0x4E, 0x3F, 0x07, 0x6F, 0xE4, 0xE3, 0xF9, 0x07, 0x50, 0xCF, 0xD4, 0xE3, 0xFA, 0x07,
  0x50, 0xCF, 0xC4, 0xE3, 0xFB, 0x07, 0x50, 0xCF, 0xB4, 0xE3, 0xC1, 0x03, 0x0E, 0xC0, 0x75, 0x0C,
  0x3E, 0x4E, 0x72, 0x03, 0xD0, 0x77, 0x1E, 0x4E, 0x01, 0x71, 0x01, 0xE0, 0x76, 0x02, 0xE4, 0xE0,
  0xB0, 0x16, 0x01, 0x0B, 0xF0, 0x75, 0x08, 0xE4, 0xFF, 0xFB, 0x07, 0x40, 0x10, 0xCD, 0x4F, 0xFF,
  0xC0, 0x74, 0x01, 0x0C, 0xC4, 0xFF, 0xFD, 0x07, 0x40, 0x10, 0xCB, 0x4F, 0xFF, 0xE0, 0x74, 0x01,
  0x0C, 0xA4, 0xFF, 0xFF, 0x07, 0x40, 0x10, 0xC9, 0x4F, 0xFF, 0xF9, 0x07, 0x40, 0x10, 0xC4, 0x0D,
  0xFF, 0xFF, 0x90, 0x77, 0x20, 0xAF, 0xFF, 0xFA, 0x07, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA0, 0x77,
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x90, 0x77, 0x77, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x76, 0x03,
  0x0E, 0xC0, 0x77, 0x77, 0x76, 0x03, 0x0E, 0xC0, 0x27, 0x77, 0x76, 0x03, 0x0E, 0xA0, 0x48, 0x0C,
  0x00, 0x81, 0x3E, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_closed_caption_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 42, 44), Box(0, 0, 47, 47),
      ic_filled_48_av_closed_caption_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_closed_caption_off 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_filled_48_av_closed_caption_off_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDA, 0x77, 0x77, 0x2A, 0x0D, 0xB7, 0x77, 0x72, 0xE7, 0x77, 0x72, 0xE7, 0x77, 0x72,
  0xE7, 0x77, 0x72, 0xE7, 0x77, 0x72, 0xE7, 0x77, 0x72, 0xE3, 0x04, 0x0D, 0xE0, 0xD0, 0x44, 0x04,
  0x0D, 0xE0, 0xD0, 0x43, 0xE3, 0x0D, 0xF9, 0x0D, 0x40, 0xDF, 0x90, 0xD3, 0xE3, 0xFB, 0x4F, 0xB3,
  0xE3, 0xB4, 0xB4, 0xB4, 0xB3, 0xE3, 0xB7, 0x4B, 0x73, 0xE3, 0xB7, 0x4B, 0x73, 0xE3, 0xB7, 0x4B,
  0x73, 0xE3, 0xB7, 0x4B, 0x73, 0xE3, 0xB4, 0xB4, 0xB4, 0xB3, 0xE3, 0xFB, 0x4F, 0xB3, 0xE3, 0x0D,
  0xF9, 0x0D, 0x40, 0xDF, 0x90, 0xD3, 0xE3, 0x04, 0x0D, 0xE0, 0xD0, 0x44, 0x04, 0x0D, 0xE0, 0xD0,
  0x43, 0xE7, 0x77, 0x72, 0xE7, 0x77, 0x72, 0xE7, 0x77, 0x72, 0xE7, 0x77, 0x72, 0xE7, 0x77, 0x72,
  0xE7, 0x77, 0x72, 0xB0, 0xDA, 0x77, 0x77, 0x2A, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF,
  0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_closed_caption_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_closed_caption_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_closed_caption 48x48, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_filled_48_av_closed_caption_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xBB, 0x2F, 0x0B, 0x01, 0x60, 0x10, 0xBC, 0x0B, 0x01,
  0x60, 0x10, 0xBF, 0xD0, 0x17, 0x10, 0x1C, 0x01, 0x71, 0x01, 0xFD, 0x73, 0xC7, 0x3F, 0xD3, 0xC3,
  0xC3, 0xC3, 0xFD, 0x3F, 0xC3, 0xFF, 0xD3, 0xFC, 0x3F, 0xFD, 0x3F, 0xC3, 0xFF, 0xD3, 0xFC, 0x3F,
  0xFD, 0x3C, 0x3C, 0x3C, 0x3F, 0xD7, 0x3C, 0x73, 0xFD, 0x01, 0x71, 0x01, 0xC0, 0x17, 0x10, 0x1F,
  0xD0, 0xB0, 0x16, 0x01, 0x0B, 0xC0, 0xB0, 0x16, 0x01, 0x0B, 0x80, 0xBB, 0x2F, 0x0D, 0xFF, 0xFF,
  0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF,
  0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_closed_caption() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_closed_caption_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_control_camera 48x48, 4-bit Alpha,  RLE, 263 bytes.
static const unsigned char ic_filled_48_av_control_camera_data[] PROGMEM = {
  0x77, 0x50, 0x07, 0x80, 0xC1, 0x00, 0x7A, 0x07, 0x77, 0x77, 0x70, 0x7C, 0x07, 0x77, 0x77, 0x50,
  0x7E, 0x07, 0x77, 0x77, 0x30, 0x7F, 0x90, 0x77, 0x77, 0x71, 0x07, 0xFB, 0x07, 0x77, 0x76, 0x07,
  0xFD, 0x07, 0x77, 0x75, 0x09, 0xD0, 0x08, 0xD0, 0x97, 0x77, 0x60, 0x9B, 0x08, 0x20, 0x8B, 0x09,
  0x77, 0x77, 0x18, 0x19, 0xF8, 0x48, 0x18, 0xF9, 0x77, 0x77, 0x30, 0x56, 0x05, 0x80, 0x9C, 0x20,
  0x07, 0x09, 0x77, 0x73, 0x09, 0x07, 0x74, 0x07, 0xA0, 0x97, 0x18, 0x46, 0xCE, 0xEC, 0x67, 0x10,
  0x9A, 0x07, 0x72, 0x07, 0xC0, 0x95, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0x09, 0xC0, 0x77, 0x07, 0xE0,
  0x54, 0x0C, 0xF9, 0x0C, 0x40, 0x5E, 0x07, 0x50, 0x7E, 0x08, 0x40, 0x6F, 0xB0, 0x64, 0x08, 0xE0,
  0x73, 0x07, 0xE0, 0x85, 0x0C, 0xFB, 0x0C, 0x50, 0x8E, 0x81, 0x70, 0x7E, 0x08, 0x60, 0xEF, 0xB0,
  0xE6, 0x08, 0xE0, 0x07, 0xE0, 0x86, 0x0E, 0xFB, 0x0E, 0x60, 0x8E, 0x81, 0x70, 0x7E, 0x08, 0x50,
  0xCF, 0xB0, 0xC5, 0x08, 0xE0, 0x73, 0x07, 0xE0, 0x84, 0x06, 0xFB, 0x06, 0x40, 0x8E, 0x07, 0x50,
  0x7E, 0x05, 0x40, 0xCF, 0x90, 0xC4, 0x05, 0xE0, 0x77, 0x07, 0xC0, 0x95, 0x01, 0x0C, 0xE0, 0xC0,
  0x15, 0x09, 0xC0, 0x77, 0x20, 0x7A, 0x09, 0x71, 0x84, 0x6C, 0xEE, 0xC6, 0x71, 0x09, 0xA0, 0x77,
  0x40, 0x70, 0x97, 0x77, 0x30, 0x90, 0x78, 0x09, 0xC2, 0x00, 0x56, 0x05, 0x77, 0x77, 0x38, 0x19,
  0xF8, 0x48, 0x18, 0xF9, 0x77, 0x77, 0x10, 0x9B, 0x08, 0x20, 0x8B, 0x09, 0x77, 0x76, 0x09, 0xD0,
  0x08, 0xD0, 0x97, 0x77, 0x50, 0x7F, 0xD0, 0x77, 0x77, 0x60, 0x7F, 0xB0, 0x77, 0x77, 0x71, 0x07,
  0xF9, 0x07, 0x77, 0x77, 0x30, 0x7E, 0x07, 0x77, 0x77, 0x50, 0x7C, 0x07, 0x77, 0x77, 0x70, 0x7A,
  0x07, 0x80, 0xC1, 0x00, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_control_camera() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_control_camera_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_equalizer 48x48, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_filled_48_av_equalizer_data[] PROGMEM = {
  0x75, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73,
  0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9, 0x77, 0x73, 0xF9,
  0x4F, 0x97, 0x5F, 0x94, 0xF9, 0x75, 0xF9, 0x4F, 0x97, 0x5F, 0x94, 0xF9, 0x75, 0xF9, 0x4F, 0x97,
  0x5F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94,
  0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4,
  0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F,
  0xFA, 0x4F, 0x94, 0xFF, 0xA4, 0xF9, 0x4F, 0xFA, 0x4F, 0x94, 0xF9,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_equalizer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_equalizer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_explicit 48x48, 4-bit Alpha,  RLE, 108 bytes.
static const unsigned char ic_filled_48_av_explicit_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAB, 0x0F, 0x75, 0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x75,
  0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF,
  0xFC, 0x75, 0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x4F, 0xFF, 0xFC,
  0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x4F, 0xFF, 0xFC, 0x75, 0xFF, 0xFB, 0x75, 0xFF, 0xFB, 0x75,
  0xFF, 0xFB, 0x75, 0x80, 0xAB, 0x0F, 0x0D, 0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1,
  0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_explicit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_explicit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_fast_forward 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_filled_48_av_fast_forward_data[] PROGMEM = {
  0x0A, 0x77, 0x30, 0xA7, 0x72, 0x90, 0xD0, 0x37, 0x71, 0x90, 0xD0, 0x37, 0x7B, 0x08, 0x77, 0xB0,
  0x87, 0x6C, 0x0C, 0x02, 0x75, 0xC0, 0xC0, 0x27, 0x4D, 0x0E, 0x06, 0x74, 0xD0, 0xE0, 0x67, 0x3F,
  0x0A, 0x01, 0x72, 0xF0, 0xA0, 0x17, 0x1F, 0x90, 0xE0, 0x47, 0x1F, 0x90, 0xE0, 0x47, 0xFB, 0x09,
  0x7F, 0xB0, 0x96, 0xFC, 0x0D, 0x03, 0x5F, 0xC0, 0xD0, 0x34, 0xFE, 0x07, 0x4F, 0xE0, 0x73, 0xFF,
  0x0B, 0x01, 0x2F, 0xF0, 0xB0, 0x11, 0xFF, 0x90, 0xE0, 0x51, 0xFF, 0x90, 0xE0, 0x5F, 0xF9, 0x0E,
  0x05, 0x1F, 0xF9, 0x0E, 0x05, 0xFF, 0x0B, 0x01, 0x2F, 0xF0, 0xB0, 0x11, 0xFE, 0x07, 0x4F, 0xE0,
  0x73, 0xFC, 0x0D, 0x03, 0x5F, 0xC0, 0xD0, 0x34, 0xFB, 0x09, 0x7F, 0xB0, 0x96, 0xF9, 0x0E, 0x04,
  0x71, 0xF9, 0x0E, 0x04, 0x7F, 0x0A, 0x01, 0x72, 0xF0, 0xA0, 0x17, 0x1D, 0x0E, 0x06, 0x74, 0xD0,
  0xE0, 0x67, 0x3C, 0x0C, 0x02, 0x75, 0xC0, 0xC0, 0x27, 0x4B, 0x08, 0x77, 0xB0, 0x87, 0x69, 0x0D,
  0x03, 0x77, 0x19, 0x0D, 0x03, 0x77, 0x0A, 0x77, 0x30, 0xA7, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_fast_forward() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 12, 42, 35), Box(0, 0, 47, 47),
      ic_filled_48_av_fast_forward_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_fast_rewind 48x48, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_filled_48_av_fast_rewind_data[] PROGMEM = {
  0x77, 0x20, 0xA7, 0x73, 0x0A, 0x77, 0x03, 0x0D, 0x97, 0x71, 0x03, 0x0D, 0x97, 0x60, 0x8B, 0x77,
  0x08, 0xB7, 0x40, 0x20, 0xCC, 0x75, 0x02, 0x0C, 0xC7, 0x30, 0x60, 0xED, 0x74, 0x06, 0x0E, 0xD7,
  0x10, 0x10, 0xAF, 0x72, 0x01, 0x0A, 0xF7, 0x04, 0x0E, 0xF9, 0x71, 0x04, 0x0E, 0xF9, 0x60, 0x9F,
  0xB7, 0x09, 0xFB, 0x40, 0x30, 0xDF, 0xC5, 0x03, 0x0D, 0xFC, 0x30, 0x7F, 0xE4, 0x07, 0xFE, 0x10,
  0x10, 0xBF, 0xF2, 0x01, 0x0B, 0xFF, 0x05, 0x0E, 0xFF, 0x91, 0x05, 0x0E, 0xFF, 0x90, 0x50, 0xEF,
  0xF9, 0x10, 0x50, 0xEF, 0xF9, 0x10, 0x10, 0xBF, 0xF2, 0x01, 0x0B, 0xFF, 0x30, 0x7F, 0xE4, 0x07,
  0xFE, 0x40, 0x30, 0xDF, 0xC5, 0x03, 0x0D, 0xFC, 0x60, 0x9F, 0xB7, 0x09, 0xFB, 0x70, 0x40, 0xEF,
  0x97, 0x10, 0x40, 0xEF, 0x97, 0x10, 0x10, 0xAF, 0x72, 0x01, 0x0A, 0xF7, 0x30, 0x60, 0xED, 0x74,
  0x06, 0x0E, 0xD7, 0x40, 0x20, 0xCC, 0x75, 0x02, 0x0C, 0xC7, 0x60, 0x8B, 0x77, 0x08, 0xB7, 0x70,
  0x30, 0xD9, 0x77, 0x10, 0x30, 0xD9, 0x77, 0x20, 0xA7, 0x73, 0x0A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_fast_rewind() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 12, 39, 35), Box(0, 0, 47, 47),
      ic_filled_48_av_fast_rewind_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_featured_play_list 48x48, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_48_av_featured_play_list_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F,
  0xFF, 0xD7, 0x74, 0x80, 0xB8, 0x6F, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF,
  0xD7, 0x74, 0x80, 0x9B, 0xA2, 0xF0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E,
  0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_featured_play_list() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_featured_play_list_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_featured_video 48x48, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_filled_48_av_featured_video_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F,
  0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7,
  0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF, 0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0xFF,
  0xFD, 0x77, 0x4F, 0xFF, 0xD7, 0x74, 0x80, 0x99, 0xF2, 0xF0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80,
  0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_featured_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_featured_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_fiber_dvr 48x48, 4-bit Alpha,  RLE, 172 bytes.
static const unsigned char ic_filled_48_av_fiber_dvr_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0x80, 0xC0, 0xF8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xD8, 0x0D, 0xC0, 0xF7, 0x01, 0x07, 0xB0, 0xD2, 0x01, 0xB0,
  0x92, 0x06, 0xB7, 0x01, 0x07, 0xFA, 0x72, 0x06, 0xB0, 0x22, 0x0C, 0xA0, 0x42, 0x0A, 0xB7, 0x20,
  0x6F, 0x97, 0x20, 0x1B, 0x07, 0x20, 0x8A, 0x30, 0xEB, 0x72, 0x01, 0xF9, 0x3C, 0x3B, 0x0B, 0x28,
  0x13, 0xFB, 0x20, 0x4C, 0x3C, 0x3F, 0x93, 0xC3, 0xC0, 0x12, 0x0E, 0x06, 0x20, 0x8C, 0x3C, 0x3F,
  0x93, 0xC3, 0xC0, 0x52, 0x0A, 0x02, 0x20, 0xDC, 0x72, 0x01, 0xF9, 0x3C, 0x3C, 0x09, 0x20, 0x32,
  0x02, 0xD7, 0x20, 0x7F, 0x93, 0xC3, 0xC0, 0xE5, 0x06, 0xD7, 0x10, 0x5F, 0xA3, 0xC3, 0xD0, 0x34,
  0x0B, 0xD3, 0xA0, 0x72, 0x07, 0xFA, 0x72, 0x01, 0xD0, 0x74, 0xE3, 0xA0, 0xE2, 0x01, 0xFA, 0x72,
  0x06, 0xD0, 0xC3, 0x05, 0xE3, 0xB0, 0x52, 0x09, 0xF9, 0x70, 0x10, 0x7F, 0x01, 0x20, 0x9E, 0x3B,
  0x0C, 0x20, 0x38, 0x0D, 0xC0, 0xF0, 0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E,
  0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_fiber_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_fiber_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_fiber_manual_record 48x48, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_filled_48_av_fiber_manual_record_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x10, 0x70, 0xEF, 0xF0, 0xE0, 0x77, 0x50, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xFF,
  0xE0, 0xD0, 0x27, 0x01, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x60, 0xCF, 0xFF, 0xB0, 0xC5, 0x07, 0xFF,
  0xFD, 0x07, 0x30, 0x10, 0xEF, 0xFF, 0xD0, 0xE0, 0x12, 0x09, 0xFF, 0xFF, 0x09, 0x20, 0xEF, 0xFF,
  0xF8, 0x1E, 0x04, 0xFF, 0xFF, 0xA0, 0x40, 0x9F, 0xFF, 0xFA, 0x09, 0x0B, 0xFF, 0xFF, 0xA0, 0xB0,
  0xDF, 0xFF, 0xFA, 0x0D, 0x0E, 0xFF, 0xFF, 0xA0, 0x0E, 0xFF, 0xFF, 0xA0, 0xE0, 0xDF, 0xFF, 0xFA,
  0x0D, 0x0B, 0xFF, 0xFF, 0xA0, 0xB0, 0x9F, 0xFF, 0xFA, 0x09, 0x04, 0xFF, 0xFF, 0xA8, 0x14, 0x0E,
  0xFF, 0xFF, 0x0E, 0x20, 0x9F, 0xFF, 0xF0, 0x92, 0x01, 0x0E, 0xFF, 0xFD, 0x0E, 0x01, 0x30, 0x7F,
  0xFF, 0xD0, 0x75, 0x0C, 0xFF, 0xFB, 0x0C, 0x60, 0x10, 0xDF, 0xFF, 0x90, 0xD0, 0x17, 0x02, 0x0D,
  0xFF, 0xE0, 0xD0, 0x27, 0x20, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x75, 0x07, 0x0E, 0xFF, 0x0E, 0x07,
  0x77, 0x18, 0x11, 0x9E, 0xFB, 0x81, 0xE9, 0x17, 0x75, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_fiber_manual_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_fiber_manual_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_fiber_new 48x48, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_filled_48_av_fiber_new_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0B, 0xD7, 0xF2, 0x02, 0xC0, 0x72, 0xA7, 0x1A, 0x20,
  0x7E, 0x07, 0x2E, 0x30, 0x6B, 0x07, 0x2A, 0x71, 0xA2, 0x07, 0xE0, 0x72, 0xE4, 0x0B, 0xA0, 0x72,
  0xA3, 0x80, 0x17, 0xA2, 0x81, 0x7F, 0xB2, 0x81, 0xBF, 0x72, 0xE4, 0x82, 0x1E, 0xF7, 0x2A, 0x3F,
  0x28, 0x17, 0xFB, 0x28, 0x1B, 0xF7, 0x2E, 0x58, 0x14, 0xF7, 0x2A, 0x38, 0x01, 0xBA, 0x28, 0x17,
  0xFB, 0x28, 0x1B, 0xF7, 0x2E, 0x20, 0x53, 0x08, 0x07, 0x2A, 0x71, 0xA2, 0x81, 0x7F, 0xB2, 0x81,
  0xBF, 0x72, 0xE2, 0x07, 0x09, 0x30, 0x52, 0xA7, 0x1A, 0x28, 0x17, 0xFB, 0x28, 0x1B, 0xF7, 0x2E,
  0x28, 0x17, 0xF5, 0x5A, 0x38, 0x01, 0xBA, 0x28, 0x17, 0xFB, 0x28, 0x1B, 0xF7, 0x2E, 0x28, 0x27,
  0xFE, 0x14, 0xA3, 0xF2, 0x81, 0x7F, 0xB2, 0x81, 0xBF, 0x72, 0xE2, 0x07, 0xA0, 0xB4, 0xA3, 0x80,
  0x17, 0xA7, 0x5E, 0x20, 0x7B, 0x07, 0x3A, 0x71, 0xA0, 0x17, 0x30, 0x1E, 0x20, 0x7C, 0x03, 0x2A,
  0x71, 0xA0, 0xB0, 0x17, 0x10, 0x10, 0xB8, 0x0B, 0xD7, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80,
  0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xEF, 0xFF, 0xFC, 0x81, 0xEA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_fiber_new() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_fiber_new_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_fiber_pin 48x48, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_filled_48_av_fiber_pin_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0xFF, 0xFF, 0xC8, 0x4E, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0B, 0xE0, 0xF7, 0x01, 0x07, 0xD3, 0xD2, 0x02, 0xC0,
  0x72, 0xF9, 0x72, 0x06, 0xC3, 0xD3, 0x06, 0xB0, 0x72, 0xF9, 0x72, 0x01, 0xC3, 0xD4, 0x0B, 0xA0,
  0x72, 0xF9, 0x3C, 0x3C, 0x3D, 0x48, 0x21, 0xEF, 0x72, 0xF9, 0x3C, 0x3C, 0x3D, 0x58, 0x14, 0xF7,
  0x2F, 0x97, 0x20, 0x1C, 0x3D, 0x20, 0x53, 0x08, 0x07, 0x2F, 0x97, 0x20, 0x6C, 0x3D, 0x20, 0x70,
  0x93, 0x05, 0x2F, 0x97, 0x01, 0x07, 0xD3, 0xD2, 0x81, 0x7F, 0x55, 0xF9, 0x3F, 0xC3, 0xD2, 0x82,
  0x7F, 0xE1, 0x4F, 0x93, 0xFC, 0x3D, 0x20, 0x7A, 0x0B, 0x4F, 0x93, 0xFC, 0x3D, 0x20, 0x7B, 0x07,
  0x3F, 0x93, 0xFC, 0x3D, 0x20, 0x7C, 0x03, 0x28, 0x0B, 0xE0, 0xF0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A,
  0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xEF, 0xFF, 0xFC, 0x81, 0xEA,
  0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_fiber_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_fiber_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_fiber_smart_record 48x48, 4-bit Alpha,  RLE, 280 bytes.
static const unsigned char ic_filled_48_av_fiber_smart_record_data[] PROGMEM = {
  0x74, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x40, 0x47, 0x75, 0x81, 0x19, 0xEF, 0xB8, 0x1E,
  0x91, 0x71, 0x98, 0x1E, 0x91, 0x77, 0x10, 0x70, 0xEF, 0xF0, 0xE0, 0x77, 0xB0, 0xE0, 0x77, 0x50,
  0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x5D, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xFF, 0xE0, 0xD0, 0x24, 0x0D,
  0xD0, 0xE0, 0x27, 0x01, 0x0D, 0xFF, 0xF9, 0x0D, 0x01, 0x40, 0x50, 0xDC, 0x0D, 0x01, 0x60, 0xCF,
  0xFF, 0xB0, 0xC5, 0x01, 0x0A, 0xC0, 0xC5, 0x07, 0xFF, 0xFD, 0x07, 0x60, 0x8C, 0x07, 0x30, 0x10,
  0xEF, 0xFF, 0xD0, 0xE0, 0x16, 0x0A, 0xC0, 0x12, 0x09, 0xFF, 0xFF, 0x09, 0x70, 0xDB, 0x08, 0x20,
  0xEF, 0xFF, 0xF0, 0xE7, 0x05, 0xB8, 0x1E, 0x04, 0xFF, 0xFF, 0xA0, 0x47, 0x0D, 0xB0, 0x40, 0x9F,
  0xFF, 0xFA, 0x09, 0x70, 0x8B, 0x08, 0x0B, 0xFF, 0xFF, 0xA0, 0xB7, 0x04, 0xB0, 0xC0, 0xDF, 0xFF,
  0xFA, 0x0D, 0x70, 0x1B, 0x0D, 0x0E, 0xFF, 0xFF, 0xA0, 0xE7, 0x1B, 0x00, 0xEF, 0xFF, 0xFA, 0x0E,
  0x71, 0xB0, 0xE0, 0xDF, 0xFF, 0xFA, 0x0D, 0x70, 0x1B, 0x0D, 0x0B, 0xFF, 0xFF, 0xA0, 0xB7, 0x04,
  0xB0, 0xC0, 0x9F, 0xFF, 0xFA, 0x09, 0x70, 0x8B, 0x08, 0x04, 0xFF, 0xFF, 0xA0, 0x47, 0x0D, 0xB8,
  0x14, 0x0E, 0xFF, 0xFF, 0x0E, 0x70, 0x5B, 0x0E, 0x20, 0x9F, 0xFF, 0xF0, 0x97, 0x0D, 0xB0, 0x82,
  0x01, 0x0E, 0xFF, 0xFD, 0x0E, 0x01, 0x60, 0xAC, 0x01, 0x30, 0x7F, 0xFF, 0xD0, 0x76, 0x08, 0xC0,
  0x75, 0x0C, 0xFF, 0xFB, 0x0C, 0x50, 0x10, 0xAC, 0x0C, 0x60, 0x10, 0xDF, 0xFF, 0x90, 0xD0, 0x14,
  0x05, 0x0D, 0xC0, 0xD0, 0x17, 0x02, 0x0D, 0xFF, 0xE0, 0xD0, 0x24, 0x0D, 0xD0, 0xE0, 0x27, 0x20,
  0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x5D, 0x0C, 0x01, 0x75, 0x07, 0x0E, 0xFF, 0x0E, 0x07, 0x7B, 0x0E,
  0x07, 0x77, 0x18, 0x11, 0x9E, 0xFB, 0x81, 0xE9, 0x17, 0x19, 0x81, 0xE9, 0x17, 0x75, 0x89, 0x04,
  0x9B, 0xDE, 0xED, 0xB9, 0x47, 0x40, 0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_fiber_smart_record() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 45, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_fiber_smart_record_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_forward_10 48x48, 4-bit Alpha,  RLE, 296 bytes.
static const unsigned char ic_filled_48_av_forward_10_data[] PROGMEM = {
  0x77, 0x20, 0x77, 0x77, 0x73, 0x90, 0x77, 0x77, 0x72, 0xA0, 0x77, 0x77, 0x71, 0xB0, 0x77, 0x77,
  0x7C, 0x07, 0x77, 0x76, 0xD0, 0x77, 0x77, 0x5E, 0x07, 0x77, 0x74, 0xF0, 0x77, 0x75, 0x83, 0x49,
  0xBD, 0xEF, 0x90, 0x77, 0x71, 0x81, 0x19, 0xEF, 0xF0, 0x77, 0x60, 0x70, 0xEF, 0xFA, 0x07, 0x74,
  0x01, 0x0C, 0xFF, 0xB0, 0x77, 0x40, 0x20, 0xDD, 0x82, 0xD9, 0x42, 0x1F, 0x07, 0x74, 0x01, 0x0D,
  0xC0, 0xD0, 0x65, 0xE0, 0x77, 0x50, 0xCC, 0x0A, 0x7D, 0x07, 0x75, 0x07, 0xC0, 0x87, 0x1C, 0x07,
  0x75, 0x01, 0x0E, 0xB0, 0xA7, 0x2B, 0x07, 0x76, 0x09, 0xB0, 0xD7, 0x3A, 0x07, 0x77, 0x0E, 0xB0,
  0x67, 0x39, 0x07, 0x77, 0x04, 0xB0, 0xD7, 0x40, 0x77, 0x71, 0x09, 0xB0, 0x97, 0x77, 0x60, 0xBB,
  0x04, 0x70, 0x40, 0x63, 0x82, 0x29, 0xB7, 0x74, 0x0D, 0xB0, 0x25, 0x82, 0x8E, 0xFB, 0x38, 0x3D,
  0xEA, 0xFA, 0x73, 0x0E, 0xB6, 0x82, 0xC7, 0xFB, 0x28, 0x55, 0xF5, 0x09, 0xF1, 0x72, 0x0E, 0xB7,
  0x19, 0x0B, 0x28, 0x57, 0xF3, 0x06, 0xF3, 0x5B, 0x0E, 0x0D, 0xB0, 0x27, 0x90, 0xB2, 0x85, 0x7F,
  0x30, 0x6F, 0x44, 0x02, 0xB0, 0xD0, 0xBB, 0x04, 0x79, 0x0B, 0x28, 0x57, 0xF3, 0x06, 0xF3, 0x40,
  0x4B, 0x0B, 0x09, 0xB0, 0x97, 0x90, 0xB2, 0x85, 0x5F, 0x40, 0x8F, 0x24, 0x09, 0xB0, 0x90, 0x4B,
  0x0D, 0x79, 0x0B, 0x28, 0x41, 0xEC, 0x6E, 0xC5, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x66, 0x0D, 0x09,
  0x38, 0x34, 0xDF, 0xB2, 0x40, 0x6B, 0x0E, 0x20, 0x9B, 0x0D, 0x77, 0x60, 0xDB, 0x09, 0x20, 0x10,
  0xEB, 0x0A, 0x77, 0x40, 0xAB, 0x0E, 0x01, 0x30, 0x7C, 0x08, 0x77, 0x20, 0x8C, 0x07, 0x50, 0xCC,
  0x0A, 0x77, 0x0A, 0xC0, 0xC6, 0x01, 0x0D, 0xC0, 0xD0, 0x67, 0x30, 0x60, 0xDC, 0x0D, 0x01, 0x70,
  0x20, 0xDD, 0x82, 0xD9, 0x42, 0x28, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x72, 0x01, 0x0C, 0xFF, 0xC0,
  0xC0, 0x17, 0x50, 0x70, 0xEF, 0xF0, 0xE0, 0x77, 0x71, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77,
  0x58, 0x90, 0x49, 0xBD, 0xEE, 0xDB, 0x94, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_forward_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_forward_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_forward_30 48x48, 4-bit Alpha,  RLE, 311 bytes.
static const unsigned char ic_filled_48_av_forward_30_data[] PROGMEM = {
  0x77, 0x20, 0x77, 0x77, 0x73, 0x90, 0x77, 0x77, 0x72, 0xA0, 0x77, 0x77, 0x71, 0xB0, 0x77, 0x77,
  0x7C, 0x07, 0x77, 0x76, 0xD0, 0x77, 0x77, 0x5E, 0x07, 0x77, 0x74, 0xF0, 0x77, 0x75, 0x83, 0x49,
  0xBD, 0xEF, 0x90, 0x77, 0x71, 0x81, 0x19, 0xEF, 0xF0, 0x77, 0x60, 0x70, 0xEF, 0xFA, 0x07, 0x74,
  0x01, 0x0C, 0xFF, 0xB0, 0x77, 0x40, 0x20, 0xDD, 0x82, 0xD9, 0x42, 0x1F, 0x07, 0x74, 0x01, 0x0D,
  0xC0, 0xD0, 0x65, 0xE0, 0x77, 0x50, 0xCC, 0x0A, 0x7D, 0x07, 0x75, 0x07, 0xC0, 0x87, 0x1C, 0x07,
  0x75, 0x01, 0x0E, 0xB0, 0xA7, 0x2B, 0x07, 0x76, 0x09, 0xB0, 0xD7, 0x3A, 0x07, 0x77, 0x0E, 0xB0,
  0x67, 0x39, 0x07, 0x77, 0x04, 0xB0, 0xD7, 0x40, 0x77, 0x71, 0x09, 0xB0, 0x97, 0x77, 0x60, 0xBB,
  0x04, 0x58, 0x23, 0x89, 0x54, 0x82, 0x59, 0x81, 0x73, 0x0D, 0xB0, 0x24, 0x84, 0x4F, 0xDC, 0xF8,
  0x28, 0x38, 0xFC, 0xED, 0x73, 0x0E, 0xB5, 0x84, 0x59, 0x10, 0xCE, 0x28, 0x4E, 0xB0, 0x4F, 0x57,
  0x20, 0xEB, 0x71, 0x89, 0x12, 0xDC, 0x02, 0xF8, 0x01, 0xF8, 0x5B, 0x0E, 0x0D, 0xB0, 0x26, 0x89,
  0x2D, 0xFE, 0x20, 0x2F, 0x80, 0x1F, 0x84, 0x02, 0xB0, 0xD0, 0xBB, 0x04, 0x68, 0x92, 0x36, 0xEB,
  0x02, 0xF8, 0x01, 0xF8, 0x40, 0x4B, 0x0B, 0x09, 0xB0, 0x94, 0x04, 0x05, 0x28, 0x90, 0x9F, 0x01,
  0xF9, 0x02, 0xF7, 0x40, 0x9B, 0x09, 0x04, 0xB0, 0xD4, 0x84, 0x9F, 0x75, 0xDD, 0x28, 0x4C, 0xE4,
  0xAF, 0x34, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x63, 0x01, 0x0B, 0xA0, 0xD0, 0x32, 0x83, 0x2D, 0xFE,
  0x74, 0x06, 0xB0, 0xE2, 0x09, 0xB0, 0xD5, 0x00, 0x16, 0x01, 0x60, 0xDB, 0x09, 0x20, 0x10, 0xEB,
  0x0A, 0x77, 0x40, 0xAB, 0x0E, 0x01, 0x30, 0x7C, 0x08, 0x77, 0x20, 0x8C, 0x07, 0x50, 0xCC, 0x0A,
  0x77, 0x0A, 0xC0, 0xC6, 0x01, 0x0D, 0xC0, 0xD0, 0x67, 0x30, 0x60, 0xDC, 0x0D, 0x01, 0x70, 0x20,
  0xDD, 0x82, 0xD9, 0x42, 0x28, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x72, 0x01, 0x0C, 0xFF, 0xC0, 0xC0,
  0x17, 0x50, 0x70, 0xEF, 0xF0, 0xE0, 0x77, 0x71, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77, 0x58,
  0x90, 0x49, 0xBD, 0xEE, 0xDB, 0x94, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_forward_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_forward_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_forward_5 48x48, 4-bit Alpha,  RLE, 276 bytes.
static const unsigned char ic_filled_48_av_forward_5_data[] PROGMEM = {
  0x77, 0x20, 0x77, 0x77, 0x73, 0x90, 0x77, 0x77, 0x72, 0xA0, 0x77, 0x77, 0x71, 0xB0, 0x77, 0x77,
  0x7C, 0x07, 0x77, 0x76, 0xD0, 0x77, 0x77, 0x5E, 0x07, 0x77, 0x74, 0xF0, 0x77, 0x75, 0x83, 0x49,
  0xBD, 0xEF, 0x90, 0x77, 0x71, 0x81, 0x19, 0xEF, 0xF0, 0x77, 0x60, 0x70, 0xEF, 0xFA, 0x07, 0x74,
  0x01, 0x0C, 0xFF, 0xB0, 0x77, 0x40, 0x20, 0xDD, 0x82, 0xD9, 0x42, 0x1F, 0x07, 0x74, 0x01, 0x0D,
  0xC0, 0xD0, 0x65, 0xE0, 0x77, 0x50, 0xCC, 0x0A, 0x7D, 0x07, 0x75, 0x07, 0xC0, 0x87, 0x1C, 0x07,
  0x75, 0x01, 0x0E, 0xB0, 0xA7, 0x2B, 0x07, 0x76, 0x09, 0xB0, 0xD7, 0x3A, 0x07, 0x77, 0x0E, 0xB0,
  0x67, 0x39, 0x07, 0x77, 0x04, 0xB0, 0xD7, 0x40, 0x77, 0x71, 0x09, 0xB0, 0x97, 0x77, 0x60, 0xBB,
  0x04, 0x71, 0x84, 0x17, 0x77, 0x75, 0x76, 0x0D, 0xB0, 0x27, 0x18, 0x43, 0xFE, 0xDD, 0x97, 0x60,
  0xEB, 0x72, 0x81, 0x5F, 0x37, 0x72, 0x0E, 0xB7, 0x28, 0x36, 0xF7, 0x84, 0x73, 0xB0, 0xE0, 0xDB,
  0x02, 0x71, 0x84, 0x7F, 0xBD, 0xF7, 0x71, 0x02, 0xB0, 0xD0, 0xBB, 0x04, 0x75, 0x00, 0xD7, 0x10,
  0x4B, 0x0B, 0x09, 0xB0, 0x97, 0x10, 0x40, 0x52, 0x0C, 0x0D, 0x71, 0x09, 0xB0, 0x90, 0x4B, 0x0D,
  0x71, 0x84, 0x8F, 0x65, 0xFA, 0x71, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x67, 0x10, 0xAA, 0x0B, 0x01,
  0x70, 0x6B, 0x0E, 0x20, 0x9B, 0x0D, 0x77, 0x60, 0xDB, 0x09, 0x20, 0x10, 0xEB, 0x0A, 0x77, 0x40,
  0xAB, 0x0E, 0x01, 0x30, 0x7C, 0x08, 0x77, 0x20, 0x8C, 0x07, 0x50, 0xCC, 0x0A, 0x77, 0x0A, 0xC0,
  0xC6, 0x01, 0x0D, 0xC0, 0xD0, 0x67, 0x30, 0x60, 0xDC, 0x0D, 0x01, 0x70, 0x20, 0xDD, 0x82, 0xD9,
  0x42, 0x28, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x72, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x70,
  0xEF, 0xF0, 0xE0, 0x77, 0x71, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77, 0x58, 0x90, 0x49, 0xBD,
  0xEE, 0xDB, 0x94, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_forward_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_forward_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_games 48x48, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_filled_48_av_games_data[] PROGMEM = {
  0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77,
  0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD, 0x77, 0x77, 0xFD,
  0x77, 0x77, 0x07, 0xFB, 0x07, 0x77, 0x77, 0x10, 0x7F, 0x90, 0x77, 0x77, 0x73, 0x07, 0xE0, 0x77,
  0x72, 0xFC, 0x07, 0x50, 0x7C, 0x07, 0x50, 0x7F, 0xFF, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xFF,
  0xFC, 0x07, 0x50, 0x07, 0x50, 0x7F, 0xFF, 0xE0, 0x77, 0x30, 0x7F, 0xFF, 0xF9, 0x07, 0x71, 0x07,
  0xFF, 0xFF, 0xB0, 0x76, 0x07, 0xFF, 0xFF, 0xC0, 0x76, 0x07, 0xFF, 0xFF, 0xB0, 0x77, 0x10, 0x7F,
  0xFF, 0xF9, 0x07, 0x73, 0x07, 0xFF, 0xFE, 0x07, 0x50, 0x07, 0x50, 0x7F, 0xFF, 0xC0, 0x75, 0x07,
  0xA0, 0x75, 0x07, 0xFF, 0xFA, 0x07, 0x50, 0x7C, 0x07, 0x50, 0x7F, 0xC7, 0x72, 0x07, 0xE0, 0x77,
  0x77, 0x73, 0x07, 0xF9, 0x07, 0x77, 0x77, 0x10, 0x7F, 0xB0, 0x77, 0x77, 0x7F, 0xD7, 0x77, 0x7F,
  0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7,
  0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x77, 0x7F, 0xD7, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_games() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_games_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_hd 48x48, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_filled_48_av_hd_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x2F, 0x3C, 0x3C, 0x71, 0x01, 0x0B, 0xFD, 0x3C,
  0x3C, 0x72, 0x01, 0xFD, 0x3C, 0x3C, 0x73, 0xFD, 0x3C, 0x3C, 0x3C, 0x3F, 0xD3, 0xC3, 0xC3, 0xC3,
  0xFD, 0x73, 0xC3, 0xC3, 0xFD, 0x73, 0xC3, 0xC3, 0xFD, 0x73, 0xC3, 0xC3, 0xFD, 0x3C, 0x3C, 0x3C,
  0x3F, 0xD3, 0xC3, 0xC7, 0x3F, 0xD3, 0xC3, 0xC7, 0x20, 0x1F, 0xD3, 0xC3, 0xC7, 0x10, 0x10, 0xB8,
  0x0C, 0xC2, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF, 0xFF, 0xC8,
  0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_hd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_hd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_hearing_disabled 48x48, 4-bit Alpha,  RLE, 433 bytes.
static const unsigned char ic_filled_48_av_hearing_disabled_data[] PROGMEM = {
  0x77, 0x77, 0x40, 0x48, 0x0C, 0x20, 0x81, 0x7F, 0x87, 0x74, 0x89, 0x04, 0x8B, 0xDF, 0xED, 0xB8,
  0x37, 0x10, 0x7B, 0x05, 0x70, 0x27, 0x06, 0x0D, 0xFB, 0x0D, 0x05, 0x50, 0x10, 0xEB, 0x0E, 0x02,
  0x58, 0x14, 0xF7, 0x50, 0x9F, 0xF0, 0xC0, 0x24, 0x04, 0xC0, 0xB4, 0x04, 0xB0, 0x75, 0x0C, 0xFF,
  0x0E, 0x05, 0x40, 0x6C, 0x05, 0x30, 0xEC, 0x07, 0x58, 0x3C, 0xFA, 0x52, 0x28, 0x12, 0x59, 0xE0,
  0x54, 0x0B, 0xB0, 0xC3, 0x03, 0x0E, 0xC0, 0x75, 0x01, 0x71, 0x01, 0x09, 0xC0, 0xE0, 0x23, 0x03,
  0xC0, 0x43, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0x06, 0xC0, 0xC4, 0x0A, 0xB0, 0xA4, 0x03, 0x0E, 0xC0,
  0x77, 0x71, 0x06, 0xC0, 0x53, 0x03, 0xC5, 0x03, 0xD0, 0x77, 0x71, 0x09, 0xB0, 0xD4, 0x0E, 0xB0,
  0x44, 0x03, 0xE0, 0x75, 0x82, 0xBE, 0xB4, 0x50, 0x1C, 0x03, 0x30, 0x9B, 0x08, 0x40, 0x7F, 0x07,
  0x50, 0xCA, 0x08, 0x50, 0x9B, 0x08, 0x30, 0x5B, 0x0A, 0x40, 0xBF, 0x90, 0x75, 0x0C, 0xA0, 0x44,
  0x05, 0xB0, 0xB3, 0x03, 0xB0, 0xD4, 0x0D, 0xB0, 0x60, 0xEC, 0x07, 0x58, 0x1C, 0xFB, 0x40, 0x2B,
  0x0D, 0x30, 0x2B, 0x0E, 0x40, 0xEB, 0x10, 0x30, 0xEC, 0x07, 0x50, 0xC0, 0xE5, 0xB0, 0xE4, 0xC7,
  0x30, 0x30, 0xEC, 0x07, 0x50, 0xB4, 0x01, 0xB0, 0xE4, 0xB0, 0xE7, 0x40, 0x30, 0xEC, 0x07, 0x72,
  0x03, 0xB0, 0xD3, 0x01, 0xB0, 0xD7, 0x50, 0x30, 0xEC, 0x07, 0x71, 0x05, 0xB0, 0xB3, 0x03, 0xB0,
  0xC7, 0x60, 0x30, 0xEC, 0x07, 0x70, 0xAB, 0x08, 0x30, 0x5B, 0x0A, 0x77, 0x03, 0x0E, 0xC0, 0x75,
  0x01, 0xC0, 0x33, 0x09, 0xB0, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xA0, 0xD4, 0x0D, 0xB0,
  0x37, 0x72, 0x03, 0x0E, 0xC0, 0x74, 0x82, 0x1C, 0xF7, 0x30, 0x4B, 0x0E, 0x77, 0x40, 0x30, 0xEC,
  0x07, 0x40, 0x10, 0xB4, 0x0A, 0xB0, 0xA7, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x10, 0x2C, 0x03, 0x77,
  0x60, 0x30, 0xEC, 0x07, 0x70, 0xCB, 0x0B, 0x77, 0x71, 0x03, 0x0E, 0xC0, 0x75, 0x05, 0xC0, 0x47,
  0x77, 0x10, 0x20, 0xDD, 0x07, 0x50, 0xCA, 0x0A, 0x77, 0x71, 0x03, 0x0E, 0xF0, 0x75, 0x81, 0xCE,
  0x17, 0x77, 0x02, 0x0E, 0xFA, 0x07, 0x50, 0x47, 0x77, 0x10, 0xDC, 0x81, 0x93, 0xEC, 0x07, 0x77,
  0x75, 0x06, 0xC0, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x40, 0xDB, 0x09, 0x40, 0x30, 0xEC, 0x07,
  0x77, 0x72, 0x04, 0xB0, 0xE0, 0x15, 0x03, 0x0E, 0xC0, 0x77, 0x30, 0xEB, 0x01, 0x70, 0xBB, 0x09,
  0x70, 0x30, 0xEC, 0x07, 0x72, 0x0C, 0xB0, 0x56, 0x03, 0xC0, 0x37, 0x10, 0x30, 0xEC, 0x07, 0x71,
  0x08, 0xB0, 0xD0, 0x14, 0x01, 0x0D, 0xB0, 0xC7, 0x30, 0x30, 0xEC, 0x07, 0x70, 0x2C, 0x84, 0xD5,
  0x10, 0x5D, 0xC0, 0x37, 0x40, 0x30, 0xEC, 0x07, 0x70, 0x9F, 0xD0, 0x97, 0x60, 0x30, 0xEC, 0x07,
  0x70, 0xBF, 0xB0, 0xA7, 0x71, 0x03, 0x0E, 0xC0, 0x77, 0x09, 0xF9, 0x07, 0x77, 0x30, 0x30, 0xEC,
  0x02, 0x78, 0x62, 0x8C, 0xEE, 0xD8, 0x27, 0x75, 0x03, 0x0E, 0xA0, 0x48, 0x0C, 0x00, 0x81, 0x3E,
  0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_hearing_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 42, 44), Box(0, 0, 47, 47),
      ic_filled_48_av_hearing_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_hearing 48x48, 4-bit Alpha,  RLE, 358 bytes.
static const unsigned char ic_filled_48_av_hearing_data[] PROGMEM = {
  0x60, 0x47, 0x77, 0x76, 0x81, 0x8F, 0x77, 0x77, 0x74, 0x05, 0xB0, 0x77, 0x18, 0x90, 0x38, 0xBD,
  0xEE, 0xDB, 0x83, 0x75, 0x02, 0x0E, 0xB0, 0xE0, 0x15, 0x05, 0x0D, 0xFB, 0x0D, 0x05, 0x73, 0x0B,
  0xC0, 0x44, 0x02, 0x0C, 0xFF, 0x0C, 0x02, 0x70, 0x5C, 0x06, 0x40, 0x50, 0xEF, 0xFA, 0x0E, 0x05,
  0x60, 0xCB, 0x0B, 0x40, 0x5E, 0x81, 0x95, 0x22, 0x81, 0x25, 0x9E, 0x05, 0x40, 0x4C, 0x03, 0x30,
  0x20, 0xEC, 0x09, 0x01, 0x71, 0x01, 0x09, 0xC0, 0xE0, 0x23, 0x0A, 0xB0, 0xA4, 0x0C, 0xC0, 0x67,
  0x50, 0x6C, 0x0C, 0x3C, 0x03, 0x30, 0x5C, 0x06, 0x77, 0x06, 0xC8, 0x15, 0x04, 0xB0, 0xE4, 0x0D,
  0xB0, 0x97, 0x72, 0x09, 0xB8, 0x1D, 0x08, 0xB0, 0x93, 0x03, 0xC0, 0x15, 0x84, 0x4B, 0xEE, 0xB4,
  0x50, 0x1C, 0x03, 0x0A, 0xB0, 0x53, 0x08, 0xB0, 0x95, 0x08, 0xE0, 0x85, 0x09, 0xB0, 0x80, 0xDB,
  0x03, 0x30, 0xBB, 0x05, 0x40, 0x4F, 0x90, 0x44, 0x05, 0xB0, 0xB0, 0xEB, 0x02, 0x30, 0xDB, 0x02,
  0x40, 0xBF, 0x90, 0xB4, 0x02, 0xB0, 0xDC, 0x40, 0xEB, 0x50, 0xEF, 0x90, 0xE5, 0xB0, 0xEC, 0x40,
  0xEB, 0x50, 0xEF, 0x90, 0xE7, 0x20, 0xEB, 0x02, 0x30, 0xDB, 0x02, 0x40, 0xBF, 0x90, 0xB7, 0x20,
  0xDB, 0x03, 0x30, 0xBB, 0x05, 0x40, 0x4F, 0x90, 0x47, 0x20, 0xAB, 0x05, 0x30, 0x8B, 0x09, 0x50,
  0x8E, 0x08, 0x73, 0x08, 0xB0, 0x93, 0x03, 0xB0, 0xE6, 0x84, 0x4B, 0xEE, 0xB4, 0x74, 0x04, 0xB0,
  0xE4, 0x0D, 0xB0, 0x77, 0x77, 0x2C, 0x03, 0x30, 0x7B, 0x0E, 0x01, 0x77, 0x71, 0x0A, 0xB0, 0xA4,
  0x0E, 0xB0, 0xA7, 0x77, 0x10, 0x4C, 0x03, 0x30, 0x6C, 0x08, 0x77, 0x71, 0x0C, 0xB0, 0xB4, 0x0B,
  0xC0, 0x87, 0x77, 0x05, 0xC0, 0x63, 0x01, 0x0D, 0xC0, 0xA7, 0x77, 0x0B, 0xC0, 0x43, 0x02, 0x0E,
  0xC0, 0xC0, 0x27, 0x75, 0x02, 0x0E, 0xB0, 0xE0, 0x13, 0x02, 0x0E, 0xC0, 0xE0, 0x37, 0x75, 0x05,
  0xB0, 0x75, 0x01, 0x0C, 0xC0, 0xE0, 0x27, 0x75, 0x81, 0x8F, 0x77, 0x10, 0x9C, 0x0C, 0x77, 0x60,
  0x47, 0x30, 0x7C, 0x06, 0x77, 0x77, 0x30, 0x9B, 0x0D, 0x77, 0x77, 0x30, 0x10, 0xEB, 0x04, 0x77,
  0x77, 0x30, 0x9B, 0x0A, 0x70, 0x1B, 0x0E, 0x77, 0x50, 0x3C, 0x03, 0x60, 0x5B, 0x0C, 0x77, 0x60,
  0xCB, 0x0D, 0x01, 0x40, 0x10, 0xDB, 0x08, 0x77, 0x60, 0x3C, 0x84, 0xD5, 0x01, 0x5D, 0xC0, 0x27,
  0x77, 0x09, 0xFD, 0x09, 0x77, 0x72, 0x0A, 0xFB, 0x0B, 0x77, 0x74, 0x07, 0xF9, 0x09, 0x77, 0x76,
  0x86, 0x28, 0xDE, 0xEC, 0x82, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_hearing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 41, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_hearing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_high_quality 48x48, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_filled_48_av_high_quality_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xBB, 0x2F, 0x3C, 0x3C, 0x0B, 0x01, 0x60, 0x10, 0xBF,
  0xD3, 0xC3, 0xC0, 0x17, 0x10, 0x1F, 0xD3, 0xC3, 0xC7, 0x3F, 0xD3, 0xC3, 0xC3, 0xC3, 0xFD, 0x3C,
  0x3C, 0x3C, 0x3F, 0xD7, 0x3C, 0x3C, 0x3F, 0xD7, 0x3C, 0x3C, 0x3F, 0xD7, 0x3C, 0x3C, 0x3F, 0xD3,
  0xC3, 0xC3, 0xC3, 0xFD, 0x3C, 0x3C, 0x73, 0xFD, 0x3C, 0x3C, 0x01, 0x71, 0x01, 0xFD, 0x3C, 0x3C,
  0x0B, 0x01, 0x60, 0x10, 0xBF, 0xFF, 0xF9, 0x07, 0x20, 0x7F, 0xFF, 0xFC, 0x07, 0x20, 0x7F, 0xFF,
  0xFC, 0x07, 0x20, 0x78, 0x09, 0xE1, 0xF0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A,
  0x1E, 0xFF, 0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_high_quality() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_high_quality_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_interpreter_mode 48x48, 4-bit Alpha,  RLE, 292 bytes.
static const unsigned char ic_filled_48_av_interpreter_mode_data[] PROGMEM = {
  0x75, 0x85, 0x28, 0xCE, 0xEC, 0x55, 0x86, 0x28, 0xCE, 0xEC, 0x82, 0x77, 0x74, 0x09, 0xD0, 0xD0,
  0x14, 0x09, 0xF9, 0x09, 0x77, 0x72, 0x0B, 0xE0, 0x54, 0x0B, 0xFB, 0x0B, 0x77, 0x70, 0x9E, 0x0D,
  0x40, 0x9F, 0xD0, 0x97, 0x75, 0x02, 0xF0, 0x83, 0x02, 0xFF, 0x02, 0x77, 0x40, 0x8F, 0x04, 0x30,
  0x8F, 0xF0, 0x87, 0x74, 0x0C, 0xF0, 0x23, 0x0C, 0xFF, 0x0C, 0x77, 0x40, 0xEF, 0x40, 0xEF, 0xF0,
  0xE7, 0x74, 0x0E, 0xF4, 0x0E, 0xFF, 0x0E, 0x77, 0x40, 0xCF, 0x02, 0x30, 0xCF, 0xF0, 0xC7, 0x74,
  0x08, 0xF0, 0x43, 0x08, 0xFF, 0x08, 0x77, 0x40, 0x2F, 0x08, 0x30, 0x2F, 0xF0, 0x27, 0x75, 0x09,
  0xE0, 0xD4, 0x09, 0xFD, 0x09, 0x77, 0x70, 0xBE, 0x05, 0x40, 0xBF, 0xB0, 0xB7, 0x77, 0x20, 0x9D,
  0x0D, 0x01, 0x40, 0x9F, 0x90, 0x94, 0x82, 0x8D, 0xD8, 0x77, 0x38, 0x52, 0x8C, 0xEE, 0xC5, 0x58,
  0x62, 0x8C, 0xEE, 0xC8, 0x24, 0x08, 0xC0, 0x88, 0x0C, 0x40, 0x0D, 0xC0, 0xD8, 0x0C, 0x40, 0xE7,
  0x68, 0x13, 0x66, 0x72, 0x84, 0x26, 0x8B, 0xDD, 0xA0, 0xD0, 0x15, 0xE7, 0x38, 0x44, 0x9E, 0xFB,
  0x16, 0x81, 0x49, 0xEF, 0x90, 0x96, 0xE7, 0x81, 0x17, 0xDB, 0x0E, 0x01, 0x50, 0x70, 0xDF, 0xC0,
  0x56, 0xE6, 0x05, 0x0E, 0xD0, 0x54, 0x05, 0x0E, 0xFE, 0x01, 0x6E, 0x50, 0x7E, 0x0D, 0x40, 0x7F,
  0xF9, 0x30, 0xE9, 0x20, 0xDC, 0x0D, 0x29, 0x0E, 0x03, 0xF0, 0x73, 0x03, 0xFF, 0xA3, 0x83, 0xCF,
  0x30, 0x8C, 0x84, 0x80, 0x3F, 0xC9, 0xF0, 0x33, 0x09, 0xFF, 0xA0, 0x22, 0x81, 0x7F, 0xA2, 0x82,
  0x8D, 0xD8, 0x28, 0x2A, 0xF7, 0xDF, 0x01, 0x30, 0xDF, 0xFA, 0x05, 0x28, 0x21, 0xEF, 0x76, 0x82,
  0x7F, 0xE1, 0xF9, 0x4F, 0xFB, 0x0A, 0x30, 0x5A, 0x0A, 0x03, 0x20, 0x30, 0xAA, 0x05, 0x1F, 0x94,
  0xFF, 0xC0, 0x13, 0x05, 0x0E, 0xE0, 0xE0, 0x52, 0xF9, 0x4F, 0xFC, 0x0A, 0x48, 0x11, 0x7C, 0xA8,
  0x1C, 0x71, 0x3F, 0x94, 0xFF, 0xD0, 0x66, 0xA6, 0xF9, 0x4F, 0xFE, 0x06, 0x5A, 0x6F, 0x94, 0xFF,
  0xF0, 0xA0, 0x13, 0xA6,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_interpreter_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 47, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_interpreter_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_library_add_check 48x48, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_filled_48_av_library_add_check_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF,
  0xFC, 0x71, 0xFF, 0xFF, 0xC7, 0x18, 0x0C, 0x0F, 0x4F, 0xFF, 0x90, 0xA0, 0x5F, 0xD4, 0xFF, 0xF0,
  0xA2, 0x05, 0xFC, 0x4F, 0xFE, 0x0A, 0x40, 0x5F, 0xB4, 0xFF, 0xD0, 0xA5, 0x0A, 0xFB, 0x4F, 0xFC,
  0x0A, 0x50, 0xAF, 0xC4, 0xFF, 0xB0, 0xB5, 0x09, 0xFD, 0x4F, 0x90, 0x80, 0xCE, 0x0B, 0x50, 0x9F,
  0xE4, 0xF8, 0x27, 0x01, 0xCC, 0x0B, 0x50, 0x9F, 0xF4, 0xE0, 0x73, 0x01, 0x0C, 0xA0, 0xB5, 0x09,
  0xFF, 0x94, 0xE0, 0x74, 0x81, 0x1C, 0xB5, 0x09, 0xFF, 0xA4, 0xF0, 0x74, 0x01, 0x50, 0x9F, 0xFB,
  0x4F, 0x90, 0x77, 0x10, 0x9F, 0xFC, 0x4F, 0xA0, 0x76, 0x09, 0xFF, 0xD4, 0xFB, 0x07, 0x40, 0x9F,
  0xFE, 0x4F, 0xC0, 0x72, 0x08, 0xFF, 0xF4, 0xFD, 0x06, 0x08, 0xFF, 0xF9, 0x48, 0x0C, 0x0F, 0x48,
  0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x40, 0xDF, 0xFF, 0xFA, 0x0D, 0xC4, 0x0A, 0xFF,
  0xFF, 0xA0, 0xAC, 0x40, 0x10, 0xEF, 0xFF, 0xF0, 0xE0, 0x1C, 0x58, 0x11, 0xAD, 0xFF, 0xFB, 0x81,
  0xDA, 0x11, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0x0D, 0xFF,
  0xFF, 0xB7, 0x10, 0xAF, 0xFF, 0xFB, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA7, 0x28, 0x11, 0xAD, 0xFF,
  0xFF, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_library_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_library_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_library_add 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_filled_48_av_library_add_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF,
  0xFC, 0x71, 0xFF, 0x4F, 0xF7, 0x1F, 0xF4, 0xFF, 0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4,
  0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4, 0xE7, 0x76,
  0xFB, 0x4E, 0x77, 0x6F, 0xB4, 0xE7, 0x76, 0xFB, 0x4E, 0x77, 0x6F, 0xB4, 0xFF, 0x4F, 0xFC, 0x4F,
  0xF4, 0xFF, 0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF,
  0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x0D, 0xFF,
  0xFF, 0xA0, 0xDC, 0x40, 0xAF, 0xFF, 0xFA, 0x0A, 0xC4, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0xC5,
  0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x1C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0,
  0x0C, 0x80, 0xC0, 0x00, 0xDF, 0xFF, 0xFB, 0x71, 0x0A, 0xFF, 0xFF, 0xB7, 0x10, 0x10, 0xEF, 0xFF,
  0xFA, 0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xF7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_library_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_library_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_library_books 48x48, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_filled_48_av_library_books_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF,
  0xFC, 0x71, 0xE7, 0x76, 0xE7, 0x1E, 0x77, 0x6F, 0xB4, 0xE7, 0x76, 0xFB, 0x4E, 0x77, 0x6F, 0xB4,
  0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0xE7, 0x76, 0xFB, 0x4E,
  0x77, 0x6F, 0xB4, 0xE7, 0x76, 0xFB, 0x4E, 0x77, 0x6F, 0xB4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4,
  0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0xE7, 0x5F, 0xFC, 0x4E, 0x75, 0xFF, 0xC4, 0xE7, 0x5F, 0xFC,
  0x4E, 0x75, 0xFF, 0xC4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x0D, 0xFF, 0xFF, 0xA0, 0xDC, 0x40,
  0xAF, 0xFF, 0xFA, 0x0A, 0xC4, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0xC5, 0x81, 0x1A, 0xDF, 0xFF,
  0xB8, 0x1D, 0xA1, 0x1C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x00,
  0xDF, 0xFF, 0xFB, 0x71, 0x0A, 0xFF, 0xFF, 0xB7, 0x10, 0x10, 0xEF, 0xFF, 0xFA, 0x72, 0x81, 0x1A,
  0xDF, 0xFF, 0xF7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_library_books() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_library_books_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_library_music 48x48, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_filled_48_av_library_music_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF,
  0xFC, 0x71, 0xFF, 0xA7, 0x1F, 0x97, 0x1F, 0xFA, 0x71, 0xFD, 0x4F, 0xFA, 0x71, 0xFD, 0x4F, 0xFA,
  0x71, 0xFD, 0x4F, 0xFA, 0x2F, 0xFC, 0x4F, 0xFA, 0x2F, 0xFC, 0x4F, 0xFA, 0x2F, 0xFC, 0x4F, 0xFA,
  0x2F, 0xFC, 0x4F, 0xFA, 0x2F, 0xFC, 0x4F, 0xFA, 0x2F, 0xFC, 0x4F, 0xB8, 0x4A, 0x30, 0x14, 0xB2,
  0xFF, 0xC4, 0xFA, 0x07, 0x71, 0xFF, 0xC4, 0xF9, 0x0A, 0x72, 0xFF, 0xC4, 0xF9, 0x03, 0x72, 0xFF,
  0xC4, 0xF9, 0x73, 0xFF, 0xC4, 0xF9, 0x73, 0xFF, 0xC4, 0xF9, 0x03, 0x71, 0x03, 0xFF, 0xC4, 0xF9,
  0x0A, 0x71, 0x0A, 0xFF, 0xC4, 0xFA, 0x07, 0x60, 0x7F, 0xFD, 0x4F, 0xB0, 0xA0, 0x32, 0x03, 0x0A,
  0xFF, 0xE4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x0D, 0xFF, 0xFF, 0xA0, 0xDC, 0x40, 0xAF, 0xFF,
  0xFA, 0x0A, 0xC4, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0xC5, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D,
  0xA1, 0x1C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x00, 0xDF, 0xFF,
  0xFB, 0x71, 0x0A, 0xFF, 0xFF, 0xB7, 0x10, 0x10, 0xEF, 0xFF, 0xFA, 0x72, 0x81, 0x1A, 0xDF, 0xFF,
  0xF7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_library_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_library_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_loop 48x48, 4-bit Alpha,  RLE, 270 bytes.
static const unsigned char ic_filled_48_av_loop_data[] PROGMEM = {
  0x77, 0x10, 0x77, 0x77, 0x72, 0x07, 0x97, 0x77, 0x71, 0x07, 0xA7, 0x77, 0x70, 0x7B, 0x77, 0x76,
  0x07, 0xC7, 0x77, 0x50, 0x7D, 0x77, 0x74, 0x07, 0xE8, 0x3E, 0xDB, 0x94, 0x77, 0x50, 0x7F, 0xD8,
  0x1E, 0x91, 0x77, 0x20, 0x7F, 0xF0, 0xE0, 0x77, 0x72, 0x07, 0xFF, 0x90, 0xC0, 0x17, 0x71, 0x07,
  0xD1, 0x82, 0x24, 0x9D, 0xD0, 0xD0, 0x27, 0x71, 0x07, 0xC5, 0x06, 0x0D, 0xC0, 0xD0, 0x17, 0x71,
  0x07, 0xB7, 0x0A, 0xC0, 0xC5, 0x03, 0x73, 0x07, 0xA7, 0x10, 0x8C, 0x07, 0x38, 0x11, 0xE7, 0x73,
  0x07, 0x97, 0x20, 0xAB, 0x0E, 0x01, 0x20, 0x9A, 0x07, 0x73, 0x07, 0x73, 0x0D, 0xB0, 0x92, 0x0E,
  0xB0, 0x37, 0x76, 0x06, 0xB8, 0x1E, 0x05, 0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x04, 0x08, 0xB0, 0x87,
  0x77, 0x10, 0x9B, 0x09, 0x0C, 0xB0, 0x47, 0x77, 0x10, 0x4B, 0x0B, 0x0D, 0xB0, 0x17, 0x77, 0x10,
  0x2B, 0x0D, 0x0E, 0xB7, 0x77, 0x3B, 0x00, 0xEB, 0x77, 0x73, 0xB0, 0xE0, 0xDB, 0x02, 0x77, 0x71,
  0x01, 0xB0, 0xD0, 0xBB, 0x04, 0x77, 0x71, 0x04, 0xB0, 0xC0, 0x9B, 0x09, 0x77, 0x71, 0x08, 0xB0,
  0x80, 0x4B, 0x0D, 0x77, 0x71, 0x0D, 0xB8, 0x15, 0x0E, 0xB0, 0x67, 0x76, 0x03, 0xB0, 0xE2, 0x09,
  0xB0, 0xD7, 0x30, 0x77, 0x30, 0x7A, 0x09, 0x20, 0x10, 0xEB, 0x0A, 0x72, 0x90, 0x77, 0x38, 0x17,
  0xE1, 0x30, 0x7C, 0x08, 0x71, 0xA0, 0x77, 0x30, 0x35, 0x0C, 0xC0, 0xA7, 0xB0, 0x77, 0x71, 0x01,
  0x0D, 0xC0, 0xD0, 0x65, 0xC0, 0x77, 0x71, 0x02, 0x0D, 0xD8, 0x2D, 0x94, 0x21, 0xD0, 0x77, 0x71,
  0x01, 0x0C, 0xFF, 0x90, 0x77, 0x72, 0x07, 0x0E, 0xFF, 0x07, 0x77, 0x28, 0x11, 0x9E, 0xFD, 0x07,
  0x77, 0x58, 0x34, 0x9B, 0xDE, 0xE0, 0x77, 0x77, 0x4D, 0x07, 0x77, 0x75, 0xC0, 0x77, 0x77, 0x6B,
  0x07, 0x77, 0x77, 0xA0, 0x77, 0x77, 0x71, 0x90, 0x77, 0x77, 0x72, 0x07, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_loop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 45), Box(0, 0, 47, 47),
      ic_filled_48_av_loop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_lyrics 48x48, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_filled_48_av_lyrics_data[] PROGMEM = {
  0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x18, 0x11, 0xAD, 0xFF, 0xF9, 0x81, 0xDA, 0x17, 0xF9,
  0x01, 0x0E, 0xFF, 0xFD, 0x0E, 0x01, 0x6F, 0x90, 0x9F, 0xFF, 0xF0, 0xA6, 0xC4, 0x0D, 0xFF, 0xFF,
  0x0D, 0x6C, 0x4F, 0xFF, 0xFA, 0x6C, 0x4F, 0xFF, 0xF0, 0xA0, 0x26, 0xC4, 0xFF, 0xFE, 0x07, 0x71,
  0xC4, 0xFF, 0xFD, 0x07, 0x72, 0xC4, 0xF9, 0x77, 0xB0, 0xA5, 0x83, 0x6C, 0xEE, 0xBC, 0x4F, 0x97,
  0x7B, 0x02, 0x30, 0x10, 0xCF, 0xA4, 0xF9, 0x77, 0xA0, 0xA4, 0x0C, 0xFB, 0x4F, 0x97, 0x7A, 0x05,
  0x30, 0x6F, 0xC4, 0xFF, 0xFB, 0x02, 0x30, 0xCF, 0xC4, 0xFF, 0xFB, 0x40, 0xEF, 0xC4, 0xF9, 0x77,
  0xA4, 0x0E, 0xFB, 0x0E, 0x4F, 0x97, 0x7A, 0x02, 0x30, 0xCF, 0xB0, 0xC4, 0xF9, 0x77, 0xA0, 0x53,
  0x06, 0xFB, 0x06, 0x4F, 0x97, 0x7A, 0x0A, 0x40, 0xCF, 0x90, 0xC5, 0xFF, 0xFC, 0x01, 0x30, 0x10,
  0xCE, 0x0C, 0x01, 0x5F, 0xFF, 0xC0, 0xA5, 0x84, 0x6C, 0xEE, 0xC6, 0x7F, 0x97, 0x1F, 0xB0, 0x67,
  0x73, 0xF9, 0x71, 0xFC, 0x06, 0x77, 0x2F, 0x97, 0x1F, 0xD0, 0xA0, 0x27, 0x7F, 0x97, 0x1F, 0xF7,
  0x7F, 0xFF, 0xFA, 0x77, 0xFF, 0xFF, 0xA7, 0x7F, 0xFF, 0xFA, 0x77, 0xFF, 0xFF, 0xA7, 0x7F, 0xFF,
  0xF9, 0x0D, 0x77, 0xFF, 0xFF, 0x90, 0xA7, 0x7F, 0xFF, 0xF0, 0xE0, 0x17, 0x7F, 0xFF, 0xD8, 0x1D,
  0xA1, 0x77, 0x1F, 0x07, 0x80, 0xC0, 0x0E, 0x07, 0x80, 0xC1, 0x0D, 0x07, 0x80, 0xC2, 0x0C, 0x07,
  0x80, 0xC3, 0x0B, 0x07, 0x80, 0xC4, 0x0A, 0x07, 0x80, 0xC5, 0x09, 0x07, 0x80, 0xC6, 0x00, 0x78,
  0x0C, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_lyrics() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 47, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_lyrics_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_mic_none 48x48, 4-bit Alpha,  RLE, 244 bytes.
static const unsigned char ic_filled_48_av_mic_none_data[] PROGMEM = {
  0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x60, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x40, 0xCF, 0x90, 0xC7,
  0x73, 0x06, 0xB8, 0x2D, 0x77, 0xDB, 0x06, 0x77, 0x20, 0xCA, 0x0E, 0x01, 0x20, 0x10, 0xEA, 0x0C,
  0x77, 0x20, 0xEA, 0x0A, 0x40, 0xAA, 0x0E, 0x77, 0x2B, 0x09, 0x40, 0x9B, 0x77, 0x2B, 0x09, 0x40,
  0x9B, 0x77, 0x2B, 0x09, 0x40, 0x9B, 0x77, 0x2B, 0x09, 0x40, 0x9B, 0x77, 0x2B, 0x09, 0x40, 0x9B,
  0x77, 0x2B, 0x09, 0x40, 0x9B, 0x77, 0x2B, 0x09, 0x40, 0x9B, 0x77, 0x2B, 0x09, 0x40, 0x9B, 0x77,
  0x2B, 0x09, 0x40, 0x9B, 0x77, 0x2B, 0x09, 0x40, 0x9B, 0x77, 0x2B, 0x09, 0x40, 0x9B, 0x77, 0x2B,
  0x09, 0x40, 0x9B, 0x71, 0x0E, 0xA0, 0x74, 0x0E, 0xA0, 0xA4, 0x0A, 0xA0, 0xE4, 0x07, 0xA0, 0xE0,
  0xDA, 0x08, 0x40, 0xCA, 0x0E, 0x01, 0x20, 0x10, 0xEA, 0x0B, 0x40, 0x8A, 0x0D, 0x0B, 0xA0, 0xB4,
  0x06, 0xB8, 0x2D, 0x77, 0xDB, 0x06, 0x40, 0xBA, 0x0B, 0x07, 0xB0, 0x14, 0x0C, 0xF9, 0x0C, 0x40,
  0x1B, 0x07, 0x02, 0xB0, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x07, 0xB8, 0x12, 0x0A, 0xA0, 0xE0,
  0x15, 0x84, 0x6C, 0xEE, 0xC6, 0x50, 0x10, 0xEA, 0x0B, 0x20, 0x3B, 0x0C, 0x77, 0x20, 0xCB, 0x03,
  0x30, 0x8B, 0x0B, 0x01, 0x75, 0x01, 0x0B, 0xB0, 0x85, 0x0B, 0xB0, 0xD0, 0x47, 0x30, 0x40, 0xDB,
  0x0B, 0x70, 0xBC, 0x81, 0xC6, 0x14, 0x81, 0x16, 0xCC, 0x0B, 0x01, 0x71, 0x0A, 0xE8, 0x2E, 0xDD,
  0xEE, 0x0A, 0x74, 0x05, 0x0D, 0xFD, 0x0E, 0x05, 0x77, 0x05, 0x0C, 0xF9, 0x0C, 0x06, 0x77, 0x40,
  0x10, 0x4C, 0x04, 0x01, 0x77, 0x71, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73,
  0xC7, 0x77, 0x3C, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_mic_none() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_mic_none_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_mic_off 48x48, 4-bit Alpha,  RLE, 343 bytes.
static const unsigned char ic_filled_48_av_mic_off_data[] PROGMEM = {
  0x77, 0x18, 0x46, 0xCE, 0xEC, 0x67, 0x77, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x81, 0x1B, 0x27,
  0x20, 0xCF, 0x90, 0xC7, 0x68, 0x31, 0xDF, 0xD2, 0x70, 0x6F, 0xB0, 0x67, 0x50, 0xBB, 0x0D, 0x02,
  0x60, 0xCF, 0xB0, 0xC7, 0x50, 0x20, 0xDB, 0x0D, 0x02, 0x50, 0xEF, 0xB0, 0xE7, 0x60, 0x20, 0xDB,
  0x0D, 0x02, 0x40, 0xCF, 0xC7, 0x70, 0x20, 0xDB, 0x0D, 0x02, 0x30, 0x10, 0xCF, 0xB7, 0x71, 0x02,
  0x0D, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0xFA, 0x77, 0x20, 0x20, 0xDB, 0x0D, 0x02, 0x30, 0x10, 0xCF,
  0x97, 0x73, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0xF7, 0x74, 0x02, 0x0D, 0xB0, 0xD0, 0x23,
  0x01, 0x0C, 0xE7, 0x75, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0xD7, 0x76, 0x02, 0x0D, 0xB0,
  0xD0, 0x23, 0x01, 0x0C, 0xC7, 0x77, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0xB7, 0x77, 0x10,
  0x20, 0xDB, 0x0D, 0x02, 0x30, 0x10, 0xCA, 0x77, 0x72, 0x02, 0xC0, 0xD0, 0x23, 0x01, 0x0C, 0x97,
  0x77, 0x3D, 0x0D, 0x02, 0x30, 0x10, 0xC7, 0x72, 0x0E, 0xA0, 0x74, 0x0E, 0xD0, 0xD0, 0x23, 0x01,
  0x40, 0x7A, 0x0E, 0x71, 0x0D, 0xA0, 0x84, 0x0B, 0xE0, 0xD0, 0x27, 0x08, 0xA0, 0xD7, 0x10, 0xBA,
  0x0B, 0x40, 0x6F, 0x0D, 0x02, 0x60, 0xBA, 0x0B, 0x71, 0x07, 0xB0, 0x14, 0x0C, 0xF0, 0xD0, 0x24,
  0x01, 0xB0, 0x77, 0x10, 0x2B, 0x07, 0x40, 0x10, 0xCF, 0x0D, 0x02, 0x40, 0xCA, 0x02, 0x72, 0x0A,
  0xA0, 0xE0, 0x15, 0x06, 0x0C, 0x0F, 0xEB, 0x0D, 0x02, 0x38, 0x11, 0xCB, 0x73, 0x03, 0xB0, 0xC7,
  0x20, 0x20, 0xDB, 0x0D, 0x02, 0x30, 0x10, 0x27, 0x40, 0x8B, 0x0B, 0x01, 0x71, 0x02, 0x0D, 0xB0,
  0xD0, 0x27, 0x72, 0x0B, 0xB0, 0xD0, 0x47, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x77, 0x20, 0xBC, 0x81,
  0xC6, 0x14, 0x81, 0x17, 0xDC, 0x0D, 0x02, 0x77, 0x20, 0xAE, 0x81, 0xED, 0xDF, 0xA0, 0xD0, 0x27,
  0x72, 0x05, 0x0D, 0xFD, 0x00, 0xDB, 0x0D, 0x02, 0x77, 0x30, 0x50, 0xCF, 0x98, 0x3C, 0x50, 0x2D,
  0xB0, 0xD0, 0x27, 0x74, 0x01, 0x04, 0xC0, 0x40, 0x14, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x75, 0xC7,
  0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x74, 0xC7, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x77, 0x3C, 0x72, 0x02,
  0x0D, 0xB0, 0xD0, 0x27, 0x72, 0xC7, 0x30, 0x20, 0xDB, 0x0B, 0x77, 0x2C, 0x74, 0x83, 0x2D, 0xFD,
  0x17, 0x72, 0xC7, 0x58, 0x12, 0xB1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_mic_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_mic_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_mic 48x48, 4-bit Alpha,  RLE, 194 bytes.
static const unsigned char ic_filled_48_av_mic_data[] PROGMEM = {
  0x74, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x60, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x40, 0xCF, 0x90, 0xC7,
  0x73, 0x06, 0xFB, 0x06, 0x77, 0x20, 0xCF, 0xB0, 0xC7, 0x72, 0x0E, 0xFB, 0x0E, 0x77, 0x2F, 0xD7,
  0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72,
  0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x77, 0x2F, 0xD7, 0x72, 0xFD, 0x71, 0x0E, 0xA0, 0x74, 0x0E,
  0xFB, 0x0E, 0x40, 0x7A, 0x0E, 0x0D, 0xA0, 0x84, 0x0C, 0xFB, 0x0B, 0x40, 0x8A, 0x0D, 0x0B, 0xA0,
  0xB4, 0x06, 0xFB, 0x06, 0x40, 0xBA, 0x0B, 0x07, 0xB0, 0x14, 0x0C, 0xF9, 0x0C, 0x40, 0x1B, 0x07,
  0x02, 0xB0, 0x74, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x07, 0xB8, 0x12, 0x0A, 0xA0, 0xE0, 0x15, 0x84,
  0x6C, 0xEE, 0xC6, 0x50, 0x10, 0xEA, 0x0B, 0x20, 0x3B, 0x0C, 0x77, 0x20, 0xCB, 0x03, 0x30, 0x8B,
  0x0B, 0x01, 0x75, 0x01, 0x0B, 0xB0, 0x85, 0x0B, 0xB0, 0xD0, 0x47, 0x30, 0x40, 0xDB, 0x0B, 0x70,
  0xBC, 0x81, 0xC6, 0x14, 0x81, 0x16, 0xCC, 0x0B, 0x01, 0x71, 0x0A, 0xE8, 0x2E, 0xDD, 0xEE, 0x0A,
  0x74, 0x05, 0x0D, 0xFD, 0x0E, 0x05, 0x77, 0x05, 0x0C, 0xF9, 0x0C, 0x06, 0x77, 0x40, 0x10, 0x4C,
  0x04, 0x01, 0x77, 0x71, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77, 0x3C, 0x77, 0x73, 0xC7, 0x77,
  0x3C, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 4, 37, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_missed_video_call 48x48, 4-bit Alpha,  RLE, 152 bytes.
static const unsigned char ic_filled_48_av_missed_video_call_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x70, 0x7F, 0xFF, 0xF6, 0x07,
  0xFF, 0xFF, 0x95, 0x07, 0xFF, 0xFF, 0xA4, 0x07, 0xFF, 0xFF, 0xB3, 0x07, 0xF9, 0x80, 0x47, 0x08,
  0xFA, 0x0A, 0xD2, 0x07, 0xFA, 0x71, 0x01, 0xF9, 0x81, 0x50, 0x7C, 0x10, 0x7F, 0xB4, 0x80, 0x05,
  0x07, 0xF0, 0x52, 0x07, 0xC0, 0x7F, 0xC4, 0x05, 0xFB, 0x05, 0x20, 0x7F, 0xFB, 0x20, 0x42, 0x05,
  0xF9, 0x05, 0x20, 0x7F, 0xFC, 0x20, 0xC0, 0x72, 0x05, 0xE0, 0x52, 0x07, 0xFF, 0xD2, 0x81, 0xCF,
  0x72, 0x05, 0xC0, 0x52, 0x07, 0xFF, 0xE2, 0x0C, 0xA0, 0x72, 0x05, 0xA0, 0x52, 0x07, 0xFF, 0xF2,
  0x0C, 0xB0, 0x72, 0x00, 0x52, 0x07, 0xFF, 0xF9, 0x81, 0x99, 0xEC, 0x07, 0x40, 0x7F, 0xC0, 0x7F,
  0xFD, 0x07, 0x20, 0x7F, 0xD1, 0x07, 0xFF, 0xD0, 0x07, 0xFE, 0x20, 0x7F, 0xFF, 0xFD, 0x30, 0x7F,
  0xFF, 0xFC, 0x40, 0x7F, 0xFF, 0xFB, 0x50, 0x7F, 0xFF, 0xFA, 0x68, 0x17, 0xFD, 0xFF, 0xFD, 0x0D,
  0x78, 0x17, 0x4D, 0xFF, 0xFB, 0x0D, 0x04, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_missed_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 41, 35), Box(0, 0, 47, 47),
      ic_filled_48_av_missed_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_movie_edit 48x48, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_filled_48_av_movie_edit_data[] PROGMEM = {
  0x18, 0x21, 0xAD, 0x35, 0x0B, 0xB0, 0x35, 0x0B, 0xB0, 0x35, 0x0B, 0xD8, 0x1D, 0xA1, 0x30, 0x10,
  0xEA, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3F, 0x0E, 0x01, 0x20, 0x9C, 0x03, 0x50,
  0xBB, 0x03, 0x50, 0xBB, 0x03, 0x50, 0xBF, 0x0A, 0x20, 0xDC, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3B,
  0x0B, 0x50, 0x3F, 0x0D, 0x2E, 0x03, 0x50, 0xBB, 0x03, 0x50, 0xBB, 0x03, 0x50, 0xBF, 0x2E, 0x0B,
  0x50, 0x3B, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3F, 0x2F, 0x03, 0x50, 0xBB, 0x03, 0x50, 0xBB, 0x03,
  0x50, 0xBE, 0x2F, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3E, 0x28, 0x0C, 0x4F, 0x28,
  0x0C, 0x4F, 0x28, 0x0C, 0x4F, 0x28, 0x0C, 0x4F, 0x2C, 0x80, 0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x80,
  0xC2, 0x0C, 0x80, 0xC2, 0x0C, 0x77, 0x77, 0x58, 0x29, 0xEB, 0x11, 0xC7, 0x77, 0x74, 0x0B, 0xB0,
  0xC0, 0x1C, 0x77, 0x77, 0x40, 0xBC, 0x0B, 0xC7, 0x77, 0x72, 0x04, 0x20, 0xBB, 0x0E, 0xC7, 0x77,
  0x71, 0x81, 0xBF, 0x62, 0x0B, 0xA0, 0x9C, 0x77, 0x77, 0x0B, 0xB0, 0x62, 0x00, 0xB1, 0xC7, 0x77,
  0x60, 0xBD, 0x06, 0x4C, 0x77, 0x75, 0x0B, 0xF0, 0x43, 0xC7, 0x77, 0x40, 0xBF, 0x0B, 0x4C, 0x77,
  0x73, 0x0B, 0xF0, 0xB5, 0xC7, 0x77, 0x20, 0xBF, 0x0B, 0x6C, 0x77, 0x71, 0x0B, 0xF0, 0xB7, 0x0D,
  0xFF, 0xD5, 0x0B, 0xF0, 0xB7, 0x10, 0xAF, 0xFD, 0x40, 0xBF, 0x0B, 0x72, 0x01, 0x0E, 0xFF, 0xC4,
  0xF0, 0xB7, 0x48, 0x11, 0xAD, 0xFF, 0xA4, 0xE0, 0xB7, 0x77, 0x77, 0xD0, 0xB8, 0x0C, 0x00, 0xC0,
  0xB7, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_movie_edit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_movie_edit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_movie 48x48, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_filled_48_av_movie_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xA0, 0x35, 0x0B, 0xB0, 0x35, 0x0B, 0xB0, 0x35, 0x0B, 0xF0, 0x10, 0xEC, 0x0B,
  0x50, 0x3B, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3F, 0x09, 0xE0, 0x35, 0x0B, 0xB0, 0x35, 0x0B, 0xB0,
  0x35, 0x0B, 0xE0, 0xDE, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3F, 0xF0, 0x35, 0x0B,
  0xB0, 0x35, 0x0B, 0xB0, 0x35, 0x0B, 0xFE, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3F,
  0xF0, 0x35, 0x0B, 0xB0, 0x35, 0x0B, 0xB0, 0x35, 0x0B, 0xFE, 0x0B, 0x50, 0x3B, 0x0B, 0x50, 0x3B,
  0x0B, 0x50, 0x38, 0x09, 0xCC, 0x0F, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1,
  0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_movie() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_movie_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_music_video 48x48, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_filled_48_av_music_video_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x77, 0x4F,
  0xB7, 0x1F, 0x97, 0x74, 0xFB, 0x71, 0xF9, 0x77, 0x4F, 0xB7, 0x1F, 0x97, 0x74, 0xFB, 0x71, 0xF9,
  0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77, 0xF9,
  0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77, 0xF9, 0x77, 0x4C, 0x77, 0xF9,
  0x76, 0x83, 0x6C, 0xEE, 0xBC, 0x77, 0xF9, 0x74, 0x01, 0x0C, 0xFA, 0x77, 0xF9, 0x74, 0x0C, 0xFB,
  0x77, 0xF9, 0x73, 0x06, 0xFC, 0x77, 0xF9, 0x73, 0x0C, 0xFC, 0x77, 0xF9, 0x73, 0x0E, 0xFC, 0x77,
  0xF9, 0x73, 0x0E, 0xFB, 0x0E, 0x77, 0xF9, 0x73, 0x0C, 0xFB, 0x0C, 0x77, 0xF9, 0x73, 0x06, 0xFB,
  0x06, 0x77, 0xF9, 0x74, 0x0C, 0xF9, 0x0C, 0x77, 0x1F, 0x97, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x77,
  0x1F, 0x97, 0x68, 0x46, 0xCE, 0xEC, 0x67, 0x73, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0,
  0xD8, 0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A,
  0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_music_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_music_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_new_releases 48x48, 4-bit Alpha,  RLE, 284 bytes.
static const unsigned char ic_filled_48_av_new_releases_data[] PROGMEM = {
  0x77, 0x81, 0x1B, 0x57, 0x38, 0x15, 0xB1, 0x77, 0x77, 0x09, 0xA8, 0x1E, 0x71, 0x48, 0x11, 0x7E,
  0xA0, 0x97, 0x77, 0x60, 0x3E, 0x82, 0xA3, 0x3A, 0xE0, 0x37, 0x77, 0x50, 0xCF, 0xFA, 0x0C, 0x77,
  0x74, 0x06, 0xFF, 0xC0, 0x67, 0x77, 0x20, 0x10, 0xEF, 0xFC, 0x0E, 0x01, 0x77, 0x68, 0x12, 0x5B,
  0xFF, 0xE8, 0x1B, 0x51, 0x77, 0x82, 0x37, 0xAE, 0xFF, 0xFD, 0x82, 0xDA, 0x63, 0x72, 0x0B, 0xFF,
  0xFF, 0xE0, 0xB7, 0x10, 0xAF, 0xFF, 0xFE, 0x0A, 0x71, 0x08, 0xFF, 0xFF, 0xE0, 0x87, 0x10, 0x7F,
  0xF9, 0x4F, 0xF9, 0x07, 0x71, 0x06, 0xFF, 0x94, 0xFF, 0x90, 0x67, 0x10, 0x4F, 0xF9, 0x4F, 0xF9,
  0x04, 0x71, 0x03, 0xFF, 0x94, 0xFF, 0x90, 0x37, 0x10, 0x4F, 0xF9, 0x4F, 0xF9, 0x04, 0x70, 0x20,
  0xEF, 0xF9, 0x4F, 0xF9, 0x0E, 0x02, 0x50, 0x10, 0xDF, 0xFA, 0x4F, 0xFA, 0x0D, 0x01, 0x40, 0xCF,
  0xFB, 0x4F, 0xFB, 0x0B, 0x30, 0xAF, 0xFC, 0x4F, 0xFC, 0x81, 0xA0, 0x8F, 0xFD, 0x4F, 0xFD, 0x00,
  0x8F, 0xFD, 0x4F, 0xFD, 0x81, 0x80, 0xAF, 0xFC, 0x4F, 0xFC, 0x0A, 0x30, 0xB8, 0x0C, 0x2F, 0x0B,
  0x40, 0x10, 0xD8, 0x0C, 0x0F, 0x0D, 0x01, 0x50, 0x20, 0xEF, 0xFF, 0xFE, 0x0E, 0x02, 0x70, 0x4F,
  0xFF, 0xFE, 0x04, 0x71, 0x03, 0xFF, 0x94, 0xFF, 0x90, 0x37, 0x10, 0x4F, 0xF9, 0x4F, 0xF9, 0x04,
  0x71, 0x06, 0xFF, 0x94, 0xFF, 0x90, 0x67, 0x10, 0x7F, 0xF9, 0x4F, 0xF9, 0x07, 0x71, 0x08, 0xFF,
  0xFF, 0xE0, 0x87, 0x10, 0xAF, 0xFF, 0xFE, 0x0A, 0x71, 0x0B, 0xFF, 0xFF, 0xE0, 0xB7, 0x28, 0x23,
  0x7A, 0xEF, 0xFF, 0xD8, 0x2D, 0xA6, 0x37, 0x78, 0x12, 0x5B, 0xFF, 0xE8, 0x1B, 0x51, 0x77, 0x60,
  0x10, 0xEF, 0xFC, 0x0E, 0x01, 0x77, 0x72, 0x06, 0xFF, 0xC0, 0x67, 0x77, 0x40, 0xCF, 0xFA, 0x0C,
  0x77, 0x75, 0x03, 0xE8, 0x2A, 0x33, 0xAE, 0x03, 0x77, 0x76, 0x0A, 0xA8, 0x1E, 0x71, 0x48, 0x11,
  0x7E, 0xA0, 0x97, 0x77, 0x78, 0x11, 0xB5, 0x73, 0x81, 0x5B, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_new_releases() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 45, 44), Box(0, 0, 47, 47),
      ic_filled_48_av_new_releases_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_note 48x48, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_filled_48_av_note_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFB, 0x07, 0x74, 0x01, 0x0E, 0xFF, 0xFE, 0x07, 0x73, 0x0A, 0xFF, 0xFF,
  0x90, 0x77, 0x20, 0xDF, 0xFF, 0xC0, 0x7C, 0x07, 0x71, 0xFF, 0xFD, 0x10, 0x7C, 0x07, 0x7F, 0xFF,
  0xD2, 0x07, 0xC0, 0x76, 0xFF, 0xFD, 0x30, 0x7C, 0x07, 0x5F, 0xFF, 0xD4, 0x07, 0xC0, 0x74, 0xFF,
  0xFD, 0x50, 0x7C, 0x07, 0x3F, 0xFF, 0xD6, 0x07, 0xC0, 0x72, 0xFF, 0xFD, 0x70, 0x7C, 0x07, 0x1F,
  0xFF, 0xD7, 0x10, 0x7C, 0x07, 0xFF, 0xFD, 0x72, 0x07, 0xFF, 0xFF, 0xA7, 0x30, 0x78, 0x09, 0x8D,
  0x7F, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1,
  0x01, 0xAE, 0xFF, 0xFF, 0xC8, 0x1D, 0x91, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_note() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_note_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_not_interested 48x48, 4-bit Alpha,  RLE, 354 bytes.
static const unsigned char ic_filled_48_av_not_interested_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xE8, 0x3E, 0xA6, 0x31, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x76, 0x0A, 0xD0, 0xD0, 0x67, 0x50,
  0x60, 0xDD, 0x0A, 0x74, 0x0A, 0xD0, 0x87, 0x72, 0x07, 0xD0, 0xA7, 0x20, 0x9D, 0x07, 0x77, 0x40,
  0x30, 0xDC, 0x09, 0x70, 0x5F, 0x05, 0x77, 0x40, 0x10, 0xCC, 0x05, 0x50, 0x10, 0xEF, 0x90, 0x57,
  0x74, 0x01, 0x0D, 0xB0, 0xE0, 0x14, 0x09, 0xC0, 0x7D, 0x05, 0x77, 0x40, 0x3C, 0x09, 0x30, 0x1C,
  0x81, 0x80, 0x5D, 0x05, 0x77, 0x40, 0x7C, 0x01, 0x20, 0x8B, 0x0D, 0x30, 0x5D, 0x05, 0x77, 0x40,
  0xDB, 0x08, 0x20, 0xDB, 0x06, 0x40, 0x5D, 0x05, 0x77, 0x30, 0x6B, 0x81, 0xD0, 0x3B, 0x0E, 0x60,
  0x5D, 0x05, 0x77, 0x3C, 0x03, 0x07, 0xB0, 0xA7, 0x05, 0xD0, 0x57, 0x72, 0x0B, 0xB0, 0x70, 0xAB,
  0x06, 0x71, 0x05, 0xD0, 0x57, 0x71, 0x06, 0xB0, 0xA0, 0xCB, 0x03, 0x72, 0x05, 0xD0, 0x57, 0x70,
  0x3B, 0x0C, 0x0E, 0xB0, 0x17, 0x30, 0x5D, 0x05, 0x76, 0x02, 0xB0, 0xEC, 0x75, 0x05, 0xD0, 0x57,
  0x6F, 0x97, 0x60, 0x5D, 0x05, 0x75, 0xC0, 0xEB, 0x02, 0x76, 0x05, 0xD0, 0x57, 0x30, 0x1B, 0x0E,
  0x0C, 0xB0, 0x37, 0x70, 0x5D, 0x05, 0x72, 0x03, 0xB0, 0xC0, 0xAB, 0x06, 0x77, 0x10, 0x5D, 0x05,
  0x71, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x77, 0x20, 0x5D, 0x05, 0x70, 0xAB, 0x07, 0x03, 0xC7, 0x73,
  0x05, 0xD0, 0x56, 0x0E, 0xB8, 0x13, 0x0D, 0xB0, 0x67, 0x73, 0x05, 0xD0, 0x54, 0x06, 0xB0, 0xD2,
  0x08, 0xB0, 0xD7, 0x74, 0x05, 0xD0, 0x53, 0x0D, 0xB0, 0x82, 0x01, 0xC0, 0x77, 0x74, 0x05, 0xD8,
  0x15, 0x08, 0xC0, 0x13, 0x09, 0xC0, 0x37, 0x74, 0x05, 0xD0, 0x7C, 0x09, 0x40, 0x10, 0xEB, 0x0D,
  0x01, 0x77, 0x40, 0x5F, 0x90, 0xE0, 0x15, 0x05, 0xC0, 0xC0, 0x17, 0x74, 0x05, 0xF0, 0x57, 0x09,
  0xC0, 0xD0, 0x37, 0x74, 0x07, 0xD0, 0x97, 0x20, 0xAD, 0x07, 0x77, 0x20, 0x8D, 0x0A, 0x74, 0x0A,
  0xD0, 0xD0, 0x67, 0x50, 0x60, 0xDD, 0x0A, 0x76, 0x09, 0xF8, 0x2B, 0x63, 0x22, 0x83, 0x13, 0x6A,
  0xEE, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01,
  0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA,
  0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_not_interested() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_not_interested_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_pause_circle_filled 48x48, 4-bit Alpha,  RLE, 234 bytes.
static const unsigned char ic_filled_48_av_pause_circle_filled_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0xFD, 0x4C, 0x4F, 0xD0, 0x82,
  0x0D, 0xFD, 0x4C, 0x4F, 0xD8, 0x1D, 0x03, 0xFE, 0x4C, 0x4F, 0xE0, 0x30, 0x7F, 0xE4, 0xC4, 0xFE,
  0x07, 0x0A, 0xFE, 0x4C, 0x4F, 0xE0, 0xA0, 0xCF, 0xE4, 0xC4, 0xFE, 0x0C, 0x0E, 0xFE, 0x4C, 0x4F,
  0xE0, 0xEF, 0xF4, 0xC4, 0xFF, 0xFF, 0x4C, 0x4F, 0xF0, 0xEF, 0xE4, 0xC4, 0xFE, 0x0E, 0x0C, 0xFE,
  0x4C, 0x4F, 0xE0, 0xC0, 0xAF, 0xE4, 0xC4, 0xFE, 0x0A, 0x07, 0xFE, 0x4C, 0x4F, 0xE0, 0x70, 0x3F,
  0xE4, 0xC4, 0xFE, 0x81, 0x30, 0xDF, 0xD4, 0xC4, 0xFD, 0x0D, 0x20, 0x8F, 0xD4, 0xC4, 0xFD, 0x08,
  0x20, 0x18, 0x0C, 0x0F, 0x01, 0x30, 0x9F, 0xFF, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E,
  0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A,
  0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E,
  0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17,
  0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_pause_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_pause_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_pause_circle_outline 48x48, 4-bit Alpha,  RLE, 333 bytes.
static const unsigned char ic_filled_48_av_pause_circle_outline_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x93,
  0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x20, 0x8B, 0x0E, 0x71, 0xC4, 0xC7, 0x10, 0xEB, 0x08,
  0x20, 0xDB, 0x06, 0x71, 0xC4, 0xC7, 0x10, 0x6B, 0x81, 0xD0, 0x3C, 0x72, 0xC4, 0xC7, 0x2C, 0x03,
  0x07, 0xB0, 0xB7, 0x2C, 0x4C, 0x72, 0x0B, 0xB0, 0x70, 0xAB, 0x06, 0x72, 0xC4, 0xC7, 0x20, 0x6B,
  0x0A, 0x0C, 0xB0, 0x37, 0x2C, 0x4C, 0x72, 0x03, 0xB0, 0xC0, 0xEB, 0x02, 0x72, 0xC4, 0xC7, 0x20,
  0x2B, 0x0E, 0xC7, 0x3C, 0x4C, 0x73, 0xF9, 0x73, 0xC4, 0xC7, 0x3C, 0x0E, 0xB0, 0x27, 0x2C, 0x4C,
  0x72, 0x02, 0xB0, 0xE0, 0xCB, 0x03, 0x72, 0xC4, 0xC7, 0x20, 0x3B, 0x0C, 0x0A, 0xB0, 0x67, 0x2C,
  0x4C, 0x72, 0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x72, 0xC4, 0xC7, 0x20, 0xBB, 0x07, 0x03, 0xC7, 0x2C,
  0x4C, 0x72, 0xC8, 0x13, 0x0D, 0xB0, 0x67, 0x1C, 0x4C, 0x71, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xE7,
  0x1C, 0x4C, 0x71, 0x0E, 0xB0, 0x82, 0x01, 0xC0, 0x77, 0x77, 0x50, 0x7C, 0x01, 0x30, 0x9C, 0x03,
  0x77, 0x73, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01,
  0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0E, 0x03, 0x77, 0x40, 0x30,
  0xEC, 0x09, 0x72, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x60, 0x9F, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09, 0x77, 0x10, 0x50,
  0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD,
  0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_pause_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_pause_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_pause_circle 48x48, 4-bit Alpha,  RLE, 234 bytes.
static const unsigned char ic_filled_48_av_pause_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0xFD, 0x4C, 0x4F, 0xD0, 0x82,
  0x0D, 0xFD, 0x4C, 0x4F, 0xD8, 0x1D, 0x03, 0xFE, 0x4C, 0x4F, 0xE0, 0x30, 0x7F, 0xE4, 0xC4, 0xFE,
  0x07, 0x0A, 0xFE, 0x4C, 0x4F, 0xE0, 0xA0, 0xCF, 0xE4, 0xC4, 0xFE, 0x0C, 0x0E, 0xFE, 0x4C, 0x4F,
  0xE0, 0xEF, 0xF4, 0xC4, 0xFF, 0xFF, 0x4C, 0x4F, 0xF0, 0xEF, 0xE4, 0xC4, 0xFE, 0x0E, 0x0C, 0xFE,
  0x4C, 0x4F, 0xE0, 0xC0, 0xAF, 0xE4, 0xC4, 0xFE, 0x0A, 0x07, 0xFE, 0x4C, 0x4F, 0xE0, 0x70, 0x3F,
  0xE4, 0xC4, 0xFE, 0x81, 0x30, 0xDF, 0xD4, 0xC4, 0xFD, 0x0D, 0x20, 0x8F, 0xD4, 0xC4, 0xFD, 0x08,
  0x20, 0x18, 0x0C, 0x0F, 0x01, 0x30, 0x9F, 0xFF, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E,
  0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A,
  0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E,
  0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17,
  0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_pause_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_pause_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_pause 48x48, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_filled_48_av_pause_data[] PROGMEM = {
  0xF9, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA,
  0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71,
  0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF,
  0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0xFA, 0x71, 0xFF, 0xA7,
  0x1F, 0xFA, 0x71, 0xFF, 0xA7, 0x1F, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_pause() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 10, 35, 37), Box(0, 0, 47, 47),
      ic_filled_48_av_pause_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_play_arrow 48x48, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_filled_48_av_play_arrow_data[] PROGMEM = {
  0x0A, 0x01, 0x77, 0x69, 0x0E, 0x06, 0x77, 0x5B, 0x0B, 0x02, 0x77, 0x3D, 0x07, 0x77, 0x2E, 0x0D,
  0x03, 0x77, 0xF9, 0x09, 0x76, 0xFA, 0x0D, 0x04, 0x74, 0xFC, 0x0A, 0x01, 0x72, 0xFD, 0x0E, 0x06,
  0x71, 0xFF, 0x0B, 0x02, 0x6F, 0xFA, 0x07, 0x5F, 0xFB, 0x0D, 0x03, 0x3F, 0xFD, 0x09, 0x2F, 0xFE,
  0x0D, 0x04, 0xFF, 0xE0, 0xD0, 0x4F, 0xFD, 0x09, 0x2F, 0xFB, 0x0D, 0x03, 0x3F, 0xFA, 0x07, 0x5F,
  0xF0, 0xB0, 0x26, 0xFD, 0x0E, 0x06, 0x71, 0xFC, 0x0A, 0x01, 0x72, 0xFA, 0x0D, 0x04, 0x74, 0xF9,
  0x09, 0x76, 0xE0, 0xD0, 0x37, 0x7D, 0x07, 0x77, 0x2B, 0x0B, 0x02, 0x77, 0x39, 0x0E, 0x06, 0x77,
  0x50, 0xA0, 0x17, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_play_arrow() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(16, 10, 37, 37), Box(0, 0, 47, 47),
      ic_filled_48_av_play_arrow_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_play_circle_filled 48x48, 4-bit Alpha,  RLE, 262 bytes.
static const unsigned char ic_filled_48_av_play_circle_filled_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0xFF, 0x05, 0x0E, 0xFF, 0xE0, 0x12, 0x08, 0xFF, 0x10, 0x20,
  0xCF, 0xFD, 0x08, 0x20, 0xDF, 0xF3, 0x09, 0xFF, 0xC8, 0x1D, 0x03, 0xFF, 0x94, 0x05, 0x0E, 0xFF,
  0xB0, 0x30, 0x7F, 0xF9, 0x50, 0x20, 0xCF, 0xFA, 0x07, 0x0A, 0xFF, 0x97, 0x09, 0xFF, 0x90, 0xA0,
  0xCF, 0xF9, 0x71, 0x05, 0x0E, 0xFE, 0x0C, 0x0E, 0xFF, 0x97, 0x20, 0x20, 0xCF, 0xD0, 0xEF, 0xFA,
  0x74, 0x09, 0xFF, 0xFF, 0x74, 0x09, 0xFD, 0x0E, 0xFF, 0x97, 0x20, 0x20, 0xCF, 0xD0, 0xE0, 0xCF,
  0xF9, 0x71, 0x05, 0x0E, 0xFE, 0x0C, 0x0A, 0xFF, 0x97, 0x09, 0xFF, 0x90, 0xA0, 0x7F, 0xF9, 0x50,
  0x20, 0xCF, 0xFA, 0x07, 0x03, 0xFF, 0x94, 0x05, 0x0E, 0xFF, 0xB8, 0x13, 0x0D, 0xFF, 0x30, 0x9F,
  0xFC, 0x0D, 0x20, 0x8F, 0xF1, 0x02, 0x0C, 0xFF, 0xD0, 0x82, 0x01, 0xFF, 0x05, 0x0E, 0xFF, 0xE0,
  0x13, 0x09, 0xFF, 0xFF, 0xE0, 0x94, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x15, 0x05, 0xFF, 0xFF,
  0xC0, 0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0,
  0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09,
  0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC,
  0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_play_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_play_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_play_circle_outline 48x48, 4-bit Alpha,  RLE, 352 bytes.
static const unsigned char ic_filled_48_av_play_circle_outline_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xF8, 0x2B, 0x63, 0x22, 0x82, 0x23, 0x6B, 0xF0, 0x97, 0x60, 0xAD, 0x0E, 0x06, 0x75, 0x06,
  0x0E, 0xD0, 0xA7, 0x40, 0xAD, 0x07, 0x77, 0x20, 0x7D, 0x0A, 0x72, 0x09, 0xC0, 0xE0, 0x37, 0x74,
  0x03, 0x0E, 0xC0, 0x97, 0x05, 0xC0, 0xC0, 0x17, 0x76, 0x01, 0x0C, 0xC0, 0x55, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x77, 0x10, 0x10, 0xEB, 0x0E, 0x01, 0x40, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x93,
  0x01, 0xC0, 0x77, 0x20, 0x97, 0x72, 0x07, 0xC0, 0x12, 0x08, 0xB0, 0xE7, 0x39, 0x0C, 0x02, 0x77,
  0x10, 0xEB, 0x08, 0x20, 0xDB, 0x06, 0x73, 0xA0, 0xE0, 0x57, 0x70, 0x6B, 0x81, 0xD0, 0x3C, 0x74,
  0xC0, 0x97, 0x7C, 0x03, 0x07, 0xB0, 0xB7, 0x4D, 0x0C, 0x02, 0x75, 0x0B, 0xB0, 0x70, 0xAB, 0x06,
  0x74, 0xE0, 0xE0, 0x57, 0x40, 0x6B, 0x0A, 0x0C, 0xB0, 0x37, 0x4F, 0x90, 0x97, 0x30, 0x3B, 0x0C,
  0x0E, 0xB0, 0x27, 0x4F, 0xA0, 0xC0, 0x27, 0x10, 0x2B, 0x0E, 0xC7, 0x5F, 0xB0, 0xE0, 0x57, 0x1F,
  0x97, 0x5F, 0xB0, 0xE0, 0x57, 0x1C, 0x0E, 0xB0, 0x27, 0x4F, 0xA0, 0xC0, 0x27, 0x10, 0x2B, 0x0E,
  0x0C, 0xB0, 0x37, 0x4F, 0x90, 0x97, 0x30, 0x3B, 0x0C, 0x0A, 0xB0, 0x67, 0x4E, 0x0E, 0x05, 0x74,
  0x06, 0xB0, 0xA0, 0x7B, 0x0B, 0x74, 0xD0, 0xC0, 0x27, 0x50, 0xBB, 0x07, 0x03, 0xC7, 0x4C, 0x09,
  0x77, 0xC8, 0x13, 0x0D, 0xB0, 0x67, 0x3A, 0x0E, 0x05, 0x77, 0x06, 0xB0, 0xD2, 0x08, 0xB0, 0xE7,
  0x39, 0x0C, 0x02, 0x77, 0x10, 0xEB, 0x08, 0x20, 0x1C, 0x07, 0x72, 0x09, 0x77, 0x20, 0x7C, 0x01,
  0x30, 0x9C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x94, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x10, 0x10,
  0xEB, 0x0E, 0x01, 0x50, 0x5C, 0x0C, 0x01, 0x77, 0x60, 0x10, 0xCC, 0x05, 0x70, 0x9C, 0x0E, 0x03,
  0x77, 0x40, 0x30, 0xEC, 0x09, 0x72, 0x0A, 0xD0, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x40, 0xAD, 0x0E,
  0x06, 0x75, 0x06, 0x0E, 0xD0, 0xA7, 0x60, 0x9F, 0x82, 0xB6, 0x32, 0x28, 0x22, 0x36, 0xBF, 0x09,
  0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68,
  0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_play_circle_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_play_circle_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_play_circle 48x48, 4-bit Alpha,  RLE, 261 bytes.
static const unsigned char ic_filled_48_av_play_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0xFE, 0x05, 0x0D, 0xFF, 0xF0, 0x12, 0x08, 0xFE, 0x10, 0x10,
  0x9F, 0xFE, 0x08, 0x20, 0xDF, 0xE3, 0x03, 0x0D, 0xFF, 0xC8, 0x1D, 0x03, 0xFF, 0x50, 0x8F, 0xFC,
  0x03, 0x07, 0xFF, 0x60, 0x30, 0xCF, 0xFA, 0x07, 0x0A, 0xFF, 0x71, 0x07, 0x0E, 0xFF, 0x0A, 0x0C,
  0xFF, 0x72, 0x02, 0x0B, 0xFE, 0x0C, 0x0E, 0xFF, 0x74, 0x06, 0x0E, 0xFC, 0x0E, 0xFF, 0x97, 0x50,
  0x10, 0xAF, 0xFF, 0xD7, 0x50, 0x10, 0xAF, 0xC0, 0xEF, 0xF7, 0x40, 0x60, 0xEF, 0xC0, 0xE0, 0xCF,
  0xF7, 0x20, 0x20, 0xBF, 0xE0, 0xC0, 0xAF, 0xF7, 0x10, 0x70, 0xEF, 0xF0, 0xA0, 0x7F, 0xF6, 0x03,
  0x0C, 0xFF, 0xA0, 0x70, 0x3F, 0xF5, 0x08, 0xFF, 0xC8, 0x13, 0x0D, 0xFE, 0x30, 0x30, 0xDF, 0xFC,
  0x0D, 0x20, 0x8F, 0xE1, 0x01, 0x09, 0xFF, 0xE0, 0x82, 0x01, 0xFE, 0x05, 0x0D, 0xFF, 0xF0, 0x13,
  0x09, 0xFF, 0xFF, 0xE0, 0x94, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x15, 0x05, 0xFF, 0xFF, 0xC0,
  0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0, 0xA7,
  0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF,
  0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA,
  0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_play_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_play_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_play_disabled 48x48, 4-bit Alpha,  RLE, 271 bytes.
static const unsigned char ic_filled_48_av_play_disabled_data[] PROGMEM = {
  0x18, 0x11, 0xB2, 0x77, 0x77, 0x28, 0x31, 0xDF, 0xD2, 0x77, 0x77, 0x10, 0xBB, 0x0D, 0x02, 0x40,
  0x70, 0x17, 0x77, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x38, 0x11, 0xB6, 0x77, 0x71, 0x02, 0x0D, 0xB0,
  0xD0, 0x23, 0x82, 0x1C, 0xB2, 0x77, 0x70, 0x20, 0xDB, 0x0D, 0x02, 0x38, 0x21, 0xCF, 0x77, 0x77,
  0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x83, 0x1C, 0xFD, 0x37, 0x76, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01,
  0x0C, 0xA0, 0x97, 0x76, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0xA0, 0xD0, 0x47, 0x75, 0x02,
  0x0D, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0xB0, 0xA0, 0x17, 0x74, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01,
  0x0C, 0xB0, 0xE0, 0x67, 0x74, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0xC0, 0xB0, 0x27, 0x73,
  0x02, 0xC0, 0xD0, 0x23, 0x01, 0x0C, 0xD0, 0x77, 0x73, 0xD0, 0xD0, 0x23, 0x01, 0x0C, 0xD0, 0xD0,
  0x37, 0x71, 0xE0, 0xD0, 0x23, 0x01, 0x0C, 0xE0, 0x97, 0x7F, 0x0D, 0x02, 0x30, 0x10, 0xCE, 0x0D,
  0x04, 0x75, 0xF9, 0x0D, 0x02, 0x30, 0x10, 0xCD, 0x0D, 0x04, 0x75, 0xFA, 0x0D, 0x02, 0x30, 0x10,
  0xCB, 0x09, 0x77, 0xFB, 0x0D, 0x02, 0x38, 0x21, 0xCD, 0x37, 0x71, 0xFC, 0x0D, 0x02, 0x77, 0x7F,
  0xD0, 0xD0, 0x27, 0x76, 0xFE, 0x0D, 0x02, 0x77, 0x5F, 0xF0, 0xD0, 0x27, 0x74, 0xFA, 0x81, 0xD6,
  0xDB, 0x0D, 0x02, 0x77, 0x3F, 0x90, 0x82, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x72, 0xE0, 0xC0, 0x34,
  0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x71, 0xD0, 0x77, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x7B, 0x0B, 0x02,
  0x72, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x69, 0x0E, 0x06, 0x75, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x50,
  0xA0, 0x17, 0x70, 0x20, 0xDB, 0x0D, 0x02, 0x77, 0x77, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x77, 0x70,
  0x20, 0xDB, 0x0B, 0x77, 0x77, 0x18, 0x32, 0xDF, 0xD1, 0x77, 0x77, 0x28, 0x12, 0xB1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_play_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 39, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_play_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_playlist_add_check_circle 48x48, 4-bit Alpha,  RLE, 270 bytes.
static const unsigned char ic_filled_48_av_playlist_add_check_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xF7, 0x7F, 0xE0, 0x93, 0x01, 0xF9, 0x77, 0xFF, 0x01, 0x20, 0x8F, 0x97, 0x7F, 0xF0, 0x82,
  0x0D, 0xF9, 0x77, 0xFF, 0x81, 0xD0, 0x38, 0x0C, 0x2F, 0x03, 0x07, 0x80, 0xC2, 0xF0, 0x70, 0xAF,
  0xA7, 0x7F, 0xF9, 0x0A, 0x0C, 0xFA, 0x77, 0xFF, 0x90, 0xC0, 0xEF, 0xA7, 0x7F, 0xF9, 0x0E, 0xFB,
  0x77, 0x80, 0xD2, 0xF0, 0xA0, 0x5F, 0x90, 0xEF, 0xFF, 0xF0, 0xA2, 0x05, 0xE0, 0xE0, 0xCF, 0xA6,
  0xFD, 0x0A, 0x40, 0x5D, 0x0C, 0x0A, 0xFA, 0x6F, 0xC0, 0xA5, 0x0A, 0xD0, 0xA0, 0x7F, 0xA6, 0xC0,
  0xD0, 0x8C, 0x09, 0x50, 0xAE, 0x07, 0x03, 0xFA, 0x6B, 0x82, 0xD1, 0x07, 0xA0, 0x95, 0x0A, 0xF8,
  0x13, 0x0D, 0xFF, 0xA0, 0xD0, 0x13, 0x07, 0x09, 0x50, 0xAF, 0x0D, 0x20, 0x8F, 0xFA, 0x0C, 0x01,
  0x72, 0x0A, 0xF9, 0x08, 0x20, 0x1F, 0xFB, 0x0C, 0x01, 0x70, 0xAF, 0xA0, 0x13, 0x09, 0xFF, 0xB0,
  0xC0, 0x15, 0x0A, 0xFA, 0x09, 0x40, 0x10, 0xEF, 0xFB, 0x0C, 0x01, 0x30, 0xAF, 0xA0, 0xE0, 0x15,
  0x05, 0xFF, 0xC8, 0x2C, 0x10, 0xAF, 0xB0, 0x57, 0x09, 0xFF, 0xC0, 0xC0, 0xAF, 0xB0, 0x97, 0x20,
  0xAF, 0xFF, 0xF0, 0xA7, 0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05,
  0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF,
  0xD8, 0x1D, 0x81, 0x77, 0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_playlist_add_check_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_playlist_add_check_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_playlist_add_check 48x48, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_filled_48_av_playlist_add_check_data[] PROGMEM = {
  0xFF, 0xF9, 0x77, 0x2F, 0xFF, 0x97, 0x72, 0xFF, 0xF9, 0x77, 0x2F, 0xFF, 0x98, 0x0A, 0xC4, 0x0F,
  0xFF, 0x97, 0x72, 0xFF, 0xF9, 0x77, 0x2F, 0xFF, 0x97, 0x72, 0xFF, 0xF9, 0x80, 0xD6, 0x00, 0x70,
  0xB7, 0x77, 0x77, 0x07, 0xA0, 0xB7, 0x77, 0x75, 0x07, 0xC0, 0xB7, 0x77, 0x73, 0x07, 0xC0, 0xE0,
  0x3F, 0xF7, 0x01, 0x0A, 0x70, 0x7C, 0x0E, 0x03, 0x1F, 0xF6, 0x82, 0x1D, 0xFC, 0x50, 0x7C, 0x0E,
  0x03, 0x2F, 0xF5, 0x01, 0x0D, 0xB0, 0xC3, 0x07, 0xC0, 0xE0, 0x33, 0xFF, 0x60, 0xBC, 0x81, 0xC0,
  0x7C, 0x0E, 0x03, 0x77, 0x74, 0x0B, 0xC0, 0xDC, 0x0E, 0x03, 0x77, 0x76, 0x0B, 0xF0, 0xE0, 0x37,
  0x77, 0x71, 0x0B, 0xD0, 0xE0, 0x37, 0x77, 0x73, 0x0B, 0xB0, 0xE0, 0x37, 0x77, 0x75, 0x82, 0xBF,
  0xE3, 0x77, 0x77, 0x70, 0xB0, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_playlist_add_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 43, 37), Box(0, 0, 47, 47),
      ic_filled_48_av_playlist_add_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_playlist_add_circle 48x48, 4-bit Alpha,  RLE, 234 bytes.
static const unsigned char ic_filled_48_av_playlist_add_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xF7, 0x7F, 0xE0, 0x93, 0x01, 0xF9, 0x77, 0xFF, 0x01, 0x20, 0x8F, 0x97, 0x7F, 0xF0, 0x82,
  0x0D, 0xF9, 0x77, 0xFF, 0x81, 0xD0, 0x38, 0x0C, 0x2F, 0x03, 0x07, 0x80, 0xC2, 0xF0, 0x70, 0xAF,
  0xA7, 0x7F, 0xF9, 0x0A, 0x0C, 0xFA, 0x77, 0xFF, 0x90, 0xC0, 0xEF, 0xA7, 0x7A, 0x4F, 0xA0, 0xEF,
  0xB7, 0x7A, 0x48, 0x0C, 0x0F, 0x4F, 0xB0, 0xEF, 0xFF, 0xC4, 0xFA, 0x0E, 0x0C, 0xFA, 0x6E, 0x75,
  0xD0, 0xC0, 0xAF, 0xA6, 0xE7, 0x5D, 0x0A, 0x07, 0xFA, 0x6E, 0x75, 0xD0, 0x70, 0x3F, 0xA6, 0xE7,
  0x5D, 0x81, 0x30, 0xDF, 0xFF, 0xB4, 0xF9, 0x0D, 0x20, 0x8F, 0xFF, 0xB4, 0xF9, 0x08, 0x20, 0x1F,
  0xFF, 0xB4, 0xF9, 0x01, 0x30, 0x9F, 0xFF, 0xA4, 0xF0, 0x94, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0,
  0x15, 0x05, 0xFF, 0xFF, 0xC0, 0x57, 0x09, 0xFF, 0xFF, 0xA0, 0x97, 0x20, 0xAF, 0xFF, 0xF0, 0xA7,
  0x40, 0xAF, 0xFF, 0xD0, 0xA7, 0x60, 0x9F, 0xFF, 0xB0, 0x97, 0x71, 0x05, 0x0E, 0xFF, 0xE0, 0xE0,
  0x57, 0x73, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x76, 0x81, 0x18, 0xDF, 0xD8, 0x1D, 0x81, 0x77,
  0x74, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_playlist_add_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_playlist_add_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_playlist_add 48x48, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_filled_48_av_playlist_add_data[] PROGMEM = {
  0xFF, 0xF9, 0x77, 0x2F, 0xFF, 0x97, 0x72, 0xFF, 0xF9, 0x77, 0x2F, 0xFF, 0x98, 0x0A, 0xC4, 0x0F,
  0xFF, 0x94, 0xC7, 0x1F, 0xFF, 0x94, 0xC7, 0x1F, 0xFF, 0x94, 0xC7, 0x1F, 0xFF, 0x94, 0xC7, 0x77,
  0x76, 0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76, 0xC7, 0x77, 0x76, 0xC7, 0x1F, 0xF4, 0xFF, 0xFF, 0xE4,
  0xFF, 0xFF, 0xE4, 0xFF, 0xFF, 0xE4, 0xFF, 0xE7, 0x77, 0x5C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C,
  0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_playlist_add() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_playlist_add_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_playlist_play 48x48, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_filled_48_av_playlist_play_data[] PROGMEM = {
  0xFF, 0xF9, 0x77, 0x2F, 0xFF, 0x97, 0x72, 0xFF, 0xF9, 0x77, 0x2F, 0xFF, 0x98, 0x0A, 0xC4, 0x0F,
  0xFF, 0x97, 0x72, 0xFF, 0xF9, 0x77, 0x2F, 0xFF, 0x97, 0x72, 0xFF, 0xF9, 0x80, 0x9E, 0x20, 0x0A,
  0x01, 0x80, 0xC0, 0x09, 0x0E, 0x05, 0x72, 0xFF, 0x75, 0xB0, 0xA0, 0x17, 0xFF, 0x75, 0xC0, 0xE0,
  0x56, 0xFF, 0x75, 0xE0, 0xA0, 0x14, 0xFF, 0x75, 0xF0, 0xE0, 0x57, 0x77, 0x71, 0xFA, 0x0A, 0x01,
  0x77, 0x76, 0xFB, 0x0E, 0x05, 0x77, 0x75, 0xFB, 0x0E, 0x05, 0x77, 0x75, 0xFA, 0x0A, 0x01, 0x77,
  0x76, 0xF0, 0xE0, 0x57, 0x77, 0x71, 0xE0, 0xA0, 0x17, 0x77, 0x72, 0xC0, 0xE0, 0x57, 0x77, 0x74,
  0xB0, 0xA0, 0x17, 0x77, 0x75, 0x90, 0xE0, 0x57, 0x77, 0x77, 0x0A, 0x01, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_playlist_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 43, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_playlist_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_playlist_remove 48x48, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_filled_48_av_playlist_remove_data[] PROGMEM = {
  0xFF, 0xF9, 0x77, 0xFF, 0xF9, 0x77, 0xFF, 0xF9, 0x77, 0xFF, 0xF9, 0x80, 0xAB, 0x20, 0xFF, 0xF9,
  0x77, 0xFF, 0xF9, 0x77, 0xFF, 0xF9, 0x77, 0xFF, 0xF9, 0x80, 0xAB, 0x20, 0xFF, 0x71, 0x0A, 0x05,
  0x71, 0x05, 0x0A, 0x2F, 0xF7, 0x0A, 0xA0, 0x56, 0x05, 0xA0, 0xA1, 0xFF, 0x60, 0xAC, 0x05, 0x40,
  0x5C, 0x0A, 0xFF, 0x60, 0x5D, 0x05, 0x20, 0x5D, 0x05, 0x77, 0x70, 0x5D, 0x00, 0x5D, 0x05, 0x77,
  0x72, 0x05, 0xFB, 0x05, 0x77, 0x74, 0x05, 0xF9, 0x05, 0x77, 0x76, 0x05, 0xE0, 0x57, 0x77, 0x70,
  0x5E, 0x05, 0x77, 0x76, 0x05, 0xF9, 0x05, 0x77, 0x74, 0x05, 0xFB, 0x05, 0x77, 0x72, 0x05, 0xD0,
  0x05, 0xD0, 0x57, 0x77, 0x05, 0xD0, 0x52, 0x05, 0xD0, 0x57, 0x76, 0x0A, 0xC0, 0x54, 0x05, 0xC0,
  0xA7, 0x77, 0x0A, 0xA0, 0x56, 0x05, 0xA0, 0xA7, 0x77, 0x20, 0xA0, 0x57, 0x10, 0x50, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_playlist_remove() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 41, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_playlist_remove_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_queue_music 48x48, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_filled_48_av_queue_music_data[] PROGMEM = {
  0xFF, 0xFB, 0x4F, 0xFF, 0xFE, 0x4F, 0xFF, 0xFE, 0x4F, 0xFF, 0xFE, 0x4F, 0xB7, 0x77, 0x7C, 0x77,
  0x77, 0x6C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x6F, 0xFF, 0xB4, 0xC6, 0xFF, 0xFB, 0x4C, 0x6F,
  0xFF, 0xB4, 0xC6, 0xFF, 0xFB, 0x4C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x77, 0x77, 0x6C, 0x77,
  0x77, 0x6C, 0x6F, 0xFA, 0x78, 0x36, 0xCE, 0xEB, 0xC6, 0xFF, 0xA5, 0x01, 0x0C, 0xFA, 0x6F, 0xFA,
  0x50, 0xCF, 0xB6, 0xFF, 0xA4, 0x06, 0xFC, 0x77, 0x75, 0x0C, 0xFC, 0x77, 0x75, 0x0E, 0xFC, 0x77,
  0x75, 0x0E, 0xFB, 0x0E, 0x77, 0x75, 0x0C, 0xFB, 0x0C, 0x77, 0x75, 0x06, 0xFB, 0x06, 0x77, 0x76,
  0x0C, 0xF9, 0x0C, 0x77, 0x77, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x72, 0x84, 0x6C, 0xEE, 0xC6,
  0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_queue_music() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_queue_music_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_queue_play_next 48x48, 4-bit Alpha,  RLE, 217 bytes.
static const unsigned char ic_filled_48_av_queue_play_next_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x30, 0x10, 0xE8, 0x0C, 0x4F, 0x0E, 0x01, 0x20,
  0xA8, 0x0C, 0x6F, 0x0A, 0x20, 0xD8, 0x0C, 0x6F, 0x0D, 0x2C, 0x80, 0xC0, 0x0C, 0x2C, 0x80, 0xC0,
  0x0C, 0x2C, 0x80, 0xC0, 0x0C, 0x2C, 0x80, 0xC0, 0x0C, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x2C, 0x77,
  0x2C, 0x77, 0x2C, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x2C, 0x77, 0x2C,
  0x77, 0x2C, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x2C, 0x73, 0xFF, 0xA7, 0x3C, 0x2C, 0x73, 0xFF, 0xA7,
  0x3C, 0x2C, 0x73, 0xFF, 0xA7, 0x3C, 0x2C, 0x73, 0xFF, 0xA7, 0x3C, 0x2C, 0x77, 0x2C, 0x77, 0x2C,
  0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x2C, 0x77, 0x2C, 0x77, 0x71, 0xC7, 0x72, 0xC7, 0x50, 0x07, 0x71,
  0xC7, 0x72, 0xC7, 0x40, 0x7A, 0x07, 0x7C, 0x77, 0x2C, 0x73, 0x07, 0xC0, 0x76, 0xC7, 0x77, 0x72,
  0x07, 0xD0, 0x75, 0xC7, 0x77, 0x73, 0x07, 0xD0, 0x74, 0xC7, 0x77, 0x74, 0x07, 0xD0, 0x73, 0xC7,
  0x77, 0x75, 0x07, 0xD0, 0x72, 0x0D, 0xFF, 0xFF, 0xD4, 0x07, 0xD8, 0x17, 0x0A, 0xFF, 0xFF, 0xD5,
  0x07, 0xD8, 0x17, 0x1E, 0xFF, 0xFF, 0xC5, 0x07, 0xD8, 0x37, 0x01, 0xAD, 0xFF, 0xFF, 0xA4, 0x07,
  0xD0, 0x77, 0x71, 0xFF, 0xA7, 0x07, 0xD0, 0x77, 0x72, 0xFF, 0xA6, 0x07, 0xD0, 0x77, 0x73, 0xFF,
  0xA5, 0x07, 0xD0, 0x77, 0x74, 0xFF, 0xA4, 0x07, 0xD0, 0x78, 0x0C, 0x30, 0x07, 0xC0, 0x78, 0x0C,
  0x50, 0x07, 0xA0, 0x78, 0x0C, 0x70, 0x00, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_queue_play_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 47, 44), Box(0, 0, 47, 47),
      ic_filled_48_av_queue_play_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_queue 48x48, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_filled_48_av_queue_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF,
  0xFC, 0x71, 0xFF, 0x4F, 0xF7, 0x1F, 0xF4, 0xFF, 0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4,
  0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4, 0xE7, 0x76,
  0xFB, 0x4E, 0x77, 0x6F, 0xB4, 0xE7, 0x76, 0xFB, 0x4E, 0x77, 0x6F, 0xB4, 0xFF, 0x4F, 0xFC, 0x4F,
  0xF4, 0xFF, 0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF,
  0xC4, 0xFF, 0x4F, 0xFC, 0x4F, 0xF4, 0xFF, 0xC4, 0x80, 0xC0, 0xF4, 0x80, 0xC0, 0xF4, 0x0D, 0xFF,
  0xFF, 0xA0, 0xDC, 0x40, 0xAF, 0xFF, 0xFA, 0x0A, 0xC4, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0xC5,
  0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x1C, 0x80, 0xC0, 0x0C, 0x80, 0xC0, 0x0C, 0x80, 0xC0,
  0x0C, 0x80, 0xC0, 0x00, 0xDF, 0xFF, 0xFB, 0x71, 0x0A, 0xFF, 0xFF, 0xB7, 0x10, 0x10, 0xEF, 0xFF,
  0xFA, 0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xF7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_radio 48x48, 4-bit Alpha,  RLE, 209 bytes.
static const unsigned char ic_filled_48_av_radio_data[] PROGMEM = {
  0x77, 0x74, 0x81, 0x17, 0xC7, 0x77, 0x77, 0x04, 0x0A, 0xB0, 0x57, 0x77, 0x73, 0x81, 0x16, 0xDD,
  0x0C, 0x77, 0x77, 0x10, 0x30, 0x9F, 0x0E, 0x08, 0x77, 0x76, 0x06, 0x0C, 0xF0, 0xC0, 0x57, 0x77,
  0x58, 0x12, 0x9E, 0xE8, 0x1E, 0x92, 0x77, 0x75, 0x05, 0x0C, 0xF0, 0xC0, 0x67, 0x77, 0x58, 0x12,
  0x8E, 0xE8, 0x1E, 0x93, 0x77, 0x75, 0x05, 0x0B, 0xF0, 0xC0, 0x67, 0x77, 0x58, 0x11, 0x8E, 0xF0,
  0x90, 0x37, 0x77, 0x50, 0x20, 0xAF, 0xFF, 0xFD, 0x84, 0xEA, 0x10, 0x2E, 0x80, 0xC0, 0xF8, 0x1E,
  0x1A, 0x80, 0xC2, 0xF0, 0xA0, 0xE8, 0x0C, 0x2F, 0x0D, 0xC7, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F,
  0x97, 0x77, 0x74, 0xF9, 0x77, 0x77, 0x4F, 0x97, 0x77, 0x3C, 0x4F, 0x97, 0x77, 0x3C, 0x4F, 0x97,
  0x77, 0x3C, 0x4F, 0x97, 0x77, 0x3C, 0x48, 0x0A, 0xC7, 0xF0, 0x80, 0x32, 0x03, 0x08, 0xFF, 0xFF,
  0xC0, 0xD0, 0x26, 0x02, 0x0D, 0xFF, 0xFF, 0xA0, 0x27, 0x10, 0x2F, 0xFF, 0xF9, 0x08, 0x73, 0x08,
  0xFF, 0xFF, 0x03, 0x73, 0x03, 0xFF, 0xFF, 0x75, 0xFF, 0xFF, 0x75, 0xFF, 0xFF, 0x03, 0x73, 0x03,
  0xFF, 0xFF, 0x08, 0x73, 0x08, 0xFF, 0xFF, 0x90, 0x27, 0x10, 0x2F, 0xFF, 0xFA, 0x0D, 0x02, 0x60,
  0x20, 0xDF, 0xFF, 0xFC, 0x08, 0x03, 0x20, 0x30, 0x8F, 0xFF, 0xE0, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A,
  0x80, 0xC2, 0xF8, 0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA,
  0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_radio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_radio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_recent_actors 48x48, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_filled_48_av_recent_actors_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x4C, 0x4C, 0x0D, 0xFF, 0xFD, 0x0D, 0x4C, 0x4F, 0xFF, 0xFC,
  0x4C, 0x4F, 0xFF, 0xFC, 0x4C, 0x4F, 0xFF, 0xFC, 0x4C, 0x4F, 0xFA, 0x82, 0xC9, 0x9C, 0xFD, 0x4C,
  0x4F, 0xF0, 0xE0, 0x54, 0x05, 0x0E, 0xFB, 0x4C, 0x4F, 0xF0, 0x56, 0x05, 0xFB, 0x4C, 0x4F, 0xE0,
  0xC7, 0x10, 0xCF, 0xA4, 0xC4, 0xFE, 0x09, 0x71, 0x09, 0xFA, 0x4C, 0x4F, 0xE0, 0x97, 0x10, 0x9F,
  0xA4, 0xC4, 0xFE, 0x0C, 0x71, 0x0C, 0xFA, 0x4C, 0x4F, 0xF0, 0x56, 0x05, 0xFB, 0x4C, 0x4F, 0xF0,
  0xE0, 0x54, 0x05, 0x0E, 0xFB, 0x4C, 0x4F, 0xFA, 0x82, 0xC9, 0x9C, 0xFD, 0x4C, 0x4F, 0xFF, 0xFC,
  0x4C, 0x4F, 0xFF, 0xFC, 0x4C, 0x4F, 0xFF, 0xFC, 0x4C, 0x4F, 0xE8, 0x2C, 0x74, 0x12, 0x82, 0x24,
  0x7B, 0xFA, 0x4C, 0x4F, 0xC0, 0x80, 0x17, 0x30, 0x10, 0x8F, 0x4C, 0x4F, 0xA0, 0xE0, 0x27, 0x70,
  0x20, 0xED, 0x4C, 0x4F, 0xA0, 0x47, 0x72, 0x04, 0xD4, 0xC4, 0xFA, 0x77, 0x4D, 0x4C, 0x4F, 0xA7,
  0x74, 0xD4, 0xC4, 0xFF, 0xFF, 0xC4, 0xC4, 0xFF, 0xFF, 0xC4, 0xC4, 0xC0, 0xDF, 0xFF, 0xD0, 0xD4,
  0xC4, 0xC0, 0x40, 0xDF, 0xFF, 0xB0, 0xD0, 0x44, 0xC4, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_recent_actors() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 10, 45, 37), Box(0, 0, 47, 47),
      ic_filled_48_av_recent_actors_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_remove_from_queue 48x48, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_filled_48_av_remove_from_queue_data[] PROGMEM = {
  0x18, 0x11, 0xAE, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98,
  0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x73, 0xFF, 0xA7, 0x3F, 0x97, 0x3F,
  0xFA, 0x73, 0xF9, 0x73, 0xFF, 0xA7, 0x3F, 0x97, 0x3F, 0xFA, 0x73, 0xF9, 0x80, 0xC0, 0x0F, 0x98,
  0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00,
  0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xC0, 0xD8,
  0x0C, 0x6F, 0x0D, 0x0A, 0x80, 0xC6, 0xF8, 0x19, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8,
  0x0C, 0x0F, 0x81, 0xDA, 0x17, 0x71, 0xFF, 0xA7, 0x77, 0x7F, 0xFA, 0x77, 0x77, 0xFF, 0xA7, 0x77,
  0x7F, 0xFA, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_remove_from_queue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_remove_from_queue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_repeat_one_on 48x48, 4-bit Alpha,  RLE, 216 bytes.
static const unsigned char ic_filled_48_av_repeat_one_on_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xAF, 0xFF,
  0xFB, 0x07, 0xFB, 0x0A, 0x0D, 0xFF, 0xFF, 0xB1, 0x07, 0xFA, 0x0D, 0xFF, 0xFF, 0xC2, 0x07, 0x80,
  0xC5, 0xF3, 0x07, 0x80, 0xC4, 0xF4, 0x07, 0x80, 0xC3, 0xF5, 0x07, 0xFF, 0x77, 0x77, 0x20, 0x7F,
  0xE7, 0x77, 0x73, 0x07, 0xFD, 0x77, 0x77, 0x30, 0x7F, 0xD7, 0x77, 0x72, 0x07, 0xFE, 0x4F, 0xFE,
  0x50, 0x7F, 0xF4, 0xFF, 0xE4, 0x07, 0xFF, 0x94, 0xFF, 0xE3, 0x07, 0xFF, 0xA4, 0xFF, 0xE2, 0x07,
  0xFF, 0xB4, 0xF9, 0x0B, 0x03, 0x2F, 0x91, 0x07, 0xFF, 0xC4, 0xE0, 0xB0, 0x34, 0xF9, 0x07, 0xFF,
  0xD4, 0xE6, 0xFF, 0xFF, 0x4E, 0x68, 0x0C, 0x5F, 0x38, 0x0C, 0x5F, 0x38, 0x0C, 0x5F, 0x38, 0x0C,
  0x5F, 0x38, 0x0C, 0x5F, 0x3F, 0x94, 0xFF, 0xFF, 0x93, 0xF9, 0x4F, 0xFD, 0x07, 0xFA, 0x3F, 0x94,
  0xFF, 0xC0, 0x71, 0xFA, 0x3F, 0x94, 0xFF, 0xB0, 0x72, 0xFF, 0xE4, 0xFF, 0xA0, 0x73, 0xFF, 0xE4,
  0xFF, 0x90, 0x74, 0xFF, 0xE4, 0xFF, 0x07, 0x5F, 0xFE, 0x4F, 0xE0, 0x77, 0x77, 0x72, 0xFD, 0x07,
  0x77, 0x77, 0x3F, 0xD0, 0x77, 0x77, 0x73, 0xFE, 0x07, 0x77, 0x77, 0x2F, 0xF0, 0x75, 0x80, 0xC3,
  0xF0, 0x74, 0x80, 0xC4, 0xF0, 0x73, 0x80, 0xC5, 0xF0, 0x72, 0xFF, 0xFF, 0xC0, 0xDF, 0xA0, 0x71,
  0xFF, 0xFF, 0xB0, 0xD0, 0xAF, 0xB0, 0x7F, 0xFF, 0xFB, 0x81, 0xA1, 0xE8, 0x0C, 0x4F, 0x84, 0xE1,
  0x01, 0xAD, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_repeat_one_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_filled_48_av_repeat_one_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_repeat_one 48x48, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_filled_48_av_repeat_one_data[] PROGMEM = {
  0x77, 0x77, 0x07, 0x77, 0x77, 0x79, 0x07, 0x77, 0x77, 0x6A, 0x07, 0x77, 0x77, 0x5B, 0x07, 0x77,
  0x77, 0x4C, 0x07, 0x77, 0x77, 0x3D, 0x07, 0x6F, 0xFF, 0xFA, 0x07, 0x5F, 0xFF, 0xFB, 0x07, 0x4F,
  0xFF, 0xFB, 0x07, 0x4F, 0xFF, 0xFA, 0x07, 0x5C, 0x77, 0x6D, 0x07, 0x6C, 0x77, 0x6C, 0x07, 0x7C,
  0x77, 0x6B, 0x07, 0x71, 0xC7, 0x76, 0xA0, 0x77, 0x2C, 0x71, 0x03, 0x0B, 0xA7, 0x19, 0x07, 0x73,
  0xC6, 0x03, 0x0B, 0xC7, 0x10, 0x77, 0x4C, 0x6E, 0x77, 0x6C, 0x6E, 0x77, 0x77, 0x5B, 0x77, 0x77,
  0x5B, 0x77, 0x77, 0x5B, 0x77, 0x77, 0x5B, 0x77, 0x77, 0x5B, 0x71, 0xC7, 0x77, 0xB7, 0x1C, 0x74,
  0x07, 0x72, 0xB7, 0x1C, 0x73, 0x07, 0x97, 0x2B, 0x71, 0xC7, 0x20, 0x7A, 0x77, 0x6C, 0x71, 0x07,
  0xB7, 0x76, 0xC7, 0x07, 0xC7, 0x76, 0xC6, 0x07, 0xD7, 0x76, 0xC5, 0x07, 0xFF, 0xFF, 0xA4, 0x07,
  0xFF, 0xFF, 0xB4, 0x07, 0xFF, 0xFF, 0xB5, 0x07, 0xFF, 0xFF, 0xA6, 0x07, 0xD7, 0x77, 0x73, 0x07,
  0xC7, 0x77, 0x74, 0x07, 0xB7, 0x77, 0x75, 0x07, 0xA7, 0x77, 0x76, 0x07, 0x97, 0x77, 0x77, 0x07,
  0x77, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_repeat_one() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_repeat_one_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_repeat_on 48x48, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_filled_48_av_repeat_on_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xAF, 0xFF,
  0xFB, 0x07, 0xFB, 0x0A, 0x0D, 0xFF, 0xFF, 0xB1, 0x07, 0xFA, 0x0D, 0xFF, 0xFF, 0xC2, 0x07, 0x80,
  0xC5, 0xF3, 0x07, 0x80, 0xC4, 0xF4, 0x07, 0x80, 0xC3, 0xF5, 0x07, 0xFF, 0x77, 0x77, 0x20, 0x7F,
  0xE7, 0x77, 0x73, 0x07, 0xFD, 0x77, 0x77, 0x30, 0x7F, 0xD7, 0x77, 0x72, 0x07, 0xFE, 0x4F, 0xFE,
  0x50, 0x7F, 0xF4, 0xFF, 0xE4, 0x07, 0xFF, 0x94, 0xFF, 0xE3, 0x07, 0xFF, 0xA4, 0xFF, 0xE2, 0x07,
  0xFF, 0xB4, 0xFF, 0xE1, 0x07, 0xFF, 0xC4, 0xFF, 0xE0, 0x7F, 0xFD, 0x48, 0x0C, 0x4F, 0x48, 0x0B,
  0xD4, 0xF4, 0x80, 0xC4, 0xF4, 0xFF, 0xD0, 0x7F, 0xFE, 0x4F, 0xFC, 0x07, 0x1F, 0xFE, 0x4F, 0xFB,
  0x07, 0x2F, 0xFE, 0x4F, 0xFA, 0x07, 0x3F, 0xFE, 0x4F, 0xF9, 0x07, 0x4F, 0xFE, 0x4F, 0xF0, 0x75,
  0xFF, 0xE4, 0xFE, 0x07, 0x77, 0x77, 0x2F, 0xD0, 0x77, 0x77, 0x73, 0xFD, 0x07, 0x77, 0x77, 0x3F,
  0xE0, 0x77, 0x77, 0x72, 0xFF, 0x07, 0x58, 0x0C, 0x3F, 0x07, 0x48, 0x0C, 0x4F, 0x07, 0x38, 0x0C,
  0x5F, 0x07, 0x2F, 0xFF, 0xFC, 0x0D, 0xFA, 0x07, 0x1F, 0xFF, 0xFB, 0x0D, 0x0A, 0xFB, 0x07, 0xFF,
  0xFF, 0xB8, 0x1A, 0x1E, 0x80, 0xC4, 0xF8, 0x4E, 0x10, 0x1A, 0xD8, 0x0C, 0x0F, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_repeat_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_filled_48_av_repeat_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_repeat 48x48, 4-bit Alpha,  RLE, 140 bytes.
static const unsigned char ic_filled_48_av_repeat_data[] PROGMEM = {
  0x77, 0x77, 0x07, 0x77, 0x77, 0x79, 0x07, 0x77, 0x77, 0x6A, 0x07, 0x77, 0x77, 0x5B, 0x07, 0x77,
  0x77, 0x4C, 0x07, 0x77, 0x77, 0x3D, 0x07, 0x6F, 0xFF, 0xFA, 0x07, 0x5F, 0xFF, 0xFB, 0x07, 0x4F,
  0xFF, 0xFB, 0x07, 0x4F, 0xFF, 0xFA, 0x07, 0x5C, 0x77, 0x6D, 0x07, 0x6C, 0x77, 0x6C, 0x07, 0x7C,
  0x77, 0x6B, 0x07, 0x71, 0xC7, 0x76, 0xA0, 0x77, 0x2C, 0x77, 0x69, 0x07, 0x73, 0xC7, 0x76, 0x07,
  0x74, 0xC7, 0x77, 0x74, 0xC8, 0x0B, 0x84, 0x0C, 0x77, 0x77, 0x4C, 0x74, 0x07, 0x77, 0x6C, 0x73,
  0x07, 0x97, 0x76, 0xC7, 0x20, 0x7A, 0x77, 0x6C, 0x71, 0x07, 0xB7, 0x76, 0xC7, 0x07, 0xC7, 0x76,
  0xC6, 0x07, 0xD7, 0x76, 0xC5, 0x07, 0xFF, 0xFF, 0xA4, 0x07, 0xFF, 0xFF, 0xB4, 0x07, 0xFF, 0xFF,
  0xB5, 0x07, 0xFF, 0xFF, 0xA6, 0x07, 0xD7, 0x77, 0x73, 0x07, 0xC7, 0x77, 0x74, 0x07, 0xB7, 0x77,
  0x75, 0x07, 0xA7, 0x77, 0x76, 0x07, 0x97, 0x77, 0x77, 0x07, 0x77, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_repeat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 41, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_repeat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_replay_10 48x48, 4-bit Alpha,  RLE, 300 bytes.
static const unsigned char ic_filled_48_av_replay_10_data[] PROGMEM = {
  0x77, 0x10, 0x77, 0x77, 0x72, 0x08, 0x97, 0x77, 0x71, 0x08, 0xA7, 0x77, 0x70, 0x8B, 0x77, 0x76,
  0x08, 0xC7, 0x77, 0x50, 0x8D, 0x77, 0x74, 0x08, 0xE7, 0x77, 0x30, 0x8F, 0x77, 0x72, 0x08, 0xF9,
  0x83, 0xED, 0xB8, 0x47, 0x73, 0x08, 0xFF, 0x81, 0xE8, 0x17, 0x70, 0x8F, 0xFA, 0x0E, 0x07, 0x77,
  0x08, 0xFF, 0xB0, 0xB0, 0x17, 0x60, 0x8F, 0x18, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x76, 0x08, 0xE5,
  0x06, 0x0E, 0xC0, 0xD0, 0x17, 0x60, 0x8D, 0x70, 0xBC, 0x0B, 0x77, 0x08, 0xC7, 0x10, 0x9C, 0x07,
  0x77, 0x08, 0xB7, 0x20, 0xBB, 0x0E, 0x01, 0x77, 0x08, 0xA7, 0x30, 0xEB, 0x08, 0x77, 0x10, 0x89,
  0x73, 0x06, 0xB0, 0xE7, 0x72, 0x07, 0x74, 0x0E, 0xB0, 0x47, 0x77, 0x60, 0x9B, 0x08, 0x75, 0x02,
  0x05, 0x48, 0x17, 0x96, 0x60, 0x4B, 0x0B, 0x73, 0x82, 0x6C, 0xFC, 0x38, 0x3C, 0xFC, 0xFA, 0x50,
  0x2B, 0x0C, 0x73, 0x82, 0xDA, 0xEC, 0x28, 0x53, 0xF7, 0x08, 0xF2, 0x40, 0x1B, 0x0E, 0xC7, 0x10,
  0xE0, 0xC2, 0x85, 0x6F, 0x40, 0x6F, 0x44, 0x01, 0xB0, 0xE0, 0xDB, 0x02, 0x70, 0xE0, 0xC2, 0x85,
  0x6F, 0x30, 0x5F, 0x54, 0x02, 0xB0, 0xC0, 0xBB, 0x04, 0x70, 0xE0, 0xC2, 0x85, 0x6F, 0x30, 0x5F,
  0x54, 0x04, 0xB0, 0xB0, 0x9B, 0x08, 0x70, 0xE0, 0xC2, 0x85, 0x5F, 0x50, 0x7F, 0x34, 0x09, 0xB0,
  0x80, 0x4B, 0x0D, 0x70, 0xE0, 0xC2, 0x84, 0x1F, 0xB4, 0xDE, 0x50, 0xEB, 0x81, 0x40, 0xEB, 0x05,
  0x60, 0xE0, 0xC3, 0x83, 0x4E, 0xFE, 0x44, 0x06, 0xB0, 0xE2, 0x09, 0xB0, 0xD7, 0x60, 0x16, 0x0E,
  0xB0, 0x82, 0x01, 0x0E, 0xB0, 0xA7, 0x74, 0x0B, 0xB0, 0xE0, 0x13, 0x08, 0xC0, 0x87, 0x72, 0x09,
  0xC0, 0x75, 0x0C, 0xC0, 0xA7, 0x70, 0xBC, 0x0B, 0x60, 0x10, 0xDC, 0x0D, 0x05, 0x73, 0x06, 0x0E,
  0xC0, 0xD0, 0x17, 0x03, 0x0D, 0xD8, 0x2D, 0x84, 0x22, 0x82, 0x24, 0x9D, 0xD0, 0xD0, 0x27, 0x20,
  0x10, 0xCF, 0xFC, 0x0B, 0x01, 0x75, 0x08, 0x0E, 0xFF, 0x0E, 0x07, 0x77, 0x18, 0x11, 0x9E, 0xFB,
  0x81, 0xE8, 0x17, 0x75, 0x89, 0x04, 0x9B, 0xDE, 0xED, 0xB8, 0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_replay_10() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_replay_10_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_replay_30 48x48, 4-bit Alpha,  RLE, 308 bytes.
static const unsigned char ic_filled_48_av_replay_30_data[] PROGMEM = {
  0x77, 0x10, 0x77, 0x77, 0x72, 0x07, 0x97, 0x77, 0x71, 0x07, 0xA7, 0x77, 0x70, 0x7B, 0x77, 0x76,
  0x07, 0xC7, 0x77, 0x50, 0x7D, 0x77, 0x74, 0x07, 0xE7, 0x77, 0x30, 0x7F, 0x77, 0x72, 0x07, 0xF9,
  0x83, 0xED, 0xB9, 0x47, 0x73, 0x07, 0xFF, 0x81, 0xE9, 0x17, 0x70, 0x7F, 0xFA, 0x0E, 0x07, 0x77,
  0x07, 0xFF, 0xB0, 0xC0, 0x17, 0x60, 0x7F, 0x18, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x76, 0x07, 0xE5,
  0x06, 0x0D, 0xC0, 0xD0, 0x17, 0x60, 0x7D, 0x70, 0xAC, 0x0C, 0x77, 0x07, 0xC7, 0x10, 0x8C, 0x07,
  0x77, 0x07, 0xB7, 0x20, 0xAB, 0x0E, 0x01, 0x77, 0x07, 0xA7, 0x30, 0xDB, 0x09, 0x77, 0x10, 0x79,
  0x73, 0x06, 0xB0, 0xE7, 0x72, 0x07, 0x74, 0x0D, 0xB0, 0x47, 0x77, 0x60, 0x9B, 0x09, 0x73, 0x82,
  0x38, 0x95, 0x48, 0x25, 0x97, 0x15, 0x04, 0xB0, 0xB7, 0x28, 0x44, 0xFD, 0xCF, 0x82, 0x83, 0x8F,
  0xCE, 0xD5, 0x02, 0xB0, 0xD7, 0x28, 0x45, 0x91, 0x0C, 0xE2, 0x84, 0xEB, 0x04, 0xF6, 0x5B, 0x00,
  0xEB, 0x71, 0x89, 0x11, 0xDC, 0x02, 0xF8, 0x02, 0xF8, 0x5B, 0x0E, 0x0D, 0xB0, 0x26, 0x89, 0x2D,
  0xFE, 0x20, 0x2F, 0x70, 0x1F, 0x94, 0x02, 0xB0, 0xD0, 0xBB, 0x04, 0x68, 0x92, 0x35, 0xDC, 0x02,
  0xF7, 0x01, 0xF9, 0x40, 0x4B, 0x0B, 0x09, 0xB0, 0x94, 0x04, 0x05, 0x28, 0x90, 0x9F, 0x11, 0xF9,
  0x03, 0xF7, 0x40, 0x9B, 0x09, 0x04, 0xB0, 0xD4, 0x84, 0x9F, 0x85, 0xDD, 0x28, 0x4C, 0xE5, 0xAF,
  0x34, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x64, 0x0A, 0xA0, 0xC0, 0x32, 0x02, 0x0C, 0xA0, 0x74, 0x06,
  0xB0, 0xE2, 0x09, 0xB0, 0xD7, 0x60, 0x16, 0x0D, 0xB0, 0x92, 0x01, 0x0E, 0xB0, 0xA7, 0x74, 0x0A,
  0xB0, 0xE0, 0x13, 0x07, 0xC0, 0x87, 0x72, 0x08, 0xC0, 0x75, 0x0C, 0xC0, 0xA7, 0x70, 0xAC, 0x0C,
  0x60, 0x10, 0xDC, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xC0, 0xD0, 0x17, 0x02, 0x0D, 0xD8, 0x2D, 0x94,
  0x22, 0x82, 0x24, 0x9D, 0xD0, 0xD0, 0x27, 0x20, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x75, 0x07, 0x0E,
  0xFF, 0x0E, 0x07, 0x77, 0x18, 0x11, 0x9E, 0xFB, 0x81, 0xE9, 0x17, 0x75, 0x89, 0x04, 0x9B, 0xDE,
  0xED, 0xB9, 0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_replay_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_replay_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_replay_5 48x48, 4-bit Alpha,  RLE, 276 bytes.
static const unsigned char ic_filled_48_av_replay_5_data[] PROGMEM = {
  0x77, 0x10, 0x77, 0x77, 0x72, 0x07, 0x97, 0x77, 0x71, 0x07, 0xA7, 0x77, 0x70, 0x7B, 0x77, 0x76,
  0x07, 0xC7, 0x77, 0x50, 0x7D, 0x77, 0x74, 0x07, 0xE7, 0x77, 0x30, 0x7F, 0x77, 0x72, 0x07, 0xF9,
  0x83, 0xED, 0xB9, 0x47, 0x73, 0x07, 0xFF, 0x81, 0xE9, 0x17, 0x70, 0x7F, 0xFA, 0x0E, 0x07, 0x77,
  0x07, 0xFF, 0xB0, 0xC0, 0x17, 0x60, 0x7F, 0x18, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x76, 0x07, 0xE5,
  0x06, 0x0D, 0xC0, 0xD0, 0x17, 0x60, 0x7D, 0x70, 0xAC, 0x0C, 0x77, 0x07, 0xC7, 0x10, 0x8C, 0x07,
  0x77, 0x07, 0xB7, 0x20, 0xAB, 0x0E, 0x01, 0x77, 0x07, 0xA7, 0x30, 0xDB, 0x09, 0x77, 0x10, 0x79,
  0x73, 0x06, 0xB0, 0xE7, 0x72, 0x07, 0x74, 0x0D, 0xB0, 0x47, 0x77, 0x60, 0x9B, 0x09, 0x76, 0x84,
  0x17, 0x77, 0x75, 0x71, 0x04, 0xB0, 0xB7, 0x68, 0x43, 0xFE, 0xDD, 0x87, 0x10, 0x2B, 0x0D, 0x76,
  0x81, 0x5F, 0x27, 0x5B, 0x00, 0xEB, 0x72, 0x83, 0x7F, 0x78, 0x47, 0x3B, 0x0E, 0x0D, 0xB0, 0x27,
  0x18, 0x47, 0xFB, 0xDF, 0x67, 0x10, 0x2B, 0x0D, 0x0B, 0xB0, 0x47, 0x50, 0xD0, 0xC7, 0x10, 0x4B,
  0x0B, 0x09, 0xB0, 0x97, 0x10, 0x40, 0x52, 0x0C, 0x0D, 0x71, 0x09, 0xB0, 0x90, 0x4B, 0x0D, 0x71,
  0x84, 0x9F, 0x66, 0xF9, 0x71, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x67, 0x01, 0x0A, 0xA0, 0xA0, 0x17,
  0x06, 0xB0, 0xE2, 0x09, 0xB0, 0xD7, 0x76, 0x0D, 0xB0, 0x92, 0x01, 0x0E, 0xB0, 0xA7, 0x74, 0x0A,
  0xB0, 0xE0, 0x13, 0x07, 0xC0, 0x87, 0x72, 0x08, 0xC0, 0x75, 0x0C, 0xC0, 0xA7, 0x70, 0xAC, 0x0C,
  0x60, 0x10, 0xDC, 0x0D, 0x06, 0x73, 0x06, 0x0D, 0xC0, 0xD0, 0x17, 0x02, 0x0D, 0xD8, 0x2D, 0x94,
  0x22, 0x82, 0x24, 0x9D, 0xD0, 0xD0, 0x27, 0x20, 0x10, 0xCF, 0xFC, 0x0C, 0x01, 0x75, 0x07, 0x0E,
  0xFF, 0x0E, 0x07, 0x77, 0x18, 0x11, 0x9E, 0xFB, 0x81, 0xE9, 0x17, 0x75, 0x89, 0x04, 0x9B, 0xDE,
  0xED, 0xB9, 0x47, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_replay_5() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_replay_5_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_replay_circle_filled 48x48, 4-bit Alpha,  RLE, 324 bytes.
static const unsigned char ic_filled_48_av_replay_circle_filled_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xF9, 0x07, 0xFA, 0x09, 0x01, 0x77, 0x30, 0x50, 0xEF, 0x90, 0x71, 0xFB,
  0x0E, 0x05, 0x77, 0x10, 0x9F, 0xA0, 0x72, 0xFD, 0x09, 0x76, 0x0A, 0xFA, 0x07, 0x3F, 0xE0, 0xA7,
  0x40, 0xAF, 0xA0, 0x74, 0xFF, 0x0A, 0x72, 0x09, 0xFA, 0x07, 0x5F, 0xF9, 0x09, 0x70, 0x5F, 0xA0,
  0x77, 0x82, 0x24, 0x9D, 0xFC, 0x05, 0x50, 0x10, 0xEF, 0x90, 0x77, 0x50, 0x60, 0xDF, 0xA0, 0xE0,
  0x14, 0x09, 0xFA, 0x07, 0x77, 0x0A, 0xFA, 0x09, 0x30, 0x1F, 0xC0, 0x77, 0x70, 0x8F, 0xA0, 0x12,
  0x08, 0xFD, 0x07, 0x58, 0x2E, 0xC8, 0x25, 0x0A, 0xF9, 0x08, 0x20, 0xDF, 0xE0, 0x74, 0xC0, 0x95,
  0x0D, 0xF8, 0x1D, 0x03, 0xFF, 0x90, 0x73, 0xD0, 0xB4, 0x06, 0xF9, 0x03, 0x07, 0xFF, 0xA0, 0x72,
  0xE0, 0x94, 0x0D, 0xF0, 0x70, 0xAF, 0xFB, 0x07, 0x1F, 0x02, 0x30, 0x9F, 0x0A, 0x0C, 0xFF, 0xC0,
  0x7F, 0x08, 0x30, 0x4F, 0x0C, 0x0E, 0xFF, 0xFD, 0x0C, 0x30, 0x2F, 0x0E, 0xFF, 0xFE, 0x0E, 0x4F,
  0xFA, 0x40, 0xEF, 0xF0, 0xE4, 0xF9, 0x0E, 0xF0, 0x23, 0x0C, 0xFF, 0x0C, 0x30, 0x2F, 0x0E, 0x0C,
  0xF0, 0x43, 0x08, 0xFF, 0x08, 0x30, 0x4F, 0x0C, 0x0A, 0xF0, 0x93, 0x02, 0xFF, 0x02, 0x30, 0x9F,
  0x0A, 0x07, 0xF0, 0xD4, 0x09, 0xFD, 0x09, 0x40, 0xDF, 0x07, 0x03, 0xF9, 0x06, 0x40, 0xBF, 0xB0,
  0xB4, 0x06, 0xF9, 0x81, 0x30, 0xDF, 0x0D, 0x50, 0x9F, 0x90, 0x95, 0x0D, 0xF0, 0xD2, 0x08, 0xF9,
  0x0A, 0x58, 0x62, 0x8C, 0xEE, 0xC8, 0x25, 0x0A, 0xF9, 0x08, 0x20, 0x1F, 0xA0, 0x87, 0x72, 0x08,
  0xFA, 0x01, 0x30, 0x9F, 0xA0, 0xA7, 0x70, 0xAF, 0xA0, 0x94, 0x01, 0x0E, 0xFA, 0x0D, 0x06, 0x73,
  0x06, 0x0D, 0xFA, 0x0E, 0x01, 0x50, 0x5F, 0xC8, 0x2D, 0x94, 0x22, 0x82, 0x24, 0x9D, 0xFC, 0x05,
  0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A, 0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76,
  0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E, 0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC,
  0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17, 0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8,
  0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_replay_circle_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_replay_circle_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_replay 48x48, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_filled_48_av_replay_data[] PROGMEM = {
  0x77, 0x10, 0x77, 0x77, 0x72, 0x07, 0x97, 0x77, 0x71, 0x07, 0xA7, 0x77, 0x70, 0x7B, 0x77, 0x76,
  0x07, 0xC7, 0x77, 0x50, 0x7D, 0x77, 0x74, 0x07, 0xE7, 0x77, 0x30, 0x7F, 0x77, 0x72, 0x07, 0xF9,
  0x83, 0xED, 0xB9, 0x47, 0x73, 0x07, 0xFF, 0x81, 0xE9, 0x17, 0x70, 0x7F, 0xFA, 0x0E, 0x07, 0x77,
  0x07, 0xFF, 0xB0, 0xC0, 0x17, 0x60, 0x7F, 0x18, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x76, 0x07, 0xE5,
  0x06, 0x0D, 0xC0, 0xD0, 0x17, 0x60, 0x7D, 0x70, 0xAC, 0x0C, 0x77, 0x07, 0xC7, 0x10, 0x8C, 0x07,
  0x77, 0x07, 0xB7, 0x20, 0xAB, 0x0E, 0x01, 0x77, 0x07, 0xA7, 0x30, 0xDB, 0x09, 0x77, 0x10, 0x79,
  0x73, 0x06, 0xB0, 0xE7, 0x72, 0x07, 0x74, 0x0D, 0xB0, 0x47, 0x77, 0x60, 0x9B, 0x09, 0x77, 0x76,
  0x04, 0xB0, 0xB7, 0x77, 0x60, 0x2B, 0x0D, 0x77, 0x77, 0xB0, 0x0E, 0xB7, 0x77, 0x3B, 0x0E, 0x0D,
  0xB0, 0x27, 0x77, 0x10, 0x2B, 0x0D, 0x0B, 0xB0, 0x47, 0x77, 0x10, 0x4B, 0x0B, 0x09, 0xB0, 0x97,
  0x77, 0x10, 0x9B, 0x09, 0x04, 0xB0, 0xD7, 0x77, 0x10, 0xDB, 0x81, 0x40, 0xEB, 0x06, 0x77, 0x60,
  0x6B, 0x0E, 0x20, 0x9B, 0x0D, 0x77, 0x60, 0xDB, 0x09, 0x20, 0x10, 0xEB, 0x0A, 0x77, 0x40, 0xAB,
  0x0E, 0x01, 0x30, 0x7C, 0x08, 0x77, 0x20, 0x8C, 0x07, 0x50, 0xCC, 0x0A, 0x77, 0x0A, 0xC0, 0xC6,
  0x01, 0x0D, 0xC0, 0xD0, 0x67, 0x30, 0x60, 0xDC, 0x0D, 0x01, 0x70, 0x20, 0xDD, 0x82, 0xD9, 0x42,
  0x28, 0x22, 0x49, 0xDD, 0x0D, 0x02, 0x72, 0x01, 0x0C, 0xFF, 0xC0, 0xC0, 0x17, 0x50, 0x70, 0xEF,
  0xF0, 0xE0, 0x77, 0x71, 0x81, 0x19, 0xEF, 0xB8, 0x1E, 0x91, 0x77, 0x58, 0x90, 0x49, 0xBD, 0xEE,
  0xDB, 0x94, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_replay() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 2, 39, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_replay_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_sd 48x48, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_filled_48_av_sd_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xCC, 0x2F, 0x0B, 0x01, 0x60, 0x10, 0xBC, 0x71, 0x01,
  0x0B, 0xFD, 0x01, 0x71, 0x01, 0xC7, 0x20, 0x1F, 0xD7, 0x3C, 0x73, 0xFD, 0x3C, 0x3C, 0x3C, 0x3F,
  0xD3, 0xFC, 0x3C, 0x3F, 0xD0, 0x17, 0x01, 0x0B, 0xC3, 0xC3, 0xFD, 0x0B, 0x01, 0x70, 0x1C, 0x3C,
  0x3F, 0xFD, 0x3C, 0x3C, 0x3F, 0xD3, 0xC3, 0xC3, 0xC3, 0xFD, 0x73, 0xC7, 0x3F, 0xD0, 0x17, 0x10,
  0x1C, 0x72, 0x01, 0xFD, 0x0B, 0x01, 0x60, 0x10, 0xBC, 0x71, 0x01, 0x0B, 0x80, 0xCC, 0x2F, 0x0D,
  0xFF, 0xFF, 0xE0, 0xD0, 0xAF, 0xFF, 0xFE, 0x81, 0xA1, 0xEF, 0xFF, 0xFC, 0x84, 0xE1, 0x01, 0xAD,
  0xFF, 0xFF, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_sd() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_sd_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_shuffle_on 48x48, 4-bit Alpha,  RLE, 281 bytes.
static const unsigned char ic_filled_48_av_shuffle_on_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xD8, 0x09, 0xB4, 0xF0, 0x50, 0xAF, 0xFB, 0x07, 0x73, 0xFE,
  0x05, 0x20, 0xAF, 0xFB, 0x07, 0x72, 0xFD, 0x05, 0x40, 0xAF, 0xFB, 0x07, 0x71, 0xFD, 0x0A, 0x50,
  0xAF, 0xFB, 0x07, 0x7F, 0xE0, 0xA5, 0x0A, 0xFF, 0xA0, 0xA7, 0xFF, 0x0A, 0x50, 0xAF, 0xF0, 0xA7,
  0x1F, 0xF9, 0x0A, 0x50, 0xAF, 0xD0, 0xA7, 0x2F, 0xFA, 0x0A, 0x50, 0xAF, 0xB0, 0xA5, 0x0A, 0x07,
  0x3F, 0xFB, 0x0A, 0x50, 0xAF, 0x90, 0xA5, 0x0A, 0xA0, 0x72, 0xFF, 0xC0, 0xA5, 0x0A, 0xE0, 0xA5,
  0x0A, 0xC0, 0x71, 0xFF, 0xD0, 0xA4, 0x02, 0x0E, 0xC0, 0xA5, 0x0A, 0xE0, 0x7F, 0xFE, 0x0A, 0x20,
  0x10, 0xDC, 0x0A, 0x50, 0xAF, 0xFF, 0xF9, 0x81, 0xA2, 0xDC, 0x0A, 0x50, 0xA8, 0x0C, 0x0F, 0x0A,
  0x50, 0xA8, 0x0C, 0x0F, 0x0A, 0x50, 0xA8, 0x0C, 0x0F, 0x0A, 0x50, 0xA8, 0x0C, 0x0F, 0x0A, 0x50,
  0xA8, 0x0C, 0x0F, 0x0A, 0x50, 0xA8, 0x0C, 0x0F, 0x0A, 0x50, 0xA8, 0x0C, 0x0F, 0x0A, 0x50, 0xAC,
  0x81, 0xD1, 0xAF, 0xFF, 0xF9, 0x0A, 0x50, 0xAC, 0x0D, 0x01, 0x20, 0xAF, 0xFF, 0xE0, 0xA5, 0x0A,
  0xD0, 0x24, 0x0A, 0xE0, 0x7F, 0xFC, 0x0A, 0x50, 0xAE, 0x0A, 0x50, 0xAC, 0x07, 0x1F, 0xFB, 0x0A,
  0x50, 0xAF, 0x90, 0xA5, 0x0A, 0xA0, 0x72, 0xFF, 0xA0, 0xA5, 0x0A, 0xFB, 0x0A, 0x50, 0xA0, 0x73,
  0xFF, 0x90, 0xA5, 0x0A, 0xFD, 0x0A, 0x72, 0xFF, 0x0A, 0x50, 0xAF, 0xF0, 0xA7, 0x1F, 0xE0, 0xA5,
  0x0A, 0xFF, 0xA0, 0xA7, 0xFD, 0x0A, 0x50, 0xAF, 0xFB, 0x07, 0x7F, 0xD0, 0x54, 0x0A, 0xFF, 0xB0,
  0x77, 0x1F, 0xE0, 0x52, 0x0A, 0xFF, 0xB0, 0x77, 0x2F, 0xF0, 0x50, 0xAF, 0xFB, 0x07, 0x73, 0x80,
  0x9B, 0x2F, 0x0D, 0x80, 0xC6, 0xF0, 0xD0, 0xA8, 0x0C, 0x6F, 0x81, 0xA1, 0xE8, 0x0C, 0x4F, 0x84,
  0xE1, 0x01, 0xAD, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_shuffle_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 45, 45), Box(0, 0, 47, 47),
      ic_filled_48_av_shuffle_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_shuffle 48x48, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_filled_48_av_shuffle_data[] PROGMEM = {
  0x20, 0xA0, 0x57, 0x73, 0x07, 0xFB, 0x10, 0xAA, 0x05, 0x77, 0x30, 0x7F, 0xA0, 0xAC, 0x05, 0x77,
  0x30, 0x7F, 0x90, 0x5D, 0x05, 0x77, 0x30, 0x7F, 0x10, 0x5D, 0x05, 0x77, 0x20, 0x5F, 0x20, 0x5D,
  0x05, 0x77, 0x05, 0xF9, 0x30, 0x5D, 0x05, 0x75, 0x05, 0xFA, 0x40, 0x5D, 0x05, 0x73, 0x05, 0xD0,
  0x50, 0x7B, 0x50, 0x5D, 0x05, 0x71, 0x05, 0xD0, 0x52, 0x07, 0xA6, 0x05, 0xD0, 0x56, 0x05, 0xD0,
  0x54, 0x07, 0x97, 0x05, 0xC0, 0xD5, 0x05, 0xD0, 0x56, 0x07, 0x71, 0x05, 0xA0, 0xD0, 0x24, 0x05,
  0xD0, 0x57, 0x73, 0x81, 0x5D, 0x14, 0x05, 0xD0, 0x57, 0x77, 0x30, 0x5D, 0x05, 0x77, 0x73, 0x05,
  0xD0, 0x57, 0x77, 0x30, 0x5D, 0x05, 0x77, 0x73, 0x05, 0xD0, 0x57, 0x77, 0x30, 0x5D, 0x05, 0x77,
  0x73, 0x05, 0xD0, 0x57, 0x77, 0x30, 0x5D, 0x05, 0x48, 0x12, 0xD5, 0x77, 0x30, 0x5D, 0x05, 0x40,
  0x20, 0xDA, 0x05, 0x77, 0x10, 0x5D, 0x05, 0x50, 0xDC, 0x05, 0x60, 0x76, 0x05, 0xD0, 0x56, 0x04,
  0xD0, 0x54, 0x07, 0x95, 0x05, 0xD0, 0x57, 0x10, 0x4D, 0x05, 0x20, 0x7A, 0x40, 0x5D, 0x05, 0x73,
  0x04, 0xD0, 0x50, 0x7B, 0x30, 0x5D, 0x05, 0x75, 0x04, 0xFA, 0x20, 0x5D, 0x05, 0x77, 0x04, 0xF9,
  0x10, 0x5D, 0x05, 0x77, 0x20, 0x4F, 0x05, 0xD0, 0x57, 0x73, 0x07, 0xF0, 0xAC, 0x05, 0x77, 0x30,
  0x7F, 0x91, 0x0A, 0xA0, 0x57, 0x73, 0x07, 0xFA, 0x20, 0xA0, 0x57, 0x73, 0x07, 0xFB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_shuffle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 8, 39, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_shuffle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_skip_next 48x48, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_48_av_skip_next_data[] PROGMEM = {
  0x0A, 0x77, 0x5D, 0x0D, 0x03, 0x77, 0x3F, 0x08, 0x77, 0x2F, 0x90, 0xC0, 0x27, 0x7F, 0xA0, 0xE0,
  0x67, 0x6F, 0xC0, 0xA0, 0x17, 0x4F, 0xD0, 0xE0, 0x47, 0x3F, 0xF0, 0x97, 0x2F, 0xF9, 0x0D, 0x03,
  0x7F, 0xFB, 0x07, 0x6F, 0xFC, 0x0B, 0x01, 0x4F, 0xFD, 0x0E, 0x05, 0x3F, 0xFD, 0x0E, 0x05, 0x3F,
  0xFC, 0x0B, 0x01, 0x4F, 0xFB, 0x07, 0x6F, 0xF9, 0x0D, 0x03, 0x7F, 0xF0, 0x97, 0x2F, 0xD0, 0xE0,
  0x47, 0x3F, 0xC0, 0xA0, 0x17, 0x4F, 0xA0, 0xE0, 0x67, 0x6F, 0x90, 0xC0, 0x27, 0x7F, 0x08, 0x77,
  0x2D, 0x0D, 0x03, 0x77, 0x3C, 0x0A, 0x77, 0x5C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_skip_next() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 12, 35, 35), Box(0, 0, 47, 47),
      ic_filled_48_av_skip_next_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_skip_previous 48x48, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_48_av_skip_previous_data[] PROGMEM = {
  0xC7, 0x75, 0x0A, 0xC7, 0x73, 0x03, 0x0D, 0xD7, 0x72, 0x08, 0xF7, 0x70, 0x20, 0xCF, 0x97, 0x60,
  0x60, 0xEF, 0xA7, 0x40, 0x10, 0xAF, 0xC7, 0x30, 0x40, 0xEF, 0xD7, 0x20, 0x9F, 0xF7, 0x03, 0x0D,
  0xFF, 0x96, 0x07, 0xFF, 0xB4, 0x01, 0x0B, 0xFF, 0xC3, 0x05, 0x0E, 0xFF, 0xD3, 0x05, 0x0E, 0xFF,
  0xD4, 0x01, 0x0B, 0xFF, 0xC6, 0x07, 0xFF, 0xB7, 0x03, 0x0D, 0xFF, 0x97, 0x20, 0x9F, 0xF7, 0x30,
  0x40, 0xEF, 0xD7, 0x40, 0x10, 0xAF, 0xC7, 0x60, 0x60, 0xEF, 0xA7, 0x70, 0x20, 0xCF, 0x97, 0x72,
  0x08, 0xF7, 0x73, 0x03, 0x0D, 0xD7, 0x75, 0x0A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_skip_previous() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 12, 35, 35), Box(0, 0, 47, 47),
      ic_filled_48_av_skip_previous_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_slow_motion_video 48x48, 4-bit Alpha,  RLE, 357 bytes.
static const unsigned char ic_filled_48_av_slow_motion_video_data[] PROGMEM = {
  0x77, 0x82, 0x37, 0x9C, 0x48, 0x2B, 0x96, 0x37, 0x77, 0x48, 0x11, 0x7D, 0xC4, 0x0D, 0xB8, 0x1D,
  0x71, 0x77, 0x68, 0x11, 0x8E, 0xE4, 0x0D, 0xE0, 0x87, 0x74, 0x04, 0x0E, 0xF9, 0x40, 0xDF, 0x0D,
  0x04, 0x77, 0x10, 0x5F, 0x81, 0xA6, 0x34, 0x82, 0x37, 0xAE, 0xE0, 0x87, 0x71, 0x0A, 0xB0, 0xD0,
  0x67, 0x48, 0x11, 0x7D, 0xD0, 0x97, 0x71, 0x81, 0xAF, 0x77, 0x72, 0x08, 0xD0, 0xA7, 0x20, 0x55,
  0x02, 0x77, 0x40, 0x30, 0xDC, 0x08, 0x78, 0x14, 0xFA, 0x77, 0x73, 0x01, 0x0D, 0xC0, 0x45, 0x01,
  0x0E, 0xA0, 0xA7, 0x77, 0x30, 0x10, 0xDB, 0x0E, 0x01, 0x40, 0x8C, 0x02, 0x77, 0x73, 0x03, 0xC0,
  0x83, 0x01, 0x0E, 0xB0, 0x77, 0x20, 0x97, 0x72, 0x07, 0xB0, 0xE0, 0x12, 0x07, 0xB0, 0xD7, 0x39,
  0x0C, 0x02, 0x77, 0x10, 0xDB, 0x07, 0x20, 0xDB, 0x06, 0x73, 0xA0, 0xE0, 0x57, 0x70, 0x6B, 0x81,
  0xD0, 0x3C, 0x74, 0xC0, 0x97, 0x70, 0xEB, 0x02, 0x07, 0xB0, 0xA7, 0x4D, 0x0C, 0x02, 0x75, 0x0B,
  0xB0, 0x60, 0x9B, 0x06, 0x74, 0xE0, 0xE0, 0x57, 0x40, 0x6B, 0x0A, 0x0C, 0xB0, 0x37, 0x4F, 0x90,
  0x97, 0x30, 0x3B, 0x0B, 0x77, 0x2F, 0xA0, 0xC0, 0x27, 0x10, 0x2B, 0x0D, 0x77, 0x2F, 0xB0, 0xE0,
  0x57, 0x1B, 0x0E, 0x77, 0x2F, 0xB0, 0xE0, 0x57, 0x1B, 0x0E, 0x77, 0x2F, 0xA0, 0xC0, 0x27, 0x10,
  0x2B, 0x0D, 0x0C, 0xB0, 0x37, 0x4F, 0x90, 0x97, 0x30, 0x3B, 0x0B, 0x09, 0xB0, 0x67, 0x4E, 0x0E,
  0x05, 0x74, 0x06, 0xB0, 0xA0, 0x7B, 0x0A, 0x74, 0xD0, 0xC0, 0x27, 0x50, 0xBB, 0x06, 0x03, 0xC7,
  0x4C, 0x09, 0x77, 0x0E, 0xB8, 0x12, 0x0D, 0xB0, 0x67, 0x3A, 0x0E, 0x05, 0x77, 0x06, 0xB0, 0xD2,
  0x07, 0xB0, 0xD7, 0x39, 0x0C, 0x02, 0x77, 0x10, 0xDB, 0x07, 0x20, 0x10, 0xEB, 0x07, 0x72, 0x09,
  0x77, 0x20, 0x7B, 0x0E, 0x01, 0x30, 0x8C, 0x02, 0x77, 0x73, 0x03, 0xC0, 0x84, 0x01, 0x0E, 0xA0,
  0xA7, 0x77, 0x30, 0x10, 0xDB, 0x0E, 0x01, 0x58, 0x14, 0xFA, 0x77, 0x73, 0x01, 0x0D, 0xC0, 0x47,
  0x05, 0x50, 0x27, 0x74, 0x03, 0x0D, 0xC0, 0x87, 0x68, 0x1A, 0xF7, 0x77, 0x20, 0x8D, 0x0A, 0x76,
  0x0A, 0xB0, 0xD0, 0x67, 0x48, 0x11, 0x7D, 0xD0, 0x97, 0x60, 0x5F, 0x81, 0xA6, 0x34, 0x82, 0x37,
  0xAE, 0xE0, 0x87, 0x71, 0x04, 0x0E, 0xF9, 0x40, 0xDF, 0x0D, 0x04, 0x77, 0x38, 0x11, 0x8E, 0xE4,
  0x0D, 0xE0, 0x87, 0x77, 0x81, 0x17, 0xDC, 0x40, 0xDB, 0x81, 0xD7, 0x17, 0x77, 0x48, 0x22, 0x79,
  0xC4, 0x82, 0xB9, 0x63, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_slow_motion_video() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_slow_motion_video_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_snooze 48x48, 4-bit Alpha,  RLE, 396 bytes.
static const unsigned char ic_filled_48_av_snooze_data[] PROGMEM = {
  0x72, 0x01, 0x77, 0x60, 0x17, 0x73, 0x0A, 0x0C, 0x77, 0x60, 0xC0, 0xA7, 0x70, 0x10, 0xCA, 0x0A,
  0x77, 0x40, 0xAA, 0x0C, 0x01, 0x74, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0x07, 0xC0, 0xD0, 0x37, 0x20,
  0x50, 0xEC, 0x0C, 0x01, 0x77, 0x20, 0x10, 0xCC, 0x0E, 0x05, 0x70, 0x7D, 0x0A, 0x48, 0x92, 0x15,
  0x9B, 0xDE, 0xED, 0xB9, 0x51, 0x40, 0xAD, 0x07, 0x50, 0xAD, 0x07, 0x30, 0x40, 0xBF, 0xD0, 0xB0,
  0x43, 0x08, 0xD0, 0xA2, 0x01, 0x0C, 0xD0, 0x52, 0x03, 0x0B, 0xFF, 0xA0, 0xB0, 0x32, 0x05, 0xD8,
  0x1C, 0x1B, 0xC0, 0xE0, 0x32, 0x08, 0xFF, 0xE0, 0x82, 0x03, 0x0E, 0xC8, 0x1B, 0x2E, 0xA8, 0x3C,
  0x10, 0x1B, 0xE8, 0x2C, 0x74, 0x22, 0x82, 0x24, 0x7C, 0xE8, 0x3B, 0x10, 0x2C, 0xA8, 0x4E, 0x20,
  0x4F, 0xA2, 0x01, 0x0C, 0xD0, 0xA0, 0x27, 0x30, 0x20, 0xAD, 0x0C, 0x01, 0x28, 0x1B, 0xF4, 0x30,
  0x33, 0x0B, 0xC0, 0xD0, 0x37, 0x70, 0x30, 0xDC, 0x0B, 0x30, 0x37, 0x08, 0xC0, 0xB0, 0x17, 0x72,
  0x01, 0x0B, 0xC0, 0x87, 0x20, 0x3C, 0x0B, 0x77, 0x60, 0xBC, 0x03, 0x71, 0x0B, 0xB0, 0xD0, 0x17,
  0x76, 0x01, 0x0D, 0xB0, 0xB7, 0x04, 0xC0, 0x35, 0xFD, 0x50, 0x3C, 0x04, 0x60, 0xBB, 0x0A, 0x6F,
  0xD6, 0x0A, 0xB0, 0xB5, 0x01, 0xC0, 0x26, 0xFD, 0x60, 0x2C, 0x01, 0x40, 0x5B, 0x0C, 0x7F, 0xC0,
  0xE7, 0x0C, 0xB0, 0x54, 0x09, 0xB0, 0x77, 0x60, 0x30, 0xEB, 0x03, 0x70, 0x7B, 0x09, 0x40, 0xBB,
  0x03, 0x75, 0x01, 0x0E, 0xB0, 0x57, 0x10, 0x3B, 0x0B, 0x40, 0xDB, 0x02, 0x74, 0x01, 0x0C, 0xB0,
  0x77, 0x20, 0x2B, 0x0D, 0x40, 0xEB, 0x75, 0x0B, 0xB0, 0x97, 0x4B, 0x0E, 0x40, 0xEB, 0x74, 0x09,
  0xB0, 0xB7, 0x5B, 0x0E, 0x40, 0xDB, 0x02, 0x72, 0x07, 0xB0, 0xC0, 0x17, 0x40, 0x2B, 0x0D, 0x40,
  0xBB, 0x03, 0x71, 0x05, 0xB0, 0xE0, 0x17, 0x50, 0x3B, 0x0B, 0x40, 0x9B, 0x07, 0x70, 0x3B, 0x0E,
  0x03, 0x76, 0x07, 0xB0, 0x94, 0x05, 0xB0, 0xC7, 0x0E, 0xFC, 0x70, 0xCB, 0x05, 0x40, 0x1C, 0x02,
  0x6F, 0xD6, 0x02, 0xC0, 0x15, 0x0B, 0xB0, 0xA6, 0xFD, 0x60, 0xAB, 0x0B, 0x60, 0x4C, 0x03, 0x5F,
  0xD5, 0x03, 0xC0, 0x47, 0x0C, 0xB0, 0xD0, 0x17, 0x76, 0x01, 0x0D, 0xB0, 0xB7, 0x10, 0x3C, 0x0B,
  0x77, 0x60, 0xBC, 0x03, 0x72, 0x08, 0xC0, 0xB0, 0x17, 0x72, 0x01, 0x0B, 0xC0, 0x87, 0x40, 0xBC,
  0x0D, 0x03, 0x77, 0x03, 0x0D, 0xC0, 0xB7, 0x50, 0x10, 0xDD, 0x0A, 0x02, 0x73, 0x02, 0x0A, 0xD0,
  0xC0, 0x17, 0x60, 0x10, 0xBE, 0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xCE, 0x0B, 0x01, 0x77, 0x20,
  0x8F, 0xFE, 0x08, 0x77, 0x50, 0x30, 0xCF, 0xFA, 0x0B, 0x03, 0x77, 0x71, 0x05, 0x0B, 0xFD, 0x0B,
  0x04, 0x77, 0x75, 0x89, 0x21, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x17, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_snooze() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_snooze_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_sort_by_alpha 48x48, 4-bit Alpha,  RLE, 313 bytes.
static const unsigned char ic_filled_48_av_sort_by_alpha_data[] PROGMEM = {
  0x77, 0x71, 0x02, 0x80, 0xC3, 0x08, 0x1B, 0xD2, 0x80, 0xC1, 0x00, 0xBA, 0x0D, 0x02, 0x77, 0x77,
  0x70, 0xBC, 0x0D, 0x02, 0x77, 0x77, 0x50, 0xBE, 0x0D, 0x02, 0x77, 0x77, 0x30, 0x28, 0x04, 0x50,
  0x48, 0x09, 0xC5, 0x08, 0x26, 0x77, 0x47, 0x30, 0x28, 0x09, 0x47, 0x02, 0x71, 0x02, 0xB0, 0xD7,
  0x30, 0x4F, 0xFA, 0x04, 0x71, 0x08, 0xC0, 0x37, 0x20, 0x4F, 0xFA, 0x04, 0x71, 0x0E, 0xC0, 0x97,
  0x20, 0x38, 0x07, 0xB0, 0xDB, 0x0E, 0x01, 0x70, 0x5D, 0x0E, 0x01, 0x77, 0x50, 0x10, 0xEB, 0x05,
  0x71, 0x0B, 0xA0, 0x90, 0xEA, 0x06, 0x77, 0x50, 0xBB, 0x0A, 0x71, 0x02, 0xB0, 0x30, 0x9A, 0x0C,
  0x77, 0x40, 0x6B, 0x0D, 0x01, 0x71, 0x08, 0xA8, 0x1D, 0x03, 0xB0, 0x37, 0x72, 0x02, 0x0E, 0xB0,
  0x47, 0x20, 0xEA, 0x07, 0x20, 0xDA, 0x09, 0x77, 0x20, 0xCB, 0x09, 0x72, 0x04, 0xB0, 0x12, 0x07,
  0xA0, 0xE7, 0x71, 0x07, 0xB0, 0xD7, 0x30, 0xBA, 0x0B, 0x30, 0x1B, 0x05, 0x76, 0x03, 0xC0, 0x37,
  0x20, 0x1B, 0x05, 0x40, 0xBA, 0x0B, 0x76, 0x0D, 0xB0, 0x77, 0x30, 0x7A, 0x0E, 0x50, 0x5B, 0x02,
  0x74, 0x08, 0xB0, 0xC7, 0x40, 0xDA, 0x09, 0x60, 0xEA, 0x08, 0x73, 0x04, 0xC0, 0x27, 0x30, 0x4B,
  0x03, 0x60, 0x9A, 0x0E, 0x73, 0x0D, 0xB0, 0x67, 0x40, 0xAB, 0x80, 0x3B, 0x0D, 0xB0, 0x57, 0x10,
  0x9B, 0x0B, 0x74, 0x01, 0xFF, 0x90, 0xB7, 0x05, 0xB0, 0xE0, 0x17, 0x40, 0x7F, 0xFA, 0x02, 0x50,
  0x10, 0xEB, 0x05, 0x75, 0x0D, 0xA0, 0xC8, 0x06, 0x7B, 0x07, 0x50, 0xBB, 0x0A, 0x75, 0x03, 0xB0,
  0x57, 0x30, 0xAA, 0x0D, 0x40, 0x6B, 0x0E, 0x01, 0x75, 0x09, 0xA0, 0xE7, 0x40, 0x5B, 0x04, 0x20,
  0x20, 0xEB, 0x0D, 0x80, 0x7B, 0x81, 0x81, 0xEA, 0x09, 0x75, 0x0E, 0xA0, 0xA2, 0x05, 0xFF, 0xA0,
  0xA0, 0x6B, 0x03, 0x75, 0x09, 0xB8, 0x11, 0x05, 0xFF, 0xA0, 0xA0, 0x50, 0xF7, 0x76, 0x85, 0x27,
  0x77, 0x20, 0x28, 0x09, 0x47, 0x05, 0x80, 0x9B, 0x70, 0x01, 0x80, 0x43, 0x02, 0x77, 0x77, 0x40,
  0xBE, 0x0D, 0x02, 0x77, 0x77, 0x50, 0xBC, 0x0D, 0x02, 0x77, 0x77, 0x70, 0xBA, 0x0D, 0x02, 0x80,
  0xC1, 0x08, 0x1B, 0xD2, 0x80, 0xC3, 0x00, 0x27, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_sort_by_alpha() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_sort_by_alpha_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_speed 48x48, 4-bit Alpha,  RLE, 287 bytes.
static const unsigned char ic_filled_48_av_speed_data[] PROGMEM = {
  0x77, 0x89, 0x21, 0x58, 0xAD, 0xDD, 0xDB, 0x86, 0x17, 0x77, 0x50, 0x60, 0xBF, 0xD8, 0x1C, 0x71,
  0x77, 0x70, 0x60, 0xEF, 0xFA, 0x0E, 0x07, 0x77, 0x40, 0x30, 0xDF, 0xFE, 0x06, 0x77, 0x20, 0x6E,
  0x83, 0xEA, 0x63, 0x12, 0x83, 0x13, 0x6A, 0xEA, 0x0C, 0x02, 0x77, 0x20, 0x9D, 0x0D, 0x06, 0x74,
  0x81, 0x16, 0x77, 0x73, 0x08, 0xD0, 0x77, 0x76, 0x01, 0x06, 0x73, 0x06, 0xC0, 0xD0, 0x27, 0x76,
  0x81, 0x5D, 0x17, 0x20, 0x3C, 0x0C, 0x01, 0x77, 0x58, 0x21, 0xBF, 0x57, 0x30, 0xCB, 0x0D, 0x01,
  0x77, 0x58, 0x25, 0xEF, 0xB4, 0x06, 0x01, 0x40, 0x7C, 0x03, 0x77, 0x40, 0x10, 0xBA, 0x0E, 0x01,
  0x38, 0x12, 0xF8, 0x40, 0xEB, 0x07, 0x77, 0x40, 0x50, 0xEB, 0x05, 0x40, 0xCA, 0x01, 0x20, 0x5B,
  0x0D, 0x77, 0x30, 0x10, 0xBC, 0x0B, 0x40, 0x7B, 0x07, 0x20, 0xCB, 0x06, 0x77, 0x20, 0x50, 0xEC,
  0x0E, 0x01, 0x40, 0x6B, 0x81, 0xD0, 0x1C, 0x01, 0x77, 0x01, 0x0B, 0xE0, 0x56, 0x0E, 0xB0, 0x30,
  0x5B, 0x0A, 0x77, 0x05, 0x0E, 0xE0, 0xB7, 0x0A, 0xB0, 0x60, 0x8B, 0x06, 0x75, 0x01, 0x0B, 0xF0,
  0xE0, 0x17, 0x06, 0xB0, 0xA0, 0xBB, 0x03, 0x74, 0x02, 0x0E, 0xF9, 0x05, 0x71, 0x03, 0xB0, 0x0C,
  0xB0, 0x17, 0x40, 0xAF, 0x90, 0xB7, 0x20, 0x1B, 0x00, 0xDB, 0x75, 0x0D, 0xF0, 0xE0, 0x17, 0x3C,
  0x0E, 0xB7, 0x50, 0xDF, 0x05, 0x74, 0xB0, 0xE0, 0xCB, 0x01, 0x74, 0x09, 0xE0, 0xB7, 0x40, 0x1B,
  0x0E, 0x0B, 0xB0, 0x37, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x74, 0x03, 0xB0, 0xC0, 0x9B, 0x06, 0x75,
  0x84, 0x2A, 0xDD, 0xA1, 0x75, 0x06, 0xB0, 0x90, 0x6B, 0x0A, 0x77, 0x77, 0x20, 0xAB, 0x07, 0x01,
  0xB0, 0xE7, 0x77, 0x72, 0x0E, 0xB8, 0x13, 0x0D, 0xB0, 0x67, 0x77, 0x70, 0x6B, 0x0D, 0x20, 0x7B,
  0x0D, 0x77, 0x77, 0x0D, 0xB0, 0x83, 0x0E, 0xFF, 0xFF, 0xE0, 0xE0, 0x13, 0x08, 0xFF, 0xFF, 0xE0,
  0x85, 0x0D, 0xFF, 0xFF, 0xC0, 0xD0, 0x15, 0x81, 0x19, 0xEF, 0xFF, 0xF8, 0x1E, 0x91, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_speed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_speed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_stop_circle 48x48, 4-bit Alpha,  RLE, 234 bytes.
static const unsigned char ic_filled_48_av_stop_circle_data[] PROGMEM = {
  0x77, 0x83, 0x37, 0xAC, 0xDA, 0x83, 0xDC, 0xA7, 0x37, 0x77, 0x48, 0x11, 0x8D, 0xFD, 0x81, 0xD8,
  0x17, 0x76, 0x01, 0x09, 0xFF, 0xC0, 0x90, 0x17, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0xE0, 0x57, 0x71,
  0x09, 0xFF, 0xFB, 0x09, 0x76, 0x0A, 0xFF, 0xFD, 0x0A, 0x74, 0x0A, 0xFF, 0xFF, 0x0A, 0x72, 0x09,
  0xFF, 0xFF, 0xA0, 0x97, 0x05, 0xFF, 0xFF, 0xC0, 0x55, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0xE0, 0x14,
  0x09, 0xFF, 0xFF, 0xE0, 0x93, 0x01, 0x80, 0xC0, 0xF0, 0x12, 0x08, 0xFB, 0x77, 0x2F, 0xB0, 0x82,
  0x0D, 0xFB, 0x77, 0x2F, 0xB8, 0x1D, 0x03, 0xFC, 0x77, 0x2F, 0xC0, 0x30, 0x7F, 0xC7, 0x72, 0xFC,
  0x07, 0x0A, 0xFC, 0x77, 0x2F, 0xC0, 0xA0, 0xCF, 0xC7, 0x72, 0xFC, 0x0C, 0x0E, 0xFC, 0x77, 0x2F,
  0xC0, 0xEF, 0xD7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xD0, 0xEF, 0xC7, 0x72, 0xFC, 0x0E, 0x0C, 0xFC,
  0x77, 0x2F, 0xC0, 0xC0, 0xAF, 0xC7, 0x72, 0xFC, 0x0A, 0x07, 0xFC, 0x77, 0x2F, 0xC0, 0x70, 0x3F,
  0xC7, 0x72, 0xFC, 0x81, 0x30, 0xDF, 0xB7, 0x72, 0xFB, 0x0D, 0x20, 0x8F, 0xB7, 0x72, 0xFB, 0x08,
  0x20, 0x18, 0x0C, 0x0F, 0x01, 0x30, 0x9F, 0xFF, 0xFE, 0x09, 0x40, 0x10, 0xEF, 0xFF, 0xFC, 0x0E,
  0x01, 0x50, 0x5F, 0xFF, 0xFC, 0x05, 0x70, 0x9F, 0xFF, 0xFA, 0x09, 0x72, 0x0A, 0xFF, 0xFF, 0x0A,
  0x74, 0x0A, 0xFF, 0xFD, 0x0A, 0x76, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x10, 0x50, 0xEF, 0xFE, 0x0E,
  0x05, 0x77, 0x30, 0x10, 0x9F, 0xFC, 0x09, 0x01, 0x77, 0x68, 0x11, 0x8D, 0xFD, 0x81, 0xD8, 0x17,
  0x77, 0x48, 0x33, 0x7A, 0xCD, 0xA8, 0x3D, 0xCA, 0x73, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_stop_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_stop_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_stop 48x48, 4-bit Alpha,  RLE, 4 bytes.
static const unsigned char ic_filled_48_av_stop_data[] PROGMEM = {
  0x80, 0x98, 0xF4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 12, 35, 35), Box(0, 0, 47, 47),
      ic_filled_48_av_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_subscriptions 48x48, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_filled_48_av_subscriptions_data[] PROGMEM = {
  0x71, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB7, 0x72, 0xFF, 0xFB, 0x77, 0x2F, 0xFF, 0xB8, 0x0A, 0xD0,
  0x0F, 0xFF, 0xFC, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF, 0xFC, 0x71, 0xFF, 0xFF, 0xC8, 0x0A, 0xC1,
  0x08, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0E, 0x4F, 0x0B, 0x80, 0xC3, 0xF1, 0x04, 0x0C, 0x80,
  0xC1, 0xF3, 0x05, 0x0D, 0xFF, 0xFF, 0xF5, 0x07, 0x0E, 0xFF, 0xFF, 0xD6, 0x01, 0x08, 0xFF, 0xFF,
  0xC7, 0x10, 0x10, 0x9F, 0xFF, 0xFA, 0x73, 0x02, 0x0B, 0xFF, 0xFF, 0x73, 0x02, 0x0B, 0xFF, 0xFF,
  0x71, 0x01, 0x09, 0xFF, 0xFF, 0xA6, 0x01, 0x08, 0xFF, 0xFF, 0xC5, 0x07, 0x0E, 0xFF, 0xFF, 0xD3,
  0x05, 0x0D, 0xFF, 0xFF, 0xF1, 0x04, 0x0C, 0x80, 0xC1, 0xF0, 0xB8, 0x0F, 0x3F, 0x0D, 0x80, 0xC2,
  0xF0, 0xD0, 0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF,
  0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_subscriptions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_subscriptions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_subtitles 48x48, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_48_av_subtitles_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0F, 0xC0, 0xF7, 0x1C, 0x77, 0x6F, 0x97, 0x1C, 0x77,
  0x6F, 0x97, 0x1C, 0x77, 0x6F, 0x97, 0x1C, 0x77, 0x68, 0x0A, 0xC4, 0xF7, 0x76, 0xC7, 0x1F, 0x97,
  0x76, 0xC7, 0x1F, 0x97, 0x76, 0xC7, 0x1F, 0x97, 0x76, 0xC7, 0x1C, 0x0D, 0x80, 0xC2, 0xF0, 0xD0,
  0xA8, 0x0C, 0x2F, 0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D,
  0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_subtitles() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_subtitles_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_surround_sound 48x48, 4-bit Alpha,  RLE, 286 bytes.
static const unsigned char ic_filled_48_av_surround_sound_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0xA8, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xDF, 0x90, 0xEF, 0xFF, 0x90, 0xEF, 0xF9, 0x81, 0xD1, 0x7F,
  0xFE, 0x81, 0x71, 0xEF, 0xF0, 0x32, 0x07, 0xFF, 0xC0, 0x72, 0x03, 0xFE, 0x07, 0x40, 0xBF, 0xFA,
  0x0B, 0x40, 0x7F, 0xC0, 0xD4, 0x04, 0xD8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xD0, 0x44, 0x0E, 0xFB,
  0x06, 0x30, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x13, 0x06, 0xFB, 0x40, 0x9C, 0x04, 0x73,
  0x04, 0xC0, 0x94, 0xFA, 0x0B, 0x30, 0x1C, 0x06, 0x75, 0x06, 0xC0, 0x13, 0x0B, 0xF9, 0x06, 0x30,
  0x6B, 0x0C, 0x48, 0x41, 0xAD, 0xDA, 0x14, 0x0C, 0xB0, 0x63, 0x06, 0xF9, 0x03, 0x30, 0xBB, 0x06,
  0x30, 0x10, 0xEC, 0x0E, 0x01, 0x30, 0x6B, 0x0B, 0x30, 0x3F, 0x90, 0x23, 0x0D, 0xB0, 0x23, 0x0A,
  0xE0, 0xA3, 0x02, 0xB0, 0xD3, 0x02, 0xF9, 0x40, 0xEB, 0x40, 0xDE, 0x0D, 0x4B, 0x0E, 0x4F, 0x94,
  0x0E, 0xB4, 0x0D, 0xE0, 0xD4, 0xB0, 0xE4, 0xF9, 0x02, 0x30, 0xDB, 0x02, 0x30, 0xAE, 0x0A, 0x30,
  0x2B, 0x0D, 0x30, 0x2F, 0x90, 0x33, 0x0B, 0xB0, 0x63, 0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x06, 0xB0,
  0xB3, 0x03, 0xF9, 0x06, 0x30, 0x6B, 0x0C, 0x48, 0x41, 0xAD, 0xDA, 0x14, 0x0C, 0xB0, 0x63, 0x06,
  0xF9, 0x0B, 0x30, 0x1C, 0x06, 0x75, 0x06, 0xC0, 0x13, 0x0B, 0xFA, 0x40, 0x9C, 0x04, 0x73, 0x04,
  0xC0, 0x94, 0xFB, 0x06, 0x30, 0x10, 0xEC, 0x06, 0x71, 0x06, 0xC0, 0xE0, 0x13, 0x06, 0xFB, 0x0E,
  0x40, 0x4D, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCD, 0x04, 0x40, 0xDF, 0xC0, 0x74, 0x0B, 0xFF, 0xA0,
  0xB4, 0x07, 0xFE, 0x03, 0x20, 0x7F, 0xFC, 0x07, 0x20, 0x3F, 0xF8, 0x1E, 0x17, 0xFF, 0xE8, 0x17,
  0x1D, 0xFF, 0x90, 0xEF, 0xFF, 0x90, 0xEF, 0x90, 0xD8, 0x0C, 0x2F, 0x0D, 0x0A, 0x80, 0xC2, 0xF8,
  0x1A, 0x1E, 0x80, 0xC0, 0xF8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xFC, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_surround_sound() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_surround_sound_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_video_call 48x48, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_filled_48_av_video_call_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x70, 0x7F, 0xFF, 0xF6, 0x07,
  0xFF, 0xFF, 0x95, 0x07, 0xFF, 0x4F, 0xD4, 0x07, 0xFF, 0x94, 0xFD, 0x30, 0x7F, 0xFA, 0x4F, 0xD2,
  0x07, 0xFF, 0xB4, 0xFD, 0x10, 0x7F, 0xFC, 0x4F, 0xD0, 0x7F, 0xFD, 0x4F, 0xFF, 0xD7, 0x72, 0xFF,
  0xE7, 0x72, 0xFF, 0xE7, 0x72, 0xFF, 0xE7, 0x72, 0xFF, 0xFD, 0x4F, 0xFF, 0xFC, 0x4F, 0xD0, 0x7F,
  0xFD, 0x4F, 0xD1, 0x07, 0xFF, 0xC4, 0xFD, 0x20, 0x7F, 0xFB, 0x4F, 0xD3, 0x07, 0xFF, 0xA4, 0xFD,
  0x40, 0x7F, 0xFF, 0xFB, 0x50, 0x7F, 0xFF, 0xFA, 0x68, 0x17, 0xFD, 0xFF, 0xFD, 0x0D, 0x78, 0x17,
  0x4D, 0xFF, 0xFB, 0x0D, 0x04, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_video_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 41, 35), Box(0, 0, 47, 47),
      ic_filled_48_av_video_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_videocam_off 48x48, 4-bit Alpha,  RLE, 288 bytes.
static const unsigned char ic_filled_48_av_videocam_off_data[] PROGMEM = {
  0x18, 0x11, 0xB2, 0x77, 0x77, 0x68, 0x31, 0xDF, 0xD2, 0x77, 0x77, 0x50, 0xBB, 0x0D, 0x02, 0x77,
  0x77, 0x40, 0x20, 0xDB, 0x0D, 0x02, 0x77, 0x77, 0x40, 0x20, 0xDB, 0x0D, 0x02, 0x77, 0x77, 0x40,
  0x20, 0xDB, 0x0D, 0x02, 0x77, 0x77, 0x40, 0x20, 0xDB, 0x0D, 0x02, 0x77, 0x77, 0x40, 0x20, 0xDB,
  0x0D, 0x02, 0x77, 0x77, 0x10, 0x40, 0xDE, 0x0D, 0x02, 0x30, 0x10, 0xCF, 0xC0, 0xD0, 0x47, 0x30,
  0xDF, 0x90, 0xD0, 0x23, 0x01, 0x0C, 0xFC, 0x0D, 0x70, 0x72, 0xFB, 0x0D, 0x02, 0x30, 0x10, 0xCF,
  0xC6, 0x07, 0x92, 0xFC, 0x0D, 0x02, 0x30, 0x10, 0xCF, 0xB5, 0x07, 0xA2, 0xFD, 0x0D, 0x02, 0x30,
  0x10, 0xCF, 0xA4, 0x07, 0xB2, 0xFE, 0x0D, 0x02, 0x30, 0x10, 0xCF, 0x93, 0x07, 0xC2, 0xFF, 0x0D,
  0x02, 0x30, 0x10, 0xCF, 0x20, 0x7D, 0x2F, 0xF9, 0x0D, 0x02, 0x30, 0x10, 0xCE, 0x10, 0x7E, 0x2F,
  0xFA, 0x0D, 0x02, 0x30, 0x10, 0xCD, 0x07, 0xF2, 0xFF, 0xB0, 0xD0, 0x23, 0x01, 0x0C, 0xFD, 0x2F,
  0xFC, 0x0D, 0x02, 0x30, 0x10, 0xCF, 0xC2, 0xFF, 0xD0, 0xD0, 0x23, 0x01, 0x0C, 0xFB, 0x2F, 0xFE,
  0x0D, 0x02, 0x30, 0x10, 0xCF, 0xA2, 0xFF, 0xF0, 0xD0, 0x23, 0x01, 0x0C, 0xF9, 0x2F, 0xFF, 0x90,
  0xD0, 0x23, 0x01, 0x0C, 0xF2, 0xFF, 0xFA, 0x0D, 0x02, 0x30, 0x10, 0xCE, 0x2F, 0xFF, 0xB0, 0xD0,
  0x23, 0x01, 0x0C, 0xD2, 0xFF, 0xFC, 0x0D, 0x02, 0x30, 0x10, 0xCC, 0x2F, 0xFF, 0xD0, 0xD0, 0x23,
  0x01, 0x0C, 0xB2, 0xFF, 0xFE, 0x0D, 0x02, 0x30, 0x10, 0xCA, 0x2F, 0xFF, 0xF0, 0xD0, 0x23, 0x01,
  0x0C, 0x92, 0xFF, 0xFF, 0x90, 0xD0, 0x23, 0x01, 0x0C, 0x20, 0xDF, 0xFF, 0xF9, 0x0D, 0x02, 0x30,
  0x12, 0x04, 0x0D, 0xFF, 0xFB, 0x00, 0xDB, 0x0D, 0x02, 0x77, 0x77, 0x40, 0x20, 0xDB, 0x0D, 0x02,
  0x77, 0x77, 0x40, 0x20, 0xDB, 0x0D, 0x02, 0x77, 0x77, 0x40, 0x20, 0xDB, 0x0D, 0x02, 0x77, 0x77,
  0x40, 0x20, 0xDB, 0x0B, 0x77, 0x77, 0x58, 0x32, 0xDF, 0xD1, 0x77, 0x77, 0x68, 0x12, 0xB1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_videocam_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_videocam_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_videocam 48x48, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_filled_48_av_videocam_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xFB, 0x0D, 0x04, 0x71, 0x0D, 0xFF, 0xFD, 0x0D, 0x70, 0x7F, 0xFF, 0xF6, 0x07,
  0xFF, 0xFF, 0x95, 0x07, 0xFF, 0xFF, 0xA4, 0x07, 0xFF, 0xFF, 0xB3, 0x07, 0xFF, 0xFF, 0xC2, 0x07,
  0xFF, 0xFF, 0xD1, 0x07, 0xFF, 0xFF, 0xE0, 0x78, 0x0B, 0xE7, 0xF0, 0x7F, 0xFF, 0xFF, 0x10, 0x7F,
  0xFF, 0xFE, 0x20, 0x7F, 0xFF, 0xFD, 0x30, 0x7F, 0xFF, 0xFC, 0x40, 0x7F, 0xFF, 0xFB, 0x50, 0x7F,
  0xFF, 0xFA, 0x68, 0x17, 0xFD, 0xFF, 0xFD, 0x0D, 0x78, 0x17, 0x4D, 0xFF, 0xFB, 0x0D, 0x04, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_videocam() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 12, 41, 35), Box(0, 0, 47, 47),
      ic_filled_48_av_videocam_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_video_file 48x48, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_filled_48_av_video_file_data[] PROGMEM = {
  0x18, 0x11, 0x9D, 0xFF, 0xA0, 0x77, 0x40, 0x10, 0xEF, 0xFD, 0x07, 0x73, 0x09, 0xFF, 0xF0, 0x77,
  0x20, 0xDF, 0xFB, 0x07, 0xC0, 0x77, 0x1F, 0xFC, 0x10, 0x7C, 0x07, 0x7F, 0xFC, 0x20, 0x7C, 0x07,
  0x6F, 0xFC, 0x30, 0x7C, 0x07, 0x5F, 0xFC, 0x40, 0x7C, 0x07, 0x4F, 0xFC, 0x50, 0x7C, 0x07, 0x3F,
  0xFC, 0x60, 0x7C, 0x07, 0x2F, 0xFC, 0x70, 0x7C, 0x07, 0x1F, 0xFC, 0x71, 0x07, 0xC0, 0x7F, 0xFC,
  0x72, 0x07, 0xFF, 0xF9, 0x73, 0x07, 0x80, 0xB8, 0x7F, 0x0B, 0x01, 0x71, 0x01, 0x0B, 0xFF, 0xE0,
  0x17, 0x30, 0x1F, 0xFE, 0x75, 0xA0, 0xA0, 0x2F, 0xFA, 0x75, 0x0B, 0x03, 0x2F, 0xFA, 0x77, 0x2F,
  0xFA, 0x77, 0x2F, 0xFA, 0x77, 0x2F, 0xFA, 0x77, 0x2F, 0xFA, 0x75, 0x0B, 0x03, 0x2F, 0xFA, 0x75,
  0xA0, 0xA0, 0x2F, 0xFA, 0x01, 0x73, 0x01, 0xFF, 0xE0, 0xB0, 0x17, 0x10, 0x10, 0xB8, 0x0A, 0x90,
  0xF0, 0xDF, 0xFF, 0xFA, 0x0D, 0x0A, 0xFF, 0xFF, 0xA8, 0x1A, 0x1E, 0xFF, 0xFF, 0x84, 0xE1, 0x01,
  0xAD, 0xFF, 0xFB, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_video_file() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 4, 39, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_video_file_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_video_label 48x48, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_filled_48_av_video_label_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x4F, 0x81, 0xE1, 0xA8, 0x0C,
  0x6F, 0x0A, 0x0D, 0x80, 0xC6, 0xF0, 0xDC, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0,
  0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98,
  0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00,
  0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80,
  0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F, 0x98, 0x0C, 0x00, 0xF9, 0x80, 0xC0, 0x0F,
  0x98, 0x0C, 0x00, 0x80, 0xC9, 0x0F, 0x0D, 0x80, 0xC6, 0xF0, 0xD0, 0xA8, 0x0C, 0x6F, 0x81, 0xA1,
  0xE8, 0x0C, 0x4F, 0x84, 0xE1, 0x01, 0xAD, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_video_label() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 6, 45, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_video_label_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_video_library 48x48, 4-bit Alpha,  RLE, 197 bytes.
static const unsigned char ic_filled_48_av_video_library_data[] PROGMEM = {
  0x72, 0x81, 0x1A, 0xDF, 0xFF, 0xB8, 0x1D, 0xA1, 0x72, 0x01, 0x0E, 0xFF, 0xFF, 0x0E, 0x01, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x10, 0xDF, 0xFF, 0xFA, 0x0D, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xFF,
  0xFC, 0x71, 0xFF, 0xFF, 0xC7, 0x1F, 0xD0, 0x50, 0xEF, 0xFF, 0x94, 0xFD, 0x10, 0x20, 0xCF, 0xFF,
  0x4F, 0xD3, 0x09, 0xFF, 0xE4, 0xFD, 0x40, 0x50, 0xEF, 0xFC, 0x4F, 0xD5, 0x02, 0x0C, 0xFF, 0xB4,
  0xFD, 0x70, 0x9F, 0xFA, 0x4F, 0xD7, 0x10, 0x50, 0xEF, 0xF4, 0xFD, 0x72, 0x02, 0x0C, 0xFE, 0x4F,
  0xD7, 0x40, 0x9F, 0xD4, 0xFD, 0x74, 0x09, 0xFD, 0x4F, 0xD7, 0x20, 0x20, 0xCF, 0xE4, 0xFD, 0x71,
  0x05, 0x0E, 0xFF, 0x4F, 0xD7, 0x09, 0xFF, 0xA4, 0xFD, 0x50, 0x20, 0xCF, 0xFB, 0x4F, 0xD4, 0x05,
  0x0E, 0xFF, 0xC4, 0xFD, 0x30, 0x9F, 0xFE, 0x4F, 0xD1, 0x02, 0x0C, 0xFF, 0xF4, 0xFD, 0x05, 0x0E,
  0xFF, 0xF9, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x48, 0x0C, 0x0F, 0x40, 0xDF, 0xFF, 0xFA, 0x0D,
  0xC4, 0x0A, 0xFF, 0xFF, 0xA0, 0xAC, 0x40, 0x10, 0xEF, 0xFF, 0xF0, 0xE0, 0x1C, 0x58, 0x11, 0xAD,
  0xFF, 0xFB, 0x81, 0xDA, 0x11, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C, 0x00, 0xC8, 0x0C,
  0x00, 0x0D, 0xFF, 0xFF, 0xB7, 0x10, 0xAF, 0xFF, 0xFB, 0x71, 0x01, 0x0E, 0xFF, 0xFF, 0xA7, 0x28,
  0x11, 0xAD, 0xFF, 0xFF, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_video_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 43, 43), Box(0, 0, 47, 47),
      ic_filled_48_av_video_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_video_settings 48x48, 4-bit Alpha,  RLE, 266 bytes.
static const unsigned char ic_filled_48_av_video_settings_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0x80, 0xC0, 0xF8, 0x1D, 0xA1, 0x30, 0x10, 0xE8, 0x0C, 0x4F, 0x0E, 0x01, 0x20,
  0xA8, 0x0C, 0x6F, 0x0A, 0x20, 0xD8, 0x0C, 0x6F, 0x0D, 0x2C, 0x80, 0xC0, 0x0C, 0x2C, 0x80, 0xC0,
  0x0C, 0x2C, 0x80, 0xC0, 0x0C, 0x2C, 0x80, 0xC0, 0x0C, 0x2C, 0x75, 0x0A, 0x01, 0x77, 0x71, 0xC2,
  0xC7, 0x59, 0x0E, 0x05, 0x77, 0x7C, 0x2C, 0x75, 0xB0, 0xA0, 0x17, 0x75, 0xC2, 0xC7, 0x5C, 0x0E,
  0x05, 0x77, 0x4C, 0x2C, 0x75, 0xE0, 0xA0, 0x17, 0x72, 0xC2, 0xC7, 0x5F, 0x0E, 0x05, 0x77, 0x1C,
  0x2C, 0x75, 0xFA, 0x0A, 0x01, 0x77, 0x5C, 0x75, 0xFB, 0x0E, 0x05, 0x77, 0x4C, 0x75, 0xFB, 0x0E,
  0x05, 0x77, 0x4C, 0x75, 0xFA, 0x0A, 0x01, 0x77, 0x5C, 0x75, 0xF0, 0xE0, 0x57, 0x10, 0x8C, 0x07,
  0x7C, 0x75, 0xE0, 0xA0, 0x17, 0x20, 0xBC, 0x0B, 0x7C, 0x75, 0xC0, 0xE0, 0x57, 0x40, 0xDC, 0x0D,
  0x7C, 0x75, 0xB0, 0xA0, 0x17, 0x83, 0xCC, 0x62, 0x8E, 0x83, 0x81, 0x6C, 0xC2, 0xC7, 0x59, 0x0E,
  0x05, 0x71, 0x06, 0xFF, 0xA0, 0x51, 0xC7, 0x50, 0xA0, 0x17, 0x20, 0xEF, 0xFA, 0x0D, 0x1C, 0x77,
  0x71, 0x08, 0xFF, 0xC0, 0x8C, 0x77, 0x71, 0x06, 0xF8, 0x27, 0x11, 0x7F, 0x06, 0xC7, 0x77, 0x20,
  0x40, 0xEC, 0x07, 0x40, 0x7C, 0x0E, 0x04, 0x1C, 0x77, 0x73, 0x07, 0xC0, 0x14, 0x01, 0xC0, 0x62,
  0x0D, 0xFF, 0xF6, 0x07, 0xC0, 0x14, 0x01, 0xC0, 0x62, 0x0A, 0xFF, 0xF5, 0x04, 0x0E, 0xC0, 0x74,
  0x07, 0xC8, 0x3E, 0x40, 0x1E, 0xFF, 0xE4, 0x07, 0xF8, 0x27, 0x11, 0x7F, 0x83, 0x60, 0x1A, 0xDF,
  0xFC, 0x40, 0x8F, 0xFC, 0x07, 0x77, 0x76, 0x0E, 0xFF, 0xA0, 0xD7, 0x77, 0x70, 0x6F, 0xFA, 0x05,
  0x77, 0x77, 0x18, 0x3C, 0xC6, 0x18, 0xE8, 0x38, 0x16, 0xCB, 0x77, 0x77, 0x70, 0xDC, 0x0D, 0x80,
  0xC4, 0x00, 0xBC, 0x0A, 0x80, 0xC4, 0x00, 0x8C, 0x07, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_video_settings() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 8, 47, 45), Box(0, 0, 47, 47),
      ic_filled_48_av_video_settings_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_volume_down_alt 48x48, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_filled_48_av_volume_down_alt_data[] PROGMEM = {
  0x77, 0x30, 0x77, 0x77, 0x40, 0x79, 0x77, 0x73, 0x07, 0xA7, 0x77, 0x20, 0x7B, 0x77, 0x71, 0x07,
  0xC7, 0x77, 0x07, 0xD7, 0x76, 0x07, 0xE7, 0x75, 0x07, 0xF7, 0x74, 0x07, 0xF9, 0x40, 0xB0, 0x17,
  0x40, 0x7F, 0xA4, 0x90, 0xE0, 0x32, 0xFF, 0xC4, 0xA0, 0xE0, 0x11, 0xFF, 0xC4, 0xB0, 0xB1, 0xFF,
  0xC4, 0xC0, 0x3F, 0xFC, 0x4C, 0x09, 0xFF, 0xC4, 0xC0, 0xCF, 0xFC, 0x4C, 0x0E, 0xFF, 0xC4, 0xC0,
  0xEF, 0xFC, 0x4C, 0x0C, 0xFF, 0xC4, 0xC0, 0x9F, 0xFC, 0x4C, 0x03, 0xFF, 0xC4, 0xB0, 0xB1, 0xFF,
  0xC4, 0xA0, 0xD0, 0x17, 0x20, 0x7F, 0xA4, 0x90, 0xE0, 0x37, 0x40, 0x7F, 0x94, 0x0A, 0x01, 0x76,
  0x07, 0xF7, 0x76, 0x07, 0xE7, 0x77, 0x07, 0xD7, 0x77, 0x10, 0x7C, 0x77, 0x72, 0x07, 0xB7, 0x77,
  0x30, 0x7A, 0x77, 0x74, 0x07, 0x97, 0x77, 0x50, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_volume_down_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 32, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_volume_down_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_volume_down 48x48, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_filled_48_av_volume_down_data[] PROGMEM = {
  0x77, 0x30, 0x77, 0x77, 0x40, 0x79, 0x77, 0x73, 0x07, 0xA7, 0x77, 0x20, 0x7B, 0x77, 0x71, 0x07,
  0xC7, 0x77, 0x07, 0xD7, 0x76, 0x07, 0xE7, 0x75, 0x07, 0xF7, 0x74, 0x07, 0xF9, 0x40, 0xB0, 0x17,
  0x40, 0x7F, 0xA4, 0x90, 0xE0, 0x32, 0xFF, 0xC4, 0xA0, 0xE0, 0x11, 0xFF, 0xC4, 0xB0, 0xB1, 0xFF,
  0xC4, 0xC0, 0x3F, 0xFC, 0x4C, 0x09, 0xFF, 0xC4, 0xC0, 0xCF, 0xFC, 0x4C, 0x0E, 0xFF, 0xC4, 0xC0,
  0xEF, 0xFC, 0x4C, 0x0C, 0xFF, 0xC4, 0xC0, 0x9F, 0xFC, 0x4C, 0x03, 0xFF, 0xC4, 0xB0, 0xB1, 0xFF,
  0xC4, 0xA0, 0xD0, 0x17, 0x20, 0x7F, 0xA4, 0x90, 0xE0, 0x37, 0x40, 0x7F, 0x94, 0x0A, 0x01, 0x76,
  0x07, 0xF7, 0x76, 0x07, 0xE7, 0x77, 0x07, 0xD7, 0x77, 0x10, 0x7C, 0x77, 0x72, 0x07, 0xB7, 0x77,
  0x30, 0x7A, 0x77, 0x74, 0x07, 0x97, 0x77, 0x50, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_volume_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 8, 36, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_volume_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_volume_mute 48x48, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_filled_48_av_volume_mute_data[] PROGMEM = {
  0x77, 0x30, 0x77, 0x72, 0x07, 0x97, 0x71, 0x07, 0xA7, 0x70, 0x7B, 0x76, 0x07, 0xC7, 0x50, 0x7D,
  0x74, 0x07, 0xE7, 0x30, 0x7F, 0x72, 0x07, 0xF9, 0x71, 0x07, 0x80, 0xBB, 0x5F, 0x71, 0x07, 0xFA,
  0x72, 0x07, 0xF9, 0x73, 0x07, 0xF7, 0x40, 0x7E, 0x75, 0x07, 0xD7, 0x60, 0x7C, 0x77, 0x07, 0xB7,
  0x71, 0x07, 0xA7, 0x72, 0x07, 0x97, 0x73, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_volume_mute() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(14, 8, 31, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_volume_mute_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_volume_off 48x48, 4-bit Alpha,  RLE, 340 bytes.
static const unsigned char ic_filled_48_av_volume_off_data[] PROGMEM = {
  0x18, 0x11, 0xB2, 0x77, 0x40, 0x50, 0x17, 0x58, 0x31, 0xDF, 0xD2, 0x77, 0x3A, 0x0B, 0x04, 0x73,
  0x0B, 0xB0, 0xD0, 0x27, 0x40, 0x74, 0xC0, 0xC0, 0x37, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x72, 0x07,
  0x94, 0xE0, 0x87, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x70, 0x7A, 0x40, 0xBE, 0x0B, 0x01, 0x70, 0x20,
  0xDB, 0x0D, 0x02, 0x50, 0x7B, 0x50, 0x20, 0x9D, 0x0C, 0x71, 0x02, 0x0D, 0xB0, 0xD0, 0x24, 0x0C,
  0xB7, 0x03, 0x0D, 0xC0, 0xB7, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x30, 0x10, 0xCA, 0x71, 0x01, 0x0B,
  0xC0, 0x87, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x30, 0x10, 0xC9, 0x73, 0x0B, 0xC0, 0x37, 0x10, 0x20,
  0xDB, 0x0D, 0x02, 0x30, 0x10, 0xC7, 0x40, 0xDB, 0x0C, 0x72, 0x02, 0x0D, 0xB0, 0xD0, 0x23, 0x01,
  0x40, 0xB0, 0x15, 0x03, 0xC0, 0x47, 0x20, 0x20, 0xDB, 0x0D, 0x02, 0x79, 0x0E, 0x03, 0x50, 0x9B,
  0x0B, 0x1F, 0xF0, 0xD0, 0x26, 0xA0, 0xE0, 0x14, 0x02, 0xC0, 0x1F, 0xF9, 0x0D, 0x02, 0x5B, 0x0B,
  0x50, 0xBB, 0x05, 0xFF, 0xA0, 0xD0, 0x24, 0x0C, 0xB0, 0x34, 0x07, 0xB0, 0x9F, 0xFB, 0x0D, 0x02,
  0x30, 0x10, 0xCA, 0x09, 0x40, 0x3B, 0x0C, 0xFF, 0xC0, 0xD0, 0x23, 0x82, 0x1C, 0xFC, 0x40, 0x1B,
  0x0D, 0xFF, 0xD0, 0xD0, 0x23, 0x81, 0x1C, 0xE5, 0xB0, 0xEF, 0xFE, 0x0D, 0x02, 0x30, 0x10, 0xB5,
  0xFF, 0xFC, 0x0D, 0x02, 0x71, 0x02, 0xB0, 0xEF, 0xFC, 0x0D, 0xB0, 0xD0, 0x27, 0x04, 0xB0, 0xCF,
  0xFC, 0x02, 0x0D, 0xB0, 0xD0, 0x26, 0x08, 0xB0, 0x9F, 0xFC, 0x10, 0x20, 0xDB, 0x0D, 0x02, 0x50,
  0xCB, 0x06, 0xFF, 0xC2, 0x02, 0x0D, 0xB0, 0xD0, 0x24, 0x0C, 0xB0, 0x17, 0x10, 0x7F, 0xA3, 0x02,
  0x0D, 0xB0, 0xD0, 0x23, 0x82, 0x1C, 0xFB, 0x73, 0x07, 0xF9, 0x40, 0x20, 0xDB, 0x0D, 0x02, 0x38,
  0x11, 0xC4, 0x74, 0x07, 0xF5, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x73, 0x07, 0xE6, 0x02, 0x0D, 0xB0,
  0xD0, 0x27, 0x73, 0x07, 0xD7, 0x02, 0x0D, 0xB0, 0xD0, 0x27, 0x73, 0x07, 0xC7, 0x04, 0x0D, 0xC0,
  0xD0, 0x27, 0x73, 0x07, 0xB5, 0x03, 0x0A, 0xF0, 0xD0, 0x27, 0x73, 0x07, 0xA4, 0x0C, 0xFB, 0x0D,
  0x02, 0x77, 0x30, 0x79, 0x4E, 0x81, 0x82, 0xDB, 0x0D, 0x02, 0x77, 0x30, 0x74, 0xC0, 0xC0, 0x32,
  0x02, 0x0D, 0xB0, 0xB7, 0x77, 0x1A, 0x0B, 0x04, 0x58, 0x32, 0xDF, 0xD1, 0x77, 0x71, 0x05, 0x01,
  0x71, 0x81, 0x2B, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_volume_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_volume_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_volume_up 48x48, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_filled_48_av_volume_up_data[] PROGMEM = {
  0x77, 0x71, 0x05, 0x01, 0x77, 0x77, 0x6A, 0x0B, 0x04, 0x77, 0x76, 0x07, 0x4C, 0x0C, 0x03, 0x77,
  0x73, 0x07, 0x94, 0xE0, 0x87, 0x77, 0x10, 0x7A, 0x40, 0xBE, 0x0B, 0x01, 0x77, 0x50, 0x7B, 0x50,
  0x20, 0x9D, 0x0C, 0x77, 0x40, 0x7C, 0x70, 0x30, 0xDC, 0x0B, 0x77, 0x20, 0x7D, 0x71, 0x01, 0x0B,
  0xC0, 0x87, 0x70, 0x7E, 0x73, 0x0B, 0xC0, 0x37, 0x50, 0x7F, 0x74, 0x0D, 0xB0, 0xC7, 0x40, 0x7F,
  0x94, 0x0B, 0x01, 0x50, 0x3C, 0x04, 0x72, 0x07, 0xFA, 0x49, 0x0E, 0x03, 0x50, 0x9B, 0x0B, 0x1F,
  0xFC, 0x4A, 0x0E, 0x01, 0x40, 0x2C, 0x01, 0xFF, 0xC4, 0xB0, 0xB5, 0x0B, 0xB0, 0x5F, 0xFC, 0x4C,
  0x03, 0x40, 0x7B, 0x09, 0xFF, 0xC4, 0xC0, 0x94, 0x03, 0xB0, 0xCF, 0xFC, 0x4C, 0x0C, 0x40, 0x1B,
  0x0D, 0xFF, 0xC4, 0xC0, 0xE5, 0xB0, 0xEF, 0xFC, 0x4C, 0x0E, 0x5B, 0x0E, 0xFF, 0xC4, 0xC0, 0xC4,
  0x01, 0xB0, 0xDF, 0xFC, 0x4C, 0x09, 0x40, 0x3B, 0x0C, 0xFF, 0xC4, 0xC0, 0x34, 0x07, 0xB0, 0x9F,
  0xFC, 0x4B, 0x0B, 0x50, 0xBB, 0x05, 0xFF, 0xC4, 0xA0, 0xD0, 0x14, 0x02, 0xC0, 0x17, 0x10, 0x7F,
  0xA4, 0x90, 0xE0, 0x35, 0x09, 0xB0, 0xB7, 0x30, 0x7F, 0x94, 0x0A, 0x01, 0x50, 0x3C, 0x04, 0x74,
  0x07, 0xF7, 0x40, 0xDB, 0x0C, 0x76, 0x07, 0xE7, 0x30, 0xBC, 0x03, 0x77, 0x07, 0xD7, 0x10, 0x10,
  0xBC, 0x08, 0x77, 0x20, 0x7C, 0x70, 0x30, 0xDC, 0x0B, 0x77, 0x40, 0x7B, 0x50, 0x20, 0x9D, 0x0C,
  0x77, 0x60, 0x7A, 0x40, 0xBE, 0x0B, 0x01, 0x77, 0x70, 0x79, 0x4E, 0x08, 0x77, 0x73, 0x07, 0x4C,
  0x0C, 0x03, 0x77, 0x77, 0x2A, 0x0B, 0x04, 0x77, 0x77, 0x40, 0x50, 0x17, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_volume_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 41, 41), Box(0, 0, 47, 47),
      ic_filled_48_av_volume_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_web_asset_off 48x48, 4-bit Alpha,  RLE, 295 bytes.
static const unsigned char ic_filled_48_av_web_asset_off_data[] PROGMEM = {
  0x20, 0x20, 0x78, 0x0C, 0x40, 0x82, 0x2E, 0xF7, 0x80, 0xC2, 0x00, 0x20, 0xEB, 0x07, 0x80, 0xC1,
  0x00, 0x30, 0xEC, 0x07, 0x80, 0xC1, 0x00, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFF, 0xC8, 0x1D, 0xA1,
  0x30, 0x30, 0xEC, 0x07, 0x50, 0xCF, 0xFF, 0xD0, 0xE0, 0x13, 0x0A, 0xD0, 0x75, 0x0C, 0xFF, 0xFD,
  0x0A, 0x30, 0xEE, 0x07, 0x50, 0xCF, 0xFF, 0xC0, 0xD3, 0xF9, 0x07, 0x50, 0xCF, 0xFF, 0xC3, 0xFA,
  0x07, 0x50, 0xCF, 0xFF, 0xB3, 0xFB, 0x07, 0x50, 0xCF, 0xFF, 0xA3, 0xFC, 0x07, 0x50, 0xCF, 0xFF,
  0x93, 0xC2, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0x2C, 0x3C, 0x30, 0x30, 0xEC, 0x07, 0x77, 0x71, 0xC3,
  0xC4, 0x03, 0x0E, 0xC0, 0x77, 0x77, 0xC3, 0xC5, 0x03, 0x0E, 0xC0, 0x77, 0x76, 0xC3, 0xC6, 0x03,
  0x0E, 0xC0, 0x77, 0x75, 0xC3, 0xC7, 0x03, 0x0E, 0xC0, 0x77, 0x74, 0xC3, 0xC7, 0x10, 0x30, 0xEC,
  0x07, 0x77, 0x3C, 0x3C, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x72, 0xC3, 0xC7, 0x30, 0x30, 0xEC, 0x07,
  0x77, 0x1C, 0x3C, 0x74, 0x03, 0x0E, 0xC0, 0x77, 0x7C, 0x3C, 0x75, 0x03, 0x0E, 0xC0, 0x77, 0x6C,
  0x3C, 0x76, 0x03, 0x0E, 0xC0, 0x77, 0x5C, 0x3C, 0x77, 0x03, 0x0E, 0xC0, 0x77, 0x4C, 0x3C, 0x77,
  0x10, 0x30, 0xEC, 0x07, 0x73, 0xC3, 0xC7, 0x72, 0x03, 0x0E, 0xC0, 0x77, 0x2C, 0x3C, 0x77, 0x30,
  0x30, 0xEC, 0x07, 0x71, 0xC3, 0xC7, 0x74, 0x03, 0x0E, 0xC0, 0x77, 0xC3, 0xC7, 0x75, 0x03, 0x0E,
  0xC0, 0x76, 0xC3, 0xC7, 0x76, 0x03, 0x0E, 0xC0, 0x75, 0x0C, 0xB3, 0xC7, 0x77, 0x03, 0x0E, 0xC0,
  0x75, 0x0C, 0xA3, 0x0D, 0xFF, 0xFF, 0xB0, 0x75, 0x0C, 0x0E, 0x30, 0xAF, 0xFF, 0xFC, 0x07, 0x50,
  0x73, 0x01, 0x0E, 0xFF, 0xFF, 0xC0, 0x77, 0x28, 0x11, 0xAD, 0xFF, 0xFF, 0xB0, 0x78, 0x0C, 0x10,
  0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x10, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x10, 0x03, 0x0E, 0xC0, 0x78,
  0x0C, 0x10, 0x03, 0x0E, 0xC0, 0x78, 0x0C, 0x10, 0x03, 0x0E, 0xA0, 0xE0, 0x28, 0x0C, 0x20, 0x82,
  0x3E, 0xE2, 0x80, 0xC4, 0x00, 0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_web_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 43, 46), Box(0, 0, 47, 47),
      ic_filled_48_av_web_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_web_asset 48x48, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_filled_48_av_web_asset_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0x84, 0xDA, 0x10, 0x1E, 0xFF, 0xFF, 0xC8, 0x1E, 0x1A, 0xFF, 0xFF,
  0xE0, 0xA0, 0xDF, 0xFF, 0xFE, 0x0D, 0x80, 0xAA, 0x0F, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77,
  0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77,
  0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9,
  0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77, 0x77, 0xF9, 0x77,
  0x77, 0xF9, 0x77, 0x77, 0xC0, 0xDF, 0xFF, 0xFE, 0x0D, 0x0A, 0xFF, 0xFF, 0xE8, 0x1A, 0x1E, 0xFF,
  0xFF, 0xC8, 0x4E, 0x10, 0x1A, 0xDF, 0xFF, 0xF8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_web_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 8, 41, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_web_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_48_av_web 48x48, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_filled_48_av_web_data[] PROGMEM = {
  0x18, 0x11, 0xAD, 0xFF, 0xFF, 0xC8, 0x4D, 0xA1, 0x01, 0xE8, 0x0C, 0x0F, 0x81, 0xE1, 0x98, 0x0C,
  0x2F, 0x0A, 0x0D, 0x80, 0xC2, 0xF0, 0xD8, 0x0B, 0xE0, 0xF7, 0x77, 0x1A, 0x71, 0xF9, 0x77, 0x71,
  0xA7, 0x1F, 0x97, 0x77, 0x1A, 0x71, 0xF9, 0x77, 0x71, 0xA7, 0x1F, 0x97, 0x77, 0x1A, 0x71, 0xF9,
  0x77, 0x71, 0xA7, 0x1F, 0x97, 0x77, 0x1A, 0x71, 0xF9, 0x77, 0x71, 0xA7, 0x1F, 0xFF, 0xFC, 0x71,
  0xFF, 0xFF, 0xC7, 0x1F, 0x97, 0x77, 0x1A, 0x71, 0xF9, 0x77, 0x71, 0xA7, 0x1F, 0x97, 0x77, 0x1A,
  0x71, 0xF9, 0x77, 0x71, 0xA7, 0x1F, 0x97, 0x77, 0x1A, 0x71, 0xF9, 0x77, 0x71, 0xA7, 0x1F, 0x97,
  0x77, 0x1A, 0x71, 0xF9, 0x77, 0x71, 0xA7, 0x1C, 0x0D, 0x80, 0xC2, 0xF0, 0xD0, 0xA8, 0x0C, 0x2F,
  0x81, 0xA1, 0xE8, 0x0C, 0x0F, 0x84, 0xE1, 0x01, 0xAD, 0xFF, 0xFF, 0xC8, 0x1D, 0xA1, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_48_av_web() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 43, 39), Box(0, 0, 47, 47),
      ic_filled_48_av_web_data, Alpha4(color::Black));
  return value;
}
