#include "maps.h"

using namespace roo_display;

// Image file ic_filled_36_maps_360 36x36, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_filled_36_maps_360_data[] PROGMEM = {
  0x73, 0x89, 0x01, 0x45, 0x67, 0x76, 0x54, 0x17, 0x72, 0x82, 0x27, 0xBE, 0xFB, 0x82, 0xEB, 0x72,
  0x73, 0x05, 0x0B, 0xFF, 0xC0, 0xB0, 0x56, 0x02, 0x0B, 0xE8, 0x90, 0xEB, 0x99, 0x77, 0x99, 0xBE,
  0xE0, 0xB0, 0x23, 0x03, 0x0E, 0xC8, 0x1A, 0x51, 0x73, 0x81, 0x15, 0xAC, 0x83, 0xE3, 0x01, 0xEA,
  0x81, 0xE8, 0x17, 0x72, 0x81, 0x18, 0xEA, 0x81, 0xE1, 0xAA, 0x0D, 0x02, 0x77, 0x60, 0x20, 0xDA,
  0x0A, 0x0D, 0xA0, 0x37, 0x77, 0x10, 0x3A, 0x0D, 0x0E, 0xA0, 0x26, 0x05, 0x01, 0x77, 0x03, 0xA0,
  0xE0, 0xAA, 0x0D, 0x02, 0x58, 0x17, 0xD1, 0x75, 0x02, 0x0D, 0xA8, 0x1A, 0x2E, 0xA8, 0x1E, 0x81,
  0x38, 0x27, 0xFD, 0x17, 0x20, 0x10, 0x8B, 0x83, 0xE2, 0x04, 0xEC, 0x82, 0xA5, 0x17, 0xA0, 0xD0,
  0x16, 0x05, 0x0A, 0xC0, 0xE0, 0x43, 0x02, 0x0C, 0xFB, 0x0D, 0x01, 0x5D, 0x0C, 0x02, 0x60, 0x50,
  0xCF, 0xA0, 0xD0, 0x14, 0xB0, 0xC0, 0x57, 0x38, 0x22, 0x7B, 0xED, 0x0D, 0x01, 0x48, 0x1B, 0x72,
  0x77, 0x20, 0x8B, 0x0D, 0x01, 0x77, 0x73, 0x07, 0xA0, 0xD0, 0x17, 0x77, 0x48, 0x27, 0xFD, 0x17,
  0x77, 0x58, 0x17, 0xD1, 0x77, 0x76, 0x05, 0x01, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_360() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 10, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_360_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_add_business 36x36, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_filled_36_maps_add_business_data[] PROGMEM = {
  0x2F, 0xFF, 0x90, 0x77, 0x4F, 0xFF, 0x90, 0x77, 0x4F, 0xFF, 0x90, 0x78, 0x0D, 0x10, 0x80, 0xA2,
  0x70, 0x47, 0x30, 0x3F, 0xFF, 0x90, 0xA7, 0x30, 0x6F, 0xFF, 0x90, 0xD7, 0x30, 0x9F, 0xFF, 0xA0,
  0x17, 0x20, 0xCF, 0xFF, 0xA0, 0x47, 0x2F, 0xFF, 0xB0, 0x77, 0x10, 0x3F, 0xFF, 0xB0, 0xA7, 0x10,
  0x6F, 0xFF, 0xB0, 0xD7, 0x10, 0x7F, 0xFF, 0xC7, 0x10, 0x7F, 0xFF, 0xC7, 0x10, 0x7F, 0xFF, 0xC7,
  0x3B, 0x70, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x74, 0xB7, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x71, 0x0F,
  0x77, 0xB7, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x71, 0xB7, 0xB7, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x71,
  0xB7, 0xB7, 0x07, 0xA0, 0x75, 0x82, 0x37, 0x73, 0x1B, 0x7B, 0x70, 0x7A, 0x07, 0x73, 0xB7, 0xFE,
  0x07, 0x50, 0x7F, 0xC0, 0x72, 0xFE, 0x07, 0x50, 0x7F, 0xC0, 0x72, 0xFE, 0x07, 0x50, 0x7F, 0xC0,
  0x77, 0x77, 0x5B, 0x77, 0x77, 0x3B, 0x77, 0x77, 0x3B, 0x77, 0x77, 0x3B, 0x77, 0x77, 0x30, 0xF7,
  0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_add_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_add_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_add_location_alt 36x36, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_filled_36_maps_add_location_alt_data[] PROGMEM = {
  0x77, 0x70, 0xF7, 0x77, 0x75, 0xB7, 0x77, 0x5B, 0x77, 0x84, 0x35, 0x77, 0x53, 0x6B, 0x74, 0x81,
  0x29, 0xEE, 0x6B, 0x73, 0x09, 0xFA, 0x10, 0x7F, 0xC0, 0x73, 0x01, 0x0C, 0xFB, 0x10, 0x7F, 0xC0,
  0x72, 0x01, 0x0D, 0xFC, 0x10, 0x7F, 0xC0, 0x72, 0x0B, 0xFD, 0x6B, 0x60, 0x5F, 0xE8, 0x00, 0x70,
  0x31, 0xB6, 0x0D, 0xFF, 0xB0, 0x71, 0xB5, 0x03, 0xFF, 0xC0, 0x71, 0xB5, 0x08, 0xFA, 0x82, 0xE9,
  0x9E, 0xD0, 0x71, 0x0F, 0x75, 0x0C, 0xF9, 0x0C, 0x01, 0x20, 0x10, 0xCC, 0x07, 0x72, 0x0D, 0xF9,
  0x03, 0x40, 0x3F, 0x90, 0xE5, 0xFA, 0x6F, 0xA5, 0x0E, 0xF9, 0x03, 0x40, 0x3F, 0x90, 0xE5, 0x0C,
  0xF9, 0x0C, 0x01, 0x20, 0x10, 0xCF, 0x90, 0xC5, 0x09, 0xFA, 0x82, 0xE9, 0x9E, 0xFA, 0x09, 0x50,
  0x4F, 0xFF, 0x90, 0x46, 0x0D, 0xFF, 0xE0, 0xD7, 0x06, 0xFF, 0xE0, 0x67, 0x10, 0xDF, 0xFC, 0x0D,
  0x72, 0x04, 0xFF, 0xC0, 0x47, 0x30, 0x9F, 0xFA, 0x09, 0x75, 0x0C, 0xFF, 0x0C, 0x76, 0x02, 0x0E,
  0xFD, 0x0E, 0x02, 0x77, 0x03, 0x0E, 0xFB, 0x0E, 0x03, 0x77, 0x20, 0x4F, 0xB0, 0x47, 0x74, 0x04,
  0xF9, 0x04, 0x77, 0x60, 0x4E, 0x04, 0x77, 0x71, 0x04, 0x0E, 0xA0, 0xE0, 0x47, 0x77, 0x38, 0x23,
  0xEE, 0x37, 0x77, 0x50, 0x02, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_add_location_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_add_location_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_add_location 36x36, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_filled_36_maps_add_location_data[] PROGMEM = {
  0x78, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x50, 0x60, 0xEF, 0x90, 0xE0, 0x67, 0x20, 0xAF, 0xD0, 0xA7,
  0x0B, 0xFF, 0x0B, 0x50, 0x8E, 0x82, 0xB7, 0x7B, 0xE0, 0x83, 0x02, 0xF0, 0x72, 0x07, 0xF0, 0x22,
  0x0A, 0xF0, 0x72, 0x07, 0xF0, 0xA2, 0x0E, 0xF0, 0x72, 0x07, 0xF8, 0x1E, 0x04, 0xF9, 0x07, 0x20,
  0x7F, 0x90, 0x40, 0x6C, 0x75, 0xC0, 0x60, 0x7C, 0x75, 0xC0, 0x70, 0x5C, 0x75, 0xC0, 0x60, 0x3F,
  0x90, 0x72, 0x07, 0xF9, 0x04, 0x1F, 0x90, 0x72, 0x07, 0xF9, 0x81, 0x10, 0xBF, 0x07, 0x20, 0x7F,
  0x0B, 0x20, 0x5F, 0x07, 0x20, 0x7F, 0x05, 0x30, 0xEE, 0x82, 0xB7, 0x7B, 0xE0, 0xE4, 0x08, 0xFF,
  0xA0, 0x84, 0x01, 0x0E, 0xFF, 0x0E, 0x01, 0x50, 0x7F, 0xF0, 0x77, 0x0D, 0xFD, 0x0D, 0x71, 0x04,
  0xFD, 0x04, 0x72, 0x0A, 0xFB, 0x0A, 0x73, 0x01, 0x0E, 0xF9, 0x0E, 0x01, 0x74, 0x05, 0xF9, 0x05,
  0x76, 0x09, 0xE0, 0x97, 0x71, 0x0C, 0xC0, 0xC7, 0x72, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x73, 0x04,
  0xA0, 0x47, 0x75, 0x00, 0x67, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_add_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_add_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_add_road 36x36, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_filled_36_maps_add_road_data[] PROGMEM = {
  0xB7, 0x07, 0xA0, 0x77, 0xB5, 0xB7, 0x07, 0xA0, 0x77, 0xB5, 0xB7, 0x07, 0xA0, 0x77, 0xB5, 0xB7,
  0x07, 0xA0, 0x77, 0xB5, 0xB7, 0x07, 0xA0, 0x77, 0xB5, 0xB7, 0x07, 0xA0, 0x77, 0xB5, 0xB7, 0x74,
  0xB5, 0xB7, 0x74, 0xB5, 0xB7, 0x74, 0xB5, 0xB7, 0x07, 0xA0, 0x77, 0xB5, 0xB7, 0x07, 0xA0, 0x77,
  0xB5, 0xB7, 0x07, 0xA0, 0x77, 0xB5, 0xB7, 0x07, 0xA0, 0x77, 0xB5, 0xB7, 0x07, 0xA0, 0x77, 0x0F,
  0x75, 0xB7, 0x07, 0xA0, 0x77, 0x71, 0xB7, 0x77, 0x5B, 0x77, 0x40, 0xF7, 0x5B, 0x77, 0x4B, 0x5B,
  0x70, 0x7A, 0x07, 0x7B, 0x5B, 0x70, 0x7A, 0x07, 0x7B, 0x5B, 0x70, 0x7A, 0x07, 0x7B, 0x5B, 0x70,
  0x7A, 0x07, 0x20, 0x7F, 0xC0, 0x7B, 0x70, 0x7A, 0x07, 0x20, 0x7F, 0xC0, 0x7B, 0x70, 0x7A, 0x07,
  0x20, 0x7F, 0xC0, 0x77, 0x77, 0xB7, 0x77, 0x5B, 0x77, 0x75, 0xB7, 0x77, 0x5B, 0x77, 0x75, 0x0F,
  0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_add_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_add_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_agriculture 36x36, 4-bit Alpha,  RLE, 246 bytes.
static const unsigned char ic_filled_36_maps_agriculture_data[] PROGMEM = {
  0x77, 0x40, 0x04, 0x77, 0x77, 0x38, 0x14, 0xFC, 0x77, 0x77, 0x28, 0x24, 0xFC, 0x17, 0x77, 0x71,
  0x04, 0xA0, 0x37, 0x77, 0x71, 0x84, 0x4F, 0xCE, 0xE2, 0x77, 0x76, 0x84, 0x1E, 0xC1, 0x2E, 0xFB,
  0x0D, 0x08, 0x70, 0x58, 0x01, 0x70, 0x43, 0x04, 0x01, 0x20, 0x7F, 0xD0, 0x85, 0x05, 0xF0, 0x96,
  0x07, 0xFD, 0x0D, 0x50, 0x5F, 0x90, 0x45, 0x07, 0xFE, 0x60, 0x58, 0x03, 0x70, 0x35, 0x08, 0xFE,
  0x77, 0x60, 0xBF, 0xE6, 0x85, 0x12, 0xCE, 0xEC, 0x56, 0x05, 0xFF, 0x58, 0x27, 0xF5, 0xEB, 0x85,
  0x4C, 0x60, 0x18, 0xBF, 0xF9, 0x40, 0x8F, 0x0E, 0xA8, 0x18, 0x08, 0xFF, 0xA3, 0x04, 0xB8, 0x4C,
  0x41, 0x15, 0xCB, 0x81, 0x40, 0xEF, 0x98, 0x59, 0x41, 0x02, 0x6D, 0x38, 0x23, 0xAF, 0xA6, 0x84,
  0xAF, 0xE7, 0x08, 0xE8, 0x5D, 0x30, 0x26, 0x74, 0x48, 0x32, 0xED, 0xE1, 0x68, 0x41, 0xEB, 0x82,
  0x3D, 0x82, 0xE2, 0x1A, 0xC0, 0xE0, 0x52, 0x06, 0xA0, 0xA7, 0x10, 0xAA, 0x06, 0x01, 0xD8, 0x16,
  0x0C, 0xF8, 0x15, 0x07, 0xA0, 0x87, 0x10, 0x8A, 0x07, 0x1C, 0x81, 0xE0, 0x7B, 0x81, 0xA8, 0xDA,
  0x81, 0xE0, 0x6A, 0x0A, 0x71, 0x0A, 0xA0, 0x60, 0x1C, 0x81, 0xA0, 0xCA, 0x06, 0x30, 0xDA, 0x84,
  0x52, 0x8B, 0xE1, 0x68, 0x31, 0xED, 0xE2, 0x7B, 0x01, 0x30, 0x8A, 0x84, 0x70, 0x7E, 0xFA, 0x68,
  0x2A, 0xFA, 0x37, 0x10, 0xEA, 0x02, 0x30, 0xAA, 0x81, 0x60, 0x4B, 0x84, 0xC5, 0x11, 0x4C, 0xB0,
  0x47, 0x10, 0xAA, 0x82, 0xC2, 0x06, 0xB0, 0x22, 0x08, 0xA0, 0xEF, 0x08, 0x72, 0x03, 0xF9, 0x0A,
  0x48, 0x16, 0xC4, 0xB8, 0x2E, 0x5F, 0x77, 0x40, 0x5E, 0x0C, 0x01, 0x68, 0x55, 0xCE, 0xEC, 0x21,
  0x76, 0x84, 0x3A, 0xEF, 0xC7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_agriculture() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_agriculture_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_airlines 36x36, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_filled_36_maps_airlines_data[] PROGMEM = {
  0x77, 0x20, 0xCF, 0xD0, 0xE7, 0x71, 0x08, 0xFE, 0x0B, 0x77, 0x03, 0xFF, 0x08, 0x77, 0x0D, 0xFF,
  0x05, 0x76, 0x09, 0xFF, 0x90, 0x27, 0x50, 0x4F, 0xF9, 0x0E, 0x75, 0x01, 0x0D, 0xFF, 0x90, 0xC7,
  0x50, 0xAD, 0x82, 0xB8, 0xAE, 0xF0, 0x97, 0x40, 0x5D, 0x05, 0x30, 0x10, 0xBE, 0x06, 0x73, 0x01,
  0x0E, 0xC0, 0x75, 0x01, 0x0E, 0xD0, 0x37, 0x30, 0xBD, 0x02, 0x60, 0xAD, 0x73, 0x06, 0xE0, 0x16,
  0x08, 0xC0, 0xD7, 0x20, 0x20, 0xEE, 0x04, 0x60, 0xBC, 0x0A, 0x72, 0x0B, 0xF0, 0xC5, 0x05, 0xD0,
  0x77, 0x10, 0x7F, 0xA8, 0x3C, 0x40, 0x27, 0xE0, 0x47, 0x02, 0xFF, 0xF0, 0x17, 0x0C, 0xFF, 0xE0,
  0xE7, 0x08, 0xFF, 0xF0, 0xB6, 0x03, 0xFF, 0xF9, 0x08, 0x60, 0xDF, 0xFF, 0x90, 0x55, 0x09, 0xFF,
  0xFA, 0x02, 0x40, 0x4F, 0xFF, 0xA0, 0xE4, 0x01, 0x0D, 0xFF, 0xFA, 0x0C, 0x40, 0xAF, 0xFF, 0xB0,
  0x94,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_airlines() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_airlines_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_airline_stops 36x36, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_filled_36_maps_airline_stops_data[] PROGMEM = {
  0x77, 0x40, 0x58, 0x05, 0x70, 0x37, 0x74, 0x01, 0x0D, 0xF9, 0x07, 0x77, 0x50, 0x10, 0xDF, 0x83,
  0x77, 0x54, 0x17, 0x72, 0x01, 0x0D, 0xE0, 0x7C, 0x81, 0xD8, 0x27, 0x70, 0x2E, 0x07, 0xF0, 0xA0,
  0x27, 0x40, 0x10, 0xCE, 0x82, 0x78, 0x9B, 0xE0, 0x77, 0x20, 0x20, 0xEB, 0x0E, 0xB0, 0x74, 0x04,
  0x0A, 0xC0, 0xB7, 0x03, 0x0E, 0xB8, 0x17, 0x1D, 0xA0, 0x76, 0x03, 0x0C, 0xB0, 0xC5, 0x01, 0x0E,
  0xA0, 0xE0, 0x42, 0x82, 0x1D, 0xF7, 0x71, 0x08, 0xB0, 0xB4, 0x0C, 0xA0, 0xE0, 0x24, 0x81, 0x1D,
  0x77, 0x20, 0x6B, 0x08, 0x20, 0x9A, 0x0E, 0x03, 0x60, 0x10, 0x57, 0x30, 0x7B, 0x00, 0x2B, 0x05,
  0x77, 0x60, 0xBA, 0x00, 0xBA, 0x0A, 0x77, 0x70, 0x2E, 0x02, 0x77, 0x71, 0x0A, 0xC0, 0x97, 0x77,
  0x20, 0x3C, 0x03, 0x77, 0x73, 0x0E, 0xA0, 0xD7, 0x77, 0x40, 0xAA, 0x0A, 0x77, 0x71, 0x82, 0x37,
  0x7C, 0xA8, 0x2B, 0x77, 0x37, 0x75, 0x07, 0xF9, 0x07, 0x77, 0x50, 0x7F, 0x90, 0x77, 0x75, 0x03,
  0x80, 0x47, 0x03, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_airline_stops() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 31, 28), Box(0, 0, 35, 35),
      ic_filled_36_maps_airline_stops_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_alt_route 36x36, 4-bit Alpha,  RLE, 187 bytes.
static const unsigned char ic_filled_36_maps_alt_route_data[] PROGMEM = {
  0x58, 0x11, 0xB1, 0x75, 0x81, 0x1B, 0x17, 0x28, 0x31, 0xDF, 0xD1, 0x73, 0x83, 0x1D, 0xFD, 0x17,
  0x01, 0x0D, 0xB0, 0xD0, 0x17, 0x10, 0x10, 0xDB, 0x0D, 0x01, 0x50, 0x10, 0xDD, 0x0D, 0x01, 0x60,
  0x10, 0xDD, 0x0D, 0x01, 0x30, 0x10, 0xDF, 0x0D, 0x01, 0x40, 0x10, 0xDF, 0x83, 0xD1, 0x01, 0xDF,
  0xA0, 0xD0, 0x12, 0x01, 0x0D, 0xFA, 0x0D, 0x01, 0x50, 0xEA, 0x75, 0xA0, 0xE7, 0x30, 0xDA, 0x01,
  0x73, 0x01, 0xA0, 0xD7, 0x38, 0x2C, 0xEA, 0x17, 0x30, 0x3A, 0x0C, 0x73, 0x01, 0x76, 0x06, 0xA0,
  0x97, 0x60, 0x27, 0x30, 0xBA, 0x06, 0x74, 0x82, 0xAE, 0xF2, 0x71, 0x02, 0xB0, 0x17, 0x40, 0xBA,
  0x0A, 0x71, 0x0B, 0xA0, 0xB7, 0x50, 0x3B, 0x06, 0x60, 0x7B, 0x03, 0x76, 0x82, 0x9F, 0xC1, 0x50,
  0x7B, 0x09, 0x77, 0x18, 0x39, 0x10, 0x16, 0x20, 0x8B, 0x0B, 0x77, 0x48, 0x31, 0xCF, 0x77, 0xB0,
  0xB7, 0x75, 0x08, 0xE0, 0xA7, 0x77, 0x0B, 0xC0, 0xB7, 0x77, 0x10, 0x1C, 0x01, 0x77, 0x72, 0x0B,
  0xA0, 0xB7, 0x77, 0x30, 0x8A, 0x09, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77,
  0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A,
  0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_alt_route() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_alt_route_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_atm 36x36, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_filled_36_maps_atm_data[] PROGMEM = {
  0x02, 0x80, 0x17, 0x05, 0x28, 0x05, 0x73, 0x06, 0x80, 0x37, 0x02, 0x0D, 0xE0, 0x51, 0xFA, 0x20,
  0x9F, 0x90, 0xDA, 0x89, 0x3C, 0xBB, 0xEF, 0x70, 0xBB, 0xBE, 0xFE, 0x0F, 0xB2, 0x82, 0xBF, 0xDB,
  0xA0, 0x0C, 0xC0, 0x32, 0x81, 0xBF, 0x74, 0x81, 0x9F, 0x95, 0x81, 0xBF, 0x71, 0xA0, 0x03, 0xC0,
  0x32, 0x81, 0xBF, 0x74, 0x81, 0x9F, 0x95, 0x81, 0xBF, 0x71, 0xA0, 0x03, 0xFA, 0x07, 0x48, 0x19,
  0xF9, 0x58, 0x1B, 0xF7, 0x1A, 0x00, 0x3F, 0xA0, 0x74, 0x81, 0x9F, 0x95, 0x81, 0xBF, 0x71, 0xA0,
  0x03, 0xC8, 0x46, 0x33, 0xCF, 0x74, 0x81, 0x9F, 0x95, 0x81, 0xBF, 0x71, 0xA0, 0x03, 0xC0, 0x32,
  0x81, 0xBF, 0x74, 0x81, 0x9F, 0x95, 0x81, 0xBF, 0x74, 0x03, 0xA8, 0x17, 0x71, 0x28, 0x15, 0x73,
  0x48, 0x14, 0x74, 0x58, 0x15, 0x73, 0x48, 0x11, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_atm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 13, 32, 22), Box(0, 0, 35, 35),
      ic_filled_36_maps_atm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_attractions 36x36, 4-bit Alpha,  RLE, 273 bytes.
static const unsigned char ic_filled_36_maps_attractions_data[] PROGMEM = {
  0x75, 0x82, 0x8E, 0xE8, 0x77, 0x72, 0x08, 0xC0, 0x87, 0x77, 0x03, 0x0E, 0xC0, 0xE0, 0x37, 0x74,
  0x07, 0x0E, 0xF9, 0x0E, 0x07, 0x77, 0x04, 0x0D, 0xA0, 0x0B, 0xC0, 0x0B, 0xA0, 0xD0, 0x47, 0x40,
  0x7A, 0x0B, 0x02, 0x28, 0x28, 0xEE, 0x82, 0x02, 0x0B, 0xA0, 0x76, 0x82, 0x2B, 0xED, 0xA0, 0x67,
  0x50, 0x6A, 0x82, 0xDE, 0xB2, 0x20, 0xDC, 0x06, 0x77, 0x06, 0xC8, 0x1D, 0x04, 0xD0, 0x87, 0x70,
  0x8D, 0x00, 0x4D, 0x08, 0x77, 0x07, 0xD8, 0x14, 0x0D, 0xC0, 0x24, 0x06, 0x0D, 0xA0, 0xD0, 0x64,
  0x02, 0xC0, 0xD2, 0x05, 0xA0, 0xC0, 0x44, 0x0A, 0xE0, 0xA4, 0x04, 0x0C, 0xA0, 0x42, 0x81, 0x7F,
  0x95, 0x07, 0xF9, 0x07, 0x58, 0x1A, 0xF7, 0x28, 0x19, 0xF6, 0x50, 0xEF, 0x90, 0xE5, 0x81, 0x7F,
  0x92, 0x81, 0xBF, 0x54, 0x02, 0xFB, 0x02, 0x48, 0x16, 0xFA, 0x28, 0x1B, 0xF6, 0x40, 0x1F, 0xB0,
  0x24, 0x81, 0x7F, 0xA2, 0x81, 0x9F, 0x75, 0x0E, 0xF9, 0x0E, 0x58, 0x18, 0xF9, 0x28, 0x17, 0xFB,
  0x50, 0x7F, 0x90, 0x85, 0x81, 0xCF, 0x72, 0x05, 0xA0, 0xC0, 0x43, 0x03, 0xF9, 0x02, 0x30, 0x40,
  0xDA, 0x04, 0x20, 0xDC, 0x02, 0x20, 0x9A, 0x0E, 0xA0, 0xEA, 0x08, 0x20, 0x2C, 0x81, 0xD0, 0x4D,
  0x81, 0x70, 0x1A, 0x89, 0x1B, 0x01, 0x10, 0xCF, 0xE1, 0x07, 0xD0, 0x04, 0xD8, 0x17, 0x08, 0xA0,
  0x44, 0x05, 0xA8, 0x17, 0x07, 0xD8, 0x14, 0x0D, 0xC8, 0x3A, 0x1E, 0xFC, 0x68, 0x3D, 0xFD, 0x1B,
  0xC0, 0xD2, 0x82, 0x2B, 0xED, 0xA0, 0xEA, 0x05, 0x60, 0x7A, 0x0E, 0xA8, 0x2D, 0xEB, 0x26, 0x06,
  0xC8, 0x64, 0x08, 0xDE, 0x80, 0x4C, 0x07, 0x74, 0x07, 0xFF, 0x06, 0x75, 0x0B, 0xA0, 0xDF, 0x90,
  0xDA, 0x0A, 0x74, 0x03, 0xA8, 0x29, 0x03, 0xEC, 0x82, 0xE3, 0x0A, 0xA0, 0x27, 0x30, 0xAA, 0x02,
  0x20, 0x8C, 0x08, 0x20, 0x3A, 0x08, 0x72, 0x01, 0xA0, 0xB4, 0x82, 0x8E, 0xE8, 0x48, 0x2B, 0xFE,
  0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_attractions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_attractions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_badge 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_filled_36_maps_badge_data[] PROGMEM = {
  0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x77, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x76, 0x06, 0xF9, 0x06,
  0x77, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x77, 0x60,
  0x7A, 0x07, 0x20, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x74, 0x01, 0x06, 0x80,
  0x37, 0x0B, 0xA0, 0x72, 0x07, 0xA0, 0xB8, 0x03, 0x78, 0x36, 0x10, 0x3E, 0xFC, 0x07, 0x20, 0x7F,
  0xC8, 0x1E, 0x3B, 0xFD, 0x07, 0x20, 0x7F, 0xD0, 0xBF, 0xE8, 0x2B, 0x77, 0xB8, 0x0A, 0x91, 0xF8,
  0x3E, 0x40, 0x4E, 0xD6, 0xFF, 0x06, 0x30, 0x6D, 0x6F, 0xF0, 0x43, 0x04, 0xD8, 0x02, 0xBF, 0xF0,
  0xA3, 0x0A, 0xFF, 0xFD, 0x81, 0xC8, 0xCE, 0x80, 0x27, 0xFF, 0x83, 0xEB, 0x9B, 0xED, 0x6F, 0xD0,
  0xD0, 0x45, 0x04, 0x0D, 0xB8, 0x02, 0x3F, 0xD0, 0x37, 0x01, 0xFF, 0xF7, 0x28, 0x09, 0xC5, 0xF0,
  0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28, 0x08, 0xDF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_badge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_badge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_bakery_dining 36x36, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_filled_36_maps_bakery_dining_data[] PROGMEM = {
  0x73, 0x01, 0x80, 0x27, 0x01, 0x77, 0x60, 0xAE, 0x0A, 0x77, 0x30, 0x22, 0x0B, 0xE0, 0xB2, 0x02,
  0x75, 0x84, 0x3C, 0xFA, 0x0A, 0xE8, 0x49, 0x0B, 0xFB, 0x37, 0x20, 0x8C, 0x10, 0x8E, 0x08, 0x1C,
  0x08, 0x71, 0xD0, 0x10, 0x7E, 0x06, 0x02, 0xD7, 0x10, 0xCC, 0x03, 0x05, 0xE0, 0x50, 0x3C, 0x0C,
  0x71, 0x04, 0xC0, 0x50, 0x3E, 0x03, 0x05, 0xC0, 0x47, 0x20, 0xCB, 0x07, 0x02, 0xE0, 0x10, 0x7B,
  0x0C, 0x78, 0x28, 0xA1, 0x4B, 0x09, 0x1E, 0x10, 0x9B, 0x82, 0x42, 0xB9, 0x30, 0x7A, 0x81, 0xB0,
  0xBA, 0x81, 0xB0, 0xEC, 0x81, 0xE0, 0xBA, 0x81, 0xB0, 0xBA, 0x82, 0x70, 0x2E, 0xB0, 0x04, 0xA8,
  0x1C, 0x0C, 0xC8, 0x1C, 0x0C, 0xA0, 0x04, 0xB8, 0x1E, 0x16, 0xC8, 0xA0, 0x80, 0x67, 0x70, 0x57,
  0x77, 0x75, 0x07, 0x76, 0x08, 0xC0, 0x60, 0x3B, 0x07, 0x77, 0x40, 0x7B, 0x83, 0x30, 0x6A, 0x37,
  0x76, 0x81, 0x3A, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_bakery_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 31, 24), Box(0, 0, 35, 35),
      ic_filled_36_maps_bakery_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_beenhere 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_filled_36_maps_beenhere_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x03, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xF0, 0x9C,
  0x00, 0x7F, 0xFE, 0x81, 0x40, 0x7B, 0x00, 0x7F, 0xFD, 0x04, 0x30, 0xBA, 0x00, 0x7F, 0xFC, 0x04,
  0x30, 0x7B, 0x00, 0x7F, 0xFB, 0x04, 0x30, 0x7C, 0x00, 0x7F, 0xFA, 0x04, 0x30, 0x7D, 0x00, 0x7C,
  0x0A, 0xFB, 0x04, 0x30, 0x7E, 0x00, 0x7B, 0x81, 0x70, 0x4F, 0x90, 0x43, 0x07, 0xF0, 0x07, 0xA0,
  0xB3, 0x04, 0xE0, 0x43, 0x07, 0xF9, 0x00, 0x7B, 0x07, 0x30, 0x4C, 0x04, 0x30, 0x7F, 0xA0, 0x07,
  0xC0, 0x73, 0x04, 0xA0, 0x43, 0x07, 0xFB, 0x00, 0x7D, 0x07, 0x30, 0x04, 0x30, 0x7F, 0xC0, 0x07,
  0xE0, 0x76, 0x07, 0xFD, 0x00, 0x7F, 0x07, 0x40, 0x7F, 0xE0, 0x07, 0xF9, 0x07, 0x20, 0x7F, 0xF0,
  0x07, 0xFA, 0x00, 0x7F, 0xF9, 0x07, 0x06, 0xFF, 0xFD, 0x81, 0x61, 0xEF, 0xFF, 0xB8, 0x3E, 0x10,
  0x2C, 0xFF, 0xF9, 0x0C, 0x02, 0x40, 0x7F, 0xFE, 0x07, 0x70, 0x20, 0xCF, 0xFA, 0x0C, 0x02, 0x73,
  0x07, 0xFF, 0x07, 0x76, 0x02, 0x0C, 0xFB, 0x0C, 0x02, 0x77, 0x20, 0x7F, 0x90, 0x77, 0x75, 0x02,
  0x0C, 0xC0, 0xC0, 0x27, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x74, 0x00, 0x27, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_beenhere() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_beenhere_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_bike_scooter 36x36, 4-bit Alpha,  RLE, 260 bytes.
static const unsigned char ic_filled_36_maps_bike_scooter_data[] PROGMEM = {
  0x77, 0x20, 0x38, 0x02, 0x70, 0x47, 0x77, 0x70, 0x7F, 0x09, 0x77, 0x10, 0x7D, 0x81, 0xEA, 0x13,
  0x07, 0xF9, 0x03, 0x77, 0x07, 0xF0, 0xC3, 0x03, 0x80, 0x17, 0x0B, 0xA0, 0x97, 0x70, 0x7F, 0x90,
  0x37, 0x10, 0x3A, 0x0E, 0x77, 0x60, 0x9A, 0x07, 0x72, 0x0C, 0xA0, 0x57, 0x75, 0x05, 0xA0, 0xB7,
  0x20, 0x7A, 0x0B, 0x77, 0x50, 0x1A, 0x0E, 0x72, 0x01, 0xB0, 0x17, 0x75, 0x0D, 0xA0, 0x20, 0x4F,
  0xE8, 0x1D, 0xB5, 0x77, 0x10, 0xAA, 0x06, 0x01, 0xFF, 0xA0, 0xC0, 0x27, 0x60, 0x6A, 0x81, 0x90,
  0xCF, 0xFA, 0x0E, 0x02, 0x75, 0x03, 0xA0, 0xD7, 0x0C, 0xD8, 0x18, 0x37, 0xB0, 0xC7, 0x60, 0xEA,
  0x01, 0x50, 0x5A, 0x0E, 0x07, 0xA0, 0xE2, 0x03, 0xB0, 0x57, 0x50, 0xBA, 0x04, 0x50, 0xAA, 0x81,
  0x70, 0xDA, 0x04, 0x20, 0x7A, 0x0B, 0x74, 0x03, 0x0C, 0xA8, 0x18, 0x0E, 0xE8, 0x12, 0x08, 0xA0,
  0x92, 0x02, 0xA0, 0xD7, 0x20, 0x10, 0xBC, 0x81, 0xB0, 0xAE, 0x28, 0x22, 0xD7, 0x23, 0xB7, 0x10,
  0x30, 0xDE, 0x10, 0x7E, 0x03, 0x70, 0x2A, 0x0D, 0x70, 0x10, 0xEB, 0x08, 0x03, 0x70, 0xAA, 0x08,
  0x70, 0x7A, 0x0A, 0x70, 0xAA, 0x85, 0xD2, 0x02, 0x66, 0x24, 0x05, 0xB0, 0x35, 0x03, 0xB0, 0x46,
  0x03, 0xB8, 0x12, 0x0A, 0xC0, 0xA4, 0x0C, 0xB8, 0x38, 0x30, 0x38, 0xB0, 0xB7, 0x08, 0xA8, 0x18,
  0x09, 0xE0, 0x93, 0x02, 0x0E, 0xFA, 0x0D, 0x01, 0x18, 0x02, 0x70, 0xDA, 0x03, 0x02, 0xB0, 0x09,
  0xB0, 0x23, 0x02, 0x0C, 0xF0, 0xB0, 0x12, 0xFA, 0x10, 0x6A, 0x09, 0x20, 0x9A, 0x06, 0x58, 0x55,
  0xBD, 0xFD, 0xA4, 0x4F, 0xA1, 0x06, 0xA0, 0x92, 0x09, 0xA0, 0x67, 0x72, 0x80, 0x57, 0x10, 0x2B,
  0x00, 0x9B, 0x02, 0x77, 0x76, 0x09, 0xE0, 0x97, 0x77, 0x71, 0x0A, 0xC0, 0xA7, 0x77, 0x73, 0x82,
  0x26, 0x62, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_bike_scooter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 35, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_bike_scooter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_breakfast_dining 36x36, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_filled_36_maps_breakfast_dining_data[] PROGMEM = {
  0x40, 0x48, 0x0A, 0x07, 0x04, 0x60, 0x50, 0xDF, 0xFF, 0x90, 0xD0, 0x53, 0x06, 0xFF, 0xFD, 0x81,
  0x60, 0x2F, 0xFF, 0xF0, 0x20, 0x9F, 0xFF, 0xF0, 0x90, 0xDF, 0xFF, 0xF0, 0xDF, 0xFF, 0xFA, 0x0D,
  0xFF, 0xFF, 0x0D, 0x09, 0xFF, 0xFF, 0x09, 0x02, 0xFF, 0xFF, 0x81, 0x20, 0x6F, 0xFF, 0xD0, 0x63,
  0x04, 0xFF, 0xFB, 0x04, 0x5F, 0xA8, 0x02, 0x7F, 0xA6, 0xFA, 0x6F, 0xA6, 0xFA, 0x6F, 0xA6, 0xFA,
  0x6F, 0xA6, 0xFA, 0x6F, 0xA6, 0xFA, 0x6F, 0xA6, 0xFA, 0x80, 0x27, 0xFA, 0x6F, 0xFF, 0xB6, 0xFF,
  0xFB, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x60, 0xBF, 0xFF, 0x90, 0xB6,
  0x03, 0x0E, 0xFF, 0xE0, 0xE0, 0x37, 0x01, 0x06, 0x80, 0x96, 0x70, 0x60, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_breakfast_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_breakfast_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_brunch_dining 36x36, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_filled_36_maps_brunch_dining_data[] PROGMEM = {
  0x77, 0x7F, 0xA7, 0x77, 0xFA, 0x77, 0x7F, 0xA7, 0x77, 0xB3, 0xB7, 0x77, 0xB3, 0xB7, 0x77, 0xB3,
  0xB7, 0x77, 0xB3, 0xB7, 0x77, 0xB3, 0xB7, 0x77, 0xB3, 0xB7, 0x77, 0xFA, 0x77, 0x7F, 0xA7, 0x77,
  0xFA, 0x77, 0x7F, 0xA7, 0x77, 0xFA, 0x77, 0x7F, 0xA7, 0x77, 0x0D, 0xF0, 0xD7, 0x77, 0x0A, 0xF0,
  0xA7, 0x77, 0x04, 0xF0, 0x57, 0x07, 0xD0, 0x77, 0x10, 0xCD, 0x0D, 0x71, 0x07, 0xD0, 0x77, 0x10,
  0x20, 0xEC, 0x03, 0x71, 0x07, 0xD0, 0x77, 0x20, 0x5B, 0x06, 0x20, 0xCF, 0xFD, 0x0C, 0x3B, 0x3F,
  0xFF, 0x3B, 0x30, 0xCF, 0xFD, 0x0C, 0x3B, 0x77, 0x76, 0xB7, 0x77, 0x6B, 0x77, 0x76, 0xB3, 0xFF,
  0xF3, 0xFF, 0xFE, 0x3E, 0x0D, 0xFF, 0xD0, 0xD3, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_brunch_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_brunch_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_bus_alert 36x36, 4-bit Alpha,  RLE, 314 bytes.
static const unsigned char ic_filled_36_maps_bus_alert_data[] PROGMEM = {
  0x77, 0x68, 0x42, 0x46, 0x75, 0x27, 0x77, 0x50, 0x60, 0xCE, 0x0D, 0x06, 0x77, 0x71, 0x03, 0x0C,
  0xFB, 0x0D, 0x02, 0x77, 0x50, 0x4C, 0x84, 0xEA, 0x88, 0xAE, 0xB0, 0xE0, 0x47, 0x73, 0x03, 0x0E,
  0xA0, 0xE0, 0x66, 0x06, 0x0E, 0xA0, 0xE0, 0x26, 0x84, 0x16, 0x9B, 0xDD, 0xF0, 0xC0, 0x12, 0x07,
  0xA0, 0x72, 0x02, 0x0D, 0xA0, 0xC4, 0x02, 0x0A, 0xFD, 0x0E, 0x01, 0x30, 0x7A, 0x07, 0x30, 0x20,
  0xEA, 0x05, 0x20, 0x30, 0xEF, 0xE0, 0x54, 0x07, 0xA0, 0x74, 0x06, 0xA0, 0xB2, 0x0D, 0xFE, 0x0E,
  0x50, 0x7A, 0x07, 0x50, 0xEA, 0x01, 0x04, 0xFF, 0x0A, 0x50, 0x7A, 0x07, 0x50, 0xBA, 0x04, 0x06,
  0xFF, 0x08, 0x50, 0x7A, 0x07, 0x50, 0x9A, 0x05, 0x07, 0xA0, 0x77, 0x10, 0x6A, 0x08, 0x50, 0x7A,
  0x07, 0x50, 0x9A, 0x05, 0x07, 0xA0, 0x77, 0x10, 0x5A, 0x0A, 0x58, 0x23, 0x77, 0x35, 0x0B, 0xA0,
  0x40, 0x7A, 0x07, 0x71, 0x02, 0xA0, 0xE7, 0x70, 0xEA, 0x01, 0x07, 0xA0, 0x77, 0x20, 0xDA, 0x05,
  0x40, 0x7A, 0x07, 0x40, 0x6A, 0x81, 0xC0, 0x7A, 0x07, 0x72, 0x06, 0xA0, 0xE0, 0x13, 0x07, 0xA0,
  0x73, 0x02, 0x0E, 0xA8, 0x15, 0x07, 0xA0, 0x77, 0x30, 0xDA, 0x0C, 0x01, 0x20, 0x7A, 0x07, 0x20,
  0x20, 0xDA, 0x0C, 0x20, 0x7A, 0x07, 0x73, 0x03, 0x0E, 0xA0, 0xE0, 0x66, 0x06, 0x0E, 0xA0, 0xE0,
  0x22, 0x07, 0xA0, 0xB8, 0x07, 0x70, 0xBC, 0x84, 0xEA, 0x88, 0xAE, 0xB0, 0xE0, 0x33, 0x07, 0xFF,
  0xFE, 0x0C, 0x02, 0x40, 0x7F, 0xFF, 0xC0, 0xD0, 0x66, 0x07, 0xFF, 0xFA, 0x0A, 0x01, 0x71, 0x07,
  0xFF, 0xFA, 0x07, 0x72, 0x07, 0xB8, 0x26, 0x12, 0xCF, 0xA8, 0x2C, 0x30, 0x6B, 0x07, 0x72, 0x07,
  0xA0, 0xA3, 0x03, 0xFA, 0x03, 0x30, 0xAA, 0x07, 0x72, 0x07, 0xA0, 0x83, 0x01, 0xFA, 0x01, 0x30,
  0x8A, 0x07, 0x72, 0x06, 0xA0, 0xD0, 0x12, 0x07, 0xFA, 0x07, 0x20, 0x10, 0xDA, 0x06, 0x72, 0x03,
  0xB8, 0x1D, 0x8A, 0xFC, 0x81, 0xA8, 0xDB, 0x03, 0x73, 0x0A, 0xFF, 0xF0, 0xA7, 0x5F, 0xFF, 0x76,
  0xC0, 0xB8, 0x07, 0x70, 0xBC, 0x76, 0xC0, 0x77, 0x40, 0x7C, 0x76, 0x0D, 0xB0, 0x57, 0x40, 0x5B,
  0x0D, 0x76, 0x82, 0x27, 0x75, 0x76, 0x82, 0x57, 0x72, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_bus_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_bus_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_car_crash 36x36, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_filled_36_maps_car_crash_data[] PROGMEM = {
  0x77, 0x78, 0x25, 0x77, 0x57, 0x77, 0x30, 0x10, 0x9E, 0x09, 0x01, 0x77, 0x60, 0x20, 0xDF, 0x90,
  0xD0, 0x27, 0x74, 0x01, 0x0D, 0xC0, 0x09, 0xC0, 0xD0, 0x17, 0x73, 0x09, 0xD0, 0x03, 0xD0, 0x95,
  0x08, 0x0E, 0xE0, 0xC3, 0xE0, 0x03, 0xE4, 0x05, 0xF9, 0x09, 0x20, 0x5E, 0x00, 0x3E, 0x05, 0x30,
  0xBF, 0x90, 0x82, 0x06, 0xE0, 0x03, 0xE0, 0x62, 0x01, 0xB0, 0x17, 0x10, 0x6E, 0x00, 0x3E, 0x06,
  0x20, 0x6A, 0x0B, 0x72, 0x05, 0xE0, 0x09, 0xE0, 0x52, 0x0B, 0xA0, 0x67, 0x3F, 0xF2, 0x01, 0xB0,
  0x17, 0x30, 0x9D, 0x00, 0x3D, 0x09, 0x20, 0x7A, 0x0D, 0x80, 0x47, 0x05, 0x20, 0x10, 0xDC, 0x00,
  0x9C, 0x0D, 0x01, 0x20, 0xCF, 0xD0, 0x22, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x20, 0x2F, 0xE0, 0xB3,
  0x01, 0x09, 0xE0, 0x90, 0x13, 0x07, 0xFF, 0x0A, 0x58, 0x25, 0x77, 0x56, 0x07, 0xFF, 0x90, 0xC0,
  0x17, 0x60, 0x7C, 0x82, 0xC2, 0x06, 0xFA, 0x08, 0x70, 0x20, 0x33, 0x07, 0xC0, 0x23, 0x0A, 0xF9,
  0x0A, 0x48, 0x38, 0xAD, 0xF7, 0x30, 0x7C, 0x01, 0x30, 0x8F, 0x90, 0x83, 0x01, 0xC0, 0x73, 0x07,
  0xC0, 0x63, 0x0D, 0xF9, 0x0D, 0x30, 0x6C, 0x07, 0x30, 0x7D, 0x81, 0xA8, 0xDF, 0xB8, 0x1D, 0x8A,
  0xD0, 0x73, 0x07, 0xFF, 0xFD, 0x07, 0x30, 0x7F, 0xFF, 0xD0, 0x73, 0x07, 0xFF, 0xFD, 0x07, 0x30,
  0x7F, 0xFF, 0xD0, 0x73, 0x07, 0xC7, 0x74, 0xC0, 0x73, 0x07, 0xC7, 0x74, 0xC0, 0x73, 0x02, 0x0D,
  0xA0, 0x87, 0x74, 0x08, 0xA0, 0xD0, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_car_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 34, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_car_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_car_rental 36x36, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_filled_36_maps_car_rental_data[] PROGMEM = {
  0x38, 0x22, 0x66, 0x37, 0x73, 0x0A, 0xC0, 0xA7, 0x71, 0x09, 0xE0, 0xA7, 0x60, 0x2B, 0x00, 0x9B,
  0x08, 0x80, 0x77, 0x03, 0x06, 0xA0, 0x92, 0x09, 0xFF, 0x07, 0x06, 0xA0, 0x92, 0x09, 0xFF, 0x07,
  0x02, 0xB0, 0x09, 0xB0, 0x88, 0x03, 0x7B, 0x82, 0x73, 0x09, 0xE0, 0xA7, 0x1B, 0x40, 0x9C, 0x0A,
  0x72, 0xB5, 0x82, 0x26, 0x63, 0x73, 0x0F, 0x78, 0x0D, 0x50, 0x02, 0x80, 0x92, 0x70, 0x26, 0x0D,
  0xFF, 0x0E, 0x58, 0x15, 0xF4, 0x75, 0x81, 0x3F, 0x54, 0x0A, 0x0E, 0x77, 0x0D, 0x0A, 0x40, 0xE0,
  0x97, 0x70, 0x80, 0xE3, 0x81, 0x5F, 0x47, 0x78, 0x13, 0xF5, 0x20, 0xA0, 0xE7, 0x72, 0x0D, 0x0A,
  0x20, 0xE0, 0x97, 0x72, 0x82, 0x8E, 0x05, 0xFF, 0xE0, 0x50, 0x7F, 0xFE, 0x00, 0x7A, 0x81, 0xC6,
  0x9F, 0xB8, 0x19, 0x6C, 0xA8, 0x27, 0x7F, 0xE3, 0x0A, 0xF9, 0x0A, 0x38, 0x4E, 0xF7, 0x7F, 0xE3,
  0x08, 0xF9, 0x08, 0x38, 0x2E, 0xF7, 0x7A, 0x82, 0x70, 0x4E, 0xF9, 0x82, 0xE4, 0x07, 0xA0, 0x07,
  0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07,
  0x77, 0x07, 0xA0, 0x70, 0x5A, 0x05, 0x77, 0x05, 0xA0, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_car_rental() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 1, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_car_rental_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_car_repair 36x36, 4-bit Alpha,  RLE, 156 bytes.
static const unsigned char ic_filled_36_maps_car_repair_data[] PROGMEM = {
  0x40, 0x18, 0x09, 0x27, 0x01, 0x71, 0x0D, 0xFF, 0x0D, 0x78, 0x15, 0xF3, 0x75, 0x81, 0x4F, 0x56,
  0x0A, 0x0E, 0x77, 0x0E, 0x0A, 0x60, 0xE0, 0x97, 0x70, 0x90, 0xE5, 0x81, 0x5F, 0x37, 0x78, 0x14,
  0xF5, 0x40, 0xA0, 0xE7, 0x72, 0x0E, 0x0A, 0x40, 0xE0, 0x97, 0x72, 0x09, 0x0E, 0x30, 0x5F, 0xFE,
  0x05, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7A, 0x81, 0xC6, 0x9F, 0xB8, 0x19, 0x6C, 0xA0, 0x72, 0x82,
  0x7F, 0xE1, 0x20, 0xAF, 0x90, 0xA2, 0x82, 0x1E, 0xF7, 0x28, 0x17, 0xFE, 0x30, 0x8F, 0x90, 0x83,
  0x81, 0xEF, 0x72, 0x07, 0xA8, 0x27, 0x04, 0xEF, 0x98, 0x2E, 0x40, 0x7A, 0x07, 0x20, 0x7F, 0xFE,
  0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7F, 0xFE, 0x07, 0x20, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x28, 0x23, 0xEE, 0x37, 0x78, 0x23, 0xEE, 0x37, 0x77, 0x48,
  0x0A, 0x47, 0x80, 0xD4, 0xF8, 0x06, 0x70, 0xBA, 0x0B, 0x80, 0x67, 0x73, 0x07, 0xA0, 0x77, 0x76,
  0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_car_repair() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 29, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_car_repair_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_castle 36x36, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_filled_36_maps_castle_data[] PROGMEM = {
  0x68, 0x23, 0x77, 0x32, 0x82, 0x37, 0x73, 0x28, 0x23, 0x77, 0x32, 0x82, 0x37, 0x73, 0x75, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7A, 0x07, 0x20, 0x7A,
  0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x75, 0x07, 0xA8, 0x2B, 0x77, 0xBA, 0x82, 0xB7, 0x7B,
  0xA8, 0x2B, 0x77, 0xBA, 0x07, 0x75, 0x07, 0xFF, 0xE0, 0x77, 0x50, 0x7F, 0xFE, 0x07, 0x75, 0x07,
  0xFF, 0xE0, 0x77, 0x50, 0x7F, 0xFE, 0x07, 0x75, 0x07, 0xFF, 0xE0, 0x76, 0x82, 0x37, 0x73, 0x20,
  0x7D, 0x82, 0xB7, 0x7B, 0xA8, 0x2B, 0x77, 0xBD, 0x07, 0x28, 0x33, 0x77, 0x37, 0xA0, 0x72, 0x07,
  0xD0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xD0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xD0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xD0, 0x72, 0x07, 0xA0, 0x07, 0xA8, 0x2B, 0x77, 0xBD, 0x07, 0x20, 0x7A,
  0x07, 0x20, 0x7D, 0x82, 0xB7, 0x7B, 0xA0, 0x07, 0xFC, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xC0,
  0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0,
  0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0x82, 0x71, 0x17, 0xFF, 0x00, 0x7F,
  0xE0, 0x74, 0x07, 0xFE, 0x00, 0x7F, 0xE0, 0x14, 0x01, 0xFE, 0x00, 0x7F, 0xE6, 0xFE, 0x00, 0x7F,
  0xE6, 0xFE, 0x00, 0x7F, 0xE6, 0xFE, 0x00, 0x7F, 0xE6, 0xFE, 0x07, 0x03, 0x80, 0x91, 0x76, 0x80,
  0x91, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_castle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_castle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_category 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_filled_36_maps_category_data[] PROGMEM = {
  0x76, 0x00, 0x47, 0x77, 0x60, 0x0D, 0x77, 0x75, 0x08, 0xA0, 0x87, 0x77, 0x30, 0x2C, 0x02, 0x77,
  0x72, 0x0B, 0xC0, 0xB7, 0x77, 0x10, 0x5E, 0x05, 0x77, 0x60, 0x10, 0xEE, 0x0E, 0x01, 0x77, 0x50,
  0x9F, 0x90, 0x97, 0x74, 0x03, 0xFB, 0x03, 0x77, 0x30, 0xCF, 0xB0, 0xC7, 0x72, 0x06, 0xFD, 0x06,
  0x77, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x76, 0x09, 0xFF, 0x09, 0x76, 0x80, 0x94, 0x78, 0x09, 0xA1,
  0x08, 0x33, 0x67, 0x51, 0x40, 0x58, 0x07, 0xB0, 0x55, 0x05, 0x0D, 0xD0, 0x90, 0x12, 0x07, 0xFC,
  0x07, 0x40, 0x7F, 0x98, 0x2D, 0x10, 0x7F, 0xC0, 0x73, 0x05, 0xFB, 0x81, 0xC0, 0x7F, 0xC0, 0x73,
  0x0D, 0xFC, 0x05, 0x07, 0xFC, 0x07, 0x20, 0x3F, 0xD0, 0xB0, 0x7F, 0xC0, 0x72, 0x06, 0xFD, 0x0E,
  0x07, 0xFC, 0x07, 0x20, 0x7F, 0xE0, 0x7F, 0xC0, 0x72, 0x05, 0xFD, 0x0D, 0x07, 0xFC, 0x07, 0x20,
  0x1F, 0xD0, 0x90, 0x7F, 0xC0, 0x73, 0x09, 0xFC, 0x02, 0x07, 0xFC, 0x07, 0x30, 0x10, 0xDF, 0xA8,
  0x17, 0x07, 0xFC, 0x07, 0x40, 0x10, 0xCF, 0x07, 0x20, 0x18, 0x07, 0x30, 0x16, 0x85, 0x5B, 0xEF,
  0xD9, 0x23,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_category() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_category_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_celebration 36x36, 4-bit Alpha,  RLE, 269 bytes.
static const unsigned char ic_filled_36_maps_celebration_data[] PROGMEM = {
  0x77, 0x40, 0x70, 0x27, 0x77, 0x72, 0x82, 0x7F, 0xE2, 0x77, 0x77, 0x18, 0x32, 0xEF, 0xE2, 0x77,
  0x72, 0x07, 0x02, 0x48, 0x22, 0xEF, 0xC7, 0x77, 0x18, 0x27, 0xFD, 0x14, 0x03, 0xA0, 0x37, 0x77,
  0x82, 0x2E, 0xF8, 0x58, 0x1E, 0xF5, 0x48, 0x12, 0x52, 0x77, 0x18, 0x17, 0xFC, 0x40, 0x3A, 0x02,
  0x20, 0x20, 0xBB, 0x0C, 0x02, 0x76, 0x81, 0x7F, 0xC3, 0x82, 0x2E, 0xFB, 0x20, 0x20, 0xEA, 0x0D,
  0xA0, 0xE0, 0x17, 0x48, 0x22, 0xEF, 0x82, 0x89, 0x52, 0xEF, 0xE2, 0x02, 0xEF, 0xE3, 0x03, 0xE7,
  0x75, 0x81, 0x7F, 0xD2, 0x89, 0x12, 0xEF, 0xE2, 0x02, 0xEF, 0xE2, 0x30, 0x17, 0x20, 0x80, 0x13,
  0x89, 0x47, 0x20, 0x2E, 0xFE, 0x20, 0x2E, 0xFE, 0x27, 0x68, 0x21, 0xFD, 0x14, 0x89, 0x12, 0xEF,
  0xE2, 0x02, 0xEF, 0xE2, 0x77, 0x06, 0xA0, 0xD0, 0x13, 0x89, 0x07, 0xFE, 0x20, 0x2E, 0xFE, 0x27,
  0x71, 0x0B, 0xB0, 0xD0, 0x13, 0x86, 0x72, 0x02, 0xEF, 0xE2, 0x77, 0x10, 0x1D, 0x0D, 0x01, 0x48,
  0x32, 0xEF, 0xE2, 0x28, 0x12, 0x52, 0x74, 0x07, 0xE0, 0xD0, 0x13, 0x85, 0x7F, 0xE2, 0x02, 0xBB,
  0x0C, 0x02, 0x72, 0x0C, 0xF0, 0xD0, 0x13, 0x83, 0x72, 0x02, 0xEA, 0x0D, 0xA0, 0xE0, 0x27, 0x02,
  0xFA, 0x0D, 0x01, 0x48, 0x91, 0x2E, 0xFE, 0x30, 0x3E, 0xFE, 0x26, 0x08, 0xFB, 0x0D, 0x01, 0x38,
  0x27, 0xFE, 0x23, 0x82, 0x2E, 0xF8, 0x60, 0xDF, 0xC0, 0xD0, 0x13, 0x07, 0x02, 0x50, 0x20, 0x76,
  0x03, 0xFE, 0x0D, 0x01, 0x77, 0x30, 0x9F, 0xF0, 0xD0, 0x17, 0x72, 0x0E, 0xFF, 0x90, 0xD0, 0x17,
  0x70, 0x5F, 0xFB, 0x08, 0x77, 0x0A, 0xFF, 0x81, 0xB6, 0x17, 0x70, 0x1F, 0xD8, 0x1C, 0x71, 0x77,
  0x30, 0x6F, 0xA8, 0x1D, 0x82, 0x77, 0x60, 0xBE, 0x81, 0xE9, 0x37, 0x77, 0x10, 0x1D, 0x0A, 0x05,
  0x77, 0x74, 0x07, 0xA8, 0x1B, 0x61, 0x77, 0x76, 0x81, 0x97, 0x17, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_celebration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 35, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_celebration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_church 36x36, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_filled_36_maps_church_data[] PROGMEM = {
  0x76, 0x82, 0x37, 0x73, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x72, 0x82,
  0x37, 0x7B, 0xA8, 0x2B, 0x77, 0x37, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76,
  0x82, 0x37, 0x7B, 0xA8, 0x2B, 0x77, 0x37, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x75, 0x08, 0xA0, 0x87,
  0x77, 0x30, 0x30, 0xBC, 0x0B, 0x03, 0x77, 0x60, 0x30, 0xBF, 0x90, 0xB0, 0x37, 0x72, 0x03, 0x0B,
  0xFD, 0x0B, 0x03, 0x76, 0x0B, 0xFF, 0xA0, 0xB7, 0x5F, 0xFC, 0x75, 0xF9, 0x00, 0xDF, 0x97, 0x5F,
  0x06, 0x20, 0x6F, 0x75, 0xE0, 0xD4, 0x0D, 0xE7, 0x40, 0x6E, 0x0D, 0x40, 0xDE, 0x06, 0x78, 0x11,
  0x8E, 0xF9, 0x06, 0x20, 0x6F, 0x98, 0x1E, 0x81, 0x20, 0x30, 0xAF, 0xD0, 0x0D, 0xFD, 0x0A, 0x03,
  0x80, 0xA8, 0x1F, 0x82, 0xE9, 0x9E, 0xFF, 0xFC, 0x0C, 0x01, 0x20, 0x10, 0xCF, 0xFF, 0xB0, 0x34,
  0x03, 0xFF, 0xFB, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_church() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_church_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_cleaning_services 36x36, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_filled_36_maps_cleaning_services_data[] PROGMEM = {
  0x74, 0x84, 0x47, 0x77, 0x74, 0x77, 0x70, 0x9E, 0x09, 0x77, 0x50, 0x4F, 0x90, 0x47, 0x74, 0x07,
  0xF9, 0x07, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x74, 0x07, 0xF9, 0x07, 0x77, 0x40, 0x7F, 0x90, 0x77,
  0x74, 0x07, 0xF9, 0x07, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x74, 0x07, 0xF9, 0x07, 0x77, 0x40, 0x7F,
  0x90, 0x77, 0x74, 0x07, 0xF9, 0x07, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x74, 0x07, 0xF9, 0x07, 0x77,
  0x40, 0x7F, 0x90, 0x77, 0x71, 0x82, 0x57, 0x7B, 0xF9, 0x82, 0xB7, 0x75, 0x72, 0x01, 0x09, 0xFF,
  0xC0, 0x90, 0x15, 0x02, 0x0D, 0xFF, 0xE0, 0xD0, 0x23, 0x01, 0x0D, 0xB0, 0xC0, 0x98, 0x09, 0x07,
  0x09, 0x0C, 0xB0, 0xD0, 0x12, 0x09, 0xA0, 0xE0, 0x57, 0x72, 0x05, 0x0E, 0xA0, 0x92, 0xB0, 0x57,
  0x74, 0x05, 0xB1, 0x05, 0xA0, 0xC7, 0x76, 0x0C, 0xA0, 0x50, 0x6A, 0x09, 0x77, 0x60, 0x9A, 0x06,
  0x07, 0xA0, 0x77, 0x76, 0x07, 0xA0, 0x07, 0xA0, 0x73, 0x00, 0x54, 0x00, 0x54, 0x00, 0x53, 0x07,
  0xA0, 0x07, 0xA0, 0x72, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x52, 0x07, 0xA0, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA8, 0x2B, 0x77, 0xBA, 0x82, 0xB7, 0x7B, 0xA8,
  0x2B, 0x77, 0xBA, 0x82, 0xB7, 0x7B, 0xA0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x38,
  0x0A, 0x67, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_cleaning_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_cleaning_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_compass_calibration 36x36, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_filled_36_maps_compass_calibration_data[] PROGMEM = {
  0x74, 0x86, 0x25, 0x67, 0x76, 0x52, 0x77, 0x48, 0x11, 0x7B, 0xFB, 0x81, 0xB7, 0x17, 0x50, 0x30,
  0xAF, 0xFA, 0x0A, 0x03, 0x71, 0x01, 0x0A, 0xFF, 0xE0, 0xA0, 0x15, 0x06, 0x0E, 0xFF, 0xF9, 0x0E,
  0x06, 0x30, 0x9F, 0xFF, 0xD8, 0x19, 0x0A, 0xFF, 0xFF, 0x81, 0xA4, 0xEF, 0xFF, 0xD8, 0x3E, 0x30,
  0x4E, 0xFF, 0xFB, 0x0E, 0x03, 0x30, 0x40, 0xEF, 0xFF, 0x90, 0xE0, 0x35, 0x04, 0x0E, 0xFF, 0xE0,
  0xE0, 0x37, 0x04, 0x0E, 0xD8, 0x6B, 0x63, 0x22, 0x36, 0xBD, 0x0E, 0x03, 0x72, 0x04, 0x0E, 0xA0,
  0xA0, 0x27, 0x10, 0x20, 0xAA, 0x0E, 0x03, 0x74, 0x81, 0x4E, 0x67, 0x58, 0x15, 0xE3, 0x80, 0xD5,
  0x08, 0x24, 0x77, 0x47, 0x77, 0x30, 0x50, 0xDC, 0x0D, 0x05, 0x77, 0x70, 0x6F, 0x90, 0x67, 0x75,
  0x02, 0xFB, 0x02, 0x77, 0x40, 0x9F, 0xB0, 0x97, 0x74, 0x0D, 0xFB, 0x0D, 0x77, 0x4F, 0xD7, 0x74,
  0x0D, 0xFB, 0x0D, 0x77, 0x40, 0x9F, 0xB0, 0x97, 0x74, 0x02, 0xFB, 0x02, 0x77, 0x50, 0x6F, 0x90,
  0x67, 0x77, 0x05, 0x0D, 0xC0, 0xD0, 0x57, 0x77, 0x38, 0x24, 0x77, 0x47, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_compass_calibration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_compass_calibration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_connecting_airports 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_filled_36_maps_connecting_airports_data[] PROGMEM = {
  0x50, 0x01, 0x77, 0x71, 0x00, 0xD7, 0x77, 0x18, 0x18, 0xF8, 0x77, 0x70, 0x4A, 0x02, 0x77, 0x78,
  0x1E, 0xFB, 0x77, 0x70, 0xAA, 0x04, 0x77, 0x0D, 0x0C, 0x40, 0x6A, 0x0D, 0x77, 0x85, 0x8F, 0xB7,
  0x77, 0x9B, 0x84, 0xA7, 0x77, 0x75, 0x71, 0x03, 0xFF, 0x90, 0x57, 0x03, 0xFF, 0x90, 0x57, 0x85,
  0x8F, 0xB7, 0x77, 0x9B, 0x84, 0xA7, 0x77, 0x75, 0x71, 0x0D, 0x0C, 0x40, 0x6A, 0x0D, 0x77, 0x60,
  0xAA, 0x04, 0x70, 0x01, 0x74, 0x81, 0xEF, 0xB7, 0x10, 0x0D, 0x73, 0x04, 0xA0, 0x27, 0x81, 0x8F,
  0x87, 0x38, 0x18, 0xF8, 0x70, 0x2A, 0x04, 0x73, 0x00, 0xD7, 0x18, 0x1B, 0xFE, 0x74, 0x00, 0x17,
  0x04, 0xA0, 0xA7, 0x76, 0x0D, 0xA0, 0x64, 0x0C, 0x0D, 0x71, 0x84, 0x57, 0x77, 0x7A, 0xB8, 0x59,
  0x77, 0x7B, 0xF8, 0x70, 0x5F, 0xF9, 0x03, 0x70, 0x5F, 0xF9, 0x03, 0x71, 0x84, 0x57, 0x77, 0x7A,
  0xB8, 0x59, 0x77, 0x7B, 0xF8, 0x77, 0x0D, 0xA0, 0x64, 0x0C, 0x0D, 0x77, 0x04, 0xA0, 0xA7, 0x77,
  0x81, 0xBF, 0xE7, 0x77, 0x02, 0xA0, 0x47, 0x77, 0x81, 0x8F, 0x87, 0x77, 0x10, 0x0D, 0x77, 0x71,
  0x00, 0x15,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_connecting_airports() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_connecting_airports_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_crisis_alert 36x36, 4-bit Alpha,  RLE, 337 bytes.
static const unsigned char ic_filled_36_maps_crisis_alert_data[] PROGMEM = {
  0x75, 0x84, 0x19, 0xDD, 0x91, 0x77, 0x73, 0x0D, 0xC0, 0xD7, 0x77, 0x20, 0x7E, 0x07, 0x77, 0x71,
  0x0A, 0xE0, 0xA7, 0x75, 0x01, 0x20, 0xAE, 0x0A, 0x20, 0x17, 0x78, 0x15, 0xD6, 0x20, 0x7E, 0x07,
  0x28, 0x16, 0xD5, 0x74, 0x08, 0xA0, 0x92, 0x04, 0xE0, 0x42, 0x09, 0xA0, 0x87, 0x20, 0xAB, 0x0B,
  0x20, 0x1E, 0x30, 0xBB, 0x0A, 0x70, 0x9B, 0x0A, 0x40, 0xCC, 0x0C, 0x40, 0xAB, 0x09, 0x50, 0x5B,
  0x08, 0x50, 0x7C, 0x07, 0x50, 0x8B, 0x05, 0x40, 0xEA, 0x0A, 0x60, 0x3C, 0x03, 0x60, 0xAA, 0x0E,
  0x30, 0x7A, 0x0D, 0x30, 0x30, 0xD3, 0x0D, 0xA0, 0xD3, 0x0D, 0x03, 0x30, 0xDA, 0x07, 0x20, 0xEA,
  0x05, 0x28, 0x21, 0xEF, 0x42, 0x82, 0x7B, 0xB7, 0x28, 0x24, 0xFE, 0x12, 0x05, 0xA8, 0x1E, 0x04,
  0xA0, 0xD3, 0x0B, 0xA0, 0x87, 0x10, 0x8A, 0x0B, 0x30, 0xDA, 0x04, 0x08, 0xA0, 0x82, 0x03, 0xB0,
  0x27, 0x10, 0x2B, 0x03, 0x20, 0x8A, 0x08, 0x0B, 0xA0, 0x42, 0x09, 0xA0, 0x83, 0x82, 0x8D, 0xD8,
  0x30, 0x8A, 0x09, 0x20, 0x4A, 0x0B, 0x0D, 0xA0, 0x12, 0x0C, 0xA0, 0x32, 0x08, 0xC0, 0x82, 0x03,
  0xA0, 0xC2, 0x01, 0xA0, 0xD0, 0xEA, 0x30, 0xEA, 0x30, 0xDC, 0x0D, 0x3A, 0x0E, 0x3A, 0x00, 0xEA,
  0x30, 0xEA, 0x30, 0xDC, 0x0D, 0x3A, 0x0E, 0x3A, 0x0E, 0x0D, 0xA0, 0x22, 0x0D, 0xA0, 0x32, 0x08,
  0xC0, 0x82, 0x03, 0xA0, 0xD2, 0x02, 0xA0, 0xD0, 0xBA, 0x04, 0x20, 0x9A, 0x08, 0x38, 0x28, 0xDD,
  0x83, 0x08, 0xA0, 0x92, 0x04, 0xA0, 0xB0, 0x8A, 0x08, 0x20, 0x4B, 0x02, 0x71, 0x02, 0xB0, 0x42,
  0x08, 0xA0, 0x80, 0x3A, 0x0D, 0x30, 0xBA, 0x0D, 0x02, 0x60, 0x20, 0xDA, 0x0B, 0x30, 0xDA, 0x81,
  0x30, 0xEA, 0x06, 0x20, 0x20, 0xEB, 0x08, 0x03, 0x20, 0x30, 0x8B, 0x0E, 0x02, 0x20, 0x6A, 0x0E,
  0x20, 0x7A, 0x0D, 0x30, 0x30, 0xEF, 0xB0, 0xE0, 0x33, 0x0D, 0xA0, 0x73, 0x0D, 0xA0, 0xA3, 0x02,
  0x0B, 0xF9, 0x0B, 0x02, 0x30, 0xAA, 0x0D, 0x40, 0x5B, 0x08, 0x48, 0x64, 0x9D, 0xEE, 0xD9, 0x44,
  0x08, 0xB0, 0x55, 0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x08, 0x70, 0xAB, 0x0D, 0x06, 0x73, 0x06, 0x0D,
  0xB0, 0xA7, 0x20, 0x7C, 0x82, 0xD9, 0x42, 0x28, 0x22, 0x49, 0xDC, 0x07, 0x74, 0x05, 0x0D, 0xFF,
  0x0D, 0x05, 0x77, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x48, 0x90, 0x38, 0xBD, 0xEE, 0xDB, 0x83,
  0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_crisis_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_crisis_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_delivery_dining 36x36, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_filled_36_maps_delivery_dining_data[] PROGMEM = {
  0x77, 0x48, 0x01, 0x70, 0x47, 0x77, 0x3E, 0x09, 0x72, 0x07, 0xF6, 0xF0, 0x47, 0x10, 0x7F, 0x68,
  0x00, 0x70, 0xBA, 0x07, 0x71, 0x07, 0xF7, 0x30, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x10,
  0x48, 0x03, 0x77, 0x30, 0x7A, 0x07, 0x60, 0x50, 0xDF, 0x97, 0x30, 0x9A, 0x07, 0x50, 0x6F, 0xB7,
  0x20, 0x5B, 0x06, 0x40, 0x2F, 0xC7, 0x10, 0x20, 0xEA, 0x0B, 0x50, 0x9F, 0xC7, 0x01, 0x0D, 0xA0,
  0xD0, 0x15, 0x0D, 0xFC, 0x70, 0xBA, 0x0E, 0x02, 0x6F, 0xD6, 0x08, 0xB8, 0x35, 0x04, 0x74, 0x3F,
  0xD5, 0x05, 0xB8, 0x18, 0x4E, 0xB0, 0xE0, 0x41, 0xFF, 0xE0, 0xB0, 0x2F, 0x02, 0xFF, 0xD8, 0x1D,
  0x1A, 0xA8, 0x1D, 0x8D, 0xA0, 0xAF, 0xFC, 0x82, 0xE2, 0x0D, 0xA8, 0x12, 0x02, 0xA0, 0xD3, 0x0D,
  0xA8, 0x12, 0x02, 0xA0, 0xD7, 0x20, 0xDA, 0x81, 0x20, 0x2A, 0x0D, 0x30, 0xAA, 0x81, 0xD8, 0xDA,
  0x0A, 0x72, 0x0A, 0xA8, 0x1D, 0x8D, 0xA0, 0xA3, 0x02, 0xF0, 0x27, 0x20, 0x2F, 0x02, 0x40, 0x40,
  0xEB, 0x0E, 0x04, 0x74, 0x04, 0x0E, 0xB0, 0xE0, 0x47, 0x81, 0x47, 0x47, 0x71, 0x81, 0x47, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_delivery_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 32, 28), Box(0, 0, 35, 35),
      ic_filled_36_maps_delivery_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_departure_board 36x36, 4-bit Alpha,  RLE, 309 bytes.
static const unsigned char ic_filled_36_maps_departure_board_data[] PROGMEM = {
  0x77, 0x68, 0x42, 0x46, 0x75, 0x27, 0x77, 0x50, 0x60, 0xCE, 0x0D, 0x07, 0x77, 0x71, 0x03, 0x0D,
  0xFB, 0x0D, 0x03, 0x77, 0x50, 0x4C, 0x84, 0xEA, 0x88, 0xAE, 0xC0, 0x57, 0x73, 0x03, 0x0E, 0xA0,
  0xE0, 0x66, 0x06, 0x0E, 0xB0, 0x36, 0x84, 0x16, 0x9B, 0xDD, 0xF0, 0xC0, 0x12, 0x81, 0x7F, 0xB3,
  0x01, 0x0C, 0xA0, 0xD4, 0x02, 0x0A, 0xFD, 0x0E, 0x01, 0x38, 0x17, 0xFB, 0x40, 0x10, 0xEA, 0x07,
  0x20, 0x30, 0xEF, 0xE0, 0x64, 0x81, 0x7F, 0xB5, 0x06, 0xA0, 0xD2, 0x0D, 0xFE, 0x0E, 0x58, 0x17,
  0xFB, 0x60, 0xEA, 0x02, 0x04, 0xFF, 0x0A, 0x58, 0x17, 0xFB, 0x60, 0xAA, 0x05, 0x06, 0xFF, 0x08,
  0x58, 0x17, 0xFB, 0x60, 0x8A, 0x06, 0x07, 0xA0, 0x77, 0x10, 0x6A, 0x08, 0x58, 0x27, 0xFD, 0x35,
  0x08, 0xA0, 0x07, 0xA0, 0x77, 0x10, 0x5A, 0x0A, 0x50, 0x5B, 0x09, 0x01, 0x30, 0xAA, 0x05, 0x07,
  0xA0, 0x77, 0x10, 0x2A, 0x0E, 0x60, 0x20, 0xAA, 0x0E, 0x06, 0x20, 0xEA, 0x02, 0x07, 0xA0, 0x77,
  0x20, 0xDA, 0x06, 0x78, 0x44, 0xDF, 0xA0, 0x6A, 0x81, 0xD0, 0x7A, 0x07, 0x72, 0x06, 0xA0, 0xE0,
  0x17, 0x18, 0x27, 0x11, 0xEA, 0x81, 0x60, 0x7A, 0x07, 0x73, 0x0D, 0xA0, 0xC0, 0x17, 0x10, 0x10,
  0xCA, 0x0D, 0x20, 0x7A, 0x07, 0x73, 0x03, 0x0E, 0xA0, 0xE0, 0x66, 0x06, 0x0E, 0xB0, 0x32, 0x07,
  0xA0, 0xB8, 0x07, 0x70, 0xBC, 0x84, 0xEA, 0x88, 0xAE, 0xC0, 0x43, 0x07, 0xFF, 0xFE, 0x0D, 0x03,
  0x40, 0x7F, 0xFF, 0xC0, 0xD0, 0x66, 0x07, 0xFF, 0xFA, 0x0A, 0x02, 0x71, 0x07, 0xFF, 0xFA, 0x07,
  0x72, 0x07, 0xB8, 0x26, 0x02, 0xCF, 0xA8, 0x2C, 0x20, 0x6B, 0x07, 0x72, 0x07, 0xA0, 0xA3, 0x02,
  0xFA, 0x02, 0x30, 0xAA, 0x07, 0x72, 0x07, 0xA0, 0x83, 0x01, 0xFA, 0x01, 0x30, 0x8A, 0x07, 0x72,
  0x06, 0xA0, 0xD3, 0x06, 0xFA, 0x06, 0x30, 0xDA, 0x06, 0x72, 0x03, 0xB8, 0x1D, 0x8A, 0xFC, 0x81,
  0xA8, 0xDB, 0x03, 0x73, 0x0A, 0xFF, 0xF0, 0xA7, 0x5F, 0xFF, 0x76, 0xC0, 0xB8, 0x07, 0x70, 0xBC,
  0x76, 0xC0, 0x77, 0x40, 0x7C, 0x76, 0x0D, 0xB0, 0x57, 0x40, 0x5B, 0x0D, 0x76, 0x82, 0x27, 0x75,
  0x76, 0x82, 0x57, 0x72, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_departure_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_departure_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_design_services 36x36, 4-bit Alpha,  RLE, 249 bytes.
static const unsigned char ic_filled_36_maps_design_services_data[] PROGMEM = {
  0x58, 0x13, 0x52, 0x76, 0x81, 0x27, 0x27, 0x10, 0xAB, 0x08, 0x74, 0x83, 0x3E, 0xFE, 0x36, 0x0B,
  0xD0, 0x97, 0x20, 0x30, 0xEB, 0x0E, 0x03, 0x40, 0xBB, 0x0C, 0xB0, 0x97, 0x01, 0x0E, 0xD0, 0xE0,
  0x32, 0x0A, 0xB8, 0x17, 0x0A, 0xB0, 0x97, 0x07, 0xE8, 0x1E, 0x23, 0xB0, 0x73, 0x0E, 0xB0, 0x93,
  0x03, 0x04, 0x20, 0x7E, 0x07, 0x06, 0xA0, 0xC3, 0x0A, 0xD8, 0x49, 0x03, 0xEF, 0x52, 0x07, 0xC8,
  0x1E, 0x23, 0xB8, 0x29, 0x03, 0xEA, 0x0C, 0xB0, 0xA0, 0xEB, 0x05, 0x20, 0x7A, 0x0E, 0x03, 0x20,
  0x8B, 0x85, 0x90, 0x3E, 0x70, 0x9F, 0x90, 0x52, 0x81, 0x7E, 0x34, 0x09, 0xB8, 0x19, 0x02, 0x30,
  0xAF, 0x90, 0x52, 0x01, 0x60, 0x9B, 0x0A, 0x30, 0x30, 0xEF, 0xA0, 0x47, 0x20, 0x9B, 0x82, 0xA0,
  0x3E, 0xFA, 0x0E, 0x03, 0x73, 0x09, 0xB0, 0xA0, 0xEF, 0xA0, 0xE0, 0x37, 0x50, 0x9F, 0xE0, 0xA7,
  0x70, 0xAF, 0xE0, 0x97, 0x50, 0x30, 0xEF, 0xA0, 0xE0, 0xAB, 0x09, 0x73, 0x03, 0x0E, 0xFA, 0x82,
  0xE3, 0x09, 0xB0, 0x97, 0x10, 0x30, 0xEF, 0xA0, 0xE0, 0x33, 0x0C, 0xB0, 0x96, 0x03, 0x0E, 0xFB,
  0x0A, 0x30, 0x7D, 0x09, 0x40, 0x30, 0xEF, 0xD8, 0x29, 0x02, 0xEA, 0x0D, 0xB0, 0x82, 0x03, 0x0E,
  0xFA, 0x0E, 0x0A, 0xB8, 0x59, 0x03, 0xEA, 0x09, 0xB8, 0x12, 0x2E, 0xFA, 0x82, 0xE3, 0x09, 0xB8,
  0x19, 0x03, 0x30, 0xCA, 0x05, 0x07, 0xFA, 0x0E, 0x03, 0x30, 0x9B, 0x09, 0x30, 0x7B, 0x03, 0x07,
  0xF9, 0x0E, 0x03, 0x50, 0x9B, 0x81, 0x90, 0x7B, 0x81, 0xA0, 0x7F, 0x0E, 0x03, 0x70, 0x9B, 0x0C,
  0xB0, 0xB2, 0x07, 0xE0, 0xE0, 0x37, 0x20, 0x9D, 0x0B, 0x30, 0x7D, 0x0E, 0x03, 0x74, 0x08, 0xB0,
  0xA4, 0x03, 0x80, 0x17, 0x02, 0x76, 0x81, 0x25, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_design_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_design_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_diamond 36x36, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_filled_36_maps_diamond_data[] PROGMEM = {
  0x40, 0x48, 0x03, 0x72, 0x00, 0x22, 0x80, 0x37, 0x04, 0x70, 0x10, 0xEE, 0x0B, 0x20, 0x0B, 0x20,
  0xBE, 0x0E, 0x01, 0x60, 0x7F, 0x81, 0x30, 0x3A, 0x81, 0x30, 0x3F, 0x07, 0x60, 0xEE, 0x0B, 0x20,
  0xBA, 0x0B, 0x20, 0xBE, 0x0E, 0x50, 0x7F, 0x81, 0x30, 0x3C, 0x81, 0x30, 0x3F, 0x07, 0x40, 0xEE,
  0x0B, 0x20, 0xBC, 0x0B, 0x20, 0xBE, 0x0E, 0x30, 0x7F, 0x81, 0x30, 0x3E, 0x81, 0x30, 0x3F, 0x07,
  0x20, 0xEE, 0x0B, 0x20, 0xBE, 0x0B, 0x20, 0xBE, 0x81, 0xE0, 0x18, 0x03, 0x50, 0x22, 0x80, 0x45,
  0x20, 0x28, 0x03, 0x50, 0x17, 0x77, 0x73, 0x80, 0x91, 0x52, 0x80, 0x91, 0x52, 0x05, 0xFC, 0x0D,
  0x20, 0xDF, 0xC0, 0x53, 0x07, 0xFB, 0x0D, 0x20, 0xDF, 0xB0, 0x75, 0x0A, 0xFA, 0x0D, 0x20, 0xDF,
  0xA0, 0xA7, 0x0C, 0xF9, 0x0D, 0x20, 0xDF, 0x90, 0xC7, 0x10, 0x10, 0xDF, 0x0D, 0x20, 0xDF, 0x0D,
  0x01, 0x72, 0x03, 0x0E, 0xE0, 0xD2, 0x0D, 0xE0, 0xE0, 0x37, 0x40, 0x5E, 0x0D, 0x20, 0xDE, 0x05,
  0x76, 0x07, 0xD0, 0xD2, 0x0D, 0xD0, 0x77, 0x71, 0x0A, 0xC0, 0xD2, 0x0D, 0xC0, 0xA7, 0x73, 0x0C,
  0xB0, 0xD2, 0x0D, 0xB0, 0xC7, 0x74, 0x01, 0x0D, 0xA0, 0xD2, 0x0D, 0xA0, 0xD0, 0x17, 0x75, 0x82,
  0x3E, 0xFD, 0x28, 0x2D, 0xFE, 0x37, 0x77, 0x81, 0x5F, 0xD2, 0x81, 0xDF, 0x57, 0x77, 0x20, 0x70,
  0xD2, 0x0D, 0x07, 0x77, 0x74, 0x08, 0x20, 0x87, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_diamond() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_diamond_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_dinner_dining 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_filled_36_maps_dinner_dining_data[] PROGMEM = {
  0x10, 0x38, 0x05, 0x70, 0x37, 0x75, 0x07, 0xFB, 0x07, 0x77, 0x69, 0x82, 0x70, 0xF7, 0x20, 0x7A,
  0x03, 0x77, 0x38, 0x90, 0x37, 0xFB, 0x7F, 0xB7, 0x7B, 0xA0, 0xB8, 0x09, 0x27, 0x03, 0x20, 0x7F,
  0xFF, 0xD0, 0x74, 0x98, 0x27, 0x0F, 0x72, 0x07, 0xA0, 0x57, 0x73, 0x89, 0x23, 0x7F, 0xB7, 0xFB,
  0x77, 0xBF, 0xD7, 0x74, 0x07, 0xFA, 0x0B, 0x02, 0x77, 0x69, 0x82, 0x70, 0xF7, 0x77, 0x74, 0x98,
  0x27, 0x0F, 0x77, 0x77, 0x49, 0x82, 0x70, 0xF7, 0x77, 0x74, 0x98, 0x27, 0x0F, 0x77, 0x77, 0x49,
  0x82, 0x70, 0xF7, 0x77, 0x74, 0x98, 0x27, 0x0F, 0x77, 0x77, 0x49, 0x82, 0x70, 0xF7, 0x78, 0x63,
  0x9C, 0xEE, 0xC7, 0x17, 0x39, 0x82, 0x70, 0xF7, 0x50, 0x10, 0xBF, 0x0E, 0x07, 0x72, 0x98, 0x27,
  0x0F, 0x74, 0x02, 0x0D, 0xFB, 0x09, 0x71, 0x98, 0x27, 0x0F, 0x74, 0x0D, 0xFD, 0x07, 0x79, 0x86,
  0x70, 0xFB, 0x75, 0x17, 0xFE, 0x0E, 0x01, 0x69, 0x0C, 0x0D, 0xFF, 0xE0, 0x76, 0xFF, 0xFA, 0x0C,
  0x50, 0x7F, 0xFF, 0xA0, 0xE4, 0x01, 0x0E, 0xFF, 0xFB, 0x77, 0x77, 0x50, 0x58, 0x0B, 0x07, 0x81,
  0x51, 0xDF, 0xFF, 0xD8, 0x3D, 0x10, 0x1D, 0xFF, 0xFB, 0x0D, 0x01, 0x30, 0x18, 0x0A, 0x47, 0x01,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_dinner_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_dinner_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_bike 36x36, 4-bit Alpha,  RLE, 318 bytes.
static const unsigned char ic_filled_36_maps_directions_bike_data[] PROGMEM = {
  0x77, 0x78, 0x22, 0x9A, 0x67, 0x77, 0x73, 0x02, 0x0E, 0xB0, 0x97, 0x77, 0x72, 0x09, 0xD0, 0x17,
  0x77, 0x71, 0x0A, 0xD0, 0x27, 0x77, 0x71, 0x06, 0xC0, 0xD7, 0x77, 0x58, 0x41, 0x66, 0x20, 0x9A,
  0x0D, 0x03, 0x77, 0x74, 0x03, 0x0E, 0xB8, 0x27, 0x01, 0x37, 0x77, 0x50, 0x30, 0xED, 0x07, 0x77,
  0x76, 0x03, 0x0E, 0xF0, 0x77, 0x77, 0x40, 0x30, 0xEF, 0xA0, 0x87, 0x77, 0x20, 0x30, 0xEE, 0x07,
  0x0C, 0xB0, 0xB0, 0x37, 0x77, 0x0D, 0xE0, 0x62, 0x0B, 0xC8, 0x1D, 0x95, 0x77, 0x30, 0x2E, 0x06,
  0x40, 0x8D, 0x0A, 0x77, 0x4D, 0x07, 0x68, 0x12, 0xAE, 0xA0, 0xA7, 0x74, 0x08, 0xC0, 0xC0, 0x17,
  0x18, 0x14, 0x55, 0x77, 0x50, 0x7C, 0x0C, 0x01, 0x77, 0x78, 0x55, 0xBD, 0xFD, 0xB5, 0x20, 0x5C,
  0x0C, 0x68, 0x55, 0xBD, 0xFD, 0xB5, 0x60, 0x20, 0xCF, 0x83, 0xC2, 0x04, 0xEB, 0x07, 0x30, 0x20,
  0xCF, 0x0C, 0x02, 0x30, 0x20, 0xEA, 0x83, 0xA6, 0x36, 0xAA, 0x83, 0xE2, 0x02, 0xDA, 0x07, 0x20,
  0x20, 0xEA, 0x83, 0xA6, 0x36, 0xAA, 0x0E, 0x02, 0x28, 0x2C, 0xFE, 0x45, 0x82, 0x4E, 0xFC, 0x20,
  0x7A, 0x07, 0x28, 0x2C, 0xFE, 0x45, 0x84, 0x4E, 0xFC, 0x05, 0xA0, 0x47, 0x04, 0xA8, 0x15, 0x07,
  0xA8, 0x17, 0x05, 0xA0, 0x47, 0x04, 0xA8, 0x25, 0xAF, 0xA7, 0x28, 0x3A, 0xFA, 0x07, 0xA8, 0x37,
  0x0A, 0xFA, 0x72, 0x84, 0xAF, 0xAD, 0xF5, 0x72, 0x83, 0x5F, 0xD0, 0x7A, 0x83, 0x70, 0xDF, 0x57,
  0x28, 0x15, 0xFD, 0xA0, 0x47, 0x20, 0x4A, 0x10, 0x7A, 0x07, 0x1A, 0x04, 0x72, 0x04, 0xA8, 0x1D,
  0xF5, 0x72, 0x83, 0x5F, 0xD0, 0x7A, 0x83, 0x70, 0xDF, 0x57, 0x28, 0x45, 0xFD, 0xAF, 0xA7, 0x28,
  0x3A, 0xFA, 0x07, 0xA8, 0x37, 0x0A, 0xFA, 0x72, 0x82, 0xAF, 0xA5, 0xA0, 0x47, 0x04, 0xA8, 0x65,
  0x03, 0x77, 0x30, 0x5A, 0x04, 0x70, 0x4A, 0x84, 0x50, 0xCF, 0xE4, 0x58, 0x24, 0xEF, 0xC7, 0x18,
  0x2C, 0xFE, 0x45, 0x82, 0x4E, 0xFC, 0x20, 0x20, 0xEA, 0x83, 0xA6, 0x36, 0xAA, 0x0E, 0x02, 0x71,
  0x02, 0x0E, 0xA8, 0x3A, 0x63, 0x6A, 0xA0, 0xE0, 0x23, 0x02, 0x0C, 0xF0, 0xC0, 0x27, 0x30, 0x20,
  0xCF, 0x0C, 0x02, 0x68, 0x55, 0xBD, 0xFD, 0xB5, 0x77, 0x85, 0x5B, 0xDF, 0xDB, 0x54,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 35, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_boat_filled 36x36, 4-bit Alpha,  RLE, 207 bytes.
static const unsigned char ic_filled_36_maps_directions_boat_filled_data[] PROGMEM = {
  0x73, 0x03, 0x80, 0x47, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60,
  0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x08, 0x0D, 0xFF, 0xC0, 0xD0, 0x87, 0x08, 0xFF,
  0xF9, 0x08, 0x60, 0xDF, 0xFF, 0x90, 0xD6, 0xB7, 0x74, 0xB6, 0xB7, 0x74, 0xB6, 0xB7, 0x74, 0xB6,
  0xB6, 0x84, 0x27, 0xDD, 0x72, 0x6B, 0x6B, 0x38, 0x13, 0x8D, 0xE8, 0x1D, 0x83, 0x3B, 0x6B, 0x81,
  0x38, 0xDF, 0xD8, 0x1D, 0x83, 0xB6, 0xFF, 0xFB, 0x38, 0x12, 0x9D, 0xFF, 0xFB, 0x82, 0xD9, 0x2D,
  0xFF, 0xFF, 0x00, 0xDF, 0xFF, 0xF0, 0xD0, 0x9F, 0xFF, 0xF0, 0x90, 0x5F, 0xFF, 0xF0, 0x50, 0x1F,
  0xFF, 0xF8, 0x11, 0x0C, 0xFF, 0xFD, 0x0C, 0x20, 0x7F, 0xFF, 0xD0, 0x72, 0x03, 0xFF, 0xFD, 0x03,
  0x30, 0xED, 0x00, 0xDF, 0xB0, 0x0D, 0xD0, 0xE4, 0x09, 0xC8, 0x2C, 0x11, 0xCF, 0x98, 0x2C, 0x11,
  0xCC, 0x09, 0x40, 0x5A, 0x0E, 0x07, 0x40, 0x70, 0xEC, 0x0E, 0x07, 0x40, 0x70, 0xEA, 0x05, 0x48,
  0x11, 0x64, 0x71, 0x82, 0x46, 0x64, 0x71, 0x81, 0x46, 0x17, 0x30, 0x03, 0x73, 0x00, 0x37, 0x70,
  0x20, 0x9A, 0x09, 0x03, 0x60, 0x30, 0x9A, 0x09, 0x02, 0x60, 0xF7, 0x81, 0x8A, 0xDE, 0x84, 0xDA,
  0x99, 0xAD, 0xE8, 0x1D, 0xA8, 0x0F, 0x78, 0x0C, 0x0F, 0x84, 0xEA, 0x33, 0x8E, 0xE8, 0x4E, 0x83,
  0x3A, 0xEE, 0x80, 0x07, 0x05, 0x03, 0x68, 0x42, 0x46, 0x64, 0x26, 0x03, 0x05, 0x80, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_boat_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_boat_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_boat 36x36, 4-bit Alpha,  RLE, 207 bytes.
static const unsigned char ic_filled_36_maps_directions_boat_data[] PROGMEM = {
  0x73, 0x03, 0x80, 0x47, 0x03, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x60,
  0x7F, 0x90, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x08, 0x0D, 0xFF, 0xC0, 0xD0, 0x87, 0x08, 0xFF,
  0xF9, 0x08, 0x60, 0xDF, 0xFF, 0x90, 0xD6, 0xB7, 0x74, 0xB6, 0xB7, 0x74, 0xB6, 0xB7, 0x74, 0xB6,
  0xB6, 0x84, 0x27, 0xDD, 0x72, 0x6B, 0x6B, 0x38, 0x13, 0x8D, 0xE8, 0x1D, 0x83, 0x3B, 0x6B, 0x81,
  0x38, 0xDF, 0xD8, 0x1D, 0x83, 0xB6, 0xFF, 0xFB, 0x38, 0x12, 0x9D, 0xFF, 0xFB, 0x82, 0xD9, 0x2D,
  0xFF, 0xFF, 0x00, 0xDF, 0xFF, 0xF0, 0xD0, 0x9F, 0xFF, 0xF0, 0x90, 0x5F, 0xFF, 0xF0, 0x50, 0x1F,
  0xFF, 0xF8, 0x11, 0x0C, 0xFF, 0xFD, 0x0B, 0x20, 0x7F, 0xFF, 0xD0, 0x72, 0x03, 0xFF, 0xFD, 0x03,
  0x30, 0xED, 0x00, 0xDF, 0xB0, 0x0D, 0xD0, 0xE4, 0x09, 0xC8, 0x2C, 0x11, 0xCF, 0x98, 0x2C, 0x11,
  0xCC, 0x09, 0x40, 0x5A, 0x0E, 0x07, 0x40, 0x70, 0xEC, 0x0E, 0x07, 0x40, 0x70, 0xEA, 0x05, 0x48,
  0x11, 0x64, 0x71, 0x82, 0x46, 0x64, 0x71, 0x81, 0x46, 0x17, 0x30, 0x03, 0x73, 0x00, 0x37, 0x70,
  0x20, 0x9A, 0x09, 0x03, 0x60, 0x30, 0x9A, 0x09, 0x02, 0x60, 0xF7, 0x81, 0x8A, 0xDE, 0x84, 0xDA,
  0x99, 0xAD, 0xE8, 0x1D, 0xA8, 0x0F, 0x78, 0x0C, 0x0F, 0x84, 0xEA, 0x33, 0x8E, 0xE8, 0x4E, 0x83,
  0x3A, 0xEE, 0x80, 0x07, 0x05, 0x03, 0x68, 0x42, 0x46, 0x64, 0x26, 0x03, 0x05, 0x80, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_boat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_boat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_bus_filled 36x36, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_filled_36_maps_directions_bus_filled_data[] PROGMEM = {
  0x48, 0x42, 0x79, 0xCD, 0xEC, 0x84, 0xED, 0xCA, 0x73, 0x60, 0x50, 0xCF, 0xFA, 0x0E, 0x06, 0x30,
  0x8F, 0xFE, 0x81, 0xA0, 0x5F, 0xFF, 0x90, 0x50, 0xBF, 0xFF, 0x90, 0xC0, 0xEF, 0xFF, 0x90, 0xEF,
  0xFF, 0xE8, 0x09, 0x67, 0xE7, 0x74, 0xE7, 0x74, 0xE7, 0x74, 0xE7, 0x74, 0x80, 0x9C, 0x4F, 0x81,
  0xD8, 0xAF, 0x98, 0x1A, 0x8D, 0xFA, 0x0D, 0x30, 0x6E, 0x06, 0x30, 0xDF, 0x90, 0x83, 0x01, 0xE0,
  0x13, 0x08, 0xF9, 0x0A, 0x30, 0x2E, 0x02, 0x30, 0xAF, 0xA8, 0x26, 0x02, 0xCE, 0x82, 0xC2, 0x06,
  0xD0, 0xCF, 0xFF, 0x90, 0xC0, 0x7F, 0xFF, 0x98, 0x17, 0x0C, 0xFF, 0xE0, 0xC2, 0x07, 0xFF, 0xE0,
  0x72, 0x07, 0xC8, 0x09, 0x07, 0xC0, 0x72, 0x07, 0xC7, 0x5C, 0x07, 0x20, 0x5B, 0x0D, 0x75, 0x0D,
  0xB0, 0x53, 0x82, 0x57, 0x72, 0x75, 0x82, 0x27, 0x75, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_bus_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_bus_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_bus 36x36, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_filled_36_maps_directions_bus_data[] PROGMEM = {
  0x48, 0x43, 0x7A, 0xCD, 0xEC, 0x84, 0xED, 0xCA, 0x73, 0x60, 0x60, 0xEF, 0xFA, 0x0E, 0x06, 0x30,
  0xAF, 0xFE, 0x81, 0xA0, 0x5F, 0xFF, 0x90, 0x50, 0xCF, 0xFF, 0x90, 0xC0, 0xEF, 0xFF, 0x90, 0xEB,
  0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x77, 0x4E, 0x80, 0x96,
  0x78, 0x09, 0xC2, 0xF8, 0x2C, 0x20, 0x6F, 0xB8, 0x26, 0x02, 0xCE, 0x02, 0x30, 0xAF, 0x90, 0xA3,
  0x02, 0xE0, 0x13, 0x08, 0xF9, 0x08, 0x30, 0x1B, 0x0E, 0xA0, 0x63, 0x0D, 0xF9, 0x0D, 0x30, 0x6A,
  0x0E, 0x0B, 0xB8, 0x1A, 0x8D, 0xFB, 0x81, 0xD8, 0xAB, 0x0B, 0x03, 0xFF, 0xF9, 0x81, 0x30, 0x8F,
  0xFE, 0x08, 0x20, 0x7C, 0x80, 0x90, 0x7C, 0x07, 0x20, 0x7C, 0x75, 0xC0, 0x72, 0x05, 0xB0, 0xD7,
  0x50, 0xDB, 0x05, 0x38, 0x25, 0x77, 0x27, 0x58, 0x22, 0x77, 0x52,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_bus() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_bus_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_car_filled 36x36, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_filled_36_maps_directions_car_filled_data[] PROGMEM = {
  0x40, 0x28, 0x09, 0x67, 0x02, 0x70, 0x10, 0xEF, 0xFC, 0x0E, 0x02, 0x60, 0x8F, 0xFE, 0x08, 0x60,
  0xDA, 0x09, 0x80, 0x92, 0x70, 0x9A, 0x0D, 0x50, 0x3A, 0x0E, 0x77, 0x20, 0xEA, 0x03, 0x40, 0x9A,
  0x09, 0x77, 0x20, 0x9A, 0x09, 0x40, 0xEA, 0x03, 0x77, 0x20, 0x3A, 0x0E, 0x30, 0x4A, 0x0D, 0x77,
  0x40, 0xDA, 0x04, 0x20, 0x9F, 0xFF, 0xB0, 0x92, 0x0E, 0xFF, 0xFB, 0x81, 0xE0, 0x5F, 0xFF, 0xD0,
  0x50, 0x7F, 0xFF, 0xD0, 0x07, 0xD8, 0x1A, 0x8D, 0xFB, 0x81, 0xD8, 0xAD, 0x00, 0x7C, 0x06, 0x30,
  0xDF, 0x90, 0xD3, 0x06, 0xC0, 0x07, 0xC0, 0x13, 0x08, 0xF9, 0x08, 0x30, 0x1C, 0x00, 0x7C, 0x02,
  0x30, 0xAF, 0x90, 0xA3, 0x02, 0xC0, 0x07, 0xC8, 0x2C, 0x20, 0x6F, 0xB8, 0x26, 0x02, 0xCC, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7C, 0x80,
  0x96, 0x7C, 0x00, 0x7C, 0x77, 0x4C, 0x07, 0x05, 0xB0, 0xD7, 0x74, 0x0D, 0xB8, 0x45, 0x05, 0x77,
  0x27, 0x74, 0x82, 0x27, 0x75, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_car_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_car_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_car 36x36, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_filled_36_maps_directions_car_data[] PROGMEM = {
  0x40, 0x28, 0x09, 0x67, 0x02, 0x70, 0x10, 0xEF, 0xFC, 0x0E, 0x02, 0x68, 0x18, 0xFE, 0x80, 0x94,
  0xB8, 0x1E, 0xF8, 0x68, 0x1D, 0xF7, 0x77, 0x28, 0x17, 0xFD, 0x50, 0x3A, 0x02, 0x77, 0x20, 0x2A,
  0x03, 0x48, 0x19, 0xFC, 0x77, 0x48, 0x1C, 0xF9, 0x48, 0x1E, 0xF7, 0x77, 0x48, 0x17, 0xFE, 0x30,
  0x4A, 0x02, 0x77, 0x40, 0x2A, 0x04, 0x28, 0x19, 0xFC, 0x77, 0x68, 0x1C, 0xF9, 0x28, 0x1E, 0xFC,
  0x80, 0xA0, 0x78, 0x3C, 0xFE, 0x05, 0xFF, 0xFD, 0x05, 0x07, 0xFF, 0xFD, 0x00, 0x7B, 0x81, 0xD8,
  0xAF, 0xF8, 0x1A, 0x8D, 0xB0, 0x07, 0xA0, 0xD3, 0x06, 0xFD, 0x06, 0x30, 0xDA, 0x00, 0x7A, 0x08,
  0x30, 0x1F, 0xD0, 0x13, 0x08, 0xA0, 0x07, 0xA0, 0xA3, 0x02, 0xFD, 0x02, 0x30, 0xAA, 0x00, 0x7B,
  0x82, 0x60, 0x2C, 0xFD, 0x82, 0xC2, 0x06, 0xB0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x09, 0x67, 0xC0, 0x07, 0xC7, 0x74, 0xC0, 0x70,
  0x5B, 0x0D, 0x77, 0x40, 0xDB, 0x84, 0x50, 0x57, 0x72, 0x77, 0x48, 0x22, 0x77, 0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_car() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_car_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions 36x36, 4-bit Alpha,  RLE, 157 bytes.
static const unsigned char ic_filled_36_maps_directions_data[] PROGMEM = {
  0x76, 0x82, 0x8D, 0xD8, 0x77, 0x74, 0x0A, 0xC0, 0xB7, 0x77, 0x20, 0xAE, 0x0B, 0x77, 0x70, 0xAF,
  0x90, 0xB7, 0x75, 0x0A, 0xFB, 0x0B, 0x77, 0x30, 0xAF, 0xD0, 0xB7, 0x71, 0x0B, 0xFF, 0x0B, 0x76,
  0x0B, 0xFF, 0xA0, 0xB7, 0x40, 0xBF, 0xC0, 0xBE, 0x0A, 0x72, 0x0B, 0xFD, 0x03, 0x07, 0xE0, 0xA7,
  0x0B, 0xFE, 0x81, 0x30, 0x7E, 0x0A, 0x50, 0xBF, 0xF0, 0x32, 0x07, 0xE0, 0xA3, 0x0B, 0xF0, 0x77,
  0x40, 0x7E, 0x81, 0xA0, 0x8F, 0x97, 0x60, 0xBE, 0x08, 0x0E, 0xF9, 0x75, 0x07, 0xF0, 0xD0, 0xEF,
  0x93, 0xD0, 0x32, 0x07, 0xF9, 0x0E, 0x08, 0xF9, 0x3D, 0x81, 0x30, 0x7F, 0xA8, 0x18, 0x0B, 0xF3,
  0xD0, 0x30, 0x7F, 0xA0, 0xB3, 0x0B, 0xE3, 0xD0, 0xBF, 0xA0, 0xB5, 0x0B, 0xD0, 0xF7, 0xFF, 0x0B,
  0x70, 0xBF, 0xFE, 0x0B, 0x72, 0x0B, 0xFF, 0xC0, 0xB7, 0x40, 0xBF, 0xFA, 0x0B, 0x76, 0x0B, 0xFF,
  0x0B, 0x77, 0x10, 0xBF, 0xD0, 0xB7, 0x73, 0x0B, 0xFB, 0x0B, 0x77, 0x50, 0xBF, 0x90, 0xB7, 0x77,
  0x0B, 0xE0, 0xB7, 0x77, 0x20, 0xBC, 0x0B, 0x77, 0x74, 0x82, 0x8E, 0xE8, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_railway_filled 36x36, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_filled_36_maps_directions_railway_filled_data[] PROGMEM = {
  0x48, 0x42, 0x79, 0xCD, 0xEC, 0x84, 0xED, 0xCA, 0x73, 0x60, 0x50, 0xCF, 0xFA, 0x0E, 0x06, 0x30,
  0x8F, 0xFE, 0x81, 0xA0, 0x5F, 0xFF, 0x90, 0x50, 0xBF, 0xFF, 0x90, 0xC0, 0xEF, 0xFF, 0x90, 0xEF,
  0xFF, 0xE8, 0x09, 0x67, 0xE7, 0x74, 0xE7, 0x74, 0xE7, 0x74, 0xE7, 0x74, 0x80, 0x9D, 0x1F, 0x82,
  0xE9, 0x9E, 0xFF, 0xE0, 0x32, 0x03, 0xFF, 0xD0, 0xC4, 0x0C, 0xFF, 0xC0, 0xE4, 0x0E, 0xFF, 0xD8,
  0x29, 0x11, 0x9F, 0xB0, 0xCF, 0xFF, 0x90, 0xC0, 0x7F, 0xFF, 0x98, 0x17, 0x0C, 0xFF, 0xE0, 0xC2,
  0x01, 0x0A, 0xFF, 0xC0, 0xA0, 0x14, 0x02, 0x07, 0xFF, 0x07, 0x02, 0x60, 0x50, 0xEF, 0xF0, 0xE0,
  0x56, 0xFF, 0xC6, 0x80, 0x96, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_railway_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_railway_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_railway 36x36, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_filled_36_maps_directions_railway_data[] PROGMEM = {
  0x68, 0x12, 0x45, 0x80, 0x27, 0x81, 0x54, 0x27, 0x20, 0x60, 0xBF, 0xF0, 0xB0, 0x64, 0x03, 0x0D,
  0xFF, 0xC8, 0x3D, 0x30, 0x2E, 0xFF, 0xE8, 0x1E, 0x29, 0xFF, 0xF9, 0x09, 0x0D, 0xFF, 0xF9, 0x0D,
  0xB8, 0x09, 0x67, 0xE7, 0x74, 0xE7, 0x74, 0xE7, 0x74, 0xE7, 0x74, 0xE7, 0x74, 0xE7, 0x74, 0xE7,
  0x74, 0x80, 0x9D, 0x1F, 0x82, 0xE9, 0x9E, 0xFF, 0xD0, 0xC0, 0x12, 0x01, 0x0C, 0xFF, 0xC0, 0x34,
  0x03, 0xFF, 0xC6, 0xFF, 0xC0, 0x34, 0x03, 0xFA, 0x0C, 0xF9, 0x0C, 0x01, 0x20, 0x10, 0xCF, 0x90,
  0xC0, 0x7F, 0xA8, 0x2E, 0x99, 0xEF, 0xA8, 0x17, 0x0C, 0xFF, 0xE0, 0xC2, 0x01, 0x0A, 0xFF, 0xC0,
  0xA0, 0x14, 0x02, 0x07, 0xFF, 0x07, 0x02, 0x70, 0xBF, 0xF0, 0xB7, 0x0B, 0xFF, 0xA0, 0xB6, 0x80,
  0x96, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_railway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_railway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_run 36x36, 4-bit Alpha,  RLE, 185 bytes.
static const unsigned char ic_filled_36_maps_directions_run_data[] PROGMEM = {
  0x77, 0x82, 0x29, 0xB6, 0x77, 0x60, 0x2C, 0x09, 0x77, 0x50, 0x9D, 0x01, 0x77, 0x40, 0xAD, 0x02,
  0x77, 0x40, 0x6C, 0x0D, 0x77, 0x60, 0x9A, 0x0D, 0x03, 0x77, 0x70, 0x10, 0x27, 0x75, 0x83, 0x5B,
  0xFE, 0x87, 0x73, 0x81, 0x17, 0xDD, 0x08, 0x77, 0x03, 0x0A, 0xFA, 0x03, 0x75, 0x0C, 0xFC, 0x0C,
  0x75, 0xC0, 0xC0, 0xAF, 0x08, 0x74, 0xB8, 0x12, 0x08, 0xF9, 0x06, 0x73, 0xB2, 0x0B, 0xD0, 0xEB,
  0x0A, 0x02, 0x71, 0xB2, 0x0E, 0xD0, 0x20, 0xCC, 0x81, 0xCA, 0x45, 0xB1, 0x02, 0xD8, 0x2D, 0x01,
  0x9D, 0x07, 0x5B, 0x10, 0x5D, 0x0A, 0x38, 0x13, 0xAE, 0xA0, 0x75, 0x0F, 0x71, 0x08, 0xD0, 0x76,
  0x81, 0x35, 0x37, 0x20, 0xBD, 0x0A, 0x77, 0x40, 0xEE, 0x0A, 0x77, 0x20, 0x1B, 0x0C, 0xC0, 0xA7,
  0x71, 0x05, 0xB0, 0x10, 0x8C, 0x07, 0x68, 0x42, 0xEA, 0x74, 0x12, 0x08, 0xA0, 0xD2, 0x08, 0xB0,
  0x76, 0x05, 0xD8, 0x1D, 0xAD, 0xA0, 0xA3, 0x09, 0xA0, 0x76, 0x08, 0xFB, 0x06, 0x30, 0x7A, 0x07,
  0x78, 0x23, 0x69, 0xCE, 0x03, 0x30, 0x7A, 0x07, 0x75, 0x83, 0x36, 0x9C, 0xE4, 0x07, 0xA0, 0x77,
  0x77, 0x07, 0xA0, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x77, 0x07, 0xA0, 0x77, 0x77, 0x07, 0xA0, 0x77,
  0x77, 0x07, 0xA0, 0x77, 0x77, 0x82, 0x37, 0x73, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_run() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 28, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_run_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_subway_filled 36x36, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_filled_36_maps_directions_subway_filled_data[] PROGMEM = {
  0x48, 0x42, 0x79, 0xCD, 0xEC, 0x84, 0xED, 0xCA, 0x73, 0x60, 0x50, 0xCF, 0xFA, 0x0E, 0x06, 0x30,
  0x8F, 0xFE, 0x81, 0xA0, 0x5F, 0xFF, 0x90, 0x50, 0xBF, 0xFF, 0x90, 0xC0, 0xEF, 0xFF, 0x90, 0xEF,
  0xFF, 0xE8, 0x03, 0x70, 0xBA, 0x0B, 0x80, 0x37, 0xE7, 0x07, 0xA0, 0x77, 0xE7, 0x07, 0xA0, 0x77,
  0xE7, 0x07, 0xA0, 0x77, 0xE7, 0x07, 0xA0, 0x77, 0x80, 0x9C, 0x4F, 0x81, 0xD8, 0xAF, 0x98, 0x1A,
  0x8D, 0xFA, 0x0D, 0x30, 0x6E, 0x06, 0x30, 0xDF, 0x90, 0x83, 0x01, 0xE0, 0x13, 0x08, 0xF9, 0x0A,
  0x30, 0x2E, 0x02, 0x30, 0xAF, 0xA8, 0x26, 0x02, 0xCE, 0x82, 0xC2, 0x06, 0xD0, 0xCF, 0xFF, 0x90,
  0xC0, 0x7F, 0xFF, 0x98, 0x17, 0x0C, 0xFF, 0xE0, 0xC2, 0x01, 0x0A, 0xFF, 0xC0, 0xA0, 0x14, 0x02,
  0x07, 0xFF, 0x07, 0x02, 0x60, 0x50, 0xEF, 0xF0, 0xE0, 0x56, 0xFF, 0xC6, 0x80, 0x96, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_subway_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_subway_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_subway 36x36, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_filled_36_maps_directions_subway_data[] PROGMEM = {
  0x48, 0x43, 0x7A, 0xCD, 0xEC, 0x84, 0xED, 0xCA, 0x73, 0x60, 0x60, 0xEF, 0xFA, 0x0E, 0x06, 0x30,
  0xAF, 0xFE, 0x81, 0xA0, 0x5F, 0xFF, 0x90, 0x50, 0xCF, 0xFF, 0x90, 0xC0, 0xEF, 0xFF, 0x90, 0xEB,
  0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E,
  0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x80, 0x37, 0x0B, 0xA0,
  0xB8, 0x03, 0x78, 0x09, 0xC2, 0xF8, 0x2C, 0x20, 0x6F, 0xB8, 0x26, 0x02, 0xCE, 0x02, 0x30, 0xAF,
  0x90, 0xA3, 0x02, 0xE0, 0x13, 0x08, 0xF9, 0x08, 0x30, 0x1B, 0x0C, 0xA0, 0x63, 0x0D, 0xF9, 0x0D,
  0x30, 0x6A, 0x0C, 0x07, 0xB8, 0x1A, 0x8D, 0xFB, 0x81, 0xD8, 0xAB, 0x81, 0x70, 0xCF, 0xFE, 0x0C,
  0x20, 0x10, 0xAF, 0xFC, 0x0A, 0x01, 0x40, 0x20, 0x7F, 0xF0, 0x70, 0x27, 0x0B, 0xFF, 0x0B, 0x70,
  0xBF, 0xFA, 0x0B, 0x68, 0x09, 0x67, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_subway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_subway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_transit_filled 36x36, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_filled_36_maps_directions_transit_filled_data[] PROGMEM = {
  0x48, 0x42, 0x79, 0xCD, 0xEC, 0x84, 0xED, 0xCA, 0x73, 0x60, 0x50, 0xCF, 0xFA, 0x0E, 0x06, 0x30,
  0x8F, 0xFE, 0x81, 0xA0, 0x5F, 0xFF, 0x90, 0x50, 0xBF, 0xFF, 0x90, 0xC0, 0xEF, 0xFF, 0x90, 0xEF,
  0xFF, 0xE8, 0x03, 0x70, 0xBA, 0x0B, 0x80, 0x37, 0xE7, 0x07, 0xA0, 0x77, 0xE7, 0x07, 0xA0, 0x77,
  0xE7, 0x07, 0xA0, 0x77, 0xE7, 0x07, 0xA0, 0x77, 0x80, 0x9C, 0x4F, 0x81, 0xD8, 0xAF, 0x98, 0x1A,
  0x8D, 0xFA, 0x0D, 0x30, 0x6E, 0x06, 0x30, 0xDF, 0x90, 0x83, 0x01, 0xE0, 0x13, 0x08, 0xF9, 0x0A,
  0x30, 0x2E, 0x02, 0x30, 0xAF, 0xA8, 0x26, 0x02, 0xCE, 0x82, 0xC2, 0x06, 0xD0, 0xCF, 0xFF, 0x90,
  0xC0, 0x7F, 0xFF, 0x98, 0x17, 0x0C, 0xFF, 0xE0, 0xC2, 0x01, 0x0A, 0xFF, 0xC0, 0xA0, 0x14, 0x02,
  0x07, 0xFF, 0x07, 0x02, 0x60, 0x50, 0xEF, 0xF0, 0xE0, 0x56, 0xFF, 0xC6, 0x80, 0x96, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_transit_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_transit_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_transit 36x36, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_filled_36_maps_directions_transit_data[] PROGMEM = {
  0x48, 0x43, 0x7A, 0xCD, 0xEC, 0x84, 0xED, 0xCA, 0x73, 0x60, 0x60, 0xEF, 0xFA, 0x0E, 0x06, 0x30,
  0xAF, 0xFE, 0x81, 0xA0, 0x5F, 0xFF, 0x90, 0x50, 0xCF, 0xFF, 0x90, 0xC0, 0xEF, 0xFF, 0x90, 0xEB,
  0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E,
  0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x80, 0x37, 0x0B, 0xA0,
  0xB8, 0x03, 0x78, 0x09, 0xC2, 0xF8, 0x2C, 0x20, 0x6F, 0xB8, 0x26, 0x02, 0xCE, 0x02, 0x30, 0xAF,
  0x90, 0xA3, 0x02, 0xE0, 0x13, 0x08, 0xF9, 0x08, 0x30, 0x1B, 0x0C, 0xA0, 0x63, 0x0D, 0xF9, 0x0D,
  0x30, 0x6A, 0x0C, 0x07, 0xB8, 0x1A, 0x8D, 0xFB, 0x81, 0xD8, 0xAB, 0x81, 0x70, 0xCF, 0xFE, 0x0C,
  0x20, 0x10, 0xAF, 0xFC, 0x0A, 0x01, 0x40, 0x20, 0x7F, 0xF0, 0x70, 0x27, 0x0B, 0xFF, 0x0B, 0x70,
  0xBF, 0xFA, 0x0B, 0x68, 0x09, 0x67, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_transit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_transit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_directions_walk 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_filled_36_maps_directions_walk_data[] PROGMEM = {
  0x72, 0x82, 0x29, 0xA6, 0x77, 0x10, 0x20, 0xEB, 0x09, 0x77, 0x09, 0xD0, 0x17, 0x60, 0xAD, 0x02,
  0x76, 0x06, 0xC0, 0xD7, 0x71, 0x09, 0xA0, 0xD0, 0x37, 0x72, 0x01, 0x03, 0x77, 0x83, 0x4B, 0xEE,
  0x77, 0x58, 0x11, 0x7D, 0xD0, 0x87, 0x28, 0x12, 0x9E, 0xF9, 0x02, 0x70, 0xBF, 0xC0, 0xC7, 0xC0,
  0xC0, 0xAF, 0x07, 0x6B, 0x81, 0x30, 0x8F, 0x90, 0x65, 0xB2, 0x0B, 0xD0, 0xEB, 0x0A, 0x02, 0x3B,
  0x20, 0xED, 0x03, 0x0D, 0xC8, 0x1C, 0x93, 0xB1, 0x01, 0xD8, 0x2D, 0x01, 0x9D, 0x07, 0xB1, 0x05,
  0xD0, 0xA3, 0x03, 0x0A, 0xB8, 0x00, 0x71, 0x08, 0xD0, 0x76, 0x81, 0x45, 0x34, 0x0B, 0xD0, 0x97,
  0x60, 0xEE, 0x0A, 0x74, 0x01, 0xB0, 0xDC, 0x0A, 0x73, 0x04, 0xB0, 0x20, 0x9C, 0x07, 0x72, 0x07,
  0xA0, 0xD2, 0x08, 0xB0, 0x77, 0x20, 0xBA, 0x0A, 0x30, 0x9A, 0x07, 0x72, 0x0E, 0xA0, 0x63, 0x07,
  0xA0, 0x77, 0x10, 0x1B, 0x03, 0x30, 0x7A, 0x07, 0x71, 0x04, 0xB4, 0x07, 0xA0, 0x77, 0x10, 0x7A,
  0x0B, 0x40, 0x7A, 0x07, 0x71, 0x0A, 0xA0, 0x84, 0x07, 0xA0, 0x77, 0x10, 0xDA, 0x05, 0x40, 0x7A,
  0x07, 0x70, 0x1B, 0x01, 0x40, 0x7A, 0x07, 0x70, 0x4A, 0x0D, 0x50, 0x7A, 0x07, 0x78, 0x23, 0x77,
  0x55, 0x82, 0x37, 0x73, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_directions_walk() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 2, 28, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_directions_walk_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_dry_cleaning 36x36, 4-bit Alpha,  RLE, 179 bytes.
static const unsigned char ic_filled_36_maps_dry_cleaning_data[] PROGMEM = {
  0x74, 0x84, 0x3A, 0xEE, 0xB3, 0x77, 0x70, 0x4E, 0x05, 0x77, 0x60, 0xEE, 0x0E, 0x01, 0x77, 0x40,
  0x5A, 0x82, 0xD2, 0x2D, 0xA0, 0x57, 0x74, 0x06, 0xA0, 0x82, 0x82, 0x47, 0x73, 0x77, 0x40, 0x5A,
  0x0D, 0x02, 0x77, 0x73, 0x0E, 0xB0, 0xD0, 0x27, 0x77, 0x10, 0x4C, 0x07, 0x77, 0x72, 0x02, 0x0C,
  0xA0, 0x77, 0x77, 0x30, 0x9A, 0x09, 0x77, 0x71, 0x06, 0x0D, 0xC0, 0xD0, 0x67, 0x73, 0x81, 0x18,
  0xEF, 0x98, 0x1E, 0x81, 0x75, 0x03, 0x0A, 0xD8, 0x2E, 0x77, 0xED, 0x0A, 0x03, 0x71, 0x04, 0x0B,
  0xD0, 0xC0, 0x64, 0x06, 0x0C, 0xD0, 0xC0, 0x54, 0x02, 0x0C, 0xD0, 0xB0, 0x47, 0x10, 0x40, 0xBD,
  0x0C, 0x02, 0x20, 0xDC, 0x09, 0x02, 0x75, 0x02, 0x09, 0xC8, 0x1D, 0x05, 0xA8, 0x2E, 0x71, 0x38,
  0x09, 0x27, 0x82, 0x31, 0x7E, 0xA0, 0x50, 0x7A, 0x09, 0x20, 0x7F, 0xF0, 0x72, 0x09, 0xA0, 0x70,
  0x4F, 0xFF, 0xD8, 0x14, 0x0B, 0xFF, 0xFB, 0x0B, 0x30, 0x80, 0xDF, 0xFE, 0x0D, 0x08, 0x71, 0x07,
  0xFF, 0x07, 0x75, 0x07, 0xFF, 0x07, 0x75, 0x07, 0xFF, 0x07, 0x75, 0x07, 0xFF, 0x07, 0x75, 0x07,
  0xFF, 0x07, 0x75, 0x07, 0xFF, 0x07, 0x75, 0x07, 0xFF, 0x07, 0x75, 0x07, 0xFF, 0x07, 0x75, 0x07,
  0xFF, 0x07, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_dry_cleaning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_dry_cleaning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_edit_attributes 36x36, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_filled_36_maps_edit_attributes_data[] PROGMEM = {
  0x40, 0x10, 0x58, 0x09, 0x67, 0x05, 0x01, 0x70, 0x9F, 0xFF, 0x90, 0x95, 0x0C, 0xFF, 0xFB, 0x0C,
  0x30, 0xAF, 0xFF, 0xD8, 0x1A, 0x03, 0xFC, 0x0D, 0x0A, 0xFF, 0x90, 0x30, 0x9F, 0xB8, 0x2D, 0x11,
  0xEF, 0xF0, 0x90, 0xDC, 0x0E, 0xC8, 0x2D, 0x11, 0xDF, 0xF9, 0x0D, 0x0E, 0xB8, 0x15, 0x4E, 0xA8,
  0x2D, 0x11, 0xDF, 0xFA, 0x00, 0xEB, 0x86, 0xA0, 0x4E, 0xD1, 0x1D, 0xFF, 0xB0, 0xE0, 0xDC, 0x84,
  0xA0, 0x31, 0x1D, 0xFF, 0xC0, 0xD0, 0x9D, 0x82, 0xA0, 0x1D, 0xFF, 0xD0, 0x90, 0x3E, 0x0A, 0x0D,
  0xFF, 0xE8, 0x13, 0x0A, 0xFF, 0xFD, 0x0A, 0x30, 0xCF, 0xFF, 0xB0, 0xC5, 0x09, 0xFF, 0xF9, 0x09,
  0x70, 0x10, 0x58, 0x09, 0x67, 0x05, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_edit_attributes() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 10, 32, 25), Box(0, 0, 35, 35),
      ic_filled_36_maps_edit_attributes_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_edit_location_alt 36x36, 4-bit Alpha,  RLE, 209 bytes.
static const unsigned char ic_filled_36_maps_edit_location_alt_data[] PROGMEM = {
  0x77, 0x71, 0x00, 0x57, 0x77, 0x20, 0xAA, 0x08, 0x71, 0x87, 0x16, 0xAD, 0xEE, 0xDA, 0x55, 0x0A,
  0xB0, 0x55, 0x02, 0x09, 0xF0, 0xE0, 0x23, 0x82, 0x93, 0x0A, 0xA0, 0x54, 0x05, 0x0E, 0xF0, 0xE0,
  0x23, 0x85, 0xAF, 0xE3, 0x0A, 0xA4, 0x07, 0xF9, 0x0E, 0x02, 0x30, 0xAB, 0x0E, 0x03, 0x50, 0x5F,
  0x90, 0xE0, 0x23, 0x0A, 0xD0, 0x94, 0x01, 0x0E, 0xF0, 0xE0, 0x23, 0x0A, 0xD0, 0xA5, 0x09, 0xF0,
  0xE0, 0x23, 0x0A, 0xD0, 0xA5, 0x01, 0xF0, 0xE0, 0x23, 0x0A, 0xD0, 0xA6, 0x06, 0xE0, 0xE0, 0x23,
  0x0A, 0xD0, 0xA3, 0x02, 0x05, 0x20, 0xAE, 0x07, 0x30, 0xAD, 0x0A, 0x38, 0x12, 0xEA, 0x20, 0xCE,
  0x07, 0x20, 0x7D, 0x0A, 0x38, 0x22, 0xEF, 0xD2, 0x0E, 0xE0, 0x72, 0x07, 0xC0, 0xA3, 0x02, 0x0E,
  0xA0, 0xE2, 0xF0, 0x72, 0x07, 0xB0, 0xA3, 0x02, 0x0E, 0xC2, 0x0D, 0xE0, 0x72, 0x03, 0x0F, 0x73,
  0x02, 0x0E, 0xC0, 0xD2, 0x0B, 0xE0, 0x77, 0x10, 0x20, 0xED, 0x0B, 0x20, 0x6E, 0x07, 0x70, 0x20,
  0xEE, 0x06, 0x20, 0x1E, 0x0B, 0x80, 0x37, 0x0E, 0xF0, 0x13, 0x0A, 0xFF, 0xE0, 0xA4, 0x02, 0xFF,
  0xE0, 0x25, 0x08, 0xFF, 0xC0, 0x86, 0x01, 0x0D, 0xFF, 0xA0, 0xD0, 0x17, 0x03, 0xFF, 0xA0, 0x37,
  0x20, 0x7F, 0xF0, 0x77, 0x40, 0x9F, 0xD0, 0x97, 0x60, 0xBF, 0xB0, 0xB7, 0x71, 0x0B, 0xF9, 0x0B,
  0x77, 0x30, 0xBE, 0x0B, 0x77, 0x50, 0xBC, 0x0B, 0x77, 0x70, 0xAA, 0x0A, 0x77, 0x72, 0x00, 0x87,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_edit_location_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 1, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_edit_location_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_edit_location 36x36, 4-bit Alpha,  RLE, 149 bytes.
static const unsigned char ic_filled_36_maps_edit_location_data[] PROGMEM = {
  0x78, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x50, 0x60, 0xEF, 0x90, 0xE0, 0x67, 0x20, 0xAF, 0xD0, 0xA7,
  0x0B, 0xFF, 0x0B, 0x50, 0x8F, 0xFA, 0x08, 0x30, 0x2F, 0xFC, 0x02, 0x20, 0xAF, 0xB8, 0x1C, 0x1A,
  0xD0, 0xA2, 0x0E, 0xFB, 0x07, 0x20, 0xBC, 0x81, 0xE0, 0x4F, 0xA8, 0x4C, 0x1B, 0x60, 0xCD, 0x04,
  0x06, 0xF9, 0x0C, 0x30, 0xB0, 0xDE, 0x06, 0x07, 0xF0, 0xC4, 0x0C, 0xF0, 0x70, 0x5E, 0x0C, 0x40,
  0xCF, 0x90, 0x60, 0x3D, 0x0C, 0x40, 0xCF, 0xA0, 0x41, 0xD0, 0x73, 0x0C, 0xFB, 0x81, 0x10, 0xBC,
  0x07, 0x20, 0xCF, 0xB0, 0xB2, 0x05, 0xFF, 0xC0, 0x53, 0x0E, 0xFF, 0xA0, 0xE4, 0x08, 0xFF, 0xA0,
  0x84, 0x01, 0x0E, 0xFF, 0x0E, 0x01, 0x50, 0x7F, 0xF0, 0x77, 0x0D, 0xFD, 0x0D, 0x71, 0x04, 0xFD,
  0x04, 0x72, 0x0A, 0xFB, 0x0A, 0x73, 0x01, 0x0E, 0xF9, 0x0E, 0x01, 0x74, 0x05, 0xF9, 0x05, 0x76,
  0x09, 0xE0, 0x97, 0x71, 0x0C, 0xC0, 0xC7, 0x72, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x73, 0x04, 0xA0,
  0x47, 0x75, 0x00, 0x67, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_edit_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_edit_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_edit_road 36x36, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_filled_36_maps_edit_road_data[] PROGMEM = {
  0xB6, 0xB6, 0xB7, 0x1B, 0x6B, 0x6B, 0x71, 0xB6, 0xB6, 0xB7, 0x1B, 0x6B, 0x6B, 0x71, 0xB6, 0xB6,
  0xB7, 0x1B, 0x6B, 0x6B, 0x71, 0xB7, 0x71, 0xB7, 0x1B, 0x77, 0x1B, 0x71, 0xB7, 0x71, 0xB7, 0x1B,
  0x6B, 0x6A, 0x05, 0x71, 0xB6, 0xB6, 0x90, 0x53, 0x81, 0x37, 0x33, 0xB6, 0xB6, 0x05, 0x30, 0x6B,
  0x07, 0x2B, 0x6B, 0x72, 0x06, 0xD0, 0x71, 0xB6, 0xB7, 0x10, 0x6F, 0x03, 0xB6, 0xB7, 0x06, 0xF9,
  0x07, 0xB7, 0x71, 0x06, 0xA8, 0x1D, 0x3D, 0xC0, 0x3B, 0x77, 0x06, 0xA8, 0x2D, 0x10, 0x3B, 0x06,
  0x1B, 0x76, 0x06, 0xA8, 0x3D, 0x10, 0x1D, 0xA0, 0x62, 0xB6, 0xB3, 0x06, 0xA8, 0x3D, 0x10, 0x1D,
  0xA0, 0x63, 0xB6, 0xB3, 0xA8, 0x3D, 0x10, 0x1D, 0xA0, 0x64, 0xB6, 0xB3, 0xA8, 0x25, 0x01, 0xDA,
  0x06, 0x5B, 0x6B, 0x3A, 0x81, 0x85, 0xDA, 0x06, 0x6B, 0x6B, 0x3E, 0x06, 0x7B, 0x6B, 0x3D, 0x06,
  0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_edit_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 34, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_edit_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_egg_alt 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_filled_36_maps_egg_alt_data[] PROGMEM = {
  0x78, 0x90, 0x27, 0xBD, 0xEF, 0xDB, 0x83, 0x77, 0x40, 0x10, 0xAF, 0xB0, 0xB0, 0x27, 0x71, 0x05,
  0x0E, 0xFD, 0x0E, 0x05, 0x76, 0x05, 0xFF, 0xA0, 0x57, 0x40, 0x3F, 0xFC, 0x04, 0x73, 0x0C, 0xFF,
  0xC0, 0xE0, 0x17, 0x10, 0x6F, 0xFE, 0x0A, 0x71, 0x0C, 0xFF, 0xF0, 0x56, 0x02, 0xFF, 0xF9, 0x0E,
  0x01, 0x50, 0x6F, 0xD8, 0x2E, 0xCC, 0xEF, 0x0B, 0x50, 0xAF, 0xB0, 0xE0, 0x64, 0x06, 0x0E, 0xE0,
  0x84, 0x0C, 0xFA, 0x0E, 0x02, 0x60, 0x20, 0xEE, 0x07, 0x30, 0xDF, 0xA0, 0x67, 0x10, 0x6F, 0x06,
  0x20, 0xEF, 0x90, 0xE7, 0x30, 0xEF, 0x03, 0x1F, 0xA0, 0xC7, 0x30, 0xCF, 0x81, 0xD0, 0xEF, 0x90,
  0xC7, 0x30, 0xCF, 0x90, 0x50, 0xBF, 0x90, 0xE7, 0x30, 0xEF, 0x90, 0xA0, 0x8F, 0xA0, 0x67, 0x10,
  0x6F, 0xA0, 0xD0, 0x2F, 0xA0, 0xE0, 0x26, 0x02, 0x0E, 0xFA, 0x81, 0xE0, 0xBF, 0xA0, 0xE0, 0x64,
  0x06, 0x0E, 0xFC, 0x10, 0x20, 0xEF, 0xB8, 0x2E, 0xCC, 0xEF, 0xD0, 0xE2, 0x04, 0xFF, 0xFD, 0x0C,
  0x30, 0x40, 0xEF, 0xFF, 0xB0, 0x84, 0x02, 0x0A, 0xFF, 0xFA, 0x04, 0x68, 0x13, 0x9E, 0xFF, 0xD0,
  0xC7, 0x38, 0x33, 0x57, 0x9E, 0xFF, 0x04, 0x77, 0x01, 0x0C, 0xFD, 0x08, 0x77, 0x20, 0x10, 0xCF,
  0xB0, 0x97, 0x75, 0x0A, 0xF0, 0xE0, 0x77, 0x77, 0x86, 0x49, 0xDE, 0xEC, 0x71, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_egg_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_egg_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_egg 36x36, 4-bit Alpha,  RLE, 141 bytes.
static const unsigned char ic_filled_36_maps_egg_data[] PROGMEM = {
  0x72, 0x82, 0x26, 0x62, 0x77, 0x20, 0x20, 0xBC, 0x0B, 0x02, 0x76, 0x04, 0xF9, 0x04, 0x74, 0x04,
  0xFB, 0x04, 0x72, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x71, 0x0B, 0xFD, 0x0B, 0x70, 0x6F, 0xF0, 0x66,
  0x0D, 0xFF, 0x0D, 0x50, 0x7F, 0xFA, 0x07, 0x40, 0xDF, 0xFA, 0x0D, 0x30, 0x3F, 0xFC, 0x03, 0x20,
  0x9F, 0xFC, 0x09, 0x20, 0xDF, 0xFC, 0x81, 0xD0, 0x1F, 0xFE, 0x01, 0x04, 0xC8, 0x17, 0x07, 0xFE,
  0x04, 0x05, 0xC3, 0xFE, 0x05, 0x07, 0xC0, 0x12, 0x0D, 0xFD, 0x07, 0x06, 0xC0, 0x32, 0x09, 0xFD,
  0x06, 0x05, 0xC0, 0x82, 0x02, 0x0E, 0xFC, 0x05, 0x02, 0xC0, 0xE0, 0x12, 0x81, 0x29, 0xDF, 0xA8,
  0x12, 0x0D, 0xC0, 0xA6, 0x07, 0xE0, 0xD2, 0x07, 0xD0, 0xA0, 0x15, 0xE0, 0x73, 0x0D, 0xD8, 0x4E,
  0x83, 0x10, 0x7D, 0x0D, 0x40, 0x3F, 0xFA, 0x03, 0x50, 0x5F, 0xF0, 0x57, 0x03, 0x0D, 0xFB, 0x0D,
  0x03, 0x73, 0x07, 0x0D, 0xE0, 0xD0, 0x77, 0x78, 0x42, 0x57, 0x75, 0x27, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_egg() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 28, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_egg_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_electrical_services 36x36, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_filled_36_maps_electrical_services_data[] PROGMEM = {
  0x20, 0x8E, 0x81, 0xEA, 0x37, 0x74, 0x0E, 0xFA, 0x05, 0x77, 0x30, 0x8F, 0xB0, 0x37, 0x77, 0x20,
  0x20, 0xCA, 0x0A, 0x77, 0x73, 0x02, 0xA0, 0xE7, 0x77, 0x30, 0x1B, 0x77, 0x73, 0x06, 0xA0, 0xC7,
  0x74, 0x84, 0x25, 0x77, 0x7A, 0xB0, 0x77, 0x72, 0x01, 0x0A, 0xF9, 0x0C, 0x77, 0x20, 0x10, 0xDF,
  0x90, 0xA0, 0x17, 0x72, 0x0A, 0xB8, 0x4B, 0x87, 0x76, 0x27, 0x73, 0x02, 0xB0, 0x57, 0x77, 0x20,
  0x6A, 0x0B, 0x74, 0x08, 0x0D, 0xC0, 0x76, 0x07, 0xA0, 0x87, 0x30, 0x8E, 0x86, 0x70, 0x77, 0x75,
  0x06, 0xA0, 0xB7, 0x30, 0xDE, 0x07, 0x1C, 0x05, 0x02, 0xB0, 0x56, 0xFB, 0x07, 0x1C, 0x81, 0x50,
  0xAB, 0x83, 0xB8, 0x77, 0x31, 0xFB, 0x84, 0x70, 0x77, 0x75, 0x20, 0x10, 0xDE, 0x07, 0x1F, 0xB0,
  0x77, 0x10, 0x10, 0xAD, 0x07, 0x1F, 0xB0, 0x77, 0x38, 0x42, 0x57, 0x77, 0x31, 0xFB, 0x84, 0x70,
  0x77, 0x75, 0x75, 0xFB, 0x07, 0x1C, 0x05, 0x77, 0x0D, 0xE0, 0x71, 0xC0, 0x57, 0x70, 0x8E, 0x84,
  0x70, 0x77, 0x75, 0x77, 0x20, 0x80, 0xDC, 0x07, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_electrical_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_electrical_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_electric_bike 36x36, 4-bit Alpha,  RLE, 314 bytes.
static const unsigned char ic_filled_36_maps_electric_bike_data[] PROGMEM = {
  0x77, 0x48, 0x00, 0x70, 0x60, 0x17, 0x77, 0x72, 0xD0, 0xE0, 0x27, 0x77, 0x71, 0xE0, 0xA7, 0x77,
  0x71, 0x80, 0x07, 0xB0, 0x17, 0x77, 0x74, 0x0B, 0xA0, 0x77, 0x76, 0x07, 0xF4, 0x05, 0xA0, 0xC7,
  0x76, 0x07, 0xF5, 0x0E, 0xA0, 0x27, 0x75, 0x07, 0xF5, 0x09, 0xA0, 0x87, 0x77, 0x10, 0xAA, 0x07,
  0x60, 0x4A, 0x0D, 0x77, 0x83, 0x25, 0x76, 0x33, 0x05, 0xA0, 0xD8, 0x03, 0x7B, 0x82, 0x97, 0x63,
  0x71, 0x04, 0x0C, 0xD0, 0xD0, 0x52, 0x0E, 0xFF, 0xA0, 0xD0, 0x55, 0x07, 0xFA, 0x81, 0x90, 0x9F,
  0xFC, 0x09, 0x30, 0x6B, 0x83, 0xEA, 0x8A, 0xEB, 0x07, 0x03, 0xB8, 0x38, 0x77, 0x7C, 0xD8, 0x1B,
  0xAE, 0xB8, 0x27, 0x01, 0xEA, 0x0A, 0x01, 0x30, 0x10, 0xAB, 0x02, 0x0D, 0xA0, 0x42, 0x02, 0xB0,
  0xDA, 0x82, 0xB0, 0x1A, 0xB0, 0x20, 0x7A, 0x0C, 0x70, 0xCA, 0x08, 0x07, 0xA0, 0xA2, 0x08, 0xA0,
  0xC0, 0x1B, 0x01, 0x20, 0xCA, 0x08, 0x0C, 0xA0, 0x43, 0x83, 0x37, 0x77, 0xAA, 0x0D, 0x09, 0xB8,
  0x17, 0x7D, 0xA8, 0x14, 0x0B, 0xA0, 0x72, 0x04, 0xA0, 0xC0, 0xEA, 0x01, 0x30, 0x7F, 0xFA, 0x28,
  0x25, 0xFE, 0x72, 0x01, 0xA0, 0x0E, 0xA0, 0x13, 0x07, 0xFF, 0xA0, 0x12, 0x05, 0x40, 0x1A, 0x0E,
  0x0C, 0xA0, 0x43, 0x83, 0x37, 0x77, 0xAA, 0x0D, 0x80, 0x27, 0x0D, 0xA0, 0x47, 0x04, 0xA0, 0xC0,
  0x8A, 0x0C, 0x70, 0xCA, 0x08, 0x60, 0x8A, 0x0C, 0x70, 0xCA, 0x07, 0x02, 0xB0, 0xA0, 0x13, 0x01,
  0x0A, 0xB0, 0x26, 0x02, 0xB0, 0xA0, 0x13, 0x01, 0x0A, 0xA8, 0x2E, 0x10, 0x7B, 0x83, 0xEA, 0x8A,
  0xEB, 0x07, 0x71, 0x07, 0xB8, 0x3E, 0xA8, 0xAE, 0xB0, 0x63, 0x09, 0xFA, 0x09, 0x73, 0x09, 0xFA,
  0x07, 0x50, 0x50, 0xDD, 0x0D, 0x05, 0x75, 0x05, 0x0D, 0xD0, 0xC0, 0x37, 0x18, 0x33, 0x67, 0x63,
  0x77, 0x28, 0x33, 0x67, 0x52, 0x80, 0xE5, 0x08, 0x16, 0x71, 0x77, 0x77, 0x58, 0x37, 0xFE, 0x71,
  0x77, 0x77, 0x30, 0x7B, 0x81, 0xE7, 0x17, 0x77, 0x28, 0x11, 0x7E, 0xFA, 0x81, 0xE7, 0x17, 0x77,
  0x28, 0x11, 0x7E, 0xC8, 0x5B, 0x77, 0x77, 0x61, 0x77, 0x73, 0x81, 0x17, 0xEA, 0x07, 0x77, 0x77,
  0x48, 0x21, 0x7E, 0x77, 0x77, 0x76, 0x01, 0x02, 0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_electric_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 35, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_electric_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_electric_car 36x36, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_filled_36_maps_electric_car_data[] PROGMEM = {
  0x40, 0x28, 0x09, 0x67, 0x02, 0x70, 0x10, 0xEF, 0xFC, 0x0E, 0x02, 0x68, 0x18, 0xFE, 0x80, 0x94,
  0xB8, 0x1E, 0xF8, 0x68, 0x1D, 0xF7, 0x77, 0x28, 0x17, 0xFD, 0x50, 0x3A, 0x02, 0x77, 0x20, 0x2A,
  0x03, 0x48, 0x19, 0xFC, 0x77, 0x48, 0x1C, 0xF9, 0x48, 0x1E, 0xF7, 0x77, 0x48, 0x17, 0xFE, 0x30,
  0x4A, 0x02, 0x77, 0x40, 0x2A, 0x04, 0x28, 0x19, 0xFC, 0x77, 0x68, 0x1C, 0xF9, 0x28, 0x1E, 0xFC,
  0x80, 0xA0, 0x78, 0x3C, 0xFE, 0x05, 0xFF, 0xFD, 0x05, 0x07, 0xFF, 0xFD, 0x00, 0x7B, 0x81, 0xD8,
  0xAF, 0xF8, 0x1A, 0x8D, 0xB0, 0x07, 0xA0, 0xD3, 0x06, 0xFD, 0x06, 0x30, 0xDA, 0x00, 0x7A, 0x08,
  0x30, 0x1F, 0xD0, 0x13, 0x08, 0xA0, 0x07, 0xA0, 0xA3, 0x02, 0xFD, 0x02, 0x30, 0xAA, 0x00, 0x7B,
  0x82, 0x60, 0x2C, 0xFD, 0x82, 0xC2, 0x06, 0xB0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x09, 0x67, 0xC0, 0x07, 0xC7, 0x74, 0xC0, 0x70,
  0x5B, 0x0D, 0x77, 0x40, 0xDB, 0x84, 0x50, 0x57, 0x72, 0x77, 0x48, 0x22, 0x77, 0x58, 0x0C, 0x50,
  0x81, 0x67, 0x17, 0x77, 0x48, 0x37, 0xFE, 0x71, 0x77, 0x72, 0x07, 0xB8, 0x1E, 0x71, 0x77, 0x18,
  0x11, 0x7E, 0xFA, 0x81, 0xE7, 0x17, 0x71, 0x81, 0x17, 0xEC, 0x85, 0xB7, 0x77, 0x76, 0x17, 0x72,
  0x81, 0x17, 0xEA, 0x07, 0x77, 0x73, 0x82, 0x17, 0xE7, 0x77, 0x75, 0x01, 0x02, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_electric_car() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_electric_car_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_electric_moped 36x36, 4-bit Alpha,  RLE, 208 bytes.
static const unsigned char ic_filled_36_maps_electric_moped_data[] PROGMEM = {
  0x77, 0x48, 0x01, 0x70, 0x47, 0x77, 0x3E, 0x09, 0x72, 0x07, 0xF6, 0xF0, 0x47, 0x10, 0x7F, 0x68,
  0x00, 0x70, 0xBA, 0x07, 0x71, 0x07, 0xF7, 0x30, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x10,
  0x48, 0x03, 0x77, 0x30, 0x7A, 0x07, 0x60, 0x50, 0xDF, 0x97, 0x30, 0x9A, 0x07, 0x50, 0x6F, 0xB7,
  0x20, 0x5B, 0x06, 0x40, 0x2F, 0xC7, 0x10, 0x20, 0xEA, 0x0B, 0x50, 0x9F, 0xC7, 0x01, 0x0D, 0xA0,
  0xD0, 0x15, 0x0D, 0xFC, 0x70, 0xBA, 0x0E, 0x02, 0x6F, 0xD6, 0x08, 0xB8, 0x35, 0x04, 0x74, 0x3F,
  0xD5, 0x05, 0xB8, 0x18, 0x4E, 0xB0, 0xE0, 0x41, 0xFF, 0xE0, 0xB0, 0x2F, 0x02, 0xFF, 0xD8, 0x1D,
  0x1A, 0xA8, 0x1D, 0x8D, 0xA0, 0xAF, 0xFC, 0x82, 0xE2, 0x0D, 0xA8, 0x12, 0x02, 0xA0, 0xD3, 0x0D,
  0xA8, 0x12, 0x02, 0xA0, 0xD7, 0x20, 0xDA, 0x81, 0x20, 0x2A, 0x0D, 0x30, 0xAA, 0x81, 0xD8, 0xDA,
  0x0A, 0x72, 0x0A, 0xA8, 0x1D, 0x8D, 0xA0, 0xA3, 0x02, 0xF0, 0x27, 0x20, 0x2F, 0x02, 0x40, 0x40,
  0xEB, 0x0E, 0x04, 0x74, 0x04, 0x0E, 0xB0, 0xE0, 0x47, 0x81, 0x47, 0x47, 0x71, 0x81, 0x47, 0x48,
  0x0D, 0x20, 0x81, 0x67, 0x17, 0x77, 0x68, 0x37, 0xFE, 0x71, 0x77, 0x74, 0x07, 0xB8, 0x1E, 0x71,
  0x77, 0x38, 0x11, 0x7E, 0xFA, 0x81, 0xE7, 0x17, 0x73, 0x81, 0x17, 0xEC, 0x85, 0xB7, 0x77, 0x76,
  0x17, 0x74, 0x81, 0x17, 0xEA, 0x07, 0x77, 0x75, 0x82, 0x17, 0xE7, 0x77, 0x77, 0x01, 0x02, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_electric_moped() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_electric_moped_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_electric_rickshaw 36x36, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_filled_36_maps_electric_rickshaw_data[] PROGMEM = {
  0x20, 0x48, 0x09, 0x77, 0x04, 0x75, 0x09, 0xFF, 0xF0, 0xB7, 0x30, 0x4F, 0xFF, 0xA0, 0xA7, 0x20,
  0x7A, 0x0B, 0x80, 0x17, 0x0B, 0xA0, 0xB8, 0x03, 0x7D, 0x07, 0x71, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x77, 0xE0, 0x57, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x77, 0xB0, 0xBA, 0x0E, 0x03, 0x60, 0x7A, 0x07,
  0x50, 0x7A, 0x07, 0x7B, 0x10, 0xDA, 0x0D, 0x01, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x7B, 0x10,
  0x20, 0xEA, 0x0C, 0x50, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x7B, 0x20, 0x3B, 0x0A, 0x40, 0x7A, 0x0B,
  0x80, 0x17, 0x0B, 0xA0, 0xB8, 0x00, 0x73, 0xB0, 0xF7, 0x0C, 0xB0, 0x33, 0x07, 0xFF, 0xA3, 0xFB,
  0x07, 0x30, 0x7F, 0xFA, 0x3F, 0xB0, 0x73, 0x07, 0xFC, 0x0B, 0x80, 0x07, 0x3F, 0xB0, 0x83, 0x07,
  0xFC, 0x07, 0x7F, 0xC0, 0xA2, 0x07, 0xFC, 0x07, 0x7F, 0xD8, 0x1A, 0x07, 0xE0, 0x09, 0xB0, 0xB8,
  0x03, 0x7F, 0x90, 0x09, 0xB0, 0x30, 0x4D, 0x09, 0x20, 0x9F, 0xFB, 0x09, 0x20, 0x9A, 0x81, 0x60,
  0x9C, 0x09, 0x20, 0x9F, 0xFB, 0x09, 0x20, 0x9A, 0x06, 0x20, 0x40, 0x8B, 0x00, 0x9B, 0x08, 0x80,
  0x77, 0x08, 0xB0, 0x09, 0xB0, 0x34, 0x0A, 0xE0, 0xA7, 0x60, 0xAE, 0x0A, 0x60, 0xAC, 0x0A, 0x77,
  0x10, 0xAC, 0x0A, 0x71, 0x82, 0x36, 0x63, 0x77, 0x38, 0x22, 0x66, 0x28, 0x0E, 0x00, 0x81, 0x67,
  0x17, 0x77, 0x73, 0x83, 0x7F, 0xE7, 0x17, 0x77, 0x71, 0x07, 0xB8, 0x1E, 0x71, 0x77, 0x78, 0x11,
  0x7E, 0xFA, 0x81, 0xE7, 0x17, 0x77, 0x81, 0x17, 0xEC, 0x85, 0xB7, 0x77, 0x76, 0x17, 0x77, 0x18,
  0x11, 0x7E, 0xA0, 0x77, 0x77, 0x72, 0x82, 0x17, 0xE7, 0x77, 0x77, 0x40, 0x10, 0x27, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_electric_rickshaw() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_electric_rickshaw_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_electric_scooter 36x36, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_filled_36_maps_electric_scooter_data[] PROGMEM = {
  0x77, 0x18, 0x02, 0x70, 0x57, 0x77, 0x2F, 0x0D, 0x01, 0x77, 0x7F, 0x90, 0x97, 0x77, 0x80, 0x17,
  0x08, 0xA0, 0xE7, 0x77, 0x60, 0xEA, 0x02, 0x77, 0x75, 0x0B, 0xA0, 0x57, 0x77, 0x50, 0x7A, 0x09,
  0x77, 0x75, 0x04, 0xA0, 0xC7, 0x77, 0x6B, 0x77, 0x76, 0x0C, 0xA0, 0x47, 0x77, 0x50, 0x9A, 0x07,
  0x77, 0x75, 0x05, 0xA0, 0xB7, 0x77, 0x50, 0x2A, 0x0E, 0x77, 0x74, 0x07, 0x0E, 0xB0, 0x27, 0x77,
  0x10, 0x20, 0xDD, 0x05, 0x77, 0x70, 0x30, 0xEB, 0x82, 0xD9, 0x74, 0x77, 0x70, 0xDA, 0x0E, 0x05,
  0x72, 0x83, 0x7C, 0xDC, 0x77, 0x30, 0x7A, 0x86, 0xE2, 0x07, 0xCE, 0xC7, 0x30, 0xBD, 0x0B, 0x72,
  0x0D, 0xA8, 0x15, 0x0B, 0xD8, 0x1B, 0x07, 0xF0, 0x67, 0x03, 0xA8, 0x1D, 0x07, 0xF0, 0x70, 0xDA,
  0x81, 0x70, 0x7F, 0xE8, 0x19, 0x0C, 0xA8, 0x17, 0x07, 0xA0, 0xCB, 0x3F, 0xE8, 0x17, 0x0E, 0xA3,
  0xA0, 0xE0, 0xDA, 0x81, 0x70, 0x7F, 0xE8, 0x17, 0x0C, 0xA8, 0x17, 0x07, 0xA0, 0xC0, 0x7F, 0x07,
  0x75, 0x07, 0xF8, 0x17, 0x0C, 0xD0, 0xB7, 0x70, 0xBD, 0x0B, 0x38, 0x37, 0xDF, 0xC7, 0x77, 0x28,
  0x37, 0xCE, 0xC7, 0x77, 0x18, 0x16, 0x71, 0x77, 0x76, 0x83, 0x7F, 0xE7, 0x17, 0x77, 0x40, 0x7B,
  0x81, 0xE7, 0x17, 0x73, 0x81, 0x17, 0xEF, 0xA8, 0x1E, 0x71, 0x77, 0x38, 0x11, 0x7E, 0xC8, 0x5B,
  0x77, 0x77, 0x61, 0x77, 0x48, 0x11, 0x7E, 0xA0, 0x77, 0x77, 0x58, 0x21, 0x7E, 0x77, 0x77, 0x70,
  0x10, 0x27, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_electric_scooter() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_electric_scooter_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_emergency 36x36, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_filled_36_maps_emergency_data[] PROGMEM = {
  0x73, 0x80, 0x27, 0x77, 0x6E, 0x77, 0x6E, 0x77, 0x6E, 0x75, 0x01, 0x7E, 0x70, 0x14, 0x81, 0xAD,
  0x55, 0xE5, 0x81, 0x5D, 0xA3, 0x03, 0xB0, 0xC0, 0x33, 0xE3, 0x03, 0x0C, 0xB0, 0x32, 0x0C, 0xD0,
  0x90, 0x11, 0xE1, 0x01, 0x09, 0xD8, 0x1C, 0x06, 0xF0, 0xE0, 0x7E, 0x07, 0x0E, 0xF0, 0x60, 0xEF,
  0xFF, 0xB8, 0x1E, 0x3C, 0xFF, 0xF9, 0x0C, 0x03, 0x20, 0x60, 0xEF, 0xFC, 0x0E, 0x06, 0x60, 0x8F,
  0xFA, 0x08, 0x72, 0x02, 0x0B, 0xFD, 0x0B, 0x02, 0x73, 0x02, 0x0B, 0xFD, 0x0B, 0x02, 0x72, 0x08,
  0xFF, 0xA0, 0x86, 0x06, 0x0E, 0xFF, 0xC0, 0xE0, 0x62, 0x03, 0x0C, 0xFF, 0xF9, 0x81, 0xC3, 0xEF,
  0xFF, 0xB0, 0xE0, 0x6F, 0x0E, 0x07, 0xE0, 0x70, 0xEF, 0x81, 0x60, 0xCD, 0x09, 0x01, 0x1E, 0x10,
  0x10, 0x9D, 0x0C, 0x20, 0x3B, 0x0C, 0x03, 0x3E, 0x30, 0x30, 0xCB, 0x03, 0x38, 0x1A, 0xD5, 0x5E,
  0x58, 0x15, 0xDA, 0x40, 0x17, 0xE7, 0x01, 0x75, 0xE7, 0x76, 0xE7, 0x76, 0xE7, 0x76, 0x80, 0x27,
  0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 30, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_emergency_recording 36x36, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_filled_36_maps_emergency_recording_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x70, 0x8F, 0xFF, 0x90, 0x86, 0x0D, 0xFF, 0xF9, 0x0D, 0x6F,
  0xFF, 0xB6, 0xFB, 0x82, 0xB7, 0x7B, 0xFB, 0x50, 0xBF, 0xB0, 0x72, 0x07, 0xFB, 0x40, 0xBF, 0xC0,
  0x72, 0x07, 0xFB, 0x30, 0xBF, 0x81, 0x92, 0xAA, 0x07, 0x20, 0x7A, 0x81, 0xA2, 0x9D, 0x20, 0xBF,
  0x0E, 0x01, 0x28, 0x13, 0xC7, 0x28, 0x17, 0xC3, 0x20, 0x10, 0xEC, 0x10, 0xBF, 0x90, 0xB0, 0x14,
  0x02, 0x20, 0x24, 0x01, 0x0B, 0xC0, 0xBF, 0xB0, 0xE0, 0x67, 0x30, 0x60, 0xEF, 0xFC, 0x0D, 0x04,
  0x60, 0x40, 0xDF, 0xFE, 0x0D, 0x04, 0x60, 0x40, 0xDF, 0xFC, 0x0E, 0x06, 0x73, 0x06, 0x0E, 0xFF,
  0x90, 0xB0, 0x14, 0x02, 0x20, 0x24, 0x01, 0x0B, 0xC0, 0xBF, 0xA0, 0xE0, 0x12, 0x81, 0x3C, 0x72,
  0x81, 0x7C, 0x32, 0x01, 0x0E, 0xC1, 0x0B, 0xFA, 0x81, 0x92, 0xAA, 0x07, 0x20, 0x7A, 0x81, 0xA2,
  0x9D, 0x20, 0xBF, 0xE0, 0x72, 0x07, 0xFB, 0x30, 0xBF, 0xD0, 0x72, 0x07, 0xFB, 0x40, 0xBF, 0xC8,
  0x2B, 0x77, 0xBF, 0xB5, 0x0B, 0xFF, 0xFB, 0x60, 0xDF, 0xFF, 0x90, 0xD6, 0x08, 0xFF, 0xF9, 0x08,
  0x70, 0x80, 0xDF, 0xFC, 0x0D, 0x08, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_emergency_recording() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_emergency_recording_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_emergency_share 36x36, 4-bit Alpha,  RLE, 198 bytes.
static const unsigned char ic_filled_36_maps_emergency_share_data[] PROGMEM = {
  0x78, 0x90, 0x49, 0xBD, 0xEE, 0xDB, 0x94, 0x74, 0x81, 0x29, 0xEF, 0xB8, 0x1E, 0x92, 0x60, 0x10,
  0x8F, 0xFA, 0x08, 0x01, 0x30, 0x20, 0xDC, 0x82, 0xC8, 0x42, 0x28, 0x22, 0x47, 0xCC, 0x83, 0xD2,
  0x04, 0xEB, 0x0B, 0x03, 0x73, 0x03, 0x0B, 0xB8, 0x5E, 0x41, 0xDF, 0xE4, 0x77, 0x87, 0x4E, 0xFD,
  0x20, 0x1B, 0x24, 0x86, 0x5A, 0xDE, 0xED, 0xA5, 0x48, 0x12, 0xB2, 0x70, 0x60, 0xEF, 0x90, 0xE0,
  0x67, 0x40, 0xAF, 0xD0, 0xA7, 0x20, 0x10, 0xDA, 0x81, 0xD7, 0x22, 0x81, 0x27, 0xDA, 0x0D, 0x01,
  0x72, 0x81, 0x1D, 0x87, 0x18, 0x18, 0xD1, 0x80, 0xF2, 0x08, 0x41, 0x57, 0x75, 0x17, 0x72, 0x04,
  0x0C, 0xE0, 0xC0, 0x47, 0x60, 0x9F, 0xB0, 0x97, 0x40, 0xAF, 0xD0, 0xA7, 0x20, 0x7F, 0xF0, 0x77,
  0x01, 0x0E, 0xFF, 0x0E, 0x01, 0x60, 0x6F, 0xFA, 0x06, 0x60, 0xBE, 0x82, 0xC5, 0x5C, 0xE0, 0xB6,
  0x0D, 0xD0, 0xE0, 0x12, 0x01, 0x0E, 0xD0, 0xD6, 0xE0, 0xC4, 0x0C, 0xE6, 0x0E, 0xD0, 0xE0, 0x12,
  0x01, 0x0E, 0xD0, 0xE6, 0x0B, 0xE8, 0x2C, 0x55, 0xCE, 0x0B, 0x60, 0x7F, 0xFA, 0x07, 0x60, 0x1F,
  0xFA, 0x01, 0x70, 0x8F, 0xF0, 0x87, 0x20, 0xDF, 0xD0, 0xD7, 0x30, 0x4F, 0xD0, 0x47, 0x40, 0x7F,
  0xB0, 0x77, 0x60, 0x9F, 0x90, 0x97, 0x71, 0x0A, 0xE0, 0xA7, 0x73, 0x0A, 0xC0, 0xA7, 0x75, 0x0A,
  0xA0, 0xA7, 0x77, 0x00, 0x87, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_emergency_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 0, 29, 35), Box(0, 0, 35, 35),
      ic_filled_36_maps_emergency_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_ev_station 36x36, 4-bit Alpha,  RLE, 215 bytes.
static const unsigned char ic_filled_36_maps_ev_station_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x05, 0x70, 0x60, 0x17, 0x40, 0x30, 0xEF, 0xC0, 0xE0, 0x32, 0x03, 0x05, 0x60,
  0xBF, 0xE8, 0x4B, 0x03, 0xEF, 0x55, 0xFF, 0x92, 0x0C, 0xA0, 0x54, 0xFF, 0x93, 0x0C, 0xA0, 0x53,
  0xF9, 0x0B, 0xE4, 0x0C, 0xA0, 0x52, 0xF9, 0x03, 0xE3, 0x04, 0x0D, 0xB0, 0x51, 0xF0, 0xA1, 0xE2,
  0x02, 0x0E, 0xC0, 0xE0, 0x2F, 0x02, 0x1E, 0x28, 0x68, 0xFD, 0x22, 0xDF, 0x8E, 0x09, 0x2E, 0x28,
  0x1A, 0xF8, 0x28, 0x18, 0xFB, 0xD0, 0xE0, 0x12, 0xE2, 0x86, 0x8F, 0xD2, 0x2D, 0xFB, 0xD0, 0x83,
  0xE2, 0x02, 0x0E, 0xD0, 0xBC, 0x0E, 0x01, 0x38, 0x17, 0x78, 0xB3, 0x03, 0x0D, 0xC0, 0xBC, 0x07,
  0x60, 0x8B, 0x58, 0x32, 0x37, 0xFB, 0xB0, 0xD6, 0x02, 0xE0, 0xB0, 0x33, 0x81, 0x7F, 0xBB, 0x06,
  0x60, 0xBF, 0x0E, 0x01, 0x28, 0x17, 0xFB, 0xB0, 0xFB, 0x30, 0x4D, 0x83, 0x33, 0xCF, 0x62, 0x81,
  0x7F, 0xBE, 0x30, 0xDD, 0x28, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0xE2, 0x06, 0xE2, 0x81, 0xBF, 0x72,
  0x81, 0x7F, 0xBE, 0x10, 0x10, 0xEE, 0x28, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0xE1, 0x08, 0xF2, 0x81,
  0xBF, 0x72, 0x81, 0x7F, 0xBE, 0x02, 0xF9, 0x28, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0xE0, 0xBF, 0x92,
  0x81, 0xBF, 0x72, 0x81, 0x7F, 0xBF, 0xF9, 0x28, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0xFF, 0x92, 0x81,
  0x9F, 0xB2, 0x81, 0xBF, 0x9F, 0xF9, 0x20, 0x3A, 0x00, 0xDA, 0x03, 0xFF, 0x93, 0x07, 0xC0, 0x71,
  0x80, 0x93, 0x74, 0x82, 0x26, 0x62, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_ev_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 30, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_ev_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_factory 36x36, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_filled_36_maps_factory_data[] PROGMEM = {
  0x77, 0x72, 0x01, 0xC0, 0x87, 0x77, 0x30, 0x2C, 0x0A, 0x77, 0x73, 0x04, 0xC0, 0xC7, 0x77, 0x30,
  0x6C, 0x0E, 0x77, 0x73, 0x08, 0xD7, 0x77, 0x30, 0xAD, 0x02, 0x77, 0x72, 0x0C, 0xD0, 0x47, 0x20,
  0x10, 0x36, 0x04, 0x50, 0xED, 0x06, 0x78, 0x23, 0x9F, 0x73, 0x81, 0x17, 0xD9, 0x5E, 0x08, 0x50,
  0x50, 0xCB, 0x82, 0x70, 0x4A, 0xC4, 0x01, 0x80, 0x2B, 0x07, 0x28, 0x11, 0x7E, 0xD0, 0xC0, 0xDE,
  0x75, 0x03, 0x09, 0xFF, 0xA7, 0x58, 0x0A, 0xE7, 0xF0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xFF, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xF0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xFF, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F, 0xF0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xFF, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20,
  0x78, 0x0A, 0xE7, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_factory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_factory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_fastfood 36x36, 4-bit Alpha,  RLE, 208 bytes.
static const unsigned char ic_filled_36_maps_fastfood_data[] PROGMEM = {
  0x77, 0x72, 0x0F, 0x77, 0x77, 0x73, 0x0E, 0xA7, 0x77, 0x73, 0x0E, 0xA7, 0x77, 0x73, 0x0E, 0xA7,
  0x77, 0x73, 0x0E, 0xA7, 0x77, 0x73, 0x0E, 0xA7, 0x77, 0x20, 0x28, 0x03, 0x5B, 0x80, 0x35, 0x02,
  0x77, 0x10, 0x4F, 0xFB, 0x06, 0x77, 0x10, 0x2F, 0xFB, 0x04, 0x77, 0x2F, 0xFB, 0x03, 0x77, 0x28,
  0x13, 0x8E, 0xFF, 0x01, 0x77, 0x50, 0x60, 0xEF, 0xD7, 0x28, 0x52, 0x56, 0x77, 0x53, 0x50, 0x10,
  0xAF, 0xB0, 0xE6, 0x81, 0x28, 0xDF, 0x90, 0xB0, 0x54, 0x08, 0xFA, 0x0C, 0x50, 0x8F, 0xE0, 0xD0,
  0x33, 0x09, 0xF9, 0x0A, 0x30, 0x10, 0xBF, 0xFA, 0x06, 0x30, 0xCF, 0x09, 0x30, 0xBF, 0xFC, 0x05,
  0x20, 0x3F, 0x07, 0x20, 0x7F, 0xFD, 0x0E, 0x01, 0x20, 0xAE, 0x06, 0x20, 0xDF, 0xFE, 0x06, 0x20,
  0x5E, 0x81, 0x40, 0x3F, 0xFF, 0x0C, 0x20, 0x1E, 0x81, 0x30, 0x5F, 0xFF, 0x0E, 0x30, 0xED, 0x81,
  0x10, 0x38, 0x0A, 0x27, 0x30, 0xED, 0x77, 0x77, 0x0E, 0xC0, 0xE7, 0x77, 0x70, 0xEC, 0x0C, 0x20,
  0x38, 0x0A, 0x27, 0x30, 0xEC, 0x0A, 0x20, 0x7F, 0xFF, 0x93, 0x0E, 0xC0, 0x92, 0x07, 0xFF, 0xF9,
  0x30, 0xEC, 0x07, 0x20, 0x38, 0x0A, 0x27, 0x30, 0xEC, 0x06, 0x77, 0x77, 0x0E, 0xC0, 0x47, 0x77,
  0x70, 0xEC, 0x03, 0x20, 0x38, 0x0A, 0x27, 0x30, 0xEC, 0x01, 0x20, 0x7F, 0xFF, 0x93, 0x0E, 0xB0,
  0xE3, 0x05, 0xFF, 0xF0, 0xD3, 0x0E, 0xB0, 0x74, 0x05, 0x80, 0xA0, 0x70, 0x23, 0x0F, 0x70, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_fastfood() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_fastfood_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_festival 36x36, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_filled_36_maps_festival_data[] PROGMEM = {
  0x76, 0x03, 0x80, 0x27, 0x06, 0x77, 0x71, 0x07, 0xE0, 0x57, 0x77, 0x10, 0x7D, 0x0B, 0x77, 0x72,
  0x07, 0xD0, 0xE0, 0x17, 0x77, 0x10, 0x7E, 0x0A, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x07, 0x77, 0x75, 0x09, 0xA0, 0x97, 0x77, 0x30, 0x10, 0xBC, 0x0B, 0x01, 0x77, 0x70, 0x50, 0xEE,
  0x0E, 0x05, 0x77, 0x40, 0x10, 0xAF, 0xB0, 0xA0, 0x17, 0x71, 0x03, 0x0D, 0xFD, 0x0D, 0x03, 0x76,
  0x08, 0xFF, 0xA0, 0x87, 0x30, 0x20, 0xCF, 0xFC, 0x0C, 0x02, 0x70, 0x6F, 0xFF, 0x90, 0x64, 0x01,
  0x0B, 0xFF, 0xFB, 0x83, 0xB1, 0x05, 0xEF, 0xFF, 0xD0, 0xE0, 0x58, 0x0A, 0x82, 0xF0, 0x0C, 0xFF,
  0xFE, 0x08, 0x20, 0x7F, 0xFF, 0xB0, 0xC0, 0x34, 0x02, 0x0C, 0xFF, 0xF0, 0xA7, 0x10, 0xAF, 0xFE,
  0x07, 0x71, 0x07, 0xFF, 0xE0, 0x77, 0x10, 0x7F, 0xFE, 0x07, 0x71, 0x07, 0xFF, 0xE0, 0x77, 0x10,
  0x7F, 0xFE, 0x07, 0x71, 0x07, 0xFF, 0xE0, 0x77, 0x10, 0x7F, 0xFE, 0x07, 0x71, 0x07, 0xFB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_festival() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_festival_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_fire_hydrant_alt 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_filled_36_maps_fire_hydrant_alt_data[] PROGMEM = {
  0x73, 0x81, 0x49, 0xDA, 0x81, 0xD9, 0x47, 0x74, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x77, 0x10, 0x30,
  0xEF, 0xB0, 0xE0, 0x37, 0x60, 0x20, 0xEF, 0xD0, 0xE0, 0x27, 0x50, 0xBF, 0xF0, 0xB7, 0x40, 0x3F,
  0xFA, 0x03, 0x7F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB7, 0xFF, 0xC7, 0x3F, 0xFC, 0x73, 0xFF,
  0xC7, 0x3F, 0x82, 0xEC, 0xCE, 0xF7, 0x81, 0x47, 0x7D, 0x0E, 0x06, 0x40, 0x60, 0xED, 0x81, 0x77,
  0x43, 0x09, 0xF0, 0xE0, 0x26, 0x02, 0x0E, 0xF8, 0x19, 0x04, 0xF9, 0x06, 0x30, 0x02, 0x30, 0x6F,
  0x90, 0x40, 0x7F, 0x0E, 0x30, 0x9A, 0x09, 0x30, 0xEF, 0x00, 0x7F, 0x0C, 0x20, 0x2C, 0x02, 0x20,
  0xCF, 0x00, 0x7F, 0x0C, 0x20, 0x2C, 0x02, 0x20, 0xCF, 0x00, 0x7F, 0x0E, 0x30, 0x9A, 0x09, 0x30,
  0xEF, 0x07, 0x04, 0xF9, 0x06, 0x30, 0x02, 0x30, 0x6F, 0x98, 0x14, 0x09, 0xF0, 0xE0, 0x26, 0x02,
  0x0E, 0xF0, 0x93, 0x81, 0x47, 0x7D, 0x0E, 0x06, 0x40, 0x60, 0xED, 0x81, 0x77, 0x47, 0xF8, 0x2E,
  0xCC, 0xEF, 0x73, 0xFF, 0xC7, 0x3F, 0xFC, 0x73, 0xFF, 0xC7, 0xFF, 0xFB, 0x4F, 0xFF, 0xB4, 0xFF,
  0xFB, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_fire_hydrant_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_fire_hydrant_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_fire_truck 36x36, 4-bit Alpha,  RLE, 220 bytes.
static const unsigned char ic_filled_36_maps_fire_truck_data[] PROGMEM = {
  0x77, 0x72, 0x82, 0x27, 0x75, 0x77, 0x77, 0x20, 0xDB, 0x05, 0x77, 0x77, 0x1C, 0x07, 0x60, 0x38,
  0x09, 0x27, 0x03, 0x20, 0x10, 0x60, 0xF7, 0xC8, 0x1B, 0x73, 0x40, 0x7F, 0xF8, 0x27, 0x03, 0xEF,
  0xC0, 0x73, 0x05, 0x0B, 0xA8, 0x1C, 0xBC, 0xA8, 0x1C, 0xBC, 0xA8, 0x2B, 0x50, 0xBF, 0xE0, 0x24,
  0xA8, 0x13, 0x01, 0xA8, 0x11, 0x03, 0xA3, 0xB8, 0x04, 0x70, 0xCA, 0x07, 0x4A, 0x81, 0x30, 0x1A,
  0x81, 0x10, 0x3A, 0x3B, 0x71, 0x05, 0xA0, 0xD2, 0x01, 0x03, 0xA8, 0x16, 0x35, 0xA8, 0x15, 0x36,
  0xA0, 0x30, 0x11, 0xB7, 0x20, 0xEA, 0x81, 0x20, 0x7F, 0xF0, 0x71, 0xB7, 0x20, 0xAA, 0x81, 0x70,
  0x7F, 0xF0, 0x71, 0xB7, 0x20, 0x5A, 0x0D, 0x77, 0x4B, 0x73, 0x0E, 0xA0, 0x20, 0x38, 0x09, 0x47,
  0xB8, 0x06, 0x70, 0xDA, 0x06, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF,
  0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF,
  0xC0, 0x70, 0x6F, 0xFF, 0xFC, 0x81, 0x71, 0xEE, 0x81, 0xD8, 0xDF, 0xD8, 0x1D, 0x8D, 0xF8, 0x27,
  0x03, 0xBD, 0x81, 0x20, 0x2F, 0xD8, 0x12, 0x02, 0xF0, 0x75, 0x0D, 0xA8, 0x12, 0x02, 0xA0, 0xD6,
  0x0D, 0xA8, 0x12, 0x02, 0xA0, 0xD7, 0x30, 0xAA, 0x81, 0xD8, 0xDA, 0x0A, 0x60, 0xAA, 0x81, 0xD8,
  0xDA, 0x0A, 0x73, 0x02, 0xF0, 0x26, 0x02, 0xF0, 0x27, 0x40, 0x40, 0xEB, 0x0E, 0x04, 0x71, 0x04,
  0x0E, 0xB0, 0xE0, 0x47, 0x78, 0x14, 0x74, 0x75, 0x81, 0x47, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_fire_truck() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_fire_truck_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_flight_class 36x36, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_filled_36_maps_flight_class_data[] PROGMEM = {
  0x07, 0xA0, 0x77, 0x10, 0x80, 0xDB, 0x82, 0xD8, 0x07, 0xA0, 0x77, 0x08, 0xF0, 0x80, 0x7A, 0x07,
  0x70, 0xDF, 0x0D, 0x07, 0xA0, 0x77, 0xFA, 0x07, 0xA0, 0x77, 0xFA, 0x07, 0xA0, 0x77, 0xFA, 0x05,
  0xA0, 0xA7, 0xFA, 0x01, 0xA0, 0xE7, 0xFA, 0x10, 0xBA, 0x04, 0x6F, 0xA1, 0x07, 0xA0, 0x96, 0xFA,
  0x10, 0x2A, 0x0D, 0x6F, 0xA2, 0x0D, 0xA0, 0x35, 0x0B, 0xF0, 0xB2, 0x08, 0xA0, 0x85, 0x03, 0x0E,
  0xD0, 0xE0, 0x32, 0x03, 0xA0, 0xD6, 0x85, 0x16, 0x77, 0x76, 0x14, 0x0E, 0xA0, 0x27, 0x72, 0x0A,
  0xA0, 0x77, 0x72, 0x05, 0xA0, 0xC7, 0x72, 0x01, 0xB0, 0x17, 0x72, 0x0B, 0xFF, 0x94, 0x04, 0xFF,
  0x95, 0x05, 0x0D, 0xFE, 0x77, 0x74, 0x80, 0x93, 0x75, 0xFF, 0x95, 0xFF, 0x95, 0x80, 0x93, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_flight_class() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 6, 26, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_flight_class_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_flight 36x36, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_filled_36_maps_flight_data[] PROGMEM = {
  0x75, 0x82, 0x3C, 0xE8, 0x77, 0x74, 0x0C, 0xB0, 0x47, 0x77, 0x3C, 0x07, 0x77, 0x73, 0xC0, 0x77,
  0x77, 0x3C, 0x07, 0x77, 0x73, 0xC0, 0x77, 0x77, 0x3C, 0x07, 0x77, 0x73, 0xC0, 0x77, 0x77, 0x3C,
  0x07, 0x77, 0x73, 0xC0, 0x77, 0x77, 0x20, 0x3C, 0x0A, 0x77, 0x71, 0x08, 0xE0, 0xD0, 0x37, 0x74,
  0x04, 0x0D, 0xFA, 0x09, 0x01, 0x77, 0x01, 0x0A, 0xFD, 0x0E, 0x05, 0x75, 0x06, 0x0E, 0xFF, 0x90,
  0xB0, 0x27, 0x10, 0x30, 0xCF, 0xFD, 0x07, 0x60, 0x8F, 0xFF, 0x90, 0xD0, 0x32, 0x04, 0x0D, 0xF9,
  0x0B, 0x06, 0xC8, 0x1A, 0x8D, 0xF9, 0x09, 0x01, 0xE8, 0x1E, 0xA5, 0x3C, 0x07, 0x28, 0x12, 0x7C,
  0xE0, 0x7B, 0x81, 0xD9, 0x46, 0xC0, 0x75, 0x81, 0x16, 0xBB, 0x82, 0x7D, 0x83, 0x72, 0xC0, 0x77,
  0x18, 0x21, 0x5A, 0x77, 0x5C, 0x07, 0x77, 0x73, 0xC0, 0x77, 0x77, 0x3C, 0x07, 0x77, 0x73, 0xC0,
  0x77, 0x77, 0x20, 0x2C, 0x0A, 0x77, 0x71, 0x05, 0x0E, 0xD0, 0xB0, 0x17, 0x75, 0x09, 0xF9, 0x0E,
  0x03, 0x77, 0x4B, 0x82, 0xEB, 0x9D, 0xB0, 0x77, 0x74, 0x81, 0xD8, 0x44, 0x82, 0x26, 0xB7, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_flight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_flight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_forest 36x36, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_filled_36_maps_forest_data[] PROGMEM = {
  0x76, 0x09, 0x71, 0x09, 0x77, 0x74, 0x81, 0x8F, 0x86, 0x81, 0x8F, 0x87, 0x77, 0x20, 0x3B, 0x03,
  0x40, 0x4B, 0x03, 0x77, 0x70, 0x10, 0xDB, 0x0D, 0x01, 0x20, 0x10, 0xDB, 0x0D, 0x01, 0x77, 0x60,
  0xAD, 0x0A, 0x20, 0xAD, 0x0A, 0x77, 0x50, 0x5F, 0x81, 0x50, 0xCE, 0x05, 0x77, 0x30, 0x10, 0xEF,
  0x82, 0xE1, 0x2E, 0xD0, 0xE0, 0x17, 0x72, 0x0B, 0xFA, 0x81, 0xB0, 0x6E, 0x0B, 0x77, 0x10, 0x7F,
  0xC8, 0x17, 0x0B, 0xE0, 0x77, 0x60, 0x2F, 0xE8, 0x12, 0x1E, 0xE0, 0x27, 0x50, 0xCF, 0xE8, 0x1C,
  0x04, 0xE0, 0xC7, 0x40, 0x8F, 0xF9, 0x81, 0x80, 0x9E, 0x08, 0x72, 0x03, 0xFF, 0xB8, 0x13, 0x0D,
  0xE0, 0x37, 0x01, 0x0D, 0xFF, 0xB8, 0x1D, 0x13, 0xE0, 0xD0, 0x16, 0x0A, 0xFF, 0xD8, 0x1A, 0x08,
  0xE0, 0xA7, 0x10, 0x8F, 0xF9, 0x08, 0x40, 0xCB, 0x08, 0x72, 0x03, 0xFF, 0xB8, 0x33, 0x06, 0x7A,
  0xC0, 0x37, 0x10, 0xCF, 0xFB, 0x81, 0xC0, 0x6E, 0x0C, 0x70, 0x7F, 0xFD, 0x81, 0x70, 0xBE, 0x07,
  0x50, 0x20, 0xEF, 0xFD, 0x82, 0xE2, 0x2E, 0xD0, 0xE0, 0x24, 0x0B, 0xFF, 0xF8, 0x1B, 0x07, 0xE0,
  0xB3, 0x06, 0xFF, 0xFA, 0x81, 0x60, 0xCE, 0x82, 0x60, 0x1E, 0xFF, 0xFA, 0x81, 0xE1, 0x3E, 0x81,
  0xE1, 0xAF, 0xFF, 0xC8, 0x1A, 0x08, 0xE0, 0xA7, 0x30, 0x7D, 0x07, 0x77, 0x77, 0x10, 0x7D, 0x07,
  0x20, 0x38, 0x01, 0x70, 0x37, 0x76, 0x07, 0xD0, 0x72, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x72,
  0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x72, 0x07, 0xD0, 0x77, 0x76, 0x07, 0xD0, 0x72, 0x07, 0xD0,
  0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_forest() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 35, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_forest_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_fork_left 36x36, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_filled_36_maps_fork_left_data[] PROGMEM = {
  0x77, 0x00, 0x17, 0x74, 0x82, 0x1D, 0xD1, 0x77, 0x20, 0x10, 0xDA, 0x0D, 0x01, 0x77, 0x01, 0x0D,
  0xC0, 0xD0, 0x17, 0x50, 0x10, 0xDE, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x72, 0x0B,
  0xB0, 0xBA, 0x0B, 0x0E, 0xA0, 0xB7, 0x28, 0x31, 0xDF, 0x47, 0xA8, 0x37, 0x4E, 0xD1, 0x73, 0x82,
  0x24, 0x07, 0xA8, 0x27, 0x03, 0x16, 0x00, 0x16, 0x07, 0xA0, 0x77, 0x18, 0x21, 0xDD, 0x15, 0x07,
  0xA0, 0x77, 0x01, 0x0D, 0xA0, 0xD5, 0x07, 0xA0, 0x76, 0x01, 0x0D, 0xA0, 0xE0, 0x45, 0x07, 0xA0,
  0x75, 0x01, 0x0D, 0xA8, 0x1E, 0x51, 0x50, 0x7A, 0x07, 0x40, 0x10, 0xDF, 0x83, 0xD9, 0x30, 0x7A,
  0x07, 0x40, 0xBF, 0xC0, 0x90, 0x8A, 0x07, 0x40, 0x10, 0xDD, 0x0D, 0x0E, 0xF0, 0x75, 0x01, 0x0D,
  0xA0, 0xE0, 0x42, 0x02, 0x09, 0xD0, 0x76, 0x01, 0x0D, 0xA0, 0xE0, 0x43, 0x05, 0xC0, 0x77, 0x01,
  0x0D, 0xA0, 0xD4, 0x06, 0xB0, 0x77, 0x18, 0x21, 0xDD, 0x15, 0x0D, 0xA0, 0x77, 0x20, 0x01, 0x60,
  0x8A, 0x07, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x30,
  0x7A, 0x07, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x38, 0x23, 0x77, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_fork_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 26, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_fork_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_fork_right 36x36, 4-bit Alpha,  RLE, 171 bytes.
static const unsigned char ic_filled_36_maps_fork_right_data[] PROGMEM = {
  0x50, 0x01, 0x77, 0x48, 0x21, 0xDD, 0x17, 0x72, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x70, 0x10, 0xDC,
  0x0D, 0x01, 0x75, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x30, 0x10, 0xDF, 0x90, 0xD0, 0x17, 0x20, 0xBA,
  0x0E, 0x0B, 0xA0, 0xBB, 0x0B, 0x72, 0x83, 0x1D, 0xE4, 0x7A, 0x83, 0x74, 0xFD, 0x17, 0x38, 0x21,
  0x30, 0x7A, 0x82, 0x70, 0x42, 0x77, 0x07, 0xA0, 0x76, 0x00, 0x17, 0x20, 0x7A, 0x07, 0x58, 0x21,
  0xDD, 0x17, 0x10, 0x7A, 0x07, 0x50, 0xDA, 0x0D, 0x01, 0x70, 0x7A, 0x07, 0x50, 0x40, 0xEA, 0x0D,
  0x01, 0x60, 0x7A, 0x07, 0x58, 0x11, 0x5E, 0xA0, 0xD0, 0x15, 0x07, 0xA8, 0x37, 0x03, 0x9D, 0xF0,
  0xD0, 0x14, 0x07, 0xA0, 0x80, 0x9F, 0xC0, 0xB4, 0x07, 0xF0, 0xE0, 0xDD, 0x0D, 0x01, 0x40, 0x7D,
  0x09, 0x02, 0x20, 0x40, 0xEA, 0x0D, 0x01, 0x50, 0x7C, 0x05, 0x30, 0x40, 0xEA, 0x0D, 0x01, 0x60,
  0x7B, 0x06, 0x40, 0xDA, 0x0D, 0x01, 0x70, 0x7A, 0x0D, 0x58, 0x21, 0xDD, 0x17, 0x10, 0x7A, 0x08,
  0x60, 0x01, 0x72, 0x07, 0xA0, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x73, 0x07,
  0xA0, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x73, 0x82, 0x37, 0x73, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_fork_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_fork_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_fort 36x36, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_filled_36_maps_fort_data[] PROGMEM = {
  0x82, 0x37, 0x73, 0x28, 0x23, 0x77, 0x32, 0x82, 0x37, 0x73, 0x28, 0x23, 0x77, 0x32, 0x82, 0x37,
  0x73, 0x28, 0x33, 0x77, 0x37, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x07, 0xA8, 0x2B, 0x77, 0xBA, 0x82, 0xB7, 0x7B, 0xA0, 0x72,
  0x07, 0xA8, 0x2B, 0x77, 0xBA, 0x82, 0xB7, 0x7B, 0xA0, 0x07, 0xFF, 0x07, 0x20, 0x7F, 0xF0, 0x07,
  0xFF, 0x07, 0x20, 0x7F, 0xF0, 0x70, 0x5F, 0xF0, 0x52, 0x05, 0xFF, 0x81, 0x50, 0x7F, 0xD0, 0x74,
  0x07, 0xFD, 0x07, 0x30, 0x7F, 0xB0, 0x76, 0x07, 0xFB, 0x07, 0x50, 0x9F, 0x90, 0x97, 0x10, 0x9F,
  0x90, 0x96, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x07, 0x60, 0x7F, 0xFF, 0xD0, 0x76, 0x07, 0xFF,
  0xFD, 0x07, 0x60, 0x7F, 0xFF, 0xD0, 0x76, 0x07, 0xFF, 0xFD, 0x07, 0x60, 0x7F, 0xFF, 0xD0, 0x76,
  0x07, 0xFF, 0xFD, 0x07, 0x60, 0x7F, 0xFF, 0xD0, 0x76, 0x09, 0xFF, 0xFD, 0x09, 0x50, 0x7F, 0xFF,
  0xF0, 0x73, 0x07, 0xFE, 0x82, 0x71, 0x17, 0xFE, 0x81, 0x70, 0x5F, 0xE0, 0x74, 0x07, 0xFE, 0x05,
  0x07, 0xFE, 0x01, 0x40, 0x1F, 0xE0, 0x07, 0xFE, 0x6F, 0xE0, 0x07, 0xFE, 0x6F, 0xE0, 0x07, 0xFE,
  0x6F, 0xE0, 0x07, 0xFE, 0x6F, 0xE0, 0x70, 0x38, 0x09, 0x17, 0x68, 0x09, 0x17, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_fort() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_fort_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_hail 36x36, 4-bit Alpha,  RLE, 193 bytes.
static const unsigned char ic_filled_36_maps_hail_data[] PROGMEM = {
  0x73, 0x82, 0x8D, 0xD8, 0x50, 0x7A, 0x07, 0x72, 0x08, 0xC0, 0x84, 0x08, 0xA0, 0x67, 0x20, 0xDC,
  0x0D, 0x40, 0xAA, 0x04, 0x72, 0x0D, 0xC0, 0xD4, 0x0E, 0xA7, 0x30, 0x8C, 0x08, 0x30, 0x8A, 0x0B,
  0x74, 0x82, 0x8D, 0xD8, 0x30, 0x5B, 0x04, 0x77, 0x20, 0x10, 0x9B, 0x0A, 0x74, 0x84, 0x25, 0x77,
  0x9B, 0xC0, 0xB7, 0x28, 0x11, 0x8E, 0xFA, 0x09, 0x72, 0x07, 0xFB, 0x0B, 0x02, 0x72, 0x0B, 0xFC,
  0x07, 0x72, 0x0A, 0xFD, 0x07, 0x71, 0x04, 0xB0, 0xA0, 0x9F, 0x90, 0x77, 0x10, 0xCA, 0x81, 0xA0,
  0x7F, 0x90, 0x77, 0x01, 0xB8, 0x11, 0x07, 0xF9, 0x07, 0x70, 0x5A, 0x0B, 0x20, 0x7F, 0x90, 0x77,
  0x06, 0xA0, 0x82, 0x07, 0xF9, 0x07, 0x70, 0x7A, 0x07, 0x20, 0x7F, 0x90, 0x77, 0x60, 0x7F, 0x90,
  0x77, 0x60, 0x7F, 0x90, 0x77, 0x60, 0x7F, 0x90, 0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x76, 0xC0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_hail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_hail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_handyman 36x36, 4-bit Alpha,  RLE, 234 bytes.
static const unsigned char ic_filled_36_maps_handyman_data[] PROGMEM = {
  0x77, 0x50, 0x37, 0x77, 0x78, 0x13, 0xEB, 0x75, 0x03, 0x09, 0x75, 0x82, 0x3E, 0xFD, 0x74, 0x82,
  0x3E, 0xFA, 0x73, 0x03, 0x0E, 0xA0, 0xD7, 0x30, 0x30, 0xEB, 0x0A, 0x71, 0x03, 0x0E, 0xB8, 0x2D,
  0x0B, 0xB6, 0x03, 0x0E, 0xD0, 0xA6, 0x03, 0x0E, 0xC0, 0xE0, 0xBA, 0x0B, 0x50, 0xBF, 0x09, 0x60,
  0xA8, 0x00, 0xDD, 0x0B, 0x50, 0xBE, 0x0B, 0x73, 0x0B, 0xE0, 0xB5, 0x0B, 0xD0, 0xC7, 0x20, 0xBF,
  0x90, 0xB5, 0x0B, 0xD0, 0x87, 0x10, 0xBF, 0xA0, 0xA5, 0x81, 0xBD, 0xEB, 0x08, 0x71, 0x0D, 0xFA,
  0x04, 0x70, 0xAB, 0x08, 0x60, 0x9F, 0xB0, 0x77, 0x10, 0xAB, 0x08, 0x40, 0x9B, 0x0E, 0xA0, 0xB0,
  0x8B, 0x08, 0x72, 0x0A, 0xB0, 0x82, 0x09, 0xB8, 0x29, 0x0B, 0xB2, 0x08, 0xA0, 0x57, 0x30, 0xAB,
  0x08, 0x09, 0xB0, 0x97, 0x08, 0x0D, 0x75, 0x0A, 0xE0, 0x97, 0x20, 0x17, 0x60, 0xAC, 0x09, 0x77,
  0x73, 0x09, 0xB0, 0x97, 0x77, 0x82, 0x89, 0x9B, 0xB0, 0x93, 0x81, 0x3B, 0x97, 0x71, 0x0B, 0xE0,
  0x93, 0x03, 0x0E, 0xA0, 0xB7, 0x60, 0xBE, 0x0C, 0x30, 0x30, 0xEC, 0x0B, 0x74, 0x0B, 0xF0, 0xA2,
  0x03, 0x0E, 0xE0, 0xB7, 0x20, 0xBF, 0x90, 0xA2, 0x0B, 0xF9, 0x0B, 0x70, 0xBF, 0xA0, 0x92, 0x0A,
  0xFA, 0x0B, 0x50, 0xBF, 0xA0, 0xB4, 0x0C, 0xFA, 0x0B, 0x30, 0xBF, 0xA0, 0xB6, 0x0C, 0xFA, 0x81,
  0xB0, 0xAF, 0xA0, 0xB7, 0x10, 0xCF, 0xA0, 0x90, 0xEF, 0x90, 0xB7, 0x30, 0xCF, 0x90, 0xD0, 0x6F,
  0x0B, 0x75, 0x0C, 0xF8, 0x15, 0x06, 0xD0, 0xB7, 0x70, 0xCD, 0x05, 0x30, 0x6B, 0x0B, 0x77, 0x20,
  0xCB, 0x05, 0x58, 0x16, 0xEA, 0x77, 0x48, 0x1A, 0xE5, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_handyman() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_handyman_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_hardware 36x36, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_filled_36_maps_hardware_data[] PROGMEM = {
  0x50, 0x30, 0x68, 0x05, 0x70, 0x33, 0x01, 0x0F, 0x73, 0x04, 0x0D, 0xFC, 0x07, 0x20, 0x10, 0xDB,
  0x20, 0x8F, 0xE8, 0x27, 0x01, 0xDC, 0x10, 0x7F, 0xF8, 0x17, 0x1D, 0xD0, 0x1F, 0xF9, 0x09, 0x0D,
  0xE0, 0x8F, 0xFF, 0xA0, 0xCF, 0xFF, 0xA0, 0xEF, 0xFF, 0xA7, 0x07, 0xF9, 0x09, 0x0D, 0xE7, 0x07,
  0xF9, 0x81, 0x71, 0xDD, 0x70, 0x7F, 0x98, 0x27, 0x01, 0xDC, 0x70, 0x7F, 0x90, 0x72, 0x01, 0x0D,
  0xB7, 0x03, 0x80, 0x47, 0x03, 0x30, 0x10, 0xF7, 0x80, 0xE3, 0x00, 0x38, 0x04, 0x70, 0x37, 0x70,
  0x7F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x70,
  0x7F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x70,
  0x7F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x77, 0x70, 0x5F, 0x90, 0x57, 0x71, 0x05, 0x80, 0x27, 0x05,
  0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_hardware() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_hardware_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_home_repair_service 36x36, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_filled_36_maps_home_repair_service_data[] PROGMEM = {
  0x71, 0x03, 0x0B, 0xFB, 0x0B, 0x03, 0x77, 0x10, 0x10, 0xEF, 0xD0, 0xE0, 0x17, 0x70, 0x6F, 0xF0,
  0x67, 0x70, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0,
  0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09, 0xB4, 0xF3, 0xFD, 0x3F, 0xD3, 0xFD, 0x3F, 0xD3, 0xFD, 0x3E,
  0x77, 0x77, 0x28, 0x02, 0x73, 0x80, 0x90, 0x73, 0x80, 0x27, 0xE3, 0xFD, 0x38, 0x0A, 0xE6, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_home_repair_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_home_repair_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_hotel 36x36, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_filled_36_maps_hotel_data[] PROGMEM = {
  0x82, 0x37, 0x73, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x77, 0x20,
  0x7A, 0x07, 0x48, 0x14, 0x74, 0x40, 0x38, 0x09, 0x07, 0x05, 0x02, 0x40, 0x7A, 0x07, 0x20, 0x40,
  0xEB, 0x0E, 0x04, 0x20, 0x7F, 0xF0, 0xA0, 0x12, 0x07, 0xA8, 0x17, 0x02, 0xF8, 0x12, 0x07, 0xFF,
  0x98, 0x2D, 0x10, 0x7A, 0x81, 0x70, 0xAF, 0x81, 0xA0, 0x7F, 0xFA, 0x81, 0xA0, 0x7A, 0x81, 0x70,
  0xDF, 0x81, 0xD0, 0x7F, 0xFB, 0x02, 0x07, 0xA8, 0x17, 0x0D, 0xF8, 0x1D, 0x07, 0xFF, 0xB0, 0x60,
  0x7A, 0x81, 0x70, 0xAF, 0x81, 0xA0, 0x7F, 0xFB, 0x00, 0x7A, 0x81, 0x70, 0x2F, 0x81, 0x20, 0x7F,
  0xFB, 0x00, 0x7A, 0x07, 0x20, 0x40, 0xEB, 0x0E, 0x04, 0x20, 0x7F, 0xFB, 0x00, 0x7A, 0x07, 0x48,
  0x14, 0x74, 0x40, 0x7F, 0xFB, 0x00, 0x7A, 0x07, 0x74, 0x07, 0xFF, 0xB0, 0x07, 0xFF, 0xFF, 0xC0,
  0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xA0, 0xB8, 0x0A,
  0x67, 0x0B, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_hotel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_hotel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_hvac 36x36, 4-bit Alpha,  RLE, 191 bytes.
static const unsigned char ic_filled_36_maps_hvac_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFA, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF, 0xA0, 0x07, 0xF0,
  0xD0, 0x37, 0x10, 0x30, 0xDF, 0x00, 0x7E, 0x0B, 0x01, 0x73, 0x01, 0x0B, 0xE0, 0x07, 0xD0, 0xD0,
  0x13, 0x84, 0x6B, 0xEE, 0xB6, 0x30, 0x10, 0xDD, 0x00, 0x7D, 0x03, 0x30, 0x48, 0x02, 0x70, 0x43,
  0x03, 0xD0, 0x07, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x07, 0xC0, 0x62, 0x06, 0xFB, 0x06, 0x20, 0x6C,
  0x00, 0x7C, 0x02, 0x20, 0xBF, 0xB0, 0xB2, 0x02, 0xC0, 0x07, 0xC3, 0x80, 0x90, 0x33, 0xC0, 0x07,
  0xC3, 0x80, 0x90, 0x33, 0xC0, 0x07, 0xC0, 0x22, 0x0B, 0xFB, 0x0B, 0x20, 0x2C, 0x00, 0x7C, 0x06,
  0x20, 0x6F, 0xB0, 0x62, 0x06, 0xC0, 0x07, 0xC0, 0xB7, 0x72, 0x0B, 0xC0, 0x07, 0xD0, 0x33, 0x04,
  0x80, 0x27, 0x04, 0x30, 0x3D, 0x00, 0x7D, 0x0D, 0x01, 0x38, 0x46, 0xBE, 0xEB, 0x63, 0x01, 0x0D,
  0xD0, 0x07, 0xE0, 0xB0, 0x17, 0x30, 0x10, 0xBE, 0x00, 0x7F, 0x0D, 0x03, 0x71, 0x03, 0x0D, 0xF0,
  0x07, 0xFA, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF, 0xA0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_hvac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_hvac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_icecream 36x36, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_filled_36_maps_icecream_data[] PROGMEM = {
  0x71, 0x86, 0x29, 0xCE, 0xEC, 0x92, 0x77, 0x10, 0x9F, 0x90, 0x97, 0x60, 0xCF, 0xB0, 0xC7, 0x40,
  0xBF, 0xD0, 0xB7, 0x20, 0x5F, 0xF0, 0x57, 0x10, 0xBF, 0xF0, 0xB7, 0x1F, 0xFA, 0x70, 0x6F, 0xFA,
  0x06, 0x40, 0x40, 0xEF, 0xFC, 0x82, 0xE4, 0x02, 0xFF, 0xF9, 0x02, 0x0A, 0xFF, 0xF9, 0x0A, 0x0E,
  0xFF, 0xF9, 0x0E, 0x0D, 0xFF, 0xF9, 0x0D, 0x0A, 0xFF, 0xF9, 0x0A, 0x02, 0xFF, 0xF9, 0x82, 0x20,
  0x4E, 0xC0, 0x80, 0xAE, 0x0A, 0x08, 0xC0, 0xE0, 0x44, 0x04, 0x0C, 0xA8, 0x90, 0xA0, 0x15, 0x77,
  0x51, 0x09, 0xA0, 0xC0, 0x47, 0x03, 0xB0, 0x26, 0x02, 0xB0, 0x47, 0x20, 0xAA, 0x0A, 0x60, 0x9A,
  0x0B, 0x73, 0x02, 0xB0, 0x34, 0x02, 0xB0, 0x37, 0x40, 0xAA, 0x0B, 0x40, 0xAA, 0x0B, 0x75, 0x02,
  0xB0, 0x42, 0x02, 0xB0, 0x37, 0x60, 0x9A, 0x0C, 0x20, 0xAA, 0x0A, 0x77, 0x01, 0xB0, 0x50, 0x3B,
  0x03, 0x77, 0x10, 0x8A, 0x0D, 0x0B, 0xA0, 0xA7, 0x72, 0x01, 0x0E, 0xD0, 0x27, 0x73, 0x07, 0xC0,
  0xA7, 0x75, 0x0E, 0xB0, 0x27, 0x75, 0x07, 0xA0, 0x97, 0x77, 0x81, 0xDF, 0x27, 0x77, 0x06, 0x09,
  0x77, 0x72, 0x01, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_icecream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_icecream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_kebab_dining 36x36, 4-bit Alpha,  RLE, 264 bytes.
static const unsigned char ic_filled_36_maps_kebab_dining_data[] PROGMEM = {
  0x58, 0x14, 0x74, 0x75, 0x81, 0x47, 0x47, 0x38, 0x19, 0xF9, 0x75, 0x81, 0x9F, 0x97, 0x07, 0x0D,
  0xD0, 0xD0, 0x76, 0x07, 0x0D, 0xD0, 0xD0, 0x73, 0x0A, 0xFA, 0x0A, 0x40, 0xAF, 0xA8, 0x1A, 0x03,
  0xFC, 0x03, 0x20, 0x3F, 0xC0, 0x30, 0x6F, 0xC0, 0x62, 0x06, 0xFC, 0x06, 0x05, 0xFC, 0x05, 0x20,
  0x5F, 0xC8, 0x15, 0x1E, 0xFA, 0x0E, 0x01, 0x20, 0x10, 0xEF, 0xA8, 0x3E, 0x10, 0x4E, 0xF0, 0xE0,
  0x44, 0x04, 0x0E, 0xF0, 0xE0, 0x43, 0x87, 0x15, 0x7C, 0xFC, 0x75, 0x16, 0x87, 0x15, 0x7C, 0xFC,
  0x75, 0x17, 0x81, 0x9F, 0x97, 0x58, 0x19, 0xF9, 0x50, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F,
  0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC,
  0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72, 0x07, 0xFC, 0x00, 0x7F, 0xC0, 0x72,
  0x07, 0xFC, 0x89, 0x47, 0x37, 0x77, 0x7C, 0xFC, 0x77, 0x77, 0x32, 0x89, 0x33, 0x77, 0x77, 0xCF,
  0xC7, 0x77, 0x73, 0x58, 0x19, 0xF9, 0x75, 0x81, 0x9F, 0x97, 0x07, 0x0D, 0xD0, 0xD0, 0x76, 0x07,
  0x0D, 0xD0, 0xD0, 0x73, 0x0A, 0xFA, 0x0A, 0x40, 0xAF, 0xA8, 0x1A, 0x03, 0xFC, 0x03, 0x20, 0x3F,
  0xC0, 0x30, 0x6F, 0xC0, 0x62, 0x06, 0xFC, 0x06, 0x05, 0xFC, 0x05, 0x20, 0x5F, 0xC8, 0x15, 0x1E,
  0xFA, 0x0E, 0x01, 0x20, 0x10, 0xEF, 0xA8, 0x3E, 0x10, 0x4E, 0xF0, 0xE0, 0x44, 0x04, 0x0E, 0xF0,
  0xE0, 0x43, 0x87, 0x15, 0x7C, 0xFC, 0x75, 0x16, 0x87, 0x15, 0x7C, 0xFC, 0x75, 0x17, 0x81, 0x9F,
  0x97, 0x58, 0x19, 0xF9, 0x73, 0x81, 0x9F, 0x97, 0x58, 0x19, 0xF9, 0x73, 0x81, 0x9F, 0x97, 0x58,
  0x19, 0xF9, 0x73, 0x81, 0x9F, 0x97, 0x58, 0x19, 0xF9, 0x73, 0x81, 0x9F, 0x97, 0x58, 0x19, 0xF9,
  0x73, 0x81, 0x47, 0x47, 0x58, 0x14, 0x74, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_kebab_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_kebab_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_layers_clear 36x36, 4-bit Alpha,  RLE, 291 bytes.
static const unsigned char ic_filled_36_maps_layers_clear_data[] PROGMEM = {
  0x10, 0x20, 0x17, 0x77, 0x68, 0x22, 0xEC, 0x17, 0x77, 0x50, 0xBA, 0x0C, 0x01, 0x72, 0x00, 0x97,
  0x70, 0x10, 0xCA, 0x0C, 0x01, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x76, 0x01, 0x0C, 0xA0, 0xC0, 0x14,
  0x04, 0x0E, 0xC0, 0xE0, 0x47, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x20, 0x10, 0xEF, 0x07, 0x76, 0x01,
  0x0C, 0xA0, 0xC0, 0x12, 0x04, 0xF9, 0x0B, 0x01, 0x75, 0x01, 0x0C, 0xA0, 0xC0, 0x12, 0x04, 0xF9,
  0x0D, 0x03, 0x75, 0x01, 0x0D, 0xA0, 0xC0, 0x12, 0x04, 0xFA, 0x06, 0x74, 0x09, 0xC0, 0xC0, 0x12,
  0x04, 0xFA, 0x09, 0x71, 0x01, 0x0C, 0xE0, 0xC0, 0x12, 0x04, 0xFA, 0x0C, 0x01, 0x50, 0x40, 0xEF,
  0x90, 0xC0, 0x12, 0x04, 0xFA, 0x0E, 0x04, 0x30, 0x3F, 0xC0, 0xC0, 0x12, 0x04, 0xFB, 0x03, 0x30,
  0x40, 0xEF, 0xB0, 0xC0, 0x12, 0x04, 0xF0, 0xE0, 0x45, 0x01, 0x0C, 0xFB, 0x0C, 0x01, 0x20, 0x4D,
  0x0C, 0x01, 0x71, 0x09, 0xFB, 0x0C, 0x01, 0x20, 0x4B, 0x09, 0x74, 0x06, 0xFB, 0x0C, 0x01, 0x28,
  0x14, 0xE6, 0x76, 0x03, 0x0D, 0xFA, 0x0C, 0x01, 0x76, 0x06, 0x05, 0x30, 0x10, 0xBF, 0xA0, 0xC0,
  0x14, 0x81, 0x5C, 0x14, 0x0A, 0xA0, 0x84, 0x07, 0xFA, 0x0C, 0x01, 0x20, 0x2A, 0x0C, 0x01, 0x20,
  0x20, 0xCB, 0x0C, 0x01, 0x30, 0x40, 0xEC, 0x0E, 0x0D, 0xA0, 0xC0, 0x12, 0x82, 0x4F, 0xC2, 0x40,
  0xAB, 0x0E, 0x03, 0x30, 0x10, 0xCA, 0x82, 0xC1, 0x1C, 0xA0, 0xC0, 0x12, 0x03, 0x70, 0x6C, 0x07,
  0x40, 0x09, 0x30, 0x10, 0xEA, 0x0C, 0x01, 0x73, 0x03, 0x0D, 0xB0, 0xA7, 0x10, 0xAC, 0x0C, 0x01,
  0x73, 0x01, 0x0B, 0xB0, 0xD0, 0x24, 0x02, 0x0D, 0xE0, 0xC0, 0x17, 0x40, 0x8B, 0x0E, 0x05, 0x20,
  0x50, 0xEB, 0x81, 0x81, 0xCA, 0x0C, 0x01, 0x74, 0x05, 0x0E, 0xB0, 0x09, 0xB0, 0xE0, 0x52, 0x01,
  0x0C, 0xA0, 0xC0, 0x17, 0x40, 0x20, 0xCE, 0x0C, 0x02, 0x40, 0x10, 0xCA, 0x0C, 0x01, 0x75, 0x0A,
  0xC0, 0xA7, 0x01, 0x0C, 0xA0, 0xB7, 0x60, 0x6A, 0x06, 0x72, 0x82, 0x1C, 0xE2, 0x77, 0x00, 0x37,
  0x40, 0x10, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_layers_clear() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_layers_clear_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_layers 36x36, 4-bit Alpha,  RLE, 196 bytes.
static const unsigned char ic_filled_36_maps_layers_data[] PROGMEM = {
  0x76, 0x00, 0x97, 0x77, 0x30, 0x10, 0xCA, 0x0C, 0x01, 0x77, 0x70, 0x40, 0xEC, 0x0E, 0x04, 0x77,
  0x50, 0x7F, 0x90, 0x77, 0x72, 0x01, 0x0B, 0xFB, 0x0B, 0x01, 0x76, 0x03, 0x0D, 0xFD, 0x0D, 0x03,
  0x74, 0x06, 0xFF, 0xA0, 0x67, 0x20, 0x9F, 0xFC, 0x09, 0x60, 0x10, 0xCF, 0xFE, 0x0C, 0x01, 0x30,
  0x40, 0xEF, 0xFF, 0x98, 0x2E, 0x40, 0x3F, 0xFF, 0xD8, 0x23, 0x04, 0xEF, 0xFF, 0x90, 0xE0, 0x43,
  0x01, 0x0C, 0xFF, 0xE0, 0xC0, 0x16, 0x09, 0xFF, 0xC0, 0x97, 0x20, 0x6F, 0xF9, 0x0E, 0x05, 0x74,
  0x03, 0x0D, 0xFD, 0x0D, 0x03, 0x71, 0x06, 0x05, 0x30, 0x10, 0xBF, 0xB0, 0xB0, 0x13, 0x05, 0x06,
  0x30, 0xAA, 0x08, 0x40, 0x7F, 0x90, 0x74, 0x09, 0xA8, 0x2A, 0x02, 0xCB, 0x0B, 0x01, 0x30, 0x40,
  0xEC, 0x0E, 0x04, 0x30, 0x10, 0xCB, 0x0C, 0x02, 0x20, 0xAB, 0x0E, 0x03, 0x30, 0x10, 0xCA, 0x0C,
  0x01, 0x30, 0x40, 0xEB, 0x0A, 0x50, 0x6C, 0x07, 0x40, 0x09, 0x40, 0x7C, 0x06, 0x70, 0x30, 0xDB,
  0x0A, 0x71, 0x0A, 0xB0, 0xD0, 0x37, 0x20, 0x10, 0xBB, 0x0D, 0x02, 0x40, 0x20, 0xDB, 0x0B, 0x01,
  0x75, 0x08, 0xB0, 0xE0, 0x52, 0x05, 0x0E, 0xB0, 0x87, 0x71, 0x05, 0x0E, 0xB0, 0x80, 0x9B, 0x0E,
  0x05, 0x77, 0x30, 0x20, 0xCE, 0x0C, 0x02, 0x77, 0x60, 0xAC, 0x0A, 0x77, 0x72, 0x06, 0xA0, 0x67,
  0x77, 0x40, 0x03, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_layers() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_layers_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_liquor 36x36, 4-bit Alpha,  RLE, 220 bytes.
static const unsigned char ic_filled_36_maps_liquor_data[] PROGMEM = {
  0x77, 0x30, 0x8D, 0x0D, 0x02, 0x77, 0x7F, 0x07, 0x77, 0x7F, 0x07, 0x77, 0x7B, 0x10, 0x7A, 0x07,
  0x77, 0x7B, 0x07, 0x0B, 0xA0, 0x77, 0x77, 0xF0, 0x74, 0x07, 0xF9, 0x07, 0x7F, 0x07, 0x40, 0x7F,
  0x90, 0x77, 0xB0, 0x70, 0xBA, 0x07, 0x40, 0x7F, 0x90, 0x76, 0x03, 0xA8, 0x1E, 0x06, 0xA0, 0xA4,
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0x81, 0x27, 0xEA, 0x81, 0xA0, 0x2B, 0x0A, 0x05, 0x20, 0x7A,
  0x07, 0x20, 0x7A, 0x07, 0x30, 0x7C, 0x0E, 0x02, 0x20, 0x9C, 0x81, 0xD2, 0x7A, 0x07, 0x20, 0x7A,
  0x07, 0x20, 0x3C, 0x0D, 0x03, 0x40, 0x9C, 0x0B, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0xC0, 0x57, 0x02, 0x07, 0xA0, 0xE0, 0x7A, 0x82, 0xB7, 0x7B, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x3B,
  0x07, 0xF9, 0x07, 0x20, 0x7A, 0x07, 0x73, 0xB0, 0x7F, 0x90, 0x72, 0x07, 0xFF, 0xA0, 0x7F, 0x90,
  0x72, 0x07, 0xFF, 0xA0, 0x7F, 0x90, 0x72, 0x07, 0xFF, 0xA0, 0x6F, 0x90, 0x62, 0x07, 0xFF, 0xA0,
  0x3F, 0x90, 0x32, 0x07, 0xFF, 0xA1, 0x0A, 0xE0, 0xA3, 0x07, 0xFF, 0xA2, 0x0A, 0xC0, 0xA4, 0x07,
  0xFF, 0xA3, 0x08, 0xA0, 0x85, 0x07, 0xFF, 0xA3, 0x07, 0xA0, 0x75, 0x07, 0xFF, 0xA3, 0x07, 0xA0,
  0x75, 0x07, 0xA0, 0x77, 0x3B, 0x30, 0x7A, 0x07, 0x50, 0x7A, 0x07, 0x73, 0xB3, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x77, 0x3B, 0x07, 0xF9, 0x07, 0x20, 0x6F, 0xF9, 0x0D, 0x07, 0xF9, 0x07, 0x20, 0x10,
  0xEF, 0xF0, 0x80, 0x7F, 0x90, 0x73, 0x03, 0x0B, 0xFC, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_liquor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_liquor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_activity 36x36, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_filled_36_maps_local_activity_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDF, 0xF0,
  0x0A, 0xFF, 0xFF, 0x00, 0x4F, 0xFF, 0xE0, 0xD2, 0x0D, 0xFF, 0xFD, 0x07, 0x20, 0x8F, 0xFF, 0xD0,
  0x12, 0x02, 0xFF, 0xE8, 0x4D, 0xDC, 0xBA, 0x74, 0x84, 0x7A, 0xBC, 0xDE, 0xF0, 0x10, 0x7C, 0x0C,
  0x01, 0x77, 0x01, 0x0C, 0xC0, 0x70, 0x12, 0x07, 0xC0, 0xE0, 0x37, 0x50, 0x30, 0xEC, 0x07, 0x40,
  0x1E, 0x06, 0x73, 0x06, 0xE0, 0x14, 0x01, 0xF0, 0x97, 0x10, 0x9F, 0x01, 0x40, 0x7F, 0x90, 0x16,
  0x02, 0xF9, 0x07, 0x20, 0x10, 0x7F, 0x90, 0xD7, 0x10, 0xDF, 0x90, 0x70, 0x1F, 0xB0, 0x97, 0x10,
  0x9F, 0xFE, 0x05, 0x28, 0x24, 0xDD, 0x42, 0x05, 0xFF, 0xE8, 0x11, 0x19, 0xC8, 0x19, 0x11, 0xFF,
  0xD8, 0x1C, 0x5E, 0xE8, 0x1E, 0x5C, 0x80, 0x98, 0x1F, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF,
  0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_activity() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_activity_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_airport 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_filled_36_maps_local_airport_data[] PROGMEM = {
  0x76, 0x82, 0x5D, 0xD5, 0x77, 0x74, 0x01, 0xC0, 0x17, 0x77, 0x30, 0x3C, 0x03, 0x77, 0x73, 0x03,
  0xC0, 0x37, 0x77, 0x30, 0x3C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x03, 0x77,
  0x73, 0x03, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x37, 0x77, 0x30, 0x7C,
  0x07, 0x77, 0x71, 0x02, 0x0B, 0xE0, 0xB0, 0x27, 0x74, 0x01, 0x09, 0xFB, 0x09, 0x01, 0x77, 0x10,
  0x60, 0xEF, 0xD0, 0xE0, 0x67, 0x50, 0x30, 0xCF, 0xFA, 0x0C, 0x03, 0x71, 0x01, 0x09, 0xFF, 0xE0,
  0x90, 0x15, 0x07, 0x0E, 0xFF, 0xF9, 0x0E, 0x07, 0x20, 0x40, 0xDF, 0x98, 0x1E, 0x98, 0xC8, 0x18,
  0x9E, 0xF9, 0x0D, 0x04, 0xF8, 0x1C, 0x73, 0x20, 0x3C, 0x03, 0x28, 0x13, 0x7C, 0xFB, 0x82, 0xEA,
  0x51, 0x50, 0x3C, 0x03, 0x58, 0x21, 0x5A, 0xEB, 0x81, 0xD8, 0x47, 0x20, 0x3C, 0x03, 0x72, 0x81,
  0x48, 0xD7, 0x50, 0x3C, 0x03, 0x77, 0x73, 0x03, 0xC0, 0x37, 0x77, 0x30, 0x3C, 0x03, 0x77, 0x73,
  0x03, 0xC0, 0x37, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x71, 0x02, 0x0B, 0xE0, 0xB0, 0x27, 0x75, 0x08,
  0xFB, 0x08, 0x77, 0x4C, 0x82, 0xD9, 0x9D, 0xC7, 0x74, 0x82, 0xD9, 0x51, 0x48, 0x21, 0x59, 0xD7,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_airport() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_airport_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_atm 36x36, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_filled_36_maps_local_atm_data[] PROGMEM = {
  0x10, 0x80, 0xEF, 0xFF, 0xB8, 0x2E, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDB, 0x77,
  0x73, 0xE7, 0x38, 0x23, 0x77, 0x37, 0x3E, 0x73, 0x07, 0xA0, 0x77, 0x3E, 0x70, 0x20, 0xDF, 0x07,
  0x7E, 0x70, 0x7F, 0x90, 0x77, 0xE7, 0x07, 0xF9, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x76, 0xE7, 0x07,
  0xA8, 0x4B, 0x77, 0x77, 0x57, 0x1E, 0x70, 0x7F, 0x90, 0x57, 0xE7, 0x05, 0xF9, 0x07, 0x7E, 0x71,
  0x84, 0x57, 0x77, 0x7B, 0xA0, 0x77, 0xE7, 0x60, 0x7A, 0x07, 0x7E, 0x70, 0x7F, 0x90, 0x77, 0xE7,
  0x07, 0xF9, 0x07, 0x7E, 0x70, 0x7F, 0x0D, 0x02, 0x7E, 0x73, 0x07, 0xA0, 0x77, 0x3E, 0x73, 0x82,
  0x37, 0x73, 0x73, 0xE7, 0x77, 0x3B, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8E,
  0xFF, 0xFB, 0x0E, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_atm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_atm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_bar 36x36, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_filled_36_maps_local_bar_data[] PROGMEM = {
  0x03, 0x80, 0xA6, 0x70, 0x30, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x06, 0xB0, 0xD8, 0x09,
  0x67, 0x0D, 0xB8, 0x16, 0x09, 0xB0, 0x57, 0x72, 0x05, 0xB0, 0x93, 0x0A, 0xB0, 0x47, 0x70, 0x4B,
  0x0A, 0x50, 0xCA, 0x0E, 0x80, 0x92, 0x70, 0xEA, 0x0C, 0x60, 0x10, 0xDF, 0xFC, 0x0D, 0x01, 0x70,
  0x20, 0xEF, 0xFA, 0x0E, 0x02, 0x72, 0x03, 0x0E, 0xFF, 0x0E, 0x03, 0x74, 0x04, 0xFF, 0x04, 0x76,
  0x06, 0xFD, 0x06, 0x77, 0x10, 0x7F, 0xB0, 0x77, 0x73, 0x09, 0xF9, 0x09, 0x77, 0x50, 0xAE, 0x0A,
  0x77, 0x70, 0xCC, 0x0C, 0x77, 0x71, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x77, 0x20, 0x7A, 0x07, 0x77,
  0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A,
  0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x38, 0x03, 0x70, 0xBA, 0x0B,
  0x80, 0x37, 0x73, 0xFF, 0xC7, 0x3F, 0xFC, 0x73, 0x80, 0x96, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_cafe 36x36, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_filled_36_maps_local_cafe_data[] PROGMEM = {
  0x80, 0xA4, 0x70, 0x60, 0x11, 0xFF, 0xFC, 0x0E, 0x03, 0xFF, 0xFD, 0x0B, 0xFF, 0xF0, 0xF7, 0xFF,
  0xFB, 0x3F, 0xFF, 0xB3, 0xFF, 0xFB, 0x3F, 0xFF, 0xB3, 0xFF, 0xFF, 0x90, 0xDF, 0xFF, 0xD0, 0x8F,
  0xFF, 0xB0, 0xD0, 0x81, 0xFF, 0xF6, 0xFF, 0xF6, 0xFF, 0xF6, 0xFF, 0xF6, 0xFF, 0xF6, 0x0D, 0xFF,
  0xD0, 0xD6, 0x09, 0xFF, 0xD0, 0x96, 0x02, 0xFF, 0xD0, 0x27, 0x06, 0xFF, 0xB0, 0x67, 0x20, 0x50,
  0xDF, 0xE0, 0xD0, 0x57, 0x50, 0x48, 0x07, 0x70, 0x48, 0x0F, 0x40, 0x80, 0xA4, 0x73, 0xFF, 0xFB,
  0x3F, 0xFF, 0xB3, 0x80, 0xA4, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_cafe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_cafe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_car_wash 36x36, 4-bit Alpha,  RLE, 221 bytes.
static const unsigned char ic_filled_36_maps_local_car_wash_data[] PROGMEM = {
  0x60, 0x76, 0x00, 0x46, 0x07, 0x74, 0x81, 0x7F, 0x74, 0x82, 0x1E, 0xE1, 0x48, 0x17, 0xF7, 0x72,
  0x02, 0xB0, 0x23, 0x09, 0xA0, 0x93, 0x02, 0xB0, 0x27, 0x10, 0x9B, 0x08, 0x20, 0x1C, 0x30, 0x9B,
  0x08, 0x71, 0x0A, 0xB0, 0xA2, 0x02, 0xC0, 0x22, 0x0A, 0xB0, 0xA7, 0x10, 0x4B, 0x04, 0x30, 0xCA,
  0x0C, 0x30, 0x4B, 0x04, 0x72, 0x81, 0x37, 0x35, 0x00, 0x65, 0x81, 0x37, 0x38, 0x0F, 0x50, 0x02,
  0x80, 0x96, 0x70, 0x27, 0x01, 0x0E, 0xFF, 0xC0, 0xE0, 0x26, 0x81, 0x8F, 0xE8, 0x09, 0x4B, 0x81,
  0xEF, 0x86, 0x81, 0xDF, 0x77, 0x72, 0x81, 0x7F, 0xD5, 0x03, 0xA0, 0x27, 0x72, 0x02, 0xA0, 0x34,
  0x81, 0x9F, 0xC7, 0x74, 0x81, 0xCF, 0x94, 0x81, 0xEF, 0x77, 0x74, 0x81, 0x7F, 0xE3, 0x04, 0xA0,
  0x27, 0x74, 0x02, 0xA0, 0x42, 0x81, 0x9F, 0xC7, 0x76, 0x81, 0xCF, 0x92, 0x81, 0xEF, 0xC8, 0x0A,
  0x07, 0x83, 0xCF, 0xE0, 0x5F, 0xFF, 0xD0, 0x50, 0x7F, 0xFF, 0xD0, 0x07, 0xB8, 0x1D, 0x8A, 0xFF,
  0x81, 0xA8, 0xDB, 0x00, 0x7A, 0x0D, 0x30, 0x6F, 0xD0, 0x63, 0x0D, 0xA0, 0x07, 0xA0, 0x83, 0x01,
  0xFD, 0x01, 0x30, 0x8A, 0x00, 0x7A, 0x0A, 0x30, 0x2F, 0xD0, 0x23, 0x0A, 0xA0, 0x07, 0xB8, 0x26,
  0x02, 0xCF, 0xD8, 0x2C, 0x20, 0x6B, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF,
  0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7C, 0x80, 0x96, 0x7C, 0x00, 0x7C, 0x77, 0x4C, 0x07, 0x05, 0xB0,
  0xD7, 0x74, 0x0D, 0xB8, 0x45, 0x05, 0x77, 0x27, 0x74, 0x82, 0x27, 0x75, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_car_wash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_car_wash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_convenience_store 36x36, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_filled_36_maps_local_convenience_store_data[] PROGMEM = {
  0x40, 0x7F, 0xFE, 0x07, 0x71, 0x07, 0xFF, 0xE0, 0x77, 0x10, 0x7F, 0xFE, 0x07, 0x71, 0x07, 0xFF,
  0xE0, 0x74, 0x80, 0x07, 0x0B, 0xC8, 0x00, 0x70, 0xBA, 0x83, 0xB7, 0xFB, 0x7C, 0x0B, 0x80, 0x07,
  0xFA, 0x40, 0x7A, 0x82, 0x70, 0xF7, 0x1F, 0xFF, 0x10, 0x7A, 0x82, 0x70, 0xF7, 0x1F, 0xFC, 0x0F,
  0x71, 0x07, 0xA8, 0x27, 0x07, 0x31, 0xFF, 0xC4, 0x07, 0xA0, 0x74, 0xFF, 0xC1, 0x07, 0xF9, 0x07,
  0x1F, 0xFC, 0x18, 0x23, 0x77, 0xBD, 0x07, 0x1F, 0xFC, 0x40, 0x7D, 0x07, 0x18, 0x0B, 0x85, 0xF6,
  0xFF, 0xFB, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_convenience_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_convenience_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_dining 36x36, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_filled_36_maps_local_dining_data[] PROGMEM = {
  0x77, 0x71, 0x82, 0x13, 0x31, 0x40, 0x50, 0x27, 0x73, 0x05, 0x0C, 0xC0, 0x92, 0x82, 0x1E, 0xE2,
  0x77, 0x01, 0x0B, 0xF8, 0x1B, 0x08, 0xA0, 0xE0, 0x27, 0x50, 0x10, 0xDF, 0xA0, 0x50, 0xCB, 0x0E,
  0x03, 0x74, 0x0A, 0xFB, 0x0A, 0x0D, 0xC0, 0xE0, 0x37, 0x20, 0x5F, 0xC0, 0xB0, 0xCD, 0x0E, 0x03,
  0x71, 0x0B, 0xFC, 0x0A, 0x08, 0xE0, 0xE0, 0x36, 0x01, 0xFD, 0x81, 0x71, 0xEE, 0x0E, 0x03, 0x50,
  0x3F, 0xD8, 0x11, 0x05, 0xF0, 0xE0, 0x34, 0x03, 0xFC, 0x08, 0x30, 0x5F, 0x0E, 0x03, 0x4F, 0xB0,
  0xC5, 0x05, 0xF0, 0xE0, 0x22, 0x03, 0x0E, 0xF9, 0x0B, 0x01, 0x60, 0x5E, 0x0A, 0x20, 0x30, 0xEF,
  0x0E, 0x08, 0x72, 0x05, 0xC0, 0xA2, 0x03, 0x0E, 0xA8, 0x5E, 0x69, 0xB9, 0x61, 0x74, 0x05, 0xA0,
  0xA2, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x74, 0x05, 0x09, 0x20, 0x30, 0xEB, 0x05, 0x77, 0x71, 0x03,
  0x0E, 0xC0, 0xE0, 0x27, 0x76, 0x03, 0x0E, 0xA0, 0x0E, 0xA0, 0xE0, 0x27, 0x74, 0x03, 0x0E, 0xA8,
  0x2E, 0x22, 0xEA, 0x0E, 0x02, 0x77, 0x20, 0x30, 0xEA, 0x0E, 0x02, 0x20, 0x20, 0xEA, 0x0E, 0x02,
  0x77, 0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x50, 0x30, 0xEA, 0x0E, 0x02,
  0x60, 0x20, 0xEA, 0x0E, 0x02, 0x73, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x10, 0x20, 0xEA, 0x0E, 0x02,
  0x71, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x30, 0x20, 0xEA, 0x0E, 0x02, 0x60, 0x30, 0xEA, 0x0E, 0x02,
  0x75, 0x02, 0x0E, 0xA0, 0xE0, 0x24, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x70, 0x20, 0xEA, 0x0E, 0x02,
  0x48, 0x2B, 0xFE, 0x27, 0x72, 0x82, 0x2E, 0xFB, 0x60, 0x90, 0x27, 0x74, 0x02, 0x0A, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_drink 36x36, 4-bit Alpha,  RLE, 173 bytes.
static const unsigned char ic_filled_36_maps_local_drink_data[] PROGMEM = {
  0x06, 0xFF, 0xFD, 0x06, 0x05, 0xFF, 0xFD, 0x05, 0x03, 0xFF, 0xFD, 0x03, 0x01, 0xA0, 0xD7, 0x76,
  0x0E, 0xA0, 0x11, 0xB7, 0x76, 0xB2, 0x0D, 0xA0, 0x17, 0x74, 0x02, 0xA0, 0xD2, 0x0C, 0xA0, 0x37,
  0x74, 0x03, 0xA0, 0xC2, 0x0A, 0xA0, 0x57, 0x74, 0x05, 0xA0, 0xA2, 0x08, 0xA0, 0x67, 0x74, 0x07,
  0xA0, 0x82, 0x07, 0xFF, 0xFB, 0x07, 0x20, 0x5F, 0xFF, 0xB0, 0x52, 0x03, 0xFF, 0xFB, 0x03, 0x20,
  0x1F, 0xFF, 0xB0, 0x13, 0xFC, 0x00, 0x7F, 0xC4, 0x0D, 0xFA, 0x0A, 0x20, 0xAF, 0xA0, 0xD4, 0x0C,
  0xF9, 0x0D, 0x01, 0x20, 0x10, 0xDF, 0x90, 0xC4, 0x0A, 0xF9, 0x05, 0x40, 0x5F, 0x90, 0xA4, 0x08,
  0xF0, 0xB6, 0x0B, 0xF0, 0x84, 0x07, 0xF0, 0x36, 0x03, 0xF0, 0x74, 0x05, 0xE0, 0xE7, 0x10, 0xCE,
  0x05, 0x40, 0x3E, 0x09, 0x71, 0x09, 0xE0, 0x34, 0x02, 0xE0, 0x97, 0x10, 0x9E, 0x02, 0x5E, 0x0C,
  0x71, 0x0C, 0xE6, 0x0E, 0xE0, 0x56, 0x05, 0xE0, 0xE6, 0x0C, 0xE0, 0xE0, 0x54, 0x05, 0x0E, 0xE0,
  0xC6, 0x0A, 0xF9, 0x82, 0xC9, 0x9C, 0xF9, 0x0A, 0x60, 0x8F, 0xFE, 0x08, 0x60, 0x6F, 0xFE, 0x06,
  0x60, 0x10, 0xEF, 0xFC, 0x0E, 0x01, 0x70, 0x30, 0xCF, 0xFA, 0x0C, 0x03, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_drink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_drink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_fire_department 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_filled_36_maps_local_fire_department_data[] PROGMEM = {
  0x73, 0x02, 0x0B, 0x77, 0x70, 0x7A, 0x77, 0x50, 0x10, 0xBB, 0x77, 0x40, 0x20, 0xDC, 0x77, 0x30,
  0x30, 0xED, 0x77, 0x20, 0x20, 0xEE, 0x01, 0x77, 0x02, 0x0E, 0xF0, 0x74, 0x81, 0x6A, 0x17, 0x0C,
  0xFA, 0x82, 0x71, 0x27, 0xA0, 0xD0, 0x15, 0x07, 0xFF, 0xB0, 0xD0, 0x13, 0x02, 0xFF, 0xD0, 0xB3,
  0x09, 0xFF, 0xE8, 0x15, 0x01, 0xFF, 0xF8, 0x1D, 0x05, 0xFB, 0x00, 0x9F, 0xB0, 0x40, 0x9F, 0xA0,
  0x92, 0x09, 0xFA, 0x09, 0x0C, 0xF9, 0x09, 0x40, 0x9F, 0x90, 0xC0, 0xEF, 0x08, 0x60, 0x9F, 0x0E,
  0xF0, 0x83, 0x00, 0x33, 0x08, 0xF0, 0xED, 0x09, 0x38, 0x23, 0xEE, 0x33, 0x09, 0xD0, 0xE0, 0xCC,
  0x0B, 0x30, 0x30, 0xEA, 0x0E, 0x03, 0x30, 0xBC, 0x0C, 0x09, 0xC0, 0x32, 0x03, 0x0E, 0xC0, 0xE0,
  0x32, 0x03, 0xC0, 0x80, 0x4B, 0x0D, 0x30, 0xDE, 0x0D, 0x30, 0xDB, 0x81, 0x40, 0xDA, 0x09, 0x20,
  0x5F, 0x90, 0x52, 0x09, 0xA0, 0xD2, 0x05, 0xA0, 0x82, 0x07, 0xF9, 0x07, 0x20, 0x8A, 0x04, 0x38,
  0x1B, 0xF8, 0x20, 0x4F, 0x90, 0x42, 0x81, 0x8F, 0xA4, 0x81, 0x1D, 0xB2, 0x01, 0x0E, 0xE0, 0xE0,
  0x12, 0x0B, 0x0C, 0x68, 0x11, 0xC2, 0x20, 0x4E, 0x04, 0x28, 0x11, 0xB1, 0x71, 0x03, 0x38, 0x42,
  0xAE, 0xEA, 0x23, 0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_fire_department() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_fire_department_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_florist 36x36, 4-bit Alpha,  RLE, 240 bytes.
static const unsigned char ic_filled_36_maps_local_florist_data[] PROGMEM = {
  0x75, 0x82, 0x26, 0x62, 0x77, 0x72, 0x07, 0xC0, 0x77, 0x77, 0x03, 0xE0, 0x37, 0x74, 0x81, 0x10,
  0x9E, 0x81, 0x90, 0x17, 0x60, 0x10, 0xAA, 0x00, 0xDE, 0x00, 0xDA, 0x0A, 0x01, 0x73, 0x0C, 0xFF,
  0xA0, 0xC7, 0x20, 0x5F, 0xFC, 0x05, 0x71, 0x08, 0xF8, 0x29, 0x55, 0x9F, 0x08, 0x71, 0x07, 0xE0,
  0x44, 0x04, 0xE0, 0x77, 0x10, 0x10, 0xEC, 0x09, 0x60, 0x9C, 0x0E, 0x01, 0x72, 0x03, 0x0D, 0xB0,
  0x56, 0x05, 0xB0, 0xD0, 0x37, 0x30, 0x30, 0xDB, 0x05, 0x60, 0x5B, 0x0D, 0x03, 0x72, 0x01, 0x0E,
  0xC0, 0x96, 0x09, 0xC0, 0xE0, 0x17, 0x10, 0x7E, 0x04, 0x40, 0x4E, 0x07, 0x71, 0x08, 0xF8, 0x29,
  0x55, 0x9F, 0x08, 0x71, 0x05, 0xFF, 0xC0, 0x57, 0x20, 0xCF, 0xFA, 0x0C, 0x73, 0x01, 0x0A, 0xA0,
  0x0D, 0xE0, 0x0D, 0xA0, 0xA0, 0x15, 0x82, 0x36, 0x42, 0x48, 0x11, 0x09, 0xE8, 0x19, 0x01, 0x48,
  0x32, 0x46, 0x36, 0xB8, 0x1C, 0x71, 0x30, 0x3E, 0x03, 0x38, 0x11, 0x7C, 0xB0, 0x60, 0x4D, 0x0E,
  0x07, 0x30, 0x7C, 0x07, 0x30, 0x70, 0xED, 0x04, 0x02, 0xF0, 0xC0, 0x12, 0x82, 0x26, 0x62, 0x20,
  0x10, 0xCF, 0x81, 0x20, 0xCF, 0x0D, 0x02, 0x60, 0x20, 0xDF, 0x0C, 0x20, 0x7F, 0x90, 0xD0, 0x14,
  0x01, 0x0D, 0xF9, 0x07, 0x20, 0x10, 0xEF, 0x90, 0xA4, 0x0A, 0xF9, 0x0E, 0x01, 0x30, 0x7F, 0xA0,
  0x42, 0x04, 0xFA, 0x07, 0x50, 0xCF, 0x90, 0xC2, 0x0C, 0xF9, 0x0C, 0x60, 0x10, 0xDF, 0x90, 0x02,
  0xF9, 0x0D, 0x01, 0x70, 0x20, 0xDF, 0x00, 0x7F, 0x0D, 0x02, 0x73, 0x0A, 0xE0, 0x0B, 0xE0, 0xA7,
  0x60, 0x40, 0xCC, 0x00, 0xDC, 0x0C, 0x04, 0x77, 0x28, 0x90, 0x27, 0xBD, 0xDD, 0xDB, 0x72, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_florist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_florist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_gas_station 36x36, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_filled_36_maps_local_gas_station_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x05, 0x70, 0x60, 0x17, 0x40, 0x30, 0xEF, 0xC0, 0xE0, 0x32, 0x03, 0x05, 0x60,
  0xBF, 0xE8, 0x4B, 0x03, 0xEF, 0x55, 0xB8, 0x05, 0x7B, 0x20, 0xCA, 0x05, 0x4B, 0x72, 0xB3, 0x0C,
  0xA0, 0x53, 0xB7, 0x2B, 0x40, 0xCA, 0x05, 0x2B, 0x72, 0xB3, 0x04, 0x0D, 0xB0, 0x51, 0xB7, 0x2B,
  0x20, 0x20, 0xEC, 0x0E, 0x02, 0xB7, 0x2B, 0x28, 0x68, 0xFD, 0x22, 0xDF, 0x8B, 0x72, 0xB2, 0x81,
  0xAF, 0x82, 0x81, 0x8F, 0xBB, 0x72, 0xB2, 0x86, 0x8F, 0xD2, 0x2D, 0xFB, 0xFF, 0x92, 0x02, 0x0E,
  0xD0, 0xBF, 0xF9, 0x30, 0x30, 0xDC, 0x0B, 0xFF, 0x95, 0x83, 0x23, 0x7F, 0xBF, 0xFB, 0x0B, 0x03,
  0x38, 0x17, 0xFB, 0xFF, 0xC0, 0xE0, 0x12, 0x81, 0x7F, 0xBF, 0xF9, 0x83, 0x33, 0xCF, 0x62, 0x81,
  0x7F, 0xBF, 0xF9, 0x28, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0xFF, 0x92, 0x81, 0xBF, 0x72, 0x81, 0x7F,
  0xBF, 0xF9, 0x28, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0xFF, 0x92, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xBF,
  0xF9, 0x28, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0xFF, 0x92, 0x81, 0xBF, 0x72, 0x81, 0x7F, 0xBF, 0xF9,
  0x28, 0x1B, 0xF7, 0x28, 0x17, 0xFB, 0xFF, 0x92, 0x81, 0x9F, 0xB2, 0x81, 0xBF, 0x9F, 0xF9, 0x20,
  0x3A, 0x00, 0xDA, 0x03, 0xFF, 0x93, 0x07, 0xC0, 0x71, 0x80, 0x93, 0x74, 0x82, 0x26, 0x62, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_gas_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 30, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_gas_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_grocery_store 36x36, 4-bit Alpha,  RLE, 167 bytes.
static const unsigned char ic_filled_36_maps_local_grocery_store_data[] PROGMEM = {
  0x07, 0xC0, 0x97, 0x77, 0x40, 0x7D, 0x01, 0x77, 0x73, 0x07, 0xD0, 0x97, 0x77, 0x60, 0x4F, 0xFF,
  0xC0, 0xD0, 0x24, 0x0C, 0xFF, 0xFC, 0x06, 0x40, 0x4F, 0xFF, 0xC0, 0x25, 0x0C, 0xFF, 0xFA, 0x09,
  0x60, 0x5F, 0xFF, 0x90, 0xE0, 0x17, 0x0D, 0xFF, 0xF0, 0x77, 0x10, 0x6F, 0xFE, 0x0E, 0x73, 0x0E,
  0xFF, 0xD0, 0x67, 0x30, 0x7F, 0xFC, 0x0D, 0x75, 0x0E, 0xFF, 0xB0, 0x47, 0x50, 0x8F, 0xFA, 0x0B,
  0x76, 0x03, 0xFF, 0xA0, 0x37, 0x60, 0xBF, 0xF9, 0x07, 0x76, 0x04, 0xB0, 0x88, 0x07, 0x70, 0x37,
  0x70, 0xCA, 0x09, 0x77, 0x75, 0x04, 0xA0, 0xE0, 0x17, 0x77, 0x50, 0x7A, 0x0E, 0x80, 0x95, 0x70,
  0x37, 0x20, 0x4F, 0xFE, 0x07, 0x73, 0x09, 0xFF, 0xD0, 0x77, 0x40, 0x48, 0x09, 0x67, 0x03, 0x80,
  0xC5, 0x08, 0x33, 0xBE, 0xB3, 0x73, 0x83, 0x3B, 0xEB, 0x37, 0x30, 0x10, 0xEB, 0x0E, 0x01, 0x71,
  0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x20, 0x5D, 0x06, 0x71, 0x05, 0xD0, 0x67, 0x20, 0x5D, 0x06, 0x71,
  0x05, 0xD0, 0x67, 0x20, 0x10, 0xEB, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x38, 0x33,
  0xBE, 0xB3, 0x73, 0x83, 0x3B, 0xEB, 0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_grocery_store() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_grocery_store_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_hospital 36x36, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_filled_36_maps_local_hospital_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x03, 0xFF, 0xFD, 0x04, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFB, 0x6F,
  0xB0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xC7, 0x74,
  0xC0, 0x07, 0xC7, 0x74, 0xC0, 0x07, 0xC7, 0x74, 0xC0, 0x07, 0xC7, 0x74, 0xC0, 0x07, 0xC7, 0x74,
  0xC0, 0x07, 0xC7, 0x74, 0xC0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFB, 0x6F,
  0xB0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFB, 0x6F, 0xB0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09, 0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A,
  0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_hospital() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_hospital_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_hotel 36x36, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_filled_36_maps_local_hotel_data[] PROGMEM = {
  0x82, 0x37, 0x73, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x77, 0x20,
  0x7A, 0x07, 0x48, 0x14, 0x74, 0x40, 0x38, 0x09, 0x07, 0x05, 0x02, 0x40, 0x7A, 0x07, 0x20, 0x40,
  0xEB, 0x0E, 0x04, 0x20, 0x7F, 0xF0, 0xA0, 0x12, 0x07, 0xA8, 0x17, 0x02, 0xF8, 0x12, 0x07, 0xFF,
  0x98, 0x2D, 0x10, 0x7A, 0x81, 0x70, 0xAF, 0x81, 0xA0, 0x7F, 0xFA, 0x81, 0xA0, 0x7A, 0x81, 0x70,
  0xDF, 0x81, 0xD0, 0x7F, 0xFB, 0x02, 0x07, 0xA8, 0x17, 0x0D, 0xF8, 0x1D, 0x07, 0xFF, 0xB0, 0x60,
  0x7A, 0x81, 0x70, 0xAF, 0x81, 0xA0, 0x7F, 0xFB, 0x00, 0x7A, 0x81, 0x70, 0x2F, 0x81, 0x20, 0x7F,
  0xFB, 0x00, 0x7A, 0x07, 0x20, 0x40, 0xEB, 0x0E, 0x04, 0x20, 0x7F, 0xFB, 0x00, 0x7A, 0x07, 0x48,
  0x14, 0x74, 0x40, 0x7F, 0xFB, 0x00, 0x7A, 0x07, 0x74, 0x07, 0xFF, 0xB0, 0x07, 0xFF, 0xFF, 0xC0,
  0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xA0, 0xB8, 0x0A,
  0x67, 0x0B, 0xA0, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_hotel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 34, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_hotel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_laundry_service 36x36, 4-bit Alpha,  RLE, 158 bytes.
static const unsigned char ic_filled_36_maps_local_laundry_service_data[] PROGMEM = {
  0x10, 0x80, 0xEF, 0xFC, 0x82, 0xD8, 0x08, 0xFF, 0xF9, 0x08, 0x0D, 0xFF, 0xF9, 0x0D, 0xB8, 0x67,
  0x07, 0xFD, 0x22, 0xDF, 0xFA, 0x39, 0x08, 0x20, 0x8F, 0xFA, 0x86, 0x70, 0x7F, 0xD2, 0x2D, 0x80,
  0x9B, 0x1F, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF, 0xF0, 0xD0, 0x37, 0x10, 0x30, 0xDF, 0xC0, 0xB0,
  0x17, 0x30, 0x10, 0xBF, 0xA0, 0xD0, 0x17, 0x50, 0x10, 0xDF, 0x90, 0x37, 0x70, 0x3F, 0x0B, 0x74,
  0x07, 0x0C, 0x30, 0xBE, 0x06, 0x73, 0x07, 0xA0, 0x62, 0x06, 0xE0, 0x27, 0x20, 0x7B, 0x0C, 0x20,
  0x2E, 0x72, 0x07, 0xC0, 0xE3, 0xE7, 0x10, 0x7D, 0x0E, 0x3E, 0x02, 0x60, 0x7E, 0x0C, 0x20, 0x2E,
  0x06, 0x50, 0x7F, 0x06, 0x20, 0x6E, 0x0B, 0x40, 0x7F, 0x0C, 0x30, 0xBF, 0x03, 0x30, 0xCE, 0x0C,
  0x01, 0x20, 0x3F, 0x90, 0xD0, 0x13, 0x84, 0x6C, 0xEE, 0xC6, 0x30, 0x10, 0xDF, 0xA0, 0xB0, 0x17,
  0x30, 0x10, 0xBF, 0xC0, 0xD0, 0x37, 0x10, 0x30, 0xDF, 0xF8, 0x1B, 0x62, 0x28, 0x12, 0x6B, 0xF9,
  0x0D, 0xFF, 0xF9, 0x0D, 0x08, 0xFF, 0xF9, 0x82, 0x80, 0x8E, 0xFF, 0xC0, 0xE0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_laundry_service() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_laundry_service_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_library 36x36, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_filled_36_maps_local_library_data[] PROGMEM = {
  0x74, 0x84, 0x2A, 0xDD, 0xA2, 0x77, 0x70, 0x4E, 0x04, 0x77, 0x60, 0xEE, 0x0E, 0x77, 0x50, 0x4F,
  0x90, 0x47, 0x74, 0x06, 0xF9, 0x06, 0x77, 0x40, 0x4F, 0x90, 0x47, 0x75, 0x0E, 0xE0, 0xE7, 0x76,
  0x04, 0xE0, 0x47, 0x77, 0x84, 0x2A, 0xDD, 0xA2, 0x74, 0x84, 0x7D, 0xCB, 0x84, 0x77, 0x28, 0x54,
  0x8B, 0xCD, 0x77, 0xD8, 0x1E, 0xA3, 0x73, 0x81, 0x3A, 0xED, 0x00, 0x7F, 0x90, 0xB0, 0x36, 0x03,
  0x0B, 0xF9, 0x00, 0x7F, 0xB0, 0x94, 0x09, 0xFB, 0x00, 0x7F, 0xC8, 0x2C, 0x22, 0xCF, 0xC0, 0x07,
  0xFD, 0x00, 0xEF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F,
  0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0,
  0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD8, 0x47, 0x39, 0xAC, 0xEF, 0xFC, 0x83, 0xEC, 0xA9, 0x35,
  0x81, 0x37, 0xCF, 0xD8, 0x1C, 0x83, 0x76, 0x03, 0x0B, 0xF9, 0x0B, 0x03, 0x77, 0x40, 0x40, 0xDC,
  0x0D, 0x04, 0x77, 0x71, 0x0A, 0xA0, 0xA7, 0x77, 0x40, 0x06, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_library() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 33), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_library_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_mall 36x36, 4-bit Alpha,  RLE, 186 bytes.
static const unsigned char ic_filled_36_maps_local_mall_data[] PROGMEM = {
  0x75, 0x82, 0x57, 0x75, 0x77, 0x70, 0x10, 0x9E, 0x09, 0x01, 0x77, 0x30, 0x20, 0xDF, 0x90, 0xD0,
  0x27, 0x71, 0x01, 0x0D, 0xB8, 0x2C, 0x99, 0xCB, 0x0D, 0x01, 0x77, 0x09, 0xA0, 0xE0, 0x54, 0x05,
  0x0E, 0xA0, 0x97, 0x7B, 0x05, 0x60, 0x5B, 0x76, 0x05, 0xA0, 0xC7, 0x10, 0xCA, 0x05, 0x75, 0x06,
  0xA0, 0x97, 0x10, 0x9A, 0x06, 0x70, 0x30, 0xBF, 0xFF, 0x98, 0x3B, 0x30, 0x1E, 0xFF, 0xFB, 0x81,
  0xE1, 0x5F, 0xFF, 0xD0, 0x60, 0x7D, 0x08, 0x20, 0x6F, 0x90, 0x62, 0x08, 0xD0, 0x07, 0xD0, 0xA2,
  0x02, 0xF9, 0x02, 0x20, 0xAD, 0x00, 0x7D, 0x0E, 0x30, 0x9E, 0x09, 0x30, 0xED, 0x00, 0x7E, 0x06,
  0x30, 0xAC, 0x0A, 0x30, 0x6E, 0x00, 0x7E, 0x0E, 0x01, 0x38, 0x22, 0x66, 0x23, 0x01, 0x0E, 0xE0,
  0x07, 0xF0, 0xC0, 0x17, 0x10, 0x10, 0xCF, 0x00, 0x7F, 0x90, 0xE0, 0x66, 0x06, 0x0E, 0xF9, 0x00,
  0x7F, 0xB8, 0x4E, 0xA8, 0x8A, 0xEF, 0xB0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x6F, 0xFF, 0xD8, 0x16, 0x1E,
  0xFF, 0xFB, 0x83, 0xE1, 0x03, 0xBF, 0xFF, 0x90, 0xB0, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_mall() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_mall_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_movies 36x36, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_filled_36_maps_local_movies_data[] PROGMEM = {
  0x0F, 0x73, 0x80, 0x90, 0x73, 0x0F, 0x7B, 0x3F, 0xD3, 0xE3, 0xFD, 0x3E, 0x0F, 0x7F, 0xD0, 0xF7,
  0x80, 0xE2, 0xF0, 0xF7, 0xFD, 0x0F, 0x7E, 0x3F, 0xD3, 0xE3, 0xFD, 0x3E, 0x0F, 0x7F, 0xD0, 0xF7,
  0x80, 0xE2, 0xF0, 0xF7, 0xFD, 0x0F, 0x7E, 0x3F, 0xD3, 0xE3, 0xFD, 0x3E, 0x0F, 0x7F, 0xD0, 0xF7,
  0x80, 0xE2, 0xF0, 0xF7, 0xFD, 0x0F, 0x7E, 0x3F, 0xD3, 0xE3, 0xFD, 0x3E, 0x0F, 0x7F, 0xD0, 0xF7,
  0x80, 0xE2, 0xF0, 0xF7, 0xFD, 0x0F, 0x7E, 0x3F, 0xD3, 0xE3, 0xFD, 0x3B, 0x0F, 0x73, 0x80, 0x90,
  0x73, 0x0F, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_movies() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_movies_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_offer 36x36, 4-bit Alpha,  RLE, 149 bytes.
static const unsigned char ic_filled_36_maps_local_offer_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xC0, 0xB0, 0x37, 0x70, 0x8F, 0xF9, 0x04, 0x76, 0x0D, 0xFF, 0xA0, 0x47, 0x5B,
  0x82, 0xC2, 0x06, 0xFC, 0x04, 0x74, 0xB0, 0x23, 0x0A, 0xFC, 0x04, 0x73, 0xB0, 0x13, 0x08, 0xFD,
  0x04, 0x72, 0xB0, 0x63, 0x0D, 0xFE, 0x04, 0x71, 0xC8, 0x1A, 0x8D, 0xFF, 0x90, 0x47, 0xFF, 0xFA,
  0x04, 0x6F, 0xFF, 0xB0, 0x45, 0xFF, 0xFC, 0x04, 0x4F, 0xFF, 0xD0, 0x43, 0xFF, 0xFE, 0x04, 0x2F,
  0xFF, 0xF8, 0x14, 0x0B, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xF8, 0x1B, 0x04, 0xFF, 0xFE, 0x0E, 0x20,
  0x4F, 0xFF, 0xD0, 0xB3, 0x04, 0xFF, 0xFB, 0x0E, 0x03, 0x40, 0x4F, 0xFF, 0x90, 0xE0, 0x46, 0x04,
  0xFF, 0xE0, 0xE0, 0x47, 0x10, 0x4F, 0xFC, 0x0E, 0x04, 0x73, 0x04, 0xFF, 0xA0, 0xE0, 0x47, 0x50,
  0x4F, 0xF0, 0xE0, 0x47, 0x70, 0x4F, 0xD0, 0xE0, 0x47, 0x72, 0x04, 0xFB, 0x0E, 0x04, 0x77, 0x40,
  0x4F, 0x90, 0xE0, 0x47, 0x76, 0x04, 0xE0, 0xE0, 0x47, 0x77, 0x10, 0x4C, 0x0E, 0x04, 0x77, 0x73,
  0x83, 0x3B, 0xEB, 0x37, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_offer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_offer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_parking 36x36, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_36_maps_local_parking_data[] PROGMEM = {
  0x80, 0x77, 0x06, 0x03, 0x7F, 0xE0, 0xE0, 0x85, 0xFF, 0x90, 0xD0, 0x33, 0xFF, 0xA0, 0xE0, 0x32,
  0xFF, 0xB0, 0xD2, 0xFF, 0xC0, 0x81, 0xE8, 0x01, 0x70, 0x90, 0xED, 0x0E, 0x1E, 0x60, 0x20, 0xED,
  0x03, 0xE7, 0x06, 0xD0, 0x6E, 0x70, 0x3D, 0x07, 0xE7, 0x06, 0xD0, 0x6E, 0x60, 0x20, 0xED, 0x03,
  0xE8, 0x01, 0x70, 0x90, 0xED, 0x0E, 0x1F, 0xFC, 0x08, 0x1F, 0xFB, 0x0D, 0x2F, 0xFA, 0x0E, 0x03,
  0x2F, 0xF9, 0x0D, 0x03, 0x3F, 0xE0, 0xE0, 0x85, 0xE8, 0x01, 0x70, 0x60, 0x37, 0xE7, 0x7E, 0x77,
  0xE7, 0x7E, 0x77, 0xE7, 0x7E, 0x77, 0xE7, 0x7E, 0x77, 0x80, 0x27, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_parking() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 28, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_parking_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_pharmacy 36x36, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_filled_36_maps_local_pharmacy_data[] PROGMEM = {
  0x77, 0x70, 0x20, 0x37, 0x77, 0x58, 0x29, 0xFD, 0x77, 0x77, 0x30, 0xEA, 0x0E, 0x77, 0x72, 0x05,
  0xB0, 0x97, 0x77, 0x20, 0xBB, 0x04, 0x77, 0x71, 0x01, 0xB0, 0xD4, 0x03, 0x80, 0x96, 0x70, 0xAB,
  0x84, 0xC7, 0x77, 0x37, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x02, 0xFF,
  0xFD, 0x81, 0x20, 0xCF, 0xFF, 0xB0, 0xC2, 0x07, 0xFB, 0x82, 0xB7, 0x7B, 0xFB, 0x07, 0x20, 0x2F,
  0xB0, 0x72, 0x07, 0xFB, 0x02, 0x30, 0xCF, 0xA0, 0x72, 0x07, 0xFA, 0x0C, 0x40, 0x7F, 0xA0, 0x72,
  0x07, 0xFA, 0x07, 0x40, 0x2F, 0xA0, 0x72, 0x07, 0xFA, 0x02, 0x50, 0xCC, 0x75, 0xC0, 0xC6, 0x09,
  0xC7, 0x5C, 0x09, 0x60, 0xCC, 0x75, 0xC0, 0xC5, 0x02, 0xFA, 0x07, 0x20, 0x7F, 0xA0, 0x24, 0x07,
  0xFA, 0x07, 0x20, 0x7F, 0xA0, 0x74, 0x0C, 0xFA, 0x07, 0x20, 0x7F, 0xA0, 0xC3, 0x02, 0xFB, 0x07,
  0x20, 0x7F, 0xB0, 0x22, 0x07, 0xFB, 0x82, 0xB7, 0x7B, 0xFB, 0x07, 0x20, 0xCF, 0xFF, 0xB8, 0x1C,
  0x02, 0xFF, 0xFD, 0x02, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x07, 0x03,
  0x80, 0xA6, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_pharmacy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_pharmacy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_phone 36x36, 4-bit Alpha,  RLE, 145 bytes.
static const unsigned char ic_filled_36_maps_local_phone_data[] PROGMEM = {
  0x10, 0x58, 0x01, 0x70, 0x67, 0x76, 0x05, 0xF0, 0x97, 0x75, 0x07, 0xF0, 0xC7, 0x75, 0x06, 0xF0,
  0xD7, 0x75, 0x05, 0xF0, 0xE7, 0x75, 0x03, 0xF9, 0x02, 0x77, 0x40, 0x1F, 0x90, 0x67, 0x75, 0x0D,
  0xF0, 0x97, 0x75, 0x09, 0xF0, 0x67, 0x75, 0x05, 0xE0, 0x97, 0x77, 0x0E, 0xC0, 0x97, 0x77, 0x10,
  0xAB, 0x09, 0x77, 0x72, 0x03, 0xB0, 0x27, 0x77, 0x30, 0xBA, 0x0B, 0x77, 0x73, 0x03, 0xB0, 0x57,
  0x77, 0x30, 0x9A, 0x0E, 0x01, 0x77, 0x72, 0x01, 0x0D, 0xA0, 0xC7, 0x77, 0x30, 0x3B, 0x0B, 0x77,
  0x73, 0x06, 0xB0, 0xB7, 0x18, 0x26, 0x95, 0x27, 0x50, 0x7B, 0x0C, 0x01, 0x50, 0x9C, 0x82, 0xED,
  0xB9, 0x72, 0x07, 0xB0, 0xE0, 0x53, 0x09, 0xFA, 0x06, 0x72, 0x06, 0xC8, 0x1B, 0x29, 0xFB, 0x07,
  0x73, 0x03, 0x0D, 0xFF, 0x90, 0x77, 0x40, 0x10, 0x9F, 0xF0, 0x77, 0x60, 0x30, 0xBF, 0xD0, 0x77,
  0x71, 0x81, 0x3A, 0xEF, 0xA0, 0x77, 0x74, 0x81, 0x59, 0xDE, 0x05, 0x77, 0x78, 0x41, 0x35, 0x67,
  0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_pizza 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_filled_36_maps_local_pizza_data[] PROGMEM = {
  0x71, 0x83, 0x26, 0xAC, 0xDA, 0x83, 0xDC, 0xA6, 0x27, 0x70, 0x50, 0xCF, 0xD0, 0xC0, 0x57, 0x30,
  0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x70, 0x9F, 0xFE, 0x09, 0x40, 0x10, 0xCD, 0x81, 0xB8, 0xBF, 0xF8,
  0x3C, 0x10, 0x1D, 0xD0, 0x53, 0x05, 0xFF, 0x81, 0xD1, 0x3D, 0x0B, 0x50, 0xBF, 0xF8, 0x13, 0x09,
  0xC0, 0x85, 0x08, 0xFE, 0x09, 0x20, 0x10, 0xEB, 0x0B, 0x50, 0xBF, 0xD0, 0xE0, 0x13, 0x08, 0xC0,
  0x53, 0x05, 0xFE, 0x08, 0x50, 0xEC, 0x81, 0xB8, 0xBF, 0xE0, 0xE6, 0x06, 0xFF, 0xE0, 0x67, 0x0C,
  0xFF, 0xC0, 0xC7, 0x10, 0x4F, 0x82, 0xE9, 0x9E, 0xF0, 0x47, 0x20, 0xBD, 0x0C, 0x01, 0x20, 0x10,
  0xCD, 0x0B, 0x73, 0x02, 0xD0, 0x34, 0x03, 0xD0, 0x27, 0x40, 0x9C, 0x6C, 0x09, 0x75, 0x01, 0x0E,
  0xB0, 0x34, 0x03, 0xB0, 0xE0, 0x17, 0x60, 0x7B, 0x0C, 0x01, 0x20, 0x10, 0xCB, 0x07, 0x77, 0x10,
  0xDB, 0x82, 0xE9, 0x9E, 0xB0, 0xD7, 0x72, 0x05, 0xFB, 0x05, 0x77, 0x30, 0xBF, 0x90, 0xB7, 0x74,
  0x03, 0xF9, 0x03, 0x77, 0x50, 0xAE, 0x0A, 0x77, 0x60, 0x1E, 0x01, 0x77, 0x70, 0x8C, 0x08, 0x77,
  0x72, 0x0E, 0xA0, 0xE7, 0x77, 0x30, 0x6A, 0x06, 0x77, 0x74, 0x00, 0xC7, 0x77, 0x50, 0x04, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_pizza() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_pizza_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_play 36x36, 4-bit Alpha,  RLE, 136 bytes.
static const unsigned char ic_filled_36_maps_local_play_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDF, 0xF0,
  0x0A, 0xFF, 0xFF, 0x00, 0x4F, 0xFF, 0xE0, 0xD2, 0x0D, 0xFF, 0xFD, 0x07, 0x20, 0x8F, 0xFF, 0xD0,
  0x12, 0x02, 0xFF, 0xE8, 0x4D, 0xDC, 0xBA, 0x74, 0x84, 0x7A, 0xBC, 0xDE, 0xF0, 0x10, 0x7C, 0x0C,
  0x01, 0x77, 0x01, 0x0C, 0xC0, 0x70, 0x12, 0x07, 0xC0, 0xE0, 0x37, 0x50, 0x30, 0xEC, 0x07, 0x40,
  0x1E, 0x06, 0x73, 0x06, 0xE0, 0x14, 0x01, 0xF0, 0x97, 0x10, 0x9F, 0x01, 0x40, 0x7F, 0x90, 0x16,
  0x02, 0xF9, 0x07, 0x20, 0x10, 0x7F, 0x90, 0xD7, 0x10, 0xDF, 0x90, 0x70, 0x1F, 0xB0, 0x97, 0x10,
  0x9F, 0xFE, 0x05, 0x28, 0x24, 0xDD, 0x42, 0x05, 0xFF, 0xE8, 0x11, 0x19, 0xC8, 0x19, 0x11, 0xFF,
  0xD8, 0x1C, 0x5E, 0xE8, 0x1E, 0x5C, 0x80, 0x98, 0x1F, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF,
  0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_play() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_play_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_police 36x36, 4-bit Alpha,  RLE, 206 bytes.
static const unsigned char ic_filled_36_maps_local_police_data[] PROGMEM = {
  0x76, 0x00, 0x47, 0x77, 0x30, 0x60, 0xCA, 0x0C, 0x06, 0x77, 0x58, 0x11, 0x7E, 0xE8, 0x1E, 0x71,
  0x77, 0x02, 0x09, 0xFD, 0x09, 0x02, 0x73, 0x04, 0x0B, 0xFF, 0xA0, 0xB0, 0x46, 0x06, 0x0C, 0xFF,
  0xE0, 0xC0, 0x62, 0x04, 0x0E, 0xFF, 0xFB, 0x81, 0xE4, 0x7F, 0xFF, 0xD0, 0x07, 0xFD, 0x00, 0xCF,
  0xD0, 0x07, 0xFD, 0x00, 0x5F, 0xD0, 0x07, 0xFC, 0x0E, 0x20, 0xEF, 0xC0, 0x07, 0xFC, 0x08, 0x20,
  0x8F, 0xC0, 0x07, 0xFC, 0x01, 0x20, 0x1F, 0xC0, 0x07, 0xD8, 0x4E, 0xDB, 0xA9, 0x64, 0x84, 0x69,
  0xAB, 0xDE, 0xD0, 0x07, 0xD0, 0x57, 0x70, 0x5D, 0x00, 0x7E, 0x07, 0x75, 0x07, 0xE0, 0x70, 0x6F,
  0x09, 0x73, 0x09, 0xF0, 0x60, 0x5F, 0x90, 0xB7, 0x10, 0xBF, 0x90, 0x50, 0x3F, 0xA0, 0x16, 0x01,
  0xFA, 0x03, 0x1F, 0x90, 0xD7, 0x10, 0xDF, 0x92, 0x0B, 0xF0, 0x93, 0x00, 0x13, 0x09, 0xF0, 0xB2,
  0x07, 0xF0, 0x62, 0x82, 0x7E, 0xE7, 0x20, 0x6F, 0x07, 0x20, 0x1F, 0x81, 0x24, 0xDC, 0x81, 0xD4,
  0x2F, 0x01, 0x30, 0x9E, 0x0A, 0xF9, 0x0A, 0xE0, 0x94, 0x02, 0xFF, 0xF9, 0x02, 0x50, 0x8F, 0xFE,
  0x08, 0x70, 0xDF, 0xFC, 0x0D, 0x71, 0x02, 0x0E, 0xFF, 0xA0, 0xE0, 0x27, 0x20, 0x4F, 0xFA, 0x04,
  0x74, 0x04, 0x0E, 0xFD, 0x0E, 0x04, 0x76, 0x02, 0x0D, 0xFB, 0x0D, 0x02, 0x77, 0x10, 0x10, 0x8F,
  0x90, 0x80, 0x17, 0x74, 0x81, 0x29, 0xEA, 0x81, 0xE9, 0x27, 0x77, 0x20, 0x05, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_police() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 31, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_police_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_post_office 36x36, 4-bit Alpha,  RLE, 112 bytes.
static const unsigned char ic_filled_36_maps_local_post_office_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDB, 0x04,
  0x0D, 0xFF, 0xE0, 0xD0, 0x4E, 0x20, 0x8F, 0xFC, 0x08, 0x2E, 0x30, 0x30, 0xCF, 0xF0, 0xC0, 0x33,
  0xE0, 0xA0, 0x13, 0x06, 0x0E, 0xFB, 0x0E, 0x06, 0x30, 0x10, 0xAF, 0x0E, 0x06, 0x30, 0x10, 0xAF,
  0x90, 0xA0, 0x13, 0x06, 0x0E, 0xFB, 0x0C, 0x03, 0x30, 0x40, 0xDC, 0x0D, 0x04, 0x30, 0x30, 0xCF,
  0xF0, 0x84, 0x08, 0xA0, 0x84, 0x08, 0xFF, 0xB0, 0xD0, 0x43, 0x00, 0x33, 0x04, 0x0D, 0xFF, 0xE0,
  0xA0, 0x14, 0x01, 0x0A, 0xFF, 0xFA, 0x0E, 0x06, 0x20, 0x60, 0xEF, 0xFF, 0xD0, 0x0C, 0x80, 0xBB,
  0x4F, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_post_office() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_post_office_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_printshop 36x36, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_36_maps_local_printshop_data[] PROGMEM = {
  0x68, 0x09, 0x67, 0x75, 0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0xFF, 0xC7,
  0x58, 0x09, 0x67, 0x80, 0xC2, 0x00, 0x70, 0xCF, 0xFF, 0x90, 0xC0, 0x73, 0x0B, 0xFF, 0xFD, 0x81,
  0xB0, 0x7F, 0xFF, 0xF0, 0x70, 0xCF, 0xFF, 0xA8, 0x17, 0x07, 0xA0, 0xCF, 0xFF, 0xB3, 0xFF, 0xFE,
  0x81, 0x70, 0x78, 0x09, 0xC2, 0xF7, 0x5F, 0xFC, 0x75, 0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0xFA, 0x80,
  0x27, 0xB7, 0x5B, 0x80, 0x27, 0x6B, 0x75, 0xB7, 0x5B, 0x75, 0xB7, 0x5B, 0x80, 0x90, 0x7B, 0x75,
  0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0x80, 0x96, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_printshop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_printshop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_see 36x36, 4-bit Alpha,  RLE, 170 bytes.
static const unsigned char ic_filled_36_maps_local_see_data[] PROGMEM = {
  0x72, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x77, 0x40, 0xCF, 0xB0, 0xC7, 0x73, 0x0B, 0xFD, 0x0B, 0x72,
  0x08, 0x0D, 0xFF, 0xFB, 0x82, 0xD8, 0x08, 0xFF, 0xFF, 0x08, 0x0D, 0xFF, 0xFF, 0x0D, 0x80, 0xC6,
  0xF8, 0x4E, 0xA8, 0x8A, 0xEF, 0xFF, 0x90, 0xE0, 0x66, 0x06, 0x0E, 0xFF, 0xD0, 0xC0, 0x17, 0x10,
  0x10, 0xCF, 0xFB, 0x0E, 0x01, 0x28, 0x41, 0x7A, 0xA7, 0x12, 0x01, 0x0E, 0xFF, 0xA0, 0x62, 0x04,
  0x0E, 0xC0, 0xE0, 0x42, 0x06, 0xFF, 0x90, 0xE2, 0x01, 0x0E, 0xE0, 0xE0, 0x12, 0x0E, 0xFF, 0x0A,
  0x20, 0x7F, 0x90, 0x72, 0x0A, 0xFF, 0x08, 0x20, 0xAF, 0x90, 0xA2, 0x08, 0xFF, 0x08, 0x20, 0xAF,
  0x90, 0xA2, 0x08, 0xFF, 0x0A, 0x20, 0x7F, 0x90, 0x72, 0x0A, 0xFF, 0x0E, 0x20, 0x10, 0xEE, 0x0E,
  0x01, 0x20, 0xEF, 0xF9, 0x06, 0x20, 0x40, 0xEC, 0x0E, 0x04, 0x20, 0x6F, 0xFA, 0x0E, 0x01, 0x28,
  0x41, 0x7A, 0xA7, 0x12, 0x01, 0x0E, 0xFF, 0xB0, 0xC0, 0x17, 0x10, 0x10, 0xCF, 0xFD, 0x0E, 0x06,
  0x60, 0x60, 0xEF, 0xFF, 0x98, 0x4E, 0xA8, 0x8A, 0xE8, 0x0C, 0x6F, 0x0D, 0xFF, 0xFF, 0x0D, 0x08,
  0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_see() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_see_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_shipping 36x36, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_filled_36_maps_local_shipping_data[] PROGMEM = {
  0x10, 0x30, 0xBF, 0xFF, 0x07, 0x72, 0x01, 0x0E, 0xFF, 0xF9, 0x07, 0x72, 0x06, 0xFF, 0xFA, 0x07,
  0x72, 0x07, 0xFF, 0xFA, 0x07, 0x72, 0x07, 0xFF, 0xFA, 0x07, 0x72, 0x07, 0xFF, 0xFA, 0x07, 0x72,
  0x07, 0xFF, 0xFF, 0x05, 0x40, 0x7F, 0xFF, 0xF0, 0xE0, 0x23, 0x07, 0xFF, 0xFA, 0x85, 0x93, 0x33,
  0x9F, 0xC3, 0x07, 0xFF, 0xFA, 0x07, 0x48, 0x1B, 0xF9, 0x20, 0x7F, 0xFF, 0xA0, 0x74, 0x84, 0x1D,
  0xF5, 0x07, 0xFF, 0xFA, 0x07, 0x58, 0x33, 0xFE, 0x27, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0,
  0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xC0, 0x07, 0xD8, 0x2C, 0x55,
  0xCF, 0xF8, 0x2C, 0x55, 0xCD, 0x00, 0x7C, 0x0E, 0x01, 0x20, 0x10, 0xEF, 0xD0, 0xE0, 0x12, 0x01,
  0x0E, 0xC8, 0x57, 0x37, 0x7B, 0xFC, 0x48, 0x1C, 0xFB, 0x80, 0x47, 0x81, 0xBF, 0xC4, 0x84, 0xCF,
  0xB7, 0x73, 0x38, 0x24, 0xFE, 0x12, 0x82, 0x1E, 0xF4, 0x71, 0x82, 0x4F, 0xE1, 0x28, 0x21, 0xEF,
  0x47, 0x86, 0xEF, 0xC5, 0x5C, 0xFE, 0x73, 0x86, 0xEF, 0xC5, 0x5C, 0xFE, 0x71, 0x04, 0xE0, 0x47,
  0x30, 0x4E, 0x04, 0x72, 0x84, 0x2A, 0xDD, 0xA2, 0x75, 0x84, 0x2A, 0xDD, 0xA2, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_shipping() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 34, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_shipping_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_local_taxi 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_filled_36_maps_local_taxi_data[] PROGMEM = {
  0x72, 0x03, 0x80, 0x47, 0x03, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x74, 0x07, 0xF9, 0x07, 0x76, 0x84,
  0x27, 0x77, 0x7B, 0xF9, 0x84, 0xB7, 0x77, 0x72, 0x70, 0x10, 0xEF, 0xFC, 0x0E, 0x02, 0x68, 0x18,
  0xFE, 0x80, 0x94, 0xB8, 0x1E, 0xF8, 0x68, 0x1D, 0xF7, 0x77, 0x28, 0x17, 0xFD, 0x50, 0x3A, 0x02,
  0x77, 0x20, 0x2A, 0x03, 0x48, 0x19, 0xFC, 0x77, 0x48, 0x1C, 0xF9, 0x48, 0x1E, 0xF7, 0x77, 0x48,
  0x17, 0xFE, 0x30, 0x4A, 0x02, 0x77, 0x40, 0x2A, 0x04, 0x28, 0x19, 0xFC, 0x77, 0x68, 0x1C, 0xF9,
  0x28, 0x1E, 0xFC, 0x80, 0xA0, 0x78, 0x3C, 0xFE, 0x05, 0xFF, 0xFD, 0x05, 0x07, 0xFF, 0xFD, 0x00,
  0x7B, 0x81, 0xD8, 0xAF, 0xF8, 0x1A, 0x8D, 0xB0, 0x07, 0xA0, 0xD3, 0x06, 0xFD, 0x06, 0x30, 0xDA,
  0x00, 0x7A, 0x08, 0x30, 0x1F, 0xD0, 0x13, 0x08, 0xA0, 0x07, 0xA0, 0xA3, 0x02, 0xFD, 0x02, 0x30,
  0xAA, 0x00, 0x7B, 0x82, 0x60, 0x2C, 0xFD, 0x82, 0xC2, 0x06, 0xB0, 0x07, 0xFF, 0xFD, 0x00, 0x7F,
  0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x09, 0x67, 0xC0, 0x07, 0xC7,
  0x74, 0xC0, 0x70, 0x5B, 0x0D, 0x77, 0x40, 0xDB, 0x84, 0x50, 0x57, 0x72, 0x77, 0x48, 0x22, 0x77,
  0x51,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_local_taxi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_local_taxi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_location_pin 36x36, 4-bit Alpha,  RLE, 144 bytes.
static const unsigned char ic_filled_36_maps_location_pin_data[] PROGMEM = {
  0x78, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x50, 0x60, 0xEF, 0x90, 0xE0, 0x67, 0x20, 0xAF, 0xD0, 0xA7,
  0x0B, 0xFF, 0x0B, 0x50, 0x9F, 0xFA, 0x09, 0x30, 0x2F, 0xFC, 0x02, 0x20, 0xAF, 0xFC, 0x0A, 0x2F,
  0x84, 0xE7, 0x33, 0x7E, 0xF1, 0x04, 0xF0, 0x34, 0x03, 0xF0, 0x40, 0x6E, 0x08, 0x60, 0x8E, 0x06,
  0x07, 0xE0, 0x56, 0x05, 0xE0, 0x70, 0x6E, 0x05, 0x60, 0x5E, 0x06, 0x05, 0xE0, 0xA6, 0x0A, 0xE0,
  0x50, 0x1F, 0x06, 0x40, 0x6F, 0x81, 0x10, 0xDF, 0x82, 0xB7, 0x7B, 0xF0, 0xD2, 0x07, 0xFF, 0xC0,
  0x72, 0x01, 0x0E, 0xFF, 0xA0, 0xE0, 0x13, 0x08, 0xFF, 0xA0, 0x75, 0x0C, 0xFF, 0x0D, 0x60, 0x20,
  0xEF, 0xE0, 0x37, 0x06, 0xFD, 0x06, 0x72, 0x0A, 0xFB, 0x0A, 0x73, 0x01, 0x0D, 0xF9, 0x0D, 0x01,
  0x74, 0x03, 0xF9, 0x04, 0x76, 0x08, 0xE0, 0x87, 0x70, 0x10, 0xEC, 0x0E, 0x01, 0x77, 0x10, 0x7C,
  0x07, 0x77, 0x20, 0x10, 0xEA, 0x0E, 0x77, 0x40, 0x8A, 0x08, 0x77, 0x48, 0x21, 0xCC, 0x17, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_location_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_location_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_lunch_dining 36x36, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_filled_36_maps_lunch_dining_data[] PROGMEM = {
  0x71, 0x84, 0x15, 0x8B, 0xDD, 0xA8, 0x4D, 0xDB, 0x85, 0x27, 0x68, 0x11, 0x7C, 0xFF, 0x81, 0xC7,
  0x17, 0x20, 0x80, 0xEF, 0xFC, 0x0E, 0x08, 0x60, 0x20, 0xDF, 0xFF, 0x90, 0xD0, 0x33, 0x03, 0x0E,
  0xFF, 0xFB, 0x83, 0xE3, 0x01, 0xDF, 0xFF, 0xD8, 0x1E, 0x17, 0xFF, 0xFF, 0x08, 0x0C, 0xFF, 0xFF,
  0x0D, 0x0E, 0xFF, 0xFF, 0x0E, 0x80, 0xF2, 0x08, 0x42, 0x8B, 0xB8, 0x34, 0x84, 0x28, 0xBB, 0x83,
  0x48, 0x42, 0x8B, 0xB8, 0x22, 0x04, 0x0A, 0xE8, 0x2A, 0x54, 0xAE, 0x82, 0xA5, 0x4A, 0xE0, 0xA0,
  0x5F, 0xFF, 0xFD, 0x82, 0xA4, 0x4A, 0xE8, 0x2A, 0x45, 0xAE, 0x82, 0xA4, 0x5A, 0xB8, 0x1B, 0x82,
  0x48, 0x42, 0x8B, 0xB8, 0x24, 0x84, 0x38, 0xBB, 0x82, 0x48, 0x13, 0x8A, 0x80, 0xF0, 0x08, 0x09,
  0xA6, 0xF0, 0xDF, 0xFF, 0xF0, 0xD0, 0x8F, 0xFF, 0xF8, 0x28, 0x08, 0xDF, 0xFF, 0xB0, 0xD0, 0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_lunch_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_lunch_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_map 36x36, 4-bit Alpha,  RLE, 208 bytes.
static const unsigned char ic_filled_36_maps_map_data[] PROGMEM = {
  0x71, 0x81, 0x26, 0x27, 0x78, 0x11, 0x61, 0x58, 0x12, 0x7C, 0xB8, 0x1C, 0x71, 0x72, 0x04, 0x0A,
  0xA0, 0x72, 0x81, 0x27, 0xCF, 0xA8, 0x1B, 0x61, 0x38, 0x11, 0x7D, 0xC8, 0x17, 0x3C, 0xF0, 0xC0,
  0xDE, 0x81, 0xA6, 0xBF, 0x00, 0x7F, 0x98, 0x37, 0x03, 0x8D, 0xFE, 0x00, 0x7F, 0x90, 0x74, 0x81,
  0x39, 0xEF, 0xB0, 0x07, 0xF9, 0x07, 0x70, 0x40, 0xCF, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9,
  0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90,
  0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F,
  0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9,
  0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07,
  0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x00, 0x7F,
  0x90, 0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x0C, 0x04, 0x70, 0x7F, 0x90, 0x07, 0xFB, 0x81, 0xE9,
  0x34, 0x07, 0xF9, 0x00, 0x7F, 0xE8, 0x3D, 0x83, 0x07, 0xF9, 0x00, 0x7F, 0x81, 0xB6, 0xAE, 0x0D,
  0x0C, 0xF8, 0x1C, 0x37, 0xC8, 0x1D, 0x71, 0x38, 0x11, 0x6B, 0xFA, 0x81, 0xC7, 0x22, 0x07, 0xA0,
  0xA0, 0x47, 0x28, 0x11, 0x7C, 0xB8, 0x1C, 0x72, 0x58, 0x11, 0x61, 0x77, 0x81, 0x26, 0x27, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_map_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_maps_ugc 36x36, 4-bit Alpha,  RLE, 198 bytes.
static const unsigned char ic_filled_36_maps_maps_ugc_data[] PROGMEM = {
  0x75, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x76, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x20,
  0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x60, 0x7F, 0xFC, 0x07, 0x74, 0x0A, 0xFF, 0xE0, 0xA7, 0x20, 0x8F,
  0xFF, 0x90, 0x87, 0x05, 0xFF, 0xFB, 0x05, 0x60, 0xDF, 0xFF, 0xB0, 0xD5, 0x07, 0xFF, 0xFD, 0x07,
  0x40, 0xEF, 0xC0, 0x72, 0x07, 0xFC, 0x0E, 0x30, 0x3F, 0xD0, 0x72, 0x07, 0xFD, 0x03, 0x20, 0x8F,
  0xD0, 0x72, 0x07, 0xFD, 0x08, 0x20, 0xBF, 0xD0, 0x72, 0x07, 0xFD, 0x0B, 0x20, 0xDF, 0x98, 0x00,
  0x70, 0x32, 0x03, 0x80, 0x07, 0xF9, 0x0D, 0x20, 0xEF, 0x97, 0x5F, 0x90, 0xE2, 0xFA, 0x75, 0xF9,
  0x0E, 0x20, 0xEF, 0x98, 0x00, 0x70, 0x32, 0x03, 0x80, 0x07, 0xF9, 0x0D, 0x20, 0xBF, 0xD0, 0x72,
  0x07, 0xFD, 0x0B, 0x20, 0x8F, 0xD0, 0x72, 0x07, 0xFD, 0x08, 0x20, 0x4F, 0xD0, 0x72, 0x07, 0xFD,
  0x03, 0x30, 0xDF, 0xC0, 0x72, 0x07, 0xFC, 0x0E, 0x40, 0x9F, 0xFF, 0xD0, 0x74, 0x0D, 0xFF, 0xFC,
  0x0D, 0x40, 0x2F, 0xFF, 0xD0, 0x54, 0x06, 0xFF, 0xFC, 0x08, 0x50, 0xBF, 0xFF, 0xB0, 0xA6, 0xFF,
  0xFB, 0x07, 0x60, 0x5F, 0xFF, 0x90, 0xD0, 0x57, 0x09, 0xF8, 0x1D, 0x9E, 0xFB, 0x0E, 0x07, 0x72,
  0x0E, 0xC8, 0x1B, 0x62, 0x38, 0x90, 0x48, 0xBD, 0xFE, 0xDB, 0x83, 0x73, 0x83, 0x3F, 0xE9, 0x57,
  0x77, 0x60, 0x20, 0x37, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_maps_ugc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_maps_ugc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_medical_information 36x36, 4-bit Alpha,  RLE, 155 bytes.
static const unsigned char ic_filled_36_maps_medical_information_data[] PROGMEM = {
  0x74, 0x03, 0x0B, 0xC0, 0xB0, 0x37, 0x77, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x76, 0x06, 0xF9, 0x06,
  0x77, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x77, 0x60,
  0x7A, 0x07, 0x20, 0x7A, 0x07, 0x77, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x74, 0x01, 0x06, 0x80,
  0x37, 0x0B, 0xA0, 0x72, 0x07, 0xA0, 0xB8, 0x03, 0x78, 0x36, 0x10, 0x3E, 0xFC, 0x07, 0x20, 0x7F,
  0xC8, 0x1E, 0x3B, 0xFD, 0x07, 0x20, 0x7F, 0xD0, 0xBF, 0xE8, 0x2B, 0x77, 0xB8, 0x0A, 0x90, 0xF0,
  0x72, 0x07, 0xFF, 0xFD, 0x07, 0x20, 0x7D, 0x0B, 0x80, 0x47, 0x0B, 0xFC, 0x07, 0x20, 0x7D, 0x07,
  0x71, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xA0, 0x98, 0x04, 0x30, 0x9F, 0x90, 0x77, 0x10, 0x7F, 0xFE,
  0x07, 0x71, 0x07, 0xFF, 0xFA, 0x07, 0x20, 0x7D, 0x07, 0x50, 0x7F, 0xF0, 0x72, 0x07, 0xD0, 0x75,
  0x07, 0xFF, 0x07, 0x20, 0x7D, 0x0D, 0x80, 0x1B, 0x0D, 0x80, 0x9B, 0x5F, 0x0D, 0xFF, 0xFF, 0x0D,
  0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_medical_information() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_medical_information_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_medical_services 36x36, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_filled_36_maps_medical_services_data[] PROGMEM = {
  0x73, 0x08, 0x0D, 0xE0, 0xD0, 0x87, 0x75, 0x08, 0xFB, 0x08, 0x77, 0x40, 0xDF, 0xB0, 0xD7, 0x74,
  0xB6, 0xB7, 0x74, 0xB6, 0xB7, 0x74, 0xB6, 0xB7, 0x30, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F,
  0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xD8, 0x09, 0xC3, 0xF0, 0x72, 0x07, 0xFF, 0xFD, 0x07, 0x20,
  0x7F, 0xFF, 0xD0, 0x72, 0x07, 0xFF, 0xFD, 0x07, 0x20, 0x7F, 0xFF, 0x98, 0x00, 0x70, 0x32, 0x03,
  0x80, 0x07, 0xFF, 0xC7, 0x5F, 0xFC, 0x75, 0xFF, 0xC8, 0x00, 0x70, 0x32, 0x03, 0x80, 0x07, 0xFF,
  0xF9, 0x07, 0x20, 0x7F, 0xFF, 0xD0, 0x72, 0x07, 0xFF, 0xFD, 0x07, 0x20, 0x7F, 0xFF, 0xD0, 0x72,
  0x07, 0x80, 0x9C, 0x3F, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82, 0x80, 0x8D, 0xFF, 0xFB,
  0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_medical_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_medical_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_menu_book 36x36, 4-bit Alpha,  RLE, 245 bytes.
static const unsigned char ic_filled_36_maps_menu_book_data[] PROGMEM = {
  0x68, 0x31, 0x23, 0x31, 0x75, 0x83, 0x13, 0x32, 0x17, 0x18, 0x21, 0x7B, 0xEE, 0x81, 0xD9, 0x44,
  0x81, 0x49, 0xDE, 0x82, 0xEB, 0x71, 0x20, 0x10, 0x9F, 0xE8, 0x2D, 0x44, 0xDF, 0xE8, 0x19, 0x17,
  0xFF, 0xF9, 0x83, 0xDC, 0xBD, 0xDD, 0x00, 0x7F, 0xFC, 0x82, 0xD8, 0x41, 0x60, 0x40, 0xBA, 0x00,
  0x7F, 0xFA, 0x0B, 0x04, 0x74, 0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x48,
  0x90, 0x24, 0x67, 0x76, 0x53, 0x07, 0xA0, 0x07, 0xFF, 0xA1, 0x81, 0x29, 0xEF, 0x91, 0x07, 0xA0,
  0x07, 0xFF, 0xA1, 0x07, 0xB8, 0x7E, 0xDB, 0xBC, 0xEF, 0x07, 0xA0, 0x07, 0xFF, 0xA1, 0x82, 0x7C,
  0x62, 0x71, 0x07, 0xA0, 0x07, 0xFF, 0xA4, 0x89, 0x02, 0x46, 0x77, 0x75, 0x30, 0x7A, 0x00, 0x7F,
  0xFA, 0x18, 0x12, 0x9E, 0xF9, 0x10, 0x7A, 0x00, 0x7F, 0xFA, 0x10, 0x7B, 0x87, 0xED, 0xBB, 0xCD,
  0xF0, 0x7A, 0x00, 0x7F, 0xFA, 0x18, 0x27, 0xB6, 0x27, 0x10, 0x7A, 0x00, 0x7F, 0xFA, 0x48, 0x90,
  0x24, 0x67, 0x77, 0x53, 0x07, 0xA0, 0x07, 0xFF, 0xA1, 0x81, 0x29, 0xEF, 0x91, 0x07, 0xA0, 0x07,
  0xFF, 0xA1, 0x07, 0xB8, 0x7E, 0xDB, 0xBC, 0xDF, 0x07, 0xA0, 0x07, 0xFF, 0xA1, 0x82, 0x7C, 0x62,
  0x71, 0x07, 0xA0, 0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x00, 0x7F, 0xFA, 0x76, 0x07, 0xA0, 0x07, 0xFF,
  0xA3, 0x89, 0x13, 0x7A, 0xDE, 0xFD, 0xDA, 0x7A, 0xA0, 0x07, 0xFF, 0xA1, 0x07, 0x0D, 0xFE, 0x00,
  0x7F, 0xFA, 0x0E, 0xFF, 0x90, 0x07, 0xA8, 0x3E, 0x96, 0x31, 0x28, 0x31, 0x36, 0x9E, 0xD8, 0x3C,
  0x84, 0x21, 0x28, 0x22, 0x47, 0xCA, 0x82, 0x73, 0x94, 0x75, 0x83, 0x5E, 0xE7, 0x17, 0x48, 0x13,
  0x82, 0x77, 0x30, 0x17, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_menu_book() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 34, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_menu_book_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_merge 36x36, 4-bit Alpha,  RLE, 150 bytes.
static const unsigned char ic_filled_36_maps_merge_data[] PROGMEM = {
  0x73, 0x00, 0x17, 0x75, 0x82, 0x1D, 0xD1, 0x77, 0x30, 0x10, 0xDA, 0x0D, 0x01, 0x77, 0x10, 0x10,
  0xDC, 0x0D, 0x01, 0x76, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x40, 0x10, 0xDF, 0x90, 0xD0, 0x17, 0x30,
  0xBA, 0x0E, 0x0B, 0xA0, 0xB0, 0xEA, 0x0B, 0x73, 0x83, 0x1D, 0xE4, 0x7A, 0x83, 0x74, 0xED, 0x17,
  0x48, 0x21, 0x30, 0x7A, 0x82, 0x70, 0x31, 0x77, 0x10, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77,
  0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x8A, 0x08, 0x77,
  0x40, 0xBA, 0x0B, 0x77, 0x30, 0x2C, 0x02, 0x77, 0x20, 0xBC, 0x0B, 0x77, 0x10, 0x9E, 0x09, 0x76,
  0x09, 0xB0, 0x09, 0xB0, 0x97, 0x40, 0x9B, 0x09, 0x20, 0x9B, 0x09, 0x72, 0x09, 0xB0, 0x94, 0x09,
  0xB0, 0x97, 0x09, 0xB0, 0x96, 0x09, 0xB0, 0x95, 0x09, 0xB0, 0x97, 0x10, 0x9B, 0x09, 0x30, 0x9B,
  0x09, 0x73, 0x09, 0xB8, 0x19, 0x03, 0xB0, 0x97, 0x50, 0x9B, 0x83, 0x30, 0x6F, 0x97, 0x78, 0x19,
  0xF6, 0x30, 0x37, 0x72, 0x03, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 28, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_minor_crash 36x36, 4-bit Alpha,  RLE, 226 bytes.
static const unsigned char ic_filled_36_maps_minor_crash_data[] PROGMEM = {
  0x75, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x72, 0x81, 0x1B,
  0x25, 0x07, 0xA0, 0x75, 0x81, 0x2B, 0x17, 0x83, 0x1C, 0xFE, 0x24, 0x07, 0xA0, 0x74, 0x83, 0x2E,
  0xFC, 0x16, 0x02, 0x0E, 0xA0, 0xE0, 0x23, 0x07, 0xA0, 0x73, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x02,
  0x0E, 0xA0, 0xE0, 0x22, 0x07, 0xA0, 0x72, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x20, 0x20, 0xEA, 0x0D,
  0x28, 0x23, 0x77, 0x32, 0x0D, 0xA0, 0xE0, 0x27, 0x48, 0x22, 0xEE, 0x27, 0x18, 0x22, 0xEE, 0x27,
  0x60, 0x02, 0x73, 0x00, 0x28, 0x0F, 0x70, 0x08, 0x0E, 0xFF, 0xA0, 0xE0, 0x87, 0x05, 0xFF, 0xE0,
  0x56, 0x0B, 0xFF, 0xE0, 0xB5, 0x01, 0xB0, 0x17, 0x70, 0x1B, 0x01, 0x40, 0x6A, 0x0B, 0x77, 0x20,
  0xBA, 0x06, 0x40, 0xBA, 0x06, 0x77, 0x20, 0x6A, 0x0B, 0x30, 0x1B, 0x01, 0x77, 0x20, 0x1B, 0x01,
  0x20, 0x7A, 0x0D, 0x80, 0x96, 0x70, 0xEA, 0x07, 0x20, 0xCF, 0xFF, 0xB8, 0x1C, 0x02, 0xFF, 0xFD,
  0x02, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xC8, 0x2C, 0x20, 0x6F, 0xB8, 0x26, 0x02,
  0xCC, 0x00, 0x7C, 0x02, 0x30, 0xAF, 0x90, 0xA3, 0x02, 0xC0, 0x07, 0xC0, 0x13, 0x08, 0xF9, 0x08,
  0x30, 0x1C, 0x00, 0x7C, 0x06, 0x30, 0xDF, 0x90, 0xD3, 0x06, 0xC0, 0x07, 0xD8, 0x1A, 0x8D, 0xFB,
  0x81, 0xD8, 0xAD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7C, 0x77, 0x4C, 0x00, 0x7C, 0x77, 0x4C, 0x81, 0x72, 0xDA, 0x08, 0x77, 0x40, 0x8A,
  0x0D, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_minor_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 31, 35), Box(0, 0, 35, 35),
      ic_filled_36_maps_minor_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_miscellaneous_services 36x36, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_filled_36_maps_miscellaneous_services_data[] PROGMEM = {
  0x70, 0x5C, 0x0C, 0x77, 0x73, 0x08, 0xD7, 0x77, 0x30, 0xAD, 0x02, 0x77, 0x48, 0x4A, 0x81, 0x05,
  0xED, 0x84, 0xA1, 0x05, 0xB4, 0x75, 0x06, 0xB0, 0xDF, 0x90, 0x0E, 0xA0, 0xD7, 0x40, 0x10, 0xEF,
  0xFB, 0x07, 0x73, 0x09, 0xFF, 0xC0, 0xE0, 0x17, 0x20, 0xDF, 0x82, 0xEA, 0x8C, 0xF9, 0x04, 0x72,
  0x01, 0x0B, 0xD0, 0xE0, 0x23, 0x09, 0xD0, 0xE0, 0x47, 0x50, 0xBC, 0x06, 0x5D, 0x02, 0x76, 0x09,
  0xC0, 0x45, 0x0C, 0xC0, 0x17, 0x60, 0xBC, 0x06, 0x5D, 0x02, 0x74, 0x01, 0x0B, 0xD0, 0xE0, 0x23,
  0x09, 0xD0, 0xE0, 0x47, 0x30, 0xDF, 0x82, 0xEA, 0x8C, 0xF9, 0x04, 0x72, 0x09, 0xFF, 0xC0, 0xE0,
  0x17, 0x20, 0x10, 0xEF, 0xFB, 0x06, 0x74, 0x06, 0xB0, 0xDF, 0x90, 0x0E, 0xA0, 0xD2, 0x01, 0x0F,
  0x77, 0x84, 0xA8, 0x20, 0x5E, 0xD8, 0x4A, 0x10, 0x5A, 0x42, 0x05, 0xB0, 0x37, 0x40, 0xAD, 0x02,
  0x48, 0x25, 0x20, 0x9B, 0x82, 0x70, 0x24, 0x71, 0x08, 0xD4, 0x02, 0xA0, 0xED, 0x82, 0xDF, 0xE1,
  0x70, 0x5C, 0x0C, 0x40, 0xBF, 0xC0, 0x97, 0x73, 0x0C, 0xC8, 0x17, 0x38, 0xC0, 0xA7, 0x74, 0x0B,
  0xA0, 0x93, 0x0B, 0xA0, 0xA7, 0x75, 0x09, 0xA0, 0x73, 0x09, 0xA0, 0x77, 0x74, 0x05, 0x0E, 0xA8,
  0x3D, 0x10, 0x2E, 0xA0, 0xE0, 0x47, 0x73, 0x0E, 0xC8, 0x1E, 0xCE, 0xC0, 0xD7, 0x73, 0x06, 0xFC,
  0x05, 0x77, 0x48, 0x2B, 0x95, 0xDB, 0x82, 0xC5, 0x9A, 0x77, 0x71, 0x05, 0xB0, 0x47, 0x77, 0x40,
  0x3B, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_miscellaneous_services() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_miscellaneous_services_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_mode_of_travel 36x36, 4-bit Alpha,  RLE, 213 bytes.
static const unsigned char ic_filled_36_maps_mode_of_travel_data[] PROGMEM = {
  0x78, 0x90, 0x16, 0xAD, 0xEE, 0xDB, 0x61, 0x77, 0x30, 0x20, 0x9F, 0xB0, 0x90, 0x27, 0x70, 0x50,
  0xEF, 0xD0, 0xE0, 0x57, 0x50, 0x7C, 0x81, 0xA5, 0x22, 0x81, 0x25, 0xAC, 0x07, 0x73, 0x05, 0xB0,
  0xC0, 0x37, 0x10, 0x30, 0xCB, 0x05, 0x71, 0x01, 0x0E, 0xA0, 0xB7, 0x50, 0xBA, 0x0E, 0x01, 0x70,
  0x9A, 0x0D, 0x77, 0x0C, 0xA0, 0x96, 0x01, 0xB0, 0x37, 0x70, 0x3B, 0x01, 0x50, 0x6A, 0x0B, 0x77,
  0x20, 0xBA, 0x06, 0x50, 0xAA, 0x06, 0x77, 0x20, 0x6A, 0x0A, 0x50, 0xCA, 0x02, 0x77, 0x20, 0x2A,
  0x0C, 0x50, 0xEA, 0x01, 0x75, 0x09, 0x80, 0x0B, 0xB8, 0x00, 0xB0, 0x9B, 0x76, 0x01, 0x0D, 0xFA,
  0x81, 0xD1, 0xDA, 0x02, 0x76, 0x01, 0x0D, 0xF8, 0x2D, 0x10, 0xBA, 0x05, 0x77, 0x01, 0x0D, 0xD0,
  0xD0, 0x12, 0x06, 0xA0, 0xB7, 0x71, 0x01, 0x0D, 0xB0, 0xD0, 0x13, 0x01, 0xB0, 0x27, 0x71, 0x83,
  0x1D, 0xFD, 0x15, 0x0A, 0xA0, 0xA7, 0x72, 0x81, 0x1B, 0x16, 0x02, 0xB0, 0x47, 0x28, 0x41, 0x9D,
  0xD9, 0x17, 0x30, 0x8A, 0x0E, 0x01, 0x71, 0x0D, 0xC0, 0xD7, 0x30, 0x10, 0xDA, 0x0B, 0x70, 0x7E,
  0x07, 0x73, 0x03, 0xB0, 0x96, 0x0A, 0xE0, 0xA7, 0x40, 0x7B, 0x07, 0x50, 0x9E, 0x09, 0x75, 0x09,
  0xB0, 0x64, 0x08, 0xE0, 0x47, 0x60, 0xBB, 0x06, 0x20, 0x6E, 0x07, 0x77, 0x10, 0xBB, 0x00, 0x7B,
  0x82, 0xB6, 0x62, 0x77, 0x30, 0xBE, 0x0B, 0x77, 0x71, 0x0B, 0xC0, 0xB7, 0x77, 0x30, 0xAA, 0x0A,
  0x77, 0x75, 0x00, 0x87, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_mode_of_travel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 34, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_mode_of_travel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_money 36x36, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_filled_36_maps_money_data[] PROGMEM = {
  0x80, 0x9B, 0x1F, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE1, 0x07, 0xA8, 0x17, 0x08, 0xD8,
  0x2D, 0x20, 0x8D, 0x0D, 0x02, 0x1E, 0x10, 0x7A, 0x07, 0x1F, 0x07, 0x1F, 0x07, 0x1E, 0x10, 0x7A,
  0x07, 0x1F, 0x07, 0x1F, 0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A,
  0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1E, 0x10, 0x7A,
  0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A,
  0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A,
  0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1B, 0x10, 0x7A, 0x07, 0x1E, 0x10, 0x7A,
  0x07, 0x1F, 0x07, 0x1F, 0x07, 0x1E, 0x10, 0x7A, 0x07, 0x1F, 0x07, 0x1F, 0x07, 0x1E, 0x10, 0x7A,
  0x81, 0x70, 0x8D, 0x82, 0xD2, 0x08, 0xD0, 0xD0, 0x21, 0xE7, 0x77, 0x3E, 0x77, 0x73, 0xE7, 0x77,
  0x38, 0x09, 0xB1, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_money() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_money_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_moped 36x36, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_filled_36_maps_moped_data[] PROGMEM = {
  0x77, 0x48, 0x01, 0x70, 0x47, 0x77, 0x3E, 0x09, 0x72, 0x07, 0xF6, 0xF0, 0x47, 0x10, 0x7F, 0x68,
  0x00, 0x70, 0xBA, 0x07, 0x71, 0x07, 0xF7, 0x30, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x10,
  0x48, 0x03, 0x77, 0x30, 0x7A, 0x07, 0x60, 0x50, 0xDF, 0x97, 0x30, 0x9A, 0x07, 0x50, 0x6F, 0xB7,
  0x20, 0x5B, 0x06, 0x40, 0x2F, 0xC7, 0x10, 0x20, 0xEA, 0x0B, 0x50, 0x9F, 0xC7, 0x01, 0x0D, 0xA0,
  0xD0, 0x15, 0x0D, 0xFC, 0x70, 0xBA, 0x0E, 0x02, 0x6F, 0xD6, 0x08, 0xB8, 0x35, 0x04, 0x74, 0x3F,
  0xD5, 0x05, 0xB8, 0x18, 0x4E, 0xB0, 0xE0, 0x41, 0xFF, 0xE0, 0xB0, 0x2F, 0x02, 0xFF, 0xD8, 0x1D,
  0x1A, 0xA8, 0x1D, 0x8D, 0xA0, 0xAF, 0xFC, 0x82, 0xE2, 0x0D, 0xA8, 0x12, 0x02, 0xA0, 0xD3, 0x0D,
  0xA8, 0x12, 0x02, 0xA0, 0xD7, 0x20, 0xDA, 0x81, 0x20, 0x2A, 0x0D, 0x30, 0xAA, 0x81, 0xD8, 0xDA,
  0x0A, 0x72, 0x0A, 0xA8, 0x1D, 0x8D, 0xA0, 0xA3, 0x02, 0xF0, 0x27, 0x20, 0x2F, 0x02, 0x40, 0x40,
  0xEB, 0x0E, 0x04, 0x74, 0x04, 0x0E, 0xB0, 0xE0, 0x47, 0x81, 0x47, 0x47, 0x71, 0x81, 0x47, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_moped() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 32, 28), Box(0, 0, 35, 35),
      ic_filled_36_maps_moped_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_mosque 36x36, 4-bit Alpha,  RLE, 247 bytes.
static const unsigned char ic_filled_36_maps_mosque_data[] PROGMEM = {
  0x77, 0x30, 0x02, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x77, 0x20, 0x20, 0xCC, 0x0C, 0x02, 0x77,
  0x76, 0x07, 0xF9, 0x07, 0x77, 0x73, 0x02, 0x0C, 0xFB, 0x0C, 0x02, 0x76, 0x00, 0x76, 0x04, 0x0E,
  0xFD, 0x0E, 0x04, 0x60, 0x07, 0x30, 0x5A, 0x05, 0x40, 0x10, 0xEF, 0xF0, 0xE0, 0x14, 0x05, 0xA8,
  0x25, 0x02, 0xEA, 0x0E, 0x02, 0x30, 0x8F, 0xFA, 0x08, 0x30, 0x20, 0xEA, 0x81, 0xE2, 0xBC, 0x0A,
  0x30, 0xDF, 0xFA, 0x0D, 0x30, 0xBC, 0x0A, 0x0E, 0xC0, 0xE3, 0x0E, 0xFF, 0xA0, 0xE3, 0x0E, 0xC0,
  0xE0, 0xCC, 0x0C, 0x30, 0xDF, 0xFA, 0x0D, 0x30, 0xCC, 0x81, 0xC3, 0xEA, 0x0E, 0x03, 0x30, 0x17,
  0x72, 0x01, 0x30, 0x30, 0xEA, 0x82, 0xE3, 0x07, 0xA0, 0x74, 0x04, 0x80, 0x94, 0x70, 0x44, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x73, 0x09, 0xFF, 0xC0, 0x93, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x04,
  0xFF, 0xE0, 0x42, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xFF, 0xE0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x72, 0x07, 0xFF, 0xE0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xFF, 0xE0,
  0x72, 0x07, 0xA0, 0x72, 0x07, 0xA8, 0x2B, 0x77, 0xBF, 0xFE, 0x82, 0xB7, 0x7B, 0xA0, 0x72, 0x07,
  0xFF, 0xFF, 0xC0, 0x72, 0x07, 0xFF, 0xFF, 0xC0, 0x72, 0x07, 0xFF, 0x82, 0xE9, 0x9E, 0xFF, 0x07,
  0x20, 0x7F, 0xE0, 0xC0, 0x12, 0x01, 0x0C, 0xFE, 0x07, 0x20, 0x7F, 0xE0, 0x34, 0x03, 0xFE, 0x07,
  0x20, 0x7F, 0xE6, 0xFE, 0x07, 0x20, 0x7F, 0xE6, 0xFE, 0x07, 0x20, 0x7F, 0xE6, 0xFE, 0x07, 0x20,
  0x7F, 0xE6, 0xFE, 0x07, 0x20, 0x7F, 0xE6, 0xFE, 0x07, 0x20, 0x7F, 0xE6, 0xFE, 0x07, 0x20, 0x38,
  0x09, 0x17, 0x68, 0x09, 0x17, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_mosque() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 35, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_mosque_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_moving 36x36, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_filled_36_maps_moving_data[] PROGMEM = {
  0x77, 0x70, 0x7F, 0x97, 0x77, 0x10, 0x7F, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x30, 0xCD, 0x77, 0x72,
  0x09, 0xE7, 0x77, 0x10, 0x9B, 0x0C, 0xB7, 0x28, 0x21, 0x44, 0x17, 0x10, 0x9B, 0x81, 0x90, 0x7A,
  0x71, 0x07, 0xC0, 0x96, 0x09, 0xB0, 0x93, 0x07, 0x97, 0x09, 0xE0, 0xC0, 0x13, 0x09, 0xB0, 0x95,
  0x07, 0x60, 0x9B, 0x0C, 0x0B, 0xB8, 0x2C, 0x10, 0x9B, 0x09, 0x75, 0x09, 0xB0, 0x92, 0x06, 0xC0,
  0xEB, 0x09, 0x75, 0x09, 0xB0, 0x94, 0x06, 0xE0, 0x97, 0x50, 0x9B, 0x09, 0x60, 0x30, 0xCA, 0x0D,
  0x06, 0x75, 0x09, 0xB0, 0x97, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x73, 0x09, 0xB0, 0x97, 0x77, 0x40,
  0x6A, 0x09, 0x77, 0x76, 0x06, 0x09, 0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_moving() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 9, 32, 26), Box(0, 0, 35, 35),
      ic_filled_36_maps_moving_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_multiple_stop 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_filled_36_maps_multiple_stop_data[] PROGMEM = {
  0x77, 0x70, 0x50, 0x17, 0x77, 0x58, 0x17, 0xD1, 0x77, 0x74, 0x82, 0x7F, 0xD1, 0x77, 0x73, 0x07,
  0xA0, 0xD0, 0x16, 0x00, 0x54, 0x00, 0x53, 0x03, 0x80, 0x17, 0x0B, 0xB0, 0xD0, 0x14, 0x05, 0xA0,
  0x52, 0x05, 0xA0, 0x52, 0x07, 0xFB, 0x0D, 0x01, 0x30, 0x5A, 0x05, 0x20, 0x5A, 0x05, 0x20, 0x7F,
  0xB0, 0xD0, 0x14, 0x00, 0x54, 0x00, 0x53, 0x03, 0x80, 0x17, 0x0B, 0xB0, 0xD0, 0x17, 0x77, 0x10,
  0x7A, 0x0D, 0x01, 0x77, 0x72, 0x82, 0x7F, 0xD1, 0x77, 0x73, 0x81, 0x7D, 0x17, 0x77, 0x40, 0x50,
  0x17, 0x30, 0x10, 0x57, 0x77, 0x48, 0x11, 0xD7, 0x77, 0x73, 0x82, 0x1D, 0xF7, 0x77, 0x72, 0x01,
  0x0D, 0xA0, 0x77, 0x77, 0x10, 0x10, 0xDB, 0x0B, 0x80, 0x17, 0x03, 0x30, 0x05, 0x40, 0x05, 0x40,
  0x10, 0xDF, 0xB0, 0x72, 0x05, 0xA0, 0x52, 0x05, 0xA0, 0x53, 0x01, 0x0D, 0xFB, 0x07, 0x20, 0x5A,
  0x05, 0x20, 0x5A, 0x05, 0x40, 0x10, 0xDB, 0x0B, 0x80, 0x17, 0x03, 0x30, 0x05, 0x40, 0x05, 0x60,
  0x10, 0xDA, 0x07, 0x77, 0x73, 0x82, 0x1D, 0xF7, 0x77, 0x74, 0x81, 0x1D, 0x77, 0x77, 0x50, 0x10,
  0x57, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_multiple_stop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_multiple_stop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_museum 36x36, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_filled_36_maps_museum_data[] PROGMEM = {
  0x76, 0x82, 0x1A, 0xA1, 0x77, 0x74, 0x03, 0x0D, 0xA0, 0xD0, 0x37, 0x77, 0x20, 0x8E, 0x08, 0x77,
  0x60, 0x20, 0xCF, 0x90, 0xC0, 0x27, 0x73, 0x06, 0xFD, 0x06, 0x77, 0x01, 0x0B, 0xFF, 0x0B, 0x01,
  0x74, 0x05, 0x0E, 0xFF, 0xA0, 0xE0, 0x57, 0x10, 0x10, 0xAF, 0xFE, 0x0A, 0x01, 0x50, 0x30, 0xDF,
  0xFF, 0x90, 0xD0, 0x33, 0x08, 0xFF, 0xFD, 0x81, 0x80, 0xCF, 0xFF, 0xF0, 0xC8, 0x0F, 0x0F, 0x0F,
  0x7E, 0x0F, 0x70, 0xEC, 0x0E, 0x0F, 0x7E, 0x0F, 0x73, 0xE3, 0x05, 0xC0, 0x53, 0xE6, 0xE4, 0x0A,
  0xA0, 0xA4, 0xE6, 0xE4, 0x82, 0x1E, 0xE1, 0x4E, 0x6E, 0x50, 0x05, 0x5E, 0x6E, 0x30, 0x54, 0x05,
  0x3E, 0x6E, 0x30, 0xE0, 0x12, 0x01, 0x0E, 0x3E, 0x6E, 0x39, 0x0A, 0x20, 0xA9, 0x3E, 0x6E, 0x3A,
  0x00, 0x5A, 0x3E, 0x6E, 0x3A, 0x00, 0xEA, 0x3E, 0x6E, 0x3E, 0x3E, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB,
  0x6F, 0xFF, 0xB3, 0x80, 0x9A, 0x6F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_museum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_museum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_my_location 36x36, 4-bit Alpha,  RLE, 276 bytes.
static const unsigned char ic_filled_36_maps_my_location_data[] PROGMEM = {
  0x77, 0x18, 0x23, 0x77, 0x37, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77,
  0x71, 0x03, 0x0A, 0xA0, 0xA0, 0x37, 0x77, 0x40, 0x40, 0xAF, 0x90, 0xA0, 0x47, 0x76, 0x03, 0x0C,
  0xFD, 0x0C, 0x03, 0x77, 0x30, 0x6D, 0x84, 0xD9, 0x88, 0x9D, 0xD0, 0x67, 0x71, 0x08, 0xC0, 0x80,
  0x26, 0x02, 0x08, 0xC0, 0x87, 0x60, 0x6B, 0x0C, 0x01, 0x73, 0x01, 0x0C, 0xB0, 0x67, 0x40, 0x3B,
  0x0A, 0x77, 0x0A, 0xB0, 0x37, 0x30, 0xCA, 0x0C, 0x77, 0x20, 0xCA, 0x0C, 0x72, 0x04, 0xB0, 0x15,
  0x84, 0x6C, 0xEE, 0xC6, 0x50, 0x1B, 0x04, 0x71, 0x0A, 0xA0, 0x84, 0x01, 0x0C, 0xE0, 0xC0, 0x14,
  0x08, 0xA0, 0xA7, 0x1B, 0x02, 0x40, 0xCF, 0x90, 0xC4, 0x02, 0xB7, 0x03, 0xA0, 0xC4, 0x06, 0xFB,
  0x06, 0x40, 0xCA, 0x03, 0x38, 0x23, 0x77, 0xAA, 0x0A, 0x40, 0xCF, 0xB0, 0xC4, 0x0A, 0xA8, 0x3A,
  0x77, 0x37, 0xD0, 0x84, 0x0E, 0xFB, 0x0E, 0x40, 0x8D, 0x00, 0x7D, 0x08, 0x40, 0xEF, 0xB0, 0xE4,
  0x08, 0xD8, 0x37, 0x37, 0x7A, 0xA0, 0xA4, 0x0C, 0xFB, 0x0C, 0x40, 0xAA, 0x82, 0xA7, 0x73, 0x30,
  0x3A, 0x0C, 0x40, 0x6F, 0xB0, 0x64, 0x0C, 0xA0, 0x37, 0xB0, 0x24, 0x0C, 0xF9, 0x0C, 0x40, 0x2B,
  0x71, 0x0A, 0xA0, 0x84, 0x01, 0x0C, 0xE0, 0xC0, 0x14, 0x08, 0xA0, 0xA7, 0x10, 0x4B, 0x01, 0x58,
  0x46, 0xCE, 0xEC, 0x65, 0x01, 0xB0, 0x47, 0x20, 0xCA, 0x0C, 0x77, 0x20, 0xCA, 0x0C, 0x73, 0x03,
  0xB0, 0xA7, 0x70, 0xAB, 0x03, 0x74, 0x06, 0xB0, 0xC0, 0x17, 0x30, 0x10, 0xCB, 0x06, 0x76, 0x08,
  0xC0, 0x80, 0x26, 0x02, 0x08, 0xC0, 0x87, 0x71, 0x06, 0xD8, 0x4D, 0x98, 0x89, 0xDD, 0x06, 0x77,
  0x30, 0x30, 0xCF, 0xD0, 0xC0, 0x37, 0x76, 0x04, 0x0A, 0xF9, 0x0A, 0x04, 0x77, 0x74, 0x03, 0x0A,
  0xA0, 0xA0, 0x37, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x77, 0x72, 0x82,
  0x37, 0x73, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_my_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_my_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_navigation 36x36, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_filled_36_maps_navigation_data[] PROGMEM = {
  0x74, 0x00, 0x37, 0x77, 0x10, 0x09, 0x77, 0x78, 0x21, 0xEE, 0x17, 0x76, 0x06, 0xA0, 0x67, 0x76,
  0x0D, 0xA0, 0xD7, 0x75, 0x03, 0xC0, 0x37, 0x74, 0x0A, 0xC0, 0xA7, 0x73, 0x01, 0xE0, 0x17, 0x72,
  0x07, 0xE0, 0x77, 0x72, 0x0D, 0xE0, 0xD7, 0x71, 0x04, 0xF9, 0x04, 0x77, 0x0B, 0xF9, 0x0B, 0x76,
  0x02, 0xFB, 0x02, 0x75, 0x08, 0xFB, 0x08, 0x75, 0x0E, 0xFB, 0x0E, 0x74, 0x05, 0xFD, 0x05, 0x73,
  0x0B, 0xFD, 0x0B, 0x72, 0x02, 0xFF, 0x02, 0x71, 0x09, 0xFF, 0x09, 0x71, 0x0E, 0xFF, 0x0E, 0x70,
  0x6F, 0xFA, 0x06, 0x60, 0xCF, 0xFA, 0x0C, 0x50, 0x3F, 0xFC, 0x03, 0x40, 0x9F, 0xFC, 0x09, 0x30,
  0x1F, 0x98, 0x2A, 0x33, 0xAF, 0x90, 0x12, 0x07, 0xD8, 0x1E, 0x81, 0x48, 0x11, 0x8E, 0xD0, 0x72,
  0x0D, 0xB0, 0xD0, 0x67, 0x30, 0x60, 0xDB, 0x85, 0xD0, 0x1E, 0xFB, 0x47, 0x78, 0x64, 0xBF, 0xE1,
  0x03, 0x37, 0x74, 0x00, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_navigation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_navigation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_near_me_disabled 36x36, 4-bit Alpha,  RLE, 203 bytes.
static const unsigned char ic_filled_36_maps_near_me_disabled_data[] PROGMEM = {
  0x10, 0x20, 0x97, 0x77, 0x68, 0x22, 0xEF, 0xB7, 0x77, 0x50, 0x7B, 0x0B, 0x77, 0x70, 0x10, 0x23,
  0x07, 0xB0, 0xB7, 0x74, 0x82, 0x5B, 0xF2, 0x40, 0x7B, 0x0B, 0x77, 0x81, 0x49, 0xEA, 0x0B, 0x60,
  0x7B, 0x0B, 0x73, 0x81, 0x28, 0xDD, 0x05, 0x70, 0x7B, 0x0B, 0x68, 0x11, 0x6C, 0xF0, 0xE7, 0x20,
  0x7B, 0x0B, 0x40, 0x8F, 0xB0, 0x97, 0x30, 0x7B, 0x0B, 0x30, 0x20, 0xDF, 0xA0, 0x47, 0x40, 0x8B,
  0x0B, 0x30, 0x20, 0xDF, 0x0D, 0x73, 0x04, 0x0A, 0xD0, 0xB3, 0x02, 0x0D, 0xE0, 0x87, 0x81, 0x38,
  0xEF, 0x90, 0xB3, 0x02, 0x0D, 0xD0, 0x25, 0x04, 0x0C, 0xFD, 0x0B, 0x30, 0x20, 0xDB, 0x0C, 0x60,
  0x7F, 0xF0, 0xB3, 0x02, 0x0D, 0xA0, 0x66, 0x05, 0xFF, 0x90, 0xB3, 0x82, 0x2D, 0xF1, 0x78, 0x11,
  0x6D, 0xFE, 0x0B, 0x30, 0x20, 0x87, 0x40, 0x30, 0xAF, 0xD0, 0xB7, 0x73, 0x81, 0x17, 0xDF, 0xB0,
  0xB7, 0x75, 0x03, 0x0A, 0xFA, 0x0B, 0x77, 0x60, 0xAF, 0xA0, 0xB7, 0x75, 0x03, 0xFB, 0x0B, 0x77,
  0x50, 0xDF, 0xB0, 0xB7, 0x74, 0x07, 0xF0, 0x8B, 0x0B, 0x77, 0x30, 0x1E, 0x81, 0xA0, 0x7B, 0x0B,
  0x77, 0x30, 0xAD, 0x04, 0x20, 0x7B, 0x0B, 0x77, 0x20, 0x3C, 0x0E, 0x40, 0x7B, 0x0B, 0x77, 0x20,
  0xDB, 0x08, 0x50, 0x7B, 0x0B, 0x77, 0x10, 0x7B, 0x03, 0x60, 0x7B, 0x09, 0x77, 0x01, 0xA0, 0xC7,
  0x18, 0x27, 0xFE, 0x27, 0x71, 0x81, 0x57, 0x47, 0x20, 0x70, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_near_me_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 33, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_near_me_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_near_me 36x36, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_filled_36_maps_near_me_data[] PROGMEM = {
  0x77, 0x75, 0x01, 0x02, 0x77, 0x73, 0x82, 0x3A, 0xE1, 0x77, 0x71, 0x06, 0x0C, 0xA0, 0xA7, 0x76,
  0x81, 0x28, 0xEC, 0x03, 0x77, 0x40, 0x40, 0xBE, 0x0C, 0x77, 0x28, 0x11, 0x7D, 0xF9, 0x06, 0x77,
  0x03, 0x0A, 0xFB, 0x0E, 0x76, 0x06, 0x0C, 0xFD, 0x08, 0x73, 0x81, 0x28, 0xEF, 0xF0, 0x27, 0x10,
  0x40, 0xBF, 0xFA, 0x0B, 0x68, 0x11, 0x7D, 0xFF, 0xC0, 0x44, 0x02, 0x09, 0xFF, 0xE0, 0xD5, 0x07,
  0xFF, 0xF0, 0x75, 0x02, 0x0A, 0xFF, 0xE0, 0x17, 0x81, 0x16, 0xCF, 0xFA, 0x09, 0x74, 0x81, 0x39,
  0xEF, 0xE0, 0x37, 0x70, 0x50, 0xBF, 0xB0, 0xC7, 0x73, 0x03, 0xFA, 0x05, 0x77, 0x40, 0xBF, 0x0E,
  0x77, 0x50, 0x5F, 0x08, 0x77, 0x60, 0xEE, 0x02, 0x77, 0x60, 0x9D, 0x0A, 0x77, 0x70, 0x3D, 0x04,
  0x77, 0x71, 0x0C, 0xB0, 0xD7, 0x77, 0x20, 0x6B, 0x06, 0x77, 0x72, 0x01, 0xA0, 0xE0, 0x17, 0x77,
  0x38, 0x1A, 0xF9, 0x77, 0x74, 0x81, 0x27, 0x27, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_near_me() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_near_me_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_nightlife 36x36, 4-bit Alpha,  RLE, 174 bytes.
static const unsigned char ic_filled_36_maps_nightlife_data[] PROGMEM = {
  0x02, 0x80, 0xA0, 0x70, 0x22, 0x03, 0x80, 0x37, 0x10, 0xCF, 0xFC, 0x0C, 0x30, 0x7F, 0x10, 0x2F,
  0xFC, 0x02, 0x30, 0x7F, 0x20, 0x7A, 0x0E, 0x80, 0x67, 0x0E, 0xA0, 0x74, 0x07, 0xF3, 0x0C, 0xA0,
  0x67, 0x10, 0x7A, 0x0C, 0x50, 0x7F, 0x30, 0x2B, 0x02, 0x60, 0x2B, 0x02, 0x50, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0xC8, 0x02, 0x70, 0xCA, 0x07, 0x60, 0x7A, 0x07, 0x72, 0x0C, 0xFB, 0x0C, 0x70, 0x7A,
  0x07, 0x72, 0x02, 0xFB, 0x02, 0x70, 0x7A, 0x07, 0x73, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xA0, 0x77,
  0x40, 0xCE, 0x0C, 0x72, 0x07, 0xA0, 0x77, 0x40, 0x2E, 0x02, 0x72, 0x07, 0xA0, 0x77, 0x50, 0x7C,
  0x07, 0x73, 0x07, 0xA0, 0x77, 0x60, 0xCA, 0x0C, 0x74, 0x07, 0xA0, 0x77, 0x60, 0x7A, 0x07, 0x78,
  0x32, 0xAD, 0xED, 0xA0, 0x77, 0x60, 0x7A, 0x07, 0x60, 0x4F, 0x07, 0x76, 0x07, 0xA0, 0x76, 0x0E,
  0xF0, 0x77, 0x60, 0x7A, 0x07, 0x50, 0x4F, 0x90, 0x77, 0x60, 0x7A, 0x07, 0x50, 0x6F, 0x90, 0x77,
  0x60, 0x7A, 0x07, 0x50, 0x4F, 0x90, 0x47, 0x30, 0x7F, 0x90, 0x73, 0x0E, 0xE0, 0xE7, 0x40, 0x7F,
  0x90, 0x73, 0x04, 0xE0, 0x47, 0x40, 0x7F, 0x90, 0x74, 0x84, 0x2A, 0xDD, 0xA2, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_nightlife() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_nightlife_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_no_crash 36x36, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_filled_36_maps_no_crash_data[] PROGMEM = {
  0x77, 0x40, 0x30, 0xB7, 0x77, 0x48, 0x23, 0xEF, 0xB7, 0x77, 0x20, 0x30, 0xEA, 0x0D, 0x02, 0x77,
  0x30, 0x60, 0x32, 0x03, 0x0E, 0xA0, 0xD0, 0x27, 0x73, 0x84, 0x6F, 0xE3, 0x3E, 0xA0, 0xD0, 0x27,
  0x74, 0x0D, 0xA0, 0x0E, 0xA0, 0xD0, 0x27, 0x75, 0x02, 0x0D, 0xC0, 0xD0, 0x27, 0x77, 0x02, 0x0D,
  0xA0, 0xD0, 0x27, 0x77, 0x28, 0x22, 0xDD, 0x27, 0x77, 0x40, 0x02, 0x80, 0x98, 0x50, 0x08, 0x0E,
  0xFF, 0xA0, 0xE0, 0x87, 0x05, 0xFF, 0xE0, 0x56, 0x0B, 0xFF, 0xE0, 0xB5, 0x01, 0xB0, 0x17, 0x70,
  0x1B, 0x01, 0x40, 0x6A, 0x0B, 0x77, 0x20, 0xBA, 0x06, 0x40, 0xBA, 0x06, 0x77, 0x20, 0x6A, 0x0B,
  0x30, 0x1B, 0x01, 0x77, 0x20, 0x1B, 0x01, 0x20, 0x7A, 0x0D, 0x80, 0x96, 0x70, 0xEA, 0x07, 0x20,
  0xCF, 0xFF, 0xB8, 0x1C, 0x02, 0xFF, 0xFD, 0x02, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07,
  0xC8, 0x2C, 0x20, 0x6F, 0xB8, 0x26, 0x02, 0xCC, 0x00, 0x7C, 0x02, 0x30, 0xAF, 0x90, 0xA3, 0x02,
  0xC0, 0x07, 0xC0, 0x13, 0x08, 0xF9, 0x08, 0x30, 0x1C, 0x00, 0x7C, 0x06, 0x30, 0xDF, 0x90, 0xD3,
  0x06, 0xC0, 0x07, 0xD8, 0x1A, 0x8D, 0xFB, 0x81, 0xD8, 0xAD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF,
  0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD, 0x00, 0x7C, 0x77, 0x4C, 0x00, 0x7C, 0x77, 0x4C,
  0x81, 0x72, 0xDA, 0x08, 0x77, 0x40, 0x8A, 0x0D, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_no_crash() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 31, 35), Box(0, 0, 35, 35),
      ic_filled_36_maps_no_crash_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_no_meals_ouline 36x36, 4-bit Alpha,  RLE, 279 bytes.
static const unsigned char ic_filled_36_maps_no_meals_ouline_data[] PROGMEM = {
  0x10, 0x30, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x18, 0x75, 0xBD, 0x70, 0x3E, 0xF7, 0x50,
  0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0x30, 0xDB, 0x81, 0x70, 0xAB, 0x07, 0x40, 0x7A, 0x07, 0x20,
  0x7A, 0x07, 0x50, 0x4D, 0x07, 0x20, 0xAB, 0x07, 0x30, 0x3A, 0x07, 0x20, 0x7A, 0x07, 0x40, 0x20,
  0xED, 0x07, 0x30, 0xBB, 0x07, 0x38, 0x14, 0xF7, 0x20, 0x7A, 0x07, 0x40, 0x9E, 0x07, 0x40, 0xBB,
  0x07, 0x30, 0x40, 0x72, 0x07, 0xA0, 0x74, 0x0E, 0xE0, 0x74, 0x07, 0xC0, 0x76, 0x07, 0xA0, 0x74,
  0xF0, 0x74, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x74, 0xF0, 0x74, 0x07, 0xE0, 0x74, 0x07, 0xA0, 0x74,
  0xF0, 0x74, 0x07, 0xA0, 0x80, 0xBB, 0x07, 0x30, 0x3A, 0x07, 0x4F, 0x07, 0x40, 0x7A, 0x0B, 0x08,
  0xC0, 0x73, 0x81, 0x4F, 0x74, 0xF0, 0x74, 0x06, 0xFA, 0x07, 0x30, 0x40, 0x54, 0xF0, 0x74, 0x02,
  0xFB, 0x07, 0x71, 0xF0, 0x75, 0x0A, 0xFB, 0x07, 0x7F, 0x07, 0x50, 0x10, 0xDF, 0xB0, 0x76, 0xF0,
  0x76, 0x01, 0x0A, 0xFB, 0x07, 0x5F, 0x07, 0x71, 0x81, 0x25, 0xBA, 0x81, 0xB5, 0xBB, 0x07, 0x4F,
  0x07, 0x73, 0x07, 0xA0, 0x72, 0x0B, 0xB0, 0x73, 0xF0, 0x77, 0x30, 0x7A, 0x07, 0x30, 0xBB, 0x07,
  0x60, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x74, 0x0B, 0xB0, 0x75, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07,
  0x50, 0xBB, 0x07, 0x40, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x76, 0x0B, 0xB0, 0x73, 0x03, 0xA0, 0x77,
  0x30, 0x7A, 0x07, 0x70, 0xBB, 0x07, 0x38, 0x14, 0xF7, 0x73, 0x07, 0xA0, 0x77, 0x10, 0xBB, 0x07,
  0x30, 0x40, 0x77, 0x30, 0x7A, 0x07, 0x72, 0x0B, 0xB0, 0x77, 0x70, 0x7A, 0x07, 0x73, 0x0A, 0xB0,
  0x77, 0x60, 0x7A, 0x07, 0x74, 0x0A, 0xB0, 0x77, 0x50, 0x7A, 0x07, 0x75, 0x0A, 0xB0, 0x77, 0x40,
  0x7A, 0x07, 0x76, 0x0A, 0xB0, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x0A, 0xB0, 0x77, 0x77, 0x78, 0x2A,
  0xFE, 0x37, 0x77, 0x71, 0x0A, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_no_meals_ouline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_no_meals_ouline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_no_meals 36x36, 4-bit Alpha,  RLE, 279 bytes.
static const unsigned char ic_filled_36_maps_no_meals_data[] PROGMEM = {
  0x10, 0x30, 0x76, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x18, 0x75, 0xBD, 0x70, 0x3E, 0xF7, 0x50,
  0x7A, 0x07, 0x20, 0x7A, 0x07, 0x60, 0x30, 0xDB, 0x81, 0x70, 0xAB, 0x07, 0x40, 0x7A, 0x07, 0x20,
  0x7A, 0x07, 0x50, 0x4D, 0x07, 0x20, 0xAB, 0x07, 0x30, 0x3A, 0x07, 0x20, 0x7A, 0x07, 0x40, 0x20,
  0xED, 0x07, 0x30, 0xBB, 0x07, 0x38, 0x14, 0xF7, 0x20, 0x7A, 0x07, 0x40, 0x9E, 0x07, 0x40, 0xBB,
  0x07, 0x30, 0x40, 0x72, 0x07, 0xA0, 0x74, 0x0E, 0xE0, 0x74, 0x07, 0xC0, 0x76, 0x07, 0xA0, 0x74,
  0xF0, 0x74, 0x07, 0xD0, 0x75, 0x07, 0xA0, 0x74, 0xF0, 0x74, 0x07, 0xE0, 0x74, 0x07, 0xA0, 0x74,
  0xF0, 0x74, 0x07, 0xA0, 0x80, 0xBB, 0x07, 0x30, 0x3A, 0x07, 0x4F, 0x07, 0x40, 0x7A, 0x0B, 0x08,
  0xC0, 0x73, 0x81, 0x4F, 0x74, 0xF0, 0x74, 0x06, 0xFA, 0x07, 0x30, 0x40, 0x54, 0xF0, 0x74, 0x02,
  0xFB, 0x07, 0x71, 0xF0, 0x75, 0x0A, 0xFB, 0x07, 0x7F, 0x07, 0x50, 0x10, 0xDF, 0xB0, 0x76, 0xF0,
  0x76, 0x01, 0x0A, 0xFB, 0x07, 0x5F, 0x07, 0x71, 0x81, 0x25, 0xBA, 0x81, 0xB5, 0xBB, 0x07, 0x4F,
  0x07, 0x73, 0x07, 0xA0, 0x72, 0x0B, 0xB0, 0x73, 0xF0, 0x77, 0x30, 0x7A, 0x07, 0x30, 0xBB, 0x07,
  0x60, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x74, 0x0B, 0xB0, 0x75, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07,
  0x50, 0xBB, 0x07, 0x40, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x76, 0x0B, 0xB0, 0x73, 0x03, 0xA0, 0x77,
  0x30, 0x7A, 0x07, 0x70, 0xBB, 0x07, 0x38, 0x14, 0xF7, 0x73, 0x07, 0xA0, 0x77, 0x10, 0xBB, 0x07,
  0x30, 0x40, 0x77, 0x30, 0x7A, 0x07, 0x72, 0x0B, 0xB0, 0x77, 0x70, 0x7A, 0x07, 0x73, 0x0A, 0xB0,
  0x77, 0x60, 0x7A, 0x07, 0x74, 0x0A, 0xB0, 0x77, 0x50, 0x7A, 0x07, 0x75, 0x0A, 0xB0, 0x77, 0x40,
  0x7A, 0x07, 0x76, 0x0A, 0xB0, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x0A, 0xB0, 0x77, 0x77, 0x78, 0x2A,
  0xFE, 0x37, 0x77, 0x71, 0x0A, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_no_meals() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_no_meals_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_not_listed_location 36x36, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_filled_36_maps_not_listed_location_data[] PROGMEM = {
  0x78, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x50, 0x60, 0xEF, 0x90, 0xE0, 0x67, 0x20, 0xAF, 0xD0, 0xA7,
  0x0B, 0xFF, 0x0B, 0x50, 0x8E, 0x82, 0xB8, 0x8B, 0xE0, 0x83, 0x02, 0xD0, 0xC0, 0x24, 0x02, 0x0C,
  0xD0, 0x22, 0x0A, 0xC0, 0xD0, 0x16, 0x01, 0x0D, 0xC0, 0xA2, 0x0E, 0xC0, 0x42, 0x82, 0x5C, 0xC5,
  0x20, 0x4C, 0x81, 0xE0, 0x4C, 0x0E, 0x20, 0x3C, 0x03, 0x20, 0xEC, 0x04, 0x06, 0xC8, 0x2D, 0x33,
  0xAC, 0x08, 0x20, 0xCC, 0x06, 0x07, 0xFD, 0x06, 0x20, 0xDC, 0x07, 0x05, 0xFC, 0x0B, 0x20, 0x3D,
  0x06, 0x03, 0xFB, 0x08, 0x20, 0x20, 0xED, 0x04, 0x1F, 0xA0, 0x92, 0x02, 0x0E, 0xE8, 0x11, 0x0B,
  0xF8, 0x3E, 0x10, 0x1E, 0xE0, 0xB2, 0x05, 0xF0, 0xC2, 0x08, 0xF0, 0x53, 0x0E, 0xE8, 0x2D, 0x99,
  0xDE, 0x0E, 0x40, 0x8F, 0xFA, 0x08, 0x40, 0x10, 0xED, 0x0A, 0x20, 0xAD, 0x0E, 0x01, 0x50, 0x7D,
  0x0A, 0x20, 0xAD, 0x07, 0x70, 0xDC, 0x82, 0xC5, 0x5C, 0xC0, 0xD7, 0x10, 0x4F, 0xD0, 0x47, 0x20,
  0xAF, 0xB0, 0xA7, 0x30, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x40, 0x5F, 0x90, 0x57, 0x60, 0x9E, 0x09,
  0x77, 0x10, 0xCC, 0x0C, 0x77, 0x20, 0x20, 0xEA, 0x0E, 0x02, 0x77, 0x30, 0x4A, 0x04, 0x77, 0x50,
  0x06, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_not_listed_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_not_listed_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_no_transfer 36x36, 4-bit Alpha,  RLE, 190 bytes.
static const unsigned char ic_filled_36_maps_no_transfer_data[] PROGMEM = {
  0x71, 0x83, 0x47, 0xAC, 0xDD, 0x84, 0xED, 0xCA, 0x73, 0x70, 0x20, 0x73, 0x01, 0x0D, 0xFF, 0xA0,
  0xE0, 0x64, 0x82, 0x2E, 0xF7, 0x30, 0x4F, 0xFC, 0x0A, 0x30, 0x9B, 0x07, 0x30, 0x4F, 0xFC, 0x05,
  0x30, 0xBB, 0x07, 0x30, 0x4F, 0xFB, 0x0C, 0x40, 0xBB, 0x07, 0x30, 0x4F, 0xFA, 0x0E, 0x50, 0xBB,
  0x07, 0x77, 0x3B, 0x6C, 0x07, 0x77, 0x2B, 0x6D, 0x07, 0x77, 0x1B, 0x6E, 0x07, 0x77, 0xB6, 0xB0,
  0xBB, 0x07, 0x76, 0xB6, 0xB1, 0x0B, 0xB0, 0x77, 0x5B, 0x6B, 0x20, 0xBB, 0x07, 0x74, 0xB6, 0xB8,
  0x17, 0x78, 0xC0, 0x74, 0x80, 0x27, 0xB6, 0xFC, 0x07, 0x30, 0x4F, 0x96, 0xFD, 0x07, 0x30, 0x4F,
  0x6F, 0xE0, 0x73, 0x04, 0xE6, 0xFF, 0x07, 0x30, 0x4D, 0x6B, 0x82, 0xC2, 0x06, 0xF9, 0x07, 0x30,
  0x4C, 0x6B, 0x02, 0x30, 0xAF, 0x90, 0x73, 0x04, 0xB6, 0xB0, 0x13, 0x08, 0xFA, 0x07, 0x30, 0x4A,
  0x60, 0xEA, 0x06, 0x30, 0xDF, 0xB0, 0x73, 0x04, 0x0D, 0x60, 0xBB, 0x81, 0xA8, 0xDF, 0xD0, 0x73,
  0x02, 0x60, 0x3F, 0xFD, 0x07, 0x73, 0x08, 0xFF, 0xD0, 0x77, 0x20, 0x7C, 0x80, 0x90, 0x7C, 0x07,
  0x71, 0x07, 0xC7, 0x5D, 0x07, 0x70, 0x5B, 0x0D, 0x75, 0x0D, 0xD0, 0x77, 0x82, 0x57, 0x72, 0x75,
  0x82, 0x27, 0x7B, 0xB0, 0x77, 0x77, 0x58, 0x2B, 0xFE, 0x27, 0x77, 0x60, 0x90, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_no_transfer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 31, 33), Box(0, 0, 35, 35),
      ic_filled_36_maps_no_transfer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_park 36x36, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_filled_36_maps_park_data[] PROGMEM = {
  0x76, 0x00, 0x57, 0x77, 0x48, 0x21, 0xEE, 0x17, 0x77, 0x30, 0xBA, 0x0B, 0x77, 0x72, 0x06, 0xC0,
  0x77, 0x77, 0x02, 0x0E, 0xD0, 0x27, 0x76, 0x0C, 0xE0, 0xC7, 0x75, 0x08, 0xF9, 0x08, 0x77, 0x30,
  0x3F, 0xB0, 0x37, 0x72, 0x0D, 0xFB, 0x0D, 0x01, 0x77, 0x09, 0xFD, 0x0A, 0x76, 0x04, 0xFF, 0x05,
  0x74, 0x01, 0x0E, 0xFF, 0x0E, 0x01, 0x73, 0x0A, 0xFF, 0xA0, 0xB7, 0x20, 0x5F, 0xFC, 0x07, 0x70,
  0x20, 0xEF, 0xFD, 0x02, 0x72, 0x0C, 0xFF, 0x0C, 0x74, 0x07, 0xFF, 0xA0, 0x77, 0x20, 0x2F, 0xFC,
  0x02, 0x71, 0x0B, 0xFF, 0xC0, 0xC7, 0x06, 0xFF, 0xE0, 0x75, 0x01, 0x0E, 0xFF, 0xF0, 0x24, 0x0B,
  0xFF, 0xF9, 0x0C, 0x30, 0x5F, 0xFF, 0xB8, 0x27, 0x01, 0xEF, 0xFF, 0xC0, 0x27, 0x4E, 0x77, 0x71,
  0xE7, 0x77, 0x1E, 0x77, 0x71, 0xE7, 0x77, 0x1E, 0x77, 0x71, 0xE7, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_park() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_park_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_pedal_bike 36x36, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_filled_36_maps_pedal_bike_data[] PROGMEM = {
  0x77, 0x4C, 0x0D, 0x07, 0x77, 0x77, 0x2E, 0x06, 0x77, 0x77, 0x1E, 0x0D, 0x77, 0x77, 0x50, 0xDA,
  0x04, 0x77, 0x60, 0x38, 0x03, 0x74, 0x08, 0xA0, 0x97, 0x76, 0x07, 0xF4, 0x02, 0xA0, 0xE7, 0x76,
  0x07, 0xF5, 0x0C, 0xA0, 0x57, 0x75, 0x82, 0x37, 0x7D, 0xA0, 0xB0, 0x75, 0x07, 0xA0, 0xB7, 0x77,
  0x10, 0x7A, 0x0A, 0x60, 0x1B, 0x01, 0x75, 0x85, 0x4A, 0xDF, 0xDB, 0x52, 0x02, 0xFF, 0x98, 0x1E,
  0xB5, 0x60, 0x10, 0xBF, 0x82, 0xC2, 0x0C, 0xFF, 0xB0, 0xD0, 0x23, 0x01, 0x0D, 0xFA, 0x81, 0xE2,
  0x6F, 0xFC, 0x0E, 0x02, 0x20, 0xBB, 0x84, 0x83, 0x02, 0x7E, 0xA0, 0xC0, 0x1B, 0x02, 0x30, 0xCD,
  0x81, 0x83, 0x7B, 0x81, 0xC0, 0x4B, 0x03, 0x50, 0x30, 0xEA, 0x05, 0x0A, 0xA0, 0x72, 0x05, 0xA0,
  0xE0, 0x7A, 0x0E, 0x20, 0x3B, 0x05, 0x0A, 0xA0, 0x87, 0x08, 0xA0, 0xA0, 0x5A, 0x0D, 0x20, 0xAA,
  0x81, 0x70, 0xDA, 0x04, 0x20, 0x7A, 0x0B, 0x0D, 0xA0, 0x33, 0x07, 0xFF, 0xA8, 0x12, 0x08, 0xA0,
  0x92, 0x02, 0xA0, 0xDB, 0x40, 0x7F, 0xFA, 0x28, 0x22, 0xD7, 0x23, 0xB0, 0xDA, 0x03, 0x30, 0x7F,
  0xFA, 0x03, 0x70, 0x2A, 0x0D, 0x0A, 0xA0, 0x87, 0x08, 0xA0, 0xA6, 0x0A, 0xA0, 0x87, 0x07, 0xA0,
  0xA0, 0x5B, 0x03, 0x50, 0x30, 0xEA, 0x05, 0x60, 0x5B, 0x03, 0x50, 0x3B, 0x81, 0x40, 0xCB, 0x84,
  0x83, 0x02, 0x7E, 0xA0, 0xC7, 0x10, 0xCB, 0x83, 0x83, 0x03, 0x8B, 0x0B, 0x20, 0x20, 0xEF, 0xA0,
  0xE0, 0x27, 0x10, 0x20, 0xEF, 0xA0, 0xD0, 0x13, 0x02, 0x0C, 0xF0, 0xC0, 0x27, 0x30, 0x20, 0xCF,
  0x0B, 0x01, 0x68, 0x55, 0xBD, 0xFD, 0xB5, 0x77, 0x85, 0x5B, 0xDF, 0xDA, 0x44,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_pedal_bike() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 35, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_pedal_bike_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_person_pin_circle 36x36, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_filled_36_maps_person_pin_circle_data[] PROGMEM = {
  0x78, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x50, 0x60, 0xEF, 0x90, 0xE0, 0x67, 0x20, 0xAF, 0xD0, 0xA7,
  0x0B, 0xD8, 0x27, 0x11, 0x7D, 0x0B, 0x50, 0x8D, 0x07, 0x40, 0x7D, 0x08, 0x30, 0x2E, 0x01, 0x40,
  0x1E, 0x02, 0x20, 0xAE, 0x01, 0x40, 0x1E, 0x0A, 0x20, 0xEE, 0x07, 0x40, 0x7E, 0x81, 0xE0, 0x4F,
  0x98, 0x27, 0x11, 0x7F, 0x90, 0x40, 0x6F, 0xFE, 0x06, 0x07, 0xFF, 0xE0, 0x70, 0x5F, 0x98, 0x2D,
  0xBB, 0xDF, 0x90, 0x60, 0x3D, 0x81, 0xD6, 0x14, 0x81, 0x16, 0xDD, 0x04, 0x1C, 0x0A, 0x73, 0x0A,
  0xC8, 0x11, 0x0B, 0xB0, 0x17, 0x30, 0x1B, 0x0B, 0x20, 0x5B, 0x09, 0x73, 0x09, 0xB0, 0x53, 0x0E,
  0xB0, 0x97, 0x10, 0x9B, 0x0E, 0x40, 0x8C, 0x86, 0xD7, 0x21, 0x12, 0x7D, 0xC0, 0x84, 0x01, 0x0E,
  0xFF, 0x0E, 0x01, 0x50, 0x7F, 0xF0, 0x77, 0x0D, 0xFD, 0x0D, 0x71, 0x04, 0xFD, 0x04, 0x72, 0x0A,
  0xFB, 0x0A, 0x73, 0x01, 0x0E, 0xF9, 0x0E, 0x01, 0x74, 0x05, 0xF9, 0x05, 0x76, 0x09, 0xE0, 0x97,
  0x71, 0x0C, 0xC0, 0xC7, 0x72, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x73, 0x04, 0xA0, 0x47, 0x75, 0x00,
  0x67, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_person_pin_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_person_pin_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_person_pin 36x36, 4-bit Alpha,  RLE, 210 bytes.
static const unsigned char ic_filled_36_maps_person_pin_data[] PROGMEM = {
  0x72, 0x89, 0x02, 0x7B, 0xDE, 0xED, 0xB7, 0x27, 0x72, 0x04, 0x0C, 0xFB, 0x0C, 0x04, 0x76, 0x0A,
  0xFF, 0x0A, 0x73, 0x02, 0x0D, 0xD8, 0x4C, 0x51, 0x15, 0xCD, 0x0D, 0x02, 0x70, 0x10, 0xDD, 0x0A,
  0x60, 0xAD, 0x0D, 0x01, 0x60, 0xCD, 0x0E, 0x01, 0x60, 0x10, 0xED, 0x0C, 0x50, 0x7E, 0x0A, 0x71,
  0x0A, 0xE0, 0x73, 0x01, 0x0E, 0xE0, 0x87, 0x10, 0x8E, 0x0E, 0x01, 0x20, 0x7F, 0x0A, 0x71, 0x0A,
  0xF0, 0x72, 0x0C, 0xF0, 0xE0, 0x16, 0x01, 0x0E, 0xF8, 0x1C, 0x02, 0xFA, 0x0A, 0x60, 0xAF, 0xA0,
  0x20, 0x4F, 0xB8, 0x4C, 0x51, 0x15, 0xCF, 0xB0, 0x40, 0x6F, 0xFF, 0xD0, 0x60, 0x7F, 0xFF, 0xD0,
  0x70, 0x6F, 0xFF, 0xD0, 0x60, 0x5F, 0x98, 0x2D, 0x84, 0x22, 0x82, 0x24, 0x7C, 0xF9, 0x05, 0x01,
  0xE0, 0x90, 0x27, 0x30, 0x20, 0x9E, 0x81, 0x10, 0xDB, 0x0E, 0x04, 0x77, 0x04, 0x0E, 0xB0, 0xD2,
  0x07, 0xB0, 0x57, 0x72, 0x05, 0xB0, 0x72, 0x01, 0xB0, 0x17, 0x72, 0x01, 0xB0, 0x13, 0x07, 0xA0,
  0xB7, 0x72, 0x0B, 0xA0, 0x75, 0x0C, 0xA0, 0x97, 0x70, 0x9A, 0x0C, 0x60, 0x10, 0xDA, 0x0C, 0x02,
  0x73, 0x02, 0x0C, 0xA0, 0xD0, 0x17, 0x02, 0x0D, 0xA8, 0x1E, 0x93, 0x68, 0x13, 0x9E, 0xA0, 0xD0,
  0x27, 0x30, 0xAC, 0x84, 0xDB, 0x99, 0xBD, 0xC0, 0xA7, 0x60, 0x40, 0xCF, 0xB0, 0xC0, 0x47, 0x72,
  0x02, 0x09, 0xE0, 0x90, 0x27, 0x76, 0x07, 0xC0, 0x77, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x74, 0x00,
  0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_person_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_person_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_pest_control 36x36, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_filled_36_maps_pest_control_data[] PROGMEM = {
  0x71, 0x09, 0x01, 0x71, 0x01, 0x09, 0x77, 0x18, 0x2B, 0xFD, 0x16, 0x82, 0x1D, 0xFB, 0x76, 0x03,
  0xB8, 0x6D, 0x6B, 0xEE, 0xB6, 0xDB, 0x03, 0x76, 0x04, 0xFD, 0x04, 0x77, 0x10, 0x4F, 0xB0, 0x47,
  0x72, 0x05, 0xFB, 0x05, 0x77, 0x20, 0xBF, 0xB0, 0xB7, 0x72, 0x0E, 0xFB, 0x0E, 0x77, 0x20, 0xEF,
  0xB0, 0xE7, 0x38, 0x13, 0xC3, 0x20, 0x4F, 0xD0, 0x42, 0x81, 0x3C, 0x34, 0x0C, 0xA8, 0x19, 0x3E,
  0xFD, 0x81, 0xE3, 0x9A, 0x0C, 0x30, 0x30, 0xEF, 0xFF, 0xA0, 0x33, 0x01, 0x0A, 0xF9, 0x82, 0xB7,
  0x7B, 0xF9, 0x0A, 0x01, 0x60, 0x30, 0xDE, 0x07, 0x20, 0x7E, 0x0D, 0x03, 0x72, 0x0A, 0xE0, 0x72,
  0x07, 0xE0, 0xA5, 0x84, 0x37, 0x77, 0x7E, 0xE0, 0x72, 0x07, 0xE8, 0x5E, 0x77, 0x77, 0x37, 0xFC,
  0x07, 0x20, 0x7F, 0xC0, 0x07, 0xFC, 0x07, 0x20, 0x7F, 0xC8, 0x57, 0x37, 0x77, 0x7E, 0xE0, 0x72,
  0x07, 0xE8, 0x4E, 0x77, 0x77, 0x35, 0x0A, 0xE0, 0x72, 0x07, 0xE0, 0xA7, 0x20, 0x40, 0xDE, 0x07,
  0x20, 0x7E, 0x0D, 0x03, 0x60, 0x20, 0xAF, 0x98, 0x2B, 0x77, 0xBF, 0x90, 0xA0, 0x13, 0x03, 0xFF,
  0xFA, 0x0E, 0x03, 0x30, 0xCA, 0x81, 0x93, 0xDF, 0xD8, 0x1D, 0x39, 0xA0, 0xC4, 0x81, 0x3B, 0x32,
  0x03, 0xFD, 0x03, 0x28, 0x13, 0xC3, 0x73, 0x03, 0x0E, 0xF9, 0x0E, 0x03, 0x77, 0x30, 0x10, 0x9E,
  0x09, 0x01, 0x77, 0x68, 0x41, 0x46, 0x64, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_pest_control() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_pest_control_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_pest_control_rodent 36x36, 4-bit Alpha,  RLE, 196 bytes.
static const unsigned char ic_filled_36_maps_pest_control_rodent_data[] PROGMEM = {
  0x71, 0x83, 0x57, 0x76, 0x37, 0x77, 0x30, 0x5D, 0x0A, 0x77, 0x72, 0x05, 0xE0, 0x77, 0x77, 0x28,
  0x25, 0x77, 0xAA, 0x0D, 0x77, 0x75, 0x02, 0xA0, 0xE7, 0x75, 0x81, 0x5A, 0xDF, 0x0B, 0x77, 0x30,
  0x20, 0xCF, 0xB0, 0x37, 0x72, 0x02, 0x0E, 0xF9, 0x81, 0xEB, 0x37, 0x73, 0x0C, 0xB0, 0x80, 0x37,
  0x77, 0x20, 0x5B, 0x03, 0x77, 0x74, 0x0A, 0xA0, 0x87, 0x77, 0x50, 0xDA, 0x03, 0x68, 0x54, 0xAD,
  0xFD, 0xA5, 0x76, 0xB5, 0x01, 0x0B, 0xD8, 0x5D, 0x30, 0x25, 0x74, 0x71, 0x0E, 0xA0, 0x23, 0x01,
  0x0D, 0xD8, 0x2E, 0x21, 0xAC, 0x0E, 0x05, 0x60, 0xAA, 0x08, 0x30, 0xBE, 0x81, 0x60, 0xCF, 0x05,
  0x50, 0x5B, 0x81, 0x40, 0x4E, 0x81, 0xE0, 0x7F, 0x90, 0xE6, 0x0C, 0xB0, 0x80, 0xBE, 0x81, 0xA0,
  0xCF, 0xA0, 0x55, 0x02, 0x0E, 0xFB, 0x81, 0x80, 0xEF, 0xA0, 0x76, 0x02, 0x0C, 0xFA, 0x81, 0x80,
  0xEF, 0xA0, 0x67, 0x10, 0x50, 0xAF, 0x81, 0xB0, 0xAF, 0xA0, 0xD0, 0x27, 0x20, 0xEF, 0x01, 0x03,
  0xFB, 0x0E, 0x04, 0x71, 0x0C, 0xF8, 0x1A, 0x0A, 0xE0, 0x09, 0xB0, 0x57, 0x07, 0xF9, 0x0B, 0xE0,
  0x92, 0x09, 0xB0, 0x46, 0x01, 0x0E, 0xFF, 0x09, 0x20, 0x9B, 0x0D, 0x70, 0x6F, 0xF9, 0x00, 0x9C,
  0x0E, 0x71, 0x07, 0xFF, 0xE0, 0xB7, 0x20, 0x40, 0xCF, 0xFB, 0x0E, 0x02, 0x74, 0x02, 0x05, 0x80,
  0x92, 0x70, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_pest_control_rodent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_pest_control_rodent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_pin_drop 36x36, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_filled_36_maps_pin_drop_data[] PROGMEM = {
  0x78, 0x64, 0x9D, 0xEE, 0xD9, 0x47, 0x50, 0x20, 0xBF, 0x90, 0xB0, 0x27, 0x20, 0x30, 0xEF, 0xB0,
  0xE0, 0x37, 0x02, 0x0E, 0xFD, 0x0E, 0x02, 0x60, 0xBF, 0xF0, 0xB5, 0x04, 0xFF, 0xA0, 0x44, 0x09,
  0xE8, 0x27, 0x11, 0x7E, 0x09, 0x40, 0xDD, 0x07, 0x40, 0x7D, 0x0D, 0x40, 0xED, 0x01, 0x40, 0x1D,
  0x0E, 0x40, 0xED, 0x01, 0x40, 0x1D, 0x0E, 0x40, 0xCD, 0x07, 0x40, 0x7D, 0x0D, 0x40, 0x9E, 0x82,
  0x71, 0x17, 0xE0, 0x94, 0x04, 0xFF, 0xA0, 0x45, 0x0E, 0xFF, 0x0E, 0x60, 0x8F, 0xF0, 0x86, 0x01,
  0x0E, 0xFD, 0x0E, 0x01, 0x70, 0x7F, 0xD0, 0x77, 0x20, 0xDF, 0xB0, 0xD7, 0x30, 0x4F, 0xB0, 0x47,
  0x40, 0xAF, 0x90, 0xA7, 0x50, 0x10, 0xDE, 0x0D, 0x01, 0x76, 0x04, 0xE0, 0x47, 0x71, 0x07, 0xC0,
  0x77, 0x73, 0x0A, 0xA0, 0xA7, 0x75, 0x00, 0xC7, 0x76, 0x00, 0x17, 0x77, 0x74, 0x07, 0xFF, 0xE0,
  0x07, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_pin_drop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_pin_drop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_place 36x36, 4-bit Alpha,  RLE, 144 bytes.
static const unsigned char ic_filled_36_maps_place_data[] PROGMEM = {
  0x78, 0x65, 0xAD, 0xEE, 0xDA, 0x57, 0x50, 0x60, 0xEF, 0x90, 0xE0, 0x67, 0x20, 0xAF, 0xD0, 0xA7,
  0x0B, 0xFF, 0x0B, 0x50, 0x9F, 0xFA, 0x09, 0x30, 0x2F, 0xFC, 0x02, 0x20, 0xAF, 0x90, 0x0D, 0xF9,
  0x0A, 0x2F, 0x0B, 0x01, 0x20, 0x10, 0xBF, 0x10, 0x4E, 0x0D, 0x60, 0xDE, 0x04, 0x06, 0xE0, 0x76,
  0x07, 0xE0, 0x60, 0x7E, 0x04, 0x60, 0x4E, 0x07, 0x05, 0xE0, 0x76, 0x07, 0xE0, 0x60, 0x3E, 0x0D,
  0x60, 0xDE, 0x04, 0x1F, 0x0B, 0x01, 0x20, 0x10, 0xBF, 0x81, 0x10, 0xBF, 0x90, 0x0D, 0xF9, 0x0B,
  0x20, 0x5F, 0xFC, 0x05, 0x30, 0xEF, 0xFA, 0x0E, 0x40, 0x8F, 0xFA, 0x08, 0x40, 0x10, 0xEF, 0xF0,
  0xE0, 0x15, 0x07, 0xFF, 0x07, 0x70, 0xDF, 0xD0, 0xD7, 0x10, 0x4F, 0xD0, 0x47, 0x20, 0xAF, 0xB0,
  0xA7, 0x30, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x40, 0x5F, 0x90, 0x57, 0x60, 0x9E, 0x09, 0x77, 0x10,
  0xCC, 0x0C, 0x77, 0x20, 0x20, 0xEA, 0x0E, 0x02, 0x77, 0x30, 0x4A, 0x04, 0x77, 0x50, 0x06, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_place() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_place_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_plumbing 36x36, 4-bit Alpha,  RLE, 192 bytes.
static const unsigned char ic_filled_36_maps_plumbing_data[] PROGMEM = {
  0x77, 0x38, 0x16, 0x97, 0x77, 0x71, 0x0B, 0xB0, 0xD0, 0x27, 0x75, 0x0B, 0xD0, 0xD0, 0x27, 0x73,
  0x0B, 0xF0, 0xD0, 0x27, 0x71, 0x0B, 0xFA, 0x0D, 0x01, 0x71, 0x84, 0x18, 0x82, 0x07, 0xD0, 0xBD,
  0x0A, 0x71, 0x0C, 0xA8, 0x2E, 0x30, 0xAB, 0x81, 0x80, 0x5D, 0x70, 0x2C, 0x84, 0xE3, 0x0A, 0xF8,
  0x30, 0x5C, 0x02, 0x70, 0xDC, 0x84, 0xE3, 0x06, 0x02, 0x30, 0x5B, 0x71, 0x03, 0x0E, 0xC8, 0x4E,
  0x30, 0x4F, 0x63, 0x81, 0x5F, 0xB7, 0x20, 0x30, 0xEC, 0x0E, 0x07, 0xB0, 0x63, 0x05, 0x02, 0x78,
  0x3B, 0xA0, 0x3E, 0xFA, 0x06, 0x73, 0x0B, 0xA8, 0x2A, 0x03, 0xEF, 0xA0, 0x67, 0x10, 0xBC, 0x82,
  0xA0, 0x3E, 0xFA, 0x01, 0x60, 0xBD, 0x81, 0x80, 0x5F, 0xB0, 0x15, 0x04, 0xD8, 0x18, 0x05, 0xF8,
  0x2E, 0x45, 0x26, 0x05, 0xC8, 0x18, 0x05, 0xF0, 0xE0, 0x37, 0x30, 0xCA, 0x81, 0x80, 0x5F, 0x0E,
  0x03, 0x75, 0x82, 0x32, 0x05, 0xF0, 0xE0, 0x37, 0x71, 0x05, 0xF0, 0xE0, 0x37, 0x71, 0x05, 0xF0,
  0xE0, 0x37, 0x71, 0x05, 0xF0, 0xE0, 0x37, 0x71, 0x05, 0xF0, 0xE0, 0x37, 0x71, 0x05, 0xF0, 0xE0,
  0x37, 0x71, 0x04, 0xF0, 0xE0, 0x37, 0x72, 0x0E, 0xE0, 0xE0, 0x37, 0x72, 0x02, 0xE0, 0xE0, 0x37,
  0x73, 0x01, 0xD0, 0xE0, 0x37, 0x75, 0x08, 0xB0, 0xE0, 0x37, 0x77, 0x82, 0x59, 0x81, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_plumbing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 30, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_plumbing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_railway_alert 36x36, 4-bit Alpha,  RLE, 299 bytes.
static const unsigned char ic_filled_36_maps_railway_alert_data[] PROGMEM = {
  0x77, 0x68, 0x42, 0x57, 0x75, 0x17, 0x77, 0x50, 0x70, 0xDE, 0x0C, 0x07, 0x77, 0x71, 0x03, 0x0D,
  0xFB, 0x0D, 0x03, 0x73, 0x82, 0x13, 0x56, 0x80, 0x27, 0xC8, 0x4E, 0xB8, 0x8A, 0xEC, 0x05, 0x68,
  0x13, 0x9D, 0xFD, 0x0E, 0x06, 0x60, 0x60, 0xEB, 0x03, 0x40, 0x9F, 0xF0, 0xD0, 0x12, 0x07, 0xA0,
  0x72, 0x02, 0x0D, 0xA0, 0xD3, 0x09, 0xFF, 0x0E, 0x01, 0x30, 0x7A, 0x07, 0x30, 0x20, 0xEA, 0x81,
  0x70, 0x2F, 0xF9, 0x05, 0x40, 0x7A, 0x07, 0x40, 0x7A, 0x81, 0xD0, 0x5F, 0xF0, 0xE5, 0x07, 0xA0,
  0x74, 0x01, 0xB0, 0x20, 0x7A, 0x0B, 0x80, 0x47, 0x0A, 0xA0, 0xA5, 0x07, 0xA0, 0x75, 0x0B, 0xA0,
  0x50, 0x7A, 0x07, 0x71, 0x06, 0xA0, 0x85, 0x07, 0xA0, 0x75, 0x09, 0xA0, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x08, 0x50, 0x7A, 0x07, 0x50, 0x9A, 0x00, 0x7A, 0x07, 0x71, 0x05, 0xA0, 0xA5, 0x82, 0x37,
  0x73, 0x50, 0xBA, 0x05, 0x07, 0xA0, 0x77, 0x10, 0x2A, 0x0E, 0x76, 0x01, 0xB0, 0x20, 0x7A, 0x07,
  0x72, 0x0D, 0xA0, 0x64, 0x07, 0xA0, 0x74, 0x07, 0xA8, 0x1D, 0x07, 0xA0, 0x77, 0x20, 0x6A, 0x0E,
  0x01, 0x30, 0x7A, 0x07, 0x30, 0x20, 0xEA, 0x81, 0x60, 0x7A, 0x07, 0x73, 0x0D, 0xA0, 0xD0, 0x12,
  0x07, 0xA0, 0x72, 0x02, 0x0D, 0xA0, 0xD2, 0x07, 0xFF, 0xB0, 0xE0, 0x66, 0x06, 0x0E, 0xB0, 0x32,
  0x07, 0xFF, 0xD8, 0x4E, 0xA7, 0x7A, 0xEC, 0x04, 0x30, 0x7F, 0xFF, 0xE0, 0xD0, 0x34, 0x07, 0xFF,
  0xFC, 0x0D, 0x06, 0x60, 0x7F, 0xB8, 0x1B, 0x8B, 0xFB, 0x0A, 0x02, 0x71, 0x07, 0xFA, 0x05, 0x30,
  0x5F, 0xA0, 0x77, 0x20, 0x7F, 0x90, 0xB5, 0x0B, 0xF9, 0x07, 0x72, 0x07, 0xF9, 0x08, 0x50, 0x8F,
  0x90, 0x77, 0x20, 0x7F, 0x90, 0xB5, 0x0B, 0xF9, 0x07, 0x72, 0x05, 0xFA, 0x05, 0x30, 0x5F, 0xA0,
  0x57, 0x30, 0xEF, 0xA8, 0x1B, 0x8B, 0xFA, 0x0E, 0x74, 0x05, 0xFF, 0xF0, 0x57, 0x50, 0x50, 0xEF,
  0xFB, 0x0E, 0x05, 0x77, 0x10, 0x40, 0xBF, 0xE0, 0xB0, 0x47, 0x73, 0x04, 0xFF, 0x90, 0x47, 0x72,
  0x03, 0xFF, 0xB0, 0x37, 0x71, 0x03, 0x80, 0x95, 0x70, 0x37, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_railway_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_railway_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_ramen_dining 36x36, 4-bit Alpha,  RLE, 176 bytes.
static const unsigned char ic_filled_36_maps_ramen_dining_data[] PROGMEM = {
  0x77, 0x71, 0x86, 0x13, 0x57, 0x9A, 0xCE, 0x77, 0x85, 0x24, 0x68, 0x9B, 0xDD, 0x82, 0xEC, 0xA8,
  0x58, 0x61, 0x35, 0x79, 0xAC, 0xED, 0x85, 0xDB, 0x97, 0x54, 0x27, 0x20, 0x7C, 0x86, 0xEE, 0xF8,
  0x65, 0x31, 0x77, 0x38, 0x57, 0xF3, 0x8F, 0x07, 0x97, 0x77, 0x18, 0x57, 0xF0, 0x7F, 0x07, 0x97,
  0x77, 0x10, 0x7F, 0xFF, 0xC4, 0x85, 0x7F, 0x7B, 0xF7, 0xB9, 0x80, 0x96, 0x74, 0x85, 0x7F, 0x07,
  0xF0, 0x79, 0x77, 0x71, 0x85, 0x7F, 0x07, 0xF0, 0x79, 0x77, 0x71, 0x85, 0x7F, 0x07, 0xF0, 0x79,
  0x77, 0x71, 0x85, 0x7F, 0x07, 0xF0, 0x79, 0x77, 0x71, 0x85, 0x7F, 0x07, 0xF0, 0x79, 0x77, 0x71,
  0x85, 0x7F, 0x07, 0xF0, 0x79, 0x77, 0x71, 0x85, 0x7F, 0x07, 0xF0, 0x79, 0x77, 0x40, 0xEF, 0xFF,
  0xF0, 0xE0, 0xDF, 0xFF, 0xF0, 0xD0, 0xBF, 0xFF, 0xF0, 0xB0, 0x7F, 0xFF, 0xF0, 0x70, 0x1F, 0xFF,
  0xF8, 0x11, 0x0A, 0xFF, 0xFD, 0x0A, 0x20, 0x20, 0xEF, 0xFF, 0xB0, 0xE0, 0x23, 0x06, 0xFF, 0xFB,
  0x06, 0x50, 0x9F, 0xFF, 0x90, 0x97, 0x09, 0xFF, 0xE0, 0x97, 0x20, 0x60, 0xEF, 0xFA, 0x0E, 0x06,
  0x74, 0x02, 0x0A, 0xFF, 0x0A, 0x02, 0x77, 0x02, 0xFD, 0x02, 0x77, 0x3F, 0xD7, 0x74, 0xFD, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_ramen_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_ramen_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_ramp_left 36x36, 4-bit Alpha,  RLE, 143 bytes.
static const unsigned char ic_filled_36_maps_ramp_left_data[] PROGMEM = {
  0x50, 0x01, 0x77, 0x82, 0x1D, 0xD1, 0x75, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x30, 0x10, 0xDC, 0x0D,
  0x01, 0x71, 0x01, 0x0D, 0xE0, 0xD0, 0x16, 0x01, 0x0D, 0xF9, 0x0D, 0x01, 0x50, 0xBA, 0x0E, 0x0B,
  0xA0, 0xB0, 0xEA, 0x0B, 0x58, 0x31, 0xDE, 0x47, 0xA8, 0x37, 0x4E, 0xD1, 0x68, 0x21, 0x30, 0x7A,
  0x82, 0x70, 0x31, 0x73, 0x07, 0xA0, 0x77, 0x60, 0x7A, 0x09, 0x76, 0x07, 0xA0, 0xB7, 0x60, 0x7A,
  0x0E, 0x76, 0x07, 0xB0, 0x57, 0x50, 0x7B, 0x0C, 0x75, 0x07, 0xC0, 0x67, 0x40, 0x7C, 0x0E, 0x02,
  0x73, 0x07, 0xD0, 0xD0, 0x17, 0x20, 0x7A, 0x0A, 0x0E, 0xA0, 0xD0, 0x17, 0x10, 0x7A, 0x07, 0x04,
  0xB0, 0xD0, 0x27, 0x07, 0xA8, 0x17, 0x05, 0xB0, 0xE0, 0x66, 0x07, 0xA0, 0x72, 0x04, 0x0E, 0xB0,
  0xB0, 0x14, 0x07, 0xA0, 0x73, 0x02, 0x0D, 0xA0, 0xC0, 0x14, 0x07, 0xA0, 0x75, 0x81, 0x8C, 0x15,
  0x07, 0xA0, 0x77, 0x60, 0x7A, 0x07, 0x76, 0x07, 0xA0, 0x77, 0x68, 0x23, 0x77, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_ramp_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 4, 28, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_ramp_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_ramp_right 36x36, 4-bit Alpha,  RLE, 142 bytes.
static const unsigned char ic_filled_36_maps_ramp_right_data[] PROGMEM = {
  0x73, 0x00, 0x17, 0x78, 0x21, 0xDD, 0x17, 0x50, 0x10, 0xDA, 0x0D, 0x01, 0x73, 0x01, 0x0D, 0xC0,
  0xD0, 0x17, 0x10, 0x10, 0xDE, 0x0D, 0x01, 0x60, 0x10, 0xDF, 0x90, 0xD0, 0x15, 0x0B, 0xA0, 0xE0,
  0xBA, 0x0B, 0xB0, 0xB5, 0x83, 0x1D, 0xE4, 0x7A, 0x83, 0x74, 0xFD, 0x16, 0x82, 0x13, 0x07, 0xA8,
  0x27, 0x04, 0x27, 0x30, 0x7A, 0x07, 0x76, 0x09, 0xA0, 0x77, 0x60, 0xBA, 0x07, 0x76, 0x0E, 0xA0,
  0x77, 0x50, 0x5B, 0x07, 0x75, 0x0C, 0xB0, 0x77, 0x40, 0x6C, 0x07, 0x73, 0x02, 0x0E, 0xC0, 0x77,
  0x20, 0x10, 0xDD, 0x07, 0x71, 0x01, 0x0D, 0xA0, 0xE0, 0xAA, 0x07, 0x70, 0x20, 0xDB, 0x04, 0x07,
  0xA0, 0x76, 0x06, 0x0E, 0xB8, 0x15, 0x07, 0xA0, 0x74, 0x01, 0x0B, 0xB0, 0xE0, 0x42, 0x07, 0xA0,
  0x74, 0x01, 0x0C, 0xA0, 0xD0, 0x23, 0x07, 0xA0, 0x75, 0x81, 0x1C, 0x85, 0x07, 0xA0, 0x77, 0x60,
  0x7A, 0x07, 0x76, 0x07, 0xA0, 0x77, 0x60, 0x7A, 0x07, 0x76, 0x82, 0x37, 0x73, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_ramp_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 4, 23, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_ramp_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_rate_review 36x36, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_filled_36_maps_rate_review_data[] PROGMEM = {
  0x10, 0x80, 0xDF, 0xFF, 0xB8, 0x2D, 0x80, 0x8F, 0xFF, 0xF0, 0x80, 0xDF, 0xFF, 0xF0, 0xDF, 0xFA,
  0x0D, 0x0E, 0xFF, 0xFE, 0x82, 0xB0, 0x2E, 0xFF, 0xFC, 0x0B, 0x30, 0x20, 0xEF, 0xFF, 0xA0, 0xB5,
  0x02, 0x0E, 0xFF, 0xF0, 0xB7, 0x0D, 0xFF, 0xE0, 0xB7, 0x0B, 0xFF, 0xE0, 0xB7, 0x0B, 0xFF, 0xE0,
  0xB7, 0x0B, 0xFF, 0xE0, 0xB7, 0x0B, 0xFF, 0xE0, 0xB7, 0x0B, 0xFF, 0xE0, 0xB7, 0x0B, 0xFF, 0xF7,
  0x0B, 0xFF, 0xF9, 0x60, 0xBA, 0x04, 0x71, 0xFD, 0x50, 0xBA, 0x04, 0x72, 0xFD, 0x40, 0xBA, 0x04,
  0x73, 0x80, 0x9F, 0x1F, 0x0D, 0xFF, 0xFF, 0x90, 0x8F, 0xFF, 0xE0, 0xD0, 0x81, 0xD0, 0x77, 0x77,
  0x3C, 0x07, 0x77, 0x74, 0xB0, 0x77, 0x77, 0x5A, 0x07, 0x77, 0x76, 0x90, 0x77, 0x77, 0x70, 0x77,
  0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_rate_review() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_rate_review_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_remove_road 36x36, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_filled_36_maps_remove_road_data[] PROGMEM = {
  0xB7, 0x07, 0xA0, 0x77, 0xB4, 0xB7, 0x07, 0xA0, 0x77, 0xB4, 0xB7, 0x07, 0xA0, 0x77, 0xB4, 0xB7,
  0x07, 0xA0, 0x77, 0xB4, 0xB7, 0x07, 0xA0, 0x77, 0xB4, 0xB7, 0x07, 0xA0, 0x77, 0xB4, 0xB7, 0x74,
  0xB4, 0xB7, 0x74, 0xB4, 0xB7, 0x74, 0xB4, 0xB7, 0x07, 0xA0, 0x77, 0xB4, 0xB7, 0x07, 0xA0, 0x77,
  0xB4, 0xB7, 0x07, 0xA0, 0x77, 0xB4, 0xB7, 0x07, 0xA0, 0x77, 0xB4, 0xB7, 0x07, 0xA0, 0x77, 0x0F,
  0x74, 0xB7, 0x07, 0xA0, 0x77, 0x7B, 0x77, 0x74, 0xB7, 0x72, 0x03, 0x50, 0x32, 0xB7, 0x71, 0x81,
  0x9F, 0x53, 0x81, 0x5F, 0x91, 0xB7, 0x07, 0xA0, 0x73, 0x07, 0xB8, 0x15, 0x05, 0xB0, 0x7B, 0x70,
  0x7A, 0x07, 0x30, 0x10, 0xCB, 0x09, 0xB0, 0xC0, 0x1B, 0x70, 0x7A, 0x07, 0x40, 0x10, 0xCD, 0x0C,
  0x01, 0x1B, 0x70, 0x7A, 0x07, 0x50, 0x10, 0xDB, 0x0D, 0x01, 0x2B, 0x70, 0x7A, 0x07, 0x50, 0x5D,
  0x05, 0x2B, 0x70, 0x7A, 0x07, 0x40, 0x5F, 0x05, 0x77, 0x40, 0x5B, 0x81, 0xC2, 0xCB, 0x05, 0x77,
  0x38, 0x91, 0x3E, 0xFC, 0x10, 0x1C, 0xFE, 0x37, 0x74, 0x81, 0x3B, 0x13, 0x81, 0x1B, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_remove_road() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 6, 33, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_remove_road_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_restaurant_menu 36x36, 4-bit Alpha,  RLE, 239 bytes.
static const unsigned char ic_filled_36_maps_restaurant_menu_data[] PROGMEM = {
  0x77, 0x71, 0x82, 0x13, 0x31, 0x40, 0x50, 0x27, 0x73, 0x05, 0x0C, 0xC0, 0x92, 0x82, 0x1E, 0xE2,
  0x77, 0x01, 0x0B, 0xF8, 0x1B, 0x08, 0xA0, 0xE0, 0x27, 0x50, 0x10, 0xDF, 0xA0, 0x50, 0xCB, 0x0E,
  0x03, 0x74, 0x0A, 0xFB, 0x0A, 0x0D, 0xC0, 0xE0, 0x37, 0x20, 0x5F, 0xC0, 0xB0, 0xCD, 0x0E, 0x03,
  0x71, 0x0B, 0xFC, 0x0A, 0x08, 0xE0, 0xE0, 0x36, 0x01, 0xFD, 0x81, 0x71, 0xEE, 0x0E, 0x03, 0x50,
  0x3F, 0xD8, 0x11, 0x05, 0xF0, 0xE0, 0x34, 0x03, 0xFC, 0x08, 0x30, 0x5F, 0x0E, 0x03, 0x4F, 0xB0,
  0xC5, 0x05, 0xF0, 0xE0, 0x22, 0x03, 0x0E, 0xF9, 0x0B, 0x01, 0x60, 0x5E, 0x0A, 0x20, 0x30, 0xEF,
  0x0E, 0x08, 0x72, 0x05, 0xC0, 0xA2, 0x03, 0x0E, 0xA8, 0x5E, 0x69, 0xB9, 0x61, 0x74, 0x05, 0xA0,
  0xA2, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x74, 0x05, 0x09, 0x20, 0x30, 0xEB, 0x05, 0x77, 0x71, 0x03,
  0x0E, 0xC0, 0xE0, 0x27, 0x76, 0x03, 0x0E, 0xA0, 0x0E, 0xA0, 0xE0, 0x27, 0x74, 0x03, 0x0E, 0xA8,
  0x2E, 0x22, 0xEA, 0x0E, 0x02, 0x77, 0x20, 0x30, 0xEA, 0x0E, 0x02, 0x20, 0x20, 0xEA, 0x0E, 0x02,
  0x77, 0x03, 0x0E, 0xA0, 0xE0, 0x24, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x50, 0x30, 0xEA, 0x0E, 0x02,
  0x60, 0x20, 0xEA, 0x0E, 0x02, 0x73, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x10, 0x20, 0xEA, 0x0E, 0x02,
  0x71, 0x03, 0x0E, 0xA0, 0xE0, 0x27, 0x30, 0x20, 0xEA, 0x0E, 0x02, 0x60, 0x30, 0xEA, 0x0E, 0x02,
  0x75, 0x02, 0x0E, 0xA0, 0xE0, 0x24, 0x02, 0x0E, 0xA0, 0xE0, 0x27, 0x70, 0x20, 0xEA, 0x0E, 0x02,
  0x48, 0x2B, 0xFE, 0x27, 0x72, 0x82, 0x2E, 0xFB, 0x60, 0x90, 0x27, 0x74, 0x02, 0x0A, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_restaurant_menu() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_restaurant_menu_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_restaurant 36x36, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_filled_36_maps_restaurant_data[] PROGMEM = {
  0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x18, 0x35, 0xBD, 0x77, 0xA0, 0x72, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x76, 0x03, 0x0D, 0xB0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0,
  0x75, 0x04, 0xD0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0x02, 0x0E, 0xD0, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0x09, 0xE0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72,
  0x07, 0xA0, 0x74, 0x0E, 0xE0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0xF0, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0xF0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07,
  0xA0, 0x74, 0xF0, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x74, 0xF0, 0x07, 0xA8, 0x2B,
  0x77, 0xBA, 0x82, 0xB7, 0x7B, 0xA0, 0x74, 0xF0, 0x70, 0x6F, 0xF0, 0x64, 0xF0, 0x70, 0x2F, 0xF0,
  0x24, 0xF8, 0x17, 0x0A, 0xFD, 0x0A, 0x5F, 0x82, 0x70, 0x1D, 0xFB, 0x0D, 0x01, 0x5F, 0x07, 0x20,
  0x10, 0x9F, 0x90, 0x90, 0x16, 0xF0, 0x74, 0x81, 0x15, 0xEA, 0x81, 0xE5, 0x17, 0x1F, 0x07, 0x60,
  0xDA, 0x0D, 0x73, 0xF0, 0x76, 0x0D, 0xA0, 0xD7, 0x60, 0x3B, 0x07, 0x60, 0xDA, 0x0D, 0x76, 0x03,
  0xB0, 0x76, 0x0D, 0xA0, 0xD7, 0x60, 0x3B, 0x07, 0x60, 0xDA, 0x0D, 0x76, 0x03, 0xB0, 0x76, 0x0D,
  0xA0, 0xD7, 0x60, 0x3B, 0x07, 0x60, 0xDA, 0x0D, 0x76, 0x03, 0xB0, 0x76, 0x0D, 0xA0, 0xD7, 0x60,
  0x3B, 0x07, 0x60, 0xDA, 0x0D, 0x76, 0x03, 0xB0, 0x76, 0x0D, 0xA0, 0xD7, 0x60, 0x3B, 0x07, 0x60,
  0xDA, 0x0D, 0x76, 0x03, 0xB0, 0x76, 0x0D, 0xA0, 0xD7, 0x60, 0x3B, 0x07, 0x60, 0xDA, 0x0D, 0x76,
  0x03, 0xB0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_restaurant() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_restaurant_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_roundabout_left 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_filled_36_maps_roundabout_left_data[] PROGMEM = {
  0x77, 0x48, 0x41, 0x57, 0x75, 0x17, 0x77, 0x10, 0x40, 0xBE, 0x0B, 0x03, 0x77, 0x50, 0x9F, 0xB0,
  0x87, 0x10, 0x01, 0x70, 0xAC, 0x82, 0xC9, 0x8B, 0xC0, 0xA6, 0x82, 0x1D, 0xD1, 0x50, 0x6B, 0x0A,
  0x01, 0x40, 0x10, 0xAB, 0x06, 0x40, 0x10, 0xDA, 0x0D, 0x40, 0x10, 0xEA, 0x08, 0x71, 0x08, 0xA0,
  0xE0, 0x12, 0x01, 0x0D, 0xA0, 0xE0, 0x44, 0x07, 0xA0, 0xC7, 0x30, 0xCA, 0x82, 0x60, 0x1D, 0xA0,
  0xE0, 0x45, 0x0B, 0xA0, 0x57, 0x30, 0x5A, 0x81, 0xB1, 0xDF, 0xE0, 0x17, 0x30, 0x1A, 0x0D, 0x0B,
  0xFE, 0x0A, 0x75, 0xB0, 0x10, 0xDF, 0xB0, 0xE0, 0x97, 0x50, 0x1A, 0x82, 0xE0, 0x1D, 0xB0, 0x47,
  0x75, 0x05, 0xA0, 0xB2, 0x01, 0x0D, 0xB0, 0x47, 0x74, 0x0C, 0xA0, 0x73, 0x01, 0x0D, 0xA0, 0xD7,
  0x73, 0x08, 0xA0, 0xE0, 0x14, 0x82, 0x1D, 0xD2, 0x77, 0x10, 0x10, 0xAB, 0x06, 0x60, 0x01, 0x77,
  0x06, 0x0B, 0xC0, 0xA7, 0x77, 0x10, 0xBD, 0x09, 0x77, 0x71, 0x05, 0xC0, 0xB0, 0x47, 0x77, 0x20,
  0x7A, 0x0A, 0x01, 0x77, 0x74, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0,
  0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x75,
  0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x75, 0x82, 0x37, 0x73, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_roundabout_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_roundabout_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_roundabout_right 36x36, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_filled_36_maps_roundabout_right_data[] PROGMEM = {
  0x68, 0x41, 0x57, 0x75, 0x17, 0x77, 0x10, 0x30, 0xBE, 0x0B, 0x04, 0x77, 0x50, 0x8F, 0xB0, 0x97,
  0x73, 0x0A, 0xC8, 0x2B, 0x89, 0xCC, 0x0A, 0x70, 0x01, 0x60, 0x6B, 0x0A, 0x01, 0x40, 0x10, 0xAB,
  0x06, 0x58, 0x21, 0xDD, 0x14, 0x01, 0x0E, 0xA0, 0x87, 0x10, 0x8A, 0x0E, 0x01, 0x40, 0xDA, 0x0D,
  0x01, 0x30, 0x6A, 0x0C, 0x73, 0x0C, 0xA0, 0x74, 0x04, 0x0E, 0xA0, 0xD0, 0x12, 0x0B, 0xA0, 0x57,
  0x30, 0x5A, 0x0B, 0x50, 0x40, 0xEA, 0x82, 0xD1, 0x0D, 0xA0, 0x17, 0x30, 0x1F, 0xE0, 0xD0, 0x1B,
  0x75, 0x0A, 0xFE, 0x0B, 0x0E, 0xA0, 0x17, 0x50, 0x90, 0xEF, 0xB8, 0x1D, 0x1B, 0xA0, 0x57, 0x75,
  0x04, 0xB8, 0x2D, 0x10, 0x7A, 0x0C, 0x77, 0x40, 0x4B, 0x0D, 0x01, 0x20, 0x10, 0xEA, 0x08, 0x77,
  0x30, 0xDA, 0x0D, 0x01, 0x40, 0x6B, 0x0A, 0x01, 0x77, 0x18, 0x22, 0xDD, 0x16, 0x0A, 0xC0, 0xB0,
  0x67, 0x70, 0x01, 0x71, 0x09, 0xD0, 0xB7, 0x77, 0x30, 0x40, 0xBC, 0x05, 0x77, 0x74, 0x01, 0x0A,
  0xA0, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77,
  0x75, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x50, 0x7A,
  0x07, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x58, 0x23, 0x77, 0x37, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_roundabout_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_roundabout_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_route 36x36, 4-bit Alpha,  RLE, 252 bytes.
static const unsigned char ic_filled_36_maps_route_data[] PROGMEM = {
  0x38, 0x22, 0x66, 0x27, 0x28, 0x32, 0x57, 0x52, 0x72, 0x0A, 0xC0, 0xA6, 0x01, 0x0A, 0xD0, 0xA0,
  0x16, 0x09, 0xE0, 0x94, 0x01, 0x0D, 0xF0, 0xD0, 0x14, 0x02, 0xF9, 0x02, 0x30, 0xAB, 0x81, 0xB8,
  0xBB, 0x0A, 0x40, 0x6F, 0x90, 0x62, 0x02, 0xB0, 0x53, 0x05, 0xB0, 0x23, 0x06, 0xF9, 0x06, 0x20,
  0x6A, 0x0B, 0x50, 0xBA, 0x06, 0x30, 0x3F, 0x90, 0x32, 0x07, 0xA0, 0x85, 0x08, 0xA0, 0x74, 0x0A,
  0xE0, 0xA3, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x0A, 0xC0, 0xA4, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x76, 0x08, 0xA0, 0x85, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07,
  0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0,
  0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76,
  0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x07,
  0xA0, 0x76, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x75, 0x08, 0xA0, 0x86, 0x07, 0xA0, 0x75, 0x07, 0xA0,
  0x74, 0x0A, 0xC0, 0xA5, 0x07, 0xA0, 0x75, 0x07, 0xA0, 0x73, 0x0A, 0xE0, 0xA4, 0x07, 0xA0, 0x85,
  0x08, 0xA0, 0x72, 0x03, 0xF9, 0x03, 0x30, 0x6A, 0x0B, 0x50, 0xBA, 0x06, 0x20, 0x6F, 0x90, 0x63,
  0x02, 0xB0, 0x53, 0x05, 0xB0, 0x22, 0x06, 0xF9, 0x06, 0x40, 0xAB, 0x81, 0xB8, 0xBB, 0x0A, 0x30,
  0x2F, 0x90, 0x24, 0x01, 0x0D, 0xF0, 0xD0, 0x14, 0x09, 0xE0, 0x96, 0x01, 0x0A, 0xD0, 0xA0, 0x16,
  0x0A, 0xC0, 0xA7, 0x28, 0x32, 0x57, 0x52, 0x72, 0x82, 0x26, 0x62, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_route() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_route_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_run_circle 36x36, 4-bit Alpha,  RLE, 212 bytes.
static const unsigned char ic_filled_36_maps_run_circle_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xFE, 0x81, 0x41, 0xAF, 0x90, 0x54, 0x0D, 0xFD, 0x0C, 0x20, 0x4F, 0x90, 0xD3,
  0x07, 0xFF, 0x81, 0x41, 0xAF, 0xA0, 0x72, 0x0E, 0xFD, 0x81, 0xEA, 0xBF, 0xC8, 0x1E, 0x03, 0xFC,
  0x0B, 0x05, 0x30, 0xAF, 0xC0, 0x30, 0x8F, 0xA0, 0xA0, 0x12, 0x01, 0x20, 0x10, 0xEF, 0xB0, 0x80,
  0xBF, 0xA8, 0x90, 0x70, 0xAF, 0x20, 0x30, 0x3E, 0xFA, 0x0B, 0x0D, 0xFA, 0x82, 0x70, 0xFE, 0x20,
  0x80, 0xA2, 0x06, 0xF9, 0x0D, 0x0E, 0xFA, 0x82, 0x70, 0xFB, 0x28, 0x3B, 0xFD, 0x61, 0xF9, 0x00,
  0xEF, 0xD0, 0x82, 0x0E, 0xFD, 0x0E, 0x0D, 0xFD, 0x05, 0x20, 0x6F, 0xD0, 0xD0, 0xBF, 0xD8, 0x32,
  0x47, 0x07, 0xFC, 0x0B, 0x08, 0xF8, 0x7A, 0x48, 0xBD, 0x07, 0xF4, 0x1F, 0xC0, 0x80, 0x3F, 0x09,
  0x02, 0x48, 0x1A, 0xF7, 0x1F, 0xC8, 0x13, 0x0E, 0xF9, 0x85, 0xEB, 0x85, 0xDF, 0x71, 0xFB, 0x0E,
  0x20, 0x7F, 0xF0, 0x71, 0xFB, 0x07, 0x30, 0xDF, 0xE0, 0x71, 0xFA, 0x0D, 0x40, 0x5F, 0xE0, 0x71,
  0xFA, 0x05, 0x50, 0x8F, 0xFF, 0x90, 0x87, 0x0A, 0xFF, 0xE0, 0xA7, 0x20, 0x7F, 0xFC, 0x07, 0x74,
  0x05, 0x0D, 0xFF, 0x0D, 0x05, 0x77, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x48, 0x90, 0x38, 0xBD,
  0xEE, 0xDB, 0x83, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_run_circle() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_run_circle_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_safety_check 36x36, 4-bit Alpha,  RLE, 181 bytes.
static const unsigned char ic_filled_36_maps_safety_check_data[] PROGMEM = {
  0x72, 0x84, 0x16, 0xCC, 0x61, 0x77, 0x20, 0x40, 0xAE, 0x0A, 0x04, 0x74, 0x81, 0x28, 0xEF, 0xB8,
  0x1E, 0x82, 0x58, 0x11, 0x6C, 0xFF, 0xA8, 0x3C, 0x61, 0x0A, 0xFF, 0xF9, 0x0A, 0x80, 0xE5, 0xF8,
  0x4E, 0xA8, 0x8A, 0xEF, 0xFA, 0x0E, 0x06, 0x60, 0x60, 0xEF, 0xE0, 0xC0, 0x17, 0x10, 0x10, 0xCF,
  0xC0, 0xE0, 0x14, 0x00, 0x54, 0x01, 0x0E, 0xFB, 0x06, 0x50, 0x0B, 0x50, 0x6F, 0xA0, 0xE6, 0x00,
  0xB6, 0x0E, 0xF9, 0x0A, 0x60, 0x0B, 0x60, 0xAC, 0x0E, 0xB0, 0x86, 0x0B, 0x0C, 0x60, 0x8B, 0x0E,
  0x0D, 0xB0, 0x86, 0x81, 0x7F, 0x85, 0x08, 0xB0, 0xD0, 0xBB, 0x0A, 0x78, 0x18, 0xF8, 0x40, 0xAB,
  0x0B, 0x07, 0xB0, 0xE7, 0x18, 0x18, 0xF4, 0x30, 0xEB, 0x07, 0x03, 0xC0, 0x67, 0x10, 0x43, 0x06,
  0xC8, 0x13, 0x0E, 0xB0, 0xE0, 0x17, 0x30, 0x10, 0xEB, 0x0E, 0x20, 0x8C, 0x0C, 0x01, 0x71, 0x01,
  0x0C, 0xC0, 0x82, 0x01, 0xD0, 0xE0, 0x66, 0x06, 0x0E, 0xD0, 0x13, 0x07, 0xE8, 0x4E, 0xA8, 0x8A,
  0xEE, 0x07, 0x50, 0xDF, 0xFA, 0x0D, 0x60, 0x30, 0xEF, 0xF0, 0xE0, 0x37, 0x04, 0xFF, 0x04, 0x72,
  0x05, 0x0E, 0xFB, 0x0E, 0x05, 0x74, 0x03, 0x0D, 0xF9, 0x0D, 0x03, 0x77, 0x08, 0xE0, 0x87, 0x73,
  0x84, 0x17, 0xCC, 0x71, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_safety_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_safety_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_sailing 36x36, 4-bit Alpha,  RLE, 243 bytes.
static const unsigned char ic_filled_36_maps_sailing_data[] PROGMEM = {
  0x77, 0x10, 0x10, 0x57, 0x77, 0x71, 0x81, 0xEE, 0x57, 0x77, 0x30, 0x42, 0x0A, 0xA0, 0x97, 0x77,
  0x10, 0x80, 0x72, 0x07, 0xB0, 0xC0, 0x17, 0x75, 0x81, 0x3F, 0x72, 0x04, 0xC0, 0xC0, 0x17, 0x74,
  0x81, 0xDF, 0x72, 0x02, 0xD0, 0xC7, 0x73, 0x09, 0xA0, 0x73, 0xE0, 0xA7, 0x71, 0x05, 0xB0, 0x73,
  0x0D, 0xE0, 0x57, 0x60, 0x10, 0xEB, 0x07, 0x30, 0xCE, 0x0E, 0x02, 0x75, 0x0B, 0xC0, 0x73, 0x0B,
  0xF0, 0xB7, 0x40, 0x6D, 0x07, 0x30, 0xBF, 0x90, 0x47, 0x20, 0x20, 0xED, 0x07, 0x30, 0xCF, 0x90,
  0xB7, 0x20, 0xCE, 0x07, 0x30, 0xDF, 0xA0, 0x27, 0x07, 0xF0, 0x73, 0x0E, 0xFA, 0x08, 0x60, 0x3F,
  0x90, 0x72, 0x01, 0xFB, 0x0C, 0x60, 0xDF, 0x90, 0x72, 0x03, 0xFC, 0x01, 0x40, 0x9F, 0xA0, 0x72,
  0x07, 0xFC, 0x03, 0x30, 0x4F, 0xB0, 0x72, 0x0A, 0xFC, 0x06, 0x20, 0x10, 0xDF, 0xB0, 0x72, 0x0E,
  0xFC, 0x07, 0x20, 0x18, 0x07, 0x30, 0x12, 0x80, 0x90, 0x30, 0x17, 0x77, 0x73, 0x80, 0xB2, 0x70,
  0xAF, 0xFF, 0xF0, 0xA0, 0x5F, 0xFF, 0xF8, 0x15, 0x0C, 0xFF, 0xFD, 0x0C, 0x20, 0x20, 0xEA, 0x00,
  0xAF, 0x00, 0xAF, 0x00, 0xAA, 0x0E, 0x02, 0x38, 0x13, 0xD7, 0x20, 0x8D, 0x08, 0x20, 0x8D, 0x08,
  0x28, 0x17, 0xD3, 0x73, 0x83, 0x15, 0x75, 0x14, 0x83, 0x15, 0x75, 0x18, 0x0C, 0x60, 0x82, 0x2A,
  0xA2, 0x58, 0x23, 0xBA, 0x25, 0x82, 0x3B, 0xA2, 0x48, 0x27, 0x79, 0xCC, 0x83, 0xDA, 0x9A, 0xDC,
  0x83, 0xDA, 0x9A, 0xDC, 0x82, 0xC9, 0x77, 0xFF, 0xFF, 0xE8, 0x2E, 0x88, 0xED, 0x82, 0xE8, 0x8E,
  0xD8, 0x2E, 0x88, 0xEC, 0x82, 0x77, 0x53, 0x48, 0x33, 0x57, 0x53, 0x48, 0x33, 0x57, 0x53, 0x48,
  0x23, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_sailing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_sailing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_satellite 36x36, 4-bit Alpha,  RLE, 185 bytes.
static const unsigned char ic_filled_36_maps_satellite_data[] PROGMEM = {
  0x20, 0x48, 0x0A, 0x27, 0x04, 0x30, 0x9F, 0xFF, 0xB8, 0x19, 0x04, 0xFF, 0xFD, 0x04, 0x07, 0xA8,
  0x3B, 0x77, 0x78, 0xB0, 0xF7, 0xFE, 0x00, 0x7A, 0x07, 0x30, 0x3A, 0x0D, 0x20, 0x1F, 0xE0, 0x07,
  0xA0, 0x73, 0x08, 0xA0, 0xA2, 0x03, 0xFE, 0x00, 0x7A, 0x07, 0x20, 0x3B, 0x05, 0x20, 0x7F, 0xE0,
  0x07, 0xA8, 0x18, 0x38, 0xB0, 0xC3, 0x0C, 0xFE, 0x00, 0x7F, 0x0E, 0x01, 0x20, 0x5F, 0xF0, 0x07,
  0xE0, 0xC0, 0x13, 0x0D, 0xFF, 0x00, 0x7B, 0x81, 0xDA, 0x54, 0x0B, 0xFF, 0x90, 0x07, 0xA0, 0x76,
  0x0B, 0xFF, 0xA0, 0x07, 0xA0, 0x74, 0x05, 0x0D, 0xFF, 0xB0, 0x07, 0xA8, 0x37, 0x13, 0x7C, 0xFF,
  0xD0, 0x07, 0xFF, 0xA0, 0x60, 0xCF, 0x90, 0x07, 0xFF, 0x98, 0x29, 0x02, 0xEF, 0x00, 0x7F, 0x09,
  0x0E, 0xD0, 0xC3, 0x05, 0xF0, 0x07, 0xE8, 0x1B, 0x03, 0xC0, 0xE0, 0x14, 0x09, 0xE0, 0x07, 0xD0,
  0xD0, 0x12, 0x05, 0xB0, 0x46, 0x0C, 0xD0, 0x07, 0xD0, 0x34, 0x81, 0x8F, 0x77, 0x02, 0x0E, 0xC0,
  0x07, 0xC0, 0x66, 0x07, 0x72, 0x05, 0xC0, 0x07, 0xB0, 0xA7, 0x74, 0x09, 0xB0, 0x07, 0xA0, 0xD7,
  0x76, 0x0C, 0xA0, 0x07, 0xFF, 0xFD, 0x00, 0x7F, 0xFF, 0xD0, 0x70, 0x4F, 0xFF, 0xD8, 0x14, 0x09,
  0xFF, 0xFB, 0x09, 0x30, 0x48, 0x0A, 0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_satellite() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_satellite_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_screen_rotation_alt 36x36, 4-bit Alpha,  RLE, 222 bytes.
static const unsigned char ic_filled_36_maps_screen_rotation_alt_data[] PROGMEM = {
  0x73, 0x83, 0x2B, 0xEC, 0x47, 0x77, 0x30, 0x20, 0xEC, 0x05, 0x77, 0x71, 0x02, 0x0E, 0xE0, 0x57,
  0x76, 0x02, 0x0E, 0xA8, 0x1E, 0x4C, 0xB0, 0x57, 0x50, 0xF7, 0x30, 0x20, 0xEA, 0x83, 0xE2, 0x01,
  0xCB, 0x05, 0x74, 0xB2, 0x02, 0x0E, 0xA0, 0xE0, 0x23, 0x01, 0x0C, 0xB0, 0x57, 0x3B, 0x10, 0x20,
  0xEA, 0x0E, 0x02, 0x50, 0x10, 0xCB, 0x05, 0x72, 0xB0, 0x20, 0xEA, 0x0E, 0x02, 0x70, 0x10, 0xCB,
  0x05, 0x71, 0xB0, 0xEA, 0x0E, 0x02, 0x72, 0x01, 0x0C, 0xB0, 0x57, 0xD0, 0xE0, 0x27, 0x40, 0x10,
  0xCB, 0x05, 0x6D, 0x0A, 0x0F, 0x77, 0x30, 0x10, 0xCB, 0x05, 0x5F, 0xA7, 0x40, 0x10, 0xCB, 0x05,
  0x4F, 0xA7, 0x50, 0x10, 0xCB, 0x05, 0x38, 0x05, 0x77, 0x68, 0x41, 0x77, 0x77, 0x18, 0x0F, 0x40,
  0x84, 0x17, 0x77, 0x71, 0x76, 0x80, 0x57, 0x30, 0x5B, 0x0C, 0x01, 0x75, 0xFA, 0x40, 0x5B, 0x0C,
  0x01, 0x74, 0xFA, 0x50, 0x5B, 0x0C, 0x01, 0x73, 0x0F, 0x70, 0xAD, 0x60, 0x5B, 0x0C, 0x01, 0x74,
  0x02, 0x0E, 0xD7, 0x05, 0xB0, 0xC0, 0x17, 0x20, 0x20, 0xEA, 0x0E, 0xB7, 0x10, 0x5B, 0x0C, 0x01,
  0x70, 0x20, 0xEA, 0x0E, 0x02, 0xB7, 0x20, 0x5B, 0x0C, 0x01, 0x50, 0x20, 0xEA, 0x0E, 0x02, 0x1B,
  0x73, 0x05, 0xB0, 0xC0, 0x13, 0x02, 0x0E, 0xA0, 0xE0, 0x22, 0xB7, 0x40, 0x5B, 0x83, 0xC1, 0x02,
  0xEA, 0x0E, 0x02, 0x30, 0xF7, 0x75, 0x05, 0xB8, 0x1C, 0x4E, 0xA0, 0xE0, 0x27, 0x76, 0x05, 0xE0,
  0xE0, 0x27, 0x77, 0x10, 0x5C, 0x0E, 0x02, 0x77, 0x73, 0x83, 0x4C, 0xEB, 0x27, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_screen_rotation_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_screen_rotation_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_set_meal 36x36, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_filled_36_maps_set_meal_data[] PROGMEM = {
  0x10, 0x10, 0x68, 0x0A, 0x47, 0x83, 0x61, 0x03, 0xEF, 0xFF, 0xD8, 0x1E, 0x3B, 0xFF, 0xFF, 0x0B,
  0x80, 0xC2, 0xF8, 0x7C, 0x85, 0x53, 0x56, 0x9D, 0xFF, 0xC8, 0x1E, 0x71, 0x72, 0x02, 0x09, 0xD8,
  0x19, 0x31, 0xF0, 0xA0, 0x17, 0x68, 0x32, 0xCF, 0xE3, 0x3E, 0x06, 0x77, 0x30, 0xA0, 0x74, 0xD0,
  0x77, 0x75, 0x01, 0x4D, 0x0C, 0x01, 0x77, 0x30, 0x30, 0x44, 0xE0, 0xD0, 0x27, 0x71, 0x81, 0x5E,
  0xB4, 0xF9, 0x08, 0x75, 0x02, 0x0A, 0xB0, 0xA0, 0x12, 0xFA, 0x81, 0xE9, 0x46, 0x81, 0x15, 0xAF,
  0x0B, 0x08, 0xFE, 0x83, 0xDC, 0xBC, 0xEF, 0xF9, 0x0D, 0xFF, 0xFF, 0x0D, 0x08, 0xFF, 0xFF, 0x82,
  0x80, 0x8D, 0xFF, 0xFB, 0x0D, 0x08, 0x80, 0x9C, 0x30, 0x89, 0x71, 0x12, 0x33, 0x55, 0x67, 0x89,
  0x9B, 0xBC, 0xD6, 0x28, 0x73, 0x89, 0x9B, 0xBC, 0xDD, 0xFF, 0xC0, 0x82, 0x06, 0xFF, 0x98, 0x92,
  0xDD, 0xCB, 0xB9, 0x98, 0x77, 0x53, 0x28, 0x94, 0x4B, 0x99, 0x87, 0x65, 0x53, 0x32, 0x11, 0x80,
  0xD2, 0x00, 0x58, 0x0A, 0x6B, 0x05, 0x20, 0x7F, 0xFF, 0xD0, 0x72, 0x03, 0x80, 0xA6, 0x70, 0x31,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_set_meal() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_set_meal_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_signpost 36x36, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_filled_36_maps_signpost_data[] PROGMEM = {
  0x75, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x7F, 0xFF, 0x07,
  0x6F, 0xFF, 0x90, 0x75, 0xFF, 0xFA, 0x07, 0x4F, 0xFF, 0xB0, 0x73, 0xFF, 0xFC, 0x03, 0x2F, 0xFF,
  0xB0, 0x73, 0xFF, 0xFA, 0x07, 0x4F, 0xFF, 0x90, 0x75, 0xFF, 0xF0, 0x77, 0x72, 0x07, 0xA0, 0x77,
  0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xFF, 0xF5, 0x07, 0xFF, 0xF9,
  0x40, 0x7F, 0xFF, 0xA3, 0x07, 0xFF, 0xFB, 0x20, 0x3F, 0xFF, 0xC3, 0x07, 0xFF, 0xFB, 0x40, 0x7F,
  0xFF, 0xA5, 0x07, 0xFF, 0xF9, 0x60, 0x7F, 0xFF, 0x77, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07,
  0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x73, 0x07, 0xA0, 0x77, 0x77, 0x30,
  0x7A, 0x07, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_signpost() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 31, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_signpost_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_snowmobile 36x36, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_filled_36_maps_snowmobile_data[] PROGMEM = {
  0x77, 0x28, 0x43, 0x77, 0x77, 0x27, 0x77, 0x72, 0x07, 0xC0, 0xE0, 0x37, 0x77, 0x71, 0x07, 0xD0,
  0xE0, 0x47, 0x77, 0x78, 0x33, 0x77, 0x7E, 0xB0, 0x57, 0x77, 0x73, 0x02, 0x0D, 0xB0, 0x67, 0x77,
  0x73, 0x04, 0xC0, 0x87, 0x77, 0x71, 0x06, 0xE0, 0x97, 0x77, 0x50, 0x10, 0xAF, 0x90, 0x97, 0x18,
  0x90, 0x1E, 0xDB, 0xA8, 0x65, 0x31, 0x60, 0x30, 0xDF, 0xB0, 0x97, 0x07, 0xFB, 0x83, 0xEC, 0xB9,
  0x9F, 0xE0, 0x95, 0x01, 0x0E, 0xFF, 0xFF, 0x90, 0x94, 0x07, 0xFF, 0xFF, 0xB0, 0x63, 0x09, 0x0E,
  0xFF, 0xFF, 0xA0, 0xE5, 0x81, 0x38, 0xDF, 0xFF, 0xE0, 0xC7, 0x10, 0x20, 0xBF, 0xFF, 0xB0, 0xE0,
  0x27, 0x03, 0x0B, 0xC0, 0x0E, 0xFF, 0xC0, 0xB0, 0x26, 0x02, 0x0A, 0xC0, 0xE0, 0x72, 0x81, 0x38,
  0xDF, 0xE0, 0x80, 0x37, 0x08, 0xD0, 0x80, 0x15, 0x01, 0xA0, 0xE6, 0x07, 0xB0, 0xB7, 0x08, 0xC0,
  0xA0, 0x27, 0x07, 0xA0, 0xC7, 0x07, 0xB0, 0xB3, 0x0F, 0x70, 0xEA, 0x0B, 0x03, 0x70, 0x10, 0x7B,
  0x06, 0x71, 0x07, 0xB8, 0x1B, 0x07, 0xA0, 0xC0, 0xEF, 0xF9, 0x0C, 0x50, 0x7F, 0xD0, 0x70, 0x8F,
  0xF0, 0xC0, 0x15, 0x07, 0xFC, 0x0B, 0x20, 0x80, 0xEF, 0xA8, 0x1E, 0xC6, 0x70, 0x7F, 0xA0, 0xC0,
  0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_snowmobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 7, 35, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_snowmobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_sos 36x36, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_filled_36_maps_sos_data[] PROGMEM = {
  0x20, 0x48, 0x02, 0x70, 0x33, 0x86, 0x26, 0x77, 0x77, 0x62, 0x50, 0x48, 0x02, 0x78, 0x13, 0x09,
  0xF0, 0x72, 0x06, 0xF9, 0x06, 0x30, 0x9F, 0x07, 0x04, 0xF9, 0x07, 0x20, 0xEF, 0x90, 0xE2, 0x04,
  0xF9, 0x00, 0x7A, 0x0B, 0x80, 0x17, 0x81, 0x30, 0x3A, 0x84, 0xD7, 0x77, 0x7D, 0xA8, 0x13, 0x07,
  0xA0, 0xB8, 0x01, 0x70, 0x30, 0x7A, 0x07, 0x70, 0x3A, 0x0B, 0x40, 0xBA, 0x81, 0x30, 0x7A, 0x07,
  0x60, 0x7A, 0x07, 0x70, 0x3A, 0x0B, 0x40, 0xBA, 0x81, 0x30, 0x7A, 0x07, 0x60, 0x7A, 0x83, 0xB7,
  0x77, 0x43, 0x03, 0xA0, 0xB4, 0x0B, 0xA8, 0x13, 0x07, 0xA8, 0x3B, 0x77, 0x74, 0x20, 0x4F, 0x09,
  0x20, 0x3A, 0x0B, 0x40, 0xBA, 0x81, 0x30, 0x4F, 0x09, 0x20, 0x9F, 0x81, 0x40, 0x3A, 0x0B, 0x40,
  0xBA, 0x03, 0x20, 0x9F, 0x04, 0x28, 0x34, 0x77, 0x7B, 0xA8, 0x17, 0x03, 0xA0, 0xB4, 0x0B, 0xA0,
  0x33, 0x83, 0x47, 0x77, 0xBA, 0x07, 0x60, 0x7A, 0x81, 0x70, 0x3A, 0x0B, 0x40, 0xBA, 0x03, 0x70,
  0x7A, 0x07, 0x60, 0x7A, 0x81, 0x70, 0x3A, 0x0B, 0x40, 0xBA, 0x03, 0x70, 0x7A, 0x07, 0x03, 0x80,
  0x17, 0x0B, 0xA8, 0x17, 0x03, 0xA8, 0x4D, 0x77, 0x77, 0xDA, 0x81, 0x30, 0x38, 0x01, 0x70, 0xBA,
  0x00, 0x7F, 0x90, 0x42, 0x0E, 0xF9, 0x0E, 0x20, 0x7F, 0x90, 0x40, 0x7F, 0x09, 0x30, 0x6F, 0x90,
  0x62, 0x07, 0xF8, 0x19, 0x03, 0x80, 0x27, 0x04, 0x58, 0x62, 0x67, 0x77, 0x76, 0x23, 0x03, 0x80,
  0x27, 0x04, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_sos() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 10, 34, 25), Box(0, 0, 35, 35),
      ic_filled_36_maps_sos_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_soup_kitchen 36x36, 4-bit Alpha,  RLE, 237 bytes.
static const unsigned char ic_filled_36_maps_soup_kitchen_data[] PROGMEM = {
  0x77, 0x78, 0x43, 0xBE, 0xD9, 0x17, 0x77, 0x10, 0x5D, 0x0E, 0x03, 0x77, 0x60, 0x10, 0xEE, 0x0D,
  0x77, 0x60, 0x6A, 0x82, 0xC1, 0x2E, 0xA0, 0x37, 0x75, 0x09, 0xA0, 0x62, 0x09, 0xA0, 0x57, 0x75,
  0x0B, 0xA0, 0x42, 0x0A, 0xA0, 0x57, 0x75, 0x0C, 0xA0, 0x22, 0x82, 0x48, 0xA2, 0x38, 0x15, 0x73,
  0x28, 0x16, 0x72, 0x28, 0x17, 0x71, 0x30, 0xEA, 0x01, 0x71, 0x01, 0xA8, 0x12, 0x03, 0xA8, 0x31,
  0x04, 0xFE, 0x4B, 0x72, 0x03, 0xA2, 0x81, 0x5F, 0xD2, 0x81, 0x7F, 0xC3, 0x02, 0xA0, 0xD7, 0x20,
  0x1A, 0x81, 0x30, 0x2A, 0x83, 0x10, 0x4F, 0xE3, 0x03, 0xA0, 0xB7, 0x38, 0x1B, 0xF8, 0x28, 0x1D,
  0xF6, 0x28, 0x1E, 0xF4, 0x20, 0x5A, 0x0A, 0x73, 0x81, 0x5F, 0xD2, 0x81, 0x7F, 0xB2, 0x81, 0x9F,
  0x92, 0x07, 0xA0, 0x87, 0x30, 0x1A, 0x81, 0x30, 0x2A, 0x83, 0x10, 0x4F, 0xE2, 0x08, 0xA0, 0x67,
  0x48, 0x1D, 0xF6, 0x28, 0x3E, 0xF4, 0x01, 0xA8, 0x12, 0x0A, 0xA0, 0x57, 0x48, 0x1C, 0xF7, 0x28,
  0x1E, 0xF5, 0x2A, 0x81, 0x30, 0xCA, 0x03, 0x74, 0x83, 0xEF, 0x30, 0x2A, 0x83, 0x10, 0x4F, 0xE2,
  0x0D, 0xA0, 0x27, 0x38, 0x11, 0x33, 0x28, 0x11, 0x33, 0x28, 0x12, 0x32, 0x2B, 0x77, 0x74, 0x01,
  0xA0, 0xE7, 0x20, 0x58, 0x09, 0x37, 0x09, 0xA0, 0xC7, 0x10, 0x5F, 0xFD, 0x0A, 0x71, 0x06, 0xFF,
  0xD0, 0x87, 0x10, 0x2F, 0xFD, 0x04, 0x72, 0x0C, 0xFF, 0xB0, 0xE7, 0x30, 0x5F, 0xFB, 0x07, 0x74,
  0x0B, 0xFF, 0x90, 0xD7, 0x50, 0x10, 0xDF, 0xE0, 0xE0, 0x27, 0x60, 0x10, 0xCF, 0xC0, 0xD0, 0x37,
  0x72, 0x08, 0xFA, 0x0A, 0x01, 0x77, 0x48, 0x71, 0x7B, 0xDF, 0xEC, 0x82, 0x77,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_soup_kitchen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_soup_kitchen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_stadium 36x36, 4-bit Alpha,  RLE, 188 bytes.
static const unsigned char ic_filled_36_maps_stadium_data[] PROGMEM = {
  0x76, 0x81, 0x67, 0x17, 0x71, 0x02, 0x01, 0x73, 0x83, 0x7F, 0xE7, 0x16, 0x03, 0x68, 0x27, 0xE7,
  0x17, 0x10, 0x7B, 0x81, 0xE7, 0x14, 0x90, 0xB0, 0x34, 0x07, 0xA8, 0x1E, 0x71, 0x60, 0x7B, 0x81,
  0xE7, 0x14, 0xB0, 0xB0, 0x32, 0x07, 0xC0, 0xD0, 0x15, 0x83, 0x7F, 0xE7, 0x16, 0xD8, 0x17, 0x07,
  0xA8, 0x1E, 0x71, 0x68, 0x16, 0x71, 0x71, 0xB0, 0xB0, 0x32, 0x82, 0x7E, 0x71, 0x77, 0x59, 0x0B,
  0x03, 0x40, 0x20, 0x16, 0x89, 0x22, 0x35, 0x57, 0x77, 0x75, 0x53, 0x23, 0x03, 0x72, 0x82, 0x37,
  0xAD, 0xFF, 0x82, 0xDA, 0x73, 0x60, 0x70, 0xDF, 0xFF, 0x90, 0xD0, 0x72, 0x02, 0x0D, 0xF8, 0x92,
  0xDB, 0x99, 0x77, 0x77, 0x99, 0xBD, 0xF8, 0x1D, 0x2C, 0xB8, 0x2E, 0x95, 0x27, 0x78, 0x22, 0x59,
  0xEB, 0x0C, 0xC8, 0x2E, 0x95, 0x27, 0x78, 0x22, 0x59, 0xEF, 0xE8, 0x92, 0xDB, 0x99, 0x87, 0x78,
  0x99, 0xBD, 0x80, 0xBF, 0x7F, 0x0B, 0x80, 0x47, 0x0B, 0xFF, 0xE0, 0x77, 0x10, 0x7F, 0xFE, 0x07,
  0x71, 0x07, 0xFB, 0x0E, 0xFA, 0x07, 0x71, 0x07, 0xFA, 0x0E, 0x08, 0xFA, 0x07, 0x71, 0x07, 0xFA,
  0x82, 0x80, 0x6E, 0xF0, 0x77, 0x10, 0x7F, 0x0E, 0x06, 0x48, 0x15, 0xBE, 0xC0, 0x77, 0x10, 0x7C,
  0x81, 0xEA, 0x57, 0x28, 0x33, 0x68, 0xA5, 0x71, 0x83, 0x5A, 0x86, 0x36,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_stadium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_stadium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_store_mall_directory 36x36, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_filled_36_maps_store_mall_directory_data[] PROGMEM = {
  0x2F, 0xFF, 0xB4, 0xFF, 0xFB, 0x4F, 0xFF, 0xB7, 0x77, 0x74, 0x80, 0xA4, 0x73, 0x03, 0xFF, 0xFB,
  0x03, 0x20, 0x6F, 0xFF, 0xB0, 0x62, 0x09, 0xFF, 0xFB, 0x09, 0x20, 0xCF, 0xFF, 0xB0, 0xC2, 0xFF,
  0xFD, 0x10, 0x3F, 0xFF, 0xD0, 0x30, 0x6F, 0xFF, 0xD0, 0x60, 0x7F, 0xFF, 0xD0, 0x07, 0xFF, 0xFD,
  0x00, 0x7F, 0xFF, 0xD0, 0x72, 0xB7, 0x2B, 0x6B, 0x4B, 0x72, 0xB6, 0xB4, 0xB7, 0x2B, 0x6B, 0x4B,
  0x72, 0xB6, 0xB4, 0xB7, 0x2B, 0x6B, 0x4B, 0x72, 0xB6, 0xB4, 0xFF, 0x96, 0xB4, 0xFF, 0x96, 0xB4,
  0xFF, 0x96, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_store_mall_directory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 31, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_store_mall_directory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_straight 36x36, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_filled_36_maps_straight_data[] PROGMEM = {
  0x50, 0x01, 0x72, 0x82, 0x1D, 0xD1, 0x70, 0x10, 0xDA, 0x0D, 0x01, 0x50, 0x10, 0xDC, 0x0D, 0x01,
  0x30, 0x10, 0xDE, 0x83, 0xD1, 0x01, 0xDF, 0x98, 0x1D, 0x1B, 0xA0, 0xE0, 0xBA, 0x0B, 0x0E, 0xA8,
  0x4B, 0x1D, 0xE4, 0x7A, 0x89, 0x07, 0x4E, 0xD1, 0x01, 0x30, 0x7A, 0x82, 0x70, 0x31, 0x50, 0x7A,
  0x07, 0x71, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71,
  0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0,
  0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x10,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x10, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x77, 0x18, 0x23, 0x77,
  0x34,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_straight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(12, 4, 23, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_straight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_streetview 36x36, 4-bit Alpha,  RLE, 204 bytes.
static const unsigned char ic_filled_36_maps_streetview_data[] PROGMEM = {
  0x77, 0x78, 0x25, 0x77, 0x57, 0x77, 0x30, 0x10, 0x9E, 0x09, 0x01, 0x77, 0x60, 0x20, 0xDF, 0x90,
  0xD0, 0x24, 0x04, 0x80, 0x77, 0x82, 0x20, 0x1D, 0xFB, 0x0D, 0x01, 0x20, 0x9F, 0xC0, 0xE2, 0x09,
  0xFD, 0x81, 0x90, 0x4F, 0xD0, 0x92, 0xFF, 0x10, 0x7F, 0xD8, 0x16, 0x05, 0xFF, 0x05, 0x07, 0xFD,
  0x81, 0x40, 0x6F, 0xF0, 0x60, 0x7F, 0xD8, 0x14, 0x06, 0xFF, 0x06, 0x07, 0xFD, 0x81, 0x60, 0x5F,
  0xF0, 0x50, 0x7F, 0xD0, 0x92, 0xFF, 0x10, 0x7F, 0xD0, 0xE2, 0x09, 0xFD, 0x81, 0x90, 0x7F, 0xE8,
  0x26, 0x01, 0xDF, 0xB8, 0x2D, 0x10, 0x7F, 0xE8, 0x3E, 0x10, 0x2D, 0xF9, 0x0D, 0x02, 0x20, 0x7F,
  0xF0, 0xB2, 0x01, 0x09, 0xE0, 0x90, 0x13, 0x07, 0xFF, 0x07, 0x58, 0x25, 0x77, 0x56, 0x07, 0xFE,
  0x07, 0x77, 0x20, 0x7F, 0xD0, 0x77, 0x82, 0x13, 0x31, 0x60, 0x7F, 0xC0, 0x74, 0x82, 0x16, 0xBE,
  0xC8, 0x1E, 0xB4, 0x30, 0x7F, 0xB0, 0x74, 0x08, 0x0E, 0xFA, 0x07, 0x30, 0x7F, 0xA0, 0x73, 0x02,
  0x0D, 0xFC, 0x07, 0x30, 0x7F, 0x90, 0x74, 0x0C, 0xFD, 0x07, 0x30, 0x7F, 0x07, 0x5F, 0xE0, 0x73,
  0x07, 0xE0, 0x76, 0xFE, 0x07, 0x30, 0x7D, 0x07, 0x7F, 0xE0, 0x73, 0x07, 0xC0, 0x77, 0x1F, 0xE0,
  0x73, 0x07, 0xB0, 0x77, 0x2F, 0xE0, 0x73, 0x07, 0xA0, 0x77, 0x3F, 0xE0, 0x73, 0x81, 0x4F, 0x77,
  0x4F, 0xE0, 0x44, 0x04, 0x75, 0xFD, 0x09, 0x77, 0x48, 0x07, 0x70, 0x45,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_streetview() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 34, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_streetview_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_subway 36x36, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_filled_36_maps_subway_data[] PROGMEM = {
  0x78, 0x52, 0x69, 0xBD, 0xDE, 0xA8, 0x5E, 0xDD, 0xB9, 0x62, 0x75, 0x06, 0x0D, 0xFF, 0xA0, 0xD0,
  0x67, 0x10, 0x30, 0xDF, 0xFE, 0x0D, 0x03, 0x50, 0x40, 0xEF, 0xFF, 0x90, 0xE0, 0x43, 0x02, 0x0E,
  0xFF, 0xFB, 0x0E, 0x02, 0x20, 0xCF, 0xFF, 0xD8, 0x1C, 0x04, 0xF8, 0x4D, 0x95, 0x21, 0x13, 0x83,
  0x12, 0x48, 0xDF, 0x04, 0x09, 0xE0, 0x77, 0x70, 0x6E, 0x09, 0x0C, 0xD0, 0x87, 0x72, 0x08, 0xD0,
  0xC0, 0xED, 0x02, 0x77, 0x20, 0x2D, 0x0E, 0xE1, 0x03, 0x80, 0x92, 0x70, 0x31, 0xFD, 0x10, 0x7F,
  0xF0, 0x71, 0xFD, 0x10, 0x7F, 0xF0, 0x71, 0xFD, 0x10, 0x7F, 0xF0, 0x71, 0xFD, 0x10, 0x7F, 0xF0,
  0x71, 0xFD, 0x10, 0x7F, 0xF0, 0x71, 0xFD, 0x10, 0x7F, 0xF0, 0x71, 0xFD, 0x10, 0x7F, 0xF0, 0x71,
  0xFD, 0x77, 0x4F, 0xD3, 0x06, 0x03, 0x71, 0x03, 0x06, 0x3F, 0xD2, 0x09, 0xA0, 0x16, 0x01, 0xA0,
  0x92, 0xFD, 0x81, 0x20, 0x9A, 0x01, 0x60, 0x1A, 0x81, 0x90, 0x2F, 0xD0, 0x62, 0x06, 0x03, 0x71,
  0x03, 0x06, 0x20, 0x6F, 0xD0, 0xE0, 0x37, 0x70, 0x30, 0xEF, 0xF0, 0x90, 0x43, 0x80, 0x03, 0x01,
  0x20, 0x40, 0x9F, 0xFA, 0x0E, 0x03, 0x20, 0xBC, 0x83, 0xD1, 0x03, 0xEF, 0xFA, 0x05, 0x20, 0xBE,
  0x82, 0xD1, 0x05, 0x80, 0x9B, 0x6F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_subway() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_subway_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_synagogue 36x36, 4-bit Alpha,  RLE, 233 bytes.
static const unsigned char ic_filled_36_maps_synagogue_data[] PROGMEM = {
  0x77, 0x20, 0x02, 0x77, 0x77, 0x38, 0x24, 0xEE, 0x47, 0x77, 0x71, 0x06, 0xC0, 0x67, 0x72, 0x81,
  0x47, 0x47, 0x10, 0x9E, 0x09, 0x71, 0x81, 0x47, 0x43, 0x09, 0xB0, 0x95, 0x01, 0x0B, 0xF9, 0x0B,
  0x01, 0x50, 0x9B, 0x81, 0x90, 0x4D, 0x04, 0x30, 0x20, 0xDF, 0xB0, 0xD0, 0x23, 0x04, 0xD0, 0x40,
  0x7D, 0x07, 0x20, 0x40, 0xEF, 0xD0, 0xE0, 0x42, 0x07, 0xD0, 0x07, 0xD8, 0x17, 0x06, 0xFF, 0xA8,
  0x16, 0x07, 0xD0, 0x77, 0x1F, 0x90, 0x0D, 0xF9, 0x71, 0x03, 0x80, 0x17, 0x03, 0x1F, 0x06, 0x20,
  0x6F, 0x10, 0x38, 0x01, 0x70, 0x30, 0x7D, 0x07, 0x1E, 0x0D, 0x40, 0xDE, 0x10, 0x7D, 0x00, 0x7D,
  0x07, 0x1E, 0x0D, 0x40, 0xDE, 0x10, 0x7D, 0x00, 0x7D, 0x07, 0x1F, 0x06, 0x20, 0x6F, 0x10, 0x7D,
  0x00, 0x7D, 0x07, 0x1F, 0x90, 0x0D, 0xF9, 0x10, 0x7D, 0x00, 0x7D, 0x07, 0x1F, 0xFC, 0x10, 0x7D,
  0x00, 0x7D, 0x07, 0x1F, 0xFC, 0x10, 0x7D, 0x00, 0x7D, 0x07, 0x1F, 0xFC, 0x10, 0x7D, 0x00, 0x7D,
  0x07, 0x1F, 0x82, 0x71, 0x17, 0xF1, 0x07, 0xD0, 0x07, 0xD0, 0x71, 0xE0, 0x74, 0x07, 0xE1, 0x07,
  0xD0, 0x07, 0xD0, 0x71, 0xE0, 0x14, 0x01, 0xE1, 0x07, 0xD0, 0x07, 0xD0, 0x71, 0xE6, 0xE1, 0x07,
  0xD0, 0x07, 0xD0, 0x71, 0xE6, 0xE1, 0x07, 0xD0, 0x07, 0xD0, 0x71, 0xE6, 0xE1, 0x07, 0xD0, 0x07,
  0xD0, 0x71, 0xE6, 0xE1, 0x07, 0xD0, 0x07, 0xD0, 0x71, 0xE6, 0xE1, 0x07, 0xD0, 0x07, 0xD0, 0x71,
  0xE6, 0xE1, 0x07, 0xD0, 0x07, 0xD0, 0x71, 0xE6, 0xE1, 0x07, 0xD0, 0x70, 0x38, 0x01, 0x70, 0x31,
  0x80, 0x27, 0x68, 0x02, 0x71, 0x03, 0x80, 0x17, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_synagogue() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 34, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_synagogue_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_takeout_dining 36x36, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_filled_36_maps_takeout_dining_data[] PROGMEM = {
  0x72, 0x02, 0x0D, 0xF9, 0x0D, 0x02, 0x77, 0x30, 0x40, 0xEF, 0xB0, 0xE0, 0x47, 0x30, 0x14, 0x07,
  0xFF, 0x06, 0x40, 0x13, 0x81, 0xAC, 0x12, 0x09, 0xFF, 0xA0, 0x92, 0x83, 0x1D, 0xA0, 0xAA, 0x81,
  0xC2, 0xBF, 0xFC, 0x81, 0xB2, 0xDA, 0x0A, 0x05, 0xFF, 0xFF, 0x81, 0x50, 0x5F, 0xFF, 0xD0, 0x53,
  0x05, 0xFF, 0xFB, 0x05, 0x50, 0x5F, 0xFF, 0x90, 0x58, 0x0C, 0x20, 0x80, 0xA0, 0x77, 0x3F, 0xFE,
  0x73, 0x0E, 0xFF, 0xC0, 0xE7, 0x30, 0xDF, 0xFC, 0x0D, 0x73, 0x0C, 0xFF, 0xC0, 0xC7, 0x30, 0xBF,
  0xFC, 0x0B, 0x73, 0x0A, 0xFF, 0xC0, 0xA7, 0x30, 0x9F, 0xFC, 0x09, 0x73, 0x07, 0xFF, 0xC0, 0x77,
  0x30, 0x6F, 0xFC, 0x06, 0x73, 0x05, 0xFF, 0xC0, 0x57, 0x30, 0x4F, 0xFC, 0x04, 0x73, 0x03, 0xFF,
  0xC0, 0x37, 0x30, 0x2F, 0xFC, 0x02, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_takeout_dining() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 6, 32, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_takeout_dining_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_taxi_alert 36x36, 4-bit Alpha,  RLE, 310 bytes.
static const unsigned char ic_filled_36_maps_taxi_alert_data[] PROGMEM = {
  0x77, 0x68, 0x42, 0x56, 0x75, 0x27, 0x77, 0x50, 0x60, 0xDE, 0x0D, 0x06, 0x77, 0x71, 0x03, 0x0D,
  0xFB, 0x0D, 0x03, 0x77, 0x50, 0x5C, 0x84, 0xD9, 0x77, 0xAE, 0xC0, 0x47, 0x73, 0x03, 0xB0, 0xE0,
  0x56, 0x05, 0x0E, 0xB0, 0x37, 0x72, 0x0D, 0xA0, 0xC0, 0x12, 0x07, 0xA0, 0x72, 0x01, 0x0C, 0xA0,
  0xD7, 0x48, 0x33, 0x77, 0x7A, 0xA0, 0xE0, 0x13, 0x07, 0xA0, 0x73, 0x01, 0x0E, 0xA0, 0x67, 0x30,
  0x7E, 0x05, 0x40, 0x7A, 0x07, 0x40, 0x6A, 0x0D, 0x73, 0x07, 0xD0, 0xD5, 0x07, 0xA0, 0x75, 0x0E,
  0xA0, 0x24, 0x84, 0x27, 0x77, 0x7B, 0xD0, 0xA5, 0x07, 0xA0, 0x75, 0x0A, 0xA0, 0x53, 0x02, 0x0E,
  0xFB, 0x08, 0x50, 0x7A, 0x07, 0x50, 0x8A, 0x07, 0x38, 0x18, 0xFE, 0x80, 0x2B, 0x0D, 0xA0, 0x85,
  0x07, 0xA0, 0x75, 0x09, 0xA0, 0x73, 0x81, 0xDF, 0x76, 0x05, 0xA0, 0xA5, 0x82, 0x37, 0x73, 0x50,
  0xBA, 0x05, 0x20, 0x3A, 0x02, 0x60, 0x2A, 0x0E, 0x77, 0x0E, 0xA0, 0x22, 0x81, 0x9F, 0xC7, 0x10,
  0xDA, 0x06, 0x40, 0x7A, 0x07, 0x40, 0x6A, 0x0D, 0x38, 0x1E, 0xF7, 0x71, 0x07, 0xA0, 0xE0, 0x13,
  0x07, 0xA0, 0x73, 0x02, 0x0E, 0xA0, 0x72, 0x04, 0xA0, 0x27, 0x20, 0xDA, 0x0D, 0x01, 0x20, 0x7A,
  0x07, 0x20, 0x20, 0xDA, 0x0D, 0x38, 0x19, 0xFC, 0x73, 0x03, 0x0E, 0xA0, 0xE0, 0x66, 0x05, 0x0E,
  0xB0, 0x33, 0x81, 0xEF, 0xC8, 0x07, 0x70, 0xBC, 0x84, 0xEA, 0x88, 0xAE, 0xC0, 0x53, 0x05, 0xFF,
  0xFE, 0x0D, 0x03, 0x40, 0x7F, 0xFF, 0xD0, 0xA6, 0x07, 0xB8, 0x1D, 0x8A, 0xFF, 0x81, 0xA8, 0xDB,
  0x07, 0x60, 0x7A, 0x0D, 0x30, 0x7F, 0xD0, 0x62, 0x01, 0x0D, 0xA0, 0x76, 0x07, 0xA0, 0x83, 0x01,
  0xFD, 0x01, 0x30, 0x8A, 0x07, 0x60, 0x7A, 0x0A, 0x30, 0x3F, 0xD0, 0x33, 0x0A, 0xA0, 0x76, 0x07,
  0xB8, 0x27, 0x12, 0xCF, 0xD8, 0x2C, 0x30, 0x6B, 0x07, 0x60, 0x7F, 0xFF, 0xD0, 0x76, 0x07, 0xFF,
  0xFD, 0x07, 0x60, 0x7F, 0xFF, 0xD0, 0x76, 0x07, 0xFF, 0xFD, 0x07, 0x60, 0x7C, 0x80, 0x96, 0x7C,
  0x07, 0x60, 0x7C, 0x77, 0x4C, 0x07, 0x60, 0x5B, 0x0D, 0x77, 0x40, 0xDB, 0x05, 0x78, 0x25, 0x77,
  0x27, 0x74, 0x82, 0x27, 0x75, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_taxi_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_taxi_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_temple_buddhist 36x36, 4-bit Alpha,  RLE, 182 bytes.
static const unsigned char ic_filled_36_maps_temple_buddhist_data[] PROGMEM = {
  0x77, 0x20, 0x01, 0x77, 0x77, 0x40, 0x0B, 0x77, 0x77, 0x30, 0x7A, 0x07, 0x77, 0x77, 0x10, 0x4C,
  0x04, 0x77, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x50, 0xBE, 0x0B, 0x77, 0x28, 0x23, 0x77,
  0x45, 0x07, 0xF9, 0x07, 0x58, 0x24, 0x77, 0x36, 0x05, 0xA0, 0xB4, 0x04, 0xFB, 0x04, 0x40, 0xBA,
  0x06, 0x60, 0x1B, 0x05, 0x77, 0x40, 0x5B, 0x02, 0x70, 0x9B, 0x0B, 0x08, 0x80, 0x92, 0x70, 0x80,
  0xBB, 0x0A, 0x71, 0x01, 0x0C, 0xFF, 0xF9, 0x0D, 0x01, 0x73, 0x09, 0xFF, 0xE0, 0x90, 0x15, 0x82,
  0x37, 0x74, 0x30, 0x1F, 0xFC, 0x01, 0x38, 0x34, 0x77, 0x35, 0xA0, 0xB4, 0xFF, 0xC4, 0x0B, 0xA0,
  0x60, 0x1B, 0x05, 0x77, 0x73, 0x05, 0xB8, 0x12, 0x09, 0xB0, 0xB0, 0x88, 0x0A, 0x07, 0x08, 0x0B,
  0xB0, 0xA2, 0x01, 0x0C, 0xFF, 0xFF, 0x0D, 0x01, 0x40, 0x9F, 0xFF, 0xD0, 0x90, 0x16, 0x01, 0xFF,
  0xFB, 0x01, 0x72, 0xFF, 0xFB, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB, 0x73, 0xFF, 0xFB, 0x73, 0xFF,
  0xFB, 0x73, 0xFB, 0x82, 0xE9, 0x9E, 0xFB, 0x73, 0xFA, 0x0C, 0x01, 0x20, 0x10, 0xCF, 0xA7, 0x3F,
  0xA0, 0x34, 0x03, 0xFA, 0x73, 0xFA, 0x6F, 0xA7, 0x3F, 0xA6, 0xFA, 0x73, 0xFA, 0x6F, 0xA7, 0x3F,
  0xA6, 0xFA, 0x73, 0xFA, 0x6F, 0xA5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_temple_buddhist() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 34, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_temple_buddhist_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_temple_hindu 36x36, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_filled_36_maps_temple_hindu_data[] PROGMEM = {
  0x73, 0x82, 0x47, 0x73, 0x28, 0x23, 0x77, 0x37, 0x76, 0x08, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76,
  0x08, 0xA0, 0x72, 0x07, 0xA0, 0x77, 0x76, 0x08, 0xA8, 0x2B, 0x77, 0xBA, 0x08, 0x77, 0x60, 0xCF,
  0x90, 0xC7, 0x75, 0x01, 0xFB, 0x01, 0x77, 0x40, 0x6F, 0xB0, 0x67, 0x74, 0x0A, 0xFB, 0x0A, 0x80,
  0x9C, 0x70, 0x0D, 0xFD, 0x0D, 0x77, 0x10, 0x3F, 0xF0, 0x37, 0x70, 0x7F, 0xF0, 0x77, 0x70, 0xCF,
  0xF0, 0xC7, 0x0F, 0x74, 0x80, 0x94, 0x74, 0x0F, 0x7B, 0x77, 0x73, 0xE7, 0x77, 0x3E, 0x80, 0xA4,
  0x78, 0x0A, 0xC1, 0xF8, 0x02, 0x7F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xFF, 0xB6, 0xFF, 0xFB, 0x6F,
  0xFF, 0xB6, 0xFF, 0xFB, 0x6F, 0xFF, 0xB6, 0xFD,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_temple_hindu() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_temple_hindu_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_terrain 36x36, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_filled_36_maps_terrain_data[] PROGMEM = {
  0x77, 0x50, 0x05, 0x77, 0x77, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x72, 0x0C, 0xA0, 0xC7, 0x77, 0x71,
  0x09, 0xC0, 0x97, 0x77, 0x60, 0x5E, 0x05, 0x77, 0x74, 0x02, 0x0E, 0xE0, 0xE0, 0x27, 0x74, 0x0A,
  0x50, 0xCF, 0x90, 0xC7, 0x73, 0x81, 0x9F, 0x93, 0x06, 0xFB, 0x09, 0x77, 0x10, 0x5B, 0x05, 0x30,
  0xCF, 0xB0, 0x57, 0x60, 0x20, 0xEB, 0x0E, 0x02, 0x20, 0x20, 0xEF, 0xA0, 0xE0, 0x27, 0x50, 0xCD,
  0x0C, 0x30, 0x5F, 0xB0, 0xC7, 0x40, 0x9F, 0x09, 0x30, 0x9F, 0xB0, 0x97, 0x20, 0x5F, 0xA0, 0x53,
  0x0C, 0xFB, 0x05, 0x70, 0x20, 0xEF, 0xA8, 0x3E, 0x20, 0x1B, 0xFB, 0x0E, 0x02, 0x60, 0xCF, 0xC8,
  0x1C, 0x3D, 0xFD, 0x0C, 0x50, 0x9F, 0xFF, 0xF0, 0x93, 0x05, 0xFF, 0xFF, 0xA8, 0x25, 0x02, 0xEF,
  0xFF, 0xFA, 0x0E, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_terrain() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 9, 34, 26), Box(0, 0, 35, 35),
      ic_filled_36_maps_terrain_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_theater_comedy 36x36, 4-bit Alpha,  RLE, 189 bytes.
static const unsigned char ic_filled_36_maps_theater_comedy_data[] PROGMEM = {
  0x76, 0x03, 0x80, 0x94, 0x77, 0x60, 0x7F, 0xFA, 0x76, 0x07, 0xFF, 0xA7, 0x60, 0x7F, 0xFA, 0x76,
  0x07, 0xFF, 0xA7, 0x60, 0x7A, 0x82, 0xE4, 0x4E, 0xC8, 0x19, 0x29, 0xB7, 0x60, 0x7A, 0x08, 0x20,
  0x8C, 0x3B, 0x76, 0x07, 0xA0, 0xC2, 0x0C, 0xC8, 0x15, 0x05, 0xB7, 0x60, 0x7B, 0x00, 0xEE, 0x0E,
  0xC7, 0x60, 0x38, 0x00, 0x7F, 0xD7, 0x74, 0xFF, 0xFF, 0x87, 0x70, 0xE7, 0x20, 0x14, 0xBC, 0x0D,
  0xFF, 0xA8, 0x17, 0x04, 0x60, 0xCB, 0x0A, 0xFF, 0xA0, 0x71, 0x80, 0x3B, 0x0D, 0xB0, 0x4F, 0xFA,
  0x07, 0x1F, 0xB0, 0xC1, 0xB8, 0x1D, 0x8D, 0xD0, 0x09, 0xB0, 0x71, 0xFA, 0x0E, 0x02, 0x1B, 0x81,
  0x20, 0x2C, 0x09, 0x20, 0x9A, 0x07, 0x1F, 0x90, 0xD0, 0x32, 0xB8, 0x12, 0x02, 0xC0, 0x92, 0x09,
  0xA8, 0x17, 0x0B, 0xD8, 0x1E, 0x81, 0x3B, 0x81, 0xD8, 0xDD, 0x00, 0x9B, 0x07, 0x28, 0x32, 0x57,
  0x64, 0x6F, 0xFA, 0x07, 0x76, 0xFF, 0xA0, 0x77, 0x60, 0xEB, 0x0C, 0x80, 0x27, 0x08, 0xC0, 0x67,
  0x60, 0xCB, 0x0D, 0x01, 0x50, 0x7C, 0x04, 0x76, 0x07, 0xC8, 0x4E, 0x85, 0x46, 0xBC, 0x0E, 0x77,
  0x01, 0x0E, 0xFE, 0x08, 0x77, 0x10, 0x7F, 0xD0, 0xD0, 0x17, 0x72, 0x09, 0xFB, 0x0E, 0x03, 0x77,
  0x40, 0x70, 0xEF, 0x0C, 0x02, 0x77, 0x68, 0x61, 0x7C, 0xEF, 0xD9, 0x47, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_theater_comedy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_theater_comedy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_tire_repair 36x36, 4-bit Alpha,  RLE, 278 bytes.
static const unsigned char ic_filled_36_maps_tire_repair_data[] PROGMEM = {
  0x77, 0x71, 0x85, 0x5A, 0xDF, 0xDA, 0x55, 0x01, 0x06, 0x80, 0x57, 0x06, 0x01, 0x60, 0x20, 0xCF,
  0x0C, 0x02, 0x20, 0x30, 0xEF, 0xC0, 0xE0, 0x34, 0x02, 0x0E, 0xFA, 0x82, 0xE2, 0x0B, 0xFE, 0x0B,
  0x40, 0xCB, 0x83, 0x83, 0x03, 0x8B, 0x0C, 0x1B, 0x07, 0xF0, 0x7B, 0x30, 0x5B, 0x03, 0x50, 0x3B,
  0x05, 0xB1, 0x07, 0xD0, 0x71, 0xB3, 0x0A, 0xA0, 0x83, 0x83, 0x28, 0xC0, 0x8A, 0x0A, 0xB2, 0x07,
  0xB0, 0x72, 0xB3, 0x0D, 0xA0, 0x32, 0x08, 0xA8, 0x18, 0x03, 0xA0, 0xDB, 0x3B, 0x3B, 0x3B, 0x30,
  0xEA, 0x02, 0x2E, 0x04, 0x2B, 0x20, 0x4B, 0x30, 0xDA, 0x03, 0x28, 0x18, 0xE8, 0x20, 0x3A, 0x0D,
  0xC0, 0x41, 0xB1, 0x04, 0xC3, 0x0A, 0xA0, 0x87, 0x08, 0xA0, 0xAD, 0x04, 0xB0, 0x4D, 0x30, 0x4B,
  0x03, 0x50, 0x3B, 0x04, 0xB0, 0xDF, 0x0D, 0xB4, 0x0C, 0xB8, 0x38, 0x30, 0x38, 0xB0, 0xC1, 0xB0,
  0x10, 0xDD, 0x0D, 0x01, 0xB4, 0x01, 0x0D, 0xFA, 0x0D, 0x01, 0x1B, 0x10, 0x10, 0xDB, 0x0D, 0x01,
  0x1B, 0x50, 0x20, 0xBF, 0x0B, 0x02, 0x2B, 0x20, 0x1B, 0x01, 0x2B, 0x70, 0x9D, 0x09, 0x4B, 0x3B,
  0x3B, 0x70, 0x7D, 0x07, 0x4B, 0x0B, 0x2B, 0x20, 0xBB, 0x81, 0x57, 0x44, 0x03, 0x07, 0xB0, 0x70,
  0x34, 0xC0, 0xB1, 0xB1, 0x0B, 0xF0, 0xD0, 0x44, 0xB6, 0xD0, 0xBB, 0x0B, 0xFB, 0x02, 0x3B, 0x6B,
  0x07, 0xF0, 0x7B, 0x81, 0xD8, 0xDA, 0x0A, 0x3B, 0x6B, 0x10, 0x7D, 0x07, 0x1B, 0x81, 0x20, 0x2A,
  0x0D, 0x3B, 0x6B, 0x20, 0x7B, 0x07, 0x2B, 0x3B, 0x3B, 0x6B, 0x3B, 0x3B, 0x3B, 0x3B, 0x6B, 0x04,
  0x2B, 0x20, 0x4B, 0x3B, 0x3B, 0x6C, 0x04, 0x1B, 0x10, 0x4C, 0x30, 0xDA, 0x81, 0x20, 0x2A, 0x0D,
  0x6D, 0x04, 0xB0, 0x4D, 0x30, 0xAA, 0x81, 0xD8, 0xDA, 0x0A, 0x60, 0xBF, 0xE0, 0xB3, 0x02, 0xF0,
  0x26, 0x03, 0x0E, 0xFC, 0x0E, 0x03, 0x40, 0x40, 0xDB, 0x0D, 0x04, 0x71, 0x01, 0x06, 0x80, 0x57,
  0x06, 0x01, 0x78, 0x14, 0x74, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_tire_repair() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 35, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_tire_repair_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_traffic 36x36, 4-bit Alpha,  RLE, 183 bytes.
static const unsigned char ic_filled_36_maps_traffic_data[] PROGMEM = {
  0x50, 0x58, 0x09, 0x07, 0x05, 0x72, 0x05, 0xFF, 0x05, 0x71, 0x07, 0xFF, 0x07, 0x48, 0x00, 0x70,
  0xBD, 0x82, 0xE9, 0x9E, 0xD8, 0x4B, 0x77, 0x77, 0xCF, 0x90, 0xC0, 0x12, 0x01, 0x0C, 0xF9, 0x0C,
  0x09, 0xF9, 0x03, 0x40, 0x3F, 0x90, 0x90, 0x1F, 0x96, 0xF9, 0x81, 0x10, 0x5F, 0x03, 0x40, 0x3F,
  0x05, 0x30, 0x40, 0xDD, 0x0C, 0x01, 0x20, 0x10, 0xCD, 0x0D, 0x04, 0x60, 0x9D, 0x82, 0xE9, 0x9E,
  0xD0, 0x97, 0x10, 0x7F, 0xF0, 0x74, 0x0E, 0xFA, 0x82, 0x71, 0x17, 0xFA, 0x0E, 0x0B, 0xF9, 0x07,
  0x40, 0x7F, 0x90, 0xB0, 0x5F, 0x90, 0x14, 0x01, 0xF9, 0x81, 0x50, 0xCF, 0x01, 0x40, 0x1F, 0x0C,
  0x20, 0x10, 0xBE, 0x07, 0x40, 0x7E, 0x0B, 0x01, 0x40, 0x50, 0xDD, 0x82, 0x71, 0x17, 0xD0, 0xD0,
  0x57, 0x07, 0xFF, 0x07, 0x48, 0x00, 0x70, 0xBD, 0x82, 0xE9, 0x9E, 0xD8, 0x4B, 0x77, 0x77, 0xCF,
  0x90, 0xC0, 0x12, 0x01, 0x0C, 0xF9, 0x0C, 0x09, 0xF9, 0x03, 0x40, 0x3F, 0x90, 0x90, 0x1F, 0x96,
  0xF9, 0x81, 0x10, 0x5F, 0x03, 0x40, 0x3F, 0x05, 0x30, 0x40, 0xDD, 0x0C, 0x01, 0x20, 0x10, 0xCD,
  0x0D, 0x04, 0x60, 0x9D, 0x82, 0xE9, 0x9E, 0xD0, 0x97, 0x10, 0x7F, 0xF0, 0x77, 0x10, 0x5F, 0xF0,
  0x57, 0x20, 0x58, 0x09, 0x07, 0x05, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_traffic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_traffic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_train 36x36, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_filled_36_maps_train_data[] PROGMEM = {
  0x48, 0x42, 0x79, 0xCD, 0xEC, 0x84, 0xED, 0xCA, 0x73, 0x60, 0x50, 0xCF, 0xFA, 0x0E, 0x06, 0x30,
  0x8F, 0xFE, 0x81, 0xA0, 0x5F, 0xFF, 0x90, 0x50, 0xBF, 0xFF, 0x90, 0xC0, 0xEF, 0xFF, 0x90, 0xEB,
  0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x7E,
  0x70, 0x7A, 0x07, 0x7E, 0x70, 0x7A, 0x07, 0x78, 0x0A, 0xA2, 0xF8, 0x2C, 0x20, 0x6F, 0xB8, 0x26,
  0x02, 0xCE, 0x02, 0x30, 0xAF, 0x90, 0xA3, 0x02, 0xE0, 0x13, 0x08, 0xF9, 0x08, 0x30, 0x1B, 0x0C,
  0xA0, 0x63, 0x0D, 0xF9, 0x0D, 0x30, 0x6A, 0x0C, 0x07, 0xB8, 0x1A, 0x8D, 0xFB, 0x81, 0xD8, 0xAB,
  0x81, 0x70, 0xCF, 0xFE, 0x0C, 0x20, 0x10, 0xAF, 0xFC, 0x0A, 0x01, 0x40, 0x20, 0x7C, 0x08, 0x80,
  0x17, 0x0D, 0xB0, 0x70, 0x27, 0x0B, 0xB0, 0x56, 0x01, 0x0D, 0xA0, 0xB7, 0x0B, 0xB0, 0x57, 0x10,
  0x10, 0xDA, 0x0B, 0x60, 0xF7, 0x04, 0x73, 0x01, 0x0F, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_train() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 3, 29, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_train_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_tram 36x36, 4-bit Alpha,  RLE, 165 bytes.
static const unsigned char ic_filled_36_maps_tram_data[] PROGMEM = {
  0x30, 0x7F, 0xF0, 0x76, 0x07, 0xFF, 0x07, 0x60, 0x18, 0x02, 0x30, 0xAA, 0x84, 0x83, 0x33, 0x31,
  0x75, 0x82, 0x1E, 0xFE, 0x77, 0x18, 0x23, 0x56, 0xAA, 0x83, 0xC6, 0x53, 0x17, 0x10, 0x70, 0xCF,
  0xD8, 0x1D, 0x81, 0x30, 0x20, 0xDF, 0xFA, 0x0E, 0x03, 0x20, 0xDF, 0xFC, 0x81, 0xE0, 0x4F, 0xFE,
  0x05, 0x07, 0xFF, 0xE0, 0x07, 0xA0, 0xB8, 0x09, 0x27, 0x0B, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A,
  0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07,
  0xA0, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x00, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x07, 0xA0, 0x77, 0x70,
  0x7A, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0xFE, 0x00, 0x7F, 0x98, 0x2C, 0x55, 0xCF, 0x90, 0x07, 0xF0,
  0xE0, 0x12, 0x01, 0x0E, 0xF0, 0x07, 0xF0, 0xC4, 0x0C, 0xF0, 0x70, 0x4F, 0x0E, 0x01, 0x20, 0x10,
  0xEF, 0x81, 0x50, 0xCF, 0x82, 0xC5, 0x5C, 0xF9, 0x82, 0x20, 0x2D, 0xFF, 0xB0, 0x93, 0x81, 0x18,
  0xEF, 0xE0, 0xD0, 0x75, 0x04, 0xB0, 0xC6, 0x07, 0xB0, 0x45, 0x04, 0xB0, 0xC7, 0x10, 0x7B, 0x04,
  0x4B, 0x0C, 0x73, 0x07, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_tram() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 3, 28, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_tram_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_transfer_within_a_station 36x36, 4-bit Alpha,  RLE, 244 bytes.
static const unsigned char ic_filled_36_maps_transfer_within_a_station_data[] PROGMEM = {
  0x72, 0x82, 0x29, 0xA6, 0x77, 0x74, 0x02, 0x0E, 0xB0, 0x97, 0x77, 0x30, 0x9D, 0x01, 0x77, 0x72,
  0x0A, 0xD0, 0x27, 0x77, 0x20, 0x6C, 0x0D, 0x77, 0x74, 0x09, 0xA0, 0xD0, 0x37, 0x77, 0x50, 0x10,
  0x37, 0x77, 0x38, 0x33, 0x9E, 0xE8, 0x77, 0x72, 0x06, 0x0C, 0xD0, 0x87, 0x75, 0x81, 0x28, 0xEF,
  0x90, 0x37, 0x73, 0x0B, 0xFC, 0x0C, 0x77, 0x3C, 0x0C, 0x0B, 0xF0, 0x87, 0x72, 0xB8, 0x14, 0x09,
  0xF9, 0x06, 0x77, 0x1B, 0x20, 0xCD, 0x0D, 0xB0, 0xA0, 0x27, 0x6B, 0x2E, 0x02, 0x0B, 0xC8, 0x1C,
  0x93, 0x73, 0xB1, 0x02, 0xD0, 0xE2, 0x08, 0xD0, 0x77, 0x3B, 0x10, 0x5D, 0x0B, 0x38, 0x13, 0xAE,
  0xA0, 0x77, 0x30, 0xF7, 0x10, 0x8D, 0x08, 0x68, 0x14, 0x53, 0x77, 0x0B, 0xD0, 0xC7, 0x30, 0x17,
  0x50, 0xEE, 0x0B, 0x71, 0x03, 0x0A, 0x74, 0x02, 0xB0, 0xDC, 0x0B, 0x68, 0x13, 0xEB, 0x74, 0x05,
  0xB0, 0x10, 0x9C, 0x07, 0x48, 0x23, 0xEF, 0xE8, 0x04, 0xB3, 0x08, 0xA0, 0xC2, 0x08, 0xB0, 0x74,
  0x0B, 0xFC, 0x30, 0xBA, 0x09, 0x30, 0x9A, 0x07, 0x48, 0x21, 0xCF, 0xD8, 0x04, 0x73, 0x0E, 0xA0,
  0x63, 0x07, 0xA0, 0x75, 0x81, 0x1C, 0xB7, 0x30, 0x2B, 0x02, 0x30, 0x7A, 0x07, 0x60, 0x10, 0x84,
  0x07, 0x50, 0x5A, 0x0E, 0x40, 0x7A, 0x07, 0x75, 0x00, 0xB4, 0x08, 0xA0, 0xB4, 0x07, 0xA0, 0x74,
  0x80, 0x45, 0x81, 0xCF, 0xB3, 0x0B, 0xA0, 0x84, 0x07, 0xA0, 0x74, 0xFC, 0x0A, 0x20, 0xEA, 0x04,
  0x40, 0x7A, 0x07, 0x48, 0x04, 0xD0, 0xEA, 0x81, 0x40, 0x1B, 0x01, 0x40, 0x7A, 0x07, 0x75, 0x81,
  0xBF, 0x42, 0x04, 0xA0, 0xD5, 0x07, 0xA0, 0x77, 0x50, 0xA0, 0x43, 0x82, 0x37, 0x75, 0x58, 0x23,
  0x77, 0x37, 0x50, 0x13,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_transfer_within_a_station() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 32, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_transfer_within_a_station_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_transit_enterexit 36x36, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_filled_36_maps_transit_enterexit_data[] PROGMEM = {
  0x77, 0x08, 0x07, 0x77, 0x10, 0x8A, 0x07, 0x76, 0x09, 0xC0, 0x7C, 0x07, 0x60, 0x9D, 0x08, 0xC0,
  0x75, 0x0A, 0xD0, 0x81, 0xC0, 0x74, 0x0A, 0xD0, 0x92, 0xC0, 0x73, 0x0A, 0xD0, 0x93, 0xC0, 0x72,
  0x0B, 0xD0, 0x94, 0xC8, 0x17, 0x0B, 0xD0, 0x95, 0xC0, 0x80, 0xBD, 0x09, 0x6F, 0xB0, 0xA7, 0xFA,
  0x0A, 0x71, 0xF9, 0x0A, 0x72, 0xF0, 0xE0, 0x88, 0x02, 0x73, 0xFF, 0x93, 0xFF, 0x93, 0xFF, 0x93,
  0xFF, 0x93,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_transit_enterexit() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 9, 26, 26), Box(0, 0, 35, 35),
      ic_filled_36_maps_transit_enterexit_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_trip_origin 36x36, 4-bit Alpha,  RLE, 199 bytes.
static const unsigned char ic_filled_36_maps_trip_origin_data[] PROGMEM = {
  0x73, 0x89, 0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x74, 0x07, 0x0E, 0xFB, 0x0E, 0x07, 0x77, 0x05,
  0x0D, 0xFF, 0x0D, 0x05, 0x74, 0x07, 0xFF, 0xC0, 0x77, 0x20, 0xAF, 0xFE, 0x0A, 0x70, 0x8F, 0xFF,
  0x90, 0x85, 0x05, 0xF9, 0x81, 0xB6, 0x22, 0x81, 0x26, 0xBF, 0x90, 0x54, 0x0D, 0xE0, 0xD0, 0x37,
  0x10, 0x30, 0xDE, 0x0D, 0x30, 0x7E, 0x0B, 0x01, 0x73, 0x01, 0x0B, 0xE0, 0x72, 0x0E, 0xD0, 0xD0,
  0x17, 0x50, 0x10, 0xDD, 0x81, 0xE0, 0x3E, 0x03, 0x77, 0x03, 0xE0, 0x30, 0x8D, 0x0B, 0x77, 0x20,
  0xBD, 0x08, 0x0B, 0xD0, 0x67, 0x72, 0x06, 0xD0, 0xB0, 0xDD, 0x02, 0x77, 0x20, 0x2D, 0x0D, 0x0E,
  0xD7, 0x74, 0xD0, 0x0E, 0xD7, 0x74, 0xD0, 0xE0, 0xDD, 0x02, 0x77, 0x20, 0x2D, 0x0D, 0x0B, 0xD0,
  0x67, 0x72, 0x06, 0xD0, 0xB0, 0x8D, 0x0B, 0x77, 0x20, 0xBD, 0x08, 0x03, 0xE0, 0x37, 0x70, 0x3E,
  0x81, 0x30, 0xED, 0x0D, 0x01, 0x75, 0x01, 0x0D, 0xD0, 0xE2, 0x07, 0xE0, 0xB0, 0x17, 0x30, 0x10,
  0xBE, 0x07, 0x30, 0xDE, 0x0D, 0x03, 0x71, 0x03, 0x0D, 0xE0, 0xD4, 0x05, 0xF9, 0x81, 0xB6, 0x22,
  0x81, 0x26, 0xBF, 0x90, 0x55, 0x08, 0xFF, 0xF9, 0x08, 0x70, 0xAF, 0xFE, 0x0A, 0x72, 0x07, 0xFF,
  0xC0, 0x77, 0x40, 0x50, 0xDF, 0xF0, 0xD0, 0x57, 0x70, 0x70, 0xEF, 0xB0, 0xE0, 0x77, 0x74, 0x89,
  0x03, 0x8B, 0xDE, 0xED, 0xB8, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_trip_origin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_trip_origin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_turn_left 36x36, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_filled_36_maps_turn_left_data[] PROGMEM = {
  0x58, 0x11, 0xB1, 0x77, 0x48, 0x31, 0xDF, 0xD1, 0x77, 0x20, 0x10, 0xDA, 0x0E, 0x03, 0x77, 0x10,
  0x10, 0xDA, 0x0E, 0x04, 0x77, 0x10, 0x10, 0xDB, 0x0B, 0x80, 0x90, 0x70, 0x42, 0x01, 0x0D, 0xFF,
  0xC8, 0x29, 0x01, 0xDF, 0xFD, 0x82, 0x40, 0x1D, 0xB0, 0xB8, 0x07, 0x70, 0xBA, 0x07, 0x20, 0x10,
  0xDB, 0x04, 0x73, 0x07, 0xA0, 0x73, 0x01, 0x0D, 0xB0, 0x47, 0x20, 0x7A, 0x07, 0x48, 0x31, 0xDF,
  0xD2, 0x72, 0x07, 0xA0, 0x75, 0x81, 0x1B, 0x17, 0x30, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77,
  0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77,
  0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_turn_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 9, 25, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_turn_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_turn_right 36x36, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_filled_36_maps_turn_right_data[] PROGMEM = {
  0x77, 0x81, 0x1B, 0x17, 0x74, 0x83, 0x1D, 0xFD, 0x17, 0x73, 0x03, 0x0E, 0xA0, 0xD0, 0x17, 0x73,
  0x04, 0x0E, 0xA0, 0xD0, 0x14, 0x04, 0x80, 0x90, 0x70, 0xBB, 0x0D, 0x01, 0x20, 0x9F, 0xFC, 0x81,
  0xD1, 0x4F, 0xFD, 0x81, 0xD1, 0x7A, 0x0B, 0x80, 0x77, 0x0B, 0xB8, 0x2D, 0x10, 0x7A, 0x07, 0x73,
  0x04, 0xB0, 0xD0, 0x12, 0x07, 0xA0, 0x77, 0x20, 0x4B, 0x0D, 0x01, 0x30, 0x7A, 0x07, 0x72, 0x83,
  0x2D, 0xFD, 0x14, 0x07, 0xA0, 0x77, 0x38, 0x11, 0xB1, 0x50, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07,
  0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07,
  0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40, 0x7A, 0x07, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_turn_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(10, 9, 31, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_turn_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_turn_sharp_left 36x36, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_filled_36_maps_turn_sharp_left_data[] PROGMEM = {
  0x60, 0x37, 0x77, 0x81, 0x7F, 0x77, 0x75, 0x07, 0xB0, 0x77, 0x73, 0x07, 0xD0, 0x77, 0x71, 0x07,
  0xF0, 0x77, 0x60, 0x7F, 0xA0, 0x77, 0x40, 0x3B, 0x0B, 0xB0, 0xBB, 0x03, 0x74, 0x81, 0x7F, 0xA1,
  0xB1, 0x81, 0xAF, 0x77, 0x60, 0x52, 0xB2, 0x05, 0x77, 0x3B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B,
  0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x80, 0x90, 0x70, 0x60, 0x16, 0x0B, 0xFF, 0x90, 0xE0, 0x35,
  0x03, 0x0E, 0xFF, 0x90, 0xB6, 0x01, 0x06, 0x80, 0x90, 0x7B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B,
  0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x60, 0xF7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_turn_sharp_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 26, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_turn_sharp_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_turn_sharp_right 36x36, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_filled_36_maps_turn_sharp_right_data[] PROGMEM = {
  0x77, 0x20, 0x37, 0x77, 0x81, 0x7F, 0x77, 0x75, 0x07, 0xB0, 0x77, 0x73, 0x07, 0xD0, 0x77, 0x71,
  0x07, 0xF0, 0x77, 0x60, 0x7F, 0xA0, 0x77, 0x40, 0x3B, 0x0B, 0xB0, 0xBB, 0x03, 0x74, 0x81, 0x7F,
  0xA1, 0xB1, 0x81, 0xBF, 0x77, 0x60, 0x52, 0xB2, 0x05, 0x77, 0x3B, 0x77, 0x6B, 0x77, 0x6B, 0x77,
  0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x60, 0x10, 0x68, 0x09, 0x07, 0xB5, 0x03, 0x0E, 0xFF, 0x90, 0xB5,
  0x0B, 0xFF, 0x90, 0xE0, 0x35, 0xB8, 0x09, 0x07, 0x06, 0x01, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77,
  0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x60, 0xF7, 0x77, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_turn_sharp_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_turn_sharp_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_turn_slight_left 36x36, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_36_maps_turn_slight_left_data[] PROGMEM = {
  0xF9, 0x07, 0x5F, 0x90, 0x75, 0xF9, 0x07, 0x5D, 0x09, 0x71, 0xE0, 0x97, 0xB0, 0x9B, 0x09, 0x6B,
  0x10, 0x9B, 0x09, 0x5B, 0x20, 0x9B, 0x09, 0x40, 0xF7, 0x30, 0x9B, 0x09, 0x73, 0x09, 0xB0, 0x97,
  0x30, 0x9B, 0x08, 0x73, 0x09, 0xB0, 0x37, 0x30, 0xAA, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A,
  0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73,
  0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0,
  0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_turn_slight_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 6, 22, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_turn_slight_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_turn_slight_right 36x36, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_36_maps_turn_slight_right_data[] PROGMEM = {
  0x50, 0x7F, 0x95, 0x07, 0xF9, 0x50, 0x7F, 0x97, 0x10, 0x9D, 0x70, 0x9E, 0x60, 0x9B, 0x09, 0xB5,
  0x09, 0xB0, 0x91, 0xB4, 0x09, 0xB0, 0x92, 0xB3, 0x09, 0xB0, 0x93, 0x0F, 0x72, 0x09, 0xB0, 0x97,
  0x10, 0x8B, 0x09, 0x71, 0x03, 0xB0, 0x97, 0x20, 0x7A, 0x0A, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A,
  0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73,
  0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0, 0x77, 0x30, 0x7A, 0x07, 0x73, 0x07, 0xA0,
  0x77, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_turn_slight_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(13, 6, 26, 29), Box(0, 0, 35, 35),
      ic_filled_36_maps_turn_slight_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_two_wheeler 36x36, 4-bit Alpha,  RLE, 228 bytes.
static const unsigned char ic_filled_36_maps_two_wheeler_data[] PROGMEM = {
  0x76, 0x03, 0x80, 0x27, 0x02, 0x77, 0x77, 0x07, 0xE0, 0xE0, 0x37, 0x77, 0x60, 0x7F, 0x0E, 0x03,
  0x50, 0x30, 0xB7, 0x75, 0x03, 0x80, 0x17, 0x0E, 0xA0, 0xE0, 0x32, 0x03, 0x0B, 0xA7, 0x77, 0x40,
  0x20, 0xEA, 0x81, 0xE5, 0xBC, 0x77, 0x75, 0x02, 0x0E, 0xF9, 0x68, 0x03, 0x70, 0x57, 0x85, 0x16,
  0x77, 0x77, 0xAC, 0x0A, 0x0F, 0x76, 0xF9, 0x07, 0x48, 0x11, 0x7E, 0xFB, 0x0E, 0x03, 0x71, 0xFA,
  0x83, 0x70, 0x17, 0xEF, 0xE0, 0xE0, 0x37, 0x0F, 0x78, 0x18, 0xCE, 0xC0, 0xA0, 0xEF, 0xD0, 0xB0,
  0xEA, 0x82, 0xE7, 0x74, 0x60, 0x50, 0xDF, 0xFD, 0x82, 0xE1, 0x2E, 0xD0, 0xD0, 0x53, 0x06, 0xFF,
  0xF8, 0x17, 0x05, 0xF9, 0x81, 0x60, 0x2B, 0x82, 0xE9, 0x9E, 0xFF, 0x81, 0xD0, 0x2B, 0x82, 0xE9,
  0x9E, 0xB0, 0x20, 0x9A, 0x0C, 0x01, 0x20, 0x10, 0xCF, 0xE8, 0x15, 0x09, 0xA0, 0xC0, 0x12, 0x01,
  0x0C, 0xA0, 0x90, 0xDA, 0x03, 0x40, 0x3F, 0xD0, 0xC2, 0x0D, 0xA0, 0x34, 0x03, 0xA0, 0xDB, 0x6B,
  0x0D, 0xF9, 0x03, 0x2B, 0x6B, 0x0D, 0xA0, 0x34, 0x03, 0xA8, 0x1D, 0x1D, 0xE0, 0x93, 0x0D, 0xA0,
  0x34, 0x03, 0xA0, 0xD0, 0x9A, 0x0C, 0x01, 0x20, 0x10, 0xCA, 0x82, 0x90, 0x1D, 0xC0, 0xE0, 0x13,
  0x09, 0xA0, 0xC0, 0x12, 0x01, 0x0C, 0xA0, 0x90, 0x2B, 0x82, 0xE9, 0x9E, 0xB0, 0x22, 0x84, 0x17,
  0x77, 0x75, 0x40, 0x2B, 0x82, 0xE9, 0x9E, 0xB8, 0x12, 0x06, 0xF9, 0x06, 0x77, 0x06, 0xF9, 0x06,
  0x30, 0x50, 0xDC, 0x0D, 0x05, 0x77, 0x20, 0x50, 0xDC, 0x0D, 0x05, 0x68, 0x24, 0x77, 0x47, 0x76,
  0x82, 0x47, 0x74, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_two_wheeler() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 7, 35, 28), Box(0, 0, 35, 35),
      ic_filled_36_maps_two_wheeler_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_u_turn_left 36x36, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_filled_36_maps_u_turn_left_data[] PROGMEM = {
  0x74, 0x84, 0x15, 0x77, 0x51, 0x77, 0x10, 0x30, 0xBE, 0x0B, 0x03, 0x75, 0x08, 0xFB, 0x08, 0x73,
  0x0A, 0xC8, 0x2B, 0x88, 0xBC, 0x0A, 0x71, 0x06, 0xB0, 0xA0, 0x14, 0x01, 0x0A, 0xB0, 0x66, 0x01,
  0x0E, 0xA0, 0x87, 0x10, 0x8A, 0x0E, 0x01, 0x50, 0x6A, 0x0C, 0x73, 0x0C, 0xA0, 0x65, 0x0B, 0xA0,
  0x57, 0x30, 0x5A, 0x0B, 0x50, 0xDA, 0x01, 0x73, 0x01, 0xA0, 0xD5, 0xB7, 0x5B, 0x5B, 0x75, 0xB5,
  0xB7, 0x5B, 0x5B, 0x75, 0xB2, 0x05, 0x2B, 0x20, 0x57, 0x2B, 0x18, 0x17, 0xFA, 0x1B, 0x18, 0x1B,
  0xF7, 0x71, 0xB0, 0x3B, 0x0B, 0xB0, 0xBB, 0x03, 0x7B, 0x10, 0x7F, 0xA0, 0x77, 0x1B, 0x20, 0x7F,
  0x07, 0x72, 0xB3, 0x07, 0xD0, 0x77, 0x3B, 0x40, 0x7B, 0x07, 0x74, 0xB5, 0x81, 0x7F, 0x77, 0x5B,
  0x60, 0x37, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x6B, 0x77, 0x60, 0xF7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_u_turn_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 26, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_u_turn_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_u_turn_right 36x36, 4-bit Alpha,  RLE, 128 bytes.
static const unsigned char ic_filled_36_maps_u_turn_right_data[] PROGMEM = {
  0x68, 0x41, 0x57, 0x75, 0x17, 0x71, 0x03, 0x0B, 0xE0, 0xB0, 0x37, 0x50, 0x8F, 0xB0, 0x87, 0x30,
  0xAC, 0x82, 0xB8, 0x8B, 0xC0, 0xA7, 0x10, 0x6B, 0x0A, 0x01, 0x40, 0x10, 0xAB, 0x06, 0x60, 0x10,
  0xEA, 0x08, 0x71, 0x08, 0xA0, 0xE0, 0x15, 0x06, 0xA0, 0xC7, 0x30, 0xCA, 0x06, 0x50, 0xBA, 0x05,
  0x73, 0x05, 0xA0, 0xB5, 0x0D, 0xA0, 0x17, 0x30, 0x1A, 0x0D, 0x5B, 0x75, 0xB5, 0xB7, 0x5B, 0x5B,
  0x75, 0xB5, 0xB7, 0x5B, 0x5B, 0x72, 0x05, 0x2B, 0x20, 0x52, 0xB7, 0x18, 0x17, 0xFB, 0x1B, 0x18,
  0x1A, 0xF7, 0x1B, 0x70, 0x3B, 0x0B, 0xB0, 0xBB, 0x03, 0xB7, 0x10, 0x7F, 0xA0, 0x71, 0xB7, 0x20,
  0x7F, 0x07, 0x2B, 0x73, 0x07, 0xD0, 0x73, 0xB7, 0x40, 0x7B, 0x07, 0x4B, 0x75, 0x81, 0x7F, 0x75,
  0xB7, 0x60, 0x36, 0xB7, 0x76, 0xB7, 0x76, 0xB7, 0x76, 0xB7, 0x76, 0xB7, 0x76, 0x0F, 0x77, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_u_turn_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_u_turn_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_volunteer_activism 36x36, 4-bit Alpha,  RLE, 221 bytes.
static const unsigned char ic_filled_36_maps_volunteer_activism_data[] PROGMEM = {
  0x77, 0x28, 0x45, 0xBE, 0xEB, 0x42, 0x84, 0x4B, 0xEE, 0xB5, 0x77, 0x30, 0x9E, 0x00, 0x9E, 0x09,
  0x77, 0x10, 0x5F, 0xFA, 0x05, 0x77, 0x0B, 0xFF, 0xA0, 0xB7, 0x70, 0xEF, 0xFA, 0x0E, 0x77, 0x0E,
  0xFF, 0xA0, 0xE7, 0x70, 0xAF, 0xFA, 0x0A, 0x77, 0x04, 0xFF, 0xA0, 0x47, 0x71, 0x0A, 0xFF, 0x0A,
  0x77, 0x20, 0x10, 0xDF, 0xD0, 0xD0, 0x17, 0x73, 0x03, 0x0E, 0xFB, 0x0E, 0x03, 0x77, 0x50, 0x4F,
  0xB0, 0x47, 0x77, 0x04, 0xF9, 0x04, 0x40, 0x38, 0x01, 0x70, 0x32, 0x83, 0x37, 0x76, 0x15, 0x04,
  0x0E, 0xC0, 0xE0, 0x45, 0x07, 0xD0, 0x72, 0x07, 0xC0, 0xB0, 0x54, 0x03, 0x0E, 0xA0, 0xE0, 0x36,
  0x07, 0xD0, 0x72, 0x07, 0xE8, 0x1E, 0x93, 0x28, 0x22, 0xDD, 0x27, 0x07, 0xD0, 0x72, 0x07, 0xFA,
  0x83, 0xD7, 0x12, 0x27, 0x10, 0x7D, 0x07, 0x20, 0x7F, 0xD0, 0xB0, 0x57, 0x10, 0x7D, 0x07, 0x20,
  0x7F, 0xF0, 0x47, 0x07, 0xD0, 0x72, 0x07, 0xFF, 0x06, 0x70, 0x7D, 0x07, 0x20, 0x7D, 0x82, 0xA3,
  0x9E, 0xC0, 0xB0, 0x17, 0x07, 0xD0, 0x72, 0x07, 0xD0, 0xA0, 0x37, 0x71, 0x07, 0xD0, 0x72, 0x07,
  0xF0, 0xD0, 0x88, 0x06, 0x78, 0x26, 0x10, 0x7D, 0x07, 0x20, 0x7F, 0xFE, 0x81, 0xE3, 0x7D, 0x07,
  0x20, 0x7F, 0xFF, 0x0C, 0x07, 0xD0, 0x72, 0x07, 0xFF, 0xF0, 0xA0, 0x7D, 0x07, 0x20, 0x7F, 0xFC,
  0x83, 0xC6, 0x10, 0x7D, 0x07, 0x38, 0x14, 0x9D, 0xFD, 0x81, 0xE8, 0x24, 0x07, 0xD0, 0x76, 0x81,
  0x26, 0xBF, 0x0A, 0x04, 0x70, 0x7D, 0x07, 0x73, 0x84, 0x49, 0xDC, 0x61, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_volunteer_activism() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 32, 32), Box(0, 0, 35, 35),
      ic_filled_36_maps_volunteer_activism_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_warehouse 36x36, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_filled_36_maps_warehouse_data[] PROGMEM = {
  0x77, 0x00, 0x47, 0x77, 0x48, 0x11, 0x7D, 0xA8, 0x1D, 0x71, 0x77, 0x60, 0x40, 0xAF, 0x90, 0xA0,
  0x47, 0x71, 0x81, 0x17, 0xDF, 0xD8, 0x1D, 0x71, 0x73, 0x04, 0x0A, 0xFF, 0xC0, 0xA0, 0x45, 0x81,
  0x17, 0xDF, 0xFF, 0x98, 0x3D, 0x71, 0x0A, 0xFF, 0xFF, 0x0A, 0x80, 0xBA, 0x5F, 0x07, 0x77, 0x07,
  0xFF, 0x07, 0x77, 0x07, 0xFF, 0x07, 0x77, 0x07, 0xFF, 0x07, 0x77, 0x07, 0xFF, 0x07, 0x77, 0x07,
  0xFF, 0x07, 0x77, 0x07, 0xFF, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7F, 0xF0, 0x75, 0x07, 0xA0, 0x75,
  0x07, 0xFF, 0x07, 0x50, 0x7A, 0x07, 0x50, 0x7F, 0xF0, 0x77, 0x70, 0x7F, 0xF0, 0x72, 0x82, 0x37,
  0x73, 0x28, 0x23, 0x77, 0x32, 0x07, 0xFF, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7A, 0x07, 0x20, 0x7F,
  0xF0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x72, 0x07, 0xF8, 0x03, 0x70, 0x32, 0x82, 0x37, 0x73,
  0x28, 0x23, 0x77, 0x32, 0x03, 0x80, 0x37,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_warehouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 32, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_warehouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_wine_bar 36x36, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_filled_36_maps_wine_bar_data[] PROGMEM = {
  0x80, 0x96, 0x78, 0x0C, 0x3F, 0x80, 0x90, 0x7E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x58, 0x0C, 0x3F,
  0x0E, 0xFF, 0xA0, 0xE0, 0xBF, 0xFA, 0x0B, 0x07, 0xFF, 0xA8, 0x17, 0x1E, 0xFF, 0x82, 0xE1, 0x06,
  0xFF, 0x06, 0x30, 0xAF, 0xD0, 0xA5, 0x08, 0xFB, 0x08, 0x70, 0x40, 0xBE, 0x0B, 0x04, 0x73, 0x01,
  0x0A, 0xA0, 0xA0, 0x17, 0x60, 0x7A, 0x07, 0x77, 0x07, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x77, 0x07,
  0xA0, 0x77, 0x70, 0x7A, 0x07, 0x73, 0x80, 0x07, 0x0B, 0xA0, 0xB8, 0x00, 0x76, 0xFD, 0x6F, 0xD6,
  0x80, 0x90, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_wine_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(9, 4, 26, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_wine_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_wrong_location 36x36, 4-bit Alpha,  RLE, 201 bytes.
static const unsigned char ic_filled_36_maps_wrong_location_data[] PROGMEM = {
  0x77, 0x40, 0x10, 0x85, 0x08, 0x01, 0x77, 0x48, 0x21, 0xDF, 0x93, 0x82, 0x9F, 0xD1, 0x72, 0x84,
  0x35, 0x77, 0x53, 0x20, 0x8B, 0x81, 0x90, 0x9B, 0x08, 0x68, 0x12, 0x9E, 0xE3, 0x09, 0xB0, 0xDB,
  0x09, 0x60, 0x9F, 0xA4, 0x09, 0xD0, 0x95, 0x01, 0x0C, 0xFB, 0x50, 0xDB, 0x0D, 0x50, 0x10, 0xDF,
  0xC4, 0x09, 0xD0, 0x94, 0x0B, 0xFD, 0x30, 0x9B, 0x0D, 0xB0, 0x92, 0x05, 0xFE, 0x20, 0x8B, 0x81,
  0x90, 0x9B, 0x81, 0x80, 0xDF, 0xE2, 0x82, 0x1D, 0xF9, 0x38, 0x39, 0xFD, 0x13, 0xFF, 0x30, 0x10,
  0x85, 0x82, 0x81, 0x08, 0xFA, 0x82, 0xE9, 0x9E, 0x97, 0x60, 0xCF, 0x90, 0xC0, 0x12, 0x01, 0x0C,
  0x76, 0x0D, 0xF9, 0x03, 0x40, 0x3F, 0x90, 0xD4, 0xFA, 0x6F, 0xA4, 0x0E, 0xF9, 0x03, 0x40, 0x3F,
  0x90, 0xE4, 0x0C, 0xF9, 0x0C, 0x01, 0x20, 0x10, 0xCF, 0x90, 0xC4, 0x09, 0xFA, 0x82, 0xE9, 0x9E,
  0xFA, 0x09, 0x40, 0x4F, 0xFF, 0x90, 0x45, 0x0D, 0xFF, 0xE0, 0xD6, 0x06, 0xFF, 0xE0, 0x67, 0x0D,
  0xFF, 0xC0, 0xD7, 0x10, 0x4F, 0xFC, 0x04, 0x72, 0x09, 0xFF, 0xA0, 0x97, 0x40, 0xCF, 0xF0, 0xC7,
  0x50, 0x20, 0xEF, 0xD0, 0xE0, 0x27, 0x60, 0x30, 0xEF, 0xB0, 0xE0, 0x37, 0x71, 0x04, 0xFB, 0x04,
  0x77, 0x30, 0x4F, 0x90, 0x47, 0x75, 0x04, 0xE0, 0x47, 0x77, 0x04, 0x0E, 0xA0, 0xE0, 0x47, 0x77,
  0x28, 0x23, 0xEE, 0x37, 0x77, 0x40, 0x02, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_wrong_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 33, 34), Box(0, 0, 35, 35),
      ic_filled_36_maps_wrong_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_zoom_in_map 36x36, 4-bit Alpha,  RLE, 198 bytes.
static const unsigned char ic_filled_36_maps_zoom_in_map_data[] PROGMEM = {
  0x81, 0x1C, 0x93, 0x82, 0x37, 0x73, 0x71, 0x82, 0x37, 0x73, 0x38, 0x29, 0xC1, 0xCA, 0x09, 0x20,
  0x7A, 0x07, 0x71, 0x07, 0xA0, 0x72, 0x09, 0xA0, 0xC0, 0x9B, 0x81, 0x90, 0x7A, 0x07, 0x71, 0x07,
  0xA8, 0x17, 0x09, 0xB8, 0x19, 0x09, 0xB0, 0x90, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x70, 0x9B, 0x09,
  0x30, 0x9B, 0x0E, 0xA0, 0x77, 0x10, 0x7A, 0x0E, 0xB0, 0x95, 0x09, 0xD0, 0x77, 0x10, 0x7D, 0x09,
  0x38, 0x33, 0x77, 0x7E, 0xC0, 0x77, 0x10, 0x7C, 0x84, 0xE7, 0x77, 0x37, 0xF9, 0x07, 0x71, 0x07,
  0xF9, 0x00, 0x7F, 0x90, 0x77, 0x10, 0x7F, 0x90, 0x70, 0x38, 0x04, 0x70, 0x37, 0x10, 0x38, 0x04,
  0x70, 0x38, 0x0B, 0xB4, 0x00, 0x38, 0x04, 0x70, 0x37, 0x10, 0x38, 0x04, 0x70, 0x30, 0x7F, 0x90,
  0x77, 0x10, 0x7F, 0x90, 0x07, 0xF9, 0x07, 0x71, 0x07, 0xF9, 0x84, 0x73, 0x77, 0x7E, 0xC0, 0x77,
  0x10, 0x7C, 0x83, 0xE7, 0x77, 0x33, 0x09, 0xD0, 0x77, 0x10, 0x7D, 0x09, 0x50, 0x9B, 0x0E, 0xA0,
  0x77, 0x10, 0x7A, 0x0E, 0xB0, 0x93, 0x09, 0xB0, 0x90, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x70, 0x9B,
  0x81, 0x90, 0x9B, 0x81, 0x90, 0x7A, 0x07, 0x71, 0x07, 0xA8, 0x17, 0x09, 0xB0, 0x90, 0xCA, 0x09,
  0x20, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x72, 0x09, 0xA8, 0x2C, 0x1C, 0x93, 0x82, 0x37, 0x73, 0x71,
  0x82, 0x37, 0x73, 0x38, 0x19, 0xC1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_zoom_in_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_zoom_in_map_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_36_maps_zoom_out_map 36x36, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_filled_36_maps_zoom_out_map_data[] PROGMEM = {
  0x03, 0x80, 0x47, 0x01, 0x71, 0x01, 0x80, 0x47, 0x03, 0x07, 0xF0, 0x77, 0x30, 0x7F, 0x00, 0x7E,
  0x07, 0x75, 0x07, 0xE0, 0x07, 0xD0, 0x77, 0x70, 0x7D, 0x00, 0x7D, 0x09, 0x77, 0x09, 0xD0, 0x07,
  0xE0, 0x97, 0x50, 0x9E, 0x00, 0x7A, 0x07, 0x09, 0xB0, 0x97, 0x30, 0x9B, 0x09, 0x07, 0xA8, 0x27,
  0x7F, 0x72, 0x09, 0xB0, 0x97, 0x10, 0x9B, 0x09, 0x20, 0x79, 0x0F, 0x74, 0x09, 0xA0, 0xE0, 0x26,
  0x02, 0x0E, 0xA0, 0x94, 0x81, 0x77, 0x16, 0x81, 0x9E, 0x37, 0x18, 0x13, 0xE9, 0x60, 0x17, 0x10,
  0x27, 0x30, 0x28, 0x0A, 0xE4, 0x00, 0x27, 0x30, 0x27, 0x10, 0x16, 0x81, 0x9E, 0x37, 0x18, 0x13,
  0xE9, 0x68, 0x11, 0x77, 0x40, 0x9A, 0x0E, 0x02, 0x60, 0x20, 0xEA, 0x09, 0x40, 0xF7, 0x90, 0x72,
  0x09, 0xB0, 0x97, 0x10, 0x9B, 0x09, 0x28, 0x27, 0xF7, 0x7A, 0x07, 0x09, 0xB0, 0x97, 0x30, 0x9B,
  0x09, 0x07, 0xA0, 0x07, 0xE0, 0x97, 0x50, 0x9E, 0x00, 0x7D, 0x09, 0x77, 0x09, 0xD0, 0x07, 0xD0,
  0x77, 0x70, 0x7D, 0x00, 0x7E, 0x07, 0x75, 0x07, 0xE0, 0x07, 0xF0, 0x77, 0x30, 0x7F, 0x07, 0x03,
  0x80, 0x47, 0x01, 0x71, 0x01, 0x80, 0x47, 0x03,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_36_maps_zoom_out_map() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 31, 31), Box(0, 0, 35, 35),
      ic_filled_36_maps_zoom_out_map_data, Alpha4(color::Black));
  return value;
}
