#include "device.h"

using namespace roo_display;

// Image file ic_filled_24_device_1x_mobiledata 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_filled_24_device_1x_mobiledata_data[] PROGMEM = {
  0xC2, 0x82, 0x1E, 0xF4, 0x28, 0x1E, 0xF5, 0xC3, 0x85, 0x6F, 0xD0, 0x8F, 0xB3, 0xA4, 0x81, 0xCF,
  0xAA, 0x02, 0x3A, 0x40, 0x3B, 0x08, 0x4A, 0x58, 0x1A, 0xFE, 0x5A, 0x50, 0xEA, 0x04, 0x4A, 0x48,
  0x38, 0xFE, 0xFD, 0x4A, 0x30, 0x2A, 0x82, 0x2C, 0xF7, 0x3A, 0x38, 0x6B, 0xF8, 0x03, 0xFE, 0x22,
  0xA2, 0x81, 0x5F, 0xD3, 0x81, 0x9F, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_1x_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 18, 16), Box(0, 0, 23, 23),
      ic_filled_24_device_1x_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_30fps 24x24, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_filled_24_device_30fps_data[] PROGMEM = {
  0xE0, 0xD0, 0x83, 0x08, 0x0D, 0xC0, 0xD0, 0x81, 0xF9, 0x81, 0x80, 0x8F, 0x90, 0x8F, 0x98, 0x1D,
  0x0D, 0xF9, 0x0D, 0x6B, 0x1B, 0x4B, 0x6B, 0x1B, 0x4B, 0x18, 0x01, 0x7A, 0x0D, 0x1B, 0x4B, 0x1E,
  0x0D, 0x03, 0x1B, 0x4B, 0x1E, 0x0D, 0x03, 0x1B, 0x4B, 0x18, 0x01, 0x7A, 0x0D, 0x1B, 0x4B, 0x6B,
  0x1B, 0x4B, 0x6B, 0x1B, 0x4F, 0xC8, 0x1D, 0x0D, 0xF9, 0x0D, 0xF9, 0x81, 0x80, 0x8F, 0x90, 0x8E,
  0x0D, 0x08, 0x30, 0x80, 0xDC, 0x0D, 0x08, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_30fps() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 18), Box(0, 0, 23, 23),
      ic_filled_24_device_30fps_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_3g_mobiledata 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_filled_24_device_3g_mobiledata_data[] PROGMEM = {
  0xD0, 0xD0, 0x42, 0x04, 0x0D, 0xD0, 0xD0, 0x4E, 0x0D, 0x20, 0xDF, 0x0D, 0x5A, 0x2A, 0x75, 0xA2,
  0xA7, 0x1D, 0x08, 0x2A, 0x20, 0x7C, 0x1D, 0x08, 0x2A, 0x20, 0x7C, 0x5A, 0x2A, 0x5A, 0x5A, 0x2A,
  0x5F, 0x90, 0xD2, 0x0D, 0xF0, 0xDD, 0x0D, 0x04, 0x20, 0x40, 0xDD, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_3g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 16), Box(0, 0, 23, 23),
      ic_filled_24_device_3g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_4g_mobiledata 24x24, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_filled_24_device_4g_mobiledata_data[] PROGMEM = {
  0xA2, 0xA3, 0x04, 0x0D, 0xD0, 0xD0, 0x4A, 0x2A, 0x30, 0xDF, 0x0D, 0xA2, 0xA3, 0xA7, 0xA2, 0xA3,
  0xA7, 0xA2, 0xA3, 0xA3, 0xFD, 0x1A, 0x3F, 0xD1, 0xA5, 0xA4, 0xA3, 0xA5, 0xA4, 0xA3, 0x0D, 0xF0,
  0xD4, 0xA3, 0x04, 0x0D, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_4g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 16), Box(0, 0, 23, 23),
      ic_filled_24_device_4g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_4g_plus_mobiledata 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_filled_24_device_4g_plus_mobiledata_data[] PROGMEM = {
  0xA2, 0xA2, 0x04, 0x0D, 0xC0, 0xD0, 0x47, 0xA2, 0xA2, 0x0D, 0xE0, 0xD7, 0xA2, 0xA2, 0xA7, 0x2A,
  0x2A, 0x2A, 0x2A, 0x72, 0xA2, 0xA2, 0xA2, 0xA2, 0xC1, 0xFE, 0x1A, 0x2C, 0x1F, 0xE1, 0xA4, 0xA3,
  0xA6, 0xA2, 0xA4, 0xA3, 0xA6, 0xA2, 0x0D, 0xE0, 0xD7, 0x4A, 0x20, 0x40, 0xDC, 0x0D, 0x04, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_4g_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 23, 16), Box(0, 0, 23, 23),
      ic_filled_24_device_4g_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_60fps 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_filled_24_device_60fps_data[] PROGMEM = {
  0x10, 0x80, 0xDD, 0x30, 0x80, 0xDC, 0x82, 0xD8, 0x08, 0xF2, 0x08, 0xF9, 0x08, 0x0D, 0xF2, 0x0D,
  0xF9, 0x0D, 0xB7, 0xB4, 0xE7, 0xB4, 0xFA, 0x0D, 0x08, 0x2B, 0x4F, 0xC0, 0x81, 0xB4, 0xFC, 0x0D,
  0x1B, 0x4E, 0x3B, 0x1B, 0x4E, 0x3B, 0x1B, 0x4E, 0x3B, 0x1B, 0x4B, 0x0D, 0xF8, 0x1D, 0x0D, 0xF9,
  0x0D, 0x08, 0xF8, 0x18, 0x08, 0xF9, 0x82, 0x80, 0x8D, 0xB0, 0xD0, 0x83, 0x08, 0x0D, 0xC0, 0xD0,
  0x81,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_60fps() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 5, 21, 18), Box(0, 0, 23, 23),
      ic_filled_24_device_60fps_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_access_alarm 24x24, 4-bit Alpha,  RLE, 160 bytes.
static const unsigned char ic_filled_24_device_access_alarm_data[] PROGMEM = {
  0x38, 0x13, 0xD2, 0x71, 0x81, 0x2D, 0x35, 0x05, 0xA0, 0x97, 0x10, 0x9A, 0x05, 0x30, 0x8A, 0x89,
  0x28, 0x04, 0x9D, 0xEE, 0xD9, 0x40, 0x8A, 0x81, 0x80, 0xAA, 0x81, 0x52, 0xBF, 0x98, 0x1B, 0x26,
  0xA8, 0x90, 0xA5, 0xE3, 0x3E, 0xFE, 0x72, 0x28, 0x72, 0x7E, 0xFE, 0x33, 0xE5, 0x28, 0x22, 0xEF,
  0xA7, 0x18, 0x3A, 0xFE, 0x21, 0x38, 0x1B, 0xFA, 0x49, 0x07, 0x48, 0x1A, 0xFB, 0x38, 0x14, 0xFE,
  0x59, 0x07, 0x58, 0x1E, 0xF4, 0x28, 0x19, 0xF7, 0x59, 0x07, 0x58, 0x17, 0xF9, 0x28, 0x1D, 0xF2,
  0x59, 0x07, 0x58, 0x12, 0xFD, 0x20, 0xE9, 0x69, 0x07, 0x69, 0x0E, 0x20, 0xE9, 0x69, 0x0C, 0x02,
  0x59, 0x0E, 0x28, 0x1D, 0xF2, 0x58, 0x24, 0xDF, 0x83, 0x81, 0x2F, 0xD2, 0x81, 0x9F, 0x77, 0x86,
  0x7F, 0xE3, 0x07, 0xF9, 0x28, 0x14, 0xFE, 0x71, 0x02, 0x09, 0x28, 0x1E, 0xF4, 0x38, 0x1B, 0xFA,
  0x73, 0x81, 0xAF, 0xB4, 0x82, 0x2E, 0xFA, 0x71, 0x82, 0xAF, 0xE2, 0x58, 0x43, 0xEF, 0xE7, 0x22,
  0x84, 0x27, 0xEF, 0xE3, 0x70, 0x20, 0xBF, 0x90, 0xB0, 0x27, 0x38, 0x64, 0x9D, 0xEE, 0xD9, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_access_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_access_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_access_alarms 24x24, 4-bit Alpha,  RLE, 159 bytes.
static const unsigned char ic_filled_24_device_access_alarms_data[] PROGMEM = {
  0x38, 0x13, 0xD2, 0x71, 0x81, 0x3E, 0x45, 0x05, 0xA0, 0x97, 0x10, 0x8A, 0x06, 0x30, 0x8A, 0x89,
  0x28, 0x04, 0x9D, 0xEE, 0xD9, 0x40, 0x7A, 0x81, 0x80, 0xAA, 0x81, 0x52, 0xBF, 0x98, 0x95, 0xB2,
  0x5E, 0xFA, 0x4D, 0x33, 0xEF, 0xE7, 0x22, 0x87, 0x27, 0xEF, 0xE3, 0x3D, 0x42, 0x82, 0x2E, 0xFA,
  0x71, 0x82, 0xAF, 0xE2, 0x48, 0x1B, 0xFA, 0x49, 0x07, 0x48, 0x1A, 0xFB, 0x38, 0x14, 0xFE, 0x59,
  0x07, 0x58, 0x1E, 0xF4, 0x28, 0x19, 0xF7, 0x59, 0x07, 0x58, 0x17, 0xF9, 0x28, 0x1D, 0xF2, 0x59,
  0x07, 0x58, 0x12, 0xFD, 0x20, 0xE9, 0x69, 0x07, 0x69, 0x0E, 0x20, 0xE9, 0x69, 0x0B, 0x02, 0x59,
  0x0E, 0x28, 0x1D, 0xF2, 0x58, 0x24, 0xDF, 0x73, 0x81, 0x2F, 0xD2, 0x81, 0x9F, 0x77, 0x86, 0x8F,
  0xD3, 0x07, 0xF9, 0x28, 0x14, 0xFE, 0x71, 0x85, 0x2A, 0x10, 0xEF, 0x43, 0x81, 0xBF, 0xA7, 0x38,
  0x1A, 0xFB, 0x48, 0x22, 0xEF, 0xA7, 0x18, 0x2A, 0xFE, 0x25, 0x84, 0x3E, 0xFE, 0x72, 0x28, 0x42,
  0x7E, 0xFE, 0x37, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x73, 0x86, 0x49, 0xDE, 0xED, 0x94, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_access_alarms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_access_alarms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_access_time_filled 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_filled_24_device_access_time_filled_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xFF, 0xA0, 0x42, 0x0D, 0xF2, 0xF8, 0x1D, 0x05, 0xF9, 0x2F, 0x90, 0x50,
  0xAF, 0x92, 0xF9, 0x09, 0x0D, 0xF9, 0x2F, 0x90, 0xD0, 0xEF, 0x92, 0x0E, 0xF0, 0x0E, 0xF9, 0x82,
  0x20, 0x2E, 0xE0, 0xE0, 0xDF, 0x98, 0x3E, 0x20, 0x2E, 0xD0, 0xD0, 0xAF, 0xA8, 0x3E, 0x20, 0x2E,
  0xC0, 0x90, 0x5F, 0xB8, 0x2E, 0x20, 0x8C, 0x81, 0x50, 0xDF, 0xB0, 0xE0, 0x9C, 0x0D, 0x20, 0x4F,
  0xFA, 0x04, 0x30, 0x8F, 0xF0, 0x85, 0x08, 0xFD, 0x08, 0x70, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x38,
  0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_access_time_filled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_access_time_filled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_access_time 24x24, 4-bit Alpha,  RLE, 137 bytes.
static const unsigned char ic_filled_24_device_access_time_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x65, 0x90, 0x75, 0x85, 0x6F, 0xD0, 0x5F, 0xC6, 0x90, 0x76, 0x84, 0xCF,
  0x5A, 0xF6, 0x69, 0x07, 0x68, 0x46, 0xF9, 0xDF, 0x26, 0x90, 0x76, 0x82, 0x2F, 0xDE, 0x97, 0x90,
  0x77, 0x90, 0x0E, 0x97, 0x90, 0xC0, 0x26, 0x98, 0x2E, 0xDF, 0x26, 0x82, 0x4D, 0xF8, 0x48, 0x42,
  0xFD, 0xAF, 0x67, 0x18, 0x27, 0xFE, 0x52, 0x84, 0x6F, 0x95, 0xFC, 0x72, 0x81, 0x2A, 0xA2, 0x85,
  0xCF, 0x50, 0xDF, 0x67, 0x58, 0x16, 0xFD, 0x20, 0x4A, 0x04, 0x73, 0x04, 0xA0, 0x43, 0x08, 0xA0,
  0x67, 0x10, 0x6A, 0x08, 0x50, 0x8A, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCA, 0x08, 0x70, 0x50, 0xDF,
  0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_access_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_access_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_add_alarm 24x24, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_filled_24_device_add_alarm_data[] PROGMEM = {
  0x38, 0x13, 0xD2, 0x71, 0x81, 0x2D, 0x35, 0x05, 0xA0, 0x97, 0x10, 0x9A, 0x05, 0x30, 0x8A, 0x89,
  0x28, 0x04, 0x9D, 0xEE, 0xD9, 0x40, 0x8A, 0x81, 0x80, 0xAA, 0x81, 0x52, 0xBF, 0x98, 0x1B, 0x26,
  0xA8, 0x90, 0xA5, 0xE3, 0x3E, 0xFE, 0x72, 0x28, 0x72, 0x7E, 0xFE, 0x33, 0xE5, 0x28, 0x22, 0xEF,
  0xA7, 0x18, 0x3A, 0xFE, 0x21, 0x38, 0x1B, 0xFA, 0x73, 0x81, 0xAF, 0xB3, 0x81, 0x4F, 0xE5, 0xA5,
  0x81, 0xEF, 0x42, 0x81, 0x9F, 0x75, 0xA5, 0x81, 0x7F, 0x92, 0x81, 0xDF, 0x25, 0xA5, 0x81, 0x2F,
  0xD2, 0x0E, 0x93, 0xF9, 0x39, 0x0E, 0x20, 0xE9, 0x3F, 0x93, 0x90, 0xE2, 0x81, 0xDF, 0x25, 0xA5,
  0x81, 0x2F, 0xD2, 0x81, 0x9F, 0x75, 0xA5, 0x81, 0x7F, 0x92, 0x81, 0x4F, 0xE5, 0xA5, 0x81, 0xEF,
  0x43, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x48, 0x22, 0xEF, 0xA7, 0x18, 0x2A, 0xFE, 0x25, 0x84,
  0x3E, 0xFE, 0x72, 0x28, 0x42, 0x7E, 0xFE, 0x37, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x73, 0x86, 0x49,
  0xDE, 0xED, 0x94, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_add_alarm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_add_alarm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_add_to_home_screen 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_filled_24_device_add_to_home_screen_data[] PROGMEM = {
  0x30, 0x40, 0xDF, 0xB0, 0xD0, 0x43, 0x0D, 0xFD, 0x0D, 0x3F, 0xF3, 0xFF, 0x3A, 0x73, 0xA7, 0x71,
  0xA7, 0x71, 0xA2, 0xF6, 0xA2, 0xF6, 0xA4, 0x01, 0x0C, 0xB6, 0xA3, 0x82, 0x1C, 0xFC, 0xA6, 0xA2,
  0x83, 0x1C, 0xFC, 0x1A, 0x6A, 0x18, 0x31, 0xCF, 0xC1, 0x1A, 0x6A, 0x83, 0x1C, 0xFC, 0x12, 0xA6,
  0xA8, 0x2B, 0xFC, 0x17, 0x4A, 0x81, 0x2B, 0x17, 0x5A, 0x77, 0x1A, 0x3A, 0x73, 0xA3, 0xFF, 0x3F,
  0xF3, 0x0D, 0xFD, 0x0D, 0x30, 0x40, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_add_to_home_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 19, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_add_to_home_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_ad_units 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_filled_24_device_ad_units_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC1, 0xF9, 0x1C, 0x1F, 0x91,
  0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7,
  0x3F, 0xFF, 0xFA, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_ad_units() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_ad_units_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_airplanemode_active 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_filled_24_device_airplanemode_active_data[] PROGMEM = {
  0x71, 0x82, 0x2D, 0xD2, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07,
  0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x20, 0x7A, 0x07, 0x77, 0x10, 0x60, 0xEA,
  0x0E, 0x06, 0x75, 0x03, 0x0C, 0xE0, 0xC0, 0x37, 0x10, 0x10, 0x9F, 0xB0, 0x90, 0x15, 0x07, 0x0E,
  0xFD, 0x0E, 0x07, 0x20, 0x40, 0xDD, 0x00, 0xCA, 0x00, 0xCD, 0x0D, 0x04, 0xB8, 0x4E, 0xA5, 0x10,
  0x7A, 0x84, 0x70, 0x15, 0xAE, 0xB8, 0x1D, 0x84, 0x50, 0x7A, 0x07, 0x58, 0x14, 0x8D, 0x71, 0x07,
  0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x72, 0x07, 0xA0, 0x77, 0x71, 0x06, 0x0E, 0xA0, 0xE0, 0x67,
  0x60, 0xCE, 0x0C, 0x75, 0x86, 0xD9, 0x51, 0x15, 0x9D, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_airplanemode_active() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_airplanemode_active_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_airplanemode_inactive 24x24, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_filled_24_device_airplanemode_inactive_data[] PROGMEM = {
  0x72, 0x82, 0x2D, 0xD2, 0x71, 0x81, 0x1C, 0x76, 0x07, 0xA0, 0x77, 0x10, 0x4A, 0x07, 0x50, 0x7A,
  0x07, 0x72, 0x05, 0xA0, 0x74, 0x07, 0xA0, 0x77, 0x30, 0x5A, 0x07, 0x30, 0x7A, 0x07, 0x74, 0x05,
  0xA0, 0x72, 0x06, 0xA0, 0x77, 0x50, 0x5A, 0x07, 0x28, 0x1A, 0xF7, 0x76, 0x05, 0xA0, 0x72, 0x81,
  0xAE, 0x67, 0x60, 0x8A, 0x07, 0x28, 0x2A, 0xFC, 0x37, 0x20, 0x10, 0xAC, 0x07, 0x20, 0xAA, 0x09,
  0x01, 0x60, 0x70, 0xEE, 0x07, 0x20, 0xAA, 0x0E, 0x07, 0x30, 0x40, 0xDD, 0x00, 0xCA, 0x07, 0x20,
  0xAB, 0x0D, 0x04, 0x1B, 0x84, 0xEA, 0x51, 0x07, 0xB0, 0x72, 0x09, 0x0E, 0xB1, 0x81, 0xD8, 0x45,
  0x07, 0xC0, 0x73, 0x81, 0x48, 0xD7, 0x20, 0x7A, 0x0C, 0xA0, 0x77, 0x70, 0x7A, 0x07, 0x05, 0xA0,
  0x77, 0x60, 0x7A, 0x81, 0x70, 0x5A, 0x07, 0x74, 0x06, 0x0E, 0xA8, 0x2E, 0x60, 0x5A, 0x07, 0x72,
  0x0C, 0xE8, 0x1C, 0x05, 0xA0, 0x77, 0x18, 0x6D, 0x95, 0x11, 0x59, 0xD2, 0x81, 0x5F, 0xC7, 0x75,
  0x04, 0x01, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_airplanemode_inactive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_airplanemode_inactive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_airplane_ticket 24x24, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_filled_24_device_airplane_ticket_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1E, 0x5D, 0xFF, 0xC0, 0xD8, 0x0D, 0x3F, 0x81, 0xC6, 0xDF, 0xFB, 0x82,
  0xC0, 0x1D, 0xFA, 0x01, 0x0B, 0xE8, 0x26, 0x01, 0xCF, 0x91, 0x01, 0xE0, 0xE0, 0x12, 0x83, 0xBD,
  0x97, 0xEB, 0x10, 0x1B, 0x0B, 0x0C, 0xA0, 0x86, 0x0A, 0xB0, 0x10, 0xBB, 0x82, 0x90, 0x63, 0x48,
  0x11, 0x5A, 0xFB, 0x03, 0x38, 0x14, 0x8D, 0xFE, 0x81, 0xC7, 0xB8, 0x0D, 0x7F, 0x0D, 0xFF, 0xC8,
  0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_airplane_ticket() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_airplane_ticket_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_air 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_filled_24_device_air_data[] PROGMEM = {
  0x74, 0x83, 0x4C, 0xEC, 0x47, 0x70, 0x4D, 0x04, 0x76, 0x85, 0xCF, 0x70, 0x7F, 0xC7, 0x60, 0x07,
  0x39, 0x0E, 0x77, 0x38, 0x17, 0xFC, 0x3F, 0xFA, 0x04, 0x3F, 0xF0, 0xC0, 0x47, 0x77, 0x3F, 0xFB,
  0x0C, 0x04, 0x1F, 0xFD, 0x04, 0x77, 0x38, 0x17, 0xFC, 0xFB, 0x0B, 0x03, 0x69, 0x0E, 0xFC, 0x0E,
  0x01, 0x48, 0x17, 0xFC, 0x73, 0x81, 0xAF, 0x63, 0x07, 0xA0, 0x46, 0x85, 0x6F, 0xA0, 0xAF, 0x63,
  0x81, 0x7C, 0x47, 0x01, 0x0E, 0xB0, 0xE0, 0x17, 0x78, 0x33, 0xBE, 0xB3, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_air() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_air_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_aod 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_filled_24_device_aod_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C,
  0x1F, 0x91, 0xC1, 0x80, 0x47, 0x1C, 0x73, 0xC2, 0xE2, 0xC2, 0x80, 0x27, 0x2C, 0x73, 0xC7, 0x3C,
  0x73, 0x80, 0xD0, 0xF0, 0xDF, 0xD8, 0x1D, 0x4D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_aod() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_aod_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_0_bar 24x24, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_filled_24_device_battery_0_bar_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0xBF, 0x90, 0xBF, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6,
  0xC6, 0xC6, 0xC6, 0xC6, 0xFD, 0x0B, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_1_bar 24x24, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_filled_24_device_battery_1_bar_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0xBF, 0x90, 0xBF, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6,
  0xC6, 0xC6, 0xFF, 0xFF, 0xC0, 0xBF, 0x90, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_20 24x24, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_filled_24_device_battery_20_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x09, 0xE4, 0x48, 0x0C, 0x4F, 0x09,
  0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_20() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_20_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_2_bar 24x24, 4-bit Alpha,  RLE, 22 bytes.
static const unsigned char ic_filled_24_device_battery_2_bar_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0xBF, 0x90, 0xBF, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6,
  0x80, 0xE0, 0xF0, 0xBF, 0x90, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_30 24x24, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_filled_24_device_battery_30_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x09, 0xC0, 0x48, 0x0F, 0x0F, 0x09,
  0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_3_bar 24x24, 4-bit Alpha,  RLE, 20 bytes.
static const unsigned char ic_filled_24_device_battery_3_bar_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0xBF, 0x90, 0xBF, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x80, 0x98,
  0x4F, 0x0B, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_4_bar 24x24, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_filled_24_device_battery_4_bar_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0xBF, 0x90, 0xBF, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x80, 0x9B, 0x0F, 0x0B,
  0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_50 24x24, 4-bit Alpha,  RLE, 19 bytes.
static const unsigned char ic_filled_24_device_battery_50_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x09, 0x94, 0x48, 0x09, 0x94, 0xF0,
  0x9F, 0x90, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_50() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_50_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_5_bar 24x24, 4-bit Alpha,  RLE, 16 bytes.
static const unsigned char ic_filled_24_device_battery_5_bar_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0xBF, 0x90, 0xBF, 0xD6, 0xC6, 0xC6, 0xC6, 0x80, 0x9D, 0x4F, 0x0B, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_5_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_5_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_60 24x24, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_filled_24_device_battery_60_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0F, 0x04, 0x80, 0x9C, 0x0F, 0x09,
  0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_60() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_60_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_6_bar 24x24, 4-bit Alpha,  RLE, 14 bytes.
static const unsigned char ic_filled_24_device_battery_6_bar_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0xBF, 0x90, 0xBF, 0xD6, 0xC6, 0x80, 0xA8, 0x0F, 0x0B, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_6_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_6_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_80 24x24, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_filled_24_device_battery_80_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0C, 0x44, 0x80, 0x9E, 0x4F, 0x09,
  0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_80() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_80_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_90 24x24, 4-bit Alpha,  RLE, 18 bytes.
static const unsigned char ic_filled_24_device_battery_90_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0B, 0x24, 0x80, 0x9F, 0x6F, 0x09,
  0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_90() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_90_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_alert 24x24, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_filled_24_device_battery_alert_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0x9F, 0x90, 0x98, 0x0D, 0x0F, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0xFF,
  0xF2, 0xF9, 0x2F, 0xFF, 0xFE, 0x09, 0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_alert() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_alert_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_charging_20 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_filled_24_device_battery_charging_20_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0A, 0x54, 0x03, 0x80, 0x54, 0x18,
  0x04, 0x40, 0x31, 0x80, 0x44, 0x28, 0x03, 0x40, 0x22, 0x80, 0x34, 0x38, 0x52, 0x24, 0x44, 0x42,
  0x48, 0x52, 0x44, 0x44, 0x22, 0x38, 0x03, 0x42, 0x02, 0x80, 0x34, 0x28, 0x00, 0x4C, 0x10, 0xAF,
  0x90, 0x3F, 0xA0, 0xBF, 0xF9, 0x09, 0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_charging_20() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_charging_20_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_charging_30 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_filled_24_device_battery_charging_30_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0A, 0x54, 0x03, 0x80, 0x54, 0x18,
  0x04, 0x40, 0x31, 0x80, 0x44, 0x28, 0x03, 0x40, 0x22, 0x80, 0x34, 0x38, 0x52, 0x24, 0x44, 0x42,
  0x48, 0x52, 0x44, 0x88, 0x77, 0x20, 0x10, 0xF8, 0xC2, 0x09, 0xF1, 0x02, 0xF9, 0x10, 0xAF, 0x90,
  0x3F, 0xA0, 0xBF, 0xF9, 0x09, 0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_charging_30() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_charging_30_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_charging_50 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_filled_24_device_battery_charging_50_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0A, 0x54, 0x03, 0x80, 0x54, 0x18,
  0x04, 0x40, 0x31, 0x80, 0x44, 0x28, 0x03, 0x40, 0x22, 0x80, 0x34, 0x38, 0x52, 0x24, 0x48, 0x84,
  0x48, 0x15, 0x88, 0xA0, 0x80, 0x72, 0x01, 0x0E, 0xE2, 0x09, 0xF1, 0x02, 0xF9, 0x10, 0xAF, 0x90,
  0x3F, 0xA0, 0xBF, 0xF9, 0x09, 0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_charging_50() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_charging_50_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_charging_60 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_filled_24_device_battery_charging_60_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0A, 0x54, 0x03, 0x80, 0x54, 0x18,
  0x04, 0x40, 0x31, 0x80, 0x44, 0x28, 0x00, 0x4B, 0x09, 0x2E, 0x0E, 0x01, 0x20, 0x70, 0x8C, 0x08,
  0x40, 0x8C, 0x08, 0x07, 0x20, 0x10, 0xEE, 0x20, 0x9F, 0x10, 0x2F, 0x91, 0x0A, 0xF9, 0x03, 0xFA,
  0x0B, 0xFF, 0x90, 0x9F, 0x90, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_charging_60() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_charging_60_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_charging_80 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_24_device_battery_charging_80_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0A, 0x54, 0x03, 0x80, 0x54, 0x18,
  0x00, 0x4C, 0x0A, 0x1F, 0x90, 0x21, 0xF0, 0x92, 0xE0, 0xE0, 0x12, 0x07, 0x08, 0xC0, 0x84, 0x08,
  0xC0, 0x80, 0x72, 0x01, 0x0E, 0xE2, 0x09, 0xF1, 0x02, 0xF9, 0x10, 0xAF, 0x90, 0x3F, 0xA0, 0xBF,
  0xF9, 0x09, 0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_charging_80() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_charging_80_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_charging_90 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_24_device_battery_charging_90_data[] PROGMEM = {
  0x38, 0x00, 0x46, 0x80, 0x04, 0x30, 0x28, 0x04, 0x40, 0x28, 0x0A, 0x54, 0x03, 0x80, 0x04, 0xD0,
  0x3F, 0x90, 0xA1, 0xF9, 0x02, 0x1F, 0x09, 0x2E, 0x0E, 0x01, 0x20, 0x70, 0x8C, 0x08, 0x40, 0x8C,
  0x08, 0x07, 0x20, 0x10, 0xEE, 0x20, 0x9F, 0x10, 0x2F, 0x91, 0x0A, 0xF9, 0x03, 0xFA, 0x0B, 0xFF,
  0x90, 0x9F, 0x90, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_charging_90() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_charging_90_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_charging_full 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_filled_24_device_battery_charging_full_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0x9F, 0x90, 0x9F, 0xFF, 0xC0, 0xBF, 0xA0, 0x3F, 0x90, 0xA1, 0xF9, 0x02, 0x1F,
  0x09, 0x2E, 0x0E, 0x01, 0x20, 0x70, 0x8C, 0x08, 0x40, 0x8C, 0x08, 0x07, 0x20, 0x10, 0xEE, 0x20,
  0x9F, 0x10, 0x2F, 0x91, 0x0A, 0xF9, 0x03, 0xFA, 0x0B, 0xFF, 0x90, 0x9F, 0x90, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_charging_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_charging_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_full 24x24, 4-bit Alpha,  RLE, 12 bytes.
static const unsigned char ic_filled_24_device_battery_full_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0x9F, 0x90, 0x98, 0x0A, 0xB4, 0xF0, 0x9F, 0x90, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_full() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_full_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_saver 24x24, 4-bit Alpha,  RLE, 20 bytes.
static const unsigned char ic_filled_24_device_battery_saver_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0xBF, 0x90, 0xB8, 0x0E, 0x2F, 0x2F, 0x92, 0xE6, 0xC6, 0xE2, 0xF9, 0x28, 0x0E,
  0x2F, 0x0B, 0xF9, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_saver() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_saver_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_std 24x24, 4-bit Alpha,  RLE, 12 bytes.
static const unsigned char ic_filled_24_device_battery_std_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0x9F, 0x90, 0x98, 0x0A, 0xB4, 0xF0, 0x9F, 0x90, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_std() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_std_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_battery_unknown 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_filled_24_device_battery_unknown_data[] PROGMEM = {
  0x3C, 0x6C, 0x30, 0x9F, 0x90, 0x9F, 0xFF, 0xFD, 0x82, 0x71, 0x17, 0xD8, 0x47, 0x05, 0x50, 0x7C,
  0x01, 0x05, 0xA0, 0x50, 0x1F, 0x90, 0x50, 0x1F, 0x81, 0x90, 0x9E, 0x81, 0xB0, 0x6F, 0x05, 0x01,
  0xFF, 0xC2, 0xF9, 0x2F, 0xFF, 0xFE, 0x09, 0xF9, 0x09,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_battery_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_battery_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_bloodtype 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_filled_24_device_bloodtype_data[] PROGMEM = {
  0x70, 0x08, 0x76, 0x0A, 0xA0, 0xA7, 0x40, 0xAC, 0x0A, 0x72, 0x0A, 0xE0, 0xA7, 0x08, 0xF9, 0x08,
  0x50, 0x5F, 0xB0, 0x53, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x20, 0xAD, 0x2D, 0x81, 0xA0, 0x2E, 0x2E,
  0x02, 0x09, 0xC6, 0xC0, 0x90, 0xDC, 0x6C, 0x0D, 0x0E, 0xE2, 0xE0, 0x0E, 0xE2, 0xE0, 0xE0, 0xCF,
  0xF0, 0xC0, 0x8C, 0x6C, 0x08, 0x02, 0xC6, 0xC8, 0x12, 0x09, 0xFD, 0x09, 0x30, 0xBF, 0xB0, 0xB5,
  0x09, 0xF9, 0x09, 0x78, 0x62, 0x8C, 0xEE, 0xC8, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_bloodtype() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_bloodtype_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_bluetooth_connected 24x24, 4-bit Alpha,  RLE, 127 bytes.
static const unsigned char ic_filled_24_device_bluetooth_connected_data[] PROGMEM = {
  0x71, 0x90, 0x77, 0x72, 0xA0, 0x77, 0x71, 0xB0, 0x77, 0x18, 0x12, 0xB1, 0x3C, 0x07, 0x78, 0x2B,
  0xFC, 0x12, 0xA0, 0x5A, 0x07, 0x68, 0x31, 0xCF, 0xC1, 0x1A, 0x10, 0x6A, 0x06, 0x68, 0x31, 0xCF,
  0xC1, 0xA8, 0x31, 0xCF, 0xC1, 0x78, 0x21, 0xCF, 0xCA, 0x82, 0xCF, 0xC1, 0x50, 0x07, 0x20, 0x10,
  0xCC, 0x0C, 0x01, 0x28, 0x27, 0x70, 0x7A, 0x07, 0x20, 0x10, 0xCA, 0x0C, 0x01, 0x20, 0x7A, 0x00,
  0x7A, 0x07, 0x20, 0x10, 0xCA, 0x0C, 0x01, 0x20, 0x7A, 0x82, 0x70, 0x77, 0x20, 0x10, 0xCC, 0x0C,
  0x01, 0x20, 0x07, 0x58, 0x21, 0xCF, 0xCA, 0x82, 0xCF, 0xC1, 0x78, 0x31, 0xCF, 0xC1, 0xA8, 0x31,
  0xCF, 0xC1, 0x58, 0x31, 0xCF, 0xC1, 0x1A, 0x10, 0x6A, 0x06, 0x58, 0x2B, 0xFC, 0x12, 0xA0, 0x5A,
  0x07, 0x68, 0x12, 0xB1, 0x3C, 0x07, 0x76, 0xB0, 0x77, 0x7A, 0x07, 0x77, 0x19, 0x07, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_bluetooth_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_bluetooth_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_bluetooth_disabled 24x24, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_filled_24_device_bluetooth_disabled_data[] PROGMEM = {
  0x79, 0x07, 0x77, 0xA0, 0x76, 0x81, 0x2B, 0x14, 0xB0, 0x75, 0x82, 0xBF, 0xC1, 0x3C, 0x07, 0x48,
  0x31, 0xCF, 0xC1, 0x2A, 0x05, 0xA0, 0x74, 0x89, 0x01, 0xCF, 0xC1, 0x08, 0xF0, 0x6A, 0x06, 0x48,
  0x92, 0x1C, 0xFC, 0x10, 0x81, 0xCF, 0xC1, 0x58, 0x90, 0x1C, 0xFC, 0x10, 0x6F, 0xC1, 0x78, 0x61,
  0xCF, 0xC1, 0x06, 0x17, 0x28, 0x31, 0xCF, 0xC1, 0x74, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x20, 0x10,
  0xCC, 0x0C, 0x01, 0x78, 0x21, 0xCF, 0xCA, 0x82, 0xCF, 0xC1, 0x58, 0x31, 0xCF, 0xC1, 0xA8, 0x31,
  0xCF, 0xC1, 0x38, 0x31, 0xCF, 0xC1, 0x1A, 0x10, 0x6A, 0x0C, 0x01, 0x28, 0x2B, 0xFC, 0x12, 0xA0,
  0x5A, 0x86, 0xEF, 0xC1, 0x02, 0xB1, 0x3C, 0x83, 0x71, 0xCF, 0xB7, 0xB0, 0x72, 0x81, 0x1B, 0x27,
  0xA0, 0x77, 0x69, 0x07, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_bluetooth_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_bluetooth_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_bluetooth_drive 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_filled_24_device_bluetooth_drive_data[] PROGMEM = {
  0x77, 0x20, 0x50, 0x97, 0x72, 0x83, 0x30, 0x5F, 0x97, 0x78, 0x51, 0xD5, 0x5A, 0xB9, 0x77, 0x84,
  0x2D, 0xAC, 0xD5, 0x20, 0x70, 0xEF, 0xA2, 0x82, 0x2D, 0xF5, 0x20, 0x1F, 0xC2, 0x82, 0x2D, 0xF5,
  0x28, 0x16, 0xFA, 0x73, 0x89, 0x02, 0xDA, 0xCD, 0x50, 0xCF, 0x57, 0x28, 0x90, 0x1D, 0x55, 0xAB,
  0x92, 0xFE, 0x74, 0x85, 0x30, 0x5F, 0x90, 0x7F, 0xD0, 0x12, 0x05, 0x09, 0x20, 0xCF, 0xD0, 0xB0,
  0x15, 0xFF, 0xC2, 0xB8, 0x17, 0x07, 0xE8, 0x17, 0x07, 0xB2, 0xB3, 0xE3, 0xB2, 0xB8, 0x17, 0x07,
  0xE8, 0x17, 0x07, 0xB2, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF, 0xC2, 0xB7, 0x5B, 0x28, 0x1B, 0xFB, 0x75,
  0x81, 0xBF, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_bluetooth_drive() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_bluetooth_drive_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_bluetooth 24x24, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_filled_24_device_bluetooth_data[] PROGMEM = {
  0x69, 0x07, 0x74, 0xA0, 0x77, 0x3B, 0x07, 0x38, 0x12, 0xB1, 0x3C, 0x07, 0x28, 0x2B, 0xFC, 0x12,
  0xA0, 0x5A, 0x85, 0x70, 0x1C, 0xFC, 0x11, 0xA1, 0x06, 0xA8, 0x56, 0x01, 0xCF, 0xC1, 0xA8, 0x31,
  0xCF, 0xC1, 0x28, 0x21, 0xCF, 0xCA, 0x82, 0xCF, 0xC1, 0x40, 0x10, 0xCC, 0x0C, 0x01, 0x60, 0x10,
  0xCA, 0x0C, 0x01, 0x70, 0x10, 0xCA, 0x0C, 0x01, 0x60, 0x10, 0xCC, 0x0C, 0x01, 0x48, 0x21, 0xCF,
  0xCA, 0x82, 0xCF, 0xC1, 0x28, 0x31, 0xCF, 0xC1, 0xA8, 0x90, 0x1C, 0xFC, 0x11, 0xCF, 0xC1, 0x1A,
  0x10, 0x6A, 0x83, 0x6B, 0xFC, 0x12, 0xA0, 0x5A, 0x83, 0x70, 0x2B, 0x13, 0xC0, 0x77, 0x1B, 0x07,
  0x72, 0xA0, 0x77, 0x39, 0x07, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_bluetooth() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 17, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_bluetooth_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_bluetooth_searching 24x24, 4-bit Alpha,  RLE, 139 bytes.
static const unsigned char ic_filled_24_device_bluetooth_searching_data[] PROGMEM = {
  0x69, 0x07, 0x77, 0x2A, 0x07, 0x77, 0x1B, 0x07, 0x71, 0x81, 0x2B, 0x13, 0xC0, 0x77, 0x82, 0xBF,
  0xC1, 0x2A, 0x05, 0xA0, 0x74, 0x85, 0x10, 0x1C, 0xFC, 0x11, 0xA1, 0x06, 0xA0, 0x62, 0x04, 0x0D,
  0x28, 0x31, 0xCF, 0xC1, 0xA8, 0x31, 0xCF, 0xC1, 0x28, 0x18, 0xF5, 0x28, 0x21, 0xCF, 0xCA, 0x82,
  0xCF, 0xC1, 0x38, 0x12, 0xFA, 0x30, 0x10, 0xCC, 0x83, 0xC1, 0x04, 0xB2, 0x0E, 0x0D, 0x40, 0x10,
  0xCA, 0x84, 0xC1, 0x04, 0xFE, 0x20, 0xC9, 0x40, 0x10, 0xCA, 0x84, 0xC1, 0x04, 0xFE, 0x20, 0xC0,
  0xE3, 0x01, 0x0C, 0xC8, 0x3C, 0x10, 0x4B, 0x20, 0xE0, 0xD2, 0x82, 0x1C, 0xFC, 0xA8, 0x96, 0xCF,
  0xC1, 0x01, 0x02, 0xF9, 0x01, 0xCF, 0xC1, 0xA8, 0x31, 0xCF, 0xC1, 0x28, 0x68, 0xF4, 0x1C, 0xFC,
  0x11, 0xA1, 0x06, 0xA0, 0x62, 0x85, 0x4C, 0x0B, 0xFC, 0x12, 0xA0, 0x5A, 0x07, 0x68, 0x12, 0xB1,
  0x3C, 0x07, 0x76, 0xB0, 0x77, 0x7A, 0x07, 0x77, 0x19, 0x07, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_bluetooth_searching() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_bluetooth_searching_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_brightness_auto 24x24, 4-bit Alpha,  RLE, 95 bytes.
static const unsigned char ic_filled_24_device_brightness_auto_data[] PROGMEM = {
  0x73, 0x00, 0xB7, 0x75, 0x0B, 0xA0, 0xB7, 0x73, 0x0B, 0xC0, 0xB7, 0x4F, 0xFA, 0x6F, 0xFA, 0x6F,
  0xFA, 0x6E, 0x0C, 0x20, 0xCE, 0x6E, 0x07, 0x20, 0x7E, 0x50, 0xBE, 0x82, 0x12, 0x21, 0xE0, 0xB3,
  0x0B, 0xE8, 0x4B, 0x07, 0x70, 0xBE, 0x81, 0xB0, 0xBF, 0x84, 0x60, 0xCC, 0x06, 0xF0, 0x0B, 0xF8,
  0x41, 0x09, 0x90, 0x1F, 0x81, 0xB0, 0xBD, 0x0A, 0x60, 0xAD, 0x0B, 0x30, 0xBC, 0x81, 0x50, 0xBA,
  0x81, 0xB0, 0x5C, 0x0B, 0x5B, 0x81, 0xE0, 0x1C, 0x81, 0x10, 0xEB, 0x6F, 0xFA, 0x6F, 0xFA, 0x6F,
  0xFA, 0x6F, 0xFA, 0x74, 0x0B, 0xC0, 0xB7, 0x73, 0x0B, 0xA0, 0xB7, 0x75, 0x00, 0xB7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_brightness_auto() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_brightness_auto_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_brightness_high 24x24, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_filled_24_device_brightness_high_data[] PROGMEM = {
  0x73, 0x00, 0xB7, 0x75, 0x0B, 0xA0, 0xB7, 0x73, 0x0B, 0xC0, 0xB7, 0x4F, 0xFA, 0x6F, 0xFA, 0x6D,
  0x08, 0x03, 0x20, 0x30, 0x8D, 0x6B, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x6B, 0x89, 0x02, 0x01, 0xAD,
  0xDA, 0x10, 0x2B, 0x50, 0xBA, 0x82, 0x80, 0x1E, 0xC8, 0x2E, 0x10, 0x8A, 0x0B, 0x30, 0xBB, 0x81,
  0x30, 0xAE, 0x81, 0xA0, 0x3B, 0x81, 0xB0, 0xBC, 0x20, 0xDE, 0x0D, 0x2C, 0x00, 0xBC, 0x20, 0xDE,
  0x0D, 0x2C, 0x81, 0xB0, 0xBB, 0x81, 0x30, 0xAE, 0x81, 0xA0, 0x3B, 0x0B, 0x30, 0xBA, 0x82, 0x80,
  0x1E, 0xC8, 0x2E, 0x10, 0x8A, 0x0B, 0x5B, 0x89, 0x02, 0x01, 0xAD, 0xDA, 0x10, 0x2B, 0x6B, 0x0D,
  0x02, 0x60, 0x20, 0xDB, 0x6D, 0x08, 0x03, 0x20, 0x30, 0x8D, 0x6F, 0xFA, 0x6F, 0xFA, 0x74, 0x0B,
  0xC0, 0xB7, 0x73, 0x0B, 0xA0, 0xB7, 0x75, 0x00, 0xB7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_brightness_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_brightness_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_brightness_low 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_filled_24_device_brightness_low_data[] PROGMEM = {
  0x73, 0x00, 0xB7, 0x75, 0x0B, 0xA0, 0xB7, 0x73, 0x0B, 0xC0, 0xB7, 0x4F, 0xFA, 0x6F, 0xFA, 0x6D,
  0x08, 0x03, 0x20, 0x30, 0x8D, 0x6B, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x6B, 0x02, 0x71, 0x02, 0xB5,
  0x0B, 0xA0, 0x87, 0x30, 0x8A, 0x0B, 0x30, 0xBB, 0x03, 0x73, 0x03, 0xB8, 0x1B, 0x0B, 0xC7, 0x5C,
  0x00, 0xBC, 0x75, 0xC8, 0x1B, 0x0B, 0xB0, 0x37, 0x30, 0x3B, 0x0B, 0x30, 0xBA, 0x08, 0x73, 0x08,
  0xA0, 0xB5, 0xB0, 0x27, 0x10, 0x2B, 0x6B, 0x0D, 0x02, 0x60, 0x20, 0xDB, 0x6D, 0x08, 0x03, 0x20,
  0x30, 0x8D, 0x6F, 0xFA, 0x6F, 0xFA, 0x74, 0x0B, 0xC0, 0xB7, 0x73, 0x0B, 0xA0, 0xB7, 0x75, 0x00,
  0xB7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_brightness_low() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_brightness_low_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_brightness_medium 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_filled_24_device_brightness_medium_data[] PROGMEM = {
  0x73, 0x00, 0xB7, 0x75, 0x0B, 0xA0, 0xB7, 0x73, 0x0B, 0xC0, 0xB7, 0x4F, 0xFA, 0x6F, 0xFA, 0x6F,
  0x91, 0x03, 0x08, 0xD6, 0xF9, 0x30, 0x20, 0xDB, 0x6F, 0x94, 0x02, 0xB5, 0x0B, 0xF9, 0x50, 0x8A,
  0x0B, 0x30, 0xBF, 0xA5, 0x03, 0xB8, 0x1B, 0x0B, 0xFB, 0x6C, 0x00, 0xBF, 0xB6, 0xC8, 0x1B, 0x0B,
  0xFA, 0x50, 0x3B, 0x0B, 0x30, 0xBF, 0x95, 0x08, 0xA0, 0xB5, 0xF9, 0x40, 0x2B, 0x6F, 0x93, 0x02,
  0x0D, 0xB6, 0xF9, 0x10, 0x30, 0x8D, 0x6F, 0xFA, 0x6F, 0xFA, 0x74, 0x0B, 0xC0, 0xB7, 0x73, 0x0B,
  0xA0, 0xB7, 0x75, 0x00, 0xB7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_brightness_medium() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_brightness_medium_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_cable 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_filled_24_device_cable_data[] PROGMEM = {
  0x38, 0x41, 0xAD, 0xDA, 0x14, 0x0B, 0xA0, 0xB3, 0x01, 0x0E, 0xC0, 0xE0, 0x13, 0xC3, 0x86, 0xAF,
  0xB1, 0x1B, 0xFA, 0x2E, 0x28, 0x1D, 0xF1, 0x28, 0x11, 0xFD, 0x2E, 0x2A, 0x4A, 0x2E, 0x2A, 0x4A,
  0x2E, 0x2A, 0x4A, 0x20, 0xBC, 0x0B, 0x2A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A,
  0x4A, 0x4A, 0x20, 0xBC, 0x0B, 0x2A, 0x4A, 0x2E, 0x2A, 0x4A, 0x2E, 0x2A, 0x4A, 0x2E, 0x28, 0x1D,
  0xF1, 0x28, 0x11, 0xFD, 0x2E, 0x28, 0x6A, 0xFB, 0x11, 0xBF, 0xA3, 0xC3, 0x01, 0x0E, 0xC0, 0xE0,
  0x13, 0x0B, 0xA0, 0xB4, 0x84, 0x1A, 0xDD, 0xA1, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_cable() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_cable_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_cameraswitch 24x24, 4-bit Alpha,  RLE, 147 bytes.
static const unsigned char ic_filled_24_device_cameraswitch_data[] PROGMEM = {
  0x71, 0x87, 0x1A, 0xCF, 0xDD, 0xA6, 0x17, 0x72, 0x06, 0xF0, 0x90, 0x17, 0x71, 0x06, 0xA8, 0x52,
  0x49, 0xEF, 0xE5, 0x77, 0x10, 0x69, 0x30, 0x10, 0x9A, 0x07, 0x77, 0x10, 0x65, 0x06, 0xA0, 0x57,
  0x77, 0x82, 0x6F, 0xE2, 0x73, 0x07, 0xC0, 0x75, 0x81, 0x9F, 0xA7, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
  0x28, 0x21, 0xEF, 0x26, 0x0D, 0xFB, 0x0D, 0x38, 0x19, 0xF7, 0x6F, 0xD3, 0x81, 0x4F, 0xA6, 0xC8,
  0x2B, 0x11, 0xBC, 0x38, 0x11, 0xFD, 0x6C, 0x01, 0x20, 0x1C, 0x75, 0xC0, 0x12, 0x01, 0xC6, 0x81,
  0xDF, 0x13, 0xC8, 0x2B, 0x11, 0xBC, 0x68, 0x1A, 0xF4, 0x3F, 0xD6, 0x81, 0x7F, 0x93, 0x0D, 0xFB,
  0x0D, 0x68, 0x22, 0xFE, 0x12, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x78, 0x1A, 0xF9, 0x77, 0x78, 0x22,
  0xEF, 0x67, 0x77, 0x05, 0xA0, 0x65, 0x06, 0x77, 0x10, 0x7A, 0x09, 0x01, 0x39, 0x06, 0x77, 0x18,
  0x55, 0xEF, 0xE9, 0x42, 0xA0, 0x67, 0x71, 0x01, 0x09, 0xF0, 0x67, 0x72, 0x87, 0x16, 0xAD, 0xDF,
  0xCA, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_cameraswitch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 23, 23), Box(0, 0, 23, 23),
      ic_filled_24_device_cameraswitch_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_credit_score 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_24_device_credit_score_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x77, 0x2C, 0x77, 0x28, 0x09, 0xA0, 0xF7,
  0x74, 0xA7, 0x72, 0x03, 0x1A, 0x77, 0x18, 0x16, 0xF8, 0xA7, 0x70, 0x6A, 0x06, 0xA7, 0x02, 0x04,
  0x40, 0x6A, 0x06, 0x1A, 0x68, 0x21, 0xDF, 0x42, 0x06, 0xA0, 0x62, 0x0D, 0xE2, 0x08, 0xA0, 0x40,
  0x6A, 0x06, 0x30, 0x40, 0xDD, 0x30, 0x8C, 0x06, 0x77, 0x10, 0x8A, 0x06, 0x77, 0x30, 0x80, 0x66,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_credit_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_credit_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_dark_mode 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_24_device_dark_mode_data[] PROGMEM = {
  0x58, 0x34, 0x9D, 0xEC, 0x74, 0x02, 0x0B, 0xB0, 0xE0, 0x17, 0x30, 0x30, 0xEC, 0x08, 0x73, 0x02,
  0x0E, 0xD0, 0x37, 0x30, 0xBE, 0x01, 0x72, 0x04, 0xF0, 0x37, 0x20, 0x9F, 0x07, 0x72, 0x0D, 0xF0,
  0xE0, 0x17, 0x01, 0x0E, 0xF9, 0x0C, 0x01, 0x58, 0x11, 0xCE, 0xFA, 0x87, 0xE7, 0x31, 0x38, 0xEE,
  0xDF, 0xFA, 0x0D, 0x09, 0xFF, 0xA0, 0x90, 0x4F, 0xFA, 0x81, 0x40, 0xBF, 0xF0, 0xB2, 0x02, 0x0E,
  0xFD, 0x0E, 0x02, 0x30, 0x30, 0xEF, 0xB0, 0xE0, 0x35, 0x02, 0x0B, 0xF9, 0x0B, 0x02, 0x71, 0x86,
  0x49, 0xDE, 0xED, 0x94, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_dark_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_dark_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_data_saver_off 24x24, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_filled_24_device_data_saver_off_data[] PROGMEM = {
  0x68, 0x15, 0xAD, 0x28, 0x1D, 0xA5, 0x73, 0x04, 0x0D, 0xB2, 0xB0, 0xD0, 0x47, 0x08, 0xD2, 0xD0,
  0x85, 0x08, 0xB8, 0x1E, 0x73, 0x28, 0x13, 0x7E, 0xB0, 0x83, 0x05, 0xB0, 0xA0, 0x16, 0x01, 0x0A,
  0xB0, 0x42, 0x0D, 0xA0, 0xA7, 0x30, 0xAA, 0x81, 0xD0, 0x5A, 0x0E, 0x75, 0x0E, 0xA0, 0x50, 0x9A,
  0x07, 0x75, 0x07, 0xA0, 0x90, 0xDA, 0x02, 0x75, 0x02, 0xA0, 0xD0, 0xEA, 0x77, 0xA0, 0x0E, 0xA7,
  0x7A, 0x0E, 0x0D, 0xA0, 0x27, 0x50, 0x2A, 0x0C, 0x0A, 0xA0, 0x77, 0x50, 0x4A, 0x09, 0x05, 0xA0,
  0xE7, 0x68, 0x32, 0xA4, 0x0D, 0xA0, 0xA7, 0x30, 0x60, 0x14, 0x04, 0xB0, 0xA7, 0x83, 0x1A, 0xFE,
  0x64, 0x08, 0xB8, 0x1E, 0x72, 0x28, 0x12, 0x7E, 0xB0, 0x75, 0x08, 0xFD, 0x08, 0x70, 0x50, 0xDF,
  0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xCA, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_data_saver_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_data_saver_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_data_saver_on 24x24, 4-bit Alpha,  RLE, 126 bytes.
static const unsigned char ic_filled_24_device_data_saver_on_data[] PROGMEM = {
  0x68, 0x15, 0xAD, 0x28, 0x1D, 0xA5, 0x73, 0x04, 0x0D, 0xB2, 0xB0, 0xD0, 0x47, 0x08, 0xD2, 0xD0,
  0x85, 0x08, 0xB8, 0x1E, 0x73, 0x28, 0x13, 0x7E, 0xB0, 0x83, 0x05, 0xB0, 0xA0, 0x16, 0x01, 0x0A,
  0xB0, 0x42, 0x0D, 0xA0, 0xA7, 0x30, 0xAA, 0x81, 0xD0, 0x5A, 0x0E, 0x5A, 0x50, 0xEA, 0x05, 0x09,
  0xA0, 0x75, 0xA5, 0x07, 0xA0, 0x90, 0xDA, 0x02, 0x5A, 0x50, 0x2A, 0x0D, 0x0E, 0xA3, 0xF9, 0x3A,
  0x00, 0xEA, 0x3F, 0x93, 0xA0, 0xE0, 0xDA, 0x02, 0x5A, 0x50, 0x2A, 0x0C, 0x0A, 0xA0, 0x75, 0xA5,
  0x04, 0xA0, 0x90, 0x5A, 0x0E, 0x5A, 0x68, 0x32, 0xA4, 0x0D, 0xA0, 0xA7, 0x30, 0x60, 0x14, 0x04,
  0xB0, 0xA7, 0x83, 0x1A, 0xFE, 0x64, 0x08, 0xB8, 0x1E, 0x72, 0x28, 0x12, 0x7E, 0xB0, 0x75, 0x08,
  0xFD, 0x08, 0x70, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xCA, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_data_saver_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_data_saver_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_dataset_linked 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_filled_24_device_dataset_linked_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x0D, 0x04, 0x30, 0xDF, 0xFA, 0x0D, 0x3F, 0xFC, 0x3F, 0xFC, 0x3C, 0x4A, 0x4C,
  0x3C, 0x4A, 0x4C, 0x3C, 0x4A, 0x4C, 0x3C, 0x4A, 0x4C, 0x3F, 0xFC, 0x3F, 0x98, 0x19, 0x31, 0x73,
  0xC7, 0x73, 0xC4, 0x81, 0x1A, 0xDA, 0x2A, 0x81, 0xDA, 0x11, 0xC3, 0x01, 0x0E, 0xC2, 0xC0, 0xE0,
  0x1C, 0x38, 0x2A, 0xFB, 0x16, 0x82, 0x1B, 0xFA, 0xD2, 0x81, 0xDF, 0x11, 0xE1, 0x81, 0x1F, 0xDD,
  0x83, 0x10, 0xDF, 0x11, 0xE1, 0x82, 0x1F, 0xDD, 0xC8, 0x43, 0x0A, 0xFB, 0x16, 0x84, 0x1B, 0xFA,
  0x4D, 0xB8, 0x29, 0x01, 0xEC, 0x2C, 0x0E, 0x01, 0x71, 0x81, 0x1A, 0xDA, 0x2A, 0x81, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_dataset_linked() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_dataset_linked_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_dataset 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_filled_24_device_dataset_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xC4, 0xF4, 0xA4, 0xF9, 0x4A, 0x4F, 0x94,
  0xA4, 0xF9, 0x4A, 0x48, 0x0D, 0x0F, 0x4A, 0x4F, 0x94, 0xA4, 0xF9, 0x4A, 0x4F, 0x94, 0xA4, 0x80,
  0xC4, 0xF0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_dataset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_dataset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_data_usage 24x24, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_filled_24_device_data_usage_data[] PROGMEM = {
  0x68, 0x15, 0xAD, 0x28, 0x1D, 0xA5, 0x73, 0x04, 0x0D, 0xB2, 0xB0, 0xD0, 0x47, 0x08, 0xD2, 0xD0,
  0x85, 0x08, 0xB8, 0x1E, 0x73, 0x28, 0x13, 0x7E, 0xB0, 0x83, 0x05, 0xB0, 0xA0, 0x16, 0x01, 0x0A,
  0xB0, 0x42, 0x0D, 0xA0, 0xA7, 0x30, 0xAA, 0x81, 0xD0, 0x5A, 0x0E, 0x75, 0x0E, 0xA0, 0x50, 0x9A,
  0x07, 0x75, 0x07, 0xA0, 0x90, 0xDA, 0x02, 0x75, 0x02, 0xA0, 0xD0, 0xEA, 0x77, 0xA0, 0x0E, 0xA7,
  0x7A, 0x0E, 0x0D, 0xA0, 0x27, 0x50, 0x2A, 0x0C, 0x0A, 0xA0, 0x77, 0x50, 0x4A, 0x09, 0x05, 0xA0,
  0xE7, 0x68, 0x32, 0xA4, 0x0D, 0xA0, 0xA7, 0x30, 0x60, 0x14, 0x04, 0xB0, 0xA7, 0x83, 0x1A, 0xFE,
  0x64, 0x08, 0xB8, 0x1E, 0x72, 0x28, 0x12, 0x7E, 0xB0, 0x75, 0x08, 0xFD, 0x08, 0x70, 0x50, 0xDF,
  0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE, 0xCA, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_data_usage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_data_usage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_developer_mode 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_filled_24_device_developer_mode_data[] PROGMEM = {
  0x10, 0x40, 0xDF, 0xB0, 0xD0, 0x42, 0x0D, 0xFD, 0x0D, 0x2F, 0xF2, 0xFF, 0x2A, 0x73, 0xA2, 0xA7,
  0x3A, 0x50, 0x56, 0x05, 0x78, 0x17, 0xF9, 0x48, 0x19, 0xF7, 0x50, 0x7A, 0x05, 0x40, 0x5A, 0x07,
  0x30, 0x7A, 0x05, 0x60, 0x5A, 0x81, 0x70, 0x7A, 0x05, 0x71, 0x05, 0xA0, 0x07, 0xA0, 0x57, 0x10,
  0x5A, 0x81, 0x70, 0x7A, 0x05, 0x60, 0x5A, 0x07, 0x30, 0x7A, 0x05, 0x40, 0x5A, 0x07, 0x58, 0x17,
  0xF9, 0x48, 0x19, 0xF7, 0x70, 0x56, 0x05, 0x5A, 0x73, 0xA2, 0xA7, 0x3A, 0x2F, 0xF2, 0xFF, 0x20,
  0xDF, 0xD0, 0xD2, 0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_developer_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_developer_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_devices_fold 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_filled_24_device_devices_fold_data[] PROGMEM = {
  0x73, 0x83, 0x18, 0xDD, 0x47, 0x60, 0x10, 0xAC, 0x0D, 0x5A, 0x2A, 0x20, 0xCF, 0xA0, 0xD0, 0x4A,
  0x2A, 0x2F, 0xC0, 0xD7, 0x1F, 0x3A, 0x71, 0xF3, 0xC6, 0xF3, 0xC6, 0xF3, 0xA7, 0x1F, 0x3A, 0x71,
  0xF3, 0xC6, 0xF3, 0xC6, 0xF3, 0xA7, 0x1F, 0x3A, 0x71, 0xF3, 0xC6, 0xF3, 0xC6, 0xF3, 0xA7, 0x1E,
  0x0C, 0x3A, 0x71, 0xD0, 0x90, 0x13, 0xC2, 0xA2, 0x0D, 0xFB, 0x0D, 0xA2, 0xA2, 0x04, 0x0D, 0xF9,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_devices_fold() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_devices_fold_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_devices 24x24, 4-bit Alpha,  RLE, 53 bytes.
static const unsigned char ic_filled_24_device_devices_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFC, 0x40, 0xDF, 0xFD, 0x4A, 0x77, 0x71, 0xA7, 0x77, 0x1A, 0x75, 0x0B, 0xE0,
  0xB2, 0xA7, 0x5F, 0x92, 0xA7, 0x5A, 0x4A, 0x2A, 0x75, 0xA4, 0xA2, 0xA7, 0x5A, 0x4A, 0x2A, 0x75,
  0xA4, 0xA2, 0xA7, 0x5A, 0x4A, 0x2A, 0x75, 0xA4, 0xA2, 0xA7, 0x5A, 0x4F, 0xFA, 0x2F, 0xFF, 0x92,
  0xFF, 0xF9, 0x20, 0xBE, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_devices() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_devices_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_device_thermostat 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_filled_24_device_device_thermostat_data[] PROGMEM = {
  0x38, 0x28, 0xDD, 0x85, 0x08, 0xC0, 0x84, 0x84, 0xDF, 0x33, 0xFD, 0x4A, 0x1B, 0x4A, 0x2A, 0x4A,
  0x2A, 0x4A, 0x1B, 0x4A, 0x2A, 0x4A, 0x2A, 0x4E, 0x4E, 0x30, 0x8E, 0x81, 0x80, 0x4F, 0x90, 0x40,
  0xBF, 0x90, 0xB0, 0xEF, 0x90, 0x0E, 0xF9, 0x0E, 0x0B, 0xF9, 0x0B, 0x04, 0xF9, 0x81, 0x40, 0x8E,
  0x08, 0x38, 0x44, 0xBE, 0xEB, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_device_thermostat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_device_thermostat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_discount 24x24, 4-bit Alpha,  RLE, 123 bytes.
static const unsigned char ic_filled_24_device_discount_data[] PROGMEM = {
  0x04, 0x0D, 0xE0, 0xE0, 0x77, 0x10, 0xDF, 0xA0, 0x87, 0xFC, 0x08, 0x6B, 0x81, 0x51, 0xCE, 0x08,
  0x5B, 0x81, 0x10, 0x9F, 0x08, 0x4B, 0x0C, 0x08, 0xFA, 0x08, 0x3F, 0xF9, 0x08, 0x2F, 0xFA, 0x81,
  0x80, 0xEF, 0xFA, 0x00, 0x7F, 0xFA, 0x81, 0xE0, 0x8F, 0xF9, 0x82, 0xC4, 0x08, 0xFE, 0x84, 0xE2,
  0xF4, 0x08, 0xFC, 0x86, 0xE3, 0x0E, 0xF4, 0x08, 0xFA, 0x83, 0xE3, 0x04, 0x7A, 0x81, 0x40, 0x8F,
  0x85, 0xE3, 0x0A, 0xE0, 0x8A, 0x81, 0x40, 0x8D, 0x84, 0xE3, 0x0A, 0xFC, 0x20, 0x8A, 0x81, 0x40,
  0x8B, 0x85, 0xE3, 0x0A, 0xFE, 0x23, 0x08, 0xA8, 0x91, 0x40, 0x7E, 0xC2, 0x0A, 0xFE, 0x35, 0x08,
  0xA0, 0x44, 0x82, 0xAF, 0xE3, 0x70, 0x8A, 0x04, 0x28, 0x2A, 0xFE, 0x37, 0x20, 0x8A, 0x83, 0x5A,
  0xFE, 0x37, 0x40, 0x8B, 0x0E, 0x03, 0x76, 0x82, 0x7E, 0xC2, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_discount() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_discount_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_do_not_disturb_on_total_silence 24x24, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_filled_24_device_do_not_disturb_on_total_silence_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x28, 0x46,
  0xCE, 0xEC, 0x62, 0x04, 0xA0, 0x42, 0x84, 0xDF, 0x60, 0x1C, 0xE8, 0x90, 0xC1, 0x06, 0xFD, 0x05,
  0xFC, 0x20, 0xCF, 0x90, 0xC2, 0x86, 0xCF, 0x59, 0xF6, 0x06, 0xFB, 0x89, 0x06, 0x06, 0xF9, 0xDF,
  0x20, 0xCF, 0xB8, 0x4C, 0x02, 0xFD, 0xE9, 0x20, 0xEA, 0x6A, 0x0E, 0x29, 0x00, 0xE9, 0x20, 0xEA,
  0x6A, 0x0E, 0x29, 0x84, 0xED, 0xF2, 0x0C, 0xFB, 0x89, 0x0C, 0x02, 0xFD, 0x9F, 0x60, 0x6F, 0xB8,
  0x66, 0x06, 0xF9, 0x5F, 0xC2, 0x0C, 0xF9, 0x0C, 0x28, 0x90, 0xCF, 0x50, 0xDF, 0x60, 0x1C, 0xE8,
  0x4C, 0x10, 0x6F, 0xD2, 0x04, 0xA0, 0x42, 0x84, 0x6C, 0xEE, 0xC6, 0x20, 0x4A, 0x04, 0x30, 0x8A,
  0x06, 0x71, 0x06, 0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D,
  0xF9, 0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_do_not_disturb_on_total_silence() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_do_not_disturb_on_total_silence_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_dvr 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_24_device_dvr_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x2A,
  0x1F, 0xC2, 0xC2, 0xA1, 0xFC, 0x2C, 0x77, 0x4C, 0x77, 0x4C, 0x2A, 0x1F, 0xC2, 0xC2, 0xA1, 0xFC,
  0x2C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4A, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x47,
  0xF9, 0x77, 0xF9, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_dvr() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_dvr_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_edgesensor_high 24x24, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_24_device_edgesensor_high_data[] PROGMEM = {
  0x60, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x50, 0xDF, 0xB0, 0xD7, 0x5F, 0xD7, 0x5F, 0xD7, 0x5F, 0xD7,
  0x2A, 0x1A, 0x71, 0xA4, 0xA3, 0xA1, 0xA7, 0x1A, 0x4A, 0x3A, 0x1A, 0x71, 0xA4, 0xC1, 0xA1, 0xA7,
  0x1A, 0x1A, 0x1C, 0x1A, 0x1A, 0x71, 0xA1, 0xA1, 0xC1, 0xA1, 0xA7, 0x1A, 0x1A, 0x1C, 0x1A, 0x1A,
  0x71, 0xA1, 0xA1, 0xC4, 0xA7, 0x1A, 0x1A, 0x3A, 0x4A, 0x71, 0xA1, 0xA3, 0xA4, 0xA7, 0x1A, 0x1A,
  0x72, 0xFD, 0x75, 0xFD, 0x75, 0xFD, 0x75, 0x0D, 0xFB, 0x0D, 0x75, 0x04, 0x0D, 0xF9, 0x0D, 0x04,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_edgesensor_high() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_edgesensor_high_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_edgesensor_low 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_filled_24_device_edgesensor_low_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x10, 0xDF, 0xB0, 0xD7, 0x1F, 0xD7, 0x1F, 0xD7, 0x1F, 0xD4,
  0xA2, 0xA7, 0x1A, 0x4A, 0x2A, 0x71, 0xA4, 0xA2, 0xA7, 0x1A, 0x4A, 0x2A, 0x71, 0xA2, 0xC2, 0xA7,
  0x1A, 0x2C, 0x2A, 0x71, 0xA2, 0xC2, 0xA7, 0x1A, 0x2A, 0x4A, 0x71, 0xA2, 0xA4, 0xA7, 0x1A, 0x2A,
  0x4A, 0x71, 0xA2, 0xA4, 0xFD, 0x71, 0xFD, 0x71, 0xFD, 0x71, 0x0D, 0xFB, 0x0D, 0x71, 0x04, 0x0D,
  0xF9, 0x0D, 0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_edgesensor_low() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_edgesensor_low_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_e_mobiledata 24x24, 4-bit Alpha,  RLE, 8 bytes.
static const unsigned char ic_filled_24_device_e_mobiledata_data[] PROGMEM = {
  0xFF, 0xC6, 0xA6, 0xFF, 0xC6, 0xA6, 0xFF, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_e_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 7, 15, 16), Box(0, 0, 23, 23),
      ic_filled_24_device_e_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_flashlight_off 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_24_device_flashlight_off_data[] PROGMEM = {
  0x5F, 0xD3, 0x81, 0x1C, 0x72, 0x0A, 0xFC, 0x30, 0x4A, 0x07, 0x20, 0xAF, 0xB4, 0x05, 0xA0, 0x77,
  0x73, 0x05, 0xA0, 0x77, 0x73, 0x05, 0xA0, 0x72, 0x0A, 0xF7, 0x05, 0xA0, 0x72, 0x0A, 0xD0, 0xA7,
  0x10, 0x5A, 0x07, 0x20, 0xAB, 0x0E, 0x01, 0x72, 0x05, 0xA0, 0x72, 0x0A, 0xA0, 0x57, 0x4B, 0x07,
  0x20, 0xA9, 0x75, 0xC0, 0x72, 0x0A, 0x75, 0xD0, 0x77, 0x7E, 0x07, 0x76, 0xF0, 0x77, 0x5F, 0x90,
  0x77, 0x4F, 0xA0, 0x77, 0x3F, 0xB0, 0x77, 0x2F, 0x90, 0x5A, 0x07, 0x71, 0xF9, 0x10, 0x5A, 0x07,
  0x7F, 0x92, 0x81, 0x5F, 0xC7, 0x74, 0x04, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_flashlight_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_flashlight_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_flashlight_on 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_filled_24_device_flashlight_on_data[] PROGMEM = {
  0x80, 0xC0, 0xF7, 0x77, 0x3F, 0xD0, 0xAF, 0xB8, 0x1A, 0x1E, 0xF9, 0x82, 0xE1, 0x05, 0xF9, 0x05,
  0x3F, 0x94, 0xB0, 0x09, 0xB4, 0xA0, 0x92, 0x09, 0xA4, 0xA0, 0x92, 0x09, 0xA4, 0xB0, 0x09, 0xB4,
  0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x94, 0xF9, 0x4F, 0x92,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_flashlight_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 17, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_flashlight_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_flourescent 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_24_device_flourescent_data[] PROGMEM = {
  0x71, 0xA7, 0x72, 0xA7, 0x20, 0x16, 0xA6, 0x83, 0x10, 0x1D, 0xB7, 0x58, 0x5B, 0xD1, 0x2D, 0xF6,
  0x73, 0x85, 0x7F, 0xD1, 0x02, 0x77, 0x50, 0x80, 0x27, 0x77, 0xFF, 0x4F, 0xF4, 0xFF, 0x4F, 0xF4,
  0xFF, 0x4F, 0xF7, 0x77, 0x01, 0x06, 0x75, 0x85, 0x61, 0x01, 0xCF, 0x67, 0x38, 0x66, 0xFC, 0x12,
  0xEC, 0x17, 0x38, 0x51, 0xCE, 0x20, 0x21, 0x5A, 0x50, 0x10, 0x27, 0x2A, 0x77, 0x2A, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_flourescent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_flourescent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_fluorescent 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_24_device_fluorescent_data[] PROGMEM = {
  0x71, 0xA7, 0x72, 0xA7, 0x20, 0x16, 0xA6, 0x83, 0x10, 0x1D, 0xB7, 0x58, 0x5B, 0xD1, 0x2D, 0xF6,
  0x73, 0x85, 0x7F, 0xD1, 0x02, 0x77, 0x50, 0x80, 0x27, 0x77, 0xFF, 0x4F, 0xF4, 0xFF, 0x4F, 0xF4,
  0xFF, 0x4F, 0xF7, 0x77, 0x01, 0x06, 0x75, 0x85, 0x61, 0x01, 0xCF, 0x67, 0x38, 0x66, 0xFC, 0x12,
  0xEC, 0x17, 0x38, 0x51, 0xCE, 0x20, 0x21, 0x5A, 0x50, 0x10, 0x27, 0x2A, 0x77, 0x2A, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_fluorescent() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_fluorescent_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_fmd_bad 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_filled_24_device_fmd_bad_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x50, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x81,
  0x90, 0x2E, 0x2E, 0x02, 0x08, 0xE2, 0xE0, 0x80, 0xCE, 0x2E, 0x0C, 0x0E, 0xE2, 0xE0, 0x0E, 0xE2,
  0xE0, 0xE0, 0xDF, 0xF0, 0xD0, 0x9F, 0xF0, 0x90, 0x2E, 0x2E, 0x81, 0x20, 0xAD, 0x2D, 0x0A, 0x20,
  0x10, 0xEF, 0xB0, 0xE0, 0x13, 0x05, 0xFB, 0x05, 0x50, 0x8F, 0x90, 0x87, 0x0A, 0xE0, 0xA7, 0x20,
  0xAC, 0x0A, 0x74, 0x0A, 0xA0, 0xA7, 0x60, 0x08, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_fmd_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_fmd_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_fmd_good 24x24, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_filled_24_device_fmd_good_data[] PROGMEM = {
  0x48, 0x62, 0x8C, 0xEE, 0xC8, 0x27, 0x09, 0xF9, 0x09, 0x50, 0xBF, 0xB0, 0xB3, 0x09, 0xFD, 0x81,
  0x90, 0x2F, 0xF0, 0x20, 0x8F, 0xF0, 0x80, 0xCD, 0x82, 0xB1, 0x1B, 0xD0, 0xC0, 0xED, 0x01, 0x20,
  0x1D, 0x00, 0xED, 0x01, 0x20, 0x1D, 0x0E, 0x0D, 0xD8, 0x2B, 0x11, 0xBD, 0x0D, 0x09, 0xFF, 0x09,
  0x02, 0xFF, 0x81, 0x20, 0xAF, 0xD0, 0xA2, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x30, 0x5F, 0xB0, 0x55,
  0x08, 0xF9, 0x08, 0x70, 0xAE, 0x0A, 0x72, 0x0A, 0xC0, 0xA7, 0x40, 0xAA, 0x0A, 0x76, 0x00, 0x87,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_fmd_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_fmd_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_g_mobiledata 24x24, 4-bit Alpha,  RLE, 20 bytes.
static const unsigned char ic_filled_24_device_g_mobiledata_data[] PROGMEM = {
  0x04, 0x0D, 0xD8, 0x1D, 0x4D, 0xF0, 0xDA, 0x7A, 0x7A, 0x3E, 0x3E, 0x5C, 0x5A, 0x0D, 0xF8, 0x1D,
  0x4D, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_g_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 7, 15, 16), Box(0, 0, 23, 23),
      ic_filled_24_device_g_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_gpp_bad 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_filled_24_device_gpp_bad_data[] PROGMEM = {
  0x58, 0x41, 0x6C, 0xC6, 0x17, 0x10, 0x40, 0xAE, 0x0A, 0x04, 0x38, 0x12, 0x8E, 0xFB, 0x81, 0xE8,
  0x28, 0x0E, 0x1F, 0x0C, 0x0E, 0xA0, 0xE0, 0xCF, 0xA8, 0x6C, 0x12, 0xEE, 0x21, 0xCF, 0x98, 0x6E,
  0x20, 0x22, 0x02, 0xEC, 0x0E, 0xC0, 0xE0, 0x22, 0x02, 0x0E, 0xC0, 0xE0, 0xDC, 0x0E, 0x02, 0x20,
  0x20, 0xEC, 0x0D, 0x0B, 0xB8, 0x6E, 0x20, 0x22, 0x02, 0xEB, 0x0B, 0x07, 0xB8, 0x6C, 0x12, 0xEE,
  0x21, 0xCB, 0x07, 0x01, 0xC0, 0xC0, 0xEA, 0x0E, 0x0C, 0xC8, 0x11, 0x09, 0xFD, 0x09, 0x20, 0x10,
  0xEF, 0xB0, 0xE0, 0x13, 0x04, 0xFB, 0x04, 0x50, 0x6F, 0x90, 0x67, 0x04, 0x0D, 0xC0, 0xD0, 0x47,
  0x38, 0x27, 0xCC, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_gpp_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_gpp_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_gpp_good 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_24_device_gpp_good_data[] PROGMEM = {
  0x58, 0x41, 0x6C, 0xC6, 0x17, 0x10, 0x40, 0xAE, 0x0A, 0x04, 0x38, 0x12, 0x8E, 0xFB, 0x81, 0xE8,
  0x28, 0x0E, 0x6F, 0x0E, 0x0C, 0xFE, 0x82, 0xE3, 0x0B, 0xF0, 0xDB, 0x83, 0xE3, 0x02, 0xDB, 0x0E,
  0xA8, 0x7C, 0x14, 0xFE, 0x30, 0x2D, 0xB0, 0xE0, 0xDA, 0x86, 0xC1, 0x04, 0x30, 0x2D, 0xC0, 0xD0,
  0xBB, 0x0C, 0x01, 0x20, 0x20, 0xDD, 0x0B, 0x07, 0xC8, 0x2C, 0x12, 0xDE, 0x07, 0x01, 0xD0, 0xC0,
  0xDF, 0x81, 0x10, 0x9F, 0xD0, 0x92, 0x01, 0x0E, 0xFB, 0x0E, 0x01, 0x30, 0x4F, 0xB0, 0x45, 0x06,
  0xF9, 0x06, 0x70, 0x40, 0xDC, 0x0D, 0x04, 0x73, 0x82, 0x7C, 0xC7, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_gpp_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_gpp_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_gpp_maybe 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_filled_24_device_gpp_maybe_data[] PROGMEM = {
  0x58, 0x41, 0x6C, 0xC6, 0x17, 0x10, 0x40, 0xAE, 0x0A, 0x04, 0x38, 0x12, 0x8E, 0xFB, 0x81, 0xE8,
  0x28, 0x0C, 0x3F, 0x2F, 0xF2, 0xFF, 0x2F, 0xF2, 0xF0, 0xEE, 0x2E, 0x0E, 0x0D, 0xFF, 0x0D, 0x0B,
  0xFF, 0x0B, 0x07, 0xE2, 0xE0, 0x70, 0x1E, 0x2E, 0x81, 0x10, 0x9F, 0xD0, 0x92, 0x01, 0x0E, 0xFB,
  0x0E, 0x01, 0x30, 0x4F, 0xB0, 0x45, 0x06, 0xF9, 0x06, 0x70, 0x40, 0xDC, 0x0D, 0x04, 0x73, 0x82,
  0x7C, 0xC7, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_gpp_maybe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_gpp_maybe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_gps_fixed 24x24, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_filled_24_device_gps_fixed_data[] PROGMEM = {
  0x73, 0xA7, 0x76, 0xA7, 0x73, 0x81, 0x49, 0xCA, 0x81, 0xC9, 0x47, 0x50, 0x20, 0xBF, 0x90, 0xB0,
  0x27, 0x28, 0x43, 0xEF, 0xE7, 0x22, 0x84, 0x27, 0xEF, 0xE3, 0x78, 0x22, 0xEF, 0xA7, 0x18, 0x2A,
  0xFE, 0x26, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x58, 0x14, 0xFE, 0x38, 0x41, 0xAD, 0xDA, 0x13,
  0x81, 0xEF, 0x44, 0x81, 0x9F, 0x72, 0x01, 0x0E, 0xC0, 0xE0, 0x12, 0x81, 0x7F, 0x94, 0x81, 0xDF,
  0x22, 0x0A, 0xE0, 0xA2, 0x81, 0x2F, 0xD2, 0xC3, 0x0D, 0xE0, 0xD3, 0xF9, 0x30, 0xDE, 0x0D, 0x3C,
  0x28, 0x1D, 0xF2, 0x20, 0xAE, 0x0A, 0x28, 0x12, 0xFD, 0x48, 0x19, 0xF7, 0x20, 0x10, 0xEC, 0x0E,
  0x01, 0x28, 0x17, 0xF9, 0x48, 0x14, 0xFE, 0x38, 0x41, 0xAD, 0xDA, 0x13, 0x81, 0xEF, 0x45, 0x81,
  0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x68, 0x22, 0xEF, 0xA7, 0x18, 0x2A, 0xFE, 0x27, 0x84, 0x3E, 0xFE,
  0x72, 0x28, 0x42, 0x7E, 0xFE, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xB0, 0x27, 0x58, 0x14, 0x9C, 0xA8,
  0x1C, 0x94, 0x77, 0x3A, 0x77, 0x6A, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_gps_fixed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_gps_fixed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_gps_not_fixed 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_filled_24_device_gps_not_fixed_data[] PROGMEM = {
  0x73, 0xA7, 0x76, 0xA7, 0x73, 0x81, 0x49, 0xCA, 0x81, 0xC9, 0x47, 0x50, 0x20, 0xBF, 0x90, 0xB0,
  0x27, 0x28, 0x43, 0xEF, 0xE7, 0x22, 0x84, 0x27, 0xEF, 0xE3, 0x78, 0x22, 0xEF, 0xA7, 0x18, 0x2A,
  0xFE, 0x26, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x58, 0x14, 0xFE, 0x75, 0x81, 0xEF, 0x44, 0x81,
  0x9F, 0x77, 0x58, 0x17, 0xF9, 0x48, 0x1D, 0xF2, 0x75, 0x81, 0x2F, 0xD2, 0xC7, 0x7F, 0x97, 0x7C,
  0x28, 0x1D, 0xF2, 0x75, 0x81, 0x2F, 0xD4, 0x81, 0x9F, 0x77, 0x58, 0x17, 0xF9, 0x48, 0x14, 0xFE,
  0x75, 0x81, 0xEF, 0x45, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x68, 0x22, 0xEF, 0xA7, 0x18, 0x2A,
  0xFE, 0x27, 0x84, 0x3E, 0xFE, 0x72, 0x28, 0x42, 0x7E, 0xFE, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xB0,
  0x27, 0x58, 0x14, 0x9C, 0xA8, 0x1C, 0x94, 0x77, 0x3A, 0x77, 0x6A, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_gps_not_fixed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_gps_not_fixed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_gps_off 24x24, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_filled_24_device_gps_off_data[] PROGMEM = {
  0x73, 0xA7, 0x76, 0xA7, 0x50, 0x40, 0xA3, 0x81, 0x39, 0xCA, 0x81, 0xC9, 0x47, 0x28, 0x1A, 0xFB,
  0x20, 0xAF, 0x0B, 0x02, 0x71, 0x81, 0xBF, 0xB2, 0x06, 0x02, 0x28, 0x42, 0x7E, 0xFE, 0x37, 0x02,
  0xA0, 0xB7, 0x18, 0x2A, 0xFE, 0x26, 0x83, 0xBF, 0xEF, 0xB7, 0x18, 0x1A, 0xFB, 0x58, 0x54, 0xFE,
  0x1B, 0xFB, 0x71, 0x81, 0xEF, 0x44, 0x81, 0x9F, 0x72, 0x81, 0xBF, 0xB7, 0x81, 0x7F, 0x94, 0x81,
  0xDF, 0x23, 0x81, 0xBF, 0xB6, 0x81, 0x2F, 0xD2, 0xC5, 0x81, 0xBF, 0xB6, 0xF9, 0x68, 0x1B, 0xFB,
  0x5C, 0x28, 0x1D, 0xF2, 0x68, 0x1B, 0xFB, 0x38, 0x12, 0xFD, 0x48, 0x19, 0xF7, 0x78, 0x1B, 0xFB,
  0x28, 0x16, 0xF9, 0x48, 0x14, 0xFE, 0x71, 0x81, 0xBF, 0xB2, 0x0A, 0x03, 0x58, 0x1B, 0xFA, 0x71,
  0x81, 0xBF, 0xB7, 0x18, 0x22, 0xEF, 0xA7, 0x82, 0x1E, 0xFB, 0x71, 0x84, 0x3E, 0xFE, 0x72, 0x28,
  0x12, 0x7E, 0xB0, 0xB7, 0x10, 0x20, 0xBF, 0x98, 0x3B, 0x2B, 0xFA, 0x72, 0x81, 0x49, 0xCA, 0x81,
  0xC9, 0x43, 0x0A, 0x04, 0x75, 0xA7, 0x76, 0xA7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_gps_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_gps_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_graphic_eq 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_filled_24_device_graphic_eq_data[] PROGMEM = {
  0x71, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x5A, 0x2A, 0x2A, 0x71, 0xA2, 0xA2, 0xA7, 0x1A,
  0x2A, 0x2A, 0x71, 0xA2, 0xA2, 0xA4, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2,
  0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA4, 0xA2, 0xA2, 0xA7, 0x1A, 0x2A, 0x2A, 0x71, 0xA2, 0xA2,
  0xA7, 0x1A, 0x2A, 0x2A, 0x75, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x72, 0xA7, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_graphic_eq() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_graphic_eq_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_grid_3x3 24x24, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_filled_24_device_grid_3x3_data[] PROGMEM = {
  0x4A, 0x4A, 0x71, 0xA4, 0xA7, 0x1A, 0x4A, 0x71, 0xA4, 0xA4, 0xFF, 0xFF, 0xC4, 0xA4, 0xA7, 0x1A,
  0x4A, 0x71, 0xA4, 0xA7, 0x1A, 0x4A, 0x4F, 0xFF, 0xFC, 0x4A, 0x4A, 0x71, 0xA4, 0xA7, 0x1A, 0x4A,
  0x71, 0xA4, 0xA4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_grid_3x3() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_grid_3x3_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_grid_4x4 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_24_device_grid_4x4_data[] PROGMEM = {
  0x3A, 0x4A, 0x4A, 0x6A, 0x4A, 0x4A, 0x6A, 0x4A, 0x4A, 0x38, 0x0C, 0x4F, 0x3A, 0x4A, 0x4A, 0x6A,
  0x4A, 0x4A, 0x6A, 0x4A, 0x4A, 0x6A, 0x4A, 0x4A, 0x38, 0x0C, 0x4F, 0x3A, 0x4A, 0x4A, 0x6A, 0x4A,
  0x4A, 0x6A, 0x4A, 0x4A, 0x6A, 0x4A, 0x4A, 0x38, 0x0C, 0x4F, 0x3A, 0x4A, 0x4A, 0x6A, 0x4A, 0x4A,
  0x6A, 0x4A, 0x4A, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_grid_4x4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_grid_4x4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_grid_goldenratio 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_filled_24_device_grid_goldenratio_data[] PROGMEM = {
  0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x7A,
  0x2A, 0x78, 0x0C, 0x4F, 0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x80, 0xC4, 0xF7, 0xA2, 0xA7, 0x7A, 0x2A,
  0x77, 0xA2, 0xA7, 0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x7A, 0x2A, 0x77, 0xA2, 0xA7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_grid_goldenratio() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_grid_goldenratio_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_hdr_auto 24x24, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_filled_24_device_hdr_auto_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xFD, 0x08, 0x50,
  0x8F, 0xF0, 0x83, 0x04, 0xE0, 0xC2, 0x0C, 0xE0, 0x42, 0x0D, 0xE0, 0x62, 0x07, 0xE8, 0x1D, 0x05,
  0xF8, 0x21, 0x33, 0x1F, 0x05, 0x09, 0xE8, 0x4A, 0x08, 0x80, 0xAE, 0x09, 0x0D, 0xE8, 0x44, 0x0D,
  0xD0, 0x5E, 0x0D, 0x0E, 0xD8, 0x1E, 0x04, 0xA8, 0x13, 0x0E, 0xD0, 0x0E, 0xD8, 0x68, 0x05, 0x99,
  0x50, 0x8D, 0x0E, 0x0D, 0xD0, 0x36, 0x03, 0xD0, 0xD0, 0x9C, 0x89, 0x0C, 0x04, 0xBB, 0xBB, 0x40,
  0xCC, 0x09, 0x05, 0xC8, 0x16, 0x0A, 0xC8, 0x1A, 0x07, 0xC8, 0x15, 0x0D, 0xB0, 0x01, 0xE0, 0x01,
  0xB0, 0xD2, 0x04, 0xFF, 0xA0, 0x43, 0x08, 0xFF, 0x08, 0x50, 0x8F, 0xD0, 0x87, 0x04, 0x0D, 0xF9,
  0x0D, 0x04, 0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_hdr_auto() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_hdr_auto_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_hdr_auto_select 24x24, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_filled_24_device_hdr_auto_select_data[] PROGMEM = {
  0x72, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x0C, 0xB0, 0x20, 0x3B,
  0x0C, 0x76, 0x06, 0xB8, 0x2C, 0x11, 0xCB, 0x06, 0x75, 0x0C, 0xB8, 0x26, 0x77, 0x6B, 0x0C, 0x75,
  0x0E, 0xB8, 0x21, 0xCC, 0x1B, 0x0E, 0x75, 0x0E, 0xA8, 0x4A, 0x03, 0x30, 0xAA, 0x0E, 0x75, 0x0C,
  0xA8, 0x44, 0x6B, 0xB6, 0x4A, 0x0C, 0x75, 0x83, 0x6F, 0xE0, 0xDA, 0x83, 0xD0, 0xEF, 0x67, 0x60,
  0xCF, 0x90, 0xC7, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x28, 0x46, 0xCE, 0xEC, 0x68, 0x0E, 0x50,
  0x98, 0x47, 0x07, 0xF0, 0x7B, 0x0D, 0x02, 0x1C, 0x07, 0x20, 0x30, 0x72, 0x98, 0x96, 0x70, 0x7F,
  0x07, 0xF7, 0x7F, 0x70, 0xFB, 0x7B, 0x92, 0x07, 0x92, 0xD1, 0x07, 0x92, 0x98, 0xA2, 0x70, 0xFB,
  0x7B, 0xE3, 0x7B, 0xF7, 0x7F, 0xB7, 0xBF, 0x07, 0x92, 0x90, 0x71, 0xC0, 0x07, 0xE8, 0x97, 0x70,
  0x7F, 0x07, 0xF7, 0x7F, 0x70, 0xF7, 0x2F, 0x52, 0x07, 0x92, 0x98, 0x47, 0x07, 0xF0, 0x7B, 0x86,
  0xD2, 0x0F, 0x70, 0xBC, 0x20, 0x79, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_hdr_auto_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_hdr_auto_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_hdr_off_select 24x24, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_filled_24_device_hdr_off_select_data[] PROGMEM = {
  0x60, 0x52, 0x84, 0x3B, 0xFD, 0xB6, 0x77, 0x81, 0xBF, 0x72, 0x0A, 0xC0, 0xB0, 0x17, 0x50, 0x5A,
  0x07, 0x28, 0x41, 0x15, 0xDF, 0xB7, 0x60, 0x8A, 0x07, 0x48, 0x21, 0xDF, 0x67, 0x50, 0xBB, 0x07,
  0x48, 0x15, 0xFB, 0x75, 0x81, 0xEF, 0x6A, 0x07, 0x38, 0x11, 0xFE, 0x75, 0x82, 0xEF, 0x15, 0xA0,
  0x72, 0x81, 0x1F, 0xE7, 0x58, 0x3B, 0xF5, 0x05, 0xA0, 0x72, 0x0A, 0x0B, 0x75, 0x84, 0x6F, 0xD1,
  0x05, 0xA0, 0x72, 0x03, 0x76, 0x84, 0xBF, 0xD5, 0x16, 0xA0, 0x77, 0x71, 0x01, 0x0B, 0xF0, 0x77,
  0x72, 0x84, 0x6B, 0xDF, 0xB8, 0xA0, 0x57, 0x77, 0x05, 0x0B, 0x77, 0x77, 0x39, 0x84, 0x70, 0x7F,
  0x07, 0xB0, 0xD0, 0x21, 0xC0, 0x72, 0x03, 0x07, 0x29, 0x89, 0x67, 0x07, 0xF0, 0x7F, 0x77, 0xF7,
  0x0F, 0xB7, 0xB9, 0x20, 0x79, 0x2D, 0x10, 0x79, 0x29, 0x8A, 0x27, 0x0F, 0xB7, 0xBE, 0x37, 0xBF,
  0x77, 0xFB, 0x7B, 0xF0, 0x79, 0x29, 0x07, 0x1C, 0x00, 0x7E, 0x89, 0x77, 0x07, 0xF0, 0x7F, 0x77,
  0xF7, 0x0F, 0x72, 0xF5, 0x20, 0x79, 0x29, 0x84, 0x70, 0x7F, 0x07, 0xB8, 0x6D, 0x20, 0xF7, 0x0B,
  0xC2, 0x07, 0x92,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_hdr_off_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_hdr_off_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_hdr_on_select 24x24, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_filled_24_device_hdr_on_select_data[] PROGMEM = {
  0x72, 0x84, 0x6C, 0xEE, 0xC6, 0x77, 0x20, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x89, 0x0C, 0xFD, 0x51,
  0x15, 0xDF, 0xC7, 0x68, 0x26, 0xFD, 0x14, 0x82, 0x1D, 0xF6, 0x75, 0x81, 0xCF, 0x56, 0x81, 0x5F,
  0xC7, 0x58, 0x1E, 0xF1, 0x68, 0x11, 0xFE, 0x75, 0x81, 0xEF, 0x16, 0x81, 0x1F, 0xE7, 0x58, 0x1C,
  0xF5, 0x68, 0x15, 0xFC, 0x75, 0x82, 0x6F, 0xD1, 0x48, 0x21, 0xDF, 0x67, 0x68, 0x90, 0xCF, 0xD5,
  0x11, 0x5D, 0xFC, 0x77, 0x01, 0x0C, 0xE0, 0xC0, 0x17, 0x72, 0x84, 0x6C, 0xEE, 0xC6, 0x80, 0xE5,
  0x09, 0x84, 0x70, 0x7F, 0x07, 0xB0, 0xD0, 0x21, 0xC0, 0x72, 0x03, 0x07, 0x29, 0x89, 0x67, 0x07,
  0xF0, 0x7F, 0x77, 0xF7, 0x0F, 0xB7, 0xB9, 0x20, 0x79, 0x2D, 0x10, 0x79, 0x29, 0x8A, 0x27, 0x0F,
  0xB7, 0xBE, 0x37, 0xBF, 0x77, 0xFB, 0x7B, 0xF0, 0x79, 0x29, 0x07, 0x1C, 0x00, 0x7E, 0x89, 0x77,
  0x07, 0xF0, 0x7F, 0x77, 0xF7, 0x0F, 0x72, 0xF5, 0x20, 0x79, 0x29, 0x84, 0x70, 0x7F, 0x07, 0xB8,
  0x6D, 0x20, 0xF7, 0x0B, 0xC2, 0x07, 0x92,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_hdr_on_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_hdr_on_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_h_mobiledata 24x24, 4-bit Alpha,  RLE, 10 bytes.
static const unsigned char ic_filled_24_device_h_mobiledata_data[] PROGMEM = {
  0xA6, 0xC6, 0xC6, 0xC6, 0xFF, 0xFB, 0x6C, 0x6C, 0x6C, 0x6A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_h_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 7, 16, 16), Box(0, 0, 23, 23),
      ic_filled_24_device_h_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_h_plus_mobiledata 24x24, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_filled_24_device_h_plus_mobiledata_data[] PROGMEM = {
  0xA6, 0xA7, 0x1A, 0x6A, 0x71, 0xA6, 0xA4, 0xA2, 0xA6, 0xA4, 0xA2, 0xFB, 0x2F, 0xFA, 0x2F, 0x96,
  0xA4, 0xA2, 0xA6, 0xA4, 0xA2, 0xA6, 0xA7, 0x1A, 0x6A, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_h_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 7, 21, 16), Box(0, 0, 23, 23),
      ic_filled_24_device_h_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_lan 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_filled_24_device_lan_data[] PROGMEM = {
  0x5F, 0x97, 0x3F, 0x97, 0x3F, 0x97, 0x3F, 0x97, 0x3F, 0x97, 0x3F, 0x97, 0x3F, 0x97, 0x6A, 0x77,
  0x2A, 0x74, 0xFD, 0x6F, 0xD6, 0xA7, 0x1A, 0x6A, 0x71, 0xA3, 0xF9, 0x2F, 0xFA, 0x2F, 0xFA, 0x2F,
  0xFA, 0x2F, 0xFA, 0x2F, 0xFA, 0x2F, 0xFA, 0x2F, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_lan() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_lan_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_lens_blur 24x24, 4-bit Alpha,  RLE, 120 bytes.
static const unsigned char ic_filled_24_device_lens_blur_data[] PROGMEM = {
  0x70, 0x02, 0x20, 0x02, 0x77, 0x00, 0x22, 0x00, 0x27, 0x77, 0x72, 0x00, 0xB2, 0x00, 0xB2, 0x00,
  0xB2, 0x00, 0xB6, 0x00, 0xB2, 0x00, 0xB2, 0x00, 0xB2, 0x00, 0xB7, 0x77, 0x72, 0x00, 0x52, 0x00,
  0x57, 0x85, 0x22, 0x0B, 0xB0, 0x5A, 0x00, 0x5A, 0x89, 0x45, 0x0B, 0xB0, 0x22, 0x22, 0x0B, 0xB0,
  0x5A, 0x00, 0x5A, 0x85, 0x50, 0xBB, 0x02, 0x27, 0x00, 0x52, 0x00, 0x57, 0x70, 0x05, 0x20, 0x05,
  0x78, 0x52, 0x20, 0xBB, 0x05, 0xA0, 0x05, 0xA8, 0x94, 0x50, 0xBB, 0x02, 0x22, 0x20, 0xBB, 0x05,
  0xA0, 0x05, 0xA8, 0x55, 0x0B, 0xB0, 0x22, 0x70, 0x05, 0x20, 0x05, 0x77, 0x77, 0x20, 0x0B, 0x20,
  0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x60, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x20, 0x0B, 0x77, 0x77, 0x20,
  0x02, 0x20, 0x02, 0x77, 0x00, 0x22, 0x00, 0x27,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_lens_blur() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_lens_blur_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_light_mode 24x24, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_filled_24_device_light_mode_data[] PROGMEM = {
  0x73, 0x00, 0xB7, 0x76, 0xA7, 0x76, 0xA7, 0x68, 0x13, 0x91, 0x40, 0x0B, 0x48, 0x11, 0x93, 0x68,
  0x19, 0xFC, 0x73, 0x81, 0xCF, 0x96, 0x82, 0x1C, 0xF3, 0x71, 0x82, 0x3F, 0xC1, 0x71, 0x03, 0x28,
  0x44, 0xBE, 0xEB, 0x42, 0x03, 0x75, 0x08, 0xE0, 0x87, 0x60, 0x4F, 0x90, 0x47, 0x50, 0xBF, 0x90,
  0xB6, 0x0B, 0xA0, 0xB2, 0x0E, 0xF9, 0x0E, 0x20, 0xBA, 0x00, 0xBA, 0x0B, 0x20, 0xEF, 0x90, 0xE2,
  0x0B, 0xA0, 0xB6, 0x0B, 0xF9, 0x0B, 0x75, 0x04, 0xF9, 0x04, 0x76, 0x08, 0xE0, 0x87, 0x50, 0x32,
  0x84, 0x4B, 0xEE, 0xB4, 0x20, 0x37, 0x18, 0x21, 0xCF, 0x37, 0x18, 0x23, 0xFC, 0x16, 0x81, 0x9F,
  0xC7, 0x38, 0x1C, 0xF9, 0x68, 0x13, 0x91, 0x40, 0x0B, 0x48, 0x11, 0x93, 0x76, 0xA7, 0x76, 0xA7,
  0x76, 0x00, 0xB7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_light_mode() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_light_mode_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_location_disabled 24x24, 4-bit Alpha,  RLE, 153 bytes.
static const unsigned char ic_filled_24_device_location_disabled_data[] PROGMEM = {
  0x73, 0xA7, 0x76, 0xA7, 0x50, 0x40, 0xA3, 0x81, 0x39, 0xCA, 0x81, 0xC9, 0x47, 0x28, 0x1A, 0xFB,
  0x20, 0xAF, 0x0B, 0x02, 0x71, 0x81, 0xBF, 0xB2, 0x06, 0x02, 0x28, 0x42, 0x7E, 0xFE, 0x37, 0x02,
  0xA0, 0xB7, 0x18, 0x2A, 0xFE, 0x26, 0x83, 0xBF, 0xEF, 0xB7, 0x18, 0x1A, 0xFB, 0x58, 0x54, 0xFE,
  0x1B, 0xFB, 0x71, 0x81, 0xEF, 0x44, 0x81, 0x9F, 0x72, 0x81, 0xBF, 0xB7, 0x81, 0x7F, 0x94, 0x81,
  0xDF, 0x23, 0x81, 0xBF, 0xB6, 0x81, 0x2F, 0xD2, 0xC5, 0x81, 0xBF, 0xB6, 0xF9, 0x68, 0x1B, 0xFB,
  0x5C, 0x28, 0x1D, 0xF2, 0x68, 0x1B, 0xFB, 0x38, 0x12, 0xFD, 0x48, 0x19, 0xF7, 0x78, 0x1B, 0xFB,
  0x28, 0x16, 0xF9, 0x48, 0x14, 0xFE, 0x71, 0x81, 0xBF, 0xB2, 0x0A, 0x03, 0x58, 0x1B, 0xFA, 0x71,
  0x81, 0xBF, 0xB7, 0x18, 0x22, 0xEF, 0xA7, 0x82, 0x1E, 0xFB, 0x71, 0x84, 0x3E, 0xFE, 0x72, 0x28,
  0x12, 0x7E, 0xB0, 0xB7, 0x10, 0x20, 0xBF, 0x98, 0x3B, 0x2B, 0xFA, 0x72, 0x81, 0x49, 0xCA, 0x81,
  0xC9, 0x43, 0x0A, 0x04, 0x75, 0xA7, 0x76, 0xA7, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_location_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_location_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_location_searching 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_filled_24_device_location_searching_data[] PROGMEM = {
  0x73, 0xA7, 0x76, 0xA7, 0x73, 0x81, 0x49, 0xCA, 0x81, 0xC9, 0x47, 0x50, 0x20, 0xBF, 0x90, 0xB0,
  0x27, 0x28, 0x43, 0xEF, 0xE7, 0x22, 0x84, 0x27, 0xEF, 0xE3, 0x78, 0x22, 0xEF, 0xA7, 0x18, 0x2A,
  0xFE, 0x26, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x58, 0x14, 0xFE, 0x75, 0x81, 0xEF, 0x44, 0x81,
  0x9F, 0x77, 0x58, 0x17, 0xF9, 0x48, 0x1D, 0xF2, 0x75, 0x81, 0x2F, 0xD2, 0xC7, 0x7F, 0x97, 0x7C,
  0x28, 0x1D, 0xF2, 0x75, 0x81, 0x2F, 0xD4, 0x81, 0x9F, 0x77, 0x58, 0x17, 0xF9, 0x48, 0x14, 0xFE,
  0x75, 0x81, 0xEF, 0x45, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x68, 0x22, 0xEF, 0xA7, 0x18, 0x2A,
  0xFE, 0x27, 0x84, 0x3E, 0xFE, 0x72, 0x28, 0x42, 0x7E, 0xFE, 0x37, 0x20, 0x20, 0xBF, 0x90, 0xB0,
  0x27, 0x58, 0x14, 0x9C, 0xA8, 0x1C, 0x94, 0x77, 0x3A, 0x77, 0x6A, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_location_searching() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_location_searching_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_lte_mobiledata 24x24, 4-bit Alpha,  RLE, 19 bytes.
static const unsigned char ic_filled_24_device_lte_mobiledata_data[] PROGMEM = {
  0xA3, 0xE1, 0xF3, 0xE1, 0xF5, 0xA3, 0xA3, 0xA5, 0xA3, 0xF5, 0xA3, 0xF5, 0xA3, 0xA3, 0xD2, 0xA3,
  0xFB, 0x2A, 0x3D,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_lte_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 8, 20, 15), Box(0, 0, 23, 23),
      ic_filled_24_device_lte_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_lte_plus_mobiledata 24x24, 4-bit Alpha,  RLE, 29 bytes.
static const unsigned char ic_filled_24_device_lte_plus_mobiledata_data[] PROGMEM = {
  0xA2, 0xE1, 0xD7, 0xA2, 0xE1, 0xD3, 0xA2, 0xA4, 0xA3, 0xA6, 0xA2, 0xA4, 0xA3, 0xD1, 0xF9, 0x4A,
  0x3D, 0x1F, 0x94, 0xA3, 0xA6, 0xA2, 0xD1, 0xA3, 0xD3, 0xA2, 0xD1, 0xA3, 0xD7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_lte_plus_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 8, 23, 15), Box(0, 0, 23, 23),
      ic_filled_24_device_lte_plus_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_macro_off 24x24, 4-bit Alpha,  RLE, 164 bytes.
static const unsigned char ic_filled_24_device_macro_off_data[] PROGMEM = {
  0x72, 0x82, 0x6D, 0xD6, 0x77, 0x10, 0x3C, 0x03, 0x68, 0x11, 0xC7, 0x28, 0x21, 0x9A, 0xAC, 0x82,
  0xAA, 0x92, 0x30, 0x4A, 0x07, 0x20, 0xAF, 0xA0, 0xE0, 0x13, 0x05, 0xA0, 0x72, 0x84, 0xAF, 0xE9,
  0x9E, 0xC0, 0x54, 0x05, 0xA0, 0x72, 0x09, 0x02, 0x20, 0x20, 0xEB, 0x03, 0x50, 0x5A, 0x07, 0x60,
  0x9A, 0x09, 0x70, 0x5A, 0x07, 0x50, 0x9A, 0x09, 0x70, 0x3B, 0x07, 0x30, 0x20, 0xEB, 0x03, 0x60,
  0x5C, 0x07, 0x20, 0x9C, 0x05, 0x60, 0x10, 0xEC, 0x07, 0x20, 0xAA, 0x0E, 0x01, 0x78, 0x22, 0x9A,
  0xAA, 0x07, 0x28, 0x19, 0x92, 0x58, 0x2D, 0xD9, 0x42, 0x03, 0xB0, 0x73, 0x82, 0x39, 0xCD, 0x20,
  0xDB, 0x83, 0xB2, 0x06, 0xDA, 0x07, 0x20, 0xAA, 0x0C, 0x20, 0x9C, 0x0E, 0x03, 0x20, 0x5A, 0x07,
  0x28, 0x1A, 0xF9, 0x20, 0x4D, 0x0E, 0x02, 0x20, 0x6A, 0x07, 0x20, 0xA0, 0x33, 0x0B, 0xD0, 0xB2,
  0x0B, 0xB0, 0x76, 0x02, 0x0E, 0xD0, 0x40, 0x3D, 0x07, 0x60, 0x30, 0xEC, 0x00, 0x9E, 0x07, 0x60,
  0x20, 0xBB, 0x00, 0xDB, 0x0B, 0x06, 0xA0, 0x77, 0x86, 0x49, 0xDD, 0xED, 0x94, 0x28, 0x15, 0xFC,
  0x77, 0x40, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_macro_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_macro_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_media_bluetooth_off 24x24, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_filled_24_device_media_bluetooth_off_data[] PROGMEM = {
  0x81, 0x1C, 0x75, 0xE7, 0x04, 0xA0, 0x74, 0xE7, 0x10, 0x5A, 0x07, 0x3E, 0x72, 0x05, 0xA0, 0x72,
  0x0A, 0xD7, 0x30, 0x5A, 0x07, 0x20, 0xA7, 0x71, 0x05, 0xA0, 0x77, 0x74, 0x05, 0xA0, 0x77, 0x10,
  0xE0, 0x27, 0x10, 0x5A, 0x07, 0x79, 0x0E, 0x02, 0x71, 0x05, 0xA0, 0x72, 0x86, 0x5D, 0x10, 0xFB,
  0xE2, 0x71, 0xB0, 0x72, 0x85, 0xAD, 0x1F, 0x3E, 0xB3, 0x83, 0x1A, 0xDE, 0xAC, 0x07, 0x28, 0x4A,
  0xDF, 0xDC, 0x12, 0x01, 0x0E, 0xE0, 0x5A, 0x07, 0x28, 0x2A, 0xFC, 0x13, 0x0A, 0xF1, 0x05, 0xA0,
  0x72, 0x81, 0xAC, 0x13, 0x0D, 0xF2, 0x05, 0xA0, 0x72, 0x81, 0xAC, 0x12, 0x0D, 0xE0, 0xD3, 0x05,
  0xA0, 0x72, 0x0A, 0x0B, 0x20, 0xAE, 0x0A, 0x30, 0x50, 0xDA, 0x07, 0x20, 0x12, 0x01, 0x0E, 0xC0,
  0xE0, 0x15, 0x05, 0xA0, 0x75, 0x84, 0x1A, 0xDE, 0xA1, 0x70, 0x5A, 0x07, 0x77, 0x48, 0x15, 0xFC,
  0x77, 0x50, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_media_bluetooth_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_media_bluetooth_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_media_bluetooth_on 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_filled_24_device_media_bluetooth_on_data[] PROGMEM = {
  0x6E, 0x75, 0xE7, 0x5E, 0x75, 0xE7, 0x5A, 0x77, 0x2A, 0x77, 0x2A, 0x60, 0xE0, 0x27, 0x1A, 0x69,
  0x0E, 0x02, 0x7A, 0x28, 0x65, 0xC1, 0x0F, 0xBE, 0x26, 0xA3, 0x89, 0x3B, 0xC1, 0xF3, 0xEB, 0x01,
  0xAD, 0xEA, 0xA4, 0x86, 0xBD, 0xFD, 0xC1, 0x1E, 0xE5, 0x84, 0xBF, 0xC1, 0x0A, 0xF5, 0x84, 0xBF,
  0xC1, 0x0D, 0xF4, 0x85, 0xBD, 0xFD, 0xC1, 0xDE, 0x0D, 0x38, 0x6B, 0xD1, 0xF3, 0xEB, 0xAE, 0x0A,
  0x28, 0x90, 0x5D, 0x10, 0xFB, 0xE2, 0x1E, 0xC0, 0xE0, 0x16, 0x90, 0xE0, 0x22, 0x84, 0x1A, 0xDE,
  0xA1, 0x70, 0xE0, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_media_bluetooth_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_media_bluetooth_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_medication_liquid 24x24, 4-bit Alpha,  RLE, 89 bytes.
static const unsigned char ic_filled_24_device_medication_liquid_data[] PROGMEM = {
  0x1F, 0xD7, 0x2F, 0xD7, 0x77, 0x71, 0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x28, 0x46, 0xDD, 0x60, 0xDF,
  0xD8, 0x1D, 0x04, 0xC0, 0x4F, 0xF1, 0x0B, 0xC0, 0xBD, 0x82, 0xB7, 0x7B, 0xD1, 0x0E, 0xC0, 0xED,
  0x07, 0x20, 0x7D, 0x10, 0xEC, 0x0E, 0xD0, 0x72, 0x07, 0xD1, 0x0B, 0xC0, 0xBB, 0x71, 0xB1, 0x04,
  0xC0, 0x4B, 0x71, 0xB2, 0x06, 0xA0, 0x61, 0xB7, 0x1B, 0x3A, 0x2D, 0x07, 0x20, 0x7D, 0x3A, 0x2D,
  0x07, 0x20, 0x7D, 0x3A, 0x2D, 0x82, 0xB7, 0x7B, 0xD3, 0xA2, 0xFF, 0x3A, 0x20, 0xDF, 0xD0, 0xD3,
  0xA2, 0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x30, 0x0B, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_medication_liquid() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_medication_liquid_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_medication 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_filled_24_device_medication_data[] PROGMEM = {
  0x1F, 0xD2, 0xFD, 0x77, 0x10, 0x40, 0xDF, 0xB8, 0x1D, 0x4D, 0xFD, 0x0D, 0xFF, 0xD8, 0x2B, 0x77,
  0xBF, 0xB0, 0x72, 0x07, 0xFB, 0x07, 0x20, 0x7F, 0x97, 0x1E, 0x71, 0xE7, 0x1F, 0x90, 0x72, 0x07,
  0xFB, 0x07, 0x20, 0x7F, 0xB8, 0x2B, 0x77, 0xBF, 0xFD, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_medication() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_medication_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_mobiledata_off 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_filled_24_device_mobiledata_off_data[] PROGMEM = {
  0x81, 0x1C, 0x77, 0x30, 0x07, 0x50, 0x4A, 0x07, 0x71, 0x07, 0xA0, 0x75, 0x05, 0xA0, 0x76, 0x07,
  0xC0, 0x75, 0x05, 0xA0, 0x74, 0x07, 0xE0, 0x75, 0x05, 0xA0, 0x76, 0xA7, 0x20, 0x5A, 0x07, 0x5A,
  0x73, 0x05, 0xA0, 0x74, 0xA7, 0x40, 0x5A, 0x07, 0x3A, 0x75, 0xB0, 0x72, 0x0A, 0x97, 0x5C, 0x07,
  0x20, 0xA7, 0x5A, 0x05, 0xA0, 0x77, 0x7A, 0x10, 0x5A, 0x07, 0x76, 0xA2, 0x05, 0xA0, 0x77, 0x5A,
  0x30, 0x5A, 0x07, 0x71, 0x08, 0xE8, 0x17, 0x05, 0xA0, 0x77, 0x10, 0x7C, 0x07, 0x30, 0x5A, 0x07,
  0x71, 0x07, 0xA0, 0x75, 0x05, 0xA0, 0x77, 0x10, 0x07, 0x70, 0x5A, 0x07, 0x77, 0x38, 0x15, 0xFC,
  0x77, 0x40, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_mobiledata_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_mobiledata_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_mobile_friendly 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_24_device_mobile_friendly_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xB0, 0xD0, 0x44, 0x0D, 0xFD, 0x0D, 0x4F, 0xF4, 0xA7, 0x3A, 0x4A, 0x73, 0xA7,
  0x72, 0xA7, 0x20, 0x20, 0x15, 0xA7, 0x18, 0x12, 0xDC, 0x5A, 0x78, 0x22, 0xDF, 0x75, 0xA6, 0x82,
  0x2D, 0xF7, 0x6A, 0x81, 0x3C, 0x22, 0x82, 0x2D, 0xF7, 0x7A, 0x86, 0x7F, 0xD2, 0x2D, 0xF7, 0x71,
  0xA1, 0x84, 0x7F, 0xDD, 0xF7, 0x72, 0xA2, 0x07, 0xA0, 0x77, 0x3A, 0x30, 0x07, 0x74, 0xA7, 0x72,
  0xA7, 0x72, 0xA4, 0xA7, 0x3A, 0x4A, 0x73, 0xA4, 0xFF, 0x40, 0xDF, 0xD0, 0xD4, 0x04, 0x0D, 0xFB,
  0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_mobile_friendly() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_mobile_friendly_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_mobile_off 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_filled_24_device_mobile_off_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xB0, 0xD0, 0x44, 0x03, 0x20, 0x9F, 0xD0, 0xD3, 0x81, 0x3F, 0xB2, 0x0A, 0xFD,
  0x48, 0x1B, 0xFB, 0x20, 0xAF, 0xC5, 0x81, 0xBF, 0xB7, 0x4A, 0x68, 0x1B, 0xFB, 0x73, 0xA7, 0xA0,
  0xB7, 0x2A, 0x7B, 0x0B, 0x71, 0xA7, 0xA8, 0x1B, 0xFB, 0x7A, 0x7A, 0x18, 0x1B, 0xFB, 0x6A, 0x7A,
  0x28, 0x1B, 0xFB, 0x5A, 0x7A, 0x38, 0x1B, 0xFB, 0x4A, 0x7A, 0x48, 0x1B, 0xFB, 0x3A, 0x7A, 0x58,
  0x1B, 0xFB, 0x20, 0xA9, 0x7A, 0x68, 0x1B, 0xFB, 0x20, 0xA7, 0xA7, 0x81, 0xBF, 0xB7, 0x2A, 0x71,
  0x81, 0xBF, 0xB7, 0x1A, 0x72, 0x81, 0xBF, 0xB7, 0xFF, 0x0B, 0x6F, 0xF9, 0x0B, 0x50, 0xDF, 0xD8,
  0x2D, 0xBF, 0xA4, 0x04, 0x0D, 0xFB, 0x83, 0xD4, 0x0A, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_mobile_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_mobile_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_mode_night 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_24_device_mode_night_data[] PROGMEM = {
  0x18, 0x72, 0x7C, 0xEF, 0xDC, 0x72, 0x60, 0x20, 0xEF, 0x90, 0x90, 0x15, 0x02, 0x0C, 0xF9, 0x0D,
  0x02, 0x50, 0x10, 0xDF, 0x90, 0xE0, 0x15, 0x03, 0xFA, 0x0C, 0x60, 0x9F, 0xA0, 0x55, 0x03, 0xFA,
  0x0C, 0x60, 0xDF, 0xA0, 0x25, 0x0A, 0xFA, 0x05, 0x50, 0x8F, 0xA0, 0x65, 0x08, 0xFA, 0x06, 0x50,
  0xAF, 0xA0, 0x55, 0x0D, 0xFA, 0x02, 0x40, 0x3F, 0xA0, 0xC5, 0x09, 0xFA, 0x05, 0x40, 0x3F, 0xA0,
  0xC4, 0x01, 0x0D, 0xF9, 0x0E, 0x01, 0x30, 0x20, 0xCF, 0x90, 0xD0, 0x23, 0x02, 0x0E, 0xF9, 0x09,
  0x01, 0x58, 0x72, 0x7C, 0xEF, 0xDC, 0x72, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_mode_night() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_mode_night_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_mode_standby 24x24, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_filled_24_device_mode_standby_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x67, 0x58, 0x56, 0xFD, 0x05, 0xFC, 0x77, 0x84, 0xCF, 0x59, 0xF6, 0x58,
  0x28, 0xDD, 0x85, 0x84, 0x6F, 0x9D, 0xF2, 0x40, 0x8C, 0x08, 0x48, 0x22, 0xFD, 0xE9, 0x50, 0xDC,
  0x0D, 0x59, 0x00, 0xE9, 0x50, 0xDC, 0x0D, 0x59, 0x82, 0xED, 0xF2, 0x40, 0x8C, 0x08, 0x48, 0x42,
  0xFD, 0x9F, 0x65, 0x82, 0x8D, 0xD8, 0x58, 0x46, 0xF9, 0x5F, 0xC7, 0x78, 0x5C, 0xF5, 0x0D, 0xF6,
  0x75, 0x81, 0x6F, 0xD2, 0x04, 0xA0, 0x47, 0x30, 0x4A, 0x04, 0x30, 0x8A, 0x06, 0x71, 0x06, 0xA0,
  0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x04, 0x0D, 0xF9, 0x0D, 0x04, 0x73,
  0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_mode_standby() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_mode_standby_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_monitor_heart 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_filled_24_device_monitor_heart_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDF, 0xFF, 0xFB, 0x04, 0x03, 0xFF, 0xB0, 0x92,
  0x09, 0xFF, 0xA0, 0x22, 0x02, 0xFF, 0x98, 0x49, 0x02, 0x20, 0x9D, 0x60, 0x3A, 0x82, 0x20, 0x99,
  0x77, 0x82, 0x99, 0x02, 0xA0, 0x36, 0xD8, 0x49, 0x02, 0x20, 0x9F, 0xF9, 0x02, 0x20, 0x2F, 0xFA,
  0x09, 0x20, 0x9F, 0xFB, 0x00, 0x3F, 0xFF, 0xFB, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_monitor_heart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_monitor_heart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_monitor_weight 24x24, 4-bit Alpha,  RLE, 45 bytes.
static const unsigned char ic_filled_24_device_monitor_weight_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0xFF, 0xFC, 0x82, 0x71, 0x17, 0xFE, 0x07, 0x40,
  0x7F, 0xD8, 0x41, 0x73, 0x37, 0x1F, 0xD8, 0x41, 0x73, 0x37, 0x1F, 0xD0, 0x74, 0x07, 0xFE, 0x82,
  0x71, 0x17, 0x80, 0xA8, 0x1F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_monitor_weight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_monitor_weight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_nearby_error 24x24, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_filled_24_device_nearby_error_data[] PROGMEM = {
  0x71, 0x82, 0x4D, 0xD5, 0x77, 0x10, 0x5C, 0x05, 0x76, 0x05, 0xE0, 0x57, 0x40, 0x5B, 0x00, 0x4B,
  0x05, 0x72, 0x05, 0xB0, 0x42, 0x04, 0xB0, 0x57, 0x05, 0xB8, 0x44, 0x01, 0x10, 0x4B, 0x60, 0x5B,
  0x86, 0x40, 0x1D, 0xD1, 0x04, 0xA5, 0x05, 0xB8, 0x24, 0x01, 0xDA, 0x82, 0xD1, 0x04, 0x94, 0x05,
  0xB8, 0x24, 0x01, 0xDC, 0x82, 0xD1, 0x04, 0x2A, 0x0D, 0xA8, 0x24, 0x01, 0xDE, 0x0D, 0x01, 0x3A,
  0x0D, 0xA8, 0x25, 0x01, 0xCE, 0x0C, 0x01, 0x3A, 0x04, 0xB8, 0x25, 0x01, 0xCC, 0x82, 0xC1, 0x05,
  0x2A, 0x10, 0x5B, 0x82, 0x50, 0x1C, 0xA8, 0x2C, 0x10, 0x59, 0x2A, 0x20, 0x5B, 0x86, 0x50, 0x1C,
  0xC1, 0x05, 0xA2, 0xA3, 0x05, 0xB8, 0x45, 0x01, 0x10, 0x5B, 0x2A, 0x40, 0x5B, 0x05, 0x20, 0x5B,
  0x05, 0x2A, 0x50, 0x5B, 0x00, 0x5B, 0x05, 0x74, 0x05, 0xE0, 0x57, 0x60, 0x5C, 0x05, 0x5A, 0x71,
  0x82, 0x4D, 0xD4, 0x6A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_nearby_error() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_nearby_error_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_nearby_off 24x24, 4-bit Alpha,  RLE, 163 bytes.
static const unsigned char ic_filled_24_device_nearby_off_data[] PROGMEM = {
  0x72, 0x82, 0x4D, 0xD4, 0x71, 0x81, 0x1C, 0x75, 0x05, 0xC0, 0x57, 0x04, 0xA0, 0x73, 0x05, 0xE0,
  0x57, 0x05, 0xA0, 0x72, 0x09, 0xA0, 0x04, 0xB0, 0x57, 0x05, 0xA0, 0x72, 0x09, 0x04, 0x20, 0x4B,
  0x05, 0x70, 0x5A, 0x07, 0x38, 0x21, 0x10, 0x4B, 0x05, 0x60, 0x5B, 0x07, 0x28, 0x38, 0xC1, 0x04,
  0xB0, 0x54, 0x05, 0xD0, 0x72, 0x83, 0xAC, 0x10, 0x4B, 0x05, 0x20, 0x4B, 0x04, 0x05, 0xA0, 0x72,
  0x83, 0xAC, 0x10, 0x4B, 0x81, 0x40, 0xDA, 0x82, 0x40, 0x1D, 0xA0, 0x72, 0x83, 0xAC, 0x10, 0x4A,
  0x81, 0xD0, 0xDA, 0x82, 0x40, 0x1C, 0xB0, 0x72, 0x82, 0x81, 0x04, 0xA8, 0x1D, 0x04, 0xB8, 0x24,
  0x01, 0xCB, 0x07, 0x30, 0x4B, 0x04, 0x20, 0x5B, 0x82, 0x40, 0x1C, 0xB0, 0x72, 0x09, 0xA0, 0x54,
  0x05, 0xB8, 0x34, 0x01, 0xDD, 0xA0, 0x72, 0x09, 0x05, 0x60, 0x5B, 0x83, 0x40, 0x11, 0x5A, 0x07,
  0x73, 0x05, 0xB0, 0x42, 0x04, 0xB0, 0x77, 0x30, 0x5B, 0x00, 0x4D, 0x07, 0x73, 0x05, 0xE0, 0x05,
  0xA0, 0x77, 0x30, 0x5C, 0x05, 0x20, 0x5A, 0x07, 0x73, 0x82, 0x4D, 0xD4, 0x48, 0x15, 0xFC, 0x77,
  0x50, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_nearby_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_nearby_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_network_cell 24x24, 4-bit Alpha,  RLE, 68 bytes.
static const unsigned char ic_filled_24_device_network_cell_data[] PROGMEM = {
  0x77, 0x50, 0x77, 0x74, 0x07, 0x97, 0x73, 0x07, 0xA7, 0x72, 0x07, 0xB7, 0x71, 0x07, 0xC7, 0x70,
  0x7A, 0x05, 0xA7, 0x60, 0x7A, 0x05, 0x1A, 0x75, 0x07, 0xA0, 0x52, 0xA7, 0x40, 0x7B, 0x3A, 0x73,
  0x07, 0xC3, 0xA7, 0x20, 0x7D, 0x3A, 0x71, 0x07, 0xE3, 0xA7, 0x07, 0xF3, 0xA6, 0x07, 0xF9, 0x3A,
  0x50, 0x7F, 0xA3, 0xA4, 0x07, 0xFB, 0x3A, 0x30, 0x7F, 0xC3, 0xA2, 0x07, 0xFD, 0x3A, 0x10, 0x7F,
  0xFC, 0x07, 0xFF, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_network_cell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_network_cell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_network_wifi_1_bar 24x24, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_filled_24_device_network_wifi_1_bar_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9B, 0x82, 0xB7, 0x31, 0x28, 0x21, 0x37, 0xBB, 0x09, 0x01, 0x38, 0x44, 0xEF, 0xE8, 0x17, 0x38,
  0x61, 0x8E, 0xFE, 0x40, 0x6A, 0x0A, 0x01, 0x77, 0x01, 0x0A, 0xA0, 0x60, 0x7A, 0x05, 0x77, 0x20,
  0x5A, 0x81, 0x70, 0x7A, 0x05, 0x77, 0x05, 0xA0, 0x73, 0x07, 0xA0, 0x57, 0x50, 0x5A, 0x07, 0x50,
  0x7A, 0x05, 0x73, 0x05, 0xA0, 0x77, 0x07, 0xA0, 0x57, 0x10, 0x5A, 0x07, 0x72, 0x07, 0xA8, 0x66,
  0x7C, 0xEE, 0xC7, 0x6A, 0x07, 0x74, 0x07, 0xFB, 0x07, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x10, 0x7E,
  0x07, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x70, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_network_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_network_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_network_wifi_2_bar 24x24, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_filled_24_device_network_wifi_2_bar_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9B, 0x82, 0xB7, 0x31, 0x28, 0x21, 0x37, 0xBB, 0x09, 0x01, 0x38, 0x44, 0xEF, 0xE8, 0x17, 0x38,
  0x61, 0x8E, 0xFE, 0x40, 0x6A, 0x0A, 0x01, 0x77, 0x01, 0x0A, 0xA0, 0x60, 0x7A, 0x05, 0x77, 0x20,
  0x5A, 0x81, 0x70, 0x7A, 0x05, 0x77, 0x05, 0xA0, 0x73, 0x07, 0xA0, 0x57, 0x50, 0x5A, 0x07, 0x50,
  0x7A, 0x83, 0x50, 0x49, 0xDA, 0x83, 0xD9, 0x40, 0x5A, 0x07, 0x70, 0x7A, 0x0C, 0xF9, 0x0C, 0xA0,
  0x77, 0x20, 0x7F, 0xD0, 0x77, 0x40, 0x7F, 0xB0, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x71, 0x07, 0xE0,
  0x77, 0x73, 0x07, 0xC0, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x00, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_network_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_network_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_network_wifi_3_bar 24x24, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_filled_24_device_network_wifi_3_bar_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9B, 0x82, 0xB7, 0x31, 0x28, 0x21, 0x37, 0xBB, 0x09, 0x01, 0x38, 0x44, 0xEF, 0xE8, 0x17, 0x38,
  0x61, 0x8E, 0xFE, 0x40, 0x6A, 0x0A, 0x01, 0x77, 0x01, 0x0A, 0xA0, 0x60, 0x7A, 0x05, 0x77, 0x20,
  0x5A, 0x81, 0x70, 0x7A, 0x05, 0x38, 0x16, 0xAD, 0xA8, 0x1D, 0xA6, 0x30, 0x5A, 0x07, 0x30, 0x7A,
  0x81, 0x57, 0xEF, 0x98, 0x1E, 0x75, 0xA0, 0x75, 0x07, 0xFF, 0xA0, 0x77, 0x07, 0xFF, 0x07, 0x72,
  0x07, 0xFD, 0x07, 0x74, 0x07, 0xFB, 0x07, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x10, 0x7E, 0x07, 0x77,
  0x30, 0x7C, 0x07, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x70, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_network_wifi_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_network_wifi_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_network_wifi 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_filled_24_device_network_wifi_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9B, 0x82, 0xB7, 0x31, 0x28, 0x21, 0x37, 0xBB, 0x09, 0x01, 0x38, 0x44, 0xEF, 0xE8, 0x17, 0x38,
  0x61, 0x8E, 0xFE, 0x40, 0x6A, 0x0A, 0x01, 0x28, 0x22, 0x7B, 0xDA, 0x82, 0xDB, 0x72, 0x20, 0x10,
  0xAA, 0x06, 0x07, 0xA8, 0x25, 0x03, 0xBF, 0xB8, 0x2B, 0x30, 0x5A, 0x81, 0x70, 0x7A, 0x0A, 0xFF,
  0x0A, 0xA0, 0x73, 0x07, 0xFF, 0xC0, 0x75, 0x07, 0xFF, 0xA0, 0x77, 0x07, 0xFF, 0x07, 0x72, 0x07,
  0xFD, 0x07, 0x74, 0x07, 0xFB, 0x07, 0x76, 0x07, 0xF9, 0x07, 0x77, 0x10, 0x7E, 0x07, 0x77, 0x30,
  0x7C, 0x07, 0x77, 0x50, 0x7A, 0x07, 0x77, 0x70, 0x07, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_network_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_network_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_nfc 24x24, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_filled_24_device_nfc_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x77, 0x2C, 0x77, 0x2C, 0x2C, 0x10, 0x40,
  0xDD, 0x2C, 0x2C, 0x10, 0xDE, 0x2C, 0x2A, 0x3A, 0x3A, 0x2C, 0x2A, 0x3A, 0x3A, 0x2C, 0x2A, 0x20,
  0x4A, 0x04, 0x2A, 0x2C, 0x2A, 0x20, 0xDA, 0x0D, 0x2A, 0x2C, 0x2A, 0x20, 0xDA, 0x0D, 0x2A, 0x2C,
  0x2A, 0x28, 0x24, 0xDD, 0x42, 0xA2, 0xC2, 0xA7, 0x1A, 0x2C, 0x2A, 0x71, 0xA2, 0xC2, 0xFD, 0x2C,
  0x2F, 0xD2, 0xC7, 0x72, 0xC7, 0x72, 0xA0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_nfc() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_nfc_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_nightlight 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_filled_24_device_nightlight_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEF, 0xDA, 0x55, 0x04, 0x0D, 0xF9, 0x09, 0x30, 0x8F, 0xA0, 0x73, 0x08, 0xFA,
  0x07, 0x30, 0x4F, 0xA0, 0xB4, 0x0D, 0xFA, 0x02, 0x30, 0x5F, 0xA0, 0xB4, 0x09, 0xFA, 0x05, 0x40,
  0xDF, 0xA0, 0x34, 0x0E, 0xFA, 0x01, 0x40, 0xEF, 0xA0, 0x14, 0x0D, 0xFA, 0x03, 0x40, 0x9F, 0xA0,
  0x54, 0x05, 0xFA, 0x0B, 0x50, 0xDF, 0xA0, 0x24, 0x04, 0xFA, 0x0B, 0x50, 0x8F, 0xA0, 0x75, 0x08,
  0xFA, 0x07, 0x50, 0x40, 0xDF, 0x90, 0x96, 0x86, 0x59, 0xDE, 0xFD, 0xA5, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_nightlight() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 18, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_nightlight_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_note_alt 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_filled_24_device_note_alt_data[] PROGMEM = {
  0x78, 0x28, 0xEE, 0x87, 0x68, 0x48, 0xFE, 0xEF, 0x86, 0x04, 0x0D, 0xE0, 0x05, 0xE8, 0x1D, 0x4D,
  0xF0, 0x0E, 0xF0, 0xD8, 0x0D, 0x3F, 0x81, 0x64, 0xEF, 0xF8, 0x2D, 0x10, 0x4F, 0xE8, 0x35, 0x6D,
  0x16, 0xFD, 0x05, 0x20, 0x60, 0xDF, 0xD0, 0x53, 0x06, 0xFD, 0x05, 0x30, 0x6F, 0xD0, 0x53, 0x06,
  0xFD, 0x05, 0x30, 0x6F, 0xE3, 0x06, 0xFF, 0x20, 0x68, 0x0D, 0x3F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D,
  0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_note_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_note_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_password 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_24_device_password_data[] PROGMEM = {
  0x18, 0x29, 0x66, 0x94, 0x82, 0x96, 0x69, 0x48, 0x29, 0x66, 0x92, 0x82, 0xBE, 0xEB, 0x48, 0x2B,
  0xEE, 0xB4, 0x85, 0xBE, 0xEB, 0x0B, 0xDA, 0x0D, 0x0B, 0x20, 0xB0, 0xDA, 0x0D, 0x0B, 0x20, 0xB0,
  0xDA, 0x82, 0xDB, 0xBD, 0xA0, 0xD0, 0xB2, 0x0B, 0x0D, 0xA0, 0xD0, 0xB2, 0x0B, 0x0D, 0xA8, 0x5D,
  0xB0, 0xBE, 0xEB, 0x48, 0x2B, 0xEE, 0xB4, 0x82, 0xBE, 0xEB, 0x28, 0x28, 0x66, 0x84, 0x82, 0x86,
  0x68, 0x48, 0x28, 0x66, 0x88, 0x09, 0xA6, 0x0F, 0xFE, 0x2F, 0xFE, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_password() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 7, 22, 18), Box(0, 0, 23, 23),
      ic_filled_24_device_password_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_pattern 24x24, 4-bit Alpha,  RLE, 115 bytes.
static const unsigned char ic_filled_24_device_pattern_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x42, 0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20,
  0xDA, 0x00, 0xDA, 0x0D, 0x20, 0xDA, 0x81, 0xD0, 0x1B, 0x83, 0xD4, 0xDD, 0x42, 0x84, 0x4D, 0xD4,
  0x1C, 0xA0, 0xD0, 0x47, 0x28, 0x31, 0xCF, 0xC1, 0x73, 0x83, 0x1C, 0xFC, 0x13, 0x82, 0x4D, 0xD4,
  0x20, 0x40, 0xDA, 0x85, 0xC1, 0x4D, 0xD4, 0xDA, 0x0D, 0x20, 0xDB, 0x81, 0x10, 0xDA, 0x00, 0xDA,
  0x81, 0xD0, 0x1B, 0x0D, 0x20, 0xDA, 0x85, 0xD4, 0xDD, 0x41, 0xCA, 0x0D, 0x04, 0x28, 0x24, 0xDD,
  0x43, 0x83, 0x1C, 0xFC, 0x17, 0x38, 0x31, 0xCF, 0xC1, 0x72, 0x04, 0x0D, 0xA8, 0x4C, 0x14, 0xDD,
  0x42, 0x83, 0x4D, 0xD4, 0xDF, 0xF0, 0x0D, 0xFF, 0x83, 0xD4, 0xDD, 0x42, 0x82, 0x3D, 0xD4, 0x28,
  0x24, 0xDD, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_pattern() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_pattern_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_phishing 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_24_device_phishing_data[] PROGMEM = {
  0x73, 0xA7, 0x5A, 0x75, 0xA7, 0x5A, 0x74, 0x08, 0xA0, 0x87, 0x20, 0x8C, 0x08, 0x71, 0x85, 0xEF,
  0x33, 0xFE, 0x77, 0x86, 0xEF, 0x33, 0xFE, 0xF7, 0x60, 0x8C, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x81,
  0xB0, 0x76, 0xA2, 0xC0, 0x75, 0xA2, 0xA7, 0x1A, 0x28, 0x1E, 0xF1, 0x68, 0x11, 0xFE, 0x28, 0x1C,
  0xF5, 0x68, 0x15, 0xFC, 0x28, 0x26, 0xFD, 0x14, 0x82, 0x1D, 0xF6, 0x38, 0x90, 0xCF, 0xD5, 0x11,
  0x5D, 0xFC, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x68, 0x46, 0xCE, 0xEC, 0x65,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_phishing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_phishing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_pin 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_filled_24_device_pin_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0F, 0x3F, 0x89, 0x4D, 0x35, 0xFE, 0x40,
  0x4E, 0xF9, 0x11, 0xAE, 0x89, 0x43, 0x25, 0xFC, 0x6D, 0x29, 0xF9, 0xB8, 0x4F, 0x07, 0x05, 0xB8,
  0x1D, 0x1C, 0xA8, 0x19, 0x19, 0xF0, 0x70, 0x5A, 0x81, 0xE2, 0x7B, 0x81, 0xB5, 0x4F, 0x84, 0x75,
  0xFE, 0x26, 0xB8, 0x24, 0xB9, 0x1F, 0x82, 0x75, 0xF9, 0x38, 0x47, 0xF9, 0x11, 0x98, 0x0F, 0x3F,
  0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_pin() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_pin_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_play_lesson 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_filled_24_device_play_lesson_data[] PROGMEM = {
  0x04, 0x0D, 0xFD, 0x0D, 0x04, 0x40, 0xDF, 0xF0, 0xD4, 0xC5, 0xF4, 0xC5, 0xF4, 0xC5, 0xF4, 0xC5,
  0xF4, 0xC5, 0xF4, 0xC2, 0x05, 0x2F, 0x4C, 0x83, 0x4D, 0xFD, 0x4F, 0x4F, 0xC8, 0x1E, 0x72, 0x6F,
  0xB0, 0xA7, 0x2F, 0xA0, 0xA2, 0x84, 0x4B, 0xEE, 0xB4, 0x2F, 0x90, 0xE2, 0x08, 0xE0, 0x81, 0xF9,
  0x81, 0x70, 0x4A, 0x0D, 0x0E, 0xC0, 0x4F, 0x98, 0x12, 0x0B, 0xA8, 0x1B, 0x19, 0xB0, 0xBF, 0x92,
  0x0E, 0xA0, 0xB2, 0x82, 0x3C, 0xFE, 0xF9, 0x20, 0xEA, 0x0B, 0x28, 0x23, 0xCF, 0xEF, 0x98, 0x12,
  0x0B, 0xA8, 0x1B, 0x19, 0xB0, 0xB0, 0xDF, 0x81, 0x70, 0x4A, 0x0D, 0x0E, 0xC8, 0x14, 0x4D, 0xE0,
  0xE2, 0x08, 0xE0, 0x87, 0x68, 0x44, 0xBE, 0xEB, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_play_lesson() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_play_lesson_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_price_change 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_24_device_price_change_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDF, 0xFF, 0xD2, 0xFF, 0xA0, 0x35, 0xB0, 0x07,
  0xFA, 0x6A, 0x07, 0x20, 0x7F, 0x92, 0xFF, 0xC5, 0x03, 0xFF, 0x03, 0x5F, 0xFC, 0x2F, 0xF6, 0xA8,
  0x28, 0x33, 0x8F, 0x95, 0x03, 0xB0, 0x04, 0xFC, 0x2F, 0xFF, 0xFC, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D,
  0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_price_change() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_price_change_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_price_check 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_filled_24_device_price_check_data[] PROGMEM = {
  0x28, 0x17, 0xF7, 0x74, 0x0B, 0xE7, 0x2F, 0x72, 0xA7, 0x7A, 0x77, 0xE0, 0xB7, 0x20, 0xBE, 0x77,
  0xA7, 0x7A, 0x72, 0xF7, 0x03, 0x1E, 0x0B, 0x68, 0x16, 0xF8, 0x28, 0x17, 0xF7, 0x70, 0x6A, 0x06,
  0x50, 0x20, 0x44, 0x06, 0xA0, 0x65, 0x82, 0x1D, 0xF4, 0x20, 0x6A, 0x06, 0x70, 0x8A, 0x04, 0x06,
  0xA0, 0x67, 0x20, 0x8C, 0x06, 0x74, 0x08, 0xA0, 0x67, 0x60, 0x80, 0x66,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_price_check() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_price_check_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_punch_clock 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_filled_24_device_punch_clock_data[] PROGMEM = {
  0x3F, 0xD6, 0xFD, 0x6A, 0x71, 0xA6, 0xA7, 0x1A, 0x6A, 0x71, 0xA3, 0x04, 0x0D, 0xFF, 0x81, 0xD4,
  0xDF, 0xFA, 0x0D, 0xFF, 0xFB, 0x0A, 0x03, 0x20, 0x30, 0xAF, 0xC0, 0x76, 0x07, 0xFA, 0x0A, 0x30,
  0x03, 0x30, 0xAF, 0x90, 0x33, 0x00, 0x73, 0x03, 0xF9, 0x40, 0x70, 0x84, 0xF9, 0x48, 0x13, 0xE3,
  0x3F, 0x90, 0x34, 0x03, 0x07, 0x20, 0x3F, 0x90, 0xA7, 0x10, 0xAF, 0xA0, 0x76, 0x07, 0xFC, 0x0A,
  0x03, 0x20, 0x30, 0xAF, 0xFF, 0xB0, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xF0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_punch_clock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_punch_clock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_quiz 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_24_device_quiz_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xD0, 0xD0, 0x44, 0x0D, 0xFF, 0x0D, 0x4F, 0xFA, 0x4E, 0x83, 0x61, 0x05, 0xEF,
  0x2D, 0x84, 0x60, 0x66, 0x06, 0xF2, 0xD0, 0xB0, 0x9A, 0x04, 0x02, 0xF2, 0xF9, 0x81, 0xD1, 0x5F,
  0x2F, 0x82, 0xE2, 0x2E, 0xF2, 0xF8, 0x16, 0x0D, 0xF9, 0x2F, 0x05, 0x04, 0xFA, 0x2F, 0xFC, 0x2F,
  0x00, 0x2F, 0xA2, 0xF0, 0x03, 0xFA, 0x2F, 0xFC, 0x20, 0xDF, 0xF0, 0xDA, 0x20, 0x40, 0xDF, 0xD0,
  0xD0, 0x4A, 0x77, 0x4A, 0x77, 0x40, 0xDF, 0xF9, 0x40, 0x40, 0xDF, 0xF4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_quiz() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_quiz_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_radar 24x24, 4-bit Alpha,  RLE, 178 bytes.
static const unsigned char ic_filled_24_device_radar_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x28, 0x46,
  0xCE, 0xEB, 0x62, 0x04, 0xA0, 0x42, 0x84, 0xDF, 0x60, 0x1C, 0xE8, 0x90, 0xC1, 0x06, 0xFD, 0x05,
  0xFC, 0x28, 0x90, 0xCF, 0xD5, 0x11, 0x5E, 0xFC, 0x28, 0x91, 0xCF, 0x59, 0xF6, 0x06, 0xFD, 0x14,
  0x8B, 0x31, 0xEF, 0x60, 0x6F, 0x9D, 0xF2, 0x0C, 0xF5, 0x04, 0xDD, 0x40, 0x5F, 0xB0, 0x2F, 0xDE,
  0x92, 0x83, 0xEF, 0x10, 0xDA, 0x83, 0xD0, 0x1F, 0xE2, 0x90, 0x0E, 0x92, 0xA8, 0x11, 0x0D, 0xA8,
  0x3E, 0x11, 0xFD, 0x29, 0x8B, 0x2E, 0xDF, 0x20, 0xCF, 0x40, 0x4D, 0xEF, 0xC6, 0xFB, 0x02, 0xFD,
  0x9F, 0x60, 0x6F, 0xD3, 0x01, 0x0C, 0xB8, 0x65, 0x06, 0xF9, 0x5F, 0xC2, 0x85, 0xCF, 0xD5, 0x10,
  0x6B, 0x89, 0x21, 0x0C, 0xF5, 0x0D, 0xF6, 0x01, 0xCF, 0x98, 0x2C, 0x7F, 0xD2, 0x04, 0xA0, 0x42,
  0x86, 0x6C, 0xEE, 0xB5, 0x1C, 0xB0, 0x43, 0x08, 0xA0, 0x67, 0x10, 0x7A, 0x08, 0x50, 0x8A, 0x81,
  0xC6, 0x22, 0x81, 0x26, 0xCA, 0x08, 0x70, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x38, 0x65, 0x9D, 0xEE,
  0xD9, 0x56,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_radar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_radar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_remember_me 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_filled_24_device_remember_me_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC3, 0x82, 0x8D, 0xD8, 0x3C,
  0x20, 0x8C, 0x08, 0x2C, 0x20, 0xDC, 0x0D, 0x2C, 0x20, 0xDC, 0x0D, 0x2C, 0x20, 0x8C, 0x08, 0x2C,
  0x38, 0x28, 0xDD, 0x83, 0xC7, 0x3C, 0x18, 0x65, 0xAD, 0xFE, 0xCA, 0x51, 0xC0, 0xEF, 0x90, 0xE8,
  0x09, 0x84, 0xF0, 0xDF, 0xD8, 0x1D, 0x4D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_remember_me() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_remember_me_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_reset_tv 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_filled_24_device_reset_tv_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x77, 0x4C, 0x77, 0x4C, 0x72, 0x07, 0x71,
  0xC7, 0x10, 0x79, 0x73, 0xA7, 0x07, 0xA7, 0x3A, 0x60, 0x7F, 0xC0, 0xD0, 0x4A, 0x60, 0x7F, 0xD0,
  0xDA, 0x70, 0x7A, 0x71, 0xC7, 0x10, 0x79, 0x71, 0xC7, 0x20, 0x77, 0x1C, 0x77, 0x4C, 0x77, 0x4A,
  0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x47, 0xF9, 0x77, 0xF9, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_reset_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_reset_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_restart_alt 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_filled_24_device_restart_alt_data[] PROGMEM = {
  0x70, 0x77, 0x70, 0x79, 0x76, 0x07, 0xA7, 0x50, 0x7B, 0x82, 0xEC, 0x82, 0x71, 0x07, 0xF0, 0x95,
  0x05, 0x20, 0x7A, 0x10, 0x30, 0x8A, 0x0B, 0x38, 0x19, 0xF6, 0x20, 0x79, 0x38, 0x42, 0xDF, 0x90,
  0x2A, 0x02, 0x30, 0x74, 0x02, 0xA8, 0x22, 0x8F, 0x87, 0x38, 0x48, 0xF8, 0xCF, 0x37, 0x38, 0x23,
  0xFC, 0xE9, 0x75, 0x90, 0x0E, 0x97, 0x59, 0x82, 0xEC, 0xF3, 0x73, 0x84, 0x3F, 0xC8, 0xF8, 0x73,
  0x82, 0x8F, 0x82, 0xA0, 0x27, 0x10, 0x2A, 0x84, 0x20, 0x9F, 0xE3, 0x68, 0x22, 0xDF, 0x93, 0x0B,
  0xA0, 0x90, 0x42, 0x03, 0x08, 0xA0, 0xB5, 0x08, 0xB2, 0xB0, 0x87, 0x81, 0x28, 0xC2, 0x81, 0xC8,
  0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_restart_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_restart_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_reviews 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_filled_24_device_reviews_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDF, 0xFF, 0xF9, 0x00, 0xBF, 0xFC, 0x00, 0x4F,
  0xFB, 0x0D, 0x20, 0xDF, 0xF9, 0x0D, 0x04, 0x20, 0x40, 0xDF, 0xD0, 0xB0, 0x46, 0x04, 0x0B, 0xFB,
  0x0B, 0x04, 0x60, 0x40, 0xBF, 0xD0, 0xD0, 0x42, 0x04, 0x0D, 0xFF, 0x90, 0xD2, 0x0D, 0xFF, 0xB0,
  0x04, 0xFF, 0xC0, 0x0B, 0x80, 0xD4, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77,
  0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_reviews() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_reviews_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_r_mobiledata 24x24, 4-bit Alpha,  RLE, 21 bytes.
static const unsigned char ic_filled_24_device_r_mobiledata_data[] PROGMEM = {
  0xD0, 0xD0, 0x4E, 0x0D, 0xA3, 0xC0, 0xF9, 0x90, 0xEE, 0x08, 0xA8, 0x25, 0x6F, 0xE1, 0xA2, 0x81,
  0x9F, 0x5A, 0x28, 0x13, 0xFC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_r_mobiledata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 8, 9), Box(0, 0, 23, 23),
      ic_filled_24_device_r_mobiledata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_rsvp 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_24_device_rsvp_data[] PROGMEM = {
  0xC8, 0x18, 0x0B, 0xB8, 0x57, 0x5F, 0x22, 0xF5, 0xC8, 0xA4, 0x8F, 0xB7, 0xBF, 0x0F, 0xB7, 0x73,
  0x1F, 0x66, 0xF1, 0xFB, 0x7B, 0xA8, 0xA2, 0xB7, 0xBE, 0x0F, 0xDB, 0xB2, 0x0B, 0xBB, 0xB0, 0xFB,
  0x7B, 0xD8, 0x77, 0x09, 0xBB, 0xF7, 0x07, 0xA0, 0x71, 0xC8, 0x94, 0x8F, 0x72, 0xF5, 0x07, 0x77,
  0xF7, 0x02, 0xA8, 0x22, 0x0F, 0x73, 0x98, 0x27, 0x0B, 0xC1, 0xC0, 0x42, 0x00, 0xD2, 0x90, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_rsvp() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 9, 22, 14), Box(0, 0, 23, 23),
      ic_filled_24_device_rsvp_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_screen_lock_landscape 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_24_device_screen_lock_landscape_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDC, 0x77, 0xF9, 0x58, 0x24, 0xCC, 0x45, 0xF9,
  0x50, 0xC2, 0x0C, 0x5F, 0x95, 0x0C, 0x20, 0xC5, 0xF9, 0x40, 0xBC, 0x0B, 0x4F, 0x94, 0xE4, 0xF9,
  0x4E, 0x4F, 0x94, 0xE4, 0xF9, 0x40, 0xBC, 0x0B, 0x4F, 0x97, 0x7C, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D,
  0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_screen_lock_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_filled_24_device_screen_lock_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_screen_lock_portrait 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_filled_24_device_screen_lock_portrait_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC3, 0x82,
  0x4C, 0xC4, 0x3C, 0x30, 0xC2, 0x0C, 0x3C, 0x30, 0xC2, 0x0C, 0x3C, 0x20, 0xBC, 0x0B, 0x2C, 0x2E,
  0x2C, 0x2E, 0x2C, 0x2E, 0x2C, 0x20, 0xBC, 0x0B, 0x2C, 0x73, 0xC7, 0x3C, 0x73, 0xFF, 0xFF, 0xA0,
  0xDF, 0xD8, 0x1D, 0x4D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_screen_lock_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_screen_lock_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_screen_lock_rotation 24x24, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_filled_24_device_screen_lock_rotation_data[] PROGMEM = {
  0x71, 0x81, 0x79, 0x14, 0x83, 0x1B, 0xCB, 0x17, 0x30, 0x9A, 0x0D, 0x01, 0x38, 0x3B, 0x30, 0x3B,
  0x72, 0x85, 0x9F, 0xEC, 0xFD, 0x12, 0x0C, 0x30, 0xC7, 0x18, 0x90, 0x9F, 0xE3, 0x0C, 0xF5, 0x0B,
  0xD0, 0xB6, 0x82, 0x9F, 0xE3, 0x30, 0x42, 0xF5, 0x82, 0x9F, 0xE3, 0x7F, 0x48, 0x29, 0xFE, 0x37,
  0x1F, 0x38, 0x27, 0xFE, 0x37, 0x2F, 0x38, 0x19, 0xFC, 0x73, 0x0B, 0xD0, 0xB3, 0x82, 0x1D, 0xFC,
  0x77, 0x68, 0x21, 0xDF, 0xC7, 0x60, 0x70, 0x15, 0x82, 0x1D, 0xFC, 0x74, 0x85, 0x7F, 0xD1, 0x0E,
  0x92, 0x82, 0x1D, 0xFC, 0x74, 0x84, 0xCF, 0xD1, 0xBD, 0x38, 0x21, 0xDF, 0xC7, 0x48, 0x4C, 0xF9,
  0x7F, 0x13, 0x82, 0x1D, 0xFC, 0x72, 0x85, 0x3E, 0xF7, 0x1F, 0x84, 0x82, 0x1D, 0xFC, 0x78, 0x23,
  0xEF, 0x92, 0x81, 0xAF, 0x14, 0x82, 0x1D, 0xFC, 0x58, 0x23, 0xEF, 0x93, 0x81, 0x1E, 0xB5, 0x82,
  0x1D, 0xFC, 0x38, 0x23, 0xEF, 0x95, 0x81, 0x5F, 0xA5, 0x87, 0x1D, 0xFC, 0x03, 0xEF, 0x97, 0x89,
  0x57, 0xFB, 0x20, 0x73, 0x01, 0xDF, 0xCE, 0xF9, 0x72, 0x89, 0x05, 0xEF, 0xBF, 0xE3, 0x01, 0xDA,
  0x09, 0x74, 0x02, 0x09, 0xB8, 0x4E, 0x30, 0x19, 0x77, 0x78, 0x41, 0x6B, 0xDD, 0x37, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_screen_lock_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 23, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_screen_lock_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_screen_rotation 24x24, 4-bit Alpha,  RLE, 211 bytes.
static const unsigned char ic_filled_24_device_screen_rotation_data[] PROGMEM = {
  0x74, 0x84, 0x3E, 0xDA, 0x61, 0x77, 0x18, 0x47, 0x91, 0x03, 0xEB, 0x09, 0x01, 0x75, 0x09, 0xA8,
  0x90, 0xD1, 0x03, 0xEF, 0xBF, 0xE4, 0x73, 0x89, 0x59, 0xF7, 0x3E, 0xD1, 0x03, 0x70, 0x3C, 0xF6,
  0x71, 0x81, 0x9F, 0x72, 0x82, 0x3E, 0xD1, 0x58, 0x1B, 0xF5, 0x68, 0x19, 0xF7, 0x48, 0x23, 0xED,
  0x15, 0x81, 0xCE, 0x14, 0x81, 0x9F, 0x76, 0x82, 0x3E, 0xD1, 0x48, 0x12, 0xF9, 0x38, 0x19, 0xF7,
  0x71, 0x82, 0x3E, 0xD1, 0x48, 0x59, 0xF1, 0x07, 0xF7, 0x73, 0x82, 0x3E, 0xD1, 0x38, 0x52, 0xF6,
  0x09, 0xE3, 0x74, 0x82, 0x3E, 0xD1, 0x38, 0x5D, 0xA0, 0x1D, 0xE3, 0x74, 0x82, 0x3E, 0xD1, 0x20,
  0xA0, 0xD2, 0x82, 0x1D, 0xE3, 0x74, 0x82, 0x3E, 0xD1, 0x68, 0x21, 0xDE, 0x37, 0x48, 0x23, 0xED,
  0x12, 0x0D, 0x0A, 0x28, 0x21, 0xDE, 0x37, 0x48, 0x53, 0xED, 0x10, 0xAD, 0x38, 0x21, 0xDE, 0x37,
  0x48, 0x53, 0xE9, 0x06, 0xF2, 0x38, 0x21, 0xDE, 0x37, 0x38, 0x57, 0xF7, 0x01, 0xF9, 0x48, 0x21,
  0xDE, 0x37, 0x18, 0x17, 0xF9, 0x38, 0x19, 0xF2, 0x48, 0x21, 0xDE, 0x36, 0x81, 0x7F, 0x94, 0x81,
  0x1E, 0xC5, 0x82, 0x1D, 0xE3, 0x48, 0x17, 0xF9, 0x68, 0x15, 0xFB, 0x58, 0x21, 0xDE, 0x32, 0x81,
  0x7F, 0x97, 0x18, 0x95, 0x6F, 0xC2, 0x07, 0x30, 0x1D, 0xE3, 0x7F, 0x97, 0x38, 0x90, 0x4E, 0xFB,
  0xFE, 0x30, 0x1D, 0xA0, 0x97, 0x50, 0x10, 0x9B, 0x84, 0xE3, 0x01, 0x97, 0x77, 0x18, 0x41, 0x6A,
  0xDE, 0x37, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_screen_rotation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 23, 23), Box(0, 0, 23, 23),
      ic_filled_24_device_screen_rotation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_screen_search_desktop 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_filled_24_device_screen_search_desktop_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x40, 0xDF, 0xFC, 0x0D, 0x4A, 0x60, 0x02, 0x71, 0xA4, 0xA4,
  0x02, 0x0C, 0xA0, 0xC0, 0x16, 0xA4, 0xA4, 0x84, 0xCC, 0x33, 0xCB, 0x6A, 0x4A, 0x38, 0x12, 0xF3,
  0x28, 0x14, 0xF1, 0x5A, 0x4A, 0x38, 0x12, 0xF3, 0x28, 0x14, 0xF1, 0x5A, 0x4A, 0x48, 0x4C, 0xC4,
  0x4D, 0xC6, 0xA4, 0xA4, 0x01, 0x0B, 0xA8, 0x1C, 0xF6, 0x5A, 0x4A, 0x68, 0x41, 0x10, 0x7F, 0x64,
  0xA4, 0xA7, 0x30, 0x70, 0xB4, 0xA4, 0xA7, 0x72, 0xA4, 0x0D, 0xFF, 0xC0, 0xD4, 0x04, 0x0D, 0xFF,
  0xA0, 0xD0, 0x42, 0x80, 0xD4, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_screen_search_desktop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_screen_search_desktop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_screenshot_monitor 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_filled_24_device_screenshot_monitor_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x77, 0x2C, 0x1C, 0x74, 0xC1, 0x98, 0x1B,
  0x77, 0x74, 0xC1, 0x90, 0x77, 0x6C, 0x19, 0x07, 0x76, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x60, 0x79,
  0x1C, 0x76, 0x07, 0x91, 0xC7, 0x48, 0x17, 0x7B, 0x91, 0xC7, 0x4C, 0x1C, 0x77, 0x2A, 0x0D, 0xFF,
  0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x46, 0xF9, 0x75, 0xF9, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_screenshot_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_screenshot_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_screenshot 24x24, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_filled_24_device_screenshot_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC1, 0xC5, 0xC1, 0x98, 0x1B,
  0x77, 0x5C, 0x19, 0x07, 0x7C, 0x19, 0x07, 0x7C, 0x73, 0xC7, 0x3C, 0x70, 0x79, 0x1C, 0x70, 0x79,
  0x1C, 0x58, 0x17, 0x7B, 0x91, 0xC5, 0xC1, 0xC7, 0x38, 0x0D, 0x0F, 0x0D, 0xFD, 0x81, 0xD4, 0xDF,
  0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_screenshot() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_screenshot_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_sd_storage 24x24, 4-bit Alpha,  RLE, 38 bytes.
static const unsigned char ic_filled_24_device_sd_storage_data[] PROGMEM = {
  0x50, 0x7F, 0x90, 0xD0, 0x44, 0x07, 0xFB, 0x0D, 0x30, 0x7A, 0x29, 0x29, 0x2A, 0x20, 0x7B, 0x29,
  0x29, 0x2A, 0x10, 0x7C, 0x29, 0x29, 0x2A, 0x07, 0xD2, 0x92, 0x92, 0x80, 0xAF, 0x6F, 0x0D, 0xFF,
  0x81, 0xD4, 0xDF, 0xD0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_sd_storage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_sd_storage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_security_update_good 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_filled_24_device_security_update_good_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC7, 0x3C, 0x70, 0x22, 0xC6,
  0x81, 0x4F, 0x61, 0xC5, 0x04, 0xA0, 0x81, 0xC1, 0x82, 0x2E, 0x54, 0xA0, 0x82, 0xC1, 0x06, 0xC0,
  0x83, 0xC2, 0x06, 0xA0, 0x84, 0xC3, 0x06, 0x08, 0x5C, 0x73, 0xC7, 0x3C, 0x73, 0x80, 0xD0, 0xF0,
  0xDF, 0xD8, 0x1D, 0x4D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_security_update_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_security_update_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_security_update 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_filled_24_device_security_update_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC7, 0x3C, 0x4A, 0x4C, 0x4A,
  0x4C, 0x4A, 0x4C, 0x4A, 0x4C, 0x10, 0x7E, 0x07, 0x1C, 0x20, 0x7C, 0x07, 0x2C, 0x30, 0x7A, 0x07,
  0x3C, 0x40, 0x07, 0x4C, 0x73, 0xC7, 0x38, 0x0D, 0x0F, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_security_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_security_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_security_update_warning 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_filled_24_device_security_update_warning_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC4, 0xA4, 0xC4, 0xA4, 0xC4,
  0xA4, 0xC4, 0xA4, 0xC4, 0xA4, 0xC4, 0xA4, 0xC7, 0x3C, 0x73, 0xC4, 0xA4, 0xC4, 0xA4, 0xC7, 0x38,
  0x0D, 0x0F, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_security_update_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_security_update_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_sell 24x24, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_filled_24_device_sell_data[] PROGMEM = {
  0x04, 0x0D, 0xF0, 0xE0, 0x67, 0x20, 0xDF, 0xB0, 0x77, 0x1F, 0xD0, 0x77, 0xB8, 0x17, 0x07, 0xF0,
  0x76, 0xB3, 0xF9, 0x07, 0x5B, 0x81, 0x70, 0x7F, 0xA0, 0x74, 0xFF, 0xA0, 0x73, 0xFF, 0xB0, 0x72,
  0xFF, 0xC8, 0x17, 0x0E, 0xFF, 0xC0, 0x06, 0xFF, 0xC8, 0x1E, 0x07, 0xFF, 0xB0, 0xC2, 0x07, 0xFF,
  0x90, 0xE0, 0x33, 0x07, 0xFE, 0x0E, 0x03, 0x50, 0x7F, 0xC0, 0xE0, 0x37, 0x07, 0xFA, 0x0E, 0x03,
  0x72, 0x07, 0xF0, 0xE0, 0x37, 0x40, 0x7D, 0x0E, 0x03, 0x76, 0x07, 0xB0, 0xE0, 0x37, 0x71, 0x82,
  0x6E, 0xC3, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_sell() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_sell_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_send_to_mobile 24x24, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_filled_24_device_send_to_mobile_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x30, 0xDF, 0xD0, 0xD3, 0xFF, 0x3F, 0xF3, 0xFF, 0x3A, 0x73, 0xA3,
  0xA7, 0x71, 0xA7, 0x40, 0x73, 0xA7, 0x49, 0x07, 0x2A, 0x74, 0xA0, 0x71, 0xA6, 0xF9, 0x07, 0xA6,
  0xF9, 0x07, 0xA7, 0x4A, 0x07, 0x1A, 0x74, 0x90, 0x72, 0xA7, 0x40, 0x73, 0xA7, 0x71, 0xA7, 0x3A,
  0x3F, 0xF3, 0xFF, 0x3F, 0xF3, 0x0D, 0xFD, 0x0D, 0x30, 0x40, 0xDF, 0xB0, 0xD0, 0x43,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_send_to_mobile() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_send_to_mobile_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_settings_suggest 24x24, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_filled_24_device_settings_suggest_data[] PROGMEM = {
  0x77, 0x20, 0x77, 0x75, 0x81, 0x2F, 0x27, 0x73, 0x83, 0x2B, 0xFB, 0x27, 0x71, 0x06, 0xD0, 0x66,
  0x08, 0xC0, 0x83, 0x83, 0x2B, 0xFB, 0x27, 0x0A, 0xC0, 0xA4, 0x81, 0x2F, 0x24, 0x83, 0x1E, 0xA5,
  0xDC, 0x85, 0xD5, 0xAE, 0x10, 0x75, 0x09, 0xFD, 0x09, 0x60, 0x3F, 0xF0, 0x35, 0x0C, 0xD8, 0x27,
  0x11, 0x7D, 0x0C, 0x20, 0x72, 0x0A, 0xC0, 0x74, 0x07, 0xC8, 0x3A, 0x03, 0xF3, 0x20, 0x7B, 0x01,
  0x40, 0x1B, 0x81, 0x70, 0x6B, 0x81, 0x60, 0x7B, 0x01, 0x40, 0x1B, 0x07, 0x28, 0x33, 0xF3, 0x0A,
  0xC0, 0x74, 0x07, 0xC0, 0xA2, 0x07, 0x20, 0xCD, 0x82, 0x71, 0x17, 0xD0, 0xC5, 0x03, 0xFF, 0x03,
  0x60, 0x9F, 0xD0, 0x97, 0x83, 0x1E, 0xA5, 0xDC, 0x83, 0xD5, 0xAE, 0x17, 0x40, 0xAC, 0x0A, 0x77,
  0x10, 0x8C, 0x08, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_settings_suggest() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 22, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_settings_suggest_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_settings_system_daydream 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_filled_24_device_settings_system_daydream_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x68,
  0x41, 0x9E, 0xE9, 0x16, 0xC6, 0x0C, 0xC0, 0xC6, 0xC4, 0x08, 0x0E, 0xE0, 0x45, 0xC3, 0x08, 0xFA,
  0x0B, 0x01, 0x3C, 0x30, 0xEF, 0xB0, 0xB3, 0xC3, 0x0D, 0xFB, 0x0E, 0x3C, 0x30, 0x8F, 0xB0, 0xB3,
  0xC4, 0x08, 0x0D, 0xF0, 0xB0, 0x13, 0xC7, 0x74, 0xC7, 0x74, 0xC7, 0x74, 0xA0, 0xDF, 0xFE, 0x81,
  0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_settings_system_daydream() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_settings_system_daydream_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_share_location 24x24, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_filled_24_device_share_location_data[] PROGMEM = {
  0x68, 0x14, 0xAC, 0x28, 0x1D, 0xA5, 0x73, 0x04, 0x0D, 0xB2, 0xB0, 0xD0, 0x57, 0x08, 0xA8, 0x1D,
  0x62, 0x28, 0x43, 0x7D, 0xFE, 0x15, 0x08, 0xA0, 0x67, 0x18, 0x26, 0x20, 0x13, 0x04, 0xA0, 0x47,
  0x48, 0x12, 0xD5, 0x28, 0x1D, 0xF7, 0x38, 0x41, 0xAE, 0xEA, 0x13, 0x85, 0x6F, 0xD0, 0x4F, 0xD3,
  0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x84, 0xCF, 0x59, 0xF7, 0x30, 0xAA, 0x00, 0xEA, 0x0A, 0x38, 0x47,
  0xFA, 0xCF, 0x33, 0x0E, 0xA0, 0x01, 0xA0, 0xD3, 0x84, 0x2F, 0xDE, 0xF1, 0x30, 0xEA, 0x00, 0x3A,
  0x0E, 0x68, 0x1E, 0xF1, 0x30, 0xAE, 0x0A, 0x68, 0x1C, 0xF3, 0x30, 0x2E, 0x02, 0x38, 0x42, 0xFD,
  0x9F, 0x74, 0x06, 0xC0, 0x64, 0x84, 0x6F, 0xA4, 0xFD, 0x50, 0x9A, 0x09, 0x58, 0x5C, 0xF5, 0x0D,
  0xF7, 0x50, 0x08, 0x58, 0x16, 0xFD, 0x20, 0x4A, 0x04, 0x74, 0x81, 0x2E, 0x53, 0x08, 0xA0, 0x67,
  0x18, 0x26, 0x20, 0x15, 0x08, 0xA8, 0x1D, 0x62, 0x28, 0x43, 0x7D, 0xFE, 0x17, 0x04, 0x0D, 0xB2,
  0xB0, 0xD0, 0x57, 0x38, 0x14, 0xAC, 0x28, 0x1D, 0xA5, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_share_location() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_share_location_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_shortcut 24x24, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_filled_24_device_shortcut_data[] PROGMEM = {
  0x75, 0x07, 0x77, 0x39, 0x07, 0x77, 0x2A, 0x07, 0x77, 0x1B, 0x07, 0x77, 0xC0, 0x73, 0x81, 0x4B,
  0xEF, 0xD8, 0x17, 0x08, 0xFF, 0x90, 0x70, 0x4A, 0x07, 0x01, 0x7C, 0x83, 0x70, 0xBF, 0x77, 0x2B,
  0x07, 0x28, 0x1E, 0xF1, 0x72, 0xA0, 0x73, 0xA7, 0x39, 0x07, 0x4A, 0x73, 0x07, 0x5A, 0x77, 0x2A,
  0x77, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_shortcut() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 5, 20, 18), Box(0, 0, 23, 23),
      ic_filled_24_device_shortcut_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_0_bar 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_0_bar_data[] PROGMEM = {
  0x77, 0x50, 0x77, 0x74, 0x07, 0x97, 0x73, 0x07, 0xA7, 0x72, 0x07, 0xB7, 0x71, 0x07, 0xC7, 0x70,
  0x7A, 0x05, 0xA7, 0x60, 0x7A, 0x05, 0x1A, 0x75, 0x07, 0xA0, 0x52, 0xA7, 0x40, 0x7A, 0x05, 0x3A,
  0x73, 0x07, 0xA0, 0x54, 0xA7, 0x20, 0x7A, 0x05, 0x5A, 0x71, 0x07, 0xA0, 0x56, 0xA7, 0x07, 0xA0,
  0x57, 0xA6, 0x07, 0xA0, 0x57, 0x1A, 0x50, 0x7A, 0x05, 0x72, 0xA4, 0x07, 0xA0, 0x57, 0x3A, 0x30,
  0x7A, 0x05, 0x74, 0xA2, 0x07, 0xA0, 0x57, 0x5A, 0x10, 0x7F, 0xFC, 0x07, 0xFF, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_1_bar 24x24, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_1_bar_data[] PROGMEM = {
  0x77, 0x50, 0x27, 0x74, 0x02, 0x04, 0x77, 0x38, 0x12, 0x44, 0x77, 0x20, 0x20, 0xF4, 0x77, 0x10,
  0x28, 0x00, 0x47, 0x70, 0x28, 0x01, 0x47, 0x60, 0x28, 0x02, 0x47, 0x50, 0x28, 0x03, 0x47, 0x40,
  0x28, 0x04, 0x47, 0x30, 0x28, 0x05, 0x47, 0x20, 0x88, 0x06, 0x47, 0x10, 0x89, 0x80, 0x64, 0x70,
  0x8A, 0x80, 0x64, 0x60, 0x8B, 0x80, 0x64, 0x50, 0x8C, 0x80, 0x64, 0x40, 0x8D, 0x80, 0x64, 0x30,
  0x8E, 0x80, 0x64, 0x20, 0x8F, 0x80, 0x64, 0x10, 0x8F, 0x98, 0x06, 0x40, 0x8F, 0xA8, 0x06, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_2_bar 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_2_bar_data[] PROGMEM = {
  0x77, 0x50, 0x27, 0x74, 0x02, 0x04, 0x77, 0x38, 0x12, 0x44, 0x77, 0x20, 0x20, 0xF4, 0x77, 0x10,
  0x28, 0x00, 0x47, 0x70, 0x28, 0x01, 0x47, 0x60, 0x28, 0x02, 0x47, 0x50, 0x28, 0x03, 0x47, 0x40,
  0x88, 0x04, 0x47, 0x30, 0x89, 0x80, 0x44, 0x72, 0x08, 0xA8, 0x04, 0x47, 0x10, 0x8B, 0x80, 0x44,
  0x70, 0x8C, 0x80, 0x44, 0x60, 0x8D, 0x80, 0x44, 0x50, 0x8E, 0x80, 0x44, 0x40, 0x8F, 0x80, 0x44,
  0x30, 0x8F, 0x98, 0x04, 0x42, 0x08, 0xFA, 0x80, 0x44, 0x10, 0x8F, 0xB8, 0x04, 0x40, 0x8F, 0xC8,
  0x04, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_3_bar 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_3_bar_data[] PROGMEM = {
  0x77, 0x50, 0x27, 0x74, 0x02, 0x04, 0x77, 0x38, 0x12, 0x44, 0x77, 0x20, 0x20, 0xF4, 0x77, 0x10,
  0x28, 0x00, 0x47, 0x70, 0x88, 0x01, 0x47, 0x60, 0x89, 0x80, 0x14, 0x75, 0x08, 0xA8, 0x01, 0x47,
  0x40, 0x8B, 0x80, 0x14, 0x73, 0x08, 0xC8, 0x01, 0x47, 0x20, 0x8D, 0x80, 0x14, 0x71, 0x08, 0xE8,
  0x01, 0x47, 0x08, 0xF8, 0x01, 0x46, 0x08, 0xF9, 0x80, 0x14, 0x50, 0x8F, 0xA8, 0x01, 0x44, 0x08,
  0xFB, 0x80, 0x14, 0x30, 0x8F, 0xC8, 0x01, 0x42, 0x08, 0xFD, 0x80, 0x14, 0x10, 0x8F, 0xE8, 0x01,
  0x40, 0x8F, 0xF8, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_4_bar 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_4_bar_data[] PROGMEM = {
  0x77, 0x50, 0x77, 0x74, 0x07, 0x97, 0x73, 0x07, 0xA7, 0x72, 0x07, 0xB7, 0x71, 0x07, 0xC7, 0x70,
  0x7D, 0x76, 0x07, 0xE7, 0x50, 0x7F, 0x74, 0x07, 0xF9, 0x73, 0x07, 0xFA, 0x72, 0x07, 0xFB, 0x71,
  0x07, 0xFC, 0x70, 0x7F, 0xD6, 0x07, 0xFE, 0x50, 0x7F, 0xF4, 0x07, 0xFF, 0x93, 0x07, 0xFF, 0xA2,
  0x07, 0xFF, 0xB1, 0x07, 0xFF, 0xC0, 0x7F, 0xFD,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_alt_1_bar 24x24, 4-bit Alpha,  RLE, 2 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_alt_1_bar_data[] PROGMEM = {
  0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_alt_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 14, 7, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_alt_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_alt_2_bar 24x24, 4-bit Alpha,  RLE, 11 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_alt_2_bar_data[] PROGMEM = {
  0x6B, 0x6B, 0x6B, 0x6B, 0x6E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_alt_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 9, 13, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_alt_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_alt 24x24, 4-bit Alpha,  RLE, 30 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_alt_data[] PROGMEM = {
  0x75, 0xB7, 0x5B, 0x75, 0xB7, 0x5B, 0x75, 0xB6, 0xB3, 0xB6, 0xB3, 0xB6, 0xB3, 0xB6, 0xB3, 0xB6,
  0xB3, 0xE3, 0xB3, 0xE3, 0xB3, 0xE3, 0xB3, 0xE3, 0xB3, 0xE3, 0xB3, 0xE3, 0xB3, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 19, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_connected_no_internet_0_bar 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_connected_no_internet_0_bar_data[] PROGMEM = {
  0x77, 0x50, 0x77, 0x74, 0x07, 0x97, 0x73, 0x07, 0xA7, 0x72, 0x07, 0xB7, 0x71, 0x07, 0xC7, 0x70,
  0x7A, 0x05, 0xA7, 0x60, 0x7A, 0x05, 0x77, 0x10, 0x7A, 0x05, 0x77, 0x10, 0x7A, 0x05, 0x3A, 0x73,
  0x07, 0xA0, 0x54, 0xA7, 0x20, 0x7A, 0x05, 0x5A, 0x71, 0x07, 0xA0, 0x56, 0xA7, 0x07, 0xA0, 0x57,
  0xA6, 0x07, 0xA0, 0x57, 0x1A, 0x50, 0x7A, 0x05, 0x72, 0xA4, 0x07, 0xA0, 0x57, 0x3A, 0x30, 0x7A,
  0x05, 0x77, 0x10, 0x7A, 0x05, 0x77, 0x10, 0x7F, 0xF2, 0xA0, 0x7F, 0xF9, 0x2A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_connected_no_internet_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_connected_no_internet_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_connected_no_internet_1_bar 24x24, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_connected_no_internet_1_bar_data[] PROGMEM = {
  0x77, 0x50, 0x27, 0x74, 0x02, 0x04, 0x77, 0x38, 0x12, 0x44, 0x77, 0x20, 0x20, 0xF4, 0x77, 0x10,
  0x28, 0x00, 0x47, 0x70, 0x28, 0x01, 0x47, 0x68, 0x12, 0x44, 0x77, 0x20, 0x20, 0xF4, 0x77, 0x10,
  0x28, 0x00, 0x42, 0xA7, 0x30, 0x28, 0x01, 0x42, 0xA7, 0x20, 0x88, 0x02, 0x42, 0xA7, 0x10, 0x89,
  0x80, 0x24, 0x2A, 0x70, 0x8A, 0x80, 0x24, 0x2A, 0x60, 0x8B, 0x80, 0x24, 0x2A, 0x50, 0x8C, 0x80,
  0x24, 0x2A, 0x40, 0x8D, 0x80, 0x24, 0x2A, 0x30, 0x8E, 0x80, 0x24, 0x60, 0x8F, 0x80, 0x24, 0x50,
  0x8F, 0x98, 0x02, 0x42, 0xA0, 0x8F, 0xA8, 0x02, 0x42, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_connected_no_internet_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_connected_no_internet_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_connected_no_internet_2_bar 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_connected_no_internet_2_bar_data[] PROGMEM = {
  0x77, 0x50, 0x27, 0x74, 0x02, 0x04, 0x77, 0x38, 0x12, 0x44, 0x77, 0x20, 0x20, 0xF4, 0x77, 0x10,
  0x28, 0x00, 0x47, 0x70, 0x28, 0x01, 0x47, 0x68, 0x12, 0x44, 0x77, 0x20, 0x20, 0xF4, 0x77, 0x10,
  0x88, 0x00, 0x42, 0xA7, 0x30, 0x89, 0x80, 0x04, 0x2A, 0x72, 0x08, 0xA8, 0x00, 0x42, 0xA7, 0x10,
  0x8B, 0x80, 0x04, 0x2A, 0x70, 0x8C, 0x80, 0x04, 0x2A, 0x60, 0x8D, 0x80, 0x04, 0x2A, 0x50, 0x8E,
  0x80, 0x04, 0x2A, 0x40, 0x8F, 0x80, 0x04, 0x2A, 0x30, 0x8F, 0x98, 0x00, 0x46, 0x08, 0xFA, 0x80,
  0x04, 0x50, 0x8F, 0xB8, 0x00, 0x42, 0xA0, 0x8F, 0xC8, 0x00, 0x42, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_connected_no_internet_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_connected_no_internet_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_connected_no_internet_3_bar 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_connected_no_internet_3_bar_data[] PROGMEM = {
  0x77, 0x50, 0x27, 0x74, 0x02, 0x04, 0x77, 0x38, 0x12, 0x44, 0x77, 0x20, 0x20, 0xF4, 0x77, 0x10,
  0x28, 0x00, 0x47, 0x70, 0x88, 0x01, 0x47, 0x68, 0x18, 0xF4, 0x77, 0x20, 0x8A, 0x04, 0x77, 0x10,
  0x8B, 0x04, 0x2A, 0x73, 0x08, 0xC0, 0x42, 0xA7, 0x20, 0x8D, 0x04, 0x2A, 0x71, 0x08, 0xE0, 0x42,
  0xA7, 0x08, 0xF0, 0x42, 0xA6, 0x08, 0xF9, 0x04, 0x2A, 0x50, 0x8F, 0xA0, 0x42, 0xA4, 0x08, 0xFB,
  0x04, 0x2A, 0x30, 0x8F, 0xC0, 0x46, 0x08, 0xFD, 0x04, 0x50, 0x8F, 0xE0, 0x42, 0xA0, 0x8F, 0xF0,
  0x42, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_connected_no_internet_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_connected_no_internet_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_connected_no_internet_4_bar 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_connected_no_internet_4_bar_data[] PROGMEM = {
  0x77, 0x50, 0x77, 0x74, 0x07, 0x97, 0x73, 0x07, 0xA7, 0x72, 0x07, 0xB7, 0x71, 0x07, 0xC7, 0x70,
  0x7D, 0x76, 0x07, 0xA7, 0x72, 0x07, 0xB7, 0x71, 0x07, 0xC2, 0xA7, 0x30, 0x7D, 0x2A, 0x72, 0x07,
  0xE2, 0xA7, 0x10, 0x7F, 0x2A, 0x70, 0x7F, 0x92, 0xA6, 0x07, 0xFA, 0x2A, 0x50, 0x7F, 0xB2, 0xA4,
  0x07, 0xFC, 0x2A, 0x30, 0x7F, 0xD6, 0x07, 0xFE, 0x50, 0x7F, 0xF2, 0xA0, 0x7F, 0xF9, 0x2A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_connected_no_internet_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_connected_no_internet_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_nodata 24x24, 4-bit Alpha,  RLE, 86 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_nodata_data[] PROGMEM = {
  0x77, 0x50, 0x77, 0x74, 0x07, 0x97, 0x73, 0x07, 0xA7, 0x72, 0x07, 0xB7, 0x71, 0x07, 0xC7, 0x70,
  0x7D, 0x76, 0x07, 0xE7, 0x50, 0x7F, 0x74, 0x07, 0xF9, 0x73, 0x07, 0xFA, 0x72, 0x07, 0xFB, 0x71,
  0x07, 0xA7, 0x72, 0x07, 0xB1, 0x85, 0x2B, 0x10, 0x1B, 0x27, 0x07, 0xC1, 0x85, 0xBF, 0xC2, 0xCF,
  0xB6, 0x07, 0xD1, 0x01, 0x0C, 0xB0, 0xC0, 0x15, 0x07, 0xE2, 0x02, 0xB0, 0x25, 0x07, 0xF1, 0x01,
  0x0C, 0xB0, 0xC0, 0x13, 0x07, 0xF9, 0x18, 0x5B, 0xFC, 0x2C, 0xFB, 0x20, 0x7F, 0xA1, 0x87, 0x2B,
  0x10, 0x1B, 0x20, 0x7F, 0xB7, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_nodata() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_nodata_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_no_sim 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_no_sim_data[] PROGMEM = {
  0x70, 0x7F, 0x0D, 0x04, 0x28, 0x11, 0xC4, 0x30, 0x7F, 0xA0, 0xD2, 0x04, 0xA8, 0x24, 0x01, 0xEF,
  0xB3, 0x04, 0xA8, 0x24, 0x03, 0xEF, 0xA4, 0x04, 0xA8, 0x24, 0x03, 0xEF, 0x95, 0xB8, 0x24, 0x03,
  0xEF, 0x5C, 0x82, 0x40, 0x3E, 0xE5, 0xD8, 0x24, 0x03, 0xED, 0x5E, 0x82, 0x40, 0x3E, 0xC5, 0xF8,
  0x24, 0x03, 0xEB, 0x5F, 0x98, 0x24, 0x03, 0xEA, 0x5F, 0xA8, 0x24, 0x03, 0xE9, 0x5F, 0xB8, 0x24,
  0x03, 0xE5, 0xFC, 0x81, 0x40, 0x35, 0xFD, 0x04, 0x6F, 0xE0, 0x45, 0x0D, 0xFE, 0x04, 0x40, 0x40,
  0xDF, 0xB0, 0xDA, 0x04, 0x77, 0x28, 0x14, 0xFC, 0x77, 0x30, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_null 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_null_data[] PROGMEM = {
  0x77, 0x50, 0x77, 0x74, 0x07, 0x97, 0x73, 0x07, 0xA7, 0x72, 0x07, 0xB7, 0x71, 0x07, 0xC7, 0x70,
  0x7A, 0x05, 0xA7, 0x60, 0x7A, 0x05, 0x1A, 0x75, 0x07, 0xA0, 0x52, 0xA7, 0x40, 0x7A, 0x05, 0x3A,
  0x73, 0x07, 0xA0, 0x54, 0xA7, 0x20, 0x7A, 0x05, 0x5A, 0x71, 0x07, 0xA0, 0x56, 0xA7, 0x07, 0xA0,
  0x57, 0xA6, 0x07, 0xA0, 0x57, 0x1A, 0x50, 0x7A, 0x05, 0x72, 0xA4, 0x07, 0xA0, 0x57, 0x3A, 0x30,
  0x7A, 0x05, 0x74, 0xA2, 0x07, 0xA0, 0x57, 0x5A, 0x10, 0x7F, 0xFC, 0x07, 0xFF, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_null() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_null_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_cellular_off 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_filled_24_device_signal_cellular_off_data[] PROGMEM = {
  0x77, 0x50, 0x77, 0x75, 0x07, 0x97, 0x74, 0x07, 0xA4, 0x03, 0x75, 0x07, 0xB3, 0x81, 0x3E, 0xB7,
  0x30, 0x7C, 0x48, 0x1B, 0xFB, 0x71, 0x07, 0xD5, 0x81, 0xBF, 0xB6, 0x07, 0xE6, 0x81, 0xBF, 0xB4,
  0x07, 0xF7, 0x81, 0xBF, 0xB2, 0x05, 0xF9, 0x71, 0x81, 0xBF, 0xB2, 0x0A, 0xF7, 0x28, 0x1B, 0xFB,
  0x20, 0xAE, 0x72, 0x08, 0xA0, 0xB2, 0x0A, 0xD7, 0x10, 0x7C, 0x0B, 0x20, 0xAC, 0x70, 0x7E, 0x0B,
  0x20, 0xAB, 0x60, 0x7F, 0x90, 0xB2, 0x0A, 0xA5, 0x07, 0xFB, 0x0B, 0x20, 0xA9, 0x40, 0x7F, 0xD0,
  0xB2, 0x0A, 0x30, 0x7F, 0xF0, 0xB4, 0x07, 0xFF, 0xA0, 0xB2, 0x07, 0xFF, 0xC0, 0xB7, 0x75, 0x81,
  0xBF, 0xA7, 0x75, 0x0A, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_cellular_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_cellular_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_0_bar 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_0_bar_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9B, 0x82, 0xB7, 0x31, 0x28, 0x21, 0x37, 0xBB, 0x09, 0x01, 0x38, 0x44, 0xEF, 0xE8, 0x17, 0x38,
  0x61, 0x8E, 0xFE, 0x40, 0x6A, 0x0A, 0x01, 0x77, 0x01, 0x0A, 0xA0, 0x60, 0x7A, 0x05, 0x77, 0x20,
  0x5A, 0x81, 0x70, 0x7A, 0x05, 0x77, 0x05, 0xA0, 0x73, 0x07, 0xA0, 0x57, 0x50, 0x5A, 0x07, 0x50,
  0x7A, 0x05, 0x73, 0x05, 0xA0, 0x77, 0x07, 0xA0, 0x57, 0x10, 0x5A, 0x07, 0x72, 0x07, 0xA0, 0x56,
  0x05, 0xA0, 0x77, 0x40, 0x7A, 0x05, 0x40, 0x5A, 0x07, 0x76, 0x07, 0xA0, 0x52, 0x05, 0xA0, 0x77,
  0x71, 0x07, 0xA0, 0x05, 0xA0, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x00,
  0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_0_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_0_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_1_bar_lock 24x24, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_1_bar_lock_data[] PROGMEM = {
  0x78, 0x90, 0x23, 0x34, 0x44, 0x43, 0x32, 0x74, 0x01, 0x03, 0x80, 0x90, 0x40, 0x30, 0x16, 0x01,
  0x80, 0x96, 0x40, 0x13, 0x03, 0x80, 0xA0, 0x48, 0x13, 0x01, 0x80, 0xA2, 0x42, 0x01, 0x80, 0xA0,
  0x40, 0x13, 0x02, 0x80, 0x94, 0x48, 0x12, 0x21, 0x50, 0x38, 0x09, 0x14, 0x02, 0x73, 0x80, 0x90,
  0x40, 0x27, 0x40, 0x18, 0x07, 0x42, 0x83, 0x2C, 0xFC, 0x26, 0x84, 0x14, 0x47, 0xBD, 0xA8, 0x1D,
  0xA4, 0x28, 0x3C, 0x70, 0x7B, 0x70, 0x30, 0xCF, 0x09, 0x29, 0x39, 0x71, 0x0D, 0xF0, 0x82, 0x93,
  0x97, 0x10, 0x20, 0xEE, 0x81, 0x80, 0xBD, 0x0B, 0x71, 0x04, 0xE0, 0x41, 0xF7, 0x20, 0x7C, 0x07,
  0x2F, 0x73, 0x0A, 0xA0, 0xA3, 0xF7, 0x40, 0x0C, 0x4F, 0x74, 0x00, 0x14, 0x0B, 0xD0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_1_bar_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_1_bar_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_1_bar 24x24, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_1_bar_data[] PROGMEM = {
  0x78, 0x90, 0x23, 0x34, 0x44, 0x43, 0x32, 0x74, 0x02, 0x03, 0x80, 0x90, 0x40, 0x30, 0x16, 0x02,
  0x80, 0x96, 0x40, 0x13, 0x03, 0x80, 0xA0, 0x48, 0x13, 0x01, 0x80, 0xA2, 0x48, 0x11, 0x02, 0x80,
  0xA0, 0x40, 0x13, 0x02, 0x80, 0x96, 0x40, 0x25, 0x03, 0x80, 0x94, 0x40, 0x37, 0x80, 0x94, 0x47,
  0x10, 0x18, 0x09, 0x24, 0x01, 0x72, 0x84, 0x14, 0x47, 0xBD, 0xA8, 0x4D, 0xB7, 0x44, 0x17, 0x40,
  0x30, 0xCF, 0x90, 0xC0, 0x37, 0x60, 0xDF, 0x90, 0xC7, 0x70, 0x20, 0xEE, 0x0E, 0x01, 0x77, 0x10,
  0x4E, 0x04, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x50, 0xAA, 0x0A, 0x77, 0x70, 0x0C, 0x77, 0x71, 0x00,
  0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_2_bar_lock 24x24, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_2_bar_lock_data[] PROGMEM = {
  0x78, 0x90, 0x23, 0x34, 0x44, 0x43, 0x32, 0x74, 0x01, 0x03, 0x80, 0x90, 0x40, 0x30, 0x16, 0x01,
  0x80, 0x96, 0x40, 0x13, 0x03, 0x80, 0xA0, 0x48, 0x13, 0x01, 0x80, 0xA2, 0x42, 0x01, 0x80, 0xA0,
  0x40, 0x13, 0x02, 0x80, 0x94, 0x48, 0x12, 0x21, 0x58, 0x63, 0x44, 0x45, 0x9C, 0xEA, 0x83, 0xEC,
  0x95, 0x27, 0x38, 0x14, 0x5B, 0xFA, 0x09, 0x74, 0x01, 0x0E, 0xFA, 0x0E, 0x28, 0x32, 0xCF, 0xC2,
  0x60, 0x7F, 0xA0, 0xA2, 0x83, 0xC7, 0x07, 0xB7, 0x0A, 0xF9, 0x08, 0x29, 0x39, 0x71, 0x0C, 0xF0,
  0x82, 0x93, 0x97, 0x10, 0x10, 0xEE, 0x81, 0x80, 0xBD, 0x0B, 0x71, 0x04, 0xE0, 0x41, 0xF7, 0x20,
  0x7C, 0x07, 0x2F, 0x73, 0x0A, 0xA0, 0xA3, 0xF7, 0x40, 0x0C, 0x4F, 0x74, 0x00, 0x14, 0x0B, 0xD0,
  0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_2_bar_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_2_bar_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_2_bar 24x24, 4-bit Alpha,  RLE, 101 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_2_bar_data[] PROGMEM = {
  0x78, 0x90, 0x23, 0x34, 0x44, 0x43, 0x32, 0x74, 0x02, 0x03, 0x80, 0x90, 0x40, 0x30, 0x16, 0x02,
  0x80, 0x96, 0x40, 0x13, 0x03, 0x80, 0xA0, 0x48, 0x13, 0x01, 0x80, 0xA2, 0x48, 0x11, 0x02, 0x80,
  0xA0, 0x40, 0x13, 0x02, 0x80, 0x96, 0x40, 0x25, 0x86, 0x34, 0x44, 0x59, 0xCE, 0xA8, 0x6E, 0xC9,
  0x54, 0x44, 0x37, 0x81, 0x45, 0xBF, 0xB8, 0x1B, 0x54, 0x71, 0x01, 0x0E, 0xFD, 0x0E, 0x01, 0x72,
  0x07, 0xFD, 0x07, 0x74, 0x0A, 0xFB, 0x0A, 0x76, 0x0D, 0xF9, 0x0C, 0x77, 0x02, 0x0E, 0xE0, 0xE0,
  0x17, 0x71, 0x04, 0xE0, 0x47, 0x73, 0x07, 0xC0, 0x77, 0x75, 0x0A, 0xA0, 0xA7, 0x77, 0x00, 0xC7,
  0x77, 0x10, 0x20, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_3_bar_lock 24x24, 4-bit Alpha,  RLE, 117 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_3_bar_lock_data[] PROGMEM = {
  0x78, 0x90, 0x23, 0x34, 0x44, 0x43, 0x32, 0x74, 0x01, 0x03, 0x80, 0x90, 0x40, 0x30, 0x16, 0x01,
  0x80, 0x96, 0x40, 0x13, 0x03, 0x80, 0xA0, 0x48, 0x13, 0x01, 0x80, 0xA2, 0x42, 0x01, 0x80, 0x14,
  0x82, 0x7A, 0xCE, 0xA8, 0x2E, 0xCA, 0x68, 0x01, 0x40, 0x13, 0x83, 0x24, 0x48, 0xDF, 0xB8, 0x3D,
  0x73, 0x22, 0x50, 0x50, 0xDF, 0xD0, 0xA0, 0x17, 0x10, 0x10, 0xEF, 0xC0, 0xA7, 0x40, 0x4F, 0xB0,
  0xE2, 0x83, 0x2C, 0xFC, 0x26, 0x07, 0xFA, 0x0A, 0x28, 0x3C, 0x70, 0x7B, 0x70, 0xAF, 0x90, 0x92,
  0x93, 0x97, 0x10, 0xCF, 0x08, 0x29, 0x39, 0x71, 0x01, 0x0E, 0xE8, 0x18, 0x0B, 0xD0, 0xB7, 0x10,
  0x4E, 0x04, 0x1F, 0x72, 0x07, 0xC0, 0x72, 0xF7, 0x30, 0xAA, 0x0A, 0x3F, 0x74, 0x00, 0xC4, 0xF7,
  0x40, 0x01, 0x40, 0xBD, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_3_bar_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_3_bar_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_3_bar 24x24, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_3_bar_data[] PROGMEM = {
  0x78, 0x90, 0x23, 0x34, 0x44, 0x43, 0x32, 0x74, 0x02, 0x03, 0x80, 0x90, 0x40, 0x30, 0x16, 0x02,
  0x80, 0x96, 0x40, 0x13, 0x03, 0x80, 0xA0, 0x48, 0x13, 0x01, 0x80, 0xA2, 0x48, 0x11, 0x02, 0x80,
  0x14, 0x82, 0x7A, 0xCE, 0xA8, 0x2E, 0xCA, 0x68, 0x01, 0x40, 0x13, 0x83, 0x24, 0x48, 0xDF, 0xB8,
  0x3D, 0x84, 0x42, 0x50, 0x50, 0xCF, 0xF0, 0xC0, 0x46, 0x02, 0x0E, 0xFF, 0x0E, 0x02, 0x70, 0x4F,
  0xF0, 0x47, 0x20, 0x7F, 0xD0, 0x77, 0x40, 0xAF, 0xB0, 0xA7, 0x60, 0xDF, 0x90, 0xC7, 0x70, 0x20,
  0xEE, 0x0E, 0x01, 0x77, 0x10, 0x4E, 0x04, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x50, 0xAA, 0x0A, 0x77,
  0x70, 0x0C, 0x77, 0x71, 0x02, 0x01, 0x74,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_3_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_3_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_4_bar_lock 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_4_bar_lock_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9F, 0xFA, 0x09, 0x01, 0x30, 0x40, 0xEF, 0xFC, 0x82, 0xE4, 0x06, 0xFF, 0xF9, 0x06, 0x07, 0xFF,
  0xF9, 0x81, 0x70, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xE8, 0x1D, 0x51, 0x71, 0x07, 0xFC, 0x0D, 0x01,
  0x74, 0x07, 0xFB, 0x06, 0x28, 0x24, 0xDD, 0x47, 0x07, 0xFA, 0x02, 0x28, 0x2D, 0x33, 0xD7, 0x10,
  0x7F, 0x93, 0x92, 0x97, 0x20, 0x7F, 0x20, 0xBC, 0x0B, 0x72, 0x07, 0xE2, 0xE7, 0x30, 0x7C, 0x07,
  0x2E, 0x74, 0x07, 0xA0, 0x73, 0xE7, 0x50, 0x07, 0x40, 0xBC, 0x0B, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_4_bar_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_4_bar_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_4_bar 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_4_bar_data[] PROGMEM = {
  0x68, 0x32, 0x69, 0xCD, 0xA8, 0x3D, 0xC9, 0x62, 0x73, 0x06, 0x0C, 0xFD, 0x0C, 0x06, 0x60, 0x60,
  0xEF, 0xFA, 0x0E, 0x06, 0x20, 0x20, 0xCF, 0xFE, 0x81, 0xC2, 0x3F, 0xFF, 0x98, 0x13, 0x06, 0xFF,
  0xE0, 0x63, 0x09, 0xFF, 0xC0, 0x95, 0x0C, 0xFF, 0xA0, 0xC6, 0x01, 0x0E, 0xFF, 0x0E, 0x01, 0x70,
  0x3F, 0xF0, 0x37, 0x20, 0x6F, 0xD0, 0x67, 0x40, 0x9F, 0xB0, 0x97, 0x60, 0xCF, 0x90, 0xC7, 0x70,
  0x10, 0xEE, 0x0E, 0x01, 0x77, 0x10, 0x3E, 0x03, 0x77, 0x30, 0x6C, 0x06, 0x77, 0x50, 0x9A, 0x09,
  0x77, 0x70, 0x0C, 0x77, 0x71, 0x00, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_bad 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_bad_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9F, 0xFA, 0x09, 0x01, 0x30, 0x40, 0xEF, 0xFC, 0x82, 0xE4, 0x06, 0xFF, 0xF9, 0x06, 0x07, 0xFF,
  0xF9, 0x81, 0x70, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFC, 0x07, 0x50, 0x7F, 0x97, 0x72, 0x07, 0xF7,
  0x73, 0x07, 0xE2, 0x85, 0x2B, 0x10, 0x1B, 0x27, 0x20, 0x7D, 0x28, 0x5B, 0xFC, 0x2C, 0xFB, 0x73,
  0x07, 0xC2, 0x01, 0x0C, 0xB0, 0xC0, 0x17, 0x40, 0x7B, 0x30, 0x2B, 0x02, 0x76, 0x07, 0xA2, 0x01,
  0x0C, 0xB0, 0xC0, 0x17, 0x60, 0x79, 0x28, 0x5B, 0xFC, 0x2C, 0xFB, 0x77, 0x07, 0x28, 0x52, 0xB1,
  0x01, 0xB2, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_bad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_bad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_connected_no_internet_4 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_connected_no_internet_4_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9F, 0xFA, 0x09, 0x01, 0x30, 0x40, 0xEF, 0xFC, 0x82, 0xE4, 0x06, 0xFF, 0xF9, 0x06, 0x07, 0xFF,
  0xF9, 0x81, 0x70, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFC, 0x07, 0x50, 0x7F, 0x97, 0x72, 0x07, 0xF7,
  0x73, 0x07, 0xE2, 0x85, 0x2B, 0x10, 0x1B, 0x27, 0x20, 0x7D, 0x28, 0x5B, 0xFC, 0x2C, 0xFB, 0x73,
  0x07, 0xC2, 0x01, 0x0C, 0xB0, 0xC0, 0x17, 0x40, 0x7B, 0x30, 0x2B, 0x02, 0x76, 0x07, 0xA2, 0x01,
  0x0C, 0xB0, 0xC0, 0x17, 0x60, 0x79, 0x28, 0x5B, 0xFC, 0x2C, 0xFB, 0x77, 0x07, 0x28, 0x52, 0xB1,
  0x01, 0xB2, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_connected_no_internet_4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_connected_no_internet_4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_off 24x24, 4-bit Alpha,  RLE, 135 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_off_data[] PROGMEM = {
  0x30, 0x47, 0x77, 0x18, 0x1A, 0xF5, 0x77, 0x78, 0x24, 0xEF, 0x52, 0x81, 0x8C, 0xDA, 0x83, 0xDC,
  0x96, 0x27, 0x20, 0x4A, 0x82, 0x50, 0x3E, 0xF9, 0x0C, 0x06, 0x60, 0x60, 0xEB, 0x82, 0x50, 0x3E,
  0xFA, 0x0E, 0x06, 0x20, 0x20, 0xCE, 0x82, 0x50, 0x3E, 0xFB, 0x81, 0xC2, 0x3F, 0x98, 0x25, 0x03,
  0xEF, 0xB8, 0x13, 0x06, 0xF9, 0x82, 0x50, 0x3E, 0xF9, 0x06, 0x30, 0x9F, 0x98, 0x25, 0x03, 0xEE,
  0x09, 0x50, 0xCF, 0x98, 0x25, 0x03, 0xEC, 0x0C, 0x60, 0x10, 0xEF, 0x98, 0x25, 0x03, 0xEA, 0x0E,
  0x01, 0x70, 0x3F, 0xA8, 0x45, 0x03, 0xEF, 0x37, 0x20, 0x6F, 0xA8, 0x25, 0x03, 0x57, 0x40, 0x9F,
  0xA0, 0x57, 0x70, 0xCF, 0xA0, 0x57, 0x60, 0x10, 0xEE, 0x82, 0xEE, 0xF5, 0x76, 0x03, 0xE8, 0x33,
  0x3E, 0xF5, 0x76, 0x06, 0xC0, 0x62, 0x82, 0x3E, 0xF3, 0x76, 0x09, 0xA0, 0x94, 0x03, 0x09, 0x77,
  0x10, 0x0C, 0x77, 0x71, 0x00, 0x17, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 23, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_statusbar_4_bar 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_statusbar_4_bar_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9F, 0xFA, 0x09, 0x01, 0x30, 0x40, 0xEF, 0xFC, 0x82, 0xE4, 0x06, 0xFF, 0xF9, 0x06, 0x07, 0xFF,
  0xF9, 0x81, 0x70, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xFC, 0x07, 0x50, 0x7F, 0xFA, 0x07, 0x70, 0x7F,
  0xF0, 0x77, 0x20, 0x7F, 0xD0, 0x77, 0x40, 0x7F, 0xB0, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x71, 0x07,
  0xE0, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x00, 0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_statusbar_4_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_statusbar_4_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_statusbar_connected_no_internet_4 24x24, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_statusbar_connected_no_internet_4_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x73, 0x81, 0x2A, 0xEF, 0xC0, 0xA0, 0x25, 0x01, 0x09,
  0xFF, 0xA0, 0xA0, 0x12, 0x04, 0x0E, 0xFF, 0xC8, 0x1E, 0x46, 0xFF, 0xA6, 0x07, 0xFF, 0xA7, 0x07,
  0xFF, 0x92, 0xA4, 0x07, 0xFF, 0x2A, 0x50, 0x7F, 0xE2, 0xA6, 0x07, 0xFD, 0x2A, 0x70, 0x7F, 0xC2,
  0xA7, 0x10, 0x7F, 0xB2, 0xA7, 0x20, 0x7F, 0x90, 0x77, 0x70, 0x7E, 0x07, 0x77, 0x20, 0x7C, 0x07,
  0x4A, 0x75, 0x07, 0xA0, 0x75, 0xA7, 0x60, 0x07, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_statusbar_connected_no_internet_4() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_statusbar_connected_no_internet_4_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_signal_wifi_statusbar_null 24x24, 4-bit Alpha,  RLE, 114 bytes.
static const unsigned char ic_filled_24_device_signal_wifi_statusbar_null_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9B, 0x82, 0xB7, 0x31, 0x28, 0x21, 0x37, 0xBB, 0x09, 0x01, 0x38, 0x44, 0xEF, 0xE8, 0x17, 0x38,
  0x61, 0x8E, 0xFE, 0x40, 0x6A, 0x0A, 0x01, 0x77, 0x01, 0x0A, 0xA0, 0x60, 0x7A, 0x05, 0x77, 0x20,
  0x5A, 0x81, 0x70, 0x7A, 0x05, 0x77, 0x05, 0xA0, 0x73, 0x07, 0xA0, 0x57, 0x50, 0x5A, 0x07, 0x50,
  0x7A, 0x05, 0x73, 0x05, 0xA0, 0x77, 0x07, 0xA0, 0x57, 0x10, 0x5A, 0x07, 0x72, 0x07, 0xA0, 0x56,
  0x05, 0xA0, 0x77, 0x40, 0x7A, 0x05, 0x40, 0x5A, 0x07, 0x76, 0x07, 0xA0, 0x52, 0x05, 0xA0, 0x77,
  0x71, 0x07, 0xA0, 0x05, 0xA0, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x75, 0x07, 0xA0, 0x77, 0x77, 0x00,
  0x77, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_signal_wifi_statusbar_null() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_signal_wifi_statusbar_null_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_sim_card_download 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_filled_24_device_sim_card_download_data[] PROGMEM = {
  0x50, 0x7F, 0x90, 0xD0, 0x44, 0x07, 0xFB, 0x0D, 0x30, 0x7F, 0xD2, 0x07, 0xFE, 0x10, 0x7F, 0xF0,
  0x78, 0x0C, 0x2F, 0x2F, 0xF2, 0xFF, 0x2F, 0xF2, 0xFC, 0x07, 0x60, 0x7F, 0xA0, 0x74, 0x07, 0xFC,
  0x07, 0x20, 0x7F, 0xE0, 0x07, 0x80, 0xE3, 0xF0, 0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_sim_card_download() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_sim_card_download_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_splitscreen 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_filled_24_device_splitscreen_data[] PROGMEM = {
  0x04, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xF0, 0xDA, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xA0,
  0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04, 0x77, 0x77, 0x40, 0x40, 0xDF, 0xD8, 0x1D, 0x4D, 0xFF,
  0x0D, 0xA7, 0x5C, 0x75, 0xC7, 0x5C, 0x75, 0xC7, 0x5A, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xD0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_splitscreen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_splitscreen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_sports_score 24x24, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_filled_24_device_sports_score_data[] PROGMEM = {
  0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xE2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2,
  0xA2, 0xA2, 0xE2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xC7, 0x5A,
  0x75, 0xA7, 0x5A, 0x75, 0xA7, 0x5A, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_sports_score() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 18, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_sports_score_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_ssid_chart 24x24, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_filled_24_device_ssid_chart_data[] PROGMEM = {
  0x77, 0x30, 0x97, 0x71, 0x03, 0x0D, 0x93, 0x81, 0x1B, 0x57, 0x10, 0x7A, 0x0C, 0x20, 0x40, 0xEA,
  0x05, 0x50, 0x10, 0xBA, 0x08, 0x20, 0x8A, 0x0C, 0xA0, 0x53, 0x83, 0x4E, 0xFE, 0x42, 0x0C, 0xA8,
  0x16, 0x07, 0xA8, 0x15, 0x08, 0xA0, 0xB0, 0x13, 0x90, 0xD0, 0x33, 0x07, 0xA0, 0xDA, 0x07, 0x50,
  0x96, 0x07, 0xA0, 0xD0, 0x37, 0x70, 0x70, 0x97, 0x30, 0x30, 0x27, 0x71, 0x82, 0x8F, 0xE3, 0x76,
  0x0C, 0xB0, 0xE0, 0x37, 0x59, 0x84, 0xD3, 0xAF, 0xE3, 0x50, 0x50, 0xEC, 0x09, 0x38, 0x29, 0xFE,
  0x43, 0x08, 0xE5, 0x09, 0xA8, 0x14, 0x1B, 0xA0, 0x67, 0x30, 0x9A, 0x82, 0xDF, 0xD3, 0x75, 0x08,
  0xA0, 0xB0, 0x17, 0x70, 0x80, 0x97, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_ssid_chart() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_ssid_chart_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_storage 24x24, 4-bit Alpha,  RLE, 26 bytes.
static const unsigned char ic_filled_24_device_storage_data[] PROGMEM = {
  0xFF, 0xF9, 0x2F, 0xFC, 0x28, 0x0C, 0x0F, 0x80, 0xC4, 0x0F, 0xFF, 0x92, 0xFF, 0xC2, 0x80, 0xC0,
  0xF8, 0x0C, 0x40, 0xFF, 0xF9, 0x2F, 0xFC, 0x28, 0x0C, 0x0F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_storage() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_storage_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_storm 24x24, 4-bit Alpha,  RLE, 166 bytes.
static const unsigned char ic_filled_24_device_storm_data[] PROGMEM = {
  0x18, 0x15, 0xFB, 0x77, 0x38, 0x19, 0xF7, 0x77, 0x38, 0x1D, 0xF2, 0x28, 0x12, 0x8C, 0xA8, 0x1C,
  0x82, 0x7A, 0x20, 0x9F, 0x90, 0x85, 0x83, 0x1F, 0xE0, 0xBA, 0x09, 0x04, 0x20, 0x30, 0x8A, 0x0B,
  0x48, 0x51, 0xFD, 0x9F, 0xD2, 0x68, 0x22, 0xDF, 0x83, 0x81, 0x1F, 0xEA, 0x89, 0x02, 0x01, 0xAD,
  0xDA, 0x10, 0x2A, 0x02, 0x3B, 0x82, 0x80, 0x1E, 0xC8, 0x4E, 0x10, 0x8F, 0xA3, 0x0D, 0xA8, 0x92,
  0x30, 0xAF, 0xB1, 0x1B, 0xFA, 0x04, 0xA0, 0x12, 0x09, 0xA8, 0x31, 0x0D, 0xF1, 0x28, 0x31, 0xFD,
  0x01, 0xA0, 0x62, 0x06, 0xA8, 0x31, 0x0D, 0xF1, 0x28, 0x31, 0xFD, 0x01, 0xA0, 0x92, 0x01, 0xA8,
  0x92, 0x40, 0xAF, 0xB1, 0x1B, 0xFA, 0x03, 0xA0, 0xC3, 0x84, 0xAF, 0x80, 0x1E, 0xC8, 0x2E, 0x10,
  0x8B, 0x30, 0x2A, 0x89, 0x02, 0x01, 0xAD, 0xDA, 0x10, 0x2A, 0x81, 0xEF, 0x13, 0x82, 0x8F, 0xD2,
  0x68, 0x52, 0xDF, 0x9D, 0xF1, 0x40, 0xBA, 0x08, 0x03, 0x20, 0x40, 0x9A, 0x83, 0xB0, 0xEF, 0x15,
  0x08, 0xF9, 0x09, 0x2A, 0x78, 0x12, 0x8C, 0xA8, 0x1C, 0x82, 0x28, 0x12, 0xFC, 0x77, 0x38, 0x16,
  0xF9, 0x77, 0x38, 0x1B, 0xF5, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_storm() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_storm_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_summarize 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_filled_24_device_summarize_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x07, 0x50, 0xDF, 0xB8, 0x1D, 0xF7, 0x4F, 0xC8, 0x21, 0xDF, 0x73, 0xFC, 0x18,
  0x21, 0xDF, 0x72, 0xC0, 0x03, 0xD2, 0x82, 0x1D, 0xF7, 0x1C, 0x00, 0x3D, 0x38, 0x21, 0xDF, 0x7F,
  0xC4, 0x01, 0x0D, 0xFF, 0xFA, 0x00, 0x3F, 0xFA, 0x00, 0x38, 0x0E, 0x0F, 0x00, 0x3F, 0xFA, 0x00,
  0x38, 0x0D, 0x4F, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_summarize() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_summarize_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_system_security_update_good 24x24, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_filled_24_device_system_security_update_good_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC7, 0x3C, 0x70, 0x22, 0xC6,
  0x81, 0x4F, 0x61, 0xC5, 0x04, 0xA0, 0x81, 0xC1, 0x82, 0x2E, 0x54, 0xA0, 0x82, 0xC1, 0x06, 0xC0,
  0x83, 0xC2, 0x06, 0xA0, 0x84, 0xC3, 0x06, 0x08, 0x5C, 0x73, 0xC7, 0x3C, 0x73, 0x80, 0xD0, 0xF0,
  0xDF, 0xD8, 0x1D, 0x4D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_system_security_update_good() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_system_security_update_good_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_system_security_update 24x24, 4-bit Alpha,  RLE, 49 bytes.
static const unsigned char ic_filled_24_device_system_security_update_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC7, 0x3C, 0x4A, 0x4C, 0x4A,
  0x4C, 0x4A, 0x4C, 0x4A, 0x4C, 0x10, 0x7E, 0x07, 0x1C, 0x20, 0x7C, 0x07, 0x2C, 0x30, 0x7A, 0x07,
  0x3C, 0x40, 0x07, 0x4C, 0x73, 0xC7, 0x38, 0x0D, 0x0F, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_system_security_update() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_system_security_update_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_system_security_update_warning 24x24, 4-bit Alpha,  RLE, 42 bytes.
static const unsigned char ic_filled_24_device_system_security_update_warning_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xD8, 0x0D, 0x0F, 0x73, 0xC4, 0xA4, 0xC4, 0xA4, 0xC4,
  0xA4, 0xC4, 0xA4, 0xC4, 0xA4, 0xC4, 0xA4, 0xC7, 0x3C, 0x73, 0xC4, 0xA4, 0xC4, 0xA4, 0xC7, 0x38,
  0x0D, 0x0F, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_system_security_update_warning() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_system_security_update_warning_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_task 24x24, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_filled_24_device_task_data[] PROGMEM = {
  0x04, 0x0D, 0xF9, 0x07, 0x50, 0xDF, 0x98, 0x1D, 0xF7, 0x4F, 0xA8, 0x21, 0xDF, 0x73, 0xFA, 0x18,
  0x21, 0xDF, 0x72, 0xFA, 0x28, 0x21, 0xDF, 0x71, 0xFA, 0x38, 0x21, 0xDF, 0x7F, 0xA4, 0x01, 0x0D,
  0x80, 0xC7, 0xF0, 0x90, 0x4F, 0xE0, 0x92, 0x0A, 0xF0, 0x60, 0xBA, 0x09, 0x20, 0x8F, 0x0A, 0x20,
  0xB0, 0x92, 0x08, 0xFA, 0x06, 0x40, 0x8F, 0xC0, 0x62, 0x08, 0xFE, 0x06, 0x08, 0x80, 0xC4, 0xF0,
  0xDF, 0xF8, 0x1D, 0x4D, 0xFD, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_task() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_task_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_thermostat 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_filled_24_device_thermostat_data[] PROGMEM = {
  0x38, 0x28, 0xDD, 0x85, 0x08, 0xC0, 0x84, 0x84, 0xDF, 0x33, 0xFD, 0x4A, 0x2A, 0x4A, 0x1B, 0x4A,
  0x2A, 0x4A, 0x2A, 0x4A, 0x1B, 0x4A, 0x2A, 0x4E, 0x4E, 0x30, 0x8E, 0x81, 0x80, 0x4F, 0x90, 0x40,
  0xBF, 0x90, 0xB0, 0xEF, 0x90, 0x0E, 0xF9, 0x0E, 0x0B, 0xF9, 0x0B, 0x04, 0xF9, 0x81, 0x40, 0x8E,
  0x08, 0x38, 0x44, 0xBE, 0xEB, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_thermostat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(7, 2, 16, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_thermostat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_timer_10_select 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_filled_24_device_timer_10_select_data[] PROGMEM = {
  0xD2, 0x08, 0x0D, 0xB0, 0xD0, 0x87, 0x1D, 0x10, 0x8F, 0x08, 0x7D, 0x10, 0xDF, 0x0D, 0x72, 0xB1,
  0xB3, 0xB7, 0x2B, 0x1B, 0x3B, 0x72, 0xB1, 0xB3, 0xB7, 0x2B, 0x1B, 0x3B, 0x10, 0x8D, 0x2B, 0x1B,
  0x3B, 0x1E, 0x2B, 0x1B, 0x3B, 0x1A, 0x6B, 0x1B, 0x3B, 0x1D, 0x08, 0x2B, 0x1B, 0x3B, 0x10, 0x8D,
  0x2B, 0x10, 0xDF, 0x0D, 0x5A, 0x2B, 0x10, 0x8F, 0x08, 0x1E, 0x2B, 0x20, 0x80, 0xDB, 0x0D, 0x08,
  0x2D, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_timer_10_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_filled_24_device_timer_10_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_timer_3_select 24x24, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_filled_24_device_timer_3_select_data[] PROGMEM = {
  0xE0, 0xD0, 0x87, 0x2F, 0x90, 0x87, 0x1F, 0x90, 0xD7, 0x7B, 0x77, 0xB7, 0x18, 0x02, 0x7A, 0x0D,
  0x71, 0xF0, 0xD0, 0x32, 0x08, 0xFD, 0x0D, 0x03, 0x2E, 0x80, 0x27, 0xA0, 0xD2, 0xA7, 0x3B, 0x2D,
  0x08, 0x6B, 0x20, 0x8F, 0xE0, 0xD6, 0xFB, 0x08, 0x2F, 0xD0, 0xD0, 0x83, 0xD0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_timer_3_select() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 20, 18), Box(0, 0, 23, 23),
      ic_filled_24_device_timer_3_select_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_tungsten 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_filled_24_device_tungsten_data[] PROGMEM = {
  0x7E, 0x77, 0xE7, 0x7A, 0x2A, 0x77, 0xA2, 0xA7, 0x7A, 0x00, 0xEA, 0x76, 0x07, 0xE0, 0x77, 0x40,
  0x4F, 0x90, 0x47, 0x30, 0xBF, 0x90, 0xB5, 0xB2, 0x0E, 0xF9, 0x0E, 0x2E, 0x20, 0xEF, 0x90, 0xE2,
  0xB5, 0x0B, 0xF9, 0x0B, 0x73, 0x04, 0xF9, 0x04, 0x74, 0x08, 0xE0, 0x87, 0x30, 0x52, 0x84, 0x4B,
  0xEE, 0xB4, 0x20, 0x57, 0x81, 0x6F, 0xB7, 0x18, 0x1B, 0xF6, 0x50, 0x2A, 0x06, 0x71, 0x06, 0xA0,
  0x25, 0x00, 0x64, 0xA4, 0x00, 0x67, 0x5A, 0x77, 0x4A, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_tungsten() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_tungsten_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_usb_off 24x24, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_filled_24_device_usb_off_data[] PROGMEM = {
  0x73, 0x00, 0x57, 0x18, 0x11, 0xC7, 0x68, 0x22, 0xEE, 0x27, 0x04, 0xA0, 0x75, 0x0C, 0xA0, 0xC7,
  0x10, 0x5A, 0x07, 0x30, 0x9C, 0x09, 0x71, 0x05, 0xA0, 0x74, 0xA7, 0x40, 0x5A, 0x07, 0x3A, 0x75,
  0x08, 0xA0, 0x72, 0x0A, 0x92, 0xC6, 0x0D, 0xB0, 0x72, 0x0A, 0x2C, 0x60, 0xDC, 0x07, 0x4C, 0x60,
  0x4A, 0x08, 0xA0, 0x73, 0xC7, 0xA1, 0x05, 0xA0, 0x73, 0xA7, 0x1A, 0x20, 0x5A, 0x07, 0x20, 0xA9,
  0x71, 0x0D, 0xF0, 0x72, 0x08, 0x71, 0x04, 0x0D, 0xF0, 0x77, 0x71, 0xA0, 0x5A, 0x07, 0x77, 0xA1,
  0x05, 0xA0, 0x77, 0x50, 0x4A, 0x81, 0x40, 0x5A, 0x07, 0x74, 0x0D, 0xA0, 0xD2, 0x05, 0xA0, 0x77,
  0x30, 0xDA, 0x0D, 0x30, 0x5A, 0x07, 0x72, 0x82, 0x4D, 0xD4, 0x48, 0x15, 0xFC, 0x77, 0x40, 0x40,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_usb_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_usb_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_usb 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_filled_24_device_usb_data[] PROGMEM = {
  0x70, 0x05, 0x75, 0x82, 0x2E, 0xE2, 0x74, 0x0C, 0xA0, 0xC7, 0x30, 0x9C, 0x09, 0x74, 0xA7, 0x10,
  0x01, 0x3A, 0x70, 0x7A, 0x07, 0x2A, 0x2C, 0x01, 0xC0, 0x11, 0xA2, 0xC0, 0x1C, 0x01, 0x1A, 0x2C,
  0x10, 0x7A, 0x07, 0x2A, 0x2C, 0x2A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x30, 0xDF, 0xB0, 0xD3, 0x04,
  0x0D, 0xF9, 0x0D, 0x04, 0x71, 0xA7, 0x6A, 0x76, 0xA7, 0x50, 0x8A, 0x08, 0x73, 0x01, 0xC0, 0x17,
  0x20, 0x1C, 0x01, 0x73, 0x07, 0xA0, 0x77, 0x50, 0x01, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_usb() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_usb_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wallpaper 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_24_device_wallpaper_data[] PROGMEM = {
  0x04, 0x0D, 0xF2, 0xF8, 0x1D, 0x4D, 0xF9, 0x2F, 0x90, 0xDA, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C,
  0x73, 0x81, 0x8E, 0x83, 0xC7, 0x38, 0x1E, 0xFE, 0x3C, 0x73, 0x81, 0x8E, 0x83, 0xC7, 0x72, 0xA8,
  0x0C, 0x40, 0xA5, 0x00, 0x67, 0x2C, 0x40, 0x3A, 0x03, 0x20, 0x05, 0x4C, 0x30, 0x10, 0xDA, 0x84,
  0xD1, 0x2E, 0xE2, 0x3C, 0x30, 0xBC, 0x00, 0xCA, 0x0C, 0x3C, 0x20, 0x9F, 0xB0, 0x92, 0xC7, 0x72,
  0xC7, 0x72, 0xA0, 0xDF, 0x92, 0xF9, 0x81, 0xD4, 0xDF, 0x2F, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wallpaper() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_wallpaper_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_water 24x24, 4-bit Alpha,  RLE, 77 bytes.
static const unsigned char ic_filled_24_device_water_data[] PROGMEM = {
  0x8A, 0x21, 0x8D, 0xFC, 0x50, 0x3A, 0xEE, 0xA3, 0x05, 0xCF, 0xE8, 0x1F, 0xFE, 0x8A, 0x2E, 0xA3,
  0x05, 0xCF, 0xD8, 0x11, 0x8E, 0xFC, 0x50, 0x3A, 0xE7, 0x76, 0x8A, 0x21, 0x8D, 0xFC, 0x50, 0x3A,
  0xEE, 0xA3, 0x05, 0xCF, 0xE8, 0x1F, 0xFE, 0x8A, 0x2E, 0xA3, 0x05, 0xCF, 0xD8, 0x11, 0x8E, 0xFC,
  0x50, 0x3A, 0xE7, 0x76, 0x8A, 0x21, 0x8D, 0xFC, 0x50, 0x3A, 0xEF, 0xA3, 0x05, 0xCF, 0xE8, 0x1F,
  0xFE, 0x8A, 0x2E, 0xA3, 0x05, 0xCF, 0xD8, 0x11, 0x8E, 0xFC, 0x50, 0x3A, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_water() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 17), Box(0, 0, 23, 23),
      ic_filled_24_device_water_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_widgets 24x24, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_filled_24_device_widgets_data[] PROGMEM = {
  0x76, 0x01, 0x77, 0x48, 0x13, 0xE7, 0x5F, 0x93, 0x03, 0x0E, 0xA0, 0x74, 0xF9, 0x20, 0x30, 0xEC,
  0x07, 0x3F, 0x91, 0x03, 0x0E, 0xE0, 0x72, 0xF9, 0x03, 0x0E, 0xF9, 0x07, 0x1F, 0x90, 0xBF, 0xA0,
  0xE0, 0x1F, 0x91, 0x0C, 0xF0, 0xE0, 0x31, 0xF9, 0x20, 0xCD, 0x0E, 0x03, 0x2F, 0x93, 0x0C, 0xB0,
  0xE0, 0x37, 0x71, 0x82, 0xCF, 0xE3, 0x77, 0x30, 0xB0, 0x35, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92,
  0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9,
  0x2F, 0x92,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_widgets() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_widgets_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_1_bar 24x24, 4-bit Alpha,  RLE, 16 bytes.
static const unsigned char ic_filled_24_device_wifi_1_bar_data[] PROGMEM = {
  0x18, 0x64, 0xBE, 0xEB, 0x40, 0x4E, 0x81, 0x40, 0x7C, 0x07, 0x30, 0x7A, 0x07, 0x50, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_1_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(8, 16, 15, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_1_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_2_bar 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_filled_24_device_wifi_2_bar_data[] PROGMEM = {
  0x38, 0x90, 0x15, 0xAD, 0xEE, 0xDA, 0x51, 0x50, 0x70, 0xEF, 0x90, 0xE0, 0x72, 0x01, 0x0C, 0xFD,
  0x81, 0xC1, 0x6B, 0x81, 0xC6, 0x22, 0x81, 0x26, 0xCB, 0x83, 0x60, 0x7F, 0x67, 0x18, 0x16, 0xF7,
  0x30, 0x27, 0x30, 0x17, 0x84, 0x4B, 0xEE, 0xB4, 0x72, 0x04, 0xE0, 0x47, 0x20, 0x7C, 0x07, 0x74,
  0x07, 0xA0, 0x77, 0x60, 0x07, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_2_bar() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 10, 19, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_2_bar_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_calling_3 24x24, 4-bit Alpha,  RLE, 109 bytes.
static const unsigned char ic_filled_24_device_wifi_calling_3_data[] PROGMEM = {
  0x0B, 0xC0, 0xD4, 0x85, 0x6B, 0xDF, 0xDB, 0x52, 0x0E, 0xD8, 0x94, 0x40, 0x3D, 0xFC, 0x97, 0x9D,
  0xFD, 0x3C, 0xD8, 0x37, 0x0D, 0xD3, 0x58, 0x24, 0xDC, 0xAD, 0x89, 0x4A, 0x01, 0x01, 0x8D, 0xFD,
  0x81, 0x11, 0x6D, 0x0D, 0x38, 0x5B, 0xFA, 0x8A, 0xFB, 0x20, 0x2D, 0x07, 0x30, 0x20, 0x33, 0x03,
  0x01, 0x30, 0xBB, 0x07, 0x68, 0x18, 0xE8, 0x50, 0x5A, 0x07, 0x78, 0x12, 0xB1, 0x68, 0x1C, 0xF7,
  0x77, 0x20, 0x3A, 0x03, 0x77, 0x28, 0x28, 0xFD, 0x17, 0x72, 0x82, 0xBF, 0xC1, 0x48, 0x36, 0xDA,
  0x74, 0x68, 0x31, 0xCF, 0xD3, 0x20, 0x7D, 0x0D, 0x60, 0x10, 0xBA, 0x00, 0x7F, 0x71, 0x08, 0xFB,
  0x72, 0x03, 0x0C, 0xF9, 0x74, 0x05, 0x0B, 0xE7, 0x68, 0x41, 0x6A, 0xCE, 0xB1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_calling_3() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_calling_3_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_channel 24x24, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_filled_24_device_wifi_channel_data[] PROGMEM = {
  0x74, 0x82, 0x3D, 0xD3, 0x76, 0x01, 0x0E, 0xA0, 0xE0, 0x17, 0x58, 0x48, 0xFA, 0xBF, 0x87, 0x58,
  0x4E, 0xF3, 0x3F, 0xE7, 0x48, 0x13, 0xFD, 0x28, 0x1D, 0xF3, 0x48, 0x23, 0xDD, 0x22, 0x81, 0x7F,
  0x82, 0x81, 0x8F, 0x74, 0x0D, 0xA0, 0xD2, 0x81, 0xBF, 0x52, 0x81, 0x5F, 0xB3, 0x89, 0x07, 0xFB,
  0xBF, 0x70, 0xEF, 0x22, 0x81, 0x2F, 0xD3, 0x87, 0xDF, 0x33, 0xFD, 0x1F, 0xE4, 0x85, 0xEF, 0x10,
  0x4F, 0xC2, 0x83, 0xDF, 0x7F, 0xC4, 0x85, 0xCF, 0x30, 0x8F, 0x72, 0x89, 0x68, 0xFE, 0xFA, 0x6E,
  0xE6, 0xAF, 0x50, 0xCF, 0x32, 0x03, 0xB0, 0xDC, 0x82, 0xDF, 0x71, 0xA4, 0xD0, 0x40, 0x5B, 0x82,
  0x94, 0xFB, 0x40, 0xBB, 0x09, 0x20, 0xAA, 0x82, 0xA7, 0xF8, 0x40, 0x8B, 0x02, 0x20, 0x2A, 0x82,
  0xC9, 0xF6, 0x40, 0x6A, 0x0B, 0x48, 0x4B, 0xFD, 0xCF, 0x34, 0x03, 0xA0, 0x64, 0x84, 0x6F, 0xEE,
  0xF1, 0x40, 0x1A, 0x02, 0x40, 0x2A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_channel() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_channel_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_find 24x24, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_filled_24_device_wifi_find_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9F, 0xFA, 0x09, 0x01, 0x30, 0x40, 0xEF, 0xFC, 0x82, 0xE4, 0x06, 0xFE, 0x84, 0x83, 0x01, 0x38,
  0xB0, 0x60, 0x7F, 0xC0, 0xD0, 0x26, 0x84, 0x2D, 0xF7, 0x07, 0xFA, 0x89, 0x2E, 0x20, 0x1A, 0xEE,
  0xA1, 0x03, 0x73, 0x07, 0xF9, 0x82, 0x80, 0x1E, 0xC0, 0xE0, 0x16, 0x07, 0xF8, 0x90, 0x30, 0xAF,
  0xA1, 0x1A, 0xFA, 0x70, 0x7E, 0x28, 0x1D, 0xF1, 0x28, 0x11, 0xFD, 0x71, 0x07, 0xD8, 0x31, 0x0D,
  0xF1, 0x28, 0x11, 0xFE, 0x72, 0x07, 0xC8, 0x90, 0x30, 0xAF, 0xA1, 0x1A, 0xFA, 0x73, 0x07, 0xB8,
  0x29, 0x01, 0xED, 0x0C, 0x01, 0x73, 0x07, 0xB8, 0x91, 0x30, 0x1A, 0xEE, 0xAC, 0xFC, 0x17, 0x30,
  0x7A, 0x0D, 0x02, 0x58, 0x21, 0xCF, 0xB7, 0x40, 0x7A, 0x07, 0x68, 0x11, 0xB2, 0x75, 0x00, 0x77,
  0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_find() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_find_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_lock 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_24_device_wifi_lock_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9F, 0xFA, 0x09, 0x01, 0x30, 0x40, 0xEF, 0xFC, 0x82, 0xE4, 0x06, 0xFF, 0xF9, 0x06, 0x07, 0xFF,
  0xF9, 0x81, 0x70, 0x7F, 0xFE, 0x07, 0x30, 0x7F, 0xE8, 0x1D, 0x51, 0x71, 0x07, 0xFC, 0x0D, 0x01,
  0x74, 0x07, 0xFB, 0x06, 0x28, 0x24, 0xDD, 0x47, 0x07, 0xFA, 0x02, 0x28, 0x2D, 0x33, 0xD7, 0x10,
  0x7F, 0x93, 0x92, 0x97, 0x20, 0x7F, 0x20, 0xBC, 0x0B, 0x72, 0x07, 0xE2, 0xE7, 0x30, 0x7C, 0x07,
  0x2E, 0x74, 0x07, 0xA0, 0x73, 0xE7, 0x50, 0x07, 0x40, 0xBC, 0x0B, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_password 24x24, 4-bit Alpha,  RLE, 132 bytes.
static const unsigned char ic_filled_24_device_wifi_password_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x81, 0x2A, 0xEF, 0xB8, 0x1E, 0xA2, 0x60, 0x10,
  0x9F, 0xFA, 0x09, 0x01, 0x30, 0x40, 0xEC, 0x82, 0xC7, 0x42, 0x28, 0x22, 0x47, 0xCC, 0x82, 0xE4,
  0x06, 0xC0, 0xA0, 0x27, 0x30, 0x20, 0xAC, 0x06, 0x07, 0xA0, 0xD0, 0x37, 0x70, 0x30, 0xDA, 0x83,
  0x70, 0x7B, 0x13, 0x89, 0x01, 0x5A, 0xDE, 0xED, 0xA5, 0x13, 0x81, 0x1B, 0x77, 0x07, 0x0E, 0xF9,
  0x0E, 0x07, 0x73, 0x01, 0x0C, 0xFD, 0x0C, 0x01, 0x71, 0x06, 0xB8, 0x1C, 0x62, 0x28, 0x12, 0x6C,
  0xB0, 0x67, 0x28, 0x17, 0xF6, 0x71, 0x81, 0x6F, 0x77, 0x40, 0x27, 0x30, 0x17, 0x71, 0x84, 0x4B,
  0xEE, 0xB4, 0x48, 0x24, 0xDD, 0x47, 0x20, 0x4E, 0x04, 0x38, 0x2D, 0x33, 0xD7, 0x30, 0x7C, 0x07,
  0x49, 0x29, 0x74, 0x07, 0xA0, 0x74, 0x0B, 0xC0, 0xB7, 0x40, 0x07, 0x5E, 0x77, 0x4E, 0x77, 0x4E,
  0x77, 0x40, 0xBC, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_password() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 23), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_password_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_tethering_error 24x24, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_filled_24_device_wifi_tethering_error_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xC9, 0x47, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x75, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x07, 0x30, 0x4A, 0x04, 0x28, 0x46,
  0xCE, 0xEC, 0x62, 0x04, 0xA0, 0x42, 0x84, 0xDF, 0x60, 0x1C, 0xE0, 0xC0, 0x15, 0x81, 0x5F, 0xC2,
  0x89, 0x0C, 0xFD, 0x51, 0x15, 0xDF, 0xC5, 0x86, 0x9F, 0x60, 0x6F, 0xD1, 0x48, 0x21, 0xDF, 0x62,
  0xA8, 0x96, 0xDF, 0x20, 0xCF, 0x50, 0x4D, 0xD4, 0x05, 0xFC, 0x2A, 0x0E, 0x92, 0x83, 0xEF, 0x10,
  0xDA, 0x83, 0xD0, 0x1F, 0xE2, 0xA0, 0xE9, 0x20, 0xE9, 0x20, 0xDA, 0x0D, 0x29, 0x0E, 0x2A, 0x89,
  0x6D, 0xF2, 0x0C, 0xF5, 0x04, 0xDD, 0x40, 0x5F, 0xC2, 0xA8, 0x59, 0xF6, 0x06, 0xFD, 0x68, 0x1D,
  0xF6, 0x2A, 0x81, 0x5F, 0xC2, 0x0C, 0x07, 0x60, 0x70, 0xC6, 0x81, 0xDF, 0x67, 0x73, 0x04, 0xA0,
  0x27, 0x6A, 0x20, 0x80, 0x77, 0x7A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_tethering_error() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_tethering_error_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_tethering_error_rounded 24x24, 4-bit Alpha,  RLE, 134 bytes.
static const unsigned char ic_filled_24_device_wifi_tethering_error_rounded_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xC9, 0x47, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x75, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x07, 0x30, 0x4A, 0x04, 0x28, 0x46,
  0xCE, 0xEC, 0x62, 0x04, 0xA0, 0x42, 0x84, 0xDF, 0x60, 0x1C, 0xE0, 0xC0, 0x15, 0x81, 0x5F, 0xC2,
  0x89, 0x0C, 0xFD, 0x51, 0x15, 0xDF, 0xC5, 0x86, 0x9F, 0x60, 0x6F, 0xD1, 0x48, 0x21, 0xDF, 0x62,
  0xA8, 0x96, 0xDF, 0x20, 0xCF, 0x50, 0x4D, 0xD4, 0x05, 0xFC, 0x2A, 0x0E, 0x92, 0x83, 0xEF, 0x10,
  0xDA, 0x83, 0xD0, 0x1F, 0xE2, 0xA0, 0xE9, 0x20, 0xE9, 0x20, 0xDA, 0x0D, 0x29, 0x0E, 0x2A, 0x89,
  0x6D, 0xF2, 0x0C, 0xF5, 0x04, 0xDD, 0x40, 0x5F, 0xC2, 0xA8, 0x59, 0xF6, 0x06, 0xFD, 0x68, 0x1D,
  0xF6, 0x2A, 0x81, 0x5F, 0xC2, 0x0C, 0x07, 0x60, 0x70, 0xC6, 0x81, 0xDF, 0x67, 0x73, 0x04, 0xA0,
  0x27, 0x6A, 0x20, 0x80, 0x77, 0x7A,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_tethering_error_rounded() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_tethering_error_rounded_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_tethering_off 24x24, 4-bit Alpha,  RLE, 175 bytes.
static const unsigned char ic_filled_24_device_wifi_tethering_off_data[] PROGMEM = {
  0x81, 0x1C, 0x74, 0x86, 0x5A, 0xDF, 0xED, 0x95, 0x60, 0x4A, 0x07, 0x20, 0x8F, 0x90, 0xD0, 0x45,
  0x05, 0xA0, 0x72, 0x81, 0x86, 0x22, 0x81, 0x26, 0xCA, 0x08, 0x50, 0x5A, 0x07, 0x72, 0x06, 0xA0,
  0x84, 0x04, 0xB0, 0x72, 0x83, 0x6E, 0xEC, 0x62, 0x04, 0xA0, 0x43, 0x81, 0xDF, 0xAA, 0x07, 0x20,
  0xAB, 0x84, 0xC1, 0x06, 0xFD, 0x28, 0x35, 0xFC, 0x05, 0xA0, 0x72, 0x83, 0x15, 0xDF, 0xC2, 0x87,
  0xCF, 0x50, 0xAF, 0x60, 0x6B, 0x07, 0x38, 0x96, 0x1D, 0xF6, 0x06, 0xF9, 0x0D, 0xF2, 0x0B, 0xF9,
  0xA0, 0x73, 0x87, 0x5F, 0xC0, 0x2F, 0xD0, 0xE9, 0x28, 0x2E, 0xF0, 0x5A, 0x07, 0x28, 0x11, 0xFE,
  0x29, 0x81, 0xE0, 0xE9, 0x20, 0xE9, 0x20, 0xDA, 0x07, 0x20, 0xA0, 0xE2, 0x98, 0x92, 0xE0, 0xDF,
  0x20, 0xCF, 0x50, 0x4D, 0xA0, 0x72, 0x89, 0x36, 0x02, 0xFD, 0x09, 0xF6, 0x06, 0xFD, 0x30, 0x5A,
  0x07, 0x38, 0x57, 0xFA, 0x05, 0xFC, 0x20, 0xC0, 0x74, 0x05, 0xA0, 0x72, 0x81, 0x8F, 0x52, 0x81,
  0xDF, 0x67, 0x10, 0x5A, 0x07, 0x20, 0x83, 0x04, 0xA0, 0x27, 0x10, 0x5A, 0x07, 0x60, 0x80, 0x77,
  0x30, 0x5A, 0x07, 0x77, 0x40, 0x5A, 0x07, 0x77, 0x48, 0x15, 0xFC, 0x77, 0x50, 0x40, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_tethering_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_tethering_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_device_wifi_tethering 24x24, 4-bit Alpha,  RLE, 168 bytes.
static const unsigned char ic_filled_24_device_wifi_tethering_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x28, 0x46,
  0xCE, 0xEC, 0x62, 0x04, 0xA0, 0x42, 0x84, 0xDF, 0x60, 0x1C, 0xE8, 0x90, 0xC1, 0x06, 0xFD, 0x05,
  0xFC, 0x28, 0x90, 0xCF, 0xD5, 0x11, 0x5D, 0xFC, 0x28, 0x91, 0xCF, 0x59, 0xF6, 0x06, 0xFD, 0x14,
  0x8B, 0x31, 0xDF, 0x60, 0x6F, 0x9D, 0xF2, 0x0C, 0xF5, 0x04, 0xDD, 0x40, 0x5F, 0xC0, 0x2F, 0xDE,
  0x92, 0x83, 0xEF, 0x10, 0xDA, 0x83, 0xD0, 0x1F, 0xE2, 0x98, 0x90, 0xEE, 0xF1, 0x0E, 0xF1, 0x0D,
  0xA8, 0xC3, 0xD0, 0x1F, 0xE0, 0x1F, 0xEC, 0xF3, 0x0B, 0xF5, 0x04, 0xDD, 0x40, 0x5F, 0xB0, 0x3F,
  0xCA, 0xF6, 0x06, 0xFD, 0x14, 0x89, 0x11, 0xDF, 0x60, 0x6F, 0xA4, 0xFD, 0x28, 0x1C, 0xFC, 0x48,
  0x1C, 0xFC, 0x28, 0x91, 0xDF, 0x40, 0xDF, 0x70, 0x1C, 0x64, 0x85, 0x6C, 0x10, 0x7F, 0xD2, 0x04,
  0xA0, 0x47, 0x30, 0x4A, 0x04, 0x30, 0x7A, 0x07, 0x71, 0x07, 0xA0, 0x75, 0x81, 0x7F, 0xA7, 0x18,
  0x1A, 0xF7, 0x70, 0x40, 0x17, 0x10, 0x10, 0x44,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_device_wifi_tethering() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_device_wifi_tethering_data, Alpha4(color::Black));
  return value;
}
