#include "communication.h"

using namespace roo_display;

// Image file ic_filled_24_communication_3p 24x24, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_filled_24_communication_3p_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x4F, 0x82, 0xB1, 0x1B, 0xFF, 0xA0,
  0x12, 0x01, 0xFF, 0xA0, 0x12, 0x01, 0xFF, 0xA8, 0x2B, 0x11, 0xBF, 0xFF, 0xFE, 0x81, 0xE7, 0x22,
  0x81, 0x27, 0xEF, 0xD0, 0x46, 0x04, 0xFD, 0x71, 0x80, 0xF5, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0,
  0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_3p() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_3p_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_add_ic_call 24x24, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_filled_24_communication_add_ic_call_data[] PROGMEM = {
  0x0B, 0xC0, 0x47, 0xA3, 0x0E, 0xC0, 0x87, 0xA3, 0x0D, 0xC0, 0x97, 0xA3, 0x0B, 0xC0, 0xC4, 0xF9,
  0x09, 0xD4, 0xF9, 0x05, 0xC0, 0xC7, 0xA4, 0x0E, 0xA0, 0xC0, 0x17, 0xA4, 0x82, 0xAF, 0xD1, 0x71,
  0xA4, 0x82, 0x3F, 0xE1, 0x77, 0x18, 0x19, 0xFA, 0x77, 0x18, 0x21, 0xEF, 0x77, 0x71, 0x04, 0xA0,
  0x57, 0x71, 0x07, 0xA0, 0x73, 0x85, 0x1C, 0xFC, 0x98, 0x45, 0x07, 0xA8, 0x2A, 0x11, 0xCE, 0x68,
  0x34, 0xEF, 0xED, 0xF7, 0x01, 0x09, 0xFA, 0x72, 0x81, 0x2A, 0xEE, 0x75, 0x84, 0x59, 0xBD, 0xEB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_add_ic_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_add_ic_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_alternate_email 24x24, 4-bit Alpha,  RLE, 148 bytes.
static const unsigned char ic_filled_24_communication_alternate_email_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x40, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1D, 0x72,
  0x28, 0x12, 0x7D, 0xA0, 0x85, 0x08, 0xA0, 0x77, 0x10, 0x7A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x73, 0x84, 0x4B, 0xEE, 0xB4, 0x38, 0x57, 0xFD, 0x05, 0xFD, 0x30, 0x8E,
  0x08, 0x38, 0x4D, 0xF5, 0x9F, 0x72, 0x04, 0xA8, 0x27, 0x11, 0x7A, 0x04, 0x28, 0x47, 0xF9, 0xDF,
  0x22, 0x81, 0xBF, 0x74, 0x81, 0x7F, 0xB2, 0x82, 0x2F, 0xDE, 0x93, 0x81, 0xEF, 0x14, 0x81, 0x1F,
  0xE3, 0x90, 0x0E, 0x93, 0x81, 0xEF, 0x14, 0x01, 0xA3, 0xA8, 0x1D, 0xF2, 0x28, 0x1B, 0xF7, 0x40,
  0x7A, 0x3A, 0x81, 0x9F, 0x72, 0x04, 0xA8, 0x27, 0x11, 0x7B, 0x86, 0x80, 0x8F, 0xC5, 0xFD, 0x30,
  0x8E, 0x0B, 0xD8, 0x34, 0x0D, 0xF7, 0x38, 0x92, 0x4B, 0xEE, 0xB4, 0x05, 0xCF, 0xC4, 0x20, 0x4A,
  0x04, 0x77, 0x30, 0x8A, 0x07, 0x77, 0x30, 0x8A, 0x81, 0xD7, 0x27, 0x71, 0x04, 0x0D, 0xFA, 0x74,
  0x82, 0x59, 0xDE, 0xD5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_alternate_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_alternate_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_app_registration 24x24, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_filled_24_communication_app_registration_data[] PROGMEM = {
  0xC2, 0xC2, 0xC1, 0xC2, 0xC2, 0xC1, 0xC2, 0xC2, 0xC1, 0xC2, 0xC2, 0xC7, 0x77, 0x77, 0xC2, 0xC4,
  0x81, 0x4D, 0x2C, 0x2C, 0x38, 0x22, 0x4F, 0xDC, 0x2B, 0x0C, 0x28, 0x34, 0xF9, 0x44, 0xC2, 0xA8,
  0x2C, 0x10, 0x4B, 0x02, 0x74, 0x04, 0xB0, 0x47, 0x40, 0x4B, 0x04, 0x3C, 0x40, 0x4B, 0x04, 0x4C,
  0x30, 0x4B, 0x04, 0x5C, 0x3B, 0x04, 0x6C, 0x3A, 0x04, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_app_registration() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 20, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_app_registration_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_business 24x24, 4-bit Alpha,  RLE, 47 bytes.
static const unsigned char ic_filled_24_communication_business_data[] PROGMEM = {
  0xFB, 0x73, 0xFB, 0x73, 0xA2, 0xA2, 0xA7, 0x3A, 0x2A, 0x2A, 0x73, 0x80, 0xC6, 0xF2, 0xA2, 0xA7,
  0x1C, 0x2A, 0x2A, 0x71, 0xFF, 0x2A, 0x2F, 0xF2, 0xA2, 0xC2, 0xA2, 0xA7, 0x1C, 0x2A, 0x2A, 0x71,
  0xFF, 0x2A, 0x2F, 0xF2, 0xA2, 0xC2, 0xA2, 0xA7, 0x1C, 0x2A, 0x2A, 0x71, 0x80, 0xC6, 0xF0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_business() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_business_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_call_end 24x24, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_filled_24_communication_call_end_data[] PROGMEM = {
  0x78, 0x90, 0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x02, 0x0A, 0xFD, 0x0A, 0x02, 0x60, 0x10, 0xAB,
  0x82, 0xC7, 0x31, 0x28, 0x21, 0x37, 0xCB, 0x0A, 0x01, 0x30, 0x40, 0xEC, 0x06, 0x71, 0x06, 0xC8,
  0x2E, 0x40, 0x7E, 0x06, 0x71, 0x06, 0xE0, 0x70, 0xEE, 0x06, 0x71, 0x06, 0xE0, 0xE0, 0x4D, 0x0D,
  0x02, 0x71, 0x02, 0x0D, 0xD8, 0x14, 0x04, 0xB0, 0x87, 0x50, 0x8B, 0x04, 0x38, 0x14, 0xC4, 0x77,
  0x81, 0x4C, 0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_call_end() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 7, 23, 15), Box(0, 0, 23, 23),
      ic_filled_24_communication_call_end_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_call_made 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_24_communication_call_made_data[] PROGMEM = {
  0x5F, 0xB5, 0xFB, 0x73, 0x01, 0x0C, 0xB7, 0x28, 0x21, 0xCF, 0xCA, 0x71, 0x83, 0x1C, 0xFC, 0x1A,
  0x78, 0x31, 0xCF, 0xC1, 0x1A, 0x68, 0x31, 0xCF, 0xC1, 0x2A, 0x58, 0x31, 0xCF, 0xC1, 0x3A, 0x48,
  0x31, 0xCF, 0xC1, 0x4A, 0x38, 0x31, 0xCF, 0xC1, 0x5A, 0x28, 0x31, 0xCF, 0xC1, 0x72, 0x83, 0x1C,
  0xFC, 0x17, 0x28, 0x31, 0xCF, 0xC1, 0x73, 0x82, 0xBF, 0xC1, 0x74, 0x81, 0x2B, 0x17, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_call_made() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 5, 18, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_call_made_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_call_merge 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_filled_24_communication_call_merge_data[] PROGMEM = {
  0x60, 0x01, 0x74, 0x82, 0x1D, 0xD1, 0x72, 0x01, 0x0D, 0xA0, 0xD0, 0x17, 0x01, 0x0D, 0xC0, 0xD0,
  0x15, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x1A, 0x75, 0xA7, 0x5A, 0x75, 0xA7, 0x5A, 0x74, 0x01, 0xA7,
  0x38, 0x21, 0xCF, 0xC7, 0x28, 0x61, 0xCF, 0xC1, 0x01, 0x15, 0x89, 0x01, 0xCF, 0xC1, 0x01, 0xCC,
  0x13, 0x83, 0x1C, 0xFC, 0x12, 0x89, 0x11, 0xCF, 0xC1, 0x01, 0xCF, 0xC1, 0x48, 0x71, 0xCF, 0xC1,
  0x1C, 0xC1, 0x68, 0x51, 0xCC, 0x10, 0x11, 0x71, 0x00, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_call_merge() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_call_merge_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_call_missed_outgoing 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_filled_24_communication_call_missed_outgoing_data[] PROGMEM = {
  0x81, 0x2B, 0x17, 0xF9, 0x82, 0xBF, 0xC1, 0x6F, 0x98, 0x31, 0xCF, 0xC1, 0x71, 0x01, 0x0C, 0xB1,
  0x83, 0x1C, 0xFC, 0x16, 0x82, 0x1C, 0xFC, 0xA2, 0x83, 0x1C, 0xFC, 0x14, 0x83, 0x1C, 0xFC, 0x1A,
  0x38, 0x31, 0xCF, 0xC1, 0x28, 0x31, 0xCF, 0xC1, 0x1A, 0x48, 0x90, 0x1C, 0xFC, 0x11, 0xCF, 0xC1,
  0x2A, 0x58, 0x61, 0xCF, 0xCC, 0xFC, 0x13, 0xA6, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x68, 0x21, 0xCC,
  0x17, 0x71, 0x00, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_call_missed_outgoing() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 17), Box(0, 0, 23, 23),
      ic_filled_24_communication_call_missed_outgoing_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_call_missed 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_filled_24_communication_call_missed_data[] PROGMEM = {
  0xF9, 0x78, 0x11, 0xB2, 0xF9, 0x68, 0x21, 0xCF, 0xBB, 0x0C, 0x01, 0x71, 0x83, 0x1C, 0xFC, 0x1A,
  0x82, 0xCF, 0xC1, 0x68, 0x31, 0xCF, 0xC1, 0x1A, 0x83, 0x1C, 0xFC, 0x14, 0x83, 0x1C, 0xFC, 0x12,
  0xA1, 0x83, 0x1C, 0xFC, 0x12, 0x83, 0x1C, 0xFC, 0x13, 0xA2, 0x89, 0x01, 0xCF, 0xC1, 0x1C, 0xFC,
  0x14, 0xA3, 0x86, 0x1C, 0xFC, 0xCF, 0xC1, 0x74, 0x01, 0x0C, 0xA0, 0xC0, 0x17, 0x68, 0x21, 0xCC,
  0x17, 0x71, 0x00, 0x17, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_call_missed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 17), Box(0, 0, 23, 23),
      ic_filled_24_communication_call_missed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_call 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_filled_24_communication_call_data[] PROGMEM = {
  0x0B, 0xC0, 0x67, 0x50, 0xEC, 0x0A, 0x75, 0x0D, 0xC0, 0xB7, 0x50, 0xBC, 0x0E, 0x75, 0x09, 0xD0,
  0x27, 0x40, 0x4C, 0x0D, 0x76, 0x0E, 0xA0, 0xB0, 0x17, 0x60, 0xAA, 0x03, 0x77, 0x02, 0xA0, 0xC7,
  0x71, 0x09, 0xA0, 0x77, 0x70, 0x10, 0xEA, 0x04, 0x77, 0x03, 0xA0, 0xE0, 0x45, 0x02, 0x71, 0x05,
  0xB0, 0x73, 0x84, 0xCF, 0xEB, 0x96, 0x50, 0x5B, 0x81, 0xC3, 0xAE, 0x60, 0x30, 0xEF, 0xB7, 0x01,
  0x09, 0xFA, 0x72, 0x81, 0x29, 0xEE, 0x75, 0x84, 0x49, 0xBD, 0xEB,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_call() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_call_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_call_received 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_24_communication_call_received_data[] PROGMEM = {
  0x75, 0x81, 0x1B, 0x27, 0x48, 0x21, 0xCF, 0xB7, 0x38, 0x31, 0xCF, 0xC1, 0x72, 0x83, 0x1C, 0xFC,
  0x17, 0x28, 0x31, 0xCF, 0xC1, 0x2A, 0x58, 0x31, 0xCF, 0xC1, 0x3A, 0x48, 0x31, 0xCF, 0xC1, 0x4A,
  0x38, 0x31, 0xCF, 0xC1, 0x5A, 0x28, 0x31, 0xCF, 0xC1, 0x6A, 0x18, 0x31, 0xCF, 0xC1, 0x7A, 0x83,
  0x1C, 0xFC, 0x17, 0x1A, 0x82, 0xCF, 0xC1, 0x72, 0xB0, 0xC0, 0x17, 0x3F, 0xB5, 0xFB, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_call_received() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 4, 19, 18), Box(0, 0, 23, 23),
      ic_filled_24_communication_call_received_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_call_split 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_filled_24_communication_call_split_data[] PROGMEM = {
  0xD0, 0x74, 0x07, 0xFA, 0x07, 0x60, 0x7F, 0x0E, 0x01, 0x60, 0x10, 0xED, 0x82, 0xEF, 0xC1, 0x48,
  0x21, 0xCF, 0xEB, 0x84, 0x71, 0xCF, 0xC1, 0x28, 0x61, 0xCF, 0xC1, 0x7F, 0x72, 0x89, 0x01, 0xCF,
  0xC1, 0x04, 0xFC, 0x12, 0x07, 0x48, 0x61, 0xCF, 0xC1, 0x04, 0x17, 0x28, 0x21, 0xCF, 0xC7, 0x60,
  0x1A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7, 0x7A, 0x77, 0xA7,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_call_split() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_call_split_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_cancel_presentation 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_filled_24_communication_cancel_presentation_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x58,
  0x12, 0xB1, 0x28, 0x11, 0xB2, 0x5C, 0x58, 0x6B, 0xFC, 0x11, 0xCF, 0xB5, 0xC5, 0x86, 0x1C, 0xFC,
  0xCF, 0xC1, 0x5C, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x6C, 0x60, 0x10, 0xCA, 0x0C, 0x01, 0x6C, 0x58,
  0x61, 0xCF, 0xCC, 0xFC, 0x15, 0xC5, 0x86, 0xBF, 0xC1, 0x1C, 0xFB, 0x5C, 0x58, 0x12, 0xB1, 0x28,
  0x11, 0xB2, 0x5C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4A, 0x0D, 0x98, 0x09, 0x6D, 0x98, 0x1D, 0x4D,
  0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_cancel_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_cancel_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_cell_tower 24x24, 4-bit Alpha,  RLE, 162 bytes.
static const unsigned char ic_filled_24_communication_cell_tower_data[] PROGMEM = {
  0x20, 0x80, 0x77, 0x50, 0x70, 0x83, 0x81, 0x5F, 0xB7, 0x58, 0x1B, 0xF5, 0x28, 0x3D, 0xE1, 0x06,
  0x71, 0x89, 0x36, 0x01, 0xED, 0x05, 0xF7, 0x09, 0xF4, 0x68, 0x93, 0x4F, 0x90, 0x7F, 0x59, 0xF1,
  0x2F, 0xB3, 0x00, 0x63, 0x89, 0x2B, 0xF2, 0x1F, 0x9D, 0xD0, 0x7F, 0x32, 0x0D, 0xA0, 0xD2, 0x89,
  0x04, 0xF7, 0x0D, 0xDE, 0xB0, 0xA9, 0x20, 0x6C, 0x89, 0x66, 0x01, 0xF9, 0x0B, 0xEE, 0xB0, 0xAF,
  0x10, 0x5C, 0x05, 0x29, 0x89, 0x0A, 0x0B, 0xED, 0xD0, 0x7F, 0x42, 0x0D, 0xA0, 0xD2, 0x89, 0x23,
  0xF7, 0x0D, 0xD9, 0xF1, 0x2F, 0xB2, 0x0C, 0xA0, 0xC2, 0x8D, 0x3B, 0xF2, 0x1F, 0xA5, 0xF7, 0x09,
  0xF4, 0x2F, 0xCC, 0xF2, 0x4F, 0x90, 0x7F, 0x50, 0xDE, 0x10, 0x60, 0x7F, 0x77, 0xF7, 0x06, 0x01,
  0xED, 0x28, 0x15, 0xFB, 0x38, 0x4C, 0xF2, 0x2F, 0xC3, 0x81, 0xBF, 0x53, 0x08, 0x07, 0x28, 0x12,
  0xFC, 0x28, 0x1C, 0xF2, 0x20, 0x70, 0x97, 0x18, 0x17, 0xF7, 0x28, 0x17, 0xF7, 0x75, 0x0C, 0xE0,
  0xC7, 0x40, 0x2F, 0x90, 0x27, 0x38, 0x17, 0xF7, 0x48, 0x17, 0xF7, 0x73, 0x81, 0xCF, 0x24, 0x81,
  0x2F, 0xC5,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_cell_tower() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_cell_tower_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_cell_wifi 24x24, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_filled_24_communication_cell_wifi_data[] PROGMEM = {
  0x38, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x10, 0x40, 0xDB, 0x00, 0xDB, 0x0D, 0x05, 0x50, 0x8A, 0x0A,
  0x03, 0x40, 0x30, 0x9A, 0x08, 0x48, 0x17, 0xD3, 0x28, 0x22, 0x44, 0x22, 0x81, 0x3D, 0x73, 0x08,
  0x30, 0x40, 0xCC, 0x0C, 0x04, 0x50, 0x89, 0x20, 0x3A, 0x82, 0xB8, 0x8B, 0xA0, 0x33, 0x08, 0xA3,
  0x07, 0x03, 0x40, 0x40, 0x73, 0x08, 0xB5, 0x82, 0x39, 0x93, 0x40, 0x8C, 0x50, 0x7A, 0x07, 0x30,
  0x8A, 0x04, 0xA6, 0x00, 0x73, 0x07, 0xA0, 0x41, 0xA7, 0x30, 0x7B, 0x2A, 0x72, 0x07, 0xC2, 0xA7,
  0x10, 0x7D, 0x2A, 0x70, 0x7E, 0x2A, 0x60, 0x7F, 0x2A, 0x50, 0x7F, 0x92, 0xA4, 0x07, 0xFA, 0x2A,
  0x30, 0x7F, 0xF2, 0x07, 0xFF, 0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_cell_wifi() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_cell_wifi_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_chat_bubble_outline 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_filled_24_communication_chat_bubble_outline_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77,
  0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77, 0x2C, 0x77,
  0x2C, 0x10, 0x7F, 0xF9, 0x0D, 0xA0, 0x7F, 0xF9, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73,
  0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_chat_bubble_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_chat_bubble_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_chat_bubble 24x24, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_filled_24_communication_chat_bubble_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0B, 0xF7, 0xF0, 0xDF, 0xFC, 0x0D, 0x04,
  0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_chat_bubble() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_chat_bubble_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_chat 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_filled_24_communication_chat_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xFF, 0xFF,
  0x75, 0xF9, 0x75, 0xFF, 0xFF, 0x71, 0xFD, 0x71, 0x80, 0xF7, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0,
  0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_chat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_chat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_clear_all 24x24, 4-bit Alpha,  RLE, 14 bytes.
static const unsigned char ic_filled_24_communication_clear_all_data[] PROGMEM = {
  0x4F, 0xF4, 0xFF, 0x80, 0xC2, 0x0F, 0xF4, 0xFF, 0x80, 0xC2, 0x0F, 0xF4, 0xFF, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_clear_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 7, 20, 16), Box(0, 0, 23, 23),
      ic_filled_24_communication_clear_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_comment 24x24, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_filled_24_communication_comment_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xFF, 0xFF,
  0x75, 0xF9, 0x75, 0xFF, 0xFF, 0x75, 0xF9, 0x75, 0x80, 0xD0, 0xF0, 0xDF, 0xFD, 0x04, 0x0D, 0xFF,
  0xC7, 0x72, 0x07, 0xB7, 0x73, 0x07, 0xA7, 0x74, 0x07, 0x97, 0x75, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_comment() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_comment_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_comments_disabled 24x24, 4-bit Alpha,  RLE, 104 bytes.
static const unsigned char ic_filled_24_communication_comments_disabled_data[] PROGMEM = {
  0x10, 0x40, 0x72, 0x0A, 0xFF, 0x84, 0xD4, 0x1E, 0xF7, 0x20, 0xAF, 0xF8, 0x1D, 0x05, 0xA0, 0x72,
  0x0A, 0xFF, 0x2B, 0x07, 0x20, 0xAF, 0xE2, 0xC0, 0x77, 0x4C, 0x2D, 0x07, 0x73, 0xC2, 0xE0, 0x72,
  0x0A, 0xFB, 0x2C, 0x05, 0xA0, 0x77, 0x1C, 0x2C, 0x10, 0x5A, 0x07, 0x7C, 0x2F, 0xA0, 0x72, 0x0A,
  0xF2, 0xC3, 0x05, 0xA0, 0x75, 0xC2, 0xC4, 0x05, 0xA0, 0x74, 0xC2, 0xFD, 0x07, 0x20, 0xAC, 0x2F,
  0xE0, 0x72, 0x0A, 0xB2, 0x0D, 0xFE, 0x07, 0x20, 0xAA, 0x20, 0x40, 0xDF, 0xE0, 0x72, 0x0A, 0x97,
  0x71, 0x05, 0xA0, 0x72, 0x0A, 0x77, 0x20, 0x5A, 0x07, 0x77, 0x50, 0x5A, 0x07, 0x77, 0x50, 0x5A,
  0x07, 0x77, 0x58, 0x15, 0xE4, 0x77, 0x60, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_comments_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 21, 23), Box(0, 0, 23, 23),
      ic_filled_24_communication_comments_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_contact_emergency 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_24_communication_contact_emergency_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xF9, 0x0D, 0x80, 0xC5, 0xF0, 0x03, 0xFF, 0xE8, 0x46,
  0x42, 0x24, 0x6F, 0xB8, 0x27, 0x11, 0x7C, 0x09, 0x01, 0x20, 0x10, 0x9F, 0xA0, 0x74, 0x07, 0xB0,
  0x90, 0x12, 0x01, 0x09, 0xFA, 0x01, 0x40, 0x1B, 0x84, 0x64, 0x22, 0x46, 0xFA, 0x01, 0x40, 0x1D,
  0x00, 0x3F, 0xC0, 0x74, 0x07, 0xFF, 0xD8, 0x27, 0x11, 0x78, 0x0C, 0x6F, 0x86, 0xD6, 0x31, 0x13,
  0x6D, 0xFF, 0x90, 0x77, 0x10, 0x7F, 0xE0, 0x47, 0x30, 0x4F, 0xC0, 0x77, 0x50, 0x7F, 0x90, 0xDF,
  0xFF, 0x98, 0x1D, 0x4D, 0xFF, 0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_contact_emergency() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_contact_emergency_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_contact_mail 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_24_communication_contact_mail_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xF9, 0x0D, 0xFF, 0xFF, 0xA8, 0x27, 0x11, 0x7C, 0x71,
  0xF0, 0x74, 0x07, 0xB1, 0x0A, 0x01, 0x20, 0x10, 0xA1, 0xF0, 0x14, 0x01, 0xB1, 0x84, 0x5C, 0x55,
  0xC5, 0x1F, 0x01, 0x40, 0x1B, 0x28, 0x21, 0xAA, 0x12, 0xF0, 0x74, 0x07, 0xB7, 0x1F, 0x98, 0x27,
  0x11, 0x7C, 0x71, 0xFF, 0xFF, 0xD0, 0x0E, 0xFF, 0xD0, 0x90, 0x53, 0x81, 0x15, 0x9F, 0xF0, 0xC0,
  0x17, 0x10, 0x10, 0xCF, 0xD0, 0x27, 0x30, 0x2F, 0xD7, 0x5F, 0xFF, 0xFE, 0x0D, 0xFF, 0xF9, 0x81,
  0xD4, 0xDF, 0xFE, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_contact_mail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_contact_mail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_contact_phone 24x24, 4-bit Alpha,  RLE, 99 bytes.
static const unsigned char ic_filled_24_communication_contact_phone_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xE8, 0x1D, 0x4D, 0xFF, 0xF9, 0x0D, 0xFF, 0xFF, 0xA8, 0x27, 0x11, 0x7F, 0x90,
  0x07, 0xFA, 0x07, 0x40, 0x7E, 0x08, 0x20, 0x7F, 0x90, 0x14, 0x01, 0xD0, 0xD3, 0x05, 0xF9, 0x01,
  0x40, 0x1D, 0x07, 0x20, 0x20, 0xEF, 0x90, 0x74, 0x07, 0xD0, 0x30, 0x4F, 0xD8, 0x27, 0x11, 0x7E,
  0x01, 0x07, 0xFF, 0xF9, 0x01, 0x07, 0xFE, 0x00, 0xEF, 0x03, 0x04, 0xFB, 0x09, 0x05, 0x38, 0x11,
  0x59, 0xC0, 0x72, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x10, 0x10, 0xCA, 0x0D, 0x30, 0x5D, 0x02, 0x73,
  0x02, 0xB0, 0x82, 0x07, 0xD7, 0x5C, 0x00, 0x7F, 0xFF, 0xF0, 0xDF, 0xFF, 0x98, 0x1D, 0x4D, 0xFF,
  0xE0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_contact_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_contact_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_contacts 24x24, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_filled_24_communication_contacts_data[] PROGMEM = {
  0x2F, 0xFA, 0x4F, 0xFA, 0x80, 0xC6, 0x00, 0x40, 0xDF, 0xFA, 0x81, 0xD4, 0xDF, 0xFC, 0x0D, 0xFA,
  0x00, 0xDF, 0xFB, 0x06, 0x20, 0x6F, 0xF9, 0x0D, 0x40, 0xDF, 0xF0, 0xD4, 0x0D, 0xFF, 0x90, 0x62,
  0x06, 0xFF, 0xB0, 0x0D, 0xFF, 0xFF, 0xF8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xFC, 0x08, 0x71, 0x08,
  0xFB, 0x73, 0xFB, 0x73, 0xFF, 0xFC, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x48, 0x0C,
  0x60, 0xFF, 0xA4, 0xFF, 0xA2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 23), Box(0, 0, 23, 23),
      ic_filled_24_communication_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_co_present 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_24_communication_co_present_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x77, 0x4C, 0x38, 0x41, 0xAD, 0xDA, 0x17,
  0x2C, 0x20, 0x10, 0xEC, 0x0E, 0x01, 0x71, 0xC2, 0x0A, 0xE0, 0xA7, 0x1C, 0x20, 0xDE, 0x0D, 0x71,
  0xC2, 0x0D, 0xE0, 0xD7, 0x1C, 0x20, 0xAE, 0x0A, 0x71, 0xC2, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x1A,
  0x58, 0x41, 0xAD, 0xDA, 0x17, 0x2A, 0x77, 0x6A, 0x38, 0x23, 0x8B, 0xDA, 0x82, 0xDB, 0x83, 0x7A,
  0x10, 0x50, 0xCF, 0xB0, 0xC0, 0x55, 0xA0, 0x6F, 0xF0, 0x64, 0xA0, 0xDF, 0xF0, 0xD4, 0xFF, 0xC4,
  0x90, 0xDF, 0xFA, 0x40, 0xD0, 0x4F, 0xFA, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_co_present() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_co_present_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_desktop_access_disabled 24x24, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_filled_24_communication_desktop_access_disabled_data[] PROGMEM = {
  0x83, 0x6C, 0x10, 0x7F, 0xFA, 0x86, 0xD4, 0x9F, 0xC1, 0x07, 0xFF, 0xA0, 0xD1, 0xA0, 0xC0, 0x17,
  0x72, 0xA1, 0xB0, 0xC0, 0x17, 0x71, 0xA1, 0xA8, 0x29, 0xFD, 0x17, 0x7A, 0x1A, 0x18, 0x29, 0xFD,
  0x17, 0x6A, 0x1A, 0x28, 0x29, 0xFD, 0x17, 0x5A, 0x1A, 0x38, 0x29, 0xFD, 0x17, 0x4A, 0x1A, 0x48,
  0x29, 0xFD, 0x17, 0x3A, 0x1A, 0x58, 0x29, 0xFD, 0x17, 0x2A, 0x1A, 0x68, 0x29, 0xFD, 0x17, 0x1A,
  0x1A, 0x78, 0x29, 0xFD, 0x17, 0xA1, 0xA7, 0x18, 0x29, 0xFD, 0x16, 0xA1, 0xA7, 0x28, 0x29, 0xFD,
  0x15, 0xA1, 0x0D, 0xFE, 0x82, 0xD1, 0x07, 0xB8, 0x2D, 0x04, 0xDF, 0xE8, 0x5D, 0x10, 0x7F, 0xD4,
  0x73, 0xC1, 0x82, 0x9F, 0xD1, 0x77, 0xC2, 0x82, 0x9F, 0xD1, 0x74, 0xF9, 0x18, 0x29, 0xFD, 0x17,
  0x3F, 0x92, 0x82, 0x9F, 0xD1, 0x77, 0x68, 0x19, 0xFD, 0x77, 0x70, 0x90, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_desktop_access_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 22, 23), Box(0, 0, 23, 23),
      ic_filled_24_communication_desktop_access_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_dialer_sip 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_24_communication_dialer_sip_data[] PROGMEM = {
  0x0B, 0xC0, 0x43, 0xB1, 0x91, 0xB0, 0xEC, 0x08, 0x39, 0x39, 0x19, 0x19, 0x0D, 0xC0, 0x93, 0xB1,
  0x91, 0xB0, 0xBC, 0x0C, 0x59, 0x19, 0x19, 0x20, 0x9D, 0x3B, 0x19, 0x19, 0x20, 0x5C, 0x0C, 0x76,
  0x0E, 0xA0, 0xC0, 0x17, 0x68, 0x2A, 0xFD, 0x17, 0x78, 0x23, 0xFE, 0x17, 0x71, 0x81, 0x9F, 0xA7,
  0x71, 0x82, 0x1E, 0xF7, 0x77, 0x10, 0x4A, 0x05, 0x77, 0x10, 0x7A, 0x07, 0x38, 0x51, 0xCF, 0xC9,
  0x84, 0x50, 0x7A, 0x82, 0xA1, 0x1C, 0xE6, 0x83, 0x4E, 0xFE, 0xDF, 0x70, 0x10, 0x9F, 0xA7, 0x28,
  0x12, 0xAE, 0xE7, 0x58, 0x45, 0x9B, 0xDE, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_dialer_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_dialer_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_dialpad 24x24, 4-bit Alpha,  RLE, 129 bytes.
static const unsigned char ic_filled_24_communication_dialpad_data[] PROGMEM = {
  0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x42, 0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20,
  0xDA, 0x00, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x83, 0xD4, 0xDD, 0x42, 0x82, 0x4D, 0xD4,
  0x28, 0x24, 0xDD, 0x47, 0x77, 0x74, 0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x42, 0x83, 0x4D, 0xD4,
  0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x00, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x83,
  0xD4, 0xDD, 0x42, 0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x47, 0x77, 0x74, 0x82, 0x4D, 0xD4, 0x28,
  0x24, 0xDD, 0x42, 0x83, 0x4D, 0xD4, 0xDA, 0x0D, 0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x00, 0xDA, 0x0D,
  0x20, 0xDA, 0x0D, 0x20, 0xDA, 0x83, 0xD4, 0xDD, 0x42, 0x82, 0x4D, 0xD4, 0x28, 0x24, 0xDD, 0x48,
  0x0C, 0x20, 0x82, 0x4D, 0xD4, 0x75, 0x0D, 0xA0, 0xD7, 0x50, 0xDA, 0x0D, 0x75, 0x82, 0x4D, 0xD4,
  0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_dialpad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_dialpad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_document_scanner 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_filled_24_communication_document_scanner_data[] PROGMEM = {
  0xD7, 0x3F, 0xB7, 0x3F, 0x77, 0x2C, 0x10, 0x40, 0xDF, 0xB0, 0xD0, 0x41, 0xC1, 0x0D, 0xFD, 0x0D,
  0x1A, 0x3F, 0xF6, 0xFF, 0x6C, 0x6C, 0x6C, 0x6C, 0x6F, 0xF6, 0xC6, 0xC6, 0xC6, 0xC6, 0xFF, 0x6C,
  0x6C, 0x6C, 0x6C, 0x6F, 0xF6, 0xFF, 0x3A, 0x10, 0xDF, 0xD0, 0xD1, 0xC1, 0x04, 0x0D, 0xFB, 0x0D,
  0x04, 0x1C, 0x77, 0x2F, 0x73, 0xFB, 0x73, 0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_document_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_document_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_domain_disabled 24x24, 4-bit Alpha,  RLE, 116 bytes.
static const unsigned char ic_filled_24_communication_domain_disabled_data[] PROGMEM = {
  0x81, 0x5D, 0x17, 0x76, 0x84, 0x7F, 0xD2, 0x06, 0xE7, 0x58, 0x47, 0xFD, 0x20, 0x6D, 0x76, 0xA8,
  0x2D, 0x20, 0x62, 0xA7, 0x6B, 0x0D, 0x02, 0x3A, 0x76, 0xC8, 0x2D, 0x20, 0x6F, 0xD3, 0xD8, 0x2D,
  0x20, 0x6F, 0xC3, 0xA2, 0xA8, 0x2D, 0x20, 0x67, 0x1A, 0x3A, 0x2B, 0x0D, 0x02, 0x72, 0xA3, 0xF9,
  0x0D, 0x02, 0x4A, 0x2A, 0x3F, 0xA0, 0xD0, 0x23, 0xA2, 0xA3, 0xA2, 0xA2, 0xA0, 0xD0, 0x26, 0xA3,
  0xA2, 0xA2, 0xB0, 0xD0, 0x25, 0xA3, 0xFD, 0x0E, 0x02, 0x4A, 0x3F, 0xE0, 0xE0, 0x23, 0xA3, 0xA2,
  0xA2, 0xA2, 0x82, 0x7F, 0xE2, 0x2A, 0x3A, 0x2A, 0x2A, 0x38, 0x47, 0xFE, 0x20, 0x69, 0x3F, 0xFA,
  0x82, 0xE2, 0x06, 0x3F, 0xFB, 0x0E, 0x02, 0x77, 0x68, 0x27, 0xFE, 0x27, 0x76, 0x82, 0x7F, 0xE1,
  0x77, 0x60, 0x07, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_domain_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 22, 23), Box(0, 0, 23, 23),
      ic_filled_24_communication_domain_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_domain_verification 24x24, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_filled_24_communication_domain_verification_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x80, 0xC2, 0xF7, 0x7C, 0x72, 0x01, 0x03, 0x3C,
  0x71, 0x82, 0x1C, 0xE3, 0x2C, 0x30, 0x23, 0x83, 0x1C, 0xFD, 0x12, 0xC2, 0x81, 0x2E, 0xA2, 0x82,
  0xCF, 0xD1, 0x3C, 0x28, 0x62, 0xEF, 0xBC, 0xFD, 0x14, 0xC3, 0x02, 0x0E, 0xA0, 0xD0, 0x15, 0xC4,
  0x82, 0x2E, 0xD1, 0x6C, 0x50, 0x20, 0x17, 0xC7, 0x7A, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0x0D,
  0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_domain_verification() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 20, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_domain_verification_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_duo 24x24, 4-bit Alpha,  RLE, 84 bytes.
static const unsigned char ic_filled_24_communication_duo_data[] PROGMEM = {
  0x68, 0x25, 0x9D, 0xEF, 0x90, 0xD0, 0x44, 0x04, 0x0D, 0xFE, 0x0D, 0x30, 0x7F, 0xFA, 0x20, 0x7F,
  0xFB, 0x10, 0x3F, 0xFC, 0x10, 0xCF, 0xFC, 0x04, 0xFF, 0xD0, 0x9C, 0x79, 0x0E, 0x05, 0xD0, 0xCC,
  0x70, 0xA0, 0x11, 0xD0, 0xEC, 0x73, 0xFB, 0x73, 0xC0, 0xE0, 0xDC, 0x70, 0xA0, 0x11, 0xC0, 0xD0,
  0xAC, 0x79, 0x0E, 0x05, 0xC0, 0x90, 0x5F, 0xFC, 0x81, 0x50, 0xDF, 0xFA, 0x0D, 0x20, 0x5F, 0xFA,
  0x04, 0x30, 0x9F, 0xF0, 0x75, 0x09, 0xFD, 0x07, 0x70, 0x50, 0xDF, 0x90, 0xC0, 0x47, 0x38, 0x65,
  0xAD, 0xFE, 0xC9, 0x46,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_duo() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_duo_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_email 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_24_communication_email_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xC2, 0x08,
  0xFB, 0x08, 0x2C, 0x83, 0xA1, 0x03, 0xCE, 0x83, 0xC3, 0x01, 0xAD, 0x0E, 0x06, 0x20, 0x60, 0xEA,
  0x0E, 0x06, 0x20, 0x60, 0xEF, 0x98, 0x90, 0xC3, 0x01, 0xAA, 0x10, 0x3C, 0xFD, 0x08, 0x40, 0x8F,
  0xF9, 0x82, 0xD4, 0x4D, 0x80, 0x9D, 0x0F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_email() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_email_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_forum 24x24, 4-bit Alpha,  RLE, 52 bytes.
static const unsigned char ic_filled_24_communication_forum_data[] PROGMEM = {
  0x0B, 0xFE, 0x0B, 0x5F, 0xF9, 0x5F, 0xF9, 0x5F, 0xF9, 0x5F, 0xF9, 0x2A, 0x0B, 0xFF, 0x92, 0xFF,
  0xC2, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF, 0xC2, 0xFF, 0xB0, 0xB2, 0xE0, 0x77, 0x6D, 0x07, 0x77, 0xC0,
  0x72, 0xFF, 0xA0, 0x73, 0xFF, 0xA4, 0x0B, 0xFF, 0x97, 0x72, 0x07, 0xB7, 0x73, 0x07, 0xA7, 0x74,
  0x07, 0x97, 0x75, 0x07,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_forum() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_forum_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_forward_to_inbox 24x24, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_filled_24_communication_forward_to_inbox_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x2D, 0x40, 0xDF, 0xFC, 0x0D, 0x1A, 0x0A, 0x01, 0x75, 0x01, 0x0A, 0xA1,
  0xB0, 0xE0, 0x67, 0x30, 0x60, 0xEB, 0x1A, 0x83, 0x4D, 0xFC, 0x36, 0x83, 0x3C, 0xFD, 0x4A, 0x1A,
  0x20, 0x8A, 0x08, 0x40, 0x8A, 0x08, 0x2A, 0x1A, 0x38, 0x90, 0x3C, 0xFD, 0x44, 0xDF, 0xC3, 0x3A,
  0x1A, 0x50, 0x60, 0xEA, 0x0E, 0x06, 0x5A, 0x1A, 0x68, 0x21, 0xAA, 0x16, 0xA1, 0xA7, 0x75, 0xA7,
  0x75, 0xA7, 0x71, 0x07, 0x3A, 0x77, 0x19, 0x07, 0x2A, 0x77, 0x1A, 0x81, 0x70, 0xDF, 0xB2, 0xF8,
  0x17, 0x4D, 0xFA, 0x2F, 0x07, 0x77, 0x3A, 0x07, 0x77, 0x49, 0x07, 0x77, 0x50, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_forward_to_inbox() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_forward_to_inbox_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_hourglass_bottom 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_filled_24_communication_hourglass_bottom_data[] PROGMEM = {
  0xFF, 0xFD, 0x71, 0xC7, 0x1C, 0x71, 0xC0, 0x16, 0x01, 0xA8, 0x27, 0xFD, 0x14, 0x87, 0x1D, 0xF7,
  0x07, 0xFD, 0x12, 0x82, 0x1D, 0xF7, 0x38, 0x67, 0xFD, 0x11, 0xDF, 0x75, 0x84, 0x7F, 0xDD, 0xF7,
  0x60, 0x7C, 0x07, 0x50, 0x7E, 0x07, 0x30, 0x7F, 0x98, 0x17, 0x07, 0xFB, 0x07, 0x80, 0x98, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_hourglass_bottom() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 17, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_hourglass_bottom_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_hourglass_top 24x24, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_filled_24_communication_hourglass_top_data[] PROGMEM = {
  0x80, 0x98, 0x4F, 0x07, 0xFB, 0x81, 0x70, 0x7F, 0x90, 0x73, 0x07, 0xE0, 0x75, 0x07, 0xC0, 0x76,
  0x84, 0x7F, 0xDD, 0xF7, 0x58, 0x67, 0xFD, 0x11, 0xDF, 0x73, 0x82, 0x7F, 0xD1, 0x28, 0x71, 0xDF,
  0x70, 0x7F, 0xD1, 0x48, 0x21, 0xDF, 0x7A, 0x01, 0x60, 0x1C, 0x71, 0xC7, 0x1C, 0x71, 0xFF, 0xFD,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_hourglass_top() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 2, 17, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_hourglass_top_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_hub 24x24, 4-bit Alpha,  RLE, 154 bytes.
static const unsigned char ic_filled_24_communication_hub_data[] PROGMEM = {
  0x73, 0x82, 0x8D, 0xD8, 0x77, 0x50, 0x8C, 0x08, 0x77, 0x40, 0xDC, 0x0D, 0x77, 0x40, 0xEC, 0x0E,
  0x77, 0x40, 0x8C, 0x08, 0x77, 0x58, 0x28, 0xEE, 0x87, 0x48, 0x21, 0x66, 0x16, 0x00, 0xB6, 0x85,
  0x16, 0x61, 0x03, 0xEA, 0x0E, 0x03, 0x50, 0x0B, 0x50, 0x30, 0xEA, 0x81, 0xE3, 0xBC, 0x0B, 0x30,
  0x30, 0xBA, 0x0A, 0x03, 0x30, 0xBC, 0x0B, 0x0E, 0xD8, 0x11, 0x05, 0xE8, 0x14, 0x01, 0xD0, 0xE0,
  0xBE, 0x0C, 0x0E, 0xE0, 0xE0, 0xCE, 0x81, 0xB3, 0xEA, 0x82, 0xE4, 0x6C, 0xF9, 0x82, 0xD7, 0x5E,
  0xA8, 0x5E, 0x30, 0x16, 0x61, 0x20, 0x7F, 0x90, 0x72, 0x82, 0x16, 0x61, 0x71, 0x05, 0xF9, 0x05,
  0x77, 0x10, 0xEE, 0x0E, 0x77, 0x20, 0x8E, 0x08, 0x77, 0x18, 0x90, 0x3E, 0xCA, 0xEE, 0xAB, 0xE3,
  0x74, 0x84, 0x8D, 0xDE, 0xD1, 0x48, 0x41, 0xDE, 0xDD, 0x87, 0x08, 0xC0, 0x96, 0x09, 0xC0, 0x86,
  0x0D, 0xC0, 0xE6, 0x0E, 0xC0, 0xD6, 0x0D, 0xC0, 0xD6, 0x0D, 0xC0, 0xD6, 0x08, 0xC0, 0x86, 0x08,
  0xC0, 0x87, 0x82, 0x8D, 0xD8, 0x71, 0x82, 0x8D, 0xD8, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 0, 23, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_import_contacts 24x24, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_filled_24_communication_import_contacts_data[] PROGMEM = {
  0x28, 0x51, 0x57, 0x75, 0x41, 0x48, 0x51, 0x57, 0x75, 0x41, 0x20, 0x40, 0xCF, 0x82, 0xC4, 0x4C,
  0xF0, 0xC0, 0x4F, 0xE8, 0x5E, 0xB9, 0x78, 0xAD, 0xFE, 0x0B, 0x04, 0x7F, 0xE7, 0x2F, 0xE7, 0x2F,
  0xE7, 0x2F, 0xE7, 0x2F, 0xE7, 0x2F, 0xE7, 0x2F, 0xE7, 0x2F, 0xE7, 0x2F, 0xE7, 0x2F, 0xE7, 0x2F,
  0xE1, 0x86, 0x38, 0xBE, 0xFE, 0xC9, 0xFE, 0x0B, 0xFC, 0x82, 0xC7, 0x31, 0x28, 0x12, 0x5A, 0xA8,
  0x91, 0xC7, 0x31, 0x01, 0x36, 0xBE, 0x17, 0x20, 0x03, 0x73,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_import_contacts() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 22, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_import_contacts_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_import_export 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_filled_24_communication_import_export_data[] PROGMEM = {
  0x30, 0x07, 0x74, 0x07, 0xA0, 0x77, 0x20, 0x7C, 0x07, 0x70, 0x7E, 0x07, 0x72, 0xA7, 0x5A, 0x75,
  0xA7, 0x5A, 0x4A, 0x6A, 0x4A, 0x6A, 0x4A, 0x6A, 0x4A, 0x75, 0xA7, 0x5A, 0x75, 0xA7, 0x20, 0x7E,
  0x07, 0x70, 0x7C, 0x07, 0x72, 0x07, 0xA0, 0x77, 0x40, 0x07, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_import_export() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 3, 18, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_import_export_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_invert_colors_off 24x24, 4-bit Alpha,  RLE, 138 bytes.
static const unsigned char ic_filled_24_communication_invert_colors_off_data[] PROGMEM = {
  0x73, 0x00, 0x77, 0x18, 0x11, 0xC7, 0x60, 0x8A, 0x08, 0x70, 0x4A, 0x07, 0x40, 0x8C, 0x08, 0x70,
  0x5A, 0x07, 0x20, 0x5A, 0x04, 0xB0, 0x87, 0x05, 0xA0, 0x72, 0x09, 0x04, 0x1C, 0x08, 0x70, 0x5A,
  0x07, 0x4D, 0x08, 0x70, 0x9A, 0x07, 0x3E, 0x06, 0x50, 0x10, 0xEB, 0x07, 0x20, 0xAD, 0x0E, 0x01,
  0x48, 0x28, 0xFA, 0x5A, 0x07, 0x20, 0xAD, 0x07, 0x48, 0x3C, 0xF4, 0x05, 0xA0, 0x72, 0x0A, 0xC0,
  0xC4, 0x81, 0xEF, 0x12, 0x05, 0xA0, 0x72, 0x0A, 0xB0, 0xE4, 0xA4, 0x05, 0xA0, 0x72, 0x0A, 0xA0,
  0xE4, 0x81, 0xDF, 0x34, 0x05, 0xA0, 0x72, 0x81, 0xAF, 0xD4, 0x81, 0x9F, 0x85, 0xB0, 0x72, 0x0A,
  0x09, 0x48, 0x23, 0xFE, 0x24, 0xC0, 0x72, 0x01, 0x58, 0x29, 0xFD, 0x23, 0xD0, 0x77, 0x10, 0xBA,
  0x08, 0x03, 0x1E, 0x07, 0x71, 0x09, 0xF9, 0x0A, 0xA0, 0x77, 0x18, 0x90, 0x28, 0xCE, 0xFC, 0x92,
  0x05, 0xA0, 0x77, 0x73, 0x81, 0x5F, 0xC7, 0x74, 0x04, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_invert_colors_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_invert_colors_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_key_off 24x24, 4-bit Alpha,  RLE, 118 bytes.
static const unsigned char ic_filled_24_communication_key_off_data[] PROGMEM = {
  0x81, 0x1C, 0x77, 0x75, 0x04, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x73,
  0x01, 0x0C, 0xB0, 0x77, 0x72, 0x0C, 0xD0, 0x77, 0x70, 0x6B, 0x07, 0x05, 0xA0, 0x77, 0x60, 0xBA,
  0x07, 0x20, 0x5A, 0x07, 0x20, 0xAF, 0x81, 0x70, 0xEA, 0x01, 0x30, 0x5A, 0x07, 0x20, 0xAF, 0x08,
  0x0E, 0xA0, 0x14, 0x05, 0xA0, 0x72, 0x0A, 0xE0, 0x70, 0xCA, 0x07, 0x40, 0x7B, 0x07, 0x20, 0xAC,
  0x81, 0x70, 0x6B, 0x82, 0x71, 0x17, 0xD0, 0x72, 0x07, 0xA0, 0x73, 0x0C, 0xF9, 0x0C, 0x05, 0xA0,
  0x72, 0x00, 0x74, 0x01, 0x0C, 0xE8, 0x2C, 0x10, 0x5A, 0x07, 0x72, 0x84, 0x6C, 0xEE, 0xC6, 0x40,
  0x5A, 0x07, 0x77, 0x50, 0x5A, 0x07, 0x77, 0x50, 0x5A, 0x07, 0x77, 0x50, 0x5A, 0x07, 0x77, 0x58,
  0x15, 0xFC, 0x77, 0x60, 0x40, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_key 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_24_communication_key_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEB, 0x57, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x75, 0x0C, 0xF9, 0x0C, 0x74, 0x06,
  0xB8, 0x27, 0x11, 0x7B, 0x05, 0x73, 0x0C, 0xA0, 0x74, 0x07, 0xFC, 0x81, 0x70, 0xEA, 0x01, 0x40,
  0x1F, 0xD0, 0x80, 0xEA, 0x01, 0x40, 0x1F, 0xD0, 0x70, 0xCA, 0x07, 0x40, 0x7F, 0xC8, 0x17, 0x06,
  0xB8, 0x27, 0x11, 0x7B, 0x05, 0x07, 0xA0, 0x07, 0xA0, 0x73, 0x0C, 0xF9, 0x0C, 0x20, 0x07, 0x20,
  0x07, 0x40, 0x10, 0xCE, 0x0C, 0x01, 0x77, 0x84, 0x6C, 0xEE, 0xB5, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 22, 17), Box(0, 0, 23, 23),
      ic_filled_24_communication_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_list_alt 24x24, 4-bit Alpha,  RLE, 40 bytes.
static const unsigned char ic_filled_24_communication_list_alt_data[] PROGMEM = {
  0x0B, 0xFF, 0xA0, 0xBF, 0xFE, 0x77, 0xC7, 0x7C, 0x2A, 0x2E, 0x2C, 0x2A, 0x2E, 0x2C, 0x77, 0xC7,
  0x7C, 0x2A, 0x2E, 0x2C, 0x2A, 0x2E, 0x2C, 0x77, 0xC7, 0x7C, 0x2A, 0x2E, 0x2C, 0x2A, 0x2E, 0x2C,
  0x77, 0xC7, 0x7F, 0xFE, 0x0B, 0xFF, 0xA0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_list_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_list_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_live_help 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_filled_24_communication_live_help_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0xE8, 0x4D, 0x51, 0x15, 0xDF, 0xC0, 0xD0, 0x14,
  0x01, 0x0D, 0xFB, 0x86, 0x50, 0x4D, 0xD4, 0x05, 0xFB, 0x81, 0x10, 0xDA, 0x81, 0xD0, 0x1F, 0xF9,
  0x81, 0xD0, 0x1F, 0xF9, 0x81, 0x40, 0x6F, 0xF8, 0x25, 0x03, 0xEF, 0xE8, 0x28, 0x02, 0xEF, 0xF8,
  0x12, 0x0B, 0xFF, 0x92, 0x0E, 0x80, 0xD7, 0xF2, 0xFF, 0xA2, 0xF9, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D,
  0xFF, 0x0D, 0x04, 0x60, 0x7C, 0x07, 0x76, 0x07, 0xA0, 0x77, 0x71, 0x00, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_live_help() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_live_help_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_location_off 24x24, 4-bit Alpha,  RLE, 121 bytes.
static const unsigned char ic_filled_24_communication_location_off_data[] PROGMEM = {
  0x68, 0x61, 0x7C, 0xEE, 0xC7, 0x14, 0x04, 0x0A, 0x30, 0x40, 0xEE, 0x0E, 0x05, 0x38, 0x1A, 0xFB,
  0x20, 0xAF, 0xA0, 0x53, 0x81, 0xBF, 0xB2, 0x0A, 0xF9, 0x0E, 0x01, 0x38, 0x1B, 0xFB, 0x28, 0x3A,
  0xE9, 0x9E, 0xC0, 0x74, 0x81, 0xDF, 0xB2, 0x01, 0x20, 0x20, 0xEB, 0x0C, 0x40, 0xEA, 0x0B, 0x50,
  0x9B, 0x0E, 0x40, 0xEB, 0x0B, 0x40, 0x9B, 0x0E, 0x40, 0xCC, 0x0B, 0x20, 0x10, 0xEB, 0x0C, 0x40,
  0x8D, 0x0B, 0x20, 0xAB, 0x08, 0x40, 0x2E, 0x0B, 0x20, 0xAA, 0x02, 0x50, 0xBE, 0x0B, 0x20, 0xA0,
  0xB6, 0x04, 0xF0, 0xB2, 0x02, 0x70, 0xBF, 0x0B, 0x72, 0x02, 0x0E, 0xF0, 0xB7, 0x20, 0x7E, 0x81,
  0xDF, 0xB7, 0x20, 0xBC, 0x83, 0xB0, 0xBF, 0xB7, 0x10, 0x10, 0xEA, 0x0E, 0x01, 0x28, 0x1B, 0xFA,
  0x71, 0x04, 0xA0, 0x44, 0x0A, 0x04, 0x72, 0x00, 0x67,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_location_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_location_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_location_on 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_filled_24_communication_location_on_data[] PROGMEM = {
  0x38, 0x61, 0x7C, 0xEE, 0xC7, 0x15, 0x05, 0x0E, 0xE0, 0xE0, 0x53, 0x05, 0xFB, 0x82, 0x50, 0x1E,
  0xFB, 0x81, 0xE1, 0x7C, 0x82, 0xE9, 0x9E, 0xC0, 0x70, 0xCB, 0x0E, 0x02, 0x20, 0x20, 0xEB, 0x0C,
  0x0E, 0xB0, 0x94, 0x09, 0xB0, 0x0E, 0xB0, 0x94, 0x09, 0xB0, 0xE0, 0xCB, 0x0E, 0x02, 0x20, 0x20,
  0xEB, 0x0C, 0x08, 0xC8, 0x2E, 0x99, 0xEC, 0x08, 0x02, 0xFD, 0x81, 0x20, 0xBF, 0xB0, 0xB2, 0x04,
  0xFB, 0x04, 0x30, 0xBF, 0x90, 0xB4, 0x02, 0x0E, 0xE0, 0xE0, 0x25, 0x07, 0xE0, 0x77, 0x0B, 0xC0,
  0xB7, 0x10, 0x10, 0xEA, 0x0E, 0x01, 0x72, 0x04, 0xA0, 0x47, 0x40, 0x06, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_location_on() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 2, 18, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_location_on_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_mail_lock 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_24_communication_mail_lock_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA0, 0xD0, 0x42, 0x0D, 0xFF, 0xC0, 0xD2, 0xA0, 0x40, 0xDF, 0xD0, 0xD0, 0x4A,
  0x2A, 0x20, 0x8F, 0xB0, 0x82, 0xA2, 0xA8, 0x3A, 0x10, 0x3C, 0xE8, 0x3C, 0x30, 0x1A, 0xA2, 0xB0,
  0xE0, 0x62, 0x06, 0x0E, 0xA0, 0xE0, 0x62, 0x06, 0x0E, 0xB2, 0xD8, 0x93, 0xC3, 0x01, 0xAA, 0x10,
  0x3C, 0xFA, 0x34, 0xF0, 0x84, 0x08, 0xA0, 0x66, 0xF9, 0x82, 0xD4, 0x4D, 0xA0, 0xA2, 0x82, 0x4D,
  0xD4, 0x1F, 0xF0, 0x32, 0x82, 0xD3, 0x3D, 0x1F, 0xF3, 0x92, 0x91, 0xFF, 0x20, 0xBC, 0x0B, 0xFF,
  0x2F, 0xFE, 0x2E, 0x0D, 0xFE, 0x2E, 0x04, 0x0D, 0xFD, 0x20, 0xBC, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_mail_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 23, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_mail_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_mail_outline 24x24, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_filled_24_communication_mail_outline_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xDA, 0x0A, 0x01, 0x75, 0x01, 0x0A, 0xD0, 0xE0,
  0x67, 0x30, 0x60, 0xED, 0x83, 0x4D, 0xFC, 0x36, 0x83, 0x3C, 0xFD, 0x4C, 0x20, 0x8A, 0x08, 0x40,
  0x8A, 0x08, 0x2C, 0x38, 0x90, 0x3C, 0xFD, 0x44, 0xDF, 0xC3, 0x3C, 0x50, 0x60, 0xEA, 0x0E, 0x06,
  0x5C, 0x68, 0x21, 0xAA, 0x16, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xC7, 0x72, 0xA0,
  0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_mail_outline() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_mail_outline_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_mark_chat_read 24x24, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_filled_24_communication_mark_chat_read_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x2D, 0x40, 0xDF, 0xFC, 0x0D, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F,
  0xFE, 0x1F, 0xFE, 0x1F, 0xFE, 0x1F, 0xE8, 0x1E, 0x72, 0x20, 0x20, 0x71, 0xFD, 0x0A, 0x71, 0xFC,
  0x0A, 0x72, 0xFB, 0x0E, 0x78, 0x11, 0xC3, 0xFB, 0x07, 0x68, 0x21, 0xDF, 0xBF, 0xB8, 0x22, 0x04,
  0x92, 0x82, 0x1D, 0xFC, 0x1F, 0xB2, 0x85, 0xEF, 0xA2, 0xDF, 0xC2, 0xFB, 0x20, 0x30, 0xEB, 0x0C,
  0x3B, 0x07, 0x72, 0x82, 0x3E, 0xFC, 0x4A, 0x07, 0x74, 0x03, 0x0B, 0x59, 0x07, 0x77, 0x50, 0x77,
  0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_mark_chat_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 22, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_mark_chat_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_mark_chat_unread 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_filled_24_communication_mark_chat_unread_data[] PROGMEM = {
  0x77, 0x18, 0x28, 0xDD, 0x87, 0x71, 0x08, 0xC8, 0x18, 0x4D, 0xFB, 0x20, 0xDC, 0x00, 0xDF, 0xC2,
  0x0D, 0xC0, 0xDF, 0xD8, 0x13, 0x08, 0xC0, 0x8F, 0xD0, 0xA2, 0x82, 0x8D, 0xD8, 0x1F, 0xE0, 0x76,
  0xFF, 0x84, 0xA3, 0x01, 0x4B, 0x80, 0xAD, 0x7F, 0x0D, 0xFF, 0xC0, 0xD0, 0x4B, 0x07, 0x77, 0x2A,
  0x07, 0x77, 0x39, 0x07, 0x77, 0x40, 0x77, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_mark_chat_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_mark_chat_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_mark_email_read 24x24, 4-bit Alpha,  RLE, 110 bytes.
static const unsigned char ic_filled_24_communication_mark_email_read_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x2D, 0x40, 0xDF, 0xFC, 0x0D, 0x1A, 0x04, 0x0D, 0xFD, 0x0D, 0x04, 0xA1,
  0xA2, 0x08, 0xFB, 0x08, 0x2A, 0x1A, 0x83, 0xA1, 0x03, 0xCE, 0x83, 0xC3, 0x01, 0xAA, 0x1B, 0x0E,
  0x06, 0x20, 0x60, 0xEA, 0x0E, 0x06, 0x20, 0x60, 0xEB, 0x1D, 0x89, 0x0C, 0x30, 0x1A, 0xA1, 0x03,
  0xCD, 0x1F, 0x08, 0x40, 0x8F, 0x1F, 0x98, 0x6D, 0x44, 0xDF, 0xE7, 0x22, 0x02, 0x07, 0x1F, 0xD0,
  0xA7, 0x1F, 0xC0, 0xA7, 0x2F, 0xB0, 0xE7, 0x81, 0x1C, 0x3F, 0xB0, 0x76, 0x82, 0x1D, 0xFB, 0xFB,
  0x82, 0x20, 0x49, 0x28, 0x41, 0xDF, 0xC0, 0xDF, 0xA2, 0x85, 0xEF, 0xA2, 0xDF, 0xC2, 0x04, 0x0D,
  0xF9, 0x20, 0x30, 0xEB, 0x0C, 0x77, 0x28, 0x23, 0xEF, 0xC7, 0x74, 0x03, 0x0B, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_mark_email_read() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 22, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_mark_email_read_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_mark_email_unread 24x24, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_filled_24_communication_mark_email_unread_data[] PROGMEM = {
  0x77, 0x18, 0x28, 0xDD, 0x87, 0x71, 0x08, 0xC8, 0x18, 0x4D, 0xFB, 0x20, 0xDC, 0x00, 0xDF, 0xC2,
  0x0D, 0xC0, 0xDA, 0x04, 0x0D, 0xF9, 0x81, 0x40, 0x8C, 0x08, 0xA2, 0x08, 0xF0, 0xB2, 0x82, 0x8D,
  0xD8, 0x1A, 0x83, 0xA1, 0x03, 0xCE, 0x05, 0x6B, 0x0E, 0x06, 0x20, 0x60, 0xEA, 0x0E, 0x06, 0x28,
  0x33, 0x11, 0x4B, 0xD8, 0x90, 0xC3, 0x01, 0xAA, 0x10, 0x3C, 0xFD, 0x08, 0x40, 0x8F, 0xF9, 0x82,
  0xD4, 0x4D, 0x80, 0x9D, 0x0F, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xA0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_mark_email_unread() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_mark_email_unread_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_mark_unread_chat_alt 24x24, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_filled_24_communication_mark_unread_chat_alt_data[] PROGMEM = {
  0x77, 0x18, 0x28, 0xDD, 0x87, 0x71, 0x08, 0xC8, 0x18, 0x4D, 0xFB, 0x20, 0xDC, 0x00, 0xDF, 0xC2,
  0x0D, 0xC0, 0xDF, 0xD8, 0x14, 0x08, 0xC0, 0x8F, 0xD0, 0xB2, 0x82, 0x8D, 0xD8, 0x1C, 0x77, 0x2C,
  0x76, 0x81, 0x14, 0xBF, 0xFF, 0xB7, 0x5F, 0x97, 0x5F, 0xFF, 0xF7, 0x1F, 0xD7, 0x18, 0x0F, 0x7F,
  0x0D, 0xFF, 0xC0, 0xD0, 0x4B, 0x07, 0x77, 0x2A, 0x07, 0x77, 0x39, 0x07, 0x77, 0x40, 0x77, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_mark_unread_chat_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_mark_unread_chat_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_message 24x24, 4-bit Alpha,  RLE, 43 bytes.
static const unsigned char ic_filled_24_communication_message_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0D, 0x0F, 0x75, 0xF9, 0x75, 0xFF, 0xFF,
  0x75, 0xF9, 0x75, 0xFF, 0xFF, 0x75, 0xF9, 0x75, 0x80, 0xF3, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0,
  0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_message() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_message_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_mobile_screen_share 24x24, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_filled_24_communication_mobile_screen_share_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C,
  0x50, 0x20, 0x53, 0xC5, 0x81, 0x5F, 0x62, 0xC3, 0x07, 0x0E, 0xB0, 0x71, 0xC2, 0x09, 0xD0, 0x61,
  0xC1, 0x85, 0x4E, 0x95, 0x6F, 0x52, 0xC1, 0x07, 0x01, 0x20, 0x20, 0x53, 0xC7, 0x3C, 0x73, 0xC7,
  0x3C, 0x73, 0xFF, 0xFF, 0xA0, 0xDF, 0xD8, 0x1D, 0x4D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_mobile_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_mobile_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_more_time 24x24, 4-bit Alpha,  RLE, 125 bytes.
static const unsigned char ic_filled_24_communication_more_time_data[] PROGMEM = {
  0x77, 0x2A, 0x77, 0x5A, 0x71, 0x84, 0x49, 0xDE, 0xEC, 0x5A, 0x60, 0x20, 0xBE, 0x2F, 0x92, 0x87,
  0x3E, 0xFE, 0x72, 0x01, 0x32, 0xF9, 0x18, 0x22, 0xEF, 0xA7, 0x4A, 0x48, 0x1B, 0xFA, 0x49, 0x07,
  0x6A, 0x38, 0x14, 0xFE, 0x59, 0x07, 0x6A, 0x38, 0x19, 0xF7, 0x59, 0x07, 0x74, 0x81, 0xDF, 0x25,
  0x90, 0x77, 0x40, 0xE9, 0x69, 0x07, 0x6A, 0x30, 0xE9, 0x69, 0x0B, 0x02, 0x59, 0x0E, 0x38, 0x1D,
  0xF2, 0x58, 0x24, 0xDF, 0x73, 0x81, 0x2F, 0xD3, 0x81, 0x9F, 0x77, 0x86, 0x8F, 0xD3, 0x07, 0xF9,
  0x38, 0x14, 0xFE, 0x71, 0x85, 0x2A, 0x10, 0xEF, 0x44, 0x81, 0xBF, 0xA7, 0x38, 0x1A, 0xFB, 0x58,
  0x22, 0xEF, 0xA7, 0x18, 0x2A, 0xFE, 0x26, 0x84, 0x3E, 0xFE, 0x72, 0x28, 0x42, 0x7E, 0xFE, 0x37,
  0x10, 0x20, 0xBF, 0x90, 0xB0, 0x27, 0x48, 0x64, 0x9D, 0xEE, 0xD9, 0x47, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_more_time() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 22, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_more_time_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_nat 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_filled_24_communication_nat_data[] PROGMEM = {
  0x48, 0x2E, 0xD9, 0x57, 0x74, 0xC0, 0xD0, 0x47, 0x73, 0x81, 0x26, 0xCA, 0x08, 0x77, 0x50, 0x6A,
  0x08, 0x77, 0x50, 0x4A, 0x04, 0x77, 0x58, 0x16, 0xFD, 0x77, 0x68, 0x1C, 0xF5, 0x72, 0x82, 0x8D,
  0xE8, 0x68, 0x16, 0xFA, 0x40, 0x93, 0x08, 0xC0, 0x85, 0x81, 0x2F, 0xD4, 0x98, 0x5C, 0x20, 0xDF,
  0x33, 0xE2, 0xF9, 0x84, 0xE5, 0xDF, 0x33, 0xE2, 0xF9, 0x81, 0xE5, 0x8C, 0x08, 0x58, 0x12, 0xFD,
  0x49, 0x0C, 0x02, 0x28, 0x28, 0xDE, 0x86, 0x81, 0x6F, 0xA4, 0x09, 0x77, 0x81, 0xCF, 0x57, 0x74,
  0x81, 0x6F, 0xD7, 0x74, 0x04, 0xA0, 0x47, 0x73, 0x06, 0xA0, 0x87, 0x71, 0x81, 0x26, 0xCA, 0x08,
  0x77, 0x1C, 0x0D, 0x04, 0x77, 0x28, 0x2E, 0xD9, 0x57, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_nat() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 22, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_nat_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_no_sim 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_24_communication_no_sim_data[] PROGMEM = {
  0x70, 0x7F, 0x0D, 0x04, 0x28, 0x11, 0xC4, 0x30, 0x7F, 0xA0, 0xD2, 0x04, 0xA8, 0x24, 0x01, 0xEF,
  0xB3, 0x04, 0xA8, 0x24, 0x03, 0xEF, 0xA4, 0x04, 0xA8, 0x24, 0x03, 0xEF, 0x95, 0xB8, 0x24, 0x03,
  0xEF, 0x5C, 0x82, 0x40, 0x3E, 0xE5, 0xD8, 0x24, 0x03, 0xED, 0x5E, 0x82, 0x40, 0x3E, 0xC5, 0xF8,
  0x24, 0x03, 0xEB, 0x5F, 0x98, 0x24, 0x03, 0xEA, 0x5F, 0xA8, 0x24, 0x03, 0xE9, 0x5F, 0xB8, 0x24,
  0x03, 0xE5, 0xFC, 0x81, 0x40, 0x35, 0xFD, 0x04, 0x6F, 0xE0, 0x45, 0x0D, 0xFE, 0x04, 0x40, 0x40,
  0xDF, 0xB0, 0xDA, 0x04, 0x77, 0x28, 0x14, 0xFC, 0x77, 0x30, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_no_sim() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_no_sim_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_pause_presentation 24x24, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_filled_24_communication_pause_presentation_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x6A,
  0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x6A, 0x2A,
  0x6C, 0x6A, 0x2A, 0x6C, 0x6A, 0x2A, 0x6C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4A, 0x0D, 0x98, 0x09,
  0x6D, 0x98, 0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_pause_presentation() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_pause_presentation_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_person_add_disabled 24x24, 4-bit Alpha,  RLE, 133 bytes.
static const unsigned char ic_filled_24_communication_person_add_disabled_data[] PROGMEM = {
  0x81, 0x6C, 0x17, 0x76, 0x82, 0x9F, 0xC1, 0x77, 0x68, 0x29, 0xFC, 0x17, 0x84, 0x1A, 0xDD, 0xA1,
  0x78, 0x29, 0xFC, 0x15, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x82, 0x9F, 0xC1, 0x40, 0xAE, 0x0A, 0x71,
  0xA0, 0xC0, 0x13, 0x0D, 0xE0, 0xD7, 0x1B, 0x0D, 0x01, 0x20, 0xDE, 0x0D, 0x71, 0xA8, 0x49, 0xFD,
  0x10, 0xAE, 0x0A, 0x5F, 0x98, 0x2D, 0x11, 0xEC, 0x0E, 0x01, 0x5F, 0xA8, 0x6D, 0x11, 0xAD, 0xDA,
  0x17, 0x2A, 0x38, 0x29, 0xFD, 0x17, 0x7A, 0x48, 0x29, 0xFD, 0x17, 0x6A, 0x48, 0x90, 0x3D, 0xFD,
  0x10, 0x5A, 0x71, 0x74, 0x03, 0x0C, 0xC8, 0x2D, 0x10, 0x7A, 0x0B, 0x03, 0x71, 0x04, 0xF8, 0x2D,
  0x10, 0x7B, 0x04, 0x70, 0xDF, 0x98, 0x2D, 0x10, 0x6A, 0x0D, 0x7F, 0xB8, 0x2D, 0x10, 0x6A, 0x7F,
  0xC8, 0x2D, 0x10, 0x69, 0x77, 0x38, 0x29, 0xFD, 0x17, 0x76, 0x82, 0x9F, 0xD1, 0x77, 0x68, 0x19,
  0xFD, 0x77, 0x70, 0x90, 0x61,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_person_add_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 22, 23), Box(0, 0, 23, 23),
      ic_filled_24_communication_person_add_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_person_search 24x24, 4-bit Alpha,  RLE, 105 bytes.
static const unsigned char ic_filled_24_communication_person_search_data[] PROGMEM = {
  0x58, 0x41, 0xAD, 0xDA, 0x17, 0x60, 0x10, 0xEC, 0x0E, 0x01, 0x75, 0x0A, 0xE0, 0xA7, 0x50, 0xDE,
  0x0D, 0x75, 0x0D, 0xE0, 0xD7, 0x50, 0xAE, 0x0A, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x68, 0x41,
  0xAD, 0xDA, 0x17, 0x76, 0x84, 0x1A, 0xDD, 0xA1, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x15, 0x89, 0x52,
  0x7A, 0xDE, 0x30, 0xAF, 0xB1, 0x1B, 0xFA, 0x30, 0x30, 0xBD, 0x28, 0x1D, 0xF1, 0x28, 0x11, 0xFD,
  0x20, 0x4F, 0x28, 0x1D, 0xF1, 0x28, 0x11, 0xFE, 0x20, 0xDF, 0x89, 0x03, 0x0A, 0xFB, 0x11, 0xBF,
  0xA2, 0xF9, 0x82, 0x80, 0x1E, 0xD0, 0xC0, 0x11, 0xFA, 0x89, 0x13, 0x01, 0xAD, 0xEA, 0xCF, 0xC1,
  0x77, 0x28, 0x21, 0xCF, 0xB7, 0x73, 0x81, 0x1B, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_person_search() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_person_search_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_phone_disabled 24x24, 4-bit Alpha,  RLE, 122 bytes.
static const unsigned char ic_filled_24_communication_phone_disabled_data[] PROGMEM = {
  0x81, 0x1C, 0x77, 0x40, 0x4C, 0x0B, 0x04, 0xA0, 0x77, 0x30, 0x8C, 0x81, 0xE0, 0x5A, 0x07, 0x72,
  0x09, 0xC0, 0xD2, 0x05, 0xA0, 0x77, 0x10, 0xCC, 0x0C, 0x30, 0x5A, 0x07, 0x7D, 0x09, 0x40, 0x5A,
  0x07, 0x60, 0xCC, 0x05, 0x50, 0x5A, 0x07, 0x50, 0x10, 0xCB, 0x01, 0x60, 0x5A, 0x07, 0x58, 0x21,
  0xDF, 0xA7, 0x10, 0x5A, 0x07, 0x48, 0x21, 0xEF, 0x37, 0x20, 0x5A, 0x07, 0x38, 0x1A, 0xFA, 0x74,
  0x05, 0xA0, 0x72, 0x81, 0xAE, 0x17, 0x50, 0x5A, 0x07, 0x20, 0x35, 0x85, 0x47, 0x9C, 0xFC, 0x12,
  0x05, 0xA0, 0x77, 0xE8, 0x2C, 0x11, 0xAB, 0x07, 0x6F, 0x83, 0xDE, 0xFE, 0x8A, 0x07, 0x5F, 0xA8,
  0x2A, 0x10, 0x5A, 0x07, 0x4F, 0x0A, 0x03, 0x40, 0x5A, 0x07, 0x38, 0x5B, 0xED, 0xB9, 0x51, 0x70,
  0x5A, 0x07, 0x77, 0x38, 0x15, 0xFC, 0x77, 0x40, 0x40, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_phone_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_phone_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_phone_enabled 24x24, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_filled_24_communication_phone_enabled_data[] PROGMEM = {
  0x75, 0x04, 0xC0, 0xB7, 0x50, 0x8C, 0x0E, 0x75, 0x09, 0xC0, 0xD7, 0x50, 0xCC, 0x0B, 0x75, 0xD0,
  0x97, 0x50, 0xCC, 0x05, 0x75, 0x01, 0x0C, 0xA0, 0xE7, 0x78, 0x21, 0xDF, 0xA7, 0x78, 0x21, 0xEF,
  0x37, 0x78, 0x1A, 0xF9, 0x77, 0x82, 0x7F, 0xE1, 0x76, 0x05, 0xA0, 0x43, 0x85, 0x47, 0x9C, 0xFC,
  0x13, 0x07, 0xA0, 0x74, 0xE8, 0x2C, 0x11, 0xAA, 0x07, 0x5F, 0x83, 0xDE, 0xFE, 0x46, 0xFA, 0x09,
  0x01, 0x7E, 0x81, 0xEA, 0x27, 0x28, 0x4B, 0xED, 0xB9, 0x57, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_phone_enabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_phone_enabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_phonelink_erase 24x24, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_filled_24_communication_phonelink_erase_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xB0, 0xD0, 0x44, 0x0D, 0xFD, 0x0D, 0x4F, 0xF4, 0xA7, 0x3A, 0x4A, 0x73, 0xA7,
  0x72, 0xA0, 0x04, 0x60, 0x04, 0x6A, 0x81, 0xAF, 0x44, 0x81, 0x4F, 0xA6, 0xA1, 0x81, 0xAF, 0x42,
  0x81, 0x4F, 0xA7, 0xA2, 0x84, 0xAF, 0x44, 0xFA, 0x71, 0xA3, 0x0A, 0xA0, 0xA7, 0x2A, 0x30, 0x5A,
  0x05, 0x72, 0xA2, 0x84, 0x4F, 0xAA, 0xF4, 0x71, 0xA1, 0x81, 0x4F, 0xA2, 0x81, 0xAF, 0x47, 0xA8,
  0x14, 0xFA, 0x48, 0x1A, 0xF4, 0x6A, 0x00, 0xA6, 0x00, 0xA6, 0xA7, 0x72, 0xA4, 0xA7, 0x3A, 0x4A,
  0x73, 0xA4, 0xFF, 0x40, 0xDF, 0xD0, 0xD4, 0x04, 0x0D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_phonelink_erase() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_phonelink_erase_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_phonelink_lock 24x24, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_filled_24_communication_phonelink_lock_data[] PROGMEM = {
  0x30, 0x40, 0xDF, 0xB0, 0xD0, 0x43, 0x0D, 0xFD, 0x0D, 0x3F, 0xF3, 0xA7, 0x3A, 0x3A, 0x73, 0xA7,
  0x71, 0xA2, 0x82, 0x8E, 0xE8, 0x72, 0xA1, 0x84, 0x7D, 0x44, 0xD7, 0x71, 0xA1, 0x0B, 0x08, 0x20,
  0x80, 0xB7, 0x1A, 0x10, 0xC0, 0x72, 0x07, 0x0C, 0x71, 0xA0, 0x9E, 0x09, 0x7F, 0xB7, 0xFB, 0x7F,
  0xB7, 0xFB, 0x7A, 0x09, 0xE0, 0x97, 0xA7, 0x71, 0xA3, 0xA7, 0x3A, 0x3A, 0x73, 0xA3, 0xFF, 0x30,
  0xDF, 0xD0, 0xD3, 0x04, 0x0D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_phonelink_lock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 20, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_phonelink_lock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_phonelink_ring 24x24, 4-bit Alpha,  RLE, 87 bytes.
static const unsigned char ic_filled_24_communication_phonelink_ring_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x60, 0xDF, 0xD0, 0xD6, 0xFF, 0x6A, 0x73, 0xA6, 0xA7, 0x3A, 0x6A,
  0x73, 0xA6, 0xA7, 0x3A, 0x40, 0x11, 0xA7, 0x3A, 0x30, 0x90, 0xB1, 0xA7, 0x3A, 0x38, 0x15, 0xF5,
  0xA7, 0x3A, 0x18, 0x3A, 0x60, 0xDB, 0xA7, 0x3A, 0x18, 0x3B, 0xC0, 0x9E, 0xA7, 0x3A, 0x18, 0x3B,
  0xC0, 0xAE, 0xA7, 0x3A, 0x18, 0x39, 0x60, 0xDB, 0xA7, 0x3A, 0x38, 0x15, 0xF5, 0xA7, 0x3A, 0x30,
  0x80, 0xA1, 0xA7, 0x3A, 0x6A, 0x73, 0xA6, 0xA7, 0x3A, 0x6A, 0x73, 0xA6, 0xFF, 0x60, 0xDF, 0xD0,
  0xD6, 0x04, 0x0D, 0xFB, 0x0D, 0x04, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_phonelink_ring() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 21, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_phonelink_ring_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_phonelink_setup 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_filled_24_communication_phonelink_setup_data[] PROGMEM = {
  0x40, 0x40, 0xDF, 0xB0, 0xD0, 0x44, 0x0D, 0xFD, 0x0D, 0x4F, 0xF4, 0xFF, 0x4A, 0x73, 0xA7, 0x72,
  0xA3, 0x04, 0xA0, 0x47, 0x2A, 0x18, 0x15, 0x19, 0xA8, 0x19, 0x15, 0x7A, 0x07, 0xF9, 0x06, 0x6A,
  0x0C, 0xA8, 0x2D, 0x55, 0xDA, 0x0C, 0x6A, 0x82, 0x1E, 0xF5, 0x28, 0x25, 0xFE, 0x16, 0xA8, 0x21,
  0xDF, 0x52, 0x82, 0x5F, 0xE1, 0x6A, 0x0C, 0xA8, 0x2D, 0x55, 0xDA, 0x0D, 0x6A, 0x06, 0xF9, 0x07,
  0x6A, 0x18, 0x15, 0x19, 0xA8, 0x19, 0x15, 0x7A, 0x30, 0x4A, 0x04, 0x72, 0xA7, 0x72, 0xA4, 0xA7,
  0x3A, 0x4F, 0xF4, 0xFF, 0x40, 0xDF, 0xD0, 0xD4, 0x04, 0x0D, 0xFB, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_phonelink_setup() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 1, 19, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_phonelink_setup_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_phone 24x24, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_filled_24_communication_phone_data[] PROGMEM = {
  0x0B, 0xC0, 0x47, 0x50, 0xEC, 0x08, 0x75, 0x0D, 0xC0, 0x97, 0x50, 0xBC, 0x0C, 0x75, 0x09, 0xD7,
  0x50, 0x5C, 0x0C, 0x76, 0x0E, 0xA0, 0xC0, 0x17, 0x68, 0x2A, 0xFD, 0x17, 0x78, 0x23, 0xFE, 0x17,
  0x71, 0x81, 0x9F, 0xA7, 0x71, 0x82, 0x1E, 0xF7, 0x77, 0x10, 0x4A, 0x05, 0x77, 0x10, 0x7A, 0x07,
  0x38, 0x51, 0xCF, 0xC9, 0x74, 0x50, 0x7A, 0x82, 0xA1, 0x1C, 0xE6, 0x83, 0x4E, 0xFE, 0xDF, 0x70,
  0x10, 0x9F, 0xA7, 0x28, 0x12, 0xAE, 0xE7, 0x58, 0x45, 0x9B, 0xDE, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_portable_wifi_off 24x24, 4-bit Alpha,  RLE, 177 bytes.
static const unsigned char ic_filled_24_communication_portable_wifi_off_data[] PROGMEM = {
  0x10, 0x34, 0x86, 0x5A, 0xDF, 0xED, 0x95, 0x68, 0x1A, 0xF4, 0x20, 0xCF, 0x90, 0xD0, 0x44, 0x04,
  0xA8, 0x91, 0x40, 0x3C, 0x72, 0x10, 0x26, 0xCA, 0x08, 0x40, 0x4A, 0x04, 0x72, 0x06, 0xA0, 0x83,
  0x04, 0xB0, 0x42, 0x83, 0xBE, 0xEC, 0x62, 0x04, 0xA0, 0x42, 0x81, 0xDF, 0x9A, 0x82, 0x40, 0x3E,
  0xB8, 0x92, 0xC1, 0x06, 0xFD, 0x05, 0xFC, 0x05, 0xA0, 0x42, 0x83, 0x15, 0xDF, 0xC2, 0x86, 0xCF,
  0x5A, 0xF6, 0x05, 0xB0, 0x43, 0x89, 0x51, 0xDF, 0x60, 0x6F, 0x9D, 0xF2, 0x0B, 0xF9, 0xA0, 0x43,
  0x86, 0x5F, 0xC0, 0x2F, 0xDE, 0x92, 0x82, 0xEF, 0x14, 0xA0, 0x42, 0x81, 0x1F, 0xE2, 0x98, 0x90,
  0xEE, 0xF1, 0x0E, 0xF1, 0x0D, 0xA0, 0x42, 0x89, 0x6E, 0xE0, 0x1F, 0xEC, 0xF3, 0x0B, 0xF5, 0x04,
  0xDA, 0x89, 0x64, 0x03, 0xB0, 0x3F, 0xDA, 0xF6, 0x06, 0xFD, 0x12, 0x04, 0xA0, 0x43, 0x84, 0x7F,
  0xA4, 0xFD, 0x28, 0x1C, 0xFC, 0x30, 0x4A, 0x04, 0x28, 0x91, 0xCF, 0x50, 0xDF, 0x70, 0x1C, 0x64,
  0x04, 0xA8, 0x24, 0x03, 0xC2, 0x04, 0xA0, 0x47, 0x10, 0x4A, 0x04, 0x50, 0x7A, 0x07, 0x71, 0x04,
  0xA0, 0x45, 0x81, 0x7F, 0xA7, 0x20, 0x4A, 0x04, 0x50, 0x40, 0x17, 0x38, 0x14, 0xFA, 0x77, 0x40,
  0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_portable_wifi_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_portable_wifi_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_present_to_all 24x24, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_filled_24_communication_present_to_all_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDA, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4C, 0x71,
  0x00, 0x77, 0x1C, 0x70, 0x7A, 0x07, 0x7C, 0x60, 0x7C, 0x07, 0x6C, 0x50, 0x7E, 0x07, 0x5C, 0x7C,
  0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x77, 0x4C, 0x77, 0x4C, 0x77, 0x4A, 0x0D, 0xFF, 0xE8,
  0x1D, 0x4D, 0xFF, 0xC0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_present_to_all() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_present_to_all_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_print_disabled 24x24, 4-bit Alpha,  RLE, 119 bytes.
static const unsigned char ic_filled_24_communication_print_disabled_data[] PROGMEM = {
  0x81, 0x7C, 0x17, 0x75, 0x82, 0x7F, 0xC1, 0x2F, 0xD5, 0x84, 0x8F, 0xC1, 0x09, 0xFC, 0x68, 0x48,
  0xFC, 0x10, 0x8F, 0xB7, 0x84, 0x8F, 0xC1, 0x08, 0xFA, 0x71, 0x82, 0x9F, 0xC1, 0x77, 0x30, 0x70,
  0xDA, 0x82, 0xD1, 0x07, 0xF9, 0x0E, 0x08, 0x30, 0x8D, 0x82, 0xD1, 0x07, 0xFA, 0x08, 0x20, 0xDE,
  0x82, 0xD1, 0x07, 0xD8, 0x23, 0x3F, 0xD2, 0xF9, 0x82, 0xD1, 0x07, 0xC0, 0x03, 0xA2, 0xFA, 0x82,
  0xD1, 0x06, 0xF2, 0xFB, 0x82, 0xD1, 0x06, 0xE2, 0xE3, 0x84, 0x9F, 0xD1, 0x06, 0xD2, 0xE4, 0x84,
  0x9F, 0xD1, 0x06, 0xC2, 0xE5, 0x84, 0x9F, 0xD1, 0x06, 0xB6, 0xA6, 0x82, 0x9F, 0xD1, 0x73, 0xA7,
  0x82, 0x9F, 0xD1, 0x72, 0xFD, 0x0D, 0x01, 0x71, 0xFE, 0x0D, 0x01, 0x77, 0x58, 0x29, 0xFD, 0x17,
  0x75, 0x81, 0x9F, 0xD7, 0x76, 0x09, 0x06,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_print_disabled() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 21, 23), Box(0, 0, 23, 23),
      ic_filled_24_communication_print_disabled_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_qr_code_2 24x24, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_filled_24_communication_qr_code_2_data[] PROGMEM = {
  0xE3, 0xA1, 0xF8, 0x2B, 0x77, 0xB9, 0x3A, 0x19, 0x82, 0xB7, 0x7B, 0xA8, 0x27, 0x88, 0x79, 0x1A,
  0x39, 0x82, 0x78, 0x87, 0xA8, 0x27, 0x88, 0x79, 0x1A, 0x39, 0x82, 0x78, 0x87, 0xA8, 0x2B, 0x77,
  0xB9, 0x1C, 0x19, 0x82, 0xB7, 0x7B, 0xF1, 0xC1, 0xE7, 0x74, 0xA2, 0xE4, 0xA2, 0xA2, 0xE4, 0xA4,
  0xA2, 0xA2, 0xC2, 0xA2, 0xA2, 0xA2, 0xC2, 0xA7, 0x1A, 0x6F, 0x92, 0xA6, 0xB8, 0x2B, 0x77, 0xB9,
  0x2A, 0x2C, 0x29, 0x82, 0x78, 0x87, 0x92, 0xA2, 0xC2, 0x98, 0x27, 0x88, 0x79, 0x2A, 0x4A, 0x29,
  0x82, 0xB7, 0x7B, 0x94, 0xA2, 0xFB, 0x4A, 0x2C,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_qr_code_2() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_qr_code_2_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_qr_code 24x24, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_filled_24_communication_qr_code_data[] PROGMEM = {
  0xF9, 0x2F, 0xFA, 0x2F, 0xB4, 0xA2, 0xA4, 0xC4, 0xA2, 0xA4, 0xC4, 0xA2, 0xA4, 0xC4, 0xA2, 0xA4,
  0xFB, 0x2F, 0xFA, 0x2F, 0x98, 0x0C, 0x00, 0xF9, 0x2A, 0x2A, 0x2F, 0x92, 0xA2, 0xA2, 0xA4, 0xA4,
  0xA2, 0xC4, 0xA4, 0xA2, 0xC4, 0xA2, 0xA2, 0xA2, 0xA4, 0xA2, 0xA2, 0xA2, 0xF9, 0x4A, 0x2F, 0xB4,
  0xA2, 0xA0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_qr_code() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_qr_code_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_qr_code_scanner 24x24, 4-bit Alpha,  RLE, 97 bytes.
static const unsigned char ic_filled_24_communication_qr_code_scanner_data[] PROGMEM = {
  0xD7, 0x3F, 0xB7, 0x3F, 0x77, 0x2C, 0x1E, 0x2E, 0x1C, 0x19, 0x82, 0xB7, 0x7B, 0x92, 0x98, 0x2B,
  0x77, 0xB9, 0x1A, 0x39, 0x07, 0x20, 0x79, 0x29, 0x07, 0x20, 0x79, 0x69, 0x07, 0x20, 0x79, 0x29,
  0x07, 0x20, 0x79, 0x69, 0x82, 0xB7, 0x7B, 0x92, 0x98, 0x2B, 0x77, 0xB9, 0x6E, 0x2E, 0x80, 0xD2,
  0x0E, 0x29, 0x82, 0x70, 0xF7, 0x79, 0x82, 0xB7, 0x7B, 0x92, 0x80, 0x27, 0x69, 0x07, 0x20, 0x79,
  0x38, 0x27, 0xF0, 0x79, 0x69, 0x07, 0x20, 0x79, 0x29, 0x82, 0x70, 0xF7, 0x4A, 0x19, 0x82, 0xB7,
  0x7B, 0x92, 0x80, 0x27, 0x1C, 0x1E, 0x38, 0x27, 0xF0, 0x79, 0x1C, 0x77, 0x2F, 0x73, 0xFB, 0x73,
  0xD0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_qr_code_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_qr_code_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_read_more 24x24, 4-bit Alpha,  RLE, 31 bytes.
static const unsigned char ic_filled_24_communication_read_more_data[] PROGMEM = {
  0x60, 0x74, 0xFA, 0x69, 0x07, 0x3F, 0xA6, 0xA0, 0x77, 0x73, 0xB0, 0x77, 0x3F, 0xB0, 0x73, 0xFF,
  0xA0, 0x73, 0xE6, 0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x90, 0x73, 0xFA, 0x60, 0x74, 0xFA,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_read_more() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 7, 21, 16), Box(0, 0, 23, 23),
      ic_filled_24_communication_read_more_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_ring_volume 24x24, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_filled_24_communication_ring_volume_data[] PROGMEM = {
  0x74, 0xA7, 0x77, 0x1A, 0x77, 0x71, 0xA7, 0x78, 0x16, 0xC1, 0x5A, 0x58, 0x11, 0xC6, 0x68, 0x2C,
  0xFC, 0x14, 0xA4, 0x82, 0x1C, 0xFC, 0x68, 0x31, 0xCF, 0xC1, 0x71, 0x83, 0x1C, 0xFC, 0x17, 0x82,
  0x1C, 0xF8, 0x71, 0x82, 0x8F, 0xC1, 0x72, 0x01, 0x08, 0x73, 0x08, 0x01, 0x80, 0xF0, 0x08, 0x90,
  0x59, 0xBD, 0xEE, 0xDB, 0x95, 0x74, 0x02, 0x0A, 0xFD, 0x0A, 0x02, 0x60, 0x10, 0xAB, 0x82, 0xC7,
  0x31, 0x28, 0x21, 0x37, 0xCB, 0x0A, 0x01, 0x30, 0x40, 0xEC, 0x06, 0x71, 0x06, 0xC8, 0x2E, 0x40,
  0x7E, 0x06, 0x71, 0x06, 0xE0, 0x70, 0xEE, 0x06, 0x71, 0x06, 0xE0, 0xE0, 0x4D, 0x0D, 0x02, 0x71,
  0x02, 0x0D, 0xD8, 0x14, 0x04, 0xB0, 0x87, 0x50, 0x8B, 0x04, 0x38, 0x14, 0xC4, 0x77, 0x81, 0x4C,
  0x42,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_ring_volume() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 23, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_ring_volume_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_rss_feed 24x24, 4-bit Alpha,  RLE, 100 bytes.
static const unsigned char ic_filled_24_communication_rss_feed_data[] PROGMEM = {
  0x82, 0x76, 0x42, 0x75, 0xC8, 0x1C, 0x71, 0x72, 0xF0, 0x80, 0x17, 0x82, 0x56, 0x8C, 0xC0, 0xE0,
  0x37, 0x30, 0x10, 0x8C, 0x06, 0x74, 0x02, 0x0B, 0xB0, 0x64, 0x82, 0xDB, 0x83, 0x40, 0x9B, 0x03,
  0x3C, 0x0B, 0x03, 0x30, 0x9A, 0x0E, 0x01, 0x2E, 0x06, 0x30, 0xBA, 0x08, 0x38, 0x11, 0x6D, 0xB0,
  0x62, 0x02, 0xB0, 0x15, 0x09, 0xB0, 0x32, 0x08, 0xA0, 0x72, 0x03, 0x04, 0x20, 0x9A, 0x0B, 0x20,
  0x2A, 0x81, 0xC0, 0x7A, 0x0C, 0x20, 0xDA, 0x03, 0x20, 0xCA, 0x01, 0x0E, 0xB8, 0x14, 0x06, 0xA0,
  0x82, 0x08, 0xA0, 0x40, 0xCB, 0x81, 0x30, 0x1A, 0x0B, 0x20, 0x6A, 0x83, 0x63, 0xCE, 0x73, 0xA0,
  0xD2, 0x04, 0xA0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_rss_feed() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 19, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_rss_feed_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_rtt 24x24, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_filled_24_communication_rtt_data[] PROGMEM = {
  0x7F, 0xD0, 0xE6, 0x03, 0xFD, 0x81, 0xB0, 0x1B, 0x0E, 0x05, 0xA8, 0x1A, 0x9A, 0xA8, 0x1B, 0x9A,
  0xA8, 0x19, 0x03, 0xB0, 0xB0, 0x8A, 0x81, 0x10, 0x5A, 0x81, 0x30, 0x2A, 0x07, 0x68, 0x1A, 0xFE,
  0x20, 0x7A, 0x81, 0x10, 0x5A, 0x04, 0x68, 0x1C, 0xFC, 0x28, 0x19, 0xFE, 0x20, 0x7A, 0x81, 0x20,
  0xAB, 0x05, 0xA0, 0x92, 0x81, 0xCF, 0xB2, 0x0A, 0xA2, 0x0D, 0xB0, 0x20, 0xF1, 0x28, 0x1E, 0xF9,
  0x20, 0xF1, 0x74, 0x01, 0xA0, 0x77, 0x72, 0x04, 0xA0, 0x46, 0x02, 0xD0, 0xD3, 0x06, 0xA0, 0x26,
  0x04, 0xD0, 0xA3, 0x09, 0xA7, 0x73, 0x81, 0xBF, 0xC7, 0x73, 0x81, 0xDF, 0xA7, 0x0B, 0xD0, 0x33,
  0xA0, 0x87, 0x0E, 0xD8, 0x21, 0x59, 0xAA, 0x81, 0xC9, 0x67, 0x50, 0xAE, 0x08, 0x75, 0x0D, 0xE0,
  0x65,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_rtt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 21, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_rtt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_screen_share 24x24, 4-bit Alpha,  RLE, 66 bytes.
static const unsigned char ic_filled_24_communication_screen_share_data[] PROGMEM = {
  0x20, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x40, 0xDF, 0xFC, 0x0D, 0x4F, 0xFE, 0x4F, 0xC0, 0x7F, 0x94,
  0xFC, 0x10, 0x6F, 0x4F, 0x98, 0x1D, 0x73, 0x20, 0x5E, 0x4F, 0x09, 0x60, 0x5D, 0x4E, 0x09, 0x70,
  0xBD, 0x4D, 0x87, 0xD0, 0x15, 0x9A, 0x01, 0xCE, 0x4D, 0x81, 0x76, 0xEB, 0x01, 0x0D, 0xF4, 0xD0,
  0xAD, 0x0D, 0xF9, 0x4F, 0xFE, 0x40, 0xDF, 0xFC, 0x0D, 0x40, 0x40, 0xDF, 0xFA, 0x0D, 0x04, 0x28,
  0x0D, 0x4F,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 23, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_send_time_extension 24x24, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_filled_24_communication_send_time_extension_data[] PROGMEM = {
  0x78, 0x13, 0x73, 0x77, 0x20, 0x6B, 0x06, 0x77, 0x10, 0xDB, 0x0D, 0x72, 0x04, 0x0D, 0xFE, 0x0D,
  0x04, 0x30, 0xDF, 0xF9, 0x0D, 0x3F, 0xFB, 0x3F, 0xFB, 0x3F, 0x90, 0xEF, 0x93, 0x0D, 0xF8, 0x11,
  0x7E, 0xE4, 0x02, 0x0C, 0xD2, 0x81, 0x17, 0xEC, 0x50, 0x3D, 0x48, 0x11, 0x7E, 0xA6, 0xD2, 0x0B,
  0x03, 0x28, 0x11, 0x7E, 0x50, 0x3D, 0x2A, 0x0B, 0x03, 0x20, 0x14, 0x02, 0x0C, 0xD2, 0xC0, 0xB0,
  0x34, 0x0D, 0xF2, 0xE0, 0xB0, 0x32, 0xF9, 0x28, 0x21, 0x59, 0xDC, 0x0B, 0x03, 0xF9, 0x28, 0x21,
  0x59, 0xDC, 0x0B, 0x03, 0xE0, 0xC0, 0x32, 0xE0, 0xB0, 0x32, 0x0D, 0xD0, 0x23, 0xC0, 0xB0, 0x34,
  0x04, 0x0D, 0xB0, 0xD4, 0xA0, 0xB0, 0x37, 0x72, 0x0B, 0x03, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_send_time_extension() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 22, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_send_time_extension_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_sentiment_satisfied_alt 24x24, 4-bit Alpha,  RLE, 151 bytes.
static const unsigned char ic_filled_24_communication_sentiment_satisfied_alt_data[] PROGMEM = {
  0x68, 0x65, 0x9D, 0xEE, 0xD9, 0x57, 0x30, 0x50, 0xDF, 0x90, 0xD0, 0x47, 0x08, 0xA8, 0x1C, 0x62,
  0x28, 0x12, 0x6C, 0xA0, 0x85, 0x08, 0xA0, 0x67, 0x10, 0x6A, 0x08, 0x30, 0x4A, 0x04, 0x73, 0x04,
  0xA0, 0x42, 0x81, 0xDF, 0x67, 0x58, 0x56, 0xFD, 0x05, 0xFC, 0x28, 0x1B, 0xFB, 0x48, 0x1B, 0xFB,
  0x28, 0x4C, 0xF5, 0xAF, 0x62, 0xB4, 0xB2, 0x84, 0x6F, 0x9D, 0xF2, 0x28, 0x1B, 0xFB, 0x48, 0x1B,
  0xFB, 0x28, 0x22, 0xFD, 0xE9, 0x77, 0x29, 0x00, 0xE9, 0x77, 0x29, 0x82, 0xED, 0xF2, 0x77, 0x84,
  0x2F, 0xDA, 0xF6, 0x28, 0x1C, 0xD1, 0x48, 0x11, 0xDC, 0x28, 0x46, 0xF9, 0x5F, 0xC2, 0x89, 0x03,
  0xED, 0x51, 0x15, 0xDE, 0x32, 0x85, 0xCF, 0x50, 0xDF, 0x62, 0x03, 0x0C, 0xC0, 0xC0, 0x32, 0x81,
  0x6F, 0xD2, 0x04, 0xA0, 0x43, 0x82, 0x36, 0x63, 0x30, 0x4A, 0x04, 0x30, 0x8A, 0x06, 0x71, 0x06,
  0xA0, 0x85, 0x08, 0xA8, 0x1C, 0x62, 0x28, 0x12, 0x6C, 0xA0, 0x87, 0x05, 0x0D, 0xF9, 0x0D, 0x04,
  0x73, 0x86, 0x59, 0xDE, 0xED, 0x95, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_sentiment_satisfied_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_sentiment_satisfied_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_sip 24x24, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_filled_24_communication_sip_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x0F, 0x3F, 0x03, 0x49, 0x29, 0x40, 0x3E,
  0x10, 0x30, 0xF7, 0x92, 0x91, 0x81, 0x37, 0x31, 0xE1, 0x82, 0x13, 0x37, 0x92, 0x91, 0x81, 0x37,
  0x31, 0xE8, 0x27, 0x33, 0x11, 0x92, 0x94, 0x03, 0xE0, 0xF7, 0x03, 0x19, 0x29, 0x10, 0x7F, 0xA4,
  0x03, 0x92, 0x91, 0x07, 0x80, 0xF6, 0xF0, 0xDF, 0xFC, 0x81, 0xD4, 0xDF, 0xFA, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_sip() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_sip_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_speaker_phone 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_24_communication_speaker_phone_data[] PROGMEM = {
  0x38, 0x90, 0x15, 0xAD, 0xEE, 0xDA, 0x51, 0x50, 0x70, 0xEF, 0x90, 0xE0, 0x72, 0x01, 0x0C, 0xA8,
  0x1B, 0x62, 0x28, 0x12, 0x6B, 0xA8, 0x4C, 0x16, 0xFD, 0x37, 0x18, 0xA1, 0x3D, 0xF6, 0x05, 0x10,
  0x17, 0xCE, 0xEC, 0x71, 0x01, 0x54, 0x05, 0x0E, 0xE0, 0xE0, 0x56, 0x89, 0x08, 0xFB, 0x41, 0x14,
  0xBF, 0x87, 0x04, 0x60, 0x47, 0x77, 0x30, 0xAE, 0x0A, 0x71, 0xF9, 0x71, 0x96, 0x97, 0x19, 0x69,
  0x71, 0x96, 0x97, 0x19, 0x69, 0x71, 0x96, 0x97, 0x19, 0x69, 0x71, 0x96, 0x97, 0x19, 0x69, 0x71,
  0xF9, 0x71, 0x0A, 0xE0, 0xA4,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_speaker_phone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 1, 19, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_speaker_phone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_spoke 24x24, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_filled_24_communication_spoke_data[] PROGMEM = {
  0x68, 0x41, 0xAD, 0xDA, 0x17, 0x40, 0x10, 0xEC, 0x0E, 0x01, 0x73, 0x0A, 0xE0, 0xA7, 0x30, 0xDE,
  0x0D, 0x73, 0x0D, 0xE0, 0xD7, 0x30, 0xAE, 0x0A, 0x73, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x48, 0x41,
  0xAD, 0xDA, 0x18, 0x0C, 0x70, 0x84, 0x1A, 0xDD, 0xA1, 0x48, 0x71, 0xAD, 0xDA, 0x10, 0x1E, 0xC0,
  0xE0, 0x12, 0x01, 0x0E, 0xC8, 0x1E, 0x1A, 0xE0, 0xA2, 0x0A, 0xE0, 0xA0, 0xDE, 0x0D, 0x20, 0xDE,
  0x00, 0xDE, 0x0D, 0x20, 0xDE, 0x0D, 0x0A, 0xE0, 0xA2, 0x0A, 0xE8, 0x1A, 0x1E, 0xC0, 0xE0, 0x12,
  0x01, 0x0E, 0xC8, 0x7E, 0x10, 0x1A, 0xDD, 0xA1, 0x48, 0x41, 0xAD, 0xDA, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_spoke() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 20, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_spoke_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_stay_current_landscape 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_filled_24_communication_stay_current_landscape_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDC, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77,
  0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xC0, 0xDF, 0xFE, 0x81,
  0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_stay_current_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_filled_24_communication_stay_current_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_stay_current_portrait 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_filled_24_communication_stay_current_portrait_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C,
  0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3F, 0xFF,
  0xFA, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_stay_current_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_stay_current_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_stay_primary_landscape 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_filled_24_communication_stay_primary_landscape_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xC8, 0x1D, 0x4D, 0xFF, 0xE0, 0xDC, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77,
  0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xF9, 0x77, 0xC0, 0xDF, 0xFE, 0x81,
  0xD4, 0xDF, 0xFC, 0x0D, 0x04,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_stay_primary_landscape() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 5, 22, 18), Box(0, 0, 23, 23),
      ic_filled_24_communication_stay_primary_landscape_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_stay_primary_portrait 24x24, 4-bit Alpha,  RLE, 41 bytes.
static const unsigned char ic_filled_24_communication_stay_primary_portrait_data[] PROGMEM = {
  0x04, 0x0D, 0xFB, 0x81, 0xD4, 0xDF, 0xD0, 0xDF, 0xFF, 0xFA, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C,
  0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3C, 0x73, 0xC7, 0x3F, 0xFF,
  0xFA, 0x0D, 0xFD, 0x81, 0xD4, 0xDF, 0xB0, 0xD0, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_stay_primary_portrait() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(5, 1, 18, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_stay_primary_portrait_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_stop_screen_share 24x24, 4-bit Alpha,  RLE, 124 bytes.
static const unsigned char ic_filled_24_communication_stop_screen_share_data[] PROGMEM = {
  0x20, 0x17, 0x77, 0x18, 0x16, 0xE3, 0x77, 0x78, 0x26, 0xFE, 0x37, 0x77, 0x84, 0x8F, 0xE3, 0x04,
  0xFD, 0x0D, 0x04, 0x40, 0xDA, 0x82, 0xE3, 0x04, 0xFD, 0x0D, 0x4C, 0x82, 0xE3, 0x04, 0xFD, 0x4D,
  0x82, 0xE3, 0x04, 0xA0, 0x7F, 0x94, 0xE8, 0x5E, 0x30, 0x4F, 0x06, 0xF4, 0xF8, 0x2E, 0x30, 0x22,
  0x05, 0xE4, 0xF9, 0x0E, 0x03, 0x40, 0x5D, 0x4E, 0x83, 0x96, 0xFE, 0x33, 0x0B, 0xD4, 0xD8, 0x7D,
  0x01, 0xBF, 0xE3, 0x04, 0xE4, 0xD8, 0x17, 0x6E, 0xB8, 0x2E, 0x30, 0x4D, 0x4D, 0x0B, 0xE8, 0x2E,
  0x30, 0x4C, 0x4F, 0xE8, 0x2E, 0x30, 0x4B, 0x40, 0xDF, 0xE8, 0x4E, 0x30, 0x4F, 0xD4, 0x04, 0x0E,
  0xFE, 0x83, 0xE3, 0x04, 0x42, 0xFF, 0xC8, 0x2E, 0x30, 0x4F, 0xFF, 0x82, 0xE3, 0x04, 0x97, 0x74,
  0x82, 0x6F, 0xE3, 0x77, 0x78, 0x16, 0xFD, 0x77, 0x71, 0x05, 0x02, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_stop_screen_share() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 23, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_stop_screen_share_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_swap_calls 24x24, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_filled_24_communication_swap_calls_data[] PROGMEM = {
  0x48, 0x41, 0xAD, 0xDA, 0x15, 0x00, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x13, 0x07, 0xA0, 0x75, 0x86,
  0xAF, 0xB1, 0x1B, 0xFA, 0x20, 0x7C, 0x07, 0x48, 0x1D, 0xF1, 0x28, 0x31, 0xFD, 0x07, 0xE0, 0x73,
  0xA4, 0xA4, 0xA6, 0xA4, 0xA4, 0xA6, 0xA4, 0xA4, 0xA6, 0xA4, 0xA4, 0xA6, 0xA4, 0xA4, 0xA6, 0xA4,
  0xA4, 0xA6, 0xA4, 0xA4, 0xA3, 0x07, 0xE8, 0x37, 0x0D, 0xF1, 0x28, 0x11, 0xFD, 0x40, 0x7C, 0x07,
  0x28, 0x6A, 0xFB, 0x11, 0xBF, 0xA5, 0x07, 0xA0, 0x73, 0x01, 0x0E, 0xC0, 0xE0, 0x16, 0x00, 0x75,
  0x84, 0x1A, 0xDD, 0xA1, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_swap_calls() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 21, 18), Box(0, 0, 23, 23),
      ic_filled_24_communication_swap_calls_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_textsms 24x24, 4-bit Alpha,  RLE, 37 bytes.
static const unsigned char ic_filled_24_communication_textsms_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0xA8, 0x1D, 0x4D, 0xFF, 0xC0, 0xD8, 0x09, 0xC5, 0xF2, 0xA2, 0xA2, 0xFB, 0x2A,
  0x2A, 0x28, 0x09, 0xF0, 0xF0, 0xDF, 0xFC, 0x0D, 0x04, 0xB0, 0x77, 0x72, 0xA0, 0x77, 0x73, 0x90,
  0x77, 0x74, 0x07, 0x77, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_textsms() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 21, 21), Box(0, 0, 23, 23),
      ic_filled_24_communication_textsms_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_unsubscribe 24x24, 4-bit Alpha,  RLE, 96 bytes.
static const unsigned char ic_filled_24_communication_unsubscribe_data[] PROGMEM = {
  0x04, 0x0D, 0xFF, 0x82, 0xD4, 0x0D, 0xFF, 0xA0, 0xD1, 0xA0, 0x30, 0xBF, 0xB0, 0xB0, 0x3A, 0x1A,
  0x20, 0x30, 0xBE, 0x0B, 0x03, 0x2A, 0x1A, 0x0B, 0x03, 0x20, 0x30, 0xBA, 0x0B, 0x03, 0x20, 0x30,
  0xBA, 0x1C, 0x0B, 0x03, 0x20, 0x03, 0x20, 0x30, 0xBC, 0x1E, 0x0B, 0x03, 0x20, 0x30, 0xBE, 0x1F,
  0x90, 0x0B, 0xF9, 0x1F, 0xE8, 0x3E, 0x97, 0xAE, 0x1F, 0xD0, 0x86, 0xFC, 0x85, 0x80, 0x4C, 0xEC,
  0x41, 0xFB, 0x81, 0xE0, 0x4D, 0x04, 0x0D, 0xFA, 0x81, 0x90, 0xCD, 0x81, 0xC4, 0xDF, 0x98, 0x28,
  0x0E, 0x73, 0x07, 0x0E, 0x75, 0x0C, 0xD0, 0xC7, 0x50, 0x4D, 0x04, 0x76, 0x83, 0x4C, 0xEC, 0x41,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_unsubscribe() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 19), Box(0, 0, 23, 23),
      ic_filled_24_communication_unsubscribe_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_voicemail 24x24, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_filled_24_communication_voicemail_data[] PROGMEM = {
  0x28, 0x52, 0x9D, 0xFD, 0x92, 0x68, 0x52, 0x9D, 0xFD, 0x92, 0x30, 0x40, 0xED, 0x0E, 0x04, 0x40,
  0x40, 0xED, 0x89, 0x4E, 0x40, 0x1E, 0xFA, 0x30, 0x3A, 0xFE, 0x12, 0x89, 0x41, 0xEF, 0xA3, 0x03,
  0xAF, 0xE1, 0x9F, 0xA5, 0x81, 0xAF, 0x92, 0x81, 0x9F, 0xA5, 0x84, 0xAF, 0x9D, 0xF3, 0x58, 0x13,
  0xFD, 0x28, 0x1D, 0xF3, 0x58, 0x13, 0xFD, 0xA7, 0xA2, 0xA7, 0xA8, 0x1D, 0xF3, 0x58, 0x13, 0xFD,
  0x28, 0x1D, 0xF3, 0x58, 0x43, 0xFD, 0x9F, 0xA5, 0x81, 0xAF, 0x92, 0x81, 0x9F, 0xA5, 0x89, 0x4A,
  0xF9, 0x1E, 0xFA, 0x30, 0x3A, 0xFE, 0x22, 0x89, 0x42, 0xEF, 0xA3, 0x03, 0xAF, 0xE1, 0x04, 0xEF,
  0xFC, 0x0E, 0x04, 0x38, 0x12, 0x9D, 0xFF, 0x81, 0xD9, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_voicemail() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 6, 23, 16), Box(0, 0, 23, 23),
      ic_filled_24_communication_voicemail_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_vpn_key_off 24x24, 4-bit Alpha,  RLE, 111 bytes.
static const unsigned char ic_filled_24_communication_vpn_key_off_data[] PROGMEM = {
  0x81, 0x1C, 0x77, 0x75, 0x04, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x75, 0x05, 0xA0, 0x77, 0x73,
  0x01, 0x0C, 0xB0, 0x77, 0x72, 0x0C, 0xD0, 0x77, 0x70, 0x6F, 0x07, 0x76, 0x0B, 0xB8, 0x1B, 0x15,
  0xA0, 0x72, 0x0A, 0xFA, 0x0E, 0xB0, 0x12, 0x05, 0xA0, 0x72, 0x0A, 0xF9, 0x0E, 0xB0, 0x12, 0x01,
  0xB0, 0x72, 0x0A, 0xF0, 0xCB, 0x82, 0xB1, 0x1B, 0xC0, 0x72, 0x0A, 0xE0, 0x6F, 0xD0, 0x72, 0x0A,
  0xB3, 0x0C, 0xF9, 0x0C, 0x05, 0xA0, 0x72, 0x0A, 0xA3, 0x01, 0x0C, 0xE8, 0x2C, 0x10, 0x5A, 0x07,
  0x20, 0xA9, 0x58, 0x46, 0xCE, 0xEC, 0x64, 0x05, 0xA0, 0x72, 0x0A, 0x77, 0x20, 0x5A, 0x07, 0x77,
  0x50, 0x5A, 0x07, 0x77, 0x50, 0x5A, 0x07, 0x77, 0x58, 0x15, 0xFC, 0x77, 0x60, 0x40, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_vpn_key_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 22, 22), Box(0, 0, 23, 23),
      ic_filled_24_communication_vpn_key_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_vpn_key 24x24, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_filled_24_communication_vpn_key_data[] PROGMEM = {
  0x38, 0x46, 0xCE, 0xEB, 0x57, 0x70, 0x10, 0xCE, 0x0C, 0x01, 0x75, 0x0C, 0xF9, 0x0C, 0x74, 0x06,
  0xFB, 0x05, 0x73, 0x0C, 0xB8, 0x2B, 0x11, 0xBF, 0xF0, 0xEB, 0x01, 0x20, 0x1F, 0xF0, 0xEB, 0x01,
  0x20, 0x1F, 0xF0, 0xCB, 0x82, 0xB1, 0x1B, 0xFF, 0x06, 0xFB, 0x05, 0x4C, 0x30, 0xCF, 0x90, 0xC5,
  0xC3, 0x01, 0x0C, 0xE0, 0xC0, 0x15, 0xC5, 0x84, 0x6C, 0xEE, 0xB5, 0x7C, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_vpn_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 22, 17), Box(0, 0, 23, 23),
      ic_filled_24_communication_vpn_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_filled_24_communication_wifi_calling 24x24, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_filled_24_communication_wifi_calling_data[] PROGMEM = {
  0x0B, 0xC0, 0x43, 0x89, 0x11, 0x6B, 0xDF, 0xEB, 0x61, 0x0E, 0xC0, 0x82, 0x06, 0x0E, 0xF8, 0x1E,
  0x6D, 0xC0, 0x92, 0x08, 0xFA, 0x08, 0x0B, 0xC0, 0xC3, 0x0B, 0xF8, 0x1B, 0x09, 0xD3, 0x01, 0x0E,
  0xD8, 0x2E, 0x10, 0x5C, 0x0C, 0x40, 0x3D, 0x03, 0x30, 0xEA, 0x0C, 0x01, 0x50, 0x7B, 0x07, 0x48,
  0x2A, 0xFD, 0x17, 0x81, 0xAF, 0xA5, 0x82, 0x3F, 0xE1, 0x71, 0x0A, 0x78, 0x19, 0xFA, 0x77, 0x28,
  0x21, 0xEF, 0x77, 0x72, 0x04, 0xA0, 0x57, 0x72, 0x07, 0xA0, 0x73, 0x85, 0x1C, 0xFC, 0x97, 0x46,
  0x07, 0xA8, 0x2A, 0x11, 0xCE, 0x78, 0x34, 0xEF, 0xED, 0xF7, 0x10, 0x10, 0x9F, 0xA7, 0x38, 0x12,
  0xAE, 0xE7, 0x68, 0x45, 0x9B, 0xDE, 0xB1,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_filled_24_communication_wifi_calling() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 3, 21, 20), Box(0, 0, 23, 23),
      ic_filled_24_communication_wifi_calling_data, Alpha4(color::Black));
  return value;
}
