#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Regular (Noto Serif Regular)
// Generated on Wed Nov 19 19:11:28 CET 2025
static const uint8_t font_NotoSerif_Regular_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x03, 0x03,
  0xFE, 0xFE, 0x09, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x0A, 0x03, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x01, 0x07, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x05, 0x02, 0x07, 0x03, 0x00, 0x07, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0x0C, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x03, 0x07, 0x04, 0x00, 0x1E, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x06, 0x07, 0x07, 0x00, 0x2E, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x05, 0x07, 0x06, 0x00, 0x47, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x06, 0x01, 0x07, 0x02, 0x00, 0x5C, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x02, 0x06, 0x03, 0x00, 0x5E, // "(" (U+0028)
  0x00, 0x29, 0x40, 0x00, 0x02, 0x06, 0x03, 0x00, 0x69, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x03, 0x07, 0x04, 0x00, 0x74, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x03, 0x05, 0x04, 0x00, 0x7C, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x00, 0x84, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x02, 0x00, 0x87, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x01, 0x02, 0x00, 0x89, // "." (U+002E)
  0x00, 0x2F, 0x40, 0x00, 0x02, 0x07, 0x02, 0x00, 0x8A, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0x96, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xA8, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xB6, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xC4, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xD2, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xE4, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xF2, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x00, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x0E, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x1C, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x05, 0x02, 0x01, 0x2A, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0xFF, 0x01, 0x05, 0x02, 0x01, 0x2F, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x36, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x03, 0x05, 0x04, 0x01, 0x3E, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x44, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x4C, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x06, 0x07, 0x07, 0x01, 0x5A, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0x76, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x8B, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x9D, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0xAF, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xC4, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xD6, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0xE7, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0xFC, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x02, 0x07, 0x03, 0x02, 0x11, // "I" (U+0049)
  0x00, 0x4A, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x02, 0x1C, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x2A, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x3F, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x07, 0x07, 0x08, 0x02, 0x4E, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x6A, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x7F, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x94, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x02, 0xA6, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x05, 0x07, 0x05, 0x02, 0xC1, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0xD6, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xE4, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0xF4, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x05, 0x07, 0x05, 0x03, 0x09, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x08, 0x07, 0x08, 0x03, 0x1E, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x05, 0x07, 0x05, 0x03, 0x3E, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x53, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x65, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0x00, 0x02, 0x07, 0x03, 0x03, 0x77, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x00, 0x02, 0x07, 0x02, 0x03, 0x83, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0x00, 0x02, 0x07, 0x03, 0x03, 0x8F, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x03, 0x06, 0x04, 0x03, 0x9B, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0x00, 0x03, 0x00, 0x04, 0x03, 0xA3, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x07, 0x01, 0x08, 0x02, 0x03, 0xA5, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0xA7, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xB4, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xC6, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xD0, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0xE2, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x03, 0x07, 0x03, 0x03, 0xEC, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFF, 0x04, 0x05, 0x04, 0x03, 0xFA, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x0C, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x07, 0x03, 0x04, 0x1E, // "i" (U+0069)
  0x00, 0x6A, 0x40, 0xFF, 0x01, 0x07, 0x02, 0x04, 0x29, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x32, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x07, 0x02, 0x04, 0x44, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x07, 0x05, 0x08, 0x04, 0x4F, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x63, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0x70, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x7D, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0x8F, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xA1, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xAB, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x02, 0x06, 0x03, 0x04, 0xB5, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xBE, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xCB, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x06, 0x05, 0x07, 0x04, 0xD8, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xEA, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xF7, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0x09, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0x00, 0x02, 0x07, 0x03, 0x05, 0x13, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x1F, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0x00, 0x02, 0x07, 0x03, 0x05, 0x21, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x03, 0x04, 0x04, 0x05, 0x2D, // "~" (U+007E)
  0x00, 0xA1, 0x41, 0xFE, 0x02, 0x04, 0x03, 0x05, 0x31, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x03, 0x07, 0x04, 0x05, 0x38, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0x46, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x03, 0x06, 0x04, 0x05, 0x58, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0x62, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x74, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x00, 0x03, 0x07, 0x04, 0x05, 0x79, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x05, 0x05, 0x89, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0x8B, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0xA4, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x05, 0xA9, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x03, 0x04, 0x04, 0x05, 0xB1, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x05, 0xB7, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x08, 0x03, 0x08, 0x04, 0x05, 0xD0, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x02, 0x07, 0x03, 0x05, 0xD2, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0xD7, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xE1, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xE7, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x07, 0x01, 0x08, 0x02, 0x05, 0xED, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x05, 0xEF, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0x00, 0x04, 0x07, 0x05, 0x06, 0x01, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x04, 0x01, 0x04, 0x02, 0x06, 0x15, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFF, 0x02, 0x01, 0x03, 0x06, 0x16, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x04, 0x02, 0x07, 0x03, 0x06, 0x1B, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x06, 0x21, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x06, 0x26, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0x2E, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0x47, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0x60, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFE, 0x03, 0x04, 0x04, 0x06, 0x79, // "¿" (U+00BF)
  0x00, 0xC0, 0x40, 0x01, 0x05, 0x09, 0x06, 0x06, 0x87, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x05, 0x09, 0x06, 0x06, 0xA2, // "Á" (U+00C1)
  0x00, 0xC2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x06, 0xBC, // "Â" (U+00C2)
  0x00, 0xC3, 0x40, 0x01, 0x05, 0x08, 0x06, 0x06, 0xD7, // "Ã" (U+00C3)
  0x00, 0xC4, 0x40, 0x01, 0x05, 0x08, 0x06, 0x06, 0xEF, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x07, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x07, 0x07, 0x08, 0x07, 0x1F, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x07, 0x3B, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0x52, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0x69, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0x7F, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x96, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x02, 0x09, 0x03, 0x07, 0xAA, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x02, 0x09, 0x03, 0x07, 0xB8, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x02, 0x09, 0x03, 0x07, 0xC6, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x02, 0x08, 0x03, 0x07, 0xD4, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x05, 0x07, 0x06, 0x07, 0xE0, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0xF5, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0x0D, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0x28, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0x43, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x5E, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0x76, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x08, 0x8E, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x05, 0x07, 0x06, 0x08, 0x96, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0xAE, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0xC9, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0xE4, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x08, 0xFF, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x09, 0x05, 0x09, 0x17, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x2D, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x3F, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0x51, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x65, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x78, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x8B, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0x9D, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x08, 0x05, 0x09, 0xAF, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x06, 0x05, 0x07, 0x09, 0xC3, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x09, 0xD5, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0xE3, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0xF3, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x03, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x13, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0A, 0x21, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0A, 0x2D, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0A, 0x39, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0A, 0x45, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x50, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x62, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x74, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x88, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x9B, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xAE, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xC0, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x0A, 0xD2, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x06, 0x05, 0x0A, 0xDA, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xEB, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0xFF, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x12, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x25, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x0B, 0x37, // "ý" (U+00FD)
  0x00, 0xFE, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x4E, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x65, // "ÿ" (U+00FF)
  0x01, 0x00, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0B, 0x7B, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0B, 0x90, // "ā" (U+0101)
  0x01, 0x02, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0B, 0x9F, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xB7, // "ă" (U+0103)
  0x01, 0x04, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x0B, 0xC9, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0B, 0xE4, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xF6, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x0D, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x1D, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x34, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0C, 0x44, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x58, // "ċ" (U+010B)
  0x01, 0x0C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0x66, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x7D, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0C, 0x8D, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0C, 0xA8, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0C, 0xBD, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xD2, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0xE4, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0C, 0xF6, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x02, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x16, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x24, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x38, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x46, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0D, 0x5C, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x6A, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0D, 0x81, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x91, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x40, 0xFF, 0x04, 0x08, 0x04, 0x0D, 0xAC, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0xC5, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0D, 0xDD, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0xF4, // "Ġ" (U+0120)
  0x01, 0x21, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0x0C, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x0E, 0x23, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0x3E, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x55, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0E, 0x70, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0E, 0x88, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0E, 0x9D, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0E, 0xAF, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x02, 0x07, 0x03, 0x0E, 0xBF, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0xCD, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x02, 0x06, 0x03, 0x0E, 0xD8, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0E, 0xE1, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0xED, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x0E, 0xF8, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFF, 0x02, 0x07, 0x03, 0x0F, 0x06, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0F, 0x14, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x05, 0x03, 0x0F, 0x20, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x0F, 0x28, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0x43, // "ĳ" (U+0133)
  0x01, 0x34, 0x40, 0xFF, 0x02, 0x09, 0x03, 0x0F, 0x5A, // "Ĵ" (U+0134)
  0x01, 0x35, 0x40, 0xFF, 0x02, 0x08, 0x02, 0x0F, 0x6B, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x0F, 0x7A, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0x97, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x05, 0x05, 0x0F, 0xAF, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0xBC, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x02, 0x0A, 0x02, 0x0F, 0xCF, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0F, 0xDE, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFE, 0x02, 0x07, 0x02, 0x0F, 0xF1, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x00, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x02, 0x07, 0x02, 0x10, 0x10, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x10, 0x1B, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x07, 0x03, 0x10, 0x2B, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x39, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x07, 0x03, 0x10, 0x4B, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0x56, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x71, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x05, 0x07, 0x06, 0x10, 0x84, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x05, 0x05, 0x10, 0xA0, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0xB3, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x08, 0x05, 0x10, 0xCE, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x05, 0x07, 0x06, 0x10, 0xE2, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x10, 0xF7, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x11, 0x12, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x05, 0x07, 0x06, 0x11, 0x24, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x11, 0x39, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x11, 0x48, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x60, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x08, 0x06, 0x11, 0x72, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x8A, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x07, 0x07, 0x08, 0x11, 0x9C, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x06, 0x05, 0x07, 0x11, 0xB8, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x05, 0x09, 0x05, 0x11, 0xCA, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x08, 0x04, 0x11, 0xE5, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x05, 0x07, 0x05, 0x11, 0xF5, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFE, 0x03, 0x05, 0x04, 0x12, 0x12, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x05, 0x09, 0x05, 0x12, 0x22, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x03, 0x08, 0x04, 0x12, 0x3D, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x03, 0x09, 0x04, 0x12, 0x4D, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x12, 0x5F, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x03, 0x09, 0x04, 0x12, 0x6F, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x12, 0x81, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x12, 0x91, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x12, 0xA3, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x03, 0x09, 0x04, 0x12, 0xB1, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x08, 0x04, 0x12, 0xC3, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x12, 0xD3, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x12, 0xE7, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0xF3, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x02, 0x07, 0x03, 0x13, 0x09, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0x14, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x02, 0x06, 0x03, 0x13, 0x26, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x05, 0x08, 0x06, 0x13, 0x2F, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0x47, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x05, 0x07, 0x06, 0x13, 0x59, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x06, 0x05, 0x13, 0x6E, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x05, 0x08, 0x06, 0x13, 0x7D, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0x95, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x05, 0x09, 0x06, 0x13, 0xA7, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xC2, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x05, 0x08, 0x06, 0x13, 0xD6, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x05, 0x13, 0xEE, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x14, 0x00, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x14, 0x1B, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x08, 0x09, 0x08, 0x14, 0x2D, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x08, 0x07, 0x14, 0x53, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x09, 0x05, 0x14, 0x6D, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x04, 0x08, 0x05, 0x14, 0x83, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x04, 0x08, 0x05, 0x14, 0x9B, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x04, 0x09, 0x05, 0x14, 0xAF, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x14, 0xC6, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x14, 0xD6, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x03, 0x07, 0x04, 0x14, 0xEA, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x14, 0xF8, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x03, 0x08, 0x04, 0x15, 0x0F, // "ž" (U+017E)
  0x01, 0x7F, 0x40, 0x01, 0x03, 0x07, 0x03, 0x15, 0x1F, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x05, 0x07, 0x06, 0x15, 0x2D, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x15, 0x42, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x04, 0x05, 0x05, 0x15, 0x54, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x03, 0x03, 0x04, 0x15, 0x61, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x03, 0x08, 0x15, 0x63, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x07, 0x04, 0x15, 0x65, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x04, 0x07, 0x04, 0x15, 0x77, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x05, 0x01, 0x07, 0x02, 0x15, 0x8B, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x05, 0x01, 0x07, 0x02, 0x15, 0x8E, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x15, 0x91, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x05, 0x01, 0x07, 0x02, 0x15, 0x94, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x05, 0x03, 0x07, 0x04, 0x15, 0x97, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x05, 0x03, 0x07, 0x04, 0x15, 0x9D, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFF, 0x03, 0x01, 0x04, 0x15, 0xA3, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x05, 0x03, 0x07, 0x04, 0x15, 0xA9, // "‟" (U+201F)
  0x20, 0x20, 0x40, 0x00, 0x03, 0x07, 0x04, 0x15, 0xAF, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x00, 0x03, 0x07, 0x04, 0x15, 0xBF, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x05, 0x03, 0x15, 0xCF, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x06, 0x02, 0x07, 0x15, 0xD4, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x09, 0x07, 0x0A, 0x15, 0xDB, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x01, 0x05, 0x03, 0x15, 0xFE, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x02, 0x05, 0x03, 0x16, 0x02, // "›" (U+203A)
  0x20, 0x44, 0xBE, 0x01, 0x01, 0x07, 0x01, 0x16, 0x08, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x06, 0x06, 0x07, 0x16, 0x16, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x07, 0x09, 0x16, 0x21, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x05, 0x07, 0x05, 0x16, 0x3E, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x05, 0x07, 0x05, 0x16, 0x53, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x01, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x01, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x3F, 0x01, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x3F, 0x01, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x01, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x01, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x01, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x01, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x01, 0x62, 0x01, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x01, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x01, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x01, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x1B, 0x1B, 0x0A, 0x08, 0x05, 0x01, 0x1A,
  // """ (U+0022)
  0x73, 0xB5, 0x28, 0x00, 0x10,
  // "#" (U+0023)
  0x05, 0x17, 0x00, 0x70, 0x70, 0x4B, 0x9B, 0x20, 0x73, 0x30, 0x7B, 0xB8, 0x02, 0x47, 0x00, 0x42,
  0x70, 0x00,
  // "$" (U+0024)
  0x00, 0x60, 0x19, 0xB7, 0x47, 0x64, 0x0B, 0x90, 0x00, 0xAA, 0x72, 0x6B, 0x18, 0xA3, 0x00, 0x20,
  // "%" (U+0025)
  0x37, 0x60, 0x61, 0x08, 0x1A, 0x07, 0x00, 0x91, 0xB4, 0x30, 0x07, 0x2A, 0x83, 0x63, 0x16, 0x56,
  0xA0, 0xA0, 0x07, 0x0A, 0x0B, 0x00, 0x70, 0x66, 0x60,
  // "&" (U+0026)
  0x08, 0x76, 0x00, 0x0C, 0x0B, 0x00, 0x0D, 0xD9, 0x00, 0x0A, 0xC0, 0x84, 0x84, 0x86, 0x80, 0xA2,
  0x0A, 0x60, 0x39, 0x66, 0xB6,
  // "'" (U+0027)
  0x73, 0x52,
  // "(" (U+0028)
  0x06, 0x32, 0x80, 0x75, 0x08, 0x40, 0x65, 0x02, 0x80, 0x05, 0x30,
  // ")" (U+0029)
  0x53, 0x00, 0xA0, 0x09, 0x30, 0x84, 0x09, 0x20, 0xA0, 0x53, 0x00,
  // "*" (U+002A)
  0x24, 0x42, 0x3B, 0xA3, 0x68, 0x75, 0x02, 0x20,
  // "+" (U+002B)
  0x00, 0x60, 0x00, 0x70, 0x48, 0xB8, 0x00, 0x70,
  // "," (U+002C)
  0x76, 0x25, 0x40,
  // "-" (U+002D)
  0x8A, 0x30,
  // "." (U+002E)
  0x66,
  // "/" (U+002F)
  0x04, 0x20, 0x60, 0x07, 0x00, 0x60, 0x34, 0x06, 0x00, 0x70, 0x07, 0x00,
  // "0" (U+0030)
  0x09, 0x84, 0x06, 0x60, 0xB0, 0x93, 0x0B, 0x09, 0x30, 0xB1, 0x83, 0x0B, 0x05, 0x60, 0xB0, 0x09,
  0x84, 0x00,
  // "1" (U+0031)
  0x05, 0xB0, 0x36, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xB0, 0x17, 0xE5,
  // "2" (U+0032)
  0x2A, 0x94, 0x44, 0x1B, 0x00, 0x29, 0x00, 0x81, 0x03, 0x50, 0x08, 0x03, 0x7B, 0xBD,
  // "3" (U+0033)
  0x2A, 0x95, 0x44, 0x0B, 0x00, 0x38, 0x04, 0xB3, 0x00, 0x0C, 0x30, 0x0D, 0x49, 0x95,
  // "4" (U+0034)
  0x00, 0xA5, 0x00, 0x39, 0x50, 0x07, 0x65, 0x05, 0x26, 0x50, 0x88, 0xBA, 0x20, 0x06, 0x50, 0x01,
  0xBB, 0x00,
  // "5" (U+0035)
  0x1C, 0xB8, 0x23, 0x02, 0x32, 0x00, 0x48, 0x82, 0x00, 0x1B, 0x20, 0x0B, 0x59, 0x94,
  // "6" (U+0036)
  0x07, 0x88, 0x29, 0x07, 0x66, 0x00, 0x79, 0x74, 0x75, 0x0C, 0x37, 0x0B, 0x08, 0x76,
  // "7" (U+0037)
  0x7B, 0xBE, 0x30, 0x0A, 0x00, 0x36, 0x00, 0x82, 0x00, 0xA0, 0x02, 0x80, 0x06, 0x40,
  // "8" (U+0038)
  0x18, 0x65, 0x65, 0x0B, 0x3E, 0x98, 0x0A, 0xD3, 0x65, 0x1C, 0x82, 0x0A, 0x28, 0x66,
  // "9" (U+0039)
  0x09, 0x93, 0x65, 0x1B, 0x83, 0x0C, 0x65, 0x0D, 0x08, 0x6B, 0x00, 0x18, 0x38, 0x91,
  // ":" (U+003A)
  0x48, 0x01, 0x00, 0x01, 0x48,
  // ";" (U+003B)
  0x48, 0x01, 0x00, 0x01, 0x49, 0x25, 0x10,
  // "<" (U+003C)
  0x00, 0x17, 0x07, 0x60, 0x38, 0x20, 0x00, 0x57,
  // "=" (U+003D)
  0x38, 0x87, 0x00, 0x00, 0x38, 0x87,
  // ">" (U+003E)
  0x44, 0x00, 0x03, 0x83, 0x00, 0x67, 0x37, 0x10,
  // "?" (U+003F)
  0x68, 0x81, 0x60, 0x56, 0x00, 0x75, 0x04, 0x90, 0x07, 0x00, 0x02, 0x00, 0x0A, 0x10,
  // "@" (U+0040)
  0x00, 0x77, 0x78, 0x10, 0x73, 0x00, 0x07, 0x18, 0x28, 0x84, 0x76, 0x4A, 0x08, 0x17, 0x72, 0xB0,
  0xB0, 0x75, 0x45, 0x74, 0x81, 0x0A, 0x00, 0x03, 0x00, 0x18, 0x77, 0x10,
  // "A" (U+0041)
  0x00, 0x94, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07, 0x0A, 0x30, 0x0A, 0x7A, 0x70, 0x25,
  0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "B" (U+0042)
  0x5E, 0x69, 0x10, 0xC0, 0x66, 0x0C, 0x07, 0x50, 0xD7, 0xB1, 0x0C, 0x03, 0x90, 0xC0, 0x2A, 0x5E,
  0x68, 0x30,
  // "C" (U+0043)
  0x06, 0x8A, 0x52, 0xA0, 0x15, 0x66, 0x00, 0x08, 0x50, 0x00, 0x77, 0x00, 0x02, 0xB0, 0x01, 0x07,
  0xA9, 0x40,
  // "D" (U+0044)
  0x5E, 0x68, 0x30, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0x93, 0x0C, 0x00, 0x85, 0x0C, 0x00, 0x94, 0x0C,
  0x00, 0xC0, 0x5E, 0x69, 0x40,
  // "E" (U+0045)
  0x5E, 0x69, 0x50, 0xC0, 0x03, 0x0C, 0x00, 0x00, 0xD7, 0x50, 0x0C, 0x00, 0x00, 0xC0, 0x04, 0x5E,
  0x67, 0x90,
  // "F" (U+0046)
  0x85, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD7, 0x52, 0x0C, 0x40, 0xC3, 0x81, 0x5E,
  0x52,
  // "G" (U+0047)
  0x05, 0x88, 0x90, 0x2A, 0x00, 0x90, 0x66, 0x00, 0x00, 0x85, 0x00, 0x00, 0x66, 0x03, 0xA4, 0x2B,
  0x00, 0xC0, 0x05, 0x97, 0xA0,
  // "H" (U+0048)
  0x5E, 0x41, 0xCA, 0x0C, 0x00, 0x84, 0x0C, 0x00, 0x84, 0x0D, 0x77, 0xB4, 0x0C, 0x00, 0x84, 0x0C,
  0x00, 0x84, 0x5E, 0x41, 0xC9,
  // "I" (U+0049)
  0x5E, 0x40, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x5E, 0x40,
  // "J" (U+004A)
  0x5E, 0x40, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x95, 0x00,
  // "K" (U+004B)
  0x5E, 0x43, 0xD2, 0x0C, 0x06, 0x20, 0x0C, 0x26, 0x00, 0x0D, 0xB6, 0x00, 0x0D, 0x2D, 0x10, 0x0C,
  0x06, 0x90, 0x5E, 0x40, 0xB6,
  // "L" (U+004C)
  0x81, 0x5E, 0x43, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC4, 0x0C, 0x28, 0x47, 0x5E, 0x67, 0x90,
  // "M" (U+004D)
  0x5F, 0x40, 0x0B, 0xB1, 0x0B, 0x80, 0x0B, 0x60, 0x07, 0xC0, 0x47, 0x60, 0x07, 0x92, 0x75, 0x60,
  0x07, 0x57, 0x75, 0x60, 0x07, 0x0D, 0x45, 0x60, 0x5C, 0x1A, 0x09, 0xB1,
  // "N" (U+004E)
  0x5E, 0x10, 0xA7, 0x0C, 0x80, 0x51, 0x07, 0xC1, 0x51, 0x07, 0x49, 0x51, 0x07, 0x0B, 0x71, 0x07,
  0x03, 0xE1, 0x5C, 0x10, 0xB1,
  // "O" (U+004F)
  0x06, 0x88, 0x50, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85, 0x00, 0x67, 0x76, 0x00, 0x75, 0x2A,
  0x00, 0xB1, 0x06, 0x88, 0x50,
  // "P" (U+0050)
  0x5E, 0x69, 0x00, 0xC0, 0x66, 0x0C, 0x05, 0x70, 0xC0, 0x83, 0x0D, 0x65, 0x00, 0xC0, 0x00, 0x5E,
  0x50, 0x00,
  // "Q" (U+0051)
  0x06, 0x77, 0x50, 0x39, 0x00, 0xA1, 0x76, 0x00, 0x76, 0x85, 0x00, 0x67, 0x66, 0x00, 0x75, 0x2A,
  0x00, 0xB1, 0x06, 0x9A, 0x50, 0x00, 0x49, 0x00, 0x00, 0x09, 0x50,
  // "R" (U+0052)
  0x5E, 0x69, 0x10, 0x0C, 0x05, 0x70, 0x0C, 0x07, 0x40, 0x0D, 0x88, 0x00, 0x0C, 0x1C, 0x00, 0x0C,
  0x09, 0x40, 0x5E, 0x42, 0xB2,
  // "S" (U+0053)
  0x18, 0x86, 0x74, 0x05, 0x5A, 0x00, 0x09, 0xD3, 0x00, 0x3C, 0x70, 0x0B, 0x49, 0x75,
  // "T" (U+0054)
  0x89, 0x0B, 0x7D, 0x7A, 0x40, 0xC0, 0x42, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC3, 0x81, 0x5E, 0x41,
  // "U" (U+0055)
  0x7D, 0x32, 0xC4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x0C,
  0x00, 0x70, 0x07, 0x98, 0x30,
  // "V" (U+0056)
  0xAC, 0x13, 0xD2, 0x2A, 0x00, 0x70, 0x0C, 0x03, 0x40, 0x09, 0x37, 0x00, 0x04, 0x77, 0x00, 0x00,
  0xB6, 0x00, 0x00, 0xB1, 0x00,
  // "W" (U+0057)
  0x9C, 0x11, 0xB0, 0x4C, 0x11, 0xB0, 0x4E, 0x01, 0x70, 0x0C, 0x07, 0x92, 0x43, 0x00, 0x92, 0x75,
  0x67, 0x00, 0x06, 0x67, 0x2A, 0x70, 0x00, 0x2C, 0x40, 0xB7, 0x00, 0x00, 0xE0, 0x0A, 0x40, 0x00,
  // "X" (U+0058)
  0x7E, 0x27, 0xA0, 0x0B, 0x27, 0x00, 0x04, 0xB5, 0x00, 0x00, 0xD2, 0x00, 0x03, 0x8A, 0x00, 0x08,
  0x0B, 0x20, 0x9A, 0x0A, 0xC1,
  // "Y" (U+0059)
  0xBB, 0x08, 0xB1, 0xB0, 0x61, 0x09, 0x37, 0x00, 0x2C, 0x30, 0x00, 0xC0, 0x00, 0x0C, 0x00, 0x05,
  0xE5, 0x00,
  // "Z" (U+005A)
  0x88, 0x7E, 0x24, 0x03, 0xB0, 0x00, 0xB3, 0x00, 0x3B, 0x00, 0x0A, 0x30, 0x02, 0xB0, 0x03, 0x9A,
  0x79, 0x50,
  // "[" (U+005B)
  0x3C, 0x33, 0x90, 0x39, 0x03, 0x90, 0x39, 0x03, 0x90, 0x39, 0x02, 0x93,
  // "\" (U+005C)
  0x70, 0x07, 0x00, 0x60, 0x03, 0x40, 0x07, 0x00, 0x70, 0x07, 0x00, 0x42,
  // "]" (U+005D)
  0x4D, 0x10, 0xA1, 0x0A, 0x10, 0xA1, 0x0A, 0x10, 0xA1, 0x0B, 0x14, 0xA0,
  // "^" (U+005E)
  0x02, 0x80, 0x07, 0x70, 0x07, 0x16, 0x52, 0x08,
  // "_" (U+005F)
  0x88, 0x86,
  // "`" (U+0060)
  0x42, 0x17,
  // "a" (U+0061)
  0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90, 0x4A, 0x6C, 0x10,
  // "b" (U+0062)
  0x79, 0x00, 0x02, 0x90, 0x00, 0x2B, 0x8A, 0x02, 0xB0, 0x65, 0x29, 0x04, 0x62, 0xB0, 0x65, 0x7A,
  0x8A, 0x00,
  // "c" (U+0063)
  0x19, 0x85, 0x64, 0x13, 0x83, 0x00, 0x65, 0x00, 0x1A, 0x85,
  // "d" (U+0064)
  0x00, 0x2D, 0x00, 0x00, 0xA0, 0x1A, 0x8C, 0x06, 0x50, 0xC0, 0x83, 0x0B, 0x06, 0x50, 0xC0, 0x1A,
  0x8B, 0x60,
  // "e" (U+0065)
  0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "f" (U+0066)
  0x08, 0x85, 0x0B, 0x00, 0x4D, 0x50, 0x0B, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x6D, 0x40,
  // "g" (U+0067)
  0x2B, 0xAA, 0x16, 0x55, 0x60, 0x0A, 0x81, 0x03, 0x40, 0x00, 0x1D, 0xC7, 0x09, 0x00, 0xB0, 0x77,
  0x76, 0x00,
  // "h" (U+0068)
  0x79, 0x00, 0x02, 0x90, 0x00, 0x2B, 0x8A, 0x02, 0xA0, 0x82, 0x29, 0x08, 0x32, 0x90, 0x83, 0x7C,
  0x18, 0x80,
  // "i" (U+0069)
  0x19, 0x00, 0x00, 0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x6D, 0x30,
  // "j" (U+006A)
  0x28, 0x00, 0x79, 0x29, 0x29, 0x29, 0x29, 0x38, 0x93,
  // "k" (U+006B)
  0x79, 0x00, 0x02, 0x90, 0x00, 0x29, 0x2D, 0x32, 0x99, 0x20, 0x2E, 0xD1, 0x02, 0x95, 0x90, 0x7C,
  0x1A, 0x50,
  // "l" (U+006C)
  0x79, 0x02, 0x90, 0x29, 0x02, 0x90, 0x29, 0x02, 0x90, 0x7C, 0x20,
  // "m" (U+006D)
  0x5B, 0x8B, 0x6A, 0x50, 0x1C, 0x08, 0x41, 0xA0, 0x1A, 0x08, 0x31, 0xA0, 0x1A, 0x08, 0x31, 0xA0,
  0x6D, 0x28, 0x81, 0xD2,
  // "n" (U+006E)
  0x6B, 0x8B, 0x01, 0xC0, 0x74, 0x1A, 0x07, 0x41, 0xA0, 0x74, 0x6D, 0x27, 0x90,
  // "o" (U+006F)
  0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0, 0x19, 0x77, 0x00,
  // "p" (U+0070)
  0x7A, 0x8A, 0x02, 0xB0, 0x65, 0x29, 0x04, 0x62, 0xB0, 0x65, 0x2B, 0x8A, 0x02, 0x90, 0x00, 0x7C,
  0x10, 0x00,
  // "q" (U+0071)
  0x1A, 0x8B, 0x66, 0x50, 0xC0, 0x83, 0x0B, 0x06, 0x50, 0xC0, 0x1A, 0x8C, 0x00, 0x00, 0xA0, 0x00,
  0x4D, 0x60,
  // "r" (U+0072)
  0x6A, 0xA7, 0x1D, 0x01, 0x1B, 0x00, 0x1A, 0x00, 0x6D, 0x30,
  // "s" (U+0073)
  0x47, 0xA0, 0x84, 0x20, 0x1B, 0x90, 0x30, 0x83, 0x66, 0x90,
  // "t" (U+0074)
  0x27, 0x08, 0xB4, 0x38, 0x03, 0x80, 0x38, 0x01, 0xB4,
  // "u" (U+0075)
  0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93, 0x0A, 0x8A, 0x80,
  // "v" (U+0076)
  0xAB, 0x0B, 0x42, 0x90, 0x70, 0x0C, 0x06, 0x00, 0x88, 0x20, 0x03, 0xB0, 0x00,
  // "w" (U+0077)
  0xAA, 0x0C, 0x08, 0x83, 0x82, 0xC3, 0x51, 0x0B, 0x63, 0x87, 0x00, 0xA6, 0x0A, 0x60, 0x07, 0x60,
  0x94, 0x00,
  // "x" (U+0078)
  0x7D, 0x3C, 0x20, 0x96, 0x20, 0x02, 0xC0, 0x00, 0x75, 0x60, 0x8A, 0x3E, 0x40,
  // "y" (U+0079)
  0xAA, 0x0C, 0x32, 0x90, 0x70, 0x0B, 0x16, 0x00, 0x6A, 0x10, 0x00, 0xB0, 0x00, 0x26, 0x00, 0x59,
  0x00, 0x00,
  // "z" (U+007A)
  0x78, 0xB7, 0x20, 0xB0, 0x07, 0x50, 0x1B, 0x02, 0x8B, 0x88,
  // "{" (U+007B)
  0x05, 0x80, 0x92, 0x0A, 0x10, 0xB0, 0x4A, 0x00, 0xA1, 0x0A, 0x20, 0x37,
  // "|" (U+007C)
  0x80, 0x57,
  // "}" (U+007D)
  0x3A, 0x00, 0xB1, 0x0A, 0x10, 0x92, 0x04, 0xA0, 0xA1, 0x0B, 0x13, 0x70,
  // "~" (U+007E)
  0x29, 0x25, 0x50, 0x76,
  // "¡" (U+00A1)
  0xA1, 0x10, 0x50, 0x80, 0xA0, 0xB0, 0xB1,
  // "¢" (U+00A2)
  0x00, 0x81, 0x0A, 0x8B, 0x47, 0x61, 0x56, 0x60, 0x2A, 0x62, 0x06, 0xB7, 0x00, 0x60,
  // "£" (U+00A3)
  0x08, 0x79, 0x02, 0x80, 0x50, 0x19, 0x00, 0x04, 0xC7, 0x10, 0x08, 0x10, 0x00, 0x80, 0x00, 0x4A,
  0xBA, 0x10,
  // "¤" (U+00A4)
  0x00, 0x01, 0x3B, 0x99, 0x24, 0x07, 0x25, 0x07, 0x39, 0x88,
  // "¥" (U+00A5)
  0xBB, 0x1D, 0x33, 0x90, 0x70, 0x0B, 0x15, 0x00, 0x88, 0x00, 0x18, 0xC4, 0x01, 0x7C, 0x40, 0x08,
  0xD3, 0x00,
  // "¦" (U+00A6)
  0x77, 0x74, 0x04, 0x77, 0x70,
  // "§" (U+00A7)
  0x09, 0x95, 0x27, 0x03, 0x1D, 0x80, 0x55, 0x5A, 0x1C, 0x99, 0x00, 0x79, 0x15, 0x08, 0x07, 0x72,
  // "¨" (U+00A8)
  0x72, 0x40,
  // "©" (U+00A9)
  0x01, 0x77, 0x60, 0x01, 0x84, 0x75, 0x80, 0x62, 0x80, 0x34, 0x27, 0x27, 0x00, 0x24, 0x62, 0x90,
  0x14, 0x21, 0x85, 0x65, 0x80, 0x01, 0x77, 0x60, 0x00,
  // "ª" (U+00AA)
  0x47, 0x64, 0x69, 0x86, 0xA0,
  // "«" (U+00AB)
  0x03, 0x03, 0x19, 0x82, 0x57, 0xC0, 0x08, 0x35,
  // "¬" (U+00AC)
  0x48, 0x89, 0x00, 0x07, 0x00, 0x05,
  // "®" (U+00AE)
  0x01, 0x77, 0x60, 0x01, 0x98, 0x54, 0x80, 0x61, 0x90, 0x94, 0x27, 0x09, 0x92, 0x24, 0x61, 0x94,
  0x64, 0x21, 0x89, 0x29, 0x80, 0x01, 0x77, 0x60, 0x00,
  // "¯" (U+00AF)
  0x88, 0x85,
  // "°" (U+00B0)
  0x39, 0x58, 0x09, 0x39, 0x50,
  // "±" (U+00B1)
  0x00, 0x70, 0x38, 0xB7, 0x00, 0x70, 0x00, 0x60, 0x38, 0x87,
  // "²" (U+00B2)
  0x36, 0x42, 0x19, 0x07, 0x26, 0x87,
  // "³" (U+00B3)
  0x46, 0x50, 0x85, 0x30, 0xA4, 0x63,
  // "´" (U+00B4)
  0x05, 0x63,
  // "µ" (U+00B5)
  0x38, 0x0A, 0x13, 0x80, 0xA1, 0x38, 0x0A, 0x13, 0x90, 0xC1, 0x4C, 0x89, 0x54, 0x50, 0x00, 0x2A,
  0x00, 0x00,
  // "¶" (U+00B6)
  0x5F, 0xBB, 0x4A, 0xF9, 0x70, 0x7F, 0x97, 0x00, 0x48, 0x70, 0x00, 0x77, 0x00, 0x07, 0x70, 0x00,
  0x77, 0x00, 0x46, 0x64,
  // "·" (U+00B7)
  0x66,
  // "¸" (U+00B8)
  0x07, 0x00, 0x81, 0x48, 0x00,
  // "¹" (U+00B9)
  0x3A, 0x00, 0xB0, 0x0B, 0x02, 0x83,
  // "º" (U+00BA)
  0x66, 0x7A, 0x0A, 0x56, 0x70,
  // "»" (U+00BB)
  0x20, 0x30, 0x19, 0x82, 0x0B, 0x67, 0x34, 0x80,
  // "¼" (U+00BC)
  0x00, 0x00, 0x80, 0x03, 0xA0, 0x35, 0x00, 0x0B, 0x07, 0x00, 0x00, 0xB0, 0x70, 0x83, 0x28, 0x91,
  0x39, 0x40, 0x08, 0x06, 0x98, 0x03, 0x40, 0x07, 0x50,
  // "½" (U+00BD)
  0x00, 0x00, 0x80, 0x03, 0xA0, 0x35, 0x00, 0x0B, 0x07, 0x00, 0x00, 0xB0, 0x73, 0x64, 0x28, 0x91,
  0x21, 0x90, 0x08, 0x00, 0x72, 0x03, 0x40, 0x68, 0x70,
  // "¾" (U+00BE)
  0x00, 0x00, 0x80, 0x04, 0x65, 0x35, 0x00, 0x08, 0x57, 0x00, 0x03, 0x0B, 0x70, 0x83, 0x46, 0x91,
  0x39, 0x40, 0x08, 0x06, 0x98, 0x03, 0x40, 0x07, 0x50,
  // "¿" (U+00BF)
  0x01, 0xA0, 0x00, 0x20, 0x00, 0x70, 0x09, 0x40, 0x57, 0x00, 0x65, 0x06, 0x18, 0x86,
  // "À" (U+00C0)
  0x04, 0x20, 0x00, 0x01, 0x70, 0x00, 0x00, 0x94, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07,
  0x0A, 0x30, 0x0A, 0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Á" (U+00C1)
  0x30, 0x54, 0x06, 0x03, 0x40, 0x90, 0x44, 0x0A, 0x09, 0x38, 0x13, 0x4C, 0x38, 0x27, 0x0A, 0x32,
  0x89, 0x7A, 0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Â" (U+00C2)
  0x00, 0x70, 0x00, 0x05, 0x65, 0x00, 0x00, 0x94, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07,
  0x0A, 0x30, 0x0A, 0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Ã" (U+00C3)
  0x04, 0x96, 0x10, 0x03, 0xDE, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07, 0x0A, 0x30, 0x0A,
  0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Ä" (U+00C4)
  0x00, 0x72, 0x40, 0x00, 0x94, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07, 0x0A, 0x30, 0x0A,
  0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Å" (U+00C5)
  0x00, 0x75, 0x00, 0x00, 0xB6, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07, 0x0A, 0x20, 0x0A,
  0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "Æ" (U+00C6)
  0x00, 0x3C, 0xA6, 0xC0, 0x00, 0x47, 0x70, 0x30, 0x00, 0x74, 0x70, 0x00, 0x02, 0x54, 0xB7, 0x30,
  0x08, 0x79, 0x70, 0x00, 0x17, 0x04, 0x70, 0x12, 0xA9, 0x0A, 0xA6, 0xA3,
  // "Ç" (U+00C7)
  0x06, 0x8A, 0x52, 0xA0, 0x15, 0x66, 0x00, 0x08, 0x50, 0x00, 0x77, 0x00, 0x02, 0xB0, 0x01, 0x07,
  0xED, 0x40, 0x00, 0xA0, 0x00, 0x65, 0x00,
  // "È" (U+00C8)
  0x04, 0x20, 0x00, 0x17, 0x00, 0x5E, 0x69, 0x50, 0xC0, 0x03, 0x0C, 0x00, 0x00, 0xD7, 0x50, 0x0C,
  0x00, 0x00, 0xC0, 0x04, 0x5E, 0x67, 0x90,
  // "É" (U+00C9)
  0x30, 0x53, 0x89, 0x06, 0x30, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD7, 0x52, 0x0C,
  0x40, 0xC2, 0x84, 0x45, 0xE6, 0x79,
  // "Ê" (U+00CA)
  0x00, 0x70, 0x00, 0x56, 0x50, 0x5E, 0x69, 0x50, 0xC0, 0x03, 0x0C, 0x00, 0x00, 0xD7, 0x50, 0x0C,
  0x00, 0x00, 0xC0, 0x04, 0x5E, 0x67, 0x90,
  // "Ë" (U+00CB)
  0x07, 0x24, 0x05, 0xE6, 0x95, 0x0C, 0x00, 0x30, 0xC0, 0x00, 0x0D, 0x75, 0x00, 0xC0, 0x00, 0x0C,
  0x00, 0x45, 0xE6, 0x79,
  // "Ì" (U+00CC)
  0x42, 0x01, 0x70, 0x5E, 0x40, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x5E, 0x40,
  // "Í" (U+00CD)
  0x00, 0x50, 0x63, 0x5E, 0x40, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x5E, 0x40,
  // "Î" (U+00CE)
  0x07, 0x05, 0x65, 0x5E, 0x40, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x5E, 0x40,
  // "Ï" (U+00CF)
  0x72, 0x45, 0xE4, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x05, 0xE4,
  // "Ð" (U+00D0)
  0x5E, 0x68, 0x30, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0x93, 0x4D, 0x71, 0x85, 0x0C, 0x00, 0x94, 0x0C,
  0x00, 0xC0, 0x5E, 0x69, 0x40,
  // "Ñ" (U+00D1)
  0x04, 0x96, 0x10, 0x5F, 0x4A, 0xB7, 0x0C, 0x80, 0x51, 0x07, 0xC1, 0x51, 0x07, 0x49, 0x51, 0x07,
  0x0B, 0x71, 0x07, 0x03, 0xE1, 0x5C, 0x10, 0xB1,
  // "Ò" (U+00D2)
  0x04, 0x20, 0x00, 0x01, 0x70, 0x00, 0x06, 0x88, 0x50, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85,
  0x00, 0x67, 0x76, 0x00, 0x75, 0x2A, 0x00, 0xB1, 0x06, 0x88, 0x50,
  // "Ó" (U+00D3)
  0x00, 0x05, 0x00, 0x00, 0x63, 0x00, 0x06, 0x88, 0x50, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85,
  0x00, 0x67, 0x76, 0x00, 0x75, 0x2A, 0x00, 0xB1, 0x06, 0x88, 0x50,
  // "Ô" (U+00D4)
  0x00, 0x70, 0x00, 0x05, 0x65, 0x00, 0x06, 0x88, 0x50, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85,
  0x00, 0x67, 0x76, 0x00, 0x75, 0x2A, 0x00, 0xB1, 0x06, 0x88, 0x50,
  // "Õ" (U+00D5)
  0x04, 0x96, 0x10, 0x0A, 0xBF, 0x50, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85, 0x00, 0x67, 0x76,
  0x00, 0x75, 0x2A, 0x00, 0xB1, 0x06, 0x88, 0x50,
  // "Ö" (U+00D6)
  0x00, 0x72, 0x40, 0x06, 0x88, 0x50, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85, 0x00, 0x67, 0x76,
  0x00, 0x75, 0x2A, 0x00, 0xB1, 0x06, 0x88, 0x50,
  // "×" (U+00D7)
  0x21, 0x03, 0x08, 0x73, 0x07, 0x91, 0x23, 0x06,
  // "Ø" (U+00D8)
  0x06, 0x88, 0x90, 0x2A, 0x05, 0xC1, 0x76, 0x07, 0x75, 0x85, 0x43, 0x67, 0x66, 0x70, 0x75, 0x3C,
  0x40, 0xB1, 0x0B, 0x88, 0x50, 0x03, 0x00, 0x00,
  // "Ù" (U+00D9)
  0x04, 0x20, 0x00, 0x01, 0x70, 0x00, 0x7D, 0x32, 0xC4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A,
  0x00, 0x70, 0x1A, 0x00, 0x70, 0x0C, 0x00, 0x70, 0x07, 0x98, 0x30,
  // "Ú" (U+00DA)
  0x00, 0x05, 0x00, 0x00, 0x63, 0x00, 0x7D, 0x32, 0xC4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A,
  0x00, 0x70, 0x1A, 0x00, 0x70, 0x0C, 0x00, 0x70, 0x07, 0x98, 0x30,
  // "Û" (U+00DB)
  0x00, 0x07, 0x00, 0x00, 0x56, 0x50, 0x7D, 0x32, 0xC4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A,
  0x00, 0x70, 0x1A, 0x00, 0x70, 0x0C, 0x00, 0x70, 0x07, 0x98, 0x30,
  // "Ü" (U+00DC)
  0x00, 0x72, 0x40, 0x7D, 0x32, 0xC4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A,
  0x00, 0x70, 0x0C, 0x00, 0x70, 0x07, 0x98, 0x30,
  // "Ý" (U+00DD)
  0x30, 0x53, 0x89, 0x76, 0x30, 0xBB, 0x08, 0xB1, 0xB0, 0x61, 0x09, 0x37, 0x28, 0x12, 0xC3, 0x30,
  0xC4, 0x0C, 0x38, 0x15, 0xE5, 0x10,
  // "Þ" (U+00DE)
  0x5F, 0x50, 0x00, 0xC0, 0x00, 0x0D, 0x67, 0x00, 0xC0, 0x66, 0x0C, 0x07, 0x50, 0xD6, 0x60, 0x5E,
  0x40, 0x00,
  // "ß" (U+00DF)
  0x07, 0x69, 0x00, 0xB0, 0x64, 0x5A, 0x58, 0x21, 0xA9, 0x30, 0x1A, 0x2C, 0x51, 0xA3, 0x0B, 0x6A,
  0x75, 0x70,
  // "à" (U+00E0)
  0x04, 0x20, 0x00, 0x17, 0x00, 0x00, 0x00, 0x01, 0xA9, 0x40, 0x13, 0x19, 0x01, 0x77, 0x90, 0x83,
  0x29, 0x04, 0xA6, 0xC1,
  // "á" (U+00E1)
  0x30, 0x53, 0x06, 0x03, 0x68, 0xA7, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90,
  0x4A, 0x6C, 0x10,
  // "â" (U+00E2)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x8A, 0x71, 0xA9, 0x40, 0x13, 0x19, 0x01, 0x77, 0x90, 0x83, 0x29,
  0x04, 0xA6, 0xC1,
  // "ã" (U+00E3)
  0x49, 0x61, 0x03, 0x39, 0x00, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90, 0x4A,
  0x6C, 0x10,
  // "ä" (U+00E4)
  0x07, 0x24, 0x00, 0x00, 0x00, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90, 0x4A,
  0x6C, 0x10,
  // "å" (U+00E5)
  0x03, 0x70, 0x00, 0x73, 0x30, 0x03, 0x70, 0x01, 0xA9, 0x40, 0x13, 0x19, 0x01, 0x77, 0x90, 0x83,
  0x29, 0x04, 0xA6, 0xC1,
  // "æ" (U+00E6)
  0x1A, 0x99, 0x79, 0x01, 0x31, 0xC0, 0x83, 0x28, 0x8C, 0x79, 0x38, 0x32, 0xC0, 0x00, 0x4A, 0x77,
  0x88, 0x00,
  // "ç" (U+00E7)
  0x19, 0x85, 0x64, 0x13, 0x83, 0x00, 0x65, 0x00, 0x1A, 0xF5, 0x00, 0x81, 0x04, 0x80,
  // "è" (U+00E8)
  0x04, 0x20, 0x01, 0x70, 0x00, 0x00, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "é" (U+00E9)
  0x00, 0x05, 0x00, 0x63, 0x00, 0x00, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "ê" (U+00EA)
  0x00, 0x70, 0x05, 0x65, 0x00, 0x00, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "ë" (U+00EB)
  0x07, 0x24, 0x00, 0x00, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "ì" (U+00EC)
  0x42, 0x01, 0x70, 0x00, 0x06, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "í" (U+00ED)
  0x00, 0x50, 0x63, 0x00, 0x06, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "î" (U+00EE)
  0x07, 0x05, 0x65, 0x00, 0x06, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "ï" (U+00EF)
  0x72, 0x40, 0x00, 0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x6D, 0x30,
  // "ð" (U+00F0)
  0x06, 0x84, 0x00, 0x47, 0x50, 0x07, 0x7C, 0x05, 0x50, 0xB1, 0x83, 0x09, 0x26, 0x40, 0xA0, 0x19,
  0x76, 0x00,
  // "ñ" (U+00F1)
  0x04, 0x96, 0x10, 0x33, 0x90, 0x6B, 0x8B, 0x01, 0xC0, 0x74, 0x1A, 0x07, 0x41, 0xA0, 0x74, 0x6D,
  0x27, 0x90,
  // "ò" (U+00F2)
  0x04, 0x20, 0x00, 0x17, 0x00, 0x00, 0x00, 0x01, 0x97, 0x60, 0x65, 0x0A, 0x08, 0x30, 0x92, 0x65,
  0x0A, 0x01, 0x97, 0x70,
  // "ó" (U+00F3)
  0x30, 0x53, 0x06, 0x03, 0x68, 0xA6, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0,
  0x19, 0x77, 0x10,
  // "ô" (U+00F4)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x8A, 0x61, 0x97, 0x60, 0x65, 0x0A, 0x08, 0x30, 0x92, 0x65, 0x0A,
  0x01, 0x97, 0x71,
  // "õ" (U+00F5)
  0x04, 0x96, 0x10, 0x33, 0x90, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0, 0x19,
  0x77, 0x00,
  // "ö" (U+00F6)
  0x07, 0x24, 0x00, 0x00, 0x00, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0, 0x19,
  0x77, 0x00,
  // "÷" (U+00F7)
  0x01, 0x70, 0x48, 0x88, 0x00, 0x00, 0x01, 0x70,
  // "ø" (U+00F8)
  0x38, 0xB3, 0x30, 0x19, 0x7A, 0x06, 0x55, 0xC0, 0x84, 0x69, 0x27, 0xA1, 0xA0, 0x2B, 0x77, 0x02,
  0x13,
  // "ù" (U+00F9)
  0x04, 0x20, 0x00, 0x17, 0x00, 0x00, 0x00, 0x07, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A,
  0x09, 0x30, 0xA8, 0xA8,
  // "ú" (U+00FA)
  0x30, 0x53, 0x06, 0x03, 0x68, 0xA7, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93,
  0x0A, 0x8A, 0x80,
  // "û" (U+00FB)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x8A, 0x77, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A, 0x09,
  0x30, 0xA8, 0xA8,
  // "ü" (U+00FC)
  0x07, 0x24, 0x00, 0x00, 0x00, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93, 0x0A,
  0x8A, 0x80,
  // "ý" (U+00FD)
  0x30, 0x53, 0x06, 0x03, 0x68, 0x7A, 0xA0, 0xC3, 0x29, 0x07, 0x28, 0x1B, 0x16, 0x28, 0x16, 0xA1,
  0x30, 0xB3, 0x02, 0x06, 0x20, 0x50, 0x93,
  // "þ" (U+00FE)
  0x79, 0x00, 0x02, 0x90, 0x00, 0x2B, 0x8A, 0x02, 0xB0, 0x65, 0x29, 0x04, 0x62, 0xB0, 0x65, 0x2C,
  0x8A, 0x02, 0x90, 0x00, 0x7C, 0x10, 0x00,
  // "ÿ" (U+00FF)
  0x18, 0x17, 0x24, 0x68, 0x7A, 0xA0, 0xC3, 0x29, 0x07, 0x28, 0x1B, 0x16, 0x28, 0x16, 0xA1, 0x30,
  0xB3, 0x02, 0x06, 0x20, 0x50, 0x93,
  // "Ā" (U+0100)
  0x06, 0xFA, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07, 0x0A, 0x30, 0x0A, 0x7A, 0x70, 0x25,
  0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "ā" (U+0101)
  0x06, 0x85, 0x01, 0xA9, 0x40, 0x13, 0x19, 0x01, 0x77, 0x90, 0x83, 0x29, 0x04, 0xA6, 0xC1,
  // "Ă" (U+0102)
  0x04, 0x04, 0x00, 0x04, 0xF7, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07, 0x0A, 0x30, 0x0A,
  0x7A, 0x70, 0x25, 0x01, 0xB0, 0xA9, 0x03, 0xE4,
  // "ă" (U+0103)
  0x04, 0x04, 0x00, 0x4B, 0x20, 0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90, 0x4A,
  0x6C, 0x10,
  // "Ą" (U+0104)
  0x00, 0x94, 0x00, 0x00, 0xA9, 0x00, 0x03, 0x4C, 0x00, 0x07, 0x0A, 0x30, 0x0A, 0x7A, 0x70, 0x25,
  0x01, 0xB0, 0xA9, 0x03, 0xF4, 0x00, 0x07, 0x20, 0x00, 0x04, 0x90,
  // "ą" (U+0105)
  0x1A, 0x94, 0x01, 0x31, 0x90, 0x17, 0x79, 0x08, 0x32, 0x90, 0x4A, 0x6E, 0x10, 0x07, 0x20, 0x00,
  0x49, 0x00,
  // "Ć" (U+0106)
  0x00, 0x05, 0x00, 0x06, 0x30, 0x06, 0x8A, 0x52, 0xA0, 0x15, 0x66, 0x00, 0x08, 0x50, 0x00, 0x77,
  0x00, 0x02, 0xB0, 0x01, 0x07, 0xA9, 0x40,
  // "ć" (U+0107)
  0x00, 0x05, 0x00, 0x63, 0x00, 0x00, 0x19, 0x85, 0x64, 0x13, 0x83, 0x00, 0x65, 0x00, 0x1A, 0x85,
  // "Ĉ" (U+0108)
  0x00, 0x70, 0x00, 0x56, 0x50, 0x06, 0x8A, 0x52, 0xA0, 0x15, 0x66, 0x00, 0x08, 0x50, 0x00, 0x77,
  0x00, 0x02, 0xB0, 0x01, 0x07, 0xA9, 0x40,
  // "ĉ" (U+0109)
  0x00, 0x70, 0x05, 0x65, 0x00, 0x00, 0x19, 0x85, 0x64, 0x13, 0x83, 0x00, 0x65, 0x00, 0x1A, 0x85,
  // "Ċ" (U+010A)
  0x00, 0x61, 0x00, 0x68, 0xA5, 0x2A, 0x01, 0x56, 0x60, 0x00, 0x85, 0x00, 0x07, 0x70, 0x00, 0x2B,
  0x00, 0x10, 0x7A, 0x94,
  // "ċ" (U+010B)
  0x06, 0x10, 0x00, 0x00, 0x19, 0x85, 0x64, 0x13, 0x83, 0x00, 0x65, 0x00, 0x1A, 0x85,
  // "Č" (U+010C)
  0x03, 0x03, 0x00, 0x2D, 0x20, 0x06, 0x8A, 0x52, 0xA0, 0x15, 0x66, 0x00, 0x08, 0x50, 0x00, 0x77,
  0x00, 0x02, 0xB0, 0x01, 0x07, 0xA9, 0x40,
  // "č" (U+010D)
  0x03, 0x03, 0x02, 0xD2, 0x00, 0x00, 0x19, 0x85, 0x64, 0x13, 0x83, 0x00, 0x65, 0x00, 0x1A, 0x85,
  // "Ď" (U+010E)
  0x03, 0x03, 0x00, 0x02, 0xD2, 0x00, 0x5E, 0x68, 0x30, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0x93, 0x0C,
  0x00, 0x85, 0x0C, 0x00, 0x94, 0x0C, 0x00, 0xC0, 0x5E, 0x69, 0x40,
  // "ď" (U+010F)
  0x00, 0x2D, 0x63, 0x00, 0x0A, 0x30, 0x1A, 0x8C, 0x00, 0x65, 0x0C, 0x00, 0x83, 0x0B, 0x00, 0x65,
  0x0C, 0x00, 0x1A, 0x8B, 0x60,
  // "Đ" (U+0110)
  0x5E, 0x68, 0x30, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0x93, 0x4D, 0x71, 0x85, 0x0C, 0x00, 0x94, 0x0C,
  0x00, 0xC0, 0x5E, 0x69, 0x40,
  // "đ" (U+0111)
  0x00, 0x2D, 0x00, 0x06, 0xC5, 0x1A, 0x8C, 0x06, 0x50, 0xC0, 0x83, 0x0B, 0x07, 0x50, 0xC0, 0x1A,
  0x8B, 0x60,
  // "Ē" (U+0112)
  0x5F, 0xEE, 0x50, 0xC0, 0x03, 0x0C, 0x00, 0x00, 0xD7, 0x50, 0x0C, 0x00, 0x00, 0xC0, 0x04, 0x5E,
  0x67, 0x90,
  // "ē" (U+0113)
  0x06, 0x85, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "Ĕ" (U+0114)
  0x04, 0x04, 0x05, 0xFF, 0xC5, 0x0C, 0x00, 0x30, 0xC0, 0x00, 0x0D, 0x75, 0x00, 0xC0, 0x00, 0x0C,
  0x00, 0x45, 0xE6, 0x79,
  // "ĕ" (U+0115)
  0x04, 0x04, 0x04, 0xB2, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "Ė" (U+0116)
  0x00, 0x61, 0x05, 0xE6, 0x95, 0x0C, 0x00, 0x30, 0xC0, 0x00, 0x0D, 0x75, 0x00, 0xC0, 0x00, 0x0C,
  0x00, 0x45, 0xE6, 0x79,
  // "ė" (U+0117)
  0x06, 0x10, 0x00, 0x00, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "Ę" (U+0118)
  0x85, 0x5E, 0x69, 0x50, 0xC2, 0x81, 0x30, 0xC4, 0x81, 0xD7, 0x52, 0x0C, 0x40, 0xC2, 0x84, 0x45,
  0xE6, 0x7A, 0x30, 0x94, 0x00, 0x70,
  // "ę" (U+0119)
  0x19, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x0A, 0x96, 0x00, 0x80, 0x00, 0xB4,
  // "Ě" (U+011A)
  0x03, 0x03, 0x00, 0x2D, 0x20, 0x5E, 0x69, 0x50, 0xC0, 0x03, 0x0C, 0x00, 0x00, 0xD7, 0x50, 0x0C,
  0x00, 0x00, 0xC0, 0x04, 0x5E, 0x67, 0x90,
  // "ě" (U+011B)
  0x03, 0x03, 0x02, 0xD2, 0x00, 0x00, 0x1A, 0x94, 0x65, 0x0B, 0x89, 0x79, 0x65, 0x00, 0x09, 0x85,
  // "Ĝ" (U+011C)
  0x00, 0x07, 0x00, 0x00, 0x56, 0x50, 0x05, 0x88, 0x90, 0x2A, 0x00, 0x90, 0x66, 0x00, 0x00, 0x85,
  0x00, 0x00, 0x66, 0x03, 0xA4, 0x2B, 0x00, 0xC0, 0x05, 0x97, 0xA0,
  // "ĝ" (U+011D)
  0x00, 0x70, 0x00, 0x56, 0x50, 0x00, 0x00, 0x02, 0xBA, 0xA1, 0x65, 0x56, 0x00, 0xA8, 0x10, 0x34,
  0x00, 0x01, 0xDC, 0x70, 0x90, 0x0B, 0x07, 0x77, 0x60,
  // "Ğ" (U+011E)
  0x00, 0x40, 0x40, 0x05, 0xCF, 0xC0, 0x2A, 0x00, 0x90, 0x66, 0x00, 0x00, 0x85, 0x00, 0x00, 0x66,
  0x03, 0xA4, 0x2B, 0x00, 0xC0, 0x05, 0x97, 0xA0,
  // "ğ" (U+011F)
  0x04, 0x04, 0x00, 0x4B, 0x20, 0x2B, 0xAA, 0x16, 0x55, 0x60, 0x0A, 0x81, 0x03, 0x40, 0x00, 0x1D,
  0xC7, 0x09, 0x00, 0xB0, 0x77, 0x76, 0x00,
  // "Ġ" (U+0120)
  0x00, 0x61, 0x00, 0x05, 0x88, 0x90, 0x2A, 0x00, 0x90, 0x66, 0x00, 0x00, 0x85, 0x00, 0x00, 0x66,
  0x03, 0xA4, 0x2B, 0x00, 0xC0, 0x05, 0x97, 0xA0,
  // "ġ" (U+0121)
  0x06, 0x10, 0x00, 0x00, 0x00, 0x2B, 0xAA, 0x16, 0x55, 0x60, 0x0A, 0x81, 0x03, 0x40, 0x00, 0x1D,
  0xC7, 0x09, 0x00, 0xB0, 0x77, 0x76, 0x00,
  // "Ģ" (U+0122)
  0x18, 0x55, 0x88, 0x90, 0x2A, 0x28, 0x29, 0x06, 0x64, 0x08, 0x05, 0x48, 0x66, 0x60, 0x3A, 0x42,
  0xB2, 0x0C, 0x28, 0x25, 0x97, 0xA7, 0x20, 0x50, 0x44, 0x01, 0x30,
  // "ģ" (U+0123)
  0x00, 0x70, 0x00, 0x13, 0x00, 0x2B, 0xAA, 0x16, 0x55, 0x60, 0x0A, 0x81, 0x03, 0x40, 0x00, 0x1D,
  0xC7, 0x09, 0x00, 0xB0, 0x77, 0x76, 0x00,
  // "Ĥ" (U+0124)
  0x00, 0x07, 0x00, 0x00, 0x56, 0x50, 0x5E, 0x41, 0xCA, 0x0C, 0x00, 0x84, 0x0C, 0x00, 0x84, 0x0D,
  0x77, 0xB4, 0x0C, 0x00, 0x84, 0x0C, 0x00, 0x84, 0x5E, 0x41, 0xC9,
  // "ĥ" (U+0125)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x07, 0x09, 0x30, 0x20, 0x93, 0x8A, 0x72, 0xB8, 0xA0, 0x2A, 0x08,
  0x22, 0x90, 0x83, 0x29, 0x08, 0x37, 0xC1, 0x88,
  // "Ħ" (U+0126)
  0x5F, 0x41, 0xCA, 0x0C, 0x00, 0x84, 0x5D, 0x77, 0xB9, 0x0D, 0x77, 0xB4, 0x0C, 0x00, 0x84, 0x0C,
  0x00, 0x84, 0x5E, 0x41, 0xC9,
  // "ħ" (U+0127)
  0x89, 0x00, 0x06, 0xB5, 0x00, 0x2C, 0x8A, 0x02, 0xA0, 0x92, 0x29, 0x08, 0x32, 0x90, 0x83, 0x7C,
  0x18, 0x80,
  // "Ĩ" (U+0128)
  0x49, 0x61, 0x9F, 0xE0, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x5E, 0x40,
  // "ĩ" (U+0129)
  0x49, 0x61, 0x33, 0x90, 0x06, 0xA0, 0x01, 0xA0, 0x01, 0xA0, 0x01, 0xA0, 0x06, 0xD3,
  // "Ī" (U+012A)
  0xBF, 0xA0, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x5E, 0x40,
  // "ī" (U+012B)
  0x68, 0x56, 0xA0, 0x1A, 0x01, 0xA0, 0x1A, 0x06, 0xD3,
  // "Ĭ" (U+012C)
  0x40, 0x49, 0xF7, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x05, 0xE4,
  // "ĭ" (U+012D)
  0x40, 0x44, 0xB2, 0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x6D, 0x30,
  // "Į" (U+012E)
  0x5E, 0x40, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x5F, 0x50, 0x90, 0x07, 0x70,
  // "į" (U+012F)
  0x19, 0x00, 0x00, 0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x7E, 0x39, 0x00, 0x77, 0x00,
  // "İ" (U+0130)
  0x06, 0x15, 0xE4, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x05, 0xE4,
  // "ı" (U+0131)
  0x6A, 0x01, 0xA0, 0x1A, 0x01, 0xA0, 0x6D, 0x30,
  // "Ĳ" (U+0132)
  0x5E, 0x45, 0xE4, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C,
  0x00, 0xC0, 0x5E, 0x40, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x09, 0x50,
  // "ĳ" (U+0133)
  0x19, 0x02, 0x80, 0x00, 0x00, 0x6A, 0x07, 0x91, 0xA0, 0x29, 0x1A, 0x02, 0x91, 0xA0, 0x29, 0x6D,
  0x32, 0x90, 0x00, 0x38, 0x00, 0x09, 0x30,
  // "Ĵ" (U+0134)
  0x07, 0x05, 0x65, 0x5E, 0x40, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x0C, 0x00, 0xC0, 0x95,
  0x00,
  // "ĵ" (U+0135)
  0x07, 0x05, 0x65, 0x00, 0x07, 0x90, 0x29, 0x02, 0x90, 0x29, 0x02, 0x90, 0x38, 0x09, 0x30,
  // "Ķ" (U+0136)
  0x89, 0x15, 0xE4, 0x3D, 0x20, 0xC0, 0x62, 0x28, 0x1C, 0x26, 0x38, 0x1D, 0xB6, 0x38, 0x2D, 0x2D,
  0x12, 0x89, 0x1C, 0x06, 0x90, 0x5E, 0x40, 0xB6, 0x71, 0x05, 0x04, 0x40, 0x13,
  // "ķ" (U+0137)
  0x07, 0x09, 0x30, 0x20, 0x93, 0x8A, 0x72, 0x92, 0xD3, 0x29, 0x92, 0x02, 0xED, 0x10, 0x29, 0x59,
  0x07, 0xC1, 0xA5, 0x60, 0x50, 0x43, 0x01, 0x30,
  // "ĸ" (U+0138)
  0x79, 0x2D, 0x32, 0x99, 0x20, 0x2E, 0xD1, 0x02, 0x95, 0x90, 0x7C, 0x1A, 0x50,
  // "Ĺ" (U+0139)
  0x20, 0x53, 0x06, 0x03, 0x28, 0x15, 0xE4, 0x30, 0xC4, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC2, 0x84,
  0x75, 0xE6, 0x79,
  // "ĺ" (U+013A)
  0x00, 0x50, 0x63, 0x00, 0x07, 0x90, 0x29, 0x02, 0x90, 0x29, 0x02, 0x90, 0x29, 0x07, 0xC2,
  // "Ļ" (U+013B)
  0x81, 0x5E, 0x43, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC4, 0x0C, 0x28, 0x47, 0x5E, 0x67, 0x97, 0x05,
  0x04, 0x30, 0x12,
  // "ļ" (U+013C)
  0x79, 0x02, 0x90, 0x29, 0x02, 0x90, 0x29, 0x02, 0x90, 0x7C, 0x20, 0x00, 0x54, 0x01, 0x00,
  // "Ľ" (U+013D)
  0x87, 0x5E, 0x47, 0x20, 0xC0, 0x22, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC2, 0x84, 0x75, 0xE6, 0x79,
  // "ľ" (U+013E)
  0x79, 0x92, 0x92, 0x29, 0x02, 0x90, 0x29, 0x02, 0x90, 0x7C, 0x20,
  // "Ŀ" (U+013F)
  0x81, 0x5E, 0x43, 0x0C, 0x40, 0xC4, 0x84, 0xC0, 0x61, 0x0C, 0x40, 0xC2, 0x84, 0x75, 0xE6, 0x79,
  // "ŀ" (U+0140)
  0x79, 0x00, 0x29, 0x00, 0x29, 0x00, 0x29, 0x61, 0x29, 0x00, 0x29, 0x00, 0x7C, 0x20,
  // "Ł" (U+0141)
  0x5E, 0x40, 0x00, 0xC0, 0x00, 0x0C, 0x51, 0x00, 0xD3, 0x00, 0x5C, 0x00, 0x00, 0xC0, 0x07, 0x5E,
  0x67, 0x90,
  // "ł" (U+0142)
  0x6B, 0x00, 0xB0, 0x0B, 0x00, 0xD3, 0x5B, 0x00, 0xB0, 0x6D, 0x30,
  // "Ń" (U+0143)
  0x00, 0x05, 0x00, 0x00, 0x63, 0x00, 0x5E, 0x10, 0xA7, 0x0C, 0x80, 0x51, 0x07, 0xC1, 0x51, 0x07,
  0x49, 0x51, 0x07, 0x0B, 0x71, 0x07, 0x03, 0xE1, 0x5C, 0x10, 0xB1,
  // "ń" (U+0144)
  0x30, 0x53, 0x06, 0x03, 0x68, 0xA7, 0x6B, 0x8B, 0x01, 0xC0, 0x74, 0x1A, 0x07, 0x41, 0xA0, 0x74,
  0x6D, 0x27, 0x90,
  // "Ņ" (U+0145)
  0x8D, 0x05, 0xE1, 0x0A, 0x70, 0xC8, 0x05, 0x10, 0x7C, 0x15, 0x10, 0x74, 0x95, 0x10, 0x70, 0xB7,
  0x10, 0x70, 0x3E, 0x15, 0xC1, 0x0B, 0x17, 0x10, 0x50, 0x44, 0x01, 0x30,
  // "ņ" (U+0146)
  0x8A, 0x76, 0xB8, 0xB0, 0x1C, 0x07, 0x41, 0xA0, 0x74, 0x1A, 0x07, 0x46, 0xD2, 0x79, 0x70, 0x50,
  0x43, 0x01, 0x20,
  // "Ň" (U+0147)
  0x00, 0x30, 0x30, 0x00, 0x2D, 0x20, 0x5E, 0x10, 0xA7, 0x0C, 0x80, 0x51, 0x07, 0xC1, 0x51, 0x07,
  0x49, 0x51, 0x07, 0x0B, 0x71, 0x07, 0x03, 0xE1, 0x5C, 0x10, 0xB1,
  // "ň" (U+0148)
  0x03, 0x03, 0x00, 0x2D, 0x20, 0x00, 0x00, 0x06, 0xB8, 0xB0, 0x1C, 0x07, 0x41, 0xA0, 0x74, 0x1A,
  0x07, 0x46, 0xD2, 0x79,
  // "ŉ" (U+0149)
  0x76, 0x00, 0x00, 0x26, 0x00, 0x00, 0x46, 0xB8, 0xB0, 0x01, 0xC0, 0x74, 0x01, 0xA0, 0x74, 0x01,
  0xA0, 0x74, 0x06, 0xD2, 0x79,
  // "Ŋ" (U+014A)
  0x5E, 0x10, 0xB8, 0x0C, 0x80, 0x51, 0x07, 0xC2, 0x51, 0x07, 0x4A, 0x51, 0x07, 0x0B, 0x91, 0x07,
  0x03, 0xF1, 0x5C, 0x20, 0xA1, 0x00, 0x00, 0x61, 0x00, 0x01, 0x80,
  // "ŋ" (U+014B)
  0x6B, 0x8B, 0x01, 0xC0, 0x74, 0x1A, 0x07, 0x41, 0xA0, 0x74, 0x7D, 0x27, 0x40, 0x00, 0x73, 0x00,
  0x2A, 0x00,
  // "Ō" (U+014C)
  0x0C, 0xFE, 0x50, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85, 0x00, 0x67, 0x76, 0x00, 0x75, 0x2A,
  0x00, 0xB1, 0x06, 0x88, 0x50,
  // "ō" (U+014D)
  0x06, 0x85, 0x01, 0x97, 0x60, 0x65, 0x0A, 0x08, 0x30, 0x92, 0x65, 0x0A, 0x01, 0x97, 0x70,
  // "Ŏ" (U+014E)
  0x00, 0x40, 0x40, 0x06, 0xCF, 0x80, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85, 0x00, 0x67, 0x76,
  0x00, 0x75, 0x2A, 0x00, 0xB1, 0x06, 0x88, 0x50,
  // "ŏ" (U+014F)
  0x04, 0x04, 0x00, 0x4B, 0x20, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0, 0x19,
  0x77, 0x00,
  // "Ő" (U+0150)
  0x04, 0x7A, 0x10, 0x08, 0x89, 0x50, 0x3A, 0x00, 0xB1, 0x76, 0x00, 0x75, 0x85, 0x00, 0x67, 0x76,
  0x00, 0x75, 0x2A, 0x00, 0xB1, 0x06, 0x88, 0x50,
  // "ő" (U+0151)
  0x04, 0x7A, 0x10, 0x10, 0x00, 0x19, 0x76, 0x06, 0x50, 0xA0, 0x83, 0x09, 0x26, 0x50, 0xA0, 0x19,
  0x77, 0x00,
  // "Œ" (U+0152)
  0x06, 0x9A, 0xC8, 0xD0, 0x3A, 0x03, 0x80, 0x40, 0x76, 0x03, 0x80, 0x00, 0x85, 0x03, 0xB7, 0x30,
  0x76, 0x03, 0x80, 0x00, 0x2A, 0x03, 0x80, 0x12, 0x06, 0x89, 0xB7, 0xA4,
  // "œ" (U+0153)
  0x19, 0x76, 0x88, 0x46, 0x50, 0xB4, 0x0B, 0x83, 0x09, 0x87, 0x96, 0x50, 0xB4, 0x00, 0x19, 0x77,
  0x98, 0x50,
  // "Ŕ" (U+0154)
  0x00, 0x05, 0x00, 0x00, 0x63, 0x00, 0x5E, 0x69, 0x10, 0x0C, 0x05, 0x70, 0x0C, 0x07, 0x40, 0x0D,
  0x88, 0x00, 0x0C, 0x1C, 0x00, 0x0C, 0x09, 0x40, 0x5E, 0x42, 0xB2,
  // "ŕ" (U+0155)
  0x00, 0x50, 0x06, 0x30, 0x00, 0x00, 0x6A, 0xA7, 0x1D, 0x01, 0x1B, 0x00, 0x1A, 0x00, 0x6D, 0x30,
  // "Ŗ" (U+0156)
  0x83, 0x5E, 0x69, 0x12, 0x82, 0xC0, 0x57, 0x28, 0x2C, 0x07, 0x42, 0x81, 0xD8, 0x83, 0x81, 0xC1,
  0xC3, 0x89, 0x1C, 0x09, 0x40, 0x5E, 0x42, 0xB2, 0x71, 0x05, 0x04, 0x40, 0x13,
  // "ŗ" (U+0157)
  0x6A, 0xA7, 0x1D, 0x01, 0x1B, 0x00, 0x1A, 0x00, 0x6D, 0x30, 0x00, 0x00, 0x54, 0x00, 0x10, 0x00,
  // "Ř" (U+0158)
  0x03, 0x03, 0x00, 0x02, 0xD2, 0x00, 0x5E, 0x69, 0x10, 0x0C, 0x05, 0x70, 0x0C, 0x07, 0x40, 0x0D,
  0x88, 0x00, 0x0C, 0x1C, 0x00, 0x0C, 0x09, 0x40, 0x5E, 0x42, 0xB2,
  // "ř" (U+0159)
  0x30, 0x30, 0x2D, 0x20, 0x00, 0x00, 0x6A, 0xA7, 0x1D, 0x01, 0x1B, 0x00, 0x1A, 0x00, 0x6D, 0x30,
  // "Ś" (U+015A)
  0x00, 0x50, 0x06, 0x30, 0x18, 0x86, 0x74, 0x05, 0x5A, 0x00, 0x09, 0xD3, 0x00, 0x3C, 0x70, 0x0B,
  0x49, 0x75,
  // "ś" (U+015B)
  0x00, 0x50, 0x06, 0x30, 0x00, 0x00, 0x47, 0xA0, 0x84, 0x20, 0x1B, 0x90, 0x30, 0x83, 0x66, 0x90,
  // "Ŝ" (U+015C)
  0x00, 0x70, 0x05, 0x65, 0x18, 0x86, 0x74, 0x05, 0x5A, 0x00, 0x09, 0xD3, 0x00, 0x3C, 0x70, 0x0B,
  0x49, 0x75,
  // "ŝ" (U+015D)
  0x07, 0x00, 0x56, 0x50, 0x00, 0x00, 0x47, 0xA0, 0x84, 0x20, 0x1B, 0x90, 0x30, 0x83, 0x66, 0x90,
  // "Ş" (U+015E)
  0x18, 0x86, 0x74, 0x05, 0x5A, 0x00, 0x09, 0xD3, 0x00, 0x3C, 0x70, 0x0B, 0x49, 0xE5, 0x00, 0x81,
  0x04, 0x80,
  // "ş" (U+015F)
  0x47, 0xA0, 0x84, 0x20, 0x1B, 0x90, 0x30, 0x83, 0x6E, 0x90, 0x08, 0x10, 0x48, 0x00,
  // "Š" (U+0160)
  0x03, 0x03, 0x02, 0xD2, 0x18, 0x86, 0x74, 0x05, 0x5A, 0x00, 0x09, 0xD3, 0x00, 0x3C, 0x70, 0x0B,
  0x49, 0x75,
  // "š" (U+0161)
  0x30, 0x30, 0x2D, 0x20, 0x00, 0x00, 0x47, 0xA0, 0x84, 0x20, 0x1B, 0x90, 0x30, 0x83, 0x66, 0x90,
  // "Ţ" (U+0162)
  0x89, 0x0B, 0x7D, 0x7A, 0x40, 0xC0, 0x42, 0x0C, 0x40, 0xC4, 0x0C, 0x40, 0xC3, 0x81, 0x9F, 0x43,
  0x0A, 0x30, 0x60, 0x52,
  // "ţ" (U+0163)
  0x27, 0x08, 0xB4, 0x38, 0x03, 0x80, 0x38, 0x01, 0xF8, 0x00, 0xA0, 0x65,
  // "Ť" (U+0164)
  0x18, 0x13, 0x03, 0x28, 0x94, 0x2D, 0x20, 0xB7, 0xD7, 0xA4, 0x0C, 0x04, 0x20, 0xC4, 0x0C, 0x40,
  0xC4, 0x0C, 0x38, 0x15, 0xE4, 0x10,
  // "ť" (U+0165)
  0x00, 0x92, 0x72, 0x8B, 0x43, 0x80, 0x38, 0x03, 0x80, 0x1B, 0x40,
  // "Ŧ" (U+0166)
  0xB7, 0xD7, 0xA4, 0x0C, 0x04, 0x00, 0xC0, 0x02, 0x7D, 0x71, 0x00, 0xC0, 0x00, 0x0C, 0x00, 0x05,
  0xE4, 0x00,
  // "ŧ" (U+0167)
  0x27, 0x08, 0xB4, 0x38, 0x07, 0xB3, 0x38, 0x01, 0xB4,
  // "Ũ" (U+0168)
  0x04, 0x96, 0x10, 0x7F, 0x6C, 0xC4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A,
  0x00, 0x70, 0x0C, 0x00, 0x70, 0x07, 0x98, 0x30,
  // "ũ" (U+0169)
  0x04, 0x96, 0x10, 0x33, 0x90, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93, 0x0A,
  0x8A, 0x80,
  // "Ū" (U+016A)
  0x7D, 0x9B, 0xF4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x0C,
  0x00, 0x70, 0x07, 0x98, 0x30,
  // "ū" (U+016B)
  0x06, 0x85, 0x07, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A, 0x09, 0x30, 0xA8, 0xA8,
  // "Ŭ" (U+016C)
  0x00, 0x40, 0x40, 0x7D, 0x7E, 0xF4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A,
  0x00, 0x70, 0x0C, 0x00, 0x70, 0x07, 0x98, 0x30,
  // "ŭ" (U+016D)
  0x04, 0x04, 0x00, 0x4B, 0x20, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93, 0x0A,
  0x8A, 0x80,
  // "Ů" (U+016E)
  0x00, 0x37, 0x00, 0x00, 0x73, 0x30, 0x7D, 0x6A, 0xD4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A,
  0x00, 0x70, 0x1A, 0x00, 0x70, 0x0C, 0x00, 0x70, 0x07, 0x98, 0x30,
  // "ů" (U+016F)
  0x03, 0x70, 0x00, 0x73, 0x30, 0x03, 0x70, 0x07, 0x91, 0xC3, 0x29, 0x08, 0x32, 0x90, 0x83, 0x1A,
  0x09, 0x30, 0xA8, 0xA8,
  // "Ű" (U+0170)
  0x04, 0x7A, 0x10, 0x7F, 0x33, 0xC4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A,
  0x00, 0x70, 0x0C, 0x00, 0x70, 0x07, 0x98, 0x30,
  // "ű" (U+0171)
  0x04, 0x7A, 0x10, 0x10, 0x00, 0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93, 0x0A,
  0x8A, 0x80,
  // "Ų" (U+0172)
  0x7D, 0x32, 0xC4, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x1A, 0x00, 0x70, 0x0C,
  0x00, 0x70, 0x07, 0x99, 0x30, 0x00, 0x90, 0x00, 0x00, 0x77, 0x00,
  // "ų" (U+0173)
  0x79, 0x1C, 0x32, 0x90, 0x83, 0x29, 0x08, 0x31, 0xA0, 0x93, 0x0A, 0x8C, 0x80, 0x07, 0x20, 0x00,
  0x49, 0x00,
  // "Ŵ" (U+0174)
  0x40, 0x77, 0x81, 0x56, 0x53, 0x89, 0x79, 0xC1, 0x1B, 0x04, 0xC1, 0x1B, 0x04, 0xE0, 0x17, 0x28,
  0x5C, 0x07, 0x92, 0x43, 0x28, 0x49, 0x27, 0x56, 0x73, 0x84, 0x66, 0x72, 0xA7, 0x38, 0x42, 0xC4,
  0x0B, 0x74, 0x0E, 0x20, 0xA0, 0x42,
  // "ŵ" (U+0175)
  0x30, 0x75, 0x81, 0x56, 0x57, 0x28, 0xA2, 0xAA, 0x0C, 0x08, 0x83, 0x82, 0xC3, 0x51, 0x0B, 0x63,
  0x87, 0x28, 0x3A, 0x60, 0xA6, 0x28, 0x37, 0x60, 0x94, 0x10,
  // "Ŷ" (U+0176)
  0x20, 0x73, 0x8A, 0x05, 0x65, 0x0B, 0xB0, 0x8B, 0x1B, 0x06, 0x10, 0x93, 0x72, 0x81, 0x2C, 0x33,
  0x0C, 0x40, 0xC3, 0x81, 0x5E, 0x51,
  // "ŷ" (U+0177)
  0x20, 0x73, 0x81, 0x56, 0x56, 0x87, 0xAA, 0x0C, 0x32, 0x90, 0x72, 0x81, 0xB1, 0x62, 0x81, 0x6A,
  0x13, 0x0B, 0x30, 0x20, 0x62, 0x05, 0x09, 0x30,
  // "Ÿ" (U+0178)
  0x07, 0x24, 0x0B, 0xB0, 0x8B, 0x1B, 0x06, 0x10, 0x93, 0x70, 0x02, 0xC3, 0x00, 0x0C, 0x00, 0x00,
  0xC0, 0x00, 0x5E, 0x50,
  // "Ź" (U+0179)
  0x00, 0x05, 0x00, 0x06, 0x30, 0x88, 0x7E, 0x24, 0x03, 0xB0, 0x00, 0xB3, 0x00, 0x3B, 0x00, 0x0A,
  0x30, 0x02, 0xB0, 0x03, 0x9A, 0x79, 0x50,
  // "ź" (U+017A)
  0x00, 0x50, 0x06, 0x30, 0x00, 0x00, 0x78, 0xB7, 0x20, 0xB0, 0x07, 0x50, 0x1B, 0x02, 0x8B, 0x88,
  // "Ż" (U+017B)
  0x00, 0x61, 0x08, 0x87, 0xE2, 0x40, 0x3B, 0x00, 0x0B, 0x30, 0x03, 0xB0, 0x00, 0xA3, 0x00, 0x2B,
  0x00, 0x39, 0xA7, 0x95,
  // "ż" (U+017C)
  0x06, 0x10, 0x00, 0x00, 0x78, 0xB7, 0x20, 0xB0, 0x07, 0x50, 0x1B, 0x02, 0x8B, 0x88,
  // "Ž" (U+017D)
  0x03, 0x03, 0x00, 0x2D, 0x20, 0x88, 0x7E, 0x24, 0x03, 0xB0, 0x00, 0xB3, 0x00, 0x3B, 0x00, 0x0A,
  0x30, 0x02, 0xB0, 0x03, 0x9A, 0x79, 0x50,
  // "ž" (U+017E)
  0x03, 0x03, 0x02, 0xD2, 0x00, 0x00, 0x78, 0xB7, 0x20, 0xB0, 0x07, 0x50, 0x1B, 0x02, 0x8B, 0x88,
  // "ſ" (U+017F)
  0x08, 0x93, 0x19, 0x00, 0x29, 0x00, 0x29, 0x00, 0x29, 0x00, 0x29, 0x00, 0x7C, 0x30,
  // "Ω" (U+03A9)
  0x07, 0x88, 0x70, 0x49, 0x00, 0x94, 0x76, 0x00, 0x67, 0x67, 0x00, 0x66, 0x1B, 0x00, 0xB1, 0x41,
  0x88, 0x24, 0x9B, 0xAA, 0xB9,
  // "μ" (U+03BC)
  0x38, 0x0A, 0x13, 0x80, 0xA1, 0x38, 0x0A, 0x13, 0x90, 0xC1, 0x4C, 0x89, 0x54, 0x50, 0x00, 0x2A,
  0x00, 0x00,
  // "π" (U+03C0)
  0x7D, 0xBD, 0x82, 0x70, 0x70, 0x08, 0x08, 0x00, 0x90, 0x90, 0x66, 0x09, 0x40,
  // "–" (U+2013)
  0x88, 0x88,
  // "—" (U+2014)
  0x80, 0x48,
  // "€" (U+20AC)
  0x03, 0x8A, 0x10, 0xA0, 0x61, 0x0B, 0x00, 0x05, 0xC6, 0x20, 0x5C, 0x60, 0x00, 0xC0, 0x00, 0x04,
  0x98, 0x10,
  // "₿" (U+20BF)
  0x5C, 0x76, 0x01, 0xA0, 0xC0, 0x1A, 0x0B, 0x01, 0xD9, 0x50, 0x1A, 0x0C, 0x01, 0xA0, 0xC1, 0x5C,
  0x68, 0x00, 0x44, 0x00,
  // "‘" (U+2018)
  0x04, 0x61, 0x67,
  // "’" (U+2019)
  0x76, 0x26, 0x40,
  // "‚" (U+201A)
  0x76, 0x25, 0x40,
  // "‛" (U+201B)
  0x67, 0x62, 0x04,
  // "“" (U+201C)
  0x04, 0x22, 0x61, 0x80, 0x67, 0xC1,
  // "”" (U+201D)
  0x76, 0xC1, 0x26, 0x70, 0x41, 0x30,
  // "„" (U+201E)
  0x76, 0xC1, 0x25, 0x70, 0x41, 0x30,
  // "‟" (U+201F)
  0x67, 0xC1, 0x62, 0x80, 0x04, 0x22,
  // "†" (U+2020)
  0x08, 0x20, 0x06, 0x00, 0x7A, 0x73, 0x09, 0x30, 0x08, 0x20, 0x07, 0x00, 0x06, 0x00, 0x05, 0x00,
  // "‡" (U+2021)
  0x08, 0x10, 0x48, 0x51, 0x28, 0x41, 0x06, 0x10, 0x06, 0x00, 0x28, 0x31, 0x59, 0x62, 0x07, 0x10,
  // "•" (U+2022)
  0x29, 0x18, 0xF7, 0x5E, 0x40,
  // "…" (U+2026)
  0x01, 0x01, 0x01, 0x04, 0x80, 0xC0, 0xA1,
  // "‰" (U+2030)
  0x37, 0x60, 0x61, 0x00, 0x00, 0x81, 0xA0, 0x70, 0x00, 0x00, 0x91, 0xB4, 0x30, 0x00, 0x00, 0x72,
  0xA8, 0x36, 0x31, 0x64, 0x16, 0x56, 0xA0, 0xA8, 0x1A, 0x00, 0x70, 0xA0, 0xB9, 0x1B, 0x00, 0x70,
  0x66, 0x64, 0x77,
  // "‹" (U+2039)
  0x03, 0x19, 0x57, 0x08,
  // "›" (U+203A)
  0x20, 0x01, 0x90, 0x0B, 0x13, 0x40,
  // "⁄" (U+2044)
  0x00, 0x08, 0x00, 0x35, 0x00, 0x70, 0x00, 0x70, 0x06, 0x10, 0x08, 0x00, 0x34, 0x00,
  // "™" (U+2122)
  0xAE, 0xBC, 0x0B, 0x41, 0x71, 0xB9, 0xC0, 0x3E, 0x4A, 0xAC, 0x40,
  // "⅒" (U+2152)
  0x40, 0x84, 0x83, 0x3A, 0x03, 0x55, 0x81, 0xB0, 0x76, 0x89, 0x7B, 0x07, 0x3A, 0x26, 0x42, 0x89,
  0x10, 0xBA, 0x1A, 0x20, 0x82, 0x89, 0x3B, 0x91, 0xA0, 0x34, 0x02, 0x85, 0x63,
  // "ﬁ" (U+FB01)
  0x06, 0x6A, 0x30, 0x0B, 0x01, 0x00, 0x4D, 0x69, 0x60, 0x0B, 0x04, 0x60, 0x0B, 0x04, 0x60, 0x0B,
  0x04, 0x60, 0x6D, 0x3A, 0xB1,
  // "ﬂ" (U+FB02)
  0x07, 0x6B, 0x60, 0x0B, 0x05, 0x60, 0x4D, 0x54, 0x60, 0x0B, 0x04, 0x60, 0x0B, 0x04, 0x60, 0x0B,
  0x04, 0x60, 0x6D, 0x3A, 0xB1,
};

const Font& font_NotoSerif_Regular_8() {
  static SmoothFont font(font_NotoSerif_Regular_8_data);
  return font;
}

}  // namespace roo_display
