#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Regular (Noto Serif Regular)
// Generated on Wed Nov 19 19:11:28 CET 2025
static const uint8_t font_NotoSerif_Regular_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x06, 0x2D,
  0xFE, 0xFE, 0x0C, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0D, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x41, 0x01, 0x02, 0x08, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x40, 0x06, 0x03, 0x08, 0x04, 0x00, 0x08, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0x0E, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x08, 0x06, 0x00, 0x26, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x08, 0x08, 0x09, 0x00, 0x3D, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x07, 0x08, 0x07, 0x00, 0x61, // "&" (U+0026)
  0x00, 0x27, 0x40, 0x06, 0x01, 0x08, 0x02, 0x00, 0x81, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x03, 0x08, 0x03, 0x00, 0x84, // "(" (U+0028)
  0x00, 0x29, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x00, 0x96, // ")" (U+0029)
  0x00, 0x2A, 0x40, 0x04, 0x04, 0x08, 0x05, 0x00, 0xA5, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x03, 0x04, 0x07, 0x06, 0x00, 0xB2, // "+" (U+002B)
  0x00, 0x2C, 0x40, 0xFF, 0x01, 0x01, 0x03, 0x00, 0xBF, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x03, 0x00, 0xC2, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x02, 0x03, 0x00, 0xC4, // "." (U+002E)
  0x00, 0x2F, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x00, 0xC6, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x05, 0x08, 0x06, 0x00, 0xD5, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x04, 0x08, 0x06, 0x00, 0xED, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x08, 0x06, 0x01, 0x01, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x08, 0x06, 0x01, 0x15, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x29, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x08, 0x06, 0x01, 0x41, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x08, 0x06, 0x01, 0x55, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x04, 0x08, 0x06, 0x01, 0x69, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x05, 0x08, 0x06, 0x01, 0x7D, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x08, 0x06, 0x01, 0x95, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x06, 0x03, 0x01, 0xA9, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x01, 0xAF, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x04, 0x06, 0x06, 0x01, 0xBB, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x04, 0x05, 0x06, 0x01, 0xC8, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x06, 0x06, 0x01, 0xCF, // ">" (U+003E)
  0x00, 0x3F, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0xDB, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x08, 0x08, 0x09, 0x01, 0xEF, // "@" (U+0040)
  0x00, 0x41, 0x40, 0x01, 0x06, 0x08, 0x07, 0x02, 0x1A, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x05, 0x08, 0x07, 0x02, 0x36, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x4E, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x06, 0x08, 0x07, 0x02, 0x66, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x82, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x9A, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x06, 0x08, 0x07, 0x02, 0xB2, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x07, 0x08, 0x08, 0x02, 0xCE, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x03, 0x08, 0x04, 0x02, 0xEE, // "I" (U+0049)
  0x00, 0x4A, 0x40, 0xFE, 0x03, 0x08, 0x04, 0x02, 0xFE, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x06, 0x08, 0x07, 0x03, 0x14, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0x30, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x08, 0x08, 0x09, 0x03, 0x48, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x07, 0x08, 0x08, 0x03, 0x6C, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x06, 0x08, 0x07, 0x03, 0x8C, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xA8, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x03, 0xC0, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x06, 0x08, 0x07, 0x03, 0xE6, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x08, 0x05, 0x04, 0x02, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0x16, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x06, 0x08, 0x07, 0x04, 0x2E, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x06, 0x08, 0x07, 0x04, 0x4A, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x0A, 0x08, 0x0A, 0x04, 0x66, // "W" (U+0057)
  0x00, 0x58, 0x40, 0x01, 0x06, 0x08, 0x07, 0x04, 0x92, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x06, 0x08, 0x06, 0x04, 0xAE, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x05, 0x08, 0x06, 0x04, 0xC8, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFF, 0x03, 0x08, 0x04, 0x04, 0xE0, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x04, 0xED, // "\" (U+005C)
  0x00, 0x5D, 0x40, 0xFF, 0x02, 0x08, 0x04, 0x04, 0xFC, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x04, 0x08, 0x06, 0x05, 0x0B, // "^" (U+005E)
  0x00, 0x5F, 0x40, 0xFF, 0x04, 0xFF, 0x05, 0x05, 0x18, // "_" (U+005F)
  0x00, 0x60, 0x40, 0x08, 0x02, 0x09, 0x03, 0x05, 0x1B, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x05, 0x06, 0x06, 0x05, 0x1E, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0x30, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x48, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0x57, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x6F, // "e" (U+0065)
  0x00, 0x66, 0x40, 0x01, 0x04, 0x08, 0x04, 0x05, 0x7E, // "f" (U+0066)
  0x00, 0x67, 0x40, 0xFE, 0x05, 0x06, 0x05, 0x05, 0x92, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0xAD, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x08, 0x03, 0x05, 0xC5, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFE, 0x01, 0x08, 0x03, 0x05, 0xD1, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x05, 0x08, 0x06, 0x05, 0xE2, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x08, 0x03, 0x05, 0xFA, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x09, 0x06, 0x09, 0x06, 0x06, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x06, 0x06, 0x06, 0x06, 0x24, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0x39, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x06, 0x4B, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x06, 0x66, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x81, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x06, 0x05, 0x06, 0x90, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x08, 0x04, 0x06, 0x9C, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0xAC, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0xBE, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x08, 0x06, 0x09, 0x06, 0xD0, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x05, 0x06, 0x06, 0x06, 0xEB, // "x" (U+0078)
  0x00, 0x79, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x06, 0xFD, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x04, 0x06, 0x05, 0x07, 0x18, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x07, 0x27, // "{" (U+007B)
  0x00, 0x7C, 0x42, 0xFE, 0x03, 0x08, 0x06, 0x07, 0x3B, // "|" (U+007C)
  0x00, 0x7D, 0x40, 0xFF, 0x03, 0x08, 0x04, 0x07, 0x46, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x04, 0x04, 0x05, 0x06, 0x07, 0x5A, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFE, 0x01, 0x05, 0x03, 0x07, 0x5F, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x04, 0x08, 0x06, 0x07, 0x67, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0x7B, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x03, 0x04, 0x07, 0x06, 0x07, 0x93, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x07, 0xA0, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFE, 0x03, 0x08, 0x06, 0x07, 0xB8, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x07, 0xC3, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x08, 0x04, 0x08, 0x06, 0x07, 0xDC, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x07, 0x08, 0x08, 0x07, 0xDE, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x05, 0x03, 0x07, 0x04, 0x07, 0xFE, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x04, 0x06, 0x05, 0x08, 0x04, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x01, 0x04, 0x04, 0x06, 0x08, 0x11, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x07, 0x08, 0x08, 0x08, 0x19, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x09, 0x04, 0x09, 0x05, 0x08, 0x39, // "¯" (U+00AF)
  0x00, 0xB0, 0x40, 0x05, 0x03, 0x08, 0x04, 0x08, 0x3C, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x04, 0x06, 0x06, 0x08, 0x44, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x05, 0x03, 0x09, 0x04, 0x08, 0x53, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x05, 0x03, 0x09, 0x04, 0x08, 0x5D, // "³" (U+00B3)
  0x00, 0xB4, 0x40, 0x08, 0x02, 0x09, 0x03, 0x08, 0x67, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x08, 0x6A, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x08, 0x85, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x04, 0x01, 0x05, 0x03, 0x08, 0xA3, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFE, 0x02, 0x00, 0x03, 0x08, 0xA5, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x05, 0x03, 0x09, 0x04, 0x08, 0xAA, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x05, 0x03, 0x07, 0x04, 0x08, 0xB4, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x04, 0x06, 0x05, 0x08, 0xBA, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x07, 0x08, 0x08, 0x08, 0xC7, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x08, 0x08, 0x08, 0x08, 0xE7, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x07, 0x08, 0x08, 0x09, 0x0B, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFE, 0x04, 0x05, 0x05, 0x09, 0x2B, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x09, 0x3F, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x09, 0x61, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x09, 0x83, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x09, 0xA6, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x09, 0xCA, // "Ä" (U+00C4)
  0x00, 0xC5, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x09, 0xEB, // "Å" (U+00C5)
  0x00, 0xC6, 0x40, 0x01, 0x08, 0x08, 0x0A, 0x0A, 0x0E, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x0A, 0x32, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x51, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x70, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0A, 0x8F, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0A, 0xAF, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x0A, 0xCC, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x0A, 0xE2, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x0A, 0xF8, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x0B, 0x0E, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x06, 0x08, 0x07, 0x0B, 0x22, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x0B, 0x3E, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x6A, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x8E, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0xB2, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0xD7, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0xFD, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x04, 0x06, 0x06, 0x0C, 0x20, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x06, 0x08, 0x07, 0x0C, 0x2D, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x0C, 0x4D, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x0C, 0x74, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x0C, 0x9B, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x0C, 0xC2, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0C, 0xE5, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x05, // "Þ" (U+00DE)
  0x00, 0xDF, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x1D, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x35, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x4F, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x69, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x84, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0D, 0x9F, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xB7, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x07, 0x06, 0x08, 0x0D, 0xD2, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x0D, 0xEA, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x01, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x17, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x2D, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x44, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x09, 0x03, 0x0E, 0x58, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x03, 0x09, 0x03, 0x0E, 0x66, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x03, 0x09, 0x03, 0x0E, 0x78, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0E, 0x8A, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x9A, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x06, 0x09, 0x06, 0x0E, 0xB5, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xD5, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0xF0, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x0B, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x26, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0F, 0x41, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x01, 0x04, 0x06, 0x06, 0x0F, 0x59, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x05, 0x07, 0x06, 0x0F, 0x65, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x7C, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x97, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0F, 0xB2, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0F, 0xCD, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x0F, 0xE5, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x10, 0x06, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x10, 0x24, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x10, 0x43, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x05, 0x08, 0x06, 0x10, 0x64, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x10, 0x7C, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x05, 0x09, 0x06, 0x10, 0xA0, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x10, 0xBB, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x10, 0xDF, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0xFA, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x09, 0x05, 0x11, 0x17, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x2D, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x04, 0x09, 0x05, 0x11, 0x4B, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x11, 0x62, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x11, 0x7D, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x91, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x11, 0xAF, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x11, 0xC6, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x06, 0x08, 0x06, 0x11, 0xED, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x06, 0x08, 0x07, 0x12, 0x09, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0x25, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0x3D, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0x5A, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x12, 0x6E, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x09, 0x05, 0x12, 0x8F, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x12, 0xA6, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0xC3, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x12, 0xD7, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x12, 0xF7, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x13, 0x0E, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0x2E, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x13, 0x45, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x05, 0x09, 0x05, 0x13, 0x69, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x13, 0x8C, // "Ğ" (U+011E)
  0x01, 0x1F, 0x40, 0xFE, 0x05, 0x09, 0x05, 0x13, 0xB0, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x13, 0xD4, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x05, 0x08, 0x05, 0x13, 0xF4, // "ġ" (U+0121)
  0x01, 0x22, 0x40, 0xFF, 0x06, 0x08, 0x07, 0x14, 0x14, // "Ģ" (U+0122)
  0x01, 0x23, 0x40, 0xFE, 0x05, 0x08, 0x05, 0x14, 0x37, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x14, 0x58, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x14, 0x84, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x07, 0x08, 0x08, 0x14, 0xA3, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x05, 0x08, 0x06, 0x14, 0xC3, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x14, 0xDB, // "Ĩ" (U+0128)
  0x01, 0x29, 0xBF, 0x01, 0x02, 0x09, 0x03, 0x14, 0xF1, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x15, 0x03, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x03, 0x08, 0x03, 0x15, 0x17, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x03, 0x0B, 0x04, 0x15, 0x27, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x03, 0x09, 0x03, 0x15, 0x3D, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFE, 0x03, 0x08, 0x04, 0x15, 0x4F, // "Į" (U+012E)
  0x01, 0x2F, 0x40, 0xFE, 0x02, 0x08, 0x03, 0x15, 0x65, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x15, 0x76, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x06, 0x03, 0x15, 0x8A, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFE, 0x06, 0x08, 0x07, 0x15, 0x93, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFE, 0x04, 0x08, 0x06, 0x15, 0xBA, // "ĳ" (U+0133)
  0x01, 0x34, 0x40, 0xFE, 0x03, 0x0B, 0x04, 0x15, 0xD6, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x02, 0x09, 0x03, 0x15, 0xF2, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x06, 0x08, 0x07, 0x16, 0x07, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x16, 0x2A, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x05, 0x06, 0x06, 0x16, 0x48, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x16, 0x5A, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x16, 0x78, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x16, 0x8B, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x16, 0xA9, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x05, 0x08, 0x06, 0x16, 0xB8, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x08, 0x03, 0x16, 0xD0, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x05, 0x08, 0x06, 0x16, 0xE0, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x08, 0x04, 0x16, 0xF8, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x05, 0x08, 0x06, 0x17, 0x08, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x08, 0x03, 0x17, 0x20, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x17, 0x2C, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x06, 0x09, 0x06, 0x17, 0x57, // "ń" (U+0144)
  0x01, 0x45, 0x40, 0xFF, 0x07, 0x08, 0x08, 0x17, 0x75, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x06, 0x06, 0x06, 0x17, 0x9D, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x07, 0x0B, 0x08, 0x17, 0xB9, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x06, 0x09, 0x06, 0x17, 0xE5, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x07, 0x08, 0x08, 0x18, 0x04, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFE, 0x07, 0x08, 0x08, 0x18, 0x22, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x18, 0x4E, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x18, 0x69, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x05, 0x08, 0x06, 0x18, 0x8C, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x18, 0xA4, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x05, 0x09, 0x06, 0x18, 0xCA, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x18, 0xE5, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x05, 0x09, 0x06, 0x19, 0x0B, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x09, 0x08, 0x0A, 0x19, 0x26, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x08, 0x06, 0x09, 0x19, 0x4E, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x19, 0x69, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x04, 0x09, 0x05, 0x19, 0x8E, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x06, 0x08, 0x07, 0x19, 0xA5, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x19, 0xC8, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x19, 0xDC, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1A, 0x02, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x1A, 0x19, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x09, 0x05, 0x1A, 0x34, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x1A, 0x46, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1A, 0x62, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x1A, 0x79, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x03, 0x06, 0x05, 0x1A, 0x95, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x1A, 0xA7, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x09, 0x05, 0x1A, 0xC3, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x1A, 0xD5, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFE, 0x03, 0x08, 0x04, 0x1A, 0xF4, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1B, 0x0A, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x03, 0x08, 0x04, 0x1B, 0x29, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1B, 0x39, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x08, 0x04, 0x1B, 0x51, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x1B, 0x61, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1B, 0x88, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x1B, 0xA3, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1B, 0xC6, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x1B, 0xDE, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1C, 0x05, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x1C, 0x20, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1C, 0x47, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x06, 0x0B, 0x07, 0x1C, 0x62, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x05, 0x09, 0x06, 0x1C, 0x89, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFE, 0x06, 0x08, 0x07, 0x1C, 0xA4, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x1C, 0xCB, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0A, 0x0B, 0x0A, 0x1C, 0xE6, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x08, 0x09, 0x09, 0x1D, 0x1B, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x1D, 0x40, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x1D, 0x61, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x1D, 0x83, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1D, 0xA2, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x04, 0x09, 0x05, 0x1D, 0xC2, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x1D, 0xD8, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x1D, 0xF5, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x1E, 0x09, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1E, 0x2A, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x04, 0x08, 0x04, 0x1E, 0x41, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x07, 0x08, 0x08, 0x1E, 0x52, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFE, 0x05, 0x06, 0x06, 0x1E, 0x72, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x06, 0x06, 0x1E, 0x8D, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x04, 0x03, 0x05, 0x1E, 0x9F, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x09, 0x03, 0x0A, 0x1E, 0xA1, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x05, 0x08, 0x06, 0x1E, 0xA3, // "€" (U+20AC)
  0x20, 0xBF, 0x40, 0x00, 0x05, 0x08, 0x06, 0x1E, 0xBB, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x06, 0x02, 0x08, 0x03, 0x1E, 0xD6, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x06, 0x01, 0x08, 0x03, 0x1E, 0xDB, // "’" (U+2019)
  0x20, 0x1A, 0x40, 0xFF, 0x01, 0x01, 0x03, 0x1E, 0xDE, // "‚" (U+201A)
  0x20, 0x1B, 0x40, 0x06, 0x02, 0x08, 0x03, 0x1E, 0xE1, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x06, 0x04, 0x08, 0x05, 0x1E, 0xE6, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x06, 0x03, 0x08, 0x05, 0x1E, 0xEE, // "”" (U+201D)
  0x20, 0x1E, 0x40, 0xFF, 0x03, 0x01, 0x05, 0x1E, 0xF4, // "„" (U+201E)
  0x20, 0x1F, 0x40, 0x06, 0x04, 0x08, 0x05, 0x1E, 0xFA, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0xFF, 0x04, 0x08, 0x04, 0x1F, 0x02, // "†" (U+2020)
  0x20, 0x21, 0x40, 0xFF, 0x04, 0x08, 0x04, 0x1F, 0x1A, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x03, 0x06, 0x04, 0x1F, 0x33, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x07, 0x02, 0x09, 0x1F, 0x3B, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0C, 0x08, 0x0D, 0x1F, 0x43, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x02, 0x06, 0x03, 0x1F, 0x76, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x02, 0x05, 0x03, 0x1F, 0x7E, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x08, 0x01, 0x1F, 0x84, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x07, 0x07, 0x08, 0x1F, 0x96, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0B, 0x08, 0x0C, 0x1F, 0xA6, // "⅒" (U+2152)
  0xFB, 0x01, 0x40, 0x01, 0x06, 0x08, 0x07, 0x1F, 0xD4, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x40, 0x01, 0x06, 0x08, 0x07, 0x1F, 0xF0, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x01, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x01, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x01, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xFD, 0x01, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x01, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x01, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x01, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x01, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x01, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x01, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xFD, 0x01, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x01, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x01, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x01, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x3F, 0x01, // A? (U+0041 U+003F)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x01, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x01, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x40, 0x01, // V@ (U+0056 U+0040)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x40, 0x01, // W@ (U+0057 U+0040)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x01, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0xC0, 0x01, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x01, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x01, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x01, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x01, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x01, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x01, 0x00, 0x01, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x01, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x01, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x01, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0xC0, 0x01, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x01, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x01, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x01, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x01, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x01, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x01, 0x00, 0x01, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x01, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x01, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x3F, 0x01, // À? (U+00C0 U+003F)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x3F, 0x01, // Á? (U+00C1 U+003F)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x3F, 0x01, // Â? (U+00C2 U+003F)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x3F, 0x01, // Ã? (U+00C3 U+003F)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x3F, 0x01, // Ä? (U+00C4 U+003F)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x3F, 0x01, // Å? (U+00C5 U+003F)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x01, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0xC0, 0x01, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x01, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x01, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x01, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x01, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x01, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x01, 0x00, 0x01, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x01, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x01, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x01, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0xC0, 0x01, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x01, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x01, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x01, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x01, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x01, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x01, 0x00, 0x01, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x01, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x01, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x3F, 0x01, // Ā? (U+0100 U+003F)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x3F, 0x01, // Ă? (U+0102 U+003F)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x3F, 0x01, // Ą? (U+0104 U+003F)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x01, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x01, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x01, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x01, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x01, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x01, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x40, 0x01, // Ŵ@ (U+0174 U+0040)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x01, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0xC0, 0x01, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x01, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x01, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x01, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x01, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x01, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x01, 0x00, 0x01, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x01, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x01, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x3F, 0x01, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x01, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x01, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xFD, 0x01, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x01, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x01, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x01, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x3F, 0x01, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x01, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x01, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xFD, 0x01, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x01, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x01, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x01, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x01, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x54, 0x01, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x56, 0x01, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x01, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x01, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x76, 0x01, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0x77, 0x01, // …w (U+2026 U+0077)
  0x20, 0x26, 0x00, 0x79, 0x01, // …y (U+2026 U+0079)
  0x20, 0x26, 0x00, 0xDD, 0x01, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x00, 0xFD, 0x01, // …ý (U+2026 U+00FD)
  0x20, 0x26, 0x00, 0xFF, 0x01, // …ÿ (U+2026 U+00FF)
  0x20, 0x26, 0x01, 0x62, 0x01, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x01, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x01, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x74, 0x01, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x75, 0x01, // …ŵ (U+2026 U+0175)
  0x20, 0x26, 0x01, 0x76, 0x01, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x77, 0x01, // …ŷ (U+2026 U+0177)
  0x20, 0x26, 0x01, 0x78, 0x01, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0xD3, 0xD2, 0xC1, 0xB0, 0xA0, 0x50, 0x51, 0xC3,
  // """ (U+0022)
  0x58, 0x77, 0x37, 0x55, 0x13, 0x22,
  // "#" (U+0023)
  0x00, 0x90, 0x90, 0x02, 0x72, 0x70, 0x4C, 0xBC, 0xB3, 0x07, 0x27, 0x10, 0x09, 0x09, 0x00, 0x7D,
  0xAD, 0xA0, 0x09, 0x09, 0x00, 0x17, 0x27, 0x00,
  // "$" (U+0024)
  0x00, 0x70, 0x00, 0x8C, 0xB5, 0x1C, 0x72, 0x70, 0xDA, 0x00, 0x02, 0xBB, 0x11, 0x17, 0x5B, 0x58,
  0x73, 0xC0, 0x8B, 0x82, 0x00, 0x70, 0x00,
  // "%" (U+0025)
  0x19, 0x93, 0x04, 0x50, 0x06, 0x63, 0x90, 0x90, 0x00, 0x85, 0x3A, 0x37, 0x00, 0x05, 0x74, 0x89,
  0x27, 0x70, 0x07, 0x72, 0x89, 0x38, 0x50, 0x00, 0x82, 0xB2, 0x67, 0x00, 0x09, 0x0A, 0x37, 0x60,
  0x06, 0x30, 0x39, 0x91,
  // "&" (U+0026)
  0x05, 0xA9, 0x50, 0x00, 0x0B, 0x31, 0xC0, 0x00, 0x09, 0x88, 0x70, 0x00, 0x05, 0xF7, 0x09, 0x80,
  0x4B, 0x4D, 0x1B, 0x00, 0x95, 0x05, 0xC8, 0x00, 0x77, 0x00, 0xAA, 0x00, 0x09, 0x77, 0x5A, 0xA2,
  // "'" (U+0027)
  0x58, 0x37, 0x13,
  // "(" (U+0028)
  0x00, 0x41, 0x06, 0x60, 0x1D, 0x00, 0x4A, 0x00, 0x69, 0x00, 0x6A, 0x00, 0x3B, 0x00, 0x0D, 0x10,
  0x03, 0x90,
  // ")" (U+0029)
  0x40, 0x01, 0xB0, 0x07, 0x70, 0x3B, 0x02, 0xD0, 0x3D, 0x04, 0xB0, 0x95, 0x48, 0x01, 0x00,
  // "*" (U+002A)
  0x10, 0xB0, 0x05, 0xAA, 0xA4, 0x39, 0xB9, 0x32, 0x1A, 0x11, 0x00, 0x20, 0x00,
  // "+" (U+002B)
  0x00, 0x51, 0x00, 0x08, 0x10, 0x39, 0xCA, 0x90, 0x08, 0x10, 0x00, 0x81, 0x00,
  // "," (U+002C)
  0x5B, 0x1B, 0x54,
  // "-" (U+002D)
  0x9C, 0xA0,
  // "." (U+002E)
  0x14, 0x4B,
  // "/" (U+002F)
  0x00, 0x90, 0x17, 0x04, 0x40, 0x80, 0x09, 0x00, 0x80, 0x44, 0x07, 0x10, 0x90, 0x04, 0x00,
  // "0" (U+0030)
  0x07, 0x9A, 0x20, 0x2C, 0x03, 0xB0, 0x69, 0x00, 0xE0, 0x87, 0x00, 0xE1, 0x87, 0x00, 0xE1, 0x69,
  0x00, 0xE0, 0x2C, 0x03, 0xB0, 0x07, 0x9A, 0x20,
  // "1" (U+0031)
  0x01, 0xB7, 0x02, 0xB9, 0x70, 0x00, 0x87, 0x00, 0x08, 0x70, 0x00, 0x87, 0x00, 0x08, 0x70, 0x00,
  0x87, 0x00, 0x7D, 0xC5,
  // "2" (U+0032)
  0x0A, 0x9B, 0x23, 0xA0, 0x69, 0x01, 0x05, 0x90, 0x00, 0xA2, 0x00, 0x47, 0x00, 0x29, 0x00, 0x09,
  0x00, 0x75, 0xED, 0xDE,
  // "3" (U+0033)
  0x0B, 0x9B, 0x42, 0x90, 0x5A, 0x00, 0x08, 0x60, 0x1A, 0xB1, 0x00, 0x05, 0xB0, 0x00, 0x1E, 0x44,
  0x03, 0xC1, 0xB8, 0xA2,
  // "4" (U+0034)
  0x00, 0x1E, 0x30, 0x00, 0x8B, 0x30, 0x03, 0x6B, 0x30, 0x09, 0x0B, 0x30, 0x54, 0x0B, 0x30, 0x99,
  0x9E, 0xA4, 0x00, 0x0B, 0x30, 0x00, 0x6E, 0xA1,
  // "5" (U+0035)
  0x0D, 0xDE, 0x70, 0x70, 0x04, 0x07, 0x00, 0x02, 0xB9, 0x91, 0x00, 0x07, 0xA0, 0x00, 0x3C, 0x32,
  0x05, 0xA2, 0xB9, 0xB1,
  // "6" (U+0036)
  0x02, 0xAA, 0x70, 0xC1, 0x09, 0x3C, 0x00, 0x05, 0xC8, 0x93, 0x5B, 0x02, 0xD4, 0xB0, 0x0E, 0x0D,
  0x01, 0xD0, 0x5A, 0xA3,
  // "7" (U+0037)
  0x5E, 0xDD, 0xF6, 0x10, 0x1B, 0x00, 0x06, 0x60, 0x00, 0xB1, 0x00, 0x1B, 0x00, 0x06, 0x70, 0x00,
  0xB2, 0x00, 0x1C, 0x00,
  // "8" (U+0038)
  0x08, 0x79, 0x30, 0x3A, 0x01, 0xB0, 0x3D, 0x24, 0xA0, 0x07, 0xFC, 0x10, 0x0A, 0x6C, 0x70, 0x68,
  0x00, 0xE1, 0x68, 0x00, 0xC0, 0x09, 0x78, 0x50,
  // "9" (U+0039)
  0x09, 0x9A, 0x14, 0xA0, 0x59, 0x68, 0x01, 0xD5, 0xB0, 0x3E, 0x08, 0xA7, 0xE0, 0x00, 0x3B, 0x01,
  0x07, 0x61, 0xA9, 0x80,
  // ":" (U+003A)
  0x1D, 0x05, 0x00, 0x00, 0x05, 0x1D,
  // ";" (U+003B)
  0x1D, 0x00, 0x60, 0x00, 0x00, 0x00, 0x15, 0x02, 0xE1, 0x08, 0x03, 0x10,
  // "<" (U+003C)
  0x00, 0x04, 0x90, 0x39, 0x60, 0x2D, 0x20, 0x00, 0x18, 0x81, 0x00, 0x02, 0x80,
  // "=" (U+003D)
  0x03, 0x80, 0x09, 0x50, 0x38, 0x00, 0x90,
  // ">" (U+003E)
  0x81, 0x38, 0x13, 0x81, 0x18, 0x74, 0x87, 0x7B, 0x03, 0x95, 0x03, 0x73,
  // "?" (U+003F)
  0x4B, 0x88, 0x07, 0x30, 0xA4, 0x00, 0x0B, 0x40, 0x05, 0xB0, 0x02, 0x90, 0x00, 0x15, 0x00, 0x02,
  0x40, 0x00, 0x59, 0x00,
  // "@" (U+0040)
  0x28, 0x41, 0x89, 0x89, 0x42, 0x81, 0x1B, 0x23, 0x8D, 0x48, 0x20, 0x93, 0x39, 0x88, 0x18, 0x0B,
  0x0D, 0x05, 0x70, 0x93, 0x84, 0x90, 0x84, 0x18, 0x57, 0x49, 0x0C, 0x36, 0x34, 0x70, 0x88, 0x29,
  0x62, 0x0B, 0x71, 0x00, 0x73, 0x08, 0x48, 0x35, 0x98, 0x81, 0x20,
  // "A" (U+0041)
  0x00, 0x0E, 0x10, 0x00, 0x05, 0xD6, 0x00, 0x00, 0x95, 0xB0, 0x00, 0x0A, 0x0F, 0x10, 0x05, 0x60,
  0xB6, 0x00, 0xA9, 0x8B, 0xB0, 0x0A, 0x00, 0x1E, 0x1A, 0xC3, 0x05, 0xFA,
  // "B" (U+0042)
  0x4E, 0x97, 0xA1, 0x0A, 0x50, 0x78, 0x0A, 0x50, 0x96, 0x0A, 0xAA, 0xB0, 0x0A, 0x50, 0x6A, 0x0A,
  0x50, 0x2D, 0x0A, 0x50, 0x3C, 0x4E, 0x97, 0x93,
  // "C" (U+0043)
  0x01, 0xA9, 0xB5, 0x0C, 0x30, 0x29, 0x3D, 0x00, 0x00, 0x6B, 0x00, 0x00, 0x6B, 0x00, 0x00, 0x3D,
  0x00, 0x00, 0x0D, 0x40, 0x04, 0x02, 0xBA, 0xA4,
  // "D" (U+0044)
  0x4E, 0x97, 0xA4, 0x00, 0xA5, 0x01, 0xD1, 0x0A, 0x50, 0x09, 0x70, 0xA5, 0x00, 0x79, 0x0A, 0x50,
  0x07, 0xA0, 0xA5, 0x00, 0x97, 0x0A, 0x50, 0x1D, 0x24, 0xE9, 0x7A, 0x40,
  // "E" (U+0045)
  0x4E, 0x97, 0xA6, 0x0A, 0x50, 0x15, 0x0A, 0x50, 0x00, 0x0A, 0xA8, 0x60, 0x0A, 0x50, 0x00, 0x0A,
  0x50, 0x00, 0x0A, 0x50, 0x09, 0x4E, 0x97, 0x8B,
  // "F" (U+0046)
  0x4E, 0x97, 0xA6, 0x0A, 0x50, 0x27, 0x0A, 0x50, 0x01, 0x0A, 0x50, 0x00, 0x0A, 0xA8, 0x60, 0x0A,
  0x50, 0x00, 0x0A, 0x50, 0x00, 0x4E, 0xB3, 0x00,
  // "G" (U+0047)
  0x01, 0x99, 0xAB, 0x00, 0xC4, 0x00, 0xB2, 0x3D, 0x00, 0x00, 0x06, 0xB0, 0x00, 0x00, 0x6B, 0x00,
  0x5B, 0x93, 0xD0, 0x00, 0xC3, 0x0C, 0x50, 0x0C, 0x30, 0x1A, 0xA8, 0xB1,
  // "H" (U+0048)
  0x4E, 0xB2, 0x2C, 0xD4, 0x0A, 0x50, 0x06, 0x90, 0x0A, 0x50, 0x06, 0x90, 0x0A, 0xA8, 0x8B, 0x90,
  0x0A, 0x50, 0x06, 0x90, 0x0A, 0x50, 0x06, 0x90, 0x0A, 0x50, 0x06, 0x90, 0x4E, 0xB2, 0x2C, 0xD4,
  // "I" (U+0049)
  0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x4E, 0xB2,
  // "J" (U+004A)
  0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x0C, 0x20, 0x98, 0x00,
  // "K" (U+004B)
  0x4E, 0xB2, 0x4F, 0x60, 0xA5, 0x06, 0x50, 0x0A, 0x52, 0x80, 0x00, 0xA6, 0xD1, 0x00, 0x0A, 0xCA,
  0x90, 0x00, 0xA5, 0x1E, 0x40, 0x0A, 0x50, 0x6D, 0x04, 0xEB, 0x20, 0x9B,
  // "L" (U+004C)
  0x4E, 0xB2, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A,
  0x50, 0x03, 0x0A, 0x50, 0x09, 0x4E, 0x97, 0x8B,
  // "M" (U+004D)
  0x4E, 0xC0, 0x00, 0x5F, 0x90, 0x9D, 0x20, 0x09, 0xE0, 0x09, 0x87, 0x00, 0x8E, 0x00, 0x93, 0xC0,
  0x53, 0xE0, 0x09, 0x0D, 0x18, 0x0E, 0x00, 0x90, 0x87, 0x80, 0xE0, 0x09, 0x03, 0xE4, 0x0E, 0x04,
  0xD5, 0x0C, 0x05, 0xF9,
  // "N" (U+004E)
  0x4E, 0x70, 0x1A, 0xC2, 0x0A, 0xE1, 0x03, 0x60, 0x09, 0x8A, 0x03, 0x60, 0x09, 0x0D, 0x33, 0x60,
  0x09, 0x05, 0xC3, 0x60, 0x09, 0x00, 0xB9, 0x60, 0x09, 0x00, 0x3F, 0x60, 0x4E, 0x70, 0x09, 0x60,
  // "O" (U+004F)
  0x02, 0xA9, 0xA5, 0x00, 0xD2, 0x00, 0xB4, 0x3C, 0x00, 0x06, 0xA6, 0xB0, 0x00, 0x4C, 0x6B, 0x00,
  0x04, 0xC3, 0xC0, 0x00, 0x6A, 0x0D, 0x20, 0x0B, 0x40, 0x2A, 0x8A, 0x50,
  // "P" (U+0050)
  0x4E, 0x97, 0xA1, 0x0A, 0x50, 0x87, 0x0A, 0x50, 0x79, 0x0A, 0x50, 0xA5, 0x0A, 0xA8, 0x50, 0x0A,
  0x50, 0x00, 0x0A, 0x50, 0x00, 0x4E, 0xB3, 0x00,
  // "Q" (U+0051)
  0x18, 0x32, 0xA9, 0xA5, 0x20, 0xC0, 0x32, 0x82, 0xC3, 0x3D, 0x38, 0x26, 0x95, 0xB3, 0x82, 0x5C,
  0x6A, 0x38, 0x24, 0xC4, 0xB3, 0x82, 0x5B, 0x1E, 0x38, 0x69, 0x70, 0x79, 0x25, 0xC3, 0x81, 0x3C,
  0x95, 0x07, 0x09, 0x60, 0xA0, 0x81,
  // "R" (U+0052)
  0x4E, 0x97, 0x90, 0x00, 0xA5, 0x08, 0x70, 0x0A, 0x50, 0x79, 0x00, 0xA5, 0x0A, 0x40, 0x0A, 0xAC,
  0x70, 0x00, 0xA5, 0x6C, 0x00, 0x0A, 0x50, 0xC6, 0x04, 0xEB, 0x23, 0xD5,
  // "S" (U+0053)
  0x08, 0x7B, 0x45, 0x80, 0x36, 0x5B, 0x00, 0x00, 0xCB, 0x30, 0x00, 0x6E, 0x60, 0x00, 0x3D, 0x65,
  0x01, 0xC2, 0xB8, 0x93,
  // "T" (U+0054)
  0xB9, 0xBC, 0x8D, 0x80, 0x78, 0x08, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00, 0x78, 0x00, 0x00,
  0x78, 0x00, 0x00, 0x78, 0x00, 0x03, 0xCD, 0x40,
  // "U" (U+0055)
  0x7F, 0x90, 0x3D, 0x90, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10,
  0x08, 0x10, 0xD1, 0x00, 0x80, 0x0B, 0x50, 0x0A, 0x00, 0x2B, 0x99, 0x40,
  // "V" (U+0056)
  0xAF, 0x60, 0x5E, 0x60, 0xE0, 0x00, 0xA0, 0x0B, 0x40, 0x36, 0x00, 0x69, 0x07, 0x10, 0x01, 0xE0,
  0x90, 0x00, 0x0C, 0x57, 0x00, 0x00, 0x7C, 0x30, 0x00, 0x02, 0xD0, 0x00,
  // "W" (U+0057)
  0x8F, 0x70, 0x1D, 0x00, 0x9D, 0x20, 0xE1, 0x05, 0xF2, 0x04, 0x60, 0x0A, 0x50, 0x8A, 0x60, 0x72,
  0x00, 0x69, 0x09, 0x5A, 0x0A, 0x00, 0x02, 0xD1, 0x81, 0xD0, 0x90, 0x00, 0x0D, 0x64, 0x0C, 0x65,
  0x00, 0x00, 0x9C, 0x00, 0x8D, 0x10, 0x00, 0x05, 0xC0, 0x04, 0xD0, 0x00,
  // "X" (U+0058)
  0x6F, 0x90, 0xAC, 0x20, 0x89, 0x08, 0x10, 0x01, 0xE5, 0x60, 0x00, 0x07, 0xD0, 0x00, 0x00, 0x6E,
  0x30, 0x00, 0x18, 0x5C, 0x00, 0x09, 0x10, 0xC5, 0x08, 0xE3, 0x1C, 0xE4,
  // "Y" (U+0059)
  0x89, 0x3B, 0xF5, 0x1A, 0xD2, 0x0E, 0x10, 0x63, 0x28, 0x27, 0x90, 0x94, 0x81, 0xD6, 0x34, 0x07,
  0x0B, 0x50, 0x50, 0xA5, 0x05, 0x0A, 0x48, 0x22, 0xBD, 0x52,
  // "Z" (U+005A)
  0x6B, 0x88, 0xF4, 0x62, 0x06, 0xB0, 0x00, 0x0D, 0x30, 0x00, 0x7A, 0x00, 0x01, 0xE2, 0x00, 0x08,
  0x90, 0x00, 0x1E, 0x10, 0x17, 0x8D, 0x88, 0xB7,
  // "[" (U+005B)
  0x90, 0x80, 0x19, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x28, 0x1B, 0x81,
  // "\" (U+005C)
  0x80, 0x08, 0x00, 0x62, 0x02, 0x60, 0x08, 0x00, 0x80, 0x06, 0x20, 0x26, 0x00, 0x80, 0x04,
  // "]" (U+005D)
  0x4B, 0x90, 0x59, 0x05, 0x90, 0x59, 0x05, 0x90, 0x59, 0x05, 0x90, 0x59, 0x06, 0x94, 0x96,
  // "^" (U+005E)
  0x00, 0x92, 0x00, 0x19, 0x80, 0x06, 0x38, 0x00, 0x90, 0x36, 0x46, 0x00, 0x90,
  // "_" (U+005F)
  0xBB, 0xBB, 0x70,
  // "`" (U+0060)
  0x5A, 0x00, 0x82,
  // "a" (U+0061)
  0x0B, 0x9B, 0x20, 0x05, 0x06, 0x70, 0x07, 0x7A, 0x80, 0x59, 0x06, 0x80, 0x68, 0x08, 0x80, 0x1C,
  0x96, 0xC1,
  // "b" (U+0062)
  0x6F, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x0E, 0x6A, 0xA0, 0x0E, 0x30, 0x95, 0x0E, 0x00, 0x68, 0x0E,
  0x00, 0x68, 0x0E, 0x30, 0x95, 0x6D, 0x7A, 0xA0,
  // "c" (U+0063)
  0x08, 0x9B, 0x33, 0xB0, 0x54, 0x68, 0x00, 0x06, 0x80, 0x00, 0x3C, 0x00, 0x10, 0x8B, 0xA3,
  // "d" (U+0064)
  0x00, 0x06, 0xF1, 0x00, 0x00, 0xD1, 0x09, 0xB8, 0xD1, 0x3B, 0x02, 0xF1, 0x68, 0x00, 0xE1, 0x68,
  0x00, 0xE1, 0x3B, 0x01, 0xF1, 0x09, 0xB8, 0xC8,
  // "e" (U+0065)
  0x08, 0x9A, 0x23, 0xA0, 0x4A, 0x6D, 0xAA, 0xA6, 0x90, 0x00, 0x2C, 0x00, 0x20, 0x7B, 0xA4,
  // "f" (U+0066)
  0x05, 0x9B, 0x30, 0xB2, 0x20, 0x5D, 0x94, 0x00, 0xC2, 0x00, 0x0C, 0x20, 0x00, 0xC2, 0x00, 0x0C,
  0x20, 0x05, 0xEA, 0x20,
  // "g" (U+0067)
  0x0A, 0xCA, 0xC2, 0x3B, 0x0A, 0x40, 0x2A, 0x0A, 0x40, 0x0A, 0x87, 0x00, 0x09, 0x00, 0x00, 0x0C,
  0xFE, 0x70, 0x84, 0x01, 0xD0, 0xB1, 0x00, 0xB0, 0x3A, 0x89, 0x30,
  // "h" (U+0068)
  0x6F, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x0E, 0x7B, 0xA0, 0x0E, 0x30, 0xC2, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x6F, 0x70, 0xAA,
  // "i" (U+0069)
  0x0C, 0x10, 0x30, 0x5F, 0x10, 0xC1, 0x0C, 0x10, 0xC1, 0x0C, 0x26, 0xE9,
  // "j" (U+006A)
  0x00, 0xD0, 0x03, 0x07, 0xF0, 0x0E, 0x00, 0xE0, 0x0E, 0x00, 0xE0, 0x0E, 0x00, 0xE0, 0x0D, 0x19,
  0x50,
  // "k" (U+006B)
  0x6F, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x0E, 0x07, 0xE3, 0x0E, 0x0A, 0x20, 0x0E, 0x98, 0x00, 0x0E,
  0x7D, 0x10, 0x0E, 0x07, 0xA0, 0x6F, 0x80, 0xB8,
  // "l" (U+006C)
  0x7F, 0x00, 0xE0, 0x0E, 0x00, 0xE0, 0x0E, 0x00, 0xE0, 0x0E, 0x07, 0xF8,
  // "m" (U+006D)
  0x5E, 0x6B, 0xA6, 0xAB, 0x00, 0x0C, 0x50, 0xC6, 0x0A, 0x40, 0x0C, 0x20, 0xA4, 0x08, 0x50, 0x0C,
  0x10, 0xA4, 0x08, 0x50, 0x0C, 0x10, 0xA4, 0x08, 0x50, 0x5E, 0x90, 0xAA, 0x08, 0xB1,
  // "n" (U+006E)
  0x5E, 0x7B, 0xB0, 0x00, 0xC5, 0x0A, 0x40, 0x0C, 0x20, 0x85, 0x00, 0xC1, 0x08, 0x50, 0x0C, 0x10,
  0x85, 0x05, 0xF9, 0x08, 0xB1,
  // "o" (U+006F)
  0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68, 0x00, 0xC2, 0x68, 0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07,
  0x99, 0x50,
  // "p" (U+0070)
  0x7E, 0x6A, 0xA0, 0x0E, 0x30, 0x95, 0x0E, 0x00, 0x68, 0x0E, 0x00, 0x68, 0x0E, 0x30, 0x95, 0x0E,
  0x7A, 0xA0, 0x0E, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x7F, 0x80, 0x00,
  // "q" (U+0071)
  0x09, 0xB8, 0xB9, 0x3B, 0x02, 0xF1, 0x68, 0x00, 0xE1, 0x68, 0x00, 0xE1, 0x3B, 0x01, 0xF1, 0x09,
  0xB8, 0xD1, 0x00, 0x00, 0xD1, 0x00, 0x00, 0xD1, 0x00, 0x08, 0xF9,
  // "r" (U+0072)
  0x5E, 0x6D, 0x60, 0xC5, 0x32, 0x0C, 0x20, 0x00, 0xC1, 0x00, 0x0C, 0x10, 0x05, 0xF9, 0x10,
  // "s" (U+0073)
  0x19, 0x88, 0x66, 0x05, 0x2D, 0x80, 0x01, 0x9C, 0x52, 0x0C, 0x4A, 0x87,
  // "t" (U+0074)
  0x04, 0x00, 0x1C, 0x00, 0x8E, 0x91, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0E, 0x00, 0x0A, 0x92,
  // "u" (U+0075)
  0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06,
  0xC9, 0x9B,
  // "v" (U+0076)
  0xAE, 0x42, 0xD7, 0x1D, 0x00, 0x90, 0x0B, 0x31, 0x70, 0x06, 0x86, 0x20, 0x01, 0xD8, 0x00, 0x00,
  0xB7, 0x00,
  // "w" (U+0077)
  0xBE, 0x30, 0xD0, 0x4E, 0x52, 0xD0, 0x5D, 0x30, 0x80, 0x0D, 0x18, 0x67, 0x26, 0x00, 0x95, 0x81,
  0xC6, 0x20, 0x05, 0xB4, 0x0C, 0x90, 0x00, 0x1E, 0x00, 0x78, 0x00,
  // "x" (U+0078)
  0x6F, 0x77, 0xD3, 0x07, 0x86, 0x20, 0x00, 0xC7, 0x00, 0x00, 0x9C, 0x00, 0x07, 0x18, 0x70, 0x8E,
  0x38, 0xF6,
  // "y" (U+0079)
  0xBF, 0x33, 0xE6, 0x1D, 0x00, 0xA0, 0x0B, 0x31, 0x70, 0x05, 0x96, 0x30, 0x00, 0xD9, 0x00, 0x00,
  0x98, 0x00, 0x00, 0x74, 0x00, 0x01, 0xB0, 0x00, 0x5A, 0x30, 0x00,
  // "z" (U+007A)
  0x5B, 0x9E, 0x63, 0x03, 0xC0, 0x00, 0xC4, 0x00, 0x5A, 0x00, 0x0D, 0x20, 0x57, 0xD9, 0xA7,
  // "{" (U+007B)
  0x01, 0xB5, 0x04, 0xA0, 0x04, 0xA0, 0x06, 0x90, 0x4D, 0x20, 0x06, 0x80, 0x04, 0xA0, 0x04, 0xA0,
  0x03, 0xB0, 0x00, 0x85,
  // "|" (U+007C)
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  // "}" (U+007D)
  0x3B, 0x40, 0x06, 0x80, 0x05, 0x90, 0x04, 0xA0, 0x00, 0xC7, 0x04, 0xB0, 0x05, 0x90, 0x05, 0x90,
  0x07, 0x80, 0x39, 0x10,
  // "~" (U+007E)
  0x1B, 0x91, 0x85, 0x33, 0xB7,
  // "¡" (U+00A1)
  0x2C, 0x15, 0x05, 0x0A, 0x0B, 0x1C, 0x2D, 0x3D,
  // "¢" (U+00A2)
  0x00, 0x36, 0x00, 0x7A, 0xBB, 0x0D, 0x25, 0x62, 0xC2, 0x50, 0x2C, 0x25, 0x00, 0xD5, 0x54, 0x03,
  0xAC, 0x60, 0x02, 0x50,
  // "£" (U+00A3)
  0x06, 0x9A, 0x70, 0x0D, 0x00, 0x70, 0x0C, 0x10, 0x00, 0x4C, 0xB8, 0x00, 0x03, 0x80, 0x00, 0x03,
  0x80, 0x00, 0x08, 0x61, 0x01, 0x3A, 0x9D, 0xB1,
  // "¤" (U+00A4)
  0x01, 0x00, 0x11, 0xB9, 0xA8, 0x09, 0x01, 0x80, 0x90, 0x27, 0x2A, 0x98, 0x90,
  // "¥" (U+00A5)
  0xAE, 0x33, 0xE4, 0x0E, 0x00, 0x90, 0x09, 0x55, 0x30, 0x02, 0xB8, 0x00, 0x08, 0xDB, 0x50, 0x08,
  0xCA, 0x50, 0x00, 0xA5, 0x00, 0x05, 0xEB, 0x20,
  // "¦" (U+00A6)
  0x81, 0x81, 0x81, 0x81, 0x30, 0x00, 0x30, 0x81, 0x81, 0x81, 0x81,
  // "§" (U+00A7)
  0x06, 0x8B, 0x20, 0xB0, 0x44, 0x0C, 0x40, 0x00, 0x9D, 0xA1, 0x2A, 0x07, 0xB0, 0xCD, 0x5B, 0x00,
  0x7F, 0x70, 0x10, 0x39, 0x0B, 0x01, 0x70, 0x59, 0x81,
  // "¨" (U+00A8)
  0x53, 0x62,
  // "©" (U+00A9)
  0x00, 0x58, 0x88, 0x10, 0x08, 0x47, 0x87, 0x91, 0x26, 0x75, 0x06, 0x08, 0x62, 0xB1, 0x00, 0x09,
  0x62, 0xB1, 0x00, 0x09, 0x27, 0x75, 0x03, 0x18, 0x08, 0x47, 0x75, 0x91, 0x00, 0x58, 0x88, 0x10,
  // "ª" (U+00AA)
  0x39, 0xB1, 0x36, 0xB3, 0x79, 0xA6,
  // "«" (U+00AB)
  0x00, 0x10, 0x10, 0x55, 0x82, 0x2C, 0x5A, 0x01, 0xC4, 0xB0, 0x03, 0x66, 0x30,
  // "¬" (U+00AC)
  0x83, 0x39, 0x99, 0xB4, 0x09, 0x40, 0x94, 0x02,
  // "®" (U+00AE)
  0x00, 0x58, 0x88, 0x10, 0x08, 0x99, 0x65, 0x91, 0x26, 0x1A, 0x0B, 0x08, 0x62, 0x1D, 0xB3, 0x09,
  0x62, 0x1A, 0x57, 0x09, 0x27, 0x59, 0x29, 0x38, 0x08, 0x40, 0x01, 0x91, 0x00, 0x58, 0x88, 0x10,
  // "¯" (U+00AF)
  0xBB, 0xBB, 0x70,
  // "°" (U+00B0)
  0x1A, 0xA1, 0x64, 0x46, 0x64, 0x46, 0x1A, 0xA1,
  // "±" (U+00B1)
  0x00, 0x81, 0x00, 0x08, 0x10, 0x39, 0xCA, 0x90, 0x08, 0x10, 0x00, 0x51, 0x03, 0x99, 0x99,
  // "²" (U+00B2)
  0x27, 0x80, 0x32, 0x95, 0x00, 0xA1, 0x07, 0x22, 0x6A, 0xA5,
  // "³" (U+00B3)
  0x27, 0x80, 0x32, 0x94, 0x06, 0xB1, 0x30, 0x77, 0x38, 0x71,
  // "´" (U+00B4)
  0x0D, 0x26, 0x40,
  // "µ" (U+00B5)
  0x0E, 0x00, 0xD1, 0x0E, 0x00, 0xD1, 0x0E, 0x00, 0xD1, 0x0E, 0x00, 0xD1, 0x0F, 0x01, 0xF1, 0x1D,
  0xB9, 0x87, 0x19, 0x00, 0x00, 0x2D, 0x10, 0x00, 0x0D, 0x30, 0x00,
  // "¶" (U+00B6)
  0x2D, 0xF9, 0xD5, 0x8F, 0xF3, 0x90, 0x8F, 0xF3, 0x90, 0x3F, 0xF3, 0x90, 0x01, 0x73, 0x90, 0x00,
  0x53, 0x90, 0x00, 0x53, 0x90, 0x00, 0x53, 0x90, 0x00, 0x53, 0x90, 0x02, 0x92, 0x85,
  // "·" (U+00B7)
  0x15, 0x4B,
  // "¸" (U+00B8)
  0x08, 0x10, 0x39, 0x3A, 0x40,
  // "¹" (U+00B9)
  0x06, 0x60, 0x49, 0x70, 0x06, 0x70, 0x06, 0x70, 0x17, 0x81,
  // "º" (U+00BA)
  0x49, 0x94, 0x93, 0x49, 0x49, 0x94,
  // "»" (U+00BB)
  0x00, 0x10, 0x01, 0x93, 0x70, 0x08, 0x7B, 0x40, 0x95, 0xC2, 0x18, 0x45, 0x00,
  // "¼" (U+00BC)
  0x06, 0x60, 0x07, 0x30, 0x49, 0x70, 0x09, 0x00, 0x06, 0x70, 0x54, 0x00, 0x06, 0x70, 0xA2, 0xA0,
  0x17, 0x85, 0x68, 0xC0, 0x00, 0x09, 0x54, 0xC0, 0x00, 0x27, 0x77, 0xD5, 0x00, 0x81, 0x04, 0x92,
  // "½" (U+00BD)
  0x06, 0x60, 0x07, 0x30, 0x04, 0x97, 0x00, 0x90, 0x00, 0x06, 0x70, 0x54, 0x00, 0x00, 0x67, 0x0A,
  0x27, 0x80, 0x17, 0x85, 0x63, 0x29, 0x50, 0x00, 0x90, 0x00, 0xA1, 0x00, 0x27, 0x00, 0x72, 0x20,
  0x08, 0x10, 0x6A, 0xA5,
  // "¾" (U+00BE)
  0x27, 0x80, 0x07, 0x30, 0x32, 0x94, 0x09, 0x00, 0x06, 0xB1, 0x54, 0x00, 0x30, 0x77, 0xA2, 0xA0,
  0x38, 0x74, 0x68, 0xC0, 0x00, 0x09, 0x54, 0xC0, 0x00, 0x27, 0x77, 0xD5, 0x00, 0x81, 0x04, 0x92,
  // "¿" (U+00BF)
  0x00, 0x95, 0x00, 0x04, 0x20, 0x00, 0x51, 0x00, 0x09, 0x20, 0x0B, 0x50, 0x04, 0xB0, 0x00, 0x4A,
  0x03, 0x70, 0x88, 0xB4,
  // "À" (U+00C0)
  0x20, 0x50, 0xA6, 0x08, 0x02, 0x75, 0x0E, 0x01, 0x48, 0x15, 0xD6, 0x48, 0x19, 0x5B, 0x48, 0x2A,
  0x0F, 0x12, 0x83, 0x56, 0x0B, 0x62, 0x83, 0xA9, 0x8B, 0xB2, 0x0A, 0x28, 0x90, 0x1E, 0x1A, 0xC3,
  0x05, 0xFA,
  // "Á" (U+00C1)
  0x40, 0xD0, 0x24, 0x06, 0x04, 0x75, 0x0E, 0x01, 0x48, 0x15, 0xD6, 0x48, 0x19, 0x5B, 0x48, 0x2A,
  0x0F, 0x12, 0x83, 0x56, 0x0B, 0x62, 0x83, 0xA9, 0x8B, 0xB2, 0x0A, 0x28, 0x90, 0x1E, 0x1A, 0xC3,
  0x05, 0xFA,
  // "Â" (U+00C2)
  0x30, 0xC0, 0x84, 0x82, 0x55, 0x82, 0x74, 0x0E, 0x01, 0x48, 0x15, 0xD6, 0x48, 0x19, 0x5B, 0x48,
  0x2A, 0x0F, 0x12, 0x83, 0x56, 0x0B, 0x62, 0x83, 0xA9, 0x8B, 0xB2, 0x0A, 0x28, 0x90, 0x1E, 0x1A,
  0xC3, 0x05, 0xFA,
  // "Ã" (U+00C3)
  0x18, 0x23, 0xB6, 0x63, 0x82, 0x51, 0xA7, 0x75, 0x0E, 0x01, 0x48, 0x15, 0xD6, 0x48, 0x19, 0x5B,
  0x48, 0x2A, 0x0F, 0x12, 0x83, 0x56, 0x0B, 0x62, 0x83, 0xA9, 0x8B, 0xB2, 0x0A, 0x28, 0x90, 0x1E,
  0x1A, 0xC3, 0x05, 0xFA,
  // "Ä" (U+00C4)
  0x28, 0x25, 0x36, 0x27, 0x40, 0xE0, 0x14, 0x81, 0x5D, 0x64, 0x81, 0x95, 0xB4, 0x82, 0xA0, 0xF1,
  0x28, 0x35, 0x60, 0xB6, 0x28, 0x3A, 0x98, 0xBB, 0x20, 0xA2, 0x89, 0x01, 0xE1, 0xAC, 0x30, 0x5F,
  0xA0,
  // "Å" (U+00C5)
  0x00, 0x39, 0x40, 0x00, 0x08, 0x18, 0x00, 0x00, 0x2F, 0x40, 0x00, 0x04, 0xD6, 0x00, 0x00, 0x95,
  0xB0, 0x00, 0x0A, 0x0F, 0x10, 0x05, 0x60, 0xB6, 0x00, 0xA9, 0x8B, 0xB0, 0x0A, 0x00, 0x1E, 0x1A,
  0xC3, 0x05, 0xFA,
  // "Æ" (U+00C6)
  0x00, 0x07, 0xDC, 0x78, 0xB0, 0x00, 0x87, 0x90, 0x06, 0x00, 0x19, 0x69, 0x00, 0x00, 0x07, 0x36,
  0xC8, 0x80, 0x00, 0xB0, 0x69, 0x00, 0x00, 0x6B, 0x8B, 0x90, 0x00, 0x0B, 0x00, 0x69, 0x00, 0x5A,
  0xC3, 0x2B, 0xC7, 0x7D,
  // "Ç" (U+00C7)
  0x18, 0x93, 0x1A, 0x9B, 0x50, 0xC3, 0x02, 0x93, 0xD4, 0x06, 0x0B, 0x40, 0x60, 0xB4, 0x03, 0x0D,
  0x50, 0xD0, 0x42, 0x85, 0x40, 0x2B, 0xAA, 0x43, 0x05, 0x04, 0x50, 0xC4, 0x09, 0x08, 0x10,
  // "È" (U+00C8)
  0x10, 0x50, 0xA5, 0x08, 0x02, 0x71, 0x89, 0x54, 0xE9, 0x7A, 0x60, 0xA5, 0x01, 0x50, 0xA5, 0x48,
  0x2A, 0xA8, 0x62, 0x0A, 0x05, 0x40, 0xA0, 0x54, 0x0A, 0x05, 0x28, 0x59, 0x4E, 0x97, 0x8B,
  // "É" (U+00C9)
  0x30, 0xD0, 0x23, 0x06, 0x04, 0x71, 0x89, 0x54, 0xE9, 0x7A, 0x60, 0xA5, 0x01, 0x50, 0xA5, 0x48,
  0x2A, 0xA8, 0x62, 0x0A, 0x05, 0x40, 0xA0, 0x54, 0x0A, 0x05, 0x28, 0x59, 0x4E, 0x97, 0x8B,
  // "Ê" (U+00CA)
  0x20, 0xC0, 0x83, 0x82, 0x55, 0x82, 0x78, 0x95, 0x4E, 0x97, 0xA6, 0x0A, 0x50, 0x15, 0x0A, 0x54,
  0x82, 0xAA, 0x86, 0x20, 0xA0, 0x54, 0x0A, 0x05, 0x40, 0xA0, 0x52, 0x85, 0x94, 0xE9, 0x78, 0xB0,
  // "Ë" (U+00CB)
  0x18, 0x25, 0x36, 0x27, 0x89, 0x54, 0xE9, 0x7A, 0x60, 0xA5, 0x01, 0x50, 0xA5, 0x48, 0x2A, 0xA8,
  0x62, 0x0A, 0x05, 0x40, 0xA0, 0x54, 0x0A, 0x05, 0x28, 0x59, 0x4E, 0x97, 0x8B,
  // "Ì" (U+00CC)
  0x5A, 0x00, 0x08, 0x20, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x0A, 0x50, 0x4E, 0xB2,
  // "Í" (U+00CD)
  0x00, 0xD2, 0x06, 0x40, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x0A, 0x50, 0x4E, 0xB2,
  // "Î" (U+00CE)
  0x0C, 0x80, 0x55, 0x82, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x0A, 0x50, 0x4E, 0xB2,
  // "Ï" (U+00CF)
  0x53, 0x62, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x4E, 0xB2,
  // "Ð" (U+00D0)
  0x4E, 0x97, 0xA4, 0x00, 0xA5, 0x01, 0xD1, 0x0A, 0x50, 0x09, 0x75, 0xDA, 0x80, 0x79, 0x0A, 0x50,
  0x07, 0xA0, 0xA5, 0x00, 0x97, 0x0A, 0x50, 0x1D, 0x24, 0xE9, 0x7A, 0x40,
  // "Ñ" (U+00D1)
  0x00, 0x3B, 0x66, 0x00, 0x00, 0x51, 0xA7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x70, 0x1A, 0xC2,
  0x0A, 0xE1, 0x03, 0x60, 0x09, 0x8A, 0x03, 0x60, 0x09, 0x0D, 0x33, 0x60, 0x09, 0x05, 0xC3, 0x60,
  0x09, 0x00, 0xB9, 0x60, 0x09, 0x00, 0x3F, 0x60, 0x4E, 0x70, 0x09, 0x60,
  // "Ò" (U+00D2)
  0x20, 0x50, 0xA6, 0x08, 0x02, 0x73, 0x83, 0x2A, 0x9A, 0x52, 0x0D, 0x02, 0x28, 0x2B, 0x43, 0xC3,
  0x82, 0x6A, 0x6B, 0x38, 0x24, 0xC6, 0xB3, 0x82, 0x4C, 0x3C, 0x38, 0x36, 0xA0, 0xD2, 0x28, 0x6B,
  0x40, 0x2A, 0x8A, 0x51,
  // "Ó" (U+00D3)
  0x40, 0xD0, 0x24, 0x06, 0x04, 0x73, 0x83, 0x2A, 0x9A, 0x52, 0x0D, 0x02, 0x28, 0x2B, 0x43, 0xC3,
  0x82, 0x6A, 0x6B, 0x38, 0x24, 0xC6, 0xB3, 0x82, 0x4C, 0x3C, 0x38, 0x36, 0xA0, 0xD2, 0x28, 0x6B,
  0x40, 0x2A, 0x8A, 0x51,
  // "Ô" (U+00D4)
  0x30, 0xC0, 0x84, 0x82, 0x55, 0x82, 0x72, 0x83, 0x2A, 0x9A, 0x52, 0x0D, 0x02, 0x28, 0x2B, 0x43,
  0xC3, 0x82, 0x6A, 0x6B, 0x38, 0x24, 0xC6, 0xB3, 0x82, 0x4C, 0x3C, 0x38, 0x36, 0xA0, 0xD2, 0x28,
  0x6B, 0x40, 0x2A, 0x8A, 0x51,
  // "Õ" (U+00D5)
  0x18, 0x23, 0xB6, 0x63, 0x82, 0x51, 0xA7, 0x73, 0x83, 0x2A, 0x9A, 0x52, 0x0D, 0x02, 0x28, 0x2B,
  0x43, 0xC3, 0x82, 0x6A, 0x6B, 0x38, 0x24, 0xC6, 0xB3, 0x82, 0x4C, 0x3C, 0x38, 0x36, 0xA0, 0xD2,
  0x28, 0x6B, 0x40, 0x2A, 0x8A, 0x51,
  // "Ö" (U+00D6)
  0x00, 0x53, 0x62, 0x00, 0x00, 0x00, 0x00, 0x02, 0xA9, 0xA5, 0x00, 0xD2, 0x00, 0xB4, 0x3C, 0x00,
  0x06, 0xA6, 0xB0, 0x00, 0x4C, 0x6B, 0x00, 0x04, 0xC3, 0xC0, 0x00, 0x6A, 0x0D, 0x20, 0x0B, 0x40,
  0x2A, 0x8A, 0x50,
  // "×" (U+00D7)
  0x14, 0x00, 0x50, 0x85, 0x93, 0x00, 0xD7, 0x00, 0x93, 0x84, 0x02, 0x00, 0x30,
  // "Ø" (U+00D8)
  0x02, 0xA8, 0x9B, 0x00, 0xD2, 0x05, 0xD4, 0x3C, 0x00, 0x86, 0xA6, 0xB0, 0x53, 0x4C, 0x6B, 0x08,
  0x04, 0xC4, 0xC5, 0x30, 0x6A, 0x0E, 0x90, 0x0B, 0x40, 0x6B, 0x8A, 0x50, 0x04, 0x00, 0x00, 0x00,
  // "Ù" (U+00D9)
  0x00, 0x5A, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF9, 0x03, 0xD9, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0D, 0x10, 0x08, 0x00,
  0xB5, 0x00, 0xA0, 0x02, 0xB9, 0x94, 0x00,
  // "Ú" (U+00DA)
  0x00, 0x00, 0xD2, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF9, 0x03, 0xD9, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0D, 0x10, 0x08, 0x00,
  0xB5, 0x00, 0xA0, 0x02, 0xB9, 0x94, 0x00,
  // "Û" (U+00DB)
  0x00, 0x0C, 0x80, 0x00, 0x05, 0x58, 0x20, 0x00, 0x00, 0x00, 0x07, 0xF9, 0x03, 0xD9, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0D, 0x10, 0x08, 0x00,
  0xB5, 0x00, 0xA0, 0x02, 0xB9, 0x94, 0x00,
  // "Ü" (U+00DC)
  0x00, 0x53, 0x62, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x90, 0x3D, 0x90, 0xE1, 0x00, 0x81, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xD1, 0x00, 0x80, 0x0B, 0x50, 0x0A, 0x00,
  0x2B, 0x99, 0x40,
  // "Ý" (U+00DD)
  0x30, 0xD0, 0x24, 0x06, 0x04, 0x73, 0x89, 0x3B, 0xF5, 0x1A, 0xD2, 0x0E, 0x10, 0x63, 0x28, 0x27,
  0x90, 0x94, 0x81, 0xD6, 0x34, 0x07, 0x0B, 0x50, 0x50, 0xA5, 0x05, 0x0A, 0x48, 0x22, 0xBD, 0x52,
  // "Þ" (U+00DE)
  0x4E, 0xB2, 0x00, 0x0A, 0xA8, 0x60, 0x0A, 0x50, 0xB5, 0x0A, 0x50, 0x79, 0x0A, 0x50, 0x79, 0x0A,
  0x50, 0xB4, 0x0A, 0xA9, 0x50, 0x4E, 0xB2, 0x00,
  // "ß" (U+00DF)
  0x04, 0xA7, 0xA0, 0x0C, 0x30, 0x75, 0x4E, 0x19, 0x83, 0x0C, 0x2D, 0x00, 0x0C, 0x1B, 0xA1, 0x0C,
  0x10, 0x8C, 0x0C, 0x35, 0x0D, 0x5E, 0x2A, 0x77,
  // "à" (U+00E0)
  0x10, 0x50, 0xA5, 0x08, 0x02, 0x72, 0x82, 0xB9, 0xB2, 0x28, 0x25, 0x06, 0x72, 0x8A, 0x57, 0x7A,
  0x80, 0x59, 0x06, 0x80, 0x68, 0x08, 0x80, 0x1C, 0x96, 0xC1,
  // "á" (U+00E1)
  0x30, 0xD0, 0x23, 0x06, 0x04, 0x72, 0x82, 0xB9, 0xB2, 0x28, 0x25, 0x06, 0x72, 0x8A, 0x57, 0x7A,
  0x80, 0x59, 0x06, 0x80, 0x68, 0x08, 0x80, 0x1C, 0x96, 0xC1,
  // "â" (U+00E2)
  0x00, 0xC8, 0x00, 0x05, 0x58, 0x20, 0x00, 0x00, 0x00, 0x0B, 0x9B, 0x20, 0x05, 0x06, 0x70, 0x07,
  0x7A, 0x80, 0x59, 0x06, 0x80, 0x68, 0x08, 0x80, 0x1C, 0x96, 0xC1,
  // "ã" (U+00E3)
  0x03, 0xB6, 0x60, 0x05, 0x1A, 0x70, 0x00, 0x00, 0x00, 0x0B, 0x9B, 0x20, 0x05, 0x06, 0x70, 0x07,
  0x7A, 0x80, 0x59, 0x06, 0x80, 0x68, 0x08, 0x80, 0x1C, 0x96, 0xC1,
  // "ä" (U+00E4)
  0x05, 0x36, 0x20, 0x00, 0x00, 0x00, 0x0B, 0x9B, 0x20, 0x05, 0x06, 0x70, 0x07, 0x7A, 0x80, 0x59,
  0x06, 0x80, 0x68, 0x08, 0x80, 0x1C, 0x96, 0xC1,
  // "å" (U+00E5)
  0x02, 0x95, 0x00, 0x07, 0x19, 0x00, 0x02, 0x95, 0x00, 0x0B, 0x9B, 0x20, 0x05, 0x06, 0x70, 0x07,
  0x7A, 0x80, 0x59, 0x06, 0x80, 0x68, 0x08, 0x80, 0x1C, 0x96, 0xC1,
  // "æ" (U+00E6)
  0x0B, 0x9B, 0x89, 0xA3, 0x05, 0x06, 0xB0, 0x3B, 0x08, 0x9B, 0xC8, 0x8A, 0x5A, 0x06, 0x90, 0x00,
  0x68, 0x08, 0xD0, 0x02, 0x1C, 0x95, 0x6C, 0xA4,
  // "ç" (U+00E7)
  0x08, 0x9B, 0x33, 0xB0, 0x54, 0x68, 0x00, 0x06, 0x80, 0x00, 0x3C, 0x00, 0x10, 0x8B, 0xA3, 0x00,
  0x81, 0x00, 0x03, 0x90, 0x03, 0xA4, 0x00,
  // "è" (U+00E8)
  0x10, 0x50, 0xA4, 0x08, 0x02, 0x78, 0x96, 0x89, 0xA2, 0x3A, 0x04, 0xA6, 0xDA, 0xAA, 0x69, 0x30,
  0x20, 0xC2, 0x84, 0x20, 0x7B, 0xA4,
  // "é" (U+00E9)
  0x30, 0xD0, 0x22, 0x06, 0x04, 0x78, 0x96, 0x89, 0xA2, 0x3A, 0x04, 0xA6, 0xDA, 0xAA, 0x69, 0x30,
  0x20, 0xC2, 0x84, 0x20, 0x7B, 0xA4,
  // "ê" (U+00EA)
  0x00, 0xC8, 0x00, 0x55, 0x82, 0x00, 0x00, 0x00, 0x89, 0xA2, 0x3A, 0x04, 0xA6, 0xDA, 0xAA, 0x69,
  0x00, 0x02, 0xC0, 0x02, 0x07, 0xBA, 0x40,
  // "ë" (U+00EB)
  0x05, 0x36, 0x20, 0x00, 0x00, 0x08, 0x9A, 0x23, 0xA0, 0x4A, 0x6D, 0xAA, 0xA6, 0x90, 0x00, 0x2C,
  0x00, 0x20, 0x7B, 0xA4,
  // "ì" (U+00EC)
  0x5A, 0x00, 0x82, 0x00, 0x05, 0xF1, 0x0C, 0x10, 0xC1, 0x0C, 0x10, 0xC2, 0x6E, 0x90,
  // "í" (U+00ED)
  0x00, 0xD2, 0x06, 0x40, 0x00, 0x00, 0x5F, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x20,
  0x6E, 0x90,
  // "î" (U+00EE)
  0x0C, 0x80, 0x55, 0x82, 0x00, 0x00, 0x5F, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x20,
  0x6E, 0x90,
  // "ï" (U+00EF)
  0x53, 0x62, 0x00, 0x00, 0x5F, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x20, 0x6E, 0x90,
  // "ð" (U+00F0)
  0x03, 0x20, 0x30, 0x01, 0xBC, 0x10, 0x01, 0x58, 0x50, 0x04, 0x89, 0xC0, 0x2C, 0x01, 0xF1, 0x58,
  0x00, 0xC3, 0x68, 0x00, 0xC2, 0x3B, 0x00, 0xC0, 0x07, 0x99, 0x40,
  // "ñ" (U+00F1)
  0x03, 0xB6, 0x60, 0x00, 0x51, 0xA7, 0x00, 0x00, 0x00, 0x00, 0x05, 0xE7, 0xBB, 0x00, 0x0C, 0x50,
  0xA4, 0x00, 0xC2, 0x08, 0x50, 0x0C, 0x10, 0x85, 0x00, 0xC1, 0x08, 0x50, 0x5F, 0x90, 0x8B, 0x10,
  // "ò" (U+00F2)
  0x05, 0xA0, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68,
  0x00, 0xC2, 0x68, 0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07, 0x99, 0x50,
  // "ó" (U+00F3)
  0x00, 0x0D, 0x20, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68,
  0x00, 0xC2, 0x68, 0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07, 0x99, 0x50,
  // "ô" (U+00F4)
  0x00, 0xC8, 0x00, 0x05, 0x58, 0x20, 0x00, 0x00, 0x00, 0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68,
  0x00, 0xC2, 0x68, 0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07, 0x99, 0x50,
  // "õ" (U+00F5)
  0x03, 0xB6, 0x60, 0x05, 0x1A, 0x70, 0x00, 0x00, 0x00, 0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68,
  0x00, 0xC2, 0x68, 0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07, 0x99, 0x50,
  // "ö" (U+00F6)
  0x05, 0x36, 0x20, 0x00, 0x00, 0x00, 0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68, 0x00, 0xC2, 0x68,
  0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07, 0x99, 0x50,
  // "÷" (U+00F7)
  0x20, 0x90, 0x33, 0x01, 0x20, 0x38, 0x00, 0x97, 0x09, 0x03, 0x30, 0x12,
  // "ø" (U+00F8)
  0x40, 0x42, 0x8B, 0x27, 0x8A, 0x90, 0x2B, 0x07, 0xD0, 0x68, 0x17, 0xC2, 0x68, 0x80, 0xC2, 0x3D,
  0x50, 0xD2, 0x85, 0xC9, 0x95, 0x01, 0x34,
  // "ù" (U+00F9)
  0x05, 0xA0, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "ú" (U+00FA)
  0x00, 0x0D, 0x20, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "û" (U+00FB)
  0x00, 0xC8, 0x00, 0x05, 0x58, 0x20, 0x00, 0x00, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "ü" (U+00FC)
  0x05, 0x36, 0x20, 0x00, 0x00, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "ý" (U+00FD)
  0x30, 0xD0, 0x23, 0x06, 0x04, 0x71, 0x86, 0xBF, 0x33, 0xE6, 0x1D, 0x20, 0xA2, 0x82, 0xB3, 0x17,
  0x28, 0x25, 0x96, 0x33, 0x0D, 0x09, 0x40, 0x90, 0x84, 0x07, 0x04, 0x30, 0x10, 0xB3, 0x81, 0x5A,
  0x33,
  // "þ" (U+00FE)
  0x07, 0x95, 0x0E, 0x58, 0x2E, 0x7A, 0xA2, 0x85, 0xE3, 0x09, 0x50, 0xE2, 0x82, 0x68, 0x0E, 0x28,
  0x93, 0x68, 0x0E, 0x30, 0x95, 0x0E, 0x7A, 0xA2, 0x0E, 0x50, 0xE4, 0x81, 0x7F, 0x83,
  // "ÿ" (U+00FF)
  0x18, 0x25, 0x36, 0x27, 0x86, 0xBF, 0x33, 0xE6, 0x1D, 0x20, 0xA2, 0x82, 0xB3, 0x17, 0x28, 0x25,
  0x96, 0x33, 0x0D, 0x09, 0x40, 0x90, 0x84, 0x07, 0x04, 0x30, 0x10, 0xB3, 0x81, 0x5A, 0x33,
  // "Ā" (U+0100)
  0x28, 0x26, 0xBB, 0x37, 0x40, 0xE0, 0x14, 0x81, 0x5D, 0x64, 0x81, 0x95, 0xB4, 0x82, 0xA0, 0xF1,
  0x28, 0x35, 0x60, 0xB6, 0x28, 0x3A, 0x98, 0xBB, 0x20, 0xA2, 0x89, 0x01, 0xE1, 0xAC, 0x30, 0x5F,
  0xA0,
  // "ā" (U+0101)
  0x06, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x0B, 0x9B, 0x20, 0x05, 0x06, 0x70, 0x07, 0x7A, 0x80, 0x59,
  0x06, 0x80, 0x68, 0x08, 0x80, 0x1C, 0x96, 0xC1,
  // "Ă" (U+0102)
  0x28, 0x25, 0x04, 0x13, 0x81, 0x2B, 0x97, 0x50, 0xE0, 0x14, 0x81, 0x5D, 0x64, 0x81, 0x95, 0xB4,
  0x82, 0xA0, 0xF1, 0x28, 0x35, 0x60, 0xB6, 0x28, 0x3A, 0x98, 0xBB, 0x20, 0xA2, 0x89, 0x01, 0xE1,
  0xAC, 0x30, 0x5F, 0xA0,
  // "ă" (U+0103)
  0x05, 0x04, 0x10, 0x02, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x9B, 0x20, 0x05, 0x06, 0x70, 0x07,
  0x7A, 0x80, 0x59, 0x06, 0x80, 0x68, 0x08, 0x80, 0x1C, 0x96, 0xC1,
  // "Ą" (U+0104)
  0x30, 0xE0, 0x14, 0x81, 0x5D, 0x64, 0x81, 0x95, 0xB4, 0x82, 0xA0, 0xF1, 0x28, 0x35, 0x60, 0xB6,
  0x28, 0x3A, 0x98, 0xBB, 0x20, 0xA2, 0x89, 0x01, 0xE1, 0xAC, 0x30, 0x5F, 0xA5, 0x05, 0x50, 0x30,
  0x95, 0x81, 0x1B, 0x80,
  // "ą" (U+0105)
  0x0B, 0x9B, 0x20, 0x05, 0x06, 0x70, 0x07, 0x7A, 0x80, 0x59, 0x06, 0x80, 0x68, 0x08, 0x80, 0x1C,
  0x96, 0xC1, 0x00, 0x05, 0x00, 0x00, 0x39, 0x00, 0x00, 0x1B, 0x80,
  // "Ć" (U+0106)
  0x40, 0xD0, 0x23, 0x06, 0x04, 0x71, 0x89, 0x31, 0xA9, 0xB5, 0x0C, 0x30, 0x29, 0x3D, 0x40, 0x60,
  0xB4, 0x06, 0x0B, 0x40, 0x30, 0xD5, 0x0D, 0x04, 0x28, 0x54, 0x02, 0xBA, 0xA4,
  // "ć" (U+0107)
  0x30, 0xD0, 0x22, 0x06, 0x04, 0x78, 0x91, 0x89, 0xB3, 0x3B, 0x05, 0x46, 0x83, 0x06, 0x08, 0x30,
  0x30, 0xC2, 0x84, 0x10, 0x8B, 0xA3,
  // "Ĉ" (U+0108)
  0x30, 0xC0, 0x83, 0x82, 0x55, 0x82, 0x78, 0x93, 0x1A, 0x9B, 0x50, 0xC3, 0x02, 0x93, 0xD4, 0x06,
  0x0B, 0x40, 0x60, 0xB4, 0x03, 0x0D, 0x50, 0xD0, 0x42, 0x85, 0x40, 0x2B, 0xAA, 0x40,
  // "ĉ" (U+0109)
  0x00, 0xC8, 0x00, 0x55, 0x82, 0x00, 0x00, 0x00, 0x89, 0xB3, 0x3B, 0x05, 0x46, 0x80, 0x00, 0x68,
  0x00, 0x03, 0xC0, 0x01, 0x08, 0xBA, 0x30,
  // "Ċ" (U+010A)
  0x30, 0x70, 0x67, 0x18, 0x93, 0x1A, 0x9B, 0x50, 0xC3, 0x02, 0x93, 0xD4, 0x06, 0x0B, 0x40, 0x60,
  0xB4, 0x03, 0x0D, 0x50, 0xD0, 0x42, 0x85, 0x40, 0x2B, 0xAA, 0x40,
  // "ċ" (U+010B)
  0x00, 0x76, 0x00, 0x00, 0x00, 0x08, 0x9B, 0x33, 0xB0, 0x54, 0x68, 0x00, 0x06, 0x80, 0x00, 0x3C,
  0x00, 0x10, 0x8B, 0xA3,
  // "Č" (U+010C)
  0x28, 0x25, 0x58, 0x23, 0x0C, 0x09, 0x71, 0x89, 0x31, 0xA9, 0xB5, 0x0C, 0x30, 0x29, 0x3D, 0x40,
  0x60, 0xB4, 0x06, 0x0B, 0x40, 0x30, 0xD5, 0x0D, 0x04, 0x28, 0x54, 0x02, 0xBA, 0xA4,
  // "č" (U+010D)
  0x05, 0x58, 0x20, 0x0C, 0x90, 0x00, 0x00, 0x00, 0x89, 0xB3, 0x3B, 0x05, 0x46, 0x80, 0x00, 0x68,
  0x00, 0x03, 0xC0, 0x01, 0x08, 0xBA, 0x30,
  // "Ď" (U+010E)
  0x05, 0x58, 0x20, 0x00, 0x0C, 0x90, 0x00, 0x00, 0x00, 0x00, 0x04, 0xE9, 0x7A, 0x40, 0x0A, 0x50,
  0x1D, 0x10, 0xA5, 0x00, 0x97, 0x0A, 0x50, 0x07, 0x90, 0xA5, 0x00, 0x7A, 0x0A, 0x50, 0x09, 0x70,
  0xA5, 0x01, 0xD2, 0x4E, 0x97, 0xA4, 0x00,
  // "ď" (U+010F)
  0x00, 0x06, 0xF3, 0x90, 0x00, 0x0D, 0x41, 0x09, 0xB8, 0xD1, 0x03, 0xB0, 0x2F, 0x10, 0x68, 0x00,
  0xE1, 0x06, 0x80, 0x0E, 0x10, 0x3B, 0x01, 0xF1, 0x00, 0x9B, 0x8C, 0x80,
  // "Đ" (U+0110)
  0x4E, 0x97, 0xA4, 0x00, 0xA5, 0x01, 0xD1, 0x0A, 0x50, 0x09, 0x75, 0xDA, 0x80, 0x79, 0x0A, 0x50,
  0x07, 0xA0, 0xA5, 0x00, 0x97, 0x0A, 0x50, 0x1D, 0x24, 0xE9, 0x7A, 0x40,
  // "đ" (U+0111)
  0x00, 0x06, 0xF1, 0x00, 0x48, 0xE8, 0x09, 0xB8, 0xD1, 0x3B, 0x02, 0xF1, 0x68, 0x00, 0xE1, 0x68,
  0x00, 0xE1, 0x3B, 0x01, 0xF1, 0x09, 0xB8, 0xC8,
  // "Ē" (U+0112)
  0x18, 0x26, 0xBB, 0x37, 0x89, 0x54, 0xE9, 0x7A, 0x60, 0xA5, 0x01, 0x50, 0xA5, 0x48, 0x2A, 0xA8,
  0x62, 0x0A, 0x05, 0x40, 0xA0, 0x54, 0x0A, 0x05, 0x28, 0x59, 0x4E, 0x97, 0x8B,
  // "ē" (U+0113)
  0x06, 0xBB, 0x30, 0x00, 0x00, 0x08, 0x9A, 0x23, 0xA0, 0x4A, 0x6D, 0xAA, 0xA6, 0x90, 0x00, 0x2C,
  0x00, 0x20, 0x7B, 0xA4,
  // "Ĕ" (U+0114)
  0x05, 0x04, 0x10, 0x02, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x97, 0xA6, 0x0A, 0x50, 0x15, 0x0A,
  0x50, 0x00, 0x0A, 0xA8, 0x60, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x09, 0x4E, 0x97,
  0x8B,
  // "ĕ" (U+0115)
  0x05, 0x04, 0x10, 0x2B, 0x90, 0x00, 0x00, 0x00, 0x89, 0xA2, 0x3A, 0x04, 0xA6, 0xDA, 0xAA, 0x69,
  0x00, 0x02, 0xC0, 0x02, 0x07, 0xBA, 0x40,
  // "Ė" (U+0116)
  0x20, 0x70, 0x67, 0x18, 0x95, 0x4E, 0x97, 0xA6, 0x0A, 0x50, 0x15, 0x0A, 0x54, 0x82, 0xAA, 0x86,
  0x20, 0xA0, 0x54, 0x0A, 0x05, 0x40, 0xA0, 0x52, 0x85, 0x94, 0xE9, 0x78, 0xB0,
  // "ė" (U+0117)
  0x00, 0x76, 0x00, 0x00, 0x00, 0x08, 0x9A, 0x23, 0xA0, 0x4A, 0x6D, 0xAA, 0xA6, 0x90, 0x00, 0x2C,
  0x00, 0x20, 0x7B, 0xA4,
  // "Ę" (U+0118)
  0x89, 0x54, 0xE9, 0x7A, 0x60, 0xA5, 0x01, 0x50, 0xA5, 0x48, 0x2A, 0xA8, 0x62, 0x0A, 0x05, 0x40,
  0xA0, 0x54, 0x0A, 0x05, 0x28, 0x59, 0x4E, 0x97, 0x8B, 0x40, 0x40, 0x24, 0x0C, 0x50, 0x90, 0xA0,
  // "ę" (U+0119)
  0x08, 0xAA, 0x13, 0xC0, 0x58, 0x69, 0x03, 0xC6, 0xC9, 0x9A, 0x2A, 0x00, 0x00, 0x7B, 0xC7, 0x00,
  0x59, 0x00, 0x0A, 0x30, 0x00, 0x5C, 0x40,
  // "Ě" (U+011A)
  0x18, 0x25, 0x58, 0x23, 0x0C, 0x09, 0x71, 0x89, 0x54, 0xE9, 0x7A, 0x60, 0xA5, 0x01, 0x50, 0xA5,
  0x48, 0x2A, 0xA8, 0x62, 0x0A, 0x05, 0x40, 0xA0, 0x54, 0x0A, 0x05, 0x28, 0x59, 0x4E, 0x97, 0x8B,
  // "ě" (U+011B)
  0x05, 0x58, 0x20, 0x0C, 0x90, 0x00, 0x00, 0x00, 0x89, 0xA2, 0x3A, 0x04, 0xA6, 0xDA, 0xAA, 0x69,
  0x00, 0x02, 0xC0, 0x02, 0x07, 0xBA, 0x40,
  // "Ĝ" (U+011C)
  0x30, 0xC0, 0x84, 0x82, 0x55, 0x82, 0x72, 0x83, 0x19, 0x9A, 0xB2, 0x0C, 0x04, 0x28, 0x2B, 0x23,
  0xD5, 0x06, 0x0B, 0x50, 0x60, 0xB2, 0x83, 0x5B, 0x93, 0xD3, 0x83, 0xC3, 0x0C, 0x52, 0x87, 0xC3,
  0x01, 0xAA, 0x8B, 0x10,
  // "ĝ" (U+011D)
  0x20, 0xC0, 0x83, 0x82, 0x55, 0x82, 0x71, 0x89, 0x6A, 0xCA, 0xC2, 0x3B, 0x0A, 0x40, 0x2A, 0x0A,
  0x42, 0x81, 0xA8, 0x73, 0x09, 0x58, 0x93, 0xCF, 0xE7, 0x08, 0x40, 0x1D, 0x0B, 0x12, 0x85, 0xB0,
  0x3A, 0x89, 0x31,
  // "Ğ" (U+011E)
  0x28, 0x25, 0x04, 0x13, 0x81, 0x2B, 0x97, 0x38, 0x31, 0x99, 0xAB, 0x20, 0xC0, 0x42, 0x82, 0xB2,
  0x3D, 0x50, 0x60, 0xB5, 0x06, 0x0B, 0x28, 0x35, 0xB9, 0x3D, 0x38, 0x3C, 0x30, 0xC5, 0x28, 0x7C,
  0x30, 0x1A, 0xA8, 0xB1,
  // "ğ" (U+011F)
  0x05, 0x04, 0x10, 0x02, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xCA, 0xC2, 0x3B, 0x0A, 0x40, 0x2A,
  0x0A, 0x40, 0x0A, 0x87, 0x00, 0x09, 0x00, 0x00, 0x0C, 0xFE, 0x70, 0x84, 0x01, 0xD0, 0xB1, 0x00,
  0xB0, 0x3A, 0x89, 0x30,
  // "Ġ" (U+0120)
  0x30, 0x70, 0x67, 0x38, 0x31, 0x99, 0xAB, 0x20, 0xC0, 0x42, 0x82, 0xB2, 0x3D, 0x50, 0x60, 0xB5,
  0x06, 0x0B, 0x28, 0x35, 0xB9, 0x3D, 0x38, 0x3C, 0x30, 0xC5, 0x28, 0x7C, 0x30, 0x1A, 0xA8, 0xB1,
  // "ġ" (U+0121)
  0x20, 0x70, 0x67, 0x28, 0x96, 0xAC, 0xAC, 0x23, 0xB0, 0xA4, 0x02, 0xA0, 0xA4, 0x28, 0x1A, 0x87,
  0x30, 0x95, 0x89, 0x3C, 0xFE, 0x70, 0x84, 0x01, 0xD0, 0xB1, 0x28, 0x5B, 0x03, 0xA8, 0x93, 0x10,
  // "Ģ" (U+0122)
  0x01, 0x99, 0xAB, 0x00, 0xC4, 0x00, 0xB2, 0x3D, 0x00, 0x00, 0x06, 0xB0, 0x00, 0x00, 0x6B, 0x00,
  0x5B, 0x93, 0xD0, 0x00, 0xC3, 0x0C, 0x50, 0x0C, 0x30, 0x1A, 0xA8, 0xB1, 0x00, 0x05, 0x60, 0x00,
  0x00, 0x81, 0x00,
  // "ģ" (U+0123)
  0x00, 0x54, 0x00, 0x00, 0x91, 0x00, 0x0A, 0xCA, 0xC2, 0x3B, 0x0A, 0x40, 0x2A, 0x0A, 0x40, 0x0A,
  0x87, 0x00, 0x09, 0x00, 0x00, 0x0C, 0xFE, 0x70, 0x84, 0x01, 0xD0, 0xB1, 0x00, 0xB0, 0x3A, 0x89,
  0x30,
  // "Ĥ" (U+0124)
  0x00, 0x0C, 0x80, 0x00, 0x00, 0x55, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0xB2, 0x2C, 0xD4,
  0x0A, 0x50, 0x06, 0x90, 0x0A, 0x50, 0x06, 0x90, 0x0A, 0xA8, 0x8B, 0x90, 0x0A, 0x50, 0x06, 0x90,
  0x0A, 0x50, 0x06, 0x90, 0x0A, 0x50, 0x06, 0x90, 0x4E, 0xB2, 0x2C, 0xD4,
  // "ĥ" (U+0125)
  0x20, 0xC0, 0x83, 0x82, 0x55, 0x82, 0x70, 0x69, 0x50, 0xE5, 0x82, 0xE7, 0xBA, 0x28, 0x5E, 0x30,
  0xC2, 0x0E, 0x28, 0x2A, 0x40, 0xE2, 0x82, 0xA4, 0x0E, 0x28, 0x6A, 0x46, 0xF7, 0x0A, 0xA0,
  // "Ħ" (U+0126)
  0x4E, 0xB2, 0x2C, 0xD4, 0x0A, 0x50, 0x06, 0x90, 0x5D, 0xB8, 0x8B, 0xC4, 0x0A, 0xB8, 0x8B, 0x90,
  0x0A, 0x50, 0x06, 0x90, 0x0A, 0x50, 0x06, 0x90, 0x0A, 0x50, 0x06, 0x90, 0x4E, 0xB2, 0x2C, 0xD4,
  // "ħ" (U+0127)
  0x6F, 0x00, 0x00, 0x6E, 0x85, 0x00, 0x0E, 0x7B, 0xA0, 0x0E, 0x30, 0xC2, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x6F, 0x80, 0xAB,
  // "Ĩ" (U+0128)
  0x3B, 0x66, 0x51, 0xA7, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x0A, 0x50, 0x4E, 0xB2,
  // "ĩ" (U+0129)
  0x3B, 0x66, 0x51, 0xA7, 0x00, 0x00, 0x05, 0xF1, 0x00, 0xC1, 0x00, 0xC1, 0x00, 0xC1, 0x00, 0xC2,
  0x06, 0xE9,
  // "Ī" (U+012A)
  0x6B, 0xB3, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x4E, 0xB2,
  // "ī" (U+012B)
  0x6B, 0xB3, 0x00, 0x00, 0x5F, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x20, 0x6E, 0x90,
  // "Ĭ" (U+012C)
  0x50, 0x41, 0x2B, 0x90, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x0A, 0x50, 0x4E, 0xB2,
  // "ĭ" (U+012D)
  0x50, 0x41, 0x2B, 0x90, 0x00, 0x00, 0x5F, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x10, 0x0C, 0x20,
  0x6E, 0x90,
  // "Į" (U+012E)
  0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x4E, 0xB2,
  0x04, 0x20, 0x0C, 0x00, 0x09, 0xA0,
  // "į" (U+012F)
  0x0C, 0x10, 0x30, 0x5F, 0x10, 0xC1, 0x0C, 0x10, 0xC1, 0x0C, 0x26, 0xE9, 0x04, 0x20, 0xC0, 0x09,
  0xA0,
  // "İ" (U+0130)
  0x07, 0x60, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x4E, 0xB2,
  // "ı" (U+0131)
  0x5F, 0x10, 0xC1, 0x0C, 0x10, 0xC1, 0x0C, 0x26, 0xE9,
  // "Ĳ" (U+0132)
  0x4E, 0xB7, 0xEB, 0x20, 0xA5, 0x0A, 0x50, 0x0A, 0x50, 0xA5, 0x00, 0xA5, 0x0A, 0x50, 0x0A, 0x50,
  0xA5, 0x00, 0xA5, 0x0A, 0x50, 0x0A, 0x50, 0xA5, 0x04, 0xEB, 0x2A, 0x50, 0x00, 0x00, 0xA5, 0x00,
  0x00, 0x0C, 0x20, 0x00, 0x09, 0x80, 0x00,
  // "ĳ" (U+0133)
  0x0C, 0x10, 0xD0, 0x30, 0x03, 0x5F, 0x17, 0xF0, 0xC1, 0x0E, 0x0C, 0x10, 0xE0, 0xC1, 0x0E, 0x0C,
  0x20, 0xE6, 0xE9, 0x0E, 0x00, 0x00, 0xE0, 0x00, 0x0D, 0x00, 0x19, 0x50,
  // "Ĵ" (U+0134)
  0x0C, 0x80, 0x55, 0x82, 0x00, 0x00, 0x4E, 0xB2, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50,
  0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0A, 0x50, 0x0C, 0x20, 0x98, 0x00,
  // "ĵ" (U+0135)
  0x18, 0x5C, 0x80, 0x55, 0x82, 0x50, 0x79, 0x30, 0xE3, 0x0E, 0x30, 0xE3, 0x0E, 0x30, 0xE3, 0x0E,
  0x38, 0x3D, 0x01, 0x95, 0x10,
  // "Ķ" (U+0136)
  0x4E, 0xB2, 0x4F, 0x60, 0xA5, 0x06, 0x50, 0x0A, 0x52, 0x80, 0x00, 0xA6, 0xD1, 0x00, 0x0A, 0xCA,
  0x90, 0x00, 0xA5, 0x1E, 0x40, 0x0A, 0x50, 0x6D, 0x04, 0xEB, 0x20, 0x9B, 0x00, 0x05, 0x60, 0x00,
  0x00, 0x81, 0x00,
  // "ķ" (U+0137)
  0x6F, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x0E, 0x07, 0xE3, 0x0E, 0x0A, 0x20, 0x0E, 0x98, 0x00, 0x0E,
  0x7D, 0x10, 0x0E, 0x07, 0xA0, 0x6F, 0x80, 0xB8, 0x00, 0x56, 0x00, 0x00, 0x81, 0x00,
  // "ĸ" (U+0138)
  0x7F, 0x07, 0xE3, 0x0E, 0x0A, 0x20, 0x0E, 0x98, 0x00, 0x0E, 0x7D, 0x10, 0x0E, 0x07, 0xA0, 0x7F,
  0x80, 0xB8,
  // "Ĺ" (U+0139)
  0x20, 0xD0, 0x23, 0x06, 0x04, 0x72, 0x82, 0x4E, 0xB2, 0x30, 0xA0, 0x54, 0x0A, 0x05, 0x40, 0xA0,
  0x54, 0x0A, 0x05, 0x40, 0xA0, 0x52, 0x82, 0x30, 0xA5, 0x28, 0x59, 0x4E, 0x97, 0x8B,
  // "ĺ" (U+013A)
  0x28, 0x3D, 0x20, 0x64, 0x50, 0x79, 0x30, 0xE3, 0x0E, 0x30, 0xE3, 0x0E, 0x30, 0xE3, 0x0E, 0x28,
  0x17, 0xF8, 0x10,
  // "Ļ" (U+013B)
  0x4E, 0xB2, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A,
  0x50, 0x03, 0x0A, 0x50, 0x09, 0x4E, 0x97, 0x8B, 0x00, 0x56, 0x00, 0x00, 0x81, 0x00,
  // "ļ" (U+013C)
  0x7F, 0x00, 0xE0, 0x0E, 0x00, 0xE0, 0x0E, 0x00, 0xE0, 0x0E, 0x07, 0xF8, 0x56, 0x08, 0x10,
  // "Ľ" (U+013D)
  0x4E, 0xB2, 0x83, 0x0A, 0x50, 0x50, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A,
  0x50, 0x03, 0x0A, 0x50, 0x09, 0x4E, 0x97, 0x8B,
  // "ľ" (U+013E)
  0x7F, 0x38, 0x0E, 0x41, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x7F, 0x80,
  // "Ŀ" (U+013F)
  0x4E, 0xB2, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x50, 0x76, 0x0A, 0x50, 0x00, 0x0A,
  0x50, 0x03, 0x0A, 0x50, 0x09, 0x4E, 0x97, 0x8B,
  // "ŀ" (U+0140)
  0x7F, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x76, 0x0E, 0x10, 0x0E, 0x00, 0x7F, 0x80,
  // "Ł" (U+0141)
  0x4E, 0xB2, 0x00, 0x0A, 0x50, 0x00, 0x0A, 0x52, 0x00, 0x0A, 0xB6, 0x00, 0x3D, 0x50, 0x00, 0x2A,
  0x50, 0x03, 0x0A, 0x50, 0x09, 0x4E, 0x97, 0x8B,
  // "ł" (U+0142)
  0x5E, 0x20, 0xB2, 0x0B, 0x20, 0xB6, 0x1D, 0x64, 0xC2, 0x0B, 0x25, 0xEA,
  // "Ń" (U+0143)
  0x40, 0xD0, 0x25, 0x06, 0x04, 0x74, 0x89, 0x54, 0xE7, 0x01, 0xAC, 0x20, 0xAE, 0x10, 0x36, 0x28,
  0x49, 0x8A, 0x03, 0x62, 0x84, 0x90, 0xD3, 0x36, 0x28, 0x49, 0x05, 0xC3, 0x62, 0x09, 0x28, 0x1B,
  0x96, 0x20, 0x92, 0x85, 0x3F, 0x60, 0x4E, 0x72, 0x09, 0x06, 0x10,
  // "ń" (U+0144)
  0x30, 0xD0, 0x24, 0x06, 0x04, 0x73, 0x83, 0x5E, 0x7B, 0xB3, 0x83, 0xC5, 0x0A, 0x42, 0x83, 0xC2,
  0x08, 0x52, 0x83, 0xC1, 0x08, 0x52, 0x89, 0x3C, 0x10, 0x85, 0x05, 0xF9, 0x08, 0xB1,
  // "Ņ" (U+0145)
  0x4E, 0x70, 0x1A, 0xC2, 0x0A, 0xE1, 0x03, 0x60, 0x09, 0x8A, 0x03, 0x60, 0x09, 0x0D, 0x33, 0x60,
  0x09, 0x05, 0xC3, 0x60, 0x09, 0x00, 0xB9, 0x60, 0x09, 0x00, 0x3F, 0x60, 0x4E, 0x70, 0x09, 0x60,
  0x00, 0x05, 0x60, 0x00, 0x00, 0x08, 0x10, 0x00,
  // "ņ" (U+0146)
  0x5E, 0x7B, 0xB0, 0x00, 0xC5, 0x0A, 0x40, 0x0C, 0x20, 0x85, 0x00, 0xC1, 0x08, 0x50, 0x0C, 0x10,
  0x85, 0x05, 0xF9, 0x08, 0xB1, 0x00, 0x56, 0x00, 0x00, 0x08, 0x10, 0x00,
  // "Ň" (U+0147)
  0x00, 0x55, 0x82, 0x00, 0x00, 0x0C, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x70, 0x1A, 0xC2,
  0x0A, 0xE1, 0x03, 0x60, 0x09, 0x8A, 0x03, 0x60, 0x09, 0x0D, 0x33, 0x60, 0x09, 0x05, 0xC3, 0x60,
  0x09, 0x00, 0xB9, 0x60, 0x09, 0x00, 0x3F, 0x60, 0x4E, 0x70, 0x09, 0x60,
  // "ň" (U+0148)
  0x18, 0x25, 0x58, 0x24, 0x0C, 0x09, 0x73, 0x83, 0x5E, 0x7B, 0xB3, 0x83, 0xC5, 0x0A, 0x42, 0x83,
  0xC2, 0x08, 0x52, 0x83, 0xC1, 0x08, 0x52, 0x89, 0x3C, 0x10, 0x85, 0x05, 0xF9, 0x08, 0xB1,
  // "ŉ" (U+0149)
  0x05, 0x0B, 0x60, 0x10, 0xB6, 0x84, 0x5A, 0xE7, 0xBB, 0x48, 0x3C, 0x50, 0xA4, 0x38, 0x3C, 0x20,
  0x85, 0x38, 0x3C, 0x10, 0x85, 0x38, 0x3C, 0x10, 0x85, 0x28, 0x55, 0xF9, 0x08, 0xB1,
  // "Ŋ" (U+014A)
  0x4E, 0x70, 0x1A, 0xC2, 0x0A, 0xE1, 0x03, 0x60, 0x09, 0x7A, 0x03, 0x60, 0x09, 0x0D, 0x43, 0x60,
  0x09, 0x04, 0xD3, 0x60, 0x09, 0x00, 0xAA, 0x60, 0x09, 0x00, 0x2F, 0x60, 0x4E, 0x70, 0x07, 0x60,
  0x00, 0x00, 0x03, 0x60, 0x00, 0x00, 0x05, 0x40, 0x00, 0x00, 0x2A, 0x00,
  // "ŋ" (U+014B)
  0x6E, 0x7B, 0xB0, 0x0C, 0x50, 0xA4, 0x0C, 0x20, 0x85, 0x0C, 0x10, 0x85, 0x0C, 0x10, 0x85, 0x5F,
  0x90, 0x85, 0x00, 0x00, 0x85, 0x00, 0x00, 0xA3, 0x00, 0x05, 0x90,
  // "Ō" (U+014C)
  0x00, 0x6B, 0xB3, 0x00, 0x00, 0x00, 0x00, 0x02, 0xA9, 0xA5, 0x00, 0xD2, 0x00, 0xB4, 0x3C, 0x00,
  0x06, 0xA6, 0xB0, 0x00, 0x4C, 0x6B, 0x00, 0x04, 0xC3, 0xC0, 0x00, 0x6A, 0x0D, 0x20, 0x0B, 0x40,
  0x2A, 0x8A, 0x50,
  // "ō" (U+014D)
  0x06, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68, 0x00, 0xC2, 0x68,
  0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07, 0x99, 0x50,
  // "Ŏ" (U+014E)
  0x28, 0x25, 0x04, 0x13, 0x81, 0x2B, 0x97, 0x38, 0x32, 0xA9, 0xA5, 0x20, 0xD0, 0x22, 0x82, 0xB4,
  0x3C, 0x38, 0x26, 0xA6, 0xB3, 0x82, 0x4C, 0x6B, 0x38, 0x24, 0xC3, 0xC3, 0x83, 0x6A, 0x0D, 0x22,
  0x86, 0xB4, 0x02, 0xA8, 0xA5, 0x10,
  // "ŏ" (U+014F)
  0x05, 0x04, 0x10, 0x02, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68,
  0x00, 0xC2, 0x68, 0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07, 0x99, 0x50,
  // "Ő" (U+0150)
  0x38, 0x1B, 0x3B, 0x38, 0x26, 0x58, 0x37, 0x28, 0x32, 0xA9, 0xA5, 0x20, 0xD0, 0x22, 0x82, 0xB4,
  0x3C, 0x38, 0x26, 0xA6, 0xB3, 0x82, 0x4C, 0x6B, 0x38, 0x24, 0xC3, 0xC3, 0x83, 0x6A, 0x0D, 0x22,
  0x86, 0xB4, 0x02, 0xA8, 0xA5, 0x10,
  // "ő" (U+0151)
  0x00, 0xB3, 0xB0, 0x06, 0x58, 0x30, 0x00, 0x00, 0x00, 0x07, 0x89, 0x40, 0x3B, 0x00, 0xD0, 0x68,
  0x00, 0xC2, 0x68, 0x00, 0xC2, 0x2B, 0x00, 0xD0, 0x07, 0x99, 0x50,
  // "Œ" (U+0152)
  0x02, 0xAA, 0xCD, 0x9A, 0xC0, 0x0D, 0x30, 0x4A, 0x00, 0x70, 0x3C, 0x00, 0x4A, 0x00, 0x00, 0x6B,
  0x00, 0x4D, 0x88, 0x00, 0x6B, 0x00, 0x4A, 0x00, 0x00, 0x3C, 0x00, 0x4A, 0x00, 0x00, 0x0D, 0x20,
  0x4A, 0x00, 0x72, 0x02, 0xA8, 0xBD, 0x88, 0xE1,
  // "œ" (U+0153)
  0x07, 0x89, 0x49, 0x8A, 0x03, 0xB0, 0x0E, 0x50, 0x86, 0x68, 0x00, 0xCB, 0xAB, 0x66, 0x80, 0x0C,
  0x40, 0x00, 0x2B, 0x00, 0xE8, 0x00, 0x10, 0x79, 0xA4, 0x9A, 0xA1,
  // "Ŕ" (U+0154)
  0x30, 0xD0, 0x24, 0x06, 0x04, 0x73, 0x83, 0x4E, 0x97, 0x93, 0x83, 0xA5, 0x08, 0x72, 0x83, 0xA5,
  0x07, 0x92, 0x83, 0xA5, 0x0A, 0x42, 0x82, 0xAA, 0xC7, 0x38, 0x2A, 0x56, 0xC3, 0x89, 0x3A, 0x50,
  0xC6, 0x04, 0xEB, 0x23, 0xD5,
  // "ŕ" (U+0155)
  0x00, 0xD2, 0x00, 0x64, 0x00, 0x00, 0x00, 0x05, 0xE6, 0xD6, 0x0C, 0x53, 0x20, 0xC2, 0x00, 0x0C,
  0x10, 0x00, 0xC1, 0x00, 0x5F, 0x91, 0x00,
  // "Ŗ" (U+0156)
  0x4E, 0x97, 0x90, 0x00, 0xA5, 0x08, 0x70, 0x0A, 0x50, 0x79, 0x00, 0xA5, 0x0A, 0x40, 0x0A, 0xAC,
  0x70, 0x00, 0xA5, 0x6C, 0x00, 0x0A, 0x50, 0xC6, 0x04, 0xEB, 0x23, 0xD5, 0x00, 0x56, 0x00, 0x00,
  0x08, 0x10, 0x00,
  // "ŗ" (U+0157)
  0x5E, 0x6D, 0x60, 0xC5, 0x32, 0x0C, 0x20, 0x00, 0xC1, 0x00, 0x0C, 0x10, 0x05, 0xF9, 0x10, 0x05,
  0x60, 0x00, 0x81, 0x00,
  // "Ř" (U+0158)
  0x18, 0x25, 0x58, 0x24, 0x0C, 0x09, 0x73, 0x83, 0x4E, 0x97, 0x93, 0x83, 0xA5, 0x08, 0x72, 0x83,
  0xA5, 0x07, 0x92, 0x83, 0xA5, 0x0A, 0x42, 0x82, 0xAA, 0xC7, 0x38, 0x2A, 0x56, 0xC3, 0x89, 0x3A,
  0x50, 0xC6, 0x04, 0xEB, 0x23, 0xD5,
  // "ř" (U+0159)
  0x55, 0x82, 0x00, 0xC9, 0x00, 0x00, 0x00, 0x05, 0xE6, 0xD6, 0x0C, 0x53, 0x20, 0xC2, 0x00, 0x0C,
  0x10, 0x00, 0xC1, 0x00, 0x5F, 0x91, 0x00,
  // "Ś" (U+015A)
  0x30, 0xD0, 0x22, 0x06, 0x04, 0x78, 0x91, 0x87, 0xB4, 0x58, 0x03, 0x65, 0xB4, 0x81, 0xCB, 0x33,
  0x81, 0x6E, 0x63, 0x89, 0x23, 0xD6, 0x50, 0x1C, 0x2B, 0x89, 0x30,
  // "ś" (U+015B)
  0x00, 0xD2, 0x06, 0x40, 0x00, 0x00, 0x19, 0x88, 0x66, 0x05, 0x2D, 0x80, 0x01, 0x9C, 0x52, 0x0C,
  0x4A, 0x87,
  // "Ŝ" (U+015C)
  0x00, 0xC8, 0x00, 0x55, 0x82, 0x00, 0x00, 0x00, 0x87, 0xB4, 0x58, 0x03, 0x65, 0xB0, 0x00, 0x0C,
  0xB3, 0x00, 0x06, 0xE6, 0x00, 0x03, 0xD6, 0x50, 0x1C, 0x2B, 0x89, 0x30,
  // "ŝ" (U+015D)
  0x00, 0xC8, 0x00, 0x55, 0x82, 0x00, 0x00, 0x01, 0x98, 0x80, 0x66, 0x05, 0x02, 0xD8, 0x00, 0x01,
  0x9C, 0x05, 0x20, 0xC0, 0x4A, 0x87, 0x00,
  // "Ş" (U+015E)
  0x08, 0x7B, 0x45, 0x80, 0x36, 0x5B, 0x00, 0x00, 0xCB, 0x30, 0x00, 0x6E, 0x60, 0x00, 0x3D, 0x65,
  0x01, 0xC2, 0xB8, 0x93, 0x00, 0x81, 0x00, 0x03, 0x90, 0x03, 0xA4, 0x00,
  // "ş" (U+015F)
  0x19, 0x88, 0x66, 0x05, 0x2D, 0x80, 0x01, 0x9C, 0x52, 0x0C, 0x4A, 0x87, 0x00, 0x81, 0x00, 0x39,
  0x03, 0xA4,
  // "Š" (U+0160)
  0x05, 0x58, 0x20, 0x0C, 0x90, 0x00, 0x00, 0x00, 0x87, 0xB4, 0x58, 0x03, 0x65, 0xB0, 0x00, 0x0C,
  0xB3, 0x00, 0x06, 0xE6, 0x00, 0x03, 0xD6, 0x50, 0x1C, 0x2B, 0x89, 0x30,
  // "š" (U+0161)
  0x55, 0x82, 0x0C, 0x90, 0x00, 0x00, 0x19, 0x88, 0x66, 0x05, 0x2D, 0x80, 0x01, 0x9C, 0x52, 0x0C,
  0x4A, 0x87,
  // "Ţ" (U+0162)
  0x89, 0x2B, 0x9B, 0xC8, 0xD8, 0x07, 0x80, 0x82, 0x07, 0x08, 0x40, 0x70, 0x84, 0x07, 0x08, 0x40,
  0x70, 0x84, 0x07, 0x08, 0x38, 0x23, 0xCD, 0x43, 0x05, 0x04, 0x50, 0xC4, 0x09, 0x08, 0x20,
  // "ţ" (U+0163)
  0x04, 0x00, 0x1C, 0x00, 0x8E, 0x91, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0E, 0x00, 0x0A, 0x92,
  0x05, 0x40, 0x00, 0xC0, 0x09, 0x80,
  // "Ť" (U+0164)
  0x18, 0x25, 0x58, 0x23, 0x0C, 0x09, 0x71, 0x89, 0x2B, 0x9B, 0xC8, 0xD8, 0x07, 0x80, 0x82, 0x07,
  0x08, 0x40, 0x70, 0x84, 0x07, 0x08, 0x40, 0x70, 0x84, 0x07, 0x08, 0x38, 0x23, 0xCD, 0x41,
  // "ť" (U+0165)
  0x00, 0x29, 0x19, 0x41, 0x8E, 0x91, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0E, 0x00, 0x0A, 0x92,
  // "Ŧ" (U+0166)
  0xB9, 0xBC, 0x8D, 0x90, 0x78, 0x09, 0x10, 0x78, 0x01, 0x00, 0x78, 0x00, 0x18, 0xBC, 0x82, 0x00,
  0x78, 0x00, 0x00, 0x78, 0x00, 0x03, 0xCD, 0x40,
  // "ŧ" (U+0167)
  0x04, 0x00, 0x1C, 0x00, 0x8E, 0x91, 0x0D, 0x00, 0x6E, 0x80, 0x0D, 0x00, 0x0E, 0x00, 0x0A, 0x92,
  // "Ũ" (U+0168)
  0x00, 0x3B, 0x66, 0x00, 0x05, 0x1A, 0x70, 0x00, 0x00, 0x00, 0x07, 0xF9, 0x03, 0xD9, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0D, 0x10, 0x08, 0x00,
  0xB5, 0x00, 0xA0, 0x02, 0xB9, 0x94, 0x00,
  // "ũ" (U+0169)
  0x03, 0xB6, 0x60, 0x05, 0x1A, 0x70, 0x00, 0x00, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "Ū" (U+016A)
  0x00, 0x6B, 0xB3, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x90, 0x3D, 0x90, 0xE1, 0x00, 0x81, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xD1, 0x00, 0x80, 0x0B, 0x50, 0x0A, 0x00,
  0x2B, 0x99, 0x40,
  // "ū" (U+016B)
  0x06, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "Ŭ" (U+016C)
  0x00, 0x50, 0x41, 0x00, 0x02, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF9, 0x03, 0xD9, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0D, 0x10, 0x08, 0x00,
  0xB5, 0x00, 0xA0, 0x02, 0xB9, 0x94, 0x00,
  // "ŭ" (U+016D)
  0x05, 0x04, 0x10, 0x02, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "Ů" (U+016E)
  0x00, 0x29, 0x50, 0x00, 0x07, 0x19, 0x00, 0x00, 0x29, 0x50, 0x07, 0xF9, 0x03, 0xD9, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0D, 0x10, 0x08, 0x00,
  0xB5, 0x00, 0xA0, 0x02, 0xB9, 0x94, 0x00,
  // "ů" (U+016F)
  0x02, 0x95, 0x00, 0x07, 0x19, 0x00, 0x02, 0x95, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "Ű" (U+0170)
  0x00, 0x0B, 0x3B, 0x00, 0x06, 0x58, 0x30, 0x00, 0x00, 0x00, 0x07, 0xF9, 0x03, 0xD9, 0x0E, 0x10,
  0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0D, 0x10, 0x08, 0x00,
  0xB5, 0x00, 0xA0, 0x02, 0xB9, 0x94, 0x00,
  // "ű" (U+0171)
  0x00, 0xB3, 0xB0, 0x06, 0x58, 0x30, 0x00, 0x00, 0x00, 0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E,
  0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06, 0xC9, 0x9B,
  // "Ų" (U+0172)
  0x7F, 0x90, 0x3D, 0x90, 0xE1, 0x00, 0x81, 0x0E, 0x10, 0x08, 0x10, 0xE1, 0x00, 0x81, 0x0E, 0x10,
  0x08, 0x10, 0xD1, 0x00, 0x80, 0x0B, 0x50, 0x0A, 0x00, 0x2B, 0x99, 0x40, 0x00, 0x04, 0x20, 0x00,
  0x00, 0xC0, 0x00, 0x00, 0x09, 0xA0, 0x00,
  // "ų" (U+0173)
  0x6F, 0x04, 0xE4, 0x0E, 0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0E, 0x00, 0xA4, 0x0D, 0x10, 0xD4, 0x06,
  0xC9, 0x9B, 0x00, 0x00, 0x50, 0x00, 0x03, 0x90, 0x00, 0x01, 0xB8,
  // "Ŵ" (U+0174)
  0x50, 0xC0, 0x87, 0x18, 0x25, 0x58, 0x27, 0x78, 0x48, 0xF7, 0x01, 0xD2, 0x89, 0x39, 0xD2, 0x0E,
  0x10, 0x5F, 0x20, 0x46, 0x28, 0x7A, 0x50, 0x8A, 0x60, 0x72, 0x28, 0x66, 0x90, 0x95, 0xA0, 0xA3,
  0x86, 0x2D, 0x18, 0x1D, 0x09, 0x48, 0x5D, 0x64, 0x0C, 0x65, 0x40, 0x90, 0xC2, 0x81, 0x8D, 0x14,
  0x05, 0x0C, 0x20, 0x40, 0xD3,
  // "ŵ" (U+0175)
  0x40, 0xC0, 0x86, 0x82, 0x55, 0x82, 0x74, 0x89, 0x7B, 0xE3, 0x0D, 0x04, 0xE5, 0x2D, 0x05, 0xD3,
  0x08, 0x28, 0x5D, 0x18, 0x67, 0x26, 0x28, 0x59, 0x58, 0x1C, 0x62, 0x28, 0x45, 0xB4, 0x0C, 0x93,
  0x01, 0x0E, 0x20, 0x70, 0x82,
  // "Ŷ" (U+0176)
  0x20, 0xC0, 0x84, 0x82, 0x55, 0x82, 0x72, 0x89, 0x3B, 0xF5, 0x1A, 0xD2, 0x0E, 0x10, 0x63, 0x28,
  0x27, 0x90, 0x94, 0x81, 0xD6, 0x34, 0x07, 0x0B, 0x50, 0x50, 0xA5, 0x05, 0x0A, 0x48, 0x22, 0xBD,
  0x52,
  // "ŷ" (U+0177)
  0x20, 0xC0, 0x83, 0x82, 0x55, 0x82, 0x78, 0x6B, 0xF3, 0x3E, 0x61, 0xD2, 0x0A, 0x28, 0x2B, 0x31,
  0x72, 0x82, 0x59, 0x63, 0x30, 0xD0, 0x94, 0x09, 0x08, 0x40, 0x70, 0x43, 0x01, 0x0B, 0x38, 0x15,
  0xA3, 0x30,
  // "Ÿ" (U+0178)
  0x18, 0x25, 0x36, 0x27, 0x28, 0x93, 0xBF, 0x51, 0xAD, 0x20, 0xE1, 0x06, 0x32, 0x82, 0x79, 0x09,
  0x48, 0x1D, 0x63, 0x40, 0x70, 0xB5, 0x05, 0x0A, 0x50, 0x50, 0xA4, 0x82, 0x2B, 0xD5, 0x20,
  // "Ź" (U+0179)
  0x30, 0xD0, 0x23, 0x06, 0x04, 0x71, 0x89, 0x16, 0xB8, 0x8F, 0x46, 0x20, 0x6B, 0x40, 0xD0, 0x33,
  0x07, 0x0A, 0x38, 0x11, 0xE2, 0x30, 0x80, 0x93, 0x89, 0x21, 0xE1, 0x01, 0x78, 0xD8, 0x8B, 0x70,
  // "ź" (U+017A)
  0x30, 0xD0, 0x22, 0x06, 0x04, 0x68, 0x75, 0xB9, 0xE6, 0x30, 0x3C, 0x30, 0xC0, 0x42, 0x05, 0x0A,
  0x38, 0x7D, 0x20, 0x57, 0xD9, 0xA7,
  // "Ż" (U+017B)
  0x20, 0x70, 0x67, 0x18, 0x91, 0x6B, 0x88, 0xF4, 0x62, 0x06, 0xB4, 0x0D, 0x03, 0x30, 0x70, 0xA3,
  0x81, 0x1E, 0x23, 0x08, 0x09, 0x38, 0x92, 0x1E, 0x10, 0x17, 0x8D, 0x88, 0xB7,
  // "ż" (U+017C)
  0x00, 0x76, 0x00, 0x00, 0x00, 0x5B, 0x9E, 0x63, 0x03, 0xC0, 0x00, 0xC4, 0x00, 0x5A, 0x00, 0x0D,
  0x20, 0x57, 0xD9, 0xA7,
  // "Ž" (U+017D)
  0x05, 0x58, 0x20, 0x00, 0xC9, 0x00, 0x00, 0x00, 0x00, 0x6B, 0x88, 0xF4, 0x62, 0x06, 0xB0, 0x00,
  0x0D, 0x30, 0x00, 0x7A, 0x00, 0x01, 0xE2, 0x00, 0x08, 0x90, 0x00, 0x1E, 0x10, 0x17, 0x8D, 0x88,
  0xB7,
  // "ž" (U+017E)
  0x05, 0x58, 0x20, 0x0C, 0x90, 0x00, 0x00, 0x05, 0xB9, 0xE6, 0x30, 0x3C, 0x00, 0x0C, 0x40, 0x05,
  0xA0, 0x00, 0xD2, 0x05, 0x7D, 0x9A, 0x70,
  // "ſ" (U+017F)
  0x18, 0x65, 0x9C, 0x10, 0xD0, 0x32, 0x0E, 0x40, 0xE4, 0x0E, 0x40, 0xE4, 0x0E, 0x38, 0x27, 0xF8,
  0x11,
  // "Ω" (U+03A9)
  0x03, 0xA9, 0xA8, 0x00, 0x0E, 0x20, 0x09, 0x70, 0x4C, 0x00, 0x04, 0xC0, 0x5B, 0x00, 0x03, 0xD0,
  0x1E, 0x00, 0x06, 0x90, 0x06, 0xA2, 0x5B, 0x10, 0x71, 0x26, 0x80, 0x71, 0x8E, 0xD6, 0xDD, 0xF1,
  // "μ" (U+03BC)
  0x0E, 0x00, 0xD1, 0x0E, 0x00, 0xD1, 0x0E, 0x00, 0xD1, 0x0E, 0x00, 0xD1, 0x0F, 0x01, 0xF1, 0x1D,
  0xB9, 0x87, 0x19, 0x00, 0x00, 0x2D, 0x10, 0x00, 0x0D, 0x30, 0x00,
  // "π" (U+03C0)
  0x5E, 0xEE, 0xEC, 0x45, 0x40, 0x90, 0x06, 0x30, 0xA0, 0x08, 0x30, 0xA0, 0x0A, 0x10, 0xB0, 0x5B,
  0x00, 0xB6,
  // "–" (U+2013)
  0x80, 0x1A,
  // "—" (U+2014)
  0x80, 0x6A,
  // "€" (U+20AC)
  0x00, 0x99, 0xB1, 0x07, 0x60, 0x72, 0x0C, 0x20, 0x00, 0x4E, 0x88, 0x10, 0x4E, 0x86, 0x00, 0x0B,
  0x30, 0x00, 0x06, 0x90, 0x00, 0x00, 0x9A, 0xA1,
  // "₿" (U+20BF)
  0x4F, 0x8A, 0x50, 0x0D, 0x13, 0xD0, 0x0D, 0x14, 0xB0, 0x0D, 0x9C, 0x30, 0x0D, 0x12, 0xD0, 0x0D,
  0x10, 0xE1, 0x0D, 0x10, 0xF0, 0x4F, 0x89, 0x60, 0x00, 0x66, 0x00,
  // "‘" (U+2018)
  0x08, 0x15, 0x70, 0x4C, 0x00,
  // "’" (U+2019)
  0x5B, 0x1B, 0x54,
  // "‚" (U+201A)
  0x5B, 0x1B, 0x54,
  // "‛" (U+201B)
  0x4C, 0x05, 0x60, 0x08, 0x10,
  // "“" (U+201C)
  0x08, 0x18, 0x15, 0x75, 0x70, 0x4C, 0x4C, 0x00,
  // "”" (U+201D)
  0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x54,
  // "„" (U+201E)
  0x5B, 0x5B, 0x1B, 0x1B, 0x54, 0x54,
  // "‟" (U+201F)
  0x4C, 0x4C, 0x05, 0x65, 0x60, 0x08, 0x18, 0x10,
  // "†" (U+2020)
  0x10, 0x20, 0xA3, 0x01, 0x08, 0x28, 0x75, 0x6A, 0x81, 0x23, 0x92, 0x20, 0x40, 0xC3, 0x02, 0x0A,
  0x30, 0x10, 0x84, 0x07, 0x40, 0x74, 0x03, 0x20,
  // "‡" (U+2021)
  0x02, 0xA0, 0x01, 0x08, 0x10, 0x78, 0xBA, 0x10, 0x3B, 0x00, 0x00, 0x60, 0x00, 0x19, 0x00, 0x12,
  0x91, 0x07, 0x8B, 0xA1, 0x01, 0x90, 0x00, 0x15, 0x00,
  // "•" (U+2022)
  0x02, 0x00, 0x4F, 0xD0, 0x7F, 0xF1, 0x3E, 0xB0,
  // "…" (U+2026)
  0x05, 0x01, 0x50, 0x24, 0x1D, 0x03, 0xC0, 0x5A,
  // "‰" (U+2030)
  0x85, 0x19, 0x93, 0x04, 0x56, 0x84, 0x66, 0x39, 0x09, 0x78, 0x48, 0x53, 0xA3, 0x77, 0x89, 0x25,
  0x74, 0x89, 0x27, 0x70, 0x17, 0x72, 0x89, 0x27, 0x72, 0x89, 0x38, 0x59, 0x38, 0x43, 0x89, 0x08,
  0x2B, 0x26, 0x7C, 0x17, 0x63, 0x89, 0x09, 0x0A, 0x37, 0x6A, 0x28, 0x52, 0x89, 0x06, 0x30, 0x39,
  0x91, 0x49, 0x91,
  // "‹" (U+2039)
  0x00, 0x10, 0x55, 0x2C, 0x01, 0xC0, 0x03, 0x60,
  // "›" (U+203A)
  0x19, 0x00, 0x87, 0x09, 0x51, 0x80,
  // "⁄" (U+2044)
  0x30, 0x70, 0x33, 0x09, 0x30, 0x50, 0x43, 0x0A, 0x30, 0x30, 0x63, 0x09, 0x30, 0x20, 0x73, 0x08,
  0x01, 0x30,
  // "™" (U+2122)
  0x57, 0x55, 0x60, 0x36, 0x18, 0x12, 0xB1, 0x76, 0x08, 0x11, 0x59, 0x56, 0x07, 0x33, 0x45, 0x36,
  // "⅒" (U+2152)
  0x10, 0x06, 0x20, 0x70, 0x35, 0x81, 0x49, 0x72, 0x09, 0x78, 0x36, 0x70, 0x54, 0x78, 0xA5, 0x67,
  0x0A, 0x06, 0x60, 0x77, 0x01, 0x78, 0x56, 0x49, 0x77, 0x55, 0x73, 0x09, 0x28, 0x46, 0x79, 0x44,
  0x92, 0x02, 0x07, 0x28, 0x46, 0x77, 0x55, 0x72, 0x87, 0x81, 0x01, 0x78, 0x27, 0x71,
  // "ﬁ" (U+FB01)
  0x03, 0x97, 0xC4, 0x00, 0xB3, 0x01, 0x00, 0x5D, 0x98, 0xA8, 0x00, 0xC2, 0x06, 0x80, 0x0C, 0x20,
  0x68, 0x00, 0xC2, 0x06, 0x80, 0x0C, 0x20, 0x68, 0x05, 0xEA, 0x2B, 0xD3,
  // "ﬂ" (U+FB02)
  0x03, 0xA8, 0xD8, 0x00, 0xB3, 0x06, 0x80, 0x5D, 0x95, 0x68, 0x00, 0xC2, 0x06, 0x80, 0x0C, 0x20,
  0x68, 0x00, 0xC2, 0x06, 0x80, 0x0C, 0x20, 0x68, 0x05, 0xEA, 0x2C, 0xD3,
};

const Font& font_NotoSerif_Regular_10() {
  static SmoothFont font(font_NotoSerif_Regular_10_data);
  return font;
}

}  // namespace roo_display
