#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Italic (Noto Serif Italic)
// Generated on Wed Nov 19 19:11:33 CET 2025
static const uint8_t font_NotoSerif_Italic_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x02, 0xF2,
  0xFE, 0xFF, 0x09, 0x0A, 0x07, 0xFE, 0x03, 0x01, 0x0A, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x07, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x05, 0x03, 0x07, 0x03, 0x00, 0x0B, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0x10, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x07, 0x04, 0x00, 0x22, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x06, 0x07, 0x07, 0x00, 0x36, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x05, 0x07, 0x06, 0x00, 0x4F, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x05, 0x01, 0x07, 0x02, 0x00, 0x64, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x03, 0x06, 0x03, 0x00, 0x66, // "(" (U+0028)
  0x00, 0x29, 0xBF, 0x00, 0x02, 0x06, 0x03, 0x00, 0x74, // ")" (U+0029)
  0x00, 0x2A, 0x41, 0x04, 0x04, 0x06, 0x04, 0x00, 0x82, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x03, 0x05, 0x04, 0x00, 0x88, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0xFF, 0x01, 0x01, 0x02, 0x00, 0x90, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x02, 0x00, 0x95, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x02, 0x02, 0x00, 0x97, // "." (U+002E)
  0x00, 0x2F, 0xBF, 0x00, 0x02, 0x07, 0x02, 0x00, 0x99, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xA9, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xBB, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xC9, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xD7, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xE9, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x07, 0x04, 0x00, 0xFB, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x0D, // "6" (U+0036)
  0x00, 0x37, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x1F, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x31, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x43, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x05, 0x02, 0x01, 0x55, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0x00, 0x01, 0x05, 0x02, 0x01, 0x5A, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x60, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x03, 0x05, 0x04, 0x01, 0x68, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x6E, // ">" (U+003E)
  0x00, 0x3F, 0x41, 0x01, 0x04, 0x07, 0x04, 0x01, 0x76, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x06, 0x07, 0x07, 0x01, 0x84, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x05, 0x07, 0x06, 0x01, 0xA0, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xB7, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xC9, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0xDB, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xF0, // "E" (U+0045)
  0x00, 0x46, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x02, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x14, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x06, 0x07, 0x06, 0x02, 0x29, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x03, 0x07, 0x03, 0x02, 0x42, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFF, 0x03, 0x07, 0x03, 0x02, 0x50, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0x66, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x7B, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x07, 0x07, 0x08, 0x02, 0x8D, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x06, 0x07, 0x06, 0x02, 0xA9, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x05, 0x07, 0x06, 0x02, 0xC2, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0xD7, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x02, 0xE9, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0x04, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x07, 0x04, 0x03, 0x16, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x05, 0x07, 0x05, 0x03, 0x28, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x06, 0x07, 0x06, 0x03, 0x3C, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x05, 0x07, 0x05, 0x03, 0x55, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x08, 0x07, 0x08, 0x03, 0x6A, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x05, 0x07, 0x05, 0x03, 0x8A, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x05, 0x07, 0x05, 0x03, 0xA2, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x04, 0x07, 0x05, 0x03, 0xB7, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0x00, 0x03, 0x07, 0x03, 0x03, 0xC9, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x00, 0x01, 0x07, 0x02, 0x03, 0xD9, // "\" (U+005C)
  0x00, 0x5D, 0xBF, 0x00, 0x02, 0x07, 0x03, 0x03, 0xE1, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x03, 0x06, 0x04, 0x03, 0xF1, // "^" (U+005E)
  0x00, 0x5F, 0xBF, 0x00, 0x02, 0x00, 0x04, 0x03, 0xF9, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x07, 0x02, 0x08, 0x02, 0x03, 0xFB, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x05, 0x05, 0x03, 0xFD, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x0A, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x1C, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x26, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x38, // "e" (U+0065)
  0x00, 0x66, 0xFF, 0xFF, 0x03, 0x07, 0x03, 0x04, 0x42, // "f" (U+0066)
  0x00, 0x67, 0xBF, 0xFF, 0x04, 0x06, 0x04, 0x04, 0x58, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x70, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x07, 0x02, 0x04, 0x82, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x04, 0x8D, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x04, 0x9F, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x07, 0x02, 0x04, 0xB1, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x06, 0x05, 0x07, 0x04, 0xBC, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xCE, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x05, 0x05, 0x04, 0xDB, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x04, 0xE8, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x04, 0x05, 0x04, 0x04, 0xFA, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0x0C, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0x16, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x02, 0x06, 0x03, 0x05, 0x20, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x05, 0x05, 0x05, 0x29, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x00, 0x03, 0x05, 0x04, 0x05, 0x36, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x06, 0x05, 0x07, 0x05, 0x42, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x05, 0x04, 0x05, 0x54, // "x" (U+0078)
  0x00, 0x79, 0xBE, 0xFF, 0x03, 0x05, 0x04, 0x05, 0x61, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0x76, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0x00, 0x03, 0x07, 0x03, 0x05, 0x80, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x90, // "|" (U+007C)
  0x00, 0x7D, 0xBF, 0x00, 0x02, 0x07, 0x03, 0x05, 0x92, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x03, 0x04, 0x04, 0x05, 0xA2, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFF, 0x01, 0x05, 0x03, 0x05, 0xA6, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0xAD, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0xBF, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x03, 0x06, 0x04, 0x05, 0xD1, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0xDB, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFF, 0x02, 0x07, 0x04, 0x05, 0xED, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x00, 0x04, 0x07, 0x04, 0x05, 0xF2, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x05, 0x06, 0x06, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0x08, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x03, 0x06, 0x03, 0x06, 0x21, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x06, 0x27, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x03, 0x04, 0x04, 0x06, 0x2F, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x07, 0x07, 0x06, 0x35, // "®" (U+00AE)
  0x00, 0xAF, 0x40, 0x08, 0x04, 0x08, 0x04, 0x06, 0x4E, // "¯" (U+00AF)
  0x00, 0xB0, 0x41, 0x05, 0x03, 0x07, 0x03, 0x06, 0x51, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x03, 0x05, 0x04, 0x06, 0x56, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x03, 0x07, 0x03, 0x06, 0x60, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x03, 0x07, 0x03, 0x06, 0x68, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x07, 0x02, 0x08, 0x02, 0x06, 0x70, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x06, 0x72, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0x00, 0x04, 0x07, 0x05, 0x06, 0x83, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x03, 0x01, 0x04, 0x02, 0x06, 0x97, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFF, 0x02, 0x01, 0x03, 0x06, 0x99, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x04, 0x02, 0x07, 0x03, 0x06, 0x9E, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x03, 0x06, 0x03, 0x06, 0xA4, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x06, 0xAA, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x07, 0x07, 0x07, 0x06, 0xB2, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x07, 0x07, 0x07, 0x06, 0xCE, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x07, 0x07, 0x07, 0x06, 0xEA, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFF, 0x02, 0x05, 0x04, 0x07, 0x06, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x07, 0x11, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x07, 0x2C, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x07, 0x47, // "Â" (U+00C2)
  0x00, 0xC3, 0xBF, 0x01, 0x05, 0x08, 0x06, 0x07, 0x64, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x05, 0x08, 0x06, 0x07, 0x80, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x07, 0x9A, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x07, 0x07, 0x08, 0x07, 0xB6, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x07, 0xD4, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xEB, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x04, 0x09, 0x05, 0x08, 0x02, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x04, 0x09, 0x05, 0x08, 0x19, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x08, 0x30, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x03, 0x09, 0x03, 0x08, 0x44, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x09, 0x03, 0x08, 0x56, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x03, 0x09, 0x03, 0x08, 0x68, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x03, 0x08, 0x03, 0x08, 0x7A, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x05, 0x07, 0x06, 0x08, 0x8A, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x06, 0x08, 0x06, 0x08, 0x9F, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0xBB, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0xD6, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x05, 0x09, 0x06, 0x08, 0xF1, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x05, 0x08, 0x06, 0x09, 0x0C, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x05, 0x08, 0x06, 0x09, 0x24, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x09, 0x3C, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x01, 0x05, 0x07, 0x06, 0x09, 0x44, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x06, 0x09, 0x06, 0x09, 0x59, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x06, 0x09, 0x06, 0x09, 0x79, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x06, 0x09, 0x06, 0x09, 0x99, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x06, 0x08, 0x06, 0x09, 0xB9, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x05, 0x09, 0x05, 0x09, 0xD5, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x07, 0x05, 0x09, 0xEF, // "Þ" (U+00DE)
  0x00, 0xDF, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x0A, 0x01, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x1C, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x2E, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x40, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x54, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0A, 0x66, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x77, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x06, 0x05, 0x07, 0x0A, 0x8B, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0A, 0x9D, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xAB, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xBB, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0A, 0xCB, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0xDF, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x08, 0x02, 0x0A, 0xED, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x08, 0x02, 0x0A, 0xF9, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x02, 0x08, 0x02, 0x0B, 0x05, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0B, 0x11, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x1C, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x2E, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x40, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x52, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0x64, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x78, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x8A, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x0B, 0x9B, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x06, 0x05, 0x0B, 0xA3, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xB3, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xC6, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0B, 0xD9, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xED, // "ü" (U+00FC)
  0x00, 0xFD, 0xFE, 0xFF, 0x03, 0x08, 0x04, 0x0B, 0xFF, // "ý" (U+00FD)
  0x00, 0xFE, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x0C, 0x19, // "þ" (U+00FE)
  0x00, 0xFF, 0xFE, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0x34, // "ÿ" (U+00FF)
  0x01, 0x00, 0xBF, 0x01, 0x05, 0x07, 0x06, 0x0C, 0x4D, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x06, 0x05, 0x0C, 0x66, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x05, 0x08, 0x06, 0x0C, 0x75, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x90, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFF, 0x05, 0x07, 0x06, 0x0C, 0xA2, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x0C, 0xBF, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x09, 0x05, 0x0C, 0xD1, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x08, 0x04, 0x0C, 0xEA, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x05, 0x09, 0x05, 0x0C, 0xFC, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0D, 0x16, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x2A, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0D, 0x3E, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x09, 0x05, 0x0D, 0x4C, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0D, 0x66, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0x7A, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x05, 0x0D, 0x95, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0D, 0xAA, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xBF, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0xD1, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x06, 0x04, 0x0D, 0xE3, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xF2, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0E, 0x06, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x18, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0E, 0x2C, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0E, 0x3A, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0E, 0x51, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0E, 0x5F, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0E, 0x7A, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0E, 0x8E, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xBF, 0xFF, 0x04, 0x08, 0x04, 0x0E, 0xA9, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xC7, // "Ğ" (U+011E)
  0x01, 0x1F, 0xBF, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0xDF, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x05, 0x08, 0x06, 0x0E, 0xFA, // "Ġ" (U+0120)
  0x01, 0x21, 0xBF, 0xFF, 0x04, 0x07, 0x04, 0x0F, 0x12, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x05, 0x07, 0x06, 0x0F, 0x2D, // "Ģ" (U+0122)
  0x01, 0x23, 0xBF, 0xFF, 0x04, 0x07, 0x04, 0x0F, 0x47, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x06, 0x09, 0x06, 0x0F, 0x62, // "Ĥ" (U+0124)
  0x01, 0x25, 0x40, 0x01, 0x04, 0x0A, 0x05, 0x0F, 0x82, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x06, 0x07, 0x06, 0x0F, 0x9B, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xB4, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0F, 0xC6, // "Ĩ" (U+0128)
  0x01, 0x29, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0F, 0xD6, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0F, 0xE1, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x03, 0x06, 0x02, 0x0F, 0xEF, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0F, 0xFB, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x02, 0x07, 0x02, 0x10, 0x0B, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFF, 0x03, 0x07, 0x03, 0x10, 0x16, // "Į" (U+012E)
  0x01, 0x2F, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x10, 0x28, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x03, 0x08, 0x03, 0x10, 0x3A, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x05, 0x02, 0x10, 0x4A, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFF, 0x06, 0x07, 0x06, 0x10, 0x52, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x10, 0x72, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFF, 0x03, 0x09, 0x03, 0x10, 0x89, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFF, 0x02, 0x08, 0x02, 0x10, 0xA4, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x05, 0x07, 0x06, 0x10, 0xB8, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x10, 0xD3, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x05, 0x05, 0x10, 0xEA, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0xF7, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x03, 0x0A, 0x02, 0x11, 0x0D, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x11, 0x21, // "Ļ" (U+013B)
  0x01, 0x3C, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x11, 0x37, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x49, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x07, 0x02, 0x11, 0x5B, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x69, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x02, 0x07, 0x03, 0x11, 0x7B, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x04, 0x07, 0x05, 0x11, 0x86, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x07, 0x03, 0x11, 0x98, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x06, 0x09, 0x06, 0x11, 0xA3, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xC3, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x06, 0x07, 0x06, 0x11, 0xD6, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x11, 0xF5, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x06, 0x09, 0x06, 0x12, 0x07, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x08, 0x05, 0x12, 0x27, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x05, 0x07, 0x06, 0x12, 0x3B, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x06, 0x07, 0x06, 0x12, 0x50, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x12, 0x70, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x05, 0x07, 0x06, 0x12, 0x82, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x06, 0x05, 0x12, 0x97, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0xA6, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xBE, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x08, 0x06, 0x12, 0xD0, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x05, 0x12, 0xE8, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x07, 0x07, 0x08, 0x12, 0xFA, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x06, 0x05, 0x07, 0x13, 0x16, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x04, 0x09, 0x05, 0x13, 0x28, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0x3F, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x13, 0x4F, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFF, 0x03, 0x05, 0x04, 0x13, 0x66, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x05, 0x09, 0x05, 0x13, 0x77, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x08, 0x04, 0x13, 0x92, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x04, 0x09, 0x04, 0x13, 0xA5, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0xBC, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x04, 0x09, 0x04, 0x13, 0xCC, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0xE3, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x13, 0xF3, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x14, 0x0A, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x09, 0x04, 0x14, 0x18, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x04, 0x08, 0x04, 0x14, 0x2F, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x05, 0x07, 0x05, 0x14, 0x43, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x14, 0x5C, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x05, 0x09, 0x05, 0x14, 0x68, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x03, 0x07, 0x03, 0x14, 0x81, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x05, 0x07, 0x05, 0x14, 0x8F, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x02, 0x06, 0x03, 0x14, 0xA4, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x06, 0x08, 0x06, 0x14, 0xAD, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x04, 0x07, 0x05, 0x14, 0xC9, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x06, 0x07, 0x06, 0x14, 0xDB, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x06, 0x05, 0x14, 0xF4, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x06, 0x08, 0x06, 0x15, 0x03, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x15, 0x1F, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x06, 0x09, 0x06, 0x15, 0x31, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x08, 0x05, 0x15, 0x51, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x06, 0x08, 0x06, 0x15, 0x65, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x05, 0x15, 0x81, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x06, 0x07, 0x06, 0x15, 0x93, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x04, 0x05, 0x05, 0x15, 0xB3, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x08, 0x09, 0x08, 0x15, 0xC5, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x08, 0x07, 0x15, 0xED, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x05, 0x09, 0x05, 0x16, 0x07, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFE, 0xFF, 0x03, 0x08, 0x04, 0x16, 0x21, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x05, 0x08, 0x05, 0x16, 0x3C, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x04, 0x09, 0x05, 0x16, 0x54, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x16, 0x6B, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x04, 0x08, 0x05, 0x16, 0x7B, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x03, 0x07, 0x04, 0x16, 0x8F, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x16, 0x9D, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x08, 0x04, 0x16, 0xB4, // "ž" (U+017E)
  0x01, 0x7F, 0xFF, 0xFF, 0x03, 0x07, 0x02, 0x16, 0xC8, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x05, 0x07, 0x06, 0x16, 0xDD, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFF, 0x04, 0x05, 0x05, 0x16, 0xF2, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x05, 0x05, 0x17, 0x03, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x03, 0x03, 0x04, 0x17, 0x12, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x03, 0x08, 0x17, 0x14, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x07, 0x04, 0x17, 0x16, // "€" (U+20AC)
  0x20, 0xBF, 0xBF, 0x00, 0x04, 0x08, 0x04, 0x17, 0x28, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x05, 0x02, 0x07, 0x02, 0x17, 0x43, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x05, 0x01, 0x07, 0x02, 0x17, 0x48, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0xFF, 0x01, 0x01, 0x02, 0x17, 0x4B, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x05, 0x02, 0x07, 0x02, 0x17, 0x50, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x05, 0x03, 0x07, 0x04, 0x17, 0x53, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x05, 0x03, 0x07, 0x04, 0x17, 0x59, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0xFF, 0x02, 0x01, 0x04, 0x17, 0x5F, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x05, 0x04, 0x07, 0x04, 0x17, 0x65, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x00, 0x03, 0x07, 0x04, 0x17, 0x6B, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x00, 0x03, 0x07, 0x04, 0x17, 0x7A, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x05, 0x03, 0x17, 0x8A, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x05, 0x02, 0x07, 0x17, 0x8F, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x09, 0x07, 0x0A, 0x17, 0x95, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x02, 0x05, 0x03, 0x17, 0xB8, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x02, 0x05, 0x03, 0x17, 0xBE, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x01, 0x17, 0xC4, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x06, 0x06, 0x07, 0x17, 0xD3, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x09, 0x07, 0x0A, 0x17, 0xDE, // "⅒" (U+2152)
  0xFB, 0x01, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x17, 0xFD, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x18, 0x18, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x63, 0x00, 0x59, 0x01, // cY (U+0063 U+0059)
  0x00, 0x63, 0x00, 0xDD, 0x01, // cÝ (U+0063 U+00DD)
  0x00, 0x63, 0x01, 0x76, 0x01, // cŶ (U+0063 U+0176)
  0x00, 0x63, 0x01, 0x78, 0x01, // cŸ (U+0063 U+0178)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE7, 0x00, 0x59, 0x01, // çY (U+00E7 U+0059)
  0x00, 0xE7, 0x00, 0xDD, 0x01, // çÝ (U+00E7 U+00DD)
  0x00, 0xE7, 0x01, 0x76, 0x01, // çŶ (U+00E7 U+0176)
  0x00, 0xE7, 0x01, 0x78, 0x01, // çŸ (U+00E7 U+0178)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x07, 0x00, 0x59, 0x01, // ćY (U+0107 U+0059)
  0x01, 0x07, 0x00, 0xDD, 0x01, // ćÝ (U+0107 U+00DD)
  0x01, 0x07, 0x01, 0x76, 0x01, // ćŶ (U+0107 U+0176)
  0x01, 0x07, 0x01, 0x78, 0x01, // ćŸ (U+0107 U+0178)
  0x01, 0x09, 0x00, 0x59, 0x01, // ĉY (U+0109 U+0059)
  0x01, 0x09, 0x00, 0xDD, 0x01, // ĉÝ (U+0109 U+00DD)
  0x01, 0x09, 0x01, 0x76, 0x01, // ĉŶ (U+0109 U+0176)
  0x01, 0x09, 0x01, 0x78, 0x01, // ĉŸ (U+0109 U+0178)
  0x01, 0x0B, 0x00, 0x59, 0x01, // ċY (U+010B U+0059)
  0x01, 0x0B, 0x00, 0xDD, 0x01, // ċÝ (U+010B U+00DD)
  0x01, 0x0B, 0x01, 0x76, 0x01, // ċŶ (U+010B U+0176)
  0x01, 0x0B, 0x01, 0x78, 0x01, // ċŸ (U+010B U+0178)
  0x01, 0x0D, 0x00, 0x59, 0x01, // čY (U+010D U+0059)
  0x01, 0x0D, 0x00, 0xDD, 0x01, // čÝ (U+010D U+00DD)
  0x01, 0x0D, 0x01, 0x76, 0x01, // čŶ (U+010D U+0176)
  0x01, 0x0D, 0x01, 0x78, 0x01, // čŸ (U+010D U+0178)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x07, 0x60, 0x93, 0x0A, 0x00, 0x90, 0x07, 0x00, 0x10, 0x65, 0x00,
  // """ (U+0022)
  0xB5, 0x68, 0x61, 0x11, 0x00,
  // "#" (U+0023)
  0x00, 0x76, 0x10, 0x33, 0x70, 0x2B, 0x8B, 0x30, 0x72, 0x50, 0x7B, 0xB8, 0x03, 0x37, 0x00, 0x60,
  0x70, 0x00,
  // "$" (U+0024)
  0x00, 0x64, 0x00, 0xAA, 0x92, 0x0C, 0x60, 0x00, 0x5D, 0x20, 0x30, 0x7B, 0x0B, 0x58, 0x90, 0x1A,
  0x50, 0x00, 0x30, 0x00,
  // "%" (U+0025)
  0x07, 0x90, 0x07, 0x03, 0x66, 0x37, 0x10, 0x63, 0x74, 0x60, 0x06, 0x39, 0x82, 0x64, 0x16, 0x65,
  0x90, 0xA0, 0x08, 0x0A, 0x09, 0x05, 0x30, 0x87, 0x20,
  // "&" (U+0026)
  0x01, 0x99, 0x40, 0x05, 0x63, 0x80, 0x05, 0xDE, 0x40, 0x05, 0xE3, 0x57, 0x66, 0x58, 0x80, 0xA1,
  0x0B, 0x60, 0x38, 0x67, 0xC3,
  // "'" (U+0027)
  0xB8, 0x10,
  // "(" (U+0028)
  0x01, 0x81, 0x0A, 0x10, 0x48, 0x00, 0x83, 0x00, 0x91, 0x00, 0x73, 0x00, 0x17, 0x00,
  // ")" (U+0029)
  0x00, 0x70, 0x00, 0x55, 0x00, 0x37, 0x00, 0x56, 0x00, 0xA2, 0x02, 0x90, 0x18, 0x00,
  // "*" (U+002A)
  0x77, 0x20, 0x8C, 0x91, 0x07, 0x60,
  // "+" (U+002B)
  0x00, 0x60, 0x00, 0x70, 0x48, 0xB8, 0x00, 0x70,
  // "," (U+002C)
  0x0B, 0x10, 0x71, 0x12, 0x00,
  // "-" (U+002D)
  0x8A, 0x20,
  // "." (U+002E)
  0x10, 0xA1,
  // "/" (U+002F)
  0x00, 0x07, 0x00, 0x16, 0x00, 0x60, 0x00, 0x70, 0x04, 0x30, 0x07, 0x00, 0x25, 0x00, 0x70, 0x00,
  // "0" (U+0030)
  0x05, 0x89, 0x00, 0x90, 0x92, 0x55, 0x08, 0x39, 0x30, 0xA1, 0xA1, 0x0B, 0x09, 0x21, 0x80, 0x29,
  0x80, 0x00,
  // "1" (U+0031)
  0x01, 0xA4, 0x08, 0xA2, 0x00, 0xC0, 0x00, 0xC0, 0x02, 0x90, 0x05, 0x70, 0x4B, 0xA1,
  // "2" (U+0032)
  0x09, 0x79, 0x17, 0x0C, 0x00, 0x0A, 0x00, 0x72, 0x05, 0x30, 0x45, 0x03, 0xDB, 0xC6,
  // "3" (U+0033)
  0x08, 0x7A, 0x00, 0x80, 0xB1, 0x00, 0x1B, 0x00, 0x4C, 0x20, 0x00, 0x3A, 0x04, 0x03, 0x90, 0xA7,
  0x91, 0x00,
  // "4" (U+0034)
  0x00, 0x2D, 0x00, 0x08, 0xB0, 0x07, 0x48, 0x05, 0x36, 0x50, 0xA8, 0xC9, 0x10, 0x0B, 0x00, 0x06,
  0xE4, 0x00,
  // "5" (U+0035)
  0x07, 0xBC, 0x20, 0x60, 0x10, 0x06, 0x00, 0x02, 0x98, 0x20, 0x00, 0x2A, 0x02, 0x03, 0x90, 0xA7,
  0x91, 0x00,
  // "6" (U+0036)
  0x02, 0x9A, 0x40, 0xB1, 0x21, 0x2A, 0x00, 0x06, 0xA7, 0x40, 0x74, 0x0C, 0x06, 0x30, 0xB0, 0x18,
  0x93, 0x00,
  // "7" (U+0037)
  0x0D, 0xBD, 0x72, 0x10, 0xA1, 0x00, 0x28, 0x00, 0x09, 0x10, 0x01, 0x90, 0x00, 0x82, 0x00, 0x1A,
  0x00, 0x00,
  // "8" (U+0038)
  0x07, 0x69, 0x00, 0xA0, 0x83, 0x0E, 0x9C, 0x00, 0x9D, 0x30, 0x92, 0x2B, 0x0B, 0x00, 0xB0, 0x67,
  0x73, 0x00,
  // "9" (U+0039)
  0x06, 0x89, 0x02, 0xA0, 0x91, 0x56, 0x09, 0x15, 0x70, 0xC0, 0x08, 0x7A, 0x00, 0x05, 0x50, 0x76,
  0x60, 0x00,
  // ":" (U+003A)
  0x0C, 0x01, 0x00, 0x10, 0x92,
  // ";" (U+003B)
  0x0C, 0x02, 0x00, 0x10, 0x95, 0x71,
  // "<" (U+003C)
  0x00, 0x17, 0x07, 0x60, 0x38, 0x20, 0x00, 0x57,
  // "=" (U+003D)
  0x38, 0x87, 0x00, 0x00, 0x38, 0x87,
  // ">" (U+003E)
  0x44, 0x00, 0x03, 0x83, 0x00, 0x67, 0x37, 0x10,
  // "?" (U+003F)
  0x77, 0xA0, 0x70, 0xA2, 0x00, 0xB0, 0x19, 0x20, 0x51, 0x00, 0x20, 0x00, 0xB0, 0x00,
  // "@" (U+0040)
  0x00, 0x77, 0x78, 0x10, 0x73, 0x00, 0x07, 0x18, 0x28, 0x84, 0x76, 0x4A, 0x08, 0x17, 0x72, 0xB0,
  0xB0, 0x75, 0x45, 0x74, 0x81, 0x0A, 0x00, 0x03, 0x00, 0x18, 0x77, 0x10,
  // "A" (U+0041)
  0x40, 0xD5, 0x81, 0x6C, 0x14, 0x81, 0x88, 0x33, 0x82, 0x52, 0x75, 0x38, 0x2A, 0x79, 0x72, 0x89,
  0x35, 0x30, 0x39, 0x02, 0xD3, 0x08, 0xD1,
  // "B" (U+0042)
  0x0A, 0xA7, 0x70, 0x75, 0x0D, 0x09, 0x31, 0xB0, 0xC7, 0xC2, 0x0C, 0x04, 0x82, 0xA0, 0x58, 0xAB,
  0x69, 0x10,
  // "C" (U+0043)
  0x00, 0x87, 0xB0, 0xA2, 0x07, 0x3A, 0x00, 0x07, 0x60, 0x00, 0x84, 0x00, 0x06, 0x60, 0x01, 0x09,
  0x88, 0x10,
  // "D" (U+0044)
  0x0A, 0xA6, 0x80, 0x07, 0x50, 0x75, 0x09, 0x20, 0x57, 0x0C, 0x00, 0x56, 0x0C, 0x00, 0x93, 0x2A,
  0x01, 0xB0, 0xAB, 0x69, 0x10,
  // "E" (U+0045)
  0x0A, 0xA6, 0xC0, 0x75, 0x04, 0x09, 0x30, 0x00, 0xC7, 0x60, 0x0C, 0x00, 0x02, 0xA0, 0x03, 0x9B,
  0x6A, 0x30,
  // "F" (U+0046)
  0x0A, 0xA6, 0xC0, 0x75, 0x04, 0x09, 0x20, 0x00, 0xC7, 0x60, 0x0C, 0x00, 0x02, 0xA0, 0x00, 0xAC,
  0x20, 0x00,
  // "G" (U+0047)
  0x01, 0x87, 0xB3, 0x0A, 0x20, 0x65, 0x3A, 0x00, 0x00, 0x76, 0x00, 0x00, 0x84, 0x04, 0xA3, 0x66,
  0x01, 0xB0, 0x09, 0x78, 0x60,
  // "H" (U+0048)
  0x0A, 0xC2, 0x4E, 0x50, 0x75, 0x00, 0xB0, 0x09, 0x30, 0x39, 0x00, 0xC7, 0x7A, 0x60, 0x0C, 0x00,
  0x83, 0x02, 0xA0, 0x0B, 0x00, 0xAB, 0x15, 0xE4, 0x00,
  // "I" (U+0049)
  0x0A, 0xB2, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0xAC, 0x10,
  // "J" (U+004A)
  0x38, 0x1B, 0xB2, 0x30, 0x70, 0x44, 0x0A, 0x01, 0x40, 0xC5, 0x0B, 0x40, 0x30, 0x94, 0x00, 0x64,
  0x09, 0x02, 0x28, 0x11, 0x78, 0x30,
  // "K" (U+004B)
  0x0A, 0xB2, 0x9A, 0x07, 0x51, 0x80, 0x09, 0x38, 0x00, 0x0C, 0xA7, 0x00, 0x0C, 0x1C, 0x00, 0x2A,
  0x0B, 0x20, 0xAC, 0x14, 0xA0,
  // "L" (U+004C)
  0x0A, 0xB2, 0x00, 0x75, 0x00, 0x09, 0x20, 0x00, 0xC0, 0x00, 0x0C, 0x00, 0x02, 0xA0, 0x16, 0xAB,
  0x6A, 0x30,
  // "M" (U+004D)
  0x0A, 0xE0, 0x01, 0xF7, 0x07, 0xC0, 0x07, 0xC0, 0x07, 0x92, 0x17, 0xB0, 0x07, 0x74, 0x63, 0x80,
  0x07, 0x56, 0x75, 0x60, 0x25, 0x3D, 0x18, 0x30, 0x98, 0x19, 0x2D, 0x60,
  // "N" (U+004E)
  0x0A, 0xA0, 0x2C, 0x30, 0x7C, 0x00, 0x70, 0x07, 0x75, 0x06, 0x00, 0x72, 0xB3, 0x30, 0x07, 0x0B,
  0x71, 0x02, 0x50, 0x6D, 0x00, 0xA8, 0x01, 0xA0, 0x00,
  // "O" (U+004F)
  0x01, 0x87, 0x91, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76, 0x00, 0x59, 0x84, 0x00, 0x85, 0x66,
  0x01, 0xB0, 0x09, 0x79, 0x10,
  // "P" (U+0050)
  0x0A, 0xA8, 0x40, 0x75, 0x0C, 0x09, 0x30, 0xD0, 0xC1, 0x48, 0x0E, 0x67, 0x02, 0xA0, 0x00, 0xAB,
  0x20, 0x00,
  // "Q" (U+0051)
  0x01, 0x87, 0x91, 0x0B, 0x20, 0x47, 0x3A, 0x00, 0x3A, 0x76, 0x00, 0x59, 0x84, 0x00, 0x95, 0x57,
  0x01, 0xB0, 0x09, 0x99, 0x10, 0x00, 0xC0, 0x00, 0x00, 0x69, 0x20,
  // "R" (U+0052)
  0x0A, 0xA7, 0x70, 0x75, 0x0C, 0x09, 0x22, 0xA0, 0xC7, 0x90, 0x0B, 0x1B, 0x02, 0x90, 0xC0, 0x9C,
  0x27, 0x70,
  // "S" (U+0053)
  0x06, 0x6A, 0x30, 0xB0, 0x32, 0x0D, 0x20, 0x00, 0x4E, 0x30, 0x00, 0x3C, 0x09, 0x00, 0xB0, 0x77,
  0x74, 0x00,
  // "T" (U+0054)
  0x89, 0x22, 0xBA, 0xBA, 0x53, 0x17, 0x51, 0x22, 0x0A, 0x02, 0x40, 0xC5, 0x0C, 0x40, 0x20, 0x93,
  0x82, 0x1A, 0xB1, 0x20,
  // "U" (U+0055)
  0x1B, 0xA1, 0x5B, 0x20, 0x92, 0x02, 0x50, 0x0C, 0x00, 0x42, 0x00, 0xC0, 0x07, 0x00, 0x2A, 0x00,
  0x70, 0x03, 0x90, 0x07, 0x00, 0x09, 0x88, 0x10, 0x00,
  // "V" (U+0056)
  0x2E, 0x70, 0x8A, 0x0A, 0x10, 0x71, 0x09, 0x30, 0x70, 0x07, 0x56, 0x10, 0x05, 0x67, 0x00, 0x03,
  0xB2, 0x00, 0x02, 0xB0, 0x00,
  // "W" (U+0057)
  0x1D, 0x70, 0x75, 0x0A, 0x80, 0xA2, 0x0C, 0x60, 0x70, 0x09, 0x33, 0x97, 0x07, 0x00, 0x84, 0x74,
  0x76, 0x10, 0x07, 0x66, 0x38, 0x70, 0x00, 0x6B, 0x12, 0xC4, 0x00, 0x04, 0x90, 0x1D, 0x00, 0x00,
  // "X" (U+0058)
  0x28, 0x3B, 0xA0, 0xC5, 0x28, 0x23, 0xA2, 0x64, 0x0D, 0x07, 0x50, 0xA0, 0x54, 0x81, 0x47, 0x93,
  0x82, 0x17, 0x0D, 0x28, 0x42, 0xC4, 0x2D, 0x71,
  // "Y" (U+0059)
  0x2E, 0x51, 0xC5, 0x09, 0x30, 0x70, 0x05, 0x76, 0x00, 0x01, 0xC5, 0x00, 0x00, 0xC0, 0x00, 0x01,
  0xA0, 0x00, 0x19, 0xC1, 0x00,
  // "Z" (U+005A)
  0x0B, 0x78, 0xD1, 0x20, 0xB4, 0x00, 0x69, 0x00, 0x1C, 0x00, 0x0A, 0x40, 0x05, 0x90, 0x03, 0xE8,
  0x7A, 0x30,
  // "[" (U+005B)
  0x08, 0x81, 0x0B, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0x57, 0x00, 0x83, 0x00, 0xB0, 0x00, 0x95, 0x00,
  // "\" (U+005C)
  0x16, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
  // "]" (U+005D)
  0x00, 0x6C, 0x00, 0x29, 0x00, 0x56, 0x00, 0x83, 0x00, 0xB0, 0x00, 0xC0, 0x02, 0x90, 0x18, 0x50,
  // "^" (U+005E)
  0x02, 0x80, 0x07, 0x70, 0x07, 0x16, 0x52, 0x08,
  // "_" (U+005F)
  0x58, 0x88,
  // "`" (U+0060)
  0x50, 0x35,
  // "a" (U+0061)
  0x06, 0x7A, 0x23, 0x90, 0xB0, 0x84, 0x0B, 0x09, 0x24, 0xA0, 0x5A, 0x5C, 0x30,
  // "b" (U+0062)
  0x1D, 0x30, 0x00, 0xB0, 0x00, 0x0C, 0x7B, 0x02, 0xC0, 0xA1, 0x57, 0x0B, 0x07, 0x41, 0xA0, 0x97,
  0x81, 0x00,
  // "c" (U+0063)
  0x07, 0x7A, 0x38, 0x04, 0x84, 0x00, 0x93, 0x00, 0x3A, 0x81,
  // "d" (U+0064)
  0x00, 0x08, 0x80, 0x00, 0x55, 0x06, 0x7C, 0x33, 0x90, 0xB0, 0x84, 0x0B, 0x09, 0x24, 0xA0, 0x5A,
  0x5C, 0x30,
  // "e" (U+0065)
  0x06, 0x89, 0x38, 0x39, 0x89, 0x60, 0x93, 0x00, 0x3A, 0x81,
  // "f" (U+0066)
  0x28, 0x13, 0x9A, 0x28, 0x59, 0x11, 0x03, 0xD7, 0x30, 0xA3, 0x03, 0x08, 0x30, 0x60, 0x53, 0x09,
  0x02, 0x30, 0xB3, 0x07, 0x06, 0x30,
  // "g" (U+0067)
  0x00, 0x00, 0x48, 0x00, 0x77, 0xB2, 0x01, 0x90, 0xA0, 0x00, 0xA7, 0x20, 0x04, 0x83, 0x00, 0x06,
  0x9C, 0x70, 0x37, 0x02, 0x80, 0x19, 0x78, 0x10,
  // "h" (U+0068)
  0x0B, 0x40, 0x00, 0xA1, 0x00, 0x0B, 0x6C, 0x00, 0xD1, 0xA1, 0x38, 0x0B, 0x05, 0x50, 0xB0, 0x82,
  0x0B, 0x40,
  // "i" (U+0069)
  0x08, 0x20, 0x00, 0x3D, 0x00, 0xB0, 0x38, 0x05, 0x50, 0x49, 0x10,
  // "j" (U+006A)
  0x00, 0x82, 0x00, 0x00, 0x03, 0xD0, 0x00, 0xB0, 0x03, 0x80, 0x06, 0x50, 0x09, 0x20, 0x0B, 0x00,
  0x76, 0x00,
  // "k" (U+006B)
  0x0B, 0x40, 0x00, 0xA1, 0x00, 0x0B, 0x0C, 0x50, 0xA5, 0x30, 0x3B, 0xC0, 0x05, 0x58, 0x40, 0x82,
  0x1B, 0x10,
  // "l" (U+006C)
  0x0B, 0x40, 0x91, 0x0B, 0x00, 0xB0, 0x38, 0x05, 0x60, 0x49, 0x10,
  // "m" (U+006D)
  0x3D, 0x6C, 0x5A, 0x50, 0xD1, 0xA5, 0x47, 0x38, 0x0B, 0x07, 0x45, 0x50, 0xB0, 0x92, 0x82, 0x19,
  0x07, 0x80,
  // "n" (U+006E)
  0x3D, 0x6C, 0x00, 0xD1, 0xA1, 0x38, 0x0B, 0x05, 0x50, 0xB0, 0x82, 0x0B, 0x40,
  // "o" (U+006F)
  0x07, 0x79, 0x04, 0x80, 0x92, 0x83, 0x0A, 0x29, 0x30, 0xB0, 0x39, 0x83, 0x00,
  // "p" (U+0070)
  0x3D, 0x6C, 0x10, 0xD0, 0x83, 0x39, 0x0A, 0x26, 0x50, 0xB0, 0x98, 0x82, 0x0B, 0x00, 0x00, 0xE3,
  0x00, 0x00,
  // "q" (U+0071)
  0x06, 0x6B, 0x33, 0x90, 0xB0, 0x84, 0x0B, 0x09, 0x24, 0x90, 0x5A, 0x76, 0x00, 0x07, 0x30, 0x00,
  0xA6, 0x00,
  // "r" (U+0072)
  0x4C, 0x79, 0x0D, 0x11, 0x39, 0x00, 0x55, 0x00, 0x82, 0x00,
  // "s" (U+0073)
  0x19, 0x84, 0x39, 0x01, 0x09, 0xA0, 0x40, 0xA2, 0x76, 0x80,
  // "t" (U+0074)
  0x08, 0x13, 0xD7, 0x0B, 0x03, 0x80, 0x55, 0x03, 0xA3,
  // "u" (U+0075)
  0x3D, 0x07, 0x50, 0xB0, 0x92, 0x38, 0x0C, 0x06, 0x53, 0xC0, 0x4B, 0x4B, 0x30,
  // "v" (U+0076)
  0x87, 0x0C, 0x29, 0x08, 0x0B, 0x06, 0x0B, 0x42, 0x0B, 0x50, 0x01, 0x00,
  // "w" (U+0077)
  0x59, 0x0B, 0x24, 0x41, 0x92, 0xC3, 0x43, 0x19, 0x67, 0x36, 0x01, 0xA5, 0x67, 0x30, 0x0D, 0x06,
  0x80, 0x00,
  // "x" (U+0078)
  0x1C, 0x09, 0x20, 0x79, 0x30, 0x03, 0xB0, 0x00, 0x8B, 0x00, 0x92, 0x78, 0x00,
  // "y" (U+0079)
  0x00, 0xA5, 0x0B, 0x00, 0x39, 0x09, 0x00, 0x0C, 0x17, 0x00, 0x0A, 0x81, 0x00, 0x06, 0x70, 0x00,
  0x09, 0x00, 0x17, 0x91, 0x00,
  // "z" (U+007A)
  0x2A, 0xA9, 0x10, 0xB1, 0x08, 0x40, 0x39, 0x02, 0xC9, 0x94,
  // "{" (U+007B)
  0x00, 0x95, 0x00, 0xB0, 0x03, 0x80, 0x06, 0x50, 0x3A, 0x00, 0x0C, 0x00, 0x0B, 0x00, 0x08, 0x20,
  // "|" (U+007C)
  0x80, 0x57,
  // "}" (U+007D)
  0x00, 0x85, 0x00, 0x38, 0x00, 0x65, 0x00, 0x84, 0x00, 0x4A, 0x00, 0xB0, 0x04, 0x80, 0x28, 0x10,
  // "~" (U+007E)
  0x29, 0x25, 0x50, 0x76,
  // "¡" (U+00A1)
  0x0B, 0x02, 0x06, 0x26, 0x54, 0x92, 0x90,
  // "¢" (U+00A2)
  0x00, 0x36, 0x00, 0x6E, 0xC1, 0x0D, 0x50, 0x03, 0x95, 0x00, 0x49, 0x61, 0x00, 0xDB, 0x30, 0x02,
  0x30, 0x00,
  // "£" (U+00A3)
  0x02, 0x8A, 0x40, 0x90, 0x23, 0x0A, 0x00, 0x03, 0xC7, 0x20, 0x09, 0x00, 0x00, 0x80, 0x00, 0x8A,
  0xC7, 0x00,
  // "¤" (U+00A4)
  0x00, 0x01, 0x2B, 0x89, 0x15, 0x07, 0x16, 0x07, 0x39, 0x88,
  // "¥" (U+00A5)
  0x1E, 0x44, 0xC0, 0xB1, 0x53, 0x08, 0x37, 0x00, 0x59, 0x30, 0x17, 0xD5, 0x02, 0x8A, 0x30, 0x2B,
  0x90, 0x00,
  // "¦" (U+00A6)
  0x77, 0x74, 0x04, 0x77, 0x70,
  // "§" (U+00A7)
  0x04, 0x6A, 0x10, 0x90, 0x30, 0x0A, 0xA1, 0x03, 0x65, 0xA0, 0x1D, 0x78, 0x00, 0x1B, 0x40, 0x70,
  0x52, 0x05, 0x64, 0x00,
  // "¨" (U+00A8)
  0x33, 0x70,
  // "©" (U+00A9)
  0x01, 0x77, 0x60, 0x01, 0x84, 0x75, 0x80, 0x62, 0x80, 0x34, 0x27, 0x27, 0x00, 0x24, 0x62, 0x90,
  0x14, 0x21, 0x85, 0x65, 0x80, 0x01, 0x77, 0x60, 0x00,
  // "ª" (U+00AA)
  0x07, 0xA1, 0x63, 0xA0, 0x57, 0x91,
  // "«" (U+00AB)
  0x01, 0x23, 0x19, 0x74, 0x66, 0xC0, 0x07, 0x61,
  // "¬" (U+00AC)
  0x48, 0x89, 0x00, 0x07, 0x00, 0x05,
  // "®" (U+00AE)
  0x01, 0x77, 0x60, 0x01, 0x98, 0x54, 0x80, 0x61, 0x90, 0x94, 0x27, 0x09, 0x92, 0x24, 0x61, 0x94,
  0x64, 0x21, 0x89, 0x29, 0x80, 0x01, 0x77, 0x60, 0x00,
  // "¯" (U+00AF)
  0x18, 0x88, 0x40,
  // "°" (U+00B0)
  0x79, 0x18, 0x35, 0x79, 0x10,
  // "±" (U+00B1)
  0x00, 0x70, 0x38, 0xB7, 0x00, 0x70, 0x00, 0x60, 0x38, 0x87,
  // "²" (U+00B2)
  0x06, 0x61, 0x02, 0x72, 0x03, 0x40, 0x38, 0x80,
  // "³" (U+00B3)
  0x05, 0x73, 0x02, 0xA1, 0x21, 0x82, 0x26, 0x60,
  // "´" (U+00B4)
  0x23, 0x80,
  // "µ" (U+00B5)
  0x18, 0xA7, 0xB0, 0x65, 0x0B, 0x09, 0x23, 0x80, 0xB0, 0x66, 0x1B, 0x09, 0xB6, 0xB2, 0xA4, 0x0D,
  0x40,
  // "¶" (U+00B6)
  0x4E, 0xCB, 0x49, 0xFA, 0x70, 0x6F, 0xA7, 0x00, 0x38, 0x70, 0x00, 0x77, 0x00, 0x07, 0x70, 0x00,
  0x77, 0x00, 0x36, 0x64,
  // "·" (U+00B7)
  0x39, 0x01,
  // "¸" (U+00B8)
  0x05, 0x00, 0xA1, 0x57, 0x00,
  // "¹" (U+00B9)
  0x04, 0x80, 0x38, 0x05, 0x51, 0x75,
  // "º" (U+00BA)
  0x08, 0x91, 0x64, 0x82, 0x48, 0x80,
  // "»" (U+00BB)
  0x02, 0x30, 0x0A, 0x63, 0x0B, 0x76, 0x64, 0x70,
  // "¼" (U+00BC)
  0x00, 0x00, 0x43, 0x00, 0x04, 0x80, 0x80, 0x00, 0x03, 0x86, 0x10, 0x00, 0x05, 0x67, 0x01, 0xB0,
  0x17, 0xD0, 0x06, 0xA0, 0x03, 0x50, 0x47, 0xB1, 0x08, 0x00, 0x05, 0x60,
  // "½" (U+00BD)
  0x00, 0x00, 0x43, 0x00, 0x04, 0x80, 0x80, 0x00, 0x03, 0x86, 0x10, 0x00, 0x05, 0x67, 0x06, 0x61,
  0x17, 0xD0, 0x02, 0x72, 0x03, 0x50, 0x03, 0x40, 0x08, 0x00, 0x38, 0x80,
  // "¾" (U+00BE)
  0x00, 0x00, 0x04, 0x30, 0x05, 0x73, 0x08, 0x00, 0x02, 0xA1, 0x61, 0x00, 0x21, 0x83, 0x71, 0xB0,
  0x26, 0x67, 0x16, 0xA0, 0x00, 0x35, 0x47, 0xB1, 0x00, 0x80, 0x05, 0x60,
  // "¿" (U+00BF)
  0x00, 0xC0, 0x02, 0x00, 0x71, 0x92, 0xB1, 0x0C, 0x08, 0x57, 0x60,
  // "À" (U+00C0)
  0x30, 0x56, 0x03, 0x05, 0x60, 0xD5, 0x81, 0x6C, 0x14, 0x81, 0x88, 0x33, 0x82, 0x52, 0x75, 0x38,
  0x2A, 0x79, 0x72, 0x89, 0x35, 0x30, 0x39, 0x02, 0xD3, 0x08, 0xD1,
  // "Á" (U+00C1)
  0x40, 0x20, 0x35, 0x08, 0x60, 0xD5, 0x81, 0x6C, 0x14, 0x81, 0x88, 0x33, 0x82, 0x52, 0x75, 0x38,
  0x2A, 0x79, 0x72, 0x89, 0x35, 0x30, 0x39, 0x02, 0xD3, 0x08, 0xD1,
  // "Â" (U+00C2)
  0x30, 0x10, 0x65, 0x81, 0x88, 0x15, 0x0D, 0x58, 0x16, 0xC1, 0x48, 0x18, 0x83, 0x38, 0x25, 0x27,
  0x53, 0x82, 0xA7, 0x97, 0x28, 0x93, 0x53, 0x03, 0x90, 0x2D, 0x30, 0x8D, 0x10,
  // "Ã" (U+00C3)
  0x00, 0x06, 0x85, 0x00, 0x00, 0x3F, 0x50, 0x00, 0x06, 0xC1, 0x00, 0x00, 0x88, 0x30, 0x00, 0x52,
  0x75, 0x00, 0x0A, 0x79, 0x70, 0x05, 0x30, 0x39, 0x02, 0xD3, 0x08, 0xD1,
  // "Ä" (U+00C4)
  0x38, 0x13, 0x37, 0x50, 0xD5, 0x81, 0x6C, 0x14, 0x81, 0x88, 0x33, 0x82, 0x52, 0x75, 0x38, 0x2A,
  0x79, 0x72, 0x89, 0x35, 0x30, 0x39, 0x02, 0xD3, 0x08, 0xD1,
  // "Å" (U+00C5)
  0x40, 0x50, 0x65, 0x00, 0x75, 0x90, 0x64, 0x81, 0x6C, 0x14, 0x81, 0x88, 0x33, 0x82, 0x52, 0x75,
  0x38, 0x2A, 0x79, 0x72, 0x89, 0x35, 0x30, 0x39, 0x02, 0xD3, 0x08, 0xD1,
  // "Æ" (U+00C6)
  0x48, 0x38, 0xD7, 0x79, 0x40, 0x70, 0xC2, 0x03, 0x38, 0x16, 0x2C, 0x58, 0x41, 0x72, 0xC7, 0x43,
  0x82, 0x88, 0xA7, 0x48, 0x96, 0x35, 0x08, 0x40, 0x30, 0x2D, 0x33, 0xD7, 0x6B, 0x10,
  // "Ç" (U+00C7)
  0x00, 0x87, 0xB0, 0xA2, 0x07, 0x3A, 0x00, 0x07, 0x60, 0x00, 0x84, 0x00, 0x06, 0x60, 0x01, 0x09,
  0xE8, 0x10, 0x0A, 0x10, 0x05, 0x70, 0x00,
  // "È" (U+00C8)
  0x00, 0x50, 0x00, 0x03, 0x50, 0x0A, 0xA6, 0xC0, 0x75, 0x04, 0x09, 0x30, 0x00, 0xC7, 0x60, 0x0C,
  0x00, 0x02, 0xA0, 0x03, 0x9B, 0x6A, 0x30,
  // "É" (U+00C9)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x0A, 0xA6, 0xC0, 0x75, 0x04, 0x09, 0x30, 0x00, 0xC7, 0x60, 0x0C,
  0x00, 0x02, 0xA0, 0x03, 0x9B, 0x6A, 0x30,
  // "Ê" (U+00CA)
  0x00, 0x16, 0x00, 0x08, 0x81, 0x0A, 0xA6, 0xC0, 0x75, 0x04, 0x09, 0x30, 0x00, 0xC7, 0x60, 0x0C,
  0x00, 0x02, 0xA0, 0x03, 0x9B, 0x6A, 0x30,
  // "Ë" (U+00CB)
  0x00, 0x33, 0x70, 0xAA, 0x6C, 0x07, 0x50, 0x40, 0x93, 0x00, 0x0C, 0x76, 0x00, 0xC0, 0x00, 0x2A,
  0x00, 0x39, 0xB6, 0xA3,
  // "Ì" (U+00CC)
  0x05, 0x00, 0x03, 0x50, 0x0A, 0xB2, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00,
  0xAC, 0x10,
  // "Í" (U+00CD)
  0x00, 0x23, 0x00, 0x80, 0x0A, 0xB2, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00,
  0xAC, 0x10,
  // "Î" (U+00CE)
  0x01, 0x60, 0x08, 0x81, 0x0A, 0xB2, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00,
  0xAC, 0x10,
  // "Ï" (U+00CF)
  0x03, 0x37, 0x0A, 0xB2, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0xAC, 0x10,
  // "Ð" (U+00D0)
  0x0A, 0xA6, 0x80, 0x07, 0x50, 0x75, 0x09, 0x30, 0x57, 0x3D, 0x72, 0x56, 0x0C, 0x00, 0x93, 0x2A,
  0x01, 0xB0, 0xAB, 0x69, 0x10,
  // "Ñ" (U+00D1)
  0x00, 0x06, 0x85, 0x00, 0xAA, 0x3A, 0xF3, 0x07, 0xC0, 0x07, 0x00, 0x77, 0x50, 0x60, 0x07, 0x2B,
  0x33, 0x00, 0x70, 0xB7, 0x10, 0x25, 0x06, 0xD0, 0x0A, 0x80, 0x1A, 0x00,
  // "Ò" (U+00D2)
  0x00, 0x05, 0x00, 0x00, 0x03, 0x50, 0x01, 0x87, 0x91, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76,
  0x00, 0x59, 0x84, 0x00, 0x85, 0x66, 0x01, 0xB0, 0x09, 0x79, 0x10,
  // "Ó" (U+00D3)
  0x00, 0x02, 0x30, 0x00, 0x08, 0x00, 0x01, 0x87, 0x91, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76,
  0x00, 0x59, 0x84, 0x00, 0x85, 0x66, 0x01, 0xB0, 0x09, 0x79, 0x10,
  // "Ô" (U+00D4)
  0x00, 0x01, 0x60, 0x00, 0x08, 0x81, 0x01, 0x87, 0x91, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76,
  0x00, 0x59, 0x84, 0x00, 0x85, 0x66, 0x01, 0xB0, 0x09, 0x79, 0x10,
  // "Õ" (U+00D5)
  0x00, 0x68, 0x50, 0x01, 0xCF, 0xF1, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76, 0x00, 0x59, 0x84,
  0x00, 0x85, 0x66, 0x01, 0xB0, 0x09, 0x79, 0x10,
  // "Ö" (U+00D6)
  0x00, 0x33, 0x70, 0x01, 0x87, 0x91, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76, 0x00, 0x59, 0x84,
  0x00, 0x85, 0x66, 0x01, 0xB0, 0x09, 0x79, 0x10,
  // "×" (U+00D7)
  0x21, 0x03, 0x08, 0x73, 0x07, 0x91, 0x23, 0x06,
  // "Ø" (U+00D8)
  0x01, 0x87, 0xA4, 0x0A, 0x20, 0xA7, 0x3A, 0x06, 0x4A, 0x76, 0x24, 0x49, 0x84, 0x70, 0x85, 0x6A,
  0x21, 0xB0, 0x2B, 0x79, 0x10,
  // "Ù" (U+00D9)
  0x00, 0x05, 0x00, 0x00, 0x00, 0x35, 0x00, 0x1B, 0xA1, 0x5B, 0x20, 0x92, 0x02, 0x50, 0x0C, 0x00,
  0x42, 0x00, 0xC0, 0x07, 0x00, 0x2A, 0x00, 0x70, 0x03, 0x90, 0x07, 0x00, 0x09, 0x88, 0x10, 0x00,
  // "Ú" (U+00DA)
  0x00, 0x02, 0x30, 0x00, 0x00, 0x80, 0x00, 0x1B, 0xA1, 0x5B, 0x20, 0x92, 0x02, 0x50, 0x0C, 0x00,
  0x42, 0x00, 0xC0, 0x07, 0x00, 0x2A, 0x00, 0x70, 0x03, 0x90, 0x07, 0x00, 0x09, 0x88, 0x10, 0x00,
  // "Û" (U+00DB)
  0x00, 0x01, 0x60, 0x00, 0x00, 0x88, 0x10, 0x1B, 0xA1, 0x5B, 0x20, 0x92, 0x02, 0x50, 0x0C, 0x00,
  0x42, 0x00, 0xC0, 0x07, 0x00, 0x2A, 0x00, 0x70, 0x03, 0x90, 0x07, 0x00, 0x09, 0x88, 0x10, 0x00,
  // "Ü" (U+00DC)
  0x00, 0x33, 0x70, 0x01, 0xBA, 0x15, 0xB2, 0x09, 0x20, 0x25, 0x00, 0xC0, 0x04, 0x20, 0x0C, 0x00,
  0x70, 0x02, 0xA0, 0x07, 0x00, 0x39, 0x00, 0x70, 0x00, 0x98, 0x81, 0x00,
  // "Ý" (U+00DD)
  0x30, 0x20, 0x34, 0x08, 0x28, 0x91, 0x2E, 0x51, 0xC5, 0x09, 0x30, 0x72, 0x81, 0x57, 0x63, 0x81,
  0x1C, 0x54, 0x0C, 0x40, 0x10, 0xA3, 0x82, 0x19, 0xC1, 0x20,
  // "Þ" (U+00DE)
  0x0A, 0xC2, 0x00, 0x79, 0x71, 0x09, 0x24, 0x80, 0xC0, 0x3A, 0x0C, 0x07, 0x52, 0xC6, 0x50, 0xAB,
  0x10, 0x00,
  // "ß" (U+00DF)
  0x00, 0x19, 0x77, 0x00, 0x93, 0x0A, 0x02, 0xD4, 0x94, 0x00, 0xB7, 0x40, 0x02, 0x91, 0xC2, 0x05,
  0x62, 0x37, 0x08, 0x49, 0x93, 0x0B, 0x00, 0x00, 0x76, 0x00, 0x00,
  // "à" (U+00E0)
  0x20, 0x54, 0x03, 0x05, 0x78, 0xA6, 0x67, 0xA2, 0x39, 0x0B, 0x08, 0x40, 0xB0, 0x92, 0x4A, 0x05,
  0xA5, 0xC3,
  // "á" (U+00E1)
  0x30, 0x20, 0x33, 0x08, 0x78, 0xA6, 0x67, 0xA2, 0x39, 0x0B, 0x08, 0x40, 0xB0, 0x92, 0x4A, 0x05,
  0xA5, 0xC3,
  // "â" (U+00E2)
  0x00, 0x16, 0x00, 0x08, 0x81, 0x00, 0x00, 0x00, 0x67, 0xA2, 0x39, 0x0B, 0x08, 0x40, 0xB0, 0x92,
  0x4A, 0x05, 0xA5, 0xC3,
  // "ã" (U+00E3)
  0x06, 0x85, 0x00, 0x38, 0x50, 0x06, 0x7A, 0x23, 0x90, 0xB0, 0x84, 0x0B, 0x09, 0x24, 0xA0, 0x5A,
  0x5C, 0x30,
  // "ä" (U+00E4)
  0x18, 0x13, 0x37, 0x78, 0xA6, 0x67, 0xA2, 0x39, 0x0B, 0x08, 0x40, 0xB0, 0x92, 0x4A, 0x05, 0xA5,
  0xC3,
  // "å" (U+00E5)
  0x00, 0x56, 0x00, 0x07, 0x70, 0x00, 0x56, 0x00, 0x67, 0xA2, 0x39, 0x0B, 0x08, 0x40, 0xB0, 0x92,
  0x4A, 0x05, 0xA5, 0xC3,
  // "æ" (U+00E6)
  0x07, 0x78, 0x8A, 0x34, 0x80, 0xA1, 0xA3, 0x84, 0x0D, 0x63, 0x09, 0x24, 0xB0, 0x00, 0x4A, 0x58,
  0x86, 0x00,
  // "ç" (U+00E7)
  0x07, 0x7A, 0x38, 0x04, 0x84, 0x00, 0x93, 0x00, 0x3F, 0x81, 0x0A, 0x10, 0x57, 0x00,
  // "è" (U+00E8)
  0x00, 0x50, 0x00, 0x35, 0x00, 0x00, 0x06, 0x89, 0x38, 0x39, 0x89, 0x60, 0x93, 0x00, 0x3A, 0x81,
  // "é" (U+00E9)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x06, 0x89, 0x38, 0x39, 0x89, 0x60, 0x93, 0x00, 0x3A, 0x81,
  // "ê" (U+00EA)
  0x00, 0x16, 0x00, 0x08, 0x81, 0x00, 0x00, 0x00, 0x68, 0x90, 0x38, 0x39, 0x08, 0x96, 0x00, 0x93,
  0x00, 0x03, 0xA8, 0x10,
  // "ë" (U+00EB)
  0x03, 0x37, 0x00, 0x00, 0x06, 0x89, 0x38, 0x39, 0x89, 0x60, 0x93, 0x00, 0x3A, 0x81,
  // "ì" (U+00EC)
  0x05, 0x00, 0x35, 0x00, 0x03, 0xD0, 0x0B, 0x03, 0x80, 0x55, 0x04, 0x91,
  // "í" (U+00ED)
  0x02, 0x30, 0x80, 0x00, 0x03, 0xD0, 0x0B, 0x03, 0x80, 0x55, 0x04, 0x91,
  // "î" (U+00EE)
  0x16, 0x08, 0x81, 0x00, 0x03, 0xD0, 0x0B, 0x03, 0x80, 0x55, 0x04, 0x91,
  // "ï" (U+00EF)
  0x33, 0x70, 0x00, 0x3D, 0x00, 0xB0, 0x38, 0x05, 0x50, 0x49, 0x10,
  // "ð" (U+00F0)
  0x02, 0x87, 0x10, 0x16, 0x90, 0x04, 0x7D, 0x02, 0x90, 0xA2, 0x84, 0x0A, 0x19, 0x30, 0xB0, 0x38,
  0x83, 0x00,
  // "ñ" (U+00F1)
  0x00, 0x68, 0x50, 0x03, 0x85, 0x3D, 0x6C, 0x00, 0xD1, 0xA1, 0x38, 0x0B, 0x05, 0x50, 0xB0, 0x82,
  0x0B, 0x40,
  // "ò" (U+00F2)
  0x20, 0x54, 0x03, 0x05, 0x78, 0xA5, 0x77, 0x90, 0x48, 0x09, 0x28, 0x30, 0xA2, 0x93, 0x0B, 0x03,
  0x98, 0x31,
  // "ó" (U+00F3)
  0x30, 0x20, 0x33, 0x08, 0x78, 0xA5, 0x77, 0x90, 0x48, 0x09, 0x28, 0x30, 0xA2, 0x93, 0x0B, 0x03,
  0x98, 0x31,
  // "ô" (U+00F4)
  0x00, 0x16, 0x00, 0x08, 0x81, 0x00, 0x00, 0x00, 0x77, 0x90, 0x48, 0x09, 0x28, 0x30, 0xA2, 0x93,
  0x0B, 0x03, 0x98, 0x30,
  // "õ" (U+00F5)
  0x06, 0x85, 0x00, 0x38, 0x50, 0x07, 0x79, 0x04, 0x80, 0x92, 0x83, 0x0A, 0x29, 0x30, 0xB0, 0x39,
  0x83, 0x00,
  // "ö" (U+00F6)
  0x18, 0x13, 0x37, 0x78, 0xA5, 0x77, 0x90, 0x48, 0x09, 0x28, 0x30, 0xA2, 0x93, 0x0B, 0x03, 0x98,
  0x31,
  // "÷" (U+00F7)
  0x01, 0x70, 0x48, 0x88, 0x00, 0x00, 0x01, 0x70,
  // "ø" (U+00F8)
  0x48, 0xB1, 0x30, 0x77, 0xC1, 0x38, 0x3C, 0x38, 0x46, 0xA2, 0x99, 0x1B, 0x06, 0x98, 0x30, 0x34,
  // "ù" (U+00F9)
  0x20, 0x54, 0x03, 0x05, 0x68, 0xA7, 0x3D, 0x07, 0x50, 0xB0, 0x92, 0x38, 0x0C, 0x06, 0x53, 0xC0,
  0x4B, 0x4B, 0x30,
  // "ú" (U+00FA)
  0x30, 0x20, 0x33, 0x08, 0x68, 0xA7, 0x3D, 0x07, 0x50, 0xB0, 0x92, 0x38, 0x0C, 0x06, 0x53, 0xC0,
  0x4B, 0x4B, 0x30,
  // "û" (U+00FB)
  0x00, 0x16, 0x00, 0x08, 0x81, 0x00, 0x00, 0x03, 0xD0, 0x75, 0x0B, 0x09, 0x23, 0x80, 0xC0, 0x65,
  0x3C, 0x04, 0xB4, 0xB3,
  // "ü" (U+00FC)
  0x03, 0x37, 0x00, 0x00, 0x00, 0x3D, 0x07, 0x50, 0xB0, 0x92, 0x38, 0x0C, 0x06, 0x53, 0xC0, 0x4B,
  0x4B, 0x30,
  // "ý" (U+00FD)
  0x40, 0x20, 0x34, 0x08, 0x72, 0x82, 0xA5, 0x0B, 0x28, 0x23, 0x90, 0x93, 0x81, 0xC1, 0x73, 0x81,
  0xA8, 0x13, 0x06, 0x07, 0x40, 0x92, 0x82, 0x17, 0x91, 0x20,
  // "þ" (U+00FE)
  0x01, 0xD2, 0x00, 0x00, 0xB0, 0x00, 0x00, 0xB7, 0xB0, 0x02, 0xC0, 0xA1, 0x05, 0x70, 0xB0, 0x08,
  0x31, 0xA0, 0x0B, 0x78, 0x10, 0x0B, 0x00, 0x00, 0x1D, 0x20, 0x00,
  // "ÿ" (U+00FF)
  0x38, 0x13, 0x37, 0x71, 0x82, 0xA5, 0x0B, 0x28, 0x23, 0x90, 0x93, 0x81, 0xC1, 0x73, 0x81, 0xA8,
  0x13, 0x06, 0x07, 0x40, 0x92, 0x82, 0x17, 0x91, 0x20,
  // "Ā" (U+0100)
  0x00, 0x01, 0xF8, 0x20, 0x00, 0x6C, 0x10, 0x00, 0x08, 0x83, 0x00, 0x05, 0x27, 0x50, 0x00, 0xA7,
  0x97, 0x00, 0x53, 0x03, 0x90, 0x2D, 0x30, 0x8D, 0x10,
  // "ā" (U+0101)
  0x00, 0x88, 0x20, 0x67, 0xA2, 0x39, 0x0B, 0x08, 0x40, 0xB0, 0x92, 0x4A, 0x05, 0xA5, 0xC3,
  // "Ă" (U+0102)
  0x48, 0x14, 0x12, 0x49, 0x0A, 0x48, 0x16, 0xC1, 0x48, 0x18, 0x83, 0x38, 0x25, 0x27, 0x53, 0x82,
  0xA7, 0x97, 0x28, 0x93, 0x53, 0x03, 0x90, 0x2D, 0x30, 0x8D, 0x10,
  // "ă" (U+0103)
  0x00, 0x41, 0x20, 0x07, 0xA0, 0x06, 0x7A, 0x23, 0x90, 0xB0, 0x84, 0x0B, 0x09, 0x24, 0xA0, 0x5A,
  0x5C, 0x30,
  // "Ą" (U+0104)
  0x40, 0xD5, 0x81, 0x6C, 0x14, 0x81, 0x88, 0x33, 0x82, 0x52, 0x75, 0x38, 0x2A, 0x79, 0x72, 0x89,
  0x35, 0x30, 0x39, 0x02, 0xD3, 0x08, 0xE1, 0x40, 0x30, 0x75, 0x81, 0x19, 0x10,
  // "ą" (U+0105)
  0x06, 0x7A, 0x23, 0x90, 0xB0, 0x84, 0x0B, 0x09, 0x24, 0xA0, 0x5A, 0x5D, 0x30, 0x03, 0x70, 0x00,
  0x19, 0x10,
  // "Ć" (U+0106)
  0x40, 0x20, 0x34, 0x08, 0x38, 0x18, 0x7B, 0x28, 0x5A, 0x20, 0x70, 0x3A, 0x40, 0x70, 0x64, 0x08,
  0x04, 0x40, 0x06, 0x20, 0x12, 0x82, 0x98, 0x81, 0x10,
  // "ć" (U+0107)
  0x30, 0x20, 0x33, 0x08, 0x78, 0x91, 0x77, 0xA0, 0x38, 0x04, 0x08, 0x43, 0x09, 0x03, 0x38, 0x23,
  0xA8, 0x11,
  // "Ĉ" (U+0108)
  0x30, 0x10, 0x64, 0x81, 0x88, 0x12, 0x81, 0x87, 0xB2, 0x85, 0xA2, 0x07, 0x03, 0xA4, 0x07, 0x06,
  0x40, 0x80, 0x44, 0x00, 0x62, 0x01, 0x28, 0x29, 0x88, 0x11,
  // "ĉ" (U+0109)
  0x00, 0x16, 0x00, 0x08, 0x81, 0x00, 0x00, 0x00, 0x77, 0xA0, 0x38, 0x04, 0x08, 0x40, 0x00, 0x93,
  0x00, 0x03, 0xA8, 0x10,
  // "Ċ" (U+010A)
  0x00, 0x00, 0x70, 0x08, 0x7B, 0x0A, 0x20, 0x73, 0xA0, 0x00, 0x76, 0x00, 0x08, 0x40, 0x00, 0x66,
  0x00, 0x10, 0x98, 0x81,
  // "ċ" (U+010B)
  0x00, 0x70, 0x00, 0x00, 0x07, 0x7A, 0x38, 0x04, 0x84, 0x00, 0x93, 0x00, 0x3A, 0x81,
  // "Č" (U+010C)
  0x38, 0x13, 0x12, 0x30, 0x70, 0xA3, 0x81, 0x87, 0xB2, 0x85, 0xA2, 0x07, 0x03, 0xA4, 0x07, 0x06,
  0x40, 0x80, 0x44, 0x00, 0x62, 0x01, 0x28, 0x29, 0x88, 0x11,
  // "č" (U+010D)
  0x00, 0x31, 0x20, 0x07, 0xA0, 0x00, 0x00, 0x00, 0x77, 0xA0, 0x38, 0x04, 0x08, 0x40, 0x00, 0x93,
  0x00, 0x03, 0xA8, 0x10,
  // "Ď" (U+010E)
  0x00, 0x03, 0x12, 0x00, 0x07, 0xA0, 0x0A, 0xA6, 0x80, 0x07, 0x50, 0x75, 0x09, 0x20, 0x57, 0x0C,
  0x00, 0x56, 0x0C, 0x00, 0x93, 0x2A, 0x01, 0xB0, 0xAB, 0x69, 0x10,
  // "ď" (U+010F)
  0x00, 0x08, 0x89, 0x00, 0x05, 0x71, 0x06, 0x7C, 0x30, 0x39, 0x0B, 0x00, 0x84, 0x0B, 0x00, 0x92,
  0x4A, 0x00, 0x5A, 0x5C, 0x30,
  // "Đ" (U+0110)
  0x0A, 0xA6, 0x80, 0x07, 0x50, 0x75, 0x09, 0x30, 0x57, 0x3D, 0x72, 0x56, 0x0C, 0x00, 0x93, 0x2A,
  0x01, 0xB0, 0xAB, 0x69, 0x10,
  // "đ" (U+0111)
  0x00, 0x09, 0x80, 0x04, 0x99, 0x06, 0x7C, 0x33, 0x80, 0xB0, 0x84, 0x0C, 0x09, 0x25, 0xA0, 0x5A,
  0x5B, 0x30,
  // "Ē" (U+0112)
  0x0A, 0xFE, 0xE0, 0x75, 0x04, 0x09, 0x30, 0x00, 0xC7, 0x60, 0x0C, 0x00, 0x02, 0xA0, 0x03, 0x9B,
  0x6A, 0x30,
  // "ē" (U+0113)
  0x00, 0x88, 0x20, 0x68, 0x90, 0x38, 0x39, 0x08, 0x96, 0x00, 0x93, 0x00, 0x03, 0xA8, 0x10,
  // "Ĕ" (U+0114)
  0x00, 0x41, 0x20, 0xAF, 0xFC, 0x07, 0x50, 0x40, 0x93, 0x00, 0x0C, 0x76, 0x00, 0xC0, 0x00, 0x2A,
  0x00, 0x39, 0xB6, 0xA3,
  // "ĕ" (U+0115)
  0x00, 0x41, 0x20, 0x07, 0xA0, 0x06, 0x89, 0x03, 0x83, 0x90, 0x89, 0x60, 0x09, 0x30, 0x00, 0x3A,
  0x81, 0x00,
  // "Ė" (U+0116)
  0x00, 0x07, 0x00, 0xAA, 0x6C, 0x07, 0x50, 0x40, 0x93, 0x00, 0x0C, 0x76, 0x00, 0xC0, 0x00, 0x2A,
  0x00, 0x39, 0xB6, 0xA3,
  // "ė" (U+0117)
  0x00, 0x70, 0x00, 0x00, 0x06, 0x89, 0x38, 0x39, 0x89, 0x60, 0x93, 0x00, 0x3A, 0x81,
  // "Ę" (U+0118)
  0x0A, 0xA6, 0xC0, 0x75, 0x04, 0x09, 0x30, 0x00, 0xC7, 0x60, 0x0C, 0x00, 0x02, 0xA0, 0x03, 0x9B,
  0x7A, 0x30, 0x37, 0x00, 0x01, 0x91, 0x00,
  // "ę" (U+0119)
  0x06, 0x89, 0x38, 0x39, 0x89, 0x60, 0x93, 0x00, 0x3B, 0x81, 0x37, 0x00, 0x19, 0x10,
  // "Ě" (U+011A)
  0x00, 0x03, 0x12, 0x00, 0x07, 0xA0, 0x0A, 0xA6, 0xC0, 0x07, 0x50, 0x40, 0x09, 0x30, 0x00, 0x0C,
  0x76, 0x00, 0x0C, 0x00, 0x00, 0x2A, 0x00, 0x30, 0x9B, 0x6A, 0x30,
  // "ě" (U+011B)
  0x00, 0x31, 0x20, 0x07, 0xA0, 0x00, 0x00, 0x00, 0x68, 0x90, 0x38, 0x39, 0x08, 0x96, 0x00, 0x93,
  0x00, 0x03, 0xA8, 0x10,
  // "Ĝ" (U+011C)
  0x00, 0x01, 0x60, 0x00, 0x08, 0x81, 0x01, 0x87, 0xB3, 0x0A, 0x20, 0x65, 0x3A, 0x00, 0x00, 0x76,
  0x00, 0x00, 0x84, 0x04, 0xA3, 0x66, 0x01, 0xB0, 0x09, 0x78, 0x60,
  // "ĝ" (U+011D)
  0x00, 0x01, 0x60, 0x00, 0x08, 0x81, 0x00, 0x00, 0x48, 0x00, 0x77, 0xB2, 0x01, 0x90, 0xA0, 0x00,
  0xA7, 0x20, 0x04, 0x83, 0x00, 0x06, 0x9C, 0x70, 0x37, 0x02, 0x80, 0x19, 0x78, 0x10,
  // "Ğ" (U+011E)
  0x00, 0x04, 0x12, 0x01, 0x8F, 0xF4, 0x0A, 0x20, 0x65, 0x3A, 0x00, 0x00, 0x76, 0x00, 0x00, 0x84,
  0x04, 0xA3, 0x66, 0x01, 0xB0, 0x09, 0x78, 0x60,
  // "ğ" (U+011F)
  0x00, 0x04, 0x12, 0x00, 0x07, 0xE8, 0x00, 0x77, 0xB2, 0x01, 0x90, 0xA0, 0x00, 0xA7, 0x20, 0x04,
  0x83, 0x00, 0x06, 0x9C, 0x70, 0x37, 0x02, 0x80, 0x19, 0x78, 0x10,
  // "Ġ" (U+0120)
  0x00, 0x00, 0x70, 0x01, 0x87, 0xB3, 0x0A, 0x20, 0x65, 0x3A, 0x00, 0x00, 0x76, 0x00, 0x00, 0x84,
  0x04, 0xA3, 0x66, 0x01, 0xB0, 0x09, 0x78, 0x60,
  // "ġ" (U+0121)
  0x00, 0x07, 0x00, 0x00, 0x00, 0x48, 0x00, 0x77, 0xB2, 0x01, 0x90, 0xA0, 0x00, 0xA7, 0x20, 0x04,
  0x83, 0x00, 0x06, 0x9C, 0x70, 0x37, 0x02, 0x80, 0x19, 0x78, 0x10,
  // "Ģ" (U+0122)
  0x18, 0x93, 0x18, 0x7B, 0x30, 0xA2, 0x06, 0x53, 0xA4, 0x07, 0x06, 0x48, 0x91, 0x84, 0x04, 0xA3,
  0x66, 0x01, 0xB2, 0x82, 0x97, 0x86, 0x30, 0x54, 0x00, 0x33,
  // "ģ" (U+0123)
  0x00, 0x02, 0x50, 0x00, 0x00, 0x48, 0x00, 0x77, 0xB2, 0x01, 0x90, 0xA0, 0x00, 0xA7, 0x20, 0x04,
  0x83, 0x00, 0x06, 0x9C, 0x70, 0x37, 0x02, 0x80, 0x19, 0x78, 0x10,
  // "Ĥ" (U+0124)
  0x00, 0x01, 0x60, 0x00, 0x00, 0x88, 0x10, 0x0A, 0xC2, 0x4E, 0x50, 0x75, 0x00, 0xB0, 0x09, 0x30,
  0x39, 0x00, 0xC7, 0x7A, 0x60, 0x0C, 0x00, 0x83, 0x02, 0xA0, 0x0B, 0x00, 0xAB, 0x15, 0xE4, 0x00,
  // "ĥ" (U+0125)
  0x00, 0x16, 0x00, 0x08, 0x81, 0x00, 0x00, 0x00, 0xB4, 0x00, 0x0A, 0x10, 0x00, 0xB6, 0xC0, 0x0D,
  0x1A, 0x13, 0x80, 0xB0, 0x55, 0x0B, 0x08, 0x20, 0xB4,
  // "Ħ" (U+0126)
  0x0A, 0xC2, 0x4F, 0x50, 0x66, 0x00, 0xC0, 0x2C, 0x87, 0x9C, 0x30, 0xB7, 0x7A, 0x70, 0x0C, 0x00,
  0x84, 0x02, 0xA0, 0x0B, 0x10, 0x9B, 0x15, 0xE4, 0x00,
  // "ħ" (U+0127)
  0x0B, 0x40, 0x01, 0xB7, 0x20, 0x0B, 0x7C, 0x00, 0xD1, 0xA1, 0x28, 0x0B, 0x05, 0x50, 0xB0, 0x82,
  0x0B, 0x40,
  // "Ĩ" (U+0128)
  0x06, 0x85, 0x0D, 0xF7, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0xAC, 0x10,
  // "ĩ" (U+0129)
  0x68, 0x53, 0x85, 0x3D, 0x00, 0xB0, 0x38, 0x05, 0x50, 0x49, 0x10,
  // "Ī" (U+012A)
  0x0F, 0xF4, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0xAC, 0x10,
  // "ī" (U+012B)
  0x08, 0x82, 0x3D, 0x00, 0x0B, 0x00, 0x38, 0x00, 0x55, 0x00, 0x49, 0x10,
  // "Ĭ" (U+012C)
  0x04, 0x12, 0x0F, 0xF2, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0xAC, 0x10,
  // "ĭ" (U+012D)
  0x41, 0x27, 0xA0, 0x3D, 0x00, 0xB0, 0x38, 0x05, 0x50, 0x49, 0x10,
  // "Į" (U+012E)
  0x0A, 0xB2, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0xAD, 0x10, 0x37, 0x00,
  0x19, 0x10,
  // "į" (U+012F)
  0x00, 0x82, 0x00, 0x00, 0x03, 0xD0, 0x00, 0xB0, 0x03, 0x80, 0x05, 0x50, 0x05, 0xA1, 0x37, 0x00,
  0x19, 0x10,
  // "İ" (U+0130)
  0x00, 0x70, 0x0A, 0xB2, 0x07, 0x50, 0x09, 0x20, 0x0C, 0x00, 0x0C, 0x00, 0x2A, 0x00, 0xAC, 0x10,
  // "ı" (U+0131)
  0x3D, 0x00, 0xB0, 0x38, 0x05, 0x50, 0x49, 0x10,
  // "Ĳ" (U+0132)
  0x0A, 0xB2, 0xBB, 0x20, 0x75, 0x07, 0x40, 0x09, 0x20, 0xA1, 0x00, 0xC0, 0x0C, 0x00, 0x0C, 0x00,
  0xB0, 0x02, 0xA0, 0x39, 0x00, 0xAC, 0x16, 0x60, 0x00, 0x00, 0x92, 0x00, 0x01, 0x78, 0x00, 0x00,
  // "ĳ" (U+0133)
  0x08, 0x28, 0x20, 0x00, 0x00, 0x3D, 0x3D, 0x00, 0xB0, 0xB0, 0x38, 0x38, 0x05, 0x56, 0x50, 0x49,
  0xA2, 0x00, 0x0B, 0x00, 0x07, 0x60, 0x00,
  // "Ĵ" (U+0134)
  0x30, 0x10, 0x64, 0x81, 0x88, 0x13, 0x81, 0xBB, 0x23, 0x07, 0x04, 0x40, 0xA0, 0x14, 0x0C, 0x50,
  0xB4, 0x03, 0x09, 0x40, 0x06, 0x40, 0x90, 0x22, 0x81, 0x17, 0x83,
  // "ĵ" (U+0135)
  0x01, 0x60, 0x08, 0x81, 0x00, 0x00, 0x03, 0xD0, 0x00, 0xB0, 0x03, 0x80, 0x06, 0x50, 0x09, 0x20,
  0x0B, 0x00, 0x76, 0x00,
  // "Ķ" (U+0136)
  0x0A, 0xB2, 0x9A, 0x07, 0x51, 0x80, 0x09, 0x38, 0x00, 0x0C, 0xA7, 0x00, 0x0C, 0x1C, 0x00, 0x2A,
  0x0B, 0x20, 0xAC, 0x14, 0xA0, 0x00, 0x50, 0x00, 0x03, 0x30, 0x00,
  // "ķ" (U+0137)
  0x0B, 0x40, 0x00, 0xA1, 0x00, 0x0B, 0x0C, 0x50, 0xA5, 0x30, 0x3B, 0xC0, 0x05, 0x58, 0x40, 0x82,
  0x1B, 0x10, 0x50, 0x00, 0x33, 0x00, 0x00,
  // "ĸ" (U+0138)
  0x3D, 0x0C, 0x50, 0xB5, 0x30, 0x3B, 0xC0, 0x05, 0x58, 0x40, 0x82, 0x1B, 0x10,
  // "Ĺ" (U+0139)
  0x20, 0x20, 0x33, 0x08, 0x38, 0x1A, 0xB2, 0x20, 0x70, 0x53, 0x09, 0x02, 0x30, 0xC4, 0x0C, 0x38,
  0x90, 0x2A, 0x01, 0x6A, 0xB6, 0xA3,
  // "ĺ" (U+013A)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x0B, 0x40, 0x09, 0x10, 0x0B, 0x00, 0x0B, 0x00, 0x38, 0x00,
  0x56, 0x00, 0x49, 0x10,
  // "Ļ" (U+013B)
  0x18, 0x1A, 0xB2, 0x20, 0x70, 0x53, 0x09, 0x02, 0x30, 0xC4, 0x0C, 0x38, 0x90, 0x2A, 0x01, 0x6A,
  0xB6, 0xA3, 0x20, 0x53, 0x00, 0x32,
  // "ļ" (U+013C)
  0x00, 0xB4, 0x00, 0x91, 0x00, 0xB0, 0x00, 0xB0, 0x03, 0x80, 0x05, 0x60, 0x04, 0x91, 0x05, 0x00,
  0x33, 0x00,
  // "Ľ" (U+013D)
  0x0A, 0xB3, 0x70, 0x75, 0x20, 0x09, 0x20, 0x00, 0xC0, 0x00, 0x0C, 0x00, 0x02, 0xA0, 0x16, 0xAB,
  0x6A, 0x30,
  // "ľ" (U+013E)
  0x0B, 0x67, 0x09, 0x40, 0x0B, 0x00, 0x0B, 0x00, 0x38, 0x00, 0x56, 0x00, 0x49, 0x10,
  // "Ŀ" (U+013F)
  0x0A, 0xB2, 0x00, 0x75, 0x00, 0x09, 0x20, 0x00, 0xC0, 0x07, 0x0C, 0x00, 0x02, 0xA0, 0x16, 0xAB,
  0x6A, 0x30,
  // "ŀ" (U+0140)
  0x0B, 0x40, 0x91, 0x0B, 0x00, 0xB7, 0x38, 0x05, 0x60, 0x49, 0x10,
  // "Ł" (U+0141)
  0x0A, 0xB2, 0x00, 0x75, 0x00, 0x09, 0x53, 0x00, 0xC5, 0x00, 0x5C, 0x00, 0x02, 0xA0, 0x16, 0xAB,
  0x6A, 0x30,
  // "ł" (U+0142)
  0x0B, 0x40, 0x91, 0x0B, 0x00, 0xD4, 0x88, 0x05, 0x60, 0x49, 0x10,
  // "Ń" (U+0143)
  0x00, 0x00, 0x23, 0x00, 0x00, 0x08, 0x00, 0x0A, 0xA0, 0x2C, 0x30, 0x7C, 0x00, 0x70, 0x07, 0x75,
  0x06, 0x00, 0x72, 0xB3, 0x30, 0x07, 0x0B, 0x71, 0x02, 0x50, 0x6D, 0x00, 0xA8, 0x01, 0xA0, 0x00,
  // "ń" (U+0144)
  0x30, 0x20, 0x33, 0x08, 0x68, 0x23, 0xD6, 0xC2, 0x8A, 0x1D, 0x1A, 0x13, 0x80, 0xB0, 0x55, 0x0B,
  0x08, 0x20, 0xB4,
  // "Ņ" (U+0145)
  0x18, 0x7A, 0xA0, 0x2C, 0x30, 0x7C, 0x20, 0x72, 0x83, 0x77, 0x50, 0x62, 0x83, 0x72, 0xB3, 0x32,
  0x89, 0x17, 0x0B, 0x71, 0x02, 0x50, 0x6D, 0x28, 0x3A, 0x80, 0x1A, 0x40, 0x55, 0x00, 0x34,
  // "ņ" (U+0146)
  0x3D, 0x6C, 0x00, 0xD1, 0xA1, 0x38, 0x0B, 0x05, 0x50, 0xB0, 0x82, 0x0B, 0x40, 0x05, 0x00, 0x03,
  0x30, 0x00,
  // "Ň" (U+0147)
  0x00, 0x03, 0x12, 0x00, 0x00, 0x7A, 0x00, 0x0A, 0xA0, 0x2C, 0x30, 0x7C, 0x00, 0x70, 0x07, 0x75,
  0x06, 0x00, 0x72, 0xB3, 0x30, 0x07, 0x0B, 0x71, 0x02, 0x50, 0x6D, 0x00, 0xA8, 0x01, 0xA0, 0x00,
  // "ň" (U+0148)
  0x00, 0x31, 0x20, 0x07, 0xA0, 0x00, 0x00, 0x03, 0xD6, 0xC0, 0x0D, 0x1A, 0x13, 0x80, 0xB0, 0x55,
  0x0B, 0x08, 0x20, 0xB4,
  // "ŉ" (U+0149)
  0x0C, 0x00, 0x00, 0x08, 0x00, 0x00, 0x25, 0xD6, 0xC0, 0x00, 0xD1, 0xA1, 0x03, 0x80, 0xB0, 0x05,
  0x50, 0xB0, 0x08, 0x20, 0xB4,
  // "Ŋ" (U+014A)
  0x0A, 0xA0, 0x3C, 0x40, 0x7D, 0x10, 0x70, 0x07, 0x76, 0x06, 0x00, 0x72, 0xB3, 0x30, 0x07, 0x0B,
  0x70, 0x02, 0x50, 0x6C, 0x00, 0xA8, 0x01, 0xA0, 0x00, 0x00, 0x06, 0x00, 0x00, 0x48, 0x10, 0x00,
  // "ŋ" (U+014B)
  0x3D, 0x6B, 0x00, 0xD0, 0xA1, 0x38, 0x0B, 0x05, 0x50, 0xB0, 0x82, 0x38, 0x00, 0x06, 0x40, 0x04,
  0x90, 0x00,
  // "Ō" (U+014C)
  0x01, 0x9F, 0xF3, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76, 0x00, 0x59, 0x84, 0x00, 0x85, 0x66,
  0x01, 0xB0, 0x09, 0x79, 0x10,
  // "ō" (U+014D)
  0x00, 0x88, 0x20, 0x77, 0x90, 0x48, 0x09, 0x28, 0x30, 0xA2, 0x93, 0x0B, 0x03, 0x98, 0x30,
  // "Ŏ" (U+014E)
  0x00, 0x04, 0x12, 0x01, 0x8F, 0xF1, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76, 0x00, 0x59, 0x84,
  0x00, 0x85, 0x66, 0x01, 0xB0, 0x09, 0x79, 0x10,
  // "ŏ" (U+014F)
  0x00, 0x41, 0x20, 0x07, 0xA0, 0x07, 0x79, 0x04, 0x80, 0x92, 0x83, 0x0A, 0x29, 0x30, 0xB0, 0x39,
  0x83, 0x00,
  // "Ő" (U+0150)
  0x00, 0x07, 0x68, 0x01, 0x98, 0xB1, 0x0B, 0x20, 0x57, 0x3A, 0x00, 0x3A, 0x76, 0x00, 0x59, 0x84,
  0x00, 0x85, 0x66, 0x01, 0xB0, 0x09, 0x79, 0x10,
  // "ő" (U+0151)
  0x00, 0x76, 0x80, 0x01, 0x10, 0x07, 0x79, 0x04, 0x80, 0x92, 0x83, 0x0A, 0x29, 0x30, 0xB0, 0x39,
  0x83, 0x00,
  // "Œ" (U+0152)
  0x01, 0x98, 0xD9, 0x8A, 0x0B, 0x20, 0xB1, 0x04, 0x3A, 0x00, 0xC0, 0x00, 0x76, 0x01, 0xD7, 0x40,
  0x84, 0x04, 0x80, 0x00, 0x66, 0x06, 0x50, 0x31, 0x09, 0x7C, 0x97, 0xC0,
  // "œ" (U+0153)
  0x06, 0x69, 0x77, 0x83, 0x80, 0x97, 0x49, 0x83, 0x0A, 0x86, 0x09, 0x30, 0xE2, 0x00, 0x39, 0x86,
  0xA8, 0x10,
  // "Ŕ" (U+0154)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x0A, 0xA7, 0x70, 0x75, 0x0C, 0x09, 0x22, 0xA0, 0xC7, 0x90, 0x0B,
  0x1B, 0x02, 0x90, 0xC0, 0x9C, 0x27, 0x70,
  // "ŕ" (U+0155)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x4C, 0x79, 0x0D, 0x11, 0x39, 0x00, 0x55, 0x00, 0x82, 0x00,
  // "Ŗ" (U+0156)
  0x0A, 0xA7, 0x70, 0x75, 0x0C, 0x09, 0x22, 0xA0, 0xC7, 0x90, 0x0B, 0x1B, 0x02, 0x90, 0xC0, 0x9C,
  0x27, 0x70, 0x05, 0x00, 0x03, 0x30, 0x00,
  // "ŗ" (U+0157)
  0x18, 0x24, 0xC7, 0x92, 0x84, 0xD1, 0x10, 0x39, 0x30, 0x05, 0x30, 0x80, 0x23, 0x05, 0x30, 0x03,
  0x30,
  // "Ř" (U+0158)
  0x00, 0x03, 0x12, 0x00, 0x07, 0xA0, 0x0A, 0xA7, 0x70, 0x07, 0x50, 0xC0, 0x09, 0x22, 0xA0, 0x0C,
  0x79, 0x00, 0x0B, 0x1B, 0x00, 0x29, 0x0C, 0x00, 0x9C, 0x27, 0x70,
  // "ř" (U+0159)
  0x28, 0x13, 0x12, 0x20, 0x70, 0xA6, 0x82, 0x4C, 0x79, 0x28, 0x4D, 0x11, 0x03, 0x93, 0x00, 0x53,
  0x08, 0x02, 0x30,
  // "Ś" (U+015A)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x06, 0x6A, 0x30, 0xB0, 0x32, 0x0D, 0x20, 0x00, 0x4E, 0x30, 0x00,
  0x3C, 0x09, 0x00, 0xB0, 0x77, 0x74, 0x00,
  // "ś" (U+015B)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x19, 0x84, 0x39, 0x01, 0x09, 0xA0, 0x40, 0xA2, 0x76, 0x80,
  // "Ŝ" (U+015C)
  0x00, 0x16, 0x00, 0x08, 0x81, 0x06, 0x6A, 0x30, 0xB0, 0x32, 0x0D, 0x20, 0x00, 0x4E, 0x30, 0x00,
  0x3C, 0x09, 0x00, 0xB0, 0x77, 0x74, 0x00,
  // "ŝ" (U+015D)
  0x01, 0x60, 0x08, 0x81, 0x00, 0x00, 0x19, 0x84, 0x39, 0x01, 0x09, 0xA0, 0x40, 0xA2, 0x76, 0x80,
  // "Ş" (U+015E)
  0x06, 0x6A, 0x30, 0xB0, 0x32, 0x0D, 0x20, 0x00, 0x4E, 0x30, 0x00, 0x3C, 0x09, 0x00, 0xB0, 0x7C,
  0x74, 0x00, 0xA1, 0x00, 0x57, 0x00, 0x00,
  // "ş" (U+015F)
  0x19, 0x84, 0x39, 0x01, 0x09, 0xA0, 0x40, 0xA2, 0x7C, 0x80, 0x0A, 0x10, 0x57, 0x00,
  // "Š" (U+0160)
  0x00, 0x31, 0x20, 0x07, 0xA0, 0x06, 0x6A, 0x30, 0xB0, 0x32, 0x0D, 0x20, 0x00, 0x4E, 0x30, 0x00,
  0x3C, 0x09, 0x00, 0xB0, 0x77, 0x74, 0x00,
  // "š" (U+0161)
  0x00, 0x31, 0x20, 0x07, 0xA0, 0x00, 0x00, 0x01, 0x98, 0x40, 0x39, 0x01, 0x00, 0x9A, 0x00, 0x40,
  0xA2, 0x07, 0x68, 0x00,
  // "Ţ" (U+0162)
  0x89, 0x22, 0xBA, 0xBA, 0x53, 0x17, 0x51, 0x22, 0x0A, 0x02, 0x40, 0xC5, 0x0C, 0x40, 0x20, 0x93,
  0x82, 0x1F, 0xB1, 0x30, 0xA0, 0x13, 0x05, 0x07, 0x40,
  // "ţ" (U+0163)
  0x08, 0x13, 0xD7, 0x0B, 0x03, 0x80, 0x55, 0x03, 0xF3, 0x0A, 0x15, 0x70,
  // "Ť" (U+0164)
  0x38, 0x13, 0x12, 0x38, 0x95, 0x7A, 0x02, 0xBA, 0xBA, 0x53, 0x17, 0x51, 0x22, 0x0A, 0x02, 0x40,
  0xC5, 0x0C, 0x40, 0x20, 0x93, 0x82, 0x1A, 0xB1, 0x20,
  // "ť" (U+0165)
  0x00, 0x18, 0x08, 0x30, 0x3D, 0x70, 0x0B, 0x00, 0x38, 0x00, 0x55, 0x00, 0x3A, 0x30,
  // "Ŧ" (U+0166)
  0x2B, 0xAB, 0xA5, 0x31, 0x75, 0x12, 0x00, 0xA2, 0x00, 0x17, 0xD7, 0x20, 0x00, 0xC0, 0x00, 0x02,
  0x90, 0x00, 0x1A, 0xB1, 0x00,
  // "ŧ" (U+0167)
  0x08, 0x13, 0xD7, 0x0B, 0x05, 0xB3, 0x56, 0x03, 0xA3,
  // "Ũ" (U+0168)
  0x00, 0x06, 0x85, 0x01, 0xBA, 0x4D, 0xF2, 0x09, 0x20, 0x25, 0x00, 0xC0, 0x04, 0x20, 0x0C, 0x00,
  0x70, 0x02, 0xA0, 0x07, 0x00, 0x39, 0x00, 0x70, 0x00, 0x98, 0x81, 0x00,
  // "ũ" (U+0169)
  0x00, 0x68, 0x50, 0x03, 0x85, 0x3D, 0x07, 0x50, 0xB0, 0x92, 0x38, 0x0C, 0x06, 0x53, 0xC0, 0x4B,
  0x4B, 0x30,
  // "Ū" (U+016A)
  0x1B, 0xA9, 0xDE, 0x20, 0x92, 0x02, 0x50, 0x0C, 0x00, 0x42, 0x00, 0xC0, 0x07, 0x00, 0x2A, 0x00,
  0x70, 0x03, 0x90, 0x07, 0x00, 0x09, 0x88, 0x10, 0x00,
  // "ū" (U+016B)
  0x00, 0x88, 0x23, 0xD0, 0x75, 0x0B, 0x09, 0x23, 0x80, 0xC0, 0x65, 0x3C, 0x04, 0xB4, 0xB3,
  // "Ŭ" (U+016C)
  0x00, 0x04, 0x12, 0x01, 0xBA, 0x8F, 0xC2, 0x09, 0x20, 0x25, 0x00, 0xC0, 0x04, 0x20, 0x0C, 0x00,
  0x70, 0x02, 0xA0, 0x07, 0x00, 0x39, 0x00, 0x70, 0x00, 0x98, 0x81, 0x00,
  // "ŭ" (U+016D)
  0x00, 0x41, 0x20, 0x07, 0xA0, 0x3D, 0x07, 0x50, 0xB0, 0x92, 0x38, 0x0C, 0x06, 0x53, 0xC0, 0x4B,
  0x4B, 0x30,
  // "Ů" (U+016E)
  0x00, 0x05, 0x60, 0x00, 0x00, 0x77, 0x00, 0x1B, 0xA6, 0xBB, 0x20, 0x92, 0x02, 0x50, 0x0C, 0x00,
  0x42, 0x00, 0xC0, 0x07, 0x00, 0x2A, 0x00, 0x70, 0x03, 0x90, 0x07, 0x00, 0x09, 0x88, 0x10, 0x00,
  // "ů" (U+016F)
  0x00, 0x56, 0x00, 0x07, 0x70, 0x00, 0x56, 0x03, 0xD0, 0x75, 0x0B, 0x09, 0x23, 0x80, 0xC0, 0x65,
  0x3C, 0x04, 0xB4, 0xB3,
  // "Ű" (U+0170)
  0x00, 0x07, 0x68, 0x01, 0xBA, 0x26, 0xB2, 0x09, 0x20, 0x25, 0x00, 0xC0, 0x04, 0x20, 0x0C, 0x00,
  0x70, 0x02, 0xA0, 0x07, 0x00, 0x39, 0x00, 0x70, 0x00, 0x98, 0x81, 0x00,
  // "ű" (U+0171)
  0x00, 0x76, 0x80, 0x01, 0x10, 0x3D, 0x07, 0x50, 0xB0, 0x92, 0x38, 0x0C, 0x06, 0x53, 0xC0, 0x4B,
  0x4B, 0x30,
  // "Ų" (U+0172)
  0x1B, 0xA1, 0x5B, 0x20, 0x92, 0x02, 0x50, 0x0C, 0x00, 0x42, 0x00, 0xC0, 0x07, 0x00, 0x2A, 0x00,
  0x70, 0x03, 0x90, 0x07, 0x00, 0x09, 0x98, 0x10, 0x00, 0x37, 0x00, 0x00, 0x01, 0x91, 0x00, 0x00,
  // "ų" (U+0173)
  0x3D, 0x07, 0x50, 0xB0, 0x92, 0x38, 0x0C, 0x06, 0x53, 0xC0, 0x4B, 0x4D, 0x40, 0x03, 0x70, 0x00,
  0x19, 0x10,
  // "Ŵ" (U+0174)
  0x40, 0x10, 0x67, 0x81, 0x88, 0x12, 0x89, 0x71, 0xD7, 0x07, 0x50, 0xA8, 0x0A, 0x20, 0xC6, 0x07,
  0x28, 0x59, 0x33, 0x97, 0x07, 0x28, 0x58, 0x47, 0x47, 0x61, 0x28, 0x47, 0x66, 0x38, 0x73, 0x84,
  0x6B, 0x12, 0xC4, 0x38, 0x34, 0x90, 0x1D, 0x30,
  // "ŵ" (U+0175)
  0x30, 0x10, 0x65, 0x81, 0x88, 0x17, 0x18, 0xB1, 0x59, 0x0B, 0x24, 0x41, 0x92, 0xC3, 0x43, 0x19,
  0x67, 0x36, 0x01, 0xA5, 0x67, 0x32, 0x82, 0xD0, 0x68, 0x20,
  // "Ŷ" (U+0176)
  0x20, 0x10, 0x64, 0x89, 0x58, 0x81, 0x02, 0xE5, 0x1C, 0x50, 0x93, 0x07, 0x28, 0x15, 0x76, 0x38,
  0x11, 0xC5, 0x40, 0xC4, 0x01, 0x0A, 0x38, 0x21, 0x9C, 0x12,
  // "ŷ" (U+0177)
  0x30, 0x10, 0x64, 0x81, 0x88, 0x17, 0x18, 0x2A, 0x50, 0xB2, 0x82, 0x39, 0x09, 0x38, 0x1C, 0x17,
  0x38, 0x1A, 0x81, 0x30, 0x60, 0x74, 0x09, 0x28, 0x21, 0x79, 0x12,
  // "Ÿ" (U+0178)
  0x00, 0x33, 0x70, 0x2E, 0x51, 0xC5, 0x09, 0x30, 0x70, 0x05, 0x76, 0x00, 0x01, 0xC5, 0x00, 0x00,
  0xC0, 0x00, 0x01, 0xA0, 0x00, 0x19, 0xC1, 0x00,
  // "Ź" (U+0179)
  0x00, 0x02, 0x30, 0x00, 0x80, 0x0B, 0x78, 0xD1, 0x20, 0xB4, 0x00, 0x69, 0x00, 0x1C, 0x00, 0x0A,
  0x40, 0x05, 0x90, 0x03, 0xE8, 0x7A, 0x30,
  // "ź" (U+017A)
  0x00, 0x23, 0x00, 0x80, 0x00, 0x00, 0x2A, 0xA9, 0x10, 0xB1, 0x08, 0x40, 0x39, 0x02, 0xC9, 0x94,
  // "Ż" (U+017B)
  0x00, 0x07, 0x00, 0xB7, 0x8D, 0x12, 0x0B, 0x40, 0x06, 0x90, 0x01, 0xC0, 0x00, 0xA4, 0x00, 0x59,
  0x00, 0x3E, 0x87, 0xA3,
  // "ż" (U+017C)
  0x00, 0x70, 0x00, 0x00, 0x2A, 0xA9, 0x10, 0xB1, 0x08, 0x40, 0x39, 0x02, 0xC9, 0x94,
  // "Ž" (U+017D)
  0x00, 0x31, 0x20, 0x07, 0xA0, 0x0B, 0x78, 0xD1, 0x20, 0xB4, 0x00, 0x69, 0x00, 0x1C, 0x00, 0x0A,
  0x40, 0x05, 0x90, 0x03, 0xE8, 0x7A, 0x30,
  // "ž" (U+017E)
  0x00, 0x31, 0x20, 0x07, 0xA0, 0x00, 0x00, 0x02, 0xAA, 0x90, 0x10, 0xB1, 0x00, 0x84, 0x00, 0x39,
  0x02, 0x0C, 0x99, 0x40,
  // "ſ" (U+017F)
  0x28, 0x13, 0x9A, 0x28, 0x19, 0x11, 0x20, 0xB4, 0x0B, 0x30, 0x30, 0x83, 0x06, 0x05, 0x30, 0x90,
  0x23, 0x0B, 0x30, 0x70, 0x53,
  // "Ω" (U+03A9)
  0x02, 0x87, 0x92, 0x0C, 0x00, 0x39, 0x49, 0x00, 0x2B, 0x58, 0x00, 0x58, 0x1B, 0x03, 0xB1, 0x43,
  0x78, 0x23, 0xEB, 0x7C, 0xD2,
  // "μ" (U+03BC)
  0x18, 0xA7, 0xB0, 0x65, 0x0B, 0x09, 0x23, 0x80, 0xB0, 0x66, 0x1B, 0x09, 0xB6, 0xB2, 0xA4, 0x0D,
  0x40,
  // "π" (U+03C0)
  0x4C, 0xCC, 0xC1, 0x27, 0x07, 0x00, 0x08, 0x08, 0x00, 0x18, 0x09, 0x00, 0xA3, 0x0B, 0x20,
  // "–" (U+2013)
  0x88, 0x88,
  // "—" (U+2014)
  0x80, 0x48,
  // "€" (U+20AC)
  0x00, 0x78, 0x80, 0x55, 0x04, 0x0A, 0x00, 0x04, 0xD6, 0x30, 0x6C, 0x60, 0x02, 0x90, 0x00, 0x09,
  0x75, 0x00,
  // "₿" (U+20BF)
  0x00, 0x04, 0x40, 0x01, 0xD8, 0xA0, 0x00, 0xB0, 0xB2, 0x00, 0xC0, 0xC0, 0x01, 0xDA, 0x50, 0x04,
  0x81, 0xB0, 0x07, 0x51, 0xB0, 0x2C, 0x88, 0x30, 0x00, 0x72, 0x00,
  // "‘" (U+2018)
  0x02, 0x10, 0x70, 0x1C, 0x00,
  // "’" (U+2019)
  0x0C, 0x08, 0x22,
  // "‚" (U+201A)
  0x0B, 0x10, 0x71, 0x12, 0x00,
  // "‛" (U+201B)
  0xB2, 0x70, 0x30,
  // "“" (U+201C)
  0x02, 0x14, 0x07, 0x53, 0x1C, 0x66,
  // "”" (U+201D)
  0x0C, 0x58, 0x08, 0x17, 0x22, 0x30,
  // "„" (U+201E)
  0x0B, 0x4A, 0x07, 0x18, 0x12, 0x30,
  // "‟" (U+201F)
  0xB2, 0xB2, 0x70, 0x70, 0x30, 0x30,
  // "†" (U+2020)
  0x20, 0xA3, 0x87, 0x70, 0x38, 0x97, 0x06, 0x62, 0x08, 0x02, 0x20, 0x83, 0x06, 0x30, 0x52,
  // "‡" (U+2021)
  0x00, 0xA0, 0x15, 0x94, 0x14, 0x83, 0x04, 0x30, 0x06, 0x00, 0x29, 0x20, 0x69, 0x70, 0x18, 0x00,
  // "•" (U+2022)
  0x29, 0x27, 0xF7, 0x4E, 0x40,
  // "…" (U+2026)
  0x10, 0x01, 0x01, 0x84, 0x48, 0x0C,
  // "‰" (U+2030)
  0x07, 0x90, 0x07, 0x00, 0x00, 0x36, 0x63, 0x71, 0x00, 0x00, 0x63, 0x74, 0x60, 0x00, 0x00, 0x63,
  0x98, 0x26, 0x40, 0x65, 0x16, 0x65, 0x90, 0xA8, 0x19, 0x00, 0x80, 0xA0, 0x99, 0x09, 0x05, 0x30,
  0x87, 0x27, 0x63,
  // "‹" (U+2039)
  0x01, 0x21, 0x90, 0x66, 0x00, 0x70,
  // "›" (U+203A)
  0x03, 0x00, 0xA0, 0x0B, 0x15, 0x20,
  // "⁄" (U+2044)
  0x30, 0x40, 0x33, 0x08, 0x30, 0x60, 0x12, 0x01, 0x07, 0x30, 0x73, 0x03, 0x05, 0x30, 0x84,
  // "™" (U+2122)
  0x3E, 0xEC, 0x63, 0xC1, 0x43, 0x5B, 0x87, 0x0A, 0x99, 0x99, 0xC0,
  // "⅒" (U+2152)
  0x40, 0x40, 0x35, 0x82, 0x48, 0x08, 0x68, 0x23, 0x86, 0x16, 0x8C, 0x45, 0x67, 0x48, 0x04, 0x71,
  0x17, 0xD0, 0x38, 0x28, 0x46, 0x03, 0x50, 0x55, 0x55, 0x73, 0x08, 0x01, 0x75, 0x17, 0x51,
  // "ﬁ" (U+FB01)
  0x00, 0x29, 0xB4, 0x00, 0x91, 0x10, 0x03, 0xD8, 0xC3, 0x00, 0xA0, 0xA0, 0x03, 0x80, 0xB0, 0x06,
  0x50, 0xA0, 0x09, 0x20, 0xB3, 0x0B, 0x00, 0x00, 0x76, 0x00, 0x00,
  // "ﬂ" (U+FB02)
  0x00, 0x29, 0xA8, 0x00, 0x91, 0x56, 0x03, 0xD7, 0x73, 0x00, 0xA0, 0xA0, 0x03, 0x80, 0xB0, 0x06,
  0x50, 0xA0, 0x09, 0x20, 0xB3, 0x0B, 0x00, 0x00, 0x76, 0x00, 0x00,
};

const Font& font_NotoSerif_Italic_8() {
  static SmoothFont font(font_NotoSerif_Italic_8_data);
  return font;
}

}  // namespace roo_display
