#include "90.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-CondensedItalic (Noto Serif Condensed Italic)
// Generated on Wed Nov 19 19:11:53 CET 2025
static const uint8_t font_NotoSerif_CondensedItalic_90_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x03, 0x01, 0x01, 0x57, 0x17, 0xFF,
  0xEC, 0xEB, 0x61, 0x57, 0x44, 0xEA, 0x13, 0x05, 0x64, 0x14, 0x18, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x05, 0x00, 0x1B, 0x40, 0x1B, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x0B, 0x2C, 0x24, 0x40, 0x20, 0x00, 0x00, 0xE2, // """ (U+0022)
  0x00, 0x23, 0x02, 0x01, 0x2C, 0x40, 0x2B, 0x00, 0x01, 0x63, // "#" (U+0023)
  0x00, 0x24, 0x02, 0xF9, 0x2B, 0x44, 0x2C, 0x00, 0x03, 0x2D, // "$" (U+0024)
  0x00, 0x25, 0x06, 0x00, 0x43, 0x41, 0x46, 0x00, 0x05, 0x66, // "%" (U+0025)
  0x00, 0x26, 0x03, 0x00, 0x3B, 0x41, 0x3A, 0x00, 0x08, 0x83, // "&" (U+0026)
  0x00, 0x27, 0x0B, 0x2C, 0x15, 0x40, 0x12, 0x00, 0x0B, 0x0C, // "'" (U+0027)
  0x00, 0x28, 0x03, 0xF5, 0x22, 0x45, 0x1B, 0x00, 0x0B, 0x4A, // "(" (U+0028)
  0x00, 0x29, 0xFC, 0xF5, 0x1A, 0x44, 0x1B, 0x00, 0x0C, 0xC7, // ")" (U+0029)
  0x00, 0x2A, 0x0A, 0x22, 0x2B, 0x45, 0x27, 0x00, 0x0E, 0x34, // "*" (U+002A)
  0x00, 0x2B, 0x05, 0x0E, 0x26, 0x34, 0x2A, 0x00, 0x0F, 0x48, // "+" (U+002B)
  0x00, 0x2C, 0xFD, 0xF3, 0x0C, 0x0B, 0x14, 0x00, 0x0F, 0xF8, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x16, 0x17, 0x1C, 0x18, 0x00, 0x10, 0x57, // "-" (U+002D)
  0x00, 0x2E, 0x02, 0x00, 0x0C, 0x0B, 0x14, 0x00, 0x10, 0x73, // "." (U+002E)
  0x00, 0x2F, 0xF8, 0xF6, 0x1F, 0x44, 0x16, 0x00, 0x10, 0x9B, // "/" (U+002F)
  0x00, 0x30, 0x04, 0x00, 0x2B, 0x41, 0x2C, 0x00, 0x12, 0x2F, // "0" (U+0030)
  0x00, 0x31, 0x03, 0x01, 0x23, 0x40, 0x2C, 0x00, 0x14, 0x07, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x2A, 0x41, 0x2C, 0x00, 0x15, 0x4B, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x00, 0x2A, 0x41, 0x2C, 0x00, 0x16, 0xFC, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x29, 0x40, 0x2C, 0x00, 0x18, 0xD5, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x00, 0x2B, 0x40, 0x2C, 0x00, 0x1A, 0x7D, // "5" (U+0035)
  0x00, 0x36, 0x05, 0x00, 0x2D, 0x41, 0x2C, 0x00, 0x1C, 0x26, // "6" (U+0036)
  0x00, 0x37, 0x06, 0x01, 0x2F, 0x40, 0x2C, 0x00, 0x1E, 0x09, // "7" (U+0037)
  0x00, 0x38, 0x01, 0x00, 0x2B, 0x41, 0x2C, 0x00, 0x1F, 0x6D, // "8" (U+0038)
  0x00, 0x39, 0x03, 0x00, 0x2A, 0x41, 0x2C, 0x00, 0x21, 0x74, // "9" (U+0039)
  0x00, 0x3A, 0x02, 0x00, 0x15, 0x30, 0x17, 0x00, 0x23, 0x56, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xF3, 0x15, 0x30, 0x17, 0x00, 0x23, 0xC2, // ";" (U+003B)
  0x00, 0x3C, 0x05, 0x0B, 0x26, 0x37, 0x2A, 0x00, 0x24, 0x63, // "<" (U+003C)
  0x00, 0x3D, 0x05, 0x16, 0x26, 0x2B, 0x2A, 0x00, 0x25, 0x6F, // "=" (U+003D)
  0x00, 0x3E, 0x05, 0x0B, 0x26, 0x37, 0x2A, 0x00, 0x25, 0x9F, // ">" (U+003E)
  0x00, 0x3F, 0x0A, 0x00, 0x2A, 0x41, 0x27, 0x00, 0x26, 0xA6, // "?" (U+003F)
  0x00, 0x40, 0x05, 0xF4, 0x44, 0x40, 0x47, 0x00, 0x27, 0xFB, // "@" (U+0040)
  0x00, 0x41, 0xFB, 0x01, 0x33, 0x40, 0x37, 0x00, 0x2B, 0x8E, // "A" (U+0041)
  0x00, 0x42, 0xFE, 0x01, 0x32, 0x40, 0x33, 0x00, 0x2D, 0x8B, // "B" (U+0042)
  0x00, 0x43, 0x04, 0x00, 0x34, 0x41, 0x31, 0x00, 0x2F, 0xB3, // "C" (U+0043)
  0x00, 0x44, 0xFE, 0x01, 0x37, 0x40, 0x39, 0x00, 0x31, 0x82, // "D" (U+0044)
  0x00, 0x45, 0xFE, 0x01, 0x33, 0x40, 0x31, 0x00, 0x33, 0xCC, // "E" (U+0045)
  0x00, 0x46, 0xFE, 0x01, 0x33, 0x40, 0x2E, 0x00, 0x35, 0x76, // "F" (U+0046)
  0x00, 0x47, 0x04, 0x00, 0x37, 0x41, 0x38, 0x00, 0x36, 0xFC, // "G" (U+0047)
  0x00, 0x48, 0xFE, 0x01, 0x43, 0x40, 0x3E, 0x00, 0x39, 0x0D, // "H" (U+0048)
  0x00, 0x49, 0xFE, 0x01, 0x23, 0x40, 0x1D, 0x00, 0x3B, 0x6E, // "I" (U+0049)
  0x00, 0x4A, 0xF3, 0xEB, 0x22, 0x40, 0x1C, 0x00, 0x3C, 0xAE, // "J" (U+004A)
  0x00, 0x4B, 0xFE, 0x01, 0x3D, 0x40, 0x37, 0x00, 0x3E, 0x89, // "K" (U+004B)
  0x00, 0x4C, 0xFE, 0x01, 0x2C, 0x40, 0x31, 0x00, 0x40, 0xDF, // "L" (U+004C)
  0x00, 0x4D, 0xFE, 0x01, 0x4E, 0x40, 0x49, 0x00, 0x42, 0x62, // "M" (U+004D)
  0x00, 0x4E, 0xFE, 0x01, 0x42, 0x40, 0x3B, 0x00, 0x45, 0xC1, // "N" (U+004E)
  0x00, 0x4F, 0x04, 0x00, 0x38, 0x41, 0x3A, 0x00, 0x48, 0x62, // "O" (U+004F)
  0x00, 0x50, 0xFE, 0x01, 0x31, 0x40, 0x31, 0x00, 0x4A, 0xAF, // "P" (U+0050)
  0x00, 0x51, 0x04, 0xED, 0x38, 0x41, 0x3A, 0x00, 0x4C, 0x87, // "Q" (U+0051)
  0x00, 0x52, 0xFE, 0x01, 0x32, 0x40, 0x34, 0x00, 0x4F, 0x46, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x00, 0x2D, 0x41, 0x2B, 0x00, 0x51, 0x6E, // "S" (U+0053)
  0x00, 0x54, 0x07, 0x01, 0x37, 0x40, 0x30, 0x00, 0x53, 0x4B, // "T" (U+0054)
  0x00, 0x55, 0x07, 0x00, 0x3F, 0x40, 0x39, 0x00, 0x54, 0xE7, // "U" (U+0055)
  0x00, 0x56, 0x08, 0x01, 0x3D, 0x40, 0x35, 0x00, 0x57, 0x25, // "V" (U+0056)
  0x00, 0x57, 0x08, 0x01, 0x59, 0x40, 0x51, 0x00, 0x59, 0x1F, // "W" (U+0057)
  0x00, 0x58, 0xFC, 0x01, 0x3A, 0x40, 0x34, 0x00, 0x5C, 0x7C, // "X" (U+0058)
  0x00, 0x59, 0x07, 0x01, 0x3A, 0x40, 0x31, 0x00, 0x5E, 0xAC, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x33, 0x40, 0x30, 0x00, 0x60, 0x76, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xF5, 0x23, 0x44, 0x1D, 0x00, 0x62, 0x3B, // "[" (U+005B)
  0x00, 0x5C, 0x09, 0xF6, 0x11, 0x44, 0x16, 0x00, 0x63, 0xB1, // "\" (U+005C)
  0x00, 0x5D, 0xFC, 0xF5, 0x1E, 0x44, 0x1D, 0x00, 0x64, 0x8D, // "]" (U+005D)
  0x00, 0x5E, 0x04, 0x19, 0x27, 0x40, 0x2A, 0x00, 0x66, 0x02, // "^" (U+005E)
  0x00, 0x5F, 0xF8, 0xF4, 0x1D, 0xF8, 0x24, 0x00, 0x67, 0x0E, // "_" (U+005F)
  0x00, 0x60, 0x0D, 0x37, 0x1A, 0x45, 0x17, 0x00, 0x67, 0x27, // "`" (U+0060)
  0x00, 0x61, 0x03, 0x00, 0x2C, 0x31, 0x2E, 0x00, 0x67, 0x5B, // "a" (U+0061)
  0x00, 0x62, 0x02, 0x00, 0x2A, 0x44, 0x2C, 0x00, 0x69, 0x03, // "b" (U+0062)
  0x00, 0x63, 0x03, 0x00, 0x27, 0x31, 0x26, 0x00, 0x6A, 0xF5, // "c" (U+0063)
  0x00, 0x64, 0x03, 0x00, 0x2F, 0x44, 0x2E, 0x00, 0x6C, 0x2F, // "d" (U+0064)
  0x00, 0x65, 0x03, 0x00, 0x26, 0x31, 0x27, 0x00, 0x6E, 0x3E, // "e" (U+0065)
  0x00, 0x66, 0xF4, 0xEB, 0x28, 0x45, 0x1A, 0x00, 0x6F, 0x9B, // "f" (U+0066)
  0x00, 0x67, 0xFC, 0xEB, 0x2F, 0x34, 0x2B, 0x00, 0x71, 0xA6, // "g" (U+0067)
  0x00, 0x68, 0x03, 0x00, 0x2E, 0x44, 0x30, 0x00, 0x74, 0x0B, // "h" (U+0068)
  0x00, 0x69, 0x05, 0x00, 0x18, 0x44, 0x18, 0x00, 0x75, 0xF9, // "i" (U+0069)
  0x00, 0x6A, 0xF4, 0xEB, 0x18, 0x44, 0x17, 0x00, 0x76, 0xDD, // "j" (U+006A)
  0x00, 0x6B, 0x03, 0x00, 0x30, 0x44, 0x2D, 0x00, 0x78, 0x5D, // "k" (U+006B)
  0x00, 0x6C, 0x05, 0x00, 0x19, 0x44, 0x18, 0x00, 0x7A, 0x4E, // "l" (U+006C)
  0x00, 0x6D, 0x03, 0x00, 0x44, 0x31, 0x46, 0x00, 0x7B, 0x4F, // "m" (U+006D)
  0x00, 0x6E, 0x03, 0x00, 0x2D, 0x31, 0x30, 0x00, 0x7D, 0xAC, // "n" (U+006E)
  0x00, 0x6F, 0x03, 0x00, 0x2A, 0x31, 0x2D, 0x00, 0x7F, 0x3A, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xEB, 0x2B, 0x31, 0x2E, 0x00, 0x80, 0xB8, // "p" (U+0070)
  0x00, 0x71, 0x03, 0xEB, 0x2B, 0x31, 0x2C, 0x00, 0x82, 0xC2, // "q" (U+0071)
  0x00, 0x72, 0x03, 0x01, 0x27, 0x31, 0x25, 0x00, 0x84, 0xC0, // "r" (U+0072)
  0x00, 0x73, 0x02, 0x00, 0x23, 0x31, 0x25, 0x00, 0x85, 0xDE, // "s" (U+0073)
  0x00, 0x74, 0x05, 0x00, 0x1E, 0x3B, 0x1D, 0x00, 0x87, 0x19, // "t" (U+0074)
  0x00, 0x75, 0x05, 0x00, 0x2E, 0x30, 0x2F, 0x00, 0x88, 0x21, // "u" (U+0075)
  0x00, 0x76, 0x02, 0xFF, 0x28, 0x31, 0x2A, 0x00, 0x89, 0xB0, // "v" (U+0076)
  0x00, 0x77, 0x04, 0xFF, 0x3F, 0x31, 0x40, 0x00, 0x8B, 0x12, // "w" (U+0077)
  0x00, 0x78, 0xFE, 0x01, 0x2D, 0x30, 0x2B, 0x00, 0x8D, 0x7B, // "x" (U+0078)
  0x00, 0x79, 0xF3, 0xEB, 0x28, 0x31, 0x2A, 0x00, 0x8E, 0xEF, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x26, 0x30, 0x28, 0x00, 0x90, 0xFC, // "z" (U+007A)
  0x00, 0x7B, 0x05, 0xF5, 0x28, 0x44, 0x21, 0x00, 0x92, 0x2F, // "{" (U+007B)
  0x00, 0x7C, 0x13, 0xEB, 0x18, 0x44, 0x2B, 0x00, 0x93, 0xBB, // "|" (U+007C)
  0x00, 0x7D, 0xFB, 0xF4, 0x1E, 0x44, 0x21, 0x00, 0x94, 0x9C, // "}" (U+007D)
  0x00, 0x7E, 0x04, 0x19, 0x27, 0x28, 0x2A, 0x00, 0x96, 0x30, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xF1, 0x16, 0x31, 0x1B, 0x00, 0x96, 0xC2, // "¡" (U+00A1)
  0x00, 0xA2, 0x07, 0x01, 0x2B, 0x40, 0x2C, 0x00, 0x97, 0xAC, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x00, 0x2D, 0x41, 0x2C, 0x00, 0x99, 0x80, // "£" (U+00A3)
  0x00, 0xA4, 0x07, 0x0F, 0x2E, 0x34, 0x32, 0x00, 0x9B, 0x3B, // "¤" (U+00A4)
  0x00, 0xA5, 0x05, 0x01, 0x34, 0x40, 0x2C, 0x00, 0x9C, 0x8A, // "¥" (U+00A5)
  0x00, 0xA6, 0x13, 0xEB, 0x18, 0x44, 0x2B, 0x00, 0x9E, 0x48, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0xF6, 0x2A, 0x44, 0x2A, 0x00, 0x9E, 0xFF, // "§" (U+00A7)
  0x00, 0xA8, 0x11, 0x3A, 0x28, 0x43, 0x2D, 0x00, 0xA1, 0x39, // "¨" (U+00A8)
  0x00, 0xA9, 0x04, 0x00, 0x3C, 0x41, 0x41, 0x00, 0xA1, 0x7B, // "©" (U+00A9)
  0x00, 0xAA, 0x06, 0x23, 0x22, 0x40, 0x1F, 0x00, 0xA4, 0x82, // "ª" (U+00AA)
  0x00, 0xAB, 0x05, 0x08, 0x27, 0x29, 0x28, 0x00, 0xA5, 0x64, // "«" (U+00AB)
  0x00, 0xAC, 0x05, 0x0C, 0x26, 0x23, 0x2A, 0x00, 0xA6, 0x64, // "¬" (U+00AC)
  0x00, 0xAE, 0x04, 0x00, 0x3C, 0x41, 0x41, 0x00, 0xA6, 0xD2, // "®" (U+00AE)
  0x00, 0xAF, 0x09, 0x45, 0x2F, 0x49, 0x24, 0x00, 0xA9, 0xE6, // "¯" (U+00AF)
  0x00, 0xB0, 0x0B, 0x28, 0x22, 0x42, 0x1F, 0x00, 0xAA, 0x00, // "°" (U+00B0)
  0x00, 0xB1, 0x06, 0x01, 0x27, 0x34, 0x2A, 0x00, 0xAA, 0xAF, // "±" (U+00B1)
  0x00, 0xB2, 0x05, 0x24, 0x21, 0x4B, 0x1F, 0x00, 0xAB, 0x77, // "²" (U+00B2)
  0x00, 0xB3, 0x06, 0x23, 0x23, 0x4A, 0x1F, 0x00, 0xAC, 0x5C, // "³" (U+00B3)
  0x00, 0xB4, 0x0A, 0x37, 0x1C, 0x45, 0x16, 0x00, 0xAD, 0x57, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xEB, 0x2D, 0x30, 0x30, 0x00, 0xAD, 0x94, // "µ" (U+00B5)
  0x00, 0xB6, 0x05, 0xF7, 0x35, 0x44, 0x38, 0x00, 0xAF, 0x98, // "¶" (U+00B6)
  0x00, 0xB7, 0x07, 0x1B, 0x12, 0x26, 0x16, 0x00, 0xB1, 0xCE, // "·" (U+00B7)
  0x00, 0xB8, 0x02, 0xEB, 0x14, 0x01, 0x1A, 0x00, 0xB1, 0xFB, // "¸" (U+00B8)
  0x00, 0xB9, 0x07, 0x24, 0x1D, 0x4A, 0x1F, 0x00, 0xB2, 0x5E, // "¹" (U+00B9)
  0x00, 0xBA, 0x07, 0x23, 0x22, 0x40, 0x20, 0x00, 0xB3, 0x07, // "º" (U+00BA)
  0x00, 0xBB, 0x02, 0x08, 0x24, 0x29, 0x28, 0x00, 0xB3, 0xCE, // "»" (U+00BB)
  0x00, 0xBC, 0x07, 0x01, 0x42, 0x41, 0x45, 0x00, 0xB4, 0xBB, // "¼" (U+00BC)
  0x00, 0xBD, 0x07, 0x01, 0x41, 0x41, 0x45, 0x00, 0xB7, 0x61, // "½" (U+00BD)
  0x00, 0xBE, 0x05, 0x01, 0x42, 0x41, 0x45, 0x00, 0xBA, 0x0E, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xF0, 0x1F, 0x31, 0x27, 0x00, 0xBC, 0xFC, // "¿" (U+00BF)
  0x00, 0xC0, 0xFB, 0x01, 0x33, 0x54, 0x37, 0x00, 0xBE, 0x4B, // "À" (U+00C0)
  0x00, 0xC1, 0xFB, 0x01, 0x34, 0x54, 0x37, 0x00, 0xC0, 0x99, // "Á" (U+00C1)
  0x00, 0xC2, 0xFB, 0x01, 0x33, 0x54, 0x37, 0x00, 0xC2, 0xEB, // "Â" (U+00C2)
  0x00, 0xC3, 0xFB, 0x01, 0x35, 0x50, 0x37, 0x00, 0xC5, 0x5B, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFB, 0x01, 0x33, 0x52, 0x37, 0x00, 0xC7, 0xCE, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFB, 0x01, 0x33, 0x4F, 0x37, 0x00, 0xCA, 0x22, // "Å" (U+00C5)
  0x00, 0xC6, 0xFB, 0x01, 0x4C, 0x40, 0x4A, 0x00, 0xCC, 0x9A, // "Æ" (U+00C6)
  0x00, 0xC7, 0x04, 0xEB, 0x34, 0x41, 0x31, 0x00, 0xCF, 0x3F, // "Ç" (U+00C7)
  0x00, 0xC8, 0xFE, 0x01, 0x33, 0x54, 0x31, 0x00, 0xD1, 0x8A, // "È" (U+00C8)
  0x00, 0xC9, 0xFE, 0x01, 0x33, 0x54, 0x31, 0x00, 0xD3, 0x85, // "É" (U+00C9)
  0x00, 0xCA, 0xFE, 0x01, 0x33, 0x54, 0x31, 0x00, 0xD5, 0x83, // "Ê" (U+00CA)
  0x00, 0xCB, 0xFE, 0x01, 0x33, 0x52, 0x31, 0x00, 0xD7, 0xA1, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFE, 0x01, 0x23, 0x54, 0x1D, 0x00, 0xD9, 0xA3, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFE, 0x01, 0x26, 0x54, 0x1D, 0x00, 0xDB, 0x34, // "Í" (U+00CD)
  0x00, 0xCE, 0xFE, 0x01, 0x23, 0x54, 0x1D, 0x00, 0xDC, 0xDF, // "Î" (U+00CE)
  0x00, 0xCF, 0xFE, 0x01, 0x25, 0x52, 0x1D, 0x00, 0xDE, 0x88, // "Ï" (U+00CF)
  0x00, 0xD0, 0xFE, 0x01, 0x37, 0x40, 0x39, 0x00, 0xE0, 0x2D, // "Ð" (U+00D0)
  0x00, 0xD1, 0xFE, 0x01, 0x42, 0x50, 0x3B, 0x00, 0xE2, 0x7A, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x04, 0x00, 0x38, 0x54, 0x3A, 0x00, 0xE5, 0x8F, // "Ò" (U+00D2)
  0x00, 0xD3, 0x04, 0x00, 0x38, 0x54, 0x3A, 0x00, 0xE8, 0x2D, // "Ó" (U+00D3)
  0x00, 0xD4, 0x04, 0x00, 0x38, 0x54, 0x3A, 0x00, 0xEA, 0xCD, // "Ô" (U+00D4)
  0x00, 0xD5, 0x04, 0x00, 0x38, 0x50, 0x3A, 0x00, 0xED, 0x8E, // "Õ" (U+00D5)
  0x00, 0xD6, 0x04, 0x00, 0x38, 0x52, 0x3A, 0x00, 0xF0, 0x49, // "Ö" (U+00D6)
  0x00, 0xD7, 0x05, 0x0E, 0x26, 0x33, 0x2A, 0x00, 0xF2, 0xED, // "×" (U+00D7)
  0x00, 0xD8, 0x04, 0xFD, 0x38, 0x44, 0x3A, 0x00, 0xF4, 0x02, // "Ø" (U+00D8)
  0x00, 0xD9, 0x07, 0x00, 0x3F, 0x54, 0x39, 0x00, 0xF6, 0xE3, // "Ù" (U+00D9)
  0x00, 0xDA, 0x07, 0x00, 0x3F, 0x54, 0x39, 0x00, 0xF9, 0x73, // "Ú" (U+00DA)
  0x00, 0xDB, 0x07, 0x00, 0x3F, 0x54, 0x39, 0x00, 0xFC, 0x06, // "Û" (U+00DB)
  0x00, 0xDC, 0x07, 0x00, 0x3F, 0x52, 0x39, 0x00, 0xFE, 0xB9, // "Ü" (U+00DC)
  0x00, 0xDD, 0x07, 0x01, 0x3A, 0x54, 0x31, 0x01, 0x01, 0x50, // "Ý" (U+00DD)
  0x00, 0xDE, 0xFE, 0x01, 0x2F, 0x40, 0x2F, 0x01, 0x03, 0x6F, // "Þ" (U+00DE)
  0x00, 0xDF, 0xF4, 0xEB, 0x30, 0x44, 0x31, 0x01, 0x05, 0x4B, // "ß" (U+00DF)
  0x00, 0xE0, 0x03, 0x00, 0x2C, 0x45, 0x2E, 0x01, 0x08, 0x4B, // "à" (U+00E0)
  0x00, 0xE1, 0x03, 0x00, 0x2C, 0x45, 0x2E, 0x01, 0x0A, 0x43, // "á" (U+00E1)
  0x00, 0xE2, 0x03, 0x00, 0x2C, 0x45, 0x2E, 0x01, 0x0C, 0x3E, // "â" (U+00E2)
  0x00, 0xE3, 0x03, 0x00, 0x2C, 0x41, 0x2E, 0x01, 0x0E, 0x52, // "ã" (U+00E3)
  0x00, 0xE4, 0x03, 0x00, 0x2C, 0x43, 0x2E, 0x01, 0x10, 0x61, // "ä" (U+00E4)
  0x00, 0xE5, 0x03, 0x00, 0x2C, 0x48, 0x2E, 0x01, 0x12, 0x57, // "å" (U+00E5)
  0x00, 0xE6, 0x03, 0x00, 0x3F, 0x31, 0x40, 0x01, 0x14, 0x86, // "æ" (U+00E6)
  0x00, 0xE7, 0x03, 0xEB, 0x27, 0x31, 0x26, 0x01, 0x16, 0xD7, // "ç" (U+00E7)
  0x00, 0xE8, 0x03, 0x00, 0x26, 0x45, 0x27, 0x01, 0x18, 0x85, // "è" (U+00E8)
  0x00, 0xE9, 0x03, 0x00, 0x2B, 0x45, 0x27, 0x01, 0x1A, 0x2F, // "é" (U+00E9)
  0x00, 0xEA, 0x03, 0x00, 0x27, 0x45, 0x27, 0x01, 0x1B, 0xF2, // "ê" (U+00EA)
  0x00, 0xEB, 0x03, 0x00, 0x28, 0x43, 0x27, 0x01, 0x1D, 0xBA, // "ë" (U+00EB)
  0x00, 0xEC, 0x05, 0x00, 0x16, 0x45, 0x18, 0x01, 0x1F, 0x6C, // "ì" (U+00EC)
  0x00, 0xED, 0x05, 0x00, 0x20, 0x45, 0x18, 0x01, 0x20, 0x5F, // "í" (U+00ED)
  0x00, 0xEE, 0x04, 0x00, 0x1B, 0x45, 0x18, 0x01, 0x21, 0x77, // "î" (U+00EE)
  0x00, 0xEF, 0x05, 0x00, 0x1D, 0x43, 0x18, 0x01, 0x22, 0x9B, // "ï" (U+00EF)
  0x00, 0xF0, 0x03, 0x00, 0x2B, 0x45, 0x2D, 0x01, 0x23, 0xB1, // "ð" (U+00F0)
  0x00, 0xF1, 0x03, 0x00, 0x2D, 0x41, 0x30, 0x01, 0x25, 0xC8, // "ñ" (U+00F1)
  0x00, 0xF2, 0x03, 0x00, 0x2A, 0x45, 0x2D, 0x01, 0x27, 0xBE, // "ò" (U+00F2)
  0x00, 0xF3, 0x03, 0x00, 0x2B, 0x45, 0x2D, 0x01, 0x29, 0x8D, // "ó" (U+00F3)
  0x00, 0xF4, 0x03, 0x00, 0x2A, 0x45, 0x2D, 0x01, 0x2B, 0x61, // "ô" (U+00F4)
  0x00, 0xF5, 0x03, 0x00, 0x2C, 0x41, 0x2D, 0x01, 0x2D, 0x4A, // "õ" (U+00F5)
  0x00, 0xF6, 0x03, 0x00, 0x2A, 0x43, 0x2D, 0x01, 0x2F, 0x33, // "ö" (U+00F6)
  0x00, 0xF7, 0x05, 0x0B, 0x26, 0x36, 0x2A, 0x01, 0x30, 0xFF, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0xFC, 0x2D, 0x35, 0x2D, 0x01, 0x31, 0x7A, // "ø" (U+00F8)
  0x00, 0xF9, 0x05, 0x00, 0x2E, 0x45, 0x2F, 0x01, 0x33, 0x85, // "ù" (U+00F9)
  0x00, 0xFA, 0x05, 0x00, 0x2E, 0x45, 0x2F, 0x01, 0x35, 0x65, // "ú" (U+00FA)
  0x00, 0xFB, 0x05, 0x00, 0x2E, 0x45, 0x2F, 0x01, 0x37, 0x49, // "û" (U+00FB)
  0x00, 0xFC, 0x05, 0x00, 0x2E, 0x43, 0x2F, 0x01, 0x39, 0x46, // "ü" (U+00FC)
  0x00, 0xFD, 0xF3, 0xEB, 0x28, 0x45, 0x2A, 0x01, 0x3B, 0x24, // "ý" (U+00FD)
  0x00, 0xFE, 0xFD, 0xEB, 0x29, 0x44, 0x2C, 0x01, 0x3D, 0x83, // "þ" (U+00FE)
  0x00, 0xFF, 0xF3, 0xEB, 0x28, 0x43, 0x2A, 0x01, 0x3F, 0xF1, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFB, 0x01, 0x33, 0x4A, 0x37, 0x01, 0x42, 0x54, // "Ā" (U+0100)
  0x01, 0x01, 0x03, 0x00, 0x2C, 0x3B, 0x2E, 0x01, 0x44, 0x70, // "ā" (U+0101)
  0x01, 0x02, 0xFB, 0x01, 0x33, 0x51, 0x37, 0x01, 0x46, 0x32, // "Ă" (U+0102)
  0x01, 0x03, 0x03, 0x00, 0x2C, 0x42, 0x2E, 0x01, 0x48, 0x8D, // "ă" (U+0103)
  0x01, 0x04, 0xFB, 0xEB, 0x33, 0x40, 0x37, 0x01, 0x4A, 0x8B, // "Ą" (U+0104)
  0x01, 0x05, 0x03, 0xEB, 0x2C, 0x31, 0x2E, 0x01, 0x4D, 0x07, // "ą" (U+0105)
  0x01, 0x06, 0x04, 0x00, 0x36, 0x54, 0x31, 0x01, 0x4F, 0x25, // "Ć" (U+0106)
  0x01, 0x07, 0x03, 0x00, 0x2B, 0x45, 0x26, 0x01, 0x51, 0x4C, // "ć" (U+0107)
  0x01, 0x08, 0x04, 0x00, 0x34, 0x54, 0x31, 0x01, 0x52, 0xEC, // "Ĉ" (U+0108)
  0x01, 0x09, 0x03, 0x00, 0x28, 0x45, 0x26, 0x01, 0x55, 0x2D, // "ĉ" (U+0109)
  0x01, 0x0A, 0x04, 0x00, 0x34, 0x53, 0x31, 0x01, 0x56, 0xD7, // "Ċ" (U+010A)
  0x01, 0x0B, 0x03, 0x00, 0x27, 0x44, 0x26, 0x01, 0x58, 0xE0, // "ċ" (U+010B)
  0x01, 0x0C, 0x04, 0x00, 0x37, 0x54, 0x31, 0x01, 0x5A, 0x50, // "Č" (U+010C)
  0x01, 0x0D, 0x03, 0x00, 0x2D, 0x45, 0x26, 0x01, 0x5C, 0x9D, // "č" (U+010D)
  0x01, 0x0E, 0xFE, 0x01, 0x37, 0x54, 0x39, 0x01, 0x5E, 0x5E, // "Ď" (U+010E)
  0x01, 0x0F, 0x03, 0x00, 0x3D, 0x44, 0x2E, 0x01, 0x61, 0x20, // "ď" (U+010F)
  0x01, 0x10, 0xFE, 0x01, 0x37, 0x40, 0x39, 0x01, 0x63, 0x91, // "Đ" (U+0110)
  0x01, 0x11, 0x03, 0x00, 0x34, 0x44, 0x2E, 0x01, 0x65, 0xDE, // "đ" (U+0111)
  0x01, 0x12, 0xFE, 0x01, 0x33, 0x4A, 0x31, 0x01, 0x68, 0x00, // "Ē" (U+0112)
  0x01, 0x13, 0x03, 0x00, 0x28, 0x3B, 0x27, 0x01, 0x69, 0xC9, // "ē" (U+0113)
  0x01, 0x14, 0xFE, 0x01, 0x33, 0x51, 0x31, 0x01, 0x6B, 0x48, // "Ĕ" (U+0114)
  0x01, 0x15, 0x03, 0x00, 0x28, 0x42, 0x27, 0x01, 0x6D, 0x51, // "ĕ" (U+0115)
  0x01, 0x16, 0xFE, 0x01, 0x33, 0x52, 0x31, 0x01, 0x6F, 0x0B, // "Ė" (U+0116)
  0x01, 0x17, 0x03, 0x00, 0x26, 0x44, 0x27, 0x01, 0x70, 0xEF, // "ė" (U+0117)
  0x01, 0x18, 0xFE, 0xEB, 0x33, 0x40, 0x31, 0x01, 0x72, 0x81, // "Ę" (U+0118)
  0x01, 0x19, 0x03, 0xEC, 0x26, 0x31, 0x27, 0x01, 0x74, 0xAA, // "ę" (U+0119)
  0x01, 0x1A, 0xFE, 0x01, 0x33, 0x54, 0x31, 0x01, 0x76, 0x6C, // "Ě" (U+011A)
  0x01, 0x1B, 0x03, 0x00, 0x2D, 0x45, 0x27, 0x01, 0x78, 0x8D, // "ě" (U+011B)
  0x01, 0x1C, 0x04, 0x00, 0x37, 0x54, 0x38, 0x01, 0x7A, 0x73, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFC, 0xEB, 0x2F, 0x45, 0x2B, 0x01, 0x7C, 0xF6, // "ĝ" (U+011D)
  0x01, 0x1E, 0x04, 0x00, 0x37, 0x51, 0x38, 0x01, 0x7F, 0xCD, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFC, 0xEB, 0x2F, 0x42, 0x2B, 0x01, 0x82, 0x3C, // "ğ" (U+011F)
  0x01, 0x20, 0x04, 0x00, 0x37, 0x53, 0x38, 0x01, 0x84, 0xFE, // "Ġ" (U+0120)
  0x01, 0x21, 0xFC, 0xEB, 0x2F, 0x44, 0x2B, 0x01, 0x87, 0x48, // "ġ" (U+0121)
  0x01, 0x22, 0x04, 0xED, 0x37, 0x41, 0x38, 0x01, 0x89, 0xE6, // "Ģ" (U+0122)
  0x01, 0x23, 0xFC, 0xEB, 0x2F, 0x44, 0x2B, 0x01, 0x8C, 0x46, // "ģ" (U+0123)
  0x01, 0x24, 0xFE, 0x01, 0x43, 0x54, 0x3E, 0x01, 0x8E, 0xF8, // "Ĥ" (U+0124)
  0x01, 0x25, 0x03, 0x00, 0x2E, 0x56, 0x30, 0x01, 0x91, 0xCD, // "ĥ" (U+0125)
  0x01, 0x26, 0xFE, 0x01, 0x43, 0x40, 0x3E, 0x01, 0x94, 0x2B, // "Ħ" (U+0126)
  0x01, 0x27, 0x03, 0x00, 0x2D, 0x44, 0x2F, 0x01, 0x96, 0x7F, // "ħ" (U+0127)
  0x01, 0x28, 0xFE, 0x01, 0x27, 0x50, 0x1D, 0x01, 0x98, 0x71, // "Ĩ" (U+0128)
  0x01, 0x29, 0x03, 0x00, 0x20, 0x41, 0x18, 0x01, 0x9A, 0x30, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFE, 0x01, 0x24, 0x4A, 0x1D, 0x01, 0x9B, 0x62, // "Ī" (U+012A)
  0x01, 0x2B, 0x05, 0x00, 0x1D, 0x3B, 0x18, 0x01, 0x9C, 0xD1, // "ī" (U+012B)
  0x01, 0x2C, 0xFE, 0x01, 0x24, 0x51, 0x1D, 0x01, 0x9D, 0xB8, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x05, 0x00, 0x1D, 0x42, 0x18, 0x01, 0x9F, 0x61, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFE, 0xEB, 0x23, 0x40, 0x1D, 0x01, 0xA0, 0x7B, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xEB, 0x18, 0x44, 0x18, 0x01, 0xA2, 0x38, // "į" (U+012F)
  0x01, 0x30, 0xFE, 0x01, 0x23, 0x53, 0x1D, 0x01, 0xA3, 0x97, // "İ" (U+0130)
  0x01, 0x31, 0x05, 0x00, 0x16, 0x30, 0x18, 0x01, 0xA5, 0x0E, // "ı" (U+0131)
  0x01, 0x32, 0xFE, 0xEB, 0x3F, 0x40, 0x39, 0x01, 0xA5, 0xC6, // "Ĳ" (U+0132)
  0x01, 0x33, 0x05, 0xEB, 0x30, 0x44, 0x2F, 0x01, 0xA8, 0x96, // "ĳ" (U+0133)
  0x01, 0x34, 0xF3, 0xEB, 0x23, 0x54, 0x1C, 0x01, 0xAA, 0xDC, // "Ĵ" (U+0134)
  0x01, 0x35, 0xF4, 0xEB, 0x1B, 0x45, 0x17, 0x01, 0xAD, 0x29, // "ĵ" (U+0135)
  0x01, 0x36, 0xFE, 0xED, 0x3D, 0x40, 0x37, 0x01, 0xAE, 0xFD, // "Ķ" (U+0136)
  0x01, 0x37, 0x03, 0xED, 0x30, 0x44, 0x2D, 0x01, 0xB1, 0xA2, // "ķ" (U+0137)
  0x01, 0x38, 0x03, 0x00, 0x30, 0x30, 0x2D, 0x01, 0xB3, 0xE3, // "ĸ" (U+0138)
  0x01, 0x39, 0xFE, 0x01, 0x2C, 0x54, 0x31, 0x01, 0xB5, 0x74, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x05, 0x00, 0x24, 0x56, 0x18, 0x01, 0xB7, 0x4B, // "ĺ" (U+013A)
  0x01, 0x3B, 0xFE, 0xED, 0x2C, 0x40, 0x31, 0x01, 0xB8, 0xDB, // "Ļ" (U+013B)
  0x01, 0x3C, 0xFF, 0xED, 0x19, 0x44, 0x18, 0x01, 0xBA, 0xAE, // "ļ" (U+013C)
  0x01, 0x3D, 0xFE, 0x01, 0x30, 0x40, 0x31, 0x01, 0xBC, 0x13, // "Ľ" (U+013D)
  0x01, 0x3E, 0x05, 0x00, 0x27, 0x44, 0x18, 0x01, 0xBD, 0xC8, // "ľ" (U+013E)
  0x01, 0x3F, 0xFE, 0x01, 0x2D, 0x40, 0x31, 0x01, 0xBF, 0x33, // "Ŀ" (U+013F)
  0x01, 0x40, 0x05, 0x00, 0x22, 0x44, 0x1F, 0x01, 0xC0, 0xD6, // "ŀ" (U+0140)
  0x01, 0x41, 0xFE, 0x01, 0x2C, 0x40, 0x31, 0x01, 0xC2, 0x16, // "Ł" (U+0141)
  0x01, 0x42, 0x01, 0x00, 0x1A, 0x44, 0x19, 0x01, 0xC3, 0xCE, // "ł" (U+0142)
  0x01, 0x43, 0xFE, 0x01, 0x42, 0x54, 0x3B, 0x01, 0xC5, 0x13, // "Ń" (U+0143)
  0x01, 0x44, 0x03, 0x00, 0x2D, 0x45, 0x30, 0x01, 0xC8, 0x08, // "ń" (U+0144)
  0x01, 0x45, 0xFE, 0xED, 0x42, 0x40, 0x3B, 0x01, 0xC9, 0xE9, // "Ņ" (U+0145)
  0x01, 0x46, 0x03, 0xED, 0x2D, 0x31, 0x30, 0x01, 0xCC, 0xD9, // "ņ" (U+0146)
  0x01, 0x47, 0xFE, 0x01, 0x42, 0x54, 0x3B, 0x01, 0xCE, 0xB7, // "Ň" (U+0147)
  0x01, 0x48, 0x03, 0x00, 0x2D, 0x45, 0x30, 0x01, 0xD1, 0xD0, // "ň" (U+0148)
  0x01, 0x49, 0x04, 0x00, 0x3A, 0x40, 0x3C, 0x01, 0xD3, 0xCE, // "ŉ" (U+0149)
  0x01, 0x4A, 0xFE, 0xEB, 0x42, 0x40, 0x3B, 0x01, 0xD5, 0xF4, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x03, 0xEB, 0x2A, 0x31, 0x2D, 0x01, 0xD9, 0x16, // "ŋ" (U+014B)
  0x01, 0x4C, 0x04, 0x00, 0x38, 0x4A, 0x3A, 0x01, 0xDA, 0xFC, // "Ō" (U+014C)
  0x01, 0x4D, 0x03, 0x00, 0x2A, 0x3B, 0x2D, 0x01, 0xDD, 0x68, // "ō" (U+014D)
  0x01, 0x4E, 0x04, 0x00, 0x38, 0x51, 0x3A, 0x01, 0xDF, 0x01, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x03, 0x00, 0x2A, 0x42, 0x2D, 0x01, 0xE1, 0xAC, // "ŏ" (U+014F)
  0x01, 0x50, 0x04, 0x00, 0x3C, 0x53, 0x3A, 0x01, 0xE3, 0x80, // "Ő" (U+0150)
  0x01, 0x51, 0x03, 0x00, 0x31, 0x44, 0x2D, 0x01, 0xE6, 0x63, // "ő" (U+0151)
  0x01, 0x52, 0x04, 0x00, 0x4D, 0x41, 0x4B, 0x01, 0xE8, 0x7B, // "Œ" (U+0152)
  0x01, 0x53, 0x03, 0x00, 0x43, 0x31, 0x43, 0x01, 0xEB, 0x4C, // "œ" (U+0153)
  0x01, 0x54, 0xFE, 0x01, 0x32, 0x54, 0x34, 0x01, 0xED, 0xA7, // "Ŕ" (U+0154)
  0x01, 0x55, 0x03, 0x01, 0x27, 0x45, 0x25, 0x01, 0xF0, 0x23, // "ŕ" (U+0155)
  0x01, 0x56, 0xFE, 0xED, 0x32, 0x40, 0x34, 0x01, 0xF1, 0x8F, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFD, 0xED, 0x27, 0x31, 0x25, 0x01, 0xF4, 0x07, // "ŗ" (U+0157)
  0x01, 0x58, 0xFE, 0x01, 0x32, 0x54, 0x34, 0x01, 0xF5, 0x8B, // "Ř" (U+0158)
  0x01, 0x59, 0x03, 0x01, 0x28, 0x45, 0x25, 0x01, 0xF8, 0x2A, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x00, 0x2E, 0x54, 0x2B, 0x01, 0xF9, 0xBD, // "Ś" (U+015A)
  0x01, 0x5B, 0x02, 0x00, 0x28, 0x45, 0x25, 0x01, 0xFB, 0xF1, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x00, 0x2D, 0x54, 0x2B, 0x01, 0xFD, 0x93, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x02, 0x00, 0x24, 0x45, 0x25, 0x01, 0xFF, 0xDF, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xEB, 0x2D, 0x41, 0x2B, 0x02, 0x01, 0x83, // "Ş" (U+015E)
  0x01, 0x5F, 0x02, 0xEB, 0x23, 0x31, 0x25, 0x02, 0x03, 0xD9, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x00, 0x30, 0x54, 0x2B, 0x02, 0x05, 0x84, // "Š" (U+0160)
  0x01, 0x61, 0x02, 0x00, 0x28, 0x45, 0x25, 0x02, 0x07, 0xDF, // "š" (U+0161)
  0x01, 0x62, 0x07, 0xEB, 0x37, 0x40, 0x30, 0x02, 0x09, 0x9C, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xEB, 0x1E, 0x3B, 0x1D, 0x02, 0x0B, 0xB9, // "ţ" (U+0163)
  0x01, 0x64, 0x07, 0x01, 0x37, 0x54, 0x30, 0x02, 0x0D, 0x43, // "Ť" (U+0164)
  0x01, 0x65, 0x05, 0x00, 0x27, 0x44, 0x1D, 0x02, 0x0F, 0x54, // "ť" (U+0165)
  0x01, 0x66, 0x07, 0x01, 0x37, 0x40, 0x30, 0x02, 0x10, 0xB8, // "Ŧ" (U+0166)
  0x01, 0x67, 0x03, 0x00, 0x1E, 0x3B, 0x1D, 0x02, 0x12, 0x5B, // "ŧ" (U+0167)
  0x01, 0x68, 0x07, 0x00, 0x3F, 0x50, 0x39, 0x02, 0x13, 0x6D, // "Ũ" (U+0168)
  0x01, 0x69, 0x05, 0x00, 0x2E, 0x41, 0x2F, 0x02, 0x16, 0x1F, // "ũ" (U+0169)
  0x01, 0x6A, 0x07, 0x00, 0x3F, 0x4A, 0x39, 0x02, 0x18, 0x16, // "Ū" (U+016A)
  0x01, 0x6B, 0x05, 0x00, 0x2E, 0x3B, 0x2F, 0x02, 0x1A, 0x74, // "ū" (U+016B)
  0x01, 0x6C, 0x07, 0x00, 0x3F, 0x51, 0x39, 0x02, 0x1C, 0x1F, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x05, 0x00, 0x2E, 0x42, 0x2F, 0x02, 0x1E, 0xBD, // "ŭ" (U+016D)
  0x01, 0x6E, 0x07, 0x00, 0x3F, 0x57, 0x39, 0x02, 0x20, 0xA4, // "Ů" (U+016E)
  0x01, 0x6F, 0x05, 0x00, 0x2E, 0x48, 0x2F, 0x02, 0x23, 0x73, // "ů" (U+016F)
  0x01, 0x70, 0x07, 0x00, 0x3F, 0x53, 0x39, 0x02, 0x25, 0x8A, // "Ű" (U+0170)
  0x01, 0x71, 0x05, 0x00, 0x33, 0x44, 0x2F, 0x02, 0x28, 0x51, // "ű" (U+0171)
  0x01, 0x72, 0x07, 0xEB, 0x3F, 0x40, 0x39, 0x02, 0x2A, 0x6B, // "Ų" (U+0172)
  0x01, 0x73, 0x05, 0xEB, 0x2E, 0x30, 0x2F, 0x02, 0x2D, 0x20, // "ų" (U+0173)
  0x01, 0x74, 0x08, 0x01, 0x59, 0x54, 0x51, 0x02, 0x2F, 0x26, // "Ŵ" (U+0174)
  0x01, 0x75, 0x04, 0xFF, 0x3F, 0x45, 0x40, 0x02, 0x32, 0xFB, // "ŵ" (U+0175)
  0x01, 0x76, 0x07, 0x01, 0x3A, 0x54, 0x31, 0x02, 0x35, 0xD7, // "Ŷ" (U+0176)
  0x01, 0x77, 0xF3, 0xEB, 0x28, 0x45, 0x2A, 0x02, 0x38, 0x15, // "ŷ" (U+0177)
  0x01, 0x78, 0x07, 0x01, 0x3A, 0x52, 0x31, 0x02, 0x3A, 0x95, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x33, 0x54, 0x30, 0x02, 0x3C, 0xB6, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x27, 0x45, 0x28, 0x02, 0x3E, 0xCF, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x33, 0x53, 0x30, 0x02, 0x40, 0x61, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x26, 0x44, 0x28, 0x02, 0x42, 0x60, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x33, 0x54, 0x30, 0x02, 0x43, 0xCD, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x2A, 0x45, 0x28, 0x02, 0x46, 0x09, // "ž" (U+017E)
  0x01, 0x7F, 0xF4, 0xEB, 0x28, 0x45, 0x19, 0x02, 0x47, 0xBE, // "ſ" (U+017F)
  0x03, 0xA9, 0xFF, 0x01, 0x39, 0x41, 0x3B, 0x02, 0x49, 0xBE, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xEB, 0x2D, 0x30, 0x30, 0x02, 0x4C, 0x57, // "μ" (U+03BC)
  0x03, 0xC0, 0xFF, 0x00, 0x33, 0x30, 0x31, 0x02, 0x4E, 0x5B, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x17, 0x2D, 0x1B, 0x2D, 0x02, 0x4F, 0xFA, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x17, 0x5A, 0x1B, 0x5A, 0x02, 0x50, 0x0F, // "—" (U+2014)
  0x20, 0xAC, 0x02, 0x00, 0x30, 0x41, 0x2C, 0x02, 0x50, 0x27, // "€" (U+20AC)
  0x20, 0xBF, 0xFD, 0xF9, 0x2B, 0x48, 0x2C, 0x02, 0x51, 0xD9, // "₿" (U+20BF)
  0x20, 0x18, 0x09, 0x29, 0x18, 0x41, 0x14, 0x02, 0x54, 0x4C, // "‘" (U+2018)
  0x20, 0x19, 0x08, 0x29, 0x16, 0x40, 0x14, 0x02, 0x54, 0xAA, // "’" (U+2019)
  0x20, 0x1A, 0xFD, 0xF3, 0x0C, 0x0B, 0x14, 0x02, 0x55, 0x02, // "‚" (U+201A)
  0x20, 0x1B, 0x0B, 0x28, 0x17, 0x40, 0x14, 0x02, 0x55, 0x63, // "‛" (U+201B)
  0x20, 0x1C, 0x09, 0x29, 0x27, 0x41, 0x23, 0x02, 0x55, 0xC1, // "“" (U+201C)
  0x20, 0x1D, 0x07, 0x28, 0x26, 0x40, 0x23, 0x02, 0x56, 0x7D, // "”" (U+201D)
  0x20, 0x1E, 0xFD, 0xF3, 0x1B, 0x0B, 0x23, 0x02, 0x57, 0x40, // "„" (U+201E)
  0x20, 0x1F, 0x0B, 0x28, 0x27, 0x40, 0x23, 0x02, 0x58, 0x01, // "‟" (U+201F)
  0x20, 0x20, 0x07, 0xF7, 0x26, 0x44, 0x23, 0x02, 0x58, 0xC3, // "†" (U+2020)
  0x20, 0x21, 0xFF, 0xF7, 0x27, 0x44, 0x23, 0x02, 0x5A, 0x3E, // "‡" (U+2021)
  0x20, 0x22, 0x05, 0x14, 0x1A, 0x2D, 0x1D, 0x02, 0x5C, 0x1C, // "•" (U+2022)
  0x20, 0x26, 0x03, 0x00, 0x3A, 0x0B, 0x43, 0x02, 0x5C, 0x8A, // "…" (U+2026)
  0x20, 0x30, 0x06, 0x00, 0x61, 0x41, 0x64, 0x02, 0x5D, 0x1C, // "‰" (U+2030)
  0x20, 0x39, 0x05, 0x08, 0x19, 0x29, 0x1A, 0x02, 0x61, 0x52, // "‹" (U+2039)
  0x20, 0x3A, 0x02, 0x08, 0x15, 0x29, 0x1A, 0x02, 0x61, 0xDD, // "›" (U+203A)
  0x20, 0x44, 0xEC, 0x01, 0x1A, 0x40, 0x05, 0x02, 0x62, 0x5C, // "⁄" (U+2044)
  0x21, 0x22, 0x09, 0x22, 0x44, 0x40, 0x40, 0x02, 0x63, 0xB1, // "™" (U+2122)
  0x21, 0x52, 0x07, 0x00, 0x5E, 0x41, 0x60, 0x02, 0x65, 0x90, // "⅒" (U+2152)
  0xFB, 0x01, 0xF4, 0xEB, 0x2C, 0x45, 0x2E, 0x02, 0x69, 0x23, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xF4, 0xEB, 0x2F, 0x45, 0x2F, 0x02, 0x6B, 0xC8, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x07, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x67, 0x04, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0xC0, 0x07, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x07, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x07, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x07, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x07, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x07, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x0B, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x07, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x07, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x07, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x54, 0x04, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x55, 0x01, // &U (U+0026 U+0055)
  0x00, 0x26, 0x00, 0x56, 0x05, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x04, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x04, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xD9, 0x01, // &Ù (U+0026 U+00D9)
  0x00, 0x26, 0x00, 0xDA, 0x01, // &Ú (U+0026 U+00DA)
  0x00, 0x26, 0x00, 0xDB, 0x01, // &Û (U+0026 U+00DB)
  0x00, 0x26, 0x00, 0xDC, 0x01, // &Ü (U+0026 U+00DC)
  0x00, 0x26, 0x00, 0xDD, 0x04, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x68, 0x01, // &Ũ (U+0026 U+0168)
  0x00, 0x26, 0x01, 0x6A, 0x01, // &Ū (U+0026 U+016A)
  0x00, 0x26, 0x01, 0x6C, 0x01, // &Ŭ (U+0026 U+016C)
  0x00, 0x26, 0x01, 0x6E, 0x01, // &Ů (U+0026 U+016E)
  0x00, 0x26, 0x01, 0x70, 0x01, // &Ű (U+0026 U+0170)
  0x00, 0x26, 0x01, 0x72, 0x01, // &Ų (U+0026 U+0172)
  0x00, 0x26, 0x01, 0x74, 0x04, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x04, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x04, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x07, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x67, 0x04, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0xC0, 0x07, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x07, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x07, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x07, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x07, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x07, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x0B, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x07, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x07, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x07, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x26, 0x02, // *& (U+002A U+0026)
  0x00, 0x2A, 0x00, 0x2C, 0x0B, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x0B, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x05, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x05, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x05, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x05, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x05, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x05, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x05, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x07, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x05, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x05, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x05, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x0B, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x0B, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x0B, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x43, 0x02, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x02, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x02, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x02, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x06, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x55, 0x02, // ,U (U+002C U+0055)
  0x00, 0x2C, 0x00, 0x56, 0x08, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x07, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x06, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x05, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x02, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x02, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xC7, 0x02, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x02, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x02, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x02, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x02, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x02, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x02, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xD9, 0x02, // ,Ù (U+002C U+00D9)
  0x00, 0x2C, 0x00, 0xDA, 0x02, // ,Ú (U+002C U+00DA)
  0x00, 0x2C, 0x00, 0xDB, 0x02, // ,Û (U+002C U+00DB)
  0x00, 0x2C, 0x00, 0xDC, 0x02, // ,Ü (U+002C U+00DC)
  0x00, 0x2C, 0x00, 0xDD, 0x06, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xFD, 0x02, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x02, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x06, 0x02, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x02, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x02, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x02, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x02, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x02, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x02, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x02, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x02, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x02, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x02, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x02, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x68, 0x02, // ,Ũ (U+002C U+0168)
  0x00, 0x2C, 0x01, 0x6A, 0x02, // ,Ū (U+002C U+016A)
  0x00, 0x2C, 0x01, 0x6C, 0x02, // ,Ŭ (U+002C U+016C)
  0x00, 0x2C, 0x01, 0x6E, 0x02, // ,Ů (U+002C U+016E)
  0x00, 0x2C, 0x01, 0x70, 0x02, // ,Ű (U+002C U+0170)
  0x00, 0x2C, 0x01, 0x72, 0x02, // ,Ų (U+002C U+0172)
  0x00, 0x2C, 0x01, 0x74, 0x07, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x02, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x06, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x02, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x06, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x43, 0x02, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x02, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x02, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x02, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x06, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x55, 0x02, // .U (U+002E U+0055)
  0x00, 0x2E, 0x00, 0x56, 0x08, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x07, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x06, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x05, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x02, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x02, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xC7, 0x02, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x02, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x02, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x02, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x02, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x02, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x02, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xD9, 0x02, // .Ù (U+002E U+00D9)
  0x00, 0x2E, 0x00, 0xDA, 0x02, // .Ú (U+002E U+00DA)
  0x00, 0x2E, 0x00, 0xDB, 0x02, // .Û (U+002E U+00DB)
  0x00, 0x2E, 0x00, 0xDC, 0x02, // .Ü (U+002E U+00DC)
  0x00, 0x2E, 0x00, 0xDD, 0x06, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xFD, 0x02, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x02, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x06, 0x02, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x02, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x02, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x02, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x02, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x02, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x02, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x02, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x02, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x02, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x02, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x02, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x68, 0x02, // .Ũ (U+002E U+0168)
  0x00, 0x2E, 0x01, 0x6A, 0x02, // .Ū (U+002E U+016A)
  0x00, 0x2E, 0x01, 0x6C, 0x02, // .Ŭ (U+002E U+016C)
  0x00, 0x2E, 0x01, 0x6E, 0x02, // .Ů (U+002E U+016E)
  0x00, 0x2E, 0x01, 0x70, 0x02, // .Ű (U+002E U+0170)
  0x00, 0x2E, 0x01, 0x72, 0x02, // .Ų (U+002E U+0172)
  0x00, 0x2E, 0x01, 0x74, 0x07, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x02, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x06, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x02, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x06, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x07, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x26, 0x02, // A& (U+0041 U+0026)
  0x00, 0x41, 0x00, 0x27, 0x07, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x08, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x43, 0x02, // AC (U+0041 U+0043)
  0x00, 0x41, 0x00, 0x47, 0x02, // AG (U+0041 U+0047)
  0x00, 0x41, 0x00, 0x4F, 0x02, // AO (U+0041 U+004F)
  0x00, 0x41, 0x00, 0x51, 0x02, // AQ (U+0041 U+0051)
  0x00, 0x41, 0x00, 0x54, 0x05, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x55, 0x02, // AU (U+0041 U+0055)
  0x00, 0x41, 0x00, 0x56, 0x07, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x06, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x06, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x63, 0x01, // Ac (U+0041 U+0063)
  0x00, 0x41, 0x00, 0x64, 0x01, // Ad (U+0041 U+0064)
  0x00, 0x41, 0x00, 0x65, 0x01, // Ae (U+0041 U+0065)
  0x00, 0x41, 0x00, 0x67, 0x01, // Ag (U+0041 U+0067)
  0x00, 0x41, 0x00, 0x6F, 0x01, // Ao (U+0041 U+006F)
  0x00, 0x41, 0x00, 0x71, 0x01, // Aq (U+0041 U+0071)
  0x00, 0x41, 0x00, 0x75, 0x02, // Au (U+0041 U+0075)
  0x00, 0x41, 0x00, 0x76, 0x04, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x77, 0x03, // Aw (U+0041 U+0077)
  0x00, 0x41, 0x00, 0x79, 0x04, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xA9, 0x05, // A© (U+0041 U+00A9)
  0x00, 0x41, 0x00, 0xAE, 0x05, // A® (U+0041 U+00AE)
  0x00, 0x41, 0x00, 0xC7, 0x02, // AÇ (U+0041 U+00C7)
  0x00, 0x41, 0x00, 0xD2, 0x02, // AÒ (U+0041 U+00D2)
  0x00, 0x41, 0x00, 0xD3, 0x02, // AÓ (U+0041 U+00D3)
  0x00, 0x41, 0x00, 0xD4, 0x02, // AÔ (U+0041 U+00D4)
  0x00, 0x41, 0x00, 0xD5, 0x02, // AÕ (U+0041 U+00D5)
  0x00, 0x41, 0x00, 0xD6, 0x02, // AÖ (U+0041 U+00D6)
  0x00, 0x41, 0x00, 0xD8, 0x02, // AØ (U+0041 U+00D8)
  0x00, 0x41, 0x00, 0xD9, 0x02, // AÙ (U+0041 U+00D9)
  0x00, 0x41, 0x00, 0xDA, 0x02, // AÚ (U+0041 U+00DA)
  0x00, 0x41, 0x00, 0xDB, 0x02, // AÛ (U+0041 U+00DB)
  0x00, 0x41, 0x00, 0xDC, 0x02, // AÜ (U+0041 U+00DC)
  0x00, 0x41, 0x00, 0xDD, 0x06, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xE7, 0x01, // Aç (U+0041 U+00E7)
  0x00, 0x41, 0x00, 0xE8, 0x01, // Aè (U+0041 U+00E8)
  0x00, 0x41, 0x00, 0xE9, 0x01, // Aé (U+0041 U+00E9)
  0x00, 0x41, 0x00, 0xEA, 0x01, // Aê (U+0041 U+00EA)
  0x00, 0x41, 0x00, 0xEB, 0x01, // Aë (U+0041 U+00EB)
  0x00, 0x41, 0x00, 0xF0, 0x01, // Að (U+0041 U+00F0)
  0x00, 0x41, 0x00, 0xF2, 0x01, // Aò (U+0041 U+00F2)
  0x00, 0x41, 0x00, 0xF3, 0x01, // Aó (U+0041 U+00F3)
  0x00, 0x41, 0x00, 0xF4, 0x01, // Aô (U+0041 U+00F4)
  0x00, 0x41, 0x00, 0xF5, 0x01, // Aõ (U+0041 U+00F5)
  0x00, 0x41, 0x00, 0xF6, 0x01, // Aö (U+0041 U+00F6)
  0x00, 0x41, 0x00, 0xF8, 0x01, // Aø (U+0041 U+00F8)
  0x00, 0x41, 0x00, 0xF9, 0x02, // Aù (U+0041 U+00F9)
  0x00, 0x41, 0x00, 0xFA, 0x02, // Aú (U+0041 U+00FA)
  0x00, 0x41, 0x00, 0xFB, 0x02, // Aû (U+0041 U+00FB)
  0x00, 0x41, 0x00, 0xFC, 0x02, // Aü (U+0041 U+00FC)
  0x00, 0x41, 0x00, 0xFD, 0x04, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x04, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x06, 0x02, // AĆ (U+0041 U+0106)
  0x00, 0x41, 0x01, 0x07, 0x01, // Ać (U+0041 U+0107)
  0x00, 0x41, 0x01, 0x08, 0x02, // AĈ (U+0041 U+0108)
  0x00, 0x41, 0x01, 0x09, 0x01, // Aĉ (U+0041 U+0109)
  0x00, 0x41, 0x01, 0x0A, 0x02, // AĊ (U+0041 U+010A)
  0x00, 0x41, 0x01, 0x0B, 0x01, // Aċ (U+0041 U+010B)
  0x00, 0x41, 0x01, 0x0C, 0x02, // AČ (U+0041 U+010C)
  0x00, 0x41, 0x01, 0x0D, 0x01, // Ač (U+0041 U+010D)
  0x00, 0x41, 0x01, 0x0F, 0x01, // Aď (U+0041 U+010F)
  0x00, 0x41, 0x01, 0x11, 0x01, // Ađ (U+0041 U+0111)
  0x00, 0x41, 0x01, 0x13, 0x01, // Aē (U+0041 U+0113)
  0x00, 0x41, 0x01, 0x15, 0x01, // Aĕ (U+0041 U+0115)
  0x00, 0x41, 0x01, 0x17, 0x01, // Aė (U+0041 U+0117)
  0x00, 0x41, 0x01, 0x19, 0x01, // Aę (U+0041 U+0119)
  0x00, 0x41, 0x01, 0x1B, 0x01, // Aě (U+0041 U+011B)
  0x00, 0x41, 0x01, 0x1C, 0x02, // AĜ (U+0041 U+011C)
  0x00, 0x41, 0x01, 0x1D, 0x01, // Aĝ (U+0041 U+011D)
  0x00, 0x41, 0x01, 0x1E, 0x02, // AĞ (U+0041 U+011E)
  0x00, 0x41, 0x01, 0x1F, 0x01, // Ağ (U+0041 U+011F)
  0x00, 0x41, 0x01, 0x20, 0x02, // AĠ (U+0041 U+0120)
  0x00, 0x41, 0x01, 0x21, 0x01, // Aġ (U+0041 U+0121)
  0x00, 0x41, 0x01, 0x22, 0x02, // AĢ (U+0041 U+0122)
  0x00, 0x41, 0x01, 0x23, 0x01, // Aģ (U+0041 U+0123)
  0x00, 0x41, 0x01, 0x49, 0x05, // Aŉ (U+0041 U+0149)
  0x00, 0x41, 0x01, 0x4C, 0x02, // AŌ (U+0041 U+014C)
  0x00, 0x41, 0x01, 0x4D, 0x01, // Aō (U+0041 U+014D)
  0x00, 0x41, 0x01, 0x4E, 0x02, // AŎ (U+0041 U+014E)
  0x00, 0x41, 0x01, 0x4F, 0x01, // Aŏ (U+0041 U+014F)
  0x00, 0x41, 0x01, 0x50, 0x02, // AŐ (U+0041 U+0150)
  0x00, 0x41, 0x01, 0x51, 0x01, // Aő (U+0041 U+0151)
  0x00, 0x41, 0x01, 0x52, 0x02, // AŒ (U+0041 U+0152)
  0x00, 0x41, 0x01, 0x53, 0x01, // Aœ (U+0041 U+0153)
  0x00, 0x41, 0x01, 0x68, 0x02, // AŨ (U+0041 U+0168)
  0x00, 0x41, 0x01, 0x69, 0x02, // Aũ (U+0041 U+0169)
  0x00, 0x41, 0x01, 0x6A, 0x02, // AŪ (U+0041 U+016A)
  0x00, 0x41, 0x01, 0x6B, 0x02, // Aū (U+0041 U+016B)
  0x00, 0x41, 0x01, 0x6C, 0x02, // AŬ (U+0041 U+016C)
  0x00, 0x41, 0x01, 0x6D, 0x02, // Aŭ (U+0041 U+016D)
  0x00, 0x41, 0x01, 0x6E, 0x02, // AŮ (U+0041 U+016E)
  0x00, 0x41, 0x01, 0x6F, 0x02, // Aů (U+0041 U+016F)
  0x00, 0x41, 0x01, 0x70, 0x02, // AŰ (U+0041 U+0170)
  0x00, 0x41, 0x01, 0x71, 0x02, // Aű (U+0041 U+0171)
  0x00, 0x41, 0x01, 0x72, 0x02, // AŲ (U+0041 U+0172)
  0x00, 0x41, 0x01, 0x73, 0x02, // Aų (U+0041 U+0173)
  0x00, 0x41, 0x01, 0x74, 0x06, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x75, 0x03, // Aŵ (U+0041 U+0175)
  0x00, 0x41, 0x01, 0x76, 0x06, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x04, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x06, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x08, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x08, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x08, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x08, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x08, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x2A, 0x02, // B* (U+0042 U+002A)
  0x00, 0x42, 0x00, 0x41, 0x01, // BA (U+0042 U+0041)
  0x00, 0x42, 0x00, 0x54, 0x02, // BT (U+0042 U+0054)
  0x00, 0x42, 0x00, 0x56, 0x04, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x57, 0x03, // BW (U+0042 U+0057)
  0x00, 0x42, 0x00, 0x58, 0x02, // BX (U+0042 U+0058)
  0x00, 0x42, 0x00, 0x59, 0x04, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0x5A, 0x01, // BZ (U+0042 U+005A)
  0x00, 0x42, 0x00, 0x77, 0x01, // Bw (U+0042 U+0077)
  0x00, 0x42, 0x00, 0x79, 0x02, // By (U+0042 U+0079)
  0x00, 0x42, 0x00, 0xC0, 0x01, // BÀ (U+0042 U+00C0)
  0x00, 0x42, 0x00, 0xC1, 0x01, // BÁ (U+0042 U+00C1)
  0x00, 0x42, 0x00, 0xC2, 0x01, // BÂ (U+0042 U+00C2)
  0x00, 0x42, 0x00, 0xC3, 0x01, // BÃ (U+0042 U+00C3)
  0x00, 0x42, 0x00, 0xC4, 0x01, // BÄ (U+0042 U+00C4)
  0x00, 0x42, 0x00, 0xC5, 0x01, // BÅ (U+0042 U+00C5)
  0x00, 0x42, 0x00, 0xC6, 0x03, // BÆ (U+0042 U+00C6)
  0x00, 0x42, 0x00, 0xDD, 0x04, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x00, 0xFD, 0x02, // Bý (U+0042 U+00FD)
  0x00, 0x42, 0x00, 0xFF, 0x02, // Bÿ (U+0042 U+00FF)
  0x00, 0x42, 0x01, 0x00, 0x01, // BĀ (U+0042 U+0100)
  0x00, 0x42, 0x01, 0x02, 0x01, // BĂ (U+0042 U+0102)
  0x00, 0x42, 0x01, 0x04, 0x01, // BĄ (U+0042 U+0104)
  0x00, 0x42, 0x01, 0x74, 0x03, // BŴ (U+0042 U+0174)
  0x00, 0x42, 0x01, 0x75, 0x01, // Bŵ (U+0042 U+0175)
  0x00, 0x42, 0x01, 0x76, 0x04, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x77, 0x02, // Bŷ (U+0042 U+0177)
  0x00, 0x42, 0x01, 0x78, 0x04, // BŸ (U+0042 U+0178)
  0x00, 0x42, 0x01, 0x79, 0x01, // BŹ (U+0042 U+0179)
  0x00, 0x42, 0x01, 0x7B, 0x01, // BŻ (U+0042 U+017B)
  0x00, 0x42, 0x01, 0x7D, 0x01, // BŽ (U+0042 U+017D)
  0x00, 0x42, 0x20, 0x19, 0x02, // B’ (U+0042 U+2019)
  0x00, 0x42, 0x20, 0x1D, 0x02, // B” (U+0042 U+201D)
  0x00, 0x42, 0x21, 0x22, 0x02, // B™ (U+0042 U+2122)
  0x00, 0x43, 0x00, 0x26, 0x02, // C& (U+0043 U+0026)
  0x00, 0x43, 0x00, 0x43, 0x01, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x01, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x01, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x01, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xC7, 0x01, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x01, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x01, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x01, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x01, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x01, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x01, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x01, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x01, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x01, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x01, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x01, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x01, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x01, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x01, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x01, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x01, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x01, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x01, // CŒ (U+0043 U+0152)
  0x00, 0x44, 0x00, 0x22, 0x03, // D" (U+0044 U+0022)
  0x00, 0x44, 0x00, 0x27, 0x03, // D' (U+0044 U+0027)
  0x00, 0x44, 0x00, 0x2C, 0x02, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x02, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x41, 0x02, // DA (U+0044 U+0041)
  0x00, 0x44, 0x00, 0x54, 0x02, // DT (U+0044 U+0054)
  0x00, 0x44, 0x00, 0x56, 0x02, // DV (U+0044 U+0056)
  0x00, 0x44, 0x00, 0x57, 0x02, // DW (U+0044 U+0057)
  0x00, 0x44, 0x00, 0x58, 0x01, // DX (U+0044 U+0058)
  0x00, 0x44, 0x00, 0x59, 0x02, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0xC0, 0x02, // DÀ (U+0044 U+00C0)
  0x00, 0x44, 0x00, 0xC1, 0x02, // DÁ (U+0044 U+00C1)
  0x00, 0x44, 0x00, 0xC2, 0x02, // DÂ (U+0044 U+00C2)
  0x00, 0x44, 0x00, 0xC3, 0x02, // DÃ (U+0044 U+00C3)
  0x00, 0x44, 0x00, 0xC4, 0x02, // DÄ (U+0044 U+00C4)
  0x00, 0x44, 0x00, 0xC5, 0x02, // DÅ (U+0044 U+00C5)
  0x00, 0x44, 0x00, 0xC6, 0x04, // DÆ (U+0044 U+00C6)
  0x00, 0x44, 0x00, 0xDD, 0x02, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x00, 0x02, // DĀ (U+0044 U+0100)
  0x00, 0x44, 0x01, 0x02, 0x02, // DĂ (U+0044 U+0102)
  0x00, 0x44, 0x01, 0x04, 0x02, // DĄ (U+0044 U+0104)
  0x00, 0x44, 0x01, 0x74, 0x02, // DŴ (U+0044 U+0174)
  0x00, 0x44, 0x01, 0x76, 0x02, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x02, // DŸ (U+0044 U+0178)
  0x00, 0x44, 0x20, 0x1A, 0x02, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x02, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x02, // D… (U+0044 U+2026)
  0x00, 0x45, 0x00, 0x56, 0x02, // EV (U+0045 U+0056)
  0x00, 0x45, 0x00, 0x57, 0x02, // EW (U+0045 U+0057)
  0x00, 0x45, 0x00, 0x59, 0x02, // EY (U+0045 U+0059)
  0x00, 0x45, 0x00, 0xDD, 0x02, // EÝ (U+0045 U+00DD)
  0x00, 0x45, 0x01, 0x74, 0x02, // EŴ (U+0045 U+0174)
  0x00, 0x45, 0x01, 0x76, 0x02, // EŶ (U+0045 U+0176)
  0x00, 0x45, 0x01, 0x78, 0x02, // EŸ (U+0045 U+0178)
  0x00, 0x46, 0x00, 0x26, 0x04, // F& (U+0046 U+0026)
  0x00, 0x46, 0x00, 0x2C, 0x07, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x07, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x05, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x04, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x04, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x04, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x04, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x04, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x04, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x04, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x05, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x05, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x05, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x05, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x05, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x05, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x0A, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x04, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x04, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x04, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x04, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x04, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x04, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x04, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x04, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x04, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x04, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x04, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x04, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x04, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x04, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x04, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x04, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x04, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x04, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x04, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x05, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x04, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x05, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x04, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x05, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x04, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x04, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x04, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x04, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x04, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x04, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x04, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x04, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x04, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x04, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x04, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x04, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x04, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x04, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x04, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x04, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x04, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x04, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x04, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x04, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x07, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x07, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x07, // F… (U+0046 U+2026)
  0x00, 0x47, 0x00, 0x54, 0x02, // GT (U+0047 U+0054)
  0x00, 0x47, 0x00, 0x56, 0x02, // GV (U+0047 U+0056)
  0x00, 0x47, 0x00, 0x57, 0x02, // GW (U+0047 U+0057)
  0x00, 0x47, 0x00, 0x59, 0x02, // GY (U+0047 U+0059)
  0x00, 0x47, 0x00, 0xC6, 0x02, // GÆ (U+0047 U+00C6)
  0x00, 0x47, 0x00, 0xDD, 0x02, // GÝ (U+0047 U+00DD)
  0x00, 0x47, 0x01, 0x74, 0x02, // GŴ (U+0047 U+0174)
  0x00, 0x47, 0x01, 0x76, 0x02, // GŶ (U+0047 U+0176)
  0x00, 0x47, 0x01, 0x78, 0x02, // GŸ (U+0047 U+0178)
  0x00, 0x4A, 0x00, 0x2C, 0x02, // J, (U+004A U+002C)
  0x00, 0x4A, 0x00, 0x2E, 0x02, // J. (U+004A U+002E)
  0x00, 0x4A, 0x00, 0x41, 0x02, // JA (U+004A U+0041)
  0x00, 0x4A, 0x00, 0xC0, 0x02, // JÀ (U+004A U+00C0)
  0x00, 0x4A, 0x00, 0xC1, 0x02, // JÁ (U+004A U+00C1)
  0x00, 0x4A, 0x00, 0xC2, 0x02, // JÂ (U+004A U+00C2)
  0x00, 0x4A, 0x00, 0xC3, 0x02, // JÃ (U+004A U+00C3)
  0x00, 0x4A, 0x00, 0xC4, 0x02, // JÄ (U+004A U+00C4)
  0x00, 0x4A, 0x00, 0xC5, 0x02, // JÅ (U+004A U+00C5)
  0x00, 0x4A, 0x01, 0x00, 0x02, // JĀ (U+004A U+0100)
  0x00, 0x4A, 0x01, 0x02, 0x02, // JĂ (U+004A U+0102)
  0x00, 0x4A, 0x01, 0x04, 0x02, // JĄ (U+004A U+0104)
  0x00, 0x4A, 0x20, 0x1A, 0x02, // J‚ (U+004A U+201A)
  0x00, 0x4A, 0x20, 0x1E, 0x02, // J„ (U+004A U+201E)
  0x00, 0x4A, 0x20, 0x26, 0x02, // J… (U+004A U+2026)
  0x00, 0x4B, 0x00, 0x26, 0x02, // K& (U+004B U+0026)
  0x00, 0x4B, 0x00, 0x43, 0x02, // KC (U+004B U+0043)
  0x00, 0x4B, 0x00, 0x47, 0x02, // KG (U+004B U+0047)
  0x00, 0x4B, 0x00, 0x4F, 0x02, // KO (U+004B U+004F)
  0x00, 0x4B, 0x00, 0x51, 0x02, // KQ (U+004B U+0051)
  0x00, 0x4B, 0x00, 0x61, 0x01, // Ka (U+004B U+0061)
  0x00, 0x4B, 0x00, 0x63, 0x02, // Kc (U+004B U+0063)
  0x00, 0x4B, 0x00, 0x64, 0x02, // Kd (U+004B U+0064)
  0x00, 0x4B, 0x00, 0x65, 0x02, // Ke (U+004B U+0065)
  0x00, 0x4B, 0x00, 0x67, 0x02, // Kg (U+004B U+0067)
  0x00, 0x4B, 0x00, 0x6F, 0x02, // Ko (U+004B U+006F)
  0x00, 0x4B, 0x00, 0x71, 0x02, // Kq (U+004B U+0071)
  0x00, 0x4B, 0x00, 0x75, 0x02, // Ku (U+004B U+0075)
  0x00, 0x4B, 0x00, 0x76, 0x01, // Kv (U+004B U+0076)
  0x00, 0x4B, 0x00, 0x77, 0x03, // Kw (U+004B U+0077)
  0x00, 0x4B, 0x00, 0x79, 0x03, // Ky (U+004B U+0079)
  0x00, 0x4B, 0x00, 0xC7, 0x02, // KÇ (U+004B U+00C7)
  0x00, 0x4B, 0x00, 0xD2, 0x02, // KÒ (U+004B U+00D2)
  0x00, 0x4B, 0x00, 0xD3, 0x02, // KÓ (U+004B U+00D3)
  0x00, 0x4B, 0x00, 0xD4, 0x02, // KÔ (U+004B U+00D4)
  0x00, 0x4B, 0x00, 0xD5, 0x02, // KÕ (U+004B U+00D5)
  0x00, 0x4B, 0x00, 0xD6, 0x02, // KÖ (U+004B U+00D6)
  0x00, 0x4B, 0x00, 0xD8, 0x02, // KØ (U+004B U+00D8)
  0x00, 0x4B, 0x00, 0xE0, 0x01, // Kà (U+004B U+00E0)
  0x00, 0x4B, 0x00, 0xE1, 0x01, // Ká (U+004B U+00E1)
  0x00, 0x4B, 0x00, 0xE2, 0x01, // Kâ (U+004B U+00E2)
  0x00, 0x4B, 0x00, 0xE3, 0x01, // Kã (U+004B U+00E3)
  0x00, 0x4B, 0x00, 0xE4, 0x01, // Kä (U+004B U+00E4)
  0x00, 0x4B, 0x00, 0xE5, 0x01, // Kå (U+004B U+00E5)
  0x00, 0x4B, 0x00, 0xE6, 0x01, // Kæ (U+004B U+00E6)
  0x00, 0x4B, 0x00, 0xE7, 0x02, // Kç (U+004B U+00E7)
  0x00, 0x4B, 0x00, 0xE8, 0x02, // Kè (U+004B U+00E8)
  0x00, 0x4B, 0x00, 0xE9, 0x02, // Ké (U+004B U+00E9)
  0x00, 0x4B, 0x00, 0xEA, 0x02, // Kê (U+004B U+00EA)
  0x00, 0x4B, 0x00, 0xEB, 0x02, // Kë (U+004B U+00EB)
  0x00, 0x4B, 0x00, 0xF0, 0x02, // Kð (U+004B U+00F0)
  0x00, 0x4B, 0x00, 0xF2, 0x02, // Kò (U+004B U+00F2)
  0x00, 0x4B, 0x00, 0xF3, 0x02, // Kó (U+004B U+00F3)
  0x00, 0x4B, 0x00, 0xF4, 0x02, // Kô (U+004B U+00F4)
  0x00, 0x4B, 0x00, 0xF5, 0x02, // Kõ (U+004B U+00F5)
  0x00, 0x4B, 0x00, 0xF6, 0x02, // Kö (U+004B U+00F6)
  0x00, 0x4B, 0x00, 0xF8, 0x02, // Kø (U+004B U+00F8)
  0x00, 0x4B, 0x00, 0xF9, 0x02, // Kù (U+004B U+00F9)
  0x00, 0x4B, 0x00, 0xFA, 0x02, // Kú (U+004B U+00FA)
  0x00, 0x4B, 0x00, 0xFB, 0x02, // Kû (U+004B U+00FB)
  0x00, 0x4B, 0x00, 0xFC, 0x02, // Kü (U+004B U+00FC)
  0x00, 0x4B, 0x00, 0xFD, 0x03, // Ký (U+004B U+00FD)
  0x00, 0x4B, 0x00, 0xFF, 0x03, // Kÿ (U+004B U+00FF)
  0x00, 0x4B, 0x01, 0x01, 0x01, // Kā (U+004B U+0101)
  0x00, 0x4B, 0x01, 0x03, 0x01, // Kă (U+004B U+0103)
  0x00, 0x4B, 0x01, 0x05, 0x01, // Ką (U+004B U+0105)
  0x00, 0x4B, 0x01, 0x06, 0x02, // KĆ (U+004B U+0106)
  0x00, 0x4B, 0x01, 0x07, 0x02, // Kć (U+004B U+0107)
  0x00, 0x4B, 0x01, 0x08, 0x02, // KĈ (U+004B U+0108)
  0x00, 0x4B, 0x01, 0x09, 0x02, // Kĉ (U+004B U+0109)
  0x00, 0x4B, 0x01, 0x0A, 0x02, // KĊ (U+004B U+010A)
  0x00, 0x4B, 0x01, 0x0B, 0x02, // Kċ (U+004B U+010B)
  0x00, 0x4B, 0x01, 0x0C, 0x02, // KČ (U+004B U+010C)
  0x00, 0x4B, 0x01, 0x0D, 0x02, // Kč (U+004B U+010D)
  0x00, 0x4B, 0x01, 0x0F, 0x02, // Kď (U+004B U+010F)
  0x00, 0x4B, 0x01, 0x11, 0x02, // Kđ (U+004B U+0111)
  0x00, 0x4B, 0x01, 0x13, 0x02, // Kē (U+004B U+0113)
  0x00, 0x4B, 0x01, 0x15, 0x02, // Kĕ (U+004B U+0115)
  0x00, 0x4B, 0x01, 0x17, 0x02, // Kė (U+004B U+0117)
  0x00, 0x4B, 0x01, 0x19, 0x02, // Kę (U+004B U+0119)
  0x00, 0x4B, 0x01, 0x1B, 0x02, // Kě (U+004B U+011B)
  0x00, 0x4B, 0x01, 0x1C, 0x02, // KĜ (U+004B U+011C)
  0x00, 0x4B, 0x01, 0x1D, 0x02, // Kĝ (U+004B U+011D)
  0x00, 0x4B, 0x01, 0x1E, 0x02, // KĞ (U+004B U+011E)
  0x00, 0x4B, 0x01, 0x1F, 0x02, // Kğ (U+004B U+011F)
  0x00, 0x4B, 0x01, 0x20, 0x02, // KĠ (U+004B U+0120)
  0x00, 0x4B, 0x01, 0x21, 0x02, // Kġ (U+004B U+0121)
  0x00, 0x4B, 0x01, 0x22, 0x02, // KĢ (U+004B U+0122)
  0x00, 0x4B, 0x01, 0x23, 0x02, // Kģ (U+004B U+0123)
  0x00, 0x4B, 0x01, 0x4C, 0x02, // KŌ (U+004B U+014C)
  0x00, 0x4B, 0x01, 0x4D, 0x02, // Kō (U+004B U+014D)
  0x00, 0x4B, 0x01, 0x4E, 0x02, // KŎ (U+004B U+014E)
  0x00, 0x4B, 0x01, 0x4F, 0x02, // Kŏ (U+004B U+014F)
  0x00, 0x4B, 0x01, 0x50, 0x02, // KŐ (U+004B U+0150)
  0x00, 0x4B, 0x01, 0x51, 0x02, // Kő (U+004B U+0151)
  0x00, 0x4B, 0x01, 0x52, 0x02, // KŒ (U+004B U+0152)
  0x00, 0x4B, 0x01, 0x53, 0x02, // Kœ (U+004B U+0153)
  0x00, 0x4B, 0x01, 0x69, 0x02, // Kũ (U+004B U+0169)
  0x00, 0x4B, 0x01, 0x6B, 0x02, // Kū (U+004B U+016B)
  0x00, 0x4B, 0x01, 0x6D, 0x02, // Kŭ (U+004B U+016D)
  0x00, 0x4B, 0x01, 0x6F, 0x02, // Ků (U+004B U+016F)
  0x00, 0x4B, 0x01, 0x71, 0x02, // Kű (U+004B U+0171)
  0x00, 0x4B, 0x01, 0x73, 0x02, // Kų (U+004B U+0173)
  0x00, 0x4B, 0x01, 0x75, 0x03, // Kŵ (U+004B U+0175)
  0x00, 0x4B, 0x01, 0x77, 0x03, // Kŷ (U+004B U+0177)
  0x00, 0x4C, 0x00, 0x22, 0x05, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x05, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x07, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x06, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x55, 0x02, // LU (U+004C U+0055)
  0x00, 0x4C, 0x00, 0x56, 0x07, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x05, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x05, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0x76, 0x03, // Lv (U+004C U+0076)
  0x00, 0x4C, 0x00, 0x79, 0x01, // Ly (U+004C U+0079)
  0x00, 0x4C, 0x00, 0xD9, 0x02, // LÙ (U+004C U+00D9)
  0x00, 0x4C, 0x00, 0xDA, 0x02, // LÚ (U+004C U+00DA)
  0x00, 0x4C, 0x00, 0xDB, 0x02, // LÛ (U+004C U+00DB)
  0x00, 0x4C, 0x00, 0xDC, 0x02, // LÜ (U+004C U+00DC)
  0x00, 0x4C, 0x00, 0xDD, 0x05, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x00, 0xFD, 0x01, // Lý (U+004C U+00FD)
  0x00, 0x4C, 0x00, 0xFF, 0x01, // Lÿ (U+004C U+00FF)
  0x00, 0x4C, 0x01, 0x68, 0x02, // LŨ (U+004C U+0168)
  0x00, 0x4C, 0x01, 0x6A, 0x02, // LŪ (U+004C U+016A)
  0x00, 0x4C, 0x01, 0x6C, 0x02, // LŬ (U+004C U+016C)
  0x00, 0x4C, 0x01, 0x6E, 0x02, // LŮ (U+004C U+016E)
  0x00, 0x4C, 0x01, 0x70, 0x02, // LŰ (U+004C U+0170)
  0x00, 0x4C, 0x01, 0x72, 0x02, // LŲ (U+004C U+0172)
  0x00, 0x4C, 0x01, 0x74, 0x05, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x05, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x77, 0x01, // Lŷ (U+004C U+0177)
  0x00, 0x4C, 0x01, 0x78, 0x05, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x08, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x07, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x08, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x07, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x07, // L™ (U+004C U+2122)
  0x00, 0x4E, 0x00, 0x26, 0x02, // N& (U+004E U+0026)
  0x00, 0x4E, 0x00, 0x2C, 0x02, // N, (U+004E U+002C)
  0x00, 0x4E, 0x00, 0x2E, 0x02, // N. (U+004E U+002E)
  0x00, 0x4E, 0x20, 0x1A, 0x02, // N‚ (U+004E U+201A)
  0x00, 0x4E, 0x20, 0x1E, 0x02, // N„ (U+004E U+201E)
  0x00, 0x4E, 0x20, 0x26, 0x02, // N… (U+004E U+2026)
  0x00, 0x4F, 0x00, 0x22, 0x03, // O" (U+004F U+0022)
  0x00, 0x4F, 0x00, 0x27, 0x03, // O' (U+004F U+0027)
  0x00, 0x4F, 0x00, 0x2C, 0x02, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x02, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x41, 0x02, // OA (U+004F U+0041)
  0x00, 0x4F, 0x00, 0x54, 0x02, // OT (U+004F U+0054)
  0x00, 0x4F, 0x00, 0x56, 0x02, // OV (U+004F U+0056)
  0x00, 0x4F, 0x00, 0x57, 0x02, // OW (U+004F U+0057)
  0x00, 0x4F, 0x00, 0x58, 0x01, // OX (U+004F U+0058)
  0x00, 0x4F, 0x00, 0x59, 0x02, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0xC0, 0x02, // OÀ (U+004F U+00C0)
  0x00, 0x4F, 0x00, 0xC1, 0x02, // OÁ (U+004F U+00C1)
  0x00, 0x4F, 0x00, 0xC2, 0x02, // OÂ (U+004F U+00C2)
  0x00, 0x4F, 0x00, 0xC3, 0x02, // OÃ (U+004F U+00C3)
  0x00, 0x4F, 0x00, 0xC4, 0x02, // OÄ (U+004F U+00C4)
  0x00, 0x4F, 0x00, 0xC5, 0x02, // OÅ (U+004F U+00C5)
  0x00, 0x4F, 0x00, 0xC6, 0x04, // OÆ (U+004F U+00C6)
  0x00, 0x4F, 0x00, 0xDD, 0x02, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x00, 0x02, // OĀ (U+004F U+0100)
  0x00, 0x4F, 0x01, 0x02, 0x02, // OĂ (U+004F U+0102)
  0x00, 0x4F, 0x01, 0x04, 0x02, // OĄ (U+004F U+0104)
  0x00, 0x4F, 0x01, 0x74, 0x02, // OŴ (U+004F U+0174)
  0x00, 0x4F, 0x01, 0x76, 0x02, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x02, // OŸ (U+004F U+0178)
  0x00, 0x4F, 0x20, 0x1A, 0x02, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x02, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x02, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x26, 0x02, // P& (U+0050 U+0026)
  0x00, 0x50, 0x00, 0x2C, 0x0B, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x0B, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x05, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x05, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x05, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x05, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x05, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x05, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x05, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x07, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x05, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x05, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x05, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x0B, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x0B, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x0B, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x22, 0x03, // Q" (U+0051 U+0022)
  0x00, 0x51, 0x00, 0x27, 0x03, // Q' (U+0051 U+0027)
  0x00, 0x51, 0x00, 0x2C, 0x02, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x02, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x41, 0x02, // QA (U+0051 U+0041)
  0x00, 0x51, 0x00, 0x54, 0x02, // QT (U+0051 U+0054)
  0x00, 0x51, 0x00, 0x56, 0x02, // QV (U+0051 U+0056)
  0x00, 0x51, 0x00, 0x57, 0x02, // QW (U+0051 U+0057)
  0x00, 0x51, 0x00, 0x58, 0x01, // QX (U+0051 U+0058)
  0x00, 0x51, 0x00, 0x59, 0x02, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0xC0, 0x02, // QÀ (U+0051 U+00C0)
  0x00, 0x51, 0x00, 0xC1, 0x02, // QÁ (U+0051 U+00C1)
  0x00, 0x51, 0x00, 0xC2, 0x02, // QÂ (U+0051 U+00C2)
  0x00, 0x51, 0x00, 0xC3, 0x02, // QÃ (U+0051 U+00C3)
  0x00, 0x51, 0x00, 0xC4, 0x02, // QÄ (U+0051 U+00C4)
  0x00, 0x51, 0x00, 0xC5, 0x02, // QÅ (U+0051 U+00C5)
  0x00, 0x51, 0x00, 0xC6, 0x04, // QÆ (U+0051 U+00C6)
  0x00, 0x51, 0x00, 0xDD, 0x02, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x00, 0x02, // QĀ (U+0051 U+0100)
  0x00, 0x51, 0x01, 0x02, 0x02, // QĂ (U+0051 U+0102)
  0x00, 0x51, 0x01, 0x04, 0x02, // QĄ (U+0051 U+0104)
  0x00, 0x51, 0x01, 0x74, 0x02, // QŴ (U+0051 U+0174)
  0x00, 0x51, 0x01, 0x76, 0x02, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x02, // QŸ (U+0051 U+0178)
  0x00, 0x51, 0x20, 0x1A, 0x02, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x02, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x02, // Q… (U+0051 U+2026)
  0x00, 0x52, 0x00, 0x26, 0x02, // R& (U+0052 U+0026)
  0x00, 0x52, 0x00, 0x2A, 0x02, // R* (U+0052 U+002A)
  0x00, 0x52, 0x00, 0x43, 0x01, // RC (U+0052 U+0043)
  0x00, 0x52, 0x00, 0x47, 0x01, // RG (U+0052 U+0047)
  0x00, 0x52, 0x00, 0x4F, 0x01, // RO (U+0052 U+004F)
  0x00, 0x52, 0x00, 0x51, 0x01, // RQ (U+0052 U+0051)
  0x00, 0x52, 0x00, 0x54, 0x02, // RT (U+0052 U+0054)
  0x00, 0x52, 0x00, 0x55, 0x01, // RU (U+0052 U+0055)
  0x00, 0x52, 0x00, 0x56, 0x03, // RV (U+0052 U+0056)
  0x00, 0x52, 0x00, 0x57, 0x03, // RW (U+0052 U+0057)
  0x00, 0x52, 0x00, 0x59, 0x03, // RY (U+0052 U+0059)
  0x00, 0x52, 0x00, 0x77, 0x02, // Rw (U+0052 U+0077)
  0x00, 0x52, 0x00, 0x79, 0x02, // Ry (U+0052 U+0079)
  0x00, 0x52, 0x00, 0xC7, 0x01, // RÇ (U+0052 U+00C7)
  0x00, 0x52, 0x00, 0xD2, 0x01, // RÒ (U+0052 U+00D2)
  0x00, 0x52, 0x00, 0xD3, 0x01, // RÓ (U+0052 U+00D3)
  0x00, 0x52, 0x00, 0xD4, 0x01, // RÔ (U+0052 U+00D4)
  0x00, 0x52, 0x00, 0xD5, 0x01, // RÕ (U+0052 U+00D5)
  0x00, 0x52, 0x00, 0xD6, 0x01, // RÖ (U+0052 U+00D6)
  0x00, 0x52, 0x00, 0xD8, 0x01, // RØ (U+0052 U+00D8)
  0x00, 0x52, 0x00, 0xD9, 0x01, // RÙ (U+0052 U+00D9)
  0x00, 0x52, 0x00, 0xDA, 0x01, // RÚ (U+0052 U+00DA)
  0x00, 0x52, 0x00, 0xDB, 0x01, // RÛ (U+0052 U+00DB)
  0x00, 0x52, 0x00, 0xDC, 0x01, // RÜ (U+0052 U+00DC)
  0x00, 0x52, 0x00, 0xDD, 0x03, // RÝ (U+0052 U+00DD)
  0x00, 0x52, 0x00, 0xFD, 0x02, // Rý (U+0052 U+00FD)
  0x00, 0x52, 0x00, 0xFF, 0x02, // Rÿ (U+0052 U+00FF)
  0x00, 0x52, 0x01, 0x06, 0x01, // RĆ (U+0052 U+0106)
  0x00, 0x52, 0x01, 0x08, 0x01, // RĈ (U+0052 U+0108)
  0x00, 0x52, 0x01, 0x0A, 0x01, // RĊ (U+0052 U+010A)
  0x00, 0x52, 0x01, 0x0C, 0x01, // RČ (U+0052 U+010C)
  0x00, 0x52, 0x01, 0x1C, 0x01, // RĜ (U+0052 U+011C)
  0x00, 0x52, 0x01, 0x1E, 0x01, // RĞ (U+0052 U+011E)
  0x00, 0x52, 0x01, 0x20, 0x01, // RĠ (U+0052 U+0120)
  0x00, 0x52, 0x01, 0x22, 0x01, // RĢ (U+0052 U+0122)
  0x00, 0x52, 0x01, 0x4C, 0x01, // RŌ (U+0052 U+014C)
  0x00, 0x52, 0x01, 0x4E, 0x01, // RŎ (U+0052 U+014E)
  0x00, 0x52, 0x01, 0x50, 0x01, // RŐ (U+0052 U+0150)
  0x00, 0x52, 0x01, 0x52, 0x01, // RŒ (U+0052 U+0152)
  0x00, 0x52, 0x01, 0x68, 0x01, // RŨ (U+0052 U+0168)
  0x00, 0x52, 0x01, 0x6A, 0x01, // RŪ (U+0052 U+016A)
  0x00, 0x52, 0x01, 0x6C, 0x01, // RŬ (U+0052 U+016C)
  0x00, 0x52, 0x01, 0x6E, 0x01, // RŮ (U+0052 U+016E)
  0x00, 0x52, 0x01, 0x70, 0x01, // RŰ (U+0052 U+0170)
  0x00, 0x52, 0x01, 0x72, 0x01, // RŲ (U+0052 U+0172)
  0x00, 0x52, 0x01, 0x74, 0x03, // RŴ (U+0052 U+0174)
  0x00, 0x52, 0x01, 0x75, 0x02, // Rŵ (U+0052 U+0175)
  0x00, 0x52, 0x01, 0x76, 0x03, // RŶ (U+0052 U+0176)
  0x00, 0x52, 0x01, 0x77, 0x02, // Rŷ (U+0052 U+0177)
  0x00, 0x52, 0x01, 0x78, 0x03, // RŸ (U+0052 U+0178)
  0x00, 0x52, 0x20, 0x19, 0x02, // R’ (U+0052 U+2019)
  0x00, 0x52, 0x20, 0x1D, 0x02, // R” (U+0052 U+201D)
  0x00, 0x52, 0x21, 0x22, 0x02, // R™ (U+0052 U+2122)
  0x00, 0x53, 0x00, 0x41, 0x01, // SA (U+0053 U+0041)
  0x00, 0x53, 0x00, 0x54, 0x02, // ST (U+0053 U+0054)
  0x00, 0x53, 0x00, 0x56, 0x02, // SV (U+0053 U+0056)
  0x00, 0x53, 0x00, 0x57, 0x02, // SW (U+0053 U+0057)
  0x00, 0x53, 0x00, 0x58, 0x02, // SX (U+0053 U+0058)
  0x00, 0x53, 0x00, 0x59, 0x02, // SY (U+0053 U+0059)
  0x00, 0x53, 0x00, 0x77, 0x01, // Sw (U+0053 U+0077)
  0x00, 0x53, 0x00, 0x79, 0x02, // Sy (U+0053 U+0079)
  0x00, 0x53, 0x00, 0xC0, 0x01, // SÀ (U+0053 U+00C0)
  0x00, 0x53, 0x00, 0xC1, 0x01, // SÁ (U+0053 U+00C1)
  0x00, 0x53, 0x00, 0xC2, 0x01, // SÂ (U+0053 U+00C2)
  0x00, 0x53, 0x00, 0xC3, 0x01, // SÃ (U+0053 U+00C3)
  0x00, 0x53, 0x00, 0xC4, 0x01, // SÄ (U+0053 U+00C4)
  0x00, 0x53, 0x00, 0xC5, 0x01, // SÅ (U+0053 U+00C5)
  0x00, 0x53, 0x00, 0xC6, 0x02, // SÆ (U+0053 U+00C6)
  0x00, 0x53, 0x00, 0xDD, 0x02, // SÝ (U+0053 U+00DD)
  0x00, 0x53, 0x00, 0xFD, 0x02, // Sý (U+0053 U+00FD)
  0x00, 0x53, 0x00, 0xFF, 0x02, // Sÿ (U+0053 U+00FF)
  0x00, 0x53, 0x01, 0x00, 0x01, // SĀ (U+0053 U+0100)
  0x00, 0x53, 0x01, 0x02, 0x01, // SĂ (U+0053 U+0102)
  0x00, 0x53, 0x01, 0x04, 0x01, // SĄ (U+0053 U+0104)
  0x00, 0x53, 0x01, 0x74, 0x02, // SŴ (U+0053 U+0174)
  0x00, 0x53, 0x01, 0x75, 0x01, // Sŵ (U+0053 U+0175)
  0x00, 0x53, 0x01, 0x76, 0x02, // SŶ (U+0053 U+0176)
  0x00, 0x53, 0x01, 0x77, 0x02, // Sŷ (U+0053 U+0177)
  0x00, 0x53, 0x01, 0x78, 0x02, // SŸ (U+0053 U+0178)
  0x00, 0x54, 0x00, 0x26, 0x02, // T& (U+0054 U+0026)
  0x00, 0x54, 0x00, 0x2C, 0x07, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x07, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x05, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x43, 0x01, // TC (U+0054 U+0043)
  0x00, 0x54, 0x00, 0x47, 0x01, // TG (U+0054 U+0047)
  0x00, 0x54, 0x00, 0x4F, 0x01, // TO (U+0054 U+004F)
  0x00, 0x54, 0x00, 0x51, 0x01, // TQ (U+0054 U+0051)
  0x00, 0x54, 0x00, 0x61, 0x03, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x03, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x03, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x03, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x03, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x03, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x03, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x05, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x05, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x05, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x05, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x05, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x05, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x07, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xC7, 0x01, // TÇ (U+0054 U+00C7)
  0x00, 0x54, 0x00, 0xD2, 0x01, // TÒ (U+0054 U+00D2)
  0x00, 0x54, 0x00, 0xD3, 0x01, // TÓ (U+0054 U+00D3)
  0x00, 0x54, 0x00, 0xD4, 0x01, // TÔ (U+0054 U+00D4)
  0x00, 0x54, 0x00, 0xD5, 0x01, // TÕ (U+0054 U+00D5)
  0x00, 0x54, 0x00, 0xD6, 0x01, // TÖ (U+0054 U+00D6)
  0x00, 0x54, 0x00, 0xD8, 0x01, // TØ (U+0054 U+00D8)
  0x00, 0x54, 0x00, 0xE0, 0x03, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x03, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x03, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x03, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x03, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x03, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x03, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x03, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x03, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x03, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x03, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x03, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x03, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x03, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x03, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x03, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x03, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x03, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x03, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x05, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x03, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x05, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x03, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x05, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x03, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x06, 0x01, // TĆ (U+0054 U+0106)
  0x00, 0x54, 0x01, 0x07, 0x03, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x08, 0x01, // TĈ (U+0054 U+0108)
  0x00, 0x54, 0x01, 0x09, 0x03, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0A, 0x01, // TĊ (U+0054 U+010A)
  0x00, 0x54, 0x01, 0x0B, 0x03, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0C, 0x01, // TČ (U+0054 U+010C)
  0x00, 0x54, 0x01, 0x0D, 0x03, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x03, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x03, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x03, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x03, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x03, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x03, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x03, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1C, 0x01, // TĜ (U+0054 U+011C)
  0x00, 0x54, 0x01, 0x1D, 0x03, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1E, 0x01, // TĞ (U+0054 U+011E)
  0x00, 0x54, 0x01, 0x1F, 0x03, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x20, 0x01, // TĠ (U+0054 U+0120)
  0x00, 0x54, 0x01, 0x21, 0x03, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x22, 0x01, // TĢ (U+0054 U+0122)
  0x00, 0x54, 0x01, 0x23, 0x03, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4C, 0x01, // TŌ (U+0054 U+014C)
  0x00, 0x54, 0x01, 0x4D, 0x03, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4E, 0x01, // TŎ (U+0054 U+014E)
  0x00, 0x54, 0x01, 0x4F, 0x03, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x50, 0x01, // TŐ (U+0054 U+0150)
  0x00, 0x54, 0x01, 0x51, 0x03, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x52, 0x01, // TŒ (U+0054 U+0152)
  0x00, 0x54, 0x01, 0x53, 0x03, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x07, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x07, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x07, // T… (U+0054 U+2026)
  0x00, 0x55, 0x00, 0x26, 0x02, // U& (U+0055 U+0026)
  0x00, 0x55, 0x00, 0x2C, 0x02, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x02, // U. (U+0055 U+002E)
  0x00, 0x55, 0x00, 0x41, 0x02, // UA (U+0055 U+0041)
  0x00, 0x55, 0x00, 0xC0, 0x02, // UÀ (U+0055 U+00C0)
  0x00, 0x55, 0x00, 0xC1, 0x02, // UÁ (U+0055 U+00C1)
  0x00, 0x55, 0x00, 0xC2, 0x02, // UÂ (U+0055 U+00C2)
  0x00, 0x55, 0x00, 0xC3, 0x02, // UÃ (U+0055 U+00C3)
  0x00, 0x55, 0x00, 0xC4, 0x02, // UÄ (U+0055 U+00C4)
  0x00, 0x55, 0x00, 0xC5, 0x02, // UÅ (U+0055 U+00C5)
  0x00, 0x55, 0x00, 0xC6, 0x02, // UÆ (U+0055 U+00C6)
  0x00, 0x55, 0x01, 0x00, 0x02, // UĀ (U+0055 U+0100)
  0x00, 0x55, 0x01, 0x02, 0x02, // UĂ (U+0055 U+0102)
  0x00, 0x55, 0x01, 0x04, 0x02, // UĄ (U+0055 U+0104)
  0x00, 0x55, 0x20, 0x1A, 0x02, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x02, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x02, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x26, 0x03, // V& (U+0056 U+0026)
  0x00, 0x56, 0x00, 0x2C, 0x0A, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x0A, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x07, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x43, 0x02, // VC (U+0056 U+0043)
  0x00, 0x56, 0x00, 0x47, 0x02, // VG (U+0056 U+0047)
  0x00, 0x56, 0x00, 0x4F, 0x02, // VO (U+0056 U+004F)
  0x00, 0x56, 0x00, 0x51, 0x02, // VQ (U+0056 U+0051)
  0x00, 0x56, 0x00, 0x61, 0x05, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x05, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x05, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x05, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x05, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x05, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x05, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x04, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x07, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x07, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x07, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x07, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x07, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x07, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x0A, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xC7, 0x02, // VÇ (U+0056 U+00C7)
  0x00, 0x56, 0x00, 0xD2, 0x02, // VÒ (U+0056 U+00D2)
  0x00, 0x56, 0x00, 0xD3, 0x02, // VÓ (U+0056 U+00D3)
  0x00, 0x56, 0x00, 0xD4, 0x02, // VÔ (U+0056 U+00D4)
  0x00, 0x56, 0x00, 0xD5, 0x02, // VÕ (U+0056 U+00D5)
  0x00, 0x56, 0x00, 0xD6, 0x02, // VÖ (U+0056 U+00D6)
  0x00, 0x56, 0x00, 0xD8, 0x02, // VØ (U+0056 U+00D8)
  0x00, 0x56, 0x00, 0xE0, 0x05, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x05, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x05, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x05, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x05, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x05, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x05, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x05, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x05, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x05, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x05, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x05, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x05, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x05, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x05, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x05, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x05, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x05, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x05, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x07, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x05, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x07, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x05, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x07, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x05, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x06, 0x02, // VĆ (U+0056 U+0106)
  0x00, 0x56, 0x01, 0x07, 0x05, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x08, 0x02, // VĈ (U+0056 U+0108)
  0x00, 0x56, 0x01, 0x09, 0x05, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0A, 0x02, // VĊ (U+0056 U+010A)
  0x00, 0x56, 0x01, 0x0B, 0x05, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0C, 0x02, // VČ (U+0056 U+010C)
  0x00, 0x56, 0x01, 0x0D, 0x05, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x05, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x05, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x05, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x05, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x05, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x05, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x05, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1C, 0x02, // VĜ (U+0056 U+011C)
  0x00, 0x56, 0x01, 0x1D, 0x05, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1E, 0x02, // VĞ (U+0056 U+011E)
  0x00, 0x56, 0x01, 0x1F, 0x05, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x20, 0x02, // VĠ (U+0056 U+0120)
  0x00, 0x56, 0x01, 0x21, 0x05, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x22, 0x02, // VĢ (U+0056 U+0122)
  0x00, 0x56, 0x01, 0x23, 0x05, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4C, 0x02, // VŌ (U+0056 U+014C)
  0x00, 0x56, 0x01, 0x4D, 0x05, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4E, 0x02, // VŎ (U+0056 U+014E)
  0x00, 0x56, 0x01, 0x4F, 0x05, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x50, 0x02, // VŐ (U+0056 U+0150)
  0x00, 0x56, 0x01, 0x51, 0x05, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x52, 0x02, // VŒ (U+0056 U+0152)
  0x00, 0x56, 0x01, 0x53, 0x05, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x04, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x04, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x04, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x04, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x0A, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x0A, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x0A, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x26, 0x03, // W& (U+0057 U+0026)
  0x00, 0x57, 0x00, 0x2C, 0x08, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x08, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x05, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x43, 0x02, // WC (U+0057 U+0043)
  0x00, 0x57, 0x00, 0x47, 0x02, // WG (U+0057 U+0047)
  0x00, 0x57, 0x00, 0x4F, 0x02, // WO (U+0057 U+004F)
  0x00, 0x57, 0x00, 0x51, 0x02, // WQ (U+0057 U+0051)
  0x00, 0x57, 0x00, 0x61, 0x05, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x05, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x05, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x05, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x05, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x05, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x05, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x03, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0x78, 0x02, // Wx (U+0057 U+0078)
  0x00, 0x57, 0x00, 0xC0, 0x05, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x05, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x05, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x05, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x05, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x05, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x0C, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xC7, 0x02, // WÇ (U+0057 U+00C7)
  0x00, 0x57, 0x00, 0xD2, 0x02, // WÒ (U+0057 U+00D2)
  0x00, 0x57, 0x00, 0xD3, 0x02, // WÓ (U+0057 U+00D3)
  0x00, 0x57, 0x00, 0xD4, 0x02, // WÔ (U+0057 U+00D4)
  0x00, 0x57, 0x00, 0xD5, 0x02, // WÕ (U+0057 U+00D5)
  0x00, 0x57, 0x00, 0xD6, 0x02, // WÖ (U+0057 U+00D6)
  0x00, 0x57, 0x00, 0xD8, 0x02, // WØ (U+0057 U+00D8)
  0x00, 0x57, 0x00, 0xE0, 0x05, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x05, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x05, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x05, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x05, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x05, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x05, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x05, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x05, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x05, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x05, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x05, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x05, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x05, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x05, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x05, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x05, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x05, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x05, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x05, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x05, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x05, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x05, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x05, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x05, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x06, 0x02, // WĆ (U+0057 U+0106)
  0x00, 0x57, 0x01, 0x07, 0x05, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x08, 0x02, // WĈ (U+0057 U+0108)
  0x00, 0x57, 0x01, 0x09, 0x05, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0A, 0x02, // WĊ (U+0057 U+010A)
  0x00, 0x57, 0x01, 0x0B, 0x05, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0C, 0x02, // WČ (U+0057 U+010C)
  0x00, 0x57, 0x01, 0x0D, 0x05, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x05, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x05, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x05, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x05, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x05, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x05, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x05, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1C, 0x02, // WĜ (U+0057 U+011C)
  0x00, 0x57, 0x01, 0x1D, 0x05, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1E, 0x02, // WĞ (U+0057 U+011E)
  0x00, 0x57, 0x01, 0x1F, 0x05, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x20, 0x02, // WĠ (U+0057 U+0120)
  0x00, 0x57, 0x01, 0x21, 0x05, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x22, 0x02, // WĢ (U+0057 U+0122)
  0x00, 0x57, 0x01, 0x23, 0x05, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4C, 0x02, // WŌ (U+0057 U+014C)
  0x00, 0x57, 0x01, 0x4D, 0x05, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4E, 0x02, // WŎ (U+0057 U+014E)
  0x00, 0x57, 0x01, 0x4F, 0x05, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x50, 0x02, // WŐ (U+0057 U+0150)
  0x00, 0x57, 0x01, 0x51, 0x05, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x52, 0x02, // WŒ (U+0057 U+0152)
  0x00, 0x57, 0x01, 0x53, 0x05, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x03, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x03, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x03, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x03, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x20, 0x1A, 0x08, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x08, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x08, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x43, 0x01, // XC (U+0058 U+0043)
  0x00, 0x58, 0x00, 0x47, 0x01, // XG (U+0058 U+0047)
  0x00, 0x58, 0x00, 0x4F, 0x01, // XO (U+0058 U+004F)
  0x00, 0x58, 0x00, 0x51, 0x01, // XQ (U+0058 U+0051)
  0x00, 0x58, 0x00, 0x53, 0x01, // XS (U+0058 U+0053)
  0x00, 0x58, 0x00, 0x63, 0x01, // Xc (U+0058 U+0063)
  0x00, 0x58, 0x00, 0x64, 0x01, // Xd (U+0058 U+0064)
  0x00, 0x58, 0x00, 0x65, 0x01, // Xe (U+0058 U+0065)
  0x00, 0x58, 0x00, 0x67, 0x01, // Xg (U+0058 U+0067)
  0x00, 0x58, 0x00, 0x6F, 0x01, // Xo (U+0058 U+006F)
  0x00, 0x58, 0x00, 0x71, 0x01, // Xq (U+0058 U+0071)
  0x00, 0x58, 0x00, 0x77, 0x03, // Xw (U+0058 U+0077)
  0x00, 0x58, 0x00, 0x79, 0x05, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xA9, 0x04, // X© (U+0058 U+00A9)
  0x00, 0x58, 0x00, 0xAE, 0x04, // X® (U+0058 U+00AE)
  0x00, 0x58, 0x00, 0xC7, 0x01, // XÇ (U+0058 U+00C7)
  0x00, 0x58, 0x00, 0xD2, 0x01, // XÒ (U+0058 U+00D2)
  0x00, 0x58, 0x00, 0xD3, 0x01, // XÓ (U+0058 U+00D3)
  0x00, 0x58, 0x00, 0xD4, 0x01, // XÔ (U+0058 U+00D4)
  0x00, 0x58, 0x00, 0xD5, 0x01, // XÕ (U+0058 U+00D5)
  0x00, 0x58, 0x00, 0xD6, 0x01, // XÖ (U+0058 U+00D6)
  0x00, 0x58, 0x00, 0xD8, 0x01, // XØ (U+0058 U+00D8)
  0x00, 0x58, 0x00, 0xE7, 0x01, // Xç (U+0058 U+00E7)
  0x00, 0x58, 0x00, 0xE8, 0x01, // Xè (U+0058 U+00E8)
  0x00, 0x58, 0x00, 0xE9, 0x01, // Xé (U+0058 U+00E9)
  0x00, 0x58, 0x00, 0xEA, 0x01, // Xê (U+0058 U+00EA)
  0x00, 0x58, 0x00, 0xEB, 0x01, // Xë (U+0058 U+00EB)
  0x00, 0x58, 0x00, 0xF0, 0x01, // Xð (U+0058 U+00F0)
  0x00, 0x58, 0x00, 0xF2, 0x01, // Xò (U+0058 U+00F2)
  0x00, 0x58, 0x00, 0xF3, 0x01, // Xó (U+0058 U+00F3)
  0x00, 0x58, 0x00, 0xF4, 0x01, // Xô (U+0058 U+00F4)
  0x00, 0x58, 0x00, 0xF5, 0x01, // Xõ (U+0058 U+00F5)
  0x00, 0x58, 0x00, 0xF6, 0x01, // Xö (U+0058 U+00F6)
  0x00, 0x58, 0x00, 0xF8, 0x01, // Xø (U+0058 U+00F8)
  0x00, 0x58, 0x00, 0xFD, 0x05, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x05, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x06, 0x01, // XĆ (U+0058 U+0106)
  0x00, 0x58, 0x01, 0x07, 0x01, // Xć (U+0058 U+0107)
  0x00, 0x58, 0x01, 0x08, 0x01, // XĈ (U+0058 U+0108)
  0x00, 0x58, 0x01, 0x09, 0x01, // Xĉ (U+0058 U+0109)
  0x00, 0x58, 0x01, 0x0A, 0x01, // XĊ (U+0058 U+010A)
  0x00, 0x58, 0x01, 0x0B, 0x01, // Xċ (U+0058 U+010B)
  0x00, 0x58, 0x01, 0x0C, 0x01, // XČ (U+0058 U+010C)
  0x00, 0x58, 0x01, 0x0D, 0x01, // Xč (U+0058 U+010D)
  0x00, 0x58, 0x01, 0x0F, 0x01, // Xď (U+0058 U+010F)
  0x00, 0x58, 0x01, 0x11, 0x01, // Xđ (U+0058 U+0111)
  0x00, 0x58, 0x01, 0x13, 0x01, // Xē (U+0058 U+0113)
  0x00, 0x58, 0x01, 0x15, 0x01, // Xĕ (U+0058 U+0115)
  0x00, 0x58, 0x01, 0x17, 0x01, // Xė (U+0058 U+0117)
  0x00, 0x58, 0x01, 0x19, 0x01, // Xę (U+0058 U+0119)
  0x00, 0x58, 0x01, 0x1B, 0x01, // Xě (U+0058 U+011B)
  0x00, 0x58, 0x01, 0x1C, 0x01, // XĜ (U+0058 U+011C)
  0x00, 0x58, 0x01, 0x1D, 0x01, // Xĝ (U+0058 U+011D)
  0x00, 0x58, 0x01, 0x1E, 0x01, // XĞ (U+0058 U+011E)
  0x00, 0x58, 0x01, 0x1F, 0x01, // Xğ (U+0058 U+011F)
  0x00, 0x58, 0x01, 0x20, 0x01, // XĠ (U+0058 U+0120)
  0x00, 0x58, 0x01, 0x21, 0x01, // Xġ (U+0058 U+0121)
  0x00, 0x58, 0x01, 0x22, 0x01, // XĢ (U+0058 U+0122)
  0x00, 0x58, 0x01, 0x23, 0x01, // Xģ (U+0058 U+0123)
  0x00, 0x58, 0x01, 0x4C, 0x01, // XŌ (U+0058 U+014C)
  0x00, 0x58, 0x01, 0x4D, 0x01, // Xō (U+0058 U+014D)
  0x00, 0x58, 0x01, 0x4E, 0x01, // XŎ (U+0058 U+014E)
  0x00, 0x58, 0x01, 0x4F, 0x01, // Xŏ (U+0058 U+014F)
  0x00, 0x58, 0x01, 0x50, 0x01, // XŐ (U+0058 U+0150)
  0x00, 0x58, 0x01, 0x51, 0x01, // Xő (U+0058 U+0151)
  0x00, 0x58, 0x01, 0x52, 0x01, // XŒ (U+0058 U+0152)
  0x00, 0x58, 0x01, 0x53, 0x01, // Xœ (U+0058 U+0153)
  0x00, 0x58, 0x01, 0x5A, 0x01, // XŚ (U+0058 U+015A)
  0x00, 0x58, 0x01, 0x5C, 0x01, // XŜ (U+0058 U+015C)
  0x00, 0x58, 0x01, 0x5E, 0x01, // XŞ (U+0058 U+015E)
  0x00, 0x58, 0x01, 0x60, 0x01, // XŠ (U+0058 U+0160)
  0x00, 0x58, 0x01, 0x75, 0x03, // Xŵ (U+0058 U+0175)
  0x00, 0x58, 0x01, 0x77, 0x05, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x26, 0x03, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x07, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x07, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x06, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x02, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x02, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x02, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x02, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x53, 0x02, // YS (U+0059 U+0053)
  0x00, 0x59, 0x00, 0x61, 0x05, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x06, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x06, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x06, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x06, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x06, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x06, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x05, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x78, 0x01, // Yx (U+0059 U+0078)
  0x00, 0x59, 0x00, 0x7A, 0x02, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xC0, 0x06, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x06, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x06, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x06, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x06, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x06, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x08, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xC7, 0x02, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x02, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x02, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x02, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x02, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x02, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x02, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x05, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x05, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x05, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x05, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x05, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x05, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x05, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x06, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x06, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x06, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x06, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x06, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x06, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x06, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x06, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x06, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x06, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x06, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x06, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x06, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x05, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x06, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x05, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x06, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x05, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x02, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x06, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x02, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x06, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x02, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x06, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x02, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x06, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x06, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x06, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x06, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x06, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x06, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x06, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x06, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x02, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x06, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x02, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x06, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x02, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x06, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x02, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x06, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4C, 0x02, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x06, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x02, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x06, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x02, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x06, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x02, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x06, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5A, 0x02, // YŚ (U+0059 U+015A)
  0x00, 0x59, 0x01, 0x5B, 0x05, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5C, 0x02, // YŜ (U+0059 U+015C)
  0x00, 0x59, 0x01, 0x5D, 0x05, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5E, 0x02, // YŞ (U+0059 U+015E)
  0x00, 0x59, 0x01, 0x5F, 0x05, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x60, 0x02, // YŠ (U+0059 U+0160)
  0x00, 0x59, 0x01, 0x61, 0x05, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x01, 0x7A, 0x02, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x02, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x02, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x07, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x07, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x07, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x04, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x04, // a' (U+0061 U+0027)
  0x00, 0x61, 0x00, 0x2A, 0x01, // a* (U+0061 U+002A)
  0x00, 0x61, 0x00, 0x54, 0x02, // aT (U+0061 U+0054)
  0x00, 0x61, 0x00, 0x56, 0x05, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x57, 0x04, // aW (U+0061 U+0057)
  0x00, 0x61, 0x00, 0x59, 0x05, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0x79, 0x01, // ay (U+0061 U+0079)
  0x00, 0x61, 0x00, 0xDD, 0x05, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x00, 0xFD, 0x01, // aý (U+0061 U+00FD)
  0x00, 0x61, 0x00, 0xFF, 0x01, // aÿ (U+0061 U+00FF)
  0x00, 0x61, 0x01, 0x74, 0x04, // aŴ (U+0061 U+0174)
  0x00, 0x61, 0x01, 0x76, 0x05, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x77, 0x01, // aŷ (U+0061 U+0177)
  0x00, 0x61, 0x01, 0x78, 0x05, // aŸ (U+0061 U+0178)
  0x00, 0x61, 0x20, 0x18, 0x03, // a‘ (U+0061 U+2018)
  0x00, 0x61, 0x20, 0x19, 0x01, // a’ (U+0061 U+2019)
  0x00, 0x61, 0x20, 0x1C, 0x03, // a“ (U+0061 U+201C)
  0x00, 0x61, 0x20, 0x1D, 0x01, // a” (U+0061 U+201D)
  0x00, 0x61, 0x21, 0x22, 0x01, // a™ (U+0061 U+2122)
  0x00, 0x62, 0x00, 0x41, 0x01, // bA (U+0062 U+0041)
  0x00, 0x62, 0x00, 0x54, 0x03, // bT (U+0062 U+0054)
  0x00, 0x62, 0x00, 0x56, 0x05, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x05, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x06, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0x78, 0x01, // bx (U+0062 U+0078)
  0x00, 0x62, 0x00, 0x79, 0x01, // by (U+0062 U+0079)
  0x00, 0x62, 0x00, 0xC0, 0x01, // bÀ (U+0062 U+00C0)
  0x00, 0x62, 0x00, 0xC1, 0x01, // bÁ (U+0062 U+00C1)
  0x00, 0x62, 0x00, 0xC2, 0x01, // bÂ (U+0062 U+00C2)
  0x00, 0x62, 0x00, 0xC3, 0x01, // bÃ (U+0062 U+00C3)
  0x00, 0x62, 0x00, 0xC4, 0x01, // bÄ (U+0062 U+00C4)
  0x00, 0x62, 0x00, 0xC5, 0x01, // bÅ (U+0062 U+00C5)
  0x00, 0x62, 0x00, 0xDD, 0x06, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x00, 0xFD, 0x01, // bý (U+0062 U+00FD)
  0x00, 0x62, 0x00, 0xFF, 0x01, // bÿ (U+0062 U+00FF)
  0x00, 0x62, 0x01, 0x00, 0x01, // bĀ (U+0062 U+0100)
  0x00, 0x62, 0x01, 0x02, 0x01, // bĂ (U+0062 U+0102)
  0x00, 0x62, 0x01, 0x04, 0x01, // bĄ (U+0062 U+0104)
  0x00, 0x62, 0x01, 0x74, 0x05, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x06, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x77, 0x01, // bŷ (U+0062 U+0177)
  0x00, 0x62, 0x01, 0x78, 0x06, // bŸ (U+0062 U+0178)
  0x00, 0x63, 0x00, 0x56, 0x05, // cV (U+0063 U+0056)
  0x00, 0x63, 0x00, 0x57, 0x05, // cW (U+0063 U+0057)
  0x00, 0x63, 0x00, 0x59, 0x05, // cY (U+0063 U+0059)
  0x00, 0x63, 0x00, 0xDD, 0x05, // cÝ (U+0063 U+00DD)
  0x00, 0x63, 0x01, 0x74, 0x05, // cŴ (U+0063 U+0174)
  0x00, 0x63, 0x01, 0x76, 0x05, // cŶ (U+0063 U+0176)
  0x00, 0x63, 0x01, 0x78, 0x05, // cŸ (U+0063 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x05, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x05, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x05, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x05, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x05, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x05, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x05, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x22, 0x04, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x04, // h' (U+0068 U+0027)
  0x00, 0x68, 0x00, 0x2A, 0x01, // h* (U+0068 U+002A)
  0x00, 0x68, 0x00, 0x54, 0x02, // hT (U+0068 U+0054)
  0x00, 0x68, 0x00, 0x56, 0x05, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x57, 0x04, // hW (U+0068 U+0057)
  0x00, 0x68, 0x00, 0x59, 0x05, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0x79, 0x01, // hy (U+0068 U+0079)
  0x00, 0x68, 0x00, 0xDD, 0x05, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x00, 0xFD, 0x01, // hý (U+0068 U+00FD)
  0x00, 0x68, 0x00, 0xFF, 0x01, // hÿ (U+0068 U+00FF)
  0x00, 0x68, 0x01, 0x74, 0x04, // hŴ (U+0068 U+0174)
  0x00, 0x68, 0x01, 0x76, 0x05, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x77, 0x01, // hŷ (U+0068 U+0177)
  0x00, 0x68, 0x01, 0x78, 0x05, // hŸ (U+0068 U+0178)
  0x00, 0x68, 0x20, 0x18, 0x03, // h‘ (U+0068 U+2018)
  0x00, 0x68, 0x20, 0x19, 0x01, // h’ (U+0068 U+2019)
  0x00, 0x68, 0x20, 0x1C, 0x03, // h“ (U+0068 U+201C)
  0x00, 0x68, 0x20, 0x1D, 0x01, // h” (U+0068 U+201D)
  0x00, 0x68, 0x21, 0x22, 0x01, // h™ (U+0068 U+2122)
  0x00, 0x6B, 0x00, 0x63, 0x01, // kc (U+006B U+0063)
  0x00, 0x6B, 0x00, 0x64, 0x01, // kd (U+006B U+0064)
  0x00, 0x6B, 0x00, 0x65, 0x01, // ke (U+006B U+0065)
  0x00, 0x6B, 0x00, 0x67, 0x01, // kg (U+006B U+0067)
  0x00, 0x6B, 0x00, 0x6F, 0x01, // ko (U+006B U+006F)
  0x00, 0x6B, 0x00, 0x71, 0x01, // kq (U+006B U+0071)
  0x00, 0x6B, 0x00, 0xE7, 0x01, // kç (U+006B U+00E7)
  0x00, 0x6B, 0x00, 0xE8, 0x01, // kè (U+006B U+00E8)
  0x00, 0x6B, 0x00, 0xE9, 0x01, // ké (U+006B U+00E9)
  0x00, 0x6B, 0x00, 0xEA, 0x01, // kê (U+006B U+00EA)
  0x00, 0x6B, 0x00, 0xEB, 0x01, // kë (U+006B U+00EB)
  0x00, 0x6B, 0x00, 0xF0, 0x01, // kð (U+006B U+00F0)
  0x00, 0x6B, 0x00, 0xF2, 0x01, // kò (U+006B U+00F2)
  0x00, 0x6B, 0x00, 0xF3, 0x01, // kó (U+006B U+00F3)
  0x00, 0x6B, 0x00, 0xF4, 0x01, // kô (U+006B U+00F4)
  0x00, 0x6B, 0x00, 0xF5, 0x01, // kõ (U+006B U+00F5)
  0x00, 0x6B, 0x00, 0xF6, 0x01, // kö (U+006B U+00F6)
  0x00, 0x6B, 0x00, 0xF8, 0x01, // kø (U+006B U+00F8)
  0x00, 0x6B, 0x01, 0x07, 0x01, // kć (U+006B U+0107)
  0x00, 0x6B, 0x01, 0x09, 0x01, // kĉ (U+006B U+0109)
  0x00, 0x6B, 0x01, 0x0B, 0x01, // kċ (U+006B U+010B)
  0x00, 0x6B, 0x01, 0x0D, 0x01, // kč (U+006B U+010D)
  0x00, 0x6B, 0x01, 0x0F, 0x01, // kď (U+006B U+010F)
  0x00, 0x6B, 0x01, 0x11, 0x01, // kđ (U+006B U+0111)
  0x00, 0x6B, 0x01, 0x13, 0x01, // kē (U+006B U+0113)
  0x00, 0x6B, 0x01, 0x15, 0x01, // kĕ (U+006B U+0115)
  0x00, 0x6B, 0x01, 0x17, 0x01, // kė (U+006B U+0117)
  0x00, 0x6B, 0x01, 0x19, 0x01, // kę (U+006B U+0119)
  0x00, 0x6B, 0x01, 0x1B, 0x01, // kě (U+006B U+011B)
  0x00, 0x6B, 0x01, 0x1D, 0x01, // kĝ (U+006B U+011D)
  0x00, 0x6B, 0x01, 0x1F, 0x01, // kğ (U+006B U+011F)
  0x00, 0x6B, 0x01, 0x21, 0x01, // kġ (U+006B U+0121)
  0x00, 0x6B, 0x01, 0x23, 0x01, // kģ (U+006B U+0123)
  0x00, 0x6B, 0x01, 0x4D, 0x01, // kō (U+006B U+014D)
  0x00, 0x6B, 0x01, 0x4F, 0x01, // kŏ (U+006B U+014F)
  0x00, 0x6B, 0x01, 0x51, 0x01, // kő (U+006B U+0151)
  0x00, 0x6B, 0x01, 0x53, 0x01, // kœ (U+006B U+0153)
  0x00, 0x6D, 0x00, 0x22, 0x04, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x04, // m' (U+006D U+0027)
  0x00, 0x6D, 0x00, 0x2A, 0x01, // m* (U+006D U+002A)
  0x00, 0x6D, 0x00, 0x54, 0x02, // mT (U+006D U+0054)
  0x00, 0x6D, 0x00, 0x56, 0x05, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x57, 0x04, // mW (U+006D U+0057)
  0x00, 0x6D, 0x00, 0x59, 0x05, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0x79, 0x01, // my (U+006D U+0079)
  0x00, 0x6D, 0x00, 0xDD, 0x05, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x00, 0xFD, 0x01, // mý (U+006D U+00FD)
  0x00, 0x6D, 0x00, 0xFF, 0x01, // mÿ (U+006D U+00FF)
  0x00, 0x6D, 0x01, 0x74, 0x04, // mŴ (U+006D U+0174)
  0x00, 0x6D, 0x01, 0x76, 0x05, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x77, 0x01, // mŷ (U+006D U+0177)
  0x00, 0x6D, 0x01, 0x78, 0x05, // mŸ (U+006D U+0178)
  0x00, 0x6D, 0x20, 0x18, 0x03, // m‘ (U+006D U+2018)
  0x00, 0x6D, 0x20, 0x19, 0x01, // m’ (U+006D U+2019)
  0x00, 0x6D, 0x20, 0x1C, 0x03, // m“ (U+006D U+201C)
  0x00, 0x6D, 0x20, 0x1D, 0x01, // m” (U+006D U+201D)
  0x00, 0x6D, 0x21, 0x22, 0x01, // m™ (U+006D U+2122)
  0x00, 0x6E, 0x00, 0x22, 0x04, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x04, // n' (U+006E U+0027)
  0x00, 0x6E, 0x00, 0x2A, 0x01, // n* (U+006E U+002A)
  0x00, 0x6E, 0x00, 0x54, 0x02, // nT (U+006E U+0054)
  0x00, 0x6E, 0x00, 0x56, 0x05, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x57, 0x04, // nW (U+006E U+0057)
  0x00, 0x6E, 0x00, 0x59, 0x05, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0x79, 0x01, // ny (U+006E U+0079)
  0x00, 0x6E, 0x00, 0xDD, 0x05, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x00, 0xFD, 0x01, // ný (U+006E U+00FD)
  0x00, 0x6E, 0x00, 0xFF, 0x01, // nÿ (U+006E U+00FF)
  0x00, 0x6E, 0x01, 0x74, 0x04, // nŴ (U+006E U+0174)
  0x00, 0x6E, 0x01, 0x76, 0x05, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x77, 0x01, // nŷ (U+006E U+0177)
  0x00, 0x6E, 0x01, 0x78, 0x05, // nŸ (U+006E U+0178)
  0x00, 0x6E, 0x20, 0x18, 0x03, // n‘ (U+006E U+2018)
  0x00, 0x6E, 0x20, 0x19, 0x01, // n’ (U+006E U+2019)
  0x00, 0x6E, 0x20, 0x1C, 0x03, // n“ (U+006E U+201C)
  0x00, 0x6E, 0x20, 0x1D, 0x01, // n” (U+006E U+201D)
  0x00, 0x6E, 0x21, 0x22, 0x01, // n™ (U+006E U+2122)
  0x00, 0x6F, 0x00, 0x41, 0x01, // oA (U+006F U+0041)
  0x00, 0x6F, 0x00, 0x54, 0x03, // oT (U+006F U+0054)
  0x00, 0x6F, 0x00, 0x56, 0x05, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x05, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x06, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0x78, 0x01, // ox (U+006F U+0078)
  0x00, 0x6F, 0x00, 0x79, 0x01, // oy (U+006F U+0079)
  0x00, 0x6F, 0x00, 0xC0, 0x01, // oÀ (U+006F U+00C0)
  0x00, 0x6F, 0x00, 0xC1, 0x01, // oÁ (U+006F U+00C1)
  0x00, 0x6F, 0x00, 0xC2, 0x01, // oÂ (U+006F U+00C2)
  0x00, 0x6F, 0x00, 0xC3, 0x01, // oÃ (U+006F U+00C3)
  0x00, 0x6F, 0x00, 0xC4, 0x01, // oÄ (U+006F U+00C4)
  0x00, 0x6F, 0x00, 0xC5, 0x01, // oÅ (U+006F U+00C5)
  0x00, 0x6F, 0x00, 0xDD, 0x06, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x00, 0xFD, 0x01, // oý (U+006F U+00FD)
  0x00, 0x6F, 0x00, 0xFF, 0x01, // oÿ (U+006F U+00FF)
  0x00, 0x6F, 0x01, 0x00, 0x01, // oĀ (U+006F U+0100)
  0x00, 0x6F, 0x01, 0x02, 0x01, // oĂ (U+006F U+0102)
  0x00, 0x6F, 0x01, 0x04, 0x01, // oĄ (U+006F U+0104)
  0x00, 0x6F, 0x01, 0x74, 0x05, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x06, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x77, 0x01, // oŷ (U+006F U+0177)
  0x00, 0x6F, 0x01, 0x78, 0x06, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x41, 0x01, // pA (U+0070 U+0041)
  0x00, 0x70, 0x00, 0x54, 0x03, // pT (U+0070 U+0054)
  0x00, 0x70, 0x00, 0x56, 0x05, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x05, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x06, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0x78, 0x01, // px (U+0070 U+0078)
  0x00, 0x70, 0x00, 0x79, 0x01, // py (U+0070 U+0079)
  0x00, 0x70, 0x00, 0xC0, 0x01, // pÀ (U+0070 U+00C0)
  0x00, 0x70, 0x00, 0xC1, 0x01, // pÁ (U+0070 U+00C1)
  0x00, 0x70, 0x00, 0xC2, 0x01, // pÂ (U+0070 U+00C2)
  0x00, 0x70, 0x00, 0xC3, 0x01, // pÃ (U+0070 U+00C3)
  0x00, 0x70, 0x00, 0xC4, 0x01, // pÄ (U+0070 U+00C4)
  0x00, 0x70, 0x00, 0xC5, 0x01, // pÅ (U+0070 U+00C5)
  0x00, 0x70, 0x00, 0xDD, 0x06, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x00, 0xFD, 0x01, // pý (U+0070 U+00FD)
  0x00, 0x70, 0x00, 0xFF, 0x01, // pÿ (U+0070 U+00FF)
  0x00, 0x70, 0x01, 0x00, 0x01, // pĀ (U+0070 U+0100)
  0x00, 0x70, 0x01, 0x02, 0x01, // pĂ (U+0070 U+0102)
  0x00, 0x70, 0x01, 0x04, 0x01, // pĄ (U+0070 U+0104)
  0x00, 0x70, 0x01, 0x74, 0x05, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x06, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x77, 0x01, // pŷ (U+0070 U+0177)
  0x00, 0x70, 0x01, 0x78, 0x06, // pŸ (U+0070 U+0178)
  0x00, 0x71, 0x00, 0x56, 0x01, // qV (U+0071 U+0056)
  0x00, 0x71, 0x00, 0x57, 0x04, // qW (U+0071 U+0057)
  0x00, 0x71, 0x00, 0x59, 0x02, // qY (U+0071 U+0059)
  0x00, 0x71, 0x00, 0xDD, 0x02, // qÝ (U+0071 U+00DD)
  0x00, 0x71, 0x01, 0x74, 0x04, // qŴ (U+0071 U+0174)
  0x00, 0x71, 0x01, 0x76, 0x02, // qŶ (U+0071 U+0176)
  0x00, 0x71, 0x01, 0x78, 0x02, // qŸ (U+0071 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x0D, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x0D, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x56, 0x03, // rV (U+0072 U+0056)
  0x00, 0x72, 0x00, 0x57, 0x04, // rW (U+0072 U+0057)
  0x00, 0x72, 0x00, 0x58, 0x05, // rX (U+0072 U+0058)
  0x00, 0x72, 0x00, 0x59, 0x03, // rY (U+0072 U+0059)
  0x00, 0x72, 0x00, 0x61, 0x02, // ra (U+0072 U+0061)
  0x00, 0x72, 0x00, 0x63, 0x02, // rc (U+0072 U+0063)
  0x00, 0x72, 0x00, 0x64, 0x02, // rd (U+0072 U+0064)
  0x00, 0x72, 0x00, 0x65, 0x02, // re (U+0072 U+0065)
  0x00, 0x72, 0x00, 0x67, 0x02, // rg (U+0072 U+0067)
  0x00, 0x72, 0x00, 0x6F, 0x02, // ro (U+0072 U+006F)
  0x00, 0x72, 0x00, 0x71, 0x02, // rq (U+0072 U+0071)
  0x00, 0x72, 0x00, 0x78, 0x01, // rx (U+0072 U+0078)
  0x00, 0x72, 0x00, 0xDD, 0x03, // rÝ (U+0072 U+00DD)
  0x00, 0x72, 0x00, 0xE0, 0x02, // rà (U+0072 U+00E0)
  0x00, 0x72, 0x00, 0xE1, 0x02, // rá (U+0072 U+00E1)
  0x00, 0x72, 0x00, 0xE2, 0x02, // râ (U+0072 U+00E2)
  0x00, 0x72, 0x00, 0xE3, 0x02, // rã (U+0072 U+00E3)
  0x00, 0x72, 0x00, 0xE4, 0x02, // rä (U+0072 U+00E4)
  0x00, 0x72, 0x00, 0xE5, 0x02, // rå (U+0072 U+00E5)
  0x00, 0x72, 0x00, 0xE6, 0x02, // ræ (U+0072 U+00E6)
  0x00, 0x72, 0x00, 0xE7, 0x02, // rç (U+0072 U+00E7)
  0x00, 0x72, 0x00, 0xE8, 0x02, // rè (U+0072 U+00E8)
  0x00, 0x72, 0x00, 0xE9, 0x02, // ré (U+0072 U+00E9)
  0x00, 0x72, 0x00, 0xEA, 0x02, // rê (U+0072 U+00EA)
  0x00, 0x72, 0x00, 0xEB, 0x02, // rë (U+0072 U+00EB)
  0x00, 0x72, 0x00, 0xF0, 0x02, // rð (U+0072 U+00F0)
  0x00, 0x72, 0x00, 0xF2, 0x02, // rò (U+0072 U+00F2)
  0x00, 0x72, 0x00, 0xF3, 0x02, // ró (U+0072 U+00F3)
  0x00, 0x72, 0x00, 0xF4, 0x02, // rô (U+0072 U+00F4)
  0x00, 0x72, 0x00, 0xF5, 0x02, // rõ (U+0072 U+00F5)
  0x00, 0x72, 0x00, 0xF6, 0x02, // rö (U+0072 U+00F6)
  0x00, 0x72, 0x00, 0xF8, 0x02, // rø (U+0072 U+00F8)
  0x00, 0x72, 0x01, 0x01, 0x02, // rā (U+0072 U+0101)
  0x00, 0x72, 0x01, 0x03, 0x02, // ră (U+0072 U+0103)
  0x00, 0x72, 0x01, 0x05, 0x02, // rą (U+0072 U+0105)
  0x00, 0x72, 0x01, 0x07, 0x02, // rć (U+0072 U+0107)
  0x00, 0x72, 0x01, 0x09, 0x02, // rĉ (U+0072 U+0109)
  0x00, 0x72, 0x01, 0x0B, 0x02, // rċ (U+0072 U+010B)
  0x00, 0x72, 0x01, 0x0D, 0x02, // rč (U+0072 U+010D)
  0x00, 0x72, 0x01, 0x0F, 0x02, // rď (U+0072 U+010F)
  0x00, 0x72, 0x01, 0x11, 0x02, // rđ (U+0072 U+0111)
  0x00, 0x72, 0x01, 0x13, 0x02, // rē (U+0072 U+0113)
  0x00, 0x72, 0x01, 0x15, 0x02, // rĕ (U+0072 U+0115)
  0x00, 0x72, 0x01, 0x17, 0x02, // rė (U+0072 U+0117)
  0x00, 0x72, 0x01, 0x19, 0x02, // rę (U+0072 U+0119)
  0x00, 0x72, 0x01, 0x1B, 0x02, // rě (U+0072 U+011B)
  0x00, 0x72, 0x01, 0x1D, 0x02, // rĝ (U+0072 U+011D)
  0x00, 0x72, 0x01, 0x1F, 0x02, // rğ (U+0072 U+011F)
  0x00, 0x72, 0x01, 0x21, 0x02, // rġ (U+0072 U+0121)
  0x00, 0x72, 0x01, 0x23, 0x02, // rģ (U+0072 U+0123)
  0x00, 0x72, 0x01, 0x4D, 0x02, // rō (U+0072 U+014D)
  0x00, 0x72, 0x01, 0x4F, 0x02, // rŏ (U+0072 U+014F)
  0x00, 0x72, 0x01, 0x51, 0x02, // rő (U+0072 U+0151)
  0x00, 0x72, 0x01, 0x53, 0x02, // rœ (U+0072 U+0153)
  0x00, 0x72, 0x01, 0x74, 0x04, // rŴ (U+0072 U+0174)
  0x00, 0x72, 0x01, 0x76, 0x03, // rŶ (U+0072 U+0176)
  0x00, 0x72, 0x01, 0x78, 0x03, // rŸ (U+0072 U+0178)
  0x00, 0x72, 0x20, 0x1A, 0x0D, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x0D, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x0D, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x22, 0x02, // s" (U+0073 U+0022)
  0x00, 0x73, 0x00, 0x27, 0x02, // s' (U+0073 U+0027)
  0x00, 0x73, 0x00, 0x56, 0x03, // sV (U+0073 U+0056)
  0x00, 0x73, 0x00, 0x57, 0x03, // sW (U+0073 U+0057)
  0x00, 0x73, 0x00, 0x59, 0x05, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x05, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x74, 0x03, // sŴ (U+0073 U+0174)
  0x00, 0x73, 0x01, 0x76, 0x05, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x05, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x05, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x06, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x02, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0x56, 0x03, // vV (U+0076 U+0056)
  0x00, 0x76, 0x00, 0x57, 0x02, // vW (U+0076 U+0057)
  0x00, 0x76, 0x00, 0x59, 0x03, // vY (U+0076 U+0059)
  0x00, 0x76, 0x00, 0xC0, 0x02, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x02, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x02, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x02, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x02, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x02, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x00, 0xDD, 0x03, // vÝ (U+0076 U+00DD)
  0x00, 0x76, 0x01, 0x00, 0x02, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x02, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x02, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x01, 0x74, 0x02, // vŴ (U+0076 U+0174)
  0x00, 0x76, 0x01, 0x76, 0x03, // vŶ (U+0076 U+0176)
  0x00, 0x76, 0x01, 0x78, 0x03, // vŸ (U+0076 U+0178)
  0x00, 0x76, 0x20, 0x1A, 0x06, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x06, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x06, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x06, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x06, // w. (U+0077 U+002E)
  0x00, 0x77, 0x00, 0x41, 0x01, // wA (U+0077 U+0041)
  0x00, 0x77, 0x00, 0x56, 0x02, // wV (U+0077 U+0056)
  0x00, 0x77, 0x00, 0x57, 0x02, // wW (U+0077 U+0057)
  0x00, 0x77, 0x00, 0x59, 0x03, // wY (U+0077 U+0059)
  0x00, 0x77, 0x00, 0xC0, 0x01, // wÀ (U+0077 U+00C0)
  0x00, 0x77, 0x00, 0xC1, 0x01, // wÁ (U+0077 U+00C1)
  0x00, 0x77, 0x00, 0xC2, 0x01, // wÂ (U+0077 U+00C2)
  0x00, 0x77, 0x00, 0xC3, 0x01, // wÃ (U+0077 U+00C3)
  0x00, 0x77, 0x00, 0xC4, 0x01, // wÄ (U+0077 U+00C4)
  0x00, 0x77, 0x00, 0xC5, 0x01, // wÅ (U+0077 U+00C5)
  0x00, 0x77, 0x00, 0xDD, 0x03, // wÝ (U+0077 U+00DD)
  0x00, 0x77, 0x01, 0x00, 0x01, // wĀ (U+0077 U+0100)
  0x00, 0x77, 0x01, 0x02, 0x01, // wĂ (U+0077 U+0102)
  0x00, 0x77, 0x01, 0x04, 0x01, // wĄ (U+0077 U+0104)
  0x00, 0x77, 0x01, 0x74, 0x02, // wŴ (U+0077 U+0174)
  0x00, 0x77, 0x01, 0x76, 0x03, // wŶ (U+0077 U+0176)
  0x00, 0x77, 0x01, 0x78, 0x03, // wŸ (U+0077 U+0178)
  0x00, 0x77, 0x20, 0x1A, 0x06, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x06, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x06, // w… (U+0077 U+2026)
  0x00, 0x78, 0x00, 0x57, 0x01, // xW (U+0078 U+0057)
  0x00, 0x78, 0x00, 0x59, 0x01, // xY (U+0078 U+0059)
  0x00, 0x78, 0x00, 0x63, 0x01, // xc (U+0078 U+0063)
  0x00, 0x78, 0x00, 0x64, 0x01, // xd (U+0078 U+0064)
  0x00, 0x78, 0x00, 0x65, 0x01, // xe (U+0078 U+0065)
  0x00, 0x78, 0x00, 0x67, 0x01, // xg (U+0078 U+0067)
  0x00, 0x78, 0x00, 0x6F, 0x01, // xo (U+0078 U+006F)
  0x00, 0x78, 0x00, 0x71, 0x01, // xq (U+0078 U+0071)
  0x00, 0x78, 0x00, 0xDD, 0x01, // xÝ (U+0078 U+00DD)
  0x00, 0x78, 0x00, 0xE7, 0x01, // xç (U+0078 U+00E7)
  0x00, 0x78, 0x00, 0xE8, 0x01, // xè (U+0078 U+00E8)
  0x00, 0x78, 0x00, 0xE9, 0x01, // xé (U+0078 U+00E9)
  0x00, 0x78, 0x00, 0xEA, 0x01, // xê (U+0078 U+00EA)
  0x00, 0x78, 0x00, 0xEB, 0x01, // xë (U+0078 U+00EB)
  0x00, 0x78, 0x00, 0xF0, 0x01, // xð (U+0078 U+00F0)
  0x00, 0x78, 0x00, 0xF2, 0x01, // xò (U+0078 U+00F2)
  0x00, 0x78, 0x00, 0xF3, 0x01, // xó (U+0078 U+00F3)
  0x00, 0x78, 0x00, 0xF4, 0x01, // xô (U+0078 U+00F4)
  0x00, 0x78, 0x00, 0xF5, 0x01, // xõ (U+0078 U+00F5)
  0x00, 0x78, 0x00, 0xF6, 0x01, // xö (U+0078 U+00F6)
  0x00, 0x78, 0x00, 0xF8, 0x01, // xø (U+0078 U+00F8)
  0x00, 0x78, 0x01, 0x07, 0x01, // xć (U+0078 U+0107)
  0x00, 0x78, 0x01, 0x09, 0x01, // xĉ (U+0078 U+0109)
  0x00, 0x78, 0x01, 0x0B, 0x01, // xċ (U+0078 U+010B)
  0x00, 0x78, 0x01, 0x0D, 0x01, // xč (U+0078 U+010D)
  0x00, 0x78, 0x01, 0x0F, 0x01, // xď (U+0078 U+010F)
  0x00, 0x78, 0x01, 0x11, 0x01, // xđ (U+0078 U+0111)
  0x00, 0x78, 0x01, 0x13, 0x01, // xē (U+0078 U+0113)
  0x00, 0x78, 0x01, 0x15, 0x01, // xĕ (U+0078 U+0115)
  0x00, 0x78, 0x01, 0x17, 0x01, // xė (U+0078 U+0117)
  0x00, 0x78, 0x01, 0x19, 0x01, // xę (U+0078 U+0119)
  0x00, 0x78, 0x01, 0x1B, 0x01, // xě (U+0078 U+011B)
  0x00, 0x78, 0x01, 0x1D, 0x01, // xĝ (U+0078 U+011D)
  0x00, 0x78, 0x01, 0x1F, 0x01, // xğ (U+0078 U+011F)
  0x00, 0x78, 0x01, 0x21, 0x01, // xġ (U+0078 U+0121)
  0x00, 0x78, 0x01, 0x23, 0x01, // xģ (U+0078 U+0123)
  0x00, 0x78, 0x01, 0x4D, 0x01, // xō (U+0078 U+014D)
  0x00, 0x78, 0x01, 0x4F, 0x01, // xŏ (U+0078 U+014F)
  0x00, 0x78, 0x01, 0x51, 0x01, // xő (U+0078 U+0151)
  0x00, 0x78, 0x01, 0x53, 0x01, // xœ (U+0078 U+0153)
  0x00, 0x78, 0x01, 0x74, 0x01, // xŴ (U+0078 U+0174)
  0x00, 0x78, 0x01, 0x76, 0x01, // xŶ (U+0078 U+0176)
  0x00, 0x78, 0x01, 0x78, 0x01, // xŸ (U+0078 U+0178)
  0x00, 0x79, 0x00, 0x2C, 0x06, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x06, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x01, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0x56, 0x01, // yV (U+0079 U+0056)
  0x00, 0x79, 0x00, 0x57, 0x02, // yW (U+0079 U+0057)
  0x00, 0x79, 0x00, 0x59, 0x02, // yY (U+0079 U+0059)
  0x00, 0x79, 0x00, 0xC0, 0x01, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x01, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x01, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x01, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x01, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x01, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x00, 0xDD, 0x02, // yÝ (U+0079 U+00DD)
  0x00, 0x79, 0x01, 0x00, 0x01, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x01, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x01, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x01, 0x74, 0x02, // yŴ (U+0079 U+0174)
  0x00, 0x79, 0x01, 0x76, 0x02, // yŶ (U+0079 U+0176)
  0x00, 0x79, 0x01, 0x78, 0x02, // yŸ (U+0079 U+0178)
  0x00, 0x79, 0x20, 0x1A, 0x06, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x06, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x06, // y… (U+0079 U+2026)
  0x00, 0x7A, 0x00, 0x2A, 0x02, // z* (U+007A U+002A)
  0x00, 0x7A, 0x00, 0x56, 0x04, // zV (U+007A U+0056)
  0x00, 0x7A, 0x00, 0x57, 0x03, // zW (U+007A U+0057)
  0x00, 0x7A, 0x00, 0x59, 0x03, // zY (U+007A U+0059)
  0x00, 0x7A, 0x00, 0xDD, 0x03, // zÝ (U+007A U+00DD)
  0x00, 0x7A, 0x01, 0x74, 0x03, // zŴ (U+007A U+0174)
  0x00, 0x7A, 0x01, 0x76, 0x03, // zŶ (U+007A U+0176)
  0x00, 0x7A, 0x01, 0x78, 0x03, // zŸ (U+007A U+0178)
  0x00, 0x7A, 0x20, 0x18, 0x02, // z‘ (U+007A U+2018)
  0x00, 0x7A, 0x20, 0x19, 0x02, // z’ (U+007A U+2019)
  0x00, 0x7A, 0x20, 0x1C, 0x02, // z“ (U+007A U+201C)
  0x00, 0x7A, 0x20, 0x1D, 0x02, // z” (U+007A U+201D)
  0x00, 0x7A, 0x21, 0x22, 0x02, // z™ (U+007A U+2122)
  0x00, 0xA1, 0x00, 0x54, 0x02, // ¡T (U+00A1 U+0054)
  0x00, 0xA1, 0x00, 0x55, 0x01, // ¡U (U+00A1 U+0055)
  0x00, 0xA1, 0x00, 0x56, 0x05, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x57, 0x02, // ¡W (U+00A1 U+0057)
  0x00, 0xA1, 0x00, 0x59, 0x05, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xD9, 0x01, // ¡Ù (U+00A1 U+00D9)
  0x00, 0xA1, 0x00, 0xDA, 0x01, // ¡Ú (U+00A1 U+00DA)
  0x00, 0xA1, 0x00, 0xDB, 0x01, // ¡Û (U+00A1 U+00DB)
  0x00, 0xA1, 0x00, 0xDC, 0x01, // ¡Ü (U+00A1 U+00DC)
  0x00, 0xA1, 0x00, 0xDD, 0x05, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x68, 0x01, // ¡Ũ (U+00A1 U+0168)
  0x00, 0xA1, 0x01, 0x6A, 0x01, // ¡Ū (U+00A1 U+016A)
  0x00, 0xA1, 0x01, 0x6C, 0x01, // ¡Ŭ (U+00A1 U+016C)
  0x00, 0xA1, 0x01, 0x6E, 0x01, // ¡Ů (U+00A1 U+016E)
  0x00, 0xA1, 0x01, 0x70, 0x01, // ¡Ű (U+00A1 U+0170)
  0x00, 0xA1, 0x01, 0x72, 0x01, // ¡Ų (U+00A1 U+0172)
  0x00, 0xA1, 0x01, 0x74, 0x02, // ¡Ŵ (U+00A1 U+0174)
  0x00, 0xA1, 0x01, 0x76, 0x05, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x05, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x03, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x55, 0x01, // ¿U (U+00BF U+0055)
  0x00, 0xBF, 0x00, 0x56, 0x05, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x05, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x05, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xD9, 0x01, // ¿Ù (U+00BF U+00D9)
  0x00, 0xBF, 0x00, 0xDA, 0x01, // ¿Ú (U+00BF U+00DA)
  0x00, 0xBF, 0x00, 0xDB, 0x01, // ¿Û (U+00BF U+00DB)
  0x00, 0xBF, 0x00, 0xDC, 0x01, // ¿Ü (U+00BF U+00DC)
  0x00, 0xBF, 0x00, 0xDD, 0x05, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x68, 0x01, // ¿Ũ (U+00BF U+0168)
  0x00, 0xBF, 0x01, 0x6A, 0x01, // ¿Ū (U+00BF U+016A)
  0x00, 0xBF, 0x01, 0x6C, 0x01, // ¿Ŭ (U+00BF U+016C)
  0x00, 0xBF, 0x01, 0x6E, 0x01, // ¿Ů (U+00BF U+016E)
  0x00, 0xBF, 0x01, 0x70, 0x01, // ¿Ű (U+00BF U+0170)
  0x00, 0xBF, 0x01, 0x72, 0x01, // ¿Ų (U+00BF U+0172)
  0x00, 0xBF, 0x01, 0x74, 0x05, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x05, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x05, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x07, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x26, 0x02, // À& (U+00C0 U+0026)
  0x00, 0xC0, 0x00, 0x27, 0x07, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x08, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x43, 0x02, // ÀC (U+00C0 U+0043)
  0x00, 0xC0, 0x00, 0x47, 0x02, // ÀG (U+00C0 U+0047)
  0x00, 0xC0, 0x00, 0x4F, 0x02, // ÀO (U+00C0 U+004F)
  0x00, 0xC0, 0x00, 0x51, 0x02, // ÀQ (U+00C0 U+0051)
  0x00, 0xC0, 0x00, 0x54, 0x05, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x55, 0x02, // ÀU (U+00C0 U+0055)
  0x00, 0xC0, 0x00, 0x56, 0x07, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x06, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x06, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x63, 0x01, // Àc (U+00C0 U+0063)
  0x00, 0xC0, 0x00, 0x64, 0x01, // Àd (U+00C0 U+0064)
  0x00, 0xC0, 0x00, 0x65, 0x01, // Àe (U+00C0 U+0065)
  0x00, 0xC0, 0x00, 0x67, 0x01, // Àg (U+00C0 U+0067)
  0x00, 0xC0, 0x00, 0x6F, 0x01, // Ào (U+00C0 U+006F)
  0x00, 0xC0, 0x00, 0x71, 0x01, // Àq (U+00C0 U+0071)
  0x00, 0xC0, 0x00, 0x75, 0x02, // Àu (U+00C0 U+0075)
  0x00, 0xC0, 0x00, 0x76, 0x05, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x77, 0x03, // Àw (U+00C0 U+0077)
  0x00, 0xC0, 0x00, 0x79, 0x04, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xA9, 0x05, // À© (U+00C0 U+00A9)
  0x00, 0xC0, 0x00, 0xAE, 0x05, // À® (U+00C0 U+00AE)
  0x00, 0xC0, 0x00, 0xC7, 0x02, // ÀÇ (U+00C0 U+00C7)
  0x00, 0xC0, 0x00, 0xD2, 0x02, // ÀÒ (U+00C0 U+00D2)
  0x00, 0xC0, 0x00, 0xD3, 0x02, // ÀÓ (U+00C0 U+00D3)
  0x00, 0xC0, 0x00, 0xD4, 0x02, // ÀÔ (U+00C0 U+00D4)
  0x00, 0xC0, 0x00, 0xD5, 0x02, // ÀÕ (U+00C0 U+00D5)
  0x00, 0xC0, 0x00, 0xD6, 0x02, // ÀÖ (U+00C0 U+00D6)
  0x00, 0xC0, 0x00, 0xD8, 0x02, // ÀØ (U+00C0 U+00D8)
  0x00, 0xC0, 0x00, 0xD9, 0x02, // ÀÙ (U+00C0 U+00D9)
  0x00, 0xC0, 0x00, 0xDA, 0x02, // ÀÚ (U+00C0 U+00DA)
  0x00, 0xC0, 0x00, 0xDB, 0x02, // ÀÛ (U+00C0 U+00DB)
  0x00, 0xC0, 0x00, 0xDC, 0x02, // ÀÜ (U+00C0 U+00DC)
  0x00, 0xC0, 0x00, 0xDD, 0x06, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xE7, 0x01, // Àç (U+00C0 U+00E7)
  0x00, 0xC0, 0x00, 0xE8, 0x01, // Àè (U+00C0 U+00E8)
  0x00, 0xC0, 0x00, 0xE9, 0x01, // Àé (U+00C0 U+00E9)
  0x00, 0xC0, 0x00, 0xEA, 0x01, // Àê (U+00C0 U+00EA)
  0x00, 0xC0, 0x00, 0xEB, 0x01, // Àë (U+00C0 U+00EB)
  0x00, 0xC0, 0x00, 0xF0, 0x01, // Àð (U+00C0 U+00F0)
  0x00, 0xC0, 0x00, 0xF2, 0x01, // Àò (U+00C0 U+00F2)
  0x00, 0xC0, 0x00, 0xF3, 0x01, // Àó (U+00C0 U+00F3)
  0x00, 0xC0, 0x00, 0xF4, 0x01, // Àô (U+00C0 U+00F4)
  0x00, 0xC0, 0x00, 0xF5, 0x01, // Àõ (U+00C0 U+00F5)
  0x00, 0xC0, 0x00, 0xF6, 0x01, // Àö (U+00C0 U+00F6)
  0x00, 0xC0, 0x00, 0xF8, 0x01, // Àø (U+00C0 U+00F8)
  0x00, 0xC0, 0x00, 0xF9, 0x02, // Àù (U+00C0 U+00F9)
  0x00, 0xC0, 0x00, 0xFA, 0x02, // Àú (U+00C0 U+00FA)
  0x00, 0xC0, 0x00, 0xFB, 0x02, // Àû (U+00C0 U+00FB)
  0x00, 0xC0, 0x00, 0xFC, 0x02, // Àü (U+00C0 U+00FC)
  0x00, 0xC0, 0x00, 0xFD, 0x04, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x04, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x06, 0x02, // ÀĆ (U+00C0 U+0106)
  0x00, 0xC0, 0x01, 0x07, 0x01, // Àć (U+00C0 U+0107)
  0x00, 0xC0, 0x01, 0x08, 0x02, // ÀĈ (U+00C0 U+0108)
  0x00, 0xC0, 0x01, 0x09, 0x01, // Àĉ (U+00C0 U+0109)
  0x00, 0xC0, 0x01, 0x0A, 0x02, // ÀĊ (U+00C0 U+010A)
  0x00, 0xC0, 0x01, 0x0B, 0x01, // Àċ (U+00C0 U+010B)
  0x00, 0xC0, 0x01, 0x0C, 0x02, // ÀČ (U+00C0 U+010C)
  0x00, 0xC0, 0x01, 0x0D, 0x01, // Àč (U+00C0 U+010D)
  0x00, 0xC0, 0x01, 0x0F, 0x01, // Àď (U+00C0 U+010F)
  0x00, 0xC0, 0x01, 0x11, 0x01, // Àđ (U+00C0 U+0111)
  0x00, 0xC0, 0x01, 0x13, 0x01, // Àē (U+00C0 U+0113)
  0x00, 0xC0, 0x01, 0x15, 0x01, // Àĕ (U+00C0 U+0115)
  0x00, 0xC0, 0x01, 0x17, 0x01, // Àė (U+00C0 U+0117)
  0x00, 0xC0, 0x01, 0x19, 0x01, // Àę (U+00C0 U+0119)
  0x00, 0xC0, 0x01, 0x1B, 0x01, // Àě (U+00C0 U+011B)
  0x00, 0xC0, 0x01, 0x1C, 0x02, // ÀĜ (U+00C0 U+011C)
  0x00, 0xC0, 0x01, 0x1D, 0x01, // Àĝ (U+00C0 U+011D)
  0x00, 0xC0, 0x01, 0x1E, 0x02, // ÀĞ (U+00C0 U+011E)
  0x00, 0xC0, 0x01, 0x1F, 0x01, // Àğ (U+00C0 U+011F)
  0x00, 0xC0, 0x01, 0x20, 0x02, // ÀĠ (U+00C0 U+0120)
  0x00, 0xC0, 0x01, 0x21, 0x01, // Àġ (U+00C0 U+0121)
  0x00, 0xC0, 0x01, 0x22, 0x02, // ÀĢ (U+00C0 U+0122)
  0x00, 0xC0, 0x01, 0x23, 0x01, // Àģ (U+00C0 U+0123)
  0x00, 0xC0, 0x01, 0x49, 0x05, // Àŉ (U+00C0 U+0149)
  0x00, 0xC0, 0x01, 0x4C, 0x02, // ÀŌ (U+00C0 U+014C)
  0x00, 0xC0, 0x01, 0x4D, 0x01, // Àō (U+00C0 U+014D)
  0x00, 0xC0, 0x01, 0x4E, 0x02, // ÀŎ (U+00C0 U+014E)
  0x00, 0xC0, 0x01, 0x4F, 0x01, // Àŏ (U+00C0 U+014F)
  0x00, 0xC0, 0x01, 0x50, 0x02, // ÀŐ (U+00C0 U+0150)
  0x00, 0xC0, 0x01, 0x51, 0x01, // Àő (U+00C0 U+0151)
  0x00, 0xC0, 0x01, 0x52, 0x02, // ÀŒ (U+00C0 U+0152)
  0x00, 0xC0, 0x01, 0x53, 0x01, // Àœ (U+00C0 U+0153)
  0x00, 0xC0, 0x01, 0x68, 0x02, // ÀŨ (U+00C0 U+0168)
  0x00, 0xC0, 0x01, 0x69, 0x02, // Àũ (U+00C0 U+0169)
  0x00, 0xC0, 0x01, 0x6A, 0x02, // ÀŪ (U+00C0 U+016A)
  0x00, 0xC0, 0x01, 0x6B, 0x02, // Àū (U+00C0 U+016B)
  0x00, 0xC0, 0x01, 0x6C, 0x02, // ÀŬ (U+00C0 U+016C)
  0x00, 0xC0, 0x01, 0x6D, 0x02, // Àŭ (U+00C0 U+016D)
  0x00, 0xC0, 0x01, 0x6E, 0x02, // ÀŮ (U+00C0 U+016E)
  0x00, 0xC0, 0x01, 0x6F, 0x02, // Àů (U+00C0 U+016F)
  0x00, 0xC0, 0x01, 0x70, 0x02, // ÀŰ (U+00C0 U+0170)
  0x00, 0xC0, 0x01, 0x71, 0x02, // Àű (U+00C0 U+0171)
  0x00, 0xC0, 0x01, 0x72, 0x02, // ÀŲ (U+00C0 U+0172)
  0x00, 0xC0, 0x01, 0x73, 0x02, // Àų (U+00C0 U+0173)
  0x00, 0xC0, 0x01, 0x74, 0x06, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x75, 0x03, // Àŵ (U+00C0 U+0175)
  0x00, 0xC0, 0x01, 0x76, 0x06, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x04, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x06, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x08, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x08, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x08, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x08, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x08, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x07, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x26, 0x02, // Á& (U+00C1 U+0026)
  0x00, 0xC1, 0x00, 0x27, 0x07, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x08, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x43, 0x02, // ÁC (U+00C1 U+0043)
  0x00, 0xC1, 0x00, 0x47, 0x02, // ÁG (U+00C1 U+0047)
  0x00, 0xC1, 0x00, 0x4F, 0x02, // ÁO (U+00C1 U+004F)
  0x00, 0xC1, 0x00, 0x51, 0x02, // ÁQ (U+00C1 U+0051)
  0x00, 0xC1, 0x00, 0x54, 0x05, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x55, 0x02, // ÁU (U+00C1 U+0055)
  0x00, 0xC1, 0x00, 0x56, 0x07, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x06, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x06, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x63, 0x01, // Ác (U+00C1 U+0063)
  0x00, 0xC1, 0x00, 0x64, 0x01, // Ád (U+00C1 U+0064)
  0x00, 0xC1, 0x00, 0x65, 0x01, // Áe (U+00C1 U+0065)
  0x00, 0xC1, 0x00, 0x67, 0x01, // Ág (U+00C1 U+0067)
  0x00, 0xC1, 0x00, 0x6F, 0x01, // Áo (U+00C1 U+006F)
  0x00, 0xC1, 0x00, 0x71, 0x01, // Áq (U+00C1 U+0071)
  0x00, 0xC1, 0x00, 0x75, 0x02, // Áu (U+00C1 U+0075)
  0x00, 0xC1, 0x00, 0x76, 0x05, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x77, 0x03, // Áw (U+00C1 U+0077)
  0x00, 0xC1, 0x00, 0x79, 0x04, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xA9, 0x05, // Á© (U+00C1 U+00A9)
  0x00, 0xC1, 0x00, 0xAE, 0x05, // Á® (U+00C1 U+00AE)
  0x00, 0xC1, 0x00, 0xC7, 0x02, // ÁÇ (U+00C1 U+00C7)
  0x00, 0xC1, 0x00, 0xD2, 0x02, // ÁÒ (U+00C1 U+00D2)
  0x00, 0xC1, 0x00, 0xD3, 0x02, // ÁÓ (U+00C1 U+00D3)
  0x00, 0xC1, 0x00, 0xD4, 0x02, // ÁÔ (U+00C1 U+00D4)
  0x00, 0xC1, 0x00, 0xD5, 0x02, // ÁÕ (U+00C1 U+00D5)
  0x00, 0xC1, 0x00, 0xD6, 0x02, // ÁÖ (U+00C1 U+00D6)
  0x00, 0xC1, 0x00, 0xD8, 0x02, // ÁØ (U+00C1 U+00D8)
  0x00, 0xC1, 0x00, 0xD9, 0x02, // ÁÙ (U+00C1 U+00D9)
  0x00, 0xC1, 0x00, 0xDA, 0x02, // ÁÚ (U+00C1 U+00DA)
  0x00, 0xC1, 0x00, 0xDB, 0x02, // ÁÛ (U+00C1 U+00DB)
  0x00, 0xC1, 0x00, 0xDC, 0x02, // ÁÜ (U+00C1 U+00DC)
  0x00, 0xC1, 0x00, 0xDD, 0x06, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xE7, 0x01, // Áç (U+00C1 U+00E7)
  0x00, 0xC1, 0x00, 0xE8, 0x01, // Áè (U+00C1 U+00E8)
  0x00, 0xC1, 0x00, 0xE9, 0x01, // Áé (U+00C1 U+00E9)
  0x00, 0xC1, 0x00, 0xEA, 0x01, // Áê (U+00C1 U+00EA)
  0x00, 0xC1, 0x00, 0xEB, 0x01, // Áë (U+00C1 U+00EB)
  0x00, 0xC1, 0x00, 0xF0, 0x01, // Áð (U+00C1 U+00F0)
  0x00, 0xC1, 0x00, 0xF2, 0x01, // Áò (U+00C1 U+00F2)
  0x00, 0xC1, 0x00, 0xF3, 0x01, // Áó (U+00C1 U+00F3)
  0x00, 0xC1, 0x00, 0xF4, 0x01, // Áô (U+00C1 U+00F4)
  0x00, 0xC1, 0x00, 0xF5, 0x01, // Áõ (U+00C1 U+00F5)
  0x00, 0xC1, 0x00, 0xF6, 0x01, // Áö (U+00C1 U+00F6)
  0x00, 0xC1, 0x00, 0xF8, 0x01, // Áø (U+00C1 U+00F8)
  0x00, 0xC1, 0x00, 0xF9, 0x02, // Áù (U+00C1 U+00F9)
  0x00, 0xC1, 0x00, 0xFA, 0x02, // Áú (U+00C1 U+00FA)
  0x00, 0xC1, 0x00, 0xFB, 0x02, // Áû (U+00C1 U+00FB)
  0x00, 0xC1, 0x00, 0xFC, 0x02, // Áü (U+00C1 U+00FC)
  0x00, 0xC1, 0x00, 0xFD, 0x04, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x04, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x06, 0x02, // ÁĆ (U+00C1 U+0106)
  0x00, 0xC1, 0x01, 0x07, 0x01, // Áć (U+00C1 U+0107)
  0x00, 0xC1, 0x01, 0x08, 0x02, // ÁĈ (U+00C1 U+0108)
  0x00, 0xC1, 0x01, 0x09, 0x01, // Áĉ (U+00C1 U+0109)
  0x00, 0xC1, 0x01, 0x0A, 0x02, // ÁĊ (U+00C1 U+010A)
  0x00, 0xC1, 0x01, 0x0B, 0x01, // Áċ (U+00C1 U+010B)
  0x00, 0xC1, 0x01, 0x0C, 0x02, // ÁČ (U+00C1 U+010C)
  0x00, 0xC1, 0x01, 0x0D, 0x01, // Áč (U+00C1 U+010D)
  0x00, 0xC1, 0x01, 0x0F, 0x01, // Áď (U+00C1 U+010F)
  0x00, 0xC1, 0x01, 0x11, 0x01, // Áđ (U+00C1 U+0111)
  0x00, 0xC1, 0x01, 0x13, 0x01, // Áē (U+00C1 U+0113)
  0x00, 0xC1, 0x01, 0x15, 0x01, // Áĕ (U+00C1 U+0115)
  0x00, 0xC1, 0x01, 0x17, 0x01, // Áė (U+00C1 U+0117)
  0x00, 0xC1, 0x01, 0x19, 0x01, // Áę (U+00C1 U+0119)
  0x00, 0xC1, 0x01, 0x1B, 0x01, // Áě (U+00C1 U+011B)
  0x00, 0xC1, 0x01, 0x1C, 0x02, // ÁĜ (U+00C1 U+011C)
  0x00, 0xC1, 0x01, 0x1D, 0x01, // Áĝ (U+00C1 U+011D)
  0x00, 0xC1, 0x01, 0x1E, 0x02, // ÁĞ (U+00C1 U+011E)
  0x00, 0xC1, 0x01, 0x1F, 0x01, // Áğ (U+00C1 U+011F)
  0x00, 0xC1, 0x01, 0x20, 0x02, // ÁĠ (U+00C1 U+0120)
  0x00, 0xC1, 0x01, 0x21, 0x01, // Áġ (U+00C1 U+0121)
  0x00, 0xC1, 0x01, 0x22, 0x02, // ÁĢ (U+00C1 U+0122)
  0x00, 0xC1, 0x01, 0x23, 0x01, // Áģ (U+00C1 U+0123)
  0x00, 0xC1, 0x01, 0x49, 0x05, // Áŉ (U+00C1 U+0149)
  0x00, 0xC1, 0x01, 0x4C, 0x02, // ÁŌ (U+00C1 U+014C)
  0x00, 0xC1, 0x01, 0x4D, 0x01, // Áō (U+00C1 U+014D)
  0x00, 0xC1, 0x01, 0x4E, 0x02, // ÁŎ (U+00C1 U+014E)
  0x00, 0xC1, 0x01, 0x4F, 0x01, // Áŏ (U+00C1 U+014F)
  0x00, 0xC1, 0x01, 0x50, 0x02, // ÁŐ (U+00C1 U+0150)
  0x00, 0xC1, 0x01, 0x51, 0x01, // Áő (U+00C1 U+0151)
  0x00, 0xC1, 0x01, 0x52, 0x02, // ÁŒ (U+00C1 U+0152)
  0x00, 0xC1, 0x01, 0x53, 0x01, // Áœ (U+00C1 U+0153)
  0x00, 0xC1, 0x01, 0x68, 0x02, // ÁŨ (U+00C1 U+0168)
  0x00, 0xC1, 0x01, 0x69, 0x02, // Áũ (U+00C1 U+0169)
  0x00, 0xC1, 0x01, 0x6A, 0x02, // ÁŪ (U+00C1 U+016A)
  0x00, 0xC1, 0x01, 0x6B, 0x02, // Áū (U+00C1 U+016B)
  0x00, 0xC1, 0x01, 0x6C, 0x02, // ÁŬ (U+00C1 U+016C)
  0x00, 0xC1, 0x01, 0x6D, 0x02, // Áŭ (U+00C1 U+016D)
  0x00, 0xC1, 0x01, 0x6E, 0x02, // ÁŮ (U+00C1 U+016E)
  0x00, 0xC1, 0x01, 0x6F, 0x02, // Áů (U+00C1 U+016F)
  0x00, 0xC1, 0x01, 0x70, 0x02, // ÁŰ (U+00C1 U+0170)
  0x00, 0xC1, 0x01, 0x71, 0x02, // Áű (U+00C1 U+0171)
  0x00, 0xC1, 0x01, 0x72, 0x02, // ÁŲ (U+00C1 U+0172)
  0x00, 0xC1, 0x01, 0x73, 0x02, // Áų (U+00C1 U+0173)
  0x00, 0xC1, 0x01, 0x74, 0x06, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x75, 0x03, // Áŵ (U+00C1 U+0175)
  0x00, 0xC1, 0x01, 0x76, 0x06, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x04, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x06, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x08, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x08, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x08, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x08, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x08, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x07, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x26, 0x02, // Â& (U+00C2 U+0026)
  0x00, 0xC2, 0x00, 0x27, 0x07, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x08, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x43, 0x02, // ÂC (U+00C2 U+0043)
  0x00, 0xC2, 0x00, 0x47, 0x02, // ÂG (U+00C2 U+0047)
  0x00, 0xC2, 0x00, 0x4F, 0x02, // ÂO (U+00C2 U+004F)
  0x00, 0xC2, 0x00, 0x51, 0x02, // ÂQ (U+00C2 U+0051)
  0x00, 0xC2, 0x00, 0x54, 0x05, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x55, 0x02, // ÂU (U+00C2 U+0055)
  0x00, 0xC2, 0x00, 0x56, 0x07, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x06, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x06, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x63, 0x01, // Âc (U+00C2 U+0063)
  0x00, 0xC2, 0x00, 0x64, 0x01, // Âd (U+00C2 U+0064)
  0x00, 0xC2, 0x00, 0x65, 0x01, // Âe (U+00C2 U+0065)
  0x00, 0xC2, 0x00, 0x67, 0x01, // Âg (U+00C2 U+0067)
  0x00, 0xC2, 0x00, 0x6F, 0x01, // Âo (U+00C2 U+006F)
  0x00, 0xC2, 0x00, 0x71, 0x01, // Âq (U+00C2 U+0071)
  0x00, 0xC2, 0x00, 0x75, 0x02, // Âu (U+00C2 U+0075)
  0x00, 0xC2, 0x00, 0x76, 0x05, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x77, 0x03, // Âw (U+00C2 U+0077)
  0x00, 0xC2, 0x00, 0x79, 0x04, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xA9, 0x05, // Â© (U+00C2 U+00A9)
  0x00, 0xC2, 0x00, 0xAE, 0x05, // Â® (U+00C2 U+00AE)
  0x00, 0xC2, 0x00, 0xC7, 0x02, // ÂÇ (U+00C2 U+00C7)
  0x00, 0xC2, 0x00, 0xD2, 0x02, // ÂÒ (U+00C2 U+00D2)
  0x00, 0xC2, 0x00, 0xD3, 0x02, // ÂÓ (U+00C2 U+00D3)
  0x00, 0xC2, 0x00, 0xD4, 0x02, // ÂÔ (U+00C2 U+00D4)
  0x00, 0xC2, 0x00, 0xD5, 0x02, // ÂÕ (U+00C2 U+00D5)
  0x00, 0xC2, 0x00, 0xD6, 0x02, // ÂÖ (U+00C2 U+00D6)
  0x00, 0xC2, 0x00, 0xD8, 0x02, // ÂØ (U+00C2 U+00D8)
  0x00, 0xC2, 0x00, 0xD9, 0x02, // ÂÙ (U+00C2 U+00D9)
  0x00, 0xC2, 0x00, 0xDA, 0x02, // ÂÚ (U+00C2 U+00DA)
  0x00, 0xC2, 0x00, 0xDB, 0x02, // ÂÛ (U+00C2 U+00DB)
  0x00, 0xC2, 0x00, 0xDC, 0x02, // ÂÜ (U+00C2 U+00DC)
  0x00, 0xC2, 0x00, 0xDD, 0x06, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xE7, 0x01, // Âç (U+00C2 U+00E7)
  0x00, 0xC2, 0x00, 0xE8, 0x01, // Âè (U+00C2 U+00E8)
  0x00, 0xC2, 0x00, 0xE9, 0x01, // Âé (U+00C2 U+00E9)
  0x00, 0xC2, 0x00, 0xEA, 0x01, // Âê (U+00C2 U+00EA)
  0x00, 0xC2, 0x00, 0xEB, 0x01, // Âë (U+00C2 U+00EB)
  0x00, 0xC2, 0x00, 0xF0, 0x01, // Âð (U+00C2 U+00F0)
  0x00, 0xC2, 0x00, 0xF2, 0x01, // Âò (U+00C2 U+00F2)
  0x00, 0xC2, 0x00, 0xF3, 0x01, // Âó (U+00C2 U+00F3)
  0x00, 0xC2, 0x00, 0xF4, 0x01, // Âô (U+00C2 U+00F4)
  0x00, 0xC2, 0x00, 0xF5, 0x01, // Âõ (U+00C2 U+00F5)
  0x00, 0xC2, 0x00, 0xF6, 0x01, // Âö (U+00C2 U+00F6)
  0x00, 0xC2, 0x00, 0xF8, 0x01, // Âø (U+00C2 U+00F8)
  0x00, 0xC2, 0x00, 0xF9, 0x02, // Âù (U+00C2 U+00F9)
  0x00, 0xC2, 0x00, 0xFA, 0x02, // Âú (U+00C2 U+00FA)
  0x00, 0xC2, 0x00, 0xFB, 0x02, // Âû (U+00C2 U+00FB)
  0x00, 0xC2, 0x00, 0xFC, 0x02, // Âü (U+00C2 U+00FC)
  0x00, 0xC2, 0x00, 0xFD, 0x04, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x04, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x06, 0x02, // ÂĆ (U+00C2 U+0106)
  0x00, 0xC2, 0x01, 0x07, 0x01, // Âć (U+00C2 U+0107)
  0x00, 0xC2, 0x01, 0x08, 0x02, // ÂĈ (U+00C2 U+0108)
  0x00, 0xC2, 0x01, 0x09, 0x01, // Âĉ (U+00C2 U+0109)
  0x00, 0xC2, 0x01, 0x0A, 0x02, // ÂĊ (U+00C2 U+010A)
  0x00, 0xC2, 0x01, 0x0B, 0x01, // Âċ (U+00C2 U+010B)
  0x00, 0xC2, 0x01, 0x0C, 0x02, // ÂČ (U+00C2 U+010C)
  0x00, 0xC2, 0x01, 0x0D, 0x01, // Âč (U+00C2 U+010D)
  0x00, 0xC2, 0x01, 0x0F, 0x01, // Âď (U+00C2 U+010F)
  0x00, 0xC2, 0x01, 0x11, 0x01, // Âđ (U+00C2 U+0111)
  0x00, 0xC2, 0x01, 0x13, 0x01, // Âē (U+00C2 U+0113)
  0x00, 0xC2, 0x01, 0x15, 0x01, // Âĕ (U+00C2 U+0115)
  0x00, 0xC2, 0x01, 0x17, 0x01, // Âė (U+00C2 U+0117)
  0x00, 0xC2, 0x01, 0x19, 0x01, // Âę (U+00C2 U+0119)
  0x00, 0xC2, 0x01, 0x1B, 0x01, // Âě (U+00C2 U+011B)
  0x00, 0xC2, 0x01, 0x1C, 0x02, // ÂĜ (U+00C2 U+011C)
  0x00, 0xC2, 0x01, 0x1D, 0x01, // Âĝ (U+00C2 U+011D)
  0x00, 0xC2, 0x01, 0x1E, 0x02, // ÂĞ (U+00C2 U+011E)
  0x00, 0xC2, 0x01, 0x1F, 0x01, // Âğ (U+00C2 U+011F)
  0x00, 0xC2, 0x01, 0x20, 0x02, // ÂĠ (U+00C2 U+0120)
  0x00, 0xC2, 0x01, 0x21, 0x01, // Âġ (U+00C2 U+0121)
  0x00, 0xC2, 0x01, 0x22, 0x02, // ÂĢ (U+00C2 U+0122)
  0x00, 0xC2, 0x01, 0x23, 0x01, // Âģ (U+00C2 U+0123)
  0x00, 0xC2, 0x01, 0x49, 0x05, // Âŉ (U+00C2 U+0149)
  0x00, 0xC2, 0x01, 0x4C, 0x02, // ÂŌ (U+00C2 U+014C)
  0x00, 0xC2, 0x01, 0x4D, 0x01, // Âō (U+00C2 U+014D)
  0x00, 0xC2, 0x01, 0x4E, 0x02, // ÂŎ (U+00C2 U+014E)
  0x00, 0xC2, 0x01, 0x4F, 0x01, // Âŏ (U+00C2 U+014F)
  0x00, 0xC2, 0x01, 0x50, 0x02, // ÂŐ (U+00C2 U+0150)
  0x00, 0xC2, 0x01, 0x51, 0x01, // Âő (U+00C2 U+0151)
  0x00, 0xC2, 0x01, 0x52, 0x02, // ÂŒ (U+00C2 U+0152)
  0x00, 0xC2, 0x01, 0x53, 0x01, // Âœ (U+00C2 U+0153)
  0x00, 0xC2, 0x01, 0x68, 0x02, // ÂŨ (U+00C2 U+0168)
  0x00, 0xC2, 0x01, 0x69, 0x02, // Âũ (U+00C2 U+0169)
  0x00, 0xC2, 0x01, 0x6A, 0x02, // ÂŪ (U+00C2 U+016A)
  0x00, 0xC2, 0x01, 0x6B, 0x02, // Âū (U+00C2 U+016B)
  0x00, 0xC2, 0x01, 0x6C, 0x02, // ÂŬ (U+00C2 U+016C)
  0x00, 0xC2, 0x01, 0x6D, 0x02, // Âŭ (U+00C2 U+016D)
  0x00, 0xC2, 0x01, 0x6E, 0x02, // ÂŮ (U+00C2 U+016E)
  0x00, 0xC2, 0x01, 0x6F, 0x02, // Âů (U+00C2 U+016F)
  0x00, 0xC2, 0x01, 0x70, 0x02, // ÂŰ (U+00C2 U+0170)
  0x00, 0xC2, 0x01, 0x71, 0x02, // Âű (U+00C2 U+0171)
  0x00, 0xC2, 0x01, 0x72, 0x02, // ÂŲ (U+00C2 U+0172)
  0x00, 0xC2, 0x01, 0x73, 0x02, // Âų (U+00C2 U+0173)
  0x00, 0xC2, 0x01, 0x74, 0x06, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x75, 0x03, // Âŵ (U+00C2 U+0175)
  0x00, 0xC2, 0x01, 0x76, 0x06, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x04, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x06, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x08, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x08, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x08, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x08, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x08, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x07, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x26, 0x02, // Ã& (U+00C3 U+0026)
  0x00, 0xC3, 0x00, 0x27, 0x07, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x08, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x43, 0x02, // ÃC (U+00C3 U+0043)
  0x00, 0xC3, 0x00, 0x47, 0x02, // ÃG (U+00C3 U+0047)
  0x00, 0xC3, 0x00, 0x4F, 0x02, // ÃO (U+00C3 U+004F)
  0x00, 0xC3, 0x00, 0x51, 0x02, // ÃQ (U+00C3 U+0051)
  0x00, 0xC3, 0x00, 0x54, 0x05, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x55, 0x02, // ÃU (U+00C3 U+0055)
  0x00, 0xC3, 0x00, 0x56, 0x07, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x06, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x06, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x63, 0x01, // Ãc (U+00C3 U+0063)
  0x00, 0xC3, 0x00, 0x64, 0x01, // Ãd (U+00C3 U+0064)
  0x00, 0xC3, 0x00, 0x65, 0x01, // Ãe (U+00C3 U+0065)
  0x00, 0xC3, 0x00, 0x67, 0x01, // Ãg (U+00C3 U+0067)
  0x00, 0xC3, 0x00, 0x6F, 0x01, // Ão (U+00C3 U+006F)
  0x00, 0xC3, 0x00, 0x71, 0x01, // Ãq (U+00C3 U+0071)
  0x00, 0xC3, 0x00, 0x75, 0x02, // Ãu (U+00C3 U+0075)
  0x00, 0xC3, 0x00, 0x76, 0x05, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x77, 0x03, // Ãw (U+00C3 U+0077)
  0x00, 0xC3, 0x00, 0x79, 0x04, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xA9, 0x05, // Ã© (U+00C3 U+00A9)
  0x00, 0xC3, 0x00, 0xAE, 0x05, // Ã® (U+00C3 U+00AE)
  0x00, 0xC3, 0x00, 0xC7, 0x02, // ÃÇ (U+00C3 U+00C7)
  0x00, 0xC3, 0x00, 0xD2, 0x02, // ÃÒ (U+00C3 U+00D2)
  0x00, 0xC3, 0x00, 0xD3, 0x02, // ÃÓ (U+00C3 U+00D3)
  0x00, 0xC3, 0x00, 0xD4, 0x02, // ÃÔ (U+00C3 U+00D4)
  0x00, 0xC3, 0x00, 0xD5, 0x02, // ÃÕ (U+00C3 U+00D5)
  0x00, 0xC3, 0x00, 0xD6, 0x02, // ÃÖ (U+00C3 U+00D6)
  0x00, 0xC3, 0x00, 0xD8, 0x02, // ÃØ (U+00C3 U+00D8)
  0x00, 0xC3, 0x00, 0xD9, 0x02, // ÃÙ (U+00C3 U+00D9)
  0x00, 0xC3, 0x00, 0xDA, 0x02, // ÃÚ (U+00C3 U+00DA)
  0x00, 0xC3, 0x00, 0xDB, 0x02, // ÃÛ (U+00C3 U+00DB)
  0x00, 0xC3, 0x00, 0xDC, 0x02, // ÃÜ (U+00C3 U+00DC)
  0x00, 0xC3, 0x00, 0xDD, 0x06, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xE7, 0x01, // Ãç (U+00C3 U+00E7)
  0x00, 0xC3, 0x00, 0xE8, 0x01, // Ãè (U+00C3 U+00E8)
  0x00, 0xC3, 0x00, 0xE9, 0x01, // Ãé (U+00C3 U+00E9)
  0x00, 0xC3, 0x00, 0xEA, 0x01, // Ãê (U+00C3 U+00EA)
  0x00, 0xC3, 0x00, 0xEB, 0x01, // Ãë (U+00C3 U+00EB)
  0x00, 0xC3, 0x00, 0xF0, 0x01, // Ãð (U+00C3 U+00F0)
  0x00, 0xC3, 0x00, 0xF2, 0x01, // Ãò (U+00C3 U+00F2)
  0x00, 0xC3, 0x00, 0xF3, 0x01, // Ãó (U+00C3 U+00F3)
  0x00, 0xC3, 0x00, 0xF4, 0x01, // Ãô (U+00C3 U+00F4)
  0x00, 0xC3, 0x00, 0xF5, 0x01, // Ãõ (U+00C3 U+00F5)
  0x00, 0xC3, 0x00, 0xF6, 0x01, // Ãö (U+00C3 U+00F6)
  0x00, 0xC3, 0x00, 0xF8, 0x01, // Ãø (U+00C3 U+00F8)
  0x00, 0xC3, 0x00, 0xF9, 0x02, // Ãù (U+00C3 U+00F9)
  0x00, 0xC3, 0x00, 0xFA, 0x02, // Ãú (U+00C3 U+00FA)
  0x00, 0xC3, 0x00, 0xFB, 0x02, // Ãû (U+00C3 U+00FB)
  0x00, 0xC3, 0x00, 0xFC, 0x02, // Ãü (U+00C3 U+00FC)
  0x00, 0xC3, 0x00, 0xFD, 0x04, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x04, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x06, 0x02, // ÃĆ (U+00C3 U+0106)
  0x00, 0xC3, 0x01, 0x07, 0x01, // Ãć (U+00C3 U+0107)
  0x00, 0xC3, 0x01, 0x08, 0x02, // ÃĈ (U+00C3 U+0108)
  0x00, 0xC3, 0x01, 0x09, 0x01, // Ãĉ (U+00C3 U+0109)
  0x00, 0xC3, 0x01, 0x0A, 0x02, // ÃĊ (U+00C3 U+010A)
  0x00, 0xC3, 0x01, 0x0B, 0x01, // Ãċ (U+00C3 U+010B)
  0x00, 0xC3, 0x01, 0x0C, 0x02, // ÃČ (U+00C3 U+010C)
  0x00, 0xC3, 0x01, 0x0D, 0x01, // Ãč (U+00C3 U+010D)
  0x00, 0xC3, 0x01, 0x0F, 0x01, // Ãď (U+00C3 U+010F)
  0x00, 0xC3, 0x01, 0x11, 0x01, // Ãđ (U+00C3 U+0111)
  0x00, 0xC3, 0x01, 0x13, 0x01, // Ãē (U+00C3 U+0113)
  0x00, 0xC3, 0x01, 0x15, 0x01, // Ãĕ (U+00C3 U+0115)
  0x00, 0xC3, 0x01, 0x17, 0x01, // Ãė (U+00C3 U+0117)
  0x00, 0xC3, 0x01, 0x19, 0x01, // Ãę (U+00C3 U+0119)
  0x00, 0xC3, 0x01, 0x1B, 0x01, // Ãě (U+00C3 U+011B)
  0x00, 0xC3, 0x01, 0x1C, 0x02, // ÃĜ (U+00C3 U+011C)
  0x00, 0xC3, 0x01, 0x1D, 0x01, // Ãĝ (U+00C3 U+011D)
  0x00, 0xC3, 0x01, 0x1E, 0x02, // ÃĞ (U+00C3 U+011E)
  0x00, 0xC3, 0x01, 0x1F, 0x01, // Ãğ (U+00C3 U+011F)
  0x00, 0xC3, 0x01, 0x20, 0x02, // ÃĠ (U+00C3 U+0120)
  0x00, 0xC3, 0x01, 0x21, 0x01, // Ãġ (U+00C3 U+0121)
  0x00, 0xC3, 0x01, 0x22, 0x02, // ÃĢ (U+00C3 U+0122)
  0x00, 0xC3, 0x01, 0x23, 0x01, // Ãģ (U+00C3 U+0123)
  0x00, 0xC3, 0x01, 0x49, 0x05, // Ãŉ (U+00C3 U+0149)
  0x00, 0xC3, 0x01, 0x4C, 0x02, // ÃŌ (U+00C3 U+014C)
  0x00, 0xC3, 0x01, 0x4D, 0x01, // Ãō (U+00C3 U+014D)
  0x00, 0xC3, 0x01, 0x4E, 0x02, // ÃŎ (U+00C3 U+014E)
  0x00, 0xC3, 0x01, 0x4F, 0x01, // Ãŏ (U+00C3 U+014F)
  0x00, 0xC3, 0x01, 0x50, 0x02, // ÃŐ (U+00C3 U+0150)
  0x00, 0xC3, 0x01, 0x51, 0x01, // Ãő (U+00C3 U+0151)
  0x00, 0xC3, 0x01, 0x52, 0x02, // ÃŒ (U+00C3 U+0152)
  0x00, 0xC3, 0x01, 0x53, 0x01, // Ãœ (U+00C3 U+0153)
  0x00, 0xC3, 0x01, 0x68, 0x02, // ÃŨ (U+00C3 U+0168)
  0x00, 0xC3, 0x01, 0x69, 0x02, // Ãũ (U+00C3 U+0169)
  0x00, 0xC3, 0x01, 0x6A, 0x02, // ÃŪ (U+00C3 U+016A)
  0x00, 0xC3, 0x01, 0x6B, 0x02, // Ãū (U+00C3 U+016B)
  0x00, 0xC3, 0x01, 0x6C, 0x02, // ÃŬ (U+00C3 U+016C)
  0x00, 0xC3, 0x01, 0x6D, 0x02, // Ãŭ (U+00C3 U+016D)
  0x00, 0xC3, 0x01, 0x6E, 0x02, // ÃŮ (U+00C3 U+016E)
  0x00, 0xC3, 0x01, 0x6F, 0x02, // Ãů (U+00C3 U+016F)
  0x00, 0xC3, 0x01, 0x70, 0x02, // ÃŰ (U+00C3 U+0170)
  0x00, 0xC3, 0x01, 0x71, 0x02, // Ãű (U+00C3 U+0171)
  0x00, 0xC3, 0x01, 0x72, 0x02, // ÃŲ (U+00C3 U+0172)
  0x00, 0xC3, 0x01, 0x73, 0x02, // Ãų (U+00C3 U+0173)
  0x00, 0xC3, 0x01, 0x74, 0x06, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x75, 0x03, // Ãŵ (U+00C3 U+0175)
  0x00, 0xC3, 0x01, 0x76, 0x06, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x04, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x06, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x08, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x08, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x08, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x08, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x08, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x07, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x26, 0x02, // Ä& (U+00C4 U+0026)
  0x00, 0xC4, 0x00, 0x27, 0x07, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x08, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x43, 0x02, // ÄC (U+00C4 U+0043)
  0x00, 0xC4, 0x00, 0x47, 0x02, // ÄG (U+00C4 U+0047)
  0x00, 0xC4, 0x00, 0x4F, 0x02, // ÄO (U+00C4 U+004F)
  0x00, 0xC4, 0x00, 0x51, 0x02, // ÄQ (U+00C4 U+0051)
  0x00, 0xC4, 0x00, 0x54, 0x05, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x55, 0x02, // ÄU (U+00C4 U+0055)
  0x00, 0xC4, 0x00, 0x56, 0x07, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x06, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x06, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x63, 0x01, // Äc (U+00C4 U+0063)
  0x00, 0xC4, 0x00, 0x64, 0x01, // Äd (U+00C4 U+0064)
  0x00, 0xC4, 0x00, 0x65, 0x01, // Äe (U+00C4 U+0065)
  0x00, 0xC4, 0x00, 0x67, 0x01, // Äg (U+00C4 U+0067)
  0x00, 0xC4, 0x00, 0x6F, 0x01, // Äo (U+00C4 U+006F)
  0x00, 0xC4, 0x00, 0x71, 0x01, // Äq (U+00C4 U+0071)
  0x00, 0xC4, 0x00, 0x75, 0x02, // Äu (U+00C4 U+0075)
  0x00, 0xC4, 0x00, 0x76, 0x05, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x77, 0x03, // Äw (U+00C4 U+0077)
  0x00, 0xC4, 0x00, 0x79, 0x04, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xA9, 0x05, // Ä© (U+00C4 U+00A9)
  0x00, 0xC4, 0x00, 0xAE, 0x05, // Ä® (U+00C4 U+00AE)
  0x00, 0xC4, 0x00, 0xC7, 0x02, // ÄÇ (U+00C4 U+00C7)
  0x00, 0xC4, 0x00, 0xD2, 0x02, // ÄÒ (U+00C4 U+00D2)
  0x00, 0xC4, 0x00, 0xD3, 0x02, // ÄÓ (U+00C4 U+00D3)
  0x00, 0xC4, 0x00, 0xD4, 0x02, // ÄÔ (U+00C4 U+00D4)
  0x00, 0xC4, 0x00, 0xD5, 0x02, // ÄÕ (U+00C4 U+00D5)
  0x00, 0xC4, 0x00, 0xD6, 0x02, // ÄÖ (U+00C4 U+00D6)
  0x00, 0xC4, 0x00, 0xD8, 0x02, // ÄØ (U+00C4 U+00D8)
  0x00, 0xC4, 0x00, 0xD9, 0x02, // ÄÙ (U+00C4 U+00D9)
  0x00, 0xC4, 0x00, 0xDA, 0x02, // ÄÚ (U+00C4 U+00DA)
  0x00, 0xC4, 0x00, 0xDB, 0x02, // ÄÛ (U+00C4 U+00DB)
  0x00, 0xC4, 0x00, 0xDC, 0x02, // ÄÜ (U+00C4 U+00DC)
  0x00, 0xC4, 0x00, 0xDD, 0x06, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xE7, 0x01, // Äç (U+00C4 U+00E7)
  0x00, 0xC4, 0x00, 0xE8, 0x01, // Äè (U+00C4 U+00E8)
  0x00, 0xC4, 0x00, 0xE9, 0x01, // Äé (U+00C4 U+00E9)
  0x00, 0xC4, 0x00, 0xEA, 0x01, // Äê (U+00C4 U+00EA)
  0x00, 0xC4, 0x00, 0xEB, 0x01, // Äë (U+00C4 U+00EB)
  0x00, 0xC4, 0x00, 0xF0, 0x01, // Äð (U+00C4 U+00F0)
  0x00, 0xC4, 0x00, 0xF2, 0x01, // Äò (U+00C4 U+00F2)
  0x00, 0xC4, 0x00, 0xF3, 0x01, // Äó (U+00C4 U+00F3)
  0x00, 0xC4, 0x00, 0xF4, 0x01, // Äô (U+00C4 U+00F4)
  0x00, 0xC4, 0x00, 0xF5, 0x01, // Äõ (U+00C4 U+00F5)
  0x00, 0xC4, 0x00, 0xF6, 0x01, // Äö (U+00C4 U+00F6)
  0x00, 0xC4, 0x00, 0xF8, 0x01, // Äø (U+00C4 U+00F8)
  0x00, 0xC4, 0x00, 0xF9, 0x02, // Äù (U+00C4 U+00F9)
  0x00, 0xC4, 0x00, 0xFA, 0x02, // Äú (U+00C4 U+00FA)
  0x00, 0xC4, 0x00, 0xFB, 0x02, // Äû (U+00C4 U+00FB)
  0x00, 0xC4, 0x00, 0xFC, 0x02, // Äü (U+00C4 U+00FC)
  0x00, 0xC4, 0x00, 0xFD, 0x04, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x04, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x06, 0x02, // ÄĆ (U+00C4 U+0106)
  0x00, 0xC4, 0x01, 0x07, 0x01, // Äć (U+00C4 U+0107)
  0x00, 0xC4, 0x01, 0x08, 0x02, // ÄĈ (U+00C4 U+0108)
  0x00, 0xC4, 0x01, 0x09, 0x01, // Äĉ (U+00C4 U+0109)
  0x00, 0xC4, 0x01, 0x0A, 0x02, // ÄĊ (U+00C4 U+010A)
  0x00, 0xC4, 0x01, 0x0B, 0x01, // Äċ (U+00C4 U+010B)
  0x00, 0xC4, 0x01, 0x0C, 0x02, // ÄČ (U+00C4 U+010C)
  0x00, 0xC4, 0x01, 0x0D, 0x01, // Äč (U+00C4 U+010D)
  0x00, 0xC4, 0x01, 0x0F, 0x01, // Äď (U+00C4 U+010F)
  0x00, 0xC4, 0x01, 0x11, 0x01, // Äđ (U+00C4 U+0111)
  0x00, 0xC4, 0x01, 0x13, 0x01, // Äē (U+00C4 U+0113)
  0x00, 0xC4, 0x01, 0x15, 0x01, // Äĕ (U+00C4 U+0115)
  0x00, 0xC4, 0x01, 0x17, 0x01, // Äė (U+00C4 U+0117)
  0x00, 0xC4, 0x01, 0x19, 0x01, // Äę (U+00C4 U+0119)
  0x00, 0xC4, 0x01, 0x1B, 0x01, // Äě (U+00C4 U+011B)
  0x00, 0xC4, 0x01, 0x1C, 0x02, // ÄĜ (U+00C4 U+011C)
  0x00, 0xC4, 0x01, 0x1D, 0x01, // Äĝ (U+00C4 U+011D)
  0x00, 0xC4, 0x01, 0x1E, 0x02, // ÄĞ (U+00C4 U+011E)
  0x00, 0xC4, 0x01, 0x1F, 0x01, // Äğ (U+00C4 U+011F)
  0x00, 0xC4, 0x01, 0x20, 0x02, // ÄĠ (U+00C4 U+0120)
  0x00, 0xC4, 0x01, 0x21, 0x01, // Äġ (U+00C4 U+0121)
  0x00, 0xC4, 0x01, 0x22, 0x02, // ÄĢ (U+00C4 U+0122)
  0x00, 0xC4, 0x01, 0x23, 0x01, // Äģ (U+00C4 U+0123)
  0x00, 0xC4, 0x01, 0x49, 0x05, // Äŉ (U+00C4 U+0149)
  0x00, 0xC4, 0x01, 0x4C, 0x02, // ÄŌ (U+00C4 U+014C)
  0x00, 0xC4, 0x01, 0x4D, 0x01, // Äō (U+00C4 U+014D)
  0x00, 0xC4, 0x01, 0x4E, 0x02, // ÄŎ (U+00C4 U+014E)
  0x00, 0xC4, 0x01, 0x4F, 0x01, // Äŏ (U+00C4 U+014F)
  0x00, 0xC4, 0x01, 0x50, 0x02, // ÄŐ (U+00C4 U+0150)
  0x00, 0xC4, 0x01, 0x51, 0x01, // Äő (U+00C4 U+0151)
  0x00, 0xC4, 0x01, 0x52, 0x02, // ÄŒ (U+00C4 U+0152)
  0x00, 0xC4, 0x01, 0x53, 0x01, // Äœ (U+00C4 U+0153)
  0x00, 0xC4, 0x01, 0x68, 0x02, // ÄŨ (U+00C4 U+0168)
  0x00, 0xC4, 0x01, 0x69, 0x02, // Äũ (U+00C4 U+0169)
  0x00, 0xC4, 0x01, 0x6A, 0x02, // ÄŪ (U+00C4 U+016A)
  0x00, 0xC4, 0x01, 0x6B, 0x02, // Äū (U+00C4 U+016B)
  0x00, 0xC4, 0x01, 0x6C, 0x02, // ÄŬ (U+00C4 U+016C)
  0x00, 0xC4, 0x01, 0x6D, 0x02, // Äŭ (U+00C4 U+016D)
  0x00, 0xC4, 0x01, 0x6E, 0x02, // ÄŮ (U+00C4 U+016E)
  0x00, 0xC4, 0x01, 0x6F, 0x02, // Äů (U+00C4 U+016F)
  0x00, 0xC4, 0x01, 0x70, 0x02, // ÄŰ (U+00C4 U+0170)
  0x00, 0xC4, 0x01, 0x71, 0x02, // Äű (U+00C4 U+0171)
  0x00, 0xC4, 0x01, 0x72, 0x02, // ÄŲ (U+00C4 U+0172)
  0x00, 0xC4, 0x01, 0x73, 0x02, // Äų (U+00C4 U+0173)
  0x00, 0xC4, 0x01, 0x74, 0x06, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x75, 0x03, // Äŵ (U+00C4 U+0175)
  0x00, 0xC4, 0x01, 0x76, 0x06, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x04, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x06, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x08, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x08, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x08, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x08, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x08, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x07, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x26, 0x02, // Å& (U+00C5 U+0026)
  0x00, 0xC5, 0x00, 0x27, 0x07, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x08, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x43, 0x02, // ÅC (U+00C5 U+0043)
  0x00, 0xC5, 0x00, 0x47, 0x02, // ÅG (U+00C5 U+0047)
  0x00, 0xC5, 0x00, 0x4F, 0x02, // ÅO (U+00C5 U+004F)
  0x00, 0xC5, 0x00, 0x51, 0x02, // ÅQ (U+00C5 U+0051)
  0x00, 0xC5, 0x00, 0x54, 0x05, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x55, 0x02, // ÅU (U+00C5 U+0055)
  0x00, 0xC5, 0x00, 0x56, 0x07, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x06, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x06, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x63, 0x01, // Åc (U+00C5 U+0063)
  0x00, 0xC5, 0x00, 0x64, 0x01, // Åd (U+00C5 U+0064)
  0x00, 0xC5, 0x00, 0x65, 0x01, // Åe (U+00C5 U+0065)
  0x00, 0xC5, 0x00, 0x67, 0x01, // Åg (U+00C5 U+0067)
  0x00, 0xC5, 0x00, 0x6F, 0x01, // Åo (U+00C5 U+006F)
  0x00, 0xC5, 0x00, 0x71, 0x01, // Åq (U+00C5 U+0071)
  0x00, 0xC5, 0x00, 0x75, 0x02, // Åu (U+00C5 U+0075)
  0x00, 0xC5, 0x00, 0x76, 0x05, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x77, 0x03, // Åw (U+00C5 U+0077)
  0x00, 0xC5, 0x00, 0x79, 0x04, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xA9, 0x05, // Å© (U+00C5 U+00A9)
  0x00, 0xC5, 0x00, 0xAE, 0x05, // Å® (U+00C5 U+00AE)
  0x00, 0xC5, 0x00, 0xC7, 0x02, // ÅÇ (U+00C5 U+00C7)
  0x00, 0xC5, 0x00, 0xD2, 0x02, // ÅÒ (U+00C5 U+00D2)
  0x00, 0xC5, 0x00, 0xD3, 0x02, // ÅÓ (U+00C5 U+00D3)
  0x00, 0xC5, 0x00, 0xD4, 0x02, // ÅÔ (U+00C5 U+00D4)
  0x00, 0xC5, 0x00, 0xD5, 0x02, // ÅÕ (U+00C5 U+00D5)
  0x00, 0xC5, 0x00, 0xD6, 0x02, // ÅÖ (U+00C5 U+00D6)
  0x00, 0xC5, 0x00, 0xD8, 0x02, // ÅØ (U+00C5 U+00D8)
  0x00, 0xC5, 0x00, 0xD9, 0x02, // ÅÙ (U+00C5 U+00D9)
  0x00, 0xC5, 0x00, 0xDA, 0x02, // ÅÚ (U+00C5 U+00DA)
  0x00, 0xC5, 0x00, 0xDB, 0x02, // ÅÛ (U+00C5 U+00DB)
  0x00, 0xC5, 0x00, 0xDC, 0x02, // ÅÜ (U+00C5 U+00DC)
  0x00, 0xC5, 0x00, 0xDD, 0x06, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xE7, 0x01, // Åç (U+00C5 U+00E7)
  0x00, 0xC5, 0x00, 0xE8, 0x01, // Åè (U+00C5 U+00E8)
  0x00, 0xC5, 0x00, 0xE9, 0x01, // Åé (U+00C5 U+00E9)
  0x00, 0xC5, 0x00, 0xEA, 0x01, // Åê (U+00C5 U+00EA)
  0x00, 0xC5, 0x00, 0xEB, 0x01, // Åë (U+00C5 U+00EB)
  0x00, 0xC5, 0x00, 0xF0, 0x01, // Åð (U+00C5 U+00F0)
  0x00, 0xC5, 0x00, 0xF2, 0x01, // Åò (U+00C5 U+00F2)
  0x00, 0xC5, 0x00, 0xF3, 0x01, // Åó (U+00C5 U+00F3)
  0x00, 0xC5, 0x00, 0xF4, 0x01, // Åô (U+00C5 U+00F4)
  0x00, 0xC5, 0x00, 0xF5, 0x01, // Åõ (U+00C5 U+00F5)
  0x00, 0xC5, 0x00, 0xF6, 0x01, // Åö (U+00C5 U+00F6)
  0x00, 0xC5, 0x00, 0xF8, 0x01, // Åø (U+00C5 U+00F8)
  0x00, 0xC5, 0x00, 0xF9, 0x02, // Åù (U+00C5 U+00F9)
  0x00, 0xC5, 0x00, 0xFA, 0x02, // Åú (U+00C5 U+00FA)
  0x00, 0xC5, 0x00, 0xFB, 0x02, // Åû (U+00C5 U+00FB)
  0x00, 0xC5, 0x00, 0xFC, 0x02, // Åü (U+00C5 U+00FC)
  0x00, 0xC5, 0x00, 0xFD, 0x04, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x04, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x06, 0x02, // ÅĆ (U+00C5 U+0106)
  0x00, 0xC5, 0x01, 0x07, 0x01, // Åć (U+00C5 U+0107)
  0x00, 0xC5, 0x01, 0x08, 0x02, // ÅĈ (U+00C5 U+0108)
  0x00, 0xC5, 0x01, 0x09, 0x01, // Åĉ (U+00C5 U+0109)
  0x00, 0xC5, 0x01, 0x0A, 0x02, // ÅĊ (U+00C5 U+010A)
  0x00, 0xC5, 0x01, 0x0B, 0x01, // Åċ (U+00C5 U+010B)
  0x00, 0xC5, 0x01, 0x0C, 0x02, // ÅČ (U+00C5 U+010C)
  0x00, 0xC5, 0x01, 0x0D, 0x01, // Åč (U+00C5 U+010D)
  0x00, 0xC5, 0x01, 0x0F, 0x01, // Åď (U+00C5 U+010F)
  0x00, 0xC5, 0x01, 0x11, 0x01, // Åđ (U+00C5 U+0111)
  0x00, 0xC5, 0x01, 0x13, 0x01, // Åē (U+00C5 U+0113)
  0x00, 0xC5, 0x01, 0x15, 0x01, // Åĕ (U+00C5 U+0115)
  0x00, 0xC5, 0x01, 0x17, 0x01, // Åė (U+00C5 U+0117)
  0x00, 0xC5, 0x01, 0x19, 0x01, // Åę (U+00C5 U+0119)
  0x00, 0xC5, 0x01, 0x1B, 0x01, // Åě (U+00C5 U+011B)
  0x00, 0xC5, 0x01, 0x1C, 0x02, // ÅĜ (U+00C5 U+011C)
  0x00, 0xC5, 0x01, 0x1D, 0x01, // Åĝ (U+00C5 U+011D)
  0x00, 0xC5, 0x01, 0x1E, 0x02, // ÅĞ (U+00C5 U+011E)
  0x00, 0xC5, 0x01, 0x1F, 0x01, // Åğ (U+00C5 U+011F)
  0x00, 0xC5, 0x01, 0x20, 0x02, // ÅĠ (U+00C5 U+0120)
  0x00, 0xC5, 0x01, 0x21, 0x01, // Åġ (U+00C5 U+0121)
  0x00, 0xC5, 0x01, 0x22, 0x02, // ÅĢ (U+00C5 U+0122)
  0x00, 0xC5, 0x01, 0x23, 0x01, // Åģ (U+00C5 U+0123)
  0x00, 0xC5, 0x01, 0x49, 0x05, // Åŉ (U+00C5 U+0149)
  0x00, 0xC5, 0x01, 0x4C, 0x02, // ÅŌ (U+00C5 U+014C)
  0x00, 0xC5, 0x01, 0x4D, 0x01, // Åō (U+00C5 U+014D)
  0x00, 0xC5, 0x01, 0x4E, 0x02, // ÅŎ (U+00C5 U+014E)
  0x00, 0xC5, 0x01, 0x4F, 0x01, // Åŏ (U+00C5 U+014F)
  0x00, 0xC5, 0x01, 0x50, 0x02, // ÅŐ (U+00C5 U+0150)
  0x00, 0xC5, 0x01, 0x51, 0x01, // Åő (U+00C5 U+0151)
  0x00, 0xC5, 0x01, 0x52, 0x02, // ÅŒ (U+00C5 U+0152)
  0x00, 0xC5, 0x01, 0x53, 0x01, // Åœ (U+00C5 U+0153)
  0x00, 0xC5, 0x01, 0x68, 0x02, // ÅŨ (U+00C5 U+0168)
  0x00, 0xC5, 0x01, 0x69, 0x02, // Åũ (U+00C5 U+0169)
  0x00, 0xC5, 0x01, 0x6A, 0x02, // ÅŪ (U+00C5 U+016A)
  0x00, 0xC5, 0x01, 0x6B, 0x02, // Åū (U+00C5 U+016B)
  0x00, 0xC5, 0x01, 0x6C, 0x02, // ÅŬ (U+00C5 U+016C)
  0x00, 0xC5, 0x01, 0x6D, 0x02, // Åŭ (U+00C5 U+016D)
  0x00, 0xC5, 0x01, 0x6E, 0x02, // ÅŮ (U+00C5 U+016E)
  0x00, 0xC5, 0x01, 0x6F, 0x02, // Åů (U+00C5 U+016F)
  0x00, 0xC5, 0x01, 0x70, 0x02, // ÅŰ (U+00C5 U+0170)
  0x00, 0xC5, 0x01, 0x71, 0x02, // Åű (U+00C5 U+0171)
  0x00, 0xC5, 0x01, 0x72, 0x02, // ÅŲ (U+00C5 U+0172)
  0x00, 0xC5, 0x01, 0x73, 0x02, // Åų (U+00C5 U+0173)
  0x00, 0xC5, 0x01, 0x74, 0x06, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x75, 0x03, // Åŵ (U+00C5 U+0175)
  0x00, 0xC5, 0x01, 0x76, 0x06, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x04, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x06, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x08, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x08, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x08, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x08, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x08, // Å™ (U+00C5 U+2122)
  0x00, 0xC6, 0x00, 0x56, 0x02, // ÆV (U+00C6 U+0056)
  0x00, 0xC6, 0x00, 0x57, 0x02, // ÆW (U+00C6 U+0057)
  0x00, 0xC6, 0x00, 0x59, 0x02, // ÆY (U+00C6 U+0059)
  0x00, 0xC6, 0x00, 0xDD, 0x02, // ÆÝ (U+00C6 U+00DD)
  0x00, 0xC6, 0x01, 0x74, 0x02, // ÆŴ (U+00C6 U+0174)
  0x00, 0xC6, 0x01, 0x76, 0x02, // ÆŶ (U+00C6 U+0176)
  0x00, 0xC6, 0x01, 0x78, 0x02, // ÆŸ (U+00C6 U+0178)
  0x00, 0xC7, 0x00, 0x26, 0x02, // Ç& (U+00C7 U+0026)
  0x00, 0xC7, 0x00, 0x43, 0x01, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x01, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x01, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x01, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xC7, 0x01, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x01, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x01, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x01, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x01, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x01, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x01, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x01, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x01, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x01, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x01, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x01, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x01, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x01, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x01, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x01, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x01, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x01, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x01, // ÇŒ (U+00C7 U+0152)
  0x00, 0xC8, 0x00, 0x56, 0x02, // ÈV (U+00C8 U+0056)
  0x00, 0xC8, 0x00, 0x57, 0x02, // ÈW (U+00C8 U+0057)
  0x00, 0xC8, 0x00, 0x59, 0x02, // ÈY (U+00C8 U+0059)
  0x00, 0xC8, 0x00, 0xDD, 0x02, // ÈÝ (U+00C8 U+00DD)
  0x00, 0xC8, 0x01, 0x74, 0x02, // ÈŴ (U+00C8 U+0174)
  0x00, 0xC8, 0x01, 0x76, 0x02, // ÈŶ (U+00C8 U+0176)
  0x00, 0xC8, 0x01, 0x78, 0x02, // ÈŸ (U+00C8 U+0178)
  0x00, 0xC9, 0x00, 0x56, 0x02, // ÉV (U+00C9 U+0056)
  0x00, 0xC9, 0x00, 0x57, 0x02, // ÉW (U+00C9 U+0057)
  0x00, 0xC9, 0x00, 0x59, 0x02, // ÉY (U+00C9 U+0059)
  0x00, 0xC9, 0x00, 0xDD, 0x02, // ÉÝ (U+00C9 U+00DD)
  0x00, 0xC9, 0x01, 0x74, 0x02, // ÉŴ (U+00C9 U+0174)
  0x00, 0xC9, 0x01, 0x76, 0x02, // ÉŶ (U+00C9 U+0176)
  0x00, 0xC9, 0x01, 0x78, 0x02, // ÉŸ (U+00C9 U+0178)
  0x00, 0xCA, 0x00, 0x56, 0x02, // ÊV (U+00CA U+0056)
  0x00, 0xCA, 0x00, 0x57, 0x02, // ÊW (U+00CA U+0057)
  0x00, 0xCA, 0x00, 0x59, 0x02, // ÊY (U+00CA U+0059)
  0x00, 0xCA, 0x00, 0xDD, 0x02, // ÊÝ (U+00CA U+00DD)
  0x00, 0xCA, 0x01, 0x74, 0x02, // ÊŴ (U+00CA U+0174)
  0x00, 0xCA, 0x01, 0x76, 0x02, // ÊŶ (U+00CA U+0176)
  0x00, 0xCA, 0x01, 0x78, 0x02, // ÊŸ (U+00CA U+0178)
  0x00, 0xCB, 0x00, 0x56, 0x02, // ËV (U+00CB U+0056)
  0x00, 0xCB, 0x00, 0x57, 0x02, // ËW (U+00CB U+0057)
  0x00, 0xCB, 0x00, 0x59, 0x02, // ËY (U+00CB U+0059)
  0x00, 0xCB, 0x00, 0xDD, 0x02, // ËÝ (U+00CB U+00DD)
  0x00, 0xCB, 0x01, 0x74, 0x02, // ËŴ (U+00CB U+0174)
  0x00, 0xCB, 0x01, 0x76, 0x02, // ËŶ (U+00CB U+0176)
  0x00, 0xCB, 0x01, 0x78, 0x02, // ËŸ (U+00CB U+0178)
  0x00, 0xD0, 0x00, 0x22, 0x03, // Ð" (U+00D0 U+0022)
  0x00, 0xD0, 0x00, 0x27, 0x03, // Ð' (U+00D0 U+0027)
  0x00, 0xD0, 0x00, 0x2C, 0x02, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x02, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x41, 0x02, // ÐA (U+00D0 U+0041)
  0x00, 0xD0, 0x00, 0x54, 0x02, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x00, 0x56, 0x02, // ÐV (U+00D0 U+0056)
  0x00, 0xD0, 0x00, 0x57, 0x02, // ÐW (U+00D0 U+0057)
  0x00, 0xD0, 0x00, 0x58, 0x01, // ÐX (U+00D0 U+0058)
  0x00, 0xD0, 0x00, 0x59, 0x02, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0xC0, 0x02, // ÐÀ (U+00D0 U+00C0)
  0x00, 0xD0, 0x00, 0xC1, 0x02, // ÐÁ (U+00D0 U+00C1)
  0x00, 0xD0, 0x00, 0xC2, 0x02, // ÐÂ (U+00D0 U+00C2)
  0x00, 0xD0, 0x00, 0xC3, 0x02, // ÐÃ (U+00D0 U+00C3)
  0x00, 0xD0, 0x00, 0xC4, 0x02, // ÐÄ (U+00D0 U+00C4)
  0x00, 0xD0, 0x00, 0xC5, 0x02, // ÐÅ (U+00D0 U+00C5)
  0x00, 0xD0, 0x00, 0xC6, 0x04, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD0, 0x00, 0xDD, 0x02, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x00, 0x02, // ÐĀ (U+00D0 U+0100)
  0x00, 0xD0, 0x01, 0x02, 0x02, // ÐĂ (U+00D0 U+0102)
  0x00, 0xD0, 0x01, 0x04, 0x02, // ÐĄ (U+00D0 U+0104)
  0x00, 0xD0, 0x01, 0x74, 0x02, // ÐŴ (U+00D0 U+0174)
  0x00, 0xD0, 0x01, 0x76, 0x02, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x02, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD0, 0x20, 0x1A, 0x02, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x02, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x02, // Ð… (U+00D0 U+2026)
  0x00, 0xD1, 0x00, 0x26, 0x02, // Ñ& (U+00D1 U+0026)
  0x00, 0xD1, 0x00, 0x2C, 0x02, // Ñ, (U+00D1 U+002C)
  0x00, 0xD1, 0x00, 0x2E, 0x02, // Ñ. (U+00D1 U+002E)
  0x00, 0xD1, 0x20, 0x1A, 0x02, // Ñ‚ (U+00D1 U+201A)
  0x00, 0xD1, 0x20, 0x1E, 0x02, // Ñ„ (U+00D1 U+201E)
  0x00, 0xD1, 0x20, 0x26, 0x02, // Ñ… (U+00D1 U+2026)
  0x00, 0xD2, 0x00, 0x22, 0x03, // Ò" (U+00D2 U+0022)
  0x00, 0xD2, 0x00, 0x27, 0x03, // Ò' (U+00D2 U+0027)
  0x00, 0xD2, 0x00, 0x2C, 0x02, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x02, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x41, 0x02, // ÒA (U+00D2 U+0041)
  0x00, 0xD2, 0x00, 0x54, 0x02, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x00, 0x56, 0x02, // ÒV (U+00D2 U+0056)
  0x00, 0xD2, 0x00, 0x57, 0x02, // ÒW (U+00D2 U+0057)
  0x00, 0xD2, 0x00, 0x58, 0x01, // ÒX (U+00D2 U+0058)
  0x00, 0xD2, 0x00, 0x59, 0x02, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0xC0, 0x02, // ÒÀ (U+00D2 U+00C0)
  0x00, 0xD2, 0x00, 0xC1, 0x02, // ÒÁ (U+00D2 U+00C1)
  0x00, 0xD2, 0x00, 0xC2, 0x02, // ÒÂ (U+00D2 U+00C2)
  0x00, 0xD2, 0x00, 0xC3, 0x02, // ÒÃ (U+00D2 U+00C3)
  0x00, 0xD2, 0x00, 0xC4, 0x02, // ÒÄ (U+00D2 U+00C4)
  0x00, 0xD2, 0x00, 0xC5, 0x02, // ÒÅ (U+00D2 U+00C5)
  0x00, 0xD2, 0x00, 0xC6, 0x04, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD2, 0x00, 0xDD, 0x02, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x00, 0x02, // ÒĀ (U+00D2 U+0100)
  0x00, 0xD2, 0x01, 0x02, 0x02, // ÒĂ (U+00D2 U+0102)
  0x00, 0xD2, 0x01, 0x04, 0x02, // ÒĄ (U+00D2 U+0104)
  0x00, 0xD2, 0x01, 0x74, 0x02, // ÒŴ (U+00D2 U+0174)
  0x00, 0xD2, 0x01, 0x76, 0x02, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x02, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD2, 0x20, 0x1A, 0x02, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x02, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x02, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x22, 0x03, // Ó" (U+00D3 U+0022)
  0x00, 0xD3, 0x00, 0x27, 0x03, // Ó' (U+00D3 U+0027)
  0x00, 0xD3, 0x00, 0x2C, 0x02, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x02, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x41, 0x02, // ÓA (U+00D3 U+0041)
  0x00, 0xD3, 0x00, 0x54, 0x02, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x00, 0x56, 0x02, // ÓV (U+00D3 U+0056)
  0x00, 0xD3, 0x00, 0x57, 0x02, // ÓW (U+00D3 U+0057)
  0x00, 0xD3, 0x00, 0x58, 0x01, // ÓX (U+00D3 U+0058)
  0x00, 0xD3, 0x00, 0x59, 0x02, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0xC0, 0x02, // ÓÀ (U+00D3 U+00C0)
  0x00, 0xD3, 0x00, 0xC1, 0x02, // ÓÁ (U+00D3 U+00C1)
  0x00, 0xD3, 0x00, 0xC2, 0x02, // ÓÂ (U+00D3 U+00C2)
  0x00, 0xD3, 0x00, 0xC3, 0x02, // ÓÃ (U+00D3 U+00C3)
  0x00, 0xD3, 0x00, 0xC4, 0x02, // ÓÄ (U+00D3 U+00C4)
  0x00, 0xD3, 0x00, 0xC5, 0x02, // ÓÅ (U+00D3 U+00C5)
  0x00, 0xD3, 0x00, 0xC6, 0x04, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD3, 0x00, 0xDD, 0x02, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x00, 0x02, // ÓĀ (U+00D3 U+0100)
  0x00, 0xD3, 0x01, 0x02, 0x02, // ÓĂ (U+00D3 U+0102)
  0x00, 0xD3, 0x01, 0x04, 0x02, // ÓĄ (U+00D3 U+0104)
  0x00, 0xD3, 0x01, 0x74, 0x02, // ÓŴ (U+00D3 U+0174)
  0x00, 0xD3, 0x01, 0x76, 0x02, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x02, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD3, 0x20, 0x1A, 0x02, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x02, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x02, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x22, 0x03, // Ô" (U+00D4 U+0022)
  0x00, 0xD4, 0x00, 0x27, 0x03, // Ô' (U+00D4 U+0027)
  0x00, 0xD4, 0x00, 0x2C, 0x02, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x02, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x41, 0x02, // ÔA (U+00D4 U+0041)
  0x00, 0xD4, 0x00, 0x54, 0x02, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x00, 0x56, 0x02, // ÔV (U+00D4 U+0056)
  0x00, 0xD4, 0x00, 0x57, 0x02, // ÔW (U+00D4 U+0057)
  0x00, 0xD4, 0x00, 0x58, 0x01, // ÔX (U+00D4 U+0058)
  0x00, 0xD4, 0x00, 0x59, 0x02, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0xC0, 0x02, // ÔÀ (U+00D4 U+00C0)
  0x00, 0xD4, 0x00, 0xC1, 0x02, // ÔÁ (U+00D4 U+00C1)
  0x00, 0xD4, 0x00, 0xC2, 0x02, // ÔÂ (U+00D4 U+00C2)
  0x00, 0xD4, 0x00, 0xC3, 0x02, // ÔÃ (U+00D4 U+00C3)
  0x00, 0xD4, 0x00, 0xC4, 0x02, // ÔÄ (U+00D4 U+00C4)
  0x00, 0xD4, 0x00, 0xC5, 0x02, // ÔÅ (U+00D4 U+00C5)
  0x00, 0xD4, 0x00, 0xC6, 0x04, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD4, 0x00, 0xDD, 0x02, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x00, 0x02, // ÔĀ (U+00D4 U+0100)
  0x00, 0xD4, 0x01, 0x02, 0x02, // ÔĂ (U+00D4 U+0102)
  0x00, 0xD4, 0x01, 0x04, 0x02, // ÔĄ (U+00D4 U+0104)
  0x00, 0xD4, 0x01, 0x74, 0x02, // ÔŴ (U+00D4 U+0174)
  0x00, 0xD4, 0x01, 0x76, 0x02, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x02, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD4, 0x20, 0x1A, 0x02, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x02, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x02, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x22, 0x03, // Õ" (U+00D5 U+0022)
  0x00, 0xD5, 0x00, 0x27, 0x03, // Õ' (U+00D5 U+0027)
  0x00, 0xD5, 0x00, 0x2C, 0x02, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x02, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x41, 0x02, // ÕA (U+00D5 U+0041)
  0x00, 0xD5, 0x00, 0x54, 0x02, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x00, 0x56, 0x02, // ÕV (U+00D5 U+0056)
  0x00, 0xD5, 0x00, 0x57, 0x02, // ÕW (U+00D5 U+0057)
  0x00, 0xD5, 0x00, 0x58, 0x01, // ÕX (U+00D5 U+0058)
  0x00, 0xD5, 0x00, 0x59, 0x02, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0xC0, 0x02, // ÕÀ (U+00D5 U+00C0)
  0x00, 0xD5, 0x00, 0xC1, 0x02, // ÕÁ (U+00D5 U+00C1)
  0x00, 0xD5, 0x00, 0xC2, 0x02, // ÕÂ (U+00D5 U+00C2)
  0x00, 0xD5, 0x00, 0xC3, 0x02, // ÕÃ (U+00D5 U+00C3)
  0x00, 0xD5, 0x00, 0xC4, 0x02, // ÕÄ (U+00D5 U+00C4)
  0x00, 0xD5, 0x00, 0xC5, 0x02, // ÕÅ (U+00D5 U+00C5)
  0x00, 0xD5, 0x00, 0xC6, 0x04, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD5, 0x00, 0xDD, 0x02, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x00, 0x02, // ÕĀ (U+00D5 U+0100)
  0x00, 0xD5, 0x01, 0x02, 0x02, // ÕĂ (U+00D5 U+0102)
  0x00, 0xD5, 0x01, 0x04, 0x02, // ÕĄ (U+00D5 U+0104)
  0x00, 0xD5, 0x01, 0x74, 0x02, // ÕŴ (U+00D5 U+0174)
  0x00, 0xD5, 0x01, 0x76, 0x02, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x02, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD5, 0x20, 0x1A, 0x02, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x02, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x02, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x22, 0x03, // Ö" (U+00D6 U+0022)
  0x00, 0xD6, 0x00, 0x27, 0x03, // Ö' (U+00D6 U+0027)
  0x00, 0xD6, 0x00, 0x2C, 0x02, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x02, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x41, 0x02, // ÖA (U+00D6 U+0041)
  0x00, 0xD6, 0x00, 0x54, 0x02, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x00, 0x56, 0x02, // ÖV (U+00D6 U+0056)
  0x00, 0xD6, 0x00, 0x57, 0x02, // ÖW (U+00D6 U+0057)
  0x00, 0xD6, 0x00, 0x58, 0x01, // ÖX (U+00D6 U+0058)
  0x00, 0xD6, 0x00, 0x59, 0x02, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0xC0, 0x02, // ÖÀ (U+00D6 U+00C0)
  0x00, 0xD6, 0x00, 0xC1, 0x02, // ÖÁ (U+00D6 U+00C1)
  0x00, 0xD6, 0x00, 0xC2, 0x02, // ÖÂ (U+00D6 U+00C2)
  0x00, 0xD6, 0x00, 0xC3, 0x02, // ÖÃ (U+00D6 U+00C3)
  0x00, 0xD6, 0x00, 0xC4, 0x02, // ÖÄ (U+00D6 U+00C4)
  0x00, 0xD6, 0x00, 0xC5, 0x02, // ÖÅ (U+00D6 U+00C5)
  0x00, 0xD6, 0x00, 0xC6, 0x04, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD6, 0x00, 0xDD, 0x02, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x00, 0x02, // ÖĀ (U+00D6 U+0100)
  0x00, 0xD6, 0x01, 0x02, 0x02, // ÖĂ (U+00D6 U+0102)
  0x00, 0xD6, 0x01, 0x04, 0x02, // ÖĄ (U+00D6 U+0104)
  0x00, 0xD6, 0x01, 0x74, 0x02, // ÖŴ (U+00D6 U+0174)
  0x00, 0xD6, 0x01, 0x76, 0x02, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x02, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD6, 0x20, 0x1A, 0x02, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x02, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x02, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x22, 0x03, // Ø" (U+00D8 U+0022)
  0x00, 0xD8, 0x00, 0x27, 0x03, // Ø' (U+00D8 U+0027)
  0x00, 0xD8, 0x00, 0x2C, 0x02, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x02, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x41, 0x02, // ØA (U+00D8 U+0041)
  0x00, 0xD8, 0x00, 0x54, 0x02, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x00, 0x56, 0x02, // ØV (U+00D8 U+0056)
  0x00, 0xD8, 0x00, 0x57, 0x02, // ØW (U+00D8 U+0057)
  0x00, 0xD8, 0x00, 0x58, 0x01, // ØX (U+00D8 U+0058)
  0x00, 0xD8, 0x00, 0x59, 0x02, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0xC0, 0x02, // ØÀ (U+00D8 U+00C0)
  0x00, 0xD8, 0x00, 0xC1, 0x02, // ØÁ (U+00D8 U+00C1)
  0x00, 0xD8, 0x00, 0xC2, 0x02, // ØÂ (U+00D8 U+00C2)
  0x00, 0xD8, 0x00, 0xC3, 0x02, // ØÃ (U+00D8 U+00C3)
  0x00, 0xD8, 0x00, 0xC4, 0x02, // ØÄ (U+00D8 U+00C4)
  0x00, 0xD8, 0x00, 0xC5, 0x02, // ØÅ (U+00D8 U+00C5)
  0x00, 0xD8, 0x00, 0xC6, 0x04, // ØÆ (U+00D8 U+00C6)
  0x00, 0xD8, 0x00, 0xDD, 0x02, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x00, 0x02, // ØĀ (U+00D8 U+0100)
  0x00, 0xD8, 0x01, 0x02, 0x02, // ØĂ (U+00D8 U+0102)
  0x00, 0xD8, 0x01, 0x04, 0x02, // ØĄ (U+00D8 U+0104)
  0x00, 0xD8, 0x01, 0x74, 0x02, // ØŴ (U+00D8 U+0174)
  0x00, 0xD8, 0x01, 0x76, 0x02, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x02, // ØŸ (U+00D8 U+0178)
  0x00, 0xD8, 0x20, 0x1A, 0x02, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x02, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x02, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x26, 0x02, // Ù& (U+00D9 U+0026)
  0x00, 0xD9, 0x00, 0x2C, 0x02, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x02, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x00, 0x41, 0x02, // ÙA (U+00D9 U+0041)
  0x00, 0xD9, 0x00, 0xC0, 0x02, // ÙÀ (U+00D9 U+00C0)
  0x00, 0xD9, 0x00, 0xC1, 0x02, // ÙÁ (U+00D9 U+00C1)
  0x00, 0xD9, 0x00, 0xC2, 0x02, // ÙÂ (U+00D9 U+00C2)
  0x00, 0xD9, 0x00, 0xC3, 0x02, // ÙÃ (U+00D9 U+00C3)
  0x00, 0xD9, 0x00, 0xC4, 0x02, // ÙÄ (U+00D9 U+00C4)
  0x00, 0xD9, 0x00, 0xC5, 0x02, // ÙÅ (U+00D9 U+00C5)
  0x00, 0xD9, 0x00, 0xC6, 0x02, // ÙÆ (U+00D9 U+00C6)
  0x00, 0xD9, 0x01, 0x00, 0x02, // ÙĀ (U+00D9 U+0100)
  0x00, 0xD9, 0x01, 0x02, 0x02, // ÙĂ (U+00D9 U+0102)
  0x00, 0xD9, 0x01, 0x04, 0x02, // ÙĄ (U+00D9 U+0104)
  0x00, 0xD9, 0x20, 0x1A, 0x02, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x02, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x02, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x26, 0x02, // Ú& (U+00DA U+0026)
  0x00, 0xDA, 0x00, 0x2C, 0x02, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x02, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x00, 0x41, 0x02, // ÚA (U+00DA U+0041)
  0x00, 0xDA, 0x00, 0xC0, 0x02, // ÚÀ (U+00DA U+00C0)
  0x00, 0xDA, 0x00, 0xC1, 0x02, // ÚÁ (U+00DA U+00C1)
  0x00, 0xDA, 0x00, 0xC2, 0x02, // ÚÂ (U+00DA U+00C2)
  0x00, 0xDA, 0x00, 0xC3, 0x02, // ÚÃ (U+00DA U+00C3)
  0x00, 0xDA, 0x00, 0xC4, 0x02, // ÚÄ (U+00DA U+00C4)
  0x00, 0xDA, 0x00, 0xC5, 0x02, // ÚÅ (U+00DA U+00C5)
  0x00, 0xDA, 0x00, 0xC6, 0x02, // ÚÆ (U+00DA U+00C6)
  0x00, 0xDA, 0x01, 0x00, 0x02, // ÚĀ (U+00DA U+0100)
  0x00, 0xDA, 0x01, 0x02, 0x02, // ÚĂ (U+00DA U+0102)
  0x00, 0xDA, 0x01, 0x04, 0x02, // ÚĄ (U+00DA U+0104)
  0x00, 0xDA, 0x20, 0x1A, 0x02, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x02, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x02, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x26, 0x02, // Û& (U+00DB U+0026)
  0x00, 0xDB, 0x00, 0x2C, 0x02, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x02, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x00, 0x41, 0x02, // ÛA (U+00DB U+0041)
  0x00, 0xDB, 0x00, 0xC0, 0x02, // ÛÀ (U+00DB U+00C0)
  0x00, 0xDB, 0x00, 0xC1, 0x02, // ÛÁ (U+00DB U+00C1)
  0x00, 0xDB, 0x00, 0xC2, 0x02, // ÛÂ (U+00DB U+00C2)
  0x00, 0xDB, 0x00, 0xC3, 0x02, // ÛÃ (U+00DB U+00C3)
  0x00, 0xDB, 0x00, 0xC4, 0x02, // ÛÄ (U+00DB U+00C4)
  0x00, 0xDB, 0x00, 0xC5, 0x02, // ÛÅ (U+00DB U+00C5)
  0x00, 0xDB, 0x00, 0xC6, 0x02, // ÛÆ (U+00DB U+00C6)
  0x00, 0xDB, 0x01, 0x00, 0x02, // ÛĀ (U+00DB U+0100)
  0x00, 0xDB, 0x01, 0x02, 0x02, // ÛĂ (U+00DB U+0102)
  0x00, 0xDB, 0x01, 0x04, 0x02, // ÛĄ (U+00DB U+0104)
  0x00, 0xDB, 0x20, 0x1A, 0x02, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x02, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x02, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x26, 0x02, // Ü& (U+00DC U+0026)
  0x00, 0xDC, 0x00, 0x2C, 0x02, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x02, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x00, 0x41, 0x02, // ÜA (U+00DC U+0041)
  0x00, 0xDC, 0x00, 0xC0, 0x02, // ÜÀ (U+00DC U+00C0)
  0x00, 0xDC, 0x00, 0xC1, 0x02, // ÜÁ (U+00DC U+00C1)
  0x00, 0xDC, 0x00, 0xC2, 0x02, // ÜÂ (U+00DC U+00C2)
  0x00, 0xDC, 0x00, 0xC3, 0x02, // ÜÃ (U+00DC U+00C3)
  0x00, 0xDC, 0x00, 0xC4, 0x02, // ÜÄ (U+00DC U+00C4)
  0x00, 0xDC, 0x00, 0xC5, 0x02, // ÜÅ (U+00DC U+00C5)
  0x00, 0xDC, 0x00, 0xC6, 0x02, // ÜÆ (U+00DC U+00C6)
  0x00, 0xDC, 0x01, 0x00, 0x02, // ÜĀ (U+00DC U+0100)
  0x00, 0xDC, 0x01, 0x02, 0x02, // ÜĂ (U+00DC U+0102)
  0x00, 0xDC, 0x01, 0x04, 0x02, // ÜĄ (U+00DC U+0104)
  0x00, 0xDC, 0x20, 0x1A, 0x02, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x02, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x02, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x03, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x07, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x07, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x06, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x02, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x02, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x02, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x02, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x53, 0x02, // ÝS (U+00DD U+0053)
  0x00, 0xDD, 0x00, 0x61, 0x05, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x06, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x06, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x06, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x06, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x06, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x06, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x05, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x78, 0x01, // Ýx (U+00DD U+0078)
  0x00, 0xDD, 0x00, 0x7A, 0x02, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xC0, 0x06, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x06, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x06, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x06, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x06, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x06, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x08, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xC7, 0x02, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x02, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x02, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x02, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x02, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x02, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x02, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x05, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x05, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x05, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x05, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x05, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x05, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x05, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x06, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x06, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x06, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x06, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x06, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x06, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x06, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x06, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x06, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x06, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x06, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x06, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x06, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x05, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x06, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x05, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x06, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x05, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x02, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x06, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x02, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x06, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x02, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x06, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x02, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x06, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x06, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x06, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x06, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x06, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x06, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x06, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x06, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x02, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x06, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x02, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x06, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x02, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x06, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x02, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x06, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4C, 0x02, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x06, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x02, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x06, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x02, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x06, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x02, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x06, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5A, 0x02, // ÝŚ (U+00DD U+015A)
  0x00, 0xDD, 0x01, 0x5B, 0x05, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5C, 0x02, // ÝŜ (U+00DD U+015C)
  0x00, 0xDD, 0x01, 0x5D, 0x05, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5E, 0x02, // ÝŞ (U+00DD U+015E)
  0x00, 0xDD, 0x01, 0x5F, 0x05, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x60, 0x02, // ÝŠ (U+00DD U+0160)
  0x00, 0xDD, 0x01, 0x61, 0x05, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x01, 0x7A, 0x02, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x02, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x02, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x07, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x07, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x07, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x22, 0x03, // Þ" (U+00DE U+0022)
  0x00, 0xDE, 0x00, 0x27, 0x03, // Þ' (U+00DE U+0027)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x02, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x54, 0x02, // ÞT (U+00DE U+0054)
  0x00, 0xDE, 0x00, 0x56, 0x02, // ÞV (U+00DE U+0056)
  0x00, 0xDE, 0x00, 0x57, 0x02, // ÞW (U+00DE U+0057)
  0x00, 0xDE, 0x00, 0x58, 0x01, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0x59, 0x02, // ÞY (U+00DE U+0059)
  0x00, 0xDE, 0x00, 0xC0, 0x02, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x02, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x02, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x02, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x02, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x02, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x04, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x00, 0xDD, 0x02, // ÞÝ (U+00DE U+00DD)
  0x00, 0xDE, 0x01, 0x00, 0x02, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x02, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x02, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x01, 0x74, 0x02, // ÞŴ (U+00DE U+0174)
  0x00, 0xDE, 0x01, 0x76, 0x02, // ÞŶ (U+00DE U+0176)
  0x00, 0xDE, 0x01, 0x78, 0x02, // ÞŸ (U+00DE U+0178)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x00, 0xDF, 0x00, 0x22, 0x02, // ß" (U+00DF U+0022)
  0x00, 0xDF, 0x00, 0x27, 0x02, // ß' (U+00DF U+0027)
  0x00, 0xDF, 0x00, 0x56, 0x03, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x03, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x05, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x05, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x03, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x05, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x05, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x04, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x04, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x00, 0x2A, 0x01, // à* (U+00E0 U+002A)
  0x00, 0xE0, 0x00, 0x54, 0x02, // àT (U+00E0 U+0054)
  0x00, 0xE0, 0x00, 0x56, 0x05, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x57, 0x04, // àW (U+00E0 U+0057)
  0x00, 0xE0, 0x00, 0x59, 0x05, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0x79, 0x01, // ày (U+00E0 U+0079)
  0x00, 0xE0, 0x00, 0xDD, 0x05, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x00, 0xFD, 0x01, // àý (U+00E0 U+00FD)
  0x00, 0xE0, 0x00, 0xFF, 0x01, // àÿ (U+00E0 U+00FF)
  0x00, 0xE0, 0x01, 0x74, 0x04, // àŴ (U+00E0 U+0174)
  0x00, 0xE0, 0x01, 0x76, 0x05, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x77, 0x01, // àŷ (U+00E0 U+0177)
  0x00, 0xE0, 0x01, 0x78, 0x05, // àŸ (U+00E0 U+0178)
  0x00, 0xE0, 0x20, 0x18, 0x03, // à‘ (U+00E0 U+2018)
  0x00, 0xE0, 0x20, 0x19, 0x01, // à’ (U+00E0 U+2019)
  0x00, 0xE0, 0x20, 0x1C, 0x03, // à“ (U+00E0 U+201C)
  0x00, 0xE0, 0x20, 0x1D, 0x01, // à” (U+00E0 U+201D)
  0x00, 0xE0, 0x21, 0x22, 0x01, // à™ (U+00E0 U+2122)
  0x00, 0xE1, 0x00, 0x22, 0x04, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x04, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x00, 0x2A, 0x01, // á* (U+00E1 U+002A)
  0x00, 0xE1, 0x00, 0x54, 0x02, // áT (U+00E1 U+0054)
  0x00, 0xE1, 0x00, 0x56, 0x05, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x57, 0x04, // áW (U+00E1 U+0057)
  0x00, 0xE1, 0x00, 0x59, 0x05, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0x79, 0x01, // áy (U+00E1 U+0079)
  0x00, 0xE1, 0x00, 0xDD, 0x05, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x00, 0xFD, 0x01, // áý (U+00E1 U+00FD)
  0x00, 0xE1, 0x00, 0xFF, 0x01, // áÿ (U+00E1 U+00FF)
  0x00, 0xE1, 0x01, 0x74, 0x04, // áŴ (U+00E1 U+0174)
  0x00, 0xE1, 0x01, 0x76, 0x05, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x77, 0x01, // áŷ (U+00E1 U+0177)
  0x00, 0xE1, 0x01, 0x78, 0x05, // áŸ (U+00E1 U+0178)
  0x00, 0xE1, 0x20, 0x18, 0x03, // á‘ (U+00E1 U+2018)
  0x00, 0xE1, 0x20, 0x19, 0x01, // á’ (U+00E1 U+2019)
  0x00, 0xE1, 0x20, 0x1C, 0x03, // á“ (U+00E1 U+201C)
  0x00, 0xE1, 0x20, 0x1D, 0x01, // á” (U+00E1 U+201D)
  0x00, 0xE1, 0x21, 0x22, 0x01, // á™ (U+00E1 U+2122)
  0x00, 0xE2, 0x00, 0x22, 0x04, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x04, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x00, 0x2A, 0x01, // â* (U+00E2 U+002A)
  0x00, 0xE2, 0x00, 0x54, 0x02, // âT (U+00E2 U+0054)
  0x00, 0xE2, 0x00, 0x56, 0x05, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x57, 0x04, // âW (U+00E2 U+0057)
  0x00, 0xE2, 0x00, 0x59, 0x05, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0x79, 0x01, // ây (U+00E2 U+0079)
  0x00, 0xE2, 0x00, 0xDD, 0x05, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x00, 0xFD, 0x01, // âý (U+00E2 U+00FD)
  0x00, 0xE2, 0x00, 0xFF, 0x01, // âÿ (U+00E2 U+00FF)
  0x00, 0xE2, 0x01, 0x74, 0x04, // âŴ (U+00E2 U+0174)
  0x00, 0xE2, 0x01, 0x76, 0x05, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x77, 0x01, // âŷ (U+00E2 U+0177)
  0x00, 0xE2, 0x01, 0x78, 0x05, // âŸ (U+00E2 U+0178)
  0x00, 0xE2, 0x20, 0x18, 0x03, // â‘ (U+00E2 U+2018)
  0x00, 0xE2, 0x20, 0x19, 0x01, // â’ (U+00E2 U+2019)
  0x00, 0xE2, 0x20, 0x1C, 0x03, // â“ (U+00E2 U+201C)
  0x00, 0xE2, 0x20, 0x1D, 0x01, // â” (U+00E2 U+201D)
  0x00, 0xE2, 0x21, 0x22, 0x01, // â™ (U+00E2 U+2122)
  0x00, 0xE3, 0x00, 0x22, 0x04, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x04, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x00, 0x2A, 0x01, // ã* (U+00E3 U+002A)
  0x00, 0xE3, 0x00, 0x54, 0x02, // ãT (U+00E3 U+0054)
  0x00, 0xE3, 0x00, 0x56, 0x05, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x57, 0x04, // ãW (U+00E3 U+0057)
  0x00, 0xE3, 0x00, 0x59, 0x05, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0x79, 0x01, // ãy (U+00E3 U+0079)
  0x00, 0xE3, 0x00, 0xDD, 0x05, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x00, 0xFD, 0x01, // ãý (U+00E3 U+00FD)
  0x00, 0xE3, 0x00, 0xFF, 0x01, // ãÿ (U+00E3 U+00FF)
  0x00, 0xE3, 0x01, 0x74, 0x04, // ãŴ (U+00E3 U+0174)
  0x00, 0xE3, 0x01, 0x76, 0x05, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x77, 0x01, // ãŷ (U+00E3 U+0177)
  0x00, 0xE3, 0x01, 0x78, 0x05, // ãŸ (U+00E3 U+0178)
  0x00, 0xE3, 0x20, 0x18, 0x03, // ã‘ (U+00E3 U+2018)
  0x00, 0xE3, 0x20, 0x19, 0x01, // ã’ (U+00E3 U+2019)
  0x00, 0xE3, 0x20, 0x1C, 0x03, // ã“ (U+00E3 U+201C)
  0x00, 0xE3, 0x20, 0x1D, 0x01, // ã” (U+00E3 U+201D)
  0x00, 0xE3, 0x21, 0x22, 0x01, // ã™ (U+00E3 U+2122)
  0x00, 0xE4, 0x00, 0x22, 0x04, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x04, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x00, 0x2A, 0x01, // ä* (U+00E4 U+002A)
  0x00, 0xE4, 0x00, 0x54, 0x02, // äT (U+00E4 U+0054)
  0x00, 0xE4, 0x00, 0x56, 0x05, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x57, 0x04, // äW (U+00E4 U+0057)
  0x00, 0xE4, 0x00, 0x59, 0x05, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0x79, 0x01, // äy (U+00E4 U+0079)
  0x00, 0xE4, 0x00, 0xDD, 0x05, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x00, 0xFD, 0x01, // äý (U+00E4 U+00FD)
  0x00, 0xE4, 0x00, 0xFF, 0x01, // äÿ (U+00E4 U+00FF)
  0x00, 0xE4, 0x01, 0x74, 0x04, // äŴ (U+00E4 U+0174)
  0x00, 0xE4, 0x01, 0x76, 0x05, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x77, 0x01, // äŷ (U+00E4 U+0177)
  0x00, 0xE4, 0x01, 0x78, 0x05, // äŸ (U+00E4 U+0178)
  0x00, 0xE4, 0x20, 0x18, 0x03, // ä‘ (U+00E4 U+2018)
  0x00, 0xE4, 0x20, 0x19, 0x01, // ä’ (U+00E4 U+2019)
  0x00, 0xE4, 0x20, 0x1C, 0x03, // ä“ (U+00E4 U+201C)
  0x00, 0xE4, 0x20, 0x1D, 0x01, // ä” (U+00E4 U+201D)
  0x00, 0xE4, 0x21, 0x22, 0x01, // ä™ (U+00E4 U+2122)
  0x00, 0xE5, 0x00, 0x22, 0x04, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x04, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x00, 0x2A, 0x01, // å* (U+00E5 U+002A)
  0x00, 0xE5, 0x00, 0x54, 0x02, // åT (U+00E5 U+0054)
  0x00, 0xE5, 0x00, 0x56, 0x05, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x57, 0x04, // åW (U+00E5 U+0057)
  0x00, 0xE5, 0x00, 0x59, 0x05, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0x79, 0x01, // åy (U+00E5 U+0079)
  0x00, 0xE5, 0x00, 0xDD, 0x05, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x00, 0xFD, 0x01, // åý (U+00E5 U+00FD)
  0x00, 0xE5, 0x00, 0xFF, 0x01, // åÿ (U+00E5 U+00FF)
  0x00, 0xE5, 0x01, 0x74, 0x04, // åŴ (U+00E5 U+0174)
  0x00, 0xE5, 0x01, 0x76, 0x05, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x77, 0x01, // åŷ (U+00E5 U+0177)
  0x00, 0xE5, 0x01, 0x78, 0x05, // åŸ (U+00E5 U+0178)
  0x00, 0xE5, 0x20, 0x18, 0x03, // å‘ (U+00E5 U+2018)
  0x00, 0xE5, 0x20, 0x19, 0x01, // å’ (U+00E5 U+2019)
  0x00, 0xE5, 0x20, 0x1C, 0x03, // å“ (U+00E5 U+201C)
  0x00, 0xE5, 0x20, 0x1D, 0x01, // å” (U+00E5 U+201D)
  0x00, 0xE5, 0x21, 0x22, 0x01, // å™ (U+00E5 U+2122)
  0x00, 0xE6, 0x00, 0x56, 0x05, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x05, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x05, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x05, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x05, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x05, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x05, // æŸ (U+00E6 U+0178)
  0x00, 0xE7, 0x00, 0x56, 0x05, // çV (U+00E7 U+0056)
  0x00, 0xE7, 0x00, 0x57, 0x05, // çW (U+00E7 U+0057)
  0x00, 0xE7, 0x00, 0x59, 0x05, // çY (U+00E7 U+0059)
  0x00, 0xE7, 0x00, 0xDD, 0x05, // çÝ (U+00E7 U+00DD)
  0x00, 0xE7, 0x01, 0x74, 0x05, // çŴ (U+00E7 U+0174)
  0x00, 0xE7, 0x01, 0x76, 0x05, // çŶ (U+00E7 U+0176)
  0x00, 0xE7, 0x01, 0x78, 0x05, // çŸ (U+00E7 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x05, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x05, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x05, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x05, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x05, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x05, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x05, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x05, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x05, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x05, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x05, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x05, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x05, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x05, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x05, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x05, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x05, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x05, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x05, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x05, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x05, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x05, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x05, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x05, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x05, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x05, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x05, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x05, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x41, 0x01, // ðA (U+00F0 U+0041)
  0x00, 0xF0, 0x00, 0x54, 0x03, // ðT (U+00F0 U+0054)
  0x00, 0xF0, 0x00, 0x56, 0x05, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x05, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x06, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0x78, 0x01, // ðx (U+00F0 U+0078)
  0x00, 0xF0, 0x00, 0x79, 0x01, // ðy (U+00F0 U+0079)
  0x00, 0xF0, 0x00, 0xC0, 0x01, // ðÀ (U+00F0 U+00C0)
  0x00, 0xF0, 0x00, 0xC1, 0x01, // ðÁ (U+00F0 U+00C1)
  0x00, 0xF0, 0x00, 0xC2, 0x01, // ðÂ (U+00F0 U+00C2)
  0x00, 0xF0, 0x00, 0xC3, 0x01, // ðÃ (U+00F0 U+00C3)
  0x00, 0xF0, 0x00, 0xC4, 0x01, // ðÄ (U+00F0 U+00C4)
  0x00, 0xF0, 0x00, 0xC5, 0x01, // ðÅ (U+00F0 U+00C5)
  0x00, 0xF0, 0x00, 0xDD, 0x06, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x00, 0xFD, 0x01, // ðý (U+00F0 U+00FD)
  0x00, 0xF0, 0x00, 0xFF, 0x01, // ðÿ (U+00F0 U+00FF)
  0x00, 0xF0, 0x01, 0x00, 0x01, // ðĀ (U+00F0 U+0100)
  0x00, 0xF0, 0x01, 0x02, 0x01, // ðĂ (U+00F0 U+0102)
  0x00, 0xF0, 0x01, 0x04, 0x01, // ðĄ (U+00F0 U+0104)
  0x00, 0xF0, 0x01, 0x74, 0x05, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x06, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x77, 0x01, // ðŷ (U+00F0 U+0177)
  0x00, 0xF0, 0x01, 0x78, 0x06, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x04, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x04, // ñ' (U+00F1 U+0027)
  0x00, 0xF1, 0x00, 0x2A, 0x01, // ñ* (U+00F1 U+002A)
  0x00, 0xF1, 0x00, 0x54, 0x02, // ñT (U+00F1 U+0054)
  0x00, 0xF1, 0x00, 0x56, 0x05, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x57, 0x04, // ñW (U+00F1 U+0057)
  0x00, 0xF1, 0x00, 0x59, 0x05, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0x79, 0x01, // ñy (U+00F1 U+0079)
  0x00, 0xF1, 0x00, 0xDD, 0x05, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x00, 0xFD, 0x01, // ñý (U+00F1 U+00FD)
  0x00, 0xF1, 0x00, 0xFF, 0x01, // ñÿ (U+00F1 U+00FF)
  0x00, 0xF1, 0x01, 0x74, 0x04, // ñŴ (U+00F1 U+0174)
  0x00, 0xF1, 0x01, 0x76, 0x05, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x77, 0x01, // ñŷ (U+00F1 U+0177)
  0x00, 0xF1, 0x01, 0x78, 0x05, // ñŸ (U+00F1 U+0178)
  0x00, 0xF1, 0x20, 0x18, 0x03, // ñ‘ (U+00F1 U+2018)
  0x00, 0xF1, 0x20, 0x19, 0x01, // ñ’ (U+00F1 U+2019)
  0x00, 0xF1, 0x20, 0x1C, 0x03, // ñ“ (U+00F1 U+201C)
  0x00, 0xF1, 0x20, 0x1D, 0x01, // ñ” (U+00F1 U+201D)
  0x00, 0xF1, 0x21, 0x22, 0x01, // ñ™ (U+00F1 U+2122)
  0x00, 0xF2, 0x00, 0x41, 0x01, // òA (U+00F2 U+0041)
  0x00, 0xF2, 0x00, 0x54, 0x03, // òT (U+00F2 U+0054)
  0x00, 0xF2, 0x00, 0x56, 0x05, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x05, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x06, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0x78, 0x01, // òx (U+00F2 U+0078)
  0x00, 0xF2, 0x00, 0x79, 0x01, // òy (U+00F2 U+0079)
  0x00, 0xF2, 0x00, 0xC0, 0x01, // òÀ (U+00F2 U+00C0)
  0x00, 0xF2, 0x00, 0xC1, 0x01, // òÁ (U+00F2 U+00C1)
  0x00, 0xF2, 0x00, 0xC2, 0x01, // òÂ (U+00F2 U+00C2)
  0x00, 0xF2, 0x00, 0xC3, 0x01, // òÃ (U+00F2 U+00C3)
  0x00, 0xF2, 0x00, 0xC4, 0x01, // òÄ (U+00F2 U+00C4)
  0x00, 0xF2, 0x00, 0xC5, 0x01, // òÅ (U+00F2 U+00C5)
  0x00, 0xF2, 0x00, 0xDD, 0x06, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x00, 0xFD, 0x01, // òý (U+00F2 U+00FD)
  0x00, 0xF2, 0x00, 0xFF, 0x01, // òÿ (U+00F2 U+00FF)
  0x00, 0xF2, 0x01, 0x00, 0x01, // òĀ (U+00F2 U+0100)
  0x00, 0xF2, 0x01, 0x02, 0x01, // òĂ (U+00F2 U+0102)
  0x00, 0xF2, 0x01, 0x04, 0x01, // òĄ (U+00F2 U+0104)
  0x00, 0xF2, 0x01, 0x74, 0x05, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x06, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x77, 0x01, // òŷ (U+00F2 U+0177)
  0x00, 0xF2, 0x01, 0x78, 0x06, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x41, 0x01, // óA (U+00F3 U+0041)
  0x00, 0xF3, 0x00, 0x54, 0x03, // óT (U+00F3 U+0054)
  0x00, 0xF3, 0x00, 0x56, 0x05, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x05, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x06, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0x78, 0x01, // óx (U+00F3 U+0078)
  0x00, 0xF3, 0x00, 0x79, 0x01, // óy (U+00F3 U+0079)
  0x00, 0xF3, 0x00, 0xC0, 0x01, // óÀ (U+00F3 U+00C0)
  0x00, 0xF3, 0x00, 0xC1, 0x01, // óÁ (U+00F3 U+00C1)
  0x00, 0xF3, 0x00, 0xC2, 0x01, // óÂ (U+00F3 U+00C2)
  0x00, 0xF3, 0x00, 0xC3, 0x01, // óÃ (U+00F3 U+00C3)
  0x00, 0xF3, 0x00, 0xC4, 0x01, // óÄ (U+00F3 U+00C4)
  0x00, 0xF3, 0x00, 0xC5, 0x01, // óÅ (U+00F3 U+00C5)
  0x00, 0xF3, 0x00, 0xDD, 0x06, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x00, 0xFD, 0x01, // óý (U+00F3 U+00FD)
  0x00, 0xF3, 0x00, 0xFF, 0x01, // óÿ (U+00F3 U+00FF)
  0x00, 0xF3, 0x01, 0x00, 0x01, // óĀ (U+00F3 U+0100)
  0x00, 0xF3, 0x01, 0x02, 0x01, // óĂ (U+00F3 U+0102)
  0x00, 0xF3, 0x01, 0x04, 0x01, // óĄ (U+00F3 U+0104)
  0x00, 0xF3, 0x01, 0x74, 0x05, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x06, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x77, 0x01, // óŷ (U+00F3 U+0177)
  0x00, 0xF3, 0x01, 0x78, 0x06, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x41, 0x01, // ôA (U+00F4 U+0041)
  0x00, 0xF4, 0x00, 0x54, 0x03, // ôT (U+00F4 U+0054)
  0x00, 0xF4, 0x00, 0x56, 0x05, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x05, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x06, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0x78, 0x01, // ôx (U+00F4 U+0078)
  0x00, 0xF4, 0x00, 0x79, 0x01, // ôy (U+00F4 U+0079)
  0x00, 0xF4, 0x00, 0xC0, 0x01, // ôÀ (U+00F4 U+00C0)
  0x00, 0xF4, 0x00, 0xC1, 0x01, // ôÁ (U+00F4 U+00C1)
  0x00, 0xF4, 0x00, 0xC2, 0x01, // ôÂ (U+00F4 U+00C2)
  0x00, 0xF4, 0x00, 0xC3, 0x01, // ôÃ (U+00F4 U+00C3)
  0x00, 0xF4, 0x00, 0xC4, 0x01, // ôÄ (U+00F4 U+00C4)
  0x00, 0xF4, 0x00, 0xC5, 0x01, // ôÅ (U+00F4 U+00C5)
  0x00, 0xF4, 0x00, 0xDD, 0x06, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x00, 0xFD, 0x01, // ôý (U+00F4 U+00FD)
  0x00, 0xF4, 0x00, 0xFF, 0x01, // ôÿ (U+00F4 U+00FF)
  0x00, 0xF4, 0x01, 0x00, 0x01, // ôĀ (U+00F4 U+0100)
  0x00, 0xF4, 0x01, 0x02, 0x01, // ôĂ (U+00F4 U+0102)
  0x00, 0xF4, 0x01, 0x04, 0x01, // ôĄ (U+00F4 U+0104)
  0x00, 0xF4, 0x01, 0x74, 0x05, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x06, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x77, 0x01, // ôŷ (U+00F4 U+0177)
  0x00, 0xF4, 0x01, 0x78, 0x06, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x41, 0x01, // õA (U+00F5 U+0041)
  0x00, 0xF5, 0x00, 0x54, 0x03, // õT (U+00F5 U+0054)
  0x00, 0xF5, 0x00, 0x56, 0x05, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x05, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x06, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0x78, 0x01, // õx (U+00F5 U+0078)
  0x00, 0xF5, 0x00, 0x79, 0x01, // õy (U+00F5 U+0079)
  0x00, 0xF5, 0x00, 0xC0, 0x01, // õÀ (U+00F5 U+00C0)
  0x00, 0xF5, 0x00, 0xC1, 0x01, // õÁ (U+00F5 U+00C1)
  0x00, 0xF5, 0x00, 0xC2, 0x01, // õÂ (U+00F5 U+00C2)
  0x00, 0xF5, 0x00, 0xC3, 0x01, // õÃ (U+00F5 U+00C3)
  0x00, 0xF5, 0x00, 0xC4, 0x01, // õÄ (U+00F5 U+00C4)
  0x00, 0xF5, 0x00, 0xC5, 0x01, // õÅ (U+00F5 U+00C5)
  0x00, 0xF5, 0x00, 0xDD, 0x06, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x00, 0xFD, 0x01, // õý (U+00F5 U+00FD)
  0x00, 0xF5, 0x00, 0xFF, 0x01, // õÿ (U+00F5 U+00FF)
  0x00, 0xF5, 0x01, 0x00, 0x01, // õĀ (U+00F5 U+0100)
  0x00, 0xF5, 0x01, 0x02, 0x01, // õĂ (U+00F5 U+0102)
  0x00, 0xF5, 0x01, 0x04, 0x01, // õĄ (U+00F5 U+0104)
  0x00, 0xF5, 0x01, 0x74, 0x05, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x06, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x77, 0x01, // õŷ (U+00F5 U+0177)
  0x00, 0xF5, 0x01, 0x78, 0x06, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x41, 0x01, // öA (U+00F6 U+0041)
  0x00, 0xF6, 0x00, 0x54, 0x03, // öT (U+00F6 U+0054)
  0x00, 0xF6, 0x00, 0x56, 0x05, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x05, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x06, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0x78, 0x01, // öx (U+00F6 U+0078)
  0x00, 0xF6, 0x00, 0x79, 0x01, // öy (U+00F6 U+0079)
  0x00, 0xF6, 0x00, 0xC0, 0x01, // öÀ (U+00F6 U+00C0)
  0x00, 0xF6, 0x00, 0xC1, 0x01, // öÁ (U+00F6 U+00C1)
  0x00, 0xF6, 0x00, 0xC2, 0x01, // öÂ (U+00F6 U+00C2)
  0x00, 0xF6, 0x00, 0xC3, 0x01, // öÃ (U+00F6 U+00C3)
  0x00, 0xF6, 0x00, 0xC4, 0x01, // öÄ (U+00F6 U+00C4)
  0x00, 0xF6, 0x00, 0xC5, 0x01, // öÅ (U+00F6 U+00C5)
  0x00, 0xF6, 0x00, 0xDD, 0x06, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x00, 0xFD, 0x01, // öý (U+00F6 U+00FD)
  0x00, 0xF6, 0x00, 0xFF, 0x01, // öÿ (U+00F6 U+00FF)
  0x00, 0xF6, 0x01, 0x00, 0x01, // öĀ (U+00F6 U+0100)
  0x00, 0xF6, 0x01, 0x02, 0x01, // öĂ (U+00F6 U+0102)
  0x00, 0xF6, 0x01, 0x04, 0x01, // öĄ (U+00F6 U+0104)
  0x00, 0xF6, 0x01, 0x74, 0x05, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x06, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x77, 0x01, // öŷ (U+00F6 U+0177)
  0x00, 0xF6, 0x01, 0x78, 0x06, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x41, 0x01, // øA (U+00F8 U+0041)
  0x00, 0xF8, 0x00, 0x54, 0x03, // øT (U+00F8 U+0054)
  0x00, 0xF8, 0x00, 0x56, 0x05, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x05, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x06, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0x78, 0x01, // øx (U+00F8 U+0078)
  0x00, 0xF8, 0x00, 0x79, 0x01, // øy (U+00F8 U+0079)
  0x00, 0xF8, 0x00, 0xC0, 0x01, // øÀ (U+00F8 U+00C0)
  0x00, 0xF8, 0x00, 0xC1, 0x01, // øÁ (U+00F8 U+00C1)
  0x00, 0xF8, 0x00, 0xC2, 0x01, // øÂ (U+00F8 U+00C2)
  0x00, 0xF8, 0x00, 0xC3, 0x01, // øÃ (U+00F8 U+00C3)
  0x00, 0xF8, 0x00, 0xC4, 0x01, // øÄ (U+00F8 U+00C4)
  0x00, 0xF8, 0x00, 0xC5, 0x01, // øÅ (U+00F8 U+00C5)
  0x00, 0xF8, 0x00, 0xDD, 0x06, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x00, 0xFD, 0x01, // øý (U+00F8 U+00FD)
  0x00, 0xF8, 0x00, 0xFF, 0x01, // øÿ (U+00F8 U+00FF)
  0x00, 0xF8, 0x01, 0x00, 0x01, // øĀ (U+00F8 U+0100)
  0x00, 0xF8, 0x01, 0x02, 0x01, // øĂ (U+00F8 U+0102)
  0x00, 0xF8, 0x01, 0x04, 0x01, // øĄ (U+00F8 U+0104)
  0x00, 0xF8, 0x01, 0x74, 0x05, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x06, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x77, 0x01, // øŷ (U+00F8 U+0177)
  0x00, 0xF8, 0x01, 0x78, 0x06, // øŸ (U+00F8 U+0178)
  0x00, 0xF9, 0x00, 0x22, 0x04, // ù" (U+00F9 U+0022)
  0x00, 0xF9, 0x00, 0x27, 0x04, // ù' (U+00F9 U+0027)
  0x00, 0xF9, 0x00, 0x2A, 0x01, // ù* (U+00F9 U+002A)
  0x00, 0xF9, 0x00, 0x54, 0x02, // ùT (U+00F9 U+0054)
  0x00, 0xF9, 0x00, 0x56, 0x05, // ùV (U+00F9 U+0056)
  0x00, 0xF9, 0x00, 0x57, 0x04, // ùW (U+00F9 U+0057)
  0x00, 0xF9, 0x00, 0x59, 0x05, // ùY (U+00F9 U+0059)
  0x00, 0xF9, 0x00, 0x79, 0x01, // ùy (U+00F9 U+0079)
  0x00, 0xF9, 0x00, 0xDD, 0x05, // ùÝ (U+00F9 U+00DD)
  0x00, 0xF9, 0x00, 0xFD, 0x01, // ùý (U+00F9 U+00FD)
  0x00, 0xF9, 0x00, 0xFF, 0x01, // ùÿ (U+00F9 U+00FF)
  0x00, 0xF9, 0x01, 0x74, 0x04, // ùŴ (U+00F9 U+0174)
  0x00, 0xF9, 0x01, 0x76, 0x05, // ùŶ (U+00F9 U+0176)
  0x00, 0xF9, 0x01, 0x77, 0x01, // ùŷ (U+00F9 U+0177)
  0x00, 0xF9, 0x01, 0x78, 0x05, // ùŸ (U+00F9 U+0178)
  0x00, 0xF9, 0x20, 0x18, 0x03, // ù‘ (U+00F9 U+2018)
  0x00, 0xF9, 0x20, 0x19, 0x01, // ù’ (U+00F9 U+2019)
  0x00, 0xF9, 0x20, 0x1C, 0x03, // ù“ (U+00F9 U+201C)
  0x00, 0xF9, 0x20, 0x1D, 0x01, // ù” (U+00F9 U+201D)
  0x00, 0xF9, 0x21, 0x22, 0x01, // ù™ (U+00F9 U+2122)
  0x00, 0xFA, 0x00, 0x22, 0x04, // ú" (U+00FA U+0022)
  0x00, 0xFA, 0x00, 0x27, 0x04, // ú' (U+00FA U+0027)
  0x00, 0xFA, 0x00, 0x2A, 0x01, // ú* (U+00FA U+002A)
  0x00, 0xFA, 0x00, 0x54, 0x02, // úT (U+00FA U+0054)
  0x00, 0xFA, 0x00, 0x56, 0x05, // úV (U+00FA U+0056)
  0x00, 0xFA, 0x00, 0x57, 0x04, // úW (U+00FA U+0057)
  0x00, 0xFA, 0x00, 0x59, 0x05, // úY (U+00FA U+0059)
  0x00, 0xFA, 0x00, 0x79, 0x01, // úy (U+00FA U+0079)
  0x00, 0xFA, 0x00, 0xDD, 0x05, // úÝ (U+00FA U+00DD)
  0x00, 0xFA, 0x00, 0xFD, 0x01, // úý (U+00FA U+00FD)
  0x00, 0xFA, 0x00, 0xFF, 0x01, // úÿ (U+00FA U+00FF)
  0x00, 0xFA, 0x01, 0x74, 0x04, // úŴ (U+00FA U+0174)
  0x00, 0xFA, 0x01, 0x76, 0x05, // úŶ (U+00FA U+0176)
  0x00, 0xFA, 0x01, 0x77, 0x01, // úŷ (U+00FA U+0177)
  0x00, 0xFA, 0x01, 0x78, 0x05, // úŸ (U+00FA U+0178)
  0x00, 0xFA, 0x20, 0x18, 0x03, // ú‘ (U+00FA U+2018)
  0x00, 0xFA, 0x20, 0x19, 0x01, // ú’ (U+00FA U+2019)
  0x00, 0xFA, 0x20, 0x1C, 0x03, // ú“ (U+00FA U+201C)
  0x00, 0xFA, 0x20, 0x1D, 0x01, // ú” (U+00FA U+201D)
  0x00, 0xFA, 0x21, 0x22, 0x01, // ú™ (U+00FA U+2122)
  0x00, 0xFB, 0x00, 0x22, 0x04, // û" (U+00FB U+0022)
  0x00, 0xFB, 0x00, 0x27, 0x04, // û' (U+00FB U+0027)
  0x00, 0xFB, 0x00, 0x2A, 0x01, // û* (U+00FB U+002A)
  0x00, 0xFB, 0x00, 0x54, 0x02, // ûT (U+00FB U+0054)
  0x00, 0xFB, 0x00, 0x56, 0x05, // ûV (U+00FB U+0056)
  0x00, 0xFB, 0x00, 0x57, 0x04, // ûW (U+00FB U+0057)
  0x00, 0xFB, 0x00, 0x59, 0x05, // ûY (U+00FB U+0059)
  0x00, 0xFB, 0x00, 0x79, 0x01, // ûy (U+00FB U+0079)
  0x00, 0xFB, 0x00, 0xDD, 0x05, // ûÝ (U+00FB U+00DD)
  0x00, 0xFB, 0x00, 0xFD, 0x01, // ûý (U+00FB U+00FD)
  0x00, 0xFB, 0x00, 0xFF, 0x01, // ûÿ (U+00FB U+00FF)
  0x00, 0xFB, 0x01, 0x74, 0x04, // ûŴ (U+00FB U+0174)
  0x00, 0xFB, 0x01, 0x76, 0x05, // ûŶ (U+00FB U+0176)
  0x00, 0xFB, 0x01, 0x77, 0x01, // ûŷ (U+00FB U+0177)
  0x00, 0xFB, 0x01, 0x78, 0x05, // ûŸ (U+00FB U+0178)
  0x00, 0xFB, 0x20, 0x18, 0x03, // û‘ (U+00FB U+2018)
  0x00, 0xFB, 0x20, 0x19, 0x01, // û’ (U+00FB U+2019)
  0x00, 0xFB, 0x20, 0x1C, 0x03, // û“ (U+00FB U+201C)
  0x00, 0xFB, 0x20, 0x1D, 0x01, // û” (U+00FB U+201D)
  0x00, 0xFB, 0x21, 0x22, 0x01, // û™ (U+00FB U+2122)
  0x00, 0xFC, 0x00, 0x22, 0x04, // ü" (U+00FC U+0022)
  0x00, 0xFC, 0x00, 0x27, 0x04, // ü' (U+00FC U+0027)
  0x00, 0xFC, 0x00, 0x2A, 0x01, // ü* (U+00FC U+002A)
  0x00, 0xFC, 0x00, 0x54, 0x02, // üT (U+00FC U+0054)
  0x00, 0xFC, 0x00, 0x56, 0x05, // üV (U+00FC U+0056)
  0x00, 0xFC, 0x00, 0x57, 0x04, // üW (U+00FC U+0057)
  0x00, 0xFC, 0x00, 0x59, 0x05, // üY (U+00FC U+0059)
  0x00, 0xFC, 0x00, 0x79, 0x01, // üy (U+00FC U+0079)
  0x00, 0xFC, 0x00, 0xDD, 0x05, // üÝ (U+00FC U+00DD)
  0x00, 0xFC, 0x00, 0xFD, 0x01, // üý (U+00FC U+00FD)
  0x00, 0xFC, 0x00, 0xFF, 0x01, // üÿ (U+00FC U+00FF)
  0x00, 0xFC, 0x01, 0x74, 0x04, // üŴ (U+00FC U+0174)
  0x00, 0xFC, 0x01, 0x76, 0x05, // üŶ (U+00FC U+0176)
  0x00, 0xFC, 0x01, 0x77, 0x01, // üŷ (U+00FC U+0177)
  0x00, 0xFC, 0x01, 0x78, 0x05, // üŸ (U+00FC U+0178)
  0x00, 0xFC, 0x20, 0x18, 0x03, // ü‘ (U+00FC U+2018)
  0x00, 0xFC, 0x20, 0x19, 0x01, // ü’ (U+00FC U+2019)
  0x00, 0xFC, 0x20, 0x1C, 0x03, // ü“ (U+00FC U+201C)
  0x00, 0xFC, 0x20, 0x1D, 0x01, // ü” (U+00FC U+201D)
  0x00, 0xFC, 0x21, 0x22, 0x01, // ü™ (U+00FC U+2122)
  0x00, 0xFD, 0x00, 0x2C, 0x06, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x06, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x01, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0x56, 0x01, // ýV (U+00FD U+0056)
  0x00, 0xFD, 0x00, 0x57, 0x02, // ýW (U+00FD U+0057)
  0x00, 0xFD, 0x00, 0x59, 0x02, // ýY (U+00FD U+0059)
  0x00, 0xFD, 0x00, 0xC0, 0x01, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x01, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x01, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x01, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x01, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x01, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x00, 0xDD, 0x02, // ýÝ (U+00FD U+00DD)
  0x00, 0xFD, 0x01, 0x00, 0x01, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x01, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x01, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x01, 0x74, 0x02, // ýŴ (U+00FD U+0174)
  0x00, 0xFD, 0x01, 0x76, 0x02, // ýŶ (U+00FD U+0176)
  0x00, 0xFD, 0x01, 0x78, 0x02, // ýŸ (U+00FD U+0178)
  0x00, 0xFD, 0x20, 0x1A, 0x06, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x06, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x06, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x41, 0x01, // þA (U+00FE U+0041)
  0x00, 0xFE, 0x00, 0x54, 0x03, // þT (U+00FE U+0054)
  0x00, 0xFE, 0x00, 0x56, 0x05, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x05, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x06, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0x78, 0x01, // þx (U+00FE U+0078)
  0x00, 0xFE, 0x00, 0x79, 0x01, // þy (U+00FE U+0079)
  0x00, 0xFE, 0x00, 0xC0, 0x01, // þÀ (U+00FE U+00C0)
  0x00, 0xFE, 0x00, 0xC1, 0x01, // þÁ (U+00FE U+00C1)
  0x00, 0xFE, 0x00, 0xC2, 0x01, // þÂ (U+00FE U+00C2)
  0x00, 0xFE, 0x00, 0xC3, 0x01, // þÃ (U+00FE U+00C3)
  0x00, 0xFE, 0x00, 0xC4, 0x01, // þÄ (U+00FE U+00C4)
  0x00, 0xFE, 0x00, 0xC5, 0x01, // þÅ (U+00FE U+00C5)
  0x00, 0xFE, 0x00, 0xDD, 0x06, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x00, 0xFD, 0x01, // þý (U+00FE U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x01, // þÿ (U+00FE U+00FF)
  0x00, 0xFE, 0x01, 0x00, 0x01, // þĀ (U+00FE U+0100)
  0x00, 0xFE, 0x01, 0x02, 0x01, // þĂ (U+00FE U+0102)
  0x00, 0xFE, 0x01, 0x04, 0x01, // þĄ (U+00FE U+0104)
  0x00, 0xFE, 0x01, 0x74, 0x05, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x06, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x77, 0x01, // þŷ (U+00FE U+0177)
  0x00, 0xFE, 0x01, 0x78, 0x06, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x06, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x06, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x01, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0x56, 0x01, // ÿV (U+00FF U+0056)
  0x00, 0xFF, 0x00, 0x57, 0x02, // ÿW (U+00FF U+0057)
  0x00, 0xFF, 0x00, 0x59, 0x02, // ÿY (U+00FF U+0059)
  0x00, 0xFF, 0x00, 0xC0, 0x01, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x01, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x01, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x01, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x01, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x01, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x00, 0xDD, 0x02, // ÿÝ (U+00FF U+00DD)
  0x00, 0xFF, 0x01, 0x00, 0x01, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x01, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x01, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x01, 0x74, 0x02, // ÿŴ (U+00FF U+0174)
  0x00, 0xFF, 0x01, 0x76, 0x02, // ÿŶ (U+00FF U+0176)
  0x00, 0xFF, 0x01, 0x78, 0x02, // ÿŸ (U+00FF U+0178)
  0x00, 0xFF, 0x20, 0x1A, 0x06, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x06, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x06, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x07, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x26, 0x02, // Ā& (U+0100 U+0026)
  0x01, 0x00, 0x00, 0x27, 0x07, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x08, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x43, 0x02, // ĀC (U+0100 U+0043)
  0x01, 0x00, 0x00, 0x47, 0x02, // ĀG (U+0100 U+0047)
  0x01, 0x00, 0x00, 0x4F, 0x02, // ĀO (U+0100 U+004F)
  0x01, 0x00, 0x00, 0x51, 0x02, // ĀQ (U+0100 U+0051)
  0x01, 0x00, 0x00, 0x54, 0x05, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x55, 0x02, // ĀU (U+0100 U+0055)
  0x01, 0x00, 0x00, 0x56, 0x07, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x06, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x06, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x63, 0x01, // Āc (U+0100 U+0063)
  0x01, 0x00, 0x00, 0x64, 0x01, // Ād (U+0100 U+0064)
  0x01, 0x00, 0x00, 0x65, 0x01, // Āe (U+0100 U+0065)
  0x01, 0x00, 0x00, 0x67, 0x01, // Āg (U+0100 U+0067)
  0x01, 0x00, 0x00, 0x6F, 0x01, // Āo (U+0100 U+006F)
  0x01, 0x00, 0x00, 0x71, 0x01, // Āq (U+0100 U+0071)
  0x01, 0x00, 0x00, 0x75, 0x02, // Āu (U+0100 U+0075)
  0x01, 0x00, 0x00, 0x76, 0x04, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x77, 0x03, // Āw (U+0100 U+0077)
  0x01, 0x00, 0x00, 0x79, 0x04, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xA9, 0x05, // Ā© (U+0100 U+00A9)
  0x01, 0x00, 0x00, 0xAE, 0x05, // Ā® (U+0100 U+00AE)
  0x01, 0x00, 0x00, 0xC7, 0x02, // ĀÇ (U+0100 U+00C7)
  0x01, 0x00, 0x00, 0xD2, 0x02, // ĀÒ (U+0100 U+00D2)
  0x01, 0x00, 0x00, 0xD3, 0x02, // ĀÓ (U+0100 U+00D3)
  0x01, 0x00, 0x00, 0xD4, 0x02, // ĀÔ (U+0100 U+00D4)
  0x01, 0x00, 0x00, 0xD5, 0x02, // ĀÕ (U+0100 U+00D5)
  0x01, 0x00, 0x00, 0xD6, 0x02, // ĀÖ (U+0100 U+00D6)
  0x01, 0x00, 0x00, 0xD8, 0x02, // ĀØ (U+0100 U+00D8)
  0x01, 0x00, 0x00, 0xD9, 0x02, // ĀÙ (U+0100 U+00D9)
  0x01, 0x00, 0x00, 0xDA, 0x02, // ĀÚ (U+0100 U+00DA)
  0x01, 0x00, 0x00, 0xDB, 0x02, // ĀÛ (U+0100 U+00DB)
  0x01, 0x00, 0x00, 0xDC, 0x02, // ĀÜ (U+0100 U+00DC)
  0x01, 0x00, 0x00, 0xDD, 0x06, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xE7, 0x01, // Āç (U+0100 U+00E7)
  0x01, 0x00, 0x00, 0xE8, 0x01, // Āè (U+0100 U+00E8)
  0x01, 0x00, 0x00, 0xE9, 0x01, // Āé (U+0100 U+00E9)
  0x01, 0x00, 0x00, 0xEA, 0x01, // Āê (U+0100 U+00EA)
  0x01, 0x00, 0x00, 0xEB, 0x01, // Āë (U+0100 U+00EB)
  0x01, 0x00, 0x00, 0xF0, 0x01, // Āð (U+0100 U+00F0)
  0x01, 0x00, 0x00, 0xF2, 0x01, // Āò (U+0100 U+00F2)
  0x01, 0x00, 0x00, 0xF3, 0x01, // Āó (U+0100 U+00F3)
  0x01, 0x00, 0x00, 0xF4, 0x01, // Āô (U+0100 U+00F4)
  0x01, 0x00, 0x00, 0xF5, 0x01, // Āõ (U+0100 U+00F5)
  0x01, 0x00, 0x00, 0xF6, 0x01, // Āö (U+0100 U+00F6)
  0x01, 0x00, 0x00, 0xF8, 0x01, // Āø (U+0100 U+00F8)
  0x01, 0x00, 0x00, 0xF9, 0x02, // Āù (U+0100 U+00F9)
  0x01, 0x00, 0x00, 0xFA, 0x02, // Āú (U+0100 U+00FA)
  0x01, 0x00, 0x00, 0xFB, 0x02, // Āû (U+0100 U+00FB)
  0x01, 0x00, 0x00, 0xFC, 0x02, // Āü (U+0100 U+00FC)
  0x01, 0x00, 0x00, 0xFD, 0x04, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x04, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x06, 0x02, // ĀĆ (U+0100 U+0106)
  0x01, 0x00, 0x01, 0x07, 0x01, // Āć (U+0100 U+0107)
  0x01, 0x00, 0x01, 0x08, 0x02, // ĀĈ (U+0100 U+0108)
  0x01, 0x00, 0x01, 0x09, 0x01, // Āĉ (U+0100 U+0109)
  0x01, 0x00, 0x01, 0x0A, 0x02, // ĀĊ (U+0100 U+010A)
  0x01, 0x00, 0x01, 0x0B, 0x01, // Āċ (U+0100 U+010B)
  0x01, 0x00, 0x01, 0x0C, 0x02, // ĀČ (U+0100 U+010C)
  0x01, 0x00, 0x01, 0x0D, 0x01, // Āč (U+0100 U+010D)
  0x01, 0x00, 0x01, 0x0F, 0x01, // Āď (U+0100 U+010F)
  0x01, 0x00, 0x01, 0x11, 0x01, // Āđ (U+0100 U+0111)
  0x01, 0x00, 0x01, 0x13, 0x01, // Āē (U+0100 U+0113)
  0x01, 0x00, 0x01, 0x15, 0x01, // Āĕ (U+0100 U+0115)
  0x01, 0x00, 0x01, 0x17, 0x01, // Āė (U+0100 U+0117)
  0x01, 0x00, 0x01, 0x19, 0x01, // Āę (U+0100 U+0119)
  0x01, 0x00, 0x01, 0x1B, 0x01, // Āě (U+0100 U+011B)
  0x01, 0x00, 0x01, 0x1C, 0x02, // ĀĜ (U+0100 U+011C)
  0x01, 0x00, 0x01, 0x1D, 0x01, // Āĝ (U+0100 U+011D)
  0x01, 0x00, 0x01, 0x1E, 0x02, // ĀĞ (U+0100 U+011E)
  0x01, 0x00, 0x01, 0x1F, 0x01, // Āğ (U+0100 U+011F)
  0x01, 0x00, 0x01, 0x20, 0x02, // ĀĠ (U+0100 U+0120)
  0x01, 0x00, 0x01, 0x21, 0x01, // Āġ (U+0100 U+0121)
  0x01, 0x00, 0x01, 0x22, 0x02, // ĀĢ (U+0100 U+0122)
  0x01, 0x00, 0x01, 0x23, 0x01, // Āģ (U+0100 U+0123)
  0x01, 0x00, 0x01, 0x49, 0x05, // Āŉ (U+0100 U+0149)
  0x01, 0x00, 0x01, 0x4C, 0x02, // ĀŌ (U+0100 U+014C)
  0x01, 0x00, 0x01, 0x4D, 0x01, // Āō (U+0100 U+014D)
  0x01, 0x00, 0x01, 0x4E, 0x02, // ĀŎ (U+0100 U+014E)
  0x01, 0x00, 0x01, 0x4F, 0x01, // Āŏ (U+0100 U+014F)
  0x01, 0x00, 0x01, 0x50, 0x02, // ĀŐ (U+0100 U+0150)
  0x01, 0x00, 0x01, 0x51, 0x01, // Āő (U+0100 U+0151)
  0x01, 0x00, 0x01, 0x52, 0x02, // ĀŒ (U+0100 U+0152)
  0x01, 0x00, 0x01, 0x53, 0x01, // Āœ (U+0100 U+0153)
  0x01, 0x00, 0x01, 0x68, 0x02, // ĀŨ (U+0100 U+0168)
  0x01, 0x00, 0x01, 0x69, 0x02, // Āũ (U+0100 U+0169)
  0x01, 0x00, 0x01, 0x6A, 0x02, // ĀŪ (U+0100 U+016A)
  0x01, 0x00, 0x01, 0x6B, 0x02, // Āū (U+0100 U+016B)
  0x01, 0x00, 0x01, 0x6C, 0x02, // ĀŬ (U+0100 U+016C)
  0x01, 0x00, 0x01, 0x6D, 0x02, // Āŭ (U+0100 U+016D)
  0x01, 0x00, 0x01, 0x6E, 0x02, // ĀŮ (U+0100 U+016E)
  0x01, 0x00, 0x01, 0x6F, 0x02, // Āů (U+0100 U+016F)
  0x01, 0x00, 0x01, 0x70, 0x02, // ĀŰ (U+0100 U+0170)
  0x01, 0x00, 0x01, 0x71, 0x02, // Āű (U+0100 U+0171)
  0x01, 0x00, 0x01, 0x72, 0x02, // ĀŲ (U+0100 U+0172)
  0x01, 0x00, 0x01, 0x73, 0x02, // Āų (U+0100 U+0173)
  0x01, 0x00, 0x01, 0x74, 0x06, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x75, 0x03, // Āŵ (U+0100 U+0175)
  0x01, 0x00, 0x01, 0x76, 0x06, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x04, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x06, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x08, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x08, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x08, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x08, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x08, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x22, 0x04, // ā" (U+0101 U+0022)
  0x01, 0x01, 0x00, 0x27, 0x04, // ā' (U+0101 U+0027)
  0x01, 0x01, 0x00, 0x2A, 0x01, // ā* (U+0101 U+002A)
  0x01, 0x01, 0x00, 0x54, 0x02, // āT (U+0101 U+0054)
  0x01, 0x01, 0x00, 0x56, 0x05, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x57, 0x04, // āW (U+0101 U+0057)
  0x01, 0x01, 0x00, 0x59, 0x05, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0x79, 0x01, // āy (U+0101 U+0079)
  0x01, 0x01, 0x00, 0xDD, 0x05, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x00, 0xFD, 0x01, // āý (U+0101 U+00FD)
  0x01, 0x01, 0x00, 0xFF, 0x01, // āÿ (U+0101 U+00FF)
  0x01, 0x01, 0x01, 0x74, 0x04, // āŴ (U+0101 U+0174)
  0x01, 0x01, 0x01, 0x76, 0x05, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x77, 0x01, // āŷ (U+0101 U+0177)
  0x01, 0x01, 0x01, 0x78, 0x05, // āŸ (U+0101 U+0178)
  0x01, 0x01, 0x20, 0x18, 0x03, // ā‘ (U+0101 U+2018)
  0x01, 0x01, 0x20, 0x19, 0x01, // ā’ (U+0101 U+2019)
  0x01, 0x01, 0x20, 0x1C, 0x03, // ā“ (U+0101 U+201C)
  0x01, 0x01, 0x20, 0x1D, 0x01, // ā” (U+0101 U+201D)
  0x01, 0x01, 0x21, 0x22, 0x01, // ā™ (U+0101 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x07, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x26, 0x02, // Ă& (U+0102 U+0026)
  0x01, 0x02, 0x00, 0x27, 0x07, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x08, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x43, 0x02, // ĂC (U+0102 U+0043)
  0x01, 0x02, 0x00, 0x47, 0x02, // ĂG (U+0102 U+0047)
  0x01, 0x02, 0x00, 0x4F, 0x02, // ĂO (U+0102 U+004F)
  0x01, 0x02, 0x00, 0x51, 0x02, // ĂQ (U+0102 U+0051)
  0x01, 0x02, 0x00, 0x54, 0x05, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x55, 0x02, // ĂU (U+0102 U+0055)
  0x01, 0x02, 0x00, 0x56, 0x07, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x06, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x06, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x63, 0x01, // Ăc (U+0102 U+0063)
  0x01, 0x02, 0x00, 0x64, 0x01, // Ăd (U+0102 U+0064)
  0x01, 0x02, 0x00, 0x65, 0x01, // Ăe (U+0102 U+0065)
  0x01, 0x02, 0x00, 0x67, 0x01, // Ăg (U+0102 U+0067)
  0x01, 0x02, 0x00, 0x6F, 0x01, // Ăo (U+0102 U+006F)
  0x01, 0x02, 0x00, 0x71, 0x01, // Ăq (U+0102 U+0071)
  0x01, 0x02, 0x00, 0x75, 0x02, // Ău (U+0102 U+0075)
  0x01, 0x02, 0x00, 0x76, 0x05, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x77, 0x03, // Ăw (U+0102 U+0077)
  0x01, 0x02, 0x00, 0x79, 0x04, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xA9, 0x05, // Ă© (U+0102 U+00A9)
  0x01, 0x02, 0x00, 0xAE, 0x05, // Ă® (U+0102 U+00AE)
  0x01, 0x02, 0x00, 0xC7, 0x02, // ĂÇ (U+0102 U+00C7)
  0x01, 0x02, 0x00, 0xD2, 0x02, // ĂÒ (U+0102 U+00D2)
  0x01, 0x02, 0x00, 0xD3, 0x02, // ĂÓ (U+0102 U+00D3)
  0x01, 0x02, 0x00, 0xD4, 0x02, // ĂÔ (U+0102 U+00D4)
  0x01, 0x02, 0x00, 0xD5, 0x02, // ĂÕ (U+0102 U+00D5)
  0x01, 0x02, 0x00, 0xD6, 0x02, // ĂÖ (U+0102 U+00D6)
  0x01, 0x02, 0x00, 0xD8, 0x02, // ĂØ (U+0102 U+00D8)
  0x01, 0x02, 0x00, 0xD9, 0x02, // ĂÙ (U+0102 U+00D9)
  0x01, 0x02, 0x00, 0xDA, 0x02, // ĂÚ (U+0102 U+00DA)
  0x01, 0x02, 0x00, 0xDB, 0x02, // ĂÛ (U+0102 U+00DB)
  0x01, 0x02, 0x00, 0xDC, 0x02, // ĂÜ (U+0102 U+00DC)
  0x01, 0x02, 0x00, 0xDD, 0x06, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xE7, 0x01, // Ăç (U+0102 U+00E7)
  0x01, 0x02, 0x00, 0xE8, 0x01, // Ăè (U+0102 U+00E8)
  0x01, 0x02, 0x00, 0xE9, 0x01, // Ăé (U+0102 U+00E9)
  0x01, 0x02, 0x00, 0xEA, 0x01, // Ăê (U+0102 U+00EA)
  0x01, 0x02, 0x00, 0xEB, 0x01, // Ăë (U+0102 U+00EB)
  0x01, 0x02, 0x00, 0xF0, 0x01, // Ăð (U+0102 U+00F0)
  0x01, 0x02, 0x00, 0xF2, 0x01, // Ăò (U+0102 U+00F2)
  0x01, 0x02, 0x00, 0xF3, 0x01, // Ăó (U+0102 U+00F3)
  0x01, 0x02, 0x00, 0xF4, 0x01, // Ăô (U+0102 U+00F4)
  0x01, 0x02, 0x00, 0xF5, 0x01, // Ăõ (U+0102 U+00F5)
  0x01, 0x02, 0x00, 0xF6, 0x01, // Ăö (U+0102 U+00F6)
  0x01, 0x02, 0x00, 0xF8, 0x01, // Ăø (U+0102 U+00F8)
  0x01, 0x02, 0x00, 0xF9, 0x02, // Ăù (U+0102 U+00F9)
  0x01, 0x02, 0x00, 0xFA, 0x02, // Ăú (U+0102 U+00FA)
  0x01, 0x02, 0x00, 0xFB, 0x02, // Ăû (U+0102 U+00FB)
  0x01, 0x02, 0x00, 0xFC, 0x02, // Ăü (U+0102 U+00FC)
  0x01, 0x02, 0x00, 0xFD, 0x04, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x04, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x06, 0x02, // ĂĆ (U+0102 U+0106)
  0x01, 0x02, 0x01, 0x07, 0x01, // Ăć (U+0102 U+0107)
  0x01, 0x02, 0x01, 0x08, 0x02, // ĂĈ (U+0102 U+0108)
  0x01, 0x02, 0x01, 0x09, 0x01, // Ăĉ (U+0102 U+0109)
  0x01, 0x02, 0x01, 0x0A, 0x02, // ĂĊ (U+0102 U+010A)
  0x01, 0x02, 0x01, 0x0B, 0x01, // Ăċ (U+0102 U+010B)
  0x01, 0x02, 0x01, 0x0C, 0x02, // ĂČ (U+0102 U+010C)
  0x01, 0x02, 0x01, 0x0D, 0x01, // Ăč (U+0102 U+010D)
  0x01, 0x02, 0x01, 0x0F, 0x01, // Ăď (U+0102 U+010F)
  0x01, 0x02, 0x01, 0x11, 0x01, // Ăđ (U+0102 U+0111)
  0x01, 0x02, 0x01, 0x13, 0x01, // Ăē (U+0102 U+0113)
  0x01, 0x02, 0x01, 0x15, 0x01, // Ăĕ (U+0102 U+0115)
  0x01, 0x02, 0x01, 0x17, 0x01, // Ăė (U+0102 U+0117)
  0x01, 0x02, 0x01, 0x19, 0x01, // Ăę (U+0102 U+0119)
  0x01, 0x02, 0x01, 0x1B, 0x01, // Ăě (U+0102 U+011B)
  0x01, 0x02, 0x01, 0x1C, 0x02, // ĂĜ (U+0102 U+011C)
  0x01, 0x02, 0x01, 0x1D, 0x01, // Ăĝ (U+0102 U+011D)
  0x01, 0x02, 0x01, 0x1E, 0x02, // ĂĞ (U+0102 U+011E)
  0x01, 0x02, 0x01, 0x1F, 0x01, // Ăğ (U+0102 U+011F)
  0x01, 0x02, 0x01, 0x20, 0x02, // ĂĠ (U+0102 U+0120)
  0x01, 0x02, 0x01, 0x21, 0x01, // Ăġ (U+0102 U+0121)
  0x01, 0x02, 0x01, 0x22, 0x02, // ĂĢ (U+0102 U+0122)
  0x01, 0x02, 0x01, 0x23, 0x01, // Ăģ (U+0102 U+0123)
  0x01, 0x02, 0x01, 0x49, 0x05, // Ăŉ (U+0102 U+0149)
  0x01, 0x02, 0x01, 0x4C, 0x02, // ĂŌ (U+0102 U+014C)
  0x01, 0x02, 0x01, 0x4D, 0x01, // Ăō (U+0102 U+014D)
  0x01, 0x02, 0x01, 0x4E, 0x02, // ĂŎ (U+0102 U+014E)
  0x01, 0x02, 0x01, 0x4F, 0x01, // Ăŏ (U+0102 U+014F)
  0x01, 0x02, 0x01, 0x50, 0x02, // ĂŐ (U+0102 U+0150)
  0x01, 0x02, 0x01, 0x51, 0x01, // Ăő (U+0102 U+0151)
  0x01, 0x02, 0x01, 0x52, 0x02, // ĂŒ (U+0102 U+0152)
  0x01, 0x02, 0x01, 0x53, 0x01, // Ăœ (U+0102 U+0153)
  0x01, 0x02, 0x01, 0x68, 0x02, // ĂŨ (U+0102 U+0168)
  0x01, 0x02, 0x01, 0x69, 0x02, // Ăũ (U+0102 U+0169)
  0x01, 0x02, 0x01, 0x6A, 0x02, // ĂŪ (U+0102 U+016A)
  0x01, 0x02, 0x01, 0x6B, 0x02, // Ăū (U+0102 U+016B)
  0x01, 0x02, 0x01, 0x6C, 0x02, // ĂŬ (U+0102 U+016C)
  0x01, 0x02, 0x01, 0x6D, 0x02, // Ăŭ (U+0102 U+016D)
  0x01, 0x02, 0x01, 0x6E, 0x02, // ĂŮ (U+0102 U+016E)
  0x01, 0x02, 0x01, 0x6F, 0x02, // Ăů (U+0102 U+016F)
  0x01, 0x02, 0x01, 0x70, 0x02, // ĂŰ (U+0102 U+0170)
  0x01, 0x02, 0x01, 0x71, 0x02, // Ăű (U+0102 U+0171)
  0x01, 0x02, 0x01, 0x72, 0x02, // ĂŲ (U+0102 U+0172)
  0x01, 0x02, 0x01, 0x73, 0x02, // Ăų (U+0102 U+0173)
  0x01, 0x02, 0x01, 0x74, 0x06, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x75, 0x03, // Ăŵ (U+0102 U+0175)
  0x01, 0x02, 0x01, 0x76, 0x06, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x04, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x06, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x08, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x08, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x08, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x08, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x08, // Ă™ (U+0102 U+2122)
  0x01, 0x03, 0x00, 0x22, 0x04, // ă" (U+0103 U+0022)
  0x01, 0x03, 0x00, 0x27, 0x04, // ă' (U+0103 U+0027)
  0x01, 0x03, 0x00, 0x2A, 0x01, // ă* (U+0103 U+002A)
  0x01, 0x03, 0x00, 0x54, 0x02, // ăT (U+0103 U+0054)
  0x01, 0x03, 0x00, 0x56, 0x05, // ăV (U+0103 U+0056)
  0x01, 0x03, 0x00, 0x57, 0x04, // ăW (U+0103 U+0057)
  0x01, 0x03, 0x00, 0x59, 0x05, // ăY (U+0103 U+0059)
  0x01, 0x03, 0x00, 0x79, 0x01, // ăy (U+0103 U+0079)
  0x01, 0x03, 0x00, 0xDD, 0x05, // ăÝ (U+0103 U+00DD)
  0x01, 0x03, 0x00, 0xFD, 0x01, // ăý (U+0103 U+00FD)
  0x01, 0x03, 0x00, 0xFF, 0x01, // ăÿ (U+0103 U+00FF)
  0x01, 0x03, 0x01, 0x74, 0x04, // ăŴ (U+0103 U+0174)
  0x01, 0x03, 0x01, 0x76, 0x05, // ăŶ (U+0103 U+0176)
  0x01, 0x03, 0x01, 0x77, 0x01, // ăŷ (U+0103 U+0177)
  0x01, 0x03, 0x01, 0x78, 0x05, // ăŸ (U+0103 U+0178)
  0x01, 0x03, 0x20, 0x18, 0x03, // ă‘ (U+0103 U+2018)
  0x01, 0x03, 0x20, 0x19, 0x01, // ă’ (U+0103 U+2019)
  0x01, 0x03, 0x20, 0x1C, 0x03, // ă“ (U+0103 U+201C)
  0x01, 0x03, 0x20, 0x1D, 0x01, // ă” (U+0103 U+201D)
  0x01, 0x03, 0x21, 0x22, 0x01, // ă™ (U+0103 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x07, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x26, 0x02, // Ą& (U+0104 U+0026)
  0x01, 0x04, 0x00, 0x27, 0x07, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x08, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x43, 0x02, // ĄC (U+0104 U+0043)
  0x01, 0x04, 0x00, 0x47, 0x02, // ĄG (U+0104 U+0047)
  0x01, 0x04, 0x00, 0x4F, 0x02, // ĄO (U+0104 U+004F)
  0x01, 0x04, 0x00, 0x51, 0x02, // ĄQ (U+0104 U+0051)
  0x01, 0x04, 0x00, 0x54, 0x05, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x55, 0x02, // ĄU (U+0104 U+0055)
  0x01, 0x04, 0x00, 0x56, 0x07, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x06, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x06, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x63, 0x01, // Ąc (U+0104 U+0063)
  0x01, 0x04, 0x00, 0x64, 0x01, // Ąd (U+0104 U+0064)
  0x01, 0x04, 0x00, 0x65, 0x01, // Ąe (U+0104 U+0065)
  0x01, 0x04, 0x00, 0x67, 0x01, // Ąg (U+0104 U+0067)
  0x01, 0x04, 0x00, 0x6F, 0x01, // Ąo (U+0104 U+006F)
  0x01, 0x04, 0x00, 0x71, 0x01, // Ąq (U+0104 U+0071)
  0x01, 0x04, 0x00, 0x75, 0x02, // Ąu (U+0104 U+0075)
  0x01, 0x04, 0x00, 0x76, 0x05, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x77, 0x03, // Ąw (U+0104 U+0077)
  0x01, 0x04, 0x00, 0x79, 0x04, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xA9, 0x05, // Ą© (U+0104 U+00A9)
  0x01, 0x04, 0x00, 0xAE, 0x05, // Ą® (U+0104 U+00AE)
  0x01, 0x04, 0x00, 0xC7, 0x02, // ĄÇ (U+0104 U+00C7)
  0x01, 0x04, 0x00, 0xD2, 0x02, // ĄÒ (U+0104 U+00D2)
  0x01, 0x04, 0x00, 0xD3, 0x02, // ĄÓ (U+0104 U+00D3)
  0x01, 0x04, 0x00, 0xD4, 0x02, // ĄÔ (U+0104 U+00D4)
  0x01, 0x04, 0x00, 0xD5, 0x02, // ĄÕ (U+0104 U+00D5)
  0x01, 0x04, 0x00, 0xD6, 0x02, // ĄÖ (U+0104 U+00D6)
  0x01, 0x04, 0x00, 0xD8, 0x02, // ĄØ (U+0104 U+00D8)
  0x01, 0x04, 0x00, 0xD9, 0x02, // ĄÙ (U+0104 U+00D9)
  0x01, 0x04, 0x00, 0xDA, 0x02, // ĄÚ (U+0104 U+00DA)
  0x01, 0x04, 0x00, 0xDB, 0x02, // ĄÛ (U+0104 U+00DB)
  0x01, 0x04, 0x00, 0xDC, 0x02, // ĄÜ (U+0104 U+00DC)
  0x01, 0x04, 0x00, 0xDD, 0x06, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xE7, 0x01, // Ąç (U+0104 U+00E7)
  0x01, 0x04, 0x00, 0xE8, 0x01, // Ąè (U+0104 U+00E8)
  0x01, 0x04, 0x00, 0xE9, 0x01, // Ąé (U+0104 U+00E9)
  0x01, 0x04, 0x00, 0xEA, 0x01, // Ąê (U+0104 U+00EA)
  0x01, 0x04, 0x00, 0xEB, 0x01, // Ąë (U+0104 U+00EB)
  0x01, 0x04, 0x00, 0xF0, 0x01, // Ąð (U+0104 U+00F0)
  0x01, 0x04, 0x00, 0xF2, 0x01, // Ąò (U+0104 U+00F2)
  0x01, 0x04, 0x00, 0xF3, 0x01, // Ąó (U+0104 U+00F3)
  0x01, 0x04, 0x00, 0xF4, 0x01, // Ąô (U+0104 U+00F4)
  0x01, 0x04, 0x00, 0xF5, 0x01, // Ąõ (U+0104 U+00F5)
  0x01, 0x04, 0x00, 0xF6, 0x01, // Ąö (U+0104 U+00F6)
  0x01, 0x04, 0x00, 0xF8, 0x01, // Ąø (U+0104 U+00F8)
  0x01, 0x04, 0x00, 0xF9, 0x02, // Ąù (U+0104 U+00F9)
  0x01, 0x04, 0x00, 0xFA, 0x02, // Ąú (U+0104 U+00FA)
  0x01, 0x04, 0x00, 0xFB, 0x02, // Ąû (U+0104 U+00FB)
  0x01, 0x04, 0x00, 0xFC, 0x02, // Ąü (U+0104 U+00FC)
  0x01, 0x04, 0x00, 0xFD, 0x04, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x04, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x06, 0x02, // ĄĆ (U+0104 U+0106)
  0x01, 0x04, 0x01, 0x07, 0x01, // Ąć (U+0104 U+0107)
  0x01, 0x04, 0x01, 0x08, 0x02, // ĄĈ (U+0104 U+0108)
  0x01, 0x04, 0x01, 0x09, 0x01, // Ąĉ (U+0104 U+0109)
  0x01, 0x04, 0x01, 0x0A, 0x02, // ĄĊ (U+0104 U+010A)
  0x01, 0x04, 0x01, 0x0B, 0x01, // Ąċ (U+0104 U+010B)
  0x01, 0x04, 0x01, 0x0C, 0x02, // ĄČ (U+0104 U+010C)
  0x01, 0x04, 0x01, 0x0D, 0x01, // Ąč (U+0104 U+010D)
  0x01, 0x04, 0x01, 0x0F, 0x01, // Ąď (U+0104 U+010F)
  0x01, 0x04, 0x01, 0x11, 0x01, // Ąđ (U+0104 U+0111)
  0x01, 0x04, 0x01, 0x13, 0x01, // Ąē (U+0104 U+0113)
  0x01, 0x04, 0x01, 0x15, 0x01, // Ąĕ (U+0104 U+0115)
  0x01, 0x04, 0x01, 0x17, 0x01, // Ąė (U+0104 U+0117)
  0x01, 0x04, 0x01, 0x19, 0x01, // Ąę (U+0104 U+0119)
  0x01, 0x04, 0x01, 0x1B, 0x01, // Ąě (U+0104 U+011B)
  0x01, 0x04, 0x01, 0x1C, 0x02, // ĄĜ (U+0104 U+011C)
  0x01, 0x04, 0x01, 0x1D, 0x01, // Ąĝ (U+0104 U+011D)
  0x01, 0x04, 0x01, 0x1E, 0x02, // ĄĞ (U+0104 U+011E)
  0x01, 0x04, 0x01, 0x1F, 0x01, // Ąğ (U+0104 U+011F)
  0x01, 0x04, 0x01, 0x20, 0x02, // ĄĠ (U+0104 U+0120)
  0x01, 0x04, 0x01, 0x21, 0x01, // Ąġ (U+0104 U+0121)
  0x01, 0x04, 0x01, 0x22, 0x02, // ĄĢ (U+0104 U+0122)
  0x01, 0x04, 0x01, 0x23, 0x01, // Ąģ (U+0104 U+0123)
  0x01, 0x04, 0x01, 0x49, 0x05, // Ąŉ (U+0104 U+0149)
  0x01, 0x04, 0x01, 0x4C, 0x02, // ĄŌ (U+0104 U+014C)
  0x01, 0x04, 0x01, 0x4D, 0x01, // Ąō (U+0104 U+014D)
  0x01, 0x04, 0x01, 0x4E, 0x02, // ĄŎ (U+0104 U+014E)
  0x01, 0x04, 0x01, 0x4F, 0x01, // Ąŏ (U+0104 U+014F)
  0x01, 0x04, 0x01, 0x50, 0x02, // ĄŐ (U+0104 U+0150)
  0x01, 0x04, 0x01, 0x51, 0x01, // Ąő (U+0104 U+0151)
  0x01, 0x04, 0x01, 0x52, 0x02, // ĄŒ (U+0104 U+0152)
  0x01, 0x04, 0x01, 0x53, 0x01, // Ąœ (U+0104 U+0153)
  0x01, 0x04, 0x01, 0x68, 0x02, // ĄŨ (U+0104 U+0168)
  0x01, 0x04, 0x01, 0x69, 0x02, // Ąũ (U+0104 U+0169)
  0x01, 0x04, 0x01, 0x6A, 0x02, // ĄŪ (U+0104 U+016A)
  0x01, 0x04, 0x01, 0x6B, 0x02, // Ąū (U+0104 U+016B)
  0x01, 0x04, 0x01, 0x6C, 0x02, // ĄŬ (U+0104 U+016C)
  0x01, 0x04, 0x01, 0x6D, 0x02, // Ąŭ (U+0104 U+016D)
  0x01, 0x04, 0x01, 0x6E, 0x02, // ĄŮ (U+0104 U+016E)
  0x01, 0x04, 0x01, 0x6F, 0x02, // Ąů (U+0104 U+016F)
  0x01, 0x04, 0x01, 0x70, 0x02, // ĄŰ (U+0104 U+0170)
  0x01, 0x04, 0x01, 0x71, 0x02, // Ąű (U+0104 U+0171)
  0x01, 0x04, 0x01, 0x72, 0x02, // ĄŲ (U+0104 U+0172)
  0x01, 0x04, 0x01, 0x73, 0x02, // Ąų (U+0104 U+0173)
  0x01, 0x04, 0x01, 0x74, 0x06, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x75, 0x03, // Ąŵ (U+0104 U+0175)
  0x01, 0x04, 0x01, 0x76, 0x06, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x04, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x06, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x08, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x08, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x08, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x08, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x08, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x22, 0x04, // ą" (U+0105 U+0022)
  0x01, 0x05, 0x00, 0x27, 0x04, // ą' (U+0105 U+0027)
  0x01, 0x05, 0x00, 0x2A, 0x01, // ą* (U+0105 U+002A)
  0x01, 0x05, 0x00, 0x54, 0x02, // ąT (U+0105 U+0054)
  0x01, 0x05, 0x00, 0x56, 0x05, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x57, 0x04, // ąW (U+0105 U+0057)
  0x01, 0x05, 0x00, 0x59, 0x05, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0x79, 0x01, // ąy (U+0105 U+0079)
  0x01, 0x05, 0x00, 0xDD, 0x05, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x00, 0xFD, 0x01, // ąý (U+0105 U+00FD)
  0x01, 0x05, 0x00, 0xFF, 0x01, // ąÿ (U+0105 U+00FF)
  0x01, 0x05, 0x01, 0x74, 0x04, // ąŴ (U+0105 U+0174)
  0x01, 0x05, 0x01, 0x76, 0x05, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x77, 0x01, // ąŷ (U+0105 U+0177)
  0x01, 0x05, 0x01, 0x78, 0x05, // ąŸ (U+0105 U+0178)
  0x01, 0x05, 0x20, 0x18, 0x03, // ą‘ (U+0105 U+2018)
  0x01, 0x05, 0x20, 0x19, 0x01, // ą’ (U+0105 U+2019)
  0x01, 0x05, 0x20, 0x1C, 0x03, // ą“ (U+0105 U+201C)
  0x01, 0x05, 0x20, 0x1D, 0x01, // ą” (U+0105 U+201D)
  0x01, 0x05, 0x21, 0x22, 0x01, // ą™ (U+0105 U+2122)
  0x01, 0x06, 0x00, 0x26, 0x02, // Ć& (U+0106 U+0026)
  0x01, 0x06, 0x00, 0x43, 0x01, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x01, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x01, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x01, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xC7, 0x01, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x01, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x01, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x01, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x01, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x01, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x01, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x01, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x01, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x01, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x01, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x01, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x01, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x01, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x01, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x01, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x01, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x01, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x01, // ĆŒ (U+0106 U+0152)
  0x01, 0x07, 0x00, 0x56, 0x05, // ćV (U+0107 U+0056)
  0x01, 0x07, 0x00, 0x57, 0x05, // ćW (U+0107 U+0057)
  0x01, 0x07, 0x00, 0x59, 0x05, // ćY (U+0107 U+0059)
  0x01, 0x07, 0x00, 0xDD, 0x05, // ćÝ (U+0107 U+00DD)
  0x01, 0x07, 0x01, 0x74, 0x05, // ćŴ (U+0107 U+0174)
  0x01, 0x07, 0x01, 0x76, 0x05, // ćŶ (U+0107 U+0176)
  0x01, 0x07, 0x01, 0x78, 0x05, // ćŸ (U+0107 U+0178)
  0x01, 0x08, 0x00, 0x26, 0x02, // Ĉ& (U+0108 U+0026)
  0x01, 0x08, 0x00, 0x43, 0x01, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x01, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x01, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x01, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xC7, 0x01, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x01, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x01, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x01, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x01, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x01, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x01, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x01, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x01, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x01, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x01, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x01, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x01, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x01, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x01, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x01, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x01, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x01, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x01, // ĈŒ (U+0108 U+0152)
  0x01, 0x09, 0x00, 0x56, 0x05, // ĉV (U+0109 U+0056)
  0x01, 0x09, 0x00, 0x57, 0x05, // ĉW (U+0109 U+0057)
  0x01, 0x09, 0x00, 0x59, 0x05, // ĉY (U+0109 U+0059)
  0x01, 0x09, 0x00, 0xDD, 0x05, // ĉÝ (U+0109 U+00DD)
  0x01, 0x09, 0x01, 0x74, 0x05, // ĉŴ (U+0109 U+0174)
  0x01, 0x09, 0x01, 0x76, 0x05, // ĉŶ (U+0109 U+0176)
  0x01, 0x09, 0x01, 0x78, 0x05, // ĉŸ (U+0109 U+0178)
  0x01, 0x0A, 0x00, 0x26, 0x02, // Ċ& (U+010A U+0026)
  0x01, 0x0A, 0x00, 0x43, 0x01, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x01, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x01, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x01, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xC7, 0x01, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x01, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x01, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x01, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x01, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x01, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x01, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x01, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x01, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x01, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x01, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x01, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x01, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x01, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x01, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x01, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x01, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x01, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x01, // ĊŒ (U+010A U+0152)
  0x01, 0x0B, 0x00, 0x56, 0x05, // ċV (U+010B U+0056)
  0x01, 0x0B, 0x00, 0x57, 0x05, // ċW (U+010B U+0057)
  0x01, 0x0B, 0x00, 0x59, 0x05, // ċY (U+010B U+0059)
  0x01, 0x0B, 0x00, 0xDD, 0x05, // ċÝ (U+010B U+00DD)
  0x01, 0x0B, 0x01, 0x74, 0x05, // ċŴ (U+010B U+0174)
  0x01, 0x0B, 0x01, 0x76, 0x05, // ċŶ (U+010B U+0176)
  0x01, 0x0B, 0x01, 0x78, 0x05, // ċŸ (U+010B U+0178)
  0x01, 0x0C, 0x00, 0x26, 0x02, // Č& (U+010C U+0026)
  0x01, 0x0C, 0x00, 0x43, 0x01, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x01, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x01, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x01, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xC7, 0x01, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x01, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x01, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x01, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x01, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x01, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x01, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x01, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x01, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x01, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x01, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x01, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x01, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x01, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x01, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x01, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x01, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x01, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x01, // ČŒ (U+010C U+0152)
  0x01, 0x0D, 0x00, 0x56, 0x05, // čV (U+010D U+0056)
  0x01, 0x0D, 0x00, 0x57, 0x05, // čW (U+010D U+0057)
  0x01, 0x0D, 0x00, 0x59, 0x05, // čY (U+010D U+0059)
  0x01, 0x0D, 0x00, 0xDD, 0x05, // čÝ (U+010D U+00DD)
  0x01, 0x0D, 0x01, 0x74, 0x05, // čŴ (U+010D U+0174)
  0x01, 0x0D, 0x01, 0x76, 0x05, // čŶ (U+010D U+0176)
  0x01, 0x0D, 0x01, 0x78, 0x05, // čŸ (U+010D U+0178)
  0x01, 0x0E, 0x00, 0x22, 0x03, // Ď" (U+010E U+0022)
  0x01, 0x0E, 0x00, 0x27, 0x03, // Ď' (U+010E U+0027)
  0x01, 0x0E, 0x00, 0x2C, 0x02, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x02, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x41, 0x02, // ĎA (U+010E U+0041)
  0x01, 0x0E, 0x00, 0x54, 0x02, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x00, 0x56, 0x02, // ĎV (U+010E U+0056)
  0x01, 0x0E, 0x00, 0x57, 0x02, // ĎW (U+010E U+0057)
  0x01, 0x0E, 0x00, 0x58, 0x01, // ĎX (U+010E U+0058)
  0x01, 0x0E, 0x00, 0x59, 0x02, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0xC0, 0x02, // ĎÀ (U+010E U+00C0)
  0x01, 0x0E, 0x00, 0xC1, 0x02, // ĎÁ (U+010E U+00C1)
  0x01, 0x0E, 0x00, 0xC2, 0x02, // ĎÂ (U+010E U+00C2)
  0x01, 0x0E, 0x00, 0xC3, 0x02, // ĎÃ (U+010E U+00C3)
  0x01, 0x0E, 0x00, 0xC4, 0x02, // ĎÄ (U+010E U+00C4)
  0x01, 0x0E, 0x00, 0xC5, 0x02, // ĎÅ (U+010E U+00C5)
  0x01, 0x0E, 0x00, 0xC6, 0x04, // ĎÆ (U+010E U+00C6)
  0x01, 0x0E, 0x00, 0xDD, 0x02, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x00, 0x02, // ĎĀ (U+010E U+0100)
  0x01, 0x0E, 0x01, 0x02, 0x02, // ĎĂ (U+010E U+0102)
  0x01, 0x0E, 0x01, 0x04, 0x02, // ĎĄ (U+010E U+0104)
  0x01, 0x0E, 0x01, 0x74, 0x02, // ĎŴ (U+010E U+0174)
  0x01, 0x0E, 0x01, 0x76, 0x02, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x02, // ĎŸ (U+010E U+0178)
  0x01, 0x0E, 0x20, 0x1A, 0x02, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x02, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x02, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x22, 0x03, // Đ" (U+0110 U+0022)
  0x01, 0x10, 0x00, 0x27, 0x03, // Đ' (U+0110 U+0027)
  0x01, 0x10, 0x00, 0x2C, 0x02, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x02, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x41, 0x02, // ĐA (U+0110 U+0041)
  0x01, 0x10, 0x00, 0x54, 0x02, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x00, 0x56, 0x02, // ĐV (U+0110 U+0056)
  0x01, 0x10, 0x00, 0x57, 0x02, // ĐW (U+0110 U+0057)
  0x01, 0x10, 0x00, 0x58, 0x01, // ĐX (U+0110 U+0058)
  0x01, 0x10, 0x00, 0x59, 0x02, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0xC0, 0x02, // ĐÀ (U+0110 U+00C0)
  0x01, 0x10, 0x00, 0xC1, 0x02, // ĐÁ (U+0110 U+00C1)
  0x01, 0x10, 0x00, 0xC2, 0x02, // ĐÂ (U+0110 U+00C2)
  0x01, 0x10, 0x00, 0xC3, 0x02, // ĐÃ (U+0110 U+00C3)
  0x01, 0x10, 0x00, 0xC4, 0x02, // ĐÄ (U+0110 U+00C4)
  0x01, 0x10, 0x00, 0xC5, 0x02, // ĐÅ (U+0110 U+00C5)
  0x01, 0x10, 0x00, 0xC6, 0x04, // ĐÆ (U+0110 U+00C6)
  0x01, 0x10, 0x00, 0xDD, 0x02, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x00, 0x02, // ĐĀ (U+0110 U+0100)
  0x01, 0x10, 0x01, 0x02, 0x02, // ĐĂ (U+0110 U+0102)
  0x01, 0x10, 0x01, 0x04, 0x02, // ĐĄ (U+0110 U+0104)
  0x01, 0x10, 0x01, 0x74, 0x02, // ĐŴ (U+0110 U+0174)
  0x01, 0x10, 0x01, 0x76, 0x02, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x02, // ĐŸ (U+0110 U+0178)
  0x01, 0x10, 0x20, 0x1A, 0x02, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x02, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x02, // Đ… (U+0110 U+2026)
  0x01, 0x12, 0x00, 0x56, 0x02, // ĒV (U+0112 U+0056)
  0x01, 0x12, 0x00, 0x57, 0x02, // ĒW (U+0112 U+0057)
  0x01, 0x12, 0x00, 0x59, 0x02, // ĒY (U+0112 U+0059)
  0x01, 0x12, 0x00, 0xDD, 0x02, // ĒÝ (U+0112 U+00DD)
  0x01, 0x12, 0x01, 0x74, 0x02, // ĒŴ (U+0112 U+0174)
  0x01, 0x12, 0x01, 0x76, 0x02, // ĒŶ (U+0112 U+0176)
  0x01, 0x12, 0x01, 0x78, 0x02, // ĒŸ (U+0112 U+0178)
  0x01, 0x13, 0x00, 0x56, 0x05, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x05, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x05, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x05, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x05, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x05, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x05, // ēŸ (U+0113 U+0178)
  0x01, 0x14, 0x00, 0x56, 0x02, // ĔV (U+0114 U+0056)
  0x01, 0x14, 0x00, 0x57, 0x02, // ĔW (U+0114 U+0057)
  0x01, 0x14, 0x00, 0x59, 0x02, // ĔY (U+0114 U+0059)
  0x01, 0x14, 0x00, 0xDD, 0x02, // ĔÝ (U+0114 U+00DD)
  0x01, 0x14, 0x01, 0x74, 0x02, // ĔŴ (U+0114 U+0174)
  0x01, 0x14, 0x01, 0x76, 0x02, // ĔŶ (U+0114 U+0176)
  0x01, 0x14, 0x01, 0x78, 0x02, // ĔŸ (U+0114 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x05, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x05, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x05, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x05, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x05, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x05, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x05, // ĕŸ (U+0115 U+0178)
  0x01, 0x16, 0x00, 0x56, 0x02, // ĖV (U+0116 U+0056)
  0x01, 0x16, 0x00, 0x57, 0x02, // ĖW (U+0116 U+0057)
  0x01, 0x16, 0x00, 0x59, 0x02, // ĖY (U+0116 U+0059)
  0x01, 0x16, 0x00, 0xDD, 0x02, // ĖÝ (U+0116 U+00DD)
  0x01, 0x16, 0x01, 0x74, 0x02, // ĖŴ (U+0116 U+0174)
  0x01, 0x16, 0x01, 0x76, 0x02, // ĖŶ (U+0116 U+0176)
  0x01, 0x16, 0x01, 0x78, 0x02, // ĖŸ (U+0116 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x05, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x05, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x05, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x05, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x05, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x05, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x05, // ėŸ (U+0117 U+0178)
  0x01, 0x18, 0x00, 0x56, 0x02, // ĘV (U+0118 U+0056)
  0x01, 0x18, 0x00, 0x57, 0x02, // ĘW (U+0118 U+0057)
  0x01, 0x18, 0x00, 0x59, 0x02, // ĘY (U+0118 U+0059)
  0x01, 0x18, 0x00, 0xDD, 0x02, // ĘÝ (U+0118 U+00DD)
  0x01, 0x18, 0x01, 0x74, 0x02, // ĘŴ (U+0118 U+0174)
  0x01, 0x18, 0x01, 0x76, 0x02, // ĘŶ (U+0118 U+0176)
  0x01, 0x18, 0x01, 0x78, 0x02, // ĘŸ (U+0118 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x05, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x05, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x05, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x05, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x05, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x05, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x05, // ęŸ (U+0119 U+0178)
  0x01, 0x1A, 0x00, 0x56, 0x02, // ĚV (U+011A U+0056)
  0x01, 0x1A, 0x00, 0x57, 0x02, // ĚW (U+011A U+0057)
  0x01, 0x1A, 0x00, 0x59, 0x02, // ĚY (U+011A U+0059)
  0x01, 0x1A, 0x00, 0xDD, 0x02, // ĚÝ (U+011A U+00DD)
  0x01, 0x1A, 0x01, 0x74, 0x02, // ĚŴ (U+011A U+0174)
  0x01, 0x1A, 0x01, 0x76, 0x02, // ĚŶ (U+011A U+0176)
  0x01, 0x1A, 0x01, 0x78, 0x02, // ĚŸ (U+011A U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x05, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x05, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x05, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x05, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x05, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x05, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x05, // ěŸ (U+011B U+0178)
  0x01, 0x1C, 0x00, 0x54, 0x02, // ĜT (U+011C U+0054)
  0x01, 0x1C, 0x00, 0x56, 0x02, // ĜV (U+011C U+0056)
  0x01, 0x1C, 0x00, 0x57, 0x02, // ĜW (U+011C U+0057)
  0x01, 0x1C, 0x00, 0x59, 0x02, // ĜY (U+011C U+0059)
  0x01, 0x1C, 0x00, 0xC6, 0x02, // ĜÆ (U+011C U+00C6)
  0x01, 0x1C, 0x00, 0xDD, 0x02, // ĜÝ (U+011C U+00DD)
  0x01, 0x1C, 0x01, 0x74, 0x02, // ĜŴ (U+011C U+0174)
  0x01, 0x1C, 0x01, 0x76, 0x02, // ĜŶ (U+011C U+0176)
  0x01, 0x1C, 0x01, 0x78, 0x02, // ĜŸ (U+011C U+0178)
  0x01, 0x1E, 0x00, 0x54, 0x02, // ĞT (U+011E U+0054)
  0x01, 0x1E, 0x00, 0x56, 0x02, // ĞV (U+011E U+0056)
  0x01, 0x1E, 0x00, 0x57, 0x02, // ĞW (U+011E U+0057)
  0x01, 0x1E, 0x00, 0x59, 0x02, // ĞY (U+011E U+0059)
  0x01, 0x1E, 0x00, 0xC6, 0x02, // ĞÆ (U+011E U+00C6)
  0x01, 0x1E, 0x00, 0xDD, 0x02, // ĞÝ (U+011E U+00DD)
  0x01, 0x1E, 0x01, 0x74, 0x02, // ĞŴ (U+011E U+0174)
  0x01, 0x1E, 0x01, 0x76, 0x02, // ĞŶ (U+011E U+0176)
  0x01, 0x1E, 0x01, 0x78, 0x02, // ĞŸ (U+011E U+0178)
  0x01, 0x20, 0x00, 0x54, 0x02, // ĠT (U+0120 U+0054)
  0x01, 0x20, 0x00, 0x56, 0x02, // ĠV (U+0120 U+0056)
  0x01, 0x20, 0x00, 0x57, 0x02, // ĠW (U+0120 U+0057)
  0x01, 0x20, 0x00, 0x59, 0x02, // ĠY (U+0120 U+0059)
  0x01, 0x20, 0x00, 0xC6, 0x02, // ĠÆ (U+0120 U+00C6)
  0x01, 0x20, 0x00, 0xDD, 0x02, // ĠÝ (U+0120 U+00DD)
  0x01, 0x20, 0x01, 0x74, 0x02, // ĠŴ (U+0120 U+0174)
  0x01, 0x20, 0x01, 0x76, 0x02, // ĠŶ (U+0120 U+0176)
  0x01, 0x20, 0x01, 0x78, 0x02, // ĠŸ (U+0120 U+0178)
  0x01, 0x22, 0x00, 0x54, 0x02, // ĢT (U+0122 U+0054)
  0x01, 0x22, 0x00, 0x56, 0x02, // ĢV (U+0122 U+0056)
  0x01, 0x22, 0x00, 0x57, 0x02, // ĢW (U+0122 U+0057)
  0x01, 0x22, 0x00, 0x59, 0x02, // ĢY (U+0122 U+0059)
  0x01, 0x22, 0x00, 0xC6, 0x02, // ĢÆ (U+0122 U+00C6)
  0x01, 0x22, 0x00, 0xDD, 0x02, // ĢÝ (U+0122 U+00DD)
  0x01, 0x22, 0x01, 0x74, 0x02, // ĢŴ (U+0122 U+0174)
  0x01, 0x22, 0x01, 0x76, 0x02, // ĢŶ (U+0122 U+0176)
  0x01, 0x22, 0x01, 0x78, 0x02, // ĢŸ (U+0122 U+0178)
  0x01, 0x25, 0x00, 0x22, 0x04, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x04, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x00, 0x2A, 0x01, // ĥ* (U+0125 U+002A)
  0x01, 0x25, 0x00, 0x54, 0x02, // ĥT (U+0125 U+0054)
  0x01, 0x25, 0x00, 0x56, 0x05, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x57, 0x04, // ĥW (U+0125 U+0057)
  0x01, 0x25, 0x00, 0x59, 0x05, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0x79, 0x01, // ĥy (U+0125 U+0079)
  0x01, 0x25, 0x00, 0xDD, 0x05, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x00, 0xFD, 0x01, // ĥý (U+0125 U+00FD)
  0x01, 0x25, 0x00, 0xFF, 0x01, // ĥÿ (U+0125 U+00FF)
  0x01, 0x25, 0x01, 0x74, 0x04, // ĥŴ (U+0125 U+0174)
  0x01, 0x25, 0x01, 0x76, 0x05, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x77, 0x01, // ĥŷ (U+0125 U+0177)
  0x01, 0x25, 0x01, 0x78, 0x05, // ĥŸ (U+0125 U+0178)
  0x01, 0x25, 0x20, 0x18, 0x03, // ĥ‘ (U+0125 U+2018)
  0x01, 0x25, 0x20, 0x19, 0x01, // ĥ’ (U+0125 U+2019)
  0x01, 0x25, 0x20, 0x1C, 0x03, // ĥ“ (U+0125 U+201C)
  0x01, 0x25, 0x20, 0x1D, 0x01, // ĥ” (U+0125 U+201D)
  0x01, 0x25, 0x21, 0x22, 0x01, // ĥ™ (U+0125 U+2122)
  0x01, 0x27, 0x00, 0x22, 0x04, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x04, // ħ' (U+0127 U+0027)
  0x01, 0x27, 0x00, 0x2A, 0x01, // ħ* (U+0127 U+002A)
  0x01, 0x27, 0x00, 0x54, 0x02, // ħT (U+0127 U+0054)
  0x01, 0x27, 0x00, 0x56, 0x05, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x57, 0x04, // ħW (U+0127 U+0057)
  0x01, 0x27, 0x00, 0x59, 0x05, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0x79, 0x01, // ħy (U+0127 U+0079)
  0x01, 0x27, 0x00, 0xDD, 0x05, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x00, 0xFD, 0x01, // ħý (U+0127 U+00FD)
  0x01, 0x27, 0x00, 0xFF, 0x01, // ħÿ (U+0127 U+00FF)
  0x01, 0x27, 0x01, 0x74, 0x04, // ħŴ (U+0127 U+0174)
  0x01, 0x27, 0x01, 0x76, 0x05, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x77, 0x01, // ħŷ (U+0127 U+0177)
  0x01, 0x27, 0x01, 0x78, 0x05, // ħŸ (U+0127 U+0178)
  0x01, 0x27, 0x20, 0x18, 0x03, // ħ‘ (U+0127 U+2018)
  0x01, 0x27, 0x20, 0x19, 0x01, // ħ’ (U+0127 U+2019)
  0x01, 0x27, 0x20, 0x1C, 0x03, // ħ“ (U+0127 U+201C)
  0x01, 0x27, 0x20, 0x1D, 0x01, // ħ” (U+0127 U+201D)
  0x01, 0x27, 0x21, 0x22, 0x01, // ħ™ (U+0127 U+2122)
  0x01, 0x32, 0x00, 0x2C, 0x02, // Ĳ, (U+0132 U+002C)
  0x01, 0x32, 0x00, 0x2E, 0x02, // Ĳ. (U+0132 U+002E)
  0x01, 0x32, 0x00, 0x41, 0x02, // ĲA (U+0132 U+0041)
  0x01, 0x32, 0x00, 0xC0, 0x02, // ĲÀ (U+0132 U+00C0)
  0x01, 0x32, 0x00, 0xC1, 0x02, // ĲÁ (U+0132 U+00C1)
  0x01, 0x32, 0x00, 0xC2, 0x02, // ĲÂ (U+0132 U+00C2)
  0x01, 0x32, 0x00, 0xC3, 0x02, // ĲÃ (U+0132 U+00C3)
  0x01, 0x32, 0x00, 0xC4, 0x02, // ĲÄ (U+0132 U+00C4)
  0x01, 0x32, 0x00, 0xC5, 0x02, // ĲÅ (U+0132 U+00C5)
  0x01, 0x32, 0x01, 0x00, 0x02, // ĲĀ (U+0132 U+0100)
  0x01, 0x32, 0x01, 0x02, 0x02, // ĲĂ (U+0132 U+0102)
  0x01, 0x32, 0x01, 0x04, 0x02, // ĲĄ (U+0132 U+0104)
  0x01, 0x32, 0x20, 0x1A, 0x02, // Ĳ‚ (U+0132 U+201A)
  0x01, 0x32, 0x20, 0x1E, 0x02, // Ĳ„ (U+0132 U+201E)
  0x01, 0x32, 0x20, 0x26, 0x02, // Ĳ… (U+0132 U+2026)
  0x01, 0x34, 0x00, 0x2C, 0x02, // Ĵ, (U+0134 U+002C)
  0x01, 0x34, 0x00, 0x2E, 0x02, // Ĵ. (U+0134 U+002E)
  0x01, 0x34, 0x00, 0x41, 0x02, // ĴA (U+0134 U+0041)
  0x01, 0x34, 0x00, 0xC0, 0x02, // ĴÀ (U+0134 U+00C0)
  0x01, 0x34, 0x00, 0xC1, 0x02, // ĴÁ (U+0134 U+00C1)
  0x01, 0x34, 0x00, 0xC2, 0x02, // ĴÂ (U+0134 U+00C2)
  0x01, 0x34, 0x00, 0xC3, 0x02, // ĴÃ (U+0134 U+00C3)
  0x01, 0x34, 0x00, 0xC4, 0x02, // ĴÄ (U+0134 U+00C4)
  0x01, 0x34, 0x00, 0xC5, 0x02, // ĴÅ (U+0134 U+00C5)
  0x01, 0x34, 0x01, 0x00, 0x02, // ĴĀ (U+0134 U+0100)
  0x01, 0x34, 0x01, 0x02, 0x02, // ĴĂ (U+0134 U+0102)
  0x01, 0x34, 0x01, 0x04, 0x02, // ĴĄ (U+0134 U+0104)
  0x01, 0x34, 0x20, 0x1A, 0x02, // Ĵ‚ (U+0134 U+201A)
  0x01, 0x34, 0x20, 0x1E, 0x02, // Ĵ„ (U+0134 U+201E)
  0x01, 0x34, 0x20, 0x26, 0x02, // Ĵ… (U+0134 U+2026)
  0x01, 0x36, 0x00, 0x26, 0x02, // Ķ& (U+0136 U+0026)
  0x01, 0x36, 0x00, 0x43, 0x02, // ĶC (U+0136 U+0043)
  0x01, 0x36, 0x00, 0x47, 0x02, // ĶG (U+0136 U+0047)
  0x01, 0x36, 0x00, 0x4F, 0x02, // ĶO (U+0136 U+004F)
  0x01, 0x36, 0x00, 0x51, 0x02, // ĶQ (U+0136 U+0051)
  0x01, 0x36, 0x00, 0x61, 0x01, // Ķa (U+0136 U+0061)
  0x01, 0x36, 0x00, 0x63, 0x02, // Ķc (U+0136 U+0063)
  0x01, 0x36, 0x00, 0x64, 0x02, // Ķd (U+0136 U+0064)
  0x01, 0x36, 0x00, 0x65, 0x02, // Ķe (U+0136 U+0065)
  0x01, 0x36, 0x00, 0x67, 0x02, // Ķg (U+0136 U+0067)
  0x01, 0x36, 0x00, 0x6F, 0x02, // Ķo (U+0136 U+006F)
  0x01, 0x36, 0x00, 0x71, 0x02, // Ķq (U+0136 U+0071)
  0x01, 0x36, 0x00, 0x75, 0x02, // Ķu (U+0136 U+0075)
  0x01, 0x36, 0x00, 0x76, 0x01, // Ķv (U+0136 U+0076)
  0x01, 0x36, 0x00, 0x77, 0x03, // Ķw (U+0136 U+0077)
  0x01, 0x36, 0x00, 0x79, 0x03, // Ķy (U+0136 U+0079)
  0x01, 0x36, 0x00, 0xC7, 0x02, // ĶÇ (U+0136 U+00C7)
  0x01, 0x36, 0x00, 0xD2, 0x02, // ĶÒ (U+0136 U+00D2)
  0x01, 0x36, 0x00, 0xD3, 0x02, // ĶÓ (U+0136 U+00D3)
  0x01, 0x36, 0x00, 0xD4, 0x02, // ĶÔ (U+0136 U+00D4)
  0x01, 0x36, 0x00, 0xD5, 0x02, // ĶÕ (U+0136 U+00D5)
  0x01, 0x36, 0x00, 0xD6, 0x02, // ĶÖ (U+0136 U+00D6)
  0x01, 0x36, 0x00, 0xD8, 0x02, // ĶØ (U+0136 U+00D8)
  0x01, 0x36, 0x00, 0xE0, 0x01, // Ķà (U+0136 U+00E0)
  0x01, 0x36, 0x00, 0xE1, 0x01, // Ķá (U+0136 U+00E1)
  0x01, 0x36, 0x00, 0xE2, 0x01, // Ķâ (U+0136 U+00E2)
  0x01, 0x36, 0x00, 0xE3, 0x01, // Ķã (U+0136 U+00E3)
  0x01, 0x36, 0x00, 0xE4, 0x01, // Ķä (U+0136 U+00E4)
  0x01, 0x36, 0x00, 0xE5, 0x01, // Ķå (U+0136 U+00E5)
  0x01, 0x36, 0x00, 0xE6, 0x01, // Ķæ (U+0136 U+00E6)
  0x01, 0x36, 0x00, 0xE7, 0x02, // Ķç (U+0136 U+00E7)
  0x01, 0x36, 0x00, 0xE8, 0x02, // Ķè (U+0136 U+00E8)
  0x01, 0x36, 0x00, 0xE9, 0x02, // Ķé (U+0136 U+00E9)
  0x01, 0x36, 0x00, 0xEA, 0x02, // Ķê (U+0136 U+00EA)
  0x01, 0x36, 0x00, 0xEB, 0x02, // Ķë (U+0136 U+00EB)
  0x01, 0x36, 0x00, 0xF0, 0x02, // Ķð (U+0136 U+00F0)
  0x01, 0x36, 0x00, 0xF2, 0x02, // Ķò (U+0136 U+00F2)
  0x01, 0x36, 0x00, 0xF3, 0x02, // Ķó (U+0136 U+00F3)
  0x01, 0x36, 0x00, 0xF4, 0x02, // Ķô (U+0136 U+00F4)
  0x01, 0x36, 0x00, 0xF5, 0x02, // Ķõ (U+0136 U+00F5)
  0x01, 0x36, 0x00, 0xF6, 0x02, // Ķö (U+0136 U+00F6)
  0x01, 0x36, 0x00, 0xF8, 0x02, // Ķø (U+0136 U+00F8)
  0x01, 0x36, 0x00, 0xF9, 0x02, // Ķù (U+0136 U+00F9)
  0x01, 0x36, 0x00, 0xFA, 0x02, // Ķú (U+0136 U+00FA)
  0x01, 0x36, 0x00, 0xFB, 0x02, // Ķû (U+0136 U+00FB)
  0x01, 0x36, 0x00, 0xFC, 0x02, // Ķü (U+0136 U+00FC)
  0x01, 0x36, 0x00, 0xFD, 0x03, // Ķý (U+0136 U+00FD)
  0x01, 0x36, 0x00, 0xFF, 0x03, // Ķÿ (U+0136 U+00FF)
  0x01, 0x36, 0x01, 0x01, 0x01, // Ķā (U+0136 U+0101)
  0x01, 0x36, 0x01, 0x03, 0x01, // Ķă (U+0136 U+0103)
  0x01, 0x36, 0x01, 0x05, 0x01, // Ķą (U+0136 U+0105)
  0x01, 0x36, 0x01, 0x06, 0x02, // ĶĆ (U+0136 U+0106)
  0x01, 0x36, 0x01, 0x07, 0x02, // Ķć (U+0136 U+0107)
  0x01, 0x36, 0x01, 0x08, 0x02, // ĶĈ (U+0136 U+0108)
  0x01, 0x36, 0x01, 0x09, 0x02, // Ķĉ (U+0136 U+0109)
  0x01, 0x36, 0x01, 0x0A, 0x02, // ĶĊ (U+0136 U+010A)
  0x01, 0x36, 0x01, 0x0B, 0x02, // Ķċ (U+0136 U+010B)
  0x01, 0x36, 0x01, 0x0C, 0x02, // ĶČ (U+0136 U+010C)
  0x01, 0x36, 0x01, 0x0D, 0x02, // Ķč (U+0136 U+010D)
  0x01, 0x36, 0x01, 0x0F, 0x02, // Ķď (U+0136 U+010F)
  0x01, 0x36, 0x01, 0x11, 0x02, // Ķđ (U+0136 U+0111)
  0x01, 0x36, 0x01, 0x13, 0x02, // Ķē (U+0136 U+0113)
  0x01, 0x36, 0x01, 0x15, 0x02, // Ķĕ (U+0136 U+0115)
  0x01, 0x36, 0x01, 0x17, 0x02, // Ķė (U+0136 U+0117)
  0x01, 0x36, 0x01, 0x19, 0x02, // Ķę (U+0136 U+0119)
  0x01, 0x36, 0x01, 0x1B, 0x02, // Ķě (U+0136 U+011B)
  0x01, 0x36, 0x01, 0x1C, 0x02, // ĶĜ (U+0136 U+011C)
  0x01, 0x36, 0x01, 0x1D, 0x02, // Ķĝ (U+0136 U+011D)
  0x01, 0x36, 0x01, 0x1E, 0x02, // ĶĞ (U+0136 U+011E)
  0x01, 0x36, 0x01, 0x1F, 0x02, // Ķğ (U+0136 U+011F)
  0x01, 0x36, 0x01, 0x20, 0x02, // ĶĠ (U+0136 U+0120)
  0x01, 0x36, 0x01, 0x21, 0x02, // Ķġ (U+0136 U+0121)
  0x01, 0x36, 0x01, 0x22, 0x02, // ĶĢ (U+0136 U+0122)
  0x01, 0x36, 0x01, 0x23, 0x02, // Ķģ (U+0136 U+0123)
  0x01, 0x36, 0x01, 0x4C, 0x02, // ĶŌ (U+0136 U+014C)
  0x01, 0x36, 0x01, 0x4D, 0x02, // Ķō (U+0136 U+014D)
  0x01, 0x36, 0x01, 0x4E, 0x02, // ĶŎ (U+0136 U+014E)
  0x01, 0x36, 0x01, 0x4F, 0x02, // Ķŏ (U+0136 U+014F)
  0x01, 0x36, 0x01, 0x50, 0x02, // ĶŐ (U+0136 U+0150)
  0x01, 0x36, 0x01, 0x51, 0x02, // Ķő (U+0136 U+0151)
  0x01, 0x36, 0x01, 0x52, 0x02, // ĶŒ (U+0136 U+0152)
  0x01, 0x36, 0x01, 0x53, 0x02, // Ķœ (U+0136 U+0153)
  0x01, 0x36, 0x01, 0x69, 0x02, // Ķũ (U+0136 U+0169)
  0x01, 0x36, 0x01, 0x6B, 0x02, // Ķū (U+0136 U+016B)
  0x01, 0x36, 0x01, 0x6D, 0x02, // Ķŭ (U+0136 U+016D)
  0x01, 0x36, 0x01, 0x6F, 0x02, // Ķů (U+0136 U+016F)
  0x01, 0x36, 0x01, 0x71, 0x02, // Ķű (U+0136 U+0171)
  0x01, 0x36, 0x01, 0x73, 0x02, // Ķų (U+0136 U+0173)
  0x01, 0x36, 0x01, 0x75, 0x03, // Ķŵ (U+0136 U+0175)
  0x01, 0x36, 0x01, 0x77, 0x03, // Ķŷ (U+0136 U+0177)
  0x01, 0x37, 0x00, 0x63, 0x01, // ķc (U+0137 U+0063)
  0x01, 0x37, 0x00, 0x64, 0x01, // ķd (U+0137 U+0064)
  0x01, 0x37, 0x00, 0x65, 0x01, // ķe (U+0137 U+0065)
  0x01, 0x37, 0x00, 0x67, 0x01, // ķg (U+0137 U+0067)
  0x01, 0x37, 0x00, 0x6F, 0x01, // ķo (U+0137 U+006F)
  0x01, 0x37, 0x00, 0x71, 0x01, // ķq (U+0137 U+0071)
  0x01, 0x37, 0x00, 0xE7, 0x01, // ķç (U+0137 U+00E7)
  0x01, 0x37, 0x00, 0xE8, 0x01, // ķè (U+0137 U+00E8)
  0x01, 0x37, 0x00, 0xE9, 0x01, // ķé (U+0137 U+00E9)
  0x01, 0x37, 0x00, 0xEA, 0x01, // ķê (U+0137 U+00EA)
  0x01, 0x37, 0x00, 0xEB, 0x01, // ķë (U+0137 U+00EB)
  0x01, 0x37, 0x00, 0xF0, 0x01, // ķð (U+0137 U+00F0)
  0x01, 0x37, 0x00, 0xF2, 0x01, // ķò (U+0137 U+00F2)
  0x01, 0x37, 0x00, 0xF3, 0x01, // ķó (U+0137 U+00F3)
  0x01, 0x37, 0x00, 0xF4, 0x01, // ķô (U+0137 U+00F4)
  0x01, 0x37, 0x00, 0xF5, 0x01, // ķõ (U+0137 U+00F5)
  0x01, 0x37, 0x00, 0xF6, 0x01, // ķö (U+0137 U+00F6)
  0x01, 0x37, 0x00, 0xF8, 0x01, // ķø (U+0137 U+00F8)
  0x01, 0x37, 0x01, 0x07, 0x01, // ķć (U+0137 U+0107)
  0x01, 0x37, 0x01, 0x09, 0x01, // ķĉ (U+0137 U+0109)
  0x01, 0x37, 0x01, 0x0B, 0x01, // ķċ (U+0137 U+010B)
  0x01, 0x37, 0x01, 0x0D, 0x01, // ķč (U+0137 U+010D)
  0x01, 0x37, 0x01, 0x0F, 0x01, // ķď (U+0137 U+010F)
  0x01, 0x37, 0x01, 0x11, 0x01, // ķđ (U+0137 U+0111)
  0x01, 0x37, 0x01, 0x13, 0x01, // ķē (U+0137 U+0113)
  0x01, 0x37, 0x01, 0x15, 0x01, // ķĕ (U+0137 U+0115)
  0x01, 0x37, 0x01, 0x17, 0x01, // ķė (U+0137 U+0117)
  0x01, 0x37, 0x01, 0x19, 0x01, // ķę (U+0137 U+0119)
  0x01, 0x37, 0x01, 0x1B, 0x01, // ķě (U+0137 U+011B)
  0x01, 0x37, 0x01, 0x1D, 0x01, // ķĝ (U+0137 U+011D)
  0x01, 0x37, 0x01, 0x1F, 0x01, // ķğ (U+0137 U+011F)
  0x01, 0x37, 0x01, 0x21, 0x01, // ķġ (U+0137 U+0121)
  0x01, 0x37, 0x01, 0x23, 0x01, // ķģ (U+0137 U+0123)
  0x01, 0x37, 0x01, 0x4D, 0x01, // ķō (U+0137 U+014D)
  0x01, 0x37, 0x01, 0x4F, 0x01, // ķŏ (U+0137 U+014F)
  0x01, 0x37, 0x01, 0x51, 0x01, // ķő (U+0137 U+0151)
  0x01, 0x37, 0x01, 0x53, 0x01, // ķœ (U+0137 U+0153)
  0x01, 0x38, 0x00, 0x63, 0x01, // ĸc (U+0138 U+0063)
  0x01, 0x38, 0x00, 0x64, 0x01, // ĸd (U+0138 U+0064)
  0x01, 0x38, 0x00, 0x65, 0x01, // ĸe (U+0138 U+0065)
  0x01, 0x38, 0x00, 0x67, 0x01, // ĸg (U+0138 U+0067)
  0x01, 0x38, 0x00, 0x6F, 0x01, // ĸo (U+0138 U+006F)
  0x01, 0x38, 0x00, 0x71, 0x01, // ĸq (U+0138 U+0071)
  0x01, 0x38, 0x00, 0xE7, 0x01, // ĸç (U+0138 U+00E7)
  0x01, 0x38, 0x00, 0xE8, 0x01, // ĸè (U+0138 U+00E8)
  0x01, 0x38, 0x00, 0xE9, 0x01, // ĸé (U+0138 U+00E9)
  0x01, 0x38, 0x00, 0xEA, 0x01, // ĸê (U+0138 U+00EA)
  0x01, 0x38, 0x00, 0xEB, 0x01, // ĸë (U+0138 U+00EB)
  0x01, 0x38, 0x00, 0xF0, 0x01, // ĸð (U+0138 U+00F0)
  0x01, 0x38, 0x00, 0xF2, 0x01, // ĸò (U+0138 U+00F2)
  0x01, 0x38, 0x00, 0xF3, 0x01, // ĸó (U+0138 U+00F3)
  0x01, 0x38, 0x00, 0xF4, 0x01, // ĸô (U+0138 U+00F4)
  0x01, 0x38, 0x00, 0xF5, 0x01, // ĸõ (U+0138 U+00F5)
  0x01, 0x38, 0x00, 0xF6, 0x01, // ĸö (U+0138 U+00F6)
  0x01, 0x38, 0x00, 0xF8, 0x01, // ĸø (U+0138 U+00F8)
  0x01, 0x38, 0x01, 0x07, 0x01, // ĸć (U+0138 U+0107)
  0x01, 0x38, 0x01, 0x09, 0x01, // ĸĉ (U+0138 U+0109)
  0x01, 0x38, 0x01, 0x0B, 0x01, // ĸċ (U+0138 U+010B)
  0x01, 0x38, 0x01, 0x0D, 0x01, // ĸč (U+0138 U+010D)
  0x01, 0x38, 0x01, 0x0F, 0x01, // ĸď (U+0138 U+010F)
  0x01, 0x38, 0x01, 0x11, 0x01, // ĸđ (U+0138 U+0111)
  0x01, 0x38, 0x01, 0x13, 0x01, // ĸē (U+0138 U+0113)
  0x01, 0x38, 0x01, 0x15, 0x01, // ĸĕ (U+0138 U+0115)
  0x01, 0x38, 0x01, 0x17, 0x01, // ĸė (U+0138 U+0117)
  0x01, 0x38, 0x01, 0x19, 0x01, // ĸę (U+0138 U+0119)
  0x01, 0x38, 0x01, 0x1B, 0x01, // ĸě (U+0138 U+011B)
  0x01, 0x38, 0x01, 0x1D, 0x01, // ĸĝ (U+0138 U+011D)
  0x01, 0x38, 0x01, 0x1F, 0x01, // ĸğ (U+0138 U+011F)
  0x01, 0x38, 0x01, 0x21, 0x01, // ĸġ (U+0138 U+0121)
  0x01, 0x38, 0x01, 0x23, 0x01, // ĸģ (U+0138 U+0123)
  0x01, 0x38, 0x01, 0x4D, 0x01, // ĸō (U+0138 U+014D)
  0x01, 0x38, 0x01, 0x4F, 0x01, // ĸŏ (U+0138 U+014F)
  0x01, 0x38, 0x01, 0x51, 0x01, // ĸő (U+0138 U+0151)
  0x01, 0x38, 0x01, 0x53, 0x01, // ĸœ (U+0138 U+0153)
  0x01, 0x39, 0x00, 0x22, 0x05, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x05, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x07, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x06, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x55, 0x02, // ĹU (U+0139 U+0055)
  0x01, 0x39, 0x00, 0x56, 0x07, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x05, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x05, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0x76, 0x03, // Ĺv (U+0139 U+0076)
  0x01, 0x39, 0x00, 0x79, 0x01, // Ĺy (U+0139 U+0079)
  0x01, 0x39, 0x00, 0xD9, 0x02, // ĹÙ (U+0139 U+00D9)
  0x01, 0x39, 0x00, 0xDA, 0x02, // ĹÚ (U+0139 U+00DA)
  0x01, 0x39, 0x00, 0xDB, 0x02, // ĹÛ (U+0139 U+00DB)
  0x01, 0x39, 0x00, 0xDC, 0x02, // ĹÜ (U+0139 U+00DC)
  0x01, 0x39, 0x00, 0xDD, 0x05, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x00, 0xFD, 0x01, // Ĺý (U+0139 U+00FD)
  0x01, 0x39, 0x00, 0xFF, 0x01, // Ĺÿ (U+0139 U+00FF)
  0x01, 0x39, 0x01, 0x68, 0x02, // ĹŨ (U+0139 U+0168)
  0x01, 0x39, 0x01, 0x6A, 0x02, // ĹŪ (U+0139 U+016A)
  0x01, 0x39, 0x01, 0x6C, 0x02, // ĹŬ (U+0139 U+016C)
  0x01, 0x39, 0x01, 0x6E, 0x02, // ĹŮ (U+0139 U+016E)
  0x01, 0x39, 0x01, 0x70, 0x02, // ĹŰ (U+0139 U+0170)
  0x01, 0x39, 0x01, 0x72, 0x02, // ĹŲ (U+0139 U+0172)
  0x01, 0x39, 0x01, 0x74, 0x05, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x05, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x77, 0x01, // Ĺŷ (U+0139 U+0177)
  0x01, 0x39, 0x01, 0x78, 0x05, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x08, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x07, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x08, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x07, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x07, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x05, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x05, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x07, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x06, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x55, 0x02, // ĻU (U+013B U+0055)
  0x01, 0x3B, 0x00, 0x56, 0x07, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x05, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x05, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0x76, 0x03, // Ļv (U+013B U+0076)
  0x01, 0x3B, 0x00, 0x79, 0x01, // Ļy (U+013B U+0079)
  0x01, 0x3B, 0x00, 0xD9, 0x02, // ĻÙ (U+013B U+00D9)
  0x01, 0x3B, 0x00, 0xDA, 0x02, // ĻÚ (U+013B U+00DA)
  0x01, 0x3B, 0x00, 0xDB, 0x02, // ĻÛ (U+013B U+00DB)
  0x01, 0x3B, 0x00, 0xDC, 0x02, // ĻÜ (U+013B U+00DC)
  0x01, 0x3B, 0x00, 0xDD, 0x05, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x00, 0xFD, 0x01, // Ļý (U+013B U+00FD)
  0x01, 0x3B, 0x00, 0xFF, 0x01, // Ļÿ (U+013B U+00FF)
  0x01, 0x3B, 0x01, 0x68, 0x02, // ĻŨ (U+013B U+0168)
  0x01, 0x3B, 0x01, 0x6A, 0x02, // ĻŪ (U+013B U+016A)
  0x01, 0x3B, 0x01, 0x6C, 0x02, // ĻŬ (U+013B U+016C)
  0x01, 0x3B, 0x01, 0x6E, 0x02, // ĻŮ (U+013B U+016E)
  0x01, 0x3B, 0x01, 0x70, 0x02, // ĻŰ (U+013B U+0170)
  0x01, 0x3B, 0x01, 0x72, 0x02, // ĻŲ (U+013B U+0172)
  0x01, 0x3B, 0x01, 0x74, 0x05, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x05, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x77, 0x01, // Ļŷ (U+013B U+0177)
  0x01, 0x3B, 0x01, 0x78, 0x05, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x08, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x07, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x08, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x07, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x07, // Ļ™ (U+013B U+2122)
  0x01, 0x3D, 0x00, 0x2A, 0x03, // Ľ* (U+013D U+002A)
  0x01, 0x3D, 0x00, 0x54, 0x03, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x05, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x20, 0x19, 0x03, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x03, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x21, 0x22, 0x03, // Ľ™ (U+013D U+2122)
  0x01, 0x41, 0x00, 0x22, 0x05, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x05, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x07, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x06, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x55, 0x02, // ŁU (U+0141 U+0055)
  0x01, 0x41, 0x00, 0x56, 0x07, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x05, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x05, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0x76, 0x03, // Łv (U+0141 U+0076)
  0x01, 0x41, 0x00, 0x79, 0x01, // Ły (U+0141 U+0079)
  0x01, 0x41, 0x00, 0xD9, 0x02, // ŁÙ (U+0141 U+00D9)
  0x01, 0x41, 0x00, 0xDA, 0x02, // ŁÚ (U+0141 U+00DA)
  0x01, 0x41, 0x00, 0xDB, 0x02, // ŁÛ (U+0141 U+00DB)
  0x01, 0x41, 0x00, 0xDC, 0x02, // ŁÜ (U+0141 U+00DC)
  0x01, 0x41, 0x00, 0xDD, 0x05, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x00, 0xFD, 0x01, // Łý (U+0141 U+00FD)
  0x01, 0x41, 0x00, 0xFF, 0x01, // Łÿ (U+0141 U+00FF)
  0x01, 0x41, 0x01, 0x68, 0x02, // ŁŨ (U+0141 U+0168)
  0x01, 0x41, 0x01, 0x6A, 0x02, // ŁŪ (U+0141 U+016A)
  0x01, 0x41, 0x01, 0x6C, 0x02, // ŁŬ (U+0141 U+016C)
  0x01, 0x41, 0x01, 0x6E, 0x02, // ŁŮ (U+0141 U+016E)
  0x01, 0x41, 0x01, 0x70, 0x02, // ŁŰ (U+0141 U+0170)
  0x01, 0x41, 0x01, 0x72, 0x02, // ŁŲ (U+0141 U+0172)
  0x01, 0x41, 0x01, 0x74, 0x05, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x05, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x77, 0x01, // Łŷ (U+0141 U+0177)
  0x01, 0x41, 0x01, 0x78, 0x05, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x08, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x07, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x08, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x07, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x07, // Ł™ (U+0141 U+2122)
  0x01, 0x43, 0x00, 0x26, 0x02, // Ń& (U+0143 U+0026)
  0x01, 0x43, 0x00, 0x2C, 0x02, // Ń, (U+0143 U+002C)
  0x01, 0x43, 0x00, 0x2E, 0x02, // Ń. (U+0143 U+002E)
  0x01, 0x43, 0x20, 0x1A, 0x02, // Ń‚ (U+0143 U+201A)
  0x01, 0x43, 0x20, 0x1E, 0x02, // Ń„ (U+0143 U+201E)
  0x01, 0x43, 0x20, 0x26, 0x02, // Ń… (U+0143 U+2026)
  0x01, 0x44, 0x00, 0x22, 0x04, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x04, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x00, 0x2A, 0x01, // ń* (U+0144 U+002A)
  0x01, 0x44, 0x00, 0x54, 0x02, // ńT (U+0144 U+0054)
  0x01, 0x44, 0x00, 0x56, 0x05, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x57, 0x04, // ńW (U+0144 U+0057)
  0x01, 0x44, 0x00, 0x59, 0x05, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0x79, 0x01, // ńy (U+0144 U+0079)
  0x01, 0x44, 0x00, 0xDD, 0x05, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x00, 0xFD, 0x01, // ńý (U+0144 U+00FD)
  0x01, 0x44, 0x00, 0xFF, 0x01, // ńÿ (U+0144 U+00FF)
  0x01, 0x44, 0x01, 0x74, 0x04, // ńŴ (U+0144 U+0174)
  0x01, 0x44, 0x01, 0x76, 0x05, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x77, 0x01, // ńŷ (U+0144 U+0177)
  0x01, 0x44, 0x01, 0x78, 0x05, // ńŸ (U+0144 U+0178)
  0x01, 0x44, 0x20, 0x18, 0x03, // ń‘ (U+0144 U+2018)
  0x01, 0x44, 0x20, 0x19, 0x01, // ń’ (U+0144 U+2019)
  0x01, 0x44, 0x20, 0x1C, 0x03, // ń“ (U+0144 U+201C)
  0x01, 0x44, 0x20, 0x1D, 0x01, // ń” (U+0144 U+201D)
  0x01, 0x44, 0x21, 0x22, 0x01, // ń™ (U+0144 U+2122)
  0x01, 0x45, 0x00, 0x26, 0x02, // Ņ& (U+0145 U+0026)
  0x01, 0x45, 0x00, 0x2C, 0x02, // Ņ, (U+0145 U+002C)
  0x01, 0x45, 0x00, 0x2E, 0x02, // Ņ. (U+0145 U+002E)
  0x01, 0x45, 0x20, 0x1A, 0x02, // Ņ‚ (U+0145 U+201A)
  0x01, 0x45, 0x20, 0x1E, 0x02, // Ņ„ (U+0145 U+201E)
  0x01, 0x45, 0x20, 0x26, 0x02, // Ņ… (U+0145 U+2026)
  0x01, 0x46, 0x00, 0x22, 0x04, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x04, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x00, 0x2A, 0x01, // ņ* (U+0146 U+002A)
  0x01, 0x46, 0x00, 0x54, 0x02, // ņT (U+0146 U+0054)
  0x01, 0x46, 0x00, 0x56, 0x05, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x57, 0x04, // ņW (U+0146 U+0057)
  0x01, 0x46, 0x00, 0x59, 0x05, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0x79, 0x01, // ņy (U+0146 U+0079)
  0x01, 0x46, 0x00, 0xDD, 0x05, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x00, 0xFD, 0x01, // ņý (U+0146 U+00FD)
  0x01, 0x46, 0x00, 0xFF, 0x01, // ņÿ (U+0146 U+00FF)
  0x01, 0x46, 0x01, 0x74, 0x04, // ņŴ (U+0146 U+0174)
  0x01, 0x46, 0x01, 0x76, 0x05, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x77, 0x01, // ņŷ (U+0146 U+0177)
  0x01, 0x46, 0x01, 0x78, 0x05, // ņŸ (U+0146 U+0178)
  0x01, 0x46, 0x20, 0x18, 0x03, // ņ‘ (U+0146 U+2018)
  0x01, 0x46, 0x20, 0x19, 0x01, // ņ’ (U+0146 U+2019)
  0x01, 0x46, 0x20, 0x1C, 0x03, // ņ“ (U+0146 U+201C)
  0x01, 0x46, 0x20, 0x1D, 0x01, // ņ” (U+0146 U+201D)
  0x01, 0x46, 0x21, 0x22, 0x01, // ņ™ (U+0146 U+2122)
  0x01, 0x47, 0x00, 0x26, 0x02, // Ň& (U+0147 U+0026)
  0x01, 0x47, 0x00, 0x2C, 0x02, // Ň, (U+0147 U+002C)
  0x01, 0x47, 0x00, 0x2E, 0x02, // Ň. (U+0147 U+002E)
  0x01, 0x47, 0x20, 0x1A, 0x02, // Ň‚ (U+0147 U+201A)
  0x01, 0x47, 0x20, 0x1E, 0x02, // Ň„ (U+0147 U+201E)
  0x01, 0x47, 0x20, 0x26, 0x02, // Ň… (U+0147 U+2026)
  0x01, 0x48, 0x00, 0x22, 0x04, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x04, // ň' (U+0148 U+0027)
  0x01, 0x48, 0x00, 0x2A, 0x01, // ň* (U+0148 U+002A)
  0x01, 0x48, 0x00, 0x54, 0x02, // ňT (U+0148 U+0054)
  0x01, 0x48, 0x00, 0x56, 0x05, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x57, 0x04, // ňW (U+0148 U+0057)
  0x01, 0x48, 0x00, 0x59, 0x05, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0x79, 0x01, // ňy (U+0148 U+0079)
  0x01, 0x48, 0x00, 0xDD, 0x05, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x00, 0xFD, 0x01, // ňý (U+0148 U+00FD)
  0x01, 0x48, 0x00, 0xFF, 0x01, // ňÿ (U+0148 U+00FF)
  0x01, 0x48, 0x01, 0x74, 0x04, // ňŴ (U+0148 U+0174)
  0x01, 0x48, 0x01, 0x76, 0x05, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x77, 0x01, // ňŷ (U+0148 U+0177)
  0x01, 0x48, 0x01, 0x78, 0x05, // ňŸ (U+0148 U+0178)
  0x01, 0x48, 0x20, 0x18, 0x03, // ň‘ (U+0148 U+2018)
  0x01, 0x48, 0x20, 0x19, 0x01, // ň’ (U+0148 U+2019)
  0x01, 0x48, 0x20, 0x1C, 0x03, // ň“ (U+0148 U+201C)
  0x01, 0x48, 0x20, 0x1D, 0x01, // ň” (U+0148 U+201D)
  0x01, 0x48, 0x21, 0x22, 0x01, // ň™ (U+0148 U+2122)
  0x01, 0x49, 0x00, 0x22, 0x04, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x04, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x00, 0x2A, 0x01, // ŉ* (U+0149 U+002A)
  0x01, 0x49, 0x00, 0x54, 0x02, // ŉT (U+0149 U+0054)
  0x01, 0x49, 0x00, 0x56, 0x05, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x57, 0x04, // ŉW (U+0149 U+0057)
  0x01, 0x49, 0x00, 0x59, 0x05, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0x79, 0x01, // ŉy (U+0149 U+0079)
  0x01, 0x49, 0x00, 0xDD, 0x05, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x00, 0xFD, 0x01, // ŉý (U+0149 U+00FD)
  0x01, 0x49, 0x00, 0xFF, 0x01, // ŉÿ (U+0149 U+00FF)
  0x01, 0x49, 0x01, 0x74, 0x04, // ŉŴ (U+0149 U+0174)
  0x01, 0x49, 0x01, 0x76, 0x05, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x77, 0x01, // ŉŷ (U+0149 U+0177)
  0x01, 0x49, 0x01, 0x78, 0x05, // ŉŸ (U+0149 U+0178)
  0x01, 0x49, 0x20, 0x18, 0x03, // ŉ‘ (U+0149 U+2018)
  0x01, 0x49, 0x20, 0x19, 0x01, // ŉ’ (U+0149 U+2019)
  0x01, 0x49, 0x20, 0x1C, 0x03, // ŉ“ (U+0149 U+201C)
  0x01, 0x49, 0x20, 0x1D, 0x01, // ŉ” (U+0149 U+201D)
  0x01, 0x49, 0x21, 0x22, 0x01, // ŉ™ (U+0149 U+2122)
  0x01, 0x4A, 0x00, 0x2C, 0x02, // Ŋ, (U+014A U+002C)
  0x01, 0x4A, 0x00, 0x2E, 0x02, // Ŋ. (U+014A U+002E)
  0x01, 0x4A, 0x00, 0x41, 0x02, // ŊA (U+014A U+0041)
  0x01, 0x4A, 0x00, 0xC0, 0x02, // ŊÀ (U+014A U+00C0)
  0x01, 0x4A, 0x00, 0xC1, 0x02, // ŊÁ (U+014A U+00C1)
  0x01, 0x4A, 0x00, 0xC2, 0x02, // ŊÂ (U+014A U+00C2)
  0x01, 0x4A, 0x00, 0xC3, 0x02, // ŊÃ (U+014A U+00C3)
  0x01, 0x4A, 0x00, 0xC4, 0x02, // ŊÄ (U+014A U+00C4)
  0x01, 0x4A, 0x00, 0xC5, 0x02, // ŊÅ (U+014A U+00C5)
  0x01, 0x4A, 0x01, 0x00, 0x02, // ŊĀ (U+014A U+0100)
  0x01, 0x4A, 0x01, 0x02, 0x02, // ŊĂ (U+014A U+0102)
  0x01, 0x4A, 0x01, 0x04, 0x02, // ŊĄ (U+014A U+0104)
  0x01, 0x4A, 0x20, 0x1A, 0x02, // Ŋ‚ (U+014A U+201A)
  0x01, 0x4A, 0x20, 0x1E, 0x02, // Ŋ„ (U+014A U+201E)
  0x01, 0x4A, 0x20, 0x26, 0x02, // Ŋ… (U+014A U+2026)
  0x01, 0x4B, 0x00, 0x22, 0x04, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x04, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x00, 0x2A, 0x01, // ŋ* (U+014B U+002A)
  0x01, 0x4B, 0x00, 0x54, 0x02, // ŋT (U+014B U+0054)
  0x01, 0x4B, 0x00, 0x56, 0x05, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x57, 0x04, // ŋW (U+014B U+0057)
  0x01, 0x4B, 0x00, 0x59, 0x05, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0x79, 0x01, // ŋy (U+014B U+0079)
  0x01, 0x4B, 0x00, 0xDD, 0x05, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x00, 0xFD, 0x01, // ŋý (U+014B U+00FD)
  0x01, 0x4B, 0x00, 0xFF, 0x01, // ŋÿ (U+014B U+00FF)
  0x01, 0x4B, 0x01, 0x74, 0x04, // ŋŴ (U+014B U+0174)
  0x01, 0x4B, 0x01, 0x76, 0x05, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x77, 0x01, // ŋŷ (U+014B U+0177)
  0x01, 0x4B, 0x01, 0x78, 0x05, // ŋŸ (U+014B U+0178)
  0x01, 0x4B, 0x20, 0x18, 0x03, // ŋ‘ (U+014B U+2018)
  0x01, 0x4B, 0x20, 0x19, 0x01, // ŋ’ (U+014B U+2019)
  0x01, 0x4B, 0x20, 0x1C, 0x03, // ŋ“ (U+014B U+201C)
  0x01, 0x4B, 0x20, 0x1D, 0x01, // ŋ” (U+014B U+201D)
  0x01, 0x4B, 0x21, 0x22, 0x01, // ŋ™ (U+014B U+2122)
  0x01, 0x4C, 0x00, 0x22, 0x03, // Ō" (U+014C U+0022)
  0x01, 0x4C, 0x00, 0x27, 0x03, // Ō' (U+014C U+0027)
  0x01, 0x4C, 0x00, 0x2C, 0x02, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x02, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x41, 0x02, // ŌA (U+014C U+0041)
  0x01, 0x4C, 0x00, 0x54, 0x02, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x00, 0x56, 0x02, // ŌV (U+014C U+0056)
  0x01, 0x4C, 0x00, 0x57, 0x02, // ŌW (U+014C U+0057)
  0x01, 0x4C, 0x00, 0x58, 0x01, // ŌX (U+014C U+0058)
  0x01, 0x4C, 0x00, 0x59, 0x02, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0xC0, 0x02, // ŌÀ (U+014C U+00C0)
  0x01, 0x4C, 0x00, 0xC1, 0x02, // ŌÁ (U+014C U+00C1)
  0x01, 0x4C, 0x00, 0xC2, 0x02, // ŌÂ (U+014C U+00C2)
  0x01, 0x4C, 0x00, 0xC3, 0x02, // ŌÃ (U+014C U+00C3)
  0x01, 0x4C, 0x00, 0xC4, 0x02, // ŌÄ (U+014C U+00C4)
  0x01, 0x4C, 0x00, 0xC5, 0x02, // ŌÅ (U+014C U+00C5)
  0x01, 0x4C, 0x00, 0xC6, 0x04, // ŌÆ (U+014C U+00C6)
  0x01, 0x4C, 0x00, 0xDD, 0x02, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x00, 0x02, // ŌĀ (U+014C U+0100)
  0x01, 0x4C, 0x01, 0x02, 0x02, // ŌĂ (U+014C U+0102)
  0x01, 0x4C, 0x01, 0x04, 0x02, // ŌĄ (U+014C U+0104)
  0x01, 0x4C, 0x01, 0x74, 0x02, // ŌŴ (U+014C U+0174)
  0x01, 0x4C, 0x01, 0x76, 0x02, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x02, // ŌŸ (U+014C U+0178)
  0x01, 0x4C, 0x20, 0x1A, 0x02, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x02, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x02, // Ō… (U+014C U+2026)
  0x01, 0x4D, 0x00, 0x41, 0x01, // ōA (U+014D U+0041)
  0x01, 0x4D, 0x00, 0x54, 0x03, // ōT (U+014D U+0054)
  0x01, 0x4D, 0x00, 0x56, 0x05, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x05, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x06, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0x78, 0x01, // ōx (U+014D U+0078)
  0x01, 0x4D, 0x00, 0x79, 0x01, // ōy (U+014D U+0079)
  0x01, 0x4D, 0x00, 0xC0, 0x01, // ōÀ (U+014D U+00C0)
  0x01, 0x4D, 0x00, 0xC1, 0x01, // ōÁ (U+014D U+00C1)
  0x01, 0x4D, 0x00, 0xC2, 0x01, // ōÂ (U+014D U+00C2)
  0x01, 0x4D, 0x00, 0xC3, 0x01, // ōÃ (U+014D U+00C3)
  0x01, 0x4D, 0x00, 0xC4, 0x01, // ōÄ (U+014D U+00C4)
  0x01, 0x4D, 0x00, 0xC5, 0x01, // ōÅ (U+014D U+00C5)
  0x01, 0x4D, 0x00, 0xDD, 0x06, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x00, 0xFD, 0x01, // ōý (U+014D U+00FD)
  0x01, 0x4D, 0x00, 0xFF, 0x01, // ōÿ (U+014D U+00FF)
  0x01, 0x4D, 0x01, 0x00, 0x01, // ōĀ (U+014D U+0100)
  0x01, 0x4D, 0x01, 0x02, 0x01, // ōĂ (U+014D U+0102)
  0x01, 0x4D, 0x01, 0x04, 0x01, // ōĄ (U+014D U+0104)
  0x01, 0x4D, 0x01, 0x74, 0x05, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x06, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x77, 0x01, // ōŷ (U+014D U+0177)
  0x01, 0x4D, 0x01, 0x78, 0x06, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0x22, 0x03, // Ŏ" (U+014E U+0022)
  0x01, 0x4E, 0x00, 0x27, 0x03, // Ŏ' (U+014E U+0027)
  0x01, 0x4E, 0x00, 0x2C, 0x02, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x02, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x41, 0x02, // ŎA (U+014E U+0041)
  0x01, 0x4E, 0x00, 0x54, 0x02, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x00, 0x56, 0x02, // ŎV (U+014E U+0056)
  0x01, 0x4E, 0x00, 0x57, 0x02, // ŎW (U+014E U+0057)
  0x01, 0x4E, 0x00, 0x58, 0x01, // ŎX (U+014E U+0058)
  0x01, 0x4E, 0x00, 0x59, 0x02, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0xC0, 0x02, // ŎÀ (U+014E U+00C0)
  0x01, 0x4E, 0x00, 0xC1, 0x02, // ŎÁ (U+014E U+00C1)
  0x01, 0x4E, 0x00, 0xC2, 0x02, // ŎÂ (U+014E U+00C2)
  0x01, 0x4E, 0x00, 0xC3, 0x02, // ŎÃ (U+014E U+00C3)
  0x01, 0x4E, 0x00, 0xC4, 0x02, // ŎÄ (U+014E U+00C4)
  0x01, 0x4E, 0x00, 0xC5, 0x02, // ŎÅ (U+014E U+00C5)
  0x01, 0x4E, 0x00, 0xC6, 0x04, // ŎÆ (U+014E U+00C6)
  0x01, 0x4E, 0x00, 0xDD, 0x02, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x00, 0x02, // ŎĀ (U+014E U+0100)
  0x01, 0x4E, 0x01, 0x02, 0x02, // ŎĂ (U+014E U+0102)
  0x01, 0x4E, 0x01, 0x04, 0x02, // ŎĄ (U+014E U+0104)
  0x01, 0x4E, 0x01, 0x74, 0x02, // ŎŴ (U+014E U+0174)
  0x01, 0x4E, 0x01, 0x76, 0x02, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x02, // ŎŸ (U+014E U+0178)
  0x01, 0x4E, 0x20, 0x1A, 0x02, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x02, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x02, // Ŏ… (U+014E U+2026)
  0x01, 0x4F, 0x00, 0x41, 0x01, // ŏA (U+014F U+0041)
  0x01, 0x4F, 0x00, 0x54, 0x03, // ŏT (U+014F U+0054)
  0x01, 0x4F, 0x00, 0x56, 0x05, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x05, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x06, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0x78, 0x01, // ŏx (U+014F U+0078)
  0x01, 0x4F, 0x00, 0x79, 0x01, // ŏy (U+014F U+0079)
  0x01, 0x4F, 0x00, 0xC0, 0x01, // ŏÀ (U+014F U+00C0)
  0x01, 0x4F, 0x00, 0xC1, 0x01, // ŏÁ (U+014F U+00C1)
  0x01, 0x4F, 0x00, 0xC2, 0x01, // ŏÂ (U+014F U+00C2)
  0x01, 0x4F, 0x00, 0xC3, 0x01, // ŏÃ (U+014F U+00C3)
  0x01, 0x4F, 0x00, 0xC4, 0x01, // ŏÄ (U+014F U+00C4)
  0x01, 0x4F, 0x00, 0xC5, 0x01, // ŏÅ (U+014F U+00C5)
  0x01, 0x4F, 0x00, 0xDD, 0x06, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x00, 0xFD, 0x01, // ŏý (U+014F U+00FD)
  0x01, 0x4F, 0x00, 0xFF, 0x01, // ŏÿ (U+014F U+00FF)
  0x01, 0x4F, 0x01, 0x00, 0x01, // ŏĀ (U+014F U+0100)
  0x01, 0x4F, 0x01, 0x02, 0x01, // ŏĂ (U+014F U+0102)
  0x01, 0x4F, 0x01, 0x04, 0x01, // ŏĄ (U+014F U+0104)
  0x01, 0x4F, 0x01, 0x74, 0x05, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x06, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x77, 0x01, // ŏŷ (U+014F U+0177)
  0x01, 0x4F, 0x01, 0x78, 0x06, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0x22, 0x03, // Ő" (U+0150 U+0022)
  0x01, 0x50, 0x00, 0x27, 0x03, // Ő' (U+0150 U+0027)
  0x01, 0x50, 0x00, 0x2C, 0x02, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x02, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x41, 0x02, // ŐA (U+0150 U+0041)
  0x01, 0x50, 0x00, 0x54, 0x02, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x00, 0x56, 0x02, // ŐV (U+0150 U+0056)
  0x01, 0x50, 0x00, 0x57, 0x02, // ŐW (U+0150 U+0057)
  0x01, 0x50, 0x00, 0x58, 0x01, // ŐX (U+0150 U+0058)
  0x01, 0x50, 0x00, 0x59, 0x02, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0xC0, 0x02, // ŐÀ (U+0150 U+00C0)
  0x01, 0x50, 0x00, 0xC1, 0x02, // ŐÁ (U+0150 U+00C1)
  0x01, 0x50, 0x00, 0xC2, 0x02, // ŐÂ (U+0150 U+00C2)
  0x01, 0x50, 0x00, 0xC3, 0x02, // ŐÃ (U+0150 U+00C3)
  0x01, 0x50, 0x00, 0xC4, 0x02, // ŐÄ (U+0150 U+00C4)
  0x01, 0x50, 0x00, 0xC5, 0x02, // ŐÅ (U+0150 U+00C5)
  0x01, 0x50, 0x00, 0xC6, 0x04, // ŐÆ (U+0150 U+00C6)
  0x01, 0x50, 0x00, 0xDD, 0x02, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x00, 0x02, // ŐĀ (U+0150 U+0100)
  0x01, 0x50, 0x01, 0x02, 0x02, // ŐĂ (U+0150 U+0102)
  0x01, 0x50, 0x01, 0x04, 0x02, // ŐĄ (U+0150 U+0104)
  0x01, 0x50, 0x01, 0x74, 0x02, // ŐŴ (U+0150 U+0174)
  0x01, 0x50, 0x01, 0x76, 0x02, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x02, // ŐŸ (U+0150 U+0178)
  0x01, 0x50, 0x20, 0x1A, 0x02, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x02, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x02, // Ő… (U+0150 U+2026)
  0x01, 0x51, 0x00, 0x41, 0x01, // őA (U+0151 U+0041)
  0x01, 0x51, 0x00, 0x54, 0x03, // őT (U+0151 U+0054)
  0x01, 0x51, 0x00, 0x56, 0x05, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x05, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x06, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0x78, 0x01, // őx (U+0151 U+0078)
  0x01, 0x51, 0x00, 0x79, 0x01, // őy (U+0151 U+0079)
  0x01, 0x51, 0x00, 0xC0, 0x01, // őÀ (U+0151 U+00C0)
  0x01, 0x51, 0x00, 0xC1, 0x01, // őÁ (U+0151 U+00C1)
  0x01, 0x51, 0x00, 0xC2, 0x01, // őÂ (U+0151 U+00C2)
  0x01, 0x51, 0x00, 0xC3, 0x01, // őÃ (U+0151 U+00C3)
  0x01, 0x51, 0x00, 0xC4, 0x01, // őÄ (U+0151 U+00C4)
  0x01, 0x51, 0x00, 0xC5, 0x01, // őÅ (U+0151 U+00C5)
  0x01, 0x51, 0x00, 0xDD, 0x06, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x00, 0xFD, 0x01, // őý (U+0151 U+00FD)
  0x01, 0x51, 0x00, 0xFF, 0x01, // őÿ (U+0151 U+00FF)
  0x01, 0x51, 0x01, 0x00, 0x01, // őĀ (U+0151 U+0100)
  0x01, 0x51, 0x01, 0x02, 0x01, // őĂ (U+0151 U+0102)
  0x01, 0x51, 0x01, 0x04, 0x01, // őĄ (U+0151 U+0104)
  0x01, 0x51, 0x01, 0x74, 0x05, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x06, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x77, 0x01, // őŷ (U+0151 U+0177)
  0x01, 0x51, 0x01, 0x78, 0x06, // őŸ (U+0151 U+0178)
  0x01, 0x52, 0x00, 0x56, 0x02, // ŒV (U+0152 U+0056)
  0x01, 0x52, 0x00, 0x57, 0x02, // ŒW (U+0152 U+0057)
  0x01, 0x52, 0x00, 0x59, 0x02, // ŒY (U+0152 U+0059)
  0x01, 0x52, 0x00, 0xDD, 0x02, // ŒÝ (U+0152 U+00DD)
  0x01, 0x52, 0x01, 0x74, 0x02, // ŒŴ (U+0152 U+0174)
  0x01, 0x52, 0x01, 0x76, 0x02, // ŒŶ (U+0152 U+0176)
  0x01, 0x52, 0x01, 0x78, 0x02, // ŒŸ (U+0152 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x05, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x05, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x05, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x05, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x05, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x05, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x05, // œŸ (U+0153 U+0178)
  0x01, 0x54, 0x00, 0x26, 0x02, // Ŕ& (U+0154 U+0026)
  0x01, 0x54, 0x00, 0x2A, 0x02, // Ŕ* (U+0154 U+002A)
  0x01, 0x54, 0x00, 0x43, 0x01, // ŔC (U+0154 U+0043)
  0x01, 0x54, 0x00, 0x47, 0x01, // ŔG (U+0154 U+0047)
  0x01, 0x54, 0x00, 0x4F, 0x01, // ŔO (U+0154 U+004F)
  0x01, 0x54, 0x00, 0x51, 0x01, // ŔQ (U+0154 U+0051)
  0x01, 0x54, 0x00, 0x54, 0x02, // ŔT (U+0154 U+0054)
  0x01, 0x54, 0x00, 0x55, 0x01, // ŔU (U+0154 U+0055)
  0x01, 0x54, 0x00, 0x56, 0x03, // ŔV (U+0154 U+0056)
  0x01, 0x54, 0x00, 0x57, 0x03, // ŔW (U+0154 U+0057)
  0x01, 0x54, 0x00, 0x59, 0x03, // ŔY (U+0154 U+0059)
  0x01, 0x54, 0x00, 0x77, 0x02, // Ŕw (U+0154 U+0077)
  0x01, 0x54, 0x00, 0x79, 0x02, // Ŕy (U+0154 U+0079)
  0x01, 0x54, 0x00, 0xC7, 0x01, // ŔÇ (U+0154 U+00C7)
  0x01, 0x54, 0x00, 0xD2, 0x01, // ŔÒ (U+0154 U+00D2)
  0x01, 0x54, 0x00, 0xD3, 0x01, // ŔÓ (U+0154 U+00D3)
  0x01, 0x54, 0x00, 0xD4, 0x01, // ŔÔ (U+0154 U+00D4)
  0x01, 0x54, 0x00, 0xD5, 0x01, // ŔÕ (U+0154 U+00D5)
  0x01, 0x54, 0x00, 0xD6, 0x01, // ŔÖ (U+0154 U+00D6)
  0x01, 0x54, 0x00, 0xD8, 0x01, // ŔØ (U+0154 U+00D8)
  0x01, 0x54, 0x00, 0xD9, 0x01, // ŔÙ (U+0154 U+00D9)
  0x01, 0x54, 0x00, 0xDA, 0x01, // ŔÚ (U+0154 U+00DA)
  0x01, 0x54, 0x00, 0xDB, 0x01, // ŔÛ (U+0154 U+00DB)
  0x01, 0x54, 0x00, 0xDC, 0x01, // ŔÜ (U+0154 U+00DC)
  0x01, 0x54, 0x00, 0xDD, 0x03, // ŔÝ (U+0154 U+00DD)
  0x01, 0x54, 0x00, 0xFD, 0x02, // Ŕý (U+0154 U+00FD)
  0x01, 0x54, 0x00, 0xFF, 0x02, // Ŕÿ (U+0154 U+00FF)
  0x01, 0x54, 0x01, 0x06, 0x01, // ŔĆ (U+0154 U+0106)
  0x01, 0x54, 0x01, 0x08, 0x01, // ŔĈ (U+0154 U+0108)
  0x01, 0x54, 0x01, 0x0A, 0x01, // ŔĊ (U+0154 U+010A)
  0x01, 0x54, 0x01, 0x0C, 0x01, // ŔČ (U+0154 U+010C)
  0x01, 0x54, 0x01, 0x1C, 0x01, // ŔĜ (U+0154 U+011C)
  0x01, 0x54, 0x01, 0x1E, 0x01, // ŔĞ (U+0154 U+011E)
  0x01, 0x54, 0x01, 0x20, 0x01, // ŔĠ (U+0154 U+0120)
  0x01, 0x54, 0x01, 0x22, 0x01, // ŔĢ (U+0154 U+0122)
  0x01, 0x54, 0x01, 0x4C, 0x01, // ŔŌ (U+0154 U+014C)
  0x01, 0x54, 0x01, 0x4E, 0x01, // ŔŎ (U+0154 U+014E)
  0x01, 0x54, 0x01, 0x50, 0x01, // ŔŐ (U+0154 U+0150)
  0x01, 0x54, 0x01, 0x52, 0x01, // ŔŒ (U+0154 U+0152)
  0x01, 0x54, 0x01, 0x68, 0x01, // ŔŨ (U+0154 U+0168)
  0x01, 0x54, 0x01, 0x6A, 0x01, // ŔŪ (U+0154 U+016A)
  0x01, 0x54, 0x01, 0x6C, 0x01, // ŔŬ (U+0154 U+016C)
  0x01, 0x54, 0x01, 0x6E, 0x01, // ŔŮ (U+0154 U+016E)
  0x01, 0x54, 0x01, 0x70, 0x01, // ŔŰ (U+0154 U+0170)
  0x01, 0x54, 0x01, 0x72, 0x01, // ŔŲ (U+0154 U+0172)
  0x01, 0x54, 0x01, 0x74, 0x03, // ŔŴ (U+0154 U+0174)
  0x01, 0x54, 0x01, 0x75, 0x02, // Ŕŵ (U+0154 U+0175)
  0x01, 0x54, 0x01, 0x76, 0x03, // ŔŶ (U+0154 U+0176)
  0x01, 0x54, 0x01, 0x77, 0x02, // Ŕŷ (U+0154 U+0177)
  0x01, 0x54, 0x01, 0x78, 0x03, // ŔŸ (U+0154 U+0178)
  0x01, 0x54, 0x20, 0x19, 0x02, // Ŕ’ (U+0154 U+2019)
  0x01, 0x54, 0x20, 0x1D, 0x02, // Ŕ” (U+0154 U+201D)
  0x01, 0x54, 0x21, 0x22, 0x02, // Ŕ™ (U+0154 U+2122)
  0x01, 0x55, 0x00, 0x2C, 0x0D, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x0D, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x56, 0x03, // ŕV (U+0155 U+0056)
  0x01, 0x55, 0x00, 0x57, 0x04, // ŕW (U+0155 U+0057)
  0x01, 0x55, 0x00, 0x58, 0x05, // ŕX (U+0155 U+0058)
  0x01, 0x55, 0x00, 0x59, 0x03, // ŕY (U+0155 U+0059)
  0x01, 0x55, 0x00, 0x61, 0x02, // ŕa (U+0155 U+0061)
  0x01, 0x55, 0x00, 0x63, 0x02, // ŕc (U+0155 U+0063)
  0x01, 0x55, 0x00, 0x64, 0x02, // ŕd (U+0155 U+0064)
  0x01, 0x55, 0x00, 0x65, 0x02, // ŕe (U+0155 U+0065)
  0x01, 0x55, 0x00, 0x67, 0x02, // ŕg (U+0155 U+0067)
  0x01, 0x55, 0x00, 0x6F, 0x02, // ŕo (U+0155 U+006F)
  0x01, 0x55, 0x00, 0x71, 0x02, // ŕq (U+0155 U+0071)
  0x01, 0x55, 0x00, 0x78, 0x01, // ŕx (U+0155 U+0078)
  0x01, 0x55, 0x00, 0xDD, 0x03, // ŕÝ (U+0155 U+00DD)
  0x01, 0x55, 0x00, 0xE0, 0x02, // ŕà (U+0155 U+00E0)
  0x01, 0x55, 0x00, 0xE1, 0x02, // ŕá (U+0155 U+00E1)
  0x01, 0x55, 0x00, 0xE2, 0x02, // ŕâ (U+0155 U+00E2)
  0x01, 0x55, 0x00, 0xE3, 0x02, // ŕã (U+0155 U+00E3)
  0x01, 0x55, 0x00, 0xE4, 0x02, // ŕä (U+0155 U+00E4)
  0x01, 0x55, 0x00, 0xE5, 0x02, // ŕå (U+0155 U+00E5)
  0x01, 0x55, 0x00, 0xE6, 0x02, // ŕæ (U+0155 U+00E6)
  0x01, 0x55, 0x00, 0xE7, 0x02, // ŕç (U+0155 U+00E7)
  0x01, 0x55, 0x00, 0xE8, 0x02, // ŕè (U+0155 U+00E8)
  0x01, 0x55, 0x00, 0xE9, 0x02, // ŕé (U+0155 U+00E9)
  0x01, 0x55, 0x00, 0xEA, 0x02, // ŕê (U+0155 U+00EA)
  0x01, 0x55, 0x00, 0xEB, 0x02, // ŕë (U+0155 U+00EB)
  0x01, 0x55, 0x00, 0xF0, 0x02, // ŕð (U+0155 U+00F0)
  0x01, 0x55, 0x00, 0xF2, 0x02, // ŕò (U+0155 U+00F2)
  0x01, 0x55, 0x00, 0xF3, 0x02, // ŕó (U+0155 U+00F3)
  0x01, 0x55, 0x00, 0xF4, 0x02, // ŕô (U+0155 U+00F4)
  0x01, 0x55, 0x00, 0xF5, 0x02, // ŕõ (U+0155 U+00F5)
  0x01, 0x55, 0x00, 0xF6, 0x02, // ŕö (U+0155 U+00F6)
  0x01, 0x55, 0x00, 0xF8, 0x02, // ŕø (U+0155 U+00F8)
  0x01, 0x55, 0x01, 0x01, 0x02, // ŕā (U+0155 U+0101)
  0x01, 0x55, 0x01, 0x03, 0x02, // ŕă (U+0155 U+0103)
  0x01, 0x55, 0x01, 0x05, 0x02, // ŕą (U+0155 U+0105)
  0x01, 0x55, 0x01, 0x07, 0x02, // ŕć (U+0155 U+0107)
  0x01, 0x55, 0x01, 0x09, 0x02, // ŕĉ (U+0155 U+0109)
  0x01, 0x55, 0x01, 0x0B, 0x02, // ŕċ (U+0155 U+010B)
  0x01, 0x55, 0x01, 0x0D, 0x02, // ŕč (U+0155 U+010D)
  0x01, 0x55, 0x01, 0x0F, 0x02, // ŕď (U+0155 U+010F)
  0x01, 0x55, 0x01, 0x11, 0x02, // ŕđ (U+0155 U+0111)
  0x01, 0x55, 0x01, 0x13, 0x02, // ŕē (U+0155 U+0113)
  0x01, 0x55, 0x01, 0x15, 0x02, // ŕĕ (U+0155 U+0115)
  0x01, 0x55, 0x01, 0x17, 0x02, // ŕė (U+0155 U+0117)
  0x01, 0x55, 0x01, 0x19, 0x02, // ŕę (U+0155 U+0119)
  0x01, 0x55, 0x01, 0x1B, 0x02, // ŕě (U+0155 U+011B)
  0x01, 0x55, 0x01, 0x1D, 0x02, // ŕĝ (U+0155 U+011D)
  0x01, 0x55, 0x01, 0x1F, 0x02, // ŕğ (U+0155 U+011F)
  0x01, 0x55, 0x01, 0x21, 0x02, // ŕġ (U+0155 U+0121)
  0x01, 0x55, 0x01, 0x23, 0x02, // ŕģ (U+0155 U+0123)
  0x01, 0x55, 0x01, 0x4D, 0x02, // ŕō (U+0155 U+014D)
  0x01, 0x55, 0x01, 0x4F, 0x02, // ŕŏ (U+0155 U+014F)
  0x01, 0x55, 0x01, 0x51, 0x02, // ŕő (U+0155 U+0151)
  0x01, 0x55, 0x01, 0x53, 0x02, // ŕœ (U+0155 U+0153)
  0x01, 0x55, 0x01, 0x74, 0x04, // ŕŴ (U+0155 U+0174)
  0x01, 0x55, 0x01, 0x76, 0x03, // ŕŶ (U+0155 U+0176)
  0x01, 0x55, 0x01, 0x78, 0x03, // ŕŸ (U+0155 U+0178)
  0x01, 0x55, 0x20, 0x1A, 0x0D, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x0D, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x0D, // ŕ… (U+0155 U+2026)
  0x01, 0x56, 0x00, 0x26, 0x02, // Ŗ& (U+0156 U+0026)
  0x01, 0x56, 0x00, 0x2A, 0x02, // Ŗ* (U+0156 U+002A)
  0x01, 0x56, 0x00, 0x43, 0x01, // ŖC (U+0156 U+0043)
  0x01, 0x56, 0x00, 0x47, 0x01, // ŖG (U+0156 U+0047)
  0x01, 0x56, 0x00, 0x4F, 0x01, // ŖO (U+0156 U+004F)
  0x01, 0x56, 0x00, 0x51, 0x01, // ŖQ (U+0156 U+0051)
  0x01, 0x56, 0x00, 0x54, 0x02, // ŖT (U+0156 U+0054)
  0x01, 0x56, 0x00, 0x55, 0x01, // ŖU (U+0156 U+0055)
  0x01, 0x56, 0x00, 0x56, 0x03, // ŖV (U+0156 U+0056)
  0x01, 0x56, 0x00, 0x57, 0x03, // ŖW (U+0156 U+0057)
  0x01, 0x56, 0x00, 0x59, 0x03, // ŖY (U+0156 U+0059)
  0x01, 0x56, 0x00, 0x77, 0x02, // Ŗw (U+0156 U+0077)
  0x01, 0x56, 0x00, 0x79, 0x02, // Ŗy (U+0156 U+0079)
  0x01, 0x56, 0x00, 0xC7, 0x01, // ŖÇ (U+0156 U+00C7)
  0x01, 0x56, 0x00, 0xD2, 0x01, // ŖÒ (U+0156 U+00D2)
  0x01, 0x56, 0x00, 0xD3, 0x01, // ŖÓ (U+0156 U+00D3)
  0x01, 0x56, 0x00, 0xD4, 0x01, // ŖÔ (U+0156 U+00D4)
  0x01, 0x56, 0x00, 0xD5, 0x01, // ŖÕ (U+0156 U+00D5)
  0x01, 0x56, 0x00, 0xD6, 0x01, // ŖÖ (U+0156 U+00D6)
  0x01, 0x56, 0x00, 0xD8, 0x01, // ŖØ (U+0156 U+00D8)
  0x01, 0x56, 0x00, 0xD9, 0x01, // ŖÙ (U+0156 U+00D9)
  0x01, 0x56, 0x00, 0xDA, 0x01, // ŖÚ (U+0156 U+00DA)
  0x01, 0x56, 0x00, 0xDB, 0x01, // ŖÛ (U+0156 U+00DB)
  0x01, 0x56, 0x00, 0xDC, 0x01, // ŖÜ (U+0156 U+00DC)
  0x01, 0x56, 0x00, 0xDD, 0x03, // ŖÝ (U+0156 U+00DD)
  0x01, 0x56, 0x00, 0xFD, 0x02, // Ŗý (U+0156 U+00FD)
  0x01, 0x56, 0x00, 0xFF, 0x02, // Ŗÿ (U+0156 U+00FF)
  0x01, 0x56, 0x01, 0x06, 0x01, // ŖĆ (U+0156 U+0106)
  0x01, 0x56, 0x01, 0x08, 0x01, // ŖĈ (U+0156 U+0108)
  0x01, 0x56, 0x01, 0x0A, 0x01, // ŖĊ (U+0156 U+010A)
  0x01, 0x56, 0x01, 0x0C, 0x01, // ŖČ (U+0156 U+010C)
  0x01, 0x56, 0x01, 0x1C, 0x01, // ŖĜ (U+0156 U+011C)
  0x01, 0x56, 0x01, 0x1E, 0x01, // ŖĞ (U+0156 U+011E)
  0x01, 0x56, 0x01, 0x20, 0x01, // ŖĠ (U+0156 U+0120)
  0x01, 0x56, 0x01, 0x22, 0x01, // ŖĢ (U+0156 U+0122)
  0x01, 0x56, 0x01, 0x4C, 0x01, // ŖŌ (U+0156 U+014C)
  0x01, 0x56, 0x01, 0x4E, 0x01, // ŖŎ (U+0156 U+014E)
  0x01, 0x56, 0x01, 0x50, 0x01, // ŖŐ (U+0156 U+0150)
  0x01, 0x56, 0x01, 0x52, 0x01, // ŖŒ (U+0156 U+0152)
  0x01, 0x56, 0x01, 0x68, 0x01, // ŖŨ (U+0156 U+0168)
  0x01, 0x56, 0x01, 0x6A, 0x01, // ŖŪ (U+0156 U+016A)
  0x01, 0x56, 0x01, 0x6C, 0x01, // ŖŬ (U+0156 U+016C)
  0x01, 0x56, 0x01, 0x6E, 0x01, // ŖŮ (U+0156 U+016E)
  0x01, 0x56, 0x01, 0x70, 0x01, // ŖŰ (U+0156 U+0170)
  0x01, 0x56, 0x01, 0x72, 0x01, // ŖŲ (U+0156 U+0172)
  0x01, 0x56, 0x01, 0x74, 0x03, // ŖŴ (U+0156 U+0174)
  0x01, 0x56, 0x01, 0x75, 0x02, // Ŗŵ (U+0156 U+0175)
  0x01, 0x56, 0x01, 0x76, 0x03, // ŖŶ (U+0156 U+0176)
  0x01, 0x56, 0x01, 0x77, 0x02, // Ŗŷ (U+0156 U+0177)
  0x01, 0x56, 0x01, 0x78, 0x03, // ŖŸ (U+0156 U+0178)
  0x01, 0x56, 0x20, 0x19, 0x02, // Ŗ’ (U+0156 U+2019)
  0x01, 0x56, 0x20, 0x1D, 0x02, // Ŗ” (U+0156 U+201D)
  0x01, 0x56, 0x21, 0x22, 0x02, // Ŗ™ (U+0156 U+2122)
  0x01, 0x57, 0x00, 0x2C, 0x0D, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x0D, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x56, 0x03, // ŗV (U+0157 U+0056)
  0x01, 0x57, 0x00, 0x57, 0x04, // ŗW (U+0157 U+0057)
  0x01, 0x57, 0x00, 0x58, 0x05, // ŗX (U+0157 U+0058)
  0x01, 0x57, 0x00, 0x59, 0x03, // ŗY (U+0157 U+0059)
  0x01, 0x57, 0x00, 0x61, 0x02, // ŗa (U+0157 U+0061)
  0x01, 0x57, 0x00, 0x63, 0x02, // ŗc (U+0157 U+0063)
  0x01, 0x57, 0x00, 0x64, 0x02, // ŗd (U+0157 U+0064)
  0x01, 0x57, 0x00, 0x65, 0x02, // ŗe (U+0157 U+0065)
  0x01, 0x57, 0x00, 0x67, 0x02, // ŗg (U+0157 U+0067)
  0x01, 0x57, 0x00, 0x6F, 0x02, // ŗo (U+0157 U+006F)
  0x01, 0x57, 0x00, 0x71, 0x02, // ŗq (U+0157 U+0071)
  0x01, 0x57, 0x00, 0x78, 0x01, // ŗx (U+0157 U+0078)
  0x01, 0x57, 0x00, 0xDD, 0x03, // ŗÝ (U+0157 U+00DD)
  0x01, 0x57, 0x00, 0xE0, 0x02, // ŗà (U+0157 U+00E0)
  0x01, 0x57, 0x00, 0xE1, 0x02, // ŗá (U+0157 U+00E1)
  0x01, 0x57, 0x00, 0xE2, 0x02, // ŗâ (U+0157 U+00E2)
  0x01, 0x57, 0x00, 0xE3, 0x02, // ŗã (U+0157 U+00E3)
  0x01, 0x57, 0x00, 0xE4, 0x02, // ŗä (U+0157 U+00E4)
  0x01, 0x57, 0x00, 0xE5, 0x02, // ŗå (U+0157 U+00E5)
  0x01, 0x57, 0x00, 0xE6, 0x02, // ŗæ (U+0157 U+00E6)
  0x01, 0x57, 0x00, 0xE7, 0x02, // ŗç (U+0157 U+00E7)
  0x01, 0x57, 0x00, 0xE8, 0x02, // ŗè (U+0157 U+00E8)
  0x01, 0x57, 0x00, 0xE9, 0x02, // ŗé (U+0157 U+00E9)
  0x01, 0x57, 0x00, 0xEA, 0x02, // ŗê (U+0157 U+00EA)
  0x01, 0x57, 0x00, 0xEB, 0x02, // ŗë (U+0157 U+00EB)
  0x01, 0x57, 0x00, 0xF0, 0x02, // ŗð (U+0157 U+00F0)
  0x01, 0x57, 0x00, 0xF2, 0x02, // ŗò (U+0157 U+00F2)
  0x01, 0x57, 0x00, 0xF3, 0x02, // ŗó (U+0157 U+00F3)
  0x01, 0x57, 0x00, 0xF4, 0x02, // ŗô (U+0157 U+00F4)
  0x01, 0x57, 0x00, 0xF5, 0x02, // ŗõ (U+0157 U+00F5)
  0x01, 0x57, 0x00, 0xF6, 0x02, // ŗö (U+0157 U+00F6)
  0x01, 0x57, 0x00, 0xF8, 0x02, // ŗø (U+0157 U+00F8)
  0x01, 0x57, 0x01, 0x01, 0x02, // ŗā (U+0157 U+0101)
  0x01, 0x57, 0x01, 0x03, 0x02, // ŗă (U+0157 U+0103)
  0x01, 0x57, 0x01, 0x05, 0x02, // ŗą (U+0157 U+0105)
  0x01, 0x57, 0x01, 0x07, 0x02, // ŗć (U+0157 U+0107)
  0x01, 0x57, 0x01, 0x09, 0x02, // ŗĉ (U+0157 U+0109)
  0x01, 0x57, 0x01, 0x0B, 0x02, // ŗċ (U+0157 U+010B)
  0x01, 0x57, 0x01, 0x0D, 0x02, // ŗč (U+0157 U+010D)
  0x01, 0x57, 0x01, 0x0F, 0x02, // ŗď (U+0157 U+010F)
  0x01, 0x57, 0x01, 0x11, 0x02, // ŗđ (U+0157 U+0111)
  0x01, 0x57, 0x01, 0x13, 0x02, // ŗē (U+0157 U+0113)
  0x01, 0x57, 0x01, 0x15, 0x02, // ŗĕ (U+0157 U+0115)
  0x01, 0x57, 0x01, 0x17, 0x02, // ŗė (U+0157 U+0117)
  0x01, 0x57, 0x01, 0x19, 0x02, // ŗę (U+0157 U+0119)
  0x01, 0x57, 0x01, 0x1B, 0x02, // ŗě (U+0157 U+011B)
  0x01, 0x57, 0x01, 0x1D, 0x02, // ŗĝ (U+0157 U+011D)
  0x01, 0x57, 0x01, 0x1F, 0x02, // ŗğ (U+0157 U+011F)
  0x01, 0x57, 0x01, 0x21, 0x02, // ŗġ (U+0157 U+0121)
  0x01, 0x57, 0x01, 0x23, 0x02, // ŗģ (U+0157 U+0123)
  0x01, 0x57, 0x01, 0x4D, 0x02, // ŗō (U+0157 U+014D)
  0x01, 0x57, 0x01, 0x4F, 0x02, // ŗŏ (U+0157 U+014F)
  0x01, 0x57, 0x01, 0x51, 0x02, // ŗő (U+0157 U+0151)
  0x01, 0x57, 0x01, 0x53, 0x02, // ŗœ (U+0157 U+0153)
  0x01, 0x57, 0x01, 0x74, 0x04, // ŗŴ (U+0157 U+0174)
  0x01, 0x57, 0x01, 0x76, 0x03, // ŗŶ (U+0157 U+0176)
  0x01, 0x57, 0x01, 0x78, 0x03, // ŗŸ (U+0157 U+0178)
  0x01, 0x57, 0x20, 0x1A, 0x0D, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x0D, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x0D, // ŗ… (U+0157 U+2026)
  0x01, 0x58, 0x00, 0x26, 0x02, // Ř& (U+0158 U+0026)
  0x01, 0x58, 0x00, 0x2A, 0x02, // Ř* (U+0158 U+002A)
  0x01, 0x58, 0x00, 0x43, 0x01, // ŘC (U+0158 U+0043)
  0x01, 0x58, 0x00, 0x47, 0x01, // ŘG (U+0158 U+0047)
  0x01, 0x58, 0x00, 0x4F, 0x01, // ŘO (U+0158 U+004F)
  0x01, 0x58, 0x00, 0x51, 0x01, // ŘQ (U+0158 U+0051)
  0x01, 0x58, 0x00, 0x54, 0x02, // ŘT (U+0158 U+0054)
  0x01, 0x58, 0x00, 0x55, 0x01, // ŘU (U+0158 U+0055)
  0x01, 0x58, 0x00, 0x56, 0x03, // ŘV (U+0158 U+0056)
  0x01, 0x58, 0x00, 0x57, 0x03, // ŘW (U+0158 U+0057)
  0x01, 0x58, 0x00, 0x59, 0x03, // ŘY (U+0158 U+0059)
  0x01, 0x58, 0x00, 0x77, 0x02, // Řw (U+0158 U+0077)
  0x01, 0x58, 0x00, 0x79, 0x02, // Řy (U+0158 U+0079)
  0x01, 0x58, 0x00, 0xC7, 0x01, // ŘÇ (U+0158 U+00C7)
  0x01, 0x58, 0x00, 0xD2, 0x01, // ŘÒ (U+0158 U+00D2)
  0x01, 0x58, 0x00, 0xD3, 0x01, // ŘÓ (U+0158 U+00D3)
  0x01, 0x58, 0x00, 0xD4, 0x01, // ŘÔ (U+0158 U+00D4)
  0x01, 0x58, 0x00, 0xD5, 0x01, // ŘÕ (U+0158 U+00D5)
  0x01, 0x58, 0x00, 0xD6, 0x01, // ŘÖ (U+0158 U+00D6)
  0x01, 0x58, 0x00, 0xD8, 0x01, // ŘØ (U+0158 U+00D8)
  0x01, 0x58, 0x00, 0xD9, 0x01, // ŘÙ (U+0158 U+00D9)
  0x01, 0x58, 0x00, 0xDA, 0x01, // ŘÚ (U+0158 U+00DA)
  0x01, 0x58, 0x00, 0xDB, 0x01, // ŘÛ (U+0158 U+00DB)
  0x01, 0x58, 0x00, 0xDC, 0x01, // ŘÜ (U+0158 U+00DC)
  0x01, 0x58, 0x00, 0xDD, 0x03, // ŘÝ (U+0158 U+00DD)
  0x01, 0x58, 0x00, 0xFD, 0x02, // Řý (U+0158 U+00FD)
  0x01, 0x58, 0x00, 0xFF, 0x02, // Řÿ (U+0158 U+00FF)
  0x01, 0x58, 0x01, 0x06, 0x01, // ŘĆ (U+0158 U+0106)
  0x01, 0x58, 0x01, 0x08, 0x01, // ŘĈ (U+0158 U+0108)
  0x01, 0x58, 0x01, 0x0A, 0x01, // ŘĊ (U+0158 U+010A)
  0x01, 0x58, 0x01, 0x0C, 0x01, // ŘČ (U+0158 U+010C)
  0x01, 0x58, 0x01, 0x1C, 0x01, // ŘĜ (U+0158 U+011C)
  0x01, 0x58, 0x01, 0x1E, 0x01, // ŘĞ (U+0158 U+011E)
  0x01, 0x58, 0x01, 0x20, 0x01, // ŘĠ (U+0158 U+0120)
  0x01, 0x58, 0x01, 0x22, 0x01, // ŘĢ (U+0158 U+0122)
  0x01, 0x58, 0x01, 0x4C, 0x01, // ŘŌ (U+0158 U+014C)
  0x01, 0x58, 0x01, 0x4E, 0x01, // ŘŎ (U+0158 U+014E)
  0x01, 0x58, 0x01, 0x50, 0x01, // ŘŐ (U+0158 U+0150)
  0x01, 0x58, 0x01, 0x52, 0x01, // ŘŒ (U+0158 U+0152)
  0x01, 0x58, 0x01, 0x68, 0x01, // ŘŨ (U+0158 U+0168)
  0x01, 0x58, 0x01, 0x6A, 0x01, // ŘŪ (U+0158 U+016A)
  0x01, 0x58, 0x01, 0x6C, 0x01, // ŘŬ (U+0158 U+016C)
  0x01, 0x58, 0x01, 0x6E, 0x01, // ŘŮ (U+0158 U+016E)
  0x01, 0x58, 0x01, 0x70, 0x01, // ŘŰ (U+0158 U+0170)
  0x01, 0x58, 0x01, 0x72, 0x01, // ŘŲ (U+0158 U+0172)
  0x01, 0x58, 0x01, 0x74, 0x03, // ŘŴ (U+0158 U+0174)
  0x01, 0x58, 0x01, 0x75, 0x02, // Řŵ (U+0158 U+0175)
  0x01, 0x58, 0x01, 0x76, 0x03, // ŘŶ (U+0158 U+0176)
  0x01, 0x58, 0x01, 0x77, 0x02, // Řŷ (U+0158 U+0177)
  0x01, 0x58, 0x01, 0x78, 0x03, // ŘŸ (U+0158 U+0178)
  0x01, 0x58, 0x20, 0x19, 0x02, // Ř’ (U+0158 U+2019)
  0x01, 0x58, 0x20, 0x1D, 0x02, // Ř” (U+0158 U+201D)
  0x01, 0x58, 0x21, 0x22, 0x02, // Ř™ (U+0158 U+2122)
  0x01, 0x59, 0x00, 0x2C, 0x0D, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x0D, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x56, 0x03, // řV (U+0159 U+0056)
  0x01, 0x59, 0x00, 0x57, 0x04, // řW (U+0159 U+0057)
  0x01, 0x59, 0x00, 0x58, 0x05, // řX (U+0159 U+0058)
  0x01, 0x59, 0x00, 0x59, 0x03, // řY (U+0159 U+0059)
  0x01, 0x59, 0x00, 0x61, 0x02, // řa (U+0159 U+0061)
  0x01, 0x59, 0x00, 0x63, 0x02, // řc (U+0159 U+0063)
  0x01, 0x59, 0x00, 0x64, 0x02, // řd (U+0159 U+0064)
  0x01, 0x59, 0x00, 0x65, 0x02, // ře (U+0159 U+0065)
  0x01, 0x59, 0x00, 0x67, 0x02, // řg (U+0159 U+0067)
  0x01, 0x59, 0x00, 0x6F, 0x02, // řo (U+0159 U+006F)
  0x01, 0x59, 0x00, 0x71, 0x02, // řq (U+0159 U+0071)
  0x01, 0x59, 0x00, 0x78, 0x01, // řx (U+0159 U+0078)
  0x01, 0x59, 0x00, 0xDD, 0x03, // řÝ (U+0159 U+00DD)
  0x01, 0x59, 0x00, 0xE0, 0x02, // řà (U+0159 U+00E0)
  0x01, 0x59, 0x00, 0xE1, 0x02, // řá (U+0159 U+00E1)
  0x01, 0x59, 0x00, 0xE2, 0x02, // řâ (U+0159 U+00E2)
  0x01, 0x59, 0x00, 0xE3, 0x02, // řã (U+0159 U+00E3)
  0x01, 0x59, 0x00, 0xE4, 0x02, // řä (U+0159 U+00E4)
  0x01, 0x59, 0x00, 0xE5, 0x02, // řå (U+0159 U+00E5)
  0x01, 0x59, 0x00, 0xE6, 0x02, // řæ (U+0159 U+00E6)
  0x01, 0x59, 0x00, 0xE7, 0x02, // řç (U+0159 U+00E7)
  0x01, 0x59, 0x00, 0xE8, 0x02, // řè (U+0159 U+00E8)
  0x01, 0x59, 0x00, 0xE9, 0x02, // řé (U+0159 U+00E9)
  0x01, 0x59, 0x00, 0xEA, 0x02, // řê (U+0159 U+00EA)
  0x01, 0x59, 0x00, 0xEB, 0x02, // řë (U+0159 U+00EB)
  0x01, 0x59, 0x00, 0xF0, 0x02, // řð (U+0159 U+00F0)
  0x01, 0x59, 0x00, 0xF2, 0x02, // řò (U+0159 U+00F2)
  0x01, 0x59, 0x00, 0xF3, 0x02, // řó (U+0159 U+00F3)
  0x01, 0x59, 0x00, 0xF4, 0x02, // řô (U+0159 U+00F4)
  0x01, 0x59, 0x00, 0xF5, 0x02, // řõ (U+0159 U+00F5)
  0x01, 0x59, 0x00, 0xF6, 0x02, // řö (U+0159 U+00F6)
  0x01, 0x59, 0x00, 0xF8, 0x02, // řø (U+0159 U+00F8)
  0x01, 0x59, 0x01, 0x01, 0x02, // řā (U+0159 U+0101)
  0x01, 0x59, 0x01, 0x03, 0x02, // řă (U+0159 U+0103)
  0x01, 0x59, 0x01, 0x05, 0x02, // řą (U+0159 U+0105)
  0x01, 0x59, 0x01, 0x07, 0x02, // řć (U+0159 U+0107)
  0x01, 0x59, 0x01, 0x09, 0x02, // řĉ (U+0159 U+0109)
  0x01, 0x59, 0x01, 0x0B, 0x02, // řċ (U+0159 U+010B)
  0x01, 0x59, 0x01, 0x0D, 0x02, // řč (U+0159 U+010D)
  0x01, 0x59, 0x01, 0x0F, 0x02, // řď (U+0159 U+010F)
  0x01, 0x59, 0x01, 0x11, 0x02, // řđ (U+0159 U+0111)
  0x01, 0x59, 0x01, 0x13, 0x02, // řē (U+0159 U+0113)
  0x01, 0x59, 0x01, 0x15, 0x02, // řĕ (U+0159 U+0115)
  0x01, 0x59, 0x01, 0x17, 0x02, // řė (U+0159 U+0117)
  0x01, 0x59, 0x01, 0x19, 0x02, // řę (U+0159 U+0119)
  0x01, 0x59, 0x01, 0x1B, 0x02, // řě (U+0159 U+011B)
  0x01, 0x59, 0x01, 0x1D, 0x02, // řĝ (U+0159 U+011D)
  0x01, 0x59, 0x01, 0x1F, 0x02, // řğ (U+0159 U+011F)
  0x01, 0x59, 0x01, 0x21, 0x02, // řġ (U+0159 U+0121)
  0x01, 0x59, 0x01, 0x23, 0x02, // řģ (U+0159 U+0123)
  0x01, 0x59, 0x01, 0x4D, 0x02, // řō (U+0159 U+014D)
  0x01, 0x59, 0x01, 0x4F, 0x02, // řŏ (U+0159 U+014F)
  0x01, 0x59, 0x01, 0x51, 0x02, // řő (U+0159 U+0151)
  0x01, 0x59, 0x01, 0x53, 0x02, // řœ (U+0159 U+0153)
  0x01, 0x59, 0x01, 0x74, 0x04, // řŴ (U+0159 U+0174)
  0x01, 0x59, 0x01, 0x76, 0x03, // řŶ (U+0159 U+0176)
  0x01, 0x59, 0x01, 0x78, 0x03, // řŸ (U+0159 U+0178)
  0x01, 0x59, 0x20, 0x1A, 0x0D, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x0D, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x0D, // ř… (U+0159 U+2026)
  0x01, 0x5A, 0x00, 0x41, 0x01, // ŚA (U+015A U+0041)
  0x01, 0x5A, 0x00, 0x54, 0x02, // ŚT (U+015A U+0054)
  0x01, 0x5A, 0x00, 0x56, 0x02, // ŚV (U+015A U+0056)
  0x01, 0x5A, 0x00, 0x57, 0x02, // ŚW (U+015A U+0057)
  0x01, 0x5A, 0x00, 0x58, 0x02, // ŚX (U+015A U+0058)
  0x01, 0x5A, 0x00, 0x59, 0x02, // ŚY (U+015A U+0059)
  0x01, 0x5A, 0x00, 0x77, 0x01, // Św (U+015A U+0077)
  0x01, 0x5A, 0x00, 0x79, 0x02, // Śy (U+015A U+0079)
  0x01, 0x5A, 0x00, 0xC0, 0x01, // ŚÀ (U+015A U+00C0)
  0x01, 0x5A, 0x00, 0xC1, 0x01, // ŚÁ (U+015A U+00C1)
  0x01, 0x5A, 0x00, 0xC2, 0x01, // ŚÂ (U+015A U+00C2)
  0x01, 0x5A, 0x00, 0xC3, 0x01, // ŚÃ (U+015A U+00C3)
  0x01, 0x5A, 0x00, 0xC4, 0x01, // ŚÄ (U+015A U+00C4)
  0x01, 0x5A, 0x00, 0xC5, 0x01, // ŚÅ (U+015A U+00C5)
  0x01, 0x5A, 0x00, 0xC6, 0x02, // ŚÆ (U+015A U+00C6)
  0x01, 0x5A, 0x00, 0xDD, 0x02, // ŚÝ (U+015A U+00DD)
  0x01, 0x5A, 0x00, 0xFD, 0x02, // Śý (U+015A U+00FD)
  0x01, 0x5A, 0x00, 0xFF, 0x02, // Śÿ (U+015A U+00FF)
  0x01, 0x5A, 0x01, 0x00, 0x01, // ŚĀ (U+015A U+0100)
  0x01, 0x5A, 0x01, 0x02, 0x01, // ŚĂ (U+015A U+0102)
  0x01, 0x5A, 0x01, 0x04, 0x01, // ŚĄ (U+015A U+0104)
  0x01, 0x5A, 0x01, 0x74, 0x02, // ŚŴ (U+015A U+0174)
  0x01, 0x5A, 0x01, 0x75, 0x01, // Śŵ (U+015A U+0175)
  0x01, 0x5A, 0x01, 0x76, 0x02, // ŚŶ (U+015A U+0176)
  0x01, 0x5A, 0x01, 0x77, 0x02, // Śŷ (U+015A U+0177)
  0x01, 0x5A, 0x01, 0x78, 0x02, // ŚŸ (U+015A U+0178)
  0x01, 0x5B, 0x00, 0x22, 0x02, // ś" (U+015B U+0022)
  0x01, 0x5B, 0x00, 0x27, 0x02, // ś' (U+015B U+0027)
  0x01, 0x5B, 0x00, 0x56, 0x03, // śV (U+015B U+0056)
  0x01, 0x5B, 0x00, 0x57, 0x03, // śW (U+015B U+0057)
  0x01, 0x5B, 0x00, 0x59, 0x05, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x05, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x74, 0x03, // śŴ (U+015B U+0174)
  0x01, 0x5B, 0x01, 0x76, 0x05, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x05, // śŸ (U+015B U+0178)
  0x01, 0x5C, 0x00, 0x41, 0x01, // ŜA (U+015C U+0041)
  0x01, 0x5C, 0x00, 0x54, 0x02, // ŜT (U+015C U+0054)
  0x01, 0x5C, 0x00, 0x56, 0x02, // ŜV (U+015C U+0056)
  0x01, 0x5C, 0x00, 0x57, 0x02, // ŜW (U+015C U+0057)
  0x01, 0x5C, 0x00, 0x58, 0x02, // ŜX (U+015C U+0058)
  0x01, 0x5C, 0x00, 0x59, 0x02, // ŜY (U+015C U+0059)
  0x01, 0x5C, 0x00, 0x77, 0x01, // Ŝw (U+015C U+0077)
  0x01, 0x5C, 0x00, 0x79, 0x02, // Ŝy (U+015C U+0079)
  0x01, 0x5C, 0x00, 0xC0, 0x01, // ŜÀ (U+015C U+00C0)
  0x01, 0x5C, 0x00, 0xC1, 0x01, // ŜÁ (U+015C U+00C1)
  0x01, 0x5C, 0x00, 0xC2, 0x01, // ŜÂ (U+015C U+00C2)
  0x01, 0x5C, 0x00, 0xC3, 0x01, // ŜÃ (U+015C U+00C3)
  0x01, 0x5C, 0x00, 0xC4, 0x01, // ŜÄ (U+015C U+00C4)
  0x01, 0x5C, 0x00, 0xC5, 0x01, // ŜÅ (U+015C U+00C5)
  0x01, 0x5C, 0x00, 0xC6, 0x02, // ŜÆ (U+015C U+00C6)
  0x01, 0x5C, 0x00, 0xDD, 0x02, // ŜÝ (U+015C U+00DD)
  0x01, 0x5C, 0x00, 0xFD, 0x02, // Ŝý (U+015C U+00FD)
  0x01, 0x5C, 0x00, 0xFF, 0x02, // Ŝÿ (U+015C U+00FF)
  0x01, 0x5C, 0x01, 0x00, 0x01, // ŜĀ (U+015C U+0100)
  0x01, 0x5C, 0x01, 0x02, 0x01, // ŜĂ (U+015C U+0102)
  0x01, 0x5C, 0x01, 0x04, 0x01, // ŜĄ (U+015C U+0104)
  0x01, 0x5C, 0x01, 0x74, 0x02, // ŜŴ (U+015C U+0174)
  0x01, 0x5C, 0x01, 0x75, 0x01, // Ŝŵ (U+015C U+0175)
  0x01, 0x5C, 0x01, 0x76, 0x02, // ŜŶ (U+015C U+0176)
  0x01, 0x5C, 0x01, 0x77, 0x02, // Ŝŷ (U+015C U+0177)
  0x01, 0x5C, 0x01, 0x78, 0x02, // ŜŸ (U+015C U+0178)
  0x01, 0x5D, 0x00, 0x22, 0x02, // ŝ" (U+015D U+0022)
  0x01, 0x5D, 0x00, 0x27, 0x02, // ŝ' (U+015D U+0027)
  0x01, 0x5D, 0x00, 0x56, 0x03, // ŝV (U+015D U+0056)
  0x01, 0x5D, 0x00, 0x57, 0x03, // ŝW (U+015D U+0057)
  0x01, 0x5D, 0x00, 0x59, 0x05, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x05, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x74, 0x03, // ŝŴ (U+015D U+0174)
  0x01, 0x5D, 0x01, 0x76, 0x05, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x05, // ŝŸ (U+015D U+0178)
  0x01, 0x5E, 0x00, 0x41, 0x01, // ŞA (U+015E U+0041)
  0x01, 0x5E, 0x00, 0x54, 0x02, // ŞT (U+015E U+0054)
  0x01, 0x5E, 0x00, 0x56, 0x02, // ŞV (U+015E U+0056)
  0x01, 0x5E, 0x00, 0x57, 0x02, // ŞW (U+015E U+0057)
  0x01, 0x5E, 0x00, 0x58, 0x02, // ŞX (U+015E U+0058)
  0x01, 0x5E, 0x00, 0x59, 0x02, // ŞY (U+015E U+0059)
  0x01, 0x5E, 0x00, 0x77, 0x01, // Şw (U+015E U+0077)
  0x01, 0x5E, 0x00, 0x79, 0x02, // Şy (U+015E U+0079)
  0x01, 0x5E, 0x00, 0xC0, 0x01, // ŞÀ (U+015E U+00C0)
  0x01, 0x5E, 0x00, 0xC1, 0x01, // ŞÁ (U+015E U+00C1)
  0x01, 0x5E, 0x00, 0xC2, 0x01, // ŞÂ (U+015E U+00C2)
  0x01, 0x5E, 0x00, 0xC3, 0x01, // ŞÃ (U+015E U+00C3)
  0x01, 0x5E, 0x00, 0xC4, 0x01, // ŞÄ (U+015E U+00C4)
  0x01, 0x5E, 0x00, 0xC5, 0x01, // ŞÅ (U+015E U+00C5)
  0x01, 0x5E, 0x00, 0xC6, 0x02, // ŞÆ (U+015E U+00C6)
  0x01, 0x5E, 0x00, 0xDD, 0x02, // ŞÝ (U+015E U+00DD)
  0x01, 0x5E, 0x00, 0xFD, 0x02, // Şý (U+015E U+00FD)
  0x01, 0x5E, 0x00, 0xFF, 0x02, // Şÿ (U+015E U+00FF)
  0x01, 0x5E, 0x01, 0x00, 0x01, // ŞĀ (U+015E U+0100)
  0x01, 0x5E, 0x01, 0x02, 0x01, // ŞĂ (U+015E U+0102)
  0x01, 0x5E, 0x01, 0x04, 0x01, // ŞĄ (U+015E U+0104)
  0x01, 0x5E, 0x01, 0x74, 0x02, // ŞŴ (U+015E U+0174)
  0x01, 0x5E, 0x01, 0x75, 0x01, // Şŵ (U+015E U+0175)
  0x01, 0x5E, 0x01, 0x76, 0x02, // ŞŶ (U+015E U+0176)
  0x01, 0x5E, 0x01, 0x77, 0x02, // Şŷ (U+015E U+0177)
  0x01, 0x5E, 0x01, 0x78, 0x02, // ŞŸ (U+015E U+0178)
  0x01, 0x5F, 0x00, 0x22, 0x02, // ş" (U+015F U+0022)
  0x01, 0x5F, 0x00, 0x27, 0x02, // ş' (U+015F U+0027)
  0x01, 0x5F, 0x00, 0x56, 0x03, // şV (U+015F U+0056)
  0x01, 0x5F, 0x00, 0x57, 0x03, // şW (U+015F U+0057)
  0x01, 0x5F, 0x00, 0x59, 0x05, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x05, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x74, 0x03, // şŴ (U+015F U+0174)
  0x01, 0x5F, 0x01, 0x76, 0x05, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x05, // şŸ (U+015F U+0178)
  0x01, 0x60, 0x00, 0x41, 0x01, // ŠA (U+0160 U+0041)
  0x01, 0x60, 0x00, 0x54, 0x02, // ŠT (U+0160 U+0054)
  0x01, 0x60, 0x00, 0x56, 0x02, // ŠV (U+0160 U+0056)
  0x01, 0x60, 0x00, 0x57, 0x02, // ŠW (U+0160 U+0057)
  0x01, 0x60, 0x00, 0x58, 0x02, // ŠX (U+0160 U+0058)
  0x01, 0x60, 0x00, 0x59, 0x02, // ŠY (U+0160 U+0059)
  0x01, 0x60, 0x00, 0x77, 0x01, // Šw (U+0160 U+0077)
  0x01, 0x60, 0x00, 0x79, 0x02, // Šy (U+0160 U+0079)
  0x01, 0x60, 0x00, 0xC0, 0x01, // ŠÀ (U+0160 U+00C0)
  0x01, 0x60, 0x00, 0xC1, 0x01, // ŠÁ (U+0160 U+00C1)
  0x01, 0x60, 0x00, 0xC2, 0x01, // ŠÂ (U+0160 U+00C2)
  0x01, 0x60, 0x00, 0xC3, 0x01, // ŠÃ (U+0160 U+00C3)
  0x01, 0x60, 0x00, 0xC4, 0x01, // ŠÄ (U+0160 U+00C4)
  0x01, 0x60, 0x00, 0xC5, 0x01, // ŠÅ (U+0160 U+00C5)
  0x01, 0x60, 0x00, 0xC6, 0x02, // ŠÆ (U+0160 U+00C6)
  0x01, 0x60, 0x00, 0xDD, 0x02, // ŠÝ (U+0160 U+00DD)
  0x01, 0x60, 0x00, 0xFD, 0x02, // Šý (U+0160 U+00FD)
  0x01, 0x60, 0x00, 0xFF, 0x02, // Šÿ (U+0160 U+00FF)
  0x01, 0x60, 0x01, 0x00, 0x01, // ŠĀ (U+0160 U+0100)
  0x01, 0x60, 0x01, 0x02, 0x01, // ŠĂ (U+0160 U+0102)
  0x01, 0x60, 0x01, 0x04, 0x01, // ŠĄ (U+0160 U+0104)
  0x01, 0x60, 0x01, 0x74, 0x02, // ŠŴ (U+0160 U+0174)
  0x01, 0x60, 0x01, 0x75, 0x01, // Šŵ (U+0160 U+0175)
  0x01, 0x60, 0x01, 0x76, 0x02, // ŠŶ (U+0160 U+0176)
  0x01, 0x60, 0x01, 0x77, 0x02, // Šŷ (U+0160 U+0177)
  0x01, 0x60, 0x01, 0x78, 0x02, // ŠŸ (U+0160 U+0178)
  0x01, 0x61, 0x00, 0x22, 0x02, // š" (U+0161 U+0022)
  0x01, 0x61, 0x00, 0x27, 0x02, // š' (U+0161 U+0027)
  0x01, 0x61, 0x00, 0x56, 0x03, // šV (U+0161 U+0056)
  0x01, 0x61, 0x00, 0x57, 0x03, // šW (U+0161 U+0057)
  0x01, 0x61, 0x00, 0x59, 0x05, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x05, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x74, 0x03, // šŴ (U+0161 U+0174)
  0x01, 0x61, 0x01, 0x76, 0x05, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x05, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x26, 0x02, // Ţ& (U+0162 U+0026)
  0x01, 0x62, 0x00, 0x2C, 0x07, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x07, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x05, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x43, 0x01, // ŢC (U+0162 U+0043)
  0x01, 0x62, 0x00, 0x47, 0x01, // ŢG (U+0162 U+0047)
  0x01, 0x62, 0x00, 0x4F, 0x01, // ŢO (U+0162 U+004F)
  0x01, 0x62, 0x00, 0x51, 0x01, // ŢQ (U+0162 U+0051)
  0x01, 0x62, 0x00, 0x61, 0x03, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x03, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x03, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x03, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x03, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x03, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x03, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x05, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x05, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x05, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x05, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x05, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x05, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x07, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xC7, 0x01, // ŢÇ (U+0162 U+00C7)
  0x01, 0x62, 0x00, 0xD2, 0x01, // ŢÒ (U+0162 U+00D2)
  0x01, 0x62, 0x00, 0xD3, 0x01, // ŢÓ (U+0162 U+00D3)
  0x01, 0x62, 0x00, 0xD4, 0x01, // ŢÔ (U+0162 U+00D4)
  0x01, 0x62, 0x00, 0xD5, 0x01, // ŢÕ (U+0162 U+00D5)
  0x01, 0x62, 0x00, 0xD6, 0x01, // ŢÖ (U+0162 U+00D6)
  0x01, 0x62, 0x00, 0xD8, 0x01, // ŢØ (U+0162 U+00D8)
  0x01, 0x62, 0x00, 0xE0, 0x03, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x03, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x03, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x03, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x03, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x03, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x03, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x03, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x03, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x03, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x03, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x03, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x03, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x03, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x03, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x03, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x03, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x03, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x03, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x05, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x03, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x05, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x03, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x05, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x03, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x06, 0x01, // ŢĆ (U+0162 U+0106)
  0x01, 0x62, 0x01, 0x07, 0x03, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x08, 0x01, // ŢĈ (U+0162 U+0108)
  0x01, 0x62, 0x01, 0x09, 0x03, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0A, 0x01, // ŢĊ (U+0162 U+010A)
  0x01, 0x62, 0x01, 0x0B, 0x03, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0C, 0x01, // ŢČ (U+0162 U+010C)
  0x01, 0x62, 0x01, 0x0D, 0x03, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x03, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x03, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x03, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x03, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x03, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x03, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x03, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1C, 0x01, // ŢĜ (U+0162 U+011C)
  0x01, 0x62, 0x01, 0x1D, 0x03, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1E, 0x01, // ŢĞ (U+0162 U+011E)
  0x01, 0x62, 0x01, 0x1F, 0x03, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x20, 0x01, // ŢĠ (U+0162 U+0120)
  0x01, 0x62, 0x01, 0x21, 0x03, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x22, 0x01, // ŢĢ (U+0162 U+0122)
  0x01, 0x62, 0x01, 0x23, 0x03, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4C, 0x01, // ŢŌ (U+0162 U+014C)
  0x01, 0x62, 0x01, 0x4D, 0x03, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4E, 0x01, // ŢŎ (U+0162 U+014E)
  0x01, 0x62, 0x01, 0x4F, 0x03, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x50, 0x01, // ŢŐ (U+0162 U+0150)
  0x01, 0x62, 0x01, 0x51, 0x03, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x52, 0x01, // ŢŒ (U+0162 U+0152)
  0x01, 0x62, 0x01, 0x53, 0x03, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x07, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x07, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x07, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x26, 0x02, // Ť& (U+0164 U+0026)
  0x01, 0x64, 0x00, 0x2C, 0x07, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x07, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x05, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x43, 0x01, // ŤC (U+0164 U+0043)
  0x01, 0x64, 0x00, 0x47, 0x01, // ŤG (U+0164 U+0047)
  0x01, 0x64, 0x00, 0x4F, 0x01, // ŤO (U+0164 U+004F)
  0x01, 0x64, 0x00, 0x51, 0x01, // ŤQ (U+0164 U+0051)
  0x01, 0x64, 0x00, 0x61, 0x03, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x03, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x03, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x03, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x03, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x03, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x03, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x05, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x05, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x05, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x05, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x05, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x05, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x07, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xC7, 0x01, // ŤÇ (U+0164 U+00C7)
  0x01, 0x64, 0x00, 0xD2, 0x01, // ŤÒ (U+0164 U+00D2)
  0x01, 0x64, 0x00, 0xD3, 0x01, // ŤÓ (U+0164 U+00D3)
  0x01, 0x64, 0x00, 0xD4, 0x01, // ŤÔ (U+0164 U+00D4)
  0x01, 0x64, 0x00, 0xD5, 0x01, // ŤÕ (U+0164 U+00D5)
  0x01, 0x64, 0x00, 0xD6, 0x01, // ŤÖ (U+0164 U+00D6)
  0x01, 0x64, 0x00, 0xD8, 0x01, // ŤØ (U+0164 U+00D8)
  0x01, 0x64, 0x00, 0xE0, 0x03, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x03, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x03, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x03, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x03, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x03, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x03, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x03, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x03, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x03, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x03, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x03, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x03, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x03, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x03, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x03, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x03, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x03, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x03, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x05, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x03, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x05, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x03, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x05, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x03, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x06, 0x01, // ŤĆ (U+0164 U+0106)
  0x01, 0x64, 0x01, 0x07, 0x03, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x08, 0x01, // ŤĈ (U+0164 U+0108)
  0x01, 0x64, 0x01, 0x09, 0x03, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0A, 0x01, // ŤĊ (U+0164 U+010A)
  0x01, 0x64, 0x01, 0x0B, 0x03, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0C, 0x01, // ŤČ (U+0164 U+010C)
  0x01, 0x64, 0x01, 0x0D, 0x03, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x03, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x03, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x03, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x03, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x03, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x03, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x03, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1C, 0x01, // ŤĜ (U+0164 U+011C)
  0x01, 0x64, 0x01, 0x1D, 0x03, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1E, 0x01, // ŤĞ (U+0164 U+011E)
  0x01, 0x64, 0x01, 0x1F, 0x03, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x20, 0x01, // ŤĠ (U+0164 U+0120)
  0x01, 0x64, 0x01, 0x21, 0x03, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x22, 0x01, // ŤĢ (U+0164 U+0122)
  0x01, 0x64, 0x01, 0x23, 0x03, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4C, 0x01, // ŤŌ (U+0164 U+014C)
  0x01, 0x64, 0x01, 0x4D, 0x03, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4E, 0x01, // ŤŎ (U+0164 U+014E)
  0x01, 0x64, 0x01, 0x4F, 0x03, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x50, 0x01, // ŤŐ (U+0164 U+0150)
  0x01, 0x64, 0x01, 0x51, 0x03, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x52, 0x01, // ŤŒ (U+0164 U+0152)
  0x01, 0x64, 0x01, 0x53, 0x03, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x07, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x07, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x07, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x26, 0x02, // Ŧ& (U+0166 U+0026)
  0x01, 0x66, 0x00, 0x2C, 0x07, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x07, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x05, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x43, 0x01, // ŦC (U+0166 U+0043)
  0x01, 0x66, 0x00, 0x47, 0x01, // ŦG (U+0166 U+0047)
  0x01, 0x66, 0x00, 0x4F, 0x01, // ŦO (U+0166 U+004F)
  0x01, 0x66, 0x00, 0x51, 0x01, // ŦQ (U+0166 U+0051)
  0x01, 0x66, 0x00, 0x61, 0x03, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x03, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x03, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x03, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x03, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x03, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x03, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x05, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x05, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x05, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x05, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x05, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x05, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x07, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xC7, 0x01, // ŦÇ (U+0166 U+00C7)
  0x01, 0x66, 0x00, 0xD2, 0x01, // ŦÒ (U+0166 U+00D2)
  0x01, 0x66, 0x00, 0xD3, 0x01, // ŦÓ (U+0166 U+00D3)
  0x01, 0x66, 0x00, 0xD4, 0x01, // ŦÔ (U+0166 U+00D4)
  0x01, 0x66, 0x00, 0xD5, 0x01, // ŦÕ (U+0166 U+00D5)
  0x01, 0x66, 0x00, 0xD6, 0x01, // ŦÖ (U+0166 U+00D6)
  0x01, 0x66, 0x00, 0xD8, 0x01, // ŦØ (U+0166 U+00D8)
  0x01, 0x66, 0x00, 0xE0, 0x03, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x03, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x03, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x03, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x03, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x03, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x03, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x03, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x03, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x03, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x03, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x03, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x03, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x03, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x03, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x03, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x03, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x03, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x03, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x05, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x03, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x05, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x03, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x05, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x03, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x06, 0x01, // ŦĆ (U+0166 U+0106)
  0x01, 0x66, 0x01, 0x07, 0x03, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x08, 0x01, // ŦĈ (U+0166 U+0108)
  0x01, 0x66, 0x01, 0x09, 0x03, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0A, 0x01, // ŦĊ (U+0166 U+010A)
  0x01, 0x66, 0x01, 0x0B, 0x03, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0C, 0x01, // ŦČ (U+0166 U+010C)
  0x01, 0x66, 0x01, 0x0D, 0x03, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x03, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x03, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x03, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x03, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x03, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x03, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x03, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1C, 0x01, // ŦĜ (U+0166 U+011C)
  0x01, 0x66, 0x01, 0x1D, 0x03, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1E, 0x01, // ŦĞ (U+0166 U+011E)
  0x01, 0x66, 0x01, 0x1F, 0x03, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x20, 0x01, // ŦĠ (U+0166 U+0120)
  0x01, 0x66, 0x01, 0x21, 0x03, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x22, 0x01, // ŦĢ (U+0166 U+0122)
  0x01, 0x66, 0x01, 0x23, 0x03, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4C, 0x01, // ŦŌ (U+0166 U+014C)
  0x01, 0x66, 0x01, 0x4D, 0x03, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4E, 0x01, // ŦŎ (U+0166 U+014E)
  0x01, 0x66, 0x01, 0x4F, 0x03, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x50, 0x01, // ŦŐ (U+0166 U+0150)
  0x01, 0x66, 0x01, 0x51, 0x03, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x52, 0x01, // ŦŒ (U+0166 U+0152)
  0x01, 0x66, 0x01, 0x53, 0x03, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x07, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x07, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x07, // Ŧ… (U+0166 U+2026)
  0x01, 0x68, 0x00, 0x26, 0x02, // Ũ& (U+0168 U+0026)
  0x01, 0x68, 0x00, 0x2C, 0x02, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x02, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x00, 0x41, 0x02, // ŨA (U+0168 U+0041)
  0x01, 0x68, 0x00, 0xC0, 0x02, // ŨÀ (U+0168 U+00C0)
  0x01, 0x68, 0x00, 0xC1, 0x02, // ŨÁ (U+0168 U+00C1)
  0x01, 0x68, 0x00, 0xC2, 0x02, // ŨÂ (U+0168 U+00C2)
  0x01, 0x68, 0x00, 0xC3, 0x02, // ŨÃ (U+0168 U+00C3)
  0x01, 0x68, 0x00, 0xC4, 0x02, // ŨÄ (U+0168 U+00C4)
  0x01, 0x68, 0x00, 0xC5, 0x02, // ŨÅ (U+0168 U+00C5)
  0x01, 0x68, 0x00, 0xC6, 0x02, // ŨÆ (U+0168 U+00C6)
  0x01, 0x68, 0x01, 0x00, 0x02, // ŨĀ (U+0168 U+0100)
  0x01, 0x68, 0x01, 0x02, 0x02, // ŨĂ (U+0168 U+0102)
  0x01, 0x68, 0x01, 0x04, 0x02, // ŨĄ (U+0168 U+0104)
  0x01, 0x68, 0x20, 0x1A, 0x02, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x02, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x02, // Ũ… (U+0168 U+2026)
  0x01, 0x69, 0x00, 0x22, 0x04, // ũ" (U+0169 U+0022)
  0x01, 0x69, 0x00, 0x27, 0x04, // ũ' (U+0169 U+0027)
  0x01, 0x69, 0x00, 0x2A, 0x01, // ũ* (U+0169 U+002A)
  0x01, 0x69, 0x00, 0x54, 0x02, // ũT (U+0169 U+0054)
  0x01, 0x69, 0x00, 0x56, 0x05, // ũV (U+0169 U+0056)
  0x01, 0x69, 0x00, 0x57, 0x04, // ũW (U+0169 U+0057)
  0x01, 0x69, 0x00, 0x59, 0x05, // ũY (U+0169 U+0059)
  0x01, 0x69, 0x00, 0x79, 0x01, // ũy (U+0169 U+0079)
  0x01, 0x69, 0x00, 0xDD, 0x05, // ũÝ (U+0169 U+00DD)
  0x01, 0x69, 0x00, 0xFD, 0x01, // ũý (U+0169 U+00FD)
  0x01, 0x69, 0x00, 0xFF, 0x01, // ũÿ (U+0169 U+00FF)
  0x01, 0x69, 0x01, 0x74, 0x04, // ũŴ (U+0169 U+0174)
  0x01, 0x69, 0x01, 0x76, 0x05, // ũŶ (U+0169 U+0176)
  0x01, 0x69, 0x01, 0x77, 0x01, // ũŷ (U+0169 U+0177)
  0x01, 0x69, 0x01, 0x78, 0x05, // ũŸ (U+0169 U+0178)
  0x01, 0x69, 0x20, 0x18, 0x03, // ũ‘ (U+0169 U+2018)
  0x01, 0x69, 0x20, 0x19, 0x01, // ũ’ (U+0169 U+2019)
  0x01, 0x69, 0x20, 0x1C, 0x03, // ũ“ (U+0169 U+201C)
  0x01, 0x69, 0x20, 0x1D, 0x01, // ũ” (U+0169 U+201D)
  0x01, 0x69, 0x21, 0x22, 0x01, // ũ™ (U+0169 U+2122)
  0x01, 0x6A, 0x00, 0x26, 0x02, // Ū& (U+016A U+0026)
  0x01, 0x6A, 0x00, 0x2C, 0x02, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x02, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x00, 0x41, 0x02, // ŪA (U+016A U+0041)
  0x01, 0x6A, 0x00, 0xC0, 0x02, // ŪÀ (U+016A U+00C0)
  0x01, 0x6A, 0x00, 0xC1, 0x02, // ŪÁ (U+016A U+00C1)
  0x01, 0x6A, 0x00, 0xC2, 0x02, // ŪÂ (U+016A U+00C2)
  0x01, 0x6A, 0x00, 0xC3, 0x02, // ŪÃ (U+016A U+00C3)
  0x01, 0x6A, 0x00, 0xC4, 0x02, // ŪÄ (U+016A U+00C4)
  0x01, 0x6A, 0x00, 0xC5, 0x02, // ŪÅ (U+016A U+00C5)
  0x01, 0x6A, 0x00, 0xC6, 0x02, // ŪÆ (U+016A U+00C6)
  0x01, 0x6A, 0x01, 0x00, 0x02, // ŪĀ (U+016A U+0100)
  0x01, 0x6A, 0x01, 0x02, 0x02, // ŪĂ (U+016A U+0102)
  0x01, 0x6A, 0x01, 0x04, 0x02, // ŪĄ (U+016A U+0104)
  0x01, 0x6A, 0x20, 0x1A, 0x02, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x02, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x02, // Ū… (U+016A U+2026)
  0x01, 0x6B, 0x00, 0x22, 0x04, // ū" (U+016B U+0022)
  0x01, 0x6B, 0x00, 0x27, 0x04, // ū' (U+016B U+0027)
  0x01, 0x6B, 0x00, 0x2A, 0x01, // ū* (U+016B U+002A)
  0x01, 0x6B, 0x00, 0x54, 0x02, // ūT (U+016B U+0054)
  0x01, 0x6B, 0x00, 0x56, 0x05, // ūV (U+016B U+0056)
  0x01, 0x6B, 0x00, 0x57, 0x04, // ūW (U+016B U+0057)
  0x01, 0x6B, 0x00, 0x59, 0x05, // ūY (U+016B U+0059)
  0x01, 0x6B, 0x00, 0x79, 0x01, // ūy (U+016B U+0079)
  0x01, 0x6B, 0x00, 0xDD, 0x05, // ūÝ (U+016B U+00DD)
  0x01, 0x6B, 0x00, 0xFD, 0x01, // ūý (U+016B U+00FD)
  0x01, 0x6B, 0x00, 0xFF, 0x01, // ūÿ (U+016B U+00FF)
  0x01, 0x6B, 0x01, 0x74, 0x04, // ūŴ (U+016B U+0174)
  0x01, 0x6B, 0x01, 0x76, 0x05, // ūŶ (U+016B U+0176)
  0x01, 0x6B, 0x01, 0x77, 0x01, // ūŷ (U+016B U+0177)
  0x01, 0x6B, 0x01, 0x78, 0x05, // ūŸ (U+016B U+0178)
  0x01, 0x6B, 0x20, 0x18, 0x03, // ū‘ (U+016B U+2018)
  0x01, 0x6B, 0x20, 0x19, 0x01, // ū’ (U+016B U+2019)
  0x01, 0x6B, 0x20, 0x1C, 0x03, // ū“ (U+016B U+201C)
  0x01, 0x6B, 0x20, 0x1D, 0x01, // ū” (U+016B U+201D)
  0x01, 0x6B, 0x21, 0x22, 0x01, // ū™ (U+016B U+2122)
  0x01, 0x6C, 0x00, 0x26, 0x02, // Ŭ& (U+016C U+0026)
  0x01, 0x6C, 0x00, 0x2C, 0x02, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x02, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x00, 0x41, 0x02, // ŬA (U+016C U+0041)
  0x01, 0x6C, 0x00, 0xC0, 0x02, // ŬÀ (U+016C U+00C0)
  0x01, 0x6C, 0x00, 0xC1, 0x02, // ŬÁ (U+016C U+00C1)
  0x01, 0x6C, 0x00, 0xC2, 0x02, // ŬÂ (U+016C U+00C2)
  0x01, 0x6C, 0x00, 0xC3, 0x02, // ŬÃ (U+016C U+00C3)
  0x01, 0x6C, 0x00, 0xC4, 0x02, // ŬÄ (U+016C U+00C4)
  0x01, 0x6C, 0x00, 0xC5, 0x02, // ŬÅ (U+016C U+00C5)
  0x01, 0x6C, 0x00, 0xC6, 0x02, // ŬÆ (U+016C U+00C6)
  0x01, 0x6C, 0x01, 0x00, 0x02, // ŬĀ (U+016C U+0100)
  0x01, 0x6C, 0x01, 0x02, 0x02, // ŬĂ (U+016C U+0102)
  0x01, 0x6C, 0x01, 0x04, 0x02, // ŬĄ (U+016C U+0104)
  0x01, 0x6C, 0x20, 0x1A, 0x02, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x02, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x02, // Ŭ… (U+016C U+2026)
  0x01, 0x6D, 0x00, 0x22, 0x04, // ŭ" (U+016D U+0022)
  0x01, 0x6D, 0x00, 0x27, 0x04, // ŭ' (U+016D U+0027)
  0x01, 0x6D, 0x00, 0x2A, 0x01, // ŭ* (U+016D U+002A)
  0x01, 0x6D, 0x00, 0x54, 0x02, // ŭT (U+016D U+0054)
  0x01, 0x6D, 0x00, 0x56, 0x05, // ŭV (U+016D U+0056)
  0x01, 0x6D, 0x00, 0x57, 0x04, // ŭW (U+016D U+0057)
  0x01, 0x6D, 0x00, 0x59, 0x05, // ŭY (U+016D U+0059)
  0x01, 0x6D, 0x00, 0x79, 0x01, // ŭy (U+016D U+0079)
  0x01, 0x6D, 0x00, 0xDD, 0x05, // ŭÝ (U+016D U+00DD)
  0x01, 0x6D, 0x00, 0xFD, 0x01, // ŭý (U+016D U+00FD)
  0x01, 0x6D, 0x00, 0xFF, 0x01, // ŭÿ (U+016D U+00FF)
  0x01, 0x6D, 0x01, 0x74, 0x04, // ŭŴ (U+016D U+0174)
  0x01, 0x6D, 0x01, 0x76, 0x05, // ŭŶ (U+016D U+0176)
  0x01, 0x6D, 0x01, 0x77, 0x01, // ŭŷ (U+016D U+0177)
  0x01, 0x6D, 0x01, 0x78, 0x05, // ŭŸ (U+016D U+0178)
  0x01, 0x6D, 0x20, 0x18, 0x03, // ŭ‘ (U+016D U+2018)
  0x01, 0x6D, 0x20, 0x19, 0x01, // ŭ’ (U+016D U+2019)
  0x01, 0x6D, 0x20, 0x1C, 0x03, // ŭ“ (U+016D U+201C)
  0x01, 0x6D, 0x20, 0x1D, 0x01, // ŭ” (U+016D U+201D)
  0x01, 0x6D, 0x21, 0x22, 0x01, // ŭ™ (U+016D U+2122)
  0x01, 0x6E, 0x00, 0x26, 0x02, // Ů& (U+016E U+0026)
  0x01, 0x6E, 0x00, 0x2C, 0x02, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x02, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x00, 0x41, 0x02, // ŮA (U+016E U+0041)
  0x01, 0x6E, 0x00, 0xC0, 0x02, // ŮÀ (U+016E U+00C0)
  0x01, 0x6E, 0x00, 0xC1, 0x02, // ŮÁ (U+016E U+00C1)
  0x01, 0x6E, 0x00, 0xC2, 0x02, // ŮÂ (U+016E U+00C2)
  0x01, 0x6E, 0x00, 0xC3, 0x02, // ŮÃ (U+016E U+00C3)
  0x01, 0x6E, 0x00, 0xC4, 0x02, // ŮÄ (U+016E U+00C4)
  0x01, 0x6E, 0x00, 0xC5, 0x02, // ŮÅ (U+016E U+00C5)
  0x01, 0x6E, 0x00, 0xC6, 0x02, // ŮÆ (U+016E U+00C6)
  0x01, 0x6E, 0x01, 0x00, 0x02, // ŮĀ (U+016E U+0100)
  0x01, 0x6E, 0x01, 0x02, 0x02, // ŮĂ (U+016E U+0102)
  0x01, 0x6E, 0x01, 0x04, 0x02, // ŮĄ (U+016E U+0104)
  0x01, 0x6E, 0x20, 0x1A, 0x02, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x02, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x02, // Ů… (U+016E U+2026)
  0x01, 0x6F, 0x00, 0x22, 0x04, // ů" (U+016F U+0022)
  0x01, 0x6F, 0x00, 0x27, 0x04, // ů' (U+016F U+0027)
  0x01, 0x6F, 0x00, 0x2A, 0x01, // ů* (U+016F U+002A)
  0x01, 0x6F, 0x00, 0x54, 0x02, // ůT (U+016F U+0054)
  0x01, 0x6F, 0x00, 0x56, 0x05, // ůV (U+016F U+0056)
  0x01, 0x6F, 0x00, 0x57, 0x04, // ůW (U+016F U+0057)
  0x01, 0x6F, 0x00, 0x59, 0x05, // ůY (U+016F U+0059)
  0x01, 0x6F, 0x00, 0x79, 0x01, // ůy (U+016F U+0079)
  0x01, 0x6F, 0x00, 0xDD, 0x05, // ůÝ (U+016F U+00DD)
  0x01, 0x6F, 0x00, 0xFD, 0x01, // ůý (U+016F U+00FD)
  0x01, 0x6F, 0x00, 0xFF, 0x01, // ůÿ (U+016F U+00FF)
  0x01, 0x6F, 0x01, 0x74, 0x04, // ůŴ (U+016F U+0174)
  0x01, 0x6F, 0x01, 0x76, 0x05, // ůŶ (U+016F U+0176)
  0x01, 0x6F, 0x01, 0x77, 0x01, // ůŷ (U+016F U+0177)
  0x01, 0x6F, 0x01, 0x78, 0x05, // ůŸ (U+016F U+0178)
  0x01, 0x6F, 0x20, 0x18, 0x03, // ů‘ (U+016F U+2018)
  0x01, 0x6F, 0x20, 0x19, 0x01, // ů’ (U+016F U+2019)
  0x01, 0x6F, 0x20, 0x1C, 0x03, // ů“ (U+016F U+201C)
  0x01, 0x6F, 0x20, 0x1D, 0x01, // ů” (U+016F U+201D)
  0x01, 0x6F, 0x21, 0x22, 0x01, // ů™ (U+016F U+2122)
  0x01, 0x70, 0x00, 0x26, 0x02, // Ű& (U+0170 U+0026)
  0x01, 0x70, 0x00, 0x2C, 0x02, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x02, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x00, 0x41, 0x02, // ŰA (U+0170 U+0041)
  0x01, 0x70, 0x00, 0xC0, 0x02, // ŰÀ (U+0170 U+00C0)
  0x01, 0x70, 0x00, 0xC1, 0x02, // ŰÁ (U+0170 U+00C1)
  0x01, 0x70, 0x00, 0xC2, 0x02, // ŰÂ (U+0170 U+00C2)
  0x01, 0x70, 0x00, 0xC3, 0x02, // ŰÃ (U+0170 U+00C3)
  0x01, 0x70, 0x00, 0xC4, 0x02, // ŰÄ (U+0170 U+00C4)
  0x01, 0x70, 0x00, 0xC5, 0x02, // ŰÅ (U+0170 U+00C5)
  0x01, 0x70, 0x00, 0xC6, 0x02, // ŰÆ (U+0170 U+00C6)
  0x01, 0x70, 0x01, 0x00, 0x02, // ŰĀ (U+0170 U+0100)
  0x01, 0x70, 0x01, 0x02, 0x02, // ŰĂ (U+0170 U+0102)
  0x01, 0x70, 0x01, 0x04, 0x02, // ŰĄ (U+0170 U+0104)
  0x01, 0x70, 0x20, 0x1A, 0x02, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x02, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x02, // Ű… (U+0170 U+2026)
  0x01, 0x71, 0x00, 0x22, 0x04, // ű" (U+0171 U+0022)
  0x01, 0x71, 0x00, 0x27, 0x04, // ű' (U+0171 U+0027)
  0x01, 0x71, 0x00, 0x2A, 0x01, // ű* (U+0171 U+002A)
  0x01, 0x71, 0x00, 0x54, 0x02, // űT (U+0171 U+0054)
  0x01, 0x71, 0x00, 0x56, 0x05, // űV (U+0171 U+0056)
  0x01, 0x71, 0x00, 0x57, 0x04, // űW (U+0171 U+0057)
  0x01, 0x71, 0x00, 0x59, 0x05, // űY (U+0171 U+0059)
  0x01, 0x71, 0x00, 0x79, 0x01, // űy (U+0171 U+0079)
  0x01, 0x71, 0x00, 0xDD, 0x05, // űÝ (U+0171 U+00DD)
  0x01, 0x71, 0x00, 0xFD, 0x01, // űý (U+0171 U+00FD)
  0x01, 0x71, 0x00, 0xFF, 0x01, // űÿ (U+0171 U+00FF)
  0x01, 0x71, 0x01, 0x74, 0x04, // űŴ (U+0171 U+0174)
  0x01, 0x71, 0x01, 0x76, 0x05, // űŶ (U+0171 U+0176)
  0x01, 0x71, 0x01, 0x77, 0x01, // űŷ (U+0171 U+0177)
  0x01, 0x71, 0x01, 0x78, 0x05, // űŸ (U+0171 U+0178)
  0x01, 0x71, 0x20, 0x18, 0x03, // ű‘ (U+0171 U+2018)
  0x01, 0x71, 0x20, 0x19, 0x01, // ű’ (U+0171 U+2019)
  0x01, 0x71, 0x20, 0x1C, 0x03, // ű“ (U+0171 U+201C)
  0x01, 0x71, 0x20, 0x1D, 0x01, // ű” (U+0171 U+201D)
  0x01, 0x71, 0x21, 0x22, 0x01, // ű™ (U+0171 U+2122)
  0x01, 0x72, 0x00, 0x26, 0x02, // Ų& (U+0172 U+0026)
  0x01, 0x72, 0x00, 0x2C, 0x02, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x02, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x00, 0x41, 0x02, // ŲA (U+0172 U+0041)
  0x01, 0x72, 0x00, 0xC0, 0x02, // ŲÀ (U+0172 U+00C0)
  0x01, 0x72, 0x00, 0xC1, 0x02, // ŲÁ (U+0172 U+00C1)
  0x01, 0x72, 0x00, 0xC2, 0x02, // ŲÂ (U+0172 U+00C2)
  0x01, 0x72, 0x00, 0xC3, 0x02, // ŲÃ (U+0172 U+00C3)
  0x01, 0x72, 0x00, 0xC4, 0x02, // ŲÄ (U+0172 U+00C4)
  0x01, 0x72, 0x00, 0xC5, 0x02, // ŲÅ (U+0172 U+00C5)
  0x01, 0x72, 0x00, 0xC6, 0x02, // ŲÆ (U+0172 U+00C6)
  0x01, 0x72, 0x01, 0x00, 0x02, // ŲĀ (U+0172 U+0100)
  0x01, 0x72, 0x01, 0x02, 0x02, // ŲĂ (U+0172 U+0102)
  0x01, 0x72, 0x01, 0x04, 0x02, // ŲĄ (U+0172 U+0104)
  0x01, 0x72, 0x20, 0x1A, 0x02, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x02, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x02, // Ų… (U+0172 U+2026)
  0x01, 0x73, 0x00, 0x22, 0x04, // ų" (U+0173 U+0022)
  0x01, 0x73, 0x00, 0x27, 0x04, // ų' (U+0173 U+0027)
  0x01, 0x73, 0x00, 0x2A, 0x01, // ų* (U+0173 U+002A)
  0x01, 0x73, 0x00, 0x54, 0x02, // ųT (U+0173 U+0054)
  0x01, 0x73, 0x00, 0x56, 0x05, // ųV (U+0173 U+0056)
  0x01, 0x73, 0x00, 0x57, 0x04, // ųW (U+0173 U+0057)
  0x01, 0x73, 0x00, 0x59, 0x05, // ųY (U+0173 U+0059)
  0x01, 0x73, 0x00, 0x79, 0x01, // ųy (U+0173 U+0079)
  0x01, 0x73, 0x00, 0xDD, 0x05, // ųÝ (U+0173 U+00DD)
  0x01, 0x73, 0x00, 0xFD, 0x01, // ųý (U+0173 U+00FD)
  0x01, 0x73, 0x00, 0xFF, 0x01, // ųÿ (U+0173 U+00FF)
  0x01, 0x73, 0x01, 0x74, 0x04, // ųŴ (U+0173 U+0174)
  0x01, 0x73, 0x01, 0x76, 0x05, // ųŶ (U+0173 U+0176)
  0x01, 0x73, 0x01, 0x77, 0x01, // ųŷ (U+0173 U+0177)
  0x01, 0x73, 0x01, 0x78, 0x05, // ųŸ (U+0173 U+0178)
  0x01, 0x73, 0x20, 0x18, 0x03, // ų‘ (U+0173 U+2018)
  0x01, 0x73, 0x20, 0x19, 0x01, // ų’ (U+0173 U+2019)
  0x01, 0x73, 0x20, 0x1C, 0x03, // ų“ (U+0173 U+201C)
  0x01, 0x73, 0x20, 0x1D, 0x01, // ų” (U+0173 U+201D)
  0x01, 0x73, 0x21, 0x22, 0x01, // ų™ (U+0173 U+2122)
  0x01, 0x74, 0x00, 0x26, 0x03, // Ŵ& (U+0174 U+0026)
  0x01, 0x74, 0x00, 0x2C, 0x08, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x08, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x05, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x43, 0x02, // ŴC (U+0174 U+0043)
  0x01, 0x74, 0x00, 0x47, 0x02, // ŴG (U+0174 U+0047)
  0x01, 0x74, 0x00, 0x4F, 0x02, // ŴO (U+0174 U+004F)
  0x01, 0x74, 0x00, 0x51, 0x02, // ŴQ (U+0174 U+0051)
  0x01, 0x74, 0x00, 0x61, 0x05, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x05, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x05, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x05, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x05, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x05, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x05, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x03, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0x78, 0x02, // Ŵx (U+0174 U+0078)
  0x01, 0x74, 0x00, 0xC0, 0x05, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x05, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x05, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x05, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x05, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x05, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x0C, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xC7, 0x02, // ŴÇ (U+0174 U+00C7)
  0x01, 0x74, 0x00, 0xD2, 0x02, // ŴÒ (U+0174 U+00D2)
  0x01, 0x74, 0x00, 0xD3, 0x02, // ŴÓ (U+0174 U+00D3)
  0x01, 0x74, 0x00, 0xD4, 0x02, // ŴÔ (U+0174 U+00D4)
  0x01, 0x74, 0x00, 0xD5, 0x02, // ŴÕ (U+0174 U+00D5)
  0x01, 0x74, 0x00, 0xD6, 0x02, // ŴÖ (U+0174 U+00D6)
  0x01, 0x74, 0x00, 0xD8, 0x02, // ŴØ (U+0174 U+00D8)
  0x01, 0x74, 0x00, 0xE0, 0x05, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x05, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x05, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x05, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x05, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x05, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x05, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x05, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x05, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x05, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x05, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x05, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x05, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x05, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x05, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x05, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x05, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x05, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x05, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x05, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x05, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x05, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x05, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x05, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x05, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x06, 0x02, // ŴĆ (U+0174 U+0106)
  0x01, 0x74, 0x01, 0x07, 0x05, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x08, 0x02, // ŴĈ (U+0174 U+0108)
  0x01, 0x74, 0x01, 0x09, 0x05, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0A, 0x02, // ŴĊ (U+0174 U+010A)
  0x01, 0x74, 0x01, 0x0B, 0x05, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0C, 0x02, // ŴČ (U+0174 U+010C)
  0x01, 0x74, 0x01, 0x0D, 0x05, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x05, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x05, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x05, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x05, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x05, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x05, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x05, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1C, 0x02, // ŴĜ (U+0174 U+011C)
  0x01, 0x74, 0x01, 0x1D, 0x05, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1E, 0x02, // ŴĞ (U+0174 U+011E)
  0x01, 0x74, 0x01, 0x1F, 0x05, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x20, 0x02, // ŴĠ (U+0174 U+0120)
  0x01, 0x74, 0x01, 0x21, 0x05, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x22, 0x02, // ŴĢ (U+0174 U+0122)
  0x01, 0x74, 0x01, 0x23, 0x05, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4C, 0x02, // ŴŌ (U+0174 U+014C)
  0x01, 0x74, 0x01, 0x4D, 0x05, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4E, 0x02, // ŴŎ (U+0174 U+014E)
  0x01, 0x74, 0x01, 0x4F, 0x05, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x50, 0x02, // ŴŐ (U+0174 U+0150)
  0x01, 0x74, 0x01, 0x51, 0x05, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x52, 0x02, // ŴŒ (U+0174 U+0152)
  0x01, 0x74, 0x01, 0x53, 0x05, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x03, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x03, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x03, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x03, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x20, 0x1A, 0x08, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x08, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x08, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x06, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x06, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x00, 0x41, 0x01, // ŵA (U+0175 U+0041)
  0x01, 0x75, 0x00, 0x56, 0x02, // ŵV (U+0175 U+0056)
  0x01, 0x75, 0x00, 0x57, 0x02, // ŵW (U+0175 U+0057)
  0x01, 0x75, 0x00, 0x59, 0x03, // ŵY (U+0175 U+0059)
  0x01, 0x75, 0x00, 0xC0, 0x01, // ŵÀ (U+0175 U+00C0)
  0x01, 0x75, 0x00, 0xC1, 0x01, // ŵÁ (U+0175 U+00C1)
  0x01, 0x75, 0x00, 0xC2, 0x01, // ŵÂ (U+0175 U+00C2)
  0x01, 0x75, 0x00, 0xC3, 0x01, // ŵÃ (U+0175 U+00C3)
  0x01, 0x75, 0x00, 0xC4, 0x01, // ŵÄ (U+0175 U+00C4)
  0x01, 0x75, 0x00, 0xC5, 0x01, // ŵÅ (U+0175 U+00C5)
  0x01, 0x75, 0x00, 0xDD, 0x03, // ŵÝ (U+0175 U+00DD)
  0x01, 0x75, 0x01, 0x00, 0x01, // ŵĀ (U+0175 U+0100)
  0x01, 0x75, 0x01, 0x02, 0x01, // ŵĂ (U+0175 U+0102)
  0x01, 0x75, 0x01, 0x04, 0x01, // ŵĄ (U+0175 U+0104)
  0x01, 0x75, 0x01, 0x74, 0x02, // ŵŴ (U+0175 U+0174)
  0x01, 0x75, 0x01, 0x76, 0x03, // ŵŶ (U+0175 U+0176)
  0x01, 0x75, 0x01, 0x78, 0x03, // ŵŸ (U+0175 U+0178)
  0x01, 0x75, 0x20, 0x1A, 0x06, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x06, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x06, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x03, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x07, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x07, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x06, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x02, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x02, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x02, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x02, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x53, 0x02, // ŶS (U+0176 U+0053)
  0x01, 0x76, 0x00, 0x61, 0x05, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x06, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x06, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x06, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x06, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x06, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x06, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x05, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x78, 0x01, // Ŷx (U+0176 U+0078)
  0x01, 0x76, 0x00, 0x7A, 0x02, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xC0, 0x06, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x06, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x06, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x06, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x06, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x06, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x08, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xC7, 0x02, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x02, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x02, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x02, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x02, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x02, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x02, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x05, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x05, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x05, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x05, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x05, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x05, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x05, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x06, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x06, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x06, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x06, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x06, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x06, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x06, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x06, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x06, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x06, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x06, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x06, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x06, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x05, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x06, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x05, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x06, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x05, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x02, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x06, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x02, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x06, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x02, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x06, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x02, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x06, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x06, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x06, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x06, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x06, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x06, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x06, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x06, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x02, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x06, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x02, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x06, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x02, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x06, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x02, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x06, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4C, 0x02, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x06, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x02, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x06, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x02, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x06, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x02, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x06, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5A, 0x02, // ŶŚ (U+0176 U+015A)
  0x01, 0x76, 0x01, 0x5B, 0x05, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5C, 0x02, // ŶŜ (U+0176 U+015C)
  0x01, 0x76, 0x01, 0x5D, 0x05, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5E, 0x02, // ŶŞ (U+0176 U+015E)
  0x01, 0x76, 0x01, 0x5F, 0x05, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x60, 0x02, // ŶŠ (U+0176 U+0160)
  0x01, 0x76, 0x01, 0x61, 0x05, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x01, 0x7A, 0x02, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x02, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x02, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x07, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x07, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x07, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x06, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x06, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x01, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0x56, 0x01, // ŷV (U+0177 U+0056)
  0x01, 0x77, 0x00, 0x57, 0x02, // ŷW (U+0177 U+0057)
  0x01, 0x77, 0x00, 0x59, 0x02, // ŷY (U+0177 U+0059)
  0x01, 0x77, 0x00, 0xC0, 0x01, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x01, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x01, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x01, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x01, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x01, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x00, 0xDD, 0x02, // ŷÝ (U+0177 U+00DD)
  0x01, 0x77, 0x01, 0x00, 0x01, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x01, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x01, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x01, 0x74, 0x02, // ŷŴ (U+0177 U+0174)
  0x01, 0x77, 0x01, 0x76, 0x02, // ŷŶ (U+0177 U+0176)
  0x01, 0x77, 0x01, 0x78, 0x02, // ŷŸ (U+0177 U+0178)
  0x01, 0x77, 0x20, 0x1A, 0x06, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x06, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x06, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x03, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x07, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x07, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x06, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x02, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x02, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x02, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x02, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x53, 0x02, // ŸS (U+0178 U+0053)
  0x01, 0x78, 0x00, 0x61, 0x05, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x06, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x06, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x06, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x06, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x06, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x06, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x05, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x78, 0x01, // Ÿx (U+0178 U+0078)
  0x01, 0x78, 0x00, 0x7A, 0x02, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xC0, 0x06, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x06, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x06, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x06, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x06, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x06, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x08, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xC7, 0x02, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x02, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x02, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x02, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x02, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x02, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x02, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x05, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x05, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x05, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x05, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x05, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x05, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x05, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x06, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x06, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x06, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x06, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x06, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x06, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x06, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x06, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x06, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x06, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x06, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x06, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x06, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x05, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x06, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x05, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x06, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x05, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x02, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x06, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x02, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x06, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x02, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x06, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x02, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x06, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x06, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x06, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x06, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x06, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x06, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x06, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x06, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x02, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x06, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x02, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x06, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x02, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x06, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x02, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x06, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4C, 0x02, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x06, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x02, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x06, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x02, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x06, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x02, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x06, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5A, 0x02, // ŸŚ (U+0178 U+015A)
  0x01, 0x78, 0x01, 0x5B, 0x05, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5C, 0x02, // ŸŜ (U+0178 U+015C)
  0x01, 0x78, 0x01, 0x5D, 0x05, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5E, 0x02, // ŸŞ (U+0178 U+015E)
  0x01, 0x78, 0x01, 0x5F, 0x05, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x60, 0x02, // ŸŠ (U+0178 U+0160)
  0x01, 0x78, 0x01, 0x61, 0x05, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x01, 0x7A, 0x02, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x02, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x02, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x07, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x07, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x07, // Ÿ… (U+0178 U+2026)
  0x01, 0x7A, 0x00, 0x2A, 0x02, // ź* (U+017A U+002A)
  0x01, 0x7A, 0x00, 0x56, 0x04, // źV (U+017A U+0056)
  0x01, 0x7A, 0x00, 0x57, 0x03, // źW (U+017A U+0057)
  0x01, 0x7A, 0x00, 0x59, 0x03, // źY (U+017A U+0059)
  0x01, 0x7A, 0x00, 0xDD, 0x03, // źÝ (U+017A U+00DD)
  0x01, 0x7A, 0x01, 0x74, 0x03, // źŴ (U+017A U+0174)
  0x01, 0x7A, 0x01, 0x76, 0x03, // źŶ (U+017A U+0176)
  0x01, 0x7A, 0x01, 0x78, 0x03, // źŸ (U+017A U+0178)
  0x01, 0x7A, 0x20, 0x18, 0x02, // ź‘ (U+017A U+2018)
  0x01, 0x7A, 0x20, 0x19, 0x02, // ź’ (U+017A U+2019)
  0x01, 0x7A, 0x20, 0x1C, 0x02, // ź“ (U+017A U+201C)
  0x01, 0x7A, 0x20, 0x1D, 0x02, // ź” (U+017A U+201D)
  0x01, 0x7A, 0x21, 0x22, 0x02, // ź™ (U+017A U+2122)
  0x01, 0x7C, 0x00, 0x2A, 0x02, // ż* (U+017C U+002A)
  0x01, 0x7C, 0x00, 0x56, 0x04, // żV (U+017C U+0056)
  0x01, 0x7C, 0x00, 0x57, 0x03, // żW (U+017C U+0057)
  0x01, 0x7C, 0x00, 0x59, 0x03, // żY (U+017C U+0059)
  0x01, 0x7C, 0x00, 0xDD, 0x03, // żÝ (U+017C U+00DD)
  0x01, 0x7C, 0x01, 0x74, 0x03, // żŴ (U+017C U+0174)
  0x01, 0x7C, 0x01, 0x76, 0x03, // żŶ (U+017C U+0176)
  0x01, 0x7C, 0x01, 0x78, 0x03, // żŸ (U+017C U+0178)
  0x01, 0x7C, 0x20, 0x18, 0x02, // ż‘ (U+017C U+2018)
  0x01, 0x7C, 0x20, 0x19, 0x02, // ż’ (U+017C U+2019)
  0x01, 0x7C, 0x20, 0x1C, 0x02, // ż“ (U+017C U+201C)
  0x01, 0x7C, 0x20, 0x1D, 0x02, // ż” (U+017C U+201D)
  0x01, 0x7C, 0x21, 0x22, 0x02, // ż™ (U+017C U+2122)
  0x01, 0x7E, 0x00, 0x2A, 0x02, // ž* (U+017E U+002A)
  0x01, 0x7E, 0x00, 0x56, 0x04, // žV (U+017E U+0056)
  0x01, 0x7E, 0x00, 0x57, 0x03, // žW (U+017E U+0057)
  0x01, 0x7E, 0x00, 0x59, 0x03, // žY (U+017E U+0059)
  0x01, 0x7E, 0x00, 0xDD, 0x03, // žÝ (U+017E U+00DD)
  0x01, 0x7E, 0x01, 0x74, 0x03, // žŴ (U+017E U+0174)
  0x01, 0x7E, 0x01, 0x76, 0x03, // žŶ (U+017E U+0176)
  0x01, 0x7E, 0x01, 0x78, 0x03, // žŸ (U+017E U+0178)
  0x01, 0x7E, 0x20, 0x18, 0x02, // ž‘ (U+017E U+2018)
  0x01, 0x7E, 0x20, 0x19, 0x02, // ž’ (U+017E U+2019)
  0x01, 0x7E, 0x20, 0x1C, 0x02, // ž“ (U+017E U+201C)
  0x01, 0x7E, 0x20, 0x1D, 0x02, // ž” (U+017E U+201D)
  0x01, 0x7E, 0x21, 0x22, 0x02, // ž™ (U+017E U+2122)
  0x20, 0x18, 0x00, 0x41, 0x06, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x06, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x06, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x06, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x06, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x06, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x06, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x0D, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x06, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x06, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x06, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x08, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x73, 0x05, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x08, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x08, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x08, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x08, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x08, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x08, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x0D, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF0, 0x01, // ’ð (U+2019 U+00F0)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x08, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x08, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x08, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x5B, 0x05, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x05, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x05, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x05, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x43, 0x02, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x02, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x02, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x02, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x06, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x55, 0x02, // ‚U (U+201A U+0055)
  0x20, 0x1A, 0x00, 0x56, 0x08, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x07, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x06, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x05, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x02, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x02, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xC7, 0x02, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x02, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x02, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x02, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x02, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x02, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x02, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xD9, 0x02, // ‚Ù (U+201A U+00D9)
  0x20, 0x1A, 0x00, 0xDA, 0x02, // ‚Ú (U+201A U+00DA)
  0x20, 0x1A, 0x00, 0xDB, 0x02, // ‚Û (U+201A U+00DB)
  0x20, 0x1A, 0x00, 0xDC, 0x02, // ‚Ü (U+201A U+00DC)
  0x20, 0x1A, 0x00, 0xDD, 0x06, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xFD, 0x02, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x02, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x06, 0x02, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x02, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x02, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x02, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x02, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x02, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x02, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x02, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x02, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x02, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x02, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x02, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x68, 0x02, // ‚Ũ (U+201A U+0168)
  0x20, 0x1A, 0x01, 0x6A, 0x02, // ‚Ū (U+201A U+016A)
  0x20, 0x1A, 0x01, 0x6C, 0x02, // ‚Ŭ (U+201A U+016C)
  0x20, 0x1A, 0x01, 0x6E, 0x02, // ‚Ů (U+201A U+016E)
  0x20, 0x1A, 0x01, 0x70, 0x02, // ‚Ű (U+201A U+0170)
  0x20, 0x1A, 0x01, 0x72, 0x02, // ‚Ų (U+201A U+0172)
  0x20, 0x1A, 0x01, 0x74, 0x07, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x02, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x06, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x02, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x06, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x06, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x06, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x06, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x06, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x06, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x06, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x06, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x0D, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x06, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x06, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x06, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x08, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x73, 0x05, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x08, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x08, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x08, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x08, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x08, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x08, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x0D, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF0, 0x01, // ”ð (U+201D U+00F0)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x08, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x08, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x08, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x5B, 0x05, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x05, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x05, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x05, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x43, 0x02, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x02, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x02, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x02, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x06, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x55, 0x02, // „U (U+201E U+0055)
  0x20, 0x1E, 0x00, 0x56, 0x08, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x07, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x06, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x05, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x02, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x02, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xC7, 0x02, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x02, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x02, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x02, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x02, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x02, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x02, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xD9, 0x02, // „Ù (U+201E U+00D9)
  0x20, 0x1E, 0x00, 0xDA, 0x02, // „Ú (U+201E U+00DA)
  0x20, 0x1E, 0x00, 0xDB, 0x02, // „Û (U+201E U+00DB)
  0x20, 0x1E, 0x00, 0xDC, 0x02, // „Ü (U+201E U+00DC)
  0x20, 0x1E, 0x00, 0xDD, 0x06, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xFD, 0x02, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x02, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x06, 0x02, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x02, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x02, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x02, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x02, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x02, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x02, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x02, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x02, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x02, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x02, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x02, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x68, 0x02, // „Ũ (U+201E U+0168)
  0x20, 0x1E, 0x01, 0x6A, 0x02, // „Ū (U+201E U+016A)
  0x20, 0x1E, 0x01, 0x6C, 0x02, // „Ŭ (U+201E U+016C)
  0x20, 0x1E, 0x01, 0x6E, 0x02, // „Ů (U+201E U+016E)
  0x20, 0x1E, 0x01, 0x70, 0x02, // „Ű (U+201E U+0170)
  0x20, 0x1E, 0x01, 0x72, 0x02, // „Ų (U+201E U+0172)
  0x20, 0x1E, 0x01, 0x74, 0x07, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x02, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x06, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x02, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x06, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x75, 0x09, 0xFA, 0x01, 0x75, 0x0C, 0xF9, 0x0D, 0x76, 0x0E, 0xF9, 0x09, 0x75, 0x01, 0xFA, 0x04,
  0x75, 0x03, 0xFA, 0x76, 0x06, 0xF9, 0x0B, 0x76, 0x08, 0xF9, 0x07, 0x76, 0x0B, 0xF9, 0x03, 0x76,
  0x0D, 0xF0, 0xE7, 0x7F, 0x90, 0xA7, 0x60, 0x2F, 0x90, 0x67, 0x60, 0x5F, 0x90, 0x17, 0x60, 0x7F,
  0x0D, 0x77, 0x09, 0xF0, 0x87, 0x70, 0xCF, 0x04, 0x77, 0x0E, 0xF7, 0x70, 0x1F, 0x0B, 0x77, 0x03,
  0xF0, 0x77, 0x70, 0x6F, 0x03, 0x77, 0x08, 0xE0, 0xE7, 0x71, 0x0B, 0xE0, 0xA7, 0x71, 0x0D, 0xE0,
  0x57, 0x71, 0xF0, 0x17, 0x70, 0x2E, 0x0D, 0x77, 0x10, 0x5E, 0x08, 0x77, 0x10, 0x7E, 0x04, 0x77,
  0x10, 0x9E, 0x77, 0x20, 0xCD, 0x0B, 0x77, 0x20, 0xED, 0x07, 0x77, 0x10, 0x1E, 0x03, 0x77, 0x10,
  0x4D, 0x0E, 0x77, 0x20, 0x6D, 0x0A, 0x77, 0x20, 0x8D, 0x05, 0x77, 0x20, 0xBD, 0x01, 0x77, 0x20,
  0xDC, 0x0C, 0x77, 0x3D, 0x08, 0x77, 0x20, 0x2D, 0x04, 0x77, 0x20, 0x5D, 0x77, 0x30, 0x7C, 0x0B,
  0x77, 0x30, 0xAC, 0x07, 0x77, 0x30, 0xCC, 0x02, 0x77, 0x30, 0xEB, 0x0E, 0x77, 0x30, 0x1C, 0x09,
  0x77, 0x30, 0x4C, 0x05, 0x77, 0x30, 0x6C, 0x01, 0x77, 0x30, 0x8B, 0x0C, 0x80, 0xAD, 0x50, 0x84,
  0x7C, 0xFE, 0xB3, 0x77, 0x10, 0x10, 0xCE, 0x05, 0x77, 0x0B, 0xF0, 0xE0, 0x17, 0x50, 0x5F, 0xA0,
  0x57, 0x50, 0xAF, 0xA0, 0x77, 0x50, 0xEF, 0xA0, 0x67, 0x5F, 0xB0, 0x57, 0x5F, 0xB0, 0x27, 0x50,
  0xDF, 0x90, 0xD7, 0x60, 0x8F, 0x90, 0x57, 0x60, 0x10, 0xDE, 0x07, 0x77, 0x28, 0x48, 0xDF, 0xEA,
  0x37, 0x71,
  // """ (U+0022)
  0x20, 0xBF, 0x90, 0x15, 0x0B, 0xF0, 0xE2, 0x0D, 0xF0, 0xB6, 0x0C, 0xF0, 0xA2, 0x0E, 0xF0, 0x56,
  0x0E, 0xF0, 0x42, 0xF9, 0x7F, 0x0E, 0x20, 0x2F, 0x0A, 0x60, 0x2F, 0x09, 0x20, 0x3F, 0x05, 0x60,
  0x3F, 0x04, 0x20, 0x5E, 0x0E, 0x70, 0x5E, 0x0E, 0x30, 0x7E, 0x0A, 0x70, 0x7E, 0x08, 0x30, 0x8E,
  0x04, 0x70, 0x8E, 0x03, 0x30, 0xAD, 0x0E, 0x71, 0x0A, 0xD0, 0xD4, 0x0B, 0xD0, 0x97, 0x10, 0xCD,
  0x08, 0x40, 0xDD, 0x04, 0x71, 0x0D, 0xD0, 0x24, 0xD0, 0xE7, 0x2D, 0x0C, 0x40, 0x1D, 0x09, 0x71,
  0x01, 0xD0, 0x74, 0x02, 0xD0, 0x47, 0x10, 0x3D, 0x02, 0x40, 0x4C, 0x0E, 0x72, 0x04, 0xC0, 0xC5,
  0x05, 0xC0, 0x87, 0x20, 0x6C, 0x06, 0x50, 0x7C, 0x03, 0x72, 0x08, 0xC0, 0x15, 0x09, 0xB0, 0xD7,
  0x30, 0x9B, 0x0B, 0x60, 0xAB, 0x08, 0x73, 0x0B, 0xB0, 0x66, 0x0C, 0xB0, 0x37, 0x30, 0xDB, 0x01,
  0x60,
  // "#" (U+0023)
  0x77, 0x60, 0xCC, 0x73, 0x03, 0xC0, 0x97, 0x77, 0x01, 0xC0, 0xB7, 0x30, 0x8C, 0x05, 0x77, 0x70,
  0x5C, 0x07, 0x73, 0x0C, 0xC0, 0x17, 0x77, 0x0A, 0xC0, 0x37, 0x20, 0x1C, 0x0B, 0x77, 0x71, 0x0E,
  0xB0, 0xE7, 0x30, 0x5C, 0x07, 0x77, 0x70, 0x3C, 0x0A, 0x73, 0x09, 0xC0, 0x37, 0x77, 0x07, 0xC0,
  0x57, 0x30, 0xDB, 0x0E, 0x77, 0x71, 0x0B, 0xC0, 0x17, 0x20, 0x2C, 0x0A, 0x77, 0x71, 0xC0, 0xC7,
  0x30, 0x7C, 0x05, 0x77, 0x70, 0x4C, 0x08, 0x73, 0x0B, 0xC0, 0x17, 0x77, 0x08, 0xC0, 0x37, 0x3C,
  0x0C, 0x77, 0x71, 0x0D, 0xB0, 0xE7, 0x30, 0x4C, 0x08, 0x77, 0x70, 0x1C, 0x0A, 0x73, 0x08, 0xC0,
  0x37, 0x77, 0x06, 0xC0, 0x67, 0x30, 0xCB, 0x0E, 0x77, 0x71, 0x0A, 0xC0, 0x17, 0x20, 0x1C, 0x0A,
  0x77, 0x71, 0x0E, 0xB0, 0xD7, 0x30, 0x5C, 0x06, 0x77, 0x70, 0x3C, 0x08, 0x73, 0x0A, 0xC0, 0x17,
  0x77, 0x07, 0xC0, 0x47, 0x30, 0xEB, 0x0D, 0x76, 0x0C, 0xFF, 0xFF, 0xF0, 0xA6, 0x0E, 0xFF, 0xFF,
  0xF0, 0x86, 0x80, 0xC0, 0xF0, 0x65, 0x02, 0x80, 0xC0, 0xF0, 0x45, 0x04, 0x80, 0xC0, 0xF0, 0x27,
  0x60, 0x4C, 0x07, 0x73, 0x0B, 0xC0, 0x17, 0x77, 0x08, 0xC0, 0x37, 0x3C, 0x0C, 0x77, 0x71, 0x0D,
  0xB0, 0xE7, 0x30, 0x4C, 0x07, 0x77, 0x70, 0x1C, 0x0A, 0x73, 0x08, 0xC0, 0x37, 0x77, 0x06, 0xC0,
  0x57, 0x30, 0xCB, 0x0E, 0x77, 0x71, 0x0A, 0xC0, 0x17, 0x20, 0x1C, 0x0A, 0x77, 0x71, 0x0E, 0xB0,
  0xC7, 0x30, 0x5C, 0x06, 0x77, 0x70, 0x3C, 0x08, 0x73, 0x09, 0xC0, 0x27, 0x77, 0x07, 0xC0, 0x47,
  0x30, 0xDB, 0x0D, 0x77, 0x71, 0x0C, 0xB0, 0xE7, 0x30, 0x2C, 0x09, 0x77, 0x71, 0xC0, 0xB7, 0x30,
  0x6C, 0x05, 0x77, 0x70, 0x5C, 0x06, 0x73, 0x0A, 0xC0, 0x17, 0x77, 0x09, 0xC0, 0x27, 0x30, 0xEB,
  0x0C, 0x77, 0x71, 0x0D, 0xB0, 0xD7, 0x30, 0x3C, 0x08, 0x77, 0x70, 0x2C, 0x09, 0x73, 0x07, 0xC0,
  0x47, 0x77, 0x06, 0xC0, 0x57, 0x30, 0xCB, 0x0E, 0x77, 0x71, 0x0A, 0xC0, 0x17, 0x3C, 0x0B, 0x77,
  0x71, 0x0E, 0xB0, 0xC7, 0x30, 0x4C, 0x06, 0x77, 0x80, 0xC0, 0xF0, 0x85, 0x02, 0x80, 0xC0, 0xF0,
  0x65, 0x03, 0x80, 0xC0, 0xF0, 0x45, 0x05, 0x80, 0xC0, 0xF0, 0x25, 0x07, 0x80, 0xC0, 0xF7, 0x60,
  0xCB, 0x0E, 0x73, 0x04, 0xC0, 0x77, 0x77, 0x01, 0xC0, 0xA7, 0x30, 0x9C, 0x02, 0x77, 0x70, 0x5C,
  0x06, 0x73, 0x0D, 0xB0, 0xE7, 0x77, 0x10, 0xAC, 0x01, 0x72, 0x02, 0xC0, 0x97, 0x77, 0x10, 0xEB,
  0x0D, 0x73, 0x06, 0xC0, 0x57, 0x77, 0x03, 0xC0, 0x87, 0x30, 0xAC, 0x01, 0x77, 0x70, 0x8C, 0x04,
  0x73, 0x0E, 0xB0, 0xC7, 0x77, 0x10, 0xCB, 0x0E, 0x73, 0x04, 0xC0, 0x77, 0x77, 0x01, 0xC0, 0xA7,
  0x30, 0x8C, 0x03, 0x77, 0x70, 0x6C, 0x06, 0x73, 0x0C, 0xB0, 0xE7, 0x77, 0x10, 0xAC, 0x02, 0x72,
  0x01, 0xC0, 0xA7, 0x77, 0x10, 0xEB, 0x0D, 0x73, 0x05, 0xC0, 0x57, 0x77, 0x04, 0xC0, 0x87, 0x30,
  0xAC, 0x01, 0x77, 0x70, 0x8C, 0x04, 0x73, 0x0E, 0xB0, 0xC7, 0x77, 0x10, 0xDB, 0x0E, 0x73, 0x03,
  0xC0, 0x87, 0x77, 0x02, 0xC0, 0xB7, 0x30, 0x7C, 0x04, 0x77, 0x70, 0x6C, 0x06, 0x73, 0x0C, 0xB0,
  0xE7, 0x77, 0x10, 0xBC, 0x02, 0x72, 0x01, 0xC0, 0xA7, 0x76,
  // "$" (U+0024)
  0x77, 0x76, 0x02, 0xB0, 0xC8, 0x0C, 0x10, 0x05, 0xB0, 0x98, 0x0C, 0x10, 0x07, 0xB0, 0x68, 0x0C,
  0x10, 0x0A, 0xB0, 0x38, 0x0C, 0x10, 0x0D, 0xA0, 0xE8, 0x0C, 0x10, 0x01, 0xB0, 0xB8, 0x0C, 0x10,
  0x04, 0xB0, 0x97, 0x77, 0x73, 0x84, 0x15, 0x9B, 0xDE, 0xE8, 0x2D, 0xA6, 0x17, 0x77, 0x30, 0x50,
  0xBF, 0xFA, 0x0B, 0x03, 0x77, 0x60, 0x40, 0xCF, 0xFE, 0x08, 0x77, 0x40, 0x8F, 0xA0, 0xEB, 0x0E,
  0xFA, 0x0A, 0x77, 0x20, 0xAF, 0x82, 0xE7, 0x18, 0xB8, 0x17, 0x2B, 0xF9, 0x07, 0x77, 0x0A, 0xF0,
  0xA0, 0x12, 0x0B, 0xB0, 0x32, 0x0A, 0xF0, 0xE7, 0x60, 0x6F, 0x09, 0x40, 0xEB, 0x40, 0xEF, 0x05,
  0x74, 0x02, 0xF0, 0xB4, 0x01, 0xB0, 0xD4, 0x07, 0xF0, 0x87, 0x40, 0x9F, 0x02, 0x40, 0x5B, 0x09,
  0x40, 0x1F, 0x09, 0x73, 0x01, 0xF0, 0x95, 0x08, 0xB0, 0x65, 0x0C, 0xE0, 0x87, 0x30, 0x6F, 0x03,
  0x50, 0xBB, 0x03, 0x50, 0x9E, 0x05, 0x73, 0x0A, 0xE0, 0xE6, 0x0E, 0xB6, 0x07, 0xD0, 0xE7, 0x40,
  0xDE, 0x0A, 0x50, 0x1B, 0x0C, 0x60, 0x5D, 0x05, 0x73, 0x01, 0xF0, 0x85, 0x05, 0xB0, 0x96, 0x04,
  0xC0, 0x67, 0x40, 0x2F, 0x07, 0x50, 0x8B, 0x06, 0x68, 0x34, 0xEC, 0x81, 0x75, 0x03, 0xF0, 0x75,
  0x0B, 0xB0, 0x27, 0x77, 0x20, 0x4F, 0x07, 0x50, 0xEA, 0x0E, 0x77, 0x73, 0x03, 0xF0, 0x94, 0x01,
  0xB0, 0xB7, 0x77, 0x30, 0x2F, 0x0D, 0x40, 0x5B, 0x08, 0x77, 0x73, 0x01, 0xF9, 0x04, 0x30, 0x8B,
  0x05, 0x77, 0x74, 0x0D, 0xF0, 0xC3, 0x0B, 0xB0, 0x27, 0x77, 0x40, 0x9F, 0x90, 0x72, 0x0E, 0xA0,
  0xE7, 0x77, 0x50, 0x3F, 0xA0, 0x60, 0x1B, 0x0B, 0x77, 0x76, 0x0C, 0xFA, 0x0C, 0xB0, 0x87, 0x77,
  0x60, 0x3F, 0xE0, 0x57, 0x77, 0x70, 0x7F, 0xD0, 0x47, 0x77, 0x71, 0x0A, 0xFD, 0x09, 0x77, 0x77,
  0x10, 0xAF, 0xD0, 0xD0, 0x47, 0x77, 0x70, 0x9F, 0xE0, 0x97, 0x77, 0x70, 0x50, 0xEF, 0xD0, 0xC0,
  0x17, 0x77, 0x60, 0x20, 0xBF, 0xD0, 0xD0, 0x27, 0x77, 0x70, 0x7F, 0xD0, 0xD0, 0x17, 0x77, 0x60,
  0x8F, 0xE0, 0xD7, 0x77, 0x60, 0xBB, 0x0B, 0xFB, 0x08, 0x77, 0x75, 0x0E, 0xB1, 0x04, 0x0E, 0xFA,
  0x02, 0x77, 0x73, 0x02, 0xB0, 0xC2, 0x02, 0x0E, 0xF9, 0x08, 0x77, 0x73, 0x05, 0xB0, 0x93, 0x03,
  0xF9, 0x0D, 0x77, 0x73, 0x08, 0xB0, 0x54, 0x08, 0xF9, 0x02, 0x74, 0x03, 0x02, 0x73, 0x0B, 0xB0,
  0x24, 0x01, 0xF9, 0x04, 0x72, 0x82, 0x8E, 0xF7, 0x73, 0x0E, 0xA0, 0xE6, 0x0B, 0xF0, 0x57, 0x01,
  0x0C, 0xB0, 0x77, 0x20, 0x2B, 0x0B, 0x60, 0x8F, 0x06, 0x70, 0xCC, 0x07, 0x72, 0x06, 0xB0, 0x86,
  0x06, 0xF0, 0x56, 0x06, 0xD0, 0x97, 0x20, 0x9B, 0x05, 0x60, 0x6F, 0x04, 0x60, 0xDD, 0x0B, 0x72,
  0x0C, 0xB0, 0x26, 0x07, 0xF0, 0x35, 0x01, 0xE0, 0xE7, 0x2B, 0x0E, 0x70, 0x9F, 0x60, 0x3F, 0x02,
  0x70, 0x3B, 0x0B, 0x70, 0xCE, 0x0C, 0x60, 0x4F, 0x06, 0x70, 0x6B, 0x08, 0x60, 0x1F, 0x07, 0x60,
  0x3F, 0x0C, 0x70, 0x9B, 0x05, 0x60, 0x7F, 0x02, 0x60, 0x1F, 0x90, 0x36, 0x0D, 0xB0, 0x26, 0x0D,
  0xE0, 0xA7, 0x10, 0xDF, 0x0C, 0x6B, 0x0E, 0x60, 0x9F, 0x02, 0x71, 0x08, 0xF9, 0x06, 0x40, 0x3B,
  0x0B, 0x50, 0x5F, 0x06, 0x72, 0x01, 0xFA, 0x05, 0x30, 0x7B, 0x08, 0x40, 0x5F, 0x0A, 0x74, 0x08,
  0xFA, 0x08, 0x20, 0xAB, 0x05, 0x20, 0x20, 0xAF, 0x0B, 0x76, 0x0B, 0xFA, 0x81, 0xD8, 0xDB, 0x81,
  0x56, 0xBF, 0x90, 0x97, 0x71, 0x0B, 0xFF, 0xFA, 0x0E, 0x06, 0x77, 0x30, 0x8F, 0xFF, 0x09, 0x01,
  0x77, 0x50, 0x20, 0x9F, 0xFA, 0x81, 0xD8, 0x17, 0x77, 0x38, 0x34, 0x7A, 0xBC, 0xC8, 0x4C, 0xBB,
  0x86, 0x27, 0x77, 0x74, 0x0E, 0xA0, 0xE8, 0x0C, 0x10, 0x02, 0xB0, 0xB8, 0x0C, 0x10, 0x05, 0xB0,
  0x88, 0x0C, 0x10, 0x08, 0xB0, 0x58, 0x0C, 0x10, 0x0C, 0xB0, 0x18, 0x0C, 0x10, 0xB0, 0xE8, 0x0C,
  0x10, 0x03, 0xB0, 0xB8, 0x0C, 0x10, 0x06, 0xB0, 0x78, 0x0C, 0x10, 0x09, 0xB0, 0x48, 0x0C, 0x10,
  0x0D, 0xB0, 0x18, 0x0C, 0x10, 0x80, 0x07, 0x77, 0x75,
  // "%" (U+0025)
  0x76, 0x87, 0x59, 0xCE, 0xFE, 0xC9, 0x48, 0x0D, 0x70, 0x06, 0x0D, 0xFA, 0x0C, 0x03, 0x77, 0x72,
  0x03, 0xD0, 0x47, 0x73, 0x01, 0x0B, 0xFE, 0x04, 0x77, 0x71, 0x0D, 0xC0, 0x97, 0x73, 0x02, 0x0D,
  0xFF, 0x0E, 0x02, 0x77, 0x60, 0x7C, 0x0E, 0x01, 0x77, 0x20, 0x20, 0xED, 0x84, 0xD5, 0x10, 0x4D,
  0xD0, 0xB7, 0x75, 0x02, 0xD0, 0x57, 0x72, 0x01, 0x0D, 0xD0, 0xB5, 0x03, 0xE0, 0x37, 0x74, 0x0B,
  0xC0, 0xB7, 0x73, 0x0A, 0xD0, 0xC7, 0x0B, 0xD0, 0x97, 0x73, 0x06, 0xD0, 0x27, 0x72, 0x05, 0xE0,
  0x27, 0x06, 0xD0, 0xE7, 0x72, 0x01, 0x0E, 0xC0, 0x77, 0x73, 0x0E, 0xD0, 0x77, 0x10, 0x3E, 0x03,
  0x77, 0x10, 0xAC, 0x0C, 0x77, 0x30, 0x8D, 0x0E, 0x72, 0x02, 0xE0, 0x67, 0x70, 0x5D, 0x03, 0x77,
  0x20, 0x10, 0xED, 0x07, 0x73, 0xE0, 0x87, 0x70, 0xDC, 0x09, 0x77, 0x30, 0x7E, 0x01, 0x73, 0xE0,
  0x97, 0x60, 0x9C, 0x0D, 0x77, 0x40, 0xDD, 0x0A, 0x74, 0xE0, 0xA7, 0x50, 0x3D, 0x04, 0x77, 0x30,
  0x4E, 0x05, 0x73, 0x01, 0xE0, 0xB7, 0x50, 0xDC, 0x0A, 0x77, 0x40, 0xAE, 0x01, 0x73, 0x01, 0xE0,
  0xB7, 0x40, 0x7C, 0x0E, 0x01, 0x77, 0x40, 0xED, 0x0B, 0x74, 0x03, 0xE0, 0xA7, 0x30, 0x2D, 0x06,
  0x77, 0x40, 0x4E, 0x07, 0x74, 0x05, 0xE0, 0x87, 0x30, 0xCC, 0x0C, 0x77, 0x50, 0x8E, 0x03, 0x74,
  0x07, 0xE0, 0x77, 0x20, 0x6D, 0x02, 0x77, 0x50, 0xBE, 0x75, 0x09, 0xE0, 0x47, 0x10, 0x10, 0xEC,
  0x08, 0x77, 0x60, 0xED, 0x0C, 0x75, 0x0B, 0xE0, 0x17, 0x10, 0xAC, 0x0D, 0x77, 0x60, 0x2E, 0x08,
  0x75, 0x0E, 0xD0, 0xE7, 0x10, 0x5D, 0x04, 0x77, 0x60, 0x4E, 0x06, 0x74, 0x02, 0xE0, 0xA7, 0x01,
  0x0E, 0xC0, 0x97, 0x77, 0x06, 0xE0, 0x47, 0x40, 0x5E, 0x06, 0x70, 0x9C, 0x0E, 0x01, 0x77, 0x70,
  0x8E, 0x01, 0x74, 0x09, 0xE0, 0x26, 0x03, 0xD0, 0x57, 0x77, 0x10, 0x9E, 0x75, 0x0E, 0xD0, 0xD7,
  0x0D, 0xC0, 0xB7, 0x77, 0x20, 0xAD, 0x0E, 0x74, 0x03, 0xE0, 0x76, 0x08, 0xD0, 0x27, 0x77, 0x20,
  0xAD, 0x0D, 0x74, 0x08, 0xE0, 0x25, 0x02, 0xD0, 0x77, 0x18, 0x90, 0x16, 0xAD, 0xEF, 0xDC, 0x83,
  0x60, 0xAD, 0x0C, 0x74, 0x0D, 0xD0, 0xB6, 0x0C, 0xC0, 0xC7, 0x81, 0x19, 0xEF, 0xA0, 0xA0, 0x14,
  0x09, 0xD0, 0xC7, 0x30, 0x4E, 0x04, 0x50, 0x6D, 0x03, 0x60, 0x40, 0xDF, 0xD0, 0xD0, 0x13, 0x08,
  0xD0, 0xC7, 0x30, 0xAD, 0x0C, 0x50, 0x10, 0xEC, 0x09, 0x60, 0x5F, 0xF9, 0x0C, 0x30, 0x6D, 0x0E,
  0x72, 0x02, 0xE0, 0x45, 0x0A, 0xC0, 0xD6, 0x05, 0xE8, 0x3B, 0x40, 0x17, 0xE0, 0x62, 0x03, 0xE7,
  0x20, 0xBD, 0x0B, 0x50, 0x5D, 0x05, 0x50, 0x4E, 0x07, 0x50, 0x7D, 0x0D, 0x3E, 0x03, 0x70, 0x5D,
  0x0E, 0x02, 0x40, 0x10, 0xEC, 0x0A, 0x50, 0x10, 0xED, 0x09, 0x70, 0xED, 0x04, 0x20, 0xAD, 0x07,
  0x60, 0x10, 0xED, 0x06, 0x50, 0x9C, 0x0E, 0x01, 0x50, 0xAD, 0x0D, 0x71, 0x0A, 0xD0, 0x92, 0x05,
  0xD0, 0xE5, 0x01, 0x0D, 0xD0, 0x95, 0x03, 0xD0, 0x65, 0x04, 0xE0, 0x37, 0x10, 0x7D, 0x0D, 0x30,
  0xCD, 0x84, 0xC3, 0x01, 0x7E, 0xD0, 0xB6, 0x0D, 0xC0, 0xC6, 0x0C, 0xD0, 0xA7, 0x20, 0x5E, 0x30,
  0x3F, 0xF9, 0x0A, 0x60, 0x8D, 0x02, 0x50, 0x4E, 0x03, 0x72, 0x04, 0xE0, 0x33, 0x04, 0xFE, 0x08,
  0x60, 0x2D, 0x08, 0x60, 0xBD, 0x0C, 0x73, 0x04, 0xE0, 0x44, 0x03, 0x0C, 0xFA, 0x0B, 0x03, 0x70,
  0xCC, 0x0D, 0x60, 0x2E, 0x06, 0x73, 0x04, 0xE0, 0x56, 0x87, 0x5A, 0xDE, 0xED, 0xB7, 0x37, 0x10,
  0x6D, 0x04, 0x60, 0x8E, 0x01, 0x73, 0x05, 0xE0, 0x67, 0x77, 0x10, 0x10, 0xEC, 0x09, 0x70, 0xDD,
  0x0B, 0x74, 0x06, 0xE0, 0x57, 0x77, 0x10, 0xBC, 0x0E, 0x01, 0x60, 0x3E, 0x06, 0x74, 0x07, 0xE0,
  0x47, 0x77, 0x05, 0xD0, 0x57, 0x08, 0xE0, 0x27, 0x40, 0x9E, 0x03, 0x77, 0x60, 0x10, 0xEC, 0x0B,
  0x71, 0x0C, 0xD0, 0xD7, 0x50, 0xBE, 0x01, 0x77, 0x60, 0x9D, 0x02, 0x71, 0xE0, 0xA7, 0x50, 0xDD,
  0x0E, 0x77, 0x60, 0x4D, 0x07, 0x71, 0x03, 0xE0, 0x67, 0x5E, 0x0C, 0x77, 0x60, 0xDC, 0x0C, 0x72,
  0x06, 0xE0, 0x37, 0x40, 0x4E, 0x08, 0x77, 0x50, 0x8D, 0x03, 0x72, 0x08, 0xE7, 0x50, 0x7E, 0x05,
  0x77, 0x40, 0x2D, 0x09, 0x73, 0x0A, 0xD0, 0xE7, 0x50, 0xAE, 0x01, 0x77, 0x40, 0xCC, 0x0D, 0x74,
  0x0C, 0xD0, 0xB7, 0x50, 0xED, 0x0C, 0x77, 0x40, 0x7D, 0x05, 0x74, 0x0D, 0xD0, 0x97, 0x40, 0x3E,
  0x07, 0x77, 0x30, 0x10, 0xEC, 0x0A, 0x75, 0x0E, 0xD0, 0x87, 0x40, 0x8E, 0x02, 0x77, 0x30, 0xBC,
  0x0E, 0x01, 0x75, 0x0E, 0xD0, 0x77, 0x40, 0xCD, 0x0C, 0x77, 0x30, 0x5D, 0x06, 0x76, 0x0D, 0xD0,
  0x77, 0x30, 0x2E, 0x06, 0x77, 0x20, 0x10, 0xEC, 0x0C, 0x77, 0x0D, 0xD0, 0x77, 0x30, 0x8D, 0x0E,
  0x77, 0x30, 0x9D, 0x02, 0x77, 0x0C, 0xD0, 0x77, 0x30, 0xED, 0x07, 0x77, 0x20, 0x4D, 0x08, 0x77,
  0x10, 0x9D, 0x08, 0x72, 0x06, 0xD0, 0xE0, 0x17, 0x72, 0x0D, 0xC0, 0xD7, 0x72, 0x07, 0xD0, 0xA7,
  0x20, 0xED, 0x06, 0x77, 0x20, 0x8D, 0x04, 0x77, 0x20, 0x4D, 0x0D, 0x71, 0x09, 0xD0, 0xC7, 0x72,
  0x03, 0xD0, 0x97, 0x74, 0x0E, 0xD0, 0x26, 0x04, 0xE0, 0x27, 0x72, 0x0C, 0xC0, 0xE0, 0x17, 0x74,
  0x08, 0xD0, 0xA5, 0x04, 0x0E, 0xD0, 0x57, 0x72, 0x07, 0xD0, 0x57, 0x75, 0x01, 0x0E, 0xD8, 0x39,
  0x10, 0x28, 0xE0, 0x77, 0x72, 0x02, 0x0E, 0xC0, 0xB7, 0x77, 0x06, 0xFF, 0x90, 0x77, 0x73, 0x0B,
  0xD0, 0x27, 0x77, 0x10, 0x8F, 0xD0, 0xE0, 0x57, 0x73, 0x05, 0xD0, 0x77, 0x77, 0x30, 0x50, 0xEF,
  0xA0, 0x90, 0x18, 0x0D, 0x60, 0x89, 0x01, 0x6B, 0xDF, 0xED, 0xA6, 0x17, 0x60,
  // "&" (U+0026)
  0x77, 0x73, 0x89, 0x32, 0x69, 0xCD, 0xEF, 0xED, 0xCA, 0x62, 0x80, 0xC5, 0x08, 0x11, 0x8E, 0xFE,
  0x0B, 0x04, 0x80, 0xC2, 0x00, 0x9F, 0xFC, 0x09, 0x77, 0x77, 0x70, 0x20, 0xDF, 0xFE, 0x0B, 0x77,
  0x77, 0x50, 0x30, 0xEF, 0x98, 0x4C, 0x87, 0x68, 0xCF, 0x90, 0x97, 0x77, 0x73, 0x02, 0x0E, 0xF0,
  0xB0, 0x26, 0x04, 0x0D, 0xF0, 0x47, 0x77, 0x72, 0x0C, 0xF0, 0x97, 0x20, 0x20, 0xEE, 0x0C, 0x77,
  0x77, 0x10, 0x5F, 0x0B, 0x74, 0x06, 0xF0, 0x27, 0x77, 0x70, 0xDF, 0x02, 0x75, 0x0E, 0xE0, 0x77,
  0x77, 0x60, 0x3F, 0x0B, 0x76, 0x0A, 0xE0, 0x97, 0x77, 0x60, 0x8F, 0x06, 0x76, 0x07, 0xE0, 0xB7,
  0x77, 0x60, 0xBF, 0x03, 0x76, 0x06, 0xE0, 0xC7, 0x77, 0x60, 0xEF, 0x77, 0x06, 0xE0, 0xB7, 0x77,
  0x6F, 0x0E, 0x77, 0x07, 0xE0, 0xA7, 0x77, 0x50, 0x1F, 0x0D, 0x77, 0x09, 0xE0, 0x87, 0x77, 0x50,
  0x2F, 0x0D, 0x77, 0x0C, 0xE0, 0x57, 0x77, 0x50, 0x2F, 0x0E, 0x76, 0x01, 0xF0, 0x17, 0x77, 0x50,
  0x1F, 0x97, 0x60, 0x7E, 0x0B, 0x77, 0x77, 0xF9, 0x01, 0x74, 0x01, 0x0E, 0xE0, 0x47, 0x77, 0x70,
  0xDF, 0x04, 0x74, 0x0A, 0xE0, 0xB7, 0x77, 0x71, 0x0A, 0xF0, 0x77, 0x30, 0x8E, 0x0E, 0x01, 0x77,
  0x77, 0x10, 0x7F, 0x0C, 0x72, 0x0A, 0xE0, 0xE0, 0x37, 0x77, 0x72, 0x03, 0xF9, 0x01, 0x60, 0x30,
  0xDE, 0x0D, 0x03, 0x77, 0x77, 0x40, 0xDF, 0x07, 0x40, 0x10, 0x9F, 0x0B, 0x01, 0x77, 0x77, 0x50,
  0x8F, 0x0D, 0x30, 0x70, 0xEE, 0x0E, 0x06, 0x77, 0x77, 0x70, 0x3F, 0x98, 0x15, 0x7E, 0xF0, 0x80,
  0x18, 0x0C, 0x10, 0x0B, 0xFF, 0x90, 0x90, 0x18, 0x0C, 0x30, 0x05, 0xFE, 0x09, 0x02, 0x73, 0x05,
  0xFE, 0x0B, 0x77, 0x20, 0x2F, 0xB8, 0x1E, 0x81, 0x75, 0x09, 0xFE, 0x08, 0x77, 0x02, 0x09, 0xFB,
  0x0E, 0x77, 0x10, 0xCF, 0xE0, 0x57, 0x50, 0x20, 0xAF, 0xE0, 0x57, 0x70, 0xEF, 0xE0, 0x27, 0x40,
  0x8F, 0xF9, 0x0D, 0x76, 0x03, 0xF9, 0x82, 0xE9, 0x52, 0x75, 0x05, 0x0E, 0xF0, 0xE0, 0xCF, 0x90,
  0x87, 0x50, 0x6F, 0x07, 0x77, 0x01, 0x0B, 0xF9, 0x82, 0xA1, 0x1E, 0xF9, 0x02, 0x74, 0x0A, 0xE0,
  0x47, 0x70, 0x30, 0xEF, 0x0E, 0x05, 0x30, 0x6F, 0x90, 0xA7, 0x40, 0xED, 0x07, 0x77, 0x04, 0xF9,
  0x0B, 0x01, 0x50, 0xCF, 0x90, 0x47, 0x20, 0x3D, 0x0C, 0x77, 0x04, 0xF9, 0x09, 0x70, 0x3F, 0x90,
  0xC7, 0x20, 0x7D, 0x04, 0x76, 0x02, 0x0E, 0xF0, 0x97, 0x20, 0xAF, 0x90, 0x67, 0x10, 0xBC, 0x0C,
  0x77, 0x0C, 0xF0, 0xB7, 0x30, 0x10, 0xEF, 0x0E, 0x01, 0x60, 0x1D, 0x05, 0x76, 0x07, 0xF0, 0xE0,
  0x17, 0x40, 0x7F, 0x90, 0x86, 0x06, 0xC0, 0xD7, 0x60, 0x10, 0xEF, 0x06, 0x76, 0x0D, 0xF9, 0x02,
  0x50, 0xBC, 0x06, 0x76, 0x07, 0xF0, 0xD7, 0x70, 0x4F, 0x90, 0xB4, 0x01, 0xC0, 0xE7, 0x70, 0xDF,
  0x08, 0x77, 0x10, 0xAF, 0x90, 0x43, 0x06, 0xC0, 0x87, 0x60, 0x2F, 0x90, 0x37, 0x71, 0x02, 0xF9,
  0x0D, 0x30, 0xCC, 0x01, 0x76, 0x06, 0xF9, 0x77, 0x30, 0x7F, 0x98, 0x17, 0x04, 0xC0, 0x97, 0x70,
  0x8F, 0x0C, 0x77, 0x40, 0xDF, 0x81, 0xE1, 0xAC, 0x02, 0x77, 0x0B, 0xF0, 0xA7, 0x74, 0x05, 0xF9,
  0x0B, 0xC0, 0xA7, 0x71, 0x0C, 0xF0, 0x97, 0x75, 0x0B, 0xFD, 0x02, 0x77, 0x10, 0xDF, 0x08, 0x77,
  0x50, 0x2F, 0xC0, 0x97, 0x72, 0x0E, 0xF0, 0x87, 0x76, 0x08, 0xFA, 0x0E, 0x01, 0x77, 0x20, 0xEF,
  0x08, 0x77, 0x70, 0xDF, 0x90, 0x87, 0x73, 0x0D, 0xF0, 0x97, 0x77, 0x05, 0xF9, 0x0D, 0x77, 0x30,
  0xBF, 0x0C, 0x77, 0x71, 0x0B, 0xF9, 0x08, 0x77, 0x20, 0x9F, 0x97, 0x77, 0x10, 0x5F, 0xA0, 0x27,
  0x71, 0x05, 0xF9, 0x05, 0x77, 0x60, 0x20, 0xEF, 0xA0, 0xC7, 0x71, 0x01, 0xF9, 0x0B, 0x77, 0x50,
  0x10, 0xDF, 0xC0, 0x67, 0x71, 0x0B, 0xF9, 0x03, 0x77, 0x30, 0x20, 0xDF, 0xD0, 0xE0, 0x17, 0x70,
  0x5F, 0x90, 0xD7, 0x72, 0x04, 0x0E, 0xC0, 0xD0, 0xAF, 0x90, 0xB7, 0x71, 0x0C, 0xF9, 0x0B, 0x77,
  0x09, 0xD8, 0x2E, 0x21, 0xEF, 0x90, 0x77, 0x70, 0x4F, 0xA0, 0xC0, 0x27, 0x30, 0x70, 0xED, 0x0D,
  0x02, 0x20, 0x7F, 0xA0, 0x87, 0x70, 0x7F, 0xB8, 0x1A, 0x52, 0x28, 0x31, 0x36, 0xAE, 0xE0, 0xD0,
  0x14, 0x0E, 0xFA, 0x82, 0xD7, 0x31, 0x74, 0x09, 0xFF, 0xFB, 0x0A, 0x60, 0x6F, 0xF0, 0x97, 0x30,
  0x8F, 0xFF, 0x0E, 0x06, 0x71, 0x0D, 0xFE, 0x05, 0x74, 0x04, 0x0D, 0xFF, 0xC0, 0x90, 0x17, 0x20,
  0x5F, 0xE0, 0x27, 0x60, 0x60, 0xDF, 0xE8, 0x1E, 0x92, 0x75, 0x0C, 0xFC, 0x0E, 0x77, 0x28, 0x93,
  0x26, 0x9C, 0xDE, 0xFE, 0xEC, 0xA7, 0x37, 0x77, 0x76,
  // "'" (U+0027)
  0x20, 0xCF, 0x0D, 0x20, 0xEF, 0x08, 0x2F, 0x98, 0x13, 0x01, 0xF0, 0xD2, 0x03, 0xF0, 0x82, 0x04,
  0xF0, 0x22, 0x06, 0xE0, 0xD3, 0x07, 0xE0, 0x73, 0x09, 0xE0, 0x23, 0x0B, 0xD0, 0xC4, 0x0C, 0xD0,
  0x74, 0x0E, 0xD0, 0x24, 0xD0, 0xC4, 0x01, 0xD0, 0x74, 0x03, 0xD0, 0x24, 0x04, 0xC0, 0xC5, 0x06,
  0xC0, 0x75, 0x07, 0xC0, 0x15, 0x09, 0xB0, 0xC6, 0x0A, 0xB0, 0x66, 0x0C, 0xB0, 0x16,
  // "(" (U+0028)
  0x77, 0x77, 0x30, 0x17, 0x77, 0x78, 0x23, 0x9E, 0x17, 0x77, 0x50, 0x40, 0xCA, 0x0D, 0x77, 0x74,
  0x03, 0x0C, 0xC0, 0x97, 0x77, 0x20, 0x10, 0x9E, 0x04, 0x77, 0x71, 0x04, 0x0D, 0xD0, 0xD0, 0x37,
  0x77, 0x10, 0x8E, 0x0A, 0x77, 0x72, 0x0A, 0xE0, 0x77, 0x77, 0x10, 0x10, 0xCE, 0x06, 0x77, 0x71,
  0x01, 0x0C, 0xE0, 0x67, 0x77, 0x20, 0xCE, 0x07, 0x77, 0x72, 0x0B, 0xE0, 0xA7, 0x77, 0x20, 0x9E,
  0x0C, 0x77, 0x72, 0x06, 0xE0, 0xE0, 0x27, 0x77, 0x10, 0x4F, 0x06, 0x77, 0x71, 0x01, 0x0D, 0xE0,
  0xB7, 0x77, 0x20, 0x9F, 0x02, 0x77, 0x71, 0x04, 0xF0, 0x87, 0x77, 0x20, 0xDE, 0x0E, 0x77, 0x72,
  0x07, 0xF0, 0x67, 0x77, 0x10, 0x10, 0xEE, 0x0D, 0x77, 0x72, 0x09, 0xF0, 0x67, 0x77, 0x10, 0x2F,
  0x0E, 0x77, 0x72, 0x09, 0xF0, 0x87, 0x77, 0x10, 0x1F, 0x90, 0x27, 0x77, 0x10, 0x8F, 0x0B, 0x77,
  0x72, 0x0E, 0xF0, 0x67, 0x77, 0x10, 0x5F, 0x97, 0x77, 0x20, 0xBF, 0x0A, 0x77, 0x71, 0x01, 0xF9,
  0x04, 0x77, 0x71, 0x07, 0xF0, 0xE7, 0x77, 0x20, 0xCF, 0x0A, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x77,
  0x71, 0x06, 0xF9, 0x01, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x20, 0xEF, 0x08, 0x77, 0x71, 0x03,
  0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x01, 0x77, 0x71, 0x0A, 0xF0, 0xD7, 0x77, 0x20, 0xDF, 0x09,
  0x77, 0x72, 0xF9, 0x06, 0x77, 0x71, 0x03, 0xF9, 0x03, 0x77, 0x71, 0x06, 0xF9, 0x77, 0x72, 0x08,
  0xF0, 0xD7, 0x77, 0x20, 0xAF, 0x0B, 0x77, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xEF, 0x06, 0x77,
  0x72, 0xF9, 0x04, 0x77, 0x71, 0x01, 0xF9, 0x02, 0x77, 0x71, 0x02, 0xF9, 0x01, 0x77, 0x71, 0x03,
  0xF9, 0x77, 0x72, 0x03, 0xF0, 0xE7, 0x77, 0x20, 0x4F, 0x0D, 0x77, 0x72, 0x04, 0xF0, 0xC7, 0x77,
  0x20, 0x4F, 0x0B, 0x77, 0x72, 0x03, 0xF0, 0xB7, 0x77, 0x20, 0x2F, 0x0B, 0x77, 0x72, 0x02, 0xF0,
  0xB7, 0x77, 0x3F, 0x0C, 0x77, 0x73, 0x0E, 0xE0, 0xC7, 0x77, 0x30, 0xBE, 0x0D, 0x77, 0x73, 0x09,
  0xF7, 0x77, 0x30, 0x6F, 0x01, 0x77, 0x72, 0x02, 0xF0, 0x37, 0x77, 0x30, 0xEE, 0x06, 0x77, 0x73,
  0x0A, 0xE0, 0x97, 0x77, 0x30, 0x5E, 0x0C, 0x77, 0x74, 0x0E, 0xE7, 0x77, 0x40, 0x9E, 0x05, 0x77,
  0x73, 0x03, 0xE0, 0xB7, 0x77, 0x40, 0xBE, 0x01, 0x77, 0x73, 0x03, 0xE0, 0x77, 0x77, 0x40, 0xAD,
  0x0E, 0x01, 0x77, 0x73, 0x01, 0x0E, 0xD0, 0x97, 0x77, 0x40, 0x3E, 0x05, 0x77, 0x74, 0x06, 0xD0,
  0xE0, 0x37, 0x77, 0x40, 0x6D, 0x0E, 0x01, 0x77, 0x74, 0x04, 0x0E, 0xB0, 0xE7, 0x77, 0x60, 0x20,
  0xCA, 0x0B, 0x77, 0x77, 0x18, 0x16, 0xE7, 0x77, 0x77, 0x20, 0x01, 0x77, 0x30,
  // ")" (U+0029)
  0x77, 0x30, 0x37, 0x77, 0x71, 0x82, 0x4F, 0xA1, 0x77, 0x76, 0x07, 0xA0, 0xE0, 0x67, 0x77, 0x50,
  0xBC, 0x09, 0x77, 0x74, 0x0B, 0xD0, 0xB7, 0x77, 0x30, 0x10, 0xDD, 0x0A, 0x77, 0x73, 0x02, 0x0E,
  0xD0, 0x87, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x0C, 0xD0, 0xD7, 0x77, 0x30, 0x4E, 0x07, 0x77,
  0x73, 0x0D, 0xD0, 0xE7, 0x77, 0x30, 0x8E, 0x06, 0x77, 0x72, 0x02, 0xE0, 0xC7, 0x77, 0x30, 0xDE,
  0x02, 0x77, 0x72, 0x09, 0xE0, 0x87, 0x77, 0x20, 0x6E, 0x0D, 0x77, 0x72, 0x02, 0xF0, 0x17, 0x77,
  0x2F, 0x05, 0x77, 0x72, 0x0D, 0xE0, 0x97, 0x77, 0x20, 0xBE, 0x0B, 0x77, 0x72, 0x0A, 0xE0, 0xE7,
  0x77, 0x20, 0x9F, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x77, 0x10, 0x7F, 0x04, 0x77, 0x71, 0x07, 0xF0,
  0x57, 0x77, 0x10, 0x7F, 0x05, 0x77, 0x71, 0x07, 0xF0, 0x67, 0x77, 0x10, 0x8F, 0x06, 0x77, 0x71,
  0x09, 0xF0, 0x67, 0x77, 0x10, 0xBF, 0x05, 0x77, 0x71, 0x0C, 0xF0, 0x57, 0x77, 0x10, 0xEF, 0x04,
  0x77, 0x71, 0xF9, 0x03, 0x77, 0x70, 0x2F, 0x90, 0x27, 0x77, 0x04, 0xF9, 0x77, 0x71, 0x06, 0xF0,
  0xE7, 0x77, 0x10, 0x9F, 0x0C, 0x77, 0x71, 0x0B, 0xF0, 0xA7, 0x77, 0x10, 0xDF, 0x07, 0x77, 0x70,
  0x1F, 0x90, 0x57, 0x77, 0x04, 0xF9, 0x02, 0x77, 0x70, 0x7F, 0x0E, 0x77, 0x71, 0x0A, 0xF0, 0xB7,
  0x77, 0x10, 0xEF, 0x08, 0x77, 0x70, 0x1F, 0x90, 0x47, 0x77, 0x05, 0xF9, 0x77, 0x71, 0x09, 0xF0,
  0xC7, 0x77, 0x10, 0xDF, 0x08, 0x77, 0x70, 0x2F, 0x90, 0x37, 0x77, 0x07, 0xF0, 0xD7, 0x77, 0x10,
  0xCF, 0x08, 0x77, 0x70, 0x1F, 0x90, 0x37, 0x77, 0x07, 0xF0, 0xC7, 0x77, 0x10, 0xCF, 0x06, 0x77,
  0x70, 0x3F, 0x90, 0x17, 0x77, 0x09, 0xF0, 0x97, 0x77, 0x10, 0xEF, 0x02, 0x77, 0x70, 0x6F, 0x0A,
  0x77, 0x71, 0x0D, 0xF0, 0x37, 0x77, 0x05, 0xF0, 0xB7, 0x77, 0x10, 0xCF, 0x02, 0x77, 0x70, 0x5F,
  0x09, 0x77, 0x71, 0x0D, 0xE0, 0xE0, 0x17, 0x77, 0x06, 0xF0, 0x67, 0x77, 0x01, 0x0E, 0xE0, 0xB7,
  0x77, 0x10, 0xAE, 0x0E, 0x01, 0x77, 0x70, 0x4F, 0x05, 0x77, 0x70, 0x10, 0xEE, 0x08, 0x77, 0x71,
  0x0B, 0xE0, 0xB7, 0x77, 0x10, 0x8E, 0x0D, 0x01, 0x77, 0x70, 0x5E, 0x0D, 0x01, 0x77, 0x70, 0x4E,
  0x0D, 0x01, 0x77, 0x70, 0x4E, 0x0D, 0x02, 0x77, 0x70, 0x6E, 0x0B, 0x01, 0x77, 0x70, 0x8E, 0x09,
  0x77, 0x70, 0x30, 0xCD, 0x0E, 0x05, 0x77, 0x70, 0x2E, 0x0B, 0x01, 0x77, 0x71, 0x06, 0xC0, 0xC0,
  0x47, 0x77, 0x30, 0xAA, 0x0D, 0x05, 0x77, 0x75, 0x81, 0xD9, 0x37, 0x77, 0x70,
  // "*" (U+002A)
  0x77, 0x38, 0x19, 0x84, 0x77, 0x77, 0x30, 0xEB, 0x81, 0xC8, 0x47, 0x77, 0x6E, 0x0A, 0x77, 0x20,
  0x77, 0x3E, 0x04, 0x77, 0x18, 0x16, 0xF8, 0x71, 0x01, 0xD0, 0xD7, 0x71, 0x02, 0x0E, 0xA0, 0x67,
  0x02, 0xD0, 0x77, 0x71, 0x0B, 0xC0, 0x46, 0x03, 0xD0, 0x17, 0x70, 0x7D, 0x0E, 0x02, 0x50, 0x5C,
  0x0B, 0x77, 0x02, 0xF0, 0xD0, 0x14, 0x06, 0xC0, 0x57, 0x70, 0x7F, 0x90, 0xC4, 0x07, 0xB0, 0xE7,
  0x72, 0x04, 0x0D, 0xF0, 0xA3, 0x08, 0xB0, 0x87, 0x18, 0x22, 0x8E, 0x56, 0x09, 0xF0, 0x72, 0x09,
  0xB0, 0x26, 0x05, 0x0B, 0xB0, 0x77, 0x04, 0x0D, 0xE8, 0x15, 0x0A, 0xA0, 0xC4, 0x81, 0x28, 0xED,
  0x0A, 0x72, 0x09, 0xE0, 0x30, 0xBA, 0x06, 0x20, 0x50, 0xBF, 0x90, 0xC7, 0x30, 0x30, 0xDC, 0x85,
  0xED, 0xFE, 0x39, 0xEF, 0xC7, 0x50, 0x8F, 0xFF, 0x02, 0x75, 0x03, 0x0D, 0xFF, 0xD0, 0x55, 0x87,
  0x13, 0x46, 0x79, 0xAC, 0xEF, 0xC8, 0x93, 0xED, 0xBA, 0x97, 0x65, 0x15, 0xAC, 0xDF, 0xFA, 0x82,
  0x94, 0x31, 0x73, 0x07, 0xFF, 0xE0, 0x97, 0x50, 0x4F, 0xD0, 0xD0, 0x9F, 0x0D, 0x04, 0x73, 0x02,
  0xFB, 0x82, 0xB4, 0x07, 0xA0, 0x90, 0xDD, 0x09, 0x01, 0x72, 0x0E, 0xE8, 0x1E, 0x82, 0x30, 0xDA,
  0x81, 0x72, 0xED, 0x0E, 0x05, 0x71, 0x0C, 0xC0, 0xC0, 0x55, 0x04, 0xB8, 0x26, 0x03, 0xEE, 0x0A,
  0x01, 0x68, 0x39, 0xFE, 0x93, 0x70, 0x9B, 0x05, 0x20, 0x4F, 0x0E, 0x05, 0x50, 0x50, 0x67, 0x30,
  0xEB, 0x04, 0x30, 0x6F, 0x90, 0xB0, 0x17, 0x70, 0x6C, 0x03, 0x40, 0x7F, 0x90, 0x37, 0x70, 0xBC,
  0x02, 0x50, 0x9E, 0x07, 0x77, 0x02, 0xD0, 0x16, 0x0A, 0xC0, 0xB7, 0x71, 0x08, 0xD0, 0x17, 0x0C,
  0xA0, 0xE0, 0x17, 0x71, 0x0D, 0xD7, 0x18, 0x21, 0xDF, 0x57, 0x71, 0x04, 0xD0, 0xE7, 0x20, 0x20,
  0x87, 0x72, 0x0A, 0xD0, 0xD7, 0x77, 0x60, 0xCD, 0x0D, 0x77, 0x77, 0x84, 0x15, 0x9C, 0xFC, 0x77,
  0x77, 0x50, 0x37, 0x73,
  // "+" (U+002B)
  0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC,
  0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77,
  0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0,
  0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77,
  0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x70, 0x9F, 0xFF, 0xFC,
  0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x50, 0x9F, 0xFF, 0xFC, 0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x50, 0x9F,
  0xFF, 0xFC, 0x05, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77,
  0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C,
  0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77,
  0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC,
  0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x70,
  // "," (U+002C)
  0x78, 0x48, 0xDF, 0xEA, 0x27, 0x10, 0x10, 0xDE, 0x05, 0x70, 0xBF, 0x90, 0x35, 0x01, 0xFA, 0x0C,
  0x50, 0x4F, 0xB0, 0x34, 0x05, 0xFB, 0x06, 0x40, 0x3F, 0xB0, 0x85, 0x0E, 0xFA, 0x08, 0x50, 0x5F,
  0xA0, 0x76, 0x06, 0xF9, 0x06, 0x70, 0x5F, 0x04, 0x71, 0x05, 0xE0, 0x17, 0x20, 0xDC, 0x0C, 0x73,
  0x0D, 0xC0, 0x77, 0x30, 0xEB, 0x0E, 0x01, 0x72, 0x04, 0xC0, 0x97, 0x30, 0xCB, 0x0E, 0x01, 0x72,
  0x09, 0xC0, 0x47, 0x10, 0x10, 0xBC, 0x08, 0x78, 0x11, 0x7E, 0xC0, 0x96, 0x05, 0x0A, 0xE0, 0x77,
  0xE0, 0xC0, 0x37, 0x02, 0xC0, 0xD0, 0x57, 0x28, 0x34, 0xFE, 0x93, 0x74, 0x00, 0x27, 0x70,
  // "-" (U+002D)
  0x20, 0xDF, 0xFD, 0x81, 0x30, 0x1F, 0xFE, 0x20, 0x4F, 0xFD, 0x0C, 0x20, 0x8F, 0xFD, 0x09, 0x20,
  0xBF, 0xFD, 0x06, 0x20, 0xEF, 0xFD, 0x81, 0x20, 0x2F, 0xFD, 0x0E, 0x20,
  // "." (U+002E)
  0x38, 0x44, 0xBE, 0xEC, 0x64, 0x09, 0xE0, 0x92, 0x07, 0xF9, 0x81, 0x41, 0xEF, 0x90, 0x90, 0x6F,
  0xA0, 0xB0, 0x9F, 0xA0, 0x0B, 0xFA, 0x0A, 0x0B, 0xFA, 0x07, 0x09, 0xFA, 0x02, 0x04, 0xF9, 0x09,
  0x20, 0xAE, 0x0A, 0x48, 0x46, 0xCF, 0xEB, 0x53,
  // "/" (U+002F)
  0x77, 0x77, 0x60, 0x9C, 0x09, 0x77, 0x77, 0x60, 0xEC, 0x03, 0x77, 0x77, 0x50, 0x6C, 0x0B, 0x77,
  0x77, 0x60, 0xDC, 0x05, 0x77, 0x77, 0x50, 0x4C, 0x0D, 0x77, 0x77, 0x60, 0xBC, 0x07, 0x77, 0x77,
  0x50, 0x2C, 0x0E, 0x01, 0x77, 0x77, 0x50, 0x9C, 0x09, 0x77, 0x77, 0x50, 0x1D, 0x02, 0x77, 0x77,
  0x50, 0x7C, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x04, 0x77, 0x77, 0x50, 0x5C, 0x0D, 0x77, 0x77, 0x60,
  0xCC, 0x06, 0x77, 0x77, 0x50, 0x3C, 0x0E, 0x77, 0x77, 0x60, 0xAC, 0x08, 0x77, 0x77, 0x50, 0x1D,
  0x01, 0x77, 0x77, 0x50, 0x8C, 0x0A, 0x77, 0x77, 0x60, 0xEC, 0x03, 0x77, 0x77, 0x50, 0x6C, 0x0C,
  0x77, 0x77, 0x60, 0xCC, 0x05, 0x77, 0x77, 0x50, 0x4C, 0x0D, 0x77, 0x77, 0x60, 0xAC, 0x07, 0x77,
  0x77, 0x50, 0x2C, 0x0E, 0x01, 0x77, 0x77, 0x50, 0x8C, 0x09, 0x77, 0x77, 0x60, 0xEC, 0x02, 0x77,
  0x77, 0x50, 0x6C, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x04, 0x77, 0x77, 0x50, 0x4C, 0x0D, 0x77, 0x77,
  0x60, 0xBC, 0x06, 0x77, 0x77, 0x50, 0x2C, 0x0E, 0x77, 0x77, 0x60, 0x9C, 0x08, 0x77, 0x77, 0x50,
  0x10, 0xEC, 0x01, 0x77, 0x77, 0x50, 0x7C, 0x0A, 0x77, 0x77, 0x60, 0xDC, 0x03, 0x77, 0x77, 0x50,
  0x5C, 0x0C, 0x77, 0x77, 0x60, 0xCC, 0x05, 0x77, 0x77, 0x50, 0x3C, 0x0E, 0x77, 0x77, 0x60, 0xAC,
  0x07, 0x77, 0x77, 0x50, 0x1D, 0x01, 0x77, 0x77, 0x50, 0x7C, 0x09, 0x77, 0x77, 0x60, 0xEC, 0x02,
  0x77, 0x77, 0x50, 0x5C, 0x0B, 0x77, 0x77, 0x60, 0xCC, 0x04, 0x77, 0x77, 0x50, 0x3C, 0x0D, 0x77,
  0x77, 0x60, 0xAC, 0x06, 0x77, 0x77, 0x50, 0x1C, 0x0E, 0x77, 0x77, 0x60, 0x8C, 0x08, 0x77, 0x77,
  0x60, 0xEC, 0x02, 0x77, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0x77, 0x60, 0xDC, 0x03, 0x77, 0x77, 0x50,
  0x4C, 0x0C, 0x77, 0x77, 0x60, 0xBC, 0x05, 0x77, 0x77, 0x50, 0x2C, 0x0E, 0x77, 0x77, 0x60, 0x9C,
  0x07, 0x77, 0x77, 0x50, 0x10, 0xEC, 0x01, 0x77, 0x77, 0x50, 0x7C, 0x09, 0x77, 0x77, 0x60, 0xDC,
  0x03, 0x77, 0x77, 0x50, 0x5C, 0x0B, 0x77, 0x77, 0x60, 0xBC, 0x05, 0x77, 0x77, 0x50, 0x3C, 0x0D,
  0x77, 0x77, 0x60, 0x9C, 0x07, 0x77, 0x77, 0x50, 0x1C, 0x0E, 0x01, 0x77, 0x77, 0x50, 0x7C, 0x09,
  0x77, 0x77, 0x60, 0xEC, 0x02, 0x77, 0x77, 0x50, 0x5C, 0x0B, 0x77, 0x77, 0x60, 0xCC, 0x04, 0x77,
  0x77, 0x50, 0x3C, 0x0C, 0x77, 0x77, 0x60, 0xAC, 0x06, 0x77, 0x77, 0x50, 0x1C, 0x0E, 0x77, 0x77,
  0x60, 0x8C, 0x08, 0x77, 0x77, 0x60, 0xEC, 0x01, 0x77, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0x77, 0x60,
  0xDC, 0x03, 0x77, 0x77, 0x50, 0x4C, 0x0C, 0x77, 0x77, 0x60, 0xBC, 0x05, 0x77, 0x77, 0x50, 0x2C,
  0x0D, 0x77, 0x77, 0x60, 0x9C, 0x07, 0x77, 0x77, 0x60, 0xEB, 0x0E, 0x01, 0x77, 0x77, 0x50, 0x6C,
  0x09, 0x77, 0x77, 0x60,
  // "0" (U+0030)
  0x77, 0x58, 0x91, 0x16, 0x9C, 0xEF, 0xED, 0xB7, 0x37, 0x77, 0x60, 0x30, 0xAF, 0xC0, 0xC0, 0x47,
  0x77, 0x20, 0x10, 0x9F, 0xF9, 0x09, 0x77, 0x70, 0x20, 0xDF, 0xFB, 0x0C, 0x01, 0x77, 0x40, 0x40,
  0xEE, 0x84, 0xE9, 0x77, 0x9E, 0xF0, 0xD0, 0x17, 0x72, 0x04, 0xF0, 0x76, 0x07, 0xF0, 0xB7, 0x71,
  0x03, 0xE0, 0xE0, 0x37, 0x10, 0x6F, 0x06, 0x76, 0x01, 0x0E, 0xE0, 0x37, 0x30, 0xAE, 0x0E, 0x76,
  0x0C, 0xE0, 0x67, 0x40, 0x3F, 0x06, 0x74, 0x07, 0xE0, 0xA7, 0x60, 0xCE, 0x0C, 0x73, 0x02, 0xE0,
  0xE0, 0x17, 0x60, 0x8F, 0x01, 0x72, 0x0B, 0xE0, 0x77, 0x70, 0x4F, 0x05, 0x71, 0x04, 0xE0, 0xE7,
  0x71, 0x01, 0xF0, 0x97, 0x10, 0xCE, 0x07, 0x77, 0x2F, 0x0B, 0x70, 0x4F, 0x01, 0x77, 0x20, 0xDE,
  0x0E, 0x70, 0xCE, 0x0A, 0x77, 0x30, 0xCF, 0x60, 0x3F, 0x05, 0x77, 0x30, 0xBF, 0x01, 0x50, 0xAE,
  0x0E, 0x77, 0x40, 0xBF, 0x02, 0x40, 0x1F, 0x0A, 0x77, 0x40, 0xBF, 0x02, 0x40, 0x6F, 0x04, 0x77,
  0x40, 0xBF, 0x03, 0x40, 0xCE, 0x0E, 0x77, 0x50, 0xCF, 0x02, 0x30, 0x2F, 0x0B, 0x77, 0x50, 0xCF,
  0x02, 0x30, 0x6F, 0x07, 0x77, 0x50, 0xDF, 0x01, 0x30, 0xBF, 0x03, 0x77, 0x50, 0xEF, 0x40, 0xEE,
  0x0E, 0x77, 0x6F, 0x93, 0x04, 0xF0, 0xA7, 0x75, 0x01, 0xF0, 0xE3, 0x08, 0xF0, 0x67, 0x75, 0x03,
  0xF0, 0xC3, 0x0C, 0xF0, 0x37, 0x75, 0x04, 0xF0, 0xB3, 0xF9, 0x01, 0x77, 0x50, 0x6F, 0x09, 0x20,
  0x3F, 0x0D, 0x77, 0x60, 0x8F, 0x07, 0x20, 0x6F, 0x0A, 0x77, 0x60, 0xAF, 0x05, 0x20, 0x9F, 0x07,
  0x77, 0x60, 0xCF, 0x02, 0x20, 0xCF, 0x05, 0x77, 0x60, 0xEF, 0x3F, 0x90, 0x37, 0x75, 0x01, 0xF0,
  0xC2, 0x02, 0xF9, 0x77, 0x60, 0x4F, 0x09, 0x20, 0x4F, 0x0E, 0x77, 0x60, 0x7F, 0x06, 0x20, 0x6F,
  0x0C, 0x77, 0x60, 0xAF, 0x03, 0x20, 0x8F, 0x0A, 0x77, 0x60, 0xDF, 0x30, 0xAF, 0x08, 0x77, 0x6F,
  0x0B, 0x30, 0xBF, 0x07, 0x77, 0x50, 0x3F, 0x07, 0x30, 0xDF, 0x05, 0x77, 0x50, 0x7F, 0x03, 0x30,
  0xDF, 0x04, 0x77, 0x50, 0xAE, 0x0E, 0x40, 0xEF, 0x03, 0x77, 0x50, 0xEE, 0x0B, 0x40, 0xEF, 0x02,
  0x77, 0x40, 0x3F, 0x06, 0x4F, 0x90, 0x27, 0x74, 0x07, 0xF0, 0x14, 0xF9, 0x01, 0x77, 0x40, 0xBE,
  0x0B, 0x5F, 0x90, 0x17, 0x73, 0x01, 0xF0, 0x65, 0xF9, 0x01, 0x77, 0x30, 0x5E, 0x0E, 0x01, 0x50,
  0xEF, 0x01, 0x77, 0x30, 0xBE, 0x09, 0x60, 0xDF, 0x01, 0x77, 0x20, 0x1F, 0x03, 0x60, 0xBF, 0x02,
  0x77, 0x20, 0x6E, 0x0B, 0x70, 0x9F, 0x03, 0x77, 0x20, 0xCE, 0x04, 0x70, 0x7F, 0x05, 0x77, 0x10,
  0x3E, 0x0C, 0x71, 0x03, 0xF0, 0x77, 0x71, 0x0A, 0xE0, 0x37, 0x2F, 0x0A, 0x77, 0x03, 0xE0, 0xA7,
  0x30, 0xBE, 0x0D, 0x77, 0x0B, 0xD0, 0xE0, 0x27, 0x30, 0x5F, 0x02, 0x75, 0x05, 0xE0, 0x77, 0x50,
  0xEE, 0x09, 0x74, 0x02, 0x0E, 0xD0, 0xB7, 0x60, 0x7F, 0x02, 0x73, 0x0C, 0xD0, 0xD0, 0x17, 0x70,
  0xDE, 0x0C, 0x71, 0x01, 0x0C, 0xD0, 0xE0, 0x37, 0x71, 0x04, 0xF0, 0xC0, 0x15, 0x04, 0x0D, 0xE0,
  0x47, 0x73, 0x07, 0xF9, 0x83, 0xA7, 0x68, 0xDE, 0x0E, 0x04, 0x77, 0x50, 0x8F, 0xFB, 0x0D, 0x02,
  0x77, 0x70, 0x60, 0xEF, 0xF0, 0x90, 0x17, 0x77, 0x20, 0x20, 0xAF, 0xC0, 0xB0, 0x47, 0x77, 0x68,
  0x91, 0x16, 0xAD, 0xEF, 0xED, 0xA6, 0x27, 0x76,
  // "1" (U+0031)
  0x77, 0x75, 0x08, 0xD0, 0x97, 0x77, 0x30, 0x10, 0xBE, 0x06, 0x77, 0x72, 0x05, 0x0E, 0xF0, 0x37,
  0x77, 0x10, 0x9F, 0x90, 0xE7, 0x77, 0x02, 0x0C, 0xFA, 0x0B, 0x77, 0x60, 0x6F, 0xC0, 0x87, 0x74,
  0x02, 0x0B, 0xFD, 0x05, 0x77, 0x30, 0x60, 0xEC, 0x05, 0xF9, 0x01, 0x77, 0x10, 0x40, 0xCD, 0x05,
  0x04, 0xF0, 0xE7, 0x70, 0x50, 0xCE, 0x81, 0x50, 0x9F, 0x0A, 0x74, 0x81, 0x27, 0xDF, 0x06, 0x20,
  0xCF, 0x07, 0x73, 0x0C, 0xFA, 0x05, 0x20, 0x1F, 0x90, 0x47, 0x3F, 0xA0, 0x53, 0x05, 0xF9, 0x74,
  0x0D, 0xE0, 0xE0, 0x44, 0x08, 0xF0, 0xC7, 0x40, 0x7D, 0x0C, 0x02, 0x50, 0xCF, 0x09, 0x75, 0x83,
  0x9F, 0xEB, 0x57, 0xF9, 0x06, 0x77, 0x72, 0x03, 0xF9, 0x02, 0x77, 0x72, 0x06, 0xF0, 0xE7, 0x77,
  0x30, 0x9F, 0x0B, 0x77, 0x73, 0x0D, 0xF0, 0x87, 0x77, 0x3F, 0x90, 0x57, 0x77, 0x20, 0x4F, 0x90,
  0x17, 0x77, 0x20, 0x7F, 0x0D, 0x77, 0x73, 0x0A, 0xF0, 0xA7, 0x77, 0x30, 0xEF, 0x07, 0x77, 0x72,
  0x01, 0xF9, 0x03, 0x77, 0x72, 0x05, 0xF9, 0x77, 0x73, 0x08, 0xF0, 0xC7, 0x77, 0x30, 0xBF, 0x09,
  0x77, 0x73, 0x0E, 0xF0, 0x67, 0x77, 0x20, 0x3F, 0x90, 0x27, 0x77, 0x20, 0x6F, 0x0E, 0x77, 0x73,
  0x09, 0xF0, 0xB7, 0x77, 0x30, 0xDF, 0x08, 0x77, 0x73, 0xF9, 0x04, 0x77, 0x72, 0x04, 0xF9, 0x01,
  0x77, 0x72, 0x07, 0xF0, 0xD7, 0x77, 0x30, 0xAF, 0x0A, 0x77, 0x73, 0x0E, 0xF0, 0x77, 0x77, 0x20,
  0x1F, 0x90, 0x37, 0x77, 0x20, 0x5F, 0x97, 0x77, 0x30, 0x8F, 0x0C, 0x77, 0x73, 0x0B, 0xF0, 0x97,
  0x77, 0x30, 0xEF, 0x05, 0x77, 0x72, 0x03, 0xF9, 0x02, 0x77, 0x72, 0x06, 0xF0, 0xE7, 0x77, 0x30,
  0x9F, 0x0B, 0x77, 0x73, 0x0D, 0xF0, 0x77, 0x77, 0x3F, 0x90, 0x47, 0x77, 0x20, 0x4F, 0x90, 0x17,
  0x77, 0x20, 0x7F, 0x0D, 0x77, 0x73, 0x0A, 0xF0, 0xA7, 0x77, 0x30, 0xEF, 0x06, 0x77, 0x72, 0x02,
  0xF9, 0x03, 0x77, 0x72, 0x06, 0xF9, 0x77, 0x73, 0x0A, 0xF0, 0xD7, 0x77, 0x20, 0x2F, 0x90, 0xC7,
  0x77, 0x20, 0xAF, 0x90, 0xD7, 0x77, 0x10, 0x9F, 0xB0, 0x47, 0x73, 0x82, 0x13, 0x8E, 0xFC, 0x82,
  0xE8, 0x41, 0x72, 0xFF, 0xFF, 0x90, 0x32, 0x03, 0xFF, 0xFF, 0x93, 0x06, 0xFF, 0xFF, 0x0C, 0x30,
  0x9F, 0xFF, 0xF0, 0x93,
  // "2" (U+0032)
  0x77, 0x78, 0x94, 0x14, 0x8A, 0xCE, 0xEF, 0xED, 0xCA, 0x63, 0x77, 0x77, 0x05, 0x0B, 0xFF, 0x0D,
  0x06, 0x77, 0x73, 0x05, 0x0D, 0xFF, 0xC0, 0xD0, 0x47, 0x76, 0x01, 0x0A, 0xFF, 0xF9, 0x07, 0x77,
  0x40, 0x20, 0xDF, 0xA8, 0x4B, 0x86, 0x79, 0xEF, 0xA0, 0x57, 0x72, 0x02, 0x0E, 0xF9, 0x0A, 0x02,
  0x60, 0x8F, 0xA0, 0x27, 0x71, 0x0D, 0xF9, 0x06, 0x72, 0x07, 0xF9, 0x0A, 0x77, 0x08, 0xF9, 0x06,
  0x74, 0x0C, 0xF9, 0x03, 0x75, 0x01, 0x0E, 0xF0, 0x97, 0x50, 0x5F, 0x90, 0x77, 0x50, 0x6F, 0x0E,
  0x01, 0x76, 0x0E, 0xF0, 0xC7, 0x50, 0xAF, 0x06, 0x77, 0x0B, 0xF0, 0xE7, 0x50, 0xDE, 0x0E, 0x77,
  0x10, 0x9F, 0x97, 0x50, 0xDE, 0x09, 0x77, 0x10, 0x8F, 0x90, 0x17, 0x40, 0xCE, 0x03, 0x77, 0x10,
  0x8F, 0x90, 0x17, 0x40, 0x9D, 0x0E, 0x77, 0x20, 0x8F, 0x97, 0x50, 0x20, 0xEC, 0x0A, 0x77, 0x20,
  0xAF, 0x0D, 0x76, 0x03, 0x0D, 0xB0, 0x77, 0x72, 0x0B, 0xF0, 0xB7, 0x71, 0x82, 0x58, 0xA3, 0x77,
  0x20, 0xEF, 0x08, 0x77, 0x77, 0x60, 0x1F, 0x90, 0x37, 0x77, 0x76, 0x05, 0xF0, 0xE7, 0x77, 0x77,
  0x09, 0xF0, 0x87, 0x77, 0x77, 0x0E, 0xF0, 0x27, 0x77, 0x76, 0x04, 0xF0, 0x97, 0x77, 0x77, 0x0B,
  0xE0, 0xE0, 0x17, 0x77, 0x76, 0x03, 0xF0, 0x77, 0x77, 0x77, 0x0B, 0xE0, 0xC7, 0x77, 0x77, 0x05,
  0xF0, 0x27, 0x77, 0x77, 0x0D, 0xE0, 0x67, 0x77, 0x77, 0x09, 0xE0, 0xA7, 0x77, 0x77, 0x04, 0xE0,
  0xC7, 0x77, 0x77, 0x01, 0x0E, 0xD0, 0xD0, 0x17, 0x77, 0x77, 0x0C, 0xD0, 0xE0, 0x27, 0x77, 0x77,
  0x09, 0xD0, 0xE0, 0x37, 0x77, 0x77, 0x07, 0xE0, 0x47, 0x77, 0x77, 0x05, 0xE0, 0x57, 0x77, 0x77,
  0x04, 0xE0, 0x57, 0x77, 0x77, 0x03, 0x0E, 0xD0, 0x57, 0x77, 0x77, 0x03, 0x0E, 0xD0, 0x57, 0x77,
  0x77, 0x02, 0x0E, 0xD0, 0x57, 0x77, 0x77, 0x02, 0x0E, 0xD0, 0x47, 0x77, 0x77, 0x02, 0x0E, 0xC0,
  0xE0, 0x47, 0x77, 0x77, 0x02, 0x0D, 0xC0, 0xE0, 0x47, 0x77, 0x77, 0x02, 0x0D, 0xD0, 0x47, 0x77,
  0x77, 0x01, 0x0D, 0xD0, 0x47, 0x77, 0x77, 0x01, 0x0D, 0xD0, 0x47, 0x77, 0x77, 0x01, 0x0D, 0xD0,
  0x47, 0x77, 0x77, 0x01, 0x0D, 0xD0, 0x47, 0x77, 0x77, 0x01, 0x0C, 0xD0, 0x57, 0x77, 0x77, 0x01,
  0x0C, 0xD0, 0x57, 0x77, 0x77, 0x01, 0x0C, 0xD0, 0x57, 0x73, 0x01, 0x0F, 0x27, 0x71, 0x0C, 0xD0,
  0x57, 0x74, 0x0D, 0xA0, 0xB7, 0x70, 0xBD, 0x05, 0x77, 0x40, 0x5B, 0x07, 0x76, 0x0B, 0xD0, 0x57,
  0x75, 0x0D, 0xB0, 0x37, 0x50, 0xBD, 0x05, 0x77, 0x50, 0x5B, 0x0E, 0x75, 0x0B, 0xD0, 0x67, 0x75,
  0x01, 0x0E, 0xB0, 0xB7, 0x40, 0xBD, 0x06, 0x77, 0x60, 0xAC, 0x07, 0x73, 0x0A, 0xD0, 0x67, 0x76,
  0x08, 0xD0, 0x37, 0x20, 0xAD, 0x06, 0x77, 0x48, 0x12, 0x6C, 0xE7, 0x20, 0x3F, 0xFF, 0xFD, 0x0B,
  0x72, 0x07, 0xFF, 0xFF, 0xD0, 0x77, 0x20, 0xBF, 0xFF, 0xFD, 0x03, 0x72, 0x0E, 0xFF, 0xFF, 0xD7,
  0x20, 0x3F, 0xFF, 0xFD, 0x0B, 0x72, 0x07, 0xFF, 0xFF, 0xD0, 0x77, 0x20, 0xAF, 0xFF, 0xFD, 0x03,
  0x72,
  // "3" (U+0033)
  0x77, 0x78, 0x93, 0x25, 0x9B, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x77, 0x68, 0x11, 0x6C, 0xFE, 0x0D,
  0x07, 0x77, 0x73, 0x08, 0x0E, 0xFF, 0xB0, 0xD0, 0x47, 0x76, 0x04, 0x0D, 0xFF, 0xF0, 0x87, 0x74,
  0x07, 0xFA, 0x84, 0xC9, 0x76, 0x7B, 0xFA, 0x08, 0x77, 0x20, 0x7F, 0x90, 0xC0, 0x36, 0x02, 0x0C,
  0xF9, 0x05, 0x77, 0x05, 0xF9, 0x09, 0x72, 0x01, 0x0D, 0xF0, 0xE7, 0x60, 0x10, 0xEF, 0x0A, 0x74,
  0x04, 0xF9, 0x07, 0x75, 0x08, 0xF0, 0xD0, 0x17, 0x50, 0xDF, 0x0B, 0x75, 0x0E, 0xF0, 0x57, 0x60,
  0x8F, 0x90, 0x17, 0x30, 0x3F, 0x0D, 0x77, 0x04, 0xF9, 0x03, 0x73, 0x05, 0xF0, 0x77, 0x70, 0x3F,
  0x90, 0x47, 0x30, 0x6F, 0x01, 0x77, 0x02, 0xF9, 0x05, 0x73, 0x06, 0xE0, 0xB7, 0x71, 0x03, 0xF9,
  0x05, 0x73, 0x03, 0xE0, 0x67, 0x71, 0x04, 0xF9, 0x04, 0x74, 0x0D, 0xD0, 0x27, 0x71, 0x05, 0xF9,
  0x02, 0x74, 0x02, 0x0D, 0xB0, 0xE7, 0x72, 0x08, 0xF0, 0xE7, 0x78, 0x25, 0x9B, 0x87, 0x72, 0x0B,
  0xF0, 0xA7, 0x77, 0x76, 0xF9, 0x06, 0x77, 0x77, 0x50, 0x5F, 0x90, 0x17, 0x77, 0x75, 0x0C, 0xF0,
  0xA7, 0x77, 0x75, 0x03, 0xF9, 0x02, 0x77, 0x77, 0x50, 0xCF, 0x09, 0x77, 0x77, 0x50, 0x8F, 0x0D,
  0x77, 0x77, 0x50, 0x5F, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x5F, 0x90, 0x47, 0x77, 0x74, 0x07, 0xF0,
  0xE0, 0x47, 0x77, 0x73, 0x03, 0x0C, 0xF0, 0xD0, 0x37, 0x77, 0x72, 0x05, 0x0B, 0xF9, 0x09, 0x77,
  0x73, 0x85, 0x36, 0x66, 0x79, 0xCF, 0xA0, 0xA0, 0x27, 0x77, 0x40, 0x9F, 0xD8, 0x1C, 0x71, 0x77,
  0x76, 0x0C, 0xFB, 0x81, 0xD6, 0x27, 0x77, 0x71, 0x0E, 0xFE, 0x0C, 0x06, 0x77, 0x75, 0x02, 0xFF,
  0xA0, 0xD0, 0x47, 0x77, 0x71, 0x82, 0x13, 0x7C, 0xFB, 0x06, 0x77, 0x77, 0x40, 0x40, 0xCF, 0xA0,
  0x67, 0x77, 0x75, 0x0A, 0xFA, 0x03, 0x77, 0x77, 0x50, 0xBF, 0x90, 0xC7, 0x77, 0x75, 0x01, 0x0E,
  0xF9, 0x04, 0x77, 0x77, 0x50, 0x7F, 0x90, 0xA7, 0x77, 0x75, 0x01, 0xF9, 0x0E, 0x77, 0x77, 0x60,
  0xCF, 0x90, 0x27, 0x77, 0x75, 0x08, 0xF9, 0x04, 0x77, 0x77, 0x50, 0x6F, 0x90, 0x57, 0x77, 0x75,
  0x05, 0xF9, 0x06, 0x77, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x77, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x77,
  0x50, 0x6F, 0x90, 0x47, 0x77, 0x75, 0x07, 0xF9, 0x02, 0x77, 0x77, 0x50, 0xAF, 0x97, 0x38, 0x15,
  0x87, 0x77, 0x70, 0xCF, 0x0C, 0x71, 0x05, 0x0E, 0xA0, 0xC7, 0x76, 0x01, 0xF9, 0x08, 0x70, 0x5C,
  0x0D, 0x77, 0x60, 0x5F, 0x90, 0x36, 0x01, 0x0E, 0xD7, 0x76, 0x0B, 0xF0, 0xD7, 0x06, 0xE0, 0x47,
  0x74, 0x02, 0xF9, 0x07, 0x70, 0x9E, 0x07, 0x77, 0x40, 0xBF, 0x0D, 0x71, 0x0B, 0xE0, 0xD7, 0x73,
  0x05, 0xF9, 0x05, 0x71, 0x0A, 0xF0, 0x67, 0x71, 0x03, 0x0E, 0xF0, 0xA7, 0x20, 0x7F, 0x0E, 0x02,
  0x76, 0x02, 0x0E, 0xF0, 0xD0, 0x17, 0x20, 0x3F, 0x90, 0xD0, 0x27, 0x40, 0x60, 0xEF, 0x0E, 0x02,
  0x74, 0x0B, 0xF9, 0x0E, 0x06, 0x71, 0x05, 0x0C, 0xF9, 0x0D, 0x02, 0x75, 0x02, 0x0E, 0xFA, 0x86,
  0xEA, 0x76, 0x68, 0xAE, 0xFA, 0x0A, 0x01, 0x77, 0x04, 0x0E, 0xFF, 0xFA, 0x0D, 0x05, 0x77, 0x30,
  0x20, 0xBF, 0xFE, 0x0D, 0x06, 0x77, 0x70, 0x40, 0xBF, 0xF9, 0x81, 0xEA, 0x47, 0x77, 0x48, 0x51,
  0x58, 0xAC, 0xEE, 0xA8, 0x4E, 0xDB, 0x96, 0x37, 0x77,
  // "4" (U+0034)
  0x77, 0x77, 0x40, 0x20, 0xEF, 0x05, 0x77, 0x77, 0x40, 0xCF, 0x90, 0x27, 0x77, 0x73, 0x09, 0xF9,
  0x0E, 0x77, 0x77, 0x30, 0x5F, 0xA0, 0xB7, 0x77, 0x72, 0x02, 0x0E, 0xFA, 0x08, 0x77, 0x77, 0x20,
  0xCF, 0xB0, 0x47, 0x77, 0x71, 0x09, 0xFC, 0x01, 0x77, 0x77, 0x05, 0xC0, 0xEE, 0x0D, 0x77, 0x77,
  0x02, 0x0E, 0xB0, 0x9F, 0x0A, 0x77, 0x77, 0x0D, 0xB0, 0xD0, 0x6F, 0x07, 0x77, 0x76, 0x0A, 0xC0,
  0x40, 0x9F, 0x04, 0x77, 0x75, 0x06, 0xC8, 0x1A, 0x0E, 0xF7, 0x77, 0x50, 0x3C, 0x81, 0xE1, 0x2F,
  0x0C, 0x77, 0x75, 0x0D, 0xC8, 0x15, 0x06, 0xF0, 0x97, 0x77, 0x40, 0xAC, 0x0A, 0x20, 0xAF, 0x06,
  0x77, 0x73, 0x06, 0xC0, 0xE0, 0x12, 0x0E, 0xF0, 0x37, 0x77, 0x20, 0x3D, 0x04, 0x20, 0x3F, 0x97,
  0x77, 0x20, 0x10, 0xDC, 0x08, 0x30, 0x6F, 0x0C, 0x77, 0x72, 0x0A, 0xC0, 0xB4, 0x0A, 0xF0, 0x87,
  0x77, 0x10, 0x7C, 0x0E, 0x01, 0x40, 0xDF, 0x05, 0x77, 0x70, 0x3D, 0x03, 0x40, 0x1F, 0x90, 0x27,
  0x76, 0x01, 0x0D, 0xC0, 0x75, 0x05, 0xF0, 0xE7, 0x77, 0x0B, 0xC0, 0xA6, 0x08, 0xF0, 0xB7, 0x76,
  0x07, 0xC0, 0xD0, 0x16, 0x0C, 0xF0, 0x77, 0x75, 0x04, 0xD0, 0x37, 0xF9, 0x04, 0x77, 0x40, 0x10,
  0xEC, 0x06, 0x70, 0x3F, 0x90, 0x17, 0x74, 0x0B, 0xC0, 0x97, 0x10, 0x6F, 0x0D, 0x77, 0x40, 0x8C,
  0x0C, 0x72, 0x09, 0xF0, 0xA7, 0x73, 0x04, 0xC0, 0xE0, 0x27, 0x20, 0xCF, 0x06, 0x77, 0x20, 0x10,
  0xEC, 0x04, 0x73, 0xF9, 0x03, 0x77, 0x20, 0xBC, 0x08, 0x73, 0x03, 0xF9, 0x77, 0x20, 0x8C, 0x0B,
  0x74, 0x06, 0xF0, 0xC7, 0x71, 0x04, 0xC0, 0xE0, 0x17, 0x40, 0x9F, 0x09, 0x77, 0x01, 0x0E, 0xC0,
  0x37, 0x50, 0xDF, 0x05, 0x77, 0x0C, 0xC0, 0x77, 0x6F, 0x90, 0x27, 0x60, 0x9C, 0x0A, 0x76, 0x04,
  0xF0, 0xE7, 0x60, 0x5C, 0x0D, 0x01, 0x76, 0x07, 0xF0, 0xB7, 0x50, 0x20, 0xEC, 0x03, 0x77, 0x0A,
  0xF0, 0x87, 0x50, 0xCC, 0x06, 0x77, 0x10, 0xDF, 0x05, 0x74, 0x09, 0xC0, 0x97, 0x71, 0x01, 0xF9,
  0x01, 0x73, 0x05, 0xC0, 0xC7, 0x72, 0x04, 0xF0, 0xE7, 0x30, 0x20, 0xEC, 0x08, 0x80, 0x94, 0x60,
  0xAF, 0x0D, 0x80, 0x46, 0x81, 0x50, 0xC8, 0x0C, 0x3F, 0x0B, 0x03, 0x80, 0xC4, 0xF0, 0x07, 0x80,
  0xC4, 0xF0, 0x30, 0xA8, 0x0C, 0x3F, 0x0E, 0x77, 0x73, 0x09, 0xF0, 0x87, 0x77, 0x75, 0x0C, 0xF0,
  0x57, 0x77, 0x75, 0xF9, 0x02, 0x77, 0x77, 0x40, 0x3F, 0x0E, 0x77, 0x77, 0x50, 0x6F, 0x0B, 0x77,
  0x77, 0x50, 0x9F, 0x07, 0x77, 0x77, 0x50, 0xCF, 0x04, 0x77, 0x77, 0x5F, 0x90, 0x17, 0x77, 0x74,
  0x04, 0xF0, 0xD7, 0x77, 0x75, 0x09, 0xF0, 0xA7, 0x77, 0x74, 0x01, 0x0E, 0xF0, 0x97, 0x77, 0x74,
  0x09, 0xF9, 0x0B, 0x77, 0x77, 0x30, 0x8F, 0xB0, 0x27, 0x77, 0x58, 0x21, 0x48, 0xEF, 0xC8, 0x2E,
  0x83, 0x17, 0x74, 0x01, 0xFF, 0xFC, 0x09, 0x77, 0x10, 0x4F, 0xFF, 0xC0, 0x57, 0x71, 0x07, 0xFF,
  0xFC, 0x02, 0x77, 0x10, 0xAF, 0xFF, 0xB0, 0xE6,
  // "5" (U+0035)
  0x77, 0x20, 0x9F, 0xFF, 0xC0, 0xE7, 0x72, 0x0D, 0xFF, 0xFC, 0x0B, 0x77, 0x10, 0x2F, 0xFF, 0xD0,
  0x87, 0x71, 0x07, 0xFF, 0xFD, 0x05, 0x77, 0x10, 0xBF, 0xFF, 0xD0, 0x27, 0x71, 0xFF, 0xFD, 0x0E,
  0x77, 0x10, 0x5F, 0xFF, 0xD0, 0xC7, 0x71, 0x09, 0xB0, 0x87, 0x72, 0x02, 0x08, 0xC0, 0x97, 0x71,
  0x0D, 0xB0, 0x47, 0x74, 0x0C, 0xB0, 0x67, 0x70, 0x3C, 0x77, 0x50, 0xAB, 0x03, 0x77, 0x07, 0xB0,
  0xB7, 0x75, 0x0C, 0xB7, 0x71, 0x0B, 0xB0, 0x77, 0x75, 0x0D, 0xA0, 0xC7, 0x70, 0x1C, 0x03, 0x77,
  0x5B, 0x09, 0x77, 0x05, 0xB0, 0xE7, 0x76, 0x0F, 0x50, 0x27, 0x70, 0x9B, 0x0A, 0x80, 0xC2, 0x00,
  0xEB, 0x06, 0x80, 0xC1, 0x00, 0x3C, 0x02, 0x80, 0xC1, 0x00, 0x7B, 0x0D, 0x80, 0xC2, 0x00, 0xCB,
  0x09, 0x80, 0xC1, 0x00, 0x1C, 0x05, 0x80, 0xC1, 0x00, 0x5C, 0x01, 0x80, 0xC1, 0x00, 0xAB, 0x0C,
  0x80, 0xC2, 0x00, 0xEB, 0x08, 0x80, 0xC1, 0x00, 0x3C, 0x03, 0x80, 0xC1, 0x00, 0x8B, 0x0E, 0x80,
  0xC2, 0x00, 0xCB, 0x0A, 0x80, 0xC1, 0x00, 0x1C, 0x89, 0x46, 0x15, 0x9C, 0xDE, 0xFE, 0xDC, 0xA6,
  0x27, 0x77, 0x30, 0x6C, 0x0D, 0xFE, 0x0D, 0x06, 0x77, 0x71, 0x0A, 0xFF, 0xE0, 0xE0, 0x47, 0x76,
  0x0E, 0xFF, 0xF9, 0x08, 0x77, 0x40, 0x3E, 0x86, 0xD9, 0x76, 0x67, 0x9E, 0xFB, 0x0B, 0x77, 0x30,
  0x40, 0xEA, 0x81, 0xD8, 0x27, 0x10, 0x50, 0xDF, 0xA0, 0x97, 0x74, 0x04, 0x05, 0x76, 0x0A, 0xFA,
  0x04, 0x77, 0x77, 0x50, 0xAF, 0x90, 0xD7, 0x77, 0x75, 0x01, 0x0E, 0xF9, 0x05, 0x77, 0x77, 0x50,
  0x6F, 0x90, 0xA7, 0x77, 0x76, 0x0E, 0xF9, 0x77, 0x77, 0x60, 0x9F, 0x90, 0x37, 0x77, 0x75, 0x06,
  0xF9, 0x06, 0x77, 0x77, 0x50, 0x3F, 0x90, 0x77, 0x77, 0x75, 0x02, 0xF9, 0x08, 0x77, 0x77, 0x50,
  0x1F, 0x90, 0x97, 0x77, 0x76, 0xF9, 0x09, 0x77, 0x77, 0x6F, 0x90, 0x87, 0x77, 0x75, 0x01, 0xF9,
  0x07, 0x77, 0x77, 0x50, 0x2F, 0x90, 0x57, 0x77, 0x75, 0x03, 0xF9, 0x02, 0x77, 0x77, 0x50, 0x5F,
  0x97, 0x77, 0x76, 0x08, 0xF0, 0xC7, 0x77, 0x76, 0x0B, 0xF0, 0x77, 0x28, 0x31, 0x9D, 0xF6, 0x77,
  0x60, 0xEF, 0x02, 0x71, 0x03, 0x0E, 0xB0, 0x77, 0x75, 0x04, 0xF0, 0xC7, 0x20, 0xDC, 0x09, 0x77,
  0x50, 0xAF, 0x05, 0x71, 0x05, 0xD0, 0xC7, 0x74, 0x02, 0xF0, 0xD7, 0x20, 0x9E, 0x77, 0x40, 0xAF,
  0x04, 0x72, 0x0B, 0xE0, 0x47, 0x72, 0x05, 0xF0, 0xA7, 0x30, 0xAE, 0x0B, 0x77, 0x10, 0x30, 0xEE,
  0x0D, 0x01, 0x73, 0x08, 0xF0, 0x57, 0x60, 0x30, 0xEF, 0x03, 0x74, 0x04, 0xF0, 0xE0, 0x37, 0x40,
  0x60, 0xEF, 0x05, 0x76, 0x0D, 0xF0, 0xE0, 0x67, 0x10, 0x50, 0xCF, 0x0E, 0x04, 0x77, 0x04, 0xFA,
  0x86, 0xEA, 0x76, 0x68, 0xAE, 0xF9, 0x0D, 0x03, 0x77, 0x20, 0x6F, 0xFF, 0xA0, 0x97, 0x75, 0x04,
  0x0D, 0xFF, 0xD0, 0xB0, 0x37, 0x77, 0x10, 0x70, 0xDF, 0xF8, 0x1D, 0x93, 0x77, 0x75, 0x84, 0x37,
  0xAC, 0xEE, 0xA8, 0x4E, 0xDC, 0x96, 0x37, 0x77, 0x10,
  // "6" (U+0036)
  0x77, 0x72, 0x83, 0x37, 0xAC, 0xEA, 0x83, 0xED, 0xA7, 0x37, 0x77, 0x58, 0x11, 0x7D, 0xFD, 0x0D,
  0x05, 0x77, 0x72, 0x07, 0x0E, 0xFF, 0xA0, 0xA7, 0x76, 0x03, 0x0D, 0xFF, 0xD0, 0xB7, 0x74, 0x07,
  0xF9, 0x84, 0xC9, 0x76, 0x8E, 0xF9, 0x08, 0x77, 0x20, 0xAF, 0x0A, 0x03, 0x60, 0xBF, 0x0E, 0x77,
  0x10, 0xBE, 0x0E, 0x05, 0x71, 0x02, 0xF9, 0x05, 0x76, 0x0B, 0xE0, 0xE0, 0x27, 0x30, 0xAF, 0x07,
  0x75, 0x0A, 0xE0, 0xE0, 0x27, 0x40, 0x5F, 0x07, 0x74, 0x07, 0xF0, 0x37, 0x50, 0x2F, 0x06, 0x73,
  0x04, 0xF0, 0x77, 0x7F, 0x01, 0x72, 0x01, 0x0D, 0xE0, 0xC7, 0x71, 0xE0, 0x97, 0x30, 0xAF, 0x03,
  0x77, 0x10, 0xEC, 0x0C, 0x01, 0x72, 0x04, 0xF0, 0x97, 0x72, 0x0E, 0xB0, 0x97, 0x40, 0xDF, 0x01,
  0x77, 0x28, 0x29, 0x85, 0x17, 0x40, 0x6F, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x02, 0x77, 0x77, 0x30,
  0x6F, 0x0B, 0x77, 0x77, 0x40, 0xDF, 0x04, 0x77, 0x77, 0x30, 0x5F, 0x0D, 0x77, 0x77, 0x40, 0xBF,
  0x08, 0x77, 0x77, 0x30, 0x2F, 0x90, 0x27, 0x77, 0x73, 0x08, 0xF0, 0xD7, 0x77, 0x74, 0x0D, 0xF0,
  0x87, 0x77, 0x73, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x30, 0x8F, 0x0E, 0x77, 0x77, 0x40, 0xDF, 0x0A,
  0x58, 0x90, 0x48, 0xBD, 0xEF, 0xEC, 0x95, 0x77, 0x20, 0x1F, 0x90, 0x53, 0x07, 0x0D, 0xFB, 0x0E,
  0x06, 0x77, 0x06, 0xF9, 0x82, 0x10, 0x5D, 0xFF, 0x0B, 0x76, 0x0A, 0xF8, 0x1D, 0x1B, 0xFF, 0xB0,
  0xC7, 0x50, 0xDF, 0x0C, 0x0E, 0xD8, 0x4B, 0x86, 0x79, 0xEF, 0x90, 0xA7, 0x30, 0x1F, 0xD8, 0x1E,
  0x71, 0x60, 0xAF, 0x90, 0x57, 0x20, 0x4F, 0xC0, 0x97, 0x30, 0xBF, 0x0D, 0x72, 0x07, 0xFA, 0x0E,
  0x04, 0x74, 0x01, 0x0E, 0xF0, 0x47, 0x10, 0xAF, 0x90, 0xC0, 0x17, 0x60, 0x9F, 0x0A, 0x71, 0x0C,
  0xF0, 0xC0, 0x17, 0x70, 0x3F, 0x0E, 0x71, 0x0E, 0xF0, 0x77, 0x72, 0x0E, 0xF0, 0x36, 0x01, 0xF9,
  0x04, 0x77, 0x20, 0xCF, 0x06, 0x60, 0x3F, 0x90, 0x17, 0x72, 0x0A, 0xF0, 0x86, 0x04, 0xF0, 0xE7,
  0x73, 0x09, 0xF0, 0x96, 0x05, 0xF0, 0xC7, 0x73, 0x08, 0xF0, 0xA6, 0x07, 0xF0, 0xA7, 0x73, 0x07,
  0xF0, 0xA6, 0x07, 0xF0, 0x87, 0x73, 0x08, 0xF0, 0x96, 0x08, 0xF0, 0x67, 0x73, 0x08, 0xF0, 0x96,
  0x08, 0xF0, 0x57, 0x73, 0x09, 0xF0, 0x76, 0x09, 0xF0, 0x47, 0x73, 0x0B, 0xF0, 0x66, 0x08, 0xF0,
  0x47, 0x73, 0x0D, 0xF0, 0x36, 0x08, 0xF0, 0x37, 0x73, 0xF9, 0x01, 0x60, 0x7F, 0x03, 0x77, 0x20,
  0x2F, 0x0D, 0x70, 0x6F, 0x04, 0x77, 0x20, 0x5F, 0x0A, 0x70, 0x4F, 0x05, 0x77, 0x20, 0xAF, 0x06,
  0x70, 0x3F, 0x05, 0x77, 0x20, 0xEF, 0x01, 0x71, 0xF0, 0x77, 0x71, 0x04, 0xF0, 0xB7, 0x20, 0xCE,
  0x09, 0x77, 0x10, 0x9F, 0x05, 0x72, 0x09, 0xE0, 0xC7, 0x70, 0x1F, 0x0D, 0x73, 0x05, 0xF0, 0x17,
  0x60, 0x8F, 0x06, 0x74, 0x0E, 0xE0, 0x57, 0x50, 0x2F, 0x0D, 0x75, 0x09, 0xE0, 0xC7, 0x50, 0xBF,
  0x03, 0x75, 0x01, 0xF0, 0x57, 0x30, 0x8F, 0x08, 0x77, 0x08, 0xE0, 0xE0, 0x17, 0x10, 0x7F, 0x0B,
  0x77, 0x20, 0xDE, 0x0D, 0x03, 0x50, 0x20, 0xAF, 0x0C, 0x01, 0x77, 0x20, 0x20, 0xEF, 0x83, 0xB8,
  0x68, 0xBF, 0x90, 0xC0, 0x17, 0x74, 0x03, 0x0E, 0xFF, 0xC0, 0x97, 0x77, 0x02, 0x0D, 0xFF, 0x90,
  0xD0, 0x47, 0x77, 0x30, 0x70, 0xEF, 0xC0, 0xC0, 0x57, 0x77, 0x78, 0x91, 0x49, 0xCE, 0xFE, 0xEC,
  0x96, 0x27, 0x76,
  // "7" (U+0037)
  0x60, 0x6F, 0xFF, 0xFE, 0x06, 0x60, 0xAF, 0xFF, 0xFE, 0x02, 0x60, 0xEF, 0xFF, 0xFD, 0x0D, 0x60,
  0x2F, 0xFF, 0xFE, 0x05, 0x60, 0x6F, 0xFF, 0xFD, 0x0D, 0x70, 0x9F, 0xFF, 0xFD, 0x05, 0x70, 0xDF,
  0xFF, 0xFC, 0x0C, 0x70, 0x1D, 0x08, 0x03, 0x77, 0x40, 0x10, 0xEE, 0x04, 0x70, 0x5C, 0x04, 0x77,
  0x60, 0x8E, 0x0B, 0x71, 0x09, 0xB0, 0x77, 0x76, 0x01, 0xF0, 0x37, 0x10, 0xDA, 0x0E, 0x77, 0x70,
  0x9E, 0x0B, 0x71, 0x01, 0xB0, 0x97, 0x76, 0x02, 0xF0, 0x37, 0x10, 0x5B, 0x05, 0x77, 0x60, 0xAE,
  0x0A, 0x72, 0x08, 0xB0, 0x17, 0x75, 0x03, 0xF0, 0x27, 0x20, 0xCA, 0x0D, 0x77, 0x60, 0xBE, 0x09,
  0x73, 0xB0, 0x97, 0x75, 0x04, 0xF0, 0x17, 0x30, 0xF1, 0x77, 0x60, 0xDE, 0x09, 0x77, 0x77, 0x50,
  0x6E, 0x0E, 0x01, 0x77, 0x77, 0x50, 0xDE, 0x08, 0x77, 0x77, 0x50, 0x7E, 0x0E, 0x01, 0x77, 0x77,
  0x40, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x50, 0x8E, 0x0E, 0x77, 0x77, 0x50, 0x1F, 0x06, 0x77, 0x77,
  0x50, 0x9E, 0x0D, 0x77, 0x77, 0x50, 0x2F, 0x06, 0x77, 0x77, 0x50, 0xAE, 0x0D, 0x77, 0x77, 0x50,
  0x3F, 0x05, 0x77, 0x77, 0x50, 0xCE, 0x0C, 0x77, 0x77, 0x50, 0x4F, 0x04, 0x77, 0x77, 0x50, 0xDE,
  0x0C, 0x77, 0x77, 0x50, 0x6F, 0x04, 0x77, 0x77, 0x50, 0xDE, 0x0B, 0x77, 0x77, 0x50, 0x7F, 0x03,
  0x77, 0x77, 0x40, 0x10, 0xEE, 0x0A, 0x77, 0x77, 0x50, 0x8F, 0x02, 0x77, 0x77, 0x40, 0x1F, 0x0A,
  0x77, 0x77, 0x50, 0x9F, 0x02, 0x77, 0x77, 0x40, 0x2F, 0x09, 0x77, 0x77, 0x50, 0xAF, 0x01, 0x77,
  0x77, 0x40, 0x3F, 0x08, 0x77, 0x77, 0x50, 0xCE, 0x0E, 0x01, 0x77, 0x77, 0x40, 0x5F, 0x08, 0x77,
  0x77, 0x50, 0xDE, 0x0E, 0x01, 0x77, 0x77, 0x40, 0x6F, 0x07, 0x77, 0x77, 0x50, 0xDE, 0x0E, 0x77,
  0x77, 0x50, 0x7F, 0x06, 0x77, 0x77, 0x40, 0x10, 0xEE, 0x0D, 0x77, 0x77, 0x50, 0x8F, 0x05, 0x77,
  0x77, 0x40, 0x1F, 0x0D, 0x77, 0x77, 0x50, 0x9F, 0x05, 0x77, 0x77, 0x40, 0x2F, 0x0C, 0x77, 0x77,
  0x50, 0xBF, 0x04, 0x77, 0x77, 0x40, 0x3F, 0x0B, 0x77, 0x77, 0x50, 0xCF, 0x03, 0x77, 0x77, 0x40,
  0x5F, 0x0B, 0x77, 0x77, 0x50, 0xDF, 0x03, 0x77, 0x77, 0x40, 0x6F, 0x0A, 0x77, 0x77, 0x50, 0xDF,
  0x02, 0x77, 0x77, 0x40, 0x7F, 0x09, 0x77, 0x77, 0x40, 0x10, 0xEF, 0x02, 0x77, 0x77, 0x40, 0x8F,
  0x09, 0x77, 0x77, 0x40, 0x1F, 0x90, 0x17, 0x77, 0x74, 0x09, 0xF0, 0x87, 0x77, 0x74, 0x02, 0xF0,
  0xE0, 0x17, 0x77, 0x74,
  // "8" (U+0038)
  0x77, 0x78, 0x94, 0x36, 0x9B, 0xDE, 0xEF, 0xED, 0xB8, 0x41, 0x77, 0x75, 0x81, 0x29, 0xEF, 0xF0,
  0x90, 0x27, 0x77, 0x10, 0x10, 0xAF, 0xFD, 0x07, 0x77, 0x60, 0x50, 0xEF, 0xFF, 0x0B, 0x77, 0x40,
  0x7F, 0xA8, 0x5E, 0xA8, 0x67, 0x9D, 0xF9, 0x0A, 0x77, 0x20, 0x7F, 0x90, 0xD0, 0x47, 0x04, 0x0D,
  0xF0, 0x77, 0x70, 0x4F, 0x90, 0x97, 0x30, 0x10, 0xDF, 0x01, 0x75, 0x01, 0x0E, 0xF0, 0x87, 0x50,
  0x3F, 0x09, 0x75, 0x08, 0xF0, 0xB7, 0x70, 0xAE, 0x0E, 0x74, 0x01, 0xF0, 0xE0, 0x17, 0x70, 0x4F,
  0x03, 0x73, 0x06, 0xF0, 0x97, 0x72, 0xF0, 0x77, 0x30, 0xCF, 0x02, 0x77, 0x20, 0xDE, 0x08, 0x72,
  0x01, 0xF0, 0xE7, 0x73, 0x0C, 0xE0, 0x97, 0x20, 0x4F, 0x0A, 0x77, 0x30, 0xBE, 0x09, 0x72, 0x07,
  0xF0, 0x87, 0x73, 0x0C, 0xE0, 0x87, 0x20, 0x9F, 0x06, 0x77, 0x30, 0xDE, 0x07, 0x72, 0x0A, 0xF0,
  0x57, 0x73, 0xF0, 0x47, 0x20, 0xBF, 0x06, 0x77, 0x20, 0x3F, 0x01, 0x72, 0x0A, 0xF0, 0x77, 0x72,
  0x07, 0xE0, 0xC7, 0x30, 0x9F, 0x09, 0x77, 0x20, 0xCE, 0x06, 0x73, 0x07, 0xF0, 0xD7, 0x71, 0x03,
  0xE0, 0xE7, 0x40, 0x4F, 0x90, 0x37, 0x70, 0xBE, 0x07, 0x74, 0x01, 0xF9, 0x0A, 0x76, 0x06, 0xE0,
  0xB7, 0x60, 0xBF, 0x90, 0x47, 0x40, 0x20, 0xED, 0x0D, 0x01, 0x76, 0x05, 0xF9, 0x0D, 0x01, 0x72,
  0x02, 0x0D, 0xD0, 0xD0, 0x27, 0x71, 0x0D, 0xF9, 0x0C, 0x71, 0x03, 0x0E, 0xD0, 0xC0, 0x17, 0x72,
  0x05, 0xFA, 0x0C, 0x01, 0x50, 0x7E, 0x0A, 0x77, 0x50, 0xBF, 0xA0, 0xD0, 0x22, 0x02, 0x0B, 0xD0,
  0xE0, 0x67, 0x76, 0x01, 0x0E, 0xFB, 0x07, 0x09, 0xE0, 0xB0, 0x27, 0x77, 0x10, 0x3F, 0xFA, 0x0D,
  0x05, 0x77, 0x74, 0x05, 0xFE, 0x0E, 0x06, 0x77, 0x77, 0x05, 0xFE, 0x06, 0x77, 0x77, 0x04, 0x0D,
  0xFE, 0x0A, 0x77, 0x74, 0x05, 0x0C, 0xFF, 0xA0, 0xC0, 0x17, 0x77, 0x04, 0x0C, 0xE0, 0x0C, 0xFC,
  0x0C, 0x01, 0x77, 0x40, 0x10, 0xAE, 0x0C, 0x04, 0x20, 0x60, 0xEF, 0xB0, 0xC7, 0x73, 0x07, 0x0E,
  0xD0, 0xE0, 0x75, 0x02, 0x0C, 0xFB, 0x09, 0x77, 0x01, 0x0B, 0xE0, 0xD0, 0x27, 0x10, 0x9F, 0xB0,
  0x57, 0x50, 0x20, 0xDE, 0x0B, 0x01, 0x73, 0x07, 0xFA, 0x0E, 0x74, 0x02, 0x0E, 0xE0, 0xB7, 0x60,
  0x7F, 0xA0, 0x87, 0x20, 0x10, 0xDE, 0x0C, 0x01, 0x77, 0x09, 0xF9, 0x0D, 0x72, 0x0A, 0xF0, 0x27,
  0x72, 0x0D, 0xF9, 0x04, 0x70, 0x4F, 0x08, 0x77, 0x30, 0x4F, 0x90, 0x87, 0x0C, 0xE0, 0xE7, 0x75,
  0x0D, 0xF0, 0xB6, 0x04, 0xF0, 0x97, 0x75, 0x08, 0xF0, 0xD6, 0x09, 0xF0, 0x37, 0x75, 0x04, 0xF0,
  0xE6, 0x0D, 0xF7, 0x76, 0x01, 0xF0, 0xE6, 0xF0, 0xC7, 0x77, 0xF0, 0xE5, 0x03, 0xF0, 0x97, 0x77,
  0xF0, 0xD5, 0x04, 0xF0, 0x87, 0x77, 0xF0, 0xC5, 0x05, 0xF0, 0x77, 0x76, 0x01, 0xF0, 0x95, 0x05,
  0xF0, 0x77, 0x76, 0x03, 0xF0, 0x75, 0x05, 0xF0, 0x87, 0x76, 0x06, 0xF0, 0x35, 0x03, 0xF0, 0x97,
  0x76, 0x0A, 0xE0, 0xE7, 0xF0, 0xD7, 0x76, 0x0E, 0xE0, 0x97, 0x0C, 0xF0, 0x17, 0x74, 0x07, 0xF0,
  0x37, 0x07, 0xF0, 0x87, 0x73, 0x01, 0x0E, 0xE0, 0xA7, 0x10, 0x1F, 0x0E, 0x01, 0x77, 0x20, 0xCF,
  0x02, 0x72, 0x08, 0xF0, 0xB7, 0x70, 0x10, 0xBF, 0x06, 0x74, 0x0D, 0xF0, 0xA7, 0x50, 0x30, 0xDF,
  0x0A, 0x75, 0x03, 0xF9, 0x0D, 0x05, 0x71, 0x03, 0x0B, 0xF9, 0x0A, 0x77, 0x04, 0xFA, 0x86, 0xEA,
  0x86, 0x78, 0xAE, 0xFA, 0x09, 0x77, 0x20, 0x30, 0xEF, 0xFF, 0x90, 0xE0, 0x57, 0x74, 0x01, 0x09,
  0xFF, 0xE0, 0x80, 0x17, 0x77, 0x81, 0x29, 0xEF, 0xF8, 0x1C, 0x61, 0x77, 0x75, 0x83, 0x37, 0xAC,
  0xEB, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x40,
  // "9" (U+0039)
  0x77, 0x68, 0x91, 0x47, 0xBD, 0xEF, 0xED, 0xB7, 0x37, 0x77, 0x58, 0x12, 0x8E, 0xFC, 0x0C, 0x04,
  0x77, 0x71, 0x01, 0x09, 0xFF, 0xA0, 0xA7, 0x76, 0x05, 0x0E, 0xFF, 0xC0, 0xC0, 0x17, 0x73, 0x08,
  0xF9, 0x84, 0xD9, 0x77, 0x9E, 0xF0, 0xC7, 0x72, 0x0A, 0xF0, 0xE0, 0x55, 0x01, 0x0A, 0xF0, 0x87,
  0x70, 0xAF, 0x0B, 0x01, 0x71, 0x0B, 0xF0, 0x37, 0x50, 0x9F, 0x0B, 0x73, 0x01, 0x0E, 0xE0, 0xB7,
  0x40, 0x5F, 0x0D, 0x01, 0x74, 0x07, 0xF0, 0x27, 0x20, 0x20, 0xEF, 0x03, 0x75, 0x01, 0xF0, 0x87,
  0x20, 0xBF, 0x08, 0x77, 0x0C, 0xE0, 0xB7, 0x10, 0x4F, 0x0E, 0x01, 0x77, 0x09, 0xF7, 0x10, 0xCF,
  0x08, 0x77, 0x10, 0x7F, 0x03, 0x60, 0x4F, 0x90, 0x27, 0x71, 0x05, 0xF0, 0x46, 0x0A, 0xF0, 0xA7,
  0x72, 0x05, 0xF0, 0x55, 0x01, 0xF9, 0x05, 0x77, 0x20, 0x4F, 0x06, 0x50, 0x6F, 0x97, 0x73, 0x04,
  0xF0, 0x75, 0x0A, 0xF0, 0xB7, 0x73, 0x04, 0xF0, 0x75, 0x0E, 0xF0, 0x77, 0x73, 0x05, 0xF0, 0x64,
  0x02, 0xF9, 0x03, 0x77, 0x30, 0x6F, 0x05, 0x40, 0x4F, 0x90, 0x17, 0x73, 0x08, 0xF0, 0x44, 0x07,
  0xF0, 0xE7, 0x74, 0x0A, 0xF0, 0x34, 0x09, 0xF0, 0xB7, 0x74, 0x0C, 0xF0, 0x24, 0x0A, 0xF0, 0xA7,
  0x74, 0x0E, 0xF5, 0x0B, 0xF0, 0x97, 0x73, 0x01, 0xF0, 0xE5, 0x0B, 0xF0, 0x87, 0x73, 0x03, 0xF0,
  0xC5, 0x0C, 0xF0, 0x77, 0x73, 0x06, 0xF0, 0x95, 0x0B, 0xF0, 0x87, 0x73, 0x0A, 0xF0, 0x75, 0x09,
  0xF0, 0x97, 0x72, 0x01, 0x0E, 0xF0, 0x45, 0x07, 0xF0, 0xB7, 0x72, 0x0A, 0xF9, 0x02, 0x50, 0x4F,
  0x0E, 0x77, 0x10, 0x6F, 0x90, 0xE6, 0x01, 0xF9, 0x03, 0x76, 0x04, 0xFA, 0x0B, 0x70, 0xAF, 0x0A,
  0x75, 0x04, 0x0E, 0xFA, 0x08, 0x70, 0x4F, 0x90, 0x47, 0x30, 0x5F, 0xC0, 0x47, 0x10, 0xCF, 0x0E,
  0x03, 0x70, 0x10, 0x9B, 0x0E, 0xF9, 0x01, 0x71, 0x02, 0xFA, 0x86, 0x93, 0x10, 0x14, 0x8E, 0xB0,
  0xD0, 0x7F, 0x0D, 0x73, 0x06, 0xFF, 0xC8, 0x1B, 0x1A, 0xF0, 0x97, 0x40, 0x6F, 0xFA, 0x07, 0x20,
  0xEF, 0x04, 0x75, 0x04, 0x0D, 0xFD, 0x0C, 0x03, 0x20, 0x3F, 0x97, 0x71, 0x06, 0x0B, 0xF8, 0x1E,
  0xA4, 0x40, 0x8F, 0x0B, 0x77, 0x48, 0x43, 0x45, 0x54, 0x27, 0x0C, 0xF0, 0x67, 0x77, 0x72, 0x02,
  0xF9, 0x01, 0x77, 0x77, 0x20, 0x6F, 0x0B, 0x77, 0x77, 0x30, 0xCF, 0x05, 0x77, 0x77, 0x20, 0x2F,
  0x0E, 0x77, 0x77, 0x30, 0x7F, 0x09, 0x77, 0x77, 0x30, 0xDF, 0x03, 0x77, 0x77, 0x20, 0x3F, 0x0C,
  0x77, 0x77, 0x30, 0x9F, 0x05, 0x77, 0x77, 0x20, 0x10, 0xEE, 0x0D, 0x77, 0x77, 0x30, 0x7F, 0x06,
  0x77, 0x77, 0x30, 0xDE, 0x0D, 0x75, 0x81, 0x49, 0x57, 0x72, 0x06, 0xF0, 0x47, 0x40, 0xBA, 0x09,
  0x77, 0x20, 0xDE, 0x0A, 0x74, 0x0A, 0xB0, 0xB7, 0x71, 0x07, 0xE0, 0xE0, 0x17, 0x30, 0x4C, 0x0D,
  0x77, 0x02, 0xF0, 0x57, 0x40, 0x9D, 0x01, 0x76, 0x0C, 0xE0, 0xA7, 0x50, 0xCD, 0x07, 0x75, 0x09,
  0xE0, 0xD7, 0x60, 0xCD, 0x0D, 0x74, 0x06, 0xE0, 0xE0, 0x27, 0x60, 0xAE, 0x09, 0x72, 0x07, 0xE0,
  0xE0, 0x37, 0x70, 0x6F, 0x07, 0x60, 0x30, 0xCE, 0x0E, 0x03, 0x77, 0x10, 0x1F, 0x98, 0x4D, 0x86,
  0x79, 0xDF, 0x0D, 0x02, 0x77, 0x30, 0x7F, 0xFD, 0x09, 0x77, 0x60, 0x8F, 0xFA, 0x0D, 0x04, 0x77,
  0x71, 0x04, 0x0D, 0xFD, 0x0C, 0x06, 0x77, 0x75, 0x83, 0x38, 0xBD, 0xEA, 0x83, 0xEC, 0xA6, 0x27,
  0x77, 0x20,
  // ":" (U+003A)
  0x74, 0x85, 0x18, 0xDF, 0xE9, 0x27, 0x50, 0x20, 0xDD, 0x0E, 0x03, 0x74, 0x0C, 0xF0, 0xD7, 0x30,
  0x6F, 0xA0, 0x27, 0x20, 0xBF, 0xA0, 0x47, 0x2F, 0xB0, 0x47, 0x10, 0x1F, 0xB0, 0x37, 0x10, 0x1F,
  0xB7, 0x30, 0xEF, 0x90, 0xB7, 0x30, 0xAF, 0x90, 0x37, 0x30, 0x20, 0xEE, 0x05, 0x75, 0x85, 0x19,
  0xDF, 0xD9, 0x28, 0x0F, 0xE6, 0x08, 0x51, 0x8D, 0xFE, 0x92, 0x75, 0x03, 0x0E, 0xD0, 0xE0, 0x27,
  0x30, 0x10, 0xDF, 0x0B, 0x73, 0x08, 0xFA, 0x01, 0x72, 0x0D, 0xFA, 0x03, 0x71, 0x01, 0xFB, 0x03,
  0x71, 0x02, 0xFB, 0x01, 0x71, 0x02, 0xFA, 0x0E, 0x73, 0xFA, 0x09, 0x73, 0x0B, 0xF0, 0xE0, 0x27,
  0x30, 0x20, 0xED, 0x0E, 0x04, 0x75, 0x85, 0x29, 0xEF, 0xD9, 0x17, 0x40,
  // ";" (U+003B)
  0x77, 0x85, 0x18, 0xDF, 0xE9, 0x27, 0x71, 0x02, 0x0D, 0xD0, 0xE0, 0x37, 0x70, 0xCF, 0x0D, 0x76,
  0x06, 0xFA, 0x02, 0x75, 0x0B, 0xFA, 0x04, 0x75, 0xFB, 0x04, 0x74, 0x01, 0xFB, 0x03, 0x74, 0x01,
  0xFB, 0x76, 0x0E, 0xF9, 0x0B, 0x76, 0x0A, 0xF9, 0x03, 0x76, 0x02, 0x0E, 0xD0, 0xE0, 0x57, 0x71,
  0x85, 0x19, 0xDF, 0xD9, 0x28, 0x09, 0x98, 0x40, 0x84, 0x5C, 0xFE, 0xC6, 0x77, 0x20, 0xAE, 0x0B,
  0x77, 0x07, 0xF9, 0x0A, 0x76, 0x0D, 0xFA, 0x03, 0x75, 0xFB, 0x09, 0x74, 0x01, 0xFB, 0x0D, 0x75,
  0xFC, 0x75, 0x0A, 0xFB, 0x75, 0x01, 0x0E, 0xF9, 0x0E, 0x76, 0x02, 0x0D, 0xF0, 0xD7, 0x70, 0x10,
  0xCE, 0x0B, 0x77, 0x10, 0x10, 0xDD, 0x07, 0x77, 0x20, 0x8D, 0x03, 0x77, 0x20, 0x7C, 0x0D, 0x77,
  0x30, 0x9C, 0x06, 0x77, 0x30, 0xEB, 0x0E, 0x77, 0x30, 0x7C, 0x05, 0x77, 0x20, 0x4C, 0x0A, 0x77,
  0x20, 0x7C, 0x0C, 0x77, 0x10, 0x50, 0xDC, 0x0C, 0x76, 0x81, 0x39, 0xED, 0x0A, 0x01, 0x76, 0x09,
  0xD0, 0xE0, 0x57, 0x71, 0x0B, 0xB8, 0x1E, 0x71, 0x77, 0x28, 0x2D, 0xEA, 0x57, 0x75, 0x03, 0x77,
  0x71,
  // "<" (U+003C)
  0x77, 0x77, 0x50, 0x17, 0x77, 0x73, 0x81, 0x4D, 0x57, 0x77, 0x71, 0x01, 0x0A, 0xA0, 0x57, 0x77,
  0x70, 0x60, 0xEB, 0x05, 0x77, 0x75, 0x02, 0x0B, 0xD0, 0x57, 0x77, 0x40, 0x8F, 0x05, 0x77, 0x72,
  0x04, 0x0D, 0xF0, 0xD0, 0x27, 0x77, 0x01, 0x09, 0xF9, 0x09, 0x77, 0x71, 0x05, 0x0E, 0xF0, 0xC0,
  0x37, 0x77, 0x02, 0x0B, 0xF9, 0x07, 0x77, 0x71, 0x07, 0xF9, 0x0C, 0x02, 0x77, 0x70, 0x30, 0xDF,
  0x0E, 0x06, 0x77, 0x70, 0x10, 0x9F, 0x90, 0xB0, 0x17, 0x77, 0x05, 0x0E, 0xF0, 0xE0, 0x57, 0x77,
  0x02, 0x0B, 0xF9, 0x0A, 0x01, 0x77, 0x70, 0x70, 0xEF, 0x0D, 0x04, 0x77, 0x70, 0x30, 0xCF, 0x90,
  0x87, 0x77, 0x10, 0x9F, 0x90, 0xC0, 0x37, 0x77, 0x05, 0x0D, 0xF9, 0x07, 0x77, 0x70, 0x10, 0xAF,
  0x90, 0xC0, 0x27, 0x77, 0x06, 0x0E, 0xF0, 0xE0, 0x67, 0x77, 0x10, 0x8F, 0x90, 0xB0, 0x17, 0x77,
  0x20, 0x9E, 0x0E, 0x05, 0x77, 0x74, 0x09, 0xF0, 0x90, 0x17, 0x77, 0x30, 0x50, 0xEF, 0x0E, 0x05,
  0x77, 0x73, 0x02, 0x0B, 0xF9, 0x0B, 0x01, 0x77, 0x73, 0x05, 0x0E, 0xF0, 0xE0, 0x77, 0x77, 0x30,
  0x10, 0x9F, 0x90, 0xC0, 0x37, 0x77, 0x30, 0x30, 0xCF, 0x90, 0x87, 0x77, 0x40, 0x70, 0xEF, 0x0D,
  0x04, 0x77, 0x73, 0x02, 0x0B, 0xF9, 0x0A, 0x01, 0x77, 0x73, 0x05, 0x0E, 0xF0, 0xE0, 0x67, 0x77,
  0x30, 0x10, 0x9F, 0x90, 0xB0, 0x27, 0x77, 0x30, 0x30, 0xCF, 0x90, 0x77, 0x77, 0x40, 0x7F, 0x90,
  0xD0, 0x37, 0x77, 0x30, 0x20, 0xBF, 0x90, 0x90, 0x17, 0x77, 0x30, 0x50, 0xEF, 0x0E, 0x05, 0x77,
  0x73, 0x01, 0x09, 0xF9, 0x0B, 0x01, 0x77, 0x73, 0x03, 0x0C, 0xF0, 0xE0, 0x77, 0x77, 0x40, 0x7F,
  0x90, 0x57, 0x77, 0x40, 0x20, 0xBE, 0x05, 0x77, 0x76, 0x05, 0x0E, 0xC0, 0x57, 0x77, 0x70, 0x10,
  0x9B, 0x05, 0x77, 0x77, 0x28, 0x23, 0xDF, 0x57, 0x77, 0x74, 0x07, 0x04,
  // "=" (U+003D)
  0x09, 0xFF, 0xFF, 0xC0, 0x60, 0x9F, 0xFF, 0xFC, 0x06, 0x09, 0xFF, 0xFF, 0xC0, 0x60, 0x9F, 0xFF,
  0xFC, 0x06, 0x09, 0xFF, 0xFF, 0xC0, 0x68, 0x0E, 0xA4, 0x00, 0x9F, 0xFF, 0xFC, 0x06, 0x09, 0xFF,
  0xFF, 0xC0, 0x60, 0x9F, 0xFF, 0xFC, 0x06, 0x09, 0xFF, 0xFF, 0xC0, 0x60, 0x9F, 0xFF, 0xFC, 0x06,
  // ">" (U+003E)
  0x02, 0x77, 0x77, 0x58, 0x19, 0xB2, 0x77, 0x77, 0x30, 0x9A, 0x07, 0x77, 0x77, 0x20, 0x9B, 0x0D,
  0x03, 0x77, 0x77, 0x09, 0xD0, 0x90, 0x17, 0x77, 0x50, 0x9E, 0x0E, 0x05, 0x77, 0x74, 0x05, 0x0E,
  0xF0, 0xB0, 0x27, 0x77, 0x30, 0x20, 0xBF, 0x90, 0x77, 0x77, 0x40, 0x50, 0xEF, 0x0C, 0x03, 0x77,
  0x73, 0x01, 0x0A, 0xF9, 0x09, 0x77, 0x74, 0x04, 0x0D, 0xF0, 0xE0, 0x57, 0x77, 0x40, 0x9F, 0x90,
  0xA0, 0x17, 0x77, 0x30, 0x30, 0xDF, 0x0E, 0x07, 0x77, 0x74, 0x08, 0xF9, 0x0C, 0x03, 0x77, 0x73,
  0x02, 0x0C, 0xF9, 0x08, 0x77, 0x74, 0x07, 0x0E, 0xF0, 0xD0, 0x47, 0x77, 0x30, 0x20, 0xBF, 0x90,
  0xA0, 0x17, 0x77, 0x30, 0x50, 0xEF, 0x0E, 0x06, 0x77, 0x73, 0x01, 0x0A, 0xF9, 0x0C, 0x02, 0x77,
  0x73, 0x04, 0x0D, 0xF9, 0x08, 0x77, 0x74, 0x09, 0xF9, 0x0D, 0x04, 0x77, 0x73, 0x03, 0x0D, 0xF9,
  0x04, 0x77, 0x74, 0x08, 0xF0, 0x57, 0x77, 0x30, 0x20, 0xBF, 0x05, 0x77, 0x72, 0x07, 0xF9, 0x0D,
  0x02, 0x77, 0x70, 0x30, 0xDF, 0x90, 0x87, 0x77, 0x01, 0x09, 0xF9, 0x0C, 0x03, 0x77, 0x70, 0x50,
  0xEF, 0x0E, 0x06, 0x77, 0x70, 0x20, 0xBF, 0x90, 0xA0, 0x17, 0x77, 0x07, 0x0E, 0xF0, 0xD0, 0x47,
  0x77, 0x03, 0x0C, 0xF9, 0x08, 0x77, 0x71, 0x08, 0xF9, 0x0C, 0x03, 0x77, 0x70, 0x40, 0xDF, 0x0E,
  0x06, 0x77, 0x70, 0x10, 0xAF, 0x90, 0xA0, 0x17, 0x77, 0x06, 0x0E, 0xF0, 0xD0, 0x57, 0x77, 0x02,
  0x0B, 0xF9, 0x08, 0x77, 0x71, 0x07, 0xF9, 0x0C, 0x03, 0x77, 0x70, 0x30, 0xDF, 0x0E, 0x07, 0x77,
  0x70, 0x10, 0x9F, 0x90, 0xA0, 0x17, 0x77, 0x10, 0x9F, 0x0D, 0x05, 0x77, 0x73, 0x09, 0xE0, 0x97,
  0x77, 0x50, 0x9C, 0x0C, 0x03, 0x77, 0x76, 0x09, 0xA0, 0xE0, 0x77, 0x77, 0x71, 0x82, 0x9F, 0xA1,
  0x77, 0x77, 0x20, 0x70, 0x57, 0x77, 0x74,
  // "?" (U+003F)
  0x74, 0x89, 0x33, 0x7A, 0xCE, 0xEF, 0xED, 0xC9, 0x52, 0x77, 0x38, 0x12, 0x9E, 0xFE, 0x0B, 0x04,
  0x76, 0x01, 0x09, 0xFF, 0xC0, 0xB0, 0x17, 0x30, 0x40, 0xEF, 0xFE, 0x0E, 0x04, 0x71, 0x06, 0xFA,
  0x84, 0xB8, 0x67, 0xAE, 0xF9, 0x0E, 0x02, 0x60, 0x5F, 0x90, 0xA0, 0x15, 0x01, 0x0A, 0xF9, 0x0D,
  0x50, 0x2F, 0x90, 0x87, 0x20, 0x9F, 0x90, 0x74, 0x0B, 0xF0, 0x97, 0x40, 0xCF, 0x0E, 0x01, 0x20,
  0x3F, 0x0E, 0x75, 0x04, 0xF9, 0x05, 0x20, 0x8F, 0x06, 0x76, 0x0E, 0xF0, 0x92, 0x0C, 0xE0, 0xE7,
  0x70, 0xAF, 0x0D, 0x20, 0xDE, 0x09, 0x77, 0x07, 0xF0, 0xE2, 0x0D, 0xE0, 0x47, 0x70, 0x6F, 0x92,
  0x0B, 0xE7, 0x71, 0x05, 0xF9, 0x81, 0x10, 0x6D, 0x0B, 0x77, 0x10, 0x5F, 0x90, 0x12, 0x0B, 0xC0,
  0x87, 0x71, 0x06, 0xF9, 0x40, 0x70, 0xDA, 0x05, 0x77, 0x10, 0x8F, 0x0E, 0x60, 0x20, 0x37, 0x72,
  0x0A, 0xF0, 0xB7, 0x77, 0x30, 0xDF, 0x08, 0x77, 0x72, 0x02, 0xF9, 0x04, 0x77, 0x72, 0x07, 0xF0,
  0xE7, 0x77, 0x30, 0xDF, 0x09, 0x77, 0x72, 0x06, 0xF9, 0x02, 0x77, 0x71, 0x01, 0x0E, 0xF0, 0x97,
  0x77, 0x20, 0xAF, 0x0D, 0x01, 0x77, 0x71, 0x07, 0xF9, 0x04, 0x77, 0x71, 0x06, 0xF9, 0x07, 0x77,
  0x71, 0x07, 0xF9, 0x09, 0x77, 0x71, 0x08, 0xF9, 0x09, 0x77, 0x70, 0x10, 0xCF, 0x90, 0x87, 0x77,
  0x05, 0x0E, 0xF0, 0xE0, 0x57, 0x76, 0x02, 0x0B, 0xF9, 0x0C, 0x02, 0x77, 0x50, 0x20, 0x9F, 0xA0,
  0x87, 0x75, 0x02, 0x09, 0xFA, 0x0B, 0x02, 0x77, 0x60, 0xCF, 0x90, 0xD0, 0x57, 0x77, 0x10, 0xEE,
  0x0D, 0x06, 0x77, 0x72, 0x01, 0xD0, 0xD0, 0x57, 0x77, 0x40, 0x3D, 0x03, 0x77, 0x75, 0x05, 0xC0,
  0xE7, 0x77, 0x60, 0x8C, 0x0B, 0x77, 0x76, 0x0A, 0xC0, 0x77, 0x77, 0x60, 0xCC, 0x03, 0x77, 0x76,
  0x0E, 0xB0, 0xE7, 0x77, 0x60, 0x1C, 0x0A, 0x77, 0x76, 0x03, 0xC0, 0x67, 0x77, 0x60, 0x6C, 0x02,
  0x77, 0x76, 0x08, 0xB0, 0xE8, 0x0B, 0xF5, 0x08, 0x44, 0xBE, 0xFC, 0x67, 0x77, 0x50, 0x8E, 0x0A,
  0x77, 0x73, 0x06, 0xF9, 0x05, 0x77, 0x72, 0x0E, 0xF9, 0x0A, 0x77, 0x71, 0x04, 0xFA, 0x0B, 0x77,
  0x71, 0x08, 0xFA, 0x0B, 0x77, 0x71, 0x09, 0xFA, 0x0A, 0x77, 0x71, 0x09, 0xFA, 0x07, 0x77, 0x71,
  0x07, 0xFA, 0x03, 0x77, 0x71, 0x03, 0xF9, 0x0A, 0x77, 0x73, 0x08, 0xE0, 0xB7, 0x77, 0x58, 0x45,
  0xCE, 0xEC, 0x57, 0x77, 0x40,
  // "@" (U+0040)
  0x77, 0x77, 0x28, 0x96, 0x35, 0x8B, 0xCD, 0xEF, 0xEE, 0xDC, 0xA7, 0x41, 0x80, 0xD0, 0x08, 0x21,
  0x5A, 0xEF, 0xFA, 0x81, 0xC7, 0x28, 0x0C, 0x30, 0x03, 0x0A, 0xFF, 0xFA, 0x0B, 0x02, 0x77, 0x77,
  0x70, 0x40, 0xCF, 0xFF, 0xE0, 0xA0, 0x17, 0x77, 0x73, 0x02, 0x0B, 0xFB, 0x89, 0x1E, 0xB9, 0x87,
  0x67, 0x79, 0xBE, 0xFA, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x8F, 0xA8, 0x1C, 0x72, 0x74, 0x81, 0x38,
  0xDF, 0x90, 0x87, 0x77, 0x50, 0x20, 0xCF, 0x81, 0xE9, 0x27, 0x73, 0x04, 0x0C, 0xF0, 0x97, 0x77,
  0x30, 0x50, 0xEF, 0x08, 0x01, 0x77, 0x70, 0x50, 0xEE, 0x09, 0x77, 0x71, 0x07, 0xF0, 0xB0, 0x27,
  0x77, 0x30, 0x10, 0xCE, 0x07, 0x77, 0x60, 0x9F, 0x07, 0x77, 0x77, 0x0B, 0xE0, 0x37, 0x74, 0x09,
  0xE0, 0xE0, 0x47, 0x77, 0x72, 0x0B, 0xD0, 0xD7, 0x73, 0x08, 0xE0, 0xD0, 0x27, 0x77, 0x74, 0x0D,
  0xD0, 0x77, 0x71, 0x06, 0xE0, 0xD0, 0x17, 0x77, 0x75, 0x02, 0xD0, 0xE0, 0x17, 0x60, 0x4E, 0x0D,
  0x01, 0x77, 0x77, 0x70, 0x7D, 0x08, 0x75, 0x01, 0x0E, 0xD0, 0xE0, 0x28, 0x0C, 0x10, 0x0E, 0xC0,
  0xE7, 0x50, 0xBE, 0x03, 0x80, 0xC2, 0x00, 0x7D, 0x05, 0x73, 0x07, 0xE0, 0x77, 0x78, 0x91, 0x15,
  0x9C, 0xDE, 0xFD, 0xC8, 0x26, 0x00, 0x16, 0x01, 0xD0, 0xB7, 0x20, 0x10, 0xED, 0x0B, 0x76, 0x03,
  0x0A, 0xFC, 0x0A, 0x01, 0x28, 0x22, 0xCF, 0x97, 0x0A, 0xD7, 0x20, 0xAD, 0x0E, 0x01, 0x74, 0x01,
  0x0A, 0xFF, 0x81, 0xE4, 0x8B, 0x06, 0x70, 0x6D, 0x04, 0x70, 0x4E, 0x06, 0x74, 0x04, 0x0E, 0xFF,
  0xF0, 0x37, 0x02, 0xD0, 0x87, 0x0C, 0xD0, 0xC7, 0x40, 0x6F, 0x85, 0xE9, 0x41, 0x02, 0x8F, 0xA7,
  0x20, 0xEC, 0x0B, 0x60, 0x4E, 0x04, 0x73, 0x07, 0xF0, 0xB0, 0x16, 0x04, 0xF0, 0xC7, 0x20, 0xBC,
  0x0E, 0x60, 0xBD, 0x0B, 0x73, 0x05, 0xF0, 0x97, 0x20, 0x8E, 0x09, 0x72, 0x09, 0xD5, 0x03, 0xE0,
  0x47, 0x20, 0x3F, 0x09, 0x73, 0x05, 0xE0, 0x67, 0x20, 0x7D, 0x03, 0x40, 0xAD, 0x0C, 0x73, 0x0D,
  0xE0, 0xC7, 0x40, 0x8E, 0x03, 0x72, 0x05, 0xD0, 0x43, 0x01, 0xE0, 0x57, 0x20, 0x8E, 0x0E, 0x02,
  0x74, 0x0B, 0xE7, 0x30, 0x5D, 0x04, 0x30, 0x6D, 0x0E, 0x72, 0x01, 0xF0, 0x77, 0x50, 0xED, 0x0D,
  0x73, 0x04, 0xD0, 0x53, 0x0C, 0xD0, 0x97, 0x20, 0x9E, 0x0E, 0x75, 0x02, 0xE0, 0xA7, 0x30, 0x4D,
  0x06, 0x20, 0x1E, 0x03, 0x71, 0x01, 0xF0, 0x77, 0x50, 0x5E, 0x07, 0x73, 0x04, 0xD0, 0x52, 0x06,
  0xD0, 0xE7, 0x20, 0x8F, 0x01, 0x75, 0x08, 0xE0, 0x47, 0x30, 0x5D, 0x05, 0x20, 0xAD, 0x0A, 0x72,
  0x0E, 0xE0, 0xA7, 0x60, 0xBE, 0x01, 0x73, 0x05, 0xD0, 0x42, 0x0E, 0xD0, 0x57, 0x10, 0x5F, 0x04,
  0x76, 0x0E, 0xD0, 0xD7, 0x40, 0x6D, 0x81, 0x30, 0x3E, 0x01, 0x71, 0x0A, 0xE0, 0xE7, 0x60, 0x2E,
  0x0A, 0x74, 0x07, 0xD8, 0x12, 0x06, 0xD0, 0xD7, 0x20, 0xEE, 0x0B, 0x76, 0x05, 0xE0, 0x77, 0x40,
  0x8D, 0x20, 0x9D, 0x0A, 0x71, 0x03, 0xF0, 0x67, 0x60, 0x8E, 0x04, 0x74, 0x09, 0xC0, 0xE2, 0x0C,
  0xD0, 0x77, 0x10, 0x6F, 0x03, 0x76, 0x0B, 0xE0, 0x17, 0x40, 0xCC, 0x0C, 0x2E, 0x04, 0x71, 0x0A,
  0xF7, 0x70, 0xED, 0x0D, 0x75, 0x0E, 0xC8, 0x19, 0x01, 0xE0, 0x27, 0x10, 0xCE, 0x0C, 0x76, 0x01,
  0xE0, 0xA7, 0x40, 0x1D, 0x81, 0x60, 0x3E, 0x01, 0x71, 0xF0, 0x97, 0x60, 0x4E, 0x07, 0x74, 0x04,
  0xD8, 0x13, 0x05, 0xD0, 0xE7, 0x10, 0x1F, 0x07, 0x76, 0x08, 0xE0, 0x47, 0x40, 0x7D, 0x20, 0x7D,
  0x0D, 0x71, 0x03, 0xF0, 0x57, 0x60, 0xBE, 0x01, 0x74, 0x0B, 0xC0, 0xB2, 0x08, 0xD0, 0xB7, 0x10,
  0x4F, 0x04, 0x76, 0x0E, 0xD0, 0xE7, 0x5D, 0x06, 0x20, 0x8D, 0x0B, 0x71, 0x04, 0xF0, 0x37, 0x50,
  0x2E, 0x0C, 0x74, 0x05, 0xD0, 0x22, 0x09, 0xD0, 0xA7, 0x10, 0x3F, 0x02, 0x75, 0x05, 0xE0, 0xA7,
  0x40, 0xAC, 0x0B, 0x30, 0x9D, 0x0A, 0x71, 0x02, 0xF0, 0x37, 0x50, 0xAE, 0x09, 0x73, 0x01, 0xD0,
  0x53, 0x0A, 0xD0, 0x97, 0x10, 0x1F, 0x04, 0x74, 0x01, 0xF0, 0x87, 0x30, 0x7C, 0x0E, 0x40, 0xAD,
  0x09, 0x72, 0x0E, 0xE0, 0x67, 0x40, 0x7F, 0x08, 0x73, 0x0E, 0xC0, 0x64, 0x09, 0xD0, 0xA7, 0x20,
  0xAE, 0x0A, 0x74, 0x0E, 0xF0, 0x97, 0x20, 0x7C, 0x0D, 0x50, 0x8D, 0x0B, 0x72, 0x07, 0xE0, 0xE7,
  0x30, 0x8A, 0x00, 0xDC, 0x0C, 0x71, 0x02, 0xD0, 0x55, 0x08, 0xD0, 0xB7, 0x20, 0x1F, 0x07, 0x71,
  0x04, 0xB0, 0x50, 0x6D, 0x02, 0x70, 0xCC, 0x0B, 0x60, 0x7D, 0x0C, 0x73, 0x09, 0xF0, 0x46, 0x04,
  0x0E, 0xA8, 0x2B, 0x01, 0xEC, 0x0B, 0x50, 0x10, 0xBC, 0x0E, 0x01, 0x60, 0x5D, 0x0E, 0x73, 0x01,
  0x0E, 0xF8, 0x48, 0x20, 0x14, 0x9B, 0x0E, 0x01, 0x20, 0x8D, 0x84, 0xC4, 0x01, 0x5D, 0xD0, 0x37,
  0x02, 0xE0, 0x17, 0x30, 0x3F, 0xFA, 0x03, 0x30, 0x10, 0xDF, 0xF0, 0x57, 0x2E, 0x03, 0x74, 0x04,
  0x0E, 0xFE, 0x05, 0x50, 0x3F, 0xD0, 0xE0, 0x47, 0x30, 0xDD, 0x06, 0x75, 0x02, 0x0C, 0xFB, 0x0E,
  0x04, 0x70, 0x40, 0xEF, 0xA0, 0xB0, 0x27, 0x40, 0xAD, 0x0A, 0x77, 0x05, 0x0B, 0xE8, 0x1D, 0x71,
  0x72, 0x81, 0x19, 0xED, 0x0B, 0x05, 0x76, 0x06, 0xD0, 0xE7, 0x72, 0x84, 0x13, 0x55, 0x42, 0x77,
  0x18, 0x33, 0x55, 0x41, 0x77, 0x10, 0x1E, 0x03, 0x80, 0xE5, 0x00, 0xCD, 0x09, 0x80, 0xE5, 0x00,
  0x7D, 0x0E, 0x01, 0x80, 0xE4, 0x00, 0x1E, 0x06, 0x80, 0xE5, 0x00, 0x9D, 0x0E, 0x01, 0x80, 0xE4,
  0x00, 0x2E, 0x09, 0x80, 0xE5, 0x00, 0x9E, 0x03, 0x80, 0xE4, 0x00, 0x10, 0xED, 0x0D, 0x01, 0x77,
  0x77, 0x70, 0x27, 0x76, 0x05, 0xE0, 0xC7, 0x77, 0x76, 0x81, 0x5E, 0x87, 0x76, 0x09, 0xE0, 0xB7,
  0x77, 0x73, 0x01, 0x0A, 0xB0, 0x27, 0x76, 0x0C, 0xE0, 0xC0, 0x17, 0x77, 0x70, 0x70, 0xEC, 0x08,
  0x77, 0x60, 0x10, 0xDE, 0x0E, 0x06, 0x77, 0x74, 0x06, 0x0D, 0xD0, 0x87, 0x77, 0x10, 0x10, 0xCF,
  0x0B, 0x04, 0x77, 0x68, 0x11, 0x6D, 0xD0, 0xD0, 0x47, 0x77, 0x30, 0x10, 0xBF, 0x98, 0x1C, 0x61,
  0x77, 0x10, 0x40, 0xAF, 0x09, 0x77, 0x77, 0x08, 0xFB, 0x84, 0xC8, 0x53, 0x11, 0x28, 0x41, 0x23,
  0x68, 0xBF, 0x90, 0xB0, 0x37, 0x77, 0x72, 0x02, 0x0C, 0xFF, 0xFF, 0x0C, 0x05, 0x77, 0x77, 0x60,
  0x50, 0xCF, 0xFF, 0xB0, 0xC0, 0x58, 0x0C, 0x20, 0x81, 0x4A, 0xEF, 0xFC, 0x81, 0xE9, 0x38, 0x0C,
  0x70, 0x82, 0x48, 0xBE, 0xFB, 0x82, 0xEB, 0x73, 0x80, 0xD6, 0x08, 0x71, 0x34, 0x55, 0x55, 0x43,
  0x77, 0x77, 0x40,
  // "A" (U+0041)
  0x80, 0xC2, 0x00, 0x8E, 0x0B, 0x80, 0xD4, 0x00, 0x10, 0xEE, 0x0D, 0x80, 0xD4, 0x00, 0x9F, 0x0E,
  0x80, 0xD3, 0x00, 0x2F, 0xA8, 0x0D, 0x30, 0x0A, 0xFA, 0x02, 0x80, 0xD1, 0x00, 0x3F, 0xB0, 0x38,
  0x0D, 0x10, 0x0B, 0xFB, 0x05, 0x80, 0xD0, 0x00, 0x4F, 0xC0, 0x68, 0x0D, 0x00, 0x0C, 0xB0, 0xCF,
  0x08, 0x80, 0xC7, 0x00, 0x5C, 0x05, 0xF0, 0x98, 0x0C, 0x70, 0x0D, 0xB0, 0xB0, 0x2F, 0x0B, 0x80,
  0xC6, 0x00, 0x6C, 0x04, 0x02, 0xF0, 0xD8, 0x0C, 0x60, 0x0D, 0xB8, 0x1D, 0x01, 0xF0, 0xE8, 0x0C,
  0x50, 0x07, 0xC8, 0x16, 0x01, 0xF9, 0x80, 0xC4, 0x00, 0x10, 0xEB, 0x0E, 0x3F, 0x90, 0x28, 0x0C,
  0x30, 0x08, 0xC0, 0x73, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x10, 0xEB, 0x0E, 0x40, 0xDF, 0x05, 0x80,
  0xC2, 0x00, 0x9C, 0x06, 0x40, 0xCF, 0x06, 0x80, 0xC1, 0x00, 0x2C, 0x0D, 0x50, 0xBF, 0x08, 0x80,
  0xC1, 0x00, 0xAC, 0x05, 0x50, 0xAF, 0x09, 0x80, 0xC0, 0x00, 0x3C, 0x0C, 0x60, 0x8F, 0x0B, 0x80,
  0xC0, 0x00, 0xBC, 0x04, 0x60, 0x7F, 0x0D, 0x77, 0x77, 0x70, 0x4C, 0x0C, 0x70, 0x6F, 0x0E, 0x77,
  0x77, 0x70, 0xCC, 0x03, 0x70, 0x4F, 0x97, 0x77, 0x76, 0x05, 0xC0, 0xB7, 0x10, 0x3F, 0x90, 0x27,
  0x77, 0x75, 0x0D, 0xC0, 0x37, 0x10, 0x1F, 0x90, 0x37, 0x77, 0x74, 0x06, 0xC0, 0xA7, 0x3F, 0x90,
  0x57, 0x77, 0x74, 0x0E, 0xC0, 0x27, 0x30, 0xEF, 0x06, 0x77, 0x77, 0x30, 0x7C, 0x09, 0x74, 0x0D,
  0xF0, 0x87, 0x77, 0x72, 0x01, 0x0E, 0xC0, 0x17, 0x40, 0xBF, 0x0A, 0x77, 0x77, 0x20, 0x8C, 0x08,
  0x75, 0x0A, 0xF0, 0xB7, 0x77, 0x71, 0x01, 0xC0, 0xE0, 0x17, 0x50, 0x9F, 0x0D, 0x77, 0x77, 0x10,
  0x9C, 0x08, 0x76, 0x07, 0xF0, 0xE7, 0x77, 0x70, 0x2C, 0x0E, 0x77, 0x06, 0xF9, 0x77, 0x77, 0x0A,
  0xC0, 0x77, 0x70, 0x4F, 0x90, 0x27, 0x77, 0x50, 0x3C, 0x0D, 0x77, 0x10, 0x3F, 0x90, 0x37, 0x77,
  0x50, 0xBC, 0x06, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77, 0x40, 0x4C, 0x0D, 0x77, 0x3F, 0x90, 0x67,
  0x77, 0x40, 0xCF, 0xFF, 0xFA, 0x08, 0x77, 0x73, 0x05, 0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x30, 0xDF,
  0xFF, 0xFB, 0x0B, 0x77, 0x72, 0x06, 0xFF, 0xFF, 0xC0, 0xD7, 0x77, 0x20, 0xEC, 0x08, 0x80, 0x97,
  0x60, 0xBF, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xC7, 0x76, 0x08, 0xF9, 0x77, 0x70, 0x10, 0xEC, 0x04,
  0x77, 0x60, 0x7F, 0x90, 0x27, 0x76, 0x08, 0xC0, 0xB7, 0x77, 0x05, 0xF9, 0x03, 0x77, 0x50, 0x1D,
  0x03, 0x77, 0x70, 0x4F, 0x90, 0x57, 0x75, 0x09, 0xC0, 0xB7, 0x77, 0x10, 0x2F, 0x90, 0x77, 0x74,
  0x02, 0xD0, 0x37, 0x77, 0x10, 0x1F, 0x90, 0x87, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x3F, 0x90, 0xA7,
  0x73, 0x03, 0xD0, 0x27, 0x77, 0x30, 0xEF, 0x0B, 0x77, 0x30, 0xBC, 0x09, 0x77, 0x74, 0x0C, 0xF0,
  0xD7, 0x72, 0x04, 0xD0, 0x27, 0x77, 0x40, 0xBF, 0x0E, 0x77, 0x20, 0xCC, 0x0A, 0x77, 0x75, 0x0A,
  0xF9, 0x77, 0x10, 0x6D, 0x04, 0x77, 0x75, 0x0A, 0xF9, 0x02, 0x76, 0x01, 0x0E, 0xD0, 0x17, 0x77,
  0x50, 0xBF, 0x90, 0x57, 0x60, 0xAD, 0x0E, 0x77, 0x76, 0x0E, 0xF9, 0x08, 0x75, 0x05, 0xE0, 0xE7,
  0x77, 0x50, 0x5F, 0xA0, 0xD7, 0x40, 0x30, 0xEF, 0x04, 0x77, 0x73, 0x03, 0x0E, 0xFB, 0x05, 0x71,
  0x02, 0x08, 0xFA, 0x81, 0xE7, 0x27, 0x76, 0x03, 0x08, 0xFE, 0x07, 0x01, 0x30, 0x9F, 0xFC, 0x0B,
  0x76, 0x03, 0xFF, 0xF8, 0x18, 0x0C, 0xFF, 0xC0, 0x87, 0x60, 0x6F, 0xFF, 0x81, 0x50, 0xEF, 0xFC,
  0x05, 0x76, 0x09, 0xFF, 0xF0, 0x30, 0x2F, 0xFD, 0x02, 0x76, 0x0B, 0xFF, 0xF1,
  // "B" (U+0042)
  0x76, 0x03, 0xFF, 0xF9, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x77, 0x20, 0x7F, 0xFF, 0xF9, 0x81, 0xC7,
  0x17, 0x76, 0x0A, 0xFF, 0xFF, 0xC0, 0x80, 0x17, 0x74, 0x82, 0x9B, 0xCE, 0xFF, 0xFF, 0xA0, 0xD0,
  0x37, 0x77, 0x03, 0x09, 0xFA, 0x0E, 0x80, 0x16, 0x82, 0x78, 0xBE, 0xFC, 0x04, 0x77, 0x71, 0x0B,
  0xF9, 0x0A, 0x72, 0x05, 0x0C, 0xFB, 0x02, 0x77, 0x70, 0x6F, 0x90, 0x77, 0x40, 0x9F, 0xA0, 0xC7,
  0x77, 0x06, 0xF9, 0x03, 0x75, 0x0A, 0xFA, 0x05, 0x77, 0x60, 0x8F, 0x97, 0x60, 0x10, 0xEF, 0x90,
  0xB7, 0x76, 0x0B, 0xF0, 0xC7, 0x70, 0x8F, 0xA7, 0x76, 0xF9, 0x09, 0x77, 0x04, 0xFA, 0x03, 0x77,
  0x40, 0x3F, 0x90, 0x57, 0x71, 0xFA, 0x05, 0x77, 0x40, 0x6F, 0x90, 0x27, 0x71, 0x0E, 0xF9, 0x05,
  0x77, 0x40, 0x9F, 0x0E, 0x77, 0x20, 0xDF, 0x90, 0x57, 0x74, 0x0D, 0xF0, 0xB7, 0x72, 0x0E, 0xF9,
  0x04, 0x77, 0x4F, 0x90, 0x77, 0x72, 0xFA, 0x03, 0x77, 0x30, 0x4F, 0x90, 0x47, 0x72, 0xFA, 0x02,
  0x77, 0x30, 0x7F, 0x90, 0x17, 0x71, 0x03, 0xF9, 0x0E, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x20, 0x6F,
  0x90, 0xA7, 0x74, 0x0D, 0xF0, 0x97, 0x72, 0x0A, 0xF9, 0x06, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x71,
  0x01, 0x0E, 0xF0, 0xE7, 0x74, 0x04, 0xF9, 0x03, 0x77, 0x10, 0x6F, 0x90, 0x87, 0x74, 0x08, 0xF0,
  0xE7, 0x72, 0x0D, 0xF0, 0xE0, 0x17, 0x74, 0x0B, 0xF0, 0xB7, 0x71, 0x09, 0xF9, 0x04, 0x77, 0x50,
  0xEF, 0x08, 0x77, 0x05, 0xF9, 0x07, 0x77, 0x50, 0x2F, 0x90, 0x57, 0x60, 0x7F, 0x90, 0x67, 0x76,
  0x05, 0xF9, 0x01, 0x74, 0x04, 0x0C, 0xF0, 0xE0, 0x57, 0x77, 0x08, 0xF0, 0xD7, 0x83, 0x12, 0x58,
  0xDF, 0x90, 0xA0, 0x17, 0x77, 0x10, 0xCF, 0xFF, 0xD0, 0xB0, 0x37, 0x77, 0x3F, 0xFF, 0xB8, 0x1C,
  0x72, 0x77, 0x74, 0x03, 0xFF, 0xFB, 0x81, 0xB6, 0x17, 0x77, 0x40, 0x6F, 0xFF, 0xD0, 0xE0, 0x87,
  0x77, 0x30, 0x9F, 0x0D, 0x80, 0x36, 0x81, 0x79, 0xCF, 0xB0, 0xD0, 0x27, 0x77, 0x10, 0xCF, 0x09,
  0x74, 0x07, 0x0D, 0xF9, 0x0E, 0x02, 0x77, 0x7F, 0x90, 0x67, 0x50, 0x10, 0xBF, 0x90, 0xD7, 0x76,
  0x03, 0xF9, 0x03, 0x77, 0x0C, 0xF9, 0x09, 0x77, 0x50, 0x7F, 0x97, 0x71, 0x02, 0xFA, 0x01, 0x77,
  0x40, 0xAF, 0x0C, 0x77, 0x20, 0xAF, 0x90, 0x77, 0x74, 0x0D, 0xF0, 0x97, 0x72, 0x05, 0xF9, 0x0C,
  0x77, 0x30, 0x1F, 0x90, 0x57, 0x72, 0x01, 0xFA, 0x77, 0x30, 0x4F, 0x90, 0x27, 0x73, 0x0E, 0xF9,
  0x02, 0x77, 0x20, 0x7F, 0x0E, 0x77, 0x40, 0xDF, 0x90, 0x47, 0x72, 0x0B, 0xF0, 0xB7, 0x74, 0x0D,
  0xF9, 0x04, 0x77, 0x20, 0xEF, 0x08, 0x77, 0x40, 0xDF, 0x90, 0x47, 0x71, 0x02, 0xF9, 0x04, 0x77,
  0x40, 0xEF, 0x90, 0x47, 0x71, 0x05, 0xF9, 0x01, 0x77, 0x4F, 0xA0, 0x37, 0x71, 0x08, 0xF0, 0xD7,
  0x74, 0x01, 0xFA, 0x01, 0x77, 0x10, 0xBF, 0x0A, 0x77, 0x40, 0x4F, 0xA7, 0x72, 0x0E, 0xF0, 0x77,
  0x74, 0x07, 0xF9, 0x0C, 0x77, 0x10, 0x2F, 0x90, 0x47, 0x74, 0x0A, 0xF9, 0x08, 0x77, 0x10, 0x6F,
  0x97, 0x75, 0xFA, 0x04, 0x77, 0x10, 0x9F, 0x0D, 0x77, 0x40, 0x6F, 0x90, 0xE7, 0x72, 0x0C, 0xF0,
  0x97, 0x74, 0x0B, 0xF9, 0x09, 0x77, 0x2F, 0x90, 0x67, 0x73, 0x05, 0xFA, 0x02, 0x77, 0x10, 0x4F,
  0x90, 0x37, 0x73, 0x0D, 0xF9, 0x09, 0x77, 0x20, 0x8F, 0x97, 0x73, 0x09, 0xF9, 0x0D, 0x01, 0x77,
  0x20, 0xEF, 0x0C, 0x77, 0x20, 0x9F, 0xA0, 0x37, 0x72, 0x07, 0xF9, 0x08, 0x77, 0x02, 0x0C, 0xFA,
  0x05, 0x77, 0x20, 0x5F, 0xA0, 0x57, 0x50, 0x40, 0xAF, 0xB0, 0x57, 0x71, 0x03, 0x0A, 0xFB, 0x08,
  0x80, 0x46, 0x81, 0x79, 0xCF, 0xC0, 0xD0, 0x37, 0x58, 0x29, 0xBC, 0xEF, 0xFF, 0xFE, 0x08, 0x76,
  0x01, 0xFF, 0xFF, 0xF8, 0x1E, 0x92, 0x77, 0x04, 0xFF, 0xFF, 0xC8, 0x1E, 0xA5, 0x77, 0x30, 0x8F,
  0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x63, 0x77, 0x60,
  // "C" (U+0043)
  0x77, 0x76, 0x89, 0x42, 0x58, 0xBC, 0xDE, 0xFE, 0xDC, 0xA7, 0x47, 0x77, 0x74, 0x81, 0x27, 0xDF,
  0xF8, 0x1E, 0xA3, 0x77, 0x76, 0x04, 0x0B, 0xFF, 0xE0, 0x90, 0x17, 0x77, 0x20, 0x30, 0xBF, 0xFF,
  0xA0, 0xD0, 0x27, 0x77, 0x08, 0xFA, 0x85, 0xEA, 0x87, 0x68, 0xCF, 0xB0, 0xD7, 0x75, 0x03, 0x0D,
  0xF9, 0x0A, 0x03, 0x70, 0x30, 0xDF, 0xA0, 0x97, 0x73, 0x05, 0xF9, 0x0B, 0x02, 0x73, 0x01, 0x0E,
  0xFA, 0x01, 0x77, 0x10, 0x8F, 0x90, 0x77, 0x60, 0x6F, 0xA0, 0x67, 0x70, 0x9F, 0x0E, 0x04, 0x77,
  0x10, 0xDF, 0x90, 0x87, 0x60, 0x9F, 0x0E, 0x03, 0x77, 0x20, 0x8F, 0x90, 0x97, 0x50, 0x8F, 0x90,
  0x37, 0x73, 0x04, 0xF9, 0x08, 0x74, 0x05, 0xF9, 0x05, 0x77, 0x40, 0x1F, 0x90, 0x57, 0x30, 0x3F,
  0x90, 0x87, 0x76, 0x0E, 0xE0, 0xE0, 0x17, 0x20, 0x10, 0xDF, 0x0C, 0x77, 0x70, 0xCE, 0x06, 0x73,
  0x09, 0xF9, 0x03, 0x77, 0x70, 0xBD, 0x07, 0x73, 0x04, 0xF9, 0x09, 0x77, 0x71, 0x0B, 0xB0, 0xC0,
  0x47, 0x40, 0xDF, 0x0E, 0x01, 0x77, 0x71, 0x82, 0x79, 0x73, 0x75, 0x07, 0xF9, 0x07, 0x80, 0xC2,
  0x00, 0x10, 0xEF, 0x0E, 0x80, 0xC3, 0x00, 0x9F, 0x90, 0x78, 0x0C, 0x20, 0x01, 0xFA, 0x01, 0x80,
  0xC2, 0x00, 0x8F, 0x90, 0x98, 0x0C, 0x30, 0x0E, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x6F, 0x90, 0xC8,
  0x0C, 0x30, 0x0C, 0xF9, 0x07, 0x80, 0xC2, 0x00, 0x2F, 0xA0, 0x28, 0x0C, 0x20, 0x08, 0xF9, 0x0C,
  0x80, 0xC3, 0x00, 0xDF, 0x90, 0x78, 0x0C, 0x20, 0x02, 0xFA, 0x03, 0x80, 0xC2, 0x00, 0x6F, 0x90,
  0xE8, 0x0C, 0x30, 0x0A, 0xF9, 0x0B, 0x80, 0xC3, 0x00, 0xEF, 0x90, 0x78, 0x0C, 0x20, 0x02, 0xFA,
  0x04, 0x80, 0xC2, 0x00, 0x5F, 0xA8, 0x0C, 0x30, 0x07, 0xF9, 0x0D, 0x80, 0xC3, 0x00, 0xAF, 0x90,
  0xA8, 0x0C, 0x30, 0x0C, 0xF9, 0x08, 0x80, 0xC3, 0x00, 0xEF, 0x90, 0x68, 0x0C, 0x30, 0xFA, 0x04,
  0x80, 0xC2, 0x00, 0x1F, 0xA0, 0x28, 0x0C, 0x20, 0x02, 0xFA, 0x01, 0x80, 0xC2, 0x00, 0x2F, 0xA8,
  0x0C, 0x30, 0x03, 0xFA, 0x80, 0xC3, 0x00, 0x3F, 0xA8, 0x0C, 0x30, 0x03, 0xFA, 0x80, 0xC3, 0x00,
  0x2F, 0xA8, 0x0C, 0x30, 0x01, 0xFA, 0x01, 0x80, 0xC3, 0x0F, 0xA0, 0x28, 0x0C, 0x30, 0x0D, 0xF9,
  0x05, 0x80, 0xC3, 0x00, 0xAF, 0x90, 0x88, 0x0C, 0x30, 0x07, 0xF9, 0x0B, 0x80, 0xC3, 0x00, 0x3F,
  0xA0, 0x18, 0x0C, 0x30, 0x0E, 0xF9, 0x06, 0x77, 0x74, 0x0A, 0x02, 0x75, 0x09, 0xF9, 0x0C, 0x77,
  0x73, 0x81, 0x8F, 0x77, 0x50, 0x3F, 0xA0, 0x67, 0x77, 0x10, 0x6A, 0x09, 0x76, 0x0B, 0xF9, 0x0E,
  0x01, 0x77, 0x60, 0x7B, 0x09, 0x76, 0x03, 0xFA, 0x0C, 0x77, 0x50, 0x9C, 0x06, 0x77, 0x09, 0xFA,
  0x0C, 0x02, 0x77, 0x10, 0x20, 0xCD, 0x01, 0x77, 0x10, 0xDF, 0xA0, 0xE0, 0x77, 0x50, 0x20, 0x8E,
  0x09, 0x77, 0x20, 0x20, 0xEF, 0xB8, 0x3E, 0xA6, 0x31, 0x28, 0x31, 0x24, 0x7B, 0xF0, 0xE0, 0x17,
  0x73, 0x03, 0x0E, 0xFF, 0xFF, 0x04, 0x77, 0x50, 0x30, 0xDF, 0xFF, 0xD0, 0x57, 0x77, 0x01, 0x0A,
  0xFF, 0xFA, 0x0D, 0x03, 0x77, 0x73, 0x04, 0x0C, 0xFF, 0xE0, 0x87, 0x77, 0x78, 0x14, 0xAE, 0xFF,
  0x81, 0xE8, 0x17, 0x77, 0x74, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0x97, 0x37, 0x76,
  // "D" (U+0044)
  0x76, 0x02, 0xFF, 0xFA, 0x85, 0xEE, 0xCA, 0x84, 0x17, 0x77, 0x60, 0x6F, 0xFF, 0xFA, 0x0B, 0x06,
  0x77, 0x74, 0x0A, 0xFF, 0xFF, 0xC0, 0xE0, 0x77, 0x77, 0x28, 0x29, 0xBC, 0xEF, 0xFF, 0xFB, 0x0D,
  0x04, 0x77, 0x74, 0x02, 0x09, 0xFA, 0x0E, 0x80, 0x26, 0x82, 0x78, 0xAE, 0xFC, 0x07, 0x77, 0x75,
  0x0B, 0xF9, 0x0A, 0x73, 0x03, 0x09, 0xFB, 0x08, 0x77, 0x74, 0x06, 0xF9, 0x07, 0x75, 0x02, 0x0B,
  0xFA, 0x08, 0x77, 0x73, 0x06, 0xF9, 0x03, 0x77, 0x08, 0xFA, 0x05, 0x77, 0x72, 0x08, 0xF9, 0x77,
  0x20, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x10, 0xBF, 0x0C, 0x77, 0x30, 0xAF, 0x90, 0xA7, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x30, 0x10, 0xEF, 0x90, 0x27, 0x76, 0x03, 0xF9, 0x06, 0x77, 0x40, 0x8F, 0x90,
  0x97, 0x76, 0x06, 0xF9, 0x02, 0x77, 0x40, 0x1F, 0x90, 0xE7, 0x76, 0x09, 0xF0, 0xE7, 0x76, 0x0B,
  0xF9, 0x05, 0x77, 0x50, 0xCF, 0x0B, 0x77, 0x60, 0x6F, 0x90, 0x97, 0x75, 0xF9, 0x08, 0x77, 0x60,
  0x3F, 0x90, 0xE7, 0x74, 0x03, 0xF9, 0x05, 0x77, 0x7F, 0xA0, 0x17, 0x73, 0x07, 0xF9, 0x01, 0x77,
  0x70, 0xDF, 0x90, 0x47, 0x73, 0x0A, 0xF0, 0xD7, 0x77, 0x10, 0xBF, 0x90, 0x67, 0x73, 0x0D, 0xF0,
  0xA7, 0x77, 0x10, 0xAF, 0x90, 0x87, 0x72, 0x01, 0xF9, 0x07, 0x77, 0x71, 0x09, 0xF9, 0x09, 0x77,
  0x20, 0x4F, 0x90, 0x37, 0x77, 0x10, 0x9F, 0x90, 0xA7, 0x72, 0x07, 0xF9, 0x77, 0x72, 0x08, 0xF9,
  0x0A, 0x77, 0x20, 0xBF, 0x0C, 0x77, 0x72, 0x09, 0xF9, 0x0A, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x72,
  0x0A, 0xF9, 0x0A, 0x77, 0x10, 0x2F, 0x90, 0x67, 0x77, 0x20, 0xAF, 0x90, 0x97, 0x71, 0x05, 0xF9,
  0x02, 0x77, 0x72, 0x0B, 0xF9, 0x09, 0x77, 0x10, 0x8F, 0x0E, 0x77, 0x73, 0x0B, 0xF9, 0x08, 0x77,
  0x10, 0xBF, 0x0B, 0x77, 0x73, 0x0D, 0xF9, 0x06, 0x77, 0x10, 0xEF, 0x08, 0x77, 0x73, 0xFA, 0x05,
  0x77, 0x02, 0xF9, 0x05, 0x77, 0x72, 0x01, 0xFA, 0x03, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x72, 0x03,
  0xFA, 0x01, 0x77, 0x09, 0xF0, 0xE7, 0x77, 0x30, 0x5F, 0x90, 0xE7, 0x71, 0x0C, 0xF0, 0xA7, 0x77,
  0x30, 0x8F, 0x90, 0xB7, 0x71, 0xF9, 0x07, 0x77, 0x73, 0x0B, 0xF9, 0x08, 0x77, 0x03, 0xF9, 0x04,
  0x77, 0x73, 0x0E, 0xF9, 0x05, 0x77, 0x06, 0xF9, 0x77, 0x73, 0x02, 0xFA, 0x01, 0x77, 0x0A, 0xF0,
  0xD7, 0x77, 0x30, 0x6F, 0x90, 0xC7, 0x71, 0x0D, 0xF0, 0x97, 0x77, 0x30, 0xBF, 0x90, 0x87, 0x70,
  0x1F, 0x90, 0x67, 0x77, 0x3F, 0xA0, 0x37, 0x70, 0x4F, 0x90, 0x37, 0x77, 0x20, 0x4F, 0x90, 0xE7,
  0x71, 0x07, 0xF9, 0x77, 0x73, 0x09, 0xF9, 0x09, 0x77, 0x10, 0xAF, 0x0B, 0x77, 0x72, 0x01, 0xFA,
  0x03, 0x77, 0x10, 0xEF, 0x08, 0x77, 0x72, 0x07, 0xF9, 0x0C, 0x77, 0x10, 0x1F, 0x90, 0x57, 0x77,
  0x20, 0xDF, 0x90, 0x57, 0x71, 0x05, 0xF9, 0x02, 0x77, 0x71, 0x05, 0xF9, 0x0D, 0x77, 0x20, 0x8F,
  0x0E, 0x77, 0x72, 0x0D, 0xF9, 0x06, 0x77, 0x20, 0xBF, 0x0A, 0x77, 0x71, 0x06, 0xF9, 0x0D, 0x77,
  0x30, 0xEF, 0x07, 0x77, 0x70, 0x10, 0xEF, 0x90, 0x47, 0x72, 0x02, 0xF9, 0x04, 0x77, 0x70, 0xAF,
  0x90, 0xA7, 0x73, 0x05, 0xF9, 0x01, 0x77, 0x60, 0x6F, 0x90, 0xE0, 0x17, 0x73, 0x09, 0xF0, 0xD7,
  0x76, 0x03, 0xFA, 0x05, 0x77, 0x40, 0xCF, 0x09, 0x77, 0x50, 0x20, 0xDF, 0x90, 0x87, 0x75, 0xF9,
  0x06, 0x77, 0x40, 0x20, 0xDF, 0x90, 0xB7, 0x75, 0x03, 0xF9, 0x03, 0x77, 0x30, 0x20, 0xDF, 0x90,
  0xC0, 0x17, 0x75, 0x08, 0xF9, 0x77, 0x30, 0x40, 0xEF, 0x90, 0xC0, 0x17, 0x76, 0x0D, 0xF0, 0xC7,
  0x72, 0x09, 0xFA, 0x0C, 0x01, 0x77, 0x60, 0x6F, 0x90, 0x87, 0x70, 0x70, 0xEF, 0xA0, 0xA7, 0x77,
  0x03, 0x0E, 0xF9, 0x05, 0x74, 0x81, 0x49, 0xEF, 0xB0, 0x67, 0x76, 0x02, 0x08, 0xFB, 0x08, 0x80,
  0x26, 0x82, 0x77, 0x9C, 0xFD, 0x0B, 0x02, 0x77, 0x38, 0x28, 0x9A, 0xDF, 0xFF, 0xFD, 0x0E, 0x06,
  0x77, 0x40, 0x1F, 0xFF, 0xFF, 0x0D, 0x06, 0x77, 0x60, 0x5F, 0xFF, 0xFC, 0x81, 0xD8, 0x37, 0x77,
  0x10, 0x8F, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x52, 0x77, 0x74,
  // "E" (U+0045)
  0x76, 0x03, 0x80, 0xC3, 0xF0, 0x57, 0x60, 0x78, 0x0C, 0x3F, 0x03, 0x76, 0x0A, 0x80, 0xC3, 0xF7,
  0x78, 0x29, 0xBC, 0xEF, 0xFF, 0xFF, 0x0C, 0x77, 0x40, 0x40, 0xCF, 0xA0, 0xE8, 0x09, 0x16, 0x07,
  0x0A, 0xF9, 0x09, 0x77, 0x50, 0x10, 0xEF, 0x90, 0xA7, 0x71, 0x02, 0x0D, 0xE0, 0x67, 0x76, 0x0A,
  0xF9, 0x07, 0x77, 0x20, 0x2E, 0x03, 0x77, 0x60, 0x9F, 0x90, 0x37, 0x73, 0x09, 0xD7, 0x77, 0x09,
  0xF9, 0x77, 0x40, 0x5C, 0x0D, 0x77, 0x70, 0xBF, 0x0C, 0x77, 0x40, 0x3C, 0x0A, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x40, 0x3C, 0x07, 0x77, 0x60, 0x2F, 0x90, 0x57, 0x74, 0x05, 0xC0, 0x47, 0x76, 0x05,
  0xF9, 0x02, 0x77, 0x40, 0x6C, 0x01, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x50, 0x8B, 0x0D, 0x77, 0x70,
  0xCF, 0x0B, 0x77, 0x50, 0xAB, 0x0A, 0x77, 0x7F, 0x90, 0x77, 0x75, 0x83, 0x56, 0x66, 0x37, 0x76,
  0x03, 0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D, 0x00, 0x0A, 0xF0, 0xD8, 0x0D, 0x10,
  0x0D, 0xF0, 0x98, 0x0D, 0x00, 0x01, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F, 0x90, 0x38, 0x0D, 0x00,
  0x07, 0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xF0, 0xB8, 0x0D, 0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02,
  0xF9, 0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x18, 0x0D, 0x00, 0x08, 0xF0, 0xD8, 0x0D, 0x10, 0x0C,
  0xFF, 0xFD, 0x03, 0x77, 0x75, 0xFF, 0xFE, 0x77, 0x75, 0x03, 0xFF, 0xFD, 0x0C, 0x77, 0x75, 0x06,
  0xFF, 0xFD, 0x09, 0x77, 0x75, 0x09, 0xF0, 0xD8, 0x09, 0x66, 0x02, 0x77, 0x75, 0x0D, 0xF0, 0x98,
  0x0D, 0x10, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F, 0x90, 0x38, 0x0D, 0x00, 0x07, 0xF9, 0x80, 0xD1,
  0x00, 0xAF, 0x0C, 0x80, 0xD1, 0x00, 0xDF, 0x09, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x58, 0x0D, 0x00,
  0x05, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x8F, 0x0E, 0x80, 0xD1, 0x00, 0xBF, 0x0B, 0x80, 0xD1, 0x00,
  0xEF, 0x08, 0x80, 0xD0, 0x00, 0x2F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9, 0x01, 0x80, 0xD0, 0x00,
  0x9F, 0x0D, 0x80, 0xD1, 0x00, 0xCF, 0x0A, 0x80, 0xD1, 0x0F, 0x90, 0x77, 0x77, 0x84, 0x1A, 0xAA,
  0xA1, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x77, 0x07, 0xB0, 0xD7, 0x74, 0x07, 0xF9, 0x77, 0x71, 0x0C,
  0xB0, 0xA7, 0x74, 0x0A, 0xF0, 0xD7, 0x77, 0x02, 0xC0, 0x67, 0x74, 0x0D, 0xF0, 0x97, 0x77, 0x07,
  0xC0, 0x27, 0x73, 0x01, 0xF9, 0x06, 0x77, 0x70, 0xDB, 0x0E, 0x77, 0x40, 0x5F, 0x90, 0x37, 0x76,
  0x06, 0xC0, 0xA7, 0x74, 0x09, 0xF9, 0x77, 0x60, 0x10, 0xEC, 0x07, 0x77, 0x40, 0xEF, 0x0C, 0x77,
  0x60, 0xBD, 0x03, 0x77, 0x30, 0x7F, 0x90, 0x87, 0x75, 0x0A, 0xD0, 0xE7, 0x73, 0x04, 0xFA, 0x05,
  0x77, 0x30, 0x30, 0xCE, 0x0B, 0x77, 0x10, 0x20, 0x9F, 0xB0, 0x88, 0x09, 0x26, 0x81, 0x79, 0xDF,
  0x90, 0x77, 0x48, 0x29, 0xAB, 0xE8, 0x0C, 0x2F, 0x03, 0x73, 0x01, 0x80, 0xC6, 0xF7, 0x40, 0x48,
  0x0C, 0x5F, 0x0B, 0x74, 0x08, 0x80, 0xC5, 0xF0, 0x87, 0x40,
  // "F" (U+0046)
  0x76, 0x03, 0x80, 0xC3, 0xF0, 0x77, 0x60, 0x78, 0x0C, 0x3F, 0x04, 0x76, 0x0A, 0x80, 0xC3, 0xF0,
  0x17, 0x68, 0x29, 0xBC, 0xEF, 0xFF, 0xFF, 0x0D, 0x77, 0x40, 0x20, 0x9F, 0xA0, 0xE8, 0x09, 0x16,
  0x07, 0x0B, 0xF9, 0x0B, 0x77, 0x60, 0xBF, 0x90, 0xA7, 0x71, 0x02, 0x0D, 0xE0, 0x87, 0x76, 0x06,
  0xF9, 0x07, 0x77, 0x20, 0x2E, 0x05, 0x77, 0x60, 0x6F, 0x90, 0x37, 0x73, 0x09, 0xD0, 0x27, 0x76,
  0x08, 0xF9, 0x77, 0x40, 0x5C, 0x0E, 0x77, 0x70, 0xBF, 0x0C, 0x77, 0x40, 0x3C, 0x0B, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x40, 0x3C, 0x08, 0x77, 0x60, 0x2F, 0x90, 0x67, 0x74, 0x04, 0xC0, 0x67, 0x76,
  0x05, 0xF9, 0x02, 0x77, 0x40, 0x5C, 0x03, 0x77, 0x60, 0x8F, 0x0E, 0x77, 0x50, 0x7C, 0x77, 0x70,
  0xCF, 0x0B, 0x77, 0x50, 0x8B, 0x0C, 0x77, 0x7F, 0x90, 0x87, 0x75, 0x83, 0x6A, 0xAA, 0x77, 0x76,
  0x03, 0xF9, 0x05, 0x80, 0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D, 0x00, 0x09, 0xF0, 0xE8, 0x0D, 0x10,
  0x0D, 0xF0, 0xA8, 0x0D, 0x00, 0x01, 0xF9, 0x07, 0x80, 0xD0, 0x00, 0x4F, 0x90, 0x48, 0x0D, 0x00,
  0x07, 0xF9, 0x80, 0xD1, 0x00, 0xAF, 0x0D, 0x80, 0xD1, 0x00, 0xEF, 0x09, 0x80, 0xD0, 0x00, 0x1F,
  0x90, 0x68, 0x0D, 0x00, 0x05, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x8F, 0x98, 0x0D, 0x10, 0x0B, 0xF0,
  0xB8, 0x0D, 0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02, 0xF9, 0x09, 0x80, 0x95, 0x60, 0x57, 0x77,
  0x50, 0x6F, 0xFF, 0xD0, 0xB7, 0x77, 0x50, 0x9F, 0xFF, 0xD0, 0x87, 0x77, 0x50, 0xCF, 0xFF, 0xD0,
  0x57, 0x77, 0x5F, 0xFF, 0xE0, 0x27, 0x77, 0x40, 0x3F, 0x90, 0x58, 0x0D, 0x00, 0x07, 0xF9, 0x01,
  0x80, 0xD0, 0x00, 0xAF, 0x0D, 0x80, 0xD1, 0x00, 0xDF, 0x0A, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x78,
  0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x8F, 0x98, 0x0D, 0x10, 0x0B, 0xF0, 0xC8, 0x0D,
  0x10, 0x0E, 0xF0, 0x98, 0x0D, 0x00, 0x02, 0xF9, 0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x28, 0x0D,
  0x00, 0x08, 0xF0, 0xE8, 0x0D, 0x10, 0x0C, 0xF0, 0xA8, 0x0D, 0x10, 0xF9, 0x07, 0x80, 0xD0, 0x00,
  0x3F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9, 0x80, 0xD1, 0x00, 0x9F, 0x0C, 0x80, 0xD1, 0x00, 0xDF,
  0x09, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x68, 0x0D, 0x00, 0x05, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x9F,
  0x90, 0x28, 0x0C, 0x70, 0x01, 0xFA, 0x02, 0x80, 0xC7, 0x00, 0xAF, 0xA0, 0x48, 0x0C, 0x60, 0x08,
  0xFB, 0x0B, 0x80, 0xC2, 0x08, 0x21, 0x38, 0xDF, 0xD8, 0x1B, 0x62, 0x77, 0x77, 0x50, 0xEF, 0xFF,
  0xA0, 0xA7, 0x77, 0x70, 0x1F, 0xFF, 0xB0, 0x77, 0x77, 0x70, 0x5F, 0xFF, 0xB0, 0x47, 0x77, 0x70,
  0x8F, 0xFF, 0xB0, 0x27, 0x77, 0x70,
  // "G" (U+0047)
  0x77, 0x77, 0x85, 0x25, 0x8B, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x96, 0x27, 0x77, 0x75, 0x81, 0x49,
  0xDF, 0xFA, 0x81, 0xD8, 0x27, 0x77, 0x68, 0x11, 0x7D, 0xFF, 0xF9, 0x09, 0x01, 0x77, 0x73, 0x08,
  0x0E, 0xFF, 0xFC, 0x0D, 0x02, 0x77, 0x70, 0x50, 0xEF, 0xA8, 0x6D, 0x98, 0x67, 0x8A, 0xEF, 0xC0,
  0xE0, 0x27, 0x74, 0x01, 0x0B, 0xF9, 0x81, 0xE8, 0x27, 0x10, 0x50, 0xDF, 0xB0, 0xD7, 0x73, 0x04,
  0x0E, 0xF9, 0x07, 0x76, 0x0B, 0xFB, 0x06, 0x77, 0x10, 0x7F, 0x90, 0xC0, 0x27, 0x71, 0x0C, 0xFA,
  0x0C, 0x77, 0x08, 0xF9, 0x0A, 0x77, 0x30, 0x4F, 0xB7, 0x60, 0x9F, 0x90, 0x97, 0x75, 0x0B, 0xFA,
  0x75, 0x08, 0xF9, 0x09, 0x77, 0x60, 0x6F, 0x90, 0xE7, 0x40, 0x6F, 0x90, 0xA7, 0x77, 0x01, 0xF9,
  0x0A, 0x73, 0x04, 0xF9, 0x0D, 0x77, 0x72, 0x0D, 0xF0, 0x47, 0x20, 0x10, 0xEF, 0x0E, 0x02, 0x77,
  0x72, 0x0B, 0xE0, 0x97, 0x30, 0xBF, 0x90, 0x67, 0x77, 0x30, 0x9D, 0x07, 0x73, 0x07, 0xF9, 0x0B,
  0x77, 0x74, 0x09, 0xA8, 0x1D, 0x81, 0x73, 0x01, 0x0E, 0xF9, 0x02, 0x77, 0x74, 0x81, 0x22, 0x17,
  0x60, 0xAF, 0x90, 0x88, 0x0C, 0x50, 0x03, 0xF9, 0x0E, 0x01, 0x80, 0xC5, 0x00, 0xCF, 0x90, 0x88,
  0x0C, 0x50, 0x03, 0xFA, 0x01, 0x80, 0xC5, 0x00, 0xBF, 0x90, 0x98, 0x0C, 0x50, 0x02, 0xFA, 0x02,
  0x80, 0xC5, 0x00, 0x9F, 0x90, 0xC8, 0x0C, 0x60, 0x0E, 0xF9, 0x06, 0x80, 0xC5, 0x00, 0x5F, 0xA0,
  0x18, 0x0C, 0x50, 0x0A, 0xF9, 0x0B, 0x80, 0xC6, 0x00, 0xEF, 0x90, 0x68, 0x0C, 0x50, 0x03, 0xFA,
  0x02, 0x80, 0xC5, 0x00, 0x8F, 0x90, 0xD8, 0x0C, 0x60, 0x0C, 0xF9, 0x09, 0x80, 0xC6, 0x0F, 0xA0,
  0x68, 0x0C, 0x50, 0x03, 0xFA, 0x02, 0x80, 0xC5, 0x00, 0x6F, 0xA8, 0x0C, 0x60, 0x09, 0xF9, 0x0C,
  0x80, 0xC6, 0x00, 0xBF, 0x90, 0xA7, 0x75, 0x0C, 0xFF, 0xE8, 0x1A, 0x0C, 0xF9, 0x07, 0x77, 0x5F,
  0xFF, 0x81, 0x70, 0xEF, 0x90, 0x57, 0x74, 0x03, 0xFF, 0xF0, 0x41, 0xFA, 0x04, 0x77, 0x40, 0x6F,
  0xFF, 0x00, 0x1F, 0xA0, 0x37, 0x76, 0x82, 0x13, 0x7C, 0xFD, 0x81, 0xA4, 0x12, 0x02, 0xFA, 0x01,
  0x77, 0x73, 0x0C, 0xFA, 0x0E, 0x03, 0x50, 0x2F, 0xA7, 0x77, 0x40, 0x7F, 0xA0, 0x46, 0x03, 0xFA,
  0x77, 0x74, 0x05, 0xF9, 0x0B, 0x70, 0x3F, 0xA7, 0x77, 0x40, 0x5F, 0x90, 0x57, 0x03, 0xF9, 0x0E,
  0x77, 0x74, 0x07, 0xF9, 0x01, 0x70, 0x2F, 0xA7, 0x77, 0x40, 0xAF, 0x0C, 0x71, 0x01, 0xFA, 0x77,
  0x74, 0x0D, 0xF0, 0x97, 0x20, 0xEF, 0x90, 0x17, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x20, 0xCF, 0x90,
  0x27, 0x77, 0x20, 0x5F, 0x90, 0x27, 0x20, 0x9F, 0x90, 0x57, 0x77, 0x20, 0x8F, 0x0E, 0x73, 0x06,
  0xF9, 0x08, 0x77, 0x72, 0x0B, 0xF0, 0xB7, 0x30, 0x2F, 0x90, 0xB7, 0x77, 0x20, 0xEF, 0x08, 0x74,
  0x0D, 0xF9, 0x01, 0x77, 0x70, 0x2F, 0x90, 0x57, 0x40, 0x7F, 0x90, 0x67, 0x77, 0x05, 0xF9, 0x02,
  0x74, 0x01, 0xF9, 0x0B, 0x77, 0x70, 0x9F, 0x0E, 0x76, 0x09, 0xF9, 0x04, 0x77, 0x60, 0xCF, 0x0B,
  0x76, 0x02, 0xF9, 0x0C, 0x77, 0x6F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x87, 0x74, 0x03, 0xF9, 0x04,
  0x77, 0x10, 0xCF, 0x90, 0x67, 0x73, 0x06, 0xF9, 0x01, 0x77, 0x10, 0x10, 0xEF, 0x90, 0x97, 0x71,
  0x06, 0x0E, 0xF0, 0xD7, 0x73, 0x02, 0x0E, 0xF9, 0x81, 0xE7, 0x17, 0x28, 0x12, 0x8D, 0xFA, 0x0A,
  0x77, 0x40, 0x20, 0xDF, 0xB8, 0x7D, 0xA7, 0x66, 0x78, 0xBE, 0xFD, 0x06, 0x77, 0x60, 0xAF, 0xFF,
  0xF0, 0xA0, 0x37, 0x77, 0x10, 0x40, 0xCF, 0xFF, 0xA8, 0x1C, 0x71, 0x77, 0x75, 0x81, 0x39, 0xEF,
  0xFB, 0x81, 0xB7, 0x27, 0x77, 0x74, 0x84, 0x36, 0x9B, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x63, 0x77,
  0x70,
  // "H" (U+0048)
  0x76, 0x03, 0xFF, 0xF9, 0x0E, 0x72, 0x02, 0xFF, 0xF9, 0x0E, 0x76, 0x06, 0xFF, 0xF9, 0x0B, 0x72,
  0x05, 0xFF, 0xF9, 0x0B, 0x76, 0x09, 0xFF, 0xF9, 0x08, 0x72, 0x08, 0xFF, 0xF9, 0x08, 0x76, 0x0D,
  0xFF, 0xF9, 0x04, 0x72, 0x0B, 0xFF, 0xF9, 0x05, 0x77, 0x18, 0x21, 0x37, 0xDF, 0xD8, 0x1A, 0x52,
  0x77, 0x82, 0x13, 0x7D, 0xFD, 0x81, 0xA5, 0x27, 0x77, 0x10, 0xDF, 0xA0, 0xD0, 0x27, 0x76, 0x01,
  0x0E, 0xFA, 0x0D, 0x03, 0x77, 0x74, 0x07, 0xF9, 0x0E, 0x02, 0x77, 0x71, 0x09, 0xF9, 0x0E, 0x02,
  0x77, 0x75, 0x05, 0xF9, 0x08, 0x77, 0x72, 0x08, 0xF9, 0x07, 0x77, 0x76, 0x07, 0xF9, 0x02, 0x77,
  0x72, 0x09, 0xF9, 0x01, 0x77, 0x76, 0x0A, 0xF0, 0xD7, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x3F, 0x90, 0x77, 0x77, 0x60, 0x1F, 0x90, 0x67, 0x77, 0x20, 0x3F, 0x90, 0x47,
  0x77, 0x60, 0x5F, 0x90, 0x27, 0x77, 0x20, 0x6F, 0x90, 0x17, 0x77, 0x60, 0x8F, 0x0E, 0x77, 0x73,
  0x0A, 0xF0, 0xD7, 0x77, 0x70, 0xBF, 0x0B, 0x77, 0x73, 0x0D, 0xF0, 0x97, 0x77, 0x70, 0xEF, 0x08,
  0x77, 0x72, 0x01, 0xF9, 0x06, 0x77, 0x76, 0x03, 0xF9, 0x04, 0x77, 0x72, 0x04, 0xF9, 0x03, 0x77,
  0x76, 0x06, 0xF9, 0x01, 0x77, 0x72, 0x08, 0xF9, 0x77, 0x77, 0x09, 0xF0, 0xD7, 0x77, 0x30, 0xBF,
  0x0C, 0x77, 0x77, 0x0C, 0xF0, 0xA7, 0x77, 0x30, 0xEF, 0x08, 0x77, 0x77, 0xF9, 0x06, 0x77, 0x72,
  0x02, 0xF9, 0x05, 0x77, 0x76, 0x04, 0xF9, 0x03, 0x77, 0x72, 0x06, 0xF9, 0x02, 0x77, 0x76, 0x07,
  0xF9, 0x77, 0x73, 0x09, 0xF0, 0xE7, 0x77, 0x70, 0xAF, 0x0B, 0x77, 0x73, 0x0D, 0xF0, 0xB7, 0x77,
  0x70, 0xDF, 0x08, 0x77, 0x72, 0x01, 0xF9, 0x07, 0x77, 0x76, 0x01, 0xF9, 0x05, 0x77, 0x72, 0x04,
  0xF9, 0x04, 0x77, 0x76, 0x05, 0xF9, 0x01, 0x77, 0x72, 0x07, 0xF9, 0x01, 0x77, 0x76, 0x08, 0xF0,
  0xD7, 0x77, 0x30, 0xBF, 0x0D, 0x77, 0x77, 0x0B, 0x80, 0xC4, 0xF0, 0x97, 0x77, 0x70, 0xE8, 0x0C,
  0x4F, 0x06, 0x77, 0x76, 0x02, 0x80, 0xC5, 0xF0, 0x37, 0x77, 0x60, 0x68, 0x0C, 0x5F, 0x77, 0x77,
  0x09, 0xF0, 0xD8, 0x0A, 0x46, 0x0E, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x08, 0x77, 0x73, 0xF9, 0x08,
  0x77, 0x77, 0xF9, 0x05, 0x77, 0x72, 0x03, 0xF9, 0x05, 0x77, 0x76, 0x03, 0xF9, 0x02, 0x77, 0x72,
  0x07, 0xF9, 0x02, 0x77, 0x76, 0x07, 0xF0, 0xE7, 0x77, 0x30, 0xAF, 0x0E, 0x77, 0x77, 0x0A, 0xF0,
  0xB7, 0x77, 0x30, 0xDF, 0x0B, 0x77, 0x77, 0x0D, 0xF0, 0x77, 0x77, 0x20, 0x1F, 0x90, 0x77, 0x77,
  0x60, 0x1F, 0x90, 0x47, 0x77, 0x20, 0x4F, 0x90, 0x47, 0x77, 0x60, 0x4F, 0x90, 0x17, 0x77, 0x20,
  0x8F, 0x90, 0x17, 0x77, 0x60, 0x8F, 0x0D, 0x77, 0x73, 0x0B, 0xF0, 0xD7, 0x77, 0x70, 0xBF, 0x0A,
  0x77, 0x73, 0x0E, 0xF0, 0xA7, 0x77, 0x70, 0xEF, 0x07, 0x77, 0x72, 0x02, 0xF9, 0x06, 0x77, 0x76,
  0x02, 0xF9, 0x03, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x76, 0x05, 0xF9, 0x77, 0x73, 0x08, 0xF9,
  0x77, 0x77, 0x09, 0xF0, 0xC7, 0x77, 0x30, 0xCF, 0x0C, 0x77, 0x77, 0x0C, 0xF0, 0x97, 0x77, 0x3F,
  0x90, 0x97, 0x77, 0x7F, 0x90, 0x67, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x77, 0x60, 0x3F, 0x90, 0x27,
  0x77, 0x20, 0x6F, 0x90, 0x27, 0x77, 0x60, 0x6F, 0x0E, 0x77, 0x73, 0x09, 0xF0, 0xE7, 0x77, 0x70,
  0xAF, 0x0B, 0x77, 0x73, 0x0C, 0xF0, 0xB7, 0x77, 0x70, 0xDF, 0x08, 0x77, 0x73, 0xF9, 0x07, 0x77,
  0x76, 0x01, 0xF9, 0x05, 0x77, 0x72, 0x03, 0xF9, 0x04, 0x77, 0x76, 0x05, 0xF9, 0x02, 0x77, 0x72,
  0x07, 0xF9, 0x01, 0x77, 0x76, 0x0A, 0xF9, 0x77, 0x73, 0x0C, 0xF0, 0xE7, 0x77, 0x60, 0x1F, 0x90,
  0xE7, 0x77, 0x20, 0x2F, 0x90, 0xC7, 0x77, 0x60, 0xAF, 0xA7, 0x77, 0x20, 0xBF, 0x90, 0xD7, 0x77,
  0x50, 0x9F, 0xB0, 0x67, 0x77, 0x09, 0xFB, 0x03, 0x77, 0x78, 0x21, 0x48, 0xEF, 0xD8, 0x19, 0x52,
  0x77, 0x82, 0x14, 0x8E, 0xFC, 0x82, 0xE8, 0x41, 0x77, 0x20, 0xEF, 0xFF, 0x90, 0x37, 0x20, 0xEF,
  0xFF, 0x90, 0x37, 0x50, 0x1F, 0xFF, 0x90, 0xE7, 0x20, 0x2F, 0xFF, 0xA7, 0x60, 0x5F, 0xFF, 0x90,
  0xB7, 0x20, 0x6F, 0xFF, 0x90, 0xC7, 0x60, 0x8F, 0xFF, 0x90, 0x87, 0x20, 0x9F, 0xFF, 0x90, 0x87,
  0x60,
  // "I" (U+0049)
  0x76, 0x03, 0xFF, 0xFA, 0x01, 0x76, 0x06, 0xFF, 0xF9, 0x0D, 0x77, 0x09, 0xFF, 0xF9, 0x0A, 0x77,
  0x0D, 0xFF, 0xF9, 0x07, 0x77, 0x28, 0x21, 0x37, 0xDF, 0xD8, 0x1B, 0x62, 0x77, 0x72, 0x0D, 0xFA,
  0x0E, 0x03, 0x77, 0x75, 0x07, 0xFA, 0x03, 0x77, 0x76, 0x05, 0xF9, 0x0A, 0x77, 0x77, 0x07, 0xF9,
  0x03, 0x77, 0x77, 0x0A, 0xF0, 0xE7, 0x77, 0x71, 0x0D, 0xF0, 0xB7, 0x77, 0x70, 0x1F, 0x90, 0x77,
  0x77, 0x70, 0x4F, 0x90, 0x47, 0x77, 0x70, 0x8F, 0x90, 0x17, 0x77, 0x70, 0xBF, 0x0D, 0x77, 0x77,
  0x10, 0xEF, 0x0A, 0x77, 0x77, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x05, 0xF9, 0x03, 0x77, 0x77, 0x09,
  0xF9, 0x77, 0x77, 0x10, 0xCF, 0x0C, 0x77, 0x77, 0x1F, 0x90, 0x87, 0x77, 0x70, 0x3F, 0x90, 0x57,
  0x77, 0x70, 0x6F, 0x90, 0x27, 0x77, 0x70, 0xAF, 0x0E, 0x77, 0x77, 0x10, 0xDF, 0x0B, 0x77, 0x77,
  0x01, 0xF9, 0x07, 0x77, 0x77, 0x04, 0xF9, 0x04, 0x77, 0x77, 0x07, 0xF9, 0x01, 0x77, 0x77, 0x0B,
  0xF0, 0xD7, 0x77, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x70, 0x2F, 0x90, 0x67, 0x77, 0x70, 0x5F, 0x90,
  0x37, 0x77, 0x70, 0x9F, 0x0E, 0x77, 0x77, 0x10, 0xCF, 0x0B, 0x77, 0x77, 0x1F, 0x90, 0x87, 0x77,
  0x70, 0x3F, 0x90, 0x57, 0x77, 0x70, 0x6F, 0x90, 0x17, 0x77, 0x70, 0xAF, 0x0E, 0x77, 0x77, 0x10,
  0xDF, 0x0A, 0x77, 0x77, 0x01, 0xF9, 0x07, 0x77, 0x77, 0x04, 0xF9, 0x03, 0x77, 0x77, 0x07, 0xF9,
  0x77, 0x77, 0x10, 0xBF, 0x0C, 0x77, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x77, 0x02, 0xF9, 0x06, 0x77,
  0x77, 0x05, 0xF9, 0x02, 0x77, 0x77, 0x08, 0xF0, 0xE7, 0x77, 0x71, 0x0C, 0xF0, 0xB7, 0x77, 0x71,
  0xF9, 0x08, 0x77, 0x77, 0x03, 0xF9, 0x04, 0x77, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x77, 0x0A, 0xF0,
  0xD7, 0x77, 0x71, 0x0D, 0xF0, 0xA7, 0x77, 0x70, 0x1F, 0x90, 0x77, 0x77, 0x70, 0x5F, 0x90, 0x37,
  0x77, 0x70, 0xAF, 0x97, 0x77, 0x70, 0x1F, 0x90, 0xE7, 0x77, 0x70, 0xAF, 0xA7, 0x77, 0x60, 0x9F,
  0xB0, 0x67, 0x77, 0x18, 0x21, 0x48, 0xEF, 0xD8, 0x29, 0x52, 0x17, 0x72, 0x0E, 0xFF, 0xF9, 0x04,
  0x76, 0x01, 0xFF, 0xFA, 0x01, 0x76, 0x05, 0xFF, 0xF9, 0x0D, 0x77, 0x08, 0xFF, 0xF9, 0x0A, 0x77,
  // "J" (U+004A)
  0x77, 0x73, 0x07, 0xFF, 0xF9, 0x0B, 0x77, 0x73, 0x0A, 0xFF, 0xF9, 0x08, 0x77, 0x73, 0x0D, 0xFF,
  0xF9, 0x04, 0x77, 0x72, 0x01, 0xFF, 0xFA, 0x01, 0x77, 0x75, 0x81, 0x14, 0x9F, 0xD8, 0x2E, 0x94,
  0x17, 0x77, 0x74, 0x05, 0xFB, 0x0B, 0x01, 0x80, 0xC0, 0x00, 0xEF, 0x90, 0xD8, 0x0C, 0x20, 0x0C,
  0xF9, 0x05, 0x80, 0xC2, 0x00, 0xDF, 0x0D, 0x80, 0xC3, 0x0F, 0x90, 0x98, 0x0C, 0x20, 0x03, 0xF9,
  0x06, 0x80, 0xC2, 0x00, 0x7F, 0x90, 0x28, 0x0C, 0x20, 0x0A, 0xF0, 0xE8, 0x0C, 0x30, 0x0D, 0xF0,
  0xB8, 0x0C, 0x20, 0x01, 0xF9, 0x08, 0x80, 0xC2, 0x00, 0x4F, 0x90, 0x48, 0x0C, 0x20, 0x08, 0xF9,
  0x01, 0x80, 0xC2, 0x00, 0xBF, 0x0D, 0x80, 0xC3, 0x00, 0xEF, 0x0A, 0x80, 0xC2, 0x00, 0x2F, 0x90,
  0x78, 0x0C, 0x20, 0x05, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x9F, 0x98, 0x0C, 0x30, 0x0C, 0xF0, 0xC8,
  0x0C, 0x30, 0xF9, 0x09, 0x80, 0xC2, 0x00, 0x3F, 0x90, 0x68, 0x0C, 0x20, 0x06, 0xF9, 0x02, 0x80,
  0xC2, 0x00, 0xAF, 0x0E, 0x80, 0xC3, 0x00, 0xDF, 0x0B, 0x80, 0xC2, 0x00, 0x1F, 0x90, 0x88, 0x0C,
  0x20, 0x04, 0xF9, 0x04, 0x80, 0xC2, 0x00, 0x7F, 0x90, 0x18, 0x0C, 0x20, 0x0B, 0xF0, 0xD8, 0x0C,
  0x30, 0x0E, 0xF0, 0xA8, 0x0C, 0x20, 0x02, 0xF9, 0x07, 0x80, 0xC2, 0x00, 0x5F, 0x90, 0x38, 0x0C,
  0x20, 0x08, 0xF9, 0x80, 0xC3, 0x00, 0xCF, 0x0C, 0x80, 0xC3, 0x0F, 0x90, 0x98, 0x0C, 0x20, 0x03,
  0xF9, 0x06, 0x80, 0xC2, 0x00, 0x6F, 0x90, 0x28, 0x0C, 0x20, 0x09, 0xF0, 0xE8, 0x0C, 0x30, 0x0D,
  0xF0, 0xB8, 0x0C, 0x20, 0x01, 0xF9, 0x08, 0x80, 0xC2, 0x00, 0x4F, 0x90, 0x58, 0x0C, 0x20, 0x07,
  0xF9, 0x01, 0x80, 0xC2, 0x00, 0xAF, 0x0D, 0x80, 0xC3, 0x00, 0xEF, 0x0A, 0x80, 0xC2, 0x00, 0x1F,
  0x90, 0x78, 0x0C, 0x20, 0x05, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x8F, 0x98, 0x0C, 0x30, 0x0B, 0xF0,
  0xC8, 0x0C, 0x30, 0x0E, 0xF0, 0x98, 0x0C, 0x20, 0x02, 0xF9, 0x06, 0x80, 0xC2, 0x00, 0x6F, 0x90,
  0x28, 0x0C, 0x20, 0x09, 0xF0, 0xE8, 0x0C, 0x30, 0x0C, 0xF0, 0xB8, 0x0C, 0x30, 0xF9, 0x08, 0x80,
  0xC2, 0x00, 0x3F, 0x90, 0x58, 0x0C, 0x20, 0x07, 0xF9, 0x01, 0x80, 0xC2, 0x00, 0xAF, 0x0D, 0x80,
  0xC3, 0x00, 0xDF, 0x0A, 0x80, 0xC2, 0x00, 0x1F, 0x90, 0x78, 0x0C, 0x20, 0x04, 0xF9, 0x03, 0x80,
  0xC2, 0x00, 0x8F, 0x98, 0x0C, 0x30, 0x0B, 0xF0, 0xC8, 0x0C, 0x30, 0x0E, 0xF0, 0x98, 0x0C, 0x20,
  0x03, 0xF9, 0x05, 0x80, 0xC2, 0x00, 0x6F, 0x90, 0x18, 0x0C, 0x20, 0x0A, 0xF0, 0xD8, 0x0C, 0x30,
  0x0E, 0xF0, 0x88, 0x0C, 0x20, 0x03, 0xF9, 0x04, 0x80, 0xC2, 0x00, 0x8F, 0x0E, 0x80, 0xC3, 0x00,
  0xDF, 0x09, 0x80, 0xC2, 0x00, 0x3F, 0x90, 0x28, 0x0C, 0x20, 0x09, 0xF0, 0xB8, 0x0C, 0x20, 0x01,
  0xF9, 0x04, 0x80, 0xC2, 0x00, 0x9F, 0x0C, 0x80, 0xC2, 0x00, 0x3F, 0x90, 0x38, 0x0C, 0x10, 0x01,
  0x0D, 0xF0, 0x98, 0x0C, 0x10, 0x01, 0x0C, 0xF0, 0xD8, 0x0C, 0x10, 0x05, 0x0D, 0xF0, 0xE0, 0x27,
  0x77, 0x78, 0x79, 0xEA, 0x87, 0x67, 0x9E, 0xF9, 0x0E, 0x03, 0x77, 0x77, 0x10, 0xDF, 0xF9, 0x0D,
  0x02, 0x77, 0x77, 0x10, 0x2F, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x7F, 0xD8, 0x1E, 0x82, 0x77, 0x77,
  0x58, 0x33, 0x8B, 0xDE, 0xA8, 0x3E, 0xDB, 0x74, 0x77, 0x77, 0x70,
  // "K" (U+004B)
  0x76, 0x03, 0xFF, 0xF9, 0x0E, 0x71, 0x08, 0xFF, 0xB0, 0x47, 0x60, 0x6F, 0xFF, 0x90, 0xB7, 0x10,
  0xBF, 0xFB, 0x01, 0x76, 0x09, 0xFF, 0xF9, 0x08, 0x71, 0x0D, 0xFF, 0xA0, 0xD7, 0x70, 0xDF, 0xFF,
  0x90, 0x47, 0x01, 0xFF, 0xB0, 0xA7, 0x72, 0x82, 0x13, 0x7D, 0xFD, 0x81, 0xA5, 0x27, 0x50, 0x10,
  0x8F, 0xC8, 0x1B, 0x51, 0x77, 0x70, 0xDF, 0xA0, 0xD0, 0x37, 0x73, 0x0E, 0xF9, 0x0D, 0x03, 0x77,
  0x73, 0x07, 0xFA, 0x03, 0x77, 0x40, 0xEF, 0x0A, 0x77, 0x75, 0x05, 0xF9, 0x09, 0x77, 0x40, 0x4F,
  0x07, 0x77, 0x76, 0x07, 0xF9, 0x03, 0x77, 0x40, 0xDE, 0x05, 0x77, 0x77, 0x09, 0xF0, 0xE7, 0x74,
  0x09, 0xE0, 0x47, 0x77, 0x71, 0x0D, 0xF0, 0xA7, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x71, 0x01, 0xF9,
  0x06, 0x77, 0x20, 0x4E, 0x04, 0x77, 0x77, 0x20, 0x4F, 0x90, 0x37, 0x71, 0x03, 0x0E, 0xD0, 0x47,
  0x77, 0x73, 0x07, 0xF9, 0x77, 0x10, 0x20, 0xED, 0x04, 0x77, 0x77, 0x40, 0xBF, 0x0C, 0x77, 0x01,
  0x0D, 0xD0, 0x47, 0x77, 0x75, 0x0E, 0xF0, 0x97, 0x60, 0x10, 0xDD, 0x04, 0x77, 0x77, 0x50, 0x2F,
  0x90, 0x57, 0x50, 0x10, 0xCD, 0x04, 0x77, 0x77, 0x60, 0x5F, 0x90, 0x27, 0x50, 0xCD, 0x04, 0x77,
  0x77, 0x70, 0x8F, 0x0E, 0x75, 0x0B, 0xD0, 0x58, 0x0C, 0x00, 0x0C, 0xF0, 0xB7, 0x40, 0xAD, 0x05,
  0x80, 0xC1, 0x0F, 0x90, 0x77, 0x30, 0xAD, 0x05, 0x80, 0xC1, 0x00, 0x3F, 0x90, 0x47, 0x20, 0x9D,
  0x05, 0x80, 0xC2, 0x00, 0x6F, 0x90, 0x17, 0x10, 0x8D, 0x05, 0x80, 0xC3, 0x00, 0x9F, 0x0D, 0x71,
  0x07, 0xD0, 0x58, 0x0C, 0x40, 0x0D, 0xF0, 0xA7, 0x07, 0xD0, 0x58, 0x0C, 0x40, 0x01, 0xF9, 0x06,
  0x60, 0x6D, 0x05, 0x80, 0xC5, 0x00, 0x4F, 0x90, 0x35, 0x05, 0xD0, 0x58, 0x0C, 0x60, 0x07, 0xF9,
  0x50, 0x4D, 0x0E, 0x80, 0xC7, 0x00, 0xBF, 0x0C, 0x40, 0x4F, 0x05, 0x80, 0xC6, 0x00, 0xEF, 0x08,
  0x30, 0x30, 0xEF, 0x0A, 0x80, 0xC5, 0x00, 0x2F, 0x90, 0x52, 0x03, 0x0E, 0xF9, 0x0E, 0x80, 0xC5,
  0x00, 0x5F, 0x98, 0x22, 0x02, 0xEF, 0xB0, 0x58, 0x0C, 0x40, 0x08, 0xF8, 0x2E, 0x02, 0xDF, 0xC0,
  0xA8, 0x0C, 0x40, 0x0C, 0xF8, 0x1B, 0x1D, 0xFE, 0x80, 0xC4, 0x0F, 0x90, 0x90, 0xDB, 0x81, 0xE3,
  0xBF, 0x90, 0x58, 0x0C, 0x20, 0x03, 0xFD, 0x82, 0xD2, 0x06, 0xF9, 0x0A, 0x80, 0xC2, 0x00, 0x6F,
  0xC0, 0xC0, 0x12, 0x01, 0xFA, 0x01, 0x80, 0xC1, 0x00, 0xAF, 0xB0, 0xA5, 0x0C, 0xF9, 0x05, 0x80,
  0xC1, 0x00, 0xDF, 0xA0, 0x96, 0x07, 0xF9, 0x0B, 0x80, 0xC0, 0x00, 0x1F, 0xA0, 0x77, 0x02, 0xFA,
  0x01, 0x77, 0x77, 0x70, 0x4F, 0x90, 0x67, 0x20, 0xCF, 0x90, 0x67, 0x77, 0x77, 0x07, 0xF9, 0x73,
  0x07, 0xF9, 0x0B, 0x77, 0x77, 0x70, 0xBF, 0x0C, 0x73, 0x02, 0xFA, 0x01, 0x77, 0x77, 0x60, 0xEF,
  0x09, 0x74, 0x0D, 0xF9, 0x06, 0x77, 0x77, 0x50, 0x2F, 0x90, 0x57, 0x40, 0x8F, 0x90, 0xB7, 0x77,
  0x75, 0x05, 0xF9, 0x02, 0x74, 0x03, 0xFA, 0x01, 0x77, 0x77, 0x40, 0x8F, 0x0E, 0x76, 0x0D, 0xF9,
  0x06, 0x77, 0x77, 0x40, 0xCF, 0x0B, 0x76, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x4F, 0x90, 0x77, 0x60,
  0x3F, 0xA0, 0x17, 0x77, 0x72, 0x03, 0xF9, 0x04, 0x77, 0x0D, 0xF9, 0x06, 0x77, 0x77, 0x20, 0x6F,
  0x97, 0x71, 0x09, 0xF9, 0x0C, 0x77, 0x77, 0x20, 0xAF, 0x0C, 0x77, 0x10, 0x4F, 0xA0, 0x17, 0x77,
  0x71, 0x0D, 0xF0, 0x97, 0x72, 0x0E, 0xF9, 0x07, 0x77, 0x77, 0x01, 0xF9, 0x05, 0x77, 0x20, 0x9F,
  0x90, 0xC7, 0x77, 0x70, 0x5F, 0x90, 0x27, 0x72, 0x04, 0xFA, 0x03, 0x77, 0x76, 0x0A, 0xF9, 0x77,
  0x40, 0xEF, 0x90, 0xA7, 0x77, 0x50, 0x2F, 0x90, 0xE7, 0x74, 0x09, 0xFA, 0x03, 0x77, 0x74, 0x0B,
  0xFA, 0x77, 0x40, 0x3F, 0xA0, 0xC7, 0x77, 0x30, 0x9F, 0xB0, 0x67, 0x74, 0x0B, 0xFA, 0x0B, 0x77,
  0x58, 0x21, 0x48, 0xEF, 0xD8, 0x29, 0x52, 0x17, 0x70, 0x3F, 0xB8, 0x1D, 0x62, 0x77, 0x0E, 0xFF,
  0xF9, 0x04, 0x76, 0x07, 0xFE, 0x75, 0x01, 0xFF, 0xFA, 0x01, 0x77, 0x08, 0xFC, 0x0C, 0x75, 0x05,
  0xFF, 0xF9, 0x0D, 0x77, 0x20, 0x40, 0xCF, 0xA0, 0x87, 0x50, 0x8F, 0xFF, 0x90, 0xA7, 0x74, 0x84,
  0x27, 0xAC, 0xDE, 0xB0, 0x57, 0x50,
  // "L" (U+004C)
  0x76, 0x03, 0xFF, 0xFA, 0x01, 0x77, 0x71, 0x06, 0xFF, 0xF9, 0x0D, 0x77, 0x72, 0x09, 0xFF, 0xF9,
  0x0A, 0x77, 0x72, 0x0D, 0xFF, 0xF9, 0x07, 0x77, 0x74, 0x82, 0x13, 0x7D, 0xFD, 0x81, 0xA5, 0x27,
  0x77, 0x74, 0x0D, 0xFA, 0x0D, 0x02, 0x77, 0x77, 0x70, 0x7F, 0x90, 0xE0, 0x28, 0x0C, 0x00, 0x05,
  0xF9, 0x08, 0x80, 0xC1, 0x00, 0x7F, 0x90, 0x28, 0x0C, 0x10, 0x0A, 0xF0, 0xD8, 0x0C, 0x20, 0x0D,
  0xF0, 0x98, 0x0C, 0x10, 0x01, 0xF9, 0x06, 0x80, 0xC1, 0x00, 0x4F, 0x90, 0x38, 0x0C, 0x10, 0x07,
  0xF9, 0x80, 0xC2, 0x00, 0xAF, 0x0C, 0x80, 0xC2, 0x00, 0xEF, 0x08, 0x80, 0xC1, 0x00, 0x2F, 0x90,
  0x58, 0x0C, 0x10, 0x05, 0xF9, 0x02, 0x80, 0xC1, 0x00, 0x8F, 0x0E, 0x80, 0xC2, 0x00, 0xBF, 0x0B,
  0x80, 0xC2, 0x00, 0xEF, 0x07, 0x80, 0xC1, 0x00, 0x3F, 0x90, 0x48, 0x0C, 0x10, 0x06, 0xF9, 0x01,
  0x80, 0xC1, 0x00, 0x9F, 0x0D, 0x80, 0xC2, 0x00, 0xCF, 0x0A, 0x80, 0xC2, 0x0F, 0x90, 0x78, 0x0C,
  0x10, 0x04, 0xF9, 0x03, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x20, 0x0A, 0xF0, 0xC8, 0x0C, 0x20,
  0x0D, 0xF0, 0x98, 0x0C, 0x10, 0x01, 0xF9, 0x06, 0x80, 0xC1, 0x00, 0x5F, 0x90, 0x28, 0x0C, 0x10,
  0x08, 0xF0, 0xE8, 0x0C, 0x20, 0x0B, 0xF0, 0xB8, 0x0C, 0x20, 0x0E, 0xF0, 0x88, 0x0C, 0x10, 0x02,
  0xF9, 0x05, 0x80, 0xC1, 0x00, 0x6F, 0x90, 0x18, 0x0C, 0x10, 0x09, 0xF0, 0xD8, 0x0C, 0x20, 0x0C,
  0xF0, 0xA8, 0x0C, 0x20, 0xF9, 0x07, 0x80, 0xC1, 0x00, 0x3F, 0x90, 0x48, 0x0C, 0x10, 0x07, 0xF9,
  0x80, 0xC2, 0x00, 0xAF, 0x0D, 0x80, 0xC2, 0x00, 0xDF, 0x09, 0x80, 0xC1, 0x00, 0x1F, 0x90, 0x67,
  0x77, 0x18, 0x00, 0x17, 0x40, 0x4F, 0x90, 0x37, 0x77, 0x02, 0xC7, 0x40, 0x8F, 0x97, 0x77, 0x10,
  0x7B, 0x0C, 0x74, 0x0B, 0xF0, 0xC7, 0x77, 0x10, 0xCB, 0x08, 0x74, 0x0E, 0xF0, 0x87, 0x77, 0x02,
  0xC0, 0x47, 0x30, 0x2F, 0x90, 0x57, 0x77, 0x07, 0xC0, 0x17, 0x30, 0x5F, 0x90, 0x27, 0x77, 0x0C,
  0xB0, 0xC7, 0x40, 0x9F, 0x0E, 0x77, 0x70, 0x1C, 0x08, 0x74, 0x0C, 0xF0, 0xB7, 0x77, 0x08, 0xC0,
  0x47, 0x4F, 0x90, 0x77, 0x77, 0x0E, 0xC0, 0x17, 0x30, 0x4F, 0x90, 0x47, 0x76, 0x06, 0xC0, 0xC7,
  0x40, 0x8F, 0x90, 0x17, 0x75, 0x01, 0x0E, 0xC0, 0x97, 0x40, 0xEF, 0x0D, 0x77, 0x60, 0xBD, 0x05,
  0x73, 0x07, 0xF9, 0x0A, 0x77, 0x50, 0x8E, 0x01, 0x72, 0x04, 0xFA, 0x06, 0x77, 0x30, 0x20, 0xAE,
  0x0D, 0x71, 0x03, 0x09, 0xFB, 0x08, 0x80, 0x93, 0x60, 0x80, 0xBF, 0x90, 0x94, 0x82, 0x9A, 0xBE,
  0x80, 0xC2, 0xF0, 0x53, 0x01, 0x80, 0xC6, 0xF0, 0x13, 0x04, 0x80, 0xC5, 0xF0, 0xD4, 0x08, 0x80,
  0xC5, 0xF0, 0x94,
  // "M" (U+004D)
  0x76, 0x03, 0xFF, 0xC0, 0x37, 0x77, 0x71, 0x03, 0xFF, 0xC7, 0x60, 0x6F, 0xFC, 0x04, 0x77, 0x77,
  0x10, 0xBF, 0xFB, 0x0C, 0x76, 0x09, 0xFF, 0xC0, 0x67, 0x77, 0x70, 0x4F, 0xFC, 0x09, 0x76, 0x0D,
  0xFF, 0xC0, 0x77, 0x77, 0x70, 0xCF, 0xFC, 0x06, 0x77, 0x18, 0x21, 0x37, 0xDF, 0xE0, 0x97, 0x77,
  0x60, 0x4F, 0xF8, 0x1B, 0x62, 0x77, 0x71, 0x0D, 0xFD, 0x0A, 0x77, 0x76, 0x0C, 0xFD, 0x0E, 0x04,
  0x77, 0x74, 0x07, 0xFD, 0x0B, 0x77, 0x75, 0x05, 0xFE, 0x04, 0x77, 0x75, 0x06, 0xC0, 0xDF, 0x0D,
  0x77, 0x75, 0x0D, 0xB0, 0xD0, 0xEF, 0x0A, 0x77, 0x76, 0x07, 0xC0, 0x8F, 0x0E, 0x77, 0x74, 0x05,
  0xC0, 0x8F, 0x90, 0x37, 0x77, 0x60, 0x9C, 0x03, 0xF9, 0x77, 0x74, 0x0D, 0xB0, 0xD0, 0x5F, 0x0E,
  0x77, 0x77, 0x0C, 0xB0, 0xE1, 0xF9, 0x02, 0x77, 0x72, 0x06, 0xC0, 0x50, 0x8F, 0x0A, 0x77, 0x77,
  0xC8, 0x1B, 0x0D, 0xF0, 0x37, 0x77, 0x20, 0xDB, 0x81, 0xD0, 0xCF, 0x06, 0x77, 0x76, 0x03, 0xC8,
  0x18, 0x0B, 0xF0, 0x57, 0x77, 0x10, 0x7C, 0x05, 0x1F, 0x90, 0x37, 0x77, 0x60, 0x7C, 0x81, 0x40,
  0xAF, 0x06, 0x77, 0x71, 0x0E, 0xB8, 0x1C, 0x03, 0xF9, 0x77, 0x77, 0x0A, 0xC8, 0x11, 0x08, 0xF0,
  0x87, 0x77, 0x07, 0xC8, 0x14, 0x06, 0xF0, 0xC7, 0x77, 0x70, 0xEB, 0x0D, 0x20, 0x7F, 0x09, 0x77,
  0x60, 0x10, 0xEB, 0x0B, 0x20, 0x9F, 0x09, 0x77, 0x76, 0x01, 0xC0, 0xA2, 0x05, 0xF0, 0xB7, 0x76,
  0x08, 0xC0, 0x32, 0x0D, 0xF0, 0x57, 0x77, 0x60, 0x5C, 0x07, 0x20, 0x4F, 0x0C, 0x77, 0x50, 0x10,
  0xEB, 0x0B, 0x20, 0x1F, 0x90, 0x27, 0x77, 0x60, 0x8C, 0x03, 0x20, 0x2F, 0x0E, 0x77, 0x50, 0x8C,
  0x03, 0x20, 0x4F, 0x0E, 0x77, 0x77, 0x0C, 0xC3, 0x01, 0xF9, 0x77, 0x40, 0x10, 0xEB, 0x0A, 0x30,
  0x7F, 0x0B, 0x77, 0x77, 0xC0, 0xC4, 0xF9, 0x01, 0x77, 0x30, 0x9C, 0x02, 0x30, 0xBF, 0x07, 0x77,
  0x76, 0x03, 0xC0, 0x94, 0x0D, 0xF0, 0x27, 0x72, 0x01, 0xC0, 0xA4, 0x0E, 0xF0, 0x47, 0x77, 0x60,
  0x6C, 0x06, 0x40, 0xCF, 0x04, 0x77, 0x20, 0x9C, 0x02, 0x30, 0x2F, 0x90, 0x17, 0x77, 0x60, 0x9C,
  0x02, 0x40, 0xAF, 0x05, 0x77, 0x10, 0x2C, 0x09, 0x40, 0x5F, 0x0D, 0x77, 0x77, 0x0D, 0xB0, 0xE5,
  0x09, 0xF0, 0x77, 0x71, 0x0A, 0xC0, 0x14, 0x08, 0xF0, 0xA7, 0x77, 0x60, 0x1C, 0x0B, 0x50, 0x7F,
  0x08, 0x77, 0x02, 0xC0, 0x85, 0x0C, 0xF0, 0x67, 0x77, 0x60, 0x4C, 0x08, 0x50, 0x5F, 0x0A, 0x77,
  0x0A, 0xB0, 0xE0, 0x15, 0xF9, 0x03, 0x77, 0x76, 0x07, 0xC0, 0x55, 0x04, 0xF0, 0xB7, 0x60, 0x3C,
  0x08, 0x50, 0x3F, 0x97, 0x77, 0x70, 0xBC, 0x01, 0x50, 0x2F, 0x0D, 0x76, 0x0B, 0xB0, 0xE0, 0x15,
  0x06, 0xF0, 0xC7, 0x77, 0x70, 0xEB, 0x0D, 0x60, 0x1F, 0x0E, 0x75, 0x03, 0xC0, 0x76, 0x09, 0xF0,
  0x97, 0x77, 0x60, 0x2C, 0x0A, 0x7F, 0x97, 0x50, 0xBB, 0x0E, 0x70, 0xDF, 0x05, 0x77, 0x76, 0x05,
  0xC0, 0x77, 0x0D, 0xF0, 0x27, 0x30, 0x4C, 0x07, 0x60, 0x1F, 0x90, 0x27, 0x77, 0x60, 0x9C, 0x04,
  0x70, 0xCF, 0x03, 0x73, 0x0C, 0xB0, 0xE7, 0x04, 0xF0, 0xE7, 0x77, 0x70, 0xCC, 0x71, 0x0A, 0xF0,
  0x47, 0x20, 0x4C, 0x06, 0x70, 0x7F, 0x0B, 0x77, 0x77, 0xC0, 0xC7, 0x10, 0x9F, 0x06, 0x72, 0x0C,
  0xB0, 0xD7, 0x10, 0xBF, 0x08, 0x77, 0x76, 0x03, 0xC0, 0x97, 0x10, 0x7F, 0x07, 0x71, 0x05, 0xC0,
  0x57, 0x10, 0xEF, 0x04, 0x77, 0x76, 0x07, 0xC0, 0x67, 0x10, 0x6F, 0x09, 0x71, 0x0D, 0xB0, 0xD7,
  0x10, 0x2F, 0x90, 0x17, 0x77, 0x60, 0xAC, 0x03, 0x71, 0x04, 0xF0, 0xA7, 0x05, 0xC0, 0x57, 0x10,
  0x5F, 0x0D, 0x77, 0x77, 0x0D, 0xC7, 0x20, 0x2F, 0x0C, 0x70, 0xDB, 0x0C, 0x72, 0x08, 0xF0, 0xA7,
  0x77, 0x60, 0x1C, 0x0B, 0x72, 0x01, 0xF0, 0xD6, 0x06, 0xC0, 0x47, 0x20, 0xCF, 0x06, 0x77, 0x76,
  0x05, 0xC0, 0x87, 0x3F, 0x96, 0x0D, 0xB0, 0xC7, 0x3F, 0x90, 0x37, 0x77, 0x60, 0x8C, 0x05, 0x73,
  0x0D, 0xF0, 0x14, 0x06, 0xC0, 0x47, 0x20, 0x3F, 0x97, 0x77, 0x70, 0xBC, 0x02, 0x73, 0x0C, 0xF0,
  0x24, 0x0E, 0xB0, 0xB7, 0x30, 0x6F, 0x0C, 0x77, 0x77, 0x0E, 0xB0, 0xE7, 0x40, 0xAF, 0x04, 0x30,
  0x7C, 0x03, 0x73, 0x09, 0xF0, 0x97, 0x77, 0x60, 0x3C, 0x0B, 0x74, 0x09, 0xF0, 0x53, 0x0E, 0xB0,
  0xA7, 0x40, 0xDF, 0x05, 0x77, 0x76, 0x06, 0xC0, 0x77, 0x40, 0x7F, 0x07, 0x20, 0x7C, 0x03, 0x73,
  0x01, 0xF9, 0x02, 0x77, 0x76, 0x09, 0xC0, 0x47, 0x40, 0x6F, 0x82, 0x80, 0x1E, 0xB0, 0xA7, 0x40,
  0x4F, 0x0E, 0x77, 0x77, 0x0D, 0xC0, 0x17, 0x40, 0x4F, 0x81, 0x90, 0x8C, 0x02, 0x74, 0x07, 0xF0,
  0xB7, 0x77, 0x60, 0x1C, 0x0D, 0x75, 0x03, 0xF8, 0x1B, 0x1E, 0xB0, 0x97, 0x50, 0xBF, 0x08, 0x77,
  0x76, 0x04, 0xC0, 0x97, 0x50, 0x1F, 0x0C, 0x09, 0xC0, 0x27, 0x50, 0xEF, 0x04, 0x77, 0x76, 0x07,
  0xC0, 0x67, 0x6F, 0x0E, 0xC0, 0x97, 0x50, 0x2F, 0x90, 0x17, 0x77, 0x60, 0xBC, 0x03, 0x76, 0x0D,
  0xFC, 0x01, 0x75, 0x05, 0xF0, 0xD7, 0x77, 0x70, 0xEC, 0x77, 0x0C, 0xFB, 0x08, 0x76, 0x08, 0xF0,
  0xA7, 0x77, 0x60, 0x2C, 0x0C, 0x77, 0x0A, 0xFA, 0x0E, 0x01, 0x76, 0x0C, 0xF0, 0x77, 0x77, 0x60,
  0x6C, 0x08, 0x77, 0x09, 0xFA, 0x07, 0x77, 0xF9, 0x03, 0x77, 0x76, 0x0A, 0xC0, 0x67, 0x70, 0x7F,
  0x90, 0xE7, 0x70, 0x4F, 0x97, 0x77, 0x60, 0x1D, 0x05, 0x77, 0x06, 0xF9, 0x07, 0x77, 0x09, 0xF0,
  0xE7, 0x77, 0x60, 0x9D, 0x06, 0x77, 0x04, 0xF0, 0xE7, 0x70, 0x2F, 0xA7, 0x77, 0x50, 0x7E, 0x0C,
  0x77, 0x03, 0xF0, 0x67, 0x60, 0x10, 0xCF, 0xA0, 0x77, 0x77, 0x82, 0x13, 0x8D, 0xF9, 0x82, 0xC6,
  0x21, 0x73, 0x01, 0xE0, 0xD7, 0x48, 0x21, 0x49, 0xEF, 0xC8, 0x19, 0x52, 0x77, 0x20, 0xEF, 0xFC,
  0x06, 0x72, 0xE0, 0x67, 0x20, 0x5F, 0xFF, 0x04, 0x75, 0x01, 0xFF, 0xD0, 0x37, 0x20, 0xEC, 0x0D,
  0x73, 0x09, 0xFF, 0xF0, 0x17, 0x50, 0x5F, 0xFC, 0x0E, 0x73, 0x0C, 0xC0, 0x57, 0x30, 0xDF, 0xFE,
  0x0D, 0x76, 0x08, 0xFF, 0xC0, 0xB7, 0x30, 0xBB, 0x0C, 0x73, 0x01, 0xFF, 0xF0, 0x97, 0x60,
  // "N" (U+004E)
  0x76, 0x03, 0xFF, 0x0B, 0x77, 0x6F, 0xFD, 0x07, 0x76, 0x06, 0xFF, 0x90, 0x17, 0x74, 0x03, 0xFF,
  0xD0, 0x37, 0x60, 0x9F, 0xF9, 0x06, 0x77, 0x40, 0x6F, 0xFD, 0x77, 0x0D, 0xFF, 0x90, 0xB7, 0x74,
  0x09, 0xFF, 0xC0, 0xC7, 0x72, 0x82, 0x13, 0x7D, 0xFC, 0x01, 0x77, 0x58, 0x21, 0x37, 0xDF, 0x98,
  0x2D, 0x73, 0x17, 0x77, 0x10, 0xDF, 0xB0, 0x67, 0x77, 0x20, 0xDE, 0x08, 0x77, 0x75, 0x07, 0xFB,
  0x0B, 0x77, 0x72, 0x07, 0xD0, 0x97, 0x77, 0x60, 0x6F, 0xC0, 0x17, 0x77, 0x10, 0x5C, 0x0E, 0x01,
  0x77, 0x76, 0x07, 0xFC, 0x06, 0x77, 0x71, 0x07, 0xC0, 0x97, 0x77, 0x70, 0x9F, 0xC0, 0xC7, 0x77,
  0x10, 0xAC, 0x05, 0x77, 0x77, 0x0C, 0xFD, 0x02, 0x77, 0x70, 0xDC, 0x01, 0x77, 0x77, 0xC0, 0xA0,
  0xEF, 0x07, 0x77, 0x60, 0x1C, 0x0D, 0x77, 0x77, 0x03, 0xC0, 0x60, 0xAF, 0x0C, 0x77, 0x60, 0x4C,
  0x09, 0x77, 0x77, 0x07, 0xC0, 0x30, 0x4F, 0x90, 0x27, 0x75, 0x08, 0xC0, 0x67, 0x77, 0x70, 0xAC,
  0x20, 0xEF, 0x07, 0x77, 0x50, 0xBC, 0x03, 0x77, 0x77, 0x0D, 0xB0, 0xC2, 0x09, 0xF0, 0xC7, 0x75,
  0x0E, 0xC7, 0x77, 0x70, 0x1C, 0x09, 0x20, 0x4F, 0x90, 0x27, 0x73, 0x02, 0xC0, 0xC7, 0x77, 0x70,
  0x5C, 0x05, 0x30, 0xEF, 0x08, 0x77, 0x30, 0x5C, 0x08, 0x77, 0x77, 0x08, 0xC0, 0x23, 0x08, 0xF0,
  0xD7, 0x73, 0x08, 0xC0, 0x57, 0x77, 0x70, 0xBB, 0x0E, 0x40, 0x3F, 0x90, 0x37, 0x72, 0x0C, 0xC0,
  0x27, 0x77, 0x70, 0xEB, 0x0B, 0x50, 0xDF, 0x08, 0x77, 0x2C, 0x0E, 0x77, 0x77, 0x02, 0xC0, 0x85,
  0x08, 0xF0, 0xD7, 0x71, 0x03, 0xC0, 0xB7, 0x77, 0x70, 0x6C, 0x04, 0x50, 0x2F, 0x90, 0x37, 0x70,
  0x6C, 0x07, 0x77, 0x77, 0x09, 0xC0, 0x16, 0x0C, 0xF0, 0x87, 0x70, 0x9C, 0x04, 0x77, 0x77, 0x0C,
  0xB0, 0xD7, 0x07, 0xF0, 0xD7, 0x70, 0xDC, 0x01, 0x77, 0x77, 0xC0, 0xA7, 0x02, 0xF9, 0x03, 0x76,
  0xC0, 0xD7, 0x77, 0x70, 0x4C, 0x07, 0x71, 0x0C, 0xF0, 0x97, 0x50, 0x3C, 0x09, 0x77, 0x77, 0x07,
  0xC0, 0x37, 0x10, 0x6F, 0x0E, 0x75, 0x07, 0xC0, 0x67, 0x77, 0x70, 0xAC, 0x72, 0x01, 0xF9, 0x04,
  0x74, 0x0A, 0xC0, 0x37, 0x77, 0x70, 0xEB, 0x0C, 0x73, 0x0B, 0xF0, 0x97, 0x40, 0xDC, 0x77, 0x77,
  0x01, 0xC0, 0x97, 0x30, 0x6F, 0x0E, 0x73, 0x01, 0xC0, 0xC7, 0x77, 0x70, 0x5C, 0x06, 0x73, 0x01,
  0xF9, 0x04, 0x72, 0x04, 0xC0, 0x87, 0x77, 0x70, 0x8C, 0x02, 0x74, 0x0B, 0xF0, 0x97, 0x20, 0x8C,
  0x05, 0x77, 0x77, 0x0B, 0xB0, 0xE7, 0x50, 0x5F, 0x0E, 0x72, 0x0B, 0xC0, 0x27, 0x77, 0x7C, 0x0B,
  0x76, 0x0E, 0xF0, 0x47, 0x10, 0xEB, 0x0E, 0x77, 0x77, 0x03, 0xC0, 0x87, 0x60, 0xAF, 0x0A, 0x70,
  0x2C, 0x0B, 0x77, 0x77, 0x06, 0xC0, 0x57, 0x60, 0x4F, 0x0E, 0x70, 0x5C, 0x07, 0x77, 0x77, 0x09,
  0xC0, 0x17, 0x70, 0xEF, 0x05, 0x60, 0x8C, 0x04, 0x77, 0x77, 0x0D, 0xB0, 0xE7, 0x71, 0x09, 0xF0,
  0xA6, 0x0C, 0xC0, 0x17, 0x77, 0x60, 0x1C, 0x0A, 0x77, 0x10, 0x4F, 0x96, 0x0E, 0xB0, 0xD7, 0x77,
  0x70, 0x4C, 0x07, 0x77, 0x20, 0xEF, 0x05, 0x40, 0x3C, 0x0A, 0x77, 0x77, 0x07, 0xC0, 0x47, 0x72,
  0x09, 0xF0, 0xA4, 0x06, 0xC0, 0x67, 0x77, 0x70, 0xAC, 0x77, 0x30, 0x3F, 0x90, 0x13, 0x09, 0xC0,
  0x37, 0x77, 0x70, 0xEB, 0x0D, 0x77, 0x40, 0xDF, 0x06, 0x30, 0xCC, 0x77, 0x77, 0x02, 0xC0, 0x97,
  0x74, 0x08, 0xF0, 0xB3, 0xC0, 0xC7, 0x77, 0x70, 0x5C, 0x06, 0x77, 0x40, 0x3F, 0x98, 0x11, 0x03,
  0xC0, 0x97, 0x77, 0x70, 0x8C, 0x03, 0x77, 0x50, 0xDF, 0x81, 0x60, 0x7C, 0x05, 0x77, 0x77, 0x0C,
  0xC7, 0x76, 0x07, 0xF8, 0x1B, 0x0A, 0xC0, 0x27, 0x77, 0x7C, 0x0C, 0x77, 0x60, 0x2F, 0x90, 0x10,
  0xDB, 0x0E, 0x77, 0x77, 0x03, 0xC0, 0x87, 0x77, 0x0C, 0xF0, 0x8C, 0x0B, 0x77, 0x77, 0x06, 0xC0,
  0x57, 0x77, 0x07, 0xF0, 0xEC, 0x07, 0x77, 0x77, 0x09, 0xC0, 0x27, 0x77, 0x01, 0xFD, 0x04, 0x77,
  0x77, 0x0D, 0xB0, 0xE7, 0x77, 0x20, 0xBF, 0xC0, 0x17, 0x77, 0x60, 0x1C, 0x0B, 0x77, 0x72, 0x06,
  0xFB, 0x0D, 0x77, 0x77, 0x05, 0xC0, 0x87, 0x77, 0x20, 0x1F, 0xB0, 0xA7, 0x77, 0x70, 0xBC, 0x06,
  0x77, 0x73, 0x0B, 0xFA, 0x06, 0x77, 0x76, 0x02, 0xD0, 0x57, 0x77, 0x30, 0x5F, 0xA0, 0x37, 0x77,
  0x60, 0xBD, 0x06, 0x77, 0x74, 0xFA, 0x77, 0x76, 0x0A, 0xE0, 0xC7, 0x77, 0x40, 0xAF, 0x0C, 0x77,
  0x72, 0x82, 0x13, 0x8E, 0xF9, 0x82, 0xC6, 0x21, 0x77, 0x70, 0x5F, 0x09, 0x77, 0x70, 0xEF, 0xFC,
  0x06, 0x77, 0x60, 0xEE, 0x05, 0x77, 0x60, 0x1F, 0xFD, 0x03, 0x77, 0x60, 0x9E, 0x02, 0x77, 0x60,
  0x5F, 0xFD, 0x77, 0x70, 0x4D, 0x0E, 0x77, 0x70, 0x8F, 0xFC, 0x0C, 0x77, 0x71, 0x0E, 0xC0, 0xB7,
  0x77,
  // "O" (U+004F)
  0x77, 0x75, 0x89, 0x41, 0x58, 0xAC, 0xDE, 0xFE, 0xDB, 0x85, 0x18, 0x0C, 0x00, 0x81, 0x17, 0xCF,
  0xF0, 0xB0, 0x47, 0x77, 0x74, 0x81, 0x19, 0xEF, 0xFC, 0x0C, 0x04, 0x77, 0x77, 0x10, 0x7F, 0xFF,
  0xA0, 0xA0, 0x17, 0x77, 0x40, 0x30, 0xDF, 0xA8, 0x5C, 0x87, 0x68, 0x9D, 0xFA, 0x0D, 0x01, 0x77,
  0x72, 0x08, 0xF9, 0x0D, 0x06, 0x71, 0x03, 0x0B, 0xF9, 0x0D, 0x02, 0x77, 0x70, 0xBF, 0x0E, 0x06,
  0x75, 0x05, 0x0E, 0xF0, 0xD0, 0x17, 0x74, 0x01, 0x0C, 0xF0, 0xD0, 0x27, 0x70, 0x30, 0xEF, 0x0B,
  0x77, 0x30, 0x10, 0xCF, 0x0B, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x57, 0x71, 0x01, 0x0C, 0xF0, 0xC7,
  0x75, 0x09, 0xF0, 0xE7, 0x71, 0x0B, 0xF0, 0xD0, 0x17, 0x75, 0x01, 0x0E, 0xF0, 0x77, 0x60, 0x8F,
  0x0E, 0x02, 0x77, 0x70, 0x9F, 0x0E, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x71, 0x03, 0xF9, 0x05, 0x73,
  0x01, 0x0E, 0xF0, 0xA7, 0x77, 0x30, 0xEF, 0x0A, 0x73, 0x0B, 0xF0, 0xE0, 0x17, 0x77, 0x30, 0xBF,
  0x0E, 0x72, 0x05, 0xF9, 0x08, 0x77, 0x74, 0x08, 0xF9, 0x03, 0x70, 0x10, 0xEF, 0x0E, 0x01, 0x77,
  0x74, 0x06, 0xF9, 0x07, 0x70, 0x8F, 0x90, 0x77, 0x77, 0x50, 0x4F, 0x90, 0x96, 0x01, 0xF9, 0x0E,
  0x77, 0x76, 0x03, 0xF9, 0x0B, 0x60, 0x9F, 0x90, 0x77, 0x77, 0x60, 0x2F, 0x90, 0xD5, 0x01, 0xFA,
  0x01, 0x77, 0x76, 0x02, 0xF9, 0x0E, 0x50, 0x8F, 0x90, 0xA7, 0x77, 0x70, 0x2F, 0xA5, 0x0E, 0xF9,
  0x04, 0x77, 0x77, 0x03, 0xFA, 0x40, 0x6F, 0x90, 0xD7, 0x77, 0x71, 0x03, 0xFA, 0x40, 0xCF, 0x90,
  0x87, 0x77, 0x71, 0x04, 0xFA, 0x30, 0x2F, 0xA0, 0x37, 0x77, 0x71, 0x05, 0xFA, 0x30, 0x7F, 0x90,
  0xE7, 0x77, 0x72, 0x07, 0xF9, 0x0E, 0x30, 0xDF, 0x90, 0xA7, 0x77, 0x72, 0x09, 0xF9, 0x0D, 0x20,
  0x2F, 0xA0, 0x57, 0x77, 0x72, 0x0B, 0xF9, 0x0B, 0x20, 0x6F, 0xA0, 0x17, 0x77, 0x72, 0x0D, 0xF9,
  0x09, 0x20, 0xAF, 0x90, 0xD7, 0x77, 0x73, 0xFA, 0x07, 0x20, 0xEF, 0x90, 0x97, 0x77, 0x72, 0x02,
  0xFA, 0x81, 0x40, 0x2F, 0xA0, 0x67, 0x77, 0x72, 0x06, 0xFA, 0x81, 0x10, 0x5F, 0xA0, 0x37, 0x77,
  0x72, 0x09, 0xF9, 0x0D, 0x20, 0x8F, 0xA7, 0x77, 0x73, 0x0C, 0xF9, 0x0A, 0x20, 0xAF, 0x90, 0xC7,
  0x77, 0x73, 0xFA, 0x06, 0x20, 0xCF, 0x90, 0xA7, 0x77, 0x72, 0x03, 0xFA, 0x02, 0x20, 0xEF, 0x90,
  0x77, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x3F, 0xA0, 0x67, 0x77, 0x72, 0x0C, 0xF9, 0x09, 0x20, 0x2F,
  0xA0, 0x47, 0x77, 0x71, 0x01, 0xFA, 0x04, 0x20, 0x2F, 0xA0, 0x27, 0x77, 0x71, 0x06, 0xF9, 0x0E,
  0x30, 0x3F, 0xA0, 0x17, 0x77, 0x71, 0x0A, 0xF9, 0x08, 0x30, 0x3F, 0xA7, 0x77, 0x71, 0x01, 0xFA,
  0x02, 0x30, 0x2F, 0xA7, 0x77, 0x71, 0x06, 0xF9, 0x0B, 0x40, 0x2F, 0xA7, 0x77, 0x71, 0x0C, 0xF9,
  0x05, 0x40, 0x1F, 0x90, 0xE7, 0x77, 0x70, 0x3F, 0x90, 0xD6, 0xFA, 0x77, 0x77, 0x09, 0xF9, 0x06,
  0x60, 0xDF, 0x97, 0x77, 0x60, 0x1F, 0x90, 0xD7, 0x0B, 0xF9, 0x01, 0x77, 0x75, 0x09, 0xF9, 0x05,
  0x70, 0x8F, 0x90, 0x37, 0x77, 0x40, 0x2F, 0x90, 0xB7, 0x10, 0x4F, 0x90, 0x57, 0x77, 0x40, 0x9F,
  0x90, 0x27, 0x2F, 0x90, 0x87, 0x77, 0x30, 0x2F, 0x90, 0x87, 0x30, 0xBF, 0x0C, 0x77, 0x73, 0x0C,
  0xF0, 0xC7, 0x40, 0x5F, 0x90, 0x17, 0x77, 0x10, 0x6F, 0x0E, 0x02, 0x75, 0x0E, 0xF0, 0x67, 0x77,
  0x03, 0xF9, 0x05, 0x76, 0x08, 0xF0, 0xD7, 0x76, 0x01, 0x0D, 0xF0, 0x87, 0x71, 0x0E, 0xF0, 0x67,
  0x74, 0x01, 0x0C, 0xF0, 0xA7, 0x72, 0x05, 0xF0, 0xE0, 0x27, 0x72, 0x01, 0x0C, 0xF0, 0xB7, 0x74,
  0x0A, 0xF0, 0xE0, 0x27, 0x70, 0x20, 0xDF, 0x0A, 0x77, 0x60, 0xDF, 0x0E, 0x04, 0x75, 0x07, 0xF9,
  0x09, 0x77, 0x70, 0x20, 0xDF, 0x90, 0xA0, 0x27, 0x81, 0x16, 0xDF, 0x90, 0x67, 0x77, 0x20, 0x10,
  0xDF, 0xA8, 0x5D, 0x97, 0x67, 0x9C, 0xFA, 0x0C, 0x02, 0x77, 0x75, 0x09, 0xFF, 0xF9, 0x0E, 0x07,
  0x77, 0x77, 0x10, 0x40, 0xCF, 0xFC, 0x81, 0xE8, 0x17, 0x77, 0x74, 0x05, 0x0B, 0xFF, 0x0B, 0x06,
  0x80, 0xC1, 0x08, 0x94, 0x15, 0x8B, 0xDE, 0xFE, 0xDD, 0xA8, 0x51, 0x77, 0x74,
  // "P" (U+0050)
  0x76, 0x03, 0xFF, 0xF8, 0x4E, 0xDC, 0x97, 0x37, 0x77, 0x30, 0x6F, 0xFF, 0xE8, 0x1E, 0x81, 0x77,
  0x70, 0xAF, 0xFF, 0xFA, 0x09, 0x77, 0x60, 0xB0, 0xEF, 0xFF, 0xFA, 0x0D, 0x03, 0x77, 0x78, 0x11,
  0x5C, 0xFA, 0x86, 0xE6, 0x66, 0x67, 0x8B, 0xFC, 0x04, 0x77, 0x72, 0x0C, 0xF9, 0x0B, 0x71, 0x05,
  0x0D, 0xFA, 0x03, 0x77, 0x71, 0x07, 0xF9, 0x08, 0x73, 0x09, 0xF9, 0x0E, 0x01, 0x77, 0x70, 0x5F,
  0x90, 0x57, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x07, 0xF9, 0x01, 0x75, 0x0D, 0xF9, 0x02, 0x77, 0x60,
  0xAF, 0x0E, 0x76, 0x06, 0xF9, 0x08, 0x77, 0x60, 0xDF, 0x0A, 0x77, 0x0E, 0xF0, 0xD7, 0x75, 0x01,
  0xF9, 0x07, 0x77, 0x0B, 0xF9, 0x02, 0x77, 0x40, 0x4F, 0x90, 0x47, 0x70, 0x8F, 0x90, 0x57, 0x74,
  0x07, 0xF9, 0x77, 0x10, 0x6F, 0x90, 0x77, 0x74, 0x0A, 0xF0, 0xC7, 0x71, 0x05, 0xF9, 0x09, 0x77,
  0x40, 0xEF, 0x09, 0x77, 0x10, 0x4F, 0x90, 0xA7, 0x73, 0x02, 0xF9, 0x06, 0x77, 0x10, 0x3F, 0x90,
  0xA7, 0x73, 0x05, 0xF9, 0x02, 0x77, 0x10, 0x4F, 0x90, 0xA7, 0x73, 0x08, 0xF0, 0xE7, 0x72, 0x05,
  0xF9, 0x09, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x20, 0x6F, 0x90, 0x77, 0x73, 0xF9, 0x08, 0x77, 0x20,
  0x8F, 0x90, 0x67, 0x72, 0x03, 0xF9, 0x05, 0x77, 0x20, 0xBF, 0x90, 0x37, 0x72, 0x06, 0xF9, 0x01,
  0x77, 0x20, 0xEF, 0x97, 0x73, 0x09, 0xF0, 0xD7, 0x72, 0x03, 0xF9, 0x0C, 0x77, 0x30, 0xDF, 0x0A,
  0x77, 0x20, 0x8F, 0x90, 0x87, 0x72, 0x01, 0xF9, 0x07, 0x77, 0x20, 0xDF, 0x90, 0x27, 0x72, 0x04,
  0xF9, 0x03, 0x77, 0x10, 0x4F, 0x90, 0xC7, 0x73, 0x07, 0xF9, 0x77, 0x20, 0xCF, 0x90, 0x57, 0x73,
  0x0B, 0xF0, 0xC7, 0x71, 0x07, 0xF9, 0x0C, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x03, 0xFA, 0x03, 0x77,
  0x30, 0x2F, 0x90, 0x67, 0x60, 0x20, 0xEF, 0x90, 0x87, 0x74, 0x05, 0xF9, 0x02, 0x75, 0x04, 0x0E,
  0xF9, 0x0B, 0x77, 0x50, 0x8F, 0x0E, 0x74, 0x01, 0x09, 0xFA, 0x0C, 0x01, 0x77, 0x50, 0xCF, 0x0B,
  0x72, 0x81, 0x39, 0xEF, 0xA0, 0xB7, 0x77, 0xF9, 0x89, 0x0B, 0x66, 0x66, 0x77, 0x9C, 0xEF, 0xC0,
  0x87, 0x77, 0x03, 0xFF, 0xFE, 0x0C, 0x03, 0x77, 0x71, 0x06, 0xFF, 0xFC, 0x0C, 0x05, 0x77, 0x73,
  0x09, 0xFF, 0xF9, 0x81, 0xD8, 0x37, 0x77, 0x50, 0xDF, 0xF8, 0x6E, 0xED, 0xCA, 0x85, 0x17, 0x77,
  0x70, 0x1F, 0x90, 0x68, 0x0C, 0x60, 0x04, 0xF9, 0x03, 0x80, 0xC6, 0x00, 0x7F, 0x98, 0x0C, 0x70,
  0x0B, 0xF0, 0xC8, 0x0C, 0x70, 0x0E, 0xF0, 0x88, 0x0C, 0x60, 0x02, 0xF9, 0x05, 0x80, 0xC6, 0x00,
  0x5F, 0x90, 0x18, 0x0C, 0x60, 0x08, 0xF0, 0xE8, 0x0C, 0x70, 0x0C, 0xF0, 0xA8, 0x0C, 0x70, 0xF9,
  0x07, 0x80, 0xC6, 0x00, 0x3F, 0x90, 0x48, 0x0C, 0x60, 0x06, 0xF9, 0x80, 0xC7, 0x00, 0xAF, 0x0C,
  0x80, 0xC7, 0x00, 0xDF, 0x09, 0x80, 0xC6, 0x00, 0x1F, 0x90, 0x68, 0x0C, 0x60, 0x05, 0xF9, 0x02,
  0x80, 0xC6, 0x00, 0xAF, 0x98, 0x0C, 0x60, 0x01, 0xF9, 0x0E, 0x80, 0xC6, 0x00, 0xAF, 0xA8, 0x0C,
  0x50, 0x09, 0xFB, 0x06, 0x80, 0xC0, 0x08, 0x21, 0x38, 0xEF, 0xD8, 0x19, 0x52, 0x77, 0x77, 0x30,
  0xEF, 0xFF, 0xA0, 0xB7, 0x77, 0x50, 0x1F, 0xFF, 0xB0, 0x77, 0x77, 0x50, 0x5F, 0xFF, 0xB0, 0x47,
  0x77, 0x50, 0x8F, 0xFF, 0xB0, 0x17, 0x77, 0x50,
  // "Q" (U+0051)
  0x77, 0x75, 0x89, 0x41, 0x58, 0xAC, 0xDE, 0xFE, 0xDB, 0x85, 0x18, 0x0C, 0x00, 0x81, 0x17, 0xCF,
  0xF0, 0xB0, 0x47, 0x77, 0x74, 0x81, 0x19, 0xEF, 0xFC, 0x0C, 0x04, 0x77, 0x77, 0x10, 0x8F, 0xFF,
  0xA0, 0xA0, 0x17, 0x77, 0x40, 0x40, 0xDF, 0xA8, 0x5C, 0x87, 0x67, 0x9D, 0xFA, 0x0D, 0x02, 0x77,
  0x72, 0x08, 0xF9, 0x0C, 0x06, 0x71, 0x03, 0x0A, 0xF9, 0x0E, 0x02, 0x77, 0x60, 0x10, 0xBF, 0x0E,
  0x06, 0x75, 0x05, 0x0E, 0xF0, 0xD0, 0x17, 0x74, 0x01, 0x0D, 0xF0, 0xC0, 0x17, 0x70, 0x30, 0xEF,
  0x0B, 0x77, 0x30, 0x10, 0xDF, 0x0B, 0x77, 0x30, 0x4F, 0x90, 0x57, 0x71, 0x01, 0x0D, 0xF0, 0xB7,
  0x75, 0x08, 0xF0, 0xE0, 0x17, 0x70, 0xCF, 0x0C, 0x77, 0x60, 0x10, 0xEF, 0x08, 0x76, 0x09, 0xF0,
  0xE0, 0x17, 0x77, 0x08, 0xF0, 0xE7, 0x50, 0x6F, 0x90, 0x47, 0x77, 0x10, 0x3F, 0x90, 0x57, 0x30,
  0x2F, 0x90, 0x97, 0x77, 0x30, 0xEF, 0x0B, 0x73, 0x0C, 0xF0, 0xE0, 0x17, 0x77, 0x30, 0xAF, 0x0E,
  0x72, 0x07, 0xF9, 0x07, 0x77, 0x74, 0x08, 0xF9, 0x03, 0x70, 0x10, 0xEF, 0x0D, 0x77, 0x75, 0x05,
  0xF9, 0x07, 0x70, 0xAF, 0x90, 0x67, 0x77, 0x50, 0x4F, 0x90, 0x96, 0x02, 0xF9, 0x0D, 0x77, 0x76,
  0x03, 0xF9, 0x0B, 0x60, 0xAF, 0x90, 0x67, 0x77, 0x60, 0x2F, 0x90, 0xD5, 0x02, 0xF9, 0x0E, 0x77,
  0x77, 0x02, 0xF9, 0x0E, 0x50, 0x9F, 0x90, 0x97, 0x77, 0x70, 0x2F, 0xA4, 0x01, 0xFA, 0x03, 0x77,
  0x77, 0x03, 0xFA, 0x40, 0x7F, 0x90, 0xC7, 0x77, 0x71, 0x04, 0xFA, 0x40, 0xDF, 0x90, 0x77, 0x77,
  0x71, 0x04, 0xFA, 0x30, 0x3F, 0xA0, 0x27, 0x77, 0x71, 0x05, 0xFA, 0x30, 0x8F, 0x90, 0xD7, 0x77,
  0x72, 0x07, 0xF9, 0x0E, 0x30, 0xDF, 0x90, 0x97, 0x77, 0x72, 0x09, 0xF9, 0x0D, 0x20, 0x2F, 0xA0,
  0x47, 0x77, 0x72, 0x0B, 0xF9, 0x0B, 0x20, 0x6F, 0xA7, 0x77, 0x73, 0x0E, 0xF9, 0x09, 0x20, 0xBF,
  0x90, 0xC7, 0x77, 0x73, 0xFA, 0x07, 0x20, 0xEF, 0x90, 0x87, 0x77, 0x72, 0x03, 0xFA, 0x81, 0x40,
  0x2F, 0xA0, 0x57, 0x77, 0x72, 0x07, 0xFA, 0x81, 0x10, 0x5F, 0xA0, 0x27, 0x77, 0x72, 0x0A, 0xF9,
  0x0D, 0x20, 0x8F, 0x90, 0xE7, 0x77, 0x73, 0x0D, 0xF9, 0x0A, 0x20, 0xAF, 0x90, 0xB7, 0x77, 0x72,
  0x01, 0xFA, 0x06, 0x20, 0xDF, 0x90, 0x97, 0x77, 0x72, 0x05, 0xFA, 0x02, 0x20, 0xEF, 0x90, 0x77,
  0x77, 0x72, 0x0A, 0xF9, 0x0D, 0x3F, 0xA0, 0x57, 0x77, 0x72, 0x0E, 0xF9, 0x09, 0x20, 0x2F, 0xA0,
  0x37, 0x77, 0x71, 0x03, 0xFA, 0x04, 0x20, 0x2F, 0xA0, 0x27, 0x77, 0x71, 0x08, 0xF9, 0x0E, 0x30,
  0x3F, 0xA0, 0x17, 0x77, 0x71, 0x0D, 0xF9, 0x09, 0x30, 0x3F, 0xA7, 0x77, 0x71, 0x03, 0xFA, 0x03,
  0x30, 0x3F, 0xA7, 0x77, 0x71, 0x09, 0xF9, 0x0C, 0x40, 0x2F, 0x90, 0xE7, 0x77, 0x71, 0x0E, 0xF9,
  0x06, 0x40, 0x1F, 0xA7, 0x77, 0x70, 0x6F, 0x90, 0xE6, 0xFA, 0x77, 0x77, 0x0C, 0xF9, 0x07, 0x60,
  0xDF, 0x90, 0x17, 0x77, 0x50, 0x5F, 0x90, 0xE7, 0x0B, 0xF9, 0x02, 0x77, 0x75, 0x0D, 0xF9, 0x07,
  0x70, 0x8F, 0x90, 0x47, 0x77, 0x40, 0x6F, 0x90, 0xD7, 0x10, 0x5F, 0x90, 0x77, 0x77, 0x40, 0xDF,
  0x90, 0x47, 0x10, 0x1F, 0x90, 0xA7, 0x77, 0x30, 0x7F, 0x90, 0xA7, 0x30, 0xCF, 0x0E, 0x77, 0x72,
  0x02, 0xF9, 0x0E, 0x01, 0x73, 0x06, 0xF9, 0x04, 0x77, 0x71, 0x0C, 0xF9, 0x04, 0x75, 0x0E, 0xF0,
  0xA7, 0x77, 0x0A, 0xF9, 0x08, 0x76, 0x08, 0xF9, 0x03, 0x77, 0x50, 0x8F, 0x90, 0xB7, 0x70, 0x10,
  0xEF, 0x0C, 0x77, 0x40, 0x8F, 0x90, 0xC0, 0x17, 0x71, 0x06, 0xF9, 0x0B, 0x77, 0x20, 0x9F, 0x90,
  0xD0, 0x17, 0x73, 0x0A, 0xF9, 0x0B, 0x76, 0x02, 0x0C, 0xF9, 0x0C, 0x01, 0x77, 0x50, 0xCF, 0x90,
  0xD0, 0x57, 0x20, 0x10, 0x8F, 0xA0, 0xB7, 0x77, 0x01, 0x0D, 0xFA, 0x87, 0xD8, 0x42, 0x12, 0x47,
  0xBF, 0xB0, 0x87, 0x77, 0x20, 0x10, 0xCF, 0xFF, 0xC0, 0xD0, 0x47, 0x77, 0x50, 0x8F, 0xFF, 0xA0,
  0x87, 0x77, 0x71, 0x03, 0x0B, 0xFF, 0xC8, 0x1E, 0x81, 0x77, 0x77, 0x48, 0x13, 0x9E, 0xFE, 0x0B,
  0x05, 0x80, 0xC2, 0x00, 0x30, 0xDF, 0x90, 0x90, 0x38, 0x0C, 0x60, 0x0C, 0xF9, 0x05, 0x80, 0xC7,
  0x00, 0xBF, 0x90, 0x68, 0x0C, 0x70, 0x0A, 0xF9, 0x07, 0x80, 0xC7, 0x00, 0x8F, 0x90, 0x88, 0x0C,
  0x70, 0x06, 0xF9, 0x0A, 0x80, 0xC7, 0x00, 0x4F, 0x90, 0xC8, 0x0C, 0x70, 0x01, 0xFA, 0x80, 0xD0,
  0x00, 0xDF, 0x90, 0x28, 0x0C, 0x70, 0x09, 0xF9, 0x07, 0x80, 0xC7, 0x00, 0x4F, 0x90, 0xC8, 0x0D,
  0x00, 0x0E, 0xF9, 0x03, 0x80, 0xC7, 0x00, 0x7F, 0x90, 0xB8, 0x0D, 0x00, 0x0E, 0xF9, 0x07, 0x80,
  0xC7, 0x00, 0x5F, 0xA0, 0x87, 0x03, 0x77, 0x77, 0x70, 0x9F, 0xA8, 0x7E, 0x97, 0x67, 0x9E, 0xF2,
  0x77, 0x77, 0x70, 0xAF, 0xFA, 0x04, 0x80, 0xC0, 0x00, 0x8F, 0xF9, 0x06, 0x80, 0xC1, 0x00, 0x30,
  0xBF, 0xD0, 0xB0, 0x48, 0x0C, 0x30, 0x83, 0x27, 0xAD, 0xEA, 0x83, 0xEC, 0xA6, 0x17, 0x72,
  // "R" (U+0052)
  0x76, 0x03, 0xFF, 0xF9, 0x85, 0xEE, 0xCB, 0x85, 0x17, 0x77, 0x20, 0x6F, 0xFF, 0xF9, 0x0C, 0x06,
  0x77, 0x70, 0xAF, 0xFF, 0xFB, 0x0E, 0x07, 0x77, 0x50, 0xB0, 0xEF, 0xFF, 0xFC, 0x0B, 0x01, 0x77,
  0x68, 0x11, 0x5C, 0xFA, 0x0E, 0x80, 0x26, 0x81, 0x89, 0xDF, 0xB0, 0xD0, 0x17, 0x77, 0x10, 0xCF,
  0x90, 0xA7, 0x20, 0x30, 0xAF, 0xA0, 0xC7, 0x77, 0x10, 0x7F, 0x90, 0x77, 0x40, 0x6F, 0xA0, 0x77,
  0x77, 0x06, 0xF9, 0x03, 0x75, 0x07, 0xF9, 0x0E, 0x01, 0x77, 0x60, 0x7F, 0x97, 0x70, 0xDF, 0x90,
  0x77, 0x76, 0x0A, 0xF0, 0xC7, 0x70, 0x6F, 0x90, 0xC7, 0x76, 0x0D, 0xF0, 0x97, 0x70, 0x1F, 0xA7,
  0x75, 0x01, 0xF9, 0x06, 0x77, 0x10, 0xEF, 0x90, 0x37, 0x74, 0x04, 0xF9, 0x03, 0x77, 0x10, 0xBF,
  0x90, 0x57, 0x74, 0x07, 0xF0, 0xE7, 0x72, 0x0A, 0xF9, 0x06, 0x77, 0x40, 0xBF, 0x0B, 0x77, 0x20,
  0x9F, 0x90, 0x77, 0x74, 0x0E, 0xF0, 0x87, 0x72, 0x09, 0xF9, 0x06, 0x77, 0x30, 0x2F, 0x90, 0x57,
  0x72, 0x0A, 0xF9, 0x06, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x72, 0x0B, 0xF9, 0x05, 0x77, 0x30, 0x8F,
  0x0E, 0x77, 0x30, 0xCF, 0x90, 0x37, 0x73, 0x0C, 0xF0, 0xB7, 0x73, 0x0E, 0xF9, 0x77, 0x4F, 0x90,
  0x77, 0x72, 0x02, 0xF9, 0x0D, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x72, 0x06, 0xF9, 0x09, 0x77, 0x30,
  0x6F, 0x90, 0x17, 0x72, 0x0A, 0xF9, 0x04, 0x77, 0x30, 0xAF, 0x0D, 0x77, 0x20, 0x1F, 0x90, 0xD7,
  0x74, 0x0D, 0xF0, 0xA7, 0x72, 0x08, 0xF9, 0x05, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x71, 0x02, 0xF9,
  0x0C, 0x77, 0x40, 0x4F, 0x90, 0x37, 0x71, 0x0C, 0xF9, 0x02, 0x77, 0x40, 0x8F, 0x97, 0x71, 0x0A,
  0xF9, 0x06, 0x77, 0x50, 0xBF, 0x0C, 0x77, 0x0B, 0xF9, 0x08, 0x77, 0x60, 0xEF, 0x09, 0x75, 0x04,
  0x0D, 0xF9, 0x08, 0x77, 0x60, 0x2F, 0x90, 0x67, 0x28, 0x11, 0x5C, 0xF9, 0x0E, 0x05, 0x77, 0x70,
  0x6F, 0x90, 0x88, 0x02, 0x68, 0x17, 0x9C, 0xFB, 0x0B, 0x02, 0x77, 0x71, 0x09, 0xFF, 0xFD, 0x0C,
  0x04, 0x77, 0x73, 0x0C, 0xFF, 0xFB, 0x0A, 0x04, 0x77, 0x75, 0xFF, 0xFA, 0x0B, 0x01, 0x77, 0x76,
  0x03, 0xFF, 0xFA, 0x0D, 0x77, 0x77, 0x07, 0xF9, 0x02, 0x60, 0x8F, 0x90, 0x17, 0x77, 0x60, 0xAF,
  0x0E, 0x70, 0x4F, 0x90, 0x57, 0x77, 0x60, 0xEF, 0x0A, 0x70, 0x1F, 0x90, 0x97, 0x77, 0x50, 0x1F,
  0x90, 0x77, 0x10, 0xDF, 0x0E, 0x77, 0x75, 0x05, 0xF9, 0x04, 0x71, 0x09, 0xF9, 0x02, 0x77, 0x74,
  0x08, 0xF9, 0x72, 0x05, 0xF9, 0x06, 0x77, 0x74, 0x0B, 0xF0, 0xC7, 0x20, 0x2F, 0x90, 0xA7, 0x77,
  0x4F, 0x90, 0x97, 0x30, 0xEF, 0x0E, 0x77, 0x73, 0x03, 0xF9, 0x06, 0x73, 0x0A, 0xF9, 0x03, 0x77,
  0x72, 0x06, 0xF9, 0x02, 0x73, 0x07, 0xF9, 0x07, 0x77, 0x72, 0x09, 0xF0, 0xE7, 0x40, 0x3F, 0x90,
  0xB7, 0x77, 0x20, 0xDF, 0x0B, 0x75, 0xFA, 0x77, 0x71, 0x01, 0xF9, 0x08, 0x75, 0x0B, 0xF9, 0x04,
  0x77, 0x70, 0x4F, 0x90, 0x47, 0x50, 0x8F, 0x90, 0x87, 0x77, 0x07, 0xF9, 0x01, 0x75, 0x04, 0xF9,
  0x0C, 0x77, 0x70, 0xBF, 0x0D, 0x76, 0x01, 0xFA, 0x01, 0x77, 0x60, 0xEF, 0x0A, 0x77, 0x0D, 0xF9,
  0x05, 0x77, 0x50, 0x2F, 0x90, 0x67, 0x70, 0x9F, 0x90, 0x97, 0x75, 0x06, 0xF9, 0x03, 0x77, 0x05,
  0xF9, 0x0E, 0x77, 0x50, 0xAF, 0x90, 0x17, 0x70, 0x1F, 0xA0, 0x57, 0x73, 0x01, 0xFA, 0x77, 0x20,
  0xBF, 0x90, 0xC7, 0x73, 0x09, 0xFA, 0x77, 0x20, 0x5F, 0xA0, 0x57, 0x71, 0x07, 0xFB, 0x06, 0x77,
  0x20, 0xDF, 0x90, 0xE0, 0x27, 0x38, 0x21, 0x38, 0xDF, 0xD8, 0x19, 0x52, 0x76, 0x05, 0xFA, 0x81,
  0xE7, 0x26, 0x0E, 0xFF, 0xFA, 0x0B, 0x73, 0x09, 0xFD, 0x05, 0x30, 0x1F, 0xFF, 0xB0, 0x77, 0x40,
  0x9F, 0xC0, 0x23, 0x05, 0xFF, 0xFB, 0x04, 0x75, 0x05, 0x0C, 0xF9, 0x0E, 0x40, 0x8F, 0xFF, 0xB0,
  0x17, 0x78, 0x42, 0x69, 0xCD, 0xEA, 0x0C, 0x40,
  // "S" (U+0053)
  0x77, 0x71, 0x89, 0x41, 0x58, 0xBD, 0xEE, 0xFE, 0xDC, 0xA7, 0x47, 0x77, 0x71, 0x05, 0x0B, 0xFF,
  0x81, 0xEA, 0x37, 0x77, 0x30, 0x60, 0xDF, 0xFD, 0x0B, 0x02, 0x77, 0x60, 0x20, 0xCF, 0xFF, 0x90,
  0xE0, 0x47, 0x74, 0x04, 0x0E, 0xF9, 0x85, 0xD9, 0x76, 0x79, 0xDF, 0xB0, 0x37, 0x72, 0x05, 0xF9,
  0x09, 0x02, 0x70, 0x50, 0xEF, 0x90, 0xE0, 0x17, 0x70, 0x4F, 0x0D, 0x03, 0x73, 0x02, 0x0E, 0xF9,
  0x07, 0x76, 0x01, 0x0E, 0xE0, 0xC0, 0x17, 0x50, 0x4F, 0x90, 0xC7, 0x60, 0xBE, 0x0E, 0x01, 0x77,
  0x0B, 0xF9, 0x75, 0x04, 0xF0, 0x57, 0x71, 0x04, 0xF9, 0x01, 0x74, 0x0B, 0xE0, 0xD7, 0x73, 0x0E,
  0xF7, 0x40, 0x2F, 0x07, 0x77, 0x30, 0xBE, 0x0B, 0x74, 0x07, 0xF0, 0x47, 0x73, 0x09, 0xE0, 0x57,
  0x40, 0xCF, 0x77, 0x40, 0x7D, 0x0A, 0x75, 0xF0, 0xE7, 0x74, 0x06, 0xC0, 0x87, 0x50, 0x2F, 0x0D,
  0x77, 0x48, 0x34, 0xA9, 0x61, 0x76, 0x04, 0xF0, 0xC8, 0x0C, 0x00, 0x05, 0xF0, 0xD8, 0x0C, 0x00,
  0x05, 0xF0, 0xE8, 0x0C, 0x00, 0x04, 0xF9, 0x02, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x57, 0x77, 0x77,
  0x02, 0xF9, 0x0B, 0x80, 0xC0, 0x00, 0xEF, 0x90, 0x37, 0x77, 0x77, 0x0C, 0xF9, 0x0D, 0x77, 0x77,
  0x70, 0x7F, 0xA0, 0xB7, 0x77, 0x76, 0x02, 0xFB, 0x0A, 0x77, 0x77, 0x60, 0xBF, 0xB0, 0xC0, 0x17,
  0x77, 0x74, 0x02, 0xFC, 0x0E, 0x03, 0x77, 0x77, 0x40, 0x8F, 0xD0, 0x87, 0x77, 0x74, 0x0B, 0xFD,
  0x0C, 0x02, 0x77, 0x77, 0x20, 0x10, 0xCF, 0xE0, 0x67, 0x77, 0x72, 0x01, 0x0C, 0xFE, 0x09, 0x77,
  0x77, 0x20, 0x10, 0xCF, 0xE0, 0xB0, 0x17, 0x77, 0x72, 0x0A, 0xFE, 0x0D, 0x01, 0x77, 0x77, 0x20,
  0x60, 0xEF, 0xD0, 0xD0, 0x17, 0x77, 0x72, 0x02, 0x0C, 0xFD, 0x0C, 0x77, 0x77, 0x40, 0x8F, 0xD0,
  0xA7, 0x77, 0x74, 0x04, 0x0E, 0xFC, 0x06, 0x77, 0x77, 0x40, 0x10, 0xCF, 0xB0, 0xE0, 0x17, 0x77,
  0x75, 0x0B, 0xFB, 0x08, 0x77, 0x77, 0x60, 0xBF, 0xA0, 0xE7, 0x77, 0x77, 0x0C, 0xFA, 0x05, 0x77,
  0x77, 0x60, 0x20, 0xEF, 0x90, 0x97, 0x77, 0x77, 0x07, 0xF9, 0x0D, 0x77, 0x77, 0x70, 0x10, 0xEF,
  0x98, 0x0C, 0x00, 0x0A, 0xF9, 0x01, 0x73, 0x81, 0x15, 0x57, 0x77, 0x10, 0x6F, 0x90, 0x27, 0x10,
  0x10, 0xAA, 0x0B, 0x77, 0x71, 0x04, 0xF9, 0x01, 0x70, 0x30, 0xEB, 0x0C, 0x77, 0x71, 0x03, 0xF9,
  0x01, 0x60, 0x10, 0xEC, 0x0D, 0x77, 0x71, 0x02, 0xF9, 0x70, 0x7E, 0x77, 0x71, 0x03, 0xF0, 0xD7,
  0x0C, 0xE0, 0x27, 0x77, 0x04, 0xF0, 0xA7, 0x0E, 0xE0, 0x67, 0x77, 0x06, 0xF0, 0x77, 0xF0, 0xA7,
  0x77, 0x0A, 0xF0, 0x27, 0x0E, 0xE0, 0xE0, 0x17, 0x76, 0x0E, 0xE0, 0xD7, 0x10, 0xCF, 0x07, 0x77,
  0x50, 0x6F, 0x06, 0x71, 0x08, 0xF0, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0xE7, 0x20, 0x3F, 0x90, 0xA7,
  0x73, 0x0A, 0xF0, 0x57, 0x30, 0xBF, 0x90, 0x77, 0x71, 0x08, 0xF0, 0xA7, 0x40, 0x2F, 0xA0, 0x87,
  0x50, 0x10, 0xAF, 0x0D, 0x76, 0x06, 0xFA, 0x0C, 0x04, 0x71, 0x81, 0x17, 0xEF, 0x0D, 0x01, 0x77,
  0x07, 0xFB, 0x86, 0xEA, 0x76, 0x68, 0x9C, 0xFA, 0x0B, 0x01, 0x77, 0x20, 0x50, 0xEF, 0xFF, 0xB0,
  0x77, 0x75, 0x01, 0x09, 0xFF, 0xF0, 0x90, 0x27, 0x77, 0x18, 0x12, 0x8E, 0xFF, 0x98, 0x1D, 0x71,
  0x77, 0x76, 0x84, 0x36, 0x9B, 0xDE, 0xA8, 0x5E, 0xEC, 0xB8, 0x51, 0x77, 0x60,
  // "T" (U+0054)
  0x30, 0x28, 0x0D, 0x0F, 0x03, 0x30, 0x58, 0x0D, 0x0F, 0x40, 0x98, 0x0C, 0x7F, 0x0D, 0x40, 0xD8,
  0x0C, 0x7F, 0x0A, 0x30, 0x1F, 0x81, 0xEA, 0x78, 0x03, 0x60, 0x8F, 0x90, 0x98, 0x03, 0x68, 0x17,
  0x9E, 0xF0, 0x73, 0x05, 0xE0, 0x90, 0x17, 0x20, 0x6F, 0x90, 0x37, 0x20, 0x10, 0xCE, 0x04, 0x30,
  0x9D, 0x08, 0x74, 0x09, 0xF9, 0x74, 0x01, 0x0E, 0xD0, 0x13, 0x0D, 0xC0, 0xB7, 0x50, 0xDF, 0x0C,
  0x75, 0x09, 0xC0, 0xD3, 0x01, 0xC0, 0xE0, 0x27, 0x5F, 0x90, 0x87, 0x50, 0x5C, 0x0B, 0x30, 0x5C,
  0x08, 0x75, 0x04, 0xF9, 0x05, 0x75, 0x03, 0xC0, 0x73, 0x09, 0xC0, 0x27, 0x50, 0x7F, 0x90, 0x27,
  0x50, 0x4C, 0x05, 0x30, 0xCB, 0x0B, 0x76, 0x0A, 0xF0, 0xE7, 0x60, 0x5C, 0x02, 0x20, 0x1C, 0x06,
  0x76, 0x0D, 0xF0, 0xB7, 0x60, 0x7B, 0x0E, 0x30, 0x5C, 0x01, 0x75, 0x01, 0xF9, 0x07, 0x76, 0x09,
  0xB0, 0xB3, 0x08, 0xB0, 0xB7, 0x60, 0x4F, 0x90, 0x47, 0x60, 0xBB, 0x08, 0x38, 0x35, 0x66, 0x63,
  0x76, 0x08, 0xF9, 0x01, 0x76, 0x83, 0x56, 0x66, 0x27, 0x77, 0x0B, 0xF0, 0xD8, 0x0C, 0x40, 0x0E,
  0xF0, 0xA8, 0x0C, 0x30, 0x02, 0xF9, 0x06, 0x80, 0xC3, 0x00, 0x5F, 0x90, 0x38, 0x0C, 0x30, 0x08,
  0xF9, 0x80, 0xC4, 0x00, 0xCF, 0x0C, 0x80, 0xC4, 0x0F, 0x90, 0x88, 0x0C, 0x30, 0x03, 0xF9, 0x05,
  0x80, 0xC3, 0x00, 0x6F, 0x90, 0x28, 0x0C, 0x30, 0x09, 0xF0, 0xE8, 0x0C, 0x40, 0x0D, 0xF0, 0xB8,
  0x0C, 0x40, 0xF9, 0x07, 0x80, 0xC3, 0x00, 0x4F, 0x90, 0x48, 0x0C, 0x30, 0x07, 0xF9, 0x01, 0x80,
  0xC3, 0x00, 0xAF, 0x0D, 0x80, 0xC4, 0x00, 0xDF, 0x0A, 0x80, 0xC3, 0x00, 0x1F, 0x90, 0x68, 0x0C,
  0x30, 0x04, 0xF9, 0x03, 0x80, 0xC3, 0x00, 0x8F, 0x98, 0x0C, 0x40, 0x0B, 0xF0, 0xC8, 0x0C, 0x40,
  0x0E, 0xF0, 0x88, 0x0C, 0x30, 0x02, 0xF9, 0x05, 0x80, 0xC3, 0x00, 0x5F, 0x90, 0x28, 0x0C, 0x30,
  0x08, 0xF0, 0xE8, 0x0C, 0x40, 0x0C, 0xF0, 0xB8, 0x0C, 0x40, 0xF9, 0x07, 0x80, 0xC3, 0x00, 0x3F,
  0x90, 0x48, 0x0C, 0x30, 0x06, 0xF9, 0x01, 0x80, 0xC3, 0x00, 0x9F, 0x0D, 0x80, 0xC4, 0x00, 0xCF,
  0x0A, 0x80, 0xC4, 0x0F, 0x90, 0x68, 0x0C, 0x30, 0x03, 0xF9, 0x03, 0x80, 0xC3, 0x00, 0x7F, 0x98,
  0x0C, 0x40, 0x0A, 0xF0, 0xC8, 0x0C, 0x40, 0x0D, 0xF0, 0x98, 0x0C, 0x30, 0x01, 0xF9, 0x05, 0x80,
  0xC3, 0x00, 0x4F, 0x90, 0x28, 0x0C, 0x30, 0x08, 0xF0, 0xE8, 0x0C, 0x40, 0x0B, 0xF0, 0xB8, 0x0C,
  0x30, 0x01, 0xF9, 0x08, 0x80, 0xC3, 0x00, 0x7F, 0x90, 0x78, 0x0C, 0x20, 0x01, 0x0E, 0xF9, 0x09,
  0x80, 0xC1, 0x00, 0x10, 0xCF, 0xA0, 0xE0, 0x17, 0x77, 0x74, 0x83, 0x12, 0x5A, 0xEF, 0xC8, 0x2D,
  0x73, 0x17, 0x77, 0x60, 0xEF, 0xFF, 0xA0, 0x87, 0x77, 0x20, 0x2F, 0xFF, 0xB0, 0x57, 0x77, 0x20,
  0x5F, 0xFF, 0xB0, 0x27, 0x77, 0x20, 0x9F, 0xFF, 0xA0, 0xE7, 0x77, 0x30,
  // "U" (U+0055)
  0x30, 0xAF, 0xFF, 0x90, 0x87, 0x30, 0xBF, 0xFC, 0x0D, 0x30, 0xDF, 0xFF, 0x90, 0x57, 0x30, 0xEF,
  0xFC, 0x0B, 0x20, 0x1F, 0xFF, 0xA0, 0x37, 0x20, 0x2F, 0xFD, 0x08, 0x20, 0x4F, 0xFF, 0xA7, 0x30,
  0x5F, 0xFD, 0x05, 0x48, 0x21, 0x25, 0xAF, 0xD8, 0x2E, 0x84, 0x17, 0x78, 0x21, 0x25, 0xAF, 0xA8,
  0x1A, 0x52, 0x74, 0x06, 0xFB, 0x09, 0x77, 0x71, 0x06, 0xE0, 0xD0, 0x37, 0x71, 0xFA, 0x0B, 0x77,
  0x73, 0xD0, 0xE0, 0x27, 0x72, 0x0E, 0xF9, 0x02, 0x77, 0x73, 0x0D, 0xC0, 0x87, 0x73, 0xF9, 0x0A,
  0x77, 0x74, 0xD0, 0x17, 0x72, 0x02, 0xF9, 0x06, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x73, 0x05, 0xF9,
  0x02, 0x77, 0x73, 0x06, 0xC0, 0x87, 0x73, 0x09, 0xF0, 0xE7, 0x77, 0x40, 0x9C, 0x05, 0x77, 0x30,
  0xCF, 0x0B, 0x77, 0x74, 0x0C, 0xC0, 0x17, 0x73, 0xF9, 0x07, 0x77, 0x74, 0xC0, 0xE7, 0x73, 0x03,
  0xF9, 0x04, 0x77, 0x73, 0x03, 0xC0, 0xA7, 0x73, 0x06, 0xF9, 0x01, 0x77, 0x73, 0x07, 0xC0, 0x77,
  0x73, 0x0A, 0xF0, 0xD7, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x30, 0xDF, 0x09, 0x77, 0x74, 0x0D, 0xC0,
  0x17, 0x72, 0x01, 0xF9, 0x06, 0x77, 0x73, 0x01, 0xC0, 0xD7, 0x73, 0x04, 0xF9, 0x03, 0x77, 0x73,
  0x04, 0xC0, 0x97, 0x73, 0x07, 0xF9, 0x77, 0x74, 0x08, 0xC0, 0x67, 0x73, 0x0B, 0xF0, 0xC7, 0x77,
  0x40, 0xBC, 0x03, 0x77, 0x30, 0xEF, 0x08, 0x77, 0x74, 0x0E, 0xC7, 0x73, 0x02, 0xF9, 0x05, 0x77,
  0x73, 0x02, 0xC0, 0xC7, 0x73, 0x05, 0xF9, 0x02, 0x77, 0x73, 0x05, 0xC0, 0x87, 0x73, 0x08, 0xF0,
  0xE7, 0x77, 0x40, 0x9C, 0x05, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x74, 0x0C, 0xC0, 0x27, 0x73, 0xF9,
  0x07, 0x77, 0x74, 0xC0, 0xE7, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xC0, 0xB7, 0x73, 0x06,
  0xF9, 0x01, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x73, 0x09, 0xF0, 0xD7, 0x77, 0x40, 0xAC, 0x04, 0x77,
  0x30, 0xDF, 0x0A, 0x77, 0x74, 0x0D, 0xC0, 0x17, 0x72, 0x01, 0xF9, 0x06, 0x77, 0x73, 0x01, 0xC0,
  0xD7, 0x73, 0x04, 0xF9, 0x03, 0x77, 0x73, 0x04, 0xC0, 0xA7, 0x73, 0x07, 0xF9, 0x77, 0x74, 0x08,
  0xC0, 0x67, 0x73, 0x0A, 0xF0, 0xC7, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x30, 0xEF, 0x09, 0x77, 0x74,
  0x0E, 0xC7, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x73, 0x05, 0xF9, 0x02, 0x77,
  0x73, 0x05, 0xC0, 0x97, 0x73, 0x08, 0xF0, 0xE7, 0x77, 0x40, 0x9C, 0x05, 0x77, 0x30, 0xBF, 0x0B,
  0x77, 0x74, 0x0C, 0xC0, 0x27, 0x73, 0x0E, 0xF0, 0x87, 0x77, 0x4C, 0x0E, 0x77, 0x30, 0x2F, 0x90,
  0x57, 0x77, 0x30, 0x3C, 0x0B, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x77, 0x30, 0x6C, 0x07, 0x77, 0x30,
  0x8F, 0x0E, 0x77, 0x74, 0x0A, 0xC0, 0x47, 0x73, 0x0A, 0xF0, 0xC7, 0x77, 0x40, 0xDC, 0x01, 0x77,
  0x30, 0xCF, 0x0A, 0x77, 0x73, 0x02, 0xC0, 0xD7, 0x74, 0x0E, 0xF0, 0x87, 0x77, 0x30, 0x6C, 0x08,
  0x77, 0x4F, 0x90, 0x67, 0x77, 0x30, 0xAC, 0x04, 0x77, 0x30, 0x1F, 0x90, 0x57, 0x77, 0x30, 0xEC,
  0x77, 0x5F, 0x90, 0x47, 0x77, 0x20, 0x6C, 0x0A, 0x77, 0x5F, 0x90, 0x57, 0x77, 0x20, 0xDC, 0x04,
  0x77, 0x50, 0xEF, 0x06, 0x77, 0x71, 0x04, 0xC0, 0xC7, 0x76, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0xCC,
  0x06, 0x77, 0x60, 0x8F, 0x0D, 0x77, 0x70, 0x6C, 0x0D, 0x77, 0x70, 0x4F, 0x90, 0x57, 0x75, 0x03,
  0xD0, 0x37, 0x77, 0x10, 0xDF, 0x0D, 0x01, 0x77, 0x30, 0x30, 0xEC, 0x09, 0x77, 0x72, 0x07, 0xF9,
  0x0C, 0x01, 0x77, 0x10, 0x6D, 0x0D, 0x01, 0x77, 0x73, 0x0D, 0xF9, 0x0E, 0x05, 0x75, 0x03, 0x0B,
  0xD0, 0xE0, 0x27, 0x77, 0x40, 0x30, 0xEF, 0xA8, 0x3E, 0x85, 0x21, 0x28, 0x31, 0x25, 0x8D, 0xE0,
  0xE0, 0x37, 0x77, 0x60, 0x4F, 0xFF, 0xD0, 0xE0, 0x37, 0x77, 0x71, 0x03, 0x0D, 0xFF, 0xFA, 0x0B,
  0x01, 0x77, 0x77, 0x40, 0x8F, 0xFE, 0x0D, 0x05, 0x77, 0x77, 0x78, 0x11, 0x7D, 0xFF, 0x90, 0xB0,
  0x58, 0x0C, 0x40, 0x89, 0x42, 0x59, 0xBC, 0xDE, 0xFE, 0xEC, 0xA8, 0x47, 0x77, 0x74,
  // "V" (U+0056)
  0x01, 0xFF, 0xF0, 0xB7, 0x40, 0xBF, 0xFC, 0x08, 0x04, 0xFF, 0xF0, 0x87, 0x40, 0xEF, 0xFC, 0x04,
  0x07, 0xFF, 0xF0, 0x57, 0x30, 0x1F, 0xFD, 0x01, 0x0B, 0xFF, 0xF0, 0x27, 0x30, 0x5F, 0xFC, 0x0D,
  0x38, 0x12, 0x6E, 0xFC, 0x81, 0xE7, 0x37, 0x73, 0x81, 0x14, 0xCF, 0xA0, 0xA0, 0x47, 0x10, 0x4F,
  0xB0, 0xD0, 0x17, 0x77, 0x10, 0xCF, 0x07, 0x74, 0x0C, 0xFA, 0x03, 0x77, 0x72, 0x07, 0xE0, 0x97,
  0x50, 0x8F, 0x90, 0xD7, 0x77, 0x30, 0x6D, 0x0D, 0x76, 0x06, 0xF9, 0x0A, 0x77, 0x73, 0x08, 0xD0,
  0x57, 0x60, 0x4F, 0x90, 0x97, 0x77, 0x30, 0xCC, 0x0C, 0x77, 0x03, 0xF9, 0x09, 0x77, 0x72, 0x03,
  0xD0, 0x47, 0x70, 0x1F, 0x90, 0xA7, 0x77, 0x20, 0xAC, 0x0C, 0x77, 0x2F, 0x90, 0xB7, 0x77, 0x10,
  0x2D, 0x04, 0x77, 0x20, 0xEF, 0x0C, 0x77, 0x71, 0x09, 0xC0, 0xB7, 0x73, 0x0D, 0xF0, 0xD7, 0x77,
  0x02, 0xD0, 0x37, 0x73, 0x0B, 0xF0, 0xE7, 0x77, 0x0A, 0xC0, 0xB7, 0x74, 0x0A, 0xF9, 0x77, 0x60,
  0x2D, 0x03, 0x77, 0x40, 0x8F, 0x90, 0x17, 0x75, 0x0A, 0xC0, 0xA7, 0x75, 0x07, 0xF9, 0x02, 0x77,
  0x40, 0x2D, 0x02, 0x77, 0x50, 0x6F, 0x90, 0x37, 0x74, 0x0A, 0xC0, 0xA7, 0x76, 0x04, 0xF9, 0x05,
  0x77, 0x30, 0x3D, 0x02, 0x77, 0x60, 0x3F, 0x90, 0x67, 0x73, 0x0A, 0xC0, 0x97, 0x77, 0x01, 0xF9,
  0x07, 0x77, 0x20, 0x3D, 0x02, 0x77, 0x71, 0xF9, 0x08, 0x77, 0x20, 0xBC, 0x09, 0x77, 0x72, 0x0E,
  0xF0, 0x97, 0x71, 0x03, 0xD0, 0x17, 0x77, 0x20, 0xDF, 0x0A, 0x77, 0x10, 0xBC, 0x08, 0x77, 0x73,
  0x0B, 0xF0, 0xB7, 0x70, 0x3C, 0x0E, 0x01, 0x77, 0x73, 0x0A, 0xF0, 0xC7, 0x70, 0xBC, 0x08, 0x77,
  0x74, 0x08, 0xF0, 0xD7, 0x60, 0x4C, 0x0E, 0x01, 0x77, 0x74, 0x07, 0xF9, 0x76, 0x0C, 0xC0, 0x77,
  0x77, 0x50, 0x6F, 0x97, 0x50, 0x4C, 0x0E, 0x01, 0x77, 0x75, 0x04, 0xF9, 0x01, 0x74, 0x0C, 0xC0,
  0x77, 0x77, 0x60, 0x3F, 0x90, 0x27, 0x30, 0x4C, 0x0E, 0x77, 0x77, 0x01, 0xF9, 0x03, 0x73, 0x0C,
  0xC0, 0x77, 0x77, 0x71, 0xF9, 0x05, 0x72, 0x05, 0xC0, 0xD7, 0x77, 0x72, 0x0E, 0xF0, 0x67, 0x20,
  0xCC, 0x06, 0x77, 0x77, 0x20, 0xDF, 0x07, 0x71, 0x05, 0xC0, 0xD7, 0x77, 0x73, 0x0B, 0xF0, 0x87,
  0x10, 0xDC, 0x06, 0x77, 0x77, 0x30, 0xAF, 0x09, 0x70, 0x5C, 0x0D, 0x77, 0x77, 0x40, 0x9F, 0x0A,
  0x70, 0xDC, 0x05, 0x77, 0x77, 0x40, 0x7F, 0x0B, 0x60, 0x5C, 0x0D, 0x77, 0x77, 0x50, 0x6F, 0x0C,
  0x60, 0xDC, 0x05, 0x77, 0x77, 0x50, 0x4F, 0x0D, 0x50, 0x5C, 0x0C, 0x77, 0x77, 0x60, 0x3F, 0x0E,
  0x50, 0xCC, 0x04, 0x77, 0x77, 0x60, 0x2F, 0x94, 0x04, 0xC0, 0xC8, 0x0C, 0x00, 0xF9, 0x40, 0xBC,
  0x04, 0x80, 0xC0, 0x00, 0xEF, 0x01, 0x20, 0x2C, 0x0B, 0x80, 0xC1, 0x00, 0xDF, 0x01, 0x20, 0x9C,
  0x03, 0x80, 0xC1, 0x00, 0xCF, 0x02, 0x20, 0xEB, 0x0B, 0x80, 0xC2, 0x00, 0xAF, 0x81, 0x20, 0x6C,
  0x03, 0x80, 0xC2, 0x00, 0x9F, 0x81, 0x20, 0xCB, 0x0A, 0x80, 0xC3, 0x00, 0x7F, 0x02, 0x03, 0xC0,
  0x28, 0x0C, 0x30, 0x06, 0xF0, 0x20, 0x9B, 0x0A, 0x80, 0xC4, 0x00, 0x5F, 0x02, 0x0E, 0xB0, 0x28,
  0x0C, 0x40, 0x03, 0xF0, 0x8B, 0x09, 0x80, 0xC5, 0x00, 0x2F, 0x0D, 0xB0, 0x28, 0x0C, 0x60, 0xFB,
  0x09, 0x80, 0xC7, 0x00, 0xEF, 0xA0, 0x18, 0x0C, 0x70, 0x0D, 0xF9, 0x09, 0x80, 0xD0, 0x00, 0xCF,
  0x90, 0x18, 0x0D, 0x00, 0x0A, 0xF0, 0x88, 0x0D, 0x10, 0x09, 0xE0, 0xE0, 0x18, 0x0D, 0x10, 0x07,
  0xE0, 0x88, 0x0D, 0x20, 0x06, 0xD0, 0xE0, 0x18, 0x0C, 0x00,
  // "W" (U+0057)
  0x10, 0xAF, 0xFF, 0x03, 0x77, 0x10, 0x9D, 0x07, 0x77, 0x20, 0x9F, 0xFC, 0x81, 0x80, 0xDF, 0xFE,
  0x0E, 0x77, 0x10, 0x1E, 0x08, 0x77, 0x20, 0xCF, 0xFC, 0x04, 0x1F, 0xFF, 0x0B, 0x77, 0x10, 0x7E,
  0x08, 0x77, 0x2F, 0xFD, 0x01, 0x04, 0xFF, 0xF0, 0x87, 0x71, 0x0E, 0xE0, 0x97, 0x71, 0x02, 0xFF,
  0xC0, 0xD4, 0x03, 0x0A, 0xFD, 0x81, 0xA4, 0x17, 0x73, 0x06, 0xF0, 0xA7, 0x75, 0x02, 0x08, 0xFA,
  0x09, 0x03, 0x72, 0x0A, 0xFB, 0x05, 0x77, 0x60, 0xDF, 0x0B, 0x77, 0x70, 0xAF, 0x04, 0x74, 0x03,
  0xFA, 0x09, 0x77, 0x60, 0x4F, 0x90, 0xC7, 0x77, 0x06, 0xE0, 0x67, 0x6F, 0xA0, 0x37, 0x76, 0x0B,
  0xF9, 0x0C, 0x77, 0x70, 0x5D, 0x0B, 0x77, 0x0D, 0xF9, 0x01, 0x77, 0x50, 0x3F, 0xA0, 0xD7, 0x77,
  0x08, 0xD0, 0x27, 0x70, 0xDF, 0x97, 0x76, 0x0A, 0xFA, 0x0E, 0x77, 0x70, 0xCC, 0x09, 0x77, 0x10,
  0xCF, 0x97, 0x75, 0x01, 0xFC, 0x77, 0x60, 0x2D, 0x02, 0x77, 0x10, 0xBF, 0x97, 0x75, 0x08, 0xFC,
  0x77, 0x60, 0x8C, 0x0A, 0x77, 0x20, 0xBF, 0x97, 0x75, 0x0E, 0xFC, 0x01, 0x77, 0x50, 0xEC, 0x03,
  0x77, 0x20, 0xAF, 0x90, 0x17, 0x73, 0x06, 0xFD, 0x02, 0x77, 0x40, 0x6C, 0x0B, 0x77, 0x30, 0x9F,
  0x90, 0x17, 0x73, 0x0D, 0xFD, 0x02, 0x77, 0x40, 0xDC, 0x04, 0x77, 0x30, 0x9F, 0x90, 0x27, 0x72,
  0x05, 0xC0, 0xC0, 0xEF, 0x03, 0x77, 0x30, 0x5C, 0x0D, 0x77, 0x40, 0x8F, 0x90, 0x37, 0x72, 0x0C,
  0xC0, 0x60, 0xDF, 0x04, 0x77, 0x30, 0xCC, 0x06, 0x77, 0x40, 0x7F, 0x90, 0x37, 0x71, 0x03, 0xC8,
  0x1E, 0x0C, 0xF0, 0x57, 0x72, 0x03, 0xC0, 0xE7, 0x75, 0x06, 0xF9, 0x04, 0x77, 0x10, 0xAC, 0x81,
  0x70, 0xBF, 0x05, 0x77, 0x20, 0xAC, 0x07, 0x77, 0x50, 0x6F, 0x90, 0x47, 0x70, 0x2C, 0x82, 0xE1,
  0x0B, 0xF0, 0x67, 0x71, 0x02, 0xC0, 0xE0, 0x17, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x08, 0xC0, 0x92,
  0x0A, 0xF0, 0x77, 0x71, 0x09, 0xC0, 0x97, 0x76, 0x04, 0xF9, 0x06, 0x76, 0x01, 0x0E, 0xC0, 0x22,
  0x09, 0xF0, 0x87, 0x70, 0x1D, 0x02, 0x77, 0x60, 0x4F, 0x90, 0x67, 0x60, 0x7C, 0x0A, 0x30, 0x9F,
  0x09, 0x77, 0x08, 0xC0, 0xA7, 0x77, 0x03, 0xF9, 0x07, 0x76, 0x0D, 0xC0, 0x33, 0x08, 0xF0, 0x97,
  0x70, 0xEC, 0x03, 0x77, 0x70, 0x2F, 0x90, 0x87, 0x50, 0x5C, 0x0C, 0x40, 0x7F, 0x0A, 0x76, 0x07,
  0xC0, 0xB7, 0x77, 0x10, 0x2F, 0x90, 0x87, 0x50, 0xCC, 0x05, 0x40, 0x6F, 0x0B, 0x76, 0x0D, 0xC0,
  0x47, 0x77, 0x10, 0x1F, 0x90, 0x97, 0x40, 0x4C, 0x0D, 0x50, 0x6F, 0x0C, 0x75, 0x05, 0xC0, 0xD7,
  0x77, 0x3F, 0x90, 0xA7, 0x40, 0xBC, 0x06, 0x50, 0x5F, 0x0C, 0x75, 0x0C, 0xC0, 0x67, 0x77, 0x3F,
  0x90, 0xA7, 0x30, 0x2C, 0x0E, 0x60, 0x4F, 0x0D, 0x74, 0x04, 0xC0, 0xE7, 0x77, 0x40, 0xEF, 0x0B,
  0x73, 0x09, 0xC0, 0x86, 0x04, 0xF0, 0xE7, 0x40, 0xBC, 0x07, 0x77, 0x74, 0x0E, 0xF0, 0xC7, 0x20,
  0x1D, 0x01, 0x60, 0x3F, 0x97, 0x30, 0x3C, 0x0E, 0x01, 0x77, 0x74, 0x0D, 0xF0, 0xC7, 0x20, 0x7C,
  0x09, 0x70, 0x2F, 0x97, 0x30, 0xAC, 0x08, 0x77, 0x75, 0x0C, 0xF0, 0xD7, 0x20, 0xEC, 0x03, 0x70,
  0x1F, 0x90, 0x17, 0x10, 0x2D, 0x02, 0x77, 0x75, 0x0C, 0xF0, 0xD7, 0x10, 0x6C, 0x0B, 0x71, 0x01,
  0xF9, 0x02, 0x71, 0x09, 0xC0, 0xA7, 0x77, 0x60, 0xBF, 0x0E, 0x71, 0x0D, 0xC0, 0x47, 0x2F, 0x90,
  0x27, 0x01, 0xD0, 0x37, 0x77, 0x60, 0xAF, 0x97, 0x04, 0xC0, 0xD7, 0x3F, 0x90, 0x37, 0x08, 0xC0,
  0xB7, 0x77, 0x70, 0xAF, 0x97, 0x0B, 0xC0, 0x67, 0x30, 0xEF, 0x04, 0x70, 0xEC, 0x04, 0x77, 0x77,
  0x09, 0xF9, 0x60, 0x2C, 0x0E, 0x74, 0x0D, 0xF0, 0x56, 0x06, 0xC0, 0xD7, 0x77, 0x71, 0x08, 0xF9,
  0x01, 0x50, 0x9C, 0x07, 0x74, 0x0D, 0xF0, 0x66, 0x0D, 0xC0, 0x67, 0x77, 0x71, 0x08, 0xF9, 0x02,
  0x40, 0x1D, 0x01, 0x74, 0x0C, 0xF0, 0x65, 0x05, 0xC0, 0xE7, 0x77, 0x72, 0x07, 0xF9, 0x02, 0x40,
  0x7C, 0x09, 0x75, 0x0B, 0xF0, 0x75, 0x0C, 0xC0, 0x77, 0x77, 0x72, 0x06, 0xF9, 0x02, 0x40, 0xEC,
  0x02, 0x75, 0x0B, 0xF0, 0x74, 0x03, 0xC0, 0xE0, 0x17, 0x77, 0x72, 0x06, 0xF9, 0x02, 0x30, 0x5C,
  0x0A, 0x76, 0x0A, 0xF0, 0x84, 0x0A, 0xC0, 0x87, 0x77, 0x73, 0x05, 0xF9, 0x03, 0x30, 0xCC, 0x03,
  0x76, 0x09, 0xF0, 0x83, 0x01, 0xD0, 0x27, 0x77, 0x73, 0x04, 0xF9, 0x03, 0x20, 0x3C, 0x0C, 0x77,
  0x08, 0xF0, 0x93, 0x08, 0xC0, 0xA7, 0x77, 0x74, 0x03, 0xF9, 0x03, 0x20, 0x9C, 0x05, 0x77, 0x08,
  0xF0, 0x93, 0x0E, 0xC0, 0x37, 0x77, 0x74, 0x03, 0xF9, 0x81, 0x30, 0x1C, 0x0D, 0x77, 0x10, 0x7F,
  0x09, 0x20, 0x5C, 0x0B, 0x77, 0x77, 0x50, 0x2F, 0x98, 0x13, 0x06, 0xC0, 0x67, 0x71, 0x06, 0xF0,
  0x92, 0x0C, 0xC0, 0x47, 0x77, 0x75, 0x01, 0xF9, 0x81, 0x30, 0xCB, 0x0E, 0x77, 0x20, 0x5F, 0x81,
  0x90, 0x2C, 0x0D, 0x77, 0x77, 0x60, 0x1F, 0x90, 0x03, 0xC0, 0x87, 0x72, 0x05, 0xF8, 0x19, 0x08,
  0xC0, 0x67, 0x77, 0x77, 0xF9, 0x03, 0x09, 0xC0, 0x17, 0x72, 0x04, 0xF8, 0x19, 0x0E, 0xB0, 0xE8,
  0x0C, 0x00, 0xF9, 0x03, 0x0E, 0xB0, 0xA7, 0x73, 0x03, 0xF0, 0x80, 0x5C, 0x07, 0x80, 0xC0, 0x00,
  0xEF, 0x07, 0xC0, 0x37, 0x73, 0x03, 0xF0, 0x80, 0xBB, 0x0E, 0x01, 0x80, 0xC0, 0x00, 0xEF, 0x0C,
  0xB0, 0xB7, 0x74, 0x02, 0xF0, 0x9C, 0x08, 0x80, 0xC1, 0x00, 0xDF, 0xC0, 0x47, 0x74, 0x01, 0xF0,
  0xDC, 0x02, 0x80, 0xC1, 0x00, 0xCF, 0xB0, 0xD7, 0x75, 0x01, 0xFC, 0x0A, 0x80, 0xC2, 0x00, 0xBF,
  0xB0, 0x67, 0x76, 0xFC, 0x03, 0x80, 0xC2, 0x00, 0xBF, 0xA0, 0xE7, 0x77, 0xFB, 0x0B, 0x80, 0xC3,
  0x00, 0xAF, 0xA0, 0x77, 0x77, 0x0E, 0xFA, 0x04, 0x80, 0xC3, 0x00, 0x9F, 0xA0, 0x17, 0x77, 0x0D,
  0xF9, 0x0D, 0x80, 0xC4, 0x00, 0x9F, 0x90, 0x97, 0x77, 0x10, 0xCF, 0x90, 0x68, 0x0C, 0x40, 0x08,
  0xF9, 0x02, 0x77, 0x71, 0x0C, 0xF0, 0xE8, 0x0C, 0x50, 0x07, 0xF0, 0xA7, 0x77, 0x20, 0xBF, 0x07,
  0x80, 0xC5, 0x00, 0x7F, 0x03, 0x77, 0x72, 0x0A, 0xE0, 0xE0, 0x17, 0x77, 0x75,
  // "X" (U+0058)
  0x77, 0x03, 0xFF, 0xF0, 0x47, 0x10, 0x8F, 0xFA, 0x09, 0x77, 0x06, 0xFF, 0xF0, 0x17, 0x10, 0xBF,
  0xFA, 0x05, 0x77, 0x09, 0xFF, 0xE0, 0xD7, 0x20, 0xEF, 0xFA, 0x02, 0x77, 0x0C, 0xFF, 0xE0, 0xA7,
  0x10, 0x2F, 0xFA, 0x0E, 0x77, 0x38, 0x12, 0x6D, 0xFC, 0x81, 0xE6, 0x27, 0x60, 0x20, 0x7F, 0xB8,
  0x1A, 0x41, 0x77, 0x70, 0xBF, 0xB0, 0x57, 0x73, 0x08, 0xF0, 0xE0, 0x37, 0x77, 0x30, 0x10, 0xEF,
  0xA0, 0x27, 0x73, 0x06, 0xE0, 0xD0, 0x17, 0x77, 0x50, 0x7F, 0xA0, 0x27, 0x73, 0x09, 0xD0, 0xD0,
  0x17, 0x77, 0x60, 0x1F, 0xA0, 0x57, 0x72, 0x01, 0x0E, 0xC0, 0xE0, 0x27, 0x77, 0x71, 0x0B, 0xF9,
  0x09, 0x77, 0x20, 0x9D, 0x03, 0x77, 0x77, 0x20, 0x6F, 0x90, 0xE7, 0x71, 0x04, 0xD0, 0x57, 0x77,
  0x73, 0x01, 0xFA, 0x03, 0x76, 0x01, 0x0E, 0xC0, 0x87, 0x77, 0x75, 0x0C, 0xF9, 0x08, 0x76, 0x0C,
  0xC0, 0xB7, 0x77, 0x76, 0x07, 0xF9, 0x0D, 0x75, 0x08, 0xC0, 0xD0, 0x17, 0x77, 0x76, 0x02, 0xFA,
  0x02, 0x73, 0x05, 0xC0, 0xE0, 0x28, 0x0C, 0x00, 0x0C, 0xF9, 0x07, 0x72, 0x02, 0x0E, 0xC0, 0x58,
  0x0C, 0x10, 0x07, 0xF9, 0x0C, 0x72, 0x0D, 0xC0, 0x88, 0x0C, 0x20, 0x02, 0xFA, 0x01, 0x70, 0xAC,
  0x0B, 0x80, 0xC4, 0x00, 0xDF, 0x90, 0x56, 0x06, 0xC0, 0xD8, 0x0C, 0x50, 0x08, 0xF9, 0x0A, 0x50,
  0x3C, 0x0E, 0x02, 0x80, 0xC5, 0x00, 0x3F, 0x90, 0xE4, 0x01, 0x0D, 0xC0, 0x48, 0x0C, 0x70, 0x0D,
  0xF9, 0x04, 0x30, 0xBC, 0x07, 0x80, 0xD0, 0x00, 0x8F, 0x90, 0x92, 0x08, 0xC0, 0xA8, 0x0D, 0x10,
  0x03, 0xF9, 0x81, 0xD0, 0x4C, 0x0C, 0x80, 0xD3, 0x00, 0xEF, 0x90, 0x50, 0xEB, 0x0E, 0x02, 0x80,
  0xD3, 0x00, 0x9F, 0xE0, 0x48, 0x0D, 0x40, 0x04, 0xFD, 0x06, 0x80, 0xD6, 0x00, 0xEF, 0xB0, 0x98,
  0x0D, 0x70, 0x09, 0xFA, 0x0C, 0x80, 0xE0, 0x00, 0x4F, 0xA0, 0x18, 0x0E, 0x10, 0x0E, 0xF9, 0x03,
  0x80, 0xE1, 0x00, 0xAF, 0x90, 0x88, 0x0E, 0x10, 0x0B, 0xF9, 0x0D, 0x80, 0xE0, 0x00, 0x8F, 0xB0,
  0x38, 0x0D, 0x60, 0x05, 0xFC, 0x09, 0x80, 0xD5, 0x00, 0x3F, 0xD0, 0xE8, 0x0D, 0x40, 0x01, 0x0E,
  0xC0, 0xDF, 0x90, 0x38, 0x0D, 0x30, 0x0C, 0xC0, 0x70, 0x6F, 0x90, 0x98, 0x0D, 0x20, 0x0A, 0xC8,
  0x1A, 0x01, 0xF9, 0x0E, 0x80, 0xD1, 0x00, 0x7C, 0x0C, 0x30, 0xBF, 0x90, 0x48, 0x0C, 0x70, 0x05,
  0xC0, 0xE0, 0x23, 0x06, 0xF9, 0x09, 0x80, 0xC6, 0x00, 0x20, 0xEC, 0x04, 0x40, 0x1F, 0x90, 0xE8,
  0x0C, 0x50, 0x01, 0x0D, 0xC0, 0x66, 0x0B, 0xF9, 0x04, 0x80, 0xC4, 0x00, 0xBC, 0x09, 0x70, 0x5F,
  0x90, 0x98, 0x0C, 0x30, 0x09, 0xC0, 0xC7, 0x10, 0x1F, 0x90, 0xE8, 0x0C, 0x20, 0x06, 0xC0, 0xE0,
  0x17, 0x20, 0xBF, 0x90, 0x48, 0x0C, 0x00, 0x04, 0xD0, 0x37, 0x30, 0x5F, 0x90, 0x97, 0x77, 0x77,
  0x02, 0x0E, 0xC0, 0x67, 0x40, 0x1F, 0x90, 0xE7, 0x77, 0x76, 0x01, 0x0D, 0xC0, 0x97, 0x60, 0xAF,
  0x90, 0x47, 0x77, 0x75, 0x0B, 0xC0, 0xB7, 0x70, 0x6F, 0x90, 0x97, 0x77, 0x74, 0x08, 0xC0, 0xD0,
  0x17, 0x70, 0x2F, 0x90, 0xE7, 0x77, 0x73, 0x06, 0xD0, 0x37, 0x72, 0x0D, 0xF9, 0x04, 0x77, 0x77,
  0x10, 0x3D, 0x07, 0x77, 0x30, 0xAF, 0x90, 0x97, 0x77, 0x70, 0x10, 0xEC, 0x0B, 0x77, 0x40, 0x6F,
  0x90, 0xE7, 0x77, 0x70, 0xCD, 0x02, 0x77, 0x40, 0x3F, 0xA0, 0x47, 0x77, 0x50, 0xBD, 0x09, 0x77,
  0x6F, 0xA0, 0xA7, 0x77, 0x40, 0x9E, 0x03, 0x77, 0x6F, 0xB0, 0x17, 0x77, 0x20, 0xAF, 0x77, 0x60,
  0x1F, 0xB0, 0xA7, 0x77, 0x02, 0x0C, 0xF9, 0x02, 0x77, 0x50, 0xAF, 0xC0, 0x67, 0x73, 0x81, 0x14,
  0x9F, 0xB8, 0x1D, 0x41, 0x77, 0x81, 0x15, 0xCF, 0xE0, 0xA0, 0x37, 0x70, 0xEF, 0xFB, 0x08, 0x73,
  0x0E, 0xFF, 0xE0, 0xB7, 0x40, 0x2F, 0xFC, 0x05, 0x72, 0x01, 0xFF, 0xF0, 0x87, 0x40, 0x6F, 0xFC,
  0x02, 0x72, 0x05, 0xFF, 0xF0, 0x47, 0x40, 0x9F, 0xFB, 0x0E, 0x73, 0x08, 0xFF, 0xF0, 0x17, 0x40,
  // "Y" (U+0059)
  0x10, 0x5F, 0xFF, 0x02, 0x71, 0x0E, 0xFF, 0xC8, 0x14, 0x08, 0xFF, 0xE0, 0xE7, 0x10, 0x2F, 0xFD,
  0x81, 0x10, 0xCF, 0xFE, 0x0B, 0x71, 0x06, 0xFF, 0xC0, 0xD2, 0x0E, 0xFF, 0xE0, 0x87, 0x10, 0x9F,
  0xFC, 0x0A, 0x40, 0x30, 0xBF, 0xC0, 0x80, 0x27, 0x73, 0x81, 0x15, 0xDF, 0x98, 0x1E, 0x61, 0x71,
  0x0D, 0xFA, 0x09, 0x77, 0x70, 0x4F, 0x0D, 0x02, 0x73, 0x07, 0xFA, 0x05, 0x77, 0x70, 0x2E, 0x0E,
  0x02, 0x74, 0x01, 0xFA, 0x05, 0x77, 0x70, 0x4E, 0x05, 0x76, 0x0B, 0xF9, 0x06, 0x77, 0x70, 0x8D,
  0x09, 0x77, 0x07, 0xF9, 0x09, 0x77, 0x70, 0xEC, 0x0D, 0x77, 0x10, 0x2F, 0x90, 0xC7, 0x76, 0x07,
  0xD0, 0x37, 0x72, 0x0E, 0xF9, 0x77, 0x50, 0x10, 0xEC, 0x08, 0x77, 0x30, 0x9F, 0x90, 0x47, 0x74,
  0x0A, 0xC0, 0xC7, 0x74, 0x05, 0xF9, 0x07, 0x77, 0x30, 0x4C, 0x0E, 0x02, 0x77, 0x40, 0x1F, 0x90,
  0xB7, 0x72, 0x01, 0x0E, 0xC0, 0x67, 0x76, 0x0C, 0xF9, 0x77, 0x20, 0xAC, 0x0A, 0x77, 0x70, 0x8F,
  0x90, 0x37, 0x70, 0x5C, 0x0D, 0x01, 0x77, 0x70, 0x3F, 0x90, 0x77, 0x60, 0x10, 0xEC, 0x04, 0x77,
  0x72, 0x0E, 0xF0, 0xB7, 0x60, 0xBC, 0x08, 0x77, 0x73, 0x0A, 0xF9, 0x75, 0x06, 0xC0, 0xC7, 0x77,
  0x40, 0x6F, 0x90, 0x47, 0x30, 0x2D, 0x02, 0x77, 0x74, 0x01, 0xF9, 0x08, 0x73, 0x0C, 0xC0, 0x67,
  0x77, 0x60, 0xDF, 0x0D, 0x72, 0x08, 0xC0, 0xB7, 0x77, 0x70, 0x8F, 0x90, 0x27, 0x03, 0xC0, 0xE0,
  0x17, 0x77, 0x70, 0x4F, 0x90, 0x67, 0x0D, 0xC0, 0x47, 0x77, 0x72, 0xF9, 0x0A, 0x60, 0x8C, 0x09,
  0x77, 0x77, 0x30, 0xBF, 0x0D, 0x50, 0x3C, 0x0D, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x14, 0x0D, 0xC0,
  0x37, 0x77, 0x74, 0x02, 0xF9, 0x04, 0x30, 0x8C, 0x07, 0x77, 0x77, 0x60, 0xDF, 0x07, 0x20, 0x3C,
  0x0B, 0x77, 0x77, 0x70, 0x9F, 0x0A, 0x20, 0xCB, 0x0E, 0x01, 0x77, 0x77, 0x70, 0x5F, 0x81, 0xD0,
  0x7C, 0x05, 0x80, 0xC0, 0x00, 0x1F, 0x0E, 0x02, 0xC0, 0x98, 0x0C, 0x20, 0x0C, 0xF0, 0xBB, 0x0D,
  0x80, 0xC3, 0x00, 0x7F, 0xC0, 0x38, 0x0C, 0x30, 0x03, 0xFB, 0x07, 0x80, 0xC5, 0x00, 0xEF, 0x90,
  0xC8, 0x0C, 0x60, 0x0B, 0xF9, 0x02, 0x80, 0xC6, 0x00, 0xDF, 0x0C, 0x80, 0xC6, 0x00, 0x1F, 0x90,
  0x98, 0x0C, 0x60, 0x04, 0xF9, 0x05, 0x80, 0xC6, 0x00, 0x7F, 0x90, 0x28, 0x0C, 0x60, 0x0A, 0xF0,
  0xE8, 0x0C, 0x70, 0x0D, 0xF0, 0xB8, 0x0C, 0x60, 0x01, 0xF9, 0x08, 0x80, 0xC6, 0x00, 0x4F, 0x90,
  0x48, 0x0C, 0x60, 0x07, 0xF9, 0x01, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC7, 0x00, 0xDF, 0x0A,
  0x80, 0xC6, 0x00, 0x1F, 0x90, 0x78, 0x0C, 0x60, 0x04, 0xF9, 0x03, 0x80, 0xC6, 0x00, 0x7F, 0x98,
  0x0C, 0x70, 0x0A, 0xF0, 0xC8, 0x0C, 0x70, 0x0E, 0xF0, 0x98, 0x0C, 0x60, 0x02, 0xF9, 0x06, 0x80,
  0xC6, 0x00, 0x6F, 0x90, 0x38, 0x0C, 0x60, 0x0C, 0xF9, 0x01, 0x80, 0xC5, 0x00, 0x5F, 0xA0, 0x38,
  0x0C, 0x40, 0x04, 0x0E, 0xFA, 0x09, 0x80, 0xC0, 0x08, 0x21, 0x37, 0xCF, 0xD8, 0x2B, 0x52, 0x17,
  0x77, 0x71, 0x08, 0xFF, 0xFB, 0x04, 0x77, 0x75, 0x0B, 0xFF, 0xFB, 0x01, 0x77, 0x75, 0x0E, 0xFF,
  0xFA, 0x0D, 0x77, 0x75, 0x02, 0xFF, 0xFB, 0x0A, 0x77, 0x75,
  // "Z" (U+005A)
  0x76, 0x05, 0x80, 0xC2, 0xF0, 0xB7, 0x60, 0x98, 0x0C, 0x2F, 0x08, 0x76, 0x0D, 0x80, 0xC2, 0xF0,
  0x57, 0x50, 0x18, 0x0C, 0x3F, 0x01, 0x75, 0x05, 0xF8, 0x1E, 0xA7, 0x80, 0x96, 0x60, 0xEF, 0xA0,
  0x77, 0x60, 0x9E, 0x08, 0x77, 0x60, 0x8F, 0xA0, 0xB7, 0x70, 0xDD, 0x06, 0x77, 0x60, 0x4F, 0xA0,
  0xE0, 0x17, 0x60, 0x1D, 0x0A, 0x77, 0x60, 0x10, 0xEF, 0xA0, 0x47, 0x70, 0x5C, 0x0D, 0x01, 0x77,
  0x60, 0xBF, 0xA0, 0x87, 0x71, 0x09, 0xC0, 0x67, 0x76, 0x06, 0xFA, 0x0C, 0x77, 0x20, 0xDB, 0x0E,
  0x77, 0x60, 0x3F, 0xA0, 0xE0, 0x27, 0x71, 0x01, 0xC0, 0x77, 0x76, 0x0D, 0xFA, 0x05, 0x77, 0x20,
  0x5C, 0x02, 0x77, 0x50, 0x9F, 0xA0, 0xA7, 0x73, 0x09, 0xB0, 0xD7, 0x75, 0x05, 0xFA, 0x0D, 0x77,
  0x40, 0xDB, 0x08, 0x77, 0x40, 0x10, 0xEF, 0xA0, 0x37, 0x74, 0x80, 0x06, 0x01, 0x77, 0x40, 0xBF,
  0xA0, 0x78, 0x0C, 0x50, 0x07, 0xFA, 0x0B, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0xE0, 0x18, 0x0C, 0x40,
  0x01, 0x0D, 0xFA, 0x04, 0x80, 0xC5, 0x00, 0xAF, 0xA0, 0x88, 0x0C, 0x50, 0x06, 0xFA, 0x0C, 0x80,
  0xC5, 0x00, 0x20, 0xEF, 0x90, 0xE0, 0x28, 0x0C, 0x50, 0x0C, 0xFA, 0x05, 0x80, 0xC5, 0x00, 0x8F,
  0xA0, 0xA8, 0x0C, 0x50, 0x04, 0xFA, 0x0D, 0x80, 0xC5, 0x00, 0x10, 0xEF, 0xA0, 0x38, 0x0C, 0x50,
  0x0B, 0xFA, 0x07, 0x80, 0xC5, 0x00, 0x6F, 0xA0, 0xB8, 0x0C, 0x50, 0x02, 0xFA, 0x0E, 0x01, 0x80,
  0xC5, 0x00, 0xDF, 0xA0, 0x48, 0x0C, 0x50, 0x09, 0xFA, 0x08, 0x80, 0xC5, 0x00, 0x5F, 0xA0, 0xC8,
  0x0C, 0x50, 0x01, 0x0E, 0xF9, 0x0E, 0x02, 0x80, 0xC5, 0x00, 0xBF, 0xA0, 0x68, 0x0C, 0x50, 0x07,
  0xFA, 0x0A, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0xD0, 0x18, 0x0C, 0x50, 0x0D, 0xFA, 0x03, 0x80, 0xC5,
  0x00, 0xAF, 0xA0, 0x78, 0x0C, 0x50, 0x05, 0xFA, 0x0B, 0x80, 0xC5, 0x00, 0x20, 0xEF, 0x90, 0xE0,
  0x18, 0x0C, 0x50, 0x0C, 0xFA, 0x04, 0x80, 0xC5, 0x00, 0x8F, 0xA0, 0x98, 0x0C, 0x50, 0x04, 0xFA,
  0x0C, 0x80, 0xC5, 0x00, 0x10, 0xEF, 0x90, 0xE0, 0x28, 0x0C, 0x50, 0x0B, 0xFA, 0x06, 0x80, 0xC5,
  0x00, 0x6F, 0xA0, 0xA8, 0x0C, 0x50, 0x02, 0xFA, 0x0D, 0x01, 0x80, 0xC5, 0x00, 0xDF, 0xA0, 0x38,
  0x0C, 0x50, 0x09, 0xFA, 0x07, 0x77, 0x78, 0x00, 0x67, 0x72, 0x05, 0xFA, 0x0B, 0x77, 0x70, 0x5B,
  0x0E, 0x77, 0x10, 0x10, 0xEF, 0x90, 0xE0, 0x17, 0x77, 0x09, 0xB0, 0xB7, 0x71, 0x0B, 0xFA, 0x04,
  0x77, 0x71, 0x0E, 0xB0, 0x77, 0x70, 0x7F, 0xA0, 0x97, 0x77, 0x10, 0x3C, 0x03, 0x76, 0x03, 0xFA,
  0x0C, 0x77, 0x72, 0x08, 0xB0, 0xE7, 0x70, 0xDF, 0xA0, 0x27, 0x77, 0x20, 0xEB, 0x0B, 0x76, 0x0A,
  0xFA, 0x06, 0x77, 0x72, 0x07, 0xC0, 0x77, 0x50, 0x5F, 0xA0, 0xA7, 0x77, 0x20, 0x20, 0xEC, 0x03,
  0x74, 0x02, 0x0E, 0xF9, 0x0D, 0x01, 0x77, 0x71, 0x01, 0x0D, 0xD7, 0x50, 0xCF, 0xA0, 0x37, 0x77,
  0x10, 0x40, 0xDD, 0x0B, 0x74, 0x08, 0xFA, 0x0C, 0x80, 0xA0, 0x68, 0x17, 0x9D, 0xF0, 0x77, 0x30,
  0x38, 0x0C, 0x5F, 0x04, 0x73, 0x07, 0x80, 0xC5, 0xF7, 0x40, 0xA8, 0x0C, 0x4F, 0x0B, 0x74, 0x0D,
  0x80, 0xC4, 0xF0, 0x87, 0x40,
  // "[" (U+005B)
  0x77, 0x30, 0xCF, 0xFB, 0x02, 0x77, 0x3F, 0xFB, 0x0E, 0x77, 0x30, 0x3F, 0xFB, 0x0B, 0x77, 0x30,
  0x7F, 0xFB, 0x07, 0x77, 0x30, 0xAF, 0xA8, 0x2E, 0x94, 0x17, 0x77, 0x10, 0xDF, 0x90, 0xB0, 0x17,
  0x77, 0x30, 0x1F, 0x90, 0xD7, 0x77, 0x50, 0x4F, 0x90, 0x57, 0x77, 0x50, 0x8F, 0x0E, 0x77, 0x76,
  0x0B, 0xF0, 0x97, 0x77, 0x60, 0xEF, 0x06, 0x77, 0x75, 0x02, 0xF9, 0x02, 0x77, 0x75, 0x05, 0xF0,
  0xE7, 0x77, 0x60, 0x9F, 0x0B, 0x77, 0x76, 0x0C, 0xF0, 0x87, 0x77, 0x6F, 0x90, 0x47, 0x77, 0x50,
  0x3F, 0x90, 0x17, 0x77, 0x50, 0x6F, 0x0D, 0x77, 0x76, 0x0A, 0xF0, 0xA7, 0x77, 0x60, 0xDF, 0x07,
  0x77, 0x75, 0x01, 0xF9, 0x03, 0x77, 0x75, 0x04, 0xF9, 0x77, 0x76, 0x07, 0xF0, 0xC7, 0x77, 0x60,
  0xBF, 0x09, 0x77, 0x76, 0x0E, 0xF0, 0x57, 0x77, 0x50, 0x2F, 0x90, 0x27, 0x77, 0x50, 0x5F, 0x0E,
  0x77, 0x76, 0x08, 0xF0, 0xB7, 0x77, 0x60, 0xCF, 0x08, 0x77, 0x76, 0xF9, 0x04, 0x77, 0x75, 0x03,
  0xF9, 0x01, 0x77, 0x75, 0x06, 0xF0, 0xD7, 0x77, 0x60, 0x9F, 0x0A, 0x77, 0x76, 0x0D, 0xF0, 0x67,
  0x77, 0x50, 0x1F, 0x90, 0x37, 0x77, 0x50, 0x4F, 0x97, 0x77, 0x60, 0x7F, 0x0C, 0x77, 0x76, 0x0A,
  0xF0, 0x97, 0x77, 0x60, 0xEF, 0x05, 0x77, 0x75, 0x01, 0xF9, 0x02, 0x77, 0x75, 0x05, 0xF0, 0xE7,
  0x77, 0x60, 0x8F, 0x0B, 0x77, 0x76, 0x0B, 0xF0, 0x77, 0x77, 0x60, 0xEF, 0x04, 0x77, 0x75, 0x02,
  0xF9, 0x01, 0x77, 0x75, 0x06, 0xF0, 0xD7, 0x77, 0x60, 0x9F, 0x0A, 0x77, 0x76, 0x0C, 0xF0, 0x67,
  0x77, 0x6F, 0x90, 0x37, 0x77, 0x50, 0x3F, 0x97, 0x77, 0x60, 0x7F, 0x0C, 0x77, 0x76, 0x0A, 0xF0,
  0x97, 0x77, 0x60, 0xDF, 0x05, 0x77, 0x75, 0x01, 0xF9, 0x02, 0x77, 0x75, 0x04, 0xF0, 0xE7, 0x77,
  0x60, 0x8F, 0x0B, 0x77, 0x76, 0x0B, 0xF0, 0x77, 0x77, 0x60, 0xEF, 0x04, 0x77, 0x75, 0x02, 0xF9,
  0x01, 0x77, 0x75, 0x05, 0xF0, 0xD7, 0x77, 0x60, 0x9F, 0x0A, 0x77, 0x76, 0x0C, 0xF0, 0x67, 0x77,
  0x6F, 0x90, 0x37, 0x77, 0x50, 0x3F, 0x97, 0x77, 0x60, 0x6F, 0x0C, 0x77, 0x76, 0x0A, 0xF0, 0x87,
  0x77, 0x60, 0xDF, 0x05, 0x77, 0x75, 0x01, 0xF9, 0x02, 0x77, 0x75, 0x04, 0xF0, 0xE7, 0x77, 0x60,
  0x7F, 0x0B, 0x77, 0x76, 0x0B, 0xF0, 0x87, 0x77, 0x60, 0xEF, 0x06, 0x77, 0x75, 0x02, 0xF9, 0x05,
  0x77, 0x75, 0x05, 0xF9, 0x06, 0x77, 0x75, 0x08, 0xF9, 0x0C, 0x77, 0x75, 0x0C, 0xFA, 0x82, 0xC6,
  0x21, 0x77, 0x71, 0xFF, 0xB0, 0xE7, 0x73, 0x03, 0xFF, 0xB0, 0xB7, 0x73, 0x06, 0xFF, 0xB0, 0x87,
  0x73, 0x09, 0xFF, 0xB0, 0x57, 0x73,
  // "\" (U+005C)
  0x02, 0xC0, 0x73, 0x01, 0xC0, 0x83, 0x01, 0xC0, 0x94, 0xC0, 0x94, 0xC0, 0xA4, 0x0E, 0xB0, 0xB4,
  0x0E, 0xB0, 0xB4, 0x0D, 0xB0, 0xC4, 0x0C, 0xB0, 0xD4, 0x0C, 0xB0, 0xD4, 0x0B, 0xB0, 0xE4, 0x0A,
  0xC4, 0x0A, 0xC4, 0x09, 0xC4, 0x09, 0xC0, 0x13, 0x08, 0xC0, 0x23, 0x07, 0xC0, 0x23, 0x07, 0xC0,
  0x33, 0x06, 0xC0, 0x43, 0x05, 0xC0, 0x43, 0x05, 0xC0, 0x53, 0x04, 0xC0, 0x63, 0x03, 0xC0, 0x63,
  0x03, 0xC0, 0x73, 0x02, 0xC0, 0x73, 0x01, 0xC0, 0x83, 0x01, 0xC0, 0x94, 0xC0, 0x94, 0xC0, 0xA4,
  0x0E, 0xB0, 0xB4, 0x0E, 0xB0, 0xB4, 0x0D, 0xB0, 0xC4, 0x0C, 0xB0, 0xD4, 0x0C, 0xB0, 0xD4, 0x0B,
  0xB0, 0xE4, 0x0A, 0xC4, 0x0A, 0xC4, 0x09, 0xC0, 0x13, 0x08, 0xC0, 0x13, 0x08, 0xC0, 0x23, 0x07,
  0xC0, 0x23, 0x06, 0xC0, 0x33, 0x06, 0xC0, 0x43, 0x05, 0xC0, 0x43, 0x04, 0xC0, 0x53, 0x04, 0xC0,
  0x63, 0x03, 0xC0, 0x63, 0x02, 0xC0, 0x73, 0x02, 0xC0, 0x83, 0x01, 0xC0, 0x84, 0xC0, 0x94, 0xC0,
  0xA4, 0xC0, 0xA4, 0x0E, 0xB0, 0xB4, 0x0D, 0xB0, 0xC4, 0x0D, 0xB0, 0xC4, 0x0C, 0xB0, 0xD4, 0x0B,
  0xB0, 0xE4, 0x0B, 0xB0, 0xE4, 0x0A, 0xC4, 0x09, 0xC4, 0x09, 0xC0, 0x13, 0x08, 0xC0, 0x13, 0x07,
  0xC0, 0x23, 0x07, 0xC0, 0x33, 0x06, 0xC0, 0x33, 0x06, 0xC0, 0x43, 0x05, 0xC0, 0x53, 0x04, 0xC0,
  0x53, 0x04, 0xC0, 0x63, 0x03, 0xC0, 0x73, 0x02, 0xC0, 0x73, 0x02, 0xC0, 0x83, 0x01, 0xC0, 0x94,
  0xC0, 0x94, 0xC0, 0xA4, 0xC0, 0xA4, 0x0E, 0xB0, 0xB4, 0x0D, 0xB0, 0xC0,
  // "]" (U+005D)
  0x77, 0x20, 0x3F, 0xFB, 0x0A, 0x77, 0x20, 0x7F, 0xFB, 0x07, 0x77, 0x20, 0xAF, 0xFB, 0x03, 0x77,
  0x20, 0xEF, 0xFB, 0x77, 0x78, 0x21, 0x26, 0xCF, 0xA0, 0xC7, 0x77, 0x40, 0xBF, 0x90, 0x97, 0x77,
  0x40, 0x4F, 0x90, 0x67, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x77, 0x40, 0x5F, 0x0E, 0x77, 0x75, 0x07,
  0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x08, 0x77, 0x75, 0x0D, 0xF0, 0x57, 0x77, 0x40, 0x1F, 0x90, 0x27,
  0x77, 0x40, 0x4F, 0x0E, 0x77, 0x75, 0x07, 0xF0, 0xB7, 0x77, 0x50, 0xBF, 0x07, 0x77, 0x75, 0x0E,
  0xF0, 0x47, 0x77, 0x40, 0x2F, 0x90, 0x17, 0x77, 0x40, 0x5F, 0x0D, 0x77, 0x75, 0x08, 0xF0, 0xA7,
  0x77, 0x50, 0xCF, 0x06, 0x77, 0x75, 0xF9, 0x03, 0x77, 0x74, 0x03, 0xF9, 0x77, 0x75, 0x06, 0xF0,
  0xC7, 0x77, 0x50, 0xAF, 0x09, 0x77, 0x75, 0x0D, 0xF0, 0x67, 0x77, 0x40, 0x1F, 0x90, 0x27, 0x77,
  0x40, 0x4F, 0x0E, 0x77, 0x75, 0x07, 0xF0, 0xB7, 0x77, 0x50, 0xBF, 0x08, 0x77, 0x75, 0x0E, 0xF0,
  0x57, 0x77, 0x40, 0x2F, 0x90, 0x17, 0x77, 0x40, 0x5F, 0x0E, 0x77, 0x75, 0x08, 0xF0, 0xA7, 0x77,
  0x50, 0xCF, 0x07, 0x77, 0x75, 0xF9, 0x04, 0x77, 0x74, 0x03, 0xF9, 0x01, 0x77, 0x74, 0x06, 0xF0,
  0xD7, 0x77, 0x50, 0x9F, 0x09, 0x77, 0x75, 0x0D, 0xF0, 0x67, 0x77, 0x40, 0x1F, 0x90, 0x37, 0x77,
  0x40, 0x4F, 0x97, 0x77, 0x50, 0x7F, 0x0C, 0x77, 0x75, 0x0A, 0xF0, 0x97, 0x77, 0x50, 0xEF, 0x05,
  0x77, 0x74, 0x02, 0xF9, 0x02, 0x77, 0x74, 0x05, 0xF0, 0xE7, 0x77, 0x50, 0x8F, 0x0B, 0x77, 0x75,
  0x0B, 0xF0, 0x87, 0x77, 0x50, 0xEF, 0x04, 0x77, 0x74, 0x03, 0xF9, 0x01, 0x77, 0x74, 0x06, 0xF0,
  0xD7, 0x77, 0x50, 0x9F, 0x0A, 0x77, 0x75, 0x0D, 0xF0, 0x77, 0x77, 0x5F, 0x90, 0x37, 0x77, 0x40,
  0x4F, 0x97, 0x77, 0x50, 0x7F, 0x0C, 0x77, 0x75, 0x0A, 0xF0, 0x97, 0x77, 0x50, 0xEF, 0x06, 0x77,
  0x74, 0x01, 0xF9, 0x03, 0x77, 0x74, 0x05, 0xF0, 0xE7, 0x77, 0x50, 0x8F, 0x0B, 0x77, 0x75, 0x0B,
  0xF0, 0x87, 0x77, 0x50, 0xEF, 0x05, 0x77, 0x74, 0x02, 0xF9, 0x02, 0x77, 0x74, 0x06, 0xF0, 0xE7,
  0x77, 0x50, 0x9F, 0x0B, 0x77, 0x75, 0x0C, 0xF0, 0x77, 0x77, 0x5F, 0x90, 0x47, 0x77, 0x40, 0x4F,
  0x90, 0x17, 0x77, 0x40, 0x8F, 0x0D, 0x77, 0x75, 0x0C, 0xF0, 0xA7, 0x77, 0x40, 0x3F, 0x90, 0x67,
  0x77, 0x40, 0xCF, 0x90, 0x37, 0x77, 0x20, 0x10, 0xBF, 0xA7, 0x77, 0x82, 0x14, 0x9E, 0xFA, 0x0C,
  0x77, 0x20, 0x5F, 0xFB, 0x09, 0x77, 0x20, 0x9F, 0xFB, 0x06, 0x77, 0x20, 0xCF, 0xFB, 0x02, 0x77,
  0x2F, 0xFB, 0x0E, 0x77, 0x30,
  // "^" (U+005E)
  0x77, 0x20, 0xBA, 0x06, 0x77, 0x77, 0x30, 0x2B, 0x0C, 0x77, 0x77, 0x30, 0x8C, 0x03, 0x77, 0x77,
  0x20, 0xEC, 0x09, 0x77, 0x77, 0x10, 0x5E, 0x01, 0x77, 0x77, 0x0C, 0xE0, 0x67, 0x77, 0x60, 0x2F,
  0x0D, 0x77, 0x76, 0x09, 0xF9, 0x03, 0x77, 0x75, 0x0E, 0xB0, 0xEC, 0x0A, 0x77, 0x74, 0x06, 0xC0,
  0x60, 0xDC, 0x01, 0x77, 0x73, 0x0C, 0xB8, 0x1E, 0x07, 0xC0, 0x77, 0x77, 0x20, 0x3C, 0x81, 0x90,
  0x1C, 0x0D, 0x77, 0x72, 0x09, 0xC0, 0x32, 0x0A, 0xC0, 0x47, 0x77, 0x10, 0xEB, 0x0D, 0x30, 0x4C,
  0x0A, 0x77, 0x70, 0x6C, 0x07, 0x40, 0xDC, 0x01, 0x77, 0x60, 0xCC, 0x01, 0x40, 0x7C, 0x07, 0x77,
  0x50, 0x3C, 0x0A, 0x50, 0x1C, 0x0D, 0x77, 0x50, 0x9C, 0x04, 0x60, 0xAC, 0x04, 0x77, 0x40, 0xEB,
  0x0D, 0x70, 0x4C, 0x0B, 0x77, 0x30, 0x6C, 0x08, 0x71, 0x0D, 0xC0, 0x17, 0x72, 0x0C, 0xC0, 0x27,
  0x10, 0x7C, 0x08, 0x77, 0x10, 0x3C, 0x0B, 0x72, 0x01, 0xC0, 0xE7, 0x71, 0x09, 0xC0, 0x57, 0x30,
  0xBC, 0x05, 0x76, 0x01, 0xC0, 0xE7, 0x40, 0x4C, 0x0B, 0x76, 0x06, 0xC0, 0x97, 0x50, 0xEC, 0x02,
  0x75, 0x0D, 0xC0, 0x27, 0x50, 0x8C, 0x08, 0x74, 0x03, 0xC0, 0xC7, 0x60, 0x2C, 0x0E, 0x74, 0x0A,
  0xC0, 0x67, 0x70, 0xBC, 0x05, 0x72, 0x01, 0xC0, 0xE7, 0x71, 0x05, 0xC0, 0xB7, 0x20, 0x7C, 0x09,
  0x77, 0x20, 0xEC, 0x02, 0x71, 0x0D, 0xC0, 0x37, 0x72, 0x08, 0xC0, 0x87, 0x04, 0xC0, 0xD7, 0x73,
  0x02, 0xC0, 0xE7, 0x0A, 0xC0, 0x77, 0x74, 0x0B, 0xC0, 0x55, 0x01, 0xD0, 0x17, 0x74, 0x05, 0xC0,
  0xC5, 0x07, 0xC0, 0xA7, 0x76, 0x0E, 0xC0, 0x34, 0x0D, 0xC0, 0x47, 0x76, 0x08, 0xC0, 0x93, 0x04,
  0xC0, 0xD7, 0x77, 0x02, 0xC0, 0xE3, 0x0A, 0xC0, 0x87, 0x77, 0x10, 0xCC, 0x81, 0x60, 0x1D, 0x02,
  0x77, 0x71, 0x06, 0xC8, 0x1C, 0x07, 0xC0, 0xB7, 0x77, 0x30, 0xEC, 0x03,
  // "_" (U+005F)
  0x10, 0x6F, 0xFF, 0xFF, 0x81, 0xD0, 0xAF, 0xFF, 0xFF, 0x81, 0x90, 0xDF, 0xFF, 0xFF, 0x05, 0x01,
  0x80, 0xC0, 0xF0, 0x20, 0x5F, 0xFF, 0xFF, 0x0E, 0x10,
  // "`" (U+0060)
  0x06, 0x80, 0x37, 0x04, 0x50, 0xEF, 0x0C, 0x50, 0x6F, 0x90, 0x25, 0x0C, 0xF0, 0x75, 0x02, 0xF0,
  0xC6, 0x07, 0xF0, 0x26, 0x0C, 0xE0, 0x86, 0x01, 0x0E, 0xD0, 0xE7, 0x05, 0xE0, 0x57, 0x08, 0xD0,
  0xB7, 0x10, 0xBD, 0x01, 0x70, 0x10, 0xDC, 0x07, 0x71, 0x03, 0x0E, 0xB0, 0xD7, 0x20, 0x4C, 0x04,
  0x72, 0x06, 0xB0, 0x40,
  // "a" (U+0061)
  0x77, 0x58, 0x91, 0x16, 0x9C, 0xEF, 0xED, 0xB8, 0x47, 0x77, 0x71, 0x03, 0x0B, 0xFC, 0x0D, 0x06,
  0x40, 0x10, 0xBA, 0x07, 0x77, 0x20, 0x10, 0xAF, 0xF9, 0x83, 0xD2, 0x06, 0xEB, 0x03, 0x77, 0x10,
  0x50, 0xEF, 0xFB, 0x0E, 0x0B, 0xD7, 0x71, 0x08, 0xF9, 0x84, 0xE9, 0x76, 0x8C, 0xFC, 0x0C, 0x77,
  0x0A, 0xF0, 0xD0, 0x56, 0x03, 0x0D, 0xFA, 0x09, 0x76, 0x0A, 0xF0, 0xB0, 0x17, 0x10, 0x10, 0xDF,
  0x90, 0x67, 0x50, 0x8F, 0x0A, 0x74, 0x05, 0xF9, 0x03, 0x74, 0x05, 0xF0, 0xB7, 0x50, 0x2F, 0x97,
  0x40, 0x10, 0xEE, 0x0D, 0x76, 0x05, 0xF0, 0xC7, 0x40, 0xBF, 0x03, 0x76, 0x09, 0xF0, 0x87, 0x30,
  0x7F, 0x09, 0x77, 0x0C, 0xF0, 0x57, 0x20, 0x1F, 0x0E, 0x01, 0x77, 0xF9, 0x02, 0x72, 0x09, 0xF0,
  0x87, 0x70, 0x3F, 0x0E, 0x72, 0x02, 0xF0, 0xE0, 0x17, 0x70, 0x6F, 0x0B, 0x72, 0x0A, 0xF0, 0x87,
  0x71, 0x09, 0xF0, 0x87, 0x10, 0x2F, 0x90, 0x27, 0x71, 0x0C, 0xF0, 0x47, 0x10, 0x9F, 0x0B, 0x77,
  0x2F, 0x90, 0x17, 0x10, 0xEF, 0x05, 0x77, 0x10, 0x3F, 0x0D, 0x71, 0x05, 0xF0, 0xE7, 0x72, 0x06,
  0xF0, 0xA7, 0x10, 0xBF, 0x0A, 0x77, 0x20, 0xAF, 0x07, 0x70, 0x1F, 0x90, 0x67, 0x72, 0x0D, 0xF0,
  0x47, 0x06, 0xF9, 0x02, 0x77, 0x10, 0x1F, 0x97, 0x10, 0xAF, 0x0D, 0x77, 0x20, 0x4F, 0x0D, 0x71,
  0x0E, 0xF0, 0x97, 0x72, 0x07, 0xF0, 0x97, 0x03, 0xF9, 0x06, 0x77, 0x20, 0xBF, 0x06, 0x70, 0x7F,
  0x90, 0x27, 0x72, 0xF9, 0x03, 0x70, 0xAF, 0x0E, 0x77, 0x20, 0x4F, 0x97, 0x10, 0xDF, 0x0C, 0x77,
  0x20, 0x9F, 0x0C, 0x71, 0xF9, 0x0A, 0x77, 0x20, 0xEF, 0x09, 0x70, 0x1F, 0x90, 0x87, 0x71, 0x05,
  0xF9, 0x06, 0x70, 0x3F, 0x90, 0x57, 0x71, 0x0B, 0xF9, 0x03, 0x70, 0x4F, 0x90, 0x47, 0x70, 0x2F,
  0xA7, 0x10, 0x5F, 0x90, 0x37, 0x70, 0x9F, 0x90, 0xD7, 0x10, 0x6F, 0x90, 0x37, 0x60, 0x1F, 0xA0,
  0xA7, 0x10, 0x5F, 0x90, 0x27, 0x60, 0x8F, 0xA0, 0x87, 0x10, 0x5F, 0x90, 0x37, 0x50, 0x2A, 0x0D,
  0xF0, 0x57, 0x10, 0x4F, 0x90, 0x37, 0x58, 0x2B, 0xFD, 0x7F, 0x03, 0x71, 0x02, 0xF9, 0x05, 0x74,
  0x05, 0xA0, 0x60, 0xAF, 0x01, 0x72, 0xF9, 0x07, 0x73, 0x84, 0x1E, 0xFD, 0x0C, 0xF7, 0x30, 0xDF,
  0x0A, 0x73, 0x0B, 0xA8, 0x14, 0x0E, 0xE0, 0xE7, 0x30, 0x9F, 0x0E, 0x72, 0x09, 0xA0, 0xB2, 0xF0,
  0xE7, 0x30, 0x5F, 0x90, 0x57, 0x08, 0xA8, 0x2E, 0x20, 0x1F, 0x97, 0x01, 0x30, 0xEF, 0x0D, 0x01,
  0x50, 0xAB, 0x05, 0x20, 0x1F, 0x90, 0x55, 0x81, 0x8E, 0x12, 0x08, 0xF9, 0x84, 0xD4, 0x01, 0x6D,
  0xB0, 0x94, 0xF9, 0x84, 0xD3, 0x02, 0x7E, 0xA0, 0x92, 0x01, 0xFF, 0xA0, 0xA5, 0x0C, 0xFF, 0x90,
  0xC3, 0x07, 0xFF, 0x0B, 0x60, 0x6F, 0xF0, 0x85, 0x0A, 0xFD, 0x08, 0x71, 0x0D, 0xFC, 0x0B, 0x02,
  0x70, 0x8F, 0xA0, 0xC0, 0x37, 0x20, 0x20, 0xDF, 0x90, 0xC0, 0x47, 0x38, 0x72, 0x8C, 0xEF, 0xDC,
  0x83, 0x76, 0x86, 0x7C, 0xEF, 0xEB, 0x83, 0x60,
  // "b" (U+0062)
  0x70, 0x3F, 0xF9, 0x77, 0x74, 0x06, 0xFF, 0x0C, 0x77, 0x74, 0x0A, 0xFF, 0x08, 0x77, 0x74, 0x0D,
  0xFF, 0x05, 0x77, 0x76, 0x81, 0x26, 0xCF, 0xB0, 0x27, 0x77, 0x72, 0x0A, 0xF9, 0x0E, 0x77, 0x77,
  0x30, 0x3F, 0x90, 0xB7, 0x77, 0x73, 0x01, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x1F, 0x90, 0x47, 0x77,
  0x73, 0x03, 0xF9, 0x01, 0x77, 0x77, 0x30, 0x6F, 0x0D, 0x77, 0x77, 0x40, 0x9F, 0x0A, 0x77, 0x77,
  0x40, 0xCF, 0x07, 0x77, 0x77, 0x4F, 0x90, 0x37, 0x77, 0x73, 0x03, 0xF9, 0x77, 0x77, 0x40, 0x7F,
  0x0C, 0x77, 0x77, 0x40, 0xAF, 0x09, 0x77, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x77, 0x30, 0x1F, 0x90,
  0x27, 0x77, 0x73, 0x04, 0xF0, 0xE7, 0x87, 0x49, 0xCE, 0xFD, 0xB6, 0x17, 0x72, 0x08, 0xF0, 0xB5,
  0x05, 0x0D, 0xF9, 0x0E, 0x04, 0x77, 0x10, 0xBF, 0x07, 0x40, 0xAF, 0xD0, 0x67, 0x70, 0xEF, 0x03,
  0x20, 0x10, 0xCF, 0xF0, 0x47, 0x50, 0x2F, 0x0E, 0x20, 0x10, 0xCF, 0xF9, 0x0D, 0x75, 0x06, 0xF0,
  0x92, 0x0B, 0xB8, 0x4B, 0x41, 0x06, 0xEF, 0x90, 0x77, 0x40, 0x9F, 0x81, 0x50, 0x8B, 0x06, 0x50,
  0x3F, 0x90, 0xD7, 0x40, 0xDF, 0x01, 0x04, 0xB0, 0x47, 0x09, 0xF9, 0x03, 0x73, 0xF8, 0x1B, 0x0D,
  0xA0, 0x57, 0x10, 0x2F, 0x90, 0x77, 0x20, 0x4F, 0x06, 0x09, 0xA0, 0x87, 0x30, 0xDF, 0x0A, 0x72,
  0x07, 0xF0, 0x4A, 0x0C, 0x74, 0x0A, 0xF0, 0xD7, 0x20, 0xBE, 0x0D, 0x0B, 0xA0, 0x27, 0x40, 0x8F,
  0x97, 0x20, 0xEF, 0xA0, 0x87, 0x50, 0x6F, 0x90, 0x17, 0x02, 0xFA, 0x0E, 0x01, 0x75, 0x05, 0xF9,
  0x01, 0x70, 0x5F, 0xA0, 0x77, 0x60, 0x5F, 0x90, 0x27, 0x08, 0xF9, 0x0E, 0x77, 0x06, 0xF9, 0x02,
  0x70, 0xCF, 0x90, 0x77, 0x70, 0x6F, 0x90, 0x27, 0xF9, 0x0E, 0x01, 0x77, 0x07, 0xF9, 0x01, 0x60,
  0x3F, 0x90, 0x97, 0x71, 0x08, 0xF9, 0x70, 0x6F, 0x90, 0x27, 0x71, 0x0A, 0xF0, 0xE7, 0x0A, 0xF0,
  0xC7, 0x72, 0x0C, 0xF0, 0xC7, 0x0D, 0xF0, 0x67, 0x72, 0x0E, 0xF0, 0xA6, 0x01, 0xF9, 0x01, 0x77,
  0x10, 0x2F, 0x90, 0x76, 0x04, 0xF0, 0xC7, 0x72, 0x05, 0xF9, 0x04, 0x60, 0x8F, 0x08, 0x77, 0x20,
  0x8F, 0x90, 0x16, 0x0B, 0xF0, 0x57, 0x72, 0x0B, 0xF0, 0xD7, 0x0E, 0xF0, 0x27, 0x72, 0x0E, 0xF0,
  0x96, 0x02, 0xF0, 0xE7, 0x72, 0x04, 0xF9, 0x05, 0x60, 0x6F, 0x0B, 0x77, 0x20, 0x8F, 0x97, 0x09,
  0xF0, 0x87, 0x72, 0x0C, 0xF0, 0xA7, 0x0C, 0xF0, 0x47, 0x71, 0x02, 0xF9, 0x04, 0x7F, 0x90, 0x17,
  0x71, 0x07, 0xF0, 0xE7, 0x04, 0xF0, 0xD7, 0x72, 0x0D, 0xF0, 0x77, 0x07, 0xF0, 0xA7, 0x71, 0x03,
  0xF9, 0x01, 0x70, 0xAF, 0x07, 0x77, 0x10, 0xAF, 0x08, 0x71, 0x0E, 0xF0, 0x47, 0x70, 0x2F, 0x0E,
  0x01, 0x70, 0x2F, 0x97, 0x71, 0x09, 0xF0, 0x77, 0x10, 0x5F, 0x0D, 0x77, 0x02, 0xF0, 0xE7, 0x20,
  0x8F, 0x09, 0x77, 0x0A, 0xF0, 0x57, 0x20, 0xCF, 0x06, 0x76, 0x05, 0xF0, 0xA7, 0x3F, 0x90, 0x37,
  0x50, 0x10, 0xEE, 0x0D, 0x01, 0x72, 0x03, 0xF9, 0x76, 0x0C, 0xF0, 0x37, 0x30, 0x6F, 0x0E, 0x75,
  0x0B, 0xF0, 0x67, 0x40, 0xAF, 0x90, 0xA7, 0x20, 0x10, 0xBF, 0x08, 0x75, 0x0D, 0xFA, 0x0C, 0x02,
  0x60, 0x60, 0xEF, 0x08, 0x75, 0x01, 0xFD, 0x84, 0xB8, 0x67, 0xAE, 0xF9, 0x06, 0x76, 0x04, 0xD0,
  0xAF, 0xFC, 0x0D, 0x03, 0x77, 0x08, 0xB8, 0x3E, 0x40, 0x3D, 0xFF, 0x90, 0x97, 0x72, 0x0B, 0xA0,
  0xA0, 0x14, 0x07, 0x0E, 0xFB, 0x81, 0xE9, 0x27, 0x77, 0x78, 0x90, 0x59, 0xCE, 0xFE, 0xDC, 0x95,
  0x77, 0x60,
  // "c" (U+0063)
  0x77, 0x58, 0x92, 0x26, 0x9C, 0xDE, 0xFE, 0xDB, 0x83, 0x77, 0x72, 0x05, 0x0B, 0xFD, 0x0D, 0x05,
  0x77, 0x50, 0x40, 0xCF, 0xFA, 0x09, 0x77, 0x30, 0x9F, 0xFD, 0x09, 0x77, 0x02, 0x0C, 0xF8, 0x3B,
  0x76, 0x8D, 0xFA, 0x05, 0x75, 0x03, 0x0E, 0xE0, 0xA0, 0x15, 0x09, 0xF9, 0x0D, 0x74, 0x03, 0x0E,
  0xE0, 0x77, 0x10, 0xCF, 0x90, 0x37, 0x20, 0x20, 0xEE, 0x07, 0x72, 0x03, 0xF9, 0x06, 0x71, 0x01,
  0x0D, 0xE0, 0x97, 0x40, 0xDF, 0x07, 0x71, 0x0A, 0xE0, 0xD7, 0x50, 0x8F, 0x05, 0x70, 0x6F, 0x03,
  0x75, 0x05, 0xF0, 0x16, 0x01, 0x0E, 0xE0, 0xA7, 0x60, 0x2E, 0x09, 0x70, 0xAF, 0x02, 0x76, 0x01,
  0xD0, 0xC7, 0x03, 0xF0, 0xA7, 0x71, 0xC0, 0xA0, 0x17, 0x0B, 0xF0, 0x37, 0x71, 0x82, 0xBA, 0x72,
  0x71, 0x04, 0xF0, 0xD7, 0x77, 0x70, 0xBF, 0x07, 0x77, 0x76, 0x02, 0xF9, 0x01, 0x77, 0x76, 0x08,
  0xF0, 0xB7, 0x77, 0x70, 0xEF, 0x07, 0x77, 0x76, 0x03, 0xF9, 0x02, 0x77, 0x76, 0x08, 0xF0, 0xE7,
  0x77, 0x70, 0xCF, 0x0A, 0x77, 0x76, 0x01, 0xF9, 0x06, 0x77, 0x76, 0x05, 0xF9, 0x03, 0x77, 0x76,
  0x08, 0xF9, 0x77, 0x77, 0x0B, 0xF0, 0xD7, 0x77, 0x70, 0xDF, 0x0B, 0x77, 0x77, 0xF9, 0x09, 0x77,
  0x76, 0x01, 0xF9, 0x08, 0x77, 0x76, 0x02, 0xF9, 0x07, 0x77, 0x76, 0x03, 0xF9, 0x06, 0x77, 0x76,
  0x03, 0xF9, 0x06, 0x77, 0x76, 0x02, 0xF9, 0x07, 0x77, 0x76, 0x02, 0xF9, 0x08, 0x77, 0x77, 0xF9,
  0x0A, 0x77, 0x77, 0x0E, 0xF0, 0xD7, 0x77, 0x70, 0xBF, 0x90, 0x17, 0x77, 0x60, 0x8F, 0x90, 0x67,
  0x73, 0x0A, 0x07, 0x71, 0x04, 0xF9, 0x0C, 0x77, 0x28, 0x19, 0xFA, 0x72, 0x0E, 0xF9, 0x05, 0x77,
  0x09, 0xA0, 0x97, 0x20, 0x8F, 0x90, 0xE0, 0x27, 0x40, 0x10, 0xBB, 0x05, 0x72, 0x01, 0xFA, 0x0D,
  0x03, 0x72, 0x05, 0x0E, 0xB0, 0xE7, 0x40, 0x7F, 0xB8, 0x1A, 0x51, 0x28, 0x21, 0x48, 0xDD, 0x08,
  0x75, 0x0C, 0xFF, 0xF9, 0x0D, 0x76, 0x01, 0x0D, 0xFF, 0xE0, 0xE0, 0x27, 0x70, 0x10, 0xCF, 0xFC,
  0x0D, 0x03, 0x77, 0x30, 0x8F, 0xFA, 0x0A, 0x01, 0x77, 0x50, 0x20, 0xAF, 0xD0, 0xC0, 0x47, 0x77,
  0x28, 0x31, 0x6A, 0xCE, 0xA8, 0x3E, 0xCA, 0x72, 0x77, 0x10,
  // "d" (U+0064)
  0x77, 0x77, 0x10, 0x2F, 0xF0, 0xB7, 0x77, 0x71, 0x05, 0xFF, 0x08, 0x77, 0x77, 0x10, 0x8F, 0xF0,
  0x57, 0x77, 0x71, 0x0C, 0xFF, 0x01, 0x77, 0x77, 0x38, 0x12, 0x6C, 0xFA, 0x0E, 0x77, 0x77, 0x70,
  0xAF, 0x90, 0xA7, 0x77, 0x77, 0x03, 0xF9, 0x07, 0x80, 0xC0, 0x0F, 0x90, 0x47, 0x77, 0x77, 0x01,
  0xF9, 0x80, 0xC0, 0x00, 0x3F, 0x0C, 0x80, 0xC0, 0x00, 0x6F, 0x09, 0x80, 0xC0, 0x00, 0x9F, 0x06,
  0x80, 0xC0, 0x00, 0xCF, 0x02, 0x80, 0xC0, 0x0F, 0x0E, 0x80, 0xC0, 0x00, 0x2F, 0x0B, 0x80, 0xC0,
  0x00, 0x5F, 0x08, 0x80, 0xC0, 0x00, 0x8F, 0x05, 0x80, 0xC0, 0x00, 0xCF, 0x01, 0x77, 0x77, 0x70,
  0x1F, 0x0D, 0x77, 0x72, 0x89, 0x11, 0x69, 0xCE, 0xFE, 0xDA, 0x61, 0x20, 0x4F, 0x0A, 0x77, 0x70,
  0x30, 0xBF, 0xC8, 0x19, 0x16, 0xF0, 0x77, 0x75, 0x02, 0x0B, 0xFF, 0x0E, 0x0C, 0xF0, 0x37, 0x74,
  0x06, 0x0E, 0xFF, 0xFB, 0x77, 0x40, 0x9F, 0x98, 0x4D, 0x97, 0x68, 0xCF, 0xC0, 0xC7, 0x73, 0x0B,
  0xF0, 0xD0, 0x56, 0x04, 0x0D, 0xFA, 0x09, 0x77, 0x20, 0xBF, 0x09, 0x72, 0x01, 0x0D, 0xF9, 0x05,
  0x77, 0x10, 0xAF, 0x08, 0x74, 0x04, 0xF9, 0x02, 0x77, 0x07, 0xF0, 0x97, 0x50, 0x1F, 0x0E, 0x77,
  0x02, 0xF0, 0xC7, 0x60, 0x4F, 0x0B, 0x77, 0x0C, 0xE0, 0xE0, 0x27, 0x60, 0x7F, 0x08, 0x76, 0x08,
  0xF0, 0x77, 0x70, 0xBF, 0x04, 0x75, 0x02, 0xF0, 0xD7, 0x71, 0x0E, 0xF0, 0x17, 0x50, 0xAF, 0x06,
  0x77, 0x02, 0xF0, 0xD7, 0x50, 0x3F, 0x0D, 0x77, 0x10, 0x5F, 0x0A, 0x75, 0x0B, 0xF0, 0x67, 0x71,
  0x09, 0xF0, 0x67, 0x40, 0x3F, 0x0E, 0x77, 0x20, 0xCF, 0x03, 0x74, 0x09, 0xF0, 0x97, 0x72, 0xF9,
  0x74, 0x01, 0xF9, 0x03, 0x77, 0x10, 0x3F, 0x0C, 0x74, 0x06, 0xF0, 0xD7, 0x72, 0x07, 0xF0, 0x97,
  0x40, 0xCF, 0x09, 0x77, 0x20, 0xAF, 0x05, 0x73, 0x02, 0xF9, 0x04, 0x77, 0x20, 0xDF, 0x02, 0x73,
  0x06, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x74, 0x0B, 0xF0, 0xB7, 0x72, 0x05, 0xF0, 0xB7, 0x40, 0xEF,
  0x07, 0x77, 0x20, 0x9F, 0x07, 0x73, 0x04, 0xF9, 0x04, 0x77, 0x20, 0xDF, 0x04, 0x73, 0x07, 0xF9,
  0x01, 0x77, 0x10, 0x1F, 0x90, 0x17, 0x30, 0xAF, 0x0D, 0x77, 0x20, 0x6F, 0x0D, 0x74, 0x0D, 0xF0,
  0xB7, 0x72, 0x0C, 0xF0, 0xA7, 0x4F, 0x90, 0x97, 0x71, 0x02, 0xF9, 0x06, 0x73, 0x02, 0xF9, 0x06,
  0x77, 0x10, 0x8F, 0x90, 0x37, 0x30, 0x3F, 0x90, 0x57, 0x71, 0x0E, 0xF9, 0x01, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x06, 0xF9, 0x0D, 0x74, 0x05, 0xF9, 0x03, 0x77, 0x0D, 0xF9, 0x0B, 0x74, 0x06, 0xF9,
  0x02, 0x76, 0x06, 0xFA, 0x08, 0x74, 0x05, 0xF9, 0x02, 0x75, 0x01, 0x0E, 0xFA, 0x06, 0x74, 0x05,
  0xF9, 0x03, 0x75, 0x09, 0xA0, 0xBF, 0x03, 0x74, 0x04, 0xF9, 0x04, 0x74, 0x03, 0xA0, 0xB0, 0x8F,
  0x02, 0x74, 0x02, 0xF9, 0x06, 0x74, 0x0D, 0xA0, 0x40, 0xBF, 0x76, 0xF9, 0x09, 0x73, 0x0A, 0xA8,
  0x1B, 0x0D, 0xF7, 0x60, 0xDF, 0x0D, 0x72, 0x07, 0xB0, 0x31, 0xF9, 0x76, 0x09, 0xF9, 0x04, 0x70,
  0x7B, 0x81, 0x90, 0x1F, 0x90, 0x17, 0x50, 0x5F, 0x90, 0xD0, 0x15, 0x09, 0xB8, 0x2D, 0x10, 0x1F,
  0x90, 0x65, 0x81, 0x6E, 0x34, 0x01, 0x0E, 0xF9, 0x84, 0xD4, 0x01, 0x6D, 0xC0, 0x33, 0xF9, 0x84,
  0xE3, 0x02, 0x6D, 0xA0, 0xC5, 0x09, 0xFF, 0xB0, 0x74, 0x0D, 0xFF, 0x90, 0xD0, 0x14, 0x02, 0xFF,
  0xA0, 0x95, 0x09, 0xFF, 0x0C, 0x01, 0x60, 0x8F, 0xF0, 0x96, 0x04, 0xFE, 0x09, 0x72, 0x0B, 0xFD,
  0x07, 0x71, 0x0B, 0xFB, 0x0E, 0x04, 0x74, 0x09, 0xFA, 0x0B, 0x03, 0x72, 0x01, 0x0C, 0xF9, 0x08,
  0x01, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xC8, 0x37, 0x68, 0x67, 0xCE, 0xFD, 0xA6, 0x17, 0x20,
  // "e" (U+0065)
  0x77, 0x58, 0x91, 0x15, 0x9C, 0xDE, 0xFE, 0xC9, 0x57, 0x77, 0x20, 0x50, 0xBF, 0xC0, 0xE0, 0x67,
  0x75, 0x03, 0x0C, 0xFF, 0x90, 0xA7, 0x73, 0x09, 0xFF, 0xC0, 0x97, 0x70, 0x20, 0xCE, 0x83, 0xEA,
  0x76, 0x9F, 0xA0, 0x47, 0x50, 0x20, 0xEE, 0x0A, 0x01, 0x40, 0x20, 0xEF, 0x0C, 0x74, 0x03, 0x0E,
  0xE0, 0x77, 0x06, 0xF9, 0x01, 0x72, 0x02, 0x0E, 0xE0, 0x87, 0x10, 0x1F, 0x90, 0x57, 0x10, 0x10,
  0xDE, 0x0B, 0x73, 0x0D, 0xF0, 0x77, 0x10, 0xAE, 0x0E, 0x01, 0x73, 0x0C, 0xF0, 0x97, 0x06, 0xF0,
  0x67, 0x40, 0xCF, 0x08, 0x60, 0x10, 0xEE, 0x0D, 0x75, 0x0D, 0xF0, 0x76, 0x0A, 0xF0, 0x57, 0x5F,
  0x90, 0x55, 0x03, 0xF0, 0xC7, 0x50, 0x3F, 0x90, 0x15, 0x0B, 0xF0, 0x67, 0x50, 0x7F, 0x0D, 0x50,
  0x4F, 0x0E, 0x76, 0x0D, 0xF0, 0x75, 0x0B, 0xF0, 0x87, 0x50, 0x5F, 0x0E, 0x01, 0x40, 0x2F, 0x90,
  0x37, 0x40, 0x10, 0xDF, 0x07, 0x50, 0x8F, 0x0D, 0x75, 0x0B, 0xF0, 0xD6, 0x0E, 0xF0, 0x87, 0x40,
  0xAF, 0x0E, 0x02, 0x50, 0x3F, 0x90, 0x37, 0x20, 0x10, 0xBF, 0x90, 0x56, 0x08, 0xF0, 0xE7, 0x20,
  0x50, 0xDF, 0x90, 0x57, 0x0C, 0xF0, 0xB7, 0x05, 0x0C, 0xFA, 0x05, 0x70, 0x1F, 0x90, 0x82, 0x83,
  0x14, 0x6A, 0xEF, 0xA0, 0xD0, 0x27, 0x10, 0x5F, 0xFF, 0xB0, 0x87, 0x30, 0x8F, 0xFF, 0x90, 0xA0,
  0x27, 0x40, 0xBF, 0xFD, 0x81, 0xE8, 0x27, 0x60, 0xDF, 0xF9, 0x82, 0xEC, 0x84, 0x77, 0x2F, 0x98,
  0x6C, 0x66, 0x65, 0x43, 0x17, 0x75, 0x01, 0xF9, 0x08, 0x77, 0x75, 0x02, 0xF9, 0x06, 0x77, 0x75,
  0x03, 0xF9, 0x05, 0x77, 0x75, 0x03, 0xF9, 0x05, 0x77, 0x75, 0x02, 0xF9, 0x05, 0x77, 0x75, 0x01,
  0xF9, 0x06, 0x77, 0x76, 0xF9, 0x07, 0x77, 0x76, 0x0D, 0xF0, 0xA7, 0x77, 0x60, 0xBF, 0x0D, 0x77,
  0x50, 0x17, 0x07, 0xF9, 0x02, 0x77, 0x30, 0xA0, 0x97, 0x03, 0xF9, 0x08, 0x77, 0x28, 0x19, 0xFB,
  0x71, 0x0D, 0xF9, 0x02, 0x77, 0x0A, 0xA0, 0xA7, 0x10, 0x7F, 0x90, 0xC7, 0x50, 0x20, 0xCB, 0x06,
  0x71, 0x01, 0x0E, 0xF9, 0x0B, 0x01, 0x72, 0x08, 0xC0, 0xE0, 0x17, 0x20, 0x6F, 0xA8, 0x2E, 0x94,
  0x12, 0x82, 0x25, 0x9E, 0xD0, 0x77, 0x40, 0xAF, 0xFF, 0x90, 0xC7, 0x60, 0xCF, 0xFE, 0x0D, 0x02,
  0x77, 0x0B, 0xFF, 0xC0, 0xD0, 0x27, 0x72, 0x08, 0xFF, 0xA0, 0x90, 0x17, 0x74, 0x02, 0x0A, 0xFD,
  0x0B, 0x03, 0x77, 0x71, 0x83, 0x16, 0x9C, 0xEA, 0x83, 0xEC, 0xA6, 0x27, 0x70,
  // "f" (U+0066)
  0x80, 0xC1, 0x08, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB9, 0x48, 0x0C, 0x40, 0x08, 0x0E, 0xFC, 0x0E,
  0x06, 0x80, 0xC0, 0x00, 0x40, 0xEF, 0xF9, 0x0A, 0x77, 0x77, 0x60, 0x6F, 0xFC, 0x09, 0x77, 0x77,
  0x40, 0x5F, 0x83, 0xE9, 0x77, 0xDF, 0x90, 0x17, 0x77, 0x72, 0x02, 0x0E, 0xE0, 0xB0, 0x14, 0x0B,
  0xF0, 0x67, 0x77, 0x72, 0x0D, 0xE0, 0xD6, 0x03, 0xF0, 0x87, 0x77, 0x71, 0x06, 0xF0, 0x47, 0x0E,
  0xE0, 0x87, 0x77, 0x71, 0x0E, 0xE0, 0xC7, 0x10, 0xBE, 0x05, 0x77, 0x77, 0x07, 0xF0, 0x67, 0x10,
  0x8D, 0x0E, 0x01, 0x77, 0x77, 0x0D, 0xF0, 0x17, 0x10, 0x7D, 0x05, 0x77, 0x77, 0x03, 0xF0, 0xC7,
  0x20, 0x7B, 0x0C, 0x04, 0x77, 0x77, 0x10, 0x8F, 0x08, 0x72, 0x82, 0x37, 0x52, 0x77, 0x77, 0x30,
  0xCF, 0x04, 0x80, 0xC7, 0x00, 0x1F, 0x98, 0x0D, 0x00, 0x05, 0xF0, 0xC8, 0x0D, 0x00, 0x08, 0xF0,
  0x98, 0x0D, 0x00, 0x0B, 0xF0, 0x68, 0x0D, 0x00, 0x0E, 0xF0, 0x38, 0x0C, 0x70, 0x03, 0xF9, 0x80,
  0xC7, 0x00, 0x30, 0x9F, 0x0C, 0x80, 0xC3, 0x08, 0x23, 0x7B, 0xEF, 0xFC, 0x06, 0x77, 0x77, 0x0A,
  0x0E, 0xFF, 0xF9, 0x02, 0x77, 0x76, 0x01, 0xFF, 0xFA, 0x0E, 0x77, 0x77, 0x04, 0xFF, 0xFA, 0x0A,
  0x77, 0x77, 0x02, 0x80, 0x26, 0x0A, 0xF0, 0xB8, 0x04, 0x60, 0x37, 0x77, 0x77, 0x09, 0xF0, 0x58,
  0x0D, 0x00, 0x0D, 0xF0, 0x28, 0x0C, 0x70, 0x01, 0xF0, 0xE8, 0x0D, 0x00, 0x04, 0xF0, 0xB8, 0x0D,
  0x00, 0x07, 0xF0, 0x88, 0x0D, 0x00, 0x0A, 0xF0, 0x58, 0x0D, 0x00, 0x0E, 0xF0, 0x18, 0x0C, 0x70,
  0x02, 0xF0, 0xE8, 0x0D, 0x00, 0x05, 0xF0, 0xA8, 0x0D, 0x00, 0x08, 0xF0, 0x78, 0x0D, 0x00, 0x0B,
  0xF0, 0x48, 0x0D, 0x00, 0x0E, 0xF0, 0x18, 0x0C, 0x70, 0x03, 0xF0, 0xD8, 0x0D, 0x00, 0x06, 0xF0,
  0xA8, 0x0D, 0x00, 0x09, 0xF0, 0x78, 0x0D, 0x00, 0x0C, 0xF0, 0x38, 0x0D, 0x00, 0xF9, 0x80, 0xD0,
  0x00, 0x3F, 0x0C, 0x80, 0xD0, 0x00, 0x7F, 0x09, 0x80, 0xD0, 0x00, 0xAF, 0x06, 0x80, 0xD0, 0x00,
  0xDF, 0x03, 0x80, 0xC7, 0x00, 0x1F, 0x98, 0x0D, 0x00, 0x04, 0xF0, 0xC8, 0x0D, 0x00, 0x08, 0xF0,
  0x88, 0x0D, 0x00, 0x0B, 0xF0, 0x58, 0x0D, 0x00, 0x0E, 0xF0, 0x28, 0x0C, 0x70, 0x02, 0xF0, 0xE8,
  0x0D, 0x00, 0x05, 0xF0, 0xB8, 0x0D, 0x00, 0x09, 0xF0, 0x88, 0x0D, 0x00, 0x0C, 0xF0, 0x48, 0x0D,
  0x00, 0xF9, 0x01, 0x80, 0xC7, 0x00, 0x3F, 0x0D, 0x80, 0xD0, 0x00, 0x6F, 0x0A, 0x80, 0xD0, 0x00,
  0xAF, 0x07, 0x80, 0xD0, 0x00, 0xDF, 0x04, 0x80, 0xC7, 0x00, 0x1F, 0x98, 0x0D, 0x00, 0x04, 0xF0,
  0xD8, 0x0D, 0x00, 0x07, 0xF0, 0x98, 0x0D, 0x00, 0x0B, 0xF0, 0x68, 0x0D, 0x00, 0x0E, 0xF0, 0x38,
  0x0C, 0x70, 0x02, 0xF9, 0x80, 0xD0, 0x00, 0x5F, 0x0C, 0x80, 0xD0, 0x00, 0x8F, 0x09, 0x80, 0xD0,
  0x00, 0xCF, 0x05, 0x80, 0xD0, 0x0F, 0x90, 0x28, 0x0C, 0x70, 0x03, 0xF0, 0xE8, 0x0D, 0x00, 0x06,
  0xF0, 0xA8, 0x0D, 0x00, 0x0A, 0xF0, 0x68, 0x0D, 0x00, 0x0D, 0xF0, 0x28, 0x0C, 0x70, 0x02, 0xF0,
  0xD8, 0x0D, 0x00, 0x06, 0xF0, 0x88, 0x0D, 0x00, 0x0B, 0xF0, 0x38, 0x0C, 0x70, 0x01, 0xF0, 0xC8,
  0x0D, 0x00, 0x06, 0xF0, 0x68, 0x0D, 0x00, 0x0C, 0xE0, 0xE8, 0x0D, 0x00, 0x04, 0xF0, 0x78, 0x0D,
  0x00, 0x0C, 0xE0, 0xD8, 0x0D, 0x00, 0x07, 0xF0, 0x48, 0x0C, 0x70, 0x04, 0xF0, 0xA8, 0x0C, 0x70,
  0x07, 0xF0, 0xC8, 0x0C, 0x10, 0x85, 0x9A, 0x86, 0x79, 0xEF, 0x0D, 0x01, 0x80, 0xC1, 0x00, 0xDF,
  0xD0, 0xC0, 0x18, 0x0C, 0x10, 0x01, 0xFD, 0x09, 0x80, 0xC3, 0x00, 0x4F, 0xB0, 0xA0, 0x38, 0x0C,
  0x40, 0x89, 0x12, 0x8B, 0xDE, 0xFE, 0xC9, 0x51, 0x80, 0xC6, 0x00,
  // "g" (U+0067)
  0x80, 0xD1, 0x08, 0x46, 0xBE, 0xFD, 0x58, 0x0D, 0x00, 0x04, 0x0D, 0xE0, 0x58, 0x0C, 0x60, 0x05,
  0xF9, 0x0C, 0x77, 0x75, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDA, 0x61, 0x40, 0x6F, 0xB7, 0x77, 0x28,
  0x11, 0x8E, 0xFC, 0x09, 0x20, 0x4F, 0xB0, 0xE7, 0x77, 0x10, 0x7F, 0xF9, 0x81, 0xC3, 0xEF, 0xB0,
  0xC7, 0x76, 0x02, 0x0C, 0xFF, 0xF8, 0x29, 0x21, 0x9C, 0x07, 0x77, 0x50, 0x30, 0xEE, 0x84, 0xEA,
  0x76, 0x8D, 0xFA, 0x05, 0x40, 0xEA, 0x0E, 0x01, 0x77, 0x40, 0x30, 0xEE, 0x09, 0x01, 0x50, 0x8F,
  0x08, 0x58, 0x2B, 0xFE, 0x47, 0x74, 0x02, 0x0E, 0xE0, 0x77, 0x10, 0xAE, 0x0E, 0x50, 0x04, 0x77,
  0x60, 0xCE, 0x08, 0x72, 0x03, 0xF0, 0x47, 0x77, 0x40, 0x7E, 0x0C, 0x74, 0x0E, 0xE0, 0x87, 0x77,
  0x30, 0x2F, 0x03, 0x74, 0x0C, 0xE0, 0xB7, 0x77, 0x30, 0xAE, 0x0A, 0x75, 0x0B, 0xE0, 0xC7, 0x77,
  0x20, 0x2F, 0x03, 0x75, 0x0B, 0xE0, 0xD7, 0x77, 0x20, 0x9E, 0x0D, 0x76, 0x0B, 0xE0, 0xD7, 0x77,
  0x20, 0xEE, 0x07, 0x76, 0x0C, 0xE0, 0xC7, 0x77, 0x10, 0x4F, 0x03, 0x76, 0x0E, 0xE0, 0xA7, 0x77,
  0x10, 0x8E, 0x0E, 0x76, 0x02, 0xF0, 0x77, 0x77, 0x10, 0xCE, 0x0B, 0x76, 0x04, 0xF0, 0x47, 0x77,
  0x1F, 0x08, 0x76, 0x08, 0xF7, 0x77, 0x10, 0x1F, 0x06, 0x76, 0x0C, 0xE0, 0xB7, 0x77, 0x10, 0x3F,
  0x04, 0x75, 0x01, 0xF0, 0x67, 0x77, 0x10, 0x3F, 0x03, 0x75, 0x07, 0xF0, 0x17, 0x77, 0x10, 0x3F,
  0x03, 0x75, 0x0D, 0xE0, 0x97, 0x77, 0x20, 0x2F, 0x04, 0x74, 0x06, 0xF0, 0x27, 0x77, 0x3F, 0x06,
  0x73, 0x01, 0x0E, 0xE0, 0x87, 0x77, 0x40, 0xDE, 0x09, 0x73, 0x09, 0xE0, 0xD7, 0x77, 0x50, 0x8E,
  0x0E, 0x01, 0x71, 0x08, 0xF0, 0x37, 0x77, 0x50, 0x2F, 0x0A, 0x70, 0x8F, 0x06, 0x77, 0x77, 0x0A,
  0xF8, 0x5B, 0x41, 0x02, 0x6C, 0xF0, 0x77, 0x77, 0x71, 0x01, 0x0D, 0xFF, 0xD0, 0x67, 0x77, 0x73,
  0x02, 0x0D, 0xFF, 0xA0, 0xD0, 0x37, 0x77, 0x75, 0x01, 0x0A, 0xFE, 0x0E, 0x07, 0x77, 0x77, 0x70,
  0x20, 0xBF, 0xC0, 0xB0, 0x68, 0x0C, 0x00, 0x08, 0xC8, 0x6D, 0x64, 0x56, 0x54, 0x28, 0x0C, 0x10,
  0x02, 0x0C, 0xC0, 0x88, 0x0D, 0x00, 0x03, 0x0E, 0xB0, 0xE0, 0x38, 0x0D, 0x00, 0x02, 0x0E, 0xB0,
  0xE0, 0x28, 0x0D, 0x10, 0x0C, 0xC0, 0x88, 0x0D, 0x10, 0x05, 0xD0, 0x48, 0x0D, 0x10, 0x09, 0xD0,
  0x58, 0x0D, 0x10, 0x0C, 0xD0, 0xC0, 0x18, 0x0D, 0x00, 0x0D, 0xE8, 0x3E, 0x96, 0x32, 0x80, 0xC4,
  0x00, 0xCF, 0xD8, 0x5E, 0xCB, 0x97, 0x52, 0x77, 0x77, 0x40, 0x8F, 0xFD, 0x81, 0xE9, 0x47, 0x77,
  0x71, 0x01, 0x0E, 0xFF, 0xF0, 0xC0, 0x47, 0x77, 0x70, 0x4F, 0xFF, 0xA0, 0x97, 0x77, 0x70, 0x40,
  0xEF, 0xFF, 0x90, 0xB7, 0x77, 0x58, 0x13, 0x7D, 0xFF, 0xFA, 0x08, 0x77, 0x72, 0x06, 0x0D, 0xFF,
  0xFE, 0x02, 0x77, 0x60, 0x60, 0xED, 0x89, 0x1E, 0xA7, 0x44, 0x57, 0x8A, 0xCD, 0xFE, 0x09, 0x77,
  0x40, 0x20, 0xCD, 0x0D, 0x06, 0x75, 0x81, 0x26, 0xBF, 0xA0, 0xD7, 0x73, 0x04, 0x0E, 0xD0, 0x97,
  0x73, 0x04, 0x0E, 0xF9, 0x02, 0x77, 0x10, 0x30, 0xED, 0x07, 0x77, 0x50, 0x20, 0xEF, 0x03, 0x77,
  0x01, 0x0E, 0xD0, 0x87, 0x77, 0x08, 0xF0, 0x57, 0x70, 0xBD, 0x0D, 0x77, 0x71, 0x02, 0xF0, 0x57,
  0x60, 0x3E, 0x05, 0x77, 0x72, 0xF0, 0x47, 0x60, 0xAE, 0x77, 0x73, 0x0E, 0xE0, 0x37, 0x60, 0xED,
  0x0B, 0x77, 0x73, 0xF7, 0x60, 0x2E, 0x09, 0x77, 0x72, 0x02, 0xE0, 0xD7, 0x60, 0x4E, 0x08, 0x77,
  0x72, 0x05, 0xE0, 0x87, 0x60, 0x4E, 0x09, 0x77, 0x72, 0x0A, 0xE0, 0x37, 0x60, 0x4E, 0x0A, 0x77,
  0x71, 0x02, 0xE0, 0xC7, 0x70, 0x2E, 0x0E, 0x77, 0x71, 0x0A, 0xE0, 0x47, 0x71, 0x0E, 0xE0, 0x67,
  0x76, 0x07, 0xE0, 0xB7, 0x72, 0x09, 0xE0, 0xE0, 0x17, 0x74, 0x07, 0xE0, 0xE0, 0x17, 0x72, 0x03,
  0xF0, 0xC0, 0x27, 0x71, 0x02, 0x0B, 0xF0, 0x47, 0x74, 0x09, 0xF8, 0x1E, 0x82, 0x74, 0x04, 0x0A,
  0xF9, 0x04, 0x77, 0x60, 0xBF, 0xA8, 0x90, 0xDA, 0x87, 0x66, 0x78, 0xAC, 0xFA, 0x0D, 0x02, 0x77,
  0x71, 0x0A, 0xFF, 0xFD, 0x09, 0x01, 0x77, 0x73, 0x06, 0x0E, 0xFF, 0xF9, 0x0A, 0x02, 0x77, 0x77,
  0x06, 0x0C, 0xFF, 0xB8, 0x1C, 0x81, 0x77, 0x77, 0x48, 0x51, 0x58, 0xAC, 0xDE, 0xA8, 0x6E, 0xED,
  0xCA, 0x75, 0x17, 0x77, 0x50,
  // "h" (U+0068)
  0x70, 0x1F, 0xF0, 0xE7, 0x77, 0x70, 0x5F, 0xF0, 0xA7, 0x77, 0x70, 0x8F, 0xF0, 0x77, 0x77, 0x70,
  0xBF, 0xF0, 0x47, 0x77, 0x72, 0x81, 0x26, 0xCF, 0xB7, 0x77, 0x76, 0x0B, 0xF9, 0x0C, 0x77, 0x77,
  0x60, 0x4F, 0x90, 0x97, 0x77, 0x76, 0x01, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x1F, 0x90, 0x27, 0x77,
  0x76, 0x03, 0xF0, 0xE7, 0x77, 0x77, 0x06, 0xF0, 0xB7, 0x77, 0x77, 0x08, 0xF0, 0x87, 0x77, 0x77,
  0x0B, 0xF0, 0x57, 0x77, 0x77, 0x0E, 0xF0, 0x17, 0x77, 0x76, 0x02, 0xF0, 0xD7, 0x77, 0x77, 0x06,
  0xF0, 0xA7, 0x77, 0x77, 0x09, 0xF0, 0x77, 0x77, 0x77, 0x0C, 0xF0, 0x47, 0x77, 0x77, 0xF9, 0x01,
  0x77, 0x77, 0x60, 0x3F, 0x0D, 0x71, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x27, 0x74, 0x07, 0xF0, 0xA6,
  0x04, 0x0C, 0xFA, 0x08, 0x77, 0x30, 0xAF, 0x06, 0x50, 0x8F, 0xD0, 0x87, 0x72, 0x0D, 0xF0, 0x34,
  0x0B, 0xFF, 0x03, 0x77, 0x01, 0xF9, 0x40, 0xCF, 0xF9, 0x0A, 0x77, 0x04, 0xF0, 0xC3, 0x0B, 0xFF,
  0xB0, 0x17, 0x60, 0x8F, 0x08, 0x20, 0x9C, 0x09, 0x03, 0x20, 0x50, 0xEF, 0x90, 0x47, 0x60, 0xBF,
  0x81, 0x50, 0x5B, 0x0C, 0x02, 0x50, 0x5F, 0x90, 0x77, 0x60, 0xEF, 0x81, 0x12, 0xEA, 0x0A, 0x71,
  0x0E, 0xF0, 0x97, 0x50, 0x2F, 0x81, 0xD0, 0xBA, 0x0B, 0x72, 0x0B, 0xF0, 0x97, 0x50, 0x5F, 0x09,
  0x06, 0xA0, 0xC7, 0x30, 0xAF, 0x09, 0x75, 0x09, 0xF8, 0x38, 0xEF, 0xE1, 0x73, 0x0A, 0xF0, 0x87,
  0x50, 0xCF, 0xB0, 0x57, 0x40, 0xBF, 0x06, 0x75, 0xFB, 0x0A, 0x75, 0x0C, 0xF0, 0x47, 0x40, 0x3F,
  0xA0, 0xE0, 0x17, 0x5F, 0x90, 0x17, 0x40, 0x6F, 0xA0, 0x77, 0x50, 0x2F, 0x0E, 0x75, 0x0A, 0xF9,
  0x0D, 0x76, 0x05, 0xF0, 0xB7, 0x50, 0xDF, 0x90, 0x67, 0x60, 0x9F, 0x07, 0x74, 0x01, 0xF9, 0x0E,
  0x77, 0x0C, 0xF0, 0x47, 0x40, 0x4F, 0x90, 0x77, 0x7F, 0x90, 0x17, 0x40, 0x7F, 0x90, 0x17, 0x60,
  0x4F, 0x0D, 0x75, 0x0B, 0xF0, 0xA7, 0x70, 0x7F, 0x0A, 0x75, 0x0E, 0xF0, 0x47, 0x70, 0xAF, 0x06,
  0x74, 0x02, 0xF0, 0xE7, 0x71, 0x0E, 0xF0, 0x37, 0x40, 0x5F, 0x0A, 0x77, 0x01, 0xF9, 0x75, 0x08,
  0xF0, 0x67, 0x70, 0x4F, 0x0C, 0x75, 0x0C, 0xF0, 0x37, 0x70, 0x8F, 0x09, 0x75, 0xF9, 0x77, 0x10,
  0xBF, 0x06, 0x74, 0x03, 0xF0, 0xC7, 0x71, 0x0E, 0xF0, 0x37, 0x40, 0x6F, 0x08, 0x77, 0x02, 0xF9,
  0x75, 0x09, 0xF0, 0x57, 0x70, 0x5F, 0x0C, 0x75, 0x0D, 0xF0, 0x27, 0x70, 0x8F, 0x08, 0x74, 0x01,
  0xF0, 0xE7, 0x71, 0x0B, 0xF0, 0x57, 0x40, 0x4F, 0x0B, 0x77, 0x10, 0xEF, 0x02, 0x74, 0x07, 0xF0,
  0x77, 0x70, 0x1F, 0x97, 0x50, 0xAF, 0x04, 0x77, 0x04, 0xF0, 0xC7, 0x50, 0xEF, 0x01, 0x77, 0x06,
  0xF0, 0xA7, 0x40, 0x2F, 0x0D, 0x77, 0x10, 0x8F, 0x08, 0x74, 0x05, 0xF0, 0xA7, 0x71, 0x0A, 0xF0,
  0x77, 0x40, 0x8F, 0x06, 0x77, 0x10, 0xBF, 0x06, 0x74, 0x0B, 0xF0, 0x37, 0x71, 0x0C, 0xF0, 0x57,
  0x40, 0xEF, 0x77, 0x20, 0xDF, 0x05, 0x73, 0x03, 0xF0, 0xC7, 0x72, 0x0C, 0xF0, 0x77, 0x30, 0x6F,
  0x09, 0x77, 0x20, 0xAF, 0x0B, 0x58, 0x12, 0xB3, 0x20, 0x9F, 0x06, 0x77, 0x20, 0x7F, 0x98, 0x37,
  0x01, 0x49, 0xA0, 0xB2, 0x0C, 0xF0, 0x27, 0x72, 0x02, 0xFF, 0x90, 0xE0, 0x11, 0xF0, 0xE7, 0x74,
  0x0B, 0xFE, 0x82, 0xD2, 0x04, 0xF0, 0xB7, 0x74, 0x02, 0x0E, 0xFC, 0x09, 0x30, 0x7F, 0x08, 0x77,
  0x50, 0x30, 0xEF, 0x90, 0xC0, 0x37, 0x77, 0x75, 0x87, 0x17, 0xCE, 0xFE, 0xC8, 0x36,
  // "i" (U+0069)
  0x75, 0x84, 0x6C, 0xEE, 0xC5, 0x76, 0x0B, 0xE0, 0x87, 0x40, 0x8F, 0x90, 0x27, 0x30, 0xEF, 0x90,
  0x67, 0x20, 0x3F, 0xA0, 0x77, 0x20, 0x4F, 0xA0, 0x67, 0x20, 0x3F, 0xA0, 0x37, 0x30, 0xEF, 0x0C,
  0x74, 0x07, 0xE0, 0xD0, 0x27, 0x58, 0x54, 0xBE, 0xFD, 0x71, 0x80, 0xB8, 0x70, 0x03, 0xFF, 0x06,
  0x40, 0x6F, 0xF0, 0x34, 0x09, 0xFF, 0x50, 0xCF, 0xE0, 0xC7, 0x81, 0x15, 0xBF, 0xA0, 0x97, 0x30,
  0xBF, 0x90, 0x57, 0x30, 0x6F, 0x90, 0x27, 0x30, 0x4F, 0x0E, 0x74, 0x05, 0xF0, 0xB7, 0x40, 0x8F,
  0x08, 0x74, 0x0A, 0xF0, 0x57, 0x40, 0xEF, 0x01, 0x73, 0x01, 0xF0, 0xE7, 0x40, 0x5F, 0x0B, 0x74,
  0x08, 0xF0, 0x77, 0x40, 0xBF, 0x04, 0x74, 0x0E, 0xF0, 0x17, 0x30, 0x2F, 0x0D, 0x74, 0x06, 0xF0,
  0xA7, 0x40, 0x9F, 0x07, 0x74, 0x0C, 0xF0, 0x37, 0x4F, 0x97, 0x40, 0x3F, 0x0D, 0x74, 0x07, 0xF0,
  0x97, 0x40, 0xAF, 0x06, 0x74, 0x0D, 0xF0, 0x37, 0x30, 0x1F, 0x97, 0x40, 0x4F, 0x0C, 0x74, 0x08,
  0xF0, 0x97, 0x40, 0xBF, 0x05, 0x74, 0x0E, 0xF0, 0x27, 0x30, 0x2F, 0x0E, 0x74, 0x04, 0xF0, 0xB7,
  0x40, 0x7F, 0x09, 0x74, 0x09, 0xF0, 0x67, 0x40, 0xBF, 0x03, 0x74, 0x0E, 0xF0, 0x17, 0x4F, 0x97,
  0x40, 0x1F, 0x0E, 0x74, 0x02, 0xF0, 0xD7, 0x40, 0x3F, 0x0D, 0x74, 0x03, 0xF9, 0x70, 0x23, 0x01,
  0xF9, 0x04, 0x58, 0x18, 0xF5, 0x30, 0xEF, 0x84, 0xD3, 0x02, 0x7E, 0xA0, 0xD3, 0x09, 0xFF, 0x90,
  0xB3, 0x02, 0xFF, 0x08, 0x50, 0x8F, 0xC0, 0xD0, 0x37, 0x0A, 0xF9, 0x0E, 0x07, 0x73, 0x86, 0x4A,
  0xDF, 0xED, 0xA5, 0x71,
  // "j" (U+006A)
  0x77, 0x77, 0x18, 0x45, 0xCE, 0xFC, 0x67, 0x77, 0x72, 0x0A, 0xE0, 0x97, 0x77, 0x70, 0x7F, 0x90,
  0x37, 0x77, 0x60, 0xDF, 0x90, 0x77, 0x77, 0x50, 0x2F, 0xA0, 0x87, 0x77, 0x50, 0x3F, 0xA0, 0x77,
  0x77, 0x50, 0x2F, 0xA0, 0x47, 0x77, 0x60, 0xEF, 0x0D, 0x77, 0x77, 0x05, 0xE0, 0xE0, 0x47, 0x77,
  0x71, 0x85, 0x4B, 0xEF, 0xD9, 0x28, 0x0E, 0x82, 0x00, 0x1F, 0xF0, 0x77, 0x77, 0x04, 0xFF, 0x04,
  0x77, 0x70, 0x7F, 0xF0, 0x17, 0x77, 0x0A, 0xFE, 0x0D, 0x77, 0x73, 0x81, 0x15, 0xBF, 0xA0, 0xA7,
  0x77, 0x60, 0xBF, 0x90, 0x67, 0x77, 0x60, 0x6F, 0x90, 0x37, 0x77, 0x60, 0x4F, 0x97, 0x77, 0x70,
  0x5F, 0x0C, 0x77, 0x77, 0x07, 0xF0, 0x97, 0x77, 0x70, 0xAF, 0x05, 0x77, 0x77, 0x0D, 0xF0, 0x27,
  0x77, 0x60, 0x1F, 0x0E, 0x77, 0x77, 0x04, 0xF0, 0xB7, 0x77, 0x70, 0x7F, 0x08, 0x77, 0x77, 0x0B,
  0xF0, 0x57, 0x77, 0x70, 0xEF, 0x01, 0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x70, 0x5F, 0x0A, 0x77,
  0x77, 0x08, 0xF0, 0x77, 0x77, 0x70, 0xBF, 0x04, 0x77, 0x77, 0x0E, 0xF0, 0x17, 0x77, 0x60, 0x3F,
  0x0D, 0x77, 0x77, 0x06, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x06, 0x77, 0x77, 0x0C, 0xF0, 0x37, 0x77,
  0x7F, 0x97, 0x77, 0x70, 0x3F, 0x0C, 0x77, 0x77, 0x07, 0xF0, 0x97, 0x77, 0x70, 0xAF, 0x05, 0x77,
  0x77, 0x0D, 0xF0, 0x27, 0x77, 0x60, 0x1F, 0x0E, 0x77, 0x77, 0x04, 0xF0, 0xB7, 0x77, 0x70, 0x7F,
  0x08, 0x77, 0x77, 0x0B, 0xF0, 0x57, 0x77, 0x70, 0xEF, 0x01, 0x77, 0x76, 0x02, 0xF0, 0xD7, 0x77,
  0x70, 0x5F, 0x0A, 0x77, 0x77, 0x08, 0xF0, 0x77, 0x77, 0x70, 0xBF, 0x04, 0x77, 0x77, 0x0E, 0xF7,
  0x77, 0x70, 0x2F, 0x0D, 0x77, 0x77, 0x06, 0xF0, 0x97, 0x77, 0x70, 0x9F, 0x06, 0x77, 0x77, 0x0C,
  0xF0, 0x37, 0x77, 0x7F, 0x97, 0x77, 0x70, 0x3F, 0x0C, 0x77, 0x77, 0x06, 0xF0, 0x97, 0x77, 0x70,
  0xAF, 0x05, 0x77, 0x77, 0x0D, 0xF0, 0x27, 0x77, 0x60, 0x1F, 0x0E, 0x77, 0x77, 0x05, 0xF0, 0xA7,
  0x77, 0x70, 0x8F, 0x06, 0x77, 0x77, 0x0C, 0xF0, 0x27, 0x77, 0x60, 0x1F, 0x0D, 0x77, 0x77, 0x06,
  0xF0, 0x87, 0x77, 0x70, 0xBF, 0x03, 0x77, 0x76, 0x01, 0xF0, 0xC7, 0x77, 0x70, 0x6F, 0x07, 0x77,
  0x77, 0x0C, 0xE0, 0xE0, 0x17, 0x77, 0x60, 0x4F, 0x08, 0x77, 0x77, 0x0C, 0xE0, 0xE0, 0x17, 0x77,
  0x60, 0x8F, 0x06, 0x77, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x60, 0x7F, 0x0E, 0x02, 0x77, 0x68, 0x59,
  0xA8, 0x67, 0x9E, 0xF9, 0x04, 0x77, 0x70, 0xDF, 0xE0, 0x47, 0x77, 0x01, 0xFD, 0x0C, 0x02, 0x77,
  0x71, 0x04, 0xFB, 0x0D, 0x06, 0x77, 0x73, 0x83, 0x28, 0xBD, 0xEA, 0x82, 0xEB, 0x84, 0x77, 0x75,
  // "k" (U+006B)
  0x70, 0x1F, 0xF0, 0xE7, 0x77, 0x72, 0x05, 0xFF, 0x0A, 0x77, 0x77, 0x20, 0x8F, 0xF0, 0x77, 0x77,
  0x72, 0x0B, 0xFF, 0x04, 0x77, 0x77, 0x48, 0x12, 0x5B, 0xFB, 0x80, 0xC0, 0x00, 0xAF, 0x90, 0xC8,
  0x0C, 0x00, 0x03, 0xF9, 0x09, 0x80, 0xC0, 0x00, 0x1F, 0x90, 0x68, 0x0C, 0x00, 0x01, 0xF9, 0x02,
  0x80, 0xC0, 0x00, 0x3F, 0x0E, 0x80, 0xC1, 0x00, 0x6F, 0x0B, 0x80, 0xC1, 0x00, 0x8F, 0x08, 0x80,
  0xC1, 0x00, 0xBF, 0x05, 0x80, 0xC1, 0x00, 0xEF, 0x01, 0x80, 0xC0, 0x00, 0x2F, 0x0D, 0x80, 0xC1,
  0x00, 0x6F, 0x0A, 0x80, 0xC1, 0x00, 0x9F, 0x07, 0x80, 0xC1, 0x00, 0xCF, 0x03, 0x80, 0xC1, 0x0F,
  0x98, 0x0C, 0x10, 0x03, 0xF0, 0xC8, 0x0C, 0x10, 0x07, 0xF0, 0x97, 0x20, 0xEF, 0xFA, 0x07, 0x73,
  0x0A, 0xF0, 0x67, 0x10, 0x2F, 0xFB, 0x05, 0x73, 0x0D, 0xF0, 0x27, 0x10, 0x5F, 0xFB, 0x02, 0x72,
  0x01, 0xF0, 0xE7, 0x20, 0x8F, 0xFA, 0x0E, 0x73, 0x04, 0xF0, 0xB7, 0x40, 0x30, 0xBF, 0xB8, 0x1C,
  0x62, 0x74, 0x08, 0xF0, 0x87, 0x50, 0x3F, 0x90, 0xE0, 0x57, 0x70, 0xBF, 0x04, 0x75, 0x04, 0xF0,
  0xA0, 0x17, 0x71, 0x0E, 0xF0, 0x17, 0x50, 0xAE, 0x07, 0x77, 0x20, 0x2F, 0x0D, 0x75, 0x03, 0xE0,
  0x57, 0x73, 0x05, 0xF0, 0xA7, 0x50, 0xDC, 0x0E, 0x03, 0x77, 0x40, 0x9F, 0x07, 0x74, 0x0B, 0xC0,
  0xE0, 0x37, 0x75, 0x0C, 0xF0, 0x37, 0x30, 0x9C, 0x0E, 0x02, 0x77, 0x6F, 0x97, 0x30, 0x8C, 0x0D,
  0x02, 0x77, 0x60, 0x3F, 0x0C, 0x72, 0x07, 0xC0, 0xE0, 0x27, 0x77, 0x06, 0xF0, 0x87, 0x10, 0x7C,
  0x0E, 0x02, 0x77, 0x71, 0x0A, 0xF0, 0x57, 0x08, 0xC0, 0xE0, 0x27, 0x77, 0x20, 0xDF, 0x01, 0x60,
  0x8C, 0x0E, 0x02, 0x77, 0x72, 0x01, 0xF0, 0xD6, 0x09, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0x4F, 0x0A,
  0x50, 0x9C, 0x0E, 0x03, 0x77, 0x74, 0x07, 0xF0, 0x64, 0x0A, 0xD0, 0x37, 0x77, 0x50, 0xBF, 0x02,
  0x30, 0xAE, 0x02, 0x77, 0x75, 0x0E, 0xE0, 0xD3, 0x0B, 0xF0, 0x87, 0x77, 0x40, 0x2F, 0x09, 0x20,
  0xBF, 0x90, 0xD7, 0x77, 0x40, 0x5F, 0x81, 0x50, 0xBF, 0xB0, 0x47, 0x77, 0x30, 0x8F, 0x02, 0x0C,
  0xFC, 0x09, 0x77, 0x73, 0x0C, 0xE0, 0xD0, 0xCC, 0x09, 0xF0, 0xE7, 0x77, 0x3F, 0xC8, 0x2E, 0x50,
  0xDF, 0x05, 0x77, 0x71, 0x03, 0xFB, 0x0D, 0x02, 0x20, 0x8F, 0x0B, 0x77, 0x71, 0x06, 0xFA, 0x0B,
  0x01, 0x30, 0x3F, 0x90, 0x17, 0x77, 0x09, 0xF9, 0x08, 0x60, 0xDF, 0x07, 0x77, 0x70, 0xDF, 0x05,
  0x70, 0x8F, 0x0C, 0x77, 0x60, 0x1F, 0x0E, 0x71, 0x03, 0xF9, 0x02, 0x77, 0x50, 0x4F, 0x0B, 0x72,
  0x0E, 0xF0, 0x87, 0x75, 0x07, 0xF0, 0x87, 0x20, 0x9F, 0x0E, 0x77, 0x50, 0xAF, 0x04, 0x72, 0x04,
  0xF9, 0x04, 0x77, 0x40, 0xEF, 0x01, 0x73, 0x0E, 0xF0, 0xA7, 0x73, 0x02, 0xF0, 0xD7, 0x40, 0x9F,
  0x0E, 0x77, 0x30, 0x5F, 0x0A, 0x74, 0x04, 0xF9, 0x05, 0x77, 0x20, 0x8F, 0x07, 0x75, 0x0E, 0xF0,
  0xB7, 0x72, 0x0B, 0xF0, 0x37, 0x50, 0xAF, 0x90, 0x27, 0x71, 0x0E, 0xF7, 0x60, 0x5F, 0x90, 0x97,
  0x70, 0x3F, 0x0C, 0x77, 0x0E, 0xF9, 0x02, 0x76, 0x06, 0xF0, 0x97, 0x70, 0x8F, 0x90, 0xC7, 0x60,
  0x9F, 0x06, 0x77, 0x01, 0x0E, 0xF9, 0x0B, 0x75, 0x0C, 0xF0, 0x27, 0x71, 0x07, 0xFA, 0x81, 0xD7,
  0x27, 0x2F, 0x0E, 0x77, 0x30, 0xCF, 0xC0, 0xE7, 0x04, 0xF0, 0xB7, 0x73, 0x01, 0x0B, 0xFB, 0x0B,
  0x70, 0x7F, 0x08, 0x77, 0x50, 0x70, 0xEF, 0x90, 0x88, 0x0C, 0x10, 0x83, 0x48, 0xAC, 0xEB, 0x04,
  0x70,
  // "l" (U+006C)
  0x50, 0xAF, 0xF0, 0xB5, 0x0D, 0xFF, 0x07, 0x40, 0x1F, 0xF9, 0x04, 0x40, 0x4F, 0xF9, 0x01, 0x68,
  0x21, 0x38, 0xDF, 0xA0, 0xD7, 0x30, 0x10, 0xDF, 0x90, 0xA7, 0x40, 0x6F, 0x90, 0x67, 0x40, 0x4F,
  0x90, 0x37, 0x40, 0x4F, 0x97, 0x50, 0x6F, 0x0C, 0x75, 0x09, 0xF0, 0x87, 0x50, 0xBF, 0x05, 0x75,
  0x0E, 0xF0, 0x27, 0x40, 0x2F, 0x0E, 0x75, 0x05, 0xF0, 0xB7, 0x50, 0x9F, 0x07, 0x75, 0x0C, 0xF0,
  0x47, 0x5F, 0x90, 0x17, 0x40, 0x3F, 0x0D, 0x75, 0x06, 0xF0, 0xA7, 0x50, 0xAF, 0x06, 0x75, 0x0D,
  0xF0, 0x37, 0x40, 0x1F, 0x97, 0x50, 0x4F, 0x0C, 0x75, 0x07, 0xF0, 0x87, 0x50, 0xBF, 0x05, 0x75,
  0x0E, 0xF0, 0x27, 0x40, 0x2F, 0x0E, 0x75, 0x05, 0xF0, 0xB7, 0x50, 0x8F, 0x07, 0x75, 0x0C, 0xF0,
  0x47, 0x5F, 0x90, 0x17, 0x40, 0x3F, 0x0D, 0x75, 0x06, 0xF0, 0x97, 0x50, 0x9F, 0x06, 0x75, 0x0D,
  0xF0, 0x37, 0x40, 0x1F, 0x97, 0x50, 0x4F, 0x0C, 0x75, 0x07, 0xF0, 0x87, 0x50, 0xBF, 0x05, 0x75,
  0x0E, 0xF0, 0x27, 0x40, 0x2F, 0x0E, 0x75, 0x05, 0xF0, 0xB7, 0x50, 0x8F, 0x07, 0x75, 0x0C, 0xF0,
  0x47, 0x5F, 0x90, 0x17, 0x40, 0x3F, 0x0D, 0x75, 0x06, 0xF0, 0x97, 0x50, 0x9F, 0x06, 0x75, 0x0C,
  0xF0, 0x37, 0x5F, 0x97, 0x50, 0x2F, 0x0D, 0x75, 0x05, 0xF0, 0xA7, 0x50, 0x8F, 0x07, 0x75, 0x0B,
  0xF0, 0x57, 0x50, 0xDF, 0x02, 0x75, 0xF9, 0x75, 0x02, 0xF0, 0xE7, 0x50, 0x4F, 0x0C, 0x75, 0x05,
  0xF0, 0xC7, 0x50, 0x6F, 0x0C, 0x75, 0x05, 0xF0, 0xE7, 0x02, 0x40, 0x4F, 0x90, 0x24, 0x82, 0x19,
  0xF2, 0x30, 0x1F, 0x98, 0x4C, 0x20, 0x38, 0xEA, 0x0A, 0x40, 0xCF, 0xF9, 0x0A, 0x40, 0x5F, 0xF0,
  0x76, 0x0A, 0xFC, 0x0C, 0x02, 0x71, 0x0B, 0xF9, 0x0D, 0x06, 0x74, 0x86, 0x5B, 0xEF, 0xEC, 0x95,
  0x72,
  // "m" (U+006D)
  0x77, 0x76, 0x87, 0x59, 0xDE, 0xFD, 0xB7, 0x17, 0x78, 0x75, 0x9D, 0xEF, 0xEC, 0x72, 0x73, 0x09,
  0xFF, 0x03, 0x60, 0x70, 0xEF, 0x90, 0xE0, 0x57, 0x40, 0x80, 0xEF, 0x90, 0xE0, 0x67, 0x20, 0xCF,
  0xF5, 0x01, 0x0C, 0xFD, 0x04, 0x71, 0x04, 0x0D, 0xFD, 0x05, 0x71, 0xFF, 0x0C, 0x40, 0x20, 0xEF,
  0xE0, 0xD7, 0x06, 0xFF, 0x0E, 0x01, 0x60, 0x3F, 0xF0, 0x93, 0x03, 0x0E, 0xFF, 0x90, 0x65, 0x07,
  0xFF, 0xA0, 0x77, 0x18, 0x21, 0x48, 0xEF, 0xA0, 0x62, 0x02, 0x0E, 0xA8, 0x4E, 0x72, 0x01, 0x7F,
  0x90, 0xB4, 0x06, 0xB8, 0x4C, 0x51, 0x02, 0x8F, 0x90, 0xD7, 0x40, 0x3F, 0xA8, 0x23, 0x01, 0xDA,
  0x0B, 0x01, 0x50, 0x9F, 0x93, 0x04, 0xB0, 0x86, 0x09, 0xF9, 0x02, 0x74, 0x0B, 0xF9, 0x20, 0xAA,
  0x09, 0x70, 0x4F, 0x98, 0x22, 0x01, 0xEA, 0x06, 0x70, 0x3F, 0x90, 0x57, 0x40, 0x9F, 0x81, 0xD0,
  0x7A, 0x09, 0x72, 0xF9, 0x81, 0x40, 0xBA, 0x06, 0x72, 0x0E, 0xF0, 0x67, 0x40, 0x9F, 0x0A, 0x02,
  0xA0, 0xB7, 0x30, 0xEF, 0x04, 0x05, 0xA0, 0x97, 0x30, 0xCF, 0x07, 0x74, 0x0B, 0xF8, 0x37, 0xCF,
  0xD1, 0x73, 0x0E, 0xF8, 0x23, 0xEF, 0xC7, 0x40, 0xCF, 0x07, 0x74, 0x0D, 0xFB, 0x04, 0x74, 0xF9,
  0x0D, 0xA0, 0x37, 0x40, 0xDF, 0x06, 0x73, 0x01, 0xFB, 0x09, 0x74, 0x01, 0xFB, 0x09, 0x75, 0x0E,
  0xF0, 0x47, 0x30, 0x4F, 0xA0, 0xE0, 0x17, 0x40, 0x3F, 0xA0, 0xE0, 0x17, 0x40, 0x1F, 0x90, 0x27,
  0x30, 0x7F, 0xA0, 0x67, 0x50, 0x5F, 0xA0, 0x67, 0x50, 0x3F, 0x0E, 0x74, 0x0A, 0xF9, 0x0D, 0x76,
  0x08, 0xF9, 0x0E, 0x76, 0x06, 0xF0, 0xB7, 0x40, 0xEF, 0x90, 0x57, 0x60, 0xBF, 0x90, 0x77, 0x60,
  0x9F, 0x08, 0x73, 0x01, 0xF9, 0x0D, 0x77, 0x0E, 0xF0, 0xE7, 0x70, 0xCF, 0x05, 0x73, 0x05, 0xF9,
  0x06, 0x76, 0x02, 0xF9, 0x08, 0x77, 0xF9, 0x02, 0x73, 0x08, 0xF0, 0xE7, 0x70, 0x6F, 0x90, 0x27,
  0x60, 0x3F, 0x0E, 0x74, 0x0B, 0xF0, 0x97, 0x70, 0x9F, 0x0C, 0x77, 0x07, 0xF0, 0xB7, 0x40, 0xEF,
  0x03, 0x77, 0x0C, 0xF0, 0x77, 0x70, 0xAF, 0x08, 0x73, 0x02, 0xF0, 0xD7, 0x71, 0xF9, 0x03, 0x77,
  0x0D, 0xF0, 0x57, 0x30, 0x6F, 0x09, 0x77, 0x04, 0xF0, 0xE7, 0x70, 0x1F, 0x90, 0x27, 0x30, 0x9F,
  0x05, 0x77, 0x07, 0xF0, 0xB7, 0x70, 0x4F, 0x0E, 0x74, 0x0C, 0xF0, 0x17, 0x70, 0xBF, 0x07, 0x77,
  0x08, 0xF0, 0xB7, 0x4F, 0x0D, 0x77, 0x10, 0xEF, 0x04, 0x77, 0x0B, 0xF0, 0x77, 0x30, 0x3F, 0x09,
  0x77, 0x02, 0xF9, 0x77, 0x10, 0xEF, 0x04, 0x73, 0x06, 0xF0, 0x67, 0x70, 0x6F, 0x0C, 0x77, 0x02,
  0xF9, 0x01, 0x73, 0x0A, 0xF0, 0x37, 0x70, 0x9F, 0x09, 0x77, 0x05, 0xF0, 0xD7, 0x40, 0xDF, 0x77,
  0x10, 0xCF, 0x05, 0x77, 0x08, 0xF0, 0xA7, 0x30, 0x1F, 0x0C, 0x77, 0x10, 0xEF, 0x02, 0x77, 0x0C,
  0xF0, 0x77, 0x30, 0x4F, 0x09, 0x77, 0x02, 0xF0, 0xE7, 0x71, 0x0E, 0xF0, 0x47, 0x30, 0x7F, 0x06,
  0x77, 0x05, 0xF0, 0xB7, 0x70, 0x2F, 0x90, 0x17, 0x30, 0xBF, 0x03, 0x77, 0x08, 0xF0, 0x87, 0x70,
  0x5F, 0x0E, 0x74, 0x0E, 0xF7, 0x71, 0x0A, 0xF0, 0x67, 0x70, 0x7F, 0x0B, 0x73, 0x02, 0xF0, 0xC7,
  0x71, 0x0D, 0xF0, 0x37, 0x70, 0x9F, 0x08, 0x73, 0x05, 0xF0, 0x97, 0x71, 0xF9, 0x01, 0x77, 0x0B,
  0xF0, 0x67, 0x30, 0x8F, 0x06, 0x77, 0x03, 0xF0, 0xE7, 0x71, 0x0D, 0xF0, 0x57, 0x30, 0xBF, 0x02,
  0x77, 0x05, 0xF0, 0xC7, 0x71, 0x0E, 0xF0, 0x47, 0x30, 0xEF, 0x77, 0x10, 0x8F, 0x0A, 0x77, 0x10,
  0xEF, 0x03, 0x72, 0x02, 0xF0, 0xC7, 0x71, 0x0A, 0xF0, 0x87, 0x71, 0xF9, 0x03, 0x72, 0x06, 0xF0,
  0x87, 0x71, 0x0D, 0xF0, 0x67, 0x71, 0x0E, 0xF0, 0x57, 0x20, 0x9F, 0x05, 0x77, 0x1F, 0x90, 0x37,
  0x71, 0x0C, 0xF0, 0x95, 0x83, 0x3C, 0x10, 0xCF, 0x02, 0x77, 0x01, 0xF9, 0x01, 0x77, 0x10, 0x9F,
  0x98, 0x36, 0x01, 0x4A, 0xA0, 0x91, 0xF0, 0xE7, 0x71, 0x03, 0xF9, 0x77, 0x20, 0x4F, 0xF9, 0x0D,
  0x03, 0xF0, 0xB7, 0x71, 0x05, 0xF0, 0xC7, 0x73, 0x0C, 0xFE, 0x81, 0xB1, 0x7F, 0x08, 0x77, 0x10,
  0x7F, 0x0A, 0x77, 0x30, 0x4F, 0xC0, 0xE0, 0x72, 0x0A, 0xF0, 0x57, 0x71, 0x09, 0xF0, 0x97, 0x74,
  0x06, 0xFA, 0x0A, 0x02, 0x80, 0xE3, 0x08, 0x72, 0x9D, 0xEF, 0xEB, 0x82, 0x50,
  // "n" (U+006E)
  0x77, 0x76, 0x87, 0x59, 0xDE, 0xFD, 0xB7, 0x17, 0x30, 0x8F, 0xF7, 0x06, 0x0D, 0xF9, 0x0E, 0x06,
  0x72, 0x0C, 0xFE, 0x0C, 0x50, 0x10, 0xAF, 0xD0, 0x57, 0x1F, 0xF0, 0xA4, 0x01, 0x0D, 0xFE, 0x0E,
  0x01, 0x60, 0x3F, 0xF0, 0x73, 0x01, 0x0D, 0xFF, 0x90, 0x77, 0x18, 0x11, 0x49, 0xFB, 0x04, 0x30,
  0xCF, 0xFA, 0x0D, 0x74, 0x03, 0xFA, 0x02, 0x20, 0xAB, 0x84, 0xE7, 0x20, 0x16, 0xFA, 0x02, 0x74,
  0x0B, 0xF9, 0x20, 0x6B, 0x0B, 0x01, 0x50, 0x8F, 0x90, 0x57, 0x40, 0x9F, 0x82, 0xC0, 0x2E, 0xA0,
  0x97, 0x03, 0xF9, 0x06, 0x74, 0x09, 0xF8, 0x1A, 0x0C, 0xA0, 0x97, 0x2F, 0x90, 0x77, 0x40, 0xBF,
  0x07, 0x06, 0xA0, 0xB7, 0x30, 0xEF, 0x06, 0x74, 0x0D, 0xF8, 0x37, 0xEF, 0xD1, 0x73, 0x0E, 0xF0,
  0x57, 0x30, 0x1F, 0xC0, 0x37, 0x4F, 0x90, 0x37, 0x30, 0x4F, 0xB0, 0x87, 0x40, 0x1F, 0x90, 0x17,
  0x30, 0x7F, 0xA0, 0xE0, 0x17, 0x40, 0x3F, 0x0E, 0x74, 0x0A, 0xFA, 0x06, 0x75, 0x06, 0xF0, 0xB7,
  0x40, 0xEF, 0x90, 0xC7, 0x60, 0x9F, 0x07, 0x73, 0x01, 0xFA, 0x05, 0x76, 0x0C, 0xF0, 0x47, 0x30,
  0x5F, 0x90, 0xD7, 0x70, 0xEF, 0x01, 0x73, 0x08, 0xF9, 0x05, 0x76, 0x02, 0xF0, 0xE7, 0x40, 0xBF,
  0x0E, 0x77, 0x05, 0xF0, 0xA7, 0x40, 0xEF, 0x08, 0x77, 0x09, 0xF0, 0x77, 0x30, 0x2F, 0x90, 0x27,
  0x70, 0xCF, 0x04, 0x73, 0x06, 0xF0, 0xD7, 0x71, 0xF9, 0x01, 0x73, 0x09, 0xF0, 0x87, 0x70, 0x4F,
  0x0D, 0x74, 0x0C, 0xF0, 0x47, 0x70, 0x7F, 0x0A, 0x74, 0xF9, 0x01, 0x77, 0x0B, 0xF0, 0x67, 0x30,
  0x3F, 0x0D, 0x77, 0x10, 0xEF, 0x03, 0x73, 0x06, 0xF0, 0x97, 0x70, 0x3F, 0x97, 0x40, 0xAF, 0x06,
  0x77, 0x06, 0xF0, 0xC7, 0x40, 0xDF, 0x03, 0x77, 0x09, 0xF0, 0x97, 0x30, 0x1F, 0x97, 0x71, 0x0C,
  0xF0, 0x67, 0x30, 0x4F, 0x0C, 0x77, 0x1F, 0x90, 0x27, 0x30, 0x7F, 0x08, 0x77, 0x02, 0xF9, 0x74,
  0x0B, 0xF0, 0x57, 0x70, 0x5F, 0x0C, 0x74, 0x0E, 0xF0, 0x27, 0x70, 0x7F, 0x0A, 0x73, 0x02, 0xF0,
  0xE7, 0x71, 0x09, 0xF0, 0x87, 0x30, 0x5F, 0x0B, 0x77, 0x10, 0xBF, 0x06, 0x73, 0x08, 0xF0, 0x77,
  0x71, 0x0D, 0xF0, 0x47, 0x30, 0xBF, 0x04, 0x77, 0x10, 0xEF, 0x03, 0x73, 0x0E, 0xF0, 0x17, 0x71,
  0xF9, 0x02, 0x72, 0x02, 0xF0, 0xD7, 0x72, 0xF9, 0x03, 0x72, 0x06, 0xF0, 0x97, 0x72, 0x0E, 0xF0,
  0x47, 0x20, 0x9F, 0x06, 0x77, 0x20, 0xCF, 0x09, 0x58, 0x33, 0xC1, 0x0C, 0xF0, 0x37, 0x72, 0x09,
  0xF9, 0x83, 0x50, 0x14, 0xAA, 0x09, 0x1F, 0x97, 0x73, 0x04, 0xFF, 0x90, 0xD0, 0x3F, 0x0C, 0x77,
  0x40, 0xCF, 0xE8, 0x1B, 0x17, 0xF0, 0x87, 0x74, 0x03, 0xFC, 0x0E, 0x06, 0x20, 0xAF, 0x05, 0x77,
  0x50, 0x40, 0xEF, 0x90, 0xA0, 0x17, 0x77, 0x74, 0x87, 0x18, 0xCE, 0xFE, 0xB7, 0x25,
  // "o" (U+006F)
  0x77, 0x58, 0x92, 0x36, 0xAC, 0xDE, 0xFE, 0xCA, 0x61, 0x77, 0x74, 0x81, 0x17, 0xDF, 0xD0, 0xA0,
  0x27, 0x77, 0x10, 0x70, 0xEF, 0xFA, 0x08, 0x77, 0x50, 0x20, 0xDF, 0xFD, 0x0B, 0x77, 0x30, 0x50,
  0xEF, 0x84, 0xC8, 0x77, 0x9D, 0xF9, 0x0B, 0x77, 0x10, 0x7F, 0x0C, 0x03, 0x60, 0x6F, 0x90, 0x87,
  0x60, 0x7F, 0x08, 0x72, 0x04, 0xF9, 0x02, 0x74, 0x05, 0xF0, 0x87, 0x40, 0x8F, 0x0B, 0x73, 0x03,
  0xF0, 0xA7, 0x50, 0x10, 0xEF, 0x02, 0x71, 0x01, 0x0D, 0xE0, 0xD7, 0x70, 0xAF, 0x08, 0x71, 0x0A,
  0xF0, 0x47, 0x70, 0x6F, 0x0C, 0x70, 0x4F, 0x0A, 0x77, 0x10, 0x3F, 0x90, 0x16, 0x0D, 0xF0, 0x27,
  0x71, 0x01, 0xF9, 0x03, 0x50, 0x6F, 0x0B, 0x77, 0x3F, 0x90, 0x55, 0x0E, 0xF0, 0x37, 0x73, 0x0E,
  0xF0, 0x74, 0x06, 0xF0, 0xC7, 0x74, 0x0E, 0xF0, 0x84, 0x0D, 0xF0, 0x77, 0x74, 0x0E, 0xF0, 0x93,
  0x04, 0xF9, 0x02, 0x77, 0x40, 0xEF, 0x09, 0x30, 0xAF, 0x0C, 0x77, 0x5F, 0x90, 0x93, 0x0E, 0xF0,
  0x77, 0x75, 0xF9, 0x08, 0x20, 0x4F, 0x90, 0x37, 0x74, 0x02, 0xF9, 0x07, 0x20, 0x9F, 0x0E, 0x77,
  0x50, 0x3F, 0x90, 0x62, 0x0D, 0xF0, 0xB7, 0x75, 0x05, 0xF9, 0x81, 0x40, 0x1F, 0x90, 0x87, 0x75,
  0x07, 0xF9, 0x81, 0x20, 0x5F, 0x90, 0x57, 0x75, 0x0A, 0xF0, 0xE2, 0x08, 0xF9, 0x02, 0x77, 0x50,
  0xDF, 0x0C, 0x20, 0xBF, 0x0E, 0x77, 0x6F, 0x90, 0x92, 0x0D, 0xF0, 0xC7, 0x75, 0x03, 0xF9, 0x05,
  0x2F, 0x90, 0xB7, 0x75, 0x07, 0xF9, 0x81, 0x10, 0x1F, 0x90, 0x97, 0x75, 0x0B, 0xF0, 0xC2, 0x02,
  0xF9, 0x07, 0x77, 0x50, 0xEF, 0x07, 0x20, 0x2F, 0x90, 0x67, 0x74, 0x03, 0xF9, 0x02, 0x20, 0x3F,
  0x90, 0x67, 0x74, 0x09, 0xF0, 0xC3, 0x02, 0xF9, 0x05, 0x77, 0x40, 0xEF, 0x05, 0x30, 0x2F, 0x90,
  0x57, 0x73, 0x04, 0xF0, 0xE4, 0x01, 0xF9, 0x05, 0x77, 0x30, 0xAF, 0x06, 0x50, 0xEF, 0x06, 0x77,
  0x20, 0x2F, 0x0D, 0x60, 0xCF, 0x08, 0x77, 0x20, 0x9F, 0x05, 0x60, 0x9F, 0x0A, 0x77, 0x10, 0x2F,
  0x0C, 0x70, 0x5F, 0x0D, 0x77, 0x10, 0xAE, 0x0E, 0x02, 0x70, 0x1F, 0x90, 0x27, 0x60, 0x5F, 0x06,
  0x72, 0x0A, 0xF0, 0x77, 0x50, 0x20, 0xEE, 0x0A, 0x73, 0x03, 0xF0, 0xE0, 0x17, 0x30, 0x10, 0xDE,
  0x0D, 0x01, 0x74, 0x0B, 0xF0, 0xB7, 0x20, 0x20, 0xDE, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xF0, 0xC0,
  0x26, 0x06, 0x0E, 0xE0, 0xD0, 0x27, 0x70, 0x4F, 0xA8, 0x4B, 0x76, 0x7A, 0xEF, 0x0B, 0x01, 0x77,
  0x20, 0x40, 0xEF, 0xFD, 0x08, 0x77, 0x50, 0x20, 0xCF, 0xFA, 0x0B, 0x02, 0x77, 0x71, 0x06, 0x0D,
  0xFD, 0x0B, 0x04, 0x77, 0x75, 0x89, 0x23, 0x8B, 0xDE, 0xFE, 0xDB, 0x95, 0x17, 0x74,
  // "p" (U+0070)
  0x77, 0x77, 0x28, 0x74, 0x9C, 0xDF, 0xEC, 0x71, 0x76, 0x04, 0xFE, 0x0D, 0x60, 0x50, 0xDF, 0xA0,
  0x77, 0x50, 0x7F, 0xE0, 0xA5, 0x0A, 0xFD, 0x09, 0x74, 0x0B, 0xFE, 0x07, 0x30, 0x10, 0xCF, 0xF0,
  0x77, 0x30, 0xEF, 0xE0, 0x43, 0x0C, 0xFF, 0xA0, 0x27, 0x38, 0x21, 0x26, 0xCF, 0xA0, 0x12, 0x0B,
  0xB8, 0x4D, 0x61, 0x03, 0xBF, 0x90, 0x97, 0x70, 0xCF, 0x0D, 0x20, 0x8B, 0x09, 0x60, 0xCF, 0x90,
  0x17, 0x60, 0x5F, 0x81, 0xA0, 0x4B, 0x07, 0x70, 0x4F, 0x90, 0x57, 0x60, 0x3F, 0x81, 0x71, 0xEA,
  0x08, 0x72, 0x0D, 0xF0, 0xA7, 0x60, 0x4F, 0x04, 0x09, 0xA0, 0xB7, 0x30, 0x9F, 0x0D, 0x76, 0x05,
  0xF0, 0x4A, 0x0E, 0x01, 0x73, 0x06, 0xF9, 0x76, 0x08, 0xF0, 0xEA, 0x05, 0x74, 0x04, 0xF9, 0x02,
  0x75, 0x0B, 0xFA, 0x0B, 0x75, 0x02, 0xF9, 0x03, 0x75, 0x0E, 0xFA, 0x03, 0x75, 0x01, 0xF9, 0x04,
  0x74, 0x02, 0xFA, 0x0A, 0x76, 0x01, 0xF9, 0x05, 0x74, 0x06, 0xFA, 0x02, 0x76, 0x01, 0xF9, 0x05,
  0x74, 0x09, 0xF9, 0x0A, 0x77, 0x02, 0xF9, 0x04, 0x74, 0x0C, 0xF9, 0x03, 0x77, 0x03, 0xF9, 0x03,
  0x74, 0xF9, 0x0C, 0x77, 0x10, 0x4F, 0x90, 0x27, 0x30, 0x3F, 0x90, 0x67, 0x71, 0x06, 0xF9, 0x01,
  0x73, 0x06, 0xF9, 0x01, 0x77, 0x10, 0x9F, 0x0E, 0x74, 0x0A, 0xF0, 0xA7, 0x72, 0x0B, 0xF0, 0xC7,
  0x40, 0xDF, 0x05, 0x77, 0x20, 0xDF, 0x09, 0x73, 0x01, 0xF9, 0x01, 0x77, 0x10, 0x1F, 0x90, 0x77,
  0x30, 0x4F, 0x0C, 0x77, 0x20, 0x4F, 0x90, 0x37, 0x30, 0x7F, 0x09, 0x77, 0x20, 0x8F, 0x0E, 0x74,
  0x0B, 0xF0, 0x57, 0x72, 0x0B, 0xF0, 0xA7, 0x40, 0xEF, 0x02, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x30,
  0x2F, 0x0E, 0x77, 0x20, 0x5F, 0x90, 0x27, 0x30, 0x5F, 0x0B, 0x77, 0x20, 0x9F, 0x0C, 0x74, 0x08,
  0xF0, 0x77, 0x72, 0x0E, 0xF0, 0x67, 0x40, 0xBF, 0x04, 0x77, 0x10, 0x4F, 0x90, 0x17, 0x40, 0xEF,
  0x01, 0x77, 0x10, 0xAF, 0x0A, 0x74, 0x02, 0xF0, 0xD7, 0x71, 0x01, 0xF9, 0x04, 0x74, 0x06, 0xF0,
  0xA7, 0x71, 0x07, 0xF0, 0xB7, 0x50, 0x9F, 0x06, 0x77, 0x10, 0xEF, 0x03, 0x75, 0x0C, 0xF0, 0x37,
  0x70, 0x7F, 0x0B, 0x76, 0xF9, 0x77, 0x01, 0x0E, 0xF0, 0x37, 0x50, 0x3F, 0x0C, 0x77, 0x08, 0xF0,
  0x97, 0x60, 0x7F, 0x08, 0x76, 0x03, 0xF0, 0xD7, 0x70, 0xAF, 0x05, 0x76, 0x0D, 0xF0, 0x37, 0x70,
  0xDF, 0x02, 0x75, 0x0A, 0xF0, 0x87, 0x70, 0x1F, 0x90, 0x27, 0x40, 0x9F, 0x0B, 0x77, 0x10, 0x4F,
  0x90, 0xD0, 0x27, 0x20, 0xAF, 0x0C, 0x01, 0x77, 0x10, 0x7F, 0xA0, 0xE0, 0x56, 0x04, 0x0D, 0xF0,
  0xC0, 0x17, 0x72, 0x0B, 0xFC, 0x84, 0xD8, 0x67, 0x9D, 0xF9, 0x0B, 0x77, 0x40, 0xEF, 0xFF, 0xB0,
  0x77, 0x74, 0x02, 0xF0, 0xEF, 0xF9, 0x0C, 0x03, 0x77, 0x50, 0x5F, 0x81, 0x64, 0xDF, 0xC0, 0xC0,
  0x57, 0x77, 0x08, 0xF0, 0x42, 0x89, 0x13, 0x8B, 0xDE, 0xFE, 0xCA, 0x62, 0x77, 0x72, 0x0B, 0xF0,
  0x18, 0x0C, 0x00, 0x0E, 0xE0, 0xE8, 0x0C, 0x00, 0x02, 0xF0, 0xB8, 0x0C, 0x00, 0x06, 0xF0, 0x88,
  0x0C, 0x00, 0x09, 0xF0, 0x48, 0x0C, 0x00, 0x0C, 0xF0, 0x18, 0x0C, 0x00, 0xF0, 0xE8, 0x0C, 0x00,
  0x03, 0xF0, 0xB8, 0x0C, 0x00, 0x07, 0xF0, 0x78, 0x0C, 0x00, 0x0A, 0xF0, 0x48, 0x0C, 0x00, 0x0D,
  0xF0, 0x17, 0x77, 0x77, 0x01, 0xF0, 0xE8, 0x0C, 0x00, 0x04, 0xF0, 0xD8, 0x0C, 0x00, 0x07, 0xF0,
  0xD8, 0x0C, 0x00, 0x0B, 0xF0, 0xE8, 0x0C, 0x00, 0x0E, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x2F, 0xB8,
  0x19, 0x41, 0x77, 0x77, 0x30, 0x5F, 0xF9, 0x77, 0x77, 0x10, 0x8F, 0xF0, 0xC7, 0x77, 0x71, 0x0B,
  0xFF, 0x09, 0x77, 0x77, 0x10, 0xEF, 0xF0, 0x67, 0x77, 0x71,
  // "q" (U+0071)
  0x77, 0x58, 0x92, 0x15, 0x9C, 0xEF, 0xED, 0xC9, 0x51, 0x50, 0x10, 0xAA, 0x0B, 0x77, 0x30, 0x20,
  0xAF, 0xD0, 0xB0, 0x42, 0x05, 0x0E, 0xB0, 0x77, 0x71, 0x01, 0x09, 0xFF, 0xA0, 0xA0, 0xBD, 0x04,
  0x77, 0x04, 0x0E, 0xFF, 0xFB, 0x01, 0x76, 0x07, 0xF9, 0x84, 0xEA, 0x76, 0x7B, 0xFC, 0x0D, 0x76,
  0x09, 0xF0, 0xE0, 0x66, 0x02, 0x0C, 0xFA, 0x0A, 0x75, 0x09, 0xF0, 0xB0, 0x17, 0x20, 0xCF, 0x90,
  0x77, 0x40, 0x8F, 0x0A, 0x74, 0x02, 0xF9, 0x03, 0x73, 0x05, 0xF0, 0xB7, 0x50, 0x2F, 0x97, 0x30,
  0x10, 0xEE, 0x0E, 0x01, 0x75, 0x05, 0xF0, 0xC7, 0x30, 0xBF, 0x04, 0x76, 0x08, 0xF0, 0x97, 0x20,
  0x7F, 0x0A, 0x77, 0x0B, 0xF0, 0x67, 0x10, 0x1F, 0x90, 0x17, 0x70, 0xEF, 0x02, 0x71, 0x09, 0xF0,
  0x97, 0x70, 0x2F, 0x0E, 0x71, 0x02, 0xF9, 0x02, 0x77, 0x05, 0xF0, 0xB7, 0x10, 0xBF, 0x0A, 0x77,
  0x10, 0x8F, 0x08, 0x70, 0x3F, 0x90, 0x37, 0x71, 0x0B, 0xF0, 0x57, 0x09, 0xF0, 0xD7, 0x72, 0x0E,
  0xF0, 0x16, 0x01, 0xF9, 0x08, 0x77, 0x10, 0x2F, 0x0E, 0x70, 0x6F, 0x90, 0x27, 0x71, 0x05, 0xF0,
  0xA7, 0x0C, 0xF0, 0xC7, 0x72, 0x08, 0xF0, 0x76, 0x01, 0xF9, 0x08, 0x77, 0x20, 0xBF, 0x04, 0x60,
  0x6F, 0x90, 0x47, 0x72, 0x0E, 0xF0, 0x16, 0x0A, 0xF9, 0x77, 0x20, 0x2F, 0x0D, 0x70, 0xEF, 0x0B,
  0x77, 0x20, 0x6F, 0x0A, 0x60, 0x2F, 0x90, 0x87, 0x72, 0x0A, 0xF0, 0x66, 0x05, 0xF9, 0x04, 0x77,
  0x20, 0xEF, 0x03, 0x60, 0x8F, 0x90, 0x17, 0x71, 0x03, 0xF9, 0x70, 0xBF, 0x0E, 0x77, 0x20, 0x8F,
  0x0C, 0x70, 0xDF, 0x0B, 0x77, 0x20, 0xEF, 0x09, 0x7F, 0x90, 0x97, 0x71, 0x04, 0xF9, 0x05, 0x60,
  0x1F, 0x90, 0x77, 0x71, 0x0A, 0xF9, 0x02, 0x60, 0x2F, 0x90, 0x67, 0x70, 0x2F, 0x90, 0xE7, 0x02,
  0xF9, 0x05, 0x77, 0x09, 0xF9, 0x0B, 0x70, 0x3F, 0x90, 0x47, 0x60, 0x1F, 0xA0, 0x87, 0x02, 0xF9,
  0x03, 0x76, 0x09, 0xFA, 0x04, 0x70, 0x2F, 0x90, 0x47, 0x50, 0x2F, 0xB0, 0x17, 0x01, 0xF9, 0x04,
  0x75, 0x0A, 0xA0, 0xEE, 0x0D, 0x72, 0xF9, 0x05, 0x74, 0x04, 0xA0, 0x80, 0xCE, 0x0A, 0x72, 0x0D,
  0xF0, 0x77, 0x38, 0x31, 0xDF, 0xE1, 0xF0, 0x77, 0x20, 0xAF, 0x0A, 0x73, 0x0A, 0xA0, 0x60, 0x4F,
  0x04, 0x72, 0x07, 0xF0, 0xE7, 0x20, 0x8A, 0x81, 0xB0, 0x7F, 0x73, 0x02, 0xF9, 0x05, 0x70, 0x7A,
  0x82, 0xE2, 0x0B, 0xE0, 0xD7, 0x40, 0xDF, 0x0E, 0x01, 0x50, 0x9B, 0x06, 0x20, 0xEE, 0x09, 0x74,
  0x06, 0xF9, 0x84, 0xD4, 0x01, 0x5D, 0xB0, 0xA2, 0x03, 0xF0, 0x67, 0x50, 0xDF, 0xF9, 0x0C, 0x30,
  0x6F, 0x03, 0x75, 0x04, 0xFF, 0x0B, 0x01, 0x30, 0xAF, 0x77, 0x06, 0xFD, 0x09, 0x50, 0xDE, 0x0C,
  0x77, 0x10, 0x40, 0xEF, 0x90, 0xD0, 0x55, 0x01, 0xF0, 0x87, 0x73, 0x86, 0x6B, 0xDF, 0xEC, 0x94,
  0x70, 0x5F, 0x05, 0x77, 0x77, 0x40, 0x8F, 0x02, 0x77, 0x77, 0x40, 0xBE, 0x0E, 0x77, 0x77, 0x50,
  0xEE, 0x0B, 0x77, 0x77, 0x40, 0x2F, 0x07, 0x77, 0x77, 0x40, 0x5F, 0x04, 0x77, 0x77, 0x40, 0x8F,
  0x01, 0x77, 0x77, 0x40, 0xBE, 0x0D, 0x77, 0x77, 0x50, 0xEE, 0x0A, 0x77, 0x77, 0x40, 0x2F, 0x07,
  0x77, 0x77, 0x40, 0x5F, 0x03, 0x77, 0x77, 0x40, 0x8F, 0x77, 0x77, 0x50, 0xBE, 0x0D, 0x77, 0x77,
  0x50, 0xEE, 0x0C, 0x77, 0x77, 0x40, 0x2F, 0x0C, 0x77, 0x77, 0x40, 0x5F, 0x0E, 0x77, 0x77, 0x40,
  0x8F, 0x90, 0x77, 0x77, 0x73, 0x0B, 0xFA, 0x81, 0xA4, 0x17, 0x77, 0x70, 0xEF, 0xE0, 0x97, 0x77,
  0x40, 0x2F, 0xF0, 0x67, 0x77, 0x40, 0x5F, 0xF0, 0x37, 0x77, 0x40, 0x8F, 0xF7, 0x10,
  // "r" (U+0072)
  0x77, 0x74, 0x87, 0x28, 0xBE, 0xFE, 0xC8, 0x25, 0x01, 0xFF, 0x04, 0x50, 0x10, 0x9F, 0xA0, 0x54,
  0x04, 0xFF, 0x01, 0x40, 0x20, 0xDF, 0xC0, 0x33, 0x07, 0xFE, 0x0E, 0x40, 0x30, 0xEF, 0xD0, 0xB3,
  0x0A, 0xFE, 0x0C, 0x30, 0x10, 0xEF, 0xF0, 0x14, 0x81, 0x25, 0x9F, 0xA0, 0x93, 0x0B, 0xFF, 0x90,
  0x37, 0x03, 0x0E, 0xF0, 0x72, 0x07, 0xB8, 0x3E, 0x61, 0x05, 0xF9, 0x03, 0x71, 0x09, 0xF8, 0x25,
  0x01, 0xEA, 0x0C, 0x01, 0x40, 0x8F, 0x01, 0x71, 0x06, 0xF8, 0x12, 0x0A, 0xA0, 0xD0, 0x15, 0x03,
  0xE0, 0xD7, 0x20, 0x6F, 0x10, 0x3A, 0x0E, 0x02, 0x7E, 0x07, 0x72, 0x07, 0xE8, 0x1D, 0x0B, 0xA0,
  0x67, 0x10, 0xEC, 0x0C, 0x73, 0x09, 0xE0, 0xB0, 0x4A, 0x0B, 0x72, 0x0D, 0xB0, 0xC0, 0x17, 0x30,
  0xCE, 0x00, 0xCA, 0x02, 0x72, 0x82, 0xBC, 0x94, 0x75, 0x0E, 0xFA, 0x08, 0x77, 0x74, 0x02, 0xFA,
  0x0E, 0x01, 0x77, 0x74, 0x06, 0xFA, 0x09, 0x77, 0x75, 0x09, 0xFA, 0x02, 0x77, 0x75, 0x0C, 0xF9,
  0x0A, 0x77, 0x76, 0xFA, 0x03, 0x77, 0x75, 0x03, 0xF9, 0x0D, 0x77, 0x76, 0x07, 0xF9, 0x07, 0x77,
  0x76, 0x0A, 0xF9, 0x01, 0x77, 0x76, 0x0D, 0xF0, 0xB7, 0x77, 0x60, 0x1F, 0x90, 0x57, 0x77, 0x60,
  0x5F, 0x90, 0x17, 0x77, 0x60, 0x8F, 0x0B, 0x77, 0x77, 0x0B, 0xF0, 0x77, 0x77, 0x70, 0xEF, 0x02,
  0x77, 0x76, 0x02, 0xF0, 0xE7, 0x77, 0x70, 0x6F, 0x0A, 0x77, 0x77, 0x09, 0xF0, 0x67, 0x77, 0x70,
  0xCF, 0x03, 0x77, 0x77, 0xF0, 0xE7, 0x77, 0x70, 0x4F, 0x0B, 0x77, 0x77, 0x07, 0xF0, 0x87, 0x77,
  0x70, 0xAF, 0x05, 0x77, 0x77, 0x0D, 0xF0, 0x27, 0x77, 0x60, 0x1F, 0x0E, 0x77, 0x77, 0x05, 0xF0,
  0xB7, 0x77, 0x70, 0x8F, 0x07, 0x77, 0x77, 0x0B, 0xF0, 0x47, 0x77, 0x70, 0xEF, 0x01, 0x77, 0x76,
  0x02, 0xF0, 0xD7, 0x77, 0x70, 0x6F, 0x0A, 0x77, 0x77, 0x09, 0xF0, 0x77, 0x77, 0x70, 0xCF, 0x03,
  0x77, 0x77, 0xF9, 0x77, 0x77, 0x04, 0xF0, 0xC7, 0x77, 0x70, 0x7F, 0x09, 0x77, 0x77,
  // "s" (U+0073)
  0x77, 0x18, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xEC, 0x96, 0x17, 0x75, 0x04, 0x0B, 0xFE, 0x0A, 0x02,
  0x77, 0x10, 0x20, 0xCF, 0xFB, 0x06, 0x76, 0x06, 0xFF, 0xE0, 0x87, 0x40, 0x8F, 0x84, 0xEA, 0x76,
  0x7A, 0xFA, 0x05, 0x72, 0x06, 0xF0, 0x76, 0x01, 0x0C, 0xF0, 0xD7, 0x10, 0x2F, 0x04, 0x71, 0x01,
  0x0D, 0xF0, 0x47, 0x0B, 0xE0, 0x77, 0x30, 0x4F, 0x08, 0x60, 0x3E, 0x0D, 0x75, 0x0D, 0xE0, 0x96,
  0x09, 0xE0, 0x77, 0x50, 0x8E, 0x08, 0x60, 0xDE, 0x03, 0x75, 0x05, 0xE0, 0x55, 0x01, 0xF0, 0x17,
  0x50, 0x2D, 0x0E, 0x60, 0x3F, 0x76, 0x01, 0xC0, 0xE0, 0x36, 0x04, 0xF0, 0x27, 0x6A, 0x81, 0xE9,
  0x27, 0x05, 0xF0, 0x57, 0x60, 0x30, 0x27, 0x30, 0x4F, 0x0B, 0x77, 0x74, 0x02, 0xF9, 0x05, 0x77,
  0x74, 0x0E, 0xF0, 0xE0, 0x37, 0x77, 0x30, 0xBF, 0x90, 0xE0, 0x47, 0x77, 0x20, 0x5F, 0xB0, 0x87,
  0x77, 0x20, 0xDF, 0xB0, 0xD0, 0x57, 0x77, 0x04, 0xFD, 0x0B, 0x03, 0x77, 0x60, 0x7F, 0xE0, 0x97,
  0x76, 0x07, 0xFE, 0x0D, 0x03, 0x77, 0x50, 0x5F, 0xE0, 0xE0, 0x47, 0x75, 0x03, 0x0D, 0xFE, 0x05,
  0x77, 0x60, 0x8F, 0xE0, 0x37, 0x76, 0x02, 0x0B, 0xFC, 0x0D, 0x77, 0x71, 0x04, 0x0D, 0xFB, 0x07,
  0x77, 0x72, 0x0A, 0xFA, 0x0E, 0x77, 0x73, 0x07, 0xFA, 0x04, 0x77, 0x73, 0x08, 0xF9, 0x07, 0x77,
  0x74, 0x0C, 0xF0, 0xA7, 0x77, 0x40, 0x4F, 0x0C, 0x78, 0x17, 0xCE, 0x77, 0x20, 0xEE, 0x0D, 0x50,
  0x20, 0xDB, 0x77, 0x20, 0xBE, 0x0C, 0x50, 0xDC, 0x01, 0x77, 0x10, 0x9E, 0x0B, 0x40, 0x7D, 0x03,
  0x77, 0x10, 0xAE, 0x09, 0x40, 0xBD, 0x06, 0x77, 0x10, 0xBE, 0x07, 0x40, 0xDD, 0x0A, 0x77, 0x10,
  0xEE, 0x03, 0x40, 0xED, 0x0E, 0x77, 0x03, 0xE0, 0xD5, 0x0C, 0xE0, 0x67, 0x60, 0x9E, 0x07, 0x50,
  0xAE, 0x0D, 0x75, 0x04, 0xE0, 0xE0, 0x15, 0x05, 0xF0, 0x97, 0x30, 0x30, 0xEE, 0x05, 0x70, 0xDF,
  0x0B, 0x02, 0x60, 0x10, 0x7F, 0x09, 0x71, 0x04, 0xFA, 0x85, 0xB8, 0x76, 0x8B, 0xEF, 0x0B, 0x73,
  0x06, 0xFF, 0xF0, 0x97, 0x50, 0x50, 0xEF, 0xFB, 0x0D, 0x04, 0x77, 0x81, 0x18, 0xEF, 0xE0, 0xC0,
  0x67, 0x75, 0x83, 0x48, 0xBD, 0xEA, 0x84, 0xED, 0xB9, 0x61, 0x77,
  // "t" (U+0074)
  0x77, 0x10, 0xEA, 0x0E, 0x77, 0x70, 0x6B, 0x0B, 0x77, 0x70, 0xDB, 0x07, 0x77, 0x60, 0x5C, 0x04,
  0x77, 0x60, 0xDC, 0x01, 0x77, 0x50, 0x8C, 0x0D, 0x77, 0x50, 0x3D, 0x0A, 0x77, 0x40, 0x10, 0xDD,
  0x06, 0x77, 0x40, 0xBE, 0x03, 0x77, 0x20, 0x10, 0xCF, 0x77, 0x20, 0x40, 0xEF, 0x0C, 0x77, 0x03,
  0x0B, 0xFF, 0xC0, 0xB2, 0x81, 0x6B, 0xEF, 0xFE, 0x07, 0x20, 0xEF, 0xFF, 0x98, 0x14, 0x03, 0xFF,
  0xFA, 0x20, 0x28, 0x01, 0x60, 0xCF, 0x0A, 0x80, 0x46, 0x05, 0x71, 0x0C, 0xF0, 0x47, 0x73, 0xF9,
  0x01, 0x77, 0x20, 0x3F, 0x0D, 0x77, 0x30, 0x6F, 0x0A, 0x77, 0x30, 0x9F, 0x07, 0x77, 0x30, 0xDF,
  0x04, 0x77, 0x20, 0x1F, 0x90, 0x17, 0x72, 0x04, 0xF0, 0xD7, 0x73, 0x07, 0xF0, 0xA7, 0x73, 0x0A,
  0xF0, 0x67, 0x73, 0x0D, 0xF0, 0x37, 0x72, 0x01, 0xF9, 0x77, 0x30, 0x4F, 0x0C, 0x77, 0x30, 0x8F,
  0x09, 0x77, 0x30, 0xBF, 0x06, 0x77, 0x30, 0xEF, 0x03, 0x77, 0x20, 0x2F, 0x97, 0x73, 0x05, 0xF0,
  0xC7, 0x73, 0x08, 0xF0, 0x97, 0x73, 0x0B, 0xF0, 0x67, 0x73, 0x0E, 0xF0, 0x27, 0x72, 0x02, 0xF9,
  0x77, 0x30, 0x6F, 0x0C, 0x77, 0x30, 0x9F, 0x08, 0x77, 0x30, 0xCF, 0x05, 0x77, 0x3F, 0x90, 0x27,
  0x72, 0x03, 0xF0, 0xE7, 0x73, 0x06, 0xF0, 0xC7, 0x73, 0x09, 0xF0, 0x97, 0x73, 0x0B, 0xF0, 0x67,
  0x73, 0x0D, 0xF0, 0x37, 0x73, 0xF9, 0x01, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0x30, 0x2F, 0x0D, 0x77,
  0x30, 0x3F, 0x0D, 0x77, 0x30, 0x2F, 0x0E, 0x77, 0x30, 0x1F, 0x90, 0x27, 0x73, 0x0E, 0xF0, 0xA7,
  0x81, 0x29, 0x47, 0x0A, 0xF9, 0x85, 0x92, 0x01, 0x26, 0xBA, 0x0A, 0x70, 0x4F, 0xFC, 0x01, 0x70,
  0xBF, 0xFA, 0x0C, 0x01, 0x70, 0x10, 0xDF, 0xE0, 0xE0, 0x67, 0x30, 0x10, 0xBF, 0xB0, 0xD0, 0x67,
  0x78, 0x90, 0x49, 0xDE, 0xFE, 0xDB, 0x73, 0x74,
  // "u" (U+0075)
  0x10, 0x8F, 0xF0, 0x77, 0x70, 0x4F, 0x0D, 0x30, 0xCF, 0xF0, 0x47, 0x70, 0x7F, 0x0A, 0x3F, 0xF9,
  0x77, 0x10, 0xBF, 0x07, 0x20, 0x3F, 0xF0, 0xC7, 0x71, 0x0E, 0xF0, 0x35, 0x81, 0x37, 0xEF, 0xA0,
  0x97, 0x70, 0x2F, 0x97, 0x10, 0x20, 0xEF, 0x90, 0x67, 0x70, 0x5F, 0x0C, 0x72, 0x08, 0xF9, 0x02,
  0x77, 0x08, 0xF0, 0x97, 0x20, 0x6F, 0x0E, 0x77, 0x10, 0xCF, 0x06, 0x72, 0x06, 0xF0, 0xB7, 0x71,
  0xF9, 0x02, 0x72, 0x08, 0xF0, 0x87, 0x70, 0x3F, 0x0E, 0x73, 0x0A, 0xF0, 0x47, 0x70, 0x6F, 0x0B,
  0x73, 0x0D, 0xF0, 0x17, 0x70, 0x9F, 0x08, 0x72, 0x01, 0xF0, 0xD7, 0x71, 0x0D, 0xF0, 0x47, 0x20,
  0x4F, 0x0A, 0x77, 0x01, 0xF9, 0x01, 0x72, 0x07, 0xF0, 0x77, 0x70, 0x4F, 0x0D, 0x73, 0x0B, 0xF0,
  0x37, 0x70, 0x7F, 0x0A, 0x73, 0x0E, 0xF7, 0x71, 0x0A, 0xF0, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x10,
  0xEF, 0x03, 0x72, 0x06, 0xF0, 0x97, 0x70, 0x1F, 0x97, 0x30, 0x9F, 0x05, 0x77, 0x05, 0xF0, 0xC7,
  0x30, 0xDF, 0x02, 0x77, 0x08, 0xF0, 0x97, 0x20, 0x1F, 0x0E, 0x77, 0x10, 0xBF, 0x05, 0x72, 0x04,
  0xF0, 0xB7, 0x71, 0x0E, 0xF0, 0x27, 0x20, 0x7F, 0x07, 0x77, 0x04, 0xF0, 0xE7, 0x30, 0xBF, 0x04,
  0x77, 0x08, 0xF0, 0xB7, 0x30, 0xEF, 0x01, 0x77, 0x0C, 0xF0, 0x87, 0x20, 0x2F, 0x0D, 0x77, 0x02,
  0xF9, 0x04, 0x72, 0x06, 0xF0, 0x97, 0x70, 0x8F, 0x90, 0x17, 0x20, 0x9F, 0x06, 0x77, 0x0D, 0xF0,
  0xD7, 0x30, 0xDF, 0x02, 0x76, 0x04, 0xF9, 0x0A, 0x72, 0x01, 0xF0, 0xE7, 0x70, 0xBF, 0x90, 0x77,
  0x20, 0x4F, 0x0C, 0x76, 0x03, 0xFA, 0x04, 0x72, 0x07, 0xF0, 0x87, 0x60, 0xBF, 0xA0, 0x17, 0x20,
  0xAF, 0x06, 0x75, 0x04, 0xFA, 0x0E, 0x73, 0x0D, 0xF0, 0x37, 0x50, 0xDF, 0xA0, 0xC7, 0x3F, 0x90,
  0x17, 0x40, 0x7F, 0xB0, 0xA7, 0x20, 0x3F, 0x97, 0x40, 0x20, 0xEA, 0x0D, 0xF0, 0x87, 0x20, 0x4F,
  0x97, 0x40, 0xCA, 0x07, 0x09, 0xF0, 0x77, 0x20, 0x5F, 0x97, 0x30, 0x9A, 0x81, 0xC0, 0xAF, 0x07,
  0x72, 0x06, 0xF9, 0x01, 0x71, 0x08, 0xB8, 0x13, 0x0C, 0xF0, 0x77, 0x20, 0x5F, 0x90, 0x57, 0x08,
  0xB0, 0x62, 0x0C, 0xF0, 0x87, 0x20, 0x4F, 0x90, 0xB5, 0x01, 0x0A, 0xB0, 0xA3, 0x0C, 0xF0, 0xD5,
  0x83, 0x1A, 0x10, 0x1F, 0xA8, 0x49, 0x10, 0x27, 0xEB, 0x0D, 0x40, 0xBF, 0x90, 0x82, 0x03, 0x09,
  0xA0, 0x82, 0x0D, 0xFF, 0xA0, 0xE0, 0x24, 0x08, 0xFF, 0xA8, 0x11, 0x07, 0xFF, 0x90, 0xE0, 0x35,
  0x03, 0xFF, 0x90, 0x62, 0x01, 0x0E, 0xFE, 0x0E, 0x04, 0x70, 0xCF, 0xD0, 0xE0, 0x54, 0x06, 0xFD,
  0x0D, 0x03, 0x71, 0x03, 0xFC, 0x0C, 0x02, 0x60, 0x7F, 0xB0, 0x80, 0x17, 0x30, 0x5F, 0x90, 0xE0,
  0x77, 0x28, 0x90, 0x28, 0xCE, 0xFE, 0xDA, 0x61, 0x76, 0x87, 0x29, 0xDE, 0xFD, 0xB6, 0x16,
  // "v" (U+0076)
  0x77, 0x77, 0x38, 0x43, 0xBE, 0xEB, 0x33, 0x09, 0xFC, 0x0B, 0x77, 0x20, 0x6E, 0x04, 0x20, 0xCF,
  0xC0, 0xC7, 0x71, 0x03, 0xF0, 0xE0, 0x11, 0xFD, 0x0E, 0x77, 0x10, 0xBF, 0x90, 0x60, 0x3F, 0xE7,
  0x70, 0x1F, 0xA0, 0xB2, 0x81, 0x14, 0xBF, 0xA0, 0x27, 0x60, 0x5F, 0xA0, 0xD5, 0x07, 0xF9, 0x03,
  0x76, 0x07, 0xFB, 0x60, 0xDF, 0x05, 0x76, 0x81, 0x49, 0xEF, 0x96, 0x08, 0xF0, 0x77, 0x71, 0x01,
  0x0C, 0xF6, 0x04, 0xF0, 0x87, 0x72, 0x01, 0x0E, 0xE6, 0x03, 0xF0, 0xA7, 0x73, 0x08, 0xD0, 0xE6,
  0x01, 0xF0, 0xC7, 0x73, 0x03, 0xD0, 0xC7, 0xF0, 0xD7, 0x73, 0x01, 0xD0, 0xA7, 0x0D, 0xF7, 0x74,
  0xD0, 0x77, 0x0C, 0xF0, 0x17, 0x73, 0xD0, 0x47, 0x0A, 0xF0, 0x37, 0x72, 0x01, 0xD0, 0x17, 0x08,
  0xF0, 0x57, 0x72, 0x03, 0xC0, 0xC7, 0x10, 0x7F, 0x06, 0x77, 0x20, 0x6C, 0x08, 0x71, 0x05, 0xF0,
  0x87, 0x72, 0x09, 0xC0, 0x37, 0x10, 0x3F, 0x0A, 0x77, 0x20, 0xDB, 0x0D, 0x72, 0x02, 0xF0, 0xB7,
  0x71, 0x02, 0xC0, 0x77, 0x3F, 0x0D, 0x77, 0x10, 0x8C, 0x01, 0x73, 0x0E, 0xF7, 0x71, 0x0D, 0xB0,
  0xB7, 0x40, 0xDF, 0x01, 0x76, 0x04, 0xC0, 0x47, 0x40, 0xBF, 0x02, 0x76, 0x0A, 0xB0, 0xD7, 0x50,
  0x9F, 0x04, 0x75, 0x01, 0xC0, 0x67, 0x50, 0x8F, 0x06, 0x75, 0x08, 0xB0, 0xD7, 0x60, 0x6F, 0x07,
  0x74, 0x01, 0x0E, 0xB0, 0x67, 0x60, 0x5F, 0x09, 0x74, 0x07, 0xB0, 0xD7, 0x70, 0x3F, 0x0A, 0x73,
  0x01, 0x0E, 0xB0, 0x57, 0x70, 0x1F, 0x0B, 0x73, 0x09, 0xB0, 0xC7, 0x72, 0xF0, 0xD7, 0x20, 0x2C,
  0x03, 0x77, 0x20, 0xEE, 0x0E, 0x72, 0x0A, 0xB0, 0x97, 0x73, 0x0C, 0xF7, 0x10, 0x4B, 0x0E, 0x01,
  0x77, 0x30, 0xAF, 0x01, 0x70, 0xDB, 0x05, 0x77, 0x40, 0x9F, 0x02, 0x60, 0x8B, 0x0B, 0x77, 0x50,
  0x7F, 0x04, 0x50, 0x3C, 0x02, 0x77, 0x50, 0x6F, 0x05, 0x50, 0xDB, 0x07, 0x77, 0x60, 0x4F, 0x06,
  0x40, 0x9B, 0x0B, 0x77, 0x70, 0x2F, 0x07, 0x30, 0x5B, 0x0E, 0x02, 0x77, 0x70, 0x1F, 0x07, 0x20,
  0x20, 0xEB, 0x06, 0x77, 0x72, 0xF8, 0x28, 0x01, 0xDB, 0x0A, 0x77, 0x73, 0x0D, 0xE8, 0x19, 0x0B,
  0xB0, 0xD0, 0x17, 0x77, 0x30, 0xBE, 0x0A, 0x09, 0xC0, 0x37, 0x77, 0x40, 0xAF, 0xC0, 0x77, 0x77,
  0x50, 0x8F, 0xB0, 0xA7, 0x77, 0x60, 0x7F, 0xA0, 0xD7, 0x77, 0x70, 0x5F, 0x90, 0xE0, 0x27, 0x77,
  0x70, 0x3F, 0x90, 0x47, 0x77, 0x71, 0x02, 0xB8, 0x3E, 0xCB, 0x94, 0x77, 0x77, 0x38, 0x15, 0x31,
  0x77, 0x74,
  // "w" (U+0077)
  0x80, 0xE1, 0x08, 0x35, 0xCF, 0xE9, 0x30, 0xBF, 0xC0, 0x97, 0x72, 0x01, 0xF7, 0x70, 0x7D, 0x0B,
  0x2F, 0xD0, 0x97, 0x72, 0x07, 0xF0, 0x17, 0x50, 0x3F, 0x00, 0x4F, 0xD0, 0x97, 0x72, 0x0D, 0xF0,
  0x27, 0x50, 0xAF, 0x09, 0x08, 0xFD, 0x09, 0x77, 0x10, 0x3F, 0x90, 0x37, 0x5F, 0x90, 0xC2, 0x02,
  0x08, 0xFA, 0x08, 0x77, 0x10, 0x9F, 0x90, 0x37, 0x40, 0x10, 0xEF, 0x0D, 0x40, 0x3F, 0x90, 0x87,
  0x71, 0x0E, 0xF9, 0x03, 0x76, 0x08, 0xE0, 0xD5, 0x0A, 0xF0, 0x87, 0x70, 0x6F, 0xA0, 0x47, 0x70,
  0xBD, 0x0C, 0x50, 0x5F, 0x08, 0x77, 0x0C, 0xFA, 0x04, 0x77, 0x04, 0xD0, 0xB5, 0x03, 0xF0, 0x87,
  0x60, 0x3F, 0xB0, 0x57, 0x70, 0x1D, 0x09, 0x50, 0x2F, 0x07, 0x76, 0x09, 0xFB, 0x05, 0x77, 0x1D,
  0x07, 0x50, 0x1F, 0x07, 0x76, 0x0E, 0xB0, 0xEE, 0x05, 0x77, 0x1D, 0x04, 0x50, 0x1F, 0x07, 0x75,
  0x06, 0xB0, 0xC0, 0xBE, 0x05, 0x77, 0x01, 0xD0, 0x15, 0x02, 0xF0, 0x77, 0x50, 0xCB, 0x06, 0x0B,
  0xE0, 0x67, 0x70, 0x3C, 0x0B, 0x60, 0x2F, 0x07, 0x74, 0x04, 0xB8, 0x1E, 0x1B, 0xE0, 0x67, 0x70,
  0x7C, 0x07, 0x60, 0x2F, 0x06, 0x74, 0x0A, 0xB8, 0x19, 0x0B, 0xE0, 0x67, 0x70, 0xAC, 0x02, 0x60,
  0x2F, 0x06, 0x73, 0x01, 0xC8, 0x12, 0x0B, 0xE0, 0x77, 0x70, 0xEB, 0x0B, 0x70, 0x3F, 0x06, 0x73,
  0x08, 0xB0, 0xB2, 0x0B, 0xE0, 0x77, 0x60, 0x4C, 0x06, 0x70, 0x3F, 0x05, 0x73, 0x0E, 0xB0, 0x42,
  0x0B, 0xE0, 0x77, 0x60, 0xAB, 0x0E, 0x71, 0x03, 0xF0, 0x57, 0x20, 0x5B, 0x0D, 0x30, 0xBE, 0x07,
  0x75, 0x01, 0xC0, 0x87, 0x10, 0x3F, 0x05, 0x72, 0x0C, 0xB0, 0x63, 0x0B, 0xE0, 0x77, 0x50, 0x6C,
  0x01, 0x71, 0x04, 0xF0, 0x57, 0x10, 0x3B, 0x0E, 0x40, 0xBE, 0x07, 0x75, 0x0C, 0xB0, 0x97, 0x20,
  0x4F, 0x04, 0x71, 0x0A, 0xB0, 0x74, 0x0B, 0xE0, 0x87, 0x40, 0x3C, 0x02, 0x72, 0x04, 0xF0, 0x47,
  0x01, 0xB0, 0xE0, 0x14, 0x0B, 0xE0, 0x87, 0x40, 0xAB, 0x09, 0x73, 0x04, 0xF0, 0x47, 0x08, 0xB0,
  0x95, 0x0B, 0xE0, 0x87, 0x30, 0x2C, 0x02, 0x73, 0x05, 0xF0, 0x37, 0x0E, 0xB0, 0x25, 0x0B, 0xE0,
  0x87, 0x30, 0x8B, 0x09, 0x74, 0x05, 0xF0, 0x36, 0x06, 0xB0, 0xA6, 0x0B, 0xE0, 0x87, 0x20, 0x10,
  0xEA, 0x0E, 0x01, 0x74, 0x05, 0xF0, 0x36, 0x0D, 0xB0, 0x26, 0x0B, 0xE0, 0x87, 0x20, 0x9B, 0x07,
  0x75, 0x05, 0xF0, 0x35, 0x04, 0xB0, 0xB7, 0x0B, 0xE0, 0x87, 0x10, 0x1B, 0x0D, 0x76, 0x06, 0xF0,
  0x25, 0x0B, 0xB0, 0x37, 0x0B, 0xE0, 0x87, 0x10, 0x9B, 0x05, 0x76, 0x06, 0xF0, 0x24, 0x03, 0xB0,
  0xC7, 0x10, 0xBE, 0x08, 0x70, 0x2B, 0x0B, 0x77, 0x06, 0xF0, 0x14, 0x0A, 0xB0, 0x47, 0x10, 0xBE,
  0x08, 0x70, 0xAB, 0x03, 0x77, 0x06, 0xF0, 0x13, 0x02, 0xB0, 0xC7, 0x20, 0xBE, 0x08, 0x60, 0x4B,
  0x09, 0x77, 0x10, 0x7F, 0x01, 0x30, 0x8B, 0x05, 0x72, 0x0B, 0xE0, 0x86, 0x0D, 0xA0, 0xE0, 0x17,
  0x71, 0x07, 0xF3, 0x01, 0x0E, 0xA0, 0xD7, 0x30, 0xBE, 0x08, 0x50, 0x6B, 0x05, 0x77, 0x20, 0x7F,
  0x30, 0x7B, 0x06, 0x73, 0x0B, 0xE0, 0x84, 0x01, 0x0E, 0xA0, 0xB7, 0x73, 0x07, 0xF3, 0x0E, 0xA0,
  0xE7, 0x40, 0xBE, 0x08, 0x40, 0xAB, 0x02, 0x77, 0x30, 0x8E, 0x0E, 0x20, 0x6B, 0x07, 0x74, 0x0B,
  0xE0, 0x83, 0x05, 0xB0, 0x77, 0x74, 0x08, 0xE0, 0xD2, 0x0D, 0xA0, 0xE7, 0x50, 0xBE, 0x08, 0x30,
  0xDA, 0x0D, 0x77, 0x50, 0x8E, 0x81, 0xD0, 0x6B, 0x07, 0x75, 0x0B, 0xE0, 0x82, 0x09, 0xB0, 0x37,
  0x75, 0x08, 0xE8, 0x1C, 0x0D, 0xA0, 0xE7, 0x60, 0xBE, 0x81, 0x80, 0x5B, 0x09, 0x77, 0x60, 0x9E,
  0x0C, 0x06, 0xB0, 0x77, 0x60, 0xCE, 0x81, 0x71, 0xEA, 0x0E, 0x01, 0x77, 0x60, 0x9E, 0x00, 0xDA,
  0x0E, 0x01, 0x76, 0x0C, 0xE0, 0x80, 0xBB, 0x05, 0x77, 0x70, 0x9F, 0xB0, 0x77, 0x70, 0xCF, 0xB0,
  0xA7, 0x77, 0x10, 0x9F, 0xA0, 0xE0, 0x17, 0x70, 0xCF, 0xA0, 0xE0, 0x17, 0x77, 0x10, 0xAF, 0xA0,
  0x77, 0x71, 0x0C, 0xFA, 0x06, 0x77, 0x72, 0x0A, 0xF9, 0x0E, 0x77, 0x20, 0xDF, 0x90, 0xB7, 0x77,
  0x30, 0xAF, 0x90, 0x77, 0x72, 0x0D, 0xF9, 0x02, 0x77, 0x73, 0x0B, 0xF0, 0xD7, 0x73, 0x0D, 0xF0,
  0x77, 0x77, 0x48, 0x7B, 0xFE, 0xCA, 0x86, 0x41, 0x77, 0x30, 0xDA, 0x83, 0xEC, 0xA8, 0x57, 0x77,
  0x50, 0x20, 0x17, 0x77, 0x38, 0x14, 0x31, 0x77, 0x75,
  // "x" (U+0078)
  0x73, 0x07, 0xFB, 0x0D, 0x77, 0x10, 0x7F, 0xA0, 0x77, 0x30, 0xAF, 0xC0, 0x17, 0x60, 0x10, 0xEF,
  0xA0, 0x37, 0x30, 0xDF, 0xC0, 0x67, 0x60, 0xAF, 0xB7, 0x30, 0x1F, 0xD0, 0xA7, 0x50, 0x3F, 0xB0,
  0xB7, 0x60, 0x30, 0xBF, 0x90, 0xE7, 0x50, 0xCE, 0x09, 0x03, 0x77, 0x40, 0xCF, 0x90, 0x37, 0x30,
  0x6D, 0x0E, 0x04, 0x77, 0x60, 0x3F, 0x90, 0x87, 0x20, 0x10, 0xEC, 0x0E, 0x03, 0x77, 0x71, 0x0C,
  0xF0, 0xC7, 0x20, 0x8D, 0x05, 0x77, 0x72, 0x06, 0xF9, 0x01, 0x70, 0x2D, 0x08, 0x77, 0x73, 0x01,
  0xF9, 0x05, 0x70, 0xBC, 0x0B, 0x77, 0x75, 0x0A, 0xF0, 0xA6, 0x05, 0xC0, 0xE0, 0x17, 0x77, 0x50,
  0x5F, 0x0E, 0x60, 0xDC, 0x05, 0x77, 0x77, 0xF9, 0x03, 0x40, 0x7C, 0x0A, 0x77, 0x77, 0x10, 0xAF,
  0x07, 0x30, 0x10, 0xEB, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x5F, 0x0C, 0x30, 0xAC, 0x04, 0x77, 0x77,
  0x30, 0xEF, 0x81, 0x10, 0x3C, 0x08, 0x77, 0x77, 0x40, 0xAF, 0x81, 0x50, 0xCB, 0x0D, 0x77, 0x77,
  0x50, 0x5F, 0x09, 0x06, 0xC0, 0x37, 0x77, 0x76, 0x0E, 0xE0, 0x0E, 0xB0, 0x77, 0x77, 0x77, 0x0A,
  0xFB, 0x0C, 0x80, 0xC0, 0x00, 0x5F, 0xA0, 0xE0, 0x28, 0x0C, 0x10, 0x0E, 0xF9, 0x06, 0x80, 0xC2,
  0x00, 0xAF, 0x0C, 0x80, 0xC3, 0x00, 0x4F, 0x0E, 0x80, 0xC3, 0x00, 0x3F, 0x90, 0x38, 0x0C, 0x20,
  0x0C, 0xF9, 0x08, 0x80, 0xC1, 0x00, 0x9F, 0xA0, 0xD8, 0x0C, 0x00, 0x05, 0xFC, 0x03, 0x77, 0x77,
  0x60, 0x20, 0xEB, 0x0C, 0xF0, 0x87, 0x77, 0x76, 0x0C, 0xB0, 0xC0, 0x2F, 0x0D, 0x77, 0x77, 0x50,
  0x9C, 0x81, 0x20, 0xDF, 0x02, 0x77, 0x77, 0x30, 0x5C, 0x08, 0x20, 0x9F, 0x07, 0x77, 0x77, 0x20,
  0x20, 0xEB, 0x0D, 0x30, 0x4F, 0x0C, 0x77, 0x77, 0x20, 0xDC, 0x04, 0x4F, 0x90, 0x27, 0x77, 0x70,
  0x9C, 0x0A, 0x50, 0xBF, 0x07, 0x77, 0x76, 0x06, 0xC0, 0xE0, 0x15, 0x07, 0xF0, 0xC7, 0x77, 0x50,
  0x20, 0xEC, 0x06, 0x60, 0x2F, 0x90, 0x17, 0x77, 0x40, 0xDC, 0x0B, 0x71, 0x0D, 0xF0, 0x67, 0x77,
  0x30, 0xAD, 0x02, 0x71, 0x09, 0xF0, 0xB7, 0x77, 0x20, 0x7D, 0x08, 0x72, 0x05, 0xF9, 0x01, 0x77,
  0x70, 0x5D, 0x0D, 0x74, 0xF9, 0x07, 0x77, 0x60, 0x4E, 0x04, 0x74, 0x0B, 0xF0, 0xD7, 0x75, 0x05,
  0xE0, 0x97, 0x50, 0x7F, 0x90, 0x87, 0x71, 0x81, 0x14, 0xBE, 0x0E, 0x01, 0x75, 0x02, 0xFA, 0x09,
  0x03, 0x74, 0x0A, 0xFB, 0x05, 0x77, 0x0D, 0xFC, 0x0E, 0x72, 0x0D, 0xFA, 0x0B, 0x77, 0x10, 0x9F,
  0xC0, 0xB7, 0x10, 0x1F, 0xB0, 0x27, 0x71, 0x05, 0xFC, 0x08, 0x71, 0x05, 0xFA, 0x07, 0x77, 0x20,
  0x1F, 0xC0, 0x57, 0x10,
  // "y" (U+0079)
  0x80, 0xD1, 0x08, 0x51, 0x9D, 0xFD, 0x81, 0x77, 0x30, 0xBF, 0xC0, 0x57, 0x72, 0x03, 0x0E, 0xD0,
  0xD0, 0x17, 0x72, 0x0E, 0xFC, 0x08, 0x77, 0x20, 0xDF, 0x0B, 0x77, 0x10, 0x2F, 0xD0, 0xB7, 0x71,
  0x07, 0xFA, 0x02, 0x77, 0x05, 0xFD, 0x0E, 0x77, 0x10, 0xBF, 0xA0, 0x67, 0x72, 0x81, 0x15, 0xCF,
  0xA0, 0x27, 0x70, 0xEF, 0xA0, 0x97, 0x75, 0x0C, 0xF9, 0x05, 0x77, 0x0A, 0x0D, 0xF9, 0x0A, 0x77,
  0x50, 0x3F, 0x90, 0x87, 0x72, 0x09, 0xF0, 0xA7, 0x76, 0x0C, 0xF0, 0xC7, 0x73, 0x0D, 0xE0, 0x97,
  0x76, 0x08, 0xF9, 0x77, 0x30, 0x7E, 0x08, 0x77, 0x60, 0x4F, 0x90, 0x37, 0x72, 0x04, 0xE0, 0x77,
  0x76, 0x01, 0xF9, 0x06, 0x77, 0x20, 0x2E, 0x04, 0x77, 0x70, 0xCF, 0x09, 0x77, 0x20, 0x3E, 0x02,
  0x77, 0x70, 0x9F, 0x0C, 0x77, 0x20, 0x3D, 0x0E, 0x77, 0x71, 0x06, 0xF9, 0x77, 0x20, 0x5D, 0x0B,
  0x77, 0x71, 0x02, 0xF9, 0x03, 0x77, 0x10, 0x7D, 0x07, 0x77, 0x72, 0x0E, 0xF0, 0x67, 0x71, 0x0B,
  0xD0, 0x37, 0x77, 0x20, 0xBF, 0x0A, 0x77, 0x10, 0xEC, 0x0D, 0x77, 0x73, 0x07, 0xF0, 0xD7, 0x70,
  0x2D, 0x08, 0x77, 0x73, 0x04, 0xF9, 0x01, 0x76, 0x07, 0xD0, 0x37, 0x77, 0x4F, 0x90, 0x47, 0x60,
  0xBC, 0x0D, 0x77, 0x75, 0x0C, 0xF0, 0x77, 0x50, 0x1D, 0x07, 0x77, 0x75, 0x09, 0xF0, 0xA7, 0x50,
  0x6D, 0x01, 0x77, 0x75, 0x05, 0xF0, 0xE7, 0x50, 0xCC, 0x09, 0x77, 0x76, 0x02, 0xF9, 0x01, 0x73,
  0x02, 0xD0, 0x27, 0x77, 0x70, 0xEF, 0x05, 0x73, 0x09, 0xC0, 0xB7, 0x77, 0x71, 0x0B, 0xF0, 0x87,
  0x30, 0xEC, 0x03, 0x77, 0x77, 0x10, 0x7F, 0x0B, 0x72, 0x06, 0xC0, 0xC7, 0x77, 0x72, 0x04, 0xF0,
  0xE7, 0x20, 0xDC, 0x05, 0x77, 0x77, 0x3F, 0x90, 0x27, 0x05, 0xC0, 0xC7, 0x77, 0x74, 0x0C, 0xF0,
  0x57, 0x0C, 0xC0, 0x57, 0x77, 0x74, 0x09, 0xF0, 0x86, 0x04, 0xC0, 0xC7, 0x77, 0x75, 0x05, 0xF0,
  0xB6, 0x0C, 0xC0, 0x57, 0x77, 0x75, 0x02, 0xF0, 0xD5, 0x04, 0xC0, 0xC7, 0x77, 0x77, 0x0E, 0xF0,
  0x14, 0x0C, 0xC0, 0x47, 0x77, 0x77, 0x0B, 0xF0, 0x33, 0x05, 0xC0, 0xB8, 0x0C, 0x00, 0x07, 0xF0,
  0x63, 0x0C, 0xC0, 0x38, 0x0C, 0x00, 0x04, 0xF0, 0x92, 0x06, 0xC0, 0xA8, 0x0C, 0x20, 0xF0, 0xB2,
  0x0E, 0xC0, 0x28, 0x0C, 0x20, 0x0C, 0xE8, 0x1E, 0x08, 0xC0, 0x88, 0x0C, 0x30, 0x09, 0xF0, 0x20,
  0xEB, 0x0E, 0x80, 0xC4, 0x00, 0x5F, 0x0C, 0xC0, 0x68, 0x0C, 0x40, 0x02, 0xFC, 0x0C, 0x80, 0xC6,
  0x00, 0xEF, 0xB0, 0x38, 0x0C, 0x60, 0x0B, 0xFA, 0x0A, 0x80, 0xC7, 0x00, 0x7F, 0x90, 0xE0, 0x18,
  0x0C, 0x70, 0x04, 0xF9, 0x06, 0x80, 0xD1, 0x0F, 0x0C, 0x80, 0xD2, 0x00, 0xCE, 0x03, 0x80, 0xD2,
  0x00, 0x9D, 0x09, 0x80, 0xD2, 0x00, 0x10, 0xEC, 0x0E, 0x01, 0x80, 0xD2, 0x00, 0xBD, 0x05, 0x80,
  0xD2, 0x00, 0x7D, 0x0A, 0x80, 0xD2, 0x00, 0x4D, 0x0E, 0x01, 0x80, 0xD1, 0x00, 0x10, 0xED, 0x06,
  0x80, 0xD2, 0x00, 0xCD, 0x0B, 0x80, 0xD2, 0x00, 0xAD, 0x0E, 0x02, 0x80, 0xD1, 0x00, 0x8E, 0x05,
  0x80, 0xD1, 0x00, 0x8E, 0x0A, 0x80, 0xD1, 0x00, 0x8E, 0x0D, 0x80, 0xD1, 0x00, 0x9E, 0x0E, 0x02,
  0x80, 0xC7, 0x00, 0x10, 0xBF, 0x04, 0x80, 0xC7, 0x00, 0x40, 0xEF, 0x06, 0x80, 0xC6, 0x00, 0x20,
  0xAF, 0x90, 0x78, 0x0C, 0x50, 0x02, 0x08, 0xFA, 0x07, 0x77, 0x77, 0x28, 0x2B, 0x84, 0x24, 0x82,
  0x24, 0x7C, 0xFB, 0x05, 0x77, 0x77, 0x20, 0x3F, 0xFE, 0x0D, 0x03, 0x77, 0x77, 0x30, 0x7F, 0xFD,
  0x08, 0x77, 0x77, 0x50, 0xCF, 0xFB, 0x0A, 0x02, 0x77, 0x77, 0x60, 0xAF, 0xF8, 0x1D, 0x71, 0x80,
  0xC1, 0x08, 0x31, 0x59, 0xCE, 0xA8, 0x5E, 0xED, 0xB8, 0x52, 0x80, 0xC3, 0x00,
  // "z" (U+007A)
  0x73, 0x02, 0xFF, 0xFE, 0x0C, 0x73, 0x06, 0xFF, 0xFE, 0x08, 0x73, 0x0B, 0xFF, 0xFE, 0x05, 0x73,
  0xFF, 0xFF, 0x02, 0x72, 0x04, 0xE0, 0xB0, 0x78, 0x06, 0x60, 0xDF, 0x90, 0x87, 0x30, 0x8C, 0x0D,
  0x03, 0x74, 0x05, 0xF9, 0x0C, 0x74, 0x0D, 0xB0, 0xE0, 0x27, 0x40, 0x10, 0xEF, 0x90, 0x27, 0x30,
  0x2C, 0x06, 0x75, 0x0A, 0xF9, 0x07, 0x74, 0x06, 0xB0, 0xC7, 0x50, 0x6F, 0x90, 0xB7, 0x50, 0xBB,
  0x04, 0x74, 0x02, 0x0E, 0xF0, 0xE0, 0x17, 0x50, 0xEA, 0x0C, 0x75, 0x0B, 0xF9, 0x05, 0x75, 0x04,
  0xB0, 0x47, 0x40, 0x7F, 0x90, 0xA7, 0x60, 0x30, 0xF6, 0x74, 0x02, 0xF9, 0x0D, 0x01, 0x77, 0x77,
  0x0C, 0xF9, 0x04, 0x77, 0x77, 0x08, 0xF9, 0x09, 0x77, 0x77, 0x03, 0xF9, 0x0D, 0x77, 0x77, 0x10,
  0xDF, 0x90, 0x37, 0x77, 0x70, 0x9F, 0x90, 0x77, 0x77, 0x70, 0x4F, 0x90, 0xC7, 0x77, 0x70, 0x10,
  0xEF, 0x0E, 0x02, 0x77, 0x77, 0x0A, 0xF9, 0x06, 0x77, 0x77, 0x06, 0xF9, 0x0B, 0x77, 0x77, 0x02,
  0x0E, 0xF0, 0xE0, 0x17, 0x77, 0x70, 0xBF, 0x90, 0x57, 0x77, 0x70, 0x7F, 0x90, 0x97, 0x77, 0x70,
  0x2F, 0x90, 0xD7, 0x77, 0x71, 0x0C, 0xF9, 0x03, 0x77, 0x77, 0x08, 0xF9, 0x08, 0x77, 0x77, 0x03,
  0xF9, 0x0C, 0x77, 0x77, 0x10, 0xDF, 0x90, 0x27, 0x77, 0x70, 0x9F, 0x90, 0x77, 0x77, 0x70, 0x4F,
  0x90, 0xB7, 0x77, 0x70, 0x10, 0xEF, 0x0E, 0x01, 0x77, 0x77, 0x0A, 0xF9, 0x05, 0x77, 0x0F, 0x27,
  0x40, 0x5F, 0x90, 0xA7, 0x70, 0x8B, 0x73, 0x01, 0x0E, 0xF0, 0xD0, 0x17, 0x70, 0xEA, 0x0C, 0x73,
  0x0B, 0xF9, 0x04, 0x77, 0x05, 0xB0, 0x87, 0x20, 0x7F, 0x90, 0x97, 0x71, 0x0C, 0xB0, 0x47, 0x10,
  0x2F, 0x90, 0xD7, 0x71, 0x03, 0xC7, 0x20, 0xCF, 0x90, 0x37, 0x71, 0x0B, 0xB0, 0xC7, 0x10, 0x8F,
  0x90, 0x77, 0x71, 0x04, 0xC0, 0x87, 0x03, 0xF9, 0x0C, 0x77, 0x20, 0xDC, 0x04, 0x70, 0xDF, 0x0E,
  0x02, 0x77, 0x01, 0x0B, 0xD7, 0x09, 0xF9, 0x0B, 0x80, 0x91, 0x68, 0x17, 0x9E, 0xD0, 0xC6, 0x03,
  0xFF, 0xFF, 0xB0, 0x86, 0x07, 0xFF, 0xFF, 0xB0, 0x46, 0x0A, 0xFF, 0xFF, 0xB0, 0x16, 0x0D, 0xFF,
  0xFF, 0xA0, 0xC7,
  // "{" (U+007B)
  0x77, 0x73, 0x84, 0x37, 0xAC, 0xDE, 0xD0, 0x17, 0x77, 0x10, 0x60, 0xDF, 0xB0, 0xD7, 0x77, 0x01,
  0x0C, 0xFD, 0x0A, 0x77, 0x60, 0x20, 0xEF, 0xE0, 0x67, 0x76, 0x0D, 0xF9, 0x81, 0xC6, 0x27, 0x77,
  0x20, 0x9F, 0x90, 0x87, 0x77, 0x40, 0x2F, 0x90, 0x87, 0x77, 0x50, 0xAF, 0x0D, 0x77, 0x75, 0x01,
  0xF9, 0x05, 0x77, 0x75, 0x07, 0xF0, 0xD7, 0x77, 0x60, 0xCF, 0x08, 0x77, 0x75, 0x01, 0xF9, 0x02,
  0x77, 0x75, 0x05, 0xF0, 0xE7, 0x77, 0x60, 0x9F, 0x0A, 0x77, 0x76, 0x0C, 0xF0, 0x67, 0x77, 0x6F,
  0x90, 0x37, 0x77, 0x50, 0x4F, 0x97, 0x77, 0x60, 0x7F, 0x0C, 0x77, 0x76, 0x0B, 0xF0, 0x97, 0x77,
  0x60, 0xEF, 0x05, 0x77, 0x75, 0x02, 0xF9, 0x02, 0x77, 0x75, 0x05, 0xF0, 0xE7, 0x77, 0x60, 0x9F,
  0x0B, 0x77, 0x76, 0x0C, 0xF0, 0x87, 0x77, 0x6F, 0x90, 0x47, 0x77, 0x50, 0x4F, 0x90, 0x17, 0x77,
  0x50, 0x7F, 0x0D, 0x77, 0x76, 0x0B, 0xF0, 0xA7, 0x77, 0x60, 0xEF, 0x07, 0x77, 0x75, 0x03, 0xF9,
  0x03, 0x77, 0x75, 0x07, 0xF0, 0xE7, 0x77, 0x60, 0xBF, 0x09, 0x77, 0x75, 0x02, 0xF9, 0x03, 0x77,
  0x75, 0x0A, 0xF0, 0xB7, 0x77, 0x50, 0x5F, 0x90, 0x27, 0x77, 0x40, 0x50, 0xEF, 0x05, 0x77, 0x73,
  0x02, 0x09, 0xF9, 0x07, 0x77, 0x78, 0x21, 0x36, 0xBF, 0x90, 0xE0, 0x57, 0x76, 0x01, 0xFD, 0x0A,
  0x01, 0x77, 0x70, 0x4F, 0xA8, 0x1B, 0x71, 0x77, 0x72, 0x07, 0xF9, 0x81, 0xC6, 0x17, 0x77, 0x30,
  0xAF, 0xC0, 0x97, 0x77, 0x38, 0x21, 0x37, 0xCF, 0x90, 0xD0, 0x17, 0x77, 0x50, 0x6F, 0x90, 0xB7,
  0x77, 0x60, 0x6F, 0x90, 0x57, 0x77, 0x60, 0xDF, 0x0A, 0x77, 0x76, 0x09, 0xF0, 0xE7, 0x77, 0x60,
  0x7F, 0x97, 0x77, 0x60, 0x6F, 0x97, 0x77, 0x60, 0x7F, 0x0E, 0x77, 0x76, 0x09, 0xF0, 0xC7, 0x77,
  0x60, 0xBF, 0x09, 0x77, 0x76, 0x0E, 0xF0, 0x57, 0x77, 0x50, 0x2F, 0x90, 0x27, 0x77, 0x50, 0x5F,
  0x0E, 0x77, 0x76, 0x09, 0xF0, 0xB7, 0x77, 0x60, 0xCF, 0x08, 0x77, 0x76, 0xF9, 0x04, 0x77, 0x75,
  0x03, 0xF9, 0x01, 0x77, 0x75, 0x06, 0xF0, 0xD7, 0x77, 0x60, 0x9F, 0x0A, 0x77, 0x76, 0x0C, 0xF0,
  0x77, 0x77, 0x6F, 0x90, 0x37, 0x77, 0x50, 0x3F, 0x97, 0x77, 0x60, 0x6F, 0x0C, 0x77, 0x76, 0x09,
  0xF0, 0x97, 0x77, 0x60, 0xDF, 0x06, 0x77, 0x75, 0x01, 0xF9, 0x03, 0x77, 0x75, 0x03, 0xF9, 0x77,
  0x76, 0x05, 0xF0, 0xE7, 0x77, 0x60, 0x6F, 0x0D, 0x77, 0x76, 0x06, 0xF0, 0xD7, 0x77, 0x60, 0x5F,
  0x97, 0x77, 0x60, 0x3F, 0x90, 0x57, 0x77, 0x60, 0xEF, 0x0D, 0x01, 0x77, 0x75, 0x08, 0xF9, 0x81,
  0xD5, 0x17, 0x77, 0x30, 0x10, 0xEF, 0xD0, 0xE7, 0x77, 0x10, 0x30, 0xEF, 0xC0, 0xB7, 0x77, 0x20,
  0x20, 0xBF, 0xB0, 0x87, 0x77, 0x48, 0x23, 0x8B, 0xDE, 0x04, 0x77, 0x30,
  // "|" (U+007C)
  0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07,
  0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0,
  0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60,
  0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C,
  0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06,
  0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07,
  0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0,
  0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60,
  0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C,
  0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06,
  0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07,
  0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0,
  0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60,
  0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C,
  0x06,
  // "}" (U+007D)
  0x77, 0x30, 0x6E, 0x82, 0xDC, 0x83, 0x77, 0x74, 0x09, 0xFB, 0x0B, 0x01, 0x77, 0x72, 0x0C, 0xFC,
  0x0D, 0x01, 0x77, 0x71, 0xFE, 0x0B, 0x77, 0x74, 0x81, 0x15, 0xDF, 0x90, 0x57, 0x77, 0x50, 0x10,
  0xDF, 0x0C, 0x77, 0x76, 0x05, 0xF9, 0x01, 0x77, 0x75, 0x01, 0xF9, 0x03, 0x77, 0x76, 0x0E, 0xF0,
  0x57, 0x77, 0x60, 0xEF, 0x04, 0x77, 0x76, 0xF9, 0x03, 0x77, 0x75, 0x01, 0xF9, 0x01, 0x77, 0x75,
  0x03, 0xF0, 0xE7, 0x77, 0x60, 0x5F, 0x0B, 0x77, 0x76, 0x09, 0xF0, 0x87, 0x77, 0x60, 0xCF, 0x05,
  0x77, 0x76, 0xF9, 0x02, 0x77, 0x75, 0x04, 0xF0, 0xE7, 0x77, 0x60, 0x7F, 0x0B, 0x77, 0x76, 0x0B,
  0xF0, 0x87, 0x77, 0x60, 0xEF, 0x05, 0x77, 0x75, 0x02, 0xF9, 0x01, 0x77, 0x75, 0x05, 0xF0, 0xE7,
  0x77, 0x60, 0x9F, 0x0B, 0x77, 0x76, 0x0C, 0xF0, 0x77, 0x77, 0x6F, 0x90, 0x47, 0x77, 0x50, 0x4F,
  0x90, 0x17, 0x77, 0x50, 0x7F, 0x0D, 0x77, 0x76, 0x0B, 0xF0, 0xA7, 0x77, 0x60, 0xDF, 0x07, 0x77,
  0x76, 0xF9, 0x05, 0x77, 0x75, 0x01, 0xF9, 0x03, 0x77, 0x75, 0x01, 0xF9, 0x04, 0x77, 0x76, 0xF9,
  0x06, 0x77, 0x76, 0x0C, 0xF0, 0xA7, 0x77, 0x60, 0x7F, 0x90, 0x37, 0x77, 0x60, 0xDF, 0x0E, 0x04,
  0x77, 0x75, 0x02, 0x0E, 0xF9, 0x82, 0xB6, 0x31, 0x77, 0x72, 0x01, 0x0A, 0xFC, 0x09, 0x77, 0x73,
  0x81, 0x27, 0xCF, 0x90, 0x57, 0x77, 0x28, 0x21, 0x6A, 0xEF, 0x90, 0x27, 0x77, 0x01, 0x0A, 0xFC,
  0x0E, 0x77, 0x70, 0x60, 0xEF, 0x98, 0x2B, 0x63, 0x17, 0x77, 0x08, 0xF9, 0x0A, 0x02, 0x77, 0x73,
  0x06, 0xF9, 0x06, 0x77, 0x74, 0x03, 0xF9, 0x05, 0x77, 0x75, 0x0B, 0xF0, 0xA7, 0x77, 0x50, 0x4F,
  0x90, 0x27, 0x77, 0x50, 0xAF, 0x0B, 0x77, 0x76, 0xF9, 0x05, 0x77, 0x75, 0x04, 0xF9, 0x01, 0x77,
  0x75, 0x08, 0xF0, 0xC7, 0x77, 0x60, 0xCF, 0x09, 0x77, 0x76, 0xF9, 0x06, 0x77, 0x75, 0x03, 0xF9,
  0x02, 0x77, 0x75, 0x06, 0xF0, 0xE7, 0x77, 0x60, 0x9F, 0x0B, 0x77, 0x76, 0x0D, 0xF0, 0x87, 0x77,
  0x50, 0x1F, 0x90, 0x57, 0x77, 0x50, 0x4F, 0x90, 0x27, 0x77, 0x50, 0x7F, 0x0E, 0x77, 0x76, 0x0A,
  0xF0, 0xB7, 0x77, 0x60, 0xEF, 0x07, 0x77, 0x75, 0x02, 0xF9, 0x04, 0x77, 0x75, 0x05, 0xF9, 0x01,
  0x77, 0x75, 0x08, 0xF0, 0xD7, 0x77, 0x60, 0xCF, 0x0A, 0x77, 0x76, 0xF9, 0x06, 0x77, 0x75, 0x04,
  0xF9, 0x03, 0x77, 0x75, 0x09, 0xF0, 0xE7, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x75, 0x05, 0xF9, 0x04,
  0x77, 0x75, 0x0C, 0xF0, 0xD7, 0x77, 0x50, 0x7F, 0x90, 0x67, 0x77, 0x40, 0x7F, 0x90, 0xD7, 0x77,
  0x28, 0x12, 0x6C, 0xFA, 0x03, 0x77, 0x50, 0x9F, 0xF0, 0x67, 0x76, 0x0C, 0xFE, 0x06, 0x77, 0x70,
  0xEF, 0xC0, 0xC0, 0x37, 0x77, 0x02, 0xFA, 0x81, 0xE9, 0x47, 0x77, 0x20, 0x18, 0x01, 0x68, 0x25,
  0x53, 0x17, 0x77, 0x50,
  // "~" (U+007E)
  0x68, 0x63, 0x9D, 0xEE, 0xD9, 0x27, 0x72, 0x06, 0xC0, 0x85, 0x09, 0xF9, 0x09, 0x77, 0x10, 0x8C,
  0x06, 0x40, 0xAF, 0xB0, 0xC0, 0x17, 0x60, 0x9C, 0x04, 0x30, 0x6F, 0xD0, 0xD0, 0x27, 0x50, 0xCC,
  0x02, 0x30, 0xEF, 0xE0, 0xD0, 0x27, 0x40, 0xEC, 0x30, 0x7D, 0x83, 0x81, 0x03, 0xCD, 0x0D, 0x02,
  0x72, 0x02, 0xC0, 0xC3, 0x0D, 0xC0, 0x75, 0x0A, 0xD0, 0xD0, 0x17, 0x10, 0x5C, 0x09, 0x20, 0x3C,
  0x0D, 0x70, 0xAD, 0x0C, 0x01, 0x70, 0xAC, 0x05, 0x20, 0x7C, 0x08, 0x71, 0x0C, 0xD0, 0xC6, 0x01,
  0x0E, 0xC0, 0x12, 0x0A, 0xC0, 0x37, 0x10, 0x10, 0xDD, 0x0B, 0x50, 0x8C, 0x0B, 0x30, 0xEC, 0x73,
  0x02, 0x0E, 0xD8, 0x3D, 0x50, 0x17, 0xD0, 0x52, 0x01, 0xC0, 0xC7, 0x40, 0x30, 0xEF, 0xE0, 0xD3,
  0x04, 0xC0, 0xA7, 0x50, 0x30, 0xEF, 0xD0, 0x43, 0x06, 0xC0, 0x87, 0x60, 0x30, 0xEF, 0xB0, 0x84,
  0x08, 0xC0, 0x67, 0x70, 0x10, 0xAF, 0x90, 0x85, 0x09, 0xC0, 0x47, 0x72, 0x86, 0x39, 0xCE, 0xFD,
  0x93, 0x60,
  // "¡" (U+00A1)
  0x77, 0x18, 0x47, 0xCF, 0xEB, 0x47, 0x71, 0x02, 0x0D, 0xE0, 0x77, 0x70, 0xCF, 0x90, 0x27, 0x50,
  0x5F, 0xA0, 0x77, 0x50, 0x9F, 0xA0, 0xA7, 0x50, 0xBF, 0xA0, 0xA7, 0x50, 0xCF, 0xA0, 0x87, 0x50,
  0xCF, 0xA0, 0x57, 0x50, 0xAF, 0xA0, 0x17, 0x50, 0x4F, 0x90, 0x87, 0x70, 0x9E, 0x0B, 0x77, 0x28,
  0x45, 0xCE, 0xEC, 0x68, 0x0A, 0xA6, 0x08, 0x28, 0x99, 0x87, 0x74, 0x01, 0xB0, 0xB7, 0x74, 0x05,
  0xB0, 0x97, 0x74, 0x0A, 0xB0, 0x77, 0x74, 0x0E, 0xB0, 0x47, 0x73, 0x03, 0xC0, 0x27, 0x73, 0x07,
  0xC7, 0x74, 0x0B, 0xB0, 0xD7, 0x74, 0xC0, 0xB7, 0x73, 0x04, 0xC0, 0x87, 0x73, 0x09, 0xC0, 0x67,
  0x73, 0x0D, 0xC0, 0x47, 0x72, 0x02, 0xD0, 0x17, 0x72, 0x06, 0xC0, 0xE7, 0x73, 0x0B, 0xC0, 0xC7,
  0x73, 0x0E, 0xC0, 0xA7, 0x72, 0x04, 0xD0, 0x87, 0x72, 0x08, 0xD0, 0x57, 0x72, 0x0C, 0xD0, 0x37,
  0x71, 0x01, 0xE0, 0x17, 0x71, 0x06, 0xD0, 0xE7, 0x72, 0x0A, 0xD0, 0xC7, 0x72, 0x0E, 0xD0, 0x97,
  0x71, 0x03, 0xE0, 0x77, 0x71, 0x07, 0xE0, 0x57, 0x71, 0x0C, 0xE0, 0x37, 0x70, 0x1F, 0x77, 0x10,
  0x5E, 0x0D, 0x77, 0x10, 0x9E, 0x0B, 0x77, 0x10, 0xDE, 0x09, 0x77, 0x02, 0xF0, 0x77, 0x70, 0x7F,
  0x04, 0x77, 0x0B, 0xF0, 0x27, 0x7F, 0x97, 0x70, 0x4F, 0x0D, 0x77, 0x08, 0xF0, 0xB7, 0x70, 0xDF,
  0x08, 0x76, 0x02, 0xF9, 0x06, 0x76, 0x06, 0xF9, 0x04, 0x76, 0x0A, 0xF9, 0x01, 0x76, 0x0E, 0xF0,
  0xE7, 0x60, 0x3F, 0x90, 0xC7, 0x60, 0x8F, 0x90, 0xA7, 0x60, 0xCF, 0x90, 0x87, 0x50, 0x1F, 0xA0,
  0x57, 0x50, 0x5F, 0xA0, 0x37, 0x50, 0x48, 0x05, 0x77, 0x60,
  // "¢" (U+00A2)
  0x77, 0x73, 0x0D, 0xB0, 0x27, 0x77, 0x73, 0x01, 0xC7, 0x77, 0x74, 0x04, 0xB0, 0xC7, 0x77, 0x74,
  0x08, 0xB0, 0x97, 0x77, 0x74, 0x0B, 0xB0, 0x67, 0x77, 0x74, 0x0E, 0xB0, 0x27, 0x77, 0x71, 0x81,
  0x13, 0x7C, 0x02, 0x77, 0x75, 0x81, 0x27, 0xCF, 0xA8, 0x1B, 0x71, 0x77, 0x60, 0x30, 0xAF, 0xF9,
  0x08, 0x77, 0x40, 0x9F, 0xFC, 0x0C, 0x77, 0x10, 0x20, 0xDF, 0xFE, 0x0B, 0x76, 0x04, 0x0E, 0xE8,
  0x1E, 0x75, 0xB0, 0xEF, 0xA0, 0x57, 0x40, 0x5F, 0x82, 0xC1, 0x06, 0xB0, 0x90, 0x5F, 0x90, 0xC7,
  0x30, 0x5F, 0x0B, 0x30, 0x9B, 0x81, 0x50, 0xAF, 0x90, 0x17, 0x10, 0x3F, 0x0C, 0x40, 0xCB, 0x81,
  0x20, 0x4F, 0x90, 0x27, 0x01, 0x0D, 0xE0, 0xE0, 0x24, 0xB0, 0xE3, 0x0E, 0xF0, 0x27, 0x0A, 0xF0,
  0x64, 0x03, 0xB0, 0xB3, 0x0B, 0xE0, 0xE7, 0x05, 0xF0, 0xC5, 0x07, 0xB0, 0x83, 0x09, 0xE0, 0x96,
  0x01, 0x0E, 0xF0, 0x45, 0x0A, 0xB0, 0x53, 0x07, 0xD0, 0xD0, 0x16, 0x08, 0xF0, 0xC6, 0x0D, 0xB0,
  0x13, 0x06, 0xC0, 0xD0, 0x26, 0x02, 0xF9, 0x05, 0x50, 0x1B, 0x0E, 0x40, 0x6A, 0x0D, 0x07, 0x71,
  0x09, 0xF0, 0xE6, 0x04, 0xB0, 0xA4, 0x81, 0x13, 0x27, 0x20, 0x1F, 0x90, 0x86, 0x07, 0xB0, 0x77,
  0x72, 0x07, 0xF9, 0x02, 0x60, 0xAB, 0x04, 0x77, 0x20, 0xDF, 0x0C, 0x70, 0xEB, 0x01, 0x77, 0x10,
  0x4F, 0x90, 0x76, 0x01, 0xB0, 0xD7, 0x72, 0x09, 0xF9, 0x02, 0x60, 0x5B, 0x0A, 0x77, 0x20, 0xEF,
  0x0D, 0x70, 0x8B, 0x07, 0x77, 0x10, 0x3F, 0x90, 0x97, 0x0B, 0xB0, 0x37, 0x71, 0x07, 0xF9, 0x05,
  0x70, 0xEB, 0x77, 0x20, 0xBF, 0x90, 0x26, 0x02, 0xB0, 0xC7, 0x72, 0x0E, 0xF0, 0xE7, 0x05, 0xB0,
  0x97, 0x71, 0x01, 0xF9, 0x0B, 0x70, 0x8B, 0x06, 0x77, 0x10, 0x4F, 0x90, 0x87, 0x0C, 0xB0, 0x37,
  0x71, 0x06, 0xF9, 0x06, 0x7C, 0x77, 0x20, 0x8F, 0x90, 0x46, 0x03, 0xB0, 0xC7, 0x72, 0x09, 0xF9,
  0x02, 0x60, 0x6B, 0x09, 0x77, 0x20, 0xAF, 0x90, 0x16, 0x09, 0xB0, 0x57, 0x72, 0x0A, 0xF9, 0x01,
  0x60, 0xCB, 0x02, 0x77, 0x20, 0xAF, 0x97, 0xB0, 0xE7, 0x73, 0x09, 0xF9, 0x60, 0x3B, 0x0B, 0x77,
  0x30, 0x8F, 0x90, 0x15, 0x06, 0xB0, 0x87, 0x73, 0x07, 0xF9, 0x02, 0x50, 0xAB, 0x05, 0x77, 0x30,
  0x4F, 0x90, 0x45, 0x0D, 0xB0, 0x17, 0x73, 0x01, 0xF9, 0x08, 0x40, 0x1B, 0x0E, 0x72, 0x01, 0x72,
  0x0D, 0xF0, 0xC4, 0x04, 0xB0, 0xA7, 0x18, 0x12, 0xE4, 0x71, 0x07, 0xF9, 0x02, 0x30, 0x7B, 0x07,
  0x78, 0x21, 0xDF, 0x77, 0x10, 0x2F, 0x90, 0x93, 0x0A, 0xB0, 0x46, 0x02, 0x0D, 0xA0, 0x67, 0x20,
  0xAF, 0x90, 0x42, 0x0D, 0xB0, 0x15, 0x03, 0x0E, 0xB0, 0x27, 0x20, 0x20, 0xEF, 0x81, 0xE4, 0x1B,
  0x0D, 0x50, 0x8C, 0x0B, 0x74, 0x07, 0xFA, 0x0C, 0xB8, 0x4A, 0x02, 0x59, 0xED, 0x02, 0x75, 0x09,
  0xFF, 0xF9, 0x06, 0x77, 0x0A, 0xFF, 0xE0, 0x67, 0x72, 0x07, 0xFF, 0xB0, 0xD0, 0x47, 0x74, 0x02,
  0x0A, 0xFE, 0x0E, 0x07, 0x77, 0x71, 0x81, 0x27, 0xBD, 0x83, 0xED, 0xB8, 0x47, 0x77, 0x60, 0xCB,
  0x04, 0x77, 0x77, 0x4C, 0x01, 0x77, 0x77, 0x30, 0x3B, 0x0D, 0x77, 0x77, 0x40, 0x6B, 0x0A, 0x77,
  0x77, 0x40, 0x9B, 0x07, 0x77, 0x77, 0x40, 0xCB, 0x04, 0x77, 0x77, 0x4C, 0x01, 0x77, 0x77, 0x30,
  0x3B, 0x0D, 0x77, 0x71,
  // "£" (U+00A3)
  0x77, 0x75, 0x84, 0x15, 0x9B, 0xDE, 0xA8, 0x3E, 0xDB, 0x84, 0x77, 0x77, 0x30, 0x50, 0xBF, 0xE0,
  0xE0, 0x87, 0x77, 0x60, 0x40, 0xDF, 0xFB, 0x0D, 0x04, 0x77, 0x72, 0x01, 0x0A, 0xFF, 0xF0, 0x57,
  0x77, 0x02, 0x0D, 0xF8, 0x4D, 0x97, 0x68, 0xBF, 0xB0, 0x37, 0x75, 0x02, 0x0E, 0xE0, 0xB0, 0x36,
  0x03, 0x0D, 0xF9, 0x0D, 0x77, 0x40, 0x10, 0xDE, 0x07, 0x72, 0x01, 0x0D, 0xF9, 0x04, 0x77, 0x30,
  0xBE, 0x07, 0x74, 0x03, 0xF9, 0x08, 0x77, 0x20, 0x6E, 0x0A, 0x76, 0x0A, 0xF0, 0xA7, 0x71, 0x01,
  0x0E, 0xE0, 0x17, 0x60, 0x4F, 0x0A, 0x77, 0x10, 0x8E, 0x09, 0x77, 0x1F, 0x08, 0x77, 0x10, 0xEE,
  0x02, 0x77, 0x10, 0xCE, 0x05, 0x77, 0x05, 0xE0, 0xD7, 0x72, 0x0A, 0xD0, 0xD7, 0x71, 0x0A, 0xE0,
  0x87, 0x72, 0x09, 0xD0, 0x47, 0x71, 0x0E, 0xE0, 0x47, 0x72, 0x09, 0xB0, 0xD0, 0x47, 0x71, 0x02,
  0xF0, 0x27, 0x72, 0x82, 0x6B, 0x95, 0x77, 0x30, 0x5F, 0x80, 0xC2, 0x00, 0x7E, 0x0C, 0x80, 0xC2,
  0x00, 0x9E, 0x0B, 0x80, 0xC2, 0x00, 0xAE, 0x0A, 0x80, 0xC2, 0x00, 0xBE, 0x0A, 0x80, 0xC2, 0x00,
  0xBE, 0x09, 0x80, 0xC2, 0x00, 0xBE, 0x09, 0x80, 0xC2, 0x00, 0xAE, 0x0A, 0x80, 0xC2, 0x00, 0xAE,
  0x0A, 0x80, 0xC2, 0x00, 0x9E, 0x0C, 0x80, 0xC2, 0x00, 0x8E, 0x0D, 0x80, 0xC2, 0x00, 0x6F, 0x80,
  0xC2, 0x00, 0x5F, 0x01, 0x80, 0xC1, 0x00, 0x3F, 0x03, 0x77, 0x77, 0x20, 0x18, 0x02, 0x60, 0x7F,
  0x09, 0x80, 0x90, 0x60, 0x37, 0x73, 0x07, 0xFF, 0xFE, 0x07, 0x77, 0x30, 0xAF, 0xFF, 0xE0, 0x37,
  0x73, 0x0D, 0xFF, 0xFE, 0x77, 0x30, 0x1F, 0xFF, 0xE0, 0xB7, 0x77, 0x50, 0x8E, 0x0C, 0x80, 0xC2,
  0x00, 0x6E, 0x0C, 0x80, 0xC2, 0x00, 0x5E, 0x0D, 0x80, 0xC2, 0x00, 0x4E, 0x0D, 0x80, 0xC2, 0x00,
  0x3E, 0x0C, 0x80, 0xC2, 0x00, 0x4E, 0x0B, 0x80, 0xC2, 0x00, 0x4E, 0x0A, 0x80, 0xC2, 0x00, 0x5E,
  0x08, 0x80, 0xC2, 0x00, 0x8E, 0x05, 0x80, 0xC2, 0x00, 0xAE, 0x02, 0x80, 0xC2, 0x00, 0xED, 0x0D,
  0x80, 0xC2, 0x00, 0x2E, 0x07, 0x80, 0xC2, 0x00, 0x8E, 0x01, 0x80, 0xC2, 0x00, 0xED, 0x08, 0x80,
  0xC2, 0x00, 0x6D, 0x0D, 0x01, 0x80, 0xC2, 0x00, 0xDD, 0x03, 0x80, 0xC2, 0x00, 0x8D, 0x06, 0x80,
  0xC2, 0x00, 0x3D, 0x08, 0x80, 0xC3, 0x00, 0xDC, 0x08, 0x80, 0xC3, 0x00, 0xBC, 0x06, 0x80, 0xC3,
  0x00, 0xAB, 0x87, 0xD3, 0x14, 0x67, 0x64, 0x17, 0x72, 0x05, 0x0A, 0x77, 0x0B, 0xB8, 0x1B, 0x6B,
  0xF8, 0x1B, 0x61, 0x75, 0x07, 0xA0, 0x67, 0x40, 0x10, 0xBF, 0xFB, 0x0A, 0x04, 0x72, 0x09, 0xB0,
  0xE0, 0x17, 0x20, 0x30, 0xDF, 0xFE, 0x87, 0xD8, 0x41, 0x01, 0x37, 0xEC, 0x07, 0x72, 0x07, 0xFF,
  0xFF, 0xE0, 0x77, 0x10, 0x20, 0xCF, 0xFF, 0xFE, 0x07, 0x71, 0x06, 0xFB, 0x00, 0xEF, 0xFF, 0xA0,
  0x57, 0x20, 0x6D, 0x82, 0xC7, 0x41, 0x48, 0x11, 0x5A, 0xFF, 0xB0, 0xD0, 0x37, 0x40, 0xEA, 0x0A,
  0x03, 0x74, 0x81, 0x17, 0xEF, 0xE0, 0x90, 0x17, 0x58, 0x1A, 0xB3, 0x77, 0x20, 0x60, 0xCF, 0xA0,
  0xB0, 0x37, 0x77, 0x77, 0x87, 0x38, 0xCD, 0xFE, 0xC8, 0x37, 0x71,
  // "¤" (U+00A4)
  0x30, 0x10, 0x77, 0x77, 0x71, 0x01, 0x09, 0x68, 0x21, 0xDF, 0xA7, 0x77, 0x68, 0x31, 0xDF, 0xC1,
  0x30, 0x10, 0xDB, 0x0A, 0x77, 0x74, 0x02, 0x0D, 0xB8, 0x3C, 0x10, 0x2D, 0xD0, 0xB6, 0x83, 0x36,
  0xAC, 0xDA, 0x83, 0xDC, 0x96, 0x15, 0x02, 0x0E, 0xD0, 0xC2, 0x0B, 0xE0, 0xB3, 0x07, 0x0D, 0xFD,
  0x0A, 0x04, 0x20, 0x30, 0xEE, 0x09, 0x30, 0xBE, 0x81, 0xC6, 0xDF, 0xFA, 0x81, 0xB5, 0xEE, 0x08,
  0x50, 0xAF, 0xFF, 0xFC, 0x07, 0x70, 0x9F, 0xC8, 0x6E, 0xA8, 0x66, 0x8A, 0xEF, 0xC0, 0x67, 0x20,
  0x8F, 0x90, 0xC0, 0x57, 0x10, 0x50, 0xCF, 0x90, 0x67, 0x40, 0xBE, 0x06, 0x75, 0x06, 0xE0, 0x87,
  0x40, 0x2D, 0x0E, 0x03, 0x77, 0x03, 0x0E, 0xC0, 0xD7, 0x40, 0xBD, 0x03, 0x77, 0x20, 0x4D, 0x08,
  0x72, 0x02, 0xD0, 0x77, 0x74, 0x08, 0xC0, 0xE0, 0x17, 0x10, 0x8C, 0x0D, 0x77, 0x60, 0xDC, 0x07,
  0x71, 0x0D, 0xC0, 0x57, 0x76, 0x06, 0xC0, 0xC7, 0x01, 0xD7, 0x77, 0x01, 0xD0, 0x16, 0x04, 0xC0,
  0xB7, 0x77, 0x10, 0xDC, 0x04, 0x60, 0x5C, 0x09, 0x77, 0x71, 0x0A, 0xC0, 0x66, 0x06, 0xC0, 0x87,
  0x77, 0x10, 0x9C, 0x07, 0x60, 0x6C, 0x07, 0x77, 0x71, 0x09, 0xC0, 0x86, 0x05, 0xC0, 0x97, 0x77,
  0x10, 0xAC, 0x06, 0x60, 0x4C, 0x0B, 0x77, 0x71, 0x0D, 0xC0, 0x56, 0x02, 0xD7, 0x77, 0x01, 0xD0,
  0x17, 0x0E, 0xC0, 0x67, 0x76, 0x07, 0xC0, 0xD7, 0x10, 0xAC, 0x0D, 0x77, 0x60, 0xDC, 0x08, 0x71,
  0x04, 0xD0, 0x77, 0x74, 0x08, 0xD0, 0x17, 0x20, 0xDD, 0x04, 0x77, 0x20, 0x4D, 0x09, 0x73, 0x04,
  0xD0, 0xE0, 0x47, 0x70, 0x40, 0xEC, 0x0E, 0x01, 0x74, 0x0C, 0xE0, 0x77, 0x50, 0x7E, 0x07, 0x74,
  0x06, 0xF9, 0x0C, 0x05, 0x71, 0x05, 0x0C, 0xF0, 0xE0, 0x37, 0x20, 0x7F, 0xC8, 0x6E, 0xA7, 0x66,
  0x7A, 0xEF, 0xB0, 0xE0, 0x47, 0x08, 0xFF, 0xFF, 0xC0, 0x55, 0x09, 0xE8, 0x1D, 0x7E, 0xFF, 0xA8,
  0x1C, 0x7E, 0xE0, 0x63, 0x0A, 0xE0, 0xD0, 0x22, 0x07, 0x0D, 0xFD, 0x0B, 0x05, 0x20, 0x30, 0xEE,
  0x82, 0x70, 0x2E, 0xD0, 0xD0, 0x15, 0x83, 0x37, 0xAD, 0xEA, 0x83, 0xDC, 0x96, 0x15, 0x02, 0x0D,
  0xD8, 0x3D, 0x10, 0x3E, 0xB0, 0xC0, 0x17, 0x77, 0x30, 0x20, 0xDB, 0x0D, 0x01, 0x38, 0x33, 0xEF,
  0xC1, 0x77, 0x75, 0x83, 0x1C, 0xFD, 0x15, 0x81, 0x3B, 0x17, 0x77, 0x78, 0x11, 0x91, 0x30,
  // "¥" (U+00A5)
  0x40, 0xBF, 0xFB, 0x0C, 0x71, 0x03, 0xFF, 0x90, 0x94, 0x0E, 0xFF, 0xB0, 0x97, 0x10, 0x6F, 0xF9,
  0x06, 0x30, 0x2F, 0xFC, 0x06, 0x71, 0x0A, 0xFF, 0x90, 0x33, 0x05, 0xFF, 0xC0, 0x37, 0x10, 0xDF,
  0xF9, 0x60, 0x20, 0x9F, 0xB8, 0x1C, 0x52, 0x75, 0x81, 0x14, 0xCF, 0x90, 0xC0, 0x47, 0x30, 0xBF,
  0x90, 0xE7, 0x73, 0x01, 0x0E, 0xE0, 0xA7, 0x50, 0x4F, 0x90, 0xA7, 0x74, 0x0C, 0xD0, 0xC7, 0x70,
  0xEF, 0x09, 0x77, 0x40, 0xEC, 0x0E, 0x01, 0x77, 0x09, 0xF0, 0xA7, 0x73, 0x03, 0xD0, 0x57, 0x71,
  0x06, 0xF0, 0xC7, 0x73, 0x0A, 0xC0, 0xA7, 0x72, 0x02, 0xF0, 0xE7, 0x72, 0x02, 0xC0, 0xE0, 0x17,
  0x73, 0x0E, 0xF0, 0x27, 0x71, 0x0A, 0xC0, 0x57, 0x74, 0x0B, 0xF0, 0x57, 0x70, 0x3C, 0x0B, 0x77,
  0x50, 0x7F, 0x09, 0x77, 0x0C, 0xB0, 0xE0, 0x17, 0x75, 0x04, 0xF0, 0xC7, 0x60, 0x5C, 0x06, 0x77,
  0x7F, 0x97, 0x50, 0x10, 0xEB, 0x0B, 0x77, 0x71, 0x0C, 0xF0, 0x37, 0x40, 0xAC, 0x02, 0x77, 0x71,
  0x09, 0xF0, 0x77, 0x30, 0x4C, 0x07, 0x77, 0x72, 0x05, 0xF0, 0xA7, 0x30, 0xDB, 0x0C, 0x77, 0x73,
  0x02, 0xF0, 0xE7, 0x20, 0x9C, 0x02, 0x77, 0x74, 0x0E, 0xF0, 0x17, 0x03, 0xC0, 0x77, 0x77, 0x50,
  0xAF, 0x04, 0x70, 0xDB, 0x0C, 0x77, 0x76, 0x07, 0xF0, 0x76, 0x08, 0xC0, 0x37, 0x77, 0x60, 0x3F,
  0x0A, 0x50, 0x3C, 0x08, 0x77, 0x77, 0x1F, 0x0D, 0x50, 0xCB, 0x0D, 0x77, 0x77, 0x20, 0xCF, 0x01,
  0x30, 0x7C, 0x03, 0x77, 0x77, 0x20, 0x8F, 0x03, 0x20, 0x10, 0xEB, 0x09, 0x77, 0x77, 0x30, 0x5F,
  0x06, 0x20, 0xBB, 0x0D, 0x77, 0x77, 0x40, 0x1F, 0x81, 0x90, 0x5C, 0x04, 0x77, 0x77, 0x50, 0xDE,
  0x81, 0xB0, 0xDB, 0x09, 0x77, 0x77, 0x60, 0xAE, 0x0C, 0x07, 0xB0, 0xE0, 0x17, 0x77, 0x76, 0x06,
  0xE0, 0x0E, 0xB0, 0x57, 0x77, 0x77, 0x03, 0xFB, 0x0A, 0x77, 0x76, 0x0D, 0xFF, 0xFF, 0x97, 0x73,
  0x01, 0xFF, 0xFF, 0x90, 0xC7, 0x73, 0x04, 0xFF, 0xFF, 0x90, 0x97, 0x73, 0x08, 0xFF, 0xFF, 0x90,
  0x57, 0x73, 0x04, 0x80, 0x66, 0x0E, 0xF0, 0x98, 0x06, 0x60, 0x17, 0x77, 0x60, 0x1F, 0x90, 0x18,
  0x0C, 0x20, 0x04, 0xF0, 0xE8, 0x0C, 0x30, 0x07, 0xF0, 0xA8, 0x0C, 0x30, 0x0B, 0xF0, 0x78, 0x0C,
  0x30, 0x0E, 0xF0, 0x37, 0x77, 0x78, 0x06, 0x60, 0x7F, 0x90, 0x78, 0x05, 0x60, 0x57, 0x73, 0x02,
  0xFF, 0xFF, 0x90, 0xA7, 0x73, 0x06, 0xFF, 0xFF, 0x90, 0x77, 0x73, 0x09, 0xFF, 0xFF, 0x90, 0x37,
  0x73, 0x0D, 0xFF, 0xFF, 0x97, 0x77, 0x70, 0x2F, 0x98, 0x0C, 0x30, 0x06, 0xF0, 0xC8, 0x0C, 0x30,
  0x09, 0xF0, 0x88, 0x0C, 0x30, 0x0C, 0xF0, 0x58, 0x0C, 0x30, 0xF9, 0x02, 0x80, 0xC2, 0x00, 0x3F,
  0x0E, 0x80, 0xC3, 0x00, 0x7F, 0x0B, 0x80, 0xC3, 0x00, 0xBF, 0x07, 0x80, 0xC2, 0x00, 0x2F, 0x90,
  0x68, 0x0C, 0x20, 0x09, 0xF9, 0x08, 0x80, 0xC1, 0x00, 0x7F, 0xA0, 0xD7, 0x77, 0x75, 0x82, 0x24,
  0x8D, 0xFC, 0x82, 0xD7, 0x31, 0x77, 0x75, 0x0C, 0xFF, 0xFA, 0x09, 0x77, 0x72, 0xFF, 0xFB, 0x05,
  0x77, 0x71, 0x03, 0xFF, 0xFB, 0x02, 0x77, 0x71, 0x06, 0xFF, 0xFA, 0x0E, 0x77, 0x72,
  // "¦" (U+00A6)
  0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07,
  0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0,
  0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60,
  0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C,
  0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06,
  0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x80, 0x9D, 0x00, 0x07, 0xC0, 0x60,
  0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C,
  0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06,
  0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07,
  0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0,
  0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06, 0x07, 0xC0, 0x60,
  0x7C, 0x06, 0x07, 0xC0, 0x60, 0x7C, 0x06,
  // "§" (U+00A7)
  0x77, 0x72, 0x89, 0x22, 0x69, 0xCE, 0xEF, 0xED, 0xA7, 0x37, 0x77, 0x70, 0x50, 0xCF, 0xD0, 0xC0,
  0x57, 0x77, 0x30, 0x40, 0xDF, 0xFA, 0x0B, 0x01, 0x77, 0x70, 0x9F, 0xFD, 0x0D, 0x01, 0x77, 0x50,
  0xBE, 0x85, 0xEA, 0x86, 0x79, 0xEF, 0x90, 0xC7, 0x74, 0x0A, 0xD0, 0xE0, 0x67, 0x08, 0xF9, 0x07,
  0x77, 0x20, 0x8D, 0x0C, 0x01, 0x72, 0x07, 0xF0, 0xE7, 0x71, 0x03, 0xD0, 0xC7, 0x50, 0xCF, 0x04,
  0x77, 0x0B, 0xD0, 0x27, 0x50, 0x5F, 0x06, 0x76, 0x03, 0xD0, 0x97, 0x70, 0xEE, 0x07, 0x76, 0x09,
  0xD0, 0x37, 0x70, 0xAE, 0x06, 0x76, 0x0E, 0xC0, 0xE7, 0x71, 0x07, 0xE0, 0x37, 0x50, 0x3D, 0x0C,
  0x77, 0x10, 0x5D, 0x0D, 0x76, 0x05, 0xD0, 0xB7, 0x71, 0x03, 0xD0, 0x57, 0x60, 0x8D, 0x0B, 0x77,
  0x10, 0x3B, 0x0C, 0x04, 0x77, 0x09, 0xD0, 0xD7, 0x71, 0x82, 0x15, 0x41, 0x77, 0x20, 0xAD, 0x0E,
  0x77, 0x77, 0x70, 0xAE, 0x04, 0x77, 0x77, 0x60, 0x9E, 0x0A, 0x77, 0x77, 0x60, 0x8F, 0x03, 0x77,
  0x77, 0x50, 0x5F, 0x0D, 0x01, 0x77, 0x77, 0x40, 0x2F, 0x90, 0xD0, 0x17, 0x77, 0x74, 0x0D, 0xF9,
  0x0D, 0x03, 0x77, 0x77, 0x30, 0x8F, 0xB0, 0x67, 0x77, 0x72, 0x03, 0xFC, 0x0A, 0x01, 0x77, 0x76,
  0x03, 0x0D, 0xFD, 0x0D, 0x04, 0x77, 0x74, 0x04, 0x0E, 0xFF, 0x90, 0x97, 0x77, 0x20, 0x4C, 0x08,
  0x0E, 0xFD, 0x0D, 0x03, 0x77, 0x60, 0x20, 0xEB, 0x82, 0x60, 0x3E, 0xFE, 0x05, 0x77, 0x50, 0xDB,
  0x0A, 0x30, 0x30, 0xDF, 0xE0, 0x87, 0x73, 0x08, 0xC0, 0x14, 0x01, 0x0C, 0xFE, 0x08, 0x77, 0x10,
  0x1C, 0x0A, 0x70, 0x8F, 0xE0, 0x67, 0x70, 0x7C, 0x07, 0x71, 0x03, 0x0D, 0xFD, 0x03, 0x76, 0x0C,
  0xC0, 0x57, 0x30, 0x9F, 0xC0, 0xD7, 0x6D, 0x05, 0x74, 0x04, 0x0E, 0xFB, 0x06, 0x74, 0x03, 0xD0,
  0x77, 0x50, 0x10, 0xBF, 0xA0, 0xC7, 0x40, 0x4D, 0x0A, 0x77, 0x09, 0xFA, 0x02, 0x73, 0x05, 0xE0,
  0x17, 0x70, 0x9F, 0x90, 0x57, 0x30, 0x4E, 0x08, 0x77, 0x10, 0xBF, 0x07, 0x73, 0x03, 0xF0, 0x37,
  0x70, 0x10, 0xEE, 0x09, 0x73, 0x01, 0xF0, 0xE0, 0x27, 0x70, 0x8E, 0x08, 0x74, 0x0D, 0xF0, 0xE0,
  0x37, 0x60, 0x1E, 0x07, 0x74, 0x08, 0xF9, 0x0E, 0x05, 0x76, 0x0C, 0xD0, 0x57, 0x40, 0x2F, 0xB0,
  0x97, 0x50, 0xAD, 0x02, 0x75, 0x0B, 0xFB, 0x0D, 0x03, 0x73, 0x09, 0xC0, 0xE7, 0x60, 0x2F, 0xD0,
  0x87, 0x20, 0xBC, 0x08, 0x77, 0x06, 0xFD, 0x0C, 0x02, 0x70, 0xEC, 0x02, 0x77, 0x10, 0x9F, 0xD0,
  0xE0, 0x45, 0x04, 0xC0, 0x97, 0x73, 0x09, 0xFE, 0x07, 0x40, 0xBB, 0x0E, 0x01, 0x77, 0x40, 0x8F,
  0xE0, 0x92, 0x05, 0xC0, 0x57, 0x76, 0x05, 0x0E, 0xFD, 0x81, 0xA2, 0xEB, 0x09, 0x77, 0x71, 0x02,
  0x0C, 0xFF, 0xA0, 0xB7, 0x77, 0x40, 0x7F, 0xF0, 0xC7, 0x77, 0x60, 0x30, 0xDF, 0xC0, 0xB7, 0x77,
  0x72, 0x0A, 0xFB, 0x08, 0x77, 0x77, 0x30, 0x6F, 0xA0, 0xE7, 0x77, 0x74, 0x04, 0xFA, 0x04, 0x77,
  0x77, 0x40, 0x4F, 0x90, 0x77, 0x77, 0x75, 0x05, 0xF0, 0xA7, 0x77, 0x76, 0x09, 0xE0, 0xB7, 0x77,
  0x76, 0x01, 0xE0, 0xB7, 0x77, 0x77, 0x0B, 0xD0, 0xA7, 0x77, 0x77, 0x07, 0xD0, 0x97, 0x68, 0x15,
  0xBE, 0x77, 0x50, 0x5D, 0x07, 0x75, 0x0A, 0xB7, 0x75, 0x06, 0xD0, 0x47, 0x40, 0x9C, 0x01, 0x77,
  0x40, 0x8D, 0x01, 0x73, 0x01, 0xD0, 0x47, 0x74, 0x0B, 0xC0, 0xC7, 0x40, 0x5D, 0x07, 0x77, 0x40,
  0xEC, 0x07, 0x74, 0x06, 0xD0, 0xC7, 0x73, 0x05, 0xC0, 0xE0, 0x17, 0x40, 0x6E, 0x02, 0x77, 0x20,
  0xDC, 0x08, 0x75, 0x05, 0xE0, 0xA7, 0x71, 0x08, 0xC0, 0xE0, 0x17, 0x50, 0x2F, 0x05, 0x76, 0x05,
  0xD0, 0x67, 0x70, 0xCF, 0x03, 0x74, 0x07, 0xD0, 0xA7, 0x71, 0x05, 0xF9, 0x08, 0x01, 0x70, 0x40,
  0xCD, 0x0C, 0x77, 0x30, 0xAF, 0xA8, 0x5B, 0x87, 0x68, 0xAE, 0xE0, 0xB7, 0x75, 0x0B, 0xFF, 0xE0,
  0x97, 0x77, 0x08, 0xFF, 0xB0, 0xD0, 0x57, 0x77, 0x28, 0x12, 0x9E, 0xFD, 0x0C, 0x06, 0x77, 0x77,
  0x89, 0x25, 0x8B, 0xDE, 0xFE, 0xDC, 0xA7, 0x27, 0x77, 0x10,
  // "¨" (U+00A8)
  0x28, 0x35, 0xCF, 0xD7, 0x73, 0x83, 0x6D, 0xFD, 0x73, 0x07, 0xD0, 0x97, 0x10, 0x8D, 0x81, 0x80,
  0x2F, 0x01, 0x60, 0x2E, 0x81, 0xE0, 0x7F, 0x03, 0x60, 0x8F, 0x02, 0x0B, 0xF0, 0x46, 0x0C, 0xF0,
  0x30, 0xCF, 0x03, 0x60, 0xDF, 0x02, 0x0B, 0xF7, 0x0C, 0xF1, 0x09, 0xE0, 0xB7, 0x0A, 0xE8, 0x1A,
  0x02, 0xD0, 0xE0, 0x27, 0x03, 0xD0, 0xD0, 0x12, 0x84, 0x3B, 0xEE, 0xA1, 0x72, 0x84, 0x4C, 0xFE,
  0x91, 0x20,
  // "©" (U+00A9)
  0x77, 0x78, 0x52, 0x69, 0xBD, 0xEE, 0xA8, 0x4E, 0xDB, 0x96, 0x38, 0x0C, 0x30, 0x81, 0x49, 0xEF,
  0xF9, 0x81, 0xEA, 0x47, 0x77, 0x76, 0x06, 0x0D, 0xFF, 0xF0, 0xD0, 0x77, 0x77, 0x72, 0x04, 0x0D,
  0xFF, 0xFC, 0x0E, 0x05, 0x77, 0x76, 0x0A, 0xFA, 0x89, 0x1E, 0xB9, 0x87, 0x67, 0x89, 0xBE, 0xFA,
  0x0B, 0x01, 0x77, 0x72, 0x02, 0x0D, 0xF8, 0x1B, 0x62, 0x74, 0x81, 0x15, 0xAF, 0x0D, 0x03, 0x77,
  0x70, 0x40, 0xEE, 0x08, 0x02, 0x77, 0x38, 0x11, 0x7E, 0xE0, 0x57, 0x75, 0x04, 0xE0, 0xA0, 0x17,
  0x77, 0x01, 0x09, 0xE0, 0x57, 0x73, 0x04, 0xD0, 0xE0, 0x47, 0x77, 0x40, 0x30, 0xDD, 0x05, 0x77,
  0x10, 0x30, 0xEC, 0x0C, 0x02, 0x77, 0x76, 0x01, 0x0B, 0xD0, 0x37, 0x70, 0xDC, 0x0C, 0x77, 0x77,
  0x30, 0xBC, 0x0D, 0x01, 0x75, 0x09, 0xC0, 0xC0, 0x17, 0x38, 0x93, 0x15, 0x9B, 0xDE, 0xFE, 0xDC,
  0x96, 0x17, 0x20, 0xCC, 0x0A, 0x74, 0x05, 0xC0, 0xD0, 0x17, 0x20, 0x20, 0xAF, 0xE0, 0xA0, 0x27,
  0x01, 0x0D, 0xC0, 0x57, 0x30, 0xDC, 0x04, 0x72, 0x08, 0xFF, 0xA0, 0xE0, 0x57, 0x03, 0xC0, 0xE7,
  0x20, 0x7C, 0x08, 0x71, 0x01, 0x0C, 0xFF, 0xD0, 0x57, 0x08, 0xC0, 0x77, 0x01, 0x0E, 0xB0, 0xD7,
  0x10, 0x10, 0xDE, 0x81, 0xA5, 0x23, 0x81, 0x26, 0xCE, 0x02, 0x70, 0xDB, 0x0E, 0x01, 0x60, 0x7C,
  0x05, 0x71, 0x0B, 0xD0, 0xA0, 0x17, 0x20, 0x6D, 0x0B, 0x70, 0x5C, 0x07, 0x60, 0xDB, 0x0D, 0x71,
  0x07, 0xD0, 0x77, 0x50, 0x6D, 0x02, 0x70, 0xDB, 0x0D, 0x50, 0x4C, 0x05, 0x70, 0x1D, 0x09, 0x77,
  0x0C, 0xC0, 0x67, 0x06, 0xC0, 0x44, 0x0A, 0xB0, 0xE7, 0x10, 0x9C, 0x0D, 0x77, 0x10, 0x5C, 0x08,
  0x71, 0x0E, 0xB0, 0xA4, 0x0E, 0xB0, 0x97, 0x01, 0xD0, 0x67, 0x71, 0x01, 0xC0, 0x77, 0x10, 0xAB,
  0x0E, 0x30, 0x3C, 0x04, 0x70, 0x7C, 0x0E, 0x77, 0x30, 0xCB, 0x02, 0x71, 0x04, 0xC0, 0x32, 0x07,
  0xC7, 0x10, 0xCC, 0x08, 0x77, 0x30, 0xBA, 0x08, 0x73, 0xC0, 0x72, 0x0B, 0xB0, 0xB7, 0x01, 0xD0,
  0x47, 0x73, 0x81, 0x8B, 0x57, 0x40, 0xBB, 0x0B, 0x2C, 0x07, 0x70, 0x5C, 0x0E, 0x77, 0x77, 0x40,
  0x8B, 0x81, 0xE0, 0x1C, 0x04, 0x70, 0x8C, 0x0B, 0x77, 0x77, 0x40, 0x4C, 0x01, 0x04, 0xC0, 0x27,
  0x0B, 0xC0, 0x97, 0x77, 0x74, 0x02, 0xC0, 0x40, 0x6C, 0x71, 0x0D, 0xC0, 0x77, 0x77, 0x75, 0xC0,
  0x60, 0x8B, 0x0D, 0x71, 0xD0, 0x57, 0x77, 0x75, 0x0D, 0xB0, 0x80, 0x9B, 0x0C, 0x71, 0xD0, 0x47,
  0x77, 0x75, 0x0C, 0xB0, 0x90, 0xAB, 0x0B, 0x70, 0x1D, 0x03, 0x77, 0x77, 0x50, 0xBB, 0x09, 0x0A,
  0xB0, 0xA7, 0x02, 0xD0, 0x27, 0x77, 0x75, 0x0B, 0xB0, 0xA0, 0xBB, 0x0A, 0x70, 0x2D, 0x02, 0x77,
  0x77, 0x50, 0xAB, 0x00, 0xBB, 0x0A, 0x70, 0x2D, 0x02, 0x77, 0x77, 0x50, 0xAB, 0x0B, 0x0A, 0xB0,
  0xB7, 0x01, 0xD0, 0x27, 0x77, 0x75, 0x0B, 0xB0, 0x0A, 0xB0, 0xB7, 0x01, 0xD0, 0x37, 0x77, 0x75,
  0x0B, 0xB0, 0x09, 0xB0, 0xC7, 0x1D, 0x04, 0x77, 0x77, 0x50, 0xCB, 0x09, 0x08, 0xB0, 0xD7, 0x10,
  0xEC, 0x06, 0x77, 0x77, 0x50, 0xDB, 0x08, 0x06, 0xC7, 0x10, 0xCC, 0x08, 0x77, 0x77, 0x5C, 0x06,
  0x04, 0xC0, 0x27, 0x09, 0xC0, 0xB7, 0x77, 0x74, 0x02, 0xC0, 0x30, 0x1C, 0x04, 0x70, 0x7C, 0x0E,
  0x77, 0x77, 0x40, 0x4C, 0x81, 0x10, 0xEB, 0x08, 0x70, 0x3D, 0x02, 0x77, 0x77, 0x30, 0x8B, 0x0E,
  0x20, 0xBB, 0x0C, 0x71, 0x0E, 0xC0, 0x77, 0x77, 0x73, 0x0C, 0xB0, 0xB2, 0x07, 0xC7, 0x10, 0xAC,
  0x0C, 0x77, 0x50, 0x17, 0x4C, 0x07, 0x20, 0x3C, 0x04, 0x70, 0x5D, 0x03, 0x77, 0x40, 0xE0, 0x77,
  0x20, 0x4C, 0x03, 0x30, 0xEB, 0x0A, 0x71, 0x0E, 0xC0, 0xB7, 0x73, 0x08, 0xA0, 0x17, 0x10, 0xAB,
  0x0E, 0x40, 0x9C, 0x01, 0x70, 0x7D, 0x05, 0x77, 0x10, 0x2B, 0x02, 0x71, 0x0E, 0xB0, 0xA4, 0x03,
  0xC0, 0x77, 0x10, 0xEC, 0x0E, 0x02, 0x77, 0x0D, 0xB7, 0x10, 0x6C, 0x04, 0x50, 0xDB, 0x0D, 0x71,
  0x05, 0xD0, 0xD0, 0x27, 0x50, 0xBB, 0x0B, 0x71, 0x0D, 0xB0, 0xD6, 0x07, 0xC0, 0x77, 0x10, 0x9D,
  0x0E, 0x05, 0x72, 0x03, 0x0D, 0xC0, 0x47, 0x05, 0xC0, 0x77, 0x0E, 0xB0, 0xE0, 0x17, 0x10, 0xBE,
  0x87, 0xC7, 0x31, 0x01, 0x26, 0xBD, 0x09, 0x71, 0x0D, 0xB0, 0xE0, 0x17, 0x07, 0xC0, 0x97, 0x20,
  0xBF, 0xFC, 0x0B, 0x71, 0x07, 0xC0, 0x77, 0x20, 0xDC, 0x05, 0x72, 0x07, 0xFF, 0xA0, 0x87, 0x10,
  0x3C, 0x0E, 0x73, 0x05, 0xC0, 0xE0, 0x27, 0x20, 0x20, 0xAF, 0xD0, 0xB0, 0x37, 0x10, 0x10, 0xDC,
  0x05, 0x74, 0x0A, 0xC0, 0xD0, 0x17, 0x38, 0x31, 0x69, 0xCE, 0xA8, 0x3E, 0xDA, 0x72, 0x73, 0x0B,
  0xC0, 0xA7, 0x60, 0xDC, 0x0D, 0x01, 0x77, 0x77, 0x20, 0xBC, 0x0D, 0x01, 0x76, 0x03, 0xD0, 0xD0,
  0x27, 0x77, 0x60, 0x10, 0xBD, 0x03, 0x77, 0x10, 0x4D, 0x0E, 0x05, 0x77, 0x74, 0x03, 0x0D, 0xD0,
  0x57, 0x73, 0x05, 0xE0, 0xB0, 0x27, 0x77, 0x01, 0x08, 0xE0, 0x57, 0x75, 0x05, 0x0E, 0xE0, 0x90,
  0x27, 0x73, 0x81, 0x16, 0xEE, 0x05, 0x77, 0x70, 0x20, 0xDF, 0x81, 0xC6, 0x27, 0x48, 0x11, 0x5A,
  0xF0, 0xD0, 0x37, 0x77, 0x20, 0x10, 0xAF, 0xA8, 0x91, 0xEB, 0x98, 0x76, 0x78, 0x9A, 0xDF, 0xA0,
  0xB0, 0x17, 0x77, 0x50, 0x50, 0xDF, 0xFF, 0xC0, 0xD0, 0x57, 0x77, 0x72, 0x06, 0x0D, 0xFF, 0xF0,
  0xD0, 0x67, 0x77, 0x76, 0x81, 0x49, 0xEF, 0xF9, 0x81, 0xE9, 0x48, 0x0C, 0x30, 0x84, 0x36, 0x9B,
  0xDE, 0xB8, 0x4E, 0xDB, 0x96, 0x37, 0x77,
  // "ª" (U+00AA)
  0x75, 0x82, 0x38, 0xBD, 0xA8, 0x2E, 0xB8, 0x23, 0x81, 0x46, 0x37, 0x40, 0x50, 0xDF, 0xB8, 0x1B,
  0x6D, 0xA0, 0x57, 0x20, 0x10, 0xBF, 0xFB, 0x01, 0x71, 0x03, 0x0E, 0xD8, 0x48, 0x20, 0x16, 0xEE,
  0x0D, 0x71, 0x03, 0x0E, 0xC0, 0xE0, 0x35, 0x02, 0x0E, 0xD0, 0x97, 0x02, 0x0E, 0xD0, 0x47, 0x0E,
  0xD0, 0x57, 0x0D, 0xD0, 0x77, 0x03, 0xE0, 0x26, 0x09, 0xD0, 0xC7, 0x10, 0x7D, 0x0D, 0x60, 0x3E,
  0x04, 0x71, 0x0B, 0xD0, 0xA6, 0x0C, 0xD0, 0xC7, 0x20, 0xED, 0x06, 0x50, 0x4E, 0x06, 0x71, 0x03,
  0xE0, 0x25, 0x0B, 0xE0, 0x17, 0x10, 0x7D, 0x0E, 0x50, 0x2E, 0x0A, 0x72, 0x0B, 0xD0, 0xA5, 0x07,
  0xE0, 0x67, 0x2E, 0x07, 0x50, 0xBE, 0x02, 0x71, 0x04, 0xE0, 0x35, 0xE0, 0xE7, 0x20, 0x9D, 0x0E,
  0x50, 0x3E, 0x0B, 0x72, 0x0E, 0xD0, 0xB5, 0x06, 0xE0, 0x97, 0x10, 0x6E, 0x07, 0x50, 0x7E, 0x07,
  0x71, 0x0C, 0xE0, 0x45, 0x08, 0xE0, 0x67, 0x05, 0xF0, 0x15, 0x09, 0xE0, 0x67, 0x81, 0xDF, 0xBC,
  0x0D, 0x60, 0x8E, 0x07, 0x68, 0x27, 0xFB, 0x8C, 0x0B, 0x60, 0x7E, 0x09, 0x50, 0x3A, 0x03, 0x0B,
  0xC0, 0xA6, 0x04, 0xE0, 0xD4, 0x84, 0x1D, 0xF8, 0x0E, 0xC0, 0xA7, 0xF0, 0x62, 0x82, 0x1C, 0xFC,
  0x2D, 0x0D, 0x30, 0x60, 0xA2, 0x0A, 0xF8, 0x49, 0x9E, 0xFE, 0x22, 0xE8, 0x1B, 0x8D, 0xA8, 0x12,
  0x03, 0xFC, 0x03, 0x30, 0xDF, 0xA0, 0x73, 0x08, 0xF9, 0x0E, 0x03, 0x40, 0x7F, 0x0E, 0x05, 0x50,
  0x70, 0xED, 0x09, 0x01, 0x60, 0xAD, 0x0A, 0x02, 0x71, 0x83, 0x56, 0x75, 0x17, 0x28, 0x33, 0x67,
  0x51, 0x50,
  // "«" (U+00AB)
  0x77, 0x10, 0x4B, 0x0E, 0x01, 0x71, 0x01, 0x0D, 0xB0, 0x57, 0x70, 0x30, 0xEB, 0x05, 0x71, 0x01,
  0x0C, 0xB0, 0xA7, 0x70, 0x30, 0xEB, 0x0A, 0x72, 0x0C, 0xB0, 0xE0, 0x17, 0x60, 0x30, 0xEB, 0x0E,
  0x01, 0x71, 0x0C, 0xC0, 0x57, 0x60, 0x20, 0xEC, 0x05, 0x71, 0x0B, 0xC0, 0xA7, 0x60, 0x20, 0xEC,
  0x0A, 0x71, 0x0B, 0xC0, 0xE0, 0x17, 0x50, 0x20, 0xDC, 0x0E, 0x01, 0x70, 0xAD, 0x05, 0x75, 0x01,
  0x0D, 0xD0, 0x57, 0x0A, 0xD0, 0xA7, 0x50, 0x10, 0xDD, 0x0A, 0x70, 0x9D, 0x0E, 0x01, 0x74, 0x01,
  0x0C, 0xD0, 0xE0, 0x16, 0x09, 0xE0, 0x57, 0x40, 0x10, 0xCE, 0x05, 0x60, 0x8E, 0x0A, 0x75, 0x0C,
  0xE0, 0xA6, 0x08, 0xE0, 0xE0, 0x17, 0x40, 0xBE, 0x0E, 0x01, 0x50, 0x7F, 0x05, 0x74, 0x0B, 0xF0,
  0x55, 0x07, 0xF0, 0xA7, 0x40, 0xBF, 0x0A, 0x50, 0x6F, 0x0E, 0x01, 0x73, 0x0A, 0xF0, 0xE0, 0x14,
  0x05, 0xF9, 0x05, 0x73, 0x02, 0xF9, 0x05, 0x50, 0xDF, 0x0A, 0x74, 0x05, 0xF0, 0xC5, 0x01, 0xF9,
  0x01, 0x74, 0x07, 0xF0, 0xE5, 0x04, 0xF9, 0x03, 0x74, 0x01, 0x0E, 0xF0, 0x35, 0x0C, 0xF0, 0x77,
  0x50, 0x7F, 0x07, 0x50, 0x4F, 0x0B, 0x76, 0x0D, 0xE0, 0xB6, 0x0B, 0xF7, 0x60, 0x5E, 0x0E, 0x60,
  0x2F, 0x04, 0x76, 0x0C, 0xE0, 0x36, 0x09, 0xE0, 0x87, 0x60, 0x4E, 0x07, 0x60, 0x10, 0xED, 0x0C,
  0x77, 0x0B, 0xD0, 0xC7, 0x07, 0xE0, 0x17, 0x60, 0x2E, 0x71, 0x0E, 0xD0, 0x57, 0x70, 0x9D, 0x04,
  0x70, 0x6D, 0x09, 0x77, 0x01, 0xD0, 0x87, 0x10, 0xDC, 0x0D, 0x77, 0x10, 0x8C, 0x0C, 0x71, 0x04,
  0xD0, 0x27, 0x71, 0x0E, 0xC0, 0x17, 0x10, 0xBC, 0x06, 0x77, 0x10, 0x6C, 0x05, 0x71, 0x03, 0xC0,
  0xA7, 0x72, 0x0D, 0xB0, 0x97, 0x20, 0xAB, 0x0E, 0x77, 0x20, 0x5B, 0x0D, 0x72, 0x02, 0xC0, 0x27,
  // "¬" (U+00AC)
  0x09, 0xFF, 0xFF, 0xC0, 0x50, 0x9F, 0xFF, 0xFC, 0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x50, 0x9F, 0xFF,
  0xFC, 0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x57, 0x77, 0x70, 0xDC, 0x05, 0x77, 0x77, 0x0D, 0xC0, 0x57,
  0x77, 0x70, 0xDC, 0x05, 0x77, 0x77, 0x0D, 0xC0, 0x57, 0x77, 0x70, 0xDC, 0x05, 0x77, 0x77, 0x0D,
  0xC0, 0x57, 0x77, 0x70, 0xDC, 0x05, 0x77, 0x77, 0x0D, 0xC0, 0x57, 0x77, 0x70, 0xDC, 0x05, 0x77,
  0x77, 0x0D, 0xC0, 0x57, 0x77, 0x70, 0xDC, 0x05, 0x77, 0x77, 0x0D, 0xC0, 0x57, 0x77, 0x70, 0xDC,
  0x05, 0x77, 0x77, 0x0D, 0xC0, 0x57, 0x77, 0x70, 0xDC, 0x05, 0x77, 0x77, 0x0D, 0xC0, 0x57, 0x77,
  0x70, 0xDC, 0x05, 0x77, 0x77, 0x0D, 0xC0, 0x57, 0x77, 0x78, 0x46, 0x77, 0x77, 0x20,
  // "®" (U+00AE)
  0x77, 0x78, 0x52, 0x69, 0xBD, 0xEE, 0xA8, 0x4E, 0xDB, 0x96, 0x38, 0x0C, 0x30, 0x81, 0x49, 0xEF,
  0xF9, 0x81, 0xEA, 0x47, 0x77, 0x76, 0x06, 0x0D, 0xFF, 0xF0, 0xD0, 0x77, 0x77, 0x72, 0x04, 0x0D,
  0xFF, 0xFC, 0x0E, 0x05, 0x77, 0x76, 0x0A, 0xFA, 0x89, 0x1E, 0xB9, 0x87, 0x67, 0x89, 0xBE, 0xFA,
  0x0B, 0x01, 0x77, 0x72, 0x02, 0x0D, 0xF8, 0x1B, 0x62, 0x74, 0x81, 0x15, 0xAF, 0x0D, 0x03, 0x77,
  0x70, 0x40, 0xEE, 0x08, 0x02, 0x77, 0x38, 0x11, 0x7E, 0xE0, 0x57, 0x75, 0x04, 0xE0, 0xA0, 0x17,
  0x77, 0x01, 0x09, 0xE0, 0x57, 0x73, 0x04, 0xD0, 0xE0, 0x47, 0x77, 0x40, 0x30, 0xDD, 0x05, 0x77,
  0x10, 0x30, 0xEC, 0x0C, 0x02, 0x77, 0x76, 0x01, 0x0B, 0xD0, 0x37, 0x70, 0xDC, 0x0C, 0x77, 0x77,
  0x30, 0xBC, 0x0D, 0x01, 0x75, 0x09, 0xC0, 0xC0, 0x17, 0x77, 0x74, 0x0C, 0xC0, 0xA7, 0x40, 0x5C,
  0x0D, 0x01, 0x77, 0x77, 0x50, 0x10, 0xDC, 0x05, 0x73, 0x0D, 0xC0, 0x47, 0x77, 0x77, 0x03, 0xC0,
  0xE7, 0x20, 0x7C, 0x08, 0x40, 0x9F, 0xE8, 0x4E, 0xED, 0xB8, 0x57, 0x60, 0x8C, 0x07, 0x70, 0x10,
  0xEB, 0x0D, 0x50, 0x9F, 0xFD, 0x81, 0xE9, 0x27, 0x40, 0xDB, 0x0E, 0x01, 0x60, 0x7C, 0x05, 0x58,
  0x25, 0x8A, 0xEF, 0xFD, 0x07, 0x73, 0x05, 0xC0, 0x76, 0x0D, 0xB0, 0xD7, 0x30, 0x9D, 0x05, 0x48,
  0x22, 0x48, 0xED, 0x08, 0x73, 0x0D, 0xB0, 0xD5, 0x04, 0xC0, 0x57, 0x30, 0x1D, 0x05, 0x71, 0x09,
  0xD0, 0x57, 0x20, 0x6C, 0x04, 0x40, 0xAB, 0x0E, 0x75, 0xD0, 0x57, 0x20, 0xBC, 0x0D, 0x73, 0x0E,
  0xB0, 0xA4, 0x0E, 0xB0, 0x97, 0x50, 0xEC, 0x05, 0x72, 0x03, 0xD0, 0x47, 0x20, 0xAB, 0x0E, 0x30,
  0x3C, 0x04, 0x75, 0x0E, 0xC0, 0x57, 0x30, 0xEC, 0x09, 0x72, 0x04, 0xC0, 0x32, 0x07, 0xC7, 0x60,
  0xEC, 0x05, 0x73, 0x0B, 0xC0, 0xB7, 0x3C, 0x07, 0x20, 0xBB, 0x0B, 0x76, 0x0E, 0xC0, 0x57, 0x30,
  0x9C, 0x0D, 0x73, 0x0B, 0xB0, 0xB2, 0xC0, 0x77, 0x60, 0xEC, 0x05, 0x73, 0x09, 0xC0, 0xD7, 0x30,
  0x8B, 0x81, 0xE0, 0x1C, 0x04, 0x76, 0x0E, 0xC0, 0x57, 0x30, 0x9C, 0x0C, 0x73, 0x04, 0xC0, 0x10,
  0x4C, 0x02, 0x76, 0x0E, 0xC0, 0x57, 0x30, 0xBC, 0x0A, 0x73, 0x02, 0xC0, 0x40, 0x6C, 0x77, 0x0E,
  0xC0, 0x57, 0x30, 0xEC, 0x07, 0x74, 0xC0, 0x60, 0x8B, 0x0D, 0x77, 0x0E, 0xC0, 0x57, 0x20, 0x4D,
  0x02, 0x74, 0x0D, 0xB0, 0x80, 0x9B, 0x0C, 0x77, 0x0E, 0xC0, 0x57, 0x20, 0xBC, 0x09, 0x75, 0x0C,
  0xB0, 0x90, 0xAB, 0x0B, 0x77, 0x0E, 0xC0, 0x57, 0x10, 0x9C, 0x0D, 0x76, 0x0B, 0xB0, 0x90, 0xAB,
  0x0A, 0x77, 0x0E, 0xC0, 0x54, 0x82, 0x14, 0x8D, 0xC0, 0xC0, 0x17, 0x60, 0xBB, 0x0A, 0x0B, 0xB0,
  0xA7, 0x70, 0xEF, 0xFA, 0x08, 0x77, 0x10, 0xAB, 0x00, 0xBB, 0x0A, 0x77, 0x0E, 0xFF, 0x09, 0x02,
  0x77, 0x20, 0xAB, 0x0B, 0x0A, 0xB0, 0xB7, 0x70, 0xEF, 0xF0, 0x37, 0x73, 0x0B, 0xB0, 0x0A, 0xB0,
  0xB7, 0x70, 0xEC, 0x05, 0x40, 0xCC, 0x0A, 0x77, 0x30, 0xBB, 0x00, 0x9B, 0x0C, 0x77, 0x0E, 0xC0,
  0x54, 0x05, 0xD0, 0x37, 0x72, 0x0C, 0xB0, 0x90, 0x8B, 0x0D, 0x77, 0x0E, 0xC0, 0x55, 0x0D, 0xC0,
  0xB7, 0x72, 0x0D, 0xB0, 0x80, 0x6C, 0x77, 0x0E, 0xC0, 0x55, 0x06, 0xD0, 0x37, 0x71, 0xC0, 0x60,
  0x4C, 0x02, 0x76, 0x0E, 0xC0, 0x56, 0x0D, 0xC0, 0xB7, 0x70, 0x2C, 0x03, 0x01, 0xC0, 0x47, 0x60,
  0xEC, 0x05, 0x60, 0x7D, 0x03, 0x76, 0x04, 0xC8, 0x11, 0x0E, 0xB0, 0x87, 0x60, 0xEC, 0x05, 0x70,
  0xEC, 0x0B, 0x76, 0x08, 0xB0, 0xE2, 0x0B, 0xB0, 0xC7, 0x60, 0xEC, 0x05, 0x70, 0x7D, 0x03, 0x75,
  0x0C, 0xB0, 0xB2, 0x07, 0xC7, 0x60, 0xEC, 0x05, 0x70, 0x10, 0xEC, 0x0B, 0x75, 0xC0, 0x72, 0x03,
  0xC0, 0x47, 0x50, 0xEC, 0x05, 0x71, 0x08, 0xD0, 0x37, 0x30, 0x4C, 0x03, 0x30, 0xEB, 0x0A, 0x75,
  0x0E, 0xC0, 0x57, 0x10, 0x1D, 0x0B, 0x73, 0x0A, 0xB0, 0xE4, 0x09, 0xC0, 0x17, 0x40, 0xEC, 0x05,
  0x72, 0x09, 0xD0, 0x37, 0x20, 0xEB, 0x0A, 0x40, 0x3C, 0x07, 0x74, 0xD0, 0x67, 0x20, 0x2D, 0x0B,
  0x71, 0x06, 0xC0, 0x45, 0x0D, 0xB0, 0xD7, 0x30, 0x4D, 0x0A, 0x73, 0x0A, 0xD0, 0x57, 0x0D, 0xB0,
  0xD6, 0x07, 0xC0, 0x77, 0x81, 0x16, 0xDE, 0x09, 0x03, 0x71, 0x02, 0xD8, 0x1E, 0x61, 0x40, 0x5C,
  0x07, 0x70, 0xEB, 0x0E, 0x01, 0x40, 0x9F, 0xF0, 0x36, 0x0B, 0xF9, 0x30, 0xDB, 0x0E, 0x01, 0x70,
  0x7C, 0x09, 0x40, 0x9F, 0xF0, 0x36, 0x03, 0xF9, 0x20, 0x7C, 0x07, 0x72, 0x0D, 0xC0, 0x53, 0x08,
  0x80, 0x92, 0xD0, 0x27, 0x0A, 0x80, 0x3D, 0x10, 0x3C, 0x0E, 0x73, 0x05, 0xC0, 0xE0, 0x27, 0x77,
  0x75, 0x01, 0x0D, 0xC0, 0x57, 0x40, 0xAC, 0x0D, 0x01, 0x77, 0x77, 0x40, 0xBC, 0x0A, 0x76, 0x0D,
  0xC0, 0xD0, 0x17, 0x77, 0x72, 0x0B, 0xC0, 0xD0, 0x17, 0x60, 0x3D, 0x0D, 0x02, 0x77, 0x76, 0x01,
  0x0B, 0xD0, 0x37, 0x71, 0x04, 0xD0, 0xE0, 0x57, 0x77, 0x40, 0x30, 0xDD, 0x05, 0x77, 0x30, 0x5E,
  0x0B, 0x02, 0x77, 0x70, 0x10, 0x8E, 0x05, 0x77, 0x50, 0x50, 0xEE, 0x09, 0x02, 0x77, 0x38, 0x11,
  0x6E, 0xE0, 0x57, 0x77, 0x02, 0x0D, 0xF8, 0x1C, 0x62, 0x74, 0x81, 0x15, 0xAF, 0x0D, 0x03, 0x77,
  0x72, 0x01, 0x0A, 0xFA, 0x89, 0x1E, 0xB9, 0x87, 0x67, 0x89, 0xAD, 0xFA, 0x0B, 0x01, 0x77, 0x75,
  0x05, 0x0D, 0xFF, 0xFC, 0x0D, 0x05, 0x77, 0x77, 0x20, 0x60, 0xDF, 0xFF, 0x0D, 0x06, 0x77, 0x77,
  0x68, 0x14, 0x9E, 0xFF, 0x98, 0x1E, 0x94, 0x80, 0xC3, 0x08, 0x43, 0x69, 0xBD, 0xEB, 0x84, 0xED,
  0xB9, 0x63, 0x77, 0x70,
  // "¯" (U+00AF)
  0x10, 0x28, 0x0C, 0x0F, 0x81, 0x20, 0x5F, 0xFF, 0xFF, 0x0D, 0x20, 0x9F, 0xFF, 0xFF, 0x0A, 0x20,
  0xDF, 0xFF, 0xFF, 0x81, 0x60, 0x18, 0x0C, 0x0F, 0x03, 0x10,
  // "°" (U+00B0)
  0x78, 0x90, 0x27, 0xBD, 0xEE, 0xDB, 0x61, 0x75, 0x01, 0x0A, 0xFB, 0x08, 0x73, 0x03, 0x0E, 0xFD,
  0x0D, 0x02, 0x70, 0x30, 0xEF, 0xF0, 0xE0, 0x25, 0x01, 0x0D, 0xD8, 0x4D, 0x87, 0x78, 0xDD, 0x0D,
  0x50, 0x9C, 0x0D, 0x04, 0x60, 0x40, 0xDC, 0x08, 0x30, 0x2C, 0x0D, 0x01, 0x71, 0x01, 0x0D, 0xC0,
  0x12, 0x08, 0xC0, 0x37, 0x30, 0x3C, 0x07, 0x20, 0xDB, 0x09, 0x75, 0x0A, 0xB8, 0x1D, 0x01, 0xC0,
  0x37, 0x50, 0x4C, 0x01, 0x04, 0xC7, 0x7C, 0x04, 0x06, 0xB0, 0xC7, 0x70, 0xCB, 0x06, 0x07, 0xB0,
  0xB7, 0x70, 0xBB, 0x07, 0x08, 0xB0, 0xA7, 0x70, 0xAB, 0x08, 0x07, 0xB0, 0xB7, 0x70, 0xBB, 0x07,
  0x06, 0xB0, 0xC7, 0x70, 0xCB, 0x06, 0x05, 0xC7, 0x7C, 0x05, 0x02, 0xC0, 0x47, 0x50, 0x4C, 0x81,
  0x10, 0xEB, 0x0A, 0x75, 0x0A, 0xB0, 0xD2, 0x08, 0xC0, 0x37, 0x30, 0x3C, 0x08, 0x20, 0x2C, 0x0D,
  0x01, 0x71, 0x01, 0x0D, 0xC0, 0x13, 0x0A, 0xC0, 0xD0, 0x46, 0x04, 0x0D, 0xC0, 0x94, 0x01, 0x0E,
  0xD8, 0x4C, 0x87, 0x68, 0xCD, 0x0D, 0x60, 0x4F, 0xF9, 0x0E, 0x03, 0x70, 0x40, 0xEF, 0xD0, 0xE0,
  0x27, 0x20, 0x20, 0xAF, 0xB0, 0x90, 0x17, 0x58, 0x90, 0x27, 0xBD, 0xFE, 0xDB, 0x61, 0x70,
  // "±" (U+00B1)
  0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC,
  0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77,
  0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0,
  0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77,
  0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x70, 0x9F, 0xFF, 0xFC,
  0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x50, 0x9F, 0xFF, 0xFC, 0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x50, 0x9F,
  0xFF, 0xFC, 0x05, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77,
  0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B,
  0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77,
  0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC,
  0x07, 0x77, 0x77, 0x0B, 0xC0, 0x77, 0x77, 0x70, 0xBC, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x78, 0x0C,
  0xB2, 0x00, 0x9F, 0xFF, 0xFC, 0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x50, 0x9F, 0xFF, 0xFC, 0x05, 0x09,
  0xFF, 0xFF, 0xC0, 0x50, 0x9F, 0xFF, 0xFC, 0x05,
  // "²" (U+00B2)
  0x77, 0x89, 0x03, 0x69, 0xAB, 0xBA, 0x85, 0x17, 0x73, 0x06, 0x0D, 0xFB, 0x09, 0x01, 0x76, 0x03,
  0x0D, 0xFE, 0x0E, 0x04, 0x74, 0x04, 0xFF, 0xB0, 0x37, 0x20, 0x3E, 0x84, 0xE6, 0x10, 0x29, 0xE0,
  0xD7, 0x20, 0xCD, 0x0D, 0x02, 0x50, 0xBE, 0x06, 0x70, 0x4E, 0x03, 0x60, 0x4E, 0x0B, 0x70, 0x9D,
  0x0A, 0x71, 0x0E, 0xD0, 0xE7, 0x0B, 0xD0, 0x27, 0x10, 0xCE, 0x70, 0xAC, 0x0C, 0x72, 0x0B, 0xE7,
  0x06, 0xC0, 0x77, 0x20, 0xCD, 0x0D, 0x71, 0x0B, 0xB0, 0x37, 0x20, 0xED, 0x0A, 0x72, 0x81, 0x6C,
  0xE7, 0x20, 0x1E, 0x06, 0x77, 0x70, 0x5E, 0x01, 0x77, 0x70, 0xBD, 0x0A, 0x77, 0x70, 0x1E, 0x02,
  0x77, 0x70, 0x9D, 0x08, 0x77, 0x70, 0x2D, 0x0C, 0x77, 0x71, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x07,
  0xD0, 0x47, 0x77, 0x04, 0xD0, 0x57, 0x77, 0x02, 0x0E, 0xC0, 0x67, 0x77, 0x01, 0x0D, 0xC0, 0x77,
  0x77, 0x01, 0x0D, 0xC0, 0x77, 0x77, 0x01, 0x0D, 0xC0, 0x67, 0x77, 0x01, 0x0D, 0xC0, 0x57, 0x77,
  0x02, 0x0D, 0xC0, 0x47, 0x77, 0x02, 0x0D, 0xB0, 0xE0, 0x37, 0x77, 0x03, 0x0E, 0xB0, 0xD0, 0x27,
  0x77, 0x03, 0x0E, 0xB0, 0xD0, 0x27, 0x18, 0x22, 0x99, 0x37, 0x20, 0x40, 0xEB, 0x0C, 0x01, 0x72,
  0x09, 0xA0, 0x37, 0x10, 0x4C, 0x0B, 0x74, 0x0E, 0xA7, 0x10, 0x5C, 0x0A, 0x74, 0x06, 0xA0, 0xB7,
  0x05, 0xC0, 0x97, 0x40, 0x10, 0xEA, 0x08, 0x60, 0x6C, 0x07, 0x74, 0x04, 0x0D, 0xB0, 0x45, 0x07,
  0xFF, 0xF9, 0x50, 0x8F, 0xFF, 0x90, 0xC4, 0x01, 0xFF, 0xFA, 0x08, 0x40, 0x5F, 0xFF, 0xA0, 0x54,
  0x08, 0xFF, 0xFA, 0x01, 0x40,
  // "³" (U+00B3)
  0x76, 0x89, 0x15, 0x8B, 0xDE, 0xFE, 0xDC, 0x95, 0x77, 0x28, 0x11, 0x9E, 0xFC, 0x0E, 0x07, 0x76,
  0x05, 0x0E, 0xFF, 0x90, 0xB7, 0x40, 0x7F, 0x98, 0x1D, 0xCE, 0xF0, 0xA7, 0x20, 0x4E, 0x81, 0xE7,
  0x13, 0x05, 0x0E, 0xE0, 0x57, 0x10, 0xCE, 0x03, 0x60, 0x6E, 0x0B, 0x70, 0x2E, 0x08, 0x71, 0xF7,
  0x04, 0xD0, 0xE0, 0x17, 0x10, 0xDE, 0x02, 0x60, 0x3D, 0x08, 0x72, 0x0D, 0xE0, 0x27, 0x0D, 0xC0,
  0x47, 0x20, 0xEE, 0x71, 0x02, 0x0B, 0xA0, 0xE7, 0x20, 0x2E, 0x0D, 0x73, 0x81, 0x13, 0x37, 0x20,
  0x6E, 0x09, 0x77, 0x71, 0x0D, 0xE0, 0x37, 0x77, 0x08, 0xE0, 0xA7, 0x77, 0x06, 0xE0, 0xC7, 0x77,
  0x09, 0xE0, 0xA7, 0x75, 0x81, 0x27, 0xED, 0x0D, 0x05, 0x77, 0x18, 0x37, 0xCC, 0xCE, 0xE0, 0xD0,
  0x67, 0x73, 0x0C, 0xF9, 0x08, 0x03, 0x77, 0x50, 0xEF, 0x98, 0x1D, 0x93, 0x77, 0x30, 0x2F, 0xD0,
  0xB0, 0x27, 0x75, 0x82, 0x13, 0x7E, 0xE0, 0xE0, 0x37, 0x77, 0x10, 0xBE, 0x0D, 0x01, 0x77, 0x71,
  0x0C, 0xE0, 0x87, 0x77, 0x10, 0x4E, 0x0E, 0x77, 0x72, 0x0D, 0xE0, 0x37, 0x77, 0x10, 0xAE, 0x05,
  0x77, 0x71, 0x08, 0xE0, 0x66, 0x81, 0x49, 0x57, 0x60, 0x8E, 0x05, 0x50, 0xAA, 0x09, 0x76, 0x09,
  0xE0, 0x34, 0x08, 0xB0, 0xB7, 0x60, 0xCE, 0x01, 0x40, 0xEB, 0x0E, 0x75, 0x01, 0xE0, 0xC4, 0x01,
  0xD0, 0x57, 0x40, 0x7E, 0x06, 0x40, 0x1D, 0x0C, 0x73, 0x02, 0x0E, 0xD0, 0xD6, 0xE0, 0x97, 0x10,
  0x30, 0xDE, 0x04, 0x60, 0xAE, 0x0A, 0x02, 0x40, 0x30, 0x9F, 0x06, 0x70, 0x20, 0xEF, 0x82, 0xEC,
  0xCE, 0xF0, 0xE0, 0x57, 0x20, 0x30, 0xEF, 0xFA, 0x0B, 0x02, 0x74, 0x02, 0x0A, 0xFE, 0x0A, 0x04,
  0x77, 0x18, 0x31, 0x6A, 0xCE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x50,
  // "´" (U+00B4)
  0x72, 0x80, 0x57, 0x01, 0x71, 0x06, 0xF9, 0x0D, 0x72, 0x0E, 0xF0, 0xE0, 0x27, 0x10, 0x8F, 0x90,
  0x47, 0x10, 0x2F, 0x90, 0x57, 0x20, 0xCF, 0x06, 0x72, 0x06, 0xF0, 0x77, 0x20, 0x10, 0xEE, 0x07,
  0x73, 0x0B, 0xE0, 0x77, 0x30, 0x7E, 0x06, 0x73, 0x02, 0xE0, 0x57, 0x40, 0xDC, 0x0E, 0x03, 0x74,
  0x0A, 0xC0, 0xC0, 0x27, 0x40, 0x6C, 0x0A, 0x76, 0x0C, 0xA0, 0xE0, 0x57, 0x70,
  // "µ" (U+00B5)
  0x77, 0x0A, 0xF0, 0x67, 0x71, 0x0E, 0xF0, 0x27, 0x70, 0xEF, 0x03, 0x77, 0x02, 0xF0, 0xE7, 0x70,
  0x1F, 0x0E, 0x77, 0x10, 0x5F, 0x0B, 0x77, 0x05, 0xF0, 0xB7, 0x71, 0x08, 0xF0, 0x77, 0x70, 0x8F,
  0x08, 0x77, 0x10, 0xCF, 0x04, 0x77, 0x0B, 0xF0, 0x57, 0x71, 0xF9, 0x01, 0x77, 0x0E, 0xF0, 0x17,
  0x70, 0x3F, 0x0D, 0x77, 0x02, 0xF0, 0xE7, 0x71, 0x06, 0xF0, 0x97, 0x70, 0x6F, 0x0A, 0x77, 0x10,
  0x9F, 0x06, 0x77, 0x09, 0xF0, 0x77, 0x71, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x04, 0x77, 0x1F, 0x97,
  0x71, 0xF9, 0x77, 0x10, 0x3F, 0x0B, 0x77, 0x03, 0xF0, 0xD7, 0x71, 0x07, 0xF0, 0x87, 0x70, 0x7F,
  0x09, 0x77, 0x10, 0xAF, 0x05, 0x77, 0x0A, 0xF0, 0x67, 0x71, 0x0D, 0xF0, 0x17, 0x70, 0xDF, 0x03,
  0x77, 0x01, 0xF0, 0xD7, 0x70, 0x1F, 0x0E, 0x77, 0x10, 0x4F, 0x0A, 0x77, 0x04, 0xF0, 0xB7, 0x71,
  0x08, 0xF0, 0x77, 0x70, 0x8F, 0x08, 0x77, 0x10, 0xBF, 0x03, 0x77, 0x0B, 0xF0, 0x57, 0x71, 0x0E,
  0xF7, 0x71, 0x0E, 0xF0, 0x17, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xE7, 0x71, 0x05, 0xF0, 0x97,
  0x70, 0x5F, 0x0A, 0x77, 0x10, 0x8F, 0x05, 0x77, 0x08, 0xF0, 0x77, 0x71, 0x0C, 0xF0, 0x27, 0x70,
  0xCF, 0x04, 0x77, 0x1F, 0x0E, 0x77, 0x1F, 0x90, 0x17, 0x70, 0x3F, 0x0B, 0x77, 0x03, 0xF0, 0xD7,
  0x71, 0x06, 0xF0, 0x77, 0x70, 0x6F, 0x09, 0x77, 0x10, 0x9F, 0x04, 0x77, 0x09, 0xF0, 0x67, 0x71,
  0x0D, 0xF0, 0x17, 0x70, 0xDF, 0x03, 0x77, 0x01, 0xF0, 0xD7, 0x71, 0xF9, 0x77, 0x10, 0x5F, 0x0A,
  0x77, 0x04, 0xF0, 0xD7, 0x71, 0x0A, 0xF0, 0x67, 0x70, 0x7F, 0x0B, 0x77, 0x10, 0xEF, 0x02, 0x77,
  0x0B, 0xF0, 0x97, 0x70, 0x5F, 0x0E, 0x77, 0x10, 0xEF, 0x07, 0x77, 0x0C, 0xF0, 0xC7, 0x70, 0x2F,
  0x90, 0x77, 0x60, 0x3F, 0x90, 0x97, 0x70, 0x6F, 0x90, 0x67, 0x60, 0xBF, 0x90, 0x67, 0x70, 0x9F,
  0x90, 0x77, 0x50, 0x5F, 0xA0, 0x47, 0x70, 0xDF, 0x90, 0x97, 0x40, 0x10, 0xEF, 0xA0, 0x27, 0x60,
  0x1F, 0xA0, 0xD7, 0x40, 0xCF, 0xB0, 0x17, 0x60, 0x5F, 0xB0, 0x37, 0x20, 0xBA, 0x0B, 0x09, 0xF0,
  0x17, 0x60, 0x9F, 0xB0, 0xC7, 0x02, 0x0C, 0xA8, 0x1E, 0x29, 0xF0, 0x45, 0x03, 0x70, 0xEB, 0x0E,
  0xF8, 0x5D, 0x51, 0x01, 0x49, 0xC8, 0x16, 0x08, 0xF8, 0x6C, 0x20, 0x26, 0xDE, 0x15, 0x02, 0xC0,
  0x80, 0xEF, 0xFA, 0x0A, 0x20, 0x6F, 0xF0, 0x75, 0x06, 0xC0, 0x40, 0x8F, 0xF9, 0x0C, 0x30, 0x3F,
  0xF0, 0xD5, 0x0B, 0xC8, 0x11, 0x0D, 0xFE, 0x0C, 0x01, 0x40, 0xDF, 0xD0, 0xD0, 0x35, 0xC0, 0xD2,
  0x02, 0x0E, 0xFC, 0x0B, 0x01, 0x50, 0x6F, 0xC0, 0xA0, 0x15, 0x04, 0xC0, 0xA3, 0x02, 0x0B, 0xF9,
  0x0E, 0x07, 0x71, 0x0A, 0xF9, 0x0D, 0x05, 0x70, 0x8C, 0x07, 0x58, 0x74, 0x9D, 0xEF, 0xEB, 0x71,
  0x73, 0x86, 0x5B, 0xEF, 0xEC, 0x95, 0x72, 0x0C, 0xC0, 0x48, 0x0C, 0x40, 0x01, 0xD0, 0x18, 0x0C,
  0x40, 0x05, 0xD8, 0x0C, 0x50, 0x09, 0xC0, 0xD8, 0x0C, 0x50, 0x0D, 0xC0, 0xB8, 0x0C, 0x40, 0x02,
  0xD0, 0xA8, 0x0C, 0x40, 0x06, 0xD0, 0x98, 0x0C, 0x40, 0x09, 0xD0, 0x98, 0x0C, 0x40, 0x0D, 0xD0,
  0x98, 0x0C, 0x40, 0xE0, 0xB8, 0x0C, 0x30, 0x03, 0xE0, 0xD8, 0x0C, 0x30, 0x05, 0xF0, 0x38, 0x0C,
  0x20, 0x07, 0xF0, 0x98, 0x0C, 0x20, 0x08, 0xF9, 0x08, 0x80, 0xC1, 0x00, 0x9F, 0xA0, 0xD0, 0x77,
  0x77, 0x77, 0x09, 0xFB, 0x09, 0x77, 0x77, 0x70, 0x8F, 0xB0, 0x37, 0x77, 0x77, 0x06, 0xFA, 0x0A,
  0x80, 0xC0, 0x00, 0x2F, 0x90, 0xB8, 0x0C, 0x20, 0x09, 0xE0, 0x88, 0x0C, 0x40, 0x84, 0x7D, 0xFD,
  0x92, 0x80, 0xC3, 0x00,
  // "¶" (U+00B6)
  0x71, 0x83, 0x26, 0xAC, 0xEF, 0xFF, 0xFF, 0x09, 0x60, 0x30, 0xB8, 0x0C, 0x4F, 0x09, 0x50, 0x98,
  0x0C, 0x6F, 0x09, 0x40, 0xA8, 0x0C, 0x3F, 0x83, 0xEB, 0x99, 0x53, 0x07, 0xFF, 0xF9, 0x80, 0x46,
  0x0A, 0xF0, 0x90, 0x37, 0x02, 0xFF, 0xFA, 0x71, 0x06, 0xE0, 0x57, 0x20, 0xAF, 0xFF, 0xA7, 0x10,
  0x6D, 0x0B, 0x72, 0x01, 0xFF, 0xFB, 0x71, 0x06, 0xD0, 0x67, 0x20, 0x7F, 0xFF, 0xB7, 0x10, 0x6D,
  0x03, 0x72, 0x0C, 0xFF, 0xFB, 0x71, 0x06, 0xD0, 0x27, 0x2F, 0xFF, 0xC7, 0x10, 0x6D, 0x01, 0x71,
  0x03, 0xFF, 0xFC, 0x71, 0x06, 0xD0, 0x17, 0x10, 0x5F, 0xFF, 0xC7, 0x10, 0x6D, 0x01, 0x71, 0x07,
  0xFF, 0xFC, 0x71, 0x06, 0xD0, 0x17, 0x10, 0x8F, 0xFF, 0xC7, 0x10, 0x6D, 0x01, 0x71, 0x08, 0xFF,
  0xFC, 0x71, 0x06, 0xD0, 0x17, 0x10, 0x8F, 0xFF, 0xC7, 0x10, 0x6D, 0x01, 0x71, 0x08, 0xFF, 0xFC,
  0x71, 0x06, 0xD0, 0x17, 0x10, 0x7F, 0xFF, 0xC7, 0x10, 0x6D, 0x01, 0x71, 0x05, 0xFF, 0xFC, 0x71,
  0x06, 0xD0, 0x17, 0x10, 0x3F, 0xFF, 0xC7, 0x10, 0x6D, 0x01, 0x71, 0x01, 0xFF, 0xFC, 0x71, 0x06,
  0xD0, 0x17, 0x20, 0xDF, 0xFF, 0xB7, 0x10, 0x6D, 0x01, 0x72, 0x09, 0xFF, 0xFB, 0x71, 0x06, 0xD0,
  0x17, 0x20, 0x4F, 0xFF, 0xB7, 0x10, 0x6D, 0x01, 0x73, 0x0E, 0xFF, 0xFA, 0x71, 0x06, 0xD0, 0x17,
  0x30, 0x7F, 0xFF, 0xA7, 0x10, 0x6D, 0x01, 0x74, 0x0E, 0xFF, 0xF9, 0x71, 0x06, 0xD0, 0x17, 0x40,
  0x4F, 0xFF, 0x97, 0x10, 0x6D, 0x01, 0x75, 0x07, 0xFF, 0xF7, 0x10, 0x6D, 0x01, 0x76, 0x07, 0xFF,
  0xE7, 0x10, 0x6D, 0x01, 0x77, 0x04, 0x0D, 0xFF, 0xC7, 0x10, 0x6D, 0x01, 0x77, 0x28, 0x15, 0xAE,
  0xFF, 0x97, 0x10, 0x6D, 0x01, 0x77, 0x50, 0x10, 0x38, 0x03, 0x40, 0x9D, 0x71, 0x06, 0xD0, 0x17,
  0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70,
  0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71,
  0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0,
  0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77,
  0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D,
  0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06,
  0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17,
  0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70,
  0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71,
  0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0,
  0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77,
  0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D,
  0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06,
  0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17,
  0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70, 0x6D, 0x71, 0x06, 0xD0, 0x17, 0x77, 0x70,
  0x7D, 0x71, 0x06, 0xD0, 0x27, 0x77, 0x70, 0x9D, 0x71, 0x06, 0xD0, 0x37, 0x77, 0x70, 0xDD, 0x71,
  0x06, 0xD0, 0x77, 0x77, 0x60, 0x4E, 0x71, 0x06, 0xD0, 0xD7, 0x77, 0x50, 0x30, 0xDE, 0x71, 0x06,
  0xE0, 0xA0, 0x17, 0x76, 0x82, 0x13, 0x6B, 0xF9, 0x71, 0x06, 0xF8, 0x2E, 0x95, 0x27, 0x71, 0xFF,
  0x71, 0x06, 0xFE, 0x09, 0x75, 0xFF, 0x71, 0x06, 0xFE, 0x09, 0x75, 0xFF, 0x71, 0x06, 0xFE, 0x09,
  0x75, 0xFF, 0x71, 0x06, 0xFE, 0x09,
  // "·" (U+00B7)
  0x38, 0x44, 0xBE, 0xFC, 0x75, 0x07, 0xE0, 0xC0, 0x12, 0x04, 0xF9, 0x09, 0x20, 0xCF, 0x98, 0x1E,
  0x01, 0xFB, 0x02, 0x05, 0xFB, 0x02, 0x06, 0xFB, 0x01, 0x06, 0xFA, 0x81, 0xE0, 0x4F, 0xA0, 0x92,
  0x0E, 0xF0, 0xE0, 0x22, 0x04, 0xE0, 0xE0, 0x44, 0x85, 0x3A, 0xEF, 0xD8, 0x13,
  // "¸" (U+00B8)
  0x73, 0x83, 0x67, 0x77, 0x17, 0x60, 0x1B, 0x0D, 0x77, 0x08, 0xB0, 0x67, 0x70, 0xEA, 0x0E, 0x77,
  0x06, 0xB0, 0x97, 0x70, 0xDC, 0x0C, 0x04, 0x74, 0x04, 0xF0, 0xA7, 0x30, 0x8F, 0x90, 0xB7, 0x38,
  0x11, 0x7E, 0xE0, 0x77, 0x40, 0x20, 0xED, 0x0E, 0x75, 0x05, 0xE0, 0x47, 0x5E, 0x07, 0x75, 0x0D,
  0xD0, 0x77, 0x50, 0xED, 0x06, 0x74, 0x01, 0xE0, 0x57, 0x40, 0x6E, 0x01, 0x73, 0x01, 0x0D, 0xD0,
  0xC7, 0x30, 0x30, 0xDE, 0x89, 0x16, 0x02, 0xFC, 0x98, 0x76, 0x8C, 0xF0, 0xC2, 0x06, 0xFF, 0x0D,
  0x01, 0x20, 0xAF, 0xE0, 0xB0, 0x13, 0x0D, 0xFC, 0x0C, 0x04, 0x58, 0x92, 0x36, 0xAC, 0xDE, 0xFE,
  0xDA, 0x72, 0x70,
  // "¹" (U+00B9)
  0x77, 0x30, 0x40, 0xDB, 0x07, 0x77, 0x20, 0x9D, 0x04, 0x77, 0x03, 0x0D, 0xE0, 0x17, 0x60, 0x8F,
  0x0D, 0x75, 0x05, 0x0D, 0xF9, 0x0A, 0x73, 0x05, 0x0C, 0xFB, 0x06, 0x68, 0x14, 0x8B, 0xE0, 0xCE,
  0x03, 0x60, 0xBF, 0x05, 0x09, 0xE7, 0x09, 0xD8, 0x2E, 0x40, 0xCD, 0x0C, 0x70, 0x3C, 0x0B, 0x01,
  0x2E, 0x09, 0x71, 0x82, 0x37, 0x62, 0x30, 0x3E, 0x06, 0x77, 0x10, 0x6E, 0x02, 0x77, 0x10, 0x9D,
  0x0E, 0x77, 0x20, 0xDD, 0x0B, 0x77, 0x2E, 0x08, 0x77, 0x10, 0x3E, 0x05, 0x77, 0x10, 0x7E, 0x01,
  0x77, 0x10, 0xAD, 0x0E, 0x77, 0x20, 0xDD, 0x0A, 0x77, 0x10, 0x1E, 0x07, 0x77, 0x10, 0x4E, 0x04,
  0x77, 0x10, 0x7E, 0x01, 0x77, 0x10, 0xAD, 0x0D, 0x77, 0x20, 0xED, 0x09, 0x77, 0x10, 0x1E, 0x06,
  0x77, 0x10, 0x5E, 0x03, 0x77, 0x10, 0x8E, 0x77, 0x20, 0xBD, 0x0C, 0x77, 0x20, 0xED, 0x09, 0x77,
  0x10, 0x2E, 0x05, 0x77, 0x10, 0x5E, 0x02, 0x77, 0x10, 0x8E, 0x77, 0x20, 0xCD, 0x0C, 0x77, 0x10,
  0x1E, 0x0B, 0x77, 0x10, 0x8E, 0x0C, 0x76, 0x02, 0x08, 0xF9, 0x07, 0x01, 0x60, 0x9F, 0xFD, 0x0B,
  0x20, 0xDF, 0xFD, 0x81, 0x90, 0x1F, 0xFE, 0x05, 0x10,
  // "º" (U+00BA)
  0x74, 0x89, 0x11, 0x6A, 0xDE, 0xFE, 0xDA, 0x61, 0x77, 0x10, 0x20, 0xAF, 0xB0, 0xE0, 0x87, 0x60,
  0x8F, 0xF0, 0xD0, 0x37, 0x20, 0x10, 0xCD, 0x84, 0xB4, 0x10, 0x4D, 0xD0, 0xE0, 0x27, 0x01, 0x0D,
  0xD0, 0x75, 0x01, 0x0E, 0xD0, 0xC7, 0x0D, 0xD0, 0x97, 0x09, 0xE0, 0x45, 0x0A, 0xD0, 0xC7, 0x10,
  0x5E, 0x0A, 0x40, 0x5E, 0x03, 0x71, 0x02, 0xE0, 0xE3, 0x01, 0x0E, 0xD0, 0xB7, 0x20, 0x1F, 0x30,
  0x8E, 0x03, 0x72, 0x01, 0xF8, 0x22, 0x01, 0xED, 0x0D, 0x73, 0x02, 0xF8, 0x12, 0x06, 0xE0, 0x87,
  0x30, 0x4F, 0x81, 0x10, 0xCE, 0x03, 0x73, 0x06, 0xF1, 0x01, 0xE0, 0xE7, 0x40, 0x8E, 0x81, 0xD0,
  0x6E, 0x0B, 0x74, 0x0B, 0xE8, 0x1A, 0x09, 0xE0, 0x87, 0x4F, 0x81, 0x60, 0xCE, 0x05, 0x73, 0x03,
  0xF8, 0x12, 0x0E, 0xE0, 0x37, 0x30, 0x8E, 0x0D, 0x20, 0xEE, 0x02, 0x73, 0x0D, 0xE0, 0x72, 0x0E,
  0xE0, 0x17, 0x20, 0x3E, 0x0E, 0x01, 0x20, 0xDE, 0x73, 0x0A, 0xE0, 0x73, 0x0B, 0xE0, 0x17, 0x10,
  0x2E, 0x0D, 0x40, 0x8E, 0x03, 0x71, 0x0A, 0xE0, 0x44, 0x03, 0xE0, 0x67, 0x05, 0xE0, 0x86, 0x0C,
  0xD0, 0xB6, 0x03, 0x0E, 0xD0, 0xA7, 0x03, 0xE0, 0x64, 0x05, 0x0E, 0xD0, 0xA7, 0x20, 0x5E, 0x82,
  0xB8, 0x8C, 0xE0, 0x87, 0x40, 0x40, 0xEF, 0xD0, 0xC0, 0x37, 0x68, 0x11, 0x7D, 0xF9, 0x0A, 0x05,
  0x77, 0x48, 0x52, 0x56, 0x76, 0x53, 0x77,
  // "»" (U+00BB)
  0x70, 0x7B, 0x0D, 0x72, 0x03, 0xC0, 0x17, 0x71, 0x03, 0xC0, 0x67, 0x20, 0xEB, 0x09, 0x77, 0x20,
  0xEB, 0x0D, 0x72, 0x0A, 0xC0, 0x27, 0x71, 0x0A, 0xC0, 0x77, 0x10, 0x5C, 0x0B, 0x77, 0x10, 0x6C,
  0x0E, 0x71, 0x01, 0xD0, 0x47, 0x70, 0x2D, 0x08, 0x71, 0x0D, 0xC0, 0xC7, 0x71, 0x0D, 0xC0, 0xE0,
  0x17, 0x08, 0xD0, 0x57, 0x70, 0x9D, 0x09, 0x70, 0x4D, 0x0D, 0x77, 0x05, 0xE0, 0x27, 0xE0, 0x67,
  0x60, 0x1E, 0x0A, 0x70, 0xBD, 0x0E, 0x77, 0x0C, 0xE0, 0x36, 0x07, 0xE0, 0x87, 0x60, 0x8E, 0x0B,
  0x60, 0x3F, 0x01, 0x75, 0x03, 0xF0, 0x36, 0x0E, 0xE0, 0x97, 0x60, 0xEE, 0x0C, 0x60, 0xAF, 0x02,
  0x75, 0x0B, 0xF0, 0x45, 0x06, 0xF0, 0xB7, 0x50, 0x6F, 0x0C, 0x50, 0x1F, 0x90, 0x37, 0x40, 0x3F,
  0x0B, 0x60, 0xEF, 0x01, 0x74, 0x0B, 0xF0, 0x85, 0x06, 0xF0, 0xC7, 0x40, 0x6F, 0x0E, 0x03, 0x40,
  0x2F, 0x90, 0x57, 0x30, 0x20, 0xEF, 0x04, 0x50, 0xCF, 0x07, 0x74, 0x0C, 0xF0, 0x45, 0x07, 0xF0,
  0x77, 0x40, 0x7F, 0x04, 0x50, 0x3F, 0x08, 0x74, 0x02, 0xF0, 0x56, 0x0C, 0xE0, 0x87, 0x50, 0xCE,
  0x05, 0x60, 0x8E, 0x09, 0x75, 0x07, 0xE0, 0x56, 0x03, 0xE0, 0x97, 0x50, 0x3E, 0x06, 0x70, 0xDD,
  0x0A, 0x76, 0x0C, 0xD0, 0x67, 0x09, 0xD0, 0xA7, 0x60, 0x8D, 0x07, 0x70, 0x4D, 0x0A, 0x76, 0x03,
  0xD0, 0x77, 0x10, 0xDC, 0x0B, 0x77, 0x0D, 0xC0, 0x77, 0x10, 0x9C, 0x0B, 0x77, 0x08, 0xC0, 0x87,
  0x10, 0x4C, 0x0B, 0x77, 0x03, 0xC0, 0x87, 0x10, 0x10, 0xEB, 0x0C, 0x77, 0x10, 0xDB, 0x09, 0x72,
  0x0A, 0xB0, 0xC0, 0x17, 0x70, 0x9B, 0x09, 0x72, 0x05, 0xB0, 0xD0, 0x17, 0x71,
  // "¼" (U+00BC)
  0x77, 0x30, 0x40, 0xDB, 0x07, 0x80, 0xE1, 0x00, 0x9D, 0x04, 0x77, 0x74, 0x04, 0xD0, 0x37, 0x75,
  0x03, 0x0D, 0xE0, 0x17, 0x77, 0x40, 0xDC, 0x09, 0x77, 0x50, 0x8F, 0x0D, 0x77, 0x74, 0x08, 0xC0,
  0xD7, 0x74, 0x05, 0x0D, 0xF9, 0x0A, 0x77, 0x73, 0x03, 0xD0, 0x47, 0x72, 0x05, 0x0C, 0xFB, 0x06,
  0x77, 0x73, 0x0C, 0xC0, 0xA7, 0x68, 0x14, 0x8B, 0xE0, 0xCE, 0x03, 0x77, 0x72, 0x07, 0xC0, 0xE0,
  0x17, 0x60, 0xBF, 0x05, 0x09, 0xE7, 0x77, 0x20, 0x20, 0xEC, 0x06, 0x77, 0x09, 0xD8, 0x2E, 0x40,
  0xCD, 0x0C, 0x77, 0x72, 0x0B, 0xC0, 0xB7, 0x71, 0x03, 0xC0, 0xB0, 0x12, 0xE0, 0x97, 0x77, 0x10,
  0x5D, 0x02, 0x77, 0x28, 0x23, 0x76, 0x23, 0x03, 0xE0, 0x67, 0x77, 0x01, 0x0E, 0xC0, 0x77, 0x77,
  0x30, 0x6E, 0x02, 0x77, 0x70, 0xAC, 0x0C, 0x77, 0x74, 0x09, 0xD0, 0xE7, 0x77, 0x04, 0xD0, 0x37,
  0x77, 0x40, 0xDD, 0x0B, 0x77, 0x70, 0xDC, 0x09, 0x77, 0x75, 0xE0, 0x87, 0x76, 0x09, 0xC0, 0xD7,
  0x77, 0x50, 0x3E, 0x05, 0x77, 0x50, 0x3D, 0x04, 0x77, 0x75, 0x07, 0xE0, 0x17, 0x75, 0x0C, 0xC0,
  0xA7, 0x77, 0x60, 0xAD, 0x0E, 0x77, 0x50, 0x7C, 0x0E, 0x01, 0x77, 0x76, 0x0D, 0xD0, 0xA7, 0x74,
  0x02, 0xD0, 0x67, 0x77, 0x60, 0x1E, 0x07, 0x77, 0x40, 0xBC, 0x0B, 0x77, 0x77, 0x04, 0xE0, 0x47,
  0x73, 0x06, 0xD0, 0x27, 0x77, 0x70, 0x7E, 0x01, 0x77, 0x20, 0x10, 0xEC, 0x07, 0x77, 0x77, 0x10,
  0xAD, 0x0D, 0x77, 0x30, 0xAC, 0x0C, 0x77, 0x77, 0x20, 0xED, 0x09, 0x77, 0x20, 0x5D, 0x03, 0x77,
  0x77, 0x10, 0x1E, 0x06, 0x77, 0x10, 0x10, 0xEC, 0x08, 0x77, 0x77, 0x20, 0x5E, 0x03, 0x77, 0x10,
  0x9C, 0x0D, 0x77, 0x77, 0x30, 0x8E, 0x77, 0x10, 0x4D, 0x04, 0x74, 0x03, 0xE0, 0x47, 0x50, 0xBD,
  0x0C, 0x77, 0x10, 0xDC, 0x0A, 0x74, 0x01, 0x0E, 0xE0, 0x17, 0x50, 0xED, 0x09, 0x77, 0x08, 0xC0,
  0xE0, 0x17, 0x40, 0xCE, 0x0D, 0x75, 0x02, 0xE0, 0x57, 0x60, 0x2D, 0x06, 0x74, 0x09, 0xF0, 0xA7,
  0x50, 0x5E, 0x02, 0x76, 0x0C, 0xC0, 0xB7, 0x40, 0x6F, 0x90, 0x77, 0x50, 0x8E, 0x76, 0x07, 0xD0,
  0x27, 0x30, 0x3F, 0xA0, 0x47, 0x50, 0xCD, 0x0C, 0x75, 0x02, 0x0E, 0xC0, 0x77, 0x30, 0x10, 0xEA,
  0x0E, 0xE0, 0x17, 0x40, 0x1E, 0x0B, 0x75, 0x0B, 0xC0, 0xC7, 0x40, 0xCA, 0x0E, 0x09, 0xD0, 0xD7,
  0x50, 0x8E, 0x0C, 0x74, 0x05, 0xD0, 0x37, 0x30, 0x9B, 0x05, 0x0A, 0xD0, 0xA7, 0x30, 0x20, 0x8F,
  0x90, 0x70, 0x17, 0x10, 0x10, 0xEC, 0x08, 0x73, 0x06, 0xB8, 0x19, 0x0E, 0xD0, 0x65, 0x09, 0xFF,
  0xD0, 0xB4, 0x0A, 0xC0, 0xD7, 0x30, 0x3B, 0x81, 0xD0, 0x3E, 0x03, 0x50, 0xDF, 0xFD, 0x09, 0x30,
  0x4D, 0x04, 0x72, 0x01, 0x0E, 0xA8, 0x2E, 0x20, 0x7E, 0x50, 0x1F, 0xFE, 0x05, 0x30, 0xDC, 0x0A,
  0x73, 0x0C, 0xB0, 0x52, 0x0B, 0xD0, 0xC7, 0x77, 0x71, 0x08, 0xC0, 0xE0, 0x17, 0x20, 0x9B, 0x08,
  0x30, 0xED, 0x09, 0x77, 0x77, 0x03, 0xD0, 0x57, 0x20, 0x7B, 0x0B, 0x30, 0x3E, 0x06, 0x77, 0x77,
  0x0C, 0xC0, 0xB7, 0x20, 0x4B, 0x0D, 0x01, 0x30, 0x6E, 0x03, 0x77, 0x76, 0x07, 0xD0, 0x27, 0x10,
  0x10, 0xEB, 0x03, 0x40, 0xAE, 0x77, 0x76, 0x02, 0xD0, 0x77, 0x20, 0xCB, 0x06, 0x50, 0xDD, 0x0C,
  0x77, 0x76, 0x0B, 0xC0, 0xC7, 0x20, 0xAB, 0x09, 0x50, 0x1E, 0x09, 0x77, 0x75, 0x06, 0xD0, 0x37,
  0x10, 0x7B, 0x0C, 0x60, 0x4E, 0x05, 0x77, 0x74, 0x01, 0x0E, 0xC0, 0x87, 0x10, 0x4B, 0x0E, 0x01,
  0x60, 0x7E, 0x02, 0x77, 0x74, 0x0A, 0xC0, 0xD7, 0x10, 0x20, 0xEB, 0x03, 0x70, 0xAD, 0x0E, 0x77,
  0x74, 0x05, 0xD0, 0x47, 0x10, 0xCB, 0x06, 0x71, 0x0D, 0xD0, 0xB7, 0x77, 0x30, 0x10, 0xEC, 0x0A,
  0x71, 0x0A, 0xB0, 0xA7, 0x10, 0x1E, 0x08, 0x77, 0x73, 0x09, 0xC0, 0xE0, 0x17, 0x06, 0xFF, 0xFE,
  0x02, 0x77, 0x20, 0x3D, 0x05, 0x71, 0x0C, 0xFF, 0xFD, 0x0E, 0x77, 0x30, 0xDC, 0x0B, 0x72, 0x0E,
  0xFF, 0xFD, 0x0A, 0x77, 0x20, 0x8C, 0x0E, 0x02, 0x71, 0x01, 0x80, 0x92, 0xCE, 0x0E, 0x80, 0x2C,
  0x05, 0x77, 0x10, 0x2D, 0x07, 0x77, 0x72, 0x02, 0xE0, 0x87, 0x77, 0x10, 0xCC, 0x0C, 0x77, 0x73,
  0x06, 0xE0, 0x57, 0x77, 0x07, 0xD0, 0x37, 0x77, 0x30, 0x9E, 0x02, 0x77, 0x60, 0x20, 0xEC, 0x08,
  0x77, 0x74, 0x0C, 0xD0, 0xD7, 0x77, 0x0B, 0xC0, 0xD7, 0x77, 0x5E, 0x09, 0x77, 0x60, 0x5D, 0x04,
  0x77, 0x74, 0x04, 0xE0, 0x77, 0x75, 0x01, 0x0E, 0xC0, 0xA7, 0x77, 0x50, 0xBE, 0x08, 0x77, 0x50,
  0xAC, 0x0E, 0x01, 0x77, 0x73, 0x03, 0x0A, 0xF0, 0xD0, 0x47, 0x73, 0x04, 0xD0, 0x57, 0x77, 0x07,
  0xFF, 0xA0, 0x97, 0x70, 0xDC, 0x0B, 0x77, 0x71, 0x0B, 0xFF, 0xA0, 0x57, 0x60, 0x8C, 0x0E, 0x02,
  0x77, 0x71, 0x0E, 0xFF, 0xA0, 0x25,
  // "½" (U+00BD)
  0x77, 0x30, 0x40, 0xDB, 0x07, 0x80, 0xE0, 0x00, 0x9D, 0x04, 0x77, 0x73, 0x04, 0xD0, 0x37, 0x75,
  0x03, 0x0D, 0xE0, 0x17, 0x77, 0x30, 0xDC, 0x09, 0x77, 0x50, 0x8F, 0x0D, 0x77, 0x73, 0x08, 0xC0,
  0xD7, 0x74, 0x05, 0x0D, 0xF9, 0x0A, 0x77, 0x72, 0x03, 0xD0, 0x47, 0x72, 0x05, 0x0C, 0xFB, 0x06,
  0x77, 0x72, 0x0C, 0xC0, 0xA7, 0x68, 0x14, 0x8B, 0xE0, 0xCE, 0x03, 0x77, 0x71, 0x07, 0xC0, 0xE0,
  0x17, 0x60, 0xBF, 0x05, 0x09, 0xE7, 0x77, 0x10, 0x20, 0xEC, 0x06, 0x77, 0x09, 0xD8, 0x2E, 0x40,
  0xCD, 0x0C, 0x77, 0x71, 0x0B, 0xC0, 0xB7, 0x71, 0x03, 0xC0, 0xB0, 0x12, 0xE0, 0x97, 0x77, 0x05,
  0xD0, 0x27, 0x72, 0x82, 0x37, 0x62, 0x30, 0x3E, 0x06, 0x77, 0x60, 0x10, 0xEC, 0x07, 0x77, 0x73,
  0x06, 0xE0, 0x27, 0x76, 0x0A, 0xC0, 0xC7, 0x77, 0x40, 0x9D, 0x0E, 0x77, 0x60, 0x4D, 0x03, 0x77,
  0x74, 0x0D, 0xD0, 0xB7, 0x76, 0x0D, 0xC0, 0x97, 0x77, 0x5E, 0x08, 0x77, 0x50, 0x9C, 0x0D, 0x77,
  0x75, 0x03, 0xE0, 0x57, 0x74, 0x03, 0xD0, 0x47, 0x77, 0x50, 0x7E, 0x01, 0x77, 0x40, 0xCC, 0x0A,
  0x77, 0x76, 0x0A, 0xD0, 0xE7, 0x74, 0x07, 0xC0, 0xE0, 0x17, 0x77, 0x60, 0xDD, 0x0A, 0x77, 0x30,
  0x2D, 0x06, 0x77, 0x76, 0x01, 0xE0, 0x77, 0x73, 0x0B, 0xC0, 0xB7, 0x77, 0x70, 0x4E, 0x04, 0x77,
  0x20, 0x6D, 0x02, 0x77, 0x77, 0x07, 0xE0, 0x17, 0x71, 0x01, 0x0E, 0xC0, 0x77, 0x77, 0x71, 0x0A,
  0xD0, 0xD7, 0x72, 0x0A, 0xC0, 0xC7, 0x77, 0x72, 0x0E, 0xD0, 0x97, 0x71, 0x05, 0xD0, 0x37, 0x77,
  0x71, 0x01, 0xE0, 0x67, 0x70, 0x10, 0xEC, 0x08, 0x77, 0x77, 0x20, 0x5E, 0x03, 0x77, 0x09, 0xC0,
  0xD6, 0x89, 0x03, 0x69, 0xAB, 0xBA, 0x85, 0x17, 0x71, 0x08, 0xE7, 0x70, 0x4D, 0x04, 0x40, 0x60,
  0xDF, 0xB0, 0x90, 0x17, 0x60, 0xBD, 0x0C, 0x77, 0x0D, 0xC0, 0xA3, 0x03, 0x0D, 0xFE, 0x0E, 0x04,
  0x75, 0x0E, 0xD0, 0x97, 0x60, 0x8C, 0x0E, 0x01, 0x20, 0x4F, 0xFB, 0x03, 0x73, 0x02, 0xE0, 0x57,
  0x50, 0x2D, 0x06, 0x20, 0x3E, 0x84, 0xE6, 0x10, 0x29, 0xE0, 0xD7, 0x30, 0x5E, 0x02, 0x75, 0x0C,
  0xC0, 0xB3, 0x0C, 0xD0, 0xD0, 0x25, 0x0B, 0xE0, 0x67, 0x20, 0x8E, 0x75, 0x07, 0xD0, 0x22, 0x04,
  0xE0, 0x36, 0x04, 0xE0, 0xB7, 0x20, 0xCD, 0x0C, 0x74, 0x02, 0x0E, 0xC0, 0x73, 0x09, 0xD0, 0xA7,
  0x10, 0xED, 0x0E, 0x71, 0x01, 0xE0, 0xB7, 0x40, 0xBC, 0x0C, 0x40, 0xBD, 0x02, 0x71, 0x0C, 0xE7,
  0x10, 0x8E, 0x0C, 0x73, 0x05, 0xD0, 0x34, 0x0A, 0xC0, 0xC7, 0x20, 0xBE, 0x60, 0x20, 0x8F, 0x90,
  0x70, 0x17, 0x01, 0x0E, 0xC0, 0x85, 0x06, 0xC0, 0x77, 0x20, 0xCD, 0x81, 0xD0, 0x9F, 0xFD, 0x0B,
  0x30, 0xAC, 0x0D, 0x70, 0xBB, 0x03, 0x72, 0x0E, 0xD8, 0x1A, 0x0D, 0xFF, 0xD0, 0x92, 0x04, 0xD0,
  0x47, 0x18, 0x16, 0xCE, 0x72, 0x01, 0xE0, 0x60, 0x1F, 0xFE, 0x05, 0x20, 0xDC, 0x0A, 0x77, 0x70,
  0x5E, 0x01, 0x77, 0x72, 0x08, 0xC0, 0xE0, 0x17, 0x77, 0x0B, 0xD0, 0xA7, 0x77, 0x20, 0x3D, 0x05,
  0x77, 0x70, 0x1E, 0x02, 0x77, 0x72, 0x0C, 0xC0, 0xB7, 0x77, 0x10, 0x9D, 0x08, 0x77, 0x72, 0x07,
  0xD0, 0x27, 0x77, 0x02, 0xD0, 0xC7, 0x77, 0x20, 0x2D, 0x07, 0x77, 0x71, 0x0B, 0xC0, 0xE0, 0x27,
  0x77, 0x20, 0xBC, 0x0C, 0x77, 0x71, 0x07, 0xD0, 0x47, 0x77, 0x20, 0x6D, 0x03, 0x77, 0x70, 0x4D,
  0x05, 0x77, 0x72, 0x01, 0x0E, 0xC0, 0x87, 0x77, 0x02, 0x0E, 0xC0, 0x67, 0x77, 0x30, 0xAC, 0x0D,
  0x77, 0x70, 0x10, 0xDC, 0x07, 0x77, 0x73, 0x05, 0xD0, 0x47, 0x76, 0x01, 0x0D, 0xC0, 0x77, 0x77,
  0x30, 0x10, 0xEC, 0x0A, 0x77, 0x60, 0x10, 0xDC, 0x06, 0x77, 0x74, 0x09, 0xC0, 0xE0, 0x17, 0x75,
  0x01, 0x0D, 0xC0, 0x57, 0x77, 0x40, 0x3D, 0x05, 0x77, 0x50, 0x20, 0xDC, 0x04, 0x77, 0x75, 0x0D,
  0xC0, 0xB7, 0x75, 0x02, 0x0D, 0xB0, 0xE0, 0x37, 0x77, 0x50, 0x8C, 0x0E, 0x02, 0x77, 0x40, 0x30,
  0xEB, 0x0D, 0x02, 0x77, 0x75, 0x02, 0xD0, 0x77, 0x74, 0x03, 0x0E, 0xB0, 0xD0, 0x27, 0x18, 0x22,
  0x99, 0x37, 0x71, 0x0C, 0xC0, 0xC7, 0x74, 0x04, 0x0E, 0xB0, 0xC0, 0x17, 0x20, 0x9A, 0x03, 0x77,
  0x07, 0xD0, 0x37, 0x73, 0x04, 0xC0, 0xB7, 0x40, 0xEA, 0x77, 0x02, 0x0E, 0xC0, 0x87, 0x73, 0x05,
  0xC0, 0xA7, 0x40, 0x6A, 0x0B, 0x77, 0x0B, 0xC0, 0xD7, 0x73, 0x05, 0xC0, 0x97, 0x40, 0x10, 0xEA,
  0x08, 0x76, 0x05, 0xD0, 0x47, 0x72, 0x06, 0xC0, 0x77, 0x40, 0x40, 0xDB, 0x04, 0x75, 0x01, 0x0E,
  0xC0, 0xA7, 0x72, 0x07, 0xFF, 0xF9, 0x76, 0x0A, 0xC0, 0xE0, 0x17, 0x71, 0x08, 0xFF, 0xF9, 0x0C,
  0x75, 0x04, 0xD0, 0x57, 0x71, 0x01, 0xFF, 0xFA, 0x08, 0x75, 0x0D, 0xC0, 0xB7, 0x72, 0x05, 0xFF,
  0xFA, 0x05, 0x74, 0x08, 0xC0, 0xE0, 0x27, 0x72, 0x08, 0xFF, 0xFA, 0x01, 0x40,
  // "¾" (U+00BE)
  0x76, 0x89, 0x15, 0x8B, 0xDE, 0xFE, 0xDC, 0x95, 0x80, 0xD4, 0x08, 0x11, 0x9E, 0xFC, 0x0E, 0x07,
  0x77, 0x74, 0x04, 0xD0, 0x37, 0x60, 0x50, 0xEF, 0xF9, 0x0B, 0x77, 0x73, 0x0D, 0xC0, 0x97, 0x60,
  0x7F, 0x98, 0x1D, 0xCE, 0xF0, 0xA7, 0x77, 0x10, 0x8C, 0x0D, 0x76, 0x04, 0xE8, 0x1E, 0x71, 0x30,
  0x50, 0xEE, 0x05, 0x77, 0x60, 0x3D, 0x04, 0x76, 0x0C, 0xE0, 0x36, 0x06, 0xE0, 0xB7, 0x76, 0x0C,
  0xC0, 0xA7, 0x60, 0x2E, 0x08, 0x71, 0xF7, 0x75, 0x07, 0xC0, 0xE0, 0x17, 0x60, 0x4D, 0x0E, 0x01,
  0x71, 0x0D, 0xE0, 0x27, 0x73, 0x02, 0x0E, 0xC0, 0x67, 0x70, 0x3D, 0x08, 0x72, 0x0D, 0xE0, 0x27,
  0x73, 0x0B, 0xC0, 0xB7, 0x72, 0x0D, 0xC0, 0x47, 0x20, 0xEE, 0x77, 0x30, 0x5D, 0x02, 0x77, 0x20,
  0x20, 0xBA, 0x0E, 0x72, 0x02, 0xE0, 0xD7, 0x72, 0x01, 0x0E, 0xC0, 0x77, 0x75, 0x81, 0x13, 0x37,
  0x20, 0x6E, 0x09, 0x77, 0x20, 0xAC, 0x0C, 0x77, 0x77, 0x40, 0xDE, 0x03, 0x77, 0x10, 0x4D, 0x03,
  0x77, 0x77, 0x30, 0x8E, 0x0A, 0x77, 0x20, 0xDC, 0x09, 0x77, 0x77, 0x30, 0x6E, 0x0C, 0x77, 0x20,
  0x9C, 0x0D, 0x77, 0x77, 0x30, 0x9E, 0x0A, 0x77, 0x20, 0x3D, 0x04, 0x77, 0x77, 0x81, 0x27, 0xED,
  0x0D, 0x05, 0x77, 0x30, 0xCC, 0x0A, 0x77, 0x73, 0x83, 0x7C, 0xCC, 0xEE, 0x0D, 0x06, 0x77, 0x40,
  0x7C, 0x0E, 0x01, 0x77, 0x73, 0x0C, 0xF9, 0x08, 0x03, 0x77, 0x50, 0x2D, 0x06, 0x77, 0x74, 0x0E,
  0xF9, 0x81, 0xD9, 0x37, 0x74, 0x0B, 0xC0, 0xB7, 0x77, 0x40, 0x2F, 0xD0, 0xB0, 0x27, 0x71, 0x06,
  0xD0, 0x27, 0x77, 0x71, 0x82, 0x13, 0x7E, 0xE0, 0xE0, 0x37, 0x60, 0x10, 0xEC, 0x07, 0x77, 0x77,
  0x60, 0xBE, 0x0D, 0x01, 0x75, 0x0A, 0xC0, 0xC8, 0x0C, 0x00, 0x0C, 0xE0, 0x87, 0x40, 0x5D, 0x03,
  0x80, 0xC0, 0x00, 0x4E, 0x0E, 0x73, 0x01, 0x0E, 0xC0, 0x88, 0x0C, 0x20, 0x0D, 0xE0, 0x37, 0x20,
  0x9C, 0x0D, 0x80, 0xC3, 0x00, 0xAE, 0x05, 0x71, 0x04, 0xD0, 0x47, 0x30, 0x3E, 0x04, 0x77, 0x70,
  0x8E, 0x06, 0x71, 0x0D, 0xC0, 0xA7, 0x30, 0x10, 0xEE, 0x01, 0x58, 0x14, 0x95, 0x76, 0x08, 0xE0,
  0x57, 0x08, 0xC0, 0xE0, 0x17, 0x30, 0xCE, 0x0D, 0x50, 0xAA, 0x09, 0x76, 0x09, 0xE0, 0x36, 0x02,
  0xD0, 0x67, 0x30, 0x9F, 0x0A, 0x40, 0x8B, 0x0B, 0x76, 0x0C, 0xE0, 0x16, 0x0C, 0xC0, 0xB7, 0x30,
  0x6F, 0x90, 0x74, 0x0E, 0xB0, 0xE7, 0x50, 0x1E, 0x0C, 0x60, 0x7D, 0x02, 0x72, 0x03, 0xFA, 0x04,
  0x30, 0x1D, 0x05, 0x74, 0x07, 0xE0, 0x65, 0x02, 0x0E, 0xC0, 0x77, 0x20, 0x10, 0xEA, 0x0E, 0xE0,
  0x13, 0x01, 0xD0, 0xC7, 0x30, 0x20, 0xED, 0x0D, 0x60, 0xBC, 0x0C, 0x73, 0x0C, 0xA0, 0xE0, 0x9D,
  0x0D, 0x5E, 0x09, 0x71, 0x03, 0x0D, 0xE0, 0x45, 0x05, 0xD0, 0x37, 0x20, 0x9B, 0x05, 0x0A, 0xD0,
  0xA5, 0x0A, 0xE0, 0xA0, 0x24, 0x03, 0x09, 0xF0, 0x65, 0x01, 0x0E, 0xC0, 0x87, 0x20, 0x6B, 0x81,
  0x90, 0xED, 0x06, 0x50, 0x20, 0xEF, 0x82, 0xEC, 0xCE, 0xF0, 0xE0, 0x56, 0x0A, 0xC0, 0xD7, 0x20,
  0x3B, 0x81, 0xD0, 0x3E, 0x03, 0x60, 0x30, 0xEF, 0xFA, 0x0B, 0x02, 0x60, 0x4D, 0x04, 0x71, 0x01,
  0x0E, 0xA8, 0x2E, 0x20, 0x7E, 0x71, 0x02, 0x0A, 0xFE, 0x0A, 0x04, 0x71, 0x0D, 0xC0, 0xA7, 0x20,
  0xCB, 0x05, 0x20, 0xBD, 0x0C, 0x73, 0x83, 0x16, 0xAC, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x72, 0x08,
  0xC0, 0xE0, 0x17, 0x10, 0x9B, 0x08, 0x30, 0xED, 0x09, 0x77, 0x77, 0x30, 0x3D, 0x05, 0x71, 0x07,
  0xB0, 0xB3, 0x03, 0xE0, 0x67, 0x77, 0x73, 0x0C, 0xC0, 0xB7, 0x10, 0x4B, 0x0D, 0x01, 0x30, 0x6E,
  0x03, 0x77, 0x77, 0x20, 0x7D, 0x02, 0x70, 0x10, 0xEB, 0x03, 0x40, 0xAE, 0x77, 0x77, 0x20, 0x2D,
  0x07, 0x71, 0x0C, 0xB0, 0x65, 0x0D, 0xD0, 0xC7, 0x77, 0x72, 0x0B, 0xC0, 0xC7, 0x10, 0xAB, 0x09,
  0x50, 0x1E, 0x09, 0x77, 0x77, 0x10, 0x6D, 0x03, 0x70, 0x7B, 0x0C, 0x60, 0x4E, 0x05, 0x77, 0x77,
  0x01, 0x0E, 0xC0, 0x87, 0x04, 0xB0, 0xE0, 0x16, 0x07, 0xE0, 0x27, 0x77, 0x70, 0xAC, 0x0D, 0x70,
  0x20, 0xEB, 0x03, 0x70, 0xAD, 0x0E, 0x77, 0x77, 0x05, 0xD0, 0x47, 0x0C, 0xB0, 0x67, 0x10, 0xDD,
  0x0B, 0x77, 0x76, 0x01, 0x0E, 0xC0, 0xA7, 0x0A, 0xB0, 0xA7, 0x10, 0x1E, 0x08, 0x77, 0x76, 0x09,
  0xC0, 0xE0, 0x16, 0x06, 0xFF, 0xFE, 0x02, 0x77, 0x50, 0x3D, 0x05, 0x70, 0xCF, 0xFF, 0xD0, 0xE7,
  0x76, 0x0D, 0xC0, 0xB7, 0x10, 0xEF, 0xFF, 0xD0, 0xA7, 0x75, 0x08, 0xC0, 0xE0, 0x27, 0x01, 0x80,
  0x92, 0xCE, 0x0E, 0x80, 0x2C, 0x05, 0x77, 0x40, 0x2D, 0x07, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77,
  0x40, 0xCC, 0x0C, 0x77, 0x72, 0x06, 0xE0, 0x57, 0x77, 0x30, 0x7D, 0x03, 0x77, 0x72, 0x09, 0xE0,
  0x27, 0x77, 0x20, 0x20, 0xEC, 0x08, 0x77, 0x73, 0x0C, 0xD0, 0xD7, 0x77, 0x30, 0xBC, 0x0D, 0x77,
  0x74, 0xE0, 0x97, 0x77, 0x20, 0x5D, 0x04, 0x77, 0x73, 0x04, 0xE0, 0x77, 0x77, 0x10, 0x10, 0xEC,
  0x0A, 0x77, 0x74, 0x0B, 0xE0, 0x87, 0x77, 0x10, 0xAC, 0x0E, 0x01, 0x77, 0x72, 0x03, 0x0A, 0xF0,
  0xD0, 0x47, 0x76, 0x04, 0xD0, 0x57, 0x76, 0x07, 0xFF, 0xA0, 0x97, 0x73, 0x0D, 0xC0, 0xB7, 0x77,
  0x0B, 0xFF, 0xA0, 0x57, 0x72, 0x08, 0xC0, 0xE0, 0x27, 0x77, 0x0E, 0xFF, 0xA0, 0x25,
  // "¿" (U+00BF)
  0x77, 0x73, 0x84, 0x5B, 0xEE, 0xC6, 0x77, 0x74, 0x0B, 0xE0, 0xA7, 0x77, 0x20, 0xAF, 0x90, 0x47,
  0x77, 0x02, 0xFA, 0x09, 0x77, 0x70, 0x7F, 0xA0, 0xB7, 0x77, 0x0A, 0xFA, 0x0B, 0x77, 0x70, 0xBF,
  0xA0, 0x97, 0x77, 0x0B, 0xFA, 0x06, 0x77, 0x70, 0x9F, 0xA0, 0x17, 0x77, 0x04, 0xF9, 0x08, 0x77,
  0x72, 0x09, 0xE0, 0xA7, 0x77, 0x48, 0x46, 0xCE, 0xEC, 0x68, 0x0B, 0xA5, 0x08, 0x00, 0x20, 0x17,
  0x77, 0x60, 0xDB, 0x08, 0x77, 0x75, 0x01, 0xC0, 0x67, 0x77, 0x50, 0x5C, 0x04, 0x77, 0x75, 0x09,
  0xC0, 0x27, 0x77, 0x50, 0xDC, 0x77, 0x75, 0x02, 0xC0, 0xD7, 0x77, 0x50, 0x6C, 0x0B, 0x77, 0x75,
  0x0A, 0xC0, 0x87, 0x77, 0x50, 0xEC, 0x06, 0x77, 0x74, 0x02, 0xD0, 0x47, 0x77, 0x28, 0x11, 0x7E,
  0xD0, 0x27, 0x77, 0x81, 0x18, 0xEF, 0x77, 0x70, 0x70, 0xEF, 0x90, 0xD7, 0x75, 0x04, 0x0D, 0xF9,
  0x0D, 0x06, 0x77, 0x40, 0x10, 0xAF, 0x90, 0xE0, 0x67, 0x75, 0x04, 0x0E, 0xF9, 0x08, 0x77, 0x60,
  0x8F, 0x90, 0xC0, 0x27, 0x76, 0x0B, 0xF9, 0x09, 0x77, 0x70, 0xBF, 0x90, 0x57, 0x77, 0x0B, 0xF9,
  0x04, 0x77, 0x70, 0x9F, 0x0E, 0x03, 0x77, 0x70, 0x5F, 0x90, 0x47, 0x77, 0x01, 0x0E, 0xF0, 0x87,
  0x77, 0x10, 0xAF, 0x0D, 0x77, 0x71, 0x02, 0xF9, 0x05, 0x77, 0x71, 0x09, 0xF0, 0xD7, 0x77, 0x20,
  0xEF, 0x07, 0x77, 0x71, 0x04, 0xF9, 0x02, 0x77, 0x71, 0x08, 0xF0, 0xE7, 0x77, 0x20, 0xBF, 0x0B,
  0x77, 0x18, 0x22, 0xA8, 0x54, 0x0D, 0xF0, 0x97, 0x71, 0x06, 0xB0, 0xD0, 0x32, 0x0E, 0xF0, 0x77,
  0x71, 0x09, 0xC0, 0xE0, 0x21, 0xF9, 0x07, 0x77, 0x10, 0xCD, 0x81, 0x90, 0xEF, 0x07, 0x77, 0x01,
  0xE8, 0x1D, 0x0D, 0xF0, 0x87, 0x70, 0x6E, 0x81, 0xE0, 0xCF, 0x0A, 0x77, 0x0B, 0xE8, 0x1D, 0x09,
  0xF0, 0xD7, 0x60, 0x1F, 0x81, 0xA0, 0x5F, 0x90, 0x37, 0x50, 0x9F, 0x81, 0x60, 0x1F, 0x90, 0x97,
  0x40, 0x3F, 0x0E, 0x01, 0x20, 0x9F, 0x90, 0x47, 0x20, 0x10, 0xDF, 0x07, 0x30, 0x2F, 0x90, 0xE0,
  0x47, 0x03, 0x0D, 0xF0, 0xC5, 0x06, 0xFA, 0x85, 0x93, 0x10, 0x14, 0x9F, 0x90, 0xD0, 0x16, 0x08,
  0xFF, 0xF9, 0x0C, 0x01, 0x71, 0x06, 0x0E, 0xFF, 0xD0, 0x87, 0x40, 0x20, 0xAF, 0xFA, 0x09, 0x02,
  0x77, 0x81, 0x18, 0xCF, 0xA8, 0x2E, 0xA6, 0x17, 0x76, 0x86, 0x34, 0x56, 0x55, 0x31, 0x76,
  // "À" (U+00C0)
  0x77, 0x77, 0x40, 0x68, 0x03, 0x70, 0x48, 0x0D, 0x40, 0x0E, 0xF0, 0xC8, 0x0D, 0x40, 0x06, 0xF9,
  0x02, 0x80, 0xD4, 0x00, 0xCF, 0x07, 0x80, 0xD4, 0x00, 0x2F, 0x0C, 0x80, 0xD5, 0x00, 0x7F, 0x02,
  0x80, 0xD5, 0x00, 0xCE, 0x08, 0x80, 0xD5, 0x00, 0x10, 0xED, 0x0E, 0x80, 0xD6, 0x00, 0x5E, 0x05,
  0x80, 0xD6, 0x00, 0x8D, 0x0B, 0x80, 0xD7, 0x00, 0xBD, 0x01, 0x80, 0xD6, 0x00, 0x10, 0xDC, 0x07,
  0x80, 0xD7, 0x00, 0x30, 0xEB, 0x0D, 0x80, 0xE0, 0x00, 0x4C, 0x04, 0x80, 0xE0, 0x00, 0x6B, 0x04,
  0x80, 0xD9, 0x20, 0x08, 0xE0, 0xB8, 0x0D, 0x40, 0x01, 0x0E, 0xE0, 0xD8, 0x0D, 0x40, 0x09, 0xF0,
  0xE8, 0x0D, 0x30, 0x02, 0xFA, 0x80, 0xD3, 0x00, 0xAF, 0xA0, 0x28, 0x0D, 0x10, 0x03, 0xFB, 0x03,
  0x80, 0xD1, 0x00, 0xBF, 0xB0, 0x58, 0x0D, 0x00, 0x04, 0xFC, 0x06, 0x80, 0xD0, 0x00, 0xCB, 0x0C,
  0xF0, 0x88, 0x0C, 0x70, 0x05, 0xC0, 0x5F, 0x09, 0x80, 0xC7, 0x00, 0xDB, 0x0B, 0x02, 0xF0, 0xB8,
  0x0C, 0x60, 0x06, 0xC0, 0x40, 0x2F, 0x0D, 0x80, 0xC6, 0x00, 0xDB, 0x81, 0xD0, 0x1F, 0x0E, 0x80,
  0xC5, 0x00, 0x7C, 0x81, 0x60, 0x1F, 0x98, 0x0C, 0x40, 0x01, 0x0E, 0xB0, 0xE3, 0xF9, 0x02, 0x80,
  0xC3, 0x00, 0x8C, 0x07, 0x3F, 0x90, 0x38, 0x0C, 0x20, 0x01, 0x0E, 0xB0, 0xE4, 0x0D, 0xF0, 0x58,
  0x0C, 0x20, 0x09, 0xC0, 0x64, 0x0C, 0xF0, 0x68, 0x0C, 0x10, 0x02, 0xC0, 0xD5, 0x0B, 0xF0, 0x88,
  0x0C, 0x10, 0x0A, 0xC0, 0x55, 0x0A, 0xF0, 0x98, 0x0C, 0x00, 0x03, 0xC0, 0xC6, 0x08, 0xF0, 0xB8,
  0x0C, 0x00, 0x0B, 0xC0, 0x46, 0x07, 0xF0, 0xD7, 0x77, 0x77, 0x04, 0xC0, 0xC7, 0x06, 0xF0, 0xE7,
  0x77, 0x77, 0x0C, 0xC0, 0x37, 0x04, 0xF9, 0x77, 0x77, 0x60, 0x5C, 0x0B, 0x71, 0x03, 0xF9, 0x02,
  0x77, 0x77, 0x50, 0xDC, 0x03, 0x71, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x40, 0x6C, 0x0A, 0x73, 0xF9,
  0x05, 0x77, 0x77, 0x40, 0xEC, 0x02, 0x73, 0x0E, 0xF0, 0x67, 0x77, 0x73, 0x07, 0xC0, 0x97, 0x40,
  0xDF, 0x08, 0x77, 0x77, 0x20, 0x10, 0xEC, 0x01, 0x74, 0x0B, 0xF0, 0xA7, 0x77, 0x72, 0x08, 0xC0,
  0x87, 0x50, 0xAF, 0x0B, 0x77, 0x77, 0x10, 0x1C, 0x0E, 0x01, 0x75, 0x09, 0xF0, 0xD7, 0x77, 0x71,
  0x09, 0xC0, 0x87, 0x60, 0x7F, 0x0E, 0x77, 0x77, 0x02, 0xC0, 0xE7, 0x70, 0x6F, 0x97, 0x77, 0x70,
  0xAC, 0x07, 0x77, 0x04, 0xF9, 0x02, 0x77, 0x75, 0x03, 0xC0, 0xD7, 0x71, 0x03, 0xF9, 0x03, 0x77,
  0x75, 0x0B, 0xC0, 0x67, 0x71, 0x02, 0xF9, 0x05, 0x77, 0x74, 0x04, 0xC0, 0xD7, 0x73, 0xF9, 0x06,
  0x77, 0x74, 0x0C, 0xFF, 0xFF, 0xA0, 0x87, 0x77, 0x30, 0x5F, 0xFF, 0xFB, 0x0A, 0x77, 0x73, 0x0D,
  0xFF, 0xFF, 0xB0, 0xB7, 0x77, 0x20, 0x6F, 0xFF, 0xFC, 0x0D, 0x77, 0x72, 0x0E, 0xC0, 0x88, 0x09,
  0x76, 0x0B, 0xF0, 0xE7, 0x77, 0x10, 0x7C, 0x0C, 0x77, 0x60, 0x8F, 0x97, 0x77, 0x01, 0x0E, 0xC0,
  0x47, 0x76, 0x07, 0xF9, 0x02, 0x77, 0x60, 0x8C, 0x0B, 0x77, 0x70, 0x5F, 0x90, 0x37, 0x75, 0x01,
  0xD0, 0x37, 0x77, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x9C, 0x0B, 0x77, 0x71, 0x02, 0xF9, 0x07, 0x77,
  0x40, 0x2D, 0x03, 0x77, 0x71, 0x01, 0xF9, 0x08, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x73, 0xF9, 0x0A,
  0x77, 0x30, 0x3D, 0x02, 0x77, 0x73, 0x0E, 0xF0, 0xB7, 0x73, 0x0B, 0xC0, 0x97, 0x77, 0x40, 0xCF,
  0x0D, 0x77, 0x20, 0x4D, 0x02, 0x77, 0x74, 0x0B, 0xF0, 0xE7, 0x72, 0x0C, 0xC0, 0xA7, 0x77, 0x50,
  0xAF, 0x97, 0x71, 0x06, 0xD0, 0x47, 0x77, 0x50, 0xAF, 0x90, 0x27, 0x60, 0x10, 0xED, 0x01, 0x77,
  0x75, 0x0B, 0xF9, 0x05, 0x76, 0x0A, 0xD0, 0xE7, 0x77, 0x60, 0xEF, 0x90, 0x87, 0x50, 0x5E, 0x0E,
  0x77, 0x75, 0x05, 0xFA, 0x0D, 0x74, 0x03, 0x0E, 0xF0, 0x47, 0x77, 0x30, 0x30, 0xEF, 0xB0, 0x57,
  0x10, 0x20, 0x8F, 0xA8, 0x1E, 0x72, 0x77, 0x60, 0x30, 0x8F, 0xE0, 0x70, 0x13, 0x09, 0xFF, 0xC0,
  0xB7, 0x60, 0x3F, 0xFF, 0x81, 0x80, 0xCF, 0xFC, 0x08, 0x76, 0x06, 0xFF, 0xF8, 0x15, 0x0E, 0xFF,
  0xC0, 0x57, 0x60, 0x9F, 0xFF, 0x03, 0x02, 0xFF, 0xD0, 0x27, 0x60, 0xBF, 0xFF, 0x10,
  // "Á" (U+00C1)
  0x80, 0xD4, 0x08, 0x05, 0x70, 0x18, 0x0D, 0x30, 0x06, 0xF9, 0x0D, 0x80, 0xD4, 0x00, 0xEF, 0x0E,
  0x02, 0x80, 0xD3, 0x00, 0x8F, 0x90, 0x48, 0x0D, 0x30, 0x02, 0xF9, 0x05, 0x80, 0xD4, 0x00, 0xCF,
  0x06, 0x80, 0xD4, 0x00, 0x6F, 0x07, 0x80, 0xD4, 0x00, 0x10, 0xEE, 0x07, 0x80, 0xD5, 0x00, 0xBE,
  0x07, 0x80, 0xD5, 0x00, 0x7E, 0x06, 0x80, 0xD5, 0x00, 0x2E, 0x05, 0x80, 0xD6, 0x00, 0xDC, 0x0E,
  0x03, 0x80, 0xD6, 0x00, 0xAC, 0x0C, 0x02, 0x80, 0xD6, 0x00, 0x6C, 0x0A, 0x80, 0xE0, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xDA, 0x20, 0x08, 0xE0, 0xB8, 0x0D, 0x50, 0x01, 0x0E, 0xE0, 0xD8, 0x0D, 0x50,
  0x09, 0xF0, 0xE8, 0x0D, 0x40, 0x02, 0xFA, 0x80, 0xD4, 0x00, 0xAF, 0xA0, 0x28, 0x0D, 0x20, 0x03,
  0xFB, 0x03, 0x80, 0xD2, 0x00, 0xBF, 0xB0, 0x58, 0x0D, 0x10, 0x04, 0xFC, 0x06, 0x80, 0xD1, 0x00,
  0xCB, 0x0C, 0xF0, 0x88, 0x0D, 0x00, 0x05, 0xC0, 0x5F, 0x09, 0x80, 0xD0, 0x00, 0xDB, 0x0B, 0x02,
  0xF0, 0xB8, 0x0C, 0x70, 0x06, 0xC0, 0x40, 0x2F, 0x0D, 0x80, 0xC7, 0x00, 0xDB, 0x81, 0xD0, 0x1F,
  0x0E, 0x80, 0xC6, 0x00, 0x7C, 0x81, 0x60, 0x1F, 0x98, 0x0C, 0x50, 0x01, 0x0E, 0xB0, 0xE3, 0xF9,
  0x02, 0x80, 0xC4, 0x00, 0x8C, 0x07, 0x3F, 0x90, 0x38, 0x0C, 0x30, 0x01, 0x0E, 0xB0, 0xE4, 0x0D,
  0xF0, 0x58, 0x0C, 0x30, 0x09, 0xC0, 0x64, 0x0C, 0xF0, 0x68, 0x0C, 0x20, 0x02, 0xC0, 0xD5, 0x0B,
  0xF0, 0x88, 0x0C, 0x20, 0x0A, 0xC0, 0x55, 0x0A, 0xF0, 0x98, 0x0C, 0x10, 0x03, 0xC0, 0xC6, 0x08,
  0xF0, 0xB8, 0x0C, 0x10, 0x0B, 0xC0, 0x46, 0x07, 0xF0, 0xD8, 0x0C, 0x00, 0x04, 0xC0, 0xC7, 0x06,
  0xF0, 0xE8, 0x0C, 0x00, 0x0C, 0xC0, 0x37, 0x04, 0xF9, 0x77, 0x77, 0x70, 0x5C, 0x0B, 0x71, 0x03,
  0xF9, 0x02, 0x77, 0x77, 0x60, 0xDC, 0x03, 0x71, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x6C, 0x0A,
  0x73, 0xF9, 0x05, 0x77, 0x77, 0x50, 0xEC, 0x02, 0x73, 0x0E, 0xF0, 0x67, 0x77, 0x74, 0x07, 0xC0,
  0x97, 0x40, 0xDF, 0x08, 0x77, 0x77, 0x30, 0x10, 0xEC, 0x01, 0x74, 0x0B, 0xF0, 0xA7, 0x77, 0x73,
  0x08, 0xC0, 0x87, 0x50, 0xAF, 0x0B, 0x77, 0x77, 0x20, 0x1C, 0x0E, 0x01, 0x75, 0x09, 0xF0, 0xD7,
  0x77, 0x72, 0x09, 0xC0, 0x87, 0x60, 0x7F, 0x0E, 0x77, 0x77, 0x10, 0x2C, 0x0E, 0x77, 0x06, 0xF9,
  0x77, 0x77, 0x10, 0xAC, 0x07, 0x77, 0x04, 0xF9, 0x02, 0x77, 0x76, 0x03, 0xC0, 0xD7, 0x71, 0x03,
  0xF9, 0x03, 0x77, 0x76, 0x0B, 0xC0, 0x67, 0x71, 0x02, 0xF9, 0x05, 0x77, 0x75, 0x04, 0xC0, 0xD7,
  0x73, 0xF9, 0x06, 0x77, 0x75, 0x0C, 0xFF, 0xFF, 0xA0, 0x87, 0x77, 0x40, 0x5F, 0xFF, 0xFB, 0x0A,
  0x77, 0x74, 0x0D, 0xFF, 0xFF, 0xB0, 0xB7, 0x77, 0x30, 0x6F, 0xFF, 0xFC, 0x0D, 0x77, 0x73, 0x0E,
  0xC0, 0x88, 0x09, 0x76, 0x0B, 0xF0, 0xE7, 0x77, 0x20, 0x7C, 0x0C, 0x77, 0x60, 0x8F, 0x97, 0x77,
  0x10, 0x10, 0xEC, 0x04, 0x77, 0x60, 0x7F, 0x90, 0x27, 0x77, 0x08, 0xC0, 0xB7, 0x77, 0x05, 0xF9,
  0x03, 0x77, 0x60, 0x1D, 0x03, 0x77, 0x70, 0x4F, 0x90, 0x57, 0x76, 0x09, 0xC0, 0xB7, 0x77, 0x10,
  0x2F, 0x90, 0x77, 0x75, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x1F, 0x90, 0x87, 0x75, 0x0A, 0xC0, 0xA7,
  0x77, 0x3F, 0x90, 0xA7, 0x74, 0x03, 0xD0, 0x27, 0x77, 0x30, 0xEF, 0x0B, 0x77, 0x40, 0xBC, 0x09,
  0x77, 0x74, 0x0C, 0xF0, 0xD7, 0x73, 0x04, 0xD0, 0x27, 0x77, 0x40, 0xBF, 0x0E, 0x77, 0x30, 0xCC,
  0x0A, 0x77, 0x75, 0x0A, 0xF9, 0x77, 0x20, 0x6D, 0x04, 0x77, 0x75, 0x0A, 0xF9, 0x02, 0x77, 0x01,
  0x0E, 0xD0, 0x17, 0x77, 0x50, 0xBF, 0x90, 0x57, 0x70, 0xAD, 0x0E, 0x77, 0x76, 0x0E, 0xF9, 0x08,
  0x76, 0x05, 0xE0, 0xE7, 0x77, 0x50, 0x5F, 0xA0, 0xD7, 0x50, 0x30, 0xEF, 0x04, 0x77, 0x73, 0x03,
  0x0E, 0xFB, 0x05, 0x72, 0x02, 0x08, 0xFA, 0x81, 0xE7, 0x27, 0x76, 0x03, 0x08, 0xFE, 0x07, 0x01,
  0x40, 0x9F, 0xFC, 0x0B, 0x76, 0x03, 0xFF, 0xF0, 0x82, 0x0C, 0xFF, 0xC0, 0x87, 0x60, 0x6F, 0xFF,
  0x05, 0x20, 0xEF, 0xFC, 0x05, 0x76, 0x09, 0xFF, 0xF8, 0x13, 0x02, 0xFF, 0xD0, 0x27, 0x60, 0xBF,
  0xFF, 0x20,
  // "Â" (U+00C2)
  0x80, 0xC6, 0x08, 0x04, 0x78, 0x0D, 0x40, 0x09, 0xF9, 0x03, 0x80, 0xD2, 0x00, 0x4F, 0xA0, 0x78,
  0x0D, 0x10, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xD1, 0x00, 0xCF, 0xC0, 0x18, 0x0C, 0x70, 0x09, 0xFD,
  0x07, 0x80, 0xC6, 0x00, 0x6E, 0x0B, 0x0D, 0xD0, 0xC8, 0x0C, 0x50, 0x03, 0xE8, 0x1A, 0x04, 0xE0,
  0x28, 0x0C, 0x30, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x98, 0x0C, 0x30, 0x0C, 0xD0, 0x84, 0x01,
  0x0E, 0xC0, 0xE8, 0x0C, 0x20, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x78, 0x0C, 0x00, 0x09, 0xC0, 0xE0,
  0x57, 0x10, 0x9C, 0x0D, 0x77, 0x77, 0x70, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x77, 0x75,
  0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x77, 0x77, 0x50, 0xCA, 0x0D, 0x04, 0x77, 0x01,
  0x0C, 0xA0, 0xD8, 0x0D, 0x81, 0x00, 0x8E, 0x0B, 0x80, 0xD4, 0x00, 0x10, 0xEE, 0x0D, 0x80, 0xD4,
  0x00, 0x9F, 0x0E, 0x80, 0xD3, 0x00, 0x2F, 0xA8, 0x0D, 0x30, 0x0A, 0xFA, 0x02, 0x80, 0xD1, 0x00,
  0x3F, 0xB0, 0x38, 0x0D, 0x10, 0x0B, 0xFB, 0x05, 0x80, 0xD0, 0x00, 0x4F, 0xC0, 0x68, 0x0D, 0x00,
  0x0C, 0xB0, 0xCF, 0x08, 0x80, 0xC7, 0x00, 0x5C, 0x05, 0xF0, 0x98, 0x0C, 0x70, 0x0D, 0xB0, 0xB0,
  0x2F, 0x0B, 0x80, 0xC6, 0x00, 0x6C, 0x04, 0x02, 0xF0, 0xD8, 0x0C, 0x60, 0x0D, 0xB8, 0x1D, 0x01,
  0xF0, 0xE8, 0x0C, 0x50, 0x07, 0xC8, 0x16, 0x01, 0xF9, 0x80, 0xC4, 0x00, 0x10, 0xEB, 0x0E, 0x3F,
  0x90, 0x28, 0x0C, 0x30, 0x08, 0xC0, 0x73, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x10, 0xEB, 0x0E, 0x40,
  0xDF, 0x05, 0x80, 0xC2, 0x00, 0x9C, 0x06, 0x40, 0xCF, 0x06, 0x80, 0xC1, 0x00, 0x2C, 0x0D, 0x50,
  0xBF, 0x08, 0x80, 0xC1, 0x00, 0xAC, 0x05, 0x50, 0xAF, 0x09, 0x80, 0xC0, 0x00, 0x3C, 0x0C, 0x60,
  0x8F, 0x0B, 0x80, 0xC0, 0x00, 0xBC, 0x04, 0x60, 0x7F, 0x0D, 0x77, 0x77, 0x70, 0x4C, 0x0C, 0x70,
  0x6F, 0x0E, 0x77, 0x77, 0x70, 0xCC, 0x03, 0x70, 0x4F, 0x97, 0x77, 0x76, 0x05, 0xC0, 0xB7, 0x10,
  0x3F, 0x90, 0x27, 0x77, 0x75, 0x0D, 0xC0, 0x37, 0x10, 0x1F, 0x90, 0x37, 0x77, 0x74, 0x06, 0xC0,
  0xA7, 0x3F, 0x90, 0x57, 0x77, 0x74, 0x0E, 0xC0, 0x27, 0x30, 0xEF, 0x06, 0x77, 0x77, 0x30, 0x7C,
  0x09, 0x74, 0x0D, 0xF0, 0x87, 0x77, 0x72, 0x01, 0x0E, 0xC0, 0x17, 0x40, 0xBF, 0x0A, 0x77, 0x77,
  0x20, 0x8C, 0x08, 0x75, 0x0A, 0xF0, 0xB7, 0x77, 0x71, 0x01, 0xC0, 0xE0, 0x17, 0x50, 0x9F, 0x0D,
  0x77, 0x77, 0x10, 0x9C, 0x08, 0x76, 0x07, 0xF0, 0xE7, 0x77, 0x70, 0x2C, 0x0E, 0x77, 0x06, 0xF9,
  0x77, 0x77, 0x0A, 0xC0, 0x77, 0x70, 0x4F, 0x90, 0x27, 0x77, 0x50, 0x3C, 0x0D, 0x77, 0x10, 0x3F,
  0x90, 0x37, 0x77, 0x50, 0xBC, 0x06, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77, 0x40, 0x4C, 0x0D, 0x77,
  0x3F, 0x90, 0x67, 0x77, 0x40, 0xCF, 0xFF, 0xFA, 0x08, 0x77, 0x73, 0x05, 0xFF, 0xFF, 0xB0, 0xA7,
  0x77, 0x30, 0xDF, 0xFF, 0xFB, 0x0B, 0x77, 0x72, 0x06, 0xFF, 0xFF, 0xC0, 0xD7, 0x77, 0x20, 0xEC,
  0x08, 0x80, 0x97, 0x60, 0xBF, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xC7, 0x76, 0x08, 0xF9, 0x77, 0x70,
  0x10, 0xEC, 0x04, 0x77, 0x60, 0x7F, 0x90, 0x27, 0x76, 0x08, 0xC0, 0xB7, 0x77, 0x05, 0xF9, 0x03,
  0x77, 0x50, 0x1D, 0x03, 0x77, 0x70, 0x4F, 0x90, 0x57, 0x75, 0x09, 0xC0, 0xB7, 0x77, 0x10, 0x2F,
  0x90, 0x77, 0x74, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x1F, 0x90, 0x87, 0x74, 0x0A, 0xC0, 0xA7, 0x77,
  0x3F, 0x90, 0xA7, 0x73, 0x03, 0xD0, 0x27, 0x77, 0x30, 0xEF, 0x0B, 0x77, 0x30, 0xBC, 0x09, 0x77,
  0x74, 0x0C, 0xF0, 0xD7, 0x72, 0x04, 0xD0, 0x27, 0x77, 0x40, 0xBF, 0x0E, 0x77, 0x20, 0xCC, 0x0A,
  0x77, 0x75, 0x0A, 0xF9, 0x77, 0x10, 0x6D, 0x04, 0x77, 0x75, 0x0A, 0xF9, 0x02, 0x76, 0x01, 0x0E,
  0xD0, 0x17, 0x77, 0x50, 0xBF, 0x90, 0x57, 0x60, 0xAD, 0x0E, 0x77, 0x76, 0x0E, 0xF9, 0x08, 0x75,
  0x05, 0xE0, 0xE7, 0x77, 0x50, 0x5F, 0xA0, 0xD7, 0x40, 0x30, 0xEF, 0x04, 0x77, 0x73, 0x03, 0x0E,
  0xFB, 0x05, 0x71, 0x02, 0x08, 0xFA, 0x81, 0xE7, 0x27, 0x76, 0x03, 0x08, 0xFE, 0x07, 0x01, 0x30,
  0x9F, 0xFC, 0x0B, 0x76, 0x03, 0xFF, 0xF8, 0x18, 0x0C, 0xFF, 0xC0, 0x87, 0x60, 0x6F, 0xFF, 0x81,
  0x50, 0xEF, 0xFC, 0x05, 0x76, 0x09, 0xFF, 0xF0, 0x30, 0x2F, 0xFD, 0x02, 0x76, 0x0B, 0xFF, 0xF1,
  // "Ã" (U+00C3)
  0x77, 0x77, 0x78, 0x61, 0x7C, 0xEF, 0xDB, 0x57, 0x50, 0x20, 0xF4, 0x77, 0x77, 0x60, 0x70, 0xEF,
  0x0D, 0x03, 0x73, 0x0C, 0xA0, 0xD7, 0x77, 0x75, 0x09, 0xFC, 0x05, 0x71, 0x02, 0xB0, 0x97, 0x77,
  0x74, 0x08, 0xFE, 0x07, 0x70, 0x9B, 0x03, 0x77, 0x77, 0x30, 0x4F, 0xF9, 0x09, 0x50, 0x2B, 0x0C,
  0x77, 0x77, 0x40, 0xDB, 0x83, 0xA3, 0x02, 0x8F, 0x98, 0x4C, 0x41, 0x15, 0xEB, 0x04, 0x77, 0x77,
  0x30, 0x5B, 0x0A, 0x50, 0x40, 0xEF, 0xF0, 0xA7, 0x77, 0x74, 0x0C, 0xB0, 0x26, 0x02, 0x0D, 0xFD,
  0x0D, 0x01, 0x77, 0x77, 0x30, 0x3B, 0x09, 0x71, 0x01, 0x0C, 0xFB, 0x0E, 0x02, 0x77, 0x77, 0x40,
  0x7B, 0x03, 0x73, 0x08, 0xF9, 0x0C, 0x02, 0x77, 0x77, 0x50, 0x20, 0xF4, 0x75, 0x86, 0x28, 0xCE,
  0xED, 0xA5, 0x80, 0xD9, 0x70, 0x08, 0xE0, 0xB8, 0x0D, 0x60, 0x01, 0x0E, 0xE0, 0xD8, 0x0D, 0x60,
  0x09, 0xF0, 0xE8, 0x0D, 0x50, 0x02, 0xFA, 0x80, 0xD5, 0x00, 0xAF, 0xA0, 0x28, 0x0D, 0x30, 0x03,
  0xFB, 0x03, 0x80, 0xD3, 0x00, 0xBF, 0xB0, 0x58, 0x0D, 0x20, 0x04, 0xFC, 0x06, 0x80, 0xD2, 0x00,
  0xCB, 0x0C, 0xF0, 0x88, 0x0D, 0x10, 0x05, 0xC0, 0x5F, 0x09, 0x80, 0xD1, 0x00, 0xDB, 0x0B, 0x02,
  0xF0, 0xB8, 0x0D, 0x00, 0x06, 0xC0, 0x40, 0x2F, 0x0D, 0x80, 0xD0, 0x00, 0xDB, 0x81, 0xD0, 0x1F,
  0x0E, 0x80, 0xC7, 0x00, 0x7C, 0x81, 0x60, 0x1F, 0x98, 0x0C, 0x60, 0x01, 0x0E, 0xB0, 0xE3, 0xF9,
  0x02, 0x80, 0xC5, 0x00, 0x8C, 0x07, 0x3F, 0x90, 0x38, 0x0C, 0x40, 0x01, 0x0E, 0xB0, 0xE4, 0x0D,
  0xF0, 0x58, 0x0C, 0x40, 0x09, 0xC0, 0x64, 0x0C, 0xF0, 0x68, 0x0C, 0x30, 0x02, 0xC0, 0xD5, 0x0B,
  0xF0, 0x88, 0x0C, 0x30, 0x0A, 0xC0, 0x55, 0x0A, 0xF0, 0x98, 0x0C, 0x20, 0x03, 0xC0, 0xC6, 0x08,
  0xF0, 0xB8, 0x0C, 0x20, 0x0B, 0xC0, 0x46, 0x07, 0xF0, 0xD8, 0x0C, 0x10, 0x04, 0xC0, 0xC7, 0x06,
  0xF0, 0xE8, 0x0C, 0x10, 0x0C, 0xC0, 0x37, 0x04, 0xF9, 0x80, 0xC0, 0x00, 0x5C, 0x0B, 0x71, 0x03,
  0xF9, 0x02, 0x77, 0x77, 0x70, 0xDC, 0x03, 0x71, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x60, 0x6C, 0x0A,
  0x73, 0xF9, 0x05, 0x77, 0x77, 0x60, 0xEC, 0x02, 0x73, 0x0E, 0xF0, 0x67, 0x77, 0x75, 0x07, 0xC0,
  0x97, 0x40, 0xDF, 0x08, 0x77, 0x77, 0x40, 0x10, 0xEC, 0x01, 0x74, 0x0B, 0xF0, 0xA7, 0x77, 0x74,
  0x08, 0xC0, 0x87, 0x50, 0xAF, 0x0B, 0x77, 0x77, 0x30, 0x1C, 0x0E, 0x01, 0x75, 0x09, 0xF0, 0xD7,
  0x77, 0x73, 0x09, 0xC0, 0x87, 0x60, 0x7F, 0x0E, 0x77, 0x77, 0x20, 0x2C, 0x0E, 0x77, 0x06, 0xF9,
  0x77, 0x77, 0x20, 0xAC, 0x07, 0x77, 0x04, 0xF9, 0x02, 0x77, 0x77, 0x03, 0xC0, 0xD7, 0x71, 0x03,
  0xF9, 0x03, 0x77, 0x77, 0x0B, 0xC0, 0x67, 0x71, 0x02, 0xF9, 0x05, 0x77, 0x76, 0x04, 0xC0, 0xD7,
  0x73, 0xF9, 0x06, 0x77, 0x76, 0x0C, 0xFF, 0xFF, 0xA0, 0x87, 0x77, 0x50, 0x5F, 0xFF, 0xFB, 0x0A,
  0x77, 0x75, 0x0D, 0xFF, 0xFF, 0xB0, 0xB7, 0x77, 0x40, 0x6F, 0xFF, 0xFC, 0x0D, 0x77, 0x74, 0x0E,
  0xC0, 0x88, 0x09, 0x76, 0x0B, 0xF0, 0xE7, 0x77, 0x30, 0x7C, 0x0C, 0x77, 0x60, 0x8F, 0x97, 0x77,
  0x20, 0x10, 0xEC, 0x04, 0x77, 0x60, 0x7F, 0x90, 0x27, 0x77, 0x10, 0x8C, 0x0B, 0x77, 0x70, 0x5F,
  0x90, 0x37, 0x77, 0x01, 0xD0, 0x37, 0x77, 0x04, 0xF9, 0x05, 0x77, 0x70, 0x9C, 0x0B, 0x77, 0x71,
  0x02, 0xF9, 0x07, 0x77, 0x60, 0x2D, 0x03, 0x77, 0x71, 0x01, 0xF9, 0x08, 0x77, 0x60, 0xAC, 0x0A,
  0x77, 0x73, 0xF9, 0x0A, 0x77, 0x50, 0x3D, 0x02, 0x77, 0x73, 0x0E, 0xF0, 0xB7, 0x75, 0x0B, 0xC0,
  0x97, 0x77, 0x40, 0xCF, 0x0D, 0x77, 0x40, 0x4D, 0x02, 0x77, 0x74, 0x0B, 0xF0, 0xE7, 0x74, 0x0C,
  0xC0, 0xA7, 0x77, 0x50, 0xAF, 0x97, 0x73, 0x06, 0xD0, 0x47, 0x77, 0x50, 0xAF, 0x90, 0x27, 0x71,
  0x01, 0x0E, 0xD0, 0x17, 0x77, 0x50, 0xBF, 0x90, 0x57, 0x71, 0x0A, 0xD0, 0xE7, 0x77, 0x60, 0xEF,
  0x90, 0x87, 0x70, 0x5E, 0x0E, 0x77, 0x75, 0x05, 0xFA, 0x0D, 0x76, 0x03, 0x0E, 0xF0, 0x47, 0x77,
  0x30, 0x30, 0xEF, 0xB0, 0x57, 0x30, 0x20, 0x8F, 0xA8, 0x1E, 0x72, 0x77, 0x60, 0x30, 0x8F, 0xE0,
  0x70, 0x15, 0x09, 0xFF, 0xC0, 0xB7, 0x60, 0x3F, 0xFF, 0x08, 0x30, 0xCF, 0xFC, 0x08, 0x76, 0x06,
  0xFF, 0xF0, 0x53, 0x0E, 0xFF, 0xC0, 0x57, 0x60, 0x9F, 0xFF, 0x03, 0x20, 0x2F, 0xFD, 0x02, 0x76,
  0x0B, 0xFF, 0xF3,
  // "Ä" (U+00C4)
  0x77, 0x77, 0x68, 0x35, 0xCF, 0xD7, 0x73, 0x83, 0x6D, 0xFD, 0x78, 0x0C, 0x00, 0x07, 0xD0, 0x97,
  0x10, 0x8D, 0x08, 0x77, 0x77, 0x60, 0x2F, 0x01, 0x60, 0x2E, 0x0E, 0x77, 0x77, 0x60, 0x7F, 0x03,
  0x60, 0x8F, 0x02, 0x77, 0x77, 0x50, 0xBF, 0x04, 0x60, 0xCF, 0x03, 0x77, 0x77, 0x50, 0xCF, 0x03,
  0x60, 0xDF, 0x02, 0x77, 0x77, 0x50, 0xBF, 0x70, 0xCF, 0x77, 0x77, 0x60, 0x9E, 0x0B, 0x70, 0xAE,
  0x0A, 0x77, 0x77, 0x60, 0x2D, 0x0E, 0x02, 0x70, 0x3D, 0x0D, 0x01, 0x77, 0x77, 0x78, 0x43, 0xBE,
  0xEA, 0x17, 0x28, 0x44, 0xCF, 0xE9, 0x18, 0x0F, 0xD5, 0x00, 0x8E, 0x0B, 0x80, 0xD4, 0x00, 0x10,
  0xEE, 0x0D, 0x80, 0xD4, 0x00, 0x9F, 0x0E, 0x80, 0xD3, 0x00, 0x2F, 0xA8, 0x0D, 0x30, 0x0A, 0xFA,
  0x02, 0x80, 0xD1, 0x00, 0x3F, 0xB0, 0x38, 0x0D, 0x10, 0x0B, 0xFB, 0x05, 0x80, 0xD0, 0x00, 0x4F,
  0xC0, 0x68, 0x0D, 0x00, 0x0C, 0xB0, 0xCF, 0x08, 0x80, 0xC7, 0x00, 0x5C, 0x05, 0xF0, 0x98, 0x0C,
  0x70, 0x0D, 0xB0, 0xB0, 0x2F, 0x0B, 0x80, 0xC6, 0x00, 0x6C, 0x04, 0x02, 0xF0, 0xD8, 0x0C, 0x60,
  0x0D, 0xB8, 0x1D, 0x01, 0xF0, 0xE8, 0x0C, 0x50, 0x07, 0xC8, 0x16, 0x01, 0xF9, 0x80, 0xC4, 0x00,
  0x10, 0xEB, 0x0E, 0x3F, 0x90, 0x28, 0x0C, 0x30, 0x08, 0xC0, 0x73, 0xF9, 0x03, 0x80, 0xC2, 0x00,
  0x10, 0xEB, 0x0E, 0x40, 0xDF, 0x05, 0x80, 0xC2, 0x00, 0x9C, 0x06, 0x40, 0xCF, 0x06, 0x80, 0xC1,
  0x00, 0x2C, 0x0D, 0x50, 0xBF, 0x08, 0x80, 0xC1, 0x00, 0xAC, 0x05, 0x50, 0xAF, 0x09, 0x80, 0xC0,
  0x00, 0x3C, 0x0C, 0x60, 0x8F, 0x0B, 0x80, 0xC0, 0x00, 0xBC, 0x04, 0x60, 0x7F, 0x0D, 0x77, 0x77,
  0x70, 0x4C, 0x0C, 0x70, 0x6F, 0x0E, 0x77, 0x77, 0x70, 0xCC, 0x03, 0x70, 0x4F, 0x97, 0x77, 0x76,
  0x05, 0xC0, 0xB7, 0x10, 0x3F, 0x90, 0x27, 0x77, 0x75, 0x0D, 0xC0, 0x37, 0x10, 0x1F, 0x90, 0x37,
  0x77, 0x74, 0x06, 0xC0, 0xA7, 0x3F, 0x90, 0x57, 0x77, 0x74, 0x0E, 0xC0, 0x27, 0x30, 0xEF, 0x06,
  0x77, 0x77, 0x30, 0x7C, 0x09, 0x74, 0x0D, 0xF0, 0x87, 0x77, 0x72, 0x01, 0x0E, 0xC0, 0x17, 0x40,
  0xBF, 0x0A, 0x77, 0x77, 0x20, 0x8C, 0x08, 0x75, 0x0A, 0xF0, 0xB7, 0x77, 0x71, 0x01, 0xC0, 0xE0,
  0x17, 0x50, 0x9F, 0x0D, 0x77, 0x77, 0x10, 0x9C, 0x08, 0x76, 0x07, 0xF0, 0xE7, 0x77, 0x70, 0x2C,
  0x0E, 0x77, 0x06, 0xF9, 0x77, 0x77, 0x0A, 0xC0, 0x77, 0x70, 0x4F, 0x90, 0x27, 0x77, 0x50, 0x3C,
  0x0D, 0x77, 0x10, 0x3F, 0x90, 0x37, 0x77, 0x50, 0xBC, 0x06, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77,
  0x40, 0x4C, 0x0D, 0x77, 0x3F, 0x90, 0x67, 0x77, 0x40, 0xCF, 0xFF, 0xFA, 0x08, 0x77, 0x73, 0x05,
  0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x30, 0xDF, 0xFF, 0xFB, 0x0B, 0x77, 0x72, 0x06, 0xFF, 0xFF, 0xC0,
  0xD7, 0x77, 0x20, 0xEC, 0x08, 0x80, 0x97, 0x60, 0xBF, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xC7, 0x76,
  0x08, 0xF9, 0x77, 0x70, 0x10, 0xEC, 0x04, 0x77, 0x60, 0x7F, 0x90, 0x27, 0x76, 0x08, 0xC0, 0xB7,
  0x77, 0x05, 0xF9, 0x03, 0x77, 0x50, 0x1D, 0x03, 0x77, 0x70, 0x4F, 0x90, 0x57, 0x75, 0x09, 0xC0,
  0xB7, 0x77, 0x10, 0x2F, 0x90, 0x77, 0x74, 0x02, 0xD0, 0x37, 0x77, 0x10, 0x1F, 0x90, 0x87, 0x74,
  0x0A, 0xC0, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x73, 0x03, 0xD0, 0x27, 0x77, 0x30, 0xEF, 0x0B, 0x77,
  0x30, 0xBC, 0x09, 0x77, 0x74, 0x0C, 0xF0, 0xD7, 0x72, 0x04, 0xD0, 0x27, 0x77, 0x40, 0xBF, 0x0E,
  0x77, 0x20, 0xCC, 0x0A, 0x77, 0x75, 0x0A, 0xF9, 0x77, 0x10, 0x6D, 0x04, 0x77, 0x75, 0x0A, 0xF9,
  0x02, 0x76, 0x01, 0x0E, 0xD0, 0x17, 0x77, 0x50, 0xBF, 0x90, 0x57, 0x60, 0xAD, 0x0E, 0x77, 0x76,
  0x0E, 0xF9, 0x08, 0x75, 0x05, 0xE0, 0xE7, 0x77, 0x50, 0x5F, 0xA0, 0xD7, 0x40, 0x30, 0xEF, 0x04,
  0x77, 0x73, 0x03, 0x0E, 0xFB, 0x05, 0x71, 0x02, 0x08, 0xFA, 0x81, 0xE7, 0x27, 0x76, 0x03, 0x08,
  0xFE, 0x07, 0x01, 0x30, 0x9F, 0xFC, 0x0B, 0x76, 0x03, 0xFF, 0xF8, 0x18, 0x0C, 0xFF, 0xC0, 0x87,
  0x60, 0x6F, 0xFF, 0x81, 0x50, 0xEF, 0xFC, 0x05, 0x76, 0x09, 0xFF, 0xF0, 0x30, 0x2F, 0xFD, 0x02,
  0x76, 0x0B, 0xFF, 0xF1,
  // "Å" (U+00C5)
  0x80, 0xC2, 0x08, 0x74, 0x9C, 0xEF, 0xEC, 0x94, 0x80, 0xD2, 0x00, 0x30, 0xCF, 0xA0, 0xC0, 0x38,
  0x0C, 0x70, 0x06, 0xFE, 0x05, 0x80, 0xC5, 0x00, 0x5F, 0xF9, 0x03, 0x80, 0xC4, 0x00, 0xDD, 0x83,
  0xA7, 0x67, 0xBD, 0x0B, 0x80, 0xC3, 0x00, 0x6C, 0x0B, 0x01, 0x50, 0x30, 0xDC, 0x01, 0x80, 0xC2,
  0x00, 0xAB, 0x0D, 0x71, 0x02, 0xC0, 0x58, 0x0C, 0x20, 0x0D, 0xB0, 0x77, 0x20, 0xCB, 0x07, 0x80,
  0xC2, 0x00, 0xEB, 0x04, 0x72, 0x0A, 0xB0, 0x88, 0x0C, 0x20, 0xC0, 0x37, 0x20, 0xAB, 0x08, 0x80,
  0xC2, 0x00, 0xEB, 0x05, 0x72, 0x0D, 0xB0, 0x68, 0x0C, 0x20, 0x0C, 0xB0, 0xB7, 0x10, 0x5C, 0x03,
  0x80, 0xC2, 0x00, 0x8C, 0x08, 0x60, 0x50, 0xEB, 0x0E, 0x80, 0xC3, 0x00, 0x3D, 0x84, 0xE9, 0x76,
  0x8D, 0xD0, 0x68, 0x0C, 0x40, 0x09, 0xFF, 0x0C, 0x80, 0xC6, 0x00, 0xBF, 0xD0, 0xC0, 0x18, 0x0C,
  0x70, 0x07, 0xFA, 0x0E, 0x07, 0x80, 0xD2, 0x00, 0xAF, 0x90, 0x18, 0x0D, 0x20, 0x02, 0xFA, 0x80,
  0xD3, 0x00, 0xAF, 0xA0, 0x28, 0x0D, 0x10, 0x03, 0xFB, 0x03, 0x80, 0xD1, 0x00, 0xBF, 0xB0, 0x58,
  0x0D, 0x00, 0x04, 0xFC, 0x06, 0x80, 0xD0, 0x00, 0xCB, 0x0C, 0xF0, 0x88, 0x0C, 0x70, 0x05, 0xC0,
  0x5F, 0x09, 0x80, 0xC7, 0x00, 0xDB, 0x0B, 0x02, 0xF0, 0xB8, 0x0C, 0x60, 0x06, 0xC0, 0x40, 0x2F,
  0x0D, 0x80, 0xC6, 0x00, 0xDB, 0x81, 0xD0, 0x1F, 0x0E, 0x80, 0xC5, 0x00, 0x7C, 0x81, 0x60, 0x1F,
  0x98, 0x0C, 0x40, 0x01, 0x0E, 0xB0, 0xE3, 0xF9, 0x02, 0x80, 0xC3, 0x00, 0x8C, 0x07, 0x3F, 0x90,
  0x38, 0x0C, 0x20, 0x01, 0x0E, 0xB0, 0xE4, 0x0D, 0xF0, 0x58, 0x0C, 0x20, 0x09, 0xC0, 0x64, 0x0C,
  0xF0, 0x68, 0x0C, 0x10, 0x02, 0xC0, 0xD5, 0x0B, 0xF0, 0x88, 0x0C, 0x10, 0x0A, 0xC0, 0x55, 0x0A,
  0xF0, 0x98, 0x0C, 0x00, 0x03, 0xC0, 0xC6, 0x08, 0xF0, 0xB8, 0x0C, 0x00, 0x0B, 0xC0, 0x46, 0x07,
  0xF0, 0xD7, 0x77, 0x77, 0x04, 0xC0, 0xC7, 0x06, 0xF0, 0xE7, 0x77, 0x77, 0x0C, 0xC0, 0x37, 0x04,
  0xF9, 0x77, 0x77, 0x60, 0x5C, 0x0B, 0x71, 0x03, 0xF9, 0x02, 0x77, 0x77, 0x50, 0xDC, 0x03, 0x71,
  0x01, 0xF9, 0x03, 0x77, 0x77, 0x40, 0x6C, 0x0A, 0x73, 0xF9, 0x05, 0x77, 0x77, 0x40, 0xEC, 0x02,
  0x73, 0x0E, 0xF0, 0x67, 0x77, 0x73, 0x07, 0xC0, 0x97, 0x40, 0xDF, 0x08, 0x77, 0x77, 0x20, 0x10,
  0xEC, 0x01, 0x74, 0x0B, 0xF0, 0xA7, 0x77, 0x72, 0x08, 0xC0, 0x87, 0x50, 0xAF, 0x0B, 0x77, 0x77,
  0x10, 0x1C, 0x0E, 0x01, 0x75, 0x09, 0xF0, 0xD7, 0x77, 0x71, 0x09, 0xC0, 0x87, 0x60, 0x7F, 0x0E,
  0x77, 0x77, 0x02, 0xC0, 0xE7, 0x70, 0x6F, 0x97, 0x77, 0x70, 0xAC, 0x07, 0x77, 0x04, 0xF9, 0x02,
  0x77, 0x75, 0x03, 0xC0, 0xD7, 0x71, 0x03, 0xF9, 0x03, 0x77, 0x75, 0x0B, 0xC0, 0x67, 0x71, 0x02,
  0xF9, 0x05, 0x77, 0x74, 0x04, 0xC0, 0xD7, 0x73, 0xF9, 0x06, 0x77, 0x74, 0x0C, 0xFF, 0xFF, 0xA0,
  0x87, 0x77, 0x30, 0x5F, 0xFF, 0xFB, 0x0A, 0x77, 0x73, 0x0D, 0xFF, 0xFF, 0xB0, 0xB7, 0x77, 0x20,
  0x6F, 0xFF, 0xFC, 0x0D, 0x77, 0x72, 0x0E, 0xC0, 0x88, 0x09, 0x76, 0x0B, 0xF0, 0xE7, 0x77, 0x10,
  0x7C, 0x0C, 0x77, 0x60, 0x8F, 0x97, 0x77, 0x01, 0x0E, 0xC0, 0x47, 0x76, 0x07, 0xF9, 0x02, 0x77,
  0x60, 0x8C, 0x0B, 0x77, 0x70, 0x5F, 0x90, 0x37, 0x75, 0x01, 0xD0, 0x37, 0x77, 0x04, 0xF9, 0x05,
  0x77, 0x50, 0x9C, 0x0B, 0x77, 0x71, 0x02, 0xF9, 0x07, 0x77, 0x40, 0x2D, 0x03, 0x77, 0x71, 0x01,
  0xF9, 0x08, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x30, 0x3D, 0x02, 0x77, 0x73,
  0x0E, 0xF0, 0xB7, 0x73, 0x0B, 0xC0, 0x97, 0x77, 0x40, 0xCF, 0x0D, 0x77, 0x20, 0x4D, 0x02, 0x77,
  0x74, 0x0B, 0xF0, 0xE7, 0x72, 0x0C, 0xC0, 0xA7, 0x77, 0x50, 0xAF, 0x97, 0x71, 0x06, 0xD0, 0x47,
  0x77, 0x50, 0xAF, 0x90, 0x27, 0x60, 0x10, 0xED, 0x01, 0x77, 0x75, 0x0B, 0xF9, 0x05, 0x76, 0x0A,
  0xD0, 0xE7, 0x77, 0x60, 0xEF, 0x90, 0x87, 0x50, 0x5E, 0x0E, 0x77, 0x75, 0x05, 0xFA, 0x0D, 0x74,
  0x03, 0x0E, 0xF0, 0x47, 0x77, 0x30, 0x30, 0xEF, 0xB0, 0x57, 0x10, 0x20, 0x8F, 0xA8, 0x1E, 0x72,
  0x77, 0x60, 0x30, 0x8F, 0xE0, 0x70, 0x13, 0x09, 0xFF, 0xC0, 0xB7, 0x60, 0x3F, 0xFF, 0x81, 0x80,
  0xCF, 0xFC, 0x08, 0x76, 0x06, 0xFF, 0xF8, 0x15, 0x0E, 0xFF, 0xC0, 0x57, 0x60, 0x9F, 0xFF, 0x03,
  0x02, 0xFF, 0xD0, 0x27, 0x60, 0xBF, 0xFF, 0x10,
  // "Æ" (U+00C6)
  0x80, 0xC1, 0x00, 0x48, 0x0C, 0x7F, 0x0E, 0x80, 0xC1, 0x00, 0x78, 0x0C, 0x7F, 0x0B, 0x80, 0xC1,
  0x00, 0xA8, 0x0C, 0x7F, 0x09, 0x80, 0xC1, 0x08, 0x1A, 0xCE, 0x80, 0xC5, 0xF0, 0x68, 0x0C, 0x50,
  0x81, 0x12, 0xEB, 0x09, 0x07, 0xF9, 0x0A, 0x80, 0x90, 0x68, 0x17, 0x8D, 0xF9, 0x03, 0x80, 0xC6,
  0x00, 0x7B, 0x81, 0xC0, 0x4F, 0x90, 0x57, 0x71, 0x06, 0xF8, 0x0C, 0x60, 0x02, 0xC8, 0x14, 0x08,
  0xF9, 0x01, 0x77, 0x20, 0x8D, 0x0C, 0x80, 0xC6, 0x00, 0xCB, 0x0A, 0x20, 0xBF, 0x0D, 0x77, 0x30,
  0x1D, 0x09, 0x80, 0xC5, 0x00, 0x7B, 0x0E, 0x01, 0x20, 0xEF, 0x0A, 0x77, 0x40, 0xCC, 0x07, 0x80,
  0xC4, 0x00, 0x2C, 0x07, 0x20, 0x2F, 0x90, 0x77, 0x74, 0x0A, 0xC0, 0x48, 0x0C, 0x40, 0x0C, 0xB0,
  0xD3, 0x05, 0xF9, 0x03, 0x77, 0x40, 0xAC, 0x01, 0x80, 0xC3, 0x00, 0x7C, 0x04, 0x30, 0x9F, 0x97,
  0x75, 0x0B, 0xB0, 0xD8, 0x0C, 0x30, 0x02, 0xC0, 0xA4, 0x0C, 0xF0, 0xC7, 0x75, 0x0C, 0xB0, 0xA8,
  0x0C, 0x30, 0x0B, 0xB0, 0xE0, 0x14, 0xF9, 0x09, 0x77, 0x50, 0xEB, 0x08, 0x80, 0xC2, 0x00, 0x6C,
  0x06, 0x40, 0x3F, 0x90, 0x57, 0x75, 0xC0, 0x58, 0x0C, 0x10, 0x02, 0x0E, 0xB0, 0xC5, 0x06, 0xF9,
  0x02, 0x77, 0x58, 0x00, 0x60, 0x18, 0x0C, 0x10, 0x0B, 0xC0, 0x35, 0x09, 0xF0, 0xE8, 0x0F, 0x10,
  0x06, 0xC0, 0x86, 0x0D, 0xF0, 0xB8, 0x0F, 0x00, 0x01, 0x0E, 0xB0, 0xD6, 0x01, 0xF9, 0x07, 0x80,
  0xF0, 0x00, 0xBC, 0x04, 0x60, 0x4F, 0x90, 0x48, 0x0E, 0x70, 0x06, 0xC0, 0xA7, 0x07, 0xF9, 0x01,
  0x80, 0xE6, 0x00, 0x10, 0xEB, 0x0E, 0x01, 0x70, 0xAF, 0x0D, 0x80, 0xE7, 0x00, 0xBC, 0x05, 0x71,
  0x0E, 0xF0, 0x98, 0x0E, 0x60, 0x05, 0xC0, 0xB7, 0x10, 0x1F, 0x90, 0x68, 0x0E, 0x50, 0x01, 0x0E,
  0xB0, 0xE0, 0x17, 0x10, 0x5F, 0x90, 0x38, 0x0E, 0x50, 0x0A, 0xC0, 0x67, 0x20, 0x8F, 0x0E, 0x80,
  0xE5, 0x00, 0x5C, 0x0C, 0x73, 0x0B, 0xF0, 0xB8, 0x0E, 0x40, 0x01, 0x0E, 0xC0, 0x27, 0x30, 0xEF,
  0x08, 0x80, 0xE4, 0x00, 0xAC, 0x07, 0x73, 0x02, 0xFF, 0xFD, 0x0D, 0x80, 0xC1, 0x00, 0x5C, 0x0C,
  0x74, 0x06, 0xFF, 0xFD, 0x09, 0x80, 0xC0, 0x00, 0x10, 0xEC, 0x03, 0x74, 0x09, 0xFF, 0xFD, 0x06,
  0x80, 0xC0, 0x00, 0xAC, 0x08, 0x75, 0x0C, 0xFF, 0xFD, 0x02, 0x77, 0x77, 0x70, 0x4C, 0x0D, 0x76,
  0xF9, 0x0A, 0x80, 0x96, 0x67, 0x77, 0x77, 0x01, 0x0E, 0xC0, 0x37, 0x50, 0x3F, 0x90, 0x48, 0x0E,
  0x10, 0x09, 0xC0, 0x97, 0x60, 0x7F, 0x90, 0x18, 0x0E, 0x00, 0x04, 0xC0, 0xD7, 0x70, 0xAF, 0x0D,
  0x80, 0xE0, 0x00, 0x10, 0xDC, 0x04, 0x77, 0x0D, 0xF0, 0xA8, 0x0E, 0x00, 0x09, 0xC0, 0xA7, 0x70,
  0x1F, 0x90, 0x78, 0x0D, 0x70, 0x04, 0xFF, 0xFF, 0x90, 0x48, 0x0D, 0x70, 0x0D, 0xFF, 0xFF, 0x98,
  0x0D, 0x70, 0x09, 0xFF, 0xFF, 0x90, 0xD8, 0x0D, 0x60, 0x04, 0xFF, 0xFF, 0xA0, 0x98, 0x0D, 0x60,
  0x0D, 0xC0, 0x78, 0x09, 0x46, 0x08, 0xF9, 0x06, 0x80, 0xD5, 0x00, 0x8C, 0x0A, 0x77, 0x30, 0x6F,
  0x90, 0x38, 0x0D, 0x40, 0x03, 0xC0, 0xE0, 0x17, 0x73, 0x09, 0xF9, 0x80, 0xD5, 0x00, 0xDC, 0x05,
  0x77, 0x40, 0xDF, 0x0C, 0x80, 0xD4, 0x00, 0x8C, 0x0B, 0x77, 0x40, 0x1F, 0x90, 0x98, 0x0D, 0x30,
  0x03, 0xD0, 0x27, 0x74, 0x04, 0xF9, 0x05, 0x80, 0xD3, 0x00, 0xDC, 0x07, 0x77, 0x50, 0x7F, 0x90,
  0x27, 0x77, 0x83, 0x59, 0x99, 0x77, 0x76, 0x08, 0xC0, 0xC7, 0x76, 0x0B, 0xF0, 0xE7, 0x77, 0x10,
  0xCB, 0x08, 0x77, 0x50, 0x3D, 0x03, 0x77, 0x60, 0xEF, 0x0B, 0x77, 0x70, 0x2C, 0x04, 0x77, 0x50,
  0xCC, 0x08, 0x77, 0x60, 0x2F, 0x90, 0x87, 0x77, 0x07, 0xC0, 0x17, 0x74, 0x08, 0xC0, 0xD7, 0x77,
  0x05, 0xF9, 0x05, 0x77, 0x70, 0xDB, 0x0C, 0x77, 0x40, 0x3D, 0x05, 0x77, 0x70, 0x9F, 0x90, 0x27,
  0x76, 0x03, 0xC0, 0x87, 0x74, 0x0C, 0xC0, 0xD7, 0x77, 0x10, 0xCF, 0x0E, 0x77, 0x70, 0xBC, 0x05,
  0x77, 0x30, 0x8D, 0x06, 0x77, 0x70, 0x1F, 0x90, 0xB7, 0x76, 0x05, 0xD0, 0x17, 0x72, 0x04, 0xE0,
  0x27, 0x77, 0x06, 0xF9, 0x07, 0x77, 0x50, 0x20, 0xEC, 0x0C, 0x77, 0x20, 0x20, 0xEE, 0x01, 0x77,
  0x60, 0x10, 0xDF, 0x90, 0x47, 0x74, 0x02, 0x0D, 0xD0, 0x87, 0x71, 0x03, 0x0E, 0xF0, 0x57, 0x75,
  0x01, 0x0B, 0xFA, 0x01, 0x77, 0x30, 0x60, 0xEE, 0x05, 0x76, 0x03, 0x08, 0xFA, 0x81, 0xE6, 0x17,
  0x68, 0x31, 0x25, 0xAE, 0xFA, 0x0E, 0x80, 0x93, 0x68, 0x17, 0xAE, 0xF9, 0x01, 0x73, 0x06, 0xFF,
  0xC0, 0x87, 0x10, 0x58, 0x0C, 0x5F, 0x0C, 0x74, 0x0A, 0xFF, 0xC0, 0x57, 0x10, 0x88, 0x0C, 0x5F,
  0x09, 0x74, 0x0D, 0xFF, 0xC0, 0x37, 0x10, 0xB8, 0x0C, 0x5F, 0x05, 0x73, 0x01, 0xFF, 0xD7, 0x20,
  0xE8, 0x0C, 0x5F, 0x01, 0x73,
  // "Ç" (U+00C7)
  0x77, 0x76, 0x89, 0x42, 0x58, 0xBC, 0xDE, 0xFE, 0xDC, 0xA7, 0x47, 0x77, 0x74, 0x81, 0x27, 0xDF,
  0xF8, 0x1E, 0xA3, 0x77, 0x76, 0x04, 0x0B, 0xFF, 0xE0, 0x90, 0x17, 0x77, 0x20, 0x30, 0xBF, 0xFF,
  0xA0, 0xD0, 0x27, 0x77, 0x08, 0xFA, 0x85, 0xEA, 0x87, 0x68, 0xCF, 0xB0, 0xD7, 0x75, 0x03, 0x0D,
  0xF9, 0x0A, 0x03, 0x70, 0x30, 0xDF, 0xA0, 0x97, 0x73, 0x05, 0xF9, 0x0B, 0x02, 0x73, 0x01, 0x0E,
  0xFA, 0x01, 0x77, 0x10, 0x8F, 0x90, 0x77, 0x60, 0x6F, 0xA0, 0x67, 0x70, 0x9F, 0x0E, 0x04, 0x77,
  0x10, 0xDF, 0x90, 0x87, 0x60, 0x9F, 0x0E, 0x03, 0x77, 0x20, 0x8F, 0x90, 0x97, 0x50, 0x8F, 0x90,
  0x37, 0x73, 0x04, 0xF9, 0x08, 0x74, 0x05, 0xF9, 0x05, 0x77, 0x40, 0x1F, 0x90, 0x57, 0x30, 0x3F,
  0x90, 0x87, 0x76, 0x0E, 0xE0, 0xE0, 0x17, 0x20, 0x10, 0xDF, 0x0C, 0x77, 0x70, 0xCE, 0x06, 0x73,
  0x09, 0xF9, 0x03, 0x77, 0x70, 0xBD, 0x07, 0x73, 0x04, 0xF9, 0x09, 0x77, 0x71, 0x0B, 0xB0, 0xC0,
  0x47, 0x40, 0xDF, 0x0E, 0x01, 0x77, 0x71, 0x82, 0x79, 0x73, 0x75, 0x07, 0xF9, 0x07, 0x80, 0xC2,
  0x00, 0x10, 0xEF, 0x0E, 0x80, 0xC3, 0x00, 0x9F, 0x90, 0x78, 0x0C, 0x20, 0x01, 0xFA, 0x01, 0x80,
  0xC2, 0x00, 0x8F, 0x90, 0x98, 0x0C, 0x30, 0x0E, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x6F, 0x90, 0xC8,
  0x0C, 0x30, 0x0C, 0xF9, 0x07, 0x80, 0xC2, 0x00, 0x2F, 0xA0, 0x28, 0x0C, 0x20, 0x08, 0xF9, 0x0C,
  0x80, 0xC3, 0x00, 0xDF, 0x90, 0x78, 0x0C, 0x20, 0x02, 0xFA, 0x03, 0x80, 0xC2, 0x00, 0x6F, 0x90,
  0xE8, 0x0C, 0x30, 0x0A, 0xF9, 0x0B, 0x80, 0xC3, 0x00, 0xEF, 0x90, 0x78, 0x0C, 0x20, 0x02, 0xFA,
  0x04, 0x80, 0xC2, 0x00, 0x5F, 0xA8, 0x0C, 0x30, 0x07, 0xF9, 0x0D, 0x80, 0xC3, 0x00, 0xAF, 0x90,
  0xA8, 0x0C, 0x30, 0x0C, 0xF9, 0x08, 0x80, 0xC3, 0x00, 0xEF, 0x90, 0x68, 0x0C, 0x30, 0xFA, 0x04,
  0x80, 0xC2, 0x00, 0x1F, 0xA0, 0x28, 0x0C, 0x20, 0x02, 0xFA, 0x01, 0x80, 0xC2, 0x00, 0x2F, 0xA8,
  0x0C, 0x30, 0x03, 0xFA, 0x80, 0xC3, 0x00, 0x3F, 0xA8, 0x0C, 0x30, 0x03, 0xFA, 0x80, 0xC3, 0x00,
  0x2F, 0xA8, 0x0C, 0x30, 0x01, 0xFA, 0x01, 0x80, 0xC3, 0x0F, 0xA0, 0x28, 0x0C, 0x30, 0x0D, 0xF9,
  0x05, 0x80, 0xC3, 0x00, 0xAF, 0x90, 0x88, 0x0C, 0x30, 0x07, 0xF9, 0x0B, 0x80, 0xC3, 0x00, 0x3F,
  0xA0, 0x18, 0x0C, 0x30, 0x0E, 0xF9, 0x06, 0x77, 0x74, 0x0A, 0x02, 0x75, 0x09, 0xF9, 0x0C, 0x77,
  0x73, 0x81, 0x8F, 0x77, 0x50, 0x3F, 0xA0, 0x67, 0x77, 0x10, 0x6A, 0x09, 0x76, 0x0B, 0xF9, 0x0E,
  0x01, 0x77, 0x60, 0x7B, 0x09, 0x76, 0x03, 0xFA, 0x0C, 0x77, 0x50, 0x9C, 0x06, 0x77, 0x09, 0xFA,
  0x0C, 0x02, 0x77, 0x10, 0x20, 0xCD, 0x01, 0x77, 0x10, 0xDF, 0xA0, 0xE0, 0x77, 0x50, 0x20, 0x8E,
  0x09, 0x77, 0x20, 0x20, 0xEF, 0xB8, 0x3E, 0xA6, 0x31, 0x28, 0x31, 0x24, 0x7B, 0xF0, 0xE0, 0x17,
  0x73, 0x03, 0x0E, 0xFF, 0xFF, 0x04, 0x77, 0x50, 0x30, 0xDF, 0xFF, 0xD0, 0x57, 0x77, 0x01, 0x0A,
  0xFF, 0xFA, 0x0D, 0x03, 0x77, 0x73, 0x04, 0x0C, 0xFF, 0xE0, 0x87, 0x77, 0x78, 0x14, 0xAE, 0xFF,
  0x81, 0xE8, 0x17, 0x77, 0x74, 0x81, 0x47, 0xCD, 0x84, 0xED, 0xC9, 0x73, 0x80, 0xC1, 0x00, 0x8B,
  0x06, 0x80, 0xD0, 0x00, 0xEA, 0x0E, 0x80, 0xD0, 0x00, 0x6B, 0x09, 0x80, 0xD0, 0x00, 0xDC, 0x0C,
  0x04, 0x80, 0xC5, 0x00, 0x4F, 0x0A, 0x80, 0xC4, 0x00, 0x8F, 0x90, 0xB8, 0x0C, 0x40, 0x81, 0x17,
  0xEE, 0x07, 0x80, 0xC5, 0x00, 0x20, 0xED, 0x0E, 0x80, 0xC6, 0x00, 0x5E, 0x04, 0x80, 0xC6, 0x0E,
  0x07, 0x80, 0xC6, 0x00, 0xDD, 0x07, 0x80, 0xC6, 0x00, 0xED, 0x06, 0x80, 0xC5, 0x00, 0x1E, 0x05,
  0x80, 0xC5, 0x00, 0x6E, 0x01, 0x80, 0xC4, 0x00, 0x10, 0xDD, 0x0C, 0x80, 0xC4, 0x00, 0x30, 0xDE,
  0x06, 0x77, 0x77, 0x38, 0x72, 0xFC, 0x98, 0x76, 0x8C, 0xF0, 0xC7, 0x77, 0x74, 0x06, 0xFF, 0x0D,
  0x01, 0x77, 0x77, 0x40, 0xAF, 0xE0, 0xB0, 0x17, 0x77, 0x75, 0x0D, 0xFC, 0x0C, 0x04, 0x77, 0x77,
  0x78, 0x92, 0x36, 0xAC, 0xDE, 0xFE, 0xDA, 0x72, 0x77, 0x77, 0x10,
  // "È" (U+00C8)
  0x77, 0x75, 0x06, 0x80, 0x37, 0x04, 0x80, 0xD1, 0x00, 0xEF, 0x0C, 0x80, 0xD1, 0x00, 0x6F, 0x90,
  0x28, 0x0D, 0x10, 0x0C, 0xF0, 0x78, 0x0D, 0x10, 0x02, 0xF0, 0xC8, 0x0D, 0x20, 0x07, 0xF0, 0x28,
  0x0D, 0x20, 0x0C, 0xE0, 0x88, 0x0D, 0x20, 0x01, 0x0E, 0xD0, 0xE8, 0x0D, 0x30, 0x05, 0xE0, 0x58,
  0x0D, 0x30, 0x08, 0xD0, 0xB8, 0x0D, 0x40, 0x0B, 0xD0, 0x18, 0x0D, 0x30, 0x01, 0x0D, 0xC0, 0x78,
  0x0D, 0x40, 0x03, 0x0E, 0xB0, 0xD8, 0x0D, 0x50, 0x04, 0xC0, 0x48, 0x0D, 0x50, 0x06, 0xB0, 0x48,
  0x0C, 0xC5, 0x00, 0x38, 0x0C, 0x3F, 0x05, 0x76, 0x07, 0x80, 0xC3, 0xF0, 0x37, 0x60, 0xA8, 0x0C,
  0x3F, 0x77, 0x82, 0x9B, 0xCE, 0xFF, 0xFF, 0xF0, 0xC7, 0x74, 0x04, 0x0C, 0xFA, 0x0E, 0x80, 0x91,
  0x60, 0x70, 0xAF, 0x90, 0x97, 0x75, 0x01, 0x0E, 0xF9, 0x0A, 0x77, 0x10, 0x20, 0xDE, 0x06, 0x77,
  0x60, 0xAF, 0x90, 0x77, 0x72, 0x02, 0xE0, 0x37, 0x76, 0x09, 0xF9, 0x03, 0x77, 0x30, 0x9D, 0x77,
  0x70, 0x9F, 0x97, 0x74, 0x05, 0xC0, 0xD7, 0x77, 0x0B, 0xF0, 0xC7, 0x74, 0x03, 0xC0, 0xA7, 0x77,
  0x0E, 0xF0, 0x97, 0x74, 0x03, 0xC0, 0x77, 0x76, 0x02, 0xF9, 0x05, 0x77, 0x40, 0x5C, 0x04, 0x77,
  0x60, 0x5F, 0x90, 0x27, 0x74, 0x06, 0xC0, 0x17, 0x76, 0x09, 0xF0, 0xE7, 0x75, 0x08, 0xB0, 0xD7,
  0x77, 0x0C, 0xF0, 0xB7, 0x75, 0x0A, 0xB0, 0xA7, 0x77, 0xF9, 0x07, 0x77, 0x58, 0x35, 0x66, 0x63,
  0x77, 0x60, 0x3F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9, 0x01, 0x80, 0xD0, 0x00, 0xAF, 0x0D, 0x80,
  0xD1, 0x00, 0xDF, 0x09, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x68, 0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80,
  0xD0, 0x00, 0x7F, 0x0E, 0x80, 0xD1, 0x00, 0xBF, 0x0B, 0x80, 0xD1, 0x00, 0xEF, 0x08, 0x80, 0xD0,
  0x00, 0x2F, 0x90, 0x58, 0x0D, 0x00, 0x05, 0xF9, 0x01, 0x80, 0xD0, 0x00, 0x8F, 0x0D, 0x80, 0xD1,
  0x00, 0xCF, 0xFF, 0xD0, 0x37, 0x77, 0x5F, 0xFF, 0xE7, 0x77, 0x50, 0x3F, 0xFF, 0xD0, 0xC7, 0x77,
  0x50, 0x6F, 0xFF, 0xD0, 0x97, 0x77, 0x50, 0x9F, 0x0D, 0x80, 0x96, 0x60, 0x27, 0x77, 0x50, 0xDF,
  0x09, 0x80, 0xD1, 0x0F, 0x90, 0x68, 0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x7F, 0x98,
  0x0D, 0x10, 0x0A, 0xF0, 0xC8, 0x0D, 0x10, 0x0D, 0xF0, 0x98, 0x0D, 0x00, 0x01, 0xF9, 0x05, 0x80,
  0xD0, 0x00, 0x5F, 0x90, 0x28, 0x0D, 0x00, 0x08, 0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xF0, 0xB8, 0x0D,
  0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02, 0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D,
  0x00, 0x09, 0xF0, 0xD8, 0x0D, 0x10, 0x0C, 0xF0, 0xA8, 0x0D, 0x10, 0xF9, 0x07, 0x77, 0x78, 0x41,
  0xAA, 0xAA, 0x17, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x70, 0x7B, 0x0D, 0x77, 0x40, 0x7F, 0x97, 0x77,
  0x10, 0xCB, 0x0A, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x70, 0x2C, 0x06, 0x77, 0x40, 0xDF, 0x09, 0x77,
  0x70, 0x7C, 0x02, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x77, 0x0D, 0xB0, 0xE7, 0x74, 0x05, 0xF9, 0x03,
  0x77, 0x60, 0x6C, 0x0A, 0x77, 0x40, 0x9F, 0x97, 0x76, 0x01, 0x0E, 0xC0, 0x77, 0x74, 0x0E, 0xF0,
  0xC7, 0x76, 0x0B, 0xD0, 0x37, 0x73, 0x07, 0xF9, 0x08, 0x77, 0x50, 0xAD, 0x0E, 0x77, 0x30, 0x4F,
  0xA0, 0x57, 0x73, 0x03, 0x0C, 0xE0, 0xB7, 0x71, 0x02, 0x09, 0xFB, 0x08, 0x80, 0x92, 0x68, 0x17,
  0x9D, 0xF9, 0x07, 0x74, 0x82, 0x9A, 0xBE, 0x80, 0xC2, 0xF0, 0x37, 0x30, 0x18, 0x0C, 0x6F, 0x74,
  0x04, 0x80, 0xC5, 0xF0, 0xB7, 0x40, 0x88, 0x0C, 0x5F, 0x08, 0x74,
  // "É" (U+00C9)
  0x80, 0xC4, 0x08, 0x05, 0x70, 0x18, 0x0C, 0x70, 0x06, 0xF9, 0x0D, 0x80, 0xD0, 0x00, 0xEF, 0x0E,
  0x02, 0x80, 0xC7, 0x00, 0x8F, 0x90, 0x48, 0x0C, 0x70, 0x02, 0xF9, 0x05, 0x80, 0xD0, 0x00, 0xCF,
  0x06, 0x80, 0xD0, 0x00, 0x6F, 0x07, 0x80, 0xD0, 0x00, 0x10, 0xEE, 0x07, 0x80, 0xD1, 0x00, 0xBE,
  0x07, 0x80, 0xD1, 0x00, 0x7E, 0x06, 0x80, 0xD1, 0x00, 0x2E, 0x05, 0x80, 0xD2, 0x00, 0xDC, 0x0E,
  0x03, 0x80, 0xD2, 0x00, 0xAC, 0x0C, 0x02, 0x80, 0xD2, 0x00, 0x6C, 0x0A, 0x80, 0xD4, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xCD, 0x10, 0x03, 0x80, 0xC3, 0xF0, 0x57, 0x60, 0x78, 0x0C, 0x3F, 0x03, 0x76,
  0x0A, 0x80, 0xC3, 0xF7, 0x78, 0x29, 0xBC, 0xEF, 0xFF, 0xFF, 0x0C, 0x77, 0x40, 0x40, 0xCF, 0xA0,
  0xE8, 0x09, 0x16, 0x07, 0x0A, 0xF9, 0x09, 0x77, 0x50, 0x10, 0xEF, 0x90, 0xA7, 0x71, 0x02, 0x0D,
  0xE0, 0x67, 0x76, 0x0A, 0xF9, 0x07, 0x77, 0x20, 0x2E, 0x03, 0x77, 0x60, 0x9F, 0x90, 0x37, 0x73,
  0x09, 0xD7, 0x77, 0x09, 0xF9, 0x77, 0x40, 0x5C, 0x0D, 0x77, 0x70, 0xBF, 0x0C, 0x77, 0x40, 0x3C,
  0x0A, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x40, 0x3C, 0x07, 0x77, 0x60, 0x2F, 0x90, 0x57, 0x74, 0x05,
  0xC0, 0x47, 0x76, 0x05, 0xF9, 0x02, 0x77, 0x40, 0x6C, 0x01, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x50,
  0x8B, 0x0D, 0x77, 0x70, 0xCF, 0x0B, 0x77, 0x50, 0xAB, 0x0A, 0x77, 0x7F, 0x90, 0x77, 0x75, 0x83,
  0x56, 0x66, 0x37, 0x76, 0x03, 0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D, 0x00, 0x0A,
  0xF0, 0xD8, 0x0D, 0x10, 0x0D, 0xF0, 0x98, 0x0D, 0x00, 0x01, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F,
  0x90, 0x38, 0x0D, 0x00, 0x07, 0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xF0, 0xB8, 0x0D, 0x10, 0x0E, 0xF0,
  0x88, 0x0D, 0x00, 0x02, 0xF9, 0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x18, 0x0D, 0x00, 0x08, 0xF0,
  0xD8, 0x0D, 0x10, 0x0C, 0xFF, 0xFD, 0x03, 0x77, 0x75, 0xFF, 0xFE, 0x77, 0x75, 0x03, 0xFF, 0xFD,
  0x0C, 0x77, 0x75, 0x06, 0xFF, 0xFD, 0x09, 0x77, 0x75, 0x09, 0xF0, 0xD8, 0x09, 0x66, 0x02, 0x77,
  0x75, 0x0D, 0xF0, 0x98, 0x0D, 0x10, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F, 0x90, 0x38, 0x0D, 0x00,
  0x07, 0xF9, 0x80, 0xD1, 0x00, 0xAF, 0x0C, 0x80, 0xD1, 0x00, 0xDF, 0x09, 0x80, 0xD0, 0x00, 0x1F,
  0x90, 0x58, 0x0D, 0x00, 0x05, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x8F, 0x0E, 0x80, 0xD1, 0x00, 0xBF,
  0x0B, 0x80, 0xD1, 0x00, 0xEF, 0x08, 0x80, 0xD0, 0x00, 0x2F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9,
  0x01, 0x80, 0xD0, 0x00, 0x9F, 0x0D, 0x80, 0xD1, 0x00, 0xCF, 0x0A, 0x80, 0xD1, 0x0F, 0x90, 0x77,
  0x77, 0x84, 0x1A, 0xAA, 0xA1, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x77, 0x07, 0xB0, 0xD7, 0x74, 0x07,
  0xF9, 0x77, 0x71, 0x0C, 0xB0, 0xA7, 0x74, 0x0A, 0xF0, 0xD7, 0x77, 0x02, 0xC0, 0x67, 0x74, 0x0D,
  0xF0, 0x97, 0x77, 0x07, 0xC0, 0x27, 0x73, 0x01, 0xF9, 0x06, 0x77, 0x70, 0xDB, 0x0E, 0x77, 0x40,
  0x5F, 0x90, 0x37, 0x76, 0x06, 0xC0, 0xA7, 0x74, 0x09, 0xF9, 0x77, 0x60, 0x10, 0xEC, 0x07, 0x77,
  0x40, 0xEF, 0x0C, 0x77, 0x60, 0xBD, 0x03, 0x77, 0x30, 0x7F, 0x90, 0x87, 0x75, 0x0A, 0xD0, 0xE7,
  0x73, 0x04, 0xFA, 0x05, 0x77, 0x30, 0x30, 0xCE, 0x0B, 0x77, 0x10, 0x20, 0x9F, 0xB0, 0x88, 0x09,
  0x26, 0x81, 0x79, 0xDF, 0x90, 0x77, 0x48, 0x29, 0xAB, 0xE8, 0x0C, 0x2F, 0x03, 0x73, 0x01, 0x80,
  0xC6, 0xF7, 0x40, 0x48, 0x0C, 0x5F, 0x0B, 0x74, 0x08, 0x80, 0xC5, 0xF0, 0x87, 0x40,
  // "Ê" (U+00CA)
  0x77, 0x77, 0x78, 0x04, 0x78, 0x0D, 0x10, 0x09, 0xF9, 0x03, 0x80, 0xC7, 0x00, 0x4F, 0xA0, 0x78,
  0x0C, 0x60, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xC6, 0x00, 0xCF, 0xC0, 0x18, 0x0C, 0x40, 0x09, 0xFD,
  0x07, 0x80, 0xC3, 0x00, 0x6E, 0x0B, 0x0D, 0xD0, 0xC8, 0x0C, 0x20, 0x03, 0xE8, 0x1A, 0x04, 0xE0,
  0x28, 0x0C, 0x00, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x98, 0x0C, 0x00, 0x0C, 0xD0, 0x84, 0x01,
  0x0E, 0xC0, 0xE7, 0x77, 0x77, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x77, 0x77, 0x75, 0x09, 0xC0, 0xE0,
  0x57, 0x10, 0x9C, 0x0D, 0x77, 0x77, 0x40, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x77, 0x72,
  0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x77, 0x77, 0x20, 0xCA, 0x0D, 0x04, 0x77, 0x01,
  0x0C, 0xA0, 0xD8, 0x0C, 0xB5, 0x00, 0x38, 0x0C, 0x3F, 0x05, 0x76, 0x07, 0x80, 0xC3, 0xF0, 0x37,
  0x60, 0xA8, 0x0C, 0x3F, 0x77, 0x82, 0x9B, 0xCE, 0xFF, 0xFF, 0xF0, 0xC7, 0x74, 0x04, 0x0C, 0xFA,
  0x0E, 0x80, 0x91, 0x60, 0x70, 0xAF, 0x90, 0x97, 0x75, 0x01, 0x0E, 0xF9, 0x0A, 0x77, 0x10, 0x20,
  0xDE, 0x06, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x72, 0x02, 0xE0, 0x37, 0x76, 0x09, 0xF9, 0x03, 0x77,
  0x30, 0x9D, 0x77, 0x70, 0x9F, 0x97, 0x74, 0x05, 0xC0, 0xD7, 0x77, 0x0B, 0xF0, 0xC7, 0x74, 0x03,
  0xC0, 0xA7, 0x77, 0x0E, 0xF0, 0x97, 0x74, 0x03, 0xC0, 0x77, 0x76, 0x02, 0xF9, 0x05, 0x77, 0x40,
  0x5C, 0x04, 0x77, 0x60, 0x5F, 0x90, 0x27, 0x74, 0x06, 0xC0, 0x17, 0x76, 0x09, 0xF0, 0xE7, 0x75,
  0x08, 0xB0, 0xD7, 0x77, 0x0C, 0xF0, 0xB7, 0x75, 0x0A, 0xB0, 0xA7, 0x77, 0xF9, 0x07, 0x77, 0x58,
  0x35, 0x66, 0x63, 0x77, 0x60, 0x3F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9, 0x01, 0x80, 0xD0, 0x00,
  0xAF, 0x0D, 0x80, 0xD1, 0x00, 0xDF, 0x09, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x68, 0x0D, 0x00, 0x04,
  0xF9, 0x03, 0x80, 0xD0, 0x00, 0x7F, 0x0E, 0x80, 0xD1, 0x00, 0xBF, 0x0B, 0x80, 0xD1, 0x00, 0xEF,
  0x08, 0x80, 0xD0, 0x00, 0x2F, 0x90, 0x58, 0x0D, 0x00, 0x05, 0xF9, 0x01, 0x80, 0xD0, 0x00, 0x8F,
  0x0D, 0x80, 0xD1, 0x00, 0xCF, 0xFF, 0xD0, 0x37, 0x77, 0x5F, 0xFF, 0xE7, 0x77, 0x50, 0x3F, 0xFF,
  0xD0, 0xC7, 0x77, 0x50, 0x6F, 0xFF, 0xD0, 0x97, 0x77, 0x50, 0x9F, 0x0D, 0x80, 0x96, 0x60, 0x27,
  0x77, 0x50, 0xDF, 0x09, 0x80, 0xD1, 0x0F, 0x90, 0x68, 0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0,
  0x00, 0x7F, 0x98, 0x0D, 0x10, 0x0A, 0xF0, 0xC8, 0x0D, 0x10, 0x0D, 0xF0, 0x98, 0x0D, 0x00, 0x01,
  0xF9, 0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x28, 0x0D, 0x00, 0x08, 0xF0, 0xE8, 0x0D, 0x10, 0x0B,
  0xF0, 0xB8, 0x0D, 0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02, 0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F,
  0x90, 0x18, 0x0D, 0x00, 0x09, 0xF0, 0xD8, 0x0D, 0x10, 0x0C, 0xF0, 0xA8, 0x0D, 0x10, 0xF9, 0x07,
  0x77, 0x78, 0x41, 0xAA, 0xAA, 0x17, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x70, 0x7B, 0x0D, 0x77, 0x40,
  0x7F, 0x97, 0x77, 0x10, 0xCB, 0x0A, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x70, 0x2C, 0x06, 0x77, 0x40,
  0xDF, 0x09, 0x77, 0x70, 0x7C, 0x02, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x77, 0x0D, 0xB0, 0xE7, 0x74,
  0x05, 0xF9, 0x03, 0x77, 0x60, 0x6C, 0x0A, 0x77, 0x40, 0x9F, 0x97, 0x76, 0x01, 0x0E, 0xC0, 0x77,
  0x74, 0x0E, 0xF0, 0xC7, 0x76, 0x0B, 0xD0, 0x37, 0x73, 0x07, 0xF9, 0x08, 0x77, 0x50, 0xAD, 0x0E,
  0x77, 0x30, 0x4F, 0xA0, 0x57, 0x73, 0x03, 0x0C, 0xE0, 0xB7, 0x71, 0x02, 0x09, 0xFB, 0x08, 0x80,
  0x92, 0x68, 0x17, 0x9D, 0xF9, 0x07, 0x74, 0x82, 0x9A, 0xBE, 0x80, 0xC2, 0xF0, 0x37, 0x30, 0x18,
  0x0C, 0x6F, 0x74, 0x04, 0x80, 0xC5, 0xF0, 0xB7, 0x40, 0x88, 0x0C, 0x5F, 0x08, 0x74,
  // "Ë" (U+00CB)
  0x77, 0x75, 0x83, 0x5C, 0xFD, 0x77, 0x38, 0x36, 0xDF, 0xD7, 0x77, 0x77, 0x50, 0x7D, 0x09, 0x71,
  0x08, 0xD0, 0x87, 0x77, 0x73, 0x02, 0xF0, 0x16, 0x02, 0xE0, 0xE7, 0x77, 0x73, 0x07, 0xF0, 0x36,
  0x08, 0xF0, 0x27, 0x77, 0x72, 0x0B, 0xF0, 0x46, 0x0C, 0xF0, 0x37, 0x77, 0x72, 0x0C, 0xF0, 0x36,
  0x0D, 0xF0, 0x27, 0x77, 0x72, 0x0B, 0xF7, 0x0C, 0xF7, 0x77, 0x73, 0x09, 0xE0, 0xB7, 0x0A, 0xE0,
  0xA7, 0x77, 0x73, 0x02, 0xD0, 0xE0, 0x27, 0x03, 0xD0, 0xD0, 0x17, 0x77, 0x74, 0x84, 0x3B, 0xEE,
  0xA1, 0x72, 0x84, 0x4C, 0xFE, 0x91, 0x80, 0xF8, 0x10, 0x03, 0x80, 0xC3, 0xF0, 0x57, 0x60, 0x78,
  0x0C, 0x3F, 0x03, 0x76, 0x0A, 0x80, 0xC3, 0xF7, 0x78, 0x29, 0xBC, 0xEF, 0xFF, 0xFF, 0x0C, 0x77,
  0x40, 0x40, 0xCF, 0xA0, 0xE8, 0x09, 0x16, 0x07, 0x0A, 0xF9, 0x09, 0x77, 0x50, 0x10, 0xEF, 0x90,
  0xA7, 0x71, 0x02, 0x0D, 0xE0, 0x67, 0x76, 0x0A, 0xF9, 0x07, 0x77, 0x20, 0x2E, 0x03, 0x77, 0x60,
  0x9F, 0x90, 0x37, 0x73, 0x09, 0xD7, 0x77, 0x09, 0xF9, 0x77, 0x40, 0x5C, 0x0D, 0x77, 0x70, 0xBF,
  0x0C, 0x77, 0x40, 0x3C, 0x0A, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x40, 0x3C, 0x07, 0x77, 0x60, 0x2F,
  0x90, 0x57, 0x74, 0x05, 0xC0, 0x47, 0x76, 0x05, 0xF9, 0x02, 0x77, 0x40, 0x6C, 0x01, 0x77, 0x60,
  0x9F, 0x0E, 0x77, 0x50, 0x8B, 0x0D, 0x77, 0x70, 0xCF, 0x0B, 0x77, 0x50, 0xAB, 0x0A, 0x77, 0x7F,
  0x90, 0x77, 0x75, 0x83, 0x56, 0x66, 0x37, 0x76, 0x03, 0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F, 0x90,
  0x18, 0x0D, 0x00, 0x0A, 0xF0, 0xD8, 0x0D, 0x10, 0x0D, 0xF0, 0x98, 0x0D, 0x00, 0x01, 0xF9, 0x06,
  0x80, 0xD0, 0x00, 0x4F, 0x90, 0x38, 0x0D, 0x00, 0x07, 0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xF0, 0xB8,
  0x0D, 0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02, 0xF9, 0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x18,
  0x0D, 0x00, 0x08, 0xF0, 0xD8, 0x0D, 0x10, 0x0C, 0xFF, 0xFD, 0x03, 0x77, 0x75, 0xFF, 0xFE, 0x77,
  0x75, 0x03, 0xFF, 0xFD, 0x0C, 0x77, 0x75, 0x06, 0xFF, 0xFD, 0x09, 0x77, 0x75, 0x09, 0xF0, 0xD8,
  0x09, 0x66, 0x02, 0x77, 0x75, 0x0D, 0xF0, 0x98, 0x0D, 0x10, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F,
  0x90, 0x38, 0x0D, 0x00, 0x07, 0xF9, 0x80, 0xD1, 0x00, 0xAF, 0x0C, 0x80, 0xD1, 0x00, 0xDF, 0x09,
  0x80, 0xD0, 0x00, 0x1F, 0x90, 0x58, 0x0D, 0x00, 0x05, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x8F, 0x0E,
  0x80, 0xD1, 0x00, 0xBF, 0x0B, 0x80, 0xD1, 0x00, 0xEF, 0x08, 0x80, 0xD0, 0x00, 0x2F, 0x90, 0x48,
  0x0D, 0x00, 0x06, 0xF9, 0x01, 0x80, 0xD0, 0x00, 0x9F, 0x0D, 0x80, 0xD1, 0x00, 0xCF, 0x0A, 0x80,
  0xD1, 0x0F, 0x90, 0x77, 0x77, 0x84, 0x1A, 0xAA, 0xA1, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x77, 0x07,
  0xB0, 0xD7, 0x74, 0x07, 0xF9, 0x77, 0x71, 0x0C, 0xB0, 0xA7, 0x74, 0x0A, 0xF0, 0xD7, 0x77, 0x02,
  0xC0, 0x67, 0x74, 0x0D, 0xF0, 0x97, 0x77, 0x07, 0xC0, 0x27, 0x73, 0x01, 0xF9, 0x06, 0x77, 0x70,
  0xDB, 0x0E, 0x77, 0x40, 0x5F, 0x90, 0x37, 0x76, 0x06, 0xC0, 0xA7, 0x74, 0x09, 0xF9, 0x77, 0x60,
  0x10, 0xEC, 0x07, 0x77, 0x40, 0xEF, 0x0C, 0x77, 0x60, 0xBD, 0x03, 0x77, 0x30, 0x7F, 0x90, 0x87,
  0x75, 0x0A, 0xD0, 0xE7, 0x73, 0x04, 0xFA, 0x05, 0x77, 0x30, 0x30, 0xCE, 0x0B, 0x77, 0x10, 0x20,
  0x9F, 0xB0, 0x88, 0x09, 0x26, 0x81, 0x79, 0xDF, 0x90, 0x77, 0x48, 0x29, 0xAB, 0xE8, 0x0C, 0x2F,
  0x03, 0x73, 0x01, 0x80, 0xC6, 0xF7, 0x40, 0x48, 0x0C, 0x5F, 0x0B, 0x74, 0x08, 0x80, 0xC5, 0xF0,
  0x87, 0x40,
  // "Ì" (U+00CC)
  0x77, 0x30, 0x68, 0x03, 0x70, 0x47, 0x77, 0x71, 0x0E, 0xF0, 0xC7, 0x77, 0x71, 0x06, 0xF9, 0x02,
  0x77, 0x77, 0x10, 0xCF, 0x07, 0x77, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x77, 0x20, 0x7F, 0x02, 0x77,
  0x77, 0x20, 0xCE, 0x08, 0x77, 0x77, 0x20, 0x10, 0xED, 0x0E, 0x77, 0x77, 0x30, 0x5E, 0x05, 0x77,
  0x77, 0x30, 0x8D, 0x0B, 0x77, 0x77, 0x40, 0xBD, 0x01, 0x77, 0x77, 0x30, 0x10, 0xDC, 0x07, 0x77,
  0x77, 0x40, 0x30, 0xEB, 0x0D, 0x77, 0x77, 0x50, 0x4C, 0x04, 0x77, 0x77, 0x50, 0x6B, 0x04, 0x80,
  0xB9, 0x60, 0x03, 0xFF, 0xFA, 0x01, 0x76, 0x06, 0xFF, 0xF9, 0x0D, 0x77, 0x09, 0xFF, 0xF9, 0x0A,
  0x77, 0x0D, 0xFF, 0xF9, 0x07, 0x77, 0x28, 0x21, 0x37, 0xDF, 0xD8, 0x1B, 0x62, 0x77, 0x72, 0x0D,
  0xFA, 0x0E, 0x03, 0x77, 0x75, 0x07, 0xFA, 0x03, 0x77, 0x76, 0x05, 0xF9, 0x0A, 0x77, 0x77, 0x07,
  0xF9, 0x03, 0x77, 0x77, 0x0A, 0xF0, 0xE7, 0x77, 0x71, 0x0D, 0xF0, 0xB7, 0x77, 0x70, 0x1F, 0x90,
  0x77, 0x77, 0x70, 0x4F, 0x90, 0x47, 0x77, 0x70, 0x8F, 0x90, 0x17, 0x77, 0x70, 0xBF, 0x0D, 0x77,
  0x77, 0x10, 0xEF, 0x0A, 0x77, 0x77, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x05, 0xF9, 0x03, 0x77, 0x77,
  0x09, 0xF9, 0x77, 0x77, 0x10, 0xCF, 0x0C, 0x77, 0x77, 0x1F, 0x90, 0x87, 0x77, 0x70, 0x3F, 0x90,
  0x57, 0x77, 0x70, 0x6F, 0x90, 0x27, 0x77, 0x70, 0xAF, 0x0E, 0x77, 0x77, 0x10, 0xDF, 0x0B, 0x77,
  0x77, 0x01, 0xF9, 0x07, 0x77, 0x77, 0x04, 0xF9, 0x04, 0x77, 0x77, 0x07, 0xF9, 0x01, 0x77, 0x77,
  0x0B, 0xF0, 0xD7, 0x77, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x70, 0x2F, 0x90, 0x67, 0x77, 0x70, 0x5F,
  0x90, 0x37, 0x77, 0x70, 0x9F, 0x0E, 0x77, 0x77, 0x10, 0xCF, 0x0B, 0x77, 0x77, 0x1F, 0x90, 0x87,
  0x77, 0x70, 0x3F, 0x90, 0x57, 0x77, 0x70, 0x6F, 0x90, 0x17, 0x77, 0x70, 0xAF, 0x0E, 0x77, 0x77,
  0x10, 0xDF, 0x0A, 0x77, 0x77, 0x01, 0xF9, 0x07, 0x77, 0x77, 0x04, 0xF9, 0x03, 0x77, 0x77, 0x07,
  0xF9, 0x77, 0x77, 0x10, 0xBF, 0x0C, 0x77, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x77, 0x02, 0xF9, 0x06,
  0x77, 0x77, 0x05, 0xF9, 0x02, 0x77, 0x77, 0x08, 0xF0, 0xE7, 0x77, 0x71, 0x0C, 0xF0, 0xB7, 0x77,
  0x71, 0xF9, 0x08, 0x77, 0x77, 0x03, 0xF9, 0x04, 0x77, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x77, 0x0A,
  0xF0, 0xD7, 0x77, 0x71, 0x0D, 0xF0, 0xA7, 0x77, 0x70, 0x1F, 0x90, 0x77, 0x77, 0x70, 0x5F, 0x90,
  0x37, 0x77, 0x70, 0xAF, 0x97, 0x77, 0x70, 0x1F, 0x90, 0xE7, 0x77, 0x70, 0xAF, 0xA7, 0x77, 0x60,
  0x9F, 0xB0, 0x67, 0x77, 0x18, 0x21, 0x48, 0xEF, 0xD8, 0x29, 0x52, 0x17, 0x72, 0x0E, 0xFF, 0xF9,
  0x04, 0x76, 0x01, 0xFF, 0xFA, 0x01, 0x76, 0x05, 0xFF, 0xF9, 0x0D, 0x77, 0x08, 0xFF, 0xF9, 0x0A,
  0x77,
  // "Í" (U+00CD)
  0x77, 0x77, 0x38, 0x05, 0x70, 0x17, 0x77, 0x72, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x30, 0xEF, 0x0E,
  0x02, 0x77, 0x77, 0x20, 0x8F, 0x90, 0x47, 0x77, 0x72, 0x02, 0xF9, 0x05, 0x77, 0x77, 0x30, 0xCF,
  0x06, 0x77, 0x77, 0x30, 0x6F, 0x07, 0x77, 0x77, 0x30, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x40, 0xBE,
  0x07, 0x77, 0x77, 0x40, 0x7E, 0x06, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x50, 0xDC, 0x0E,
  0x03, 0x77, 0x77, 0x50, 0xAC, 0x0C, 0x02, 0x77, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0x77, 0x70, 0xCA,
  0x0E, 0x05, 0x80, 0xBC, 0x40, 0x03, 0xFF, 0xFA, 0x01, 0x77, 0x20, 0x6F, 0xFF, 0x90, 0xD7, 0x73,
  0x09, 0xFF, 0xF9, 0x0A, 0x77, 0x30, 0xDF, 0xFF, 0x90, 0x77, 0x75, 0x82, 0x13, 0x7D, 0xFD, 0x81,
  0xB6, 0x27, 0x77, 0x50, 0xDF, 0xA0, 0xE0, 0x37, 0x77, 0x71, 0x07, 0xFA, 0x03, 0x77, 0x77, 0x20,
  0x5F, 0x90, 0xA7, 0x77, 0x73, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x30, 0xAF, 0x0E, 0x77, 0x77, 0x40,
  0xDF, 0x0B, 0x77, 0x77, 0x30, 0x1F, 0x90, 0x77, 0x77, 0x73, 0x04, 0xF9, 0x04, 0x77, 0x77, 0x30,
  0x8F, 0x90, 0x17, 0x77, 0x73, 0x0B, 0xF0, 0xD7, 0x77, 0x74, 0x0E, 0xF0, 0xA7, 0x77, 0x73, 0x02,
  0xF9, 0x06, 0x77, 0x77, 0x30, 0x5F, 0x90, 0x37, 0x77, 0x73, 0x09, 0xF9, 0x77, 0x77, 0x40, 0xCF,
  0x0C, 0x77, 0x77, 0x4F, 0x90, 0x87, 0x77, 0x73, 0x03, 0xF9, 0x05, 0x77, 0x77, 0x30, 0x6F, 0x90,
  0x27, 0x77, 0x73, 0x0A, 0xF0, 0xE7, 0x77, 0x74, 0x0D, 0xF0, 0xB7, 0x77, 0x73, 0x01, 0xF9, 0x07,
  0x77, 0x77, 0x30, 0x4F, 0x90, 0x47, 0x77, 0x73, 0x07, 0xF9, 0x01, 0x77, 0x77, 0x30, 0xBF, 0x0D,
  0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x30, 0x2F, 0x90, 0x67, 0x77, 0x73, 0x05, 0xF9, 0x03,
  0x77, 0x77, 0x30, 0x9F, 0x0E, 0x77, 0x77, 0x40, 0xCF, 0x0B, 0x77, 0x77, 0x4F, 0x90, 0x87, 0x77,
  0x73, 0x03, 0xF9, 0x05, 0x77, 0x77, 0x30, 0x6F, 0x90, 0x17, 0x77, 0x73, 0x0A, 0xF0, 0xE7, 0x77,
  0x74, 0x0D, 0xF0, 0xA7, 0x77, 0x73, 0x01, 0xF9, 0x07, 0x77, 0x77, 0x30, 0x4F, 0x90, 0x37, 0x77,
  0x73, 0x07, 0xF9, 0x77, 0x77, 0x40, 0xBF, 0x0C, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x30,
  0x2F, 0x90, 0x67, 0x77, 0x73, 0x05, 0xF9, 0x02, 0x77, 0x77, 0x30, 0x8F, 0x0E, 0x77, 0x77, 0x40,
  0xCF, 0x0B, 0x77, 0x77, 0x4F, 0x90, 0x87, 0x77, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x77, 0x30, 0x6F,
  0x90, 0x17, 0x77, 0x73, 0x0A, 0xF0, 0xD7, 0x77, 0x74, 0x0D, 0xF0, 0xA7, 0x77, 0x73, 0x01, 0xF9,
  0x07, 0x77, 0x77, 0x30, 0x5F, 0x90, 0x37, 0x77, 0x73, 0x0A, 0xF9, 0x77, 0x77, 0x30, 0x1F, 0x90,
  0xE7, 0x77, 0x73, 0x0A, 0xFA, 0x77, 0x77, 0x20, 0x9F, 0xB0, 0x67, 0x77, 0x48, 0x21, 0x48, 0xEF,
  0xD8, 0x29, 0x52, 0x17, 0x75, 0x0E, 0xFF, 0xF9, 0x04, 0x77, 0x20, 0x1F, 0xFF, 0xA0, 0x17, 0x72,
  0x05, 0xFF, 0xF9, 0x0D, 0x77, 0x30, 0x8F, 0xFF, 0x90, 0xA7, 0x73,
  // "Î" (U+00CE)
  0x77, 0x74, 0x80, 0x47, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x37, 0x77, 0x60, 0x4F, 0xA0, 0x77, 0x77,
  0x50, 0x10, 0xEF, 0xA0, 0xB7, 0x77, 0x50, 0xCF, 0xC0, 0x17, 0x77, 0x30, 0x9F, 0xD0, 0x77, 0x77,
  0x20, 0x6E, 0x0B, 0x0D, 0xD0, 0xC7, 0x77, 0x10, 0x3E, 0x81, 0xA0, 0x4E, 0x02, 0x77, 0x60, 0x20,
  0xED, 0x09, 0x30, 0xAD, 0x09, 0x77, 0x60, 0xCD, 0x08, 0x40, 0x10, 0xEC, 0x0E, 0x77, 0x50, 0xBD,
  0x07, 0x60, 0x5D, 0x07, 0x77, 0x30, 0x9C, 0x0E, 0x05, 0x71, 0x09, 0xC0, 0xD7, 0x72, 0x07, 0xC0,
  0xD0, 0x27, 0x30, 0xBC, 0x05, 0x77, 0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x77, 0x0C,
  0xA0, 0xD0, 0x47, 0x70, 0x10, 0xCA, 0x0D, 0x80, 0xB8, 0x70, 0x03, 0xFF, 0xFA, 0x01, 0x76, 0x06,
  0xFF, 0xF9, 0x0D, 0x77, 0x09, 0xFF, 0xF9, 0x0A, 0x77, 0x0D, 0xFF, 0xF9, 0x07, 0x77, 0x28, 0x21,
  0x37, 0xDF, 0xD8, 0x1B, 0x62, 0x77, 0x72, 0x0D, 0xFA, 0x0E, 0x03, 0x77, 0x75, 0x07, 0xFA, 0x03,
  0x77, 0x76, 0x05, 0xF9, 0x0A, 0x77, 0x77, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x0A, 0xF0, 0xE7, 0x77,
  0x71, 0x0D, 0xF0, 0xB7, 0x77, 0x70, 0x1F, 0x90, 0x77, 0x77, 0x70, 0x4F, 0x90, 0x47, 0x77, 0x70,
  0x8F, 0x90, 0x17, 0x77, 0x70, 0xBF, 0x0D, 0x77, 0x77, 0x10, 0xEF, 0x0A, 0x77, 0x77, 0x02, 0xF9,
  0x06, 0x77, 0x77, 0x05, 0xF9, 0x03, 0x77, 0x77, 0x09, 0xF9, 0x77, 0x77, 0x10, 0xCF, 0x0C, 0x77,
  0x77, 0x1F, 0x90, 0x87, 0x77, 0x70, 0x3F, 0x90, 0x57, 0x77, 0x70, 0x6F, 0x90, 0x27, 0x77, 0x70,
  0xAF, 0x0E, 0x77, 0x77, 0x10, 0xDF, 0x0B, 0x77, 0x77, 0x01, 0xF9, 0x07, 0x77, 0x77, 0x04, 0xF9,
  0x04, 0x77, 0x77, 0x07, 0xF9, 0x01, 0x77, 0x77, 0x0B, 0xF0, 0xD7, 0x77, 0x71, 0x0E, 0xF0, 0x97,
  0x77, 0x70, 0x2F, 0x90, 0x67, 0x77, 0x70, 0x5F, 0x90, 0x37, 0x77, 0x70, 0x9F, 0x0E, 0x77, 0x77,
  0x10, 0xCF, 0x0B, 0x77, 0x77, 0x1F, 0x90, 0x87, 0x77, 0x70, 0x3F, 0x90, 0x57, 0x77, 0x70, 0x6F,
  0x90, 0x17, 0x77, 0x70, 0xAF, 0x0E, 0x77, 0x77, 0x10, 0xDF, 0x0A, 0x77, 0x77, 0x01, 0xF9, 0x07,
  0x77, 0x77, 0x04, 0xF9, 0x03, 0x77, 0x77, 0x07, 0xF9, 0x77, 0x77, 0x10, 0xBF, 0x0C, 0x77, 0x77,
  0x10, 0xEF, 0x09, 0x77, 0x77, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x05, 0xF9, 0x02, 0x77, 0x77, 0x08,
  0xF0, 0xE7, 0x77, 0x71, 0x0C, 0xF0, 0xB7, 0x77, 0x71, 0xF9, 0x08, 0x77, 0x77, 0x03, 0xF9, 0x04,
  0x77, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x77, 0x0A, 0xF0, 0xD7, 0x77, 0x71, 0x0D, 0xF0, 0xA7, 0x77,
  0x70, 0x1F, 0x90, 0x77, 0x77, 0x70, 0x5F, 0x90, 0x37, 0x77, 0x70, 0xAF, 0x97, 0x77, 0x70, 0x1F,
  0x90, 0xE7, 0x77, 0x70, 0xAF, 0xA7, 0x77, 0x60, 0x9F, 0xB0, 0x67, 0x77, 0x18, 0x21, 0x48, 0xEF,
  0xD8, 0x29, 0x52, 0x17, 0x72, 0x0E, 0xFF, 0xF9, 0x04, 0x76, 0x01, 0xFF, 0xFA, 0x01, 0x76, 0x05,
  0xFF, 0xF9, 0x0D, 0x77, 0x08, 0xFF, 0xF9, 0x0A, 0x77,
  // "Ï" (U+00CF)
  0x77, 0x48, 0x35, 0xCF, 0xD7, 0x73, 0x83, 0x6D, 0xFD, 0x77, 0x75, 0x07, 0xD0, 0x97, 0x10, 0x8D,
  0x08, 0x77, 0x30, 0x2F, 0x01, 0x60, 0x2E, 0x0E, 0x77, 0x30, 0x7F, 0x03, 0x60, 0x8F, 0x02, 0x77,
  0x20, 0xBF, 0x04, 0x60, 0xCF, 0x03, 0x77, 0x20, 0xCF, 0x03, 0x60, 0xDF, 0x02, 0x77, 0x20, 0xBF,
  0x70, 0xCF, 0x77, 0x30, 0x9E, 0x0B, 0x70, 0xAE, 0x0A, 0x77, 0x30, 0x2D, 0x0E, 0x02, 0x70, 0x3D,
  0x0D, 0x01, 0x77, 0x48, 0x43, 0xBE, 0xEA, 0x17, 0x28, 0x44, 0xCF, 0xE9, 0x18, 0x0D, 0x93, 0x00,
  0x3F, 0xFF, 0xA0, 0x17, 0x71, 0x06, 0xFF, 0xF9, 0x0D, 0x77, 0x20, 0x9F, 0xFF, 0x90, 0xA7, 0x72,
  0x0D, 0xFF, 0xF9, 0x07, 0x77, 0x48, 0x21, 0x37, 0xDF, 0xD8, 0x1B, 0x62, 0x77, 0x74, 0x0D, 0xFA,
  0x0E, 0x03, 0x77, 0x77, 0x07, 0xFA, 0x03, 0x77, 0x77, 0x10, 0x5F, 0x90, 0xA7, 0x77, 0x72, 0x07,
  0xF9, 0x03, 0x77, 0x77, 0x20, 0xAF, 0x0E, 0x77, 0x77, 0x30, 0xDF, 0x0B, 0x77, 0x77, 0x20, 0x1F,
  0x90, 0x77, 0x77, 0x72, 0x04, 0xF9, 0x04, 0x77, 0x77, 0x20, 0x8F, 0x90, 0x17, 0x77, 0x72, 0x0B,
  0xF0, 0xD7, 0x77, 0x73, 0x0E, 0xF0, 0xA7, 0x77, 0x72, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x20, 0x5F,
  0x90, 0x37, 0x77, 0x72, 0x09, 0xF9, 0x77, 0x77, 0x30, 0xCF, 0x0C, 0x77, 0x77, 0x3F, 0x90, 0x87,
  0x77, 0x72, 0x03, 0xF9, 0x05, 0x77, 0x77, 0x20, 0x6F, 0x90, 0x27, 0x77, 0x72, 0x0A, 0xF0, 0xE7,
  0x77, 0x73, 0x0D, 0xF0, 0xB7, 0x77, 0x72, 0x01, 0xF9, 0x07, 0x77, 0x77, 0x20, 0x4F, 0x90, 0x47,
  0x77, 0x72, 0x07, 0xF9, 0x01, 0x77, 0x77, 0x20, 0xBF, 0x0D, 0x77, 0x77, 0x30, 0xEF, 0x09, 0x77,
  0x77, 0x20, 0x2F, 0x90, 0x67, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x77, 0x20, 0x9F, 0x0E, 0x77,
  0x77, 0x30, 0xCF, 0x0B, 0x77, 0x77, 0x3F, 0x90, 0x87, 0x77, 0x72, 0x03, 0xF9, 0x05, 0x77, 0x77,
  0x20, 0x6F, 0x90, 0x17, 0x77, 0x72, 0x0A, 0xF0, 0xE7, 0x77, 0x73, 0x0D, 0xF0, 0xA7, 0x77, 0x72,
  0x01, 0xF9, 0x07, 0x77, 0x77, 0x20, 0x4F, 0x90, 0x37, 0x77, 0x72, 0x07, 0xF9, 0x77, 0x77, 0x30,
  0xBF, 0x0C, 0x77, 0x77, 0x30, 0xEF, 0x09, 0x77, 0x77, 0x20, 0x2F, 0x90, 0x67, 0x77, 0x72, 0x05,
  0xF9, 0x02, 0x77, 0x77, 0x20, 0x8F, 0x0E, 0x77, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x77, 0x3F, 0x90,
  0x87, 0x77, 0x72, 0x03, 0xF9, 0x04, 0x77, 0x77, 0x20, 0x6F, 0x90, 0x17, 0x77, 0x72, 0x0A, 0xF0,
  0xD7, 0x77, 0x73, 0x0D, 0xF0, 0xA7, 0x77, 0x72, 0x01, 0xF9, 0x07, 0x77, 0x77, 0x20, 0x5F, 0x90,
  0x37, 0x77, 0x72, 0x0A, 0xF9, 0x77, 0x77, 0x20, 0x1F, 0x90, 0xE7, 0x77, 0x72, 0x0A, 0xFA, 0x77,
  0x77, 0x10, 0x9F, 0xB0, 0x67, 0x77, 0x38, 0x21, 0x48, 0xEF, 0xD8, 0x29, 0x52, 0x17, 0x74, 0x0E,
  0xFF, 0xF9, 0x04, 0x77, 0x10, 0x1F, 0xFF, 0xA0, 0x17, 0x71, 0x05, 0xFF, 0xF9, 0x0D, 0x77, 0x20,
  0x8F, 0xFF, 0x90, 0xA7, 0x72,
  // "Ð" (U+00D0)
  0x76, 0x02, 0xFF, 0xFA, 0x85, 0xEE, 0xCA, 0x84, 0x17, 0x77, 0x60, 0x6F, 0xFF, 0xFA, 0x0B, 0x06,
  0x77, 0x74, 0x0A, 0xFF, 0xFF, 0xC0, 0xE0, 0x77, 0x77, 0x28, 0x29, 0xBC, 0xEF, 0xFF, 0xFB, 0x0D,
  0x04, 0x77, 0x74, 0x02, 0x08, 0xFA, 0x0E, 0x80, 0x26, 0x82, 0x78, 0xAE, 0xFC, 0x07, 0x77, 0x75,
  0x0A, 0xF9, 0x0A, 0x73, 0x03, 0x09, 0xFB, 0x08, 0x77, 0x74, 0x06, 0xF9, 0x07, 0x75, 0x02, 0x0B,
  0xFA, 0x08, 0x77, 0x73, 0x06, 0xF9, 0x03, 0x77, 0x08, 0xFA, 0x05, 0x77, 0x72, 0x08, 0xF9, 0x77,
  0x20, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x10, 0xCF, 0x0C, 0x77, 0x30, 0xAF, 0x90, 0xA7, 0x77, 0x1F,
  0x90, 0x97, 0x73, 0x01, 0x0E, 0xF9, 0x02, 0x77, 0x60, 0x3F, 0x90, 0x57, 0x74, 0x08, 0xF9, 0x09,
  0x77, 0x60, 0x6F, 0x90, 0x27, 0x74, 0x01, 0xF9, 0x0E, 0x77, 0x60, 0xAF, 0x0E, 0x77, 0x60, 0xBF,
  0x90, 0x57, 0x75, 0x0D, 0xF0, 0xB7, 0x76, 0x06, 0xF9, 0x09, 0x77, 0x40, 0x1F, 0x90, 0x77, 0x76,
  0x03, 0xF9, 0x0E, 0x77, 0x40, 0x4F, 0x90, 0x47, 0x77, 0xFA, 0x01, 0x77, 0x30, 0x7F, 0x90, 0x17,
  0x77, 0x0D, 0xF9, 0x04, 0x77, 0x30, 0xBF, 0x0D, 0x77, 0x71, 0x0B, 0xF9, 0x06, 0x77, 0x30, 0xEF,
  0x09, 0x77, 0x71, 0x0A, 0xF9, 0x08, 0x77, 0x20, 0x2F, 0x90, 0x67, 0x77, 0x10, 0x9F, 0x90, 0x97,
  0x72, 0x05, 0xF9, 0x03, 0x77, 0x71, 0x09, 0xF9, 0x0A, 0x77, 0x20, 0x9F, 0x0E, 0x77, 0x72, 0x08,
  0xF9, 0x0A, 0x77, 0x20, 0xCF, 0x0B, 0x77, 0x72, 0x09, 0xF9, 0x0A, 0x77, 0x2F, 0x90, 0x87, 0x77,
  0x20, 0xAF, 0x90, 0xA7, 0x71, 0x03, 0xF9, 0x05, 0x77, 0x72, 0x0A, 0xF9, 0x09, 0x77, 0x10, 0x6F,
  0x90, 0x17, 0x77, 0x20, 0xBF, 0x90, 0x97, 0x71, 0x0A, 0xF0, 0xD7, 0x77, 0x30, 0xBF, 0x90, 0x87,
  0x01, 0xFF, 0xFF, 0x08, 0x74, 0x0D, 0xF9, 0x06, 0x70, 0x4F, 0xFF, 0xF0, 0x57, 0x4F, 0xA0, 0x57,
  0x08, 0xFF, 0xFF, 0x02, 0x73, 0x01, 0xFA, 0x03, 0x70, 0xBF, 0xFF, 0xE0, 0xE7, 0x40, 0x3F, 0xA0,
  0x17, 0x05, 0x80, 0x26, 0x0D, 0xF0, 0xD8, 0x09, 0x06, 0x05, 0x74, 0x05, 0xF9, 0x0E, 0x77, 0x10,
  0xDF, 0x09, 0x77, 0x73, 0x08, 0xF9, 0x0B, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x73, 0x0B, 0xF9, 0x08,
  0x77, 0x04, 0xF9, 0x03, 0x77, 0x73, 0x0E, 0xF9, 0x05, 0x77, 0x08, 0xF9, 0x77, 0x73, 0x02, 0xFA,
  0x01, 0x77, 0x0B, 0xF0, 0xC7, 0x77, 0x30, 0x6F, 0x90, 0xC7, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x30,
  0xBF, 0x90, 0x87, 0x70, 0x2F, 0x90, 0x57, 0x77, 0x3F, 0xA0, 0x37, 0x70, 0x5F, 0x90, 0x27, 0x77,
  0x20, 0x4F, 0x90, 0xE7, 0x71, 0x08, 0xF0, 0xE7, 0x77, 0x30, 0x9F, 0x90, 0x97, 0x71, 0x0B, 0xF0,
  0xB7, 0x77, 0x20, 0x1F, 0xA0, 0x37, 0x71, 0x0E, 0xF0, 0x87, 0x77, 0x20, 0x7F, 0x90, 0xC7, 0x71,
  0x02, 0xF9, 0x04, 0x77, 0x72, 0x0D, 0xF9, 0x05, 0x77, 0x10, 0x5F, 0x90, 0x17, 0x77, 0x10, 0x5F,
  0x90, 0xD7, 0x72, 0x08, 0xF0, 0xD7, 0x77, 0x20, 0xDF, 0x90, 0x67, 0x72, 0x0C, 0xF0, 0xA7, 0x77,
  0x10, 0x6F, 0x90, 0xD7, 0x73, 0xF9, 0x07, 0x77, 0x70, 0x10, 0xEF, 0x90, 0x47, 0x72, 0x03, 0xF9,
  0x04, 0x77, 0x70, 0xAF, 0x90, 0xA7, 0x73, 0x06, 0xF9, 0x77, 0x70, 0x6F, 0x90, 0xE0, 0x17, 0x73,
  0x09, 0xF0, 0xD7, 0x76, 0x03, 0xFA, 0x05, 0x77, 0x40, 0xCF, 0x09, 0x77, 0x50, 0x20, 0xDF, 0x90,
  0x87, 0x75, 0xF9, 0x06, 0x77, 0x40, 0x20, 0xDF, 0x90, 0xB7, 0x75, 0x04, 0xF9, 0x03, 0x77, 0x30,
  0x20, 0xDF, 0x90, 0xC0, 0x17, 0x75, 0x08, 0xF9, 0x77, 0x30, 0x40, 0xEF, 0x90, 0xC0, 0x17, 0x76,
  0x0E, 0xF0, 0xC7, 0x72, 0x09, 0xFA, 0x0C, 0x01, 0x77, 0x60, 0x6F, 0x90, 0x87, 0x70, 0x70, 0xEF,
  0xA0, 0xA7, 0x77, 0x03, 0x0E, 0xF9, 0x05, 0x74, 0x81, 0x49, 0xEF, 0xB0, 0x67, 0x76, 0x02, 0x08,
  0xFB, 0x08, 0x80, 0x26, 0x82, 0x77, 0x9C, 0xFD, 0x0B, 0x02, 0x77, 0x38, 0x28, 0x9A, 0xDF, 0xFF,
  0xFD, 0x0E, 0x06, 0x77, 0x40, 0x1F, 0xFF, 0xFF, 0x0D, 0x06, 0x77, 0x60, 0x5F, 0xFF, 0xFC, 0x81,
  0xD8, 0x37, 0x77, 0x10, 0x8F, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x52, 0x77, 0x74,
  // "Ñ" (U+00D1)
  0x77, 0x77, 0x78, 0x61, 0x7C, 0xEF, 0xDB, 0x57, 0x50, 0x20, 0xF4, 0x80, 0xD0, 0x00, 0x70, 0xEF,
  0x0D, 0x03, 0x73, 0x0C, 0xA0, 0xD8, 0x0C, 0x70, 0x09, 0xFC, 0x05, 0x71, 0x02, 0xB0, 0x98, 0x0C,
  0x60, 0x08, 0xFE, 0x07, 0x70, 0x9B, 0x03, 0x80, 0xC5, 0x00, 0x4F, 0xF9, 0x09, 0x50, 0x2B, 0x0C,
  0x80, 0xC6, 0x00, 0xDB, 0x83, 0xA3, 0x02, 0x8F, 0x98, 0x4C, 0x41, 0x15, 0xEB, 0x04, 0x80, 0xC5,
  0x00, 0x5B, 0x0A, 0x50, 0x40, 0xEF, 0xF0, 0xA8, 0x0C, 0x60, 0x0C, 0xB0, 0x26, 0x02, 0x0D, 0xFD,
  0x0D, 0x01, 0x80, 0xC5, 0x00, 0x3B, 0x09, 0x71, 0x01, 0x0C, 0xFB, 0x0E, 0x02, 0x80, 0xC6, 0x00,
  0x7B, 0x03, 0x73, 0x08, 0xF9, 0x0C, 0x02, 0x80, 0xC7, 0x00, 0x20, 0xF4, 0x75, 0x86, 0x28, 0xCE,
  0xED, 0xA5, 0x80, 0xDE, 0x20, 0x03, 0xFF, 0x0B, 0x77, 0x6F, 0xFD, 0x07, 0x76, 0x06, 0xFF, 0x90,
  0x17, 0x74, 0x03, 0xFF, 0xD0, 0x37, 0x60, 0x9F, 0xF9, 0x06, 0x77, 0x40, 0x6F, 0xFD, 0x77, 0x0D,
  0xFF, 0x90, 0xB7, 0x74, 0x09, 0xFF, 0xC0, 0xC7, 0x72, 0x82, 0x13, 0x7D, 0xFC, 0x01, 0x77, 0x58,
  0x21, 0x37, 0xDF, 0x98, 0x2D, 0x73, 0x17, 0x77, 0x10, 0xDF, 0xB0, 0x67, 0x77, 0x20, 0xDE, 0x08,
  0x77, 0x75, 0x07, 0xFB, 0x0B, 0x77, 0x72, 0x07, 0xD0, 0x97, 0x77, 0x60, 0x6F, 0xC0, 0x17, 0x77,
  0x10, 0x5C, 0x0E, 0x01, 0x77, 0x76, 0x07, 0xFC, 0x06, 0x77, 0x71, 0x07, 0xC0, 0x97, 0x77, 0x70,
  0x9F, 0xC0, 0xC7, 0x77, 0x10, 0xAC, 0x05, 0x77, 0x77, 0x0C, 0xFD, 0x02, 0x77, 0x70, 0xDC, 0x01,
  0x77, 0x77, 0xC0, 0xA0, 0xEF, 0x07, 0x77, 0x60, 0x1C, 0x0D, 0x77, 0x77, 0x03, 0xC0, 0x60, 0xAF,
  0x0C, 0x77, 0x60, 0x4C, 0x09, 0x77, 0x77, 0x07, 0xC0, 0x30, 0x4F, 0x90, 0x27, 0x75, 0x08, 0xC0,
  0x67, 0x77, 0x70, 0xAC, 0x20, 0xEF, 0x07, 0x77, 0x50, 0xBC, 0x03, 0x77, 0x77, 0x0D, 0xB0, 0xC2,
  0x09, 0xF0, 0xC7, 0x75, 0x0E, 0xC7, 0x77, 0x70, 0x1C, 0x09, 0x20, 0x4F, 0x90, 0x27, 0x73, 0x02,
  0xC0, 0xC7, 0x77, 0x70, 0x5C, 0x05, 0x30, 0xEF, 0x08, 0x77, 0x30, 0x5C, 0x08, 0x77, 0x77, 0x08,
  0xC0, 0x23, 0x08, 0xF0, 0xD7, 0x73, 0x08, 0xC0, 0x57, 0x77, 0x70, 0xBB, 0x0E, 0x40, 0x3F, 0x90,
  0x37, 0x72, 0x0C, 0xC0, 0x27, 0x77, 0x70, 0xEB, 0x0B, 0x50, 0xDF, 0x08, 0x77, 0x2C, 0x0E, 0x77,
  0x77, 0x02, 0xC0, 0x85, 0x08, 0xF0, 0xD7, 0x71, 0x03, 0xC0, 0xB7, 0x77, 0x70, 0x6C, 0x04, 0x50,
  0x2F, 0x90, 0x37, 0x70, 0x6C, 0x07, 0x77, 0x77, 0x09, 0xC0, 0x16, 0x0C, 0xF0, 0x87, 0x70, 0x9C,
  0x04, 0x77, 0x77, 0x0C, 0xB0, 0xD7, 0x07, 0xF0, 0xD7, 0x70, 0xDC, 0x01, 0x77, 0x77, 0xC0, 0xA7,
  0x02, 0xF9, 0x03, 0x76, 0xC0, 0xD7, 0x77, 0x70, 0x4C, 0x07, 0x71, 0x0C, 0xF0, 0x97, 0x50, 0x3C,
  0x09, 0x77, 0x77, 0x07, 0xC0, 0x37, 0x10, 0x6F, 0x0E, 0x75, 0x07, 0xC0, 0x67, 0x77, 0x70, 0xAC,
  0x72, 0x01, 0xF9, 0x04, 0x74, 0x0A, 0xC0, 0x37, 0x77, 0x70, 0xEB, 0x0C, 0x73, 0x0B, 0xF0, 0x97,
  0x40, 0xDC, 0x77, 0x77, 0x01, 0xC0, 0x97, 0x30, 0x6F, 0x0E, 0x73, 0x01, 0xC0, 0xC7, 0x77, 0x70,
  0x5C, 0x06, 0x73, 0x01, 0xF9, 0x04, 0x72, 0x04, 0xC0, 0x87, 0x77, 0x70, 0x8C, 0x02, 0x74, 0x0B,
  0xF0, 0x97, 0x20, 0x8C, 0x05, 0x77, 0x77, 0x0B, 0xB0, 0xE7, 0x50, 0x5F, 0x0E, 0x72, 0x0B, 0xC0,
  0x27, 0x77, 0x7C, 0x0B, 0x76, 0x0E, 0xF0, 0x47, 0x10, 0xEB, 0x0E, 0x77, 0x77, 0x03, 0xC0, 0x87,
  0x60, 0xAF, 0x0A, 0x70, 0x2C, 0x0B, 0x77, 0x77, 0x06, 0xC0, 0x57, 0x60, 0x4F, 0x0E, 0x70, 0x5C,
  0x07, 0x77, 0x77, 0x09, 0xC0, 0x17, 0x70, 0xEF, 0x05, 0x60, 0x8C, 0x04, 0x77, 0x77, 0x0D, 0xB0,
  0xE7, 0x71, 0x09, 0xF0, 0xA6, 0x0C, 0xC0, 0x17, 0x77, 0x60, 0x1C, 0x0A, 0x77, 0x10, 0x4F, 0x96,
  0x0E, 0xB0, 0xD7, 0x77, 0x70, 0x4C, 0x07, 0x77, 0x20, 0xEF, 0x05, 0x40, 0x3C, 0x0A, 0x77, 0x77,
  0x07, 0xC0, 0x47, 0x72, 0x09, 0xF0, 0xA4, 0x06, 0xC0, 0x67, 0x77, 0x70, 0xAC, 0x77, 0x30, 0x3F,
  0x90, 0x13, 0x09, 0xC0, 0x37, 0x77, 0x70, 0xEB, 0x0D, 0x77, 0x40, 0xDF, 0x06, 0x30, 0xCC, 0x77,
  0x77, 0x02, 0xC0, 0x97, 0x74, 0x08, 0xF0, 0xB3, 0xC0, 0xC7, 0x77, 0x70, 0x5C, 0x06, 0x77, 0x40,
  0x3F, 0x98, 0x11, 0x03, 0xC0, 0x97, 0x77, 0x70, 0x8C, 0x03, 0x77, 0x50, 0xDF, 0x81, 0x60, 0x7C,
  0x05, 0x77, 0x77, 0x0C, 0xC7, 0x76, 0x07, 0xF8, 0x1B, 0x0A, 0xC0, 0x27, 0x77, 0x7C, 0x0C, 0x77,
  0x60, 0x2F, 0x90, 0x10, 0xDB, 0x0E, 0x77, 0x77, 0x03, 0xC0, 0x87, 0x77, 0x0C, 0xF0, 0x8C, 0x0B,
  0x77, 0x77, 0x06, 0xC0, 0x57, 0x77, 0x07, 0xF0, 0xEC, 0x07, 0x77, 0x77, 0x09, 0xC0, 0x27, 0x77,
  0x01, 0xFD, 0x04, 0x77, 0x77, 0x0D, 0xB0, 0xE7, 0x77, 0x20, 0xBF, 0xC0, 0x17, 0x77, 0x60, 0x1C,
  0x0B, 0x77, 0x72, 0x06, 0xFB, 0x0D, 0x77, 0x77, 0x05, 0xC0, 0x87, 0x77, 0x20, 0x1F, 0xB0, 0xA7,
  0x77, 0x70, 0xBC, 0x06, 0x77, 0x73, 0x0B, 0xFA, 0x06, 0x77, 0x76, 0x02, 0xD0, 0x57, 0x77, 0x30,
  0x5F, 0xA0, 0x37, 0x77, 0x60, 0xBD, 0x06, 0x77, 0x74, 0xFA, 0x77, 0x76, 0x0A, 0xE0, 0xC7, 0x77,
  0x40, 0xAF, 0x0C, 0x77, 0x72, 0x82, 0x13, 0x8E, 0xF9, 0x82, 0xC6, 0x21, 0x77, 0x70, 0x5F, 0x09,
  0x77, 0x70, 0xEF, 0xFC, 0x06, 0x77, 0x60, 0xEE, 0x05, 0x77, 0x60, 0x1F, 0xFD, 0x03, 0x77, 0x60,
  0x9E, 0x02, 0x77, 0x60, 0x5F, 0xFD, 0x77, 0x70, 0x4D, 0x0E, 0x77, 0x70, 0x8F, 0xFC, 0x0C, 0x77,
  0x71, 0x0E, 0xC0, 0xB7, 0x77,
  // "Ò" (U+00D2)
  0x77, 0x75, 0x06, 0x80, 0x37, 0x04, 0x80, 0xD0, 0x00, 0xEF, 0x0C, 0x80, 0xD0, 0x00, 0x6F, 0x90,
  0x28, 0x0D, 0x00, 0x0C, 0xF0, 0x78, 0x0D, 0x00, 0x02, 0xF0, 0xC8, 0x0D, 0x10, 0x07, 0xF0, 0x28,
  0x0D, 0x10, 0x0C, 0xE0, 0x88, 0x0D, 0x10, 0x01, 0x0E, 0xD0, 0xE8, 0x0D, 0x20, 0x05, 0xE0, 0x58,
  0x0D, 0x20, 0x08, 0xD0, 0xB8, 0x0D, 0x30, 0x0B, 0xD0, 0x18, 0x0D, 0x20, 0x01, 0x0D, 0xC0, 0x78,
  0x0D, 0x30, 0x03, 0x0E, 0xB0, 0xD8, 0x0D, 0x40, 0x04, 0xC0, 0x48, 0x0D, 0x40, 0x06, 0xB0, 0x48,
  0x0B, 0xE7, 0x08, 0x94, 0x15, 0x8A, 0xCD, 0xEF, 0xED, 0xB8, 0x51, 0x80, 0xC0, 0x08, 0x11, 0x7C,
  0xFF, 0x0B, 0x04, 0x77, 0x77, 0x48, 0x11, 0x9E, 0xFF, 0xC0, 0xC0, 0x47, 0x77, 0x71, 0x07, 0xFF,
  0xFA, 0x0A, 0x01, 0x77, 0x74, 0x03, 0x0D, 0xFA, 0x85, 0xC8, 0x76, 0x89, 0xDF, 0xA0, 0xD0, 0x17,
  0x77, 0x20, 0x8F, 0x90, 0xD0, 0x67, 0x10, 0x30, 0xBF, 0x90, 0xD0, 0x27, 0x77, 0x0B, 0xF0, 0xE0,
  0x67, 0x50, 0x50, 0xEF, 0x0D, 0x01, 0x77, 0x40, 0x10, 0xCF, 0x0D, 0x02, 0x77, 0x03, 0x0E, 0xF0,
  0xB7, 0x73, 0x01, 0x0C, 0xF0, 0xB0, 0x17, 0x72, 0x04, 0xF9, 0x05, 0x77, 0x10, 0x10, 0xCF, 0x0C,
  0x77, 0x50, 0x9F, 0x0E, 0x77, 0x10, 0xBF, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xEF, 0x07, 0x76, 0x08,
  0xF0, 0xE0, 0x27, 0x77, 0x09, 0xF0, 0xE7, 0x50, 0x5F, 0x90, 0x57, 0x77, 0x10, 0x3F, 0x90, 0x57,
  0x30, 0x10, 0xEF, 0x0A, 0x77, 0x73, 0x0E, 0xF0, 0xA7, 0x30, 0xBF, 0x0E, 0x01, 0x77, 0x73, 0x0B,
  0xF0, 0xE7, 0x20, 0x5F, 0x90, 0x87, 0x77, 0x40, 0x8F, 0x90, 0x37, 0x01, 0x0E, 0xF0, 0xE0, 0x17,
  0x77, 0x40, 0x6F, 0x90, 0x77, 0x08, 0xF9, 0x07, 0x77, 0x75, 0x04, 0xF9, 0x09, 0x60, 0x1F, 0x90,
  0xE7, 0x77, 0x60, 0x3F, 0x90, 0xB6, 0x09, 0xF9, 0x07, 0x77, 0x76, 0x02, 0xF9, 0x0D, 0x50, 0x1F,
  0xA0, 0x17, 0x77, 0x60, 0x2F, 0x90, 0xE5, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x02, 0xFA, 0x50, 0xEF,
  0x90, 0x47, 0x77, 0x70, 0x3F, 0xA4, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x10, 0x3F, 0xA4, 0x0C, 0xF9,
  0x08, 0x77, 0x77, 0x10, 0x4F, 0xA3, 0x02, 0xFA, 0x03, 0x77, 0x77, 0x10, 0x5F, 0xA3, 0x07, 0xF9,
  0x0E, 0x77, 0x77, 0x20, 0x7F, 0x90, 0xE3, 0x0D, 0xF9, 0x0A, 0x77, 0x77, 0x20, 0x9F, 0x90, 0xD2,
  0x02, 0xFA, 0x05, 0x77, 0x77, 0x20, 0xBF, 0x90, 0xB2, 0x06, 0xFA, 0x01, 0x77, 0x77, 0x20, 0xDF,
  0x90, 0x92, 0x0A, 0xF9, 0x0D, 0x77, 0x77, 0x3F, 0xA0, 0x72, 0x0E, 0xF9, 0x09, 0x77, 0x77, 0x20,
  0x2F, 0xA8, 0x14, 0x02, 0xFA, 0x06, 0x77, 0x77, 0x20, 0x6F, 0xA8, 0x11, 0x05, 0xFA, 0x03, 0x77,
  0x77, 0x20, 0x9F, 0x90, 0xD2, 0x08, 0xFA, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xA2, 0x0A, 0xF9, 0x0C,
  0x77, 0x77, 0x3F, 0xA0, 0x62, 0x0C, 0xF9, 0x0A, 0x77, 0x77, 0x20, 0x3F, 0xA0, 0x22, 0x0E, 0xF9,
  0x07, 0x77, 0x77, 0x20, 0x8F, 0x90, 0xD3, 0xFA, 0x06, 0x77, 0x77, 0x20, 0xCF, 0x90, 0x92, 0x02,
  0xFA, 0x04, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x42, 0x02, 0xFA, 0x02, 0x77, 0x77, 0x10, 0x6F, 0x90,
  0xE3, 0x03, 0xFA, 0x01, 0x77, 0x77, 0x10, 0xAF, 0x90, 0x83, 0x03, 0xFA, 0x77, 0x77, 0x10, 0x1F,
  0xA0, 0x23, 0x02, 0xFA, 0x77, 0x77, 0x10, 0x6F, 0x90, 0xB4, 0x02, 0xFA, 0x77, 0x77, 0x10, 0xCF,
  0x90, 0x54, 0x01, 0xF9, 0x0E, 0x77, 0x77, 0x03, 0xF9, 0x0D, 0x6F, 0xA7, 0x77, 0x70, 0x9F, 0x90,
  0x66, 0x0D, 0xF9, 0x77, 0x76, 0x01, 0xF9, 0x0D, 0x70, 0xBF, 0x90, 0x17, 0x77, 0x50, 0x9F, 0x90,
  0x57, 0x08, 0xF9, 0x03, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x71, 0x04, 0xF9, 0x05, 0x77, 0x74, 0x09,
  0xF9, 0x02, 0x72, 0xF9, 0x08, 0x77, 0x73, 0x02, 0xF9, 0x08, 0x73, 0x0B, 0xF0, 0xC7, 0x77, 0x30,
  0xCF, 0x0C, 0x74, 0x05, 0xF9, 0x01, 0x77, 0x71, 0x06, 0xF0, 0xE0, 0x27, 0x50, 0xEF, 0x06, 0x77,
  0x70, 0x3F, 0x90, 0x57, 0x60, 0x8F, 0x0D, 0x77, 0x60, 0x10, 0xDF, 0x08, 0x77, 0x10, 0xEF, 0x06,
  0x77, 0x40, 0x10, 0xCF, 0x0A, 0x77, 0x20, 0x5F, 0x0E, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x0B, 0x77,
  0x40, 0xAF, 0x0E, 0x02, 0x77, 0x02, 0x0D, 0xF0, 0xA7, 0x76, 0x0D, 0xF0, 0xE0, 0x47, 0x50, 0x7F,
  0x90, 0x97, 0x77, 0x02, 0x0D, 0xF9, 0x0A, 0x02, 0x78, 0x11, 0x6D, 0xF9, 0x06, 0x77, 0x72, 0x01,
  0x0D, 0xFA, 0x85, 0xD9, 0x76, 0x79, 0xCF, 0xA0, 0xC0, 0x27, 0x77, 0x50, 0x9F, 0xFF, 0x90, 0xE0,
  0x77, 0x77, 0x71, 0x04, 0x0C, 0xFF, 0xC8, 0x1E, 0x81, 0x77, 0x77, 0x40, 0x50, 0xBF, 0xF0, 0xB0,
  0x68, 0x0C, 0x10, 0x89, 0x41, 0x58, 0xBD, 0xEF, 0xED, 0xDA, 0x85, 0x17, 0x77, 0x40,
  // "Ó" (U+00D3)
  0x80, 0xC2, 0x08, 0x05, 0x70, 0x18, 0x0C, 0x60, 0x06, 0xF9, 0x0D, 0x80, 0xC7, 0x00, 0xEF, 0x0E,
  0x02, 0x80, 0xC6, 0x00, 0x8F, 0x90, 0x48, 0x0C, 0x60, 0x02, 0xF9, 0x05, 0x80, 0xC7, 0x00, 0xCF,
  0x06, 0x80, 0xC7, 0x00, 0x6F, 0x07, 0x80, 0xC7, 0x00, 0x10, 0xEE, 0x07, 0x80, 0xD0, 0x00, 0xBE,
  0x07, 0x80, 0xD0, 0x00, 0x7E, 0x06, 0x80, 0xD0, 0x00, 0x2E, 0x05, 0x80, 0xD1, 0x00, 0xDC, 0x0E,
  0x03, 0x80, 0xD1, 0x00, 0xAC, 0x0C, 0x02, 0x80, 0xD1, 0x00, 0x6C, 0x0A, 0x80, 0xD3, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xBF, 0x50, 0x89, 0x41, 0x58, 0xAC, 0xDE, 0xFE, 0xDB, 0x85, 0x18, 0x0C, 0x00,
  0x81, 0x17, 0xCF, 0xF0, 0xB0, 0x47, 0x77, 0x74, 0x81, 0x19, 0xEF, 0xFC, 0x0C, 0x04, 0x77, 0x77,
  0x10, 0x7F, 0xFF, 0xA0, 0xA0, 0x17, 0x77, 0x40, 0x30, 0xDF, 0xA8, 0x5C, 0x87, 0x68, 0x9D, 0xFA,
  0x0D, 0x01, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x06, 0x71, 0x03, 0x0B, 0xF9, 0x0D, 0x02, 0x77, 0x70,
  0xBF, 0x0E, 0x06, 0x75, 0x05, 0x0E, 0xF0, 0xD0, 0x17, 0x74, 0x01, 0x0C, 0xF0, 0xD0, 0x27, 0x70,
  0x30, 0xEF, 0x0B, 0x77, 0x30, 0x10, 0xCF, 0x0B, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x57, 0x71, 0x01,
  0x0C, 0xF0, 0xC7, 0x75, 0x09, 0xF0, 0xE7, 0x71, 0x0B, 0xF0, 0xD0, 0x17, 0x75, 0x01, 0x0E, 0xF0,
  0x77, 0x60, 0x8F, 0x0E, 0x02, 0x77, 0x70, 0x9F, 0x0E, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x71, 0x03,
  0xF9, 0x05, 0x73, 0x01, 0x0E, 0xF0, 0xA7, 0x77, 0x30, 0xEF, 0x0A, 0x73, 0x0B, 0xF0, 0xE0, 0x17,
  0x77, 0x30, 0xBF, 0x0E, 0x72, 0x05, 0xF9, 0x08, 0x77, 0x74, 0x08, 0xF9, 0x03, 0x70, 0x10, 0xEF,
  0x0E, 0x01, 0x77, 0x74, 0x06, 0xF9, 0x07, 0x70, 0x8F, 0x90, 0x77, 0x77, 0x50, 0x4F, 0x90, 0x96,
  0x01, 0xF9, 0x0E, 0x77, 0x76, 0x03, 0xF9, 0x0B, 0x60, 0x9F, 0x90, 0x77, 0x77, 0x60, 0x2F, 0x90,
  0xD5, 0x01, 0xFA, 0x01, 0x77, 0x76, 0x02, 0xF9, 0x0E, 0x50, 0x8F, 0x90, 0xA7, 0x77, 0x70, 0x2F,
  0xA5, 0x0E, 0xF9, 0x04, 0x77, 0x77, 0x03, 0xFA, 0x40, 0x6F, 0x90, 0xD7, 0x77, 0x71, 0x03, 0xFA,
  0x40, 0xCF, 0x90, 0x87, 0x77, 0x71, 0x04, 0xFA, 0x30, 0x2F, 0xA0, 0x37, 0x77, 0x71, 0x05, 0xFA,
  0x30, 0x7F, 0x90, 0xE7, 0x77, 0x72, 0x07, 0xF9, 0x0E, 0x30, 0xDF, 0x90, 0xA7, 0x77, 0x72, 0x09,
  0xF9, 0x0D, 0x20, 0x2F, 0xA0, 0x57, 0x77, 0x72, 0x0B, 0xF9, 0x0B, 0x20, 0x6F, 0xA0, 0x17, 0x77,
  0x72, 0x0D, 0xF9, 0x09, 0x20, 0xAF, 0x90, 0xD7, 0x77, 0x73, 0xFA, 0x07, 0x20, 0xEF, 0x90, 0x97,
  0x77, 0x72, 0x02, 0xFA, 0x81, 0x40, 0x2F, 0xA0, 0x67, 0x77, 0x72, 0x06, 0xFA, 0x81, 0x10, 0x5F,
  0xA0, 0x37, 0x77, 0x72, 0x09, 0xF9, 0x0D, 0x20, 0x8F, 0xA7, 0x77, 0x73, 0x0C, 0xF9, 0x0A, 0x20,
  0xAF, 0x90, 0xC7, 0x77, 0x73, 0xFA, 0x06, 0x20, 0xCF, 0x90, 0xA7, 0x77, 0x72, 0x03, 0xFA, 0x02,
  0x20, 0xEF, 0x90, 0x77, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x3F, 0xA0, 0x67, 0x77, 0x72, 0x0C, 0xF9,
  0x09, 0x20, 0x2F, 0xA0, 0x47, 0x77, 0x71, 0x01, 0xFA, 0x04, 0x20, 0x2F, 0xA0, 0x27, 0x77, 0x71,
  0x06, 0xF9, 0x0E, 0x30, 0x3F, 0xA0, 0x17, 0x77, 0x71, 0x0A, 0xF9, 0x08, 0x30, 0x3F, 0xA7, 0x77,
  0x71, 0x01, 0xFA, 0x02, 0x30, 0x2F, 0xA7, 0x77, 0x71, 0x06, 0xF9, 0x0B, 0x40, 0x2F, 0xA7, 0x77,
  0x71, 0x0C, 0xF9, 0x05, 0x40, 0x1F, 0x90, 0xE7, 0x77, 0x70, 0x3F, 0x90, 0xD6, 0xFA, 0x77, 0x77,
  0x09, 0xF9, 0x06, 0x60, 0xDF, 0x97, 0x77, 0x60, 0x1F, 0x90, 0xD7, 0x0B, 0xF9, 0x01, 0x77, 0x75,
  0x09, 0xF9, 0x05, 0x70, 0x8F, 0x90, 0x37, 0x77, 0x40, 0x2F, 0x90, 0xB7, 0x10, 0x4F, 0x90, 0x57,
  0x77, 0x40, 0x9F, 0x90, 0x27, 0x2F, 0x90, 0x87, 0x77, 0x30, 0x2F, 0x90, 0x87, 0x30, 0xBF, 0x0C,
  0x77, 0x73, 0x0C, 0xF0, 0xC7, 0x40, 0x5F, 0x90, 0x17, 0x77, 0x10, 0x6F, 0x0E, 0x02, 0x75, 0x0E,
  0xF0, 0x67, 0x77, 0x03, 0xF9, 0x05, 0x76, 0x08, 0xF0, 0xD7, 0x76, 0x01, 0x0D, 0xF0, 0x87, 0x71,
  0x0E, 0xF0, 0x67, 0x74, 0x01, 0x0C, 0xF0, 0xA7, 0x72, 0x05, 0xF0, 0xE0, 0x27, 0x72, 0x01, 0x0C,
  0xF0, 0xB7, 0x74, 0x0A, 0xF0, 0xE0, 0x27, 0x70, 0x20, 0xDF, 0x0A, 0x77, 0x60, 0xDF, 0x0E, 0x04,
  0x75, 0x07, 0xF9, 0x09, 0x77, 0x70, 0x20, 0xDF, 0x90, 0xA0, 0x27, 0x81, 0x16, 0xDF, 0x90, 0x67,
  0x77, 0x20, 0x10, 0xDF, 0xA8, 0x5D, 0x97, 0x67, 0x9C, 0xFA, 0x0C, 0x02, 0x77, 0x75, 0x09, 0xFF,
  0xF9, 0x0E, 0x07, 0x77, 0x77, 0x10, 0x40, 0xCF, 0xFC, 0x81, 0xE8, 0x17, 0x77, 0x74, 0x05, 0x0B,
  0xFF, 0x0B, 0x06, 0x80, 0xC1, 0x08, 0x94, 0x15, 0x8B, 0xDE, 0xFE, 0xDD, 0xA8, 0x51, 0x77, 0x74,
  // "Ô" (U+00D4)
  0x77, 0x77, 0x58, 0x04, 0x78, 0x0D, 0x00, 0x09, 0xF9, 0x03, 0x80, 0xC6, 0x00, 0x4F, 0xA0, 0x78,
  0x0C, 0x50, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xC5, 0x00, 0xCF, 0xC0, 0x18, 0x0C, 0x30, 0x09, 0xFD,
  0x07, 0x80, 0xC2, 0x00, 0x6E, 0x0B, 0x0D, 0xD0, 0xC8, 0x0C, 0x10, 0x03, 0xE8, 0x1A, 0x04, 0xE0,
  0x27, 0x77, 0x77, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x97, 0x77, 0x77, 0x0C, 0xD0, 0x84, 0x01,
  0x0E, 0xC0, 0xE7, 0x77, 0x76, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x77, 0x77, 0x74, 0x09, 0xC0, 0xE0,
  0x57, 0x10, 0x9C, 0x0D, 0x77, 0x77, 0x30, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x77, 0x71,
  0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x77, 0x77, 0x10, 0xCA, 0x0D, 0x04, 0x77, 0x01,
  0x0C, 0xA0, 0xD8, 0x0B, 0xE1, 0x08, 0x94, 0x15, 0x8A, 0xCD, 0xEF, 0xED, 0xB8, 0x51, 0x80, 0xC0,
  0x08, 0x11, 0x7C, 0xFF, 0x0B, 0x04, 0x77, 0x77, 0x48, 0x11, 0x9E, 0xFF, 0xC0, 0xC0, 0x47, 0x77,
  0x71, 0x07, 0xFF, 0xFA, 0x0A, 0x01, 0x77, 0x74, 0x03, 0x0D, 0xFA, 0x85, 0xC8, 0x76, 0x89, 0xDF,
  0xA0, 0xD0, 0x17, 0x77, 0x20, 0x8F, 0x90, 0xD0, 0x67, 0x10, 0x30, 0xBF, 0x90, 0xD0, 0x27, 0x77,
  0x0B, 0xF0, 0xE0, 0x67, 0x50, 0x50, 0xEF, 0x0D, 0x01, 0x77, 0x40, 0x10, 0xCF, 0x0D, 0x02, 0x77,
  0x03, 0x0E, 0xF0, 0xB7, 0x73, 0x01, 0x0C, 0xF0, 0xB0, 0x17, 0x72, 0x04, 0xF9, 0x05, 0x77, 0x10,
  0x10, 0xCF, 0x0C, 0x77, 0x50, 0x9F, 0x0E, 0x77, 0x10, 0xBF, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xEF,
  0x07, 0x76, 0x08, 0xF0, 0xE0, 0x27, 0x77, 0x09, 0xF0, 0xE7, 0x50, 0x5F, 0x90, 0x57, 0x77, 0x10,
  0x3F, 0x90, 0x57, 0x30, 0x10, 0xEF, 0x0A, 0x77, 0x73, 0x0E, 0xF0, 0xA7, 0x30, 0xBF, 0x0E, 0x01,
  0x77, 0x73, 0x0B, 0xF0, 0xE7, 0x20, 0x5F, 0x90, 0x87, 0x77, 0x40, 0x8F, 0x90, 0x37, 0x01, 0x0E,
  0xF0, 0xE0, 0x17, 0x77, 0x40, 0x6F, 0x90, 0x77, 0x08, 0xF9, 0x07, 0x77, 0x75, 0x04, 0xF9, 0x09,
  0x60, 0x1F, 0x90, 0xE7, 0x77, 0x60, 0x3F, 0x90, 0xB6, 0x09, 0xF9, 0x07, 0x77, 0x76, 0x02, 0xF9,
  0x0D, 0x50, 0x1F, 0xA0, 0x17, 0x77, 0x60, 0x2F, 0x90, 0xE5, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x02,
  0xFA, 0x50, 0xEF, 0x90, 0x47, 0x77, 0x70, 0x3F, 0xA4, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x10, 0x3F,
  0xA4, 0x0C, 0xF9, 0x08, 0x77, 0x77, 0x10, 0x4F, 0xA3, 0x02, 0xFA, 0x03, 0x77, 0x77, 0x10, 0x5F,
  0xA3, 0x07, 0xF9, 0x0E, 0x77, 0x77, 0x20, 0x7F, 0x90, 0xE3, 0x0D, 0xF9, 0x0A, 0x77, 0x77, 0x20,
  0x9F, 0x90, 0xD2, 0x02, 0xFA, 0x05, 0x77, 0x77, 0x20, 0xBF, 0x90, 0xB2, 0x06, 0xFA, 0x01, 0x77,
  0x77, 0x20, 0xDF, 0x90, 0x92, 0x0A, 0xF9, 0x0D, 0x77, 0x77, 0x3F, 0xA0, 0x72, 0x0E, 0xF9, 0x09,
  0x77, 0x77, 0x20, 0x2F, 0xA8, 0x14, 0x02, 0xFA, 0x06, 0x77, 0x77, 0x20, 0x6F, 0xA8, 0x11, 0x05,
  0xFA, 0x03, 0x77, 0x77, 0x20, 0x9F, 0x90, 0xD2, 0x08, 0xFA, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xA2,
  0x0A, 0xF9, 0x0C, 0x77, 0x77, 0x3F, 0xA0, 0x62, 0x0C, 0xF9, 0x0A, 0x77, 0x77, 0x20, 0x3F, 0xA0,
  0x22, 0x0E, 0xF9, 0x07, 0x77, 0x77, 0x20, 0x8F, 0x90, 0xD3, 0xFA, 0x06, 0x77, 0x77, 0x20, 0xCF,
  0x90, 0x92, 0x02, 0xFA, 0x04, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x42, 0x02, 0xFA, 0x02, 0x77, 0x77,
  0x10, 0x6F, 0x90, 0xE3, 0x03, 0xFA, 0x01, 0x77, 0x77, 0x10, 0xAF, 0x90, 0x83, 0x03, 0xFA, 0x77,
  0x77, 0x10, 0x1F, 0xA0, 0x23, 0x02, 0xFA, 0x77, 0x77, 0x10, 0x6F, 0x90, 0xB4, 0x02, 0xFA, 0x77,
  0x77, 0x10, 0xCF, 0x90, 0x54, 0x01, 0xF9, 0x0E, 0x77, 0x77, 0x03, 0xF9, 0x0D, 0x6F, 0xA7, 0x77,
  0x70, 0x9F, 0x90, 0x66, 0x0D, 0xF9, 0x77, 0x76, 0x01, 0xF9, 0x0D, 0x70, 0xBF, 0x90, 0x17, 0x77,
  0x50, 0x9F, 0x90, 0x57, 0x08, 0xF9, 0x03, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x71, 0x04, 0xF9, 0x05,
  0x77, 0x74, 0x09, 0xF9, 0x02, 0x72, 0xF9, 0x08, 0x77, 0x73, 0x02, 0xF9, 0x08, 0x73, 0x0B, 0xF0,
  0xC7, 0x77, 0x30, 0xCF, 0x0C, 0x74, 0x05, 0xF9, 0x01, 0x77, 0x71, 0x06, 0xF0, 0xE0, 0x27, 0x50,
  0xEF, 0x06, 0x77, 0x70, 0x3F, 0x90, 0x57, 0x60, 0x8F, 0x0D, 0x77, 0x60, 0x10, 0xDF, 0x08, 0x77,
  0x10, 0xEF, 0x06, 0x77, 0x40, 0x10, 0xCF, 0x0A, 0x77, 0x20, 0x5F, 0x0E, 0x02, 0x77, 0x20, 0x10,
  0xCF, 0x0B, 0x77, 0x40, 0xAF, 0x0E, 0x02, 0x77, 0x02, 0x0D, 0xF0, 0xA7, 0x76, 0x0D, 0xF0, 0xE0,
  0x47, 0x50, 0x7F, 0x90, 0x97, 0x77, 0x02, 0x0D, 0xF9, 0x0A, 0x02, 0x78, 0x11, 0x6D, 0xF9, 0x06,
  0x77, 0x72, 0x01, 0x0D, 0xFA, 0x85, 0xD9, 0x76, 0x79, 0xCF, 0xA0, 0xC0, 0x27, 0x77, 0x50, 0x9F,
  0xFF, 0x90, 0xE0, 0x77, 0x77, 0x71, 0x04, 0x0C, 0xFF, 0xC8, 0x1E, 0x81, 0x77, 0x77, 0x40, 0x50,
  0xBF, 0xF0, 0xB0, 0x68, 0x0C, 0x10, 0x89, 0x41, 0x58, 0xBD, 0xEF, 0xED, 0xDA, 0x85, 0x17, 0x77,
  0x40,
  // "Õ" (U+00D5)
  0x77, 0x75, 0x86, 0x17, 0xCE, 0xFD, 0xB5, 0x75, 0x02, 0x0F, 0x47, 0x77, 0x70, 0x70, 0xEF, 0x0D,
  0x03, 0x73, 0x0C, 0xA0, 0xD7, 0x77, 0x60, 0x9F, 0xC0, 0x57, 0x10, 0x2B, 0x09, 0x77, 0x75, 0x08,
  0xFE, 0x07, 0x70, 0x9B, 0x03, 0x77, 0x74, 0x04, 0xFF, 0x90, 0x95, 0x02, 0xB0, 0xC7, 0x77, 0x50,
  0xDB, 0x83, 0xA3, 0x02, 0x8F, 0x98, 0x4C, 0x41, 0x15, 0xEB, 0x04, 0x77, 0x74, 0x05, 0xB0, 0xA5,
  0x04, 0x0E, 0xFF, 0x0A, 0x77, 0x75, 0x0C, 0xB0, 0x26, 0x02, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x74,
  0x03, 0xB0, 0x97, 0x10, 0x10, 0xCF, 0xB0, 0xE0, 0x27, 0x77, 0x50, 0x7B, 0x03, 0x73, 0x08, 0xF9,
  0x0C, 0x02, 0x77, 0x76, 0x02, 0x0F, 0x47, 0x58, 0x62, 0x8C, 0xEE, 0xDA, 0x58, 0x0B, 0xE3, 0x08,
  0x94, 0x15, 0x8A, 0xCD, 0xEF, 0xED, 0xB8, 0x51, 0x80, 0xC0, 0x08, 0x11, 0x7C, 0xFF, 0x0B, 0x04,
  0x77, 0x77, 0x48, 0x11, 0x9E, 0xFF, 0xC0, 0xC0, 0x47, 0x77, 0x71, 0x07, 0xFF, 0xFA, 0x0A, 0x01,
  0x77, 0x74, 0x03, 0x0D, 0xFA, 0x85, 0xC8, 0x76, 0x89, 0xDF, 0xA0, 0xD0, 0x17, 0x77, 0x20, 0x8F,
  0x90, 0xD0, 0x67, 0x10, 0x30, 0xBF, 0x90, 0xD0, 0x27, 0x77, 0x0B, 0xF0, 0xE0, 0x67, 0x50, 0x50,
  0xEF, 0x0D, 0x01, 0x77, 0x40, 0x10, 0xCF, 0x0D, 0x02, 0x77, 0x03, 0x0E, 0xF0, 0xB7, 0x73, 0x01,
  0x0C, 0xF0, 0xB0, 0x17, 0x72, 0x04, 0xF9, 0x05, 0x77, 0x10, 0x10, 0xCF, 0x0C, 0x77, 0x50, 0x9F,
  0x0E, 0x77, 0x10, 0xBF, 0x0D, 0x01, 0x77, 0x50, 0x10, 0xEF, 0x07, 0x76, 0x08, 0xF0, 0xE0, 0x27,
  0x77, 0x09, 0xF0, 0xE7, 0x50, 0x5F, 0x90, 0x57, 0x77, 0x10, 0x3F, 0x90, 0x57, 0x30, 0x10, 0xEF,
  0x0A, 0x77, 0x73, 0x0E, 0xF0, 0xA7, 0x30, 0xBF, 0x0E, 0x01, 0x77, 0x73, 0x0B, 0xF0, 0xE7, 0x20,
  0x5F, 0x90, 0x87, 0x77, 0x40, 0x8F, 0x90, 0x37, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x77, 0x40, 0x6F,
  0x90, 0x77, 0x08, 0xF9, 0x07, 0x77, 0x75, 0x04, 0xF9, 0x09, 0x60, 0x1F, 0x90, 0xE7, 0x77, 0x60,
  0x3F, 0x90, 0xB6, 0x09, 0xF9, 0x07, 0x77, 0x76, 0x02, 0xF9, 0x0D, 0x50, 0x1F, 0xA0, 0x17, 0x77,
  0x60, 0x2F, 0x90, 0xE5, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x02, 0xFA, 0x50, 0xEF, 0x90, 0x47, 0x77,
  0x70, 0x3F, 0xA4, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x10, 0x3F, 0xA4, 0x0C, 0xF9, 0x08, 0x77, 0x77,
  0x10, 0x4F, 0xA3, 0x02, 0xFA, 0x03, 0x77, 0x77, 0x10, 0x5F, 0xA3, 0x07, 0xF9, 0x0E, 0x77, 0x77,
  0x20, 0x7F, 0x90, 0xE3, 0x0D, 0xF9, 0x0A, 0x77, 0x77, 0x20, 0x9F, 0x90, 0xD2, 0x02, 0xFA, 0x05,
  0x77, 0x77, 0x20, 0xBF, 0x90, 0xB2, 0x06, 0xFA, 0x01, 0x77, 0x77, 0x20, 0xDF, 0x90, 0x92, 0x0A,
  0xF9, 0x0D, 0x77, 0x77, 0x3F, 0xA0, 0x72, 0x0E, 0xF9, 0x09, 0x77, 0x77, 0x20, 0x2F, 0xA8, 0x14,
  0x02, 0xFA, 0x06, 0x77, 0x77, 0x20, 0x6F, 0xA8, 0x11, 0x05, 0xFA, 0x03, 0x77, 0x77, 0x20, 0x9F,
  0x90, 0xD2, 0x08, 0xFA, 0x77, 0x77, 0x30, 0xCF, 0x90, 0xA2, 0x0A, 0xF9, 0x0C, 0x77, 0x77, 0x3F,
  0xA0, 0x62, 0x0C, 0xF9, 0x0A, 0x77, 0x77, 0x20, 0x3F, 0xA0, 0x22, 0x0E, 0xF9, 0x07, 0x77, 0x77,
  0x20, 0x8F, 0x90, 0xD3, 0xFA, 0x06, 0x77, 0x77, 0x20, 0xCF, 0x90, 0x92, 0x02, 0xFA, 0x04, 0x77,
  0x77, 0x10, 0x1F, 0xA0, 0x42, 0x02, 0xFA, 0x02, 0x77, 0x77, 0x10, 0x6F, 0x90, 0xE3, 0x03, 0xFA,
  0x01, 0x77, 0x77, 0x10, 0xAF, 0x90, 0x83, 0x03, 0xFA, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x23, 0x02,
  0xFA, 0x77, 0x77, 0x10, 0x6F, 0x90, 0xB4, 0x02, 0xFA, 0x77, 0x77, 0x10, 0xCF, 0x90, 0x54, 0x01,
  0xF9, 0x0E, 0x77, 0x77, 0x03, 0xF9, 0x0D, 0x6F, 0xA7, 0x77, 0x70, 0x9F, 0x90, 0x66, 0x0D, 0xF9,
  0x77, 0x76, 0x01, 0xF9, 0x0D, 0x70, 0xBF, 0x90, 0x17, 0x77, 0x50, 0x9F, 0x90, 0x57, 0x08, 0xF9,
  0x03, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x71, 0x04, 0xF9, 0x05, 0x77, 0x74, 0x09, 0xF9, 0x02, 0x72,
  0xF9, 0x08, 0x77, 0x73, 0x02, 0xF9, 0x08, 0x73, 0x0B, 0xF0, 0xC7, 0x77, 0x30, 0xCF, 0x0C, 0x74,
  0x05, 0xF9, 0x01, 0x77, 0x71, 0x06, 0xF0, 0xE0, 0x27, 0x50, 0xEF, 0x06, 0x77, 0x70, 0x3F, 0x90,
  0x57, 0x60, 0x8F, 0x0D, 0x77, 0x60, 0x10, 0xDF, 0x08, 0x77, 0x10, 0xEF, 0x06, 0x77, 0x40, 0x10,
  0xCF, 0x0A, 0x77, 0x20, 0x5F, 0x0E, 0x02, 0x77, 0x20, 0x10, 0xCF, 0x0B, 0x77, 0x40, 0xAF, 0x0E,
  0x02, 0x77, 0x02, 0x0D, 0xF0, 0xA7, 0x76, 0x0D, 0xF0, 0xE0, 0x47, 0x50, 0x7F, 0x90, 0x97, 0x77,
  0x02, 0x0D, 0xF9, 0x0A, 0x02, 0x78, 0x11, 0x6D, 0xF9, 0x06, 0x77, 0x72, 0x01, 0x0D, 0xFA, 0x85,
  0xD9, 0x76, 0x79, 0xCF, 0xA0, 0xC0, 0x27, 0x77, 0x50, 0x9F, 0xFF, 0x90, 0xE0, 0x77, 0x77, 0x71,
  0x04, 0x0C, 0xFF, 0xC8, 0x1E, 0x81, 0x77, 0x77, 0x40, 0x50, 0xBF, 0xF0, 0xB0, 0x68, 0x0C, 0x10,
  0x89, 0x41, 0x58, 0xBD, 0xEF, 0xED, 0xDA, 0x85, 0x17, 0x77, 0x40,
  // "Ö" (U+00D6)
  0x77, 0x74, 0x83, 0x5C, 0xFD, 0x77, 0x38, 0x36, 0xDF, 0xD7, 0x77, 0x77, 0x40, 0x7D, 0x09, 0x71,
  0x08, 0xD0, 0x87, 0x77, 0x72, 0x02, 0xF0, 0x16, 0x02, 0xE0, 0xE7, 0x77, 0x72, 0x07, 0xF0, 0x36,
  0x08, 0xF0, 0x27, 0x77, 0x71, 0x0B, 0xF0, 0x46, 0x0C, 0xF0, 0x37, 0x77, 0x71, 0x0C, 0xF0, 0x36,
  0x0D, 0xF0, 0x27, 0x77, 0x71, 0x0B, 0xF7, 0x0C, 0xF7, 0x77, 0x72, 0x09, 0xE0, 0xB7, 0x0A, 0xE0,
  0xA7, 0x77, 0x72, 0x02, 0xD0, 0xE0, 0x27, 0x03, 0xD0, 0xD0, 0x17, 0x77, 0x73, 0x84, 0x3B, 0xEE,
  0xA1, 0x72, 0x84, 0x4C, 0xFE, 0x91, 0x80, 0xEA, 0x10, 0x89, 0x41, 0x58, 0xAC, 0xDE, 0xFE, 0xDB,
  0x85, 0x18, 0x0C, 0x00, 0x81, 0x17, 0xCF, 0xF0, 0xB0, 0x47, 0x77, 0x74, 0x81, 0x19, 0xEF, 0xFC,
  0x0C, 0x04, 0x77, 0x77, 0x10, 0x7F, 0xFF, 0xA0, 0xA0, 0x17, 0x77, 0x40, 0x30, 0xDF, 0xA8, 0x5C,
  0x87, 0x68, 0x9D, 0xFA, 0x0D, 0x01, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x06, 0x71, 0x03, 0x0B, 0xF9,
  0x0D, 0x02, 0x77, 0x70, 0xBF, 0x0E, 0x06, 0x75, 0x05, 0x0E, 0xF0, 0xD0, 0x17, 0x74, 0x01, 0x0C,
  0xF0, 0xD0, 0x27, 0x70, 0x30, 0xEF, 0x0B, 0x77, 0x30, 0x10, 0xCF, 0x0B, 0x01, 0x77, 0x20, 0x4F,
  0x90, 0x57, 0x71, 0x01, 0x0C, 0xF0, 0xC7, 0x75, 0x09, 0xF0, 0xE7, 0x71, 0x0B, 0xF0, 0xD0, 0x17,
  0x75, 0x01, 0x0E, 0xF0, 0x77, 0x60, 0x8F, 0x0E, 0x02, 0x77, 0x70, 0x9F, 0x0E, 0x75, 0x05, 0xF9,
  0x05, 0x77, 0x71, 0x03, 0xF9, 0x05, 0x73, 0x01, 0x0E, 0xF0, 0xA7, 0x77, 0x30, 0xEF, 0x0A, 0x73,
  0x0B, 0xF0, 0xE0, 0x17, 0x77, 0x30, 0xBF, 0x0E, 0x72, 0x05, 0xF9, 0x08, 0x77, 0x74, 0x08, 0xF9,
  0x03, 0x70, 0x10, 0xEF, 0x0E, 0x01, 0x77, 0x74, 0x06, 0xF9, 0x07, 0x70, 0x8F, 0x90, 0x77, 0x77,
  0x50, 0x4F, 0x90, 0x96, 0x01, 0xF9, 0x0E, 0x77, 0x76, 0x03, 0xF9, 0x0B, 0x60, 0x9F, 0x90, 0x77,
  0x77, 0x60, 0x2F, 0x90, 0xD5, 0x01, 0xFA, 0x01, 0x77, 0x76, 0x02, 0xF9, 0x0E, 0x50, 0x8F, 0x90,
  0xA7, 0x77, 0x70, 0x2F, 0xA5, 0x0E, 0xF9, 0x04, 0x77, 0x77, 0x03, 0xFA, 0x40, 0x6F, 0x90, 0xD7,
  0x77, 0x71, 0x03, 0xFA, 0x40, 0xCF, 0x90, 0x87, 0x77, 0x71, 0x04, 0xFA, 0x30, 0x2F, 0xA0, 0x37,
  0x77, 0x71, 0x05, 0xFA, 0x30, 0x7F, 0x90, 0xE7, 0x77, 0x72, 0x07, 0xF9, 0x0E, 0x30, 0xDF, 0x90,
  0xA7, 0x77, 0x72, 0x09, 0xF9, 0x0D, 0x20, 0x2F, 0xA0, 0x57, 0x77, 0x72, 0x0B, 0xF9, 0x0B, 0x20,
  0x6F, 0xA0, 0x17, 0x77, 0x72, 0x0D, 0xF9, 0x09, 0x20, 0xAF, 0x90, 0xD7, 0x77, 0x73, 0xFA, 0x07,
  0x20, 0xEF, 0x90, 0x97, 0x77, 0x72, 0x02, 0xFA, 0x81, 0x40, 0x2F, 0xA0, 0x67, 0x77, 0x72, 0x06,
  0xFA, 0x81, 0x10, 0x5F, 0xA0, 0x37, 0x77, 0x72, 0x09, 0xF9, 0x0D, 0x20, 0x8F, 0xA7, 0x77, 0x73,
  0x0C, 0xF9, 0x0A, 0x20, 0xAF, 0x90, 0xC7, 0x77, 0x73, 0xFA, 0x06, 0x20, 0xCF, 0x90, 0xA7, 0x77,
  0x72, 0x03, 0xFA, 0x02, 0x20, 0xEF, 0x90, 0x77, 0x77, 0x72, 0x08, 0xF9, 0x0D, 0x3F, 0xA0, 0x67,
  0x77, 0x72, 0x0C, 0xF9, 0x09, 0x20, 0x2F, 0xA0, 0x47, 0x77, 0x71, 0x01, 0xFA, 0x04, 0x20, 0x2F,
  0xA0, 0x27, 0x77, 0x71, 0x06, 0xF9, 0x0E, 0x30, 0x3F, 0xA0, 0x17, 0x77, 0x71, 0x0A, 0xF9, 0x08,
  0x30, 0x3F, 0xA7, 0x77, 0x71, 0x01, 0xFA, 0x02, 0x30, 0x2F, 0xA7, 0x77, 0x71, 0x06, 0xF9, 0x0B,
  0x40, 0x2F, 0xA7, 0x77, 0x71, 0x0C, 0xF9, 0x05, 0x40, 0x1F, 0x90, 0xE7, 0x77, 0x70, 0x3F, 0x90,
  0xD6, 0xFA, 0x77, 0x77, 0x09, 0xF9, 0x06, 0x60, 0xDF, 0x97, 0x77, 0x60, 0x1F, 0x90, 0xD7, 0x0B,
  0xF9, 0x01, 0x77, 0x75, 0x09, 0xF9, 0x05, 0x70, 0x8F, 0x90, 0x37, 0x77, 0x40, 0x2F, 0x90, 0xB7,
  0x10, 0x4F, 0x90, 0x57, 0x77, 0x40, 0x9F, 0x90, 0x27, 0x2F, 0x90, 0x87, 0x77, 0x30, 0x2F, 0x90,
  0x87, 0x30, 0xBF, 0x0C, 0x77, 0x73, 0x0C, 0xF0, 0xC7, 0x40, 0x5F, 0x90, 0x17, 0x77, 0x10, 0x6F,
  0x0E, 0x02, 0x75, 0x0E, 0xF0, 0x67, 0x77, 0x03, 0xF9, 0x05, 0x76, 0x08, 0xF0, 0xD7, 0x76, 0x01,
  0x0D, 0xF0, 0x87, 0x71, 0x0E, 0xF0, 0x67, 0x74, 0x01, 0x0C, 0xF0, 0xA7, 0x72, 0x05, 0xF0, 0xE0,
  0x27, 0x72, 0x01, 0x0C, 0xF0, 0xB7, 0x74, 0x0A, 0xF0, 0xE0, 0x27, 0x70, 0x20, 0xDF, 0x0A, 0x77,
  0x60, 0xDF, 0x0E, 0x04, 0x75, 0x07, 0xF9, 0x09, 0x77, 0x70, 0x20, 0xDF, 0x90, 0xA0, 0x27, 0x81,
  0x16, 0xDF, 0x90, 0x67, 0x77, 0x20, 0x10, 0xDF, 0xA8, 0x5D, 0x97, 0x67, 0x9C, 0xFA, 0x0C, 0x02,
  0x77, 0x75, 0x09, 0xFF, 0xF9, 0x0E, 0x07, 0x77, 0x77, 0x10, 0x40, 0xCF, 0xFC, 0x81, 0xE8, 0x17,
  0x77, 0x74, 0x05, 0x0B, 0xFF, 0x0B, 0x06, 0x80, 0xC1, 0x08, 0x94, 0x15, 0x8B, 0xDE, 0xFE, 0xDD,
  0xA8, 0x51, 0x77, 0x74,
  // "×" (U+00D7)
  0x30, 0x10, 0x97, 0x77, 0x30, 0x80, 0x15, 0x82, 0x2D, 0xFA, 0x77, 0x71, 0x82, 0x9F, 0xE3, 0x30,
  0x30, 0xEB, 0x08, 0x77, 0x60, 0x6B, 0x82, 0xE5, 0x01, 0xE0, 0x67, 0x74, 0x04, 0xE8, 0x13, 0x07,
  0xE0, 0x47, 0x72, 0x02, 0x0E, 0xD0, 0x83, 0x09, 0xD0, 0xE0, 0x27, 0x70, 0x10, 0xDD, 0x0B, 0x50,
  0xBD, 0x0D, 0x01, 0x76, 0x0C, 0xD0, 0xC6, 0x01, 0x0D, 0xD0, 0xB7, 0x50, 0xAD, 0x0E, 0x01, 0x70,
  0x20, 0xED, 0x0A, 0x73, 0x08, 0xE0, 0x37, 0x20, 0x3E, 0x07, 0x71, 0x06, 0xE0, 0x57, 0x40, 0x5E,
  0x05, 0x60, 0x4E, 0x07, 0x76, 0x07, 0xE0, 0x34, 0x02, 0x0E, 0xD0, 0x97, 0x71, 0x09, 0xD0, 0xE0,
  0x22, 0x01, 0x0D, 0xD0, 0xB7, 0x73, 0x0B, 0xD8, 0x2D, 0x10, 0xCD, 0x0D, 0x01, 0x77, 0x30, 0x10,
  0xDD, 0x0B, 0x0A, 0xD0, 0xE0, 0x27, 0x75, 0x02, 0x0E, 0xFC, 0x04, 0x77, 0x70, 0x3F, 0xB0, 0x67,
  0x77, 0x20, 0x5F, 0x90, 0x87, 0x77, 0x40, 0x8E, 0x0B, 0x77, 0x75, 0x0C, 0xE0, 0xE0, 0x27, 0x77,
  0x30, 0xBF, 0x90, 0xD0, 0x17, 0x77, 0x10, 0x9F, 0xB0, 0xB7, 0x77, 0x06, 0xE0, 0xED, 0x09, 0x77,
  0x50, 0x4E, 0x05, 0x04, 0xE0, 0x77, 0x73, 0x02, 0x0E, 0xD0, 0x72, 0x06, 0xE0, 0x57, 0x71, 0x01,
  0x0D, 0xD0, 0x94, 0x08, 0xD0, 0xE0, 0x37, 0x70, 0xCD, 0x0B, 0x60, 0xAD, 0x0D, 0x01, 0x75, 0x0A,
  0xD0, 0xD0, 0x17, 0x0C, 0xD0, 0xC7, 0x40, 0x8D, 0x0E, 0x02, 0x71, 0x01, 0x0D, 0xD0, 0xA7, 0x20,
  0x5E, 0x04, 0x73, 0x03, 0x0E, 0xD0, 0x87, 0x03, 0xE0, 0x67, 0x50, 0x4E, 0x06, 0x50, 0x20, 0xED,
  0x08, 0x77, 0x07, 0xE0, 0x43, 0x01, 0x0D, 0xD0, 0xA7, 0x72, 0x09, 0xD0, 0xE0, 0x22, 0x0B, 0xD0,
  0xC7, 0x74, 0x0B, 0xD8, 0x2D, 0x11, 0xCC, 0x0D, 0x01, 0x77, 0x40, 0x10, 0xDC, 0x0C, 0x01, 0x20,
  0xAA, 0x0E, 0x03, 0x77, 0x60, 0x20, 0xEA, 0x0B, 0x58, 0x18, 0xF5, 0x77, 0x71, 0x81, 0x3F, 0x97,
  0x02, 0x77, 0x73, 0x02, 0x40,
  // "Ø" (U+00D8)
  0x80, 0xD4, 0x00, 0xDB, 0x0C, 0x80, 0xD3, 0x00, 0x9C, 0x03, 0x80, 0xD2, 0x00, 0x5C, 0x08, 0x77,
  0x76, 0x89, 0x41, 0x58, 0xAC, 0xDE, 0xFE, 0xDC, 0x96, 0x25, 0x01, 0x0E, 0xB0, 0xD7, 0x77, 0x50,
  0x60, 0xBF, 0xF8, 0x1C, 0x71, 0x20, 0xBC, 0x04, 0x77, 0x72, 0x81, 0x18, 0xEF, 0xFC, 0x81, 0xE7,
  0x7C, 0x09, 0x77, 0x72, 0x07, 0x0E, 0xFF, 0xFD, 0x0E, 0x01, 0x77, 0x70, 0x30, 0xDF, 0xA8, 0x5C,
  0x87, 0x67, 0x9D, 0xFD, 0x05, 0x77, 0x70, 0x7F, 0x90, 0xD0, 0x67, 0x10, 0x40, 0xCF, 0xA0, 0xB7,
  0x77, 0x0A, 0xF0, 0xE0, 0x67, 0x50, 0x9F, 0x90, 0x97, 0x75, 0x01, 0x0B, 0xF0, 0xD0, 0x27, 0x70,
  0x9F, 0x90, 0x67, 0x74, 0x0C, 0xF0, 0xB0, 0x17, 0x72, 0x0C, 0xF0, 0xE0, 0x17, 0x72, 0x0B, 0xF0,
  0xC7, 0x74, 0x09, 0xF9, 0x0A, 0x77, 0x10, 0xAF, 0x0D, 0x01, 0x77, 0x30, 0x4F, 0xB0, 0x37, 0x60,
  0x7F, 0x0E, 0x02, 0x77, 0x40, 0xDF, 0xB0, 0xB7, 0x50, 0x4F, 0x90, 0x57, 0x74, 0x08, 0xFD, 0x02,
  0x73, 0x01, 0x0D, 0xF0, 0xB7, 0x74, 0x03, 0xC0, 0xAF, 0x90, 0x87, 0x30, 0xAF, 0x0E, 0x01, 0x77,
  0x40, 0xDB, 0x81, 0xC0, 0xEF, 0x0C, 0x72, 0x04, 0xF9, 0x08, 0x77, 0x40, 0x8C, 0x81, 0x20, 0xAF,
  0x90, 0x17, 0x10, 0xDF, 0x0E, 0x01, 0x77, 0x30, 0x2C, 0x08, 0x20, 0x7F, 0x90, 0x57, 0x07, 0xF9,
  0x07, 0x77, 0x40, 0xCB, 0x0D, 0x30, 0x5F, 0x90, 0x86, 0x01, 0x0E, 0xF0, 0xE7, 0x74, 0x07, 0xC0,
  0x33, 0x04, 0xF9, 0x0B, 0x60, 0x8F, 0x90, 0x77, 0x73, 0x02, 0xC0, 0x94, 0x02, 0xF9, 0x0C, 0x50,
  0x10, 0xEF, 0x90, 0x17, 0x73, 0x0B, 0xB0, 0xD5, 0x02, 0xF9, 0x0E, 0x50, 0x7F, 0x90, 0xB7, 0x73,
  0x06, 0xC0, 0x45, 0x02, 0xFA, 0x50, 0xDF, 0x90, 0x57, 0x72, 0x01, 0x0E, 0xB0, 0x96, 0x02, 0xFA,
  0x40, 0x5F, 0x90, 0xE7, 0x73, 0x0B, 0xB0, 0xE0, 0x16, 0x03, 0xFA, 0x40, 0xBF, 0x90, 0x87, 0x72,
  0x05, 0xC0, 0x57, 0x04, 0xFA, 0x30, 0x1F, 0xA0, 0x37, 0x71, 0x01, 0x0E, 0xB0, 0xA7, 0x10, 0x5F,
  0xA3, 0x06, 0xF9, 0x0E, 0x77, 0x20, 0xAB, 0x0E, 0x01, 0x71, 0x06, 0xF9, 0x0E, 0x30, 0xBF, 0x90,
  0xA7, 0x71, 0x04, 0xC0, 0x67, 0x20, 0x8F, 0x90, 0xD2, 0x01, 0xFA, 0x05, 0x77, 0x01, 0x0D, 0xB0,
  0xB7, 0x30, 0xAF, 0x90, 0xB2, 0x05, 0xFA, 0x01, 0x77, 0x09, 0xB0, 0xE0, 0x27, 0x30, 0xCF, 0x90,
  0x92, 0x09, 0xF9, 0x0D, 0x77, 0x04, 0xC0, 0x67, 0x40, 0xEF, 0x90, 0x72, 0x0D, 0xF9, 0x09, 0x77,
  0x0D, 0xB0, 0xC7, 0x40, 0x1F, 0xA8, 0x15, 0x01, 0xFA, 0x06, 0x76, 0x08, 0xC0, 0x27, 0x40, 0x4F,
  0xA8, 0x12, 0x04, 0xFA, 0x03, 0x75, 0x03, 0xC0, 0x77, 0x50, 0x8F, 0x90, 0xE2, 0x07, 0xFA, 0x76,
  0x0D, 0xB0, 0xC7, 0x60, 0xBF, 0x90, 0xB2, 0x09, 0xF9, 0x0C, 0x75, 0x08, 0xC0, 0x37, 0x60, 0xEF,
  0x90, 0x72, 0x0C, 0xF9, 0x0A, 0x74, 0x02, 0xC0, 0x87, 0x60, 0x2F, 0xA0, 0x32, 0x0E, 0xF9, 0x08,
  0x74, 0x0C, 0xB0, 0xD7, 0x70, 0x6F, 0x90, 0xE3, 0xFA, 0x06, 0x73, 0x07, 0xC0, 0x47, 0x70, 0xBF,
  0x90, 0x92, 0x01, 0xFA, 0x04, 0x72, 0x02, 0xC0, 0x97, 0x71, 0xFA, 0x05, 0x20, 0x2F, 0xA0, 0x27,
  0x20, 0xBB, 0x0D, 0x01, 0x77, 0x04, 0xF9, 0x0E, 0x30, 0x3F, 0xA0, 0x17, 0x10, 0x6C, 0x04, 0x77,
  0x10, 0x9F, 0x90, 0x93, 0x03, 0xFA, 0x71, 0x01, 0x0E, 0xB0, 0xA7, 0x72, 0x0E, 0xF9, 0x03, 0x30,
  0x3F, 0xA7, 0x10, 0xBB, 0x0E, 0x01, 0x77, 0x10, 0x5F, 0x90, 0xC4, 0x02, 0xFA, 0x70, 0x5C, 0x05,
  0x77, 0x20, 0xBF, 0x90, 0x54, 0x02, 0xF9, 0x0E, 0x60, 0x10, 0xEB, 0x0B, 0x77, 0x20, 0x1F, 0x90,
  0xE6, 0xFA, 0x60, 0xAB, 0x0E, 0x01, 0x77, 0x20, 0x7F, 0x90, 0x76, 0x0E, 0xF9, 0x50, 0x4C, 0x06,
  0x77, 0x30, 0xEF, 0x0E, 0x70, 0xCF, 0x90, 0x13, 0x01, 0x0D, 0xB0, 0xB7, 0x73, 0x07, 0xF9, 0x06,
  0x70, 0x9F, 0x90, 0x33, 0x09, 0xC0, 0x27, 0x72, 0x01, 0x0E, 0xF0, 0xC7, 0x10, 0x6F, 0x90, 0x52,
  0x04, 0xC0, 0x77, 0x73, 0x08, 0xF9, 0x03, 0x71, 0x02, 0xF9, 0x08, 0x20, 0xDB, 0x0C, 0x77, 0x30,
  0x10, 0xEF, 0x09, 0x73, 0x0C, 0xF8, 0x1C, 0x08, 0xC0, 0x37, 0x73, 0x0A, 0xF0, 0xD7, 0x40, 0x7F,
  0x90, 0x4C, 0x08, 0x77, 0x30, 0x5F, 0x90, 0x37, 0x40, 0x1F, 0xD0, 0xD7, 0x73, 0x02, 0x0E, 0xF0,
  0x67, 0x60, 0xAF, 0xC0, 0x37, 0x72, 0x01, 0x0D, 0xF0, 0x97, 0x70, 0x2F, 0xB0, 0x97, 0x73, 0x0C,
  0xF0, 0xB7, 0x72, 0x09, 0xF9, 0x0D, 0x77, 0x20, 0x10, 0xBF, 0x0B, 0x77, 0x40, 0xDF, 0x0D, 0x01,
  0x77, 0x02, 0x0D, 0xF0, 0xB7, 0x75, 0x03, 0xF9, 0x0D, 0x02, 0x75, 0x07, 0x0E, 0xF0, 0xA7, 0x77,
  0x05, 0xFA, 0x08, 0x01, 0x71, 0x06, 0x0D, 0xF9, 0x07, 0x77, 0x71, 0x07, 0xFC, 0x85, 0xC9, 0x76,
  0x79, 0xCF, 0xA0, 0xD0, 0x37, 0x77, 0x10, 0x2F, 0xFF, 0xD0, 0xE0, 0x77, 0x77, 0x30, 0xCB, 0x81,
  0xD8, 0xEF, 0xFC, 0x81, 0xE8, 0x17, 0x77, 0x30, 0x8C, 0x83, 0x30, 0x17, 0xDF, 0xF8, 0x1C, 0x71,
  0x77, 0x74, 0x03, 0xC0, 0x75, 0x89, 0x42, 0x69, 0xCD, 0xEF, 0xED, 0xDA, 0x85, 0x17, 0x77, 0x60,
  0x10, 0xDB, 0x0B, 0x80, 0xD3, 0x00, 0xAB, 0x0E, 0x01, 0x80, 0xD2, 0x00, 0x5C, 0x05, 0x80, 0xD2,
  0x00,
  // "Ù" (U+00D9)
  0x77, 0x71, 0x06, 0x80, 0x37, 0x04, 0x80, 0xD4, 0x00, 0xEF, 0x0C, 0x80, 0xD4, 0x00, 0x6F, 0x90,
  0x28, 0x0D, 0x40, 0x0C, 0xF0, 0x78, 0x0D, 0x40, 0x02, 0xF0, 0xC8, 0x0D, 0x50, 0x07, 0xF0, 0x28,
  0x0D, 0x50, 0x0C, 0xE0, 0x88, 0x0D, 0x50, 0x01, 0x0E, 0xD0, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x58,
  0x0D, 0x60, 0x08, 0xD0, 0xB8, 0x0D, 0x70, 0x0B, 0xD0, 0x18, 0x0D, 0x60, 0x01, 0x0D, 0xC0, 0x78,
  0x0D, 0x70, 0x03, 0x0E, 0xB0, 0xD8, 0x0E, 0x00, 0x04, 0xC0, 0x48, 0x0E, 0x00, 0x06, 0xB0, 0x48,
  0x0C, 0xE1, 0x00, 0xAF, 0xFF, 0x90, 0x87, 0x30, 0xBF, 0xFC, 0x0D, 0x30, 0xDF, 0xFF, 0x90, 0x57,
  0x30, 0xEF, 0xFC, 0x0B, 0x20, 0x1F, 0xFF, 0xA0, 0x37, 0x20, 0x2F, 0xFD, 0x08, 0x20, 0x4F, 0xFF,
  0xA7, 0x30, 0x5F, 0xFD, 0x05, 0x48, 0x21, 0x25, 0xAF, 0xD8, 0x2E, 0x84, 0x17, 0x78, 0x21, 0x25,
  0xAF, 0xA8, 0x1A, 0x52, 0x74, 0x06, 0xFB, 0x09, 0x77, 0x71, 0x06, 0xE0, 0xD0, 0x37, 0x71, 0xFA,
  0x0B, 0x77, 0x73, 0xD0, 0xE0, 0x27, 0x72, 0x0E, 0xF9, 0x02, 0x77, 0x73, 0x0D, 0xC0, 0x87, 0x73,
  0xF9, 0x0A, 0x77, 0x74, 0xD0, 0x17, 0x72, 0x02, 0xF9, 0x06, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x73,
  0x05, 0xF9, 0x02, 0x77, 0x73, 0x06, 0xC0, 0x87, 0x73, 0x09, 0xF0, 0xE7, 0x77, 0x40, 0x9C, 0x05,
  0x77, 0x30, 0xCF, 0x0B, 0x77, 0x74, 0x0C, 0xC0, 0x17, 0x73, 0xF9, 0x07, 0x77, 0x74, 0xC0, 0xE7,
  0x73, 0x03, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xC0, 0xA7, 0x73, 0x06, 0xF9, 0x01, 0x77, 0x73, 0x07,
  0xC0, 0x77, 0x73, 0x0A, 0xF0, 0xD7, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x30, 0xDF, 0x09, 0x77, 0x74,
  0x0D, 0xC0, 0x17, 0x72, 0x01, 0xF9, 0x06, 0x77, 0x73, 0x01, 0xC0, 0xD7, 0x73, 0x04, 0xF9, 0x03,
  0x77, 0x73, 0x04, 0xC0, 0x97, 0x73, 0x07, 0xF9, 0x77, 0x74, 0x08, 0xC0, 0x67, 0x73, 0x0B, 0xF0,
  0xC7, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x30, 0xEF, 0x08, 0x77, 0x74, 0x0E, 0xC7, 0x73, 0x02, 0xF9,
  0x05, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x73, 0x05, 0xF9, 0x02, 0x77, 0x73, 0x05, 0xC0, 0x87, 0x73,
  0x08, 0xF0, 0xE7, 0x77, 0x40, 0x9C, 0x05, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x74, 0x0C, 0xC0, 0x27,
  0x73, 0xF9, 0x07, 0x77, 0x74, 0xC0, 0xE7, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xC0, 0xB7,
  0x73, 0x06, 0xF9, 0x01, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x73, 0x09, 0xF0, 0xD7, 0x77, 0x40, 0xAC,
  0x04, 0x77, 0x30, 0xDF, 0x0A, 0x77, 0x74, 0x0D, 0xC0, 0x17, 0x72, 0x01, 0xF9, 0x06, 0x77, 0x73,
  0x01, 0xC0, 0xD7, 0x73, 0x04, 0xF9, 0x03, 0x77, 0x73, 0x04, 0xC0, 0xA7, 0x73, 0x07, 0xF9, 0x77,
  0x74, 0x08, 0xC0, 0x67, 0x73, 0x0A, 0xF0, 0xC7, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x30, 0xEF, 0x09,
  0x77, 0x74, 0x0E, 0xC7, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x73, 0x05, 0xF9,
  0x02, 0x77, 0x73, 0x05, 0xC0, 0x97, 0x73, 0x08, 0xF0, 0xE7, 0x77, 0x40, 0x9C, 0x05, 0x77, 0x30,
  0xBF, 0x0B, 0x77, 0x74, 0x0C, 0xC0, 0x27, 0x73, 0x0E, 0xF0, 0x87, 0x77, 0x4C, 0x0E, 0x77, 0x30,
  0x2F, 0x90, 0x57, 0x77, 0x30, 0x3C, 0x0B, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x77, 0x30, 0x6C, 0x07,
  0x77, 0x30, 0x8F, 0x0E, 0x77, 0x74, 0x0A, 0xC0, 0x47, 0x73, 0x0A, 0xF0, 0xC7, 0x77, 0x40, 0xDC,
  0x01, 0x77, 0x30, 0xCF, 0x0A, 0x77, 0x73, 0x02, 0xC0, 0xD7, 0x74, 0x0E, 0xF0, 0x87, 0x77, 0x30,
  0x6C, 0x08, 0x77, 0x4F, 0x90, 0x67, 0x77, 0x30, 0xAC, 0x04, 0x77, 0x30, 0x1F, 0x90, 0x57, 0x77,
  0x30, 0xEC, 0x77, 0x5F, 0x90, 0x47, 0x77, 0x20, 0x6C, 0x0A, 0x77, 0x5F, 0x90, 0x57, 0x77, 0x20,
  0xDC, 0x04, 0x77, 0x50, 0xEF, 0x06, 0x77, 0x71, 0x04, 0xC0, 0xC7, 0x76, 0x0C, 0xF0, 0x97, 0x77,
  0x10, 0xCC, 0x06, 0x77, 0x60, 0x8F, 0x0D, 0x77, 0x70, 0x6C, 0x0D, 0x77, 0x70, 0x4F, 0x90, 0x57,
  0x75, 0x03, 0xD0, 0x37, 0x77, 0x10, 0xDF, 0x0D, 0x01, 0x77, 0x30, 0x30, 0xEC, 0x09, 0x77, 0x72,
  0x07, 0xF9, 0x0C, 0x01, 0x77, 0x10, 0x6D, 0x0D, 0x01, 0x77, 0x73, 0x0D, 0xF9, 0x0E, 0x05, 0x75,
  0x03, 0x0B, 0xD0, 0xE0, 0x27, 0x77, 0x40, 0x30, 0xEF, 0xA8, 0x3E, 0x85, 0x21, 0x28, 0x31, 0x25,
  0x8D, 0xE0, 0xE0, 0x37, 0x77, 0x60, 0x4F, 0xFF, 0xD0, 0xE0, 0x37, 0x77, 0x71, 0x03, 0x0D, 0xFF,
  0xFA, 0x0B, 0x01, 0x77, 0x77, 0x40, 0x8F, 0xFE, 0x0D, 0x05, 0x77, 0x77, 0x78, 0x11, 0x7D, 0xFF,
  0x90, 0xB0, 0x58, 0x0C, 0x40, 0x89, 0x42, 0x59, 0xBC, 0xDE, 0xFE, 0xEC, 0xA8, 0x47, 0x77, 0x74,
  // "Ú" (U+00DA)
  0x80, 0xC1, 0x08, 0x05, 0x70, 0x18, 0x0D, 0x20, 0x06, 0xF9, 0x0D, 0x80, 0xD3, 0x00, 0xEF, 0x0E,
  0x02, 0x80, 0xD2, 0x00, 0x8F, 0x90, 0x48, 0x0D, 0x20, 0x02, 0xF9, 0x05, 0x80, 0xD3, 0x00, 0xCF,
  0x06, 0x80, 0xD3, 0x00, 0x6F, 0x07, 0x80, 0xD3, 0x00, 0x10, 0xEE, 0x07, 0x80, 0xD4, 0x00, 0xBE,
  0x07, 0x80, 0xD4, 0x00, 0x7E, 0x06, 0x80, 0xD4, 0x00, 0x2E, 0x05, 0x80, 0xD5, 0x00, 0xDC, 0x0E,
  0x03, 0x80, 0xD5, 0x00, 0xAC, 0x0C, 0x02, 0x80, 0xD5, 0x00, 0x6C, 0x0A, 0x80, 0xD7, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xCE, 0x40, 0x0A, 0xFF, 0xF9, 0x08, 0x73, 0x0B, 0xFF, 0xC0, 0xD3, 0x0D, 0xFF,
  0xF9, 0x05, 0x73, 0x0E, 0xFF, 0xC0, 0xB2, 0x01, 0xFF, 0xFA, 0x03, 0x72, 0x02, 0xFF, 0xD0, 0x82,
  0x04, 0xFF, 0xFA, 0x73, 0x05, 0xFF, 0xD0, 0x54, 0x82, 0x12, 0x5A, 0xFD, 0x82, 0xE8, 0x41, 0x77,
  0x82, 0x12, 0x5A, 0xFA, 0x81, 0xA5, 0x27, 0x40, 0x6F, 0xB0, 0x97, 0x77, 0x10, 0x6E, 0x0D, 0x03,
  0x77, 0x1F, 0xA0, 0xB7, 0x77, 0x3D, 0x0E, 0x02, 0x77, 0x20, 0xEF, 0x90, 0x27, 0x77, 0x30, 0xDC,
  0x08, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x4D, 0x01, 0x77, 0x20, 0x2F, 0x90, 0x67, 0x77, 0x30, 0x2C,
  0x0C, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x77, 0x30, 0x6C, 0x08, 0x77, 0x30, 0x9F, 0x0E, 0x77, 0x74,
  0x09, 0xC0, 0x57, 0x73, 0x0C, 0xF0, 0xB7, 0x77, 0x40, 0xCC, 0x01, 0x77, 0x3F, 0x90, 0x77, 0x77,
  0x4C, 0x0E, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x77, 0x30, 0x3C, 0x0A, 0x77, 0x30, 0x6F, 0x90, 0x17,
  0x77, 0x30, 0x7C, 0x07, 0x77, 0x30, 0xAF, 0x0D, 0x77, 0x74, 0x0A, 0xC0, 0x47, 0x73, 0x0D, 0xF0,
  0x97, 0x77, 0x40, 0xDC, 0x01, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x77, 0x30, 0x1C, 0x0D, 0x77, 0x30,
  0x4F, 0x90, 0x37, 0x77, 0x30, 0x4C, 0x09, 0x77, 0x30, 0x7F, 0x97, 0x77, 0x40, 0x8C, 0x06, 0x77,
  0x30, 0xBF, 0x0C, 0x77, 0x74, 0x0B, 0xC0, 0x37, 0x73, 0x0E, 0xF0, 0x87, 0x77, 0x40, 0xEC, 0x77,
  0x30, 0x2F, 0x90, 0x57, 0x77, 0x30, 0x2C, 0x0C, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x77, 0x30, 0x5C,
  0x08, 0x77, 0x30, 0x8F, 0x0E, 0x77, 0x74, 0x09, 0xC0, 0x57, 0x73, 0x0C, 0xF0, 0xB7, 0x77, 0x40,
  0xCC, 0x02, 0x77, 0x3F, 0x90, 0x77, 0x77, 0x4C, 0x0E, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x77, 0x30,
  0x3C, 0x0B, 0x77, 0x30, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x30, 0x9F, 0x0D, 0x77,
  0x74, 0x0A, 0xC0, 0x47, 0x73, 0x0D, 0xF0, 0xA7, 0x77, 0x40, 0xDC, 0x01, 0x77, 0x20, 0x1F, 0x90,
  0x67, 0x77, 0x30, 0x1C, 0x0D, 0x77, 0x30, 0x4F, 0x90, 0x37, 0x77, 0x30, 0x4C, 0x0A, 0x77, 0x30,
  0x7F, 0x97, 0x77, 0x40, 0x8C, 0x06, 0x77, 0x30, 0xAF, 0x0C, 0x77, 0x74, 0x0B, 0xC0, 0x37, 0x73,
  0x0E, 0xF0, 0x97, 0x77, 0x40, 0xEC, 0x77, 0x30, 0x2F, 0x90, 0x57, 0x77, 0x30, 0x2C, 0x0C, 0x77,
  0x30, 0x5F, 0x90, 0x27, 0x77, 0x30, 0x5C, 0x09, 0x77, 0x30, 0x8F, 0x0E, 0x77, 0x74, 0x09, 0xC0,
  0x57, 0x73, 0x0B, 0xF0, 0xB7, 0x77, 0x40, 0xCC, 0x02, 0x77, 0x30, 0xEF, 0x08, 0x77, 0x74, 0xC0,
  0xE7, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x73, 0x03, 0xC0, 0xB7, 0x73, 0x05, 0xF9, 0x02, 0x77, 0x73,
  0x06, 0xC0, 0x77, 0x73, 0x08, 0xF0, 0xE7, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x30, 0xAF, 0x0C, 0x77,
  0x74, 0x0D, 0xC0, 0x17, 0x73, 0x0C, 0xF0, 0xA7, 0x77, 0x30, 0x2C, 0x0D, 0x77, 0x40, 0xEF, 0x08,
  0x77, 0x73, 0x06, 0xC0, 0x87, 0x74, 0xF9, 0x06, 0x77, 0x73, 0x0A, 0xC0, 0x47, 0x73, 0x01, 0xF9,
  0x05, 0x77, 0x73, 0x0E, 0xC7, 0x75, 0xF9, 0x04, 0x77, 0x72, 0x06, 0xC0, 0xA7, 0x75, 0xF9, 0x05,
  0x77, 0x72, 0x0D, 0xC0, 0x47, 0x75, 0x0E, 0xF0, 0x67, 0x77, 0x10, 0x4C, 0x0C, 0x77, 0x60, 0xCF,
  0x09, 0x77, 0x71, 0x0C, 0xC0, 0x67, 0x76, 0x08, 0xF0, 0xD7, 0x77, 0x06, 0xC0, 0xD7, 0x77, 0x04,
  0xF9, 0x05, 0x77, 0x50, 0x3D, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD0, 0x17, 0x73, 0x03, 0x0E, 0xC0,
  0x97, 0x77, 0x20, 0x7F, 0x90, 0xC0, 0x17, 0x71, 0x06, 0xD0, 0xD0, 0x17, 0x77, 0x30, 0xDF, 0x90,
  0xE0, 0x57, 0x50, 0x30, 0xBD, 0x0E, 0x02, 0x77, 0x74, 0x03, 0x0E, 0xFA, 0x83, 0xE8, 0x52, 0x12,
  0x83, 0x12, 0x58, 0xDE, 0x0E, 0x03, 0x77, 0x76, 0x04, 0xFF, 0xFD, 0x0E, 0x03, 0x77, 0x77, 0x10,
  0x30, 0xDF, 0xFF, 0xA0, 0xB0, 0x17, 0x77, 0x74, 0x08, 0xFF, 0xE0, 0xD0, 0x57, 0x77, 0x77, 0x81,
  0x17, 0xDF, 0xF9, 0x0B, 0x05, 0x80, 0xC4, 0x08, 0x94, 0x25, 0x9B, 0xCD, 0xEF, 0xEE, 0xCA, 0x84,
  0x77, 0x77, 0x40,
  // "Û" (U+00DB)
  0x77, 0x77, 0x48, 0x04, 0x78, 0x0D, 0x40, 0x09, 0xF9, 0x03, 0x80, 0xD2, 0x00, 0x4F, 0xA0, 0x78,
  0x0D, 0x10, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xD1, 0x00, 0xCF, 0xC0, 0x18, 0x0C, 0x70, 0x09, 0xFD,
  0x07, 0x80, 0xC6, 0x00, 0x6E, 0x0B, 0x0D, 0xD0, 0xC8, 0x0C, 0x50, 0x03, 0xE8, 0x1A, 0x04, 0xE0,
  0x28, 0x0C, 0x30, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x98, 0x0C, 0x30, 0x0C, 0xD0, 0x84, 0x01,
  0x0E, 0xC0, 0xE8, 0x0C, 0x20, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x78, 0x0C, 0x00, 0x09, 0xC0, 0xE0,
  0x57, 0x10, 0x9C, 0x0D, 0x77, 0x77, 0x70, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x77, 0x75,
  0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x77, 0x77, 0x50, 0xCA, 0x0D, 0x04, 0x77, 0x01,
  0x0C, 0xA0, 0xD8, 0x0C, 0xD0, 0x00, 0xAF, 0xFF, 0x90, 0x87, 0x30, 0xBF, 0xFC, 0x0D, 0x30, 0xDF,
  0xFF, 0x90, 0x57, 0x30, 0xEF, 0xFC, 0x0B, 0x20, 0x1F, 0xFF, 0xA0, 0x37, 0x20, 0x2F, 0xFD, 0x08,
  0x20, 0x4F, 0xFF, 0xA7, 0x30, 0x5F, 0xFD, 0x05, 0x48, 0x21, 0x25, 0xAF, 0xD8, 0x2E, 0x84, 0x17,
  0x78, 0x21, 0x25, 0xAF, 0xA8, 0x1A, 0x52, 0x74, 0x06, 0xFB, 0x09, 0x77, 0x71, 0x06, 0xE0, 0xD0,
  0x37, 0x71, 0xFA, 0x0B, 0x77, 0x73, 0xD0, 0xE0, 0x27, 0x72, 0x0E, 0xF9, 0x02, 0x77, 0x73, 0x0D,
  0xC0, 0x87, 0x73, 0xF9, 0x0A, 0x77, 0x74, 0xD0, 0x17, 0x72, 0x02, 0xF9, 0x06, 0x77, 0x73, 0x02,
  0xC0, 0xC7, 0x73, 0x05, 0xF9, 0x02, 0x77, 0x73, 0x06, 0xC0, 0x87, 0x73, 0x09, 0xF0, 0xE7, 0x77,
  0x40, 0x9C, 0x05, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x74, 0x0C, 0xC0, 0x17, 0x73, 0xF9, 0x07, 0x77,
  0x74, 0xC0, 0xE7, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x73, 0x03, 0xC0, 0xA7, 0x73, 0x06, 0xF9, 0x01,
  0x77, 0x73, 0x07, 0xC0, 0x77, 0x73, 0x0A, 0xF0, 0xD7, 0x77, 0x40, 0xAC, 0x04, 0x77, 0x30, 0xDF,
  0x09, 0x77, 0x74, 0x0D, 0xC0, 0x17, 0x72, 0x01, 0xF9, 0x06, 0x77, 0x73, 0x01, 0xC0, 0xD7, 0x73,
  0x04, 0xF9, 0x03, 0x77, 0x73, 0x04, 0xC0, 0x97, 0x73, 0x07, 0xF9, 0x77, 0x74, 0x08, 0xC0, 0x67,
  0x73, 0x0B, 0xF0, 0xC7, 0x77, 0x40, 0xBC, 0x03, 0x77, 0x30, 0xEF, 0x08, 0x77, 0x74, 0x0E, 0xC7,
  0x73, 0x02, 0xF9, 0x05, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x73, 0x05, 0xF9, 0x02, 0x77, 0x73, 0x05,
  0xC0, 0x87, 0x73, 0x08, 0xF0, 0xE7, 0x77, 0x40, 0x9C, 0x05, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x74,
  0x0C, 0xC0, 0x27, 0x73, 0xF9, 0x07, 0x77, 0x74, 0xC0, 0xE7, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x73,
  0x03, 0xC0, 0xB7, 0x73, 0x06, 0xF9, 0x01, 0x77, 0x73, 0x07, 0xC0, 0x77, 0x73, 0x09, 0xF0, 0xD7,
  0x77, 0x40, 0xAC, 0x04, 0x77, 0x30, 0xDF, 0x0A, 0x77, 0x74, 0x0D, 0xC0, 0x17, 0x72, 0x01, 0xF9,
  0x06, 0x77, 0x73, 0x01, 0xC0, 0xD7, 0x73, 0x04, 0xF9, 0x03, 0x77, 0x73, 0x04, 0xC0, 0xA7, 0x73,
  0x07, 0xF9, 0x77, 0x74, 0x08, 0xC0, 0x67, 0x73, 0x0A, 0xF0, 0xC7, 0x77, 0x40, 0xBC, 0x03, 0x77,
  0x30, 0xEF, 0x09, 0x77, 0x74, 0x0E, 0xC7, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x73, 0x02, 0xC0, 0xC7,
  0x73, 0x05, 0xF9, 0x02, 0x77, 0x73, 0x05, 0xC0, 0x97, 0x73, 0x08, 0xF0, 0xE7, 0x77, 0x40, 0x9C,
  0x05, 0x77, 0x30, 0xBF, 0x0B, 0x77, 0x74, 0x0C, 0xC0, 0x27, 0x73, 0x0E, 0xF0, 0x87, 0x77, 0x4C,
  0x0E, 0x77, 0x30, 0x2F, 0x90, 0x57, 0x77, 0x30, 0x3C, 0x0B, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x77,
  0x30, 0x6C, 0x07, 0x77, 0x30, 0x8F, 0x0E, 0x77, 0x74, 0x0A, 0xC0, 0x47, 0x73, 0x0A, 0xF0, 0xC7,
  0x77, 0x40, 0xDC, 0x01, 0x77, 0x30, 0xCF, 0x0A, 0x77, 0x73, 0x02, 0xC0, 0xD7, 0x74, 0x0E, 0xF0,
  0x87, 0x77, 0x30, 0x6C, 0x08, 0x77, 0x4F, 0x90, 0x67, 0x77, 0x30, 0xAC, 0x04, 0x77, 0x30, 0x1F,
  0x90, 0x57, 0x77, 0x30, 0xEC, 0x77, 0x5F, 0x90, 0x47, 0x77, 0x20, 0x6C, 0x0A, 0x77, 0x5F, 0x90,
  0x57, 0x77, 0x20, 0xDC, 0x04, 0x77, 0x50, 0xEF, 0x06, 0x77, 0x71, 0x04, 0xC0, 0xC7, 0x76, 0x0C,
  0xF0, 0x97, 0x77, 0x10, 0xCC, 0x06, 0x77, 0x60, 0x8F, 0x0D, 0x77, 0x70, 0x6C, 0x0D, 0x77, 0x70,
  0x4F, 0x90, 0x57, 0x75, 0x03, 0xD0, 0x37, 0x77, 0x10, 0xDF, 0x0D, 0x01, 0x77, 0x30, 0x30, 0xEC,
  0x09, 0x77, 0x72, 0x07, 0xF9, 0x0C, 0x01, 0x77, 0x10, 0x6D, 0x0D, 0x01, 0x77, 0x73, 0x0D, 0xF9,
  0x0E, 0x05, 0x75, 0x03, 0x0B, 0xD0, 0xE0, 0x27, 0x77, 0x40, 0x30, 0xEF, 0xA8, 0x3E, 0x85, 0x21,
  0x28, 0x31, 0x25, 0x8D, 0xE0, 0xE0, 0x37, 0x77, 0x60, 0x4F, 0xFF, 0xD0, 0xE0, 0x37, 0x77, 0x71,
  0x03, 0x0D, 0xFF, 0xFA, 0x0B, 0x01, 0x77, 0x77, 0x40, 0x8F, 0xFE, 0x0D, 0x05, 0x77, 0x77, 0x78,
  0x11, 0x7D, 0xFF, 0x90, 0xB0, 0x58, 0x0C, 0x40, 0x89, 0x42, 0x59, 0xBC, 0xDE, 0xFE, 0xEC, 0xA8,
  0x47, 0x77, 0x74,
  // "Ü" (U+00DC)
  0x77, 0x72, 0x83, 0x5C, 0xFD, 0x77, 0x38, 0x36, 0xDF, 0xD7, 0x80, 0xC0, 0x00, 0x7D, 0x09, 0x71,
  0x08, 0xD0, 0x87, 0x77, 0x76, 0x02, 0xF0, 0x16, 0x02, 0xE0, 0xE7, 0x77, 0x76, 0x07, 0xF0, 0x36,
  0x08, 0xF0, 0x27, 0x77, 0x75, 0x0B, 0xF0, 0x46, 0x0C, 0xF0, 0x37, 0x77, 0x75, 0x0C, 0xF0, 0x36,
  0x0D, 0xF0, 0x27, 0x77, 0x75, 0x0B, 0xF7, 0x0C, 0xF7, 0x77, 0x76, 0x09, 0xE0, 0xB7, 0x0A, 0xE0,
  0xA7, 0x77, 0x76, 0x02, 0xD0, 0xE0, 0x27, 0x03, 0xD0, 0xD0, 0x17, 0x77, 0x77, 0x84, 0x3B, 0xEE,
  0xA1, 0x72, 0x84, 0x4C, 0xFE, 0x91, 0x80, 0xFA, 0x50, 0x0A, 0xFF, 0xF9, 0x08, 0x73, 0x0B, 0xFF,
  0xC0, 0xD3, 0x0D, 0xFF, 0xF9, 0x05, 0x73, 0x0E, 0xFF, 0xC0, 0xB2, 0x01, 0xFF, 0xFA, 0x03, 0x72,
  0x02, 0xFF, 0xD0, 0x82, 0x04, 0xFF, 0xFA, 0x73, 0x05, 0xFF, 0xD0, 0x54, 0x82, 0x12, 0x5A, 0xFD,
  0x82, 0xE8, 0x41, 0x77, 0x82, 0x12, 0x5A, 0xFA, 0x81, 0xA5, 0x27, 0x40, 0x6F, 0xB0, 0x97, 0x77,
  0x10, 0x6E, 0x0D, 0x03, 0x77, 0x1F, 0xA0, 0xB7, 0x77, 0x3D, 0x0E, 0x02, 0x77, 0x20, 0xEF, 0x90,
  0x27, 0x77, 0x30, 0xDC, 0x08, 0x77, 0x3F, 0x90, 0xA7, 0x77, 0x4D, 0x01, 0x77, 0x20, 0x2F, 0x90,
  0x67, 0x77, 0x30, 0x2C, 0x0C, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x77, 0x30, 0x6C, 0x08, 0x77, 0x30,
  0x9F, 0x0E, 0x77, 0x74, 0x09, 0xC0, 0x57, 0x73, 0x0C, 0xF0, 0xB7, 0x77, 0x40, 0xCC, 0x01, 0x77,
  0x3F, 0x90, 0x77, 0x77, 0x4C, 0x0E, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x77, 0x30, 0x3C, 0x0A, 0x77,
  0x30, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x30, 0xAF, 0x0D, 0x77, 0x74, 0x0A, 0xC0,
  0x47, 0x73, 0x0D, 0xF0, 0x97, 0x77, 0x40, 0xDC, 0x01, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x77, 0x30,
  0x1C, 0x0D, 0x77, 0x30, 0x4F, 0x90, 0x37, 0x77, 0x30, 0x4C, 0x09, 0x77, 0x30, 0x7F, 0x97, 0x77,
  0x40, 0x8C, 0x06, 0x77, 0x30, 0xBF, 0x0C, 0x77, 0x74, 0x0B, 0xC0, 0x37, 0x73, 0x0E, 0xF0, 0x87,
  0x77, 0x40, 0xEC, 0x77, 0x30, 0x2F, 0x90, 0x57, 0x77, 0x30, 0x2C, 0x0C, 0x77, 0x30, 0x5F, 0x90,
  0x27, 0x77, 0x30, 0x5C, 0x08, 0x77, 0x30, 0x8F, 0x0E, 0x77, 0x74, 0x09, 0xC0, 0x57, 0x73, 0x0C,
  0xF0, 0xB7, 0x77, 0x40, 0xCC, 0x02, 0x77, 0x3F, 0x90, 0x77, 0x77, 0x4C, 0x0E, 0x77, 0x30, 0x3F,
  0x90, 0x47, 0x77, 0x30, 0x3C, 0x0B, 0x77, 0x30, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x7C, 0x07, 0x77,
  0x30, 0x9F, 0x0D, 0x77, 0x74, 0x0A, 0xC0, 0x47, 0x73, 0x0D, 0xF0, 0xA7, 0x77, 0x40, 0xDC, 0x01,
  0x77, 0x20, 0x1F, 0x90, 0x67, 0x77, 0x30, 0x1C, 0x0D, 0x77, 0x30, 0x4F, 0x90, 0x37, 0x77, 0x30,
  0x4C, 0x0A, 0x77, 0x30, 0x7F, 0x97, 0x77, 0x40, 0x8C, 0x06, 0x77, 0x30, 0xAF, 0x0C, 0x77, 0x74,
  0x0B, 0xC0, 0x37, 0x73, 0x0E, 0xF0, 0x97, 0x77, 0x40, 0xEC, 0x77, 0x30, 0x2F, 0x90, 0x57, 0x77,
  0x30, 0x2C, 0x0C, 0x77, 0x30, 0x5F, 0x90, 0x27, 0x77, 0x30, 0x5C, 0x09, 0x77, 0x30, 0x8F, 0x0E,
  0x77, 0x74, 0x09, 0xC0, 0x57, 0x73, 0x0B, 0xF0, 0xB7, 0x77, 0x40, 0xCC, 0x02, 0x77, 0x30, 0xEF,
  0x08, 0x77, 0x74, 0xC0, 0xE7, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x73, 0x03, 0xC0, 0xB7, 0x73, 0x05,
  0xF9, 0x02, 0x77, 0x73, 0x06, 0xC0, 0x77, 0x73, 0x08, 0xF0, 0xE7, 0x77, 0x40, 0xAC, 0x04, 0x77,
  0x30, 0xAF, 0x0C, 0x77, 0x74, 0x0D, 0xC0, 0x17, 0x73, 0x0C, 0xF0, 0xA7, 0x77, 0x30, 0x2C, 0x0D,
  0x77, 0x40, 0xEF, 0x08, 0x77, 0x73, 0x06, 0xC0, 0x87, 0x74, 0xF9, 0x06, 0x77, 0x73, 0x0A, 0xC0,
  0x47, 0x73, 0x01, 0xF9, 0x05, 0x77, 0x73, 0x0E, 0xC7, 0x75, 0xF9, 0x04, 0x77, 0x72, 0x06, 0xC0,
  0xA7, 0x75, 0xF9, 0x05, 0x77, 0x72, 0x0D, 0xC0, 0x47, 0x75, 0x0E, 0xF0, 0x67, 0x77, 0x10, 0x4C,
  0x0C, 0x77, 0x60, 0xCF, 0x09, 0x77, 0x71, 0x0C, 0xC0, 0x67, 0x76, 0x08, 0xF0, 0xD7, 0x77, 0x06,
  0xC0, 0xD7, 0x77, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x3D, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD0, 0x17,
  0x73, 0x03, 0x0E, 0xC0, 0x97, 0x77, 0x20, 0x7F, 0x90, 0xC0, 0x17, 0x71, 0x06, 0xD0, 0xD0, 0x17,
  0x77, 0x30, 0xDF, 0x90, 0xE0, 0x57, 0x50, 0x30, 0xBD, 0x0E, 0x02, 0x77, 0x74, 0x03, 0x0E, 0xFA,
  0x83, 0xE8, 0x52, 0x12, 0x83, 0x12, 0x58, 0xDE, 0x0E, 0x03, 0x77, 0x76, 0x04, 0xFF, 0xFD, 0x0E,
  0x03, 0x77, 0x77, 0x10, 0x30, 0xDF, 0xFF, 0xA0, 0xB0, 0x17, 0x77, 0x74, 0x08, 0xFF, 0xE0, 0xD0,
  0x57, 0x77, 0x77, 0x81, 0x17, 0xDF, 0xF9, 0x0B, 0x05, 0x80, 0xC4, 0x08, 0x94, 0x25, 0x9B, 0xCD,
  0xEF, 0xEE, 0xCA, 0x84, 0x77, 0x77, 0x40,
  // "Ý" (U+00DD)
  0x77, 0x77, 0x58, 0x05, 0x70, 0x18, 0x0C, 0x50, 0x06, 0xF9, 0x0D, 0x80, 0xC6, 0x00, 0xEF, 0x0E,
  0x02, 0x80, 0xC5, 0x00, 0x8F, 0x90, 0x48, 0x0C, 0x50, 0x02, 0xF9, 0x05, 0x80, 0xC6, 0x00, 0xCF,
  0x06, 0x80, 0xC6, 0x00, 0x6F, 0x07, 0x80, 0xC6, 0x00, 0x10, 0xEE, 0x07, 0x80, 0xC7, 0x00, 0xBE,
  0x07, 0x80, 0xC7, 0x00, 0x7E, 0x06, 0x80, 0xC7, 0x00, 0x2E, 0x05, 0x80, 0xD0, 0x00, 0xDC, 0x0E,
  0x03, 0x80, 0xD0, 0x00, 0xAC, 0x0C, 0x02, 0x80, 0xD0, 0x00, 0x6C, 0x0A, 0x80, 0xD2, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xCB, 0x00, 0x05, 0xFF, 0xF0, 0x27, 0x10, 0xEF, 0xFC, 0x81, 0x40, 0x8F, 0xFE,
  0x0E, 0x71, 0x02, 0xFF, 0xD8, 0x11, 0x0C, 0xFF, 0xE0, 0xB7, 0x10, 0x6F, 0xFC, 0x0D, 0x20, 0xEF,
  0xFE, 0x08, 0x71, 0x09, 0xFF, 0xC0, 0xA4, 0x03, 0x0B, 0xFC, 0x08, 0x02, 0x77, 0x38, 0x11, 0x5D,
  0xF9, 0x81, 0xE6, 0x17, 0x10, 0xDF, 0xA0, 0x97, 0x77, 0x04, 0xF0, 0xD0, 0x27, 0x30, 0x7F, 0xA0,
  0x57, 0x77, 0x02, 0xE0, 0xE0, 0x27, 0x40, 0x1F, 0xA0, 0x57, 0x77, 0x04, 0xE0, 0x57, 0x60, 0xBF,
  0x90, 0x67, 0x77, 0x08, 0xD0, 0x97, 0x70, 0x7F, 0x90, 0x97, 0x77, 0x0E, 0xC0, 0xD7, 0x71, 0x02,
  0xF9, 0x0C, 0x77, 0x60, 0x7D, 0x03, 0x77, 0x20, 0xEF, 0x97, 0x75, 0x01, 0x0E, 0xC0, 0x87, 0x73,
  0x09, 0xF9, 0x04, 0x77, 0x40, 0xAC, 0x0C, 0x77, 0x40, 0x5F, 0x90, 0x77, 0x73, 0x04, 0xC0, 0xE0,
  0x27, 0x74, 0x01, 0xF9, 0x0B, 0x77, 0x20, 0x10, 0xEC, 0x06, 0x77, 0x60, 0xCF, 0x97, 0x72, 0x0A,
  0xC0, 0xA7, 0x77, 0x08, 0xF9, 0x03, 0x77, 0x05, 0xC0, 0xD0, 0x17, 0x77, 0x03, 0xF9, 0x07, 0x76,
  0x01, 0x0E, 0xC0, 0x47, 0x77, 0x20, 0xEF, 0x0B, 0x76, 0x0B, 0xC0, 0x87, 0x77, 0x30, 0xAF, 0x97,
  0x50, 0x6C, 0x0C, 0x77, 0x74, 0x06, 0xF9, 0x04, 0x73, 0x02, 0xD0, 0x27, 0x77, 0x40, 0x1F, 0x90,
  0x87, 0x30, 0xCC, 0x06, 0x77, 0x76, 0x0D, 0xF0, 0xD7, 0x20, 0x8C, 0x0B, 0x77, 0x77, 0x08, 0xF9,
  0x02, 0x70, 0x3C, 0x0E, 0x01, 0x77, 0x77, 0x04, 0xF9, 0x06, 0x70, 0xDC, 0x04, 0x77, 0x77, 0x2F,
  0x90, 0xA6, 0x08, 0xC0, 0x97, 0x77, 0x73, 0x0B, 0xF0, 0xD5, 0x03, 0xC0, 0xD7, 0x77, 0x74, 0x07,
  0xF9, 0x01, 0x40, 0xDC, 0x03, 0x77, 0x77, 0x40, 0x2F, 0x90, 0x43, 0x08, 0xC0, 0x77, 0x77, 0x76,
  0x0D, 0xF0, 0x72, 0x03, 0xC0, 0xB7, 0x77, 0x77, 0x09, 0xF0, 0xA2, 0x0C, 0xB0, 0xE0, 0x17, 0x77,
  0x77, 0x05, 0xF8, 0x1D, 0x07, 0xC0, 0x58, 0x0C, 0x00, 0x01, 0xF0, 0xE0, 0x2C, 0x09, 0x80, 0xC2,
  0x00, 0xCF, 0x0B, 0xB0, 0xD8, 0x0C, 0x30, 0x07, 0xFC, 0x03, 0x80, 0xC3, 0x00, 0x3F, 0xB0, 0x78,
  0x0C, 0x50, 0x0E, 0xF9, 0x0C, 0x80, 0xC6, 0x00, 0xBF, 0x90, 0x28, 0x0C, 0x60, 0x0D, 0xF0, 0xC8,
  0x0C, 0x60, 0x01, 0xF9, 0x09, 0x80, 0xC6, 0x00, 0x4F, 0x90, 0x58, 0x0C, 0x60, 0x07, 0xF9, 0x02,
  0x80, 0xC6, 0x00, 0xAF, 0x0E, 0x80, 0xC7, 0x00, 0xDF, 0x0B, 0x80, 0xC6, 0x00, 0x1F, 0x90, 0x88,
  0x0C, 0x60, 0x04, 0xF9, 0x04, 0x80, 0xC6, 0x00, 0x7F, 0x90, 0x18, 0x0C, 0x60, 0x0A, 0xF0, 0xD8,
  0x0C, 0x70, 0x0D, 0xF0, 0xA8, 0x0C, 0x60, 0x01, 0xF9, 0x07, 0x80, 0xC6, 0x00, 0x4F, 0x90, 0x38,
  0x0C, 0x60, 0x07, 0xF9, 0x80, 0xC7, 0x00, 0xAF, 0x0C, 0x80, 0xC7, 0x00, 0xEF, 0x09, 0x80, 0xC6,
  0x00, 0x2F, 0x90, 0x68, 0x0C, 0x60, 0x06, 0xF9, 0x03, 0x80, 0xC6, 0x00, 0xCF, 0x90, 0x18, 0x0C,
  0x50, 0x05, 0xFA, 0x03, 0x80, 0xC4, 0x00, 0x40, 0xEF, 0xA0, 0x98, 0x0C, 0x00, 0x82, 0x13, 0x7C,
  0xFD, 0x82, 0xB5, 0x21, 0x77, 0x77, 0x10, 0x8F, 0xFF, 0xB0, 0x47, 0x77, 0x50, 0xBF, 0xFF, 0xB0,
  0x17, 0x77, 0x50, 0xEF, 0xFF, 0xA0, 0xD7, 0x77, 0x50, 0x2F, 0xFF, 0xB0, 0xA7, 0x77, 0x50,
  // "Þ" (U+00DE)
  0x76, 0x03, 0xFF, 0xFA, 0x0B, 0x77, 0x74, 0x06, 0xFF, 0xFA, 0x07, 0x77, 0x74, 0x09, 0xFF, 0xFA,
  0x04, 0x77, 0x74, 0x0D, 0xFF, 0xFA, 0x01, 0x77, 0x76, 0x82, 0x13, 0x7D, 0xFD, 0x81, 0xA5, 0x27,
  0x77, 0x77, 0x0D, 0xFA, 0x0C, 0x02, 0x80, 0xC2, 0x00, 0x7F, 0x90, 0xE0, 0x18, 0x0C, 0x30, 0x05,
  0xF9, 0x07, 0x80, 0xC4, 0x00, 0x7F, 0x90, 0x18, 0x0C, 0x40, 0x0A, 0xF0, 0xC8, 0x0C, 0x50, 0x0D,
  0xF0, 0x98, 0x0C, 0x40, 0x01, 0xFF, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x77, 0x10, 0x4F, 0xFE, 0x0B,
  0x05, 0x77, 0x76, 0x08, 0xFF, 0xF9, 0x0D, 0x04, 0x77, 0x74, 0x0B, 0xFF, 0xFB, 0x09, 0x77, 0x73,
  0x0E, 0xF8, 0x6A, 0x66, 0x67, 0x8A, 0xEF, 0xB0, 0xB7, 0x77, 0x10, 0x2F, 0x90, 0x37, 0x04, 0x0B,
  0xFA, 0x0B, 0x77, 0x70, 0x5F, 0x97, 0x30, 0x6F, 0xA0, 0x77, 0x76, 0x09, 0xF0, 0xC7, 0x40, 0x5F,
  0xA0, 0x27, 0x75, 0x0C, 0xF0, 0x97, 0x50, 0x8F, 0x90, 0x97, 0x75, 0xF9, 0x06, 0x75, 0x01, 0xFA,
  0x01, 0x77, 0x30, 0x3F, 0x90, 0x37, 0x60, 0x9F, 0x90, 0x67, 0x73, 0x06, 0xF0, 0xE7, 0x70, 0x5F,
  0x90, 0xA7, 0x73, 0x0A, 0xF0, 0xB7, 0x70, 0x2F, 0x90, 0xD7, 0x73, 0x0D, 0xF0, 0x87, 0x71, 0x0E,
  0xF9, 0x77, 0x20, 0x1F, 0x90, 0x57, 0x71, 0x0D, 0xF9, 0x02, 0x77, 0x10, 0x4F, 0x90, 0x27, 0x71,
  0x0C, 0xF9, 0x03, 0x77, 0x10, 0x7F, 0x0E, 0x77, 0x20, 0xBF, 0x90, 0x37, 0x71, 0x0B, 0xF0, 0xB7,
  0x72, 0x0C, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x07, 0x77, 0x20, 0xCF, 0x90, 0x27, 0x70, 0x2F, 0x90,
  0x47, 0x72, 0x0D, 0xF9, 0x77, 0x10, 0x5F, 0x90, 0x17, 0x72, 0xF9, 0x0E, 0x77, 0x10, 0x9F, 0x0D,
  0x77, 0x20, 0x2F, 0x90, 0xC7, 0x71, 0x0C, 0xF0, 0xA7, 0x72, 0x05, 0xF9, 0x09, 0x77, 0x1F, 0x90,
  0x67, 0x72, 0x08, 0xF9, 0x06, 0x77, 0x03, 0xF9, 0x03, 0x77, 0x20, 0xDF, 0x90, 0x27, 0x70, 0x6F,
  0x97, 0x72, 0x02, 0xF9, 0x0D, 0x77, 0x10, 0xAF, 0x0C, 0x77, 0x20, 0x8F, 0x90, 0x77, 0x71, 0x0D,
  0xF0, 0x97, 0x71, 0x01, 0x0E, 0xF9, 0x01, 0x77, 0x01, 0xF9, 0x05, 0x77, 0x10, 0x9F, 0x90, 0x97,
  0x71, 0x04, 0xF9, 0x02, 0x77, 0x04, 0xF9, 0x0E, 0x01, 0x77, 0x10, 0x7F, 0x0E, 0x77, 0x02, 0x0E,
  0xF9, 0x07, 0x77, 0x20, 0xBF, 0x0B, 0x76, 0x03, 0x0D, 0xF9, 0x0B, 0x77, 0x30, 0xEF, 0x08, 0x75,
  0x06, 0xFA, 0x0D, 0x01, 0x77, 0x20, 0x2F, 0x90, 0x47, 0x30, 0x50, 0xCF, 0xA0, 0xD0, 0x17, 0x73,
  0x05, 0xF9, 0x01, 0x48, 0x41, 0x24, 0x6A, 0xEF, 0xB0, 0xB0, 0x17, 0x74, 0x08, 0xFF, 0xFE, 0x0E,
  0x06, 0x77, 0x60, 0xCF, 0xFF, 0xD0, 0x90, 0x17, 0x77, 0xFF, 0xFB, 0x81, 0xD8, 0x27, 0x77, 0x10,
  0x3F, 0xFE, 0x82, 0xDA, 0x73, 0x77, 0x74, 0x06, 0xF9, 0x80, 0x26, 0x83, 0x55, 0x44, 0x27, 0x77,
  0x72, 0x0A, 0xF0, 0xD8, 0x0C, 0x50, 0x0D, 0xF0, 0xA8, 0x0C, 0x40, 0x01, 0xF9, 0x06, 0x80, 0xC4,
  0x00, 0x5F, 0x90, 0x38, 0x0C, 0x40, 0x0A, 0xF9, 0x01, 0x80, 0xC3, 0x00, 0x1F, 0x90, 0xE8, 0x0C,
  0x40, 0x0A, 0xFA, 0x80, 0xC3, 0x00, 0x8F, 0xB0, 0x67, 0x77, 0x76, 0x82, 0x13, 0x8D, 0xFD, 0x81,
  0x94, 0x17, 0x77, 0x71, 0x0E, 0xFF, 0xF9, 0x0E, 0x77, 0x74, 0x01, 0xFF, 0xFA, 0x0B, 0x77, 0x74,
  0x05, 0xFF, 0xFA, 0x08, 0x77, 0x74, 0x08, 0xFF, 0xFA, 0x05, 0x77, 0x74,
  // "ß" (U+00DF)
  0x80, 0xC4, 0x08, 0x93, 0x26, 0x9B, 0xDE, 0xFE, 0xDC, 0xA7, 0x38, 0x0D, 0x10, 0x81, 0x28, 0xDF,
  0xE8, 0x1E, 0x71, 0x80, 0xC4, 0x00, 0x20, 0xAF, 0xFC, 0x0E, 0x03, 0x80, 0xC2, 0x00, 0x60, 0xEF,
  0xFF, 0x06, 0x80, 0xC0, 0x00, 0x9F, 0xA8, 0x5C, 0x87, 0x67, 0xAE, 0xF9, 0x03, 0x77, 0x77, 0x60,
  0xBF, 0x90, 0x80, 0x17, 0x07, 0xF0, 0xE7, 0x77, 0x75, 0x09, 0xF0, 0xD0, 0x27, 0x30, 0x5F, 0x07,
  0x77, 0x77, 0x30, 0x7F, 0x0C, 0x01, 0x75, 0x09, 0xE0, 0xE7, 0x77, 0x72, 0x02, 0xF0, 0xE0, 0x27,
  0x60, 0x2F, 0x03, 0x77, 0x77, 0x10, 0xBF, 0x06, 0x77, 0x10, 0xDE, 0x08, 0x77, 0x77, 0x03, 0xF0,
  0xC7, 0x72, 0x09, 0xE0, 0xA7, 0x77, 0x70, 0xBF, 0x05, 0x77, 0x20, 0x8E, 0x0C, 0x77, 0x76, 0x01,
  0xF0, 0xE7, 0x73, 0x08, 0xE0, 0xD7, 0x77, 0x60, 0x7F, 0x08, 0x77, 0x30, 0x9E, 0x0D, 0x77, 0x76,
  0x0C, 0xF0, 0x37, 0x73, 0x0B, 0xE0, 0xC7, 0x77, 0x50, 0x1F, 0x97, 0x74, 0x0D, 0xE0, 0xB7, 0x77,
  0x50, 0x5F, 0x0B, 0x77, 0x4F, 0x09, 0x77, 0x75, 0x09, 0xF0, 0x87, 0x73, 0x03, 0xF0, 0x87, 0x77,
  0x50, 0xDF, 0x04, 0x77, 0x30, 0x6F, 0x05, 0x77, 0x74, 0x01, 0xF9, 0x01, 0x74, 0x84, 0x25, 0x9C,
  0xDE, 0xF9, 0x03, 0x77, 0x50, 0x8F, 0xE0, 0xD7, 0x30, 0x50, 0xCF, 0xF7, 0x76, 0x0C, 0xFE, 0x0A,
  0x71, 0x03, 0x0D, 0xFF, 0x90, 0xD7, 0x76, 0xFF, 0x06, 0x70, 0x7F, 0xFB, 0x09, 0x77, 0x50, 0x4F,
  0xF0, 0x36, 0x08, 0xFA, 0x81, 0xC9, 0x78, 0x02, 0x60, 0x37, 0x75, 0x02, 0x80, 0x16, 0x09, 0xF9,
  0x60, 0x6F, 0x81, 0xE7, 0x17, 0x77, 0x77, 0x08, 0xF0, 0xC5, 0x02, 0xF0, 0xD0, 0x28, 0x0C, 0x10,
  0x0B, 0xF0, 0x85, 0x0A, 0xE0, 0xE0, 0x28, 0x0C, 0x20, 0x0E, 0xF0, 0x54, 0x01, 0xF0, 0x68, 0x0C,
  0x20, 0x02, 0xF9, 0x02, 0x40, 0x7E, 0x0E, 0x80, 0xC3, 0x00, 0x6F, 0x0E, 0x50, 0xBE, 0x0A, 0x80,
  0xC3, 0x00, 0x9F, 0x0B, 0x50, 0xEE, 0x07, 0x80, 0xC3, 0x00, 0xCF, 0x07, 0x5F, 0x06, 0x80, 0xC3,
  0x0F, 0x90, 0x44, 0x01, 0xF0, 0x78, 0x0C, 0x20, 0x03, 0xF9, 0x01, 0x40, 0x2F, 0x09, 0x80, 0xC2,
  0x00, 0x6F, 0x0D, 0x50, 0x1F, 0x0E, 0x80, 0xC2, 0x00, 0xAF, 0x09, 0x6F, 0x90, 0x68, 0x0C, 0x10,
  0x0D, 0xF0, 0x66, 0x0D, 0xF0, 0xE0, 0x27, 0x77, 0x77, 0x01, 0xF9, 0x03, 0x60, 0x9F, 0x90, 0xD0,
  0x17, 0x77, 0x76, 0x04, 0xF9, 0x70, 0x3F, 0xA0, 0xD0, 0x17, 0x77, 0x75, 0x07, 0xF0, 0xB7, 0x10,
  0xBF, 0xA0, 0xD0, 0x37, 0x77, 0x74, 0x0A, 0xF0, 0x87, 0x10, 0x20, 0xEF, 0xB0, 0x57, 0x77, 0x73,
  0x0E, 0xF0, 0x57, 0x20, 0x4F, 0xC0, 0x77, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x73, 0x06, 0xFC, 0x08,
  0x77, 0x77, 0x05, 0xF0, 0xE7, 0x50, 0x6F, 0xC0, 0x77, 0x77, 0x60, 0x8F, 0x0A, 0x76, 0x06, 0xFC,
  0x05, 0x77, 0x75, 0x0B, 0xF0, 0x77, 0x70, 0x40, 0xEF, 0xA0, 0xE0, 0x17, 0x77, 0x40, 0xEF, 0x04,
  0x77, 0x10, 0x30, 0xEF, 0xA0, 0xA7, 0x77, 0x30, 0x2F, 0x97, 0x73, 0x02, 0x0D, 0xFA, 0x02, 0x77,
  0x72, 0x06, 0xF0, 0xC7, 0x74, 0x02, 0x0E, 0xF9, 0x08, 0x77, 0x72, 0x09, 0xF0, 0x97, 0x75, 0x04,
  0xF9, 0x0D, 0x77, 0x72, 0x0C, 0xF0, 0x67, 0x76, 0x0A, 0xF9, 0x01, 0x77, 0x71, 0xF9, 0x02, 0x77,
  0x60, 0x3F, 0x90, 0x47, 0x77, 0x03, 0xF0, 0xE7, 0x77, 0x10, 0xDF, 0x05, 0x77, 0x70, 0x6F, 0x0B,
  0x77, 0x71, 0x08, 0xF0, 0x67, 0x77, 0x0A, 0xF0, 0x86, 0x82, 0x5A, 0xD4, 0x75, 0x06, 0xF0, 0x67,
  0x77, 0x0D, 0xF0, 0x44, 0x01, 0x0C, 0xB0, 0x57, 0x50, 0x4F, 0x05, 0x77, 0x60, 0x1F, 0x90, 0x14,
  0x0C, 0xC0, 0x67, 0x50, 0x5F, 0x03, 0x77, 0x60, 0x4F, 0x0D, 0x40, 0x5D, 0x08, 0x75, 0x06, 0xF0,
  0x17, 0x76, 0x07, 0xF0, 0xA4, 0x09, 0xD0, 0xA7, 0x50, 0x8E, 0x0D, 0x77, 0x70, 0xBF, 0x07, 0x40,
  0xBD, 0x0D, 0x75, 0x0C, 0xE0, 0x97, 0x77, 0x0E, 0xF0, 0x34, 0x0C, 0xE0, 0x27, 0x30, 0x3F, 0x03,
  0x77, 0x60, 0x1F, 0x95, 0x0B, 0xE0, 0x87, 0x30, 0xBE, 0x0B, 0x77, 0x70, 0x5F, 0x0C, 0x50, 0x7F,
  0x03, 0x71, 0x08, 0xF0, 0x37, 0x77, 0x08, 0xF0, 0x95, 0x02, 0xF0, 0xD0, 0x25, 0x01, 0x0A, 0xF0,
  0x77, 0x77, 0x10, 0xBF, 0x05, 0x60, 0xAF, 0x98, 0x3B, 0x76, 0x7B, 0xF9, 0x09, 0x77, 0x72, 0x0E,
  0xF0, 0x26, 0x01, 0x0D, 0xFF, 0xD0, 0x97, 0x77, 0x20, 0x2F, 0x0E, 0x71, 0x01, 0x0C, 0xFF, 0xA0,
  0xE0, 0x57, 0x77, 0x30, 0x6F, 0x0B, 0x73, 0x06, 0x0D, 0xFD, 0x0D, 0x07, 0x77, 0x75, 0x09, 0xF0,
  0x77, 0x58, 0x34, 0x8B, 0xDE, 0xA8, 0x3E, 0xCA, 0x73, 0x77, 0x77, 0x0C, 0xF0, 0x48, 0x0E, 0x00,
  0xF9, 0x80, 0xE0, 0x00, 0x4F, 0x0C, 0x80, 0xE0, 0x00, 0x7F, 0x08, 0x80, 0xE0, 0x00, 0xBF, 0x04,
  0x80, 0xE0, 0x0F, 0x0E, 0x80, 0xE0, 0x00, 0x5F, 0x0A, 0x80, 0xE0, 0x00, 0x9F, 0x05, 0x80, 0xE0,
  0x00, 0xEE, 0x0E, 0x80, 0xE0, 0x00, 0x5F, 0x08, 0x80, 0xE0, 0x00, 0xBF, 0x02, 0x80, 0xD7, 0x00,
  0x3F, 0x09, 0x80, 0xE0, 0x00, 0xBF, 0x01, 0x80, 0xD7, 0x00, 0x6F, 0x07, 0x80, 0xD7, 0x00, 0x3F,
  0x0C, 0x80, 0xD7, 0x00, 0x6F, 0x0E, 0x01, 0x80, 0xD0, 0x08, 0x56, 0xB8, 0x77, 0x9E, 0xF0, 0xE0,
  0x38, 0x0D, 0x10, 0x0A, 0xFD, 0x0E, 0x03, 0x80, 0xD2, 0x00, 0xDF, 0xC0, 0xA0, 0x18, 0x0D, 0x20,
  0x01, 0xFB, 0x0B, 0x04, 0x80, 0xD5, 0x08, 0x90, 0x6A, 0xDE, 0xFE, 0xDA, 0x62, 0x80, 0xD6, 0x00,
  // "à" (U+00E0)
  0x77, 0x20, 0x68, 0x03, 0x70, 0x47, 0x77, 0x75, 0x0E, 0xF0, 0xC7, 0x77, 0x75, 0x06, 0xF9, 0x02,
  0x77, 0x77, 0x50, 0xCF, 0x07, 0x77, 0x77, 0x50, 0x2F, 0x0C, 0x77, 0x77, 0x60, 0x7F, 0x02, 0x77,
  0x77, 0x60, 0xCE, 0x08, 0x77, 0x77, 0x60, 0x10, 0xED, 0x0E, 0x77, 0x77, 0x70, 0x5E, 0x05, 0x77,
  0x77, 0x70, 0x8D, 0x0B, 0x80, 0xC0, 0x00, 0xBD, 0x01, 0x77, 0x77, 0x70, 0x10, 0xDC, 0x07, 0x80,
  0xC0, 0x00, 0x30, 0xEB, 0x0D, 0x80, 0xC1, 0x00, 0x4C, 0x04, 0x80, 0xC1, 0x00, 0x6B, 0x04, 0x80,
  0xBD, 0x50, 0x89, 0x11, 0x69, 0xCE, 0xFE, 0xDB, 0x84, 0x77, 0x77, 0x10, 0x30, 0xBF, 0xC0, 0xD0,
  0x64, 0x01, 0x0B, 0xA0, 0x77, 0x72, 0x01, 0x0A, 0xFF, 0x98, 0x3D, 0x20, 0x6E, 0xB0, 0x37, 0x71,
  0x05, 0x0E, 0xFF, 0xB0, 0xE0, 0xBD, 0x77, 0x10, 0x8F, 0x98, 0x4E, 0x97, 0x68, 0xCF, 0xC0, 0xC7,
  0x70, 0xAF, 0x0D, 0x05, 0x60, 0x30, 0xDF, 0xA0, 0x97, 0x60, 0xAF, 0x0B, 0x01, 0x71, 0x01, 0x0D,
  0xF9, 0x06, 0x75, 0x08, 0xF0, 0xA7, 0x40, 0x5F, 0x90, 0x37, 0x40, 0x5F, 0x0B, 0x75, 0x02, 0xF9,
  0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x60, 0x5F, 0x0C, 0x74, 0x0B, 0xF0, 0x37, 0x60, 0x9F, 0x08, 0x73,
  0x07, 0xF0, 0x97, 0x70, 0xCF, 0x05, 0x72, 0x01, 0xF0, 0xE0, 0x17, 0x7F, 0x90, 0x27, 0x20, 0x9F,
  0x08, 0x77, 0x03, 0xF0, 0xE7, 0x20, 0x2F, 0x0E, 0x01, 0x77, 0x06, 0xF0, 0xB7, 0x20, 0xAF, 0x08,
  0x77, 0x10, 0x9F, 0x08, 0x71, 0x02, 0xF9, 0x02, 0x77, 0x10, 0xCF, 0x04, 0x71, 0x09, 0xF0, 0xB7,
  0x72, 0xF9, 0x01, 0x71, 0x0E, 0xF0, 0x57, 0x71, 0x03, 0xF0, 0xD7, 0x10, 0x5F, 0x0E, 0x77, 0x20,
  0x6F, 0x0A, 0x71, 0x0B, 0xF0, 0xA7, 0x72, 0x0A, 0xF0, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x20, 0xDF,
  0x04, 0x70, 0x6F, 0x90, 0x27, 0x71, 0x01, 0xF9, 0x71, 0x0A, 0xF0, 0xD7, 0x72, 0x04, 0xF0, 0xD7,
  0x10, 0xEF, 0x09, 0x77, 0x20, 0x7F, 0x09, 0x70, 0x3F, 0x90, 0x67, 0x72, 0x0B, 0xF0, 0x67, 0x07,
  0xF9, 0x02, 0x77, 0x2F, 0x90, 0x37, 0x0A, 0xF0, 0xE7, 0x72, 0x04, 0xF9, 0x71, 0x0D, 0xF0, 0xC7,
  0x72, 0x09, 0xF0, 0xC7, 0x1F, 0x90, 0xA7, 0x72, 0x0E, 0xF0, 0x97, 0x01, 0xF9, 0x08, 0x77, 0x10,
  0x5F, 0x90, 0x67, 0x03, 0xF9, 0x05, 0x77, 0x10, 0xBF, 0x90, 0x37, 0x04, 0xF9, 0x04, 0x77, 0x02,
  0xFA, 0x71, 0x05, 0xF9, 0x03, 0x77, 0x09, 0xF9, 0x0D, 0x71, 0x06, 0xF9, 0x03, 0x76, 0x01, 0xFA,
  0x0A, 0x71, 0x05, 0xF9, 0x02, 0x76, 0x08, 0xFA, 0x08, 0x71, 0x05, 0xF9, 0x03, 0x75, 0x02, 0xA0,
  0xDF, 0x05, 0x71, 0x04, 0xF9, 0x03, 0x75, 0x82, 0xBF, 0xD7, 0xF0, 0x37, 0x10, 0x2F, 0x90, 0x57,
  0x40, 0x5A, 0x06, 0x0A, 0xF0, 0x17, 0x2F, 0x90, 0x77, 0x38, 0x41, 0xEF, 0xD0, 0xCF, 0x73, 0x0D,
  0xF0, 0xA7, 0x30, 0xBA, 0x81, 0x40, 0xEE, 0x0E, 0x73, 0x09, 0xF0, 0xE7, 0x20, 0x9A, 0x0B, 0x2F,
  0x0E, 0x73, 0x05, 0xF9, 0x05, 0x70, 0x8A, 0x82, 0xE2, 0x01, 0xF9, 0x70, 0x13, 0x0E, 0xF0, 0xD0,
  0x15, 0x0A, 0xB0, 0x52, 0x01, 0xF9, 0x05, 0x58, 0x18, 0xE1, 0x20, 0x8F, 0x98, 0x4D, 0x40, 0x16,
  0xDB, 0x09, 0x4F, 0x98, 0x4D, 0x30, 0x27, 0xEA, 0x09, 0x20, 0x1F, 0xFA, 0x0A, 0x50, 0xCF, 0xF9,
  0x0C, 0x30, 0x7F, 0xF0, 0xB6, 0x06, 0xFF, 0x08, 0x50, 0xAF, 0xD0, 0x87, 0x10, 0xDF, 0xC0, 0xB0,
  0x27, 0x08, 0xFA, 0x0C, 0x03, 0x72, 0x02, 0x0D, 0xF9, 0x0C, 0x04, 0x73, 0x87, 0x28, 0xCE, 0xFD,
  0xC8, 0x37, 0x68, 0x67, 0xCE, 0xFE, 0xB8, 0x36,
  // "á" (U+00E1)
  0x77, 0x77, 0x38, 0x05, 0x70, 0x17, 0x77, 0x73, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x40, 0xEF, 0x0E,
  0x02, 0x77, 0x77, 0x30, 0x8F, 0x90, 0x47, 0x77, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x77, 0x40, 0xCF,
  0x06, 0x77, 0x77, 0x40, 0x6F, 0x07, 0x77, 0x77, 0x40, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x50, 0xBE,
  0x07, 0x77, 0x77, 0x50, 0x7E, 0x06, 0x77, 0x77, 0x50, 0x2E, 0x05, 0x77, 0x77, 0x60, 0xDC, 0x0E,
  0x03, 0x77, 0x77, 0x60, 0xAC, 0x0C, 0x02, 0x77, 0x77, 0x60, 0x6C, 0x0A, 0x80, 0xC0, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xBE, 0x00, 0x89, 0x11, 0x69, 0xCE, 0xFE, 0xDB, 0x84, 0x77, 0x77, 0x10, 0x30,
  0xBF, 0xC0, 0xD0, 0x64, 0x01, 0x0B, 0xA0, 0x77, 0x72, 0x01, 0x0A, 0xFF, 0x98, 0x3D, 0x20, 0x6E,
  0xB0, 0x37, 0x71, 0x05, 0x0E, 0xFF, 0xB0, 0xE0, 0xBD, 0x77, 0x10, 0x8F, 0x98, 0x4E, 0x97, 0x68,
  0xCF, 0xC0, 0xC7, 0x70, 0xAF, 0x0D, 0x05, 0x60, 0x30, 0xDF, 0xA0, 0x97, 0x60, 0xAF, 0x0B, 0x01,
  0x71, 0x01, 0x0D, 0xF9, 0x06, 0x75, 0x08, 0xF0, 0xA7, 0x40, 0x5F, 0x90, 0x37, 0x40, 0x5F, 0x0B,
  0x75, 0x02, 0xF9, 0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x60, 0x5F, 0x0C, 0x74, 0x0B, 0xF0, 0x37, 0x60,
  0x9F, 0x08, 0x73, 0x07, 0xF0, 0x97, 0x70, 0xCF, 0x05, 0x72, 0x01, 0xF0, 0xE0, 0x17, 0x7F, 0x90,
  0x27, 0x20, 0x9F, 0x08, 0x77, 0x03, 0xF0, 0xE7, 0x20, 0x2F, 0x0E, 0x01, 0x77, 0x06, 0xF0, 0xB7,
  0x20, 0xAF, 0x08, 0x77, 0x10, 0x9F, 0x08, 0x71, 0x02, 0xF9, 0x02, 0x77, 0x10, 0xCF, 0x04, 0x71,
  0x09, 0xF0, 0xB7, 0x72, 0xF9, 0x01, 0x71, 0x0E, 0xF0, 0x57, 0x71, 0x03, 0xF0, 0xD7, 0x10, 0x5F,
  0x0E, 0x77, 0x20, 0x6F, 0x0A, 0x71, 0x0B, 0xF0, 0xA7, 0x72, 0x0A, 0xF0, 0x77, 0x01, 0xF9, 0x06,
  0x77, 0x20, 0xDF, 0x04, 0x70, 0x6F, 0x90, 0x27, 0x71, 0x01, 0xF9, 0x71, 0x0A, 0xF0, 0xD7, 0x72,
  0x04, 0xF0, 0xD7, 0x10, 0xEF, 0x09, 0x77, 0x20, 0x7F, 0x09, 0x70, 0x3F, 0x90, 0x67, 0x72, 0x0B,
  0xF0, 0x67, 0x07, 0xF9, 0x02, 0x77, 0x2F, 0x90, 0x37, 0x0A, 0xF0, 0xE7, 0x72, 0x04, 0xF9, 0x71,
  0x0D, 0xF0, 0xC7, 0x72, 0x09, 0xF0, 0xC7, 0x1F, 0x90, 0xA7, 0x72, 0x0E, 0xF0, 0x97, 0x01, 0xF9,
  0x08, 0x77, 0x10, 0x5F, 0x90, 0x67, 0x03, 0xF9, 0x05, 0x77, 0x10, 0xBF, 0x90, 0x37, 0x04, 0xF9,
  0x04, 0x77, 0x02, 0xFA, 0x71, 0x05, 0xF9, 0x03, 0x77, 0x09, 0xF9, 0x0D, 0x71, 0x06, 0xF9, 0x03,
  0x76, 0x01, 0xFA, 0x0A, 0x71, 0x05, 0xF9, 0x02, 0x76, 0x08, 0xFA, 0x08, 0x71, 0x05, 0xF9, 0x03,
  0x75, 0x02, 0xA0, 0xDF, 0x05, 0x71, 0x04, 0xF9, 0x03, 0x75, 0x82, 0xBF, 0xD7, 0xF0, 0x37, 0x10,
  0x2F, 0x90, 0x57, 0x40, 0x5A, 0x06, 0x0A, 0xF0, 0x17, 0x2F, 0x90, 0x77, 0x38, 0x41, 0xEF, 0xD0,
  0xCF, 0x73, 0x0D, 0xF0, 0xA7, 0x30, 0xBA, 0x81, 0x40, 0xEE, 0x0E, 0x73, 0x09, 0xF0, 0xE7, 0x20,
  0x9A, 0x0B, 0x2F, 0x0E, 0x73, 0x05, 0xF9, 0x05, 0x70, 0x8A, 0x82, 0xE2, 0x01, 0xF9, 0x70, 0x13,
  0x0E, 0xF0, 0xD0, 0x15, 0x0A, 0xB0, 0x52, 0x01, 0xF9, 0x05, 0x58, 0x18, 0xE1, 0x20, 0x8F, 0x98,
  0x4D, 0x40, 0x16, 0xDB, 0x09, 0x4F, 0x98, 0x4D, 0x30, 0x27, 0xEA, 0x09, 0x20, 0x1F, 0xFA, 0x0A,
  0x50, 0xCF, 0xF9, 0x0C, 0x30, 0x7F, 0xF0, 0xB6, 0x06, 0xFF, 0x08, 0x50, 0xAF, 0xD0, 0x87, 0x10,
  0xDF, 0xC0, 0xB0, 0x27, 0x08, 0xFA, 0x0C, 0x03, 0x72, 0x02, 0x0D, 0xF9, 0x0C, 0x04, 0x73, 0x87,
  0x28, 0xCE, 0xFD, 0xC8, 0x37, 0x68, 0x67, 0xCE, 0xFE, 0xB8, 0x36,
  // "â" (U+00E2)
  0x77, 0x74, 0x80, 0x47, 0x77, 0x77, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x73, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x20, 0x10, 0xEF, 0xA0, 0xB7, 0x77, 0x72, 0x0C, 0xFC, 0x01, 0x77, 0x77, 0x09, 0xFD, 0x07,
  0x77, 0x76, 0x06, 0xE0, 0xB0, 0xDD, 0x0C, 0x77, 0x75, 0x03, 0xE8, 0x1A, 0x04, 0xE0, 0x27, 0x77,
  0x30, 0x20, 0xED, 0x09, 0x30, 0xAD, 0x09, 0x77, 0x73, 0x0C, 0xD0, 0x84, 0x01, 0x0E, 0xC0, 0xE7,
  0x77, 0x20, 0xBD, 0x07, 0x60, 0x5D, 0x07, 0x77, 0x70, 0x9C, 0x0E, 0x05, 0x71, 0x09, 0xC0, 0xD7,
  0x76, 0x07, 0xC0, 0xD0, 0x27, 0x30, 0xBC, 0x05, 0x77, 0x40, 0x5C, 0x0A, 0x01, 0x74, 0x01, 0x0C,
  0xB0, 0xD7, 0x74, 0x0C, 0xA0, 0xD0, 0x47, 0x70, 0x10, 0xCA, 0x0D, 0x80, 0xBC, 0x50, 0x89, 0x11,
  0x69, 0xCE, 0xFE, 0xDB, 0x84, 0x77, 0x77, 0x10, 0x30, 0xBF, 0xC0, 0xD0, 0x64, 0x01, 0x0B, 0xA0,
  0x77, 0x72, 0x01, 0x0A, 0xFF, 0x98, 0x3D, 0x20, 0x6E, 0xB0, 0x37, 0x71, 0x05, 0x0E, 0xFF, 0xB0,
  0xE0, 0xBD, 0x77, 0x10, 0x8F, 0x98, 0x4E, 0x97, 0x68, 0xCF, 0xC0, 0xC7, 0x70, 0xAF, 0x0D, 0x05,
  0x60, 0x30, 0xDF, 0xA0, 0x97, 0x60, 0xAF, 0x0B, 0x01, 0x71, 0x01, 0x0D, 0xF9, 0x06, 0x75, 0x08,
  0xF0, 0xA7, 0x40, 0x5F, 0x90, 0x37, 0x40, 0x5F, 0x0B, 0x75, 0x02, 0xF9, 0x74, 0x01, 0x0E, 0xE0,
  0xD7, 0x60, 0x5F, 0x0C, 0x74, 0x0B, 0xF0, 0x37, 0x60, 0x9F, 0x08, 0x73, 0x07, 0xF0, 0x97, 0x70,
  0xCF, 0x05, 0x72, 0x01, 0xF0, 0xE0, 0x17, 0x7F, 0x90, 0x27, 0x20, 0x9F, 0x08, 0x77, 0x03, 0xF0,
  0xE7, 0x20, 0x2F, 0x0E, 0x01, 0x77, 0x06, 0xF0, 0xB7, 0x20, 0xAF, 0x08, 0x77, 0x10, 0x9F, 0x08,
  0x71, 0x02, 0xF9, 0x02, 0x77, 0x10, 0xCF, 0x04, 0x71, 0x09, 0xF0, 0xB7, 0x72, 0xF9, 0x01, 0x71,
  0x0E, 0xF0, 0x57, 0x71, 0x03, 0xF0, 0xD7, 0x10, 0x5F, 0x0E, 0x77, 0x20, 0x6F, 0x0A, 0x71, 0x0B,
  0xF0, 0xA7, 0x72, 0x0A, 0xF0, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x20, 0xDF, 0x04, 0x70, 0x6F, 0x90,
  0x27, 0x71, 0x01, 0xF9, 0x71, 0x0A, 0xF0, 0xD7, 0x72, 0x04, 0xF0, 0xD7, 0x10, 0xEF, 0x09, 0x77,
  0x20, 0x7F, 0x09, 0x70, 0x3F, 0x90, 0x67, 0x72, 0x0B, 0xF0, 0x67, 0x07, 0xF9, 0x02, 0x77, 0x2F,
  0x90, 0x37, 0x0A, 0xF0, 0xE7, 0x72, 0x04, 0xF9, 0x71, 0x0D, 0xF0, 0xC7, 0x72, 0x09, 0xF0, 0xC7,
  0x1F, 0x90, 0xA7, 0x72, 0x0E, 0xF0, 0x97, 0x01, 0xF9, 0x08, 0x77, 0x10, 0x5F, 0x90, 0x67, 0x03,
  0xF9, 0x05, 0x77, 0x10, 0xBF, 0x90, 0x37, 0x04, 0xF9, 0x04, 0x77, 0x02, 0xFA, 0x71, 0x05, 0xF9,
  0x03, 0x77, 0x09, 0xF9, 0x0D, 0x71, 0x06, 0xF9, 0x03, 0x76, 0x01, 0xFA, 0x0A, 0x71, 0x05, 0xF9,
  0x02, 0x76, 0x08, 0xFA, 0x08, 0x71, 0x05, 0xF9, 0x03, 0x75, 0x02, 0xA0, 0xDF, 0x05, 0x71, 0x04,
  0xF9, 0x03, 0x75, 0x82, 0xBF, 0xD7, 0xF0, 0x37, 0x10, 0x2F, 0x90, 0x57, 0x40, 0x5A, 0x06, 0x0A,
  0xF0, 0x17, 0x2F, 0x90, 0x77, 0x38, 0x41, 0xEF, 0xD0, 0xCF, 0x73, 0x0D, 0xF0, 0xA7, 0x30, 0xBA,
  0x81, 0x40, 0xEE, 0x0E, 0x73, 0x09, 0xF0, 0xE7, 0x20, 0x9A, 0x0B, 0x2F, 0x0E, 0x73, 0x05, 0xF9,
  0x05, 0x70, 0x8A, 0x82, 0xE2, 0x01, 0xF9, 0x70, 0x13, 0x0E, 0xF0, 0xD0, 0x15, 0x0A, 0xB0, 0x52,
  0x01, 0xF9, 0x05, 0x58, 0x18, 0xE1, 0x20, 0x8F, 0x98, 0x4D, 0x40, 0x16, 0xDB, 0x09, 0x4F, 0x98,
  0x4D, 0x30, 0x27, 0xEA, 0x09, 0x20, 0x1F, 0xFA, 0x0A, 0x50, 0xCF, 0xF9, 0x0C, 0x30, 0x7F, 0xF0,
  0xB6, 0x06, 0xFF, 0x08, 0x50, 0xAF, 0xD0, 0x87, 0x10, 0xDF, 0xC0, 0xB0, 0x27, 0x08, 0xFA, 0x0C,
  0x03, 0x72, 0x02, 0x0D, 0xF9, 0x0C, 0x04, 0x73, 0x87, 0x28, 0xCE, 0xFD, 0xC8, 0x37, 0x68, 0x67,
  0xCE, 0xFE, 0xB8, 0x36,
  // "ã" (U+00E3)
  0x77, 0x48, 0x61, 0x7C, 0xEF, 0xDB, 0x57, 0x50, 0x20, 0xF4, 0x77, 0x30, 0x70, 0xEF, 0x0D, 0x03,
  0x73, 0x0C, 0xA0, 0xD7, 0x72, 0x09, 0xFC, 0x05, 0x71, 0x02, 0xB0, 0x97, 0x71, 0x08, 0xFE, 0x07,
  0x70, 0x9B, 0x03, 0x77, 0x04, 0xFF, 0x90, 0x95, 0x02, 0xB0, 0xC7, 0x71, 0x0D, 0xB8, 0x3A, 0x30,
  0x28, 0xF9, 0x84, 0xC4, 0x11, 0x5E, 0xB0, 0x47, 0x70, 0x5B, 0x0A, 0x50, 0x40, 0xEF, 0xF0, 0xA7,
  0x71, 0x0C, 0xB0, 0x26, 0x02, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x03, 0xB0, 0x97, 0x10, 0x10, 0xCF,
  0xB0, 0xE0, 0x27, 0x71, 0x07, 0xB0, 0x37, 0x30, 0x8F, 0x90, 0xC0, 0x27, 0x72, 0x02, 0x0F, 0x47,
  0x58, 0x62, 0x8C, 0xEE, 0xDA, 0x58, 0x0B, 0xC7, 0x08, 0x91, 0x16, 0x9C, 0xEF, 0xED, 0xB8, 0x47,
  0x77, 0x71, 0x03, 0x0B, 0xFC, 0x0D, 0x06, 0x40, 0x10, 0xBA, 0x07, 0x77, 0x20, 0x10, 0xAF, 0xF9,
  0x83, 0xD2, 0x06, 0xEB, 0x03, 0x77, 0x10, 0x50, 0xEF, 0xFB, 0x0E, 0x0B, 0xD7, 0x71, 0x08, 0xF9,
  0x84, 0xE9, 0x76, 0x8C, 0xFC, 0x0C, 0x77, 0x0A, 0xF0, 0xD0, 0x56, 0x03, 0x0D, 0xFA, 0x09, 0x76,
  0x0A, 0xF0, 0xB0, 0x17, 0x10, 0x10, 0xDF, 0x90, 0x67, 0x50, 0x8F, 0x0A, 0x74, 0x05, 0xF9, 0x03,
  0x74, 0x05, 0xF0, 0xB7, 0x50, 0x2F, 0x97, 0x40, 0x10, 0xEE, 0x0D, 0x76, 0x05, 0xF0, 0xC7, 0x40,
  0xBF, 0x03, 0x76, 0x09, 0xF0, 0x87, 0x30, 0x7F, 0x09, 0x77, 0x0C, 0xF0, 0x57, 0x20, 0x1F, 0x0E,
  0x01, 0x77, 0xF9, 0x02, 0x72, 0x09, 0xF0, 0x87, 0x70, 0x3F, 0x0E, 0x72, 0x02, 0xF0, 0xE0, 0x17,
  0x70, 0x6F, 0x0B, 0x72, 0x0A, 0xF0, 0x87, 0x71, 0x09, 0xF0, 0x87, 0x10, 0x2F, 0x90, 0x27, 0x71,
  0x0C, 0xF0, 0x47, 0x10, 0x9F, 0x0B, 0x77, 0x2F, 0x90, 0x17, 0x10, 0xEF, 0x05, 0x77, 0x10, 0x3F,
  0x0D, 0x71, 0x05, 0xF0, 0xE7, 0x72, 0x06, 0xF0, 0xA7, 0x10, 0xBF, 0x0A, 0x77, 0x20, 0xAF, 0x07,
  0x70, 0x1F, 0x90, 0x67, 0x72, 0x0D, 0xF0, 0x47, 0x06, 0xF9, 0x02, 0x77, 0x10, 0x1F, 0x97, 0x10,
  0xAF, 0x0D, 0x77, 0x20, 0x4F, 0x0D, 0x71, 0x0E, 0xF0, 0x97, 0x72, 0x07, 0xF0, 0x97, 0x03, 0xF9,
  0x06, 0x77, 0x20, 0xBF, 0x06, 0x70, 0x7F, 0x90, 0x27, 0x72, 0xF9, 0x03, 0x70, 0xAF, 0x0E, 0x77,
  0x20, 0x4F, 0x97, 0x10, 0xDF, 0x0C, 0x77, 0x20, 0x9F, 0x0C, 0x71, 0xF9, 0x0A, 0x77, 0x20, 0xEF,
  0x09, 0x70, 0x1F, 0x90, 0x87, 0x71, 0x05, 0xF9, 0x06, 0x70, 0x3F, 0x90, 0x57, 0x71, 0x0B, 0xF9,
  0x03, 0x70, 0x4F, 0x90, 0x47, 0x70, 0x2F, 0xA7, 0x10, 0x5F, 0x90, 0x37, 0x70, 0x9F, 0x90, 0xD7,
  0x10, 0x6F, 0x90, 0x37, 0x60, 0x1F, 0xA0, 0xA7, 0x10, 0x5F, 0x90, 0x27, 0x60, 0x8F, 0xA0, 0x87,
  0x10, 0x5F, 0x90, 0x37, 0x50, 0x2A, 0x0D, 0xF0, 0x57, 0x10, 0x4F, 0x90, 0x37, 0x58, 0x2B, 0xFD,
  0x7F, 0x03, 0x71, 0x02, 0xF9, 0x05, 0x74, 0x05, 0xA0, 0x60, 0xAF, 0x01, 0x72, 0xF9, 0x07, 0x73,
  0x84, 0x1E, 0xFD, 0x0C, 0xF7, 0x30, 0xDF, 0x0A, 0x73, 0x0B, 0xA8, 0x14, 0x0E, 0xE0, 0xE7, 0x30,
  0x9F, 0x0E, 0x72, 0x09, 0xA0, 0xB2, 0xF0, 0xE7, 0x30, 0x5F, 0x90, 0x57, 0x08, 0xA8, 0x2E, 0x20,
  0x1F, 0x97, 0x01, 0x30, 0xEF, 0x0D, 0x01, 0x50, 0xAB, 0x05, 0x20, 0x1F, 0x90, 0x55, 0x81, 0x8E,
  0x12, 0x08, 0xF9, 0x84, 0xD4, 0x01, 0x6D, 0xB0, 0x94, 0xF9, 0x84, 0xD3, 0x02, 0x7E, 0xA0, 0x92,
  0x01, 0xFF, 0xA0, 0xA5, 0x0C, 0xFF, 0x90, 0xC3, 0x07, 0xFF, 0x0B, 0x60, 0x6F, 0xF0, 0x85, 0x0A,
  0xFD, 0x08, 0x71, 0x0D, 0xFC, 0x0B, 0x02, 0x70, 0x8F, 0xA0, 0xC0, 0x37, 0x20, 0x20, 0xDF, 0x90,
  0xC0, 0x47, 0x38, 0x72, 0x8C, 0xEF, 0xDC, 0x83, 0x76, 0x86, 0x7C, 0xEF, 0xEB, 0x83, 0x60,
  // "ä" (U+00E4)
  0x77, 0x28, 0x35, 0xCF, 0xD7, 0x73, 0x83, 0x6D, 0xFD, 0x77, 0x77, 0x07, 0xD0, 0x97, 0x10, 0x8D,
  0x08, 0x77, 0x50, 0x2F, 0x01, 0x60, 0x2E, 0x0E, 0x77, 0x50, 0x7F, 0x03, 0x60, 0x8F, 0x02, 0x77,
  0x40, 0xBF, 0x04, 0x60, 0xCF, 0x03, 0x77, 0x40, 0xCF, 0x03, 0x60, 0xDF, 0x02, 0x77, 0x40, 0xBF,
  0x70, 0xCF, 0x77, 0x50, 0x9E, 0x0B, 0x70, 0xAE, 0x0A, 0x77, 0x50, 0x2D, 0x0E, 0x02, 0x70, 0x3D,
  0x0D, 0x01, 0x77, 0x68, 0x43, 0xBE, 0xEA, 0x17, 0x28, 0x44, 0xCF, 0xE9, 0x18, 0x0D, 0xC5, 0x08,
  0x91, 0x16, 0x9C, 0xEF, 0xED, 0xB8, 0x47, 0x77, 0x71, 0x03, 0x0B, 0xFC, 0x0D, 0x06, 0x40, 0x10,
  0xBA, 0x07, 0x77, 0x20, 0x10, 0xAF, 0xF9, 0x83, 0xD2, 0x06, 0xEB, 0x03, 0x77, 0x10, 0x50, 0xEF,
  0xFB, 0x0E, 0x0B, 0xD7, 0x71, 0x08, 0xF9, 0x84, 0xE9, 0x76, 0x8C, 0xFC, 0x0C, 0x77, 0x0A, 0xF0,
  0xD0, 0x56, 0x03, 0x0D, 0xFA, 0x09, 0x76, 0x0A, 0xF0, 0xB0, 0x17, 0x10, 0x10, 0xDF, 0x90, 0x67,
  0x50, 0x8F, 0x0A, 0x74, 0x05, 0xF9, 0x03, 0x74, 0x05, 0xF0, 0xB7, 0x50, 0x2F, 0x97, 0x40, 0x10,
  0xEE, 0x0D, 0x76, 0x05, 0xF0, 0xC7, 0x40, 0xBF, 0x03, 0x76, 0x09, 0xF0, 0x87, 0x30, 0x7F, 0x09,
  0x77, 0x0C, 0xF0, 0x57, 0x20, 0x1F, 0x0E, 0x01, 0x77, 0xF9, 0x02, 0x72, 0x09, 0xF0, 0x87, 0x70,
  0x3F, 0x0E, 0x72, 0x02, 0xF0, 0xE0, 0x17, 0x70, 0x6F, 0x0B, 0x72, 0x0A, 0xF0, 0x87, 0x71, 0x09,
  0xF0, 0x87, 0x10, 0x2F, 0x90, 0x27, 0x71, 0x0C, 0xF0, 0x47, 0x10, 0x9F, 0x0B, 0x77, 0x2F, 0x90,
  0x17, 0x10, 0xEF, 0x05, 0x77, 0x10, 0x3F, 0x0D, 0x71, 0x05, 0xF0, 0xE7, 0x72, 0x06, 0xF0, 0xA7,
  0x10, 0xBF, 0x0A, 0x77, 0x20, 0xAF, 0x07, 0x70, 0x1F, 0x90, 0x67, 0x72, 0x0D, 0xF0, 0x47, 0x06,
  0xF9, 0x02, 0x77, 0x10, 0x1F, 0x97, 0x10, 0xAF, 0x0D, 0x77, 0x20, 0x4F, 0x0D, 0x71, 0x0E, 0xF0,
  0x97, 0x72, 0x07, 0xF0, 0x97, 0x03, 0xF9, 0x06, 0x77, 0x20, 0xBF, 0x06, 0x70, 0x7F, 0x90, 0x27,
  0x72, 0xF9, 0x03, 0x70, 0xAF, 0x0E, 0x77, 0x20, 0x4F, 0x97, 0x10, 0xDF, 0x0C, 0x77, 0x20, 0x9F,
  0x0C, 0x71, 0xF9, 0x0A, 0x77, 0x20, 0xEF, 0x09, 0x70, 0x1F, 0x90, 0x87, 0x71, 0x05, 0xF9, 0x06,
  0x70, 0x3F, 0x90, 0x57, 0x71, 0x0B, 0xF9, 0x03, 0x70, 0x4F, 0x90, 0x47, 0x70, 0x2F, 0xA7, 0x10,
  0x5F, 0x90, 0x37, 0x70, 0x9F, 0x90, 0xD7, 0x10, 0x6F, 0x90, 0x37, 0x60, 0x1F, 0xA0, 0xA7, 0x10,
  0x5F, 0x90, 0x27, 0x60, 0x8F, 0xA0, 0x87, 0x10, 0x5F, 0x90, 0x37, 0x50, 0x2A, 0x0D, 0xF0, 0x57,
  0x10, 0x4F, 0x90, 0x37, 0x58, 0x2B, 0xFD, 0x7F, 0x03, 0x71, 0x02, 0xF9, 0x05, 0x74, 0x05, 0xA0,
  0x60, 0xAF, 0x01, 0x72, 0xF9, 0x07, 0x73, 0x84, 0x1E, 0xFD, 0x0C, 0xF7, 0x30, 0xDF, 0x0A, 0x73,
  0x0B, 0xA8, 0x14, 0x0E, 0xE0, 0xE7, 0x30, 0x9F, 0x0E, 0x72, 0x09, 0xA0, 0xB2, 0xF0, 0xE7, 0x30,
  0x5F, 0x90, 0x57, 0x08, 0xA8, 0x2E, 0x20, 0x1F, 0x97, 0x01, 0x30, 0xEF, 0x0D, 0x01, 0x50, 0xAB,
  0x05, 0x20, 0x1F, 0x90, 0x55, 0x81, 0x8E, 0x12, 0x08, 0xF9, 0x84, 0xD4, 0x01, 0x6D, 0xB0, 0x94,
  0xF9, 0x84, 0xD3, 0x02, 0x7E, 0xA0, 0x92, 0x01, 0xFF, 0xA0, 0xA5, 0x0C, 0xFF, 0x90, 0xC3, 0x07,
  0xFF, 0x0B, 0x60, 0x6F, 0xF0, 0x85, 0x0A, 0xFD, 0x08, 0x71, 0x0D, 0xFC, 0x0B, 0x02, 0x70, 0x8F,
  0xA0, 0xC0, 0x37, 0x20, 0x20, 0xDF, 0x90, 0xC0, 0x47, 0x38, 0x72, 0x8C, 0xEF, 0xDC, 0x83, 0x76,
  0x86, 0x7C, 0xEF, 0xEB, 0x83, 0x60,
  // "å" (U+00E5)
  0x77, 0x72, 0x87, 0x49, 0xCE, 0xFE, 0xC9, 0x47, 0x77, 0x73, 0x03, 0x0C, 0xFA, 0x0C, 0x03, 0x77,
  0x77, 0x06, 0xFE, 0x05, 0x77, 0x75, 0x05, 0xFF, 0x90, 0x37, 0x77, 0x40, 0xDD, 0x83, 0xA7, 0x67,
  0xBD, 0x0B, 0x77, 0x73, 0x06, 0xC0, 0xB0, 0x15, 0x03, 0x0D, 0xC0, 0x17, 0x77, 0x20, 0xAB, 0x0D,
  0x71, 0x02, 0xC0, 0x57, 0x77, 0x20, 0xDB, 0x07, 0x72, 0x0C, 0xB0, 0x77, 0x77, 0x20, 0xEB, 0x04,
  0x72, 0x0A, 0xB0, 0x87, 0x77, 0x2C, 0x03, 0x72, 0x0A, 0xB0, 0x87, 0x77, 0x20, 0xEB, 0x05, 0x72,
  0x0D, 0xB0, 0x67, 0x77, 0x20, 0xCB, 0x0B, 0x71, 0x05, 0xC0, 0x37, 0x77, 0x20, 0x8C, 0x08, 0x60,
  0x50, 0xEB, 0x0E, 0x77, 0x73, 0x03, 0xD8, 0x4E, 0x97, 0x68, 0xDD, 0x06, 0x77, 0x74, 0x09, 0xFF,
  0x0C, 0x77, 0x76, 0x0B, 0xFD, 0x0C, 0x01, 0x77, 0x77, 0x07, 0xFA, 0x0E, 0x07, 0x77, 0x77, 0x38,
  0x90, 0x17, 0xBD, 0xFE, 0xDA, 0x61, 0x80, 0xBD, 0x30, 0x89, 0x11, 0x69, 0xCE, 0xFE, 0xDB, 0x84,
  0x77, 0x77, 0x10, 0x30, 0xBF, 0xC0, 0xD0, 0x64, 0x01, 0x0B, 0xA0, 0x77, 0x72, 0x01, 0x0A, 0xFF,
  0x98, 0x3D, 0x20, 0x6E, 0xB0, 0x37, 0x71, 0x05, 0x0E, 0xFF, 0xB0, 0xE0, 0xBD, 0x77, 0x10, 0x8F,
  0x98, 0x4E, 0x97, 0x68, 0xCF, 0xC0, 0xC7, 0x70, 0xAF, 0x0D, 0x05, 0x60, 0x30, 0xDF, 0xA0, 0x97,
  0x60, 0xAF, 0x0B, 0x01, 0x71, 0x01, 0x0D, 0xF9, 0x06, 0x75, 0x08, 0xF0, 0xA7, 0x40, 0x5F, 0x90,
  0x37, 0x40, 0x5F, 0x0B, 0x75, 0x02, 0xF9, 0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x60, 0x5F, 0x0C, 0x74,
  0x0B, 0xF0, 0x37, 0x60, 0x9F, 0x08, 0x73, 0x07, 0xF0, 0x97, 0x70, 0xCF, 0x05, 0x72, 0x01, 0xF0,
  0xE0, 0x17, 0x7F, 0x90, 0x27, 0x20, 0x9F, 0x08, 0x77, 0x03, 0xF0, 0xE7, 0x20, 0x2F, 0x0E, 0x01,
  0x77, 0x06, 0xF0, 0xB7, 0x20, 0xAF, 0x08, 0x77, 0x10, 0x9F, 0x08, 0x71, 0x02, 0xF9, 0x02, 0x77,
  0x10, 0xCF, 0x04, 0x71, 0x09, 0xF0, 0xB7, 0x72, 0xF9, 0x01, 0x71, 0x0E, 0xF0, 0x57, 0x71, 0x03,
  0xF0, 0xD7, 0x10, 0x5F, 0x0E, 0x77, 0x20, 0x6F, 0x0A, 0x71, 0x0B, 0xF0, 0xA7, 0x72, 0x0A, 0xF0,
  0x77, 0x01, 0xF9, 0x06, 0x77, 0x20, 0xDF, 0x04, 0x70, 0x6F, 0x90, 0x27, 0x71, 0x01, 0xF9, 0x71,
  0x0A, 0xF0, 0xD7, 0x72, 0x04, 0xF0, 0xD7, 0x10, 0xEF, 0x09, 0x77, 0x20, 0x7F, 0x09, 0x70, 0x3F,
  0x90, 0x67, 0x72, 0x0B, 0xF0, 0x67, 0x07, 0xF9, 0x02, 0x77, 0x2F, 0x90, 0x37, 0x0A, 0xF0, 0xE7,
  0x72, 0x04, 0xF9, 0x71, 0x0D, 0xF0, 0xC7, 0x72, 0x09, 0xF0, 0xC7, 0x1F, 0x90, 0xA7, 0x72, 0x0E,
  0xF0, 0x97, 0x01, 0xF9, 0x08, 0x77, 0x10, 0x5F, 0x90, 0x67, 0x03, 0xF9, 0x05, 0x77, 0x10, 0xBF,
  0x90, 0x37, 0x04, 0xF9, 0x04, 0x77, 0x02, 0xFA, 0x71, 0x05, 0xF9, 0x03, 0x77, 0x09, 0xF9, 0x0D,
  0x71, 0x06, 0xF9, 0x03, 0x76, 0x01, 0xFA, 0x0A, 0x71, 0x05, 0xF9, 0x02, 0x76, 0x08, 0xFA, 0x08,
  0x71, 0x05, 0xF9, 0x03, 0x75, 0x02, 0xA0, 0xDF, 0x05, 0x71, 0x04, 0xF9, 0x03, 0x75, 0x82, 0xBF,
  0xD7, 0xF0, 0x37, 0x10, 0x2F, 0x90, 0x57, 0x40, 0x5A, 0x06, 0x0A, 0xF0, 0x17, 0x2F, 0x90, 0x77,
  0x38, 0x41, 0xEF, 0xD0, 0xCF, 0x73, 0x0D, 0xF0, 0xA7, 0x30, 0xBA, 0x81, 0x40, 0xEE, 0x0E, 0x73,
  0x09, 0xF0, 0xE7, 0x20, 0x9A, 0x0B, 0x2F, 0x0E, 0x73, 0x05, 0xF9, 0x05, 0x70, 0x8A, 0x82, 0xE2,
  0x01, 0xF9, 0x70, 0x13, 0x0E, 0xF0, 0xD0, 0x15, 0x0A, 0xB0, 0x52, 0x01, 0xF9, 0x05, 0x58, 0x18,
  0xE1, 0x20, 0x8F, 0x98, 0x4D, 0x40, 0x16, 0xDB, 0x09, 0x4F, 0x98, 0x4D, 0x30, 0x27, 0xEA, 0x09,
  0x20, 0x1F, 0xFA, 0x0A, 0x50, 0xCF, 0xF9, 0x0C, 0x30, 0x7F, 0xF0, 0xB6, 0x06, 0xFF, 0x08, 0x50,
  0xAF, 0xD0, 0x87, 0x10, 0xDF, 0xC0, 0xB0, 0x27, 0x08, 0xFA, 0x0C, 0x03, 0x72, 0x02, 0x0D, 0xF9,
  0x0C, 0x04, 0x73, 0x87, 0x28, 0xCE, 0xFD, 0xC8, 0x37, 0x68, 0x67, 0xCE, 0xFE, 0xB8, 0x36,
  // "æ" (U+00E6)
  0x77, 0x58, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xA6, 0x17, 0x71, 0x89, 0x05, 0x9B, 0xDE, 0xFE, 0xD9,
  0x67, 0x77, 0x18, 0x11, 0x9E, 0xFC, 0x0A, 0x02, 0x73, 0x02, 0x09, 0xFC, 0x0E, 0x07, 0x77, 0x50,
  0x8F, 0xFA, 0x07, 0x70, 0x10, 0xAF, 0xF9, 0x0B, 0x77, 0x20, 0x30, 0xDF, 0xFC, 0x0B, 0x50, 0x50,
  0xEF, 0xFB, 0x0A, 0x77, 0x06, 0xFA, 0x84, 0xC8, 0x66, 0x8D, 0xE0, 0xC0, 0x12, 0x09, 0xF8, 0x2A,
  0x77, 0x9F, 0xA0, 0x57, 0x50, 0x7F, 0x90, 0x90, 0x26, 0x04, 0x0D, 0xD8, 0x1C, 0x1B, 0xE0, 0xB0,
  0x14, 0x02, 0x0E, 0xF0, 0xD7, 0x40, 0x7F, 0x0E, 0x04, 0x73, 0x0B, 0xD0, 0xEE, 0x08, 0x70, 0x5F,
  0x90, 0x37, 0x20, 0x5F, 0x0E, 0x02, 0x75, 0x0B, 0xFB, 0x09, 0x72, 0x0E, 0xF0, 0x77, 0x10, 0x20,
  0xEE, 0x0E, 0x03, 0x76, 0x01, 0x0E, 0xF9, 0x0C, 0x73, 0x0B, 0xF0, 0x97, 0x10, 0xCF, 0x05, 0x77,
  0x10, 0x5F, 0x0E, 0x02, 0x73, 0x0A, 0xF0, 0xA7, 0x07, 0xF0, 0xA7, 0x72, 0x09, 0xF0, 0x77, 0x40,
  0xAF, 0x0A, 0x60, 0x2F, 0x0E, 0x01, 0x77, 0x10, 0x2F, 0x0E, 0x75, 0x0B, 0xF0, 0x96, 0x0B, 0xF0,
  0x77, 0x72, 0x0A, 0xF0, 0x67, 0x50, 0xDF, 0x07, 0x50, 0x3F, 0x0E, 0x77, 0x20, 0x2F, 0x0E, 0x75,
  0x01, 0xF9, 0x03, 0x50, 0xBF, 0x07, 0x77, 0x20, 0x9F, 0x07, 0x75, 0x05, 0xF0, 0xE5, 0x03, 0xF9,
  0x01, 0x77, 0x10, 0x1F, 0x90, 0x17, 0x50, 0xBF, 0x09, 0x50, 0xAF, 0x0A, 0x77, 0x20, 0x7F, 0x0B,
  0x75, 0x03, 0xF9, 0x02, 0x40, 0x1F, 0x90, 0x47, 0x72, 0x0D, 0xF0, 0x57, 0x50, 0xCF, 0x09, 0x50,
  0x6F, 0x0D, 0x77, 0x20, 0x4F, 0x97, 0x50, 0x9F, 0x0E, 0x01, 0x50, 0xCF, 0x09, 0x77, 0x20, 0x9F,
  0x0B, 0x74, 0x08, 0xF9, 0x04, 0x50, 0x2F, 0x90, 0x57, 0x72, 0x0E, 0xF0, 0x67, 0x30, 0x9F, 0x90,
  0x76, 0x06, 0xF9, 0x01, 0x77, 0x10, 0x4F, 0x90, 0x27, 0x10, 0x40, 0xDF, 0x90, 0x77, 0x0A, 0xF0,
  0xC7, 0x72, 0x08, 0xF0, 0xD7, 0x05, 0x0B, 0xFA, 0x06, 0x71, 0x0E, 0xF0, 0x87, 0x72, 0x0C, 0xF0,
  0x92, 0x83, 0x14, 0x6A, 0xEF, 0xA0, 0xD0, 0x37, 0x10, 0x3F, 0x90, 0x57, 0x71, 0x01, 0xFF, 0xFB,
  0x09, 0x01, 0x72, 0x06, 0xF9, 0x02, 0x77, 0x10, 0x5F, 0xFF, 0x90, 0xB0, 0x37, 0x40, 0x8F, 0x0E,
  0x77, 0x20, 0x8F, 0xFE, 0x09, 0x03, 0x76, 0x0B, 0xF0, 0xC7, 0x72, 0x0C, 0xFF, 0xA8, 0x1C, 0x94,
  0x77, 0x20, 0xDF, 0x0B, 0x77, 0x2F, 0x98, 0x6D, 0x66, 0x65, 0x44, 0x27, 0x76, 0xF9, 0x09, 0x77,
  0x10, 0x3F, 0x90, 0xA7, 0x77, 0x6F, 0x90, 0x77, 0x71, 0x07, 0xF9, 0x08, 0x77, 0x75, 0x01, 0xF9,
  0x06, 0x77, 0x10, 0xAF, 0x90, 0x77, 0x77, 0x50, 0x2F, 0x90, 0x57, 0x71, 0x0E, 0xF9, 0x06, 0x77,
  0x75, 0x03, 0xF9, 0x05, 0x77, 0x04, 0xFA, 0x07, 0x77, 0x75, 0x03, 0xF9, 0x05, 0x77, 0x09, 0xFA,
  0x08, 0x77, 0x75, 0x02, 0xF9, 0x06, 0x76, 0x01, 0x0E, 0xFA, 0x09, 0x77, 0x75, 0x01, 0xF9, 0x07,
  0x76, 0x07, 0xFB, 0x0C, 0x77, 0x76, 0xF9, 0x0A, 0x76, 0x0D, 0xA0, 0x6F, 0x0E, 0x77, 0x76, 0x0D,
  0xF0, 0xD7, 0x50, 0x7A, 0x0B, 0x1F, 0x90, 0x47, 0x73, 0x06, 0x07, 0x70, 0xAF, 0x90, 0x27, 0x30,
  0x10, 0xEA, 0x81, 0x50, 0xCF, 0x0A, 0x77, 0x28, 0x15, 0xFC, 0x70, 0x7F, 0x90, 0x87, 0x30, 0xBA,
  0x0D, 0x20, 0x7F, 0x90, 0x37, 0x70, 0x7A, 0x0C, 0x70, 0x3F, 0x90, 0xE0, 0x27, 0x10, 0x9B, 0x05,
  0x20, 0x1F, 0x90, 0xD0, 0x17, 0x40, 0x10, 0xAB, 0x09, 0x71, 0x0D, 0xF9, 0x0C, 0x01, 0x50, 0x10,
  0xAB, 0x0B, 0x40, 0xAF, 0x90, 0xC0, 0x27, 0x20, 0x60, 0xEC, 0x04, 0x71, 0x07, 0xFA, 0x85, 0xD5,
  0x10, 0x27, 0xEB, 0x0E, 0x02, 0x40, 0x2F, 0xB8, 0x19, 0x41, 0x28, 0x21, 0x48, 0xED, 0x0C, 0x73,
  0x0E, 0xFF, 0xC0, 0x66, 0x08, 0xFF, 0xFA, 0x03, 0x73, 0x05, 0xFF, 0xB0, 0x87, 0x10, 0xBF, 0xFF,
  0x05, 0x75, 0x07, 0xFF, 0x90, 0x97, 0x30, 0xBF, 0xFD, 0x05, 0x77, 0x07, 0xFE, 0x06, 0x75, 0x08,
  0xFF, 0xA0, 0xC0, 0x37, 0x72, 0x04, 0x0D, 0xFA, 0x0A, 0x02, 0x77, 0x03, 0x0A, 0xFD, 0x0D, 0x06,
  0x77, 0x68, 0x74, 0xAD, 0xEE, 0xDB, 0x72, 0x77, 0x48, 0x31, 0x6A, 0xCE, 0xA8, 0x3E, 0xDA, 0x73,
  0x77,
  // "ç" (U+00E7)
  0x77, 0x58, 0x92, 0x26, 0x9C, 0xDE, 0xFE, 0xDB, 0x83, 0x77, 0x72, 0x05, 0x0B, 0xFD, 0x0D, 0x05,
  0x77, 0x50, 0x40, 0xCF, 0xFA, 0x09, 0x77, 0x30, 0x9F, 0xFD, 0x09, 0x77, 0x02, 0x0C, 0xF8, 0x3B,
  0x76, 0x8D, 0xFA, 0x05, 0x75, 0x03, 0x0E, 0xE0, 0xA0, 0x15, 0x09, 0xF9, 0x0D, 0x74, 0x03, 0x0E,
  0xE0, 0x77, 0x10, 0xCF, 0x90, 0x37, 0x20, 0x20, 0xEE, 0x07, 0x72, 0x03, 0xF9, 0x06, 0x71, 0x01,
  0x0D, 0xE0, 0x97, 0x40, 0xDF, 0x07, 0x71, 0x0A, 0xE0, 0xD7, 0x50, 0x8F, 0x05, 0x70, 0x6F, 0x03,
  0x75, 0x05, 0xF0, 0x16, 0x01, 0x0E, 0xE0, 0xA7, 0x60, 0x2E, 0x09, 0x70, 0xAF, 0x02, 0x76, 0x01,
  0xD0, 0xC7, 0x03, 0xF0, 0xA7, 0x71, 0xC0, 0xA0, 0x17, 0x0B, 0xF0, 0x37, 0x71, 0x82, 0xBA, 0x72,
  0x71, 0x04, 0xF0, 0xD7, 0x77, 0x70, 0xBF, 0x07, 0x77, 0x76, 0x02, 0xF9, 0x01, 0x77, 0x76, 0x08,
  0xF0, 0xB7, 0x77, 0x70, 0xEF, 0x07, 0x77, 0x76, 0x03, 0xF9, 0x02, 0x77, 0x76, 0x08, 0xF0, 0xE7,
  0x77, 0x70, 0xCF, 0x0A, 0x77, 0x76, 0x01, 0xF9, 0x06, 0x77, 0x76, 0x05, 0xF9, 0x03, 0x77, 0x76,
  0x08, 0xF9, 0x77, 0x77, 0x0B, 0xF0, 0xD7, 0x77, 0x70, 0xDF, 0x0B, 0x77, 0x77, 0xF9, 0x09, 0x77,
  0x76, 0x01, 0xF9, 0x08, 0x77, 0x76, 0x02, 0xF9, 0x07, 0x77, 0x76, 0x03, 0xF9, 0x06, 0x77, 0x76,
  0x03, 0xF9, 0x06, 0x77, 0x76, 0x02, 0xF9, 0x07, 0x77, 0x76, 0x02, 0xF9, 0x08, 0x77, 0x77, 0xF9,
  0x0A, 0x77, 0x77, 0x0E, 0xF0, 0xD7, 0x77, 0x70, 0xBF, 0x90, 0x17, 0x77, 0x60, 0x8F, 0x90, 0x67,
  0x73, 0x0A, 0x07, 0x71, 0x04, 0xF9, 0x0C, 0x77, 0x28, 0x19, 0xFA, 0x72, 0x0E, 0xF9, 0x05, 0x77,
  0x09, 0xA0, 0x97, 0x20, 0x8F, 0x90, 0xE0, 0x27, 0x40, 0x10, 0xBB, 0x05, 0x72, 0x01, 0xFA, 0x0D,
  0x03, 0x72, 0x05, 0x0E, 0xB0, 0xE7, 0x40, 0x7F, 0xB8, 0x1A, 0x51, 0x28, 0x21, 0x48, 0xDD, 0x08,
  0x75, 0x0C, 0xFF, 0xF9, 0x0D, 0x76, 0x01, 0x0D, 0xFF, 0xE0, 0xE0, 0x27, 0x70, 0x10, 0xCF, 0xFC,
  0x0D, 0x03, 0x77, 0x30, 0x8F, 0xFA, 0x0A, 0x01, 0x77, 0x50, 0x20, 0xAF, 0xD0, 0xC0, 0x47, 0x77,
  0x28, 0x11, 0x6C, 0xC8, 0x3E, 0xCA, 0x72, 0x77, 0x76, 0x08, 0xB0, 0x67, 0x77, 0x74, 0x0E, 0xA0,
  0xE7, 0x77, 0x74, 0x06, 0xB0, 0x97, 0x77, 0x74, 0x0D, 0xC0, 0xC0, 0x47, 0x77, 0x71, 0x04, 0xF0,
  0xA7, 0x77, 0x70, 0x8F, 0x90, 0xB7, 0x77, 0x78, 0x11, 0x7E, 0xE0, 0x77, 0x77, 0x71, 0x02, 0x0E,
  0xD0, 0xE7, 0x77, 0x72, 0x05, 0xE0, 0x47, 0x77, 0x72, 0xE0, 0x77, 0x77, 0x72, 0x0D, 0xD0, 0x77,
  0x77, 0x72, 0x0E, 0xD0, 0x67, 0x77, 0x71, 0x01, 0xE0, 0x57, 0x77, 0x71, 0x06, 0xE0, 0x17, 0x77,
  0x70, 0x10, 0xDD, 0x0C, 0x77, 0x77, 0x03, 0x0D, 0xE0, 0x67, 0x75, 0x87, 0x2F, 0xC9, 0x87, 0x68,
  0xCF, 0x0C, 0x77, 0x60, 0x6F, 0xF0, 0xD0, 0x17, 0x76, 0x0A, 0xFE, 0x0B, 0x01, 0x77, 0x70, 0xDF,
  0xC0, 0xC0, 0x47, 0x77, 0x28, 0x92, 0x36, 0xAC, 0xDE, 0xFE, 0xDA, 0x72, 0x77, 0x71,
  // "è" (U+00E8)
  0x77, 0x20, 0x68, 0x03, 0x70, 0x47, 0x77, 0x60, 0xEF, 0x0C, 0x77, 0x76, 0x06, 0xF9, 0x02, 0x77,
  0x76, 0x0C, 0xF0, 0x77, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x77, 0x07, 0xF0, 0x27, 0x77, 0x70, 0xCE,
  0x08, 0x77, 0x77, 0x01, 0x0E, 0xD0, 0xE7, 0x77, 0x71, 0x05, 0xE0, 0x57, 0x77, 0x71, 0x08, 0xD0,
  0xB7, 0x77, 0x72, 0x0B, 0xD0, 0x17, 0x77, 0x71, 0x01, 0x0D, 0xC0, 0x77, 0x77, 0x72, 0x03, 0x0E,
  0xB0, 0xD7, 0x77, 0x73, 0x04, 0xC0, 0x47, 0x77, 0x73, 0x06, 0xB0, 0x48, 0x0B, 0x91, 0x08, 0x91,
  0x15, 0x9C, 0xDE, 0xFE, 0xC9, 0x57, 0x77, 0x20, 0x50, 0xBF, 0xC0, 0xE0, 0x67, 0x75, 0x03, 0x0C,
  0xFF, 0x90, 0xA7, 0x73, 0x09, 0xFF, 0xC0, 0x97, 0x70, 0x20, 0xCE, 0x83, 0xEA, 0x76, 0x9F, 0xA0,
  0x47, 0x50, 0x20, 0xEE, 0x0A, 0x01, 0x40, 0x20, 0xEF, 0x0C, 0x74, 0x03, 0x0E, 0xE0, 0x77, 0x06,
  0xF9, 0x01, 0x72, 0x02, 0x0E, 0xE0, 0x87, 0x10, 0x1F, 0x90, 0x57, 0x10, 0x10, 0xDE, 0x0B, 0x73,
  0x0D, 0xF0, 0x77, 0x10, 0xAE, 0x0E, 0x01, 0x73, 0x0C, 0xF0, 0x97, 0x06, 0xF0, 0x67, 0x40, 0xCF,
  0x08, 0x60, 0x10, 0xEE, 0x0D, 0x75, 0x0D, 0xF0, 0x76, 0x0A, 0xF0, 0x57, 0x5F, 0x90, 0x55, 0x03,
  0xF0, 0xC7, 0x50, 0x3F, 0x90, 0x15, 0x0B, 0xF0, 0x67, 0x50, 0x7F, 0x0D, 0x50, 0x4F, 0x0E, 0x76,
  0x0D, 0xF0, 0x75, 0x0B, 0xF0, 0x87, 0x50, 0x5F, 0x0E, 0x01, 0x40, 0x2F, 0x90, 0x37, 0x40, 0x10,
  0xDF, 0x07, 0x50, 0x8F, 0x0D, 0x75, 0x0B, 0xF0, 0xD6, 0x0E, 0xF0, 0x87, 0x40, 0xAF, 0x0E, 0x02,
  0x50, 0x3F, 0x90, 0x37, 0x20, 0x10, 0xBF, 0x90, 0x56, 0x08, 0xF0, 0xE7, 0x20, 0x50, 0xDF, 0x90,
  0x57, 0x0C, 0xF0, 0xB7, 0x05, 0x0C, 0xFA, 0x05, 0x70, 0x1F, 0x90, 0x82, 0x83, 0x14, 0x6A, 0xEF,
  0xA0, 0xD0, 0x27, 0x10, 0x5F, 0xFF, 0xB0, 0x87, 0x30, 0x8F, 0xFF, 0x90, 0xA0, 0x27, 0x40, 0xBF,
  0xFD, 0x81, 0xE8, 0x27, 0x60, 0xDF, 0xF9, 0x82, 0xEC, 0x84, 0x77, 0x2F, 0x98, 0x6C, 0x66, 0x65,
  0x43, 0x17, 0x75, 0x01, 0xF9, 0x08, 0x77, 0x75, 0x02, 0xF9, 0x06, 0x77, 0x75, 0x03, 0xF9, 0x05,
  0x77, 0x75, 0x03, 0xF9, 0x05, 0x77, 0x75, 0x02, 0xF9, 0x05, 0x77, 0x75, 0x01, 0xF9, 0x06, 0x77,
  0x76, 0xF9, 0x07, 0x77, 0x76, 0x0D, 0xF0, 0xA7, 0x77, 0x60, 0xBF, 0x0D, 0x77, 0x50, 0x17, 0x07,
  0xF9, 0x02, 0x77, 0x30, 0xA0, 0x97, 0x03, 0xF9, 0x08, 0x77, 0x28, 0x19, 0xFB, 0x71, 0x0D, 0xF9,
  0x02, 0x77, 0x0A, 0xA0, 0xA7, 0x10, 0x7F, 0x90, 0xC7, 0x50, 0x20, 0xCB, 0x06, 0x71, 0x01, 0x0E,
  0xF9, 0x0B, 0x01, 0x72, 0x08, 0xC0, 0xE0, 0x17, 0x20, 0x6F, 0xA8, 0x2E, 0x94, 0x12, 0x82, 0x25,
  0x9E, 0xD0, 0x77, 0x40, 0xAF, 0xFF, 0x90, 0xC7, 0x60, 0xCF, 0xFE, 0x0D, 0x02, 0x77, 0x0B, 0xFF,
  0xC0, 0xD0, 0x27, 0x72, 0x08, 0xFF, 0xA0, 0x90, 0x17, 0x74, 0x02, 0x0A, 0xFD, 0x0B, 0x03, 0x77,
  0x71, 0x83, 0x16, 0x9C, 0xEA, 0x83, 0xEC, 0xA6, 0x27, 0x70,
  // "é" (U+00E9)
  0x77, 0x77, 0x38, 0x05, 0x70, 0x17, 0x77, 0x72, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x30, 0xEF, 0x0E,
  0x02, 0x77, 0x77, 0x20, 0x8F, 0x90, 0x47, 0x77, 0x72, 0x02, 0xF9, 0x05, 0x77, 0x77, 0x30, 0xCF,
  0x06, 0x77, 0x77, 0x30, 0x6F, 0x07, 0x77, 0x77, 0x30, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x40, 0xBE,
  0x07, 0x77, 0x77, 0x40, 0x7E, 0x06, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x50, 0xDC, 0x0E,
  0x03, 0x77, 0x77, 0x50, 0xAC, 0x0C, 0x02, 0x77, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0x77, 0x70, 0xCA,
  0x0E, 0x05, 0x80, 0xBD, 0x20, 0x89, 0x11, 0x59, 0xCD, 0xEF, 0xEC, 0x95, 0x77, 0x77, 0x05, 0x0B,
  0xFC, 0x0E, 0x06, 0x77, 0x73, 0x03, 0x0C, 0xFF, 0x90, 0xA7, 0x77, 0x10, 0x9F, 0xFC, 0x09, 0x77,
  0x50, 0x20, 0xCE, 0x83, 0xEA, 0x76, 0x9F, 0xA0, 0x47, 0x73, 0x02, 0x0E, 0xE0, 0xA0, 0x14, 0x02,
  0x0E, 0xF0, 0xC7, 0x72, 0x03, 0x0E, 0xE0, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x02, 0x0E, 0xE0, 0x87,
  0x10, 0x1F, 0x90, 0x57, 0x60, 0x10, 0xDE, 0x0B, 0x73, 0x0D, 0xF0, 0x77, 0x60, 0xAE, 0x0E, 0x01,
  0x73, 0x0C, 0xF0, 0x97, 0x50, 0x6F, 0x06, 0x74, 0x0C, 0xF0, 0x87, 0x40, 0x10, 0xEE, 0x0D, 0x75,
  0x0D, 0xF0, 0x77, 0x40, 0xAF, 0x05, 0x75, 0xF9, 0x05, 0x73, 0x03, 0xF0, 0xC7, 0x50, 0x3F, 0x90,
  0x17, 0x30, 0xBF, 0x06, 0x75, 0x07, 0xF0, 0xD7, 0x30, 0x4F, 0x0E, 0x76, 0x0D, 0xF0, 0x77, 0x30,
  0xBF, 0x08, 0x75, 0x05, 0xF0, 0xE0, 0x17, 0x20, 0x2F, 0x90, 0x37, 0x40, 0x10, 0xDF, 0x07, 0x73,
  0x08, 0xF0, 0xD7, 0x50, 0xBF, 0x0D, 0x74, 0x0E, 0xF0, 0x87, 0x40, 0xAF, 0x0E, 0x02, 0x73, 0x03,
  0xF9, 0x03, 0x72, 0x01, 0x0B, 0xF9, 0x05, 0x74, 0x08, 0xF0, 0xE7, 0x20, 0x50, 0xDF, 0x90, 0x57,
  0x50, 0xCF, 0x0B, 0x70, 0x50, 0xCF, 0xA0, 0x57, 0x50, 0x1F, 0x90, 0x82, 0x83, 0x14, 0x6A, 0xEF,
  0xA0, 0xD0, 0x27, 0x60, 0x5F, 0xFF, 0xB0, 0x87, 0x71, 0x08, 0xFF, 0xF9, 0x0A, 0x02, 0x77, 0x20,
  0xBF, 0xFD, 0x81, 0xE8, 0x27, 0x74, 0x0D, 0xFF, 0x98, 0x2E, 0xC8, 0x47, 0x77, 0xF9, 0x86, 0xC6,
  0x66, 0x54, 0x31, 0x77, 0x73, 0x01, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x2F, 0x90, 0x67, 0x77, 0x73,
  0x03, 0xF9, 0x05, 0x77, 0x77, 0x30, 0x3F, 0x90, 0x57, 0x77, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x77,
  0x30, 0x1F, 0x90, 0x67, 0x77, 0x74, 0xF9, 0x07, 0x77, 0x77, 0x40, 0xDF, 0x0A, 0x77, 0x77, 0x40,
  0xBF, 0x0D, 0x77, 0x50, 0x17, 0x50, 0x7F, 0x90, 0x27, 0x73, 0x0A, 0x09, 0x75, 0x03, 0xF9, 0x08,
  0x77, 0x28, 0x19, 0xFB, 0x76, 0x0D, 0xF9, 0x02, 0x77, 0x0A, 0xA0, 0xA7, 0x60, 0x7F, 0x90, 0xC7,
  0x50, 0x20, 0xCB, 0x06, 0x76, 0x01, 0x0E, 0xF9, 0x0B, 0x01, 0x72, 0x08, 0xC0, 0xE0, 0x17, 0x70,
  0x6F, 0xA8, 0x2E, 0x94, 0x12, 0x82, 0x25, 0x9E, 0xD0, 0x77, 0x72, 0x0A, 0xFF, 0xF9, 0x0C, 0x77,
  0x40, 0xCF, 0xFE, 0x0D, 0x02, 0x77, 0x50, 0xBF, 0xFC, 0x0D, 0x02, 0x77, 0x70, 0x8F, 0xFA, 0x09,
  0x01, 0x77, 0x72, 0x02, 0x0A, 0xFD, 0x0B, 0x03, 0x77, 0x76, 0x83, 0x16, 0x9C, 0xEA, 0x83, 0xEC,
  0xA6, 0x27, 0x75,
  // "ê" (U+00EA)
  0x77, 0x73, 0x80, 0x47, 0x77, 0x77, 0x09, 0xF9, 0x03, 0x77, 0x75, 0x04, 0xFA, 0x07, 0x77, 0x74,
  0x01, 0x0E, 0xFA, 0x0B, 0x77, 0x74, 0x0C, 0xFC, 0x01, 0x77, 0x72, 0x09, 0xFD, 0x07, 0x77, 0x71,
  0x06, 0xE0, 0xB0, 0xDD, 0x0C, 0x77, 0x70, 0x3E, 0x81, 0xA0, 0x4E, 0x02, 0x77, 0x50, 0x20, 0xED,
  0x09, 0x30, 0xAD, 0x09, 0x77, 0x50, 0xCD, 0x08, 0x40, 0x10, 0xEC, 0x0E, 0x77, 0x40, 0xBD, 0x07,
  0x60, 0x5D, 0x07, 0x77, 0x20, 0x9C, 0x0E, 0x05, 0x71, 0x09, 0xC0, 0xD7, 0x71, 0x07, 0xC0, 0xD0,
  0x27, 0x30, 0xBC, 0x05, 0x76, 0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x76, 0x0C, 0xA0,
  0xD0, 0x47, 0x70, 0x10, 0xCA, 0x0D, 0x80, 0xB9, 0x00, 0x89, 0x11, 0x59, 0xCD, 0xEF, 0xEC, 0x95,
  0x77, 0x73, 0x05, 0x0B, 0xFC, 0x0E, 0x06, 0x77, 0x60, 0x30, 0xCF, 0xF9, 0x0A, 0x77, 0x40, 0x9F,
  0xFC, 0x09, 0x77, 0x10, 0x20, 0xCE, 0x83, 0xEA, 0x76, 0x9F, 0xA0, 0x47, 0x60, 0x20, 0xEE, 0x0A,
  0x01, 0x40, 0x20, 0xEF, 0x0C, 0x75, 0x03, 0x0E, 0xE0, 0x77, 0x06, 0xF9, 0x01, 0x73, 0x02, 0x0E,
  0xE0, 0x87, 0x10, 0x1F, 0x90, 0x57, 0x20, 0x10, 0xDE, 0x0B, 0x73, 0x0D, 0xF0, 0x77, 0x20, 0xAE,
  0x0E, 0x01, 0x73, 0x0C, 0xF0, 0x97, 0x10, 0x6F, 0x06, 0x74, 0x0C, 0xF0, 0x87, 0x01, 0x0E, 0xE0,
  0xD7, 0x50, 0xDF, 0x07, 0x70, 0xAF, 0x05, 0x75, 0xF9, 0x05, 0x60, 0x3F, 0x0C, 0x75, 0x03, 0xF9,
  0x01, 0x60, 0xBF, 0x06, 0x75, 0x07, 0xF0, 0xD6, 0x04, 0xF0, 0xE7, 0x60, 0xDF, 0x07, 0x60, 0xBF,
  0x08, 0x75, 0x05, 0xF0, 0xE0, 0x15, 0x02, 0xF9, 0x03, 0x74, 0x01, 0x0D, 0xF0, 0x76, 0x08, 0xF0,
  0xD7, 0x50, 0xBF, 0x0D, 0x70, 0xEF, 0x08, 0x74, 0x0A, 0xF0, 0xE0, 0x26, 0x03, 0xF9, 0x03, 0x72,
  0x01, 0x0B, 0xF9, 0x05, 0x70, 0x8F, 0x0E, 0x72, 0x05, 0x0D, 0xF9, 0x05, 0x71, 0x0C, 0xF0, 0xB7,
  0x05, 0x0C, 0xFA, 0x05, 0x71, 0x01, 0xF9, 0x08, 0x28, 0x31, 0x46, 0xAE, 0xFA, 0x0D, 0x02, 0x72,
  0x05, 0xFF, 0xFB, 0x08, 0x74, 0x08, 0xFF, 0xF9, 0x0A, 0x02, 0x75, 0x0B, 0xFF, 0xD8, 0x1E, 0x82,
  0x77, 0x0D, 0xFF, 0x98, 0x2E, 0xC8, 0x47, 0x73, 0xF9, 0x86, 0xC6, 0x66, 0x54, 0x31, 0x77, 0x60,
  0x1F, 0x90, 0x87, 0x77, 0x60, 0x2F, 0x90, 0x67, 0x77, 0x60, 0x3F, 0x90, 0x57, 0x77, 0x60, 0x3F,
  0x90, 0x57, 0x77, 0x60, 0x2F, 0x90, 0x57, 0x77, 0x60, 0x1F, 0x90, 0x67, 0x77, 0x7F, 0x90, 0x77,
  0x77, 0x70, 0xDF, 0x0A, 0x77, 0x77, 0x0B, 0xF0, 0xD7, 0x75, 0x01, 0x71, 0x07, 0xF9, 0x02, 0x77,
  0x30, 0xA0, 0x97, 0x10, 0x3F, 0x90, 0x87, 0x72, 0x81, 0x9F, 0xB7, 0x20, 0xDF, 0x90, 0x27, 0x70,
  0xAA, 0x0A, 0x72, 0x07, 0xF9, 0x0C, 0x75, 0x02, 0x0C, 0xB0, 0x67, 0x20, 0x10, 0xEF, 0x90, 0xB0,
  0x17, 0x20, 0x8C, 0x0E, 0x01, 0x73, 0x06, 0xFA, 0x82, 0xE9, 0x41, 0x28, 0x22, 0x59, 0xED, 0x07,
  0x75, 0x0A, 0xFF, 0xF9, 0x0C, 0x77, 0x0C, 0xFF, 0xE0, 0xD0, 0x27, 0x71, 0x0B, 0xFF, 0xC0, 0xD0,
  0x27, 0x73, 0x08, 0xFF, 0xA0, 0x90, 0x17, 0x75, 0x02, 0x0A, 0xFD, 0x0B, 0x03, 0x77, 0x72, 0x83,
  0x16, 0x9C, 0xEA, 0x83, 0xEC, 0xA6, 0x27, 0x71,
  // "ë" (U+00EB)
  0x77, 0x28, 0x35, 0xCF, 0xD7, 0x73, 0x83, 0x6D, 0xFD, 0x77, 0x73, 0x07, 0xD0, 0x97, 0x10, 0x8D,
  0x08, 0x77, 0x10, 0x2F, 0x01, 0x60, 0x2E, 0x0E, 0x77, 0x10, 0x7F, 0x03, 0x60, 0x8F, 0x02, 0x77,
  0x0B, 0xF0, 0x46, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x60, 0xDF, 0x02, 0x77, 0x0B, 0xF7, 0x0C,
  0xF7, 0x71, 0x09, 0xE0, 0xB7, 0x0A, 0xE0, 0xA7, 0x71, 0x02, 0xD0, 0xE0, 0x27, 0x03, 0xD0, 0xD0,
  0x17, 0x72, 0x84, 0x3B, 0xEE, 0xA1, 0x72, 0x84, 0x4C, 0xFE, 0x91, 0x80, 0xD8, 0x10, 0x89, 0x11,
  0x59, 0xCD, 0xEF, 0xEC, 0x95, 0x77, 0x74, 0x05, 0x0B, 0xFC, 0x0E, 0x06, 0x77, 0x70, 0x30, 0xCF,
  0xF9, 0x0A, 0x77, 0x50, 0x9F, 0xFC, 0x09, 0x77, 0x20, 0x20, 0xCE, 0x83, 0xEA, 0x76, 0x9F, 0xA0,
  0x47, 0x70, 0x20, 0xEE, 0x0A, 0x01, 0x40, 0x20, 0xEF, 0x0C, 0x76, 0x03, 0x0E, 0xE0, 0x77, 0x06,
  0xF9, 0x01, 0x74, 0x02, 0x0E, 0xE0, 0x87, 0x10, 0x1F, 0x90, 0x57, 0x30, 0x10, 0xDE, 0x0B, 0x73,
  0x0D, 0xF0, 0x77, 0x30, 0xAE, 0x0E, 0x01, 0x73, 0x0C, 0xF0, 0x97, 0x20, 0x6F, 0x06, 0x74, 0x0C,
  0xF0, 0x87, 0x10, 0x10, 0xEE, 0x0D, 0x75, 0x0D, 0xF0, 0x77, 0x10, 0xAF, 0x05, 0x75, 0xF9, 0x05,
  0x70, 0x3F, 0x0C, 0x75, 0x03, 0xF9, 0x01, 0x70, 0xBF, 0x06, 0x75, 0x07, 0xF0, 0xD7, 0x04, 0xF0,
  0xE7, 0x60, 0xDF, 0x07, 0x70, 0xBF, 0x08, 0x75, 0x05, 0xF0, 0xE0, 0x16, 0x02, 0xF9, 0x03, 0x74,
  0x01, 0x0D, 0xF0, 0x77, 0x08, 0xF0, 0xD7, 0x50, 0xBF, 0x0D, 0x71, 0x0E, 0xF0, 0x87, 0x40, 0xAF,
  0x0E, 0x02, 0x70, 0x3F, 0x90, 0x37, 0x20, 0x10, 0xBF, 0x90, 0x57, 0x10, 0x8F, 0x0E, 0x72, 0x05,
  0x0D, 0xF9, 0x05, 0x72, 0x0C, 0xF0, 0xB7, 0x05, 0x0C, 0xFA, 0x05, 0x72, 0x01, 0xF9, 0x08, 0x28,
  0x31, 0x46, 0xAE, 0xFA, 0x0D, 0x02, 0x73, 0x05, 0xFF, 0xFB, 0x08, 0x75, 0x08, 0xFF, 0xF9, 0x0A,
  0x02, 0x76, 0x0B, 0xFF, 0xD8, 0x1E, 0x82, 0x77, 0x10, 0xDF, 0xF9, 0x82, 0xEC, 0x84, 0x77, 0x4F,
  0x98, 0x6C, 0x66, 0x65, 0x43, 0x17, 0x77, 0x01, 0xF9, 0x08, 0x77, 0x77, 0x02, 0xF9, 0x06, 0x77,
  0x77, 0x03, 0xF9, 0x05, 0x77, 0x77, 0x03, 0xF9, 0x05, 0x77, 0x77, 0x02, 0xF9, 0x05, 0x77, 0x77,
  0x01, 0xF9, 0x06, 0x77, 0x77, 0x1F, 0x90, 0x77, 0x77, 0x71, 0x0D, 0xF0, 0xA7, 0x77, 0x71, 0x0B,
  0xF0, 0xD7, 0x75, 0x01, 0x72, 0x07, 0xF9, 0x02, 0x77, 0x30, 0xA0, 0x97, 0x20, 0x3F, 0x90, 0x87,
  0x72, 0x81, 0x9F, 0xB7, 0x30, 0xDF, 0x90, 0x27, 0x70, 0xAA, 0x0A, 0x73, 0x07, 0xF9, 0x0C, 0x75,
  0x02, 0x0C, 0xB0, 0x67, 0x30, 0x10, 0xEF, 0x90, 0xB0, 0x17, 0x20, 0x8C, 0x0E, 0x01, 0x74, 0x06,
  0xFA, 0x82, 0xE9, 0x41, 0x28, 0x22, 0x59, 0xED, 0x07, 0x76, 0x0A, 0xFF, 0xF9, 0x0C, 0x77, 0x10,
  0xCF, 0xFE, 0x0D, 0x02, 0x77, 0x20, 0xBF, 0xFC, 0x0D, 0x02, 0x77, 0x40, 0x8F, 0xFA, 0x09, 0x01,
  0x77, 0x60, 0x20, 0xAF, 0xD0, 0xB0, 0x37, 0x77, 0x38, 0x31, 0x69, 0xCE, 0xA8, 0x3E, 0xCA, 0x62,
  0x77, 0x20,
  // "ì" (U+00EC)
  0x30, 0x68, 0x03, 0x70, 0x47, 0x20, 0xEF, 0x0C, 0x72, 0x06, 0xF9, 0x02, 0x72, 0x0C, 0xF0, 0x77,
  0x20, 0x2F, 0x0C, 0x73, 0x07, 0xF0, 0x27, 0x30, 0xCE, 0x08, 0x73, 0x01, 0x0E, 0xD0, 0xE7, 0x40,
  0x5E, 0x05, 0x74, 0x08, 0xD0, 0xB7, 0x50, 0xBD, 0x01, 0x74, 0x01, 0x0D, 0xC0, 0x77, 0x50, 0x30,
  0xEB, 0x0D, 0x76, 0x04, 0xC0, 0x47, 0x60, 0x6B, 0x04, 0x80, 0x9D, 0x20, 0x02, 0xFF, 0x06, 0x20,
  0x5F, 0xF0, 0x32, 0x08, 0xFF, 0x30, 0xCF, 0xE0, 0xC5, 0x81, 0x15, 0xBF, 0xA0, 0x87, 0x10, 0xCF,
  0x90, 0x57, 0x10, 0x7F, 0x90, 0x27, 0x10, 0x7F, 0x0E, 0x72, 0x07, 0xF0, 0xB7, 0x20, 0xAF, 0x07,
  0x72, 0x0C, 0xF0, 0x47, 0x2F, 0x90, 0x17, 0x10, 0x3F, 0x0D, 0x72, 0x06, 0xF0, 0xA7, 0x20, 0xAF,
  0x07, 0x72, 0x0D, 0xF0, 0x37, 0x10, 0x1F, 0x97, 0x20, 0x4F, 0x0C, 0x72, 0x07, 0xF0, 0x97, 0x20,
  0xBF, 0x06, 0x72, 0x0E, 0xF0, 0x27, 0x10, 0x2F, 0x0E, 0x72, 0x05, 0xF0, 0xB7, 0x20, 0x8F, 0x08,
  0x72, 0x0B, 0xF0, 0x57, 0x20, 0xEF, 0x02, 0x71, 0x02, 0xF0, 0xE7, 0x20, 0x5F, 0x0B, 0x72, 0x08,
  0xF0, 0x77, 0x20, 0xBF, 0x04, 0x72, 0x0E, 0xF0, 0x17, 0x10, 0x1F, 0x0E, 0x72, 0x03, 0xF0, 0xB7,
  0x20, 0x6F, 0x09, 0x72, 0x08, 0xF0, 0x67, 0x20, 0xBF, 0x04, 0x72, 0x0D, 0xF0, 0x17, 0x2F, 0x97,
  0x20, 0x1F, 0x0E, 0x72, 0x02, 0xF0, 0xD7, 0x20, 0x3F, 0x0D, 0x72, 0x03, 0xF9, 0x78, 0x12, 0x01,
  0xF9, 0x04, 0x58, 0x38, 0xF5, 0x0E, 0xF8, 0x4D, 0x30, 0x27, 0xEA, 0x81, 0xD0, 0x9F, 0xF9, 0x81,
  0xB0, 0x2F, 0xF0, 0x83, 0x08, 0xFC, 0x0C, 0x03, 0x50, 0xAF, 0x90, 0xE0, 0x77, 0x18, 0x64, 0xAE,
  0xFE, 0xC9, 0x56,
  // "í" (U+00ED)
  0x77, 0x48, 0x05, 0x70, 0x17, 0x73, 0x06, 0xF9, 0x0D, 0x77, 0x40, 0xEF, 0x0E, 0x02, 0x77, 0x30,
  0x8F, 0x90, 0x47, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x40, 0xCF, 0x06, 0x77, 0x40, 0x6F, 0x07, 0x77,
  0x40, 0x10, 0xEE, 0x07, 0x77, 0x50, 0xBE, 0x07, 0x77, 0x50, 0x7E, 0x06, 0x77, 0x50, 0x2E, 0x05,
  0x77, 0x60, 0xDC, 0x0E, 0x03, 0x77, 0x60, 0xAC, 0x0C, 0x02, 0x77, 0x60, 0x6C, 0x0A, 0x77, 0x71,
  0x0C, 0xA0, 0xE0, 0x58, 0x0A, 0xE3, 0x00, 0x2F, 0xF0, 0x67, 0x50, 0x5F, 0xF0, 0x37, 0x50, 0x8F,
  0xF7, 0x60, 0xCF, 0xE0, 0xC7, 0x71, 0x81, 0x15, 0xBF, 0xA0, 0x87, 0x74, 0x0C, 0xF9, 0x05, 0x77,
  0x40, 0x7F, 0x90, 0x27, 0x74, 0x07, 0xF0, 0xE7, 0x75, 0x07, 0xF0, 0xB7, 0x75, 0x0A, 0xF0, 0x77,
  0x75, 0x0C, 0xF0, 0x47, 0x75, 0xF9, 0x01, 0x77, 0x40, 0x3F, 0x0D, 0x77, 0x50, 0x6F, 0x0A, 0x77,
  0x50, 0xAF, 0x07, 0x77, 0x50, 0xDF, 0x03, 0x77, 0x40, 0x1F, 0x97, 0x75, 0x04, 0xF0, 0xC7, 0x75,
  0x07, 0xF0, 0x97, 0x75, 0x0B, 0xF0, 0x67, 0x75, 0x0E, 0xF0, 0x27, 0x74, 0x02, 0xF0, 0xE7, 0x75,
  0x05, 0xF0, 0xB7, 0x75, 0x08, 0xF0, 0x87, 0x75, 0x0B, 0xF0, 0x57, 0x75, 0x0E, 0xF0, 0x27, 0x74,
  0x02, 0xF0, 0xE7, 0x75, 0x05, 0xF0, 0xB7, 0x75, 0x08, 0xF0, 0x77, 0x75, 0x0B, 0xF0, 0x47, 0x75,
  0x0E, 0xF0, 0x17, 0x74, 0x01, 0xF0, 0xE7, 0x75, 0x03, 0xF0, 0xB7, 0x75, 0x06, 0xF0, 0x97, 0x75,
  0x08, 0xF0, 0x67, 0x75, 0x0B, 0xF0, 0x47, 0x75, 0x0D, 0xF0, 0x17, 0x75, 0xF9, 0x77, 0x50, 0x1F,
  0x0E, 0x77, 0x50, 0x2F, 0x0D, 0x77, 0x50, 0x3F, 0x0D, 0x77, 0x50, 0x3F, 0x97, 0x02, 0x74, 0x01,
  0xF9, 0x04, 0x58, 0x18, 0xF5, 0x74, 0x0E, 0xF8, 0x4D, 0x30, 0x27, 0xEA, 0x0D, 0x74, 0x09, 0xFF,
  0x90, 0xB7, 0x40, 0x2F, 0xF0, 0x87, 0x60, 0x8F, 0xC0, 0xC0, 0x37, 0x71, 0x0A, 0xF9, 0x0E, 0x07,
  0x77, 0x48, 0x64, 0xAE, 0xFE, 0xC9, 0x57, 0x72,
  // "î" (U+00EE)
  0x74, 0x80, 0x47, 0x77, 0x10, 0x9F, 0x90, 0x37, 0x60, 0x4F, 0xA0, 0x77, 0x50, 0x10, 0xEF, 0xA0,
  0xB7, 0x50, 0xCF, 0xC0, 0x17, 0x30, 0x9F, 0xD0, 0x77, 0x20, 0x6E, 0x0B, 0x0D, 0xD0, 0xC7, 0x10,
  0x3E, 0x81, 0xA0, 0x4E, 0x02, 0x60, 0x20, 0xED, 0x09, 0x30, 0xAD, 0x09, 0x60, 0xCD, 0x08, 0x40,
  0x10, 0xEC, 0x0E, 0x50, 0xBD, 0x07, 0x60, 0x5D, 0x07, 0x30, 0x9C, 0x0E, 0x05, 0x71, 0x09, 0xC0,
  0xD2, 0x07, 0xC0, 0xD0, 0x27, 0x30, 0xBC, 0x00, 0x5C, 0x0A, 0x01, 0x74, 0x01, 0x0C, 0xB0, 0xD0,
  0xCA, 0x0D, 0x04, 0x77, 0x01, 0x0C, 0xA0, 0xD8, 0x0A, 0x96, 0x00, 0x2F, 0xF0, 0x67, 0x10, 0x5F,
  0xF0, 0x37, 0x10, 0x8F, 0xF7, 0x20, 0xCF, 0xE0, 0xC7, 0x48, 0x11, 0x5B, 0xFA, 0x08, 0x77, 0x0C,
  0xF9, 0x05, 0x77, 0x07, 0xF9, 0x02, 0x77, 0x07, 0xF0, 0xE7, 0x71, 0x07, 0xF0, 0xB7, 0x71, 0x0A,
  0xF0, 0x77, 0x71, 0x0C, 0xF0, 0x47, 0x71, 0xF9, 0x01, 0x77, 0x03, 0xF0, 0xD7, 0x71, 0x06, 0xF0,
  0xA7, 0x71, 0x0A, 0xF0, 0x77, 0x71, 0x0D, 0xF0, 0x37, 0x70, 0x1F, 0x97, 0x71, 0x04, 0xF0, 0xC7,
  0x71, 0x07, 0xF0, 0x97, 0x71, 0x0B, 0xF0, 0x67, 0x71, 0x0E, 0xF0, 0x27, 0x70, 0x2F, 0x0E, 0x77,
  0x10, 0x5F, 0x0B, 0x77, 0x10, 0x8F, 0x08, 0x77, 0x10, 0xBF, 0x05, 0x77, 0x10, 0xEF, 0x02, 0x77,
  0x02, 0xF0, 0xE7, 0x71, 0x05, 0xF0, 0xB7, 0x71, 0x08, 0xF0, 0x77, 0x71, 0x0B, 0xF0, 0x47, 0x71,
  0x0E, 0xF0, 0x17, 0x70, 0x1F, 0x0E, 0x77, 0x10, 0x3F, 0x0B, 0x77, 0x10, 0x6F, 0x09, 0x77, 0x10,
  0x8F, 0x06, 0x77, 0x10, 0xBF, 0x04, 0x77, 0x10, 0xDF, 0x01, 0x77, 0x1F, 0x97, 0x71, 0x01, 0xF0,
  0xE7, 0x71, 0x02, 0xF0, 0xD7, 0x71, 0x03, 0xF0, 0xD7, 0x71, 0x03, 0xF9, 0x70, 0x27, 0x01, 0xF9,
  0x04, 0x58, 0x18, 0xF5, 0x70, 0xEF, 0x84, 0xD3, 0x02, 0x7E, 0xA0, 0xD7, 0x09, 0xFF, 0x90, 0xB7,
  0x02, 0xFF, 0x08, 0x72, 0x08, 0xFC, 0x0C, 0x03, 0x74, 0x0A, 0xF9, 0x0E, 0x07, 0x77, 0x86, 0x4A,
  0xEF, 0xEC, 0x95, 0x74,
  // "ï" (U+00EF)
  0x38, 0x35, 0xCF, 0xD7, 0x73, 0x83, 0x6D, 0xFD, 0x74, 0x07, 0xD0, 0x97, 0x10, 0x8D, 0x08, 0x20,
  0x2F, 0x01, 0x60, 0x2E, 0x0E, 0x20, 0x7F, 0x03, 0x60, 0x8F, 0x81, 0x20, 0xBF, 0x04, 0x60, 0xCF,
  0x81, 0x30, 0xCF, 0x03, 0x60, 0xDF, 0x81, 0x20, 0xBF, 0x70, 0xCF, 0x20, 0x9E, 0x0B, 0x70, 0xAE,
  0x0A, 0x20, 0x2D, 0x0E, 0x02, 0x70, 0x3D, 0x0D, 0x01, 0x38, 0x43, 0xBE, 0xEA, 0x17, 0x28, 0x44,
  0xCF, 0xE9, 0x18, 0x0B, 0xC0, 0x00, 0x2F, 0xF0, 0x67, 0x20, 0x5F, 0xF0, 0x37, 0x20, 0x8F, 0xF7,
  0x30, 0xCF, 0xE0, 0xC7, 0x58, 0x11, 0x5B, 0xFA, 0x08, 0x77, 0x10, 0xCF, 0x90, 0x57, 0x71, 0x07,
  0xF9, 0x02, 0x77, 0x10, 0x7F, 0x0E, 0x77, 0x20, 0x7F, 0x0B, 0x77, 0x20, 0xAF, 0x07, 0x77, 0x20,
  0xCF, 0x04, 0x77, 0x2F, 0x90, 0x17, 0x71, 0x03, 0xF0, 0xD7, 0x72, 0x06, 0xF0, 0xA7, 0x72, 0x0A,
  0xF0, 0x77, 0x72, 0x0D, 0xF0, 0x37, 0x71, 0x01, 0xF9, 0x77, 0x20, 0x4F, 0x0C, 0x77, 0x20, 0x7F,
  0x09, 0x77, 0x20, 0xBF, 0x06, 0x77, 0x20, 0xEF, 0x02, 0x77, 0x10, 0x2F, 0x0E, 0x77, 0x20, 0x5F,
  0x0B, 0x77, 0x20, 0x8F, 0x08, 0x77, 0x20, 0xBF, 0x05, 0x77, 0x20, 0xEF, 0x02, 0x77, 0x10, 0x2F,
  0x0E, 0x77, 0x20, 0x5F, 0x0B, 0x77, 0x20, 0x8F, 0x07, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x20, 0xEF,
  0x01, 0x77, 0x10, 0x1F, 0x0E, 0x77, 0x20, 0x3F, 0x0B, 0x77, 0x20, 0x6F, 0x09, 0x77, 0x20, 0x8F,
  0x06, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x20, 0xDF, 0x01, 0x77, 0x2F, 0x97, 0x72, 0x01, 0xF0, 0xE7,
  0x72, 0x02, 0xF0, 0xD7, 0x72, 0x03, 0xF0, 0xD7, 0x72, 0x03, 0xF9, 0x70, 0x27, 0x10, 0x1F, 0x90,
  0x45, 0x81, 0x8F, 0x57, 0x10, 0xEF, 0x84, 0xD3, 0x02, 0x7E, 0xA0, 0xD7, 0x10, 0x9F, 0xF9, 0x0B,
  0x71, 0x02, 0xFF, 0x08, 0x73, 0x08, 0xFC, 0x0C, 0x03, 0x75, 0x0A, 0xF9, 0x0E, 0x07, 0x77, 0x18,
  0x64, 0xAE, 0xFE, 0xC9, 0x57, 0x60,
  // "ð" (U+00F0)
  0x80, 0xC4, 0x00, 0x17, 0x72, 0x82, 0x8E, 0x83, 0x77, 0x48, 0x14, 0xD2, 0x77, 0x20, 0xDB, 0x0B,
  0x04, 0x77, 0x82, 0x2B, 0xFE, 0x77, 0x20, 0x2E, 0x0B, 0x03, 0x73, 0x01, 0x08, 0xB0, 0xA7, 0x72,
  0x07, 0xF9, 0x08, 0x71, 0x06, 0x0E, 0xC0, 0x77, 0x72, 0x04, 0x0B, 0xF9, 0x0C, 0x02, 0x40, 0x30,
  0xCE, 0x03, 0x77, 0x40, 0x20, 0xBF, 0x83, 0xE3, 0x02, 0xAE, 0x0C, 0x04, 0x77, 0x70, 0x40, 0xDF,
  0x09, 0xE0, 0xE0, 0x67, 0x77, 0x40, 0x9F, 0xD0, 0x90, 0x17, 0x77, 0x60, 0x6F, 0xA0, 0xB0, 0x27,
  0x77, 0x71, 0x01, 0x0C, 0xF0, 0x77, 0x77, 0x72, 0x07, 0x0E, 0xF9, 0x0D, 0x01, 0x77, 0x76, 0x05,
  0x0D, 0xFC, 0x0A, 0x77, 0x74, 0x03, 0x0C, 0xE0, 0xC0, 0xBE, 0x05, 0x77, 0x72, 0x09, 0xE8, 0x3E,
  0x50, 0x1E, 0xD0, 0xE0, 0x17, 0x77, 0x04, 0xE0, 0x84, 0x06, 0xE0, 0x87, 0x77, 0x07, 0xC0, 0xA0,
  0x26, 0x0D, 0xE0, 0x17, 0x76, 0x0B, 0xA0, 0xC0, 0x47, 0x10, 0x5E, 0x08, 0x77, 0x68, 0x1E, 0xE6,
  0x74, 0x0D, 0xD0, 0xE0, 0x17, 0x74, 0x81, 0x28, 0x17, 0x50, 0x8E, 0x07, 0x77, 0x77, 0x50, 0x3E,
  0x0C, 0x77, 0x77, 0x60, 0xDE, 0x03, 0x77, 0x77, 0x50, 0x8E, 0x08, 0x77, 0x72, 0x85, 0x24, 0x56,
  0x54, 0x23, 0x05, 0xE0, 0xC7, 0x75, 0x82, 0x16, 0xBE, 0xF8, 0x2E, 0x92, 0x1F, 0x01, 0x77, 0x20,
  0x10, 0x9F, 0xF0, 0x70, 0xEE, 0x05, 0x77, 0x10, 0x7F, 0xFF, 0xB0, 0x87, 0x60, 0x10, 0xBF, 0xFF,
  0xC0, 0xB7, 0x50, 0x20, 0xDF, 0x98, 0x5A, 0x51, 0x01, 0x39, 0xFC, 0x0E, 0x74, 0x03, 0x0E, 0xF0,
  0xB0, 0x27, 0x03, 0x0E, 0xFB, 0x01, 0x72, 0x02, 0x0E, 0xF0, 0x97, 0x30, 0x3F, 0xB0, 0x27, 0x20,
  0xDF, 0x09, 0x75, 0x09, 0xFA, 0x04, 0x71, 0x09, 0xF0, 0xB7, 0x60, 0x2F, 0xA0, 0x57, 0x05, 0xF0,
  0xE0, 0x17, 0x70, 0xDF, 0x90, 0x67, 0x0E, 0xF0, 0x67, 0x71, 0x09, 0xF9, 0x06, 0x60, 0x8F, 0x0D,
  0x77, 0x20, 0x7F, 0x90, 0x75, 0x01, 0xF9, 0x06, 0x77, 0x20, 0x5F, 0x90, 0x75, 0x08, 0xF0, 0xD7,
  0x73, 0x04, 0xF9, 0x07, 0x40, 0x10, 0xEF, 0x07, 0x77, 0x30, 0x4F, 0x90, 0x64, 0x06, 0xF9, 0x01,
  0x77, 0x30, 0x4F, 0x90, 0x54, 0x0C, 0xF0, 0xB7, 0x74, 0x04, 0xF9, 0x04, 0x30, 0x2F, 0x90, 0x67,
  0x74, 0x05, 0xF9, 0x02, 0x30, 0x7F, 0x90, 0x17, 0x74, 0x06, 0xF9, 0x01, 0x30, 0xCF, 0x0D, 0x77,
  0x50, 0x8F, 0x0E, 0x4F, 0x90, 0x97, 0x75, 0x0A, 0xF0, 0xC3, 0x04, 0xF9, 0x05, 0x77, 0x50, 0xCF,
  0x09, 0x30, 0x7F, 0x90, 0x27, 0x75, 0x0E, 0xF0, 0x73, 0x0A, 0xF9, 0x77, 0x50, 0x2F, 0x90, 0x33,
  0x0D, 0xF0, 0xC7, 0x75, 0x05, 0xF9, 0x4F, 0x90, 0xB7, 0x75, 0x08, 0xF0, 0xC3, 0x01, 0xF9, 0x09,
  0x77, 0x50, 0xCF, 0x07, 0x30, 0x2F, 0x90, 0x77, 0x74, 0x01, 0xF9, 0x03, 0x30, 0x2F, 0x90, 0x67,
  0x74, 0x05, 0xF0, 0xD4, 0x03, 0xF9, 0x06, 0x77, 0x40, 0xBF, 0x08, 0x40, 0x2F, 0x90, 0x57, 0x73,
  0x01, 0xF9, 0x02, 0x40, 0x2F, 0x90, 0x57, 0x73, 0x06, 0xF0, 0xB6, 0xF9, 0x06, 0x77, 0x30, 0xDF,
  0x04, 0x60, 0xEF, 0x06, 0x77, 0x20, 0x6F, 0x0C, 0x70, 0xBF, 0x09, 0x77, 0x20, 0xDF, 0x03, 0x70,
  0x7F, 0x0B, 0x77, 0x10, 0x7F, 0x0A, 0x71, 0x02, 0xF9, 0x77, 0x02, 0x0E, 0xE0, 0xE0, 0x17, 0x20,
  0xCF, 0x05, 0x76, 0x0C, 0xF0, 0x57, 0x30, 0x5F, 0x0D, 0x75, 0x0B, 0xF0, 0x87, 0x50, 0xCF, 0x09,
  0x72, 0x01, 0x0C, 0xF0, 0xA7, 0x60, 0x20, 0xEF, 0x0A, 0x01, 0x60, 0x60, 0xEF, 0x0A, 0x77, 0x10,
  0x5F, 0xA8, 0x4A, 0x76, 0x7A, 0xEF, 0x90, 0x87, 0x73, 0x05, 0xFF, 0xE0, 0xE0, 0x47, 0x75, 0x03,
  0x0C, 0xFF, 0xB0, 0x80, 0x17, 0x77, 0x10, 0x60, 0xDF, 0xD8, 0x1D, 0x81, 0x77, 0x75, 0x89, 0x23,
  0x8B, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x75,
  // "ñ" (U+00F1)
  0x77, 0x48, 0x61, 0x7C, 0xEF, 0xDB, 0x57, 0x50, 0x20, 0xF4, 0x77, 0x40, 0x70, 0xEF, 0x0D, 0x03,
  0x73, 0x0C, 0xA0, 0xD7, 0x73, 0x09, 0xFC, 0x05, 0x71, 0x02, 0xB0, 0x97, 0x72, 0x08, 0xFE, 0x07,
  0x70, 0x9B, 0x03, 0x77, 0x10, 0x4F, 0xF9, 0x09, 0x50, 0x2B, 0x0C, 0x77, 0x20, 0xDB, 0x83, 0xA3,
  0x02, 0x8F, 0x98, 0x4C, 0x41, 0x15, 0xEB, 0x04, 0x77, 0x10, 0x5B, 0x0A, 0x50, 0x40, 0xEF, 0xF0,
  0xA7, 0x72, 0x0C, 0xB0, 0x26, 0x02, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x10, 0x3B, 0x09, 0x71, 0x01,
  0x0C, 0xFB, 0x0E, 0x02, 0x77, 0x20, 0x7B, 0x03, 0x73, 0x08, 0xF9, 0x0C, 0x02, 0x77, 0x30, 0x20,
  0xF4, 0x75, 0x86, 0x28, 0xCE, 0xED, 0xA5, 0x80, 0xBE, 0x50, 0x87, 0x59, 0xDE, 0xFD, 0xB7, 0x17,
  0x30, 0x8F, 0xF7, 0x06, 0x0D, 0xF9, 0x0E, 0x06, 0x72, 0x0C, 0xFE, 0x0C, 0x50, 0x10, 0xAF, 0xD0,
  0x57, 0x1F, 0xF0, 0xA4, 0x01, 0x0D, 0xFE, 0x0E, 0x01, 0x60, 0x3F, 0xF0, 0x73, 0x01, 0x0D, 0xFF,
  0x90, 0x77, 0x18, 0x11, 0x49, 0xFB, 0x04, 0x30, 0xCF, 0xFA, 0x0D, 0x74, 0x03, 0xFA, 0x02, 0x20,
  0xAB, 0x84, 0xE7, 0x20, 0x16, 0xFA, 0x02, 0x74, 0x0B, 0xF9, 0x20, 0x6B, 0x0B, 0x01, 0x50, 0x8F,
  0x90, 0x57, 0x40, 0x9F, 0x82, 0xC0, 0x2E, 0xA0, 0x97, 0x03, 0xF9, 0x06, 0x74, 0x09, 0xF8, 0x1A,
  0x0C, 0xA0, 0x97, 0x2F, 0x90, 0x77, 0x40, 0xBF, 0x07, 0x06, 0xA0, 0xB7, 0x30, 0xEF, 0x06, 0x74,
  0x0D, 0xF8, 0x37, 0xEF, 0xD1, 0x73, 0x0E, 0xF0, 0x57, 0x30, 0x1F, 0xC0, 0x37, 0x4F, 0x90, 0x37,
  0x30, 0x4F, 0xB0, 0x87, 0x40, 0x1F, 0x90, 0x17, 0x30, 0x7F, 0xA0, 0xE0, 0x17, 0x40, 0x3F, 0x0E,
  0x74, 0x0A, 0xFA, 0x06, 0x75, 0x06, 0xF0, 0xB7, 0x40, 0xEF, 0x90, 0xC7, 0x60, 0x9F, 0x07, 0x73,
  0x01, 0xFA, 0x05, 0x76, 0x0C, 0xF0, 0x47, 0x30, 0x5F, 0x90, 0xD7, 0x70, 0xEF, 0x01, 0x73, 0x08,
  0xF9, 0x05, 0x76, 0x02, 0xF0, 0xE7, 0x40, 0xBF, 0x0E, 0x77, 0x05, 0xF0, 0xA7, 0x40, 0xEF, 0x08,
  0x77, 0x09, 0xF0, 0x77, 0x30, 0x2F, 0x90, 0x27, 0x70, 0xCF, 0x04, 0x73, 0x06, 0xF0, 0xD7, 0x71,
  0xF9, 0x01, 0x73, 0x09, 0xF0, 0x87, 0x70, 0x4F, 0x0D, 0x74, 0x0C, 0xF0, 0x47, 0x70, 0x7F, 0x0A,
  0x74, 0xF9, 0x01, 0x77, 0x0B, 0xF0, 0x67, 0x30, 0x3F, 0x0D, 0x77, 0x10, 0xEF, 0x03, 0x73, 0x06,
  0xF0, 0x97, 0x70, 0x3F, 0x97, 0x40, 0xAF, 0x06, 0x77, 0x06, 0xF0, 0xC7, 0x40, 0xDF, 0x03, 0x77,
  0x09, 0xF0, 0x97, 0x30, 0x1F, 0x97, 0x71, 0x0C, 0xF0, 0x67, 0x30, 0x4F, 0x0C, 0x77, 0x1F, 0x90,
  0x27, 0x30, 0x7F, 0x08, 0x77, 0x02, 0xF9, 0x74, 0x0B, 0xF0, 0x57, 0x70, 0x5F, 0x0C, 0x74, 0x0E,
  0xF0, 0x27, 0x70, 0x7F, 0x0A, 0x73, 0x02, 0xF0, 0xE7, 0x71, 0x09, 0xF0, 0x87, 0x30, 0x5F, 0x0B,
  0x77, 0x10, 0xBF, 0x06, 0x73, 0x08, 0xF0, 0x77, 0x71, 0x0D, 0xF0, 0x47, 0x30, 0xBF, 0x04, 0x77,
  0x10, 0xEF, 0x03, 0x73, 0x0E, 0xF0, 0x17, 0x71, 0xF9, 0x02, 0x72, 0x02, 0xF0, 0xD7, 0x72, 0xF9,
  0x03, 0x72, 0x06, 0xF0, 0x97, 0x72, 0x0E, 0xF0, 0x47, 0x20, 0x9F, 0x06, 0x77, 0x20, 0xCF, 0x09,
  0x58, 0x33, 0xC1, 0x0C, 0xF0, 0x37, 0x72, 0x09, 0xF9, 0x83, 0x50, 0x14, 0xAA, 0x09, 0x1F, 0x97,
  0x73, 0x04, 0xFF, 0x90, 0xD0, 0x3F, 0x0C, 0x77, 0x40, 0xCF, 0xE8, 0x1B, 0x17, 0xF0, 0x87, 0x74,
  0x03, 0xFC, 0x0E, 0x06, 0x20, 0xAF, 0x05, 0x77, 0x50, 0x40, 0xEF, 0x90, 0xA0, 0x17, 0x77, 0x74,
  0x87, 0x18, 0xCE, 0xFE, 0xB7, 0x25,
  // "ò" (U+00F2)
  0x77, 0x20, 0x68, 0x03, 0x70, 0x47, 0x77, 0x73, 0x0E, 0xF0, 0xC7, 0x77, 0x73, 0x06, 0xF9, 0x02,
  0x77, 0x77, 0x30, 0xCF, 0x07, 0x77, 0x77, 0x30, 0x2F, 0x0C, 0x77, 0x77, 0x40, 0x7F, 0x02, 0x77,
  0x77, 0x40, 0xCE, 0x08, 0x77, 0x77, 0x40, 0x10, 0xED, 0x0E, 0x77, 0x77, 0x50, 0x5E, 0x05, 0x77,
  0x77, 0x50, 0x8D, 0x0B, 0x77, 0x77, 0x60, 0xBD, 0x01, 0x77, 0x77, 0x50, 0x10, 0xDC, 0x07, 0x77,
  0x77, 0x60, 0x30, 0xEB, 0x0D, 0x77, 0x77, 0x70, 0x4C, 0x04, 0x77, 0x77, 0x70, 0x6B, 0x04, 0x80,
  0xBC, 0x10, 0x89, 0x23, 0x6A, 0xCD, 0xEF, 0xEC, 0xA6, 0x17, 0x77, 0x48, 0x11, 0x7D, 0xFD, 0x0A,
  0x02, 0x77, 0x71, 0x07, 0x0E, 0xFF, 0xA0, 0x87, 0x75, 0x02, 0x0D, 0xFF, 0xD0, 0xB7, 0x73, 0x05,
  0x0E, 0xF8, 0x4C, 0x87, 0x79, 0xDF, 0x90, 0xB7, 0x71, 0x07, 0xF0, 0xC0, 0x36, 0x06, 0xF9, 0x08,
  0x76, 0x07, 0xF0, 0x87, 0x20, 0x4F, 0x90, 0x27, 0x40, 0x5F, 0x08, 0x74, 0x08, 0xF0, 0xB7, 0x30,
  0x3F, 0x0A, 0x75, 0x01, 0x0E, 0xF0, 0x27, 0x10, 0x10, 0xDE, 0x0D, 0x77, 0x0A, 0xF0, 0x87, 0x10,
  0xAF, 0x04, 0x77, 0x06, 0xF0, 0xC7, 0x04, 0xF0, 0xA7, 0x71, 0x03, 0xF9, 0x01, 0x60, 0xDF, 0x02,
  0x77, 0x10, 0x1F, 0x90, 0x35, 0x06, 0xF0, 0xB7, 0x73, 0xF9, 0x05, 0x50, 0xEF, 0x03, 0x77, 0x30,
  0xEF, 0x07, 0x40, 0x6F, 0x0C, 0x77, 0x40, 0xEF, 0x08, 0x40, 0xDF, 0x07, 0x77, 0x40, 0xEF, 0x09,
  0x30, 0x4F, 0x90, 0x27, 0x74, 0x0E, 0xF0, 0x93, 0x0A, 0xF0, 0xC7, 0x75, 0xF9, 0x09, 0x30, 0xEF,
  0x07, 0x77, 0x5F, 0x90, 0x82, 0x04, 0xF9, 0x03, 0x77, 0x40, 0x2F, 0x90, 0x72, 0x09, 0xF0, 0xE7,
  0x75, 0x03, 0xF9, 0x06, 0x20, 0xDF, 0x0B, 0x77, 0x50, 0x5F, 0x98, 0x14, 0x01, 0xF9, 0x08, 0x77,
  0x50, 0x7F, 0x98, 0x12, 0x05, 0xF9, 0x05, 0x77, 0x50, 0xAF, 0x0E, 0x20, 0x8F, 0x90, 0x27, 0x75,
  0x0D, 0xF0, 0xC2, 0x0B, 0xF0, 0xE7, 0x76, 0xF9, 0x09, 0x20, 0xDF, 0x0C, 0x77, 0x50, 0x3F, 0x90,
  0x52, 0xF9, 0x0B, 0x77, 0x50, 0x7F, 0x98, 0x11, 0x01, 0xF9, 0x09, 0x77, 0x50, 0xBF, 0x0C, 0x20,
  0x2F, 0x90, 0x77, 0x75, 0x0E, 0xF0, 0x72, 0x02, 0xF9, 0x06, 0x77, 0x40, 0x3F, 0x90, 0x22, 0x03,
  0xF9, 0x06, 0x77, 0x40, 0x9F, 0x0C, 0x30, 0x2F, 0x90, 0x57, 0x74, 0x0E, 0xF0, 0x53, 0x02, 0xF9,
  0x05, 0x77, 0x30, 0x4F, 0x0E, 0x40, 0x1F, 0x90, 0x57, 0x73, 0x0A, 0xF0, 0x65, 0x0E, 0xF0, 0x67,
  0x72, 0x02, 0xF0, 0xD6, 0x0C, 0xF0, 0x87, 0x72, 0x09, 0xF0, 0x56, 0x09, 0xF0, 0xA7, 0x71, 0x02,
  0xF0, 0xC7, 0x05, 0xF0, 0xD7, 0x71, 0x0A, 0xE0, 0xE0, 0x27, 0x01, 0xF9, 0x02, 0x76, 0x05, 0xF0,
  0x67, 0x20, 0xAF, 0x07, 0x75, 0x02, 0x0E, 0xE0, 0xA7, 0x30, 0x3F, 0x0E, 0x01, 0x73, 0x01, 0x0D,
  0xE0, 0xD0, 0x17, 0x40, 0xBF, 0x0B, 0x72, 0x02, 0x0D, 0xE0, 0xD0, 0x17, 0x50, 0x10, 0xEF, 0x0C,
  0x02, 0x60, 0x60, 0xEE, 0x0D, 0x02, 0x77, 0x04, 0xFA, 0x84, 0xB7, 0x67, 0xAE, 0xF0, 0xB0, 0x17,
  0x72, 0x04, 0x0E, 0xFF, 0xD0, 0x87, 0x75, 0x02, 0x0C, 0xFF, 0xA0, 0xB0, 0x27, 0x77, 0x10, 0x60,
  0xDF, 0xD0, 0xB0, 0x47, 0x77, 0x58, 0x92, 0x38, 0xBD, 0xEF, 0xED, 0xB9, 0x51, 0x77, 0x40,
  // "ó" (U+00F3)
  0x77, 0x77, 0x38, 0x05, 0x70, 0x17, 0x77, 0x72, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x30, 0xEF, 0x0E,
  0x02, 0x77, 0x77, 0x20, 0x8F, 0x90, 0x47, 0x77, 0x72, 0x02, 0xF9, 0x05, 0x77, 0x77, 0x30, 0xCF,
  0x06, 0x77, 0x77, 0x30, 0x6F, 0x07, 0x77, 0x77, 0x30, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x40, 0xBE,
  0x07, 0x77, 0x77, 0x40, 0x7E, 0x06, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x50, 0xDC, 0x0E,
  0x03, 0x77, 0x77, 0x50, 0xAC, 0x0C, 0x02, 0x77, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0x77, 0x70, 0xCA,
  0x0E, 0x05, 0x80, 0xBD, 0x20, 0x89, 0x23, 0x6A, 0xCD, 0xEF, 0xEC, 0xA6, 0x17, 0x77, 0x58, 0x11,
  0x7D, 0xFD, 0x0A, 0x02, 0x77, 0x72, 0x07, 0x0E, 0xFF, 0xA0, 0x87, 0x76, 0x02, 0x0D, 0xFF, 0xD0,
  0xB7, 0x74, 0x05, 0x0E, 0xF8, 0x4C, 0x87, 0x79, 0xDF, 0x90, 0xB7, 0x72, 0x07, 0xF0, 0xC0, 0x36,
  0x06, 0xF9, 0x08, 0x77, 0x07, 0xF0, 0x87, 0x20, 0x4F, 0x90, 0x27, 0x50, 0x5F, 0x08, 0x74, 0x08,
  0xF0, 0xB7, 0x40, 0x3F, 0x0A, 0x75, 0x01, 0x0E, 0xF0, 0x27, 0x20, 0x10, 0xDE, 0x0D, 0x77, 0x0A,
  0xF0, 0x87, 0x20, 0xAF, 0x04, 0x77, 0x06, 0xF0, 0xC7, 0x10, 0x4F, 0x0A, 0x77, 0x10, 0x3F, 0x90,
  0x17, 0x0D, 0xF0, 0x27, 0x71, 0x01, 0xF9, 0x03, 0x60, 0x6F, 0x0B, 0x77, 0x3F, 0x90, 0x56, 0x0E,
  0xF0, 0x37, 0x73, 0x0E, 0xF0, 0x75, 0x06, 0xF0, 0xC7, 0x74, 0x0E, 0xF0, 0x85, 0x0D, 0xF0, 0x77,
  0x74, 0x0E, 0xF0, 0x94, 0x04, 0xF9, 0x02, 0x77, 0x40, 0xEF, 0x09, 0x40, 0xAF, 0x0C, 0x77, 0x5F,
  0x90, 0x94, 0x0E, 0xF0, 0x77, 0x75, 0xF9, 0x08, 0x30, 0x4F, 0x90, 0x37, 0x74, 0x02, 0xF9, 0x07,
  0x30, 0x9F, 0x0E, 0x77, 0x50, 0x3F, 0x90, 0x63, 0x0D, 0xF0, 0xB7, 0x75, 0x05, 0xF9, 0x04, 0x20,
  0x1F, 0x90, 0x87, 0x75, 0x07, 0xF9, 0x02, 0x20, 0x5F, 0x90, 0x57, 0x75, 0x0A, 0xF0, 0xE3, 0x08,
  0xF9, 0x02, 0x77, 0x50, 0xDF, 0x0C, 0x30, 0xBF, 0x0E, 0x77, 0x6F, 0x90, 0x93, 0x0D, 0xF0, 0xC7,
  0x75, 0x03, 0xF9, 0x05, 0x3F, 0x90, 0xB7, 0x75, 0x07, 0xF9, 0x01, 0x20, 0x1F, 0x90, 0x97, 0x75,
  0x0B, 0xF0, 0xC3, 0x02, 0xF9, 0x07, 0x77, 0x50, 0xEF, 0x07, 0x30, 0x2F, 0x90, 0x67, 0x74, 0x03,
  0xF9, 0x02, 0x30, 0x3F, 0x90, 0x67, 0x74, 0x09, 0xF0, 0xC4, 0x02, 0xF9, 0x05, 0x77, 0x40, 0xEF,
  0x05, 0x40, 0x2F, 0x90, 0x57, 0x73, 0x04, 0xF0, 0xE5, 0x01, 0xF9, 0x05, 0x77, 0x30, 0xAF, 0x06,
  0x60, 0xEF, 0x06, 0x77, 0x20, 0x2F, 0x0D, 0x70, 0xCF, 0x08, 0x77, 0x20, 0x9F, 0x05, 0x70, 0x9F,
  0x0A, 0x77, 0x10, 0x2F, 0x0C, 0x71, 0x05, 0xF0, 0xD7, 0x71, 0x0A, 0xE0, 0xE0, 0x27, 0x10, 0x1F,
  0x90, 0x27, 0x60, 0x5F, 0x06, 0x73, 0x0A, 0xF0, 0x77, 0x50, 0x20, 0xEE, 0x0A, 0x74, 0x03, 0xF0,
  0xE0, 0x17, 0x30, 0x10, 0xDE, 0x0D, 0x01, 0x75, 0x0B, 0xF0, 0xB7, 0x20, 0x20, 0xDE, 0x0D, 0x01,
  0x76, 0x01, 0x0E, 0xF0, 0xC0, 0x26, 0x06, 0x0E, 0xE0, 0xD0, 0x27, 0x71, 0x04, 0xFA, 0x84, 0xB7,
  0x67, 0xAE, 0xF0, 0xB0, 0x17, 0x73, 0x04, 0x0E, 0xFF, 0xD0, 0x87, 0x76, 0x02, 0x0C, 0xFF, 0xA0,
  0xB0, 0x27, 0x77, 0x20, 0x60, 0xDF, 0xD0, 0xB0, 0x47, 0x77, 0x68, 0x92, 0x38, 0xBD, 0xEF, 0xED,
  0xB9, 0x51, 0x77, 0x50,
  // "ô" (U+00F4)
  0x77, 0x74, 0x80, 0x47, 0x77, 0x77, 0x30, 0x9F, 0x90, 0x37, 0x77, 0x71, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x01, 0x0E, 0xFA, 0x0B, 0x77, 0x77, 0x0C, 0xFC, 0x01, 0x77, 0x75, 0x09, 0xFD, 0x07, 0x77,
  0x74, 0x06, 0xE0, 0xB0, 0xDD, 0x0C, 0x77, 0x73, 0x03, 0xE8, 0x1A, 0x04, 0xE0, 0x27, 0x77, 0x10,
  0x20, 0xED, 0x09, 0x30, 0xAD, 0x09, 0x77, 0x71, 0x0C, 0xD0, 0x84, 0x01, 0x0E, 0xC0, 0xE7, 0x77,
  0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x77, 0x75, 0x09, 0xC0, 0xE0, 0x57, 0x10, 0x9C, 0x0D, 0x77, 0x40,
  0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x72, 0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D,
  0x77, 0x20, 0xCA, 0x0D, 0x04, 0x77, 0x01, 0x0C, 0xA0, 0xD8, 0x0B, 0xB1, 0x08, 0x92, 0x36, 0xAC,
  0xDE, 0xFE, 0xCA, 0x61, 0x77, 0x74, 0x81, 0x17, 0xDF, 0xD0, 0xA0, 0x27, 0x77, 0x10, 0x70, 0xEF,
  0xFA, 0x08, 0x77, 0x50, 0x20, 0xDF, 0xFD, 0x0B, 0x77, 0x30, 0x50, 0xEF, 0x84, 0xC8, 0x77, 0x9D,
  0xF9, 0x0B, 0x77, 0x10, 0x7F, 0x0C, 0x03, 0x60, 0x6F, 0x90, 0x87, 0x60, 0x7F, 0x08, 0x72, 0x04,
  0xF9, 0x02, 0x74, 0x05, 0xF0, 0x87, 0x40, 0x8F, 0x0B, 0x73, 0x03, 0xF0, 0xA7, 0x50, 0x10, 0xEF,
  0x02, 0x71, 0x01, 0x0D, 0xE0, 0xD7, 0x70, 0xAF, 0x08, 0x71, 0x0A, 0xF0, 0x47, 0x70, 0x6F, 0x0C,
  0x70, 0x4F, 0x0A, 0x77, 0x10, 0x3F, 0x90, 0x16, 0x0D, 0xF0, 0x27, 0x71, 0x01, 0xF9, 0x03, 0x50,
  0x6F, 0x0B, 0x77, 0x3F, 0x90, 0x55, 0x0E, 0xF0, 0x37, 0x73, 0x0E, 0xF0, 0x74, 0x06, 0xF0, 0xC7,
  0x74, 0x0E, 0xF0, 0x84, 0x0D, 0xF0, 0x77, 0x74, 0x0E, 0xF0, 0x93, 0x04, 0xF9, 0x02, 0x77, 0x40,
  0xEF, 0x09, 0x30, 0xAF, 0x0C, 0x77, 0x5F, 0x90, 0x93, 0x0E, 0xF0, 0x77, 0x75, 0xF9, 0x08, 0x20,
  0x4F, 0x90, 0x37, 0x74, 0x02, 0xF9, 0x07, 0x20, 0x9F, 0x0E, 0x77, 0x50, 0x3F, 0x90, 0x62, 0x0D,
  0xF0, 0xB7, 0x75, 0x05, 0xF9, 0x81, 0x40, 0x1F, 0x90, 0x87, 0x75, 0x07, 0xF9, 0x81, 0x20, 0x5F,
  0x90, 0x57, 0x75, 0x0A, 0xF0, 0xE2, 0x08, 0xF9, 0x02, 0x77, 0x50, 0xDF, 0x0C, 0x20, 0xBF, 0x0E,
  0x77, 0x6F, 0x90, 0x92, 0x0D, 0xF0, 0xC7, 0x75, 0x03, 0xF9, 0x05, 0x2F, 0x90, 0xB7, 0x75, 0x07,
  0xF9, 0x81, 0x10, 0x1F, 0x90, 0x97, 0x75, 0x0B, 0xF0, 0xC2, 0x02, 0xF9, 0x07, 0x77, 0x50, 0xEF,
  0x07, 0x20, 0x2F, 0x90, 0x67, 0x74, 0x03, 0xF9, 0x02, 0x20, 0x3F, 0x90, 0x67, 0x74, 0x09, 0xF0,
  0xC3, 0x02, 0xF9, 0x05, 0x77, 0x40, 0xEF, 0x05, 0x30, 0x2F, 0x90, 0x57, 0x73, 0x04, 0xF0, 0xE4,
  0x01, 0xF9, 0x05, 0x77, 0x30, 0xAF, 0x06, 0x50, 0xEF, 0x06, 0x77, 0x20, 0x2F, 0x0D, 0x60, 0xCF,
  0x08, 0x77, 0x20, 0x9F, 0x05, 0x60, 0x9F, 0x0A, 0x77, 0x10, 0x2F, 0x0C, 0x70, 0x5F, 0x0D, 0x77,
  0x10, 0xAE, 0x0E, 0x02, 0x70, 0x1F, 0x90, 0x27, 0x60, 0x5F, 0x06, 0x72, 0x0A, 0xF0, 0x77, 0x50,
  0x20, 0xEE, 0x0A, 0x73, 0x03, 0xF0, 0xE0, 0x17, 0x30, 0x10, 0xDE, 0x0D, 0x01, 0x74, 0x0B, 0xF0,
  0xB7, 0x20, 0x20, 0xDE, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xF0, 0xC0, 0x26, 0x06, 0x0E, 0xE0, 0xD0,
  0x27, 0x70, 0x4F, 0xA8, 0x4B, 0x76, 0x7A, 0xEF, 0x0B, 0x01, 0x77, 0x20, 0x40, 0xEF, 0xFD, 0x08,
  0x77, 0x50, 0x20, 0xCF, 0xFA, 0x0B, 0x02, 0x77, 0x71, 0x06, 0x0D, 0xFD, 0x0B, 0x04, 0x77, 0x75,
  0x89, 0x23, 0x8B, 0xDE, 0xFE, 0xDB, 0x95, 0x17, 0x74,
  // "õ" (U+00F5)
  0x77, 0x48, 0x61, 0x7C, 0xEF, 0xDB, 0x57, 0x50, 0x20, 0xF4, 0x77, 0x30, 0x70, 0xEF, 0x0D, 0x03,
  0x73, 0x0C, 0xA0, 0xD7, 0x72, 0x09, 0xFC, 0x05, 0x71, 0x02, 0xB0, 0x97, 0x71, 0x08, 0xFE, 0x07,
  0x70, 0x9B, 0x03, 0x77, 0x04, 0xFF, 0x90, 0x95, 0x02, 0xB0, 0xC7, 0x71, 0x0D, 0xB8, 0x3A, 0x30,
  0x28, 0xF9, 0x84, 0xC4, 0x11, 0x5E, 0xB0, 0x47, 0x70, 0x5B, 0x0A, 0x50, 0x40, 0xEF, 0xF0, 0xA7,
  0x71, 0x0C, 0xB0, 0x26, 0x02, 0x0D, 0xFD, 0x0D, 0x01, 0x77, 0x03, 0xB0, 0x97, 0x10, 0x10, 0xCF,
  0xB0, 0xE0, 0x27, 0x71, 0x07, 0xB0, 0x37, 0x30, 0x8F, 0x90, 0xC0, 0x27, 0x72, 0x02, 0x0F, 0x47,
  0x58, 0x62, 0x8C, 0xEE, 0xDA, 0x58, 0x0B, 0xC7, 0x08, 0x92, 0x36, 0xAC, 0xDE, 0xFE, 0xCA, 0x61,
  0x77, 0x76, 0x81, 0x17, 0xDF, 0xD0, 0xA0, 0x27, 0x77, 0x30, 0x70, 0xEF, 0xFA, 0x08, 0x77, 0x70,
  0x20, 0xDF, 0xFD, 0x0B, 0x77, 0x50, 0x50, 0xEF, 0x84, 0xC8, 0x77, 0x9D, 0xF9, 0x0B, 0x77, 0x30,
  0x7F, 0x0C, 0x03, 0x60, 0x6F, 0x90, 0x87, 0x71, 0x07, 0xF0, 0x87, 0x20, 0x4F, 0x90, 0x27, 0x60,
  0x5F, 0x08, 0x74, 0x08, 0xF0, 0xB7, 0x50, 0x3F, 0x0A, 0x75, 0x01, 0x0E, 0xF0, 0x27, 0x30, 0x10,
  0xDE, 0x0D, 0x77, 0x0A, 0xF0, 0x87, 0x30, 0xAF, 0x04, 0x77, 0x06, 0xF0, 0xC7, 0x20, 0x4F, 0x0A,
  0x77, 0x10, 0x3F, 0x90, 0x17, 0x10, 0xDF, 0x02, 0x77, 0x10, 0x1F, 0x90, 0x37, 0x06, 0xF0, 0xB7,
  0x73, 0xF9, 0x05, 0x70, 0xEF, 0x03, 0x77, 0x30, 0xEF, 0x07, 0x60, 0x6F, 0x0C, 0x77, 0x40, 0xEF,
  0x08, 0x60, 0xDF, 0x07, 0x77, 0x40, 0xEF, 0x09, 0x50, 0x4F, 0x90, 0x27, 0x74, 0x0E, 0xF0, 0x95,
  0x0A, 0xF0, 0xC7, 0x75, 0xF9, 0x09, 0x50, 0xEF, 0x07, 0x77, 0x5F, 0x90, 0x84, 0x04, 0xF9, 0x03,
  0x77, 0x40, 0x2F, 0x90, 0x74, 0x09, 0xF0, 0xE7, 0x75, 0x03, 0xF9, 0x06, 0x40, 0xDF, 0x0B, 0x77,
  0x50, 0x5F, 0x90, 0x43, 0x01, 0xF9, 0x08, 0x77, 0x50, 0x7F, 0x90, 0x23, 0x05, 0xF9, 0x05, 0x77,
  0x50, 0xAF, 0x0E, 0x40, 0x8F, 0x90, 0x27, 0x75, 0x0D, 0xF0, 0xC4, 0x0B, 0xF0, 0xE7, 0x76, 0xF9,
  0x09, 0x40, 0xDF, 0x0C, 0x77, 0x50, 0x3F, 0x90, 0x54, 0xF9, 0x0B, 0x77, 0x50, 0x7F, 0x90, 0x13,
  0x01, 0xF9, 0x09, 0x77, 0x50, 0xBF, 0x0C, 0x40, 0x2F, 0x90, 0x77, 0x75, 0x0E, 0xF0, 0x74, 0x02,
  0xF9, 0x06, 0x77, 0x40, 0x3F, 0x90, 0x24, 0x03, 0xF9, 0x06, 0x77, 0x40, 0x9F, 0x0C, 0x50, 0x2F,
  0x90, 0x57, 0x74, 0x0E, 0xF0, 0x55, 0x02, 0xF9, 0x05, 0x77, 0x30, 0x4F, 0x0E, 0x60, 0x1F, 0x90,
  0x57, 0x73, 0x0A, 0xF0, 0x67, 0x0E, 0xF0, 0x67, 0x72, 0x02, 0xF0, 0xD7, 0x10, 0xCF, 0x08, 0x77,
  0x20, 0x9F, 0x05, 0x71, 0x09, 0xF0, 0xA7, 0x71, 0x02, 0xF0, 0xC7, 0x20, 0x5F, 0x0D, 0x77, 0x10,
  0xAE, 0x0E, 0x02, 0x72, 0x01, 0xF9, 0x02, 0x76, 0x05, 0xF0, 0x67, 0x40, 0xAF, 0x07, 0x75, 0x02,
  0x0E, 0xE0, 0xA7, 0x50, 0x3F, 0x0E, 0x01, 0x73, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x60, 0xBF, 0x0B,
  0x72, 0x02, 0x0D, 0xE0, 0xD0, 0x17, 0x70, 0x10, 0xEF, 0x0C, 0x02, 0x60, 0x60, 0xEE, 0x0D, 0x02,
  0x77, 0x20, 0x4F, 0xA8, 0x4B, 0x76, 0x7A, 0xEF, 0x0B, 0x01, 0x77, 0x40, 0x40, 0xEF, 0xFD, 0x08,
  0x77, 0x70, 0x20, 0xCF, 0xFA, 0x0B, 0x02, 0x77, 0x73, 0x06, 0x0D, 0xFD, 0x0B, 0x04, 0x77, 0x77,
  0x89, 0x23, 0x8B, 0xDE, 0xFE, 0xDB, 0x95, 0x17, 0x76,
  // "ö" (U+00F6)
  0x77, 0x38, 0x35, 0xCF, 0xD7, 0x73, 0x83, 0x6D, 0xFD, 0x77, 0x75, 0x07, 0xD0, 0x97, 0x10, 0x8D,
  0x08, 0x77, 0x30, 0x2F, 0x01, 0x60, 0x2E, 0x0E, 0x77, 0x30, 0x7F, 0x03, 0x60, 0x8F, 0x02, 0x77,
  0x20, 0xBF, 0x04, 0x60, 0xCF, 0x03, 0x77, 0x20, 0xCF, 0x03, 0x60, 0xDF, 0x02, 0x77, 0x20, 0xBF,
  0x70, 0xCF, 0x77, 0x30, 0x9E, 0x0B, 0x70, 0xAE, 0x0A, 0x77, 0x30, 0x2D, 0x0E, 0x02, 0x70, 0x3D,
  0x0D, 0x01, 0x77, 0x48, 0x43, 0xBE, 0xEA, 0x17, 0x28, 0x44, 0xCF, 0xE9, 0x18, 0x0D, 0xA2, 0x08,
  0x92, 0x36, 0xAC, 0xDE, 0xFE, 0xCA, 0x61, 0x77, 0x74, 0x81, 0x17, 0xDF, 0xD0, 0xA0, 0x27, 0x77,
  0x10, 0x70, 0xEF, 0xFA, 0x08, 0x77, 0x50, 0x20, 0xDF, 0xFD, 0x0B, 0x77, 0x30, 0x50, 0xEF, 0x84,
  0xC8, 0x77, 0x9D, 0xF9, 0x0B, 0x77, 0x10, 0x7F, 0x0C, 0x03, 0x60, 0x6F, 0x90, 0x87, 0x60, 0x7F,
  0x08, 0x72, 0x04, 0xF9, 0x02, 0x74, 0x05, 0xF0, 0x87, 0x40, 0x8F, 0x0B, 0x73, 0x03, 0xF0, 0xA7,
  0x50, 0x10, 0xEF, 0x02, 0x71, 0x01, 0x0D, 0xE0, 0xD7, 0x70, 0xAF, 0x08, 0x71, 0x0A, 0xF0, 0x47,
  0x70, 0x6F, 0x0C, 0x70, 0x4F, 0x0A, 0x77, 0x10, 0x3F, 0x90, 0x16, 0x0D, 0xF0, 0x27, 0x71, 0x01,
  0xF9, 0x03, 0x50, 0x6F, 0x0B, 0x77, 0x3F, 0x90, 0x55, 0x0E, 0xF0, 0x37, 0x73, 0x0E, 0xF0, 0x74,
  0x06, 0xF0, 0xC7, 0x74, 0x0E, 0xF0, 0x84, 0x0D, 0xF0, 0x77, 0x74, 0x0E, 0xF0, 0x93, 0x04, 0xF9,
  0x02, 0x77, 0x40, 0xEF, 0x09, 0x30, 0xAF, 0x0C, 0x77, 0x5F, 0x90, 0x93, 0x0E, 0xF0, 0x77, 0x75,
  0xF9, 0x08, 0x20, 0x4F, 0x90, 0x37, 0x74, 0x02, 0xF9, 0x07, 0x20, 0x9F, 0x0E, 0x77, 0x50, 0x3F,
  0x90, 0x62, 0x0D, 0xF0, 0xB7, 0x75, 0x05, 0xF9, 0x81, 0x40, 0x1F, 0x90, 0x87, 0x75, 0x07, 0xF9,
  0x81, 0x20, 0x5F, 0x90, 0x57, 0x75, 0x0A, 0xF0, 0xE2, 0x08, 0xF9, 0x02, 0x77, 0x50, 0xDF, 0x0C,
  0x20, 0xBF, 0x0E, 0x77, 0x6F, 0x90, 0x92, 0x0D, 0xF0, 0xC7, 0x75, 0x03, 0xF9, 0x05, 0x2F, 0x90,
  0xB7, 0x75, 0x07, 0xF9, 0x81, 0x10, 0x1F, 0x90, 0x97, 0x75, 0x0B, 0xF0, 0xC2, 0x02, 0xF9, 0x07,
  0x77, 0x50, 0xEF, 0x07, 0x20, 0x2F, 0x90, 0x67, 0x74, 0x03, 0xF9, 0x02, 0x20, 0x3F, 0x90, 0x67,
  0x74, 0x09, 0xF0, 0xC3, 0x02, 0xF9, 0x05, 0x77, 0x40, 0xEF, 0x05, 0x30, 0x2F, 0x90, 0x57, 0x73,
  0x04, 0xF0, 0xE4, 0x01, 0xF9, 0x05, 0x77, 0x30, 0xAF, 0x06, 0x50, 0xEF, 0x06, 0x77, 0x20, 0x2F,
  0x0D, 0x60, 0xCF, 0x08, 0x77, 0x20, 0x9F, 0x05, 0x60, 0x9F, 0x0A, 0x77, 0x10, 0x2F, 0x0C, 0x70,
  0x5F, 0x0D, 0x77, 0x10, 0xAE, 0x0E, 0x02, 0x70, 0x1F, 0x90, 0x27, 0x60, 0x5F, 0x06, 0x72, 0x0A,
  0xF0, 0x77, 0x50, 0x20, 0xEE, 0x0A, 0x73, 0x03, 0xF0, 0xE0, 0x17, 0x30, 0x10, 0xDE, 0x0D, 0x01,
  0x74, 0x0B, 0xF0, 0xB7, 0x20, 0x20, 0xDE, 0x0D, 0x01, 0x75, 0x01, 0x0E, 0xF0, 0xC0, 0x26, 0x06,
  0x0E, 0xE0, 0xD0, 0x27, 0x70, 0x4F, 0xA8, 0x4B, 0x76, 0x7A, 0xEF, 0x0B, 0x01, 0x77, 0x20, 0x40,
  0xEF, 0xFD, 0x08, 0x77, 0x50, 0x20, 0xCF, 0xFA, 0x0B, 0x02, 0x77, 0x71, 0x06, 0x0D, 0xFD, 0x0B,
  0x04, 0x77, 0x75, 0x89, 0x23, 0x8B, 0xDE, 0xFE, 0xDB, 0x95, 0x17, 0x74,
  // "÷" (U+00F7)
  0x77, 0x84, 0x4B, 0xEE, 0xB3, 0x77, 0x76, 0x05, 0xE0, 0x37, 0x77, 0x50, 0xDE, 0x0B, 0x77, 0x74,
  0x01, 0xF0, 0xE7, 0x77, 0x40, 0x2F, 0x90, 0x17, 0x77, 0x30, 0x2F, 0x97, 0x77, 0x40, 0x1F, 0x0E,
  0x77, 0x75, 0x0C, 0xE0, 0xB7, 0x77, 0x50, 0x4E, 0x03, 0x77, 0x76, 0x84, 0x4B, 0xEE, 0xB3, 0x80,
  0xDB, 0x60, 0x09, 0xFF, 0xFF, 0xC0, 0x50, 0x9F, 0xFF, 0xFC, 0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x50,
  0x9F, 0xFF, 0xFC, 0x05, 0x09, 0xFF, 0xFF, 0xC0, 0x58, 0x0C, 0xF4, 0x08, 0x44, 0xBE, 0xEB, 0x37,
  0x77, 0x60, 0x5E, 0x03, 0x77, 0x75, 0x0D, 0xE0, 0xB7, 0x77, 0x40, 0x1F, 0x0E, 0x77, 0x74, 0x02,
  0xF9, 0x01, 0x77, 0x73, 0x02, 0xF9, 0x77, 0x74, 0x01, 0xF0, 0xE7, 0x77, 0x50, 0xCE, 0x0B, 0x77,
  0x75, 0x04, 0xE0, 0x37, 0x77, 0x68, 0x44, 0xBE, 0xEB, 0x37, 0x70,
  // "ø" (U+00F8)
  0x80, 0xC5, 0x00, 0x58, 0x00, 0x78, 0x0C, 0x40, 0x03, 0xC0, 0x88, 0x0C, 0x30, 0x01, 0x0D, 0xB0,
  0xC8, 0x0C, 0x40, 0x0A, 0xB0, 0xE0, 0x27, 0x77, 0x28, 0x92, 0x36, 0xAC, 0xDE, 0xFE, 0xC9, 0x61,
  0x40, 0x6C, 0x05, 0x77, 0x78, 0x11, 0x7D, 0xFD, 0x83, 0xA3, 0x02, 0xEB, 0x09, 0x77, 0x70, 0x70,
  0xEF, 0xFA, 0x08, 0x0C, 0xB0, 0xD7, 0x76, 0x02, 0x0D, 0xFF, 0xFA, 0x03, 0x77, 0x50, 0x50, 0xEF,
  0x84, 0xD9, 0x77, 0x9D, 0xFB, 0x06, 0x77, 0x50, 0x7F, 0x0C, 0x04, 0x60, 0x6F, 0x90, 0xC7, 0x75,
  0x07, 0xF0, 0xA7, 0x20, 0x4F, 0x0E, 0x01, 0x77, 0x30, 0x5F, 0x09, 0x74, 0x09, 0xF0, 0x97, 0x72,
  0x03, 0xF0, 0xB7, 0x50, 0x3F, 0x90, 0x17, 0x70, 0x10, 0xDE, 0x0E, 0x01, 0x75, 0x0C, 0xF9, 0x06,
  0x77, 0x0A, 0xF0, 0x57, 0x50, 0x8F, 0xA0, 0xB7, 0x60, 0x4F, 0x0B, 0x75, 0x04, 0xFB, 0x0E, 0x76,
  0x0D, 0xF0, 0x37, 0x40, 0x10, 0xDF, 0xC0, 0x27, 0x40, 0x6F, 0x0C, 0x75, 0x0A, 0xB0, 0xDF, 0x90,
  0x57, 0x40, 0xEF, 0x04, 0x74, 0x06, 0xC0, 0x30, 0xEF, 0x07, 0x73, 0x06, 0xF0, 0xD7, 0x40, 0x2C,
  0x81, 0x70, 0xEF, 0x08, 0x73, 0x0D, 0xF0, 0x87, 0x40, 0xCB, 0x0B, 0x20, 0xEF, 0x09, 0x72, 0x04,
  0xF9, 0x02, 0x73, 0x09, 0xB0, 0xE0, 0x12, 0x0E, 0xF0, 0x97, 0x20, 0xAF, 0x0D, 0x73, 0x04, 0xC0,
  0x53, 0xF9, 0x09, 0x72, 0x0E, 0xF0, 0x87, 0x20, 0x10, 0xEB, 0x09, 0x4F, 0x90, 0x87, 0x10, 0x4F,
  0x90, 0x47, 0x20, 0xBB, 0x0D, 0x40, 0x2F, 0x90, 0x77, 0x10, 0x9F, 0x97, 0x20, 0x7C, 0x03, 0x40,
  0x3F, 0x90, 0x67, 0x10, 0xDF, 0x0B, 0x71, 0x03, 0xC0, 0x75, 0x05, 0xF9, 0x04, 0x70, 0x1F, 0x90,
  0x87, 0x10, 0xDB, 0x0B, 0x60, 0x7F, 0x90, 0x27, 0x05, 0xF9, 0x05, 0x70, 0x9B, 0x0E, 0x01, 0x60,
  0xAF, 0x97, 0x10, 0x8F, 0x90, 0x26, 0x05, 0xC0, 0x47, 0x0C, 0xF0, 0xC7, 0x10, 0xBF, 0x96, 0x02,
  0x0E, 0xB0, 0x97, 0x1F, 0x90, 0x97, 0x10, 0xDF, 0x0D, 0x60, 0xCB, 0x0D, 0x71, 0x03, 0xF9, 0x06,
  0x71, 0xF9, 0x0B, 0x50, 0x8C, 0x02, 0x71, 0x07, 0xF9, 0x02, 0x70, 0x1F, 0x90, 0x94, 0x03, 0xC0,
  0x67, 0x20, 0xAF, 0x0D, 0x71, 0x02, 0xF9, 0x07, 0x30, 0x10, 0xDB, 0x0B, 0x73, 0x0E, 0xF0, 0x87,
  0x10, 0x2F, 0x90, 0x63, 0x0A, 0xB0, 0xE0, 0x17, 0x20, 0x3F, 0x90, 0x27, 0x10, 0x3F, 0x90, 0x62,
  0x06, 0xC0, 0x47, 0x30, 0x8F, 0x0C, 0x72, 0x02, 0xF9, 0x82, 0x50, 0x2E, 0xB0, 0x87, 0x40, 0xEF,
  0x06, 0x72, 0x01, 0xF9, 0x81, 0x50, 0xCB, 0x0C, 0x74, 0x04, 0xF0, 0xE7, 0x4F, 0x90, 0x50, 0x8C,
  0x02, 0x74, 0x0A, 0xF0, 0x67, 0x40, 0xEF, 0x0A, 0xC0, 0x67, 0x40, 0x2F, 0x0D, 0x75, 0x0B, 0xFC,
  0x0A, 0x75, 0x09, 0xF0, 0x57, 0x50, 0x8F, 0xB0, 0xD0, 0x17, 0x40, 0x1F, 0x0C, 0x76, 0x04, 0xFB,
  0x04, 0x75, 0x0A, 0xF0, 0x27, 0x70, 0xEF, 0x90, 0x87, 0x50, 0x4F, 0x06, 0x77, 0x10, 0x8F, 0x0C,
  0x75, 0x01, 0x0E, 0xE0, 0xA7, 0x72, 0x02, 0xF0, 0xE0, 0x17, 0x30, 0x10, 0xCE, 0x0D, 0x01, 0x77,
  0x30, 0x8F, 0x0A, 0x72, 0x02, 0x0D, 0xE0, 0xE0, 0x27, 0x74, 0x03, 0xF9, 0x0B, 0x01, 0x60, 0x60,
  0xEE, 0x0D, 0x02, 0x77, 0x50, 0xCF, 0xB8, 0x4B, 0x86, 0x7A, 0xEF, 0x0C, 0x01, 0x77, 0x50, 0x8F,
  0xFF, 0xA0, 0x87, 0x76, 0x04, 0xC0, 0x90, 0xCF, 0xFA, 0x0B, 0x02, 0x77, 0x60, 0x10, 0xEB, 0x0B,
  0x20, 0x60, 0xDF, 0xD0, 0xB0, 0x47, 0x77, 0x10, 0xBB, 0x0E, 0x01, 0x48, 0x92, 0x48, 0xBD, 0xEF,
  0xED, 0xB9, 0x51, 0x77, 0x72, 0x07, 0xC0, 0x48, 0x0C, 0x30, 0x03, 0xC0, 0x88, 0x0C, 0x40, 0x0D,
  0xB0, 0xC8, 0x0C, 0x40, 0x84, 0x37, 0x77, 0x72, 0x80, 0xC4, 0x00,
  // "ù" (U+00F9)
  0x77, 0x06, 0x80, 0x37, 0x04, 0x77, 0x77, 0x50, 0xEF, 0x0C, 0x77, 0x77, 0x50, 0x6F, 0x90, 0x27,
  0x77, 0x75, 0x0C, 0xF0, 0x77, 0x77, 0x75, 0x02, 0xF0, 0xC7, 0x77, 0x76, 0x07, 0xF0, 0x27, 0x77,
  0x76, 0x0C, 0xE0, 0x87, 0x77, 0x76, 0x01, 0x0E, 0xD0, 0xE7, 0x77, 0x77, 0x05, 0xE0, 0x57, 0x77,
  0x77, 0x08, 0xD0, 0xB8, 0x0C, 0x00, 0x0B, 0xD0, 0x17, 0x77, 0x77, 0x01, 0x0D, 0xC0, 0x78, 0x0C,
  0x00, 0x03, 0x0E, 0xB0, 0xD8, 0x0C, 0x10, 0x04, 0xC0, 0x48, 0x0C, 0x10, 0x06, 0xB0, 0x48, 0x0C,
  0x87, 0x00, 0x8F, 0xF0, 0x77, 0x70, 0x4F, 0x0D, 0x30, 0xCF, 0xF0, 0x47, 0x70, 0x7F, 0x0A, 0x3F,
  0xF9, 0x77, 0x10, 0xBF, 0x07, 0x20, 0x3F, 0xF0, 0xC7, 0x71, 0x0E, 0xF0, 0x35, 0x81, 0x37, 0xEF,
  0xA0, 0x97, 0x70, 0x2F, 0x97, 0x10, 0x20, 0xEF, 0x90, 0x67, 0x70, 0x5F, 0x0C, 0x72, 0x08, 0xF9,
  0x02, 0x77, 0x08, 0xF0, 0x97, 0x20, 0x6F, 0x0E, 0x77, 0x10, 0xCF, 0x06, 0x72, 0x06, 0xF0, 0xB7,
  0x71, 0xF9, 0x02, 0x72, 0x08, 0xF0, 0x87, 0x70, 0x3F, 0x0E, 0x73, 0x0A, 0xF0, 0x47, 0x70, 0x6F,
  0x0B, 0x73, 0x0D, 0xF0, 0x17, 0x70, 0x9F, 0x08, 0x72, 0x01, 0xF0, 0xD7, 0x71, 0x0D, 0xF0, 0x47,
  0x20, 0x4F, 0x0A, 0x77, 0x01, 0xF9, 0x01, 0x72, 0x07, 0xF0, 0x77, 0x70, 0x4F, 0x0D, 0x73, 0x0B,
  0xF0, 0x37, 0x70, 0x7F, 0x0A, 0x73, 0x0E, 0xF7, 0x71, 0x0A, 0xF0, 0x77, 0x20, 0x2F, 0x0C, 0x77,
  0x10, 0xEF, 0x03, 0x72, 0x06, 0xF0, 0x97, 0x70, 0x1F, 0x97, 0x30, 0x9F, 0x05, 0x77, 0x05, 0xF0,
  0xC7, 0x30, 0xDF, 0x02, 0x77, 0x08, 0xF0, 0x97, 0x20, 0x1F, 0x0E, 0x77, 0x10, 0xBF, 0x05, 0x72,
  0x04, 0xF0, 0xB7, 0x71, 0x0E, 0xF0, 0x27, 0x20, 0x7F, 0x07, 0x77, 0x04, 0xF0, 0xE7, 0x30, 0xBF,
  0x04, 0x77, 0x08, 0xF0, 0xB7, 0x30, 0xEF, 0x01, 0x77, 0x0C, 0xF0, 0x87, 0x20, 0x2F, 0x0D, 0x77,
  0x02, 0xF9, 0x04, 0x72, 0x06, 0xF0, 0x97, 0x70, 0x8F, 0x90, 0x17, 0x20, 0x9F, 0x06, 0x77, 0x0D,
  0xF0, 0xD7, 0x30, 0xDF, 0x02, 0x76, 0x04, 0xF9, 0x0A, 0x72, 0x01, 0xF0, 0xE7, 0x70, 0xBF, 0x90,
  0x77, 0x20, 0x4F, 0x0C, 0x76, 0x03, 0xFA, 0x04, 0x72, 0x07, 0xF0, 0x87, 0x60, 0xBF, 0xA0, 0x17,
  0x20, 0xAF, 0x06, 0x75, 0x04, 0xFA, 0x0E, 0x73, 0x0D, 0xF0, 0x37, 0x50, 0xDF, 0xA0, 0xC7, 0x3F,
  0x90, 0x17, 0x40, 0x7F, 0xB0, 0xA7, 0x20, 0x3F, 0x97, 0x40, 0x20, 0xEA, 0x0D, 0xF0, 0x87, 0x20,
  0x4F, 0x97, 0x40, 0xCA, 0x07, 0x09, 0xF0, 0x77, 0x20, 0x5F, 0x97, 0x30, 0x9A, 0x81, 0xC0, 0xAF,
  0x07, 0x72, 0x06, 0xF9, 0x01, 0x71, 0x08, 0xB8, 0x13, 0x0C, 0xF0, 0x77, 0x20, 0x5F, 0x90, 0x57,
  0x08, 0xB0, 0x62, 0x0C, 0xF0, 0x87, 0x20, 0x4F, 0x90, 0xB5, 0x01, 0x0A, 0xB0, 0xA3, 0x0C, 0xF0,
  0xD5, 0x83, 0x1A, 0x10, 0x1F, 0xA8, 0x49, 0x10, 0x27, 0xEB, 0x0D, 0x40, 0xBF, 0x90, 0x82, 0x03,
  0x09, 0xA0, 0x82, 0x0D, 0xFF, 0xA0, 0xE0, 0x24, 0x08, 0xFF, 0xA8, 0x11, 0x07, 0xFF, 0x90, 0xE0,
  0x35, 0x03, 0xFF, 0x90, 0x62, 0x01, 0x0E, 0xFE, 0x0E, 0x04, 0x70, 0xCF, 0xD0, 0xE0, 0x54, 0x06,
  0xFD, 0x0D, 0x03, 0x71, 0x03, 0xFC, 0x0C, 0x02, 0x60, 0x7F, 0xB0, 0x80, 0x17, 0x30, 0x5F, 0x90,
  0xE0, 0x77, 0x28, 0x90, 0x28, 0xCE, 0xFE, 0xDA, 0x61, 0x76, 0x87, 0x29, 0xDE, 0xFD, 0xB6, 0x16,
  // "ú" (U+00FA)
  0x77, 0x77, 0x28, 0x05, 0x70, 0x17, 0x77, 0x73, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x40, 0xEF, 0x0E,
  0x02, 0x77, 0x77, 0x30, 0x8F, 0x90, 0x47, 0x77, 0x73, 0x02, 0xF9, 0x05, 0x77, 0x77, 0x40, 0xCF,
  0x06, 0x77, 0x77, 0x40, 0x6F, 0x07, 0x77, 0x77, 0x40, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x50, 0xBE,
  0x07, 0x77, 0x77, 0x50, 0x7E, 0x06, 0x77, 0x77, 0x50, 0x2E, 0x05, 0x77, 0x77, 0x60, 0xDC, 0x0E,
  0x03, 0x77, 0x77, 0x60, 0xAC, 0x0C, 0x02, 0x77, 0x77, 0x60, 0x6C, 0x0A, 0x80, 0xC0, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xC9, 0x10, 0x08, 0xFF, 0x07, 0x77, 0x04, 0xF0, 0xD3, 0x0C, 0xFF, 0x04, 0x77,
  0x07, 0xF0, 0xA3, 0xFF, 0x97, 0x71, 0x0B, 0xF0, 0x72, 0x03, 0xFF, 0x0C, 0x77, 0x10, 0xEF, 0x03,
  0x58, 0x13, 0x7E, 0xFA, 0x09, 0x77, 0x02, 0xF9, 0x71, 0x02, 0x0E, 0xF9, 0x06, 0x77, 0x05, 0xF0,
  0xC7, 0x20, 0x8F, 0x90, 0x27, 0x70, 0x8F, 0x09, 0x72, 0x06, 0xF0, 0xE7, 0x71, 0x0C, 0xF0, 0x67,
  0x20, 0x6F, 0x0B, 0x77, 0x1F, 0x90, 0x27, 0x20, 0x8F, 0x08, 0x77, 0x03, 0xF0, 0xE7, 0x30, 0xAF,
  0x04, 0x77, 0x06, 0xF0, 0xB7, 0x30, 0xDF, 0x01, 0x77, 0x09, 0xF0, 0x87, 0x20, 0x1F, 0x0D, 0x77,
  0x10, 0xDF, 0x04, 0x72, 0x04, 0xF0, 0xA7, 0x70, 0x1F, 0x90, 0x17, 0x20, 0x7F, 0x07, 0x77, 0x04,
  0xF0, 0xD7, 0x30, 0xBF, 0x03, 0x77, 0x07, 0xF0, 0xA7, 0x30, 0xEF, 0x77, 0x10, 0xAF, 0x07, 0x72,
  0x02, 0xF0, 0xC7, 0x71, 0x0E, 0xF0, 0x37, 0x20, 0x6F, 0x09, 0x77, 0x01, 0xF9, 0x73, 0x09, 0xF0,
  0x57, 0x70, 0x5F, 0x0C, 0x73, 0x0D, 0xF0, 0x27, 0x70, 0x8F, 0x09, 0x72, 0x01, 0xF0, 0xE7, 0x71,
  0x0B, 0xF0, 0x57, 0x20, 0x4F, 0x0B, 0x77, 0x10, 0xEF, 0x02, 0x72, 0x07, 0xF0, 0x77, 0x70, 0x4F,
  0x0E, 0x73, 0x0B, 0xF0, 0x47, 0x70, 0x8F, 0x0B, 0x73, 0x0E, 0xF0, 0x17, 0x70, 0xCF, 0x08, 0x72,
  0x02, 0xF0, 0xD7, 0x70, 0x2F, 0x90, 0x47, 0x20, 0x6F, 0x09, 0x77, 0x08, 0xF9, 0x01, 0x72, 0x09,
  0xF0, 0x67, 0x70, 0xDF, 0x0D, 0x73, 0x0D, 0xF0, 0x27, 0x60, 0x4F, 0x90, 0xA7, 0x20, 0x1F, 0x0E,
  0x77, 0x0B, 0xF9, 0x07, 0x72, 0x04, 0xF0, 0xC7, 0x60, 0x3F, 0xA0, 0x47, 0x20, 0x7F, 0x08, 0x76,
  0x0B, 0xFA, 0x01, 0x72, 0x0A, 0xF0, 0x67, 0x50, 0x4F, 0xA0, 0xE7, 0x30, 0xDF, 0x03, 0x75, 0x0D,
  0xFA, 0x0C, 0x73, 0xF9, 0x01, 0x74, 0x07, 0xFB, 0x0A, 0x72, 0x03, 0xF9, 0x74, 0x02, 0x0E, 0xA0,
  0xDF, 0x08, 0x72, 0x04, 0xF9, 0x74, 0x0C, 0xA0, 0x70, 0x9F, 0x07, 0x72, 0x05, 0xF9, 0x73, 0x09,
  0xA8, 0x1C, 0x0A, 0xF0, 0x77, 0x20, 0x6F, 0x90, 0x17, 0x10, 0x8B, 0x81, 0x30, 0xCF, 0x07, 0x72,
  0x05, 0xF9, 0x05, 0x70, 0x8B, 0x06, 0x20, 0xCF, 0x08, 0x72, 0x04, 0xF9, 0x0B, 0x50, 0x10, 0xAB,
  0x0A, 0x30, 0xCF, 0x0D, 0x58, 0x31, 0xA1, 0x01, 0xFA, 0x84, 0x91, 0x02, 0x7E, 0xB0, 0xD4, 0x0B,
  0xF9, 0x08, 0x20, 0x30, 0x9A, 0x08, 0x20, 0xDF, 0xFA, 0x0E, 0x02, 0x40, 0x8F, 0xFA, 0x81, 0x10,
  0x7F, 0xF9, 0x0E, 0x03, 0x50, 0x3F, 0xF9, 0x06, 0x20, 0x10, 0xEF, 0xE0, 0xE0, 0x47, 0x0C, 0xFD,
  0x0E, 0x05, 0x40, 0x6F, 0xD0, 0xD0, 0x37, 0x10, 0x3F, 0xC0, 0xC0, 0x26, 0x07, 0xFB, 0x08, 0x01,
  0x73, 0x05, 0xF9, 0x0E, 0x07, 0x72, 0x89, 0x02, 0x8C, 0xEF, 0xED, 0xA6, 0x17, 0x68, 0x72, 0x9D,
  0xEF, 0xDB, 0x61, 0x60,
  // "û" (U+00FB)
  0x77, 0x73, 0x80, 0x47, 0x77, 0x77, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x73, 0x04, 0xFA, 0x07, 0x77,
  0x77, 0x20, 0x10, 0xEF, 0xA0, 0xB7, 0x77, 0x72, 0x0C, 0xFC, 0x01, 0x77, 0x77, 0x09, 0xFD, 0x07,
  0x77, 0x76, 0x06, 0xE0, 0xB0, 0xDD, 0x0C, 0x77, 0x75, 0x03, 0xE8, 0x1A, 0x04, 0xE0, 0x27, 0x77,
  0x30, 0x20, 0xED, 0x09, 0x30, 0xAD, 0x09, 0x77, 0x73, 0x0C, 0xD0, 0x84, 0x01, 0x0E, 0xC0, 0xE7,
  0x77, 0x20, 0xBD, 0x07, 0x60, 0x5D, 0x07, 0x77, 0x70, 0x9C, 0x0E, 0x05, 0x71, 0x09, 0xC0, 0xD7,
  0x76, 0x07, 0xC0, 0xD0, 0x27, 0x30, 0xBC, 0x05, 0x77, 0x40, 0x5C, 0x0A, 0x01, 0x74, 0x01, 0x0C,
  0xB0, 0xD7, 0x74, 0x0C, 0xA0, 0xD0, 0x47, 0x70, 0x10, 0xCA, 0x0D, 0x80, 0xBF, 0x60, 0x08, 0xFF,
  0x07, 0x77, 0x04, 0xF0, 0xD3, 0x0C, 0xFF, 0x04, 0x77, 0x07, 0xF0, 0xA3, 0xFF, 0x97, 0x71, 0x0B,
  0xF0, 0x72, 0x03, 0xFF, 0x0C, 0x77, 0x10, 0xEF, 0x03, 0x58, 0x13, 0x7E, 0xFA, 0x09, 0x77, 0x02,
  0xF9, 0x71, 0x02, 0x0E, 0xF9, 0x06, 0x77, 0x05, 0xF0, 0xC7, 0x20, 0x8F, 0x90, 0x27, 0x70, 0x8F,
  0x09, 0x72, 0x06, 0xF0, 0xE7, 0x71, 0x0C, 0xF0, 0x67, 0x20, 0x6F, 0x0B, 0x77, 0x1F, 0x90, 0x27,
  0x20, 0x8F, 0x08, 0x77, 0x03, 0xF0, 0xE7, 0x30, 0xAF, 0x04, 0x77, 0x06, 0xF0, 0xB7, 0x30, 0xDF,
  0x01, 0x77, 0x09, 0xF0, 0x87, 0x20, 0x1F, 0x0D, 0x77, 0x10, 0xDF, 0x04, 0x72, 0x04, 0xF0, 0xA7,
  0x70, 0x1F, 0x90, 0x17, 0x20, 0x7F, 0x07, 0x77, 0x04, 0xF0, 0xD7, 0x30, 0xBF, 0x03, 0x77, 0x07,
  0xF0, 0xA7, 0x30, 0xEF, 0x77, 0x10, 0xAF, 0x07, 0x72, 0x02, 0xF0, 0xC7, 0x71, 0x0E, 0xF0, 0x37,
  0x20, 0x6F, 0x09, 0x77, 0x01, 0xF9, 0x73, 0x09, 0xF0, 0x57, 0x70, 0x5F, 0x0C, 0x73, 0x0D, 0xF0,
  0x27, 0x70, 0x8F, 0x09, 0x72, 0x01, 0xF0, 0xE7, 0x71, 0x0B, 0xF0, 0x57, 0x20, 0x4F, 0x0B, 0x77,
  0x10, 0xEF, 0x02, 0x72, 0x07, 0xF0, 0x77, 0x70, 0x4F, 0x0E, 0x73, 0x0B, 0xF0, 0x47, 0x70, 0x8F,
  0x0B, 0x73, 0x0E, 0xF0, 0x17, 0x70, 0xCF, 0x08, 0x72, 0x02, 0xF0, 0xD7, 0x70, 0x2F, 0x90, 0x47,
  0x20, 0x6F, 0x09, 0x77, 0x08, 0xF9, 0x01, 0x72, 0x09, 0xF0, 0x67, 0x70, 0xDF, 0x0D, 0x73, 0x0D,
  0xF0, 0x27, 0x60, 0x4F, 0x90, 0xA7, 0x20, 0x1F, 0x0E, 0x77, 0x0B, 0xF9, 0x07, 0x72, 0x04, 0xF0,
  0xC7, 0x60, 0x3F, 0xA0, 0x47, 0x20, 0x7F, 0x08, 0x76, 0x0B, 0xFA, 0x01, 0x72, 0x0A, 0xF0, 0x67,
  0x50, 0x4F, 0xA0, 0xE7, 0x30, 0xDF, 0x03, 0x75, 0x0D, 0xFA, 0x0C, 0x73, 0xF9, 0x01, 0x74, 0x07,
  0xFB, 0x0A, 0x72, 0x03, 0xF9, 0x74, 0x02, 0x0E, 0xA0, 0xDF, 0x08, 0x72, 0x04, 0xF9, 0x74, 0x0C,
  0xA0, 0x70, 0x9F, 0x07, 0x72, 0x05, 0xF9, 0x73, 0x09, 0xA8, 0x1C, 0x0A, 0xF0, 0x77, 0x20, 0x6F,
  0x90, 0x17, 0x10, 0x8B, 0x81, 0x30, 0xCF, 0x07, 0x72, 0x05, 0xF9, 0x05, 0x70, 0x8B, 0x06, 0x20,
  0xCF, 0x08, 0x72, 0x04, 0xF9, 0x0B, 0x50, 0x10, 0xAB, 0x0A, 0x30, 0xCF, 0x0D, 0x58, 0x31, 0xA1,
  0x01, 0xFA, 0x84, 0x91, 0x02, 0x7E, 0xB0, 0xD4, 0x0B, 0xF9, 0x08, 0x20, 0x30, 0x9A, 0x08, 0x20,
  0xDF, 0xFA, 0x0E, 0x02, 0x40, 0x8F, 0xFA, 0x81, 0x10, 0x7F, 0xF9, 0x0E, 0x03, 0x50, 0x3F, 0xF9,
  0x06, 0x20, 0x10, 0xEF, 0xE0, 0xE0, 0x47, 0x0C, 0xFD, 0x0E, 0x05, 0x40, 0x6F, 0xD0, 0xD0, 0x37,
  0x10, 0x3F, 0xC0, 0xC0, 0x26, 0x07, 0xFB, 0x08, 0x01, 0x73, 0x05, 0xF9, 0x0E, 0x07, 0x72, 0x89,
  0x02, 0x8C, 0xEF, 0xED, 0xA6, 0x17, 0x68, 0x72, 0x9D, 0xEF, 0xDB, 0x61, 0x60,
  // "ü" (U+00FC)
  0x77, 0x38, 0x35, 0xCF, 0xD7, 0x73, 0x83, 0x6D, 0xFD, 0x77, 0x77, 0x07, 0xD0, 0x97, 0x10, 0x8D,
  0x08, 0x77, 0x50, 0x2F, 0x01, 0x60, 0x2E, 0x0E, 0x77, 0x50, 0x7F, 0x03, 0x60, 0x8F, 0x02, 0x77,
  0x40, 0xBF, 0x04, 0x60, 0xCF, 0x03, 0x77, 0x40, 0xCF, 0x03, 0x60, 0xDF, 0x02, 0x77, 0x40, 0xBF,
  0x70, 0xCF, 0x77, 0x50, 0x9E, 0x0B, 0x70, 0xAE, 0x0A, 0x77, 0x50, 0x2D, 0x0E, 0x02, 0x70, 0x3D,
  0x0D, 0x01, 0x77, 0x68, 0x43, 0xBE, 0xEA, 0x17, 0x28, 0x44, 0xCF, 0xE9, 0x18, 0x0D, 0xF4, 0x00,
  0x8F, 0xF0, 0x77, 0x70, 0x4F, 0x0D, 0x30, 0xCF, 0xF0, 0x47, 0x70, 0x7F, 0x0A, 0x3F, 0xF9, 0x77,
  0x10, 0xBF, 0x07, 0x20, 0x3F, 0xF0, 0xC7, 0x71, 0x0E, 0xF0, 0x35, 0x81, 0x37, 0xEF, 0xA0, 0x97,
  0x70, 0x2F, 0x97, 0x10, 0x20, 0xEF, 0x90, 0x67, 0x70, 0x5F, 0x0C, 0x72, 0x08, 0xF9, 0x02, 0x77,
  0x08, 0xF0, 0x97, 0x20, 0x6F, 0x0E, 0x77, 0x10, 0xCF, 0x06, 0x72, 0x06, 0xF0, 0xB7, 0x71, 0xF9,
  0x02, 0x72, 0x08, 0xF0, 0x87, 0x70, 0x3F, 0x0E, 0x73, 0x0A, 0xF0, 0x47, 0x70, 0x6F, 0x0B, 0x73,
  0x0D, 0xF0, 0x17, 0x70, 0x9F, 0x08, 0x72, 0x01, 0xF0, 0xD7, 0x71, 0x0D, 0xF0, 0x47, 0x20, 0x4F,
  0x0A, 0x77, 0x01, 0xF9, 0x01, 0x72, 0x07, 0xF0, 0x77, 0x70, 0x4F, 0x0D, 0x73, 0x0B, 0xF0, 0x37,
  0x70, 0x7F, 0x0A, 0x73, 0x0E, 0xF7, 0x71, 0x0A, 0xF0, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x10, 0xEF,
  0x03, 0x72, 0x06, 0xF0, 0x97, 0x70, 0x1F, 0x97, 0x30, 0x9F, 0x05, 0x77, 0x05, 0xF0, 0xC7, 0x30,
  0xDF, 0x02, 0x77, 0x08, 0xF0, 0x97, 0x20, 0x1F, 0x0E, 0x77, 0x10, 0xBF, 0x05, 0x72, 0x04, 0xF0,
  0xB7, 0x71, 0x0E, 0xF0, 0x27, 0x20, 0x7F, 0x07, 0x77, 0x04, 0xF0, 0xE7, 0x30, 0xBF, 0x04, 0x77,
  0x08, 0xF0, 0xB7, 0x30, 0xEF, 0x01, 0x77, 0x0C, 0xF0, 0x87, 0x20, 0x2F, 0x0D, 0x77, 0x02, 0xF9,
  0x04, 0x72, 0x06, 0xF0, 0x97, 0x70, 0x8F, 0x90, 0x17, 0x20, 0x9F, 0x06, 0x77, 0x0D, 0xF0, 0xD7,
  0x30, 0xDF, 0x02, 0x76, 0x04, 0xF9, 0x0A, 0x72, 0x01, 0xF0, 0xE7, 0x70, 0xBF, 0x90, 0x77, 0x20,
  0x4F, 0x0C, 0x76, 0x03, 0xFA, 0x04, 0x72, 0x07, 0xF0, 0x87, 0x60, 0xBF, 0xA0, 0x17, 0x20, 0xAF,
  0x06, 0x75, 0x04, 0xFA, 0x0E, 0x73, 0x0D, 0xF0, 0x37, 0x50, 0xDF, 0xA0, 0xC7, 0x3F, 0x90, 0x17,
  0x40, 0x7F, 0xB0, 0xA7, 0x20, 0x3F, 0x97, 0x40, 0x20, 0xEA, 0x0D, 0xF0, 0x87, 0x20, 0x4F, 0x97,
  0x40, 0xCA, 0x07, 0x09, 0xF0, 0x77, 0x20, 0x5F, 0x97, 0x30, 0x9A, 0x81, 0xC0, 0xAF, 0x07, 0x72,
  0x06, 0xF9, 0x01, 0x71, 0x08, 0xB8, 0x13, 0x0C, 0xF0, 0x77, 0x20, 0x5F, 0x90, 0x57, 0x08, 0xB0,
  0x62, 0x0C, 0xF0, 0x87, 0x20, 0x4F, 0x90, 0xB5, 0x01, 0x0A, 0xB0, 0xA3, 0x0C, 0xF0, 0xD5, 0x83,
  0x1A, 0x10, 0x1F, 0xA8, 0x49, 0x10, 0x27, 0xEB, 0x0D, 0x40, 0xBF, 0x90, 0x82, 0x03, 0x09, 0xA0,
  0x82, 0x0D, 0xFF, 0xA0, 0xE0, 0x24, 0x08, 0xFF, 0xA8, 0x11, 0x07, 0xFF, 0x90, 0xE0, 0x35, 0x03,
  0xFF, 0x90, 0x62, 0x01, 0x0E, 0xFE, 0x0E, 0x04, 0x70, 0xCF, 0xD0, 0xE0, 0x54, 0x06, 0xFD, 0x0D,
  0x03, 0x71, 0x03, 0xFC, 0x0C, 0x02, 0x60, 0x7F, 0xB0, 0x80, 0x17, 0x30, 0x5F, 0x90, 0xE0, 0x77,
  0x28, 0x90, 0x28, 0xCE, 0xFE, 0xDA, 0x61, 0x76, 0x87, 0x29, 0xDE, 0xFD, 0xB6, 0x16,
  // "ý" (U+00FD)
  0x80, 0xC7, 0x08, 0x05, 0x70, 0x18, 0x0C, 0x70, 0x06, 0xF9, 0x0D, 0x80, 0xD0, 0x00, 0xEF, 0x0E,
  0x02, 0x80, 0xC7, 0x00, 0x8F, 0x90, 0x48, 0x0C, 0x70, 0x02, 0xF9, 0x05, 0x80, 0xD0, 0x00, 0xCF,
  0x06, 0x80, 0xD0, 0x00, 0x6F, 0x07, 0x80, 0xD0, 0x00, 0x10, 0xEE, 0x07, 0x80, 0xD1, 0x00, 0xBE,
  0x07, 0x80, 0xD1, 0x00, 0x7E, 0x06, 0x80, 0xD1, 0x00, 0x2E, 0x05, 0x80, 0xD2, 0x00, 0xDC, 0x0E,
  0x03, 0x80, 0xD2, 0x00, 0xAC, 0x0C, 0x02, 0x80, 0xD2, 0x00, 0x6C, 0x0A, 0x80, 0xD4, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xD8, 0x60, 0x85, 0x19, 0xDF, 0xD8, 0x17, 0x73, 0x0B, 0xFC, 0x05, 0x77, 0x20,
  0x30, 0xED, 0x0D, 0x01, 0x77, 0x20, 0xEF, 0xC0, 0x87, 0x72, 0x0D, 0xF0, 0xB7, 0x71, 0x02, 0xFD,
  0x0B, 0x77, 0x10, 0x7F, 0xA0, 0x27, 0x70, 0x5F, 0xD0, 0xE7, 0x71, 0x0B, 0xFA, 0x06, 0x77, 0x28,
  0x11, 0x5C, 0xFA, 0x02, 0x77, 0x0E, 0xFA, 0x09, 0x77, 0x50, 0xCF, 0x90, 0x57, 0x70, 0xA0, 0xDF,
  0x90, 0xA7, 0x75, 0x03, 0xF9, 0x08, 0x77, 0x20, 0x9F, 0x0A, 0x77, 0x60, 0xCF, 0x0C, 0x77, 0x30,
  0xDE, 0x09, 0x77, 0x60, 0x8F, 0x97, 0x73, 0x07, 0xE0, 0x87, 0x76, 0x04, 0xF9, 0x03, 0x77, 0x20,
  0x4E, 0x07, 0x77, 0x60, 0x1F, 0x90, 0x67, 0x72, 0x02, 0xE0, 0x47, 0x77, 0x0C, 0xF0, 0x97, 0x72,
  0x03, 0xE0, 0x27, 0x77, 0x09, 0xF0, 0xC7, 0x72, 0x03, 0xD0, 0xE7, 0x77, 0x10, 0x6F, 0x97, 0x72,
  0x05, 0xD0, 0xB7, 0x77, 0x10, 0x2F, 0x90, 0x37, 0x71, 0x07, 0xD0, 0x77, 0x77, 0x20, 0xEF, 0x06,
  0x77, 0x10, 0xBD, 0x03, 0x77, 0x72, 0x0B, 0xF0, 0xA7, 0x71, 0x0E, 0xC0, 0xD7, 0x77, 0x30, 0x7F,
  0x0D, 0x77, 0x02, 0xD0, 0x87, 0x77, 0x30, 0x4F, 0x90, 0x17, 0x60, 0x7D, 0x03, 0x77, 0x74, 0xF9,
  0x04, 0x76, 0x0B, 0xC0, 0xD7, 0x77, 0x50, 0xCF, 0x07, 0x75, 0x01, 0xD0, 0x77, 0x77, 0x50, 0x9F,
  0x0A, 0x75, 0x06, 0xD0, 0x17, 0x77, 0x50, 0x5F, 0x0E, 0x75, 0x0C, 0xC0, 0x97, 0x77, 0x60, 0x2F,
  0x90, 0x17, 0x30, 0x2D, 0x02, 0x77, 0x77, 0x0E, 0xF0, 0x57, 0x30, 0x9C, 0x0B, 0x77, 0x77, 0x10,
  0xBF, 0x08, 0x73, 0x0E, 0xC0, 0x37, 0x77, 0x71, 0x07, 0xF0, 0xB7, 0x20, 0x6C, 0x0C, 0x77, 0x77,
  0x20, 0x4F, 0x0E, 0x72, 0x0D, 0xC0, 0x57, 0x77, 0x73, 0xF9, 0x02, 0x70, 0x5C, 0x0C, 0x77, 0x77,
  0x40, 0xCF, 0x05, 0x70, 0xCC, 0x05, 0x77, 0x77, 0x40, 0x9F, 0x08, 0x60, 0x4C, 0x0C, 0x77, 0x77,
  0x50, 0x5F, 0x0B, 0x60, 0xCC, 0x05, 0x77, 0x77, 0x50, 0x2F, 0x0D, 0x50, 0x4C, 0x0C, 0x77, 0x77,
  0x70, 0xEF, 0x01, 0x40, 0xCC, 0x04, 0x77, 0x77, 0x70, 0xBF, 0x03, 0x30, 0x5C, 0x0B, 0x80, 0xC0,
  0x00, 0x7F, 0x06, 0x30, 0xCC, 0x03, 0x80, 0xC0, 0x00, 0x4F, 0x09, 0x20, 0x6C, 0x0A, 0x80, 0xC2,
  0x0F, 0x0B, 0x20, 0xEC, 0x02, 0x80, 0xC2, 0x00, 0xCE, 0x81, 0xE0, 0x8C, 0x08, 0x80, 0xC3, 0x00,
  0x9F, 0x02, 0x0E, 0xB0, 0xE8, 0x0C, 0x40, 0x05, 0xF0, 0xCC, 0x06, 0x80, 0xC4, 0x00, 0x2F, 0xC0,
  0xC8, 0x0C, 0x60, 0x0E, 0xFB, 0x03, 0x80, 0xC6, 0x00, 0xBF, 0xA0, 0xA8, 0x0C, 0x70, 0x07, 0xF9,
  0x0E, 0x01, 0x80, 0xC7, 0x00, 0x4F, 0x90, 0x68, 0x0D, 0x10, 0xF0, 0xC8, 0x0D, 0x20, 0x0C, 0xE0,
  0x38, 0x0D, 0x20, 0x09, 0xD0, 0x98, 0x0D, 0x20, 0x01, 0x0E, 0xC0, 0xE0, 0x18, 0x0D, 0x20, 0x0B,
  0xD0, 0x58, 0x0D, 0x20, 0x07, 0xD0, 0xA8, 0x0D, 0x20, 0x04, 0xD0, 0xE0, 0x18, 0x0D, 0x10, 0x01,
  0x0E, 0xD0, 0x68, 0x0D, 0x20, 0x0C, 0xD0, 0xB8, 0x0D, 0x20, 0x0A, 0xD0, 0xE0, 0x28, 0x0D, 0x10,
  0x08, 0xE0, 0x58, 0x0D, 0x10, 0x08, 0xE0, 0xA8, 0x0D, 0x10, 0x08, 0xE0, 0xD8, 0x0D, 0x10, 0x09,
  0xE0, 0xE0, 0x28, 0x0C, 0x70, 0x01, 0x0B, 0xF0, 0x48, 0x0C, 0x70, 0x04, 0x0E, 0xF0, 0x68, 0x0C,
  0x60, 0x02, 0x0A, 0xF9, 0x07, 0x80, 0xC5, 0x00, 0x20, 0x8F, 0xA0, 0x77, 0x77, 0x72, 0x82, 0xB8,
  0x42, 0x48, 0x22, 0x47, 0xCF, 0xB0, 0x57, 0x77, 0x72, 0x03, 0xFF, 0xE0, 0xD0, 0x37, 0x77, 0x73,
  0x07, 0xFF, 0xD0, 0x87, 0x77, 0x75, 0x0C, 0xFF, 0xB0, 0xA0, 0x27, 0x77, 0x76, 0x0A, 0xFF, 0x81,
  0xD7, 0x18, 0x0C, 0x10, 0x83, 0x15, 0x9C, 0xEA, 0x85, 0xEE, 0xDB, 0x85, 0x28, 0x0C, 0x30,
  // "þ" (U+00FE)
  0x75, 0x06, 0xFF, 0x08, 0x77, 0x77, 0x10, 0x9F, 0xF0, 0x57, 0x77, 0x71, 0x0C, 0xFF, 0x01, 0x77,
  0x77, 0x1F, 0xF0, 0xE7, 0x77, 0x73, 0x82, 0x13, 0x7D, 0xFA, 0x0A, 0x77, 0x77, 0x60, 0x10, 0xDF,
  0x90, 0x77, 0x77, 0x77, 0x06, 0xF9, 0x04, 0x77, 0x77, 0x70, 0x4F, 0x98, 0x0C, 0x00, 0x04, 0xF0,
  0xD8, 0x0C, 0x00, 0x06, 0xF0, 0x98, 0x0C, 0x00, 0x09, 0xF0, 0x68, 0x0C, 0x00, 0x0D, 0xF0, 0x37,
  0x77, 0x77, 0x01, 0xF0, 0xE8, 0x0C, 0x00, 0x04, 0xF0, 0xB8, 0x0C, 0x00, 0x07, 0xF0, 0x88, 0x0C,
  0x00, 0x0A, 0xF0, 0x58, 0x0C, 0x00, 0x0E, 0xF0, 0x27, 0x77, 0x77, 0x01, 0xF0, 0xE8, 0x0C, 0x00,
  0x05, 0xF0, 0xA8, 0x0C, 0x00, 0x08, 0xF0, 0x77, 0x86, 0x5A, 0xDE, 0xFD, 0xB5, 0x77, 0x70, 0xBF,
  0x04, 0x50, 0x70, 0xEF, 0x90, 0xD0, 0x37, 0x75, 0x0E, 0xF4, 0x02, 0x0C, 0xFD, 0x04, 0x77, 0x30,
  0x2F, 0x0C, 0x30, 0x30, 0xEF, 0xE0, 0xE0, 0x27, 0x72, 0x06, 0xF0, 0x82, 0x03, 0x0E, 0xFF, 0x90,
  0xB7, 0x72, 0x09, 0xF8, 0x24, 0x01, 0xDB, 0x84, 0x93, 0x01, 0x6E, 0xF9, 0x04, 0x77, 0x10, 0xCE,
  0x0E, 0x20, 0xBA, 0x0E, 0x03, 0x50, 0x3F, 0x90, 0xB7, 0x71, 0xF8, 0x1A, 0x06, 0xA0, 0xD0, 0x27,
  0x0A, 0xF9, 0x77, 0x03, 0xF8, 0x45, 0x2E, 0xFE, 0x27, 0x10, 0x5F, 0x90, 0x57, 0x60, 0x7F, 0x01,
  0x0B, 0xA0, 0x47, 0x20, 0x2F, 0x90, 0x87, 0x60, 0xAE, 0x0B, 0x04, 0xA0, 0x87, 0x40, 0xDF, 0x0A,
  0x76, 0x0D, 0xE8, 0x27, 0xDF, 0xD7, 0x50, 0xBF, 0x0C, 0x75, 0x01, 0xFB, 0x04, 0x75, 0x0A, 0xF0,
  0xE7, 0x50, 0x4F, 0xA0, 0xB7, 0x60, 0x9F, 0x0E, 0x75, 0x08, 0xFA, 0x03, 0x76, 0x08, 0xF9, 0x75,
  0x0B, 0xF9, 0x0A, 0x77, 0x08, 0xF9, 0x75, 0x0E, 0xF9, 0x03, 0x77, 0x09, 0xF0, 0xE7, 0x40, 0x2F,
  0x90, 0xC7, 0x71, 0x0A, 0xF0, 0xD7, 0x40, 0x5F, 0x90, 0x57, 0x71, 0x0B, 0xF0, 0xC7, 0x40, 0x9F,
  0x0E, 0x77, 0x20, 0xDF, 0x0B, 0x74, 0x0C, 0xF0, 0x97, 0x72, 0xF9, 0x09, 0x74, 0xF9, 0x03, 0x77,
  0x10, 0x2F, 0x90, 0x67, 0x30, 0x3F, 0x0E, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x30, 0x6F, 0x0A, 0x77,
  0x20, 0x8F, 0x90, 0x17, 0x30, 0xAF, 0x05, 0x77, 0x20, 0xBF, 0x0D, 0x74, 0x0D, 0xF0, 0x27, 0x72,
  0x0E, 0xF0, 0x97, 0x30, 0x1F, 0x0E, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x30, 0x4F, 0x0A, 0x77, 0x20,
  0x7F, 0x90, 0x17, 0x30, 0x7F, 0x07, 0x77, 0x20, 0xCF, 0x0C, 0x74, 0x0A, 0xF0, 0x37, 0x71, 0x01,
  0xF9, 0x07, 0x74, 0x0E, 0xF7, 0x72, 0x06, 0xF9, 0x01, 0x73, 0x02, 0xF0, 0xC7, 0x72, 0x0B, 0xF0,
  0xA7, 0x40, 0x5F, 0x09, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x40, 0x8F, 0x05, 0x77, 0x10, 0x8F, 0x0D,
  0x75, 0x0B, 0xF0, 0x27, 0x71, 0x0E, 0xF0, 0x67, 0x50, 0xEE, 0x0E, 0x77, 0x10, 0x6F, 0x0D, 0x75,
  0x03, 0xF0, 0xB7, 0x71, 0x0D, 0xF0, 0x67, 0x50, 0x6F, 0x07, 0x77, 0x06, 0xF0, 0xD7, 0x60, 0x9F,
  0x04, 0x76, 0x01, 0x0E, 0xF0, 0x47, 0x60, 0xCF, 0x01, 0x76, 0x0A, 0xF0, 0x97, 0x7F, 0x0D, 0x76,
  0x05, 0xF0, 0xD7, 0x70, 0x3F, 0x09, 0x75, 0x03, 0x0E, 0xF0, 0x37, 0x70, 0x7F, 0x09, 0x74, 0x02,
  0x0E, 0xF0, 0x67, 0x71, 0x0A, 0xF9, 0x08, 0x72, 0x03, 0x0E, 0xF0, 0x87, 0x72, 0x0D, 0xFA, 0x0B,
  0x01, 0x50, 0x10, 0x8F, 0x90, 0x87, 0x72, 0x01, 0xFD, 0x84, 0xB7, 0x67, 0xAE, 0xF9, 0x06, 0x77,
  0x30, 0x4F, 0xFF, 0xB0, 0xD0, 0x47, 0x74, 0x08, 0xF0, 0xEF, 0xF9, 0x09, 0x77, 0x60, 0xBE, 0x82,
  0xE1, 0x8E, 0xFB, 0x81, 0xE9, 0x27, 0x77, 0x0E, 0xE0, 0xC3, 0x89, 0x05, 0x9C, 0xEF, 0xED, 0xB9,
  0x57, 0x77, 0x20, 0x2F, 0x0A, 0x80, 0xC0, 0x00, 0x5F, 0x07, 0x80, 0xC0, 0x00, 0x9F, 0x04, 0x80,
  0xC0, 0x00, 0xCF, 0x01, 0x80, 0xC0, 0x0F, 0x0D, 0x80, 0xC0, 0x00, 0x3F, 0x0A, 0x80, 0xC0, 0x00,
  0x6F, 0x07, 0x80, 0xC0, 0x00, 0xAF, 0x04, 0x80, 0xC0, 0x00, 0xDF, 0x01, 0x77, 0x77, 0x70, 0x1F,
  0x0D, 0x80, 0xC0, 0x00, 0x4F, 0x09, 0x80, 0xC0, 0x00, 0x7F, 0x07, 0x80, 0xC0, 0x00, 0xBF, 0x06,
  0x80, 0xC0, 0x00, 0xEF, 0x06, 0x77, 0x77, 0x70, 0x2F, 0x90, 0x97, 0x77, 0x77, 0x05, 0xFA, 0x02,
  0x77, 0x77, 0x60, 0x8F, 0xA8, 0x1E, 0x73, 0x77, 0x77, 0x40, 0xCF, 0xF0, 0xA7, 0x77, 0x71, 0xFF,
  0x90, 0x77, 0x77, 0x70, 0x3F, 0xF9, 0x03, 0x77, 0x77, 0x06, 0xFF, 0x97, 0x77, 0x71,
  // "ÿ" (U+00FF)
  0x77, 0x77, 0x83, 0x5C, 0xFD, 0x77, 0x38, 0x36, 0xDF, 0xD7, 0x77, 0x77, 0x50, 0x7D, 0x09, 0x71,
  0x08, 0xD0, 0x87, 0x77, 0x73, 0x02, 0xF0, 0x16, 0x02, 0xE0, 0xE7, 0x77, 0x73, 0x07, 0xF0, 0x36,
  0x08, 0xF0, 0x27, 0x77, 0x72, 0x0B, 0xF0, 0x46, 0x0C, 0xF0, 0x37, 0x77, 0x72, 0x0C, 0xF0, 0x36,
  0x0D, 0xF0, 0x27, 0x77, 0x72, 0x0B, 0xF7, 0x0C, 0xF7, 0x77, 0x73, 0x09, 0xE0, 0xB7, 0x0A, 0xE0,
  0xA7, 0x77, 0x73, 0x02, 0xD0, 0xE0, 0x27, 0x03, 0xD0, 0xD0, 0x17, 0x77, 0x74, 0x84, 0x3B, 0xEE,
  0xA1, 0x72, 0x84, 0x4C, 0xFE, 0x91, 0x80, 0xFB, 0x70, 0x85, 0x19, 0xDF, 0xD8, 0x17, 0x73, 0x0B,
  0xFC, 0x05, 0x77, 0x20, 0x30, 0xED, 0x0D, 0x01, 0x77, 0x20, 0xEF, 0xC0, 0x87, 0x72, 0x0D, 0xF0,
  0xB7, 0x71, 0x02, 0xFD, 0x0B, 0x77, 0x10, 0x7F, 0xA0, 0x27, 0x70, 0x5F, 0xD0, 0xE7, 0x71, 0x0B,
  0xFA, 0x06, 0x77, 0x28, 0x11, 0x5C, 0xFA, 0x02, 0x77, 0x0E, 0xFA, 0x09, 0x77, 0x50, 0xCF, 0x90,
  0x57, 0x70, 0xA0, 0xDF, 0x90, 0xA7, 0x75, 0x03, 0xF9, 0x08, 0x77, 0x20, 0x9F, 0x0A, 0x77, 0x60,
  0xCF, 0x0C, 0x77, 0x30, 0xDE, 0x09, 0x77, 0x60, 0x8F, 0x97, 0x73, 0x07, 0xE0, 0x87, 0x76, 0x04,
  0xF9, 0x03, 0x77, 0x20, 0x4E, 0x07, 0x77, 0x60, 0x1F, 0x90, 0x67, 0x72, 0x02, 0xE0, 0x47, 0x77,
  0x0C, 0xF0, 0x97, 0x72, 0x03, 0xE0, 0x27, 0x77, 0x09, 0xF0, 0xC7, 0x72, 0x03, 0xD0, 0xE7, 0x77,
  0x10, 0x6F, 0x97, 0x72, 0x05, 0xD0, 0xB7, 0x77, 0x10, 0x2F, 0x90, 0x37, 0x71, 0x07, 0xD0, 0x77,
  0x77, 0x20, 0xEF, 0x06, 0x77, 0x10, 0xBD, 0x03, 0x77, 0x72, 0x0B, 0xF0, 0xA7, 0x71, 0x0E, 0xC0,
  0xD7, 0x77, 0x30, 0x7F, 0x0D, 0x77, 0x02, 0xD0, 0x87, 0x77, 0x30, 0x4F, 0x90, 0x17, 0x60, 0x7D,
  0x03, 0x77, 0x74, 0xF9, 0x04, 0x76, 0x0B, 0xC0, 0xD7, 0x77, 0x50, 0xCF, 0x07, 0x75, 0x01, 0xD0,
  0x77, 0x77, 0x50, 0x9F, 0x0A, 0x75, 0x06, 0xD0, 0x17, 0x77, 0x50, 0x5F, 0x0E, 0x75, 0x0C, 0xC0,
  0x97, 0x77, 0x60, 0x2F, 0x90, 0x17, 0x30, 0x2D, 0x02, 0x77, 0x77, 0x0E, 0xF0, 0x57, 0x30, 0x9C,
  0x0B, 0x77, 0x77, 0x10, 0xBF, 0x08, 0x73, 0x0E, 0xC0, 0x37, 0x77, 0x71, 0x07, 0xF0, 0xB7, 0x20,
  0x6C, 0x0C, 0x77, 0x77, 0x20, 0x4F, 0x0E, 0x72, 0x0D, 0xC0, 0x57, 0x77, 0x73, 0xF9, 0x02, 0x70,
  0x5C, 0x0C, 0x77, 0x77, 0x40, 0xCF, 0x05, 0x70, 0xCC, 0x05, 0x77, 0x77, 0x40, 0x9F, 0x08, 0x60,
  0x4C, 0x0C, 0x77, 0x77, 0x50, 0x5F, 0x0B, 0x60, 0xCC, 0x05, 0x77, 0x77, 0x50, 0x2F, 0x0D, 0x50,
  0x4C, 0x0C, 0x77, 0x77, 0x70, 0xEF, 0x01, 0x40, 0xCC, 0x04, 0x77, 0x77, 0x70, 0xBF, 0x03, 0x30,
  0x5C, 0x0B, 0x80, 0xC0, 0x00, 0x7F, 0x06, 0x30, 0xCC, 0x03, 0x80, 0xC0, 0x00, 0x4F, 0x09, 0x20,
  0x6C, 0x0A, 0x80, 0xC2, 0x0F, 0x0B, 0x20, 0xEC, 0x02, 0x80, 0xC2, 0x00, 0xCE, 0x81, 0xE0, 0x8C,
  0x08, 0x80, 0xC3, 0x00, 0x9F, 0x02, 0x0E, 0xB0, 0xE8, 0x0C, 0x40, 0x05, 0xF0, 0xCC, 0x06, 0x80,
  0xC4, 0x00, 0x2F, 0xC0, 0xC8, 0x0C, 0x60, 0x0E, 0xFB, 0x03, 0x80, 0xC6, 0x00, 0xBF, 0xA0, 0xA8,
  0x0C, 0x70, 0x07, 0xF9, 0x0E, 0x01, 0x80, 0xC7, 0x00, 0x4F, 0x90, 0x68, 0x0D, 0x10, 0xF0, 0xC8,
  0x0D, 0x20, 0x0C, 0xE0, 0x38, 0x0D, 0x20, 0x09, 0xD0, 0x98, 0x0D, 0x20, 0x01, 0x0E, 0xC0, 0xE0,
  0x18, 0x0D, 0x20, 0x0B, 0xD0, 0x58, 0x0D, 0x20, 0x07, 0xD0, 0xA8, 0x0D, 0x20, 0x04, 0xD0, 0xE0,
  0x18, 0x0D, 0x10, 0x01, 0x0E, 0xD0, 0x68, 0x0D, 0x20, 0x0C, 0xD0, 0xB8, 0x0D, 0x20, 0x0A, 0xD0,
  0xE0, 0x28, 0x0D, 0x10, 0x08, 0xE0, 0x58, 0x0D, 0x10, 0x08, 0xE0, 0xA8, 0x0D, 0x10, 0x08, 0xE0,
  0xD8, 0x0D, 0x10, 0x09, 0xE0, 0xE0, 0x28, 0x0C, 0x70, 0x01, 0x0B, 0xF0, 0x48, 0x0C, 0x70, 0x04,
  0x0E, 0xF0, 0x68, 0x0C, 0x60, 0x02, 0x0A, 0xF9, 0x07, 0x80, 0xC5, 0x00, 0x20, 0x8F, 0xA0, 0x77,
  0x77, 0x72, 0x82, 0xB8, 0x42, 0x48, 0x22, 0x47, 0xCF, 0xB0, 0x57, 0x77, 0x72, 0x03, 0xFF, 0xE0,
  0xD0, 0x37, 0x77, 0x73, 0x07, 0xFF, 0xD0, 0x87, 0x77, 0x75, 0x0C, 0xFF, 0xB0, 0xA0, 0x27, 0x77,
  0x76, 0x0A, 0xFF, 0x81, 0xD7, 0x18, 0x0C, 0x10, 0x83, 0x15, 0x9C, 0xEA, 0x85, 0xEE, 0xDB, 0x85,
  0x28, 0x0C, 0x30,
  // "Ā" (U+0100)
  0x77, 0x77, 0x50, 0xCF, 0xFF, 0x09, 0x77, 0x77, 0x6F, 0xFF, 0x90, 0x57, 0x77, 0x75, 0x04, 0xFF,
  0xF9, 0x01, 0x77, 0x77, 0x50, 0x8F, 0xFF, 0x0D, 0x77, 0x77, 0x60, 0xCF, 0xFF, 0x09, 0x80, 0xD8,
  0x10, 0x08, 0xE0, 0xB8, 0x0D, 0x40, 0x01, 0x0E, 0xE0, 0xD8, 0x0D, 0x40, 0x09, 0xF0, 0xE8, 0x0D,
  0x30, 0x02, 0xFA, 0x80, 0xD3, 0x00, 0xAF, 0xA0, 0x28, 0x0D, 0x10, 0x03, 0xFB, 0x03, 0x80, 0xD1,
  0x00, 0xBF, 0xB0, 0x58, 0x0D, 0x00, 0x04, 0xFC, 0x06, 0x80, 0xD0, 0x00, 0xCB, 0x0C, 0xF0, 0x88,
  0x0C, 0x70, 0x05, 0xC0, 0x5F, 0x09, 0x80, 0xC7, 0x00, 0xDB, 0x0B, 0x02, 0xF0, 0xB8, 0x0C, 0x60,
  0x06, 0xC0, 0x40, 0x2F, 0x0D, 0x80, 0xC6, 0x00, 0xDB, 0x81, 0xD0, 0x1F, 0x0E, 0x80, 0xC5, 0x00,
  0x7C, 0x81, 0x60, 0x1F, 0x98, 0x0C, 0x40, 0x01, 0x0E, 0xB0, 0xE3, 0xF9, 0x02, 0x80, 0xC3, 0x00,
  0x8C, 0x07, 0x3F, 0x90, 0x38, 0x0C, 0x20, 0x01, 0x0E, 0xB0, 0xE4, 0x0D, 0xF0, 0x58, 0x0C, 0x20,
  0x09, 0xC0, 0x64, 0x0C, 0xF0, 0x68, 0x0C, 0x10, 0x02, 0xC0, 0xD5, 0x0B, 0xF0, 0x88, 0x0C, 0x10,
  0x0A, 0xC0, 0x55, 0x0A, 0xF0, 0x98, 0x0C, 0x00, 0x03, 0xC0, 0xC6, 0x08, 0xF0, 0xB8, 0x0C, 0x00,
  0x0B, 0xC0, 0x46, 0x07, 0xF0, 0xD7, 0x77, 0x77, 0x04, 0xC0, 0xC7, 0x06, 0xF0, 0xE7, 0x77, 0x77,
  0x0C, 0xC0, 0x37, 0x04, 0xF9, 0x77, 0x77, 0x60, 0x5C, 0x0B, 0x71, 0x03, 0xF9, 0x02, 0x77, 0x77,
  0x50, 0xDC, 0x03, 0x71, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x40, 0x6C, 0x0A, 0x73, 0xF9, 0x05, 0x77,
  0x77, 0x40, 0xEC, 0x02, 0x73, 0x0E, 0xF0, 0x67, 0x77, 0x73, 0x07, 0xC0, 0x97, 0x40, 0xDF, 0x08,
  0x77, 0x77, 0x20, 0x10, 0xEC, 0x01, 0x74, 0x0B, 0xF0, 0xA7, 0x77, 0x72, 0x08, 0xC0, 0x87, 0x50,
  0xAF, 0x0B, 0x77, 0x77, 0x10, 0x1C, 0x0E, 0x01, 0x75, 0x09, 0xF0, 0xD7, 0x77, 0x71, 0x09, 0xC0,
  0x87, 0x60, 0x7F, 0x0E, 0x77, 0x77, 0x02, 0xC0, 0xE7, 0x70, 0x6F, 0x97, 0x77, 0x70, 0xAC, 0x07,
  0x77, 0x04, 0xF9, 0x02, 0x77, 0x75, 0x03, 0xC0, 0xD7, 0x71, 0x03, 0xF9, 0x03, 0x77, 0x75, 0x0B,
  0xC0, 0x67, 0x71, 0x02, 0xF9, 0x05, 0x77, 0x74, 0x04, 0xC0, 0xD7, 0x73, 0xF9, 0x06, 0x77, 0x74,
  0x0C, 0xFF, 0xFF, 0xA0, 0x87, 0x77, 0x30, 0x5F, 0xFF, 0xFB, 0x0A, 0x77, 0x73, 0x0D, 0xFF, 0xFF,
  0xB0, 0xB7, 0x77, 0x20, 0x6F, 0xFF, 0xFC, 0x0D, 0x77, 0x72, 0x0E, 0xC0, 0x88, 0x09, 0x76, 0x0B,
  0xF0, 0xE7, 0x77, 0x10, 0x7C, 0x0C, 0x77, 0x60, 0x8F, 0x97, 0x77, 0x01, 0x0E, 0xC0, 0x47, 0x76,
  0x07, 0xF9, 0x02, 0x77, 0x60, 0x8C, 0x0B, 0x77, 0x70, 0x5F, 0x90, 0x37, 0x75, 0x01, 0xD0, 0x37,
  0x77, 0x04, 0xF9, 0x05, 0x77, 0x50, 0x9C, 0x0B, 0x77, 0x71, 0x02, 0xF9, 0x07, 0x77, 0x40, 0x2D,
  0x03, 0x77, 0x71, 0x01, 0xF9, 0x08, 0x77, 0x40, 0xAC, 0x0A, 0x77, 0x73, 0xF9, 0x0A, 0x77, 0x30,
  0x3D, 0x02, 0x77, 0x73, 0x0E, 0xF0, 0xB7, 0x73, 0x0B, 0xC0, 0x97, 0x77, 0x40, 0xCF, 0x0D, 0x77,
  0x20, 0x4D, 0x02, 0x77, 0x74, 0x0B, 0xF0, 0xE7, 0x72, 0x0C, 0xC0, 0xA7, 0x77, 0x50, 0xAF, 0x97,
  0x71, 0x06, 0xD0, 0x47, 0x77, 0x50, 0xAF, 0x90, 0x27, 0x60, 0x10, 0xED, 0x01, 0x77, 0x75, 0x0B,
  0xF9, 0x05, 0x76, 0x0A, 0xD0, 0xE7, 0x77, 0x60, 0xEF, 0x90, 0x87, 0x50, 0x5E, 0x0E, 0x77, 0x75,
  0x05, 0xFA, 0x0D, 0x74, 0x03, 0x0E, 0xF0, 0x47, 0x77, 0x30, 0x30, 0xEF, 0xB0, 0x57, 0x10, 0x20,
  0x8F, 0xA8, 0x1E, 0x72, 0x77, 0x60, 0x30, 0x8F, 0xE0, 0x70, 0x13, 0x09, 0xFF, 0xC0, 0xB7, 0x60,
  0x3F, 0xFF, 0x81, 0x80, 0xCF, 0xFC, 0x08, 0x76, 0x06, 0xFF, 0xF8, 0x15, 0x0E, 0xFF, 0xC0, 0x57,
  0x60, 0x9F, 0xFF, 0x03, 0x02, 0xFF, 0xD0, 0x27, 0x60, 0xBF, 0xFF, 0x10,
  // "ā" (U+0101)
  0x77, 0x20, 0xCF, 0xFF, 0x09, 0x77, 0x5F, 0xFF, 0x90, 0x57, 0x74, 0x04, 0xFF, 0xF9, 0x01, 0x77,
  0x40, 0x8F, 0xFF, 0x0D, 0x77, 0x50, 0xCF, 0xFF, 0x09, 0x80, 0xBC, 0x50, 0x89, 0x11, 0x69, 0xCE,
  0xFE, 0xDB, 0x84, 0x77, 0x77, 0x10, 0x30, 0xBF, 0xC0, 0xD0, 0x64, 0x01, 0x0B, 0xA0, 0x77, 0x72,
  0x01, 0x0A, 0xFF, 0x98, 0x3D, 0x20, 0x6E, 0xB0, 0x37, 0x71, 0x05, 0x0E, 0xFF, 0xB0, 0xE0, 0xBD,
  0x77, 0x10, 0x8F, 0x98, 0x4E, 0x97, 0x68, 0xCF, 0xC0, 0xC7, 0x70, 0xAF, 0x0D, 0x05, 0x60, 0x30,
  0xDF, 0xA0, 0x97, 0x60, 0xAF, 0x0B, 0x01, 0x71, 0x01, 0x0D, 0xF9, 0x06, 0x75, 0x08, 0xF0, 0xA7,
  0x40, 0x5F, 0x90, 0x37, 0x40, 0x5F, 0x0B, 0x75, 0x02, 0xF9, 0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x60,
  0x5F, 0x0C, 0x74, 0x0B, 0xF0, 0x37, 0x60, 0x9F, 0x08, 0x73, 0x07, 0xF0, 0x97, 0x70, 0xCF, 0x05,
  0x72, 0x01, 0xF0, 0xE0, 0x17, 0x7F, 0x90, 0x27, 0x20, 0x9F, 0x08, 0x77, 0x03, 0xF0, 0xE7, 0x20,
  0x2F, 0x0E, 0x01, 0x77, 0x06, 0xF0, 0xB7, 0x20, 0xAF, 0x08, 0x77, 0x10, 0x9F, 0x08, 0x71, 0x02,
  0xF9, 0x02, 0x77, 0x10, 0xCF, 0x04, 0x71, 0x09, 0xF0, 0xB7, 0x72, 0xF9, 0x01, 0x71, 0x0E, 0xF0,
  0x57, 0x71, 0x03, 0xF0, 0xD7, 0x10, 0x5F, 0x0E, 0x77, 0x20, 0x6F, 0x0A, 0x71, 0x0B, 0xF0, 0xA7,
  0x72, 0x0A, 0xF0, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x20, 0xDF, 0x04, 0x70, 0x6F, 0x90, 0x27, 0x71,
  0x01, 0xF9, 0x71, 0x0A, 0xF0, 0xD7, 0x72, 0x04, 0xF0, 0xD7, 0x10, 0xEF, 0x09, 0x77, 0x20, 0x7F,
  0x09, 0x70, 0x3F, 0x90, 0x67, 0x72, 0x0B, 0xF0, 0x67, 0x07, 0xF9, 0x02, 0x77, 0x2F, 0x90, 0x37,
  0x0A, 0xF0, 0xE7, 0x72, 0x04, 0xF9, 0x71, 0x0D, 0xF0, 0xC7, 0x72, 0x09, 0xF0, 0xC7, 0x1F, 0x90,
  0xA7, 0x72, 0x0E, 0xF0, 0x97, 0x01, 0xF9, 0x08, 0x77, 0x10, 0x5F, 0x90, 0x67, 0x03, 0xF9, 0x05,
  0x77, 0x10, 0xBF, 0x90, 0x37, 0x04, 0xF9, 0x04, 0x77, 0x02, 0xFA, 0x71, 0x05, 0xF9, 0x03, 0x77,
  0x09, 0xF9, 0x0D, 0x71, 0x06, 0xF9, 0x03, 0x76, 0x01, 0xFA, 0x0A, 0x71, 0x05, 0xF9, 0x02, 0x76,
  0x08, 0xFA, 0x08, 0x71, 0x05, 0xF9, 0x03, 0x75, 0x02, 0xA0, 0xDF, 0x05, 0x71, 0x04, 0xF9, 0x03,
  0x75, 0x82, 0xBF, 0xD7, 0xF0, 0x37, 0x10, 0x2F, 0x90, 0x57, 0x40, 0x5A, 0x06, 0x0A, 0xF0, 0x17,
  0x2F, 0x90, 0x77, 0x38, 0x41, 0xEF, 0xD0, 0xCF, 0x73, 0x0D, 0xF0, 0xA7, 0x30, 0xBA, 0x81, 0x40,
  0xEE, 0x0E, 0x73, 0x09, 0xF0, 0xE7, 0x20, 0x9A, 0x0B, 0x2F, 0x0E, 0x73, 0x05, 0xF9, 0x05, 0x70,
  0x8A, 0x82, 0xE2, 0x01, 0xF9, 0x70, 0x13, 0x0E, 0xF0, 0xD0, 0x15, 0x0A, 0xB0, 0x52, 0x01, 0xF9,
  0x05, 0x58, 0x18, 0xE1, 0x20, 0x8F, 0x98, 0x4D, 0x40, 0x16, 0xDB, 0x09, 0x4F, 0x98, 0x4D, 0x30,
  0x27, 0xEA, 0x09, 0x20, 0x1F, 0xFA, 0x0A, 0x50, 0xCF, 0xF9, 0x0C, 0x30, 0x7F, 0xF0, 0xB6, 0x06,
  0xFF, 0x08, 0x50, 0xAF, 0xD0, 0x87, 0x10, 0xDF, 0xC0, 0xB0, 0x27, 0x08, 0xFA, 0x0C, 0x03, 0x72,
  0x02, 0x0D, 0xF9, 0x0C, 0x04, 0x73, 0x87, 0x28, 0xCE, 0xFD, 0xC8, 0x37, 0x68, 0x67, 0xCE, 0xFE,
  0xB8, 0x36,
  // "Ă" (U+0102)
  0x77, 0x77, 0x50, 0x5B, 0x06, 0x77, 0x0C, 0xB7, 0x77, 0x76, 0x04, 0xB0, 0x97, 0x60, 0x5B, 0x0B,
  0x77, 0x77, 0x60, 0x3B, 0x0D, 0x75, 0x01, 0x0E, 0xB0, 0x67, 0x77, 0x76, 0x01, 0xC0, 0x67, 0x40,
  0xCB, 0x0E, 0x80, 0xC0, 0x00, 0xDC, 0x05, 0x71, 0x03, 0x0D, 0xC0, 0x88, 0x0C, 0x00, 0x09, 0xD8,
  0x1B, 0x51, 0x28, 0x12, 0x5A, 0xD0, 0xD8, 0x0C, 0x10, 0x04, 0xFF, 0xC0, 0x58, 0x0C, 0x20, 0x0D,
  0xFF, 0xA0, 0x88, 0x0C, 0x30, 0x04, 0xFF, 0x90, 0xA8, 0x0C, 0x50, 0x07, 0xFE, 0x08, 0x80, 0xC7,
  0x00, 0x50, 0xEF, 0xA0, 0xC0, 0x48, 0x0D, 0x20, 0x87, 0x6A, 0xDE, 0xFD, 0xC8, 0x48, 0x0D, 0x90,
  0x00, 0x8E, 0x0B, 0x80, 0xD4, 0x00, 0x10, 0xEE, 0x0D, 0x80, 0xD4, 0x00, 0x9F, 0x0E, 0x80, 0xD3,
  0x00, 0x2F, 0xA8, 0x0D, 0x30, 0x0A, 0xFA, 0x02, 0x80, 0xD1, 0x00, 0x3F, 0xB0, 0x38, 0x0D, 0x10,
  0x0B, 0xFB, 0x05, 0x80, 0xD0, 0x00, 0x4F, 0xC0, 0x68, 0x0D, 0x00, 0x0C, 0xB0, 0xCF, 0x08, 0x80,
  0xC7, 0x00, 0x5C, 0x05, 0xF0, 0x98, 0x0C, 0x70, 0x0D, 0xB0, 0xB0, 0x2F, 0x0B, 0x80, 0xC6, 0x00,
  0x6C, 0x04, 0x02, 0xF0, 0xD8, 0x0C, 0x60, 0x0D, 0xB8, 0x1D, 0x01, 0xF0, 0xE8, 0x0C, 0x50, 0x07,
  0xC8, 0x16, 0x01, 0xF9, 0x80, 0xC4, 0x00, 0x10, 0xEB, 0x0E, 0x3F, 0x90, 0x28, 0x0C, 0x30, 0x08,
  0xC0, 0x73, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x10, 0xEB, 0x0E, 0x40, 0xDF, 0x05, 0x80, 0xC2, 0x00,
  0x9C, 0x06, 0x40, 0xCF, 0x06, 0x80, 0xC1, 0x00, 0x2C, 0x0D, 0x50, 0xBF, 0x08, 0x80, 0xC1, 0x00,
  0xAC, 0x05, 0x50, 0xAF, 0x09, 0x80, 0xC0, 0x00, 0x3C, 0x0C, 0x60, 0x8F, 0x0B, 0x80, 0xC0, 0x00,
  0xBC, 0x04, 0x60, 0x7F, 0x0D, 0x77, 0x77, 0x70, 0x4C, 0x0C, 0x70, 0x6F, 0x0E, 0x77, 0x77, 0x70,
  0xCC, 0x03, 0x70, 0x4F, 0x97, 0x77, 0x76, 0x05, 0xC0, 0xB7, 0x10, 0x3F, 0x90, 0x27, 0x77, 0x75,
  0x0D, 0xC0, 0x37, 0x10, 0x1F, 0x90, 0x37, 0x77, 0x74, 0x06, 0xC0, 0xA7, 0x3F, 0x90, 0x57, 0x77,
  0x74, 0x0E, 0xC0, 0x27, 0x30, 0xEF, 0x06, 0x77, 0x77, 0x30, 0x7C, 0x09, 0x74, 0x0D, 0xF0, 0x87,
  0x77, 0x72, 0x01, 0x0E, 0xC0, 0x17, 0x40, 0xBF, 0x0A, 0x77, 0x77, 0x20, 0x8C, 0x08, 0x75, 0x0A,
  0xF0, 0xB7, 0x77, 0x71, 0x01, 0xC0, 0xE0, 0x17, 0x50, 0x9F, 0x0D, 0x77, 0x77, 0x10, 0x9C, 0x08,
  0x76, 0x07, 0xF0, 0xE7, 0x77, 0x70, 0x2C, 0x0E, 0x77, 0x06, 0xF9, 0x77, 0x77, 0x0A, 0xC0, 0x77,
  0x70, 0x4F, 0x90, 0x27, 0x77, 0x50, 0x3C, 0x0D, 0x77, 0x10, 0x3F, 0x90, 0x37, 0x77, 0x50, 0xBC,
  0x06, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77, 0x40, 0x4C, 0x0D, 0x77, 0x3F, 0x90, 0x67, 0x77, 0x40,
  0xCF, 0xFF, 0xFA, 0x08, 0x77, 0x73, 0x05, 0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x30, 0xDF, 0xFF, 0xFB,
  0x0B, 0x77, 0x72, 0x06, 0xFF, 0xFF, 0xC0, 0xD7, 0x77, 0x20, 0xEC, 0x08, 0x80, 0x97, 0x60, 0xBF,
  0x0E, 0x77, 0x71, 0x07, 0xC0, 0xC7, 0x76, 0x08, 0xF9, 0x77, 0x70, 0x10, 0xEC, 0x04, 0x77, 0x60,
  0x7F, 0x90, 0x27, 0x76, 0x08, 0xC0, 0xB7, 0x77, 0x05, 0xF9, 0x03, 0x77, 0x50, 0x1D, 0x03, 0x77,
  0x70, 0x4F, 0x90, 0x57, 0x75, 0x09, 0xC0, 0xB7, 0x77, 0x10, 0x2F, 0x90, 0x77, 0x74, 0x02, 0xD0,
  0x37, 0x77, 0x10, 0x1F, 0x90, 0x87, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x3F, 0x90, 0xA7, 0x73, 0x03,
  0xD0, 0x27, 0x77, 0x30, 0xEF, 0x0B, 0x77, 0x30, 0xBC, 0x09, 0x77, 0x74, 0x0C, 0xF0, 0xD7, 0x72,
  0x04, 0xD0, 0x27, 0x77, 0x40, 0xBF, 0x0E, 0x77, 0x20, 0xCC, 0x0A, 0x77, 0x75, 0x0A, 0xF9, 0x77,
  0x10, 0x6D, 0x04, 0x77, 0x75, 0x0A, 0xF9, 0x02, 0x76, 0x01, 0x0E, 0xD0, 0x17, 0x77, 0x50, 0xBF,
  0x90, 0x57, 0x60, 0xAD, 0x0E, 0x77, 0x76, 0x0E, 0xF9, 0x08, 0x75, 0x05, 0xE0, 0xE7, 0x77, 0x50,
  0x5F, 0xA0, 0xD7, 0x40, 0x30, 0xEF, 0x04, 0x77, 0x73, 0x03, 0x0E, 0xFB, 0x05, 0x71, 0x02, 0x08,
  0xFA, 0x81, 0xE7, 0x27, 0x76, 0x03, 0x08, 0xFE, 0x07, 0x01, 0x30, 0x9F, 0xFC, 0x0B, 0x76, 0x03,
  0xFF, 0xF8, 0x18, 0x0C, 0xFF, 0xC0, 0x87, 0x60, 0x6F, 0xFF, 0x81, 0x50, 0xEF, 0xFC, 0x05, 0x76,
  0x09, 0xFF, 0xF0, 0x30, 0x2F, 0xFD, 0x02, 0x76, 0x0B, 0xFF, 0xF1,
  // "ă" (U+0103)
  0x77, 0x20, 0x5B, 0x06, 0x77, 0x0C, 0xB7, 0x75, 0x04, 0xB0, 0x97, 0x60, 0x5B, 0x0B, 0x77, 0x50,
  0x3B, 0x0D, 0x75, 0x01, 0x0E, 0xB0, 0x67, 0x75, 0x01, 0xC0, 0x67, 0x40, 0xCB, 0x0E, 0x77, 0x70,
  0xDC, 0x05, 0x71, 0x03, 0x0D, 0xC0, 0x87, 0x77, 0x09, 0xD8, 0x1B, 0x51, 0x28, 0x12, 0x5A, 0xD0,
  0xD7, 0x77, 0x10, 0x4F, 0xFC, 0x05, 0x77, 0x72, 0x0D, 0xFF, 0xA0, 0x87, 0x77, 0x30, 0x4F, 0xF9,
  0x0A, 0x77, 0x75, 0x07, 0xFE, 0x08, 0x77, 0x77, 0x05, 0x0E, 0xFA, 0x0C, 0x04, 0x77, 0x77, 0x38,
  0x76, 0xAD, 0xEF, 0xDC, 0x84, 0x80, 0xBD, 0x40, 0x89, 0x11, 0x69, 0xCE, 0xFE, 0xDB, 0x84, 0x77,
  0x77, 0x10, 0x30, 0xBF, 0xC0, 0xD0, 0x64, 0x01, 0x0B, 0xA0, 0x77, 0x72, 0x01, 0x0A, 0xFF, 0x98,
  0x3D, 0x20, 0x6E, 0xB0, 0x37, 0x71, 0x05, 0x0E, 0xFF, 0xB0, 0xE0, 0xBD, 0x77, 0x10, 0x8F, 0x98,
  0x4E, 0x97, 0x68, 0xCF, 0xC0, 0xC7, 0x70, 0xAF, 0x0D, 0x05, 0x60, 0x30, 0xDF, 0xA0, 0x97, 0x60,
  0xAF, 0x0B, 0x01, 0x71, 0x01, 0x0D, 0xF9, 0x06, 0x75, 0x08, 0xF0, 0xA7, 0x40, 0x5F, 0x90, 0x37,
  0x40, 0x5F, 0x0B, 0x75, 0x02, 0xF9, 0x74, 0x01, 0x0E, 0xE0, 0xD7, 0x60, 0x5F, 0x0C, 0x74, 0x0B,
  0xF0, 0x37, 0x60, 0x9F, 0x08, 0x73, 0x07, 0xF0, 0x97, 0x70, 0xCF, 0x05, 0x72, 0x01, 0xF0, 0xE0,
  0x17, 0x7F, 0x90, 0x27, 0x20, 0x9F, 0x08, 0x77, 0x03, 0xF0, 0xE7, 0x20, 0x2F, 0x0E, 0x01, 0x77,
  0x06, 0xF0, 0xB7, 0x20, 0xAF, 0x08, 0x77, 0x10, 0x9F, 0x08, 0x71, 0x02, 0xF9, 0x02, 0x77, 0x10,
  0xCF, 0x04, 0x71, 0x09, 0xF0, 0xB7, 0x72, 0xF9, 0x01, 0x71, 0x0E, 0xF0, 0x57, 0x71, 0x03, 0xF0,
  0xD7, 0x10, 0x5F, 0x0E, 0x77, 0x20, 0x6F, 0x0A, 0x71, 0x0B, 0xF0, 0xA7, 0x72, 0x0A, 0xF0, 0x77,
  0x01, 0xF9, 0x06, 0x77, 0x20, 0xDF, 0x04, 0x70, 0x6F, 0x90, 0x27, 0x71, 0x01, 0xF9, 0x71, 0x0A,
  0xF0, 0xD7, 0x72, 0x04, 0xF0, 0xD7, 0x10, 0xEF, 0x09, 0x77, 0x20, 0x7F, 0x09, 0x70, 0x3F, 0x90,
  0x67, 0x72, 0x0B, 0xF0, 0x67, 0x07, 0xF9, 0x02, 0x77, 0x2F, 0x90, 0x37, 0x0A, 0xF0, 0xE7, 0x72,
  0x04, 0xF9, 0x71, 0x0D, 0xF0, 0xC7, 0x72, 0x09, 0xF0, 0xC7, 0x1F, 0x90, 0xA7, 0x72, 0x0E, 0xF0,
  0x97, 0x01, 0xF9, 0x08, 0x77, 0x10, 0x5F, 0x90, 0x67, 0x03, 0xF9, 0x05, 0x77, 0x10, 0xBF, 0x90,
  0x37, 0x04, 0xF9, 0x04, 0x77, 0x02, 0xFA, 0x71, 0x05, 0xF9, 0x03, 0x77, 0x09, 0xF9, 0x0D, 0x71,
  0x06, 0xF9, 0x03, 0x76, 0x01, 0xFA, 0x0A, 0x71, 0x05, 0xF9, 0x02, 0x76, 0x08, 0xFA, 0x08, 0x71,
  0x05, 0xF9, 0x03, 0x75, 0x02, 0xA0, 0xDF, 0x05, 0x71, 0x04, 0xF9, 0x03, 0x75, 0x82, 0xBF, 0xD7,
  0xF0, 0x37, 0x10, 0x2F, 0x90, 0x57, 0x40, 0x5A, 0x06, 0x0A, 0xF0, 0x17, 0x2F, 0x90, 0x77, 0x38,
  0x41, 0xEF, 0xD0, 0xCF, 0x73, 0x0D, 0xF0, 0xA7, 0x30, 0xBA, 0x81, 0x40, 0xEE, 0x0E, 0x73, 0x09,
  0xF0, 0xE7, 0x20, 0x9A, 0x0B, 0x2F, 0x0E, 0x73, 0x05, 0xF9, 0x05, 0x70, 0x8A, 0x82, 0xE2, 0x01,
  0xF9, 0x70, 0x13, 0x0E, 0xF0, 0xD0, 0x15, 0x0A, 0xB0, 0x52, 0x01, 0xF9, 0x05, 0x58, 0x18, 0xE1,
  0x20, 0x8F, 0x98, 0x4D, 0x40, 0x16, 0xDB, 0x09, 0x4F, 0x98, 0x4D, 0x30, 0x27, 0xEA, 0x09, 0x20,
  0x1F, 0xFA, 0x0A, 0x50, 0xCF, 0xF9, 0x0C, 0x30, 0x7F, 0xF0, 0xB6, 0x06, 0xFF, 0x08, 0x50, 0xAF,
  0xD0, 0x87, 0x10, 0xDF, 0xC0, 0xB0, 0x27, 0x08, 0xFA, 0x0C, 0x03, 0x72, 0x02, 0x0D, 0xF9, 0x0C,
  0x04, 0x73, 0x87, 0x28, 0xCE, 0xFD, 0xC8, 0x37, 0x68, 0x67, 0xCE, 0xFE, 0xB8, 0x36,
  // "Ą" (U+0104)
  0x80, 0xC2, 0x00, 0x8E, 0x0B, 0x80, 0xD4, 0x00, 0x10, 0xEE, 0x0D, 0x80, 0xD4, 0x00, 0x9F, 0x0E,
  0x80, 0xD3, 0x00, 0x2F, 0xA8, 0x0D, 0x30, 0x0A, 0xFA, 0x02, 0x80, 0xD1, 0x00, 0x3F, 0xB0, 0x38,
  0x0D, 0x10, 0x0B, 0xFB, 0x05, 0x80, 0xD0, 0x00, 0x4F, 0xC0, 0x68, 0x0D, 0x00, 0x0C, 0xB0, 0xCF,
  0x08, 0x80, 0xC7, 0x00, 0x5C, 0x05, 0xF0, 0x98, 0x0C, 0x70, 0x0D, 0xB0, 0xB0, 0x2F, 0x0B, 0x80,
  0xC6, 0x00, 0x6C, 0x04, 0x02, 0xF0, 0xD8, 0x0C, 0x60, 0x0D, 0xB8, 0x1D, 0x01, 0xF0, 0xE8, 0x0C,
  0x50, 0x07, 0xC8, 0x16, 0x01, 0xF9, 0x80, 0xC4, 0x00, 0x10, 0xEB, 0x0E, 0x3F, 0x90, 0x28, 0x0C,
  0x30, 0x08, 0xC0, 0x73, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x10, 0xEB, 0x0E, 0x40, 0xDF, 0x05, 0x80,
  0xC2, 0x00, 0x9C, 0x06, 0x40, 0xCF, 0x06, 0x80, 0xC1, 0x00, 0x2C, 0x0D, 0x50, 0xBF, 0x08, 0x80,
  0xC1, 0x00, 0xAC, 0x05, 0x50, 0xAF, 0x09, 0x80, 0xC0, 0x00, 0x3C, 0x0C, 0x60, 0x8F, 0x0B, 0x80,
  0xC0, 0x00, 0xBC, 0x04, 0x60, 0x7F, 0x0D, 0x77, 0x77, 0x70, 0x4C, 0x0C, 0x70, 0x6F, 0x0E, 0x77,
  0x77, 0x70, 0xCC, 0x03, 0x70, 0x4F, 0x97, 0x77, 0x76, 0x05, 0xC0, 0xB7, 0x10, 0x3F, 0x90, 0x27,
  0x77, 0x75, 0x0D, 0xC0, 0x37, 0x10, 0x1F, 0x90, 0x37, 0x77, 0x74, 0x06, 0xC0, 0xA7, 0x3F, 0x90,
  0x57, 0x77, 0x74, 0x0E, 0xC0, 0x27, 0x30, 0xEF, 0x06, 0x77, 0x77, 0x30, 0x7C, 0x09, 0x74, 0x0D,
  0xF0, 0x87, 0x77, 0x72, 0x01, 0x0E, 0xC0, 0x17, 0x40, 0xBF, 0x0A, 0x77, 0x77, 0x20, 0x8C, 0x08,
  0x75, 0x0A, 0xF0, 0xB7, 0x77, 0x71, 0x01, 0xC0, 0xE0, 0x17, 0x50, 0x9F, 0x0D, 0x77, 0x77, 0x10,
  0x9C, 0x08, 0x76, 0x07, 0xF0, 0xE7, 0x77, 0x70, 0x2C, 0x0E, 0x77, 0x06, 0xF9, 0x77, 0x77, 0x0A,
  0xC0, 0x77, 0x70, 0x4F, 0x90, 0x27, 0x77, 0x50, 0x3C, 0x0D, 0x77, 0x10, 0x3F, 0x90, 0x37, 0x77,
  0x50, 0xBC, 0x06, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77, 0x40, 0x4C, 0x0D, 0x77, 0x3F, 0x90, 0x67,
  0x77, 0x40, 0xCF, 0xFF, 0xFA, 0x08, 0x77, 0x73, 0x05, 0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x30, 0xDF,
  0xFF, 0xFB, 0x0B, 0x77, 0x72, 0x06, 0xFF, 0xFF, 0xC0, 0xD7, 0x77, 0x20, 0xEC, 0x08, 0x80, 0x97,
  0x60, 0xBF, 0x0E, 0x77, 0x71, 0x07, 0xC0, 0xC7, 0x76, 0x08, 0xF9, 0x77, 0x70, 0x10, 0xEC, 0x04,
  0x77, 0x60, 0x7F, 0x90, 0x27, 0x76, 0x08, 0xC0, 0xB7, 0x77, 0x05, 0xF9, 0x03, 0x77, 0x50, 0x1D,
  0x03, 0x77, 0x70, 0x4F, 0x90, 0x57, 0x75, 0x09, 0xC0, 0xB7, 0x77, 0x10, 0x2F, 0x90, 0x77, 0x74,
  0x02, 0xD0, 0x37, 0x77, 0x10, 0x1F, 0x90, 0x87, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x3F, 0x90, 0xA7,
  0x73, 0x03, 0xD0, 0x27, 0x77, 0x30, 0xEF, 0x0B, 0x77, 0x30, 0xBC, 0x09, 0x77, 0x74, 0x0C, 0xF0,
  0xD7, 0x72, 0x04, 0xD0, 0x27, 0x77, 0x40, 0xBF, 0x0E, 0x77, 0x20, 0xCC, 0x0A, 0x77, 0x75, 0x0A,
  0xF9, 0x77, 0x10, 0x6D, 0x04, 0x77, 0x75, 0x0A, 0xF9, 0x02, 0x76, 0x01, 0x0E, 0xD0, 0x17, 0x77,
  0x50, 0xBF, 0x90, 0x57, 0x60, 0xAD, 0x0E, 0x77, 0x76, 0x0E, 0xF9, 0x08, 0x75, 0x05, 0xE0, 0xE7,
  0x77, 0x50, 0x5F, 0xA0, 0xD7, 0x40, 0x30, 0xEF, 0x04, 0x77, 0x73, 0x03, 0x0E, 0xFB, 0x05, 0x71,
  0x02, 0x08, 0xFA, 0x81, 0xE7, 0x27, 0x76, 0x03, 0x08, 0xFE, 0x07, 0x01, 0x30, 0x9F, 0xFC, 0x0B,
  0x76, 0x03, 0xFF, 0xF8, 0x18, 0x0C, 0xFF, 0xC0, 0x87, 0x60, 0x6F, 0xFF, 0x81, 0x50, 0xEF, 0xFC,
  0x05, 0x76, 0x09, 0xFF, 0xF0, 0x30, 0x2F, 0xFD, 0x02, 0x76, 0x0B, 0xFF, 0xF8, 0x0D, 0x40, 0x84,
  0x16, 0x77, 0x75, 0x80, 0xD5, 0x00, 0x30, 0xAB, 0x0D, 0x05, 0x80, 0xD4, 0x00, 0x20, 0xBC, 0x08,
  0x80, 0xD5, 0x00, 0x7C, 0x0E, 0x04, 0x80, 0xD5, 0x00, 0xBC, 0x0E, 0x02, 0x80, 0xD5, 0x00, 0xCD,
  0x04, 0x80, 0xD5, 0x00, 0xBD, 0x07, 0x80, 0xD5, 0x00, 0x7D, 0x0D, 0x80, 0xD5, 0x00, 0x10, 0xED,
  0x06, 0x80, 0xD5, 0x00, 0x6E, 0x01, 0x80, 0xD5, 0x00, 0xBD, 0x0E, 0x80, 0xD6, 0x00, 0xDD, 0x0D,
  0x80, 0xD6, 0x0E, 0x0C, 0x80, 0xD6, 0x0E, 0x0E, 0x80, 0xD6, 0x00, 0xEE, 0x03, 0x80, 0xD5, 0x00,
  0xCE, 0x0C, 0x80, 0xD5, 0x00, 0x9F, 0x0C, 0x04, 0x28, 0x21, 0x48, 0xC8, 0x0C, 0x50, 0x03, 0xFF,
  0x0C, 0x80, 0xC6, 0x00, 0xAF, 0xE0, 0x98, 0x0C, 0x70, 0x0C, 0xFD, 0x06, 0x80, 0xD0, 0x00, 0x9F,
  0xB0, 0xD0, 0x28, 0x0D, 0x10, 0x89, 0x02, 0x8C, 0xEF, 0xED, 0xB8, 0x36,
  // "ą" (U+0105)
  0x77, 0x58, 0x91, 0x16, 0x9C, 0xEF, 0xED, 0xB8, 0x47, 0x77, 0x71, 0x03, 0x0B, 0xFC, 0x0D, 0x06,
  0x40, 0x10, 0xBA, 0x07, 0x77, 0x20, 0x10, 0xAF, 0xF9, 0x83, 0xD2, 0x06, 0xEB, 0x03, 0x77, 0x10,
  0x50, 0xEF, 0xFB, 0x0E, 0x0B, 0xD7, 0x71, 0x08, 0xF9, 0x84, 0xE9, 0x76, 0x8C, 0xFC, 0x0C, 0x77,
  0x0A, 0xF0, 0xD0, 0x56, 0x03, 0x0D, 0xFA, 0x09, 0x76, 0x0A, 0xF0, 0xB0, 0x17, 0x10, 0x10, 0xDF,
  0x90, 0x67, 0x50, 0x8F, 0x0A, 0x74, 0x05, 0xF9, 0x03, 0x74, 0x05, 0xF0, 0xB7, 0x50, 0x2F, 0x97,
  0x40, 0x10, 0xEE, 0x0D, 0x76, 0x05, 0xF0, 0xC7, 0x40, 0xBF, 0x03, 0x76, 0x09, 0xF0, 0x87, 0x30,
  0x7F, 0x09, 0x77, 0x0C, 0xF0, 0x57, 0x20, 0x1F, 0x0E, 0x01, 0x77, 0xF9, 0x02, 0x72, 0x09, 0xF0,
  0x87, 0x70, 0x3F, 0x0E, 0x72, 0x02, 0xF0, 0xE0, 0x17, 0x70, 0x6F, 0x0B, 0x72, 0x0A, 0xF0, 0x87,
  0x71, 0x09, 0xF0, 0x87, 0x10, 0x2F, 0x90, 0x27, 0x71, 0x0C, 0xF0, 0x47, 0x10, 0x9F, 0x0B, 0x77,
  0x2F, 0x90, 0x17, 0x10, 0xEF, 0x05, 0x77, 0x10, 0x3F, 0x0D, 0x71, 0x05, 0xF0, 0xE7, 0x72, 0x06,
  0xF0, 0xA7, 0x10, 0xBF, 0x0A, 0x77, 0x20, 0xAF, 0x07, 0x70, 0x1F, 0x90, 0x67, 0x72, 0x0D, 0xF0,
  0x47, 0x06, 0xF9, 0x02, 0x77, 0x10, 0x1F, 0x97, 0x10, 0xAF, 0x0D, 0x77, 0x20, 0x4F, 0x0D, 0x71,
  0x0E, 0xF0, 0x97, 0x72, 0x07, 0xF0, 0x97, 0x03, 0xF9, 0x06, 0x77, 0x20, 0xBF, 0x06, 0x70, 0x7F,
  0x90, 0x27, 0x72, 0xF9, 0x03, 0x70, 0xAF, 0x0E, 0x77, 0x20, 0x4F, 0x97, 0x10, 0xDF, 0x0C, 0x77,
  0x20, 0x9F, 0x0C, 0x71, 0xF9, 0x0A, 0x77, 0x20, 0xEF, 0x09, 0x70, 0x1F, 0x90, 0x87, 0x71, 0x05,
  0xF9, 0x06, 0x70, 0x3F, 0x90, 0x57, 0x71, 0x0B, 0xF9, 0x03, 0x70, 0x4F, 0x90, 0x47, 0x70, 0x2F,
  0xA7, 0x10, 0x5F, 0x90, 0x37, 0x70, 0x9F, 0x90, 0xD7, 0x10, 0x6F, 0x90, 0x37, 0x60, 0x1F, 0xA0,
  0xA7, 0x10, 0x5F, 0x90, 0x27, 0x60, 0x8F, 0xA0, 0x87, 0x10, 0x5F, 0x90, 0x37, 0x50, 0x2A, 0x0D,
  0xF0, 0x57, 0x10, 0x4F, 0x90, 0x37, 0x58, 0x2B, 0xFD, 0x7F, 0x03, 0x71, 0x02, 0xF9, 0x05, 0x74,
  0x05, 0xA0, 0x60, 0xAF, 0x01, 0x72, 0xF9, 0x07, 0x73, 0x84, 0x1E, 0xFD, 0x0C, 0xF7, 0x30, 0xDF,
  0x0A, 0x73, 0x0B, 0xA8, 0x14, 0x0E, 0xE0, 0xE7, 0x30, 0x9F, 0x0E, 0x72, 0x09, 0xA0, 0xB2, 0xF0,
  0xE7, 0x30, 0x5F, 0x90, 0x57, 0x08, 0xA8, 0x2E, 0x20, 0x1F, 0x97, 0x01, 0x30, 0xEF, 0x0D, 0x01,
  0x50, 0xAB, 0x05, 0x20, 0x1F, 0x90, 0x55, 0x81, 0x8E, 0x12, 0x08, 0xF9, 0x84, 0xD4, 0x01, 0x6D,
  0xB0, 0x94, 0xF9, 0x84, 0xD3, 0x02, 0x7E, 0xA0, 0x92, 0x01, 0xFF, 0xA0, 0xA5, 0x0C, 0xFF, 0x90,
  0xC3, 0x07, 0xFF, 0x0B, 0x60, 0x6F, 0xF0, 0x85, 0x0A, 0xFD, 0x08, 0x71, 0x0D, 0xFC, 0x0B, 0x02,
  0x70, 0x8F, 0xA0, 0xC0, 0x37, 0x20, 0x20, 0xDF, 0x90, 0xC0, 0x47, 0x38, 0x72, 0x8C, 0xEF, 0xDC,
  0x83, 0x76, 0x09, 0xD0, 0x80, 0x37, 0x77, 0x74, 0x03, 0x0A, 0xB0, 0xD0, 0x57, 0x77, 0x75, 0x02,
  0x0B, 0xC0, 0x87, 0x77, 0x76, 0x07, 0xC0, 0xE0, 0x47, 0x77, 0x76, 0x0B, 0xC0, 0xE0, 0x27, 0x77,
  0x76, 0x0C, 0xD0, 0x47, 0x77, 0x76, 0x0B, 0xD0, 0x77, 0x77, 0x76, 0x07, 0xD0, 0xD7, 0x77, 0x76,
  0x01, 0x0E, 0xD0, 0x67, 0x77, 0x76, 0x06, 0xE0, 0x17, 0x77, 0x76, 0x0B, 0xD0, 0xE7, 0x77, 0x77,
  0x0D, 0xD0, 0xD7, 0x77, 0x77, 0xE0, 0xC7, 0x77, 0x77, 0xE0, 0xE7, 0x77, 0x77, 0x0E, 0xE0, 0x37,
  0x77, 0x76, 0x0C, 0xE0, 0xC7, 0x77, 0x76, 0x09, 0xF0, 0xC0, 0x42, 0x82, 0x14, 0x8C, 0x77, 0x75,
  0x03, 0xFF, 0x0C, 0x77, 0x76, 0x0A, 0xFE, 0x09, 0x77, 0x77, 0x0C, 0xFD, 0x06, 0x77, 0x77, 0x10,
  0x9F, 0xB0, 0xD0, 0x27, 0x77, 0x72, 0x89, 0x02, 0x8C, 0xEF, 0xED, 0xB8, 0x37, 0x30,
  // "Ć" (U+0106)
  0x80, 0xC5, 0x08, 0x05, 0x70, 0x18, 0x0C, 0x40, 0x06, 0xF9, 0x0D, 0x80, 0xC5, 0x00, 0xEF, 0x0E,
  0x02, 0x80, 0xC4, 0x00, 0x8F, 0x90, 0x48, 0x0C, 0x40, 0x02, 0xF9, 0x05, 0x80, 0xC5, 0x00, 0xCF,
  0x06, 0x80, 0xC5, 0x00, 0x6F, 0x07, 0x80, 0xC5, 0x00, 0x10, 0xEE, 0x07, 0x80, 0xC6, 0x00, 0xBE,
  0x07, 0x80, 0xC6, 0x00, 0x7E, 0x06, 0x80, 0xC6, 0x00, 0x2E, 0x05, 0x80, 0xC7, 0x00, 0xDC, 0x0E,
  0x03, 0x80, 0xC7, 0x00, 0xAC, 0x0C, 0x02, 0x80, 0xC7, 0x00, 0x6C, 0x0A, 0x80, 0xD1, 0x00, 0xCA,
  0x0E, 0x05, 0x80, 0xBE, 0x10, 0x89, 0x42, 0x58, 0xBC, 0xDE, 0xFE, 0xDC, 0xA7, 0x47, 0x77, 0x76,
  0x81, 0x27, 0xDF, 0xF8, 0x1E, 0xA3, 0x77, 0x77, 0x10, 0x40, 0xBF, 0xFE, 0x09, 0x01, 0x77, 0x74,
  0x03, 0x0B, 0xFF, 0xFA, 0x0D, 0x02, 0x77, 0x72, 0x08, 0xFA, 0x85, 0xEA, 0x87, 0x68, 0xCF, 0xB0,
  0xD7, 0x77, 0x03, 0x0D, 0xF9, 0x0A, 0x03, 0x70, 0x30, 0xDF, 0xA0, 0x97, 0x75, 0x05, 0xF9, 0x0B,
  0x02, 0x73, 0x01, 0x0E, 0xFA, 0x01, 0x77, 0x30, 0x8F, 0x90, 0x77, 0x60, 0x6F, 0xA0, 0x67, 0x72,
  0x09, 0xF0, 0xE0, 0x47, 0x71, 0x0D, 0xF9, 0x08, 0x77, 0x10, 0x9F, 0x0E, 0x03, 0x77, 0x20, 0x8F,
  0x90, 0x97, 0x70, 0x8F, 0x90, 0x37, 0x73, 0x04, 0xF9, 0x08, 0x76, 0x05, 0xF9, 0x05, 0x77, 0x40,
  0x1F, 0x90, 0x57, 0x50, 0x3F, 0x90, 0x87, 0x76, 0x0E, 0xE0, 0xE0, 0x17, 0x40, 0x10, 0xDF, 0x0C,
  0x77, 0x70, 0xCE, 0x06, 0x75, 0x09, 0xF9, 0x03, 0x77, 0x70, 0xBD, 0x07, 0x75, 0x04, 0xF9, 0x09,
  0x77, 0x71, 0x0B, 0xB0, 0xC0, 0x47, 0x60, 0xDF, 0x0E, 0x01, 0x77, 0x71, 0x82, 0x79, 0x73, 0x77,
  0x07, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0x10, 0xEF, 0x0E, 0x80, 0xC5, 0x00, 0x9F, 0x90, 0x78, 0x0C,
  0x40, 0x01, 0xFA, 0x01, 0x80, 0xC4, 0x00, 0x8F, 0x90, 0x98, 0x0C, 0x50, 0x0E, 0xF9, 0x03, 0x80,
  0xC4, 0x00, 0x6F, 0x90, 0xC8, 0x0C, 0x50, 0x0C, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0x2F, 0xA0, 0x28,
  0x0C, 0x40, 0x08, 0xF9, 0x0C, 0x80, 0xC5, 0x00, 0xDF, 0x90, 0x78, 0x0C, 0x40, 0x02, 0xFA, 0x03,
  0x80, 0xC4, 0x00, 0x6F, 0x90, 0xE8, 0x0C, 0x50, 0x0A, 0xF9, 0x0B, 0x80, 0xC5, 0x00, 0xEF, 0x90,
  0x78, 0x0C, 0x40, 0x02, 0xFA, 0x04, 0x80, 0xC4, 0x00, 0x5F, 0xA8, 0x0C, 0x50, 0x07, 0xF9, 0x0D,
  0x80, 0xC5, 0x00, 0xAF, 0x90, 0xA8, 0x0C, 0x50, 0x0C, 0xF9, 0x08, 0x80, 0xC5, 0x00, 0xEF, 0x90,
  0x68, 0x0C, 0x50, 0xFA, 0x04, 0x80, 0xC4, 0x00, 0x1F, 0xA0, 0x28, 0x0C, 0x40, 0x02, 0xFA, 0x01,
  0x80, 0xC4, 0x00, 0x2F, 0xA8, 0x0C, 0x50, 0x03, 0xFA, 0x80, 0xC5, 0x00, 0x3F, 0xA8, 0x0C, 0x50,
  0x03, 0xFA, 0x80, 0xC5, 0x00, 0x2F, 0xA8, 0x0C, 0x50, 0x01, 0xFA, 0x01, 0x80, 0xC5, 0x0F, 0xA0,
  0x28, 0x0C, 0x50, 0x0D, 0xF9, 0x05, 0x80, 0xC5, 0x00, 0xAF, 0x90, 0x88, 0x0C, 0x50, 0x07, 0xF9,
  0x0B, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0x18, 0x0C, 0x50, 0x0E, 0xF9, 0x06, 0x77, 0x74, 0x0A, 0x02,
  0x77, 0x09, 0xF9, 0x0C, 0x77, 0x73, 0x81, 0x8F, 0x77, 0x70, 0x3F, 0xA0, 0x67, 0x77, 0x10, 0x6A,
  0x09, 0x77, 0x10, 0xBF, 0x90, 0xE0, 0x17, 0x76, 0x07, 0xB0, 0x97, 0x71, 0x03, 0xFA, 0x0C, 0x77,
  0x50, 0x9C, 0x06, 0x77, 0x20, 0x9F, 0xA0, 0xC0, 0x27, 0x71, 0x02, 0x0C, 0xD0, 0x17, 0x73, 0x0D,
  0xFA, 0x0E, 0x07, 0x75, 0x02, 0x08, 0xE0, 0x97, 0x74, 0x02, 0x0E, 0xFB, 0x83, 0xEA, 0x63, 0x12,
  0x83, 0x12, 0x47, 0xBF, 0x0E, 0x01, 0x77, 0x50, 0x30, 0xEF, 0xFF, 0xF0, 0x47, 0x77, 0x03, 0x0D,
  0xFF, 0xFD, 0x05, 0x77, 0x72, 0x01, 0x0A, 0xFF, 0xFA, 0x0D, 0x03, 0x77, 0x75, 0x04, 0x0C, 0xFF,
  0xE0, 0x87, 0x77, 0x72, 0x81, 0x4A, 0xEF, 0xF8, 0x1E, 0x81, 0x77, 0x77, 0x68, 0x44, 0x7A, 0xCD,
  0xEA, 0x84, 0xED, 0xC9, 0x73, 0x77, 0x71,
  // "ć" (U+0107)
  0x77, 0x77, 0x38, 0x05, 0x70, 0x17, 0x77, 0x72, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x30, 0xEF, 0x0E,
  0x02, 0x77, 0x77, 0x20, 0x8F, 0x90, 0x47, 0x77, 0x72, 0x02, 0xF9, 0x05, 0x77, 0x77, 0x30, 0xCF,
  0x06, 0x77, 0x77, 0x30, 0x6F, 0x07, 0x77, 0x77, 0x30, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x40, 0xBE,
  0x07, 0x77, 0x77, 0x40, 0x7E, 0x06, 0x77, 0x77, 0x40, 0x2E, 0x05, 0x77, 0x77, 0x50, 0xDC, 0x0E,
  0x03, 0x77, 0x77, 0x50, 0xAC, 0x0C, 0x02, 0x77, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0x77, 0x70, 0xCA,
  0x0E, 0x05, 0x80, 0xBD, 0x20, 0x89, 0x22, 0x69, 0xCD, 0xEF, 0xED, 0xB8, 0x37, 0x77, 0x60, 0x50,
  0xBF, 0xD0, 0xD0, 0x57, 0x77, 0x20, 0x40, 0xCF, 0xFA, 0x09, 0x77, 0x70, 0x9F, 0xFD, 0x09, 0x77,
  0x40, 0x20, 0xCF, 0x83, 0xB7, 0x68, 0xDF, 0xA0, 0x57, 0x72, 0x03, 0x0E, 0xE0, 0xA0, 0x15, 0x09,
  0xF9, 0x0D, 0x77, 0x10, 0x30, 0xEE, 0x07, 0x71, 0x0C, 0xF9, 0x03, 0x76, 0x02, 0x0E, 0xE0, 0x77,
  0x20, 0x3F, 0x90, 0x67, 0x50, 0x10, 0xDE, 0x09, 0x74, 0x0D, 0xF0, 0x77, 0x50, 0xAE, 0x0D, 0x75,
  0x08, 0xF0, 0x57, 0x40, 0x6F, 0x03, 0x75, 0x05, 0xF0, 0x17, 0x30, 0x10, 0xEE, 0x0A, 0x76, 0x02,
  0xE0, 0x97, 0x40, 0xAF, 0x02, 0x76, 0x01, 0xD0, 0xC7, 0x40, 0x3F, 0x0A, 0x77, 0x1C, 0x0A, 0x01,
  0x74, 0x0B, 0xF0, 0x37, 0x71, 0x82, 0xBA, 0x72, 0x75, 0x04, 0xF0, 0xD7, 0x77, 0x74, 0x0B, 0xF0,
  0x77, 0x77, 0x73, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x30, 0x8F, 0x0B, 0x77, 0x77, 0x40, 0xEF, 0x07,
  0x77, 0x77, 0x30, 0x3F, 0x90, 0x27, 0x77, 0x73, 0x08, 0xF0, 0xE7, 0x77, 0x74, 0x0C, 0xF0, 0xA7,
  0x77, 0x73, 0x01, 0xF9, 0x06, 0x77, 0x77, 0x30, 0x5F, 0x90, 0x37, 0x77, 0x73, 0x08, 0xF9, 0x77,
  0x77, 0x40, 0xBF, 0x0D, 0x77, 0x77, 0x40, 0xDF, 0x0B, 0x77, 0x77, 0x4F, 0x90, 0x97, 0x77, 0x73,
  0x01, 0xF9, 0x08, 0x77, 0x77, 0x30, 0x2F, 0x90, 0x77, 0x77, 0x73, 0x03, 0xF9, 0x06, 0x77, 0x77,
  0x30, 0x3F, 0x90, 0x67, 0x77, 0x73, 0x02, 0xF9, 0x07, 0x77, 0x77, 0x30, 0x2F, 0x90, 0x87, 0x77,
  0x74, 0xF9, 0x0A, 0x77, 0x77, 0x40, 0xEF, 0x0D, 0x77, 0x77, 0x40, 0xBF, 0x90, 0x17, 0x77, 0x73,
  0x08, 0xF9, 0x06, 0x77, 0x30, 0xA0, 0x77, 0x50, 0x4F, 0x90, 0xC7, 0x72, 0x81, 0x9F, 0xA7, 0x60,
  0xEF, 0x90, 0x57, 0x70, 0x9A, 0x09, 0x76, 0x08, 0xF9, 0x0E, 0x02, 0x74, 0x01, 0x0B, 0xB0, 0x57,
  0x60, 0x1F, 0xA0, 0xD0, 0x37, 0x20, 0x50, 0xEB, 0x0E, 0x77, 0x10, 0x7F, 0xB8, 0x1A, 0x51, 0x28,
  0x21, 0x48, 0xDD, 0x08, 0x77, 0x20, 0xCF, 0xFF, 0x90, 0xD7, 0x73, 0x01, 0x0D, 0xFF, 0xE0, 0xE0,
  0x27, 0x74, 0x01, 0x0C, 0xFF, 0xC0, 0xD0, 0x37, 0x77, 0x08, 0xFF, 0xA0, 0xA0, 0x17, 0x77, 0x20,
  0x20, 0xAF, 0xD0, 0xC0, 0x47, 0x77, 0x68, 0x31, 0x6A, 0xCE, 0xA8, 0x3E, 0xCA, 0x72, 0x77, 0x50,
  // "Ĉ" (U+0108)
  0x77, 0x77, 0x68, 0x04, 0x78, 0x0C, 0x40, 0x09, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0x4F, 0xA0, 0x78,
  0x0C, 0x10, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xC1, 0x00, 0xCF, 0xC0, 0x17, 0x77, 0x77, 0x09, 0xFD,
  0x07, 0x77, 0x77, 0x60, 0x6E, 0x0B, 0x0D, 0xD0, 0xC7, 0x77, 0x75, 0x03, 0xE8, 0x1A, 0x04, 0xE0,
  0x27, 0x77, 0x73, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x97, 0x77, 0x73, 0x0C, 0xD0, 0x84, 0x01,
  0x0E, 0xC0, 0xE7, 0x77, 0x72, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x77, 0x77, 0x70, 0x9C, 0x0E, 0x05,
  0x71, 0x09, 0xC0, 0xD7, 0x77, 0x60, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x77, 0x40, 0x5C,
  0x0A, 0x01, 0x74, 0x01, 0x0C, 0xB0, 0xD7, 0x77, 0x40, 0xCA, 0x0D, 0x04, 0x77, 0x01, 0x0C, 0xA0,
  0xD8, 0x0B, 0xB5, 0x08, 0x94, 0x25, 0x8B, 0xCD, 0xEF, 0xED, 0xCA, 0x74, 0x77, 0x77, 0x48, 0x12,
  0x7D, 0xFF, 0x81, 0xEA, 0x37, 0x77, 0x60, 0x40, 0xBF, 0xFE, 0x09, 0x01, 0x77, 0x72, 0x03, 0x0B,
  0xFF, 0xFA, 0x0D, 0x02, 0x77, 0x70, 0x8F, 0xA8, 0x5E, 0xA8, 0x76, 0x8C, 0xFB, 0x0D, 0x77, 0x50,
  0x30, 0xDF, 0x90, 0xA0, 0x37, 0x03, 0x0D, 0xFA, 0x09, 0x77, 0x30, 0x5F, 0x90, 0xB0, 0x27, 0x30,
  0x10, 0xEF, 0xA0, 0x17, 0x71, 0x08, 0xF9, 0x07, 0x76, 0x06, 0xFA, 0x06, 0x77, 0x09, 0xF0, 0xE0,
  0x47, 0x71, 0x0D, 0xF9, 0x08, 0x76, 0x09, 0xF0, 0xE0, 0x37, 0x72, 0x08, 0xF9, 0x09, 0x75, 0x08,
  0xF9, 0x03, 0x77, 0x30, 0x4F, 0x90, 0x87, 0x40, 0x5F, 0x90, 0x57, 0x74, 0x01, 0xF9, 0x05, 0x73,
  0x03, 0xF9, 0x08, 0x77, 0x60, 0xEE, 0x0E, 0x01, 0x72, 0x01, 0x0D, 0xF0, 0xC7, 0x77, 0x0C, 0xE0,
  0x67, 0x30, 0x9F, 0x90, 0x37, 0x77, 0x0B, 0xD0, 0x77, 0x30, 0x4F, 0x90, 0x97, 0x77, 0x10, 0xBB,
  0x0C, 0x04, 0x74, 0x0D, 0xF0, 0xE0, 0x17, 0x77, 0x18, 0x27, 0x97, 0x37, 0x50, 0x7F, 0x90, 0x78,
  0x0C, 0x20, 0x01, 0x0E, 0xF0, 0xE8, 0x0C, 0x30, 0x09, 0xF9, 0x07, 0x80, 0xC2, 0x00, 0x1F, 0xA0,
  0x18, 0x0C, 0x20, 0x08, 0xF9, 0x09, 0x80, 0xC3, 0x00, 0xEF, 0x90, 0x38, 0x0C, 0x20, 0x06, 0xF9,
  0x0C, 0x80, 0xC3, 0x00, 0xCF, 0x90, 0x78, 0x0C, 0x20, 0x02, 0xFA, 0x02, 0x80, 0xC2, 0x00, 0x8F,
  0x90, 0xC8, 0x0C, 0x30, 0x0D, 0xF9, 0x07, 0x80, 0xC2, 0x00, 0x2F, 0xA0, 0x38, 0x0C, 0x20, 0x06,
  0xF9, 0x0E, 0x80, 0xC3, 0x00, 0xAF, 0x90, 0xB8, 0x0C, 0x30, 0x0E, 0xF9, 0x07, 0x80, 0xC2, 0x00,
  0x2F, 0xA0, 0x48, 0x0C, 0x20, 0x05, 0xFA, 0x80, 0xC3, 0x00, 0x7F, 0x90, 0xD8, 0x0C, 0x30, 0x0A,
  0xF9, 0x0A, 0x80, 0xC3, 0x00, 0xCF, 0x90, 0x88, 0x0C, 0x30, 0x0E, 0xF9, 0x06, 0x80, 0xC3, 0x0F,
  0xA0, 0x48, 0x0C, 0x20, 0x01, 0xFA, 0x02, 0x80, 0xC2, 0x00, 0x2F, 0xA0, 0x18, 0x0C, 0x20, 0x02,
  0xFA, 0x80, 0xC3, 0x00, 0x3F, 0xA8, 0x0C, 0x30, 0x03, 0xFA, 0x80, 0xC3, 0x00, 0x3F, 0xA8, 0x0C,
  0x30, 0x02, 0xFA, 0x80, 0xC3, 0x00, 0x1F, 0xA0, 0x18, 0x0C, 0x30, 0xFA, 0x02, 0x80, 0xC3, 0x00,
  0xDF, 0x90, 0x58, 0x0C, 0x30, 0x0A, 0xF9, 0x08, 0x80, 0xC3, 0x00, 0x7F, 0x90, 0xB8, 0x0C, 0x30,
  0x03, 0xFA, 0x01, 0x80, 0xC3, 0x00, 0xEF, 0x90, 0x67, 0x77, 0x40, 0xA0, 0x27, 0x50, 0x9F, 0x90,
  0xC7, 0x77, 0x38, 0x18, 0xF7, 0x75, 0x03, 0xFA, 0x06, 0x77, 0x71, 0x06, 0xA0, 0x97, 0x60, 0xBF,
  0x90, 0xE0, 0x17, 0x76, 0x07, 0xB0, 0x97, 0x60, 0x3F, 0xA0, 0xC7, 0x75, 0x09, 0xC0, 0x67, 0x70,
  0x9F, 0xA0, 0xC0, 0x27, 0x71, 0x02, 0x0C, 0xD0, 0x17, 0x71, 0x0D, 0xFA, 0x0E, 0x07, 0x75, 0x02,
  0x08, 0xE0, 0x97, 0x72, 0x02, 0x0E, 0xFB, 0x83, 0xEA, 0x63, 0x12, 0x83, 0x12, 0x47, 0xBF, 0x0E,
  0x01, 0x77, 0x30, 0x30, 0xEF, 0xFF, 0xF0, 0x47, 0x75, 0x03, 0x0D, 0xFF, 0xFD, 0x05, 0x77, 0x70,
  0x10, 0xAF, 0xFF, 0xA0, 0xD0, 0x37, 0x77, 0x30, 0x40, 0xCF, 0xFE, 0x08, 0x77, 0x77, 0x81, 0x4A,
  0xEF, 0xF8, 0x1E, 0x81, 0x77, 0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x73, 0x77,
  0x60,
  // "ĉ" (U+0109)
  0x77, 0x74, 0x80, 0x47, 0x77, 0x77, 0x10, 0x9F, 0x90, 0x37, 0x77, 0x60, 0x4F, 0xA0, 0x77, 0x77,
  0x50, 0x10, 0xEF, 0xA0, 0xB7, 0x77, 0x50, 0xCF, 0xC0, 0x17, 0x77, 0x30, 0x9F, 0xD0, 0x77, 0x77,
  0x20, 0x6E, 0x0B, 0x0D, 0xD0, 0xC7, 0x77, 0x10, 0x3E, 0x81, 0xA0, 0x4E, 0x02, 0x77, 0x60, 0x20,
  0xED, 0x09, 0x30, 0xAD, 0x09, 0x77, 0x60, 0xCD, 0x08, 0x40, 0x10, 0xEC, 0x0E, 0x77, 0x50, 0xBD,
  0x07, 0x60, 0x5D, 0x07, 0x77, 0x30, 0x9C, 0x0E, 0x05, 0x71, 0x09, 0xC0, 0xD7, 0x72, 0x07, 0xC0,
  0xD0, 0x27, 0x30, 0xBC, 0x05, 0x77, 0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x77, 0x0C,
  0xA0, 0xD0, 0x47, 0x70, 0x10, 0xCA, 0x0D, 0x80, 0xB9, 0x50, 0x89, 0x22, 0x69, 0xCD, 0xEF, 0xED,
  0xB8, 0x37, 0x77, 0x30, 0x50, 0xBF, 0xD0, 0xD0, 0x57, 0x76, 0x04, 0x0C, 0xFF, 0xA0, 0x97, 0x74,
  0x09, 0xFF, 0xD0, 0x97, 0x71, 0x02, 0x0C, 0xF8, 0x3B, 0x76, 0x8D, 0xFA, 0x05, 0x76, 0x03, 0x0E,
  0xE0, 0xA0, 0x15, 0x09, 0xF9, 0x0D, 0x75, 0x03, 0x0E, 0xE0, 0x77, 0x10, 0xCF, 0x90, 0x37, 0x30,
  0x20, 0xEE, 0x07, 0x72, 0x03, 0xF9, 0x06, 0x72, 0x01, 0x0D, 0xE0, 0x97, 0x40, 0xDF, 0x07, 0x72,
  0x0A, 0xE0, 0xD7, 0x50, 0x8F, 0x05, 0x71, 0x06, 0xF0, 0x37, 0x50, 0x5F, 0x01, 0x70, 0x10, 0xEE,
  0x0A, 0x76, 0x02, 0xE0, 0x97, 0x10, 0xAF, 0x02, 0x76, 0x01, 0xD0, 0xC7, 0x10, 0x3F, 0x0A, 0x77,
  0x1C, 0x0A, 0x01, 0x71, 0x0B, 0xF0, 0x37, 0x71, 0x82, 0xBA, 0x72, 0x72, 0x04, 0xF0, 0xD7, 0x77,
  0x71, 0x0B, 0xF0, 0x77, 0x77, 0x70, 0x2F, 0x90, 0x17, 0x77, 0x70, 0x8F, 0x0B, 0x77, 0x77, 0x10,
  0xEF, 0x07, 0x77, 0x77, 0x03, 0xF9, 0x02, 0x77, 0x77, 0x08, 0xF0, 0xE7, 0x77, 0x71, 0x0C, 0xF0,
  0xA7, 0x77, 0x70, 0x1F, 0x90, 0x67, 0x77, 0x70, 0x5F, 0x90, 0x37, 0x77, 0x70, 0x8F, 0x97, 0x77,
  0x71, 0x0B, 0xF0, 0xD7, 0x77, 0x71, 0x0D, 0xF0, 0xB7, 0x77, 0x71, 0xF9, 0x09, 0x77, 0x77, 0x01,
  0xF9, 0x08, 0x77, 0x77, 0x02, 0xF9, 0x07, 0x77, 0x77, 0x03, 0xF9, 0x06, 0x77, 0x77, 0x03, 0xF9,
  0x06, 0x77, 0x77, 0x02, 0xF9, 0x07, 0x77, 0x77, 0x02, 0xF9, 0x08, 0x77, 0x77, 0x1F, 0x90, 0xA7,
  0x77, 0x71, 0x0E, 0xF0, 0xD7, 0x77, 0x71, 0x0B, 0xF9, 0x01, 0x77, 0x77, 0x08, 0xF9, 0x06, 0x77,
  0x30, 0xA0, 0x77, 0x20, 0x4F, 0x90, 0xC7, 0x72, 0x81, 0x9F, 0xA7, 0x30, 0xEF, 0x90, 0x57, 0x70,
  0x9A, 0x09, 0x73, 0x08, 0xF9, 0x0E, 0x02, 0x74, 0x01, 0x0B, 0xB0, 0x57, 0x30, 0x1F, 0xA0, 0xD0,
  0x37, 0x20, 0x50, 0xEB, 0x0E, 0x75, 0x07, 0xFB, 0x81, 0xA5, 0x12, 0x82, 0x14, 0x8D, 0xD0, 0x87,
  0x60, 0xCF, 0xFF, 0x90, 0xD7, 0x70, 0x10, 0xDF, 0xFE, 0x0E, 0x02, 0x77, 0x10, 0x10, 0xCF, 0xFC,
  0x0D, 0x03, 0x77, 0x40, 0x8F, 0xFA, 0x0A, 0x01, 0x77, 0x60, 0x20, 0xAF, 0xD0, 0xC0, 0x47, 0x77,
  0x38, 0x31, 0x6A, 0xCE, 0xA8, 0x3E, 0xCA, 0x72, 0x77, 0x20,
  // "Ċ" (U+010A)
  0x77, 0x77, 0x68, 0x44, 0xBE, 0xFD, 0x78, 0x0C, 0x60, 0x07, 0xE0, 0xC8, 0x0C, 0x40, 0x04, 0xF9,
  0x07, 0x80, 0xC3, 0x00, 0xAF, 0x90, 0xA8, 0x0C, 0x30, 0x0E, 0xF9, 0x0B, 0x80, 0xC3, 0x0F, 0xA0,
  0xA8, 0x0C, 0x30, 0x0E, 0xF9, 0x07, 0x80, 0xC3, 0x00, 0xBF, 0x90, 0x18, 0x0C, 0x30, 0x03, 0x0E,
  0xE0, 0x58, 0x0C, 0x50, 0x85, 0x2A, 0xEF, 0xD9, 0x28, 0x0E, 0xD0, 0x08, 0x94, 0x25, 0x8B, 0xCD,
  0xEF, 0xED, 0xCA, 0x74, 0x77, 0x77, 0x48, 0x12, 0x7D, 0xFF, 0x81, 0xEA, 0x37, 0x77, 0x60, 0x40,
  0xBF, 0xFE, 0x09, 0x01, 0x77, 0x72, 0x03, 0x0B, 0xFF, 0xFA, 0x0D, 0x02, 0x77, 0x70, 0x8F, 0xA8,
  0x5E, 0xA8, 0x76, 0x8C, 0xFB, 0x0D, 0x77, 0x50, 0x30, 0xDF, 0x90, 0xA0, 0x37, 0x03, 0x0D, 0xFA,
  0x09, 0x77, 0x30, 0x5F, 0x90, 0xB0, 0x27, 0x30, 0x10, 0xEF, 0xA0, 0x17, 0x71, 0x08, 0xF9, 0x07,
  0x76, 0x06, 0xFA, 0x06, 0x77, 0x09, 0xF0, 0xE0, 0x47, 0x71, 0x0D, 0xF9, 0x08, 0x76, 0x09, 0xF0,
  0xE0, 0x37, 0x72, 0x08, 0xF9, 0x09, 0x75, 0x08, 0xF9, 0x03, 0x77, 0x30, 0x4F, 0x90, 0x87, 0x40,
  0x5F, 0x90, 0x57, 0x74, 0x01, 0xF9, 0x05, 0x73, 0x03, 0xF9, 0x08, 0x77, 0x60, 0xEE, 0x0E, 0x01,
  0x72, 0x01, 0x0D, 0xF0, 0xC7, 0x77, 0x0C, 0xE0, 0x67, 0x30, 0x9F, 0x90, 0x37, 0x77, 0x0B, 0xD0,
  0x77, 0x30, 0x4F, 0x90, 0x97, 0x77, 0x10, 0xBB, 0x0C, 0x04, 0x74, 0x0D, 0xF0, 0xE0, 0x17, 0x77,
  0x18, 0x27, 0x97, 0x37, 0x50, 0x7F, 0x90, 0x78, 0x0C, 0x20, 0x01, 0x0E, 0xF0, 0xE8, 0x0C, 0x30,
  0x09, 0xF9, 0x07, 0x80, 0xC2, 0x00, 0x1F, 0xA0, 0x18, 0x0C, 0x20, 0x08, 0xF9, 0x09, 0x80, 0xC3,
  0x00, 0xEF, 0x90, 0x38, 0x0C, 0x20, 0x06, 0xF9, 0x0C, 0x80, 0xC3, 0x00, 0xCF, 0x90, 0x78, 0x0C,
  0x20, 0x02, 0xFA, 0x02, 0x80, 0xC2, 0x00, 0x8F, 0x90, 0xC8, 0x0C, 0x30, 0x0D, 0xF9, 0x07, 0x80,
  0xC2, 0x00, 0x2F, 0xA0, 0x38, 0x0C, 0x20, 0x06, 0xF9, 0x0E, 0x80, 0xC3, 0x00, 0xAF, 0x90, 0xB8,
  0x0C, 0x30, 0x0E, 0xF9, 0x07, 0x80, 0xC2, 0x00, 0x2F, 0xA0, 0x48, 0x0C, 0x20, 0x05, 0xFA, 0x80,
  0xC3, 0x00, 0x7F, 0x90, 0xD8, 0x0C, 0x30, 0x0A, 0xF9, 0x0A, 0x80, 0xC3, 0x00, 0xCF, 0x90, 0x88,
  0x0C, 0x30, 0x0E, 0xF9, 0x06, 0x80, 0xC3, 0x0F, 0xA0, 0x48, 0x0C, 0x20, 0x01, 0xFA, 0x02, 0x80,
  0xC2, 0x00, 0x2F, 0xA0, 0x18, 0x0C, 0x20, 0x02, 0xFA, 0x80, 0xC3, 0x00, 0x3F, 0xA8, 0x0C, 0x30,
  0x03, 0xFA, 0x80, 0xC3, 0x00, 0x3F, 0xA8, 0x0C, 0x30, 0x02, 0xFA, 0x80, 0xC3, 0x00, 0x1F, 0xA0,
  0x18, 0x0C, 0x30, 0xFA, 0x02, 0x80, 0xC3, 0x00, 0xDF, 0x90, 0x58, 0x0C, 0x30, 0x0A, 0xF9, 0x08,
  0x80, 0xC3, 0x00, 0x7F, 0x90, 0xB8, 0x0C, 0x30, 0x03, 0xFA, 0x01, 0x80, 0xC3, 0x00, 0xEF, 0x90,
  0x67, 0x77, 0x40, 0xA0, 0x27, 0x50, 0x9F, 0x90, 0xC7, 0x77, 0x38, 0x18, 0xF7, 0x75, 0x03, 0xFA,
  0x06, 0x77, 0x71, 0x06, 0xA0, 0x97, 0x60, 0xBF, 0x90, 0xE0, 0x17, 0x76, 0x07, 0xB0, 0x97, 0x60,
  0x3F, 0xA0, 0xC7, 0x75, 0x09, 0xC0, 0x67, 0x70, 0x9F, 0xA0, 0xC0, 0x27, 0x71, 0x02, 0x0C, 0xD0,
  0x17, 0x71, 0x0D, 0xFA, 0x0E, 0x07, 0x75, 0x02, 0x08, 0xE0, 0x97, 0x72, 0x02, 0x0E, 0xFB, 0x83,
  0xEA, 0x63, 0x12, 0x83, 0x12, 0x47, 0xBF, 0x0E, 0x01, 0x77, 0x30, 0x30, 0xEF, 0xFF, 0xF0, 0x47,
  0x75, 0x03, 0x0D, 0xFF, 0xFD, 0x05, 0x77, 0x70, 0x10, 0xAF, 0xFF, 0xA0, 0xD0, 0x37, 0x77, 0x30,
  0x40, 0xCF, 0xFE, 0x08, 0x77, 0x77, 0x81, 0x4A, 0xEF, 0xF8, 0x1E, 0x81, 0x77, 0x77, 0x48, 0x44,
  0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xC9, 0x73, 0x77, 0x60,
  // "ċ" (U+010B)
  0x77, 0x74, 0x84, 0x4B, 0xEF, 0xD7, 0x77, 0x77, 0x20, 0x7E, 0x0C, 0x77, 0x77, 0x04, 0xF9, 0x07,
  0x77, 0x76, 0x0A, 0xF9, 0x0A, 0x77, 0x76, 0x0E, 0xF9, 0x0B, 0x77, 0x76, 0xFA, 0x0A, 0x77, 0x76,
  0x0E, 0xF9, 0x07, 0x77, 0x76, 0x0B, 0xF9, 0x01, 0x77, 0x76, 0x03, 0x0E, 0xE0, 0x57, 0x77, 0x71,
  0x85, 0x2A, 0xEF, 0xD9, 0x28, 0x0D, 0xC2, 0x08, 0x92, 0x26, 0x9C, 0xDE, 0xFE, 0xDB, 0x83, 0x77,
  0x72, 0x05, 0x0B, 0xFD, 0x0D, 0x05, 0x77, 0x50, 0x40, 0xCF, 0xFA, 0x09, 0x77, 0x30, 0x9F, 0xFD,
  0x09, 0x77, 0x02, 0x0C, 0xF8, 0x3B, 0x76, 0x8D, 0xFA, 0x05, 0x75, 0x03, 0x0E, 0xE0, 0xA0, 0x15,
  0x09, 0xF9, 0x0D, 0x74, 0x03, 0x0E, 0xE0, 0x77, 0x10, 0xCF, 0x90, 0x37, 0x20, 0x20, 0xEE, 0x07,
  0x72, 0x03, 0xF9, 0x06, 0x71, 0x01, 0x0D, 0xE0, 0x97, 0x40, 0xDF, 0x07, 0x71, 0x0A, 0xE0, 0xD7,
  0x50, 0x8F, 0x05, 0x70, 0x6F, 0x03, 0x75, 0x05, 0xF0, 0x16, 0x01, 0x0E, 0xE0, 0xA7, 0x60, 0x2E,
  0x09, 0x70, 0xAF, 0x02, 0x76, 0x01, 0xD0, 0xC7, 0x03, 0xF0, 0xA7, 0x71, 0xC0, 0xA0, 0x17, 0x0B,
  0xF0, 0x37, 0x71, 0x82, 0xBA, 0x72, 0x71, 0x04, 0xF0, 0xD7, 0x77, 0x70, 0xBF, 0x07, 0x77, 0x76,
  0x02, 0xF9, 0x01, 0x77, 0x76, 0x08, 0xF0, 0xB7, 0x77, 0x70, 0xEF, 0x07, 0x77, 0x76, 0x03, 0xF9,
  0x02, 0x77, 0x76, 0x08, 0xF0, 0xE7, 0x77, 0x70, 0xCF, 0x0A, 0x77, 0x76, 0x01, 0xF9, 0x06, 0x77,
  0x76, 0x05, 0xF9, 0x03, 0x77, 0x76, 0x08, 0xF9, 0x77, 0x77, 0x0B, 0xF0, 0xD7, 0x77, 0x70, 0xDF,
  0x0B, 0x77, 0x77, 0xF9, 0x09, 0x77, 0x76, 0x01, 0xF9, 0x08, 0x77, 0x76, 0x02, 0xF9, 0x07, 0x77,
  0x76, 0x03, 0xF9, 0x06, 0x77, 0x76, 0x03, 0xF9, 0x06, 0x77, 0x76, 0x02, 0xF9, 0x07, 0x77, 0x76,
  0x02, 0xF9, 0x08, 0x77, 0x77, 0xF9, 0x0A, 0x77, 0x77, 0x0E, 0xF0, 0xD7, 0x77, 0x70, 0xBF, 0x90,
  0x17, 0x77, 0x60, 0x8F, 0x90, 0x67, 0x73, 0x0A, 0x07, 0x71, 0x04, 0xF9, 0x0C, 0x77, 0x28, 0x19,
  0xFA, 0x72, 0x0E, 0xF9, 0x05, 0x77, 0x09, 0xA0, 0x97, 0x20, 0x8F, 0x90, 0xE0, 0x27, 0x40, 0x10,
  0xBB, 0x05, 0x72, 0x01, 0xFA, 0x0D, 0x03, 0x72, 0x05, 0x0E, 0xB0, 0xE7, 0x40, 0x7F, 0xB8, 0x1A,
  0x51, 0x28, 0x21, 0x48, 0xDD, 0x08, 0x75, 0x0C, 0xFF, 0xF9, 0x0D, 0x76, 0x01, 0x0D, 0xFF, 0xE0,
  0xE0, 0x27, 0x70, 0x10, 0xCF, 0xFC, 0x0D, 0x03, 0x77, 0x30, 0x8F, 0xFA, 0x0A, 0x01, 0x77, 0x50,
  0x20, 0xAF, 0xD0, 0xC0, 0x47, 0x77, 0x28, 0x31, 0x6A, 0xCE, 0xA8, 0x3E, 0xCA, 0x72, 0x77, 0x10,
  // "Č" (U+010C)
  0x77, 0x77, 0x0F, 0x70, 0x37, 0x71, 0x83, 0x27, 0x77, 0x57, 0x77, 0x7B, 0x0E, 0x03, 0x76, 0x06,
  0x0E, 0xB0, 0x77, 0x77, 0x70, 0xBB, 0x0D, 0x01, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x71, 0x04, 0xC0,
  0xB7, 0x20, 0x10, 0xCC, 0x0C, 0x77, 0x77, 0x30, 0xCC, 0x07, 0x70, 0x30, 0xEC, 0x0D, 0x01, 0x77,
  0x77, 0x30, 0x6D, 0x03, 0x50, 0x40, 0xEC, 0x0E, 0x02, 0x77, 0x77, 0x50, 0xEC, 0x0C, 0x40, 0x6E,
  0x04, 0x77, 0x77, 0x60, 0x8D, 0x07, 0x20, 0x7E, 0x06, 0x77, 0x77, 0x70, 0x3D, 0x81, 0xE1, 0x7E,
  0x09, 0x80, 0xC1, 0x00, 0xCD, 0x0D, 0xE0, 0xC8, 0x0C, 0x20, 0x07, 0xFC, 0x0E, 0x01, 0x80, 0xC2,
  0x00, 0x1F, 0xC0, 0x38, 0x0C, 0x40, 0x0D, 0xFA, 0x07, 0x80, 0xC5, 0x00, 0x9F, 0x90, 0xC8, 0x0C,
  0x60, 0x05, 0xF0, 0xE0, 0x28, 0x0B, 0xE1, 0x08, 0x94, 0x25, 0x8B, 0xCD, 0xEF, 0xED, 0xCA, 0x74,
  0x77, 0x77, 0x78, 0x12, 0x7D, 0xFF, 0x81, 0xEA, 0x37, 0x77, 0x72, 0x04, 0x0B, 0xFF, 0xE0, 0x90,
  0x17, 0x77, 0x50, 0x30, 0xBF, 0xFF, 0xA0, 0xD0, 0x27, 0x77, 0x30, 0x8F, 0xA8, 0x5E, 0xA8, 0x76,
  0x8C, 0xFB, 0x0D, 0x77, 0x71, 0x03, 0x0D, 0xF9, 0x0A, 0x03, 0x70, 0x30, 0xDF, 0xA0, 0x97, 0x76,
  0x05, 0xF9, 0x0B, 0x02, 0x73, 0x01, 0x0E, 0xFA, 0x01, 0x77, 0x40, 0x8F, 0x90, 0x77, 0x60, 0x6F,
  0xA0, 0x67, 0x73, 0x09, 0xF0, 0xE0, 0x47, 0x71, 0x0D, 0xF9, 0x08, 0x77, 0x20, 0x9F, 0x0E, 0x03,
  0x77, 0x20, 0x8F, 0x90, 0x97, 0x71, 0x08, 0xF9, 0x03, 0x77, 0x30, 0x4F, 0x90, 0x87, 0x70, 0x5F,
  0x90, 0x57, 0x74, 0x01, 0xF9, 0x05, 0x76, 0x03, 0xF9, 0x08, 0x77, 0x60, 0xEE, 0x0E, 0x01, 0x75,
  0x01, 0x0D, 0xF0, 0xC7, 0x77, 0x0C, 0xE0, 0x67, 0x60, 0x9F, 0x90, 0x37, 0x77, 0x0B, 0xD0, 0x77,
  0x60, 0x4F, 0x90, 0x97, 0x77, 0x10, 0xBB, 0x0C, 0x04, 0x77, 0x0D, 0xF0, 0xE0, 0x17, 0x77, 0x18,
  0x27, 0x97, 0x37, 0x71, 0x07, 0xF9, 0x07, 0x80, 0xC5, 0x00, 0x10, 0xEF, 0x0E, 0x80, 0xC6, 0x00,
  0x9F, 0x90, 0x78, 0x0C, 0x50, 0x01, 0xFA, 0x01, 0x80, 0xC5, 0x00, 0x8F, 0x90, 0x98, 0x0C, 0x60,
  0x0E, 0xF9, 0x03, 0x80, 0xC5, 0x00, 0x6F, 0x90, 0xC8, 0x0C, 0x60, 0x0C, 0xF9, 0x07, 0x80, 0xC5,
  0x00, 0x2F, 0xA0, 0x28, 0x0C, 0x50, 0x08, 0xF9, 0x0C, 0x80, 0xC6, 0x00, 0xDF, 0x90, 0x78, 0x0C,
  0x50, 0x02, 0xFA, 0x03, 0x80, 0xC5, 0x00, 0x6F, 0x90, 0xE8, 0x0C, 0x60, 0x0A, 0xF9, 0x0B, 0x80,
  0xC6, 0x00, 0xEF, 0x90, 0x78, 0x0C, 0x50, 0x02, 0xFA, 0x04, 0x80, 0xC5, 0x00, 0x5F, 0xA8, 0x0C,
  0x60, 0x07, 0xF9, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x90, 0xA8, 0x0C, 0x60, 0x0C, 0xF9, 0x08, 0x80,
  0xC6, 0x00, 0xEF, 0x90, 0x68, 0x0C, 0x60, 0xFA, 0x04, 0x80, 0xC5, 0x00, 0x1F, 0xA0, 0x28, 0x0C,
  0x50, 0x02, 0xFA, 0x01, 0x80, 0xC5, 0x00, 0x2F, 0xA8, 0x0C, 0x60, 0x03, 0xFA, 0x80, 0xC6, 0x00,
  0x3F, 0xA8, 0x0C, 0x60, 0x03, 0xFA, 0x80, 0xC6, 0x00, 0x2F, 0xA8, 0x0C, 0x60, 0x01, 0xFA, 0x01,
  0x80, 0xC6, 0x0F, 0xA0, 0x28, 0x0C, 0x60, 0x0D, 0xF9, 0x05, 0x80, 0xC6, 0x00, 0xAF, 0x90, 0x88,
  0x0C, 0x60, 0x07, 0xF9, 0x0B, 0x80, 0xC6, 0x00, 0x3F, 0xA0, 0x18, 0x0C, 0x60, 0x0E, 0xF9, 0x06,
  0x77, 0x74, 0x0A, 0x02, 0x77, 0x10, 0x9F, 0x90, 0xC7, 0x77, 0x38, 0x18, 0xF7, 0x77, 0x10, 0x3F,
  0xA0, 0x67, 0x77, 0x10, 0x6A, 0x09, 0x77, 0x20, 0xBF, 0x90, 0xE0, 0x17, 0x76, 0x07, 0xB0, 0x97,
  0x72, 0x03, 0xFA, 0x0C, 0x77, 0x50, 0x9C, 0x06, 0x77, 0x30, 0x9F, 0xA0, 0xC0, 0x27, 0x71, 0x02,
  0x0C, 0xD0, 0x17, 0x74, 0x0D, 0xFA, 0x0E, 0x07, 0x75, 0x02, 0x08, 0xE0, 0x97, 0x75, 0x02, 0x0E,
  0xFB, 0x83, 0xEA, 0x63, 0x12, 0x83, 0x12, 0x47, 0xBF, 0x0E, 0x01, 0x77, 0x60, 0x30, 0xEF, 0xFF,
  0xF0, 0x47, 0x77, 0x10, 0x30, 0xDF, 0xFF, 0xD0, 0x57, 0x77, 0x30, 0x10, 0xAF, 0xFF, 0xA0, 0xD0,
  0x37, 0x77, 0x60, 0x40, 0xCF, 0xFE, 0x08, 0x77, 0x77, 0x38, 0x14, 0xAE, 0xFF, 0x81, 0xE8, 0x17,
  0x77, 0x77, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDC, 0x97, 0x37, 0x77, 0x20,
  // "č" (U+010D)
  0x77, 0x50, 0xF7, 0x03, 0x77, 0x18, 0x32, 0x77, 0x75, 0x77, 0x5B, 0x0E, 0x03, 0x76, 0x06, 0x0E,
  0xB0, 0x77, 0x75, 0x0B, 0xB0, 0xD0, 0x17, 0x40, 0xAC, 0x0A, 0x77, 0x60, 0x4C, 0x0B, 0x72, 0x01,
  0x0C, 0xC0, 0xC7, 0x77, 0x10, 0xCC, 0x07, 0x70, 0x30, 0xEC, 0x0D, 0x01, 0x77, 0x71, 0x06, 0xD0,
  0x35, 0x04, 0x0E, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0xEC, 0x0C, 0x40, 0x6E, 0x04, 0x77, 0x74, 0x08,
  0xD0, 0x72, 0x07, 0xE0, 0x67, 0x77, 0x50, 0x3D, 0x81, 0xE1, 0x7E, 0x09, 0x77, 0x77, 0x0C, 0xD0,
  0xDE, 0x0C, 0x77, 0x77, 0x10, 0x7F, 0xC0, 0xE0, 0x17, 0x77, 0x71, 0x01, 0xFC, 0x03, 0x77, 0x77,
  0x30, 0xDF, 0xA0, 0x77, 0x77, 0x74, 0x09, 0xF9, 0x0C, 0x77, 0x77, 0x50, 0x5F, 0x0E, 0x02, 0x80,
  0xBE, 0x00, 0x89, 0x22, 0x69, 0xCD, 0xEF, 0xED, 0xB8, 0x37, 0x77, 0x71, 0x05, 0x0B, 0xFD, 0x0D,
  0x05, 0x77, 0x74, 0x04, 0x0C, 0xFF, 0xA0, 0x97, 0x77, 0x20, 0x9F, 0xFD, 0x09, 0x77, 0x60, 0x20,
  0xCF, 0x83, 0xB7, 0x68, 0xDF, 0xA0, 0x57, 0x74, 0x03, 0x0E, 0xE0, 0xA0, 0x15, 0x09, 0xF9, 0x0D,
  0x77, 0x30, 0x30, 0xEE, 0x07, 0x71, 0x0C, 0xF9, 0x03, 0x77, 0x10, 0x20, 0xEE, 0x07, 0x72, 0x03,
  0xF9, 0x06, 0x77, 0x01, 0x0D, 0xE0, 0x97, 0x40, 0xDF, 0x07, 0x77, 0x0A, 0xE0, 0xD7, 0x50, 0x8F,
  0x05, 0x76, 0x06, 0xF0, 0x37, 0x50, 0x5F, 0x01, 0x75, 0x01, 0x0E, 0xE0, 0xA7, 0x60, 0x2E, 0x09,
  0x76, 0x0A, 0xF0, 0x27, 0x60, 0x1D, 0x0C, 0x76, 0x03, 0xF0, 0xA7, 0x71, 0xC0, 0xA0, 0x17, 0x60,
  0xBF, 0x03, 0x77, 0x18, 0x2B, 0xA7, 0x27, 0x70, 0x4F, 0x0D, 0x77, 0x77, 0x60, 0xBF, 0x07, 0x77,
  0x77, 0x50, 0x2F, 0x90, 0x17, 0x77, 0x75, 0x08, 0xF0, 0xB7, 0x77, 0x76, 0x0E, 0xF0, 0x77, 0x77,
  0x75, 0x03, 0xF9, 0x02, 0x77, 0x77, 0x50, 0x8F, 0x0E, 0x77, 0x77, 0x60, 0xCF, 0x0A, 0x77, 0x77,
  0x50, 0x1F, 0x90, 0x67, 0x77, 0x75, 0x05, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x8F, 0x97, 0x77, 0x76,
  0x0B, 0xF0, 0xD7, 0x77, 0x76, 0x0D, 0xF0, 0xB7, 0x77, 0x76, 0xF9, 0x09, 0x77, 0x77, 0x50, 0x1F,
  0x90, 0x87, 0x77, 0x75, 0x02, 0xF9, 0x07, 0x77, 0x77, 0x50, 0x3F, 0x90, 0x67, 0x77, 0x75, 0x03,
  0xF9, 0x06, 0x77, 0x77, 0x50, 0x2F, 0x90, 0x77, 0x77, 0x75, 0x02, 0xF9, 0x08, 0x77, 0x77, 0x6F,
  0x90, 0xA7, 0x77, 0x76, 0x0E, 0xF0, 0xD7, 0x77, 0x76, 0x0B, 0xF9, 0x01, 0x77, 0x77, 0x50, 0x8F,
  0x90, 0x67, 0x73, 0x0A, 0x07, 0x77, 0x04, 0xF9, 0x0C, 0x77, 0x28, 0x19, 0xFA, 0x77, 0x10, 0xEF,
  0x90, 0x57, 0x70, 0x9A, 0x09, 0x77, 0x10, 0x8F, 0x90, 0xE0, 0x27, 0x40, 0x10, 0xBB, 0x05, 0x77,
  0x10, 0x1F, 0xA0, 0xD0, 0x37, 0x20, 0x50, 0xEB, 0x0E, 0x77, 0x30, 0x7F, 0xB8, 0x1A, 0x51, 0x28,
  0x21, 0x48, 0xDD, 0x08, 0x77, 0x40, 0xCF, 0xFF, 0x90, 0xD7, 0x75, 0x01, 0x0D, 0xFF, 0xE0, 0xE0,
  0x27, 0x76, 0x01, 0x0C, 0xFF, 0xC0, 0xD0, 0x37, 0x77, 0x20, 0x8F, 0xFA, 0x0A, 0x01, 0x77, 0x74,
  0x02, 0x0A, 0xFD, 0x0C, 0x04, 0x77, 0x77, 0x18, 0x31, 0x6A, 0xCE, 0xA8, 0x3E, 0xCA, 0x72, 0x77,
  0x70,
  // "Ď" (U+010E)
  0x77, 0x77, 0x10, 0xF7, 0x03, 0x77, 0x18, 0x32, 0x77, 0x75, 0x77, 0x77, 0x6B, 0x0E, 0x03, 0x76,
  0x06, 0x0E, 0xB0, 0x77, 0x77, 0x76, 0x0B, 0xB0, 0xD0, 0x17, 0x40, 0xAC, 0x0A, 0x77, 0x77, 0x70,
  0x4C, 0x0B, 0x72, 0x01, 0x0C, 0xC0, 0xC8, 0x0C, 0x10, 0x0C, 0xC0, 0x77, 0x03, 0x0E, 0xC0, 0xD0,
  0x18, 0x0C, 0x10, 0x06, 0xD0, 0x35, 0x04, 0x0E, 0xC0, 0xE0, 0x28, 0x0C, 0x30, 0x0E, 0xC0, 0xC4,
  0x06, 0xE0, 0x48, 0x0C, 0x40, 0x08, 0xD0, 0x72, 0x07, 0xE0, 0x68, 0x0C, 0x50, 0x03, 0xD8, 0x1E,
  0x17, 0xE0, 0x98, 0x0C, 0x70, 0x0C, 0xD0, 0xDE, 0x0C, 0x80, 0xD0, 0x00, 0x7F, 0xC0, 0xE0, 0x18,
  0x0D, 0x00, 0x01, 0xFC, 0x03, 0x80, 0xD2, 0x00, 0xDF, 0xA0, 0x78, 0x0D, 0x30, 0x09, 0xF9, 0x0C,
  0x80, 0xD4, 0x00, 0x5F, 0x0E, 0x02, 0x80, 0xCF, 0x20, 0x02, 0xFF, 0xFA, 0x85, 0xEE, 0xCA, 0x84,
  0x17, 0x77, 0x60, 0x6F, 0xFF, 0xFA, 0x0B, 0x06, 0x77, 0x74, 0x0A, 0xFF, 0xFF, 0xC0, 0xE0, 0x77,
  0x77, 0x28, 0x29, 0xBC, 0xEF, 0xFF, 0xFB, 0x0D, 0x04, 0x77, 0x74, 0x02, 0x09, 0xFA, 0x0E, 0x80,
  0x26, 0x82, 0x78, 0xAE, 0xFC, 0x07, 0x77, 0x75, 0x0B, 0xF9, 0x0A, 0x73, 0x03, 0x09, 0xFB, 0x08,
  0x77, 0x74, 0x06, 0xF9, 0x07, 0x75, 0x02, 0x0B, 0xFA, 0x08, 0x77, 0x73, 0x06, 0xF9, 0x03, 0x77,
  0x08, 0xFA, 0x05, 0x77, 0x72, 0x08, 0xF9, 0x77, 0x20, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x10, 0xBF,
  0x0C, 0x77, 0x30, 0xAF, 0x90, 0xA7, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x30, 0x10, 0xEF, 0x90, 0x27,
  0x76, 0x03, 0xF9, 0x06, 0x77, 0x40, 0x8F, 0x90, 0x97, 0x76, 0x06, 0xF9, 0x02, 0x77, 0x40, 0x1F,
  0x90, 0xE7, 0x76, 0x09, 0xF0, 0xE7, 0x76, 0x0B, 0xF9, 0x05, 0x77, 0x50, 0xCF, 0x0B, 0x77, 0x60,
  0x6F, 0x90, 0x97, 0x75, 0xF9, 0x08, 0x77, 0x60, 0x3F, 0x90, 0xE7, 0x74, 0x03, 0xF9, 0x05, 0x77,
  0x7F, 0xA0, 0x17, 0x73, 0x07, 0xF9, 0x01, 0x77, 0x70, 0xDF, 0x90, 0x47, 0x73, 0x0A, 0xF0, 0xD7,
  0x77, 0x10, 0xBF, 0x90, 0x67, 0x73, 0x0D, 0xF0, 0xA7, 0x77, 0x10, 0xAF, 0x90, 0x87, 0x72, 0x01,
  0xF9, 0x07, 0x77, 0x71, 0x09, 0xF9, 0x09, 0x77, 0x20, 0x4F, 0x90, 0x37, 0x77, 0x10, 0x9F, 0x90,
  0xA7, 0x72, 0x07, 0xF9, 0x77, 0x72, 0x08, 0xF9, 0x0A, 0x77, 0x20, 0xBF, 0x0C, 0x77, 0x72, 0x09,
  0xF9, 0x0A, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x72, 0x0A, 0xF9, 0x0A, 0x77, 0x10, 0x2F, 0x90, 0x67,
  0x77, 0x20, 0xAF, 0x90, 0x97, 0x71, 0x05, 0xF9, 0x02, 0x77, 0x72, 0x0B, 0xF9, 0x09, 0x77, 0x10,
  0x8F, 0x0E, 0x77, 0x73, 0x0B, 0xF9, 0x08, 0x77, 0x10, 0xBF, 0x0B, 0x77, 0x73, 0x0D, 0xF9, 0x06,
  0x77, 0x10, 0xEF, 0x08, 0x77, 0x73, 0xFA, 0x05, 0x77, 0x02, 0xF9, 0x05, 0x77, 0x72, 0x01, 0xFA,
  0x03, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x72, 0x03, 0xFA, 0x01, 0x77, 0x09, 0xF0, 0xE7, 0x77, 0x30,
  0x5F, 0x90, 0xE7, 0x71, 0x0C, 0xF0, 0xA7, 0x77, 0x30, 0x8F, 0x90, 0xB7, 0x71, 0xF9, 0x07, 0x77,
  0x73, 0x0B, 0xF9, 0x08, 0x77, 0x03, 0xF9, 0x04, 0x77, 0x73, 0x0E, 0xF9, 0x05, 0x77, 0x06, 0xF9,
  0x77, 0x73, 0x02, 0xFA, 0x01, 0x77, 0x0A, 0xF0, 0xD7, 0x77, 0x30, 0x6F, 0x90, 0xC7, 0x71, 0x0D,
  0xF0, 0x97, 0x77, 0x30, 0xBF, 0x90, 0x87, 0x70, 0x1F, 0x90, 0x67, 0x77, 0x3F, 0xA0, 0x37, 0x70,
  0x4F, 0x90, 0x37, 0x77, 0x20, 0x4F, 0x90, 0xE7, 0x71, 0x07, 0xF9, 0x77, 0x73, 0x09, 0xF9, 0x09,
  0x77, 0x10, 0xAF, 0x0B, 0x77, 0x72, 0x01, 0xFA, 0x03, 0x77, 0x10, 0xEF, 0x08, 0x77, 0x72, 0x07,
  0xF9, 0x0C, 0x77, 0x10, 0x1F, 0x90, 0x57, 0x77, 0x20, 0xDF, 0x90, 0x57, 0x71, 0x05, 0xF9, 0x02,
  0x77, 0x71, 0x05, 0xF9, 0x0D, 0x77, 0x20, 0x8F, 0x0E, 0x77, 0x72, 0x0D, 0xF9, 0x06, 0x77, 0x20,
  0xBF, 0x0A, 0x77, 0x71, 0x06, 0xF9, 0x0D, 0x77, 0x30, 0xEF, 0x07, 0x77, 0x70, 0x10, 0xEF, 0x90,
  0x47, 0x72, 0x02, 0xF9, 0x04, 0x77, 0x70, 0xAF, 0x90, 0xA7, 0x73, 0x05, 0xF9, 0x01, 0x77, 0x60,
  0x6F, 0x90, 0xE0, 0x17, 0x73, 0x09, 0xF0, 0xD7, 0x76, 0x03, 0xFA, 0x05, 0x77, 0x40, 0xCF, 0x09,
  0x77, 0x50, 0x20, 0xDF, 0x90, 0x87, 0x75, 0xF9, 0x06, 0x77, 0x40, 0x20, 0xDF, 0x90, 0xB7, 0x75,
  0x03, 0xF9, 0x03, 0x77, 0x30, 0x20, 0xDF, 0x90, 0xC0, 0x17, 0x75, 0x08, 0xF9, 0x77, 0x30, 0x40,
  0xEF, 0x90, 0xC0, 0x17, 0x76, 0x0D, 0xF0, 0xC7, 0x72, 0x09, 0xFA, 0x0C, 0x01, 0x77, 0x60, 0x6F,
  0x90, 0x87, 0x70, 0x70, 0xEF, 0xA0, 0xA7, 0x77, 0x03, 0x0E, 0xF9, 0x05, 0x74, 0x81, 0x49, 0xEF,
  0xB0, 0x67, 0x76, 0x02, 0x08, 0xFB, 0x08, 0x80, 0x26, 0x82, 0x77, 0x9C, 0xFD, 0x0B, 0x02, 0x77,
  0x38, 0x28, 0x9A, 0xDF, 0xFF, 0xFD, 0x0E, 0x06, 0x77, 0x40, 0x1F, 0xFF, 0xFF, 0x0D, 0x06, 0x77,
  0x60, 0x5F, 0xFF, 0xFC, 0x81, 0xD8, 0x37, 0x77, 0x10, 0x8F, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x52,
  0x77, 0x74,
  // "ď" (U+010F)
  0x77, 0x77, 0x10, 0x2F, 0xF0, 0xB6, 0x0C, 0xE0, 0x87, 0x77, 0x71, 0x05, 0xFF, 0x08, 0x50, 0x2E,
  0x0E, 0x01, 0x77, 0x77, 0x10, 0x8F, 0xF0, 0x55, 0x07, 0xE0, 0x77, 0x77, 0x72, 0x0C, 0xFF, 0x01,
  0x50, 0xCD, 0x0C, 0x77, 0x77, 0x58, 0x12, 0x6C, 0xFA, 0x0E, 0x50, 0x2E, 0x03, 0x80, 0xC0, 0x00,
  0xAF, 0x90, 0xA5, 0x08, 0xD0, 0x98, 0x0C, 0x10, 0x03, 0xF9, 0x07, 0x50, 0xDC, 0x0D, 0x80, 0xC3,
  0x0F, 0x90, 0x44, 0x03, 0xD0, 0x38, 0x0C, 0x20, 0x01, 0xF9, 0x50, 0x9C, 0x08, 0x80, 0xC3, 0x00,
  0x3F, 0x0C, 0x50, 0xEB, 0x0D, 0x80, 0xC4, 0x00, 0x6F, 0x09, 0x40, 0x6C, 0x03, 0x80, 0xC4, 0x00,
  0x9F, 0x06, 0x40, 0xCB, 0x07, 0x80, 0xC5, 0x00, 0xCF, 0x02, 0x30, 0x3B, 0x0B, 0x80, 0xC6, 0x0F,
  0x0E, 0x40, 0x8A, 0x0D, 0x01, 0x80, 0xC5, 0x00, 0x2F, 0x0B, 0x48, 0x23, 0x44, 0x28, 0x0C, 0x60,
  0x05, 0xF0, 0x88, 0x0D, 0x60, 0x08, 0xF0, 0x58, 0x0D, 0x60, 0x0C, 0xF0, 0x18, 0x0D, 0x50, 0x01,
  0xF0, 0xD8, 0x0C, 0x10, 0x89, 0x11, 0x69, 0xCE, 0xFE, 0xDA, 0x61, 0x20, 0x4F, 0x0A, 0x77, 0x77,
  0x70, 0x30, 0xBF, 0xC8, 0x19, 0x16, 0xF0, 0x77, 0x77, 0x75, 0x02, 0x0B, 0xFF, 0x0E, 0x0C, 0xF0,
  0x37, 0x77, 0x74, 0x06, 0x0E, 0xFF, 0xFB, 0x77, 0x77, 0x40, 0x9F, 0x98, 0x4D, 0x97, 0x68, 0xCF,
  0xC0, 0xC7, 0x77, 0x73, 0x0B, 0xF0, 0xD0, 0x56, 0x04, 0x0D, 0xFA, 0x09, 0x77, 0x77, 0x20, 0xBF,
  0x09, 0x72, 0x01, 0x0D, 0xF9, 0x05, 0x77, 0x77, 0x10, 0xAF, 0x08, 0x74, 0x04, 0xF9, 0x02, 0x77,
  0x77, 0x07, 0xF0, 0x97, 0x50, 0x1F, 0x0E, 0x77, 0x77, 0x02, 0xF0, 0xC7, 0x60, 0x4F, 0x0B, 0x77,
  0x77, 0x0C, 0xE0, 0xE0, 0x27, 0x60, 0x7F, 0x08, 0x77, 0x76, 0x08, 0xF0, 0x77, 0x70, 0xBF, 0x04,
  0x77, 0x75, 0x02, 0xF0, 0xD7, 0x71, 0x0E, 0xF0, 0x17, 0x77, 0x50, 0xAF, 0x06, 0x77, 0x02, 0xF0,
  0xD7, 0x77, 0x50, 0x3F, 0x0D, 0x77, 0x10, 0x5F, 0x0A, 0x77, 0x75, 0x0B, 0xF0, 0x67, 0x71, 0x09,
  0xF0, 0x67, 0x77, 0x40, 0x3F, 0x0E, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x74, 0x09, 0xF0, 0x97, 0x72,
  0xF9, 0x77, 0x74, 0x01, 0xF9, 0x03, 0x77, 0x10, 0x3F, 0x0C, 0x77, 0x74, 0x06, 0xF0, 0xD7, 0x72,
  0x07, 0xF0, 0x97, 0x77, 0x40, 0xCF, 0x09, 0x77, 0x20, 0xAF, 0x05, 0x77, 0x73, 0x02, 0xF9, 0x04,
  0x77, 0x20, 0xDF, 0x02, 0x77, 0x73, 0x06, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0x74, 0x0B, 0xF0,
  0xB7, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x40, 0xEF, 0x07, 0x77, 0x20, 0x9F, 0x07, 0x77, 0x73, 0x04,
  0xF9, 0x04, 0x77, 0x20, 0xDF, 0x04, 0x77, 0x73, 0x07, 0xF9, 0x01, 0x77, 0x10, 0x1F, 0x90, 0x17,
  0x77, 0x30, 0xAF, 0x0D, 0x77, 0x20, 0x6F, 0x0D, 0x77, 0x74, 0x0D, 0xF0, 0xB7, 0x72, 0x0C, 0xF0,
  0xA7, 0x77, 0x4F, 0x90, 0x97, 0x71, 0x02, 0xF9, 0x06, 0x77, 0x73, 0x02, 0xF9, 0x06, 0x77, 0x10,
  0x8F, 0x90, 0x37, 0x77, 0x30, 0x3F, 0x90, 0x57, 0x71, 0x0E, 0xF9, 0x01, 0x77, 0x73, 0x05, 0xF9,
  0x04, 0x77, 0x06, 0xF9, 0x0D, 0x77, 0x74, 0x05, 0xF9, 0x03, 0x77, 0x0D, 0xF9, 0x0B, 0x77, 0x74,
  0x06, 0xF9, 0x02, 0x76, 0x06, 0xFA, 0x08, 0x77, 0x74, 0x05, 0xF9, 0x02, 0x75, 0x01, 0x0E, 0xFA,
  0x06, 0x77, 0x74, 0x05, 0xF9, 0x03, 0x75, 0x09, 0xA0, 0xBF, 0x03, 0x77, 0x74, 0x04, 0xF9, 0x04,
  0x74, 0x03, 0xA0, 0xB0, 0x8F, 0x02, 0x77, 0x74, 0x02, 0xF9, 0x06, 0x74, 0x0D, 0xA0, 0x40, 0xBF,
  0x77, 0x76, 0xF9, 0x09, 0x73, 0x0A, 0xA8, 0x1B, 0x0D, 0xF7, 0x77, 0x60, 0xDF, 0x0D, 0x72, 0x07,
  0xB0, 0x31, 0xF9, 0x77, 0x76, 0x09, 0xF9, 0x04, 0x70, 0x7B, 0x81, 0x90, 0x1F, 0x90, 0x17, 0x77,
  0x50, 0x5F, 0x90, 0xD0, 0x15, 0x09, 0xB8, 0x2D, 0x10, 0x1F, 0x90, 0x65, 0x81, 0x6E, 0x37, 0x74,
  0x01, 0x0E, 0xF9, 0x84, 0xD4, 0x01, 0x6D, 0xC0, 0x33, 0xF9, 0x84, 0xE3, 0x02, 0x6D, 0xA0, 0xC7,
  0x75, 0x09, 0xFF, 0xB0, 0x74, 0x0D, 0xFF, 0x90, 0xD0, 0x17, 0x74, 0x02, 0xFF, 0xA0, 0x95, 0x09,
  0xFF, 0x0C, 0x01, 0x77, 0x60, 0x8F, 0xF0, 0x96, 0x04, 0xFE, 0x09, 0x77, 0x72, 0x0B, 0xFD, 0x07,
  0x71, 0x0B, 0xFB, 0x0E, 0x04, 0x77, 0x74, 0x09, 0xFA, 0x0B, 0x03, 0x72, 0x01, 0x0C, 0xF9, 0x08,
  0x01, 0x77, 0x76, 0x87, 0x28, 0xCE, 0xFD, 0xC8, 0x37, 0x68, 0x67, 0xCE, 0xFD, 0xA6, 0x17, 0x77,
  0x20,
  // "Đ" (U+0110)
  0x76, 0x02, 0xFF, 0xFA, 0x85, 0xEE, 0xCA, 0x84, 0x17, 0x77, 0x60, 0x6F, 0xFF, 0xFA, 0x0B, 0x06,
  0x77, 0x74, 0x0A, 0xFF, 0xFF, 0xC0, 0xE0, 0x77, 0x77, 0x28, 0x29, 0xBC, 0xEF, 0xFF, 0xFB, 0x0D,
  0x04, 0x77, 0x74, 0x02, 0x08, 0xFA, 0x0E, 0x80, 0x26, 0x82, 0x78, 0xAE, 0xFC, 0x07, 0x77, 0x75,
  0x0A, 0xF9, 0x0A, 0x73, 0x03, 0x09, 0xFB, 0x08, 0x77, 0x74, 0x06, 0xF9, 0x07, 0x75, 0x02, 0x0B,
  0xFA, 0x08, 0x77, 0x73, 0x06, 0xF9, 0x03, 0x77, 0x08, 0xFA, 0x05, 0x77, 0x72, 0x08, 0xF9, 0x77,
  0x20, 0x8F, 0x90, 0xE0, 0x17, 0x77, 0x10, 0xCF, 0x0C, 0x77, 0x30, 0xAF, 0x90, 0xA7, 0x77, 0x1F,
  0x90, 0x97, 0x73, 0x01, 0x0E, 0xF9, 0x02, 0x77, 0x60, 0x3F, 0x90, 0x57, 0x74, 0x08, 0xF9, 0x09,
  0x77, 0x60, 0x6F, 0x90, 0x27, 0x74, 0x01, 0xF9, 0x0E, 0x77, 0x60, 0xAF, 0x0E, 0x77, 0x60, 0xBF,
  0x90, 0x57, 0x75, 0x0D, 0xF0, 0xB7, 0x76, 0x06, 0xF9, 0x09, 0x77, 0x40, 0x1F, 0x90, 0x77, 0x76,
  0x03, 0xF9, 0x0E, 0x77, 0x40, 0x4F, 0x90, 0x47, 0x77, 0xFA, 0x01, 0x77, 0x30, 0x7F, 0x90, 0x17,
  0x77, 0x0D, 0xF9, 0x04, 0x77, 0x30, 0xBF, 0x0D, 0x77, 0x71, 0x0B, 0xF9, 0x06, 0x77, 0x30, 0xEF,
  0x09, 0x77, 0x71, 0x0A, 0xF9, 0x08, 0x77, 0x20, 0x2F, 0x90, 0x67, 0x77, 0x10, 0x9F, 0x90, 0x97,
  0x72, 0x05, 0xF9, 0x03, 0x77, 0x71, 0x09, 0xF9, 0x0A, 0x77, 0x20, 0x9F, 0x0E, 0x77, 0x72, 0x08,
  0xF9, 0x0A, 0x77, 0x20, 0xCF, 0x0B, 0x77, 0x72, 0x09, 0xF9, 0x0A, 0x77, 0x2F, 0x90, 0x87, 0x77,
  0x20, 0xAF, 0x90, 0xA7, 0x71, 0x03, 0xF9, 0x05, 0x77, 0x72, 0x0A, 0xF9, 0x09, 0x77, 0x10, 0x6F,
  0x90, 0x17, 0x77, 0x20, 0xBF, 0x90, 0x97, 0x71, 0x0A, 0xF0, 0xD7, 0x77, 0x30, 0xBF, 0x90, 0x87,
  0x01, 0xFF, 0xFF, 0x08, 0x74, 0x0D, 0xF9, 0x06, 0x70, 0x4F, 0xFF, 0xF0, 0x57, 0x4F, 0xA0, 0x57,
  0x08, 0xFF, 0xFF, 0x02, 0x73, 0x01, 0xFA, 0x03, 0x70, 0xBF, 0xFF, 0xE0, 0xE7, 0x40, 0x3F, 0xA0,
  0x17, 0x05, 0x80, 0x26, 0x0D, 0xF0, 0xD8, 0x09, 0x06, 0x05, 0x74, 0x05, 0xF9, 0x0E, 0x77, 0x10,
  0xDF, 0x09, 0x77, 0x73, 0x08, 0xF9, 0x0B, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x73, 0x0B, 0xF9, 0x08,
  0x77, 0x04, 0xF9, 0x03, 0x77, 0x73, 0x0E, 0xF9, 0x05, 0x77, 0x08, 0xF9, 0x77, 0x73, 0x02, 0xFA,
  0x01, 0x77, 0x0B, 0xF0, 0xC7, 0x77, 0x30, 0x6F, 0x90, 0xC7, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x30,
  0xBF, 0x90, 0x87, 0x70, 0x2F, 0x90, 0x57, 0x77, 0x3F, 0xA0, 0x37, 0x70, 0x5F, 0x90, 0x27, 0x77,
  0x20, 0x4F, 0x90, 0xE7, 0x71, 0x08, 0xF0, 0xE7, 0x77, 0x30, 0x9F, 0x90, 0x97, 0x71, 0x0B, 0xF0,
  0xB7, 0x77, 0x20, 0x1F, 0xA0, 0x37, 0x71, 0x0E, 0xF0, 0x87, 0x77, 0x20, 0x7F, 0x90, 0xC7, 0x71,
  0x02, 0xF9, 0x04, 0x77, 0x72, 0x0D, 0xF9, 0x05, 0x77, 0x10, 0x5F, 0x90, 0x17, 0x77, 0x10, 0x5F,
  0x90, 0xD7, 0x72, 0x08, 0xF0, 0xD7, 0x77, 0x20, 0xDF, 0x90, 0x67, 0x72, 0x0C, 0xF0, 0xA7, 0x77,
  0x10, 0x6F, 0x90, 0xD7, 0x73, 0xF9, 0x07, 0x77, 0x70, 0x10, 0xEF, 0x90, 0x47, 0x72, 0x03, 0xF9,
  0x04, 0x77, 0x70, 0xAF, 0x90, 0xA7, 0x73, 0x06, 0xF9, 0x77, 0x70, 0x6F, 0x90, 0xE0, 0x17, 0x73,
  0x09, 0xF0, 0xD7, 0x76, 0x03, 0xFA, 0x05, 0x77, 0x40, 0xCF, 0x09, 0x77, 0x50, 0x20, 0xDF, 0x90,
  0x87, 0x75, 0xF9, 0x06, 0x77, 0x40, 0x20, 0xDF, 0x90, 0xB7, 0x75, 0x04, 0xF9, 0x03, 0x77, 0x30,
  0x20, 0xDF, 0x90, 0xC0, 0x17, 0x75, 0x08, 0xF9, 0x77, 0x30, 0x40, 0xEF, 0x90, 0xC0, 0x17, 0x76,
  0x0E, 0xF0, 0xC7, 0x72, 0x09, 0xFA, 0x0C, 0x01, 0x77, 0x60, 0x6F, 0x90, 0x87, 0x70, 0x70, 0xEF,
  0xA0, 0xA7, 0x77, 0x03, 0x0E, 0xF9, 0x05, 0x74, 0x81, 0x49, 0xEF, 0xB0, 0x67, 0x76, 0x02, 0x08,
  0xFB, 0x08, 0x80, 0x26, 0x82, 0x77, 0x9C, 0xFD, 0x0B, 0x02, 0x77, 0x38, 0x28, 0x9A, 0xDF, 0xFF,
  0xFD, 0x0E, 0x06, 0x77, 0x40, 0x1F, 0xFF, 0xFF, 0x0D, 0x06, 0x77, 0x60, 0x5F, 0xFF, 0xFC, 0x81,
  0xD8, 0x37, 0x77, 0x10, 0x8F, 0xFF, 0xC8, 0x5E, 0xDC, 0xA8, 0x52, 0x77, 0x74,
  // "đ" (U+0111)
  0x77, 0x77, 0x10, 0x4F, 0xF0, 0xA7, 0x77, 0x76, 0x07, 0xFF, 0x07, 0x77, 0x77, 0x60, 0xAF, 0xF0,
  0x37, 0x77, 0x76, 0x0D, 0xFF, 0x80, 0xC1, 0x08, 0x11, 0x4B, 0xFA, 0x0C, 0x80, 0xC4, 0x00, 0xAF,
  0x90, 0x98, 0x0C, 0x40, 0x03, 0xF9, 0x05, 0x80, 0xC4, 0x00, 0x1F, 0x90, 0x28, 0x0C, 0x40, 0x02,
  0xF0, 0xE8, 0x0C, 0x50, 0x05, 0xF0, 0xA7, 0x77, 0x70, 0x48, 0x09, 0x06, 0x0A, 0xF0, 0xB8, 0x02,
  0x60, 0x27, 0x77, 0x0C, 0xFF, 0xFE, 0x03, 0x77, 0x7F, 0xFF, 0xF7, 0x77, 0x03, 0xFF, 0xFE, 0x0D,
  0x77, 0x70, 0x6F, 0xFF, 0xE0, 0xA7, 0x77, 0x76, 0x07, 0xF0, 0x68, 0x0C, 0x50, 0x0A, 0xF0, 0x38,
  0x0C, 0x50, 0x0E, 0xF8, 0x0C, 0x50, 0x02, 0xF0, 0xC8, 0x0C, 0x50, 0x05, 0xF0, 0x97, 0x77, 0x72,
  0x84, 0x14, 0x56, 0x53, 0x50, 0x8F, 0x05, 0x77, 0x76, 0x81, 0x5A, 0xEF, 0x0C, 0x06, 0x20, 0xBF,
  0x02, 0x77, 0x74, 0x06, 0x0D, 0xFD, 0x81, 0xD4, 0xDE, 0x0E, 0x77, 0x73, 0x03, 0x0C, 0xFF, 0xFA,
  0x0B, 0x77, 0x72, 0x07, 0xFF, 0xFC, 0x07, 0x77, 0x71, 0x0A, 0xF9, 0x85, 0xB5, 0x20, 0x13, 0x9F,
  0xC0, 0x47, 0x77, 0x0B, 0xF0, 0xD0, 0x37, 0x03, 0x0E, 0xFA, 0x01, 0x77, 0x60, 0xBF, 0x0B, 0x73,
  0x02, 0xF9, 0x0D, 0x77, 0x60, 0x9F, 0x0B, 0x75, 0x09, 0xF0, 0xA7, 0x75, 0x05, 0xF0, 0xC7, 0x60,
  0x9F, 0x06, 0x77, 0x40, 0x10, 0xEE, 0x0E, 0x02, 0x76, 0x0C, 0xF0, 0x37, 0x74, 0x0B, 0xF0, 0x67,
  0x7F, 0x97, 0x74, 0x06, 0xF0, 0xC7, 0x70, 0x4F, 0x0C, 0x77, 0x40, 0xEF, 0x03, 0x77, 0x07, 0xF0,
  0x87, 0x73, 0x07, 0xF0, 0xB7, 0x71, 0x0A, 0xF0, 0x57, 0x72, 0x01, 0x0E, 0xF0, 0x37, 0x71, 0x0E,
  0xF0, 0x27, 0x72, 0x08, 0xF0, 0xC7, 0x71, 0x01, 0xF0, 0xE7, 0x73, 0x0E, 0xF0, 0x57, 0x71, 0x05,
  0xF0, 0xB7, 0x72, 0x05, 0xF0, 0xE7, 0x72, 0x08, 0xF0, 0x77, 0x72, 0x0B, 0xF0, 0x97, 0x72, 0x0B,
  0xF0, 0x47, 0x71, 0x02, 0xF9, 0x04, 0x77, 0x2F, 0x90, 0x17, 0x71, 0x07, 0xF0, 0xE7, 0x72, 0x03,
  0xF0, 0xD7, 0x72, 0x0B, 0xF0, 0xA7, 0x72, 0x06, 0xF0, 0x97, 0x72, 0xF9, 0x06, 0x77, 0x20, 0xAF,
  0x06, 0x77, 0x10, 0x4F, 0x90, 0x37, 0x72, 0x0E, 0xF0, 0x37, 0x71, 0x08, 0xF9, 0x77, 0x20, 0x3F,
  0x97, 0x72, 0x0B, 0xF0, 0xC7, 0x72, 0x08, 0xF0, 0xC7, 0x72, 0x0E, 0xF0, 0x97, 0x72, 0x0D, 0xF0,
  0x87, 0x71, 0x01, 0xF9, 0x07, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x71, 0x03, 0xF9, 0x05, 0x77, 0x10,
  0xAF, 0x90, 0x27, 0x71, 0x05, 0xF9, 0x03, 0x77, 0x01, 0xFA, 0x77, 0x20, 0x6F, 0x90, 0x27, 0x70,
  0x9F, 0x90, 0xD7, 0x72, 0x07, 0xF9, 0x01, 0x76, 0x01, 0xFA, 0x0A, 0x77, 0x20, 0x7F, 0x90, 0x17,
  0x60, 0x9F, 0xA0, 0x77, 0x72, 0x07, 0xF9, 0x01, 0x75, 0x02, 0xFB, 0x05, 0x77, 0x20, 0x6F, 0x90,
  0x17, 0x50, 0xBA, 0x0C, 0xF0, 0x27, 0x72, 0x05, 0xF9, 0x03, 0x74, 0x05, 0xA0, 0xA0, 0x9F, 0x01,
  0x77, 0x20, 0x3F, 0x90, 0x57, 0x30, 0x10, 0xEA, 0x03, 0x0B, 0xF7, 0x73, 0x01, 0xF9, 0x08, 0x73,
  0x0C, 0xA8, 0x1B, 0x0D, 0xE0, 0xE7, 0x74, 0x0E, 0xF0, 0xC7, 0x20, 0xAB, 0x02, 0x1F, 0x0E, 0x77,
  0x40, 0xAF, 0x90, 0x27, 0x09, 0xB8, 0x18, 0x01, 0xF9, 0x77, 0x40, 0x6F, 0x90, 0xC6, 0x0A, 0xB0,
  0xD2, 0x01, 0xF9, 0x04, 0x58, 0x16, 0xE2, 0x72, 0x01, 0xFA, 0x84, 0xB3, 0x01, 0x6E, 0xC0, 0x33,
  0xF9, 0x84, 0xD2, 0x02, 0x7D, 0xA0, 0xB7, 0x30, 0xAF, 0xFB, 0x07, 0x40, 0xDF, 0xF9, 0x0C, 0x73,
  0x03, 0xFF, 0xA0, 0x95, 0x0A, 0xFF, 0x0B, 0x01, 0x74, 0x09, 0xFF, 0x09, 0x60, 0x5F, 0xE0, 0x87,
  0x70, 0xCF, 0xD0, 0x77, 0x10, 0xCF, 0xB0, 0xD0, 0x47, 0x72, 0x0A, 0xFA, 0x0B, 0x03, 0x72, 0x01,
  0x0D, 0xF0, 0xE0, 0x77, 0x75, 0x87, 0x39, 0xCE, 0xFD, 0xC8, 0x37, 0x68, 0x57, 0xCE, 0xED, 0xA6,
  0x77, 0x10,
  // "Ē" (U+0112)
  0x77, 0x75, 0x0C, 0xFF, 0xF0, 0x97, 0x77, 0x73, 0xFF, 0xF9, 0x05, 0x77, 0x77, 0x20, 0x4F, 0xFF,
  0x90, 0x17, 0x77, 0x72, 0x08, 0xFF, 0xF0, 0xD7, 0x77, 0x73, 0x0C, 0xFF, 0xF0, 0x98, 0x0C, 0xB5,
  0x00, 0x38, 0x0C, 0x3F, 0x05, 0x76, 0x07, 0x80, 0xC3, 0xF0, 0x37, 0x60, 0xA8, 0x0C, 0x3F, 0x77,
  0x82, 0x9B, 0xCE, 0xFF, 0xFF, 0xF0, 0xC7, 0x74, 0x04, 0x0C, 0xFA, 0x0E, 0x80, 0x91, 0x60, 0x70,
  0xAF, 0x90, 0x97, 0x75, 0x01, 0x0E, 0xF9, 0x0A, 0x77, 0x10, 0x20, 0xDE, 0x06, 0x77, 0x60, 0xAF,
  0x90, 0x77, 0x72, 0x02, 0xE0, 0x37, 0x76, 0x09, 0xF9, 0x03, 0x77, 0x30, 0x9D, 0x77, 0x70, 0x9F,
  0x97, 0x74, 0x05, 0xC0, 0xD7, 0x77, 0x0B, 0xF0, 0xC7, 0x74, 0x03, 0xC0, 0xA7, 0x77, 0x0E, 0xF0,
  0x97, 0x74, 0x03, 0xC0, 0x77, 0x76, 0x02, 0xF9, 0x05, 0x77, 0x40, 0x5C, 0x04, 0x77, 0x60, 0x5F,
  0x90, 0x27, 0x74, 0x06, 0xC0, 0x17, 0x76, 0x09, 0xF0, 0xE7, 0x75, 0x08, 0xB0, 0xD7, 0x77, 0x0C,
  0xF0, 0xB7, 0x75, 0x0A, 0xB0, 0xA7, 0x77, 0xF9, 0x07, 0x77, 0x58, 0x35, 0x66, 0x63, 0x77, 0x60,
  0x3F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9, 0x01, 0x80, 0xD0, 0x00, 0xAF, 0x0D, 0x80, 0xD1, 0x00,
  0xDF, 0x09, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x68, 0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0, 0x00,
  0x7F, 0x0E, 0x80, 0xD1, 0x00, 0xBF, 0x0B, 0x80, 0xD1, 0x00, 0xEF, 0x08, 0x80, 0xD0, 0x00, 0x2F,
  0x90, 0x58, 0x0D, 0x00, 0x05, 0xF9, 0x01, 0x80, 0xD0, 0x00, 0x8F, 0x0D, 0x80, 0xD1, 0x00, 0xCF,
  0xFF, 0xD0, 0x37, 0x77, 0x5F, 0xFF, 0xE7, 0x77, 0x50, 0x3F, 0xFF, 0xD0, 0xC7, 0x77, 0x50, 0x6F,
  0xFF, 0xD0, 0x97, 0x77, 0x50, 0x9F, 0x0D, 0x80, 0x96, 0x60, 0x27, 0x77, 0x50, 0xDF, 0x09, 0x80,
  0xD1, 0x0F, 0x90, 0x68, 0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x7F, 0x98, 0x0D, 0x10,
  0x0A, 0xF0, 0xC8, 0x0D, 0x10, 0x0D, 0xF0, 0x98, 0x0D, 0x00, 0x01, 0xF9, 0x05, 0x80, 0xD0, 0x00,
  0x5F, 0x90, 0x28, 0x0D, 0x00, 0x08, 0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xF0, 0xB8, 0x0D, 0x10, 0x0E,
  0xF0, 0x88, 0x0D, 0x00, 0x02, 0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D, 0x00, 0x09,
  0xF0, 0xD8, 0x0D, 0x10, 0x0C, 0xF0, 0xA8, 0x0D, 0x10, 0xF9, 0x07, 0x77, 0x78, 0x41, 0xAA, 0xAA,
  0x17, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x70, 0x7B, 0x0D, 0x77, 0x40, 0x7F, 0x97, 0x77, 0x10, 0xCB,
  0x0A, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x70, 0x2C, 0x06, 0x77, 0x40, 0xDF, 0x09, 0x77, 0x70, 0x7C,
  0x02, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x77, 0x0D, 0xB0, 0xE7, 0x74, 0x05, 0xF9, 0x03, 0x77, 0x60,
  0x6C, 0x0A, 0x77, 0x40, 0x9F, 0x97, 0x76, 0x01, 0x0E, 0xC0, 0x77, 0x74, 0x0E, 0xF0, 0xC7, 0x76,
  0x0B, 0xD0, 0x37, 0x73, 0x07, 0xF9, 0x08, 0x77, 0x50, 0xAD, 0x0E, 0x77, 0x30, 0x4F, 0xA0, 0x57,
  0x73, 0x03, 0x0C, 0xE0, 0xB7, 0x71, 0x02, 0x09, 0xFB, 0x08, 0x80, 0x92, 0x68, 0x17, 0x9D, 0xF9,
  0x07, 0x74, 0x82, 0x9A, 0xBE, 0x80, 0xC2, 0xF0, 0x37, 0x30, 0x18, 0x0C, 0x6F, 0x74, 0x04, 0x80,
  0xC5, 0xF0, 0xB7, 0x40, 0x88, 0x0C, 0x5F, 0x08, 0x74,
  // "ē" (U+0113)
  0x77, 0x10, 0xCF, 0xFF, 0x09, 0x77, 0x1F, 0xFF, 0x90, 0x57, 0x70, 0x4F, 0xFF, 0x90, 0x17, 0x70,
  0x8F, 0xFF, 0x0D, 0x77, 0x10, 0xCF, 0xFF, 0x09, 0x80, 0xB9, 0x60, 0x89, 0x11, 0x59, 0xCD, 0xEF,
  0xEC, 0x95, 0x77, 0x74, 0x05, 0x0B, 0xFC, 0x0E, 0x06, 0x77, 0x70, 0x30, 0xCF, 0xF9, 0x0A, 0x77,
  0x50, 0x9F, 0xFC, 0x09, 0x77, 0x20, 0x20, 0xCE, 0x83, 0xEA, 0x76, 0x9F, 0xA0, 0x47, 0x70, 0x20,
  0xEE, 0x0A, 0x01, 0x40, 0x20, 0xEF, 0x0C, 0x76, 0x03, 0x0E, 0xE0, 0x77, 0x06, 0xF9, 0x01, 0x74,
  0x02, 0x0E, 0xE0, 0x87, 0x10, 0x1F, 0x90, 0x57, 0x30, 0x10, 0xDE, 0x0B, 0x73, 0x0D, 0xF0, 0x77,
  0x30, 0xAE, 0x0E, 0x01, 0x73, 0x0C, 0xF0, 0x97, 0x20, 0x6F, 0x06, 0x74, 0x0C, 0xF0, 0x87, 0x10,
  0x10, 0xEE, 0x0D, 0x75, 0x0D, 0xF0, 0x77, 0x10, 0xAF, 0x05, 0x75, 0xF9, 0x05, 0x70, 0x3F, 0x0C,
  0x75, 0x03, 0xF9, 0x01, 0x70, 0xBF, 0x06, 0x75, 0x07, 0xF0, 0xD7, 0x04, 0xF0, 0xE7, 0x60, 0xDF,
  0x07, 0x70, 0xBF, 0x08, 0x75, 0x05, 0xF0, 0xE0, 0x16, 0x02, 0xF9, 0x03, 0x74, 0x01, 0x0D, 0xF0,
  0x77, 0x08, 0xF0, 0xD7, 0x50, 0xBF, 0x0D, 0x71, 0x0E, 0xF0, 0x87, 0x40, 0xAF, 0x0E, 0x02, 0x70,
  0x3F, 0x90, 0x37, 0x20, 0x10, 0xBF, 0x90, 0x57, 0x10, 0x8F, 0x0E, 0x72, 0x05, 0x0D, 0xF9, 0x05,
  0x72, 0x0C, 0xF0, 0xB7, 0x05, 0x0C, 0xFA, 0x05, 0x72, 0x01, 0xF9, 0x08, 0x28, 0x31, 0x46, 0xAE,
  0xFA, 0x0D, 0x02, 0x73, 0x05, 0xFF, 0xFB, 0x08, 0x75, 0x08, 0xFF, 0xF9, 0x0A, 0x02, 0x76, 0x0B,
  0xFF, 0xD8, 0x1E, 0x82, 0x77, 0x10, 0xDF, 0xF9, 0x82, 0xEC, 0x84, 0x77, 0x4F, 0x98, 0x6C, 0x66,
  0x65, 0x43, 0x17, 0x77, 0x01, 0xF9, 0x08, 0x77, 0x77, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x03, 0xF9,
  0x05, 0x77, 0x77, 0x03, 0xF9, 0x05, 0x77, 0x77, 0x02, 0xF9, 0x05, 0x77, 0x77, 0x01, 0xF9, 0x06,
  0x77, 0x77, 0x1F, 0x90, 0x77, 0x77, 0x71, 0x0D, 0xF0, 0xA7, 0x77, 0x71, 0x0B, 0xF0, 0xD7, 0x75,
  0x01, 0x72, 0x07, 0xF9, 0x02, 0x77, 0x30, 0xA0, 0x97, 0x20, 0x3F, 0x90, 0x87, 0x72, 0x81, 0x9F,
  0xB7, 0x30, 0xDF, 0x90, 0x27, 0x70, 0xAA, 0x0A, 0x73, 0x07, 0xF9, 0x0C, 0x75, 0x02, 0x0C, 0xB0,
  0x67, 0x30, 0x10, 0xEF, 0x90, 0xB0, 0x17, 0x20, 0x8C, 0x0E, 0x01, 0x74, 0x06, 0xFA, 0x82, 0xE9,
  0x41, 0x28, 0x22, 0x59, 0xED, 0x07, 0x76, 0x0A, 0xFF, 0xF9, 0x0C, 0x77, 0x10, 0xCF, 0xFE, 0x0D,
  0x02, 0x77, 0x20, 0xBF, 0xFC, 0x0D, 0x02, 0x77, 0x40, 0x8F, 0xFA, 0x09, 0x01, 0x77, 0x60, 0x20,
  0xAF, 0xD0, 0xB0, 0x37, 0x77, 0x38, 0x31, 0x69, 0xCE, 0xA8, 0x3E, 0xCA, 0x62, 0x77, 0x20,
  // "Ĕ" (U+0114)
  0x77, 0x74, 0x05, 0xB0, 0x67, 0x70, 0xCB, 0x77, 0x77, 0x30, 0x4B, 0x09, 0x76, 0x05, 0xB0, 0xB7,
  0x77, 0x73, 0x03, 0xB0, 0xD7, 0x50, 0x10, 0xEB, 0x06, 0x77, 0x77, 0x30, 0x1C, 0x06, 0x74, 0x0C,
  0xB0, 0xE7, 0x77, 0x75, 0x0D, 0xC0, 0x57, 0x10, 0x30, 0xDC, 0x08, 0x77, 0x77, 0x50, 0x9D, 0x81,
  0xB5, 0x12, 0x81, 0x25, 0xAD, 0x0D, 0x77, 0x77, 0x60, 0x4F, 0xFC, 0x05, 0x77, 0x77, 0x70, 0xDF,
  0xFA, 0x08, 0x80, 0xC0, 0x00, 0x4F, 0xF9, 0x0A, 0x80, 0xC2, 0x00, 0x7F, 0xE0, 0x88, 0x0C, 0x40,
  0x05, 0x0E, 0xFA, 0x0C, 0x04, 0x80, 0xC7, 0x08, 0x76, 0xAD, 0xEF, 0xDC, 0x84, 0x80, 0xCC, 0x50,
  0x03, 0x80, 0xC3, 0xF0, 0x57, 0x60, 0x78, 0x0C, 0x3F, 0x03, 0x76, 0x0A, 0x80, 0xC3, 0xF7, 0x78,
  0x29, 0xBC, 0xEF, 0xFF, 0xFF, 0x0C, 0x77, 0x40, 0x40, 0xCF, 0xA0, 0xE8, 0x09, 0x16, 0x07, 0x0A,
  0xF9, 0x09, 0x77, 0x50, 0x10, 0xEF, 0x90, 0xA7, 0x71, 0x02, 0x0D, 0xE0, 0x67, 0x76, 0x0A, 0xF9,
  0x07, 0x77, 0x20, 0x2E, 0x03, 0x77, 0x60, 0x9F, 0x90, 0x37, 0x73, 0x09, 0xD7, 0x77, 0x09, 0xF9,
  0x77, 0x40, 0x5C, 0x0D, 0x77, 0x70, 0xBF, 0x0C, 0x77, 0x40, 0x3C, 0x0A, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x40, 0x3C, 0x07, 0x77, 0x60, 0x2F, 0x90, 0x57, 0x74, 0x05, 0xC0, 0x47, 0x76, 0x05, 0xF9,
  0x02, 0x77, 0x40, 0x6C, 0x01, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x50, 0x8B, 0x0D, 0x77, 0x70, 0xCF,
  0x0B, 0x77, 0x50, 0xAB, 0x0A, 0x77, 0x7F, 0x90, 0x77, 0x75, 0x83, 0x56, 0x66, 0x37, 0x76, 0x03,
  0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D, 0x00, 0x0A, 0xF0, 0xD8, 0x0D, 0x10, 0x0D,
  0xF0, 0x98, 0x0D, 0x00, 0x01, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F, 0x90, 0x38, 0x0D, 0x00, 0x07,
  0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xF0, 0xB8, 0x0D, 0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02, 0xF9,
  0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x18, 0x0D, 0x00, 0x08, 0xF0, 0xD8, 0x0D, 0x10, 0x0C, 0xFF,
  0xFD, 0x03, 0x77, 0x75, 0xFF, 0xFE, 0x77, 0x75, 0x03, 0xFF, 0xFD, 0x0C, 0x77, 0x75, 0x06, 0xFF,
  0xFD, 0x09, 0x77, 0x75, 0x09, 0xF0, 0xD8, 0x09, 0x66, 0x02, 0x77, 0x75, 0x0D, 0xF0, 0x98, 0x0D,
  0x10, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F, 0x90, 0x38, 0x0D, 0x00, 0x07, 0xF9, 0x80, 0xD1, 0x00,
  0xAF, 0x0C, 0x80, 0xD1, 0x00, 0xDF, 0x09, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x58, 0x0D, 0x00, 0x05,
  0xF9, 0x02, 0x80, 0xD0, 0x00, 0x8F, 0x0E, 0x80, 0xD1, 0x00, 0xBF, 0x0B, 0x80, 0xD1, 0x00, 0xEF,
  0x08, 0x80, 0xD0, 0x00, 0x2F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9, 0x01, 0x80, 0xD0, 0x00, 0x9F,
  0x0D, 0x80, 0xD1, 0x00, 0xCF, 0x0A, 0x80, 0xD1, 0x0F, 0x90, 0x77, 0x77, 0x84, 0x1A, 0xAA, 0xA1,
  0x77, 0x30, 0x3F, 0x90, 0x47, 0x77, 0x07, 0xB0, 0xD7, 0x74, 0x07, 0xF9, 0x77, 0x71, 0x0C, 0xB0,
  0xA7, 0x74, 0x0A, 0xF0, 0xD7, 0x77, 0x02, 0xC0, 0x67, 0x74, 0x0D, 0xF0, 0x97, 0x77, 0x07, 0xC0,
  0x27, 0x73, 0x01, 0xF9, 0x06, 0x77, 0x70, 0xDB, 0x0E, 0x77, 0x40, 0x5F, 0x90, 0x37, 0x76, 0x06,
  0xC0, 0xA7, 0x74, 0x09, 0xF9, 0x77, 0x60, 0x10, 0xEC, 0x07, 0x77, 0x40, 0xEF, 0x0C, 0x77, 0x60,
  0xBD, 0x03, 0x77, 0x30, 0x7F, 0x90, 0x87, 0x75, 0x0A, 0xD0, 0xE7, 0x73, 0x04, 0xFA, 0x05, 0x77,
  0x30, 0x30, 0xCE, 0x0B, 0x77, 0x10, 0x20, 0x9F, 0xB0, 0x88, 0x09, 0x26, 0x81, 0x79, 0xDF, 0x90,
  0x77, 0x48, 0x29, 0xAB, 0xE8, 0x0C, 0x2F, 0x03, 0x73, 0x01, 0x80, 0xC6, 0xF7, 0x40, 0x48, 0x0C,
  0x5F, 0x0B, 0x74, 0x08, 0x80, 0xC5, 0xF0, 0x87, 0x40,
  // "ĕ" (U+0115)
  0x77, 0x10, 0x5B, 0x06, 0x77, 0x0C, 0xB7, 0x71, 0x04, 0xB0, 0x97, 0x60, 0x5B, 0x0B, 0x77, 0x10,
  0x3B, 0x0D, 0x75, 0x01, 0x0E, 0xB0, 0x67, 0x71, 0x01, 0xC0, 0x67, 0x40, 0xCB, 0x0E, 0x77, 0x30,
  0xDC, 0x05, 0x71, 0x03, 0x0D, 0xC0, 0x87, 0x73, 0x09, 0xD8, 0x1B, 0x51, 0x28, 0x12, 0x5A, 0xD0,
  0xD7, 0x74, 0x04, 0xFF, 0xC0, 0x57, 0x75, 0x0D, 0xFF, 0xA0, 0x87, 0x76, 0x04, 0xFF, 0x90, 0xA7,
  0x77, 0x10, 0x7F, 0xE0, 0x87, 0x77, 0x30, 0x50, 0xEF, 0xA0, 0xC0, 0x47, 0x77, 0x68, 0x76, 0xAD,
  0xEF, 0xDC, 0x84, 0x80, 0xBA, 0x50, 0x89, 0x11, 0x59, 0xCD, 0xEF, 0xEC, 0x95, 0x77, 0x74, 0x05,
  0x0B, 0xFC, 0x0E, 0x06, 0x77, 0x70, 0x30, 0xCF, 0xF9, 0x0A, 0x77, 0x50, 0x9F, 0xFC, 0x09, 0x77,
  0x20, 0x20, 0xCE, 0x83, 0xEA, 0x76, 0x9F, 0xA0, 0x47, 0x70, 0x20, 0xEE, 0x0A, 0x01, 0x40, 0x20,
  0xEF, 0x0C, 0x76, 0x03, 0x0E, 0xE0, 0x77, 0x06, 0xF9, 0x01, 0x74, 0x02, 0x0E, 0xE0, 0x87, 0x10,
  0x1F, 0x90, 0x57, 0x30, 0x10, 0xDE, 0x0B, 0x73, 0x0D, 0xF0, 0x77, 0x30, 0xAE, 0x0E, 0x01, 0x73,
  0x0C, 0xF0, 0x97, 0x20, 0x6F, 0x06, 0x74, 0x0C, 0xF0, 0x87, 0x10, 0x10, 0xEE, 0x0D, 0x75, 0x0D,
  0xF0, 0x77, 0x10, 0xAF, 0x05, 0x75, 0xF9, 0x05, 0x70, 0x3F, 0x0C, 0x75, 0x03, 0xF9, 0x01, 0x70,
  0xBF, 0x06, 0x75, 0x07, 0xF0, 0xD7, 0x04, 0xF0, 0xE7, 0x60, 0xDF, 0x07, 0x70, 0xBF, 0x08, 0x75,
  0x05, 0xF0, 0xE0, 0x16, 0x02, 0xF9, 0x03, 0x74, 0x01, 0x0D, 0xF0, 0x77, 0x08, 0xF0, 0xD7, 0x50,
  0xBF, 0x0D, 0x71, 0x0E, 0xF0, 0x87, 0x40, 0xAF, 0x0E, 0x02, 0x70, 0x3F, 0x90, 0x37, 0x20, 0x10,
  0xBF, 0x90, 0x57, 0x10, 0x8F, 0x0E, 0x72, 0x05, 0x0D, 0xF9, 0x05, 0x72, 0x0C, 0xF0, 0xB7, 0x05,
  0x0C, 0xFA, 0x05, 0x72, 0x01, 0xF9, 0x08, 0x28, 0x31, 0x46, 0xAE, 0xFA, 0x0D, 0x02, 0x73, 0x05,
  0xFF, 0xFB, 0x08, 0x75, 0x08, 0xFF, 0xF9, 0x0A, 0x02, 0x76, 0x0B, 0xFF, 0xD8, 0x1E, 0x82, 0x77,
  0x10, 0xDF, 0xF9, 0x82, 0xEC, 0x84, 0x77, 0x4F, 0x98, 0x6C, 0x66, 0x65, 0x43, 0x17, 0x77, 0x01,
  0xF9, 0x08, 0x77, 0x77, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x03, 0xF9, 0x05, 0x77, 0x77, 0x03, 0xF9,
  0x05, 0x77, 0x77, 0x02, 0xF9, 0x05, 0x77, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x77, 0x1F, 0x90, 0x77,
  0x77, 0x71, 0x0D, 0xF0, 0xA7, 0x77, 0x71, 0x0B, 0xF0, 0xD7, 0x75, 0x01, 0x72, 0x07, 0xF9, 0x02,
  0x77, 0x30, 0xA0, 0x97, 0x20, 0x3F, 0x90, 0x87, 0x72, 0x81, 0x9F, 0xB7, 0x30, 0xDF, 0x90, 0x27,
  0x70, 0xAA, 0x0A, 0x73, 0x07, 0xF9, 0x0C, 0x75, 0x02, 0x0C, 0xB0, 0x67, 0x30, 0x10, 0xEF, 0x90,
  0xB0, 0x17, 0x20, 0x8C, 0x0E, 0x01, 0x74, 0x06, 0xFA, 0x82, 0xE9, 0x41, 0x28, 0x22, 0x59, 0xED,
  0x07, 0x76, 0x0A, 0xFF, 0xF9, 0x0C, 0x77, 0x10, 0xCF, 0xFE, 0x0D, 0x02, 0x77, 0x20, 0xBF, 0xFC,
  0x0D, 0x02, 0x77, 0x40, 0x8F, 0xFA, 0x09, 0x01, 0x77, 0x60, 0x20, 0xAF, 0xD0, 0xB0, 0x37, 0x77,
  0x38, 0x31, 0x69, 0xCE, 0xA8, 0x3E, 0xCA, 0x62, 0x77, 0x20,
  // "Ė" (U+0116)
  0x77, 0x77, 0x68, 0x44, 0xBE, 0xFD, 0x78, 0x0D, 0x30, 0x07, 0xE0, 0xC8, 0x0D, 0x10, 0x04, 0xF9,
  0x07, 0x80, 0xD0, 0x00, 0xAF, 0x90, 0xA8, 0x0D, 0x00, 0x0E, 0xF9, 0x0B, 0x80, 0xD0, 0x0F, 0xA0,
  0xA8, 0x0D, 0x00, 0x0E, 0xF9, 0x07, 0x80, 0xD0, 0x00, 0xBF, 0x90, 0x18, 0x0D, 0x00, 0x03, 0x0E,
  0xE0, 0x58, 0x0D, 0x20, 0x85, 0x2A, 0xEF, 0xD9, 0x28, 0x0F, 0x87, 0x00, 0x38, 0x0C, 0x3F, 0x05,
  0x76, 0x07, 0x80, 0xC3, 0xF0, 0x37, 0x60, 0xA8, 0x0C, 0x3F, 0x77, 0x82, 0x9B, 0xCE, 0xFF, 0xFF,
  0xF0, 0xC7, 0x74, 0x04, 0x0C, 0xFA, 0x0E, 0x80, 0x91, 0x60, 0x70, 0xAF, 0x90, 0x97, 0x75, 0x01,
  0x0E, 0xF9, 0x0A, 0x77, 0x10, 0x20, 0xDE, 0x06, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x72, 0x02, 0xE0,
  0x37, 0x76, 0x09, 0xF9, 0x03, 0x77, 0x30, 0x9D, 0x77, 0x70, 0x9F, 0x97, 0x74, 0x05, 0xC0, 0xD7,
  0x77, 0x0B, 0xF0, 0xC7, 0x74, 0x03, 0xC0, 0xA7, 0x77, 0x0E, 0xF0, 0x97, 0x74, 0x03, 0xC0, 0x77,
  0x76, 0x02, 0xF9, 0x05, 0x77, 0x40, 0x5C, 0x04, 0x77, 0x60, 0x5F, 0x90, 0x27, 0x74, 0x06, 0xC0,
  0x17, 0x76, 0x09, 0xF0, 0xE7, 0x75, 0x08, 0xB0, 0xD7, 0x77, 0x0C, 0xF0, 0xB7, 0x75, 0x0A, 0xB0,
  0xA7, 0x77, 0xF9, 0x07, 0x77, 0x58, 0x35, 0x66, 0x63, 0x77, 0x60, 0x3F, 0x90, 0x48, 0x0D, 0x00,
  0x06, 0xF9, 0x01, 0x80, 0xD0, 0x00, 0xAF, 0x0D, 0x80, 0xD1, 0x00, 0xDF, 0x09, 0x80, 0xD0, 0x00,
  0x1F, 0x90, 0x68, 0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x7F, 0x0E, 0x80, 0xD1, 0x00,
  0xBF, 0x0B, 0x80, 0xD1, 0x00, 0xEF, 0x08, 0x80, 0xD0, 0x00, 0x2F, 0x90, 0x58, 0x0D, 0x00, 0x05,
  0xF9, 0x01, 0x80, 0xD0, 0x00, 0x8F, 0x0D, 0x80, 0xD1, 0x00, 0xCF, 0xFF, 0xD0, 0x37, 0x77, 0x5F,
  0xFF, 0xE7, 0x77, 0x50, 0x3F, 0xFF, 0xD0, 0xC7, 0x77, 0x50, 0x6F, 0xFF, 0xD0, 0x97, 0x77, 0x50,
  0x9F, 0x0D, 0x80, 0x96, 0x60, 0x27, 0x77, 0x50, 0xDF, 0x09, 0x80, 0xD1, 0x0F, 0x90, 0x68, 0x0D,
  0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x7F, 0x98, 0x0D, 0x10, 0x0A, 0xF0, 0xC8, 0x0D, 0x10,
  0x0D, 0xF0, 0x98, 0x0D, 0x00, 0x01, 0xF9, 0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x28, 0x0D, 0x00,
  0x08, 0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xF0, 0xB8, 0x0D, 0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02,
  0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D, 0x00, 0x09, 0xF0, 0xD8, 0x0D, 0x10, 0x0C,
  0xF0, 0xA8, 0x0D, 0x10, 0xF9, 0x07, 0x77, 0x78, 0x41, 0xAA, 0xAA, 0x17, 0x73, 0x03, 0xF9, 0x04,
  0x77, 0x70, 0x7B, 0x0D, 0x77, 0x40, 0x7F, 0x97, 0x77, 0x10, 0xCB, 0x0A, 0x77, 0x40, 0xAF, 0x0D,
  0x77, 0x70, 0x2C, 0x06, 0x77, 0x40, 0xDF, 0x09, 0x77, 0x70, 0x7C, 0x02, 0x77, 0x30, 0x1F, 0x90,
  0x67, 0x77, 0x0D, 0xB0, 0xE7, 0x74, 0x05, 0xF9, 0x03, 0x77, 0x60, 0x6C, 0x0A, 0x77, 0x40, 0x9F,
  0x97, 0x76, 0x01, 0x0E, 0xC0, 0x77, 0x74, 0x0E, 0xF0, 0xC7, 0x76, 0x0B, 0xD0, 0x37, 0x73, 0x07,
  0xF9, 0x08, 0x77, 0x50, 0xAD, 0x0E, 0x77, 0x30, 0x4F, 0xA0, 0x57, 0x73, 0x03, 0x0C, 0xE0, 0xB7,
  0x71, 0x02, 0x09, 0xFB, 0x08, 0x80, 0x92, 0x68, 0x17, 0x9D, 0xF9, 0x07, 0x74, 0x82, 0x9A, 0xBE,
  0x80, 0xC2, 0xF0, 0x37, 0x30, 0x18, 0x0C, 0x6F, 0x74, 0x04, 0x80, 0xC5, 0xF0, 0xB7, 0x40, 0x88,
  0x0C, 0x5F, 0x08, 0x74,
  // "ė" (U+0117)
  0x77, 0x73, 0x84, 0x4B, 0xEF, 0xD7, 0x77, 0x77, 0x10, 0x7E, 0x0C, 0x77, 0x76, 0x04, 0xF9, 0x07,
  0x77, 0x75, 0x0A, 0xF9, 0x0A, 0x77, 0x75, 0x0E, 0xF9, 0x0B, 0x77, 0x75, 0xFA, 0x0A, 0x77, 0x75,
  0x0E, 0xF9, 0x07, 0x77, 0x75, 0x0B, 0xF9, 0x01, 0x77, 0x75, 0x03, 0x0E, 0xE0, 0x57, 0x77, 0x78,
  0x52, 0xAE, 0xFD, 0x92, 0x80, 0xDB, 0x10, 0x89, 0x11, 0x59, 0xCD, 0xEF, 0xEC, 0x95, 0x77, 0x72,
  0x05, 0x0B, 0xFC, 0x0E, 0x06, 0x77, 0x50, 0x30, 0xCF, 0xF9, 0x0A, 0x77, 0x30, 0x9F, 0xFC, 0x09,
  0x77, 0x02, 0x0C, 0xE8, 0x3E, 0xA7, 0x69, 0xFA, 0x04, 0x75, 0x02, 0x0E, 0xE0, 0xA0, 0x14, 0x02,
  0x0E, 0xF0, 0xC7, 0x40, 0x30, 0xEE, 0x07, 0x70, 0x6F, 0x90, 0x17, 0x20, 0x20, 0xEE, 0x08, 0x71,
  0x01, 0xF9, 0x05, 0x71, 0x01, 0x0D, 0xE0, 0xB7, 0x30, 0xDF, 0x07, 0x71, 0x0A, 0xE0, 0xE0, 0x17,
  0x30, 0xCF, 0x09, 0x70, 0x6F, 0x06, 0x74, 0x0C, 0xF0, 0x86, 0x01, 0x0E, 0xE0, 0xD7, 0x50, 0xDF,
  0x07, 0x60, 0xAF, 0x05, 0x75, 0xF9, 0x05, 0x50, 0x3F, 0x0C, 0x75, 0x03, 0xF9, 0x01, 0x50, 0xBF,
  0x06, 0x75, 0x07, 0xF0, 0xD5, 0x04, 0xF0, 0xE7, 0x60, 0xDF, 0x07, 0x50, 0xBF, 0x08, 0x75, 0x05,
  0xF0, 0xE0, 0x14, 0x02, 0xF9, 0x03, 0x74, 0x01, 0x0D, 0xF0, 0x75, 0x08, 0xF0, 0xD7, 0x50, 0xBF,
  0x0D, 0x60, 0xEF, 0x08, 0x74, 0x0A, 0xF0, 0xE0, 0x25, 0x03, 0xF9, 0x03, 0x72, 0x01, 0x0B, 0xF9,
  0x05, 0x60, 0x8F, 0x0E, 0x72, 0x05, 0x0D, 0xF9, 0x05, 0x70, 0xCF, 0x0B, 0x70, 0x50, 0xCF, 0xA0,
  0x57, 0x01, 0xF9, 0x08, 0x28, 0x31, 0x46, 0xAE, 0xFA, 0x0D, 0x02, 0x71, 0x05, 0xFF, 0xFB, 0x08,
  0x73, 0x08, 0xFF, 0xF9, 0x0A, 0x02, 0x74, 0x0B, 0xFF, 0xD8, 0x1E, 0x82, 0x76, 0x0D, 0xFF, 0x98,
  0x2E, 0xC8, 0x47, 0x72, 0xF9, 0x86, 0xC6, 0x66, 0x54, 0x31, 0x77, 0x50, 0x1F, 0x90, 0x87, 0x77,
  0x50, 0x2F, 0x90, 0x67, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x77, 0x50,
  0x2F, 0x90, 0x57, 0x77, 0x50, 0x1F, 0x90, 0x67, 0x77, 0x6F, 0x90, 0x77, 0x77, 0x60, 0xDF, 0x0A,
  0x77, 0x76, 0x0B, 0xF0, 0xD7, 0x75, 0x01, 0x70, 0x7F, 0x90, 0x27, 0x73, 0x0A, 0x09, 0x70, 0x3F,
  0x90, 0x87, 0x72, 0x81, 0x9F, 0xB7, 0x10, 0xDF, 0x90, 0x27, 0x70, 0xAA, 0x0A, 0x71, 0x07, 0xF9,
  0x0C, 0x75, 0x02, 0x0C, 0xB0, 0x67, 0x10, 0x10, 0xEF, 0x90, 0xB0, 0x17, 0x20, 0x8C, 0x0E, 0x01,
  0x72, 0x06, 0xFA, 0x82, 0xE9, 0x41, 0x28, 0x22, 0x59, 0xED, 0x07, 0x74, 0x0A, 0xFF, 0xF9, 0x0C,
  0x76, 0x0C, 0xFF, 0xE0, 0xD0, 0x27, 0x70, 0xBF, 0xFC, 0x0D, 0x02, 0x77, 0x20, 0x8F, 0xFA, 0x09,
  0x01, 0x77, 0x40, 0x20, 0xAF, 0xD0, 0xB0, 0x37, 0x77, 0x18, 0x31, 0x69, 0xCE, 0xA8, 0x3E, 0xCA,
  0x62, 0x77,
  // "Ę" (U+0118)
  0x76, 0x03, 0x80, 0xC3, 0xF0, 0x57, 0x60, 0x78, 0x0C, 0x3F, 0x03, 0x76, 0x0A, 0x80, 0xC3, 0xF7,
  0x78, 0x29, 0xBC, 0xEF, 0xFF, 0xFF, 0x0C, 0x77, 0x40, 0x40, 0xCF, 0xA0, 0xE8, 0x09, 0x16, 0x07,
  0x0A, 0xF9, 0x09, 0x77, 0x50, 0x10, 0xEF, 0x90, 0xA7, 0x71, 0x02, 0x0D, 0xE0, 0x67, 0x76, 0x0A,
  0xF9, 0x07, 0x77, 0x20, 0x2E, 0x03, 0x77, 0x60, 0x9F, 0x90, 0x37, 0x73, 0x09, 0xD7, 0x77, 0x09,
  0xF9, 0x77, 0x40, 0x5C, 0x0D, 0x77, 0x70, 0xBF, 0x0C, 0x77, 0x40, 0x3C, 0x0A, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x40, 0x3C, 0x07, 0x77, 0x60, 0x2F, 0x90, 0x57, 0x74, 0x05, 0xC0, 0x47, 0x76, 0x05,
  0xF9, 0x02, 0x77, 0x40, 0x6C, 0x01, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x50, 0x8B, 0x0D, 0x77, 0x70,
  0xCF, 0x0B, 0x77, 0x50, 0xAB, 0x0A, 0x77, 0x7F, 0x90, 0x77, 0x75, 0x83, 0x56, 0x66, 0x37, 0x76,
  0x03, 0xF9, 0x04, 0x80, 0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D, 0x00, 0x0A, 0xF0, 0xD8, 0x0D, 0x10,
  0x0D, 0xF0, 0x98, 0x0D, 0x00, 0x01, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F, 0x90, 0x38, 0x0D, 0x00,
  0x07, 0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xF0, 0xB8, 0x0D, 0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02,
  0xF9, 0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x18, 0x0D, 0x00, 0x08, 0xF0, 0xD8, 0x0D, 0x10, 0x0C,
  0xFF, 0xFD, 0x03, 0x77, 0x75, 0xFF, 0xFE, 0x77, 0x75, 0x03, 0xFF, 0xFD, 0x0C, 0x77, 0x75, 0x06,
  0xFF, 0xFD, 0x09, 0x77, 0x75, 0x09, 0xF0, 0xD8, 0x09, 0x66, 0x02, 0x77, 0x75, 0x0D, 0xF0, 0x98,
  0x0D, 0x10, 0xF9, 0x06, 0x80, 0xD0, 0x00, 0x4F, 0x90, 0x38, 0x0D, 0x00, 0x07, 0xF9, 0x80, 0xD1,
  0x00, 0xAF, 0x0C, 0x80, 0xD1, 0x00, 0xDF, 0x09, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x58, 0x0D, 0x00,
  0x05, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x8F, 0x0E, 0x80, 0xD1, 0x00, 0xBF, 0x0B, 0x80, 0xD1, 0x00,
  0xEF, 0x08, 0x80, 0xD0, 0x00, 0x2F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9, 0x01, 0x80, 0xD0, 0x00,
  0x9F, 0x0D, 0x80, 0xD1, 0x00, 0xCF, 0x0A, 0x80, 0xD1, 0x0F, 0x90, 0x77, 0x77, 0x84, 0x1A, 0xAA,
  0xA1, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x77, 0x07, 0xB0, 0xD7, 0x74, 0x07, 0xF9, 0x77, 0x71, 0x0C,
  0xB0, 0xA7, 0x74, 0x0A, 0xF0, 0xD7, 0x77, 0x02, 0xC0, 0x67, 0x74, 0x0D, 0xF0, 0x97, 0x77, 0x07,
  0xC0, 0x27, 0x73, 0x01, 0xF9, 0x06, 0x77, 0x70, 0xDB, 0x0E, 0x77, 0x40, 0x5F, 0x90, 0x37, 0x76,
  0x06, 0xC0, 0xA7, 0x74, 0x09, 0xF9, 0x77, 0x60, 0x10, 0xEC, 0x07, 0x77, 0x40, 0xEF, 0x0C, 0x77,
  0x60, 0xBD, 0x03, 0x77, 0x30, 0x7F, 0x90, 0x87, 0x75, 0x0A, 0xD0, 0xE7, 0x73, 0x04, 0xFA, 0x05,
  0x77, 0x30, 0x30, 0xCE, 0x0B, 0x77, 0x10, 0x20, 0x9F, 0xB0, 0x88, 0x09, 0x26, 0x81, 0x79, 0xDF,
  0x90, 0x77, 0x48, 0x29, 0xAB, 0xE8, 0x0C, 0x2F, 0x03, 0x73, 0x01, 0x80, 0xC6, 0xF7, 0x40, 0x48,
  0x0C, 0x5F, 0x0B, 0x74, 0x08, 0x80, 0xC5, 0xF0, 0x88, 0x0C, 0x70, 0x84, 0x16, 0x77, 0x75, 0x80,
  0xD2, 0x00, 0x30, 0xAB, 0x0D, 0x05, 0x80, 0xD1, 0x00, 0x20, 0xBC, 0x08, 0x80, 0xD2, 0x00, 0x7C,
  0x0E, 0x04, 0x80, 0xD2, 0x00, 0xBC, 0x0E, 0x02, 0x80, 0xD2, 0x00, 0xCD, 0x04, 0x80, 0xD2, 0x00,
  0xBD, 0x07, 0x80, 0xD2, 0x00, 0x7D, 0x0D, 0x80, 0xD2, 0x00, 0x10, 0xED, 0x06, 0x80, 0xD2, 0x00,
  0x6E, 0x01, 0x80, 0xD2, 0x00, 0xBD, 0x0E, 0x80, 0xD3, 0x00, 0xDD, 0x0D, 0x80, 0xD3, 0x0E, 0x0C,
  0x80, 0xD3, 0x0E, 0x0E, 0x80, 0xD3, 0x00, 0xEE, 0x03, 0x80, 0xD2, 0x00, 0xCE, 0x0C, 0x80, 0xD2,
  0x00, 0x9F, 0x0C, 0x04, 0x28, 0x21, 0x48, 0xC8, 0x0C, 0x20, 0x03, 0xFF, 0x0C, 0x80, 0xC3, 0x00,
  0xAF, 0xE0, 0x98, 0x0C, 0x40, 0x0C, 0xFD, 0x06, 0x80, 0xC5, 0x00, 0x9F, 0xB0, 0xD0, 0x28, 0x0C,
  0x60, 0x89, 0x02, 0x8C, 0xEF, 0xED, 0xB8, 0x37, 0x74,
  // "ę" (U+0119)
  0x77, 0x58, 0x91, 0x15, 0x9C, 0xDE, 0xFE, 0xC9, 0x57, 0x77, 0x20, 0x50, 0xBF, 0xC0, 0xE0, 0x67,
  0x75, 0x03, 0x0C, 0xFF, 0x90, 0xA7, 0x73, 0x09, 0xFF, 0xC0, 0x97, 0x70, 0x20, 0xCE, 0x83, 0xEA,
  0x76, 0x9F, 0xA0, 0x47, 0x50, 0x20, 0xEE, 0x0A, 0x01, 0x40, 0x20, 0xEF, 0x0C, 0x74, 0x03, 0x0E,
  0xE0, 0x77, 0x06, 0xF9, 0x01, 0x72, 0x02, 0x0E, 0xE0, 0x87, 0x10, 0x1F, 0x90, 0x57, 0x10, 0x10,
  0xDE, 0x0B, 0x73, 0x0D, 0xF0, 0x77, 0x10, 0xAE, 0x0E, 0x01, 0x73, 0x0C, 0xF0, 0x97, 0x06, 0xF0,
  0x67, 0x40, 0xCF, 0x08, 0x60, 0x10, 0xEE, 0x0D, 0x75, 0x0D, 0xF0, 0x76, 0x0A, 0xF0, 0x57, 0x5F,
  0x90, 0x55, 0x03, 0xF0, 0xC7, 0x50, 0x3F, 0x90, 0x15, 0x0B, 0xF0, 0x67, 0x50, 0x7F, 0x0D, 0x50,
  0x4F, 0x0E, 0x76, 0x0D, 0xF0, 0x75, 0x0B, 0xF0, 0x87, 0x50, 0x5F, 0x0E, 0x01, 0x40, 0x2F, 0x90,
  0x37, 0x40, 0x10, 0xDF, 0x07, 0x50, 0x8F, 0x0D, 0x75, 0x0B, 0xF0, 0xD6, 0x0E, 0xF0, 0x87, 0x40,
  0xAF, 0x0E, 0x02, 0x50, 0x3F, 0x90, 0x37, 0x20, 0x10, 0xBF, 0x90, 0x56, 0x08, 0xF0, 0xE7, 0x20,
  0x50, 0xDF, 0x90, 0x57, 0x0C, 0xF0, 0xB7, 0x05, 0x0C, 0xFA, 0x05, 0x70, 0x1F, 0x90, 0x82, 0x83,
  0x14, 0x6A, 0xEF, 0xA0, 0xD0, 0x27, 0x10, 0x5F, 0xFF, 0xB0, 0x87, 0x30, 0x8F, 0xFF, 0x90, 0xA0,
  0x27, 0x40, 0xBF, 0xFD, 0x81, 0xE8, 0x27, 0x60, 0xDF, 0xF9, 0x82, 0xEC, 0x84, 0x77, 0x2F, 0x98,
  0x6C, 0x66, 0x65, 0x43, 0x17, 0x75, 0x01, 0xF9, 0x08, 0x77, 0x75, 0x02, 0xF9, 0x06, 0x77, 0x75,
  0x03, 0xF9, 0x05, 0x77, 0x75, 0x03, 0xF9, 0x05, 0x77, 0x75, 0x02, 0xF9, 0x05, 0x77, 0x75, 0x01,
  0xF9, 0x06, 0x77, 0x76, 0xF9, 0x07, 0x77, 0x76, 0x0D, 0xF0, 0xA7, 0x77, 0x60, 0xBF, 0x0D, 0x77,
  0x50, 0x17, 0x07, 0xF9, 0x02, 0x77, 0x30, 0xA0, 0x97, 0x03, 0xF9, 0x08, 0x77, 0x28, 0x19, 0xFB,
  0x71, 0x0D, 0xF9, 0x02, 0x77, 0x0A, 0xA0, 0xA7, 0x10, 0x7F, 0x90, 0xC7, 0x50, 0x20, 0xCB, 0x06,
  0x71, 0x01, 0x0E, 0xF9, 0x0B, 0x01, 0x72, 0x08, 0xC0, 0xE0, 0x17, 0x20, 0x6F, 0xA8, 0x2E, 0x94,
  0x12, 0x82, 0x25, 0x9E, 0xD0, 0x77, 0x40, 0xAF, 0xFF, 0x90, 0xC7, 0x60, 0xCF, 0xFE, 0x0D, 0x02,
  0x77, 0x0B, 0xFF, 0xC0, 0xD0, 0x27, 0x72, 0x08, 0xFF, 0xA0, 0x90, 0x17, 0x74, 0x02, 0x0A, 0xFE,
  0x09, 0x77, 0x71, 0x83, 0x16, 0x9C, 0xEF, 0x05, 0x77, 0x76, 0x02, 0x0B, 0xC0, 0x87, 0x77, 0x70,
  0x7C, 0x0E, 0x04, 0x77, 0x77, 0x0B, 0xC0, 0xE0, 0x27, 0x77, 0x70, 0xCD, 0x04, 0x77, 0x77, 0x0B,
  0xD0, 0x77, 0x77, 0x70, 0x7D, 0x0D, 0x77, 0x77, 0x01, 0x0E, 0xD0, 0x67, 0x77, 0x70, 0x6E, 0x01,
  0x77, 0x77, 0x0B, 0xD0, 0xE7, 0x77, 0x71, 0x0D, 0xD0, 0xD7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71,
  0xE0, 0xE7, 0x77, 0x71, 0x0E, 0xE0, 0x37, 0x77, 0x70, 0xCE, 0x0C, 0x77, 0x77, 0x09, 0xF0, 0xC0,
  0x42, 0x82, 0x14, 0x8C, 0x77, 0x60, 0x3F, 0xF0, 0xC7, 0x77, 0x0A, 0xFE, 0x09, 0x77, 0x71, 0x0C,
  0xFD, 0x06, 0x77, 0x72, 0x09, 0xFB, 0x0D, 0x02, 0x77, 0x73, 0x89, 0x02, 0x8C, 0xEF, 0xED, 0xB8,
  0x37, 0x70,
  // "Ě" (U+011A)
  0x77, 0x77, 0x0F, 0x70, 0x37, 0x71, 0x83, 0x27, 0x77, 0x57, 0x77, 0x72, 0xB0, 0xE0, 0x37, 0x60,
  0x60, 0xEB, 0x07, 0x77, 0x77, 0x20, 0xBB, 0x0D, 0x01, 0x74, 0x0A, 0xC0, 0xA7, 0x77, 0x73, 0x04,
  0xC0, 0xB7, 0x20, 0x10, 0xCC, 0x0C, 0x77, 0x77, 0x50, 0xCC, 0x07, 0x70, 0x30, 0xEC, 0x0D, 0x01,
  0x77, 0x77, 0x50, 0x6D, 0x03, 0x50, 0x40, 0xEC, 0x0E, 0x02, 0x77, 0x77, 0x70, 0xEC, 0x0C, 0x40,
  0x6E, 0x04, 0x80, 0xC0, 0x00, 0x8D, 0x07, 0x20, 0x7E, 0x06, 0x80, 0xC1, 0x00, 0x3D, 0x81, 0xE1,
  0x7E, 0x09, 0x80, 0xC3, 0x00, 0xCD, 0x0D, 0xE0, 0xC8, 0x0C, 0x40, 0x07, 0xFC, 0x0E, 0x01, 0x80,
  0xC4, 0x00, 0x1F, 0xC0, 0x38, 0x0C, 0x60, 0x0D, 0xFA, 0x07, 0x80, 0xC7, 0x00, 0x9F, 0x90, 0xC8,
  0x0D, 0x00, 0x05, 0xF0, 0xE0, 0x28, 0x0C, 0xC3, 0x00, 0x38, 0x0C, 0x3F, 0x05, 0x76, 0x07, 0x80,
  0xC3, 0xF0, 0x37, 0x60, 0xA8, 0x0C, 0x3F, 0x77, 0x82, 0x9B, 0xCE, 0xFF, 0xFF, 0xF0, 0xC7, 0x74,
  0x04, 0x0C, 0xFA, 0x0E, 0x80, 0x91, 0x60, 0x70, 0xAF, 0x90, 0x97, 0x75, 0x01, 0x0E, 0xF9, 0x0A,
  0x77, 0x10, 0x20, 0xDE, 0x06, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x72, 0x02, 0xE0, 0x37, 0x76, 0x09,
  0xF9, 0x03, 0x77, 0x30, 0x9D, 0x77, 0x70, 0x9F, 0x97, 0x74, 0x05, 0xC0, 0xD7, 0x77, 0x0B, 0xF0,
  0xC7, 0x74, 0x03, 0xC0, 0xA7, 0x77, 0x0E, 0xF0, 0x97, 0x74, 0x03, 0xC0, 0x77, 0x76, 0x02, 0xF9,
  0x05, 0x77, 0x40, 0x5C, 0x04, 0x77, 0x60, 0x5F, 0x90, 0x27, 0x74, 0x06, 0xC0, 0x17, 0x76, 0x09,
  0xF0, 0xE7, 0x75, 0x08, 0xB0, 0xD7, 0x77, 0x0C, 0xF0, 0xB7, 0x75, 0x0A, 0xB0, 0xA7, 0x77, 0xF9,
  0x07, 0x77, 0x58, 0x35, 0x66, 0x63, 0x77, 0x60, 0x3F, 0x90, 0x48, 0x0D, 0x00, 0x06, 0xF9, 0x01,
  0x80, 0xD0, 0x00, 0xAF, 0x0D, 0x80, 0xD1, 0x00, 0xDF, 0x09, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x68,
  0x0D, 0x00, 0x04, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x7F, 0x0E, 0x80, 0xD1, 0x00, 0xBF, 0x0B, 0x80,
  0xD1, 0x00, 0xEF, 0x08, 0x80, 0xD0, 0x00, 0x2F, 0x90, 0x58, 0x0D, 0x00, 0x05, 0xF9, 0x01, 0x80,
  0xD0, 0x00, 0x8F, 0x0D, 0x80, 0xD1, 0x00, 0xCF, 0xFF, 0xD0, 0x37, 0x77, 0x5F, 0xFF, 0xE7, 0x77,
  0x50, 0x3F, 0xFF, 0xD0, 0xC7, 0x77, 0x50, 0x6F, 0xFF, 0xD0, 0x97, 0x77, 0x50, 0x9F, 0x0D, 0x80,
  0x96, 0x60, 0x27, 0x77, 0x50, 0xDF, 0x09, 0x80, 0xD1, 0x0F, 0x90, 0x68, 0x0D, 0x00, 0x04, 0xF9,
  0x03, 0x80, 0xD0, 0x00, 0x7F, 0x98, 0x0D, 0x10, 0x0A, 0xF0, 0xC8, 0x0D, 0x10, 0x0D, 0xF0, 0x98,
  0x0D, 0x00, 0x01, 0xF9, 0x05, 0x80, 0xD0, 0x00, 0x5F, 0x90, 0x28, 0x0D, 0x00, 0x08, 0xF0, 0xE8,
  0x0D, 0x10, 0x0B, 0xF0, 0xB8, 0x0D, 0x10, 0x0E, 0xF0, 0x88, 0x0D, 0x00, 0x02, 0xF9, 0x04, 0x80,
  0xD0, 0x00, 0x6F, 0x90, 0x18, 0x0D, 0x00, 0x09, 0xF0, 0xD8, 0x0D, 0x10, 0x0C, 0xF0, 0xA8, 0x0D,
  0x10, 0xF9, 0x07, 0x77, 0x78, 0x41, 0xAA, 0xAA, 0x17, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x70, 0x7B,
  0x0D, 0x77, 0x40, 0x7F, 0x97, 0x77, 0x10, 0xCB, 0x0A, 0x77, 0x40, 0xAF, 0x0D, 0x77, 0x70, 0x2C,
  0x06, 0x77, 0x40, 0xDF, 0x09, 0x77, 0x70, 0x7C, 0x02, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x77, 0x0D,
  0xB0, 0xE7, 0x74, 0x05, 0xF9, 0x03, 0x77, 0x60, 0x6C, 0x0A, 0x77, 0x40, 0x9F, 0x97, 0x76, 0x01,
  0x0E, 0xC0, 0x77, 0x74, 0x0E, 0xF0, 0xC7, 0x76, 0x0B, 0xD0, 0x37, 0x73, 0x07, 0xF9, 0x08, 0x77,
  0x50, 0xAD, 0x0E, 0x77, 0x30, 0x4F, 0xA0, 0x57, 0x73, 0x03, 0x0C, 0xE0, 0xB7, 0x71, 0x02, 0x09,
  0xFB, 0x08, 0x80, 0x92, 0x68, 0x17, 0x9D, 0xF9, 0x07, 0x74, 0x82, 0x9A, 0xBE, 0x80, 0xC2, 0xF0,
  0x37, 0x30, 0x18, 0x0C, 0x6F, 0x74, 0x04, 0x80, 0xC5, 0xF0, 0xB7, 0x40, 0x88, 0x0C, 0x5F, 0x08,
  0x74,
  // "ě" (U+011B)
  0x77, 0x50, 0xF7, 0x03, 0x77, 0x18, 0x32, 0x77, 0x75, 0x77, 0x5B, 0x0E, 0x03, 0x76, 0x06, 0x0E,
  0xB0, 0x77, 0x75, 0x0B, 0xB0, 0xD0, 0x17, 0x40, 0xAC, 0x0A, 0x77, 0x60, 0x4C, 0x0B, 0x72, 0x01,
  0x0C, 0xC0, 0xC7, 0x77, 0x10, 0xCC, 0x07, 0x70, 0x30, 0xEC, 0x0D, 0x01, 0x77, 0x71, 0x06, 0xD0,
  0x35, 0x04, 0x0E, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0xEC, 0x0C, 0x40, 0x6E, 0x04, 0x77, 0x74, 0x08,
  0xD0, 0x72, 0x07, 0xE0, 0x67, 0x77, 0x50, 0x3D, 0x81, 0xE1, 0x7E, 0x09, 0x77, 0x77, 0x0C, 0xD0,
  0xDE, 0x0C, 0x77, 0x77, 0x10, 0x7F, 0xC0, 0xE0, 0x17, 0x77, 0x71, 0x01, 0xFC, 0x03, 0x77, 0x77,
  0x30, 0xDF, 0xA0, 0x77, 0x77, 0x74, 0x09, 0xF9, 0x0C, 0x77, 0x77, 0x50, 0x5F, 0x0E, 0x02, 0x80,
  0xBE, 0x00, 0x89, 0x11, 0x59, 0xCD, 0xEF, 0xEC, 0x95, 0x77, 0x77, 0x20, 0x50, 0xBF, 0xC0, 0xE0,
  0x67, 0x77, 0x50, 0x30, 0xCF, 0xF9, 0x0A, 0x77, 0x73, 0x09, 0xFF, 0xC0, 0x97, 0x77, 0x02, 0x0C,
  0xE8, 0x3E, 0xA7, 0x69, 0xFA, 0x04, 0x77, 0x50, 0x20, 0xEE, 0x0A, 0x01, 0x40, 0x20, 0xEF, 0x0C,
  0x77, 0x40, 0x30, 0xEE, 0x07, 0x70, 0x6F, 0x90, 0x17, 0x72, 0x02, 0x0E, 0xE0, 0x87, 0x10, 0x1F,
  0x90, 0x57, 0x71, 0x01, 0x0D, 0xE0, 0xB7, 0x30, 0xDF, 0x07, 0x77, 0x10, 0xAE, 0x0E, 0x01, 0x73,
  0x0C, 0xF0, 0x97, 0x70, 0x6F, 0x06, 0x74, 0x0C, 0xF0, 0x87, 0x60, 0x10, 0xEE, 0x0D, 0x75, 0x0D,
  0xF0, 0x77, 0x60, 0xAF, 0x05, 0x75, 0xF9, 0x05, 0x75, 0x03, 0xF0, 0xC7, 0x50, 0x3F, 0x90, 0x17,
  0x50, 0xBF, 0x06, 0x75, 0x07, 0xF0, 0xD7, 0x50, 0x4F, 0x0E, 0x76, 0x0D, 0xF0, 0x77, 0x50, 0xBF,
  0x08, 0x75, 0x05, 0xF0, 0xE0, 0x17, 0x40, 0x2F, 0x90, 0x37, 0x40, 0x10, 0xDF, 0x07, 0x75, 0x08,
  0xF0, 0xD7, 0x50, 0xBF, 0x0D, 0x76, 0x0E, 0xF0, 0x87, 0x40, 0xAF, 0x0E, 0x02, 0x75, 0x03, 0xF9,
  0x03, 0x72, 0x01, 0x0B, 0xF9, 0x05, 0x76, 0x08, 0xF0, 0xE7, 0x20, 0x50, 0xDF, 0x90, 0x57, 0x70,
  0xCF, 0x0B, 0x70, 0x50, 0xCF, 0xA0, 0x57, 0x70, 0x1F, 0x90, 0x82, 0x83, 0x14, 0x6A, 0xEF, 0xA0,
  0xD0, 0x27, 0x71, 0x05, 0xFF, 0xFB, 0x08, 0x77, 0x30, 0x8F, 0xFF, 0x90, 0xA0, 0x27, 0x74, 0x0B,
  0xFF, 0xD8, 0x1E, 0x82, 0x77, 0x60, 0xDF, 0xF9, 0x82, 0xEC, 0x84, 0x77, 0x72, 0xF9, 0x86, 0xC6,
  0x66, 0x54, 0x31, 0x77, 0x75, 0x01, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x2F, 0x90, 0x67, 0x77, 0x75,
  0x03, 0xF9, 0x05, 0x77, 0x77, 0x50, 0x3F, 0x90, 0x57, 0x77, 0x75, 0x02, 0xF9, 0x05, 0x77, 0x77,
  0x50, 0x1F, 0x90, 0x67, 0x77, 0x76, 0xF9, 0x07, 0x77, 0x77, 0x60, 0xDF, 0x0A, 0x77, 0x77, 0x60,
  0xBF, 0x0D, 0x77, 0x50, 0x17, 0x70, 0x7F, 0x90, 0x27, 0x73, 0x0A, 0x09, 0x77, 0x03, 0xF9, 0x08,
  0x77, 0x28, 0x19, 0xFB, 0x77, 0x10, 0xDF, 0x90, 0x27, 0x70, 0xAA, 0x0A, 0x77, 0x10, 0x7F, 0x90,
  0xC7, 0x50, 0x20, 0xCB, 0x06, 0x77, 0x10, 0x10, 0xEF, 0x90, 0xB0, 0x17, 0x20, 0x8C, 0x0E, 0x01,
  0x77, 0x20, 0x6F, 0xA8, 0x2E, 0x94, 0x12, 0x82, 0x25, 0x9E, 0xD0, 0x77, 0x74, 0x0A, 0xFF, 0xF9,
  0x0C, 0x77, 0x60, 0xCF, 0xFE, 0x0D, 0x02, 0x77, 0x70, 0xBF, 0xFC, 0x0D, 0x02, 0x77, 0x72, 0x08,
  0xFF, 0xA0, 0x90, 0x17, 0x77, 0x40, 0x20, 0xAF, 0xD0, 0xB0, 0x37, 0x77, 0x71, 0x83, 0x16, 0x9C,
  0xEA, 0x83, 0xEC, 0xA6, 0x27, 0x77,
  // "Ĝ" (U+011C)
  0x77, 0x77, 0x68, 0x04, 0x78, 0x0C, 0x70, 0x09, 0xF9, 0x03, 0x80, 0xC5, 0x00, 0x4F, 0xA0, 0x78,
  0x0C, 0x40, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xC4, 0x00, 0xCF, 0xC0, 0x18, 0x0C, 0x20, 0x09, 0xFD,
  0x07, 0x80, 0xC1, 0x00, 0x6E, 0x0B, 0x0D, 0xD0, 0xC8, 0x0C, 0x00, 0x03, 0xE8, 0x1A, 0x04, 0xE0,
  0x27, 0x77, 0x76, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x97, 0x77, 0x76, 0x0C, 0xD0, 0x84, 0x01,
  0x0E, 0xC0, 0xE7, 0x77, 0x75, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x77, 0x77, 0x73, 0x09, 0xC0, 0xE0,
  0x57, 0x10, 0x9C, 0x0D, 0x77, 0x77, 0x20, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x77, 0x70,
  0x5C, 0x0A, 0x01, 0x74, 0x01, 0x0C, 0xB0, 0xD7, 0x77, 0x70, 0xCA, 0x0D, 0x04, 0x77, 0x01, 0x0C,
  0xA0, 0xD8, 0x0B, 0xD5, 0x08, 0x52, 0x58, 0xBC, 0xDE, 0xA8, 0x5E, 0xDC, 0xB9, 0x62, 0x77, 0x77,
  0x58, 0x14, 0x9D, 0xFF, 0xA8, 0x1D, 0x82, 0x77, 0x76, 0x81, 0x17, 0xDF, 0xFF, 0x90, 0x90, 0x17,
  0x77, 0x30, 0x80, 0xEF, 0xFF, 0xC0, 0xD0, 0x27, 0x77, 0x05, 0x0E, 0xFA, 0x86, 0xD9, 0x86, 0x78,
  0xAE, 0xFC, 0x0E, 0x02, 0x77, 0x40, 0x10, 0xBF, 0x98, 0x1E, 0x82, 0x71, 0x05, 0x0D, 0xFB, 0x0D,
  0x77, 0x30, 0x40, 0xEF, 0x90, 0x77, 0x60, 0xBF, 0xB0, 0x67, 0x71, 0x07, 0xF9, 0x0C, 0x02, 0x77,
  0x10, 0xCF, 0xA0, 0xC7, 0x70, 0x8F, 0x90, 0xA7, 0x73, 0x04, 0xFB, 0x76, 0x09, 0xF9, 0x09, 0x77,
  0x50, 0xBF, 0xA7, 0x50, 0x8F, 0x90, 0x97, 0x76, 0x06, 0xF9, 0x0E, 0x74, 0x06, 0xF9, 0x0A, 0x77,
  0x70, 0x1F, 0x90, 0xA7, 0x30, 0x4F, 0x90, 0xD7, 0x77, 0x20, 0xDF, 0x04, 0x72, 0x01, 0x0E, 0xF0,
  0xE0, 0x27, 0x77, 0x20, 0xBE, 0x09, 0x73, 0x0B, 0xF9, 0x06, 0x77, 0x73, 0x09, 0xD0, 0x77, 0x30,
  0x7F, 0x90, 0xB7, 0x77, 0x40, 0x9A, 0x81, 0xD8, 0x17, 0x30, 0x10, 0xEF, 0x90, 0x27, 0x77, 0x48,
  0x12, 0x21, 0x76, 0x0A, 0xF9, 0x08, 0x80, 0xC5, 0x00, 0x3F, 0x90, 0xE0, 0x18, 0x0C, 0x50, 0x0C,
  0xF9, 0x08, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0x18, 0x0C, 0x50, 0x0B, 0xF9, 0x09, 0x80, 0xC5, 0x00,
  0x2F, 0xA0, 0x28, 0x0C, 0x50, 0x09, 0xF9, 0x0C, 0x80, 0xC6, 0x00, 0xEF, 0x90, 0x68, 0x0C, 0x50,
  0x05, 0xFA, 0x01, 0x80, 0xC5, 0x00, 0xAF, 0x90, 0xB8, 0x0C, 0x60, 0x0E, 0xF9, 0x06, 0x80, 0xC5,
  0x00, 0x3F, 0xA0, 0x28, 0x0C, 0x50, 0x08, 0xF9, 0x0D, 0x80, 0xC6, 0x00, 0xCF, 0x90, 0x98, 0x0C,
  0x60, 0xFA, 0x06, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0x28, 0x0C, 0x50, 0x06, 0xFA, 0x80, 0xC6, 0x00,
  0x9F, 0x90, 0xC8, 0x0C, 0x60, 0x0B, 0xF9, 0x0A, 0x77, 0x50, 0xCF, 0xFE, 0x81, 0xA0, 0xCF, 0x90,
  0x77, 0x75, 0xFF, 0xF8, 0x17, 0x0E, 0xF9, 0x05, 0x77, 0x40, 0x3F, 0xFF, 0x04, 0x1F, 0xA0, 0x47,
  0x74, 0x06, 0xFF, 0xF0, 0x01, 0xFA, 0x03, 0x77, 0x68, 0x21, 0x37, 0xCF, 0xD8, 0x1A, 0x41, 0x20,
  0x2F, 0xA0, 0x17, 0x77, 0x30, 0xCF, 0xA0, 0xE0, 0x35, 0x02, 0xFA, 0x77, 0x74, 0x07, 0xFA, 0x04,
  0x60, 0x3F, 0xA7, 0x77, 0x40, 0x5F, 0x90, 0xB7, 0x03, 0xFA, 0x77, 0x74, 0x05, 0xF9, 0x05, 0x70,
  0x3F, 0x90, 0xE7, 0x77, 0x40, 0x7F, 0x90, 0x17, 0x02, 0xFA, 0x77, 0x74, 0x0A, 0xF0, 0xC7, 0x10,
  0x1F, 0xA7, 0x77, 0x40, 0xDF, 0x09, 0x72, 0x0E, 0xF9, 0x01, 0x77, 0x72, 0x01, 0xF9, 0x06, 0x72,
  0x0C, 0xF9, 0x02, 0x77, 0x72, 0x05, 0xF9, 0x02, 0x72, 0x09, 0xF9, 0x05, 0x77, 0x72, 0x08, 0xF0,
  0xE7, 0x30, 0x6F, 0x90, 0x87, 0x77, 0x20, 0xBF, 0x0B, 0x73, 0x02, 0xF9, 0x0B, 0x77, 0x72, 0x0E,
  0xF0, 0x87, 0x40, 0xDF, 0x90, 0x17, 0x77, 0x02, 0xF9, 0x05, 0x74, 0x07, 0xF9, 0x06, 0x77, 0x70,
  0x5F, 0x90, 0x27, 0x40, 0x1F, 0x90, 0xB7, 0x77, 0x09, 0xF0, 0xE7, 0x60, 0x9F, 0x90, 0x47, 0x76,
  0x0C, 0xF0, 0xB7, 0x60, 0x2F, 0x90, 0xC7, 0x76, 0xF9, 0x07, 0x77, 0x07, 0xF9, 0x08, 0x77, 0x40,
  0x3F, 0x90, 0x47, 0x71, 0x0C, 0xF9, 0x06, 0x77, 0x30, 0x6F, 0x90, 0x17, 0x71, 0x01, 0x0E, 0xF9,
  0x09, 0x77, 0x10, 0x60, 0xEF, 0x0D, 0x77, 0x30, 0x20, 0xEF, 0x98, 0x1E, 0x71, 0x72, 0x81, 0x28,
  0xDF, 0xA0, 0xA7, 0x74, 0x02, 0x0D, 0xFB, 0x87, 0xDA, 0x76, 0x67, 0x8B, 0xEF, 0xD0, 0x67, 0x76,
  0x0A, 0xFF, 0xFF, 0x0A, 0x03, 0x77, 0x71, 0x04, 0x0C, 0xFF, 0xFA, 0x81, 0xC7, 0x17, 0x77, 0x58,
  0x13, 0x9E, 0xFF, 0xB8, 0x1B, 0x72, 0x77, 0x77, 0x48, 0x43, 0x69, 0xBD, 0xEB, 0x85, 0xED, 0xCA,
  0x86, 0x37, 0x77,
  // "ĝ" (U+011D)
  0x77, 0x77, 0x28, 0x04, 0x78, 0x0C, 0x70, 0x09, 0xF9, 0x03, 0x80, 0xC5, 0x00, 0x4F, 0xA0, 0x78,
  0x0C, 0x40, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xC4, 0x00, 0xCF, 0xC0, 0x18, 0x0C, 0x20, 0x09, 0xFD,
  0x07, 0x80, 0xC1, 0x00, 0x6E, 0x0B, 0x0D, 0xD0, 0xC8, 0x0C, 0x00, 0x03, 0xE8, 0x1A, 0x04, 0xE0,
  0x27, 0x77, 0x76, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x97, 0x77, 0x76, 0x0C, 0xD0, 0x84, 0x01,
  0x0E, 0xC0, 0xE7, 0x77, 0x75, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x77, 0x77, 0x73, 0x09, 0xC0, 0xE0,
  0x57, 0x10, 0x9C, 0x0D, 0x77, 0x77, 0x20, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x77, 0x70,
  0x5C, 0x0A, 0x01, 0x74, 0x01, 0x0C, 0xB0, 0xD7, 0x77, 0x70, 0xCA, 0x0D, 0x04, 0x77, 0x01, 0x0C,
  0xA0, 0xD8, 0x0A, 0xB2, 0x08, 0x46, 0xBE, 0xFD, 0x58, 0x0D, 0x00, 0x04, 0x0D, 0xE0, 0x58, 0x0C,
  0x60, 0x05, 0xF9, 0x0C, 0x77, 0x75, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDA, 0x61, 0x40, 0x6F, 0xB7,
  0x77, 0x28, 0x11, 0x8E, 0xFC, 0x09, 0x20, 0x4F, 0xB0, 0xE7, 0x77, 0x10, 0x7F, 0xF9, 0x81, 0xC3,
  0xEF, 0xB0, 0xC7, 0x76, 0x02, 0x0C, 0xFF, 0xF8, 0x29, 0x21, 0x9C, 0x07, 0x77, 0x50, 0x30, 0xEE,
  0x84, 0xEA, 0x76, 0x8D, 0xFA, 0x05, 0x40, 0xEA, 0x0E, 0x01, 0x77, 0x40, 0x30, 0xEE, 0x09, 0x01,
  0x50, 0x8F, 0x08, 0x58, 0x2B, 0xFE, 0x47, 0x74, 0x02, 0x0E, 0xE0, 0x77, 0x10, 0xAE, 0x0E, 0x50,
  0x04, 0x77, 0x60, 0xCE, 0x08, 0x72, 0x03, 0xF0, 0x47, 0x77, 0x40, 0x7E, 0x0C, 0x74, 0x0E, 0xE0,
  0x87, 0x77, 0x30, 0x2F, 0x03, 0x74, 0x0C, 0xE0, 0xB7, 0x77, 0x30, 0xAE, 0x0A, 0x75, 0x0B, 0xE0,
  0xC7, 0x77, 0x20, 0x2F, 0x03, 0x75, 0x0B, 0xE0, 0xD7, 0x77, 0x20, 0x9E, 0x0D, 0x76, 0x0B, 0xE0,
  0xD7, 0x77, 0x20, 0xEE, 0x07, 0x76, 0x0C, 0xE0, 0xC7, 0x77, 0x10, 0x4F, 0x03, 0x76, 0x0E, 0xE0,
  0xA7, 0x77, 0x10, 0x8E, 0x0E, 0x76, 0x02, 0xF0, 0x77, 0x77, 0x10, 0xCE, 0x0B, 0x76, 0x04, 0xF0,
  0x47, 0x77, 0x1F, 0x08, 0x76, 0x08, 0xF7, 0x77, 0x10, 0x1F, 0x06, 0x76, 0x0C, 0xE0, 0xB7, 0x77,
  0x10, 0x3F, 0x04, 0x75, 0x01, 0xF0, 0x67, 0x77, 0x10, 0x3F, 0x03, 0x75, 0x07, 0xF0, 0x17, 0x77,
  0x10, 0x3F, 0x03, 0x75, 0x0D, 0xE0, 0x97, 0x77, 0x20, 0x2F, 0x04, 0x74, 0x06, 0xF0, 0x27, 0x77,
  0x3F, 0x06, 0x73, 0x01, 0x0E, 0xE0, 0x87, 0x77, 0x40, 0xDE, 0x09, 0x73, 0x09, 0xE0, 0xD7, 0x77,
  0x50, 0x8E, 0x0E, 0x01, 0x71, 0x08, 0xF0, 0x37, 0x77, 0x50, 0x2F, 0x0A, 0x70, 0x8F, 0x06, 0x77,
  0x77, 0x0A, 0xF8, 0x5B, 0x41, 0x02, 0x6C, 0xF0, 0x77, 0x77, 0x71, 0x01, 0x0D, 0xFF, 0xD0, 0x67,
  0x77, 0x73, 0x02, 0x0D, 0xFF, 0xA0, 0xD0, 0x37, 0x77, 0x75, 0x01, 0x0A, 0xFE, 0x0E, 0x07, 0x77,
  0x77, 0x70, 0x20, 0xBF, 0xC0, 0xB0, 0x68, 0x0C, 0x00, 0x08, 0xC8, 0x6D, 0x64, 0x56, 0x54, 0x28,
  0x0C, 0x10, 0x02, 0x0C, 0xC0, 0x88, 0x0D, 0x00, 0x03, 0x0E, 0xB0, 0xE0, 0x38, 0x0D, 0x00, 0x02,
  0x0E, 0xB0, 0xE0, 0x28, 0x0D, 0x10, 0x0C, 0xC0, 0x88, 0x0D, 0x10, 0x05, 0xD0, 0x48, 0x0D, 0x10,
  0x09, 0xD0, 0x58, 0x0D, 0x10, 0x0C, 0xD0, 0xC0, 0x18, 0x0D, 0x00, 0x0D, 0xE8, 0x3E, 0x96, 0x32,
  0x80, 0xC4, 0x00, 0xCF, 0xD8, 0x5E, 0xCB, 0x97, 0x52, 0x77, 0x77, 0x40, 0x8F, 0xFD, 0x81, 0xE9,
  0x47, 0x77, 0x71, 0x01, 0x0E, 0xFF, 0xF0, 0xC0, 0x47, 0x77, 0x70, 0x4F, 0xFF, 0xA0, 0x97, 0x77,
  0x70, 0x40, 0xEF, 0xFF, 0x90, 0xB7, 0x77, 0x58, 0x13, 0x7D, 0xFF, 0xFA, 0x08, 0x77, 0x72, 0x06,
  0x0D, 0xFF, 0xFE, 0x02, 0x77, 0x60, 0x60, 0xED, 0x89, 0x1E, 0xA7, 0x44, 0x57, 0x8A, 0xCD, 0xFE,
  0x09, 0x77, 0x40, 0x20, 0xCD, 0x0D, 0x06, 0x75, 0x81, 0x26, 0xBF, 0xA0, 0xD7, 0x73, 0x04, 0x0E,
  0xD0, 0x97, 0x73, 0x04, 0x0E, 0xF9, 0x02, 0x77, 0x10, 0x30, 0xED, 0x07, 0x77, 0x50, 0x20, 0xEF,
  0x03, 0x77, 0x01, 0x0E, 0xD0, 0x87, 0x77, 0x08, 0xF0, 0x57, 0x70, 0xBD, 0x0D, 0x77, 0x71, 0x02,
  0xF0, 0x57, 0x60, 0x3E, 0x05, 0x77, 0x72, 0xF0, 0x47, 0x60, 0xAE, 0x77, 0x73, 0x0E, 0xE0, 0x37,
  0x60, 0xED, 0x0B, 0x77, 0x73, 0xF7, 0x60, 0x2E, 0x09, 0x77, 0x72, 0x02, 0xE0, 0xD7, 0x60, 0x4E,
  0x08, 0x77, 0x72, 0x05, 0xE0, 0x87, 0x60, 0x4E, 0x09, 0x77, 0x72, 0x0A, 0xE0, 0x37, 0x60, 0x4E,
  0x0A, 0x77, 0x71, 0x02, 0xE0, 0xC7, 0x70, 0x2E, 0x0E, 0x77, 0x71, 0x0A, 0xE0, 0x47, 0x71, 0x0E,
  0xE0, 0x67, 0x76, 0x07, 0xE0, 0xB7, 0x72, 0x09, 0xE0, 0xE0, 0x17, 0x74, 0x07, 0xE0, 0xE0, 0x17,
  0x72, 0x03, 0xF0, 0xC0, 0x27, 0x71, 0x02, 0x0B, 0xF0, 0x47, 0x74, 0x09, 0xF8, 0x1E, 0x82, 0x74,
  0x04, 0x0A, 0xF9, 0x04, 0x77, 0x60, 0xBF, 0xA8, 0x90, 0xDA, 0x87, 0x66, 0x78, 0xAC, 0xFA, 0x0D,
  0x02, 0x77, 0x71, 0x0A, 0xFF, 0xFD, 0x09, 0x01, 0x77, 0x73, 0x06, 0x0E, 0xFF, 0xF9, 0x0A, 0x02,
  0x77, 0x77, 0x06, 0x0C, 0xFF, 0xB8, 0x1C, 0x81, 0x77, 0x77, 0x48, 0x51, 0x58, 0xAC, 0xDE, 0xA8,
  0x6E, 0xED, 0xCA, 0x75, 0x17, 0x77, 0x50,
  // "Ğ" (U+011E)
  0x77, 0x74, 0x05, 0xB0, 0x67, 0x70, 0xCB, 0x77, 0x77, 0x10, 0x4B, 0x09, 0x76, 0x05, 0xB0, 0xB7,
  0x77, 0x71, 0x03, 0xB0, 0xD7, 0x50, 0x10, 0xEB, 0x06, 0x77, 0x77, 0x10, 0x1C, 0x06, 0x74, 0x0C,
  0xB0, 0xE7, 0x77, 0x73, 0x0D, 0xC0, 0x57, 0x10, 0x30, 0xDC, 0x08, 0x77, 0x77, 0x30, 0x9D, 0x81,
  0xB5, 0x12, 0x81, 0x25, 0xAD, 0x0D, 0x77, 0x77, 0x40, 0x4F, 0xFC, 0x05, 0x77, 0x77, 0x50, 0xDF,
  0xFA, 0x08, 0x77, 0x77, 0x60, 0x4F, 0xF9, 0x0A, 0x80, 0xC0, 0x00, 0x7F, 0xE0, 0x88, 0x0C, 0x20,
  0x05, 0x0E, 0xFA, 0x0C, 0x04, 0x80, 0xC5, 0x08, 0x76, 0xAD, 0xEF, 0xDC, 0x84, 0x80, 0xBE, 0x40,
  0x85, 0x25, 0x8B, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x96, 0x27, 0x77, 0x75, 0x81, 0x49, 0xDF, 0xFA,
  0x81, 0xD8, 0x27, 0x77, 0x68, 0x11, 0x7D, 0xFF, 0xF9, 0x09, 0x01, 0x77, 0x73, 0x08, 0x0E, 0xFF,
  0xFC, 0x0D, 0x02, 0x77, 0x70, 0x50, 0xEF, 0xA8, 0x6D, 0x98, 0x67, 0x8A, 0xEF, 0xC0, 0xE0, 0x27,
  0x74, 0x01, 0x0B, 0xF9, 0x81, 0xE8, 0x27, 0x10, 0x50, 0xDF, 0xB0, 0xD7, 0x73, 0x04, 0x0E, 0xF9,
  0x07, 0x76, 0x0B, 0xFB, 0x06, 0x77, 0x10, 0x7F, 0x90, 0xC0, 0x27, 0x71, 0x0C, 0xFA, 0x0C, 0x77,
  0x08, 0xF9, 0x0A, 0x77, 0x30, 0x4F, 0xB7, 0x60, 0x9F, 0x90, 0x97, 0x75, 0x0B, 0xFA, 0x75, 0x08,
  0xF9, 0x09, 0x77, 0x60, 0x6F, 0x90, 0xE7, 0x40, 0x6F, 0x90, 0xA7, 0x77, 0x01, 0xF9, 0x0A, 0x73,
  0x04, 0xF9, 0x0D, 0x77, 0x72, 0x0D, 0xF0, 0x47, 0x20, 0x10, 0xEF, 0x0E, 0x02, 0x77, 0x72, 0x0B,
  0xE0, 0x97, 0x30, 0xBF, 0x90, 0x67, 0x77, 0x30, 0x9D, 0x07, 0x73, 0x07, 0xF9, 0x0B, 0x77, 0x74,
  0x09, 0xA8, 0x1D, 0x81, 0x73, 0x01, 0x0E, 0xF9, 0x02, 0x77, 0x74, 0x81, 0x22, 0x17, 0x60, 0xAF,
  0x90, 0x88, 0x0C, 0x50, 0x03, 0xF9, 0x0E, 0x01, 0x80, 0xC5, 0x00, 0xCF, 0x90, 0x88, 0x0C, 0x50,
  0x03, 0xFA, 0x01, 0x80, 0xC5, 0x00, 0xBF, 0x90, 0x98, 0x0C, 0x50, 0x02, 0xFA, 0x02, 0x80, 0xC5,
  0x00, 0x9F, 0x90, 0xC8, 0x0C, 0x60, 0x0E, 0xF9, 0x06, 0x80, 0xC5, 0x00, 0x5F, 0xA0, 0x18, 0x0C,
  0x50, 0x0A, 0xF9, 0x0B, 0x80, 0xC6, 0x00, 0xEF, 0x90, 0x68, 0x0C, 0x50, 0x03, 0xFA, 0x02, 0x80,
  0xC5, 0x00, 0x8F, 0x90, 0xD8, 0x0C, 0x60, 0x0C, 0xF9, 0x09, 0x80, 0xC6, 0x0F, 0xA0, 0x68, 0x0C,
  0x50, 0x03, 0xFA, 0x02, 0x80, 0xC5, 0x00, 0x6F, 0xA8, 0x0C, 0x60, 0x09, 0xF9, 0x0C, 0x80, 0xC6,
  0x00, 0xBF, 0x90, 0xA7, 0x75, 0x0C, 0xFF, 0xE8, 0x1A, 0x0C, 0xF9, 0x07, 0x77, 0x5F, 0xFF, 0x81,
  0x70, 0xEF, 0x90, 0x57, 0x74, 0x03, 0xFF, 0xF0, 0x41, 0xFA, 0x04, 0x77, 0x40, 0x6F, 0xFF, 0x00,
  0x1F, 0xA0, 0x37, 0x76, 0x82, 0x13, 0x7C, 0xFD, 0x81, 0xA4, 0x12, 0x02, 0xFA, 0x01, 0x77, 0x73,
  0x0C, 0xFA, 0x0E, 0x03, 0x50, 0x2F, 0xA7, 0x77, 0x40, 0x7F, 0xA0, 0x46, 0x03, 0xFA, 0x77, 0x74,
  0x05, 0xF9, 0x0B, 0x70, 0x3F, 0xA7, 0x77, 0x40, 0x5F, 0x90, 0x57, 0x03, 0xF9, 0x0E, 0x77, 0x74,
  0x07, 0xF9, 0x01, 0x70, 0x2F, 0xA7, 0x77, 0x40, 0xAF, 0x0C, 0x71, 0x01, 0xFA, 0x77, 0x74, 0x0D,
  0xF0, 0x97, 0x20, 0xEF, 0x90, 0x17, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x20, 0xCF, 0x90, 0x27, 0x77,
  0x20, 0x5F, 0x90, 0x27, 0x20, 0x9F, 0x90, 0x57, 0x77, 0x20, 0x8F, 0x0E, 0x73, 0x06, 0xF9, 0x08,
  0x77, 0x72, 0x0B, 0xF0, 0xB7, 0x30, 0x2F, 0x90, 0xB7, 0x77, 0x20, 0xEF, 0x08, 0x74, 0x0D, 0xF9,
  0x01, 0x77, 0x70, 0x2F, 0x90, 0x57, 0x40, 0x7F, 0x90, 0x67, 0x77, 0x05, 0xF9, 0x02, 0x74, 0x01,
  0xF9, 0x0B, 0x77, 0x70, 0x9F, 0x0E, 0x76, 0x09, 0xF9, 0x04, 0x77, 0x60, 0xCF, 0x0B, 0x76, 0x02,
  0xF9, 0x0C, 0x77, 0x6F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x87, 0x74, 0x03, 0xF9, 0x04, 0x77, 0x10,
  0xCF, 0x90, 0x67, 0x73, 0x06, 0xF9, 0x01, 0x77, 0x10, 0x10, 0xEF, 0x90, 0x97, 0x71, 0x06, 0x0E,
  0xF0, 0xD7, 0x73, 0x02, 0x0E, 0xF9, 0x81, 0xE7, 0x17, 0x28, 0x12, 0x8D, 0xFA, 0x0A, 0x77, 0x40,
  0x20, 0xDF, 0xB8, 0x7D, 0xA7, 0x66, 0x78, 0xBE, 0xFD, 0x06, 0x77, 0x60, 0xAF, 0xFF, 0xF0, 0xA0,
  0x37, 0x77, 0x10, 0x40, 0xCF, 0xFF, 0xA8, 0x1C, 0x71, 0x77, 0x75, 0x81, 0x39, 0xEF, 0xFB, 0x81,
  0xB7, 0x27, 0x77, 0x74, 0x84, 0x36, 0x9B, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x63, 0x77, 0x70,
  // "ğ" (U+011F)
  0x77, 0x71, 0x05, 0xB0, 0x67, 0x70, 0xCB, 0x77, 0x77, 0x10, 0x4B, 0x09, 0x76, 0x05, 0xB0, 0xB7,
  0x77, 0x71, 0x03, 0xB0, 0xD7, 0x50, 0x10, 0xEB, 0x06, 0x77, 0x77, 0x10, 0x1C, 0x06, 0x74, 0x0C,
  0xB0, 0xE7, 0x77, 0x73, 0x0D, 0xC0, 0x57, 0x10, 0x30, 0xDC, 0x08, 0x77, 0x77, 0x30, 0x9D, 0x81,
  0xB5, 0x12, 0x81, 0x25, 0xAD, 0x0D, 0x77, 0x77, 0x40, 0x4F, 0xFC, 0x05, 0x77, 0x77, 0x50, 0xDF,
  0xFA, 0x08, 0x77, 0x77, 0x60, 0x4F, 0xF9, 0x0A, 0x80, 0xC0, 0x00, 0x7F, 0xE0, 0x88, 0x0C, 0x20,
  0x05, 0x0E, 0xFA, 0x0C, 0x04, 0x80, 0xC5, 0x08, 0x76, 0xAD, 0xEF, 0xDC, 0x84, 0x80, 0xAC, 0x00,
  0x84, 0x6B, 0xEF, 0xD5, 0x80, 0xD0, 0x00, 0x40, 0xDE, 0x05, 0x80, 0xC6, 0x00, 0x5F, 0x90, 0xC7,
  0x77, 0x58, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xA6, 0x14, 0x06, 0xFB, 0x77, 0x72, 0x81, 0x18, 0xEF,
  0xC0, 0x92, 0x04, 0xFB, 0x0E, 0x77, 0x71, 0x07, 0xFF, 0x98, 0x1C, 0x3E, 0xFB, 0x0C, 0x77, 0x60,
  0x20, 0xCF, 0xFF, 0x82, 0x92, 0x19, 0xC0, 0x77, 0x75, 0x03, 0x0E, 0xE8, 0x4E, 0xA7, 0x68, 0xDF,
  0xA0, 0x54, 0x0E, 0xA0, 0xE0, 0x17, 0x74, 0x03, 0x0E, 0xE0, 0x90, 0x15, 0x08, 0xF0, 0x85, 0x82,
  0xBF, 0xE4, 0x77, 0x40, 0x20, 0xEE, 0x07, 0x71, 0x0A, 0xE0, 0xE5, 0x00, 0x47, 0x76, 0x0C, 0xE0,
  0x87, 0x20, 0x3F, 0x04, 0x77, 0x74, 0x07, 0xE0, 0xC7, 0x40, 0xEE, 0x08, 0x77, 0x73, 0x02, 0xF0,
  0x37, 0x40, 0xCE, 0x0B, 0x77, 0x73, 0x0A, 0xE0, 0xA7, 0x50, 0xBE, 0x0C, 0x77, 0x72, 0x02, 0xF0,
  0x37, 0x50, 0xBE, 0x0D, 0x77, 0x72, 0x09, 0xE0, 0xD7, 0x60, 0xBE, 0x0D, 0x77, 0x72, 0x0E, 0xE0,
  0x77, 0x60, 0xCE, 0x0C, 0x77, 0x71, 0x04, 0xF0, 0x37, 0x60, 0xEE, 0x0A, 0x77, 0x71, 0x08, 0xE0,
  0xE7, 0x60, 0x2F, 0x07, 0x77, 0x71, 0x0C, 0xE0, 0xB7, 0x60, 0x4F, 0x04, 0x77, 0x71, 0xF0, 0x87,
  0x60, 0x8F, 0x77, 0x71, 0x01, 0xF0, 0x67, 0x60, 0xCE, 0x0B, 0x77, 0x71, 0x03, 0xF0, 0x47, 0x50,
  0x1F, 0x06, 0x77, 0x71, 0x03, 0xF0, 0x37, 0x50, 0x7F, 0x01, 0x77, 0x71, 0x03, 0xF0, 0x37, 0x50,
  0xDE, 0x09, 0x77, 0x72, 0x02, 0xF0, 0x47, 0x40, 0x6F, 0x02, 0x77, 0x73, 0xF0, 0x67, 0x30, 0x10,
  0xEE, 0x08, 0x77, 0x74, 0x0D, 0xE0, 0x97, 0x30, 0x9E, 0x0D, 0x77, 0x75, 0x08, 0xE0, 0xE0, 0x17,
  0x10, 0x8F, 0x03, 0x77, 0x75, 0x02, 0xF0, 0xA7, 0x08, 0xF0, 0x67, 0x77, 0x70, 0xAF, 0x85, 0xB4,
  0x10, 0x26, 0xCF, 0x07, 0x77, 0x77, 0x10, 0x10, 0xDF, 0xFD, 0x06, 0x77, 0x77, 0x30, 0x20, 0xDF,
  0xFA, 0x0D, 0x03, 0x77, 0x77, 0x50, 0x10, 0xAF, 0xE0, 0xE0, 0x77, 0x77, 0x77, 0x02, 0x0B, 0xFC,
  0x0B, 0x06, 0x80, 0xC0, 0x00, 0x8C, 0x86, 0xD6, 0x45, 0x65, 0x42, 0x80, 0xC1, 0x00, 0x20, 0xCC,
  0x08, 0x80, 0xD0, 0x00, 0x30, 0xEB, 0x0E, 0x03, 0x80, 0xD0, 0x00, 0x20, 0xEB, 0x0E, 0x02, 0x80,
  0xD1, 0x00, 0xCC, 0x08, 0x80, 0xD1, 0x00, 0x5D, 0x04, 0x80, 0xD1, 0x00, 0x9D, 0x05, 0x80, 0xD1,
  0x00, 0xCD, 0x0C, 0x01, 0x80, 0xD0, 0x00, 0xDE, 0x83, 0xE9, 0x63, 0x28, 0x0C, 0x40, 0x0C, 0xFD,
  0x85, 0xEC, 0xB9, 0x75, 0x27, 0x77, 0x74, 0x08, 0xFF, 0xD8, 0x1E, 0x94, 0x77, 0x77, 0x10, 0x10,
  0xEF, 0xFF, 0x0C, 0x04, 0x77, 0x77, 0x04, 0xFF, 0xFA, 0x09, 0x77, 0x77, 0x04, 0x0E, 0xFF, 0xF9,
  0x0B, 0x77, 0x75, 0x81, 0x37, 0xDF, 0xFF, 0xA0, 0x87, 0x77, 0x20, 0x60, 0xDF, 0xFF, 0xE0, 0x27,
  0x76, 0x06, 0x0E, 0xD8, 0x91, 0xEA, 0x74, 0x45, 0x78, 0xAC, 0xDF, 0xE0, 0x97, 0x74, 0x02, 0x0C,
  0xD0, 0xD0, 0x67, 0x58, 0x12, 0x6B, 0xFA, 0x0D, 0x77, 0x30, 0x40, 0xED, 0x09, 0x77, 0x30, 0x40,
  0xEF, 0x90, 0x27, 0x71, 0x03, 0x0E, 0xD0, 0x77, 0x75, 0x02, 0x0E, 0xF0, 0x37, 0x70, 0x10, 0xED,
  0x08, 0x77, 0x70, 0x8F, 0x05, 0x77, 0x0B, 0xD0, 0xD7, 0x77, 0x10, 0x2F, 0x05, 0x76, 0x03, 0xE0,
  0x57, 0x77, 0x2F, 0x04, 0x76, 0x0A, 0xE7, 0x77, 0x30, 0xEE, 0x03, 0x76, 0x0E, 0xD0, 0xB7, 0x77,
  0x3F, 0x76, 0x02, 0xE0, 0x97, 0x77, 0x20, 0x2E, 0x0D, 0x76, 0x04, 0xE0, 0x87, 0x77, 0x20, 0x5E,
  0x08, 0x76, 0x04, 0xE0, 0x97, 0x77, 0x20, 0xAE, 0x03, 0x76, 0x04, 0xE0, 0xA7, 0x77, 0x10, 0x2E,
  0x0C, 0x77, 0x02, 0xE0, 0xE7, 0x77, 0x10, 0xAE, 0x04, 0x77, 0x10, 0xEE, 0x06, 0x77, 0x60, 0x7E,
  0x0B, 0x77, 0x20, 0x9E, 0x0E, 0x01, 0x77, 0x40, 0x7E, 0x0E, 0x01, 0x77, 0x20, 0x3F, 0x0C, 0x02,
  0x77, 0x10, 0x20, 0xBF, 0x04, 0x77, 0x40, 0x9F, 0x81, 0xE8, 0x27, 0x40, 0x40, 0xAF, 0x90, 0x47,
  0x76, 0x0B, 0xFA, 0x89, 0x0D, 0xA8, 0x76, 0x67, 0x8A, 0xCF, 0xA0, 0xD0, 0x27, 0x77, 0x10, 0xAF,
  0xFF, 0xD0, 0x90, 0x17, 0x77, 0x30, 0x60, 0xEF, 0xFF, 0x90, 0xA0, 0x27, 0x77, 0x70, 0x60, 0xCF,
  0xFB, 0x81, 0xC8, 0x17, 0x77, 0x74, 0x85, 0x15, 0x8A, 0xCD, 0xEA, 0x86, 0xEE, 0xDC, 0xA7, 0x51,
  0x77, 0x75,
  // "Ġ" (U+0120)
  0x77, 0x77, 0x78, 0x44, 0xBE, 0xFD, 0x78, 0x0D, 0x10, 0x07, 0xE0, 0xC8, 0x0C, 0x70, 0x04, 0xF9,
  0x07, 0x80, 0xC6, 0x00, 0xAF, 0x90, 0xA8, 0x0C, 0x60, 0x0E, 0xF9, 0x0B, 0x80, 0xC6, 0x0F, 0xA0,
  0xA8, 0x0C, 0x60, 0x0E, 0xF9, 0x07, 0x80, 0xC6, 0x00, 0xBF, 0x90, 0x18, 0x0C, 0x60, 0x03, 0x0E,
  0xE0, 0x58, 0x0D, 0x00, 0x85, 0x2A, 0xEF, 0xD9, 0x28, 0x0F, 0x83, 0x08, 0x52, 0x58, 0xBC, 0xDE,
  0xA8, 0x5E, 0xDC, 0xB9, 0x62, 0x77, 0x77, 0x58, 0x14, 0x9D, 0xFF, 0xA8, 0x1D, 0x82, 0x77, 0x76,
  0x81, 0x17, 0xDF, 0xFF, 0x90, 0x90, 0x17, 0x77, 0x30, 0x80, 0xEF, 0xFF, 0xC0, 0xD0, 0x27, 0x77,
  0x05, 0x0E, 0xFA, 0x86, 0xD9, 0x86, 0x78, 0xAE, 0xFC, 0x0E, 0x02, 0x77, 0x40, 0x10, 0xBF, 0x98,
  0x1E, 0x82, 0x71, 0x05, 0x0D, 0xFB, 0x0D, 0x77, 0x30, 0x40, 0xEF, 0x90, 0x77, 0x60, 0xBF, 0xB0,
  0x67, 0x71, 0x07, 0xF9, 0x0C, 0x02, 0x77, 0x10, 0xCF, 0xA0, 0xC7, 0x70, 0x8F, 0x90, 0xA7, 0x73,
  0x04, 0xFB, 0x76, 0x09, 0xF9, 0x09, 0x77, 0x50, 0xBF, 0xA7, 0x50, 0x8F, 0x90, 0x97, 0x76, 0x06,
  0xF9, 0x0E, 0x74, 0x06, 0xF9, 0x0A, 0x77, 0x70, 0x1F, 0x90, 0xA7, 0x30, 0x4F, 0x90, 0xD7, 0x77,
  0x20, 0xDF, 0x04, 0x72, 0x01, 0x0E, 0xF0, 0xE0, 0x27, 0x77, 0x20, 0xBE, 0x09, 0x73, 0x0B, 0xF9,
  0x06, 0x77, 0x73, 0x09, 0xD0, 0x77, 0x30, 0x7F, 0x90, 0xB7, 0x77, 0x40, 0x9A, 0x81, 0xD8, 0x17,
  0x30, 0x10, 0xEF, 0x90, 0x27, 0x77, 0x48, 0x12, 0x21, 0x76, 0x0A, 0xF9, 0x08, 0x80, 0xC5, 0x00,
  0x3F, 0x90, 0xE0, 0x18, 0x0C, 0x50, 0x0C, 0xF9, 0x08, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0x18, 0x0C,
  0x50, 0x0B, 0xF9, 0x09, 0x80, 0xC5, 0x00, 0x2F, 0xA0, 0x28, 0x0C, 0x50, 0x09, 0xF9, 0x0C, 0x80,
  0xC6, 0x00, 0xEF, 0x90, 0x68, 0x0C, 0x50, 0x05, 0xFA, 0x01, 0x80, 0xC5, 0x00, 0xAF, 0x90, 0xB8,
  0x0C, 0x60, 0x0E, 0xF9, 0x06, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0x28, 0x0C, 0x50, 0x08, 0xF9, 0x0D,
  0x80, 0xC6, 0x00, 0xCF, 0x90, 0x98, 0x0C, 0x60, 0xFA, 0x06, 0x80, 0xC5, 0x00, 0x3F, 0xA0, 0x28,
  0x0C, 0x50, 0x06, 0xFA, 0x80, 0xC6, 0x00, 0x9F, 0x90, 0xC8, 0x0C, 0x60, 0x0B, 0xF9, 0x0A, 0x77,
  0x50, 0xCF, 0xFE, 0x81, 0xA0, 0xCF, 0x90, 0x77, 0x75, 0xFF, 0xF8, 0x17, 0x0E, 0xF9, 0x05, 0x77,
  0x40, 0x3F, 0xFF, 0x04, 0x1F, 0xA0, 0x47, 0x74, 0x06, 0xFF, 0xF0, 0x01, 0xFA, 0x03, 0x77, 0x68,
  0x21, 0x37, 0xCF, 0xD8, 0x1A, 0x41, 0x20, 0x2F, 0xA0, 0x17, 0x77, 0x30, 0xCF, 0xA0, 0xE0, 0x35,
  0x02, 0xFA, 0x77, 0x74, 0x07, 0xFA, 0x04, 0x60, 0x3F, 0xA7, 0x77, 0x40, 0x5F, 0x90, 0xB7, 0x03,
  0xFA, 0x77, 0x74, 0x05, 0xF9, 0x05, 0x70, 0x3F, 0x90, 0xE7, 0x77, 0x40, 0x7F, 0x90, 0x17, 0x02,
  0xFA, 0x77, 0x74, 0x0A, 0xF0, 0xC7, 0x10, 0x1F, 0xA7, 0x77, 0x40, 0xDF, 0x09, 0x72, 0x0E, 0xF9,
  0x01, 0x77, 0x72, 0x01, 0xF9, 0x06, 0x72, 0x0C, 0xF9, 0x02, 0x77, 0x72, 0x05, 0xF9, 0x02, 0x72,
  0x09, 0xF9, 0x05, 0x77, 0x72, 0x08, 0xF0, 0xE7, 0x30, 0x6F, 0x90, 0x87, 0x77, 0x20, 0xBF, 0x0B,
  0x73, 0x02, 0xF9, 0x0B, 0x77, 0x72, 0x0E, 0xF0, 0x87, 0x40, 0xDF, 0x90, 0x17, 0x77, 0x02, 0xF9,
  0x05, 0x74, 0x07, 0xF9, 0x06, 0x77, 0x70, 0x5F, 0x90, 0x27, 0x40, 0x1F, 0x90, 0xB7, 0x77, 0x09,
  0xF0, 0xE7, 0x60, 0x9F, 0x90, 0x47, 0x76, 0x0C, 0xF0, 0xB7, 0x60, 0x2F, 0x90, 0xC7, 0x76, 0xF9,
  0x07, 0x77, 0x07, 0xF9, 0x08, 0x77, 0x40, 0x3F, 0x90, 0x47, 0x71, 0x0C, 0xF9, 0x06, 0x77, 0x30,
  0x6F, 0x90, 0x17, 0x71, 0x01, 0x0E, 0xF9, 0x09, 0x77, 0x10, 0x60, 0xEF, 0x0D, 0x77, 0x30, 0x20,
  0xEF, 0x98, 0x1E, 0x71, 0x72, 0x81, 0x28, 0xDF, 0xA0, 0xA7, 0x74, 0x02, 0x0D, 0xFB, 0x87, 0xDA,
  0x76, 0x67, 0x8B, 0xEF, 0xD0, 0x67, 0x76, 0x0A, 0xFF, 0xFF, 0x0A, 0x03, 0x77, 0x71, 0x04, 0x0C,
  0xFF, 0xFA, 0x81, 0xC7, 0x17, 0x77, 0x58, 0x13, 0x9E, 0xFF, 0xB8, 0x1B, 0x72, 0x77, 0x77, 0x48,
  0x43, 0x69, 0xBD, 0xEB, 0x85, 0xED, 0xCA, 0x86, 0x37, 0x77,
  // "ġ" (U+0121)
  0x77, 0x77, 0x48, 0x44, 0xBE, 0xFD, 0x78, 0x0D, 0x10, 0x07, 0xE0, 0xC8, 0x0C, 0x70, 0x04, 0xF9,
  0x07, 0x80, 0xC6, 0x00, 0xAF, 0x90, 0xA8, 0x0C, 0x60, 0x0E, 0xF9, 0x0B, 0x80, 0xC6, 0x0F, 0xA0,
  0xA8, 0x0C, 0x60, 0x0E, 0xF9, 0x07, 0x80, 0xC6, 0x00, 0xBF, 0x90, 0x18, 0x0C, 0x60, 0x03, 0x0E,
  0xE0, 0x58, 0x0D, 0x00, 0x85, 0x2A, 0xEF, 0xD9, 0x28, 0x0D, 0xD7, 0x08, 0x46, 0xBE, 0xFD, 0x58,
  0x0D, 0x00, 0x04, 0x0D, 0xE0, 0x58, 0x0C, 0x60, 0x05, 0xF9, 0x0C, 0x77, 0x75, 0x89, 0x14, 0x8B,
  0xDE, 0xFE, 0xDA, 0x61, 0x40, 0x6F, 0xB7, 0x77, 0x28, 0x11, 0x8E, 0xFC, 0x09, 0x20, 0x4F, 0xB0,
  0xE7, 0x77, 0x10, 0x7F, 0xF9, 0x81, 0xC3, 0xEF, 0xB0, 0xC7, 0x76, 0x02, 0x0C, 0xFF, 0xF8, 0x29,
  0x21, 0x9C, 0x07, 0x77, 0x50, 0x30, 0xEE, 0x84, 0xEA, 0x76, 0x8D, 0xFA, 0x05, 0x40, 0xEA, 0x0E,
  0x01, 0x77, 0x40, 0x30, 0xEE, 0x09, 0x01, 0x50, 0x8F, 0x08, 0x58, 0x2B, 0xFE, 0x47, 0x74, 0x02,
  0x0E, 0xE0, 0x77, 0x10, 0xAE, 0x0E, 0x50, 0x04, 0x77, 0x60, 0xCE, 0x08, 0x72, 0x03, 0xF0, 0x47,
  0x77, 0x40, 0x7E, 0x0C, 0x74, 0x0E, 0xE0, 0x87, 0x77, 0x30, 0x2F, 0x03, 0x74, 0x0C, 0xE0, 0xB7,
  0x77, 0x30, 0xAE, 0x0A, 0x75, 0x0B, 0xE0, 0xC7, 0x77, 0x20, 0x2F, 0x03, 0x75, 0x0B, 0xE0, 0xD7,
  0x77, 0x20, 0x9E, 0x0D, 0x76, 0x0B, 0xE0, 0xD7, 0x77, 0x20, 0xEE, 0x07, 0x76, 0x0C, 0xE0, 0xC7,
  0x77, 0x10, 0x4F, 0x03, 0x76, 0x0E, 0xE0, 0xA7, 0x77, 0x10, 0x8E, 0x0E, 0x76, 0x02, 0xF0, 0x77,
  0x77, 0x10, 0xCE, 0x0B, 0x76, 0x04, 0xF0, 0x47, 0x77, 0x1F, 0x08, 0x76, 0x08, 0xF7, 0x77, 0x10,
  0x1F, 0x06, 0x76, 0x0C, 0xE0, 0xB7, 0x77, 0x10, 0x3F, 0x04, 0x75, 0x01, 0xF0, 0x67, 0x77, 0x10,
  0x3F, 0x03, 0x75, 0x07, 0xF0, 0x17, 0x77, 0x10, 0x3F, 0x03, 0x75, 0x0D, 0xE0, 0x97, 0x77, 0x20,
  0x2F, 0x04, 0x74, 0x06, 0xF0, 0x27, 0x77, 0x3F, 0x06, 0x73, 0x01, 0x0E, 0xE0, 0x87, 0x77, 0x40,
  0xDE, 0x09, 0x73, 0x09, 0xE0, 0xD7, 0x77, 0x50, 0x8E, 0x0E, 0x01, 0x71, 0x08, 0xF0, 0x37, 0x77,
  0x50, 0x2F, 0x0A, 0x70, 0x8F, 0x06, 0x77, 0x77, 0x0A, 0xF8, 0x5B, 0x41, 0x02, 0x6C, 0xF0, 0x77,
  0x77, 0x71, 0x01, 0x0D, 0xFF, 0xD0, 0x67, 0x77, 0x73, 0x02, 0x0D, 0xFF, 0xA0, 0xD0, 0x37, 0x77,
  0x75, 0x01, 0x0A, 0xFE, 0x0E, 0x07, 0x77, 0x77, 0x70, 0x20, 0xBF, 0xC0, 0xB0, 0x68, 0x0C, 0x00,
  0x08, 0xC8, 0x6D, 0x64, 0x56, 0x54, 0x28, 0x0C, 0x10, 0x02, 0x0C, 0xC0, 0x88, 0x0D, 0x00, 0x03,
  0x0E, 0xB0, 0xE0, 0x38, 0x0D, 0x00, 0x02, 0x0E, 0xB0, 0xE0, 0x28, 0x0D, 0x10, 0x0C, 0xC0, 0x88,
  0x0D, 0x10, 0x05, 0xD0, 0x48, 0x0D, 0x10, 0x09, 0xD0, 0x58, 0x0D, 0x10, 0x0C, 0xD0, 0xC0, 0x18,
  0x0D, 0x00, 0x0D, 0xE8, 0x3E, 0x96, 0x32, 0x80, 0xC4, 0x00, 0xCF, 0xD8, 0x5E, 0xCB, 0x97, 0x52,
  0x77, 0x77, 0x40, 0x8F, 0xFD, 0x81, 0xE9, 0x47, 0x77, 0x71, 0x01, 0x0E, 0xFF, 0xF0, 0xC0, 0x47,
  0x77, 0x70, 0x4F, 0xFF, 0xA0, 0x97, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0x90, 0xB7, 0x77, 0x58, 0x13,
  0x7D, 0xFF, 0xFA, 0x08, 0x77, 0x72, 0x06, 0x0D, 0xFF, 0xFE, 0x02, 0x77, 0x60, 0x60, 0xED, 0x89,
  0x1E, 0xA7, 0x44, 0x57, 0x8A, 0xCD, 0xFE, 0x09, 0x77, 0x40, 0x20, 0xCD, 0x0D, 0x06, 0x75, 0x81,
  0x26, 0xBF, 0xA0, 0xD7, 0x73, 0x04, 0x0E, 0xD0, 0x97, 0x73, 0x04, 0x0E, 0xF9, 0x02, 0x77, 0x10,
  0x30, 0xED, 0x07, 0x77, 0x50, 0x20, 0xEF, 0x03, 0x77, 0x01, 0x0E, 0xD0, 0x87, 0x77, 0x08, 0xF0,
  0x57, 0x70, 0xBD, 0x0D, 0x77, 0x71, 0x02, 0xF0, 0x57, 0x60, 0x3E, 0x05, 0x77, 0x72, 0xF0, 0x47,
  0x60, 0xAE, 0x77, 0x73, 0x0E, 0xE0, 0x37, 0x60, 0xED, 0x0B, 0x77, 0x73, 0xF7, 0x60, 0x2E, 0x09,
  0x77, 0x72, 0x02, 0xE0, 0xD7, 0x60, 0x4E, 0x08, 0x77, 0x72, 0x05, 0xE0, 0x87, 0x60, 0x4E, 0x09,
  0x77, 0x72, 0x0A, 0xE0, 0x37, 0x60, 0x4E, 0x0A, 0x77, 0x71, 0x02, 0xE0, 0xC7, 0x70, 0x2E, 0x0E,
  0x77, 0x71, 0x0A, 0xE0, 0x47, 0x71, 0x0E, 0xE0, 0x67, 0x76, 0x07, 0xE0, 0xB7, 0x72, 0x09, 0xE0,
  0xE0, 0x17, 0x74, 0x07, 0xE0, 0xE0, 0x17, 0x72, 0x03, 0xF0, 0xC0, 0x27, 0x71, 0x02, 0x0B, 0xF0,
  0x47, 0x74, 0x09, 0xF8, 0x1E, 0x82, 0x74, 0x04, 0x0A, 0xF9, 0x04, 0x77, 0x60, 0xBF, 0xA8, 0x90,
  0xDA, 0x87, 0x66, 0x78, 0xAC, 0xFA, 0x0D, 0x02, 0x77, 0x71, 0x0A, 0xFF, 0xFD, 0x09, 0x01, 0x77,
  0x73, 0x06, 0x0E, 0xFF, 0xF9, 0x0A, 0x02, 0x77, 0x77, 0x06, 0x0C, 0xFF, 0xB8, 0x1C, 0x81, 0x77,
  0x77, 0x48, 0x51, 0x58, 0xAC, 0xDE, 0xA8, 0x6E, 0xED, 0xCA, 0x75, 0x17, 0x77, 0x50,
  // "Ģ" (U+0122)
  0x77, 0x77, 0x85, 0x25, 0x8B, 0xCD, 0xEA, 0x85, 0xED, 0xCB, 0x96, 0x27, 0x77, 0x75, 0x81, 0x49,
  0xDF, 0xFA, 0x81, 0xD8, 0x27, 0x77, 0x68, 0x11, 0x7D, 0xFF, 0xF9, 0x09, 0x01, 0x77, 0x73, 0x08,
  0x0E, 0xFF, 0xFC, 0x0D, 0x02, 0x77, 0x70, 0x50, 0xEF, 0xA8, 0x6D, 0x98, 0x67, 0x8A, 0xEF, 0xC0,
  0xE0, 0x27, 0x74, 0x01, 0x0B, 0xF9, 0x81, 0xE8, 0x27, 0x10, 0x50, 0xDF, 0xB0, 0xD7, 0x73, 0x04,
  0x0E, 0xF9, 0x07, 0x76, 0x0B, 0xFB, 0x06, 0x77, 0x10, 0x7F, 0x90, 0xC0, 0x27, 0x71, 0x0C, 0xFA,
  0x0C, 0x77, 0x08, 0xF9, 0x0A, 0x77, 0x30, 0x4F, 0xB7, 0x60, 0x9F, 0x90, 0x97, 0x75, 0x0B, 0xFA,
  0x75, 0x08, 0xF9, 0x09, 0x77, 0x60, 0x6F, 0x90, 0xE7, 0x40, 0x6F, 0x90, 0xA7, 0x77, 0x01, 0xF9,
  0x0A, 0x73, 0x04, 0xF9, 0x0D, 0x77, 0x72, 0x0D, 0xF0, 0x47, 0x20, 0x10, 0xEF, 0x0E, 0x02, 0x77,
  0x72, 0x0B, 0xE0, 0x97, 0x30, 0xBF, 0x90, 0x67, 0x77, 0x30, 0x9D, 0x07, 0x73, 0x07, 0xF9, 0x0B,
  0x77, 0x74, 0x09, 0xA8, 0x1D, 0x81, 0x73, 0x01, 0x0E, 0xF9, 0x02, 0x77, 0x74, 0x81, 0x22, 0x17,
  0x60, 0xAF, 0x90, 0x88, 0x0C, 0x50, 0x03, 0xF9, 0x0E, 0x01, 0x80, 0xC5, 0x00, 0xCF, 0x90, 0x88,
  0x0C, 0x50, 0x03, 0xFA, 0x01, 0x80, 0xC5, 0x00, 0xBF, 0x90, 0x98, 0x0C, 0x50, 0x02, 0xFA, 0x02,
  0x80, 0xC5, 0x00, 0x9F, 0x90, 0xC8, 0x0C, 0x60, 0x0E, 0xF9, 0x06, 0x80, 0xC5, 0x00, 0x5F, 0xA0,
  0x18, 0x0C, 0x50, 0x0A, 0xF9, 0x0B, 0x80, 0xC6, 0x00, 0xEF, 0x90, 0x68, 0x0C, 0x50, 0x03, 0xFA,
  0x02, 0x80, 0xC5, 0x00, 0x8F, 0x90, 0xD8, 0x0C, 0x60, 0x0C, 0xF9, 0x09, 0x80, 0xC6, 0x0F, 0xA0,
  0x68, 0x0C, 0x50, 0x03, 0xFA, 0x02, 0x80, 0xC5, 0x00, 0x6F, 0xA8, 0x0C, 0x60, 0x09, 0xF9, 0x0C,
  0x80, 0xC6, 0x00, 0xBF, 0x90, 0xA7, 0x75, 0x0C, 0xFF, 0xE8, 0x1A, 0x0C, 0xF9, 0x07, 0x77, 0x5F,
  0xFF, 0x81, 0x70, 0xEF, 0x90, 0x57, 0x74, 0x03, 0xFF, 0xF0, 0x41, 0xFA, 0x04, 0x77, 0x40, 0x6F,
  0xFF, 0x00, 0x1F, 0xA0, 0x37, 0x76, 0x82, 0x13, 0x7C, 0xFD, 0x81, 0xA4, 0x12, 0x02, 0xFA, 0x01,
  0x77, 0x73, 0x0C, 0xFA, 0x0E, 0x03, 0x50, 0x2F, 0xA7, 0x77, 0x40, 0x7F, 0xA0, 0x46, 0x03, 0xFA,
  0x77, 0x74, 0x05, 0xF9, 0x0B, 0x70, 0x3F, 0xA7, 0x77, 0x40, 0x5F, 0x90, 0x57, 0x03, 0xF9, 0x0E,
  0x77, 0x74, 0x07, 0xF9, 0x01, 0x70, 0x2F, 0xA7, 0x77, 0x40, 0xAF, 0x0C, 0x71, 0x01, 0xFA, 0x77,
  0x74, 0x0D, 0xF0, 0x97, 0x20, 0xEF, 0x90, 0x17, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x20, 0xCF, 0x90,
  0x27, 0x77, 0x20, 0x5F, 0x90, 0x27, 0x20, 0x9F, 0x90, 0x57, 0x77, 0x20, 0x8F, 0x0E, 0x73, 0x06,
  0xF9, 0x08, 0x77, 0x72, 0x0B, 0xF0, 0xB7, 0x30, 0x2F, 0x90, 0xB7, 0x77, 0x20, 0xEF, 0x08, 0x74,
  0x0D, 0xF9, 0x01, 0x77, 0x70, 0x2F, 0x90, 0x57, 0x40, 0x7F, 0x90, 0x67, 0x77, 0x05, 0xF9, 0x02,
  0x74, 0x01, 0xF9, 0x0B, 0x77, 0x70, 0x9F, 0x0E, 0x76, 0x09, 0xF9, 0x04, 0x77, 0x60, 0xCF, 0x0B,
  0x76, 0x02, 0xF9, 0x0C, 0x77, 0x6F, 0x90, 0x77, 0x70, 0x7F, 0x90, 0x87, 0x74, 0x03, 0xF9, 0x04,
  0x77, 0x10, 0xCF, 0x90, 0x67, 0x73, 0x06, 0xF9, 0x01, 0x77, 0x10, 0x10, 0xEF, 0x90, 0x97, 0x71,
  0x06, 0x0E, 0xF0, 0xD7, 0x73, 0x02, 0x0E, 0xF9, 0x81, 0xE7, 0x17, 0x28, 0x12, 0x8D, 0xFA, 0x0A,
  0x77, 0x40, 0x20, 0xDF, 0xB8, 0x7D, 0xA7, 0x66, 0x78, 0xBE, 0xFD, 0x06, 0x77, 0x60, 0xAF, 0xFF,
  0xF0, 0xA0, 0x37, 0x77, 0x10, 0x40, 0xCF, 0xFF, 0xA8, 0x1C, 0x71, 0x77, 0x75, 0x81, 0x39, 0xEF,
  0xFB, 0x81, 0xB7, 0x27, 0x77, 0x74, 0x84, 0x36, 0x9B, 0xDE, 0xB8, 0x5E, 0xDC, 0xA8, 0x63, 0x80,
  0xBE, 0x10, 0x02, 0x80, 0x37, 0x80, 0xD0, 0x00, 0x8E, 0x0D, 0x80, 0xD0, 0x00, 0xDE, 0x05, 0x80,
  0xC7, 0x00, 0x3E, 0x0C, 0x80, 0xD0, 0x00, 0x9E, 0x03, 0x80, 0xD0, 0x00, 0xED, 0x09, 0x80, 0xD0,
  0x00, 0x4D, 0x0D, 0x80, 0xD1, 0x00, 0xAD, 0x03, 0x80, 0xD0, 0x00, 0x1D, 0x08, 0x80, 0xD1, 0x00,
  0x6C, 0x0D, 0x80, 0xD2, 0x00, 0xCC, 0x03, 0x80, 0xD1, 0x00, 0x2C, 0x06, 0x80, 0xD2, 0x00, 0x9B,
  0x0A, 0x80, 0xD3, 0x00, 0xEA, 0x0D, 0x01, 0x80, 0xD2, 0x00, 0x4A, 0x0E, 0x02, 0x80, 0xC0, 0x00,
  // "ģ" (U+0123)
  0x80, 0xC2, 0x00, 0xBA, 0x0B, 0x80, 0xD3, 0x00, 0x9B, 0x06, 0x80, 0xD2, 0x00, 0x6B, 0x0E, 0x80,
  0xD2, 0x00, 0x3C, 0x09, 0x80, 0xD2, 0x00, 0xDC, 0x03, 0x80, 0xD1, 0x00, 0x9C, 0x0C, 0x80, 0xD1,
  0x00, 0x5D, 0x06, 0x80, 0xD0, 0x00, 0x10, 0xEC, 0x0E, 0x80, 0xD1, 0x00, 0xBD, 0x0A, 0x80, 0xD0,
  0x00, 0x6E, 0x04, 0x80, 0xC7, 0x00, 0x20, 0xED, 0x0E, 0x80, 0xD0, 0x00, 0xBE, 0x09, 0x80, 0xC7,
  0x00, 0x5F, 0x03, 0x80, 0xC7, 0x00, 0xDE, 0x0D, 0x80, 0xD0, 0x08, 0x04, 0x18, 0x09, 0xD4, 0x08,
  0x46, 0xBE, 0xFD, 0x58, 0x0D, 0x00, 0x04, 0x0D, 0xE0, 0x58, 0x0C, 0x60, 0x05, 0xF9, 0x0C, 0x77,
  0x75, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDA, 0x61, 0x40, 0x6F, 0xB7, 0x77, 0x28, 0x11, 0x8E, 0xFC,
  0x09, 0x20, 0x4F, 0xB0, 0xE7, 0x77, 0x10, 0x7F, 0xF9, 0x81, 0xC3, 0xEF, 0xB0, 0xC7, 0x76, 0x02,
  0x0C, 0xFF, 0xF8, 0x29, 0x21, 0x9C, 0x07, 0x77, 0x50, 0x30, 0xEE, 0x84, 0xEA, 0x76, 0x8D, 0xFA,
  0x05, 0x40, 0xEA, 0x0E, 0x01, 0x77, 0x40, 0x30, 0xEE, 0x09, 0x01, 0x50, 0x8F, 0x08, 0x58, 0x2B,
  0xFE, 0x47, 0x74, 0x02, 0x0E, 0xE0, 0x77, 0x10, 0xAE, 0x0E, 0x50, 0x04, 0x77, 0x60, 0xCE, 0x08,
  0x72, 0x03, 0xF0, 0x47, 0x77, 0x40, 0x7E, 0x0C, 0x74, 0x0E, 0xE0, 0x87, 0x77, 0x30, 0x2F, 0x03,
  0x74, 0x0C, 0xE0, 0xB7, 0x77, 0x30, 0xAE, 0x0A, 0x75, 0x0B, 0xE0, 0xC7, 0x77, 0x20, 0x2F, 0x03,
  0x75, 0x0B, 0xE0, 0xD7, 0x77, 0x20, 0x9E, 0x0D, 0x76, 0x0B, 0xE0, 0xD7, 0x77, 0x20, 0xEE, 0x07,
  0x76, 0x0C, 0xE0, 0xC7, 0x77, 0x10, 0x4F, 0x03, 0x76, 0x0E, 0xE0, 0xA7, 0x77, 0x10, 0x8E, 0x0E,
  0x76, 0x02, 0xF0, 0x77, 0x77, 0x10, 0xCE, 0x0B, 0x76, 0x04, 0xF0, 0x47, 0x77, 0x1F, 0x08, 0x76,
  0x08, 0xF7, 0x77, 0x10, 0x1F, 0x06, 0x76, 0x0C, 0xE0, 0xB7, 0x77, 0x10, 0x3F, 0x04, 0x75, 0x01,
  0xF0, 0x67, 0x77, 0x10, 0x3F, 0x03, 0x75, 0x07, 0xF0, 0x17, 0x77, 0x10, 0x3F, 0x03, 0x75, 0x0D,
  0xE0, 0x97, 0x77, 0x20, 0x2F, 0x04, 0x74, 0x06, 0xF0, 0x27, 0x77, 0x3F, 0x06, 0x73, 0x01, 0x0E,
  0xE0, 0x87, 0x77, 0x40, 0xDE, 0x09, 0x73, 0x09, 0xE0, 0xD7, 0x77, 0x50, 0x8E, 0x0E, 0x01, 0x71,
  0x08, 0xF0, 0x37, 0x77, 0x50, 0x2F, 0x0A, 0x70, 0x8F, 0x06, 0x77, 0x77, 0x0A, 0xF8, 0x5B, 0x41,
  0x02, 0x6C, 0xF0, 0x77, 0x77, 0x71, 0x01, 0x0D, 0xFF, 0xD0, 0x67, 0x77, 0x73, 0x02, 0x0D, 0xFF,
  0xA0, 0xD0, 0x37, 0x77, 0x75, 0x01, 0x0A, 0xFE, 0x0E, 0x07, 0x77, 0x77, 0x70, 0x20, 0xBF, 0xC0,
  0xB0, 0x68, 0x0C, 0x00, 0x08, 0xC8, 0x6D, 0x64, 0x56, 0x54, 0x28, 0x0C, 0x10, 0x02, 0x0C, 0xC0,
  0x88, 0x0D, 0x00, 0x03, 0x0E, 0xB0, 0xE0, 0x38, 0x0D, 0x00, 0x02, 0x0E, 0xB0, 0xE0, 0x28, 0x0D,
  0x10, 0x0C, 0xC0, 0x88, 0x0D, 0x10, 0x05, 0xD0, 0x48, 0x0D, 0x10, 0x09, 0xD0, 0x58, 0x0D, 0x10,
  0x0C, 0xD0, 0xC0, 0x18, 0x0D, 0x00, 0x0D, 0xE8, 0x3E, 0x96, 0x32, 0x80, 0xC4, 0x00, 0xCF, 0xD8,
  0x5E, 0xCB, 0x97, 0x52, 0x77, 0x77, 0x40, 0x8F, 0xFD, 0x81, 0xE9, 0x47, 0x77, 0x71, 0x01, 0x0E,
  0xFF, 0xF0, 0xC0, 0x47, 0x77, 0x70, 0x4F, 0xFF, 0xA0, 0x97, 0x77, 0x70, 0x40, 0xEF, 0xFF, 0x90,
  0xB7, 0x77, 0x58, 0x13, 0x7D, 0xFF, 0xFA, 0x08, 0x77, 0x72, 0x06, 0x0D, 0xFF, 0xFE, 0x02, 0x77,
  0x60, 0x60, 0xED, 0x89, 0x1E, 0xA7, 0x44, 0x57, 0x8A, 0xCD, 0xFE, 0x09, 0x77, 0x40, 0x20, 0xCD,
  0x0D, 0x06, 0x75, 0x81, 0x26, 0xBF, 0xA0, 0xD7, 0x73, 0x04, 0x0E, 0xD0, 0x97, 0x73, 0x04, 0x0E,
  0xF9, 0x02, 0x77, 0x10, 0x30, 0xED, 0x07, 0x77, 0x50, 0x20, 0xEF, 0x03, 0x77, 0x01, 0x0E, 0xD0,
  0x87, 0x77, 0x08, 0xF0, 0x57, 0x70, 0xBD, 0x0D, 0x77, 0x71, 0x02, 0xF0, 0x57, 0x60, 0x3E, 0x05,
  0x77, 0x72, 0xF0, 0x47, 0x60, 0xAE, 0x77, 0x73, 0x0E, 0xE0, 0x37, 0x60, 0xED, 0x0B, 0x77, 0x73,
  0xF7, 0x60, 0x2E, 0x09, 0x77, 0x72, 0x02, 0xE0, 0xD7, 0x60, 0x4E, 0x08, 0x77, 0x72, 0x05, 0xE0,
  0x87, 0x60, 0x4E, 0x09, 0x77, 0x72, 0x0A, 0xE0, 0x37, 0x60, 0x4E, 0x0A, 0x77, 0x71, 0x02, 0xE0,
  0xC7, 0x70, 0x2E, 0x0E, 0x77, 0x71, 0x0A, 0xE0, 0x47, 0x71, 0x0E, 0xE0, 0x67, 0x76, 0x07, 0xE0,
  0xB7, 0x72, 0x09, 0xE0, 0xE0, 0x17, 0x74, 0x07, 0xE0, 0xE0, 0x17, 0x72, 0x03, 0xF0, 0xC0, 0x27,
  0x71, 0x02, 0x0B, 0xF0, 0x47, 0x74, 0x09, 0xF8, 0x1E, 0x82, 0x74, 0x04, 0x0A, 0xF9, 0x04, 0x77,
  0x60, 0xBF, 0xA8, 0x90, 0xDA, 0x87, 0x66, 0x78, 0xAC, 0xFA, 0x0D, 0x02, 0x77, 0x71, 0x0A, 0xFF,
  0xFD, 0x09, 0x01, 0x77, 0x73, 0x06, 0x0E, 0xFF, 0xF9, 0x0A, 0x02, 0x77, 0x77, 0x06, 0x0C, 0xFF,
  0xB8, 0x1C, 0x81, 0x77, 0x77, 0x48, 0x51, 0x58, 0xAC, 0xDE, 0xA8, 0x6E, 0xED, 0xCA, 0x75, 0x17,
  0x77, 0x50,
  // "Ĥ" (U+0124)
  0x80, 0xC6, 0x08, 0x04, 0x78, 0x0F, 0x10, 0x09, 0xF9, 0x03, 0x80, 0xE7, 0x00, 0x4F, 0xA0, 0x78,
  0x0E, 0x60, 0x01, 0x0E, 0xFA, 0x0B, 0x80, 0xE6, 0x00, 0xCF, 0xC0, 0x18, 0x0E, 0x40, 0x09, 0xFD,
  0x07, 0x80, 0xE3, 0x00, 0x6E, 0x0B, 0x0D, 0xD0, 0xC8, 0x0E, 0x20, 0x03, 0xE8, 0x1A, 0x04, 0xE0,
  0x28, 0x0E, 0x00, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x98, 0x0E, 0x00, 0x0C, 0xD0, 0x84, 0x01,
  0x0E, 0xC0, 0xE8, 0x0D, 0x70, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x78, 0x0D, 0x50, 0x09, 0xC0, 0xE0,
  0x57, 0x10, 0x9C, 0x0D, 0x80, 0xD4, 0x00, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x58, 0x0D, 0x20,
  0x05, 0xC0, 0xA0, 0x17, 0x40, 0x10, 0xCB, 0x0D, 0x80, 0xD2, 0x00, 0xCA, 0x0D, 0x04, 0x77, 0x01,
  0x0C, 0xA0, 0xD8, 0x0D, 0xE6, 0x00, 0x3F, 0xFF, 0x90, 0xE7, 0x20, 0x2F, 0xFF, 0x90, 0xE7, 0x60,
  0x6F, 0xFF, 0x90, 0xB7, 0x20, 0x5F, 0xFF, 0x90, 0xB7, 0x60, 0x9F, 0xFF, 0x90, 0x87, 0x20, 0x8F,
  0xFF, 0x90, 0x87, 0x60, 0xDF, 0xFF, 0x90, 0x47, 0x20, 0xBF, 0xFF, 0x90, 0x57, 0x71, 0x82, 0x13,
  0x7D, 0xFD, 0x81, 0xA5, 0x27, 0x78, 0x21, 0x37, 0xDF, 0xD8, 0x1A, 0x52, 0x77, 0x71, 0x0D, 0xFA,
  0x0D, 0x02, 0x77, 0x60, 0x10, 0xEF, 0xA0, 0xD0, 0x37, 0x77, 0x40, 0x7F, 0x90, 0xE0, 0x27, 0x77,
  0x10, 0x9F, 0x90, 0xE0, 0x27, 0x77, 0x50, 0x5F, 0x90, 0x87, 0x77, 0x20, 0x8F, 0x90, 0x77, 0x77,
  0x60, 0x7F, 0x90, 0x27, 0x77, 0x20, 0x9F, 0x90, 0x17, 0x77, 0x60, 0xAF, 0x0D, 0x77, 0x73, 0x0C,
  0xF0, 0xB7, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x73, 0xF9, 0x07, 0x77, 0x76, 0x01, 0xF9, 0x06, 0x77,
  0x72, 0x03, 0xF9, 0x04, 0x77, 0x76, 0x05, 0xF9, 0x02, 0x77, 0x72, 0x06, 0xF9, 0x01, 0x77, 0x76,
  0x08, 0xF0, 0xE7, 0x77, 0x30, 0xAF, 0x0D, 0x77, 0x77, 0x0B, 0xF0, 0xB7, 0x77, 0x30, 0xDF, 0x09,
  0x77, 0x77, 0x0E, 0xF0, 0x87, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x77, 0x60, 0x3F, 0x90, 0x47, 0x77,
  0x20, 0x4F, 0x90, 0x37, 0x77, 0x60, 0x6F, 0x90, 0x17, 0x77, 0x20, 0x8F, 0x97, 0x77, 0x70, 0x9F,
  0x0D, 0x77, 0x73, 0x0B, 0xF0, 0xC7, 0x77, 0x70, 0xCF, 0x0A, 0x77, 0x73, 0x0E, 0xF0, 0x87, 0x77,
  0x7F, 0x90, 0x67, 0x77, 0x20, 0x2F, 0x90, 0x57, 0x77, 0x60, 0x4F, 0x90, 0x37, 0x77, 0x20, 0x6F,
  0x90, 0x27, 0x77, 0x60, 0x7F, 0x97, 0x77, 0x30, 0x9F, 0x0E, 0x77, 0x77, 0x0A, 0xF0, 0xB7, 0x77,
  0x30, 0xDF, 0x0B, 0x77, 0x77, 0x0D, 0xF0, 0x87, 0x77, 0x20, 0x1F, 0x90, 0x77, 0x77, 0x60, 0x1F,
  0x90, 0x57, 0x77, 0x20, 0x4F, 0x90, 0x47, 0x77, 0x60, 0x5F, 0x90, 0x17, 0x77, 0x20, 0x7F, 0x90,
  0x17, 0x77, 0x60, 0x8F, 0x0D, 0x77, 0x73, 0x0B, 0xF0, 0xD7, 0x77, 0x70, 0xB8, 0x0C, 0x4F, 0x09,
  0x77, 0x77, 0x0E, 0x80, 0xC4, 0xF0, 0x67, 0x77, 0x60, 0x28, 0x0C, 0x5F, 0x03, 0x77, 0x76, 0x06,
  0x80, 0xC5, 0xF7, 0x77, 0x70, 0x9F, 0x0D, 0x80, 0xA4, 0x60, 0xEF, 0x0C, 0x77, 0x77, 0x0C, 0xF0,
  0x87, 0x77, 0x3F, 0x90, 0x87, 0x77, 0x7F, 0x90, 0x57, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x77, 0x60,
  0x3F, 0x90, 0x27, 0x77, 0x20, 0x7F, 0x90, 0x27, 0x77, 0x60, 0x7F, 0x0E, 0x77, 0x73, 0x0A, 0xF0,
  0xE7, 0x77, 0x70, 0xAF, 0x0B, 0x77, 0x73, 0x0D, 0xF0, 0xB7, 0x77, 0x70, 0xDF, 0x07, 0x77, 0x72,
  0x01, 0xF9, 0x07, 0x77, 0x76, 0x01, 0xF9, 0x04, 0x77, 0x72, 0x04, 0xF9, 0x04, 0x77, 0x76, 0x04,
  0xF9, 0x01, 0x77, 0x72, 0x08, 0xF9, 0x01, 0x77, 0x76, 0x08, 0xF0, 0xD7, 0x77, 0x30, 0xBF, 0x0D,
  0x77, 0x77, 0x0B, 0xF0, 0xA7, 0x77, 0x30, 0xEF, 0x0A, 0x77, 0x77, 0x0E, 0xF0, 0x77, 0x77, 0x20,
  0x2F, 0x90, 0x67, 0x77, 0x60, 0x2F, 0x90, 0x37, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x77, 0x60, 0x5F,
  0x97, 0x77, 0x30, 0x8F, 0x97, 0x77, 0x70, 0x9F, 0x0C, 0x77, 0x73, 0x0C, 0xF0, 0xC7, 0x77, 0x70,
  0xCF, 0x09, 0x77, 0x73, 0xF9, 0x09, 0x77, 0x77, 0xF9, 0x06, 0x77, 0x72, 0x03, 0xF9, 0x05, 0x77,
  0x76, 0x03, 0xF9, 0x02, 0x77, 0x72, 0x06, 0xF9, 0x02, 0x77, 0x76, 0x06, 0xF0, 0xE7, 0x77, 0x30,
  0x9F, 0x0E, 0x77, 0x77, 0x0A, 0xF0, 0xB7, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x77, 0x0D, 0xF0, 0x87,
  0x77, 0x3F, 0x90, 0x77, 0x77, 0x60, 0x1F, 0x90, 0x57, 0x77, 0x20, 0x3F, 0x90, 0x47, 0x77, 0x60,
  0x5F, 0x90, 0x27, 0x77, 0x20, 0x7F, 0x90, 0x17, 0x77, 0x60, 0xAF, 0x97, 0x77, 0x30, 0xCF, 0x0E,
  0x77, 0x76, 0x01, 0xF9, 0x0E, 0x77, 0x72, 0x02, 0xF9, 0x0C, 0x77, 0x76, 0x0A, 0xFA, 0x77, 0x72,
  0x0B, 0xF9, 0x0D, 0x77, 0x75, 0x09, 0xFB, 0x06, 0x77, 0x70, 0x9F, 0xB0, 0x37, 0x77, 0x82, 0x14,
  0x8E, 0xFD, 0x81, 0x95, 0x27, 0x78, 0x21, 0x48, 0xEF, 0xC8, 0x2E, 0x84, 0x17, 0x72, 0x0E, 0xFF,
  0xF9, 0x03, 0x72, 0x0E, 0xFF, 0xF9, 0x03, 0x75, 0x01, 0xFF, 0xF9, 0x0E, 0x72, 0x02, 0xFF, 0xFA,
  0x76, 0x05, 0xFF, 0xF9, 0x0B, 0x72, 0x06, 0xFF, 0xF9, 0x0C, 0x76, 0x08, 0xFF, 0xF9, 0x08, 0x72,
  0x09, 0xFF, 0xF9, 0x08, 0x76,
  // "ĥ" (U+0125)
  0x77, 0x77, 0x18, 0x04, 0x77, 0x77, 0x77, 0x09, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x4F, 0xA0, 0x77,
  0x77, 0x74, 0x01, 0x0E, 0xFA, 0x0B, 0x77, 0x77, 0x40, 0xCF, 0xC0, 0x17, 0x77, 0x72, 0x09, 0xFD,
  0x07, 0x77, 0x77, 0x10, 0x6E, 0x0B, 0x0D, 0xD0, 0xC7, 0x77, 0x70, 0x3E, 0x81, 0xA0, 0x4E, 0x02,
  0x77, 0x75, 0x02, 0x0E, 0xD0, 0x93, 0x0A, 0xD0, 0x97, 0x77, 0x50, 0xCD, 0x08, 0x40, 0x10, 0xEC,
  0x0E, 0x77, 0x74, 0x0B, 0xD0, 0x76, 0x05, 0xD0, 0x77, 0x77, 0x20, 0x9C, 0x0E, 0x05, 0x71, 0x09,
  0xC0, 0xD7, 0x77, 0x10, 0x7C, 0x0D, 0x02, 0x73, 0x0B, 0xC0, 0x57, 0x76, 0x05, 0xC0, 0xA0, 0x17,
  0x40, 0x10, 0xCB, 0x0D, 0x77, 0x60, 0xCA, 0x0D, 0x04, 0x77, 0x01, 0x0C, 0xA0, 0xD8, 0x0A, 0x91,
  0x00, 0x1F, 0xF0, 0xE7, 0x77, 0x70, 0x5F, 0xF0, 0xA7, 0x77, 0x70, 0x8F, 0xF0, 0x77, 0x77, 0x70,
  0xBF, 0xF0, 0x47, 0x77, 0x72, 0x81, 0x26, 0xCF, 0xB7, 0x77, 0x76, 0x0B, 0xF9, 0x0C, 0x77, 0x77,
  0x60, 0x4F, 0x90, 0x97, 0x77, 0x76, 0x01, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x1F, 0x90, 0x27, 0x77,
  0x76, 0x03, 0xF0, 0xE7, 0x77, 0x77, 0x06, 0xF0, 0xB7, 0x77, 0x77, 0x08, 0xF0, 0x87, 0x77, 0x77,
  0x0B, 0xF0, 0x57, 0x77, 0x77, 0x0E, 0xF0, 0x17, 0x77, 0x76, 0x02, 0xF0, 0xD7, 0x77, 0x77, 0x06,
  0xF0, 0xA7, 0x77, 0x77, 0x09, 0xF0, 0x77, 0x77, 0x77, 0x0C, 0xF0, 0x47, 0x77, 0x77, 0xF9, 0x01,
  0x77, 0x77, 0x60, 0x3F, 0x0D, 0x71, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x27, 0x74, 0x07, 0xF0, 0xA6,
  0x04, 0x0C, 0xFA, 0x08, 0x77, 0x30, 0xAF, 0x06, 0x50, 0x8F, 0xD0, 0x87, 0x72, 0x0D, 0xF0, 0x34,
  0x0B, 0xFF, 0x03, 0x77, 0x01, 0xF9, 0x40, 0xCF, 0xF9, 0x0A, 0x77, 0x04, 0xF0, 0xC3, 0x0B, 0xFF,
  0xB0, 0x17, 0x60, 0x8F, 0x08, 0x20, 0x9C, 0x09, 0x03, 0x20, 0x50, 0xEF, 0x90, 0x47, 0x60, 0xBF,
  0x81, 0x50, 0x5B, 0x0C, 0x02, 0x50, 0x5F, 0x90, 0x77, 0x60, 0xEF, 0x81, 0x12, 0xEA, 0x0A, 0x71,
  0x0E, 0xF0, 0x97, 0x50, 0x2F, 0x81, 0xD0, 0xBA, 0x0B, 0x72, 0x0B, 0xF0, 0x97, 0x50, 0x5F, 0x09,
  0x06, 0xA0, 0xC7, 0x30, 0xAF, 0x09, 0x75, 0x09, 0xF8, 0x38, 0xEF, 0xE1, 0x73, 0x0A, 0xF0, 0x87,
  0x50, 0xCF, 0xB0, 0x57, 0x40, 0xBF, 0x06, 0x75, 0xFB, 0x0A, 0x75, 0x0C, 0xF0, 0x47, 0x40, 0x3F,
  0xA0, 0xE0, 0x17, 0x5F, 0x90, 0x17, 0x40, 0x6F, 0xA0, 0x77, 0x50, 0x2F, 0x0E, 0x75, 0x0A, 0xF9,
  0x0D, 0x76, 0x05, 0xF0, 0xB7, 0x50, 0xDF, 0x90, 0x67, 0x60, 0x9F, 0x07, 0x74, 0x01, 0xF9, 0x0E,
  0x77, 0x0C, 0xF0, 0x47, 0x40, 0x4F, 0x90, 0x77, 0x7F, 0x90, 0x17, 0x40, 0x7F, 0x90, 0x17, 0x60,
  0x4F, 0x0D, 0x75, 0x0B, 0xF0, 0xA7, 0x70, 0x7F, 0x0A, 0x75, 0x0E, 0xF0, 0x47, 0x70, 0xAF, 0x06,
  0x74, 0x02, 0xF0, 0xE7, 0x71, 0x0E, 0xF0, 0x37, 0x40, 0x5F, 0x0A, 0x77, 0x01, 0xF9, 0x75, 0x08,
  0xF0, 0x67, 0x70, 0x4F, 0x0C, 0x75, 0x0C, 0xF0, 0x37, 0x70, 0x8F, 0x09, 0x75, 0xF9, 0x77, 0x10,
  0xBF, 0x06, 0x74, 0x03, 0xF0, 0xC7, 0x71, 0x0E, 0xF0, 0x37, 0x40, 0x6F, 0x08, 0x77, 0x02, 0xF9,
  0x75, 0x09, 0xF0, 0x57, 0x70, 0x5F, 0x0C, 0x75, 0x0D, 0xF0, 0x27, 0x70, 0x8F, 0x08, 0x74, 0x01,
  0xF0, 0xE7, 0x71, 0x0B, 0xF0, 0x57, 0x40, 0x4F, 0x0B, 0x77, 0x10, 0xEF, 0x02, 0x74, 0x07, 0xF0,
  0x77, 0x70, 0x1F, 0x97, 0x50, 0xAF, 0x04, 0x77, 0x04, 0xF0, 0xC7, 0x50, 0xEF, 0x01, 0x77, 0x06,
  0xF0, 0xA7, 0x40, 0x2F, 0x0D, 0x77, 0x10, 0x8F, 0x08, 0x74, 0x05, 0xF0, 0xA7, 0x71, 0x0A, 0xF0,
  0x77, 0x40, 0x8F, 0x06, 0x77, 0x10, 0xBF, 0x06, 0x74, 0x0B, 0xF0, 0x37, 0x71, 0x0C, 0xF0, 0x57,
  0x40, 0xEF, 0x77, 0x20, 0xDF, 0x05, 0x73, 0x03, 0xF0, 0xC7, 0x72, 0x0C, 0xF0, 0x77, 0x30, 0x6F,
  0x09, 0x77, 0x20, 0xAF, 0x0B, 0x58, 0x12, 0xB3, 0x20, 0x9F, 0x06, 0x77, 0x20, 0x7F, 0x98, 0x37,
  0x01, 0x49, 0xA0, 0xB2, 0x0C, 0xF0, 0x27, 0x72, 0x02, 0xFF, 0x90, 0xE0, 0x11, 0xF0, 0xE7, 0x74,
  0x0B, 0xFE, 0x82, 0xD2, 0x04, 0xF0, 0xB7, 0x74, 0x02, 0x0E, 0xFC, 0x09, 0x30, 0x7F, 0x08, 0x77,
  0x50, 0x30, 0xEF, 0x90, 0xC0, 0x37, 0x77, 0x75, 0x87, 0x17, 0xCE, 0xFE, 0xC8, 0x36,
  // "Ħ" (U+0126)
  0x76, 0x03, 0xFF, 0xF9, 0x0E, 0x72, 0x02, 0xFF, 0xF9, 0x0E, 0x76, 0x06, 0xFF, 0xF9, 0x0B, 0x72,
  0x05, 0xFF, 0xF9, 0x0B, 0x76, 0x09, 0xFF, 0xF9, 0x08, 0x72, 0x08, 0xFF, 0xF9, 0x08, 0x76, 0x0D,
  0xFF, 0xF9, 0x04, 0x72, 0x0B, 0xFF, 0xF9, 0x05, 0x77, 0x18, 0x21, 0x37, 0xCF, 0xD8, 0x1A, 0x52,
  0x77, 0x82, 0x13, 0x6C, 0xFD, 0x81, 0xA5, 0x27, 0x77, 0x10, 0xCF, 0xA0, 0xC0, 0x27, 0x77, 0x0D,
  0xFA, 0x0C, 0x02, 0x77, 0x74, 0x06, 0xF9, 0x0E, 0x01, 0x77, 0x71, 0x09, 0xF9, 0x0E, 0x01, 0x77,
  0x75, 0x06, 0xF9, 0x07, 0x77, 0x72, 0x08, 0xF9, 0x06, 0x77, 0x76, 0x08, 0xF9, 0x01, 0x77, 0x72,
  0x09, 0xF0, 0xE7, 0x77, 0x70, 0xBF, 0x0C, 0x77, 0x73, 0x0C, 0xF0, 0xA7, 0x77, 0x70, 0xEF, 0x08,
  0x77, 0x72, 0x01, 0xF9, 0x06, 0x77, 0x76, 0x03, 0xF9, 0x05, 0x77, 0x72, 0x04, 0xF9, 0x03, 0x77,
  0x76, 0x06, 0xF9, 0x01, 0x77, 0x72, 0x08, 0xF0, 0xE7, 0x77, 0x70, 0xAF, 0x0C, 0x77, 0x73, 0x0C,
  0xF0, 0xB7, 0x76, 0x03, 0x80, 0x36, 0x0D, 0xF0, 0xC8, 0x0A, 0x46, 0xF9, 0x0B, 0x80, 0x26, 0x05,
  0x76, 0x09, 0x80, 0xE3, 0xF0, 0xC7, 0x60, 0xC8, 0x0E, 0x3F, 0x09, 0x76, 0x80, 0xE4, 0xF0, 0x67,
  0x50, 0x28, 0x0E, 0x4F, 0x04, 0x77, 0x60, 0xEF, 0x0A, 0x77, 0x73, 0x0E, 0xF0, 0x77, 0x77, 0x60,
  0x1F, 0x90, 0x67, 0x77, 0x20, 0x2F, 0x90, 0x47, 0x77, 0x60, 0x5F, 0x90, 0x37, 0x77, 0x20, 0x6F,
  0x90, 0x17, 0x77, 0x60, 0x8F, 0x97, 0x77, 0x30, 0x9F, 0x0D, 0x77, 0x77, 0x0B, 0xF0, 0xB7, 0x77,
  0x30, 0xDF, 0x0A, 0x77, 0x77, 0x0E, 0xF0, 0x87, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x77, 0x60, 0x2F,
  0x90, 0x57, 0x77, 0x20, 0x4F, 0x90, 0x37, 0x77, 0x60, 0x5F, 0x90, 0x17, 0x77, 0x20, 0x7F, 0x97,
  0x77, 0x70, 0x9F, 0x0D, 0x77, 0x73, 0x0B, 0xF0, 0xC7, 0x77, 0x70, 0xC8, 0x0C, 0x4F, 0x09, 0x77,
  0x77, 0x80, 0xC5, 0xF0, 0x57, 0x77, 0x60, 0x38, 0x0C, 0x5F, 0x02, 0x77, 0x76, 0x06, 0x80, 0xC4,
  0xF0, 0xE7, 0x77, 0x70, 0xAF, 0x0D, 0x80, 0xA4, 0x60, 0xEF, 0x0B, 0x77, 0x77, 0x0D, 0xF0, 0x87,
  0x77, 0x3F, 0x90, 0x87, 0x77, 0x60, 0x1F, 0x90, 0x57, 0x77, 0x20, 0x3F, 0x90, 0x57, 0x77, 0x60,
  0x4F, 0x90, 0x27, 0x77, 0x20, 0x7F, 0x90, 0x17, 0x77, 0x60, 0x7F, 0x0E, 0x77, 0x73, 0x0A, 0xF0,
  0xD7, 0x77, 0x70, 0xAF, 0x0B, 0x77, 0x73, 0x0D, 0xF0, 0xA7, 0x77, 0x70, 0xEF, 0x07, 0x77, 0x72,
  0x01, 0xF9, 0x07, 0x77, 0x76, 0x01, 0xF9, 0x04, 0x77, 0x72, 0x04, 0xF9, 0x04, 0x77, 0x76, 0x05,
  0xF9, 0x01, 0x77, 0x72, 0x08, 0xF9, 0x77, 0x77, 0x08, 0xF0, 0xD7, 0x77, 0x30, 0xBF, 0x0C, 0x77,
  0x77, 0x0B, 0xF0, 0xA7, 0x77, 0x30, 0xEF, 0x09, 0x77, 0x77, 0x0E, 0xF0, 0x77, 0x77, 0x20, 0x2F,
  0x90, 0x67, 0x77, 0x60, 0x2F, 0x90, 0x37, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x77, 0x60, 0x6F, 0x97,
  0x77, 0x30, 0x8F, 0x97, 0x77, 0x70, 0x9F, 0x0C, 0x77, 0x73, 0x0C, 0xF0, 0xC7, 0x77, 0x70, 0xCF,
  0x09, 0x77, 0x73, 0xF9, 0x08, 0x77, 0x77, 0xF9, 0x06, 0x77, 0x72, 0x03, 0xF9, 0x05, 0x77, 0x76,
  0x03, 0xF9, 0x02, 0x77, 0x72, 0x06, 0xF9, 0x02, 0x77, 0x76, 0x06, 0xF0, 0xE7, 0x77, 0x30, 0x9F,
  0x0E, 0x77, 0x77, 0x0A, 0xF0, 0xB7, 0x77, 0x30, 0xCF, 0x0B, 0x77, 0x77, 0x0D, 0xF0, 0x87, 0x77,
  0x3F, 0x90, 0x77,