#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-CondensedItalic (Noto Serif Condensed Italic)
// Generated on Wed Nov 19 19:11:52 CET 2025
static const uint8_t font_NotoSerif_CondensedItalic_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x02, 0xA0,
  0xFE, 0xFF, 0x08, 0x0A, 0x07, 0xFE, 0x03, 0x00, 0x09, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x07, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x06, 0x03, 0x07, 0x03, 0x00, 0x0B, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0x0E, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x03, 0x07, 0x04, 0x00, 0x1C, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x05, 0x07, 0x06, 0x00, 0x2C, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x05, 0x07, 0x05, 0x00, 0x41, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x06, 0x01, 0x07, 0x02, 0x00, 0x56, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x02, 0x06, 0x02, 0x00, 0x57, // "(" (U+0028)
  0x00, 0x29, 0xBF, 0x00, 0x02, 0x06, 0x02, 0x00, 0x62, // ")" (U+0029)
  0x00, 0x2A, 0x41, 0x04, 0x03, 0x06, 0x04, 0x00, 0x70, // "*" (U+002A)
  0x00, 0x2B, 0x40, 0x02, 0x03, 0x05, 0x04, 0x00, 0x75, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0xFF, 0x00, 0x01, 0x02, 0x00, 0x7D, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x01, 0x03, 0x02, 0x00, 0x80, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x00, 0x02, 0x02, 0x00, 0x81, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0x00, 0x02, 0x07, 0x02, 0x00, 0x82, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0x91, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0x9F, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xAD, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xBB, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xC9, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xD7, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x03, 0x07, 0x04, 0x00, 0xE5, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0xF3, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x03, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x03, 0x07, 0x04, 0x01, 0x11, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x01, 0x05, 0x02, 0x01, 0x1F, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0x00, 0x01, 0x05, 0x02, 0x01, 0x24, // ";" (U+003B)
  0x00, 0x3C, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x2A, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x03, 0x05, 0x04, 0x01, 0x32, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x03, 0x05, 0x04, 0x01, 0x38, // ">" (U+003E)
  0x00, 0x3F, 0x41, 0x01, 0x03, 0x07, 0x03, 0x01, 0x40, // "?" (U+003F)
  0x00, 0x40, 0x40, 0x00, 0x05, 0x07, 0x06, 0x01, 0x4B, // "@" (U+0040)
  0x00, 0x41, 0xBF, 0x01, 0x04, 0x07, 0x05, 0x01, 0x63, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x78, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0x8A, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0x9C, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x04, 0x07, 0x04, 0x01, 0xAE, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x07, 0x04, 0x01, 0xC0, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x04, 0x07, 0x05, 0x01, 0xD1, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x05, 0x07, 0x06, 0x01, 0xE3, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x02, 0x07, 0x03, 0x01, 0xF8, // "I" (U+0049)
  0x00, 0x4A, 0xBF, 0xFF, 0x02, 0x07, 0x03, 0x02, 0x03, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x05, 0x07, 0x05, 0x02, 0x15, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0x2A, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x06, 0x07, 0x06, 0x02, 0x38, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x05, 0x07, 0x05, 0x02, 0x51, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0x66, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x04, 0x07, 0x04, 0x02, 0x78, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x02, 0x8A, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x04, 0x07, 0x05, 0x02, 0xA1, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x03, 0x07, 0x04, 0x02, 0xB3, // "S" (U+0053)
  0x00, 0x54, 0x40, 0x01, 0x04, 0x07, 0x04, 0x02, 0xC1, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x05, 0x07, 0x05, 0x02, 0xD3, // "U" (U+0055)
  0x00, 0x56, 0x40, 0x01, 0x05, 0x07, 0x05, 0x02, 0xE8, // "V" (U+0056)
  0x00, 0x57, 0x40, 0x01, 0x07, 0x07, 0x07, 0x02, 0xFD, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x05, 0x07, 0x05, 0x03, 0x19, // "X" (U+0058)
  0x00, 0x59, 0x40, 0x01, 0x04, 0x07, 0x04, 0x03, 0x31, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x04, 0x07, 0x04, 0x03, 0x43, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0x00, 0x02, 0x07, 0x03, 0x03, 0x55, // "[" (U+005B)
  0x00, 0x5C, 0x40, 0x00, 0x01, 0x07, 0x02, 0x03, 0x61, // "\" (U+005C)
  0x00, 0x5D, 0xBF, 0x00, 0x02, 0x07, 0x03, 0x03, 0x69, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x03, 0x03, 0x06, 0x04, 0x03, 0x79, // "^" (U+005E)
  0x00, 0x5F, 0xBF, 0x00, 0x02, 0x00, 0x03, 0x03, 0x81, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x07, 0x02, 0x08, 0x02, 0x03, 0x83, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x03, 0x05, 0x04, 0x03, 0x85, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x03, 0x07, 0x04, 0x03, 0x8F, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x03, 0x05, 0x03, 0x03, 0x9D, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x04, 0x07, 0x04, 0x03, 0xA7, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x03, 0x05, 0x03, 0x03, 0xB9, // "e" (U+0065)
  0x00, 0x66, 0xBF, 0xFF, 0x03, 0x07, 0x02, 0x03, 0xC3, // "f" (U+0066)
  0x00, 0x67, 0xBF, 0xFF, 0x04, 0x06, 0x04, 0x03, 0xDA, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x03, 0x07, 0x04, 0x03, 0xF2, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x07, 0x02, 0x04, 0x00, // "i" (U+0069)
  0x00, 0x6A, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x04, 0x0B, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x04, 0x04, 0x1D, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x07, 0x02, 0x04, 0x2F, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x05, 0x05, 0x06, 0x04, 0x3A, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x49, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x53, // "o" (U+006F)
  0x00, 0x70, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x5D, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x6B, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x03, 0x05, 0x03, 0x04, 0x79, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x05, 0x03, 0x04, 0x83, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x02, 0x06, 0x03, 0x04, 0x8D, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0x96, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xA0, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x05, 0x05, 0x06, 0x04, 0xAA, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xB9, // "x" (U+0078)
  0x00, 0x79, 0xBF, 0xFF, 0x03, 0x05, 0x04, 0x04, 0xC3, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x03, 0x05, 0x04, 0x04, 0xD5, // "z" (U+007A)
  0x00, 0x7B, 0x40, 0x00, 0x03, 0x07, 0x03, 0x04, 0xDF, // "{" (U+007B)
  0x00, 0x7C, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x04, 0xEF, // "|" (U+007C)
  0x00, 0x7D, 0xBF, 0x00, 0x02, 0x07, 0x03, 0x04, 0xF8, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x03, 0x03, 0x04, 0x04, 0x05, 0x08, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFF, 0x01, 0x05, 0x02, 0x05, 0x0C, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x03, 0x07, 0x04, 0x05, 0x13, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x03, 0x07, 0x04, 0x05, 0x21, // "£" (U+00A3)
  0x00, 0xA4, 0x40, 0x02, 0x03, 0x06, 0x04, 0x05, 0x2F, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x04, 0x07, 0x04, 0x05, 0x39, // "¥" (U+00A5)
  0x00, 0xA6, 0x41, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x4B, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0x00, 0x03, 0x07, 0x04, 0x05, 0x54, // "§" (U+00A7)
  0x00, 0xA8, 0x41, 0x07, 0x03, 0x07, 0x04, 0x05, 0x64, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x05, 0x07, 0x06, 0x05, 0x66, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0x7B, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x05, 0x80, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x02, 0x03, 0x04, 0x04, 0x05, 0x88, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x05, 0x07, 0x06, 0x05, 0x8E, // "®" (U+00AE)
  0x00, 0xAF, 0x41, 0x08, 0x04, 0x08, 0x03, 0x05, 0xA3, // "¯" (U+00AF)
  0x00, 0xB0, 0x41, 0x05, 0x02, 0x07, 0x03, 0x05, 0xA5, // "°" (U+00B0)
  0x00, 0xB1, 0x40, 0x01, 0x03, 0x05, 0x04, 0x05, 0xA8, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xB2, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xB8, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x07, 0x02, 0x08, 0x02, 0x05, 0xBE, // "´" (U+00B4)
  0x00, 0xB5, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x05, 0xC0, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0x00, 0x04, 0x07, 0x05, 0x05, 0xCE, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x03, 0x01, 0x04, 0x02, 0x05, 0xE2, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFF, 0x01, 0x01, 0x02, 0x05, 0xE4, // "¸" (U+00B8)
  0x00, 0xB9, 0x40, 0x04, 0x02, 0x07, 0x03, 0x05, 0xE7, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x04, 0x02, 0x06, 0x03, 0x05, 0xED, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x05, 0xF2, // "»" (U+00BB)
  0x00, 0xBC, 0x40, 0x01, 0x05, 0x07, 0x06, 0x05, 0xFA, // "¼" (U+00BC)
  0x00, 0xBD, 0x40, 0x01, 0x05, 0x07, 0x06, 0x06, 0x0F, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x05, 0x07, 0x06, 0x06, 0x24, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFF, 0x02, 0x05, 0x03, 0x06, 0x39, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x04, 0x09, 0x05, 0x06, 0x44, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x04, 0x09, 0x05, 0x06, 0x5E, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x04, 0x09, 0x05, 0x06, 0x78, // "Â" (U+00C2)
  0x00, 0xC3, 0xBF, 0x01, 0x04, 0x08, 0x05, 0x06, 0x92, // "Ã" (U+00C3)
  0x00, 0xC4, 0xBF, 0x01, 0x04, 0x08, 0x05, 0x06, 0xAA, // "Ä" (U+00C4)
  0x00, 0xC5, 0xBF, 0x01, 0x04, 0x08, 0x05, 0x06, 0xC2, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x06, 0x07, 0x07, 0x06, 0xDA, // "Æ" (U+00C6)
  0x00, 0xC7, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x06, 0xF5, // "Ç" (U+00C7)
  0x00, 0xC8, 0x40, 0x01, 0x04, 0x09, 0x04, 0x07, 0x0C, // "È" (U+00C8)
  0x00, 0xC9, 0x40, 0x01, 0x04, 0x09, 0x04, 0x07, 0x23, // "É" (U+00C9)
  0x00, 0xCA, 0x40, 0x01, 0x04, 0x09, 0x04, 0x07, 0x3A, // "Ê" (U+00CA)
  0x00, 0xCB, 0x40, 0x01, 0x04, 0x08, 0x04, 0x07, 0x51, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x02, 0x09, 0x03, 0x07, 0x65, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x09, 0x03, 0x07, 0x73, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x02, 0x09, 0x03, 0x07, 0x85, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x03, 0x08, 0x03, 0x07, 0x93, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x04, 0x07, 0x05, 0x07, 0xA3, // "Ð" (U+00D0)
  0x00, 0xD1, 0x40, 0x01, 0x05, 0x08, 0x05, 0x07, 0xB5, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xCD, // "Ò" (U+00D2)
  0x00, 0xD3, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xE4, // "Ó" (U+00D3)
  0x00, 0xD4, 0x40, 0x01, 0x04, 0x09, 0x05, 0x07, 0xFB, // "Ô" (U+00D4)
  0x00, 0xD5, 0x40, 0x01, 0x04, 0x08, 0x05, 0x08, 0x12, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x04, 0x08, 0x05, 0x08, 0x26, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x08, 0x3A, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x04, 0x07, 0x05, 0x08, 0x42, // "Ø" (U+00D8)
  0x00, 0xD9, 0x40, 0x01, 0x05, 0x09, 0x05, 0x08, 0x56, // "Ù" (U+00D9)
  0x00, 0xDA, 0x40, 0x01, 0x05, 0x09, 0x05, 0x08, 0x71, // "Ú" (U+00DA)
  0x00, 0xDB, 0x40, 0x01, 0x05, 0x09, 0x05, 0x08, 0x8C, // "Û" (U+00DB)
  0x00, 0xDC, 0x40, 0x01, 0x05, 0x08, 0x05, 0x08, 0xA7, // "Ü" (U+00DC)
  0x00, 0xDD, 0x40, 0x01, 0x04, 0x09, 0x04, 0x08, 0xBF, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x04, 0x07, 0x04, 0x08, 0xD6, // "Þ" (U+00DE)
  0x00, 0xDF, 0xBF, 0xFF, 0x04, 0x07, 0x04, 0x08, 0xE8, // "ß" (U+00DF)
  0x00, 0xE0, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x03, // "à" (U+00E0)
  0x00, 0xE1, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x13, // "á" (U+00E1)
  0x00, 0xE2, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0x23, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0x33, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0x41, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0x4F, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x05, 0x05, 0x06, 0x09, 0x5D, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFF, 0x03, 0x05, 0x03, 0x09, 0x6C, // "ç" (U+00E7)
  0x00, 0xE8, 0x40, 0x01, 0x03, 0x08, 0x03, 0x09, 0x7A, // "è" (U+00E8)
  0x00, 0xE9, 0x40, 0x01, 0x03, 0x08, 0x03, 0x09, 0x8A, // "é" (U+00E9)
  0x00, 0xEA, 0x40, 0x01, 0x03, 0x08, 0x03, 0x09, 0x9A, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x03, 0x07, 0x03, 0x09, 0xAA, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x08, 0x02, 0x09, 0xB8, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x08, 0x02, 0x09, 0xC4, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x01, 0x08, 0x02, 0x09, 0xD0, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x02, 0x07, 0x02, 0x09, 0xD8, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0xE3, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x03, 0x07, 0x04, 0x09, 0xF1, // "ñ" (U+00F1)
  0x00, 0xF2, 0x40, 0x01, 0x03, 0x08, 0x04, 0x09, 0xFF, // "ò" (U+00F2)
  0x00, 0xF3, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x0F, // "ó" (U+00F3)
  0x00, 0xF4, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x1F, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x2F, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x3D, // "ö" (U+00F6)
  0x00, 0xF7, 0x40, 0x02, 0x03, 0x05, 0x04, 0x0A, 0x4B, // "÷" (U+00F7)
  0x00, 0xF8, 0x40, 0x00, 0x03, 0x06, 0x04, 0x0A, 0x53, // "ø" (U+00F8)
  0x00, 0xF9, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x61, // "ù" (U+00F9)
  0x00, 0xFA, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x71, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x81, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x91, // "ü" (U+00FC)
  0x00, 0xFD, 0xFF, 0xFF, 0x03, 0x08, 0x04, 0x0A, 0x9F, // "ý" (U+00FD)
  0x00, 0xFE, 0xBF, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0xB7, // "þ" (U+00FE)
  0x00, 0xFF, 0xBF, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0xCE, // "ÿ" (U+00FF)
  0x01, 0x00, 0xBF, 0x01, 0x04, 0x07, 0x05, 0x0A, 0xE5, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0A, 0xFA, // "ā" (U+0101)
  0x01, 0x02, 0xBF, 0x01, 0x04, 0x07, 0x05, 0x0B, 0x06, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x03, 0x06, 0x04, 0x0B, 0x1B, // "ă" (U+0103)
  0x01, 0x04, 0xBF, 0xFF, 0x04, 0x07, 0x05, 0x0B, 0x27, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0B, 0x42, // "ą" (U+0105)
  0x01, 0x06, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0B, 0x50, // "Ć" (U+0106)
  0x01, 0x07, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0B, 0x67, // "ć" (U+0107)
  0x01, 0x08, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0B, 0x77, // "Ĉ" (U+0108)
  0x01, 0x09, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0B, 0x8E, // "ĉ" (U+0109)
  0x01, 0x0A, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0B, 0x9E, // "Ċ" (U+010A)
  0x01, 0x0B, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0B, 0xB2, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x09, 0x04, 0x0B, 0xC0, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x08, 0x03, 0x0B, 0xDA, // "č" (U+010D)
  0x01, 0x0E, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xED, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x05, 0x07, 0x04, 0x0C, 0x04, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0C, 0x19, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0C, 0x2B, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0C, 0x3D, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x03, 0x06, 0x03, 0x0C, 0x4F, // "ē" (U+0113)
  0x01, 0x14, 0x40, 0x01, 0x04, 0x07, 0x04, 0x0C, 0x5B, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x03, 0x06, 0x03, 0x0C, 0x6D, // "ĕ" (U+0115)
  0x01, 0x16, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0C, 0x79, // "Ė" (U+0116)
  0x01, 0x17, 0x40, 0x01, 0x03, 0x07, 0x03, 0x0C, 0x8D, // "ė" (U+0117)
  0x01, 0x18, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0C, 0x9B, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFF, 0x03, 0x05, 0x03, 0x0C, 0xB2, // "ę" (U+0119)
  0x01, 0x1A, 0x40, 0x01, 0x04, 0x09, 0x04, 0x0C, 0xC0, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x04, 0x08, 0x03, 0x0C, 0xD7, // "ě" (U+011B)
  0x01, 0x1C, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xEA, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xBF, 0xFF, 0x04, 0x08, 0x04, 0x0D, 0x01, // "ĝ" (U+011D)
  0x01, 0x1E, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x1F, // "Ğ" (U+011E)
  0x01, 0x1F, 0xBF, 0xFF, 0x04, 0x06, 0x04, 0x0D, 0x31, // "ğ" (U+011F)
  0x01, 0x20, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x49, // "Ġ" (U+0120)
  0x01, 0x21, 0xBF, 0xFF, 0x04, 0x07, 0x04, 0x0D, 0x5D, // "ġ" (U+0121)
  0x01, 0x22, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x78, // "Ģ" (U+0122)
  0x01, 0x23, 0xBF, 0xFF, 0x04, 0x07, 0x04, 0x0D, 0x8F, // "ģ" (U+0123)
  0x01, 0x24, 0x40, 0x01, 0x05, 0x09, 0x06, 0x0D, 0xAA, // "Ĥ" (U+0124)
  0x01, 0x25, 0x40, 0x01, 0x03, 0x0A, 0x04, 0x0D, 0xC5, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x05, 0x07, 0x06, 0x0D, 0xD9, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0D, 0xEE, // "ħ" (U+0127)
  0x01, 0x28, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0D, 0xFC, // "Ĩ" (U+0128)
  0x01, 0x29, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0E, 0x0C, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0x17, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x02, 0x06, 0x02, 0x0E, 0x22, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0E, 0x2B, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x02, 0x06, 0x02, 0x0E, 0x36, // "ĭ" (U+012D)
  0x01, 0x2E, 0xBF, 0xFF, 0x02, 0x07, 0x03, 0x0E, 0x3F, // "Į" (U+012E)
  0x01, 0x2F, 0xBF, 0xFF, 0x02, 0x07, 0x02, 0x0E, 0x51, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x02, 0x08, 0x03, 0x0E, 0x63, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x01, 0x05, 0x02, 0x0E, 0x6F, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFF, 0x05, 0x07, 0x05, 0x0E, 0x74, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0x8F, // "ĳ" (U+0133)
  0x01, 0x34, 0xBF, 0xFF, 0x02, 0x09, 0x03, 0x0E, 0xA5, // "Ĵ" (U+0134)
  0x01, 0x35, 0xBF, 0xFF, 0x01, 0x08, 0x02, 0x0E, 0xBB, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x05, 0x07, 0x05, 0x0E, 0xCA, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x04, 0x07, 0x04, 0x0E, 0xE5, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x04, 0x05, 0x04, 0x0E, 0xFC, // "ĸ" (U+0138)
  0x01, 0x39, 0x40, 0x01, 0x03, 0x09, 0x04, 0x0F, 0x09, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x03, 0x0A, 0x02, 0x0F, 0x1B, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x0F, 0x2F, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFF, 0x02, 0x07, 0x02, 0x0F, 0x41, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0F, 0x4F, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x03, 0x07, 0x02, 0x0F, 0x60, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0x6E, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x02, 0x07, 0x03, 0x0F, 0x7C, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x03, 0x07, 0x04, 0x0F, 0x87, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x07, 0x02, 0x0F, 0x95, // "ł" (U+0142)
  0x01, 0x43, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0F, 0xA0, // "Ń" (U+0143)
  0x01, 0x44, 0x40, 0x01, 0x03, 0x08, 0x04, 0x0F, 0xBB, // "ń" (U+0144)
  0x01, 0x45, 0x40, 0xFF, 0x05, 0x07, 0x05, 0x0F, 0xCB, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x0F, 0xE6, // "ņ" (U+0146)
  0x01, 0x47, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0F, 0xF4, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x08, 0x04, 0x10, 0x0F, // "ň" (U+0148)
  0x01, 0x49, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x23, // "ŉ" (U+0149)
  0x01, 0x4A, 0x40, 0xFF, 0x05, 0x07, 0x05, 0x10, 0x35, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x10, 0x50, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x5E, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x03, 0x06, 0x04, 0x10, 0x70, // "ō" (U+014D)
  0x01, 0x4E, 0x40, 0x01, 0x04, 0x07, 0x05, 0x10, 0x7C, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x03, 0x06, 0x04, 0x10, 0x8E, // "ŏ" (U+014F)
  0x01, 0x50, 0x40, 0x01, 0x05, 0x08, 0x05, 0x10, 0x9A, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x04, 0x07, 0x04, 0x10, 0xB2, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x06, 0x07, 0x07, 0x10, 0xC4, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x05, 0x05, 0x06, 0x10, 0xDD, // "œ" (U+0153)
  0x01, 0x54, 0x40, 0x01, 0x04, 0x09, 0x05, 0x10, 0xEC, // "Ŕ" (U+0154)
  0x01, 0x55, 0x40, 0x01, 0x03, 0x08, 0x03, 0x11, 0x03, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x04, 0x07, 0x05, 0x11, 0x13, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFF, 0x03, 0x05, 0x03, 0x11, 0x2A, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x04, 0x09, 0x05, 0x11, 0x38, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x03, 0x08, 0x03, 0x11, 0x4F, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x04, 0x09, 0x04, 0x11, 0x5F, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x08, 0x03, 0x11, 0x76, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x03, 0x09, 0x04, 0x11, 0x86, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x08, 0x03, 0x11, 0x98, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFF, 0x03, 0x07, 0x04, 0x11, 0xA8, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFF, 0x03, 0x05, 0x03, 0x11, 0xBA, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x09, 0x04, 0x11, 0xC8, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x08, 0x03, 0x11, 0xDF, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x04, 0x07, 0x04, 0x11, 0xEF, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x12, 0x04, // "ţ" (U+0163)
  0x01, 0x64, 0x40, 0x01, 0x04, 0x09, 0x04, 0x12, 0x10, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x03, 0x07, 0x03, 0x12, 0x27, // "ť" (U+0165)
  0x01, 0x66, 0x40, 0x01, 0x04, 0x07, 0x04, 0x12, 0x35, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x02, 0x06, 0x03, 0x12, 0x47, // "ŧ" (U+0167)
  0x01, 0x68, 0x40, 0x01, 0x05, 0x08, 0x05, 0x12, 0x50, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x04, 0x07, 0x04, 0x12, 0x68, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x05, 0x07, 0x05, 0x12, 0x7A, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x03, 0x06, 0x04, 0x12, 0x8F, // "ū" (U+016B)
  0x01, 0x6C, 0x40, 0x01, 0x05, 0x07, 0x05, 0x12, 0x9B, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x03, 0x06, 0x04, 0x12, 0xB0, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x05, 0x08, 0x05, 0x12, 0xBC, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x03, 0x07, 0x04, 0x12, 0xD4, // "ů" (U+016F)
  0x01, 0x70, 0x40, 0x01, 0x05, 0x08, 0x05, 0x12, 0xE2, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x04, 0x07, 0x04, 0x12, 0xFA, // "ű" (U+0171)
  0x01, 0x72, 0x40, 0xFF, 0x05, 0x07, 0x05, 0x13, 0x0C, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x13, 0x27, // "ų" (U+0173)
  0x01, 0x74, 0x40, 0x01, 0x07, 0x09, 0x07, 0x13, 0x35, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x05, 0x08, 0x06, 0x13, 0x59, // "ŵ" (U+0175)
  0x01, 0x76, 0x40, 0x01, 0x04, 0x09, 0x04, 0x13, 0x6F, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFF, 0xFF, 0x03, 0x08, 0x04, 0x13, 0x86, // "ŷ" (U+0177)
  0x01, 0x78, 0x40, 0x01, 0x04, 0x08, 0x04, 0x13, 0x9E, // "Ÿ" (U+0178)
  0x01, 0x79, 0x40, 0x01, 0x04, 0x09, 0x04, 0x13, 0xB2, // "Ź" (U+0179)
  0x01, 0x7A, 0x40, 0x01, 0x03, 0x08, 0x04, 0x13, 0xC9, // "ź" (U+017A)
  0x01, 0x7B, 0x40, 0x01, 0x04, 0x08, 0x04, 0x13, 0xD9, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x03, 0x07, 0x04, 0x13, 0xED, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x04, 0x09, 0x04, 0x13, 0xFB, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x08, 0x04, 0x14, 0x12, // "ž" (U+017E)
  0x01, 0x7F, 0xFF, 0xFF, 0x03, 0x07, 0x02, 0x14, 0x26, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x05, 0x07, 0x05, 0x14, 0x3C, // "Ω" (U+03A9)
  0x03, 0xBC, 0x40, 0xFF, 0x03, 0x05, 0x04, 0x14, 0x51, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x04, 0x05, 0x04, 0x14, 0x5F, // "π" (U+03C0)
  0x20, 0x13, 0x40, 0x03, 0x03, 0x03, 0x04, 0x14, 0x6C, // "–" (U+2013)
  0x20, 0x14, 0x40, 0x03, 0x07, 0x03, 0x08, 0x14, 0x6E, // "—" (U+2014)
  0x20, 0xAC, 0x40, 0x01, 0x04, 0x07, 0x04, 0x14, 0x72, // "€" (U+20AC)
  0x20, 0xBF, 0xBF, 0x00, 0x03, 0x08, 0x04, 0x14, 0x84, // "₿" (U+20BF)
  0x20, 0x18, 0x40, 0x05, 0x01, 0x07, 0x02, 0x14, 0x9B, // "‘" (U+2018)
  0x20, 0x19, 0x40, 0x05, 0x01, 0x07, 0x02, 0x14, 0x9E, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0xFF, 0x00, 0x01, 0x02, 0x14, 0xA1, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x05, 0x01, 0x07, 0x02, 0x14, 0xA4, // "‛" (U+201B)
  0x20, 0x1C, 0x40, 0x05, 0x03, 0x07, 0x03, 0x14, 0xA6, // "“" (U+201C)
  0x20, 0x1D, 0x40, 0x05, 0x03, 0x07, 0x03, 0x14, 0xAC, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0xFF, 0x02, 0x01, 0x03, 0x14, 0xB2, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x05, 0x02, 0x07, 0x03, 0x14, 0xB8, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x00, 0x03, 0x07, 0x03, 0x14, 0xBB, // "†" (U+2020)
  0x20, 0x21, 0x40, 0x00, 0x03, 0x07, 0x03, 0x14, 0xCA, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x05, 0x03, 0x14, 0xDA, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x05, 0x02, 0x06, 0x14, 0xDF, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x08, 0x07, 0x09, 0x14, 0xE5, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x01, 0x05, 0x02, 0x15, 0x05, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x01, 0x05, 0x02, 0x15, 0x09, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x00, 0x15, 0x0D, // "⁄" (U+2044)
  0x21, 0x22, 0x40, 0x04, 0x06, 0x06, 0x06, 0x15, 0x1B, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x08, 0x07, 0x09, 0x15, 0x26, // "⅒" (U+2152)
  0xFB, 0x01, 0xBF, 0xFF, 0x03, 0x07, 0x04, 0x15, 0x44, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xBF, 0xFF, 0x04, 0x07, 0x04, 0x15, 0x5B, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x08, 0x40, 0x91, 0x09, 0x00, 0x80, 0x06, 0x00, 0x00, 0x74, 0x00,
  // """ (U+0022)
  0xA8, 0x27, 0x70,
  // "#" (U+0023)
  0x02, 0x46, 0x05, 0x16, 0x2B, 0xA8, 0x06, 0x60, 0x7A, 0xB4, 0x51, 0x60, 0x62, 0x40,
  // "$" (U+0024)
  0x00, 0x71, 0x0A, 0x8A, 0x0B, 0x50, 0x06, 0xB0, 0x23, 0x85, 0xA6, 0x93, 0x29, 0x30, 0x02, 0x00,
  // "%" (U+0025)
  0x07, 0x80, 0x61, 0x26, 0x90, 0x60, 0x53, 0x96, 0x10, 0x62, 0x96, 0x55, 0x17, 0x83, 0x68, 0x01,
  0x66, 0x28, 0x07, 0x03, 0x74,
  // "&" (U+0026)
  0x01, 0x89, 0x00, 0x06, 0x39, 0x10, 0x06, 0xDC, 0x00, 0x07, 0xD1, 0x91, 0x65, 0xA5, 0x40, 0xA1,
  0x2D, 0x00, 0x57, 0x6A, 0x70,
  // "'" (U+0027)
  0xA7,
  // "(" (U+0028)
  0x01, 0x70, 0x90, 0x47, 0x08, 0x30, 0xA1, 0x08, 0x10, 0x25, 0x00,
  // ")" (U+0029)
  0x00, 0x70, 0x00, 0x63, 0x00, 0x65, 0x00, 0x83, 0x00, 0xA0, 0x03, 0x70, 0x17, 0x00,
  // "*" (U+002A)
  0x67, 0x18, 0xC6, 0x16, 0x40,
  // "+" (U+002B)
  0x04, 0x20, 0x04, 0x20, 0x4A, 0x93, 0x04, 0x20,
  // "," (U+002C)
  0x0B, 0x07, 0x12,
  // "-" (U+002D)
  0x7A,
  // "." (U+002E)
  0x1A,
  // "/" (U+002F)
  0x30, 0x72, 0x00, 0x32, 0x07, 0x30, 0x62, 0x05, 0x01, 0x20, 0x72, 0x01, 0x05, 0x20, 0x63,
  // "0" (U+0030)
  0x05, 0x86, 0x09, 0x0A, 0x55, 0x0B, 0x82, 0x0A, 0x91, 0x28, 0x81, 0x72, 0x39, 0x60,
  // "1" (U+0031)
  0x01, 0xB1, 0x07, 0xB0, 0x00, 0xB0, 0x02, 0x80, 0x05, 0x60, 0x08, 0x30, 0x4D, 0x70,
  // "2" (U+0032)
  0x09, 0x86, 0x07, 0x1A, 0x00, 0x47, 0x00, 0x90, 0x07, 0x20, 0x54, 0x11, 0xDA, 0xC0,
  // "3" (U+0033)
  0x08, 0x86, 0x08, 0x0B, 0x00, 0x46, 0x05, 0xB0, 0x00, 0x84, 0x40, 0x83, 0xA7, 0x80,
  // "4" (U+0034)
  0x00, 0x59, 0x01, 0xA6, 0x07, 0x83, 0x42, 0xA0, 0x87, 0xD5, 0x00, 0xA0, 0x08, 0xC1,
  // "5" (U+0035)
  0x07, 0xBB, 0x05, 0x01, 0x05, 0x00, 0x28, 0x80, 0x00, 0x74, 0x20, 0x82, 0x97, 0x70,
  // "6" (U+0036)
  0x02, 0x9A, 0x0B, 0x03, 0x2A, 0x00, 0x6A, 0x81, 0x74, 0x47, 0x73, 0x56, 0x18, 0x90,
  // "7" (U+0037)
  0x18, 0x6C, 0xBE, 0x11, 0x21, 0x93, 0x07, 0x03, 0x30, 0xA3, 0x00, 0x53, 0x0A, 0x30, 0x30, 0x83,
  // "8" (U+0038)
  0x07, 0x67, 0x0A, 0x0B, 0x0D, 0xA7, 0x09, 0xD0, 0x92, 0x75, 0xB0, 0x45, 0x66, 0x70,
  // "9" (U+0039)
  0x06, 0x86, 0x19, 0x0A, 0x46, 0x0A, 0x46, 0x29, 0x08, 0x85, 0x00, 0x80, 0x76, 0x40,
  // ":" (U+003A)
  0x0B, 0x01, 0x00, 0x10, 0x91,
  // ";" (U+003B)
  0x0B, 0x01, 0x00, 0x10, 0x93, 0x70,
  // "<" (U+003C)
  0x00, 0x43, 0x17, 0x30, 0x38, 0x10, 0x00, 0x73,
  // "=" (U+003D)
  0x48, 0x83, 0x00, 0x00, 0x48, 0x83,
  // ">" (U+003E)
  0x43, 0x00, 0x04, 0x70, 0x01, 0x82, 0x46, 0x00,
  // "?" (U+003F)
  0x88, 0x67, 0x0A, 0x04, 0x73, 0x80, 0x60, 0x01, 0x00, 0xA0, 0x00,
  // "@" (U+0040)
  0x00, 0x77, 0x83, 0x08, 0x10, 0x08, 0x26, 0x56, 0x97, 0x53, 0x91, 0x77, 0x72, 0x85, 0x57, 0x62,
  0x74, 0x73, 0x27, 0x00, 0x30, 0x03, 0x77, 0x20,
  // "A" (U+0041)
  0x00, 0x03, 0xA0, 0x00, 0x06, 0xB0, 0x00, 0x15, 0xB0, 0x00, 0x60, 0xB0, 0x00, 0xA7, 0xD0, 0x05,
  0x20, 0xB0, 0x2C, 0x22, 0xD5,
  // "B" (U+0042)
  0x0A, 0x99, 0x20, 0x83, 0x57, 0x0B, 0x08, 0x40, 0xC8, 0xA0, 0x0B, 0x0B, 0x03, 0x80, 0xC0, 0xA9,
  0x76, 0x00,
  // "C" (U+0043)
  0x01, 0x89, 0x60, 0xA1, 0x16, 0x39, 0x00, 0x06, 0x50, 0x00, 0x84, 0x00, 0x06, 0x50, 0x10, 0x1A,
  0x85, 0x00,
  // "D" (U+0044)
  0x0A, 0x98, 0x40, 0x83, 0x0B, 0x0B, 0x00, 0xC0, 0xB0, 0x0C, 0x0A, 0x02, 0x93, 0x80, 0x93, 0xAA,
  0x86, 0x00,
  // "E" (U+0045)
  0x0A, 0x97, 0x70, 0x83, 0x03, 0x0B, 0x00, 0x00, 0xD7, 0x30, 0x1B, 0x00, 0x03, 0x80, 0x30, 0xA9,
  0x69, 0x00,
  // "F" (U+0046)
  0x18, 0x91, 0xA9, 0x77, 0x08, 0x30, 0x30, 0xA4, 0x81, 0xC7, 0x32, 0x0A, 0x30, 0x30, 0x83, 0x00,
  0xA3,
  // "G" (U+0047)
  0x01, 0x88, 0xA0, 0xB1, 0x06, 0x39, 0x00, 0x07, 0x50, 0x00, 0x84, 0x08, 0x76, 0x50, 0x83, 0x19,
  0x7A, 0x00,
  // "H" (U+0048)
  0x0A, 0xA0, 0xB9, 0x08, 0x30, 0x92, 0x0B, 0x00, 0xB0, 0x0C, 0x77, 0xB0, 0x0A, 0x01, 0x90, 0x38,
  0x04, 0x70, 0xAA, 0x1B, 0x90,
  // "I" (U+0049)
  0x0A, 0xA0, 0x83, 0x0B, 0x00, 0xB0, 0x0A, 0x03, 0x80, 0xAA, 0x00,
  // "J" (U+004A)
  0x00, 0xBA, 0x00, 0x92, 0x00, 0xB0, 0x00, 0xB0, 0x02, 0x90, 0x04, 0x70, 0x07, 0x40, 0x0A, 0x00,
  0x77, 0x00,
  // "K" (U+004B)
  0x0A, 0xA1, 0xD3, 0x08, 0x35, 0x20, 0x0B, 0x35, 0x00, 0x0C, 0xC2, 0x00, 0x0B, 0x66, 0x00, 0x38,
  0x2A, 0x00, 0xAA, 0x0A, 0x30,
  // "L" (U+004C)
  0x0A, 0xA0, 0x08, 0x30, 0x0B, 0x00, 0x0B, 0x00, 0x0A, 0x00, 0x38, 0x06, 0xA9, 0x69,
  // "M" (U+004D)
  0x0A, 0xB0, 0x0C, 0x90, 0x6B, 0x03, 0xC1, 0x06, 0xB0, 0x6B, 0x00, 0x6B, 0x15, 0xB0, 0x15, 0xA6,
  0x29, 0x03, 0x39, 0x64, 0x60, 0xA5, 0x72, 0xA8, 0x00,
  // "N" (U+004E)
  0x0A, 0x70, 0x87, 0x06, 0xB0, 0x60, 0x06, 0xA1, 0x60, 0x06, 0x65, 0x60, 0x05, 0x19, 0x60, 0x33,
  0x0C, 0x50, 0xA5, 0x08, 0x20,
  // "O" (U+004F)
  0x01, 0x88, 0x60, 0xA1, 0x0C, 0x39, 0x00, 0xC7, 0x50, 0x0C, 0x84, 0x01, 0xA6, 0x50, 0x83, 0x09,
  0x76, 0x00,
  // "P" (U+0050)
  0x0A, 0x99, 0x00, 0x83, 0x65, 0x0B, 0x16, 0x50, 0xC0, 0xA1, 0x0D, 0x63, 0x03, 0x80, 0x00, 0xAA,
  0x00, 0x00,
  // "Q" (U+0051)
  0x01, 0x87, 0x60, 0xA1, 0x0B, 0x39, 0x00, 0xC7, 0x50, 0x0D, 0x84, 0x01, 0xB6, 0x50, 0x84, 0x1A,
  0x86, 0x00, 0x2A, 0x00, 0x00, 0xA5, 0x00,
  // "R" (U+0052)
  0x0A, 0x99, 0x20, 0x82, 0x56, 0x0A, 0x08, 0x30, 0xC9, 0x60, 0x1A, 0x65, 0x03, 0x83, 0x80, 0xAA,
  0x1B, 0x10,
  // "S" (U+0053)
  0x06, 0x7A, 0x0A, 0x05, 0x0D, 0x10, 0x06, 0xC0, 0x00, 0x85, 0x80, 0x46, 0x77, 0x80,
  // "T" (U+0054)
  0x2A, 0xC8, 0xB2, 0x0A, 0x03, 0x00, 0xB0, 0x00, 0x0A, 0x00, 0x03, 0x80, 0x00, 0x55, 0x00, 0x1B,
  0x80, 0x00,
  // "U" (U+0055)
  0x0C, 0x80, 0xB4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B, 0x00, 0x60, 0x38, 0x02, 0x30, 0x47,
  0x06, 0x00, 0x0A, 0x85, 0x00,
  // "V" (U+0056)
  0x1E, 0x51, 0xC2, 0x0B, 0x00, 0x60, 0x0A, 0x15, 0x10, 0x09, 0x27, 0x00, 0x08, 0x63, 0x00, 0x07,
  0x90, 0x00, 0x05, 0x60, 0x00,
  // "W" (U+0057)
  0x1D, 0x50, 0xA0, 0x78, 0x0B, 0x04, 0xC0, 0x60, 0x0A, 0x17, 0xB0, 0x70, 0x0A, 0x25, 0xB3, 0x30,
  0x09, 0x81, 0xB7, 0x00, 0x09, 0x80, 0xA6, 0x00, 0x08, 0x50, 0xB2, 0x00,
  // "X" (U+0058)
  0x28, 0x3B, 0x82, 0xC1, 0x28, 0x25, 0x75, 0x13, 0x81, 0x1C, 0x55, 0x0D, 0x58, 0x15, 0x94, 0x38,
  0x22, 0x54, 0x82, 0x84, 0x1C, 0x26, 0xD1, 0x10,
  // "Y" (U+0059)
  0x1E, 0x43, 0xC0, 0xA1, 0x42, 0x07, 0x56, 0x00, 0x3C, 0x10, 0x02, 0x90, 0x00, 0x56, 0x00, 0x1B,
  0x90, 0x00,
  // "Z" (U+005A)
  0x0B, 0x6B, 0x61, 0x21, 0xC0, 0x00, 0x94, 0x00, 0x3B, 0x00, 0x0B, 0x20, 0x05, 0x80, 0x30, 0xE7,
  0x79, 0x00,
  // "[" (U+005B)
  0x08, 0x80, 0xB0, 0x0B, 0x02, 0x90, 0x55, 0x08, 0x20, 0xB0, 0x09, 0x40,
  // "\" (U+005C)
  0x14, 0x15, 0x05, 0x06, 0x06, 0x06, 0x06, 0x06,
  // "]" (U+005D)
  0x00, 0x79, 0x00, 0x46, 0x00, 0x73, 0x00, 0xA0, 0x00, 0xB0, 0x01, 0xA0, 0x04, 0x70, 0x18, 0x30,
  // "^" (U+005E)
  0x05, 0x30, 0x06, 0x60, 0x15, 0x60, 0x60, 0x24,
  // "_" (U+005F)
  0x58, 0x85,
  // "`" (U+0060)
  0x50, 0x43,
  // "a" (U+0061)
  0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "b" (U+0062)
  0x1D, 0x20, 0x0B, 0x00, 0x0B, 0x97, 0x2B, 0x0B, 0x56, 0x29, 0x83, 0x64, 0x97, 0x70,
  // "c" (U+0063)
  0x07, 0x95, 0x36, 0x12, 0x82, 0x00, 0x92, 0x00, 0x4A, 0x60,
  // "d" (U+0064)
  0x00, 0x0C, 0x20, 0x00, 0xA0, 0x07, 0x7B, 0x03, 0x71, 0x90, 0x83, 0x46, 0x0A, 0x19, 0x30, 0x69,
  0x88, 0x00,
  // "e" (U+0065)
  0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3A, 0x60,
  // "f" (U+0066)
  0x00, 0x49, 0x60, 0x0A, 0x01, 0x02, 0xD5, 0x00, 0x19, 0x00, 0x04, 0x70, 0x00, 0x74, 0x00, 0x09,
  0x10, 0x00, 0xB0, 0x00, 0x75, 0x00, 0x00,
  // "g" (U+0067)
  0x00, 0x00, 0x72, 0x00, 0x89, 0x70, 0x02, 0x75, 0x50, 0x00, 0xA6, 0x00, 0x05, 0x61, 0x00, 0x07,
  0x8D, 0x00, 0x36, 0x08, 0x00, 0x19, 0x76, 0x00,
  // "h" (U+0068)
  0x0C, 0x30, 0x0A, 0x00, 0x0B, 0x69, 0x0C, 0x0B, 0x37, 0x28, 0x64, 0x55, 0x91, 0x49,
  // "i" (U+0069)
  0x08, 0x10, 0x00, 0x2C, 0x01, 0x90, 0x47, 0x06, 0x40, 0x58, 0x00,
  // "j" (U+006A)
  0x00, 0x81, 0x00, 0x00, 0x02, 0xC0, 0x01, 0x90, 0x04, 0x70, 0x07, 0x40, 0x09, 0x10, 0x0B, 0x00,
  0x75, 0x00,
  // "k" (U+006B)
  0x0B, 0x30, 0x00, 0xA0, 0x00, 0x0B, 0x2C, 0x11, 0x97, 0x00, 0x3B, 0x90, 0x06, 0x4B, 0x00, 0x91,
  0x66, 0x00,
  // "l" (U+006C)
  0x0C, 0x30, 0xA0, 0x0B, 0x01, 0x90, 0x46, 0x06, 0x40, 0x58, 0x00,
  // "m" (U+006D)
  0x3C, 0x79, 0x6A, 0x1C, 0x0D, 0x0B, 0x47, 0x38, 0x28, 0x74, 0x55, 0x46, 0x91, 0x73, 0x3A,
  // "n" (U+006E)
  0x3C, 0x79, 0x1C, 0x0A, 0x47, 0x38, 0x74, 0x55, 0x91, 0x49,
  // "o" (U+006F)
  0x07, 0x75, 0x46, 0x0B, 0x82, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "p" (U+0070)
  0x2C, 0x89, 0x1C, 0x0B, 0x47, 0x0A, 0x64, 0x46, 0x97, 0x80, 0xB0, 0x00, 0xD1, 0x00,
  // "q" (U+0071)
  0x07, 0x6A, 0x37, 0x19, 0x83, 0x46, 0x91, 0xA3, 0x69, 0xB0, 0x00, 0xA0, 0x00, 0xD1,
  // "r" (U+0072)
  0x3B, 0x95, 0x1C, 0x00, 0x38, 0x00, 0x64, 0x00, 0x91, 0x00,
  // "s" (U+0073)
  0x18, 0xA1, 0x37, 0x20, 0x0B, 0x60, 0x40, 0xA0, 0x86, 0x60,
  // "t" (U+0074)
  0x09, 0x03, 0xD5, 0x1A, 0x04, 0x70, 0x64, 0x04, 0x91,
  // "u" (U+0075)
  0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x69,
  // "v" (U+0076)
  0x76, 0x18, 0x28, 0x07, 0x09, 0x42, 0x0A, 0x60, 0x08, 0x00,
  // "w" (U+0077)
  0x58, 0x1B, 0x08, 0x28, 0x5A, 0x06, 0x28, 0x59, 0x41, 0x2A, 0x2A, 0x50, 0x2A, 0x0B, 0x10,
  // "x" (U+0078)
  0x1C, 0x19, 0x09, 0x80, 0x06, 0x70, 0x07, 0xA0, 0x91, 0xB2,
  // "y" (U+0079)
  0x09, 0x52, 0x70, 0x38, 0x07, 0x00, 0xA5, 0x20, 0x0A, 0x70, 0x00, 0x93, 0x00, 0x18, 0x00, 0x78,
  0x00, 0x00,
  // "z" (U+007A)
  0x2A, 0xC4, 0x11, 0xA0, 0x09, 0x20, 0x48, 0x10, 0xC8, 0xA0,
  // "{" (U+007B)
  0x00, 0xA3, 0x02, 0x80, 0x05, 0x50, 0x08, 0x20, 0x49, 0x00, 0x0B, 0x00, 0x28, 0x00, 0x18, 0x00,
  // "|" (U+007C)
  0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
  // "}" (U+007D)
  0x00, 0x84, 0x00, 0x55, 0x00, 0x83, 0x00, 0xA1, 0x00, 0x76, 0x01, 0xA0, 0x05, 0x60, 0x27, 0x00,
  // "~" (U+007E)
  0x38, 0x05, 0x51, 0x82,
  // "¡" (U+00A1)
  0x0B, 0x02, 0x05, 0x34, 0x62, 0xA0, 0x90,
  // "¢" (U+00A2)
  0x00, 0x62, 0x07, 0xCA, 0x0C, 0x40, 0x47, 0x40, 0x58, 0x51, 0x1E, 0x80, 0x05, 0x00,
  // "£" (U+00A3)
  0x03, 0x7B, 0x09, 0x04, 0x0A, 0x00, 0x3C, 0x60, 0x09, 0x00, 0x17, 0x00, 0x8B, 0xA3,
  // "¤" (U+00A4)
  0x00, 0x01, 0x1B, 0x8A, 0x06, 0x07, 0x07, 0x07, 0x19, 0x89,
  // "¥" (U+00A5)
  0x1E, 0x29, 0x50, 0xB0, 0x60, 0x09, 0x25, 0x00, 0x69, 0x00, 0x19, 0xA2, 0x02, 0xA8, 0x10, 0x2C,
  0x50, 0x00,
  // "¦" (U+00A6)
  0x42, 0x42, 0x42, 0x21, 0x00, 0x21, 0x42, 0x42, 0x42,
  // "§" (U+00A7)
  0x05, 0x68, 0x09, 0x03, 0x0B, 0x70, 0x34, 0x84, 0x1D, 0x84, 0x02, 0xC0, 0x60, 0x70, 0x56, 0x20,
  // "¨" (U+00A8)
  0x42, 0x50,
  // "©" (U+00A9)
  0x03, 0x66, 0x10, 0x25, 0x66, 0x60, 0x65, 0x12, 0x24, 0x67, 0x00, 0x05, 0x65, 0x21, 0x14, 0x25,
  0x65, 0x70, 0x03, 0x66, 0x10,
  // "ª" (U+00AA)
  0x07, 0xA5, 0x49, 0x47, 0x90,
  // "«" (U+00AB)
  0x02, 0x12, 0x18, 0x80, 0x66, 0x80, 0x06, 0x70,
  // "¬" (U+00AC)
  0x48, 0x84, 0x00, 0x16, 0x00, 0x04,
  // "®" (U+00AE)
  0x03, 0x66, 0x10, 0x27, 0x75, 0x60, 0x60, 0x77, 0x14, 0x60, 0x97, 0x05, 0x60, 0x77, 0x14, 0x27,
  0x74, 0x80, 0x03, 0x66, 0x10,
  // "¯" (U+00AF)
  0x88, 0x81,
  // "°" (U+00B0)
  0x56, 0x65, 0x56,
  // "±" (U+00B1)
  0x03, 0x40, 0x39, 0xA4, 0x03, 0x40, 0x02, 0x30, 0x38, 0x84,
  // "²" (U+00B2)
  0x05, 0x60, 0x28, 0x04, 0x33, 0x85,
  // "³" (U+00B3)
  0x05, 0x70, 0x38, 0x20, 0x92, 0x64,
  // "´" (U+00B4)
  0x32, 0x80,
  // "µ" (U+00B5)
  0x0B, 0x0B, 0x19, 0x0B, 0x47, 0x28, 0x74, 0x65, 0x8A, 0x89, 0x80, 0x00, 0xB0, 0x00,
  // "¶" (U+00B6)
  0x3E, 0xDB, 0x57, 0xFB, 0x70, 0x5F, 0xB7, 0x00, 0x39, 0x70, 0x00, 0x77, 0x00, 0x07, 0x70, 0x00,
  0x77, 0x00, 0x37, 0x55,
  // "·" (U+00B7)
  0x37, 0x01,
  // "¸" (U+00B8)
  0x04, 0x09, 0x55,
  // "¹" (U+00B9)
  0x05, 0x60, 0x45, 0x06, 0x21, 0x72,
  // "º" (U+00BA)
  0x07, 0x94, 0x5A, 0x28, 0x60,
  // "»" (U+00BB)
  0x02, 0x30, 0x09, 0x80, 0x0A, 0x91, 0x65, 0x30,
  // "¼" (U+00BC)
  0x00, 0x00, 0x51, 0x05, 0x60, 0x70, 0x04, 0x56, 0x10, 0x06, 0x27, 0x19, 0x17, 0x81, 0x68, 0x00,
  0x63, 0x79, 0x06, 0x00, 0x54,
  // "½" (U+00BD)
  0x00, 0x00, 0x51, 0x05, 0x60, 0x70, 0x04, 0x56, 0x10, 0x06, 0x2C, 0x60, 0x17, 0x83, 0x80, 0x00,
  0x64, 0x30, 0x06, 0x48, 0x50,
  // "¾" (U+00BE)
  0x00, 0x00, 0x51, 0x05, 0x70, 0x70, 0x03, 0x86, 0x10, 0x20, 0xA7, 0x19, 0x26, 0xA1, 0x68, 0x00,
  0x63, 0x79, 0x06, 0x00, 0x54,
  // "¿" (U+00BF)
  0x00, 0xA0, 0x02, 0x02, 0x42, 0x91, 0xA0, 0x0B, 0x08, 0x67, 0x30,
  // "À" (U+00C0)
  0x30, 0x55, 0x04, 0x03, 0x40, 0x30, 0xA4, 0x06, 0x0B, 0x38, 0x11, 0x5B, 0x38, 0x16, 0x0B, 0x38,
  0x1A, 0x7D, 0x28, 0x91, 0x52, 0x0B, 0x02, 0xC2, 0x2D, 0x50,
  // "Á" (U+00C1)
  0x40, 0x30, 0x24, 0x08, 0x40, 0x30, 0xA4, 0x06, 0x0B, 0x38, 0x11, 0x5B, 0x38, 0x16, 0x0B, 0x38,
  0x1A, 0x7D, 0x28, 0x91, 0x52, 0x0B, 0x02, 0xC2, 0x2D, 0x50,
  // "Â" (U+00C2)
  0x30, 0x20, 0x54, 0x00, 0x74, 0x03, 0x0A, 0x40, 0x60, 0xB3, 0x81, 0x15, 0xB3, 0x81, 0x60, 0xB3,
  0x81, 0xA7, 0xD2, 0x89, 0x15, 0x20, 0xB0, 0x2C, 0x22, 0xD5,
  // "Ã" (U+00C3)
  0x00, 0x06, 0x33, 0x00, 0x06, 0xF2, 0x00, 0x06, 0xB0, 0x00, 0x15, 0xB0, 0x00, 0x60, 0xB0, 0x00,
  0xA7, 0xD0, 0x05, 0x20, 0xB0, 0x2C, 0x22, 0xD5,
  // "Ä" (U+00C4)
  0x00, 0x04, 0x25, 0x00, 0x03, 0xA0, 0x00, 0x06, 0xB0, 0x00, 0x15, 0xB0, 0x00, 0x60, 0xB0, 0x00,
  0xA7, 0xD0, 0x05, 0x20, 0xB0, 0x2C, 0x22, 0xD5,
  // "Å" (U+00C5)
  0x00, 0x05, 0x40, 0x00, 0x09, 0xE0, 0x00, 0x06, 0xB0, 0x00, 0x15, 0xB0, 0x00, 0x60, 0xB0, 0x00,
  0xA7, 0xD0, 0x05, 0x20, 0xB0, 0x2C, 0x22, 0xD5,
  // "Æ" (U+00C6)
  0x48, 0x2B, 0xC7, 0xA3, 0x83, 0x28, 0x70, 0x33, 0x81, 0x76, 0x54, 0x83, 0x34, 0x98, 0x53, 0x81,
  0x97, 0xD4, 0x89, 0x44, 0x30, 0xC0, 0x21, 0x2C, 0x26, 0xC5, 0xB1,
  // "Ç" (U+00C7)
  0x01, 0x89, 0x60, 0xA1, 0x16, 0x39, 0x00, 0x06, 0x50, 0x00, 0x84, 0x00, 0x06, 0x50, 0x10, 0x1B,
  0xD5, 0x00, 0x09, 0x00, 0x05, 0x50, 0x00,
  // "È" (U+00C8)
  0x00, 0x50, 0x00, 0x04, 0x30, 0x0A, 0x97, 0x70, 0x83, 0x03, 0x0B, 0x00, 0x00, 0xD7, 0x30, 0x1B,
  0x00, 0x03, 0x80, 0x30, 0xA9, 0x69, 0x00,
  // "É" (U+00C9)
  0x00, 0x03, 0x20, 0x00, 0x80, 0x0A, 0x97, 0x70, 0x83, 0x03, 0x0B, 0x00, 0x00, 0xD7, 0x30, 0x1B,
  0x00, 0x03, 0x80, 0x30, 0xA9, 0x69, 0x00,
  // "Ê" (U+00CA)
  0x00, 0x25, 0x00, 0x07, 0x70, 0x0A, 0x97, 0x70, 0x83, 0x03, 0x0B, 0x00, 0x00, 0xD7, 0x30, 0x1B,
  0x00, 0x03, 0x80, 0x30, 0xA9, 0x69, 0x00,
  // "Ë" (U+00CB)
  0x04, 0x25, 0x00, 0xA9, 0x77, 0x08, 0x30, 0x30, 0xB0, 0x00, 0x0D, 0x73, 0x01, 0xB0, 0x00, 0x38,
  0x03, 0x0A, 0x96, 0x90,
  // "Ì" (U+00CC)
  0x05, 0x00, 0x43, 0x0A, 0xA0, 0x83, 0x0B, 0x00, 0xB0, 0x0A, 0x03, 0x80, 0xAA, 0x00,
  // "Í" (U+00CD)
  0x00, 0x32, 0x00, 0x80, 0x0A, 0xA0, 0x08, 0x30, 0x0B, 0x00, 0x0B, 0x00, 0x0A, 0x00, 0x38, 0x00,
  0xAA, 0x00,
  // "Î" (U+00CE)
  0x02, 0x50, 0x77, 0x0A, 0xA0, 0x83, 0x0B, 0x00, 0xB0, 0x0A, 0x03, 0x80, 0xAA, 0x00,
  // "Ï" (U+00CF)
  0x04, 0x25, 0x0A, 0xA0, 0x08, 0x30, 0x0B, 0x00, 0x0B, 0x00, 0x0A, 0x00, 0x38, 0x00, 0xAA, 0x00,
  // "Ð" (U+00D0)
  0x0A, 0x98, 0x40, 0x83, 0x0B, 0x0A, 0x00, 0xC3, 0xD7, 0x0C, 0x0B, 0x02, 0x93, 0x80, 0x93, 0xAA,
  0x86, 0x00,
  // "Ñ" (U+00D1)
  0x00, 0x63, 0x30, 0x0A, 0xA8, 0xA7, 0x06, 0xB0, 0x60, 0x06, 0xA1, 0x60, 0x06, 0x65, 0x60, 0x05,
  0x19, 0x60, 0x33, 0x0C, 0x50, 0xA5, 0x08, 0x20,
  // "Ò" (U+00D2)
  0x00, 0x05, 0x00, 0x00, 0x43, 0x01, 0x88, 0x60, 0xA1, 0x0C, 0x39, 0x00, 0xC7, 0x50, 0x0C, 0x84,
  0x01, 0xA6, 0x50, 0x83, 0x09, 0x76, 0x00,
  // "Ó" (U+00D3)
  0x00, 0x03, 0x20, 0x00, 0x80, 0x01, 0x88, 0x60, 0xA1, 0x0C, 0x39, 0x00, 0xC7, 0x50, 0x0C, 0x84,
  0x01, 0xA6, 0x50, 0x83, 0x09, 0x76, 0x00,
  // "Ô" (U+00D4)
  0x00, 0x25, 0x00, 0x07, 0x70, 0x01, 0x88, 0x60, 0xA1, 0x0C, 0x39, 0x00, 0xC7, 0x50, 0x0C, 0x84,
  0x01, 0xA6, 0x50, 0x83, 0x09, 0x76, 0x00,
  // "Õ" (U+00D5)
  0x00, 0x63, 0x30, 0x1B, 0xF8, 0x0A, 0x10, 0xC3, 0x90, 0x0C, 0x75, 0x00, 0xC8, 0x40, 0x1A, 0x65,
  0x08, 0x30, 0x97, 0x60,
  // "Ö" (U+00D6)
  0x00, 0x42, 0x50, 0x18, 0x86, 0x0A, 0x10, 0xC3, 0x90, 0x0C, 0x75, 0x00, 0xC8, 0x40, 0x1A, 0x65,
  0x08, 0x30, 0x97, 0x60,
  // "×" (U+00D7)
  0x20, 0x12, 0x08, 0x80, 0x08, 0x70, 0x32, 0x32,
  // "Ø" (U+00D8)
  0x01, 0x88, 0x90, 0xA1, 0x4C, 0x39, 0x06, 0xC7, 0x55, 0x1C, 0x84, 0x51, 0xA6, 0xA0, 0x83, 0x2B,
  0x76, 0x02, 0x00, 0x00,
  // "Ù" (U+00D9)
  0x00, 0x50, 0x00, 0x00, 0x43, 0x00, 0x0C, 0x80, 0xB4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B,
  0x00, 0x60, 0x38, 0x02, 0x30, 0x47, 0x06, 0x00, 0x0A, 0x85, 0x00,
  // "Ú" (U+00DA)
  0x00, 0x03, 0x20, 0x00, 0x08, 0x00, 0x0C, 0x80, 0xB4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B,
  0x00, 0x60, 0x38, 0x02, 0x30, 0x47, 0x06, 0x00, 0x0A, 0x85, 0x00,
  // "Û" (U+00DB)
  0x00, 0x02, 0x50, 0x00, 0x07, 0x70, 0x0C, 0x80, 0xB4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B,
  0x00, 0x60, 0x38, 0x02, 0x30, 0x47, 0x06, 0x00, 0x0A, 0x85, 0x00,
  // "Ü" (U+00DC)
  0x00, 0x42, 0x50, 0x0C, 0x80, 0xB4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B, 0x00, 0x60, 0x38,
  0x02, 0x30, 0x47, 0x06, 0x00, 0x0A, 0x85, 0x00,
  // "Ý" (U+00DD)
  0x00, 0x03, 0x20, 0x00, 0x80, 0x1E, 0x43, 0xC0, 0xA1, 0x42, 0x07, 0x56, 0x00, 0x3C, 0x10, 0x02,
  0x90, 0x00, 0x56, 0x00, 0x1B, 0x90, 0x00,
  // "Þ" (U+00DE)
  0x0A, 0xA0, 0x00, 0x89, 0x60, 0x0B, 0x0A, 0x10, 0xB0, 0x92, 0x0B, 0x0B, 0x03, 0xB7, 0x20, 0xAA,
  0x00, 0x00,
  // "ß" (U+00DF)
  0x00, 0x28, 0x91, 0x00, 0x91, 0x54, 0x02, 0xC6, 0x61, 0x01, 0xAA, 0x00, 0x04, 0x74, 0xA0, 0x06,
  0x61, 0xB0, 0x09, 0x58, 0x80, 0x0B, 0x00, 0x00, 0x75, 0x00, 0x00,
  // "à" (U+00E0)
  0x00, 0x50, 0x00, 0x43, 0x00, 0x00, 0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "á" (U+00E1)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "â" (U+00E2)
  0x00, 0x25, 0x00, 0x77, 0x00, 0x00, 0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "ã" (U+00E3)
  0x06, 0x33, 0x03, 0x82, 0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "ä" (U+00E4)
  0x04, 0x25, 0x00, 0x00, 0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "å" (U+00E5)
  0x00, 0x54, 0x00, 0x54, 0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "æ" (U+00E6)
  0x07, 0x69, 0x76, 0x47, 0x19, 0x47, 0x82, 0x5A, 0x60, 0x92, 0x96, 0x00, 0x59, 0x4B, 0x80,
  // "ç" (U+00E7)
  0x07, 0x95, 0x36, 0x12, 0x82, 0x00, 0x92, 0x00, 0x4E, 0x60, 0x09, 0x00, 0x55, 0x00,
  // "è" (U+00E8)
  0x00, 0x50, 0x00, 0x43, 0x00, 0x00, 0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3A, 0x60,
  // "é" (U+00E9)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3A, 0x60,
  // "ê" (U+00EA)
  0x00, 0x25, 0x00, 0x77, 0x00, 0x00, 0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3A, 0x60,
  // "ë" (U+00EB)
  0x04, 0x25, 0x00, 0x00, 0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3A, 0x60,
  // "ì" (U+00EC)
  0x05, 0x00, 0x43, 0x00, 0x02, 0xC0, 0x19, 0x04, 0x60, 0x64, 0x05, 0x80,
  // "í" (U+00ED)
  0x03, 0x20, 0x80, 0x00, 0x02, 0xC0, 0x19, 0x04, 0x60, 0x64, 0x05, 0x80,
  // "î" (U+00EE)
  0x25, 0x77, 0x00, 0x2C, 0x19, 0x46, 0x64, 0x58,
  // "ï" (U+00EF)
  0x42, 0x50, 0x00, 0x2C, 0x01, 0x90, 0x46, 0x06, 0x40, 0x58, 0x00,
  // "ð" (U+00F0)
  0x02, 0x85, 0x02, 0x74, 0x05, 0x79, 0x38, 0x0B, 0x83, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "ñ" (U+00F1)
  0x06, 0x33, 0x03, 0x82, 0x3C, 0x79, 0x1C, 0x0A, 0x47, 0x38, 0x74, 0x55, 0x91, 0x49,
  // "ò" (U+00F2)
  0x00, 0x50, 0x00, 0x43, 0x00, 0x00, 0x07, 0x75, 0x46, 0x0B, 0x82, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "ó" (U+00F3)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x07, 0x75, 0x46, 0x0B, 0x82, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "ô" (U+00F4)
  0x00, 0x25, 0x00, 0x77, 0x00, 0x00, 0x07, 0x75, 0x46, 0x0B, 0x82, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "õ" (U+00F5)
  0x06, 0x33, 0x03, 0x82, 0x07, 0x75, 0x46, 0x0B, 0x82, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "ö" (U+00F6)
  0x04, 0x25, 0x00, 0x00, 0x07, 0x75, 0x46, 0x0B, 0x82, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "÷" (U+00F7)
  0x05, 0x30, 0x48, 0x83, 0x00, 0x00, 0x05, 0x30,
  // "ø" (U+00F8)
  0x00, 0x03, 0x07, 0x88, 0x46, 0x8B, 0x87, 0x7A, 0x9A, 0x46, 0x78, 0x70, 0x30, 0x00,
  // "ù" (U+00F9)
  0x00, 0x50, 0x00, 0x43, 0x00, 0x00, 0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x69,
  // "ú" (U+00FA)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x69,
  // "û" (U+00FB)
  0x00, 0x25, 0x00, 0x77, 0x00, 0x00, 0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x69,
  // "ü" (U+00FC)
  0x04, 0x25, 0x00, 0x00, 0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x69,
  // "ý" (U+00FD)
  0x30, 0x30, 0x23, 0x08, 0x78, 0x79, 0x52, 0x70, 0x38, 0x07, 0x28, 0x1A, 0x52, 0x20, 0xA0, 0x73,
  0x09, 0x03, 0x20, 0x10, 0x82, 0x07, 0x08, 0x30,
  // "þ" (U+00FE)
  0x01, 0xD1, 0x00, 0x0B, 0x00, 0x00, 0xC8, 0x70, 0x3A, 0x0B, 0x05, 0x52, 0x90, 0x82, 0x64, 0x0B,
  0x67, 0x00, 0xB0, 0x00, 0x1C, 0x10, 0x00,
  // "ÿ" (U+00FF)
  0x00, 0x42, 0x50, 0x00, 0x00, 0x09, 0x52, 0x70, 0x38, 0x07, 0x00, 0xA5, 0x20, 0x0A, 0x70, 0x00,
  0x93, 0x00, 0x18, 0x00, 0x78, 0x00, 0x00,
  // "Ā" (U+0100)
  0x00, 0x0B, 0xF0, 0x00, 0x06, 0xB0, 0x00, 0x15, 0xB0, 0x00, 0x60, 0xB0, 0x00, 0xA7, 0xD0, 0x05,
  0x20, 0xB0, 0x2C, 0x22, 0xD5,
  // "ā" (U+0101)
  0x00, 0x77, 0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "Ă" (U+0102)
  0x00, 0x0B, 0xF0, 0x00, 0x06, 0xB0, 0x00, 0x15, 0xB0, 0x00, 0x60, 0xB0, 0x00, 0xA7, 0xD0, 0x05,
  0x20, 0xB0, 0x2C, 0x22, 0xD5,
  // "ă" (U+0103)
  0x00, 0x89, 0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x87,
  // "Ą" (U+0104)
  0x00, 0x03, 0xA0, 0x00, 0x06, 0xB0, 0x00, 0x15, 0xB0, 0x00, 0x60, 0xB0, 0x00, 0xA7, 0xD0, 0x05,
  0x20, 0xB0, 0x2C, 0x22, 0xF5, 0x00, 0x03, 0x50, 0x00, 0x02, 0x80,
  // "ą" (U+0105)
  0x07, 0x7A, 0x37, 0x19, 0x83, 0x46, 0xA1, 0x93, 0x69, 0x98, 0x03, 0x50, 0x02, 0x80,
  // "Ć" (U+0106)
  0x00, 0x03, 0x20, 0x00, 0x80, 0x01, 0x89, 0x60, 0xA1, 0x16, 0x39, 0x00, 0x06, 0x50, 0x00, 0x84,
  0x00, 0x06, 0x50, 0x10, 0x1A, 0x85, 0x00,
  // "ć" (U+0107)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x07, 0x95, 0x36, 0x12, 0x82, 0x00, 0x92, 0x00, 0x4A, 0x60,
  // "Ĉ" (U+0108)
  0x00, 0x25, 0x00, 0x07, 0x70, 0x01, 0x89, 0x60, 0xA1, 0x16, 0x39, 0x00, 0x06, 0x50, 0x00, 0x84,
  0x00, 0x06, 0x50, 0x10, 0x1A, 0x85, 0x00,
  // "ĉ" (U+0109)
  0x00, 0x25, 0x00, 0x77, 0x00, 0x00, 0x07, 0x95, 0x36, 0x12, 0x82, 0x00, 0x92, 0x00, 0x4A, 0x60,
  // "Ċ" (U+010A)
  0x00, 0x07, 0x00, 0x18, 0x96, 0x0A, 0x11, 0x63, 0x90, 0x00, 0x65, 0x00, 0x08, 0x40, 0x00, 0x65,
  0x01, 0x01, 0xA8, 0x50,
  // "ċ" (U+010B)
  0x00, 0x70, 0x00, 0x00, 0x07, 0x95, 0x36, 0x12, 0x82, 0x00, 0x92, 0x00, 0x4A, 0x60,
  // "Č" (U+010C)
  0x38, 0x13, 0x21, 0x30, 0x08, 0x28, 0x21, 0x89, 0x62, 0x85, 0xA1, 0x16, 0x03, 0x94, 0x06, 0x05,
  0x40, 0x80, 0x44, 0x82, 0x65, 0x01, 0x28, 0x21, 0xA8, 0x52,
  // "č" (U+010D)
  0x28, 0x13, 0x21, 0x20, 0x08, 0x78, 0x91, 0x79, 0x50, 0x36, 0x12, 0x08, 0x23, 0x09, 0x02, 0x38,
  0x14, 0xA6, 0x20,
  // "Ď" (U+010E)
  0x00, 0x32, 0x10, 0x08, 0x80, 0x0A, 0x98, 0x40, 0x83, 0x0B, 0x0B, 0x00, 0xC0, 0xB0, 0x0C, 0x0A,
  0x02, 0x93, 0x80, 0x93, 0xAA, 0x86, 0x00,
  // "ď" (U+010F)
  0x00, 0x0C, 0x73, 0x00, 0x0A, 0x30, 0x07, 0x7B, 0x00, 0x37, 0x19, 0x00, 0x83, 0x46, 0x00, 0xA1,
  0x93, 0x00, 0x69, 0x88, 0x00,
  // "Đ" (U+0110)
  0x0A, 0x98, 0x40, 0x83, 0x0B, 0x0A, 0x00, 0xC3, 0xD7, 0x0C, 0x0B, 0x02, 0x93, 0x80, 0x93, 0xAA,
  0x86, 0x00,
  // "đ" (U+0111)
  0x00, 0x0D, 0x20, 0x05, 0xC4, 0x07, 0x6B, 0x03, 0x72, 0x90, 0x82, 0x56, 0x0A, 0x1A, 0x30, 0x69,
  0x77, 0x00,
  // "Ē" (U+0112)
  0x0B, 0xFE, 0x70, 0x83, 0x03, 0x0B, 0x00, 0x00, 0xD7, 0x30, 0x1B, 0x00, 0x03, 0x80, 0x30, 0xA9,
  0x69, 0x00,
  // "ē" (U+0113)
  0x00, 0x77, 0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3A, 0x60,
  // "Ĕ" (U+0114)
  0x0A, 0xFF, 0x70, 0x83, 0x03, 0x0B, 0x00, 0x00, 0xD7, 0x30, 0x1B, 0x00, 0x03, 0x80, 0x30, 0xA9,
  0x69, 0x00,
  // "ĕ" (U+0115)
  0x00, 0x89, 0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3A, 0x60,
  // "Ė" (U+0116)
  0x00, 0x07, 0x00, 0xA9, 0x77, 0x08, 0x30, 0x30, 0xB0, 0x00, 0x0D, 0x73, 0x01, 0xB0, 0x00, 0x38,
  0x03, 0x0A, 0x96, 0x90,
  // "ė" (U+0117)
  0x00, 0x70, 0x00, 0x00, 0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3A, 0x60,
  // "Ę" (U+0118)
  0x0A, 0x97, 0x70, 0x83, 0x03, 0x0B, 0x00, 0x00, 0xD7, 0x30, 0x1B, 0x00, 0x03, 0x80, 0x30, 0xA9,
  0x79, 0x00, 0x35, 0x00, 0x02, 0x80, 0x00,
  // "ę" (U+0119)
  0x06, 0x93, 0x36, 0x74, 0x88, 0x50, 0x92, 0x00, 0x3B, 0x60, 0x35, 0x00, 0x28, 0x00,
  // "Ě" (U+011A)
  0x00, 0x32, 0x10, 0x08, 0x80, 0x0A, 0x97, 0x70, 0x83, 0x03, 0x0B, 0x00, 0x00, 0xD7, 0x30, 0x1B,
  0x00, 0x03, 0x80, 0x30, 0xA9, 0x69, 0x00,
  // "ě" (U+011B)
  0x28, 0x13, 0x21, 0x20, 0x08, 0x78, 0x92, 0x69, 0x30, 0x36, 0x74, 0x08, 0x85, 0x20, 0x90, 0x23,
  0x81, 0x3A, 0x62,
  // "Ĝ" (U+011C)
  0x00, 0x02, 0x50, 0x00, 0x77, 0x01, 0x88, 0xA0, 0xB1, 0x06, 0x39, 0x00, 0x07, 0x50, 0x00, 0x84,
  0x08, 0x76, 0x50, 0x83, 0x19, 0x7A, 0x00,
  // "ĝ" (U+011D)
  0x00, 0x25, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x72, 0x00, 0x89, 0x70, 0x02, 0x75, 0x50, 0x00,
  0xA6, 0x00, 0x05, 0x61, 0x00, 0x07, 0x8D, 0x00, 0x36, 0x08, 0x00, 0x19, 0x76, 0x00,
  // "Ğ" (U+011E)
  0x01, 0x8F, 0xF0, 0xB1, 0x06, 0x39, 0x00, 0x07, 0x50, 0x00, 0x84, 0x08, 0x76, 0x50, 0x83, 0x19,
  0x7A, 0x00,
  // "ğ" (U+011F)
  0x00, 0x08, 0xF2, 0x00, 0x89, 0x70, 0x02, 0x75, 0x50, 0x00, 0xA6, 0x00, 0x05, 0x61, 0x00, 0x07,
  0x8D, 0x00, 0x36, 0x08, 0x00, 0x19, 0x76, 0x00,
  // "Ġ" (U+0120)
  0x00, 0x07, 0x00, 0x18, 0x8A, 0x0B, 0x10, 0x63, 0x90, 0x00, 0x75, 0x00, 0x08, 0x40, 0x87, 0x65,
  0x08, 0x31, 0x97, 0xA0,
  // "ġ" (U+0121)
  0x00, 0x07, 0x00, 0x00, 0x00, 0x72, 0x00, 0x89, 0x70, 0x02, 0x75, 0x50, 0x00, 0xA6, 0x00, 0x05,
  0x61, 0x00, 0x07, 0x8D, 0x00, 0x36, 0x08, 0x00, 0x19, 0x76, 0x00,
  // "Ģ" (U+0122)
  0x01, 0x88, 0xA0, 0xB1, 0x06, 0x39, 0x00, 0x07, 0x50, 0x00, 0x84, 0x08, 0x76, 0x50, 0x83, 0x19,
  0x7A, 0x00, 0x22, 0x00, 0x06, 0x00, 0x00,
  // "ģ" (U+0123)
  0x00, 0x05, 0x20, 0x00, 0x00, 0x72, 0x00, 0x89, 0x70, 0x02, 0x75, 0x50, 0x00, 0xA6, 0x00, 0x05,
  0x61, 0x00, 0x07, 0x8D, 0x00, 0x36, 0x08, 0x00, 0x19, 0x76, 0x00,
  // "Ĥ" (U+0124)
  0x00, 0x02, 0x50, 0x00, 0x07, 0x70, 0x0A, 0xA0, 0xB9, 0x08, 0x30, 0x92, 0x0B, 0x00, 0xB0, 0x0C,
  0x77, 0xB0, 0x0A, 0x01, 0x90, 0x38, 0x04, 0x70, 0xAA, 0x1B, 0x90,
  // "ĥ" (U+0125)
  0x00, 0x25, 0x00, 0x77, 0x00, 0x00, 0x0C, 0x30, 0x0A, 0x00, 0x0B, 0x69, 0x0C, 0x0B, 0x37, 0x28,
  0x64, 0x55, 0x91, 0x49,
  // "Ħ" (U+0126)
  0x0A, 0xA0, 0xBA, 0x07, 0x40, 0x92, 0x1C, 0x65, 0xD4, 0x0C, 0x77, 0xC0, 0x0A, 0x01, 0x90, 0x38,
  0x04, 0x70, 0xAA, 0x1B, 0x90,
  // "ħ" (U+0127)
  0x0C, 0x30, 0x1C, 0x61, 0x0B, 0x88, 0x1C, 0x1A, 0x47, 0x37, 0x73, 0x55, 0x91, 0x49,
  // "Ĩ" (U+0128)
  0x06, 0x33, 0x0D, 0xF2, 0x08, 0x30, 0x0B, 0x00, 0x0B, 0x00, 0x0A, 0x00, 0x38, 0x00, 0xAA, 0x00,
  // "ĩ" (U+0129)
  0x63, 0x33, 0x82, 0x2C, 0x01, 0x90, 0x46, 0x06, 0x40, 0x58, 0x00,
  // "Ī" (U+012A)
  0x0F, 0xF0, 0x83, 0x0B, 0x00, 0xB0, 0x0A, 0x03, 0x80, 0xAA, 0x00,
  // "ī" (U+012B)
  0x07, 0x72, 0xC0, 0x19, 0x04, 0x60, 0x64, 0x05, 0x80,
  // "Ĭ" (U+012C)
  0x0F, 0xF0, 0x83, 0x0B, 0x00, 0xB0, 0x0A, 0x03, 0x80, 0xAA, 0x00,
  // "ĭ" (U+012D)
  0x08, 0x92, 0xC0, 0x19, 0x04, 0x60, 0x64, 0x05, 0x80,
  // "Į" (U+012E)
  0x00, 0xAA, 0x00, 0x83, 0x00, 0xB0, 0x00, 0xB0, 0x00, 0xA0, 0x03, 0x80, 0x0C, 0xA0, 0x35, 0x00,
  0x28, 0x00,
  // "į" (U+012F)
  0x00, 0x81, 0x00, 0x00, 0x02, 0xC0, 0x01, 0x90, 0x04, 0x70, 0x06, 0x40, 0x06, 0x80, 0x35, 0x00,
  0x28, 0x00,
  // "İ" (U+0130)
  0x00, 0x70, 0xAA, 0x08, 0x30, 0xB0, 0x0B, 0x00, 0xA0, 0x38, 0x0A, 0xA0,
  // "ı" (U+0131)
  0x2C, 0x19, 0x46, 0x64, 0x58,
  // "Ĳ" (U+0132)
  0x0A, 0xA0, 0xBA, 0x08, 0x30, 0x92, 0x0B, 0x00, 0xB0, 0x0B, 0x00, 0xB0, 0x0A, 0x02, 0x90, 0x38,
  0x04, 0x70, 0xAA, 0x07, 0x40, 0x00, 0x0A, 0x00, 0x00, 0x77, 0x00,
  // "ĳ" (U+0133)
  0x18, 0x28, 0x18, 0x15, 0x8A, 0x62, 0xC2, 0xC0, 0x19, 0x19, 0x04, 0x74, 0x70, 0x64, 0x74, 0x05,
  0x8A, 0x13, 0x0B, 0x30, 0x70, 0x52,
  // "Ĵ" (U+0134)
  0x00, 0x25, 0x00, 0x77, 0x00, 0xBA, 0x00, 0x92, 0x00, 0xB0, 0x00, 0xB0, 0x02, 0x90, 0x04, 0x70,
  0x07, 0x40, 0x0A, 0x00, 0x77, 0x00,
  // "ĵ" (U+0135)
  0x02, 0x50, 0x77, 0x00, 0x00, 0x2C, 0x01, 0x90, 0x47, 0x07, 0x40, 0x91, 0x0B, 0x07, 0x50,
  // "Ķ" (U+0136)
  0x0A, 0xA1, 0xD3, 0x08, 0x35, 0x20, 0x0B, 0x35, 0x00, 0x0C, 0xC2, 0x00, 0x0B, 0x66, 0x00, 0x38,
  0x2A, 0x00, 0xAA, 0x0A, 0x30, 0x02, 0x20, 0x00, 0x06, 0x00, 0x00,
  // "ķ" (U+0137)
  0x0B, 0x30, 0x00, 0xA0, 0x00, 0x0B, 0x2C, 0x11, 0x97, 0x00, 0x3B, 0x90, 0x06, 0x4B, 0x00, 0x91,
  0x66, 0x00, 0x22, 0x00, 0x06, 0x00, 0x00,
  // "ĸ" (U+0138)
  0x2C, 0x2B, 0x11, 0x97, 0x00, 0x4B, 0x90, 0x07, 0x4B, 0x00, 0x91, 0x66, 0x00,
  // "Ĺ" (U+0139)
  0x00, 0x32, 0x00, 0x80, 0x0A, 0xA0, 0x08, 0x30, 0x0B, 0x00, 0x0B, 0x00, 0x0A, 0x00, 0x38, 0x06,
  0xA9, 0x69,
  // "ĺ" (U+013A)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x0C, 0x30, 0x0A, 0x00, 0x0B, 0x00, 0x19, 0x00, 0x46, 0x00,
  0x64, 0x00, 0x58, 0x00,
  // "Ļ" (U+013B)
  0x0A, 0xA0, 0x08, 0x30, 0x0B, 0x00, 0x0B, 0x00, 0x0A, 0x00, 0x38, 0x06, 0xA9, 0x69, 0x02, 0x20,
  0x06, 0x00,
  // "ļ" (U+013C)
  0x0C, 0x30, 0xA0, 0x0B, 0x01, 0x90, 0x46, 0x06, 0x40, 0x58, 0x02, 0x20, 0x60, 0x00,
  // "Ľ" (U+013D)
  0x18, 0x6A, 0xA7, 0x20, 0x83, 0x32, 0x0B, 0x40, 0xB4, 0x0A, 0x38, 0x73, 0x80, 0x60, 0xA9, 0x69,
  0x10,
  // "ľ" (U+013E)
  0x0C, 0x73, 0x0A, 0x30, 0x0B, 0x00, 0x19, 0x00, 0x46, 0x00, 0x64, 0x00, 0x58, 0x00,
  // "Ŀ" (U+013F)
  0x0A, 0xA0, 0x08, 0x30, 0x0B, 0x00, 0x0B, 0x07, 0x0A, 0x00, 0x38, 0x06, 0xA9, 0x69,
  // "ŀ" (U+0140)
  0x0C, 0x30, 0xA0, 0x0B, 0x01, 0x97, 0x46, 0x06, 0x40, 0x58, 0x00,
  // "Ł" (U+0141)
  0x0A, 0xA0, 0x08, 0x30, 0x0B, 0x50, 0x1C, 0x30, 0x5A, 0x00, 0x38, 0x06, 0xA9, 0x69,
  // "ł" (U+0142)
  0x0C, 0x30, 0xA0, 0x0B, 0x01, 0xC2, 0x86, 0x06, 0x40, 0x58, 0x00,
  // "Ń" (U+0143)
  0x00, 0x03, 0x20, 0x00, 0x08, 0x00, 0x0A, 0x70, 0x87, 0x06, 0xB0, 0x60, 0x06, 0xA1, 0x60, 0x06,
  0x65, 0x60, 0x05, 0x19, 0x60, 0x33, 0x0C, 0x50, 0xA5, 0x08, 0x20,
  // "ń" (U+0144)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x3C, 0x79, 0x1C, 0x0A, 0x47, 0x38, 0x74, 0x55, 0x91, 0x49,
  // "Ņ" (U+0145)
  0x0A, 0x70, 0x87, 0x06, 0xB0, 0x60, 0x06, 0xA1, 0x60, 0x06, 0x65, 0x60, 0x05, 0x19, 0x60, 0x33,
  0x0C, 0x50, 0xA5, 0x08, 0x20, 0x02, 0x20, 0x00, 0x06, 0x00, 0x00,
  // "ņ" (U+0146)
  0x3C, 0x79, 0x1C, 0x0A, 0x47, 0x38, 0x74, 0x55, 0x91, 0x49, 0x02, 0x20, 0x06, 0x00,
  // "Ň" (U+0147)
  0x00, 0x03, 0x21, 0x00, 0x08, 0x80, 0x0A, 0x70, 0x87, 0x06, 0xB0, 0x60, 0x06, 0xA1, 0x60, 0x06,
  0x65, 0x60, 0x05, 0x19, 0x60, 0x33, 0x0C, 0x50, 0xA5, 0x08, 0x20,
  // "ň" (U+0148)
  0x00, 0x32, 0x10, 0x08, 0x80, 0x00, 0x00, 0x03, 0xC7, 0x90, 0x1C, 0x0A, 0x04, 0x73, 0x80, 0x74,
  0x55, 0x09, 0x14, 0x90,
  // "ŉ" (U+0149)
  0x0B, 0x00, 0x00, 0x70, 0x00, 0x14, 0xC7, 0x90, 0x1C, 0x0A, 0x04, 0x73, 0x80, 0x74, 0x55, 0x09,
  0x14, 0x90,
  // "Ŋ" (U+014A)
  0x0A, 0x70, 0x87, 0x06, 0xB0, 0x60, 0x06, 0xA1, 0x60, 0x06, 0x65, 0x60, 0x05, 0x29, 0x60, 0x33,
  0x0C, 0x40, 0xA5, 0x08, 0x10, 0x00, 0x06, 0x00, 0x00, 0x75, 0x00,
  // "ŋ" (U+014B)
  0x3C, 0x79, 0x1C, 0x0A, 0x47, 0x38, 0x74, 0x65, 0x91, 0x82, 0x00, 0xB0, 0x06, 0x60,
  // "Ō" (U+014C)
  0x01, 0x9F, 0xD0, 0xA1, 0x0C, 0x39, 0x00, 0xC7, 0x50, 0x0C, 0x84, 0x01, 0xA6, 0x50, 0x83, 0x09,
  0x76, 0x00,
  // "ō" (U+014D)
  0x00, 0x77, 0x07, 0x75, 0x46, 0x0B, 0x82, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "Ŏ" (U+014E)
  0x01, 0xFF, 0x60, 0xA1, 0x0C, 0x39, 0x00, 0xC7, 0x50, 0x0C, 0x84, 0x01, 0xA6, 0x50, 0x83, 0x09,
  0x76, 0x00,
  // "ŏ" (U+014F)
  0x00, 0x89, 0x07, 0x75, 0x46, 0x0B, 0x82, 0x0A, 0x91, 0x46, 0x48, 0x80,
  // "Ő" (U+0150)
  0x00, 0x07, 0x74, 0x01, 0x89, 0x70, 0x0A, 0x10, 0xC0, 0x39, 0x00, 0xC0, 0x75, 0x00, 0xC0, 0x84,
  0x01, 0xA0, 0x65, 0x08, 0x30, 0x09, 0x76, 0x00,
  // "ő" (U+0151)
  0x00, 0x77, 0x40, 0x00, 0x10, 0x07, 0x75, 0x04, 0x60, 0xB0, 0x82, 0x0A, 0x09, 0x14, 0x60, 0x48,
  0x80, 0x00,
  // "Œ" (U+0152)
  0x01, 0x99, 0xD8, 0xB0, 0xB1, 0x39, 0x04, 0x39, 0x05, 0x60, 0x07, 0x50, 0x88, 0x60, 0x84, 0x0B,
  0x10, 0x06, 0x50, 0xB0, 0x11, 0x09, 0x7D, 0x6B, 0x00,
  // "œ" (U+0153)
  0x07, 0x77, 0x7A, 0x46, 0x0E, 0x1B, 0x83, 0x1C, 0x71, 0x91, 0x4A, 0x00, 0x48, 0x79, 0x82,
  // "Ŕ" (U+0154)
  0x00, 0x03, 0x20, 0x00, 0x80, 0x0A, 0x99, 0x20, 0x82, 0x56, 0x0A, 0x08, 0x30, 0xC9, 0x60, 0x1A,
  0x65, 0x03, 0x83, 0x80, 0xAA, 0x1B, 0x10,
  // "ŕ" (U+0155)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x3B, 0x95, 0x1C, 0x00, 0x38, 0x00, 0x64, 0x00, 0x91, 0x00,
  // "Ŗ" (U+0156)
  0x0A, 0x99, 0x20, 0x82, 0x56, 0x0A, 0x08, 0x30, 0xC9, 0x60, 0x1A, 0x65, 0x03, 0x83, 0x80, 0xAA,
  0x1B, 0x10, 0x22, 0x00, 0x06, 0x00, 0x00,
  // "ŗ" (U+0157)
  0x3B, 0x95, 0x1C, 0x00, 0x38, 0x00, 0x64, 0x00, 0x91, 0x00, 0x22, 0x00, 0x60, 0x00,
  // "Ř" (U+0158)
  0x00, 0x32, 0x10, 0x08, 0x80, 0x0A, 0x99, 0x20, 0x82, 0x56, 0x0A, 0x08, 0x30, 0xC9, 0x60, 0x1A,
  0x65, 0x03, 0x83, 0x80, 0xAA, 0x1B, 0x10,
  // "ř" (U+0159)
  0x03, 0x21, 0x08, 0x80, 0x00, 0x00, 0x3B, 0x95, 0x1C, 0x00, 0x38, 0x00, 0x64, 0x00, 0x91, 0x00,
  // "Ś" (U+015A)
  0x00, 0x03, 0x20, 0x00, 0x80, 0x06, 0x7A, 0x00, 0xA0, 0x50, 0x0D, 0x10, 0x00, 0x6C, 0x00, 0x00,
  0x85, 0x08, 0x04, 0x60, 0x77, 0x80, 0x00,
  // "ś" (U+015B)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x18, 0xA1, 0x37, 0x20, 0x0B, 0x60, 0x40, 0xA0, 0x86, 0x60,
  // "Ŝ" (U+015C)
  0x00, 0x25, 0x00, 0x77, 0x06, 0x7A, 0x0A, 0x05, 0x0D, 0x10, 0x06, 0xC0, 0x00, 0x85, 0x80, 0x46,
  0x77, 0x80,
  // "ŝ" (U+015D)
  0x02, 0x50, 0x07, 0x70, 0x00, 0x00, 0x18, 0xA1, 0x37, 0x20, 0x0B, 0x60, 0x40, 0xA0, 0x86, 0x60,
  // "Ş" (U+015E)
  0x06, 0x7A, 0x0A, 0x05, 0x0D, 0x10, 0x06, 0xC0, 0x00, 0x85, 0x80, 0x46, 0x8B, 0x80, 0x09, 0x00,
  0x55, 0x00,
  // "ş" (U+015F)
  0x18, 0xA1, 0x37, 0x20, 0x0B, 0x60, 0x40, 0xA0, 0x8B, 0x60, 0x09, 0x00, 0x55, 0x00,
  // "Š" (U+0160)
  0x00, 0x32, 0x10, 0x08, 0x80, 0x06, 0x7A, 0x00, 0xA0, 0x50, 0x0D, 0x10, 0x00, 0x6C, 0x00, 0x00,
  0x85, 0x08, 0x04, 0x60, 0x77, 0x80, 0x00,
  // "š" (U+0161)
  0x03, 0x21, 0x08, 0x80, 0x00, 0x00, 0x18, 0xA1, 0x37, 0x20, 0x0B, 0x60, 0x40, 0xA0, 0x86, 0x60,
  // "Ţ" (U+0162)
  0x89, 0x02, 0xAC, 0x8B, 0x20, 0xA0, 0x32, 0x0B, 0x40, 0xA3, 0x03, 0x08, 0x30, 0x05, 0x28, 0x12,
  0xF8, 0x30, 0x93, 0x00, 0x53,
  // "ţ" (U+0163)
  0x09, 0x03, 0xD5, 0x1A, 0x04, 0x70, 0x64, 0x05, 0xE1, 0x09, 0x05, 0x50,
  // "Ť" (U+0164)
  0x00, 0x32, 0x10, 0x08, 0x80, 0x2A, 0xC8, 0xB2, 0x0A, 0x03, 0x00, 0xB0, 0x00, 0x0A, 0x00, 0x03,
  0x80, 0x00, 0x55, 0x00, 0x1B, 0x80, 0x00,
  // "ť" (U+0165)
  0x00, 0x44, 0x09, 0x20, 0x3D, 0x50, 0x1A, 0x00, 0x47, 0x00, 0x64, 0x00, 0x49, 0x10,
  // "Ŧ" (U+0166)
  0x2A, 0xC8, 0xB2, 0x0B, 0x03, 0x00, 0xB0, 0x01, 0x7D, 0x60, 0x03, 0x80, 0x00, 0x55, 0x00, 0x1B,
  0x80, 0x00,
  // "ŧ" (U+0167)
  0x09, 0x03, 0xD5, 0x0A, 0x05, 0xB2, 0x65, 0x05, 0x91,
  // "Ũ" (U+0168)
  0x00, 0x63, 0x30, 0x0C, 0xB8, 0xD4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B, 0x00, 0x60, 0x38,
  0x02, 0x30, 0x47, 0x06, 0x00, 0x0A, 0x85, 0x00,
  // "ũ" (U+0169)
  0x00, 0x63, 0x30, 0x03, 0x82, 0x3C, 0x0B, 0x01, 0x90, 0xA0, 0x47, 0x38, 0x06, 0x48, 0x50, 0x59,
  0x69, 0x00,
  // "Ū" (U+016A)
  0x0C, 0x98, 0xF4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B, 0x00, 0x60, 0x38, 0x02, 0x30, 0x47,
  0x06, 0x00, 0x0A, 0x85, 0x00,
  // "ū" (U+016B)
  0x00, 0x77, 0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x69,
  // "Ŭ" (U+016C)
  0x0C, 0xFA, 0xB4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B, 0x00, 0x60, 0x38, 0x02, 0x30, 0x47,
  0x06, 0x00, 0x0A, 0x85, 0x00,
  // "ŭ" (U+016D)
  0x00, 0x89, 0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x69,
  // "Ů" (U+016E)
  0x00, 0x05, 0x40, 0x0C, 0x86, 0xF4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B, 0x00, 0x60, 0x38,
  0x02, 0x30, 0x47, 0x06, 0x00, 0x0A, 0x85, 0x00,
  // "ů" (U+016F)
  0x00, 0x54, 0x00, 0x54, 0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x69,
  // "Ű" (U+0170)
  0x00, 0x07, 0x74, 0x0C, 0x81, 0xC4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B, 0x00, 0x60, 0x38,
  0x02, 0x30, 0x47, 0x06, 0x00, 0x0A, 0x85, 0x00,
  // "ű" (U+0171)
  0x00, 0x77, 0x40, 0x00, 0x10, 0x3C, 0x0B, 0x01, 0x90, 0xA0, 0x47, 0x38, 0x06, 0x48, 0x50, 0x59,
  0x69, 0x00,
  // "Ų" (U+0172)
  0x0C, 0x80, 0xB4, 0x0A, 0x10, 0x60, 0x0B, 0x00, 0x60, 0x0B, 0x00, 0x60, 0x38, 0x02, 0x30, 0x47,
  0x06, 0x00, 0x0A, 0x95, 0x00, 0x03, 0x50, 0x00, 0x02, 0x80, 0x00,
  // "ų" (U+0173)
  0x3C, 0x0B, 0x19, 0x0A, 0x47, 0x38, 0x64, 0x85, 0x59, 0x79, 0x03, 0x50, 0x02, 0x80,
  // "Ŵ" (U+0174)
  0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x77, 0x00, 0x1D, 0x50, 0xA0, 0x78, 0x0B, 0x04, 0xC0, 0x60,
  0x0A, 0x17, 0xB0, 0x70, 0x0A, 0x25, 0xB3, 0x30, 0x09, 0x81, 0xB7, 0x00, 0x09, 0x80, 0xA6, 0x00,
  0x08, 0x50, 0xB2, 0x00,
  // "ŵ" (U+0175)
  0x30, 0x20, 0x54, 0x00, 0x77, 0x8B, 0x35, 0x81, 0xB0, 0x82, 0x85, 0xA0, 0x62, 0x85, 0x94, 0x12,
  0xA2, 0xA5, 0x02, 0xA0, 0xB1, 0x10,
  // "Ŷ" (U+0176)
  0x00, 0x25, 0x00, 0x07, 0x70, 0x1E, 0x43, 0xC0, 0xA1, 0x42, 0x07, 0x56, 0x00, 0x3C, 0x10, 0x02,
  0x90, 0x00, 0x56, 0x00, 0x1B, 0x90, 0x00,
  // "ŷ" (U+0177)
  0x20, 0x20, 0x53, 0x00, 0x77, 0x87, 0x95, 0x27, 0x03, 0x80, 0x72, 0x81, 0xA5, 0x22, 0x0A, 0x07,
  0x30, 0x90, 0x32, 0x01, 0x08, 0x20, 0x70, 0x83,
  // "Ÿ" (U+0178)
  0x00, 0x42, 0x51, 0xE4, 0x3C, 0x0A, 0x14, 0x20, 0x75, 0x60, 0x03, 0xC1, 0x00, 0x29, 0x00, 0x05,
  0x60, 0x01, 0xB9, 0x00,
  // "Ź" (U+0179)
  0x00, 0x03, 0x20, 0x00, 0x80, 0x0B, 0x6B, 0x61, 0x21, 0xC0, 0x00, 0x94, 0x00, 0x3B, 0x00, 0x0B,
  0x20, 0x05, 0x80, 0x30, 0xE7, 0x79, 0x00,
  // "ź" (U+017A)
  0x00, 0x32, 0x00, 0x80, 0x00, 0x00, 0x2A, 0xC4, 0x11, 0xA0, 0x09, 0x20, 0x48, 0x10, 0xC8, 0xA0,
  // "Ż" (U+017B)
  0x00, 0x70, 0x00, 0xB6, 0xB6, 0x12, 0x1C, 0x00, 0x09, 0x40, 0x03, 0xB0, 0x00, 0xB2, 0x00, 0x58,
  0x03, 0x0E, 0x77, 0x90,
  // "ż" (U+017C)
  0x00, 0x70, 0x00, 0x00, 0x2A, 0xC4, 0x11, 0xA0, 0x09, 0x20, 0x48, 0x10, 0xC8, 0xA0,
  // "Ž" (U+017D)
  0x00, 0x32, 0x10, 0x08, 0x80, 0x0B, 0x6B, 0x61, 0x21, 0xC0, 0x00, 0x94, 0x00, 0x3B, 0x00, 0x0B,
  0x20, 0x05, 0x80, 0x30, 0xE7, 0x79, 0x00,
  // "ž" (U+017E)
  0x00, 0x32, 0x10, 0x08, 0x80, 0x00, 0x00, 0x02, 0xAC, 0x40, 0x11, 0xA0, 0x00, 0x92, 0x00, 0x48,
  0x10, 0x0C, 0x8A, 0x00,
  // "ſ" (U+017F)
  0x28, 0x13, 0x96, 0x28, 0x1A, 0x11, 0x20, 0xB3, 0x01, 0x0A, 0x30, 0x40, 0x73, 0x07, 0x04, 0x30,
  0x90, 0x13, 0x0A, 0x30, 0x70, 0x53,
  // "Ω" (U+03A9)
  0x03, 0x87, 0x70, 0x0B, 0x00, 0xB1, 0x38, 0x00, 0xA1, 0x57, 0x00, 0xC0, 0x2A, 0x07, 0x60, 0x36,
  0x74, 0x30, 0xDB, 0x8B, 0x80,
  // "μ" (U+03BC)
  0x0B, 0x0B, 0x19, 0x0B, 0x47, 0x28, 0x74, 0x65, 0x8A, 0x89, 0x80, 0x00, 0xB0, 0x00,
  // "π" (U+03C0)
  0x4C, 0xBC, 0x61, 0x60, 0x60, 0x07, 0x25, 0x02, 0x65, 0x20, 0xA1, 0x57, 0x00,
  // "–" (U+2013)
  0x78, 0x87,
  // "—" (U+2014)
  0x78, 0x88, 0x88, 0x87,
  // "€" (U+20AC)
  0x00, 0x7A, 0x20, 0x63, 0x21, 0x0A, 0x00, 0x03, 0xC6, 0x00, 0x6B, 0x40, 0x03, 0x70, 0x00, 0x0A,
  0x72, 0x00,
  // "₿" (U+20BF)
  0x00, 0x04, 0x30, 0x0C, 0x87, 0x00, 0xB0, 0xC0, 0x0C, 0x2A, 0x01, 0xCC, 0x20, 0x47, 0x56, 0x06,
  0x56, 0x51, 0xC8, 0x80, 0x01, 0x60, 0x00,
  // "‘" (U+2018)
  0x02, 0x07, 0x1A,
  // "’" (U+2019)
  0x0B, 0x07, 0x11,
  // "‚" (U+201A)
  0x0B, 0x07, 0x12,
  // "‛" (U+201B)
  0xB7, 0x20,
  // "“" (U+201C)
  0x02, 0x12, 0x07, 0x70, 0x1A, 0xA1,
  // "”" (U+201D)
  0x0C, 0x74, 0x07, 0x43, 0x11, 0x30,
  // "„" (U+201E)
  0x0B, 0x75, 0x07, 0x34, 0x12, 0x30,
  // "‟" (U+201F)
  0xBC, 0x77, 0x22,
  // "†" (U+2020)
  0x20, 0x93, 0x87, 0x60, 0x39, 0x93, 0x08, 0x32, 0x09, 0x30, 0x73, 0x05, 0x20, 0x10, 0x32,
  // "‡" (U+2021)
  0x00, 0x90, 0x14, 0x82, 0x16, 0x61, 0x05, 0x10, 0x06, 0x00, 0x29, 0x10, 0x69, 0x40, 0x35, 0x00,
  // "•" (U+2022)
  0x18, 0x07, 0xF5, 0x4E, 0x20,
  // "…" (U+2026)
  0x10, 0x10, 0x10, 0x92, 0x91, 0x91,
  // "‰" (U+2030)
  0x07, 0x80, 0x61, 0x00, 0x02, 0x69, 0x06, 0x00, 0x00, 0x53, 0x96, 0x10, 0x00, 0x06, 0x29, 0x65,
  0x50, 0x64, 0x17, 0x83, 0x68, 0x71, 0x80, 0x16, 0x62, 0x89, 0x07, 0x07, 0x03, 0x74, 0x76, 0x10,
  // "‹" (U+2039)
  0x02, 0x18, 0x64, 0x06,
  // "›" (U+203A)
  0x02, 0x09, 0x0A, 0x61,
  // "⁄" (U+2044)
  0x30, 0x50, 0x13, 0x07, 0x30, 0x60, 0x13, 0x07, 0x30, 0x60, 0x13, 0x06, 0x30, 0x64,
  // "™" (U+2122)
  0x2E, 0xCC, 0x0B, 0x11, 0x62, 0x79, 0xA0, 0x0A, 0x6B, 0x9C, 0x10,
  // "⅒" (U+2152)
  0x40, 0x50, 0x14, 0x82, 0x56, 0x07, 0x58, 0x24, 0x56, 0x15, 0x89, 0x76, 0x2C, 0x60, 0x46, 0x01,
  0x78, 0x55, 0x27, 0x71, 0x28, 0x46, 0x62, 0x54, 0x92, 0x85, 0x62, 0x72, 0x16, 0x31,
  // "ﬁ" (U+FB01)
  0x00, 0x38, 0xA0, 0x0A, 0x01, 0x02, 0xD8, 0xB0, 0x19, 0x29, 0x03, 0x74, 0x60, 0x64, 0x73, 0x09,
  0x16, 0x70, 0xB0, 0x00, 0x75, 0x00, 0x00,
  // "ﬂ" (U+FB02)
  0x00, 0x39, 0xD2, 0x00, 0xA0, 0xB0, 0x02, 0xD4, 0xA0, 0x01, 0x91, 0x90, 0x03, 0x74, 0x60, 0x06,
  0x47, 0x30, 0x09, 0x16, 0x80, 0x0B, 0x00, 0x00, 0x75, 0x00, 0x00,
};

const Font& font_NotoSerif_CondensedItalic_8() {
  static SmoothFont font(font_NotoSerif_CondensedItalic_8_data);
  return font;
}

}  // namespace roo_display
