#include "40.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-CondensedItalic (Noto Serif Condensed Italic)
// Generated on Wed Nov 19 19:11:52 CET 2025
static const uint8_t font_NotoSerif_CondensedItalic_40_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x13, 0xE0,
  0xF7, 0xF7, 0x2B, 0x27, 0x1F, 0xF6, 0x08, 0x02, 0x2D, 0x0A, 0x0B, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x02, 0x01, 0x0B, 0x1D, 0x0C, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x05, 0x15, 0x10, 0x1D, 0x0E, 0x00, 0x4F, // """ (U+0022)
  0x00, 0x23, 0x01, 0x01, 0x13, 0x1D, 0x13, 0x00, 0x83, // "#" (U+0023)
  0x00, 0x24, 0x01, 0xFE, 0x13, 0x1F, 0x14, 0x01, 0x37, // "$" (U+0024)
  0x00, 0x25, 0x02, 0x01, 0x1D, 0x1D, 0x1F, 0x02, 0x04, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x01, 0x1A, 0x1D, 0x1A, 0x03, 0x27, // "&" (U+0026)
  0x00, 0x27, 0x45, 0x15, 0x09, 0x1D, 0x08, 0x04, 0x07, // "'" (U+0027)
  0x00, 0x28, 0x01, 0xFC, 0x0E, 0x1F, 0x0C, 0x04, 0x1E, // "(" (U+0028)
  0x00, 0x29, 0xFE, 0xFB, 0x0B, 0x1E, 0x0C, 0x04, 0x9F, // ")" (U+0029)
  0x00, 0x2A, 0x04, 0x10, 0x13, 0x1F, 0x12, 0x05, 0x1D, // "*" (U+002A)
  0x00, 0x2B, 0x02, 0x07, 0x10, 0x17, 0x13, 0x05, 0x7E, // "+" (U+002B)
  0x00, 0x2C, 0xFF, 0xFB, 0x05, 0x05, 0x09, 0x05, 0xBA, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x0B, 0x0A, 0x0D, 0x0B, 0x05, 0xDF, // "-" (U+002D)
  0x00, 0x2E, 0x41, 0x01, 0x05, 0x05, 0x09, 0x05, 0xEA, // "." (U+002E)
  0x00, 0x2F, 0xFC, 0xFC, 0x0D, 0x1F, 0x0A, 0x05, 0xF7, // "/" (U+002F)
  0x00, 0x30, 0x01, 0x01, 0x13, 0x1D, 0x14, 0x06, 0x7E, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x0F, 0x1D, 0x14, 0x07, 0x2D, // "1" (U+0031)
  0x00, 0x32, 0xFF, 0x01, 0x12, 0x1D, 0x14, 0x07, 0xA1, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x12, 0x1D, 0x14, 0x08, 0x32, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x12, 0x1D, 0x14, 0x08, 0xD0, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x13, 0x1D, 0x14, 0x09, 0x65, // "5" (U+0035)
  0x00, 0x36, 0x02, 0x01, 0x14, 0x1D, 0x14, 0x09, 0xF8, // "6" (U+0036)
  0x00, 0x37, 0x03, 0x01, 0x14, 0x1D, 0x14, 0x0A, 0x9F, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x13, 0x1D, 0x14, 0x0B, 0x18, // "8" (U+0038)
  0x00, 0x39, 0x01, 0x01, 0x12, 0x1D, 0x14, 0x0B, 0xD4, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x09, 0x16, 0x0A, 0x0C, 0x77, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFC, 0x09, 0x16, 0x0A, 0x0C, 0x9A, // ";" (U+003B)
  0x00, 0x3C, 0x02, 0x05, 0x10, 0x18, 0x13, 0x0C, 0xD2, // "<" (U+003C)
  0x00, 0x3D, 0x02, 0x0A, 0x11, 0x13, 0x13, 0x0D, 0x2C, // "=" (U+003D)
  0x00, 0x3E, 0x02, 0x05, 0x10, 0x18, 0x13, 0x0D, 0x3E, // ">" (U+003E)
  0x00, 0x3F, 0x04, 0x01, 0x12, 0x1D, 0x11, 0x0D, 0x98, // "?" (U+003F)
  0x00, 0x40, 0x02, 0xFC, 0x1E, 0x1D, 0x20, 0x0E, 0x12, // "@" (U+0040)
  0x00, 0x41, 0xFE, 0x01, 0x16, 0x1D, 0x19, 0x0F, 0x64, // "A" (U+0041)
  0x00, 0x42, 0xFF, 0x01, 0x16, 0x1D, 0x17, 0x10, 0x13, // "B" (U+0042)
  0x00, 0x43, 0x02, 0x01, 0x17, 0x1D, 0x16, 0x10, 0xCF, // "C" (U+0043)
  0x00, 0x44, 0xFF, 0x01, 0x18, 0x1D, 0x19, 0x11, 0x6C, // "D" (U+0044)
  0x00, 0x45, 0xFF, 0x01, 0x16, 0x1D, 0x16, 0x12, 0x2D, // "E" (U+0045)
  0x00, 0x46, 0xFF, 0x01, 0x16, 0x1D, 0x14, 0x12, 0xC0, // "F" (U+0046)
  0x00, 0x47, 0x02, 0x01, 0x18, 0x1D, 0x19, 0x13, 0x45, // "G" (U+0047)
  0x00, 0x48, 0xFF, 0x01, 0x1E, 0x1D, 0x1B, 0x13, 0xF8, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x0F, 0x1D, 0x0D, 0x14, 0xC1, // "I" (U+0049)
  0x00, 0x4A, 0xFA, 0xF7, 0x0F, 0x1D, 0x0D, 0x15, 0x28, // "J" (U+004A)
  0x00, 0x4B, 0xFF, 0x01, 0x1B, 0x1D, 0x18, 0x15, 0xCA, // "K" (U+004B)
  0x00, 0x4C, 0xFF, 0x01, 0x13, 0x1D, 0x16, 0x16, 0x94, // "L" (U+004C)
  0x00, 0x4D, 0xFF, 0x01, 0x23, 0x1D, 0x20, 0x17, 0x1C, // "M" (U+004D)
  0x00, 0x4E, 0xFF, 0x01, 0x1D, 0x1D, 0x1A, 0x18, 0x53, // "N" (U+004E)
  0x00, 0x4F, 0x02, 0x01, 0x19, 0x1D, 0x1A, 0x19, 0x43, // "O" (U+004F)
  0x00, 0x50, 0xFF, 0x01, 0x15, 0x1D, 0x16, 0x1A, 0x03, // "P" (U+0050)
  0x00, 0x51, 0x02, 0xF8, 0x19, 0x1D, 0x1A, 0x1A, 0x9E, // "Q" (U+0051)
  0x00, 0x52, 0xFF, 0x01, 0x16, 0x1D, 0x17, 0x1B, 0x86, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x13, 0x1D, 0x13, 0x1C, 0x46, // "S" (U+0053)
  0x00, 0x54, 0x03, 0x01, 0x18, 0x1D, 0x15, 0x1C, 0xEB, // "T" (U+0054)
  0x00, 0x55, 0x03, 0x01, 0x1C, 0x1D, 0x19, 0x1D, 0x79, // "U" (U+0055)
  0x00, 0x56, 0x03, 0x01, 0x1B, 0x1D, 0x17, 0x1E, 0x3F, // "V" (U+0056)
  0x00, 0x57, 0x03, 0x01, 0x27, 0x1D, 0x24, 0x1E, 0xF2, // "W" (U+0057)
  0x00, 0x58, 0xFE, 0x01, 0x19, 0x1D, 0x17, 0x20, 0x26, // "X" (U+0058)
  0x00, 0x59, 0x03, 0x01, 0x19, 0x1D, 0x16, 0x20, 0xE3, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x16, 0x1D, 0x15, 0x21, 0x7C, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFC, 0x0F, 0x1F, 0x0D, 0x22, 0x19, // "[" (U+005B)
  0x00, 0x5C, 0x44, 0xFC, 0x07, 0x1F, 0x0A, 0x22, 0x95, // "\" (U+005C)
  0x00, 0x5D, 0xFE, 0xFC, 0x0D, 0x1F, 0x0D, 0x22, 0xDD, // "]" (U+005D)
  0x00, 0x5E, 0x02, 0x0C, 0x11, 0x1D, 0x13, 0x23, 0x5B, // "^" (U+005E)
  0x00, 0x5F, 0xFC, 0xFB, 0x0D, 0xFC, 0x10, 0x23, 0xBB, // "_" (U+005F)
  0x00, 0x60, 0x05, 0x19, 0x0B, 0x1F, 0x0A, 0x23, 0xC4, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x13, 0x16, 0x14, 0x23, 0xDA, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x12, 0x1F, 0x14, 0x24, 0x69, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x11, 0x16, 0x11, 0x25, 0x16, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x15, 0x1F, 0x14, 0x25, 0x7D, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x11, 0x16, 0x11, 0x26, 0x31, // "e" (U+0065)
  0x00, 0x66, 0xFB, 0xF7, 0x11, 0x1F, 0x0B, 0x26, 0xA8, // "f" (U+0066)
  0x00, 0x67, 0xFE, 0xF7, 0x15, 0x17, 0x13, 0x27, 0x5D, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x14, 0x1F, 0x15, 0x28, 0x35, // "h" (U+0068)
  0x00, 0x69, 0x02, 0x01, 0x0A, 0x1F, 0x0B, 0x28, 0xDC, // "i" (U+0069)
  0x00, 0x6A, 0xFB, 0xF7, 0x0A, 0x1F, 0x0A, 0x29, 0x2F, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x15, 0x1F, 0x14, 0x29, 0xB6, // "k" (U+006B)
  0x00, 0x6C, 0x02, 0x01, 0x0B, 0x1F, 0x0B, 0x2A, 0x67, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x1E, 0x16, 0x1F, 0x2A, 0xC4, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x14, 0x16, 0x15, 0x2B, 0x92, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x12, 0x16, 0x14, 0x2C, 0x1A, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xF7, 0x13, 0x16, 0x14, 0x2C, 0x9F, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xF7, 0x13, 0x16, 0x14, 0x2D, 0x4F, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x11, 0x16, 0x11, 0x2E, 0x04, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x0F, 0x16, 0x10, 0x2E, 0x66, // "s" (U+0073)
  0x00, 0x74, 0x02, 0x01, 0x0D, 0x1B, 0x0D, 0x2E, 0xD3, // "t" (U+0074)
  0x00, 0x75, 0x02, 0x01, 0x14, 0x16, 0x15, 0x2F, 0x2C, // "u" (U+0075)
  0x00, 0x76, 0x01, 0x00, 0x12, 0x16, 0x13, 0x2F, 0xB7, // "v" (U+0076)
  0x00, 0x77, 0x02, 0x00, 0x1C, 0x16, 0x1D, 0x30, 0x39, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x14, 0x16, 0x13, 0x31, 0x1B, // "x" (U+0078)
  0x00, 0x79, 0xFA, 0xF7, 0x11, 0x16, 0x13, 0x31, 0x9F, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x11, 0x16, 0x12, 0x32, 0x4C, // "z" (U+007A)
  0x00, 0x7B, 0x02, 0xFC, 0x11, 0x1F, 0x0F, 0x32, 0xC1, // "{" (U+007B)
  0x00, 0x7C, 0x48, 0xF7, 0x0A, 0x1F, 0x13, 0x33, 0x45, // "|" (U+007C)
  0x00, 0x7D, 0xFE, 0xFC, 0x0D, 0x1F, 0x0F, 0x33, 0x83, // "}" (U+007D)
  0x00, 0x7E, 0x02, 0x0C, 0x11, 0x12, 0x13, 0x34, 0x07, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFA, 0x09, 0x16, 0x0C, 0x34, 0x39, // "¡" (U+00A1)
  0x00, 0xA2, 0x03, 0x01, 0x13, 0x1D, 0x14, 0x34, 0x8B, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x14, 0x1D, 0x14, 0x35, 0x2E, // "£" (U+00A3)
  0x00, 0xA4, 0x03, 0x08, 0x14, 0x18, 0x16, 0x35, 0xC1, // "¤" (U+00A4)
  0x00, 0xA5, 0x02, 0x01, 0x17, 0x1D, 0x14, 0x36, 0x33, // "¥" (U+00A5)
  0x00, 0xA6, 0x08, 0xF7, 0x0A, 0x1F, 0x13, 0x36, 0xCD, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0xFD, 0x12, 0x1F, 0x13, 0x37, 0x02, // "§" (U+00A7)
  0x00, 0xA8, 0x47, 0x1B, 0x11, 0x1E, 0x14, 0x37, 0xC5, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x1A, 0x1E, 0x1D, 0x37, 0xDB, // "©" (U+00A9)
  0x00, 0xAA, 0x02, 0x11, 0x0E, 0x1D, 0x0E, 0x38, 0xEF, // "ª" (U+00AA)
  0x00, 0xAB, 0x02, 0x04, 0x11, 0x12, 0x12, 0x39, 0x3D, // "«" (U+00AB)
  0x00, 0xAC, 0x02, 0x05, 0x10, 0x0F, 0x13, 0x39, 0x9C, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x1A, 0x1E, 0x1D, 0x39, 0xB9, // "®" (U+00AE)
  0x00, 0xAF, 0x04, 0x20, 0x14, 0x21, 0x10, 0x3A, 0xDC, // "¯" (U+00AF)
  0x00, 0xB0, 0x05, 0x12, 0x0F, 0x1D, 0x0E, 0x3A, 0xE4, // "°" (U+00B0)
  0x00, 0xB1, 0x02, 0x01, 0x11, 0x17, 0x13, 0x3B, 0x1C, // "±" (U+00B1)
  0x00, 0xB2, 0x02, 0x10, 0x0F, 0x21, 0x0E, 0x3B, 0x55, // "²" (U+00B2)
  0x00, 0xB3, 0x03, 0x10, 0x0F, 0x21, 0x0E, 0x3B, 0xAC, // "³" (U+00B3)
  0x00, 0xB4, 0x04, 0x19, 0x0C, 0x1F, 0x0A, 0x3C, 0x08, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xF7, 0x13, 0x16, 0x15, 0x3C, 0x25, // "µ" (U+00B5)
  0x00, 0xB6, 0x02, 0xFD, 0x17, 0x1F, 0x19, 0x3C, 0xD5, // "¶" (U+00B6)
  0x00, 0xB7, 0x43, 0x0D, 0x07, 0x11, 0x0A, 0x3D, 0xA1, // "·" (U+00B7)
  0x00, 0xB8, 0x01, 0xF7, 0x09, 0x00, 0x0B, 0x3D, 0xAE, // "¸" (U+00B8)
  0x00, 0xB9, 0x03, 0x10, 0x0C, 0x22, 0x0E, 0x3D, 0xCF, // "¹" (U+00B9)
  0x00, 0xBA, 0x03, 0x11, 0x0F, 0x1D, 0x0E, 0x3E, 0x11, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x04, 0x0F, 0x12, 0x12, 0x3E, 0x5E, // "»" (U+00BB)
  0x00, 0xBC, 0x03, 0x01, 0x1D, 0x1E, 0x1F, 0x3E, 0xBF, // "¼" (U+00BC)
  0x00, 0xBD, 0x03, 0x01, 0x1D, 0x1E, 0x1F, 0x3F, 0xBD, // "½" (U+00BD)
  0x00, 0xBE, 0x03, 0x01, 0x1D, 0x1D, 0x1F, 0x40, 0xB7, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFA, 0x0D, 0x16, 0x11, 0x41, 0xC9, // "¿" (U+00BF)
  0x00, 0xC0, 0xFE, 0x01, 0x16, 0x26, 0x19, 0x42, 0x3C, // "À" (U+00C0)
  0x00, 0xC1, 0xFE, 0x01, 0x16, 0x26, 0x19, 0x43, 0x0B, // "Á" (U+00C1)
  0x00, 0xC2, 0xFE, 0x01, 0x16, 0x26, 0x19, 0x43, 0xDE, // "Â" (U+00C2)
  0x00, 0xC3, 0xFE, 0x01, 0x17, 0x24, 0x19, 0x44, 0xB6, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFE, 0x01, 0x16, 0x25, 0x19, 0x45, 0x8D, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFE, 0x01, 0x16, 0x23, 0x19, 0x46, 0x59, // "Å" (U+00C5)
  0x00, 0xC6, 0xFE, 0x01, 0x22, 0x1D, 0x21, 0x47, 0x2E, // "Æ" (U+00C6)
  0x00, 0xC7, 0x02, 0xF7, 0x17, 0x1D, 0x16, 0x48, 0x21, // "Ç" (U+00C7)
  0x00, 0xC8, 0xFF, 0x01, 0x16, 0x26, 0x16, 0x48, 0xE9, // "È" (U+00C8)
  0x00, 0xC9, 0xFF, 0x01, 0x16, 0x26, 0x16, 0x49, 0x9B, // "É" (U+00C9)
  0x00, 0xCA, 0xFF, 0x01, 0x16, 0x26, 0x16, 0x4A, 0x53, // "Ê" (U+00CA)
  0x00, 0xCB, 0xFF, 0x01, 0x16, 0x25, 0x16, 0x4B, 0x10, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x0F, 0x26, 0x0D, 0x4B, 0xC1, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x10, 0x26, 0x0D, 0x4C, 0x44, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x0F, 0x26, 0x0D, 0x4C, 0xCD, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x10, 0x25, 0x0D, 0x4D, 0x5B, // "Ï" (U+00CF)
  0x00, 0xD0, 0xFF, 0x01, 0x18, 0x1D, 0x19, 0x4D, 0xDF, // "Ð" (U+00D0)
  0x00, 0xD1, 0xFF, 0x01, 0x1D, 0x24, 0x1A, 0x4E, 0xA1, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x02, 0x01, 0x19, 0x26, 0x1A, 0x4F, 0xBA, // "Ò" (U+00D2)
  0x00, 0xD3, 0x02, 0x01, 0x19, 0x26, 0x1A, 0x50, 0x99, // "Ó" (U+00D3)
  0x00, 0xD4, 0x02, 0x01, 0x19, 0x26, 0x1A, 0x51, 0x7E, // "Ô" (U+00D4)
  0x00, 0xD5, 0x02, 0x01, 0x19, 0x24, 0x1A, 0x52, 0x67, // "Õ" (U+00D5)
  0x00, 0xD6, 0x02, 0x01, 0x19, 0x25, 0x1A, 0x53, 0x4D, // "Ö" (U+00D6)
  0x00, 0xD7, 0x02, 0x07, 0x10, 0x17, 0x13, 0x54, 0x2B, // "×" (U+00D7)
  0x00, 0xD8, 0x02, 0xFF, 0x19, 0x1F, 0x1A, 0x54, 0x8A, // "Ø" (U+00D8)
  0x00, 0xD9, 0x03, 0x01, 0x1C, 0x26, 0x19, 0x55, 0x8B, // "Ù" (U+00D9)
  0x00, 0xDA, 0x03, 0x01, 0x1C, 0x26, 0x19, 0x56, 0x73, // "Ú" (U+00DA)
  0x00, 0xDB, 0x03, 0x01, 0x1C, 0x26, 0x19, 0x57, 0x5E, // "Û" (U+00DB)
  0x00, 0xDC, 0x03, 0x01, 0x1C, 0x25, 0x19, 0x58, 0x4E, // "Ü" (U+00DC)
  0x00, 0xDD, 0x03, 0x01, 0x19, 0x26, 0x16, 0x59, 0x33, // "Ý" (U+00DD)
  0x00, 0xDE, 0xFF, 0x01, 0x14, 0x1D, 0x15, 0x59, 0xF1, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFB, 0xF7, 0x15, 0x1F, 0x16, 0x5A, 0x91, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x13, 0x1F, 0x14, 0x5B, 0xB2, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x13, 0x1F, 0x14, 0x5C, 0x5F, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x13, 0x1F, 0x14, 0x5D, 0x0F, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x13, 0x1D, 0x14, 0x5D, 0xC5, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x13, 0x1E, 0x14, 0x5E, 0x77, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x13, 0x20, 0x14, 0x5F, 0x23, // "å" (U+00E5)
  0x00, 0xE6, 0x01, 0x01, 0x1C, 0x16, 0x1C, 0x5F, 0xDF, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xF7, 0x11, 0x16, 0x11, 0x60, 0xA2, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x11, 0x1F, 0x11, 0x61, 0x31, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x13, 0x1F, 0x11, 0x61, 0xC3, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x11, 0x1F, 0x11, 0x62, 0x5D, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x11, 0x1E, 0x11, 0x62, 0xFA, // "ë" (U+00EB)
  0x00, 0xEC, 0x02, 0x01, 0x0A, 0x1F, 0x0B, 0x63, 0x8D, // "ì" (U+00EC)
  0x00, 0xED, 0x02, 0x01, 0x0E, 0x1F, 0x0B, 0x63, 0xE6, // "í" (U+00ED)
  0x00, 0xEE, 0x01, 0x01, 0x0B, 0x1F, 0x0B, 0x64, 0x50, // "î" (U+00EE)
  0x00, 0xEF, 0x02, 0x01, 0x0C, 0x1E, 0x0B, 0x64, 0xB4, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x13, 0x1F, 0x14, 0x65, 0x0F, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x14, 0x1D, 0x15, 0x65, 0xCD, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x12, 0x1F, 0x14, 0x66, 0x7A, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x13, 0x1F, 0x14, 0x67, 0x1C, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x12, 0x1F, 0x14, 0x67, 0xC4, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x13, 0x1D, 0x14, 0x68, 0x70, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x12, 0x1E, 0x14, 0x69, 0x1B, // "ö" (U+00F6)
  0x00, 0xF7, 0x02, 0x06, 0x10, 0x18, 0x13, 0x69, 0xBC, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0xFF, 0x14, 0x18, 0x14, 0x69, 0xE0, // "ø" (U+00F8)
  0x00, 0xF9, 0x02, 0x01, 0x14, 0x1F, 0x15, 0x6A, 0x99, // "ù" (U+00F9)
  0x00, 0xFA, 0x02, 0x01, 0x14, 0x1F, 0x15, 0x6B, 0x43, // "ú" (U+00FA)
  0x00, 0xFB, 0x02, 0x01, 0x14, 0x1F, 0x15, 0x6B, 0xF0, // "û" (U+00FB)
  0x00, 0xFC, 0x02, 0x01, 0x14, 0x1E, 0x15, 0x6C, 0xA3, // "ü" (U+00FC)
  0x00, 0xFD, 0xFA, 0xF7, 0x11, 0x1F, 0x13, 0x6D, 0x4C, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xF7, 0x12, 0x1F, 0x14, 0x6E, 0x1E, // "þ" (U+00FE)
  0x00, 0xFF, 0xFA, 0xF7, 0x11, 0x1E, 0x13, 0x6E, 0xF4, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFE, 0x01, 0x16, 0x21, 0x19, 0x6F, 0xBF, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x13, 0x1A, 0x14, 0x70, 0x78, // "ā" (U+0101)
  0x01, 0x02, 0xFE, 0x01, 0x16, 0x25, 0x19, 0x71, 0x11, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x13, 0x1E, 0x14, 0x71, 0xE6, // "ă" (U+0103)
  0x01, 0x04, 0xFE, 0xF7, 0x16, 0x1D, 0x19, 0x72, 0x99, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xF7, 0x13, 0x16, 0x14, 0x73, 0x76, // "ą" (U+0105)
  0x01, 0x06, 0x02, 0x01, 0x18, 0x26, 0x16, 0x74, 0x2F, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x13, 0x1F, 0x11, 0x74, 0xF1, // "ć" (U+0107)
  0x01, 0x08, 0x02, 0x01, 0x17, 0x26, 0x16, 0x75, 0x7B, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x11, 0x1F, 0x11, 0x76, 0x40, // "ĉ" (U+0109)
  0x01, 0x0A, 0x02, 0x01, 0x17, 0x26, 0x16, 0x76, 0xCD, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x11, 0x1F, 0x11, 0x77, 0x81, // "ċ" (U+010B)
  0x01, 0x0C, 0x02, 0x01, 0x18, 0x26, 0x16, 0x77, 0xFC, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x14, 0x1F, 0x11, 0x78, 0xC5, // "č" (U+010D)
  0x01, 0x0E, 0xFF, 0x01, 0x18, 0x26, 0x19, 0x79, 0x5C, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x1B, 0x1F, 0x14, 0x7A, 0x49, // "ď" (U+010F)
  0x01, 0x10, 0xFF, 0x01, 0x18, 0x1D, 0x19, 0x7B, 0x1C, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x17, 0x1F, 0x14, 0x7B, 0xDE, // "đ" (U+0111)
  0x01, 0x12, 0xFF, 0x01, 0x16, 0x21, 0x16, 0x7C, 0x96, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x11, 0x1A, 0x11, 0x7D, 0x34, // "ē" (U+0113)
  0x01, 0x14, 0xFF, 0x01, 0x16, 0x25, 0x16, 0x7D, 0xB5, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x12, 0x1E, 0x11, 0x7E, 0x6F, // "ĕ" (U+0115)
  0x01, 0x16, 0xFF, 0x01, 0x16, 0x25, 0x16, 0x7F, 0x09, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x11, 0x1F, 0x11, 0x7F, 0xB4, // "ė" (U+0117)
  0x01, 0x18, 0xFF, 0xF7, 0x16, 0x1D, 0x16, 0x80, 0x40, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xF8, 0x11, 0x16, 0x11, 0x81, 0x01, // "ę" (U+0119)
  0x01, 0x1A, 0xFF, 0x01, 0x16, 0x26, 0x16, 0x81, 0x9D, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x14, 0x1F, 0x11, 0x82, 0x5C, // "ě" (U+011B)
  0x01, 0x1C, 0x02, 0x01, 0x18, 0x26, 0x19, 0x83, 0x03, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFE, 0xF7, 0x15, 0x1F, 0x13, 0x83, 0xDF, // "ĝ" (U+011D)
  0x01, 0x1E, 0x02, 0x01, 0x18, 0x25, 0x19, 0x84, 0xE0, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFE, 0xF7, 0x15, 0x1E, 0x13, 0x85, 0xB8, // "ğ" (U+011F)
  0x01, 0x20, 0x02, 0x01, 0x18, 0x26, 0x19, 0x86, 0xB6, // "Ġ" (U+0120)
  0x01, 0x21, 0xFE, 0xF7, 0x15, 0x1F, 0x13, 0x87, 0x80, // "ġ" (U+0121)
  0x01, 0x22, 0x02, 0xF8, 0x18, 0x1D, 0x19, 0x88, 0x6E, // "Ģ" (U+0122)
  0x01, 0x23, 0xFE, 0xF7, 0x15, 0x1F, 0x13, 0x89, 0x3F, // "ģ" (U+0123)
  0x01, 0x24, 0xFF, 0x01, 0x1E, 0x26, 0x1B, 0x8A, 0x36, // "Ĥ" (U+0124)
  0x01, 0x25, 0x01, 0x01, 0x14, 0x27, 0x15, 0x8B, 0x2D, // "ĥ" (U+0125)
  0x01, 0x26, 0xFF, 0x01, 0x1E, 0x1D, 0x1B, 0x8B, 0xFC, // "Ħ" (U+0126)
  0x01, 0x27, 0x01, 0x01, 0x14, 0x1F, 0x15, 0x8C, 0xC3, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x11, 0x24, 0x0D, 0x8D, 0x6E, // "Ĩ" (U+0128)
  0x01, 0x29, 0x01, 0x01, 0x0E, 0x1D, 0x0B, 0x8D, 0xFC, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x0F, 0x21, 0x0D, 0x8E, 0x6A, // "Ī" (U+012A)
  0x01, 0x2B, 0x02, 0x01, 0x0C, 0x1A, 0x0B, 0x8E, 0xDB, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x10, 0x25, 0x0D, 0x8F, 0x26, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x02, 0x01, 0x0D, 0x1E, 0x0B, 0x8F, 0xB1, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xF7, 0x0F, 0x1D, 0x0D, 0x90, 0x16, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xF7, 0x0A, 0x1F, 0x0B, 0x90, 0xA6, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x0F, 0x26, 0x0D, 0x91, 0x1E, // "İ" (U+0130)
  0x01, 0x31, 0x02, 0x01, 0x0A, 0x16, 0x0B, 0x91, 0x9A, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xF7, 0x1C, 0x1D, 0x19, 0x91, 0xDB, // "Ĳ" (U+0132)
  0x01, 0x33, 0x02, 0xF7, 0x15, 0x1F, 0x15, 0x92, 0xD9, // "ĳ" (U+0133)
  0x01, 0x34, 0xFA, 0xF7, 0x0F, 0x26, 0x0D, 0x93, 0xA7, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFB, 0xF7, 0x0B, 0x1F, 0x0A, 0x94, 0x72, // "ĵ" (U+0135)
  0x01, 0x36, 0xFF, 0xF8, 0x1B, 0x1D, 0x18, 0x95, 0x0A, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xF8, 0x15, 0x1F, 0x14, 0x95, 0xF6, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x15, 0x16, 0x14, 0x96, 0xC6, // "ĸ" (U+0138)
  0x01, 0x39, 0xFF, 0x01, 0x13, 0x26, 0x16, 0x97, 0x55, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x02, 0x01, 0x10, 0x27, 0x0B, 0x98, 0x02, // "ĺ" (U+013A)
  0x01, 0x3B, 0xFF, 0xF8, 0x13, 0x1D, 0x16, 0x98, 0x8F, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xF8, 0x0B, 0x1F, 0x0B, 0x99, 0x35, // "ļ" (U+013C)
  0x01, 0x3D, 0xFF, 0x01, 0x15, 0x1D, 0x16, 0x99, 0xB1, // "Ľ" (U+013D)
  0x01, 0x3E, 0x02, 0x01, 0x11, 0x1F, 0x0B, 0x9A, 0x4C, // "ľ" (U+013E)
  0x01, 0x3F, 0xFF, 0x01, 0x14, 0x1D, 0x16, 0x9A, 0xC9, // "Ŀ" (U+013F)
  0x01, 0x40, 0x02, 0x01, 0x0F, 0x1F, 0x0E, 0x9B, 0x5D, // "ŀ" (U+0140)
  0x01, 0x41, 0xFF, 0x01, 0x13, 0x1D, 0x16, 0x9B, 0xD5, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x0B, 0x1F, 0x0B, 0x9C, 0x6D, // "ł" (U+0142)
  0x01, 0x43, 0xFF, 0x01, 0x1D, 0x26, 0x1A, 0x9C, 0xDD, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x14, 0x1F, 0x15, 0x9D, 0xF6, // "ń" (U+0144)
  0x01, 0x45, 0xFF, 0xF8, 0x1D, 0x1D, 0x1A, 0x9E, 0xA0, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xF8, 0x14, 0x16, 0x15, 0x9F, 0xB2, // "ņ" (U+0146)
  0x01, 0x47, 0xFF, 0x01, 0x1D, 0x26, 0x1A, 0xA0, 0x58, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x14, 0x1F, 0x15, 0xA1, 0x77, // "ň" (U+0148)
  0x01, 0x49, 0x01, 0x01, 0x1A, 0x1D, 0x1B, 0xA2, 0x29, // "ŉ" (U+0149)
  0x01, 0x4A, 0xFF, 0xF7, 0x1D, 0x1D, 0x1A, 0xA2, 0xE5, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xF7, 0x12, 0x16, 0x14, 0xA4, 0x07, // "ŋ" (U+014B)
  0x01, 0x4C, 0x02, 0x01, 0x19, 0x21, 0x1A, 0xA4, 0xB5, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x12, 0x1A, 0x14, 0xA5, 0x80, // "ō" (U+014D)
  0x01, 0x4E, 0x02, 0x01, 0x19, 0x25, 0x1A, 0xA6, 0x0F, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x12, 0x1E, 0x14, 0xA6, 0xF5, // "ŏ" (U+014F)
  0x01, 0x50, 0x02, 0x01, 0x1A, 0x25, 0x1A, 0xA7, 0x9D, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x16, 0x1E, 0x14, 0xA8, 0x8C, // "ő" (U+0151)
  0x01, 0x52, 0x02, 0x01, 0x22, 0x1D, 0x21, 0xA9, 0x42, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x01, 0x1D, 0x16, 0x1E, 0xAA, 0x31, // "œ" (U+0153)
  0x01, 0x54, 0xFF, 0x01, 0x16, 0x26, 0x17, 0xAA, 0xFE, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x11, 0x1F, 0x11, 0xAB, 0xE3, // "ŕ" (U+0155)
  0x01, 0x56, 0xFF, 0xF8, 0x16, 0x1D, 0x17, 0xAC, 0x66, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xF8, 0x11, 0x16, 0x11, 0xAD, 0x44, // "ŗ" (U+0157)
  0x01, 0x58, 0xFF, 0x01, 0x16, 0x26, 0x17, 0xAD, 0xC5, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x12, 0x1F, 0x11, 0xAE, 0xB0, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x14, 0x26, 0x13, 0xAF, 0x3B, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x11, 0x1F, 0x10, 0xB0, 0x07, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x13, 0x26, 0x13, 0xB0, 0x97, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x01, 0x01, 0x0F, 0x1F, 0x10, 0xB1, 0x63, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xF7, 0x13, 0x1D, 0x13, 0xB1, 0xF6, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xF7, 0x0F, 0x16, 0x10, 0xB2, 0xC6, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x15, 0x26, 0x13, 0xB3, 0x59, // "Š" (U+0160)
  0x01, 0x61, 0x01, 0x01, 0x12, 0x1F, 0x10, 0xB4, 0x2D, // "š" (U+0161)
  0x01, 0x62, 0x03, 0xF7, 0x18, 0x1D, 0x15, 0xB4, 0xC5, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xF7, 0x0D, 0x1B, 0x0D, 0xB5, 0x7E, // "ţ" (U+0163)
  0x01, 0x64, 0x03, 0x01, 0x18, 0x26, 0x15, 0xB6, 0x04, // "Ť" (U+0164)
  0x01, 0x65, 0x02, 0x01, 0x11, 0x1F, 0x0D, 0xB6, 0xBD, // "ť" (U+0165)
  0x01, 0x66, 0x03, 0x01, 0x18, 0x1D, 0x15, 0xB7, 0x34, // "Ŧ" (U+0166)
  0x01, 0x67, 0x01, 0x01, 0x0D, 0x1B, 0x0D, 0xB7, 0xC8, // "ŧ" (U+0167)
  0x01, 0x68, 0x03, 0x01, 0x1C, 0x24, 0x19, 0xB8, 0x29, // "Ũ" (U+0168)
  0x01, 0x69, 0x02, 0x01, 0x14, 0x1D, 0x15, 0xB9, 0x15, // "ũ" (U+0169)
  0x01, 0x6A, 0x03, 0x01, 0x1C, 0x21, 0x19, 0xB9, 0xC5, // "Ū" (U+016A)
  0x01, 0x6B, 0x02, 0x01, 0x14, 0x1A, 0x15, 0xBA, 0x96, // "ū" (U+016B)
  0x01, 0x6C, 0x03, 0x01, 0x1C, 0x25, 0x19, 0xBB, 0x2C, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x02, 0x01, 0x14, 0x1E, 0x15, 0xBC, 0x19, // "ŭ" (U+016D)
  0x01, 0x6E, 0x03, 0x01, 0x1C, 0x27, 0x19, 0xBC, 0xC9, // "Ů" (U+016E)
  0x01, 0x6F, 0x02, 0x01, 0x14, 0x20, 0x15, 0xBD, 0xC0, // "ů" (U+016F)
  0x01, 0x70, 0x03, 0x01, 0x1C, 0x25, 0x19, 0xBE, 0x7A, // "Ű" (U+0170)
  0x01, 0x71, 0x02, 0x01, 0x16, 0x1E, 0x15, 0xBF, 0x6F, // "ű" (U+0171)
  0x01, 0x72, 0x03, 0xF7, 0x1C, 0x1D, 0x19, 0xC0, 0x2A, // "Ų" (U+0172)
  0x01, 0x73, 0x02, 0xF7, 0x14, 0x16, 0x15, 0xC1, 0x20, // "ų" (U+0173)
  0x01, 0x74, 0x03, 0x01, 0x27, 0x26, 0x24, 0xC1, 0xD6, // "Ŵ" (U+0174)
  0x01, 0x75, 0x02, 0x00, 0x1C, 0x1F, 0x1D, 0xC3, 0x3B, // "ŵ" (U+0175)
  0x01, 0x76, 0x03, 0x01, 0x19, 0x26, 0x16, 0xC4, 0x49, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFA, 0xF7, 0x11, 0x1F, 0x13, 0xC5, 0x0C, // "ŷ" (U+0177)
  0x01, 0x78, 0x03, 0x01, 0x19, 0x25, 0x16, 0xC5, 0xE3, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x16, 0x26, 0x15, 0xC6, 0x9A, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x11, 0x1F, 0x12, 0xC7, 0x5C, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x16, 0x26, 0x15, 0xC7, 0xF2, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x11, 0x1F, 0x12, 0xC8, 0xA6, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x16, 0x26, 0x15, 0xC9, 0x30, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x13, 0x1F, 0x12, 0xC9, 0xF8, // "ž" (U+017E)
  0x01, 0x7F, 0xFB, 0xF7, 0x11, 0x1F, 0x0B, 0xCA, 0x97, // "ſ" (U+017F)
  0x03, 0xA9, 0xFF, 0x01, 0x19, 0x1D, 0x1A, 0xCB, 0x48, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xF7, 0x13, 0x16, 0x15, 0xCC, 0x2A, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x16, 0x16, 0x16, 0xCC, 0xDA, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x0B, 0x14, 0x0C, 0x14, 0xCD, 0x6B, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x0B, 0x28, 0x0C, 0x28, 0xCD, 0x73, // "—" (U+2014)
  0x20, 0xAC, 0x01, 0x01, 0x15, 0x1D, 0x14, 0xCD, 0x7C, // "€" (U+20AC)
  0x20, 0xBF, 0xFE, 0xFD, 0x13, 0x20, 0x14, 0xCE, 0x0B, // "₿" (U+20BF)
  0x20, 0x18, 0x04, 0x13, 0x0A, 0x1D, 0x09, 0xCE, 0xE8, // "‘" (U+2018)
  0x20, 0x19, 0x03, 0x13, 0x09, 0x1D, 0x09, 0xCF, 0x0B, // "’" (U+2019)
  0x20, 0x1A, 0xFE, 0xFB, 0x05, 0x05, 0x09, 0xCF, 0x2D, // "‚" (U+201A)
  0x20, 0x1B, 0x45, 0x12, 0x0A, 0x1D, 0x09, 0xCF, 0x52, // "‛" (U+201B)
  0x20, 0x1C, 0x04, 0x13, 0x11, 0x1D, 0x10, 0xCF, 0x76, // "“" (U+201C)
  0x20, 0x1D, 0x03, 0x13, 0x10, 0x1D, 0x10, 0xCF, 0xB8, // "”" (U+201D)
  0x20, 0x1E, 0xFE, 0xFB, 0x0C, 0x05, 0x10, 0xCF, 0xFD, // "„" (U+201E)
  0x20, 0x1F, 0x05, 0x12, 0x11, 0x1D, 0x10, 0xD0, 0x45, // "‟" (U+201F)
  0x20, 0x20, 0x03, 0xFD, 0x10, 0x1F, 0x10, 0xD0, 0x8F, // "†" (U+2020)
  0x20, 0x21, 0xFF, 0xFD, 0x11, 0x1F, 0x10, 0xD1, 0x10, // "‡" (U+2021)
  0x20, 0x22, 0x02, 0x0A, 0x0B, 0x15, 0x0D, 0xD1, 0xB4, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x1A, 0x05, 0x1E, 0xD1, 0xDD, // "…" (U+2026)
  0x20, 0x30, 0x02, 0x01, 0x2B, 0x1D, 0x2D, 0xD2, 0x0B, // "‰" (U+2030)
  0x20, 0x39, 0x02, 0x04, 0x0A, 0x12, 0x0C, 0xD3, 0x9E, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x04, 0x09, 0x12, 0x0C, 0xD3, 0xD0, // "›" (U+203A)
  0x20, 0x44, 0xF7, 0x01, 0x0B, 0x1D, 0x02, 0xD4, 0x02, // "⁄" (U+2044)
  0x21, 0x22, 0x04, 0x0F, 0x1E, 0x1D, 0x1C, 0xD4, 0x7C, // "™" (U+2122)
  0x21, 0x52, 0x03, 0x01, 0x29, 0x1E, 0x2B, 0xD5, 0x1A, // "⅒" (U+2152)
  0xFB, 0x01, 0xFB, 0xF7, 0x13, 0x1F, 0x15, 0xD6, 0x71, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFB, 0xF7, 0x15, 0x1F, 0x15, 0xD7, 0x5A, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x03, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x67, 0x02, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0xC0, 0x03, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x03, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x03, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x03, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x03, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x03, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x05, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x03, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x03, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x03, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x54, 0x02, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x02, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x02, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x02, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x02, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x74, 0x02, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x02, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x02, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x03, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x67, 0x02, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0xC0, 0x03, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x03, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x03, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x03, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x03, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x03, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x05, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x03, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x03, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x03, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x26, 0x01, // *& (U+002A U+0026)
  0x00, 0x2A, 0x00, 0x2C, 0x05, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x05, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x02, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x02, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x02, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x02, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x02, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x02, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x02, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x03, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x02, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x02, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x02, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x05, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x05, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x05, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x03, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x55, 0x01, // ,U (U+002C U+0055)
  0x00, 0x2C, 0x00, 0x56, 0x04, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x03, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x03, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x02, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x01, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x01, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xD9, 0x01, // ,Ù (U+002C U+00D9)
  0x00, 0x2C, 0x00, 0xDA, 0x01, // ,Ú (U+002C U+00DA)
  0x00, 0x2C, 0x00, 0xDB, 0x01, // ,Û (U+002C U+00DB)
  0x00, 0x2C, 0x00, 0xDC, 0x01, // ,Ü (U+002C U+00DC)
  0x00, 0x2C, 0x00, 0xDD, 0x03, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xFD, 0x01, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x01, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x68, 0x01, // ,Ũ (U+002C U+0168)
  0x00, 0x2C, 0x01, 0x6A, 0x01, // ,Ū (U+002C U+016A)
  0x00, 0x2C, 0x01, 0x6C, 0x01, // ,Ŭ (U+002C U+016C)
  0x00, 0x2C, 0x01, 0x6E, 0x01, // ,Ů (U+002C U+016E)
  0x00, 0x2C, 0x01, 0x70, 0x01, // ,Ű (U+002C U+0170)
  0x00, 0x2C, 0x01, 0x72, 0x01, // ,Ų (U+002C U+0172)
  0x00, 0x2C, 0x01, 0x74, 0x03, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x01, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x03, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x01, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x03, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x03, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x55, 0x01, // .U (U+002E U+0055)
  0x00, 0x2E, 0x00, 0x56, 0x04, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x03, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x03, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x02, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x01, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x01, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xD9, 0x01, // .Ù (U+002E U+00D9)
  0x00, 0x2E, 0x00, 0xDA, 0x01, // .Ú (U+002E U+00DA)
  0x00, 0x2E, 0x00, 0xDB, 0x01, // .Û (U+002E U+00DB)
  0x00, 0x2E, 0x00, 0xDC, 0x01, // .Ü (U+002E U+00DC)
  0x00, 0x2E, 0x00, 0xDD, 0x03, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xFD, 0x01, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x01, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x68, 0x01, // .Ũ (U+002E U+0168)
  0x00, 0x2E, 0x01, 0x6A, 0x01, // .Ū (U+002E U+016A)
  0x00, 0x2E, 0x01, 0x6C, 0x01, // .Ŭ (U+002E U+016C)
  0x00, 0x2E, 0x01, 0x6E, 0x01, // .Ů (U+002E U+016E)
  0x00, 0x2E, 0x01, 0x70, 0x01, // .Ű (U+002E U+0170)
  0x00, 0x2E, 0x01, 0x72, 0x01, // .Ų (U+002E U+0172)
  0x00, 0x2E, 0x01, 0x74, 0x03, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x01, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x03, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x01, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x03, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x03, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x26, 0x01, // A& (U+0041 U+0026)
  0x00, 0x41, 0x00, 0x27, 0x03, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x03, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x43, 0x01, // AC (U+0041 U+0043)
  0x00, 0x41, 0x00, 0x47, 0x01, // AG (U+0041 U+0047)
  0x00, 0x41, 0x00, 0x4F, 0x01, // AO (U+0041 U+004F)
  0x00, 0x41, 0x00, 0x51, 0x01, // AQ (U+0041 U+0051)
  0x00, 0x41, 0x00, 0x54, 0x02, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x55, 0x01, // AU (U+0041 U+0055)
  0x00, 0x41, 0x00, 0x56, 0x03, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x03, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x03, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x63, 0x01, // Ac (U+0041 U+0063)
  0x00, 0x41, 0x00, 0x64, 0x01, // Ad (U+0041 U+0064)
  0x00, 0x41, 0x00, 0x65, 0x01, // Ae (U+0041 U+0065)
  0x00, 0x41, 0x00, 0x67, 0x01, // Ag (U+0041 U+0067)
  0x00, 0x41, 0x00, 0x6F, 0x01, // Ao (U+0041 U+006F)
  0x00, 0x41, 0x00, 0x71, 0x01, // Aq (U+0041 U+0071)
  0x00, 0x41, 0x00, 0x75, 0x01, // Au (U+0041 U+0075)
  0x00, 0x41, 0x00, 0x76, 0x02, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x77, 0x01, // Aw (U+0041 U+0077)
  0x00, 0x41, 0x00, 0x79, 0x02, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xA9, 0x02, // A© (U+0041 U+00A9)
  0x00, 0x41, 0x00, 0xAE, 0x02, // A® (U+0041 U+00AE)
  0x00, 0x41, 0x00, 0xC7, 0x01, // AÇ (U+0041 U+00C7)
  0x00, 0x41, 0x00, 0xD2, 0x01, // AÒ (U+0041 U+00D2)
  0x00, 0x41, 0x00, 0xD3, 0x01, // AÓ (U+0041 U+00D3)
  0x00, 0x41, 0x00, 0xD4, 0x01, // AÔ (U+0041 U+00D4)
  0x00, 0x41, 0x00, 0xD5, 0x01, // AÕ (U+0041 U+00D5)
  0x00, 0x41, 0x00, 0xD6, 0x01, // AÖ (U+0041 U+00D6)
  0x00, 0x41, 0x00, 0xD8, 0x01, // AØ (U+0041 U+00D8)
  0x00, 0x41, 0x00, 0xD9, 0x01, // AÙ (U+0041 U+00D9)
  0x00, 0x41, 0x00, 0xDA, 0x01, // AÚ (U+0041 U+00DA)
  0x00, 0x41, 0x00, 0xDB, 0x01, // AÛ (U+0041 U+00DB)
  0x00, 0x41, 0x00, 0xDC, 0x01, // AÜ (U+0041 U+00DC)
  0x00, 0x41, 0x00, 0xDD, 0x03, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xE7, 0x01, // Aç (U+0041 U+00E7)
  0x00, 0x41, 0x00, 0xE8, 0x01, // Aè (U+0041 U+00E8)
  0x00, 0x41, 0x00, 0xE9, 0x01, // Aé (U+0041 U+00E9)
  0x00, 0x41, 0x00, 0xEA, 0x01, // Aê (U+0041 U+00EA)
  0x00, 0x41, 0x00, 0xEB, 0x01, // Aë (U+0041 U+00EB)
  0x00, 0x41, 0x00, 0xF0, 0x01, // Að (U+0041 U+00F0)
  0x00, 0x41, 0x00, 0xF2, 0x01, // Aò (U+0041 U+00F2)
  0x00, 0x41, 0x00, 0xF3, 0x01, // Aó (U+0041 U+00F3)
  0x00, 0x41, 0x00, 0xF4, 0x01, // Aô (U+0041 U+00F4)
  0x00, 0x41, 0x00, 0xF5, 0x01, // Aõ (U+0041 U+00F5)
  0x00, 0x41, 0x00, 0xF6, 0x01, // Aö (U+0041 U+00F6)
  0x00, 0x41, 0x00, 0xF8, 0x01, // Aø (U+0041 U+00F8)
  0x00, 0x41, 0x00, 0xF9, 0x01, // Aù (U+0041 U+00F9)
  0x00, 0x41, 0x00, 0xFA, 0x01, // Aú (U+0041 U+00FA)
  0x00, 0x41, 0x00, 0xFB, 0x01, // Aû (U+0041 U+00FB)
  0x00, 0x41, 0x00, 0xFC, 0x01, // Aü (U+0041 U+00FC)
  0x00, 0x41, 0x00, 0xFD, 0x02, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x02, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x06, 0x01, // AĆ (U+0041 U+0106)
  0x00, 0x41, 0x01, 0x07, 0x01, // Ać (U+0041 U+0107)
  0x00, 0x41, 0x01, 0x08, 0x01, // AĈ (U+0041 U+0108)
  0x00, 0x41, 0x01, 0x09, 0x01, // Aĉ (U+0041 U+0109)
  0x00, 0x41, 0x01, 0x0A, 0x01, // AĊ (U+0041 U+010A)
  0x00, 0x41, 0x01, 0x0B, 0x01, // Aċ (U+0041 U+010B)
  0x00, 0x41, 0x01, 0x0C, 0x01, // AČ (U+0041 U+010C)
  0x00, 0x41, 0x01, 0x0D, 0x01, // Ač (U+0041 U+010D)
  0x00, 0x41, 0x01, 0x0F, 0x01, // Aď (U+0041 U+010F)
  0x00, 0x41, 0x01, 0x11, 0x01, // Ađ (U+0041 U+0111)
  0x00, 0x41, 0x01, 0x13, 0x01, // Aē (U+0041 U+0113)
  0x00, 0x41, 0x01, 0x15, 0x01, // Aĕ (U+0041 U+0115)
  0x00, 0x41, 0x01, 0x17, 0x01, // Aė (U+0041 U+0117)
  0x00, 0x41, 0x01, 0x19, 0x01, // Aę (U+0041 U+0119)
  0x00, 0x41, 0x01, 0x1B, 0x01, // Aě (U+0041 U+011B)
  0x00, 0x41, 0x01, 0x1C, 0x01, // AĜ (U+0041 U+011C)
  0x00, 0x41, 0x01, 0x1D, 0x01, // Aĝ (U+0041 U+011D)
  0x00, 0x41, 0x01, 0x1E, 0x01, // AĞ (U+0041 U+011E)
  0x00, 0x41, 0x01, 0x1F, 0x01, // Ağ (U+0041 U+011F)
  0x00, 0x41, 0x01, 0x20, 0x01, // AĠ (U+0041 U+0120)
  0x00, 0x41, 0x01, 0x21, 0x01, // Aġ (U+0041 U+0121)
  0x00, 0x41, 0x01, 0x22, 0x01, // AĢ (U+0041 U+0122)
  0x00, 0x41, 0x01, 0x23, 0x01, // Aģ (U+0041 U+0123)
  0x00, 0x41, 0x01, 0x49, 0x02, // Aŉ (U+0041 U+0149)
  0x00, 0x41, 0x01, 0x4C, 0x01, // AŌ (U+0041 U+014C)
  0x00, 0x41, 0x01, 0x4D, 0x01, // Aō (U+0041 U+014D)
  0x00, 0x41, 0x01, 0x4E, 0x01, // AŎ (U+0041 U+014E)
  0x00, 0x41, 0x01, 0x4F, 0x01, // Aŏ (U+0041 U+014F)
  0x00, 0x41, 0x01, 0x50, 0x01, // AŐ (U+0041 U+0150)
  0x00, 0x41, 0x01, 0x51, 0x01, // Aő (U+0041 U+0151)
  0x00, 0x41, 0x01, 0x52, 0x01, // AŒ (U+0041 U+0152)
  0x00, 0x41, 0x01, 0x53, 0x01, // Aœ (U+0041 U+0153)
  0x00, 0x41, 0x01, 0x68, 0x01, // AŨ (U+0041 U+0168)
  0x00, 0x41, 0x01, 0x69, 0x01, // Aũ (U+0041 U+0169)
  0x00, 0x41, 0x01, 0x6A, 0x01, // AŪ (U+0041 U+016A)
  0x00, 0x41, 0x01, 0x6B, 0x01, // Aū (U+0041 U+016B)
  0x00, 0x41, 0x01, 0x6C, 0x01, // AŬ (U+0041 U+016C)
  0x00, 0x41, 0x01, 0x6D, 0x01, // Aŭ (U+0041 U+016D)
  0x00, 0x41, 0x01, 0x6E, 0x01, // AŮ (U+0041 U+016E)
  0x00, 0x41, 0x01, 0x6F, 0x01, // Aů (U+0041 U+016F)
  0x00, 0x41, 0x01, 0x70, 0x01, // AŰ (U+0041 U+0170)
  0x00, 0x41, 0x01, 0x71, 0x01, // Aű (U+0041 U+0171)
  0x00, 0x41, 0x01, 0x72, 0x01, // AŲ (U+0041 U+0172)
  0x00, 0x41, 0x01, 0x73, 0x01, // Aų (U+0041 U+0173)
  0x00, 0x41, 0x01, 0x74, 0x03, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x75, 0x01, // Aŵ (U+0041 U+0175)
  0x00, 0x41, 0x01, 0x76, 0x03, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x02, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x03, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x04, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x03, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x04, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x03, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x03, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x2A, 0x01, // B* (U+0042 U+002A)
  0x00, 0x42, 0x00, 0x54, 0x01, // BT (U+0042 U+0054)
  0x00, 0x42, 0x00, 0x56, 0x02, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x57, 0x01, // BW (U+0042 U+0057)
  0x00, 0x42, 0x00, 0x58, 0x01, // BX (U+0042 U+0058)
  0x00, 0x42, 0x00, 0x59, 0x02, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0x79, 0x01, // By (U+0042 U+0079)
  0x00, 0x42, 0x00, 0xC6, 0x01, // BÆ (U+0042 U+00C6)
  0x00, 0x42, 0x00, 0xDD, 0x02, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x00, 0xFD, 0x01, // Bý (U+0042 U+00FD)
  0x00, 0x42, 0x00, 0xFF, 0x01, // Bÿ (U+0042 U+00FF)
  0x00, 0x42, 0x01, 0x74, 0x01, // BŴ (U+0042 U+0174)
  0x00, 0x42, 0x01, 0x76, 0x02, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x77, 0x01, // Bŷ (U+0042 U+0177)
  0x00, 0x42, 0x01, 0x78, 0x02, // BŸ (U+0042 U+0178)
  0x00, 0x42, 0x20, 0x19, 0x01, // B’ (U+0042 U+2019)
  0x00, 0x42, 0x20, 0x1D, 0x01, // B” (U+0042 U+201D)
  0x00, 0x42, 0x21, 0x22, 0x01, // B™ (U+0042 U+2122)
  0x00, 0x43, 0x00, 0x26, 0x01, // C& (U+0043 U+0026)
  0x00, 0x44, 0x00, 0x22, 0x01, // D" (U+0044 U+0022)
  0x00, 0x44, 0x00, 0x27, 0x01, // D' (U+0044 U+0027)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x41, 0x01, // DA (U+0044 U+0041)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x00, 0x56, 0x01, // DV (U+0044 U+0056)
  0x00, 0x44, 0x00, 0x57, 0x01, // DW (U+0044 U+0057)
  0x00, 0x44, 0x00, 0x58, 0x01, // DX (U+0044 U+0058)
  0x00, 0x44, 0x00, 0x59, 0x01, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0xC0, 0x01, // DÀ (U+0044 U+00C0)
  0x00, 0x44, 0x00, 0xC1, 0x01, // DÁ (U+0044 U+00C1)
  0x00, 0x44, 0x00, 0xC2, 0x01, // DÂ (U+0044 U+00C2)
  0x00, 0x44, 0x00, 0xC3, 0x01, // DÃ (U+0044 U+00C3)
  0x00, 0x44, 0x00, 0xC4, 0x01, // DÄ (U+0044 U+00C4)
  0x00, 0x44, 0x00, 0xC5, 0x01, // DÅ (U+0044 U+00C5)
  0x00, 0x44, 0x00, 0xC6, 0x02, // DÆ (U+0044 U+00C6)
  0x00, 0x44, 0x00, 0xDD, 0x01, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x00, 0x01, // DĀ (U+0044 U+0100)
  0x00, 0x44, 0x01, 0x02, 0x01, // DĂ (U+0044 U+0102)
  0x00, 0x44, 0x01, 0x04, 0x01, // DĄ (U+0044 U+0104)
  0x00, 0x44, 0x01, 0x74, 0x01, // DŴ (U+0044 U+0174)
  0x00, 0x44, 0x01, 0x76, 0x01, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x01, // DŸ (U+0044 U+0178)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x45, 0x00, 0x56, 0x01, // EV (U+0045 U+0056)
  0x00, 0x45, 0x00, 0x57, 0x01, // EW (U+0045 U+0057)
  0x00, 0x45, 0x00, 0x59, 0x01, // EY (U+0045 U+0059)
  0x00, 0x45, 0x00, 0xDD, 0x01, // EÝ (U+0045 U+00DD)
  0x00, 0x45, 0x01, 0x74, 0x01, // EŴ (U+0045 U+0174)
  0x00, 0x45, 0x01, 0x76, 0x01, // EŶ (U+0045 U+0176)
  0x00, 0x45, 0x01, 0x78, 0x01, // EŸ (U+0045 U+0178)
  0x00, 0x46, 0x00, 0x26, 0x02, // F& (U+0046 U+0026)
  0x00, 0x46, 0x00, 0x2C, 0x03, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x03, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x02, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x02, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x02, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x02, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x02, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x02, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x02, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x02, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x02, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x02, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x02, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x02, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x02, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x02, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x04, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x02, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x02, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x02, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x02, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x02, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x02, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x02, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x02, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x02, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x02, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x02, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x02, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x02, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x02, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x02, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x02, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x02, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x02, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x02, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x02, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x02, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x02, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x02, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x02, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x02, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x02, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x02, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x02, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x02, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x02, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x02, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x02, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x02, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x02, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x02, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x02, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x02, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x02, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x02, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x02, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x02, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x02, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x02, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x02, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x03, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x03, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x03, // F… (U+0046 U+2026)
  0x00, 0x47, 0x00, 0x54, 0x01, // GT (U+0047 U+0054)
  0x00, 0x47, 0x00, 0x56, 0x01, // GV (U+0047 U+0056)
  0x00, 0x47, 0x00, 0x57, 0x01, // GW (U+0047 U+0057)
  0x00, 0x47, 0x00, 0x59, 0x01, // GY (U+0047 U+0059)
  0x00, 0x47, 0x00, 0xC6, 0x01, // GÆ (U+0047 U+00C6)
  0x00, 0x47, 0x00, 0xDD, 0x01, // GÝ (U+0047 U+00DD)
  0x00, 0x47, 0x01, 0x74, 0x01, // GŴ (U+0047 U+0174)
  0x00, 0x47, 0x01, 0x76, 0x01, // GŶ (U+0047 U+0176)
  0x00, 0x47, 0x01, 0x78, 0x01, // GŸ (U+0047 U+0178)
  0x00, 0x4A, 0x00, 0x2C, 0x01, // J, (U+004A U+002C)
  0x00, 0x4A, 0x00, 0x2E, 0x01, // J. (U+004A U+002E)
  0x00, 0x4A, 0x00, 0x41, 0x01, // JA (U+004A U+0041)
  0x00, 0x4A, 0x00, 0xC0, 0x01, // JÀ (U+004A U+00C0)
  0x00, 0x4A, 0x00, 0xC1, 0x01, // JÁ (U+004A U+00C1)
  0x00, 0x4A, 0x00, 0xC2, 0x01, // JÂ (U+004A U+00C2)
  0x00, 0x4A, 0x00, 0xC3, 0x01, // JÃ (U+004A U+00C3)
  0x00, 0x4A, 0x00, 0xC4, 0x01, // JÄ (U+004A U+00C4)
  0x00, 0x4A, 0x00, 0xC5, 0x01, // JÅ (U+004A U+00C5)
  0x00, 0x4A, 0x01, 0x00, 0x01, // JĀ (U+004A U+0100)
  0x00, 0x4A, 0x01, 0x02, 0x01, // JĂ (U+004A U+0102)
  0x00, 0x4A, 0x01, 0x04, 0x01, // JĄ (U+004A U+0104)
  0x00, 0x4A, 0x20, 0x1A, 0x01, // J‚ (U+004A U+201A)
  0x00, 0x4A, 0x20, 0x1E, 0x01, // J„ (U+004A U+201E)
  0x00, 0x4A, 0x20, 0x26, 0x01, // J… (U+004A U+2026)
  0x00, 0x4B, 0x00, 0x26, 0x01, // K& (U+004B U+0026)
  0x00, 0x4B, 0x00, 0x43, 0x01, // KC (U+004B U+0043)
  0x00, 0x4B, 0x00, 0x47, 0x01, // KG (U+004B U+0047)
  0x00, 0x4B, 0x00, 0x4F, 0x01, // KO (U+004B U+004F)
  0x00, 0x4B, 0x00, 0x51, 0x01, // KQ (U+004B U+0051)
  0x00, 0x4B, 0x00, 0x63, 0x01, // Kc (U+004B U+0063)
  0x00, 0x4B, 0x00, 0x64, 0x01, // Kd (U+004B U+0064)
  0x00, 0x4B, 0x00, 0x65, 0x01, // Ke (U+004B U+0065)
  0x00, 0x4B, 0x00, 0x67, 0x01, // Kg (U+004B U+0067)
  0x00, 0x4B, 0x00, 0x6F, 0x01, // Ko (U+004B U+006F)
  0x00, 0x4B, 0x00, 0x71, 0x01, // Kq (U+004B U+0071)
  0x00, 0x4B, 0x00, 0x75, 0x01, // Ku (U+004B U+0075)
  0x00, 0x4B, 0x00, 0x76, 0x01, // Kv (U+004B U+0076)
  0x00, 0x4B, 0x00, 0x77, 0x01, // Kw (U+004B U+0077)
  0x00, 0x4B, 0x00, 0x79, 0x01, // Ky (U+004B U+0079)
  0x00, 0x4B, 0x00, 0xC7, 0x01, // KÇ (U+004B U+00C7)
  0x00, 0x4B, 0x00, 0xD2, 0x01, // KÒ (U+004B U+00D2)
  0x00, 0x4B, 0x00, 0xD3, 0x01, // KÓ (U+004B U+00D3)
  0x00, 0x4B, 0x00, 0xD4, 0x01, // KÔ (U+004B U+00D4)
  0x00, 0x4B, 0x00, 0xD5, 0x01, // KÕ (U+004B U+00D5)
  0x00, 0x4B, 0x00, 0xD6, 0x01, // KÖ (U+004B U+00D6)
  0x00, 0x4B, 0x00, 0xD8, 0x01, // KØ (U+004B U+00D8)
  0x00, 0x4B, 0x00, 0xE7, 0x01, // Kç (U+004B U+00E7)
  0x00, 0x4B, 0x00, 0xE8, 0x01, // Kè (U+004B U+00E8)
  0x00, 0x4B, 0x00, 0xE9, 0x01, // Ké (U+004B U+00E9)
  0x00, 0x4B, 0x00, 0xEA, 0x01, // Kê (U+004B U+00EA)
  0x00, 0x4B, 0x00, 0xEB, 0x01, // Kë (U+004B U+00EB)
  0x00, 0x4B, 0x00, 0xF0, 0x01, // Kð (U+004B U+00F0)
  0x00, 0x4B, 0x00, 0xF2, 0x01, // Kò (U+004B U+00F2)
  0x00, 0x4B, 0x00, 0xF3, 0x01, // Kó (U+004B U+00F3)
  0x00, 0x4B, 0x00, 0xF4, 0x01, // Kô (U+004B U+00F4)
  0x00, 0x4B, 0x00, 0xF5, 0x01, // Kõ (U+004B U+00F5)
  0x00, 0x4B, 0x00, 0xF6, 0x01, // Kö (U+004B U+00F6)
  0x00, 0x4B, 0x00, 0xF8, 0x01, // Kø (U+004B U+00F8)
  0x00, 0x4B, 0x00, 0xF9, 0x01, // Kù (U+004B U+00F9)
  0x00, 0x4B, 0x00, 0xFA, 0x01, // Kú (U+004B U+00FA)
  0x00, 0x4B, 0x00, 0xFB, 0x01, // Kû (U+004B U+00FB)
  0x00, 0x4B, 0x00, 0xFC, 0x01, // Kü (U+004B U+00FC)
  0x00, 0x4B, 0x00, 0xFD, 0x01, // Ký (U+004B U+00FD)
  0x00, 0x4B, 0x00, 0xFF, 0x01, // Kÿ (U+004B U+00FF)
  0x00, 0x4B, 0x01, 0x06, 0x01, // KĆ (U+004B U+0106)
  0x00, 0x4B, 0x01, 0x07, 0x01, // Kć (U+004B U+0107)
  0x00, 0x4B, 0x01, 0x08, 0x01, // KĈ (U+004B U+0108)
  0x00, 0x4B, 0x01, 0x09, 0x01, // Kĉ (U+004B U+0109)
  0x00, 0x4B, 0x01, 0x0A, 0x01, // KĊ (U+004B U+010A)
  0x00, 0x4B, 0x01, 0x0B, 0x01, // Kċ (U+004B U+010B)
  0x00, 0x4B, 0x01, 0x0C, 0x01, // KČ (U+004B U+010C)
  0x00, 0x4B, 0x01, 0x0D, 0x01, // Kč (U+004B U+010D)
  0x00, 0x4B, 0x01, 0x0F, 0x01, // Kď (U+004B U+010F)
  0x00, 0x4B, 0x01, 0x11, 0x01, // Kđ (U+004B U+0111)
  0x00, 0x4B, 0x01, 0x13, 0x01, // Kē (U+004B U+0113)
  0x00, 0x4B, 0x01, 0x15, 0x01, // Kĕ (U+004B U+0115)
  0x00, 0x4B, 0x01, 0x17, 0x01, // Kė (U+004B U+0117)
  0x00, 0x4B, 0x01, 0x19, 0x01, // Kę (U+004B U+0119)
  0x00, 0x4B, 0x01, 0x1B, 0x01, // Kě (U+004B U+011B)
  0x00, 0x4B, 0x01, 0x1C, 0x01, // KĜ (U+004B U+011C)
  0x00, 0x4B, 0x01, 0x1D, 0x01, // Kĝ (U+004B U+011D)
  0x00, 0x4B, 0x01, 0x1E, 0x01, // KĞ (U+004B U+011E)
  0x00, 0x4B, 0x01, 0x1F, 0x01, // Kğ (U+004B U+011F)
  0x00, 0x4B, 0x01, 0x20, 0x01, // KĠ (U+004B U+0120)
  0x00, 0x4B, 0x01, 0x21, 0x01, // Kġ (U+004B U+0121)
  0x00, 0x4B, 0x01, 0x22, 0x01, // KĢ (U+004B U+0122)
  0x00, 0x4B, 0x01, 0x23, 0x01, // Kģ (U+004B U+0123)
  0x00, 0x4B, 0x01, 0x4C, 0x01, // KŌ (U+004B U+014C)
  0x00, 0x4B, 0x01, 0x4D, 0x01, // Kō (U+004B U+014D)
  0x00, 0x4B, 0x01, 0x4E, 0x01, // KŎ (U+004B U+014E)
  0x00, 0x4B, 0x01, 0x4F, 0x01, // Kŏ (U+004B U+014F)
  0x00, 0x4B, 0x01, 0x50, 0x01, // KŐ (U+004B U+0150)
  0x00, 0x4B, 0x01, 0x51, 0x01, // Kő (U+004B U+0151)
  0x00, 0x4B, 0x01, 0x52, 0x01, // KŒ (U+004B U+0152)
  0x00, 0x4B, 0x01, 0x53, 0x01, // Kœ (U+004B U+0153)
  0x00, 0x4B, 0x01, 0x69, 0x01, // Kũ (U+004B U+0169)
  0x00, 0x4B, 0x01, 0x6B, 0x01, // Kū (U+004B U+016B)
  0x00, 0x4B, 0x01, 0x6D, 0x01, // Kŭ (U+004B U+016D)
  0x00, 0x4B, 0x01, 0x6F, 0x01, // Ků (U+004B U+016F)
  0x00, 0x4B, 0x01, 0x71, 0x01, // Kű (U+004B U+0171)
  0x00, 0x4B, 0x01, 0x73, 0x01, // Kų (U+004B U+0173)
  0x00, 0x4B, 0x01, 0x75, 0x01, // Kŵ (U+004B U+0175)
  0x00, 0x4B, 0x01, 0x77, 0x01, // Kŷ (U+004B U+0177)
  0x00, 0x4C, 0x00, 0x22, 0x02, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x02, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x03, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x03, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x55, 0x01, // LU (U+004C U+0055)
  0x00, 0x4C, 0x00, 0x56, 0x03, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x02, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x02, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0x76, 0x01, // Lv (U+004C U+0076)
  0x00, 0x4C, 0x00, 0x79, 0x01, // Ly (U+004C U+0079)
  0x00, 0x4C, 0x00, 0xD9, 0x01, // LÙ (U+004C U+00D9)
  0x00, 0x4C, 0x00, 0xDA, 0x01, // LÚ (U+004C U+00DA)
  0x00, 0x4C, 0x00, 0xDB, 0x01, // LÛ (U+004C U+00DB)
  0x00, 0x4C, 0x00, 0xDC, 0x01, // LÜ (U+004C U+00DC)
  0x00, 0x4C, 0x00, 0xDD, 0x02, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x00, 0xFD, 0x01, // Lý (U+004C U+00FD)
  0x00, 0x4C, 0x00, 0xFF, 0x01, // Lÿ (U+004C U+00FF)
  0x00, 0x4C, 0x01, 0x68, 0x01, // LŨ (U+004C U+0168)
  0x00, 0x4C, 0x01, 0x6A, 0x01, // LŪ (U+004C U+016A)
  0x00, 0x4C, 0x01, 0x6C, 0x01, // LŬ (U+004C U+016C)
  0x00, 0x4C, 0x01, 0x6E, 0x01, // LŮ (U+004C U+016E)
  0x00, 0x4C, 0x01, 0x70, 0x01, // LŰ (U+004C U+0170)
  0x00, 0x4C, 0x01, 0x72, 0x01, // LŲ (U+004C U+0172)
  0x00, 0x4C, 0x01, 0x74, 0x02, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x02, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x77, 0x01, // Lŷ (U+004C U+0177)
  0x00, 0x4C, 0x01, 0x78, 0x02, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x04, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x03, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x04, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x03, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x03, // L™ (U+004C U+2122)
  0x00, 0x4E, 0x00, 0x26, 0x01, // N& (U+004E U+0026)
  0x00, 0x4E, 0x00, 0x2C, 0x01, // N, (U+004E U+002C)
  0x00, 0x4E, 0x00, 0x2E, 0x01, // N. (U+004E U+002E)
  0x00, 0x4E, 0x20, 0x1A, 0x01, // N‚ (U+004E U+201A)
  0x00, 0x4E, 0x20, 0x1E, 0x01, // N„ (U+004E U+201E)
  0x00, 0x4E, 0x20, 0x26, 0x01, // N… (U+004E U+2026)
  0x00, 0x4F, 0x00, 0x22, 0x01, // O" (U+004F U+0022)
  0x00, 0x4F, 0x00, 0x27, 0x01, // O' (U+004F U+0027)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x41, 0x01, // OA (U+004F U+0041)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x00, 0x56, 0x01, // OV (U+004F U+0056)
  0x00, 0x4F, 0x00, 0x57, 0x01, // OW (U+004F U+0057)
  0x00, 0x4F, 0x00, 0x58, 0x01, // OX (U+004F U+0058)
  0x00, 0x4F, 0x00, 0x59, 0x01, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0xC0, 0x01, // OÀ (U+004F U+00C0)
  0x00, 0x4F, 0x00, 0xC1, 0x01, // OÁ (U+004F U+00C1)
  0x00, 0x4F, 0x00, 0xC2, 0x01, // OÂ (U+004F U+00C2)
  0x00, 0x4F, 0x00, 0xC3, 0x01, // OÃ (U+004F U+00C3)
  0x00, 0x4F, 0x00, 0xC4, 0x01, // OÄ (U+004F U+00C4)
  0x00, 0x4F, 0x00, 0xC5, 0x01, // OÅ (U+004F U+00C5)
  0x00, 0x4F, 0x00, 0xC6, 0x02, // OÆ (U+004F U+00C6)
  0x00, 0x4F, 0x00, 0xDD, 0x01, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x00, 0x01, // OĀ (U+004F U+0100)
  0x00, 0x4F, 0x01, 0x02, 0x01, // OĂ (U+004F U+0102)
  0x00, 0x4F, 0x01, 0x04, 0x01, // OĄ (U+004F U+0104)
  0x00, 0x4F, 0x01, 0x74, 0x01, // OŴ (U+004F U+0174)
  0x00, 0x4F, 0x01, 0x76, 0x01, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x01, // OŸ (U+004F U+0178)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x26, 0x01, // P& (U+0050 U+0026)
  0x00, 0x50, 0x00, 0x2C, 0x05, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x05, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x02, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x02, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x02, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x02, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x02, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x02, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x02, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x03, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x02, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x02, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x02, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x05, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x05, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x05, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x22, 0x01, // Q" (U+0051 U+0022)
  0x00, 0x51, 0x00, 0x27, 0x01, // Q' (U+0051 U+0027)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x41, 0x01, // QA (U+0051 U+0041)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x00, 0x56, 0x01, // QV (U+0051 U+0056)
  0x00, 0x51, 0x00, 0x57, 0x01, // QW (U+0051 U+0057)
  0x00, 0x51, 0x00, 0x58, 0x01, // QX (U+0051 U+0058)
  0x00, 0x51, 0x00, 0x59, 0x01, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0xC0, 0x01, // QÀ (U+0051 U+00C0)
  0x00, 0x51, 0x00, 0xC1, 0x01, // QÁ (U+0051 U+00C1)
  0x00, 0x51, 0x00, 0xC2, 0x01, // QÂ (U+0051 U+00C2)
  0x00, 0x51, 0x00, 0xC3, 0x01, // QÃ (U+0051 U+00C3)
  0x00, 0x51, 0x00, 0xC4, 0x01, // QÄ (U+0051 U+00C4)
  0x00, 0x51, 0x00, 0xC5, 0x01, // QÅ (U+0051 U+00C5)
  0x00, 0x51, 0x00, 0xC6, 0x02, // QÆ (U+0051 U+00C6)
  0x00, 0x51, 0x00, 0xDD, 0x01, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x00, 0x01, // QĀ (U+0051 U+0100)
  0x00, 0x51, 0x01, 0x02, 0x01, // QĂ (U+0051 U+0102)
  0x00, 0x51, 0x01, 0x04, 0x01, // QĄ (U+0051 U+0104)
  0x00, 0x51, 0x01, 0x74, 0x01, // QŴ (U+0051 U+0174)
  0x00, 0x51, 0x01, 0x76, 0x01, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x01, // QŸ (U+0051 U+0178)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x52, 0x00, 0x26, 0x01, // R& (U+0052 U+0026)
  0x00, 0x52, 0x00, 0x2A, 0x01, // R* (U+0052 U+002A)
  0x00, 0x52, 0x00, 0x54, 0x01, // RT (U+0052 U+0054)
  0x00, 0x52, 0x00, 0x56, 0x01, // RV (U+0052 U+0056)
  0x00, 0x52, 0x00, 0x57, 0x01, // RW (U+0052 U+0057)
  0x00, 0x52, 0x00, 0x59, 0x01, // RY (U+0052 U+0059)
  0x00, 0x52, 0x00, 0x77, 0x01, // Rw (U+0052 U+0077)
  0x00, 0x52, 0x00, 0x79, 0x01, // Ry (U+0052 U+0079)
  0x00, 0x52, 0x00, 0xDD, 0x01, // RÝ (U+0052 U+00DD)
  0x00, 0x52, 0x00, 0xFD, 0x01, // Rý (U+0052 U+00FD)
  0x00, 0x52, 0x00, 0xFF, 0x01, // Rÿ (U+0052 U+00FF)
  0x00, 0x52, 0x01, 0x74, 0x01, // RŴ (U+0052 U+0174)
  0x00, 0x52, 0x01, 0x75, 0x01, // Rŵ (U+0052 U+0175)
  0x00, 0x52, 0x01, 0x76, 0x01, // RŶ (U+0052 U+0176)
  0x00, 0x52, 0x01, 0x77, 0x01, // Rŷ (U+0052 U+0177)
  0x00, 0x52, 0x01, 0x78, 0x01, // RŸ (U+0052 U+0178)
  0x00, 0x52, 0x20, 0x19, 0x01, // R’ (U+0052 U+2019)
  0x00, 0x52, 0x20, 0x1D, 0x01, // R” (U+0052 U+201D)
  0x00, 0x52, 0x21, 0x22, 0x01, // R™ (U+0052 U+2122)
  0x00, 0x53, 0x00, 0x54, 0x01, // ST (U+0053 U+0054)
  0x00, 0x53, 0x00, 0x56, 0x01, // SV (U+0053 U+0056)
  0x00, 0x53, 0x00, 0x57, 0x01, // SW (U+0053 U+0057)
  0x00, 0x53, 0x00, 0x58, 0x01, // SX (U+0053 U+0058)
  0x00, 0x53, 0x00, 0x59, 0x01, // SY (U+0053 U+0059)
  0x00, 0x53, 0x00, 0x79, 0x01, // Sy (U+0053 U+0079)
  0x00, 0x53, 0x00, 0xC6, 0x01, // SÆ (U+0053 U+00C6)
  0x00, 0x53, 0x00, 0xDD, 0x01, // SÝ (U+0053 U+00DD)
  0x00, 0x53, 0x00, 0xFD, 0x01, // Sý (U+0053 U+00FD)
  0x00, 0x53, 0x00, 0xFF, 0x01, // Sÿ (U+0053 U+00FF)
  0x00, 0x53, 0x01, 0x74, 0x01, // SŴ (U+0053 U+0174)
  0x00, 0x53, 0x01, 0x76, 0x01, // SŶ (U+0053 U+0176)
  0x00, 0x53, 0x01, 0x77, 0x01, // Sŷ (U+0053 U+0177)
  0x00, 0x53, 0x01, 0x78, 0x01, // SŸ (U+0053 U+0178)
  0x00, 0x54, 0x00, 0x26, 0x01, // T& (U+0054 U+0026)
  0x00, 0x54, 0x00, 0x2C, 0x03, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x03, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x02, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x02, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x02, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x02, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x02, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x02, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x02, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x03, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x01, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x02, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x02, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x02, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x03, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x03, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x03, // T… (U+0054 U+2026)
  0x00, 0x55, 0x00, 0x26, 0x01, // U& (U+0055 U+0026)
  0x00, 0x55, 0x00, 0x2C, 0x01, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x01, // U. (U+0055 U+002E)
  0x00, 0x55, 0x00, 0x41, 0x01, // UA (U+0055 U+0041)
  0x00, 0x55, 0x00, 0xC0, 0x01, // UÀ (U+0055 U+00C0)
  0x00, 0x55, 0x00, 0xC1, 0x01, // UÁ (U+0055 U+00C1)
  0x00, 0x55, 0x00, 0xC2, 0x01, // UÂ (U+0055 U+00C2)
  0x00, 0x55, 0x00, 0xC3, 0x01, // UÃ (U+0055 U+00C3)
  0x00, 0x55, 0x00, 0xC4, 0x01, // UÄ (U+0055 U+00C4)
  0x00, 0x55, 0x00, 0xC5, 0x01, // UÅ (U+0055 U+00C5)
  0x00, 0x55, 0x00, 0xC6, 0x01, // UÆ (U+0055 U+00C6)
  0x00, 0x55, 0x01, 0x00, 0x01, // UĀ (U+0055 U+0100)
  0x00, 0x55, 0x01, 0x02, 0x01, // UĂ (U+0055 U+0102)
  0x00, 0x55, 0x01, 0x04, 0x01, // UĄ (U+0055 U+0104)
  0x00, 0x55, 0x20, 0x1A, 0x01, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x01, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x01, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x26, 0x01, // V& (U+0056 U+0026)
  0x00, 0x56, 0x00, 0x2C, 0x04, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x04, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x03, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x43, 0x01, // VC (U+0056 U+0043)
  0x00, 0x56, 0x00, 0x47, 0x01, // VG (U+0056 U+0047)
  0x00, 0x56, 0x00, 0x4F, 0x01, // VO (U+0056 U+004F)
  0x00, 0x56, 0x00, 0x51, 0x01, // VQ (U+0056 U+0051)
  0x00, 0x56, 0x00, 0x61, 0x02, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x02, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x02, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x02, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x02, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x02, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x02, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x02, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x03, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x03, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x03, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x03, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x03, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x03, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x04, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xC7, 0x01, // VÇ (U+0056 U+00C7)
  0x00, 0x56, 0x00, 0xD2, 0x01, // VÒ (U+0056 U+00D2)
  0x00, 0x56, 0x00, 0xD3, 0x01, // VÓ (U+0056 U+00D3)
  0x00, 0x56, 0x00, 0xD4, 0x01, // VÔ (U+0056 U+00D4)
  0x00, 0x56, 0x00, 0xD5, 0x01, // VÕ (U+0056 U+00D5)
  0x00, 0x56, 0x00, 0xD6, 0x01, // VÖ (U+0056 U+00D6)
  0x00, 0x56, 0x00, 0xD8, 0x01, // VØ (U+0056 U+00D8)
  0x00, 0x56, 0x00, 0xE0, 0x02, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x02, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x02, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x02, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x02, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x02, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x02, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x02, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x02, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x02, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x02, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x02, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x02, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x02, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x02, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x02, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x02, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x02, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x02, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x03, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x02, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x03, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x02, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x03, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x02, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x06, 0x01, // VĆ (U+0056 U+0106)
  0x00, 0x56, 0x01, 0x07, 0x02, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x08, 0x01, // VĈ (U+0056 U+0108)
  0x00, 0x56, 0x01, 0x09, 0x02, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0A, 0x01, // VĊ (U+0056 U+010A)
  0x00, 0x56, 0x01, 0x0B, 0x02, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0C, 0x01, // VČ (U+0056 U+010C)
  0x00, 0x56, 0x01, 0x0D, 0x02, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x02, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x02, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x02, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x02, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x02, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x02, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x02, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1C, 0x01, // VĜ (U+0056 U+011C)
  0x00, 0x56, 0x01, 0x1D, 0x02, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1E, 0x01, // VĞ (U+0056 U+011E)
  0x00, 0x56, 0x01, 0x1F, 0x02, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x20, 0x01, // VĠ (U+0056 U+0120)
  0x00, 0x56, 0x01, 0x21, 0x02, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x22, 0x01, // VĢ (U+0056 U+0122)
  0x00, 0x56, 0x01, 0x23, 0x02, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4C, 0x01, // VŌ (U+0056 U+014C)
  0x00, 0x56, 0x01, 0x4D, 0x02, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4E, 0x01, // VŎ (U+0056 U+014E)
  0x00, 0x56, 0x01, 0x4F, 0x02, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x50, 0x01, // VŐ (U+0056 U+0150)
  0x00, 0x56, 0x01, 0x51, 0x02, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x52, 0x01, // VŒ (U+0056 U+0152)
  0x00, 0x56, 0x01, 0x53, 0x02, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x02, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x02, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x02, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x02, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x04, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x04, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x04, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x26, 0x01, // W& (U+0057 U+0026)
  0x00, 0x57, 0x00, 0x2C, 0x04, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x04, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x02, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x43, 0x01, // WC (U+0057 U+0043)
  0x00, 0x57, 0x00, 0x47, 0x01, // WG (U+0057 U+0047)
  0x00, 0x57, 0x00, 0x4F, 0x01, // WO (U+0057 U+004F)
  0x00, 0x57, 0x00, 0x51, 0x01, // WQ (U+0057 U+0051)
  0x00, 0x57, 0x00, 0x61, 0x02, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x02, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x02, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x02, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x02, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x02, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x02, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0x78, 0x01, // Wx (U+0057 U+0078)
  0x00, 0x57, 0x00, 0xC0, 0x02, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x02, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x02, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x02, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x02, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x02, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x05, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xC7, 0x01, // WÇ (U+0057 U+00C7)
  0x00, 0x57, 0x00, 0xD2, 0x01, // WÒ (U+0057 U+00D2)
  0x00, 0x57, 0x00, 0xD3, 0x01, // WÓ (U+0057 U+00D3)
  0x00, 0x57, 0x00, 0xD4, 0x01, // WÔ (U+0057 U+00D4)
  0x00, 0x57, 0x00, 0xD5, 0x01, // WÕ (U+0057 U+00D5)
  0x00, 0x57, 0x00, 0xD6, 0x01, // WÖ (U+0057 U+00D6)
  0x00, 0x57, 0x00, 0xD8, 0x01, // WØ (U+0057 U+00D8)
  0x00, 0x57, 0x00, 0xE0, 0x02, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x02, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x02, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x02, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x02, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x02, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x02, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x02, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x02, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x02, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x02, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x02, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x02, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x02, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x02, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x02, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x02, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x02, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x02, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x02, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x02, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x02, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x02, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x02, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x02, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x06, 0x01, // WĆ (U+0057 U+0106)
  0x00, 0x57, 0x01, 0x07, 0x02, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x08, 0x01, // WĈ (U+0057 U+0108)
  0x00, 0x57, 0x01, 0x09, 0x02, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0A, 0x01, // WĊ (U+0057 U+010A)
  0x00, 0x57, 0x01, 0x0B, 0x02, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0C, 0x01, // WČ (U+0057 U+010C)
  0x00, 0x57, 0x01, 0x0D, 0x02, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x02, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x02, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x02, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x02, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x02, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x02, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x02, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1C, 0x01, // WĜ (U+0057 U+011C)
  0x00, 0x57, 0x01, 0x1D, 0x02, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1E, 0x01, // WĞ (U+0057 U+011E)
  0x00, 0x57, 0x01, 0x1F, 0x02, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x20, 0x01, // WĠ (U+0057 U+0120)
  0x00, 0x57, 0x01, 0x21, 0x02, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x22, 0x01, // WĢ (U+0057 U+0122)
  0x00, 0x57, 0x01, 0x23, 0x02, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4C, 0x01, // WŌ (U+0057 U+014C)
  0x00, 0x57, 0x01, 0x4D, 0x02, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4E, 0x01, // WŎ (U+0057 U+014E)
  0x00, 0x57, 0x01, 0x4F, 0x02, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x50, 0x01, // WŐ (U+0057 U+0150)
  0x00, 0x57, 0x01, 0x51, 0x02, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x52, 0x01, // WŒ (U+0057 U+0152)
  0x00, 0x57, 0x01, 0x53, 0x02, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x20, 0x1A, 0x04, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x04, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x04, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x43, 0x01, // XC (U+0058 U+0043)
  0x00, 0x58, 0x00, 0x47, 0x01, // XG (U+0058 U+0047)
  0x00, 0x58, 0x00, 0x4F, 0x01, // XO (U+0058 U+004F)
  0x00, 0x58, 0x00, 0x51, 0x01, // XQ (U+0058 U+0051)
  0x00, 0x58, 0x00, 0x77, 0x01, // Xw (U+0058 U+0077)
  0x00, 0x58, 0x00, 0x79, 0x02, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xA9, 0x02, // X© (U+0058 U+00A9)
  0x00, 0x58, 0x00, 0xAE, 0x02, // X® (U+0058 U+00AE)
  0x00, 0x58, 0x00, 0xC7, 0x01, // XÇ (U+0058 U+00C7)
  0x00, 0x58, 0x00, 0xD2, 0x01, // XÒ (U+0058 U+00D2)
  0x00, 0x58, 0x00, 0xD3, 0x01, // XÓ (U+0058 U+00D3)
  0x00, 0x58, 0x00, 0xD4, 0x01, // XÔ (U+0058 U+00D4)
  0x00, 0x58, 0x00, 0xD5, 0x01, // XÕ (U+0058 U+00D5)
  0x00, 0x58, 0x00, 0xD6, 0x01, // XÖ (U+0058 U+00D6)
  0x00, 0x58, 0x00, 0xD8, 0x01, // XØ (U+0058 U+00D8)
  0x00, 0x58, 0x00, 0xFD, 0x02, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x02, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x06, 0x01, // XĆ (U+0058 U+0106)
  0x00, 0x58, 0x01, 0x08, 0x01, // XĈ (U+0058 U+0108)
  0x00, 0x58, 0x01, 0x0A, 0x01, // XĊ (U+0058 U+010A)
  0x00, 0x58, 0x01, 0x0C, 0x01, // XČ (U+0058 U+010C)
  0x00, 0x58, 0x01, 0x1C, 0x01, // XĜ (U+0058 U+011C)
  0x00, 0x58, 0x01, 0x1E, 0x01, // XĞ (U+0058 U+011E)
  0x00, 0x58, 0x01, 0x20, 0x01, // XĠ (U+0058 U+0120)
  0x00, 0x58, 0x01, 0x22, 0x01, // XĢ (U+0058 U+0122)
  0x00, 0x58, 0x01, 0x4C, 0x01, // XŌ (U+0058 U+014C)
  0x00, 0x58, 0x01, 0x4E, 0x01, // XŎ (U+0058 U+014E)
  0x00, 0x58, 0x01, 0x50, 0x01, // XŐ (U+0058 U+0150)
  0x00, 0x58, 0x01, 0x52, 0x01, // XŒ (U+0058 U+0152)
  0x00, 0x58, 0x01, 0x75, 0x01, // Xŵ (U+0058 U+0175)
  0x00, 0x58, 0x01, 0x77, 0x02, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x03, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x03, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x03, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x01, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x01, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x01, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x01, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x53, 0x01, // YS (U+0059 U+0053)
  0x00, 0x59, 0x00, 0x61, 0x02, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x03, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x03, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x03, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x03, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x03, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x03, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x02, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x7A, 0x01, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xC0, 0x03, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x03, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x03, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x03, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x03, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x03, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x04, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xC7, 0x01, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x01, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x01, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x01, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x01, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x01, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x01, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x02, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x02, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x02, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x02, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x02, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x02, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x02, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x03, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x03, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x03, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x03, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x03, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x03, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x03, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x03, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x03, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x03, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x03, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x03, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x03, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x02, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x03, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x02, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x03, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x02, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x01, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x03, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x01, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x03, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x01, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x03, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x01, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x03, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x03, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x03, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x03, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x03, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x03, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x03, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x03, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x01, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x03, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x01, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x03, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x01, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x03, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x01, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x03, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4C, 0x01, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x03, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x01, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x03, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x01, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x03, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x01, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x03, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5A, 0x01, // YŚ (U+0059 U+015A)
  0x00, 0x59, 0x01, 0x5B, 0x02, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5C, 0x01, // YŜ (U+0059 U+015C)
  0x00, 0x59, 0x01, 0x5D, 0x02, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5E, 0x01, // YŞ (U+0059 U+015E)
  0x00, 0x59, 0x01, 0x5F, 0x02, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x60, 0x01, // YŠ (U+0059 U+0160)
  0x00, 0x59, 0x01, 0x61, 0x02, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x01, 0x7A, 0x01, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x01, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x01, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x03, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x03, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x03, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x02, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x02, // a' (U+0061 U+0027)
  0x00, 0x61, 0x00, 0x2A, 0x01, // a* (U+0061 U+002A)
  0x00, 0x61, 0x00, 0x54, 0x01, // aT (U+0061 U+0054)
  0x00, 0x61, 0x00, 0x56, 0x02, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x57, 0x02, // aW (U+0061 U+0057)
  0x00, 0x61, 0x00, 0x59, 0x02, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0xDD, 0x02, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x01, 0x74, 0x02, // aŴ (U+0061 U+0174)
  0x00, 0x61, 0x01, 0x76, 0x02, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x78, 0x02, // aŸ (U+0061 U+0178)
  0x00, 0x61, 0x20, 0x18, 0x01, // a‘ (U+0061 U+2018)
  0x00, 0x61, 0x20, 0x19, 0x01, // a’ (U+0061 U+2019)
  0x00, 0x61, 0x20, 0x1C, 0x01, // a“ (U+0061 U+201C)
  0x00, 0x61, 0x20, 0x1D, 0x01, // a” (U+0061 U+201D)
  0x00, 0x61, 0x21, 0x22, 0x01, // a™ (U+0061 U+2122)
  0x00, 0x62, 0x00, 0x54, 0x01, // bT (U+0062 U+0054)
  0x00, 0x62, 0x00, 0x56, 0x02, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x02, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x03, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0x78, 0x01, // bx (U+0062 U+0078)
  0x00, 0x62, 0x00, 0x79, 0x01, // by (U+0062 U+0079)
  0x00, 0x62, 0x00, 0xDD, 0x03, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x00, 0xFD, 0x01, // bý (U+0062 U+00FD)
  0x00, 0x62, 0x00, 0xFF, 0x01, // bÿ (U+0062 U+00FF)
  0x00, 0x62, 0x01, 0x74, 0x02, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x03, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x77, 0x01, // bŷ (U+0062 U+0177)
  0x00, 0x62, 0x01, 0x78, 0x03, // bŸ (U+0062 U+0178)
  0x00, 0x63, 0x00, 0x56, 0x02, // cV (U+0063 U+0056)
  0x00, 0x63, 0x00, 0x57, 0x02, // cW (U+0063 U+0057)
  0x00, 0x63, 0x00, 0x59, 0x02, // cY (U+0063 U+0059)
  0x00, 0x63, 0x00, 0xDD, 0x02, // cÝ (U+0063 U+00DD)
  0x00, 0x63, 0x01, 0x74, 0x02, // cŴ (U+0063 U+0174)
  0x00, 0x63, 0x01, 0x76, 0x02, // cŶ (U+0063 U+0176)
  0x00, 0x63, 0x01, 0x78, 0x02, // cŸ (U+0063 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x02, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x02, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x02, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x02, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x02, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x02, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x02, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x22, 0x02, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x02, // h' (U+0068 U+0027)
  0x00, 0x68, 0x00, 0x2A, 0x01, // h* (U+0068 U+002A)
  0x00, 0x68, 0x00, 0x54, 0x01, // hT (U+0068 U+0054)
  0x00, 0x68, 0x00, 0x56, 0x02, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x57, 0x02, // hW (U+0068 U+0057)
  0x00, 0x68, 0x00, 0x59, 0x02, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0xDD, 0x02, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x01, 0x74, 0x02, // hŴ (U+0068 U+0174)
  0x00, 0x68, 0x01, 0x76, 0x02, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x78, 0x02, // hŸ (U+0068 U+0178)
  0x00, 0x68, 0x20, 0x18, 0x01, // h‘ (U+0068 U+2018)
  0x00, 0x68, 0x20, 0x19, 0x01, // h’ (U+0068 U+2019)
  0x00, 0x68, 0x20, 0x1C, 0x01, // h“ (U+0068 U+201C)
  0x00, 0x68, 0x20, 0x1D, 0x01, // h” (U+0068 U+201D)
  0x00, 0x68, 0x21, 0x22, 0x01, // h™ (U+0068 U+2122)
  0x00, 0x6D, 0x00, 0x22, 0x02, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x02, // m' (U+006D U+0027)
  0x00, 0x6D, 0x00, 0x2A, 0x01, // m* (U+006D U+002A)
  0x00, 0x6D, 0x00, 0x54, 0x01, // mT (U+006D U+0054)
  0x00, 0x6D, 0x00, 0x56, 0x02, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x57, 0x02, // mW (U+006D U+0057)
  0x00, 0x6D, 0x00, 0x59, 0x02, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0xDD, 0x02, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x01, 0x74, 0x02, // mŴ (U+006D U+0174)
  0x00, 0x6D, 0x01, 0x76, 0x02, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x78, 0x02, // mŸ (U+006D U+0178)
  0x00, 0x6D, 0x20, 0x18, 0x01, // m‘ (U+006D U+2018)
  0x00, 0x6D, 0x20, 0x19, 0x01, // m’ (U+006D U+2019)
  0x00, 0x6D, 0x20, 0x1C, 0x01, // m“ (U+006D U+201C)
  0x00, 0x6D, 0x20, 0x1D, 0x01, // m” (U+006D U+201D)
  0x00, 0x6D, 0x21, 0x22, 0x01, // m™ (U+006D U+2122)
  0x00, 0x6E, 0x00, 0x22, 0x02, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x02, // n' (U+006E U+0027)
  0x00, 0x6E, 0x00, 0x2A, 0x01, // n* (U+006E U+002A)
  0x00, 0x6E, 0x00, 0x54, 0x01, // nT (U+006E U+0054)
  0x00, 0x6E, 0x00, 0x56, 0x02, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x57, 0x02, // nW (U+006E U+0057)
  0x00, 0x6E, 0x00, 0x59, 0x02, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0xDD, 0x02, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x01, 0x74, 0x02, // nŴ (U+006E U+0174)
  0x00, 0x6E, 0x01, 0x76, 0x02, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x78, 0x02, // nŸ (U+006E U+0178)
  0x00, 0x6E, 0x20, 0x18, 0x01, // n‘ (U+006E U+2018)
  0x00, 0x6E, 0x20, 0x19, 0x01, // n’ (U+006E U+2019)
  0x00, 0x6E, 0x20, 0x1C, 0x01, // n“ (U+006E U+201C)
  0x00, 0x6E, 0x20, 0x1D, 0x01, // n” (U+006E U+201D)
  0x00, 0x6E, 0x21, 0x22, 0x01, // n™ (U+006E U+2122)
  0x00, 0x6F, 0x00, 0x54, 0x01, // oT (U+006F U+0054)
  0x00, 0x6F, 0x00, 0x56, 0x02, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x02, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x03, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0x78, 0x01, // ox (U+006F U+0078)
  0x00, 0x6F, 0x00, 0x79, 0x01, // oy (U+006F U+0079)
  0x00, 0x6F, 0x00, 0xDD, 0x03, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x00, 0xFD, 0x01, // oý (U+006F U+00FD)
  0x00, 0x6F, 0x00, 0xFF, 0x01, // oÿ (U+006F U+00FF)
  0x00, 0x6F, 0x01, 0x74, 0x02, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x03, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x77, 0x01, // oŷ (U+006F U+0177)
  0x00, 0x6F, 0x01, 0x78, 0x03, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x54, 0x01, // pT (U+0070 U+0054)
  0x00, 0x70, 0x00, 0x56, 0x02, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x02, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x03, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0x78, 0x01, // px (U+0070 U+0078)
  0x00, 0x70, 0x00, 0x79, 0x01, // py (U+0070 U+0079)
  0x00, 0x70, 0x00, 0xDD, 0x03, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x00, 0xFD, 0x01, // pý (U+0070 U+00FD)
  0x00, 0x70, 0x00, 0xFF, 0x01, // pÿ (U+0070 U+00FF)
  0x00, 0x70, 0x01, 0x74, 0x02, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x03, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x77, 0x01, // pŷ (U+0070 U+0177)
  0x00, 0x70, 0x01, 0x78, 0x03, // pŸ (U+0070 U+0178)
  0x00, 0x71, 0x00, 0x56, 0x01, // qV (U+0071 U+0056)
  0x00, 0x71, 0x00, 0x57, 0x02, // qW (U+0071 U+0057)
  0x00, 0x71, 0x00, 0x59, 0x01, // qY (U+0071 U+0059)
  0x00, 0x71, 0x00, 0xDD, 0x01, // qÝ (U+0071 U+00DD)
  0x00, 0x71, 0x01, 0x74, 0x02, // qŴ (U+0071 U+0174)
  0x00, 0x71, 0x01, 0x76, 0x01, // qŶ (U+0071 U+0176)
  0x00, 0x71, 0x01, 0x78, 0x01, // qŸ (U+0071 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x06, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x06, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x56, 0x01, // rV (U+0072 U+0056)
  0x00, 0x72, 0x00, 0x57, 0x02, // rW (U+0072 U+0057)
  0x00, 0x72, 0x00, 0x58, 0x02, // rX (U+0072 U+0058)
  0x00, 0x72, 0x00, 0x59, 0x01, // rY (U+0072 U+0059)
  0x00, 0x72, 0x00, 0x61, 0x01, // ra (U+0072 U+0061)
  0x00, 0x72, 0x00, 0x63, 0x01, // rc (U+0072 U+0063)
  0x00, 0x72, 0x00, 0x64, 0x01, // rd (U+0072 U+0064)
  0x00, 0x72, 0x00, 0x65, 0x01, // re (U+0072 U+0065)
  0x00, 0x72, 0x00, 0x67, 0x01, // rg (U+0072 U+0067)
  0x00, 0x72, 0x00, 0x6F, 0x01, // ro (U+0072 U+006F)
  0x00, 0x72, 0x00, 0x71, 0x01, // rq (U+0072 U+0071)
  0x00, 0x72, 0x00, 0xDD, 0x01, // rÝ (U+0072 U+00DD)
  0x00, 0x72, 0x00, 0xE0, 0x01, // rà (U+0072 U+00E0)
  0x00, 0x72, 0x00, 0xE1, 0x01, // rá (U+0072 U+00E1)
  0x00, 0x72, 0x00, 0xE2, 0x01, // râ (U+0072 U+00E2)
  0x00, 0x72, 0x00, 0xE3, 0x01, // rã (U+0072 U+00E3)
  0x00, 0x72, 0x00, 0xE4, 0x01, // rä (U+0072 U+00E4)
  0x00, 0x72, 0x00, 0xE5, 0x01, // rå (U+0072 U+00E5)
  0x00, 0x72, 0x00, 0xE6, 0x01, // ræ (U+0072 U+00E6)
  0x00, 0x72, 0x00, 0xE7, 0x01, // rç (U+0072 U+00E7)
  0x00, 0x72, 0x00, 0xE8, 0x01, // rè (U+0072 U+00E8)
  0x00, 0x72, 0x00, 0xE9, 0x01, // ré (U+0072 U+00E9)
  0x00, 0x72, 0x00, 0xEA, 0x01, // rê (U+0072 U+00EA)
  0x00, 0x72, 0x00, 0xEB, 0x01, // rë (U+0072 U+00EB)
  0x00, 0x72, 0x00, 0xF0, 0x01, // rð (U+0072 U+00F0)
  0x00, 0x72, 0x00, 0xF2, 0x01, // rò (U+0072 U+00F2)
  0x00, 0x72, 0x00, 0xF3, 0x01, // ró (U+0072 U+00F3)
  0x00, 0x72, 0x00, 0xF4, 0x01, // rô (U+0072 U+00F4)
  0x00, 0x72, 0x00, 0xF5, 0x01, // rõ (U+0072 U+00F5)
  0x00, 0x72, 0x00, 0xF6, 0x01, // rö (U+0072 U+00F6)
  0x00, 0x72, 0x00, 0xF8, 0x01, // rø (U+0072 U+00F8)
  0x00, 0x72, 0x01, 0x01, 0x01, // rā (U+0072 U+0101)
  0x00, 0x72, 0x01, 0x03, 0x01, // ră (U+0072 U+0103)
  0x00, 0x72, 0x01, 0x05, 0x01, // rą (U+0072 U+0105)
  0x00, 0x72, 0x01, 0x07, 0x01, // rć (U+0072 U+0107)
  0x00, 0x72, 0x01, 0x09, 0x01, // rĉ (U+0072 U+0109)
  0x00, 0x72, 0x01, 0x0B, 0x01, // rċ (U+0072 U+010B)
  0x00, 0x72, 0x01, 0x0D, 0x01, // rč (U+0072 U+010D)
  0x00, 0x72, 0x01, 0x0F, 0x01, // rď (U+0072 U+010F)
  0x00, 0x72, 0x01, 0x11, 0x01, // rđ (U+0072 U+0111)
  0x00, 0x72, 0x01, 0x13, 0x01, // rē (U+0072 U+0113)
  0x00, 0x72, 0x01, 0x15, 0x01, // rĕ (U+0072 U+0115)
  0x00, 0x72, 0x01, 0x17, 0x01, // rė (U+0072 U+0117)
  0x00, 0x72, 0x01, 0x19, 0x01, // rę (U+0072 U+0119)
  0x00, 0x72, 0x01, 0x1B, 0x01, // rě (U+0072 U+011B)
  0x00, 0x72, 0x01, 0x1D, 0x01, // rĝ (U+0072 U+011D)
  0x00, 0x72, 0x01, 0x1F, 0x01, // rğ (U+0072 U+011F)
  0x00, 0x72, 0x01, 0x21, 0x01, // rġ (U+0072 U+0121)
  0x00, 0x72, 0x01, 0x23, 0x01, // rģ (U+0072 U+0123)
  0x00, 0x72, 0x01, 0x4D, 0x01, // rō (U+0072 U+014D)
  0x00, 0x72, 0x01, 0x4F, 0x01, // rŏ (U+0072 U+014F)
  0x00, 0x72, 0x01, 0x51, 0x01, // rő (U+0072 U+0151)
  0x00, 0x72, 0x01, 0x53, 0x01, // rœ (U+0072 U+0153)
  0x00, 0x72, 0x01, 0x74, 0x02, // rŴ (U+0072 U+0174)
  0x00, 0x72, 0x01, 0x76, 0x01, // rŶ (U+0072 U+0176)
  0x00, 0x72, 0x01, 0x78, 0x01, // rŸ (U+0072 U+0178)
  0x00, 0x72, 0x20, 0x1A, 0x06, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x06, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x06, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x22, 0x01, // s" (U+0073 U+0022)
  0x00, 0x73, 0x00, 0x27, 0x01, // s' (U+0073 U+0027)
  0x00, 0x73, 0x00, 0x56, 0x01, // sV (U+0073 U+0056)
  0x00, 0x73, 0x00, 0x57, 0x01, // sW (U+0073 U+0057)
  0x00, 0x73, 0x00, 0x59, 0x02, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x02, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x74, 0x01, // sŴ (U+0073 U+0174)
  0x00, 0x73, 0x01, 0x76, 0x02, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x02, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x02, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x03, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x01, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0x56, 0x01, // vV (U+0076 U+0056)
  0x00, 0x76, 0x00, 0x57, 0x01, // vW (U+0076 U+0057)
  0x00, 0x76, 0x00, 0x59, 0x01, // vY (U+0076 U+0059)
  0x00, 0x76, 0x00, 0xC0, 0x01, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x01, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x01, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x01, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x01, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x01, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x00, 0xDD, 0x01, // vÝ (U+0076 U+00DD)
  0x00, 0x76, 0x01, 0x00, 0x01, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x01, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x01, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x01, 0x74, 0x01, // vŴ (U+0076 U+0174)
  0x00, 0x76, 0x01, 0x76, 0x01, // vŶ (U+0076 U+0176)
  0x00, 0x76, 0x01, 0x78, 0x01, // vŸ (U+0076 U+0178)
  0x00, 0x76, 0x20, 0x1A, 0x03, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x03, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x03, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x03, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x03, // w. (U+0077 U+002E)
  0x00, 0x77, 0x00, 0x41, 0x01, // wA (U+0077 U+0041)
  0x00, 0x77, 0x00, 0x56, 0x01, // wV (U+0077 U+0056)
  0x00, 0x77, 0x00, 0x57, 0x01, // wW (U+0077 U+0057)
  0x00, 0x77, 0x00, 0x59, 0x01, // wY (U+0077 U+0059)
  0x00, 0x77, 0x00, 0xC0, 0x01, // wÀ (U+0077 U+00C0)
  0x00, 0x77, 0x00, 0xC1, 0x01, // wÁ (U+0077 U+00C1)
  0x00, 0x77, 0x00, 0xC2, 0x01, // wÂ (U+0077 U+00C2)
  0x00, 0x77, 0x00, 0xC3, 0x01, // wÃ (U+0077 U+00C3)
  0x00, 0x77, 0x00, 0xC4, 0x01, // wÄ (U+0077 U+00C4)
  0x00, 0x77, 0x00, 0xC5, 0x01, // wÅ (U+0077 U+00C5)
  0x00, 0x77, 0x00, 0xDD, 0x01, // wÝ (U+0077 U+00DD)
  0x00, 0x77, 0x01, 0x00, 0x01, // wĀ (U+0077 U+0100)
  0x00, 0x77, 0x01, 0x02, 0x01, // wĂ (U+0077 U+0102)
  0x00, 0x77, 0x01, 0x04, 0x01, // wĄ (U+0077 U+0104)
  0x00, 0x77, 0x01, 0x74, 0x01, // wŴ (U+0077 U+0174)
  0x00, 0x77, 0x01, 0x76, 0x01, // wŶ (U+0077 U+0176)
  0x00, 0x77, 0x01, 0x78, 0x01, // wŸ (U+0077 U+0178)
  0x00, 0x77, 0x20, 0x1A, 0x03, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x03, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x03, // w… (U+0077 U+2026)
  0x00, 0x78, 0x00, 0x57, 0x01, // xW (U+0078 U+0057)
  0x00, 0x78, 0x00, 0x59, 0x01, // xY (U+0078 U+0059)
  0x00, 0x78, 0x00, 0xDD, 0x01, // xÝ (U+0078 U+00DD)
  0x00, 0x78, 0x01, 0x74, 0x01, // xŴ (U+0078 U+0174)
  0x00, 0x78, 0x01, 0x76, 0x01, // xŶ (U+0078 U+0176)
  0x00, 0x78, 0x01, 0x78, 0x01, // xŸ (U+0078 U+0178)
  0x00, 0x79, 0x00, 0x2C, 0x03, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x03, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x01, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0x56, 0x01, // yV (U+0079 U+0056)
  0x00, 0x79, 0x00, 0x57, 0x01, // yW (U+0079 U+0057)
  0x00, 0x79, 0x00, 0x59, 0x01, // yY (U+0079 U+0059)
  0x00, 0x79, 0x00, 0xC0, 0x01, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x01, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x01, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x01, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x01, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x01, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x00, 0xDD, 0x01, // yÝ (U+0079 U+00DD)
  0x00, 0x79, 0x01, 0x00, 0x01, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x01, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x01, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x01, 0x74, 0x01, // yŴ (U+0079 U+0174)
  0x00, 0x79, 0x01, 0x76, 0x01, // yŶ (U+0079 U+0176)
  0x00, 0x79, 0x01, 0x78, 0x01, // yŸ (U+0079 U+0178)
  0x00, 0x79, 0x20, 0x1A, 0x03, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x03, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x03, // y… (U+0079 U+2026)
  0x00, 0x7A, 0x00, 0x2A, 0x01, // z* (U+007A U+002A)
  0x00, 0x7A, 0x00, 0x56, 0x02, // zV (U+007A U+0056)
  0x00, 0x7A, 0x00, 0x57, 0x01, // zW (U+007A U+0057)
  0x00, 0x7A, 0x00, 0x59, 0x01, // zY (U+007A U+0059)
  0x00, 0x7A, 0x00, 0xDD, 0x01, // zÝ (U+007A U+00DD)
  0x00, 0x7A, 0x01, 0x74, 0x01, // zŴ (U+007A U+0174)
  0x00, 0x7A, 0x01, 0x76, 0x01, // zŶ (U+007A U+0176)
  0x00, 0x7A, 0x01, 0x78, 0x01, // zŸ (U+007A U+0178)
  0x00, 0x7A, 0x20, 0x18, 0x01, // z‘ (U+007A U+2018)
  0x00, 0x7A, 0x20, 0x19, 0x01, // z’ (U+007A U+2019)
  0x00, 0x7A, 0x20, 0x1C, 0x01, // z“ (U+007A U+201C)
  0x00, 0x7A, 0x20, 0x1D, 0x01, // z” (U+007A U+201D)
  0x00, 0x7A, 0x21, 0x22, 0x01, // z™ (U+007A U+2122)
  0x00, 0xA1, 0x00, 0x54, 0x01, // ¡T (U+00A1 U+0054)
  0x00, 0xA1, 0x00, 0x56, 0x02, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x57, 0x01, // ¡W (U+00A1 U+0057)
  0x00, 0xA1, 0x00, 0x59, 0x02, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x02, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x74, 0x01, // ¡Ŵ (U+00A1 U+0174)
  0x00, 0xA1, 0x01, 0x76, 0x02, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x02, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x02, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x02, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x02, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x02, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x02, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x02, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x02, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x03, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x26, 0x01, // À& (U+00C0 U+0026)
  0x00, 0xC0, 0x00, 0x27, 0x03, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x03, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x43, 0x01, // ÀC (U+00C0 U+0043)
  0x00, 0xC0, 0x00, 0x47, 0x01, // ÀG (U+00C0 U+0047)
  0x00, 0xC0, 0x00, 0x4F, 0x01, // ÀO (U+00C0 U+004F)
  0x00, 0xC0, 0x00, 0x51, 0x01, // ÀQ (U+00C0 U+0051)
  0x00, 0xC0, 0x00, 0x54, 0x02, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x55, 0x01, // ÀU (U+00C0 U+0055)
  0x00, 0xC0, 0x00, 0x56, 0x03, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x03, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x03, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x63, 0x01, // Àc (U+00C0 U+0063)
  0x00, 0xC0, 0x00, 0x64, 0x01, // Àd (U+00C0 U+0064)
  0x00, 0xC0, 0x00, 0x65, 0x01, // Àe (U+00C0 U+0065)
  0x00, 0xC0, 0x00, 0x67, 0x01, // Àg (U+00C0 U+0067)
  0x00, 0xC0, 0x00, 0x6F, 0x01, // Ào (U+00C0 U+006F)
  0x00, 0xC0, 0x00, 0x71, 0x01, // Àq (U+00C0 U+0071)
  0x00, 0xC0, 0x00, 0x75, 0x01, // Àu (U+00C0 U+0075)
  0x00, 0xC0, 0x00, 0x76, 0x02, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x77, 0x01, // Àw (U+00C0 U+0077)
  0x00, 0xC0, 0x00, 0x79, 0x02, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xA9, 0x02, // À© (U+00C0 U+00A9)
  0x00, 0xC0, 0x00, 0xAE, 0x02, // À® (U+00C0 U+00AE)
  0x00, 0xC0, 0x00, 0xC7, 0x01, // ÀÇ (U+00C0 U+00C7)
  0x00, 0xC0, 0x00, 0xD2, 0x01, // ÀÒ (U+00C0 U+00D2)
  0x00, 0xC0, 0x00, 0xD3, 0x01, // ÀÓ (U+00C0 U+00D3)
  0x00, 0xC0, 0x00, 0xD4, 0x01, // ÀÔ (U+00C0 U+00D4)
  0x00, 0xC0, 0x00, 0xD5, 0x01, // ÀÕ (U+00C0 U+00D5)
  0x00, 0xC0, 0x00, 0xD6, 0x01, // ÀÖ (U+00C0 U+00D6)
  0x00, 0xC0, 0x00, 0xD8, 0x01, // ÀØ (U+00C0 U+00D8)
  0x00, 0xC0, 0x00, 0xD9, 0x01, // ÀÙ (U+00C0 U+00D9)
  0x00, 0xC0, 0x00, 0xDA, 0x01, // ÀÚ (U+00C0 U+00DA)
  0x00, 0xC0, 0x00, 0xDB, 0x01, // ÀÛ (U+00C0 U+00DB)
  0x00, 0xC0, 0x00, 0xDC, 0x01, // ÀÜ (U+00C0 U+00DC)
  0x00, 0xC0, 0x00, 0xDD, 0x03, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xE7, 0x01, // Àç (U+00C0 U+00E7)
  0x00, 0xC0, 0x00, 0xE8, 0x01, // Àè (U+00C0 U+00E8)
  0x00, 0xC0, 0x00, 0xE9, 0x01, // Àé (U+00C0 U+00E9)
  0x00, 0xC0, 0x00, 0xEA, 0x01, // Àê (U+00C0 U+00EA)
  0x00, 0xC0, 0x00, 0xEB, 0x01, // Àë (U+00C0 U+00EB)
  0x00, 0xC0, 0x00, 0xF0, 0x01, // Àð (U+00C0 U+00F0)
  0x00, 0xC0, 0x00, 0xF2, 0x01, // Àò (U+00C0 U+00F2)
  0x00, 0xC0, 0x00, 0xF3, 0x01, // Àó (U+00C0 U+00F3)
  0x00, 0xC0, 0x00, 0xF4, 0x01, // Àô (U+00C0 U+00F4)
  0x00, 0xC0, 0x00, 0xF5, 0x01, // Àõ (U+00C0 U+00F5)
  0x00, 0xC0, 0x00, 0xF6, 0x01, // Àö (U+00C0 U+00F6)
  0x00, 0xC0, 0x00, 0xF8, 0x01, // Àø (U+00C0 U+00F8)
  0x00, 0xC0, 0x00, 0xF9, 0x01, // Àù (U+00C0 U+00F9)
  0x00, 0xC0, 0x00, 0xFA, 0x01, // Àú (U+00C0 U+00FA)
  0x00, 0xC0, 0x00, 0xFB, 0x01, // Àû (U+00C0 U+00FB)
  0x00, 0xC0, 0x00, 0xFC, 0x01, // Àü (U+00C0 U+00FC)
  0x00, 0xC0, 0x00, 0xFD, 0x02, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x02, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x06, 0x01, // ÀĆ (U+00C0 U+0106)
  0x00, 0xC0, 0x01, 0x07, 0x01, // Àć (U+00C0 U+0107)
  0x00, 0xC0, 0x01, 0x08, 0x01, // ÀĈ (U+00C0 U+0108)
  0x00, 0xC0, 0x01, 0x09, 0x01, // Àĉ (U+00C0 U+0109)
  0x00, 0xC0, 0x01, 0x0A, 0x01, // ÀĊ (U+00C0 U+010A)
  0x00, 0xC0, 0x01, 0x0B, 0x01, // Àċ (U+00C0 U+010B)
  0x00, 0xC0, 0x01, 0x0C, 0x01, // ÀČ (U+00C0 U+010C)
  0x00, 0xC0, 0x01, 0x0D, 0x01, // Àč (U+00C0 U+010D)
  0x00, 0xC0, 0x01, 0x0F, 0x01, // Àď (U+00C0 U+010F)
  0x00, 0xC0, 0x01, 0x11, 0x01, // Àđ (U+00C0 U+0111)
  0x00, 0xC0, 0x01, 0x13, 0x01, // Àē (U+00C0 U+0113)
  0x00, 0xC0, 0x01, 0x15, 0x01, // Àĕ (U+00C0 U+0115)
  0x00, 0xC0, 0x01, 0x17, 0x01, // Àė (U+00C0 U+0117)
  0x00, 0xC0, 0x01, 0x19, 0x01, // Àę (U+00C0 U+0119)
  0x00, 0xC0, 0x01, 0x1B, 0x01, // Àě (U+00C0 U+011B)
  0x00, 0xC0, 0x01, 0x1C, 0x01, // ÀĜ (U+00C0 U+011C)
  0x00, 0xC0, 0x01, 0x1D, 0x01, // Àĝ (U+00C0 U+011D)
  0x00, 0xC0, 0x01, 0x1E, 0x01, // ÀĞ (U+00C0 U+011E)
  0x00, 0xC0, 0x01, 0x1F, 0x01, // Àğ (U+00C0 U+011F)
  0x00, 0xC0, 0x01, 0x20, 0x01, // ÀĠ (U+00C0 U+0120)
  0x00, 0xC0, 0x01, 0x21, 0x01, // Àġ (U+00C0 U+0121)
  0x00, 0xC0, 0x01, 0x22, 0x01, // ÀĢ (U+00C0 U+0122)
  0x00, 0xC0, 0x01, 0x23, 0x01, // Àģ (U+00C0 U+0123)
  0x00, 0xC0, 0x01, 0x49, 0x02, // Àŉ (U+00C0 U+0149)
  0x00, 0xC0, 0x01, 0x4C, 0x01, // ÀŌ (U+00C0 U+014C)
  0x00, 0xC0, 0x01, 0x4D, 0x01, // Àō (U+00C0 U+014D)
  0x00, 0xC0, 0x01, 0x4E, 0x01, // ÀŎ (U+00C0 U+014E)
  0x00, 0xC0, 0x01, 0x4F, 0x01, // Àŏ (U+00C0 U+014F)
  0x00, 0xC0, 0x01, 0x50, 0x01, // ÀŐ (U+00C0 U+0150)
  0x00, 0xC0, 0x01, 0x51, 0x01, // Àő (U+00C0 U+0151)
  0x00, 0xC0, 0x01, 0x52, 0x01, // ÀŒ (U+00C0 U+0152)
  0x00, 0xC0, 0x01, 0x53, 0x01, // Àœ (U+00C0 U+0153)
  0x00, 0xC0, 0x01, 0x68, 0x01, // ÀŨ (U+00C0 U+0168)
  0x00, 0xC0, 0x01, 0x69, 0x01, // Àũ (U+00C0 U+0169)
  0x00, 0xC0, 0x01, 0x6A, 0x01, // ÀŪ (U+00C0 U+016A)
  0x00, 0xC0, 0x01, 0x6B, 0x01, // Àū (U+00C0 U+016B)
  0x00, 0xC0, 0x01, 0x6C, 0x01, // ÀŬ (U+00C0 U+016C)
  0x00, 0xC0, 0x01, 0x6D, 0x01, // Àŭ (U+00C0 U+016D)
  0x00, 0xC0, 0x01, 0x6E, 0x01, // ÀŮ (U+00C0 U+016E)
  0x00, 0xC0, 0x01, 0x6F, 0x01, // Àů (U+00C0 U+016F)
  0x00, 0xC0, 0x01, 0x70, 0x01, // ÀŰ (U+00C0 U+0170)
  0x00, 0xC0, 0x01, 0x71, 0x01, // Àű (U+00C0 U+0171)
  0x00, 0xC0, 0x01, 0x72, 0x01, // ÀŲ (U+00C0 U+0172)
  0x00, 0xC0, 0x01, 0x73, 0x01, // Àų (U+00C0 U+0173)
  0x00, 0xC0, 0x01, 0x74, 0x03, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x75, 0x01, // Àŵ (U+00C0 U+0175)
  0x00, 0xC0, 0x01, 0x76, 0x03, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x02, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x03, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x04, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x03, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x04, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x03, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x03, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x03, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x26, 0x01, // Á& (U+00C1 U+0026)
  0x00, 0xC1, 0x00, 0x27, 0x03, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x03, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x43, 0x01, // ÁC (U+00C1 U+0043)
  0x00, 0xC1, 0x00, 0x47, 0x01, // ÁG (U+00C1 U+0047)
  0x00, 0xC1, 0x00, 0x4F, 0x01, // ÁO (U+00C1 U+004F)
  0x00, 0xC1, 0x00, 0x51, 0x01, // ÁQ (U+00C1 U+0051)
  0x00, 0xC1, 0x00, 0x54, 0x02, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x55, 0x01, // ÁU (U+00C1 U+0055)
  0x00, 0xC1, 0x00, 0x56, 0x03, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x03, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x03, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x63, 0x01, // Ác (U+00C1 U+0063)
  0x00, 0xC1, 0x00, 0x64, 0x01, // Ád (U+00C1 U+0064)
  0x00, 0xC1, 0x00, 0x65, 0x01, // Áe (U+00C1 U+0065)
  0x00, 0xC1, 0x00, 0x67, 0x01, // Ág (U+00C1 U+0067)
  0x00, 0xC1, 0x00, 0x6F, 0x01, // Áo (U+00C1 U+006F)
  0x00, 0xC1, 0x00, 0x71, 0x01, // Áq (U+00C1 U+0071)
  0x00, 0xC1, 0x00, 0x75, 0x01, // Áu (U+00C1 U+0075)
  0x00, 0xC1, 0x00, 0x76, 0x02, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x77, 0x01, // Áw (U+00C1 U+0077)
  0x00, 0xC1, 0x00, 0x79, 0x02, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xA9, 0x02, // Á© (U+00C1 U+00A9)
  0x00, 0xC1, 0x00, 0xAE, 0x02, // Á® (U+00C1 U+00AE)
  0x00, 0xC1, 0x00, 0xC7, 0x01, // ÁÇ (U+00C1 U+00C7)
  0x00, 0xC1, 0x00, 0xD2, 0x01, // ÁÒ (U+00C1 U+00D2)
  0x00, 0xC1, 0x00, 0xD3, 0x01, // ÁÓ (U+00C1 U+00D3)
  0x00, 0xC1, 0x00, 0xD4, 0x01, // ÁÔ (U+00C1 U+00D4)
  0x00, 0xC1, 0x00, 0xD5, 0x01, // ÁÕ (U+00C1 U+00D5)
  0x00, 0xC1, 0x00, 0xD6, 0x01, // ÁÖ (U+00C1 U+00D6)
  0x00, 0xC1, 0x00, 0xD8, 0x01, // ÁØ (U+00C1 U+00D8)
  0x00, 0xC1, 0x00, 0xD9, 0x01, // ÁÙ (U+00C1 U+00D9)
  0x00, 0xC1, 0x00, 0xDA, 0x01, // ÁÚ (U+00C1 U+00DA)
  0x00, 0xC1, 0x00, 0xDB, 0x01, // ÁÛ (U+00C1 U+00DB)
  0x00, 0xC1, 0x00, 0xDC, 0x01, // ÁÜ (U+00C1 U+00DC)
  0x00, 0xC1, 0x00, 0xDD, 0x03, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xE7, 0x01, // Áç (U+00C1 U+00E7)
  0x00, 0xC1, 0x00, 0xE8, 0x01, // Áè (U+00C1 U+00E8)
  0x00, 0xC1, 0x00, 0xE9, 0x01, // Áé (U+00C1 U+00E9)
  0x00, 0xC1, 0x00, 0xEA, 0x01, // Áê (U+00C1 U+00EA)
  0x00, 0xC1, 0x00, 0xEB, 0x01, // Áë (U+00C1 U+00EB)
  0x00, 0xC1, 0x00, 0xF0, 0x01, // Áð (U+00C1 U+00F0)
  0x00, 0xC1, 0x00, 0xF2, 0x01, // Áò (U+00C1 U+00F2)
  0x00, 0xC1, 0x00, 0xF3, 0x01, // Áó (U+00C1 U+00F3)
  0x00, 0xC1, 0x00, 0xF4, 0x01, // Áô (U+00C1 U+00F4)
  0x00, 0xC1, 0x00, 0xF5, 0x01, // Áõ (U+00C1 U+00F5)
  0x00, 0xC1, 0x00, 0xF6, 0x01, // Áö (U+00C1 U+00F6)
  0x00, 0xC1, 0x00, 0xF8, 0x01, // Áø (U+00C1 U+00F8)
  0x00, 0xC1, 0x00, 0xF9, 0x01, // Áù (U+00C1 U+00F9)
  0x00, 0xC1, 0x00, 0xFA, 0x01, // Áú (U+00C1 U+00FA)
  0x00, 0xC1, 0x00, 0xFB, 0x01, // Áû (U+00C1 U+00FB)
  0x00, 0xC1, 0x00, 0xFC, 0x01, // Áü (U+00C1 U+00FC)
  0x00, 0xC1, 0x00, 0xFD, 0x02, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x02, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x06, 0x01, // ÁĆ (U+00C1 U+0106)
  0x00, 0xC1, 0x01, 0x07, 0x01, // Áć (U+00C1 U+0107)
  0x00, 0xC1, 0x01, 0x08, 0x01, // ÁĈ (U+00C1 U+0108)
  0x00, 0xC1, 0x01, 0x09, 0x01, // Áĉ (U+00C1 U+0109)
  0x00, 0xC1, 0x01, 0x0A, 0x01, // ÁĊ (U+00C1 U+010A)
  0x00, 0xC1, 0x01, 0x0B, 0x01, // Áċ (U+00C1 U+010B)
  0x00, 0xC1, 0x01, 0x0C, 0x01, // ÁČ (U+00C1 U+010C)
  0x00, 0xC1, 0x01, 0x0D, 0x01, // Áč (U+00C1 U+010D)
  0x00, 0xC1, 0x01, 0x0F, 0x01, // Áď (U+00C1 U+010F)
  0x00, 0xC1, 0x01, 0x11, 0x01, // Áđ (U+00C1 U+0111)
  0x00, 0xC1, 0x01, 0x13, 0x01, // Áē (U+00C1 U+0113)
  0x00, 0xC1, 0x01, 0x15, 0x01, // Áĕ (U+00C1 U+0115)
  0x00, 0xC1, 0x01, 0x17, 0x01, // Áė (U+00C1 U+0117)
  0x00, 0xC1, 0x01, 0x19, 0x01, // Áę (U+00C1 U+0119)
  0x00, 0xC1, 0x01, 0x1B, 0x01, // Áě (U+00C1 U+011B)
  0x00, 0xC1, 0x01, 0x1C, 0x01, // ÁĜ (U+00C1 U+011C)
  0x00, 0xC1, 0x01, 0x1D, 0x01, // Áĝ (U+00C1 U+011D)
  0x00, 0xC1, 0x01, 0x1E, 0x01, // ÁĞ (U+00C1 U+011E)
  0x00, 0xC1, 0x01, 0x1F, 0x01, // Áğ (U+00C1 U+011F)
  0x00, 0xC1, 0x01, 0x20, 0x01, // ÁĠ (U+00C1 U+0120)
  0x00, 0xC1, 0x01, 0x21, 0x01, // Áġ (U+00C1 U+0121)
  0x00, 0xC1, 0x01, 0x22, 0x01, // ÁĢ (U+00C1 U+0122)
  0x00, 0xC1, 0x01, 0x23, 0x01, // Áģ (U+00C1 U+0123)
  0x00, 0xC1, 0x01, 0x49, 0x02, // Áŉ (U+00C1 U+0149)
  0x00, 0xC1, 0x01, 0x4C, 0x01, // ÁŌ (U+00C1 U+014C)
  0x00, 0xC1, 0x01, 0x4D, 0x01, // Áō (U+00C1 U+014D)
  0x00, 0xC1, 0x01, 0x4E, 0x01, // ÁŎ (U+00C1 U+014E)
  0x00, 0xC1, 0x01, 0x4F, 0x01, // Áŏ (U+00C1 U+014F)
  0x00, 0xC1, 0x01, 0x50, 0x01, // ÁŐ (U+00C1 U+0150)
  0x00, 0xC1, 0x01, 0x51, 0x01, // Áő (U+00C1 U+0151)
  0x00, 0xC1, 0x01, 0x52, 0x01, // ÁŒ (U+00C1 U+0152)
  0x00, 0xC1, 0x01, 0x53, 0x01, // Áœ (U+00C1 U+0153)
  0x00, 0xC1, 0x01, 0x68, 0x01, // ÁŨ (U+00C1 U+0168)
  0x00, 0xC1, 0x01, 0x69, 0x01, // Áũ (U+00C1 U+0169)
  0x00, 0xC1, 0x01, 0x6A, 0x01, // ÁŪ (U+00C1 U+016A)
  0x00, 0xC1, 0x01, 0x6B, 0x01, // Áū (U+00C1 U+016B)
  0x00, 0xC1, 0x01, 0x6C, 0x01, // ÁŬ (U+00C1 U+016C)
  0x00, 0xC1, 0x01, 0x6D, 0x01, // Áŭ (U+00C1 U+016D)
  0x00, 0xC1, 0x01, 0x6E, 0x01, // ÁŮ (U+00C1 U+016E)
  0x00, 0xC1, 0x01, 0x6F, 0x01, // Áů (U+00C1 U+016F)
  0x00, 0xC1, 0x01, 0x70, 0x01, // ÁŰ (U+00C1 U+0170)
  0x00, 0xC1, 0x01, 0x71, 0x01, // Áű (U+00C1 U+0171)
  0x00, 0xC1, 0x01, 0x72, 0x01, // ÁŲ (U+00C1 U+0172)
  0x00, 0xC1, 0x01, 0x73, 0x01, // Áų (U+00C1 U+0173)
  0x00, 0xC1, 0x01, 0x74, 0x03, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x75, 0x01, // Áŵ (U+00C1 U+0175)
  0x00, 0xC1, 0x01, 0x76, 0x03, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x02, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x03, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x04, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x03, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x04, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x03, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x03, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x03, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x26, 0x01, // Â& (U+00C2 U+0026)
  0x00, 0xC2, 0x00, 0x27, 0x03, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x03, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x43, 0x01, // ÂC (U+00C2 U+0043)
  0x00, 0xC2, 0x00, 0x47, 0x01, // ÂG (U+00C2 U+0047)
  0x00, 0xC2, 0x00, 0x4F, 0x01, // ÂO (U+00C2 U+004F)
  0x00, 0xC2, 0x00, 0x51, 0x01, // ÂQ (U+00C2 U+0051)
  0x00, 0xC2, 0x00, 0x54, 0x02, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x55, 0x01, // ÂU (U+00C2 U+0055)
  0x00, 0xC2, 0x00, 0x56, 0x03, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x03, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x03, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x63, 0x01, // Âc (U+00C2 U+0063)
  0x00, 0xC2, 0x00, 0x64, 0x01, // Âd (U+00C2 U+0064)
  0x00, 0xC2, 0x00, 0x65, 0x01, // Âe (U+00C2 U+0065)
  0x00, 0xC2, 0x00, 0x67, 0x01, // Âg (U+00C2 U+0067)
  0x00, 0xC2, 0x00, 0x6F, 0x01, // Âo (U+00C2 U+006F)
  0x00, 0xC2, 0x00, 0x71, 0x01, // Âq (U+00C2 U+0071)
  0x00, 0xC2, 0x00, 0x75, 0x01, // Âu (U+00C2 U+0075)
  0x00, 0xC2, 0x00, 0x76, 0x02, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x77, 0x01, // Âw (U+00C2 U+0077)
  0x00, 0xC2, 0x00, 0x79, 0x02, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xA9, 0x02, // Â© (U+00C2 U+00A9)
  0x00, 0xC2, 0x00, 0xAE, 0x02, // Â® (U+00C2 U+00AE)
  0x00, 0xC2, 0x00, 0xC7, 0x01, // ÂÇ (U+00C2 U+00C7)
  0x00, 0xC2, 0x00, 0xD2, 0x01, // ÂÒ (U+00C2 U+00D2)
  0x00, 0xC2, 0x00, 0xD3, 0x01, // ÂÓ (U+00C2 U+00D3)
  0x00, 0xC2, 0x00, 0xD4, 0x01, // ÂÔ (U+00C2 U+00D4)
  0x00, 0xC2, 0x00, 0xD5, 0x01, // ÂÕ (U+00C2 U+00D5)
  0x00, 0xC2, 0x00, 0xD6, 0x01, // ÂÖ (U+00C2 U+00D6)
  0x00, 0xC2, 0x00, 0xD8, 0x01, // ÂØ (U+00C2 U+00D8)
  0x00, 0xC2, 0x00, 0xD9, 0x01, // ÂÙ (U+00C2 U+00D9)
  0x00, 0xC2, 0x00, 0xDA, 0x01, // ÂÚ (U+00C2 U+00DA)
  0x00, 0xC2, 0x00, 0xDB, 0x01, // ÂÛ (U+00C2 U+00DB)
  0x00, 0xC2, 0x00, 0xDC, 0x01, // ÂÜ (U+00C2 U+00DC)
  0x00, 0xC2, 0x00, 0xDD, 0x03, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xE7, 0x01, // Âç (U+00C2 U+00E7)
  0x00, 0xC2, 0x00, 0xE8, 0x01, // Âè (U+00C2 U+00E8)
  0x00, 0xC2, 0x00, 0xE9, 0x01, // Âé (U+00C2 U+00E9)
  0x00, 0xC2, 0x00, 0xEA, 0x01, // Âê (U+00C2 U+00EA)
  0x00, 0xC2, 0x00, 0xEB, 0x01, // Âë (U+00C2 U+00EB)
  0x00, 0xC2, 0x00, 0xF0, 0x01, // Âð (U+00C2 U+00F0)
  0x00, 0xC2, 0x00, 0xF2, 0x01, // Âò (U+00C2 U+00F2)
  0x00, 0xC2, 0x00, 0xF3, 0x01, // Âó (U+00C2 U+00F3)
  0x00, 0xC2, 0x00, 0xF4, 0x01, // Âô (U+00C2 U+00F4)
  0x00, 0xC2, 0x00, 0xF5, 0x01, // Âõ (U+00C2 U+00F5)
  0x00, 0xC2, 0x00, 0xF6, 0x01, // Âö (U+00C2 U+00F6)
  0x00, 0xC2, 0x00, 0xF8, 0x01, // Âø (U+00C2 U+00F8)
  0x00, 0xC2, 0x00, 0xF9, 0x01, // Âù (U+00C2 U+00F9)
  0x00, 0xC2, 0x00, 0xFA, 0x01, // Âú (U+00C2 U+00FA)
  0x00, 0xC2, 0x00, 0xFB, 0x01, // Âû (U+00C2 U+00FB)
  0x00, 0xC2, 0x00, 0xFC, 0x01, // Âü (U+00C2 U+00FC)
  0x00, 0xC2, 0x00, 0xFD, 0x02, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x02, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x06, 0x01, // ÂĆ (U+00C2 U+0106)
  0x00, 0xC2, 0x01, 0x07, 0x01, // Âć (U+00C2 U+0107)
  0x00, 0xC2, 0x01, 0x08, 0x01, // ÂĈ (U+00C2 U+0108)
  0x00, 0xC2, 0x01, 0x09, 0x01, // Âĉ (U+00C2 U+0109)
  0x00, 0xC2, 0x01, 0x0A, 0x01, // ÂĊ (U+00C2 U+010A)
  0x00, 0xC2, 0x01, 0x0B, 0x01, // Âċ (U+00C2 U+010B)
  0x00, 0xC2, 0x01, 0x0C, 0x01, // ÂČ (U+00C2 U+010C)
  0x00, 0xC2, 0x01, 0x0D, 0x01, // Âč (U+00C2 U+010D)
  0x00, 0xC2, 0x01, 0x0F, 0x01, // Âď (U+00C2 U+010F)
  0x00, 0xC2, 0x01, 0x11, 0x01, // Âđ (U+00C2 U+0111)
  0x00, 0xC2, 0x01, 0x13, 0x01, // Âē (U+00C2 U+0113)
  0x00, 0xC2, 0x01, 0x15, 0x01, // Âĕ (U+00C2 U+0115)
  0x00, 0xC2, 0x01, 0x17, 0x01, // Âė (U+00C2 U+0117)
  0x00, 0xC2, 0x01, 0x19, 0x01, // Âę (U+00C2 U+0119)
  0x00, 0xC2, 0x01, 0x1B, 0x01, // Âě (U+00C2 U+011B)
  0x00, 0xC2, 0x01, 0x1C, 0x01, // ÂĜ (U+00C2 U+011C)
  0x00, 0xC2, 0x01, 0x1D, 0x01, // Âĝ (U+00C2 U+011D)
  0x00, 0xC2, 0x01, 0x1E, 0x01, // ÂĞ (U+00C2 U+011E)
  0x00, 0xC2, 0x01, 0x1F, 0x01, // Âğ (U+00C2 U+011F)
  0x00, 0xC2, 0x01, 0x20, 0x01, // ÂĠ (U+00C2 U+0120)
  0x00, 0xC2, 0x01, 0x21, 0x01, // Âġ (U+00C2 U+0121)
  0x00, 0xC2, 0x01, 0x22, 0x01, // ÂĢ (U+00C2 U+0122)
  0x00, 0xC2, 0x01, 0x23, 0x01, // Âģ (U+00C2 U+0123)
  0x00, 0xC2, 0x01, 0x49, 0x02, // Âŉ (U+00C2 U+0149)
  0x00, 0xC2, 0x01, 0x4C, 0x01, // ÂŌ (U+00C2 U+014C)
  0x00, 0xC2, 0x01, 0x4D, 0x01, // Âō (U+00C2 U+014D)
  0x00, 0xC2, 0x01, 0x4E, 0x01, // ÂŎ (U+00C2 U+014E)
  0x00, 0xC2, 0x01, 0x4F, 0x01, // Âŏ (U+00C2 U+014F)
  0x00, 0xC2, 0x01, 0x50, 0x01, // ÂŐ (U+00C2 U+0150)
  0x00, 0xC2, 0x01, 0x51, 0x01, // Âő (U+00C2 U+0151)
  0x00, 0xC2, 0x01, 0x52, 0x01, // ÂŒ (U+00C2 U+0152)
  0x00, 0xC2, 0x01, 0x53, 0x01, // Âœ (U+00C2 U+0153)
  0x00, 0xC2, 0x01, 0x68, 0x01, // ÂŨ (U+00C2 U+0168)
  0x00, 0xC2, 0x01, 0x69, 0x01, // Âũ (U+00C2 U+0169)
  0x00, 0xC2, 0x01, 0x6A, 0x01, // ÂŪ (U+00C2 U+016A)
  0x00, 0xC2, 0x01, 0x6B, 0x01, // Âū (U+00C2 U+016B)
  0x00, 0xC2, 0x01, 0x6C, 0x01, // ÂŬ (U+00C2 U+016C)
  0x00, 0xC2, 0x01, 0x6D, 0x01, // Âŭ (U+00C2 U+016D)
  0x00, 0xC2, 0x01, 0x6E, 0x01, // ÂŮ (U+00C2 U+016E)
  0x00, 0xC2, 0x01, 0x6F, 0x01, // Âů (U+00C2 U+016F)
  0x00, 0xC2, 0x01, 0x70, 0x01, // ÂŰ (U+00C2 U+0170)
  0x00, 0xC2, 0x01, 0x71, 0x01, // Âű (U+00C2 U+0171)
  0x00, 0xC2, 0x01, 0x72, 0x01, // ÂŲ (U+00C2 U+0172)
  0x00, 0xC2, 0x01, 0x73, 0x01, // Âų (U+00C2 U+0173)
  0x00, 0xC2, 0x01, 0x74, 0x03, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x75, 0x01, // Âŵ (U+00C2 U+0175)
  0x00, 0xC2, 0x01, 0x76, 0x03, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x02, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x03, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x04, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x03, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x04, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x03, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x03, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x03, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x26, 0x01, // Ã& (U+00C3 U+0026)
  0x00, 0xC3, 0x00, 0x27, 0x03, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x03, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x43, 0x01, // ÃC (U+00C3 U+0043)
  0x00, 0xC3, 0x00, 0x47, 0x01, // ÃG (U+00C3 U+0047)
  0x00, 0xC3, 0x00, 0x4F, 0x01, // ÃO (U+00C3 U+004F)
  0x00, 0xC3, 0x00, 0x51, 0x01, // ÃQ (U+00C3 U+0051)
  0x00, 0xC3, 0x00, 0x54, 0x02, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x55, 0x01, // ÃU (U+00C3 U+0055)
  0x00, 0xC3, 0x00, 0x56, 0x03, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x03, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x03, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x63, 0x01, // Ãc (U+00C3 U+0063)
  0x00, 0xC3, 0x00, 0x64, 0x01, // Ãd (U+00C3 U+0064)
  0x00, 0xC3, 0x00, 0x65, 0x01, // Ãe (U+00C3 U+0065)
  0x00, 0xC3, 0x00, 0x67, 0x01, // Ãg (U+00C3 U+0067)
  0x00, 0xC3, 0x00, 0x6F, 0x01, // Ão (U+00C3 U+006F)
  0x00, 0xC3, 0x00, 0x71, 0x01, // Ãq (U+00C3 U+0071)
  0x00, 0xC3, 0x00, 0x75, 0x01, // Ãu (U+00C3 U+0075)
  0x00, 0xC3, 0x00, 0x76, 0x02, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x77, 0x01, // Ãw (U+00C3 U+0077)
  0x00, 0xC3, 0x00, 0x79, 0x02, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xA9, 0x02, // Ã© (U+00C3 U+00A9)
  0x00, 0xC3, 0x00, 0xAE, 0x02, // Ã® (U+00C3 U+00AE)
  0x00, 0xC3, 0x00, 0xC7, 0x01, // ÃÇ (U+00C3 U+00C7)
  0x00, 0xC3, 0x00, 0xD2, 0x01, // ÃÒ (U+00C3 U+00D2)
  0x00, 0xC3, 0x00, 0xD3, 0x01, // ÃÓ (U+00C3 U+00D3)
  0x00, 0xC3, 0x00, 0xD4, 0x01, // ÃÔ (U+00C3 U+00D4)
  0x00, 0xC3, 0x00, 0xD5, 0x01, // ÃÕ (U+00C3 U+00D5)
  0x00, 0xC3, 0x00, 0xD6, 0x01, // ÃÖ (U+00C3 U+00D6)
  0x00, 0xC3, 0x00, 0xD8, 0x01, // ÃØ (U+00C3 U+00D8)
  0x00, 0xC3, 0x00, 0xD9, 0x01, // ÃÙ (U+00C3 U+00D9)
  0x00, 0xC3, 0x00, 0xDA, 0x01, // ÃÚ (U+00C3 U+00DA)
  0x00, 0xC3, 0x00, 0xDB, 0x01, // ÃÛ (U+00C3 U+00DB)
  0x00, 0xC3, 0x00, 0xDC, 0x01, // ÃÜ (U+00C3 U+00DC)
  0x00, 0xC3, 0x00, 0xDD, 0x03, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xE7, 0x01, // Ãç (U+00C3 U+00E7)
  0x00, 0xC3, 0x00, 0xE8, 0x01, // Ãè (U+00C3 U+00E8)
  0x00, 0xC3, 0x00, 0xE9, 0x01, // Ãé (U+00C3 U+00E9)
  0x00, 0xC3, 0x00, 0xEA, 0x01, // Ãê (U+00C3 U+00EA)
  0x00, 0xC3, 0x00, 0xEB, 0x01, // Ãë (U+00C3 U+00EB)
  0x00, 0xC3, 0x00, 0xF0, 0x01, // Ãð (U+00C3 U+00F0)
  0x00, 0xC3, 0x00, 0xF2, 0x01, // Ãò (U+00C3 U+00F2)
  0x00, 0xC3, 0x00, 0xF3, 0x01, // Ãó (U+00C3 U+00F3)
  0x00, 0xC3, 0x00, 0xF4, 0x01, // Ãô (U+00C3 U+00F4)
  0x00, 0xC3, 0x00, 0xF5, 0x01, // Ãõ (U+00C3 U+00F5)
  0x00, 0xC3, 0x00, 0xF6, 0x01, // Ãö (U+00C3 U+00F6)
  0x00, 0xC3, 0x00, 0xF8, 0x01, // Ãø (U+00C3 U+00F8)
  0x00, 0xC3, 0x00, 0xF9, 0x01, // Ãù (U+00C3 U+00F9)
  0x00, 0xC3, 0x00, 0xFA, 0x01, // Ãú (U+00C3 U+00FA)
  0x00, 0xC3, 0x00, 0xFB, 0x01, // Ãû (U+00C3 U+00FB)
  0x00, 0xC3, 0x00, 0xFC, 0x01, // Ãü (U+00C3 U+00FC)
  0x00, 0xC3, 0x00, 0xFD, 0x02, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x02, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x06, 0x01, // ÃĆ (U+00C3 U+0106)
  0x00, 0xC3, 0x01, 0x07, 0x01, // Ãć (U+00C3 U+0107)
  0x00, 0xC3, 0x01, 0x08, 0x01, // ÃĈ (U+00C3 U+0108)
  0x00, 0xC3, 0x01, 0x09, 0x01, // Ãĉ (U+00C3 U+0109)
  0x00, 0xC3, 0x01, 0x0A, 0x01, // ÃĊ (U+00C3 U+010A)
  0x00, 0xC3, 0x01, 0x0B, 0x01, // Ãċ (U+00C3 U+010B)
  0x00, 0xC3, 0x01, 0x0C, 0x01, // ÃČ (U+00C3 U+010C)
  0x00, 0xC3, 0x01, 0x0D, 0x01, // Ãč (U+00C3 U+010D)
  0x00, 0xC3, 0x01, 0x0F, 0x01, // Ãď (U+00C3 U+010F)
  0x00, 0xC3, 0x01, 0x11, 0x01, // Ãđ (U+00C3 U+0111)
  0x00, 0xC3, 0x01, 0x13, 0x01, // Ãē (U+00C3 U+0113)
  0x00, 0xC3, 0x01, 0x15, 0x01, // Ãĕ (U+00C3 U+0115)
  0x00, 0xC3, 0x01, 0x17, 0x01, // Ãė (U+00C3 U+0117)
  0x00, 0xC3, 0x01, 0x19, 0x01, // Ãę (U+00C3 U+0119)
  0x00, 0xC3, 0x01, 0x1B, 0x01, // Ãě (U+00C3 U+011B)
  0x00, 0xC3, 0x01, 0x1C, 0x01, // ÃĜ (U+00C3 U+011C)
  0x00, 0xC3, 0x01, 0x1D, 0x01, // Ãĝ (U+00C3 U+011D)
  0x00, 0xC3, 0x01, 0x1E, 0x01, // ÃĞ (U+00C3 U+011E)
  0x00, 0xC3, 0x01, 0x1F, 0x01, // Ãğ (U+00C3 U+011F)
  0x00, 0xC3, 0x01, 0x20, 0x01, // ÃĠ (U+00C3 U+0120)
  0x00, 0xC3, 0x01, 0x21, 0x01, // Ãġ (U+00C3 U+0121)
  0x00, 0xC3, 0x01, 0x22, 0x01, // ÃĢ (U+00C3 U+0122)
  0x00, 0xC3, 0x01, 0x23, 0x01, // Ãģ (U+00C3 U+0123)
  0x00, 0xC3, 0x01, 0x49, 0x02, // Ãŉ (U+00C3 U+0149)
  0x00, 0xC3, 0x01, 0x4C, 0x01, // ÃŌ (U+00C3 U+014C)
  0x00, 0xC3, 0x01, 0x4D, 0x01, // Ãō (U+00C3 U+014D)
  0x00, 0xC3, 0x01, 0x4E, 0x01, // ÃŎ (U+00C3 U+014E)
  0x00, 0xC3, 0x01, 0x4F, 0x01, // Ãŏ (U+00C3 U+014F)
  0x00, 0xC3, 0x01, 0x50, 0x01, // ÃŐ (U+00C3 U+0150)
  0x00, 0xC3, 0x01, 0x51, 0x01, // Ãő (U+00C3 U+0151)
  0x00, 0xC3, 0x01, 0x52, 0x01, // ÃŒ (U+00C3 U+0152)
  0x00, 0xC3, 0x01, 0x53, 0x01, // Ãœ (U+00C3 U+0153)
  0x00, 0xC3, 0x01, 0x68, 0x01, // ÃŨ (U+00C3 U+0168)
  0x00, 0xC3, 0x01, 0x69, 0x01, // Ãũ (U+00C3 U+0169)
  0x00, 0xC3, 0x01, 0x6A, 0x01, // ÃŪ (U+00C3 U+016A)
  0x00, 0xC3, 0x01, 0x6B, 0x01, // Ãū (U+00C3 U+016B)
  0x00, 0xC3, 0x01, 0x6C, 0x01, // ÃŬ (U+00C3 U+016C)
  0x00, 0xC3, 0x01, 0x6D, 0x01, // Ãŭ (U+00C3 U+016D)
  0x00, 0xC3, 0x01, 0x6E, 0x01, // ÃŮ (U+00C3 U+016E)
  0x00, 0xC3, 0x01, 0x6F, 0x01, // Ãů (U+00C3 U+016F)
  0x00, 0xC3, 0x01, 0x70, 0x01, // ÃŰ (U+00C3 U+0170)
  0x00, 0xC3, 0x01, 0x71, 0x01, // Ãű (U+00C3 U+0171)
  0x00, 0xC3, 0x01, 0x72, 0x01, // ÃŲ (U+00C3 U+0172)
  0x00, 0xC3, 0x01, 0x73, 0x01, // Ãų (U+00C3 U+0173)
  0x00, 0xC3, 0x01, 0x74, 0x03, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x75, 0x01, // Ãŵ (U+00C3 U+0175)
  0x00, 0xC3, 0x01, 0x76, 0x03, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x02, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x03, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x04, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x03, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x04, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x03, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x03, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x03, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x26, 0x01, // Ä& (U+00C4 U+0026)
  0x00, 0xC4, 0x00, 0x27, 0x03, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x03, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x43, 0x01, // ÄC (U+00C4 U+0043)
  0x00, 0xC4, 0x00, 0x47, 0x01, // ÄG (U+00C4 U+0047)
  0x00, 0xC4, 0x00, 0x4F, 0x01, // ÄO (U+00C4 U+004F)
  0x00, 0xC4, 0x00, 0x51, 0x01, // ÄQ (U+00C4 U+0051)
  0x00, 0xC4, 0x00, 0x54, 0x02, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x55, 0x01, // ÄU (U+00C4 U+0055)
  0x00, 0xC4, 0x00, 0x56, 0x03, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x03, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x03, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x63, 0x01, // Äc (U+00C4 U+0063)
  0x00, 0xC4, 0x00, 0x64, 0x01, // Äd (U+00C4 U+0064)
  0x00, 0xC4, 0x00, 0x65, 0x01, // Äe (U+00C4 U+0065)
  0x00, 0xC4, 0x00, 0x67, 0x01, // Äg (U+00C4 U+0067)
  0x00, 0xC4, 0x00, 0x6F, 0x01, // Äo (U+00C4 U+006F)
  0x00, 0xC4, 0x00, 0x71, 0x01, // Äq (U+00C4 U+0071)
  0x00, 0xC4, 0x00, 0x75, 0x01, // Äu (U+00C4 U+0075)
  0x00, 0xC4, 0x00, 0x76, 0x02, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x77, 0x01, // Äw (U+00C4 U+0077)
  0x00, 0xC4, 0x00, 0x79, 0x02, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xA9, 0x02, // Ä© (U+00C4 U+00A9)
  0x00, 0xC4, 0x00, 0xAE, 0x02, // Ä® (U+00C4 U+00AE)
  0x00, 0xC4, 0x00, 0xC7, 0x01, // ÄÇ (U+00C4 U+00C7)
  0x00, 0xC4, 0x00, 0xD2, 0x01, // ÄÒ (U+00C4 U+00D2)
  0x00, 0xC4, 0x00, 0xD3, 0x01, // ÄÓ (U+00C4 U+00D3)
  0x00, 0xC4, 0x00, 0xD4, 0x01, // ÄÔ (U+00C4 U+00D4)
  0x00, 0xC4, 0x00, 0xD5, 0x01, // ÄÕ (U+00C4 U+00D5)
  0x00, 0xC4, 0x00, 0xD6, 0x01, // ÄÖ (U+00C4 U+00D6)
  0x00, 0xC4, 0x00, 0xD8, 0x01, // ÄØ (U+00C4 U+00D8)
  0x00, 0xC4, 0x00, 0xD9, 0x01, // ÄÙ (U+00C4 U+00D9)
  0x00, 0xC4, 0x00, 0xDA, 0x01, // ÄÚ (U+00C4 U+00DA)
  0x00, 0xC4, 0x00, 0xDB, 0x01, // ÄÛ (U+00C4 U+00DB)
  0x00, 0xC4, 0x00, 0xDC, 0x01, // ÄÜ (U+00C4 U+00DC)
  0x00, 0xC4, 0x00, 0xDD, 0x03, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xE7, 0x01, // Äç (U+00C4 U+00E7)
  0x00, 0xC4, 0x00, 0xE8, 0x01, // Äè (U+00C4 U+00E8)
  0x00, 0xC4, 0x00, 0xE9, 0x01, // Äé (U+00C4 U+00E9)
  0x00, 0xC4, 0x00, 0xEA, 0x01, // Äê (U+00C4 U+00EA)
  0x00, 0xC4, 0x00, 0xEB, 0x01, // Äë (U+00C4 U+00EB)
  0x00, 0xC4, 0x00, 0xF0, 0x01, // Äð (U+00C4 U+00F0)
  0x00, 0xC4, 0x00, 0xF2, 0x01, // Äò (U+00C4 U+00F2)
  0x00, 0xC4, 0x00, 0xF3, 0x01, // Äó (U+00C4 U+00F3)
  0x00, 0xC4, 0x00, 0xF4, 0x01, // Äô (U+00C4 U+00F4)
  0x00, 0xC4, 0x00, 0xF5, 0x01, // Äõ (U+00C4 U+00F5)
  0x00, 0xC4, 0x00, 0xF6, 0x01, // Äö (U+00C4 U+00F6)
  0x00, 0xC4, 0x00, 0xF8, 0x01, // Äø (U+00C4 U+00F8)
  0x00, 0xC4, 0x00, 0xF9, 0x01, // Äù (U+00C4 U+00F9)
  0x00, 0xC4, 0x00, 0xFA, 0x01, // Äú (U+00C4 U+00FA)
  0x00, 0xC4, 0x00, 0xFB, 0x01, // Äû (U+00C4 U+00FB)
  0x00, 0xC4, 0x00, 0xFC, 0x01, // Äü (U+00C4 U+00FC)
  0x00, 0xC4, 0x00, 0xFD, 0x02, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x02, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x06, 0x01, // ÄĆ (U+00C4 U+0106)
  0x00, 0xC4, 0x01, 0x07, 0x01, // Äć (U+00C4 U+0107)
  0x00, 0xC4, 0x01, 0x08, 0x01, // ÄĈ (U+00C4 U+0108)
  0x00, 0xC4, 0x01, 0x09, 0x01, // Äĉ (U+00C4 U+0109)
  0x00, 0xC4, 0x01, 0x0A, 0x01, // ÄĊ (U+00C4 U+010A)
  0x00, 0xC4, 0x01, 0x0B, 0x01, // Äċ (U+00C4 U+010B)
  0x00, 0xC4, 0x01, 0x0C, 0x01, // ÄČ (U+00C4 U+010C)
  0x00, 0xC4, 0x01, 0x0D, 0x01, // Äč (U+00C4 U+010D)
  0x00, 0xC4, 0x01, 0x0F, 0x01, // Äď (U+00C4 U+010F)
  0x00, 0xC4, 0x01, 0x11, 0x01, // Äđ (U+00C4 U+0111)
  0x00, 0xC4, 0x01, 0x13, 0x01, // Äē (U+00C4 U+0113)
  0x00, 0xC4, 0x01, 0x15, 0x01, // Äĕ (U+00C4 U+0115)
  0x00, 0xC4, 0x01, 0x17, 0x01, // Äė (U+00C4 U+0117)
  0x00, 0xC4, 0x01, 0x19, 0x01, // Äę (U+00C4 U+0119)
  0x00, 0xC4, 0x01, 0x1B, 0x01, // Äě (U+00C4 U+011B)
  0x00, 0xC4, 0x01, 0x1C, 0x01, // ÄĜ (U+00C4 U+011C)
  0x00, 0xC4, 0x01, 0x1D, 0x01, // Äĝ (U+00C4 U+011D)
  0x00, 0xC4, 0x01, 0x1E, 0x01, // ÄĞ (U+00C4 U+011E)
  0x00, 0xC4, 0x01, 0x1F, 0x01, // Äğ (U+00C4 U+011F)
  0x00, 0xC4, 0x01, 0x20, 0x01, // ÄĠ (U+00C4 U+0120)
  0x00, 0xC4, 0x01, 0x21, 0x01, // Äġ (U+00C4 U+0121)
  0x00, 0xC4, 0x01, 0x22, 0x01, // ÄĢ (U+00C4 U+0122)
  0x00, 0xC4, 0x01, 0x23, 0x01, // Äģ (U+00C4 U+0123)
  0x00, 0xC4, 0x01, 0x49, 0x02, // Äŉ (U+00C4 U+0149)
  0x00, 0xC4, 0x01, 0x4C, 0x01, // ÄŌ (U+00C4 U+014C)
  0x00, 0xC4, 0x01, 0x4D, 0x01, // Äō (U+00C4 U+014D)
  0x00, 0xC4, 0x01, 0x4E, 0x01, // ÄŎ (U+00C4 U+014E)
  0x00, 0xC4, 0x01, 0x4F, 0x01, // Äŏ (U+00C4 U+014F)
  0x00, 0xC4, 0x01, 0x50, 0x01, // ÄŐ (U+00C4 U+0150)
  0x00, 0xC4, 0x01, 0x51, 0x01, // Äő (U+00C4 U+0151)
  0x00, 0xC4, 0x01, 0x52, 0x01, // ÄŒ (U+00C4 U+0152)
  0x00, 0xC4, 0x01, 0x53, 0x01, // Äœ (U+00C4 U+0153)
  0x00, 0xC4, 0x01, 0x68, 0x01, // ÄŨ (U+00C4 U+0168)
  0x00, 0xC4, 0x01, 0x69, 0x01, // Äũ (U+00C4 U+0169)
  0x00, 0xC4, 0x01, 0x6A, 0x01, // ÄŪ (U+00C4 U+016A)
  0x00, 0xC4, 0x01, 0x6B, 0x01, // Äū (U+00C4 U+016B)
  0x00, 0xC4, 0x01, 0x6C, 0x01, // ÄŬ (U+00C4 U+016C)
  0x00, 0xC4, 0x01, 0x6D, 0x01, // Äŭ (U+00C4 U+016D)
  0x00, 0xC4, 0x01, 0x6E, 0x01, // ÄŮ (U+00C4 U+016E)
  0x00, 0xC4, 0x01, 0x6F, 0x01, // Äů (U+00C4 U+016F)
  0x00, 0xC4, 0x01, 0x70, 0x01, // ÄŰ (U+00C4 U+0170)
  0x00, 0xC4, 0x01, 0x71, 0x01, // Äű (U+00C4 U+0171)
  0x00, 0xC4, 0x01, 0x72, 0x01, // ÄŲ (U+00C4 U+0172)
  0x00, 0xC4, 0x01, 0x73, 0x01, // Äų (U+00C4 U+0173)
  0x00, 0xC4, 0x01, 0x74, 0x03, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x75, 0x01, // Äŵ (U+00C4 U+0175)
  0x00, 0xC4, 0x01, 0x76, 0x03, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x02, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x03, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x04, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x03, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x04, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x03, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x03, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x03, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x26, 0x01, // Å& (U+00C5 U+0026)
  0x00, 0xC5, 0x00, 0x27, 0x03, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x03, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x43, 0x01, // ÅC (U+00C5 U+0043)
  0x00, 0xC5, 0x00, 0x47, 0x01, // ÅG (U+00C5 U+0047)
  0x00, 0xC5, 0x00, 0x4F, 0x01, // ÅO (U+00C5 U+004F)
  0x00, 0xC5, 0x00, 0x51, 0x01, // ÅQ (U+00C5 U+0051)
  0x00, 0xC5, 0x00, 0x54, 0x02, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x55, 0x01, // ÅU (U+00C5 U+0055)
  0x00, 0xC5, 0x00, 0x56, 0x03, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x03, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x03, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x63, 0x01, // Åc (U+00C5 U+0063)
  0x00, 0xC5, 0x00, 0x64, 0x01, // Åd (U+00C5 U+0064)
  0x00, 0xC5, 0x00, 0x65, 0x01, // Åe (U+00C5 U+0065)
  0x00, 0xC5, 0x00, 0x67, 0x01, // Åg (U+00C5 U+0067)
  0x00, 0xC5, 0x00, 0x6F, 0x01, // Åo (U+00C5 U+006F)
  0x00, 0xC5, 0x00, 0x71, 0x01, // Åq (U+00C5 U+0071)
  0x00, 0xC5, 0x00, 0x75, 0x01, // Åu (U+00C5 U+0075)
  0x00, 0xC5, 0x00, 0x76, 0x02, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x77, 0x01, // Åw (U+00C5 U+0077)
  0x00, 0xC5, 0x00, 0x79, 0x02, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xA9, 0x02, // Å© (U+00C5 U+00A9)
  0x00, 0xC5, 0x00, 0xAE, 0x02, // Å® (U+00C5 U+00AE)
  0x00, 0xC5, 0x00, 0xC7, 0x01, // ÅÇ (U+00C5 U+00C7)
  0x00, 0xC5, 0x00, 0xD2, 0x01, // ÅÒ (U+00C5 U+00D2)
  0x00, 0xC5, 0x00, 0xD3, 0x01, // ÅÓ (U+00C5 U+00D3)
  0x00, 0xC5, 0x00, 0xD4, 0x01, // ÅÔ (U+00C5 U+00D4)
  0x00, 0xC5, 0x00, 0xD5, 0x01, // ÅÕ (U+00C5 U+00D5)
  0x00, 0xC5, 0x00, 0xD6, 0x01, // ÅÖ (U+00C5 U+00D6)
  0x00, 0xC5, 0x00, 0xD8, 0x01, // ÅØ (U+00C5 U+00D8)
  0x00, 0xC5, 0x00, 0xD9, 0x01, // ÅÙ (U+00C5 U+00D9)
  0x00, 0xC5, 0x00, 0xDA, 0x01, // ÅÚ (U+00C5 U+00DA)
  0x00, 0xC5, 0x00, 0xDB, 0x01, // ÅÛ (U+00C5 U+00DB)
  0x00, 0xC5, 0x00, 0xDC, 0x01, // ÅÜ (U+00C5 U+00DC)
  0x00, 0xC5, 0x00, 0xDD, 0x03, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xE7, 0x01, // Åç (U+00C5 U+00E7)
  0x00, 0xC5, 0x00, 0xE8, 0x01, // Åè (U+00C5 U+00E8)
  0x00, 0xC5, 0x00, 0xE9, 0x01, // Åé (U+00C5 U+00E9)
  0x00, 0xC5, 0x00, 0xEA, 0x01, // Åê (U+00C5 U+00EA)
  0x00, 0xC5, 0x00, 0xEB, 0x01, // Åë (U+00C5 U+00EB)
  0x00, 0xC5, 0x00, 0xF0, 0x01, // Åð (U+00C5 U+00F0)
  0x00, 0xC5, 0x00, 0xF2, 0x01, // Åò (U+00C5 U+00F2)
  0x00, 0xC5, 0x00, 0xF3, 0x01, // Åó (U+00C5 U+00F3)
  0x00, 0xC5, 0x00, 0xF4, 0x01, // Åô (U+00C5 U+00F4)
  0x00, 0xC5, 0x00, 0xF5, 0x01, // Åõ (U+00C5 U+00F5)
  0x00, 0xC5, 0x00, 0xF6, 0x01, // Åö (U+00C5 U+00F6)
  0x00, 0xC5, 0x00, 0xF8, 0x01, // Åø (U+00C5 U+00F8)
  0x00, 0xC5, 0x00, 0xF9, 0x01, // Åù (U+00C5 U+00F9)
  0x00, 0xC5, 0x00, 0xFA, 0x01, // Åú (U+00C5 U+00FA)
  0x00, 0xC5, 0x00, 0xFB, 0x01, // Åû (U+00C5 U+00FB)
  0x00, 0xC5, 0x00, 0xFC, 0x01, // Åü (U+00C5 U+00FC)
  0x00, 0xC5, 0x00, 0xFD, 0x02, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x02, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x06, 0x01, // ÅĆ (U+00C5 U+0106)
  0x00, 0xC5, 0x01, 0x07, 0x01, // Åć (U+00C5 U+0107)
  0x00, 0xC5, 0x01, 0x08, 0x01, // ÅĈ (U+00C5 U+0108)
  0x00, 0xC5, 0x01, 0x09, 0x01, // Åĉ (U+00C5 U+0109)
  0x00, 0xC5, 0x01, 0x0A, 0x01, // ÅĊ (U+00C5 U+010A)
  0x00, 0xC5, 0x01, 0x0B, 0x01, // Åċ (U+00C5 U+010B)
  0x00, 0xC5, 0x01, 0x0C, 0x01, // ÅČ (U+00C5 U+010C)
  0x00, 0xC5, 0x01, 0x0D, 0x01, // Åč (U+00C5 U+010D)
  0x00, 0xC5, 0x01, 0x0F, 0x01, // Åď (U+00C5 U+010F)
  0x00, 0xC5, 0x01, 0x11, 0x01, // Åđ (U+00C5 U+0111)
  0x00, 0xC5, 0x01, 0x13, 0x01, // Åē (U+00C5 U+0113)
  0x00, 0xC5, 0x01, 0x15, 0x01, // Åĕ (U+00C5 U+0115)
  0x00, 0xC5, 0x01, 0x17, 0x01, // Åė (U+00C5 U+0117)
  0x00, 0xC5, 0x01, 0x19, 0x01, // Åę (U+00C5 U+0119)
  0x00, 0xC5, 0x01, 0x1B, 0x01, // Åě (U+00C5 U+011B)
  0x00, 0xC5, 0x01, 0x1C, 0x01, // ÅĜ (U+00C5 U+011C)
  0x00, 0xC5, 0x01, 0x1D, 0x01, // Åĝ (U+00C5 U+011D)
  0x00, 0xC5, 0x01, 0x1E, 0x01, // ÅĞ (U+00C5 U+011E)
  0x00, 0xC5, 0x01, 0x1F, 0x01, // Åğ (U+00C5 U+011F)
  0x00, 0xC5, 0x01, 0x20, 0x01, // ÅĠ (U+00C5 U+0120)
  0x00, 0xC5, 0x01, 0x21, 0x01, // Åġ (U+00C5 U+0121)
  0x00, 0xC5, 0x01, 0x22, 0x01, // ÅĢ (U+00C5 U+0122)
  0x00, 0xC5, 0x01, 0x23, 0x01, // Åģ (U+00C5 U+0123)
  0x00, 0xC5, 0x01, 0x49, 0x02, // Åŉ (U+00C5 U+0149)
  0x00, 0xC5, 0x01, 0x4C, 0x01, // ÅŌ (U+00C5 U+014C)
  0x00, 0xC5, 0x01, 0x4D, 0x01, // Åō (U+00C5 U+014D)
  0x00, 0xC5, 0x01, 0x4E, 0x01, // ÅŎ (U+00C5 U+014E)
  0x00, 0xC5, 0x01, 0x4F, 0x01, // Åŏ (U+00C5 U+014F)
  0x00, 0xC5, 0x01, 0x50, 0x01, // ÅŐ (U+00C5 U+0150)
  0x00, 0xC5, 0x01, 0x51, 0x01, // Åő (U+00C5 U+0151)
  0x00, 0xC5, 0x01, 0x52, 0x01, // ÅŒ (U+00C5 U+0152)
  0x00, 0xC5, 0x01, 0x53, 0x01, // Åœ (U+00C5 U+0153)
  0x00, 0xC5, 0x01, 0x68, 0x01, // ÅŨ (U+00C5 U+0168)
  0x00, 0xC5, 0x01, 0x69, 0x01, // Åũ (U+00C5 U+0169)
  0x00, 0xC5, 0x01, 0x6A, 0x01, // ÅŪ (U+00C5 U+016A)
  0x00, 0xC5, 0x01, 0x6B, 0x01, // Åū (U+00C5 U+016B)
  0x00, 0xC5, 0x01, 0x6C, 0x01, // ÅŬ (U+00C5 U+016C)
  0x00, 0xC5, 0x01, 0x6D, 0x01, // Åŭ (U+00C5 U+016D)
  0x00, 0xC5, 0x01, 0x6E, 0x01, // ÅŮ (U+00C5 U+016E)
  0x00, 0xC5, 0x01, 0x6F, 0x01, // Åů (U+00C5 U+016F)
  0x00, 0xC5, 0x01, 0x70, 0x01, // ÅŰ (U+00C5 U+0170)
  0x00, 0xC5, 0x01, 0x71, 0x01, // Åű (U+00C5 U+0171)
  0x00, 0xC5, 0x01, 0x72, 0x01, // ÅŲ (U+00C5 U+0172)
  0x00, 0xC5, 0x01, 0x73, 0x01, // Åų (U+00C5 U+0173)
  0x00, 0xC5, 0x01, 0x74, 0x03, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x75, 0x01, // Åŵ (U+00C5 U+0175)
  0x00, 0xC5, 0x01, 0x76, 0x03, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x02, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x03, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x04, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x03, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x04, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x03, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x03, // Å™ (U+00C5 U+2122)
  0x00, 0xC6, 0x00, 0x56, 0x01, // ÆV (U+00C6 U+0056)
  0x00, 0xC6, 0x00, 0x57, 0x01, // ÆW (U+00C6 U+0057)
  0x00, 0xC6, 0x00, 0x59, 0x01, // ÆY (U+00C6 U+0059)
  0x00, 0xC6, 0x00, 0xDD, 0x01, // ÆÝ (U+00C6 U+00DD)
  0x00, 0xC6, 0x01, 0x74, 0x01, // ÆŴ (U+00C6 U+0174)
  0x00, 0xC6, 0x01, 0x76, 0x01, // ÆŶ (U+00C6 U+0176)
  0x00, 0xC6, 0x01, 0x78, 0x01, // ÆŸ (U+00C6 U+0178)
  0x00, 0xC7, 0x00, 0x26, 0x01, // Ç& (U+00C7 U+0026)
  0x00, 0xC8, 0x00, 0x56, 0x01, // ÈV (U+00C8 U+0056)
  0x00, 0xC8, 0x00, 0x57, 0x01, // ÈW (U+00C8 U+0057)
  0x00, 0xC8, 0x00, 0x59, 0x01, // ÈY (U+00C8 U+0059)
  0x00, 0xC8, 0x00, 0xDD, 0x01, // ÈÝ (U+00C8 U+00DD)
  0x00, 0xC8, 0x01, 0x74, 0x01, // ÈŴ (U+00C8 U+0174)
  0x00, 0xC8, 0x01, 0x76, 0x01, // ÈŶ (U+00C8 U+0176)
  0x00, 0xC8, 0x01, 0x78, 0x01, // ÈŸ (U+00C8 U+0178)
  0x00, 0xC9, 0x00, 0x56, 0x01, // ÉV (U+00C9 U+0056)
  0x00, 0xC9, 0x00, 0x57, 0x01, // ÉW (U+00C9 U+0057)
  0x00, 0xC9, 0x00, 0x59, 0x01, // ÉY (U+00C9 U+0059)
  0x00, 0xC9, 0x00, 0xDD, 0x01, // ÉÝ (U+00C9 U+00DD)
  0x00, 0xC9, 0x01, 0x74, 0x01, // ÉŴ (U+00C9 U+0174)
  0x00, 0xC9, 0x01, 0x76, 0x01, // ÉŶ (U+00C9 U+0176)
  0x00, 0xC9, 0x01, 0x78, 0x01, // ÉŸ (U+00C9 U+0178)
  0x00, 0xCA, 0x00, 0x56, 0x01, // ÊV (U+00CA U+0056)
  0x00, 0xCA, 0x00, 0x57, 0x01, // ÊW (U+00CA U+0057)
  0x00, 0xCA, 0x00, 0x59, 0x01, // ÊY (U+00CA U+0059)
  0x00, 0xCA, 0x00, 0xDD, 0x01, // ÊÝ (U+00CA U+00DD)
  0x00, 0xCA, 0x01, 0x74, 0x01, // ÊŴ (U+00CA U+0174)
  0x00, 0xCA, 0x01, 0x76, 0x01, // ÊŶ (U+00CA U+0176)
  0x00, 0xCA, 0x01, 0x78, 0x01, // ÊŸ (U+00CA U+0178)
  0x00, 0xCB, 0x00, 0x56, 0x01, // ËV (U+00CB U+0056)
  0x00, 0xCB, 0x00, 0x57, 0x01, // ËW (U+00CB U+0057)
  0x00, 0xCB, 0x00, 0x59, 0x01, // ËY (U+00CB U+0059)
  0x00, 0xCB, 0x00, 0xDD, 0x01, // ËÝ (U+00CB U+00DD)
  0x00, 0xCB, 0x01, 0x74, 0x01, // ËŴ (U+00CB U+0174)
  0x00, 0xCB, 0x01, 0x76, 0x01, // ËŶ (U+00CB U+0176)
  0x00, 0xCB, 0x01, 0x78, 0x01, // ËŸ (U+00CB U+0178)
  0x00, 0xD0, 0x00, 0x22, 0x01, // Ð" (U+00D0 U+0022)
  0x00, 0xD0, 0x00, 0x27, 0x01, // Ð' (U+00D0 U+0027)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x41, 0x01, // ÐA (U+00D0 U+0041)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x00, 0x56, 0x01, // ÐV (U+00D0 U+0056)
  0x00, 0xD0, 0x00, 0x57, 0x01, // ÐW (U+00D0 U+0057)
  0x00, 0xD0, 0x00, 0x58, 0x01, // ÐX (U+00D0 U+0058)
  0x00, 0xD0, 0x00, 0x59, 0x01, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0xC0, 0x01, // ÐÀ (U+00D0 U+00C0)
  0x00, 0xD0, 0x00, 0xC1, 0x01, // ÐÁ (U+00D0 U+00C1)
  0x00, 0xD0, 0x00, 0xC2, 0x01, // ÐÂ (U+00D0 U+00C2)
  0x00, 0xD0, 0x00, 0xC3, 0x01, // ÐÃ (U+00D0 U+00C3)
  0x00, 0xD0, 0x00, 0xC4, 0x01, // ÐÄ (U+00D0 U+00C4)
  0x00, 0xD0, 0x00, 0xC5, 0x01, // ÐÅ (U+00D0 U+00C5)
  0x00, 0xD0, 0x00, 0xC6, 0x02, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD0, 0x00, 0xDD, 0x01, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x00, 0x01, // ÐĀ (U+00D0 U+0100)
  0x00, 0xD0, 0x01, 0x02, 0x01, // ÐĂ (U+00D0 U+0102)
  0x00, 0xD0, 0x01, 0x04, 0x01, // ÐĄ (U+00D0 U+0104)
  0x00, 0xD0, 0x01, 0x74, 0x01, // ÐŴ (U+00D0 U+0174)
  0x00, 0xD0, 0x01, 0x76, 0x01, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x01, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD1, 0x00, 0x26, 0x01, // Ñ& (U+00D1 U+0026)
  0x00, 0xD1, 0x00, 0x2C, 0x01, // Ñ, (U+00D1 U+002C)
  0x00, 0xD1, 0x00, 0x2E, 0x01, // Ñ. (U+00D1 U+002E)
  0x00, 0xD1, 0x20, 0x1A, 0x01, // Ñ‚ (U+00D1 U+201A)
  0x00, 0xD1, 0x20, 0x1E, 0x01, // Ñ„ (U+00D1 U+201E)
  0x00, 0xD1, 0x20, 0x26, 0x01, // Ñ… (U+00D1 U+2026)
  0x00, 0xD2, 0x00, 0x22, 0x01, // Ò" (U+00D2 U+0022)
  0x00, 0xD2, 0x00, 0x27, 0x01, // Ò' (U+00D2 U+0027)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x41, 0x01, // ÒA (U+00D2 U+0041)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x00, 0x56, 0x01, // ÒV (U+00D2 U+0056)
  0x00, 0xD2, 0x00, 0x57, 0x01, // ÒW (U+00D2 U+0057)
  0x00, 0xD2, 0x00, 0x58, 0x01, // ÒX (U+00D2 U+0058)
  0x00, 0xD2, 0x00, 0x59, 0x01, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0xC0, 0x01, // ÒÀ (U+00D2 U+00C0)
  0x00, 0xD2, 0x00, 0xC1, 0x01, // ÒÁ (U+00D2 U+00C1)
  0x00, 0xD2, 0x00, 0xC2, 0x01, // ÒÂ (U+00D2 U+00C2)
  0x00, 0xD2, 0x00, 0xC3, 0x01, // ÒÃ (U+00D2 U+00C3)
  0x00, 0xD2, 0x00, 0xC4, 0x01, // ÒÄ (U+00D2 U+00C4)
  0x00, 0xD2, 0x00, 0xC5, 0x01, // ÒÅ (U+00D2 U+00C5)
  0x00, 0xD2, 0x00, 0xC6, 0x02, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD2, 0x00, 0xDD, 0x01, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x00, 0x01, // ÒĀ (U+00D2 U+0100)
  0x00, 0xD2, 0x01, 0x02, 0x01, // ÒĂ (U+00D2 U+0102)
  0x00, 0xD2, 0x01, 0x04, 0x01, // ÒĄ (U+00D2 U+0104)
  0x00, 0xD2, 0x01, 0x74, 0x01, // ÒŴ (U+00D2 U+0174)
  0x00, 0xD2, 0x01, 0x76, 0x01, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x01, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x22, 0x01, // Ó" (U+00D3 U+0022)
  0x00, 0xD3, 0x00, 0x27, 0x01, // Ó' (U+00D3 U+0027)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x41, 0x01, // ÓA (U+00D3 U+0041)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x00, 0x56, 0x01, // ÓV (U+00D3 U+0056)
  0x00, 0xD3, 0x00, 0x57, 0x01, // ÓW (U+00D3 U+0057)
  0x00, 0xD3, 0x00, 0x58, 0x01, // ÓX (U+00D3 U+0058)
  0x00, 0xD3, 0x00, 0x59, 0x01, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0xC0, 0x01, // ÓÀ (U+00D3 U+00C0)
  0x00, 0xD3, 0x00, 0xC1, 0x01, // ÓÁ (U+00D3 U+00C1)
  0x00, 0xD3, 0x00, 0xC2, 0x01, // ÓÂ (U+00D3 U+00C2)
  0x00, 0xD3, 0x00, 0xC3, 0x01, // ÓÃ (U+00D3 U+00C3)
  0x00, 0xD3, 0x00, 0xC4, 0x01, // ÓÄ (U+00D3 U+00C4)
  0x00, 0xD3, 0x00, 0xC5, 0x01, // ÓÅ (U+00D3 U+00C5)
  0x00, 0xD3, 0x00, 0xC6, 0x02, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD3, 0x00, 0xDD, 0x01, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x00, 0x01, // ÓĀ (U+00D3 U+0100)
  0x00, 0xD3, 0x01, 0x02, 0x01, // ÓĂ (U+00D3 U+0102)
  0x00, 0xD3, 0x01, 0x04, 0x01, // ÓĄ (U+00D3 U+0104)
  0x00, 0xD3, 0x01, 0x74, 0x01, // ÓŴ (U+00D3 U+0174)
  0x00, 0xD3, 0x01, 0x76, 0x01, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x01, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x22, 0x01, // Ô" (U+00D4 U+0022)
  0x00, 0xD4, 0x00, 0x27, 0x01, // Ô' (U+00D4 U+0027)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x41, 0x01, // ÔA (U+00D4 U+0041)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x00, 0x56, 0x01, // ÔV (U+00D4 U+0056)
  0x00, 0xD4, 0x00, 0x57, 0x01, // ÔW (U+00D4 U+0057)
  0x00, 0xD4, 0x00, 0x58, 0x01, // ÔX (U+00D4 U+0058)
  0x00, 0xD4, 0x00, 0x59, 0x01, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0xC0, 0x01, // ÔÀ (U+00D4 U+00C0)
  0x00, 0xD4, 0x00, 0xC1, 0x01, // ÔÁ (U+00D4 U+00C1)
  0x00, 0xD4, 0x00, 0xC2, 0x01, // ÔÂ (U+00D4 U+00C2)
  0x00, 0xD4, 0x00, 0xC3, 0x01, // ÔÃ (U+00D4 U+00C3)
  0x00, 0xD4, 0x00, 0xC4, 0x01, // ÔÄ (U+00D4 U+00C4)
  0x00, 0xD4, 0x00, 0xC5, 0x01, // ÔÅ (U+00D4 U+00C5)
  0x00, 0xD4, 0x00, 0xC6, 0x02, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD4, 0x00, 0xDD, 0x01, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x00, 0x01, // ÔĀ (U+00D4 U+0100)
  0x00, 0xD4, 0x01, 0x02, 0x01, // ÔĂ (U+00D4 U+0102)
  0x00, 0xD4, 0x01, 0x04, 0x01, // ÔĄ (U+00D4 U+0104)
  0x00, 0xD4, 0x01, 0x74, 0x01, // ÔŴ (U+00D4 U+0174)
  0x00, 0xD4, 0x01, 0x76, 0x01, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x01, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x22, 0x01, // Õ" (U+00D5 U+0022)
  0x00, 0xD5, 0x00, 0x27, 0x01, // Õ' (U+00D5 U+0027)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x41, 0x01, // ÕA (U+00D5 U+0041)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x00, 0x56, 0x01, // ÕV (U+00D5 U+0056)
  0x00, 0xD5, 0x00, 0x57, 0x01, // ÕW (U+00D5 U+0057)
  0x00, 0xD5, 0x00, 0x58, 0x01, // ÕX (U+00D5 U+0058)
  0x00, 0xD5, 0x00, 0x59, 0x01, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0xC0, 0x01, // ÕÀ (U+00D5 U+00C0)
  0x00, 0xD5, 0x00, 0xC1, 0x01, // ÕÁ (U+00D5 U+00C1)
  0x00, 0xD5, 0x00, 0xC2, 0x01, // ÕÂ (U+00D5 U+00C2)
  0x00, 0xD5, 0x00, 0xC3, 0x01, // ÕÃ (U+00D5 U+00C3)
  0x00, 0xD5, 0x00, 0xC4, 0x01, // ÕÄ (U+00D5 U+00C4)
  0x00, 0xD5, 0x00, 0xC5, 0x01, // ÕÅ (U+00D5 U+00C5)
  0x00, 0xD5, 0x00, 0xC6, 0x02, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD5, 0x00, 0xDD, 0x01, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x00, 0x01, // ÕĀ (U+00D5 U+0100)
  0x00, 0xD5, 0x01, 0x02, 0x01, // ÕĂ (U+00D5 U+0102)
  0x00, 0xD5, 0x01, 0x04, 0x01, // ÕĄ (U+00D5 U+0104)
  0x00, 0xD5, 0x01, 0x74, 0x01, // ÕŴ (U+00D5 U+0174)
  0x00, 0xD5, 0x01, 0x76, 0x01, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x01, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x22, 0x01, // Ö" (U+00D6 U+0022)
  0x00, 0xD6, 0x00, 0x27, 0x01, // Ö' (U+00D6 U+0027)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x41, 0x01, // ÖA (U+00D6 U+0041)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x00, 0x56, 0x01, // ÖV (U+00D6 U+0056)
  0x00, 0xD6, 0x00, 0x57, 0x01, // ÖW (U+00D6 U+0057)
  0x00, 0xD6, 0x00, 0x58, 0x01, // ÖX (U+00D6 U+0058)
  0x00, 0xD6, 0x00, 0x59, 0x01, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0xC0, 0x01, // ÖÀ (U+00D6 U+00C0)
  0x00, 0xD6, 0x00, 0xC1, 0x01, // ÖÁ (U+00D6 U+00C1)
  0x00, 0xD6, 0x00, 0xC2, 0x01, // ÖÂ (U+00D6 U+00C2)
  0x00, 0xD6, 0x00, 0xC3, 0x01, // ÖÃ (U+00D6 U+00C3)
  0x00, 0xD6, 0x00, 0xC4, 0x01, // ÖÄ (U+00D6 U+00C4)
  0x00, 0xD6, 0x00, 0xC5, 0x01, // ÖÅ (U+00D6 U+00C5)
  0x00, 0xD6, 0x00, 0xC6, 0x02, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD6, 0x00, 0xDD, 0x01, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x00, 0x01, // ÖĀ (U+00D6 U+0100)
  0x00, 0xD6, 0x01, 0x02, 0x01, // ÖĂ (U+00D6 U+0102)
  0x00, 0xD6, 0x01, 0x04, 0x01, // ÖĄ (U+00D6 U+0104)
  0x00, 0xD6, 0x01, 0x74, 0x01, // ÖŴ (U+00D6 U+0174)
  0x00, 0xD6, 0x01, 0x76, 0x01, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x01, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x22, 0x01, // Ø" (U+00D8 U+0022)
  0x00, 0xD8, 0x00, 0x27, 0x01, // Ø' (U+00D8 U+0027)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x41, 0x01, // ØA (U+00D8 U+0041)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x00, 0x56, 0x01, // ØV (U+00D8 U+0056)
  0x00, 0xD8, 0x00, 0x57, 0x01, // ØW (U+00D8 U+0057)
  0x00, 0xD8, 0x00, 0x58, 0x01, // ØX (U+00D8 U+0058)
  0x00, 0xD8, 0x00, 0x59, 0x01, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0xC0, 0x01, // ØÀ (U+00D8 U+00C0)
  0x00, 0xD8, 0x00, 0xC1, 0x01, // ØÁ (U+00D8 U+00C1)
  0x00, 0xD8, 0x00, 0xC2, 0x01, // ØÂ (U+00D8 U+00C2)
  0x00, 0xD8, 0x00, 0xC3, 0x01, // ØÃ (U+00D8 U+00C3)
  0x00, 0xD8, 0x00, 0xC4, 0x01, // ØÄ (U+00D8 U+00C4)
  0x00, 0xD8, 0x00, 0xC5, 0x01, // ØÅ (U+00D8 U+00C5)
  0x00, 0xD8, 0x00, 0xC6, 0x02, // ØÆ (U+00D8 U+00C6)
  0x00, 0xD8, 0x00, 0xDD, 0x01, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x00, 0x01, // ØĀ (U+00D8 U+0100)
  0x00, 0xD8, 0x01, 0x02, 0x01, // ØĂ (U+00D8 U+0102)
  0x00, 0xD8, 0x01, 0x04, 0x01, // ØĄ (U+00D8 U+0104)
  0x00, 0xD8, 0x01, 0x74, 0x01, // ØŴ (U+00D8 U+0174)
  0x00, 0xD8, 0x01, 0x76, 0x01, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x01, // ØŸ (U+00D8 U+0178)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x26, 0x01, // Ù& (U+00D9 U+0026)
  0x00, 0xD9, 0x00, 0x2C, 0x01, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x01, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x00, 0x41, 0x01, // ÙA (U+00D9 U+0041)
  0x00, 0xD9, 0x00, 0xC0, 0x01, // ÙÀ (U+00D9 U+00C0)
  0x00, 0xD9, 0x00, 0xC1, 0x01, // ÙÁ (U+00D9 U+00C1)
  0x00, 0xD9, 0x00, 0xC2, 0x01, // ÙÂ (U+00D9 U+00C2)
  0x00, 0xD9, 0x00, 0xC3, 0x01, // ÙÃ (U+00D9 U+00C3)
  0x00, 0xD9, 0x00, 0xC4, 0x01, // ÙÄ (U+00D9 U+00C4)
  0x00, 0xD9, 0x00, 0xC5, 0x01, // ÙÅ (U+00D9 U+00C5)
  0x00, 0xD9, 0x00, 0xC6, 0x01, // ÙÆ (U+00D9 U+00C6)
  0x00, 0xD9, 0x01, 0x00, 0x01, // ÙĀ (U+00D9 U+0100)
  0x00, 0xD9, 0x01, 0x02, 0x01, // ÙĂ (U+00D9 U+0102)
  0x00, 0xD9, 0x01, 0x04, 0x01, // ÙĄ (U+00D9 U+0104)
  0x00, 0xD9, 0x20, 0x1A, 0x01, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x01, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x01, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x26, 0x01, // Ú& (U+00DA U+0026)
  0x00, 0xDA, 0x00, 0x2C, 0x01, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x01, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x00, 0x41, 0x01, // ÚA (U+00DA U+0041)
  0x00, 0xDA, 0x00, 0xC0, 0x01, // ÚÀ (U+00DA U+00C0)
  0x00, 0xDA, 0x00, 0xC1, 0x01, // ÚÁ (U+00DA U+00C1)
  0x00, 0xDA, 0x00, 0xC2, 0x01, // ÚÂ (U+00DA U+00C2)
  0x00, 0xDA, 0x00, 0xC3, 0x01, // ÚÃ (U+00DA U+00C3)
  0x00, 0xDA, 0x00, 0xC4, 0x01, // ÚÄ (U+00DA U+00C4)
  0x00, 0xDA, 0x00, 0xC5, 0x01, // ÚÅ (U+00DA U+00C5)
  0x00, 0xDA, 0x00, 0xC6, 0x01, // ÚÆ (U+00DA U+00C6)
  0x00, 0xDA, 0x01, 0x00, 0x01, // ÚĀ (U+00DA U+0100)
  0x00, 0xDA, 0x01, 0x02, 0x01, // ÚĂ (U+00DA U+0102)
  0x00, 0xDA, 0x01, 0x04, 0x01, // ÚĄ (U+00DA U+0104)
  0x00, 0xDA, 0x20, 0x1A, 0x01, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x01, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x01, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x26, 0x01, // Û& (U+00DB U+0026)
  0x00, 0xDB, 0x00, 0x2C, 0x01, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x01, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x00, 0x41, 0x01, // ÛA (U+00DB U+0041)
  0x00, 0xDB, 0x00, 0xC0, 0x01, // ÛÀ (U+00DB U+00C0)
  0x00, 0xDB, 0x00, 0xC1, 0x01, // ÛÁ (U+00DB U+00C1)
  0x00, 0xDB, 0x00, 0xC2, 0x01, // ÛÂ (U+00DB U+00C2)
  0x00, 0xDB, 0x00, 0xC3, 0x01, // ÛÃ (U+00DB U+00C3)
  0x00, 0xDB, 0x00, 0xC4, 0x01, // ÛÄ (U+00DB U+00C4)
  0x00, 0xDB, 0x00, 0xC5, 0x01, // ÛÅ (U+00DB U+00C5)
  0x00, 0xDB, 0x00, 0xC6, 0x01, // ÛÆ (U+00DB U+00C6)
  0x00, 0xDB, 0x01, 0x00, 0x01, // ÛĀ (U+00DB U+0100)
  0x00, 0xDB, 0x01, 0x02, 0x01, // ÛĂ (U+00DB U+0102)
  0x00, 0xDB, 0x01, 0x04, 0x01, // ÛĄ (U+00DB U+0104)
  0x00, 0xDB, 0x20, 0x1A, 0x01, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x01, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x01, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x26, 0x01, // Ü& (U+00DC U+0026)
  0x00, 0xDC, 0x00, 0x2C, 0x01, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x01, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x00, 0x41, 0x01, // ÜA (U+00DC U+0041)
  0x00, 0xDC, 0x00, 0xC0, 0x01, // ÜÀ (U+00DC U+00C0)
  0x00, 0xDC, 0x00, 0xC1, 0x01, // ÜÁ (U+00DC U+00C1)
  0x00, 0xDC, 0x00, 0xC2, 0x01, // ÜÂ (U+00DC U+00C2)
  0x00, 0xDC, 0x00, 0xC3, 0x01, // ÜÃ (U+00DC U+00C3)
  0x00, 0xDC, 0x00, 0xC4, 0x01, // ÜÄ (U+00DC U+00C4)
  0x00, 0xDC, 0x00, 0xC5, 0x01, // ÜÅ (U+00DC U+00C5)
  0x00, 0xDC, 0x00, 0xC6, 0x01, // ÜÆ (U+00DC U+00C6)
  0x00, 0xDC, 0x01, 0x00, 0x01, // ÜĀ (U+00DC U+0100)
  0x00, 0xDC, 0x01, 0x02, 0x01, // ÜĂ (U+00DC U+0102)
  0x00, 0xDC, 0x01, 0x04, 0x01, // ÜĄ (U+00DC U+0104)
  0x00, 0xDC, 0x20, 0x1A, 0x01, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x01, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x01, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x03, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x03, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x03, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x01, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x01, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x01, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x01, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x53, 0x01, // ÝS (U+00DD U+0053)
  0x00, 0xDD, 0x00, 0x61, 0x02, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x03, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x03, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x03, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x03, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x03, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x03, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x02, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x7A, 0x01, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xC0, 0x03, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x03, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x03, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x03, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x03, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x03, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x04, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xC7, 0x01, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x01, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x01, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x01, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x01, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x01, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x01, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x02, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x02, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x02, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x02, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x02, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x02, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x02, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x03, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x03, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x03, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x03, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x03, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x03, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x03, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x03, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x03, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x03, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x03, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x03, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x03, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x02, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x03, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x02, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x03, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x02, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x01, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x03, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x01, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x03, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x01, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x03, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x01, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x03, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x03, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x03, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x03, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x03, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x03, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x03, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x03, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x01, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x03, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x01, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x03, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x01, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x03, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x01, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x03, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4C, 0x01, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x03, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x01, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x03, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x01, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x03, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x01, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x03, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5A, 0x01, // ÝŚ (U+00DD U+015A)
  0x00, 0xDD, 0x01, 0x5B, 0x02, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5C, 0x01, // ÝŜ (U+00DD U+015C)
  0x00, 0xDD, 0x01, 0x5D, 0x02, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5E, 0x01, // ÝŞ (U+00DD U+015E)
  0x00, 0xDD, 0x01, 0x5F, 0x02, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x60, 0x01, // ÝŠ (U+00DD U+0160)
  0x00, 0xDD, 0x01, 0x61, 0x02, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x01, 0x7A, 0x01, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x01, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x01, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x03, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x03, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x03, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x22, 0x01, // Þ" (U+00DE U+0022)
  0x00, 0xDE, 0x00, 0x27, 0x01, // Þ' (U+00DE U+0027)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x54, 0x01, // ÞT (U+00DE U+0054)
  0x00, 0xDE, 0x00, 0x56, 0x01, // ÞV (U+00DE U+0056)
  0x00, 0xDE, 0x00, 0x57, 0x01, // ÞW (U+00DE U+0057)
  0x00, 0xDE, 0x00, 0x58, 0x01, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0x59, 0x01, // ÞY (U+00DE U+0059)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x02, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x00, 0xDD, 0x01, // ÞÝ (U+00DE U+00DD)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x01, 0x74, 0x01, // ÞŴ (U+00DE U+0174)
  0x00, 0xDE, 0x01, 0x76, 0x01, // ÞŶ (U+00DE U+0176)
  0x00, 0xDE, 0x01, 0x78, 0x01, // ÞŸ (U+00DE U+0178)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x00, 0xDF, 0x00, 0x22, 0x01, // ß" (U+00DF U+0022)
  0x00, 0xDF, 0x00, 0x27, 0x01, // ß' (U+00DF U+0027)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x02, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x02, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x02, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x02, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x02, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x02, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x00, 0x2A, 0x01, // à* (U+00E0 U+002A)
  0x00, 0xE0, 0x00, 0x54, 0x01, // àT (U+00E0 U+0054)
  0x00, 0xE0, 0x00, 0x56, 0x02, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x57, 0x02, // àW (U+00E0 U+0057)
  0x00, 0xE0, 0x00, 0x59, 0x02, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0xDD, 0x02, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x01, 0x74, 0x02, // àŴ (U+00E0 U+0174)
  0x00, 0xE0, 0x01, 0x76, 0x02, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x78, 0x02, // àŸ (U+00E0 U+0178)
  0x00, 0xE0, 0x20, 0x18, 0x01, // à‘ (U+00E0 U+2018)
  0x00, 0xE0, 0x20, 0x19, 0x01, // à’ (U+00E0 U+2019)
  0x00, 0xE0, 0x20, 0x1C, 0x01, // à“ (U+00E0 U+201C)
  0x00, 0xE0, 0x20, 0x1D, 0x01, // à” (U+00E0 U+201D)
  0x00, 0xE0, 0x21, 0x22, 0x01, // à™ (U+00E0 U+2122)
  0x00, 0xE1, 0x00, 0x22, 0x02, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x02, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x00, 0x2A, 0x01, // á* (U+00E1 U+002A)
  0x00, 0xE1, 0x00, 0x54, 0x01, // áT (U+00E1 U+0054)
  0x00, 0xE1, 0x00, 0x56, 0x02, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x57, 0x02, // áW (U+00E1 U+0057)
  0x00, 0xE1, 0x00, 0x59, 0x02, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0xDD, 0x02, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x01, 0x74, 0x02, // áŴ (U+00E1 U+0174)
  0x00, 0xE1, 0x01, 0x76, 0x02, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x78, 0x02, // áŸ (U+00E1 U+0178)
  0x00, 0xE1, 0x20, 0x18, 0x01, // á‘ (U+00E1 U+2018)
  0x00, 0xE1, 0x20, 0x19, 0x01, // á’ (U+00E1 U+2019)
  0x00, 0xE1, 0x20, 0x1C, 0x01, // á“ (U+00E1 U+201C)
  0x00, 0xE1, 0x20, 0x1D, 0x01, // á” (U+00E1 U+201D)
  0x00, 0xE1, 0x21, 0x22, 0x01, // á™ (U+00E1 U+2122)
  0x00, 0xE2, 0x00, 0x22, 0x02, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x02, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x00, 0x2A, 0x01, // â* (U+00E2 U+002A)
  0x00, 0xE2, 0x00, 0x54, 0x01, // âT (U+00E2 U+0054)
  0x00, 0xE2, 0x00, 0x56, 0x02, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x57, 0x02, // âW (U+00E2 U+0057)
  0x00, 0xE2, 0x00, 0x59, 0x02, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0xDD, 0x02, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x01, 0x74, 0x02, // âŴ (U+00E2 U+0174)
  0x00, 0xE2, 0x01, 0x76, 0x02, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x78, 0x02, // âŸ (U+00E2 U+0178)
  0x00, 0xE2, 0x20, 0x18, 0x01, // â‘ (U+00E2 U+2018)
  0x00, 0xE2, 0x20, 0x19, 0x01, // â’ (U+00E2 U+2019)
  0x00, 0xE2, 0x20, 0x1C, 0x01, // â“ (U+00E2 U+201C)
  0x00, 0xE2, 0x20, 0x1D, 0x01, // â” (U+00E2 U+201D)
  0x00, 0xE2, 0x21, 0x22, 0x01, // â™ (U+00E2 U+2122)
  0x00, 0xE3, 0x00, 0x22, 0x02, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x02, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x00, 0x2A, 0x01, // ã* (U+00E3 U+002A)
  0x00, 0xE3, 0x00, 0x54, 0x01, // ãT (U+00E3 U+0054)
  0x00, 0xE3, 0x00, 0x56, 0x02, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x57, 0x02, // ãW (U+00E3 U+0057)
  0x00, 0xE3, 0x00, 0x59, 0x02, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0xDD, 0x02, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x01, 0x74, 0x02, // ãŴ (U+00E3 U+0174)
  0x00, 0xE3, 0x01, 0x76, 0x02, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x78, 0x02, // ãŸ (U+00E3 U+0178)
  0x00, 0xE3, 0x20, 0x18, 0x01, // ã‘ (U+00E3 U+2018)
  0x00, 0xE3, 0x20, 0x19, 0x01, // ã’ (U+00E3 U+2019)
  0x00, 0xE3, 0x20, 0x1C, 0x01, // ã“ (U+00E3 U+201C)
  0x00, 0xE3, 0x20, 0x1D, 0x01, // ã” (U+00E3 U+201D)
  0x00, 0xE3, 0x21, 0x22, 0x01, // ã™ (U+00E3 U+2122)
  0x00, 0xE4, 0x00, 0x22, 0x02, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x02, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x00, 0x2A, 0x01, // ä* (U+00E4 U+002A)
  0x00, 0xE4, 0x00, 0x54, 0x01, // äT (U+00E4 U+0054)
  0x00, 0xE4, 0x00, 0x56, 0x02, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x57, 0x02, // äW (U+00E4 U+0057)
  0x00, 0xE4, 0x00, 0x59, 0x02, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0xDD, 0x02, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x01, 0x74, 0x02, // äŴ (U+00E4 U+0174)
  0x00, 0xE4, 0x01, 0x76, 0x02, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x78, 0x02, // äŸ (U+00E4 U+0178)
  0x00, 0xE4, 0x20, 0x18, 0x01, // ä‘ (U+00E4 U+2018)
  0x00, 0xE4, 0x20, 0x19, 0x01, // ä’ (U+00E4 U+2019)
  0x00, 0xE4, 0x20, 0x1C, 0x01, // ä“ (U+00E4 U+201C)
  0x00, 0xE4, 0x20, 0x1D, 0x01, // ä” (U+00E4 U+201D)
  0x00, 0xE4, 0x21, 0x22, 0x01, // ä™ (U+00E4 U+2122)
  0x00, 0xE5, 0x00, 0x22, 0x02, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x02, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x00, 0x2A, 0x01, // å* (U+00E5 U+002A)
  0x00, 0xE5, 0x00, 0x54, 0x01, // åT (U+00E5 U+0054)
  0x00, 0xE5, 0x00, 0x56, 0x02, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x57, 0x02, // åW (U+00E5 U+0057)
  0x00, 0xE5, 0x00, 0x59, 0x02, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0xDD, 0x02, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x01, 0x74, 0x02, // åŴ (U+00E5 U+0174)
  0x00, 0xE5, 0x01, 0x76, 0x02, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x78, 0x02, // åŸ (U+00E5 U+0178)
  0x00, 0xE5, 0x20, 0x18, 0x01, // å‘ (U+00E5 U+2018)
  0x00, 0xE5, 0x20, 0x19, 0x01, // å’ (U+00E5 U+2019)
  0x00, 0xE5, 0x20, 0x1C, 0x01, // å“ (U+00E5 U+201C)
  0x00, 0xE5, 0x20, 0x1D, 0x01, // å” (U+00E5 U+201D)
  0x00, 0xE5, 0x21, 0x22, 0x01, // å™ (U+00E5 U+2122)
  0x00, 0xE6, 0x00, 0x56, 0x02, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x02, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x02, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x02, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x02, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x02, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x02, // æŸ (U+00E6 U+0178)
  0x00, 0xE7, 0x00, 0x56, 0x02, // çV (U+00E7 U+0056)
  0x00, 0xE7, 0x00, 0x57, 0x02, // çW (U+00E7 U+0057)
  0x00, 0xE7, 0x00, 0x59, 0x02, // çY (U+00E7 U+0059)
  0x00, 0xE7, 0x00, 0xDD, 0x02, // çÝ (U+00E7 U+00DD)
  0x00, 0xE7, 0x01, 0x74, 0x02, // çŴ (U+00E7 U+0174)
  0x00, 0xE7, 0x01, 0x76, 0x02, // çŶ (U+00E7 U+0176)
  0x00, 0xE7, 0x01, 0x78, 0x02, // çŸ (U+00E7 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x02, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x02, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x02, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x02, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x02, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x02, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x02, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x02, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x02, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x02, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x02, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x02, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x02, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x02, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x02, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x02, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x02, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x02, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x02, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x02, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x02, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x02, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x02, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x02, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x02, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x02, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x02, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x02, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x54, 0x01, // ðT (U+00F0 U+0054)
  0x00, 0xF0, 0x00, 0x56, 0x02, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x02, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x03, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0x78, 0x01, // ðx (U+00F0 U+0078)
  0x00, 0xF0, 0x00, 0x79, 0x01, // ðy (U+00F0 U+0079)
  0x00, 0xF0, 0x00, 0xDD, 0x03, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x00, 0xFD, 0x01, // ðý (U+00F0 U+00FD)
  0x00, 0xF0, 0x00, 0xFF, 0x01, // ðÿ (U+00F0 U+00FF)
  0x00, 0xF0, 0x01, 0x74, 0x02, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x03, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x77, 0x01, // ðŷ (U+00F0 U+0177)
  0x00, 0xF0, 0x01, 0x78, 0x03, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x02, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x02, // ñ' (U+00F1 U+0027)
  0x00, 0xF1, 0x00, 0x2A, 0x01, // ñ* (U+00F1 U+002A)
  0x00, 0xF1, 0x00, 0x54, 0x01, // ñT (U+00F1 U+0054)
  0x00, 0xF1, 0x00, 0x56, 0x02, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x57, 0x02, // ñW (U+00F1 U+0057)
  0x00, 0xF1, 0x00, 0x59, 0x02, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0xDD, 0x02, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x01, 0x74, 0x02, // ñŴ (U+00F1 U+0174)
  0x00, 0xF1, 0x01, 0x76, 0x02, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x78, 0x02, // ñŸ (U+00F1 U+0178)
  0x00, 0xF1, 0x20, 0x18, 0x01, // ñ‘ (U+00F1 U+2018)
  0x00, 0xF1, 0x20, 0x19, 0x01, // ñ’ (U+00F1 U+2019)
  0x00, 0xF1, 0x20, 0x1C, 0x01, // ñ“ (U+00F1 U+201C)
  0x00, 0xF1, 0x20, 0x1D, 0x01, // ñ” (U+00F1 U+201D)
  0x00, 0xF1, 0x21, 0x22, 0x01, // ñ™ (U+00F1 U+2122)
  0x00, 0xF2, 0x00, 0x54, 0x01, // òT (U+00F2 U+0054)
  0x00, 0xF2, 0x00, 0x56, 0x02, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x02, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x03, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0x78, 0x01, // òx (U+00F2 U+0078)
  0x00, 0xF2, 0x00, 0x79, 0x01, // òy (U+00F2 U+0079)
  0x00, 0xF2, 0x00, 0xDD, 0x03, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x00, 0xFD, 0x01, // òý (U+00F2 U+00FD)
  0x00, 0xF2, 0x00, 0xFF, 0x01, // òÿ (U+00F2 U+00FF)
  0x00, 0xF2, 0x01, 0x74, 0x02, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x03, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x77, 0x01, // òŷ (U+00F2 U+0177)
  0x00, 0xF2, 0x01, 0x78, 0x03, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x54, 0x01, // óT (U+00F3 U+0054)
  0x00, 0xF3, 0x00, 0x56, 0x02, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x02, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x03, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0x78, 0x01, // óx (U+00F3 U+0078)
  0x00, 0xF3, 0x00, 0x79, 0x01, // óy (U+00F3 U+0079)
  0x00, 0xF3, 0x00, 0xDD, 0x03, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x00, 0xFD, 0x01, // óý (U+00F3 U+00FD)
  0x00, 0xF3, 0x00, 0xFF, 0x01, // óÿ (U+00F3 U+00FF)
  0x00, 0xF3, 0x01, 0x74, 0x02, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x03, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x77, 0x01, // óŷ (U+00F3 U+0177)
  0x00, 0xF3, 0x01, 0x78, 0x03, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x54, 0x01, // ôT (U+00F4 U+0054)
  0x00, 0xF4, 0x00, 0x56, 0x02, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x02, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x03, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0x78, 0x01, // ôx (U+00F4 U+0078)
  0x00, 0xF4, 0x00, 0x79, 0x01, // ôy (U+00F4 U+0079)
  0x00, 0xF4, 0x00, 0xDD, 0x03, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x00, 0xFD, 0x01, // ôý (U+00F4 U+00FD)
  0x00, 0xF4, 0x00, 0xFF, 0x01, // ôÿ (U+00F4 U+00FF)
  0x00, 0xF4, 0x01, 0x74, 0x02, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x03, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x77, 0x01, // ôŷ (U+00F4 U+0177)
  0x00, 0xF4, 0x01, 0x78, 0x03, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x54, 0x01, // õT (U+00F5 U+0054)
  0x00, 0xF5, 0x00, 0x56, 0x02, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x02, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x03, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0x78, 0x01, // õx (U+00F5 U+0078)
  0x00, 0xF5, 0x00, 0x79, 0x01, // õy (U+00F5 U+0079)
  0x00, 0xF5, 0x00, 0xDD, 0x03, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x00, 0xFD, 0x01, // õý (U+00F5 U+00FD)
  0x00, 0xF5, 0x00, 0xFF, 0x01, // õÿ (U+00F5 U+00FF)
  0x00, 0xF5, 0x01, 0x74, 0x02, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x03, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x77, 0x01, // õŷ (U+00F5 U+0177)
  0x00, 0xF5, 0x01, 0x78, 0x03, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x54, 0x01, // öT (U+00F6 U+0054)
  0x00, 0xF6, 0x00, 0x56, 0x02, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x02, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x03, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0x78, 0x01, // öx (U+00F6 U+0078)
  0x00, 0xF6, 0x00, 0x79, 0x01, // öy (U+00F6 U+0079)
  0x00, 0xF6, 0x00, 0xDD, 0x03, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x00, 0xFD, 0x01, // öý (U+00F6 U+00FD)
  0x00, 0xF6, 0x00, 0xFF, 0x01, // öÿ (U+00F6 U+00FF)
  0x00, 0xF6, 0x01, 0x74, 0x02, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x03, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x77, 0x01, // öŷ (U+00F6 U+0177)
  0x00, 0xF6, 0x01, 0x78, 0x03, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x54, 0x01, // øT (U+00F8 U+0054)
  0x00, 0xF8, 0x00, 0x56, 0x02, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x02, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x03, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0x78, 0x01, // øx (U+00F8 U+0078)
  0x00, 0xF8, 0x00, 0x79, 0x01, // øy (U+00F8 U+0079)
  0x00, 0xF8, 0x00, 0xDD, 0x03, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x00, 0xFD, 0x01, // øý (U+00F8 U+00FD)
  0x00, 0xF8, 0x00, 0xFF, 0x01, // øÿ (U+00F8 U+00FF)
  0x00, 0xF8, 0x01, 0x74, 0x02, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x03, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x77, 0x01, // øŷ (U+00F8 U+0177)
  0x00, 0xF8, 0x01, 0x78, 0x03, // øŸ (U+00F8 U+0178)
  0x00, 0xF9, 0x00, 0x22, 0x02, // ù" (U+00F9 U+0022)
  0x00, 0xF9, 0x00, 0x27, 0x02, // ù' (U+00F9 U+0027)
  0x00, 0xF9, 0x00, 0x2A, 0x01, // ù* (U+00F9 U+002A)
  0x00, 0xF9, 0x00, 0x54, 0x01, // ùT (U+00F9 U+0054)
  0x00, 0xF9, 0x00, 0x56, 0x02, // ùV (U+00F9 U+0056)
  0x00, 0xF9, 0x00, 0x57, 0x02, // ùW (U+00F9 U+0057)
  0x00, 0xF9, 0x00, 0x59, 0x02, // ùY (U+00F9 U+0059)
  0x00, 0xF9, 0x00, 0xDD, 0x02, // ùÝ (U+00F9 U+00DD)
  0x00, 0xF9, 0x01, 0x74, 0x02, // ùŴ (U+00F9 U+0174)
  0x00, 0xF9, 0x01, 0x76, 0x02, // ùŶ (U+00F9 U+0176)
  0x00, 0xF9, 0x01, 0x78, 0x02, // ùŸ (U+00F9 U+0178)
  0x00, 0xF9, 0x20, 0x18, 0x01, // ù‘ (U+00F9 U+2018)
  0x00, 0xF9, 0x20, 0x19, 0x01, // ù’ (U+00F9 U+2019)
  0x00, 0xF9, 0x20, 0x1C, 0x01, // ù“ (U+00F9 U+201C)
  0x00, 0xF9, 0x20, 0x1D, 0x01, // ù” (U+00F9 U+201D)
  0x00, 0xF9, 0x21, 0x22, 0x01, // ù™ (U+00F9 U+2122)
  0x00, 0xFA, 0x00, 0x22, 0x02, // ú" (U+00FA U+0022)
  0x00, 0xFA, 0x00, 0x27, 0x02, // ú' (U+00FA U+0027)
  0x00, 0xFA, 0x00, 0x2A, 0x01, // ú* (U+00FA U+002A)
  0x00, 0xFA, 0x00, 0x54, 0x01, // úT (U+00FA U+0054)
  0x00, 0xFA, 0x00, 0x56, 0x02, // úV (U+00FA U+0056)
  0x00, 0xFA, 0x00, 0x57, 0x02, // úW (U+00FA U+0057)
  0x00, 0xFA, 0x00, 0x59, 0x02, // úY (U+00FA U+0059)
  0x00, 0xFA, 0x00, 0xDD, 0x02, // úÝ (U+00FA U+00DD)
  0x00, 0xFA, 0x01, 0x74, 0x02, // úŴ (U+00FA U+0174)
  0x00, 0xFA, 0x01, 0x76, 0x02, // úŶ (U+00FA U+0176)
  0x00, 0xFA, 0x01, 0x78, 0x02, // úŸ (U+00FA U+0178)
  0x00, 0xFA, 0x20, 0x18, 0x01, // ú‘ (U+00FA U+2018)
  0x00, 0xFA, 0x20, 0x19, 0x01, // ú’ (U+00FA U+2019)
  0x00, 0xFA, 0x20, 0x1C, 0x01, // ú“ (U+00FA U+201C)
  0x00, 0xFA, 0x20, 0x1D, 0x01, // ú” (U+00FA U+201D)
  0x00, 0xFA, 0x21, 0x22, 0x01, // ú™ (U+00FA U+2122)
  0x00, 0xFB, 0x00, 0x22, 0x02, // û" (U+00FB U+0022)
  0x00, 0xFB, 0x00, 0x27, 0x02, // û' (U+00FB U+0027)
  0x00, 0xFB, 0x00, 0x2A, 0x01, // û* (U+00FB U+002A)
  0x00, 0xFB, 0x00, 0x54, 0x01, // ûT (U+00FB U+0054)
  0x00, 0xFB, 0x00, 0x56, 0x02, // ûV (U+00FB U+0056)
  0x00, 0xFB, 0x00, 0x57, 0x02, // ûW (U+00FB U+0057)
  0x00, 0xFB, 0x00, 0x59, 0x02, // ûY (U+00FB U+0059)
  0x00, 0xFB, 0x00, 0xDD, 0x02, // ûÝ (U+00FB U+00DD)
  0x00, 0xFB, 0x01, 0x74, 0x02, // ûŴ (U+00FB U+0174)
  0x00, 0xFB, 0x01, 0x76, 0x02, // ûŶ (U+00FB U+0176)
  0x00, 0xFB, 0x01, 0x78, 0x02, // ûŸ (U+00FB U+0178)
  0x00, 0xFB, 0x20, 0x18, 0x01, // û‘ (U+00FB U+2018)
  0x00, 0xFB, 0x20, 0x19, 0x01, // û’ (U+00FB U+2019)
  0x00, 0xFB, 0x20, 0x1C, 0x01, // û“ (U+00FB U+201C)
  0x00, 0xFB, 0x20, 0x1D, 0x01, // û” (U+00FB U+201D)
  0x00, 0xFB, 0x21, 0x22, 0x01, // û™ (U+00FB U+2122)
  0x00, 0xFC, 0x00, 0x22, 0x02, // ü" (U+00FC U+0022)
  0x00, 0xFC, 0x00, 0x27, 0x02, // ü' (U+00FC U+0027)
  0x00, 0xFC, 0x00, 0x2A, 0x01, // ü* (U+00FC U+002A)
  0x00, 0xFC, 0x00, 0x54, 0x01, // üT (U+00FC U+0054)
  0x00, 0xFC, 0x00, 0x56, 0x02, // üV (U+00FC U+0056)
  0x00, 0xFC, 0x00, 0x57, 0x02, // üW (U+00FC U+0057)
  0x00, 0xFC, 0x00, 0x59, 0x02, // üY (U+00FC U+0059)
  0x00, 0xFC, 0x00, 0xDD, 0x02, // üÝ (U+00FC U+00DD)
  0x00, 0xFC, 0x01, 0x74, 0x02, // üŴ (U+00FC U+0174)
  0x00, 0xFC, 0x01, 0x76, 0x02, // üŶ (U+00FC U+0176)
  0x00, 0xFC, 0x01, 0x78, 0x02, // üŸ (U+00FC U+0178)
  0x00, 0xFC, 0x20, 0x18, 0x01, // ü‘ (U+00FC U+2018)
  0x00, 0xFC, 0x20, 0x19, 0x01, // ü’ (U+00FC U+2019)
  0x00, 0xFC, 0x20, 0x1C, 0x01, // ü“ (U+00FC U+201C)
  0x00, 0xFC, 0x20, 0x1D, 0x01, // ü” (U+00FC U+201D)
  0x00, 0xFC, 0x21, 0x22, 0x01, // ü™ (U+00FC U+2122)
  0x00, 0xFD, 0x00, 0x2C, 0x03, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x03, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x01, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0x56, 0x01, // ýV (U+00FD U+0056)
  0x00, 0xFD, 0x00, 0x57, 0x01, // ýW (U+00FD U+0057)
  0x00, 0xFD, 0x00, 0x59, 0x01, // ýY (U+00FD U+0059)
  0x00, 0xFD, 0x00, 0xC0, 0x01, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x01, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x01, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x01, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x01, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x01, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x00, 0xDD, 0x01, // ýÝ (U+00FD U+00DD)
  0x00, 0xFD, 0x01, 0x00, 0x01, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x01, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x01, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x01, 0x74, 0x01, // ýŴ (U+00FD U+0174)
  0x00, 0xFD, 0x01, 0x76, 0x01, // ýŶ (U+00FD U+0176)
  0x00, 0xFD, 0x01, 0x78, 0x01, // ýŸ (U+00FD U+0178)
  0x00, 0xFD, 0x20, 0x1A, 0x03, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x03, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x03, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x54, 0x01, // þT (U+00FE U+0054)
  0x00, 0xFE, 0x00, 0x56, 0x02, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x02, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x03, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0x78, 0x01, // þx (U+00FE U+0078)
  0x00, 0xFE, 0x00, 0x79, 0x01, // þy (U+00FE U+0079)
  0x00, 0xFE, 0x00, 0xDD, 0x03, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x00, 0xFD, 0x01, // þý (U+00FE U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x01, // þÿ (U+00FE U+00FF)
  0x00, 0xFE, 0x01, 0x74, 0x02, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x03, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x77, 0x01, // þŷ (U+00FE U+0177)
  0x00, 0xFE, 0x01, 0x78, 0x03, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x03, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x03, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x01, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0x56, 0x01, // ÿV (U+00FF U+0056)
  0x00, 0xFF, 0x00, 0x57, 0x01, // ÿW (U+00FF U+0057)
  0x00, 0xFF, 0x00, 0x59, 0x01, // ÿY (U+00FF U+0059)
  0x00, 0xFF, 0x00, 0xC0, 0x01, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x01, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x01, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x01, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x01, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x01, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x00, 0xDD, 0x01, // ÿÝ (U+00FF U+00DD)
  0x00, 0xFF, 0x01, 0x00, 0x01, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x01, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x01, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x01, 0x74, 0x01, // ÿŴ (U+00FF U+0174)
  0x00, 0xFF, 0x01, 0x76, 0x01, // ÿŶ (U+00FF U+0176)
  0x00, 0xFF, 0x01, 0x78, 0x01, // ÿŸ (U+00FF U+0178)
  0x00, 0xFF, 0x20, 0x1A, 0x03, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x03, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x03, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x03, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x26, 0x01, // Ā& (U+0100 U+0026)
  0x01, 0x00, 0x00, 0x27, 0x03, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x03, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x43, 0x01, // ĀC (U+0100 U+0043)
  0x01, 0x00, 0x00, 0x47, 0x01, // ĀG (U+0100 U+0047)
  0x01, 0x00, 0x00, 0x4F, 0x01, // ĀO (U+0100 U+004F)
  0x01, 0x00, 0x00, 0x51, 0x01, // ĀQ (U+0100 U+0051)
  0x01, 0x00, 0x00, 0x54, 0x02, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x55, 0x01, // ĀU (U+0100 U+0055)
  0x01, 0x00, 0x00, 0x56, 0x03, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x03, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x03, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x63, 0x01, // Āc (U+0100 U+0063)
  0x01, 0x00, 0x00, 0x64, 0x01, // Ād (U+0100 U+0064)
  0x01, 0x00, 0x00, 0x65, 0x01, // Āe (U+0100 U+0065)
  0x01, 0x00, 0x00, 0x67, 0x01, // Āg (U+0100 U+0067)
  0x01, 0x00, 0x00, 0x6F, 0x01, // Āo (U+0100 U+006F)
  0x01, 0x00, 0x00, 0x71, 0x01, // Āq (U+0100 U+0071)
  0x01, 0x00, 0x00, 0x75, 0x01, // Āu (U+0100 U+0075)
  0x01, 0x00, 0x00, 0x76, 0x02, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x77, 0x01, // Āw (U+0100 U+0077)
  0x01, 0x00, 0x00, 0x79, 0x02, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xA9, 0x02, // Ā© (U+0100 U+00A9)
  0x01, 0x00, 0x00, 0xAE, 0x02, // Ā® (U+0100 U+00AE)
  0x01, 0x00, 0x00, 0xC7, 0x01, // ĀÇ (U+0100 U+00C7)
  0x01, 0x00, 0x00, 0xD2, 0x01, // ĀÒ (U+0100 U+00D2)
  0x01, 0x00, 0x00, 0xD3, 0x01, // ĀÓ (U+0100 U+00D3)
  0x01, 0x00, 0x00, 0xD4, 0x01, // ĀÔ (U+0100 U+00D4)
  0x01, 0x00, 0x00, 0xD5, 0x01, // ĀÕ (U+0100 U+00D5)
  0x01, 0x00, 0x00, 0xD6, 0x01, // ĀÖ (U+0100 U+00D6)
  0x01, 0x00, 0x00, 0xD8, 0x01, // ĀØ (U+0100 U+00D8)
  0x01, 0x00, 0x00, 0xD9, 0x01, // ĀÙ (U+0100 U+00D9)
  0x01, 0x00, 0x00, 0xDA, 0x01, // ĀÚ (U+0100 U+00DA)
  0x01, 0x00, 0x00, 0xDB, 0x01, // ĀÛ (U+0100 U+00DB)
  0x01, 0x00, 0x00, 0xDC, 0x01, // ĀÜ (U+0100 U+00DC)
  0x01, 0x00, 0x00, 0xDD, 0x03, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xE7, 0x01, // Āç (U+0100 U+00E7)
  0x01, 0x00, 0x00, 0xE8, 0x01, // Āè (U+0100 U+00E8)
  0x01, 0x00, 0x00, 0xE9, 0x01, // Āé (U+0100 U+00E9)
  0x01, 0x00, 0x00, 0xEA, 0x01, // Āê (U+0100 U+00EA)
  0x01, 0x00, 0x00, 0xEB, 0x01, // Āë (U+0100 U+00EB)
  0x01, 0x00, 0x00, 0xF0, 0x01, // Āð (U+0100 U+00F0)
  0x01, 0x00, 0x00, 0xF2, 0x01, // Āò (U+0100 U+00F2)
  0x01, 0x00, 0x00, 0xF3, 0x01, // Āó (U+0100 U+00F3)
  0x01, 0x00, 0x00, 0xF4, 0x01, // Āô (U+0100 U+00F4)
  0x01, 0x00, 0x00, 0xF5, 0x01, // Āõ (U+0100 U+00F5)
  0x01, 0x00, 0x00, 0xF6, 0x01, // Āö (U+0100 U+00F6)
  0x01, 0x00, 0x00, 0xF8, 0x01, // Āø (U+0100 U+00F8)
  0x01, 0x00, 0x00, 0xF9, 0x01, // Āù (U+0100 U+00F9)
  0x01, 0x00, 0x00, 0xFA, 0x01, // Āú (U+0100 U+00FA)
  0x01, 0x00, 0x00, 0xFB, 0x01, // Āû (U+0100 U+00FB)
  0x01, 0x00, 0x00, 0xFC, 0x01, // Āü (U+0100 U+00FC)
  0x01, 0x00, 0x00, 0xFD, 0x02, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x02, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x06, 0x01, // ĀĆ (U+0100 U+0106)
  0x01, 0x00, 0x01, 0x07, 0x01, // Āć (U+0100 U+0107)
  0x01, 0x00, 0x01, 0x08, 0x01, // ĀĈ (U+0100 U+0108)
  0x01, 0x00, 0x01, 0x09, 0x01, // Āĉ (U+0100 U+0109)
  0x01, 0x00, 0x01, 0x0A, 0x01, // ĀĊ (U+0100 U+010A)
  0x01, 0x00, 0x01, 0x0B, 0x01, // Āċ (U+0100 U+010B)
  0x01, 0x00, 0x01, 0x0C, 0x01, // ĀČ (U+0100 U+010C)
  0x01, 0x00, 0x01, 0x0D, 0x01, // Āč (U+0100 U+010D)
  0x01, 0x00, 0x01, 0x0F, 0x01, // Āď (U+0100 U+010F)
  0x01, 0x00, 0x01, 0x11, 0x01, // Āđ (U+0100 U+0111)
  0x01, 0x00, 0x01, 0x13, 0x01, // Āē (U+0100 U+0113)
  0x01, 0x00, 0x01, 0x15, 0x01, // Āĕ (U+0100 U+0115)
  0x01, 0x00, 0x01, 0x17, 0x01, // Āė (U+0100 U+0117)
  0x01, 0x00, 0x01, 0x19, 0x01, // Āę (U+0100 U+0119)
  0x01, 0x00, 0x01, 0x1B, 0x01, // Āě (U+0100 U+011B)
  0x01, 0x00, 0x01, 0x1C, 0x01, // ĀĜ (U+0100 U+011C)
  0x01, 0x00, 0x01, 0x1D, 0x01, // Āĝ (U+0100 U+011D)
  0x01, 0x00, 0x01, 0x1E, 0x01, // ĀĞ (U+0100 U+011E)
  0x01, 0x00, 0x01, 0x1F, 0x01, // Āğ (U+0100 U+011F)
  0x01, 0x00, 0x01, 0x20, 0x01, // ĀĠ (U+0100 U+0120)
  0x01, 0x00, 0x01, 0x21, 0x01, // Āġ (U+0100 U+0121)
  0x01, 0x00, 0x01, 0x22, 0x01, // ĀĢ (U+0100 U+0122)
  0x01, 0x00, 0x01, 0x23, 0x01, // Āģ (U+0100 U+0123)
  0x01, 0x00, 0x01, 0x49, 0x02, // Āŉ (U+0100 U+0149)
  0x01, 0x00, 0x01, 0x4C, 0x01, // ĀŌ (U+0100 U+014C)
  0x01, 0x00, 0x01, 0x4D, 0x01, // Āō (U+0100 U+014D)
  0x01, 0x00, 0x01, 0x4E, 0x01, // ĀŎ (U+0100 U+014E)
  0x01, 0x00, 0x01, 0x4F, 0x01, // Āŏ (U+0100 U+014F)
  0x01, 0x00, 0x01, 0x50, 0x01, // ĀŐ (U+0100 U+0150)
  0x01, 0x00, 0x01, 0x51, 0x01, // Āő (U+0100 U+0151)
  0x01, 0x00, 0x01, 0x52, 0x01, // ĀŒ (U+0100 U+0152)
  0x01, 0x00, 0x01, 0x53, 0x01, // Āœ (U+0100 U+0153)
  0x01, 0x00, 0x01, 0x68, 0x01, // ĀŨ (U+0100 U+0168)
  0x01, 0x00, 0x01, 0x69, 0x01, // Āũ (U+0100 U+0169)
  0x01, 0x00, 0x01, 0x6A, 0x01, // ĀŪ (U+0100 U+016A)
  0x01, 0x00, 0x01, 0x6B, 0x01, // Āū (U+0100 U+016B)
  0x01, 0x00, 0x01, 0x6C, 0x01, // ĀŬ (U+0100 U+016C)
  0x01, 0x00, 0x01, 0x6D, 0x01, // Āŭ (U+0100 U+016D)
  0x01, 0x00, 0x01, 0x6E, 0x01, // ĀŮ (U+0100 U+016E)
  0x01, 0x00, 0x01, 0x6F, 0x01, // Āů (U+0100 U+016F)
  0x01, 0x00, 0x01, 0x70, 0x01, // ĀŰ (U+0100 U+0170)
  0x01, 0x00, 0x01, 0x71, 0x01, // Āű (U+0100 U+0171)
  0x01, 0x00, 0x01, 0x72, 0x01, // ĀŲ (U+0100 U+0172)
  0x01, 0x00, 0x01, 0x73, 0x01, // Āų (U+0100 U+0173)
  0x01, 0x00, 0x01, 0x74, 0x03, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x75, 0x01, // Āŵ (U+0100 U+0175)
  0x01, 0x00, 0x01, 0x76, 0x03, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x02, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x03, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x04, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x03, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x04, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x03, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x03, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x22, 0x02, // ā" (U+0101 U+0022)
  0x01, 0x01, 0x00, 0x27, 0x02, // ā' (U+0101 U+0027)
  0x01, 0x01, 0x00, 0x2A, 0x01, // ā* (U+0101 U+002A)
  0x01, 0x01, 0x00, 0x54, 0x01, // āT (U+0101 U+0054)
  0x01, 0x01, 0x00, 0x56, 0x02, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x57, 0x02, // āW (U+0101 U+0057)
  0x01, 0x01, 0x00, 0x59, 0x02, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0xDD, 0x02, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x01, 0x74, 0x02, // āŴ (U+0101 U+0174)
  0x01, 0x01, 0x01, 0x76, 0x02, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x78, 0x02, // āŸ (U+0101 U+0178)
  0x01, 0x01, 0x20, 0x18, 0x01, // ā‘ (U+0101 U+2018)
  0x01, 0x01, 0x20, 0x19, 0x01, // ā’ (U+0101 U+2019)
  0x01, 0x01, 0x20, 0x1C, 0x01, // ā“ (U+0101 U+201C)
  0x01, 0x01, 0x20, 0x1D, 0x01, // ā” (U+0101 U+201D)
  0x01, 0x01, 0x21, 0x22, 0x01, // ā™ (U+0101 U+2122)
  0x01, 0x02, 0x00, 0x22, 0x03, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x26, 0x01, // Ă& (U+0102 U+0026)
  0x01, 0x02, 0x00, 0x27, 0x03, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x03, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x43, 0x01, // ĂC (U+0102 U+0043)
  0x01, 0x02, 0x00, 0x47, 0x01, // ĂG (U+0102 U+0047)
  0x01, 0x02, 0x00, 0x4F, 0x01, // ĂO (U+0102 U+004F)
  0x01, 0x02, 0x00, 0x51, 0x01, // ĂQ (U+0102 U+0051)
  0x01, 0x02, 0x00, 0x54, 0x02, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x55, 0x01, // ĂU (U+0102 U+0055)
  0x01, 0x02, 0x00, 0x56, 0x03, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x03, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x03, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x63, 0x01, // Ăc (U+0102 U+0063)
  0x01, 0x02, 0x00, 0x64, 0x01, // Ăd (U+0102 U+0064)
  0x01, 0x02, 0x00, 0x65, 0x01, // Ăe (U+0102 U+0065)
  0x01, 0x02, 0x00, 0x67, 0x01, // Ăg (U+0102 U+0067)
  0x01, 0x02, 0x00, 0x6F, 0x01, // Ăo (U+0102 U+006F)
  0x01, 0x02, 0x00, 0x71, 0x01, // Ăq (U+0102 U+0071)
  0x01, 0x02, 0x00, 0x75, 0x01, // Ău (U+0102 U+0075)
  0x01, 0x02, 0x00, 0x76, 0x02, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x77, 0x01, // Ăw (U+0102 U+0077)
  0x01, 0x02, 0x00, 0x79, 0x02, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xA9, 0x02, // Ă© (U+0102 U+00A9)
  0x01, 0x02, 0x00, 0xAE, 0x02, // Ă® (U+0102 U+00AE)
  0x01, 0x02, 0x00, 0xC7, 0x01, // ĂÇ (U+0102 U+00C7)
  0x01, 0x02, 0x00, 0xD2, 0x01, // ĂÒ (U+0102 U+00D2)
  0x01, 0x02, 0x00, 0xD3, 0x01, // ĂÓ (U+0102 U+00D3)
  0x01, 0x02, 0x00, 0xD4, 0x01, // ĂÔ (U+0102 U+00D4)
  0x01, 0x02, 0x00, 0xD5, 0x01, // ĂÕ (U+0102 U+00D5)
  0x01, 0x02, 0x00, 0xD6, 0x01, // ĂÖ (U+0102 U+00D6)
  0x01, 0x02, 0x00, 0xD8, 0x01, // ĂØ (U+0102 U+00D8)
  0x01, 0x02, 0x00, 0xD9, 0x01, // ĂÙ (U+0102 U+00D9)
  0x01, 0x02, 0x00, 0xDA, 0x01, // ĂÚ (U+0102 U+00DA)
  0x01, 0x02, 0x00, 0xDB, 0x01, // ĂÛ (U+0102 U+00DB)
  0x01, 0x02, 0x00, 0xDC, 0x01, // ĂÜ (U+0102 U+00DC)
  0x01, 0x02, 0x00, 0xDD, 0x03, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xE7, 0x01, // Ăç (U+0102 U+00E7)
  0x01, 0x02, 0x00, 0xE8, 0x01, // Ăè (U+0102 U+00E8)
  0x01, 0x02, 0x00, 0xE9, 0x01, // Ăé (U+0102 U+00E9)
  0x01, 0x02, 0x00, 0xEA, 0x01, // Ăê (U+0102 U+00EA)
  0x01, 0x02, 0x00, 0xEB, 0x01, // Ăë (U+0102 U+00EB)
  0x01, 0x02, 0x00, 0xF0, 0x01, // Ăð (U+0102 U+00F0)
  0x01, 0x02, 0x00, 0xF2, 0x01, // Ăò (U+0102 U+00F2)
  0x01, 0x02, 0x00, 0xF3, 0x01, // Ăó (U+0102 U+00F3)
  0x01, 0x02, 0x00, 0xF4, 0x01, // Ăô (U+0102 U+00F4)
  0x01, 0x02, 0x00, 0xF5, 0x01, // Ăõ (U+0102 U+00F5)
  0x01, 0x02, 0x00, 0xF6, 0x01, // Ăö (U+0102 U+00F6)
  0x01, 0x02, 0x00, 0xF8, 0x01, // Ăø (U+0102 U+00F8)
  0x01, 0x02, 0x00, 0xF9, 0x01, // Ăù (U+0102 U+00F9)
  0x01, 0x02, 0x00, 0xFA, 0x01, // Ăú (U+0102 U+00FA)
  0x01, 0x02, 0x00, 0xFB, 0x01, // Ăû (U+0102 U+00FB)
  0x01, 0x02, 0x00, 0xFC, 0x01, // Ăü (U+0102 U+00FC)
  0x01, 0x02, 0x00, 0xFD, 0x02, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x02, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x06, 0x01, // ĂĆ (U+0102 U+0106)
  0x01, 0x02, 0x01, 0x07, 0x01, // Ăć (U+0102 U+0107)
  0x01, 0x02, 0x01, 0x08, 0x01, // ĂĈ (U+0102 U+0108)
  0x01, 0x02, 0x01, 0x09, 0x01, // Ăĉ (U+0102 U+0109)
  0x01, 0x02, 0x01, 0x0A, 0x01, // ĂĊ (U+0102 U+010A)
  0x01, 0x02, 0x01, 0x0B, 0x01, // Ăċ (U+0102 U+010B)
  0x01, 0x02, 0x01, 0x0C, 0x01, // ĂČ (U+0102 U+010C)
  0x01, 0x02, 0x01, 0x0D, 0x01, // Ăč (U+0102 U+010D)
  0x01, 0x02, 0x01, 0x0F, 0x01, // Ăď (U+0102 U+010F)
  0x01, 0x02, 0x01, 0x11, 0x01, // Ăđ (U+0102 U+0111)
  0x01, 0x02, 0x01, 0x13, 0x01, // Ăē (U+0102 U+0113)
  0x01, 0x02, 0x01, 0x15, 0x01, // Ăĕ (U+0102 U+0115)
  0x01, 0x02, 0x01, 0x17, 0x01, // Ăė (U+0102 U+0117)
  0x01, 0x02, 0x01, 0x19, 0x01, // Ăę (U+0102 U+0119)
  0x01, 0x02, 0x01, 0x1B, 0x01, // Ăě (U+0102 U+011B)
  0x01, 0x02, 0x01, 0x1C, 0x01, // ĂĜ (U+0102 U+011C)
  0x01, 0x02, 0x01, 0x1D, 0x01, // Ăĝ (U+0102 U+011D)
  0x01, 0x02, 0x01, 0x1E, 0x01, // ĂĞ (U+0102 U+011E)
  0x01, 0x02, 0x01, 0x1F, 0x01, // Ăğ (U+0102 U+011F)
  0x01, 0x02, 0x01, 0x20, 0x01, // ĂĠ (U+0102 U+0120)
  0x01, 0x02, 0x01, 0x21, 0x01, // Ăġ (U+0102 U+0121)
  0x01, 0x02, 0x01, 0x22, 0x01, // ĂĢ (U+0102 U+0122)
  0x01, 0x02, 0x01, 0x23, 0x01, // Ăģ (U+0102 U+0123)
  0x01, 0x02, 0x01, 0x49, 0x02, // Ăŉ (U+0102 U+0149)
  0x01, 0x02, 0x01, 0x4C, 0x01, // ĂŌ (U+0102 U+014C)
  0x01, 0x02, 0x01, 0x4D, 0x01, // Ăō (U+0102 U+014D)
  0x01, 0x02, 0x01, 0x4E, 0x01, // ĂŎ (U+0102 U+014E)
  0x01, 0x02, 0x01, 0x4F, 0x01, // Ăŏ (U+0102 U+014F)
  0x01, 0x02, 0x01, 0x50, 0x01, // ĂŐ (U+0102 U+0150)
  0x01, 0x02, 0x01, 0x51, 0x01, // Ăő (U+0102 U+0151)
  0x01, 0x02, 0x01, 0x52, 0x01, // ĂŒ (U+0102 U+0152)
  0x01, 0x02, 0x01, 0x53, 0x01, // Ăœ (U+0102 U+0153)
  0x01, 0x02, 0x01, 0x68, 0x01, // ĂŨ (U+0102 U+0168)
  0x01, 0x02, 0x01, 0x69, 0x01, // Ăũ (U+0102 U+0169)
  0x01, 0x02, 0x01, 0x6A, 0x01, // ĂŪ (U+0102 U+016A)
  0x01, 0x02, 0x01, 0x6B, 0x01, // Ăū (U+0102 U+016B)
  0x01, 0x02, 0x01, 0x6C, 0x01, // ĂŬ (U+0102 U+016C)
  0x01, 0x02, 0x01, 0x6D, 0x01, // Ăŭ (U+0102 U+016D)
  0x01, 0x02, 0x01, 0x6E, 0x01, // ĂŮ (U+0102 U+016E)
  0x01, 0x02, 0x01, 0x6F, 0x01, // Ăů (U+0102 U+016F)
  0x01, 0x02, 0x01, 0x70, 0x01, // ĂŰ (U+0102 U+0170)
  0x01, 0x02, 0x01, 0x71, 0x01, // Ăű (U+0102 U+0171)
  0x01, 0x02, 0x01, 0x72, 0x01, // ĂŲ (U+0102 U+0172)
  0x01, 0x02, 0x01, 0x73, 0x01, // Ăų (U+0102 U+0173)
  0x01, 0x02, 0x01, 0x74, 0x03, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x75, 0x01, // Ăŵ (U+0102 U+0175)
  0x01, 0x02, 0x01, 0x76, 0x03, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x02, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x03, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x04, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x03, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x04, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x03, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x03, // Ă™ (U+0102 U+2122)
  0x01, 0x03, 0x00, 0x22, 0x02, // ă" (U+0103 U+0022)
  0x01, 0x03, 0x00, 0x27, 0x02, // ă' (U+0103 U+0027)
  0x01, 0x03, 0x00, 0x2A, 0x01, // ă* (U+0103 U+002A)
  0x01, 0x03, 0x00, 0x54, 0x01, // ăT (U+0103 U+0054)
  0x01, 0x03, 0x00, 0x56, 0x02, // ăV (U+0103 U+0056)
  0x01, 0x03, 0x00, 0x57, 0x02, // ăW (U+0103 U+0057)
  0x01, 0x03, 0x00, 0x59, 0x02, // ăY (U+0103 U+0059)
  0x01, 0x03, 0x00, 0xDD, 0x02, // ăÝ (U+0103 U+00DD)
  0x01, 0x03, 0x01, 0x74, 0x02, // ăŴ (U+0103 U+0174)
  0x01, 0x03, 0x01, 0x76, 0x02, // ăŶ (U+0103 U+0176)
  0x01, 0x03, 0x01, 0x78, 0x02, // ăŸ (U+0103 U+0178)
  0x01, 0x03, 0x20, 0x18, 0x01, // ă‘ (U+0103 U+2018)
  0x01, 0x03, 0x20, 0x19, 0x01, // ă’ (U+0103 U+2019)
  0x01, 0x03, 0x20, 0x1C, 0x01, // ă“ (U+0103 U+201C)
  0x01, 0x03, 0x20, 0x1D, 0x01, // ă” (U+0103 U+201D)
  0x01, 0x03, 0x21, 0x22, 0x01, // ă™ (U+0103 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x03, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x26, 0x01, // Ą& (U+0104 U+0026)
  0x01, 0x04, 0x00, 0x27, 0x03, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x03, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x43, 0x01, // ĄC (U+0104 U+0043)
  0x01, 0x04, 0x00, 0x47, 0x01, // ĄG (U+0104 U+0047)
  0x01, 0x04, 0x00, 0x4F, 0x01, // ĄO (U+0104 U+004F)
  0x01, 0x04, 0x00, 0x51, 0x01, // ĄQ (U+0104 U+0051)
  0x01, 0x04, 0x00, 0x54, 0x02, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x55, 0x01, // ĄU (U+0104 U+0055)
  0x01, 0x04, 0x00, 0x56, 0x03, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x03, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x03, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x63, 0x01, // Ąc (U+0104 U+0063)
  0x01, 0x04, 0x00, 0x64, 0x01, // Ąd (U+0104 U+0064)
  0x01, 0x04, 0x00, 0x65, 0x01, // Ąe (U+0104 U+0065)
  0x01, 0x04, 0x00, 0x67, 0x01, // Ąg (U+0104 U+0067)
  0x01, 0x04, 0x00, 0x6F, 0x01, // Ąo (U+0104 U+006F)
  0x01, 0x04, 0x00, 0x71, 0x01, // Ąq (U+0104 U+0071)
  0x01, 0x04, 0x00, 0x75, 0x01, // Ąu (U+0104 U+0075)
  0x01, 0x04, 0x00, 0x76, 0x02, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x77, 0x01, // Ąw (U+0104 U+0077)
  0x01, 0x04, 0x00, 0x79, 0x02, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xA9, 0x02, // Ą© (U+0104 U+00A9)
  0x01, 0x04, 0x00, 0xAE, 0x02, // Ą® (U+0104 U+00AE)
  0x01, 0x04, 0x00, 0xC7, 0x01, // ĄÇ (U+0104 U+00C7)
  0x01, 0x04, 0x00, 0xD2, 0x01, // ĄÒ (U+0104 U+00D2)
  0x01, 0x04, 0x00, 0xD3, 0x01, // ĄÓ (U+0104 U+00D3)
  0x01, 0x04, 0x00, 0xD4, 0x01, // ĄÔ (U+0104 U+00D4)
  0x01, 0x04, 0x00, 0xD5, 0x01, // ĄÕ (U+0104 U+00D5)
  0x01, 0x04, 0x00, 0xD6, 0x01, // ĄÖ (U+0104 U+00D6)
  0x01, 0x04, 0x00, 0xD8, 0x01, // ĄØ (U+0104 U+00D8)
  0x01, 0x04, 0x00, 0xD9, 0x01, // ĄÙ (U+0104 U+00D9)
  0x01, 0x04, 0x00, 0xDA, 0x01, // ĄÚ (U+0104 U+00DA)
  0x01, 0x04, 0x00, 0xDB, 0x01, // ĄÛ (U+0104 U+00DB)
  0x01, 0x04, 0x00, 0xDC, 0x01, // ĄÜ (U+0104 U+00DC)
  0x01, 0x04, 0x00, 0xDD, 0x03, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xE7, 0x01, // Ąç (U+0104 U+00E7)
  0x01, 0x04, 0x00, 0xE8, 0x01, // Ąè (U+0104 U+00E8)
  0x01, 0x04, 0x00, 0xE9, 0x01, // Ąé (U+0104 U+00E9)
  0x01, 0x04, 0x00, 0xEA, 0x01, // Ąê (U+0104 U+00EA)
  0x01, 0x04, 0x00, 0xEB, 0x01, // Ąë (U+0104 U+00EB)
  0x01, 0x04, 0x00, 0xF0, 0x01, // Ąð (U+0104 U+00F0)
  0x01, 0x04, 0x00, 0xF2, 0x01, // Ąò (U+0104 U+00F2)
  0x01, 0x04, 0x00, 0xF3, 0x01, // Ąó (U+0104 U+00F3)
  0x01, 0x04, 0x00, 0xF4, 0x01, // Ąô (U+0104 U+00F4)
  0x01, 0x04, 0x00, 0xF5, 0x01, // Ąõ (U+0104 U+00F5)
  0x01, 0x04, 0x00, 0xF6, 0x01, // Ąö (U+0104 U+00F6)
  0x01, 0x04, 0x00, 0xF8, 0x01, // Ąø (U+0104 U+00F8)
  0x01, 0x04, 0x00, 0xF9, 0x01, // Ąù (U+0104 U+00F9)
  0x01, 0x04, 0x00, 0xFA, 0x01, // Ąú (U+0104 U+00FA)
  0x01, 0x04, 0x00, 0xFB, 0x01, // Ąû (U+0104 U+00FB)
  0x01, 0x04, 0x00, 0xFC, 0x01, // Ąü (U+0104 U+00FC)
  0x01, 0x04, 0x00, 0xFD, 0x02, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x02, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x06, 0x01, // ĄĆ (U+0104 U+0106)
  0x01, 0x04, 0x01, 0x07, 0x01, // Ąć (U+0104 U+0107)
  0x01, 0x04, 0x01, 0x08, 0x01, // ĄĈ (U+0104 U+0108)
  0x01, 0x04, 0x01, 0x09, 0x01, // Ąĉ (U+0104 U+0109)
  0x01, 0x04, 0x01, 0x0A, 0x01, // ĄĊ (U+0104 U+010A)
  0x01, 0x04, 0x01, 0x0B, 0x01, // Ąċ (U+0104 U+010B)
  0x01, 0x04, 0x01, 0x0C, 0x01, // ĄČ (U+0104 U+010C)
  0x01, 0x04, 0x01, 0x0D, 0x01, // Ąč (U+0104 U+010D)
  0x01, 0x04, 0x01, 0x0F, 0x01, // Ąď (U+0104 U+010F)
  0x01, 0x04, 0x01, 0x11, 0x01, // Ąđ (U+0104 U+0111)
  0x01, 0x04, 0x01, 0x13, 0x01, // Ąē (U+0104 U+0113)
  0x01, 0x04, 0x01, 0x15, 0x01, // Ąĕ (U+0104 U+0115)
  0x01, 0x04, 0x01, 0x17, 0x01, // Ąė (U+0104 U+0117)
  0x01, 0x04, 0x01, 0x19, 0x01, // Ąę (U+0104 U+0119)
  0x01, 0x04, 0x01, 0x1B, 0x01, // Ąě (U+0104 U+011B)
  0x01, 0x04, 0x01, 0x1C, 0x01, // ĄĜ (U+0104 U+011C)
  0x01, 0x04, 0x01, 0x1D, 0x01, // Ąĝ (U+0104 U+011D)
  0x01, 0x04, 0x01, 0x1E, 0x01, // ĄĞ (U+0104 U+011E)
  0x01, 0x04, 0x01, 0x1F, 0x01, // Ąğ (U+0104 U+011F)
  0x01, 0x04, 0x01, 0x20, 0x01, // ĄĠ (U+0104 U+0120)
  0x01, 0x04, 0x01, 0x21, 0x01, // Ąġ (U+0104 U+0121)
  0x01, 0x04, 0x01, 0x22, 0x01, // ĄĢ (U+0104 U+0122)
  0x01, 0x04, 0x01, 0x23, 0x01, // Ąģ (U+0104 U+0123)
  0x01, 0x04, 0x01, 0x49, 0x02, // Ąŉ (U+0104 U+0149)
  0x01, 0x04, 0x01, 0x4C, 0x01, // ĄŌ (U+0104 U+014C)
  0x01, 0x04, 0x01, 0x4D, 0x01, // Ąō (U+0104 U+014D)
  0x01, 0x04, 0x01, 0x4E, 0x01, // ĄŎ (U+0104 U+014E)
  0x01, 0x04, 0x01, 0x4F, 0x01, // Ąŏ (U+0104 U+014F)
  0x01, 0x04, 0x01, 0x50, 0x01, // ĄŐ (U+0104 U+0150)
  0x01, 0x04, 0x01, 0x51, 0x01, // Ąő (U+0104 U+0151)
  0x01, 0x04, 0x01, 0x52, 0x01, // ĄŒ (U+0104 U+0152)
  0x01, 0x04, 0x01, 0x53, 0x01, // Ąœ (U+0104 U+0153)
  0x01, 0x04, 0x01, 0x68, 0x01, // ĄŨ (U+0104 U+0168)
  0x01, 0x04, 0x01, 0x69, 0x01, // Ąũ (U+0104 U+0169)
  0x01, 0x04, 0x01, 0x6A, 0x01, // ĄŪ (U+0104 U+016A)
  0x01, 0x04, 0x01, 0x6B, 0x01, // Ąū (U+0104 U+016B)
  0x01, 0x04, 0x01, 0x6C, 0x01, // ĄŬ (U+0104 U+016C)
  0x01, 0x04, 0x01, 0x6D, 0x01, // Ąŭ (U+0104 U+016D)
  0x01, 0x04, 0x01, 0x6E, 0x01, // ĄŮ (U+0104 U+016E)
  0x01, 0x04, 0x01, 0x6F, 0x01, // Ąů (U+0104 U+016F)
  0x01, 0x04, 0x01, 0x70, 0x01, // ĄŰ (U+0104 U+0170)
  0x01, 0x04, 0x01, 0x71, 0x01, // Ąű (U+0104 U+0171)
  0x01, 0x04, 0x01, 0x72, 0x01, // ĄŲ (U+0104 U+0172)
  0x01, 0x04, 0x01, 0x73, 0x01, // Ąų (U+0104 U+0173)
  0x01, 0x04, 0x01, 0x74, 0x03, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x75, 0x01, // Ąŵ (U+0104 U+0175)
  0x01, 0x04, 0x01, 0x76, 0x03, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x02, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x03, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x04, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x03, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x04, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x03, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x03, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x22, 0x02, // ą" (U+0105 U+0022)
  0x01, 0x05, 0x00, 0x27, 0x02, // ą' (U+0105 U+0027)
  0x01, 0x05, 0x00, 0x2A, 0x01, // ą* (U+0105 U+002A)
  0x01, 0x05, 0x00, 0x54, 0x01, // ąT (U+0105 U+0054)
  0x01, 0x05, 0x00, 0x56, 0x02, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x57, 0x02, // ąW (U+0105 U+0057)
  0x01, 0x05, 0x00, 0x59, 0x02, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0xDD, 0x02, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x01, 0x74, 0x02, // ąŴ (U+0105 U+0174)
  0x01, 0x05, 0x01, 0x76, 0x02, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x78, 0x02, // ąŸ (U+0105 U+0178)
  0x01, 0x05, 0x20, 0x18, 0x01, // ą‘ (U+0105 U+2018)
  0x01, 0x05, 0x20, 0x19, 0x01, // ą’ (U+0105 U+2019)
  0x01, 0x05, 0x20, 0x1C, 0x01, // ą“ (U+0105 U+201C)
  0x01, 0x05, 0x20, 0x1D, 0x01, // ą” (U+0105 U+201D)
  0x01, 0x05, 0x21, 0x22, 0x01, // ą™ (U+0105 U+2122)
  0x01, 0x06, 0x00, 0x26, 0x01, // Ć& (U+0106 U+0026)
  0x01, 0x07, 0x00, 0x56, 0x02, // ćV (U+0107 U+0056)
  0x01, 0x07, 0x00, 0x57, 0x02, // ćW (U+0107 U+0057)
  0x01, 0x07, 0x00, 0x59, 0x02, // ćY (U+0107 U+0059)
  0x01, 0x07, 0x00, 0xDD, 0x02, // ćÝ (U+0107 U+00DD)
  0x01, 0x07, 0x01, 0x74, 0x02, // ćŴ (U+0107 U+0174)
  0x01, 0x07, 0x01, 0x76, 0x02, // ćŶ (U+0107 U+0176)
  0x01, 0x07, 0x01, 0x78, 0x02, // ćŸ (U+0107 U+0178)
  0x01, 0x08, 0x00, 0x26, 0x01, // Ĉ& (U+0108 U+0026)
  0x01, 0x09, 0x00, 0x56, 0x02, // ĉV (U+0109 U+0056)
  0x01, 0x09, 0x00, 0x57, 0x02, // ĉW (U+0109 U+0057)
  0x01, 0x09, 0x00, 0x59, 0x02, // ĉY (U+0109 U+0059)
  0x01, 0x09, 0x00, 0xDD, 0x02, // ĉÝ (U+0109 U+00DD)
  0x01, 0x09, 0x01, 0x74, 0x02, // ĉŴ (U+0109 U+0174)
  0x01, 0x09, 0x01, 0x76, 0x02, // ĉŶ (U+0109 U+0176)
  0x01, 0x09, 0x01, 0x78, 0x02, // ĉŸ (U+0109 U+0178)
  0x01, 0x0A, 0x00, 0x26, 0x01, // Ċ& (U+010A U+0026)
  0x01, 0x0B, 0x00, 0x56, 0x02, // ċV (U+010B U+0056)
  0x01, 0x0B, 0x00, 0x57, 0x02, // ċW (U+010B U+0057)
  0x01, 0x0B, 0x00, 0x59, 0x02, // ċY (U+010B U+0059)
  0x01, 0x0B, 0x00, 0xDD, 0x02, // ċÝ (U+010B U+00DD)
  0x01, 0x0B, 0x01, 0x74, 0x02, // ċŴ (U+010B U+0174)
  0x01, 0x0B, 0x01, 0x76, 0x02, // ċŶ (U+010B U+0176)
  0x01, 0x0B, 0x01, 0x78, 0x02, // ċŸ (U+010B U+0178)
  0x01, 0x0C, 0x00, 0x26, 0x01, // Č& (U+010C U+0026)
  0x01, 0x0D, 0x00, 0x56, 0x02, // čV (U+010D U+0056)
  0x01, 0x0D, 0x00, 0x57, 0x02, // čW (U+010D U+0057)
  0x01, 0x0D, 0x00, 0x59, 0x02, // čY (U+010D U+0059)
  0x01, 0x0D, 0x00, 0xDD, 0x02, // čÝ (U+010D U+00DD)
  0x01, 0x0D, 0x01, 0x74, 0x02, // čŴ (U+010D U+0174)
  0x01, 0x0D, 0x01, 0x76, 0x02, // čŶ (U+010D U+0176)
  0x01, 0x0D, 0x01, 0x78, 0x02, // čŸ (U+010D U+0178)
  0x01, 0x0E, 0x00, 0x22, 0x01, // Ď" (U+010E U+0022)
  0x01, 0x0E, 0x00, 0x27, 0x01, // Ď' (U+010E U+0027)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x41, 0x01, // ĎA (U+010E U+0041)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x00, 0x56, 0x01, // ĎV (U+010E U+0056)
  0x01, 0x0E, 0x00, 0x57, 0x01, // ĎW (U+010E U+0057)
  0x01, 0x0E, 0x00, 0x58, 0x01, // ĎX (U+010E U+0058)
  0x01, 0x0E, 0x00, 0x59, 0x01, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0xC0, 0x01, // ĎÀ (U+010E U+00C0)
  0x01, 0x0E, 0x00, 0xC1, 0x01, // ĎÁ (U+010E U+00C1)
  0x01, 0x0E, 0x00, 0xC2, 0x01, // ĎÂ (U+010E U+00C2)
  0x01, 0x0E, 0x00, 0xC3, 0x01, // ĎÃ (U+010E U+00C3)
  0x01, 0x0E, 0x00, 0xC4, 0x01, // ĎÄ (U+010E U+00C4)
  0x01, 0x0E, 0x00, 0xC5, 0x01, // ĎÅ (U+010E U+00C5)
  0x01, 0x0E, 0x00, 0xC6, 0x02, // ĎÆ (U+010E U+00C6)
  0x01, 0x0E, 0x00, 0xDD, 0x01, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x00, 0x01, // ĎĀ (U+010E U+0100)
  0x01, 0x0E, 0x01, 0x02, 0x01, // ĎĂ (U+010E U+0102)
  0x01, 0x0E, 0x01, 0x04, 0x01, // ĎĄ (U+010E U+0104)
  0x01, 0x0E, 0x01, 0x74, 0x01, // ĎŴ (U+010E U+0174)
  0x01, 0x0E, 0x01, 0x76, 0x01, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x01, // ĎŸ (U+010E U+0178)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x22, 0x01, // Đ" (U+0110 U+0022)
  0x01, 0x10, 0x00, 0x27, 0x01, // Đ' (U+0110 U+0027)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x41, 0x01, // ĐA (U+0110 U+0041)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x00, 0x56, 0x01, // ĐV (U+0110 U+0056)
  0x01, 0x10, 0x00, 0x57, 0x01, // ĐW (U+0110 U+0057)
  0x01, 0x10, 0x00, 0x58, 0x01, // ĐX (U+0110 U+0058)
  0x01, 0x10, 0x00, 0x59, 0x01, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0xC0, 0x01, // ĐÀ (U+0110 U+00C0)
  0x01, 0x10, 0x00, 0xC1, 0x01, // ĐÁ (U+0110 U+00C1)
  0x01, 0x10, 0x00, 0xC2, 0x01, // ĐÂ (U+0110 U+00C2)
  0x01, 0x10, 0x00, 0xC3, 0x01, // ĐÃ (U+0110 U+00C3)
  0x01, 0x10, 0x00, 0xC4, 0x01, // ĐÄ (U+0110 U+00C4)
  0x01, 0x10, 0x00, 0xC5, 0x01, // ĐÅ (U+0110 U+00C5)
  0x01, 0x10, 0x00, 0xC6, 0x02, // ĐÆ (U+0110 U+00C6)
  0x01, 0x10, 0x00, 0xDD, 0x01, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x00, 0x01, // ĐĀ (U+0110 U+0100)
  0x01, 0x10, 0x01, 0x02, 0x01, // ĐĂ (U+0110 U+0102)
  0x01, 0x10, 0x01, 0x04, 0x01, // ĐĄ (U+0110 U+0104)
  0x01, 0x10, 0x01, 0x74, 0x01, // ĐŴ (U+0110 U+0174)
  0x01, 0x10, 0x01, 0x76, 0x01, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x01, // ĐŸ (U+0110 U+0178)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x12, 0x00, 0x56, 0x01, // ĒV (U+0112 U+0056)
  0x01, 0x12, 0x00, 0x57, 0x01, // ĒW (U+0112 U+0057)
  0x01, 0x12, 0x00, 0x59, 0x01, // ĒY (U+0112 U+0059)
  0x01, 0x12, 0x00, 0xDD, 0x01, // ĒÝ (U+0112 U+00DD)
  0x01, 0x12, 0x01, 0x74, 0x01, // ĒŴ (U+0112 U+0174)
  0x01, 0x12, 0x01, 0x76, 0x01, // ĒŶ (U+0112 U+0176)
  0x01, 0x12, 0x01, 0x78, 0x01, // ĒŸ (U+0112 U+0178)
  0x01, 0x13, 0x00, 0x56, 0x02, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x02, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x02, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x02, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x02, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x02, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x02, // ēŸ (U+0113 U+0178)
  0x01, 0x14, 0x00, 0x56, 0x01, // ĔV (U+0114 U+0056)
  0x01, 0x14, 0x00, 0x57, 0x01, // ĔW (U+0114 U+0057)
  0x01, 0x14, 0x00, 0x59, 0x01, // ĔY (U+0114 U+0059)
  0x01, 0x14, 0x00, 0xDD, 0x01, // ĔÝ (U+0114 U+00DD)
  0x01, 0x14, 0x01, 0x74, 0x01, // ĔŴ (U+0114 U+0174)
  0x01, 0x14, 0x01, 0x76, 0x01, // ĔŶ (U+0114 U+0176)
  0x01, 0x14, 0x01, 0x78, 0x01, // ĔŸ (U+0114 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x02, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x02, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x02, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x02, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x02, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x02, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x02, // ĕŸ (U+0115 U+0178)
  0x01, 0x16, 0x00, 0x56, 0x01, // ĖV (U+0116 U+0056)
  0x01, 0x16, 0x00, 0x57, 0x01, // ĖW (U+0116 U+0057)
  0x01, 0x16, 0x00, 0x59, 0x01, // ĖY (U+0116 U+0059)
  0x01, 0x16, 0x00, 0xDD, 0x01, // ĖÝ (U+0116 U+00DD)
  0x01, 0x16, 0x01, 0x74, 0x01, // ĖŴ (U+0116 U+0174)
  0x01, 0x16, 0x01, 0x76, 0x01, // ĖŶ (U+0116 U+0176)
  0x01, 0x16, 0x01, 0x78, 0x01, // ĖŸ (U+0116 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x02, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x02, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x02, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x02, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x02, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x02, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x02, // ėŸ (U+0117 U+0178)
  0x01, 0x18, 0x00, 0x56, 0x01, // ĘV (U+0118 U+0056)
  0x01, 0x18, 0x00, 0x57, 0x01, // ĘW (U+0118 U+0057)
  0x01, 0x18, 0x00, 0x59, 0x01, // ĘY (U+0118 U+0059)
  0x01, 0x18, 0x00, 0xDD, 0x01, // ĘÝ (U+0118 U+00DD)
  0x01, 0x18, 0x01, 0x74, 0x01, // ĘŴ (U+0118 U+0174)
  0x01, 0x18, 0x01, 0x76, 0x01, // ĘŶ (U+0118 U+0176)
  0x01, 0x18, 0x01, 0x78, 0x01, // ĘŸ (U+0118 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x02, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x02, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x02, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x02, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x02, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x02, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x02, // ęŸ (U+0119 U+0178)
  0x01, 0x1A, 0x00, 0x56, 0x01, // ĚV (U+011A U+0056)
  0x01, 0x1A, 0x00, 0x57, 0x01, // ĚW (U+011A U+0057)
  0x01, 0x1A, 0x00, 0x59, 0x01, // ĚY (U+011A U+0059)
  0x01, 0x1A, 0x00, 0xDD, 0x01, // ĚÝ (U+011A U+00DD)
  0x01, 0x1A, 0x01, 0x74, 0x01, // ĚŴ (U+011A U+0174)
  0x01, 0x1A, 0x01, 0x76, 0x01, // ĚŶ (U+011A U+0176)
  0x01, 0x1A, 0x01, 0x78, 0x01, // ĚŸ (U+011A U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x02, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x02, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x02, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x02, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x02, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x02, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x02, // ěŸ (U+011B U+0178)
  0x01, 0x1C, 0x00, 0x54, 0x01, // ĜT (U+011C U+0054)
  0x01, 0x1C, 0x00, 0x56, 0x01, // ĜV (U+011C U+0056)
  0x01, 0x1C, 0x00, 0x57, 0x01, // ĜW (U+011C U+0057)
  0x01, 0x1C, 0x00, 0x59, 0x01, // ĜY (U+011C U+0059)
  0x01, 0x1C, 0x00, 0xC6, 0x01, // ĜÆ (U+011C U+00C6)
  0x01, 0x1C, 0x00, 0xDD, 0x01, // ĜÝ (U+011C U+00DD)
  0x01, 0x1C, 0x01, 0x74, 0x01, // ĜŴ (U+011C U+0174)
  0x01, 0x1C, 0x01, 0x76, 0x01, // ĜŶ (U+011C U+0176)
  0x01, 0x1C, 0x01, 0x78, 0x01, // ĜŸ (U+011C U+0178)
  0x01, 0x1E, 0x00, 0x54, 0x01, // ĞT (U+011E U+0054)
  0x01, 0x1E, 0x00, 0x56, 0x01, // ĞV (U+011E U+0056)
  0x01, 0x1E, 0x00, 0x57, 0x01, // ĞW (U+011E U+0057)
  0x01, 0x1E, 0x00, 0x59, 0x01, // ĞY (U+011E U+0059)
  0x01, 0x1E, 0x00, 0xC6, 0x01, // ĞÆ (U+011E U+00C6)
  0x01, 0x1E, 0x00, 0xDD, 0x01, // ĞÝ (U+011E U+00DD)
  0x01, 0x1E, 0x01, 0x74, 0x01, // ĞŴ (U+011E U+0174)
  0x01, 0x1E, 0x01, 0x76, 0x01, // ĞŶ (U+011E U+0176)
  0x01, 0x1E, 0x01, 0x78, 0x01, // ĞŸ (U+011E U+0178)
  0x01, 0x20, 0x00, 0x54, 0x01, // ĠT (U+0120 U+0054)
  0x01, 0x20, 0x00, 0x56, 0x01, // ĠV (U+0120 U+0056)
  0x01, 0x20, 0x00, 0x57, 0x01, // ĠW (U+0120 U+0057)
  0x01, 0x20, 0x00, 0x59, 0x01, // ĠY (U+0120 U+0059)
  0x01, 0x20, 0x00, 0xC6, 0x01, // ĠÆ (U+0120 U+00C6)
  0x01, 0x20, 0x00, 0xDD, 0x01, // ĠÝ (U+0120 U+00DD)
  0x01, 0x20, 0x01, 0x74, 0x01, // ĠŴ (U+0120 U+0174)
  0x01, 0x20, 0x01, 0x76, 0x01, // ĠŶ (U+0120 U+0176)
  0x01, 0x20, 0x01, 0x78, 0x01, // ĠŸ (U+0120 U+0178)
  0x01, 0x22, 0x00, 0x54, 0x01, // ĢT (U+0122 U+0054)
  0x01, 0x22, 0x00, 0x56, 0x01, // ĢV (U+0122 U+0056)
  0x01, 0x22, 0x00, 0x57, 0x01, // ĢW (U+0122 U+0057)
  0x01, 0x22, 0x00, 0x59, 0x01, // ĢY (U+0122 U+0059)
  0x01, 0x22, 0x00, 0xC6, 0x01, // ĢÆ (U+0122 U+00C6)
  0x01, 0x22, 0x00, 0xDD, 0x01, // ĢÝ (U+0122 U+00DD)
  0x01, 0x22, 0x01, 0x74, 0x01, // ĢŴ (U+0122 U+0174)
  0x01, 0x22, 0x01, 0x76, 0x01, // ĢŶ (U+0122 U+0176)
  0x01, 0x22, 0x01, 0x78, 0x01, // ĢŸ (U+0122 U+0178)
  0x01, 0x25, 0x00, 0x22, 0x02, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x02, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x00, 0x2A, 0x01, // ĥ* (U+0125 U+002A)
  0x01, 0x25, 0x00, 0x54, 0x01, // ĥT (U+0125 U+0054)
  0x01, 0x25, 0x00, 0x56, 0x02, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x57, 0x02, // ĥW (U+0125 U+0057)
  0x01, 0x25, 0x00, 0x59, 0x02, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0xDD, 0x02, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x01, 0x74, 0x02, // ĥŴ (U+0125 U+0174)
  0x01, 0x25, 0x01, 0x76, 0x02, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x78, 0x02, // ĥŸ (U+0125 U+0178)
  0x01, 0x25, 0x20, 0x18, 0x01, // ĥ‘ (U+0125 U+2018)
  0x01, 0x25, 0x20, 0x19, 0x01, // ĥ’ (U+0125 U+2019)
  0x01, 0x25, 0x20, 0x1C, 0x01, // ĥ“ (U+0125 U+201C)
  0x01, 0x25, 0x20, 0x1D, 0x01, // ĥ” (U+0125 U+201D)
  0x01, 0x25, 0x21, 0x22, 0x01, // ĥ™ (U+0125 U+2122)
  0x01, 0x27, 0x00, 0x22, 0x02, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x02, // ħ' (U+0127 U+0027)
  0x01, 0x27, 0x00, 0x2A, 0x01, // ħ* (U+0127 U+002A)
  0x01, 0x27, 0x00, 0x54, 0x01, // ħT (U+0127 U+0054)
  0x01, 0x27, 0x00, 0x56, 0x02, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x57, 0x02, // ħW (U+0127 U+0057)
  0x01, 0x27, 0x00, 0x59, 0x02, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0xDD, 0x02, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x01, 0x74, 0x02, // ħŴ (U+0127 U+0174)
  0x01, 0x27, 0x01, 0x76, 0x02, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x78, 0x02, // ħŸ (U+0127 U+0178)
  0x01, 0x27, 0x20, 0x18, 0x01, // ħ‘ (U+0127 U+2018)
  0x01, 0x27, 0x20, 0x19, 0x01, // ħ’ (U+0127 U+2019)
  0x01, 0x27, 0x20, 0x1C, 0x01, // ħ“ (U+0127 U+201C)
  0x01, 0x27, 0x20, 0x1D, 0x01, // ħ” (U+0127 U+201D)
  0x01, 0x27, 0x21, 0x22, 0x01, // ħ™ (U+0127 U+2122)
  0x01, 0x32, 0x00, 0x2C, 0x01, // Ĳ, (U+0132 U+002C)
  0x01, 0x32, 0x00, 0x2E, 0x01, // Ĳ. (U+0132 U+002E)
  0x01, 0x32, 0x00, 0x41, 0x01, // ĲA (U+0132 U+0041)
  0x01, 0x32, 0x00, 0xC0, 0x01, // ĲÀ (U+0132 U+00C0)
  0x01, 0x32, 0x00, 0xC1, 0x01, // ĲÁ (U+0132 U+00C1)
  0x01, 0x32, 0x00, 0xC2, 0x01, // ĲÂ (U+0132 U+00C2)
  0x01, 0x32, 0x00, 0xC3, 0x01, // ĲÃ (U+0132 U+00C3)
  0x01, 0x32, 0x00, 0xC4, 0x01, // ĲÄ (U+0132 U+00C4)
  0x01, 0x32, 0x00, 0xC5, 0x01, // ĲÅ (U+0132 U+00C5)
  0x01, 0x32, 0x01, 0x00, 0x01, // ĲĀ (U+0132 U+0100)
  0x01, 0x32, 0x01, 0x02, 0x01, // ĲĂ (U+0132 U+0102)
  0x01, 0x32, 0x01, 0x04, 0x01, // ĲĄ (U+0132 U+0104)
  0x01, 0x32, 0x20, 0x1A, 0x01, // Ĳ‚ (U+0132 U+201A)
  0x01, 0x32, 0x20, 0x1E, 0x01, // Ĳ„ (U+0132 U+201E)
  0x01, 0x32, 0x20, 0x26, 0x01, // Ĳ… (U+0132 U+2026)
  0x01, 0x34, 0x00, 0x2C, 0x01, // Ĵ, (U+0134 U+002C)
  0x01, 0x34, 0x00, 0x2E, 0x01, // Ĵ. (U+0134 U+002E)
  0x01, 0x34, 0x00, 0x41, 0x01, // ĴA (U+0134 U+0041)
  0x01, 0x34, 0x00, 0xC0, 0x01, // ĴÀ (U+0134 U+00C0)
  0x01, 0x34, 0x00, 0xC1, 0x01, // ĴÁ (U+0134 U+00C1)
  0x01, 0x34, 0x00, 0xC2, 0x01, // ĴÂ (U+0134 U+00C2)
  0x01, 0x34, 0x00, 0xC3, 0x01, // ĴÃ (U+0134 U+00C3)
  0x01, 0x34, 0x00, 0xC4, 0x01, // ĴÄ (U+0134 U+00C4)
  0x01, 0x34, 0x00, 0xC5, 0x01, // ĴÅ (U+0134 U+00C5)
  0x01, 0x34, 0x01, 0x00, 0x01, // ĴĀ (U+0134 U+0100)
  0x01, 0x34, 0x01, 0x02, 0x01, // ĴĂ (U+0134 U+0102)
  0x01, 0x34, 0x01, 0x04, 0x01, // ĴĄ (U+0134 U+0104)
  0x01, 0x34, 0x20, 0x1A, 0x01, // Ĵ‚ (U+0134 U+201A)
  0x01, 0x34, 0x20, 0x1E, 0x01, // Ĵ„ (U+0134 U+201E)
  0x01, 0x34, 0x20, 0x26, 0x01, // Ĵ… (U+0134 U+2026)
  0x01, 0x36, 0x00, 0x26, 0x01, // Ķ& (U+0136 U+0026)
  0x01, 0x36, 0x00, 0x43, 0x01, // ĶC (U+0136 U+0043)
  0x01, 0x36, 0x00, 0x47, 0x01, // ĶG (U+0136 U+0047)
  0x01, 0x36, 0x00, 0x4F, 0x01, // ĶO (U+0136 U+004F)
  0x01, 0x36, 0x00, 0x51, 0x01, // ĶQ (U+0136 U+0051)
  0x01, 0x36, 0x00, 0x63, 0x01, // Ķc (U+0136 U+0063)
  0x01, 0x36, 0x00, 0x64, 0x01, // Ķd (U+0136 U+0064)
  0x01, 0x36, 0x00, 0x65, 0x01, // Ķe (U+0136 U+0065)
  0x01, 0x36, 0x00, 0x67, 0x01, // Ķg (U+0136 U+0067)
  0x01, 0x36, 0x00, 0x6F, 0x01, // Ķo (U+0136 U+006F)
  0x01, 0x36, 0x00, 0x71, 0x01, // Ķq (U+0136 U+0071)
  0x01, 0x36, 0x00, 0x75, 0x01, // Ķu (U+0136 U+0075)
  0x01, 0x36, 0x00, 0x76, 0x01, // Ķv (U+0136 U+0076)
  0x01, 0x36, 0x00, 0x77, 0x01, // Ķw (U+0136 U+0077)
  0x01, 0x36, 0x00, 0x79, 0x01, // Ķy (U+0136 U+0079)
  0x01, 0x36, 0x00, 0xC7, 0x01, // ĶÇ (U+0136 U+00C7)
  0x01, 0x36, 0x00, 0xD2, 0x01, // ĶÒ (U+0136 U+00D2)
  0x01, 0x36, 0x00, 0xD3, 0x01, // ĶÓ (U+0136 U+00D3)
  0x01, 0x36, 0x00, 0xD4, 0x01, // ĶÔ (U+0136 U+00D4)
  0x01, 0x36, 0x00, 0xD5, 0x01, // ĶÕ (U+0136 U+00D5)
  0x01, 0x36, 0x00, 0xD6, 0x01, // ĶÖ (U+0136 U+00D6)
  0x01, 0x36, 0x00, 0xD8, 0x01, // ĶØ (U+0136 U+00D8)
  0x01, 0x36, 0x00, 0xE7, 0x01, // Ķç (U+0136 U+00E7)
  0x01, 0x36, 0x00, 0xE8, 0x01, // Ķè (U+0136 U+00E8)
  0x01, 0x36, 0x00, 0xE9, 0x01, // Ķé (U+0136 U+00E9)
  0x01, 0x36, 0x00, 0xEA, 0x01, // Ķê (U+0136 U+00EA)
  0x01, 0x36, 0x00, 0xEB, 0x01, // Ķë (U+0136 U+00EB)
  0x01, 0x36, 0x00, 0xF0, 0x01, // Ķð (U+0136 U+00F0)
  0x01, 0x36, 0x00, 0xF2, 0x01, // Ķò (U+0136 U+00F2)
  0x01, 0x36, 0x00, 0xF3, 0x01, // Ķó (U+0136 U+00F3)
  0x01, 0x36, 0x00, 0xF4, 0x01, // Ķô (U+0136 U+00F4)
  0x01, 0x36, 0x00, 0xF5, 0x01, // Ķõ (U+0136 U+00F5)
  0x01, 0x36, 0x00, 0xF6, 0x01, // Ķö (U+0136 U+00F6)
  0x01, 0x36, 0x00, 0xF8, 0x01, // Ķø (U+0136 U+00F8)
  0x01, 0x36, 0x00, 0xF9, 0x01, // Ķù (U+0136 U+00F9)
  0x01, 0x36, 0x00, 0xFA, 0x01, // Ķú (U+0136 U+00FA)
  0x01, 0x36, 0x00, 0xFB, 0x01, // Ķû (U+0136 U+00FB)
  0x01, 0x36, 0x00, 0xFC, 0x01, // Ķü (U+0136 U+00FC)
  0x01, 0x36, 0x00, 0xFD, 0x01, // Ķý (U+0136 U+00FD)
  0x01, 0x36, 0x00, 0xFF, 0x01, // Ķÿ (U+0136 U+00FF)
  0x01, 0x36, 0x01, 0x06, 0x01, // ĶĆ (U+0136 U+0106)
  0x01, 0x36, 0x01, 0x07, 0x01, // Ķć (U+0136 U+0107)
  0x01, 0x36, 0x01, 0x08, 0x01, // ĶĈ (U+0136 U+0108)
  0x01, 0x36, 0x01, 0x09, 0x01, // Ķĉ (U+0136 U+0109)
  0x01, 0x36, 0x01, 0x0A, 0x01, // ĶĊ (U+0136 U+010A)
  0x01, 0x36, 0x01, 0x0B, 0x01, // Ķċ (U+0136 U+010B)
  0x01, 0x36, 0x01, 0x0C, 0x01, // ĶČ (U+0136 U+010C)
  0x01, 0x36, 0x01, 0x0D, 0x01, // Ķč (U+0136 U+010D)
  0x01, 0x36, 0x01, 0x0F, 0x01, // Ķď (U+0136 U+010F)
  0x01, 0x36, 0x01, 0x11, 0x01, // Ķđ (U+0136 U+0111)
  0x01, 0x36, 0x01, 0x13, 0x01, // Ķē (U+0136 U+0113)
  0x01, 0x36, 0x01, 0x15, 0x01, // Ķĕ (U+0136 U+0115)
  0x01, 0x36, 0x01, 0x17, 0x01, // Ķė (U+0136 U+0117)
  0x01, 0x36, 0x01, 0x19, 0x01, // Ķę (U+0136 U+0119)
  0x01, 0x36, 0x01, 0x1B, 0x01, // Ķě (U+0136 U+011B)
  0x01, 0x36, 0x01, 0x1C, 0x01, // ĶĜ (U+0136 U+011C)
  0x01, 0x36, 0x01, 0x1D, 0x01, // Ķĝ (U+0136 U+011D)
  0x01, 0x36, 0x01, 0x1E, 0x01, // ĶĞ (U+0136 U+011E)
  0x01, 0x36, 0x01, 0x1F, 0x01, // Ķğ (U+0136 U+011F)
  0x01, 0x36, 0x01, 0x20, 0x01, // ĶĠ (U+0136 U+0120)
  0x01, 0x36, 0x01, 0x21, 0x01, // Ķġ (U+0136 U+0121)
  0x01, 0x36, 0x01, 0x22, 0x01, // ĶĢ (U+0136 U+0122)
  0x01, 0x36, 0x01, 0x23, 0x01, // Ķģ (U+0136 U+0123)
  0x01, 0x36, 0x01, 0x4C, 0x01, // ĶŌ (U+0136 U+014C)
  0x01, 0x36, 0x01, 0x4D, 0x01, // Ķō (U+0136 U+014D)
  0x01, 0x36, 0x01, 0x4E, 0x01, // ĶŎ (U+0136 U+014E)
  0x01, 0x36, 0x01, 0x4F, 0x01, // Ķŏ (U+0136 U+014F)
  0x01, 0x36, 0x01, 0x50, 0x01, // ĶŐ (U+0136 U+0150)
  0x01, 0x36, 0x01, 0x51, 0x01, // Ķő (U+0136 U+0151)
  0x01, 0x36, 0x01, 0x52, 0x01, // ĶŒ (U+0136 U+0152)
  0x01, 0x36, 0x01, 0x53, 0x01, // Ķœ (U+0136 U+0153)
  0x01, 0x36, 0x01, 0x69, 0x01, // Ķũ (U+0136 U+0169)
  0x01, 0x36, 0x01, 0x6B, 0x01, // Ķū (U+0136 U+016B)
  0x01, 0x36, 0x01, 0x6D, 0x01, // Ķŭ (U+0136 U+016D)
  0x01, 0x36, 0x01, 0x6F, 0x01, // Ķů (U+0136 U+016F)
  0x01, 0x36, 0x01, 0x71, 0x01, // Ķű (U+0136 U+0171)
  0x01, 0x36, 0x01, 0x73, 0x01, // Ķų (U+0136 U+0173)
  0x01, 0x36, 0x01, 0x75, 0x01, // Ķŵ (U+0136 U+0175)
  0x01, 0x36, 0x01, 0x77, 0x01, // Ķŷ (U+0136 U+0177)
  0x01, 0x39, 0x00, 0x22, 0x02, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x02, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x03, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x03, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x55, 0x01, // ĹU (U+0139 U+0055)
  0x01, 0x39, 0x00, 0x56, 0x03, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x02, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x02, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0x76, 0x01, // Ĺv (U+0139 U+0076)
  0x01, 0x39, 0x00, 0x79, 0x01, // Ĺy (U+0139 U+0079)
  0x01, 0x39, 0x00, 0xD9, 0x01, // ĹÙ (U+0139 U+00D9)
  0x01, 0x39, 0x00, 0xDA, 0x01, // ĹÚ (U+0139 U+00DA)
  0x01, 0x39, 0x00, 0xDB, 0x01, // ĹÛ (U+0139 U+00DB)
  0x01, 0x39, 0x00, 0xDC, 0x01, // ĹÜ (U+0139 U+00DC)
  0x01, 0x39, 0x00, 0xDD, 0x02, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x00, 0xFD, 0x01, // Ĺý (U+0139 U+00FD)
  0x01, 0x39, 0x00, 0xFF, 0x01, // Ĺÿ (U+0139 U+00FF)
  0x01, 0x39, 0x01, 0x68, 0x01, // ĹŨ (U+0139 U+0168)
  0x01, 0x39, 0x01, 0x6A, 0x01, // ĹŪ (U+0139 U+016A)
  0x01, 0x39, 0x01, 0x6C, 0x01, // ĹŬ (U+0139 U+016C)
  0x01, 0x39, 0x01, 0x6E, 0x01, // ĹŮ (U+0139 U+016E)
  0x01, 0x39, 0x01, 0x70, 0x01, // ĹŰ (U+0139 U+0170)
  0x01, 0x39, 0x01, 0x72, 0x01, // ĹŲ (U+0139 U+0172)
  0x01, 0x39, 0x01, 0x74, 0x02, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x02, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x77, 0x01, // Ĺŷ (U+0139 U+0177)
  0x01, 0x39, 0x01, 0x78, 0x02, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x04, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x03, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x04, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x03, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x03, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x02, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x02, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x03, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x03, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x55, 0x01, // ĻU (U+013B U+0055)
  0x01, 0x3B, 0x00, 0x56, 0x03, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x02, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x02, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0x76, 0x01, // Ļv (U+013B U+0076)
  0x01, 0x3B, 0x00, 0x79, 0x01, // Ļy (U+013B U+0079)
  0x01, 0x3B, 0x00, 0xD9, 0x01, // ĻÙ (U+013B U+00D9)
  0x01, 0x3B, 0x00, 0xDA, 0x01, // ĻÚ (U+013B U+00DA)
  0x01, 0x3B, 0x00, 0xDB, 0x01, // ĻÛ (U+013B U+00DB)
  0x01, 0x3B, 0x00, 0xDC, 0x01, // ĻÜ (U+013B U+00DC)
  0x01, 0x3B, 0x00, 0xDD, 0x02, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x00, 0xFD, 0x01, // Ļý (U+013B U+00FD)
  0x01, 0x3B, 0x00, 0xFF, 0x01, // Ļÿ (U+013B U+00FF)
  0x01, 0x3B, 0x01, 0x68, 0x01, // ĻŨ (U+013B U+0168)
  0x01, 0x3B, 0x01, 0x6A, 0x01, // ĻŪ (U+013B U+016A)
  0x01, 0x3B, 0x01, 0x6C, 0x01, // ĻŬ (U+013B U+016C)
  0x01, 0x3B, 0x01, 0x6E, 0x01, // ĻŮ (U+013B U+016E)
  0x01, 0x3B, 0x01, 0x70, 0x01, // ĻŰ (U+013B U+0170)
  0x01, 0x3B, 0x01, 0x72, 0x01, // ĻŲ (U+013B U+0172)
  0x01, 0x3B, 0x01, 0x74, 0x02, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x02, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x77, 0x01, // Ļŷ (U+013B U+0177)
  0x01, 0x3B, 0x01, 0x78, 0x02, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x04, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x03, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x04, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x03, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x03, // Ļ™ (U+013B U+2122)
  0x01, 0x3D, 0x00, 0x2A, 0x01, // Ľ* (U+013D U+002A)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x02, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x21, 0x22, 0x01, // Ľ™ (U+013D U+2122)
  0x01, 0x41, 0x00, 0x22, 0x02, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x02, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x03, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x03, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x55, 0x01, // ŁU (U+0141 U+0055)
  0x01, 0x41, 0x00, 0x56, 0x03, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x02, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x02, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0x76, 0x01, // Łv (U+0141 U+0076)
  0x01, 0x41, 0x00, 0x79, 0x01, // Ły (U+0141 U+0079)
  0x01, 0x41, 0x00, 0xD9, 0x01, // ŁÙ (U+0141 U+00D9)
  0x01, 0x41, 0x00, 0xDA, 0x01, // ŁÚ (U+0141 U+00DA)
  0x01, 0x41, 0x00, 0xDB, 0x01, // ŁÛ (U+0141 U+00DB)
  0x01, 0x41, 0x00, 0xDC, 0x01, // ŁÜ (U+0141 U+00DC)
  0x01, 0x41, 0x00, 0xDD, 0x02, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x00, 0xFD, 0x01, // Łý (U+0141 U+00FD)
  0x01, 0x41, 0x00, 0xFF, 0x01, // Łÿ (U+0141 U+00FF)
  0x01, 0x41, 0x01, 0x68, 0x01, // ŁŨ (U+0141 U+0168)
  0x01, 0x41, 0x01, 0x6A, 0x01, // ŁŪ (U+0141 U+016A)
  0x01, 0x41, 0x01, 0x6C, 0x01, // ŁŬ (U+0141 U+016C)
  0x01, 0x41, 0x01, 0x6E, 0x01, // ŁŮ (U+0141 U+016E)
  0x01, 0x41, 0x01, 0x70, 0x01, // ŁŰ (U+0141 U+0170)
  0x01, 0x41, 0x01, 0x72, 0x01, // ŁŲ (U+0141 U+0172)
  0x01, 0x41, 0x01, 0x74, 0x02, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x02, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x77, 0x01, // Łŷ (U+0141 U+0177)
  0x01, 0x41, 0x01, 0x78, 0x02, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x04, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x03, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x04, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x03, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x03, // Ł™ (U+0141 U+2122)
  0x01, 0x43, 0x00, 0x26, 0x01, // Ń& (U+0143 U+0026)
  0x01, 0x43, 0x00, 0x2C, 0x01, // Ń, (U+0143 U+002C)
  0x01, 0x43, 0x00, 0x2E, 0x01, // Ń. (U+0143 U+002E)
  0x01, 0x43, 0x20, 0x1A, 0x01, // Ń‚ (U+0143 U+201A)
  0x01, 0x43, 0x20, 0x1E, 0x01, // Ń„ (U+0143 U+201E)
  0x01, 0x43, 0x20, 0x26, 0x01, // Ń… (U+0143 U+2026)
  0x01, 0x44, 0x00, 0x22, 0x02, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x02, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x00, 0x2A, 0x01, // ń* (U+0144 U+002A)
  0x01, 0x44, 0x00, 0x54, 0x01, // ńT (U+0144 U+0054)
  0x01, 0x44, 0x00, 0x56, 0x02, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x57, 0x02, // ńW (U+0144 U+0057)
  0x01, 0x44, 0x00, 0x59, 0x02, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0xDD, 0x02, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x01, 0x74, 0x02, // ńŴ (U+0144 U+0174)
  0x01, 0x44, 0x01, 0x76, 0x02, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x78, 0x02, // ńŸ (U+0144 U+0178)
  0x01, 0x44, 0x20, 0x18, 0x01, // ń‘ (U+0144 U+2018)
  0x01, 0x44, 0x20, 0x19, 0x01, // ń’ (U+0144 U+2019)
  0x01, 0x44, 0x20, 0x1C, 0x01, // ń“ (U+0144 U+201C)
  0x01, 0x44, 0x20, 0x1D, 0x01, // ń” (U+0144 U+201D)
  0x01, 0x44, 0x21, 0x22, 0x01, // ń™ (U+0144 U+2122)
  0x01, 0x45, 0x00, 0x26, 0x01, // Ņ& (U+0145 U+0026)
  0x01, 0x45, 0x00, 0x2C, 0x01, // Ņ, (U+0145 U+002C)
  0x01, 0x45, 0x00, 0x2E, 0x01, // Ņ. (U+0145 U+002E)
  0x01, 0x45, 0x20, 0x1A, 0x01, // Ņ‚ (U+0145 U+201A)
  0x01, 0x45, 0x20, 0x1E, 0x01, // Ņ„ (U+0145 U+201E)
  0x01, 0x45, 0x20, 0x26, 0x01, // Ņ… (U+0145 U+2026)
  0x01, 0x46, 0x00, 0x22, 0x02, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x02, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x00, 0x2A, 0x01, // ņ* (U+0146 U+002A)
  0x01, 0x46, 0x00, 0x54, 0x01, // ņT (U+0146 U+0054)
  0x01, 0x46, 0x00, 0x56, 0x02, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x57, 0x02, // ņW (U+0146 U+0057)
  0x01, 0x46, 0x00, 0x59, 0x02, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0xDD, 0x02, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x01, 0x74, 0x02, // ņŴ (U+0146 U+0174)
  0x01, 0x46, 0x01, 0x76, 0x02, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x78, 0x02, // ņŸ (U+0146 U+0178)
  0x01, 0x46, 0x20, 0x18, 0x01, // ņ‘ (U+0146 U+2018)
  0x01, 0x46, 0x20, 0x19, 0x01, // ņ’ (U+0146 U+2019)
  0x01, 0x46, 0x20, 0x1C, 0x01, // ņ“ (U+0146 U+201C)
  0x01, 0x46, 0x20, 0x1D, 0x01, // ņ” (U+0146 U+201D)
  0x01, 0x46, 0x21, 0x22, 0x01, // ņ™ (U+0146 U+2122)
  0x01, 0x47, 0x00, 0x26, 0x01, // Ň& (U+0147 U+0026)
  0x01, 0x47, 0x00, 0x2C, 0x01, // Ň, (U+0147 U+002C)
  0x01, 0x47, 0x00, 0x2E, 0x01, // Ň. (U+0147 U+002E)
  0x01, 0x47, 0x20, 0x1A, 0x01, // Ň‚ (U+0147 U+201A)
  0x01, 0x47, 0x20, 0x1E, 0x01, // Ň„ (U+0147 U+201E)
  0x01, 0x47, 0x20, 0x26, 0x01, // Ň… (U+0147 U+2026)
  0x01, 0x48, 0x00, 0x22, 0x02, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x02, // ň' (U+0148 U+0027)
  0x01, 0x48, 0x00, 0x2A, 0x01, // ň* (U+0148 U+002A)
  0x01, 0x48, 0x00, 0x54, 0x01, // ňT (U+0148 U+0054)
  0x01, 0x48, 0x00, 0x56, 0x02, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x57, 0x02, // ňW (U+0148 U+0057)
  0x01, 0x48, 0x00, 0x59, 0x02, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0xDD, 0x02, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x01, 0x74, 0x02, // ňŴ (U+0148 U+0174)
  0x01, 0x48, 0x01, 0x76, 0x02, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x78, 0x02, // ňŸ (U+0148 U+0178)
  0x01, 0x48, 0x20, 0x18, 0x01, // ň‘ (U+0148 U+2018)
  0x01, 0x48, 0x20, 0x19, 0x01, // ň’ (U+0148 U+2019)
  0x01, 0x48, 0x20, 0x1C, 0x01, // ň“ (U+0148 U+201C)
  0x01, 0x48, 0x20, 0x1D, 0x01, // ň” (U+0148 U+201D)
  0x01, 0x48, 0x21, 0x22, 0x01, // ň™ (U+0148 U+2122)
  0x01, 0x49, 0x00, 0x22, 0x02, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x02, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x00, 0x2A, 0x01, // ŉ* (U+0149 U+002A)
  0x01, 0x49, 0x00, 0x54, 0x01, // ŉT (U+0149 U+0054)
  0x01, 0x49, 0x00, 0x56, 0x02, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x57, 0x02, // ŉW (U+0149 U+0057)
  0x01, 0x49, 0x00, 0x59, 0x02, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0xDD, 0x02, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x01, 0x74, 0x02, // ŉŴ (U+0149 U+0174)
  0x01, 0x49, 0x01, 0x76, 0x02, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x78, 0x02, // ŉŸ (U+0149 U+0178)
  0x01, 0x49, 0x20, 0x18, 0x01, // ŉ‘ (U+0149 U+2018)
  0x01, 0x49, 0x20, 0x19, 0x01, // ŉ’ (U+0149 U+2019)
  0x01, 0x49, 0x20, 0x1C, 0x01, // ŉ“ (U+0149 U+201C)
  0x01, 0x49, 0x20, 0x1D, 0x01, // ŉ” (U+0149 U+201D)
  0x01, 0x49, 0x21, 0x22, 0x01, // ŉ™ (U+0149 U+2122)
  0x01, 0x4A, 0x00, 0x2C, 0x01, // Ŋ, (U+014A U+002C)
  0x01, 0x4A, 0x00, 0x2E, 0x01, // Ŋ. (U+014A U+002E)
  0x01, 0x4A, 0x00, 0x41, 0x01, // ŊA (U+014A U+0041)
  0x01, 0x4A, 0x00, 0xC0, 0x01, // ŊÀ (U+014A U+00C0)
  0x01, 0x4A, 0x00, 0xC1, 0x01, // ŊÁ (U+014A U+00C1)
  0x01, 0x4A, 0x00, 0xC2, 0x01, // ŊÂ (U+014A U+00C2)
  0x01, 0x4A, 0x00, 0xC3, 0x01, // ŊÃ (U+014A U+00C3)
  0x01, 0x4A, 0x00, 0xC4, 0x01, // ŊÄ (U+014A U+00C4)
  0x01, 0x4A, 0x00, 0xC5, 0x01, // ŊÅ (U+014A U+00C5)
  0x01, 0x4A, 0x01, 0x00, 0x01, // ŊĀ (U+014A U+0100)
  0x01, 0x4A, 0x01, 0x02, 0x01, // ŊĂ (U+014A U+0102)
  0x01, 0x4A, 0x01, 0x04, 0x01, // ŊĄ (U+014A U+0104)
  0x01, 0x4A, 0x20, 0x1A, 0x01, // Ŋ‚ (U+014A U+201A)
  0x01, 0x4A, 0x20, 0x1E, 0x01, // Ŋ„ (U+014A U+201E)
  0x01, 0x4A, 0x20, 0x26, 0x01, // Ŋ… (U+014A U+2026)
  0x01, 0x4B, 0x00, 0x22, 0x02, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x02, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x00, 0x2A, 0x01, // ŋ* (U+014B U+002A)
  0x01, 0x4B, 0x00, 0x54, 0x01, // ŋT (U+014B U+0054)
  0x01, 0x4B, 0x00, 0x56, 0x02, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x57, 0x02, // ŋW (U+014B U+0057)
  0x01, 0x4B, 0x00, 0x59, 0x02, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0xDD, 0x02, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x01, 0x74, 0x02, // ŋŴ (U+014B U+0174)
  0x01, 0x4B, 0x01, 0x76, 0x02, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x78, 0x02, // ŋŸ (U+014B U+0178)
  0x01, 0x4B, 0x20, 0x18, 0x01, // ŋ‘ (U+014B U+2018)
  0x01, 0x4B, 0x20, 0x19, 0x01, // ŋ’ (U+014B U+2019)
  0x01, 0x4B, 0x20, 0x1C, 0x01, // ŋ“ (U+014B U+201C)
  0x01, 0x4B, 0x20, 0x1D, 0x01, // ŋ” (U+014B U+201D)
  0x01, 0x4B, 0x21, 0x22, 0x01, // ŋ™ (U+014B U+2122)
  0x01, 0x4C, 0x00, 0x22, 0x01, // Ō" (U+014C U+0022)
  0x01, 0x4C, 0x00, 0x27, 0x01, // Ō' (U+014C U+0027)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x41, 0x01, // ŌA (U+014C U+0041)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x00, 0x56, 0x01, // ŌV (U+014C U+0056)
  0x01, 0x4C, 0x00, 0x57, 0x01, // ŌW (U+014C U+0057)
  0x01, 0x4C, 0x00, 0x58, 0x01, // ŌX (U+014C U+0058)
  0x01, 0x4C, 0x00, 0x59, 0x01, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0xC0, 0x01, // ŌÀ (U+014C U+00C0)
  0x01, 0x4C, 0x00, 0xC1, 0x01, // ŌÁ (U+014C U+00C1)
  0x01, 0x4C, 0x00, 0xC2, 0x01, // ŌÂ (U+014C U+00C2)
  0x01, 0x4C, 0x00, 0xC3, 0x01, // ŌÃ (U+014C U+00C3)
  0x01, 0x4C, 0x00, 0xC4, 0x01, // ŌÄ (U+014C U+00C4)
  0x01, 0x4C, 0x00, 0xC5, 0x01, // ŌÅ (U+014C U+00C5)
  0x01, 0x4C, 0x00, 0xC6, 0x02, // ŌÆ (U+014C U+00C6)
  0x01, 0x4C, 0x00, 0xDD, 0x01, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x00, 0x01, // ŌĀ (U+014C U+0100)
  0x01, 0x4C, 0x01, 0x02, 0x01, // ŌĂ (U+014C U+0102)
  0x01, 0x4C, 0x01, 0x04, 0x01, // ŌĄ (U+014C U+0104)
  0x01, 0x4C, 0x01, 0x74, 0x01, // ŌŴ (U+014C U+0174)
  0x01, 0x4C, 0x01, 0x76, 0x01, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x01, // ŌŸ (U+014C U+0178)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4D, 0x00, 0x54, 0x01, // ōT (U+014D U+0054)
  0x01, 0x4D, 0x00, 0x56, 0x02, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x02, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x03, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0x78, 0x01, // ōx (U+014D U+0078)
  0x01, 0x4D, 0x00, 0x79, 0x01, // ōy (U+014D U+0079)
  0x01, 0x4D, 0x00, 0xDD, 0x03, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x00, 0xFD, 0x01, // ōý (U+014D U+00FD)
  0x01, 0x4D, 0x00, 0xFF, 0x01, // ōÿ (U+014D U+00FF)
  0x01, 0x4D, 0x01, 0x74, 0x02, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x03, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x77, 0x01, // ōŷ (U+014D U+0177)
  0x01, 0x4D, 0x01, 0x78, 0x03, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0x22, 0x01, // Ŏ" (U+014E U+0022)
  0x01, 0x4E, 0x00, 0x27, 0x01, // Ŏ' (U+014E U+0027)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x41, 0x01, // ŎA (U+014E U+0041)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x00, 0x56, 0x01, // ŎV (U+014E U+0056)
  0x01, 0x4E, 0x00, 0x57, 0x01, // ŎW (U+014E U+0057)
  0x01, 0x4E, 0x00, 0x58, 0x01, // ŎX (U+014E U+0058)
  0x01, 0x4E, 0x00, 0x59, 0x01, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0xC0, 0x01, // ŎÀ (U+014E U+00C0)
  0x01, 0x4E, 0x00, 0xC1, 0x01, // ŎÁ (U+014E U+00C1)
  0x01, 0x4E, 0x00, 0xC2, 0x01, // ŎÂ (U+014E U+00C2)
  0x01, 0x4E, 0x00, 0xC3, 0x01, // ŎÃ (U+014E U+00C3)
  0x01, 0x4E, 0x00, 0xC4, 0x01, // ŎÄ (U+014E U+00C4)
  0x01, 0x4E, 0x00, 0xC5, 0x01, // ŎÅ (U+014E U+00C5)
  0x01, 0x4E, 0x00, 0xC6, 0x02, // ŎÆ (U+014E U+00C6)
  0x01, 0x4E, 0x00, 0xDD, 0x01, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x00, 0x01, // ŎĀ (U+014E U+0100)
  0x01, 0x4E, 0x01, 0x02, 0x01, // ŎĂ (U+014E U+0102)
  0x01, 0x4E, 0x01, 0x04, 0x01, // ŎĄ (U+014E U+0104)
  0x01, 0x4E, 0x01, 0x74, 0x01, // ŎŴ (U+014E U+0174)
  0x01, 0x4E, 0x01, 0x76, 0x01, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x01, // ŎŸ (U+014E U+0178)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x4F, 0x00, 0x54, 0x01, // ŏT (U+014F U+0054)
  0x01, 0x4F, 0x00, 0x56, 0x02, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x02, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x03, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0x78, 0x01, // ŏx (U+014F U+0078)
  0x01, 0x4F, 0x00, 0x79, 0x01, // ŏy (U+014F U+0079)
  0x01, 0x4F, 0x00, 0xDD, 0x03, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x00, 0xFD, 0x01, // ŏý (U+014F U+00FD)
  0x01, 0x4F, 0x00, 0xFF, 0x01, // ŏÿ (U+014F U+00FF)
  0x01, 0x4F, 0x01, 0x74, 0x02, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x03, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x77, 0x01, // ŏŷ (U+014F U+0177)
  0x01, 0x4F, 0x01, 0x78, 0x03, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0x22, 0x01, // Ő" (U+0150 U+0022)
  0x01, 0x50, 0x00, 0x27, 0x01, // Ő' (U+0150 U+0027)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x41, 0x01, // ŐA (U+0150 U+0041)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x00, 0x56, 0x01, // ŐV (U+0150 U+0056)
  0x01, 0x50, 0x00, 0x57, 0x01, // ŐW (U+0150 U+0057)
  0x01, 0x50, 0x00, 0x58, 0x01, // ŐX (U+0150 U+0058)
  0x01, 0x50, 0x00, 0x59, 0x01, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0xC0, 0x01, // ŐÀ (U+0150 U+00C0)
  0x01, 0x50, 0x00, 0xC1, 0x01, // ŐÁ (U+0150 U+00C1)
  0x01, 0x50, 0x00, 0xC2, 0x01, // ŐÂ (U+0150 U+00C2)
  0x01, 0x50, 0x00, 0xC3, 0x01, // ŐÃ (U+0150 U+00C3)
  0x01, 0x50, 0x00, 0xC4, 0x01, // ŐÄ (U+0150 U+00C4)
  0x01, 0x50, 0x00, 0xC5, 0x01, // ŐÅ (U+0150 U+00C5)
  0x01, 0x50, 0x00, 0xC6, 0x02, // ŐÆ (U+0150 U+00C6)
  0x01, 0x50, 0x00, 0xDD, 0x01, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x00, 0x01, // ŐĀ (U+0150 U+0100)
  0x01, 0x50, 0x01, 0x02, 0x01, // ŐĂ (U+0150 U+0102)
  0x01, 0x50, 0x01, 0x04, 0x01, // ŐĄ (U+0150 U+0104)
  0x01, 0x50, 0x01, 0x74, 0x01, // ŐŴ (U+0150 U+0174)
  0x01, 0x50, 0x01, 0x76, 0x01, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x01, // ŐŸ (U+0150 U+0178)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x51, 0x00, 0x54, 0x01, // őT (U+0151 U+0054)
  0x01, 0x51, 0x00, 0x56, 0x02, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x02, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x03, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0x78, 0x01, // őx (U+0151 U+0078)
  0x01, 0x51, 0x00, 0x79, 0x01, // őy (U+0151 U+0079)
  0x01, 0x51, 0x00, 0xDD, 0x03, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x00, 0xFD, 0x01, // őý (U+0151 U+00FD)
  0x01, 0x51, 0x00, 0xFF, 0x01, // őÿ (U+0151 U+00FF)
  0x01, 0x51, 0x01, 0x74, 0x02, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x03, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x77, 0x01, // őŷ (U+0151 U+0177)
  0x01, 0x51, 0x01, 0x78, 0x03, // őŸ (U+0151 U+0178)
  0x01, 0x52, 0x00, 0x56, 0x01, // ŒV (U+0152 U+0056)
  0x01, 0x52, 0x00, 0x57, 0x01, // ŒW (U+0152 U+0057)
  0x01, 0x52, 0x00, 0x59, 0x01, // ŒY (U+0152 U+0059)
  0x01, 0x52, 0x00, 0xDD, 0x01, // ŒÝ (U+0152 U+00DD)
  0x01, 0x52, 0x01, 0x74, 0x01, // ŒŴ (U+0152 U+0174)
  0x01, 0x52, 0x01, 0x76, 0x01, // ŒŶ (U+0152 U+0176)
  0x01, 0x52, 0x01, 0x78, 0x01, // ŒŸ (U+0152 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x02, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x02, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x02, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x02, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x02, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x02, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x02, // œŸ (U+0153 U+0178)
  0x01, 0x54, 0x00, 0x26, 0x01, // Ŕ& (U+0154 U+0026)
  0x01, 0x54, 0x00, 0x2A, 0x01, // Ŕ* (U+0154 U+002A)
  0x01, 0x54, 0x00, 0x54, 0x01, // ŔT (U+0154 U+0054)
  0x01, 0x54, 0x00, 0x56, 0x01, // ŔV (U+0154 U+0056)
  0x01, 0x54, 0x00, 0x57, 0x01, // ŔW (U+0154 U+0057)
  0x01, 0x54, 0x00, 0x59, 0x01, // ŔY (U+0154 U+0059)
  0x01, 0x54, 0x00, 0x77, 0x01, // Ŕw (U+0154 U+0077)
  0x01, 0x54, 0x00, 0x79, 0x01, // Ŕy (U+0154 U+0079)
  0x01, 0x54, 0x00, 0xDD, 0x01, // ŔÝ (U+0154 U+00DD)
  0x01, 0x54, 0x00, 0xFD, 0x01, // Ŕý (U+0154 U+00FD)
  0x01, 0x54, 0x00, 0xFF, 0x01, // Ŕÿ (U+0154 U+00FF)
  0x01, 0x54, 0x01, 0x74, 0x01, // ŔŴ (U+0154 U+0174)
  0x01, 0x54, 0x01, 0x75, 0x01, // Ŕŵ (U+0154 U+0175)
  0x01, 0x54, 0x01, 0x76, 0x01, // ŔŶ (U+0154 U+0176)
  0x01, 0x54, 0x01, 0x77, 0x01, // Ŕŷ (U+0154 U+0177)
  0x01, 0x54, 0x01, 0x78, 0x01, // ŔŸ (U+0154 U+0178)
  0x01, 0x54, 0x20, 0x19, 0x01, // Ŕ’ (U+0154 U+2019)
  0x01, 0x54, 0x20, 0x1D, 0x01, // Ŕ” (U+0154 U+201D)
  0x01, 0x54, 0x21, 0x22, 0x01, // Ŕ™ (U+0154 U+2122)
  0x01, 0x55, 0x00, 0x2C, 0x06, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x06, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x56, 0x01, // ŕV (U+0155 U+0056)
  0x01, 0x55, 0x00, 0x57, 0x02, // ŕW (U+0155 U+0057)
  0x01, 0x55, 0x00, 0x58, 0x02, // ŕX (U+0155 U+0058)
  0x01, 0x55, 0x00, 0x59, 0x01, // ŕY (U+0155 U+0059)
  0x01, 0x55, 0x00, 0x61, 0x01, // ŕa (U+0155 U+0061)
  0x01, 0x55, 0x00, 0x63, 0x01, // ŕc (U+0155 U+0063)
  0x01, 0x55, 0x00, 0x64, 0x01, // ŕd (U+0155 U+0064)
  0x01, 0x55, 0x00, 0x65, 0x01, // ŕe (U+0155 U+0065)
  0x01, 0x55, 0x00, 0x67, 0x01, // ŕg (U+0155 U+0067)
  0x01, 0x55, 0x00, 0x6F, 0x01, // ŕo (U+0155 U+006F)
  0x01, 0x55, 0x00, 0x71, 0x01, // ŕq (U+0155 U+0071)
  0x01, 0x55, 0x00, 0xDD, 0x01, // ŕÝ (U+0155 U+00DD)
  0x01, 0x55, 0x00, 0xE0, 0x01, // ŕà (U+0155 U+00E0)
  0x01, 0x55, 0x00, 0xE1, 0x01, // ŕá (U+0155 U+00E1)
  0x01, 0x55, 0x00, 0xE2, 0x01, // ŕâ (U+0155 U+00E2)
  0x01, 0x55, 0x00, 0xE3, 0x01, // ŕã (U+0155 U+00E3)
  0x01, 0x55, 0x00, 0xE4, 0x01, // ŕä (U+0155 U+00E4)
  0x01, 0x55, 0x00, 0xE5, 0x01, // ŕå (U+0155 U+00E5)
  0x01, 0x55, 0x00, 0xE6, 0x01, // ŕæ (U+0155 U+00E6)
  0x01, 0x55, 0x00, 0xE7, 0x01, // ŕç (U+0155 U+00E7)
  0x01, 0x55, 0x00, 0xE8, 0x01, // ŕè (U+0155 U+00E8)
  0x01, 0x55, 0x00, 0xE9, 0x01, // ŕé (U+0155 U+00E9)
  0x01, 0x55, 0x00, 0xEA, 0x01, // ŕê (U+0155 U+00EA)
  0x01, 0x55, 0x00, 0xEB, 0x01, // ŕë (U+0155 U+00EB)
  0x01, 0x55, 0x00, 0xF0, 0x01, // ŕð (U+0155 U+00F0)
  0x01, 0x55, 0x00, 0xF2, 0x01, // ŕò (U+0155 U+00F2)
  0x01, 0x55, 0x00, 0xF3, 0x01, // ŕó (U+0155 U+00F3)
  0x01, 0x55, 0x00, 0xF4, 0x01, // ŕô (U+0155 U+00F4)
  0x01, 0x55, 0x00, 0xF5, 0x01, // ŕõ (U+0155 U+00F5)
  0x01, 0x55, 0x00, 0xF6, 0x01, // ŕö (U+0155 U+00F6)
  0x01, 0x55, 0x00, 0xF8, 0x01, // ŕø (U+0155 U+00F8)
  0x01, 0x55, 0x01, 0x01, 0x01, // ŕā (U+0155 U+0101)
  0x01, 0x55, 0x01, 0x03, 0x01, // ŕă (U+0155 U+0103)
  0x01, 0x55, 0x01, 0x05, 0x01, // ŕą (U+0155 U+0105)
  0x01, 0x55, 0x01, 0x07, 0x01, // ŕć (U+0155 U+0107)
  0x01, 0x55, 0x01, 0x09, 0x01, // ŕĉ (U+0155 U+0109)
  0x01, 0x55, 0x01, 0x0B, 0x01, // ŕċ (U+0155 U+010B)
  0x01, 0x55, 0x01, 0x0D, 0x01, // ŕč (U+0155 U+010D)
  0x01, 0x55, 0x01, 0x0F, 0x01, // ŕď (U+0155 U+010F)
  0x01, 0x55, 0x01, 0x11, 0x01, // ŕđ (U+0155 U+0111)
  0x01, 0x55, 0x01, 0x13, 0x01, // ŕē (U+0155 U+0113)
  0x01, 0x55, 0x01, 0x15, 0x01, // ŕĕ (U+0155 U+0115)
  0x01, 0x55, 0x01, 0x17, 0x01, // ŕė (U+0155 U+0117)
  0x01, 0x55, 0x01, 0x19, 0x01, // ŕę (U+0155 U+0119)
  0x01, 0x55, 0x01, 0x1B, 0x01, // ŕě (U+0155 U+011B)
  0x01, 0x55, 0x01, 0x1D, 0x01, // ŕĝ (U+0155 U+011D)
  0x01, 0x55, 0x01, 0x1F, 0x01, // ŕğ (U+0155 U+011F)
  0x01, 0x55, 0x01, 0x21, 0x01, // ŕġ (U+0155 U+0121)
  0x01, 0x55, 0x01, 0x23, 0x01, // ŕģ (U+0155 U+0123)
  0x01, 0x55, 0x01, 0x4D, 0x01, // ŕō (U+0155 U+014D)
  0x01, 0x55, 0x01, 0x4F, 0x01, // ŕŏ (U+0155 U+014F)
  0x01, 0x55, 0x01, 0x51, 0x01, // ŕő (U+0155 U+0151)
  0x01, 0x55, 0x01, 0x53, 0x01, // ŕœ (U+0155 U+0153)
  0x01, 0x55, 0x01, 0x74, 0x02, // ŕŴ (U+0155 U+0174)
  0x01, 0x55, 0x01, 0x76, 0x01, // ŕŶ (U+0155 U+0176)
  0x01, 0x55, 0x01, 0x78, 0x01, // ŕŸ (U+0155 U+0178)
  0x01, 0x55, 0x20, 0x1A, 0x06, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x06, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x06, // ŕ… (U+0155 U+2026)
  0x01, 0x56, 0x00, 0x26, 0x01, // Ŗ& (U+0156 U+0026)
  0x01, 0x56, 0x00, 0x2A, 0x01, // Ŗ* (U+0156 U+002A)
  0x01, 0x56, 0x00, 0x54, 0x01, // ŖT (U+0156 U+0054)
  0x01, 0x56, 0x00, 0x56, 0x01, // ŖV (U+0156 U+0056)
  0x01, 0x56, 0x00, 0x57, 0x01, // ŖW (U+0156 U+0057)
  0x01, 0x56, 0x00, 0x59, 0x01, // ŖY (U+0156 U+0059)
  0x01, 0x56, 0x00, 0x77, 0x01, // Ŗw (U+0156 U+0077)
  0x01, 0x56, 0x00, 0x79, 0x01, // Ŗy (U+0156 U+0079)
  0x01, 0x56, 0x00, 0xDD, 0x01, // ŖÝ (U+0156 U+00DD)
  0x01, 0x56, 0x00, 0xFD, 0x01, // Ŗý (U+0156 U+00FD)
  0x01, 0x56, 0x00, 0xFF, 0x01, // Ŗÿ (U+0156 U+00FF)
  0x01, 0x56, 0x01, 0x74, 0x01, // ŖŴ (U+0156 U+0174)
  0x01, 0x56, 0x01, 0x75, 0x01, // Ŗŵ (U+0156 U+0175)
  0x01, 0x56, 0x01, 0x76, 0x01, // ŖŶ (U+0156 U+0176)
  0x01, 0x56, 0x01, 0x77, 0x01, // Ŗŷ (U+0156 U+0177)
  0x01, 0x56, 0x01, 0x78, 0x01, // ŖŸ (U+0156 U+0178)
  0x01, 0x56, 0x20, 0x19, 0x01, // Ŗ’ (U+0156 U+2019)
  0x01, 0x56, 0x20, 0x1D, 0x01, // Ŗ” (U+0156 U+201D)
  0x01, 0x56, 0x21, 0x22, 0x01, // Ŗ™ (U+0156 U+2122)
  0x01, 0x57, 0x00, 0x2C, 0x06, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x06, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x56, 0x01, // ŗV (U+0157 U+0056)
  0x01, 0x57, 0x00, 0x57, 0x02, // ŗW (U+0157 U+0057)
  0x01, 0x57, 0x00, 0x58, 0x02, // ŗX (U+0157 U+0058)
  0x01, 0x57, 0x00, 0x59, 0x01, // ŗY (U+0157 U+0059)
  0x01, 0x57, 0x00, 0x61, 0x01, // ŗa (U+0157 U+0061)
  0x01, 0x57, 0x00, 0x63, 0x01, // ŗc (U+0157 U+0063)
  0x01, 0x57, 0x00, 0x64, 0x01, // ŗd (U+0157 U+0064)
  0x01, 0x57, 0x00, 0x65, 0x01, // ŗe (U+0157 U+0065)
  0x01, 0x57, 0x00, 0x67, 0x01, // ŗg (U+0157 U+0067)
  0x01, 0x57, 0x00, 0x6F, 0x01, // ŗo (U+0157 U+006F)
  0x01, 0x57, 0x00, 0x71, 0x01, // ŗq (U+0157 U+0071)
  0x01, 0x57, 0x00, 0xDD, 0x01, // ŗÝ (U+0157 U+00DD)
  0x01, 0x57, 0x00, 0xE0, 0x01, // ŗà (U+0157 U+00E0)
  0x01, 0x57, 0x00, 0xE1, 0x01, // ŗá (U+0157 U+00E1)
  0x01, 0x57, 0x00, 0xE2, 0x01, // ŗâ (U+0157 U+00E2)
  0x01, 0x57, 0x00, 0xE3, 0x01, // ŗã (U+0157 U+00E3)
  0x01, 0x57, 0x00, 0xE4, 0x01, // ŗä (U+0157 U+00E4)
  0x01, 0x57, 0x00, 0xE5, 0x01, // ŗå (U+0157 U+00E5)
  0x01, 0x57, 0x00, 0xE6, 0x01, // ŗæ (U+0157 U+00E6)
  0x01, 0x57, 0x00, 0xE7, 0x01, // ŗç (U+0157 U+00E7)
  0x01, 0x57, 0x00, 0xE8, 0x01, // ŗè (U+0157 U+00E8)
  0x01, 0x57, 0x00, 0xE9, 0x01, // ŗé (U+0157 U+00E9)
  0x01, 0x57, 0x00, 0xEA, 0x01, // ŗê (U+0157 U+00EA)
  0x01, 0x57, 0x00, 0xEB, 0x01, // ŗë (U+0157 U+00EB)
  0x01, 0x57, 0x00, 0xF0, 0x01, // ŗð (U+0157 U+00F0)
  0x01, 0x57, 0x00, 0xF2, 0x01, // ŗò (U+0157 U+00F2)
  0x01, 0x57, 0x00, 0xF3, 0x01, // ŗó (U+0157 U+00F3)
  0x01, 0x57, 0x00, 0xF4, 0x01, // ŗô (U+0157 U+00F4)
  0x01, 0x57, 0x00, 0xF5, 0x01, // ŗõ (U+0157 U+00F5)
  0x01, 0x57, 0x00, 0xF6, 0x01, // ŗö (U+0157 U+00F6)
  0x01, 0x57, 0x00, 0xF8, 0x01, // ŗø (U+0157 U+00F8)
  0x01, 0x57, 0x01, 0x01, 0x01, // ŗā (U+0157 U+0101)
  0x01, 0x57, 0x01, 0x03, 0x01, // ŗă (U+0157 U+0103)
  0x01, 0x57, 0x01, 0x05, 0x01, // ŗą (U+0157 U+0105)
  0x01, 0x57, 0x01, 0x07, 0x01, // ŗć (U+0157 U+0107)
  0x01, 0x57, 0x01, 0x09, 0x01, // ŗĉ (U+0157 U+0109)
  0x01, 0x57, 0x01, 0x0B, 0x01, // ŗċ (U+0157 U+010B)
  0x01, 0x57, 0x01, 0x0D, 0x01, // ŗč (U+0157 U+010D)
  0x01, 0x57, 0x01, 0x0F, 0x01, // ŗď (U+0157 U+010F)
  0x01, 0x57, 0x01, 0x11, 0x01, // ŗđ (U+0157 U+0111)
  0x01, 0x57, 0x01, 0x13, 0x01, // ŗē (U+0157 U+0113)
  0x01, 0x57, 0x01, 0x15, 0x01, // ŗĕ (U+0157 U+0115)
  0x01, 0x57, 0x01, 0x17, 0x01, // ŗė (U+0157 U+0117)
  0x01, 0x57, 0x01, 0x19, 0x01, // ŗę (U+0157 U+0119)
  0x01, 0x57, 0x01, 0x1B, 0x01, // ŗě (U+0157 U+011B)
  0x01, 0x57, 0x01, 0x1D, 0x01, // ŗĝ (U+0157 U+011D)
  0x01, 0x57, 0x01, 0x1F, 0x01, // ŗğ (U+0157 U+011F)
  0x01, 0x57, 0x01, 0x21, 0x01, // ŗġ (U+0157 U+0121)
  0x01, 0x57, 0x01, 0x23, 0x01, // ŗģ (U+0157 U+0123)
  0x01, 0x57, 0x01, 0x4D, 0x01, // ŗō (U+0157 U+014D)
  0x01, 0x57, 0x01, 0x4F, 0x01, // ŗŏ (U+0157 U+014F)
  0x01, 0x57, 0x01, 0x51, 0x01, // ŗő (U+0157 U+0151)
  0x01, 0x57, 0x01, 0x53, 0x01, // ŗœ (U+0157 U+0153)
  0x01, 0x57, 0x01, 0x74, 0x02, // ŗŴ (U+0157 U+0174)
  0x01, 0x57, 0x01, 0x76, 0x01, // ŗŶ (U+0157 U+0176)
  0x01, 0x57, 0x01, 0x78, 0x01, // ŗŸ (U+0157 U+0178)
  0x01, 0x57, 0x20, 0x1A, 0x06, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x06, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x06, // ŗ… (U+0157 U+2026)
  0x01, 0x58, 0x00, 0x26, 0x01, // Ř& (U+0158 U+0026)
  0x01, 0x58, 0x00, 0x2A, 0x01, // Ř* (U+0158 U+002A)
  0x01, 0x58, 0x00, 0x54, 0x01, // ŘT (U+0158 U+0054)
  0x01, 0x58, 0x00, 0x56, 0x01, // ŘV (U+0158 U+0056)
  0x01, 0x58, 0x00, 0x57, 0x01, // ŘW (U+0158 U+0057)
  0x01, 0x58, 0x00, 0x59, 0x01, // ŘY (U+0158 U+0059)
  0x01, 0x58, 0x00, 0x77, 0x01, // Řw (U+0158 U+0077)
  0x01, 0x58, 0x00, 0x79, 0x01, // Řy (U+0158 U+0079)
  0x01, 0x58, 0x00, 0xDD, 0x01, // ŘÝ (U+0158 U+00DD)
  0x01, 0x58, 0x00, 0xFD, 0x01, // Řý (U+0158 U+00FD)
  0x01, 0x58, 0x00, 0xFF, 0x01, // Řÿ (U+0158 U+00FF)
  0x01, 0x58, 0x01, 0x74, 0x01, // ŘŴ (U+0158 U+0174)
  0x01, 0x58, 0x01, 0x75, 0x01, // Řŵ (U+0158 U+0175)
  0x01, 0x58, 0x01, 0x76, 0x01, // ŘŶ (U+0158 U+0176)
  0x01, 0x58, 0x01, 0x77, 0x01, // Řŷ (U+0158 U+0177)
  0x01, 0x58, 0x01, 0x78, 0x01, // ŘŸ (U+0158 U+0178)
  0x01, 0x58, 0x20, 0x19, 0x01, // Ř’ (U+0158 U+2019)
  0x01, 0x58, 0x20, 0x1D, 0x01, // Ř” (U+0158 U+201D)
  0x01, 0x58, 0x21, 0x22, 0x01, // Ř™ (U+0158 U+2122)
  0x01, 0x59, 0x00, 0x2C, 0x06, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x06, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x56, 0x01, // řV (U+0159 U+0056)
  0x01, 0x59, 0x00, 0x57, 0x02, // řW (U+0159 U+0057)
  0x01, 0x59, 0x00, 0x58, 0x02, // řX (U+0159 U+0058)
  0x01, 0x59, 0x00, 0x59, 0x01, // řY (U+0159 U+0059)
  0x01, 0x59, 0x00, 0x61, 0x01, // řa (U+0159 U+0061)
  0x01, 0x59, 0x00, 0x63, 0x01, // řc (U+0159 U+0063)
  0x01, 0x59, 0x00, 0x64, 0x01, // řd (U+0159 U+0064)
  0x01, 0x59, 0x00, 0x65, 0x01, // ře (U+0159 U+0065)
  0x01, 0x59, 0x00, 0x67, 0x01, // řg (U+0159 U+0067)
  0x01, 0x59, 0x00, 0x6F, 0x01, // řo (U+0159 U+006F)
  0x01, 0x59, 0x00, 0x71, 0x01, // řq (U+0159 U+0071)
  0x01, 0x59, 0x00, 0xDD, 0x01, // řÝ (U+0159 U+00DD)
  0x01, 0x59, 0x00, 0xE0, 0x01, // řà (U+0159 U+00E0)
  0x01, 0x59, 0x00, 0xE1, 0x01, // řá (U+0159 U+00E1)
  0x01, 0x59, 0x00, 0xE2, 0x01, // řâ (U+0159 U+00E2)
  0x01, 0x59, 0x00, 0xE3, 0x01, // řã (U+0159 U+00E3)
  0x01, 0x59, 0x00, 0xE4, 0x01, // řä (U+0159 U+00E4)
  0x01, 0x59, 0x00, 0xE5, 0x01, // řå (U+0159 U+00E5)
  0x01, 0x59, 0x00, 0xE6, 0x01, // řæ (U+0159 U+00E6)
  0x01, 0x59, 0x00, 0xE7, 0x01, // řç (U+0159 U+00E7)
  0x01, 0x59, 0x00, 0xE8, 0x01, // řè (U+0159 U+00E8)
  0x01, 0x59, 0x00, 0xE9, 0x01, // řé (U+0159 U+00E9)
  0x01, 0x59, 0x00, 0xEA, 0x01, // řê (U+0159 U+00EA)
  0x01, 0x59, 0x00, 0xEB, 0x01, // řë (U+0159 U+00EB)
  0x01, 0x59, 0x00, 0xF0, 0x01, // řð (U+0159 U+00F0)
  0x01, 0x59, 0x00, 0xF2, 0x01, // řò (U+0159 U+00F2)
  0x01, 0x59, 0x00, 0xF3, 0x01, // řó (U+0159 U+00F3)
  0x01, 0x59, 0x00, 0xF4, 0x01, // řô (U+0159 U+00F4)
  0x01, 0x59, 0x00, 0xF5, 0x01, // řõ (U+0159 U+00F5)
  0x01, 0x59, 0x00, 0xF6, 0x01, // řö (U+0159 U+00F6)
  0x01, 0x59, 0x00, 0xF8, 0x01, // řø (U+0159 U+00F8)
  0x01, 0x59, 0x01, 0x01, 0x01, // řā (U+0159 U+0101)
  0x01, 0x59, 0x01, 0x03, 0x01, // řă (U+0159 U+0103)
  0x01, 0x59, 0x01, 0x05, 0x01, // řą (U+0159 U+0105)
  0x01, 0x59, 0x01, 0x07, 0x01, // řć (U+0159 U+0107)
  0x01, 0x59, 0x01, 0x09, 0x01, // řĉ (U+0159 U+0109)
  0x01, 0x59, 0x01, 0x0B, 0x01, // řċ (U+0159 U+010B)
  0x01, 0x59, 0x01, 0x0D, 0x01, // řč (U+0159 U+010D)
  0x01, 0x59, 0x01, 0x0F, 0x01, // řď (U+0159 U+010F)
  0x01, 0x59, 0x01, 0x11, 0x01, // řđ (U+0159 U+0111)
  0x01, 0x59, 0x01, 0x13, 0x01, // řē (U+0159 U+0113)
  0x01, 0x59, 0x01, 0x15, 0x01, // řĕ (U+0159 U+0115)
  0x01, 0x59, 0x01, 0x17, 0x01, // řė (U+0159 U+0117)
  0x01, 0x59, 0x01, 0x19, 0x01, // řę (U+0159 U+0119)
  0x01, 0x59, 0x01, 0x1B, 0x01, // řě (U+0159 U+011B)
  0x01, 0x59, 0x01, 0x1D, 0x01, // řĝ (U+0159 U+011D)
  0x01, 0x59, 0x01, 0x1F, 0x01, // řğ (U+0159 U+011F)
  0x01, 0x59, 0x01, 0x21, 0x01, // řġ (U+0159 U+0121)
  0x01, 0x59, 0x01, 0x23, 0x01, // řģ (U+0159 U+0123)
  0x01, 0x59, 0x01, 0x4D, 0x01, // řō (U+0159 U+014D)
  0x01, 0x59, 0x01, 0x4F, 0x01, // řŏ (U+0159 U+014F)
  0x01, 0x59, 0x01, 0x51, 0x01, // řő (U+0159 U+0151)
  0x01, 0x59, 0x01, 0x53, 0x01, // řœ (U+0159 U+0153)
  0x01, 0x59, 0x01, 0x74, 0x02, // řŴ (U+0159 U+0174)
  0x01, 0x59, 0x01, 0x76, 0x01, // řŶ (U+0159 U+0176)
  0x01, 0x59, 0x01, 0x78, 0x01, // řŸ (U+0159 U+0178)
  0x01, 0x59, 0x20, 0x1A, 0x06, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x06, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x06, // ř… (U+0159 U+2026)
  0x01, 0x5A, 0x00, 0x54, 0x01, // ŚT (U+015A U+0054)
  0x01, 0x5A, 0x00, 0x56, 0x01, // ŚV (U+015A U+0056)
  0x01, 0x5A, 0x00, 0x57, 0x01, // ŚW (U+015A U+0057)
  0x01, 0x5A, 0x00, 0x58, 0x01, // ŚX (U+015A U+0058)
  0x01, 0x5A, 0x00, 0x59, 0x01, // ŚY (U+015A U+0059)
  0x01, 0x5A, 0x00, 0x79, 0x01, // Śy (U+015A U+0079)
  0x01, 0x5A, 0x00, 0xC6, 0x01, // ŚÆ (U+015A U+00C6)
  0x01, 0x5A, 0x00, 0xDD, 0x01, // ŚÝ (U+015A U+00DD)
  0x01, 0x5A, 0x00, 0xFD, 0x01, // Śý (U+015A U+00FD)
  0x01, 0x5A, 0x00, 0xFF, 0x01, // Śÿ (U+015A U+00FF)
  0x01, 0x5A, 0x01, 0x74, 0x01, // ŚŴ (U+015A U+0174)
  0x01, 0x5A, 0x01, 0x76, 0x01, // ŚŶ (U+015A U+0176)
  0x01, 0x5A, 0x01, 0x77, 0x01, // Śŷ (U+015A U+0177)
  0x01, 0x5A, 0x01, 0x78, 0x01, // ŚŸ (U+015A U+0178)
  0x01, 0x5B, 0x00, 0x22, 0x01, // ś" (U+015B U+0022)
  0x01, 0x5B, 0x00, 0x27, 0x01, // ś' (U+015B U+0027)
  0x01, 0x5B, 0x00, 0x56, 0x01, // śV (U+015B U+0056)
  0x01, 0x5B, 0x00, 0x57, 0x01, // śW (U+015B U+0057)
  0x01, 0x5B, 0x00, 0x59, 0x02, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x02, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x74, 0x01, // śŴ (U+015B U+0174)
  0x01, 0x5B, 0x01, 0x76, 0x02, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x02, // śŸ (U+015B U+0178)
  0x01, 0x5C, 0x00, 0x54, 0x01, // ŜT (U+015C U+0054)
  0x01, 0x5C, 0x00, 0x56, 0x01, // ŜV (U+015C U+0056)
  0x01, 0x5C, 0x00, 0x57, 0x01, // ŜW (U+015C U+0057)
  0x01, 0x5C, 0x00, 0x58, 0x01, // ŜX (U+015C U+0058)
  0x01, 0x5C, 0x00, 0x59, 0x01, // ŜY (U+015C U+0059)
  0x01, 0x5C, 0x00, 0x79, 0x01, // Ŝy (U+015C U+0079)
  0x01, 0x5C, 0x00, 0xC6, 0x01, // ŜÆ (U+015C U+00C6)
  0x01, 0x5C, 0x00, 0xDD, 0x01, // ŜÝ (U+015C U+00DD)
  0x01, 0x5C, 0x00, 0xFD, 0x01, // Ŝý (U+015C U+00FD)
  0x01, 0x5C, 0x00, 0xFF, 0x01, // Ŝÿ (U+015C U+00FF)
  0x01, 0x5C, 0x01, 0x74, 0x01, // ŜŴ (U+015C U+0174)
  0x01, 0x5C, 0x01, 0x76, 0x01, // ŜŶ (U+015C U+0176)
  0x01, 0x5C, 0x01, 0x77, 0x01, // Ŝŷ (U+015C U+0177)
  0x01, 0x5C, 0x01, 0x78, 0x01, // ŜŸ (U+015C U+0178)
  0x01, 0x5D, 0x00, 0x22, 0x01, // ŝ" (U+015D U+0022)
  0x01, 0x5D, 0x00, 0x27, 0x01, // ŝ' (U+015D U+0027)
  0x01, 0x5D, 0x00, 0x56, 0x01, // ŝV (U+015D U+0056)
  0x01, 0x5D, 0x00, 0x57, 0x01, // ŝW (U+015D U+0057)
  0x01, 0x5D, 0x00, 0x59, 0x02, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x02, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x74, 0x01, // ŝŴ (U+015D U+0174)
  0x01, 0x5D, 0x01, 0x76, 0x02, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x02, // ŝŸ (U+015D U+0178)
  0x01, 0x5E, 0x00, 0x54, 0x01, // ŞT (U+015E U+0054)
  0x01, 0x5E, 0x00, 0x56, 0x01, // ŞV (U+015E U+0056)
  0x01, 0x5E, 0x00, 0x57, 0x01, // ŞW (U+015E U+0057)
  0x01, 0x5E, 0x00, 0x58, 0x01, // ŞX (U+015E U+0058)
  0x01, 0x5E, 0x00, 0x59, 0x01, // ŞY (U+015E U+0059)
  0x01, 0x5E, 0x00, 0x79, 0x01, // Şy (U+015E U+0079)
  0x01, 0x5E, 0x00, 0xC6, 0x01, // ŞÆ (U+015E U+00C6)
  0x01, 0x5E, 0x00, 0xDD, 0x01, // ŞÝ (U+015E U+00DD)
  0x01, 0x5E, 0x00, 0xFD, 0x01, // Şý (U+015E U+00FD)
  0x01, 0x5E, 0x00, 0xFF, 0x01, // Şÿ (U+015E U+00FF)
  0x01, 0x5E, 0x01, 0x74, 0x01, // ŞŴ (U+015E U+0174)
  0x01, 0x5E, 0x01, 0x76, 0x01, // ŞŶ (U+015E U+0176)
  0x01, 0x5E, 0x01, 0x77, 0x01, // Şŷ (U+015E U+0177)
  0x01, 0x5E, 0x01, 0x78, 0x01, // ŞŸ (U+015E U+0178)
  0x01, 0x5F, 0x00, 0x22, 0x01, // ş" (U+015F U+0022)
  0x01, 0x5F, 0x00, 0x27, 0x01, // ş' (U+015F U+0027)
  0x01, 0x5F, 0x00, 0x56, 0x01, // şV (U+015F U+0056)
  0x01, 0x5F, 0x00, 0x57, 0x01, // şW (U+015F U+0057)
  0x01, 0x5F, 0x00, 0x59, 0x02, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x02, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x74, 0x01, // şŴ (U+015F U+0174)
  0x01, 0x5F, 0x01, 0x76, 0x02, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x02, // şŸ (U+015F U+0178)
  0x01, 0x60, 0x00, 0x54, 0x01, // ŠT (U+0160 U+0054)
  0x01, 0x60, 0x00, 0x56, 0x01, // ŠV (U+0160 U+0056)
  0x01, 0x60, 0x00, 0x57, 0x01, // ŠW (U+0160 U+0057)
  0x01, 0x60, 0x00, 0x58, 0x01, // ŠX (U+0160 U+0058)
  0x01, 0x60, 0x00, 0x59, 0x01, // ŠY (U+0160 U+0059)
  0x01, 0x60, 0x00, 0x79, 0x01, // Šy (U+0160 U+0079)
  0x01, 0x60, 0x00, 0xC6, 0x01, // ŠÆ (U+0160 U+00C6)
  0x01, 0x60, 0x00, 0xDD, 0x01, // ŠÝ (U+0160 U+00DD)
  0x01, 0x60, 0x00, 0xFD, 0x01, // Šý (U+0160 U+00FD)
  0x01, 0x60, 0x00, 0xFF, 0x01, // Šÿ (U+0160 U+00FF)
  0x01, 0x60, 0x01, 0x74, 0x01, // ŠŴ (U+0160 U+0174)
  0x01, 0x60, 0x01, 0x76, 0x01, // ŠŶ (U+0160 U+0176)
  0x01, 0x60, 0x01, 0x77, 0x01, // Šŷ (U+0160 U+0177)
  0x01, 0x60, 0x01, 0x78, 0x01, // ŠŸ (U+0160 U+0178)
  0x01, 0x61, 0x00, 0x22, 0x01, // š" (U+0161 U+0022)
  0x01, 0x61, 0x00, 0x27, 0x01, // š' (U+0161 U+0027)
  0x01, 0x61, 0x00, 0x56, 0x01, // šV (U+0161 U+0056)
  0x01, 0x61, 0x00, 0x57, 0x01, // šW (U+0161 U+0057)
  0x01, 0x61, 0x00, 0x59, 0x02, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x02, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x74, 0x01, // šŴ (U+0161 U+0174)
  0x01, 0x61, 0x01, 0x76, 0x02, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x02, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x26, 0x01, // Ţ& (U+0162 U+0026)
  0x01, 0x62, 0x00, 0x2C, 0x03, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x03, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x02, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x02, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x02, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x02, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x02, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x02, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x02, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x03, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x01, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x02, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x02, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x02, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x03, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x03, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x03, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x26, 0x01, // Ť& (U+0164 U+0026)
  0x01, 0x64, 0x00, 0x2C, 0x03, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x03, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x02, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x02, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x02, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x02, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x02, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x02, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x02, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x03, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x01, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x02, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x02, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x02, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x03, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x03, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x03, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x26, 0x01, // Ŧ& (U+0166 U+0026)
  0x01, 0x66, 0x00, 0x2C, 0x03, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x03, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x02, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x02, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x02, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x02, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x02, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x02, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x02, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x03, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x01, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x02, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x02, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x02, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x03, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x03, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x03, // Ŧ… (U+0166 U+2026)
  0x01, 0x68, 0x00, 0x26, 0x01, // Ũ& (U+0168 U+0026)
  0x01, 0x68, 0x00, 0x2C, 0x01, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x01, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x00, 0x41, 0x01, // ŨA (U+0168 U+0041)
  0x01, 0x68, 0x00, 0xC0, 0x01, // ŨÀ (U+0168 U+00C0)
  0x01, 0x68, 0x00, 0xC1, 0x01, // ŨÁ (U+0168 U+00C1)
  0x01, 0x68, 0x00, 0xC2, 0x01, // ŨÂ (U+0168 U+00C2)
  0x01, 0x68, 0x00, 0xC3, 0x01, // ŨÃ (U+0168 U+00C3)
  0x01, 0x68, 0x00, 0xC4, 0x01, // ŨÄ (U+0168 U+00C4)
  0x01, 0x68, 0x00, 0xC5, 0x01, // ŨÅ (U+0168 U+00C5)
  0x01, 0x68, 0x00, 0xC6, 0x01, // ŨÆ (U+0168 U+00C6)
  0x01, 0x68, 0x01, 0x00, 0x01, // ŨĀ (U+0168 U+0100)
  0x01, 0x68, 0x01, 0x02, 0x01, // ŨĂ (U+0168 U+0102)
  0x01, 0x68, 0x01, 0x04, 0x01, // ŨĄ (U+0168 U+0104)
  0x01, 0x68, 0x20, 0x1A, 0x01, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x01, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x01, // Ũ… (U+0168 U+2026)
  0x01, 0x69, 0x00, 0x22, 0x02, // ũ" (U+0169 U+0022)
  0x01, 0x69, 0x00, 0x27, 0x02, // ũ' (U+0169 U+0027)
  0x01, 0x69, 0x00, 0x2A, 0x01, // ũ* (U+0169 U+002A)
  0x01, 0x69, 0x00, 0x54, 0x01, // ũT (U+0169 U+0054)
  0x01, 0x69, 0x00, 0x56, 0x02, // ũV (U+0169 U+0056)
  0x01, 0x69, 0x00, 0x57, 0x02, // ũW (U+0169 U+0057)
  0x01, 0x69, 0x00, 0x59, 0x02, // ũY (U+0169 U+0059)
  0x01, 0x69, 0x00, 0xDD, 0x02, // ũÝ (U+0169 U+00DD)
  0x01, 0x69, 0x01, 0x74, 0x02, // ũŴ (U+0169 U+0174)
  0x01, 0x69, 0x01, 0x76, 0x02, // ũŶ (U+0169 U+0176)
  0x01, 0x69, 0x01, 0x78, 0x02, // ũŸ (U+0169 U+0178)
  0x01, 0x69, 0x20, 0x18, 0x01, // ũ‘ (U+0169 U+2018)
  0x01, 0x69, 0x20, 0x19, 0x01, // ũ’ (U+0169 U+2019)
  0x01, 0x69, 0x20, 0x1C, 0x01, // ũ“ (U+0169 U+201C)
  0x01, 0x69, 0x20, 0x1D, 0x01, // ũ” (U+0169 U+201D)
  0x01, 0x69, 0x21, 0x22, 0x01, // ũ™ (U+0169 U+2122)
  0x01, 0x6A, 0x00, 0x26, 0x01, // Ū& (U+016A U+0026)
  0x01, 0x6A, 0x00, 0x2C, 0x01, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x01, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x00, 0x41, 0x01, // ŪA (U+016A U+0041)
  0x01, 0x6A, 0x00, 0xC0, 0x01, // ŪÀ (U+016A U+00C0)
  0x01, 0x6A, 0x00, 0xC1, 0x01, // ŪÁ (U+016A U+00C1)
  0x01, 0x6A, 0x00, 0xC2, 0x01, // ŪÂ (U+016A U+00C2)
  0x01, 0x6A, 0x00, 0xC3, 0x01, // ŪÃ (U+016A U+00C3)
  0x01, 0x6A, 0x00, 0xC4, 0x01, // ŪÄ (U+016A U+00C4)
  0x01, 0x6A, 0x00, 0xC5, 0x01, // ŪÅ (U+016A U+00C5)
  0x01, 0x6A, 0x00, 0xC6, 0x01, // ŪÆ (U+016A U+00C6)
  0x01, 0x6A, 0x01, 0x00, 0x01, // ŪĀ (U+016A U+0100)
  0x01, 0x6A, 0x01, 0x02, 0x01, // ŪĂ (U+016A U+0102)
  0x01, 0x6A, 0x01, 0x04, 0x01, // ŪĄ (U+016A U+0104)
  0x01, 0x6A, 0x20, 0x1A, 0x01, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x01, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x01, // Ū… (U+016A U+2026)
  0x01, 0x6B, 0x00, 0x22, 0x02, // ū" (U+016B U+0022)
  0x01, 0x6B, 0x00, 0x27, 0x02, // ū' (U+016B U+0027)
  0x01, 0x6B, 0x00, 0x2A, 0x01, // ū* (U+016B U+002A)
  0x01, 0x6B, 0x00, 0x54, 0x01, // ūT (U+016B U+0054)
  0x01, 0x6B, 0x00, 0x56, 0x02, // ūV (U+016B U+0056)
  0x01, 0x6B, 0x00, 0x57, 0x02, // ūW (U+016B U+0057)
  0x01, 0x6B, 0x00, 0x59, 0x02, // ūY (U+016B U+0059)
  0x01, 0x6B, 0x00, 0xDD, 0x02, // ūÝ (U+016B U+00DD)
  0x01, 0x6B, 0x01, 0x74, 0x02, // ūŴ (U+016B U+0174)
  0x01, 0x6B, 0x01, 0x76, 0x02, // ūŶ (U+016B U+0176)
  0x01, 0x6B, 0x01, 0x78, 0x02, // ūŸ (U+016B U+0178)
  0x01, 0x6B, 0x20, 0x18, 0x01, // ū‘ (U+016B U+2018)
  0x01, 0x6B, 0x20, 0x19, 0x01, // ū’ (U+016B U+2019)
  0x01, 0x6B, 0x20, 0x1C, 0x01, // ū“ (U+016B U+201C)
  0x01, 0x6B, 0x20, 0x1D, 0x01, // ū” (U+016B U+201D)
  0x01, 0x6B, 0x21, 0x22, 0x01, // ū™ (U+016B U+2122)
  0x01, 0x6C, 0x00, 0x26, 0x01, // Ŭ& (U+016C U+0026)
  0x01, 0x6C, 0x00, 0x2C, 0x01, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x01, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x00, 0x41, 0x01, // ŬA (U+016C U+0041)
  0x01, 0x6C, 0x00, 0xC0, 0x01, // ŬÀ (U+016C U+00C0)
  0x01, 0x6C, 0x00, 0xC1, 0x01, // ŬÁ (U+016C U+00C1)
  0x01, 0x6C, 0x00, 0xC2, 0x01, // ŬÂ (U+016C U+00C2)
  0x01, 0x6C, 0x00, 0xC3, 0x01, // ŬÃ (U+016C U+00C3)
  0x01, 0x6C, 0x00, 0xC4, 0x01, // ŬÄ (U+016C U+00C4)
  0x01, 0x6C, 0x00, 0xC5, 0x01, // ŬÅ (U+016C U+00C5)
  0x01, 0x6C, 0x00, 0xC6, 0x01, // ŬÆ (U+016C U+00C6)
  0x01, 0x6C, 0x01, 0x00, 0x01, // ŬĀ (U+016C U+0100)
  0x01, 0x6C, 0x01, 0x02, 0x01, // ŬĂ (U+016C U+0102)
  0x01, 0x6C, 0x01, 0x04, 0x01, // ŬĄ (U+016C U+0104)
  0x01, 0x6C, 0x20, 0x1A, 0x01, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x01, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x01, // Ŭ… (U+016C U+2026)
  0x01, 0x6D, 0x00, 0x22, 0x02, // ŭ" (U+016D U+0022)
  0x01, 0x6D, 0x00, 0x27, 0x02, // ŭ' (U+016D U+0027)
  0x01, 0x6D, 0x00, 0x2A, 0x01, // ŭ* (U+016D U+002A)
  0x01, 0x6D, 0x00, 0x54, 0x01, // ŭT (U+016D U+0054)
  0x01, 0x6D, 0x00, 0x56, 0x02, // ŭV (U+016D U+0056)
  0x01, 0x6D, 0x00, 0x57, 0x02, // ŭW (U+016D U+0057)
  0x01, 0x6D, 0x00, 0x59, 0x02, // ŭY (U+016D U+0059)
  0x01, 0x6D, 0x00, 0xDD, 0x02, // ŭÝ (U+016D U+00DD)
  0x01, 0x6D, 0x01, 0x74, 0x02, // ŭŴ (U+016D U+0174)
  0x01, 0x6D, 0x01, 0x76, 0x02, // ŭŶ (U+016D U+0176)
  0x01, 0x6D, 0x01, 0x78, 0x02, // ŭŸ (U+016D U+0178)
  0x01, 0x6D, 0x20, 0x18, 0x01, // ŭ‘ (U+016D U+2018)
  0x01, 0x6D, 0x20, 0x19, 0x01, // ŭ’ (U+016D U+2019)
  0x01, 0x6D, 0x20, 0x1C, 0x01, // ŭ“ (U+016D U+201C)
  0x01, 0x6D, 0x20, 0x1D, 0x01, // ŭ” (U+016D U+201D)
  0x01, 0x6D, 0x21, 0x22, 0x01, // ŭ™ (U+016D U+2122)
  0x01, 0x6E, 0x00, 0x26, 0x01, // Ů& (U+016E U+0026)
  0x01, 0x6E, 0x00, 0x2C, 0x01, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x01, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x00, 0x41, 0x01, // ŮA (U+016E U+0041)
  0x01, 0x6E, 0x00, 0xC0, 0x01, // ŮÀ (U+016E U+00C0)
  0x01, 0x6E, 0x00, 0xC1, 0x01, // ŮÁ (U+016E U+00C1)
  0x01, 0x6E, 0x00, 0xC2, 0x01, // ŮÂ (U+016E U+00C2)
  0x01, 0x6E, 0x00, 0xC3, 0x01, // ŮÃ (U+016E U+00C3)
  0x01, 0x6E, 0x00, 0xC4, 0x01, // ŮÄ (U+016E U+00C4)
  0x01, 0x6E, 0x00, 0xC5, 0x01, // ŮÅ (U+016E U+00C5)
  0x01, 0x6E, 0x00, 0xC6, 0x01, // ŮÆ (U+016E U+00C6)
  0x01, 0x6E, 0x01, 0x00, 0x01, // ŮĀ (U+016E U+0100)
  0x01, 0x6E, 0x01, 0x02, 0x01, // ŮĂ (U+016E U+0102)
  0x01, 0x6E, 0x01, 0x04, 0x01, // ŮĄ (U+016E U+0104)
  0x01, 0x6E, 0x20, 0x1A, 0x01, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x01, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x01, // Ů… (U+016E U+2026)
  0x01, 0x6F, 0x00, 0x22, 0x02, // ů" (U+016F U+0022)
  0x01, 0x6F, 0x00, 0x27, 0x02, // ů' (U+016F U+0027)
  0x01, 0x6F, 0x00, 0x2A, 0x01, // ů* (U+016F U+002A)
  0x01, 0x6F, 0x00, 0x54, 0x01, // ůT (U+016F U+0054)
  0x01, 0x6F, 0x00, 0x56, 0x02, // ůV (U+016F U+0056)
  0x01, 0x6F, 0x00, 0x57, 0x02, // ůW (U+016F U+0057)
  0x01, 0x6F, 0x00, 0x59, 0x02, // ůY (U+016F U+0059)
  0x01, 0x6F, 0x00, 0xDD, 0x02, // ůÝ (U+016F U+00DD)
  0x01, 0x6F, 0x01, 0x74, 0x02, // ůŴ (U+016F U+0174)
  0x01, 0x6F, 0x01, 0x76, 0x02, // ůŶ (U+016F U+0176)
  0x01, 0x6F, 0x01, 0x78, 0x02, // ůŸ (U+016F U+0178)
  0x01, 0x6F, 0x20, 0x18, 0x01, // ů‘ (U+016F U+2018)
  0x01, 0x6F, 0x20, 0x19, 0x01, // ů’ (U+016F U+2019)
  0x01, 0x6F, 0x20, 0x1C, 0x01, // ů“ (U+016F U+201C)
  0x01, 0x6F, 0x20, 0x1D, 0x01, // ů” (U+016F U+201D)
  0x01, 0x6F, 0x21, 0x22, 0x01, // ů™ (U+016F U+2122)
  0x01, 0x70, 0x00, 0x26, 0x01, // Ű& (U+0170 U+0026)
  0x01, 0x70, 0x00, 0x2C, 0x01, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x01, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x00, 0x41, 0x01, // ŰA (U+0170 U+0041)
  0x01, 0x70, 0x00, 0xC0, 0x01, // ŰÀ (U+0170 U+00C0)
  0x01, 0x70, 0x00, 0xC1, 0x01, // ŰÁ (U+0170 U+00C1)
  0x01, 0x70, 0x00, 0xC2, 0x01, // ŰÂ (U+0170 U+00C2)
  0x01, 0x70, 0x00, 0xC3, 0x01, // ŰÃ (U+0170 U+00C3)
  0x01, 0x70, 0x00, 0xC4, 0x01, // ŰÄ (U+0170 U+00C4)
  0x01, 0x70, 0x00, 0xC5, 0x01, // ŰÅ (U+0170 U+00C5)
  0x01, 0x70, 0x00, 0xC6, 0x01, // ŰÆ (U+0170 U+00C6)
  0x01, 0x70, 0x01, 0x00, 0x01, // ŰĀ (U+0170 U+0100)
  0x01, 0x70, 0x01, 0x02, 0x01, // ŰĂ (U+0170 U+0102)
  0x01, 0x70, 0x01, 0x04, 0x01, // ŰĄ (U+0170 U+0104)
  0x01, 0x70, 0x20, 0x1A, 0x01, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x01, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x01, // Ű… (U+0170 U+2026)
  0x01, 0x71, 0x00, 0x22, 0x02, // ű" (U+0171 U+0022)
  0x01, 0x71, 0x00, 0x27, 0x02, // ű' (U+0171 U+0027)
  0x01, 0x71, 0x00, 0x2A, 0x01, // ű* (U+0171 U+002A)
  0x01, 0x71, 0x00, 0x54, 0x01, // űT (U+0171 U+0054)
  0x01, 0x71, 0x00, 0x56, 0x02, // űV (U+0171 U+0056)
  0x01, 0x71, 0x00, 0x57, 0x02, // űW (U+0171 U+0057)
  0x01, 0x71, 0x00, 0x59, 0x02, // űY (U+0171 U+0059)
  0x01, 0x71, 0x00, 0xDD, 0x02, // űÝ (U+0171 U+00DD)
  0x01, 0x71, 0x01, 0x74, 0x02, // űŴ (U+0171 U+0174)
  0x01, 0x71, 0x01, 0x76, 0x02, // űŶ (U+0171 U+0176)
  0x01, 0x71, 0x01, 0x78, 0x02, // űŸ (U+0171 U+0178)
  0x01, 0x71, 0x20, 0x18, 0x01, // ű‘ (U+0171 U+2018)
  0x01, 0x71, 0x20, 0x19, 0x01, // ű’ (U+0171 U+2019)
  0x01, 0x71, 0x20, 0x1C, 0x01, // ű“ (U+0171 U+201C)
  0x01, 0x71, 0x20, 0x1D, 0x01, // ű” (U+0171 U+201D)
  0x01, 0x71, 0x21, 0x22, 0x01, // ű™ (U+0171 U+2122)
  0x01, 0x72, 0x00, 0x26, 0x01, // Ų& (U+0172 U+0026)
  0x01, 0x72, 0x00, 0x2C, 0x01, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x01, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x00, 0x41, 0x01, // ŲA (U+0172 U+0041)
  0x01, 0x72, 0x00, 0xC0, 0x01, // ŲÀ (U+0172 U+00C0)
  0x01, 0x72, 0x00, 0xC1, 0x01, // ŲÁ (U+0172 U+00C1)
  0x01, 0x72, 0x00, 0xC2, 0x01, // ŲÂ (U+0172 U+00C2)
  0x01, 0x72, 0x00, 0xC3, 0x01, // ŲÃ (U+0172 U+00C3)
  0x01, 0x72, 0x00, 0xC4, 0x01, // ŲÄ (U+0172 U+00C4)
  0x01, 0x72, 0x00, 0xC5, 0x01, // ŲÅ (U+0172 U+00C5)
  0x01, 0x72, 0x00, 0xC6, 0x01, // ŲÆ (U+0172 U+00C6)
  0x01, 0x72, 0x01, 0x00, 0x01, // ŲĀ (U+0172 U+0100)
  0x01, 0x72, 0x01, 0x02, 0x01, // ŲĂ (U+0172 U+0102)
  0x01, 0x72, 0x01, 0x04, 0x01, // ŲĄ (U+0172 U+0104)
  0x01, 0x72, 0x20, 0x1A, 0x01, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x01, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x01, // Ų… (U+0172 U+2026)
  0x01, 0x73, 0x00, 0x22, 0x02, // ų" (U+0173 U+0022)
  0x01, 0x73, 0x00, 0x27, 0x02, // ų' (U+0173 U+0027)
  0x01, 0x73, 0x00, 0x2A, 0x01, // ų* (U+0173 U+002A)
  0x01, 0x73, 0x00, 0x54, 0x01, // ųT (U+0173 U+0054)
  0x01, 0x73, 0x00, 0x56, 0x02, // ųV (U+0173 U+0056)
  0x01, 0x73, 0x00, 0x57, 0x02, // ųW (U+0173 U+0057)
  0x01, 0x73, 0x00, 0x59, 0x02, // ųY (U+0173 U+0059)
  0x01, 0x73, 0x00, 0xDD, 0x02, // ųÝ (U+0173 U+00DD)
  0x01, 0x73, 0x01, 0x74, 0x02, // ųŴ (U+0173 U+0174)
  0x01, 0x73, 0x01, 0x76, 0x02, // ųŶ (U+0173 U+0176)
  0x01, 0x73, 0x01, 0x78, 0x02, // ųŸ (U+0173 U+0178)
  0x01, 0x73, 0x20, 0x18, 0x01, // ų‘ (U+0173 U+2018)
  0x01, 0x73, 0x20, 0x19, 0x01, // ų’ (U+0173 U+2019)
  0x01, 0x73, 0x20, 0x1C, 0x01, // ų“ (U+0173 U+201C)
  0x01, 0x73, 0x20, 0x1D, 0x01, // ų” (U+0173 U+201D)
  0x01, 0x73, 0x21, 0x22, 0x01, // ų™ (U+0173 U+2122)
  0x01, 0x74, 0x00, 0x26, 0x01, // Ŵ& (U+0174 U+0026)
  0x01, 0x74, 0x00, 0x2C, 0x04, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x04, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x02, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x43, 0x01, // ŴC (U+0174 U+0043)
  0x01, 0x74, 0x00, 0x47, 0x01, // ŴG (U+0174 U+0047)
  0x01, 0x74, 0x00, 0x4F, 0x01, // ŴO (U+0174 U+004F)
  0x01, 0x74, 0x00, 0x51, 0x01, // ŴQ (U+0174 U+0051)
  0x01, 0x74, 0x00, 0x61, 0x02, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x02, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x02, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x02, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x02, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x02, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x02, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0x78, 0x01, // Ŵx (U+0174 U+0078)
  0x01, 0x74, 0x00, 0xC0, 0x02, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x02, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x02, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x02, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x02, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x02, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x05, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xC7, 0x01, // ŴÇ (U+0174 U+00C7)
  0x01, 0x74, 0x00, 0xD2, 0x01, // ŴÒ (U+0174 U+00D2)
  0x01, 0x74, 0x00, 0xD3, 0x01, // ŴÓ (U+0174 U+00D3)
  0x01, 0x74, 0x00, 0xD4, 0x01, // ŴÔ (U+0174 U+00D4)
  0x01, 0x74, 0x00, 0xD5, 0x01, // ŴÕ (U+0174 U+00D5)
  0x01, 0x74, 0x00, 0xD6, 0x01, // ŴÖ (U+0174 U+00D6)
  0x01, 0x74, 0x00, 0xD8, 0x01, // ŴØ (U+0174 U+00D8)
  0x01, 0x74, 0x00, 0xE0, 0x02, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x02, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x02, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x02, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x02, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x02, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x02, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x02, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x02, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x02, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x02, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x02, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x02, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x02, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x02, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x02, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x02, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x02, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x02, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x02, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x02, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x02, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x02, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x02, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x02, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x06, 0x01, // ŴĆ (U+0174 U+0106)
  0x01, 0x74, 0x01, 0x07, 0x02, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x08, 0x01, // ŴĈ (U+0174 U+0108)
  0x01, 0x74, 0x01, 0x09, 0x02, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0A, 0x01, // ŴĊ (U+0174 U+010A)
  0x01, 0x74, 0x01, 0x0B, 0x02, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0C, 0x01, // ŴČ (U+0174 U+010C)
  0x01, 0x74, 0x01, 0x0D, 0x02, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x02, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x02, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x02, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x02, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x02, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x02, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x02, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1C, 0x01, // ŴĜ (U+0174 U+011C)
  0x01, 0x74, 0x01, 0x1D, 0x02, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1E, 0x01, // ŴĞ (U+0174 U+011E)
  0x01, 0x74, 0x01, 0x1F, 0x02, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x20, 0x01, // ŴĠ (U+0174 U+0120)
  0x01, 0x74, 0x01, 0x21, 0x02, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x22, 0x01, // ŴĢ (U+0174 U+0122)
  0x01, 0x74, 0x01, 0x23, 0x02, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4C, 0x01, // ŴŌ (U+0174 U+014C)
  0x01, 0x74, 0x01, 0x4D, 0x02, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4E, 0x01, // ŴŎ (U+0174 U+014E)
  0x01, 0x74, 0x01, 0x4F, 0x02, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x50, 0x01, // ŴŐ (U+0174 U+0150)
  0x01, 0x74, 0x01, 0x51, 0x02, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x52, 0x01, // ŴŒ (U+0174 U+0152)
  0x01, 0x74, 0x01, 0x53, 0x02, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x20, 0x1A, 0x04, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x04, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x04, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x03, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x03, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x00, 0x41, 0x01, // ŵA (U+0175 U+0041)
  0x01, 0x75, 0x00, 0x56, 0x01, // ŵV (U+0175 U+0056)
  0x01, 0x75, 0x00, 0x57, 0x01, // ŵW (U+0175 U+0057)
  0x01, 0x75, 0x00, 0x59, 0x01, // ŵY (U+0175 U+0059)
  0x01, 0x75, 0x00, 0xC0, 0x01, // ŵÀ (U+0175 U+00C0)
  0x01, 0x75, 0x00, 0xC1, 0x01, // ŵÁ (U+0175 U+00C1)
  0x01, 0x75, 0x00, 0xC2, 0x01, // ŵÂ (U+0175 U+00C2)
  0x01, 0x75, 0x00, 0xC3, 0x01, // ŵÃ (U+0175 U+00C3)
  0x01, 0x75, 0x00, 0xC4, 0x01, // ŵÄ (U+0175 U+00C4)
  0x01, 0x75, 0x00, 0xC5, 0x01, // ŵÅ (U+0175 U+00C5)
  0x01, 0x75, 0x00, 0xDD, 0x01, // ŵÝ (U+0175 U+00DD)
  0x01, 0x75, 0x01, 0x00, 0x01, // ŵĀ (U+0175 U+0100)
  0x01, 0x75, 0x01, 0x02, 0x01, // ŵĂ (U+0175 U+0102)
  0x01, 0x75, 0x01, 0x04, 0x01, // ŵĄ (U+0175 U+0104)
  0x01, 0x75, 0x01, 0x74, 0x01, // ŵŴ (U+0175 U+0174)
  0x01, 0x75, 0x01, 0x76, 0x01, // ŵŶ (U+0175 U+0176)
  0x01, 0x75, 0x01, 0x78, 0x01, // ŵŸ (U+0175 U+0178)
  0x01, 0x75, 0x20, 0x1A, 0x03, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x03, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x03, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x03, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x03, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x03, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x01, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x01, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x01, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x01, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x53, 0x01, // ŶS (U+0176 U+0053)
  0x01, 0x76, 0x00, 0x61, 0x02, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x03, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x03, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x03, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x03, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x03, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x03, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x02, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x7A, 0x01, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xC0, 0x03, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x03, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x03, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x03, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x03, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x03, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x04, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xC7, 0x01, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x01, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x01, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x01, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x01, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x01, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x01, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x02, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x02, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x02, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x02, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x02, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x02, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x02, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x03, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x03, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x03, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x03, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x03, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x03, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x03, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x03, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x03, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x03, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x03, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x03, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x03, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x02, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x03, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x02, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x03, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x02, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x01, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x03, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x01, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x03, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x01, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x03, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x01, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x03, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x03, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x03, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x03, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x03, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x03, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x03, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x03, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x01, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x03, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x01, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x03, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x01, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x03, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x01, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x03, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4C, 0x01, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x03, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x01, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x03, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x01, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x03, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x01, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x03, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5A, 0x01, // ŶŚ (U+0176 U+015A)
  0x01, 0x76, 0x01, 0x5B, 0x02, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5C, 0x01, // ŶŜ (U+0176 U+015C)
  0x01, 0x76, 0x01, 0x5D, 0x02, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5E, 0x01, // ŶŞ (U+0176 U+015E)
  0x01, 0x76, 0x01, 0x5F, 0x02, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x60, 0x01, // ŶŠ (U+0176 U+0160)
  0x01, 0x76, 0x01, 0x61, 0x02, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x01, 0x7A, 0x01, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x01, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x01, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x03, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x03, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x03, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x03, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x03, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x01, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0x56, 0x01, // ŷV (U+0177 U+0056)
  0x01, 0x77, 0x00, 0x57, 0x01, // ŷW (U+0177 U+0057)
  0x01, 0x77, 0x00, 0x59, 0x01, // ŷY (U+0177 U+0059)
  0x01, 0x77, 0x00, 0xC0, 0x01, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x01, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x01, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x01, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x01, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x01, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x00, 0xDD, 0x01, // ŷÝ (U+0177 U+00DD)
  0x01, 0x77, 0x01, 0x00, 0x01, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x01, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x01, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x01, 0x74, 0x01, // ŷŴ (U+0177 U+0174)
  0x01, 0x77, 0x01, 0x76, 0x01, // ŷŶ (U+0177 U+0176)
  0x01, 0x77, 0x01, 0x78, 0x01, // ŷŸ (U+0177 U+0178)
  0x01, 0x77, 0x20, 0x1A, 0x03, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x03, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x03, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x03, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x03, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x03, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x01, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x01, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x01, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x01, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x53, 0x01, // ŸS (U+0178 U+0053)
  0x01, 0x78, 0x00, 0x61, 0x02, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x03, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x03, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x03, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x03, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x03, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x03, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x02, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x7A, 0x01, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xC0, 0x03, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x03, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x03, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x03, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x03, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x03, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x04, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xC7, 0x01, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x01, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x01, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x01, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x01, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x01, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x01, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x02, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x02, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x02, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x02, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x02, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x02, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x02, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x03, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x03, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x03, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x03, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x03, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x03, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x03, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x03, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x03, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x03, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x03, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x03, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x03, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x02, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x03, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x02, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x03, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x02, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x01, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x03, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x01, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x03, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x01, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x03, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x01, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x03, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x03, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x03, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x03, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x03, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x03, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x03, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x03, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x01, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x03, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x01, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x03, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x01, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x03, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x01, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x03, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4C, 0x01, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x03, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x01, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x03, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x01, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x03, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x01, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x03, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5A, 0x01, // ŸŚ (U+0178 U+015A)
  0x01, 0x78, 0x01, 0x5B, 0x02, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5C, 0x01, // ŸŜ (U+0178 U+015C)
  0x01, 0x78, 0x01, 0x5D, 0x02, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5E, 0x01, // ŸŞ (U+0178 U+015E)
  0x01, 0x78, 0x01, 0x5F, 0x02, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x60, 0x01, // ŸŠ (U+0178 U+0160)
  0x01, 0x78, 0x01, 0x61, 0x02, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x01, 0x7A, 0x01, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x01, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x01, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x03, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x03, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x03, // Ÿ… (U+0178 U+2026)
  0x01, 0x7A, 0x00, 0x2A, 0x01, // ź* (U+017A U+002A)
  0x01, 0x7A, 0x00, 0x56, 0x02, // źV (U+017A U+0056)
  0x01, 0x7A, 0x00, 0x57, 0x01, // źW (U+017A U+0057)
  0x01, 0x7A, 0x00, 0x59, 0x01, // źY (U+017A U+0059)
  0x01, 0x7A, 0x00, 0xDD, 0x01, // źÝ (U+017A U+00DD)
  0x01, 0x7A, 0x01, 0x74, 0x01, // źŴ (U+017A U+0174)
  0x01, 0x7A, 0x01, 0x76, 0x01, // źŶ (U+017A U+0176)
  0x01, 0x7A, 0x01, 0x78, 0x01, // źŸ (U+017A U+0178)
  0x01, 0x7A, 0x20, 0x18, 0x01, // ź‘ (U+017A U+2018)
  0x01, 0x7A, 0x20, 0x19, 0x01, // ź’ (U+017A U+2019)
  0x01, 0x7A, 0x20, 0x1C, 0x01, // ź“ (U+017A U+201C)
  0x01, 0x7A, 0x20, 0x1D, 0x01, // ź” (U+017A U+201D)
  0x01, 0x7A, 0x21, 0x22, 0x01, // ź™ (U+017A U+2122)
  0x01, 0x7C, 0x00, 0x2A, 0x01, // ż* (U+017C U+002A)
  0x01, 0x7C, 0x00, 0x56, 0x02, // żV (U+017C U+0056)
  0x01, 0x7C, 0x00, 0x57, 0x01, // żW (U+017C U+0057)
  0x01, 0x7C, 0x00, 0x59, 0x01, // żY (U+017C U+0059)
  0x01, 0x7C, 0x00, 0xDD, 0x01, // żÝ (U+017C U+00DD)
  0x01, 0x7C, 0x01, 0x74, 0x01, // żŴ (U+017C U+0174)
  0x01, 0x7C, 0x01, 0x76, 0x01, // żŶ (U+017C U+0176)
  0x01, 0x7C, 0x01, 0x78, 0x01, // żŸ (U+017C U+0178)
  0x01, 0x7C, 0x20, 0x18, 0x01, // ż‘ (U+017C U+2018)
  0x01, 0x7C, 0x20, 0x19, 0x01, // ż’ (U+017C U+2019)
  0x01, 0x7C, 0x20, 0x1C, 0x01, // ż“ (U+017C U+201C)
  0x01, 0x7C, 0x20, 0x1D, 0x01, // ż” (U+017C U+201D)
  0x01, 0x7C, 0x21, 0x22, 0x01, // ż™ (U+017C U+2122)
  0x01, 0x7E, 0x00, 0x2A, 0x01, // ž* (U+017E U+002A)
  0x01, 0x7E, 0x00, 0x56, 0x02, // žV (U+017E U+0056)
  0x01, 0x7E, 0x00, 0x57, 0x01, // žW (U+017E U+0057)
  0x01, 0x7E, 0x00, 0x59, 0x01, // žY (U+017E U+0059)
  0x01, 0x7E, 0x00, 0xDD, 0x01, // žÝ (U+017E U+00DD)
  0x01, 0x7E, 0x01, 0x74, 0x01, // žŴ (U+017E U+0174)
  0x01, 0x7E, 0x01, 0x76, 0x01, // žŶ (U+017E U+0176)
  0x01, 0x7E, 0x01, 0x78, 0x01, // žŸ (U+017E U+0178)
  0x01, 0x7E, 0x20, 0x18, 0x01, // ž‘ (U+017E U+2018)
  0x01, 0x7E, 0x20, 0x19, 0x01, // ž’ (U+017E U+2019)
  0x01, 0x7E, 0x20, 0x1C, 0x01, // ž“ (U+017E U+201C)
  0x01, 0x7E, 0x20, 0x1D, 0x01, // ž” (U+017E U+201D)
  0x01, 0x7E, 0x21, 0x22, 0x01, // ž™ (U+017E U+2122)
  0x20, 0x18, 0x00, 0x41, 0x03, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x03, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x03, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x03, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x03, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x03, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x03, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x06, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x03, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x03, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x03, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x04, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x73, 0x02, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x04, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x04, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x04, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x04, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x04, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x04, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x06, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x04, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x04, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x04, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x5B, 0x02, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x02, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x02, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x02, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x03, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x55, 0x01, // ‚U (U+201A U+0055)
  0x20, 0x1A, 0x00, 0x56, 0x04, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x03, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x03, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x02, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x01, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x01, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xD9, 0x01, // ‚Ù (U+201A U+00D9)
  0x20, 0x1A, 0x00, 0xDA, 0x01, // ‚Ú (U+201A U+00DA)
  0x20, 0x1A, 0x00, 0xDB, 0x01, // ‚Û (U+201A U+00DB)
  0x20, 0x1A, 0x00, 0xDC, 0x01, // ‚Ü (U+201A U+00DC)
  0x20, 0x1A, 0x00, 0xDD, 0x03, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xFD, 0x01, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x01, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x68, 0x01, // ‚Ũ (U+201A U+0168)
  0x20, 0x1A, 0x01, 0x6A, 0x01, // ‚Ū (U+201A U+016A)
  0x20, 0x1A, 0x01, 0x6C, 0x01, // ‚Ŭ (U+201A U+016C)
  0x20, 0x1A, 0x01, 0x6E, 0x01, // ‚Ů (U+201A U+016E)
  0x20, 0x1A, 0x01, 0x70, 0x01, // ‚Ű (U+201A U+0170)
  0x20, 0x1A, 0x01, 0x72, 0x01, // ‚Ų (U+201A U+0172)
  0x20, 0x1A, 0x01, 0x74, 0x03, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x01, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x03, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x01, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x03, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x03, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x03, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x03, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x03, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x03, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x03, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x03, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x06, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x03, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x03, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x03, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x04, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x73, 0x02, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x04, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x04, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x04, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x04, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x04, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x04, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x06, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x04, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x04, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x04, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x5B, 0x02, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x02, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x02, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x02, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x03, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x55, 0x01, // „U (U+201E U+0055)
  0x20, 0x1E, 0x00, 0x56, 0x04, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x03, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x03, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x02, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x01, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x01, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xD9, 0x01, // „Ù (U+201E U+00D9)
  0x20, 0x1E, 0x00, 0xDA, 0x01, // „Ú (U+201E U+00DA)
  0x20, 0x1E, 0x00, 0xDB, 0x01, // „Û (U+201E U+00DB)
  0x20, 0x1E, 0x00, 0xDC, 0x01, // „Ü (U+201E U+00DC)
  0x20, 0x1E, 0x00, 0xDD, 0x03, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xFD, 0x01, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x01, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x68, 0x01, // „Ũ (U+201E U+0168)
  0x20, 0x1E, 0x01, 0x6A, 0x01, // „Ū (U+201E U+016A)
  0x20, 0x1E, 0x01, 0x6C, 0x01, // „Ŭ (U+201E U+016C)
  0x20, 0x1E, 0x01, 0x6E, 0x01, // „Ů (U+201E U+016E)
  0x20, 0x1E, 0x01, 0x70, 0x01, // „Ű (U+201E U+0170)
  0x20, 0x1E, 0x01, 0x72, 0x01, // „Ų (U+201E U+0172)
  0x20, 0x1E, 0x01, 0x74, 0x03, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x01, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x03, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x01, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x03, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x50, 0x4B, 0x0E, 0x50, 0x7B, 0x0B, 0x50, 0x9B, 0x07, 0x50, 0xBB, 0x02, 0x50, 0xEA, 0x0E, 0x50,
  0x1B, 0x09, 0x50, 0x3B, 0x05, 0x50, 0x5B, 0x01, 0x50, 0x8A, 0x0D, 0x60, 0xAA, 0x08, 0x60, 0xCA,
  0x04, 0x6B, 0x60, 0x2A, 0x0B, 0x60, 0x4A, 0x07, 0x60, 0x6A, 0x03, 0x68, 0x19, 0xFE, 0x78, 0x1B,
  0xFA, 0x78, 0x1D, 0xF6, 0x7A, 0x02, 0x68, 0x13, 0xFD, 0x78, 0x14, 0xD8, 0x80, 0xC0, 0x08, 0x29,
  0xED, 0x35, 0x07, 0xB0, 0xC5, 0x0B, 0xB0, 0xC5, 0x0A, 0xB0, 0x85, 0x82, 0x3C, 0xEA, 0x60,
  // """ (U+0022)
  0x02, 0xB0, 0xA2, 0x07, 0xB0, 0x50, 0x3B, 0x05, 0x20, 0x8A, 0x81, 0xE0, 0x5A, 0x0E, 0x30, 0xAA,
  0x81, 0x90, 0x7A, 0x09, 0x30, 0xCA, 0x81, 0x30, 0x8A, 0x04, 0x38, 0x1E, 0xFD, 0x28, 0x1A, 0xFE,
  0x4A, 0x08, 0x28, 0x1C, 0xF8, 0x30, 0x2A, 0x02, 0x28, 0x1D, 0xF3, 0x38, 0x13, 0xFC, 0x39, 0x0D,
  0x48, 0x15, 0xF7, 0x30,
  // "#" (U+0023)
  0x71, 0x81, 0x3F, 0xE4, 0x81, 0x4F, 0xD7, 0x28, 0x17, 0xFA, 0x48, 0x18, 0xF9, 0x72, 0x81, 0xBF,
  0x54, 0x81, 0xDF, 0x47, 0x2A, 0x01, 0x30, 0x1A, 0x72, 0x81, 0x5F, 0xC4, 0x81, 0x6F, 0xB7, 0x28,
  0x19, 0xF8, 0x48, 0x1A, 0xF7, 0x72, 0x81, 0xDF, 0x44, 0x81, 0xEF, 0x27, 0x18, 0x12, 0xFE, 0x48,
  0x13, 0xFD, 0x50, 0x6F, 0xF9, 0x0C, 0x20, 0x70, 0xFE, 0xA8, 0x01, 0xEA, 0x0F, 0xE0, 0x95, 0x01,
  0xA4, 0x81, 0x2F, 0xE7, 0x28, 0x15, 0xFC, 0x48, 0x16, 0xFB, 0x72, 0x81, 0x8F, 0x84, 0x81, 0xAF,
  0x77, 0x28, 0x1C, 0xF4, 0x48, 0x1D, 0xF3, 0x71, 0x01, 0xA0, 0x13, 0x01, 0xA7, 0x28, 0x14, 0xFC,
  0x48, 0x15, 0xFB, 0x72, 0x81, 0x8F, 0x84, 0x81, 0x9F, 0x87, 0x28, 0x1C, 0xF5, 0x48, 0x1D, 0xF4,
  0x72, 0xA0, 0x13, 0x01, 0xA6, 0x0A, 0x0F, 0xEA, 0x80, 0x1E, 0xA0, 0xFE, 0x07, 0x20, 0xDF, 0xF9,
  0x05, 0x58, 0x1E, 0xF2, 0x30, 0x1A, 0x72, 0x81, 0x4F, 0xD4, 0x81, 0x5F, 0xB7, 0x28, 0x18, 0xF8,
  0x48, 0x1A, 0xF7, 0x72, 0x81, 0xDF, 0x44, 0x81, 0xEF, 0x27, 0x18, 0x12, 0xFE, 0x48, 0x13, 0xFD,
  0x72, 0x81, 0x6F, 0xB4, 0x81, 0x7F, 0x97, 0x28, 0x1B, 0xF6, 0x48, 0x1C, 0xF5, 0x72, 0xA0, 0x23,
  0x01, 0xA0, 0x17, 0x10,
  // "$" (U+0024)
  0x75, 0x0C, 0x0E, 0x77, 0x30, 0xE0, 0xB7, 0x72, 0x81, 0x2F, 0x87, 0x68, 0x73, 0x8B, 0xDF, 0xEB,
  0x71, 0x71, 0x01, 0x0B, 0xF9, 0x0E, 0x04, 0x60, 0x10, 0xDA, 0x84, 0xC4, 0xCE, 0x2D, 0xA0, 0xE0,
  0x15, 0x0B, 0xA0, 0xC2, 0x98, 0x1B, 0x03, 0xB0, 0x54, 0x03, 0xB8, 0x33, 0x03, 0xF8, 0x20, 0xEA,
  0x04, 0x40, 0x8A, 0x0D, 0x28, 0x16, 0xF4, 0x28, 0x1C, 0xFE, 0x50, 0xAA, 0x0A, 0x28, 0x19, 0xF1,
  0x28, 0x19, 0xA2, 0x50, 0xBA, 0x0A, 0x20, 0xC0, 0xE7, 0x40, 0xBA, 0x0D, 0x29, 0x0A, 0x74, 0x09,
  0xB8, 0x24, 0x3F, 0x77, 0x40, 0x3B, 0x82, 0xE9, 0xF4, 0x75, 0x0A, 0xD0, 0x27, 0x60, 0xBC, 0x0E,
  0x05, 0x76, 0x09, 0xD0, 0x97, 0x60, 0x7D, 0x0A, 0x75, 0x81, 0x9F, 0x8C, 0x05, 0x74, 0x82, 0xCE,
  0x05, 0xB0, 0xC5, 0x04, 0x01, 0x49, 0x0B, 0x20, 0xBB, 0x48, 0x1B, 0xF4, 0x38, 0x13, 0xF8, 0x20,
  0x7B, 0x30, 0x7A, 0x05, 0x38, 0x16, 0xF5, 0x20, 0x6B, 0x30, 0xAA, 0x07, 0x38, 0x19, 0xF2, 0x20,
  0x8A, 0x0C, 0x30, 0xBA, 0x0C, 0x30, 0xC0, 0xE3, 0x0D, 0xA0, 0x83, 0x09, 0xB0, 0x42, 0x90, 0xB2,
  0x07, 0xA0, 0xE0, 0x13, 0x03, 0xB8, 0x5D, 0x23, 0xF8, 0x07, 0xB0, 0x35, 0x07, 0xC8, 0x2D, 0xFD,
  0xEA, 0x0D, 0x04, 0x70, 0x40, 0xCE, 0x81, 0xD7, 0x17, 0x38, 0x41, 0x2E, 0xD2, 0x17, 0x78, 0x11,
  0xFA, 0x77, 0x28, 0x14, 0xF7, 0x77, 0x28, 0x17, 0xF3, 0x77, 0x20, 0xA9, 0x75,
  // "%" (U+0025)
  0x58, 0x42, 0x9D, 0xFD, 0x87, 0x30, 0x4A, 0x02, 0x70, 0x40, 0xED, 0x0B, 0x72, 0x81, 0xDF, 0x87,
  0x85, 0x3E, 0xFC, 0x20, 0xAA, 0x05, 0x78, 0x18, 0xFD, 0x71, 0x82, 0xDF, 0xE1, 0x20, 0x3A, 0x0A,
  0x60, 0x2A, 0x04, 0x70, 0x7A, 0x07, 0x30, 0x1A, 0x0D, 0x68, 0x1B, 0xFA, 0x71, 0x0D, 0xA0, 0x14,
  0xB5, 0x82, 0x6F, 0xE1, 0x70, 0x4A, 0x0A, 0x5B, 0x48, 0x21, 0xEF, 0x77, 0x10, 0x8A, 0x06, 0x40,
  0x2A, 0x0D, 0x48, 0x1A, 0xFC, 0x72, 0x0C, 0xA0, 0x24, 0x04, 0xA0, 0xB3, 0x04, 0xA0, 0x37, 0x2B,
  0x50, 0x7A, 0x08, 0x38, 0x1D, 0xF9, 0x72, 0x01, 0xA0, 0xD5, 0x0B, 0xA0, 0x42, 0x82, 0x8F, 0xE1,
  0x72, 0x02, 0xA0, 0xB5, 0xA0, 0xE2, 0x02, 0xA0, 0x52, 0x84, 0x19, 0xDE, 0xC7, 0x20, 0x2A, 0x0A,
  0x40, 0x5A, 0x08, 0x28, 0x1B, 0xFB, 0x20, 0x30, 0xED, 0x81, 0xA0, 0x1A, 0x0B, 0x40, 0xCA, 0x81,
  0x10, 0x6A, 0x87, 0x20, 0x3E, 0xFD, 0x31, 0xBA, 0x83, 0x40, 0xEF, 0xE3, 0x06, 0xA8, 0x47, 0x01,
  0xEF, 0x72, 0x0D, 0xA0, 0x22, 0x03, 0xA8, 0x19, 0x08, 0xA8, 0x16, 0x05, 0xA0, 0xB2, 0x81, 0xAF,
  0xD2, 0x06, 0xA0, 0x73, 0x01, 0xA8, 0x2C, 0x01, 0xDD, 0x0B, 0x20, 0x4A, 0x04, 0x20, 0xDA, 0x01,
  0x4A, 0x0E, 0x28, 0x41, 0x9D, 0xEC, 0x63, 0x81, 0xDF, 0x92, 0x04, 0xA0, 0xA5, 0xA0, 0xE7, 0x38,
  0x28, 0xFE, 0x12, 0x08, 0xA0, 0x64, 0x02, 0xA0, 0xD7, 0x20, 0x2A, 0x06, 0x30, 0xCA, 0x02, 0x40,
  0x4A, 0x0A, 0x72, 0x81, 0xBF, 0xC4, 0xA0, 0xE5, 0x07, 0xA0, 0x77, 0x10, 0x6A, 0x02, 0x30, 0x1A,
  0x0C, 0x50, 0xBA, 0x03, 0x78, 0x21, 0xEF, 0x84, 0x02, 0xA0, 0xA5, 0xA0, 0xE7, 0x18, 0x1A, 0xFD,
  0x50, 0x2A, 0x0A, 0x40, 0x5A, 0x08, 0x70, 0x4A, 0x04, 0x50, 0x1A, 0x0A, 0x40, 0xCA, 0x01, 0x78,
  0x1D, 0xFA, 0x78, 0x1E, 0xFD, 0x30, 0x6A, 0x07, 0x78, 0x28, 0xFE, 0x17, 0x09, 0xA8, 0x45, 0x05,
  0xEF, 0xC7, 0x02, 0xA0, 0x67, 0x10, 0x10, 0xDD, 0x0C, 0x01, 0x78, 0x1B, 0xFC, 0x73, 0x84, 0x2A,
  0xEF, 0xC7, 0x50,
  // "&" (U+0026)
  0x72, 0x82, 0x16, 0xBD, 0xA8, 0x1D, 0xA3, 0x77, 0x20, 0x50, 0xEF, 0x90, 0x77, 0x70, 0x4B, 0x83,
  0xA2, 0x01, 0x9B, 0x03, 0x76, 0x0D, 0xA0, 0xC5, 0x0C, 0xA0, 0x97, 0x50, 0x3B, 0x05, 0x50, 0x7A,
  0x0B, 0x75, 0x06, 0xB0, 0x25, 0x06, 0xA0, 0xA7, 0x50, 0x7B, 0x01, 0x50, 0x8A, 0x08, 0x75, 0x06,
  0xB0, 0x15, 0x0C, 0xA0, 0x27, 0x50, 0x4B, 0x03, 0x40, 0x5A, 0x08, 0x77, 0xB0, 0x63, 0x05, 0xA0,
  0x77, 0x71, 0x0A, 0xA8, 0x5C, 0x01, 0xAF, 0xA2, 0x77, 0x20, 0x3B, 0x82, 0xAE, 0x92, 0x40, 0xB8,
  0x01, 0xE0, 0x76, 0x07, 0x0E, 0xC0, 0x66, 0x0E, 0xD0, 0x54, 0x04, 0x0D, 0xE0, 0xD5, 0x02, 0xB0,
  0x90, 0x35, 0x08, 0xB8, 0x1C, 0x2A, 0xB0, 0x74, 0x06, 0xA0, 0x86, 0x08, 0xB0, 0x92, 0x02, 0xB0,
  0xE0, 0x13, 0x81, 0xAF, 0xE6, 0x04, 0xB0, 0xA4, 0x08, 0xB0, 0x83, 0x81, 0xEF, 0x76, 0x0D, 0xA0,
  0xE0, 0x15, 0x0E, 0xB8, 0x11, 0x03, 0xA0, 0x15, 0x03, 0xB0, 0x96, 0x06, 0xB8, 0x39, 0x09, 0xFA,
  0x60, 0x7B, 0x05, 0x70, 0xCB, 0x82, 0x3E, 0xF3, 0x60, 0x9B, 0x03, 0x70, 0x4B, 0x81, 0xDF, 0xA7,
  0x09, 0xB0, 0x27, 0x10, 0xAC, 0x03, 0x70, 0x8B, 0x02, 0x71, 0x02, 0xB0, 0xE0, 0x17, 0x06, 0xB0,
  0x57, 0x20, 0xAB, 0x09, 0x70, 0x1B, 0x0A, 0x71, 0x05, 0xD0, 0x37, 0x0A, 0xB0, 0x36, 0x07, 0xA0,
  0x9B, 0x0C, 0x70, 0x10, 0xEA, 0x0E, 0x06, 0x28, 0x61, 0x5C, 0xFE, 0x40, 0xCB, 0x0B, 0x02, 0x60,
  0x20, 0xDF, 0x90, 0xB0, 0x22, 0x05, 0xE0, 0x36, 0x86, 0x5B, 0xDF, 0xED, 0x94, 0x50, 0xCD, 0x30,
  // "'" (U+0027)
  0x2F, 0xFF, 0x94, 0xFF, 0xF4, 0x5F, 0xFE, 0x07, 0xFF, 0x80, 0x9F, 0xF3, 0x0A, 0xFD, 0x00, 0xCF,
  0x80, 0x0D, 0xF2, 0x00, 0xFC, 0x00, 0x00,
  // "(" (U+0028)
  0x76, 0x01, 0x74, 0x02, 0x0A, 0x97, 0x30, 0x8A, 0x09, 0x71, 0x01, 0x0C, 0xA0, 0x67, 0x10, 0x10,
  0xDA, 0x04, 0x72, 0x0C, 0xA0, 0x67, 0x20, 0xBA, 0x09, 0x72, 0x07, 0xA0, 0xD0, 0x17, 0x10, 0x10,
  0xEA, 0x05, 0x72, 0x0B, 0xA0, 0xD7, 0x20, 0x3B, 0x05, 0x72, 0x0A, 0xA0, 0xE7, 0x20, 0x1B, 0x09,
  0x72, 0x07, 0xB0, 0x37, 0x20, 0xCA, 0x0E, 0x72, 0x01, 0xB0, 0x97, 0x20, 0x6B, 0x05, 0x72, 0x09,
  0xB0, 0x27, 0x20, 0xCA, 0x0E, 0x73, 0x0E, 0xA0, 0xB7, 0x20, 0x1B, 0x09, 0x72, 0x03, 0xB0, 0x77,
  0x20, 0x4B, 0x05, 0x72, 0x05, 0xB0, 0x47, 0x20, 0x5B, 0x03, 0x72, 0x04, 0xB0, 0x37, 0x20, 0x3B,
  0x04, 0x72, 0x01, 0xB0, 0x57, 0x30, 0xDA, 0x06, 0x73, 0x09, 0xA0, 0x97, 0x30, 0x4A, 0x0D, 0x74,
  0x0D, 0xA0, 0x37, 0x30, 0x4A, 0x0A, 0x74, 0x09, 0xA0, 0x57, 0x48, 0x19, 0xFE, 0x75, 0x06, 0x0B,
  0x70,
  // ")" (U+0029)
  0x70, 0x50, 0x87, 0x58, 0x28, 0xFD, 0x27, 0x38, 0x31, 0xDF, 0xD1, 0x73, 0x04, 0xA0, 0xA7, 0x40,
  0xCA, 0x03, 0x73, 0x07, 0xA0, 0xA7, 0x30, 0x3A, 0x0E, 0x74, 0xB0, 0x47, 0x30, 0xDA, 0x07, 0x73,
  0x0C, 0xA0, 0x97, 0x30, 0xCA, 0x0A, 0x73, 0x0C, 0xA0, 0xB7, 0x30, 0xDA, 0x0B, 0x73, 0x0E, 0xA0,
  0xA7, 0x3B, 0x09, 0x72, 0x02, 0xB0, 0x87, 0x20, 0x5B, 0x05, 0x72, 0x07, 0xB0, 0x37, 0x20, 0xBB,
  0x73, 0x0E, 0xA0, 0xC7, 0x20, 0x3B, 0x07, 0x72, 0x07, 0xB0, 0x37, 0x20, 0xCA, 0x0E, 0x72, 0x02,
  0xB0, 0x87, 0x20, 0x8B, 0x01, 0x72, 0x0E, 0xA0, 0xA7, 0x20, 0x6B, 0x02, 0x72, 0x0D, 0xA0, 0x87,
  0x20, 0x8A, 0x0D, 0x72, 0x02, 0xB0, 0x37, 0x10, 0x10, 0xDA, 0x05, 0x72, 0x0B, 0xA0, 0x77, 0x10,
  0x10, 0xBA, 0x06, 0x71, 0x83, 0x3E, 0xFD, 0x37, 0x28, 0x19, 0xE7, 0x74, 0x03, 0x76,
  // "*" (U+002A)
  0x71, 0x07, 0x03, 0x77, 0xA0, 0xD7, 0x81, 0x3D, 0x12, 0x01, 0xA0, 0x87, 0x81, 0xCF, 0xB2, 0x02,
  0xA0, 0x26, 0x04, 0xB8, 0x39, 0x03, 0xFC, 0x40, 0x23, 0x03, 0x0D, 0xA8, 0x27, 0x4F, 0x62, 0x81,
  0x6C, 0xD5, 0x08, 0xA8, 0x3A, 0xE4, 0x9E, 0xB0, 0x15, 0x03, 0x0D, 0xF9, 0x84, 0x32, 0x8A, 0xBD,
  0xC8, 0x6C, 0x65, 0x32, 0x10, 0x3C, 0x85, 0xE9, 0xFE, 0xFA, 0x14, 0x01, 0xA8, 0x90, 0xD6, 0x05,
  0xF4, 0xDF, 0xE6, 0x40, 0x90, 0x43, 0x83, 0xBF, 0x22, 0xEA, 0x0B, 0x01, 0x60, 0x1A, 0x81, 0x10,
  0x3A, 0x0E, 0x01, 0x60, 0x7A, 0x38, 0x15, 0xF5, 0x78, 0x1D, 0xFE, 0x40, 0x37, 0x18, 0x17, 0xBD,
  0x71,
  // "+" (U+002B)
  0x68, 0x17, 0xFD, 0x75, 0x81, 0x7F, 0xD7, 0x58, 0x17, 0xFD, 0x75, 0x81, 0x7F, 0xD7, 0x58, 0x17,
  0xFD, 0x75, 0x81, 0x7F, 0xD7, 0x58, 0x17, 0xFD, 0x60, 0x88, 0x01, 0xEB, 0x80, 0x2E, 0x09, 0xFF,
  0x68, 0x17, 0xFD, 0x75, 0x81, 0x7F, 0xD7, 0x58, 0x17, 0xFD, 0x75, 0x81, 0x7F, 0xD7, 0x58, 0x17,
  0xFD, 0x75, 0x81, 0x7F, 0xD7, 0x58, 0x17, 0xFD, 0x75, 0x81, 0x7F, 0xD6,
  // "," (U+002C)
  0x28, 0x26, 0xED, 0x52, 0x01, 0xC8, 0x12, 0x03, 0xC8, 0x27, 0x01, 0xEB, 0x08, 0x20, 0x30, 0xEA,
  0x07, 0x30, 0x5A, 0x04, 0x38, 0x15, 0xFD, 0x48, 0x1C, 0xF5, 0x28, 0x23, 0xCF, 0x82, 0x82, 0xBF,
  0xE6, 0x38, 0x1C, 0x71, 0x40,
  // "-" (U+002D)
  0x10, 0x98, 0x04, 0xE8, 0x13, 0x0D, 0xF9, 0x10, 0x1F, 0x90, 0xC1,
  // "." (U+002E)
  0x1A, 0xEC, 0x1A, 0xFF, 0xF9, 0xEF, 0xFF, 0x9E, 0xFF, 0xF5, 0x5D, 0xE8, 0x00,
  // "/" (U+002F)
  0x77, 0x18, 0x15, 0xFE, 0x77, 0x18, 0x1C, 0xF7, 0x77, 0x03, 0xA0, 0x17, 0x78, 0x1A, 0xFA, 0x77,
  0x01, 0xA0, 0x37, 0x78, 0x18, 0xFC, 0x77, 0x18, 0x1E, 0xF5, 0x77, 0x81, 0x5F, 0xD7, 0x71, 0x81,
  0xCF, 0x77, 0x70, 0x3A, 0x01, 0x77, 0x81, 0xAF, 0x97, 0x70, 0x1A, 0x03, 0x77, 0x81, 0x8F, 0xB7,
  0x71, 0x81, 0xEF, 0x57, 0x78, 0x16, 0xFD, 0x77, 0x18, 0x1C, 0xF7, 0x77, 0x82, 0x3F, 0xE1, 0x77,
  0x81, 0xAF, 0x97, 0x70, 0x1A, 0x02, 0x77, 0x81, 0x8F, 0xB7, 0x71, 0x81, 0xEF, 0x47, 0x78, 0x16,
  0xFD, 0x77, 0x18, 0x1C, 0xF6, 0x77, 0x81, 0x4F, 0xE7, 0x71, 0x81, 0xAF, 0x97, 0x70, 0x1A, 0x02,
  0x77, 0x81, 0x8F, 0xB7, 0x71, 0x81, 0xEF, 0x47, 0x78, 0x16, 0xFD, 0x77, 0x18, 0x1C, 0xF6, 0x77,
  0x81, 0x4F, 0xE7, 0x71, 0x81, 0xAF, 0x87, 0x70, 0x2A, 0x02, 0x77, 0x81, 0x8F, 0xA7, 0x71, 0x81,
  0xEF, 0x47, 0x78, 0x12, 0x77, 0x77, 0x10,
  // "0" (U+0030)
  0x71, 0x85, 0x29, 0xDF, 0xEB, 0x57, 0x40, 0x7F, 0x0B, 0x72, 0x09, 0xA8, 0x3B, 0x20, 0x2C, 0xA0,
  0xA7, 0x07, 0xA0, 0xB4, 0x01, 0xB0, 0x45, 0x03, 0xA0, 0xE0, 0x15, 0x0B, 0xA0, 0xA5, 0x0C, 0xA0,
  0x76, 0x07, 0xA0, 0xE4, 0x04, 0xA0, 0xE7, 0x05, 0xB0, 0x13, 0x0B, 0xA0, 0x97, 0x05, 0xB0, 0x22,
  0x02, 0xB0, 0x47, 0x05, 0xB0, 0x22, 0x08, 0xA0, 0xE7, 0x10, 0x5B, 0x02, 0x20, 0xCA, 0x0B, 0x71,
  0x06, 0xB8, 0x11, 0x01, 0xB0, 0x77, 0x10, 0x8B, 0x20, 0x5B, 0x03, 0x71, 0x09, 0xA0, 0xE2, 0x08,
  0xB7, 0x20, 0xBA, 0x0C, 0x20, 0xBA, 0x0D, 0x72, 0x0D, 0xA0, 0x92, 0x0D, 0xA0, 0xB7, 0x10, 0x1B,
  0x06, 0x2B, 0x09, 0x71, 0x04, 0xB8, 0x13, 0x01, 0xB0, 0x87, 0x10, 0x7A, 0x0E, 0x20, 0x2B, 0x07,
  0x71, 0x0B, 0xA0, 0xA2, 0x03, 0xB0, 0x67, 0x10, 0xEA, 0x05, 0x20, 0x3B, 0x05, 0x70, 0x4A, 0x0E,
  0x30, 0x2B, 0x05, 0x70, 0x9A, 0x09, 0x4B, 0x06, 0x70, 0xEA, 0x02, 0x40, 0xDA, 0x08, 0x60, 0x7A,
  0x09, 0x50, 0x9A, 0x0B, 0x58, 0x31, 0xEF, 0xE1, 0x50, 0x2B, 0x02, 0x40, 0xAA, 0x05, 0x70, 0x9A,
  0x83, 0xD3, 0x02, 0xAA, 0x07, 0x72, 0x0A, 0xF0, 0x67, 0x48, 0x55, 0xBE, 0xFD, 0x92, 0x71,
  // "1" (U+0031)
  0x74, 0x82, 0x5E, 0xFB, 0x73, 0x09, 0xB0, 0x87, 0x10, 0x20, 0xCC, 0x05, 0x78, 0x27, 0xFE, 0xAB,
  0x02, 0x48, 0x51, 0x7D, 0xFE, 0x3B, 0xA0, 0xE4, 0x01, 0xB0, 0xE0, 0x31, 0xB0, 0xB5, 0x84, 0xDF,
  0xC2, 0x03, 0xB0, 0x76, 0x02, 0x30, 0x6B, 0x04, 0x73, 0x0A, 0xB0, 0x17, 0x30, 0xDA, 0x0D, 0x73,
  0x01, 0xB0, 0xA7, 0x30, 0x4B, 0x06, 0x73, 0x07, 0xB0, 0x37, 0x30, 0xAB, 0x74, 0x0E, 0xA0, 0xC7,
  0x30, 0x1B, 0x09, 0x73, 0x05, 0xB0, 0x57, 0x30, 0x8B, 0x02, 0x73, 0x0B, 0xA0, 0xE7, 0x40, 0xEA,
  0x0B, 0x73, 0x02, 0xB0, 0x87, 0x30, 0x6B, 0x04, 0x73, 0x09, 0xB0, 0x17, 0x30, 0xCA, 0x0D, 0x74,
  0xB0, 0xA7, 0x30, 0x6B, 0x09, 0x72, 0x05, 0x0E, 0xB0, 0xD0, 0x24, 0x81, 0x4E, 0xEF, 0xA8, 0x2E,
  0xA0, 0x6F, 0xD0, 0x81,
  // "2" (U+0032)
  0x72, 0x86, 0x5A, 0xDE, 0xFE, 0xB6, 0x73, 0x03, 0x0D, 0xF9, 0x0D, 0x02, 0x70, 0x4B, 0x0D, 0x04,
  0x20, 0x6B, 0x0C, 0x70, 0xDA, 0x0D, 0x01, 0x40, 0xAB, 0x05, 0x50, 0x5B, 0x05, 0x50, 0x4B, 0x09,
  0x50, 0x7A, 0x0D, 0x60, 0x2B, 0x0A, 0x50, 0x4A, 0x08, 0x60, 0x2B, 0x09, 0x68, 0x17, 0xD4, 0x60,
  0x4B, 0x07, 0x77, 0x10, 0x7B, 0x03, 0x77, 0x10, 0xBA, 0x0D, 0x77, 0x10, 0x2B, 0x05, 0x77, 0x10,
  0xAA, 0x0B, 0x77, 0x10, 0x4A, 0x0E, 0x01, 0x77, 0x01, 0x0D, 0xA0, 0x47, 0x71, 0x0B, 0xA0, 0x57,
  0x71, 0x09, 0xA0, 0x67, 0x71, 0x07, 0xA0, 0x77, 0x71, 0x07, 0xA0, 0x77, 0x71, 0x06, 0xA0, 0x67,
  0x71, 0x06, 0xA0, 0x67, 0x71, 0x06, 0xA0, 0x77, 0x71, 0x05, 0xA0, 0x77, 0x71, 0x05, 0xA0, 0x77,
  0x81, 0x3A, 0x35, 0x05, 0xA0, 0x87, 0x18, 0x1B, 0xF1, 0x40, 0x4A, 0x08, 0x71, 0x81, 0x4F, 0xD4,
  0x04, 0xA0, 0x87, 0x83, 0x15, 0xEF, 0x94, 0x0B, 0xFF, 0x05, 0x4F, 0xF9, 0x01, 0x30, 0x3F, 0xF0,
  0xD4,
  // "3" (U+0033)
  0x71, 0x86, 0x38, 0xCE, 0xFE, 0xB6, 0x72, 0x01, 0x0A, 0xF9, 0x0D, 0x02, 0x60, 0x20, 0xDA, 0x0D,
  0x05, 0x20, 0x40, 0xEA, 0x0E, 0x01, 0x50, 0xBA, 0x0E, 0x02, 0x40, 0x6B, 0x07, 0x40, 0x2B, 0x07,
  0x50, 0x1B, 0x0B, 0x40, 0x4B, 0x01, 0x6B, 0x0C, 0x40, 0x2A, 0x0B, 0x60, 0x1B, 0x0B, 0x58, 0x15,
  0xB6, 0x60, 0x3B, 0x08, 0x77, 0x08, 0xB0, 0x37, 0x70, 0xDA, 0x0B, 0x77, 0x09, 0xA0, 0xE0, 0x27,
  0x60, 0x9A, 0x0E, 0x03, 0x74, 0x81, 0x27, 0xDA, 0x0B, 0x02, 0x72, 0x02, 0xD0, 0x90, 0x37, 0x40,
  0x50, 0xED, 0x0B, 0x02, 0x76, 0x02, 0x08, 0xB0, 0xE0, 0x37, 0x70, 0x5B, 0x0D, 0x77, 0x10, 0xBB,
  0x05, 0x77, 0x06, 0xB0, 0x87, 0x70, 0x4B, 0x09, 0x77, 0x04, 0xB0, 0x87, 0x70, 0x6B, 0x07, 0x30,
  0x80, 0xD7, 0x20, 0x9B, 0x03, 0x20, 0x7A, 0x01, 0x71, 0x0E, 0xA0, 0xD3, 0x0C, 0xA0, 0x67, 0x07,
  0xB0, 0x63, 0x0C, 0xA0, 0xD0, 0x15, 0x04, 0x0E, 0xA0, 0xB4, 0x06, 0xB0, 0xC0, 0x32, 0x02, 0x08,
  0xB0, 0xB6, 0x09, 0xFA, 0x0E, 0x07, 0x71, 0x87, 0x39, 0xDE, 0xFE, 0xDA, 0x57, 0x10,
  // "4" (U+0034)
  0x77, 0x08, 0xB0, 0x57, 0x60, 0x4C, 0x01, 0x75, 0x01, 0x0E, 0xB0, 0xE7, 0x68, 0x1B, 0xFE, 0xA0,
  0xB7, 0x58, 0x28, 0xFB, 0xEA, 0x07, 0x74, 0x82, 0x4F, 0xE5, 0xB0, 0x47, 0x38, 0x31, 0xEF, 0x67,
  0xB0, 0x17, 0x38, 0x3B, 0xFB, 0x0B, 0xA0, 0xD7, 0x38, 0x47, 0xFE, 0x10, 0xEA, 0x0A, 0x72, 0x03,
  0xA8, 0x14, 0x02, 0xB0, 0x77, 0x18, 0x21, 0xDF, 0x82, 0x06, 0xB0, 0x37, 0x18, 0x1A, 0xFB, 0x30,
  0x9B, 0x71, 0x82, 0x6F, 0xE1, 0x30, 0xCA, 0x0D, 0x70, 0x2A, 0x03, 0x4B, 0x09, 0x78, 0x1D, 0xF7,
  0x40, 0x3B, 0x06, 0x68, 0x19, 0xFA, 0x50, 0x6B, 0x03, 0x58, 0x25, 0xFD, 0x15, 0x09, 0xB5, 0x82,
  0x2E, 0xF3, 0x60, 0xDA, 0x0C, 0x58, 0x1C, 0xF8, 0x80, 0x21, 0x02, 0xB8, 0x4A, 0x11, 0x11, 0x7F,
  0xFB, 0x07, 0x0C, 0xFF, 0xB0, 0x47, 0x30, 0xAA, 0x0E, 0x77, 0x10, 0xDA, 0x0B, 0x77, 0x01, 0xB0,
  0x87, 0x70, 0x4B, 0x04, 0x77, 0x0A, 0xB0, 0x37, 0x50, 0x10, 0x8C, 0x08, 0x72, 0x03, 0x0E, 0xFA,
  0x0E, 0x03, 0x60, 0x5F, 0xC3,
  // "5" (U+0035)
  0x70, 0x5F, 0xC0, 0x77, 0x09, 0xFC, 0x04, 0x70, 0xDF, 0xC0, 0x16, 0x81, 0x2F, 0x97, 0x81, 0x3F,
  0xE7, 0x81, 0x7F, 0x57, 0x19, 0x0B, 0x78, 0x1B, 0xF1, 0x78, 0x11, 0xF8, 0x79, 0x0D, 0x77, 0x38,
  0x14, 0xF9, 0x77, 0x38, 0x18, 0xF5, 0x77, 0x38, 0x1D, 0xF1, 0x77, 0x28, 0x11, 0xFD, 0x77, 0x38,
  0x16, 0xF9, 0x77, 0x38, 0x90, 0xAF, 0xAB, 0xDE, 0xDB, 0x71, 0x73, 0x0E, 0xFA, 0x06, 0x71, 0x87,
  0x1C, 0xB5, 0x10, 0x16, 0xEB, 0x06, 0x77, 0x10, 0x3B, 0x0E, 0x01, 0x77, 0x10, 0x9B, 0x05, 0x77,
  0x10, 0x4B, 0x09, 0x77, 0x10, 0x2B, 0x0A, 0x77, 0x10, 0x2B, 0x0A, 0x77, 0x10, 0x3B, 0x09, 0x77,
  0x10, 0x5B, 0x06, 0x48, 0x11, 0x62, 0x71, 0x08, 0xB0, 0x23, 0x82, 0x1E, 0xF5, 0x71, 0x0D, 0xA0,
  0xB4, 0x05, 0xA0, 0x97, 0x06, 0xB0, 0x34, 0x05, 0xA0, 0xE0, 0x15, 0x03, 0x0E, 0xA0, 0x75, 0x01,
  0xB0, 0xC0, 0x32, 0x02, 0x08, 0xB0, 0x87, 0x05, 0xFA, 0x0D, 0x05, 0x72, 0x87, 0x28, 0xCE, 0xFE,
  0xDA, 0x57, 0x20,
  // "6" (U+0036)
  0x72, 0x86, 0x39, 0xCE, 0xFD, 0xA4, 0x73, 0x0A, 0xF9, 0x06, 0x70, 0x20, 0xDA, 0x83, 0x92, 0x01,
  0xCB, 0x01, 0x50, 0x20, 0xDA, 0x05, 0x40, 0x5B, 0x03, 0x50, 0xDA, 0x07, 0x50, 0x2A, 0x0E, 0x50,
  0x9A, 0x0C, 0x68, 0x21, 0xFE, 0x44, 0x03, 0xB0, 0x47, 0x02, 0x60, 0xBA, 0x0C, 0x77, 0x03, 0xB0,
  0x57, 0x70, 0x9A, 0x0E, 0x77, 0x10, 0xEA, 0x0A, 0x77, 0x05, 0xB8, 0x65, 0x06, 0xBD, 0xDB, 0x67,
  0x09, 0xB0, 0x50, 0xDE, 0x0B, 0x60, 0xCC, 0x83, 0xC5, 0x10, 0x7B, 0x08, 0x5C, 0x08, 0x50, 0xAA,
  0x0E, 0x01, 0x30, 0x3B, 0x08, 0x60, 0x4B, 0x05, 0x30, 0x5B, 0x04, 0x60, 0x1B, 0x08, 0x30, 0x7B,
  0x02, 0x7B, 0x09, 0x30, 0x8B, 0x71, 0xB0, 0x93, 0x08, 0xA0, 0xE7, 0x01, 0xB0, 0x83, 0x09, 0xA0,
  0xD7, 0x03, 0xB0, 0x53, 0x08, 0xA0, 0xD7, 0x06, 0xB0, 0x23, 0x06, 0xA0, 0xE7, 0x0A, 0xA0, 0xD4,
  0x03, 0xB0, 0x15, 0x01, 0x0E, 0xA0, 0x85, 0x0E, 0xA0, 0x45, 0x07, 0xA0, 0xE0, 0x15, 0x08, 0xA0,
  0xB4, 0x02, 0xB0, 0x66, 0x01, 0x0E, 0xA0, 0x82, 0x05, 0x0E, 0xA0, 0x97, 0x10, 0x30, 0xEF, 0x07,
  0x73, 0x86, 0x17, 0xCE, 0xEC, 0x82, 0x71,
  // "7" (U+0037)
  0x20, 0x7F, 0xF9, 0x20, 0xBF, 0xF0, 0xA2, 0x0E, 0xFF, 0x84, 0x20, 0x3F, 0xD3, 0x71, 0x0A, 0xA0,
  0x92, 0x81, 0x6F, 0x47, 0x10, 0x3B, 0x02, 0x20, 0xA0, 0xE7, 0x20, 0xBA, 0x09, 0x30, 0xE0, 0xA7,
  0x10, 0x4B, 0x01, 0x30, 0x20, 0x17, 0x10, 0xCA, 0x08, 0x76, 0x05, 0xA0, 0xE0, 0x17, 0x60, 0xCA,
  0x08, 0x76, 0x05, 0xA0, 0xE0, 0x17, 0x60, 0xDA, 0x08, 0x76, 0x06, 0xA0, 0xE0, 0x17, 0x60, 0xEA,
  0x07, 0x76, 0x07, 0xA0, 0xE7, 0x60, 0x10, 0xEA, 0x07, 0x76, 0x08, 0xA0, 0xE7, 0x60, 0x10, 0xEA,
  0x07, 0x76, 0x08, 0xA0, 0xE7, 0x60, 0x1B, 0x06, 0x76, 0x09, 0xA0, 0xD7, 0x60, 0x2B, 0x06, 0x76,
  0x0A, 0xA0, 0xD7, 0x60, 0x3B, 0x05, 0x76, 0x0B, 0xA0, 0xD7, 0x60, 0x3B, 0x05, 0x76, 0x0B, 0xA0,
  0xC7, 0x60, 0x4B, 0x05, 0x76, 0x0C, 0xA0, 0xC7, 0x70,
  // "8" (U+0038)
  0x71, 0x82, 0x17, 0xBE, 0xA8, 0x1D, 0xA3, 0x73, 0x06, 0xFA, 0x08, 0x71, 0x08, 0xB0, 0x90, 0x22,
  0x06, 0xB0, 0x76, 0x04, 0xB0, 0x65, 0x07, 0xA0, 0xE6, 0x0B, 0xA0, 0xC6, 0x01, 0xB0, 0x44, 0x01,
  0xB0, 0x67, 0x0E, 0xA0, 0x54, 0x04, 0xB0, 0x37, 0x0E, 0xA0, 0x54, 0x06, 0xB0, 0x26, 0x01, 0xB0,
  0x34, 0x05, 0xB0, 0x46, 0x05, 0xA0, 0xE5, 0x03, 0xB0, 0x86, 0x0B, 0xA0, 0x66, 0x0D, 0xA0, 0xE0,
  0x14, 0x06, 0xA0, 0xA7, 0x07, 0xB0, 0xC0, 0x12, 0x07, 0xA0, 0x97, 0x20, 0xCB, 0x84, 0xD5, 0xCF,
  0xE5, 0x73, 0x01, 0x0D, 0xD0, 0x97, 0x50, 0x20, 0xAD, 0x0E, 0x03, 0x72, 0x01, 0x09, 0xA8, 0x1B,
  0x6E, 0xC0, 0x47, 0x83, 0x4E, 0xFE, 0x42, 0x01, 0x0B, 0xB0, 0xE0, 0x25, 0x05, 0xA0, 0xE0, 0x35,
  0x0A, 0xB0, 0xA4, 0x03, 0xB0, 0x47, 0x0D, 0xB4, 0x0A, 0xA0, 0xB7, 0x10, 0x7B, 0x03, 0x3B, 0x06,
  0x71, 0x04, 0xB0, 0x42, 0x02, 0xB0, 0x47, 0x10, 0x3B, 0x03, 0x20, 0x3B, 0x03, 0x71, 0x04, 0xB0,
  0x12, 0x03, 0xB0, 0x47, 0x10, 0x8A, 0x0D, 0x40, 0xEA, 0x08, 0x71, 0x0E, 0xA0, 0x74, 0x09, 0xA0,
  0xE0, 0x26, 0x0A, 0xA0, 0xC5, 0x01, 0x0D, 0xA0, 0xD0, 0x52, 0x81, 0x15, 0xDA, 0x0D, 0x01, 0x60,
  0x10, 0xBF, 0xA0, 0xA0, 0x17, 0x28, 0x74, 0x9D, 0xEF, 0xDC, 0x72, 0x70,
  // "9" (U+0039)
  0x71, 0x85, 0x5A, 0xDF, 0xEB, 0x57, 0x20, 0x40, 0xDF, 0x0B, 0x70, 0x6B, 0x83, 0x92, 0x03, 0xDA,
  0x09, 0x50, 0x5B, 0x07, 0x40, 0x3B, 0x02, 0x30, 0x10, 0xEA, 0x0B, 0x60, 0xCA, 0x08, 0x30, 0x9B,
  0x02, 0x60, 0x9A, 0x0B, 0x20, 0x1B, 0x0B, 0x70, 0x9A, 0x0C, 0x20, 0x5B, 0x06, 0x70, 0x9A, 0x0D,
  0x20, 0x8B, 0x02, 0x70, 0xAA, 0x0C, 0x20, 0xBB, 0x71, 0x0C, 0xA0, 0xB2, 0x0C, 0xA0, 0xE7, 0x10,
  0xEA, 0x0A, 0x20, 0xBA, 0x0E, 0x70, 0x3B, 0x08, 0x20, 0x9B, 0x70, 0xCB, 0x05, 0x20, 0x5B, 0x06,
  0x50, 0xAC, 0x02, 0x30, 0xDA, 0x85, 0xE6, 0x10, 0x4C, 0xEB, 0x0E, 0x40, 0x20, 0xEE, 0x0C, 0x04,
  0xB0, 0xB5, 0x87, 0x18, 0xCE, 0xDB, 0x50, 0x6B, 0x07, 0x76, 0x0A, 0xB0, 0x27, 0x60, 0xEA, 0x0D,
  0x76, 0x05, 0xB0, 0x77, 0x60, 0xAB, 0x01, 0x75, 0x01, 0xB0, 0x95, 0x03, 0x70, 0x7B, 0x01, 0x40,
  0x0D, 0x70, 0xEA, 0x07, 0x40, 0x6A, 0x60, 0x9A, 0x0C, 0x50, 0x8A, 0x05, 0x40, 0x5A, 0x0E, 0x02,
  0x50, 0x5A, 0x83, 0xE4, 0x01, 0x7A, 0x0E, 0x02, 0x70, 0xCF, 0x0B, 0x01, 0x72, 0x85, 0x7C, 0xEF,
  0xDA, 0x47, 0x20,
  // ":" (U+003A)
  0x48, 0x22, 0xCE, 0xA5, 0x0C, 0xB0, 0x63, 0x01, 0xC0, 0x63, 0x01, 0xC0, 0x24, 0x82, 0x7E, 0xD6,
  0x80, 0x9D, 0x20, 0x82, 0x8E, 0xD3, 0x40, 0x6B, 0x0C, 0x40, 0xAB, 0x0C, 0x40, 0xAB, 0x08, 0x48,
  0x22, 0xCE, 0xA5,
  // ";" (U+003B)
  0x68, 0x22, 0xCE, 0xA7, 0x0C, 0xB0, 0x65, 0x01, 0xC0, 0x65, 0x01, 0xC0, 0x26, 0x82, 0x7E, 0xD5,
  0x80, 0x9F, 0x00, 0x83, 0x1A, 0xEB, 0x26, 0x08, 0xB0, 0xC6, 0x0A, 0xC0, 0x15, 0x06, 0xC0, 0x36,
  0x08, 0xB0, 0x17, 0x81, 0xBF, 0xD7, 0x18, 0x1C, 0xF8, 0x78, 0x23, 0xFD, 0x16, 0x82, 0x6E, 0xE3,
  0x58, 0x33, 0xEF, 0xC2, 0x68, 0x15, 0xA4, 0x71,
  // "<" (U+003C)
  0x76, 0x03, 0x0C, 0x74, 0x01, 0x09, 0xA7, 0x30, 0x50, 0xEA, 0x0B, 0x71, 0x01, 0x0B, 0xA0, 0xE0,
  0x67, 0x10, 0x70, 0xEA, 0x0A, 0x01, 0x70, 0x30, 0xCA, 0x0D, 0x04, 0x71, 0x08, 0xB0, 0x97, 0x10,
  0x40, 0xDA, 0x0D, 0x03, 0x70, 0x10, 0xAB, 0x08, 0x72, 0x09, 0xA0, 0xE0, 0x27, 0x30, 0x50, 0xEA,
  0x0B, 0x02, 0x73, 0x02, 0x0B, 0xB0, 0x77, 0x40, 0x50, 0xEA, 0x0C, 0x03, 0x73, 0x01, 0x09, 0xB0,
  0x97, 0x40, 0x30, 0xCA, 0x0D, 0x04, 0x74, 0x07, 0x0E, 0xA0, 0xA0, 0x17, 0x30, 0x20, 0xBA, 0x0E,
  0x06, 0x74, 0x05, 0x0E, 0xA7, 0x50, 0x10, 0x99, 0x77, 0x03,
  // "=" (U+003D)
  0x08, 0x80, 0x92, 0xE0, 0x10, 0x9F, 0xF0, 0x18, 0x09, 0xB4, 0x00, 0x88, 0x09, 0x2E, 0x01, 0x09,
  0xFF, 0x01,
  // ">" (U+003E)
  0x08, 0x07, 0x76, 0x82, 0x9F, 0xD4, 0x74, 0x05, 0x0E, 0xA0, 0x90, 0x17, 0x30, 0x20, 0xBA, 0x0E,
  0x05, 0x74, 0x05, 0x0E, 0xA0, 0xB0, 0x27, 0x30, 0x10, 0xAB, 0x07, 0x74, 0x04, 0x0D, 0xA0, 0xC0,
  0x37, 0x40, 0x9B, 0x09, 0x01, 0x73, 0x03, 0x0D, 0xA0, 0xE0, 0x57, 0x40, 0x9B, 0x73, 0x07, 0x0E,
  0xA0, 0xB7, 0x10, 0x30, 0xCA, 0x0E, 0x05, 0x71, 0x08, 0xB0, 0x90, 0x17, 0x04, 0x0D, 0xA0, 0xD0,
  0x37, 0x01, 0x0A, 0xB0, 0x77, 0x10, 0x60, 0xEA, 0x0B, 0x02, 0x70, 0x20, 0xBA, 0x0E, 0x05, 0x72,
  0x09, 0xA0, 0x90, 0x17, 0x38, 0x19, 0xD3, 0x75, 0x03, 0x77,
  // "?" (U+003F)
  0x48, 0x64, 0x9D, 0xEF, 0xDB, 0x55, 0x01, 0x0B, 0xF9, 0x0C, 0x01, 0x20, 0x10, 0xDA, 0x0D, 0x04,
  0x20, 0x7B, 0x0B, 0x20, 0x9A, 0x0E, 0x02, 0x40, 0xAB, 0x81, 0x40, 0xEA, 0x08, 0x50, 0x4B, 0x08,
  0x1B, 0x03, 0x50, 0x1B, 0x83, 0xA0, 0xBF, 0xE6, 0x01, 0xB8, 0x3A, 0x01, 0x77, 0x60, 0x2B, 0x09,
  0x73, 0x06, 0xB0, 0x67, 0x30, 0xBB, 0x01, 0x72, 0x04, 0xB0, 0x87, 0x20, 0x20, 0xEA, 0x0C, 0x72,
  0x02, 0x0D, 0xA0, 0xD0, 0x17, 0x10, 0x6B, 0x0C, 0x01, 0x70, 0x40, 0xCB, 0x07, 0x71, 0x05, 0xB0,
  0x90, 0x27, 0x28, 0x28, 0xFE, 0x27, 0x48, 0x1A, 0xFA, 0x75, 0x81, 0xCF, 0x67, 0x58, 0x1E, 0xF2,
  0x74, 0x81, 0x1E, 0xC8, 0x0E, 0x40, 0x82, 0x4D, 0xE8, 0x73, 0x01, 0x0E, 0xB0, 0x27, 0x20, 0x5C,
  0x02, 0x72, 0x04, 0xB0, 0xE7, 0x48, 0x2A, 0xEC, 0x37, 0x30,
  // "@" (U+0040)
  0x75, 0x82, 0x49, 0xBE, 0xA8, 0x2E, 0xC9, 0x47, 0x73, 0x07, 0x0E, 0xFB, 0x0C, 0x04, 0x76, 0x04,
  0x0D, 0xA8, 0x1D, 0x83, 0x38, 0x11, 0x59, 0xB0, 0x77, 0x40, 0x8A, 0x0E, 0x06, 0x72, 0x02, 0x0C,
  0xA0, 0x77, 0x20, 0xAA, 0x0B, 0x01, 0x75, 0x0A, 0xA0, 0x47, 0x09, 0xA0, 0xA7, 0x71, 0x81, 0xDF,
  0xD6, 0x05, 0xA0, 0xB7, 0x72, 0x04, 0xA0, 0x54, 0x83, 0x1E, 0xFE, 0x14, 0x89, 0x01, 0x7C, 0xEF,
  0xD6, 0x02, 0x73, 0x81, 0xDF, 0xA4, 0x0A, 0xA0, 0x54, 0x03, 0x0E, 0xE8, 0x1C, 0xFA, 0x38, 0x19,
  0xFE, 0x30, 0x2A, 0x0B, 0x40, 0x5B, 0x83, 0x81, 0x04, 0xEA, 0x07, 0x30, 0x5A, 0x02, 0x20, 0x9A,
  0x04, 0x30, 0x20, 0xEA, 0x06, 0x40, 0xBA, 0x04, 0x30, 0x3A, 0x84, 0x40, 0x1E, 0xFD, 0x40, 0xCA,
  0x09, 0x50, 0xEA, 0x01, 0x30, 0x2A, 0x81, 0x50, 0x6A, 0x06, 0x30, 0x4B, 0x02, 0x40, 0x2A, 0x0D,
  0x40, 0x2A, 0x81, 0x60, 0xBA, 0x01, 0x30, 0xBA, 0x0A, 0x50, 0x5A, 0x0A, 0x40, 0x3A, 0x05, 0x1A,
  0x0C, 0x30, 0x1B, 0x04, 0x50, 0x8A, 0x07, 0x40, 0x3A, 0x04, 0x03, 0xA0, 0x93, 0x05, 0xB0, 0x15,
  0x0B, 0xA0, 0x44, 0x05, 0xA0, 0x20, 0x5A, 0x06, 0x30, 0x8A, 0x0C, 0x60, 0xEA, 0x01, 0x40, 0x8A,
  0x10, 0x7A, 0x04, 0x30, 0xAA, 0x0A, 0x50, 0x1A, 0x0D, 0x58, 0x3A, 0xFC, 0x08, 0xA0, 0x33, 0x0B,
  0xA0, 0x85, 0x05, 0xA0, 0xB5, 0x83, 0xEF, 0x80, 0x9A, 0x02, 0x30, 0xBA, 0x08, 0x50, 0x9A, 0x09,
  0x40, 0x4A, 0x81, 0x20, 0x9A, 0x02, 0x30, 0xAA, 0x09, 0x50, 0xEA, 0x09, 0x48, 0x1B, 0xFB, 0x20,
  0x9A, 0x03, 0x30, 0x6A, 0x0E, 0x48, 0x37, 0xED, 0xFB, 0x30, 0x5A, 0x03, 0x20, 0x8A, 0x04, 0x30,
  0x10, 0xEA, 0x85, 0xA1, 0x17, 0xF7, 0x5A, 0x84, 0x60, 0x5E, 0xF8, 0x30, 0x6A, 0x06, 0x40, 0x5E,
  0x0A, 0x20, 0xCD, 0x0A, 0x40, 0x3A, 0x09, 0x50, 0x30, 0xCA, 0x0E, 0x08, 0x30, 0x10, 0xAA, 0x0D,
  0x06, 0x68, 0x1E, 0xFD, 0x71, 0x01, 0x71, 0x01, 0x71, 0x0A, 0xA0, 0x37, 0x77, 0x40, 0x3A, 0x0B,
  0x77, 0x75, 0x0A, 0xA0, 0x67, 0x77, 0x40, 0x10, 0xEA, 0x04, 0x76, 0x81, 0x4D, 0x77, 0x20, 0x30,
  0xEA, 0x07, 0x73, 0x83, 0x3A, 0xFD, 0x47, 0x30, 0x30, 0xDA, 0x81, 0xE8, 0x34, 0x81, 0x36, 0xBA,
  0x09, 0x01, 0x76, 0x08, 0x0E, 0xFB, 0x0A, 0x02, 0x77, 0x28, 0x91, 0x15, 0xAD, 0xEF, 0xED, 0xB7,
  0x27, 0x40,
  // "A" (U+0041)
  0x77, 0x20, 0x4B, 0x01, 0x77, 0x60, 0xCB, 0x03, 0x77, 0x50, 0x4C, 0x05, 0x77, 0x50, 0xCC, 0x06,
  0x77, 0x48, 0x25, 0xF9, 0xEA, 0x08, 0x77, 0x48, 0x2D, 0xF3, 0xEA, 0x09, 0x77, 0x38, 0x36, 0xFB,
  0x0D, 0xA0, 0xB7, 0x73, 0x83, 0xEF, 0x30, 0xCA, 0x0C, 0x77, 0x28, 0x17, 0xFB, 0x20, 0xBA, 0x0E,
  0x77, 0x18, 0x21, 0xEF, 0x32, 0x0A, 0xB7, 0x71, 0x81, 0x8F, 0xA3, 0x09, 0xB0, 0x17, 0x68, 0x21,
  0xEF, 0x23, 0x07, 0xB0, 0x37, 0x68, 0x19, 0xF9, 0x40, 0x6B, 0x04, 0x75, 0x02, 0xA0, 0x24, 0x04,
  0xB0, 0x67, 0x58, 0x19, 0xF9, 0x50, 0x3B, 0x08, 0x74, 0x02, 0xA0, 0x15, 0x02, 0xB0, 0x97, 0x48,
  0x1A, 0xF8, 0x7B, 0x0B, 0x73, 0x03, 0xFE, 0x0C, 0x73, 0x0B, 0xFE, 0x0E, 0x72, 0x82, 0x4F, 0xE1,
  0x71, 0x0C, 0xB7, 0x28, 0x1C, 0xF8, 0x72, 0x0B, 0xB0, 0x17, 0x82, 0x5F, 0xE1, 0x72, 0x09, 0xB0,
  0x37, 0x81, 0xDF, 0x77, 0x30, 0x8B, 0x04, 0x68, 0x15, 0xFE, 0x74, 0x07, 0xB0, 0x66, 0x81, 0xDF,
  0x97, 0x40, 0x6B, 0x08, 0x50, 0x8A, 0x06, 0x74, 0x09, 0xB0, 0xB4, 0x06, 0xB0, 0xB0, 0x17, 0x20,
  0x5D, 0x81, 0x40, 0x9F, 0x0E, 0x60, 0xBF, 0x90, 0xD0, 0xCF, 0x0C, 0x60, 0xEF, 0x90, 0xB0,
  // "B" (U+0042)
  0x60, 0xCF, 0xA8, 0x3E, 0xDA, 0x61, 0x72, 0x09, 0x0B, 0xD0, 0x0E, 0xD0, 0xE0, 0x57, 0x30, 0x5B,
  0x0D, 0x30, 0x20, 0x8C, 0x05, 0x72, 0x03, 0xB0, 0x95, 0x07, 0xB0, 0xD7, 0x20, 0x6B, 0x06, 0x60,
  0xEB, 0x03, 0x71, 0x09, 0xB0, 0x36, 0x0C, 0xB0, 0x57, 0x10, 0xCB, 0x70, 0xBB, 0x05, 0x71, 0xB0,
  0xC7, 0x0C, 0xB0, 0x47, 0x03, 0xB0, 0x97, 0x0E, 0xB0, 0x17, 0x06, 0xB0, 0x66, 0x03, 0xB0, 0xC7,
  0x10, 0x9B, 0x03, 0x60, 0xAB, 0x04, 0x71, 0x0D, 0xB6, 0x06, 0xB0, 0x77, 0x2B, 0x0C, 0x38, 0x11,
  0x4A, 0xA0, 0xE0, 0x67, 0x20, 0x3F, 0xB8, 0x1D, 0x71, 0x73, 0x07, 0xC0, 0x0E, 0xD0, 0xA0, 0x27,
  0x30, 0xAB, 0x02, 0x38, 0x11, 0x7E, 0xA0, 0xE0, 0x37, 0x20, 0xDA, 0x0E, 0x60, 0x4B, 0x0D, 0x71,
  0x01, 0xB0, 0xB7, 0x0B, 0xB0, 0x47, 0x04, 0xB0, 0x87, 0x08, 0xB0, 0x77, 0x07, 0xB0, 0x47, 0x07,
  0xB0, 0x87, 0x0A, 0xB0, 0x17, 0x08, 0xB0, 0x87, 0x0D, 0xA0, 0xD7, 0x10, 0xAB, 0x06, 0x60, 0x1B,
  0x0A, 0x71, 0x0D, 0xB0, 0x36, 0x04, 0xB0, 0x77, 0x03, 0xB0, 0xE7, 0x08, 0xB0, 0x47, 0x0A, 0xB0,
  0x77, 0x0C, 0xB7, 0x07, 0xB0, 0xC7, 0x07, 0xB0, 0xC4, 0x81, 0x15, 0xBB, 0x0C, 0x01, 0x48, 0x14,
  0xAD, 0xD0, 0xFE, 0xD0, 0xE0, 0x86, 0x09, 0xFC, 0x82, 0xEC, 0x96, 0x71,
  // "C" (U+0043)
  0x73, 0x82, 0x27, 0xBD, 0xA8, 0x1E, 0xB7, 0x74, 0x02, 0x0A, 0xFA, 0x0E, 0x03, 0x71, 0x06, 0x0E,
  0xA0, 0xC0, 0x42, 0x02, 0x0B, 0xB0, 0xD7, 0x08, 0xB0, 0x75, 0x01, 0x0E, 0xB0, 0x45, 0x08, 0xB0,
  0x67, 0x0A, 0xB0, 0x54, 0x06, 0xB0, 0x97, 0x10, 0x7B, 0x02, 0x30, 0x2B, 0x0D, 0x72, 0x06, 0xA0,
  0x74, 0x0B, 0xB0, 0x47, 0x28, 0x12, 0x62, 0x40, 0x5B, 0x0C, 0x77, 0x30, 0xCB, 0x05, 0x77, 0x20,
  0x3B, 0x0E, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x30, 0xEB, 0x04, 0x77, 0x20, 0x3C, 0x77, 0x30, 0x6B,
  0x0C, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x30, 0xBB, 0x07, 0x77, 0x30, 0xCB, 0x05, 0x77, 0x30, 0xDB,
  0x04, 0x77, 0x30, 0xDB, 0x03, 0x77, 0x30, 0xBB, 0x03, 0x77, 0x30, 0xAB, 0x04, 0x77, 0x30, 0x6B,
  0x07, 0x77, 0x30, 0x2B, 0x0C, 0x74, 0x04, 0x60, 0xAB, 0x03, 0x72, 0x05, 0x0E, 0x60, 0x10, 0xEA,
  0x0D, 0x01, 0x78, 0x17, 0xFA, 0x70, 0x40, 0xEA, 0x81, 0xE7, 0x22, 0x84, 0x14, 0xBF, 0xE2, 0x71,
  0x02, 0x0C, 0xFA, 0x0C, 0x03, 0x74, 0x87, 0x49, 0xCE, 0xFE, 0xD9, 0x57, 0x10,
  // "D" (U+0044)
  0x60, 0xCF, 0xB8, 0x2D, 0xC8, 0x27, 0x40, 0x90, 0xCD, 0x00, 0xEE, 0x0A, 0x01, 0x74, 0x05, 0xB0,
  0xD4, 0x04, 0x0B, 0xB0, 0xD0, 0x27, 0x30, 0x3B, 0x09, 0x60, 0x7B, 0x0C, 0x73, 0x06, 0xB0, 0x67,
  0x0A, 0xB0, 0x77, 0x20, 0x9B, 0x03, 0x70, 0x2B, 0x0D, 0x72, 0x0C, 0xB7, 0x20, 0xCB, 0x03, 0x71,
  0xB0, 0xC7, 0x20, 0x9B, 0x07, 0x70, 0x3B, 0x09, 0x72, 0x06, 0xB0, 0x97, 0x06, 0xB0, 0x57, 0x20,
  0x6B, 0x0A, 0x70, 0x9B, 0x02, 0x72, 0x05, 0xB0, 0xB7, 0x0C, 0xA0, 0xE7, 0x30, 0x6B, 0x0A, 0x7B,
  0x0B, 0x73, 0x07, 0xB0, 0x96, 0x03, 0xB0, 0x87, 0x30, 0x8B, 0x08, 0x60, 0x7B, 0x05, 0x73, 0x0A,
  0xB0, 0x66, 0x0A, 0xB0, 0x17, 0x30, 0xDB, 0x03, 0x60, 0xDA, 0x0E, 0x73, 0x01, 0xC6, 0x01, 0xB0,
  0xB7, 0x30, 0x5B, 0x0C, 0x60, 0x4B, 0x07, 0x73, 0x09, 0xB0, 0x66, 0x07, 0xB0, 0x47, 0x30, 0xEB,
  0x01, 0x60, 0xAB, 0x01, 0x72, 0x06, 0xB0, 0xA7, 0x0D, 0xA0, 0xD7, 0x30, 0xEB, 0x02, 0x60, 0x1B,
  0x0A, 0x72, 0x08, 0xB0, 0x87, 0x04, 0xB0, 0x77, 0x10, 0x4B, 0x0D, 0x71, 0x07, 0xB0, 0x37, 0x04,
  0xB0, 0xE0, 0x27, 0x10, 0xCB, 0x70, 0x7B, 0x0E, 0x03, 0x71, 0x06, 0xB0, 0xC4, 0x81, 0x27, 0xDB,
  0x0C, 0x02, 0x68, 0x14, 0x9D, 0xD0, 0xFE, 0xD0, 0xE0, 0x77, 0x10, 0x9F, 0xC8, 0x2E, 0xC9, 0x57,
  0x30,
  // "E" (U+0045)
  0x60, 0xCF, 0xFA, 0x0C, 0x60, 0x90, 0xCD, 0x80, 0x1E, 0xD0, 0x97, 0x10, 0x7B, 0x0D, 0x60, 0x20,
  0xCA, 0x06, 0x71, 0x04, 0xB0, 0x97, 0x04, 0xA0, 0x37, 0x10, 0x5B, 0x06, 0x70, 0x1A, 0x72, 0x09,
  0xB0, 0x37, 0x81, 0x2F, 0xD7, 0x20, 0xCB, 0x71, 0x81, 0x4F, 0xA7, 0x2B, 0x0C, 0x72, 0x02, 0x01,
  0x71, 0x03, 0xB0, 0x97, 0x75, 0x06, 0xB0, 0x67, 0x75, 0x09, 0xB0, 0x37, 0x75, 0x0D, 0xB7, 0x76,
  0xB0, 0xC7, 0x75, 0x03, 0xFC, 0x0C, 0x74, 0x07, 0xC8, 0x03, 0xE0, 0x97, 0x40, 0xAB, 0x02, 0x77,
  0x50, 0xDA, 0x0E, 0x77, 0x50, 0x1B, 0x0B, 0x77, 0x50, 0x4B, 0x08, 0x77, 0x50, 0x7B, 0x04, 0x77,
  0x50, 0xBB, 0x01, 0x77, 0x50, 0xEA, 0x0D, 0x77, 0x50, 0x1B, 0x0A, 0x72, 0x81, 0x6F, 0x77, 0x05,
  0xB0, 0x77, 0x28, 0x1B, 0xF4, 0x70, 0x8B, 0x04, 0x71, 0x02, 0xA7, 0x10, 0xCB, 0x72, 0x81, 0xCF,
  0xC7, 0x07, 0xB0, 0xC7, 0x03, 0x0B, 0xA0, 0x84, 0x81, 0x4A, 0xDD, 0x80, 0x2E, 0xD0, 0x44, 0x09,
  0xFF, 0xC0, 0x14,
  // "F" (U+0046)
  0x60, 0xCF, 0xFA, 0x0C, 0x60, 0xA0, 0xCF, 0xF9, 0x09, 0x71, 0x05, 0xB0, 0xD6, 0x03, 0x0C, 0xA0,
  0x77, 0x10, 0x3B, 0x09, 0x70, 0x4A, 0x04, 0x71, 0x05, 0xB0, 0x67, 0x01, 0xA0, 0x17, 0x10, 0x9B,
  0x03, 0x78, 0x12, 0xFE, 0x72, 0x0C, 0xB7, 0x18, 0x13, 0xFB, 0x72, 0xB0, 0xC7, 0x20, 0x20, 0x17,
  0x10, 0x3B, 0x09, 0x77, 0x50, 0x6B, 0x06, 0x77, 0x50, 0x9B, 0x03, 0x77, 0x50, 0xCB, 0x77, 0x6B,
  0x0C, 0x77, 0x50, 0x3B, 0x09, 0x77, 0x50, 0x7F, 0xC0, 0xA7, 0x40, 0xAF, 0xC0, 0x77, 0x40, 0xDA,
  0x0E, 0x77, 0x50, 0x1B, 0x0B, 0x77, 0x50, 0x4B, 0x08, 0x77, 0x50, 0x7B, 0x04, 0x77, 0x50, 0xBB,
  0x01, 0x77, 0x50, 0xEA, 0x0D, 0x77, 0x50, 0x2B, 0x0A, 0x77, 0x50, 0x5B, 0x06, 0x77, 0x50, 0x8B,
  0x03, 0x77, 0x50, 0xDB, 0x03, 0x77, 0x30, 0x20, 0xAC, 0x09, 0x01, 0x77, 0x06, 0xFA, 0x0E, 0x07,
  0x75, 0x09, 0xFB, 0x04, 0x75,
  // "G" (U+0047)
  0x74, 0x89, 0x05, 0x9C, 0xEF, 0xED, 0xB8, 0x27, 0x38, 0x11, 0x8E, 0xFB, 0x08, 0x71, 0x05, 0x0E,
  0xA8, 0x1D, 0x61, 0x20, 0x30, 0xBC, 0x07, 0x60, 0x8B, 0x09, 0x70, 0xCB, 0x0D, 0x50, 0x9B, 0x08,
  0x71, 0x04, 0xB0, 0xD4, 0x07, 0xB0, 0x97, 0x3B, 0x07, 0x30, 0x2B, 0x0D, 0x74, 0x81, 0xEC, 0x64,
  0x0C, 0xB0, 0x47, 0x73, 0x06, 0xB0, 0xB7, 0x74, 0x0D, 0xB0, 0x47, 0x73, 0x04, 0xB0, 0xD7, 0x74,
  0x0A, 0xB0, 0x87, 0x74, 0x0E, 0xB0, 0x37, 0x73, 0x04, 0xB0, 0xE7, 0x74, 0x07, 0xB0, 0xB7, 0x74,
  0x09, 0xB0, 0x87, 0x10, 0xC8, 0x04, 0xE0, 0xA0, 0xBB, 0x06, 0x71, 0xFA, 0x08, 0x0C, 0xB0, 0x57,
  0x20, 0x20, 0xCC, 0x82, 0x81, 0x0D, 0xB0, 0x47, 0x30, 0x6B, 0x0A, 0x30, 0xDB, 0x03, 0x73, 0x07,
  0xB0, 0x53, 0x0B, 0xB0, 0x37, 0x30, 0xAB, 0x01, 0x30, 0x9B, 0x05, 0x73, 0x0D, 0xA0, 0xE4, 0x06,
  0xB0, 0x87, 0x20, 0x1B, 0x0A, 0x40, 0x1B, 0x0D, 0x72, 0x04, 0xB0, 0x75, 0x0A, 0xB0, 0x47, 0x10,
  0x7B, 0x04, 0x50, 0x10, 0xEA, 0x0E, 0x02, 0x70, 0xBB, 0x01, 0x60, 0x30, 0xEA, 0x81, 0xE7, 0x22,
  0x81, 0x15, 0xBB, 0x0D, 0x71, 0x02, 0x0C, 0xFC, 0x0A, 0x03, 0x73, 0x89, 0x14, 0x8C, 0xEF, 0xEE,
  0xC9, 0x51, 0x70,
  // "H" (U+0048)
  0x60, 0xCF, 0xA0, 0x73, 0x02, 0xFB, 0x02, 0x60, 0xEF, 0xA0, 0x43, 0x04, 0xFA, 0x0E, 0x71, 0x01,
  0x09, 0xC0, 0x90, 0x27, 0x02, 0x0D, 0xB8, 0x1E, 0x61, 0x73, 0x03, 0xB0, 0xC7, 0x30, 0x9B, 0x07,
  0x75, 0x05, 0xB0, 0x77, 0x30, 0xAB, 0x01, 0x75, 0x08, 0xB0, 0x47, 0x30, 0xDA, 0x0D, 0x76, 0x0B,
  0xB0, 0x17, 0x20, 0x1B, 0x0A, 0x76, 0x0E, 0xA0, 0xD7, 0x30, 0x4B, 0x06, 0x75, 0x02, 0xB0, 0x97,
  0x30, 0x8B, 0x03, 0x75, 0x06, 0xB0, 0x67, 0x30, 0xBB, 0x76, 0x09, 0xB0, 0x37, 0x30, 0xEA, 0x0C,
  0x76, 0x0C, 0xB7, 0x30, 0x2B, 0x09, 0x76, 0xB0, 0xC7, 0x30, 0x5B, 0x05, 0x75, 0x03, 0xFF, 0xC0,
  0x27, 0x50, 0x6B, 0x80, 0x7E, 0xB0, 0xE7, 0x60, 0xAB, 0x01, 0x73, 0xB0, 0xB7, 0x60, 0xDA, 0x0D,
  0x73, 0x03, 0xB0, 0x87, 0x50, 0x1B, 0x0A, 0x73, 0x07, 0xB0, 0x47, 0x50, 0x4B, 0x07, 0x73, 0x0A,
  0xB0, 0x17, 0x50, 0x7B, 0x04, 0x73, 0x0D, 0xA0, 0xD7, 0x60, 0xBB, 0x73, 0x01, 0xB0, 0xA7, 0x60,
  0xEA, 0x0C, 0x73, 0x04, 0xB0, 0x77, 0x50, 0x2B, 0x09, 0x73, 0x08, 0xB0, 0x37, 0x50, 0x5B, 0x06,
  0x73, 0x0B, 0xB7, 0x60, 0x9B, 0x03, 0x73, 0x0E, 0xA0, 0xD7, 0x60, 0xEB, 0x01, 0x72, 0x04, 0xB0,
  0xB7, 0x40, 0x30, 0xBC, 0x07, 0x71, 0x05, 0x0D, 0xB0, 0xE0, 0x37, 0x10, 0x6F, 0xA0, 0xC4, 0x0B,
  0xFA, 0x07, 0x60, 0x9F, 0xA0, 0x94, 0xFB, 0x04, 0x60,
  // "I" (U+0049)
  0x60, 0xCF, 0xA0, 0x86, 0x0E, 0xFA, 0x05, 0x70, 0x10, 0x9C, 0x0A, 0x02, 0x73, 0x03, 0xB0, 0xD7,
  0x50, 0x4B, 0x08, 0x75, 0x08, 0xB0, 0x47, 0x50, 0xBB, 0x01, 0x75, 0x0E, 0xA0, 0xD7, 0x50, 0x2B,
  0x0A, 0x75, 0x05, 0xB0, 0x67, 0x50, 0x9B, 0x03, 0x75, 0x0C, 0xB7, 0x6B, 0x0C, 0x75, 0x03, 0xB0,
  0x97, 0x50, 0x6B, 0x05, 0x75, 0x0A, 0xB0, 0x27, 0x50, 0xDA, 0x0E, 0x75, 0x01, 0xB0, 0xB7, 0x50,
  0x4B, 0x07, 0x75, 0x07, 0xB0, 0x47, 0x50, 0xBB, 0x01, 0x75, 0x0E, 0xA0, 0xD7, 0x50, 0x2B, 0x0A,
  0x75, 0x05, 0xB0, 0x67, 0x50, 0x9B, 0x03, 0x75, 0x0E, 0xB0, 0x17, 0x30, 0x30, 0xBC, 0x08, 0x71,
  0x06, 0xFA, 0x0C, 0x60, 0x9F, 0xA0, 0xA6,
  // "J" (U+004A)
  0x74, 0x0E, 0xFA, 0x06, 0x73, 0x01, 0xFB, 0x03, 0x75, 0x01, 0x0B, 0xC0, 0x80, 0x27, 0x71, 0x06,
  0xB0, 0xB7, 0x73, 0x07, 0xB0, 0x57, 0x73, 0x0A, 0xB0, 0x27, 0x73, 0x0D, 0xA0, 0xE7, 0x73, 0x01,
  0xB0, 0xB7, 0x73, 0x04, 0xB0, 0x87, 0x73, 0x07, 0xB0, 0x47, 0x73, 0x0B, 0xB0, 0x17, 0x73, 0x0E,
  0xA0, 0xD7, 0x73, 0x02, 0xB0, 0xA7, 0x73, 0x05, 0xB0, 0x77, 0x73, 0x08, 0xB0, 0x47, 0x73, 0x0B,
  0xB7, 0x74, 0x0E, 0xA0, 0xD7, 0x73, 0x02, 0xB0, 0x97, 0x73, 0x06, 0xB0, 0x67, 0x73, 0x09, 0xB0,
  0x37, 0x73, 0x0C, 0xB7, 0x74, 0xB0, 0xC7, 0x73, 0x03, 0xB0, 0x87, 0x73, 0x06, 0xB0, 0x57, 0x73,
  0x0A, 0xB0, 0x27, 0x73, 0x0D, 0xA0, 0xE7, 0x73, 0x01, 0xB0, 0xB7, 0x73, 0x04, 0xB0, 0x87, 0x73,
  0x07, 0xB0, 0x47, 0x73, 0x0A, 0xB0, 0x17, 0x73, 0x0E, 0xA0, 0xD7, 0x73, 0x02, 0xB0, 0x97, 0x73,
  0x07, 0xB0, 0x47, 0x73, 0x0C, 0xA0, 0xD7, 0x73, 0x04, 0xB0, 0x67, 0x73, 0x0D, 0xA0, 0xD7, 0x60,
  0x22, 0x03, 0x0C, 0xA0, 0xE0, 0x27, 0x50, 0x4E, 0x0D, 0x03, 0x76, 0x05, 0x0D, 0xA8, 0x1D, 0xB6,
  0x77, 0x10,
  // "K" (U+004B)
  0x60, 0xCF, 0xA0, 0x73, 0x0B, 0xF0, 0x26, 0x0E, 0xFA, 0x04, 0x30, 0xDF, 0x71, 0x01, 0x09, 0xC0,
  0x90, 0x26, 0x09, 0xB0, 0xD0, 0x47, 0x30, 0x3B, 0x0D, 0x71, 0x0B, 0xA0, 0xB0, 0x17, 0x40, 0x4B,
  0x07, 0x70, 0x5A, 0x0A, 0x76, 0x08, 0xB0, 0x46, 0x82, 0x3E, 0xFA, 0x77, 0x0B, 0xB6, 0x82, 0x2E,
  0xFA, 0x77, 0x10, 0xEA, 0x0D, 0x58, 0x21, 0xDF, 0xA7, 0x71, 0x02, 0xB0, 0x94, 0x82, 0x1D, 0xFB,
  0x77, 0x20, 0x5B, 0x06, 0x38, 0x21, 0xCF, 0xB7, 0x73, 0x09, 0xB0, 0x33, 0x81, 0xCF, 0xB7, 0x74,
  0x0C, 0xB3, 0x81, 0xBF, 0xB7, 0x75, 0xB0, 0xC2, 0x0A, 0xA0, 0x27, 0x74, 0x03, 0xB8, 0x18, 0x0A,
  0xB0, 0x77, 0x74, 0x06, 0xB0, 0x50, 0x9C, 0x0C, 0x77, 0x40, 0xAB, 0x82, 0xAF, 0xAE, 0xB0, 0x27,
  0x73, 0x0D, 0xC8, 0x19, 0x09, 0xB0, 0x77, 0x72, 0x01, 0xC0, 0x72, 0x04, 0xB0, 0xC7, 0x72, 0x04,
  0xB0, 0x84, 0x0E, 0xB0, 0x27, 0x71, 0x07, 0xB0, 0x44, 0x0A, 0xB0, 0x77, 0x71, 0x0B, 0xB0, 0x14,
  0x05, 0xB0, 0xC7, 0x71, 0x0E, 0xA0, 0xD6, 0xC0, 0x27, 0x60, 0x2B, 0x09, 0x60, 0xBB, 0x07, 0x76,
  0x05, 0xB0, 0x66, 0x06, 0xB0, 0xC7, 0x60, 0x9B, 0x03, 0x60, 0x1C, 0x02, 0x75, 0x0E, 0xB0, 0x17,
  0x0B, 0xB0, 0xA7, 0x30, 0x30, 0xBC, 0x08, 0x70, 0x4C, 0x08, 0x01, 0x60, 0x6F, 0xA0, 0xC6, 0x0A,
  0xD0, 0x25, 0x09, 0xFA, 0x0A, 0x78, 0x36, 0xBE, 0xFE, 0x60,
  // "L" (U+004C)
  0x60, 0xCF, 0xA0, 0x87, 0x30, 0xEF, 0xA0, 0x57, 0x40, 0x10, 0x9C, 0x09, 0x02, 0x77, 0x03, 0xB0,
  0xC7, 0x72, 0x04, 0xB0, 0x77, 0x72, 0x07, 0xB0, 0x47, 0x72, 0x0B, 0xB0, 0x17, 0x72, 0x0E, 0xA0,
  0xD7, 0x72, 0x02, 0xB0, 0x97, 0x72, 0x05, 0xB0, 0x67, 0x72, 0x08, 0xB0, 0x37, 0x72, 0x0B, 0xB7,
  0x73, 0x0E, 0xA0, 0xC7, 0x72, 0x02, 0xB0, 0x97, 0x72, 0x06, 0xB0, 0x57, 0x72, 0x09, 0xB0, 0x27,
  0x72, 0x0C, 0xA0, 0xE7, 0x73, 0xB0, 0xB7, 0x72, 0x03, 0xB0, 0x87, 0x72, 0x07, 0xB0, 0x57, 0x72,
  0x0A, 0xB0, 0x27, 0x20, 0x70, 0x95, 0x0D, 0xA0, 0xE7, 0x28, 0x11, 0xFC, 0x40, 0x1B, 0x0B, 0x72,
  0x81, 0x6F, 0x84, 0x04, 0xB0, 0x77, 0x28, 0x1C, 0xF5, 0x40, 0x7B, 0x04, 0x71, 0x03, 0xA0, 0x14,
  0x0C, 0xB0, 0x17, 0x18, 0x1C, 0xFD, 0x40, 0x7B, 0x0D, 0x70, 0x20, 0xAA, 0x83, 0x90, 0x4A, 0xDD,
  0x80, 0x2E, 0xD8, 0x15, 0x09, 0xFF, 0xC0, 0x11,
  // "M" (U+004D)
  0x60, 0xCF, 0x07, 0x75, 0x02, 0xF9, 0x01, 0x60, 0xEF, 0x08, 0x75, 0x09, 0xF0, 0xD7, 0x10, 0x10,
  0x9D, 0x09, 0x74, 0x02, 0xD0, 0xE0, 0x67, 0x40, 0x3A, 0x0E, 0xA0, 0xB7, 0x48, 0x1A, 0xFE, 0xB0,
  0x67, 0x58, 0x24, 0xFC, 0xCA, 0x0C, 0x73, 0x82, 0x2F, 0xEA, 0xB0, 0x17, 0x58, 0x27, 0xF9, 0xAA,
  0x0E, 0x73, 0x82, 0xAF, 0x7D, 0xA0, 0xC7, 0x68, 0x2B, 0xF6, 0x9B, 0x72, 0x82, 0x3F, 0xE1, 0xB0,
  0x97, 0x68, 0x2E, 0xF2, 0x7B, 0x01, 0x71, 0x82, 0xAF, 0x74, 0xB0, 0x67, 0x58, 0x32, 0xFE, 0x06,
  0xB0, 0x37, 0x83, 0x3F, 0xE0, 0x7B, 0x02, 0x75, 0x83, 0x5F, 0xB0, 0x4B, 0x04, 0x78, 0x3B, 0xF6,
  0x0A, 0xA0, 0xE7, 0x68, 0x38, 0xF8, 0x03, 0xB0, 0x56, 0x81, 0x3F, 0xD2, 0x0D, 0xA0, 0xB7, 0x68,
  0x3C, 0xF5, 0x01, 0xB0, 0x76, 0x83, 0xBF, 0x60, 0x1B, 0x08, 0x76, 0xA0, 0x22, 0xB0, 0x85, 0x81,
  0x3F, 0xD2, 0x05, 0xB0, 0x57, 0x58, 0x13, 0xFE, 0x30, 0xEA, 0x0A, 0x58, 0x1B, 0xF6, 0x20, 0x8B,
  0x01, 0x75, 0x81, 0x6F, 0xB3, 0x0C, 0xA0, 0xB4, 0x81, 0x4F, 0xD3, 0x0B, 0xA0, 0xE7, 0x68, 0x1A,
  0xF7, 0x30, 0xBA, 0x0D, 0x48, 0x1C, 0xF5, 0x30, 0xEA, 0x0A, 0x76, 0x81, 0xDF, 0x43, 0x09, 0xA0,
  0xE3, 0x81, 0x4F, 0xD3, 0x02, 0xB0, 0x77, 0x50, 0x1A, 0x01, 0x30, 0x8B, 0x38, 0x1C, 0xF5, 0x30,
  0x5B, 0x04, 0x75, 0x81, 0x4F, 0xD4, 0x06, 0xB8, 0x31, 0x04, 0xFD, 0x40, 0x9B, 0x01, 0x75, 0x81,
  0x7F, 0xA4, 0x05, 0xB8, 0x33, 0x0C, 0xF5, 0x40, 0xCA, 0x0D, 0x76, 0x81, 0xBF, 0x64, 0x03, 0xB8,
  0x24, 0x5F, 0xC5, 0xB0, 0x97, 0x68, 0x1E, 0xF3, 0x40, 0x2B, 0x82, 0x6C, 0xF4, 0x40, 0x3B, 0x06,
  0x75, 0x02, 0xA6, 0xB8, 0x1C, 0xFC, 0x50, 0x6B, 0x03, 0x75, 0x81, 0x5F, 0xC6, 0x0E, 0xC0, 0x45,
  0x0A, 0xB7, 0x68, 0x19, 0xF9, 0x60, 0xDB, 0x0C, 0x60, 0xDA, 0x0C, 0x76, 0x81, 0xEF, 0x76, 0x0B,
  0xB0, 0x45, 0x02, 0xB0, 0xA7, 0x40, 0x20, 0xAA, 0x0C, 0x02, 0x50, 0xAA, 0x0B, 0x50, 0x30, 0xCB,
  0x0E, 0x03, 0x71, 0x06, 0xF9, 0x02, 0x30, 0x8A, 0x03, 0x30, 0x3F, 0xA0, 0x66, 0x09, 0xF0, 0xE4,
  0x81, 0x7F, 0xB4, 0x06, 0xFA, 0x03, 0x60,
  // "N" (U+004E)
  0x60, 0xCD, 0x0E, 0x71, 0x02, 0xF9, 0x07, 0x60, 0xEE, 0x04, 0x70, 0x5F, 0x90, 0x47, 0x01, 0x09,
  0xC0, 0x97, 0x20, 0x30, 0xDA, 0x09, 0x02, 0x73, 0x03, 0xC0, 0xE7, 0x38, 0x19, 0xFC, 0x75, 0x04,
  0xD0, 0x47, 0x28, 0x1B, 0xF7, 0x75, 0x81, 0x7F, 0xBB, 0x0A, 0x72, 0x81, 0xEF, 0x37, 0x58, 0x2B,
  0xF5, 0xCA, 0x0E, 0x71, 0x02, 0xA7, 0x68, 0x2E, 0xF2, 0x7B, 0x04, 0x78, 0x16, 0xFC, 0x75, 0x83,
  0x2F, 0xE0, 0x1B, 0x0A, 0x78, 0x19, 0xF9, 0x75, 0x81, 0x5F, 0xB2, 0x0C, 0xA0, 0xE7, 0x81, 0xCF,
  0x67, 0x58, 0x18, 0xF8, 0x20, 0x6B, 0x05, 0x6A, 0x02, 0x75, 0x81, 0xCF, 0x42, 0x01, 0xB0, 0xA5,
  0x81, 0x3F, 0xE7, 0x6A, 0x01, 0x30, 0xBA, 0x0E, 0x58, 0x16, 0xFB, 0x75, 0x81, 0x3F, 0xD4, 0x06,
  0xB0, 0x54, 0x81, 0x9F, 0x87, 0x58, 0x16, 0xFA, 0x40, 0x1B, 0x0A, 0x48, 0x1D, 0xF5, 0x75, 0x81,
  0x9F, 0x75, 0x0B, 0xA0, 0xE3, 0x01, 0xA0, 0x17, 0x58, 0x1D, 0xF4, 0x50, 0x6B, 0x05, 0x28, 0x14,
  0xFE, 0x75, 0x01, 0xA6, 0x01, 0xB0, 0xA2, 0x81, 0x7F, 0xA7, 0x58, 0x14, 0xFD, 0x70, 0xBB, 0x28,
  0x1A, 0xF7, 0x75, 0x81, 0x7F, 0x97, 0x05, 0xB8, 0x35, 0x0D, 0xF4, 0x75, 0x81, 0xBF, 0x67, 0x1B,
  0x0A, 0x01, 0xA0, 0x17, 0x58, 0x1E, 0xF3, 0x71, 0x0A, 0xB8, 0x15, 0xFD, 0x75, 0x02, 0xA7, 0x20,
  0x5B, 0x81, 0xDF, 0xA7, 0x58, 0x15, 0xFC, 0x73, 0x0E, 0xC0, 0x67, 0x58, 0x19, 0xF9, 0x73, 0x0A,
  0xC0, 0x37, 0x58, 0x1E, 0xF8, 0x73, 0x05, 0xC7, 0x40, 0x30, 0xBA, 0x0C, 0x02, 0x73, 0x0E, 0xA0,
  0xC7, 0x20, 0x6F, 0x90, 0x27, 0x10, 0x9A, 0x09, 0x72, 0x09, 0xF0, 0xE7, 0x20, 0x4A, 0x05, 0x72,
  // "O" (U+004F)
  0x73, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x27, 0x60, 0x30, 0xCF, 0xA0, 0x87, 0x40, 0x8B, 0x09, 0x03,
  0x20, 0x20, 0x8B, 0x0B, 0x72, 0x0A, 0xA0, 0xE0, 0x46, 0x05, 0xB0, 0x87, 0x0A, 0xB0, 0x37, 0x10,
  0xAB, 0x02, 0x50, 0x6B, 0x06, 0x72, 0x03, 0xB0, 0x94, 0x03, 0xB0, 0xB7, 0x4B, 0x0D, 0x40, 0xBB,
  0x03, 0x74, 0x0C, 0xB0, 0x12, 0x05, 0xB0, 0xA7, 0x50, 0xBB, 0x04, 0x20, 0xCB, 0x04, 0x75, 0x0B,
  0xB8, 0x15, 0x03, 0xB0, 0xD7, 0x60, 0xCB, 0x81, 0x50, 0x9B, 0x08, 0x76, 0x0D, 0xB8, 0x14, 0x0E,
  0xB0, 0x47, 0x6C, 0x00, 0x3C, 0x76, 0x02, 0xC1, 0x06, 0xB0, 0xC7, 0x60, 0x5B, 0x81, 0xD0, 0x9B,
  0x09, 0x76, 0x08, 0xB8, 0x1A, 0x0B, 0xB0, 0x77, 0x60, 0xCB, 0x81, 0x50, 0xCB, 0x05, 0x75, 0x01,
  0xC8, 0x11, 0x0D, 0xB0, 0x47, 0x50, 0x6B, 0x0A, 0x20, 0xDB, 0x03, 0x75, 0x0C, 0xB0, 0x32, 0x0B,
  0xB0, 0x37, 0x40, 0x2B, 0x0C, 0x30, 0x9B, 0x04, 0x74, 0x0A, 0xB0, 0x33, 0x05, 0xB0, 0x77, 0x30,
  0x3B, 0x09, 0x40, 0x1B, 0x0B, 0x73, 0x0D, 0xA0, 0xD6, 0x09, 0xB0, 0x27, 0x10, 0xAA, 0x0E, 0x02,
  0x60, 0x10, 0xEA, 0x0C, 0x70, 0xBA, 0x0E, 0x03, 0x71, 0x03, 0x0E, 0xA0, 0xD0, 0x52, 0x81, 0x16,
  0xDA, 0x0C, 0x02, 0x73, 0x02, 0x0C, 0xFA, 0x07, 0x77, 0x81, 0x5A, 0xDA, 0x82, 0xDB, 0x61, 0x73,
  // "P" (U+0050)
  0x60, 0xCF, 0xA8, 0x2E, 0xB7, 0x17, 0x20, 0xA0, 0xCD, 0x00, 0xDD, 0x06, 0x73, 0x05, 0xB0, 0xD3,
  0x03, 0x0C, 0xB0, 0x77, 0x20, 0x3B, 0x0A, 0x50, 0xCB, 0x02, 0x71, 0x05, 0xB0, 0x75, 0x04, 0xB0,
  0x97, 0x10, 0x8B, 0x04, 0x6B, 0x0D, 0x71, 0x0B, 0xB0, 0x16, 0x0E, 0xB7, 0x10, 0xEA, 0x0D, 0x70,
  0xDB, 0x70, 0x2B, 0x0A, 0x70, 0xEB, 0x70, 0x6B, 0x06, 0x7B, 0x0E, 0x70, 0x9B, 0x03, 0x60, 0x4B,
  0x0B, 0x70, 0xCB, 0x70, 0x8B, 0x07, 0x7B, 0x0D, 0x70, 0xEB, 0x01, 0x60, 0x3B, 0x09, 0x60, 0x9B,
  0x08, 0x70, 0x7B, 0x06, 0x50, 0x8B, 0x0C, 0x71, 0x0A, 0xB0, 0x32, 0x81, 0x25, 0xCB, 0x0C, 0x01,
  0x71, 0x0D, 0xFB, 0x0E, 0x07, 0x72, 0x01, 0xC0, 0xFE, 0x82, 0xDC, 0x95, 0x74, 0x04, 0xB0, 0x87,
  0x74, 0x07, 0xB0, 0x57, 0x74, 0x0B, 0xB0, 0x17, 0x74, 0x0E, 0xA0, 0xD7, 0x74, 0x02, 0xB0, 0xA7,
  0x74, 0x05, 0xB0, 0x77, 0x74, 0x09, 0xB0, 0x37, 0x74, 0x0E, 0xB0, 0x17, 0x72, 0x03, 0x0B, 0xC0,
  0x77, 0x70, 0x6F, 0xA0, 0xE0, 0x77, 0x40, 0x9F, 0xB0, 0x47, 0x40,
  // "Q" (U+0051)
  0x73, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x17, 0x60, 0x20, 0xBF, 0xA0, 0x87, 0x40, 0x7B, 0x09, 0x03,
  0x20, 0x20, 0x8B, 0x0A, 0x72, 0x09, 0xB0, 0x46, 0x05, 0xB0, 0x87, 0x09, 0xB0, 0x47, 0x10, 0xAB,
  0x02, 0x50, 0x6B, 0x07, 0x72, 0x03, 0xB0, 0x84, 0x02, 0xB0, 0xB7, 0x4B, 0x0D, 0x40, 0xBB, 0x03,
  0x74, 0x0C, 0xB0, 0x12, 0x04, 0xB0, 0xB7, 0x50, 0xBB, 0x03, 0x20, 0xBB, 0x04, 0x75, 0x0B, 0xB8,
  0x14, 0x02, 0xB0, 0xE7, 0x60, 0xCB, 0x81, 0x50, 0x8B, 0x09, 0x76, 0x0D, 0xB8, 0x14, 0x0D, 0xB0,
  0x47, 0x6C, 0x03, 0x02, 0xC7, 0x60, 0x1C, 0x01, 0x05, 0xB0, 0xC7, 0x60, 0x4B, 0x81, 0xE0, 0x8B,
  0x09, 0x76, 0x07, 0xB8, 0x1B, 0x0B, 0xB0, 0x77, 0x60, 0xBB, 0x81, 0x70, 0xCB, 0x05, 0x76, 0xC8,
  0x12, 0x0D, 0xB0, 0x47, 0x50, 0x5B, 0x0C, 0x20, 0xDB, 0x03, 0x75, 0x0B, 0xB0, 0x62, 0x0C, 0xB0,
  0x37, 0x40, 0x1B, 0x0E, 0x30, 0xAB, 0x04, 0x74, 0x09, 0xB0, 0x83, 0x07, 0xB0, 0x67, 0x30, 0x1B,
  0x0D, 0x40, 0x3B, 0x0A, 0x73, 0x0B, 0xB0, 0x55, 0x0C, 0xA0, 0xE0, 0x17, 0x10, 0x7B, 0x09, 0x60,
  0x4B, 0x0A, 0x70, 0x7B, 0x0B, 0x71, 0x09, 0xB0, 0xA0, 0x13, 0x02, 0x09, 0xB0, 0xA7, 0x30, 0x9C,
  0x81, 0xCB, 0xCB, 0x0E, 0x07, 0x75, 0x05, 0x0C, 0xE8, 0x1E, 0x91, 0x77, 0x10, 0x2C, 0x03, 0x77,
  0x50, 0xEB, 0x01, 0x77, 0x50, 0xDB, 0x03, 0x77, 0x50, 0xAB, 0x05, 0x77, 0x50, 0x6B, 0x09, 0x77,
  0x50, 0x10, 0xEA, 0x0E, 0x01, 0x77, 0x50, 0x7B, 0x0B, 0x01, 0x20, 0x27, 0x72, 0x09, 0xC8, 0x1E,
  0xFC, 0x77, 0x38, 0x55, 0xBE, 0xFE, 0xB6, 0x70,
  // "R" (U+0052)
  0x60, 0xCF, 0xA8, 0x3E, 0xDA, 0x61, 0x72, 0x0A, 0x0C, 0xD8, 0x1D, 0xDE, 0xC0, 0xE0, 0x57, 0x30,
  0x5B, 0x0C, 0x40, 0x60, 0xEB, 0x04, 0x72, 0x03, 0xB0, 0x95, 0x04, 0xB0, 0xD7, 0x20, 0x5B, 0x06,
  0x60, 0xDB, 0x02, 0x71, 0x08, 0xB0, 0x36, 0x0A, 0xB0, 0x57, 0x10, 0xBB, 0x70, 0x9B, 0x06, 0x71,
  0x0E, 0xA0, 0xC7, 0x09, 0xB0, 0x57, 0x02, 0xB0, 0x87, 0x0B, 0xB0, 0x47, 0x06, 0xB0, 0x57, 0x0E,
  0xB0, 0x17, 0x09, 0xB0, 0x26, 0x04, 0xB0, 0xA7, 0x10, 0xCA, 0x0E, 0x70, 0xDA, 0x0E, 0x02, 0x71,
  0xB0, 0xB6, 0x0A, 0xB0, 0x57, 0x10, 0x3B, 0x08, 0x38, 0x11, 0x6D, 0xA0, 0xE0, 0x47, 0x20, 0x7B,
  0x82, 0xED, 0xDE, 0xB8, 0x1E, 0x91, 0x73, 0x0A, 0xFA, 0x0E, 0x76, 0x0D, 0xA0, 0xD3, 0x0B, 0xB0,
  0x17, 0x40, 0x1B, 0x0A, 0x30, 0x8B, 0x05, 0x74, 0x04, 0xB0, 0x73, 0x04, 0xB0, 0x97, 0x40, 0x8B,
  0x04, 0x30, 0x1B, 0x0D, 0x74, 0x0B, 0xB5, 0x0D, 0xB0, 0x27, 0x30, 0xEA, 0x0C, 0x50, 0x9B, 0x06,
  0x72, 0x02, 0xB0, 0x95, 0x06, 0xB0, 0xA7, 0x20, 0x5B, 0x06, 0x50, 0x3B, 0x0E, 0x72, 0x09, 0xB0,
  0x36, 0x0E, 0xB0, 0x37, 0x10, 0xEB, 0x01, 0x60, 0xAB, 0x09, 0x60, 0x20, 0xAC, 0x08, 0x60, 0x3C,
  0x06, 0x30, 0x6F, 0xA0, 0xE0, 0x74, 0x08, 0xD2, 0x09, 0xFB, 0x04, 0x58, 0x35, 0xBD, 0xFD, 0x20,
  // "S" (U+0053)
  0x72, 0x87, 0x49, 0xCE, 0xFE, 0xC9, 0x37, 0x20, 0x10, 0xBF, 0xA0, 0xA7, 0x02, 0x0E, 0xA0, 0xB0,
  0x32, 0x03, 0x0C, 0xB0, 0x96, 0x0D, 0xA0, 0x85, 0x01, 0x0E, 0xA0, 0xE5, 0x07, 0xA0, 0xD7, 0x09,
  0xA0, 0xE5, 0x0D, 0xA0, 0x87, 0x05, 0xA0, 0xA4, 0x02, 0xB0, 0x67, 0x81, 0x4C, 0x85, 0x03, 0xB0,
  0x57, 0x71, 0x04, 0xB0, 0x77, 0x71, 0x02, 0xB0, 0xC7, 0x72, 0x0E, 0xB0, 0x67, 0x71, 0x09, 0xC0,
  0x67, 0x70, 0x10, 0xEC, 0x0A, 0x01, 0x76, 0x02, 0x0E, 0xC0, 0xE0, 0x47, 0x60, 0x30, 0xDD, 0x06,
  0x76, 0x01, 0x0A, 0xD0, 0x57, 0x70, 0x6D, 0x03, 0x77, 0x04, 0x0E, 0xB0, 0xB7, 0x71, 0x04, 0xC0,
  0x17, 0x71, 0x0B, 0xB0, 0x54, 0x06, 0x03, 0x72, 0x06, 0xB0, 0x53, 0x81, 0xCF, 0x77, 0x20, 0x4B,
  0x05, 0x20, 0x6A, 0x09, 0x72, 0x05, 0xB0, 0x32, 0x08, 0xA0, 0xD7, 0x20, 0x8A, 0x0E, 0x30, 0x6B,
  0x05, 0x71, 0x0D, 0xA0, 0x83, 0x01, 0x0E, 0xA0, 0xD0, 0x16, 0x09, 0xA0, 0xE0, 0x14, 0x06, 0xB8,
  0x1D, 0x51, 0x20, 0x40, 0xBA, 0x0E, 0x03, 0x60, 0x60, 0xEF, 0xA0, 0xB0, 0x17, 0x18, 0x90, 0x16,
  0xBD, 0xEF, 0xEC, 0x83, 0x70,
  // "T" (U+0054)
  0x10, 0x3F, 0xFD, 0x81, 0x70, 0x7C, 0x0F, 0xEC, 0x0F, 0xED, 0x81, 0x40, 0xBA, 0x07, 0x01, 0x30,
  0xBB, 0x01, 0x30, 0x30, 0xEA, 0x83, 0x10, 0xEF, 0x75, 0x0E, 0xA0, 0xD5, 0x85, 0x7F, 0xE0, 0x3F,
  0xE5, 0x02, 0xB0, 0xA5, 0x85, 0x5F, 0xB0, 0x7F, 0x85, 0x05, 0xB0, 0x75, 0x85, 0x6F, 0x80, 0x9E,
  0x35, 0x09, 0xB0, 0x35, 0x81, 0x7E, 0x57, 0x20, 0xCB, 0x77, 0x4B, 0x0C, 0x77, 0x30, 0x3B, 0x09,
  0x77, 0x30, 0x6B, 0x06, 0x77, 0x30, 0x9B, 0x02, 0x77, 0x30, 0xCA, 0x0E, 0x77, 0x4B, 0x0B, 0x77,
  0x30, 0x3B, 0x08, 0x77, 0x30, 0x6B, 0x05, 0x77, 0x30, 0xAB, 0x02, 0x77, 0x30, 0xDA, 0x0E, 0x77,
  0x30, 0x1B, 0x0B, 0x77, 0x30, 0x4B, 0x07, 0x77, 0x30, 0x7B, 0x04, 0x77, 0x30, 0xAB, 0x01, 0x77,
  0x30, 0xDA, 0x0D, 0x77, 0x30, 0x1B, 0x0A, 0x77, 0x30, 0x5B, 0x06, 0x77, 0x30, 0xAB, 0x05, 0x77,
  0x10, 0x10, 0x7C, 0x0B, 0x01, 0x75, 0x06, 0xFB, 0x06, 0x73, 0x0A, 0xFB, 0x03, 0x73,
  // "U" (U+0055)
  0x10, 0x7F, 0xA0, 0xD4, 0x05, 0xF9, 0x81, 0x50, 0x9F, 0xA0, 0xA4, 0x08, 0xF9, 0x03, 0x30, 0x5C,
  0x0D, 0x04, 0x71, 0x04, 0x0E, 0xA0, 0x80, 0x26, 0x0D, 0xB0, 0x37, 0x38, 0x1B, 0xFA, 0x71, 0xB0,
  0xC7, 0x48, 0x1D, 0xF5, 0x70, 0x3B, 0x09, 0x73, 0x01, 0xA0, 0x17, 0x06, 0xB0, 0x57, 0x38, 0x14,
  0xFD, 0x71, 0x09, 0xB0, 0x27, 0x38, 0x18, 0xFA, 0x71, 0x0D, 0xA0, 0xE7, 0x48, 0x1B, 0xF7, 0x71,
  0xB0, 0xB7, 0x48, 0x1E, 0xF3, 0x70, 0x4B, 0x08, 0x73, 0x02, 0xA7, 0x10, 0x7B, 0x05, 0x73, 0x81,
  0x5F, 0xC7, 0x10, 0xAB, 0x01, 0x73, 0x81, 0x8F, 0x97, 0x10, 0xEA, 0x0D, 0x74, 0x81, 0xCF, 0x57,
  0x01, 0xB0, 0xA7, 0x4A, 0x02, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x3F, 0xE7, 0x10, 0x8B, 0x04, 0x73,
  0x81, 0x6F, 0xB7, 0x10, 0xBB, 0x74, 0x81, 0x9F, 0x87, 0x10, 0xEA, 0x0D, 0x74, 0x81, 0xDF, 0x47,
  0x02, 0xB0, 0xA7, 0x4A, 0x01, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x4F, 0xD7, 0x10, 0x6B, 0x05, 0x73,
  0x81, 0x8F, 0x97, 0x10, 0x7B, 0x04, 0x73, 0x81, 0xDF, 0x47, 0x10, 0x6B, 0x04, 0x72, 0x81, 0x4F,
  0xD7, 0x20, 0x2B, 0x07, 0x72, 0x81, 0xCF, 0x67, 0x30, 0xCA, 0x0E, 0x01, 0x78, 0x1A, 0xFB, 0x74,
  0x03, 0xB8, 0x1D, 0x61, 0x28, 0x41, 0x6D, 0xFC, 0x17, 0x50, 0x40, 0xDF, 0xA0, 0xA7, 0x72, 0x87,
  0x6A, 0xDE, 0xFE, 0xC8, 0x27, 0x60,
  // "V" (U+0056)
  0x01, 0xFA, 0x09, 0x40, 0x3F, 0x90, 0x04, 0xFA, 0x06, 0x40, 0x6F, 0x0E, 0x01, 0x20, 0x8C, 0x0C,
  0x02, 0x71, 0x04, 0xB0, 0xB0, 0x24, 0x01, 0xC0, 0x37, 0x38, 0x2D, 0xFE, 0x16, 0x0E, 0xB0, 0x17,
  0x20, 0x1A, 0x06, 0x70, 0xCB, 0x01, 0x72, 0x81, 0x7F, 0xD7, 0x10, 0xBB, 0x02, 0x72, 0x81, 0xEF,
  0x67, 0x10, 0xAB, 0x03, 0x71, 0x81, 0x7F, 0xD7, 0x20, 0x8B, 0x04, 0x71, 0x81, 0xEF, 0x67, 0x20,
  0x7B, 0x05, 0x78, 0x17, 0xFD, 0x73, 0x05, 0xB0, 0x67, 0x81, 0xEF, 0x67, 0x30, 0x4B, 0x07, 0x68,
  0x17, 0xFD, 0x74, 0x03, 0xB0, 0x96, 0x81, 0xEF, 0x57, 0x40, 0x1B, 0x0A, 0x58, 0x17, 0xFD, 0x76,
  0xB0, 0xB5, 0x81, 0xEF, 0x57, 0x60, 0xEA, 0x0C, 0x48, 0x17, 0xFD, 0x77, 0x0D, 0xA0, 0xD4, 0x81,
  0xEF, 0x57, 0x70, 0xBA, 0x0E, 0x38, 0x17, 0xFC, 0x77, 0x10, 0xAB, 0x38, 0x1E, 0xF5, 0x77, 0x10,
  0x8B, 0x83, 0x10, 0x6F, 0xC7, 0x72, 0x07, 0xB8, 0x31, 0x0D, 0xF4, 0x77, 0x20, 0x6B, 0x82, 0x25,
  0xFC, 0x77, 0x30, 0x4B, 0x82, 0x2B, 0xF4, 0x77, 0x30, 0x3B, 0x81, 0x4F, 0xC7, 0x74, 0x01, 0xB8,
  0x1A, 0xF4, 0x77, 0x5C, 0x0C, 0x77, 0x60, 0xEB, 0x04, 0x77, 0x60, 0xDA, 0x0B, 0x77, 0x70, 0xBA,
  0x03, 0x77, 0x20,
  // "W" (U+0057)
  0x10, 0xDF, 0x90, 0xC6, 0x01, 0xA0, 0xC7, 0x0B, 0xF0, 0xB0, 0x1F, 0xA0, 0x96, 0x07, 0xA0, 0xD7,
  0x0D, 0xF0, 0x72, 0x04, 0xC0, 0xD0, 0x37, 0x10, 0xEA, 0x0D, 0x72, 0x0A, 0xA0, 0xE0, 0x45, 0x0C,
  0xB0, 0x67, 0x10, 0x5B, 0x0E, 0x72, 0x06, 0xA0, 0x56, 0x0A, 0xB0, 0x37, 0x10, 0xCC, 0x72, 0x81,
  0x9F, 0xC7, 0x0A, 0xB0, 0x37, 0x04, 0xD7, 0x28, 0x1E, 0xF5, 0x70, 0x9B, 0x03, 0x70, 0xAD, 0x01,
  0x78, 0x16, 0xFD, 0x71, 0x08, 0xB0, 0x46, 0x02, 0xA0, 0xBB, 0x02, 0x78, 0x1D, 0xF6, 0x71, 0x08,
  0xB0, 0x56, 0x82, 0x8F, 0xC7, 0xB0, 0x26, 0x81, 0x4F, 0xE7, 0x20, 0x7B, 0x05, 0x68, 0x2E, 0xF5,
  0x6B, 0x03, 0x68, 0x1B, 0xF8, 0x72, 0x06, 0xB0, 0x65, 0x83, 0x7F, 0xD0, 0x5B, 0x04, 0x50, 0x3A,
  0x01, 0x72, 0x06, 0xB0, 0x75, 0x83, 0xDF, 0x70, 0x4B, 0x05, 0x58, 0x1A, 0xF9, 0x73, 0x05, 0xB0,
  0x74, 0x84, 0x5F, 0xE1, 0x04, 0xB0, 0x54, 0x02, 0xA0, 0x37, 0x30, 0x4B, 0x08, 0x48, 0x1B, 0xF9,
  0x20, 0x3B, 0x06, 0x48, 0x18, 0xFB, 0x74, 0x04, 0xB0, 0x93, 0x03, 0xA0, 0x22, 0x02, 0xB0, 0x73,
  0x82, 0x1E, 0xF4, 0x74, 0x03, 0xB0, 0x93, 0x81, 0xAF, 0xA3, 0x02, 0xB0, 0x83, 0x81, 0x7F, 0xD7,
  0x50, 0x2B, 0x0A, 0x20, 0x1A, 0x03, 0x30, 0x1B, 0x08, 0x38, 0x1D, 0xF6, 0x75, 0x02, 0xB0, 0xA2,
  0x81, 0x8F, 0xC5, 0xB0, 0x92, 0x81, 0x5F, 0xE7, 0x60, 0x1B, 0x0B, 0x28, 0x1E, 0xF5, 0x5B, 0x0A,
  0x28, 0x1C, 0xF7, 0x77, 0xB8, 0x3B, 0x05, 0xFD, 0x60, 0xEA, 0x81, 0xA0, 0x3A, 0x01, 0x77, 0xB8,
  0x3B, 0x0C, 0xF7, 0x60, 0xEA, 0x83, 0xA0, 0xAF, 0x97, 0x71, 0xB8, 0x3C, 0x2F, 0xE1, 0x60, 0xDA,
  0x0B, 0x01, 0xA0, 0x27, 0x71, 0x0E, 0xA8, 0x2C, 0x8F, 0x97, 0x0C, 0xA8, 0x2B, 0x7F, 0xB7, 0x72,
  0x0D, 0xA8, 0x2B, 0xDF, 0x27, 0x0B, 0xA8, 0x2A, 0xCF, 0x47, 0x72, 0x0D, 0xA8, 0x1E, 0xFA, 0x71,
  0x0B, 0xA8, 0x1D, 0xFC, 0x77, 0x30, 0xCC, 0x03, 0x71, 0x0A, 0xC0, 0x57, 0x73, 0x0B, 0xB0, 0xC7,
  0x20, 0x9B, 0x0D, 0x77, 0x40, 0xBB, 0x05, 0x72, 0x09, 0xB0, 0x77, 0x74, 0x0A, 0xA0, 0xD7, 0x30,
  0x8A, 0x0E, 0x01, 0x77,
  // "X" (U+0058)
  0x60, 0x3F, 0xA0, 0x43, 0x09, 0xF6, 0x06, 0xF9, 0x0E, 0x01, 0x30, 0xCE, 0x0C, 0x71, 0x07, 0xC0,
  0xC0, 0x16, 0x06, 0xB0, 0xB0, 0x27, 0x30, 0xAB, 0x0A, 0x70, 0x4A, 0x0A, 0x75, 0x05, 0xB0, 0xD7,
  0x81, 0xCF, 0xC7, 0x70, 0xEB, 0x02, 0x58, 0x27, 0xFD, 0x17, 0x70, 0xAB, 0x07, 0x40, 0x4A, 0x03,
  0x77, 0x10, 0x5B, 0x0B, 0x38, 0x21, 0xEF, 0x57, 0x73, 0xC0, 0x12, 0x81, 0xCF, 0x87, 0x74, 0x0B,
  0xB8, 0x35, 0x08, 0xFB, 0x77, 0x50, 0x6B, 0x83, 0xA5, 0xFD, 0x17, 0x75, 0x01, 0xB0, 0xFE, 0x03,
  0x77, 0x70, 0xBC, 0x05, 0x77, 0x71, 0x06, 0xB0, 0xB7, 0x77, 0x20, 0x3B, 0x0E, 0x77, 0x72, 0x0C,
  0xC0, 0x57, 0x77, 0x81, 0xAF, 0xDB, 0x0A, 0x77, 0x68, 0x37, 0xFC, 0x1E, 0xA0, 0xE7, 0x75, 0x84,
  0x4F, 0xE2, 0x0A, 0xB0, 0x57, 0x73, 0x82, 0x2E, 0xF4, 0x20, 0x5B, 0x0A, 0x77, 0x28, 0x21, 0xDF,
  0x74, 0x0E, 0xA0, 0xE7, 0x72, 0x81, 0xBF, 0xA5, 0x0A, 0xB0, 0x57, 0x78, 0x18, 0xFC, 0x60, 0x5B,
  0x0A, 0x76, 0x82, 0x6F, 0xE2, 0x60, 0x1B, 0x0E, 0x75, 0x03, 0xA0, 0x77, 0x10, 0xDB, 0x05, 0x73,
  0x82, 0x2E, 0xFE, 0x72, 0x0C, 0xB0, 0xB7, 0x20, 0x60, 0xEA, 0x0E, 0x02, 0x70, 0x5D, 0x07, 0x60,
  0x5F, 0x0D, 0x40, 0x6F, 0xA0, 0x24, 0x08, 0xF0, 0xA4, 0x09, 0xF9, 0x0E, 0x50,
  // "Y" (U+0059)
  0x03, 0xFA, 0x05, 0x30, 0xAF, 0x0D, 0x05, 0xF8, 0x1E, 0xE2, 0x30, 0xDF, 0x82, 0xA0, 0x1B, 0xC0,
  0x37, 0x10, 0x4B, 0x0A, 0x01, 0x30, 0x4B, 0x0E, 0x72, 0x02, 0xA0, 0xC6, 0x0E, 0xB0, 0x17, 0x10,
  0x7A, 0x02, 0x60, 0xAB, 0x04, 0x78, 0x21, 0xEF, 0x67, 0x06, 0xB0, 0x87, 0x81, 0xAF, 0xB7, 0x10,
  0x1B, 0x0B, 0x68, 0x25, 0xFE, 0x17, 0x20, 0xDB, 0x58, 0x21, 0xEF, 0x57, 0x30, 0x8B, 0x04, 0x48,
  0x1B, 0xF9, 0x74, 0x04, 0xB0, 0x83, 0x81, 0x6F, 0xD7, 0x6B, 0x0C, 0x28, 0x22, 0xEF, 0x37, 0x60,
  0xBB, 0x28, 0x1B, 0xF7, 0x77, 0x07, 0xB8, 0x23, 0x6F, 0xC7, 0x71, 0x02, 0xB8, 0x27, 0xEE, 0x27,
  0x72, 0x0E, 0xC0, 0x67, 0x73, 0x09, 0xB0, 0xA7, 0x74, 0x09, 0xB0, 0x37, 0x74, 0x0C, 0xB7, 0x75,
  0xB0, 0xC7, 0x74, 0x03, 0xB0, 0x97, 0x74, 0x06, 0xB0, 0x57, 0x74, 0x09, 0xB0, 0x27, 0x74, 0x0C,
  0xA0, 0xE7, 0x75, 0xB0, 0xB7, 0x74, 0x06, 0xB0, 0x97, 0x73, 0x05, 0x0E, 0xB0, 0xD0, 0x37, 0x60,
  0x40, 0xEF, 0xA0, 0xB7, 0x40, 0x7F, 0xB0, 0x87, 0x40,
  // "Z" (U+005A)
  0x60, 0x6F, 0xFA, 0x0E, 0x60, 0xAC, 0x80, 0x4E, 0xC0, 0xB6, 0x82, 0xEF, 0xE5, 0x71, 0x07, 0xB0,
  0xE0, 0x25, 0x02, 0xA0, 0x47, 0x10, 0x3C, 0x05, 0x68, 0x16, 0xFB, 0x72, 0x0D, 0xB0, 0xA7, 0x81,
  0xAF, 0x57, 0x10, 0x9B, 0x0D, 0x01, 0x70, 0xD0, 0xE7, 0x10, 0x5C, 0x04, 0x77, 0x30, 0x10, 0xEB,
  0x08, 0x77, 0x40, 0xBB, 0x0C, 0x77, 0x40, 0x7B, 0x0E, 0x02, 0x77, 0x30, 0x3C, 0x06, 0x77, 0x40,
  0xDB, 0x0A, 0x77, 0x40, 0x9B, 0x0E, 0x01, 0x77, 0x30, 0x4C, 0x04, 0x77, 0x30, 0x10, 0xEB, 0x08,
  0x77, 0x40, 0xAB, 0x0C, 0x77, 0x40, 0x6C, 0x02, 0x77, 0x30, 0x20, 0xEB, 0x06, 0x77, 0x40, 0xCB,
  0x0B, 0x77, 0x40, 0x8B, 0x0E, 0x01, 0x77, 0x30, 0x3C, 0x04, 0x77, 0x30, 0x10, 0xDB, 0x09, 0x77,
  0x40, 0xAB, 0x0D, 0x72, 0x81, 0x5F, 0x76, 0x05, 0xC0, 0x27, 0x28, 0x1A, 0xF4, 0x50, 0x10, 0xEB,
  0x07, 0x72, 0x01, 0xA6, 0x0B, 0xB0, 0xB7, 0x38, 0x18, 0xFC, 0x50, 0x7B, 0x0E, 0x01, 0x71, 0x01,
  0x07, 0xA0, 0x84, 0x01, 0xD8, 0x04, 0xED, 0x04, 0x40, 0x5F, 0xFC, 0x01, 0x40,
  // "[" (U+005B)
  0x70, 0x6F, 0x09, 0x70, 0x9E, 0x0E, 0x05, 0x70, 0xDB, 0x09, 0x02, 0x73, 0xB0, 0xC7, 0x40, 0x4B,
  0x07, 0x74, 0x07, 0xB0, 0x37, 0x40, 0xAB, 0x75, 0x0D, 0xA0, 0xC7, 0x40, 0x1B, 0x09, 0x74, 0x04,
  0xB0, 0x67, 0x40, 0x8B, 0x02, 0x74, 0x0B, 0xA0, 0xE7, 0x50, 0xEA, 0x0B, 0x74, 0x02, 0xB0, 0x87,
  0x40, 0x5B, 0x05, 0x74, 0x08, 0xB0, 0x17, 0x40, 0xCA, 0x0D, 0x75, 0xB0, 0xA7, 0x40, 0x3B, 0x07,
  0x74, 0x06, 0xB0, 0x37, 0x40, 0x9B, 0x75, 0x0C, 0xA0, 0xC7, 0x5B, 0x09, 0x74, 0x03, 0xB0, 0x67,
  0x40, 0x7B, 0x02, 0x74, 0x0A, 0xA0, 0xE7, 0x50, 0xDA, 0x0B, 0x74, 0x01, 0xB0, 0x87, 0x40, 0x4B,
  0x05, 0x74, 0x07, 0xB0, 0x17, 0x40, 0xBA, 0x0D, 0x75, 0x0E, 0xA0, 0xA7, 0x40, 0x2B, 0x09, 0x74,
  0x05, 0xB0, 0xD0, 0x27, 0x30, 0x8E, 0x0E, 0x05, 0x70, 0xBF, 0x03, 0x70,
  // "\" (U+005C)
  0x9F, 0x70, 0x9F, 0x70, 0x8F, 0x80, 0x7F, 0x90, 0x7F, 0x90, 0x6F, 0xA0, 0x5F, 0xB0, 0x5F, 0xB0,
  0x4F, 0xC0, 0x3F, 0xC0, 0x3F, 0xD0, 0x2F, 0xE0, 0x1F, 0xE0, 0x1F, 0xF0, 0x0F, 0xF0, 0x0F, 0xF1,
  0x0E, 0xF1, 0x0E, 0xF2, 0x0D, 0xF3, 0x0C, 0xF3, 0x0C, 0xF4, 0x0B, 0xF5, 0x0A, 0xF5, 0x0A, 0xF6,
  0x09, 0xF7, 0x08, 0xF7, 0x08, 0xF8, 0x07, 0xF9, 0x07, 0xF9, 0x06, 0xFA, 0x05, 0xFB, 0x05, 0xFB,
  0x04, 0xFC, 0x03, 0xFD, 0x03, 0xFD, 0x01, 0x76,
  // "]" (U+005D)
  0x70, 0x6F, 0x09, 0x70, 0x80, 0xEE, 0x05, 0x73, 0x04, 0xC0, 0x27, 0x40, 0xCA, 0x0E, 0x75, 0x0E,
  0xA0, 0xB7, 0x40, 0x1B, 0x08, 0x74, 0x04, 0xB0, 0x57, 0x40, 0x8B, 0x01, 0x74, 0x0B, 0xA0, 0xE7,
  0x50, 0xEA, 0x0A, 0x74, 0x02, 0xB0, 0x77, 0x40, 0x5B, 0x04, 0x74, 0x09, 0xB0, 0x17, 0x40, 0xCA,
  0x0D, 0x75, 0xB0, 0xA7, 0x40, 0x3B, 0x06, 0x74, 0x06, 0xB0, 0x37, 0x40, 0xAB, 0x75, 0x0D, 0xA0,
  0xC7, 0x40, 0x1B, 0x09, 0x74, 0x04, 0xB0, 0x67, 0x40, 0x7B, 0x02, 0x74, 0x0B, 0xA0, 0xE7, 0x50,
  0xEA, 0x0B, 0x74, 0x02, 0xB0, 0x87, 0x40, 0x5B, 0x05, 0x74, 0x08, 0xB0, 0x27, 0x40, 0xCA, 0x0E,
  0x75, 0xB0, 0xB7, 0x40, 0x3B, 0x07, 0x74, 0x06, 0xB0, 0x47, 0x40, 0xAB, 0x01, 0x73, 0x01, 0x0E,
  0xA0, 0xD7, 0x30, 0x30, 0xBB, 0x0A, 0x70, 0x70, 0xEE, 0x07, 0x70, 0xBF, 0x04, 0x70,
  // "^" (U+005E)
  0x68, 0x11, 0xF7, 0x76, 0x81, 0x8F, 0xD7, 0x60, 0xDA, 0x04, 0x74, 0x04, 0xB0, 0xB7, 0x48, 0x1B,
  0xF8, 0xA0, 0x17, 0x20, 0x1A, 0x82, 0x1A, 0xF7, 0x72, 0x85, 0x7F, 0xA0, 0x4F, 0xD7, 0x28, 0x1D,
  0xF4, 0x28, 0x1D, 0xF4, 0x78, 0x14, 0xFD, 0x38, 0x17, 0xFB, 0x78, 0x1A, 0xF7, 0x30, 0x1A, 0x01,
  0x50, 0x1A, 0x02, 0x48, 0x1B, 0xF7, 0x58, 0x17, 0xFB, 0x58, 0x15, 0xFD, 0x58, 0x1D, 0xF5, 0x68,
  0x1E, 0xF4, 0x38, 0x14, 0xFE, 0x78, 0x18, 0xFB, 0x38, 0x1A, 0xF9, 0x70, 0x2A, 0x81, 0x10, 0x1A,
  0x03, 0x71, 0x85, 0xCF, 0x70, 0x7F, 0xC7, 0x28, 0x55, 0xFD, 0x0D, 0xF6, 0x73, 0x81, 0xEF, 0x40,
  // "_" (U+005F)
  0x10, 0xD8, 0x09, 0x3E, 0x00, 0x2F, 0xF9, 0x0E, 0x10,
  // "`" (U+0060)
  0x83, 0x17, 0x77, 0x53, 0x0D, 0xA0, 0xD3, 0x04, 0xB0, 0x33, 0x08, 0xA0, 0x94, 0x81, 0xCF, 0xE4,
  0x82, 0x1E, 0xF5, 0x48, 0x13, 0xFA,
  // "a" (U+0061)
  0x71, 0x89, 0x15, 0xBD, 0xFE, 0xA4, 0x06, 0xF3, 0x60, 0x20, 0xDF, 0x0C, 0xA6, 0x04, 0xB8, 0x3A,
  0x20, 0x1A, 0xB0, 0xD5, 0x03, 0x0E, 0xA0, 0x75, 0xB0, 0x95, 0x0D, 0xA0, 0xA5, 0x02, 0xB0, 0x64,
  0x09, 0xA0, 0xE0, 0x15, 0x05, 0xB0, 0x33, 0x02, 0xB0, 0x86, 0x08, 0xB4, 0x09, 0xB0, 0x16, 0x0B,
  0xA0, 0xC4, 0x0E, 0xA0, 0xB7, 0x0E, 0xA0, 0x93, 0x05, 0xB0, 0x66, 0x02, 0xB0, 0x63, 0x0A, 0xB0,
  0x26, 0x05, 0xB0, 0x33, 0x0E, 0xA0, 0xE7, 0x09, 0xB3, 0x01, 0xB0, 0xB7, 0x0D, 0xA0, 0xC3, 0x04,
  0xB0, 0x86, 0x03, 0xB0, 0x93, 0x05, 0xB0, 0x76, 0x0A, 0xB0, 0x63, 0x06, 0xB0, 0x65, 0x01, 0xC0,
  0x33, 0x05, 0xB0, 0x65, 0x0A, 0x0C, 0xB0, 0x13, 0x03, 0xB0, 0x84, 0x81, 0x4D, 0x7B, 0x50, 0xEA,
  0x0B, 0x38, 0x22, 0xE5, 0x8B, 0x50, 0x9B, 0x85, 0x60, 0x4E, 0x90, 0x8B, 0x85, 0x40, 0x69, 0x01,
  0xED, 0x09, 0x20, 0x3E, 0x08, 0x28, 0x42, 0xBE, 0xEB, 0x54, 0x84, 0x6D, 0xEC, 0x81, 0x10,
  // "b" (U+0062)
  0x30, 0xAE, 0x74, 0x0D, 0xD0, 0xD7, 0x50, 0x20, 0xCB, 0x09, 0x76, 0x06, 0xB0, 0x67, 0x60, 0x7B,
  0x03, 0x76, 0x09, 0xB7, 0x70, 0xDA, 0x0C, 0x77, 0xB0, 0x97, 0x60, 0x4B, 0x05, 0x76, 0x07, 0xB8,
  0x62, 0x02, 0x9D, 0xFC, 0x56, 0x0A, 0xA8, 0x1D, 0x05, 0xE0, 0x65, 0x0E, 0xA8, 0x59, 0x4F, 0x70,
  0x2E, 0xA0, 0xE0, 0x13, 0x01, 0xB8, 0x16, 0xE6, 0x30, 0x6B, 0x05, 0x30, 0x5B, 0x0B, 0x0A, 0x40,
  0x2B, 0x09, 0x30, 0x8B, 0x0E, 0x01, 0x40, 0x1B, 0x0B, 0x30, 0xBB, 0x08, 0x50, 0x1B, 0x0B, 0x30,
  0xEB, 0x01, 0x50, 0x1B, 0x0B, 0x20, 0x2B, 0x09, 0x60, 0x3B, 0x0A, 0x20, 0x6B, 0x03, 0x60, 0x5B,
  0x07, 0x20, 0x9A, 0x0E, 0x70, 0x8B, 0x05, 0x20, 0xCA, 0x0B, 0x70, 0xBB, 0x01, 0x2B, 0x08, 0x7B,
  0x0C, 0x20, 0x3B, 0x04, 0x60, 0x5B, 0x06, 0x20, 0x7B, 0x01, 0x60, 0xBA, 0x0E, 0x01, 0x20, 0xAA,
  0x0D, 0x60, 0x2B, 0x08, 0x30, 0xDA, 0x0A, 0x60, 0xAA, 0x0E, 0x30, 0x1B, 0x07, 0x50, 0x4B, 0x04,
  0x30, 0x4B, 0x05, 0x40, 0x20, 0xEA, 0x08, 0x40, 0x8B, 0x84, 0xE4, 0x01, 0x6E, 0xA0, 0x95, 0x82,
  0xBF, 0xCE, 0xE0, 0xE0, 0x66, 0x89, 0x1E, 0xB0, 0x18, 0xCE, 0xEC, 0x71, 0x70,
  // "c" (U+0063)
  0x71, 0x85, 0x6B, 0xEF, 0xEB, 0x57, 0x10, 0x40, 0xDF, 0x09, 0x60, 0x6A, 0x83, 0xD4, 0x02, 0xDB,
  0x04, 0x40, 0x5A, 0x0E, 0x01, 0x30, 0x4B, 0x08, 0x30, 0x3B, 0x04, 0x5B, 0x06, 0x30, 0xCA, 0x0B,
  0x68, 0x1D, 0xFD, 0x30, 0x5B, 0x03, 0x60, 0x80, 0x74, 0x0D, 0xA0, 0xD7, 0x50, 0x3B, 0x08, 0x75,
  0x08, 0xB0, 0x37, 0x50, 0xCB, 0x76, 0xB0, 0xC7, 0x50, 0x2B, 0x0A, 0x75, 0x04, 0xB0, 0x97, 0x50,
  0x4B, 0x08, 0x75, 0x03, 0xB0, 0x87, 0x50, 0x1B, 0x0A, 0x76, 0x0D, 0xA0, 0xE7, 0x02, 0x05, 0x40,
  0x6B, 0x06, 0x58, 0x12, 0xD6, 0x50, 0xCB, 0x06, 0x28, 0x21, 0x7E, 0xD6, 0x01, 0x0B, 0xF0, 0xD0,
  0x27, 0x18, 0x55, 0xBE, 0xFD, 0xB6, 0x60,
  // "d" (U+0064)
  0x76, 0x07, 0xE0, 0x27, 0x60, 0x9D, 0x0E, 0x77, 0x10, 0x10, 0x9B, 0x0B, 0x77, 0x20, 0x2B, 0x08,
  0x77, 0x20, 0x3B, 0x05, 0x77, 0x20, 0x6B, 0x02, 0x77, 0x20, 0x8A, 0x0E, 0x77, 0x30, 0xBA, 0x0B,
  0x77, 0x30, 0xEA, 0x07, 0x73, 0x85, 0x5B, 0xDF, 0xD8, 0x3B, 0x04, 0x71, 0x03, 0x0D, 0xFB, 0x01,
  0x70, 0x4B, 0x83, 0xA2, 0x02, 0xBB, 0x0D, 0x70, 0x3B, 0x07, 0x50, 0xEA, 0x0A, 0x60, 0x10, 0xDA,
  0x0A, 0x6B, 0x07, 0x60, 0x9A, 0x0E, 0x01, 0x50, 0x4B, 0x04, 0x50, 0x2B, 0x08, 0x60, 0x7B, 0x01,
  0x50, 0x9B, 0x01, 0x60, 0xAA, 0x0D, 0x50, 0x1B, 0x0B, 0x70, 0xDA, 0x0A, 0x50, 0x6B, 0x07, 0x60,
  0x1B, 0x06, 0x50, 0xAB, 0x03, 0x60, 0x5B, 0x03, 0x50, 0xEA, 0x0E, 0x70, 0x8B, 0x50, 0x2B, 0x0B,
  0x70, 0xDA, 0x0C, 0x50, 0x4B, 0x09, 0x60, 0x3B, 0x09, 0x50, 0x5B, 0x07, 0x60, 0x9B, 0x06, 0x50,
  0x6B, 0x06, 0x50, 0x1C, 0x04, 0x50, 0x5B, 0x06, 0x50, 0x90, 0xEB, 0x01, 0x50, 0x3B, 0x08, 0x48,
  0x14, 0xE8, 0xB7, 0x0E, 0xA0, 0xB3, 0x82, 0x2E, 0x68, 0xB7, 0x09, 0xB8, 0x56, 0x04, 0xEA, 0x08,
  0xB8, 0x24, 0x06, 0xA3, 0x02, 0x0E, 0xD0, 0xA2, 0x04, 0xE0, 0x84, 0x84, 0x2B, 0xEE, 0xB5, 0x48,
  0x47, 0xDE, 0xC8, 0x13,
  // "e" (U+0065)
  0x71, 0x85, 0x6B, 0xEF, 0xEA, 0x37, 0x10, 0x40, 0xDF, 0x04, 0x60, 0x6A, 0x83, 0xC3, 0x03, 0xEA,
  0x0D, 0x50, 0x5A, 0x0D, 0x01, 0x30, 0xAB, 0x01, 0x30, 0x3B, 0x02, 0x40, 0x9B, 0x01, 0x30, 0xCA,
  0x0A, 0x50, 0xBA, 0x0E, 0x30, 0x5B, 0x02, 0x40, 0x1B, 0x0A, 0x30, 0xDA, 0x0A, 0x50, 0xAB, 0x02,
  0x20, 0x3B, 0x05, 0x30, 0x10, 0xAB, 0x05, 0x30, 0x8B, 0x83, 0x10, 0x38, 0xEA, 0x0E, 0x05, 0x40,
  0xCF, 0xA0, 0xA0, 0x15, 0xE8, 0x2E, 0xB7, 0x26, 0x02, 0xB0, 0x97, 0x50, 0x4B, 0x07, 0x75, 0x04,
  0xB0, 0x77, 0x50, 0x3B, 0x08, 0x75, 0x01, 0xB0, 0xA7, 0x60, 0xCA, 0x0E, 0x70, 0x10, 0x54, 0x06,
  0xB0, 0x65, 0x81, 0x2D, 0x75, 0x0B, 0xB0, 0x62, 0x83, 0x28, 0xEE, 0x15, 0x01, 0x0B, 0xF0, 0xE0,
  0x47, 0x18, 0x65, 0xBD, 0xFE, 0xC7, 0x15,
  // "f" (U+0066)
  0x77, 0x18, 0x55, 0xBE, 0xFE, 0xC6, 0x77, 0x10, 0xBF, 0x08, 0x76, 0x0B, 0xA8, 0x2C, 0x10, 0xAB,
  0x75, 0x05, 0xB0, 0x22, 0x04, 0xA0, 0xE7, 0x50, 0xCA, 0x0B, 0x30, 0x1A, 0x06, 0x74, 0x02, 0xB0,
  0x64, 0x05, 0x01, 0x75, 0x06, 0xB0, 0x27, 0x74, 0x0A, 0xA0, 0xE7, 0x75, 0x0D, 0xA0, 0xB7, 0x71,
  0x81, 0x18, 0xCF, 0x90, 0x67, 0x48, 0x16, 0xEE, 0xC8, 0x00, 0xE0, 0x27, 0x70, 0x8B, 0x77, 0x50,
  0xBA, 0x0D, 0x77, 0x50, 0xEA, 0x09, 0x77, 0x40, 0x2B, 0x06, 0x77, 0x40, 0x5B, 0x03, 0x77, 0x40,
  0x8B, 0x77, 0x50, 0xBA, 0x0C, 0x77, 0x50, 0xEA, 0x09, 0x77, 0x40, 0x2B, 0x06, 0x77, 0x40, 0x5B,
  0x03, 0x77, 0x40, 0x9B, 0x77, 0x50, 0xCA, 0x0C, 0x77, 0x5B, 0x09, 0x77, 0x40, 0x3B, 0x06, 0x77,
  0x40, 0x6B, 0x03, 0x77, 0x40, 0x9B, 0x77, 0x50, 0xCA, 0x0C, 0x77, 0x5B, 0x09, 0x77, 0x40, 0x3B,
  0x06, 0x77, 0x40, 0x6B, 0x02, 0x77, 0x40, 0x9A, 0x0E, 0x77, 0x50, 0xDA, 0x0B, 0x77, 0x40, 0x1B,
  0x07, 0x77, 0x40, 0x5B, 0x02, 0x77, 0x40, 0xAA, 0x0C, 0x77, 0x40, 0x10, 0xEA, 0x05, 0x77, 0x40,
  0x8A, 0x0C, 0x77, 0x10, 0x12, 0x07, 0xA0, 0xE0, 0x27, 0x71, 0x0D, 0xC0, 0xE0, 0x37, 0x72, 0x84,
  0xCF, 0xEC, 0x71, 0x77, 0x30,
  // "g" (U+0067)
  0x77, 0x58, 0x22, 0xBE, 0xC7, 0x48, 0x90, 0x17, 0xCE, 0xEC, 0x50, 0x2E, 0xB0, 0x47, 0x20, 0x40,
  0xEE, 0x82, 0x8D, 0xFE, 0xA0, 0x27, 0x10, 0x5A, 0x83, 0xD4, 0x02, 0xCA, 0x0C, 0x20, 0xB0, 0x77,
  0x10, 0x2A, 0x0E, 0x02, 0x30, 0x5A, 0x0E, 0x75, 0x0B, 0xA0, 0x74, 0x02, 0xB0, 0x27, 0x30, 0x3B,
  0x01, 0x40, 0x1B, 0x04, 0x73, 0x09, 0xA0, 0xB5, 0x02, 0xB0, 0x27, 0x30, 0xDA, 0x07, 0x50, 0x5B,
  0x74, 0xB0, 0x45, 0x08, 0xA0, 0xB7, 0x30, 0x1B, 0x03, 0x50, 0xDA, 0x06, 0x74, 0xB0, 0x44, 0x05,
  0xA0, 0xE7, 0x50, 0xDA, 0x07, 0x30, 0x10, 0xDA, 0x05, 0x75, 0x07, 0xA8, 0x3E, 0x40, 0x3C, 0xA0,
  0x87, 0x70, 0xBF, 0x07, 0x77, 0x10, 0x4A, 0x83, 0xEE, 0xC8, 0x27, 0x71, 0x82, 0x9F, 0xB1, 0x77,
  0x58, 0x19, 0xFB, 0x77, 0x60, 0x1A, 0x07, 0x77, 0x60, 0x3A, 0x83, 0xE8, 0x53, 0x27, 0x72, 0x01,
  0xF9, 0x81, 0xD8, 0x17, 0x60, 0x6F, 0xA0, 0xE0, 0x57, 0x40, 0x50, 0xBF, 0xC0, 0x17, 0x18, 0x92,
  0x2C, 0xFD, 0x51, 0x01, 0x24, 0x7E, 0xB0, 0x77, 0x82, 0x2E, 0xFB, 0x71, 0x01, 0x0E, 0xA0, 0xA7,
  0x82, 0xCF, 0xE1, 0x72, 0x09, 0xA0, 0xA6, 0x04, 0xA0, 0xA7, 0x30, 0x8A, 0x09, 0x60, 0x6A, 0x09,
  0x73, 0x0B, 0xA0, 0x56, 0x06, 0xA0, 0xA7, 0x20, 0x2A, 0x0E, 0x70, 0x3B, 0x02, 0x70, 0x10, 0xDA,
  0x05, 0x71, 0x0B, 0xA8, 0x1D, 0x51, 0x38, 0x13, 0x8E, 0xA0, 0x77, 0x30, 0xBF, 0xB0, 0xD0, 0x47,
  0x58, 0x24, 0x9C, 0xEA, 0x82, 0xEC, 0x94, 0x74,
  // "h" (U+0068)
  0x30, 0x3E, 0x07, 0x75, 0x05, 0xE0, 0x37, 0x70, 0x6C, 0x77, 0x20, 0xEA, 0x0C, 0x77, 0x2B, 0x09,
  0x77, 0x10, 0x2B, 0x05, 0x77, 0x10, 0x5B, 0x02, 0x77, 0x10, 0x9A, 0x0E, 0x77, 0x20, 0xCA, 0x0B,
  0x77, 0x2B, 0x08, 0x28, 0x43, 0xAE, 0xFD, 0x57, 0x03, 0xB8, 0x14, 0x07, 0xE0, 0x36, 0x06, 0xB8,
  0x41, 0x8E, 0x50, 0x3B, 0x0A, 0x60, 0x9A, 0x82, 0xD5, 0xE2, 0x30, 0xCA, 0x0D, 0x60, 0xCA, 0x81,
  0xCE, 0x44, 0x0B, 0xA0, 0xE6, 0xC0, 0x95, 0x0D, 0xA0, 0xD5, 0x03, 0xC0, 0x15, 0xB0, 0xA5, 0x07,
  0xB0, 0x95, 0x03, 0xB0, 0x75, 0x0A, 0xB0, 0x15, 0x06, 0xB0, 0x45, 0x0D, 0xA0, 0xB6, 0x0A, 0xB0,
  0x14, 0x01, 0xB0, 0x66, 0x0D, 0xA0, 0xD5, 0x04, 0xB0, 0x36, 0xB0, 0xA5, 0x07, 0xB6, 0x03, 0xB0,
  0x75, 0x0B, 0xA0, 0xC6, 0x07, 0xB0, 0x35, 0x0E, 0xA0, 0x96, 0x0A, 0xB0, 0x14, 0x02, 0xB0, 0x66,
  0x0C, 0xA0, 0xD5, 0x05, 0xB0, 0x36, 0x0E, 0xA0, 0xB5, 0x08, 0xB7, 0xB0, 0x95, 0x0B, 0xA0, 0xC7,
  0xB0, 0x95, 0x0E, 0xA0, 0x97, 0x0D, 0xA8, 0x4D, 0x02, 0x92, 0x2B, 0x05, 0x70, 0x7D, 0x81, 0xE3,
  0x5B, 0x02, 0x71, 0x83, 0x8E, 0xEC, 0x72,
  // "i" (U+0069)
  0x58, 0x27, 0xED, 0x34, 0x03, 0xB0, 0xB4, 0x06, 0xB0, 0xC4, 0x05, 0xB0, 0x95, 0x82, 0xBE, 0xB1,
  0x80, 0xC1, 0x0E, 0x81, 0x70, 0x3E, 0x04, 0x30, 0x3C, 0x50, 0xCA, 0x0D, 0x50, 0xEA, 0x0A, 0x40,
  0x1B, 0x06, 0x40, 0x5B, 0x03, 0x40, 0x8B, 0x50, 0xBA, 0x0D, 0x50, 0xEA, 0x09, 0x40, 0x2B, 0x06,
  0x40, 0x6B, 0x03, 0x40, 0x9B, 0x50, 0xCA, 0x0C, 0x5B, 0x09, 0x40, 0x2B, 0x06, 0x40, 0x4B, 0x04,
  0x40, 0x6B, 0x02, 0x40, 0x6B, 0x02, 0x40, 0x4B, 0x82, 0x70, 0x4C, 0x20, 0xDD, 0x87, 0xA1, 0x03,
  0xCF, 0xEA, 0x42,
  // "j" (U+006A)
  0x75, 0x82, 0x6E, 0xD4, 0x74, 0x02, 0xB0, 0xC7, 0x40, 0x6B, 0x0D, 0x74, 0x05, 0xB0, 0xA7, 0x58,
  0x2A, 0xEC, 0x28, 0x09, 0x84, 0x00, 0xED, 0x07, 0x71, 0x02, 0xE0, 0x47, 0x30, 0x3C, 0x01, 0x74,
  0x0C, 0xA0, 0xD7, 0x50, 0xDA, 0x0A, 0x74, 0x01, 0xB0, 0x77, 0x40, 0x4B, 0x04, 0x74, 0x07, 0xB0,
  0x17, 0x40, 0xAA, 0x0D, 0x75, 0x0D, 0xA0, 0xA7, 0x40, 0x1B, 0x06, 0x74, 0x04, 0xB0, 0x37, 0x40,
  0x8B, 0x75, 0x0B, 0xA0, 0xC7, 0x50, 0xEA, 0x09, 0x74, 0x02, 0xB0, 0x67, 0x40, 0x5B, 0x03, 0x74,
  0x08, 0xB7, 0x50, 0xBA, 0x0C, 0x75, 0x0E, 0xA0, 0x97, 0x40, 0x2B, 0x06, 0x74, 0x05, 0xB0, 0x27,
  0x40, 0x8A, 0x0E, 0x75, 0x0C, 0xA0, 0xB7, 0x5B, 0x07, 0x74, 0x04, 0xB0, 0x37, 0x40, 0xAA, 0x0D,
  0x74, 0x01, 0x0E, 0xA0, 0x67, 0x40, 0x9A, 0x0D, 0x71, 0x01, 0x20, 0x8B, 0x03, 0x71, 0x0D, 0xD0,
  0x57, 0x28, 0x4C, 0xEF, 0xD8, 0x27, 0x30,
  // "k" (U+006B)
  0x30, 0x3E, 0x07, 0x76, 0x05, 0xE0, 0x37, 0x71, 0x06, 0xC7, 0x73, 0x0E, 0xA0, 0xC7, 0x73, 0xB0,
  0x97, 0x72, 0x02, 0xB0, 0x67, 0x72, 0x05, 0xB0, 0x27, 0x72, 0x09, 0xA0, 0xE7, 0x73, 0x0C, 0xA0,
  0xB7, 0x73, 0xB0, 0x83, 0x03, 0xF0, 0x74, 0x03, 0xB0, 0x53, 0x06, 0xF0, 0x54, 0x06, 0xB0, 0x14,
  0x01, 0xB8, 0x1E, 0x71, 0x50, 0x9A, 0x0E, 0x50, 0x3A, 0x0D, 0x02, 0x70, 0xCA, 0x0A, 0x58, 0x2C,
  0xFC, 0x17, 0x1B, 0x07, 0x48, 0x1A, 0xFB, 0x72, 0x03, 0xB0, 0x33, 0x81, 0xAF, 0xB7, 0x30, 0x7B,
  0x38, 0x1A, 0xFB, 0x74, 0x0A, 0xA0, 0xC2, 0x81, 0xBF, 0xB7, 0x50, 0xDA, 0x81, 0x80, 0xBA, 0x09,
  0x74, 0x01, 0xB0, 0x50, 0xCB, 0x0E, 0x74, 0x04, 0xB8, 0x1D, 0xFA, 0xB0, 0x57, 0x30, 0x7C, 0x81,
  0x50, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE0, 0x32, 0x09, 0xB0, 0x17, 0x20, 0xEA, 0x09, 0x30, 0x4B,
  0x07, 0x71, 0x02, 0xB0, 0x54, 0x0E, 0xA0, 0xC7, 0x10, 0x5B, 0x02, 0x40, 0xAB, 0x02, 0x70, 0x8A,
  0x0E, 0x50, 0x5B, 0x09, 0x70, 0xBA, 0x0C, 0x60, 0xEA, 0x0E, 0x02, 0x60, 0xEA, 0x09, 0x60, 0x9B,
  0x0D, 0x03, 0x40, 0x2B, 0x05, 0x60, 0x10, 0xDC, 0x09, 0x30, 0x5B, 0x02, 0x78, 0x41, 0x8C, 0xEF,
  0x63,
  // "l" (U+006C)
  0x20, 0x7E, 0x05, 0x20, 0x9E, 0x02, 0x40, 0x8B, 0x0E, 0x6B, 0x0B, 0x50, 0x1B, 0x08, 0x50, 0x4B,
  0x05, 0x50, 0x7B, 0x01, 0x50, 0xAA, 0x0E, 0x60, 0xDA, 0x0A, 0x50, 0x1B, 0x07, 0x50, 0x4B, 0x04,
  0x50, 0x8B, 0x01, 0x50, 0xBA, 0x0D, 0x60, 0xEA, 0x09, 0x50, 0x2B, 0x06, 0x50, 0x5B, 0x03, 0x50,
  0x9B, 0x60, 0xCA, 0x0C, 0x6B, 0x09, 0x50, 0x3B, 0x05, 0x50, 0x6B, 0x02, 0x50, 0x9A, 0x0E, 0x60,
  0xCA, 0x0B, 0x6B, 0x08, 0x50, 0x3B, 0x06, 0x50, 0x5B, 0x04, 0x50, 0x7B, 0x02, 0x50, 0x7B, 0x02,
  0x50, 0x5B, 0x82, 0x60, 0x5C, 0x30, 0xED, 0x09, 0x38, 0x43, 0xCF, 0xDA, 0x33,
  // "m" (U+006D)
  0x10, 0x3E, 0x06, 0x28, 0x43, 0xAE, 0xFC, 0x44, 0x84, 0x29, 0xDF, 0xD7, 0x40, 0x5E, 0x81, 0x30,
  0x7E, 0x02, 0x20, 0x6E, 0x05, 0x50, 0x6C, 0x18, 0x37, 0xD4, 0x05, 0xB8, 0x68, 0x05, 0xE5, 0x02,
  0xEA, 0x0C, 0x60, 0xEA, 0x82, 0xC4, 0xD1, 0x30, 0xEA, 0x82, 0xB3, 0xE2, 0x30, 0xAB, 0x6B, 0x81,
  0xBD, 0x34, 0x0D, 0xA8, 0x1C, 0xC5, 0x40, 0x9B, 0x01, 0x40, 0x2C, 0x08, 0x50, 0xEB, 0x0B, 0x50,
  0xAB, 0x50, 0x5B, 0x0E, 0x50, 0x1C, 0x03, 0x50, 0xCA, 0x0D, 0x50, 0x9B, 0x07, 0x50, 0x4B, 0x0B,
  0x6B, 0x0A, 0x50, 0xCB, 0x01, 0x50, 0x7B, 0x05, 0x50, 0x3B, 0x07, 0x5B, 0x0A, 0x60, 0xBA, 0x0E,
  0x60, 0x7B, 0x04, 0x40, 0x3B, 0x05, 0x60, 0xEA, 0x0B, 0x60, 0xAB, 0x50, 0x6B, 0x01, 0x50, 0x2B,
  0x07, 0x60, 0xDA, 0x0D, 0x50, 0x9A, 0x0D, 0x60, 0x5B, 0x04, 0x50, 0x1B, 0x09, 0x50, 0xCA, 0x0A,
  0x60, 0x8B, 0x01, 0x50, 0x4B, 0x06, 0x5B, 0x07, 0x60, 0xBA, 0x0D, 0x60, 0x7B, 0x03, 0x40, 0x3B,
  0x04, 0x60, 0xEA, 0x0A, 0x60, 0xAB, 0x50, 0x6B, 0x01, 0x50, 0x1B, 0x08, 0x60, 0xCA, 0x0D, 0x50,
  0x9A, 0x0D, 0x60, 0x3B, 0x05, 0x60, 0xDA, 0x0C, 0x50, 0xDA, 0x0A, 0x60, 0x6B, 0x03, 0x60, 0xCA,
  0x0C, 0x5B, 0x07, 0x60, 0x8B, 0x01, 0x60, 0xAA, 0x84, 0xE1, 0x18, 0x53, 0xB0, 0x46, 0x0A, 0xB7,
  0x04, 0xD8, 0x1E, 0x57, 0xB0, 0x16, 0x0C, 0xA0, 0xD7, 0x18, 0x47, 0xEF, 0xD8, 0x11,
  // "n" (U+006E)
  0x10, 0x2E, 0x04, 0x28, 0x44, 0xAE, 0xFC, 0x44, 0x05, 0xE8, 0x11, 0x08, 0xE0, 0x25, 0x07, 0xB8,
  0x5E, 0x08, 0xD4, 0x04, 0xB0, 0x96, 0x0E, 0xA8, 0x2B, 0x5E, 0x23, 0x0E, 0xA0, 0xC6, 0xB8, 0x1C,
  0xE3, 0x40, 0xDA, 0x0D, 0x50, 0x2C, 0x08, 0x5B, 0x0C, 0x50, 0x5B, 0x0E, 0x01, 0x40, 0x1B, 0x09,
  0x50, 0x9B, 0x07, 0x50, 0x4B, 0x06, 0x50, 0xCB, 0x01, 0x50, 0x7B, 0x03, 0x5B, 0x0A, 0x60, 0xAB,
  0x50, 0x3B, 0x06, 0x60, 0xEA, 0x0C, 0x50, 0x6B, 0x02, 0x50, 0x2B, 0x09, 0x50, 0x9A, 0x0E, 0x60,
  0x5B, 0x06, 0x50, 0xCA, 0x0B, 0x60, 0x8B, 0x02, 0x5B, 0x08, 0x60, 0xBB, 0x50, 0x3B, 0x05, 0x60,
  0xEA, 0x0C, 0x50, 0x6B, 0x01, 0x6B, 0x09, 0x50, 0x9A, 0x0E, 0x60, 0x1B, 0x08, 0x50, 0xDA, 0x0B,
  0x60, 0x1B, 0x08, 0x5B, 0x07, 0x70, 0xEA, 0x84, 0xC0, 0x2A, 0x13, 0xB0, 0x47, 0x07, 0xD8, 0x1D,
  0x37, 0xB0, 0x17, 0x18, 0x39, 0xEE, 0xC6, 0x20,
  // "o" (U+006F)
  0x78, 0x61, 0x7B, 0xEF, 0xDA, 0x47, 0x20, 0x50, 0xEF, 0x09, 0x70, 0x8A, 0x0D, 0x05, 0x20, 0x5B,
  0x08, 0x50, 0x7A, 0x0D, 0x01, 0x40, 0x7B, 0x02, 0x30, 0x4B, 0x03, 0x50, 0x1B, 0x08, 0x30, 0xDA,
  0x09, 0x70, 0xEA, 0x0B, 0x20, 0x6B, 0x02, 0x70, 0xDA, 0x0D, 0x20, 0xDA, 0x0C, 0x71, 0x0D, 0xA8,
  0x1E, 0x04, 0xB0, 0x77, 0x10, 0xEA, 0x81, 0xE0, 0x9B, 0x03, 0x71, 0xB8, 0x1D, 0x0D, 0xB7, 0x10,
  0x2B, 0x0A, 0x1B, 0x0C, 0x71, 0x04, 0xB0, 0x70, 0x2B, 0x0A, 0x71, 0x08, 0xB0, 0x30, 0x4B, 0x08,
  0x71, 0x0C, 0xA8, 0x1E, 0x04, 0xB0, 0x77, 0x01, 0xB8, 0x18, 0x03, 0xB0, 0x77, 0x07, 0xB8, 0x12,
  0x01, 0xB0, 0x87, 0x0E, 0xA0, 0x93, 0x0D, 0xA0, 0xB6, 0x08, 0xA0, 0xD0, 0x13, 0x07, 0xB0, 0x24,
  0x04, 0xB0, 0x35, 0x0D, 0xA8, 0x3D, 0x30, 0x17, 0xB0, 0x46, 0x02, 0x0D, 0xF0, 0xC0, 0x37, 0x28,
  0x57, 0xCE, 0xED, 0xA5, 0x70,
  // "p" (U+0070)
  0x30, 0x1E, 0x03, 0x28, 0x46, 0xCE, 0xEA, 0x15, 0x03, 0xE2, 0x0B, 0xD0, 0xD0, 0x16, 0x04, 0xB8,
  0x5D, 0x0B, 0xD3, 0x06, 0xB0, 0x87, 0x0C, 0xA8, 0x2A, 0x7D, 0x13, 0x0D, 0xA0, 0xD7, 0x0D, 0xA8,
  0x1A, 0xE3, 0x40, 0xAB, 0x01, 0x6C, 0x08, 0x50, 0x8B, 0x03, 0x50, 0x3C, 0x01, 0x50, 0x7B, 0x04,
  0x50, 0x6B, 0x09, 0x60, 0x8B, 0x03, 0x50, 0xAB, 0x02, 0x60, 0xAB, 0x02, 0x50, 0xDA, 0x0C, 0x70,
  0xCB, 0x6B, 0x08, 0x7B, 0x0C, 0x50, 0x4B, 0x04, 0x60, 0x3B, 0x08, 0x50, 0x7B, 0x01, 0x60, 0x7B,
  0x04, 0x50, 0xAA, 0x0D, 0x70, 0xCA, 0x0E, 0x60, 0xDA, 0x09, 0x60, 0x3B, 0x08, 0x50, 0x1B, 0x06,
  0x60, 0x9A, 0x0E, 0x01, 0x50, 0x4B, 0x03, 0x50, 0x2B, 0x08, 0x60, 0x7B, 0x60, 0xCA, 0x0D, 0x70,
  0xAA, 0x0D, 0x50, 0x9A, 0x0E, 0x03, 0x70, 0xEB, 0x83, 0xA2, 0x02, 0xAA, 0x0E, 0x04, 0x70, 0x1F,
  0xB0, 0xC0, 0x27, 0x10, 0x5B, 0x85, 0x3A, 0xDF, 0xDB, 0x57, 0x30, 0x8A, 0x0D, 0x77, 0x30, 0xBA,
  0x0B, 0x77, 0x30, 0xEA, 0x08, 0x77, 0x20, 0x2B, 0x05, 0x77, 0x20, 0x5B, 0x01, 0x77, 0x20, 0x8B,
  0x77, 0x30, 0xBB, 0x77, 0x30, 0xEB, 0x06, 0x77, 0x10, 0x2E, 0x09, 0x76, 0x05, 0xE0, 0x77, 0x60,
  // "q" (U+0071)
  0x71, 0x89, 0x15, 0xBD, 0xFE, 0xB5, 0x08, 0xF5, 0x60, 0x20, 0xCF, 0xB0, 0x25, 0x04, 0x0E, 0xA8,
  0x3A, 0x20, 0x1B, 0xB0, 0xE5, 0x03, 0x0E, 0xA0, 0x85, 0x0E, 0xA0, 0xB5, 0x0D, 0xA0, 0xB5, 0x01,
  0xB0, 0x84, 0x09, 0xB0, 0x15, 0x04, 0xB0, 0x53, 0x02, 0xB0, 0x96, 0x07, 0xB0, 0x13, 0x09, 0xB0,
  0x26, 0x0A, 0xA0, 0xE3, 0x01, 0x0E, 0xA0, 0xC7, 0x0D, 0xA0, 0xA3, 0x06, 0xB0, 0x76, 0x01, 0xB0,
  0x73, 0x0A, 0xB0, 0x36, 0x04, 0xB0, 0x43, 0x0E, 0xA0, 0xE7, 0x08, 0xB0, 0x12, 0x01, 0xB0, 0xC7,
  0x0D, 0xA0, 0xD3, 0x03, 0xB0, 0x96, 0x03, 0xB0, 0xA3, 0x04, 0xB0, 0x76, 0x0A, 0xB0, 0x63, 0x04,
  0xB0, 0x75, 0x02, 0xC0, 0x33, 0x03, 0xB0, 0x75, 0x0A, 0x0D, 0xB4, 0x02, 0xB0, 0x84, 0x81, 0x4C,
  0x9A, 0x0C, 0x50, 0xEA, 0x0C, 0x38, 0x22, 0xD3, 0xDA, 0x09, 0x50, 0x8B, 0x84, 0x60, 0x4D, 0x81,
  0xB0, 0x65, 0x01, 0x0D, 0xD8, 0x19, 0x04, 0xB0, 0x26, 0x84, 0x1A, 0xEE, 0xB4, 0x20, 0x8A, 0x0E,
  0x77, 0x10, 0xBA, 0x0B, 0x77, 0x10, 0xEA, 0x08, 0x77, 0x01, 0xB0, 0x57, 0x70, 0x4B, 0x02, 0x77,
  0x07, 0xA0, 0xE7, 0x71, 0x0A, 0xA0, 0xB7, 0x71, 0x0D, 0xA0, 0xB7, 0x71, 0xB0, 0xE0, 0x47, 0x60,
  0x3E, 0x03, 0x74, 0x06, 0xE4,
  // "r" (U+0072)
  0x10, 0x6E, 0x38, 0x37, 0xDE, 0xD5, 0x20, 0x8D, 0x0C, 0x20, 0xBD, 0x02, 0x30, 0x6B, 0x84, 0xA0,
  0xAF, 0xEE, 0xB0, 0x54, 0x0E, 0xA8, 0x48, 0x4F, 0x80, 0x1B, 0x05, 0x40, 0xDA, 0x81, 0x6C, 0xA3,
  0x81, 0xCF, 0xE5, 0xB8, 0x1A, 0xE1, 0x38, 0x19, 0xA2, 0x40, 0x3C, 0x06, 0x74, 0x07, 0xB0, 0xE7,
  0x50, 0xAB, 0x07, 0x75, 0x0D, 0xB0, 0x27, 0x40, 0x1B, 0x0B, 0x75, 0x04, 0xB0, 0x77, 0x50, 0x7B,
  0x02, 0x75, 0x0B, 0xA0, 0xE7, 0x60, 0xEA, 0x0A, 0x75, 0x01, 0xB0, 0x77, 0x50, 0x5B, 0x04, 0x75,
  0x08, 0xB0, 0x17, 0x50, 0xBA, 0x0D, 0x76, 0x0E, 0xA0, 0x97, 0x50, 0x2B, 0x06, 0x75, 0x05, 0xB0,
  0x37, 0x50,
  // "s" (U+0073)
  0x58, 0x61, 0x7C, 0xEF, 0xEB, 0x66, 0x05, 0x0E, 0xF0, 0xC4, 0x05, 0xA0, 0xE0, 0x52, 0x06, 0xB0,
  0x83, 0x0E, 0xA0, 0x34, 0x09, 0xA0, 0xC2, 0x05, 0xA0, 0xD5, 0x04, 0xA0, 0xA2, 0x08, 0xA0, 0xB5,
  0x82, 0x2F, 0xD3, 0x20, 0x8A, 0x0D, 0x60, 0x34, 0x07, 0xB0, 0x77, 0x30, 0x3C, 0x09, 0x73, 0x09,
  0xC0, 0xD0, 0x57, 0x20, 0x9D, 0x0A, 0x72, 0x06, 0x0E, 0xC0, 0xB7, 0x20, 0x10, 0xAC, 0x07, 0x73,
  0x06, 0xB0, 0xE7, 0x40, 0x9B, 0x83, 0x10, 0x3C, 0x96, 0x04, 0xB8, 0x32, 0x0D, 0xFA, 0x60, 0x2B,
  0x2A, 0x0E, 0x60, 0x5A, 0x0C, 0x2B, 0x05, 0x50, 0xBA, 0x06, 0x20, 0xAA, 0x0E, 0x05, 0x20, 0x30,
  0xBA, 0x0B, 0x30, 0x10, 0xCF, 0x90, 0xA6, 0x86, 0x6B, 0xEF, 0xED, 0x93, 0x50,
  // "t" (U+0074)
  0x68, 0x13, 0xF9, 0x72, 0x81, 0xCF, 0x57, 0x10, 0x6A, 0x02, 0x70, 0x5A, 0x0E, 0x60, 0x30, 0xAB,
  0x0B, 0x50, 0xCF, 0xA8, 0x29, 0x0E, 0xEC, 0x80, 0x0E, 0x05, 0x30, 0x9B, 0x71, 0x0C, 0xA0, 0xC7,
  0x1B, 0x09, 0x70, 0x3B, 0x06, 0x70, 0x6B, 0x03, 0x70, 0x9B, 0x71, 0x0D, 0xA0, 0xC7, 0x1B, 0x09,
  0x70, 0x3B, 0x06, 0x70, 0x7B, 0x03, 0x70, 0xAB, 0x71, 0x0D, 0xA0, 0xC7, 0x1B, 0x09, 0x70, 0x3B,
  0x06, 0x70, 0x5B, 0x04, 0x70, 0x6B, 0x02, 0x70, 0x5B, 0x03, 0x70, 0x2B, 0x0A, 0x20, 0x40, 0xA4,
  0x0A, 0xE0, 0xD0, 0x14, 0x84, 0x9E, 0xFE, 0xB5, 0x40,
  // "u" (U+0075)
  0x02, 0xE0, 0x76, 0x0B, 0xA8, 0x1D, 0x05, 0xE0, 0x46, 0x0E, 0xA0, 0xA3, 0x05, 0xC0, 0x15, 0x02,
  0xB0, 0x74, 0x0D, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0xA6, 0x08, 0xB0, 0x13, 0x01, 0xB0,
  0x76, 0x0B, 0xA0, 0xD4, 0x04, 0xB0, 0x36, 0x0E, 0xA0, 0xA4, 0x08, 0xB6, 0x02, 0xB0, 0x74, 0x0B,
  0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0x96, 0x09, 0xB0, 0x13, 0x03, 0xB0, 0x66, 0x0C, 0xA0,
  0xD4, 0x06, 0xB0, 0x36, 0xB0, 0xA4, 0x09, 0xB6, 0x05, 0xB0, 0x64, 0x0D, 0xA0, 0xC6, 0x0A, 0xB0,
  0x33, 0x01, 0xB0, 0x95, 0x02, 0xC4, 0x04, 0xB0, 0x65, 0x09, 0xB0, 0xD4, 0x05, 0xB0, 0x44, 0x03,
  0xC0, 0xB4, 0x07, 0xB0, 0x34, 0x81, 0xC9, 0xEA, 0x0A, 0x40, 0x6B, 0x04, 0x30, 0xA0, 0xC1, 0xB0,
  0xA4, 0x03, 0xB8, 0x6A, 0x02, 0xBD, 0x10, 0xEA, 0x85, 0xD0, 0x19, 0x20, 0xCD, 0x0D, 0x01, 0x20,
  0x9D, 0x87, 0xE3, 0x02, 0xBE, 0xFC, 0x75, 0x83, 0x9E, 0xEC, 0x72,
  // "v" (U+0076)
  0x08, 0xD7, 0x84, 0x5E, 0xD4, 0x0A, 0xD0, 0x15, 0x02, 0xB0, 0xE2, 0x01, 0x0C, 0xB0, 0x35, 0x06,
  0xC0, 0x22, 0x04, 0xB0, 0x56, 0x04, 0xB0, 0x32, 0x01, 0xB0, 0x67, 0x0A, 0xA0, 0x23, 0xB0, 0x87,
  0x07, 0xA4, 0x0D, 0xA0, 0x97, 0x81, 0x7F, 0xD4, 0x0B, 0xA0, 0xB7, 0x81, 0xAF, 0x94, 0x0A, 0xA0,
  0xD7, 0x81, 0xDF, 0x44, 0x08, 0xA0, 0xE6, 0x81, 0x3F, 0xD5, 0x07, 0xB0, 0x15, 0x81, 0x9F, 0x75,
  0x05, 0xB0, 0x24, 0x82, 0x1E, 0xE1, 0x50, 0x3B, 0x04, 0x48, 0x18, 0xF7, 0x60, 0x2B, 0x05, 0x38,
  0x12, 0xFE, 0x71, 0xB0, 0x63, 0x81, 0xAF, 0x57, 0x10, 0xEA, 0x07, 0x28, 0x14, 0xFB, 0x72, 0x0C,
  0xA0, 0x92, 0x81, 0xDE, 0x27, 0x20, 0xBA, 0x83, 0xA0, 0x9F, 0x67, 0x30, 0x9A, 0x82, 0xB6, 0xFA,
  0x74, 0x08, 0xA8, 0x2E, 0xFD, 0x17, 0x40, 0x6B, 0x0E, 0x02, 0x75, 0x04, 0xA0, 0xD0, 0x47, 0x70,
  0x17, 0x50,
  // "w" (U+0077)
  0x0B, 0xC0, 0xC7, 0x09, 0xA0, 0xB6, 0x83, 0xAE, 0x90, 0xEC, 0x0C, 0x70, 0xEA, 0x0B, 0x50, 0x6B,
  0x81, 0x30, 0x5B, 0x0C, 0x60, 0x5B, 0x0C, 0x50, 0x30, 0xDA, 0x05, 0x20, 0xBA, 0x0C, 0x60, 0xBB,
  0x0C, 0x60, 0x5A, 0x05, 0x20, 0x9A, 0x0C, 0x50, 0x1C, 0x0C, 0x60, 0x3A, 0x03, 0x20, 0x9A, 0x0B,
  0x58, 0x18, 0xFB, 0xA0, 0xD6, 0x04, 0xA3, 0x09, 0xA0, 0xB5, 0x81, 0xEE, 0x5A, 0x0D, 0x68, 0x17,
  0xFB, 0x30, 0x9A, 0x0B, 0x48, 0x25, 0xF9, 0x4A, 0x0D, 0x68, 0x1C, 0xF5, 0x30, 0xAA, 0x0B, 0x48,
  0x2C, 0xF2, 0x4A, 0x0D, 0x58, 0x12, 0xFE, 0x40, 0xAA, 0x0A, 0x38, 0x33, 0xFA, 0x04, 0xA0, 0xD5,
  0x81, 0x8F, 0x74, 0x0A, 0xA0, 0xA3, 0x83, 0x9F, 0x30, 0x4A, 0x0E, 0x50, 0x0E, 0x50, 0xAA, 0x0A,
  0x28, 0x11, 0xFC, 0x20, 0x4A, 0x0E, 0x48, 0x16, 0xF7, 0x50, 0xBA, 0x09, 0x28, 0x17, 0xF4, 0x20,
  0x4A, 0x0E, 0x40, 0xE0, 0xD6, 0x0B, 0xA0, 0x92, 0x0E, 0x0D, 0x30, 0x4A, 0x0E, 0x38, 0x17, 0xF5,
  0x60, 0xBA, 0x83, 0x90, 0x5F, 0x63, 0x05, 0xA0, 0xE2, 0x81, 0x1E, 0xB7, 0x0B, 0xA8, 0x28, 0x0C,
  0xD4, 0x05, 0xA0, 0xE2, 0x81, 0x9F, 0x27, 0x0C, 0xA8, 0x28, 0x4F, 0x64, 0x05, 0xA8, 0x3E, 0x03,
  0xF7, 0x71, 0x0C, 0xA8, 0x17, 0xBE, 0x50, 0x5A, 0x82, 0xE0, 0xDD, 0x72, 0x0C, 0xA8, 0x1B, 0xF7,
  0x50, 0x5A, 0x82, 0xD8, 0xF3, 0x72, 0x0C, 0xB0, 0xE6, 0x05, 0xC0, 0x97, 0x30, 0xDB, 0x07, 0x60,
  0x5B, 0x0D, 0x74, 0x82, 0xDF, 0xEB, 0x70, 0x6A, 0x0E, 0x04, 0x74, 0x02, 0x01, 0x72, 0x81, 0x13,
  0x17, 0x40,
  // "x" (U+0078)
  0x40, 0x3C, 0x0D, 0x60, 0x5C, 0x02, 0x40, 0x6D, 0x02, 0x50, 0xDB, 0x0E, 0x60, 0x10, 0xBB, 0x06,
  0x40, 0x7A, 0x09, 0x01, 0x71, 0x02, 0xB0, 0xB3, 0x82, 0x1E, 0xF9, 0x74, 0x0B, 0xA0, 0xE3, 0x81,
  0xAF, 0xC7, 0x50, 0x6B, 0x81, 0x40, 0x3A, 0x02, 0x75, 0x01, 0xB8, 0x38, 0x0C, 0xF6, 0x77, 0x0B,
  0xA8, 0x2C, 0x5F, 0xB7, 0x71, 0x06, 0xB8, 0x1E, 0xE1, 0x77, 0x10, 0x1C, 0x05, 0x77, 0x30, 0xBA,
  0x0E, 0x77, 0x40, 0xCB, 0x03, 0x77, 0x20, 0x9C, 0x08, 0x77, 0x18, 0x25, 0xFB, 0xBA, 0x0D, 0x77,
  0x83, 0x1E, 0xF2, 0x6B, 0x02, 0x76, 0x83, 0xCF, 0x80, 0x2B, 0x07, 0x75, 0x81, 0x8F, 0xD3, 0x0D,
  0xA0, 0xC7, 0x40, 0x4A, 0x05, 0x30, 0x9B, 0x01, 0x72, 0x82, 0x2E, 0xFB, 0x40, 0x5B, 0x07, 0x71,
  0x04, 0x0D, 0xA0, 0x24, 0x01, 0xB0, 0xE0, 0x25, 0x04, 0xC0, 0x86, 0x0C, 0xC0, 0xC4, 0x08, 0xB0,
  0xD7, 0x08, 0xC0, 0xA4,
  // "y" (U+0079)
  0x7D, 0x06, 0x78, 0x29, 0xEC, 0x26, 0x03, 0xD0, 0x96, 0x06, 0xB0, 0xC7, 0x10, 0x7B, 0x0C, 0x60,
  0x7C, 0x72, 0x0D, 0xB7, 0x05, 0xB7, 0x20, 0x8B, 0x03, 0x7B, 0x72, 0x05, 0xB0, 0x67, 0xA0, 0xD7,
  0x20, 0x2B, 0x09, 0x60, 0x1A, 0x0A, 0x73, 0x0E, 0xA0, 0xC6, 0x04, 0xA0, 0x57, 0x30, 0xBB, 0x60,
  0x7A, 0x01, 0x73, 0x07, 0xB0, 0x35, 0x81, 0xCF, 0xB7, 0x40, 0x4B, 0x06, 0x40, 0x2A, 0x04, 0x74,
  0x01, 0xB0, 0x94, 0x81, 0x7F, 0xD7, 0x60, 0xDA, 0x0C, 0x48, 0x1D, 0xF6, 0x76, 0x0A, 0xB3, 0x81,
  0x5F, 0xE7, 0x70, 0x6B, 0x02, 0x28, 0x1C, 0xF6, 0x77, 0x03, 0xB8, 0x35, 0x05, 0xFD, 0x77, 0x2B,
  0x83, 0x70, 0xCF, 0x67, 0x72, 0x0C, 0xA8, 0x2A, 0x5F, 0xD7, 0x73, 0x09, 0xA8, 0x2C, 0xDF, 0x47,
  0x73, 0x05, 0xC0, 0xB7, 0x74, 0x02, 0xC0, 0x27, 0x75, 0x0E, 0xA0, 0x87, 0x76, 0x81, 0xCF, 0xD7,
  0x76, 0x04, 0xA0, 0x47, 0x75, 0x82, 0x1E, 0xFA, 0x77, 0x68, 0x2C, 0xFE, 0x17, 0x75, 0x0B, 0xA0,
  0x47, 0x75, 0x0A, 0xA0, 0x77, 0x74, 0x02, 0x0C, 0xA0, 0x97, 0x50, 0x10, 0x23, 0x03, 0x09, 0xB0,
  0x87, 0x60, 0x7F, 0x0D, 0x04, 0x77, 0x86, 0x6C, 0xEF, 0xEC, 0x95, 0x77, 0x20,
  // "z" (U+007A)
  0x40, 0x4F, 0xD0, 0x24, 0x08, 0xB8, 0x00, 0xEC, 0x0E, 0x58, 0x2C, 0xFA, 0x14, 0x0B, 0xB0, 0x54,
  0x81, 0x1F, 0xD5, 0x06, 0xB0, 0xB5, 0x81, 0x5F, 0x54, 0x01, 0x0E, 0xA0, 0xE0, 0x15, 0x05, 0x09,
  0x50, 0xBB, 0x05, 0x75, 0x06, 0xB0, 0xA7, 0x50, 0x10, 0xEA, 0x0E, 0x01, 0x75, 0x0B, 0xB0, 0x57,
  0x50, 0x6B, 0x0A, 0x75, 0x01, 0x0E, 0xA0, 0xE0, 0x17, 0x50, 0xBB, 0x05, 0x75, 0x06, 0xB0, 0xA7,
  0x50, 0x20, 0xEA, 0x0E, 0x01, 0x75, 0x0B, 0xB0, 0x57, 0x50, 0x6B, 0x0A, 0x60, 0x60, 0x44, 0x02,
  0x0E, 0xA0, 0xE0, 0x15, 0x81, 0x4F, 0x64, 0x0B, 0xB0, 0x46, 0x81, 0xAF, 0x23, 0x06, 0xB0, 0x96,
  0x81, 0x2F, 0xE3, 0x02, 0x0E, 0xA0, 0xD0, 0x15, 0x82, 0x2C, 0xFA, 0x30, 0xAC, 0x80, 0x2E, 0xB0,
  0x63, 0x0E, 0xFE, 0x03, 0x30,
  // "{" (U+007B)
  0x73, 0x81, 0x6B, 0xEA, 0x0B, 0x72, 0x0B, 0xC0, 0xE0, 0x87, 0x10, 0x9B, 0x09, 0x01, 0x72, 0x02,
  0xB0, 0xB7, 0x40, 0x7B, 0x04, 0x74, 0x0C, 0xA0, 0xE7, 0x5B, 0x0A, 0x74, 0x03, 0xB0, 0x77, 0x40,
  0x7B, 0x03, 0x74, 0x0A, 0xB7, 0x50, 0xEA, 0x0C, 0x74, 0x02, 0xB0, 0x97, 0x40, 0x5B, 0x06, 0x74,
  0x09, 0xB0, 0x27, 0x40, 0xEA, 0x0C, 0x74, 0x08, 0xB0, 0x47, 0x20, 0x30, 0xAB, 0x07, 0x71, 0x06,
  0xB8, 0x1E, 0xA3, 0x72, 0x09, 0xB0, 0xD0, 0x77, 0x40, 0x20, 0x9B, 0x0A, 0x75, 0x0A, 0xB0, 0x27,
  0x40, 0x7B, 0x05, 0x74, 0x07, 0xB0, 0x47, 0x40, 0x9B, 0x01, 0x74, 0x0C, 0xA0, 0xD7, 0x5B, 0x0A,
  0x74, 0x03, 0xB0, 0x67, 0x40, 0x6B, 0x03, 0x74, 0x09, 0xB7, 0x50, 0xCA, 0x0C, 0x75, 0xB0, 0x97,
  0x40, 0x2B, 0x07, 0x74, 0x02, 0xB0, 0x97, 0x50, 0xEA, 0x0E, 0x03, 0x74, 0x07, 0xD0, 0x87, 0x38,
  0x15, 0xBE, 0xA0, 0x67,
  // "|" (U+007C)
  0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F,
  0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4,
  0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD,
  0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD0,
  // "}" (U+007D)
  0x70, 0x7B, 0x0C, 0x05, 0x73, 0x09, 0xD0, 0x57, 0x40, 0x30, 0xEA, 0x0D, 0x75, 0x09, 0xB0, 0x17,
  0x40, 0x8B, 0x01, 0x74, 0x09, 0xB7, 0x50, 0xCA, 0x0C, 0x75, 0xB0, 0x97, 0x40, 0x3B, 0x06, 0x74,
  0x07, 0xB0, 0x37, 0x40, 0xAB, 0x75, 0x0D, 0xA0, 0xC7, 0x40, 0x1B, 0x09, 0x74, 0x04, 0xB0, 0x67,
  0x40, 0x5B, 0x05, 0x74, 0x03, 0xB0, 0x87, 0x50, 0xBB, 0x07, 0x01, 0x74, 0x08, 0x0D, 0xB0, 0x87,
  0x28, 0x13, 0x9E, 0xB0, 0x57, 0x10, 0x6B, 0x81, 0xB4, 0x17, 0x10, 0x3B, 0x08, 0x74, 0x0C, 0xA0,
  0xD7, 0x40, 0x2B, 0x08, 0x74, 0x06, 0xB0, 0x47, 0x40, 0xAB, 0x01, 0x74, 0x0D, 0xA0, 0xD7, 0x40,
  0x1B, 0x0A, 0x74, 0x04, 0xB0, 0x77, 0x40, 0x7B, 0x03, 0x74, 0x0B, 0xB7, 0x50, 0xEA, 0x0C, 0x74,
  0x04, 0xB0, 0x87, 0x40, 0xBB, 0x02, 0x72, 0x01, 0x09, 0xB0, 0x97, 0x10, 0x9D, 0x0B, 0x72, 0x0C,
  0xA8, 0x1D, 0xB6, 0x73,
  // "~" (U+007E)
  0x28, 0x37, 0xDD, 0xA2, 0x68, 0x39, 0xE7, 0x08, 0xC0, 0xE0, 0x35, 0x82, 0xCF, 0x61, 0xA8, 0x44,
  0x08, 0xFE, 0x34, 0x84, 0xEF, 0x37, 0xFB, 0x38, 0x28, 0xFE, 0x22, 0x85, 0x3F, 0xE0, 0xBF, 0x64,
  0x89, 0x2A, 0xFD, 0x30, 0xAF, 0x90, 0xDF, 0x45, 0x0B, 0xC0, 0xE0, 0x11, 0xA0, 0x26, 0x83, 0x7D,
  0xFC, 0x32,
  // "¡" (U+00A1)
  0x68, 0x28, 0xED, 0x55, 0x05, 0xB0, 0xE5, 0x08, 0xC5, 0x07, 0xB0, 0xB5, 0x83, 0x1B, 0xEC, 0x27,
  0x77, 0x50, 0x20, 0x17, 0x81, 0x4F, 0x67, 0x81, 0x9F, 0x47, 0x81, 0xDF, 0x16, 0x02, 0xA7, 0x81,
  0x6F, 0xC7, 0x81, 0xAF, 0xA7, 0x81, 0xEF, 0x86, 0x03, 0xA0, 0x66, 0x08, 0xA0, 0x36, 0x0C, 0xA0,
  0x15, 0x01, 0xA0, 0xE6, 0x05, 0xA0, 0xC6, 0x09, 0xA0, 0xA6, 0x0E, 0xA0, 0x75, 0x02, 0xB0, 0x55,
  0x07, 0xB0, 0x35, 0x0B, 0xB0, 0x15, 0xB0, 0xE5, 0x04, 0xB0, 0xC5, 0x08, 0xB0, 0x95, 0x83, 0x57,
  0x77, 0x35,
  // "¢" (U+00A2)
  0x73, 0x81, 0x3F, 0x97, 0x78, 0x17, 0xF6, 0x77, 0x81, 0xAF, 0x37, 0x48, 0x14, 0xAE, 0xA8, 0x1C,
  0x92, 0x70, 0x10, 0xAF, 0x90, 0x45, 0x01, 0x0C, 0xA8, 0x2D, 0x9F, 0xBB, 0x0D, 0x50, 0xCA, 0x84,
  0xD1, 0x6F, 0x49, 0xB0, 0x23, 0x09, 0xB8, 0x42, 0x09, 0xF1, 0x5B, 0x30, 0x4B, 0x08, 0x28, 0x2C,
  0xE0, 0x3A, 0x07, 0x30, 0xCB, 0x01, 0x29, 0x83, 0xA0, 0x18, 0x33, 0x04, 0xB0, 0xA2, 0x81, 0x3F,
  0x77, 0x09, 0xB0, 0x42, 0x81, 0x7F, 0x47, 0x0E, 0xB3, 0x81, 0xAF, 0x16, 0x03, 0xB0, 0xB3, 0x00,
  0xD7, 0x06, 0xB0, 0x82, 0x81, 0x1F, 0xA7, 0x09, 0xB0, 0x52, 0x81, 0x4F, 0x77, 0x0A, 0xB0, 0x32,
  0x81, 0x7F, 0x47, 0x0B, 0xB0, 0x22, 0x81, 0xAF, 0x17, 0x0B, 0xB0, 0x22, 0x0E, 0x0D, 0x71, 0x09,
  0xB8, 0x33, 0x01, 0xFA, 0x71, 0x06, 0xB8, 0x37, 0x05, 0xF6, 0x30, 0x60, 0x13, 0x01, 0xB8, 0x3D,
  0x08, 0xF3, 0x28, 0x15, 0xF2, 0x40, 0x8B, 0x86, 0xAC, 0xF1, 0x3A, 0xFA, 0x60, 0xBF, 0x90, 0xB7,
  0x10, 0x8C, 0x81, 0xDB, 0x57, 0x38, 0x21, 0x9F, 0x47, 0x78, 0x1A, 0xF2, 0x77, 0x0D, 0x0E, 0x77,
  0x19, 0x0C, 0x73,
  // "£" (U+00A3)
  0x73, 0x87, 0x17, 0xBE, 0xFE, 0xC8, 0x27, 0x40, 0x7F, 0x90, 0xE0, 0x47, 0x20, 0xAA, 0x0B, 0x03,
  0x20, 0x6B, 0x0E, 0x71, 0x08, 0xA0, 0xA5, 0x08, 0xB0, 0x46, 0x01, 0xB0, 0x15, 0x02, 0xB0, 0x36,
  0x08, 0xA0, 0xA7, 0xA0, 0xC7, 0x0C, 0xA0, 0x67, 0x81, 0xA7, 0x17, 0xB0, 0x37, 0x72, 0x01, 0xB0,
  0x27, 0x72, 0x01, 0xB0, 0x27, 0x72, 0x01, 0xB0, 0x37, 0x73, 0xB0, 0x47, 0x73, 0x0D, 0xA0, 0x67,
  0x60, 0x10, 0xFE, 0xC8, 0x01, 0xE0, 0x47, 0x05, 0xFD, 0x01, 0x74, 0x08, 0xA0, 0xA7, 0x73, 0x07,
  0xA0, 0xB7, 0x73, 0x07, 0xA0, 0xA7, 0x73, 0x08, 0xA0, 0x87, 0x73, 0x0A, 0xA0, 0x57, 0x73, 0x81,
  0xEF, 0xE7, 0x73, 0x05, 0xA0, 0x77, 0x73, 0x81, 0xDF, 0xC7, 0x73, 0x82, 0x9F, 0xC1, 0x77, 0x28,
  0x57, 0xFB, 0x68, 0x73, 0x60, 0x50, 0x35, 0x08, 0xA0, 0xEC, 0x86, 0xD7, 0x20, 0x28, 0xFA, 0x30,
  0x20, 0xBF, 0xF0, 0xB4, 0x86, 0xBF, 0xC7, 0x44, 0x5A, 0xF0, 0x75, 0x03, 0x04, 0x68, 0x51, 0x7C,
  0xFE, 0xA2, 0x60,
  // "¤" (U+00A4)
  0x77, 0x10, 0x13, 0x0A, 0x0B, 0x74, 0x83, 0x1D, 0x90, 0x5A, 0x83, 0xC1, 0x39, 0xDA, 0x83, 0xD8,
  0x22, 0xDA, 0x81, 0x40, 0x7A, 0x0E, 0xF9, 0x0E, 0xA0, 0x63, 0x06, 0xB0, 0x90, 0x32, 0x03, 0x09,
  0xB0, 0x54, 0x06, 0xA0, 0x56, 0x05, 0xA0, 0x44, 0x81, 0xDF, 0x97, 0x18, 0x19, 0xFC, 0x30, 0x2A,
  0x02, 0x71, 0x02, 0xA0, 0x22, 0x81, 0x4F, 0xE7, 0x3A, 0x04, 0x28, 0x14, 0xFE, 0x73, 0xA0, 0x42,
  0x02, 0xA0, 0x27, 0x10, 0x3A, 0x02, 0x38, 0x1D, 0xF9, 0x71, 0x81, 0xAF, 0xC4, 0x07, 0xA0, 0x66,
  0x07, 0xA0, 0x44, 0x06, 0xB8, 0x4A, 0x31, 0x13, 0xAB, 0x04, 0x30, 0x7A, 0x0E, 0xF9, 0x0E, 0xA8,
  0x15, 0x05, 0xA8, 0x92, 0xC1, 0x39, 0xCE, 0xEC, 0x81, 0x1D, 0xA8, 0x34, 0x0B, 0xC1, 0x73, 0x81,
  0x1C, 0xA1,
  // "¥" (U+00A5)
  0x20, 0xEF, 0x04, 0x30, 0xAE, 0x81, 0x50, 0x1F, 0x90, 0x13, 0x0D, 0xE0, 0x23, 0x0A, 0xB0, 0xD0,
  0x16, 0x06, 0xB0, 0x65, 0x03, 0xB0, 0x97, 0x03, 0xA0, 0x77, 0x0E, 0xA0, 0xA7, 0x81, 0x8F, 0xC7,
  0x10, 0xBA, 0x0D, 0x68, 0x21, 0xEF, 0x37, 0x10, 0x7B, 0x01, 0x58, 0x19, 0xF8, 0x72, 0x04, 0xB0,
  0x44, 0x81, 0x3F, 0xD7, 0x4B, 0x08, 0x48, 0x1C, 0xF4, 0x74, 0x0C, 0xA0, 0xB3, 0x81, 0x7F, 0x97,
  0x50, 0x9A, 0x0E, 0x28, 0x22, 0xFE, 0x17, 0x50, 0x6B, 0x83, 0x10, 0xBF, 0x57, 0x60, 0x2B, 0x82,
  0x45, 0xFA, 0x77, 0x10, 0xEA, 0x82, 0x7E, 0xE1, 0x77, 0x10, 0xBA, 0x81, 0xEF, 0x67, 0x58, 0x00,
  0xED, 0x80, 0x0E, 0x04, 0x70, 0x3F, 0xE0, 0x17, 0x50, 0x9B, 0x77, 0x40, 0xCA, 0x0D, 0x77, 0x40,
  0xEA, 0x0A, 0x76, 0xFE, 0x04, 0x70, 0x38, 0x00, 0xEC, 0x80, 0x1E, 0x01, 0x75, 0x09, 0xB7, 0x74,
  0x0C, 0xA0, 0xC7, 0x74, 0xB0, 0x97, 0x73, 0x05, 0xB0, 0x77, 0x72, 0x05, 0x0E, 0xB0, 0xB0, 0x17,
  0x50, 0x40, 0xEF, 0xA0, 0x87, 0x30, 0x7F, 0xB0, 0x57, 0x30,
  // "¦" (U+00A6)
  0x8D, 0x64, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F,
  0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD7, 0x77, 0x68, 0xD6, 0x4F, 0xD4, 0xFD,
  0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F, 0xD4, 0xFD, 0x4F,
  0xD4, 0xFD, 0x4F, 0xD4, 0xFD,
  // "§" (U+00A7)
  0x72, 0x86, 0x16, 0xBD, 0xFE, 0xB5, 0x73, 0x04, 0x0E, 0xF0, 0xA7, 0x10, 0x4A, 0x0A, 0x02, 0x20,
  0x7B, 0x06, 0x68, 0x21, 0xEF, 0x95, 0x0B, 0xA0, 0xC6, 0x07, 0xA0, 0x15, 0x05, 0xA0, 0xC6, 0x81,
  0xCF, 0xC6, 0x02, 0xA0, 0x96, 0x81, 0xEF, 0xC6, 0x81, 0x1B, 0x87, 0xA0, 0xE7, 0x72, 0xB0, 0x57,
  0x71, 0x0D, 0xA0, 0xE0, 0x37, 0x70, 0x8C, 0x06, 0x75, 0x02, 0x0D, 0xD0, 0xA0, 0x17, 0x28, 0x31,
  0xDE, 0x5E, 0xC0, 0xE0, 0x47, 0x18, 0x4B, 0xF4, 0x03, 0xDD, 0x05, 0x60, 0x3A, 0x30, 0x10, 0xAD,
  0x02, 0x50, 0x6A, 0x50, 0x50, 0xEB, 0x0A, 0x50, 0x8A, 0x03, 0x50, 0x30, 0xEB, 0x50, 0x7A, 0x0B,
  0x60, 0x5B, 0x01, 0x40, 0x5B, 0x0A, 0x60, 0xCA, 0x60, 0xEB, 0x0C, 0x02, 0x48, 0x19, 0xFD, 0x60,
  0x5D, 0x06, 0x38, 0x1B, 0xF7, 0x70, 0x7D, 0x84, 0xA0, 0x1F, 0xE1, 0x71, 0x05, 0x0E, 0xC8, 0x2B,
  0xBF, 0x47, 0x30, 0x20, 0xCD, 0x05, 0x76, 0x08, 0xC0, 0x27, 0x70, 0x7B, 0x06, 0x77, 0x10, 0xAA,
  0x08, 0x77, 0x10, 0x4A, 0x07, 0x58, 0x17, 0xE2, 0x70, 0x2A, 0x05, 0x40, 0x2A, 0x03, 0x70, 0x5A,
  0x01, 0x40, 0x4A, 0x08, 0x78, 0x1A, 0xFA, 0x50, 0x3A, 0x0E, 0x01, 0x58, 0x25, 0xFE, 0x26, 0x0C,
  0xA0, 0xD0, 0x42, 0x02, 0x08, 0xA0, 0x57, 0x02, 0x0D, 0xF0, 0xE0, 0x47, 0x38, 0x67, 0xBE, 0xFE,
  0xC7, 0x17, 0x10,
  // "¨" (U+00A8)
  0x08, 0xEB, 0x00, 0x01, 0xCE, 0x63, 0xFF, 0xF2, 0x00, 0x8F, 0xFC, 0x4F, 0xFF, 0x10, 0x0A, 0xFF,
  0xB1, 0xCE, 0x70, 0x00, 0x4E, 0xD3,
  // "©" (U+00A9)
  0x72, 0x87, 0x59, 0xCD, 0xED, 0xC9, 0x47, 0x71, 0x06, 0x0E, 0xFA, 0x0D, 0x05, 0x74, 0x01, 0x0B,
  0xA8, 0x7B, 0x62, 0x10, 0x13, 0x6C, 0xA0, 0xB7, 0x28, 0x31, 0xDF, 0xD4, 0x72, 0x82, 0x4D, 0xFC,
  0x71, 0x81, 0xCF, 0xB7, 0x58, 0x21, 0xCF, 0xB6, 0x81, 0x8F, 0xC4, 0x86, 0x28, 0xCE, 0xEC, 0x81,
  0x28, 0x21, 0xDF, 0x74, 0x82, 0x2F, 0xE2, 0x30, 0x8F, 0x0E, 0x02, 0x28, 0x23, 0xFE, 0x13, 0x81,
  0xAF, 0x73, 0x07, 0xA8, 0x69, 0x30, 0x15, 0xDF, 0xC3, 0x81, 0x9F, 0x82, 0x01, 0xA0, 0x12, 0x02,
  0xA0, 0x75, 0x03, 0xA0, 0x22, 0x81, 0x2F, 0xD2, 0x81, 0x5F, 0xA3, 0x81, 0x9F, 0xC7, 0x81, 0xCF,
  0x23, 0x85, 0xCF, 0x30, 0x9F, 0x53, 0x81, 0xEF, 0x67, 0x09, 0x08, 0x48, 0x57, 0xF7, 0x0C, 0xF2,
  0x20, 0x2A, 0x02, 0x76, 0x83, 0x4F, 0xA0, 0xE9, 0x30, 0x5A, 0x77, 0x84, 0x1F, 0xD0, 0xFE, 0x38,
  0x17, 0xFD, 0x77, 0x19, 0x82, 0xE1, 0xFD, 0x38, 0x17, 0xFD, 0x77, 0x1A, 0x81, 0x1F, 0xD3, 0x81,
  0x7F, 0xD7, 0x71, 0xA1, 0x90, 0xE3, 0x81, 0x6F, 0xE7, 0x71, 0x98, 0x1E, 0x0E, 0x93, 0x05, 0xA7,
  0x78, 0x51, 0xFD, 0x0C, 0xF2, 0x20, 0x2A, 0x03, 0x76, 0x85, 0x4F, 0xA0, 0x9F, 0x63, 0x81, 0xEF,
  0x87, 0x68, 0x57, 0xF7, 0x05, 0xFA, 0x38, 0x19, 0xFE, 0x70, 0x10, 0xD4, 0x83, 0xBF, 0x30, 0x1A,
  0x01, 0x20, 0x2A, 0x09, 0x60, 0xB9, 0x38, 0x11, 0xFE, 0x38, 0x1A, 0xF8, 0x30, 0x7A, 0x0A, 0x03,
  0x28, 0x23, 0xCF, 0x93, 0x81, 0x9F, 0x83, 0x82, 0x2F, 0xE2, 0x30, 0x8F, 0x0C, 0x38, 0x22, 0xFE,
  0x14, 0x81, 0x9F, 0xC4, 0x85, 0x39, 0xDF, 0xEB, 0x64, 0x81, 0xCF, 0x76, 0x81, 0xDF, 0xB7, 0x68,
  0x1B, 0xFB, 0x78, 0x31, 0xDF, 0xD3, 0x72, 0x83, 0x3D, 0xFC, 0x17, 0x10, 0x10, 0xCA, 0x81, 0xB5,
  0x23, 0x81, 0x25, 0xBA, 0x0B, 0x01, 0x74, 0x07, 0x0E, 0xFA, 0x0E, 0x06, 0x77, 0x18, 0x75, 0xAD,
  0xEF, 0xEC, 0x95, 0x71,
  // "ª" (U+00AA)
  0x58, 0x64, 0xBE, 0xED, 0x88, 0x94, 0x84, 0xAF, 0xC4, 0x4C, 0xA0, 0x93, 0x82, 0xBF, 0xD1, 0x20,
  0x7A, 0x05, 0x20, 0x7A, 0x04, 0x30, 0xBA, 0x84, 0x10, 0x1E, 0xFD, 0x4A, 0x0D, 0x20, 0x7A, 0x08,
  0x30, 0x4A, 0x09, 0x20, 0xCA, 0x03, 0x30, 0x8A, 0x05, 0x2B, 0x40, 0xEA, 0x81, 0x10, 0x1B, 0x38,
  0x26, 0xEF, 0xD2, 0x01, 0xB2, 0x83, 0x1D, 0xAF, 0xB3, 0x0E, 0xA8, 0x91, 0x51, 0xC6, 0xBF, 0xC0,
  0x50, 0x9C, 0x81, 0x90, 0xBB, 0x85, 0xC0, 0x1A, 0xFD, 0x72, 0x82, 0x3D, 0xE9, 0x10,
  // "«" (U+00AB)
  0x68, 0x12, 0xDD, 0x48, 0x1A, 0xF4, 0x58, 0x22, 0xDF, 0x43, 0x81, 0xAF, 0x95, 0x82, 0x1D, 0xF9,
  0x38, 0x19, 0xFD, 0x58, 0x21, 0xDF, 0xD3, 0x09, 0xA0, 0x44, 0x01, 0x0D, 0xA0, 0x32, 0x08, 0xA0,
  0x94, 0x01, 0x0C, 0xA0, 0x82, 0x08, 0xA0, 0xD4, 0x01, 0x0C, 0xA0, 0xD2, 0x07, 0xB0, 0x34, 0x06,
  0xB8, 0x13, 0x01, 0xB0, 0x95, 0x06, 0xB8, 0x14, 0x01, 0xB0, 0xA6, 0x0C, 0xA0, 0x82, 0x08, 0xA0,
  0xE6, 0x04, 0xA0, 0xC3, 0x0E, 0xA0, 0x26, 0x0B, 0xA0, 0x12, 0x06, 0xA0, 0x66, 0x02, 0xA0, 0x53,
  0x81, 0xDF, 0xA7, 0x81, 0x9F, 0x93, 0x81, 0x4F, 0xE7, 0x81, 0x1E, 0xD4, 0x81, 0xBF, 0x33,
  // "¬" (U+00AC)
  0x08, 0x80, 0x92, 0xE0, 0x9F, 0xF7, 0x50, 0x4A, 0x75, 0x04, 0xA7, 0x50, 0x4A, 0x75, 0x04, 0xA7,
  0x50, 0x4A, 0x75, 0x04, 0xA7, 0x50, 0x4A, 0x75, 0x04, 0xA7, 0x58, 0x12, 0x77,
  // "®" (U+00AE)
  0x72, 0x87, 0x59, 0xCD, 0xED, 0xC9, 0x47, 0x71, 0x06, 0x0E, 0xFA, 0x0D, 0x05, 0x74, 0x01, 0x0B,
  0xA8, 0x7B, 0x62, 0x10, 0x13, 0x6C, 0xA0, 0xB7, 0x28, 0x31, 0xDF, 0xD4, 0x72, 0x82, 0x4D, 0xFC,
  0x71, 0x81, 0xCF, 0xB7, 0x58, 0x21, 0xCF, 0xB6, 0x81, 0x8F, 0xC7, 0x78, 0x21, 0xDF, 0x74, 0x82,
  0x2F, 0xE2, 0x77, 0x18, 0x23, 0xFE, 0x13, 0x81, 0xAF, 0x72, 0x0C, 0xD8, 0x2E, 0xDA, 0x55, 0x81,
  0x9F, 0x82, 0x01, 0xA0, 0x12, 0x02, 0x06, 0xA8, 0x5A, 0x23, 0x5C, 0xFB, 0x48, 0x12, 0xFD, 0x28,
  0x15, 0xFA, 0x58, 0x1C, 0xF9, 0x48, 0x1D, 0xF7, 0x48, 0x5C, 0xF3, 0x09, 0xF5, 0x58, 0x1B, 0xF9,
  0x48, 0x19, 0xFC, 0x48, 0x57, 0xF7, 0x0C, 0xF2, 0x58, 0x1B, 0xF9, 0x48, 0x17, 0xFE, 0x48, 0x34,
  0xFA, 0x0E, 0x96, 0x81, 0xBF, 0x94, 0x81, 0x9F, 0xD4, 0x84, 0x1F, 0xD0, 0xFE, 0x68, 0x1B, 0xF9,
  0x48, 0x1D, 0xFA, 0x59, 0x82, 0xE1, 0xFD, 0x68, 0x1B, 0xF9, 0x20, 0x20, 0x9A, 0x02, 0x5A, 0x81,
  0x1F, 0xD6, 0x0B, 0xE0, 0xD0, 0x36, 0xA1, 0x90, 0xE6, 0x0B, 0xA0, 0xEB, 0x01, 0x79, 0x81, 0xE0,
  0xE9, 0x68, 0x3B, 0xF9, 0x01, 0xA0, 0x86, 0x85, 0x1F, 0xD0, 0xCF, 0x25, 0x81, 0xBF, 0x92, 0x82,
  0x8F, 0xE1, 0x58, 0x54, 0xFA, 0x09, 0xF6, 0x58, 0x1B, 0xF9, 0x28, 0x21, 0xEF, 0x85, 0x85, 0x7F,
  0x70, 0x5F, 0xA5, 0x81, 0xBF, 0x93, 0x07, 0xA0, 0x24, 0x83, 0xBF, 0x30, 0x1A, 0x01, 0x48, 0x1C,
  0xF9, 0x48, 0x1E, 0xF9, 0x38, 0x11, 0xFE, 0x38, 0x1A, 0xF8, 0x38, 0x33, 0xEF, 0xC2, 0x30, 0x7A,
  0x04, 0x28, 0x19, 0xF8, 0x38, 0x42, 0xFE, 0x20, 0xDD, 0x0B, 0x30, 0xEA, 0x83, 0xC2, 0xFE, 0x14,
  0x81, 0x9F, 0xC1, 0x80, 0x32, 0x38, 0x51, 0x22, 0x2C, 0xF7, 0x68, 0x1D, 0xFB, 0x76, 0x81, 0xBF,
  0xB7, 0x83, 0x1D, 0xFD, 0x37, 0x28, 0x33, 0xDF, 0xC1, 0x71, 0x01, 0x0C, 0xA8, 0x1B, 0x52, 0x38,
  0x12, 0x5B, 0xA0, 0xB0, 0x17, 0x40, 0x70, 0xEF, 0xA0, 0xE0, 0x67, 0x71, 0x87, 0x5A, 0xDE, 0xFE,
  0xC9, 0x57, 0x10,
  // "¯" (U+00AF)
  0x03, 0x80, 0x93, 0xE0, 0xC0, 0x7F, 0xF9, 0x09,
  // "°" (U+00B0)
  0x28, 0x43, 0xBE, 0xEC, 0x74, 0x05, 0xE0, 0xB2, 0x82, 0x1E, 0xF7, 0x28, 0x63, 0xDF, 0x70, 0x8F,
  0x94, 0x85, 0x2F, 0xE0, 0xCF, 0x25, 0x82, 0xBF, 0x3D, 0x96, 0x82, 0x9F, 0x5D, 0x96, 0x84, 0x9F,
  0x5C, 0xF2, 0x58, 0x4B, 0xF3, 0x8F, 0x94, 0x83, 0x2F, 0xE0, 0x1A, 0x07, 0x28, 0x23, 0xDF, 0x72,
  0x05, 0xE0, 0xB4, 0x84, 0x3B, 0xEF, 0xC7, 0x30,
  // "±" (U+00B1)
  0x7A, 0x04, 0x76, 0xA0, 0x47, 0x6A, 0x04, 0x76, 0xA0, 0x47, 0x6A, 0x04, 0x76, 0xA0, 0x47, 0x6A,
  0x04, 0x76, 0xA0, 0x46, 0x02, 0x80, 0x2E, 0xB8, 0x01, 0xE0, 0x70, 0x2F, 0xF0, 0x77, 0xA0, 0x47,
  0x6A, 0x04, 0x76, 0xA0, 0x47, 0x6A, 0x04, 0x76, 0xA0, 0x47, 0x6A, 0x04, 0x76, 0xA0, 0x48, 0x09,
  0x82, 0x00, 0x28, 0x09, 0x2E, 0x07, 0x02, 0xFF, 0x07,
  // "²" (U+00B2)
  0x68, 0x35, 0x9A, 0x96, 0x70, 0x30, 0xDD, 0x0D, 0x02, 0x48, 0x51, 0xEF, 0xE4, 0x08, 0xA0, 0xB4,
  0x06, 0xA0, 0x63, 0xB4, 0x81, 0x7F, 0xE4, 0x0E, 0xA0, 0x13, 0x81, 0x2D, 0xA4, 0xA0, 0xE7, 0x30,
  0x4A, 0x0A, 0x73, 0x0A, 0xA0, 0x27, 0x20, 0x4A, 0x08, 0x72, 0x82, 0x1E, 0xFB, 0x72, 0x82, 0x1D,
  0xFC, 0x72, 0x82, 0x1D, 0xFB, 0x72, 0x82, 0x1D, 0xFB, 0x72, 0x82, 0x2D, 0xFB, 0x30, 0x10, 0x34,
  0x82, 0x2E, 0xFA, 0x40, 0x70, 0xC3, 0x82, 0x3E, 0xF9, 0x48, 0x11, 0xE8, 0x20, 0x20, 0xEA, 0x80,
  0x1A, 0x81, 0xDF, 0x42, 0x08, 0xFB, 0x30,
  // "³" (U+00B3)
  0x58, 0x45, 0x8A, 0xA8, 0x45, 0x03, 0x0D, 0xE0, 0x93, 0x01, 0x0E, 0xA8, 0x26, 0x12, 0xDA, 0x05,
  0x20, 0x4A, 0x08, 0x30, 0x8A, 0x09, 0x20, 0x2A, 0x02, 0x30, 0x8A, 0x09, 0x30, 0x20, 0x44, 0x0C,
  0xA0, 0x57, 0x10, 0x6A, 0x0C, 0x70, 0x20, 0x8A, 0x09, 0x60, 0xCB, 0x09, 0x02, 0x78, 0x1A, 0xBE,
  0xA0, 0xA0, 0x17, 0x20, 0x9A, 0x0C, 0x73, 0x0E, 0xA0, 0x37, 0x20, 0xBA, 0x83, 0x50, 0x5F, 0x35,
  0x0B, 0xA8, 0x34, 0x0D, 0xF6, 0x40, 0x10, 0xEA, 0x28, 0x2D, 0xFD, 0x12, 0x01, 0x0B, 0xA0, 0x72,
  0x06, 0xA8, 0x1E, 0xBC, 0xB0, 0x74, 0x86, 0x4B, 0xEF, 0xEC, 0x82, 0x40,
  // "´" (U+00B4)
  0x48, 0x34, 0x77, 0x73, 0x30, 0x10, 0xEA, 0x0D, 0x01, 0x30, 0xAA, 0x0E, 0x02, 0x30, 0x4A, 0x0E,
  0x02, 0x38, 0x31, 0xDF, 0xE2, 0x48, 0x2A, 0xFD, 0x24, 0x82, 0x5F, 0xA1, 0x50,
  // "µ" (U+00B5)
  0x60, 0x2B, 0x07, 0x60, 0x9B, 0x60, 0x5B, 0x03, 0x60, 0xCA, 0x0C, 0x60, 0x8B, 0x7B, 0x09, 0x60,
  0xBA, 0x0D, 0x60, 0x2B, 0x06, 0x60, 0xEA, 0x0A, 0x60, 0x6B, 0x02, 0x50, 0x2B, 0x06, 0x60, 0x9A,
  0x0E, 0x60, 0x6B, 0x03, 0x60, 0xCA, 0x0C, 0x60, 0x9B, 0x7B, 0x08, 0x60, 0xCA, 0x0C, 0x60, 0x2B,
  0x05, 0x6B, 0x09, 0x60, 0x6B, 0x02, 0x50, 0x3B, 0x06, 0x60, 0x9A, 0x0E, 0x60, 0x6B, 0x03, 0x60,
  0xCA, 0x0B, 0x60, 0x9B, 0x7B, 0x08, 0x60, 0xCA, 0x0C, 0x60, 0x3B, 0x04, 0x6B, 0x09, 0x60, 0x7B,
  0x01, 0x50, 0x3B, 0x07, 0x60, 0xCA, 0x0E, 0x60, 0x7B, 0x06, 0x50, 0x3B, 0x0B, 0x60, 0xAB, 0x07,
  0x50, 0xBB, 0x08, 0x60, 0xEB, 0x0A, 0x40, 0x70, 0xEB, 0x07, 0x50, 0x3D, 0x85, 0x50, 0x18, 0xF3,
  0xDA, 0x82, 0xA0, 0x34, 0x28, 0x27, 0xFB, 0xBD, 0x82, 0xE4, 0x0A, 0xD0, 0xC2, 0x89, 0x0B, 0xF7,
  0x08, 0xDF, 0xD9, 0x22, 0x84, 0x1B, 0xEE, 0xB6, 0x3A, 0x04, 0x77, 0x30, 0x4A, 0x02, 0x77, 0x30,
  0x8A, 0x77, 0x40, 0xBA, 0x77, 0x48, 0x1E, 0xFE, 0x77, 0x30, 0x2B, 0x02, 0x77, 0x20, 0x3B, 0x0C,
  0x02, 0x77, 0x10, 0x3C, 0x0A, 0x77, 0x10, 0x2B, 0x0E, 0x02, 0x77, 0x28, 0x28, 0xEB, 0x27, 0x72,
  // "¶" (U+00B6)
  0x38, 0x15, 0xBE, 0xFF, 0x90, 0xD2, 0x0B, 0xFF, 0xA8, 0x3E, 0xB9, 0x08, 0xFA, 0x83, 0xC1, 0x11,
  0x6A, 0x0A, 0x40, 0xEF, 0xA0, 0xC3, 0x06, 0xA0, 0x23, 0x04, 0xFB, 0x0C, 0x30, 0x6A, 0x40, 0x7F,
  0xB0, 0xC3, 0x06, 0xA4, 0x08, 0xFB, 0x0C, 0x30, 0x6A, 0x40, 0x8F, 0xB0, 0xC3, 0x06, 0xA4, 0x07,
  0xFB, 0x0C, 0x30, 0x6A, 0x40, 0x5F, 0xB0, 0xC3, 0x06, 0xA4, 0x02, 0xFB, 0x0C, 0x30, 0x6A, 0x50,
  0xCF, 0xA0, 0xC3, 0x06, 0xA5, 0x04, 0xFA, 0x0C, 0x30, 0x6A, 0x60, 0x7F, 0x90, 0xC3, 0x06, 0xA7,
  0x81, 0x3A, 0xD0, 0xFE, 0xA0, 0xC3, 0x06, 0xA7, 0x68, 0x19, 0xFC, 0x30, 0x6A, 0x76, 0x81, 0x9F,
  0xC3, 0x06, 0xA7, 0x68, 0x19, 0xFC, 0x30, 0x6A, 0x76, 0x81, 0x9F, 0xC3, 0x06, 0xA7, 0x68, 0x19,
  0xFC, 0x30, 0x6A, 0x76, 0x81, 0x9F, 0xC3, 0x06, 0xA7, 0x68, 0x19, 0xFC, 0x30, 0x6A, 0x76, 0x81,
  0x9F, 0xC3, 0x06, 0xA7, 0x68, 0x19, 0xFC, 0x30, 0x6A, 0x76, 0x81, 0x9F, 0xC3, 0x06, 0xA7, 0x68,
  0x19, 0xFC, 0x30, 0x6A, 0x76, 0x81, 0x9F, 0xC3, 0x06, 0xA7, 0x68, 0x19, 0xFC, 0x30, 0x6A, 0x76,
  0x81, 0x9F, 0xC3, 0x06, 0xA7, 0x68, 0x19, 0xFC, 0x30, 0x6A, 0x76, 0x81, 0xAF, 0xC3, 0x06, 0xA0,
  0x17, 0x58, 0x1D, 0xFC, 0x30, 0x6A, 0x03, 0x73, 0x02, 0x09, 0xA0, 0xC3, 0x06, 0xA0, 0xC0, 0x47,
  0x06, 0xD0, 0xC3, 0x06, 0xD0, 0xC5, 0x06, 0xD0, 0xC3, 0x06, 0xD0, 0xD0,
  // "·" (U+00B7)
  0x08, 0xED, 0x55, 0xFF, 0xFE, 0x9F, 0xFF, 0xF8, 0xFF, 0xFC, 0x1B, 0xEB, 0x20,
  // "¸" (U+00B8)
  0x40, 0xB0, 0xE6, 0x81, 0x2F, 0x96, 0x09, 0xA0, 0x95, 0x04, 0x0B, 0xA0, 0x96, 0x0E, 0xA6, 0x0B,
  0xA0, 0x15, 0x87, 0xEF, 0xE0, 0x32, 0x13, 0xBA, 0x81, 0x90, 0xDD, 0x87, 0xC1, 0x0B, 0xEF, 0xEB,
  0x63,
  // "¹" (U+00B9)
  0x71, 0x00, 0x37, 0x09, 0xA5, 0x03, 0x0D, 0xA0, 0xC2, 0x81, 0x14, 0xAC, 0x09, 0x20, 0x8A, 0x0B,
  0x09, 0xA0, 0x52, 0x83, 0x2A, 0x70, 0xBA, 0x02, 0x68, 0x1E, 0xFE, 0x60, 0x2A, 0x0B, 0x60, 0x5A,
  0x08, 0x60, 0x8A, 0x05, 0x60, 0xCA, 0x01, 0x6A, 0x0E, 0x60, 0x3A, 0x0A, 0x60, 0x6A, 0x07, 0x60,
  0x9A, 0x04, 0x60, 0xDA, 0x01, 0x38, 0x11, 0x16, 0xB8, 0x25, 0x10, 0x5F, 0x90, 0xB0, 0x18, 0x04,
  0x30, 0x20,
  // "º" (U+00BA)
  0x48, 0x53, 0xAD, 0xFD, 0x92, 0x58, 0x79, 0xFE, 0x53, 0xCF, 0xE3, 0x38, 0x29, 0xFE, 0x22, 0x03,
  0xA0, 0xC2, 0x05, 0xA0, 0x83, 0x01, 0xB8, 0x11, 0x0E, 0xA0, 0x13, 0x01, 0xB0, 0x20, 0x5A, 0x0C,
  0x40, 0x2B, 0x01, 0x09, 0xA0, 0x84, 0x05, 0xA8, 0x1E, 0x0C, 0xA0, 0x54, 0x0A, 0xA8, 0x1A, 0x0D,
  0xA0, 0x44, 0x0E, 0xA8, 0x13, 0x0B, 0xA0, 0x43, 0x05, 0xA0, 0xA2, 0x07, 0xA0, 0x62, 0x83, 0x1D,
  0xFD, 0x13, 0x87, 0xCF, 0xD4, 0x4D, 0xFC, 0x25, 0x84, 0x8D, 0xFE, 0xB6, 0x50,
  // "»" (U+00BB)
  0x38, 0x1B, 0xF4, 0x38, 0x15, 0xF9, 0x68, 0x16, 0xFD, 0x30, 0x1A, 0x03, 0x50, 0x2A, 0x06, 0x38,
  0x1C, 0xFB, 0x68, 0x1D, 0xFD, 0x30, 0x8A, 0x04, 0x50, 0x9A, 0x07, 0x20, 0x3A, 0x0C, 0x50, 0x5A,
  0x0E, 0x01, 0x20, 0xEA, 0x06, 0x40, 0x1B, 0x08, 0x20, 0xAA, 0x0D, 0x40, 0x10, 0xEA, 0x09, 0x20,
  0xAA, 0x0E, 0x40, 0xAA, 0x82, 0xE2, 0x04, 0xB0, 0x63, 0x05, 0xA8, 0x3E, 0x20, 0x1E, 0xA0, 0x63,
  0x83, 0x1E, 0xFE, 0x22, 0x0A, 0xA0, 0x64, 0x82, 0xAF, 0xE3, 0x20, 0x5A, 0x07, 0x48, 0x25, 0xFE,
  0x32, 0x82, 0x1E, 0xF7, 0x48, 0x21, 0xEE, 0x33, 0x81, 0xBF, 0x85, 0x81, 0xBE, 0x33, 0x81, 0x6F,
  0x86,
  // "¼" (U+00BC)
  0x71, 0x00, 0x37, 0x77, 0x30, 0x9A, 0x75, 0x81, 0xDF, 0x77, 0x03, 0x0D, 0xA0, 0xC7, 0x48, 0x19,
  0xFD, 0x58, 0x11, 0x4A, 0xC0, 0x97, 0x30, 0x3A, 0x03, 0x50, 0x8A, 0x0B, 0x09, 0xA0, 0x57, 0x38,
  0x1C, 0xF9, 0x68, 0x32, 0xA7, 0x0B, 0xA0, 0x27, 0x28, 0x27, 0xFE, 0x17, 0x38, 0x1E, 0xFE, 0x72,
  0x82, 0x2E, 0xF5, 0x73, 0x02, 0xA0, 0xB7, 0x28, 0x1B, 0xFB, 0x74, 0x05, 0xA0, 0x87, 0x10, 0x5A,
  0x02, 0x74, 0x08, 0xA0, 0x57, 0x82, 0x1E, 0xF7, 0x75, 0x0C, 0xA0, 0x17, 0x81, 0x9F, 0xD7, 0x6A,
  0x0E, 0x70, 0x3A, 0x03, 0x75, 0x03, 0xA0, 0xA7, 0x81, 0xCF, 0x94, 0x82, 0x47, 0x72, 0x50, 0x6A,
  0x07, 0x68, 0x27, 0xFE, 0x13, 0x02, 0x0E, 0xA0, 0x35, 0x09, 0xA0, 0x45, 0x02, 0xA0, 0x53, 0x01,
  0x0D, 0xB6, 0x0D, 0xA0, 0x15, 0x81, 0xBF, 0xB4, 0x0B, 0x0E, 0xA0, 0xC3, 0x81, 0x11, 0x6B, 0x05,
  0x01, 0x30, 0x5A, 0x02, 0x38, 0x18, 0xF8, 0xA0, 0x92, 0x05, 0xF9, 0x84, 0xB0, 0x1E, 0xF7, 0x38,
  0x25, 0xF8, 0x7A, 0x06, 0x20, 0x18, 0x04, 0x38, 0x32, 0x09, 0xFD, 0x38, 0x32, 0xEB, 0x0B, 0xA0,
  0x27, 0x50, 0x3A, 0x03, 0x38, 0x5D, 0xD1, 0x0E, 0xFE, 0x76, 0x81, 0xDF, 0x93, 0x83, 0xAF, 0x30,
  0x2A, 0x0C, 0x75, 0x82, 0x7F, 0xE1, 0x28, 0x17, 0xF6, 0x20, 0x6A, 0x08, 0x74, 0x02, 0xA0, 0x52,
  0x81, 0x4F, 0x93, 0x09, 0xA0, 0x57, 0x48, 0x1B, 0xFB, 0x28, 0x61, 0xEF, 0xBA, 0xAA, 0xEA, 0x82,
  0xBA, 0xA1, 0x70, 0x6A, 0x02, 0x20, 0x5F, 0xC0, 0xE7, 0x82, 0x1E, 0xF7, 0x72, 0x03, 0xA0, 0xB7,
  0x38, 0x1A, 0xFD, 0x73, 0x07, 0xA0, 0x77, 0x20, 0x4A, 0x03, 0x73, 0x0C, 0xA0, 0x57, 0x28, 0x1D,
  0xF9, 0x71, 0x81, 0x4A, 0xDB, 0x81, 0xEB, 0x16, 0x82, 0x8F, 0xE1, 0x71, 0x09, 0xF3,
  // "½" (U+00BD)
  0x71, 0x00, 0x37, 0x77, 0x30, 0x9A, 0x74, 0x81, 0xDF, 0x77, 0x10, 0x30, 0xDA, 0x0C, 0x73, 0x81,
  0x9F, 0xD6, 0x81, 0x14, 0xAC, 0x09, 0x72, 0x03, 0xA0, 0x36, 0x08, 0xA0, 0xB0, 0x9A, 0x05, 0x72,
  0x81, 0xCF, 0x97, 0x83, 0x2A, 0x70, 0xBA, 0x02, 0x71, 0x82, 0x7F, 0xE1, 0x74, 0x81, 0xEF, 0xE7,
  0x18, 0x22, 0xEF, 0x57, 0x40, 0x2A, 0x0B, 0x71, 0x81, 0xBF, 0xB7, 0x50, 0x5A, 0x08, 0x70, 0x5A,
  0x02, 0x75, 0x08, 0xA0, 0x56, 0x82, 0x1E, 0xF7, 0x76, 0x0C, 0xA0, 0x16, 0x81, 0x9F, 0xD7, 0x7A,
  0x0E, 0x60, 0x3A, 0x03, 0x76, 0x03, 0xA0, 0xA6, 0x81, 0xCF, 0x92, 0x83, 0x59, 0xA9, 0x67, 0x06,
  0xA0, 0x75, 0x84, 0x7F, 0xE1, 0x3D, 0xD0, 0xD0, 0x25, 0x09, 0xA0, 0x44, 0x02, 0xA8, 0x65, 0x1E,
  0xFE, 0x40, 0x8A, 0x0B, 0x50, 0xDA, 0x01, 0x48, 0x3B, 0xFB, 0x06, 0xA0, 0x63, 0xB2, 0x81, 0x11,
  0x6B, 0x05, 0x01, 0x20, 0x5A, 0x83, 0x20, 0x7F, 0xE4, 0x0E, 0xA0, 0x10, 0x5F, 0x98, 0x3B, 0x1E,
  0xF7, 0x28, 0x12, 0xDA, 0x4A, 0x81, 0xE0, 0x18, 0x04, 0x38, 0x22, 0x9F, 0xD7, 0x20, 0x4A, 0x0A,
  0x73, 0x03, 0xA0, 0x37, 0x20, 0xAA, 0x02, 0x73, 0x81, 0xDF, 0x97, 0x20, 0x4A, 0x08, 0x73, 0x82,
  0x7F, 0xE1, 0x71, 0x82, 0x1E, 0xFB, 0x73, 0x02, 0xA0, 0x57, 0x18, 0x21, 0xDF, 0xC7, 0x48, 0x1B,
  0xFB, 0x71, 0x82, 0x1D, 0xFB, 0x74, 0x06, 0xA0, 0x27, 0x82, 0x1D, 0xFB, 0x74, 0x82, 0x1E, 0xF7,
  0x78, 0x22, 0xDF, 0xB3, 0x01, 0x03, 0x78, 0x1A, 0xFD, 0x78, 0x22, 0xEF, 0xA4, 0x07, 0x0C, 0x60,
  0x4A, 0x03, 0x68, 0x23, 0xEF, 0x94, 0x81, 0x1E, 0x86, 0x81, 0xDF, 0x96, 0x02, 0x0E, 0xA8, 0x01,
  0xA8, 0x1D, 0xF4, 0x58, 0x28, 0xFE, 0x16, 0x08, 0xFB, 0x30,
  // "¾" (U+00BE)
  0x58, 0x45, 0x8A, 0xA8, 0x47, 0x48, 0x1D, 0xF7, 0x50, 0x30, 0xDE, 0x09, 0x72, 0x81, 0x9F, 0xD5,
  0x01, 0x0E, 0xA8, 0x26, 0x12, 0xDA, 0x05, 0x70, 0x3A, 0x03, 0x50, 0x4A, 0x08, 0x30, 0x8A, 0x09,
  0x78, 0x1C, 0xF9, 0x60, 0x2A, 0x02, 0x30, 0x8A, 0x09, 0x68, 0x27, 0xFE, 0x17, 0x02, 0x04, 0x40,
  0xCA, 0x05, 0x58, 0x22, 0xEF, 0x57, 0x60, 0x6A, 0x0C, 0x68, 0x1B, 0xFB, 0x75, 0x02, 0x08, 0xA0,
  0x96, 0x05, 0xA0, 0x27, 0x30, 0xCB, 0x09, 0x02, 0x68, 0x21, 0xEF, 0x77, 0x48, 0x1A, 0xBE, 0xA0,
  0xA0, 0x15, 0x81, 0x9F, 0xD7, 0x71, 0x09, 0xA0, 0xC4, 0x03, 0xA0, 0x37, 0x72, 0x0E, 0xA0, 0x33,
  0x81, 0xCF, 0x94, 0x82, 0x47, 0x72, 0x72, 0x0B, 0xA0, 0x52, 0x82, 0x7F, 0xE1, 0x30, 0x20, 0xEA,
  0x83, 0x30, 0x5F, 0x35, 0x0B, 0xA8, 0x14, 0x02, 0xA0, 0x53, 0x01, 0x0D, 0xB2, 0x81, 0xDF, 0x64,
  0x01, 0x0E, 0xA2, 0x81, 0xBF, 0xB4, 0x0B, 0x0E, 0xA0, 0xC2, 0x82, 0xDF, 0xD1, 0x20, 0x10, 0xBA,
  0x81, 0x70, 0x5A, 0x02, 0x38, 0x18, 0xF8, 0xA0, 0x92, 0x06, 0xA8, 0x1E, 0xBC, 0xB8, 0x47, 0x01,
  0xEF, 0x73, 0x82, 0x5F, 0x87, 0xA0, 0x63, 0x86, 0x4B, 0xEF, 0xEC, 0x82, 0x28, 0x19, 0xFD, 0x38,
  0x32, 0xEB, 0x0B, 0xA0, 0x27, 0x50, 0x3A, 0x03, 0x38, 0x5D, 0xD1, 0x0E, 0xFE, 0x76, 0x81, 0xDF,
  0x93, 0x83, 0xAF, 0x30, 0x2A, 0x0C, 0x75, 0x82, 0x7F, 0xE1, 0x28, 0x17, 0xF6, 0x20, 0x6A, 0x08,
  0x74, 0x02, 0xA0, 0x52, 0x81, 0x4F, 0x93, 0x09, 0xA0, 0x57, 0x48, 0x1B, 0xFB, 0x28, 0x61, 0xEF,
  0xBA, 0xAA, 0xEA, 0x82, 0xBA, 0xA1, 0x70, 0x6A, 0x02, 0x20, 0x5F, 0xC0, 0xE7, 0x82, 0x1E, 0xF7,
  0x72, 0x03, 0xA0, 0xB7, 0x38, 0x1A, 0xFD, 0x73, 0x07, 0xA0, 0x77, 0x20, 0x4A, 0x03, 0x73, 0x0C,
  0xA0, 0x57, 0x28, 0x1D, 0xF9, 0x71, 0x81, 0x4A, 0xDB, 0x81, 0xEB, 0x16, 0x82, 0x8F, 0xE1, 0x71,
  0x09, 0xF3,
  // "¿" (U+00BF)
  0x73, 0x82, 0x6E, 0xE6, 0x72, 0x04, 0xC7, 0x20, 0x7C, 0x72, 0x07, 0xB0, 0xC7, 0x28, 0x31, 0xBE,
  0xB2, 0x80, 0xD7, 0x08, 0x13, 0xEB, 0x74, 0x81, 0x7F, 0x97, 0x48, 0x1A, 0xF7, 0x74, 0x81, 0xEF,
  0x57, 0x30, 0x5A, 0x03, 0x71, 0x04, 0x0C, 0xB0, 0x16, 0x01, 0x0A, 0xB0, 0x90, 0x26, 0x03, 0x0E,
  0xA0, 0xD0, 0x37, 0x04, 0xB0, 0xB7, 0x10, 0x20, 0xEA, 0x0B, 0x72, 0x0C, 0xA0, 0xE0, 0x17, 0x10,
  0x5B, 0x07, 0x72, 0x0A, 0xB0, 0x17, 0x20, 0xDA, 0x0D, 0x70, 0x90, 0x61, 0xB0, 0xC6, 0x04, 0xA0,
  0x70, 0xEA, 0x0C, 0x60, 0x7A, 0x0B, 0x0C, 0xA0, 0xE6, 0x0D, 0xA0, 0x90, 0x8B, 0x05, 0x40, 0x6B,
  0x81, 0x41, 0xEA, 0x83, 0xE5, 0x01, 0x7B, 0x09, 0x20, 0x30, 0xDF, 0x90, 0x85, 0x86, 0x6B, 0xDE,
  0xDB, 0x72, 0x30,
  // "À" (U+00C0)
  0x76, 0x83, 0x17, 0x77, 0x57, 0x77, 0x0D, 0xA0, 0xD7, 0x77, 0x04, 0xB0, 0x37, 0x77, 0x08, 0xA0,
  0x97, 0x77, 0x18, 0x1C, 0xFE, 0x77, 0x71, 0x82, 0x1E, 0xF5, 0x77, 0x71, 0x81, 0x3F, 0xA8, 0x09,
  0x83, 0x00, 0x4B, 0x01, 0x77, 0x60, 0xCB, 0x03, 0x77, 0x50, 0x4C, 0x05, 0x77, 0x50, 0xCC, 0x06,
  0x77, 0x48, 0x25, 0xF9, 0xEA, 0x08, 0x77, 0x48, 0x2D, 0xF3, 0xEA, 0x09, 0x77, 0x38, 0x36, 0xFB,
  0x0D, 0xA0, 0xB7, 0x73, 0x83, 0xEF, 0x30, 0xCA, 0x0C, 0x77, 0x28, 0x17, 0xFB, 0x20, 0xBA, 0x0E,
  0x77, 0x18, 0x21, 0xEF, 0x32, 0x0A, 0xB7, 0x71, 0x81, 0x8F, 0xA3, 0x09, 0xB0, 0x17, 0x68, 0x21,
  0xEF, 0x23, 0x07, 0xB0, 0x37, 0x68, 0x19, 0xF9, 0x40, 0x6B, 0x04, 0x75, 0x02, 0xA0, 0x24, 0x04,
  0xB0, 0x67, 0x58, 0x19, 0xF9, 0x50, 0x3B, 0x08, 0x74, 0x02, 0xA0, 0x15, 0x02, 0xB0, 0x97, 0x48,
  0x1A, 0xF8, 0x7B, 0x0B, 0x73, 0x03, 0xFE, 0x0C, 0x73, 0x0B, 0xFE, 0x0E, 0x72, 0x82, 0x4F, 0xE1,
  0x71, 0x0C, 0xB7, 0x28, 0x1C, 0xF8, 0x72, 0x0B, 0xB0, 0x17, 0x82, 0x5F, 0xE1, 0x72, 0x09, 0xB0,
  0x37, 0x81, 0xDF, 0x77, 0x30, 0x8B, 0x04, 0x68, 0x15, 0xFE, 0x74, 0x07, 0xB0, 0x66, 0x81, 0xDF,
  0x97, 0x40, 0x6B, 0x08, 0x50, 0x8A, 0x06, 0x74, 0x09, 0xB0, 0xB4, 0x06, 0xB0, 0xB0, 0x17, 0x20,
  0x5D, 0x81, 0x40, 0x9F, 0x0E, 0x60, 0xBF, 0x90, 0xD0, 0xCF, 0x0C, 0x60, 0xEF, 0x90, 0xB0,
  // "Á" (U+00C1)
  0x77, 0x68, 0x34, 0x77, 0x73, 0x77, 0x50, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x50, 0xAA, 0x0E, 0x02,
  0x77, 0x50, 0x4A, 0x0E, 0x02, 0x77, 0x58, 0x31, 0xDF, 0xE2, 0x77, 0x68, 0x2A, 0xFD, 0x27, 0x76,
  0x82, 0x5F, 0xA1, 0x80, 0x98, 0x30, 0x04, 0xB0, 0x17, 0x76, 0x0C, 0xB0, 0x37, 0x75, 0x04, 0xC0,
  0x57, 0x75, 0x0C, 0xC0, 0x67, 0x74, 0x82, 0x5F, 0x9E, 0xA0, 0x87, 0x74, 0x82, 0xDF, 0x3E, 0xA0,
  0x97, 0x73, 0x83, 0x6F, 0xB0, 0xDA, 0x0B, 0x77, 0x38, 0x3E, 0xF3, 0x0C, 0xA0, 0xC7, 0x72, 0x81,
  0x7F, 0xB2, 0x0B, 0xA0, 0xE7, 0x71, 0x82, 0x1E, 0xF3, 0x20, 0xAB, 0x77, 0x18, 0x18, 0xFA, 0x30,
  0x9B, 0x01, 0x76, 0x82, 0x1E, 0xF2, 0x30, 0x7B, 0x03, 0x76, 0x81, 0x9F, 0x94, 0x06, 0xB0, 0x47,
  0x50, 0x2A, 0x02, 0x40, 0x4B, 0x06, 0x75, 0x81, 0x9F, 0x95, 0x03, 0xB0, 0x87, 0x40, 0x2A, 0x01,
  0x50, 0x2B, 0x09, 0x74, 0x81, 0xAF, 0x87, 0xB0, 0xB7, 0x30, 0x3F, 0xE0, 0xC7, 0x30, 0xBF, 0xE0,
  0xE7, 0x28, 0x24, 0xFE, 0x17, 0x10, 0xCB, 0x72, 0x81, 0xCF, 0x87, 0x20, 0xBB, 0x01, 0x78, 0x25,
  0xFE, 0x17, 0x20, 0x9B, 0x03, 0x78, 0x1D, 0xF7, 0x73, 0x08, 0xB0, 0x46, 0x81, 0x5F, 0xE7, 0x40,
  0x7B, 0x06, 0x68, 0x1D, 0xF9, 0x74, 0x06, 0xB0, 0x85, 0x08, 0xA0, 0x67, 0x40, 0x9B, 0x0B, 0x40,
  0x6B, 0x0B, 0x01, 0x72, 0x05, 0xD8, 0x14, 0x09, 0xF0, 0xE6, 0x0B, 0xF9, 0x0D, 0x0C, 0xF0, 0xC6,
  0x0E, 0xF9, 0x0B,
  // "Â" (U+00C2)
  0x77, 0x40, 0x60, 0xF7, 0x77, 0x60, 0x5C, 0x02, 0x77, 0x40, 0x20, 0xEC, 0x06, 0x77, 0x48, 0x5C,
  0xFE, 0x6E, 0xFC, 0x77, 0x38, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x77, 0x18, 0x28, 0xFD, 0x23, 0x81,
  0xBF, 0xA7, 0x78, 0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0F, 0x70, 0x04, 0xB0, 0x17, 0x76, 0x0C,
  0xB0, 0x37, 0x75, 0x04, 0xC0, 0x57, 0x75, 0x0C, 0xC0, 0x67, 0x74, 0x82, 0x5F, 0x9E, 0xA0, 0x87,
  0x74, 0x82, 0xDF, 0x3E, 0xA0, 0x97, 0x73, 0x83, 0x6F, 0xB0, 0xDA, 0x0B, 0x77, 0x38, 0x3E, 0xF3,
  0x0C, 0xA0, 0xC7, 0x72, 0x81, 0x7F, 0xB2, 0x0B, 0xA0, 0xE7, 0x71, 0x82, 0x1E, 0xF3, 0x20, 0xAB,
  0x77, 0x18, 0x18, 0xFA, 0x30, 0x9B, 0x01, 0x76, 0x82, 0x1E, 0xF2, 0x30, 0x7B, 0x03, 0x76, 0x81,
  0x9F, 0x94, 0x06, 0xB0, 0x47, 0x50, 0x2A, 0x02, 0x40, 0x4B, 0x06, 0x75, 0x81, 0x9F, 0x95, 0x03,
  0xB0, 0x87, 0x40, 0x2A, 0x01, 0x50, 0x2B, 0x09, 0x74, 0x81, 0xAF, 0x87, 0xB0, 0xB7, 0x30, 0x3F,
  0xE0, 0xC7, 0x30, 0xBF, 0xE0, 0xE7, 0x28, 0x24, 0xFE, 0x17, 0x10, 0xCB, 0x72, 0x81, 0xCF, 0x87,
  0x20, 0xBB, 0x01, 0x78, 0x25, 0xFE, 0x17, 0x20, 0x9B, 0x03, 0x78, 0x1D, 0xF7, 0x73, 0x08, 0xB0,
  0x46, 0x81, 0x5F, 0xE7, 0x40, 0x7B, 0x06, 0x68, 0x1D, 0xF9, 0x74, 0x06, 0xB0, 0x85, 0x08, 0xA0,
  0x67, 0x40, 0x9B, 0x0B, 0x40, 0x6B, 0x0B, 0x01, 0x72, 0x05, 0xD8, 0x14, 0x09, 0xF0, 0xE6, 0x0B,
  0xF9, 0x0D, 0x0C, 0xF0, 0xC6, 0x0E, 0xF9, 0x0B,
  // "Ã" (U+00C3)
  0x77, 0x83, 0x19, 0xDD, 0x95, 0x09, 0x07, 0x77, 0x0C, 0xC0, 0xC0, 0x12, 0x81, 0x3F, 0x67, 0x68,
  0x38, 0xF4, 0x19, 0xA8, 0x3D, 0x20, 0xBE, 0x77, 0x0E, 0x0A, 0x30, 0x8D, 0x05, 0x76, 0x81, 0x3A,
  0x34, 0x83, 0x5D, 0xFC, 0x58, 0x09, 0x82, 0x00, 0x4B, 0x01, 0x77, 0x70, 0xCB, 0x03, 0x77, 0x60,
  0x4C, 0x05, 0x77, 0x60, 0xCC, 0x06, 0x77, 0x58, 0x25, 0xF9, 0xEA, 0x08, 0x77, 0x58, 0x2D, 0xF3,
  0xEA, 0x09, 0x77, 0x48, 0x36, 0xFB, 0x0D, 0xA0, 0xB7, 0x74, 0x83, 0xEF, 0x30, 0xCA, 0x0C, 0x77,
  0x38, 0x17, 0xFB, 0x20, 0xBA, 0x0E, 0x77, 0x28, 0x21, 0xEF, 0x32, 0x0A, 0xB7, 0x72, 0x81, 0x8F,
  0xA3, 0x09, 0xB0, 0x17, 0x78, 0x21, 0xEF, 0x23, 0x07, 0xB0, 0x37, 0x78, 0x19, 0xF9, 0x40, 0x6B,
  0x04, 0x76, 0x02, 0xA0, 0x24, 0x04, 0xB0, 0x67, 0x68, 0x19, 0xF9, 0x50, 0x3B, 0x08, 0x75, 0x02,
  0xA0, 0x15, 0x02, 0xB0, 0x97, 0x58, 0x1A, 0xF8, 0x7B, 0x0B, 0x74, 0x03, 0xFE, 0x0C, 0x74, 0x0B,
  0xFE, 0x0E, 0x73, 0x82, 0x4F, 0xE1, 0x71, 0x0C, 0xB7, 0x38, 0x1C, 0xF8, 0x72, 0x0B, 0xB0, 0x17,
  0x18, 0x25, 0xFE, 0x17, 0x20, 0x9B, 0x03, 0x71, 0x81, 0xDF, 0x77, 0x30, 0x8B, 0x04, 0x78, 0x15,
  0xFE, 0x74, 0x07, 0xB0, 0x67, 0x81, 0xDF, 0x97, 0x40, 0x6B, 0x08, 0x60, 0x8A, 0x06, 0x74, 0x09,
  0xB0, 0xB5, 0x06, 0xB0, 0xB0, 0x17, 0x20, 0x5D, 0x04, 0x20, 0x9F, 0x0E, 0x60, 0xBF, 0x98, 0x1D,
  0x0C, 0xF0, 0xC6, 0x0E, 0xF9, 0x0B, 0x10,
  // "Ä" (U+00C4)
  0x77, 0x81, 0x8E, 0xB3, 0x82, 0x1C, 0xE6, 0x77, 0x03, 0xB0, 0x22, 0x08, 0xA0, 0xC7, 0x70, 0x4B,
  0x01, 0x20, 0xAA, 0x0B, 0x77, 0x82, 0x1C, 0xE7, 0x38, 0x24, 0xED, 0x38, 0x09, 0xE1, 0x00, 0x4B,
  0x01, 0x77, 0x60, 0xCB, 0x03, 0x77, 0x50, 0x4C, 0x05, 0x77, 0x50, 0xCC, 0x06, 0x77, 0x48, 0x25,
  0xF9, 0xEA, 0x08, 0x77, 0x48, 0x2D, 0xF3, 0xEA, 0x09, 0x77, 0x38, 0x36, 0xFB, 0x0D, 0xA0, 0xB7,
  0x73, 0x83, 0xEF, 0x30, 0xCA, 0x0C, 0x77, 0x28, 0x17, 0xFB, 0x20, 0xBA, 0x0E, 0x77, 0x18, 0x21,
  0xEF, 0x32, 0x0A, 0xB7, 0x71, 0x81, 0x8F, 0xA3, 0x09, 0xB0, 0x17, 0x68, 0x21, 0xEF, 0x23, 0x07,
  0xB0, 0x37, 0x68, 0x19, 0xF9, 0x40, 0x6B, 0x04, 0x75, 0x02, 0xA0, 0x24, 0x04, 0xB0, 0x67, 0x58,
  0x19, 0xF9, 0x50, 0x3B, 0x08, 0x74, 0x02, 0xA0, 0x15, 0x02, 0xB0, 0x97, 0x48, 0x1A, 0xF8, 0x7B,
  0x0B, 0x73, 0x03, 0xFE, 0x0C, 0x73, 0x0B, 0xFE, 0x0E, 0x72, 0x82, 0x4F, 0xE1, 0x71, 0x0C, 0xB7,
  0x28, 0x1C, 0xF8, 0x72, 0x0B, 0xB0, 0x17, 0x82, 0x5F, 0xE1, 0x72, 0x09, 0xB0, 0x37, 0x81, 0xDF,
  0x77, 0x30, 0x8B, 0x04, 0x68, 0x15, 0xFE, 0x74, 0x07, 0xB0, 0x66, 0x81, 0xDF, 0x97, 0x40, 0x6B,
  0x08, 0x50, 0x8A, 0x06, 0x74, 0x09, 0xB0, 0xB4, 0x06, 0xB0, 0xB0, 0x17, 0x20, 0x5D, 0x81, 0x40,
  0x9F, 0x0E, 0x60, 0xBF, 0x90, 0xD0, 0xCF, 0x0C, 0x60, 0xEF, 0x90, 0xB0,
  // "Å" (U+00C5)
  0x77, 0x28, 0x48, 0xDF, 0xD8, 0x17, 0x74, 0x0C, 0xD0, 0xD7, 0x73, 0x87, 0x6F, 0xC2, 0x02, 0xCF,
  0x67, 0x72, 0x81, 0x9F, 0x43, 0x81, 0x5F, 0x87, 0x72, 0x81, 0xAF, 0x43, 0x81, 0x6F, 0x87, 0x72,
  0x87, 0x7F, 0xB1, 0x03, 0xDF, 0x47, 0x72, 0x01, 0x0E, 0xD0, 0xB7, 0x74, 0x01, 0xC0, 0xA7, 0x75,
  0x04, 0xC0, 0x57, 0x75, 0x0C, 0xC0, 0x67, 0x74, 0x82, 0x5F, 0x9E, 0xA0, 0x87, 0x74, 0x82, 0xDF,
  0x3E, 0xA0, 0x97, 0x73, 0x83, 0x6F, 0xB0, 0xDA, 0x0B, 0x77, 0x38, 0x3E, 0xF3, 0x0C, 0xA0, 0xC7,
  0x72, 0x81, 0x7F, 0xB2, 0x0B, 0xA0, 0xE7, 0x71, 0x82, 0x1E, 0xF3, 0x20, 0xAB, 0x77, 0x18, 0x18,
  0xFA, 0x30, 0x9B, 0x01, 0x76, 0x82, 0x1E, 0xF2, 0x30, 0x7B, 0x03, 0x76, 0x81, 0x9F, 0x94, 0x06,
  0xB0, 0x47, 0x50, 0x2A, 0x02, 0x40, 0x4B, 0x06, 0x75, 0x81, 0x9F, 0x95, 0x03, 0xB0, 0x87, 0x40,
  0x2A, 0x01, 0x50, 0x2B, 0x09, 0x74, 0x81, 0xAF, 0x87, 0xB0, 0xB7, 0x30, 0x3F, 0xE0, 0xC7, 0x30,
  0xBF, 0xE0, 0xE7, 0x28, 0x24, 0xFE, 0x17, 0x10, 0xCB, 0x72, 0x81, 0xCF, 0x87, 0x20, 0xBB, 0x01,
  0x78, 0x25, 0xFE, 0x17, 0x20, 0x9B, 0x03, 0x78, 0x1D, 0xF7, 0x73, 0x08, 0xB0, 0x46, 0x81, 0x5F,
  0xE7, 0x40, 0x7B, 0x06, 0x68, 0x1D, 0xF9, 0x74, 0x06, 0xB0, 0x85, 0x08, 0xA0, 0x67, 0x40, 0x9B,
  0x0B, 0x40, 0x6B, 0x0B, 0x01, 0x72, 0x05, 0xD8, 0x14, 0x09, 0xF0, 0xE6, 0x0B, 0xF9, 0x0D, 0x0C,
  0xF0, 0xC6, 0x0E, 0xF9, 0x0B,
  // "Æ" (U+00C6)
  0x77, 0x20, 0x8F, 0xFD, 0x02, 0x77, 0x28, 0x17, 0xBC, 0xF8, 0x01, 0xEC, 0x0E, 0x77, 0x58, 0x25,
  0xF8, 0x9B, 0x03, 0x60, 0x8A, 0x0C, 0x77, 0x48, 0x31, 0xEE, 0x1C, 0xB7, 0x18, 0x1E, 0xF9, 0x77,
  0x48, 0x1A, 0xF6, 0x1B, 0x0C, 0x71, 0x81, 0xBF, 0x67, 0x73, 0x83, 0x4F, 0xC0, 0x3B, 0x09, 0x71,
  0x81, 0xCF, 0x37, 0x72, 0x84, 0x1D, 0xF3, 0x06, 0xB0, 0x67, 0x18, 0x1D, 0xF1, 0x77, 0x28, 0x19,
  0xF8, 0x20, 0xAB, 0x03, 0x71, 0x00, 0x27, 0x72, 0x81, 0x4F, 0xD3, 0x0D, 0xB7, 0x77, 0x68, 0x1D,
  0xF4, 0x20, 0x1B, 0x0C, 0x77, 0x75, 0x81, 0x8F, 0xA3, 0x04, 0xB0, 0x97, 0x77, 0x48, 0x23, 0xFE,
  0x13, 0x07, 0xB0, 0x57, 0x77, 0x48, 0x1D, 0xF6, 0x40, 0xAB, 0x02, 0x77, 0x73, 0x81, 0x8F, 0xB5,
  0x0D, 0xFC, 0x03, 0x77, 0x10, 0x2A, 0x02, 0x40, 0x1C, 0x80, 0x4E, 0x77, 0x28, 0x1C, 0xF7, 0x50,
  0x4B, 0x08, 0x77, 0x72, 0x81, 0x7F, 0xC6, 0x08, 0xB0, 0x57, 0x77, 0x10, 0x2B, 0x80, 0x2E, 0xC0,
  0x27, 0x77, 0x10, 0xBF, 0xD0, 0xE7, 0x77, 0x18, 0x16, 0xFC, 0x70, 0x2B, 0x0B, 0x77, 0x78, 0x21,
  0xEF, 0x37, 0x06, 0xB0, 0x87, 0x77, 0x81, 0xBF, 0x97, 0x10, 0x9B, 0x04, 0x72, 0x00, 0x37, 0x28,
  0x25, 0xFE, 0x17, 0x10, 0xCB, 0x01, 0x71, 0x81, 0x1F, 0xD7, 0x18, 0x21, 0xEF, 0x67, 0x2B, 0x0D,
  0x72, 0x81, 0x6F, 0x97, 0x18, 0x1A, 0xFD, 0x72, 0x03, 0xB0, 0xA7, 0x28, 0x1C, 0xF6, 0x70, 0x6A,
  0x08, 0x72, 0x08, 0xB0, 0x77, 0x10, 0x7A, 0x02, 0x60, 0x5B, 0x0B, 0x70, 0x10, 0x6C, 0x04, 0x60,
  0x10, 0x7A, 0x0E, 0x50, 0x8F, 0x0D, 0x30, 0x1F, 0x80, 0x3E, 0xC0, 0xA5, 0x0C, 0xF0, 0xB3, 0x04,
  0xFF, 0xC0, 0x65,
  // "Ç" (U+00C7)
  0x73, 0x82, 0x27, 0xBD, 0xA8, 0x1E, 0xB7, 0x74, 0x02, 0x0A, 0xFA, 0x0E, 0x03, 0x71, 0x06, 0x0E,
  0xA0, 0xC0, 0x42, 0x02, 0x0B, 0xB0, 0xD7, 0x08, 0xB0, 0x75, 0x01, 0x0E, 0xB0, 0x45, 0x08, 0xB0,
  0x67, 0x0A, 0xB0, 0x54, 0x06, 0xB0, 0x97, 0x10, 0x7B, 0x02, 0x30, 0x2B, 0x0D, 0x72, 0x06, 0xA0,
  0x74, 0x0B, 0xB0, 0x47, 0x28, 0x12, 0x62, 0x40, 0x5B, 0x0C, 0x77, 0x30, 0xCB, 0x05, 0x77, 0x20,
  0x3B, 0x0E, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x30, 0xEB, 0x04, 0x77, 0x20, 0x3C, 0x77, 0x30, 0x6B,
  0x0C, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x30, 0xBB, 0x07, 0x77, 0x30, 0xCB, 0x05, 0x77, 0x30, 0xDB,
  0x04, 0x77, 0x30, 0xDB, 0x03, 0x77, 0x30, 0xBB, 0x03, 0x77, 0x30, 0xAB, 0x04, 0x77, 0x30, 0x6B,
  0x07, 0x77, 0x30, 0x2B, 0x0C, 0x74, 0x04, 0x60, 0xAB, 0x03, 0x72, 0x05, 0x0E, 0x60, 0x10, 0xEA,
  0x0D, 0x01, 0x78, 0x17, 0xFA, 0x70, 0x40, 0xEA, 0x81, 0xE7, 0x22, 0x84, 0x14, 0xBF, 0xE2, 0x71,
  0x02, 0x0C, 0xFA, 0x0C, 0x03, 0x74, 0x87, 0x49, 0xCE, 0xFE, 0xD9, 0x57, 0x72, 0x0B, 0x0E, 0x77,
  0x58, 0x12, 0xF9, 0x77, 0x50, 0x9A, 0x09, 0x77, 0x40, 0x40, 0xBA, 0x09, 0x77, 0x50, 0xEA, 0x77,
  0x50, 0xBA, 0x01, 0x77, 0x48, 0x1E, 0xFE, 0x77, 0x83, 0x32, 0x13, 0xBA, 0x09, 0x77, 0x0D, 0xD0,
  0xC0, 0x17, 0x78, 0x4B, 0xEF, 0xEB, 0x67, 0x50,
  // "È" (U+00C8)
  0x74, 0x83, 0x17, 0x77, 0x57, 0x76, 0x0D, 0xA0, 0xD7, 0x76, 0x04, 0xB0, 0x37, 0x76, 0x08, 0xA0,
  0x97, 0x77, 0x81, 0xCF, 0xE7, 0x77, 0x82, 0x1E, 0xF5, 0x77, 0x78, 0x13, 0xFA, 0x80, 0xF0, 0x00,
  0xCF, 0xFA, 0x0C, 0x60, 0x90, 0xCD, 0x80, 0x1E, 0xD0, 0x97, 0x10, 0x7B, 0x0D, 0x60, 0x20, 0xCA,
  0x06, 0x71, 0x04, 0xB0, 0x97, 0x04, 0xA0, 0x37, 0x10, 0x5B, 0x06, 0x70, 0x1A, 0x72, 0x09, 0xB0,
  0x37, 0x81, 0x2F, 0xD7, 0x20, 0xCB, 0x71, 0x81, 0x4F, 0xA7, 0x2B, 0x0C, 0x72, 0x02, 0x01, 0x71,
  0x03, 0xB0, 0x97, 0x75, 0x06, 0xB0, 0x67, 0x75, 0x09, 0xB0, 0x37, 0x75, 0x0D, 0xB7, 0x76, 0xB0,
  0xC7, 0x75, 0x03, 0xFC, 0x0C, 0x74, 0x07, 0xC8, 0x03, 0xE0, 0x97, 0x40, 0xAB, 0x02, 0x77, 0x50,
  0xDA, 0x0E, 0x77, 0x50, 0x1B, 0x0B, 0x77, 0x50, 0x4B, 0x08, 0x77, 0x50, 0x7B, 0x04, 0x77, 0x50,
  0xBB, 0x01, 0x77, 0x50, 0xEA, 0x0D, 0x77, 0x50, 0x1B, 0x0A, 0x72, 0x81, 0x6F, 0x77, 0x05, 0xB0,
  0x77, 0x28, 0x1B, 0xF4, 0x70, 0x8B, 0x04, 0x71, 0x02, 0xA7, 0x10, 0xCB, 0x72, 0x81, 0xCF, 0xC7,
  0x07, 0xB0, 0xC7, 0x03, 0x0B, 0xA0, 0x84, 0x81, 0x4A, 0xDD, 0x80, 0x2E, 0xD0, 0x44, 0x09, 0xFF,
  0xC0, 0x14,
  // "É" (U+00C9)
  0x77, 0x48, 0x34, 0x77, 0x73, 0x77, 0x40, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x40, 0xAA, 0x0E, 0x02,
  0x77, 0x40, 0x4A, 0x0E, 0x02, 0x77, 0x48, 0x31, 0xDF, 0xE2, 0x77, 0x58, 0x2A, 0xFD, 0x27, 0x75,
  0x82, 0x5F, 0xA1, 0x80, 0xF0, 0x00, 0xCF, 0xFA, 0x0C, 0x60, 0x90, 0xCD, 0x80, 0x1E, 0xD0, 0x97,
  0x10, 0x7B, 0x0D, 0x60, 0x20, 0xCA, 0x06, 0x71, 0x04, 0xB0, 0x97, 0x04, 0xA0, 0x37, 0x10, 0x5B,
  0x06, 0x70, 0x1A, 0x72, 0x09, 0xB0, 0x37, 0x81, 0x2F, 0xD7, 0x20, 0xCB, 0x71, 0x81, 0x4F, 0xA7,
  0x2B, 0x0C, 0x72, 0x02, 0x01, 0x71, 0x03, 0xB0, 0x97, 0x75, 0x06, 0xB0, 0x67, 0x75, 0x09, 0xB0,
  0x37, 0x75, 0x0D, 0xB7, 0x76, 0xB0, 0xC7, 0x75, 0x03, 0xFC, 0x0C, 0x74, 0x07, 0xC8, 0x03, 0xE0,
  0x97, 0x40, 0xAB, 0x02, 0x77, 0x50, 0xDA, 0x0E, 0x77, 0x50, 0x1B, 0x0B, 0x77, 0x50, 0x4B, 0x08,
  0x77, 0x50, 0x7B, 0x04, 0x77, 0x50, 0xBB, 0x01, 0x77, 0x50, 0xEA, 0x0D, 0x77, 0x50, 0x1B, 0x0A,
  0x72, 0x81, 0x6F, 0x77, 0x05, 0xB0, 0x77, 0x28, 0x1B, 0xF4, 0x70, 0x8B, 0x04, 0x71, 0x02, 0xA7,
  0x10, 0xCB, 0x72, 0x81, 0xCF, 0xC7, 0x07, 0xB0, 0xC7, 0x03, 0x0B, 0xA0, 0x84, 0x81, 0x4A, 0xDD,
  0x80, 0x2E, 0xD0, 0x44, 0x09, 0xFF, 0xC0, 0x14,
  // "Ê" (U+00CA)
  0x77, 0x10, 0x60, 0xF7, 0x77, 0x50, 0x5C, 0x02, 0x77, 0x30, 0x20, 0xEC, 0x06, 0x77, 0x38, 0x5C,
  0xFE, 0x6E, 0xFC, 0x77, 0x28, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x77, 0x82, 0x8F, 0xD2, 0x38, 0x1B,
  0xFA, 0x76, 0x82, 0x5F, 0xA1, 0x40, 0x10, 0xC9, 0x80, 0xE5, 0x00, 0xCF, 0xFA, 0x0C, 0x60, 0x90,
  0xCD, 0x80, 0x1E, 0xD0, 0x97, 0x10, 0x7B, 0x0D, 0x60, 0x20, 0xCA, 0x06, 0x71, 0x04, 0xB0, 0x97,
  0x04, 0xA0, 0x37, 0x10, 0x5B, 0x06, 0x70, 0x1A, 0x72, 0x09, 0xB0, 0x37, 0x81, 0x2F, 0xD7, 0x20,
  0xCB, 0x71, 0x81, 0x4F, 0xA7, 0x2B, 0x0C, 0x72, 0x02, 0x01, 0x71, 0x03, 0xB0, 0x97, 0x75, 0x06,
  0xB0, 0x67, 0x75, 0x09, 0xB0, 0x37, 0x75, 0x0D, 0xB7, 0x76, 0xB0, 0xC7, 0x75, 0x03, 0xFC, 0x0C,
  0x74, 0x07, 0xC8, 0x03, 0xE0, 0x97, 0x40, 0xAB, 0x02, 0x77, 0x50, 0xDA, 0x0E, 0x77, 0x50, 0x1B,
  0x0B, 0x77, 0x50, 0x4B, 0x08, 0x77, 0x50, 0x7B, 0x04, 0x77, 0x50, 0xBB, 0x01, 0x77, 0x50, 0xEA,
  0x0D, 0x77, 0x50, 0x1B, 0x0A, 0x72, 0x81, 0x6F, 0x77, 0x05, 0xB0, 0x77, 0x28, 0x1B, 0xF4, 0x70,
  0x8B, 0x04, 0x71, 0x02, 0xA7, 0x10, 0xCB, 0x72, 0x81, 0xCF, 0xC7, 0x07, 0xB0, 0xC7, 0x03, 0x0B,
  0xA0, 0x84, 0x81, 0x4A, 0xDD, 0x80, 0x2E, 0xD0, 0x44, 0x09, 0xFF, 0xC0, 0x14,
  // "Ë" (U+00CB)
  0x74, 0x81, 0x8E, 0xB3, 0x82, 0x1C, 0xE6, 0x76, 0x03, 0xB0, 0x22, 0x08, 0xA0, 0xC7, 0x60, 0x4B,
  0x01, 0x20, 0xAA, 0x0B, 0x76, 0x82, 0x1C, 0xE7, 0x38, 0x24, 0xED, 0x38, 0x09, 0xC5, 0x00, 0xCF,
  0xFA, 0x0C, 0x60, 0x90, 0xCD, 0x80, 0x1E, 0xD0, 0x97, 0x10, 0x7B, 0x0D, 0x60, 0x20, 0xCA, 0x06,
  0x71, 0x04, 0xB0, 0x97, 0x04, 0xA0, 0x37, 0x10, 0x5B, 0x06, 0x70, 0x1A, 0x72, 0x09, 0xB0, 0x37,
  0x81, 0x2F, 0xD7, 0x20, 0xCB, 0x71, 0x81, 0x4F, 0xA7, 0x2B, 0x0C, 0x72, 0x02, 0x01, 0x71, 0x03,
  0xB0, 0x97, 0x75, 0x06, 0xB0, 0x67, 0x75, 0x09, 0xB0, 0x37, 0x75, 0x0D, 0xB7, 0x76, 0xB0, 0xC7,
  0x75, 0x03, 0xFC, 0x0C, 0x74, 0x07, 0xC8, 0x03, 0xE0, 0x97, 0x40, 0xAB, 0x02, 0x77, 0x50, 0xDA,
  0x0E, 0x77, 0x50, 0x1B, 0x0B, 0x77, 0x50, 0x4B, 0x08, 0x77, 0x50, 0x7B, 0x04, 0x77, 0x50, 0xBB,
  0x01, 0x77, 0x50, 0xEA, 0x0D, 0x77, 0x50, 0x1B, 0x0A, 0x72, 0x81, 0x6F, 0x77, 0x05, 0xB0, 0x77,
  0x28, 0x1B, 0xF4, 0x70, 0x8B, 0x04, 0x71, 0x02, 0xA7, 0x10, 0xCB, 0x72, 0x81, 0xCF, 0xC7, 0x07,
  0xB0, 0xC7, 0x03, 0x0B, 0xA0, 0x84, 0x81, 0x4A, 0xDD, 0x80, 0x2E, 0xD0, 0x44, 0x09, 0xFF, 0xC0,
  0x14,
  // "Ì" (U+00CC)
  0x78, 0x31, 0x77, 0x75, 0x76, 0x0D, 0xA0, 0xD7, 0x60, 0x4B, 0x03, 0x76, 0x08, 0xA0, 0x97, 0x78,
  0x1C, 0xFE, 0x77, 0x82, 0x1E, 0xF5, 0x77, 0x81, 0x3F, 0xA8, 0x0C, 0x70, 0x0C, 0xFA, 0x08, 0x60,
  0xEF, 0xA0, 0x57, 0x01, 0x09, 0xC0, 0xA0, 0x27, 0x30, 0x3B, 0x0D, 0x75, 0x04, 0xB0, 0x87, 0x50,
  0x8B, 0x04, 0x75, 0x0B, 0xB0, 0x17, 0x50, 0xEA, 0x0D, 0x75, 0x02, 0xB0, 0xA7, 0x50, 0x5B, 0x06,
  0x75, 0x09, 0xB0, 0x37, 0x50, 0xCB, 0x76, 0xB0, 0xC7, 0x50, 0x3B, 0x09, 0x75, 0x06, 0xB0, 0x57,
  0x50, 0xAB, 0x02, 0x75, 0x0D, 0xA0, 0xE7, 0x50, 0x1B, 0x0B, 0x75, 0x04, 0xB0, 0x77, 0x50, 0x7B,
  0x04, 0x75, 0x0B, 0xB0, 0x17, 0x50, 0xEA, 0x0D, 0x75, 0x02, 0xB0, 0xA7, 0x50, 0x5B, 0x06, 0x75,
  0x09, 0xB0, 0x37, 0x50, 0xEB, 0x01, 0x73, 0x03, 0x0B, 0xC0, 0x87, 0x10, 0x6F, 0xA0, 0xC6, 0x09,
  0xFA, 0x0A, 0x60,
  // "Í" (U+00CD)
  0x76, 0x83, 0x47, 0x77, 0x37, 0x50, 0x10, 0xEA, 0x0D, 0x01, 0x75, 0x0A, 0xA0, 0xE0, 0x27, 0x50,
  0x4A, 0x0E, 0x02, 0x75, 0x83, 0x1D, 0xFE, 0x27, 0x68, 0x2A, 0xFD, 0x27, 0x68, 0x25, 0xFA, 0x18,
  0x0D, 0x30, 0x0C, 0xFA, 0x08, 0x70, 0xEF, 0xA0, 0x57, 0x10, 0x10, 0x9C, 0x0A, 0x02, 0x74, 0x03,
  0xB0, 0xD7, 0x60, 0x4B, 0x08, 0x76, 0x08, 0xB0, 0x47, 0x60, 0xBB, 0x01, 0x76, 0x0E, 0xA0, 0xD7,
  0x60, 0x2B, 0x0A, 0x76, 0x05, 0xB0, 0x67, 0x60, 0x9B, 0x03, 0x76, 0x0C, 0xB7, 0x7B, 0x0C, 0x76,
  0x03, 0xB0, 0x97, 0x60, 0x6B, 0x05, 0x76, 0x0A, 0xB0, 0x27, 0x60, 0xDA, 0x0E, 0x76, 0x01, 0xB0,
  0xB7, 0x60, 0x4B, 0x07, 0x76, 0x07, 0xB0, 0x47, 0x60, 0xBB, 0x01, 0x76, 0x0E, 0xA0, 0xD7, 0x60,
  0x2B, 0x0A, 0x76, 0x05, 0xB0, 0x67, 0x60, 0x9B, 0x03, 0x76, 0x0E, 0xB0, 0x17, 0x40, 0x30, 0xBC,
  0x08, 0x72, 0x06, 0xFA, 0x0C, 0x70, 0x9F, 0xA0, 0xA7,
  // "Î" (U+00CE)
  0x74, 0x06, 0x0F, 0x77, 0x50, 0x5C, 0x02, 0x73, 0x02, 0x0E, 0xC0, 0x67, 0x38, 0x5C, 0xFE, 0x6E,
  0xFC, 0x72, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x82, 0x8F, 0xD2, 0x38, 0x1B, 0xFA, 0x68, 0x25,
  0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0C, 0x40, 0x0C, 0xFA, 0x08, 0x60, 0xEF, 0xA0, 0x57, 0x01, 0x09,
  0xC0, 0xA0, 0x27, 0x30, 0x3B, 0x0D, 0x75, 0x04, 0xB0, 0x87, 0x50, 0x8B, 0x04, 0x75, 0x0B, 0xB0,
  0x17, 0x50, 0xEA, 0x0D, 0x75, 0x02, 0xB0, 0xA7, 0x50, 0x5B, 0x06, 0x75, 0x09, 0xB0, 0x37, 0x50,
  0xCB, 0x76, 0xB0, 0xC7, 0x50, 0x3B, 0x09, 0x75, 0x06, 0xB0, 0x57, 0x50, 0xAB, 0x02, 0x75, 0x0D,
  0xA0, 0xE7, 0x50, 0x1B, 0x0B, 0x75, 0x04, 0xB0, 0x77, 0x50, 0x7B, 0x04, 0x75, 0x0B, 0xB0, 0x17,
  0x50, 0xEA, 0x0D, 0x75, 0x02, 0xB0, 0xA7, 0x50, 0x5B, 0x06, 0x75, 0x09, 0xB0, 0x37, 0x50, 0xEB,
  0x01, 0x73, 0x03, 0x0B, 0xC0, 0x87, 0x10, 0x6F, 0xA0, 0xC6, 0x09, 0xFA, 0x0A, 0x60,
  // "Ï" (U+00CF)
  0x71, 0x81, 0x8E, 0xB3, 0x82, 0x1C, 0xE6, 0x70, 0x3B, 0x02, 0x20, 0x8A, 0x0C, 0x70, 0x4B, 0x01,
  0x20, 0xAA, 0x0B, 0x78, 0x21, 0xCE, 0x73, 0x82, 0x4E, 0xD3, 0x80, 0x99, 0x20, 0x0C, 0xFA, 0x08,
  0x70, 0xEF, 0xA0, 0x57, 0x10, 0x10, 0x9C, 0x0A, 0x02, 0x74, 0x03, 0xB0, 0xD7, 0x60, 0x4B, 0x08,
  0x76, 0x08, 0xB0, 0x47, 0x60, 0xBB, 0x01, 0x76, 0x0E, 0xA0, 0xD7, 0x60, 0x2B, 0x0A, 0x76, 0x05,
  0xB0, 0x67, 0x60, 0x9B, 0x03, 0x76, 0x0C, 0xB7, 0x7B, 0x0C, 0x76, 0x03, 0xB0, 0x97, 0x60, 0x6B,
  0x05, 0x76, 0x0A, 0xB0, 0x27, 0x60, 0xDA, 0x0E, 0x76, 0x01, 0xB0, 0xB7, 0x60, 0x4B, 0x07, 0x76,
  0x07, 0xB0, 0x47, 0x60, 0xBB, 0x01, 0x76, 0x0E, 0xA0, 0xD7, 0x60, 0x2B, 0x0A, 0x76, 0x05, 0xB0,
  0x67, 0x60, 0x9B, 0x03, 0x76, 0x0E, 0xB0, 0x17, 0x40, 0x30, 0xBC, 0x08, 0x72, 0x06, 0xFA, 0x0C,
  0x70, 0x9F, 0xA0, 0xA7,
  // "Ð" (U+00D0)
  0x60, 0xCF, 0xB8, 0x2D, 0xC8, 0x27, 0x40, 0x90, 0xCD, 0x00, 0xEE, 0x0A, 0x01, 0x74, 0x05, 0xB0,
  0xD4, 0x04, 0x0B, 0xB0, 0xD0, 0x27, 0x30, 0x3B, 0x09, 0x60, 0x7B, 0x0C, 0x73, 0x05, 0xB0, 0x67,
  0x0A, 0xB0, 0x77, 0x20, 0x9B, 0x03, 0x70, 0x2B, 0x0D, 0x72, 0x0C, 0xB7, 0x20, 0xCB, 0x03, 0x71,
  0xB0, 0xC7, 0x20, 0x9B, 0x07, 0x70, 0x3B, 0x09, 0x72, 0x06, 0xB0, 0x97, 0x06, 0xB0, 0x67, 0x20,
  0x6B, 0x0A, 0x70, 0x9B, 0x03, 0x72, 0x05, 0xB0, 0xB7, 0x0C, 0xB7, 0x30, 0x6B, 0x0A, 0x7B, 0x0C,
  0x73, 0x07, 0xB0, 0x93, 0x06, 0xFD, 0x04, 0x40, 0x8B, 0x08, 0x38, 0x19, 0xEE, 0xD8, 0x01, 0xE0,
  0x14, 0x0A, 0xB0, 0x66, 0x09, 0xB0, 0x27, 0x30, 0xDB, 0x03, 0x60, 0xDA, 0x0E, 0x73, 0x01, 0xC7,
  0xB0, 0xB7, 0x30, 0x5B, 0x0C, 0x60, 0x3B, 0x08, 0x73, 0x09, 0xB0, 0x66, 0x07, 0xB0, 0x47, 0x30,
  0xEB, 0x01, 0x60, 0xAB, 0x01, 0x72, 0x06, 0xB0, 0xA7, 0x0D, 0xA0, 0xD7, 0x30, 0xEB, 0x02, 0x60,
  0x1B, 0x0A, 0x72, 0x08, 0xB0, 0x87, 0x04, 0xB0, 0x77, 0x10, 0x4B, 0x0D, 0x71, 0x07, 0xB0, 0x47,
  0x04, 0xB0, 0xE0, 0x27, 0x10, 0xCB, 0x70, 0x7B, 0x0E, 0x03, 0x71, 0x06, 0xB0, 0xC4, 0x81, 0x27,
  0xDB, 0x0C, 0x02, 0x68, 0x14, 0x9D, 0xD0, 0xFE, 0xD0, 0xE0, 0x77, 0x10, 0x9F, 0xC8, 0x2E, 0xC9,
  0x57, 0x30,
  // "Ñ" (U+00D1)
  0x77, 0x83, 0x19, 0xDD, 0x95, 0x09, 0x07, 0x77, 0x50, 0xCC, 0x0C, 0x01, 0x28, 0x13, 0xF6, 0x77,
  0x48, 0x38, 0xF4, 0x19, 0xA8, 0x3D, 0x20, 0xBE, 0x77, 0x50, 0xE0, 0xA3, 0x08, 0xD0, 0x57, 0x74,
  0x81, 0x3A, 0x34, 0x83, 0x5D, 0xFC, 0x58, 0x09, 0x87, 0x00, 0xCD, 0x0E, 0x71, 0x02, 0xF9, 0x07,
  0x60, 0xEE, 0x04, 0x70, 0x5F, 0x90, 0x47, 0x01, 0x09, 0xC0, 0x97, 0x20, 0x30, 0xDA, 0x09, 0x02,
  0x73, 0x03, 0xC0, 0xE7, 0x38, 0x19, 0xFC, 0x75, 0x04, 0xD0, 0x47, 0x28, 0x1B, 0xF7, 0x75, 0x81,
  0x7F, 0xBB, 0x0A, 0x72, 0x81, 0xEF, 0x37, 0x58, 0x2B, 0xF5, 0xCA, 0x0E, 0x71, 0x02, 0xA7, 0x68,
  0x2E, 0xF2, 0x7B, 0x04, 0x78, 0x16, 0xFC, 0x75, 0x83, 0x2F, 0xE0, 0x1B, 0x0A, 0x78, 0x19, 0xF9,
  0x75, 0x81, 0x5F, 0xB2, 0x0C, 0xA0, 0xE7, 0x81, 0xCF, 0x67, 0x58, 0x18, 0xF8, 0x20, 0x6B, 0x05,
  0x6A, 0x02, 0x75, 0x81, 0xCF, 0x42, 0x01, 0xB0, 0xA5, 0x81, 0x3F, 0xE7, 0x6A, 0x01, 0x30, 0xBA,
  0x0E, 0x58, 0x16, 0xFB, 0x75, 0x81, 0x3F, 0xD4, 0x06, 0xB0, 0x54, 0x81, 0x9F, 0x87, 0x58, 0x16,
  0xFA, 0x40, 0x1B, 0x0A, 0x48, 0x1D, 0xF5, 0x75, 0x81, 0x9F, 0x75, 0x0B, 0xA0, 0xE3, 0x01, 0xA0,
  0x17, 0x58, 0x1D, 0xF4, 0x50, 0x6B, 0x05, 0x28, 0x14, 0xFE, 0x75, 0x01, 0xA6, 0x01, 0xB0, 0xA2,
  0x81, 0x7F, 0xA7, 0x58, 0x14, 0xFD, 0x70, 0xBB, 0x28, 0x1A, 0xF7, 0x75, 0x81, 0x7F, 0x97, 0x05,
  0xB8, 0x35, 0x0D, 0xF4, 0x75, 0x81, 0xBF, 0x67, 0x1B, 0x0A, 0x01, 0xA0, 0x17, 0x58, 0x1E, 0xF3,
  0x71, 0x0A, 0xB8, 0x15, 0xFD, 0x75, 0x02, 0xA7, 0x20, 0x5B, 0x81, 0xDF, 0xA7, 0x58, 0x15, 0xFC,
  0x73, 0x0E, 0xC0, 0x67, 0x58, 0x19, 0xF9, 0x73, 0x0A, 0xC0, 0x37, 0x58, 0x1E, 0xF8, 0x73, 0x05,
  0xC7, 0x40, 0x30, 0xBA, 0x0C, 0x02, 0x73, 0x0E, 0xA0, 0xC7, 0x20, 0x6F, 0x90, 0x27, 0x10, 0x9A,
  0x09, 0x72, 0x09, 0xF0, 0xE7, 0x20, 0x4A, 0x05, 0x72,
  // "Ò" (U+00D2)
  0x74, 0x83, 0x17, 0x77, 0x57, 0x76, 0x0D, 0xA0, 0xD7, 0x76, 0x04, 0xB0, 0x37, 0x76, 0x08, 0xA0,
  0x97, 0x77, 0x81, 0xCF, 0xE7, 0x77, 0x82, 0x1E, 0xF5, 0x77, 0x78, 0x13, 0xFA, 0x80, 0xF4, 0x08,
  0x73, 0x8C, 0xEF, 0xEC, 0x82, 0x76, 0x03, 0x0C, 0xFA, 0x08, 0x74, 0x08, 0xB0, 0x90, 0x32, 0x02,
  0x08, 0xB0, 0xB7, 0x20, 0xAA, 0x0E, 0x04, 0x60, 0x5B, 0x08, 0x70, 0xAB, 0x03, 0x71, 0x0A, 0xB0,
  0x25, 0x06, 0xB0, 0x67, 0x20, 0x3B, 0x09, 0x40, 0x3B, 0x0B, 0x74, 0xB0, 0xD4, 0x0B, 0xB0, 0x37,
  0x40, 0xCB, 0x01, 0x20, 0x5B, 0x0A, 0x75, 0x0B, 0xB0, 0x42, 0x0C, 0xB0, 0x47, 0x50, 0xBB, 0x81,
  0x50, 0x3B, 0x0D, 0x76, 0x0C, 0xB8, 0x15, 0x09, 0xB0, 0x87, 0x60, 0xDB, 0x81, 0x40, 0xEB, 0x04,
  0x76, 0xC0, 0x03, 0xC7, 0x60, 0x2C, 0x10, 0x6B, 0x0C, 0x76, 0x05, 0xB8, 0x1D, 0x09, 0xB0, 0x97,
  0x60, 0x8B, 0x81, 0xA0, 0xBB, 0x07, 0x76, 0x0C, 0xB8, 0x15, 0x0C, 0xB0, 0x57, 0x50, 0x1C, 0x81,
  0x10, 0xDB, 0x04, 0x75, 0x06, 0xB0, 0xA2, 0x0D, 0xB0, 0x37, 0x50, 0xCB, 0x03, 0x20, 0xBB, 0x03,
  0x74, 0x02, 0xB0, 0xC3, 0x09, 0xB0, 0x47, 0x40, 0xAB, 0x03, 0x30, 0x5B, 0x07, 0x73, 0x03, 0xB0,
  0x94, 0x01, 0xB0, 0xB7, 0x30, 0xDA, 0x0D, 0x60, 0x9B, 0x02, 0x71, 0x0A, 0xA0, 0xE0, 0x26, 0x01,
  0x0E, 0xA0, 0xC7, 0x0B, 0xA0, 0xE0, 0x37, 0x10, 0x30, 0xEA, 0x0D, 0x05, 0x28, 0x11, 0x6D, 0xA0,
  0xC0, 0x27, 0x30, 0x20, 0xCF, 0xA0, 0x77, 0x78, 0x15, 0xAD, 0xA8, 0x2D, 0xB6, 0x17, 0x30,
  // "Ó" (U+00D3)
  0x77, 0x28, 0x34, 0x77, 0x73, 0x77, 0x40, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x40, 0xAA, 0x0E, 0x02,
  0x77, 0x40, 0x4A, 0x0E, 0x02, 0x77, 0x48, 0x31, 0xDF, 0xE2, 0x77, 0x58, 0x2A, 0xFD, 0x27, 0x75,
  0x82, 0x5F, 0xA1, 0x80, 0xF6, 0x08, 0x73, 0x8C, 0xEF, 0xEC, 0x82, 0x76, 0x03, 0x0C, 0xFA, 0x08,
  0x74, 0x08, 0xB0, 0x90, 0x32, 0x02, 0x08, 0xB0, 0xB7, 0x20, 0xAA, 0x0E, 0x04, 0x60, 0x5B, 0x08,
  0x70, 0xAB, 0x03, 0x71, 0x0A, 0xB0, 0x25, 0x06, 0xB0, 0x67, 0x20, 0x3B, 0x09, 0x40, 0x3B, 0x0B,
  0x74, 0xB0, 0xD4, 0x0B, 0xB0, 0x37, 0x40, 0xCB, 0x01, 0x20, 0x5B, 0x0A, 0x75, 0x0B, 0xB0, 0x42,
  0x0C, 0xB0, 0x47, 0x50, 0xBB, 0x81, 0x50, 0x3B, 0x0D, 0x76, 0x0C, 0xB8, 0x15, 0x09, 0xB0, 0x87,
  0x60, 0xDB, 0x81, 0x40, 0xEB, 0x04, 0x76, 0xC0, 0x03, 0xC7, 0x60, 0x2C, 0x10, 0x6B, 0x0C, 0x76,
  0x05, 0xB8, 0x1D, 0x09, 0xB0, 0x97, 0x60, 0x8B, 0x81, 0xA0, 0xBB, 0x07, 0x76, 0x0C, 0xB8, 0x15,
  0x0C, 0xB0, 0x57, 0x50, 0x1C, 0x81, 0x10, 0xDB, 0x04, 0x75, 0x06, 0xB0, 0xA2, 0x0D, 0xB0, 0x37,
  0x50, 0xCB, 0x03, 0x20, 0xBB, 0x03, 0x74, 0x02, 0xB0, 0xC3, 0x09, 0xB0, 0x47, 0x40, 0xAB, 0x03,
  0x30, 0x5B, 0x07, 0x73, 0x03, 0xB0, 0x94, 0x01, 0xB0, 0xB7, 0x30, 0xDA, 0x0D, 0x60, 0x9B, 0x02,
  0x71, 0x0A, 0xA0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xC7, 0x0B, 0xA0, 0xE0, 0x37, 0x10, 0x30, 0xEA,
  0x0D, 0x05, 0x28, 0x11, 0x6D, 0xA0, 0xC0, 0x27, 0x30, 0x20, 0xCF, 0xA0, 0x77, 0x78, 0x15, 0xAD,
  0xA8, 0x2D, 0xB6, 0x17, 0x30,
  // "Ô" (U+00D4)
  0x77, 0x06, 0x0F, 0x77, 0x75, 0x05, 0xC0, 0x27, 0x73, 0x02, 0x0E, 0xC0, 0x67, 0x73, 0x85, 0xCF,
  0xE6, 0xEF, 0xC7, 0x72, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x78, 0x28, 0xFD, 0x23, 0x81, 0xBF,
  0xA7, 0x68, 0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0F, 0x20, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x27,
  0x60, 0x30, 0xCF, 0xA0, 0x87, 0x40, 0x8B, 0x09, 0x03, 0x20, 0x20, 0x8B, 0x0B, 0x72, 0x0A, 0xA0,
  0xE0, 0x46, 0x05, 0xB0, 0x87, 0x0A, 0xB0, 0x37, 0x10, 0xAB, 0x02, 0x50, 0x6B, 0x06, 0x72, 0x03,
  0xB0, 0x94, 0x03, 0xB0, 0xB7, 0x4B, 0x0D, 0x40, 0xBB, 0x03, 0x74, 0x0C, 0xB0, 0x12, 0x05, 0xB0,
  0xA7, 0x50, 0xBB, 0x04, 0x20, 0xCB, 0x04, 0x75, 0x0B, 0xB8, 0x15, 0x03, 0xB0, 0xD7, 0x60, 0xCB,
  0x81, 0x50, 0x9B, 0x08, 0x76, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x47, 0x6C, 0x00, 0x3C, 0x76, 0x02,
  0xC1, 0x06, 0xB0, 0xC7, 0x60, 0x5B, 0x81, 0xD0, 0x9B, 0x09, 0x76, 0x08, 0xB8, 0x1A, 0x0B, 0xB0,
  0x77, 0x60, 0xCB, 0x81, 0x50, 0xCB, 0x05, 0x75, 0x01, 0xC8, 0x11, 0x0D, 0xB0, 0x47, 0x50, 0x6B,
  0x0A, 0x20, 0xDB, 0x03, 0x75, 0x0C, 0xB0, 0x32, 0x0B, 0xB0, 0x37, 0x40, 0x2B, 0x0C, 0x30, 0x9B,
  0x04, 0x74, 0x0A, 0xB0, 0x33, 0x05, 0xB0, 0x77, 0x30, 0x3B, 0x09, 0x40, 0x1B, 0x0B, 0x73, 0x0D,
  0xA0, 0xD6, 0x09, 0xB0, 0x27, 0x10, 0xAA, 0x0E, 0x02, 0x60, 0x10, 0xEA, 0x0C, 0x70, 0xBA, 0x0E,
  0x03, 0x71, 0x03, 0x0E, 0xA0, 0xD0, 0x52, 0x81, 0x16, 0xDA, 0x0C, 0x02, 0x73, 0x02, 0x0C, 0xFA,
  0x07, 0x77, 0x81, 0x5A, 0xDA, 0x82, 0xDB, 0x61, 0x73,
  // "Õ" (U+00D5)
  0x73, 0x83, 0x19, 0xDD, 0x95, 0x09, 0x07, 0x75, 0x0C, 0xC0, 0xC0, 0x12, 0x81, 0x3F, 0x67, 0x48,
  0x38, 0xF4, 0x19, 0xA8, 0x3D, 0x20, 0xBE, 0x75, 0x0E, 0x0A, 0x30, 0x8D, 0x05, 0x74, 0x81, 0x3A,
  0x34, 0x83, 0x5D, 0xFC, 0x58, 0x0F, 0x20, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x27, 0x60, 0x30, 0xCF,
  0xA0, 0x87, 0x40, 0x8B, 0x09, 0x03, 0x20, 0x20, 0x8B, 0x0B, 0x72, 0x0A, 0xA0, 0xE0, 0x46, 0x05,
  0xB0, 0x87, 0x0A, 0xB0, 0x37, 0x10, 0xAB, 0x02, 0x50, 0x6B, 0x06, 0x72, 0x03, 0xB0, 0x94, 0x03,
  0xB0, 0xB7, 0x4B, 0x0D, 0x40, 0xBB, 0x03, 0x74, 0x0C, 0xB0, 0x12, 0x05, 0xB0, 0xA7, 0x50, 0xBB,
  0x04, 0x20, 0xCB, 0x04, 0x75, 0x0B, 0xB8, 0x15, 0x03, 0xB0, 0xD7, 0x60, 0xCB, 0x81, 0x50, 0x9B,
  0x08, 0x76, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x47, 0x6C, 0x00, 0x3C, 0x76, 0x02, 0xC1, 0x06, 0xB0,
  0xC7, 0x60, 0x5B, 0x81, 0xD0, 0x9B, 0x09, 0x76, 0x08, 0xB8, 0x1A, 0x0B, 0xB0, 0x77, 0x60, 0xCB,
  0x81, 0x50, 0xCB, 0x05, 0x75, 0x01, 0xC8, 0x11, 0x0D, 0xB0, 0x47, 0x50, 0x6B, 0x0A, 0x20, 0xDB,
  0x03, 0x75, 0x0C, 0xB0, 0x32, 0x0B, 0xB0, 0x37, 0x40, 0x2B, 0x0C, 0x30, 0x9B, 0x04, 0x74, 0x0A,
  0xB0, 0x33, 0x05, 0xB0, 0x77, 0x30, 0x3B, 0x09, 0x40, 0x1B, 0x0B, 0x73, 0x0D, 0xA0, 0xD6, 0x09,
  0xB0, 0x27, 0x10, 0xAA, 0x0E, 0x02, 0x60, 0x10, 0xEA, 0x0C, 0x70, 0xBA, 0x0E, 0x03, 0x71, 0x03,
  0x0E, 0xA0, 0xD0, 0x52, 0x81, 0x16, 0xDA, 0x0C, 0x02, 0x73, 0x02, 0x0C, 0xFA, 0x07, 0x77, 0x81,
  0x5A, 0xDA, 0x82, 0xDB, 0x61, 0x73,
  // "Ö" (U+00D6)
  0x74, 0x81, 0x8E, 0xB3, 0x82, 0x1C, 0xE6, 0x76, 0x03, 0xB0, 0x22, 0x08, 0xA0, 0xC7, 0x60, 0x4B,
  0x01, 0x20, 0xAA, 0x0B, 0x76, 0x82, 0x1C, 0xE7, 0x38, 0x24, 0xED, 0x38, 0x09, 0xD1, 0x08, 0x73,
  0x8C, 0xEF, 0xEC, 0x82, 0x76, 0x03, 0x0C, 0xFA, 0x08, 0x74, 0x08, 0xB0, 0x90, 0x32, 0x02, 0x08,
  0xB0, 0xB7, 0x20, 0xAA, 0x0E, 0x04, 0x60, 0x5B, 0x08, 0x70, 0xAB, 0x03, 0x71, 0x0A, 0xB0, 0x25,
  0x06, 0xB0, 0x67, 0x20, 0x3B, 0x09, 0x40, 0x3B, 0x0B, 0x74, 0xB0, 0xD4, 0x0B, 0xB0, 0x37, 0x40,
  0xCB, 0x01, 0x20, 0x5B, 0x0A, 0x75, 0x0B, 0xB0, 0x42, 0x0C, 0xB0, 0x47, 0x50, 0xBB, 0x81, 0x50,
  0x3B, 0x0D, 0x76, 0x0C, 0xB8, 0x15, 0x09, 0xB0, 0x87, 0x60, 0xDB, 0x81, 0x40, 0xEB, 0x04, 0x76,
  0xC0, 0x03, 0xC7, 0x60, 0x2C, 0x10, 0x6B, 0x0C, 0x76, 0x05, 0xB8, 0x1D, 0x09, 0xB0, 0x97, 0x60,
  0x8B, 0x81, 0xA0, 0xBB, 0x07, 0x76, 0x0C, 0xB8, 0x15, 0x0C, 0xB0, 0x57, 0x50, 0x1C, 0x81, 0x10,
  0xDB, 0x04, 0x75, 0x06, 0xB0, 0xA2, 0x0D, 0xB0, 0x37, 0x50, 0xCB, 0x03, 0x20, 0xBB, 0x03, 0x74,
  0x02, 0xB0, 0xC3, 0x09, 0xB0, 0x47, 0x40, 0xAB, 0x03, 0x30, 0x5B, 0x07, 0x73, 0x03, 0xB0, 0x94,
  0x01, 0xB0, 0xB7, 0x30, 0xDA, 0x0D, 0x60, 0x9B, 0x02, 0x71, 0x0A, 0xA0, 0xE0, 0x26, 0x01, 0x0E,
  0xA0, 0xC7, 0x0B, 0xA0, 0xE0, 0x37, 0x10, 0x30, 0xEA, 0x0D, 0x05, 0x28, 0x11, 0x6D, 0xA0, 0xC0,
  0x27, 0x30, 0x20, 0xCF, 0xA0, 0x77, 0x78, 0x15, 0xAD, 0xA8, 0x2D, 0xB6, 0x17, 0x30,
  // "×" (U+00D7)
  0x10, 0x10, 0x47, 0x38, 0x45, 0x02, 0xDE, 0x37, 0x18, 0x68, 0xF9, 0x1D, 0xFE, 0x16, 0x06, 0xA8,
  0x48, 0x02, 0xEF, 0xC5, 0x04, 0xA0, 0xA3, 0x04, 0xA0, 0xB3, 0x82, 0x2E, 0xFC, 0x50, 0x6A, 0x85,
  0x90, 0x1D, 0xFD, 0x16, 0x08, 0xA8, 0x37, 0xCF, 0xE3, 0x71, 0x0A, 0xC0, 0x57, 0x30, 0xDA, 0x08,
  0x73, 0x05, 0xB0, 0xD0, 0x17, 0x10, 0x3A, 0x82, 0xBE, 0xFC, 0x78, 0x42, 0xEF, 0xC0, 0x4A, 0x0A,
  0x58, 0x31, 0xDF, 0xD1, 0x20, 0x6A, 0x08, 0x48, 0x2B, 0xFE, 0x34, 0x08, 0xA0, 0x62, 0x09, 0xA0,
  0x46, 0x0B, 0xA0, 0x40, 0x3A, 0x07, 0x71, 0x84, 0xCF, 0xC0, 0x59, 0x72, 0x81, 0x1A, 0x10,
  // "Ø" (U+00D8)
  0x77, 0x78, 0x1E, 0xF2, 0x77, 0x68, 0x18, 0xF8, 0x74, 0x89, 0x23, 0x8C, 0xEF, 0xEC, 0x83, 0x2F,
  0xE7, 0x30, 0x20, 0xCF, 0xA8, 0x1D, 0xF6, 0x72, 0x07, 0xB0, 0x90, 0x32, 0x02, 0x09, 0xB0, 0xE7,
  0x20, 0x9A, 0x0E, 0x04, 0x60, 0x7B, 0x07, 0x70, 0x9B, 0x03, 0x70, 0x9C, 0x01, 0x50, 0x6B, 0x06,
  0x78, 0x13, 0xFE, 0xB0, 0x84, 0x02, 0xB0, 0xB7, 0x18, 0x1D, 0xF4, 0xB0, 0xD4, 0x0B, 0xB0, 0x37,
  0x83, 0x8F, 0x80, 0xDB, 0x01, 0x20, 0x4B, 0x0A, 0x78, 0x13, 0xFD, 0x20, 0xCB, 0x03, 0x20, 0xCB,
  0x04, 0x78, 0x1C, 0xF3, 0x20, 0xBB, 0x81, 0x40, 0x3B, 0x0D, 0x78, 0x17, 0xF9, 0x30, 0xCB, 0x81,
  0x50, 0x9B, 0x08, 0x68, 0x12, 0xFD, 0x40, 0xDB, 0x81, 0x40, 0xDB, 0x04, 0x68, 0x1C, 0xF4, 0x4C,
  0x03, 0x02, 0xC6, 0x81, 0x7F, 0x94, 0x01, 0xC1, 0x06, 0xB0, 0xC5, 0x82, 0x2F, 0xE1, 0x40, 0x4B,
  0x81, 0xD0, 0x9B, 0x09, 0x58, 0x1C, 0xF5, 0x50, 0x8B, 0x81, 0xA0, 0xBB, 0x07, 0x48, 0x16, 0xFA,
  0x60, 0xCB, 0x81, 0x50, 0xCB, 0x05, 0x38, 0x22, 0xEE, 0x15, 0x01, 0xC8, 0x11, 0x0D, 0xB0, 0x43,
  0x81, 0xBF, 0x56, 0x05, 0xB0, 0xA2, 0x0C, 0xB0, 0x32, 0x81, 0x6F, 0xB7, 0x0B, 0xB0, 0x32, 0x0B,
  0xB8, 0x43, 0x01, 0xEE, 0x16, 0x02, 0xB0, 0xC3, 0x09, 0xB8, 0x34, 0x0B, 0xF6, 0x70, 0xAB, 0x03,
  0x30, 0x5B, 0x82, 0x75, 0xFB, 0x70, 0x3B, 0x09, 0x40, 0x1B, 0x82, 0xCE, 0xE2, 0x70, 0xDA, 0x0D,
  0x60, 0x9C, 0x06, 0x70, 0xAA, 0x0E, 0x02, 0x60, 0x10, 0xEA, 0x0E, 0x70, 0xAA, 0x0E, 0x03, 0x71,
  0x05, 0xB0, 0xC0, 0x42, 0x81, 0x15, 0xDA, 0x0C, 0x02, 0x72, 0x81, 0xAF, 0xEF, 0xA0, 0x77, 0x38,
  0x54, 0xFB, 0x06, 0xBD, 0xA8, 0x2D, 0xB6, 0x17, 0x38, 0x21, 0xEE, 0x27, 0x76, 0x81, 0x37, 0x47,
  0x77,
  // "Ù" (U+00D9)
  0x72, 0x83, 0x17, 0x77, 0x57, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x71, 0x04, 0xB0, 0x37, 0x77, 0x10,
  0x8A, 0x09, 0x77, 0x72, 0x81, 0xCF, 0xE7, 0x77, 0x28, 0x21, 0xEF, 0x57, 0x77, 0x28, 0x13, 0xFA,
  0x80, 0xF3, 0x00, 0x7F, 0xA0, 0xD4, 0x05, 0xF9, 0x81, 0x50, 0x9F, 0xA0, 0xA4, 0x08, 0xF9, 0x03,
  0x30, 0x5C, 0x0D, 0x04, 0x71, 0x04, 0x0E, 0xA0, 0x80, 0x26, 0x0D, 0xB0, 0x37, 0x38, 0x1B, 0xFA,
  0x71, 0xB0, 0xC7, 0x48, 0x1D, 0xF5, 0x70, 0x3B, 0x09, 0x73, 0x01, 0xA0, 0x17, 0x06, 0xB0, 0x57,
  0x38, 0x14, 0xFD, 0x71, 0x09, 0xB0, 0x27, 0x38, 0x18, 0xFA, 0x71, 0x0D, 0xA0, 0xE7, 0x48, 0x1B,
  0xF7, 0x71, 0xB0, 0xB7, 0x48, 0x1E, 0xF3, 0x70, 0x4B, 0x08, 0x73, 0x02, 0xA7, 0x10, 0x7B, 0x05,
  0x73, 0x81, 0x5F, 0xC7, 0x10, 0xAB, 0x01, 0x73, 0x81, 0x8F, 0x97, 0x10, 0xEA, 0x0D, 0x74, 0x81,
  0xCF, 0x57, 0x01, 0xB0, 0xA7, 0x4A, 0x02, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x3F, 0xE7, 0x10, 0x8B,
  0x04, 0x73, 0x81, 0x6F, 0xB7, 0x10, 0xBB, 0x74, 0x81, 0x9F, 0x87, 0x10, 0xEA, 0x0D, 0x74, 0x81,
  0xDF, 0x47, 0x02, 0xB0, 0xA7, 0x4A, 0x01, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x4F, 0xD7, 0x10, 0x6B,
  0x05, 0x73, 0x81, 0x8F, 0x97, 0x10, 0x7B, 0x04, 0x73, 0x81, 0xDF, 0x47, 0x10, 0x6B, 0x04, 0x72,
  0x81, 0x4F, 0xD7, 0x20, 0x2B, 0x07, 0x72, 0x81, 0xCF, 0x67, 0x30, 0xCA, 0x0E, 0x01, 0x78, 0x1A,
  0xFB, 0x74, 0x03, 0xB8, 0x1D, 0x61, 0x28, 0x41, 0x6D, 0xFC, 0x17, 0x50, 0x40, 0xDF, 0xA0, 0xA7,
  0x72, 0x87, 0x6A, 0xDE, 0xFE, 0xC8, 0x27, 0x60,
  // "Ú" (U+00DA)
  0x77, 0x28, 0x34, 0x77, 0x73, 0x77, 0x60, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x60, 0xAA, 0x0E, 0x02,
  0x77, 0x60, 0x4A, 0x0E, 0x02, 0x77, 0x68, 0x31, 0xDF, 0xE2, 0x77, 0x78, 0x2A, 0xFD, 0x27, 0x77,
  0x82, 0x5F, 0xA1, 0x80, 0xF3, 0x00, 0x7F, 0xA0, 0xD4, 0x05, 0xF9, 0x81, 0x50, 0x9F, 0xA0, 0xA4,
  0x08, 0xF9, 0x03, 0x30, 0x5C, 0x0D, 0x04, 0x71, 0x04, 0x0E, 0xA0, 0x80, 0x26, 0x0D, 0xB0, 0x37,
  0x38, 0x1B, 0xFA, 0x71, 0xB0, 0xC7, 0x48, 0x1D, 0xF5, 0x70, 0x3B, 0x09, 0x73, 0x01, 0xA0, 0x17,
  0x06, 0xB0, 0x57, 0x38, 0x14, 0xFD, 0x71, 0x09, 0xB0, 0x27, 0x38, 0x18, 0xFA, 0x71, 0x0D, 0xA0,
  0xE7, 0x48, 0x1B, 0xF7, 0x71, 0xB0, 0xB7, 0x48, 0x1E, 0xF3, 0x70, 0x4B, 0x08, 0x73, 0x02, 0xA7,
  0x10, 0x7B, 0x05, 0x73, 0x81, 0x5F, 0xC7, 0x10, 0xAB, 0x01, 0x73, 0x81, 0x8F, 0x97, 0x10, 0xEA,
  0x0D, 0x74, 0x81, 0xCF, 0x57, 0x01, 0xB0, 0xA7, 0x4A, 0x02, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x3F,
  0xE7, 0x10, 0x8B, 0x04, 0x73, 0x81, 0x6F, 0xB7, 0x10, 0xBB, 0x74, 0x81, 0x9F, 0x87, 0x10, 0xEA,
  0x0D, 0x74, 0x81, 0xDF, 0x47, 0x02, 0xB0, 0xA7, 0x4A, 0x01, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x4F,
  0xD7, 0x10, 0x6B, 0x05, 0x73, 0x81, 0x8F, 0x97, 0x10, 0x7B, 0x04, 0x73, 0x81, 0xDF, 0x47, 0x10,
  0x6B, 0x04, 0x72, 0x81, 0x4F, 0xD7, 0x20, 0x2B, 0x07, 0x72, 0x81, 0xCF, 0x67, 0x30, 0xCA, 0x0E,
  0x01, 0x78, 0x1A, 0xFB, 0x74, 0x03, 0xB8, 0x1D, 0x61, 0x28, 0x41, 0x6D, 0xFC, 0x17, 0x50, 0x40,
  0xDF, 0xA0, 0xA7, 0x72, 0x87, 0x6A, 0xDE, 0xFE, 0xC8, 0x27, 0x60,
  // "Û" (U+00DB)
  0x77, 0x06, 0x0F, 0x77, 0x77, 0x05, 0xC0, 0x27, 0x75, 0x02, 0x0E, 0xC0, 0x67, 0x75, 0x85, 0xCF,
  0xE6, 0xEF, 0xC7, 0x74, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x72, 0x82, 0x8F, 0xD2, 0x38, 0x1B,
  0xFA, 0x77, 0x18, 0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0E, 0x70, 0x07, 0xFA, 0x0D, 0x40, 0x5F,
  0x98, 0x15, 0x09, 0xFA, 0x0A, 0x40, 0x8F, 0x90, 0x33, 0x05, 0xC0, 0xD0, 0x47, 0x10, 0x40, 0xEA,
  0x08, 0x02, 0x60, 0xDB, 0x03, 0x73, 0x81, 0xBF, 0xA7, 0x1B, 0x0C, 0x74, 0x81, 0xDF, 0x57, 0x03,
  0xB0, 0x97, 0x30, 0x1A, 0x01, 0x70, 0x6B, 0x05, 0x73, 0x81, 0x4F, 0xD7, 0x10, 0x9B, 0x02, 0x73,
  0x81, 0x8F, 0xA7, 0x10, 0xDA, 0x0E, 0x74, 0x81, 0xBF, 0x77, 0x1B, 0x0B, 0x74, 0x81, 0xEF, 0x37,
  0x04, 0xB0, 0x87, 0x30, 0x2A, 0x71, 0x07, 0xB0, 0x57, 0x38, 0x15, 0xFC, 0x71, 0x0A, 0xB0, 0x17,
  0x38, 0x18, 0xF9, 0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1C, 0xF5, 0x70, 0x1B, 0x0A, 0x74, 0xA0, 0x27,
  0x05, 0xB0, 0x77, 0x38, 0x13, 0xFE, 0x71, 0x08, 0xB0, 0x47, 0x38, 0x16, 0xFB, 0x71, 0x0B, 0xB7,
  0x48, 0x19, 0xF8, 0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1D, 0xF4, 0x70, 0x2B, 0x0A, 0x74, 0xA0, 0x17,
  0x05, 0xB0, 0x77, 0x38, 0x14, 0xFD, 0x71, 0x06, 0xB0, 0x57, 0x38, 0x18, 0xF9, 0x71, 0x07, 0xB0,
  0x47, 0x38, 0x1D, 0xF4, 0x71, 0x06, 0xB0, 0x47, 0x28, 0x14, 0xFD, 0x72, 0x02, 0xB0, 0x77, 0x28,
  0x1C, 0xF6, 0x73, 0x0C, 0xA0, 0xE0, 0x17, 0x81, 0xAF, 0xB7, 0x40, 0x3B, 0x81, 0xD6, 0x12, 0x84,
  0x16, 0xDF, 0xC1, 0x75, 0x04, 0x0D, 0xFA, 0x0A, 0x77, 0x28, 0x76, 0xAD, 0xEF, 0xEC, 0x82, 0x76,
  // "Ü" (U+00DC)
  0x73, 0x81, 0x8E, 0xB3, 0x82, 0x1C, 0xE6, 0x77, 0x10, 0x3B, 0x02, 0x20, 0x8A, 0x0C, 0x77, 0x10,
  0x4B, 0x01, 0x20, 0xAA, 0x0B, 0x77, 0x18, 0x21, 0xCE, 0x73, 0x82, 0x4E, 0xD3, 0x80, 0x9D, 0x30,
  0x07, 0xFA, 0x0D, 0x40, 0x5F, 0x98, 0x15, 0x09, 0xFA, 0x0A, 0x40, 0x8F, 0x90, 0x33, 0x05, 0xC0,
  0xD0, 0x47, 0x10, 0x40, 0xEA, 0x08, 0x02, 0x60, 0xDB, 0x03, 0x73, 0x81, 0xBF, 0xA7, 0x1B, 0x0C,
  0x74, 0x81, 0xDF, 0x57, 0x03, 0xB0, 0x97, 0x30, 0x1A, 0x01, 0x70, 0x6B, 0x05, 0x73, 0x81, 0x4F,
  0xD7, 0x10, 0x9B, 0x02, 0x73, 0x81, 0x8F, 0xA7, 0x10, 0xDA, 0x0E, 0x74, 0x81, 0xBF, 0x77, 0x1B,
  0x0B, 0x74, 0x81, 0xEF, 0x37, 0x04, 0xB0, 0x87, 0x30, 0x2A, 0x71, 0x07, 0xB0, 0x57, 0x38, 0x15,
  0xFC, 0x71, 0x0A, 0xB0, 0x17, 0x38, 0x18, 0xF9, 0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1C, 0xF5, 0x70,
  0x1B, 0x0A, 0x74, 0xA0, 0x27, 0x05, 0xB0, 0x77, 0x38, 0x13, 0xFE, 0x71, 0x08, 0xB0, 0x47, 0x38,
  0x16, 0xFB, 0x71, 0x0B, 0xB7, 0x48, 0x19, 0xF8, 0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1D, 0xF4, 0x70,
  0x2B, 0x0A, 0x74, 0xA0, 0x17, 0x05, 0xB0, 0x77, 0x38, 0x14, 0xFD, 0x71, 0x06, 0xB0, 0x57, 0x38,
  0x18, 0xF9, 0x71, 0x07, 0xB0, 0x47, 0x38, 0x1D, 0xF4, 0x71, 0x06, 0xB0, 0x47, 0x28, 0x14, 0xFD,
  0x72, 0x02, 0xB0, 0x77, 0x28, 0x1C, 0xF6, 0x73, 0x0C, 0xA0, 0xE0, 0x17, 0x81, 0xAF, 0xB7, 0x40,
  0x3B, 0x81, 0xD6, 0x12, 0x84, 0x16, 0xDF, 0xC1, 0x75, 0x04, 0x0D, 0xFA, 0x0A, 0x77, 0x28, 0x76,
  0xAD, 0xEF, 0xEC, 0x82, 0x76,
  // "Ý" (U+00DD)
  0x77, 0x83, 0x47, 0x77, 0x37, 0x73, 0x01, 0x0E, 0xA0, 0xD0, 0x17, 0x73, 0x0A, 0xA0, 0xE0, 0x27,
  0x73, 0x04, 0xA0, 0xE0, 0x27, 0x73, 0x83, 0x1D, 0xFE, 0x27, 0x74, 0x82, 0xAF, 0xD2, 0x77, 0x48,
  0x25, 0xFA, 0x18, 0x0E, 0x30, 0x03, 0xFA, 0x05, 0x30, 0xAF, 0x0D, 0x05, 0xF8, 0x1E, 0xE2, 0x30,
  0xDF, 0x82, 0xA0, 0x1B, 0xC0, 0x37, 0x10, 0x4B, 0x0A, 0x01, 0x30, 0x4B, 0x0E, 0x72, 0x02, 0xA0,
  0xC6, 0x0E, 0xB0, 0x17, 0x10, 0x7A, 0x02, 0x60, 0xAB, 0x04, 0x78, 0x21, 0xEF, 0x67, 0x06, 0xB0,
  0x87, 0x81, 0xAF, 0xB7, 0x10, 0x1B, 0x0B, 0x68, 0x25, 0xFE, 0x17, 0x20, 0xDB, 0x58, 0x21, 0xEF,
  0x57, 0x30, 0x8B, 0x04, 0x48, 0x1B, 0xF9, 0x74, 0x04, 0xB0, 0x83, 0x81, 0x6F, 0xD7, 0x6B, 0x0C,
  0x28, 0x22, 0xEF, 0x37, 0x60, 0xBB, 0x28, 0x1B, 0xF7, 0x77, 0x07, 0xB8, 0x23, 0x6F, 0xC7, 0x71,
  0x02, 0xB8, 0x27, 0xEE, 0x27, 0x72, 0x0E, 0xC0, 0x67, 0x73, 0x09, 0xB0, 0xA7, 0x74, 0x09, 0xB0,
  0x37, 0x74, 0x0C, 0xB7, 0x75, 0xB0, 0xC7, 0x74, 0x03, 0xB0, 0x97, 0x74, 0x06, 0xB0, 0x57, 0x74,
  0x09, 0xB0, 0x27, 0x74, 0x0C, 0xA0, 0xE7, 0x75, 0xB0, 0xB7, 0x74, 0x06, 0xB0, 0x97, 0x73, 0x05,
  0x0E, 0xB0, 0xD0, 0x37, 0x60, 0x40, 0xEF, 0xA0, 0xB7, 0x40, 0x7F, 0xB0, 0x87, 0x40,
  // "Þ" (U+00DE)
  0x60, 0xCF, 0xA0, 0xC7, 0x40, 0xEF, 0xA0, 0x97, 0x50, 0x10, 0x9C, 0x09, 0x02, 0x77, 0x10, 0x3B,
  0x0C, 0x77, 0x30, 0x4B, 0x07, 0x77, 0x30, 0x8C, 0x83, 0xEE, 0xDA, 0x67, 0x50, 0xBF, 0xA0, 0xE0,
  0x47, 0x30, 0xEA, 0x0B, 0x28, 0x11, 0x6E, 0xB0, 0x57, 0x10, 0x2B, 0x08, 0x40, 0x20, 0xEA, 0x0E,
  0x01, 0x70, 0x5B, 0x05, 0x50, 0x7B, 0x07, 0x70, 0x9B, 0x02, 0x50, 0x3B, 0x0B, 0x70, 0xCA, 0x0E,
  0x60, 0x1B, 0x0E, 0x7B, 0x0B, 0x7C, 0x60, 0x3B, 0x08, 0x60, 0x1B, 0x0E, 0x60, 0x6B, 0x05, 0x60,
  0x2B, 0x0D, 0x60, 0xAB, 0x01, 0x60, 0x5B, 0x0A, 0x60, 0xDA, 0x0E, 0x70, 0x9B, 0x06, 0x50, 0x1B,
  0x0B, 0x60, 0x10, 0xEB, 0x01, 0x50, 0x4B, 0x07, 0x60, 0x9B, 0x08, 0x60, 0x7B, 0x04, 0x50, 0x8B,
  0x0C, 0x70, 0xBB, 0x01, 0x28, 0x12, 0x6C, 0xB0, 0xC0, 0x17, 0x0E, 0xFB, 0x0E, 0x07, 0x71, 0x02,
  0xC0, 0xFE, 0x83, 0xDC, 0xA6, 0x17, 0x20, 0x5B, 0x07, 0x77, 0x30, 0x9B, 0x03, 0x77, 0x30, 0xEB,
  0x01, 0x77, 0x10, 0x30, 0xBC, 0x07, 0x76, 0x06, 0xFA, 0x0E, 0x02, 0x73, 0x09, 0xFA, 0x0E, 0x74,
  // "ß" (U+00DF)
  0x77, 0x28, 0x63, 0x8C, 0xEF, 0xEB, 0x77, 0x73, 0x01, 0x0A, 0xF9, 0x0D, 0x02, 0x77, 0x01, 0x0D,
  0xA0, 0xC0, 0x42, 0x02, 0x0C, 0xA0, 0xC7, 0x70, 0xCA, 0x0C, 0x50, 0x1B, 0x04, 0x75, 0x06, 0xB0,
  0x26, 0x0B, 0xA0, 0x87, 0x50, 0xDA, 0x0A, 0x70, 0x9A, 0x0A, 0x74, 0x03, 0xB0, 0x57, 0x09, 0xA0,
  0xA7, 0x40, 0x7B, 0x01, 0x70, 0xBA, 0x09, 0x74, 0x0B, 0xA0, 0xD7, 0x10, 0xEA, 0x07, 0x71, 0x0B,
  0xD0, 0xA4, 0x82, 0x4A, 0xDE, 0xB0, 0x57, 0x10, 0x0E, 0xC0, 0x72, 0x01, 0x0B, 0xC0, 0xFE, 0x02,
  0x73, 0x07, 0xB0, 0x32, 0x0B, 0xA0, 0xD0, 0x47, 0x71, 0x0A, 0xB2, 0x05, 0xA0, 0xE0, 0x17, 0x72,
  0x0D, 0xA0, 0xC2, 0x0B, 0xA0, 0x97, 0x72, 0x01, 0xB0, 0x92, 0x0D, 0xA0, 0x67, 0x72, 0x04, 0xB0,
  0x62, 0x0E, 0xA0, 0x87, 0x72, 0x07, 0xB0, 0x32, 0x0C, 0xA0, 0xE0, 0x17, 0x71, 0x0A, 0xB3, 0x08,
  0xB0, 0xC0, 0x17, 0x70, 0xDA, 0x0C, 0x30, 0x10, 0xDB, 0x0D, 0x02, 0x75, 0x01, 0xB0, 0x84, 0x02,
  0x0E, 0xB0, 0xE0, 0x37, 0x40, 0x4B, 0x05, 0x50, 0x20, 0xDB, 0x0D, 0x01, 0x73, 0x07, 0xB0, 0x26,
  0x01, 0x0D, 0xB0, 0x87, 0x30, 0xBA, 0x0E, 0x71, 0x02, 0xB0, 0xE7, 0x30, 0xEA, 0x0B, 0x72, 0x09,
  0xB0, 0x17, 0x10, 0x1B, 0x08, 0x20, 0x50, 0x85, 0x04, 0xB0, 0x27, 0x10, 0x5B, 0x83, 0x40, 0x7F,
  0xD5, 0x04, 0xB0, 0x17, 0x10, 0x8B, 0x81, 0x10, 0xCA, 0x50, 0x6A, 0x0D, 0x72, 0x0B, 0xA0, 0xD2,
  0x0D, 0xA0, 0x44, 0x0C, 0xA0, 0x77, 0x20, 0xEA, 0x0A, 0x20, 0x9A, 0x83, 0xD3, 0x02, 0xAA, 0x0D,
  0x72, 0x02, 0xB0, 0x72, 0x01, 0x0D, 0xF0, 0xC0, 0x27, 0x20, 0x5B, 0x04, 0x38, 0x61, 0x8C, 0xEF,
  0xDA, 0x57, 0x40, 0x8B, 0x77, 0x72, 0x0C, 0xA0, 0xC7, 0x77, 0x2B, 0x08, 0x77, 0x71, 0x04, 0xB0,
  0x47, 0x77, 0x10, 0x9A, 0x0D, 0x77, 0x71, 0x01, 0x0E, 0xA0, 0x77, 0x77, 0x10, 0x8A, 0x0D, 0x77,
  0x50, 0x12, 0x07, 0xB0, 0x37, 0x75, 0x0B, 0xC0, 0xE0, 0x47, 0x76, 0x84, 0xBE, 0xEC, 0x71, 0x77,
  0x70,
  // "à" (U+00E0)
  0x68, 0x31, 0x77, 0x75, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0x4B, 0x03, 0x77, 0x10, 0x8A, 0x09,
  0x77, 0x28, 0x1C, 0xFE, 0x77, 0x28, 0x21, 0xEF, 0x57, 0x72, 0x81, 0x3F, 0xA8, 0x0E, 0x00, 0x89,
  0x15, 0xBD, 0xFE, 0xA4, 0x06, 0xF3, 0x60, 0x20, 0xDF, 0x0C, 0xA6, 0x04, 0xB8, 0x3A, 0x20, 0x1A,
  0xB0, 0xD5, 0x03, 0x0E, 0xA0, 0x75, 0xB0, 0x95, 0x0D, 0xA0, 0xA5, 0x02, 0xB0, 0x64, 0x09, 0xA0,
  0xE0, 0x15, 0x05, 0xB0, 0x33, 0x02, 0xB0, 0x86, 0x08, 0xB4, 0x09, 0xB0, 0x16, 0x0B, 0xA0, 0xC4,
  0x0E, 0xA0, 0xB7, 0x0E, 0xA0, 0x93, 0x05, 0xB0, 0x66, 0x02, 0xB0, 0x63, 0x0A, 0xB0, 0x26, 0x05,
  0xB0, 0x33, 0x0E, 0xA0, 0xE7, 0x09, 0xB3, 0x01, 0xB0, 0xB7, 0x0D, 0xA0, 0xC3, 0x04, 0xB0, 0x86,
  0x03, 0xB0, 0x93, 0x05, 0xB0, 0x76, 0x0A, 0xB0, 0x63, 0x06, 0xB0, 0x65, 0x01, 0xC0, 0x33, 0x05,
  0xB0, 0x65, 0x0A, 0x0C, 0xB0, 0x13, 0x03, 0xB0, 0x84, 0x81, 0x4D, 0x7B, 0x50, 0xEA, 0x0B, 0x38,
  0x22, 0xE5, 0x8B, 0x50, 0x9B, 0x85, 0x60, 0x4E, 0x90, 0x8B, 0x85, 0x40, 0x69, 0x01, 0xED, 0x09,
  0x20, 0x3E, 0x08, 0x28, 0x42, 0xBE, 0xEB, 0x54, 0x84, 0x6D, 0xEC, 0x81, 0x10,
  // "á" (U+00E1)
  0x77, 0x83, 0x47, 0x77, 0x37, 0x60, 0x10, 0xEA, 0x0D, 0x01, 0x76, 0x0A, 0xA0, 0xE0, 0x27, 0x60,
  0x4A, 0x0E, 0x02, 0x76, 0x83, 0x1D, 0xFE, 0x27, 0x78, 0x2A, 0xFD, 0x27, 0x78, 0x25, 0xFA, 0x18,
  0x0D, 0x70, 0x89, 0x15, 0xBD, 0xFE, 0xA4, 0x06, 0xF3, 0x60, 0x20, 0xDF, 0x0C, 0xA6, 0x04, 0xB8,
  0x3A, 0x20, 0x1A, 0xB0, 0xD5, 0x03, 0x0E, 0xA0, 0x75, 0xB0, 0x95, 0x0D, 0xA0, 0xA5, 0x02, 0xB0,
  0x64, 0x09, 0xA0, 0xE0, 0x15, 0x05, 0xB0, 0x33, 0x02, 0xB0, 0x86, 0x08, 0xB4, 0x09, 0xB0, 0x16,
  0x0B, 0xA0, 0xC4, 0x0E, 0xA0, 0xB7, 0x0E, 0xA0, 0x93, 0x05, 0xB0, 0x66, 0x02, 0xB0, 0x63, 0x0A,
  0xB0, 0x26, 0x05, 0xB0, 0x33, 0x0E, 0xA0, 0xE7, 0x09, 0xB3, 0x01, 0xB0, 0xB7, 0x0D, 0xA0, 0xC3,
  0x04, 0xB0, 0x86, 0x03, 0xB0, 0x93, 0x05, 0xB0, 0x76, 0x0A, 0xB0, 0x63, 0x06, 0xB0, 0x65, 0x01,
  0xC0, 0x33, 0x05, 0xB0, 0x65, 0x0A, 0x0C, 0xB0, 0x13, 0x03, 0xB0, 0x84, 0x81, 0x4D, 0x7B, 0x50,
  0xEA, 0x0B, 0x38, 0x22, 0xE5, 0x8B, 0x50, 0x9B, 0x85, 0x60, 0x4E, 0x90, 0x8B, 0x85, 0x40, 0x69,
  0x01, 0xED, 0x09, 0x20, 0x3E, 0x08, 0x28, 0x42, 0xBE, 0xEB, 0x54, 0x84, 0x6D, 0xEC, 0x81, 0x10,
  // "â" (U+00E2)
  0x74, 0x06, 0x0F, 0x77, 0x70, 0x5C, 0x02, 0x75, 0x02, 0x0E, 0xC0, 0x67, 0x58, 0x5C, 0xFE, 0x6E,
  0xFC, 0x74, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x28, 0x28, 0xFD, 0x23, 0x81, 0xBF, 0xA7, 0x18,
  0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0D, 0x40, 0x89, 0x15, 0xBD, 0xFE, 0xA4, 0x06, 0xF3, 0x60,
  0x20, 0xDF, 0x0C, 0xA6, 0x04, 0xB8, 0x3A, 0x20, 0x1A, 0xB0, 0xD5, 0x03, 0x0E, 0xA0, 0x75, 0xB0,
  0x95, 0x0D, 0xA0, 0xA5, 0x02, 0xB0, 0x64, 0x09, 0xA0, 0xE0, 0x15, 0x05, 0xB0, 0x33, 0x02, 0xB0,
  0x86, 0x08, 0xB4, 0x09, 0xB0, 0x16, 0x0B, 0xA0, 0xC4, 0x0E, 0xA0, 0xB7, 0x0E, 0xA0, 0x93, 0x05,
  0xB0, 0x66, 0x02, 0xB0, 0x63, 0x0A, 0xB0, 0x26, 0x05, 0xB0, 0x33, 0x0E, 0xA0, 0xE7, 0x09, 0xB3,
  0x01, 0xB0, 0xB7, 0x0D, 0xA0, 0xC3, 0x04, 0xB0, 0x86, 0x03, 0xB0, 0x93, 0x05, 0xB0, 0x76, 0x0A,
  0xB0, 0x63, 0x06, 0xB0, 0x65, 0x01, 0xC0, 0x33, 0x05, 0xB0, 0x65, 0x0A, 0x0C, 0xB0, 0x13, 0x03,
  0xB0, 0x84, 0x81, 0x4D, 0x7B, 0x50, 0xEA, 0x0B, 0x38, 0x22, 0xE5, 0x8B, 0x50, 0x9B, 0x85, 0x60,
  0x4E, 0x90, 0x8B, 0x85, 0x40, 0x69, 0x01, 0xED, 0x09, 0x20, 0x3E, 0x08, 0x28, 0x42, 0xBE, 0xEB,
  0x54, 0x84, 0x6D, 0xEC, 0x81, 0x10,
  // "ã" (U+00E3)
  0x78, 0x31, 0x9D, 0xD9, 0x50, 0x90, 0x77, 0x0C, 0xC0, 0xC0, 0x12, 0x81, 0x3F, 0x66, 0x83, 0x8F,
  0x41, 0x9A, 0x83, 0xD2, 0x0B, 0xE7, 0x0E, 0x0A, 0x30, 0x8D, 0x05, 0x68, 0x13, 0xA3, 0x48, 0x35,
  0xDF, 0xC5, 0x80, 0xD4, 0x08, 0x91, 0x5B, 0xDF, 0xEA, 0x40, 0x6F, 0x36, 0x02, 0x0D, 0xF0, 0xCA,
  0x60, 0x4B, 0x83, 0xA2, 0x01, 0xAB, 0x0D, 0x50, 0x30, 0xEA, 0x07, 0x5B, 0x09, 0x50, 0xDA, 0x0A,
  0x50, 0x2B, 0x06, 0x40, 0x9A, 0x0E, 0x01, 0x50, 0x5B, 0x03, 0x30, 0x2B, 0x08, 0x60, 0x8B, 0x40,
  0x9B, 0x01, 0x60, 0xBA, 0x0C, 0x40, 0xEA, 0x0B, 0x70, 0xEA, 0x09, 0x30, 0x5B, 0x06, 0x60, 0x2B,
  0x06, 0x30, 0xAB, 0x02, 0x60, 0x5B, 0x03, 0x30, 0xEA, 0x0E, 0x70, 0x9B, 0x30, 0x1B, 0x0B, 0x70,
  0xDA, 0x0C, 0x30, 0x4B, 0x08, 0x60, 0x3B, 0x09, 0x30, 0x5B, 0x07, 0x60, 0xAB, 0x06, 0x30, 0x6B,
  0x06, 0x50, 0x1C, 0x03, 0x30, 0x5B, 0x06, 0x50, 0xA0, 0xCB, 0x01, 0x30, 0x3B, 0x08, 0x48, 0x14,
  0xD7, 0xB5, 0x0E, 0xA0, 0xB3, 0x82, 0x2E, 0x58, 0xB5, 0x09, 0xB8, 0x56, 0x04, 0xE9, 0x08, 0xB8,
  0x54, 0x06, 0x90, 0x1E, 0xD0, 0x92, 0x03, 0xE0, 0x82, 0x84, 0x2B, 0xEE, 0xB5, 0x48, 0x46, 0xDE,
  0xC8, 0x11,
  // "ä" (U+00E4)
  0x78, 0x18, 0xEB, 0x38, 0x21, 0xCE, 0x67, 0x10, 0x3B, 0x02, 0x20, 0x8A, 0x0C, 0x71, 0x04, 0xB0,
  0x12, 0x0A, 0xA0, 0xB7, 0x18, 0x21, 0xCE, 0x73, 0x82, 0x4E, 0xD3, 0x80, 0x9A, 0x20, 0x89, 0x15,
  0xBD, 0xFE, 0xA4, 0x06, 0xF3, 0x60, 0x20, 0xDF, 0x0C, 0xA6, 0x04, 0xB8, 0x3A, 0x20, 0x1A, 0xB0,
  0xD5, 0x03, 0x0E, 0xA0, 0x75, 0xB0, 0x95, 0x0D, 0xA0, 0xA5, 0x02, 0xB0, 0x64, 0x09, 0xA0, 0xE0,
  0x15, 0x05, 0xB0, 0x33, 0x02, 0xB0, 0x86, 0x08, 0xB4, 0x09, 0xB0, 0x16, 0x0B, 0xA0, 0xC4, 0x0E,
  0xA0, 0xB7, 0x0E, 0xA0, 0x93, 0x05, 0xB0, 0x66, 0x02, 0xB0, 0x63, 0x0A, 0xB0, 0x26, 0x05, 0xB0,
  0x33, 0x0E, 0xA0, 0xE7, 0x09, 0xB3, 0x01, 0xB0, 0xB7, 0x0D, 0xA0, 0xC3, 0x04, 0xB0, 0x86, 0x03,
  0xB0, 0x93, 0x05, 0xB0, 0x76, 0x0A, 0xB0, 0x63, 0x06, 0xB0, 0x65, 0x01, 0xC0, 0x33, 0x05, 0xB0,
  0x65, 0x0A, 0x0C, 0xB0, 0x13, 0x03, 0xB0, 0x84, 0x81, 0x4D, 0x7B, 0x50, 0xEA, 0x0B, 0x38, 0x22,
  0xE5, 0x8B, 0x50, 0x9B, 0x85, 0x60, 0x4E, 0x90, 0x8B, 0x85, 0x40, 0x69, 0x01, 0xED, 0x09, 0x20,
  0x3E, 0x08, 0x28, 0x42, 0xBE, 0xEB, 0x54, 0x84, 0x6D, 0xEC, 0x81, 0x10,
  // "å" (U+00E5)
  0x73, 0x84, 0x8D, 0xFD, 0x81, 0x75, 0x0C, 0xD0, 0xD7, 0x48, 0x76, 0xFC, 0x20, 0x2C, 0xF6, 0x73,
  0x81, 0x9F, 0x43, 0x81, 0x5F, 0x87, 0x38, 0x1A, 0xF4, 0x38, 0x16, 0xF8, 0x73, 0x87, 0x7F, 0xB1,
  0x03, 0xDF, 0x47, 0x30, 0x10, 0xED, 0x0B, 0x75, 0x84, 0x19, 0xDF, 0xD7, 0x80, 0xD6, 0x08, 0x91,
  0x5B, 0xDF, 0xEA, 0x40, 0x6F, 0x36, 0x02, 0x0D, 0xF0, 0xCA, 0x60, 0x4B, 0x83, 0xA2, 0x01, 0xAB,
  0x0D, 0x50, 0x30, 0xEA, 0x07, 0x5B, 0x09, 0x50, 0xDA, 0x0A, 0x50, 0x2B, 0x06, 0x40, 0x9A, 0x0E,
  0x01, 0x50, 0x5B, 0x03, 0x30, 0x2B, 0x08, 0x60, 0x8B, 0x40, 0x9B, 0x01, 0x60, 0xBA, 0x0C, 0x40,
  0xEA, 0x0B, 0x70, 0xEA, 0x09, 0x30, 0x5B, 0x06, 0x60, 0x2B, 0x06, 0x30, 0xAB, 0x02, 0x60, 0x5B,
  0x03, 0x30, 0xEA, 0x0E, 0x70, 0x9B, 0x30, 0x1B, 0x0B, 0x70, 0xDA, 0x0C, 0x30, 0x4B, 0x08, 0x60,
  0x3B, 0x09, 0x30, 0x5B, 0x07, 0x60, 0xAB, 0x06, 0x30, 0x6B, 0x06, 0x50, 0x1C, 0x03, 0x30, 0x5B,
  0x06, 0x50, 0xA0, 0xCB, 0x01, 0x30, 0x3B, 0x08, 0x48, 0x14, 0xD7, 0xB5, 0x0E, 0xA0, 0xB3, 0x82,
  0x2E, 0x58, 0xB5, 0x09, 0xB8, 0x56, 0x04, 0xE9, 0x08, 0xB8, 0x54, 0x06, 0x90, 0x1E, 0xD0, 0x92,
  0x03, 0xE0, 0x82, 0x84, 0x2B, 0xEE, 0xB5, 0x48, 0x46, 0xDE, 0xC8, 0x11,
  // "æ" (U+00E6)
  0x78, 0x61, 0x7C, 0xEE, 0xD8, 0x14, 0x85, 0x4A, 0xDF, 0xEB, 0x47, 0x10, 0x60, 0xEE, 0x83, 0xE4,
  0x02, 0xBF, 0x06, 0x60, 0x9B, 0x83, 0x81, 0x02, 0xAA, 0x86, 0x7E, 0xFD, 0x40, 0x2D, 0xA0, 0xE5,
  0x08, 0xB0, 0x45, 0x09, 0xB0, 0xE0, 0x23, 0x07, 0xB0, 0x33, 0x03, 0xB0, 0x76, 0x03, 0xB0, 0x54,
  0x06, 0xB0, 0x43, 0x0D, 0xA0, 0xD7, 0x0B, 0xA0, 0xB5, 0x09, 0xB0, 0x22, 0x06, 0xB0, 0x56, 0x03,
  0xB0, 0x45, 0x0D, 0xA0, 0xC3, 0x0C, 0xA0, 0xE7, 0x09, 0xA0, 0xD5, 0x08, 0xB0, 0x42, 0x03, 0xB0,
  0x97, 0x0E, 0xA0, 0x94, 0x08, 0xB0, 0x73, 0x08, 0xB0, 0x46, 0x04, 0xB8, 0x34, 0x02, 0x7D, 0xB0,
  0x74, 0x0C, 0xB0, 0x16, 0x08, 0xFA, 0x0C, 0x03, 0x5B, 0x0D, 0x70, 0xCD, 0x82, 0xEC, 0x83, 0x60,
  0x2B, 0x0B, 0x7B, 0x0B, 0x75, 0x03, 0xB0, 0x96, 0x03, 0xB0, 0xA7, 0x50, 0x4B, 0x08, 0x60, 0x7B,
  0x0A, 0x75, 0x04, 0xB0, 0x76, 0x0C, 0xB0, 0xA7, 0x50, 0x3B, 0x09, 0x58, 0x12, 0xED, 0xA0, 0xD7,
  0x6B, 0x0B, 0x58, 0x1A, 0x98, 0xB0, 0x16, 0x02, 0x09, 0x40, 0xBB, 0x01, 0x38, 0x24, 0xE1, 0x3B,
  0x09, 0x58, 0x12, 0xD8, 0x40, 0x5B, 0x84, 0xB1, 0x06, 0xF5, 0x20, 0xAB, 0x86, 0x81, 0x02, 0x7E,
  0xE1, 0x50, 0x9E, 0x07, 0x40, 0xBF, 0x0D, 0x03, 0x78, 0x46, 0xCF, 0xEA, 0x36, 0x86, 0x5B, 0xEF,
  0xEC, 0x71, 0x50,
  // "ç" (U+00E7)
  0x71, 0x85, 0x6B, 0xEF, 0xEB, 0x57, 0x10, 0x40, 0xDF, 0x09, 0x60, 0x6A, 0x83, 0xD4, 0x02, 0xDB,
  0x04, 0x40, 0x5A, 0x0E, 0x01, 0x30, 0x4B, 0x08, 0x30, 0x3B, 0x04, 0x5B, 0x06, 0x30, 0xCA, 0x0B,
  0x68, 0x1D, 0xFD, 0x30, 0x5B, 0x03, 0x60, 0x80, 0x74, 0x0D, 0xA0, 0xD7, 0x50, 0x3B, 0x08, 0x75,
  0x08, 0xB0, 0x37, 0x50, 0xCB, 0x76, 0xB0, 0xC7, 0x50, 0x2B, 0x0A, 0x75, 0x04, 0xB0, 0x97, 0x50,
  0x4B, 0x08, 0x75, 0x03, 0xB0, 0x87, 0x50, 0x1B, 0x0A, 0x76, 0x0D, 0xA0, 0xE7, 0x02, 0x05, 0x40,
  0x6B, 0x06, 0x58, 0x12, 0xD6, 0x50, 0xCB, 0x06, 0x28, 0x21, 0x7E, 0xD6, 0x01, 0x0B, 0xF0, 0xD0,
  0x27, 0x18, 0x55, 0xBE, 0xFD, 0xB6, 0x75, 0x0B, 0x0E, 0x77, 0x81, 0x2F, 0x97, 0x70, 0x9A, 0x09,
  0x76, 0x04, 0x0B, 0xA0, 0x97, 0x70, 0xEA, 0x77, 0x0B, 0xA0, 0x17, 0x68, 0x1E, 0xFE, 0x72, 0x83,
  0x32, 0x13, 0xBA, 0x09, 0x72, 0x0D, 0xD0, 0xC0, 0x17, 0x28, 0x4B, 0xEF, 0xEB, 0x67, 0x20,
  // "è" (U+00E8)
  0x78, 0x31, 0x77, 0x75, 0x76, 0x0D, 0xA0, 0xD7, 0x60, 0x4B, 0x03, 0x76, 0x08, 0xA0, 0x97, 0x78,
  0x1C, 0xFE, 0x77, 0x82, 0x1E, 0xF5, 0x77, 0x81, 0x3F, 0xA8, 0x0D, 0x10, 0x85, 0x6B, 0xEF, 0xEA,
  0x37, 0x10, 0x40, 0xDF, 0x04, 0x60, 0x6A, 0x83, 0xC3, 0x03, 0xEA, 0x0D, 0x50, 0x5A, 0x0D, 0x01,
  0x30, 0xAB, 0x01, 0x30, 0x3B, 0x02, 0x40, 0x9B, 0x01, 0x30, 0xCA, 0x0A, 0x50, 0xBA, 0x0E, 0x30,
  0x5B, 0x02, 0x40, 0x1B, 0x0A, 0x30, 0xDA, 0x0A, 0x50, 0xAB, 0x02, 0x20, 0x3B, 0x05, 0x30, 0x10,
  0xAB, 0x05, 0x30, 0x8B, 0x83, 0x10, 0x38, 0xEA, 0x0E, 0x05, 0x40, 0xCF, 0xA0, 0xA0, 0x15, 0xE8,
  0x2E, 0xB7, 0x26, 0x02, 0xB0, 0x97, 0x50, 0x4B, 0x07, 0x75, 0x04, 0xB0, 0x77, 0x50, 0x3B, 0x08,
  0x75, 0x01, 0xB0, 0xA7, 0x60, 0xCA, 0x0E, 0x70, 0x10, 0x54, 0x06, 0xB0, 0x65, 0x81, 0x2D, 0x75,
  0x0B, 0xB0, 0x62, 0x83, 0x28, 0xEE, 0x15, 0x01, 0x0B, 0xF0, 0xE0, 0x47, 0x18, 0x65, 0xBD, 0xFE,
  0xC7, 0x15,
  // "é" (U+00E9)
  0x77, 0x83, 0x47, 0x77, 0x37, 0x60, 0x10, 0xEA, 0x0D, 0x01, 0x76, 0x0A, 0xA0, 0xE0, 0x27, 0x60,
  0x4A, 0x0E, 0x02, 0x76, 0x83, 0x1D, 0xFE, 0x27, 0x78, 0x2A, 0xFD, 0x27, 0x78, 0x25, 0xFA, 0x18,
  0x0D, 0x70, 0x85, 0x6B, 0xEF, 0xEA, 0x37, 0x30, 0x40, 0xDF, 0x04, 0x71, 0x06, 0xA8, 0x3C, 0x30,
  0x3E, 0xA0, 0xD7, 0x05, 0xA0, 0xD0, 0x13, 0x0A, 0xB0, 0x15, 0x03, 0xB0, 0x24, 0x09, 0xB0, 0x15,
  0x0C, 0xA0, 0xA5, 0x0B, 0xA0, 0xE5, 0x05, 0xB0, 0x24, 0x01, 0xB0, 0xA5, 0x0D, 0xA0, 0xA5, 0x0A,
  0xB0, 0x24, 0x03, 0xB0, 0x53, 0x01, 0x0A, 0xB0, 0x55, 0x08, 0xB8, 0x31, 0x03, 0x8E, 0xA0, 0xE0,
  0x56, 0x0C, 0xFA, 0x0A, 0x01, 0x7E, 0x82, 0xEB, 0x72, 0x71, 0x02, 0xB0, 0x97, 0x70, 0x4B, 0x07,
  0x77, 0x04, 0xB0, 0x77, 0x70, 0x3B, 0x08, 0x77, 0x01, 0xB0, 0xA7, 0x71, 0x0C, 0xA0, 0xE7, 0x01,
  0x05, 0x60, 0x6B, 0x06, 0x58, 0x12, 0xD7, 0x70, 0xBB, 0x06, 0x28, 0x32, 0x8E, 0xE1, 0x70, 0x10,
  0xBF, 0x0E, 0x04, 0x73, 0x86, 0x5B, 0xDF, 0xEC, 0x71, 0x70,
  // "ê" (U+00EA)
  0x74, 0x06, 0x0F, 0x77, 0x50, 0x5C, 0x02, 0x73, 0x02, 0x0E, 0xC0, 0x67, 0x38, 0x5C, 0xFE, 0x6E,
  0xFC, 0x72, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x82, 0x8F, 0xD2, 0x38, 0x1B, 0xFA, 0x68, 0x25,
  0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0C, 0x60, 0x85, 0x6B, 0xEF, 0xEA, 0x37, 0x10, 0x40, 0xDF, 0x04,
  0x60, 0x6A, 0x83, 0xC3, 0x03, 0xEA, 0x0D, 0x50, 0x5A, 0x0D, 0x01, 0x30, 0xAB, 0x01, 0x30, 0x3B,
  0x02, 0x40, 0x9B, 0x01, 0x30, 0xCA, 0x0A, 0x50, 0xBA, 0x0E, 0x30, 0x5B, 0x02, 0x40, 0x1B, 0x0A,
  0x30, 0xDA, 0x0A, 0x50, 0xAB, 0x02, 0x20, 0x3B, 0x05, 0x30, 0x10, 0xAB, 0x05, 0x30, 0x8B, 0x83,
  0x10, 0x38, 0xEA, 0x0E, 0x05, 0x40, 0xCF, 0xA0, 0xA0, 0x15, 0xE8, 0x2E, 0xB7, 0x26, 0x02, 0xB0,
  0x97, 0x50, 0x4B, 0x07, 0x75, 0x04, 0xB0, 0x77, 0x50, 0x3B, 0x08, 0x75, 0x01, 0xB0, 0xA7, 0x60,
  0xCA, 0x0E, 0x70, 0x10, 0x54, 0x06, 0xB0, 0x65, 0x81, 0x2D, 0x75, 0x0B, 0xB0, 0x62, 0x83, 0x28,
  0xEE, 0x15, 0x01, 0x0B, 0xF0, 0xE0, 0x47, 0x18, 0x65, 0xBD, 0xFE, 0xC7, 0x15,
  // "ë" (U+00EB)
  0x78, 0x18, 0xEB, 0x38, 0x21, 0xCE, 0x66, 0x03, 0xB0, 0x22, 0x08, 0xA0, 0xC6, 0x04, 0xB0, 0x12,
  0x0A, 0xA0, 0xB6, 0x82, 0x1C, 0xE7, 0x38, 0x24, 0xED, 0x38, 0x09, 0x90, 0x08, 0x56, 0xBE, 0xFE,
  0xA3, 0x71, 0x04, 0x0D, 0xF0, 0x46, 0x06, 0xA8, 0x3C, 0x30, 0x3E, 0xA0, 0xD5, 0x05, 0xA0, 0xD0,
  0x13, 0x0A, 0xB0, 0x13, 0x03, 0xB0, 0x24, 0x09, 0xB0, 0x13, 0x0C, 0xA0, 0xA5, 0x0B, 0xA0, 0xE3,
  0x05, 0xB0, 0x24, 0x01, 0xB0, 0xA3, 0x0D, 0xA0, 0xA5, 0x0A, 0xB0, 0x22, 0x03, 0xB0, 0x53, 0x01,
  0x0A, 0xB0, 0x53, 0x08, 0xB8, 0x31, 0x03, 0x8E, 0xA0, 0xE0, 0x54, 0x0C, 0xFA, 0x0A, 0x01, 0x5E,
  0x82, 0xEB, 0x72, 0x60, 0x2B, 0x09, 0x75, 0x04, 0xB0, 0x77, 0x50, 0x4B, 0x07, 0x75, 0x03, 0xB0,
  0x87, 0x50, 0x1B, 0x0A, 0x76, 0x0C, 0xA0, 0xE7, 0x01, 0x05, 0x40, 0x6B, 0x06, 0x58, 0x12, 0xD7,
  0x50, 0xBB, 0x06, 0x28, 0x32, 0x8E, 0xE1, 0x50, 0x10, 0xBF, 0x0E, 0x04, 0x71, 0x86, 0x5B, 0xDF,
  0xEC, 0x71, 0x50,
  // "ì" (U+00EC)
  0x18, 0x31, 0x77, 0x75, 0x50, 0xDA, 0x0D, 0x50, 0x4B, 0x03, 0x50, 0x8A, 0x09, 0x68, 0x1C, 0xFE,
  0x68, 0x21, 0xEF, 0x56, 0x81, 0x3F, 0xA7, 0x76, 0xE8, 0x17, 0x02, 0xE0, 0x33, 0x04, 0xC5, 0x0D,
  0xA0, 0xD5, 0x0E, 0xA0, 0x94, 0x02, 0xB0, 0x64, 0x05, 0xB0, 0x34, 0x09, 0xB5, 0x0C, 0xA0, 0xC5,
  0xB0, 0x94, 0x03, 0xB0, 0x64, 0x06, 0xB0, 0x24, 0x09, 0xA0, 0xE5, 0x0C, 0xA0, 0xC5, 0xB0, 0x94,
  0x02, 0xB0, 0x64, 0x04, 0xB0, 0x44, 0x06, 0xB0, 0x24, 0x06, 0xB0, 0x24, 0x04, 0xB8, 0x27, 0x04,
  0xC2, 0x0D, 0xD8, 0x7A, 0x10, 0x3C, 0xFD, 0xA3, 0x20,
  // "í" (U+00ED)
  0x71, 0x83, 0x47, 0x77, 0x37, 0x01, 0x0E, 0xA0, 0xD0, 0x17, 0x0A, 0xA0, 0xE0, 0x27, 0x04, 0xA0,
  0xE0, 0x27, 0x83, 0x1D, 0xFE, 0x27, 0x18, 0x2A, 0xFD, 0x27, 0x18, 0x25, 0xFA, 0x17, 0x77, 0x74,
  0xE0, 0x75, 0x02, 0xE0, 0x37, 0x04, 0xC7, 0x20, 0xDA, 0x0D, 0x72, 0x0E, 0xA0, 0x97, 0x10, 0x2B,
  0x06, 0x71, 0x05, 0xB0, 0x37, 0x10, 0x9B, 0x72, 0x0C, 0xA0, 0xC7, 0x2B, 0x09, 0x71, 0x03, 0xB0,
  0x67, 0x10, 0x6B, 0x02, 0x71, 0x09, 0xA0, 0xE7, 0x20, 0xCA, 0x0C, 0x72, 0xB0, 0x97, 0x10, 0x2B,
  0x06, 0x71, 0x04, 0xB0, 0x47, 0x10, 0x6B, 0x02, 0x71, 0x06, 0xB0, 0x27, 0x10, 0x4B, 0x82, 0x70,
  0x4C, 0x60, 0xDD, 0x0A, 0x01, 0x58, 0x43, 0xCF, 0xDA, 0x36,
  // "î" (U+00EE)
  0x50, 0x60, 0xF7, 0x60, 0x5C, 0x02, 0x40, 0x20, 0xEC, 0x06, 0x48, 0x5C, 0xFE, 0x6E, 0xFC, 0x38,
  0x4A, 0xFE, 0x30, 0x6A, 0x84, 0x30, 0x8F, 0xD2, 0x38, 0x5B, 0xFA, 0x5F, 0xA1, 0x40, 0x10, 0xC9,
  0x77, 0x73, 0xE0, 0x73, 0x02, 0xE0, 0x35, 0x04, 0xC7, 0x0D, 0xA0, 0xD7, 0x0E, 0xA0, 0x96, 0x02,
  0xB0, 0x66, 0x05, 0xB0, 0x36, 0x09, 0xB7, 0x0C, 0xA0, 0xC7, 0xB0, 0x96, 0x03, 0xB0, 0x66, 0x06,
  0xB0, 0x26, 0x09, 0xA0, 0xE7, 0x0C, 0xA0, 0xC7, 0xB0, 0x96, 0x02, 0xB0, 0x66, 0x04, 0xB0, 0x46,
  0x06, 0xB0, 0x26, 0x06, 0xB0, 0x26, 0x04, 0xB8, 0x27, 0x04, 0xC4, 0x0D, 0xD0, 0xA0, 0x13, 0x84,
  0x3C, 0xFD, 0xA3, 0x30,
  // "ï" (U+00EF)
  0x18, 0x18, 0xEB, 0x38, 0x31, 0xCE, 0x63, 0xB0, 0x22, 0x08, 0xA0, 0xC0, 0x4B, 0x01, 0x20, 0xAA,
  0x83, 0xB1, 0xCE, 0x73, 0x82, 0x4E, 0xD3, 0x80, 0xD1, 0x0E, 0x07, 0x30, 0x2E, 0x03, 0x50, 0x4C,
  0x70, 0xDA, 0x0D, 0x70, 0xEA, 0x09, 0x60, 0x2B, 0x06, 0x60, 0x5B, 0x03, 0x60, 0x9B, 0x70, 0xCA,
  0x0C, 0x7B, 0x09, 0x60, 0x3B, 0x06, 0x60, 0x6B, 0x02, 0x60, 0x9A, 0x0E, 0x70, 0xCA, 0x0C, 0x7B,
  0x09, 0x60, 0x2B, 0x06, 0x60, 0x4B, 0x04, 0x60, 0x6B, 0x02, 0x60, 0x6B, 0x02, 0x60, 0x4B, 0x82,
  0x70, 0x4C, 0x40, 0xDD, 0x0A, 0x01, 0x38, 0x43, 0xCF, 0xDA, 0x34,
  // "ð" (U+00F0)
  0x78, 0x27, 0xE7, 0x15, 0x81, 0x3C, 0x17, 0x0B, 0xA0, 0xE0, 0x52, 0x82, 0x1A, 0xFD, 0x72, 0x07,
  0x0E, 0xA8, 0x48, 0x7E, 0xFC, 0x37, 0x30, 0x20, 0xCB, 0x0E, 0x06, 0x75, 0x02, 0x0B, 0xB0, 0x77,
  0x40, 0x10, 0x8A, 0x83, 0xBE, 0xFE, 0x17, 0x38, 0x4A, 0xFD, 0x50, 0x5A, 0x0B, 0x73, 0x0D, 0x07,
  0x40, 0xDA, 0x02, 0x72, 0x01, 0x50, 0x7A, 0x09, 0x77, 0x10, 0x2A, 0x0E, 0x72, 0x86, 0x49, 0xDE,
  0xEB, 0x5E, 0xA0, 0x46, 0x01, 0x0B, 0xFB, 0x07, 0x50, 0x20, 0xDA, 0x83, 0xD4, 0x11, 0x8C, 0x0A,
  0x50, 0xDA, 0x0C, 0x50, 0xAB, 0x0B, 0x40, 0xAA, 0x0E, 0x01, 0x50, 0x4B, 0x0D, 0x30, 0x3B, 0x07,
  0x60, 0x1B, 0x0D, 0x30, 0xBA, 0x0E, 0x71, 0xB0, 0xD2, 0x02, 0xB0, 0x97, 0x1B, 0x0B, 0x20, 0x7B,
  0x04, 0x70, 0x1B, 0x0A, 0x20, 0xCB, 0x71, 0x02, 0xB0, 0x82, 0xB0, 0xD7, 0x10, 0x5B, 0x81, 0x50,
  0x2B, 0x0A, 0x71, 0x08, 0xB8, 0x12, 0x03, 0xB0, 0x97, 0x10, 0xCA, 0x0D, 0x20, 0x4B, 0x07, 0x70,
  0x1B, 0x08, 0x20, 0x3B, 0x07, 0x70, 0x6B, 0x02, 0x20, 0x2B, 0x08, 0x70, 0xDA, 0x0A, 0x40, 0xDA,
  0x0B, 0x60, 0x7A, 0x0E, 0x02, 0x40, 0x8B, 0x02, 0x40, 0x4B, 0x05, 0x60, 0xDA, 0x83, 0xC3, 0x01,
  0x7B, 0x07, 0x70, 0x20, 0xDF, 0x0E, 0x04, 0x73, 0x85, 0x6C, 0xEF, 0xEB, 0x67, 0x10,
  // "ñ" (U+00F1)
  0x78, 0x31, 0x9D, 0xD9, 0x50, 0x90, 0x77, 0x10, 0xCC, 0x0C, 0x01, 0x28, 0x13, 0xF6, 0x78, 0x38,
  0xF4, 0x19, 0xA8, 0x3D, 0x20, 0xBE, 0x71, 0x0E, 0x0A, 0x30, 0x8D, 0x05, 0x78, 0x13, 0xA3, 0x48,
  0x35, 0xDF, 0xC5, 0x80, 0xD0, 0x00, 0x2E, 0x04, 0x28, 0x44, 0xAE, 0xFC, 0x44, 0x05, 0xE8, 0x11,
  0x08, 0xE0, 0x25, 0x07, 0xB8, 0x5E, 0x08, 0xD4, 0x04, 0xB0, 0x96, 0x0E, 0xA8, 0x2B, 0x5E, 0x23,
  0x0E, 0xA0, 0xC6, 0xB8, 0x1C, 0xE3, 0x40, 0xDA, 0x0D, 0x50, 0x2C, 0x08, 0x5B, 0x0C, 0x50, 0x5B,
  0x0E, 0x01, 0x40, 0x1B, 0x09, 0x50, 0x9B, 0x07, 0x50, 0x4B, 0x06, 0x50, 0xCB, 0x01, 0x50, 0x7B,
  0x03, 0x5B, 0x0A, 0x60, 0xAB, 0x50, 0x3B, 0x06, 0x60, 0xEA, 0x0C, 0x50, 0x6B, 0x02, 0x50, 0x2B,
  0x09, 0x50, 0x9A, 0x0E, 0x60, 0x5B, 0x06, 0x50, 0xCA, 0x0B, 0x60, 0x8B, 0x02, 0x5B, 0x08, 0x60,
  0xBB, 0x50, 0x3B, 0x05, 0x60, 0xEA, 0x0C, 0x50, 0x6B, 0x01, 0x6B, 0x09, 0x50, 0x9A, 0x0E, 0x60,
  0x1B, 0x08, 0x50, 0xDA, 0x0B, 0x60, 0x1B, 0x08, 0x5B, 0x07, 0x70, 0xEA, 0x84, 0xC0, 0x2A, 0x13,
  0xB0, 0x47, 0x07, 0xD8, 0x1D, 0x37, 0xB0, 0x17, 0x18, 0x39, 0xEE, 0xC6, 0x20,
  // "ò" (U+00F2)
  0x78, 0x31, 0x77, 0x75, 0x77, 0x0D, 0xA0, 0xD7, 0x70, 0x4B, 0x03, 0x77, 0x08, 0xA0, 0x97, 0x71,
  0x81, 0xCF, 0xE7, 0x71, 0x82, 0x1E, 0xF5, 0x77, 0x18, 0x13, 0xFA, 0x80, 0xD3, 0x08, 0x61, 0x7B,
  0xEF, 0xDA, 0x47, 0x20, 0x50, 0xEF, 0x09, 0x70, 0x8A, 0x0D, 0x05, 0x20, 0x5B, 0x08, 0x50, 0x7A,
  0x0D, 0x01, 0x40, 0x7B, 0x02, 0x30, 0x4B, 0x03, 0x50, 0x1B, 0x08, 0x30, 0xDA, 0x09, 0x70, 0xEA,
  0x0B, 0x20, 0x6B, 0x02, 0x70, 0xDA, 0x0D, 0x20, 0xDA, 0x0C, 0x71, 0x0D, 0xA8, 0x1E, 0x04, 0xB0,
  0x77, 0x10, 0xEA, 0x81, 0xE0, 0x9B, 0x03, 0x71, 0xB8, 0x1D, 0x0D, 0xB7, 0x10, 0x2B, 0x0A, 0x1B,
  0x0C, 0x71, 0x04, 0xB0, 0x70, 0x2B, 0x0A, 0x71, 0x08, 0xB0, 0x30, 0x4B, 0x08, 0x71, 0x0C, 0xA8,
  0x1E, 0x04, 0xB0, 0x77, 0x01, 0xB8, 0x18, 0x03, 0xB0, 0x77, 0x07, 0xB8, 0x12, 0x01, 0xB0, 0x87,
  0x0E, 0xA0, 0x93, 0x0D, 0xA0, 0xB6, 0x08, 0xA0, 0xD0, 0x13, 0x07, 0xB0, 0x24, 0x04, 0xB0, 0x35,
  0x0D, 0xA8, 0x3D, 0x30, 0x17, 0xB0, 0x46, 0x02, 0x0D, 0xF0, 0xC0, 0x37, 0x28, 0x57, 0xCE, 0xED,
  0xA5, 0x70,
  // "ó" (U+00F3)
  0x77, 0x83, 0x47, 0x77, 0x37, 0x60, 0x10, 0xEA, 0x0D, 0x01, 0x76, 0x0A, 0xA0, 0xE0, 0x27, 0x60,
  0x4A, 0x0E, 0x02, 0x76, 0x83, 0x1D, 0xFE, 0x27, 0x78, 0x2A, 0xFD, 0x27, 0x78, 0x25, 0xFA, 0x18,
  0x0D, 0x60, 0x86, 0x17, 0xBE, 0xFD, 0xA4, 0x73, 0x05, 0x0E, 0xF0, 0x97, 0x10, 0x8A, 0x0D, 0x05,
  0x20, 0x5B, 0x08, 0x60, 0x7A, 0x0D, 0x01, 0x40, 0x7B, 0x02, 0x40, 0x4B, 0x03, 0x50, 0x1B, 0x08,
  0x40, 0xDA, 0x09, 0x70, 0xEA, 0x0B, 0x30, 0x6B, 0x02, 0x70, 0xDA, 0x0D, 0x30, 0xDA, 0x0C, 0x71,
  0x0D, 0xA0, 0xE2, 0x04, 0xB0, 0x77, 0x10, 0xEA, 0x0E, 0x20, 0x9B, 0x03, 0x71, 0xB0, 0xD2, 0x0D,
  0xB7, 0x10, 0x2B, 0x0A, 0x2B, 0x0C, 0x71, 0x04, 0xB8, 0x17, 0x02, 0xB0, 0xA7, 0x10, 0x8B, 0x81,
  0x30, 0x4B, 0x08, 0x71, 0x0C, 0xA0, 0xE2, 0x04, 0xB0, 0x77, 0x01, 0xB0, 0x82, 0x03, 0xB0, 0x77,
  0x07, 0xB0, 0x22, 0x01, 0xB0, 0x87, 0x0E, 0xA0, 0x94, 0x0D, 0xA0, 0xB6, 0x08, 0xA0, 0xD0, 0x14,
  0x07, 0xB0, 0x24, 0x04, 0xB0, 0x36, 0x0D, 0xA8, 0x3D, 0x30, 0x17, 0xB0, 0x47, 0x02, 0x0D, 0xF0,
  0xC0, 0x37, 0x38, 0x57, 0xCE, 0xED, 0xA5, 0x71,
  // "ô" (U+00F4)
  0x74, 0x06, 0x0F, 0x77, 0x60, 0x5C, 0x02, 0x74, 0x02, 0x0E, 0xC0, 0x67, 0x48, 0x5C, 0xFE, 0x6E,
  0xFC, 0x73, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x18, 0x28, 0xFD, 0x23, 0x81, 0xBF, 0xA7, 0x82,
  0x5F, 0xA1, 0x40, 0x10, 0xC9, 0x80, 0xD0, 0x08, 0x61, 0x7B, 0xEF, 0xDA, 0x47, 0x20, 0x50, 0xEF,
  0x09, 0x70, 0x8A, 0x0D, 0x05, 0x20, 0x5B, 0x08, 0x50, 0x7A, 0x0D, 0x01, 0x40, 0x7B, 0x02, 0x30,
  0x4B, 0x03, 0x50, 0x1B, 0x08, 0x30, 0xDA, 0x09, 0x70, 0xEA, 0x0B, 0x20, 0x6B, 0x02, 0x70, 0xDA,
  0x0D, 0x20, 0xDA, 0x0C, 0x71, 0x0D, 0xA8, 0x1E, 0x04, 0xB0, 0x77, 0x10, 0xEA, 0x81, 0xE0, 0x9B,
  0x03, 0x71, 0xB8, 0x1D, 0x0D, 0xB7, 0x10, 0x2B, 0x0A, 0x1B, 0x0C, 0x71, 0x04, 0xB0, 0x70, 0x2B,
  0x0A, 0x71, 0x08, 0xB0, 0x30, 0x4B, 0x08, 0x71, 0x0C, 0xA8, 0x1E, 0x04, 0xB0, 0x77, 0x01, 0xB8,
  0x18, 0x03, 0xB0, 0x77, 0x07, 0xB8, 0x12, 0x01, 0xB0, 0x87, 0x0E, 0xA0, 0x93, 0x0D, 0xA0, 0xB6,
  0x08, 0xA0, 0xD0, 0x13, 0x07, 0xB0, 0x24, 0x04, 0xB0, 0x35, 0x0D, 0xA8, 0x3D, 0x30, 0x17, 0xB0,
  0x46, 0x02, 0x0D, 0xF0, 0xC0, 0x37, 0x28, 0x57, 0xCE, 0xED, 0xA5, 0x70,
  // "õ" (U+00F5)
  0x78, 0x31, 0x9D, 0xD9, 0x50, 0x90, 0x77, 0x0C, 0xC0, 0xC0, 0x12, 0x81, 0x3F, 0x66, 0x83, 0x8F,
  0x41, 0x9A, 0x83, 0xD2, 0x0B, 0xE7, 0x0E, 0x0A, 0x30, 0x8D, 0x05, 0x68, 0x13, 0xA3, 0x48, 0x35,
  0xDF, 0xC5, 0x80, 0xD3, 0x08, 0x61, 0x7B, 0xEF, 0xDA, 0x47, 0x30, 0x50, 0xEF, 0x09, 0x71, 0x08,
  0xA0, 0xD0, 0x52, 0x05, 0xB0, 0x86, 0x07, 0xA0, 0xD0, 0x14, 0x07, 0xB0, 0x24, 0x04, 0xB0, 0x35,
  0x01, 0xB0, 0x84, 0x0D, 0xA0, 0x97, 0x0E, 0xA0, 0xB3, 0x06, 0xB0, 0x27, 0x0D, 0xA0, 0xD3, 0x0D,
  0xA0, 0xC7, 0x10, 0xDA, 0x0E, 0x20, 0x4B, 0x07, 0x71, 0x0E, 0xA0, 0xE2, 0x09, 0xB0, 0x37, 0x1B,
  0x0D, 0x20, 0xDB, 0x71, 0x02, 0xB0, 0xA2, 0xB0, 0xC7, 0x10, 0x4B, 0x81, 0x70, 0x2B, 0x0A, 0x71,
  0x08, 0xB8, 0x13, 0x04, 0xB0, 0x87, 0x10, 0xCA, 0x0E, 0x20, 0x4B, 0x07, 0x70, 0x1B, 0x08, 0x20,
  0x3B, 0x07, 0x70, 0x7B, 0x02, 0x20, 0x1B, 0x08, 0x70, 0xEA, 0x09, 0x40, 0xDA, 0x0B, 0x60, 0x8A,
  0x0D, 0x01, 0x40, 0x7B, 0x02, 0x40, 0x4B, 0x03, 0x60, 0xDA, 0x83, 0xD3, 0x01, 0x7B, 0x04, 0x70,
  0x20, 0xDF, 0x0C, 0x03, 0x73, 0x85, 0x7C, 0xEE, 0xDA, 0x57, 0x10,
  // "ö" (U+00F6)
  0x78, 0x18, 0xEB, 0x38, 0x21, 0xCE, 0x67, 0x03, 0xB0, 0x22, 0x08, 0xA0, 0xC7, 0x04, 0xB0, 0x12,
  0x0A, 0xA0, 0xB7, 0x82, 0x1C, 0xE7, 0x38, 0x24, 0xED, 0x38, 0x09, 0x94, 0x08, 0x61, 0x7B, 0xEF,
  0xDA, 0x47, 0x20, 0x50, 0xEF, 0x09, 0x70, 0x8A, 0x0D, 0x05, 0x20, 0x5B, 0x08, 0x50, 0x7A, 0x0D,
  0x01, 0x40, 0x7B, 0x02, 0x30, 0x4B, 0x03, 0x50, 0x1B, 0x08, 0x30, 0xDA, 0x09, 0x70, 0xEA, 0x0B,
  0x20, 0x6B, 0x02, 0x70, 0xDA, 0x0D, 0x20, 0xDA, 0x0C, 0x71, 0x0D, 0xA8, 0x1E, 0x04, 0xB0, 0x77,
  0x10, 0xEA, 0x81, 0xE0, 0x9B, 0x03, 0x71, 0xB8, 0x1D, 0x0D, 0xB7, 0x10, 0x2B, 0x0A, 0x1B, 0x0C,
  0x71, 0x04, 0xB0, 0x70, 0x2B, 0x0A, 0x71, 0x08, 0xB0, 0x30, 0x4B, 0x08, 0x71, 0x0C, 0xA8, 0x1E,
  0x04, 0xB0, 0x77, 0x01, 0xB8, 0x18, 0x03, 0xB0, 0x77, 0x07, 0xB8, 0x12, 0x01, 0xB0, 0x87, 0x0E,
  0xA0, 0x93, 0x0D, 0xA0, 0xB6, 0x08, 0xA0, 0xD0, 0x13, 0x07, 0xB0, 0x24, 0x04, 0xB0, 0x35, 0x0D,
  0xA8, 0x3D, 0x30, 0x17, 0xB0, 0x46, 0x02, 0x0D, 0xF0, 0xC0, 0x37, 0x28, 0x57, 0xCE, 0xED, 0xA5,
  0x70,
  // "÷" (U+00F7)
  0x68, 0x27, 0xEC, 0x27, 0x4B, 0x08, 0x74, 0xB0, 0x87, 0x48, 0x27, 0xEC, 0x28, 0x0F, 0x50, 0x08,
  0x80, 0x92, 0xE0, 0x9F, 0xF8, 0x09, 0x95, 0x08, 0x27, 0xEC, 0x27, 0x4B, 0x08, 0x74, 0xB0, 0x87,
  0x48, 0x27, 0xEC, 0x25,
  // "ø" (U+00F8)
  0x77, 0x48, 0x1D, 0xF3, 0x77, 0x38, 0x17, 0xF9, 0x72, 0x89, 0x21, 0x7B, 0xEF, 0xEB, 0x52, 0xFE,
  0x17, 0x10, 0x50, 0xEF, 0x81, 0xEF, 0x57, 0x10, 0x8A, 0x83, 0xE6, 0x10, 0x6B, 0x0B, 0x71, 0x07,
  0xA0, 0xE0, 0x34, 0x08, 0xA0, 0xE0, 0x16, 0x04, 0xB0, 0x55, 0x0C, 0xB0, 0x66, 0x0D, 0xA0, 0xB5,
  0x08, 0xC0, 0xA5, 0x06, 0xB0, 0x44, 0x82, 0x4F, 0x9D, 0xA0, 0xD5, 0x0D, 0xA0, 0xD4, 0x83, 0x1D,
  0xD0, 0xDA, 0x0E, 0x40, 0x4B, 0x08, 0x48, 0x3A, 0xF2, 0x0E, 0xA0, 0xE4, 0x09, 0xB0, 0x43, 0x81,
  0x6F, 0x62, 0xB0, 0xD4, 0x0D, 0xB0, 0x12, 0x81, 0x2F, 0xB2, 0x02, 0xB0, 0xB4, 0xB0, 0xD3, 0x81,
  0xCE, 0x12, 0x04, 0xB0, 0x83, 0x02, 0xB0, 0xA2, 0x81, 0x9F, 0x43, 0x08, 0xB0, 0x43, 0x04, 0xB8,
  0x39, 0x04, 0xF8, 0x40, 0xCA, 0x0E, 0x40, 0x4B, 0x82, 0x81, 0xEC, 0x40, 0x1B, 0x09, 0x40, 0x3B,
  0x82, 0x7B, 0xE2, 0x40, 0x7B, 0x02, 0x40, 0x1B, 0x81, 0xDF, 0x65, 0x0E, 0xA0, 0x96, 0x0D, 0xB0,
  0xA5, 0x07, 0xA0, 0xE0, 0x16, 0x07, 0xB0, 0x34, 0x04, 0xB0, 0x47, 0x01, 0xB8, 0x3C, 0x30, 0x17,
  0xB0, 0x47, 0x18, 0x19, 0xFE, 0xF0, 0xC0, 0x37, 0x18, 0x91, 0x5F, 0xB1, 0x7C, 0xEE, 0xDA, 0x57,
  0x28, 0x22, 0xEE, 0x17, 0x73, 0x81, 0x57, 0x37, 0x74,
  // "ù" (U+00F9)
  0x68, 0x31, 0x77, 0x75, 0x77, 0x10, 0xDA, 0x0D, 0x77, 0x10, 0x4B, 0x03, 0x77, 0x10, 0x8A, 0x09,
  0x77, 0x28, 0x1C, 0xFE, 0x77, 0x28, 0x21, 0xEF, 0x57, 0x72, 0x81, 0x3F, 0xA8, 0x0D, 0x00, 0x02,
  0xE0, 0x76, 0x0B, 0xA8, 0x1D, 0x05, 0xE0, 0x46, 0x0E, 0xA0, 0xA3, 0x05, 0xC0, 0x15, 0x02, 0xB0,
  0x74, 0x0D, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0xA6, 0x08, 0xB0, 0x13, 0x01, 0xB0, 0x76,
  0x0B, 0xA0, 0xD4, 0x04, 0xB0, 0x36, 0x0E, 0xA0, 0xA4, 0x08, 0xB6, 0x02, 0xB0, 0x74, 0x0B, 0xA0,
  0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0x96, 0x09, 0xB0, 0x13, 0x03, 0xB0, 0x66, 0x0C, 0xA0, 0xD4,
  0x06, 0xB0, 0x36, 0xB0, 0xA4, 0x09, 0xB6, 0x05, 0xB0, 0x64, 0x0D, 0xA0, 0xC6, 0x0A, 0xB0, 0x33,
  0x01, 0xB0, 0x95, 0x02, 0xC4, 0x04, 0xB0, 0x65, 0x09, 0xB0, 0xD4, 0x05, 0xB0, 0x44, 0x03, 0xC0,
  0xB4, 0x07, 0xB0, 0x34, 0x81, 0xC9, 0xEA, 0x0A, 0x40, 0x6B, 0x04, 0x30, 0xA0, 0xC1, 0xB0, 0xA4,
  0x03, 0xB8, 0x6A, 0x02, 0xBD, 0x10, 0xEA, 0x85, 0xD0, 0x19, 0x20, 0xCD, 0x0D, 0x01, 0x20, 0x9D,
  0x87, 0xE3, 0x02, 0xBE, 0xFC, 0x75, 0x83, 0x9E, 0xEC, 0x72,
  // "ú" (U+00FA)
  0x76, 0x83, 0x47, 0x77, 0x37, 0x60, 0x10, 0xEA, 0x0D, 0x01, 0x76, 0x0A, 0xA0, 0xE0, 0x27, 0x60,
  0x4A, 0x0E, 0x02, 0x76, 0x83, 0x1D, 0xFE, 0x27, 0x78, 0x2A, 0xFD, 0x27, 0x78, 0x25, 0xFA, 0x18,
  0x0D, 0x00, 0x02, 0xE0, 0x76, 0x0B, 0xA8, 0x1D, 0x05, 0xE0, 0x46, 0x0E, 0xA0, 0xA3, 0x05, 0xC0,
  0x15, 0x02, 0xB0, 0x74, 0x0D, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0xA6, 0x08, 0xB0, 0x13,
  0x01, 0xB0, 0x76, 0x0B, 0xA0, 0xD4, 0x04, 0xB0, 0x36, 0x0E, 0xA0, 0xA4, 0x08, 0xB6, 0x02, 0xB0,
  0x74, 0x0B, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0x96, 0x09, 0xB0, 0x13, 0x03, 0xB0, 0x66,
  0x0C, 0xA0, 0xD4, 0x06, 0xB0, 0x36, 0xB0, 0xA4, 0x09, 0xB6, 0x05, 0xB0, 0x64, 0x0D, 0xA0, 0xC6,
  0x0A, 0xB0, 0x33, 0x01, 0xB0, 0x95, 0x02, 0xC4, 0x04, 0xB0, 0x65, 0x09, 0xB0, 0xD4, 0x05, 0xB0,
  0x44, 0x03, 0xC0, 0xB4, 0x07, 0xB0, 0x34, 0x81, 0xC9, 0xEA, 0x0A, 0x40, 0x6B, 0x04, 0x30, 0xA0,
  0xC1, 0xB0, 0xA4, 0x03, 0xB8, 0x6A, 0x02, 0xBD, 0x10, 0xEA, 0x85, 0xD0, 0x19, 0x20, 0xCD, 0x0D,
  0x01, 0x20, 0x9D, 0x87, 0xE3, 0x02, 0xBE, 0xFC, 0x75, 0x83, 0x9E, 0xEC, 0x72,
  // "û" (U+00FB)
  0x74, 0x06, 0x0F, 0x77, 0x70, 0x5C, 0x02, 0x75, 0x02, 0x0E, 0xC0, 0x67, 0x58, 0x5C, 0xFE, 0x6E,
  0xFC, 0x74, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x28, 0x28, 0xFD, 0x23, 0x81, 0xBF, 0xA7, 0x18,
  0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0C, 0x40, 0x02, 0xE0, 0x76, 0x0B, 0xA8, 0x1D, 0x05, 0xE0,
  0x46, 0x0E, 0xA0, 0xA3, 0x05, 0xC0, 0x15, 0x02, 0xB0, 0x74, 0x0D, 0xA0, 0xD6, 0x05, 0xB0, 0x44,
  0x0E, 0xA0, 0xA6, 0x08, 0xB0, 0x13, 0x01, 0xB0, 0x76, 0x0B, 0xA0, 0xD4, 0x04, 0xB0, 0x36, 0x0E,
  0xA0, 0xA4, 0x08, 0xB6, 0x02, 0xB0, 0x74, 0x0B, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0x96,
  0x09, 0xB0, 0x13, 0x03, 0xB0, 0x66, 0x0C, 0xA0, 0xD4, 0x06, 0xB0, 0x36, 0xB0, 0xA4, 0x09, 0xB6,
  0x05, 0xB0, 0x64, 0x0D, 0xA0, 0xC6, 0x0A, 0xB0, 0x33, 0x01, 0xB0, 0x95, 0x02, 0xC4, 0x04, 0xB0,
  0x65, 0x09, 0xB0, 0xD4, 0x05, 0xB0, 0x44, 0x03, 0xC0, 0xB4, 0x07, 0xB0, 0x34, 0x81, 0xC9, 0xEA,
  0x0A, 0x40, 0x6B, 0x04, 0x30, 0xA0, 0xC1, 0xB0, 0xA4, 0x03, 0xB8, 0x6A, 0x02, 0xBD, 0x10, 0xEA,
  0x85, 0xD0, 0x19, 0x20, 0xCD, 0x0D, 0x01, 0x20, 0x9D, 0x87, 0xE3, 0x02, 0xBE, 0xFC, 0x75, 0x83,
  0x9E, 0xEC, 0x72,
  // "ü" (U+00FC)
  0x78, 0x18, 0xEB, 0x38, 0x21, 0xCE, 0x67, 0x10, 0x3B, 0x02, 0x20, 0x8A, 0x0C, 0x71, 0x04, 0xB0,
  0x12, 0x0A, 0xA0, 0xB7, 0x18, 0x21, 0xCE, 0x73, 0x82, 0x4E, 0xD3, 0x80, 0x99, 0x20, 0x02, 0xE0,
  0x76, 0x0B, 0xA8, 0x1D, 0x05, 0xE0, 0x46, 0x0E, 0xA0, 0xA3, 0x05, 0xC0, 0x15, 0x02, 0xB0, 0x74,
  0x0D, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0xA6, 0x08, 0xB0, 0x13, 0x01, 0xB0, 0x76, 0x0B,
  0xA0, 0xD4, 0x04, 0xB0, 0x36, 0x0E, 0xA0, 0xA4, 0x08, 0xB6, 0x02, 0xB0, 0x74, 0x0B, 0xA0, 0xD6,
  0x05, 0xB0, 0x44, 0x0E, 0xA0, 0x96, 0x09, 0xB0, 0x13, 0x03, 0xB0, 0x66, 0x0C, 0xA0, 0xD4, 0x06,
  0xB0, 0x36, 0xB0, 0xA4, 0x09, 0xB6, 0x05, 0xB0, 0x64, 0x0D, 0xA0, 0xC6, 0x0A, 0xB0, 0x33, 0x01,
  0xB0, 0x95, 0x02, 0xC4, 0x04, 0xB0, 0x65, 0x09, 0xB0, 0xD4, 0x05, 0xB0, 0x44, 0x03, 0xC0, 0xB4,
  0x07, 0xB0, 0x34, 0x81, 0xC9, 0xEA, 0x0A, 0x40, 0x6B, 0x04, 0x30, 0xA0, 0xC1, 0xB0, 0xA4, 0x03,
  0xB8, 0x6A, 0x02, 0xBD, 0x10, 0xEA, 0x85, 0xD0, 0x19, 0x20, 0xCD, 0x0D, 0x01, 0x20, 0x9D, 0x87,
  0xE3, 0x02, 0xBE, 0xFC, 0x75, 0x83, 0x9E, 0xEC, 0x72,
  // "ý" (U+00FD)
  0x77, 0x58, 0x34, 0x77, 0x73, 0x77, 0x40, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x40, 0xAA, 0x0E, 0x02,
  0x77, 0x40, 0x4A, 0x0E, 0x02, 0x77, 0x48, 0x31, 0xDF, 0xE2, 0x77, 0x58, 0x2A, 0xFD, 0x27, 0x75,
  0x82, 0x5F, 0xA1, 0x80, 0xF0, 0x0D, 0x06, 0x78, 0x29, 0xEC, 0x26, 0x03, 0xD0, 0x96, 0x06, 0xB0,
  0xC7, 0x10, 0x7B, 0x0C, 0x60, 0x7C, 0x72, 0x0D, 0xB7, 0x05, 0xB7, 0x20, 0x8B, 0x03, 0x7B, 0x72,
  0x05, 0xB0, 0x67, 0xA0, 0xD7, 0x20, 0x2B, 0x09, 0x60, 0x1A, 0x0A, 0x73, 0x0E, 0xA0, 0xC6, 0x04,
  0xA0, 0x57, 0x30, 0xBB, 0x60, 0x7A, 0x01, 0x73, 0x07, 0xB0, 0x35, 0x81, 0xCF, 0xB7, 0x40, 0x4B,
  0x06, 0x40, 0x2A, 0x04, 0x74, 0x01, 0xB0, 0x94, 0x81, 0x7F, 0xD7, 0x60, 0xDA, 0x0C, 0x48, 0x1D,
  0xF6, 0x76, 0x0A, 0xB3, 0x81, 0x5F, 0xE7, 0x70, 0x6B, 0x02, 0x28, 0x1C, 0xF6, 0x77, 0x03, 0xB8,
  0x35, 0x05, 0xFD, 0x77, 0x2B, 0x83, 0x70, 0xCF, 0x67, 0x72, 0x0C, 0xA8, 0x2A, 0x5F, 0xD7, 0x73,
  0x09, 0xA8, 0x2C, 0xDF, 0x47, 0x73, 0x05, 0xC0, 0xB7, 0x74, 0x02, 0xC0, 0x27, 0x75, 0x0E, 0xA0,
  0x87, 0x76, 0x81, 0xCF, 0xD7, 0x76, 0x04, 0xA0, 0x47, 0x75, 0x82, 0x1E, 0xFA, 0x77, 0x68, 0x2C,
  0xFE, 0x17, 0x75, 0x0B, 0xA0, 0x47, 0x75, 0x0A, 0xA0, 0x77, 0x74, 0x02, 0x0C, 0xA0, 0x97, 0x50,
  0x10, 0x23, 0x03, 0x09, 0xB0, 0x87, 0x60, 0x7F, 0x0D, 0x04, 0x77, 0x86, 0x6C, 0xEF, 0xEC, 0x95,
  0x77, 0x20,
  // "þ" (U+00FE)
  0x50, 0xCD, 0x0D, 0x76, 0x0E, 0xD0, 0x97, 0x70, 0x20, 0xDB, 0x06, 0x77, 0x10, 0x7B, 0x03, 0x77,
  0x10, 0x8B, 0x77, 0x20, 0xBA, 0x0C, 0x77, 0x20, 0xEA, 0x09, 0x77, 0x10, 0x2B, 0x06, 0x77, 0x10,
  0x5B, 0x02, 0x77, 0x10, 0x8A, 0x0E, 0x28, 0x42, 0x9D, 0xFC, 0x57, 0x10, 0xCA, 0x81, 0xB0, 0x5E,
  0x05, 0x70, 0xEA, 0x85, 0x74, 0xE6, 0x02, 0xEA, 0x0E, 0x60, 0x3B, 0x81, 0x4D, 0x43, 0x07, 0xB0,
  0x45, 0x06, 0xA8, 0x1D, 0x98, 0x40, 0x4B, 0x07, 0x50, 0x9A, 0x0E, 0x0D, 0x50, 0x2B, 0x09, 0x50,
  0xCB, 0x06, 0x50, 0x2B, 0x0A, 0x5B, 0x0E, 0x60, 0x3B, 0x09, 0x40, 0x3B, 0x07, 0x60, 0x4B, 0x08,
  0x40, 0x6B, 0x02, 0x60, 0x7B, 0x06, 0x40, 0xAA, 0x0D, 0x70, 0xAB, 0x03, 0x40, 0xDA, 0x09, 0x70,
  0xDA, 0x0E, 0x40, 0x1B, 0x06, 0x60, 0x2B, 0x0A, 0x40, 0x4B, 0x03, 0x60, 0x7B, 0x05, 0x40, 0x7A,
  0x0E, 0x70, 0xCA, 0x0E, 0x50, 0xAA, 0x0B, 0x60, 0x4B, 0x07, 0x50, 0xDA, 0x08, 0x60, 0xCA, 0x0E,
  0x50, 0x1B, 0x05, 0x50, 0x6B, 0x04, 0x50, 0x4B, 0x02, 0x40, 0x4B, 0x08, 0x60, 0x8B, 0x83, 0xD4,
  0x01, 0x7B, 0x09, 0x70, 0xBF, 0xB0, 0x67, 0x10, 0xEA, 0x86, 0x78, 0xDF, 0xEC, 0x71, 0x71, 0x02,
  0xB0, 0x37, 0x71, 0x05, 0xB0, 0x17, 0x71, 0x08, 0xA0, 0xD7, 0x72, 0x0C, 0xA0, 0xA7, 0x72, 0x0E,
  0xA0, 0x77, 0x71, 0x02, 0xB0, 0x57, 0x71, 0x06, 0xB0, 0x57, 0x71, 0x09, 0xB0, 0xB0, 0x17, 0x70,
  0xCD, 0x0E, 0x76, 0xE0, 0xD7, 0x60,
  // "ÿ" (U+00FF)
  0x75, 0x81, 0x8E, 0xB3, 0x82, 0x1C, 0xE6, 0x76, 0x03, 0xB0, 0x22, 0x08, 0xA0, 0xC7, 0x60, 0x4B,
  0x01, 0x20, 0xAA, 0x0B, 0x76, 0x82, 0x1C, 0xE7, 0x38, 0x24, 0xED, 0x38, 0x09, 0xC5, 0x0D, 0x06,
  0x78, 0x29, 0xEC, 0x26, 0x03, 0xD0, 0x96, 0x06, 0xB0, 0xC7, 0x10, 0x7B, 0x0C, 0x60, 0x7C, 0x72,
  0x0D, 0xB7, 0x05, 0xB7, 0x20, 0x8B, 0x03, 0x7B, 0x72, 0x05, 0xB0, 0x67, 0xA0, 0xD7, 0x20, 0x2B,
  0x09, 0x60, 0x1A, 0x0A, 0x73, 0x0E, 0xA0, 0xC6, 0x04, 0xA0, 0x57, 0x30, 0xBB, 0x60, 0x7A, 0x01,
  0x73, 0x07, 0xB0, 0x35, 0x81, 0xCF, 0xB7, 0x40, 0x4B, 0x06, 0x40, 0x2A, 0x04, 0x74, 0x01, 0xB0,
  0x94, 0x81, 0x7F, 0xD7, 0x60, 0xDA, 0x0C, 0x48, 0x1D, 0xF6, 0x76, 0x0A, 0xB3, 0x81, 0x5F, 0xE7,
  0x70, 0x6B, 0x02, 0x28, 0x1C, 0xF6, 0x77, 0x03, 0xB8, 0x35, 0x05, 0xFD, 0x77, 0x2B, 0x83, 0x70,
  0xCF, 0x67, 0x72, 0x0C, 0xA8, 0x2A, 0x5F, 0xD7, 0x73, 0x09, 0xA8, 0x2C, 0xDF, 0x47, 0x73, 0x05,
  0xC0, 0xB7, 0x74, 0x02, 0xC0, 0x27, 0x75, 0x0E, 0xA0, 0x87, 0x76, 0x81, 0xCF, 0xD7, 0x76, 0x04,
  0xA0, 0x47, 0x75, 0x82, 0x1E, 0xFA, 0x77, 0x68, 0x2C, 0xFE, 0x17, 0x75, 0x0B, 0xA0, 0x47, 0x75,
  0x0A, 0xA0, 0x77, 0x74, 0x02, 0x0C, 0xA0, 0x97, 0x50, 0x10, 0x23, 0x03, 0x09, 0xB0, 0x87, 0x60,
  0x7F, 0x0D, 0x04, 0x77, 0x86, 0x6C, 0xEF, 0xEC, 0x95, 0x77, 0x20,
  // "Ā" (U+0100)
  0x76, 0x01, 0x80, 0x5E, 0x0C, 0x77, 0x05, 0xFA, 0x09, 0x80, 0xF7, 0x00, 0x4B, 0x01, 0x77, 0x60,
  0xCB, 0x03, 0x77, 0x50, 0x4C, 0x05, 0x77, 0x50, 0xCC, 0x06, 0x77, 0x48, 0x25, 0xF9, 0xEA, 0x08,
  0x77, 0x48, 0x2D, 0xF3, 0xEA, 0x09, 0x77, 0x38, 0x36, 0xFB, 0x0D, 0xA0, 0xB7, 0x73, 0x83, 0xEF,
  0x30, 0xCA, 0x0C, 0x77, 0x28, 0x17, 0xFB, 0x20, 0xBA, 0x0E, 0x77, 0x18, 0x21, 0xEF, 0x32, 0x0A,
  0xB7, 0x71, 0x81, 0x8F, 0xA3, 0x09, 0xB0, 0x17, 0x68, 0x21, 0xEF, 0x23, 0x07, 0xB0, 0x37, 0x68,
  0x19, 0xF9, 0x40, 0x6B, 0x04, 0x75, 0x02, 0xA0, 0x24, 0x04, 0xB0, 0x67, 0x58, 0x19, 0xF9, 0x50,
  0x3B, 0x08, 0x74, 0x02, 0xA0, 0x15, 0x02, 0xB0, 0x97, 0x48, 0x1A, 0xF8, 0x7B, 0x0B, 0x73, 0x03,
  0xFE, 0x0C, 0x73, 0x0B, 0xFE, 0x0E, 0x72, 0x82, 0x4F, 0xE1, 0x71, 0x0C, 0xB7, 0x28, 0x1C, 0xF8,
  0x72, 0x0B, 0xB0, 0x17, 0x82, 0x5F, 0xE1, 0x72, 0x09, 0xB0, 0x37, 0x81, 0xDF, 0x77, 0x30, 0x8B,
  0x04, 0x68, 0x15, 0xFE, 0x74, 0x07, 0xB0, 0x66, 0x81, 0xDF, 0x97, 0x40, 0x6B, 0x08, 0x50, 0x8A,
  0x06, 0x74, 0x09, 0xB0, 0xB4, 0x06, 0xB0, 0xB0, 0x17, 0x20, 0x5D, 0x81, 0x40, 0x9F, 0x0E, 0x60,
  0xBF, 0x90, 0xD0, 0xCF, 0x0C, 0x60, 0xEF, 0x90, 0xB0,
  // "ā" (U+0101)
  0x70, 0x18, 0x05, 0xE0, 0xC7, 0x10, 0x5F, 0xA0, 0x98, 0x0D, 0x30, 0x89, 0x15, 0xBD, 0xFE, 0xA4,
  0x06, 0xF3, 0x60, 0x20, 0xDF, 0x0C, 0xA6, 0x04, 0xB8, 0x3A, 0x20, 0x1A, 0xB0, 0xD5, 0x03, 0x0E,
  0xA0, 0x75, 0xB0, 0x95, 0x0D, 0xA0, 0xA5, 0x02, 0xB0, 0x64, 0x09, 0xA0, 0xE0, 0x15, 0x05, 0xB0,
  0x33, 0x02, 0xB0, 0x86, 0x08, 0xB4, 0x09, 0xB0, 0x16, 0x0B, 0xA0, 0xC4, 0x0E, 0xA0, 0xB7, 0x0E,
  0xA0, 0x93, 0x05, 0xB0, 0x66, 0x02, 0xB0, 0x63, 0x0A, 0xB0, 0x26, 0x05, 0xB0, 0x33, 0x0E, 0xA0,
  0xE7, 0x09, 0xB3, 0x01, 0xB0, 0xB7, 0x0D, 0xA0, 0xC3, 0x04, 0xB0, 0x86, 0x03, 0xB0, 0x93, 0x05,
  0xB0, 0x76, 0x0A, 0xB0, 0x63, 0x06, 0xB0, 0x65, 0x01, 0xC0, 0x33, 0x05, 0xB0, 0x65, 0x0A, 0x0C,
  0xB0, 0x13, 0x03, 0xB0, 0x84, 0x81, 0x4D, 0x7B, 0x50, 0xEA, 0x0B, 0x38, 0x22, 0xE5, 0x8B, 0x50,
  0x9B, 0x85, 0x60, 0x4E, 0x90, 0x8B, 0x85, 0x40, 0x69, 0x01, 0xED, 0x09, 0x20, 0x3E, 0x08, 0x28,
  0x42, 0xBE, 0xEB, 0x54, 0x84, 0x6D, 0xEC, 0x81, 0x10,
  // "Ă" (U+0102)
  0x77, 0x81, 0x37, 0x25, 0x81, 0x17, 0x47, 0x78, 0x15, 0xF8, 0x58, 0x19, 0xF4, 0x77, 0x82, 0x2F,
  0xE4, 0x28, 0x21, 0x9F, 0xD7, 0x72, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x77, 0x20, 0x5E, 0x07, 0x77,
  0x48, 0x45, 0xCF, 0xEB, 0x48, 0x09, 0x81, 0x00, 0x4B, 0x01, 0x77, 0x60, 0xCB, 0x03, 0x77, 0x50,
  0x4C, 0x05, 0x77, 0x50, 0xCC, 0x06, 0x77, 0x48, 0x25, 0xF9, 0xEA, 0x08, 0x77, 0x48, 0x2D, 0xF3,
  0xEA, 0x09, 0x77, 0x38, 0x36, 0xFB, 0x0D, 0xA0, 0xB7, 0x73, 0x83, 0xEF, 0x30, 0xCA, 0x0C, 0x77,
  0x28, 0x17, 0xFB, 0x20, 0xBA, 0x0E, 0x77, 0x18, 0x21, 0xEF, 0x32, 0x0A, 0xB7, 0x71, 0x81, 0x8F,
  0xA3, 0x09, 0xB0, 0x17, 0x68, 0x21, 0xEF, 0x23, 0x07, 0xB0, 0x37, 0x68, 0x19, 0xF9, 0x40, 0x6B,
  0x04, 0x75, 0x02, 0xA0, 0x24, 0x04, 0xB0, 0x67, 0x58, 0x19, 0xF9, 0x50, 0x3B, 0x08, 0x74, 0x02,
  0xA0, 0x15, 0x02, 0xB0, 0x97, 0x48, 0x1A, 0xF8, 0x7B, 0x0B, 0x73, 0x03, 0xFE, 0x0C, 0x73, 0x0B,
  0xFE, 0x0E, 0x72, 0x82, 0x4F, 0xE1, 0x71, 0x0C, 0xB7, 0x28, 0x1C, 0xF8, 0x72, 0x0B, 0xB0, 0x17,
  0x82, 0x5F, 0xE1, 0x72, 0x09, 0xB0, 0x37, 0x81, 0xDF, 0x77, 0x30, 0x8B, 0x04, 0x68, 0x15, 0xFE,
  0x74, 0x07, 0xB0, 0x66, 0x81, 0xDF, 0x97, 0x40, 0x6B, 0x08, 0x50, 0x8A, 0x06, 0x74, 0x09, 0xB0,
  0xB4, 0x06, 0xB0, 0xB0, 0x17, 0x20, 0x5D, 0x81, 0x40, 0x9F, 0x0E, 0x60, 0xBF, 0x90, 0xD0, 0xCF,
  0x0C, 0x60, 0xEF, 0x90, 0xB0,
  // "ă" (U+0103)
  0x78, 0x13, 0x72, 0x58, 0x11, 0x74, 0x71, 0x81, 0x5F, 0x85, 0x81, 0x9F, 0x47, 0x18, 0x22, 0xFE,
  0x42, 0x82, 0x19, 0xFD, 0x73, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x73, 0x05, 0xE0, 0x77, 0x58, 0x45,
  0xCF, 0xEB, 0x48, 0x0D, 0x60, 0x89, 0x15, 0xBD, 0xFE, 0xA4, 0x06, 0xF3, 0x60, 0x20, 0xDF, 0x0C,
  0xA6, 0x04, 0xB8, 0x3A, 0x20, 0x1A, 0xB0, 0xD5, 0x03, 0x0E, 0xA0, 0x75, 0xB0, 0x95, 0x0D, 0xA0,
  0xA5, 0x02, 0xB0, 0x64, 0x09, 0xA0, 0xE0, 0x15, 0x05, 0xB0, 0x33, 0x02, 0xB0, 0x86, 0x08, 0xB4,
  0x09, 0xB0, 0x16, 0x0B, 0xA0, 0xC4, 0x0E, 0xA0, 0xB7, 0x0E, 0xA0, 0x93, 0x05, 0xB0, 0x66, 0x02,
  0xB0, 0x63, 0x0A, 0xB0, 0x26, 0x05, 0xB0, 0x33, 0x0E, 0xA0, 0xE7, 0x09, 0xB3, 0x01, 0xB0, 0xB7,
  0x0D, 0xA0, 0xC3, 0x04, 0xB0, 0x86, 0x03, 0xB0, 0x93, 0x05, 0xB0, 0x76, 0x0A, 0xB0, 0x63, 0x06,
  0xB0, 0x65, 0x01, 0xC0, 0x33, 0x05, 0xB0, 0x65, 0x0A, 0x0C, 0xB0, 0x13, 0x03, 0xB0, 0x84, 0x81,
  0x4D, 0x7B, 0x50, 0xEA, 0x0B, 0x38, 0x22, 0xE5, 0x8B, 0x50, 0x9B, 0x85, 0x60, 0x4E, 0x90, 0x8B,
  0x85, 0x40, 0x69, 0x01, 0xED, 0x09, 0x20, 0x3E, 0x08, 0x28, 0x42, 0xBE, 0xEB, 0x54, 0x84, 0x6D,
  0xEC, 0x81, 0x10,
  // "Ą" (U+0104)
  0x77, 0x20, 0x4B, 0x01, 0x77, 0x60, 0xCB, 0x03, 0x77, 0x50, 0x4C, 0x05, 0x77, 0x50, 0xCC, 0x06,
  0x77, 0x48, 0x25, 0xF9, 0xEA, 0x08, 0x77, 0x48, 0x2D, 0xF3, 0xEA, 0x09, 0x77, 0x38, 0x36, 0xFB,
  0x0D, 0xA0, 0xB7, 0x73, 0x83, 0xEF, 0x30, 0xCA, 0x0C, 0x77, 0x28, 0x17, 0xFB, 0x20, 0xBA, 0x0E,
  0x77, 0x18, 0x21, 0xEF, 0x32, 0x0A, 0xB7, 0x71, 0x81, 0x8F, 0xA3, 0x09, 0xB0, 0x17, 0x68, 0x21,
  0xEF, 0x23, 0x07, 0xB0, 0x37, 0x68, 0x19, 0xF9, 0x40, 0x6B, 0x04, 0x75, 0x02, 0xA0, 0x24, 0x04,
  0xB0, 0x67, 0x58, 0x19, 0xF9, 0x50, 0x3B, 0x08, 0x74, 0x02, 0xA0, 0x15, 0x02, 0xB0, 0x97, 0x48,
  0x1A, 0xF8, 0x7B, 0x0B, 0x73, 0x03, 0xFE, 0x0C, 0x73, 0x0B, 0xFE, 0x0E, 0x72, 0x82, 0x4F, 0xE1,
  0x71, 0x0C, 0xB7, 0x28, 0x1C, 0xF8, 0x72, 0x0B, 0xB0, 0x17, 0x82, 0x5F, 0xE1, 0x72, 0x09, 0xB0,
  0x37, 0x81, 0xDF, 0x77, 0x30, 0x8B, 0x04, 0x68, 0x15, 0xFE, 0x74, 0x07, 0xB0, 0x66, 0x81, 0xDF,
  0x97, 0x40, 0x6B, 0x08, 0x50, 0x8A, 0x06, 0x74, 0x09, 0xB0, 0xB4, 0x06, 0xB0, 0xB0, 0x17, 0x20,
  0x5D, 0x81, 0x40, 0x9F, 0x0E, 0x60, 0xBF, 0x90, 0xD0, 0xCF, 0x0C, 0x60, 0xEF, 0x90, 0xB7, 0x76,
  0x81, 0x17, 0x67, 0x76, 0x82, 0x1A, 0xF9, 0x77, 0x68, 0x23, 0xDF, 0x77, 0x76, 0x82, 0x1E, 0xFC,
  0x77, 0x70, 0x8A, 0x06, 0x77, 0x70, 0xBA, 0x04, 0x77, 0x70, 0xBA, 0x06, 0x77, 0x70, 0x9A, 0x83,
  0xE7, 0x58, 0x37, 0x73, 0x02, 0xE0, 0x27, 0x74, 0x84, 0x2A, 0xEE, 0xC7, 0x20,
  // "ą" (U+0105)
  0x71, 0x89, 0x15, 0xBD, 0xFE, 0xA4, 0x06, 0xF3, 0x60, 0x20, 0xDF, 0x0C, 0xA6, 0x04, 0xB8, 0x3A,
  0x20, 0x1A, 0xB0, 0xD5, 0x03, 0x0E, 0xA0, 0x75, 0xB0, 0x95, 0x0D, 0xA0, 0xA5, 0x02, 0xB0, 0x64,
  0x09, 0xA0, 0xE0, 0x15, 0x05, 0xB0, 0x33, 0x02, 0xB0, 0x86, 0x08, 0xB4, 0x09, 0xB0, 0x16, 0x0B,
  0xA0, 0xC4, 0x0E, 0xA0, 0xB7, 0x0E, 0xA0, 0x93, 0x05, 0xB0, 0x66, 0x02, 0xB0, 0x63, 0x0A, 0xB0,
  0x26, 0x05, 0xB0, 0x33, 0x0E, 0xA0, 0xE7, 0x09, 0xB3, 0x01, 0xB0, 0xB7, 0x0D, 0xA0, 0xC3, 0x04,
  0xB0, 0x86, 0x03, 0xB0, 0x93, 0x05, 0xB0, 0x76, 0x0A, 0xB0, 0x63, 0x06, 0xB0, 0x65, 0x01, 0xC0,
  0x33, 0x05, 0xB0, 0x65, 0x0A, 0x0C, 0xB0, 0x13, 0x03, 0xB0, 0x84, 0x81, 0x4D, 0x7B, 0x50, 0xEA,
  0x0B, 0x38, 0x22, 0xE5, 0x8B, 0x50, 0x9B, 0x85, 0x60, 0x4E, 0x90, 0x8B, 0x85, 0x40, 0x69, 0x01,
  0xED, 0x09, 0x20, 0x3E, 0x08, 0x28, 0x42, 0xBE, 0xEB, 0x54, 0x84, 0x6D, 0xEC, 0x81, 0x76, 0x81,
  0x17, 0x67, 0x78, 0x21, 0xAF, 0x97, 0x78, 0x23, 0xDF, 0x77, 0x78, 0x21, 0xEF, 0xC7, 0x71, 0x08,
  0xA0, 0x67, 0x71, 0x0B, 0xA0, 0x47, 0x71, 0x0B, 0xA0, 0x67, 0x71, 0x09, 0xA8, 0x3E, 0x75, 0x83,
  0x74, 0x02, 0xE0, 0x27, 0x58, 0x42, 0xAE, 0xEC, 0x74,
  // "Ć" (U+0106)
  0x77, 0x48, 0x34, 0x77, 0x73, 0x77, 0x30, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x30, 0xAA, 0x0E, 0x02,
  0x77, 0x30, 0x4A, 0x0E, 0x02, 0x77, 0x38, 0x31, 0xDF, 0xE2, 0x77, 0x48, 0x2A, 0xFD, 0x27, 0x74,
  0x82, 0x5F, 0xA1, 0x80, 0xF1, 0x08, 0x22, 0x7B, 0xDA, 0x81, 0xEB, 0x77, 0x50, 0x20, 0xAF, 0xA0,
  0xE0, 0x37, 0x20, 0x60, 0xEA, 0x0C, 0x04, 0x20, 0x20, 0xBB, 0x0D, 0x71, 0x08, 0xB0, 0x75, 0x01,
  0x0E, 0xB0, 0x46, 0x08, 0xB0, 0x67, 0x0A, 0xB0, 0x55, 0x06, 0xB0, 0x97, 0x10, 0x7B, 0x02, 0x40,
  0x2B, 0x0D, 0x72, 0x06, 0xA0, 0x75, 0x0B, 0xB0, 0x47, 0x28, 0x12, 0x62, 0x50, 0x5B, 0x0C, 0x77,
  0x40, 0xCB, 0x05, 0x77, 0x30, 0x3B, 0x0E, 0x77, 0x40, 0x9B, 0x09, 0x77, 0x40, 0xEB, 0x04, 0x77,
  0x30, 0x3C, 0x77, 0x40, 0x6B, 0x0C, 0x77, 0x40, 0x9B, 0x09, 0x77, 0x40, 0xBB, 0x07, 0x77, 0x40,
  0xCB, 0x05, 0x77, 0x40, 0xDB, 0x04, 0x77, 0x40, 0xDB, 0x03, 0x77, 0x40, 0xBB, 0x03, 0x77, 0x40,
  0xAB, 0x04, 0x77, 0x40, 0x6B, 0x07, 0x77, 0x40, 0x2B, 0x0C, 0x74, 0x04, 0x70, 0xAB, 0x03, 0x72,
  0x05, 0x0E, 0x70, 0x10, 0xEA, 0x0D, 0x01, 0x78, 0x17, 0xFA, 0x71, 0x04, 0x0E, 0xA8, 0x1E, 0x72,
  0x28, 0x41, 0x4B, 0xFE, 0x27, 0x20, 0x20, 0xCF, 0xA0, 0xC0, 0x37, 0x58, 0x74, 0x9C, 0xEF, 0xED,
  0x95, 0x72,
  // "ć" (U+0107)
  0x77, 0x83, 0x47, 0x77, 0x37, 0x60, 0x10, 0xEA, 0x0D, 0x01, 0x76, 0x0A, 0xA0, 0xE0, 0x27, 0x60,
  0x4A, 0x0E, 0x02, 0x76, 0x83, 0x1D, 0xFE, 0x27, 0x78, 0x2A, 0xFD, 0x27, 0x78, 0x25, 0xFA, 0x18,
  0x0D, 0x70, 0x85, 0x6B, 0xEF, 0xEB, 0x57, 0x30, 0x40, 0xDF, 0x09, 0x71, 0x06, 0xA8, 0x3D, 0x40,
  0x2D, 0xB0, 0x46, 0x05, 0xA0, 0xE0, 0x13, 0x04, 0xB0, 0x85, 0x03, 0xB0, 0x45, 0xB0, 0x65, 0x0C,
  0xA0, 0xB6, 0x81, 0xDF, 0xD5, 0x05, 0xB0, 0x36, 0x08, 0x07, 0x60, 0xDA, 0x0D, 0x77, 0x03, 0xB0,
  0x87, 0x70, 0x8B, 0x03, 0x77, 0x0C, 0xB7, 0x71, 0xB0, 0xC7, 0x70, 0x2B, 0x0A, 0x77, 0x04, 0xB0,
  0x97, 0x70, 0x4B, 0x08, 0x77, 0x03, 0xB0, 0x87, 0x70, 0x1B, 0x0A, 0x77, 0x10, 0xDA, 0x0E, 0x70,
  0x20, 0x56, 0x06, 0xB0, 0x65, 0x81, 0x2D, 0x67, 0x0C, 0xB0, 0x62, 0x82, 0x17, 0xED, 0x71, 0x01,
  0x0B, 0xF0, 0xD0, 0x27, 0x38, 0x55, 0xBE, 0xFD, 0xB6, 0x71,
  // "Ĉ" (U+0108)
  0x77, 0x06, 0x0F, 0x77, 0x73, 0x05, 0xC0, 0x27, 0x71, 0x02, 0x0E, 0xC0, 0x67, 0x71, 0x85, 0xCF,
  0xE6, 0xEF, 0xC7, 0x78, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x75, 0x82, 0x8F, 0xD2, 0x38, 0x1B, 0xFA,
  0x74, 0x82, 0x5F, 0xA1, 0x40, 0x10, 0xC9, 0x80, 0xE4, 0x08, 0x22, 0x7B, 0xDA, 0x81, 0xEB, 0x77,
  0x40, 0x20, 0xAF, 0xA0, 0xE0, 0x37, 0x10, 0x60, 0xEA, 0x0C, 0x04, 0x20, 0x20, 0xBB, 0x0D, 0x70,
  0x8B, 0x07, 0x50, 0x10, 0xEB, 0x04, 0x50, 0x8B, 0x06, 0x70, 0xAB, 0x05, 0x40, 0x6B, 0x09, 0x71,
  0x07, 0xB0, 0x23, 0x02, 0xB0, 0xD7, 0x20, 0x6A, 0x07, 0x40, 0xBB, 0x04, 0x72, 0x81, 0x26, 0x24,
  0x05, 0xB0, 0xC7, 0x73, 0x0C, 0xB0, 0x57, 0x72, 0x03, 0xB0, 0xE7, 0x73, 0x09, 0xB0, 0x97, 0x73,
  0x0E, 0xB0, 0x47, 0x72, 0x03, 0xC7, 0x73, 0x06, 0xB0, 0xC7, 0x73, 0x09, 0xB0, 0x97, 0x73, 0x0B,
  0xB0, 0x77, 0x73, 0x0C, 0xB0, 0x57, 0x73, 0x0D, 0xB0, 0x47, 0x73, 0x0D, 0xB0, 0x37, 0x73, 0x0B,
  0xB0, 0x37, 0x73, 0x0A, 0xB0, 0x47, 0x73, 0x06, 0xB0, 0x77, 0x73, 0x02, 0xB0, 0xC7, 0x40, 0x46,
  0x0A, 0xB0, 0x37, 0x20, 0x50, 0xE6, 0x01, 0x0E, 0xA0, 0xD0, 0x17, 0x81, 0x7F, 0xA7, 0x04, 0x0E,
  0xA8, 0x1E, 0x72, 0x28, 0x41, 0x4B, 0xFE, 0x27, 0x10, 0x20, 0xCF, 0xA0, 0xC0, 0x37, 0x48, 0x74,
  0x9C, 0xEF, 0xED, 0x95, 0x71,
  // "ĉ" (U+0109)
  0x74, 0x06, 0x0F, 0x77, 0x50, 0x5C, 0x02, 0x73, 0x02, 0x0E, 0xC0, 0x67, 0x38, 0x5C, 0xFE, 0x6E,
  0xFC, 0x72, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x82, 0x8F, 0xD2, 0x38, 0x1B, 0xFA, 0x68, 0x25,
  0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0C, 0x60, 0x85, 0x6B, 0xEF, 0xEB, 0x57, 0x10, 0x40, 0xDF, 0x09,
  0x60, 0x6A, 0x83, 0xD4, 0x02, 0xDB, 0x04, 0x40, 0x5A, 0x0E, 0x01, 0x30, 0x4B, 0x08, 0x30, 0x3B,
  0x04, 0x5B, 0x06, 0x30, 0xCA, 0x0B, 0x68, 0x1D, 0xFD, 0x30, 0x5B, 0x03, 0x60, 0x80, 0x74, 0x0D,
  0xA0, 0xD7, 0x50, 0x3B, 0x08, 0x75, 0x08, 0xB0, 0x37, 0x50, 0xCB, 0x76, 0xB0, 0xC7, 0x50, 0x2B,
  0x0A, 0x75, 0x04, 0xB0, 0x97, 0x50, 0x4B, 0x08, 0x75, 0x03, 0xB0, 0x87, 0x50, 0x1B, 0x0A, 0x76,
  0x0D, 0xA0, 0xE7, 0x02, 0x05, 0x40, 0x6B, 0x06, 0x58, 0x12, 0xD6, 0x50, 0xCB, 0x06, 0x28, 0x21,
  0x7E, 0xD6, 0x01, 0x0B, 0xF0, 0xD0, 0x27, 0x18, 0x55, 0xBE, 0xFD, 0xB6, 0x60,
  // "Ċ" (U+010A)
  0x77, 0x18, 0x29, 0xEC, 0x17, 0x73, 0x06, 0xB0, 0x87, 0x73, 0x09, 0xB0, 0x97, 0x73, 0x09, 0xB0,
  0x67, 0x73, 0x82, 0x2C, 0xE9, 0x80, 0x9C, 0x20, 0x82, 0x27, 0xBD, 0xA8, 0x1E, 0xB7, 0x74, 0x02,
  0x0A, 0xFA, 0x0E, 0x03, 0x71, 0x06, 0x0E, 0xA0, 0xC0, 0x42, 0x02, 0x0B, 0xB0, 0xD7, 0x08, 0xB0,
  0x75, 0x01, 0x0E, 0xB0, 0x45, 0x08, 0xB0, 0x67, 0x0A, 0xB0, 0x54, 0x06, 0xB0, 0x97, 0x10, 0x7B,
  0x02, 0x30, 0x2B, 0x0D, 0x72, 0x06, 0xA0, 0x74, 0x0B, 0xB0, 0x47, 0x28, 0x12, 0x62, 0x40, 0x5B,
  0x0C, 0x77, 0x30, 0xCB, 0x05, 0x77, 0x20, 0x3B, 0x0E, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x30, 0xEB,
  0x04, 0x77, 0x20, 0x3C, 0x77, 0x30, 0x6B, 0x0C, 0x77, 0x30, 0x9B, 0x09, 0x77, 0x30, 0xBB, 0x07,
  0x77, 0x30, 0xCB, 0x05, 0x77, 0x30, 0xDB, 0x04, 0x77, 0x30, 0xDB, 0x03, 0x77, 0x30, 0xBB, 0x03,
  0x77, 0x30, 0xAB, 0x04, 0x77, 0x30, 0x6B, 0x07, 0x77, 0x30, 0x2B, 0x0C, 0x74, 0x04, 0x60, 0xAB,
  0x03, 0x72, 0x05, 0x0E, 0x60, 0x10, 0xEA, 0x0D, 0x01, 0x78, 0x17, 0xFA, 0x70, 0x40, 0xEA, 0x81,
  0xE7, 0x22, 0x84, 0x14, 0xBF, 0xE2, 0x71, 0x02, 0x0C, 0xFA, 0x0C, 0x03, 0x74, 0x87, 0x49, 0xCE,
  0xFE, 0xD9, 0x57, 0x10,
  // "ċ" (U+010B)
  0x74, 0x82, 0x9E, 0xC1, 0x75, 0x06, 0xB0, 0x87, 0x50, 0x9B, 0x09, 0x75, 0x09, 0xB0, 0x67, 0x58,
  0x22, 0xCE, 0x98, 0x09, 0x93, 0x08, 0x56, 0xBE, 0xFE, 0xB5, 0x71, 0x04, 0x0D, 0xF0, 0x96, 0x06,
  0xA8, 0x3D, 0x40, 0x2D, 0xB0, 0x44, 0x05, 0xA0, 0xE0, 0x13, 0x04, 0xB0, 0x83, 0x03, 0xB0, 0x45,
  0xB0, 0x63, 0x0C, 0xA0, 0xB6, 0x81, 0xDF, 0xD3, 0x05, 0xB0, 0x36, 0x08, 0x07, 0x40, 0xDA, 0x0D,
  0x75, 0x03, 0xB0, 0x87, 0x50, 0x8B, 0x03, 0x75, 0x0C, 0xB7, 0x6B, 0x0C, 0x75, 0x02, 0xB0, 0xA7,
  0x50, 0x4B, 0x09, 0x75, 0x04, 0xB0, 0x87, 0x50, 0x3B, 0x08, 0x75, 0x01, 0xB0, 0xA7, 0x60, 0xDA,
  0x0E, 0x70, 0x20, 0x54, 0x06, 0xB0, 0x65, 0x81, 0x2D, 0x65, 0x0C, 0xB0, 0x62, 0x82, 0x17, 0xED,
  0x60, 0x10, 0xBF, 0x0D, 0x02, 0x71, 0x85, 0x5B, 0xEF, 0xDB, 0x66,
  // "Č" (U+010C)
  0x74, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x48, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x68, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x76, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x71, 0x82, 0xCF, 0xED,
  0xA0, 0x47, 0x72, 0x07, 0xC0, 0x77, 0x73, 0x03, 0xB0, 0xC8, 0x0F, 0x10, 0x82, 0x27, 0xBD, 0xA8,
  0x1E, 0xB7, 0x75, 0x02, 0x0A, 0xFA, 0x0E, 0x03, 0x72, 0x06, 0x0E, 0xA0, 0xC0, 0x42, 0x02, 0x0B,
  0xB0, 0xD7, 0x10, 0x8B, 0x07, 0x50, 0x10, 0xEB, 0x04, 0x60, 0x8B, 0x06, 0x70, 0xAB, 0x05, 0x50,
  0x6B, 0x09, 0x71, 0x07, 0xB0, 0x24, 0x02, 0xB0, 0xD7, 0x20, 0x6A, 0x07, 0x50, 0xBB, 0x04, 0x72,
  0x81, 0x26, 0x25, 0x05, 0xB0, 0xC7, 0x74, 0x0C, 0xB0, 0x57, 0x73, 0x03, 0xB0, 0xE7, 0x74, 0x09,
  0xB0, 0x97, 0x74, 0x0E, 0xB0, 0x47, 0x73, 0x03, 0xC7, 0x74, 0x06, 0xB0, 0xC7, 0x74, 0x09, 0xB0,
  0x97, 0x74, 0x0B, 0xB0, 0x77, 0x74, 0x0C, 0xB0, 0x57, 0x74, 0x0D, 0xB0, 0x47, 0x74, 0x0D, 0xB0,
  0x37, 0x74, 0x0B, 0xB0, 0x37, 0x74, 0x0A, 0xB0, 0x47, 0x74, 0x06, 0xB0, 0x77, 0x74, 0x02, 0xB0,
  0xC7, 0x40, 0x47, 0x0A, 0xB0, 0x37, 0x20, 0x50, 0xE7, 0x01, 0x0E, 0xA0, 0xD0, 0x17, 0x81, 0x7F,
  0xA7, 0x10, 0x40, 0xEA, 0x81, 0xE7, 0x22, 0x84, 0x14, 0xBF, 0xE2, 0x72, 0x02, 0x0C, 0xFA, 0x0C,
  0x03, 0x75, 0x87, 0x49, 0xCE, 0xFE, 0xD9, 0x57, 0x20,
  // "č" (U+010D)
  0x71, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x18, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x38, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x73, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x58, 0x2C, 0xFE, 0xDA,
  0x04, 0x76, 0x07, 0xC0, 0x77, 0x70, 0x3B, 0x0C, 0x80, 0xE1, 0x08, 0x56, 0xBE, 0xFE, 0xB5, 0x74,
  0x04, 0x0D, 0xF0, 0x97, 0x20, 0x6A, 0x83, 0xD4, 0x02, 0xDB, 0x04, 0x70, 0x5A, 0x0E, 0x01, 0x30,
  0x4B, 0x08, 0x60, 0x3B, 0x04, 0x5B, 0x06, 0x60, 0xCA, 0x0B, 0x68, 0x1D, 0xFD, 0x60, 0x5B, 0x03,
  0x60, 0x80, 0x77, 0x0D, 0xA0, 0xD7, 0x71, 0x03, 0xB0, 0x87, 0x71, 0x08, 0xB0, 0x37, 0x71, 0x0C,
  0xB7, 0x72, 0xB0, 0xC7, 0x71, 0x02, 0xB0, 0xA7, 0x71, 0x04, 0xB0, 0x97, 0x71, 0x04, 0xB0, 0x87,
  0x71, 0x03, 0xB0, 0x87, 0x71, 0x01, 0xB0, 0xA7, 0x72, 0x0D, 0xA0, 0xE7, 0x02, 0x05, 0x70, 0x6B,
  0x06, 0x58, 0x12, 0xD6, 0x71, 0x0C, 0xB0, 0x62, 0x82, 0x17, 0xED, 0x72, 0x01, 0x0B, 0xF0, 0xD0,
  0x27, 0x48, 0x55, 0xBE, 0xFD, 0xB6, 0x72,
  // "Ď" (U+010E)
  0x75, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x78, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x72, 0x81,
  0x9F, 0xC2, 0x83, 0x1C, 0xFD, 0x17, 0x72, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x74, 0x82, 0xCF,
  0xED, 0xA0, 0x47, 0x75, 0x07, 0xC0, 0x77, 0x76, 0x03, 0xB0, 0xC8, 0x0F, 0x50, 0x0C, 0xFB, 0x82,
  0xDC, 0x82, 0x74, 0x09, 0x0C, 0xD0, 0x0E, 0xE0, 0xA0, 0x17, 0x40, 0x5B, 0x0D, 0x40, 0x40, 0xBB,
  0x0D, 0x02, 0x73, 0x03, 0xB0, 0x96, 0x07, 0xB0, 0xC7, 0x30, 0x6B, 0x06, 0x70, 0xAB, 0x07, 0x72,
  0x09, 0xB0, 0x37, 0x02, 0xB0, 0xD7, 0x20, 0xCB, 0x72, 0x0C, 0xB0, 0x37, 0x1B, 0x0C, 0x72, 0x09,
  0xB0, 0x77, 0x03, 0xB0, 0x97, 0x20, 0x6B, 0x09, 0x70, 0x6B, 0x05, 0x72, 0x06, 0xB0, 0xA7, 0x09,
  0xB0, 0x27, 0x20, 0x5B, 0x0B, 0x70, 0xCA, 0x0E, 0x73, 0x06, 0xB0, 0xA7, 0xB0, 0xB7, 0x30, 0x7B,
  0x09, 0x60, 0x3B, 0x08, 0x73, 0x08, 0xB0, 0x86, 0x07, 0xB0, 0x57, 0x30, 0xAB, 0x06, 0x60, 0xAB,
  0x01, 0x73, 0x0D, 0xB0, 0x36, 0x0D, 0xA0, 0xE7, 0x30, 0x1C, 0x60, 0x1B, 0x0B, 0x73, 0x05, 0xB0,
  0xC6, 0x04, 0xB0, 0x77, 0x30, 0x9B, 0x06, 0x60, 0x7B, 0x04, 0x73, 0x0E, 0xB0, 0x16, 0x0A, 0xB0,
  0x17, 0x20, 0x6B, 0x0A, 0x70, 0xDA, 0x0D, 0x73, 0x0E, 0xB0, 0x26, 0x01, 0xB0, 0xA7, 0x20, 0x8B,
  0x08, 0x70, 0x4B, 0x07, 0x71, 0x04, 0xB0, 0xD7, 0x10, 0x7B, 0x03, 0x70, 0x4B, 0x0E, 0x02, 0x71,
  0x0C, 0xB7, 0x07, 0xB0, 0xE0, 0x37, 0x10, 0x6B, 0x0C, 0x48, 0x12, 0x7D, 0xB0, 0xC0, 0x26, 0x81,
  0x49, 0xDD, 0x0F, 0xED, 0x0E, 0x07, 0x71, 0x09, 0xFC, 0x82, 0xEC, 0x95, 0x73,
  // "ď" (U+010F)
  0x76, 0x07, 0xE0, 0x22, 0x0E, 0xA0, 0x37, 0x60, 0x9D, 0x0E, 0x20, 0x4A, 0x0A, 0x77, 0x10, 0x10,
  0x9B, 0x0B, 0x20, 0x9A, 0x02, 0x77, 0x20, 0x2B, 0x08, 0x28, 0x1E, 0xF7, 0x77, 0x30, 0x3B, 0x83,
  0x50, 0x5F, 0xC7, 0x74, 0x06, 0xB8, 0x32, 0x0A, 0xF3, 0x77, 0x40, 0x8A, 0x0E, 0x20, 0xC0, 0x67,
  0x75, 0x0B, 0xA0, 0xB7, 0x77, 0x20, 0xEA, 0x07, 0x77, 0x28, 0x55, 0xBD, 0xFD, 0x83, 0xB0, 0x47,
  0x70, 0x30, 0xDF, 0xB0, 0x17, 0x60, 0x4B, 0x83, 0xA2, 0x02, 0xBB, 0x0D, 0x76, 0x03, 0xB0, 0x75,
  0x0E, 0xA0, 0xA7, 0x50, 0x10, 0xDA, 0x0A, 0x6B, 0x07, 0x75, 0x09, 0xA0, 0xE0, 0x15, 0x04, 0xB0,
  0x47, 0x40, 0x2B, 0x08, 0x60, 0x7B, 0x01, 0x74, 0x09, 0xB0, 0x16, 0x0A, 0xA0, 0xD7, 0x40, 0x1B,
  0x0B, 0x70, 0xDA, 0x0A, 0x74, 0x06, 0xB0, 0x76, 0x01, 0xB0, 0x67, 0x40, 0xAB, 0x03, 0x60, 0x5B,
  0x03, 0x74, 0x0E, 0xA0, 0xE7, 0x08, 0xB7, 0x40, 0x2B, 0x0B, 0x70, 0xDA, 0x0C, 0x74, 0x04, 0xB0,
  0x96, 0x03, 0xB0, 0x97, 0x40, 0x5B, 0x07, 0x60, 0x9B, 0x06, 0x74, 0x06, 0xB0, 0x65, 0x01, 0xC0,
  0x47, 0x40, 0x5B, 0x06, 0x50, 0x90, 0xEB, 0x01, 0x74, 0x03, 0xB0, 0x84, 0x81, 0x4E, 0x8B, 0x76,
  0x0E, 0xA0, 0xB3, 0x82, 0x2E, 0x68, 0xB7, 0x60, 0x9B, 0x85, 0x60, 0x4E, 0xA0, 0x8B, 0x82, 0x40,
  0x6A, 0x72, 0x02, 0x0E, 0xD0, 0xA2, 0x04, 0xE0, 0x87, 0x38, 0x42, 0xBE, 0xEB, 0x54, 0x84, 0x7D,
  0xEC, 0x81, 0x72,
  // "Đ" (U+0110)
  0x60, 0xCF, 0xB8, 0x2D, 0xC8, 0x27, 0x40, 0x90, 0xCD, 0x00, 0xEE, 0x0A, 0x01, 0x74, 0x05, 0xB0,
  0xD4, 0x04, 0x0B, 0xB0, 0xD0, 0x27, 0x30, 0x3B, 0x09, 0x60, 0x7B, 0x0C, 0x73, 0x05, 0xB0, 0x67,
  0x0A, 0xB0, 0x77, 0x20, 0x9B, 0x03, 0x70, 0x2B, 0x0D, 0x72, 0x0C, 0xB7, 0x20, 0xCB, 0x03, 0x71,
  0xB0, 0xC7, 0x20, 0x9B, 0x07, 0x70, 0x3B, 0x09, 0x72, 0x06, 0xB0, 0x97, 0x06, 0xB0, 0x67, 0x20,
  0x6B, 0x0A, 0x70, 0x9B, 0x03, 0x72, 0x05, 0xB0, 0xB7, 0x0C, 0xB7, 0x30, 0x6B, 0x0A, 0x7B, 0x0C,
  0x73, 0x07, 0xB0, 0x93, 0x06, 0xFD, 0x04, 0x40, 0x8B, 0x08, 0x38, 0x19, 0xEE, 0xD8, 0x01, 0xE0,
  0x14, 0x0A, 0xB0, 0x66, 0x09, 0xB0, 0x27, 0x30, 0xDB, 0x03, 0x60, 0xDA, 0x0E, 0x73, 0x01, 0xC7,
  0xB0, 0xB7, 0x30, 0x5B, 0x0C, 0x60, 0x3B, 0x08, 0x73, 0x09, 0xB0, 0x66, 0x07, 0xB0, 0x47, 0x30,
  0xEB, 0x01, 0x60, 0xAB, 0x01, 0x72, 0x06, 0xB0, 0xA7, 0x0D, 0xA0, 0xD7, 0x30, 0xEB, 0x02, 0x60,
  0x1B, 0x0A, 0x72, 0x08, 0xB0, 0x87, 0x04, 0xB0, 0x77, 0x10, 0x4B, 0x0D, 0x71, 0x07, 0xB0, 0x47,
  0x04, 0xB0, 0xE0, 0x27, 0x10, 0xCB, 0x70, 0x7B, 0x0E, 0x03, 0x71, 0x06, 0xB0, 0xC4, 0x81, 0x27,
  0xDB, 0x0C, 0x02, 0x68, 0x14, 0x9D, 0xD0, 0xFE, 0xD0, 0xE0, 0x77, 0x10, 0x9F, 0xC8, 0x2E, 0xC9,
  0x57, 0x30,
  // "đ" (U+0111)
  0x76, 0x07, 0xE0, 0x27, 0x71, 0x0A, 0xD0, 0xE7, 0x73, 0x01, 0x09, 0xB0, 0xB7, 0x74, 0x02, 0xB0,
  0x77, 0x74, 0x04, 0xB0, 0x47, 0x50, 0x4F, 0xD0, 0x27, 0x20, 0x68, 0x01, 0xEC, 0x0F, 0xE7, 0x72,
  0x0D, 0xA0, 0xA7, 0x74, 0x01, 0xB0, 0x77, 0x48, 0x61, 0x6B, 0xEF, 0xD8, 0x5B, 0x04, 0x73, 0x04,
  0x0E, 0xFB, 0x01, 0x72, 0x07, 0xB8, 0x38, 0x10, 0x3D, 0xB0, 0xD7, 0x20, 0x6B, 0x05, 0x40, 0x3B,
  0x0A, 0x71, 0x02, 0x0E, 0xA0, 0x85, 0x03, 0xB0, 0x67, 0x10, 0xCA, 0x0D, 0x60, 0x7B, 0x03, 0x70,
  0x5B, 0x06, 0x60, 0xAB, 0x71, 0x0C, 0xA0, 0xE7, 0x0D, 0xA0, 0xC7, 0x03, 0xB0, 0x96, 0x01, 0xB0,
  0x97, 0x08, 0xB0, 0x46, 0x04, 0xB0, 0x67, 0x0C, 0xB7, 0x07, 0xB0, 0x37, 0xB0, 0xC7, 0x0B, 0xB7,
  0x03, 0xB0, 0x97, 0xB0, 0xC7, 0x05, 0xB0, 0x76, 0x05, 0xB0, 0x97, 0x06, 0xB0, 0x66, 0x0C, 0xB0,
  0x67, 0x06, 0xB0, 0x55, 0x04, 0xC0, 0x37, 0x05, 0xB0, 0x65, 0x0C, 0x0D, 0xB0, 0x17, 0x03, 0xB0,
  0x74, 0x81, 0x7E, 0x8B, 0x72, 0x0E, 0xA0, 0xB3, 0x82, 0x3F, 0x58, 0xB7, 0x20, 0x9B, 0x85, 0x50,
  0x5E, 0x90, 0x7B, 0x82, 0x40, 0x6A, 0x50, 0x20, 0xED, 0x0A, 0x20, 0x3D, 0x0E, 0x07, 0x68, 0x42,
  0xBE, 0xEB, 0x54, 0x84, 0x7D, 0xEC, 0x71, 0x50,
  // "Ē" (U+0112)
  0x74, 0x01, 0x80, 0x5E, 0x0C, 0x76, 0x05, 0xFA, 0x09, 0x80, 0xE4, 0x00, 0xCF, 0xFA, 0x0C, 0x60,
  0x90, 0xCD, 0x80, 0x1E, 0xD0, 0x97, 0x10, 0x7B, 0x0D, 0x60, 0x20, 0xCA, 0x06, 0x71, 0x04, 0xB0,
  0x97, 0x04, 0xA0, 0x37, 0x10, 0x5B, 0x06, 0x70, 0x1A, 0x72, 0x09, 0xB0, 0x37, 0x81, 0x2F, 0xD7,
  0x20, 0xCB, 0x71, 0x81, 0x4F, 0xA7, 0x2B, 0x0C, 0x72, 0x02, 0x01, 0x71, 0x03, 0xB0, 0x97, 0x75,
  0x06, 0xB0, 0x67, 0x75, 0x09, 0xB0, 0x37, 0x75, 0x0D, 0xB7, 0x76, 0xB0, 0xC7, 0x75, 0x03, 0xFC,
  0x0C, 0x74, 0x07, 0xC8, 0x03, 0xE0, 0x97, 0x40, 0xAB, 0x02, 0x77, 0x50, 0xDA, 0x0E, 0x77, 0x50,
  0x1B, 0x0B, 0x77, 0x50, 0x4B, 0x08, 0x77, 0x50, 0x7B, 0x04, 0x77, 0x50, 0xBB, 0x01, 0x77, 0x50,
  0xEA, 0x0D, 0x77, 0x50, 0x1B, 0x0A, 0x72, 0x81, 0x6F, 0x77, 0x05, 0xB0, 0x77, 0x28, 0x1B, 0xF4,
  0x70, 0x8B, 0x04, 0x71, 0x02, 0xA7, 0x10, 0xCB, 0x72, 0x81, 0xCF, 0xC7, 0x07, 0xB0, 0xC7, 0x03,
  0x0B, 0xA0, 0x84, 0x81, 0x4A, 0xDD, 0x80, 0x2E, 0xD0, 0x44, 0x09, 0xFF, 0xC0, 0x14,
  // "ē" (U+0113)
  0x60, 0x18, 0x05, 0xE0, 0xC6, 0x05, 0xFA, 0x09, 0x80, 0xC6, 0x08, 0x56, 0xBE, 0xFE, 0xA3, 0x71,
  0x04, 0x0D, 0xF0, 0x46, 0x06, 0xA8, 0x3C, 0x30, 0x3E, 0xA0, 0xD5, 0x05, 0xA0, 0xD0, 0x13, 0x0A,
  0xB0, 0x13, 0x03, 0xB0, 0x24, 0x09, 0xB0, 0x13, 0x0C, 0xA0, 0xA5, 0x0B, 0xA0, 0xE3, 0x05, 0xB0,
  0x24, 0x01, 0xB0, 0xA3, 0x0D, 0xA0, 0xA5, 0x0A, 0xB0, 0x22, 0x03, 0xB0, 0x53, 0x01, 0x0A, 0xB0,
  0x53, 0x08, 0xB8, 0x31, 0x03, 0x8E, 0xA0, 0xE0, 0x54, 0x0C, 0xFA, 0x0A, 0x01, 0x5E, 0x82, 0xEB,
  0x72, 0x60, 0x2B, 0x09, 0x75, 0x04, 0xB0, 0x77, 0x50, 0x4B, 0x07, 0x75, 0x03, 0xB0, 0x87, 0x50,
  0x1B, 0x0A, 0x76, 0x0C, 0xA0, 0xE7, 0x01, 0x05, 0x40, 0x6B, 0x06, 0x58, 0x12, 0xD7, 0x50, 0xBB,
  0x06, 0x28, 0x32, 0x8E, 0xE1, 0x50, 0x10, 0xBF, 0x0E, 0x04, 0x71, 0x86, 0x5B, 0xDF, 0xEC, 0x71,
  0x50,
  // "Ĕ" (U+0114)
  0x74, 0x81, 0x37, 0x25, 0x81, 0x17, 0x47, 0x68, 0x15, 0xF8, 0x58, 0x19, 0xF4, 0x76, 0x82, 0x2F,
  0xE4, 0x28, 0x21, 0x9F, 0xD7, 0x71, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x77, 0x10, 0x5E, 0x07, 0x77,
  0x38, 0x45, 0xCF, 0xEB, 0x48, 0x0E, 0x70, 0x0C, 0xFF, 0xA0, 0xC6, 0x09, 0x0C, 0xD8, 0x01, 0xED,
  0x09, 0x71, 0x07, 0xB0, 0xD6, 0x02, 0x0C, 0xA0, 0x67, 0x10, 0x4B, 0x09, 0x70, 0x4A, 0x03, 0x71,
  0x05, 0xB0, 0x67, 0x01, 0xA7, 0x20, 0x9B, 0x03, 0x78, 0x12, 0xFD, 0x72, 0x0C, 0xB7, 0x18, 0x14,
  0xFA, 0x72, 0xB0, 0xC7, 0x20, 0x20, 0x17, 0x10, 0x3B, 0x09, 0x77, 0x50, 0x6B, 0x06, 0x77, 0x50,
  0x9B, 0x03, 0x77, 0x50, 0xDB, 0x77, 0x6B, 0x0C, 0x77, 0x50, 0x3F, 0xC0, 0xC7, 0x40, 0x7C, 0x80,
  0x3E, 0x09, 0x74, 0x0A, 0xB0, 0x27, 0x75, 0x0D, 0xA0, 0xE7, 0x75, 0x01, 0xB0, 0xB7, 0x75, 0x04,
  0xB0, 0x87, 0x75, 0x07, 0xB0, 0x47, 0x75, 0x0B, 0xB0, 0x17, 0x75, 0x0E, 0xA0, 0xD7, 0x75, 0x01,
  0xB0, 0xA7, 0x28, 0x16, 0xF7, 0x70, 0x5B, 0x07, 0x72, 0x81, 0xBF, 0x47, 0x08, 0xB0, 0x47, 0x10,
  0x2A, 0x71, 0x0C, 0xB7, 0x28, 0x1C, 0xFC, 0x70, 0x7B, 0x0C, 0x70, 0x30, 0xBA, 0x08, 0x48, 0x14,
  0xAD, 0xD8, 0x02, 0xED, 0x04, 0x40, 0x9F, 0xFC, 0x01, 0x40,
  // "ĕ" (U+0115)
  0x78, 0x13, 0x72, 0x58, 0x11, 0x74, 0x78, 0x15, 0xF8, 0x58, 0x19, 0xF4, 0x78, 0x22, 0xFE, 0x42,
  0x82, 0x19, 0xFD, 0x72, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x72, 0x05, 0xE0, 0x77, 0x48, 0x45, 0xCF,
  0xEB, 0x48, 0x0D, 0x30, 0x85, 0x6B, 0xEF, 0xEA, 0x37, 0x20, 0x40, 0xDF, 0x04, 0x70, 0x6A, 0x83,
  0xC3, 0x03, 0xEA, 0x0D, 0x60, 0x5A, 0x0D, 0x01, 0x30, 0xAB, 0x01, 0x40, 0x3B, 0x02, 0x40, 0x9B,
  0x01, 0x40, 0xCA, 0x0A, 0x50, 0xBA, 0x0E, 0x40, 0x5B, 0x02, 0x40, 0x1B, 0x0A, 0x40, 0xDA, 0x0A,
  0x50, 0xAB, 0x02, 0x30, 0x3B, 0x05, 0x30, 0x10, 0xAB, 0x05, 0x40, 0x8B, 0x83, 0x10, 0x38, 0xEA,
  0x0E, 0x05, 0x50, 0xCF, 0xA0, 0xA0, 0x16, 0xE8, 0x2E, 0xB7, 0x27, 0x02, 0xB0, 0x97, 0x60, 0x4B,
  0x07, 0x76, 0x04, 0xB0, 0x77, 0x60, 0x3B, 0x08, 0x76, 0x01, 0xB0, 0xA7, 0x70, 0xCA, 0x0E, 0x70,
  0x10, 0x55, 0x06, 0xB0, 0x65, 0x81, 0x2D, 0x76, 0x0B, 0xB0, 0x62, 0x83, 0x28, 0xEE, 0x16, 0x01,
  0x0B, 0xF0, 0xE0, 0x47, 0x28, 0x65, 0xBD, 0xFE, 0xC7, 0x16,
  // "Ė" (U+0116)
  0x77, 0x18, 0x29, 0xEC, 0x17, 0x75, 0x06, 0xB0, 0x87, 0x75, 0x09, 0xB0, 0x97, 0x75, 0x09, 0xB0,
  0x67, 0x75, 0x82, 0x2C, 0xE9, 0x80, 0x9A, 0x00, 0x0C, 0xFF, 0xA0, 0xC6, 0x09, 0x0C, 0xD8, 0x01,
  0xED, 0x09, 0x71, 0x07, 0xB0, 0xD6, 0x02, 0x0C, 0xA0, 0x67, 0x10, 0x4B, 0x09, 0x70, 0x4A, 0x03,
  0x71, 0x05, 0xB0, 0x67, 0x01, 0xA7, 0x20, 0x9B, 0x03, 0x78, 0x12, 0xFD, 0x72, 0x0C, 0xB7, 0x18,
  0x14, 0xFA, 0x72, 0xB0, 0xC7, 0x20, 0x20, 0x17, 0x10, 0x3B, 0x09, 0x77, 0x50, 0x6B, 0x06, 0x77,
  0x50, 0x9B, 0x03, 0x77, 0x50, 0xDB, 0x77, 0x6B, 0x0C, 0x77, 0x50, 0x3F, 0xC0, 0xC7, 0x40, 0x7C,
  0x80, 0x3E, 0x09, 0x74, 0x0A, 0xB0, 0x27, 0x75, 0x0D, 0xA0, 0xE7, 0x75, 0x01, 0xB0, 0xB7, 0x75,
  0x04, 0xB0, 0x87, 0x75, 0x07, 0xB0, 0x47, 0x75, 0x0B, 0xB0, 0x17, 0x75, 0x0E, 0xA0, 0xD7, 0x75,
  0x01, 0xB0, 0xA7, 0x28, 0x16, 0xF7, 0x70, 0x5B, 0x07, 0x72, 0x81, 0xBF, 0x47, 0x08, 0xB0, 0x47,
  0x10, 0x2A, 0x71, 0x0C, 0xB7, 0x28, 0x1C, 0xFC, 0x70, 0x7B, 0x0C, 0x70, 0x30, 0xBA, 0x08, 0x48,
  0x14, 0xAD, 0xD8, 0x02, 0xED, 0x04, 0x40, 0x9F, 0xFC, 0x01, 0x40,
  // "ė" (U+0117)
  0x74, 0x82, 0x9E, 0xC1, 0x75, 0x06, 0xB0, 0x87, 0x50, 0x9B, 0x09, 0x75, 0x09, 0xB0, 0x67, 0x58,
  0x22, 0xCE, 0x98, 0x09, 0x93, 0x08, 0x56, 0xBE, 0xFE, 0xA3, 0x71, 0x04, 0x0D, 0xF0, 0x46, 0x06,
  0xA8, 0x3C, 0x30, 0x3E, 0xA0, 0xD5, 0x05, 0xA0, 0xD0, 0x13, 0x0A, 0xB0, 0x13, 0x03, 0xB0, 0x24,
  0x09, 0xB0, 0x13, 0x0C, 0xA0, 0xA5, 0x0B, 0xA0, 0xE3, 0x05, 0xB0, 0x24, 0x01, 0xB0, 0xA3, 0x0D,
  0xA0, 0xA5, 0x0A, 0xB0, 0x22, 0x03, 0xB0, 0x53, 0x01, 0x0A, 0xB0, 0x53, 0x08, 0xB8, 0x31, 0x03,
  0x8E, 0xA0, 0xE0, 0x54, 0x0C, 0xFA, 0x0A, 0x01, 0x5E, 0x82, 0xEB, 0x72, 0x60, 0x2B, 0x09, 0x75,
  0x04, 0xB0, 0x77, 0x50, 0x4B, 0x07, 0x75, 0x03, 0xB0, 0x87, 0x50, 0x1B, 0x0A, 0x76, 0x0C, 0xA0,
  0xE7, 0x01, 0x05, 0x40, 0x6B, 0x06, 0x58, 0x12, 0xD7, 0x50, 0xBB, 0x06, 0x28, 0x32, 0x8E, 0xE1,
  0x50, 0x10, 0xBF, 0x0E, 0x04, 0x71, 0x86, 0x5B, 0xDF, 0xEC, 0x71, 0x50,
  // "Ę" (U+0118)
  0x60, 0xCF, 0xFA, 0x0C, 0x60, 0x90, 0xCD, 0x80, 0x1E, 0xD0, 0x97, 0x10, 0x7B, 0x0D, 0x60, 0x20,
  0xCA, 0x06, 0x71, 0x04, 0xB0, 0x97, 0x04, 0xA0, 0x37, 0x10, 0x5B, 0x06, 0x70, 0x1A, 0x72, 0x09,
  0xB0, 0x37, 0x81, 0x2F, 0xD7, 0x20, 0xCB, 0x71, 0x81, 0x4F, 0xA7, 0x2B, 0x0C, 0x72, 0x02, 0x01,
  0x71, 0x03, 0xB0, 0x97, 0x75, 0x06, 0xB0, 0x67, 0x75, 0x09, 0xB0, 0x37, 0x75, 0x0D, 0xB7, 0x76,
  0xB0, 0xC7, 0x75, 0x03, 0xFC, 0x0C, 0x74, 0x07, 0xC8, 0x03, 0xE0, 0x97, 0x40, 0xAB, 0x02, 0x77,
  0x50, 0xDA, 0x0E, 0x77, 0x50, 0x1B, 0x0B, 0x77, 0x50, 0x4B, 0x08, 0x77, 0x50, 0x7B, 0x04, 0x77,
  0x50, 0xBB, 0x01, 0x77, 0x50, 0xEA, 0x0D, 0x77, 0x50, 0x1B, 0x0A, 0x72, 0x81, 0x6F, 0x77, 0x05,
  0xB0, 0x77, 0x28, 0x1B, 0xF4, 0x70, 0x8B, 0x04, 0x71, 0x02, 0xA7, 0x10, 0xCB, 0x72, 0x81, 0xCF,
  0xC7, 0x07, 0xB0, 0xC7, 0x03, 0x0B, 0xA0, 0x84, 0x81, 0x4A, 0xDD, 0x80, 0x2E, 0xD0, 0x44, 0x09,
  0xFF, 0xC0, 0x17, 0x74, 0x81, 0x17, 0x67, 0x75, 0x82, 0x1A, 0xF9, 0x77, 0x58, 0x23, 0xDF, 0x77,
  0x75, 0x82, 0x1E, 0xFC, 0x77, 0x60, 0x8A, 0x06, 0x77, 0x60, 0xBA, 0x04, 0x77, 0x60, 0xBA, 0x06,
  0x77, 0x60, 0x9A, 0x83, 0xE7, 0x58, 0x37, 0x72, 0x02, 0xE0, 0x27, 0x73, 0x84, 0x2A, 0xEE, 0xC7,
  0x70,
  // "ę" (U+0119)
  0x71, 0x85, 0x6B, 0xEF, 0xEA, 0x37, 0x10, 0x40, 0xDF, 0x04, 0x60, 0x6A, 0x83, 0xC3, 0x03, 0xEA,
  0x0D, 0x50, 0x5A, 0x0D, 0x01, 0x30, 0xAB, 0x01, 0x30, 0x3B, 0x02, 0x40, 0x9B, 0x01, 0x30, 0xCA,
  0x0A, 0x50, 0xBA, 0x0E, 0x30, 0x5B, 0x02, 0x40, 0x1B, 0x0A, 0x30, 0xDA, 0x0A, 0x50, 0xAB, 0x02,
  0x20, 0x3B, 0x05, 0x30, 0x10, 0xAB, 0x05, 0x30, 0x8B, 0x83, 0x10, 0x38, 0xEA, 0x0E, 0x05, 0x40,
  0xCF, 0xA0, 0xA0, 0x15, 0xE8, 0x2E, 0xB7, 0x26, 0x02, 0xB0, 0x97, 0x50, 0x4B, 0x07, 0x75, 0x04,
  0xB0, 0x77, 0x50, 0x3B, 0x08, 0x75, 0x01, 0xB0, 0xA7, 0x60, 0xCA, 0x0E, 0x70, 0x10, 0x54, 0x06,
  0xB0, 0x65, 0x81, 0x2D, 0x75, 0x0B, 0xB0, 0x62, 0x83, 0x28, 0xEE, 0x15, 0x01, 0x0B, 0xF0, 0xE0,
  0x47, 0x18, 0x15, 0xBD, 0xB0, 0xE0, 0x27, 0x48, 0x21, 0xAF, 0x97, 0x58, 0x23, 0xDF, 0x77, 0x58,
  0x21, 0xEF, 0xC7, 0x60, 0x8A, 0x06, 0x76, 0x0B, 0xA0, 0x47, 0x60, 0xBA, 0x06, 0x76, 0x09, 0xA8,
  0x3E, 0x75, 0x83, 0x72, 0x02, 0xE0, 0x27, 0x38, 0x42, 0xAE, 0xEC, 0x76,
  // "Ě" (U+011A)
  0x75, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x58, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x78, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x77, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x72, 0x82, 0xCF, 0xED,
  0xA0, 0x47, 0x73, 0x07, 0xC0, 0x77, 0x74, 0x03, 0xB0, 0xC8, 0x0E, 0x70, 0x0C, 0xFF, 0xA0, 0xC6,
  0x09, 0x0C, 0xD8, 0x01, 0xED, 0x09, 0x71, 0x07, 0xB0, 0xD6, 0x02, 0x0C, 0xA0, 0x67, 0x10, 0x4B,
  0x09, 0x70, 0x4A, 0x03, 0x71, 0x05, 0xB0, 0x67, 0x01, 0xA7, 0x20, 0x9B, 0x03, 0x78, 0x12, 0xFD,
  0x72, 0x0C, 0xB7, 0x18, 0x14, 0xFA, 0x72, 0xB0, 0xC7, 0x20, 0x20, 0x17, 0x10, 0x3B, 0x09, 0x77,
  0x50, 0x6B, 0x06, 0x77, 0x50, 0x9B, 0x03, 0x77, 0x50, 0xDB, 0x77, 0x6B, 0x0C, 0x77, 0x50, 0x3F,
  0xC0, 0xC7, 0x40, 0x7C, 0x80, 0x3E, 0x09, 0x74, 0x0A, 0xB0, 0x27, 0x75, 0x0D, 0xA0, 0xE7, 0x75,
  0x01, 0xB0, 0xB7, 0x75, 0x04, 0xB0, 0x87, 0x75, 0x07, 0xB0, 0x47, 0x75, 0x0B, 0xB0, 0x17, 0x75,
  0x0E, 0xA0, 0xD7, 0x75, 0x01, 0xB0, 0xA7, 0x28, 0x16, 0xF7, 0x70, 0x5B, 0x07, 0x72, 0x81, 0xBF,
  0x47, 0x08, 0xB0, 0x47, 0x10, 0x2A, 0x71, 0x0C, 0xB7, 0x28, 0x1C, 0xFC, 0x70, 0x7B, 0x0C, 0x70,
  0x30, 0xBA, 0x08, 0x48, 0x14, 0xAD, 0xD8, 0x02, 0xED, 0x04, 0x40, 0x9F, 0xFC, 0x01, 0x40,
  // "ě" (U+011B)
  0x71, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x18, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x38, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x73, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x58, 0x2C, 0xFE, 0xDA,
  0x04, 0x76, 0x07, 0xC0, 0x77, 0x70, 0x3B, 0x0C, 0x80, 0xE1, 0x08, 0x56, 0xBE, 0xFE, 0xA3, 0x74,
  0x04, 0x0D, 0xF0, 0x47, 0x20, 0x6A, 0x83, 0xC3, 0x03, 0xEA, 0x0D, 0x71, 0x05, 0xA0, 0xD0, 0x13,
  0x0A, 0xB0, 0x16, 0x03, 0xB0, 0x24, 0x09, 0xB0, 0x16, 0x0C, 0xA0, 0xA5, 0x0B, 0xA0, 0xE6, 0x05,
  0xB0, 0x24, 0x01, 0xB0, 0xA6, 0x0D, 0xA0, 0xA5, 0x0A, 0xB0, 0x25, 0x03, 0xB0, 0x53, 0x01, 0x0A,
  0xB0, 0x56, 0x08, 0xB8, 0x31, 0x03, 0x8E, 0xA0, 0xE0, 0x57, 0x0C, 0xFA, 0x0A, 0x01, 0x71, 0xE8,
  0x2E, 0xB7, 0x27, 0x20, 0x2B, 0x09, 0x77, 0x10, 0x4B, 0x07, 0x77, 0x10, 0x4B, 0x07, 0x77, 0x10,
  0x3B, 0x08, 0x77, 0x10, 0x1B, 0x0A, 0x77, 0x20, 0xCA, 0x0E, 0x70, 0x10, 0x57, 0x06, 0xB0, 0x65,
  0x81, 0x2D, 0x77, 0x10, 0xBB, 0x06, 0x28, 0x32, 0x8E, 0xE1, 0x71, 0x01, 0x0B, 0xF0, 0xE0, 0x47,
  0x48, 0x65, 0xBD, 0xFE, 0xC7, 0x17, 0x10,
  // "Ĝ" (U+011C)
  0x77, 0x10, 0x60, 0xF7, 0x77, 0x40, 0x5C, 0x02, 0x77, 0x20, 0x20, 0xEC, 0x06, 0x77, 0x28, 0x5C,
  0xFE, 0x6E, 0xFC, 0x77, 0x18, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x76, 0x82, 0x8F, 0xD2, 0x38, 0x1B,
  0xFA, 0x75, 0x82, 0x5F, 0xA1, 0x40, 0x10, 0xC9, 0x80, 0xE7, 0x08, 0x90, 0x59, 0xCE, 0xFE, 0xDB,
  0x82, 0x73, 0x81, 0x18, 0xEF, 0xB0, 0x87, 0x10, 0x50, 0xEA, 0x81, 0xD6, 0x12, 0x03, 0x0B, 0xC0,
  0x76, 0x08, 0xB0, 0x97, 0x0C, 0xB0, 0xD5, 0x09, 0xB0, 0x87, 0x10, 0x4B, 0x0D, 0x40, 0x7B, 0x09,
  0x73, 0xB0, 0x73, 0x02, 0xB0, 0xD7, 0x48, 0x1E, 0xC6, 0x40, 0xCB, 0x04, 0x77, 0x30, 0x6B, 0x0B,
  0x77, 0x40, 0xDB, 0x04, 0x77, 0x30, 0x4B, 0x0D, 0x77, 0x40, 0xAB, 0x08, 0x77, 0x40, 0xEB, 0x03,
  0x77, 0x30, 0x4B, 0x0E, 0x77, 0x40, 0x7B, 0x0B, 0x77, 0x40, 0x9B, 0x08, 0x71, 0x0C, 0x80, 0x4E,
  0x0A, 0x0B, 0xB0, 0x67, 0x1F, 0xA0, 0x80, 0xCB, 0x05, 0x72, 0x02, 0x0C, 0xC8, 0x28, 0x10, 0xDB,
  0x04, 0x73, 0x06, 0xB0, 0xA3, 0x0D, 0xB0, 0x37, 0x30, 0x7B, 0x05, 0x30, 0xBB, 0x03, 0x73, 0x0A,
  0xB0, 0x13, 0x09, 0xB0, 0x57, 0x30, 0xDA, 0x0E, 0x40, 0x6B, 0x08, 0x72, 0x01, 0xB0, 0xA4, 0x01,
  0xB0, 0xD7, 0x20, 0x4B, 0x07, 0x50, 0xAB, 0x04, 0x71, 0x07, 0xB0, 0x45, 0x01, 0x0E, 0xA0, 0xE0,
  0x27, 0x0B, 0xB0, 0x16, 0x03, 0x0E, 0xA8, 0x1E, 0x72, 0x28, 0x11, 0x5B, 0xB0, 0xD7, 0x10, 0x20,
  0xCF, 0xC0, 0xA0, 0x37, 0x38, 0x91, 0x48, 0xCE, 0xFE, 0xEC, 0x95, 0x17,
  // "ĝ" (U+011D)
  0x76, 0x06, 0x0F, 0x77, 0x75, 0x05, 0xC0, 0x27, 0x73, 0x02, 0x0E, 0xC0, 0x67, 0x73, 0x85, 0xCF,
  0xE6, 0xEF, 0xC7, 0x72, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x78, 0x28, 0xFD, 0x23, 0x81, 0xBF,
  0xA7, 0x68, 0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0D, 0x40, 0x82, 0x2B, 0xEC, 0x74, 0x89, 0x01,
  0x7C, 0xEE, 0xC5, 0x02, 0xEB, 0x04, 0x72, 0x04, 0x0E, 0xE8, 0x28, 0xDF, 0xEA, 0x02, 0x71, 0x05,
  0xA8, 0x3D, 0x40, 0x2C, 0xA0, 0xC2, 0x0B, 0x07, 0x71, 0x02, 0xA0, 0xE0, 0x23, 0x05, 0xA0, 0xE7,
  0x50, 0xBA, 0x07, 0x40, 0x2B, 0x02, 0x73, 0x03, 0xB0, 0x14, 0x01, 0xB0, 0x47, 0x30, 0x9A, 0x0B,
  0x50, 0x2B, 0x02, 0x73, 0x0D, 0xA0, 0x75, 0x05, 0xB7, 0x4B, 0x04, 0x50, 0x8A, 0x0B, 0x73, 0x01,
  0xB0, 0x35, 0x0D, 0xA0, 0x67, 0x4B, 0x04, 0x40, 0x5A, 0x0E, 0x75, 0x0D, 0xA0, 0x73, 0x01, 0x0D,
  0xA0, 0x57, 0x50, 0x7A, 0x83, 0xE4, 0x03, 0xCA, 0x08, 0x77, 0x0B, 0xF0, 0x77, 0x71, 0x04, 0xA8,
  0x3E, 0xEC, 0x82, 0x77, 0x18, 0x29, 0xFB, 0x17, 0x75, 0x81, 0x9F, 0xB7, 0x76, 0x01, 0xA0, 0x77,
  0x76, 0x03, 0xA8, 0x3E, 0x85, 0x32, 0x77, 0x20, 0x1F, 0x98, 0x1D, 0x81, 0x76, 0x06, 0xFA, 0x0E,
  0x05, 0x74, 0x05, 0x0B, 0xFC, 0x01, 0x71, 0x89, 0x22, 0xCF, 0xD5, 0x10, 0x12, 0x47, 0xEB, 0x07,
  0x78, 0x22, 0xEF, 0xB7, 0x10, 0x10, 0xEA, 0x0A, 0x78, 0x2C, 0xFE, 0x17, 0x20, 0x9A, 0x0A, 0x60,
  0x4A, 0x0A, 0x73, 0x08, 0xA0, 0x96, 0x06, 0xA0, 0x97, 0x30, 0xBA, 0x05, 0x60, 0x6A, 0x0A, 0x72,
  0x02, 0xA0, 0xE7, 0x03, 0xB0, 0x27, 0x01, 0x0D, 0xA0, 0x57, 0x10, 0xBA, 0x81, 0xD5, 0x13, 0x81,
  0x38, 0xEA, 0x07, 0x73, 0x0B, 0xFB, 0x0D, 0x04, 0x75, 0x82, 0x49, 0xCE, 0xA8, 0x2E, 0xC9, 0x47,
  0x40,
  // "Ğ" (U+011E)
  0x73, 0x81, 0x37, 0x25, 0x81, 0x17, 0x47, 0x58, 0x15, 0xF8, 0x58, 0x19, 0xF4, 0x75, 0x82, 0x2F,
  0xE4, 0x28, 0x21, 0x9F, 0xD7, 0x70, 0xDA, 0x0E, 0x0D, 0xB0, 0x47, 0x70, 0x5E, 0x07, 0x77, 0x28,
  0x45, 0xCF, 0xEB, 0x48, 0x0F, 0x20, 0x89, 0x05, 0x9C, 0xEF, 0xED, 0xB8, 0x27, 0x38, 0x11, 0x8E,
  0xFB, 0x08, 0x71, 0x05, 0x0E, 0xA8, 0x1D, 0x61, 0x20, 0x30, 0xBC, 0x07, 0x60, 0x8B, 0x09, 0x70,
  0xCB, 0x0D, 0x50, 0x9B, 0x08, 0x71, 0x04, 0xB0, 0xD4, 0x07, 0xB0, 0x97, 0x3B, 0x07, 0x30, 0x2B,
  0x0D, 0x74, 0x81, 0xEC, 0x64, 0x0C, 0xB0, 0x47, 0x73, 0x06, 0xB0, 0xB7, 0x74, 0x0D, 0xB0, 0x47,
  0x73, 0x04, 0xB0, 0xD7, 0x74, 0x0A, 0xB0, 0x87, 0x74, 0x0E, 0xB0, 0x37, 0x73, 0x04, 0xB0, 0xE7,
  0x74, 0x07, 0xB0, 0xB7, 0x74, 0x09, 0xB0, 0x87, 0x10, 0xC8, 0x04, 0xE0, 0xA0, 0xBB, 0x06, 0x71,
  0xFA, 0x08, 0x0C, 0xB0, 0x57, 0x20, 0x20, 0xCC, 0x82, 0x81, 0x0D, 0xB0, 0x47, 0x30, 0x6B, 0x0A,
  0x30, 0xDB, 0x03, 0x73, 0x07, 0xB0, 0x53, 0x0B, 0xB0, 0x37, 0x30, 0xAB, 0x01, 0x30, 0x9B, 0x05,
  0x73, 0x0D, 0xA0, 0xE4, 0x06, 0xB0, 0x87, 0x20, 0x1B, 0x0A, 0x40, 0x1B, 0x0D, 0x72, 0x04, 0xB0,
  0x75, 0x0A, 0xB0, 0x47, 0x10, 0x7B, 0x04, 0x50, 0x10, 0xEA, 0x0E, 0x02, 0x70, 0xBB, 0x01, 0x60,
  0x30, 0xEA, 0x81, 0xE7, 0x22, 0x81, 0x15, 0xBB, 0x0D, 0x71, 0x02, 0x0C, 0xFC, 0x0A, 0x03, 0x73,
  0x89, 0x14, 0x8C, 0xEF, 0xEE, 0xC9, 0x51, 0x70,
  // "ğ" (U+011F)
  0x73, 0x81, 0x37, 0x25, 0x81, 0x17, 0x47, 0x68, 0x15, 0xF8, 0x58, 0x19, 0xF4, 0x76, 0x82, 0x2F,
  0xE4, 0x28, 0x21, 0x9F, 0xD7, 0x71, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x77, 0x10, 0x5E, 0x07, 0x77,
  0x38, 0x45, 0xCF, 0xEB, 0x48, 0x0D, 0x50, 0x82, 0x2B, 0xEC, 0x74, 0x89, 0x01, 0x7C, 0xEE, 0xC5,
  0x02, 0xEB, 0x04, 0x72, 0x04, 0x0E, 0xE8, 0x28, 0xDF, 0xEA, 0x02, 0x71, 0x05, 0xA8, 0x3D, 0x40,
  0x2C, 0xA0, 0xC2, 0x0B, 0x07, 0x71, 0x02, 0xA0, 0xE0, 0x23, 0x05, 0xA0, 0xE7, 0x50, 0xBA, 0x07,
  0x40, 0x2B, 0x02, 0x73, 0x03, 0xB0, 0x14, 0x01, 0xB0, 0x47, 0x30, 0x9A, 0x0B, 0x50, 0x2B, 0x02,
  0x73, 0x0D, 0xA0, 0x75, 0x05, 0xB7, 0x4B, 0x04, 0x50, 0x8A, 0x0B, 0x73, 0x01, 0xB0, 0x35, 0x0D,
  0xA0, 0x67, 0x4B, 0x04, 0x40, 0x5A, 0x0E, 0x75, 0x0D, 0xA0, 0x73, 0x01, 0x0D, 0xA0, 0x57, 0x50,
  0x7A, 0x83, 0xE4, 0x03, 0xCA, 0x08, 0x77, 0x0B, 0xF0, 0x77, 0x71, 0x04, 0xA8, 0x3E, 0xEC, 0x82,
  0x77, 0x18, 0x29, 0xFB, 0x17, 0x75, 0x81, 0x9F, 0xB7, 0x76, 0x01, 0xA0, 0x77, 0x76, 0x03, 0xA8,
  0x3E, 0x85, 0x32, 0x77, 0x20, 0x1F, 0x98, 0x1D, 0x81, 0x76, 0x06, 0xFA, 0x0E, 0x05, 0x74, 0x05,
  0x0B, 0xFC, 0x01, 0x71, 0x89, 0x22, 0xCF, 0xD5, 0x10, 0x12, 0x47, 0xEB, 0x07, 0x78, 0x22, 0xEF,
  0xB7, 0x10, 0x10, 0xEA, 0x0A, 0x78, 0x2C, 0xFE, 0x17, 0x20, 0x9A, 0x0A, 0x60, 0x4A, 0x0A, 0x73,
  0x08, 0xA0, 0x96, 0x06, 0xA0, 0x97, 0x30, 0xBA, 0x05, 0x60, 0x6A, 0x0A, 0x72, 0x02, 0xA0, 0xE7,
  0x03, 0xB0, 0x27, 0x01, 0x0D, 0xA0, 0x57, 0x10, 0xBA, 0x81, 0xD5, 0x13, 0x81, 0x38, 0xEA, 0x07,
  0x73, 0x0B, 0xFB, 0x0D, 0x04, 0x75, 0x82, 0x49, 0xCE, 0xA8, 0x2E, 0xC9, 0x47, 0x40,
  // "Ġ" (U+0120)
  0x77, 0x18, 0x29, 0xEC, 0x17, 0x74, 0x06, 0xB0, 0x87, 0x74, 0x09, 0xB0, 0x97, 0x74, 0x09, 0xB0,
  0x67, 0x74, 0x82, 0x2C, 0xE9, 0x80, 0x9D, 0x00, 0x89, 0x05, 0x9C, 0xEF, 0xED, 0xB8, 0x27, 0x38,
  0x11, 0x8E, 0xFB, 0x08, 0x71, 0x05, 0x0E, 0xA8, 0x1D, 0x61, 0x20, 0x30, 0xBC, 0x07, 0x60, 0x8B,
  0x09, 0x70, 0xCB, 0x0D, 0x50, 0x9B, 0x08, 0x71, 0x04, 0xB0, 0xD4, 0x07, 0xB0, 0x97, 0x3B, 0x07,
  0x30, 0x2B, 0x0D, 0x74, 0x81, 0xEC, 0x64, 0x0C, 0xB0, 0x47, 0x73, 0x06, 0xB0, 0xB7, 0x74, 0x0D,
  0xB0, 0x47, 0x73, 0x04, 0xB0, 0xD7, 0x74, 0x0A, 0xB0, 0x87, 0x74, 0x0E, 0xB0, 0x37, 0x73, 0x04,
  0xB0, 0xE7, 0x74, 0x07, 0xB0, 0xB7, 0x74, 0x09, 0xB0, 0x87, 0x10, 0xC8, 0x04, 0xE0, 0xA0, 0xBB,
  0x06, 0x71, 0xFA, 0x08, 0x0C, 0xB0, 0x57, 0x20, 0x20, 0xCC, 0x82, 0x81, 0x0D, 0xB0, 0x47, 0x30,
  0x6B, 0x0A, 0x30, 0xDB, 0x03, 0x73, 0x07, 0xB0, 0x53, 0x0B, 0xB0, 0x37, 0x30, 0xAB, 0x01, 0x30,
  0x9B, 0x05, 0x73, 0x0D, 0xA0, 0xE4, 0x06, 0xB0, 0x87, 0x20, 0x1B, 0x0A, 0x40, 0x1B, 0x0D, 0x72,
  0x04, 0xB0, 0x75, 0x0A, 0xB0, 0x47, 0x10, 0x7B, 0x04, 0x50, 0x10, 0xEA, 0x0E, 0x02, 0x70, 0xBB,
  0x01, 0x60, 0x30, 0xEA, 0x81, 0xE7, 0x22, 0x81, 0x15, 0xBB, 0x0D, 0x71, 0x02, 0x0C, 0xFC, 0x0A,
  0x03, 0x73, 0x89, 0x14, 0x8C, 0xEF, 0xEE, 0xC9, 0x51, 0x70,
  // "ġ" (U+0121)
  0x77, 0x82, 0x9E, 0xC1, 0x77, 0x50, 0x6B, 0x08, 0x77, 0x50, 0x9B, 0x09, 0x77, 0x50, 0x9B, 0x06,
  0x77, 0x58, 0x22, 0xCE, 0x98, 0x09, 0xB6, 0x08, 0x22, 0xBE, 0xC7, 0x48, 0x90, 0x17, 0xCE, 0xEC,
  0x50, 0x2E, 0xB0, 0x47, 0x20, 0x40, 0xEE, 0x82, 0x8D, 0xFE, 0xA0, 0x27, 0x10, 0x5A, 0x83, 0xD4,
  0x02, 0xCA, 0x0C, 0x20, 0xB0, 0x77, 0x10, 0x2A, 0x0E, 0x02, 0x30, 0x5A, 0x0E, 0x75, 0x0B, 0xA0,
  0x74, 0x02, 0xB0, 0x27, 0x30, 0x3B, 0x01, 0x40, 0x1B, 0x04, 0x73, 0x09, 0xA0, 0xB5, 0x02, 0xB0,
  0x27, 0x30, 0xDA, 0x07, 0x50, 0x5B, 0x74, 0xB0, 0x45, 0x08, 0xA0, 0xB7, 0x30, 0x1B, 0x03, 0x50,
  0xDA, 0x06, 0x74, 0xB0, 0x44, 0x05, 0xA0, 0xE7, 0x50, 0xDA, 0x07, 0x30, 0x10, 0xDA, 0x05, 0x75,
  0x07, 0xA8, 0x3E, 0x40, 0x3C, 0xA0, 0x87, 0x70, 0xBF, 0x07, 0x77, 0x10, 0x4A, 0x83, 0xEE, 0xC8,
  0x27, 0x71, 0x82, 0x9F, 0xB1, 0x77, 0x58, 0x19, 0xFB, 0x77, 0x60, 0x1A, 0x07, 0x77, 0x60, 0x3A,
  0x83, 0xE8, 0x53, 0x27, 0x72, 0x01, 0xF9, 0x81, 0xD8, 0x17, 0x60, 0x6F, 0xA0, 0xE0, 0x57, 0x40,
  0x50, 0xBF, 0xC0, 0x17, 0x18, 0x92, 0x2C, 0xFD, 0x51, 0x01, 0x24, 0x7E, 0xB0, 0x77, 0x82, 0x2E,
  0xFB, 0x71, 0x01, 0x0E, 0xA0, 0xA7, 0x82, 0xCF, 0xE1, 0x72, 0x09, 0xA0, 0xA6, 0x04, 0xA0, 0xA7,
  0x30, 0x8A, 0x09, 0x60, 0x6A, 0x09, 0x73, 0x0B, 0xA0, 0x56, 0x06, 0xA0, 0xA7, 0x20, 0x2A, 0x0E,
  0x70, 0x3B, 0x02, 0x70, 0x10, 0xDA, 0x05, 0x71, 0x0B, 0xA8, 0x1D, 0x51, 0x38, 0x13, 0x8E, 0xA0,
  0x77, 0x30, 0xBF, 0xB0, 0xD0, 0x47, 0x58, 0x24, 0x9C, 0xEA, 0x82, 0xEC, 0x94, 0x74,
  // "Ģ" (U+0122)
  0x74, 0x89, 0x05, 0x9C, 0xEF, 0xED, 0xB8, 0x27, 0x38, 0x11, 0x8E, 0xFB, 0x08, 0x71, 0x05, 0x0E,
  0xA8, 0x1D, 0x61, 0x20, 0x30, 0xBC, 0x07, 0x60, 0x8B, 0x09, 0x70, 0xCB, 0x0D, 0x50, 0x9B, 0x08,
  0x71, 0x04, 0xB0, 0xD4, 0x07, 0xB0, 0x97, 0x3B, 0x07, 0x30, 0x2B, 0x0D, 0x74, 0x81, 0xEC, 0x64,
  0x0C, 0xB0, 0x47, 0x73, 0x06, 0xB0, 0xB7, 0x74, 0x0D, 0xB0, 0x47, 0x73, 0x04, 0xB0, 0xD7, 0x74,
  0x0A, 0xB0, 0x87, 0x74, 0x0E, 0xB0, 0x37, 0x73, 0x04, 0xB0, 0xE7, 0x74, 0x07, 0xB0, 0xB7, 0x74,
  0x09, 0xB0, 0x87, 0x10, 0xC8, 0x04, 0xE0, 0xA0, 0xBB, 0x06, 0x71, 0xFA, 0x08, 0x0C, 0xB0, 0x57,
  0x20, 0x20, 0xCC, 0x82, 0x81, 0x0D, 0xB0, 0x47, 0x30, 0x6B, 0x0A, 0x30, 0xDB, 0x03, 0x73, 0x07,
  0xB0, 0x53, 0x0B, 0xB0, 0x37, 0x30, 0xAB, 0x01, 0x30, 0x9B, 0x05, 0x73, 0x0D, 0xA0, 0xE4, 0x06,
  0xB0, 0x87, 0x20, 0x1B, 0x0A, 0x40, 0x1B, 0x0D, 0x72, 0x04, 0xB0, 0x75, 0x0A, 0xB0, 0x47, 0x10,
  0x7B, 0x04, 0x50, 0x10, 0xEA, 0x0E, 0x02, 0x70, 0xBB, 0x01, 0x60, 0x30, 0xEA, 0x81, 0xE7, 0x22,
  0x81, 0x15, 0xBB, 0x0D, 0x71, 0x02, 0x0C, 0xFC, 0x0A, 0x03, 0x73, 0x89, 0x14, 0x8C, 0xEF, 0xEE,
  0xC9, 0x51, 0x80, 0xE7, 0x08, 0x23, 0x77, 0x67, 0x75, 0x0A, 0xA0, 0x87, 0x75, 0x81, 0xEF, 0xE7,
  0x75, 0x05, 0xA0, 0x47, 0x75, 0x81, 0xBF, 0x97, 0x75, 0x81, 0x1F, 0xD7, 0x76, 0x81, 0x7F, 0x37,
  0x72,
  // "ģ" (U+0123)
  0x77, 0x28, 0x11, 0xDA, 0x77, 0x78, 0x1A, 0xF5, 0x77, 0x68, 0x15, 0xFE, 0x77, 0x78, 0x1D, 0xFA,
  0x77, 0x60, 0x9A, 0x05, 0x77, 0x50, 0x2B, 0x77, 0x60, 0xAA, 0x0A, 0x77, 0x60, 0xF1, 0x77, 0x76,
  0x82, 0x2B, 0xEC, 0x74, 0x89, 0x01, 0x7C, 0xEE, 0xC5, 0x02, 0xEB, 0x04, 0x72, 0x04, 0x0E, 0xE8,
  0x28, 0xDF, 0xEA, 0x02, 0x71, 0x05, 0xA8, 0x3D, 0x40, 0x2C, 0xA0, 0xC2, 0x0B, 0x07, 0x71, 0x02,
  0xA0, 0xE0, 0x23, 0x05, 0xA0, 0xE7, 0x50, 0xBA, 0x07, 0x40, 0x2B, 0x02, 0x73, 0x03, 0xB0, 0x14,
  0x01, 0xB0, 0x47, 0x30, 0x9A, 0x0B, 0x50, 0x2B, 0x02, 0x73, 0x0D, 0xA0, 0x75, 0x05, 0xB7, 0x4B,
  0x04, 0x50, 0x8A, 0x0B, 0x73, 0x01, 0xB0, 0x35, 0x0D, 0xA0, 0x67, 0x4B, 0x04, 0x40, 0x5A, 0x0E,
  0x75, 0x0D, 0xA0, 0x73, 0x01, 0x0D, 0xA0, 0x57, 0x50, 0x7A, 0x83, 0xE4, 0x03, 0xCA, 0x08, 0x77,
  0x0B, 0xF0, 0x77, 0x71, 0x04, 0xA8, 0x3E, 0xEC, 0x82, 0x77, 0x18, 0x29, 0xFB, 0x17, 0x75, 0x81,
  0x9F, 0xB7, 0x76, 0x01, 0xA0, 0x77, 0x76, 0x03, 0xA8, 0x3E, 0x85, 0x32, 0x77, 0x20, 0x1F, 0x98,
  0x1D, 0x81, 0x76, 0x06, 0xFA, 0x0E, 0x05, 0x74, 0x05, 0x0B, 0xFC, 0x01, 0x71, 0x89, 0x22, 0xCF,
  0xD5, 0x10, 0x12, 0x47, 0xEB, 0x07, 0x78, 0x22, 0xEF, 0xB7, 0x10, 0x10, 0xEA, 0x0A, 0x78, 0x2C,
  0xFE, 0x17, 0x20, 0x9A, 0x0A, 0x60, 0x4A, 0x0A, 0x73, 0x08, 0xA0, 0x96, 0x06, 0xA0, 0x97, 0x30,
  0xBA, 0x05, 0x60, 0x6A, 0x0A, 0x72, 0x02, 0xA0, 0xE7, 0x03, 0xB0, 0x27, 0x01, 0x0D, 0xA0, 0x57,
  0x10, 0xBA, 0x81, 0xD5, 0x13, 0x81, 0x38, 0xEA, 0x07, 0x73, 0x0B, 0xFB, 0x0D, 0x04, 0x75, 0x82,
  0x49, 0xCE, 0xA8, 0x2E, 0xC9, 0x47, 0x40,
  // "Ĥ" (U+0124)
  0x77, 0x40, 0x60, 0xF7, 0x77, 0x76, 0x05, 0xC0, 0x27, 0x77, 0x40, 0x20, 0xEC, 0x06, 0x77, 0x74,
  0x85, 0xCF, 0xE6, 0xEF, 0xC7, 0x77, 0x38, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x77, 0x71, 0x82, 0x8F,
  0xD2, 0x38, 0x1B, 0xFA, 0x77, 0x78, 0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x09, 0x92, 0x00, 0xCF,
  0xA0, 0x73, 0x02, 0xFB, 0x02, 0x60, 0xEF, 0xA0, 0x43, 0x04, 0xFA, 0x0E, 0x71, 0x01, 0x09, 0xC0,
  0x90, 0x27, 0x02, 0x0D, 0xB8, 0x1E, 0x61, 0x73, 0x03, 0xB0, 0xC7, 0x30, 0x9B, 0x07, 0x75, 0x05,
  0xB0, 0x77, 0x30, 0xAB, 0x01, 0x75, 0x08, 0xB0, 0x47, 0x30, 0xDA, 0x0D, 0x76, 0x0B, 0xB0, 0x17,
  0x20, 0x1B, 0x0A, 0x76, 0x0E, 0xA0, 0xD7, 0x30, 0x4B, 0x06, 0x75, 0x02, 0xB0, 0x97, 0x30, 0x8B,
  0x03, 0x75, 0x06, 0xB0, 0x67, 0x30, 0xBB, 0x76, 0x09, 0xB0, 0x37, 0x30, 0xEA, 0x0C, 0x76, 0x0C,
  0xB7, 0x30, 0x2B, 0x09, 0x76, 0xB0, 0xC7, 0x30, 0x5B, 0x05, 0x75, 0x03, 0xFF, 0xC0, 0x27, 0x50,
  0x6B, 0x80, 0x7E, 0xB0, 0xE7, 0x60, 0xAB, 0x01, 0x73, 0xB0, 0xB7, 0x60, 0xDA, 0x0D, 0x73, 0x03,
  0xB0, 0x87, 0x50, 0x1B, 0x0A, 0x73, 0x07, 0xB0, 0x47, 0x50, 0x4B, 0x07, 0x73, 0x0A, 0xB0, 0x17,
  0x50, 0x7B, 0x04, 0x73, 0x0D, 0xA0, 0xD7, 0x60, 0xBB, 0x73, 0x01, 0xB0, 0xA7, 0x60, 0xEA, 0x0C,
  0x73, 0x04, 0xB0, 0x77, 0x50, 0x2B, 0x09, 0x73, 0x08, 0xB0, 0x37, 0x50, 0x5B, 0x06, 0x73, 0x0B,
  0xB7, 0x60, 0x9B, 0x03, 0x73, 0x0E, 0xA0, 0xD7, 0x60, 0xEB, 0x01, 0x72, 0x04, 0xB0, 0xB7, 0x40,
  0x30, 0xBC, 0x07, 0x71, 0x05, 0x0D, 0xB0, 0xE0, 0x37, 0x10, 0x6F, 0xA0, 0xC4, 0x0B, 0xFA, 0x07,
  0x60, 0x9F, 0xA0, 0x94, 0xFB, 0x04, 0x60,
  // "ĥ" (U+0125)
  0x76, 0x06, 0x0F, 0x77, 0x71, 0x05, 0xC0, 0x27, 0x60, 0x20, 0xEC, 0x06, 0x76, 0x85, 0xCF, 0xE6,
  0xEF, 0xC7, 0x58, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x73, 0x82, 0x8F, 0xD2, 0x38, 0x1B, 0xFA, 0x72,
  0x82, 0x5F, 0xA1, 0x40, 0x10, 0xC9, 0x77, 0x73, 0x03, 0xE0, 0x77, 0x50, 0x5E, 0x03, 0x77, 0x06,
  0xC7, 0x72, 0x0E, 0xA0, 0xC7, 0x72, 0xB0, 0x97, 0x71, 0x02, 0xB0, 0x57, 0x71, 0x05, 0xB0, 0x27,
  0x71, 0x09, 0xA0, 0xE7, 0x72, 0x0C, 0xA0, 0xB7, 0x72, 0xB0, 0x82, 0x84, 0x3A, 0xEF, 0xD5, 0x70,
  0x3B, 0x81, 0x40, 0x7E, 0x03, 0x60, 0x6B, 0x84, 0x18, 0xE5, 0x03, 0xB0, 0xA6, 0x09, 0xA8, 0x2D,
  0x5E, 0x23, 0x0C, 0xA0, 0xD6, 0x0C, 0xA8, 0x1C, 0xE4, 0x40, 0xBA, 0x0E, 0x6C, 0x09, 0x50, 0xDA,
  0x0D, 0x50, 0x3C, 0x01, 0x5B, 0x0A, 0x50, 0x7B, 0x09, 0x50, 0x3B, 0x07, 0x50, 0xAB, 0x01, 0x50,
  0x6B, 0x04, 0x50, 0xDA, 0x0B, 0x60, 0xAB, 0x01, 0x40, 0x1B, 0x06, 0x60, 0xDA, 0x0D, 0x50, 0x4B,
  0x03, 0x6B, 0x0A, 0x50, 0x7B, 0x60, 0x3B, 0x07, 0x50, 0xBA, 0x0C, 0x60, 0x7B, 0x03, 0x50, 0xEA,
  0x09, 0x60, 0xAB, 0x01, 0x40, 0x2B, 0x06, 0x60, 0xCA, 0x0D, 0x50, 0x5B, 0x03, 0x60, 0xEA, 0x0B,
  0x50, 0x8B, 0x7B, 0x09, 0x50, 0xBA, 0x0C, 0x7B, 0x09, 0x50, 0xEA, 0x09, 0x70, 0xDA, 0x84, 0xD0,
  0x29, 0x22, 0xB0, 0x57, 0x07, 0xD8, 0x1E, 0x35, 0xB0, 0x27, 0x18, 0x38, 0xEE, 0xC7, 0x20,
  // "Ħ" (U+0126)
  0x60, 0xCF, 0xA0, 0x73, 0x02, 0xFB, 0x02, 0x60, 0xEF, 0xA0, 0x43, 0x04, 0xFA, 0x0E, 0x71, 0x01,
  0x09, 0xC0, 0x90, 0x27, 0x02, 0x0D, 0xB8, 0x1E, 0x61, 0x73, 0x03, 0xB0, 0xC7, 0x30, 0x9B, 0x07,
  0x75, 0x05, 0xB0, 0x77, 0x30, 0xAB, 0x01, 0x75, 0x08, 0xB0, 0x47, 0x30, 0xDA, 0x0D, 0x76, 0x0B,
  0xB7, 0x30, 0x1B, 0x0A, 0x72, 0x04, 0xFF, 0xFB, 0x0C, 0x60, 0x70, 0xFE, 0xC8, 0x06, 0xEC, 0x0F,
  0xE0, 0x87, 0x20, 0x5B, 0x06, 0x73, 0x0B, 0xB7, 0x60, 0x8B, 0x03, 0x73, 0x0E, 0xA0, 0xC7, 0x60,
  0xCB, 0x73, 0x02, 0xB0, 0x97, 0x6B, 0x0C, 0x73, 0x05, 0xB0, 0x67, 0x50, 0x3F, 0xFC, 0x02, 0x75,
  0x06, 0xB8, 0x07, 0xEB, 0x0E, 0x76, 0x09, 0xB0, 0x17, 0x3B, 0x0B, 0x76, 0x0D, 0xA0, 0xD7, 0x30,
  0x3B, 0x08, 0x75, 0x01, 0xB0, 0xA7, 0x30, 0x7B, 0x05, 0x75, 0x04, 0xB0, 0x77, 0x30, 0xAB, 0x01,
  0x75, 0x07, 0xB0, 0x47, 0x30, 0xDA, 0x0D, 0x76, 0x0A, 0xB7, 0x30, 0x1B, 0x0A, 0x76, 0x0E, 0xA0,
  0xC7, 0x30, 0x4B, 0x07, 0x75, 0x02, 0xB0, 0x97, 0x30, 0x8B, 0x03, 0x75, 0x05, 0xB0, 0x67, 0x30,
  0xBB, 0x76, 0x08, 0xB0, 0x37, 0x30, 0xEA, 0x0D, 0x76, 0x0D, 0xB0, 0x17, 0x20, 0x4B, 0x0B, 0x74,
  0x03, 0x0B, 0xC0, 0x77, 0x10, 0x50, 0xDB, 0x0E, 0x03, 0x71, 0x06, 0xFA, 0x0C, 0x40, 0xBF, 0xA0,
  0x76, 0x09, 0xFA, 0x09, 0x4F, 0xB0, 0x46,
  // "ħ" (U+0127)
  0x30, 0x5E, 0x04, 0x75, 0x08, 0xE0, 0x17, 0x70, 0x8B, 0x0D, 0x77, 0x10, 0x1B, 0x0A, 0x77, 0x10,
  0x3B, 0x07, 0x75, 0x06, 0xFD, 0x78, 0x19, 0xEE, 0xC8, 0x01, 0xE0, 0xC7, 0x30, 0xCA, 0x0D, 0x77,
  0x2B, 0x09, 0x77, 0x10, 0x3B, 0x05, 0x28, 0x45, 0xBE, 0xEB, 0x27, 0x06, 0xB8, 0x11, 0x0A, 0xD0,
  0xD7, 0x09, 0xA8, 0x5D, 0x0B, 0xC3, 0x08, 0xB0, 0x46, 0x0C, 0xA8, 0x18, 0x9C, 0x30, 0x2B, 0x08,
  0x6B, 0x81, 0x9E, 0x13, 0x01, 0xB0, 0x95, 0x03, 0xC0, 0x64, 0x03, 0xB0, 0x85, 0x07, 0xB0, 0xD5,
  0x05, 0xB0, 0x65, 0x0A, 0xB0, 0x65, 0x08, 0xB0, 0x35, 0x0D, 0xA0, 0xD6, 0x0B, 0xB5, 0x01, 0xB0,
  0x86, 0x0E, 0xA0, 0xC5, 0x04, 0xB0, 0x35, 0x02, 0xB0, 0x95, 0x07, 0xA0, 0xE6, 0x04, 0xB0, 0x65,
  0x0A, 0xA0, 0xB6, 0x07, 0xB0, 0x35, 0x0D, 0xA0, 0x86, 0x0A, 0xB5, 0x01, 0xB0, 0x56, 0x0D, 0xA0,
  0xD5, 0x04, 0xB0, 0x26, 0xB0, 0xA5, 0x07, 0xB6, 0x01, 0xB0, 0x85, 0x0B, 0xA0, 0xC6, 0x02, 0xB0,
  0x75, 0x0E, 0xA0, 0x96, 0x02, 0xB0, 0x74, 0x01, 0xB0, 0x67, 0x0E, 0xA8, 0x4B, 0x02, 0xA1, 0x5B,
  0x03, 0x70, 0x8D, 0x81, 0xD2, 0x8B, 0x72, 0x83, 0x9E, 0xEC, 0x62,
  // "Ĩ" (U+0128)
  0x78, 0x31, 0x9D, 0xD9, 0x50, 0x90, 0x77, 0x0C, 0xC0, 0xC0, 0x12, 0x81, 0x3F, 0x66, 0x83, 0x8F,
  0x41, 0x9A, 0x83, 0xD2, 0x0B, 0xE7, 0x0E, 0x0A, 0x30, 0x8D, 0x05, 0x68, 0x13, 0xA3, 0x48, 0x35,
  0xDF, 0xC5, 0x80, 0xD2, 0x00, 0xCF, 0xA0, 0x87, 0x10, 0xEF, 0xA0, 0x57, 0x20, 0x10, 0x9C, 0x0A,
  0x02, 0x75, 0x03, 0xB0, 0xD7, 0x70, 0x4B, 0x08, 0x77, 0x08, 0xB0, 0x47, 0x70, 0xBB, 0x01, 0x77,
  0x0E, 0xA0, 0xD7, 0x70, 0x2B, 0x0A, 0x77, 0x05, 0xB0, 0x67, 0x70, 0x9B, 0x03, 0x77, 0x0C, 0xB7,
  0x71, 0xB0, 0xC7, 0x70, 0x3B, 0x09, 0x77, 0x06, 0xB0, 0x57, 0x70, 0xAB, 0x02, 0x77, 0x0D, 0xA0,
  0xE7, 0x70, 0x1B, 0x0B, 0x77, 0x04, 0xB0, 0x77, 0x70, 0x7B, 0x04, 0x77, 0x0B, 0xB0, 0x17, 0x70,
  0xEA, 0x0D, 0x77, 0x02, 0xB0, 0xA7, 0x70, 0x5B, 0x06, 0x77, 0x09, 0xB0, 0x37, 0x70, 0xEB, 0x01,
  0x75, 0x03, 0x0B, 0xC0, 0x87, 0x30, 0x6F, 0xA0, 0xC7, 0x10, 0x9F, 0xA0, 0xA7, 0x10,
  // "ĩ" (U+0129)
  0x28, 0x31, 0x9D, 0xD9, 0x50, 0x90, 0x72, 0x0C, 0xC0, 0xC0, 0x12, 0x87, 0x3F, 0x60, 0x8F, 0x41,
  0x9A, 0x83, 0xD2, 0x0B, 0xE2, 0x0E, 0x0A, 0x30, 0x8D, 0x83, 0x50, 0x3A, 0x34, 0x83, 0x5D, 0xFC,
  0x57, 0x77, 0x74, 0xE0, 0x76, 0x02, 0xE0, 0x37, 0x10, 0x4C, 0x73, 0x0D, 0xA0, 0xD7, 0x30, 0xEA,
  0x09, 0x72, 0x02, 0xB0, 0x67, 0x20, 0x5B, 0x03, 0x72, 0x09, 0xB7, 0x30, 0xCA, 0x0C, 0x73, 0xB0,
  0x97, 0x20, 0x3B, 0x06, 0x72, 0x06, 0xB0, 0x27, 0x20, 0x9A, 0x0E, 0x73, 0x0C, 0xA0, 0xC7, 0x3B,
  0x09, 0x72, 0x02, 0xB0, 0x67, 0x20, 0x4B, 0x04, 0x72, 0x06, 0xB0, 0x27, 0x20, 0x6B, 0x02, 0x72,
  0x04, 0xB8, 0x27, 0x04, 0xC7, 0x0D, 0xD0, 0xA0, 0x16, 0x84, 0x3C, 0xFD, 0xA3, 0x60,
  // "Ī" (U+012A)
  0x60, 0x18, 0x05, 0xE0, 0xC6, 0x05, 0xFA, 0x09, 0x80, 0xC4, 0x00, 0xCF, 0xA0, 0x86, 0x0E, 0xFA,
  0x05, 0x70, 0x10, 0x9C, 0x0A, 0x02, 0x73, 0x03, 0xB0, 0xD7, 0x50, 0x4B, 0x08, 0x75, 0x08, 0xB0,
  0x47, 0x50, 0xBB, 0x01, 0x75, 0x0E, 0xA0, 0xD7, 0x50, 0x2B, 0x0A, 0x75, 0x05, 0xB0, 0x67, 0x50,
  0x9B, 0x03, 0x75, 0x0C, 0xB7, 0x6B, 0x0C, 0x75, 0x03, 0xB0, 0x97, 0x50, 0x6B, 0x05, 0x75, 0x0A,
  0xB0, 0x27, 0x50, 0xDA, 0x0E, 0x75, 0x01, 0xB0, 0xB7, 0x50, 0x4B, 0x07, 0x75, 0x07, 0xB0, 0x47,
  0x50, 0xBB, 0x01, 0x75, 0x0E, 0xA0, 0xD7, 0x50, 0x2B, 0x0A, 0x75, 0x05, 0xB0, 0x67, 0x50, 0x9B,
  0x03, 0x75, 0x0E, 0xB0, 0x17, 0x30, 0x30, 0xBC, 0x08, 0x71, 0x06, 0xFA, 0x0C, 0x60, 0x9F, 0xA0,
  0xA6,
  // "ī" (U+012B)
  0x01, 0x80, 0x5E, 0x0C, 0x05, 0xFA, 0x09, 0x77, 0x72, 0xE0, 0x73, 0x02, 0xE0, 0x35, 0x04, 0xC7,
  0x0D, 0xA0, 0xD7, 0x0E, 0xA0, 0x96, 0x02, 0xB0, 0x66, 0x05, 0xB0, 0x36, 0x09, 0xB7, 0x0C, 0xA0,
  0xC7, 0xB0, 0x96, 0x03, 0xB0, 0x66, 0x06, 0xB0, 0x26, 0x09, 0xA0, 0xE7, 0x0C, 0xA0, 0xC7, 0xB0,
  0x96, 0x02, 0xB0, 0x66, 0x04, 0xB0, 0x46, 0x06, 0xB0, 0x26, 0x06, 0xB0, 0x26, 0x04, 0xB8, 0x27,
  0x04, 0xC4, 0x0D, 0xD0, 0xA0, 0x13, 0x84, 0x3C, 0xFD, 0xA3, 0x40,
  // "Ĭ" (U+012C)
  0x78, 0x13, 0x72, 0x58, 0x11, 0x74, 0x78, 0x15, 0xF8, 0x58, 0x19, 0xF4, 0x78, 0x22, 0xFE, 0x42,
  0x82, 0x19, 0xFD, 0x72, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x72, 0x05, 0xE0, 0x77, 0x48, 0x45, 0xCF,
  0xEB, 0x48, 0x0D, 0x10, 0x0C, 0xFA, 0x08, 0x70, 0xEF, 0xA0, 0x57, 0x10, 0x10, 0x9C, 0x0A, 0x02,
  0x74, 0x03, 0xB0, 0xD7, 0x60, 0x4B, 0x08, 0x76, 0x08, 0xB0, 0x47, 0x60, 0xBB, 0x01, 0x76, 0x0E,
  0xA0, 0xD7, 0x60, 0x2B, 0x0A, 0x76, 0x05, 0xB0, 0x67, 0x60, 0x9B, 0x03, 0x76, 0x0C, 0xB7, 0x7B,
  0x0C, 0x76, 0x03, 0xB0, 0x97, 0x60, 0x6B, 0x05, 0x76, 0x0A, 0xB0, 0x27, 0x60, 0xDA, 0x0E, 0x76,
  0x01, 0xB0, 0xB7, 0x60, 0x4B, 0x07, 0x76, 0x07, 0xB0, 0x47, 0x60, 0xBB, 0x01, 0x76, 0x0E, 0xA0,
  0xD7, 0x60, 0x2B, 0x0A, 0x76, 0x05, 0xB0, 0x67, 0x60, 0x9B, 0x03, 0x76, 0x0E, 0xB0, 0x17, 0x40,
  0x30, 0xBC, 0x08, 0x72, 0x06, 0xFA, 0x0C, 0x70, 0x9F, 0xA0, 0xA7,
  // "ĭ" (U+012D)
  0x18, 0x13, 0x72, 0x58, 0x51, 0x74, 0x05, 0xF8, 0x58, 0x69, 0xF4, 0x02, 0xFE, 0x42, 0x82, 0x19,
  0xFD, 0x30, 0xDA, 0x0E, 0x0D, 0xB0, 0x43, 0x05, 0xE0, 0x75, 0x84, 0x5C, 0xFE, 0xB4, 0x77, 0x77,
  0xE0, 0x74, 0x02, 0xE0, 0x36, 0x04, 0xC7, 0x10, 0xDA, 0x0D, 0x71, 0x0E, 0xA0, 0x97, 0x02, 0xB0,
  0x67, 0x05, 0xB0, 0x37, 0x09, 0xB7, 0x10, 0xCA, 0x0C, 0x71, 0xB0, 0x97, 0x03, 0xB0, 0x67, 0x06,
  0xB0, 0x27, 0x09, 0xA0, 0xE7, 0x10, 0xCA, 0x0C, 0x71, 0xB0, 0x97, 0x02, 0xB0, 0x67, 0x04, 0xB0,
  0x47, 0x06, 0xB0, 0x27, 0x06, 0xB0, 0x27, 0x04, 0xB8, 0x27, 0x04, 0xC5, 0x0D, 0xD0, 0xA0, 0x14,
  0x84, 0x3C, 0xFD, 0xA3, 0x50,
  // "Į" (U+012E)
  0x60, 0xCF, 0xA0, 0x86, 0x0E, 0xFA, 0x05, 0x70, 0x10, 0x9C, 0x0A, 0x02, 0x73, 0x03, 0xB0, 0xD7,
  0x50, 0x4B, 0x08, 0x75, 0x08, 0xB0, 0x47, 0x50, 0xBB, 0x01, 0x75, 0x0E, 0xA0, 0xD7, 0x50, 0x2B,
  0x0A, 0x75, 0x05, 0xB0, 0x67, 0x50, 0x9B, 0x03, 0x75, 0x0C, 0xB7, 0x6B, 0x0C, 0x75, 0x03, 0xB0,
  0x97, 0x50, 0x6B, 0x05, 0x75, 0x0A, 0xB0, 0x27, 0x50, 0xDA, 0x0E, 0x75, 0x01, 0xB0, 0xB7, 0x50,
  0x4B, 0x07, 0x75, 0x07, 0xB0, 0x47, 0x50, 0xBB, 0x01, 0x75, 0x0E, 0xA0, 0xD7, 0x50, 0x2B, 0x0A,
  0x75, 0x05, 0xB0, 0x67, 0x50, 0x9B, 0x03, 0x75, 0x0E, 0xB0, 0x17, 0x30, 0x30, 0xBC, 0x08, 0x71,
  0x06, 0xFA, 0x0C, 0x60, 0x9F, 0xA0, 0xA7, 0x48, 0x11, 0x76, 0x75, 0x82, 0x1A, 0xF9, 0x75, 0x82,
  0x3D, 0xF7, 0x75, 0x82, 0x1E, 0xFC, 0x76, 0x08, 0xA0, 0x67, 0x60, 0xBA, 0x04, 0x76, 0x0B, 0xA0,
  0x67, 0x60, 0x9A, 0x83, 0xE7, 0x58, 0x37, 0x20, 0x2E, 0x02, 0x73, 0x84, 0x2A, 0xEE, 0xC7, 0x72,
  // "į" (U+012F)
  0x78, 0x27, 0xED, 0x36, 0x03, 0xB0, 0xB6, 0x06, 0xB0, 0xC6, 0x05, 0xB0, 0x97, 0x82, 0xBE, 0xB1,
  0x80, 0xD3, 0x0E, 0x07, 0x30, 0x3E, 0x04, 0x50, 0x3C, 0x70, 0xCA, 0x0D, 0x70, 0xEA, 0x0A, 0x60,
  0x1B, 0x06, 0x60, 0x5B, 0x03, 0x60, 0x8B, 0x70, 0xBA, 0x0D, 0x70, 0xEA, 0x09, 0x60, 0x2B, 0x06,
  0x60, 0x6B, 0x03, 0x60, 0x9B, 0x70, 0xCA, 0x0C, 0x7B, 0x09, 0x60, 0x2B, 0x06, 0x60, 0x4B, 0x04,
  0x60, 0x6B, 0x02, 0x60, 0x6B, 0x02, 0x60, 0x4B, 0x82, 0x70, 0x4C, 0x40, 0xDD, 0x0A, 0x01, 0x38,
  0x43, 0xCF, 0xEA, 0x46, 0x81, 0x17, 0x66, 0x82, 0x1A, 0xF9, 0x68, 0x23, 0xDF, 0x76, 0x82, 0x1E,
  0xFC, 0x70, 0x8A, 0x06, 0x70, 0xBA, 0x04, 0x70, 0xBA, 0x06, 0x70, 0x9A, 0x83, 0xE7, 0x58, 0x33,
  0x02, 0xE0, 0x24, 0x84, 0x2A, 0xEE, 0xC7, 0x40,
  // "İ" (U+0130)
  0x74, 0x82, 0x9E, 0xC1, 0x75, 0x06, 0xB0, 0x87, 0x50, 0x9B, 0x09, 0x75, 0x09, 0xB0, 0x67, 0x58,
  0x22, 0xCE, 0x98, 0x09, 0x91, 0x00, 0xCF, 0xA0, 0x86, 0x0E, 0xFA, 0x05, 0x70, 0x10, 0x9C, 0x0A,
  0x02, 0x73, 0x03, 0xB0, 0xD7, 0x50, 0x4B, 0x08, 0x75, 0x08, 0xB0, 0x47, 0x50, 0xBB, 0x01, 0x75,
  0x0E, 0xA0, 0xD7, 0x50, 0x2B, 0x0A, 0x75, 0x05, 0xB0, 0x67, 0x50, 0x9B, 0x03, 0x75, 0x0C, 0xB7,
  0x6B, 0x0C, 0x75, 0x03, 0xB0, 0x97, 0x50, 0x6B, 0x05, 0x75, 0x0A, 0xB0, 0x27, 0x50, 0xDA, 0x0E,
  0x75, 0x01, 0xB0, 0xB7, 0x50, 0x4B, 0x07, 0x75, 0x07, 0xB0, 0x47, 0x50, 0xBB, 0x01, 0x75, 0x0E,
  0xA0, 0xD7, 0x50, 0x2B, 0x0A, 0x75, 0x05, 0xB0, 0x67, 0x50, 0x9B, 0x03, 0x75, 0x0E, 0xB0, 0x17,
  0x30, 0x30, 0xBC, 0x08, 0x71, 0x06, 0xFA, 0x0C, 0x60, 0x9F, 0xA0, 0xA6,
  // "ı" (U+0131)
  0x1E, 0x81, 0x70, 0x2E, 0x03, 0x30, 0x4C, 0x50, 0xDA, 0x0D, 0x50, 0xEA, 0x09, 0x40, 0x2B, 0x06,
  0x40, 0x5B, 0x03, 0x40, 0x9B, 0x50, 0xCA, 0x0C, 0x5B, 0x09, 0x40, 0x3B, 0x06, 0x40, 0x6B, 0x02,
  0x40, 0x9A, 0x0E, 0x50, 0xCA, 0x0C, 0x5B, 0x09, 0x40, 0x2B, 0x06, 0x40, 0x4B, 0x04, 0x40, 0x6B,
  0x02, 0x40, 0x6B, 0x02, 0x40, 0x4B, 0x82, 0x70, 0x4C, 0x20, 0xDD, 0x87, 0xA1, 0x03, 0xCF, 0xDA,
  0x32,
  // "Ĳ" (U+0132)
  0x60, 0xCF, 0xA0, 0x82, 0x0E, 0xFA, 0x06, 0x60, 0xEF, 0xA8, 0x15, 0x01, 0xFB, 0x03, 0x70, 0x10,
  0x9C, 0x0A, 0x02, 0x50, 0x10, 0xBC, 0x08, 0x02, 0x73, 0x03, 0xB0, 0xD7, 0x10, 0x6B, 0x0B, 0x75,
  0x04, 0xB0, 0x87, 0x10, 0x7B, 0x05, 0x75, 0x08, 0xB0, 0x47, 0x10, 0xAB, 0x02, 0x75, 0x0B, 0xB0,
  0x17, 0x10, 0xDA, 0x0E, 0x76, 0x0E, 0xA0, 0xD7, 0x10, 0x1B, 0x0B, 0x75, 0x02, 0xB0, 0xA7, 0x10,
  0x4B, 0x08, 0x75, 0x05, 0xB0, 0x67, 0x10, 0x7B, 0x04, 0x75, 0x09, 0xB0, 0x37, 0x10, 0xBB, 0x01,
  0x75, 0x0C, 0xB7, 0x20, 0xEA, 0x0D, 0x76, 0xB0, 0xC7, 0x10, 0x2B, 0x0A, 0x75, 0x03, 0xB0, 0x97,
  0x10, 0x5B, 0x07, 0x75, 0x06, 0xB0, 0x57, 0x10, 0x8B, 0x04, 0x75, 0x0A, 0xB0, 0x27, 0x10, 0xBB,
  0x76, 0x0D, 0xA0, 0xE7, 0x20, 0xEA, 0x0D, 0x75, 0x01, 0xB0, 0xB7, 0x10, 0x2B, 0x09, 0x75, 0x04,
  0xB0, 0x77, 0x10, 0x6B, 0x06, 0x75, 0x07, 0xB0, 0x47, 0x10, 0x9B, 0x03, 0x75, 0x0B, 0xB0, 0x17,
  0x10, 0xCB, 0x76, 0x0E, 0xA0, 0xD7, 0x2B, 0x0C, 0x75, 0x02, 0xB0, 0xA7, 0x10, 0x3B, 0x08, 0x75,
  0x05, 0xB0, 0x67, 0x10, 0x6B, 0x05, 0x75, 0x09, 0xB0, 0x37, 0x10, 0xAB, 0x02, 0x75, 0x0E, 0xB0,
  0x17, 0x10, 0xDA, 0x0E, 0x74, 0x03, 0x0B, 0xC0, 0x87, 0x01, 0xB0, 0xB7, 0x20, 0x6F, 0xA0, 0xC5,
  0x04, 0xB0, 0x87, 0x20, 0x9F, 0xA0, 0xA5, 0x07, 0xB0, 0x47, 0x77, 0x40, 0xAB, 0x01, 0x77, 0x74,
  0x0E, 0xA0, 0xD7, 0x77, 0x40, 0x2B, 0x09, 0x77, 0x74, 0x07, 0xB0, 0x47, 0x77, 0x40, 0xCA, 0x0D,
  0x77, 0x74, 0x04, 0xB0, 0x67, 0x77, 0x40, 0xDA, 0x0D, 0x77, 0x70, 0x22, 0x03, 0x0C, 0xA0, 0xE0,
  0x27, 0x76, 0x04, 0xE0, 0xD0, 0x37, 0x77, 0x05, 0x0D, 0xA8, 0x1D, 0xB6, 0x77, 0x10,
  // "ĳ" (U+0133)
  0x58, 0x27, 0xED, 0x37, 0x82, 0x6E, 0xD4, 0x40, 0x3B, 0x0B, 0x60, 0x2B, 0x0C, 0x40, 0x6B, 0x0C,
  0x60, 0x6B, 0x0D, 0x40, 0x5B, 0x09, 0x60, 0x5B, 0x0A, 0x58, 0x2B, 0xEB, 0x17, 0x82, 0xAE, 0xC2,
  0x80, 0x99, 0x50, 0xE0, 0x74, 0x0E, 0xD8, 0x17, 0x03, 0xE0, 0x43, 0x02, 0xE0, 0x43, 0x03, 0xC6,
  0x03, 0xC0, 0x14, 0x0C, 0xA0, 0xD7, 0x0C, 0xA0, 0xD5, 0x0E, 0xA0, 0xA7, 0x0D, 0xA0, 0xA4, 0x01,
  0xB0, 0x66, 0x01, 0xB0, 0x74, 0x05, 0xB0, 0x36, 0x04, 0xB0, 0x44, 0x08, 0xB7, 0x07, 0xB0, 0x14,
  0x0B, 0xA0, 0xD7, 0x0A, 0xA0, 0xD5, 0x0E, 0xA0, 0x97, 0x0D, 0xA0, 0xA4, 0x02, 0xB0, 0x66, 0x01,
  0xB0, 0x64, 0x06, 0xB0, 0x36, 0x04, 0xB0, 0x34, 0x09, 0xB7, 0x08, 0xB5, 0x0C, 0xA0, 0xC7, 0x0B,
  0xA0, 0xC5, 0xB0, 0x97, 0x0E, 0xA0, 0x94, 0x02, 0xB0, 0x66, 0x02, 0xB0, 0x64, 0x04, 0xB0, 0x46,
  0x05, 0xB0, 0x34, 0x06, 0xB0, 0x26, 0x08, 0xB5, 0x06, 0xB0, 0x26, 0x0B, 0xA0, 0xC5, 0x04, 0xB8,
  0x27, 0x04, 0xC3, 0x0E, 0xA0, 0x96, 0x0D, 0xD8, 0x2A, 0x10, 0x2B, 0x06, 0x68, 0x43, 0xCF, 0xEA,
  0x43, 0x05, 0xB0, 0x27, 0x71, 0x08, 0xA0, 0xE7, 0x72, 0x0C, 0xA0, 0xB7, 0x72, 0xB0, 0x77, 0x71,
  0x04, 0xB0, 0x37, 0x71, 0x0A, 0xA0, 0xD7, 0x71, 0x01, 0x0E, 0xA0, 0x67, 0x71, 0x09, 0xA0, 0xD7,
  0x50, 0x12, 0x08, 0xB0, 0x37, 0x50, 0xDD, 0x05, 0x76, 0x84, 0xCE, 0xFD, 0x82, 0x73,
  // "Ĵ" (U+0134)
  0x77, 0x20, 0x60, 0xF7, 0x77, 0x30, 0x5C, 0x02, 0x77, 0x10, 0x20, 0xEC, 0x06, 0x77, 0x18, 0x5C,
  0xFE, 0x6E, 0xFC, 0x77, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x58, 0x28, 0xFD, 0x23, 0x81, 0xBF,
  0xA7, 0x48, 0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0E, 0x30, 0x0E, 0xFA, 0x06, 0x73, 0x01, 0xFB,
  0x03, 0x75, 0x01, 0x0B, 0xC0, 0x80, 0x27, 0x71, 0x06, 0xB0, 0xB7, 0x73, 0x07, 0xB0, 0x57, 0x73,
  0x0A, 0xB0, 0x27, 0x73, 0x0D, 0xA0, 0xE7, 0x73, 0x01, 0xB0, 0xB7, 0x73, 0x04, 0xB0, 0x87, 0x73,
  0x07, 0xB0, 0x47, 0x73, 0x0B, 0xB0, 0x17, 0x73, 0x0E, 0xA0, 0xD7, 0x73, 0x02, 0xB0, 0xA7, 0x73,
  0x05, 0xB0, 0x77, 0x73, 0x08, 0xB0, 0x47, 0x73, 0x0B, 0xB7, 0x74, 0x0E, 0xA0, 0xD7, 0x73, 0x02,
  0xB0, 0x97, 0x73, 0x06, 0xB0, 0x67, 0x73, 0x09, 0xB0, 0x37, 0x73, 0x0C, 0xB7, 0x74, 0xB0, 0xC7,
  0x73, 0x03, 0xB0, 0x87, 0x73, 0x06, 0xB0, 0x57, 0x73, 0x0A, 0xB0, 0x27, 0x73, 0x0D, 0xA0, 0xE7,
  0x73, 0x01, 0xB0, 0xB7, 0x73, 0x04, 0xB0, 0x87, 0x73, 0x07, 0xB0, 0x47, 0x73, 0x0A, 0xB0, 0x17,
  0x73, 0x0E, 0xA0, 0xD7, 0x73, 0x02, 0xB0, 0x97, 0x73, 0x07, 0xB0, 0x47, 0x73, 0x0C, 0xA0, 0xD7,
  0x73, 0x04, 0xB0, 0x67, 0x73, 0x0D, 0xA0, 0xD7, 0x60, 0x22, 0x03, 0x0C, 0xA0, 0xE0, 0x27, 0x50,
  0x4E, 0x0D, 0x03, 0x76, 0x05, 0x0D, 0xA8, 0x1D, 0xB6, 0x77, 0x10,
  // "ĵ" (U+0135)
  0x74, 0x06, 0x0F, 0x77, 0x50, 0x5C, 0x02, 0x73, 0x02, 0x0E, 0xC0, 0x67, 0x38, 0x5C, 0xFE, 0x6E,
  0xFC, 0x72, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x82, 0x8F, 0xD2, 0x38, 0x1B, 0xFA, 0x68, 0x25,
  0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0C, 0x60, 0x0E, 0xD0, 0x77, 0x20, 0x2E, 0x04, 0x74, 0x03, 0xC0,
  0x17, 0x50, 0xCA, 0x0D, 0x76, 0x0D, 0xA0, 0xA7, 0x50, 0x1B, 0x07, 0x75, 0x04, 0xB0, 0x47, 0x50,
  0x7B, 0x01, 0x75, 0x0A, 0xA0, 0xD7, 0x60, 0xDA, 0x0A, 0x75, 0x01, 0xB0, 0x67, 0x50, 0x4B, 0x03,
  0x75, 0x08, 0xB7, 0x60, 0xBA, 0x0C, 0x76, 0x0E, 0xA0, 0x97, 0x50, 0x2B, 0x06, 0x75, 0x05, 0xB0,
  0x37, 0x50, 0x8B, 0x76, 0x0B, 0xA0, 0xC7, 0x60, 0xEA, 0x09, 0x75, 0x02, 0xB0, 0x67, 0x50, 0x5B,
  0x02, 0x75, 0x08, 0xA0, 0xE7, 0x60, 0xCA, 0x0B, 0x76, 0xB0, 0x77, 0x50, 0x4B, 0x03, 0x75, 0x0A,
  0xA0, 0xD7, 0x50, 0x10, 0xEA, 0x06, 0x75, 0x09, 0xA0, 0xD7, 0x20, 0x12, 0x08, 0xB0, 0x47, 0x20,
  0xDD, 0x05, 0x73, 0x84, 0xCE, 0xED, 0x82, 0x74,
  // "Ķ" (U+0136)
  0x60, 0xCF, 0xA0, 0x73, 0x0B, 0xF0, 0x26, 0x0E, 0xFA, 0x04, 0x30, 0xDF, 0x71, 0x01, 0x09, 0xC0,
  0x90, 0x26, 0x09, 0xB0, 0xD0, 0x47, 0x30, 0x3B, 0x0D, 0x71, 0x0B, 0xA0, 0xB0, 0x17, 0x40, 0x4B,
  0x07, 0x70, 0x5A, 0x0A, 0x76, 0x08, 0xB0, 0x46, 0x82, 0x3E, 0xFA, 0x77, 0x0B, 0xB6, 0x82, 0x2E,
  0xFA, 0x77, 0x10, 0xEA, 0x0D, 0x58, 0x21, 0xDF, 0xA7, 0x71, 0x02, 0xB0, 0x94, 0x82, 0x1D, 0xFB,
  0x77, 0x20, 0x5B, 0x06, 0x38, 0x21, 0xCF, 0xB7, 0x73, 0x09, 0xB0, 0x33, 0x81, 0xCF, 0xB7, 0x74,
  0x0C, 0xB3, 0x81, 0xBF, 0xB7, 0x75, 0xB0, 0xC2, 0x0A, 0xA0, 0x27, 0x74, 0x03, 0xB8, 0x18, 0x0A,
  0xB0, 0x77, 0x74, 0x06, 0xB0, 0x50, 0x9C, 0x0C, 0x77, 0x40, 0xAB, 0x82, 0xAF, 0xAE, 0xB0, 0x27,
  0x73, 0x0D, 0xC8, 0x19, 0x09, 0xB0, 0x77, 0x72, 0x01, 0xC0, 0x72, 0x04, 0xB0, 0xC7, 0x72, 0x04,
  0xB0, 0x84, 0x0E, 0xB0, 0x27, 0x71, 0x07, 0xB0, 0x44, 0x0A, 0xB0, 0x77, 0x71, 0x0B, 0xB0, 0x14,
  0x05, 0xB0, 0xC7, 0x71, 0x0E, 0xA0, 0xD6, 0xC0, 0x27, 0x60, 0x2B, 0x09, 0x60, 0xBB, 0x07, 0x76,
  0x05, 0xB0, 0x66, 0x06, 0xB0, 0xC7, 0x60, 0x9B, 0x03, 0x60, 0x1C, 0x02, 0x75, 0x0E, 0xB0, 0x17,
  0x0B, 0xB0, 0xA7, 0x30, 0x30, 0xBC, 0x08, 0x70, 0x4C, 0x08, 0x01, 0x60, 0x6F, 0xA0, 0xC6, 0x0A,
  0xD0, 0x25, 0x09, 0xFA, 0x0A, 0x78, 0x36, 0xBE, 0xFE, 0x80, 0x98, 0x50, 0x82, 0x37, 0x76, 0x77,
  0x74, 0x0A, 0xA0, 0x87, 0x77, 0x48, 0x1E, 0xFE, 0x77, 0x74, 0x05, 0xA0, 0x47, 0x77, 0x48, 0x1B,
  0xF9, 0x77, 0x74, 0x81, 0x1F, 0xD7, 0x77, 0x58, 0x17, 0xF3, 0x77, 0x50,
  // "ķ" (U+0137)
  0x30, 0x3E, 0x07, 0x76, 0x05, 0xE0, 0x37, 0x71, 0x06, 0xC7, 0x73, 0x0E, 0xA0, 0xC7, 0x73, 0xB0,
  0x97, 0x72, 0x02, 0xB0, 0x67, 0x72, 0x05, 0xB0, 0x27, 0x72, 0x09, 0xA0, 0xE7, 0x73, 0x0C, 0xA0,
  0xB7, 0x73, 0xB0, 0x83, 0x03, 0xF0, 0x74, 0x03, 0xB0, 0x53, 0x06, 0xF0, 0x54, 0x06, 0xB0, 0x14,
  0x01, 0xB8, 0x1E, 0x71, 0x50, 0x9A, 0x0E, 0x50, 0x3A, 0x0D, 0x02, 0x70, 0xCA, 0x0A, 0x58, 0x2C,
  0xFC, 0x17, 0x1B, 0x07, 0x48, 0x1A, 0xFB, 0x72, 0x03, 0xB0, 0x33, 0x81, 0xAF, 0xB7, 0x30, 0x7B,
  0x38, 0x1A, 0xFB, 0x74, 0x0A, 0xA0, 0xC2, 0x81, 0xBF, 0xB7, 0x50, 0xDA, 0x81, 0x80, 0xBA, 0x09,
  0x74, 0x01, 0xB0, 0x50, 0xCB, 0x0E, 0x74, 0x04, 0xB8, 0x1D, 0xFA, 0xB0, 0x57, 0x30, 0x7C, 0x81,
  0x50, 0xEA, 0x0B, 0x73, 0x0B, 0xA0, 0xE0, 0x32, 0x09, 0xB0, 0x17, 0x20, 0xEA, 0x09, 0x30, 0x4B,
  0x07, 0x71, 0x02, 0xB0, 0x54, 0x0E, 0xA0, 0xC7, 0x10, 0x5B, 0x02, 0x40, 0xAB, 0x02, 0x70, 0x8A,
  0x0E, 0x50, 0x5B, 0x09, 0x70, 0xBA, 0x0C, 0x60, 0xEA, 0x0E, 0x02, 0x60, 0xEA, 0x09, 0x60, 0x9B,
  0x0D, 0x03, 0x40, 0x2B, 0x05, 0x60, 0x10, 0xDC, 0x09, 0x30, 0x5B, 0x02, 0x78, 0x41, 0x8C, 0xEF,
  0x68, 0x0D, 0x60, 0x82, 0x37, 0x76, 0x77, 0x30, 0xAA, 0x08, 0x77, 0x38, 0x1E, 0xFE, 0x77, 0x30,
  0x5A, 0x04, 0x77, 0x38, 0x1B, 0xF9, 0x77, 0x38, 0x11, 0xFD, 0x77, 0x48, 0x17, 0xF3, 0x77, 0x10,
  // "ĸ" (U+0138)
  0x10, 0x2E, 0x07, 0x30, 0x5F, 0x81, 0x70, 0x5E, 0x03, 0x30, 0x8F, 0x03, 0x30, 0x5C, 0x50, 0x2B,
  0x0E, 0x06, 0x60, 0xEA, 0x0C, 0x50, 0x4A, 0x0C, 0x01, 0x70, 0xEA, 0x09, 0x48, 0x21, 0xDF, 0xB7,
  0x10, 0x2B, 0x06, 0x48, 0x1C, 0xFA, 0x72, 0x05, 0xB0, 0x23, 0x81, 0xBF, 0xA7, 0x30, 0x8A, 0x0E,
  0x38, 0x1C, 0xFA, 0x74, 0x0B, 0xA8, 0x4B, 0x01, 0xCF, 0xA7, 0x50, 0xEA, 0x81, 0x71, 0xCA, 0x08,
  0x74, 0x02, 0xB0, 0x50, 0xCB, 0x0D, 0x74, 0x05, 0xB8, 0x1D, 0xFA, 0xB0, 0x37, 0x30, 0x9B, 0x0E,
  0x04, 0x1B, 0x09, 0x73, 0x0C, 0xA0, 0xD0, 0x22, 0x0B, 0xA0, 0xE7, 0x3B, 0x07, 0x30, 0x6B, 0x04,
  0x71, 0x03, 0xB0, 0x43, 0x01, 0xB0, 0xA7, 0x10, 0x6B, 0x01, 0x40, 0xBB, 0x71, 0x09, 0xA0, 0xD5,
  0x07, 0xB0, 0x67, 0x0C, 0xA0, 0xA5, 0x01, 0xB0, 0xE0, 0x16, 0xB0, 0x76, 0x0A, 0xB0, 0xC0, 0x34,
  0x03, 0xB0, 0x46, 0x01, 0x0D, 0xC0, 0x83, 0x07, 0xB0, 0x17, 0x84, 0x18, 0xCE, 0xF5, 0x30,
  // "Ĺ" (U+0139)
  0x77, 0x83, 0x47, 0x77, 0x37, 0x71, 0x01, 0x0E, 0xA0, 0xD0, 0x17, 0x71, 0x0A, 0xA0, 0xE0, 0x27,
  0x71, 0x04, 0xA0, 0xE0, 0x27, 0x71, 0x83, 0x1D, 0xFE, 0x27, 0x72, 0x82, 0xAF, 0xD2, 0x77, 0x28,
  0x25, 0xFA, 0x18, 0x0E, 0x30, 0x0C, 0xFA, 0x08, 0x73, 0x0E, 0xFA, 0x05, 0x74, 0x01, 0x09, 0xC0,
  0x90, 0x27, 0x70, 0x3B, 0x0C, 0x77, 0x20, 0x4B, 0x07, 0x77, 0x20, 0x7B, 0x04, 0x77, 0x20, 0xBB,
  0x01, 0x77, 0x20, 0xEA, 0x0D, 0x77, 0x20, 0x2B, 0x09, 0x77, 0x20, 0x5B, 0x06, 0x77, 0x20, 0x8B,
  0x03, 0x77, 0x20, 0xBB, 0x77, 0x30, 0xEA, 0x0C, 0x77, 0x20, 0x2B, 0x09, 0x77, 0x20, 0x6B, 0x05,
  0x77, 0x20, 0x9B, 0x02, 0x77, 0x20, 0xCA, 0x0E, 0x77, 0x3B, 0x0B, 0x77, 0x20, 0x3B, 0x08, 0x77,
  0x20, 0x7B, 0x05, 0x77, 0x20, 0xAB, 0x02, 0x72, 0x07, 0x09, 0x50, 0xDA, 0x0E, 0x72, 0x81, 0x1F,
  0xC4, 0x01, 0xB0, 0xB7, 0x28, 0x16, 0xF8, 0x40, 0x4B, 0x07, 0x72, 0x81, 0xCF, 0x54, 0x07, 0xB0,
  0x47, 0x10, 0x3A, 0x01, 0x40, 0xCB, 0x01, 0x71, 0x81, 0xCF, 0xD4, 0x07, 0xB0, 0xD7, 0x02, 0x0A,
  0xA8, 0x39, 0x04, 0xAD, 0xD8, 0x02, 0xED, 0x81, 0x50, 0x9F, 0xFC, 0x01, 0x10,
  // "ĺ" (U+013A)
  0x73, 0x83, 0x47, 0x77, 0x37, 0x20, 0x10, 0xEA, 0x0D, 0x01, 0x72, 0x0A, 0xA0, 0xE0, 0x27, 0x20,
  0x4A, 0x0E, 0x02, 0x72, 0x83, 0x1D, 0xFE, 0x27, 0x38, 0x2A, 0xFD, 0x27, 0x38, 0x25, 0xFA, 0x17,
  0x77, 0x10, 0x7E, 0x05, 0x70, 0x9E, 0x02, 0x72, 0x08, 0xB0, 0xE7, 0x4B, 0x0B, 0x73, 0x01, 0xB0,
  0x87, 0x30, 0x4B, 0x05, 0x73, 0x07, 0xB0, 0x17, 0x30, 0xAA, 0x0E, 0x74, 0x0D, 0xA0, 0xA7, 0x30,
  0x1B, 0x07, 0x73, 0x04, 0xB0, 0x47, 0x30, 0x8B, 0x01, 0x73, 0x0B, 0xA0, 0xD7, 0x40, 0xEA, 0x09,
  0x73, 0x02, 0xB0, 0x67, 0x30, 0x5B, 0x03, 0x73, 0x09, 0xB7, 0x40, 0xCA, 0x0C, 0x74, 0xB0, 0x97,
  0x30, 0x3B, 0x05, 0x73, 0x06, 0xB0, 0x27, 0x30, 0x9A, 0x0E, 0x74, 0x0C, 0xA0, 0xB7, 0x4B, 0x08,
  0x73, 0x03, 0xB0, 0x67, 0x30, 0x5B, 0x04, 0x73, 0x07, 0xB0, 0x27, 0x30, 0x7B, 0x02, 0x73, 0x05,
  0xB8, 0x26, 0x05, 0xC7, 0x10, 0xED, 0x09, 0x71, 0x84, 0x3C, 0xFD, 0xA3, 0x71,
  // "Ļ" (U+013B)
  0x60, 0xCF, 0xA0, 0x87, 0x30, 0xEF, 0xA0, 0x57, 0x40, 0x10, 0x9C, 0x09, 0x02, 0x77, 0x03, 0xB0,
  0xC7, 0x72, 0x04, 0xB0, 0x77, 0x72, 0x07, 0xB0, 0x47, 0x72, 0x0B, 0xB0, 0x17, 0x72, 0x0E, 0xA0,
  0xD7, 0x72, 0x02, 0xB0, 0x97, 0x72, 0x05, 0xB0, 0x67, 0x72, 0x08, 0xB0, 0x37, 0x72, 0x0B, 0xB7,
  0x73, 0x0E, 0xA0, 0xC7, 0x72, 0x02, 0xB0, 0x97, 0x72, 0x06, 0xB0, 0x57, 0x72, 0x09, 0xB0, 0x27,
  0x72, 0x0C, 0xA0, 0xE7, 0x73, 0xB0, 0xB7, 0x72, 0x03, 0xB0, 0x87, 0x72, 0x07, 0xB0, 0x57, 0x72,
  0x0A, 0xB0, 0x27, 0x20, 0x70, 0x95, 0x0D, 0xA0, 0xE7, 0x28, 0x11, 0xFC, 0x40, 0x1B, 0x0B, 0x72,
  0x81, 0x6F, 0x84, 0x04, 0xB0, 0x77, 0x28, 0x1C, 0xF5, 0x40, 0x7B, 0x04, 0x71, 0x03, 0xA0, 0x14,
  0x0C, 0xB0, 0x17, 0x18, 0x1C, 0xFD, 0x40, 0x7B, 0x0D, 0x70, 0x20, 0xAA, 0x83, 0x90, 0x4A, 0xDD,
  0x80, 0x2E, 0xD8, 0x15, 0x09, 0xFF, 0xC0, 0x18, 0x0D, 0x60, 0x82, 0x37, 0x76, 0x77, 0x30, 0xAA,
  0x08, 0x77, 0x38, 0x1E, 0xFE, 0x77, 0x30, 0x5A, 0x04, 0x77, 0x38, 0x1B, 0xF9, 0x77, 0x38, 0x11,
  0xFD, 0x77, 0x48, 0x17, 0xF3, 0x76,
  // "ļ" (U+013C)
  0x40, 0x7E, 0x05, 0x40, 0x9E, 0x02, 0x60, 0x8B, 0x0E, 0x71, 0xB0, 0xB7, 0x01, 0xB0, 0x87, 0x04,
  0xB0, 0x57, 0x07, 0xB0, 0x17, 0x0A, 0xA0, 0xE7, 0x10, 0xDA, 0x0A, 0x70, 0x1B, 0x07, 0x70, 0x4B,
  0x04, 0x70, 0x8B, 0x01, 0x70, 0xBA, 0x0D, 0x71, 0x0E, 0xA0, 0x97, 0x02, 0xB0, 0x67, 0x05, 0xB0,
  0x37, 0x09, 0xB7, 0x10, 0xCA, 0x0C, 0x71, 0xB0, 0x97, 0x03, 0xB0, 0x57, 0x06, 0xB0, 0x27, 0x09,
  0xA0, 0xE7, 0x10, 0xCA, 0x0B, 0x71, 0xB0, 0x87, 0x03, 0xB0, 0x67, 0x05, 0xB0, 0x47, 0x07, 0xB0,
  0x27, 0x07, 0xB0, 0x27, 0x05, 0xB8, 0x26, 0x05, 0xC5, 0x0E, 0xD0, 0x95, 0x84, 0x3C, 0xFD, 0xA3,
  0x77, 0x77, 0x18, 0x23, 0x77, 0x67, 0x10, 0xAA, 0x08, 0x71, 0x81, 0xEF, 0xE7, 0x10, 0x5A, 0x04,
  0x71, 0x81, 0xBF, 0x97, 0x18, 0x11, 0xFD, 0x72, 0x81, 0x7F, 0x37, 0x20,
  // "Ľ" (U+013D)
  0x60, 0xCF, 0xA0, 0x82, 0x0A, 0xA0, 0x76, 0x0E, 0xFA, 0x05, 0x28, 0x1E, 0xFE, 0x71, 0x01, 0x09,
  0xC0, 0x90, 0x23, 0x05, 0xA0, 0x57, 0x20, 0x3B, 0x0C, 0x58, 0x1A, 0xFB, 0x73, 0x04, 0xB0, 0x74,
  0x82, 0x1F, 0xE2, 0x73, 0x07, 0xB0, 0x44, 0x81, 0x6F, 0x67, 0x40, 0xBB, 0x01, 0x40, 0x80, 0x97,
  0x50, 0xEA, 0x0D, 0x77, 0x40, 0x2B, 0x09, 0x77, 0x40, 0x5B, 0x06, 0x77, 0x40, 0x8B, 0x03, 0x77,
  0x40, 0xBB, 0x77, 0x50, 0xEA, 0x0C, 0x77, 0x40, 0x2B, 0x09, 0x77, 0x40, 0x6B, 0x05, 0x77, 0x40,
  0x9B, 0x02, 0x77, 0x40, 0xCA, 0x0E, 0x77, 0x5B, 0x0B, 0x77, 0x40, 0x3B, 0x08, 0x77, 0x40, 0x7B,
  0x05, 0x77, 0x40, 0xAB, 0x02, 0x72, 0x07, 0x09, 0x70, 0xDA, 0x0E, 0x72, 0x81, 0x1F, 0xC6, 0x01,
  0xB0, 0xB7, 0x28, 0x16, 0xF8, 0x60, 0x4B, 0x07, 0x72, 0x81, 0xCF, 0x56, 0x07, 0xB0, 0x47, 0x10,
  0x3A, 0x01, 0x60, 0xCB, 0x01, 0x71, 0x81, 0xCF, 0xD6, 0x07, 0xB0, 0xD7, 0x02, 0x0A, 0xA0, 0x93,
  0x81, 0x4A, 0xDD, 0x80, 0x2E, 0xD0, 0x53, 0x09, 0xFF, 0xC0, 0x13,
  // "ľ" (U+013E)
  0x20, 0x7E, 0x05, 0x20, 0xEA, 0x04, 0x20, 0x9E, 0x81, 0x20, 0x3A, 0x0C, 0x50, 0x8B, 0x0E, 0x20,
  0x8A, 0x03, 0x6B, 0x0B, 0x28, 0x1D, 0xF8, 0x60, 0x1B, 0x83, 0x80, 0x4F, 0xD7, 0x04, 0xB8, 0x35,
  0x0A, 0xF4, 0x70, 0x7B, 0x82, 0x10, 0xB7, 0x71, 0x0A, 0xA0, 0xE7, 0x50, 0xDA, 0x0A, 0x74, 0x01,
  0xB0, 0x77, 0x40, 0x4B, 0x04, 0x74, 0x08, 0xB0, 0x17, 0x40, 0xBA, 0x0D, 0x75, 0x0E, 0xA0, 0x97,
  0x40, 0x2B, 0x06, 0x74, 0x05, 0xB0, 0x37, 0x40, 0x9B, 0x75, 0x0C, 0xA0, 0xC7, 0x5B, 0x09, 0x74,
  0x03, 0xB0, 0x57, 0x40, 0x6B, 0x02, 0x74, 0x09, 0xA0, 0xE7, 0x50, 0xCA, 0x0B, 0x75, 0xB0, 0x87,
  0x40, 0x3B, 0x06, 0x74, 0x05, 0xB0, 0x47, 0x40, 0x7B, 0x02, 0x74, 0x07, 0xB0, 0x27, 0x40, 0x5B,
  0x82, 0x60, 0x5C, 0x72, 0x0E, 0xD0, 0x97, 0x28, 0x43, 0xCF, 0xDA, 0x37, 0x20,
  // "Ŀ" (U+013F)
  0x60, 0xCF, 0xA0, 0x87, 0x40, 0xEF, 0xA0, 0x57, 0x50, 0x10, 0x9C, 0x09, 0x02, 0x77, 0x10, 0x3B,
  0x0C, 0x77, 0x30, 0x4B, 0x07, 0x77, 0x30, 0x7B, 0x04, 0x77, 0x30, 0xBB, 0x01, 0x77, 0x30, 0xEA,
  0x0D, 0x77, 0x30, 0x2B, 0x09, 0x77, 0x30, 0x5B, 0x06, 0x77, 0x30, 0x8B, 0x03, 0x77, 0x30, 0xBB,
  0x78, 0x29, 0xEC, 0x17, 0x0E, 0xA0, 0xC6, 0x06, 0xB0, 0x86, 0x02, 0xB0, 0x96, 0x09, 0xB0, 0x96,
  0x06, 0xB0, 0x56, 0x09, 0xB0, 0x66, 0x09, 0xB0, 0x26, 0x82, 0x2C, 0xE9, 0x70, 0xCA, 0x0E, 0x77,
  0x4B, 0x0B, 0x77, 0x30, 0x3B, 0x08, 0x77, 0x30, 0x7B, 0x05, 0x77, 0x30, 0xAB, 0x02, 0x72, 0x07,
  0x09, 0x60, 0xDA, 0x0E, 0x72, 0x81, 0x1F, 0xC5, 0x01, 0xB0, 0xB7, 0x28, 0x16, 0xF8, 0x50, 0x4B,
  0x07, 0x72, 0x81, 0xCF, 0x55, 0x07, 0xB0, 0x47, 0x10, 0x3A, 0x01, 0x50, 0xCB, 0x01, 0x71, 0x81,
  0xCF, 0xD5, 0x07, 0xB0, 0xD7, 0x02, 0x0A, 0xA0, 0x92, 0x81, 0x4A, 0xDD, 0x80, 0x2E, 0xD0, 0x52,
  0x09, 0xFF, 0xC0, 0x12,
  // "ŀ" (U+0140)
  0x20, 0x7E, 0x05, 0x60, 0x9E, 0x02, 0x71, 0x08, 0xB0, 0xE7, 0x3B, 0x0B, 0x72, 0x01, 0xB0, 0x87,
  0x20, 0x4B, 0x05, 0x72, 0x07, 0xB0, 0x17, 0x20, 0xAA, 0x0E, 0x73, 0x0D, 0xA0, 0xA7, 0x20, 0x1B,
  0x07, 0x72, 0x04, 0xB0, 0x47, 0x20, 0x8B, 0x01, 0x72, 0x0B, 0xA0, 0xD7, 0x30, 0xEA, 0x09, 0x72,
  0x02, 0xB0, 0x63, 0x82, 0x9E, 0xC1, 0x20, 0x5B, 0x03, 0x20, 0x6B, 0x08, 0x20, 0x9B, 0x30, 0x9B,
  0x09, 0x20, 0xCA, 0x0C, 0x30, 0x9B, 0x06, 0x2B, 0x09, 0x38, 0x22, 0xCE, 0x92, 0x03, 0xB0, 0x57,
  0x20, 0x6B, 0x02, 0x72, 0x09, 0xA0, 0xE7, 0x30, 0xCA, 0x0B, 0x73, 0xB0, 0x87, 0x20, 0x3B, 0x06,
  0x72, 0x05, 0xB0, 0x47, 0x20, 0x7B, 0x02, 0x72, 0x07, 0xB0, 0x27, 0x20, 0x5B, 0x82, 0x60, 0x5C,
  0x70, 0xED, 0x09, 0x78, 0x43, 0xCF, 0xDA, 0x37,
  // "Ł" (U+0141)
  0x60, 0xCF, 0xA0, 0x87, 0x30, 0xEF, 0xA0, 0x57, 0x40, 0x10, 0x9C, 0x09, 0x02, 0x77, 0x03, 0xB0,
  0xC7, 0x72, 0x04, 0xB0, 0x77, 0x72, 0x07, 0xB0, 0x47, 0x72, 0x0B, 0xB0, 0x17, 0x72, 0x0E, 0xA0,
  0xD7, 0x72, 0x02, 0xB0, 0x97, 0x72, 0x05, 0xB0, 0x67, 0x72, 0x08, 0xB0, 0x32, 0x81, 0x18, 0x67,
  0x40, 0xCB, 0x18, 0x31, 0x8E, 0xF4, 0x74, 0x0E, 0xA8, 0x4D, 0x7E, 0xFE, 0x77, 0x40, 0x3D, 0x81,
  0xE8, 0x17, 0x50, 0x6C, 0x09, 0x01, 0x76, 0x07, 0x0E, 0xB0, 0x37, 0x60, 0x60, 0xEC, 0x0E, 0x76,
  0x08, 0xA0, 0x9B, 0x0B, 0x76, 0x82, 0xB9, 0x13, 0xB0, 0x87, 0x60, 0x12, 0x07, 0xB0, 0x57, 0x72,
  0x0A, 0xB0, 0x27, 0x20, 0x70, 0x95, 0x0D, 0xA0, 0xE7, 0x28, 0x11, 0xFC, 0x40, 0x1B, 0x0B, 0x72,
  0x81, 0x6F, 0x84, 0x04, 0xB0, 0x77, 0x28, 0x1C, 0xF5, 0x40, 0x7B, 0x04, 0x71, 0x03, 0xA0, 0x14,
  0x0C, 0xB0, 0x17, 0x18, 0x1C, 0xFD, 0x40, 0x7B, 0x0D, 0x70, 0x20, 0xAA, 0x83, 0x90, 0x4A, 0xDD,
  0x80, 0x2E, 0xD8, 0x15, 0x09, 0xFF, 0xC0, 0x11,
  // "ł" (U+0142)
  0x40, 0x7E, 0x05, 0x40, 0x9E, 0x02, 0x60, 0x8B, 0x0E, 0x71, 0xB0, 0xB7, 0x01, 0xB0, 0x87, 0x03,
  0xB0, 0x57, 0x07, 0xB0, 0x27, 0x0A, 0xA0, 0xE7, 0x10, 0xDA, 0x0B, 0x70, 0x1B, 0x08, 0x70, 0x4B,
  0x04, 0x70, 0x7B, 0x01, 0x70, 0xAA, 0x0D, 0x71, 0x0D, 0xA0, 0xA2, 0x02, 0x40, 0x1B, 0x82, 0x72,
  0x9D, 0x40, 0x4B, 0x0C, 0xA0, 0xA4, 0x07, 0xC0, 0xD0, 0x64, 0x01, 0x0C, 0xA0, 0xE0, 0x64, 0x81,
  0x18, 0xEB, 0x09, 0x40, 0x20, 0xED, 0x06, 0x48, 0x26, 0xE8, 0x7B, 0x03, 0x48, 0x23, 0x10, 0x9B,
  0x71, 0x0C, 0xA0, 0xC7, 0x10, 0xEA, 0x09, 0x70, 0x2B, 0x06, 0x70, 0x5B, 0x04, 0x70, 0x7B, 0x02,
  0x70, 0x7B, 0x02, 0x70, 0x5B, 0x82, 0x60, 0x5C, 0x50, 0xED, 0x09, 0x58, 0x43, 0xCF, 0xDA, 0x33,
  // "Ń" (U+0143)
  0x77, 0x68, 0x34, 0x77, 0x73, 0x77, 0x74, 0x01, 0x0E, 0xA0, 0xD0, 0x17, 0x77, 0x40, 0xAA, 0x0E,
  0x02, 0x77, 0x74, 0x04, 0xA0, 0xE0, 0x27, 0x77, 0x48, 0x31, 0xDF, 0xE2, 0x77, 0x75, 0x82, 0xAF,
  0xD2, 0x77, 0x75, 0x82, 0x5F, 0xA1, 0x80, 0x99, 0x30, 0x0C, 0xD0, 0xE7, 0x10, 0x2F, 0x90, 0x76,
  0x0E, 0xE0, 0x47, 0x05, 0xF9, 0x04, 0x70, 0x10, 0x9C, 0x09, 0x72, 0x03, 0x0D, 0xA0, 0x90, 0x27,
  0x30, 0x3C, 0x0E, 0x73, 0x81, 0x9F, 0xC7, 0x50, 0x4D, 0x04, 0x72, 0x81, 0xBF, 0x77, 0x58, 0x17,
  0xFB, 0xB0, 0xA7, 0x28, 0x1E, 0xF3, 0x75, 0x82, 0xBF, 0x5C, 0xA0, 0xE7, 0x10, 0x2A, 0x76, 0x82,
  0xEF, 0x27, 0xB0, 0x47, 0x81, 0x6F, 0xC7, 0x58, 0x32, 0xFE, 0x01, 0xB0, 0xA7, 0x81, 0x9F, 0x97,
  0x58, 0x15, 0xFB, 0x20, 0xCA, 0x0E, 0x78, 0x1C, 0xF6, 0x75, 0x81, 0x8F, 0x82, 0x06, 0xB0, 0x56,
  0xA0, 0x27, 0x58, 0x1C, 0xF4, 0x20, 0x1B, 0x0A, 0x58, 0x13, 0xFE, 0x76, 0xA0, 0x13, 0x0B, 0xA0,
  0xE5, 0x81, 0x6F, 0xB7, 0x58, 0x13, 0xFD, 0x40, 0x6B, 0x05, 0x48, 0x19, 0xF8, 0x75, 0x81, 0x6F,
  0xA4, 0x01, 0xB0, 0xA4, 0x81, 0xDF, 0x57, 0x58, 0x19, 0xF7, 0x50, 0xBA, 0x0E, 0x30, 0x1A, 0x01,
  0x75, 0x81, 0xDF, 0x45, 0x06, 0xB0, 0x52, 0x81, 0x4F, 0xE7, 0x50, 0x1A, 0x60, 0x1B, 0x0A, 0x28,
  0x17, 0xFA, 0x75, 0x81, 0x4F, 0xD7, 0x0B, 0xB2, 0x81, 0xAF, 0x77, 0x58, 0x17, 0xF9, 0x70, 0x5B,
  0x83, 0x50, 0xDF, 0x47, 0x58, 0x1B, 0xF6, 0x71, 0xB0, 0xA0, 0x1A, 0x01, 0x75, 0x81, 0xEF, 0x37,
  0x10, 0xAB, 0x81, 0x5F, 0xD7, 0x50, 0x2A, 0x72, 0x05, 0xB8, 0x1D, 0xFA, 0x75, 0x81, 0x5F, 0xC7,
  0x30, 0xEC, 0x06, 0x75, 0x81, 0x9F, 0x97, 0x30, 0xAC, 0x03, 0x75, 0x81, 0xEF, 0x87, 0x30, 0x5C,
  0x74, 0x03, 0x0B, 0xA0, 0xC0, 0x27, 0x30, 0xEA, 0x0C, 0x72, 0x06, 0xF9, 0x02, 0x71, 0x09, 0xA0,
  0x97, 0x20, 0x9F, 0x0E, 0x72, 0x04, 0xA0, 0x57, 0x20,
  // "ń" (U+0144)
  0x77, 0x83, 0x47, 0x77, 0x37, 0x70, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x0A, 0xA0, 0xE0, 0x27, 0x70,
  0x4A, 0x0E, 0x02, 0x77, 0x83, 0x1D, 0xFE, 0x27, 0x71, 0x82, 0xAF, 0xD2, 0x77, 0x18, 0x25, 0xFA,
  0x18, 0x0D, 0x30, 0x02, 0xE0, 0x42, 0x84, 0x4A, 0xEF, 0xC4, 0x40, 0x5E, 0x81, 0x10, 0x8E, 0x02,
  0x50, 0x7B, 0x85, 0xE0, 0x8D, 0x40, 0x4B, 0x09, 0x60, 0xEA, 0x82, 0xB5, 0xE2, 0x30, 0xEA, 0x0C,
  0x6B, 0x81, 0xCE, 0x34, 0x0D, 0xA0, 0xD5, 0x02, 0xC0, 0x85, 0xB0, 0xC5, 0x05, 0xB0, 0xE0, 0x14,
  0x01, 0xB0, 0x95, 0x09, 0xB0, 0x75, 0x04, 0xB0, 0x65, 0x0C, 0xB0, 0x15, 0x07, 0xB0, 0x35, 0xB0,
  0xA6, 0x0A, 0xB5, 0x03, 0xB0, 0x66, 0x0E, 0xA0, 0xC5, 0x06, 0xB0, 0x25, 0x02, 0xB0, 0x95, 0x09,
  0xA0, 0xE6, 0x05, 0xB0, 0x65, 0x0C, 0xA0, 0xB6, 0x08, 0xB0, 0x25, 0xB0, 0x86, 0x0B, 0xB5, 0x03,
  0xB0, 0x56, 0x0E, 0xA0, 0xC5, 0x06, 0xB0, 0x16, 0xB0, 0x95, 0x09, 0xA0, 0xE6, 0x01, 0xB0, 0x85,
  0x0D, 0xA0, 0xB6, 0x01, 0xB0, 0x85, 0xB0, 0x77, 0x0E, 0xA8, 0x4C, 0x02, 0xA1, 0x3B, 0x04, 0x70,
  0x7D, 0x81, 0xD3, 0x7B, 0x01, 0x71, 0x83, 0x9E, 0xEC, 0x62,
  // "Ņ" (U+0145)
  0x60, 0xCD, 0x0E, 0x71, 0x02, 0xF9, 0x07, 0x60, 0xEE, 0x04, 0x70, 0x5F, 0x90, 0x47, 0x01, 0x09,
  0xC0, 0x97, 0x20, 0x30, 0xDA, 0x09, 0x02, 0x73, 0x03, 0xC0, 0xE7, 0x38, 0x19, 0xFC, 0x75, 0x04,
  0xD0, 0x47, 0x28, 0x1B, 0xF7, 0x75, 0x81, 0x7F, 0xBB, 0x0A, 0x72, 0x81, 0xEF, 0x37, 0x58, 0x2B,
  0xF5, 0xCA, 0x0E, 0x71, 0x02, 0xA7, 0x68, 0x2E, 0xF2, 0x7B, 0x04, 0x78, 0x16, 0xFC, 0x75, 0x83,
  0x2F, 0xE0, 0x1B, 0x0A, 0x78, 0x19, 0xF9, 0x75, 0x81, 0x5F, 0xB2, 0x0C, 0xA0, 0xE7, 0x81, 0xCF,
  0x67, 0x58, 0x18, 0xF8, 0x20, 0x6B, 0x05, 0x6A, 0x02, 0x75, 0x81, 0xCF, 0x42, 0x01, 0xB0, 0xA5,
  0x81, 0x3F, 0xE7, 0x6A, 0x01, 0x30, 0xBA, 0x0E, 0x58, 0x16, 0xFB, 0x75, 0x81, 0x3F, 0xD4, 0x06,
  0xB0, 0x54, 0x81, 0x9F, 0x87, 0x58, 0x16, 0xFA, 0x40, 0x1B, 0x0A, 0x48, 0x1D, 0xF5, 0x75, 0x81,
  0x9F, 0x75, 0x0B, 0xA0, 0xE3, 0x01, 0xA0, 0x17, 0x58, 0x1D, 0xF4, 0x50, 0x6B, 0x05, 0x28, 0x14,
  0xFE, 0x75, 0x01, 0xA6, 0x01, 0xB0, 0xA2, 0x81, 0x7F, 0xA7, 0x58, 0x14, 0xFD, 0x70, 0xBB, 0x28,
  0x1A, 0xF7, 0x75, 0x81, 0x7F, 0x97, 0x05, 0xB8, 0x35, 0x0D, 0xF4, 0x75, 0x81, 0xBF, 0x67, 0x1B,
  0x0A, 0x01, 0xA0, 0x17, 0x58, 0x1E, 0xF3, 0x71, 0x0A, 0xB8, 0x15, 0xFD, 0x75, 0x02, 0xA7, 0x20,
  0x5B, 0x81, 0xDF, 0xA7, 0x58, 0x15, 0xFC, 0x73, 0x0E, 0xC0, 0x67, 0x58, 0x19, 0xF9, 0x73, 0x0A,
  0xC0, 0x37, 0x58, 0x1E, 0xF8, 0x73, 0x05, 0xC7, 0x40, 0x30, 0xBA, 0x0C, 0x02, 0x73, 0x0E, 0xA0,
  0xC7, 0x20, 0x6F, 0x90, 0x27, 0x10, 0x9A, 0x09, 0x72, 0x09, 0xF0, 0xE7, 0x20, 0x4A, 0x05, 0x80,
  0x99, 0x50, 0x82, 0x37, 0x76, 0x77, 0x76, 0x0A, 0xA0, 0x87, 0x77, 0x68, 0x1E, 0xFE, 0x77, 0x76,
  0x05, 0xA0, 0x47, 0x77, 0x68, 0x1B, 0xF9, 0x77, 0x76, 0x81, 0x1F, 0xD7, 0x77, 0x78, 0x17, 0xF3,
  0x77, 0x60,
  // "ņ" (U+0146)
  0x10, 0x2E, 0x04, 0x28, 0x44, 0xAE, 0xFC, 0x44, 0x05, 0xE8, 0x11, 0x08, 0xE0, 0x25, 0x07, 0xB8,
  0x5E, 0x08, 0xD4, 0x04, 0xB0, 0x96, 0x0E, 0xA8, 0x2B, 0x5E, 0x23, 0x0E, 0xA0, 0xC6, 0xB8, 0x1C,
  0xE3, 0x40, 0xDA, 0x0D, 0x50, 0x2C, 0x08, 0x5B, 0x0C, 0x50, 0x5B, 0x0E, 0x01, 0x40, 0x1B, 0x09,
  0x50, 0x9B, 0x07, 0x50, 0x4B, 0x06, 0x50, 0xCB, 0x01, 0x50, 0x7B, 0x03, 0x5B, 0x0A, 0x60, 0xAB,
  0x50, 0x3B, 0x06, 0x60, 0xEA, 0x0C, 0x50, 0x6B, 0x02, 0x50, 0x2B, 0x09, 0x50, 0x9A, 0x0E, 0x60,
  0x5B, 0x06, 0x50, 0xCA, 0x0B, 0x60, 0x8B, 0x02, 0x5B, 0x08, 0x60, 0xBB, 0x50, 0x3B, 0x05, 0x60,
  0xEA, 0x0C, 0x50, 0x6B, 0x01, 0x6B, 0x09, 0x50, 0x9A, 0x0E, 0x60, 0x1B, 0x08, 0x50, 0xDA, 0x0B,
  0x60, 0x1B, 0x08, 0x5B, 0x07, 0x70, 0xEA, 0x84, 0xC0, 0x2A, 0x13, 0xB0, 0x47, 0x07, 0xD8, 0x1D,
  0x37, 0xB0, 0x17, 0x18, 0x39, 0xEE, 0xC6, 0x80, 0xD3, 0x08, 0x23, 0x77, 0x67, 0x72, 0x0A, 0xA0,
  0x87, 0x72, 0x81, 0xEF, 0xE7, 0x72, 0x05, 0xA0, 0x47, 0x72, 0x81, 0xBF, 0x97, 0x72, 0x81, 0x1F,
  0xD7, 0x73, 0x81, 0x7F, 0x37, 0x70,
  // "Ň" (U+0147)
  0x77, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x75, 0x82, 0x1F, 0xE2, 0x48, 0x19, 0xFB, 0x77, 0x78,
  0x19, 0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x77, 0x70, 0x3A, 0x84, 0x61, 0xDF, 0xE2, 0x77, 0x72, 0x82,
  0xCF, 0xED, 0xA0, 0x47, 0x77, 0x30, 0x7C, 0x07, 0x77, 0x74, 0x03, 0xB0, 0xC8, 0x09, 0x92, 0x00,
  0xCD, 0x0E, 0x71, 0x02, 0xF9, 0x07, 0x60, 0xEE, 0x04, 0x70, 0x5F, 0x90, 0x47, 0x01, 0x09, 0xC0,
  0x97, 0x20, 0x30, 0xDA, 0x09, 0x02, 0x73, 0x03, 0xC0, 0xE7, 0x38, 0x19, 0xFC, 0x75, 0x04, 0xD0,
  0x47, 0x28, 0x1B, 0xF7, 0x75, 0x81, 0x7F, 0xBB, 0x0A, 0x72, 0x81, 0xEF, 0x37, 0x58, 0x2B, 0xF5,
  0xCA, 0x0E, 0x71, 0x02, 0xA7, 0x68, 0x2E, 0xF2, 0x7B, 0x04, 0x78, 0x16, 0xFC, 0x75, 0x83, 0x2F,
  0xE0, 0x1B, 0x0A, 0x78, 0x19, 0xF9, 0x75, 0x81, 0x5F, 0xB2, 0x0C, 0xA0, 0xE7, 0x81, 0xCF, 0x67,
  0x58, 0x18, 0xF8, 0x20, 0x6B, 0x05, 0x6A, 0x02, 0x75, 0x81, 0xCF, 0x42, 0x01, 0xB0, 0xA5, 0x81,
  0x3F, 0xE7, 0x6A, 0x01, 0x30, 0xBA, 0x0E, 0x58, 0x16, 0xFB, 0x75, 0x81, 0x3F, 0xD4, 0x06, 0xB0,
  0x54, 0x81, 0x9F, 0x87, 0x58, 0x16, 0xFA, 0x40, 0x1B, 0x0A, 0x48, 0x1D, 0xF5, 0x75, 0x81, 0x9F,
  0x75, 0x0B, 0xA0, 0xE3, 0x01, 0xA0, 0x17, 0x58, 0x1D, 0xF4, 0x50, 0x6B, 0x05, 0x28, 0x14, 0xFE,
  0x75, 0x01, 0xA6, 0x01, 0xB0, 0xA2, 0x81, 0x7F, 0xA7, 0x58, 0x14, 0xFD, 0x70, 0xBB, 0x28, 0x1A,
  0xF7, 0x75, 0x81, 0x7F, 0x97, 0x05, 0xB8, 0x35, 0x0D, 0xF4, 0x75, 0x81, 0xBF, 0x67, 0x1B, 0x0A,
  0x01, 0xA0, 0x17, 0x58, 0x1E, 0xF3, 0x71, 0x0A, 0xB8, 0x15, 0xFD, 0x75, 0x02, 0xA7, 0x20, 0x5B,
  0x81, 0xDF, 0xA7, 0x58, 0x15, 0xFC, 0x73, 0x0E, 0xC0, 0x67, 0x58, 0x19, 0xF9, 0x73, 0x0A, 0xC0,
  0x37, 0x58, 0x1E, 0xF8, 0x73, 0x05, 0xC7, 0x40, 0x30, 0xBA, 0x0C, 0x02, 0x73, 0x0E, 0xA0, 0xC7,
  0x20, 0x6F, 0x90, 0x27, 0x10, 0x9A, 0x09, 0x72, 0x09, 0xF0, 0xE7, 0x20, 0x4A, 0x05, 0x72,
  // "ň" (U+0148)
  0x71, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x18, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x38, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x73, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x58, 0x2C, 0xFE, 0xDA,
  0x04, 0x76, 0x07, 0xC0, 0x77, 0x70, 0x3B, 0x0C, 0x80, 0xD2, 0x00, 0x2E, 0x04, 0x28, 0x44, 0xAE,
  0xFC, 0x44, 0x05, 0xE8, 0x11, 0x08, 0xE0, 0x25, 0x07, 0xB8, 0x5E, 0x08, 0xD4, 0x04, 0xB0, 0x96,
  0x0E, 0xA8, 0x2B, 0x5E, 0x23, 0x0E, 0xA0, 0xC6, 0xB8, 0x1C, 0xE3, 0x40, 0xDA, 0x0D, 0x50, 0x2C,
  0x08, 0x5B, 0x0C, 0x50, 0x5B, 0x0E, 0x01, 0x40, 0x1B, 0x09, 0x50, 0x9B, 0x07, 0x50, 0x4B, 0x06,
  0x50, 0xCB, 0x01, 0x50, 0x7B, 0x03, 0x5B, 0x0A, 0x60, 0xAB, 0x50, 0x3B, 0x06, 0x60, 0xEA, 0x0C,
  0x50, 0x6B, 0x02, 0x50, 0x2B, 0x09, 0x50, 0x9A, 0x0E, 0x60, 0x5B, 0x06, 0x50, 0xCA, 0x0B, 0x60,
  0x8B, 0x02, 0x5B, 0x08, 0x60, 0xBB, 0x50, 0x3B, 0x05, 0x60, 0xEA, 0x0C, 0x50, 0x6B, 0x01, 0x6B,
  0x09, 0x50, 0x9A, 0x0E, 0x60, 0x1B, 0x08, 0x50, 0xDA, 0x0B, 0x60, 0x1B, 0x08, 0x5B, 0x07, 0x70,
  0xEA, 0x84, 0xC0, 0x2A, 0x13, 0xB0, 0x47, 0x07, 0xD8, 0x1D, 0x37, 0xB0, 0x17, 0x18, 0x39, 0xEE,
  0xC6, 0x20,
  // "ŉ" (U+0149)
  0x28, 0x31, 0xBE, 0xA1, 0x77, 0x70, 0x9B, 0x0A, 0x77, 0x70, 0xBB, 0x0E, 0x77, 0x70, 0x6C, 0x77,
  0x71, 0x05, 0xA0, 0xD7, 0x77, 0x28, 0x1C, 0xF9, 0x77, 0x72, 0x81, 0xEF, 0x27, 0x77, 0x18, 0x39,
  0xF8, 0x02, 0xE0, 0x42, 0x84, 0x4A, 0xEF, 0xC4, 0x48, 0x26, 0xCF, 0x92, 0x05, 0xE8, 0x11, 0x08,
  0xE0, 0x22, 0x82, 0x5F, 0xC4, 0x50, 0x7B, 0x85, 0xE0, 0x8D, 0x40, 0x4B, 0x09, 0x20, 0x02, 0x71,
  0x0E, 0xA8, 0x2B, 0x5E, 0x23, 0x0E, 0xA0, 0xC7, 0x5B, 0x81, 0xCE, 0x34, 0x0D, 0xA0, 0xD7, 0x40,
  0x2C, 0x08, 0x5B, 0x0C, 0x74, 0x05, 0xB0, 0xE0, 0x14, 0x01, 0xB0, 0x97, 0x40, 0x9B, 0x07, 0x50,
  0x4B, 0x06, 0x74, 0x0C, 0xB0, 0x15, 0x07, 0xB0, 0x37, 0x4B, 0x0A, 0x60, 0xAB, 0x74, 0x03, 0xB0,
  0x66, 0x0E, 0xA0, 0xC7, 0x40, 0x6B, 0x02, 0x50, 0x2B, 0x09, 0x74, 0x09, 0xA0, 0xE6, 0x05, 0xB0,
  0x67, 0x40, 0xCA, 0x0B, 0x60, 0x8B, 0x02, 0x74, 0xB0, 0x86, 0x0B, 0xB7, 0x40, 0x3B, 0x05, 0x60,
  0xEA, 0x0C, 0x74, 0x06, 0xB0, 0x16, 0xB0, 0x97, 0x40, 0x9A, 0x0E, 0x60, 0x1B, 0x08, 0x74, 0x0D,
  0xA0, 0xB6, 0x01, 0xB0, 0x87, 0x4B, 0x07, 0x70, 0xEA, 0x83, 0xC0, 0x2A, 0x16, 0x03, 0xB0, 0x47,
  0x07, 0xD0, 0xD0, 0x36, 0x07, 0xB0, 0x17, 0x18, 0x39, 0xEE, 0xC6, 0x20,
  // "Ŋ" (U+014A)
  0x60, 0xCD, 0x0E, 0x71, 0x02, 0xF9, 0x07, 0x60, 0xEE, 0x04, 0x70, 0x5F, 0x90, 0x47, 0x01, 0x09,
  0xC0, 0x97, 0x20, 0x30, 0xDA, 0x09, 0x02, 0x73, 0x03, 0xC0, 0xE7, 0x38, 0x19, 0xFC, 0x75, 0x04,
  0xD0, 0x47, 0x28, 0x1B, 0xF7, 0x75, 0x81, 0x7F, 0xBB, 0x0A, 0x72, 0x81, 0xEF, 0x37, 0x58, 0x2B,
  0xF5, 0xCA, 0x0E, 0x71, 0x02, 0xA7, 0x68, 0x2E, 0xF2, 0x7B, 0x04, 0x78, 0x15, 0xFC, 0x75, 0x83,
  0x2F, 0xE0, 0x1B, 0x0A, 0x78, 0x19, 0xF9, 0x75, 0x81, 0x5F, 0xB2, 0x0C, 0xA0, 0xE7, 0x81, 0xCF,
  0x67, 0x58, 0x19, 0xF8, 0x20, 0x6B, 0x05, 0x6A, 0x03, 0x75, 0x81, 0xCF, 0x52, 0x01, 0xB0, 0xA5,
  0x03, 0xA7, 0x6A, 0x01, 0x30, 0xBA, 0x0E, 0x58, 0x16, 0xFC, 0x75, 0x81, 0x3F, 0xE4, 0x06, 0xB0,
  0x54, 0x81, 0x9F, 0x87, 0x58, 0x16, 0xFA, 0x40, 0x1B, 0x0A, 0x48, 0x1D, 0xF5, 0x75, 0x81, 0xAF,
  0x75, 0x0B, 0xA0, 0xE4, 0xA0, 0x27, 0x58, 0x1D, 0xF4, 0x50, 0x6B, 0x05, 0x28, 0x14, 0xFE, 0x75,
  0x01, 0xA0, 0x15, 0x01, 0xB0, 0xA2, 0x81, 0x7F, 0xB7, 0x58, 0x14, 0xFD, 0x70, 0xBB, 0x28, 0x1A,
  0xF8, 0x75, 0x81, 0x7F, 0xA7, 0x05, 0xB8, 0x35, 0x0D, 0xF4, 0x75, 0x81, 0xBF, 0x67, 0x01, 0xB0,
  0xA0, 0x1A, 0x01, 0x75, 0x81, 0xEF, 0x37, 0x10, 0xAB, 0x81, 0x5F, 0xD7, 0x50, 0x2A, 0x72, 0x05,
  0xB8, 0x1D, 0xFA, 0x75, 0x81, 0x5F, 0xC7, 0x3D, 0x07, 0x75, 0x81, 0x9F, 0x97, 0x30, 0xAC, 0x04,
  0x75, 0x81, 0xEF, 0x77, 0x30, 0x5C, 0x01, 0x73, 0x03, 0x0B, 0xA0, 0xC0, 0x27, 0x30, 0xEA, 0x0D,
  0x72, 0x06, 0xF9, 0x02, 0x71, 0x0A, 0xA0, 0xA7, 0x20, 0x9F, 0x97, 0x20, 0x4A, 0x06, 0x77, 0x76,
  0x01, 0xA0, 0x37, 0x77, 0x68, 0x15, 0xFE, 0x77, 0x77, 0x81, 0x9F, 0xB7, 0x77, 0x78, 0x1E, 0xF6,
  0x77, 0x76, 0x07, 0xA0, 0x17, 0x77, 0x58, 0x22, 0xEF, 0xA7, 0x77, 0x50, 0x10, 0xCA, 0x02, 0x77,
  0x71, 0x02, 0x20, 0x50, 0xDA, 0x06, 0x77, 0x71, 0x02, 0xE0, 0x67, 0x77, 0x28, 0x53, 0xCE, 0xED,
  0x82, 0x77,
  // "ŋ" (U+014B)
  0x10, 0x2E, 0x04, 0x28, 0x44, 0xBE, 0xFC, 0x42, 0x05, 0xE8, 0x11, 0x08, 0xE0, 0x23, 0x06, 0xB8,
  0x5E, 0x09, 0xD4, 0x05, 0xB0, 0x94, 0x0E, 0xA8, 0x2B, 0x7E, 0x23, 0x0E, 0xA0, 0xC4, 0xB8, 0x1C,
  0xF3, 0x40, 0xDA, 0x0D, 0x30, 0x2C, 0x08, 0x50, 0xEA, 0x0C, 0x30, 0x5B, 0x0E, 0x01, 0x40, 0x1B,
  0x09, 0x30, 0x8B, 0x07, 0x50, 0x4B, 0x06, 0x30, 0xBB, 0x01, 0x50, 0x7B, 0x03, 0x30, 0xEA, 0x0A,
  0x60, 0xAB, 0x30, 0x2B, 0x05, 0x60, 0xDA, 0x0D, 0x30, 0x6B, 0x01, 0x50, 0x1B, 0x09, 0x30, 0x9A,
  0x0E, 0x60, 0x4B, 0x06, 0x30, 0xCA, 0x0B, 0x60, 0x7B, 0x03, 0x3B, 0x07, 0x60, 0xAB, 0x30, 0x3B,
  0x04, 0x60, 0xDA, 0x0C, 0x30, 0x6B, 0x01, 0x50, 0x1B, 0x09, 0x30, 0x9A, 0x0E, 0x60, 0x4B, 0x05,
  0x30, 0xDA, 0x0A, 0x60, 0x7B, 0x02, 0x3B, 0x07, 0x60, 0xAA, 0x0E, 0x30, 0x3B, 0x04, 0x60, 0xEA,
  0x0B, 0x30, 0x7B, 0x01, 0x50, 0x1B, 0x08, 0x76, 0x04, 0xB0, 0x47, 0x60, 0x8B, 0x01, 0x76, 0x0C,
  0xA0, 0xD7, 0x60, 0x1B, 0x08, 0x76, 0x05, 0xB0, 0x37, 0x60, 0xBA, 0x0C, 0x76, 0x04, 0xB0, 0x47,
  0x50, 0x40, 0xEA, 0x09, 0x73, 0x08, 0xD0, 0xA7, 0x48, 0x48, 0xEF, 0xDA, 0x47, 0x10,
  // "Ō" (U+014C)
  0x73, 0x01, 0x80, 0x5E, 0x0C, 0x76, 0x05, 0xFA, 0x09, 0x80, 0xF1, 0x08, 0x73, 0x8C, 0xEF, 0xEC,
  0x82, 0x76, 0x03, 0x0C, 0xFA, 0x08, 0x74, 0x08, 0xB0, 0x90, 0x32, 0x02, 0x08, 0xB0, 0xB7, 0x20,
  0xAA, 0x0E, 0x04, 0x60, 0x5B, 0x08, 0x70, 0xAB, 0x03, 0x71, 0x0A, 0xB0, 0x25, 0x06, 0xB0, 0x67,
  0x20, 0x3B, 0x09, 0x40, 0x3B, 0x0B, 0x74, 0xB0, 0xD4, 0x0B, 0xB0, 0x37, 0x40, 0xCB, 0x01, 0x20,
  0x5B, 0x0A, 0x75, 0x0B, 0xB0, 0x42, 0x0C, 0xB0, 0x47, 0x50, 0xBB, 0x81, 0x50, 0x3B, 0x0D, 0x76,
  0x0C, 0xB8, 0x15, 0x09, 0xB0, 0x87, 0x60, 0xDB, 0x81, 0x40, 0xEB, 0x04, 0x76, 0xC0, 0x03, 0xC7,
  0x60, 0x2C, 0x10, 0x6B, 0x0C, 0x76, 0x05, 0xB8, 0x1D, 0x09, 0xB0, 0x97, 0x60, 0x8B, 0x81, 0xA0,
  0xBB, 0x07, 0x76, 0x0C, 0xB8, 0x15, 0x0C, 0xB0, 0x57, 0x50, 0x1C, 0x81, 0x10, 0xDB, 0x04, 0x75,
  0x06, 0xB0, 0xA2, 0x0D, 0xB0, 0x37, 0x50, 0xCB, 0x03, 0x20, 0xBB, 0x03, 0x74, 0x02, 0xB0, 0xC3,
  0x09, 0xB0, 0x47, 0x40, 0xAB, 0x03, 0x30, 0x5B, 0x07, 0x73, 0x03, 0xB0, 0x94, 0x01, 0xB0, 0xB7,
  0x30, 0xDA, 0x0D, 0x60, 0x9B, 0x02, 0x71, 0x0A, 0xA0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xC7, 0x0B,
  0xA0, 0xE0, 0x37, 0x10, 0x30, 0xEA, 0x0D, 0x05, 0x28, 0x11, 0x6D, 0xA0, 0xC0, 0x27, 0x30, 0x20,
  0xCF, 0xA0, 0x77, 0x78, 0x15, 0xAD, 0xA8, 0x2D, 0xB6, 0x17, 0x30,
  // "ō" (U+014D)
  0x60, 0x18, 0x05, 0xE0, 0xC7, 0x05, 0xFA, 0x09, 0x80, 0xD0, 0x08, 0x61, 0x7B, 0xEF, 0xDA, 0x47,
  0x20, 0x50, 0xEF, 0x09, 0x70, 0x8A, 0x0D, 0x05, 0x20, 0x5B, 0x08, 0x50, 0x7A, 0x0D, 0x01, 0x40,
  0x7B, 0x02, 0x30, 0x4B, 0x03, 0x50, 0x1B, 0x08, 0x30, 0xDA, 0x09, 0x70, 0xEA, 0x0B, 0x20, 0x6B,
  0x02, 0x70, 0xDA, 0x0D, 0x20, 0xDA, 0x0C, 0x71, 0x0D, 0xA8, 0x1E, 0x04, 0xB0, 0x77, 0x10, 0xEA,
  0x81, 0xE0, 0x9B, 0x03, 0x71, 0xB8, 0x1D, 0x0D, 0xB7, 0x10, 0x2B, 0x0A, 0x1B, 0x0C, 0x71, 0x04,
  0xB0, 0x70, 0x2B, 0x0A, 0x71, 0x08, 0xB0, 0x30, 0x4B, 0x08, 0x71, 0x0C, 0xA8, 0x1E, 0x04, 0xB0,
  0x77, 0x01, 0xB8, 0x18, 0x03, 0xB0, 0x77, 0x07, 0xB8, 0x12, 0x01, 0xB0, 0x87, 0x0E, 0xA0, 0x93,
  0x0D, 0xA0, 0xB6, 0x08, 0xA0, 0xD0, 0x13, 0x07, 0xB0, 0x24, 0x04, 0xB0, 0x35, 0x0D, 0xA8, 0x3D,
  0x30, 0x17, 0xB0, 0x46, 0x02, 0x0D, 0xF0, 0xC0, 0x37, 0x28, 0x57, 0xCE, 0xED, 0xA5, 0x70,
  // "Ŏ" (U+014E)
  0x73, 0x81, 0x37, 0x25, 0x81, 0x17, 0x47, 0x68, 0x15, 0xF8, 0x58, 0x19, 0xF4, 0x76, 0x82, 0x2F,
  0xE4, 0x28, 0x21, 0x9F, 0xD7, 0x71, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x77, 0x10, 0x5E, 0x07, 0x77,
  0x38, 0x45, 0xCF, 0xEB, 0x48, 0x0F, 0x40, 0x87, 0x38, 0xCE, 0xFE, 0xC8, 0x27, 0x60, 0x30, 0xCF,
  0xA0, 0x87, 0x40, 0x8B, 0x09, 0x03, 0x20, 0x20, 0x8B, 0x0B, 0x72, 0x0A, 0xA0, 0xE0, 0x46, 0x05,
  0xB0, 0x87, 0x0A, 0xB0, 0x37, 0x10, 0xAB, 0x02, 0x50, 0x6B, 0x06, 0x72, 0x03, 0xB0, 0x94, 0x03,
  0xB0, 0xB7, 0x4B, 0x0D, 0x40, 0xBB, 0x03, 0x74, 0x0C, 0xB0, 0x12, 0x05, 0xB0, 0xA7, 0x50, 0xBB,
  0x04, 0x20, 0xCB, 0x04, 0x75, 0x0B, 0xB8, 0x15, 0x03, 0xB0, 0xD7, 0x60, 0xCB, 0x81, 0x50, 0x9B,
  0x08, 0x76, 0x0D, 0xB8, 0x14, 0x0E, 0xB0, 0x47, 0x6C, 0x00, 0x3C, 0x76, 0x02, 0xC1, 0x06, 0xB0,
  0xC7, 0x60, 0x5B, 0x81, 0xD0, 0x9B, 0x09, 0x76, 0x08, 0xB8, 0x1A, 0x0B, 0xB0, 0x77, 0x60, 0xCB,
  0x81, 0x50, 0xCB, 0x05, 0x75, 0x01, 0xC8, 0x11, 0x0D, 0xB0, 0x47, 0x50, 0x6B, 0x0A, 0x20, 0xDB,
  0x03, 0x75, 0x0C, 0xB0, 0x32, 0x0B, 0xB0, 0x37, 0x40, 0x2B, 0x0C, 0x30, 0x9B, 0x04, 0x74, 0x0A,
  0xB0, 0x33, 0x05, 0xB0, 0x77, 0x30, 0x3B, 0x09, 0x40, 0x1B, 0x0B, 0x73, 0x0D, 0xA0, 0xD6, 0x09,
  0xB0, 0x27, 0x10, 0xAA, 0x0E, 0x02, 0x60, 0x10, 0xEA, 0x0C, 0x70, 0xBA, 0x0E, 0x03, 0x71, 0x03,
  0x0E, 0xA0, 0xD0, 0x52, 0x81, 0x16, 0xDA, 0x0C, 0x02, 0x73, 0x02, 0x0C, 0xFA, 0x07, 0x77, 0x81,
  0x5A, 0xDA, 0x82, 0xDB, 0x61, 0x73,
  // "ŏ" (U+014F)
  0x78, 0x13, 0x72, 0x58, 0x11, 0x74, 0x78, 0x15, 0xF8, 0x58, 0x19, 0xF4, 0x78, 0x22, 0xFE, 0x42,
  0x82, 0x19, 0xFD, 0x72, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x72, 0x05, 0xE0, 0x77, 0x48, 0x45, 0xCF,
  0xEB, 0x48, 0x0D, 0x20, 0x86, 0x17, 0xBE, 0xFD, 0xA4, 0x72, 0x05, 0x0E, 0xF0, 0x97, 0x08, 0xA0,
  0xD0, 0x52, 0x05, 0xB0, 0x85, 0x07, 0xA0, 0xD0, 0x14, 0x07, 0xB0, 0x23, 0x04, 0xB0, 0x35, 0x01,
  0xB0, 0x83, 0x0D, 0xA0, 0x97, 0x0E, 0xA0, 0xB2, 0x06, 0xB0, 0x27, 0x0D, 0xA0, 0xD2, 0x0D, 0xA0,
  0xC7, 0x10, 0xDA, 0x81, 0xE0, 0x4B, 0x07, 0x71, 0x0E, 0xA8, 0x1E, 0x09, 0xB0, 0x37, 0x1B, 0x81,
  0xD0, 0xDB, 0x71, 0x02, 0xB0, 0xA1, 0xB0, 0xC7, 0x10, 0x4B, 0x07, 0x02, 0xB0, 0xA7, 0x10, 0x8B,
  0x03, 0x04, 0xB0, 0x87, 0x10, 0xCA, 0x81, 0xE0, 0x4B, 0x07, 0x70, 0x1B, 0x81, 0x80, 0x3B, 0x07,
  0x70, 0x7B, 0x81, 0x20, 0x1B, 0x08, 0x70, 0xEA, 0x09, 0x30, 0xDA, 0x0B, 0x60, 0x8A, 0x0D, 0x01,
  0x30, 0x7B, 0x02, 0x40, 0x4B, 0x03, 0x50, 0xDA, 0x83, 0xD3, 0x01, 0x7B, 0x04, 0x60, 0x20, 0xDF,
  0x0C, 0x03, 0x72, 0x85, 0x7C, 0xEE, 0xDA, 0x57,
  // "Ő" (U+0150)
  0x77, 0x0C, 0xA8, 0x2E, 0x10, 0x9B, 0x04, 0x76, 0x08, 0xA8, 0x2E, 0x30, 0x4B, 0x06, 0x76, 0x03,
  0xA0, 0xE0, 0x32, 0x0D, 0xA0, 0x67, 0x78, 0x2D, 0xFE, 0x22, 0x0A, 0xA0, 0x57, 0x78, 0x2A, 0xFD,
  0x22, 0x82, 0x6F, 0xE4, 0x77, 0x82, 0x5F, 0xA1, 0x28, 0x21, 0xFD, 0x28, 0x0F, 0x50, 0x87, 0x38,
  0xCE, 0xFE, 0xC8, 0x27, 0x70, 0x30, 0xCF, 0xA0, 0x87, 0x50, 0x8B, 0x09, 0x03, 0x20, 0x20, 0x8B,
  0x0B, 0x73, 0x0A, 0xA0, 0xE0, 0x46, 0x05, 0xB0, 0x87, 0x10, 0xAB, 0x03, 0x71, 0x0A, 0xB0, 0x26,
  0x06, 0xB0, 0x67, 0x20, 0x3B, 0x09, 0x50, 0x3B, 0x0B, 0x74, 0xB0, 0xD5, 0x0B, 0xB0, 0x37, 0x40,
  0xCB, 0x01, 0x30, 0x5B, 0x0A, 0x75, 0x0B, 0xB0, 0x43, 0x0C, 0xB0, 0x47, 0x50, 0xBB, 0x05, 0x20,
  0x3B, 0x0D, 0x76, 0x0C, 0xB0, 0x52, 0x09, 0xB0, 0x87, 0x60, 0xDB, 0x04, 0x20, 0xEB, 0x04, 0x76,
  0xC8, 0x13, 0x03, 0xC7, 0x60, 0x2C, 0x20, 0x6B, 0x0C, 0x76, 0x05, 0xB0, 0xD2, 0x09, 0xB0, 0x97,
  0x60, 0x8B, 0x0A, 0x20, 0xBB, 0x07, 0x76, 0x0C, 0xB0, 0x52, 0x0C, 0xB0, 0x57, 0x50, 0x1C, 0x01,
  0x20, 0xDB, 0x04, 0x75, 0x06, 0xB0, 0xA3, 0x0D, 0xB0, 0x37, 0x50, 0xCB, 0x03, 0x30, 0xBB, 0x03,
  0x74, 0x02, 0xB0, 0xC4, 0x09, 0xB0, 0x47, 0x40, 0xAB, 0x03, 0x40, 0x5B, 0x07, 0x73, 0x03, 0xB0,
  0x95, 0x01, 0xB0, 0xB7, 0x30, 0xDA, 0x0D, 0x70, 0x9B, 0x02, 0x71, 0x0A, 0xA0, 0xE0, 0x27, 0x01,
  0x0E, 0xA0, 0xC7, 0x0B, 0xA0, 0xE0, 0x37, 0x20, 0x30, 0xEA, 0x0D, 0x05, 0x28, 0x11, 0x6D, 0xA0,
  0xC0, 0x27, 0x40, 0x20, 0xCF, 0xA0, 0x77, 0x71, 0x81, 0x5A, 0xDA, 0x82, 0xDB, 0x61, 0x74,
  // "ő" (U+0151)
  0x74, 0x0C, 0xA8, 0x2E, 0x10, 0x9B, 0x04, 0x73, 0x08, 0xA8, 0x2E, 0x30, 0x4B, 0x06, 0x73, 0x03,
  0xA0, 0xE0, 0x32, 0x0D, 0xA0, 0x67, 0x48, 0x2D, 0xFE, 0x22, 0x0A, 0xA0, 0x57, 0x48, 0x2A, 0xFD,
  0x22, 0x82, 0x6F, 0xE4, 0x74, 0x82, 0x5F, 0xA1, 0x28, 0x21, 0xFD, 0x28, 0x0E, 0x40, 0x86, 0x17,
  0xBE, 0xFD, 0xA4, 0x76, 0x05, 0x0E, 0xF0, 0x97, 0x40, 0x8A, 0x0D, 0x05, 0x20, 0x5B, 0x08, 0x72,
  0x07, 0xA0, 0xD0, 0x14, 0x07, 0xB0, 0x27, 0x04, 0xB0, 0x35, 0x01, 0xB0, 0x87, 0x0D, 0xA0, 0x97,
  0x0E, 0xA0, 0xB6, 0x06, 0xB0, 0x27, 0x0D, 0xA0, 0xD6, 0x0D, 0xA0, 0xC7, 0x10, 0xDA, 0x0E, 0x50,
  0x4B, 0x07, 0x71, 0x0E, 0xA0, 0xE5, 0x09, 0xB0, 0x37, 0x1B, 0x0D, 0x50, 0xDB, 0x71, 0x02, 0xB0,
  0xA5, 0xB0, 0xC7, 0x10, 0x4B, 0x07, 0x40, 0x2B, 0x0A, 0x71, 0x08, 0xB0, 0x34, 0x04, 0xB0, 0x87,
  0x10, 0xCA, 0x0E, 0x50, 0x4B, 0x07, 0x70, 0x1B, 0x08, 0x50, 0x3B, 0x07, 0x70, 0x7B, 0x02, 0x50,
  0x1B, 0x08, 0x70, 0xEA, 0x09, 0x70, 0xDA, 0x0B, 0x60, 0x8A, 0x0D, 0x01, 0x70, 0x7B, 0x02, 0x40,
  0x4B, 0x03, 0x72, 0x0D, 0xA8, 0x3D, 0x30, 0x17, 0xB0, 0x47, 0x30, 0x20, 0xDF, 0x0C, 0x03, 0x76,
  0x85, 0x7C, 0xEE, 0xDA, 0x57, 0x40,
  // "Œ" (U+0152)
  0x73, 0x82, 0x38, 0xCE, 0xFF, 0xC0, 0x87, 0x10, 0x30, 0xCF, 0xD8, 0x01, 0xED, 0x05, 0x70, 0x8B,
  0x09, 0x03, 0x28, 0x11, 0x38, 0xB0, 0x96, 0x04, 0x0E, 0xA0, 0x26, 0x0A, 0xA0, 0xE0, 0x46, 0x06,
  0xB0, 0x67, 0x08, 0xA6, 0x0A, 0xB0, 0x37, 0x09, 0xB0, 0x27, 0x81, 0x6F, 0xC5, 0x06, 0xB0, 0x67,
  0x10, 0xCB, 0x71, 0x81, 0x6F, 0x94, 0x03, 0xB0, 0xB7, 0x2B, 0x0C, 0x71, 0x81, 0x7F, 0x64, 0x0B,
  0xB0, 0x37, 0x10, 0x3B, 0x08, 0x71, 0x01, 0x02, 0x40, 0x5B, 0x0A, 0x72, 0x06, 0xB0, 0x57, 0x70,
  0xCB, 0x03, 0x72, 0x0A, 0xB0, 0x27, 0x60, 0x3B, 0x0D, 0x73, 0x0D, 0xA0, 0xE7, 0x70, 0x9B, 0x08,
  0x72, 0x01, 0xB0, 0xB7, 0x70, 0xEB, 0x03, 0x72, 0x04, 0xB0, 0x87, 0x60, 0x3B, 0x0E, 0x73, 0x07,
  0xFC, 0x09, 0x50, 0x6B, 0x0B, 0x73, 0x0A, 0xB8, 0x04, 0xE0, 0x55, 0x09, 0xB0, 0x87, 0x30, 0xDA,
  0x0E, 0x77, 0x0B, 0xB0, 0x67, 0x20, 0x1B, 0x0B, 0x77, 0x0C, 0xB0, 0x47, 0x20, 0x4B, 0x07, 0x77,
  0x0D, 0xB0, 0x37, 0x20, 0x8B, 0x04, 0x77, 0x0D, 0xB0, 0x27, 0x20, 0xBB, 0x01, 0x77, 0x0B, 0xB0,
  0x27, 0x20, 0xEA, 0x0D, 0x77, 0x10, 0x9B, 0x03, 0x71, 0x02, 0xB0, 0xA7, 0x71, 0x05, 0xB0, 0x67,
  0x10, 0x5B, 0x07, 0x72, 0x81, 0x9F, 0x43, 0x01, 0xB0, 0xA7, 0x10, 0x8B, 0x03, 0x72, 0x81, 0xEF,
  0x14, 0x09, 0xB0, 0x27, 0x0B, 0xB7, 0x28, 0x16, 0xFC, 0x50, 0x10, 0xEA, 0x0C, 0x70, 0xEA, 0x0D,
  0x71, 0x82, 0x1E, 0xF8, 0x60, 0x30, 0xEA, 0x0D, 0x05, 0x28, 0x11, 0x38, 0xB0, 0x97, 0x04, 0x0D,
  0xA0, 0x47, 0x02, 0x0C, 0xFD, 0x80, 0x2E, 0xD0, 0x17, 0x28, 0x15, 0xAD, 0xFF, 0xD0, 0xC5,
  // "œ" (U+0153)
  0x78, 0x61, 0x6B, 0xDF, 0xDA, 0x45, 0x86, 0x17, 0xCE, 0xFD, 0x91, 0x70, 0x50, 0xEF, 0x09, 0x30,
  0x40, 0xEE, 0x0D, 0x01, 0x50, 0x8A, 0x0D, 0x05, 0x20, 0x6B, 0x81, 0x80, 0x7A, 0x82, 0x91, 0x07,
  0xB0, 0x84, 0x08, 0xA0, 0xD0, 0x14, 0x08, 0xB0, 0x7A, 0x09, 0x40, 0xEA, 0x0C, 0x30, 0x4B, 0x04,
  0x50, 0x2D, 0x0D, 0x50, 0xDA, 0x0D, 0x30, 0xDA, 0x0A, 0x7D, 0x05, 0x5B, 0x0A, 0x20, 0x7B, 0x03,
  0x70, 0xDB, 0x0D, 0x50, 0x5B, 0x05, 0x20, 0xDA, 0x0D, 0x71, 0x0D, 0xB0, 0x64, 0x01, 0x0D, 0xA0,
  0xC2, 0x04, 0xB0, 0x77, 0x10, 0xEB, 0x01, 0x30, 0x20, 0xCA, 0x0D, 0x02, 0x20, 0x9B, 0x03, 0x71,
  0xB8, 0x3C, 0x01, 0x49, 0xB0, 0xD0, 0x23, 0x0D, 0xB7, 0x10, 0x2F, 0xA0, 0xE0, 0x75, 0xB0, 0xC7,
  0x10, 0x5D, 0x83, 0xED, 0xA6, 0x15, 0x03, 0xB0, 0xA7, 0x10, 0x8B, 0x05, 0x74, 0x04, 0xB0, 0x97,
  0x10, 0xCB, 0x03, 0x74, 0x04, 0xB0, 0x87, 0x02, 0xC0, 0x37, 0x40, 0x3B, 0x08, 0x70, 0x8C, 0x04,
  0x74, 0x01, 0xB0, 0x97, 0x0E, 0xC0, 0x67, 0x50, 0xDA, 0x0C, 0x60, 0x8D, 0x0A, 0x70, 0x80, 0x33,
  0x07, 0xB0, 0x24, 0x04, 0xB0, 0xEB, 0x02, 0x58, 0x17, 0xF1, 0x40, 0xCA, 0x83, 0xD3, 0x01, 0x7B,
  0x81, 0x72, 0xEA, 0x0D, 0x04, 0x28, 0x24, 0xBF, 0x95, 0x01, 0x0D, 0xF0, 0xD0, 0x42, 0x04, 0x0E,
  0xF0, 0x97, 0x18, 0x56, 0xCE, 0xED, 0xA5, 0x58, 0x61, 0x7C, 0xEE, 0xD9, 0x45,
  // "Ŕ" (U+0154)
  0x77, 0x48, 0x34, 0x77, 0x73, 0x77, 0x40, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x40, 0xAA, 0x0E, 0x02,
  0x77, 0x40, 0x4A, 0x0E, 0x02, 0x77, 0x48, 0x31, 0xDF, 0xE2, 0x77, 0x58, 0x2A, 0xFD, 0x27, 0x75,
  0x82, 0x5F, 0xA1, 0x80, 0xF0, 0x00, 0xCF, 0xA8, 0x3E, 0xDA, 0x61, 0x72, 0x0A, 0x0C, 0xD8, 0x1D,
  0xDE, 0xC0, 0xE0, 0x57, 0x30, 0x5B, 0x0C, 0x40, 0x60, 0xEB, 0x04, 0x72, 0x03, 0xB0, 0x95, 0x04,
  0xB0, 0xD7, 0x20, 0x5B, 0x06, 0x60, 0xDB, 0x02, 0x71, 0x08, 0xB0, 0x36, 0x0A, 0xB0, 0x57, 0x10,
  0xBB, 0x70, 0x9B, 0x06, 0x71, 0x0E, 0xA0, 0xC7, 0x09, 0xB0, 0x57, 0x02, 0xB0, 0x87, 0x0B, 0xB0,
  0x47, 0x06, 0xB0, 0x57, 0x0E, 0xB0, 0x17, 0x09, 0xB0, 0x26, 0x04, 0xB0, 0xA7, 0x10, 0xCA, 0x0E,
  0x70, 0xDA, 0x0E, 0x02, 0x71, 0xB0, 0xB6, 0x0A, 0xB0, 0x57, 0x10, 0x3B, 0x08, 0x38, 0x11, 0x6D,
  0xA0, 0xE0, 0x47, 0x20, 0x7B, 0x82, 0xED, 0xDE, 0xB8, 0x1E, 0x91, 0x73, 0x0A, 0xFA, 0x0E, 0x76,
  0x0D, 0xA0, 0xD3, 0x0B, 0xB0, 0x17, 0x40, 0x1B, 0x0A, 0x30, 0x8B, 0x05, 0x74, 0x04, 0xB0, 0x73,
  0x04, 0xB0, 0x97, 0x40, 0x8B, 0x04, 0x30, 0x1B, 0x0D, 0x74, 0x0B, 0xB5, 0x0D, 0xB0, 0x27, 0x30,
  0xEA, 0x0C, 0x50, 0x9B, 0x06, 0x72, 0x02, 0xB0, 0x95, 0x06, 0xB0, 0xA7, 0x20, 0x5B, 0x06, 0x50,
  0x3B, 0x0E, 0x72, 0x09, 0xB0, 0x36, 0x0E, 0xB0, 0x37, 0x10, 0xEB, 0x01, 0x60, 0xAB, 0x09, 0x60,
  0x20, 0xAC, 0x08, 0x60, 0x3C, 0x06, 0x30, 0x6F, 0xA0, 0xE0, 0x74, 0x08, 0xD2, 0x09, 0xFB, 0x04,
  0x58, 0x35, 0xBD, 0xFD, 0x20,
  // "ŕ" (U+0155)
  0x75, 0x83, 0x47, 0x77, 0x37, 0x40, 0x10, 0xEA, 0x0D, 0x01, 0x74, 0x0A, 0xA0, 0xE0, 0x27, 0x40,
  0x4A, 0x0E, 0x02, 0x74, 0x83, 0x1D, 0xFE, 0x27, 0x58, 0x2A, 0xFD, 0x27, 0x58, 0x25, 0xFA, 0x18,
  0x0C, 0x40, 0x06, 0xE3, 0x83, 0x7D, 0xED, 0x52, 0x08, 0xD0, 0xC2, 0x0B, 0xD0, 0x23, 0x06, 0xB8,
  0x4A, 0x0A, 0xFE, 0xEB, 0x05, 0x40, 0xEA, 0x84, 0x84, 0xF8, 0x01, 0xB0, 0x54, 0x0D, 0xA8, 0x16,
  0xCA, 0x38, 0x1C, 0xFE, 0x5B, 0x81, 0xAE, 0x13, 0x81, 0x9A, 0x24, 0x03, 0xC0, 0x67, 0x40, 0x7B,
  0x0E, 0x75, 0x0A, 0xB0, 0x77, 0x50, 0xDB, 0x02, 0x74, 0x01, 0xB0, 0xB7, 0x50, 0x4B, 0x07, 0x75,
  0x07, 0xB0, 0x27, 0x50, 0xBA, 0x0E, 0x76, 0x0E, 0xA0, 0xA7, 0x50, 0x1B, 0x07, 0x75, 0x05, 0xB0,
  0x47, 0x50, 0x8B, 0x01, 0x75, 0x0B, 0xA0, 0xD7, 0x60, 0xEA, 0x09, 0x75, 0x02, 0xB0, 0x67, 0x50,
  0x5B, 0x03, 0x75,
  // "Ŗ" (U+0156)
  0x60, 0xCF, 0xA8, 0x3E, 0xDA, 0x61, 0x72, 0x0A, 0x0C, 0xD8, 0x1D, 0xDE, 0xC0, 0xE0, 0x57, 0x30,
  0x5B, 0x0C, 0x40, 0x60, 0xEB, 0x04, 0x72, 0x03, 0xB0, 0x95, 0x04, 0xB0, 0xD7, 0x20, 0x5B, 0x06,
  0x60, 0xDB, 0x02, 0x71, 0x08, 0xB0, 0x36, 0x0A, 0xB0, 0x57, 0x10, 0xBB, 0x70, 0x9B, 0x06, 0x71,
  0x0E, 0xA0, 0xC7, 0x09, 0xB0, 0x57, 0x02, 0xB0, 0x87, 0x0B, 0xB0, 0x47, 0x06, 0xB0, 0x57, 0x0E,
  0xB0, 0x17, 0x09, 0xB0, 0x26, 0x04, 0xB0, 0xA7, 0x10, 0xCA, 0x0E, 0x70, 0xDA, 0x0E, 0x02, 0x71,
  0xB0, 0xB6, 0x0A, 0xB0, 0x57, 0x10, 0x3B, 0x08, 0x38, 0x11, 0x6D, 0xA0, 0xE0, 0x47, 0x20, 0x7B,
  0x82, 0xED, 0xDE, 0xB8, 0x1E, 0x91, 0x73, 0x0A, 0xFA, 0x0E, 0x76, 0x0D, 0xA0, 0xD3, 0x0B, 0xB0,
  0x17, 0x40, 0x1B, 0x0A, 0x30, 0x8B, 0x05, 0x74, 0x04, 0xB0, 0x73, 0x04, 0xB0, 0x97, 0x40, 0x8B,
  0x04, 0x30, 0x1B, 0x0D, 0x74, 0x0B, 0xB5, 0x0D, 0xB0, 0x27, 0x30, 0xEA, 0x0C, 0x50, 0x9B, 0x06,
  0x72, 0x02, 0xB0, 0x95, 0x06, 0xB0, 0xA7, 0x20, 0x5B, 0x06, 0x50, 0x3B, 0x0E, 0x72, 0x09, 0xB0,
  0x36, 0x0E, 0xB0, 0x37, 0x10, 0xEB, 0x01, 0x60, 0xAB, 0x09, 0x60, 0x20, 0xAC, 0x08, 0x60, 0x3C,
  0x06, 0x30, 0x6F, 0xA0, 0xE0, 0x74, 0x08, 0xD2, 0x09, 0xFB, 0x04, 0x58, 0x35, 0xBD, 0xFD, 0x80,
  0xE7, 0x08, 0x23, 0x77, 0x67, 0x76, 0x0A, 0xA0, 0x87, 0x76, 0x81, 0xEF, 0xE7, 0x76, 0x05, 0xA0,
  0x47, 0x76, 0x81, 0xBF, 0x97, 0x76, 0x81, 0x1F, 0xD7, 0x77, 0x81, 0x7F, 0x37, 0x70,
  // "ŗ" (U+0157)
  0x30, 0x6E, 0x38, 0x37, 0xDE, 0xD5, 0x40, 0x8D, 0x0C, 0x20, 0xBD, 0x02, 0x50, 0x6B, 0x84, 0xA0,
  0xAF, 0xEE, 0xB0, 0x56, 0x0E, 0xA8, 0x48, 0x4F, 0x80, 0x1B, 0x05, 0x60, 0xDA, 0x81, 0x6C, 0xA3,
  0x81, 0xCF, 0xE7, 0xB8, 0x1A, 0xE1, 0x38, 0x19, 0xA2, 0x60, 0x3C, 0x06, 0x76, 0x07, 0xB0, 0xE7,
  0x70, 0xAB, 0x07, 0x77, 0x0D, 0xB0, 0x27, 0x60, 0x1B, 0x0B, 0x77, 0x04, 0xB0, 0x77, 0x70, 0x7B,
  0x02, 0x77, 0x0B, 0xA0, 0xE7, 0x71, 0x0E, 0xA0, 0xA7, 0x70, 0x1B, 0x07, 0x77, 0x05, 0xB0, 0x47,
  0x70, 0x8B, 0x01, 0x77, 0x0B, 0xA0, 0xD7, 0x71, 0x0E, 0xA0, 0x97, 0x70, 0x2B, 0x06, 0x77, 0x05,
  0xB0, 0x38, 0x0E, 0x00, 0x82, 0x37, 0x76, 0x77, 0x10, 0xAA, 0x08, 0x77, 0x18, 0x1E, 0xFE, 0x77,
  0x10, 0x5A, 0x04, 0x77, 0x18, 0x1B, 0xF9, 0x77, 0x18, 0x11, 0xFD, 0x77, 0x28, 0x17, 0xF3, 0x77,
  0x20,
  // "Ř" (U+0158)
  0x75, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x58, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x78, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x77, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x72, 0x82, 0xCF, 0xED,
  0xA0, 0x47, 0x73, 0x07, 0xC0, 0x77, 0x74, 0x03, 0xB0, 0xC8, 0x0E, 0x70, 0x0C, 0xFA, 0x83, 0xED,
  0xA6, 0x17, 0x20, 0xA0, 0xCD, 0x81, 0xDD, 0xEC, 0x0E, 0x05, 0x73, 0x05, 0xB0, 0xC4, 0x06, 0x0E,
  0xB0, 0x47, 0x20, 0x3B, 0x09, 0x50, 0x4B, 0x0D, 0x72, 0x05, 0xB0, 0x66, 0x0D, 0xB0, 0x27, 0x10,
  0x8B, 0x03, 0x60, 0xAB, 0x05, 0x71, 0x0B, 0xB7, 0x09, 0xB0, 0x67, 0x10, 0xEA, 0x0C, 0x70, 0x9B,
  0x05, 0x70, 0x2B, 0x08, 0x70, 0xBB, 0x04, 0x70, 0x6B, 0x05, 0x70, 0xEB, 0x01, 0x70, 0x9B, 0x02,
  0x60, 0x4B, 0x0A, 0x71, 0x0C, 0xA0, 0xE7, 0x0D, 0xA0, 0xE0, 0x27, 0x1B, 0x0B, 0x60, 0xAB, 0x05,
  0x71, 0x03, 0xB0, 0x83, 0x81, 0x16, 0xDA, 0x0E, 0x04, 0x72, 0x07, 0xB8, 0x2E, 0xDD, 0xEB, 0x81,
  0xE9, 0x17, 0x30, 0xAF, 0xA0, 0xE7, 0x60, 0xDA, 0x0D, 0x30, 0xBB, 0x01, 0x74, 0x01, 0xB0, 0xA3,
  0x08, 0xB0, 0x57, 0x40, 0x4B, 0x07, 0x30, 0x4B, 0x09, 0x74, 0x08, 0xB0, 0x43, 0x01, 0xB0, 0xD7,
  0x40, 0xBB, 0x50, 0xDB, 0x02, 0x73, 0x0E, 0xA0, 0xC5, 0x09, 0xB0, 0x67, 0x20, 0x2B, 0x09, 0x50,
  0x6B, 0x0A, 0x72, 0x05, 0xB0, 0x65, 0x03, 0xB0, 0xE7, 0x20, 0x9B, 0x03, 0x60, 0xEB, 0x03, 0x71,
  0x0E, 0xB0, 0x16, 0x0A, 0xB0, 0x96, 0x02, 0x0A, 0xC0, 0x86, 0x03, 0xC0, 0x63, 0x06, 0xFA, 0x0E,
  0x07, 0x40, 0x8D, 0x20, 0x9F, 0xB0, 0x45, 0x83, 0x5B, 0xDF, 0xD2,
  // "ř" (U+0159)
  0x68, 0x11, 0x73, 0x68, 0x15, 0x72, 0x68, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x18, 0x19, 0xFC,
  0x28, 0x31, 0xCF, 0xD1, 0x71, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x38, 0x2C, 0xFE, 0xDA, 0x04,
  0x74, 0x07, 0xC0, 0x77, 0x50, 0x3B, 0x0C, 0x80, 0xC6, 0x00, 0x6E, 0x38, 0x37, 0xDE, 0xD5, 0x30,
  0x8D, 0x0C, 0x20, 0xBD, 0x02, 0x40, 0x6B, 0x84, 0xA0, 0xAF, 0xEE, 0xB0, 0x55, 0x0E, 0xA8, 0x48,
  0x4F, 0x80, 0x1B, 0x05, 0x50, 0xDA, 0x81, 0x6C, 0xA3, 0x81, 0xCF, 0xE6, 0xB8, 0x1A, 0xE1, 0x38,
  0x19, 0xA2, 0x50, 0x3C, 0x06, 0x75, 0x07, 0xB0, 0xE7, 0x60, 0xAB, 0x07, 0x76, 0x0D, 0xB0, 0x27,
  0x50, 0x1B, 0x0B, 0x76, 0x04, 0xB0, 0x77, 0x60, 0x7B, 0x02, 0x76, 0x0B, 0xA0, 0xE7, 0x70, 0xEA,
  0x0A, 0x76, 0x01, 0xB0, 0x77, 0x60, 0x5B, 0x04, 0x76, 0x08, 0xB0, 0x17, 0x60, 0xBA, 0x0D, 0x77,
  0x0E, 0xA0, 0x97, 0x60, 0x2B, 0x06, 0x76, 0x05, 0xB0, 0x37, 0x60,
  // "Ś" (U+015A)
  0x77, 0x28, 0x34, 0x77, 0x73, 0x77, 0x10, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x10, 0xAA, 0x0E, 0x02,
  0x77, 0x10, 0x4A, 0x0E, 0x02, 0x77, 0x18, 0x31, 0xDF, 0xE2, 0x77, 0x28, 0x2A, 0xFD, 0x27, 0x72,
  0x82, 0x5F, 0xA1, 0x80, 0xE4, 0x08, 0x74, 0x9C, 0xEF, 0xEC, 0x93, 0x73, 0x01, 0x0B, 0xFA, 0x0A,
  0x71, 0x02, 0x0E, 0xA0, 0xB0, 0x32, 0x03, 0x0C, 0xB0, 0x97, 0x0D, 0xA0, 0x85, 0x01, 0x0E, 0xA0,
  0xE6, 0x07, 0xA0, 0xD7, 0x09, 0xA0, 0xE6, 0x0D, 0xA0, 0x87, 0x05, 0xA0, 0xA5, 0x02, 0xB0, 0x67,
  0x81, 0x4C, 0x86, 0x03, 0xB0, 0x57, 0x72, 0x04, 0xB0, 0x77, 0x72, 0x02, 0xB0, 0xC7, 0x73, 0x0E,
  0xB0, 0x67, 0x72, 0x09, 0xC0, 0x67, 0x71, 0x01, 0x0E, 0xC0, 0xA0, 0x17, 0x70, 0x20, 0xEC, 0x0E,
  0x04, 0x77, 0x03, 0x0D, 0xD0, 0x67, 0x70, 0x10, 0xAD, 0x05, 0x77, 0x10, 0x6D, 0x03, 0x77, 0x10,
  0x40, 0xEB, 0x0B, 0x77, 0x20, 0x4C, 0x01, 0x77, 0x20, 0xBB, 0x05, 0x50, 0x60, 0x37, 0x20, 0x6B,
  0x05, 0x48, 0x1C, 0xF7, 0x72, 0x04, 0xB0, 0x53, 0x06, 0xA0, 0x97, 0x20, 0x5B, 0x03, 0x30, 0x8A,
  0x0D, 0x72, 0x08, 0xA0, 0xE4, 0x06, 0xB0, 0x57, 0x10, 0xDA, 0x08, 0x40, 0x10, 0xEA, 0x0D, 0x01,
  0x60, 0x9A, 0x0E, 0x01, 0x50, 0x6B, 0x81, 0xD5, 0x12, 0x04, 0x0B, 0xA0, 0xE0, 0x37, 0x06, 0x0E,
  0xFA, 0x0B, 0x01, 0x72, 0x89, 0x01, 0x6B, 0xDE, 0xFE, 0xC8, 0x37, 0x10,
  // "ś" (U+015B)
  0x75, 0x83, 0x47, 0x77, 0x37, 0x40, 0x10, 0xEA, 0x0D, 0x01, 0x74, 0x0A, 0xA0, 0xE0, 0x27, 0x40,
  0x4A, 0x0E, 0x02, 0x74, 0x83, 0x1D, 0xFE, 0x27, 0x58, 0x2A, 0xFD, 0x27, 0x58, 0x25, 0xFA, 0x18,
  0x0D, 0x00, 0x86, 0x17, 0xCE, 0xFE, 0xB6, 0x71, 0x05, 0x0E, 0xF0, 0xC6, 0x05, 0xA0, 0xE0, 0x52,
  0x06, 0xB0, 0x85, 0x0E, 0xA0, 0x34, 0x09, 0xA0, 0xC4, 0x05, 0xA0, 0xD5, 0x04, 0xA0, 0xA4, 0x08,
  0xA0, 0xB5, 0x82, 0x2F, 0xD3, 0x40, 0x8A, 0x0D, 0x60, 0x36, 0x07, 0xB0, 0x77, 0x50, 0x3C, 0x09,
  0x75, 0x09, 0xC0, 0xD0, 0x57, 0x40, 0x9D, 0x0A, 0x74, 0x06, 0x0E, 0xC0, 0xB7, 0x40, 0x10, 0xAC,
  0x07, 0x75, 0x06, 0xB0, 0xE7, 0x60, 0x9B, 0x01, 0x38, 0x13, 0xC9, 0x60, 0x4B, 0x02, 0x38, 0x1D,
  0xFA, 0x60, 0x2B, 0x4A, 0x0E, 0x60, 0x5A, 0x0C, 0x4B, 0x05, 0x50, 0xBA, 0x06, 0x40, 0xAA, 0x0E,
  0x05, 0x20, 0x30, 0xBA, 0x0B, 0x50, 0x10, 0xCF, 0x90, 0xA7, 0x18, 0x66, 0xBE, 0xFE, 0xD9, 0x37,
  // "Ŝ" (U+015C)
  0x76, 0x06, 0x0F, 0x77, 0x71, 0x05, 0xC0, 0x27, 0x60, 0x20, 0xEC, 0x06, 0x76, 0x85, 0xCF, 0xE6,
  0xEF, 0xC7, 0x58, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x73, 0x82, 0x8F, 0xD2, 0x38, 0x1B, 0xFA, 0x72,
  0x82, 0x5F, 0xA1, 0x40, 0x10, 0xC9, 0x80, 0xD6, 0x08, 0x74, 0x9C, 0xEF, 0xEC, 0x93, 0x72, 0x01,
  0x0B, 0xFA, 0x0A, 0x70, 0x20, 0xEA, 0x0B, 0x03, 0x20, 0x30, 0xCB, 0x09, 0x60, 0xDA, 0x08, 0x50,
  0x10, 0xEA, 0x0E, 0x50, 0x7A, 0x0D, 0x70, 0x9A, 0x0E, 0x50, 0xDA, 0x08, 0x70, 0x5A, 0x0A, 0x40,
  0x2B, 0x06, 0x78, 0x14, 0xC8, 0x50, 0x3B, 0x05, 0x77, 0x10, 0x4B, 0x07, 0x77, 0x10, 0x2B, 0x0C,
  0x77, 0x20, 0xEB, 0x06, 0x77, 0x10, 0x9C, 0x06, 0x77, 0x01, 0x0E, 0xC0, 0xA0, 0x17, 0x60, 0x20,
  0xEC, 0x0E, 0x04, 0x76, 0x03, 0x0D, 0xD0, 0x67, 0x60, 0x10, 0xAD, 0x05, 0x77, 0x06, 0xD0, 0x37,
  0x70, 0x40, 0xEB, 0x0B, 0x77, 0x10, 0x4C, 0x01, 0x77, 0x10, 0xBB, 0x05, 0x40, 0x60, 0x37, 0x20,
  0x6B, 0x05, 0x38, 0x1C, 0xF7, 0x72, 0x04, 0xB0, 0x52, 0x06, 0xA0, 0x97, 0x20, 0x5B, 0x03, 0x20,
  0x8A, 0x0D, 0x72, 0x08, 0xA0, 0xE3, 0x06, 0xB0, 0x57, 0x10, 0xDA, 0x08, 0x30, 0x10, 0xEA, 0x0D,
  0x01, 0x60, 0x9A, 0x0E, 0x01, 0x40, 0x6B, 0x81, 0xD5, 0x12, 0x04, 0x0B, 0xA0, 0xE0, 0x36, 0x06,
  0x0E, 0xFA, 0x0B, 0x01, 0x71, 0x89, 0x01, 0x6B, 0xDE, 0xFE, 0xC8, 0x37,
  // "ŝ" (U+015D)
  0x72, 0x06, 0x0F, 0x77, 0x30, 0x5C, 0x02, 0x71, 0x02, 0x0E, 0xC0, 0x67, 0x18, 0x5C, 0xFE, 0x6E,
  0xFC, 0x78, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x58, 0x28, 0xFD, 0x23, 0x81, 0xBF, 0xA4, 0x82, 0x5F,
  0xA1, 0x40, 0x10, 0xC9, 0x77, 0x77, 0x78, 0x61, 0x7C, 0xEF, 0xEB, 0x66, 0x05, 0x0E, 0xF0, 0xC4,
  0x05, 0xA0, 0xE0, 0x52, 0x06, 0xB0, 0x83, 0x0E, 0xA0, 0x34, 0x09, 0xA0, 0xC2, 0x05, 0xA0, 0xD5,
  0x04, 0xA0, 0xA2, 0x08, 0xA0, 0xB5, 0x82, 0x2F, 0xD3, 0x20, 0x8A, 0x0D, 0x60, 0x34, 0x07, 0xB0,
  0x77, 0x30, 0x3C, 0x09, 0x73, 0x09, 0xC0, 0xD0, 0x57, 0x20, 0x9D, 0x0A, 0x72, 0x06, 0x0E, 0xC0,
  0xB7, 0x20, 0x10, 0xAC, 0x07, 0x73, 0x06, 0xB0, 0xE7, 0x40, 0x9B, 0x83, 0x10, 0x3C, 0x96, 0x04,
  0xB8, 0x32, 0x0D, 0xFA, 0x60, 0x2B, 0x2A, 0x0E, 0x60, 0x5A, 0x0C, 0x2B, 0x05, 0x50, 0xBA, 0x06,
  0x20, 0xAA, 0x0E, 0x05, 0x20, 0x30, 0xBA, 0x0B, 0x30, 0x10, 0xCF, 0x90, 0xA6, 0x86, 0x6B, 0xEF,
  0xED, 0x93, 0x50,
  // "Ş" (U+015E)
  0x72, 0x87, 0x49, 0xCE, 0xFE, 0xC9, 0x37, 0x20, 0x10, 0xBF, 0xA0, 0xA7, 0x02, 0x0E, 0xA0, 0xB0,
  0x32, 0x03, 0x0C, 0xB0, 0x96, 0x0D, 0xA0, 0x85, 0x01, 0x0E, 0xA0, 0xE5, 0x07, 0xA0, 0xD7, 0x09,
  0xA0, 0xE5, 0x0D, 0xA0, 0x87, 0x05, 0xA0, 0xA4, 0x02, 0xB0, 0x67, 0x81, 0x4C, 0x85, 0x03, 0xB0,
  0x57, 0x71, 0x04, 0xB0, 0x77, 0x71, 0x02, 0xB0, 0xC7, 0x72, 0x0E, 0xB0, 0x67, 0x71, 0x09, 0xC0,
  0x67, 0x70, 0x10, 0xEC, 0x0A, 0x01, 0x76, 0x02, 0x0E, 0xC0, 0xE0, 0x47, 0x60, 0x30, 0xDD, 0x06,
  0x76, 0x01, 0x0A, 0xD0, 0x57, 0x70, 0x6D, 0x03, 0x77, 0x04, 0x0E, 0xB0, 0xB7, 0x71, 0x04, 0xC0,
  0x17, 0x71, 0x0B, 0xB0, 0x54, 0x06, 0x03, 0x72, 0x06, 0xB0, 0x53, 0x81, 0xCF, 0x77, 0x20, 0x4B,
  0x05, 0x20, 0x6A, 0x09, 0x72, 0x05, 0xB0, 0x32, 0x08, 0xA0, 0xD7, 0x20, 0x8A, 0x0E, 0x30, 0x6B,
  0x05, 0x71, 0x0D, 0xA0, 0x83, 0x01, 0x0E, 0xA0, 0xD0, 0x16, 0x09, 0xA0, 0xE0, 0x14, 0x06, 0xB8,
  0x1D, 0x51, 0x20, 0x40, 0xBA, 0x0E, 0x03, 0x60, 0x60, 0xEF, 0xA0, 0xB0, 0x17, 0x18, 0x90, 0x16,
  0xBD, 0xEF, 0xEC, 0x83, 0x77, 0x0B, 0x0E, 0x77, 0x38, 0x12, 0xF9, 0x77, 0x30, 0x9A, 0x09, 0x77,
  0x20, 0x40, 0xBA, 0x09, 0x77, 0x30, 0xEA, 0x77, 0x30, 0xBA, 0x01, 0x77, 0x28, 0x1E, 0xFE, 0x75,
  0x83, 0x32, 0x13, 0xBA, 0x09, 0x75, 0x0D, 0xD0, 0xC0, 0x17, 0x58, 0x4B, 0xEF, 0xEB, 0x67, 0x40,
  // "ş" (U+015F)
  0x58, 0x61, 0x7C, 0xEF, 0xEB, 0x66, 0x05, 0x0E, 0xF0, 0xC4, 0x05, 0xA0, 0xE0, 0x52, 0x06, 0xB0,
  0x83, 0x0E, 0xA0, 0x34, 0x09, 0xA0, 0xC2, 0x05, 0xA0, 0xD5, 0x04, 0xA0, 0xA2, 0x08, 0xA0, 0xB5,
  0x82, 0x2F, 0xD3, 0x20, 0x8A, 0x0D, 0x60, 0x34, 0x07, 0xB0, 0x77, 0x30, 0x3C, 0x09, 0x73, 0x09,
  0xC0, 0xD0, 0x57, 0x20, 0x9D, 0x0A, 0x72, 0x06, 0x0E, 0xC0, 0xB7, 0x20, 0x10, 0xAC, 0x07, 0x73,
  0x06, 0xB0, 0xE7, 0x40, 0x9B, 0x83, 0x10, 0x3C, 0x96, 0x04, 0xB8, 0x32, 0x0D, 0xFA, 0x60, 0x2B,
  0x2A, 0x0E, 0x60, 0x5A, 0x0C, 0x2B, 0x05, 0x50, 0xBA, 0x06, 0x20, 0xAA, 0x0E, 0x05, 0x20, 0x30,
  0xBA, 0x0B, 0x30, 0x10, 0xCF, 0x90, 0xA6, 0x86, 0x6B, 0xEF, 0xED, 0x93, 0x72, 0x0B, 0x0E, 0x75,
  0x81, 0x2F, 0x97, 0x50, 0x9A, 0x09, 0x74, 0x04, 0x0B, 0xA0, 0x97, 0x50, 0xEA, 0x75, 0x0B, 0xA0,
  0x17, 0x48, 0x1E, 0xFE, 0x78, 0x33, 0x21, 0x3B, 0xA0, 0x97, 0x0D, 0xD0, 0xC0, 0x17, 0x84, 0xBE,
  0xFE, 0xB6, 0x72,
  // "Š" (U+0160)
  0x73, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x38, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x58, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x75, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x78, 0x2C, 0xFE, 0xDA,
  0x04, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x20, 0x3B, 0x0C, 0x80, 0xE6, 0x08, 0x74, 0x9C, 0xEF, 0xEC,
  0x93, 0x74, 0x01, 0x0B, 0xFA, 0x0A, 0x72, 0x02, 0x0E, 0xA0, 0xB0, 0x32, 0x03, 0x0C, 0xB0, 0x97,
  0x10, 0xDA, 0x08, 0x50, 0x10, 0xEA, 0x0E, 0x70, 0x7A, 0x0D, 0x70, 0x9A, 0x0E, 0x70, 0xDA, 0x08,
  0x70, 0x5A, 0x0A, 0x60, 0x2B, 0x06, 0x78, 0x14, 0xC8, 0x70, 0x3B, 0x05, 0x77, 0x30, 0x4B, 0x07,
  0x77, 0x30, 0x2B, 0x0C, 0x77, 0x40, 0xEB, 0x06, 0x77, 0x30, 0x9C, 0x06, 0x77, 0x20, 0x10, 0xEC,
  0x0A, 0x01, 0x77, 0x10, 0x20, 0xEC, 0x0E, 0x04, 0x77, 0x10, 0x30, 0xDD, 0x06, 0x77, 0x10, 0x10,
  0xAD, 0x05, 0x77, 0x20, 0x6D, 0x03, 0x77, 0x20, 0x40, 0xEB, 0x0B, 0x77, 0x30, 0x4C, 0x01, 0x77,
  0x30, 0xBB, 0x05, 0x60, 0x60, 0x37, 0x20, 0x6B, 0x05, 0x58, 0x1C, 0xF7, 0x72, 0x04, 0xB0, 0x54,
  0x06, 0xA0, 0x97, 0x20, 0x5B, 0x03, 0x40, 0x8A, 0x0D, 0x72, 0x08, 0xA0, 0xE5, 0x06, 0xB0, 0x57,
  0x10, 0xDA, 0x08, 0x50, 0x10, 0xEA, 0x0D, 0x01, 0x60, 0x9A, 0x0E, 0x01, 0x60, 0x6B, 0x81, 0xD5,
  0x12, 0x04, 0x0B, 0xA0, 0xE0, 0x37, 0x10, 0x60, 0xEF, 0xA0, 0xB0, 0x17, 0x38, 0x90, 0x16, 0xBD,
  0xEF, 0xEC, 0x83, 0x72,
  // "š" (U+0161)
  0x68, 0x11, 0x73, 0x68, 0x15, 0x72, 0x68, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x18, 0x19, 0xFC,
  0x28, 0x31, 0xCF, 0xD1, 0x71, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x38, 0x2C, 0xFE, 0xDA, 0x04,
  0x74, 0x07, 0xC0, 0x77, 0x50, 0x3B, 0x0C, 0x80, 0xD2, 0x08, 0x61, 0x7C, 0xEF, 0xEB, 0x67, 0x20,
  0x50, 0xEF, 0x0C, 0x70, 0x5A, 0x0E, 0x05, 0x20, 0x6B, 0x08, 0x60, 0xEA, 0x03, 0x40, 0x9A, 0x0C,
  0x50, 0x5A, 0x0D, 0x50, 0x4A, 0x0A, 0x50, 0x8A, 0x0B, 0x58, 0x22, 0xFD, 0x35, 0x08, 0xA0, 0xD6,
  0x03, 0x70, 0x7B, 0x07, 0x76, 0x03, 0xC0, 0x97, 0x60, 0x9C, 0x0D, 0x05, 0x75, 0x09, 0xD0, 0xA7,
  0x50, 0x60, 0xEC, 0x0B, 0x75, 0x01, 0x0A, 0xC0, 0x77, 0x60, 0x6B, 0x0E, 0x77, 0x09, 0xB0, 0x14,
  0x81, 0x3C, 0x96, 0x04, 0xB0, 0x24, 0x81, 0xDF, 0xA6, 0x02, 0xB5, 0xA0, 0xE6, 0x05, 0xA0, 0xC5,
  0xB0, 0x55, 0x0B, 0xA0, 0x65, 0x0A, 0xA0, 0xE0, 0x52, 0x03, 0x0B, 0xA0, 0xB6, 0x01, 0x0C, 0xF9,
  0x0A, 0x72, 0x86, 0x6B, 0xEF, 0xED, 0x93, 0x71,
  // "Ţ" (U+0162)
  0x10, 0x3F, 0xFD, 0x81, 0x70, 0x7C, 0x0F, 0xEC, 0x0F, 0xED, 0x81, 0x40, 0xBA, 0x07, 0x01, 0x30,
  0xBB, 0x01, 0x30, 0x30, 0xEA, 0x83, 0x10, 0xEF, 0x75, 0x0E, 0xA0, 0xD5, 0x85, 0x7F, 0xE0, 0x3F,
  0xE5, 0x02, 0xB0, 0xA5, 0x85, 0x5F, 0xB0, 0x7F, 0x85, 0x05, 0xB0, 0x75, 0x85, 0x6F, 0x80, 0x9E,
  0x35, 0x09, 0xB0, 0x35, 0x81, 0x7E, 0x57, 0x20, 0xCB, 0x77, 0x4B, 0x0C, 0x77, 0x30, 0x3B, 0x09,
  0x77, 0x30, 0x6B, 0x06, 0x77, 0x30, 0x9B, 0x02, 0x77, 0x30, 0xCA, 0x0E, 0x77, 0x4B, 0x0B, 0x77,
  0x30, 0x3B, 0x08, 0x77, 0x30, 0x6B, 0x05, 0x77, 0x30, 0xAB, 0x02, 0x77, 0x30, 0xDA, 0x0E, 0x77,
  0x30, 0x1B, 0x0B, 0x77, 0x30, 0x4B, 0x07, 0x77, 0x30, 0x7B, 0x04, 0x77, 0x30, 0xAB, 0x01, 0x77,
  0x30, 0xDA, 0x0D, 0x77, 0x30, 0x1B, 0x0A, 0x77, 0x30, 0x5B, 0x06, 0x77, 0x30, 0xAB, 0x05, 0x77,
  0x10, 0x10, 0x7C, 0x0B, 0x01, 0x75, 0x06, 0xFB, 0x06, 0x73, 0x0A, 0xFB, 0x03, 0x77, 0x0B, 0x0E,
  0x77, 0x58, 0x12, 0xF9, 0x77, 0x50, 0x9A, 0x09, 0x77, 0x40, 0x40, 0xBA, 0x09, 0x77, 0x50, 0xEA,
  0x77, 0x50, 0xBA, 0x01, 0x77, 0x48, 0x1E, 0xFE, 0x77, 0x83, 0x32, 0x13, 0xBA, 0x09, 0x77, 0x0D,
  0xD0, 0xC0, 0x17, 0x78, 0x4B, 0xEF, 0xEB, 0x67, 0x72,
  // "ţ" (U+0163)
  0x71, 0x81, 0x3F, 0x97, 0x48, 0x1C, 0xF5, 0x73, 0x06, 0xA0, 0x27, 0x20, 0x5A, 0x0E, 0x71, 0x03,
  0x0A, 0xB0, 0xB7, 0x0C, 0xFA, 0x09, 0x30, 0x0E, 0xC8, 0x00, 0xE0, 0x55, 0x09, 0xB7, 0x30, 0xCA,
  0x0C, 0x73, 0xB0, 0x97, 0x20, 0x3B, 0x06, 0x72, 0x06, 0xB0, 0x37, 0x20, 0x9B, 0x73, 0x0D, 0xA0,
  0xC7, 0x3B, 0x09, 0x72, 0x03, 0xB0, 0x67, 0x20, 0x7B, 0x03, 0x72, 0x0A, 0xB7, 0x30, 0xDA, 0x0C,
  0x73, 0xB0, 0x97, 0x20, 0x3B, 0x06, 0x72, 0x05, 0xB0, 0x47, 0x20, 0x6B, 0x02, 0x72, 0x05, 0xB0,
  0x37, 0x20, 0x2B, 0x0A, 0x20, 0x40, 0xA6, 0x0A, 0xE0, 0xD0, 0x16, 0x84, 0x9E, 0xFE, 0xB5, 0x71,
  0x0B, 0x0E, 0x74, 0x81, 0x2F, 0x97, 0x40, 0x9A, 0x09, 0x73, 0x04, 0x0B, 0xA0, 0x97, 0x40, 0xEA,
  0x74, 0x0B, 0xA0, 0x17, 0x38, 0x1E, 0xFE, 0x68, 0x33, 0x21, 0x3B, 0xA0, 0x96, 0x0D, 0xD0, 0xC0,
  0x16, 0x84, 0xBE, 0xFE, 0xB6, 0x71,
  // "Ť" (U+0164)
  0x71, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x38, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x58, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x75, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x78, 0x2C, 0xFE, 0xDA,
  0x04, 0x77, 0x10, 0x7C, 0x07, 0x77, 0x20, 0x3B, 0x0C, 0x80, 0xE0, 0x00, 0x3F, 0xFD, 0x81, 0x70,
  0x7C, 0x0F, 0xEC, 0x0F, 0xED, 0x81, 0x40, 0xBA, 0x07, 0x01, 0x30, 0xBB, 0x01, 0x30, 0x30, 0xEA,
  0x83, 0x10, 0xEF, 0x75, 0x0E, 0xA0, 0xD5, 0x85, 0x7F, 0xE0, 0x3F, 0xE5, 0x02, 0xB0, 0xA5, 0x85,
  0x5F, 0xB0, 0x7F, 0x85, 0x05, 0xB0, 0x75, 0x85, 0x6F, 0x80, 0x9E, 0x35, 0x09, 0xB0, 0x35, 0x81,
  0x7E, 0x57, 0x20, 0xCB, 0x77, 0x4B, 0x0C, 0x77, 0x30, 0x3B, 0x09, 0x77, 0x30, 0x6B, 0x06, 0x77,
  0x30, 0x9B, 0x02, 0x77, 0x30, 0xCA, 0x0E, 0x77, 0x4B, 0x0B, 0x77, 0x30, 0x3B, 0x08, 0x77, 0x30,
  0x6B, 0x05, 0x77, 0x30, 0xAB, 0x02, 0x77, 0x30, 0xDA, 0x0E, 0x77, 0x30, 0x1B, 0x0B, 0x77, 0x30,
  0x4B, 0x07, 0x77, 0x30, 0x7B, 0x04, 0x77, 0x30, 0xAB, 0x01, 0x77, 0x30, 0xDA, 0x0D, 0x77, 0x30,
  0x1B, 0x0A, 0x77, 0x30, 0x5B, 0x06, 0x77, 0x30, 0xAB, 0x05, 0x77, 0x10, 0x10, 0x7C, 0x0B, 0x01,
  0x75, 0x06, 0xFB, 0x06, 0x73, 0x0A, 0xFB, 0x03, 0x73,
  // "ť" (U+0165)
  0x75, 0x0A, 0xA0, 0x87, 0x58, 0x2E, 0xFE, 0x17, 0x40, 0x5A, 0x05, 0x75, 0x81, 0xAF, 0xA7, 0x18,
  0x63, 0xF8, 0x01, 0xFE, 0x17, 0x18, 0x5B, 0xF5, 0x07, 0xF4, 0x71, 0x06, 0xA8, 0x22, 0x04, 0x47,
  0x10, 0x5A, 0x0E, 0x73, 0x03, 0x0A, 0xB0, 0xB7, 0x20, 0xCF, 0xA0, 0x95, 0x00, 0xEC, 0x80, 0x0E,
  0x05, 0x70, 0x9B, 0x75, 0x0C, 0xA0, 0xC7, 0x5B, 0x09, 0x74, 0x03, 0xB0, 0x67, 0x40, 0x6B, 0x03,
  0x74, 0x09, 0xB7, 0x50, 0xDA, 0x0C, 0x75, 0xB0, 0x97, 0x40, 0x3B, 0x06, 0x74, 0x07, 0xB0, 0x37,
  0x40, 0xAB, 0x75, 0x0D, 0xA0, 0xC7, 0x5B, 0x09, 0x74, 0x03, 0xB0, 0x67, 0x40, 0x5B, 0x04, 0x74,
  0x06, 0xB0, 0x27, 0x40, 0x5B, 0x03, 0x74, 0x02, 0xB0, 0xA2, 0x04, 0x0A, 0x71, 0x0A, 0xE0, 0xD0,
  0x17, 0x18, 0x49, 0xEF, 0xEB, 0x57, 0x10,
  // "Ŧ" (U+0166)
  0x10, 0x3F, 0xFD, 0x81, 0x70, 0x7C, 0x0F, 0xEC, 0x0F, 0xED, 0x81, 0x40, 0xBA, 0x06, 0x40, 0xBB,
  0x01, 0x30, 0x30, 0xEA, 0x83, 0x20, 0xEF, 0x75, 0x0E, 0xA0, 0xD5, 0x85, 0x7F, 0xE0, 0x2F, 0xE5,
  0x02, 0xB0, 0xA5, 0x85, 0x5F, 0xB0, 0x6F, 0x95, 0x05, 0xB0, 0x75, 0x85, 0x6F, 0x90, 0xAF, 0x45,
  0x08, 0xB0, 0x45, 0x84, 0x8F, 0x60, 0x12, 0x60, 0xBB, 0x01, 0x50, 0x10, 0x27, 0x30, 0xEA, 0x0D,
  0x77, 0x30, 0x2B, 0x0A, 0x77, 0x30, 0x5B, 0x07, 0x77, 0x30, 0x8B, 0x04, 0x77, 0x30, 0xBB, 0x01,
  0x77, 0x30, 0xEA, 0x0D, 0x75, 0x0D, 0xFF, 0x08, 0x50, 0x18, 0x01, 0xED, 0x80, 0x1E, 0x05, 0x74,
  0x08, 0xB0, 0x37, 0x73, 0x0C, 0xB7, 0x74, 0xB0, 0xC7, 0x73, 0x03, 0xB0, 0x87, 0x73, 0x06, 0xB0,
  0x57, 0x73, 0x09, 0xB0, 0x27, 0x73, 0x0D, 0xA0, 0xE7, 0x73, 0x01, 0xB0, 0xA7, 0x73, 0x04, 0xB0,
  0x77, 0x73, 0x0A, 0xB0, 0x57, 0x71, 0x01, 0x07, 0xC0, 0xA0, 0x17, 0x50, 0x6F, 0xB0, 0x67, 0x30,
  0xAF, 0xB0, 0x37, 0x30,
  // "ŧ" (U+0167)
  0x78, 0x13, 0xF9, 0x73, 0x81, 0xCF, 0x57, 0x20, 0x6A, 0x02, 0x71, 0x05, 0xA0, 0xE7, 0x03, 0x0A,
  0xB0, 0xB6, 0x0C, 0xFA, 0x09, 0x20, 0x0E, 0xC8, 0x00, 0xE0, 0x54, 0x09, 0xB7, 0x20, 0xCA, 0x0C,
  0x72, 0xB0, 0x97, 0x10, 0x3B, 0x06, 0x71, 0x06, 0xB0, 0x37, 0x10, 0x9B, 0x60, 0x3F, 0xB8, 0x31,
  0x05, 0xEE, 0xC0, 0xFE, 0x0D, 0x40, 0x3B, 0x06, 0x71, 0x06, 0xB0, 0x37, 0x10, 0x9B, 0x72, 0x0C,
  0xA0, 0xC7, 0x2B, 0x09, 0x71, 0x03, 0xB0, 0x67, 0x10, 0x5B, 0x04, 0x71, 0x06, 0xB0, 0x27, 0x10,
  0x5B, 0x03, 0x71, 0x02, 0xB0, 0xA2, 0x04, 0x0A, 0x50, 0xAE, 0x0D, 0x01, 0x58, 0x49, 0xEF, 0xEB,
  0x54,
  // "Ũ" (U+0168)
  0x73, 0x83, 0x19, 0xDD, 0x95, 0x09, 0x07, 0x77, 0x0C, 0xC0, 0xC0, 0x12, 0x81, 0x3F, 0x67, 0x68,
  0x38, 0xF4, 0x19, 0xA8, 0x3D, 0x20, 0xBE, 0x77, 0x0E, 0x0A, 0x30, 0x8D, 0x05, 0x76, 0x81, 0x3A,
  0x34, 0x83, 0x5D, 0xFC, 0x58, 0x0E, 0x70, 0x07, 0xFA, 0x0D, 0x40, 0x5F, 0x98, 0x15, 0x09, 0xFA,
  0x0A, 0x40, 0x8F, 0x90, 0x33, 0x05, 0xC0, 0xD0, 0x47, 0x10, 0x40, 0xEA, 0x08, 0x02, 0x60, 0xDB,
  0x03, 0x73, 0x81, 0xBF, 0xA7, 0x1B, 0x0C, 0x74, 0x81, 0xDF, 0x57, 0x03, 0xB0, 0x97, 0x30, 0x1A,
  0x01, 0x70, 0x6B, 0x05, 0x73, 0x81, 0x4F, 0xD7, 0x10, 0x9B, 0x02, 0x73, 0x81, 0x8F, 0xA7, 0x10,
  0xDA, 0x0E, 0x74, 0x81, 0xBF, 0x77, 0x1B, 0x0B, 0x74, 0x81, 0xEF, 0x37, 0x04, 0xB0, 0x87, 0x30,
  0x2A, 0x71, 0x07, 0xB0, 0x57, 0x38, 0x15, 0xFC, 0x71, 0x0A, 0xB0, 0x17, 0x38, 0x18, 0xF9, 0x71,
  0x0E, 0xA0, 0xD7, 0x48, 0x1C, 0xF5, 0x70, 0x1B, 0x0A, 0x74, 0xA0, 0x27, 0x05, 0xB0, 0x77, 0x38,
  0x13, 0xFE, 0x71, 0x08, 0xB0, 0x47, 0x38, 0x16, 0xFB, 0x71, 0x0B, 0xB7, 0x48, 0x19, 0xF8, 0x71,
  0x0E, 0xA0, 0xD7, 0x48, 0x1D, 0xF4, 0x70, 0x2B, 0x0A, 0x74, 0xA0, 0x17, 0x05, 0xB0, 0x77, 0x38,
  0x14, 0xFD, 0x71, 0x06, 0xB0, 0x57, 0x38, 0x18, 0xF9, 0x71, 0x07, 0xB0, 0x47, 0x38, 0x1D, 0xF4,
  0x71, 0x06, 0xB0, 0x47, 0x28, 0x14, 0xFD, 0x72, 0x02, 0xB0, 0x77, 0x28, 0x1C, 0xF6, 0x73, 0x0C,
  0xA0, 0xE0, 0x17, 0x81, 0xAF, 0xB7, 0x40, 0x3B, 0x81, 0xD6, 0x12, 0x84, 0x16, 0xDF, 0xC1, 0x75,
  0x04, 0x0D, 0xFA, 0x0A, 0x77, 0x28, 0x76, 0xAD, 0xEF, 0xEC, 0x82, 0x76,
  // "ũ" (U+0169)
  0x78, 0x31, 0x9D, 0xD9, 0x50, 0x90, 0x77, 0x0C, 0xC0, 0xC0, 0x12, 0x81, 0x3F, 0x66, 0x83, 0x8F,
  0x41, 0x9A, 0x83, 0xD2, 0x0B, 0xE7, 0x0E, 0x0A, 0x30, 0x8D, 0x05, 0x68, 0x13, 0xA3, 0x48, 0x35,
  0xDF, 0xC5, 0x80, 0xC4, 0x00, 0x2E, 0x07, 0x60, 0xBA, 0x81, 0xD0, 0x5E, 0x04, 0x60, 0xEA, 0x0A,
  0x30, 0x5C, 0x01, 0x50, 0x2B, 0x07, 0x40, 0xDA, 0x0D, 0x60, 0x5B, 0x04, 0x40, 0xEA, 0x0A, 0x60,
  0x8B, 0x01, 0x30, 0x1B, 0x07, 0x60, 0xBA, 0x0D, 0x40, 0x4B, 0x03, 0x60, 0xEA, 0x0A, 0x40, 0x8B,
  0x60, 0x2B, 0x07, 0x40, 0xBA, 0x0D, 0x60, 0x5B, 0x04, 0x40, 0xEA, 0x09, 0x60, 0x9B, 0x01, 0x30,
  0x3B, 0x06, 0x60, 0xCA, 0x0D, 0x40, 0x6B, 0x03, 0x6B, 0x0A, 0x40, 0x9B, 0x60, 0x5B, 0x06, 0x40,
  0xDA, 0x0C, 0x60, 0xAB, 0x03, 0x30, 0x1B, 0x09, 0x50, 0x2C, 0x40, 0x4B, 0x06, 0x50, 0x9B, 0x0D,
  0x40, 0x5B, 0x04, 0x40, 0x3C, 0x0B, 0x40, 0x7B, 0x03, 0x48, 0x1C, 0x9E, 0xA0, 0xA4, 0x06, 0xB0,
  0x43, 0x0A, 0x0C, 0x1B, 0x0A, 0x40, 0x3B, 0x86, 0xA0, 0x2B, 0xD1, 0x0E, 0xA8, 0x5D, 0x01, 0x92,
  0x0C, 0xD0, 0xD0, 0x12, 0x09, 0xD8, 0x7E, 0x30, 0x2B, 0xEF, 0xC7, 0x58, 0x39, 0xEE, 0xC7, 0x20,
  // "Ū" (U+016A)
  0x72, 0x01, 0x80, 0x5E, 0x0C, 0x77, 0x10, 0x5F, 0xA0, 0x98, 0x0E, 0x70, 0x07, 0xFA, 0x0D, 0x40,
  0x5F, 0x98, 0x15, 0x09, 0xFA, 0x0A, 0x40, 0x8F, 0x90, 0x33, 0x05, 0xC0, 0xD0, 0x47, 0x10, 0x40,
  0xEA, 0x08, 0x02, 0x60, 0xDB, 0x03, 0x73, 0x81, 0xBF, 0xA7, 0x1B, 0x0C, 0x74, 0x81, 0xDF, 0x57,
  0x03, 0xB0, 0x97, 0x30, 0x1A, 0x01, 0x70, 0x6B, 0x05, 0x73, 0x81, 0x4F, 0xD7, 0x10, 0x9B, 0x02,
  0x73, 0x81, 0x8F, 0xA7, 0x10, 0xDA, 0x0E, 0x74, 0x81, 0xBF, 0x77, 0x1B, 0x0B, 0x74, 0x81, 0xEF,
  0x37, 0x04, 0xB0, 0x87, 0x30, 0x2A, 0x71, 0x07, 0xB0, 0x57, 0x38, 0x15, 0xFC, 0x71, 0x0A, 0xB0,
  0x17, 0x38, 0x18, 0xF9, 0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1C, 0xF5, 0x70, 0x1B, 0x0A, 0x74, 0xA0,
  0x27, 0x05, 0xB0, 0x77, 0x38, 0x13, 0xFE, 0x71, 0x08, 0xB0, 0x47, 0x38, 0x16, 0xFB, 0x71, 0x0B,
  0xB7, 0x48, 0x19, 0xF8, 0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1D, 0xF4, 0x70, 0x2B, 0x0A, 0x74, 0xA0,
  0x17, 0x05, 0xB0, 0x77, 0x38, 0x14, 0xFD, 0x71, 0x06, 0xB0, 0x57, 0x38, 0x18, 0xF9, 0x71, 0x07,
  0xB0, 0x47, 0x38, 0x1D, 0xF4, 0x71, 0x06, 0xB0, 0x47, 0x28, 0x14, 0xFD, 0x72, 0x02, 0xB0, 0x77,
  0x28, 0x1C, 0xF6, 0x73, 0x0C, 0xA0, 0xE0, 0x17, 0x81, 0xAF, 0xB7, 0x40, 0x3B, 0x81, 0xD6, 0x12,
  0x84, 0x16, 0xDF, 0xC1, 0x75, 0x04, 0x0D, 0xFA, 0x0A, 0x77, 0x28, 0x76, 0xAD, 0xEF, 0xEC, 0x82,
  0x76,
  // "ū" (U+016B)
  0x60, 0x18, 0x05, 0xE0, 0xC7, 0x10, 0x5F, 0xA0, 0x98, 0x0C, 0x40, 0x02, 0xE0, 0x76, 0x0B, 0xA8,
  0x1D, 0x05, 0xE0, 0x46, 0x0E, 0xA0, 0xA3, 0x05, 0xC0, 0x15, 0x02, 0xB0, 0x74, 0x0D, 0xA0, 0xD6,
  0x05, 0xB0, 0x44, 0x0E, 0xA0, 0xA6, 0x08, 0xB0, 0x13, 0x01, 0xB0, 0x76, 0x0B, 0xA0, 0xD4, 0x04,
  0xB0, 0x36, 0x0E, 0xA0, 0xA4, 0x08, 0xB6, 0x02, 0xB0, 0x74, 0x0B, 0xA0, 0xD6, 0x05, 0xB0, 0x44,
  0x0E, 0xA0, 0x96, 0x09, 0xB0, 0x13, 0x03, 0xB0, 0x66, 0x0C, 0xA0, 0xD4, 0x06, 0xB0, 0x36, 0xB0,
  0xA4, 0x09, 0xB6, 0x05, 0xB0, 0x64, 0x0D, 0xA0, 0xC6, 0x0A, 0xB0, 0x33, 0x01, 0xB0, 0x95, 0x02,
  0xC4, 0x04, 0xB0, 0x65, 0x09, 0xB0, 0xD4, 0x05, 0xB0, 0x44, 0x03, 0xC0, 0xB4, 0x07, 0xB0, 0x34,
  0x81, 0xC9, 0xEA, 0x0A, 0x40, 0x6B, 0x04, 0x30, 0xA0, 0xC1, 0xB0, 0xA4, 0x03, 0xB8, 0x6A, 0x02,
  0xBD, 0x10, 0xEA, 0x85, 0xD0, 0x19, 0x20, 0xCD, 0x0D, 0x01, 0x20, 0x9D, 0x87, 0xE3, 0x02, 0xBE,
  0xFC, 0x75, 0x83, 0x9E, 0xEC, 0x72,
  // "Ŭ" (U+016C)
  0x72, 0x81, 0x37, 0x25, 0x81, 0x17, 0x47, 0x71, 0x81, 0x5F, 0x85, 0x81, 0x9F, 0x47, 0x71, 0x82,
  0x2F, 0xE4, 0x28, 0x21, 0x9F, 0xD7, 0x73, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x77, 0x30, 0x5E, 0x07,
  0x77, 0x58, 0x45, 0xCF, 0xEB, 0x48, 0x0F, 0x20, 0x07, 0xFA, 0x0D, 0x40, 0x5F, 0x98, 0x15, 0x09,
  0xFA, 0x0A, 0x40, 0x8F, 0x90, 0x33, 0x05, 0xC0, 0xD0, 0x47, 0x10, 0x40, 0xEA, 0x08, 0x02, 0x60,
  0xDB, 0x03, 0x73, 0x81, 0xBF, 0xA7, 0x1B, 0x0C, 0x74, 0x81, 0xDF, 0x57, 0x03, 0xB0, 0x97, 0x30,
  0x1A, 0x01, 0x70, 0x6B, 0x05, 0x73, 0x81, 0x4F, 0xD7, 0x10, 0x9B, 0x02, 0x73, 0x81, 0x8F, 0xA7,
  0x10, 0xDA, 0x0E, 0x74, 0x81, 0xBF, 0x77, 0x1B, 0x0B, 0x74, 0x81, 0xEF, 0x37, 0x04, 0xB0, 0x87,
  0x30, 0x2A, 0x71, 0x07, 0xB0, 0x57, 0x38, 0x15, 0xFC, 0x71, 0x0A, 0xB0, 0x17, 0x38, 0x18, 0xF9,
  0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1C, 0xF5, 0x70, 0x1B, 0x0A, 0x74, 0xA0, 0x27, 0x05, 0xB0, 0x77,
  0x38, 0x13, 0xFE, 0x71, 0x08, 0xB0, 0x47, 0x38, 0x16, 0xFB, 0x71, 0x0B, 0xB7, 0x48, 0x19, 0xF8,
  0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1D, 0xF4, 0x70, 0x2B, 0x0A, 0x74, 0xA0, 0x17, 0x05, 0xB0, 0x77,
  0x38, 0x14, 0xFD, 0x71, 0x06, 0xB0, 0x57, 0x38, 0x18, 0xF9, 0x71, 0x07, 0xB0, 0x47, 0x38, 0x1D,
  0xF4, 0x71, 0x06, 0xB0, 0x47, 0x28, 0x14, 0xFD, 0x72, 0x02, 0xB0, 0x77, 0x28, 0x1C, 0xF6, 0x73,
  0x0C, 0xA0, 0xE0, 0x17, 0x81, 0xAF, 0xB7, 0x40, 0x3B, 0x81, 0xD6, 0x12, 0x84, 0x16, 0xDF, 0xC1,
  0x75, 0x04, 0x0D, 0xFA, 0x0A, 0x77, 0x28, 0x76, 0xAD, 0xEF, 0xEC, 0x82, 0x76,
  // "ŭ" (U+016D)
  0x78, 0x13, 0x72, 0x58, 0x11, 0x74, 0x71, 0x81, 0x5F, 0x85, 0x81, 0x9F, 0x47, 0x18, 0x22, 0xFE,
  0x42, 0x82, 0x19, 0xFD, 0x73, 0x0D, 0xA0, 0xE0, 0xDB, 0x04, 0x73, 0x05, 0xE0, 0x77, 0x58, 0x45,
  0xCF, 0xEB, 0x48, 0x0C, 0x60, 0x02, 0xE0, 0x76, 0x0B, 0xA8, 0x1D, 0x05, 0xE0, 0x46, 0x0E, 0xA0,
  0xA3, 0x05, 0xC0, 0x15, 0x02, 0xB0, 0x74, 0x0D, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0xA6,
  0x08, 0xB0, 0x13, 0x01, 0xB0, 0x76, 0x0B, 0xA0, 0xD4, 0x04, 0xB0, 0x36, 0x0E, 0xA0, 0xA4, 0x08,
  0xB6, 0x02, 0xB0, 0x74, 0x0B, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0x96, 0x09, 0xB0, 0x13,
  0x03, 0xB0, 0x66, 0x0C, 0xA0, 0xD4, 0x06, 0xB0, 0x36, 0xB0, 0xA4, 0x09, 0xB6, 0x05, 0xB0, 0x64,
  0x0D, 0xA0, 0xC6, 0x0A, 0xB0, 0x33, 0x01, 0xB0, 0x95, 0x02, 0xC4, 0x04, 0xB0, 0x65, 0x09, 0xB0,
  0xD4, 0x05, 0xB0, 0x44, 0x03, 0xC0, 0xB4, 0x07, 0xB0, 0x34, 0x81, 0xC9, 0xEA, 0x0A, 0x40, 0x6B,
  0x04, 0x30, 0xA0, 0xC1, 0xB0, 0xA4, 0x03, 0xB8, 0x6A, 0x02, 0xBD, 0x10, 0xEA, 0x85, 0xD0, 0x19,
  0x20, 0xCD, 0x0D, 0x01, 0x20, 0x9D, 0x87, 0xE3, 0x02, 0xBE, 0xFC, 0x75, 0x83, 0x9E, 0xEC, 0x72,
  // "Ů" (U+016E)
  0x75, 0x84, 0x8D, 0xFD, 0x81, 0x77, 0x50, 0xCD, 0x0D, 0x77, 0x48, 0x76, 0xFC, 0x20, 0x2C, 0xF6,
  0x77, 0x38, 0x19, 0xF4, 0x38, 0x15, 0xF8, 0x77, 0x38, 0x1A, 0xF4, 0x38, 0x16, 0xF8, 0x77, 0x38,
  0x77, 0xFB, 0x10, 0x3D, 0xF4, 0x77, 0x30, 0x10, 0xED, 0x0B, 0x77, 0x58, 0x41, 0x9D, 0xFD, 0x78,
  0x0F, 0x20, 0x07, 0xFA, 0x0D, 0x40, 0x5F, 0x98, 0x15, 0x09, 0xFA, 0x0A, 0x40, 0x8F, 0x90, 0x33,
  0x05, 0xC0, 0xD0, 0x47, 0x10, 0x40, 0xEA, 0x08, 0x02, 0x60, 0xDB, 0x03, 0x73, 0x81, 0xBF, 0xA7,
  0x1B, 0x0C, 0x74, 0x81, 0xDF, 0x57, 0x03, 0xB0, 0x97, 0x30, 0x1A, 0x01, 0x70, 0x6B, 0x05, 0x73,
  0x81, 0x4F, 0xD7, 0x10, 0x9B, 0x02, 0x73, 0x81, 0x8F, 0xA7, 0x10, 0xDA, 0x0E, 0x74, 0x81, 0xBF,
  0x77, 0x1B, 0x0B, 0x74, 0x81, 0xEF, 0x37, 0x04, 0xB0, 0x87, 0x30, 0x2A, 0x71, 0x07, 0xB0, 0x57,
  0x38, 0x15, 0xFC, 0x71, 0x0A, 0xB0, 0x17, 0x38, 0x18, 0xF9, 0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1C,
  0xF5, 0x70, 0x1B, 0x0A, 0x74, 0xA0, 0x27, 0x05, 0xB0, 0x77, 0x38, 0x13, 0xFE, 0x71, 0x08, 0xB0,
  0x47, 0x38, 0x16, 0xFB, 0x71, 0x0B, 0xB7, 0x48, 0x19, 0xF8, 0x71, 0x0E, 0xA0, 0xD7, 0x48, 0x1D,
  0xF4, 0x70, 0x2B, 0x0A, 0x74, 0xA0, 0x17, 0x05, 0xB0, 0x77, 0x38, 0x14, 0xFD, 0x71, 0x06, 0xB0,
  0x57, 0x38, 0x18, 0xF9, 0x71, 0x07, 0xB0, 0x47, 0x38, 0x1D, 0xF4, 0x71, 0x06, 0xB0, 0x47, 0x28,
  0x14, 0xFD, 0x72, 0x02, 0xB0, 0x77, 0x28, 0x1C, 0xF6, 0x73, 0x0C, 0xA0, 0xE0, 0x17, 0x81, 0xAF,
  0xB7, 0x40, 0x3B, 0x81, 0xD6, 0x12, 0x84, 0x16, 0xDF, 0xC1, 0x75, 0x04, 0x0D, 0xFA, 0x0A, 0x77,
  0x28, 0x76, 0xAD, 0xEF, 0xEC, 0x82, 0x76,
  // "ů" (U+016F)
  0x72, 0x84, 0x8D, 0xFD, 0x81, 0x75, 0x0C, 0xD0, 0xD7, 0x48, 0x76, 0xFC, 0x20, 0x2C, 0xF6, 0x73,
  0x81, 0x9F, 0x43, 0x81, 0x5F, 0x87, 0x38, 0x1A, 0xF4, 0x38, 0x16, 0xF8, 0x73, 0x87, 0x7F, 0xB1,
  0x03, 0xDF, 0x47, 0x30, 0x10, 0xED, 0x0B, 0x75, 0x84, 0x19, 0xDF, 0xD7, 0x80, 0xC7, 0x00, 0x2E,
  0x07, 0x60, 0xBA, 0x81, 0xD0, 0x5E, 0x04, 0x60, 0xEA, 0x0A, 0x30, 0x5C, 0x01, 0x50, 0x2B, 0x07,
  0x40, 0xDA, 0x0D, 0x60, 0x5B, 0x04, 0x40, 0xEA, 0x0A, 0x60, 0x8B, 0x01, 0x30, 0x1B, 0x07, 0x60,
  0xBA, 0x0D, 0x40, 0x4B, 0x03, 0x60, 0xEA, 0x0A, 0x40, 0x8B, 0x60, 0x2B, 0x07, 0x40, 0xBA, 0x0D,
  0x60, 0x5B, 0x04, 0x40, 0xEA, 0x09, 0x60, 0x9B, 0x01, 0x30, 0x3B, 0x06, 0x60, 0xCA, 0x0D, 0x40,
  0x6B, 0x03, 0x6B, 0x0A, 0x40, 0x9B, 0x60, 0x5B, 0x06, 0x40, 0xDA, 0x0C, 0x60, 0xAB, 0x03, 0x30,
  0x1B, 0x09, 0x50, 0x2C, 0x40, 0x4B, 0x06, 0x50, 0x9B, 0x0D, 0x40, 0x5B, 0x04, 0x40, 0x3C, 0x0B,
  0x40, 0x7B, 0x03, 0x48, 0x1C, 0x9E, 0xA0, 0xA4, 0x06, 0xB0, 0x43, 0x0A, 0x0C, 0x1B, 0x0A, 0x40,
  0x3B, 0x86, 0xA0, 0x2B, 0xD1, 0x0E, 0xA8, 0x5D, 0x01, 0x92, 0x0C, 0xD0, 0xD0, 0x12, 0x09, 0xD8,
  0x7E, 0x30, 0x2B, 0xEF, 0xC7, 0x58, 0x39, 0xEE, 0xC7, 0x20,
  // "Ű" (U+0170)
  0x76, 0x0C, 0xA8, 0x2E, 0x10, 0x9B, 0x04, 0x77, 0x08, 0xA8, 0x2E, 0x30, 0x4B, 0x06, 0x77, 0x03,
  0xA0, 0xE0, 0x32, 0x0D, 0xA0, 0x67, 0x71, 0x82, 0xDF, 0xE2, 0x20, 0xAA, 0x05, 0x77, 0x18, 0x2A,
  0xFD, 0x22, 0x82, 0x6F, 0xE4, 0x77, 0x18, 0x25, 0xFA, 0x12, 0x82, 0x1F, 0xD2, 0x80, 0xF0, 0x00,
  0x7F, 0xA0, 0xD4, 0x05, 0xF9, 0x81, 0x50, 0x9F, 0xA0, 0xA4, 0x08, 0xF9, 0x03, 0x30, 0x5C, 0x0D,
  0x04, 0x71, 0x04, 0x0E, 0xA0, 0x80, 0x26, 0x0D, 0xB0, 0x37, 0x38, 0x1B, 0xFA, 0x71, 0xB0, 0xC7,
  0x48, 0x1D, 0xF5, 0x70, 0x3B, 0x09, 0x73, 0x01, 0xA0, 0x17, 0x06, 0xB0, 0x57, 0x38, 0x14, 0xFD,
  0x71, 0x09, 0xB0, 0x27, 0x38, 0x18, 0xFA, 0x71, 0x0D, 0xA0, 0xE7, 0x48, 0x1B, 0xF7, 0x71, 0xB0,
  0xB7, 0x48, 0x1E, 0xF3, 0x70, 0x4B, 0x08, 0x73, 0x02, 0xA7, 0x10, 0x7B, 0x05, 0x73, 0x81, 0x5F,
  0xC7, 0x10, 0xAB, 0x01, 0x73, 0x81, 0x8F, 0x97, 0x10, 0xEA, 0x0D, 0x74, 0x81, 0xCF, 0x57, 0x01,
  0xB0, 0xA7, 0x4A, 0x02, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x3F, 0xE7, 0x10, 0x8B, 0x04, 0x73, 0x81,
  0x6F, 0xB7, 0x10, 0xBB, 0x74, 0x81, 0x9F, 0x87, 0x10, 0xEA, 0x0D, 0x74, 0x81, 0xDF, 0x47, 0x02,
  0xB0, 0xA7, 0x4A, 0x01, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x4F, 0xD7, 0x10, 0x6B, 0x05, 0x73, 0x81,
  0x8F, 0x97, 0x10, 0x7B, 0x04, 0x73, 0x81, 0xDF, 0x47, 0x10, 0x6B, 0x04, 0x72, 0x81, 0x4F, 0xD7,
  0x20, 0x2B, 0x07, 0x72, 0x81, 0xCF, 0x67, 0x30, 0xCA, 0x0E, 0x01, 0x78, 0x1A, 0xFB, 0x74, 0x03,
  0xB8, 0x1D, 0x61, 0x28, 0x41, 0x6D, 0xFC, 0x17, 0x50, 0x40, 0xDF, 0xA0, 0xA7, 0x72, 0x87, 0x6A,
  0xDE, 0xFE, 0xC8, 0x27, 0x60,
  // "ű" (U+0171)
  0x73, 0x0C, 0xA8, 0x2E, 0x10, 0x9B, 0x04, 0x72, 0x08, 0xA8, 0x2E, 0x30, 0x4B, 0x06, 0x72, 0x03,
  0xA0, 0xE0, 0x32, 0x0D, 0xA0, 0x67, 0x38, 0x2D, 0xFE, 0x22, 0x0A, 0xA0, 0x57, 0x38, 0x2A, 0xFD,
  0x22, 0x82, 0x6F, 0xE4, 0x73, 0x82, 0x5F, 0xA1, 0x28, 0x21, 0xFD, 0x28, 0x0D, 0x30, 0x02, 0xE0,
  0x76, 0x0B, 0xA0, 0xD3, 0x05, 0xE0, 0x46, 0x0E, 0xA0, 0xA5, 0x05, 0xC0, 0x15, 0x02, 0xB0, 0x76,
  0x0D, 0xA0, 0xD6, 0x05, 0xB0, 0x46, 0x0E, 0xA0, 0xA6, 0x08, 0xB0, 0x15, 0x01, 0xB0, 0x76, 0x0B,
  0xA0, 0xD6, 0x04, 0xB0, 0x36, 0x0E, 0xA0, 0xA6, 0x08, 0xB6, 0x02, 0xB0, 0x76, 0x0B, 0xA0, 0xD6,
  0x05, 0xB0, 0x46, 0x0E, 0xA0, 0x96, 0x09, 0xB0, 0x15, 0x03, 0xB0, 0x66, 0x0C, 0xA0, 0xD6, 0x06,
  0xB0, 0x36, 0xB0, 0xA6, 0x09, 0xB6, 0x05, 0xB0, 0x66, 0x0D, 0xA0, 0xC6, 0x0A, 0xB0, 0x35, 0x01,
  0xB0, 0x95, 0x02, 0xC6, 0x04, 0xB0, 0x65, 0x09, 0xB0, 0xD6, 0x05, 0xB0, 0x44, 0x03, 0xC0, 0xB6,
  0x07, 0xB0, 0x34, 0x81, 0xC9, 0xEA, 0x0A, 0x60, 0x6B, 0x04, 0x30, 0xA0, 0xC1, 0xB0, 0xA6, 0x03,
  0xB8, 0x6A, 0x02, 0xBD, 0x10, 0xEA, 0x83, 0xD0, 0x19, 0x23, 0x0C, 0xD0, 0xD0, 0x12, 0x09, 0xD0,
  0xE0, 0x33, 0x84, 0x2B, 0xEF, 0xC7, 0x58, 0x39, 0xEE, 0xC7, 0x40,
  // "Ų" (U+0172)
  0x10, 0x7F, 0xA0, 0xD4, 0x05, 0xF9, 0x81, 0x50, 0x9F, 0xA0, 0xA4, 0x08, 0xF9, 0x03, 0x30, 0x5C,
  0x0D, 0x04, 0x71, 0x04, 0x0E, 0xA0, 0x80, 0x26, 0x0D, 0xB0, 0x37, 0x38, 0x1B, 0xFA, 0x71, 0xB0,
  0xC7, 0x48, 0x1D, 0xF5, 0x70, 0x3B, 0x09, 0x73, 0x01, 0xA0, 0x17, 0x06, 0xB0, 0x57, 0x38, 0x14,
  0xFD, 0x71, 0x09, 0xB0, 0x27, 0x38, 0x18, 0xFA, 0x71, 0x0D, 0xA0, 0xE7, 0x48, 0x1B, 0xF7, 0x71,
  0xB0, 0xB7, 0x48, 0x1E, 0xF3, 0x70, 0x4B, 0x08, 0x73, 0x02, 0xA7, 0x10, 0x7B, 0x05, 0x73, 0x81,
  0x5F, 0xC7, 0x10, 0xAB, 0x01, 0x73, 0x81, 0x8F, 0x97, 0x10, 0xEA, 0x0D, 0x74, 0x81, 0xCF, 0x57,
  0x01, 0xB0, 0xA7, 0x4A, 0x02, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x3F, 0xE7, 0x10, 0x8B, 0x04, 0x73,
  0x81, 0x6F, 0xB7, 0x10, 0xBB, 0x74, 0x81, 0x9F, 0x87, 0x10, 0xEA, 0x0D, 0x74, 0x81, 0xDF, 0x47,
  0x02, 0xB0, 0xA7, 0x4A, 0x01, 0x70, 0x5B, 0x07, 0x73, 0x81, 0x4F, 0xD7, 0x10, 0x6B, 0x05, 0x73,
  0x81, 0x8F, 0x97, 0x10, 0x7B, 0x04, 0x73, 0x81, 0xDF, 0x47, 0x10, 0x6B, 0x04, 0x72, 0x81, 0x4F,
  0xD7, 0x20, 0x2B, 0x07, 0x72, 0x81, 0xCF, 0x67, 0x30, 0xCA, 0x0E, 0x01, 0x78, 0x1A, 0xFB, 0x74,
  0x03, 0xB8, 0x1D, 0x61, 0x28, 0x41, 0x6D, 0xFC, 0x17, 0x50, 0x40, 0xDF, 0xA0, 0xA7, 0x72, 0x87,
  0x6A, 0xDE, 0xFE, 0xC8, 0x27, 0x77, 0x81, 0x17, 0x67, 0x77, 0x82, 0x1A, 0xF9, 0x77, 0x78, 0x23,
  0xDF, 0x77, 0x77, 0x82, 0x1E, 0xFC, 0x77, 0x71, 0x08, 0xA0, 0x67, 0x77, 0x10, 0xBA, 0x04, 0x77,
  0x71, 0x0B, 0xA0, 0x67, 0x77, 0x10, 0x9A, 0x83, 0xE7, 0x58, 0x37, 0x74, 0x02, 0xE0, 0x27, 0x75,
  0x84, 0x2A, 0xEE, 0xC7, 0x77, 0x10,
  // "ų" (U+0173)
  0x02, 0xE0, 0x76, 0x0B, 0xA8, 0x1D, 0x05, 0xE0, 0x46, 0x0E, 0xA0, 0xA3, 0x05, 0xC0, 0x15, 0x02,
  0xB0, 0x74, 0x0D, 0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0xA6, 0x08, 0xB0, 0x13, 0x01, 0xB0,
  0x76, 0x0B, 0xA0, 0xD4, 0x04, 0xB0, 0x36, 0x0E, 0xA0, 0xA4, 0x08, 0xB6, 0x02, 0xB0, 0x74, 0x0B,
  0xA0, 0xD6, 0x05, 0xB0, 0x44, 0x0E, 0xA0, 0x96, 0x09, 0xB0, 0x13, 0x03, 0xB0, 0x66, 0x0C, 0xA0,
  0xD4, 0x06, 0xB0, 0x36, 0xB0, 0xA4, 0x09, 0xB6, 0x05, 0xB0, 0x64, 0x0D, 0xA0, 0xC6, 0x0A, 0xB0,
  0x33, 0x01, 0xB0, 0x95, 0x02, 0xC4, 0x04, 0xB0, 0x65, 0x09, 0xB0, 0xD4, 0x05, 0xB0, 0x44, 0x03,
  0xC0, 0xB4, 0x07, 0xB0, 0x34, 0x81, 0xC9, 0xEA, 0x0A, 0x40, 0x6B, 0x04, 0x30, 0xA0, 0xC1, 0xB0,
  0xA4, 0x03, 0xB8, 0x6A, 0x02, 0xBD, 0x10, 0xEA, 0x85, 0xD0, 0x19, 0x20, 0xCD, 0x0D, 0x01, 0x20,
  0x9D, 0x87, 0xE3, 0x02, 0xBE, 0xFC, 0x75, 0x83, 0x9E, 0xEC, 0x77, 0x78, 0x11, 0x76, 0x77, 0x82,
  0x1A, 0xF9, 0x77, 0x82, 0x3D, 0xF7, 0x77, 0x82, 0x1E, 0xFC, 0x77, 0x10, 0x8A, 0x06, 0x77, 0x10,
  0xBA, 0x04, 0x77, 0x10, 0xBA, 0x06, 0x77, 0x10, 0x9A, 0x83, 0xE7, 0x58, 0x37, 0x40, 0x2E, 0x02,
  0x75, 0x84, 0x2A, 0xEE, 0xC7, 0x40,
  // "Ŵ" (U+0174)
  0x77, 0x50, 0x60, 0xF7, 0x77, 0x77, 0x40, 0x5C, 0x02, 0x77, 0x77, 0x20, 0x20, 0xEC, 0x06, 0x77,
  0x77, 0x28, 0x5C, 0xFE, 0x6E, 0xFC, 0x77, 0x77, 0x18, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x77, 0x76,
  0x82, 0x8F, 0xD2, 0x38, 0x1B, 0xFA, 0x77, 0x75, 0x82, 0x5F, 0xA1, 0x40, 0x10, 0xC9, 0x80, 0x9A,
  0x30, 0x0D, 0xF9, 0x0C, 0x60, 0x1A, 0x0C, 0x70, 0xBF, 0x0B, 0x01, 0xFA, 0x09, 0x60, 0x7A, 0x0D,
  0x70, 0xDF, 0x07, 0x20, 0x4C, 0x0D, 0x03, 0x71, 0x0E, 0xA0, 0xD7, 0x20, 0xAA, 0x0E, 0x04, 0x50,
  0xCB, 0x06, 0x71, 0x05, 0xB0, 0xE7, 0x20, 0x6A, 0x05, 0x60, 0xAB, 0x03, 0x71, 0x0C, 0xC7, 0x28,
  0x19, 0xFC, 0x70, 0xAB, 0x03, 0x70, 0x4D, 0x72, 0x81, 0xEF, 0x57, 0x09, 0xB0, 0x37, 0x0A, 0xD0,
  0x17, 0x81, 0x6F, 0xD7, 0x10, 0x8B, 0x04, 0x60, 0x2A, 0x0B, 0xB0, 0x27, 0x81, 0xDF, 0x67, 0x10,
  0x8B, 0x05, 0x68, 0x28, 0xFC, 0x7B, 0x02, 0x68, 0x14, 0xFE, 0x72, 0x07, 0xB0, 0x56, 0x82, 0xEF,
  0x56, 0xB0, 0x36, 0x81, 0xBF, 0x87, 0x20, 0x6B, 0x06, 0x58, 0x37, 0xFD, 0x05, 0xB0, 0x45, 0x03,
  0xA0, 0x17, 0x20, 0x6B, 0x07, 0x58, 0x3D, 0xF7, 0x04, 0xB0, 0x55, 0x81, 0xAF, 0x97, 0x30, 0x5B,
  0x07, 0x48, 0x45, 0xFE, 0x10, 0x4B, 0x05, 0x40, 0x2A, 0x03, 0x73, 0x04, 0xB0, 0x84, 0x81, 0xBF,
  0x92, 0x03, 0xB0, 0x64, 0x81, 0x8F, 0xB7, 0x40, 0x4B, 0x09, 0x30, 0x3A, 0x02, 0x20, 0x2B, 0x07,
  0x38, 0x21, 0xEF, 0x47, 0x40, 0x3B, 0x09, 0x38, 0x1A, 0xFA, 0x30, 0x2B, 0x08, 0x38, 0x17, 0xFD,
  0x75, 0x02, 0xB0, 0xA2, 0x01, 0xA0, 0x33, 0x01, 0xB0, 0x83, 0x81, 0xDF, 0x67, 0x50, 0x2B, 0x0A,
  0x28, 0x18, 0xFC, 0x5B, 0x09, 0x28, 0x15, 0xFE, 0x76, 0x01, 0xB0, 0xB2, 0x81, 0xEF, 0x55, 0xB0,
  0xA2, 0x81, 0xCF, 0x77, 0x7B, 0x83, 0xB0, 0x5F, 0xD6, 0x0E, 0xA8, 0x1A, 0x03, 0xA0, 0x17, 0x7B,
  0x83, 0xB0, 0xCF, 0x76, 0x0E, 0xA8, 0x3A, 0x0A, 0xF9, 0x77, 0x1B, 0x83, 0xC2, 0xFE, 0x16, 0x0D,
  0xA0, 0xB0, 0x1A, 0x02, 0x77, 0x10, 0xEA, 0x82, 0xC8, 0xF9, 0x70, 0xCA, 0x82, 0xB7, 0xFB, 0x77,
  0x20, 0xDA, 0x82, 0xBD, 0xF2, 0x70, 0xBA, 0x82, 0xAC, 0xF4, 0x77, 0x20, 0xDA, 0x81, 0xEF, 0xA7,
  0x10, 0xBA, 0x81, 0xDF, 0xC7, 0x73, 0x0C, 0xC0, 0x37, 0x10, 0xAC, 0x05, 0x77, 0x30, 0xBB, 0x0C,
  0x72, 0x09, 0xB0, 0xD7, 0x74, 0x0B, 0xB0, 0x57, 0x20, 0x9B, 0x07, 0x77, 0x40, 0xAA, 0x0D, 0x73,
  0x08, 0xA0, 0xE0, 0x17, 0x70,
  // "ŵ" (U+0175)
  0x77, 0x10, 0x60, 0xF7, 0x77, 0x71, 0x05, 0xC0, 0x27, 0x76, 0x02, 0x0E, 0xC0, 0x67, 0x76, 0x85,
  0xCF, 0xE6, 0xEF, 0xC7, 0x75, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x73, 0x82, 0x8F, 0xD2, 0x38,
  0x1B, 0xFA, 0x77, 0x28, 0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0F, 0x00, 0x0B, 0xC0, 0xC7, 0x09,
  0xA0, 0xB6, 0x83, 0xAE, 0x90, 0xEC, 0x0C, 0x70, 0xEA, 0x0B, 0x50, 0x6B, 0x81, 0x30, 0x5B, 0x0C,
  0x60, 0x5B, 0x0C, 0x50, 0x30, 0xDA, 0x05, 0x20, 0xBA, 0x0C, 0x60, 0xBB, 0x0C, 0x60, 0x5A, 0x05,
  0x20, 0x9A, 0x0C, 0x50, 0x1C, 0x0C, 0x60, 0x3A, 0x03, 0x20, 0x9A, 0x0B, 0x58, 0x18, 0xFB, 0xA0,
  0xD6, 0x04, 0xA3, 0x09, 0xA0, 0xB5, 0x81, 0xEE, 0x5A, 0x0D, 0x68, 0x17, 0xFB, 0x30, 0x9A, 0x0B,
  0x48, 0x25, 0xF9, 0x4A, 0x0D, 0x68, 0x1C, 0xF5, 0x30, 0xAA, 0x0B, 0x48, 0x2C, 0xF2, 0x4A, 0x0D,
  0x58, 0x12, 0xFE, 0x40, 0xAA, 0x0A, 0x38, 0x33, 0xFA, 0x04, 0xA0, 0xD5, 0x81, 0x8F, 0x74, 0x0A,
  0xA0, 0xA3, 0x83, 0x9F, 0x30, 0x4A, 0x0E, 0x50, 0x0E, 0x50, 0xAA, 0x0A, 0x28, 0x11, 0xFC, 0x20,
  0x4A, 0x0E, 0x48, 0x16, 0xF7, 0x50, 0xBA, 0x09, 0x28, 0x17, 0xF4, 0x20, 0x4A, 0x0E, 0x40, 0xE0,
  0xD6, 0x0B, 0xA0, 0x92, 0x0E, 0x0D, 0x30, 0x4A, 0x0E, 0x38, 0x17, 0xF5, 0x60, 0xBA, 0x83, 0x90,
  0x5F, 0x63, 0x05, 0xA0, 0xE2, 0x81, 0x1E, 0xB7, 0x0B, 0xA8, 0x28, 0x0C, 0xD4, 0x05, 0xA0, 0xE2,
  0x81, 0x9F, 0x27, 0x0C, 0xA8, 0x28, 0x4F, 0x64, 0x05, 0xA8, 0x3E, 0x03, 0xF7, 0x71, 0x0C, 0xA8,
  0x17, 0xBE, 0x50, 0x5A, 0x82, 0xE0, 0xDD, 0x72, 0x0C, 0xA8, 0x1B, 0xF7, 0x50, 0x5A, 0x82, 0xD8,
  0xF3, 0x72, 0x0C, 0xB0, 0xE6, 0x05, 0xC0, 0x97, 0x30, 0xDB, 0x07, 0x60, 0x5B, 0x0D, 0x74, 0x82,
  0xDF, 0xEB, 0x70, 0x6A, 0x0E, 0x04, 0x74, 0x02, 0x01, 0x72, 0x81, 0x13, 0x17, 0x40,
  // "Ŷ" (U+0176)
  0x75, 0x06, 0x0F, 0x77, 0x74, 0x05, 0xC0, 0x27, 0x72, 0x02, 0x0E, 0xC0, 0x67, 0x72, 0x85, 0xCF,
  0xE6, 0xEF, 0xC7, 0x71, 0x84, 0xAF, 0xE3, 0x06, 0xA0, 0x37, 0x68, 0x28, 0xFD, 0x23, 0x81, 0xBF,
  0xA7, 0x58, 0x25, 0xFA, 0x14, 0x01, 0x0C, 0x98, 0x0D, 0x70, 0x03, 0xFA, 0x05, 0x30, 0xAF, 0x0D,
  0x05, 0xF8, 0x1E, 0xE2, 0x30, 0xDF, 0x82, 0xA0, 0x1B, 0xC0, 0x37, 0x10, 0x4B, 0x0A, 0x01, 0x30,
  0x4B, 0x0E, 0x72, 0x02, 0xA0, 0xC6, 0x0E, 0xB0, 0x17, 0x10, 0x7A, 0x02, 0x60, 0xAB, 0x04, 0x78,
  0x21, 0xEF, 0x67, 0x06, 0xB0, 0x87, 0x81, 0xAF, 0xB7, 0x10, 0x1B, 0x0B, 0x68, 0x25, 0xFE, 0x17,
  0x20, 0xDB, 0x58, 0x21, 0xEF, 0x57, 0x30, 0x8B, 0x04, 0x48, 0x1B, 0xF9, 0x74, 0x04, 0xB0, 0x83,
  0x81, 0x6F, 0xD7, 0x6B, 0x0C, 0x28, 0x22, 0xEF, 0x37, 0x60, 0xBB, 0x28, 0x1B, 0xF7, 0x77, 0x07,
  0xB8, 0x23, 0x6F, 0xC7, 0x71, 0x02, 0xB8, 0x27, 0xEE, 0x27, 0x72, 0x0E, 0xC0, 0x67, 0x73, 0x09,
  0xB0, 0xA7, 0x74, 0x09, 0xB0, 0x37, 0x74, 0x0C, 0xB7, 0x75, 0xB0, 0xC7, 0x74, 0x03, 0xB0, 0x97,
  0x74, 0x06, 0xB0, 0x57, 0x74, 0x09, 0xB0, 0x27, 0x74, 0x0C, 0xA0, 0xE7, 0x75, 0xB0, 0xB7, 0x74,
  0x06, 0xB0, 0x97, 0x73, 0x05, 0x0E, 0xB0, 0xD0, 0x37, 0x60, 0x40, 0xEF, 0xA0, 0xB7, 0x40, 0x7F,
  0xB0, 0x87, 0x40,
  // "ŷ" (U+0177)
  0x77, 0x20, 0x60, 0xF7, 0x77, 0x50, 0x5C, 0x02, 0x77, 0x30, 0x20, 0xEC, 0x06, 0x77, 0x38, 0x5C,
  0xFE, 0x6E, 0xFC, 0x77, 0x28, 0x4A, 0xFE, 0x30, 0x6A, 0x03, 0x77, 0x82, 0x8F, 0xD2, 0x38, 0x1B,
  0xFA, 0x76, 0x82, 0x5F, 0xA1, 0x40, 0x10, 0xC9, 0x80, 0xE5, 0x0D, 0x06, 0x78, 0x29, 0xEC, 0x26,
  0x03, 0xD0, 0x96, 0x06, 0xB0, 0xC7, 0x10, 0x7B, 0x0C, 0x60, 0x7C, 0x72, 0x0D, 0xB7, 0x05, 0xB7,
  0x20, 0x8B, 0x03, 0x7B, 0x72, 0x05, 0xB0, 0x67, 0xA0, 0xD7, 0x20, 0x2B, 0x09, 0x60, 0x1A, 0x0A,
  0x73, 0x0E, 0xA0, 0xC6, 0x04, 0xA0, 0x57, 0x30, 0xBB, 0x60, 0x7A, 0x01, 0x73, 0x07, 0xB0, 0x35,
  0x81, 0xCF, 0xB7, 0x40, 0x4B, 0x06, 0x40, 0x2A, 0x04, 0x74, 0x01, 0xB0, 0x94, 0x81, 0x7F, 0xD7,
  0x60, 0xDA, 0x0C, 0x48, 0x1D, 0xF6, 0x76, 0x0A, 0xB3, 0x81, 0x5F, 0xE7, 0x70, 0x6B, 0x02, 0x28,
  0x1C, 0xF6, 0x77, 0x03, 0xB8, 0x35, 0x05, 0xFD, 0x77, 0x2B, 0x83, 0x70, 0xCF, 0x67, 0x72, 0x0C,
  0xA8, 0x2A, 0x5F, 0xD7, 0x73, 0x09, 0xA8, 0x2C, 0xDF, 0x47, 0x73, 0x05, 0xC0, 0xB7, 0x74, 0x02,
  0xC0, 0x27, 0x75, 0x0E, 0xA0, 0x87, 0x76, 0x81, 0xCF, 0xD7, 0x76, 0x04, 0xA0, 0x47, 0x75, 0x82,
  0x1E, 0xFA, 0x77, 0x68, 0x2C, 0xFE, 0x17, 0x75, 0x0B, 0xA0, 0x47, 0x75, 0x0A, 0xA0, 0x77, 0x74,
  0x02, 0x0C, 0xA0, 0x97, 0x50, 0x10, 0x23, 0x03, 0x09, 0xB0, 0x87, 0x60, 0x7F, 0x0D, 0x04, 0x77,
  0x86, 0x6C, 0xEF, 0xEC, 0x95, 0x77, 0x20,
  // "Ÿ" (U+0178)
  0x71, 0x81, 0x8E, 0xB3, 0x82, 0x1C, 0xE6, 0x75, 0x03, 0xB0, 0x22, 0x08, 0xA0, 0xC7, 0x50, 0x4B,
  0x01, 0x20, 0xAA, 0x0B, 0x75, 0x82, 0x1C, 0xE7, 0x38, 0x24, 0xED, 0x38, 0x09, 0xB5, 0x00, 0x3F,
  0xA0, 0x53, 0x0A, 0xF0, 0xD0, 0x5F, 0x81, 0xEE, 0x23, 0x0D, 0xF8, 0x2A, 0x01, 0xBC, 0x03, 0x71,
  0x04, 0xB0, 0xA0, 0x13, 0x04, 0xB0, 0xE7, 0x20, 0x2A, 0x0C, 0x60, 0xEB, 0x01, 0x71, 0x07, 0xA0,
  0x26, 0x0A, 0xB0, 0x47, 0x82, 0x1E, 0xF6, 0x70, 0x6B, 0x08, 0x78, 0x1A, 0xFB, 0x71, 0x01, 0xB0,
  0xB6, 0x82, 0x5F, 0xE1, 0x72, 0x0D, 0xB5, 0x82, 0x1E, 0xF5, 0x73, 0x08, 0xB0, 0x44, 0x81, 0xBF,
  0x97, 0x40, 0x4B, 0x08, 0x38, 0x16, 0xFD, 0x76, 0xB0, 0xC2, 0x82, 0x2E, 0xF3, 0x76, 0x0B, 0xB2,
  0x81, 0xBF, 0x77, 0x70, 0x7B, 0x82, 0x36, 0xFC, 0x77, 0x10, 0x2B, 0x82, 0x7E, 0xE2, 0x77, 0x20,
  0xEC, 0x06, 0x77, 0x30, 0x9B, 0x0A, 0x77, 0x40, 0x9B, 0x03, 0x77, 0x40, 0xCB, 0x77, 0x5B, 0x0C,
  0x77, 0x40, 0x3B, 0x09, 0x77, 0x40, 0x6B, 0x05, 0x77, 0x40, 0x9B, 0x02, 0x77, 0x40, 0xCA, 0x0E,
  0x77, 0x5B, 0x0B, 0x77, 0x40, 0x6B, 0x09, 0x77, 0x30, 0x50, 0xEB, 0x0D, 0x03, 0x76, 0x04, 0x0E,
  0xFA, 0x0B, 0x74, 0x07, 0xFB, 0x08, 0x74,
  // "Ź" (U+0179)
  0x77, 0x38, 0x34, 0x77, 0x73, 0x77, 0x40, 0x10, 0xEA, 0x0D, 0x01, 0x77, 0x40, 0xAA, 0x0E, 0x02,
  0x77, 0x40, 0x4A, 0x0E, 0x02, 0x77, 0x48, 0x31, 0xDF, 0xE2, 0x77, 0x58, 0x2A, 0xFD, 0x27, 0x75,
  0x82, 0x5F, 0xA1, 0x80, 0xF1, 0x00, 0x6F, 0xFA, 0x0E, 0x60, 0xAC, 0x80, 0x4E, 0xC0, 0xB6, 0x82,
  0xEF, 0xE5, 0x71, 0x07, 0xB0, 0xE0, 0x25, 0x02, 0xA0, 0x47, 0x10, 0x3C, 0x05, 0x68, 0x16, 0xFB,
  0x72, 0x0D, 0xB0, 0xA7, 0x81, 0xAF, 0x57, 0x10, 0x9B, 0x0D, 0x01, 0x70, 0xD0, 0xE7, 0x10, 0x5C,
  0x04, 0x77, 0x30, 0x10, 0xEB, 0x08, 0x77, 0x40, 0xBB, 0x0C, 0x77, 0x40, 0x7B, 0x0E, 0x02, 0x77,
  0x30, 0x3C, 0x06, 0x77, 0x40, 0xDB, 0x0A, 0x77, 0x40, 0x9B, 0x0E, 0x01, 0x77, 0x30, 0x4C, 0x04,
  0x77, 0x30, 0x10, 0xEB, 0x08, 0x77, 0x40, 0xAB, 0x0C, 0x77, 0x40, 0x6C, 0x02, 0x77, 0x30, 0x20,
  0xEB, 0x06, 0x77, 0x40, 0xCB, 0x0B, 0x77, 0x40, 0x8B, 0x0E, 0x01, 0x77, 0x30, 0x3C, 0x04, 0x77,
  0x30, 0x10, 0xDB, 0x09, 0x77, 0x40, 0xAB, 0x0D, 0x72, 0x81, 0x5F, 0x76, 0x05, 0xC0, 0x27, 0x28,
  0x1A, 0xF4, 0x50, 0x10, 0xEB, 0x07, 0x72, 0x01, 0xA6, 0x0B, 0xB0, 0xB7, 0x38, 0x18, 0xFC, 0x50,
  0x7B, 0x0E, 0x01, 0x71, 0x01, 0x07, 0xA0, 0x84, 0x01, 0xD8, 0x04, 0xED, 0x04, 0x40, 0x5F, 0xFC,
  0x01, 0x40,
  // "ź" (U+017A)
  0x76, 0x83, 0x47, 0x77, 0x37, 0x50, 0x10, 0xEA, 0x0D, 0x01, 0x75, 0x0A, 0xA0, 0xE0, 0x27, 0x50,
  0x4A, 0x0E, 0x02, 0x75, 0x83, 0x1D, 0xFE, 0x27, 0x68, 0x2A, 0xFD, 0x27, 0x68, 0x25, 0xFA, 0x18,
  0x0D, 0x10, 0x04, 0xFD, 0x02, 0x40, 0x8B, 0x80, 0x0E, 0xC0, 0xE5, 0x82, 0xCF, 0xA1, 0x40, 0xBB,
  0x05, 0x48, 0x11, 0xFD, 0x50, 0x6B, 0x0B, 0x58, 0x15, 0xF5, 0x40, 0x10, 0xEA, 0x0E, 0x01, 0x50,
  0x50, 0x95, 0x0B, 0xB0, 0x57, 0x50, 0x6B, 0x0A, 0x75, 0x01, 0x0E, 0xA0, 0xE0, 0x17, 0x50, 0xBB,
  0x05, 0x75, 0x06, 0xB0, 0xA7, 0x50, 0x10, 0xEA, 0x0E, 0x01, 0x75, 0x0B, 0xB0, 0x57, 0x50, 0x6B,
  0x0A, 0x75, 0x02, 0x0E, 0xA0, 0xE0, 0x17, 0x50, 0xBB, 0x05, 0x75, 0x06, 0xB0, 0xA6, 0x06, 0x04,
  0x40, 0x20, 0xEA, 0x0E, 0x01, 0x58, 0x14, 0xF6, 0x40, 0xBB, 0x04, 0x68, 0x1A, 0xF2, 0x30, 0x6B,
  0x09, 0x68, 0x12, 0xFE, 0x30, 0x20, 0xEA, 0x0D, 0x01, 0x58, 0x22, 0xCF, 0xA3, 0x0A, 0xC8, 0x02,
  0xEB, 0x06, 0x30, 0xEF, 0xE0, 0x33,
  // "Ż" (U+017B)
  0x77, 0x82, 0x9E, 0xC1, 0x77, 0x50, 0x6B, 0x08, 0x77, 0x50, 0x9B, 0x09, 0x77, 0x50, 0x9B, 0x06,
  0x77, 0x58, 0x22, 0xCE, 0x98, 0x09, 0xD1, 0x00, 0x6F, 0xFA, 0x0E, 0x60, 0xAC, 0x80, 0x4E, 0xC0,
  0xB6, 0x82, 0xEF, 0xE5, 0x71, 0x07, 0xB0, 0xE0, 0x25, 0x02, 0xA0, 0x47, 0x10, 0x3C, 0x05, 0x68,
  0x16, 0xFB, 0x72, 0x0D, 0xB0, 0xA7, 0x81, 0xAF, 0x57, 0x10, 0x9B, 0x0D, 0x01, 0x70, 0xD0, 0xE7,
  0x10, 0x5C, 0x04, 0x77, 0x30, 0x10, 0xEB, 0x08, 0x77, 0x40, 0xBB, 0x0C, 0x77, 0x40, 0x7B, 0x0E,
  0x02, 0x77, 0x30, 0x3C, 0x06, 0x77, 0x40, 0xDB, 0x0A, 0x77, 0x40, 0x9B, 0x0E, 0x01, 0x77, 0x30,
  0x4C, 0x04, 0x77, 0x30, 0x10, 0xEB, 0x08, 0x77, 0x40, 0xAB, 0x0C, 0x77, 0x40, 0x6C, 0x02, 0x77,
  0x30, 0x20, 0xEB, 0x06, 0x77, 0x40, 0xCB, 0x0B, 0x77, 0x40, 0x8B, 0x0E, 0x01, 0x77, 0x30, 0x3C,
  0x04, 0x77, 0x30, 0x10, 0xDB, 0x09, 0x77, 0x40, 0xAB, 0x0D, 0x72, 0x81, 0x5F, 0x76, 0x05, 0xC0,
  0x27, 0x28, 0x1A, 0xF4, 0x50, 0x10, 0xEB, 0x07, 0x72, 0x01, 0xA6, 0x0B, 0xB0, 0xB7, 0x38, 0x18,
  0xFC, 0x50, 0x7B, 0x0E, 0x01, 0x71, 0x01, 0x07, 0xA0, 0x84, 0x01, 0xD8, 0x04, 0xED, 0x04, 0x40,
  0x5F, 0xFC, 0x01, 0x40,
  // "ż" (U+017C)
  0x73, 0x82, 0x9E, 0xC1, 0x76, 0x06, 0xB0, 0x87, 0x60, 0x9B, 0x09, 0x76, 0x09, 0xB0, 0x67, 0x68,
  0x22, 0xCE, 0x98, 0x09, 0x95, 0x00, 0x4F, 0xD0, 0x24, 0x08, 0xB8, 0x00, 0xEC, 0x0E, 0x58, 0x2C,
  0xFA, 0x14, 0x0B, 0xB0, 0x54, 0x81, 0x1F, 0xD5, 0x06, 0xB0, 0xB5, 0x81, 0x5F, 0x54, 0x01, 0x0E,
  0xA0, 0xE0, 0x15, 0x05, 0x09, 0x50, 0xBB, 0x05, 0x75, 0x06, 0xB0, 0xA7, 0x50, 0x10, 0xEA, 0x0E,
  0x01, 0x75, 0x0B, 0xB0, 0x57, 0x50, 0x6B, 0x0A, 0x75, 0x01, 0x0E, 0xA0, 0xE0, 0x17, 0x50, 0xBB,
  0x05, 0x75, 0x06, 0xB0, 0xA7, 0x50, 0x20, 0xEA, 0x0E, 0x01, 0x75, 0x0B, 0xB0, 0x57, 0x50, 0x6B,
  0x0A, 0x60, 0x60, 0x44, 0x02, 0x0E, 0xA0, 0xE0, 0x15, 0x81, 0x4F, 0x64, 0x0B, 0xB0, 0x46, 0x81,
  0xAF, 0x23, 0x06, 0xB0, 0x96, 0x81, 0x2F, 0xE3, 0x02, 0x0E, 0xA0, 0xD0, 0x15, 0x82, 0x2C, 0xFA,
  0x30, 0xAC, 0x80, 0x2E, 0xB0, 0x63, 0x0E, 0xFE, 0x03, 0x30,
  // "Ž" (U+017D)
  0x74, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x58, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x78, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x77, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x72, 0x82, 0xCF, 0xED,
  0xA0, 0x47, 0x73, 0x07, 0xC0, 0x77, 0x74, 0x03, 0xB0, 0xC8, 0x0F, 0x00, 0x06, 0xFF, 0xA0, 0xE6,
  0x0A, 0xC8, 0x04, 0xEC, 0x0B, 0x68, 0x2E, 0xFE, 0x57, 0x10, 0x7B, 0x0E, 0x02, 0x50, 0x2A, 0x04,
  0x71, 0x03, 0xC0, 0x56, 0x81, 0x6F, 0xB7, 0x20, 0xDB, 0x0A, 0x78, 0x1A, 0xF5, 0x71, 0x09, 0xB0,
  0xD0, 0x17, 0x0D, 0x0E, 0x71, 0x05, 0xC0, 0x47, 0x73, 0x01, 0x0E, 0xB0, 0x87, 0x74, 0x0B, 0xB0,
  0xC7, 0x74, 0x07, 0xB0, 0xE0, 0x27, 0x73, 0x03, 0xC0, 0x67, 0x74, 0x0D, 0xB0, 0xA7, 0x74, 0x09,
  0xB0, 0xE0, 0x17, 0x73, 0x04, 0xC0, 0x47, 0x73, 0x01, 0x0E, 0xB0, 0x87, 0x74, 0x0A, 0xB0, 0xC7,
  0x74, 0x06, 0xC0, 0x27, 0x73, 0x02, 0x0E, 0xB0, 0x67, 0x74, 0x0C, 0xB0, 0xB7, 0x74, 0x08, 0xB0,
  0xE0, 0x17, 0x73, 0x03, 0xC0, 0x47, 0x73, 0x01, 0x0D, 0xB0, 0x97, 0x74, 0x0A, 0xB0, 0xD7, 0x28,
  0x15, 0xF7, 0x60, 0x5C, 0x02, 0x72, 0x81, 0xAF, 0x45, 0x01, 0x0E, 0xB0, 0x77, 0x20, 0x1A, 0x60,
  0xBB, 0x0B, 0x73, 0x81, 0x8F, 0xC5, 0x07, 0xB0, 0xE0, 0x17, 0x10, 0x10, 0x7A, 0x08, 0x40, 0x1D,
  0x80, 0x4E, 0xD0, 0x44, 0x05, 0xFF, 0xC0, 0x14,
  // "ž" (U+017E)
  0x71, 0x81, 0x17, 0x36, 0x81, 0x57, 0x27, 0x18, 0x21, 0xFE, 0x24, 0x81, 0x9F, 0xB7, 0x38, 0x19,
  0xFC, 0x28, 0x31, 0xCF, 0xD1, 0x73, 0x03, 0xA8, 0x46, 0x1D, 0xFE, 0x27, 0x58, 0x2C, 0xFE, 0xDA,
  0x04, 0x76, 0x07, 0xC0, 0x77, 0x70, 0x3B, 0x0C, 0x80, 0xD5, 0x00, 0x4F, 0xD0, 0x26, 0x08, 0xB8,
  0x00, 0xEC, 0x0E, 0x78, 0x2C, 0xFA, 0x14, 0x0B, 0xB0, 0x56, 0x81, 0x1F, 0xD5, 0x06, 0xB0, 0xB7,
  0x81, 0x5F, 0x54, 0x01, 0x0E, 0xA0, 0xE0, 0x17, 0x05, 0x09, 0x50, 0xBB, 0x05, 0x77, 0x06, 0xB0,
  0xA7, 0x70, 0x10, 0xEA, 0x0E, 0x01, 0x77, 0x0B, 0xB0, 0x57, 0x70, 0x6B, 0x0A, 0x77, 0x01, 0x0E,
  0xA0, 0xE0, 0x17, 0x70, 0xBB, 0x05, 0x77, 0x06, 0xB0, 0xA7, 0x70, 0x20, 0xEA, 0x0E, 0x01, 0x77,
  0x0B, 0xB0, 0x57, 0x70, 0x6B, 0x0A, 0x60, 0x60, 0x46, 0x02, 0x0E, 0xA0, 0xE0, 0x15, 0x81, 0x4F,
  0x66, 0x0B, 0xB0, 0x46, 0x81, 0xAF, 0x25, 0x06, 0xB0, 0x96, 0x81, 0x2F, 0xE5, 0x02, 0x0E, 0xA0,
  0xD0, 0x15, 0x82, 0x2C, 0xFA, 0x50, 0xAC, 0x80, 0x2E, 0xB0, 0x65, 0x0E, 0xFE, 0x03, 0x50,
  // "ſ" (U+017F)
  0x77, 0x18, 0x54, 0xAE, 0xFE, 0xB5, 0x77, 0x10, 0x9F, 0x07, 0x76, 0x07, 0xA8, 0x2D, 0x20, 0x9A,
  0x0E, 0x75, 0x02, 0xB0, 0x32, 0x03, 0xA0, 0xE7, 0x50, 0x9A, 0x0C, 0x30, 0x1A, 0x09, 0x75, 0x0E,
  0xA0, 0x83, 0x81, 0x1A, 0x67, 0x50, 0x4B, 0x04, 0x77, 0x40, 0x8B, 0x77, 0x50, 0xBA, 0x0D, 0x77,
  0x50, 0xEA, 0x09, 0x77, 0x40, 0x2B, 0x06, 0x77, 0x40, 0x5B, 0x03, 0x77, 0x40, 0x8B, 0x77, 0x50,
  0xCA, 0x0C, 0x77, 0x5B, 0x09, 0x77, 0x40, 0x3B, 0x05, 0x77, 0x40, 0x6B, 0x02, 0x77, 0x40, 0x9A,
  0x0E, 0x77, 0x50, 0xCA, 0x0B, 0x77, 0x5B, 0x08, 0x77, 0x40, 0x3B, 0x05, 0x77, 0x40, 0x7B, 0x01,
  0x77, 0x40, 0xAA, 0x0E, 0x77, 0x50, 0xDA, 0x0A, 0x77, 0x40, 0x1B, 0x07, 0x77, 0x40, 0x4B, 0x04,
  0x77, 0x40, 0x7B, 0x01, 0x77, 0x40, 0xBA, 0x0D, 0x77, 0x50, 0xEA, 0x0A, 0x77, 0x40, 0x2B, 0x07,
  0x77, 0x40, 0x5B, 0x03, 0x77, 0x40, 0x8B, 0x77, 0x50, 0xCA, 0x0B, 0x77, 0x5B, 0x07, 0x77, 0x40,
  0x4B, 0x02, 0x77, 0x40, 0x9A, 0x0C, 0x77, 0x40, 0x10, 0xEA, 0x05, 0x77, 0x40, 0x8A, 0x0D, 0x77,
  0x10, 0x12, 0x07, 0xB0, 0x37, 0x71, 0x0D, 0xC0, 0xE0, 0x47, 0x72, 0x84, 0xCE, 0xEC, 0x81, 0x77,
  0x30,
  // "Ω" (U+03A9)
  0x75, 0x89, 0x02, 0x6A, 0xCE, 0xFE, 0xDA, 0x57, 0x71, 0x03, 0x0B, 0xFB, 0x0D, 0x04, 0x75, 0x08,
  0xB8, 0x1C, 0x51, 0x28, 0x11, 0x6D, 0xB0, 0x67, 0x30, 0xBB, 0x07, 0x70, 0x10, 0xCB, 0x04, 0x71,
  0x0A, 0xB0, 0x67, 0x20, 0x3B, 0x0C, 0x70, 0x5B, 0x0A, 0x74, 0x0C, 0xB0, 0x35, 0x01, 0x0E, 0xB0,
  0x17, 0x40, 0x7B, 0x07, 0x50, 0x7B, 0x09, 0x75, 0x05, 0xB0, 0xA5, 0x0D, 0xB0, 0x37, 0x50, 0x5B,
  0x0B, 0x40, 0x2B, 0x0E, 0x76, 0x05, 0xB0, 0xB4, 0x06, 0xB0, 0xB7, 0x60, 0x7B, 0x0A, 0x40, 0x9B,
  0x08, 0x76, 0x09, 0xB0, 0x84, 0x0B, 0xB0, 0x67, 0x60, 0xCB, 0x05, 0x40, 0xCB, 0x05, 0x75, 0x01,
  0xC0, 0x14, 0x0B, 0xB0, 0x57, 0x50, 0x6B, 0x0C, 0x50, 0xAB, 0x06, 0x75, 0x0C, 0xB0, 0x65, 0x07,
  0xB0, 0x87, 0x40, 0x5B, 0x0D, 0x60, 0x2B, 0x0C, 0x73, 0x01, 0x0E, 0xB0, 0x47, 0x0B, 0xB0, 0x27,
  0x10, 0x10, 0xCB, 0x07, 0x71, 0x03, 0xB0, 0xB7, 0x03, 0x0C, 0xB0, 0x77, 0x30, 0x5B, 0x0C, 0x05,
  0x28, 0x11, 0x7B, 0xB0, 0xD0, 0x47, 0x50, 0x30, 0xDB, 0x81, 0x10, 0x6B, 0x0C, 0x06, 0x71, 0x81,
  0x6D, 0x45, 0x81, 0x4F, 0xE2, 0x82, 0xAF, 0x82, 0x50, 0xC0, 0xA3, 0x81, 0x8F, 0x65, 0x81, 0x1F,
  0xB2, 0x81, 0xDF, 0x15, 0x81, 0x6F, 0x83, 0x81, 0xAF, 0x75, 0x85, 0x4F, 0x70, 0x1F, 0xD5, 0x82,
  0x1E, 0xF4, 0x38, 0x2C, 0xFD, 0x34, 0x85, 0x7F, 0x40, 0x5F, 0x93, 0x81, 0x14, 0xCA, 0x40, 0xDF,
  0xA8, 0x11, 0x09, 0xFA, 0x0C, 0x4F, 0xA0, 0xE2, 0x0C, 0xFA, 0x08, 0x30, 0x1F, 0xA0, 0xB2, 0xFB,
  0x04, 0x30,
  // "μ" (U+03BC)
  0x60, 0x2B, 0x07, 0x60, 0x9B, 0x60, 0x5B, 0x03, 0x60, 0xCA, 0x0C, 0x60, 0x8B, 0x7B, 0x09, 0x60,
  0xBA, 0x0D, 0x60, 0x2B, 0x06, 0x60, 0xEA, 0x0A, 0x60, 0x6B, 0x02, 0x50, 0x2B, 0x06, 0x60, 0x9A,
  0x0E, 0x60, 0x6B, 0x03, 0x60, 0xCA, 0x0C, 0x60, 0x9B, 0x7B, 0x08, 0x60, 0xCA, 0x0C, 0x60, 0x2B,
  0x05, 0x6B, 0x09, 0x60, 0x6B, 0x02, 0x50, 0x3B, 0x06, 0x60, 0x9A, 0x0E, 0x60, 0x6B, 0x03, 0x60,
  0xCA, 0x0B, 0x60, 0x9B, 0x7B, 0x08, 0x60, 0xCA, 0x0C, 0x60, 0x3B, 0x04, 0x6B, 0x09, 0x60, 0x7B,
  0x01, 0x50, 0x3B, 0x07, 0x60, 0xCA, 0x0E, 0x60, 0x7B, 0x06, 0x50, 0x3B, 0x0B, 0x60, 0xAB, 0x07,
  0x50, 0xBB, 0x08, 0x60, 0xEB, 0x0A, 0x40, 0x70, 0xEB, 0x07, 0x50, 0x3D, 0x85, 0x50, 0x18, 0xF3,
  0xDA, 0x82, 0xA0, 0x34, 0x28, 0x27, 0xFB, 0xBD, 0x82, 0xE4, 0x0A, 0xD0, 0xC2, 0x89, 0x0B, 0xF7,
  0x08, 0xDF, 0xD9, 0x22, 0x84, 0x1B, 0xEE, 0xB6, 0x3A, 0x04, 0x77, 0x30, 0x4A, 0x02, 0x77, 0x30,
  0x8A, 0x77, 0x40, 0xBA, 0x77, 0x48, 0x1E, 0xFE, 0x77, 0x30, 0x2B, 0x02, 0x77, 0x20, 0x3B, 0x0C,
  0x02, 0x77, 0x10, 0x3C, 0x0A, 0x77, 0x10, 0x2B, 0x0E, 0x02, 0x77, 0x28, 0x28, 0xEB, 0x27, 0x72,
  // "π" (U+03C0)
  0x48, 0x23, 0xAD, 0xEF, 0xF0, 0xE3, 0x04, 0xFF, 0xC0, 0xB3, 0x0E, 0xFF, 0xC0, 0x62, 0x86, 0x5F,
  0xD4, 0x01, 0xFE, 0x68, 0x19, 0xF6, 0x68, 0x19, 0xF2, 0x28, 0x15, 0xFB, 0x68, 0x1E, 0xF2, 0x60,
  0x70, 0x63, 0x81, 0xAF, 0x75, 0x81, 0x4F, 0xD7, 0x58, 0x1E, 0xF3, 0x58, 0x19, 0xF9, 0x74, 0x81,
  0x4F, 0xE6, 0x81, 0xDF, 0x67, 0x48, 0x19, 0xFB, 0x50, 0x2A, 0x02, 0x74, 0x81, 0xDF, 0x75, 0x81,
  0x6F, 0xE7, 0x40, 0x2A, 0x04, 0x58, 0x1B, 0xFB, 0x74, 0x07, 0xA6, 0x81, 0xEF, 0x87, 0x48, 0x1C,
  0xFC, 0x50, 0x3A, 0x05, 0x73, 0x01, 0xA0, 0x85, 0x07, 0xA0, 0x27, 0x30, 0x6A, 0x04, 0x50, 0xAA,
  0x74, 0x0B, 0xA6, 0x81, 0xDF, 0xD7, 0x30, 0x2A, 0x0B, 0x6A, 0x0B, 0x73, 0x0A, 0xA0, 0x75, 0x02,
  0xA0, 0xA7, 0x20, 0x5B, 0x01, 0x50, 0x3A, 0x0C, 0x70, 0x50, 0xAB, 0x0A, 0x60, 0x2B, 0x82, 0x97,
  0xC1, 0x3C, 0x0E, 0x02, 0x70, 0xDC, 0x0D, 0x02, 0x38, 0x39, 0xEE, 0xA2, 0x71, 0x83, 0x3C, 0xFD,
  0x75,
  // "–" (U+2013)
  0x01, 0x80, 0xA0, 0xE0, 0x50, 0x4F, 0xFE, 0x01,
  // "—" (U+2014)
  0x01, 0x80, 0xC4, 0xE0, 0x50, 0x48, 0x0C, 0x4F, 0x01,
  // "€" (U+20AC)
  0x74, 0x86, 0x28, 0xCE, 0xFE, 0xB5, 0x75, 0x09, 0xF9, 0x0A, 0x72, 0x83, 0x1C, 0xFE, 0x62, 0x04,
  0x0E, 0xB0, 0x47, 0x83, 0x1D, 0xFE, 0x34, 0x06, 0xB0, 0x67, 0x0B, 0xA0, 0x55, 0x01, 0xB0, 0x36,
  0x07, 0xA0, 0xB7, 0x81, 0xEF, 0x86, 0x01, 0xB0, 0x37, 0x02, 0x71, 0x09, 0xA0, 0xC7, 0x72, 0x01,
  0xB0, 0x67, 0x72, 0x07, 0xB0, 0x17, 0x72, 0x0D, 0xA0, 0xB7, 0x78, 0x17, 0xEE, 0xC8, 0x02, 0xE0,
  0xB7, 0x0B, 0xFD, 0x08, 0x72, 0x08, 0xB0, 0x17, 0x72, 0x0B, 0xA0, 0xE7, 0x73, 0x0E, 0xA0, 0xC7,
  0x70, 0x7F, 0xC0, 0x57, 0x18, 0x1A, 0xEE, 0xC8, 0x01, 0xE0, 0x27, 0x30, 0x3B, 0x07, 0x77, 0x20,
  0x3B, 0x06, 0x77, 0x20, 0x4B, 0x05, 0x77, 0x20, 0x3B, 0x06, 0x77, 0x20, 0x2B, 0x07, 0x77, 0x3B,
  0x0A, 0x77, 0x30, 0xBA, 0x0E, 0x71, 0x01, 0x71, 0x05, 0xB0, 0x76, 0x00, 0x97, 0x20, 0xBB, 0x86,
  0x71, 0x01, 0x5C, 0xF4, 0x73, 0x0B, 0xF0, 0xE0, 0x57, 0x58, 0x64, 0xAD, 0xFE, 0xC8, 0x17,
  // "₿" (U+20BF)
  0x76, 0x84, 0xAF, 0x10, 0xCE, 0x77, 0x20, 0x0D, 0x29, 0x0B, 0x77, 0x18, 0x52, 0xF9, 0x04, 0xF7,
  0x72, 0x07, 0xF9, 0x82, 0xED, 0xF4, 0x72, 0x09, 0xE0, 0xEC, 0x0D, 0x04, 0x73, 0x09, 0xB8, 0x2C,
  0x01, 0x6B, 0x0E, 0x03, 0x72, 0x03, 0xB0, 0x93, 0x07, 0xB0, 0xB7, 0x20, 0x6B, 0x06, 0x30, 0x1C,
  0x72, 0x09, 0xB0, 0x24, 0x0E, 0xB0, 0x27, 0x10, 0xCA, 0x0E, 0x50, 0xDB, 0x03, 0x71, 0xB0, 0xC5,
  0x0E, 0xB0, 0x27, 0x03, 0xB0, 0x84, 0x01, 0xB0, 0xE7, 0x10, 0x6B, 0x05, 0x40, 0x4B, 0x0B, 0x71,
  0x0A, 0xB0, 0x24, 0x0B, 0xB0, 0x47, 0x10, 0xDA, 0x0E, 0x40, 0x5B, 0x09, 0x71, 0x01, 0xB0, 0xB2,
  0x03, 0x09, 0xB0, 0x97, 0x20, 0x4F, 0xA0, 0xB0, 0x47, 0x30, 0x7B, 0x00, 0xEC, 0x0D, 0x05, 0x73,
  0x0A, 0xB0, 0x12, 0x05, 0x0E, 0xB0, 0x47, 0x20, 0xEA, 0x0E, 0x40, 0x4B, 0x0C, 0x71, 0x01, 0xB0,
  0xA5, 0x0D, 0xB0, 0x27, 0x05, 0xB0, 0x75, 0x0A, 0xB0, 0x47, 0x08, 0xB0, 0x45, 0x0A, 0xB0, 0x67,
  0x0B, 0xB0, 0x15, 0x0A, 0xB0, 0x57, 0x0E, 0xA0, 0xD6, 0x0C, 0xB0, 0x46, 0x02, 0xB0, 0xA6, 0x0E,
  0xB0, 0x16, 0x05, 0xB0, 0x65, 0x04, 0xB0, 0xD7, 0x09, 0xB0, 0x35, 0x0B, 0xB0, 0x67, 0x0E, 0xB5,
  0x06, 0xB0, 0xC6, 0x02, 0x0A, 0xB0, 0xC3, 0x03, 0x09, 0xB0, 0xD0, 0x14, 0x01, 0xF0, 0x0E, 0xD0,
  0x90, 0x15, 0x04, 0xFC, 0x81, 0xB6, 0x17, 0x68, 0x56, 0xF5, 0x09, 0xF2, 0x77, 0x18, 0x4A, 0xF1,
  0x0C, 0xE7, 0x72, 0x00, 0xD2, 0x90, 0xB7, 0x72, 0x84, 0x75, 0x01, 0x74, 0x73,
  // "‘" (U+2018)
  0x48, 0x12, 0x89, 0x30, 0x9A, 0x08, 0x28, 0x2B, 0xF9, 0x12, 0x81, 0x8F, 0x83, 0x01, 0xA0, 0x13,
  0x07, 0xA0, 0x13, 0x0B, 0xA0, 0xC0, 0x12, 0x0C, 0xB0, 0xB2, 0x0B, 0xC2, 0x07, 0xB0, 0xD3, 0x82,
  0x9E, 0xD3, 0x20,
  // "’" (U+2019)
  0x28, 0x31, 0xBE, 0xA1, 0x20, 0x9B, 0x0A, 0x20, 0xBB, 0x0E, 0x20, 0x6C, 0x30, 0x5A, 0x0D, 0x48,
  0x1C, 0xF9, 0x48, 0x1E, 0xF2, 0x38, 0x19, 0xF8, 0x28, 0x26, 0xCF, 0x92, 0x82, 0x5F, 0xC4, 0x30,
  0x02, 0x50,
  // "‚" (U+201A)
  0x38, 0x29, 0xEC, 0x33, 0x05, 0xB0, 0xE0, 0x12, 0x07, 0xC0, 0x42, 0x03, 0xC0, 0x53, 0x05, 0xB0,
  0x44, 0x08, 0xA0, 0x14, 0x81, 0x8F, 0xA4, 0x82, 0x1E, 0xE2, 0x38, 0x24, 0xDF, 0x52, 0x83, 0x1D,
  0xFD, 0x43, 0x81, 0x3B, 0x65,
  // "‛" (U+201B)
  0x01, 0xAE, 0xD2, 0x0D, 0xFF, 0xF8, 0x7F, 0xFF, 0xF7, 0xBF, 0xFF, 0xE2, 0xEF, 0xFC, 0x20, 0xEF,
  0x90, 0x00, 0xDF, 0x30, 0x00, 0x9F, 0x60, 0x00, 0x2F, 0xD2, 0x00, 0x06, 0xFE, 0x60, 0x00, 0x5E,
  0x90, 0x00, 0x00, 0x10,
  // "“" (U+201C)
  0x48, 0x12, 0x89, 0x48, 0x12, 0x89, 0x30, 0x9A, 0x08, 0x30, 0x9A, 0x07, 0x28, 0x2B, 0xF9, 0x13,
  0x82, 0xCF, 0x81, 0x28, 0x18, 0xF8, 0x48, 0x19, 0xF7, 0x30, 0x1A, 0x01, 0x30, 0x2A, 0x40, 0x7A,
  0x01, 0x30, 0x8A, 0x40, 0xBA, 0x0C, 0x01, 0x20, 0xCA, 0x0B, 0x30, 0xCB, 0x0B, 0x20, 0xDB, 0x0A,
  0x20, 0xBC, 0x20, 0xCC, 0x20, 0x7B, 0x0D, 0x20, 0x8B, 0x0C, 0x38, 0x29, 0xED, 0x33, 0x82, 0x9E,
  0xC3, 0x20,
  // "”" (U+201D)
  0x28, 0x31, 0xBE, 0xA1, 0x28, 0x32, 0xCE, 0xA1, 0x20, 0xAB, 0x0A, 0x20, 0xBB, 0x09, 0x20, 0xCC,
  0x20, 0xDB, 0x0E, 0x20, 0x8C, 0x20, 0x9C, 0x30, 0xAA, 0x0E, 0x30, 0xAA, 0x0D, 0x48, 0x1D, 0xFB,
  0x48, 0x1E, 0xF9, 0x48, 0x1E, 0xF5, 0x48, 0x1E, 0xF3, 0x38, 0x15, 0xFB, 0x48, 0x16, 0xFA, 0x28,
  0x31, 0x7F, 0xD1, 0x28, 0x51, 0x8F, 0xD1, 0x05, 0xA0, 0xB0, 0x12, 0x05, 0xA0, 0xA0, 0x12, 0x81,
  0x79, 0x34, 0x81, 0x89, 0x34,
  // "„" (U+201E)
  0x38, 0x29, 0xEC, 0x43, 0x82, 0x9E, 0xC3, 0x30, 0x5B, 0x82, 0xE1, 0x06, 0xB0, 0xD3, 0x07, 0xC8,
  0x15, 0x08, 0xC0, 0x32, 0x03, 0xC8, 0x16, 0x04, 0xC0, 0x43, 0x05, 0xB0, 0x42, 0x06, 0xB0, 0x24,
  0x08, 0xA0, 0x13, 0x81, 0x9F, 0xE5, 0x81, 0x8F, 0xA4, 0x81, 0xAF, 0x84, 0x82, 0x1E, 0xF2, 0x38,
  0x22, 0xEE, 0x13, 0x82, 0x4D, 0xF5, 0x38, 0x25, 0xEF, 0x43, 0x82, 0xDF, 0xD4, 0x28, 0x31, 0xEF,
  0xD3, 0x38, 0x12, 0xB6, 0x48, 0x14, 0xA5, 0x50,
  // "‟" (U+201F)
  0x18, 0x31, 0xAE, 0xD2, 0x28, 0x51, 0xAE, 0xD2, 0x0D, 0xB0, 0x82, 0x0D, 0xB0, 0x80, 0x7C, 0x81,
  0x70, 0x7C, 0x07, 0x0B, 0xB8, 0x2E, 0x20, 0xBB, 0x81, 0xE2, 0xEA, 0x0C, 0x02, 0x20, 0xEA, 0x84,
  0xC2, 0x0E, 0xF9, 0x48, 0x1E, 0xF9, 0x38, 0x1D, 0xF3, 0x48, 0x1D, 0xF3, 0x38, 0x19, 0xF6, 0x48,
  0x19, 0xF6, 0x38, 0x22, 0xFD, 0x23, 0x82, 0x2F, 0xD2, 0x38, 0x26, 0xFE, 0x63, 0x82, 0x6F, 0xE6,
  0x38, 0x15, 0xE9, 0x48, 0x15, 0xE9, 0x50, 0x16, 0x01, 0x10,
  // "†" (U+2020)
  0x70, 0x5A, 0x0E, 0x73, 0x07, 0xA0, 0xA7, 0x30, 0x9A, 0x05, 0x73, 0x0A, 0xA0, 0x17, 0x38, 0x1C,
  0xFB, 0x74, 0x81, 0xDF, 0x77, 0x4A, 0x02, 0x73, 0x81, 0x1F, 0xD7, 0x48, 0x13, 0xF8, 0x58, 0x95,
  0x2E, 0xC9, 0x74, 0x6F, 0x65, 0x79, 0xCE, 0x5F, 0xD8, 0x96, 0xC9, 0xFD, 0xB8, 0x6E, 0xD6, 0x8B,
  0xEF, 0x82, 0x48, 0x15, 0xFE, 0x40, 0x01, 0x50, 0xDA, 0x73, 0x05, 0xB0, 0x17, 0x20, 0xCB, 0x02,
  0x72, 0xB0, 0xD7, 0x20, 0x1B, 0x08, 0x72, 0x02, 0xB0, 0x37, 0x20, 0x4A, 0x0D, 0x73, 0x06, 0xA0,
  0x87, 0x30, 0x8A, 0x03, 0x73, 0x81, 0xAF, 0xE7, 0x48, 0x1C, 0xF9, 0x74, 0x81, 0xEF, 0x57, 0x30,
  0x1A, 0x01, 0x73, 0x81, 0x3F, 0xC7, 0x48, 0x15, 0xF8, 0x74, 0x81, 0x8F, 0x47, 0x40, 0xB9, 0x75,
  0x0E, 0x0B, 0x74, 0x81, 0x1F, 0x77, 0x48, 0x14, 0xF4, 0x74, 0x81, 0x7F, 0x17, 0x40, 0xA0, 0xC7,
  0x40,
  // "‡" (U+2021)
  0x74, 0x06, 0xA0, 0xE7, 0x71, 0x07, 0xA0, 0x97, 0x71, 0x08, 0xA0, 0x47, 0x71, 0x81, 0x9F, 0xE7,
  0x72, 0x81, 0xAF, 0x97, 0x72, 0x81, 0xCF, 0x47, 0x72, 0x0D, 0x0E, 0x74, 0x89, 0x4A, 0xCA, 0x75,
  0x2E, 0xB3, 0x58, 0xAC, 0x65, 0x0E, 0xFD, 0x03, 0x40, 0x2A, 0x89, 0x1C, 0xA7, 0xAF, 0x88, 0xBD,
  0xFE, 0x50, 0x10, 0x24, 0x81, 0xDF, 0x43, 0x01, 0x03, 0x73, 0x06, 0xA0, 0x67, 0x71, 0x0E, 0xA0,
  0x77, 0x70, 0x6B, 0x07, 0x77, 0x01, 0xA0, 0xB7, 0x72, 0x81, 0xDF, 0x27, 0x72, 0x0C, 0x09, 0x77,
  0x30, 0xD0, 0x37, 0x72, 0x81, 0x2F, 0x17, 0x72, 0x81, 0x9F, 0x17, 0x71, 0x02, 0xA0, 0x37, 0x70,
  0x10, 0xDA, 0x0A, 0x77, 0x03, 0xB0, 0x77, 0x70, 0x2A, 0x0E, 0x77, 0x2A, 0x07, 0x73, 0x89, 0x47,
  0xA7, 0x41, 0x0F, 0xD0, 0x24, 0x79, 0x65, 0x0C, 0xC8, 0x1E, 0xFE, 0xD0, 0x55, 0xB8, 0x5E, 0xBB,
  0xFB, 0xBE, 0xB0, 0x14, 0x81, 0x15, 0x33, 0x81, 0x9F, 0x22, 0x81, 0x14, 0x67, 0x48, 0x1E, 0xF1,
  0x77, 0x10, 0x4A, 0x77, 0x28, 0x19, 0xFE, 0x77, 0x28, 0x1E, 0xFD, 0x77, 0x10, 0x4A, 0x0C, 0x77,
  0x10, 0x9A, 0x0B, 0x74,
  // "•" (U+2022)
  0x28, 0x42, 0xAE, 0xFC, 0x63, 0x03, 0x0E, 0xD0, 0x92, 0x0C, 0xF0, 0x30, 0x2F, 0x90, 0x80, 0x5F,
  0x90, 0xA0, 0x7F, 0x90, 0xB0, 0x7F, 0x90, 0xB0, 0x6F, 0x90, 0x90, 0x3F, 0x98, 0x16, 0x0E, 0xE8,
  0x2E, 0x10, 0x5E, 0x05, 0x38, 0x44, 0xBE, 0xEB, 0x42,
  // "…" (U+2026)
  0x18, 0x25, 0xDE, 0x66, 0x82, 0x6E, 0xD5, 0x68, 0x46, 0xEE, 0x50, 0x1C, 0x01, 0x40, 0x3B, 0x0E,
  0x50, 0x2C, 0x10, 0x5C, 0x02, 0x40, 0x7C, 0x50, 0x6C, 0x01, 0x04, 0xB0, 0xE5, 0x06, 0xB0, 0xC5,
  0x05, 0xB0, 0xD2, 0x82, 0x9E, 0xC3, 0x68, 0x2A, 0xEC, 0x26, 0x82, 0xAE, 0xC3, 0x10,
  // "‰" (U+2030)
  0x58, 0x42, 0x9D, 0xFD, 0x87, 0x30, 0x4A, 0x02, 0x77, 0x70, 0x40, 0xED, 0x0B, 0x72, 0x81, 0xDF,
  0x87, 0x77, 0x85, 0x3E, 0xFC, 0x20, 0xAA, 0x05, 0x78, 0x18, 0xFD, 0x77, 0x71, 0x82, 0xDF, 0xE1,
  0x20, 0x3A, 0x0A, 0x60, 0x2A, 0x04, 0x77, 0x70, 0x7A, 0x07, 0x30, 0x1A, 0x0D, 0x68, 0x1B, 0xFA,
  0x77, 0x71, 0x0D, 0xA0, 0x14, 0xB5, 0x82, 0x6F, 0xE1, 0x77, 0x70, 0x4A, 0x0A, 0x5B, 0x48, 0x21,
  0xEF, 0x77, 0x77, 0x10, 0x8A, 0x06, 0x40, 0x2A, 0x0D, 0x48, 0x1A, 0xFC, 0x77, 0x72, 0x0C, 0xA0,
  0x24, 0x04, 0xA0, 0xB3, 0x04, 0xA0, 0x37, 0x77, 0x2B, 0x50, 0x7A, 0x08, 0x38, 0x1D, 0xF9, 0x77,
  0x72, 0x01, 0xA0, 0xD5, 0x0B, 0xA0, 0x42, 0x82, 0x8F, 0xE1, 0x77, 0x72, 0x02, 0xA0, 0xB5, 0xA0,
  0xE2, 0x02, 0xA0, 0x52, 0x84, 0x19, 0xDE, 0xC7, 0x71, 0x84, 0x5B, 0xEE, 0xB3, 0x20, 0x2A, 0x0A,
  0x40, 0x5A, 0x08, 0x28, 0x1B, 0xFB, 0x20, 0x30, 0xED, 0x0A, 0x60, 0x9E, 0x81, 0x30, 0x1A, 0x0B,
  0x40, 0xCA, 0x81, 0x10, 0x6A, 0x87, 0x20, 0x3E, 0xFD, 0x31, 0xBA, 0x04, 0x40, 0x9A, 0x81, 0x81,
  0x4A, 0x0C, 0x28, 0x1E, 0xFE, 0x30, 0x6A, 0x84, 0x70, 0x1E, 0xF7, 0x20, 0xDA, 0x02, 0x20, 0x3A,
  0x09, 0x30, 0x5A, 0x09, 0x30, 0xBA, 0x81, 0x20, 0x8A, 0x81, 0x60, 0x5A, 0x0B, 0x28, 0x1A, 0xFD,
  0x20, 0x6A, 0x07, 0x30, 0x1A, 0x0C, 0x38, 0x2D, 0xFE, 0x13, 0x08, 0xA8, 0x25, 0x01, 0xDD, 0x0B,
  0x20, 0x4A, 0x04, 0x20, 0xDA, 0x01, 0x4A, 0x0E, 0x20, 0x5A, 0x09, 0x40, 0x7A, 0x07, 0x28, 0x41,
  0x9D, 0xEC, 0x63, 0x81, 0xDF, 0x92, 0x04, 0xA0, 0xA5, 0xA0, 0xE2, 0x0B, 0xA0, 0x34, 0x08, 0xA0,
  0x77, 0x38, 0x28, 0xFE, 0x12, 0x08, 0xA0, 0x64, 0x02, 0xA0, 0xD2, 0xA0, 0xE5, 0x09, 0xA0, 0x57,
  0x20, 0x2A, 0x06, 0x30, 0xCA, 0x02, 0x40, 0x4A, 0x81, 0xA0, 0x4A, 0x0A, 0x50, 0xBA, 0x03, 0x72,
  0x81, 0xBF, 0xC4, 0xA0, 0xE5, 0x07, 0xA8, 0x17, 0x07, 0xA0, 0x75, 0x0E, 0xA7, 0x20, 0x6A, 0x02,
  0x30, 0x1A, 0x0C, 0x50, 0xBA, 0x81, 0x30, 0x9A, 0x05, 0x40, 0x3A, 0x0B, 0x71, 0x82, 0x1E, 0xF8,
  0x40, 0x2A, 0x0A, 0x5A, 0x0E, 0x20, 0xAA, 0x03, 0x40, 0x7A, 0x07, 0x71, 0x81, 0xAF, 0xD5, 0x02,
  0xA0, 0xA4, 0x05, 0xA0, 0x82, 0x0A, 0xA0, 0x34, 0x0D, 0xA0, 0x17, 0x04, 0xA0, 0x45, 0x01, 0xA0,
  0xA4, 0x0C, 0xA0, 0x12, 0x09, 0xA0, 0x43, 0x05, 0xA0, 0x97, 0x18, 0x1D, 0xFA, 0x78, 0x1E, 0xFD,
  0x30, 0x6A, 0x07, 0x30, 0x6A, 0x06, 0x38, 0x2D, 0xFE, 0x17, 0x82, 0x8F, 0xE1, 0x70, 0x9A, 0x84,
  0x50, 0x5E, 0xFC, 0x40, 0x1A, 0x82, 0xC1, 0x1B, 0xA0, 0x57, 0x02, 0xA0, 0x67, 0x10, 0x10, 0xDD,
  0x0C, 0x01, 0x50, 0x7E, 0x05, 0x71, 0x81, 0xBF, 0xC7, 0x38, 0x42, 0xAE, 0xFC, 0x77, 0x18, 0x46,
  0xCF, 0xEA, 0x35,
  // "‹" (U+2039)
  0x68, 0x12, 0xED, 0x58, 0x22, 0xDF, 0x34, 0x82, 0x1D, 0xF8, 0x48, 0x21, 0xDF, 0xD4, 0x01, 0x0D,
  0xA0, 0x33, 0x01, 0x0D, 0xA0, 0x83, 0x01, 0x0C, 0xA0, 0xC4, 0x07, 0xB0, 0x34, 0x06, 0xB0, 0x45,
  0x0D, 0xA0, 0x85, 0x04, 0xA0, 0xC6, 0x0B, 0xA0, 0x15, 0x03, 0xA0, 0x56, 0x81, 0xAF, 0x96, 0x81,
  0x2F, 0xD3,
  // "›" (U+203A)
  0x38, 0x1A, 0xF4, 0x68, 0x16, 0xFD, 0x60, 0x1A, 0x06, 0x68, 0x1D, 0xFE, 0x60, 0x8A, 0x07, 0x50,
  0x4A, 0x0E, 0x01, 0x5B, 0x09, 0x50, 0xEA, 0x09, 0x40, 0x9A, 0x0E, 0x02, 0x30, 0x4A, 0x0E, 0x02,
  0x38, 0x31, 0xEF, 0xE3, 0x48, 0x2A, 0xFE, 0x34, 0x82, 0x5F, 0xE3, 0x48, 0x21, 0xEE, 0x45, 0x81,
  0xAF, 0x46,
  // "⁄" (U+2044)
  0x77, 0x48, 0x1D, 0xF7, 0x77, 0x38, 0x19, 0xFD, 0x77, 0x30, 0x3A, 0x03, 0x77, 0x38, 0x1C, 0xF9,
  0x77, 0x38, 0x27, 0xFE, 0x17, 0x72, 0x82, 0x2E, 0xF5, 0x77, 0x38, 0x1B, 0xFB, 0x77, 0x30, 0x5A,
  0x02, 0x77, 0x28, 0x21, 0xEF, 0x77, 0x73, 0x81, 0x9F, 0xD7, 0x73, 0x03, 0xA0, 0x37, 0x73, 0x81,
  0xCF, 0x97, 0x73, 0x82, 0x7F, 0xE1, 0x77, 0x20, 0x2A, 0x05, 0x77, 0x38, 0x1B, 0xFB, 0x77, 0x30,
  0x5A, 0x02, 0x77, 0x28, 0x21, 0xEF, 0x77, 0x73, 0x81, 0x9F, 0xD7, 0x73, 0x03, 0xA0, 0x37, 0x73,
  0x81, 0xDF, 0x97, 0x73, 0x82, 0x7F, 0xE1, 0x77, 0x20, 0x2A, 0x05, 0x77, 0x38, 0x1B, 0xFB, 0x77,
  0x30, 0x6A, 0x02, 0x77, 0x28, 0x21, 0xEF, 0x77, 0x73, 0x81, 0xAF, 0xD7, 0x73, 0x04, 0xA0, 0x37,
  0x73, 0x81, 0xDF, 0x97, 0x73, 0x82, 0x8F, 0xE1, 0x77, 0x30,
  // "™" (U+2122)
  0x0A, 0xFA, 0x04, 0x0A, 0xB0, 0x66, 0x05, 0xB8, 0x94, 0xAB, 0xC3, 0x2C, 0xF7, 0x25, 0xF5, 0x16,
  0xA0, 0xB6, 0x0A, 0xA8, 0x26, 0x1B, 0x62, 0x81, 0xBF, 0x52, 0x0B, 0x05, 0x2B, 0x01, 0x50, 0xEA,
  0x20, 0x70, 0x22, 0x81, 0xBF, 0x52, 0x05, 0x03, 0x29, 0x81, 0xBF, 0x54, 0x05, 0x0B, 0xA6, 0x81,
  0xBF, 0x56, 0x98, 0x16, 0xFB, 0x40, 0xA0, 0x6A, 0x68, 0x1B, 0xF5, 0x69, 0x82, 0x1E, 0xF1, 0x28,
  0x11, 0xE1, 0xA6, 0x81, 0xBF, 0x56, 0x98, 0x21, 0x9F, 0x52, 0x06, 0x0A, 0x1A, 0x68, 0x1B, 0xF5,
  0x69, 0x82, 0x14, 0xFA, 0x20, 0xB0, 0x51, 0xA6, 0x81, 0xBF, 0x56, 0x98, 0x51, 0x0E, 0xF0, 0x1E,
  0x2A, 0x68, 0x1B, 0xF5, 0x69, 0x85, 0x10, 0x9F, 0x56, 0xA2, 0xA6, 0x81, 0xBF, 0x56, 0x98, 0x51,
  0x04, 0xFA, 0xB4, 0x2A, 0x68, 0x1B, 0xF5, 0x69, 0x01, 0x28, 0x1E, 0xFE, 0x3A, 0x58, 0x21, 0xDF,
  0x95, 0x81, 0x4F, 0x42, 0x81, 0x9F, 0x92, 0x04, 0xA0, 0x43, 0x08, 0xD0, 0x32, 0x0A, 0xB8, 0x56,
  0x04, 0xF4, 0x05, 0xC0, 0xA2, 0x80, 0x21, 0x38, 0x00, 0x13, 0x01, 0x38, 0x01, 0x10,
  // "⅒" (U+2152)
  0x71, 0x00, 0x38, 0x0C, 0x00, 0x09, 0xA7, 0x48, 0x1D, 0xF7, 0x77, 0x60, 0x30, 0xDA, 0x0C, 0x73,
  0x81, 0x9F, 0xD7, 0x74, 0x81, 0x14, 0xAC, 0x09, 0x72, 0x03, 0xA0, 0x37, 0x74, 0x08, 0xA0, 0xB0,
  0x9A, 0x05, 0x72, 0x81, 0xCF, 0x97, 0x75, 0x83, 0x2A, 0x70, 0xBA, 0x02, 0x71, 0x82, 0x7F, 0xE1,
  0x77, 0x72, 0x81, 0xEF, 0xE7, 0x18, 0x22, 0xEF, 0x57, 0x77, 0x20, 0x2A, 0x0B, 0x71, 0x81, 0xBF,
  0xB7, 0x77, 0x30, 0x5A, 0x08, 0x70, 0x5A, 0x02, 0x77, 0x73, 0x08, 0xA0, 0x56, 0x82, 0x1E, 0xF7,
  0x77, 0x74, 0x0C, 0xA0, 0x16, 0x81, 0x9F, 0xD7, 0x77, 0x5A, 0x0E, 0x60, 0x3A, 0x03, 0x40, 0x03,
  0x77, 0x50, 0x3A, 0x0A, 0x68, 0x1C, 0xF9, 0x40, 0x9A, 0x78, 0x42, 0x7A, 0x97, 0x16, 0x06, 0xA0,
  0x75, 0x82, 0x7F, 0xE1, 0x20, 0x30, 0xDA, 0x0C, 0x60, 0x7D, 0x0E, 0x03, 0x50, 0x9A, 0x04, 0x40,
  0x2A, 0x82, 0x51, 0x4A, 0xC0, 0x95, 0x07, 0xA8, 0x46, 0x03, 0xEF, 0xD5, 0x0D, 0xA0, 0x14, 0x83,
  0xBF, 0xB0, 0x8A, 0x0B, 0x09, 0xA0, 0x54, 0x04, 0xA0, 0x73, 0x08, 0xA8, 0x35, 0x01, 0x16, 0xB0,
  0x50, 0x12, 0x05, 0xA8, 0x52, 0x02, 0xA7, 0x0B, 0xA0, 0x24, 0x81, 0xDF, 0xE4, 0x06, 0xA0, 0x80,
  0x5F, 0x98, 0x3B, 0x1E, 0xF7, 0x68, 0x1E, 0xFE, 0x40, 0x5A, 0x08, 0x40, 0x5A, 0x09, 0x01, 0x80,
  0x43, 0x82, 0x29, 0xFD, 0x60, 0x2A, 0x0B, 0x40, 0xBA, 0x03, 0x40, 0x6A, 0x09, 0x72, 0x03, 0xA0,
  0x36, 0x05, 0xA0, 0x83, 0x01, 0xB5, 0x07, 0xA0, 0x87, 0x28, 0x1D, 0xF9, 0x70, 0x8A, 0x05, 0x30,
  0x5A, 0x0B, 0x50, 0x9A, 0x06, 0x71, 0x82, 0x7F, 0xE1, 0x70, 0xCA, 0x01, 0x30, 0x7A, 0x08, 0x50,
  0xCA, 0x03, 0x70, 0x2A, 0x05, 0x71, 0xA0, 0xE4, 0x0A, 0xA0, 0x65, 0xA0, 0xE7, 0x18, 0x1B, 0xFB,
  0x71, 0x03, 0xA0, 0xA4, 0x0B, 0xA0, 0x44, 0x04, 0xA0, 0xA7, 0x06, 0xA0, 0x27, 0x10, 0x6A, 0x07,
  0x40, 0xBA, 0x03, 0x40, 0x8A, 0x04, 0x68, 0x21, 0xEF, 0x77, 0x20, 0x9A, 0x04, 0x40, 0xAA, 0x04,
  0x48, 0x1E, 0xFC, 0x78, 0x1A, 0xFD, 0x73, 0x0D, 0xA0, 0x14, 0x07, 0xA0, 0x53, 0x07, 0xA0, 0x46,
  0x04, 0xA0, 0x37, 0x81, 0x11, 0x6B, 0x05, 0x01, 0x30, 0x2A, 0x0B, 0x20, 0x3A, 0x08, 0x78, 0x1D,
  0xF9, 0x70, 0x5F, 0x90, 0xB3, 0x07, 0xA0, 0xD0, 0xBA, 0x08, 0x78, 0x28, 0xFE, 0x17, 0x01, 0x80,
  0x43, 0x02, 0x48, 0x45, 0xCF, 0xEB, 0x45,
  // "ﬁ" (U+FB01)
  0x77, 0x18, 0x71, 0x7B, 0xEF, 0xED, 0x92, 0x77, 0x10, 0x6F, 0xA0, 0x47, 0x60, 0x6B, 0x06, 0x20,
  0x5B, 0x0B, 0x75, 0x02, 0xB0, 0x54, 0x0C, 0xA0, 0xB7, 0x50, 0xAA, 0x0D, 0x58, 0x29, 0xFE, 0x37,
  0x40, 0x1B, 0x07, 0x50, 0x30, 0x47, 0x60, 0x6B, 0x02, 0x77, 0x60, 0x9A, 0x0E, 0x77, 0x70, 0xDA,
  0x0B, 0x77, 0x38, 0x11, 0x8C, 0xFF, 0x03, 0x78, 0x16, 0xEE, 0xC8, 0x02, 0xEC, 0x74, 0x08, 0xB6,
  0x0D, 0xA0, 0xC7, 0x40, 0xBA, 0x0D, 0x50, 0x1B, 0x09, 0x74, 0x0E, 0xA0, 0x95, 0x04, 0xB0, 0x67,
  0x30, 0x2B, 0x06, 0x50, 0x7B, 0x02, 0x73, 0x05, 0xB0, 0x35, 0x0A, 0xA0, 0xE7, 0x40, 0x8B, 0x60,
  0xDA, 0x0B, 0x74, 0x0B, 0xA0, 0xC5, 0x01, 0xB0, 0x87, 0x40, 0xEA, 0x09, 0x50, 0x4B, 0x05, 0x73,
  0x02, 0xB0, 0x65, 0x07, 0xB0, 0x27, 0x30, 0x5B, 0x03, 0x50, 0xAA, 0x0E, 0x74, 0x09, 0xB6, 0x0D,
  0xA0, 0xB7, 0x40, 0xCA, 0x0C, 0x50, 0x1B, 0x08, 0x74, 0xB0, 0x95, 0x04, 0xB0, 0x57, 0x30, 0x3B,
  0x06, 0x50, 0x6B, 0x03, 0x73, 0x06, 0xB0, 0x35, 0x09, 0xB7, 0x40, 0x9B, 0x60, 0xAA, 0x0E, 0x74,
  0x0C, 0xA0, 0xC6, 0x0A, 0xA0, 0xE7, 0x4B, 0x09, 0x60, 0x8B, 0x82, 0x30, 0x7B, 0x60, 0x3B, 0x06,
  0x60, 0x2E, 0x08, 0x60, 0x6B, 0x02, 0x78, 0x45, 0xDF, 0xD9, 0x27, 0x09, 0xA0, 0xE7, 0x77, 0x0D,
  0xA0, 0xB7, 0x76, 0x01, 0xB0, 0x77, 0x76, 0x05, 0xB0, 0x27, 0x76, 0x0A, 0xA0, 0xC7, 0x76, 0x01,
  0x0E, 0xA0, 0x57, 0x76, 0x08, 0xA0, 0xC7, 0x73, 0x01, 0x20, 0x7A, 0x0E, 0x02, 0x77, 0x30, 0xDC,
  0x0E, 0x03, 0x77, 0x48, 0x4C, 0xFE, 0xC7, 0x17, 0x75,
  // "ﬂ" (U+FB02)
  0x77, 0x18, 0x92, 0x28, 0xCE, 0xFE, 0xC9, 0x8C, 0xF3, 0x77, 0x06, 0xFC, 0x77, 0x07, 0xA0, 0xE0,
  0x52, 0x06, 0xC0, 0xC7, 0x60, 0x3B, 0x06, 0x40, 0xCB, 0x08, 0x76, 0x0B, 0xA0, 0xD5, 0x08, 0xB0,
  0x57, 0x50, 0x1B, 0x07, 0x50, 0x7B, 0x02, 0x75, 0x06, 0xB0, 0x25, 0x09, 0xA0, 0xE7, 0x60, 0x9A,
  0x0E, 0x60, 0xDA, 0x0B, 0x76, 0x0D, 0xA0, 0xB5, 0x01, 0xB0, 0x77, 0x28, 0x11, 0x8C, 0xF9, 0x81,
  0x30, 0x4B, 0x04, 0x72, 0x81, 0x6E, 0xEC, 0x80, 0x0E, 0x20, 0x7B, 0x01, 0x75, 0x08, 0xB6, 0x0A,
  0xA0, 0xD7, 0x60, 0xBA, 0x0D, 0x60, 0xEA, 0x0A, 0x76, 0x0E, 0xA0, 0x95, 0x01, 0xB0, 0x77, 0x50,
  0x2B, 0x06, 0x50, 0x5B, 0x03, 0x75, 0x05, 0xB0, 0x35, 0x08, 0xB7, 0x60, 0x8B, 0x60, 0xBA, 0x0C,
  0x76, 0x0B, 0xA0, 0xC6, 0x0E, 0xA0, 0x97, 0x60, 0xEA, 0x09, 0x50, 0x2B, 0x06, 0x75, 0x02, 0xB0,
  0x65, 0x06, 0xB0, 0x27, 0x50, 0x5B, 0x03, 0x50, 0x9A, 0x0E, 0x76, 0x09, 0xB6, 0x0C, 0xA0, 0xB7,
  0x60, 0xCA, 0x0C, 0x6B, 0x08, 0x76, 0xB0, 0x95, 0x03, 0xB0, 0x67, 0x50, 0x3B, 0x06, 0x50, 0x6B,
  0x03, 0x75, 0x06, 0xB0, 0x35, 0x08, 0xB0, 0x17, 0x50, 0x9B, 0x60, 0xAB, 0x76, 0x0C, 0xA0, 0xC6,
  0x0A, 0xB7, 0x6B, 0x09, 0x60, 0x8B, 0x82, 0x40, 0x7B, 0x71, 0x03, 0xB0, 0x66, 0x02, 0xE0, 0x87,
  0x10, 0x6B, 0x02, 0x78, 0x45, 0xDF, 0xD9, 0x27, 0x20, 0x9A, 0x0E, 0x77, 0x72, 0x0D, 0xA0, 0xB7,
  0x77, 0x10, 0x1B, 0x07, 0x77, 0x71, 0x05, 0xB0, 0x27, 0x77, 0x10, 0xAA, 0x0C, 0x77, 0x71, 0x01,
  0x0E, 0xA0, 0x57, 0x77, 0x10, 0x8A, 0x0C, 0x77, 0x50, 0x12, 0x07, 0xA0, 0xE0, 0x27, 0x75, 0x0D,
  0xC0, 0xE0, 0x37, 0x76, 0x84, 0xCF, 0xEC, 0x71, 0x77, 0x70,
};

const Font& font_NotoSerif_CondensedItalic_40() {
  static SmoothFont font(font_NotoSerif_CondensedItalic_40_data);
  return font;
}

}  // namespace roo_display
