#include "18.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-CondensedItalic (Noto Serif Condensed Italic)
// Generated on Wed Nov 19 19:11:52 CET 2025
static const uint8_t font_NotoSerif_CondensedItalic_18_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x08, 0x77,
  0xFC, 0xFD, 0x13, 0x12, 0x0E, 0xFC, 0x04, 0x01, 0x14, 0x06, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x05, 0x0D, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x42, 0x0A, 0x07, 0x0D, 0x06, 0x00, 0x1F, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x00, 0x2B, // "#" (U+0023)
  0x00, 0x24, 0x00, 0xFF, 0x08, 0x0E, 0x09, 0x00, 0x62, // "$" (U+0024)
  0x00, 0x25, 0x41, 0x01, 0x0D, 0x0D, 0x0E, 0x00, 0xA0, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x00, 0xF5, // "&" (U+0026)
  0x00, 0x27, 0x42, 0x0A, 0x04, 0x0D, 0x04, 0x01, 0x40, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFE, 0x06, 0x0E, 0x05, 0x01, 0x46, // "(" (U+0028)
  0x00, 0x29, 0xFF, 0xFE, 0x05, 0x0E, 0x05, 0x01, 0x74, // ")" (U+0029)
  0x00, 0x2A, 0x42, 0x07, 0x08, 0x0E, 0x08, 0x01, 0xA2, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x04, 0x07, 0x0B, 0x08, 0x01, 0xBE, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0xFE, 0x02, 0x02, 0x04, 0x01, 0xD5, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x05, 0x04, 0x05, 0x05, 0x01, 0xDF, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x02, 0x03, 0x04, 0x01, 0xE2, // "." (U+002E)
  0x00, 0x2F, 0xFE, 0xFF, 0x06, 0x0E, 0x04, 0x01, 0xE7, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x08, 0x0D, 0x09, 0x02, 0x10, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x06, 0x0D, 0x09, 0x02, 0x4B, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x02, 0x74, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x02, 0xA7, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x02, 0xDC, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x03, 0x0E, // "5" (U+0035)
  0x00, 0x36, 0x41, 0x01, 0x08, 0x0D, 0x09, 0x03, 0x40, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x09, 0x0D, 0x09, 0x03, 0x74, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x08, 0x0D, 0x09, 0x03, 0x9E, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x03, 0xD9, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x04, 0x13, // ":" (U+003A)
  0x00, 0x3B, 0xFF, 0xFF, 0x04, 0x0A, 0x05, 0x04, 0x24, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x03, 0x07, 0x0B, 0x08, 0x04, 0x3B, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x05, 0x07, 0x09, 0x08, 0x04, 0x56, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x03, 0x07, 0x0B, 0x08, 0x04, 0x60, // ">" (U+003E)
  0x00, 0x3F, 0x02, 0x01, 0x08, 0x0D, 0x08, 0x04, 0x7B, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFF, 0x0D, 0x0D, 0x0E, 0x04, 0xA3, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x0A, 0x0D, 0x0B, 0x04, 0xFE, // "A" (U+0041)
  0x00, 0x42, 0xFF, 0x01, 0x09, 0x0D, 0x0A, 0x05, 0x3A, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0A, 0x0D, 0x0A, 0x05, 0x7F, // "C" (U+0043)
  0x00, 0x44, 0xFF, 0x01, 0x0B, 0x0D, 0x0B, 0x05, 0xB2, // "D" (U+0044)
  0x00, 0x45, 0xFF, 0x01, 0x0A, 0x0D, 0x0A, 0x05, 0xFB, // "E" (U+0045)
  0x00, 0x46, 0xFF, 0x01, 0x0A, 0x0D, 0x09, 0x06, 0x35, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0B, 0x0D, 0x0B, 0x06, 0x69, // "G" (U+0047)
  0x00, 0x48, 0xFF, 0x01, 0x0D, 0x0D, 0x0C, 0x06, 0xA7, // "H" (U+0048)
  0x00, 0x49, 0xFF, 0x01, 0x06, 0x0D, 0x06, 0x06, 0xF2, // "I" (U+0049)
  0x00, 0x4A, 0xFD, 0xFD, 0x06, 0x0D, 0x06, 0x07, 0x18, // "J" (U+004A)
  0x00, 0x4B, 0xFF, 0x01, 0x0C, 0x0D, 0x0B, 0x07, 0x49, // "K" (U+004B)
  0x00, 0x4C, 0xFF, 0x01, 0x08, 0x0D, 0x0A, 0x07, 0x91, // "L" (U+004C)
  0x00, 0x4D, 0xFF, 0x01, 0x0F, 0x0D, 0x0F, 0x07, 0xBF, // "M" (U+004D)
  0x00, 0x4E, 0xFF, 0x01, 0x0D, 0x0D, 0x0C, 0x08, 0x24, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x0B, 0x0D, 0x0C, 0x08, 0x74, // "O" (U+004F)
  0x00, 0x50, 0xFF, 0x01, 0x09, 0x0D, 0x0A, 0x08, 0xB4, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFD, 0x0B, 0x0D, 0x0C, 0x08, 0xEE, // "Q" (U+0051)
  0x00, 0x52, 0xFF, 0x01, 0x09, 0x0D, 0x0A, 0x09, 0x3A, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x09, 0x7D, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x0A, 0x0D, 0x0A, 0x09, 0xB0, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x0C, 0x0D, 0x0B, 0x09, 0xDE, // "U" (U+0055)
  0x00, 0x56, 0x01, 0x01, 0x0C, 0x0D, 0x0B, 0x0A, 0x23, // "V" (U+0056)
  0x00, 0x57, 0x01, 0x01, 0x11, 0x0D, 0x10, 0x0A, 0x5F, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x0B, 0x0D, 0x0A, 0x0A, 0xC2, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x0B, 0x0D, 0x0A, 0x0B, 0x03, // "Y" (U+0059)
  0x00, 0x5A, 0xFF, 0x01, 0x0A, 0x0D, 0x0A, 0x0B, 0x39, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFF, 0x06, 0x0E, 0x06, 0x0B, 0x78, // "[" (U+005B)
  0x00, 0x5C, 0x42, 0xFF, 0x03, 0x0E, 0x04, 0x0B, 0xA7, // "\" (U+005C)
  0x00, 0x5D, 0xFF, 0xFF, 0x05, 0x0E, 0x06, 0x0B, 0xB7, // "]" (U+005D)
  0x00, 0x5E, 0x41, 0x06, 0x07, 0x0D, 0x08, 0x0B, 0xE4, // "^" (U+005E)
  0x00, 0x5F, 0xBE, 0xFE, 0x05, 0xFE, 0x07, 0x0C, 0x00, // "_" (U+005F)
  0x00, 0x60, 0x42, 0x0C, 0x05, 0x0E, 0x05, 0x0C, 0x04, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x08, 0x0A, 0x09, 0x0C, 0x0A, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x0C, 0x37, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x0C, 0x74, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x0C, 0x98, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x0C, 0xDA, // "e" (U+0065)
  0x00, 0x66, 0xFD, 0xFD, 0x08, 0x0E, 0x05, 0x0D, 0x02, // "f" (U+0066)
  0x00, 0x67, 0xFF, 0xFD, 0x09, 0x0B, 0x09, 0x0D, 0x40, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x0D, 0x84, // "h" (U+0068)
  0x00, 0x69, 0x41, 0x01, 0x04, 0x0E, 0x05, 0x0D, 0xC4, // "i" (U+0069)
  0x00, 0x6A, 0xFD, 0xFD, 0x04, 0x0E, 0x05, 0x0D, 0xE0, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x09, 0x0E, 0x09, 0x0E, 0x0D, // "k" (U+006B)
  0x00, 0x6C, 0x41, 0x01, 0x05, 0x0E, 0x05, 0x0E, 0x49, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x0D, 0x0A, 0x0E, 0x0E, 0x6C, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x08, 0x0A, 0x0A, 0x0E, 0xB2, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x08, 0x0A, 0x09, 0x0E, 0xDF, // "o" (U+006F)
  0x00, 0x70, 0xFF, 0xFD, 0x08, 0x0A, 0x09, 0x0F, 0x0C, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFD, 0x08, 0x0A, 0x09, 0x0F, 0x4B, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x0F, 0x86, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x06, 0x0A, 0x07, 0x0F, 0xA6, // "s" (U+0073)
  0x00, 0x74, 0x41, 0x01, 0x05, 0x0C, 0x06, 0x0F, 0xC9, // "t" (U+0074)
  0x00, 0x75, 0x41, 0x01, 0x09, 0x0A, 0x09, 0x0F, 0xE7, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x08, 0x0A, 0x08, 0x10, 0x14, // "v" (U+0076)
  0x00, 0x77, 0x41, 0x01, 0x0C, 0x0A, 0x0D, 0x10, 0x40, // "w" (U+0077)
  0x00, 0x78, 0xFF, 0x01, 0x08, 0x0A, 0x09, 0x10, 0x7C, // "x" (U+0078)
  0x00, 0x79, 0xFD, 0xFD, 0x08, 0x0A, 0x08, 0x10, 0xA7, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x07, 0x0A, 0x08, 0x10, 0xE2, // "z" (U+007A)
  0x00, 0x7B, 0x01, 0xFF, 0x07, 0x0E, 0x07, 0x11, 0x0A, // "{" (U+007B)
  0x00, 0x7C, 0x43, 0xFD, 0x04, 0x0E, 0x09, 0x11, 0x38, // "|" (U+007C)
  0x00, 0x7D, 0xFF, 0xFF, 0x05, 0x0E, 0x07, 0x11, 0x4A, // "}" (U+007D)
  0x00, 0x7E, 0x41, 0x06, 0x07, 0x08, 0x08, 0x11, 0x78, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFE, 0x04, 0x0A, 0x05, 0x11, 0x83, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x08, 0x0D, 0x09, 0x11, 0xA4, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x09, 0x0D, 0x09, 0x11, 0xD3, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x03, 0x08, 0x0B, 0x0A, 0x12, 0x06, // "¤" (U+00A4)
  0x00, 0xA5, 0x01, 0x01, 0x0A, 0x0D, 0x09, 0x12, 0x29, // "¥" (U+00A5)
  0x00, 0xA6, 0x43, 0xFD, 0x04, 0x0E, 0x09, 0x12, 0x5F, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0xFF, 0x08, 0x0E, 0x08, 0x12, 0x71, // "§" (U+00A7)
  0x00, 0xA8, 0x43, 0x0D, 0x07, 0x0E, 0x09, 0x12, 0xB5, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x0C, 0x0E, 0x0D, 0x12, 0xBA, // "©" (U+00A9)
  0x00, 0xAA, 0x41, 0x08, 0x06, 0x0D, 0x06, 0x13, 0x0F, // "ª" (U+00AA)
  0x00, 0xAB, 0x41, 0x02, 0x07, 0x08, 0x08, 0x13, 0x21, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x03, 0x07, 0x07, 0x08, 0x13, 0x3A, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x0C, 0x0E, 0x0D, 0x13, 0x48, // "®" (U+00AE)
  0x00, 0xAF, 0x42, 0x0F, 0x09, 0x0F, 0x07, 0x13, 0xA3, // "¯" (U+00AF)
  0x00, 0xB0, 0x42, 0x09, 0x06, 0x0E, 0x06, 0x13, 0xA7, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x07, 0x0B, 0x08, 0x13, 0xB6, // "±" (U+00B1)
  0x00, 0xB2, 0x41, 0x08, 0x06, 0x0F, 0x06, 0x13, 0xD2, // "²" (U+00B2)
  0x00, 0xB3, 0x41, 0x08, 0x06, 0x0F, 0x06, 0x13, 0xEA, // "³" (U+00B3)
  0x00, 0xB4, 0x42, 0x0C, 0x05, 0x0E, 0x04, 0x14, 0x02, // "´" (U+00B4)
  0x00, 0xB5, 0xFF, 0xFD, 0x08, 0x0A, 0x0A, 0x14, 0x08, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFF, 0x0A, 0x0E, 0x0B, 0x14, 0x49, // "¶" (U+00B6)
  0x00, 0xB7, 0x41, 0x06, 0x03, 0x08, 0x04, 0x14, 0x8D, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFD, 0x03, 0x01, 0x05, 0x14, 0x92, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x08, 0x05, 0x10, 0x06, 0x14, 0x9C, // "¹" (U+00B9)
  0x00, 0xBA, 0x41, 0x08, 0x06, 0x0D, 0x06, 0x14, 0xB3, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x07, 0x08, 0x08, 0x14, 0xC5, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x0D, 0x0E, 0x0E, 0x14, 0xE1, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x0D, 0x0E, 0x0E, 0x15, 0x37, // "½" (U+00BD)
  0x00, 0xBE, 0x01, 0x01, 0x0D, 0x0D, 0x0E, 0x15, 0x8B, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x06, 0x0A, 0x08, 0x15, 0xDE, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x0A, 0x11, 0x0B, 0x16, 0x07, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x0A, 0x11, 0x0B, 0x16, 0x4D, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x0A, 0x11, 0x0B, 0x16, 0x94, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x0A, 0x10, 0x0B, 0x16, 0xDC, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x0A, 0x11, 0x0B, 0x17, 0x22, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x0A, 0x10, 0x0B, 0x17, 0x68, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x0F, 0x0D, 0x0F, 0x17, 0xB0, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFD, 0x0A, 0x0D, 0x0A, 0x18, 0x05, // "Ç" (U+00C7)
  0x00, 0xC8, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x18, 0x43, // "È" (U+00C8)
  0x00, 0xC9, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x18, 0x87, // "É" (U+00C9)
  0x00, 0xCA, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x18, 0xCC, // "Ê" (U+00CA)
  0x00, 0xCB, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x19, 0x12, // "Ë" (U+00CB)
  0x00, 0xCC, 0xFF, 0x01, 0x06, 0x11, 0x06, 0x19, 0x56, // "Ì" (U+00CC)
  0x00, 0xCD, 0xFF, 0x01, 0x07, 0x11, 0x06, 0x19, 0x85, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x06, 0x11, 0x06, 0x19, 0xB4, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x06, 0x11, 0x06, 0x19, 0xE5, // "Ï" (U+00CF)
  0x00, 0xD0, 0xFF, 0x01, 0x0B, 0x0D, 0x0B, 0x1A, 0x14, // "Ð" (U+00D0)
  0x00, 0xD1, 0xFF, 0x01, 0x0D, 0x10, 0x0C, 0x1A, 0x5D, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x1A, 0xB7, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x1B, 0x01, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x1B, 0x4B, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x0B, 0x10, 0x0C, 0x1B, 0x97, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x1B, 0xE1, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x07, 0x0A, 0x08, 0x1C, 0x2A, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x0B, 0x0E, 0x0C, 0x1C, 0x45, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x0C, 0x11, 0x0B, 0x1C, 0x97, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x0C, 0x11, 0x0B, 0x1C, 0xE6, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x0C, 0x11, 0x0B, 0x1D, 0x36, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x0C, 0x11, 0x0B, 0x1D, 0x87, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x0B, 0x11, 0x0A, 0x1D, 0xD6, // "Ý" (U+00DD)
  0x00, 0xDE, 0xFF, 0x01, 0x09, 0x0D, 0x09, 0x1E, 0x17, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFD, 0xFD, 0x09, 0x0E, 0x0A, 0x1E, 0x54, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1E, 0xA9, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1E, 0xE3, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1F, 0x1D, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x1F, 0x59, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1F, 0x93, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x1F, 0xCD, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x0C, 0x0A, 0x0D, 0x20, 0x0C, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x20, 0x4D, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x20, 0x7C, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x20, 0xAD, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x20, 0xE1, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x21, 0x14, // "ë" (U+00EB)
  0x00, 0xEC, 0x41, 0x01, 0x04, 0x0E, 0x05, 0x21, 0x45, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x06, 0x0E, 0x05, 0x21, 0x61, // "í" (U+00ED)
  0x00, 0xEE, 0x41, 0x01, 0x05, 0x0E, 0x05, 0x21, 0x85, // "î" (U+00EE)
  0x00, 0xEF, 0x01, 0x01, 0x05, 0x0E, 0x05, 0x21, 0xA8, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x08, 0x0E, 0x09, 0x21, 0xC9, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x08, 0x0D, 0x0A, 0x22, 0x08, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x22, 0x43, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x22, 0x7B, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x22, 0xB3, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x22, 0xED, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x23, 0x25, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x03, 0x07, 0x0B, 0x08, 0x23, 0x5D, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x08, 0x0B, 0x09, 0x23, 0x70, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x09, 0x0E, 0x09, 0x23, 0xA3, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x09, 0x0E, 0x09, 0x23, 0xDF, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x09, 0x0E, 0x09, 0x24, 0x1B, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x09, 0x0E, 0x09, 0x24, 0x59, // "ü" (U+00FC)
  0x00, 0xFD, 0xFD, 0xFD, 0x08, 0x0E, 0x08, 0x24, 0x95, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFD, 0x08, 0x0E, 0x09, 0x24, 0xDB, // "þ" (U+00FE)
  0x00, 0xFF, 0xFD, 0xFD, 0x08, 0x0E, 0x08, 0x25, 0x28, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x0A, 0x0F, 0x0B, 0x25, 0x6D, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x25, 0xAE, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x0A, 0x11, 0x0B, 0x25, 0xE3, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x26, 0x2B, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFD, 0x0A, 0x0D, 0x0B, 0x26, 0x67, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x08, 0x0A, 0x09, 0x26, 0xB0, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0A, 0x11, 0x0A, 0x26, 0xEC, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x27, 0x28, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0A, 0x11, 0x0A, 0x27, 0x57, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x27, 0x95, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0A, 0x11, 0x0A, 0x27, 0xC4, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x27, 0xFE, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0B, 0x11, 0x0A, 0x28, 0x29, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x09, 0x0E, 0x08, 0x28, 0x6B, // "č" (U+010D)
  0x01, 0x0E, 0xFF, 0x01, 0x0B, 0x11, 0x0B, 0x28, 0x9D, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x0C, 0x0E, 0x09, 0x28, 0xF3, // "ď" (U+010F)
  0x01, 0x10, 0xFF, 0x01, 0x0B, 0x0D, 0x0B, 0x29, 0x39, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x0A, 0x0E, 0x09, 0x29, 0x82, // "đ" (U+0111)
  0x01, 0x12, 0xFF, 0x01, 0x0A, 0x0F, 0x0A, 0x29, 0xC7, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x2A, 0x06, // "ē" (U+0113)
  0x01, 0x14, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x2A, 0x33, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x2A, 0x7A, // "ĕ" (U+0115)
  0x01, 0x16, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x2A, 0xAE, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x2A, 0xF1, // "ė" (U+0117)
  0x01, 0x18, 0xFF, 0xFD, 0x0A, 0x0D, 0x0A, 0x2B, 0x20, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x2B, 0x66, // "ę" (U+0119)
  0x01, 0x1A, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x2B, 0x99, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x09, 0x0E, 0x08, 0x2B, 0xE0, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0B, 0x11, 0x0B, 0x2C, 0x17, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xFD, 0x09, 0x0E, 0x09, 0x2C, 0x61, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0B, 0x11, 0x0B, 0x2C, 0xB0, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xFD, 0x09, 0x0E, 0x09, 0x2C, 0xFA, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0B, 0x11, 0x0B, 0x2D, 0x49, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xFD, 0x09, 0x0E, 0x09, 0x2D, 0x8F, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFD, 0x0B, 0x0D, 0x0B, 0x2D, 0xDA, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xFD, 0x09, 0x0E, 0x09, 0x2E, 0x21, // "ģ" (U+0123)
  0x01, 0x24, 0xFF, 0x01, 0x0D, 0x11, 0x0C, 0x2E, 0x6D, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x2E, 0xC5, // "ĥ" (U+0125)
  0x01, 0x26, 0xFF, 0x01, 0x0D, 0x0D, 0x0C, 0x2F, 0x0F, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x08, 0x0E, 0x09, 0x2F, 0x5E, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x07, 0x10, 0x06, 0x2F, 0x9D, // "Ĩ" (U+0128)
  0x01, 0x29, 0x01, 0x01, 0x06, 0x0D, 0x05, 0x2F, 0xCD, // "ĩ" (U+0129)
  0x01, 0x2A, 0xFF, 0x01, 0x07, 0x0F, 0x06, 0x2F, 0xEF, // "Ī" (U+012A)
  0x01, 0x2B, 0x01, 0x01, 0x05, 0x0C, 0x05, 0x30, 0x1A, // "ī" (U+012B)
  0x01, 0x2C, 0xFF, 0x01, 0x06, 0x11, 0x06, 0x30, 0x37, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x41, 0x01, 0x05, 0x0E, 0x05, 0x30, 0x69, // "ĭ" (U+012D)
  0x01, 0x2E, 0xFF, 0xFD, 0x06, 0x0D, 0x06, 0x30, 0x8C, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFD, 0x04, 0x0E, 0x05, 0x30, 0xBD, // "į" (U+012F)
  0x01, 0x30, 0xFF, 0x01, 0x06, 0x11, 0x06, 0x30, 0xE6, // "İ" (U+0130)
  0x01, 0x31, 0x41, 0x01, 0x04, 0x0A, 0x05, 0x31, 0x13, // "ı" (U+0131)
  0x01, 0x32, 0xFF, 0xFD, 0x0C, 0x0D, 0x0B, 0x31, 0x27, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFD, 0x09, 0x0E, 0x09, 0x31, 0x7E, // "ĳ" (U+0133)
  0x01, 0x34, 0xFD, 0xFD, 0x06, 0x11, 0x06, 0x31, 0xC5, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFD, 0xFD, 0x05, 0x0E, 0x05, 0x32, 0x02, // "ĵ" (U+0135)
  0x01, 0x36, 0xFF, 0xFD, 0x0C, 0x0D, 0x0B, 0x32, 0x34, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFD, 0x09, 0x0E, 0x09, 0x32, 0x86, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x09, 0x0A, 0x09, 0x32, 0xCA, // "ĸ" (U+0138)
  0x01, 0x39, 0xFF, 0x01, 0x08, 0x11, 0x0A, 0x32, 0xFC, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x01, 0x01, 0x07, 0x11, 0x05, 0x33, 0x33, // "ĺ" (U+013A)
  0x01, 0x3B, 0xFF, 0xFD, 0x08, 0x0D, 0x0A, 0x33, 0x62, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFD, 0x05, 0x0E, 0x05, 0x33, 0x98, // "ļ" (U+013C)
  0x01, 0x3D, 0xFF, 0x01, 0x09, 0x0D, 0x0A, 0x33, 0xC6, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x07, 0x0E, 0x05, 0x33, 0xFD, // "ľ" (U+013E)
  0x01, 0x3F, 0xFF, 0x01, 0x09, 0x0D, 0x0A, 0x34, 0x27, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x07, 0x0E, 0x06, 0x34, 0x5E, // "ŀ" (U+0140)
  0x01, 0x41, 0xFF, 0x01, 0x08, 0x0D, 0x0A, 0x34, 0x87, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x05, 0x0E, 0x05, 0x34, 0xB9, // "ł" (U+0142)
  0x01, 0x43, 0xFF, 0x01, 0x0D, 0x11, 0x0C, 0x34, 0xE1, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x35, 0x3C, // "ń" (U+0144)
  0x01, 0x45, 0xFF, 0xFD, 0x0D, 0x0D, 0x0C, 0x35, 0x77, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFD, 0x08, 0x0A, 0x0A, 0x35, 0xD1, // "ņ" (U+0146)
  0x01, 0x47, 0xFF, 0x01, 0x0D, 0x11, 0x0C, 0x36, 0x0B, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x09, 0x0E, 0x0A, 0x36, 0x68, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x36, 0xA9, // "ŉ" (U+0149)
  0x01, 0x4A, 0xFF, 0xFD, 0x0D, 0x0D, 0x0C, 0x36, 0xEC, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFD, 0x08, 0x0A, 0x09, 0x37, 0x48, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x37, 0x85, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x37, 0xCA, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x37, 0xFD, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x38, 0x49, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x0C, 0x11, 0x0C, 0x38, 0x83, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x0A, 0x0E, 0x09, 0x38, 0xD6, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x0F, 0x0D, 0x0F, 0x39, 0x19, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x0D, 0x0A, 0x0D, 0x39, 0x6D, // "œ" (U+0153)
  0x01, 0x54, 0xFF, 0x01, 0x09, 0x11, 0x0A, 0x39, 0xB3, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x3A, 0x01, // "ŕ" (U+0155)
  0x01, 0x56, 0xFF, 0xFD, 0x09, 0x0D, 0x0A, 0x3A, 0x2A, // "Ŗ" (U+0156)
  0x01, 0x57, 0xFF, 0xFD, 0x07, 0x0A, 0x07, 0x3A, 0x77, // "ŗ" (U+0157)
  0x01, 0x58, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x3A, 0x9F, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x08, 0x0E, 0x07, 0x3A, 0xF0, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x09, 0x11, 0x09, 0x3B, 0x1C, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x3B, 0x5C, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x08, 0x11, 0x09, 0x3B, 0x8D, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x3B, 0xCB, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFD, 0x08, 0x0D, 0x09, 0x3B, 0xFE, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFD, 0x06, 0x0A, 0x07, 0x3C, 0x3C, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x09, 0x11, 0x09, 0x3C, 0x6B, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x08, 0x0E, 0x07, 0x3C, 0xAD, // "š" (U+0161)
  0x01, 0x62, 0x01, 0xFD, 0x0A, 0x0D, 0x0A, 0x3C, 0xE2, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFD, 0x05, 0x0C, 0x06, 0x3D, 0x1C, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x0A, 0x11, 0x0A, 0x3D, 0x48, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x01, 0x07, 0x0E, 0x06, 0x3D, 0x82, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x0A, 0x0D, 0x0A, 0x3D, 0xAB, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x05, 0x0C, 0x06, 0x3D, 0xDC, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x0C, 0x10, 0x0B, 0x3E, 0x00, // "Ũ" (U+0168)
  0x01, 0x69, 0x41, 0x01, 0x09, 0x0D, 0x09, 0x3E, 0x4F, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x0C, 0x0F, 0x0B, 0x3E, 0x8A, // "Ū" (U+016A)
  0x01, 0x6B, 0x41, 0x01, 0x09, 0x0C, 0x09, 0x3E, 0xD4, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x0C, 0x11, 0x0B, 0x3F, 0x0A, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x41, 0x01, 0x09, 0x0E, 0x09, 0x3F, 0x5C, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x0C, 0x12, 0x0B, 0x3F, 0x9B, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x09, 0x0F, 0x09, 0x3F, 0xF1, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x0C, 0x11, 0x0B, 0x40, 0x33, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x0A, 0x0E, 0x09, 0x40, 0x86, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFD, 0x0C, 0x0D, 0x0B, 0x40, 0xCA, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFD, 0x09, 0x0A, 0x09, 0x41, 0x1C, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x11, 0x11, 0x10, 0x41, 0x5A, // "Ŵ" (U+0174)
  0x01, 0x75, 0x01, 0x01, 0x0C, 0x0E, 0x0D, 0x41, 0xCB, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x0B, 0x11, 0x0A, 0x42, 0x18, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFD, 0xFD, 0x08, 0x0E, 0x08, 0x42, 0x5A, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x0B, 0x11, 0x0A, 0x42, 0xA1, // "Ÿ" (U+0178)
  0x01, 0x79, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x42, 0xE1, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x43, 0x2B, // "ź" (U+017A)
  0x01, 0x7B, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x43, 0x5C, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x43, 0xA4, // "ż" (U+017C)
  0x01, 0x7D, 0xFF, 0x01, 0x0A, 0x11, 0x0A, 0x43, 0xD3, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x08, 0x0E, 0x08, 0x44, 0x1F, // "ž" (U+017E)
  0x01, 0x7F, 0xFD, 0xFD, 0x08, 0x0E, 0x05, 0x44, 0x55, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x44, 0x93, // "Ω" (U+03A9)
  0x03, 0xBC, 0xFF, 0xFD, 0x08, 0x0A, 0x0A, 0x44, 0xDD, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x0A, 0x0A, 0x0A, 0x45, 0x1E, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x05, 0x09, 0x05, 0x09, 0x45, 0x55, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x05, 0x12, 0x05, 0x12, 0x45, 0x59, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x09, 0x0D, 0x09, 0x45, 0x5E, // "€" (U+20AC)
  0x20, 0xBF, 0xFF, 0xFF, 0x08, 0x0F, 0x09, 0x45, 0x8F, // "₿" (U+20BF)
  0x20, 0x18, 0x41, 0x09, 0x04, 0x0D, 0x04, 0x45, 0xDD, // "‘" (U+2018)
  0x20, 0x19, 0x41, 0x09, 0x04, 0x0D, 0x04, 0x45, 0xE7, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0xFE, 0x02, 0x02, 0x04, 0x45, 0xF1, // "‚" (U+201A)
  0x20, 0x1B, 0x42, 0x09, 0x04, 0x0D, 0x04, 0x45, 0xFB, // "‛" (U+201B)
  0x20, 0x1C, 0x41, 0x09, 0x07, 0x0D, 0x07, 0x46, 0x03, // "“" (U+201C)
  0x20, 0x1D, 0x41, 0x09, 0x07, 0x0D, 0x07, 0x46, 0x15, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0xFE, 0x05, 0x02, 0x07, 0x46, 0x27, // "„" (U+201E)
  0x20, 0x1F, 0x42, 0x09, 0x07, 0x0D, 0x07, 0x46, 0x39, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0xFF, 0x07, 0x0E, 0x07, 0x46, 0x48, // "†" (U+2020)
  0x20, 0x21, 0x00, 0xFF, 0x07, 0x0E, 0x07, 0x46, 0x72, // "‡" (U+2021)
  0x20, 0x22, 0x41, 0x05, 0x05, 0x09, 0x06, 0x46, 0xA6, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x0B, 0x03, 0x0D, 0x46, 0xB3, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x01, 0x13, 0x0D, 0x14, 0x46, 0xC5, // "‰" (U+2030)
  0x20, 0x39, 0x41, 0x02, 0x04, 0x08, 0x05, 0x47, 0x3B, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x04, 0x08, 0x05, 0x47, 0x49, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x05, 0x0D, 0x01, 0x47, 0x5B, // "⁄" (U+2044)
  0x21, 0x22, 0x41, 0x07, 0x0D, 0x0D, 0x0D, 0x47, 0x7F, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x12, 0x0E, 0x13, 0x47, 0xAD, // "⅒" (U+2152)
  0xFB, 0x01, 0xFD, 0xFD, 0x08, 0x0E, 0x09, 0x48, 0x1C, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFD, 0xFD, 0x09, 0x0E, 0x09, 0x48, 0x72, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x01, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x74, 0x01, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x02, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x02, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x02, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x02, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x02, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x02, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x02, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x02, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x76, 0x01, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x77, 0x01, // Aw (U+0041 U+0077)
  0x00, 0x41, 0x00, 0x79, 0x01, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xA9, 0x01, // A© (U+0041 U+00A9)
  0x00, 0x41, 0x00, 0xAE, 0x01, // A® (U+0041 U+00AE)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xFD, 0x01, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x01, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x49, 0x01, // Aŉ (U+0041 U+0149)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x75, 0x01, // Aŵ (U+0041 U+0175)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x01, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x02, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x02, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x02, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x02, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x02, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x56, 0x01, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x57, 0x01, // BW (U+0042 U+0057)
  0x00, 0x42, 0x00, 0x59, 0x01, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0xC6, 0x01, // BÆ (U+0042 U+00C6)
  0x00, 0x42, 0x00, 0xDD, 0x01, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x01, 0x74, 0x01, // BŴ (U+0042 U+0174)
  0x00, 0x42, 0x01, 0x76, 0x01, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x78, 0x01, // BŸ (U+0042 U+0178)
  0x00, 0x44, 0x00, 0x22, 0x01, // D" (U+0044 U+0022)
  0x00, 0x44, 0x00, 0x27, 0x01, // D' (U+0044 U+0027)
  0x00, 0x44, 0x00, 0xC6, 0x01, // DÆ (U+0044 U+00C6)
  0x00, 0x46, 0x00, 0x26, 0x01, // F& (U+0046 U+0026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x01, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x01, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x01, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x01, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x01, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x01, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x01, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x02, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x01, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x01, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x01, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x01, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x01, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x01, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x01, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x01, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x01, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x01, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x01, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x01, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x01, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x01, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x01, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x01, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x01, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x01, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x01, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x01, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x01, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x01, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x01, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x01, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x01, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x01, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x01, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x01, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x01, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x01, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x01, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x01, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x01, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x01, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x01, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x01, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x01, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x01, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x01, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x01, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x01, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0x77, 0x01, // Kw (U+004B U+0077)
  0x00, 0x4B, 0x00, 0x79, 0x01, // Ky (U+004B U+0079)
  0x00, 0x4B, 0x00, 0xFD, 0x01, // Ký (U+004B U+00FD)
  0x00, 0x4B, 0x00, 0xFF, 0x01, // Kÿ (U+004B U+00FF)
  0x00, 0x4B, 0x01, 0x75, 0x01, // Kŵ (U+004B U+0175)
  0x00, 0x4B, 0x01, 0x77, 0x01, // Kŷ (U+004B U+0177)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0x76, 0x01, // Lv (U+004C U+0076)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x02, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x02, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x4F, 0x00, 0x22, 0x01, // O" (U+004F U+0022)
  0x00, 0x4F, 0x00, 0x27, 0x01, // O' (U+004F U+0027)
  0x00, 0x4F, 0x00, 0xC6, 0x01, // OÆ (U+004F U+00C6)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x22, 0x01, // Q" (U+0051 U+0022)
  0x00, 0x51, 0x00, 0x27, 0x01, // Q' (U+0051 U+0027)
  0x00, 0x51, 0x00, 0xC6, 0x01, // QÆ (U+0051 U+00C6)
  0x00, 0x52, 0x00, 0x56, 0x01, // RV (U+0052 U+0056)
  0x00, 0x52, 0x00, 0x57, 0x01, // RW (U+0052 U+0057)
  0x00, 0x52, 0x00, 0x59, 0x01, // RY (U+0052 U+0059)
  0x00, 0x52, 0x00, 0xDD, 0x01, // RÝ (U+0052 U+00DD)
  0x00, 0x52, 0x01, 0x74, 0x01, // RŴ (U+0052 U+0174)
  0x00, 0x52, 0x01, 0x76, 0x01, // RŶ (U+0052 U+0176)
  0x00, 0x52, 0x01, 0x78, 0x01, // RŸ (U+0052 U+0178)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x01, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x26, 0x01, // V& (U+0056 U+0026)
  0x00, 0x56, 0x00, 0x2C, 0x02, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x02, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x01, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x02, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x01, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x01, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x01, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x01, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x02, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x02, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x02, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x26, 0x01, // W& (U+0057 U+0026)
  0x00, 0x57, 0x00, 0x2C, 0x02, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x02, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x02, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x01, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x01, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x20, 0x1A, 0x02, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x02, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x02, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x77, 0x01, // Xw (U+0058 U+0077)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xA9, 0x01, // X© (U+0058 U+00A9)
  0x00, 0x58, 0x00, 0xAE, 0x01, // X® (U+0058 U+00AE)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x75, 0x01, // Xŵ (U+0058 U+0175)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x02, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x01, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x01, // a' (U+0061 U+0027)
  0x00, 0x61, 0x00, 0x56, 0x01, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x57, 0x01, // aW (U+0061 U+0057)
  0x00, 0x61, 0x00, 0x59, 0x01, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0xDD, 0x01, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x01, 0x74, 0x01, // aŴ (U+0061 U+0174)
  0x00, 0x61, 0x01, 0x76, 0x01, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x78, 0x01, // aŸ (U+0061 U+0178)
  0x00, 0x61, 0x20, 0x18, 0x01, // a‘ (U+0061 U+2018)
  0x00, 0x61, 0x20, 0x1C, 0x01, // a“ (U+0061 U+201C)
  0x00, 0x62, 0x00, 0x54, 0x01, // bT (U+0062 U+0054)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x63, 0x00, 0x56, 0x01, // cV (U+0063 U+0056)
  0x00, 0x63, 0x00, 0x57, 0x01, // cW (U+0063 U+0057)
  0x00, 0x63, 0x00, 0x59, 0x01, // cY (U+0063 U+0059)
  0x00, 0x63, 0x00, 0xDD, 0x01, // cÝ (U+0063 U+00DD)
  0x00, 0x63, 0x01, 0x74, 0x01, // cŴ (U+0063 U+0174)
  0x00, 0x63, 0x01, 0x76, 0x01, // cŶ (U+0063 U+0176)
  0x00, 0x63, 0x01, 0x78, 0x01, // cŸ (U+0063 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x22, 0x01, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x01, // h' (U+0068 U+0027)
  0x00, 0x68, 0x00, 0x56, 0x01, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x57, 0x01, // hW (U+0068 U+0057)
  0x00, 0x68, 0x00, 0x59, 0x01, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0xDD, 0x01, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x01, 0x74, 0x01, // hŴ (U+0068 U+0174)
  0x00, 0x68, 0x01, 0x76, 0x01, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x78, 0x01, // hŸ (U+0068 U+0178)
  0x00, 0x68, 0x20, 0x18, 0x01, // h‘ (U+0068 U+2018)
  0x00, 0x68, 0x20, 0x1C, 0x01, // h“ (U+0068 U+201C)
  0x00, 0x6D, 0x00, 0x22, 0x01, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x01, // m' (U+006D U+0027)
  0x00, 0x6D, 0x00, 0x56, 0x01, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x57, 0x01, // mW (U+006D U+0057)
  0x00, 0x6D, 0x00, 0x59, 0x01, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0xDD, 0x01, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x01, 0x74, 0x01, // mŴ (U+006D U+0174)
  0x00, 0x6D, 0x01, 0x76, 0x01, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x78, 0x01, // mŸ (U+006D U+0178)
  0x00, 0x6D, 0x20, 0x18, 0x01, // m‘ (U+006D U+2018)
  0x00, 0x6D, 0x20, 0x1C, 0x01, // m“ (U+006D U+201C)
  0x00, 0x6E, 0x00, 0x22, 0x01, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x01, // n' (U+006E U+0027)
  0x00, 0x6E, 0x00, 0x56, 0x01, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x57, 0x01, // nW (U+006E U+0057)
  0x00, 0x6E, 0x00, 0x59, 0x01, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0xDD, 0x01, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x01, 0x74, 0x01, // nŴ (U+006E U+0174)
  0x00, 0x6E, 0x01, 0x76, 0x01, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x78, 0x01, // nŸ (U+006E U+0178)
  0x00, 0x6E, 0x20, 0x18, 0x01, // n‘ (U+006E U+2018)
  0x00, 0x6E, 0x20, 0x1C, 0x01, // n“ (U+006E U+201C)
  0x00, 0x6F, 0x00, 0x54, 0x01, // oT (U+006F U+0054)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x54, 0x01, // pT (U+0070 U+0054)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x71, 0x00, 0x57, 0x01, // qW (U+0071 U+0057)
  0x00, 0x71, 0x01, 0x74, 0x01, // qŴ (U+0071 U+0174)
  0x00, 0x72, 0x00, 0x2C, 0x03, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x03, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x56, 0x01, // rV (U+0072 U+0056)
  0x00, 0x72, 0x00, 0x57, 0x01, // rW (U+0072 U+0057)
  0x00, 0x72, 0x00, 0x58, 0x01, // rX (U+0072 U+0058)
  0x00, 0x72, 0x00, 0x59, 0x01, // rY (U+0072 U+0059)
  0x00, 0x72, 0x00, 0xDD, 0x01, // rÝ (U+0072 U+00DD)
  0x00, 0x72, 0x01, 0x74, 0x01, // rŴ (U+0072 U+0174)
  0x00, 0x72, 0x01, 0x76, 0x01, // rŶ (U+0072 U+0176)
  0x00, 0x72, 0x01, 0x78, 0x01, // rŸ (U+0072 U+0178)
  0x00, 0x72, 0x20, 0x1A, 0x03, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x03, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x03, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x56, 0x01, // sV (U+0073 U+0056)
  0x00, 0x73, 0x00, 0x57, 0x01, // sW (U+0073 U+0057)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x74, 0x01, // sŴ (U+0073 U+0174)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x56, 0x01, // vV (U+0076 U+0056)
  0x00, 0x76, 0x00, 0x59, 0x01, // vY (U+0076 U+0059)
  0x00, 0x76, 0x00, 0xDD, 0x01, // vÝ (U+0076 U+00DD)
  0x00, 0x76, 0x01, 0x76, 0x01, // vŶ (U+0076 U+0176)
  0x00, 0x76, 0x01, 0x78, 0x01, // vŸ (U+0076 U+0178)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x00, 0x59, 0x01, // wY (U+0077 U+0059)
  0x00, 0x77, 0x00, 0xDD, 0x01, // wÝ (U+0077 U+00DD)
  0x00, 0x77, 0x01, 0x76, 0x01, // wŶ (U+0077 U+0176)
  0x00, 0x77, 0x01, 0x78, 0x01, // wŸ (U+0077 U+0178)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0x7A, 0x00, 0x56, 0x01, // zV (U+007A U+0056)
  0x00, 0x7A, 0x00, 0x57, 0x01, // zW (U+007A U+0057)
  0x00, 0x7A, 0x00, 0x59, 0x01, // zY (U+007A U+0059)
  0x00, 0x7A, 0x00, 0xDD, 0x01, // zÝ (U+007A U+00DD)
  0x00, 0x7A, 0x01, 0x74, 0x01, // zŴ (U+007A U+0174)
  0x00, 0x7A, 0x01, 0x76, 0x01, // zŶ (U+007A U+0176)
  0x00, 0x7A, 0x01, 0x78, 0x01, // zŸ (U+007A U+0178)
  0x00, 0xA1, 0x00, 0x56, 0x01, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x02, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x77, 0x01, // Àw (U+00C0 U+0077)
  0x00, 0xC0, 0x00, 0x79, 0x01, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xA9, 0x01, // À© (U+00C0 U+00A9)
  0x00, 0xC0, 0x00, 0xAE, 0x01, // À® (U+00C0 U+00AE)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xFD, 0x01, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x01, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x49, 0x01, // Àŉ (U+00C0 U+0149)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x75, 0x01, // Àŵ (U+00C0 U+0175)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x01, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x02, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x02, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x02, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x02, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x02, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x02, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x77, 0x01, // Áw (U+00C1 U+0077)
  0x00, 0xC1, 0x00, 0x79, 0x01, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xA9, 0x01, // Á© (U+00C1 U+00A9)
  0x00, 0xC1, 0x00, 0xAE, 0x01, // Á® (U+00C1 U+00AE)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xFD, 0x01, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x01, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x49, 0x01, // Áŉ (U+00C1 U+0149)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x75, 0x01, // Áŵ (U+00C1 U+0175)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x01, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x02, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x02, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x02, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x02, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x02, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x02, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x77, 0x01, // Âw (U+00C2 U+0077)
  0x00, 0xC2, 0x00, 0x79, 0x01, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xA9, 0x01, // Â© (U+00C2 U+00A9)
  0x00, 0xC2, 0x00, 0xAE, 0x01, // Â® (U+00C2 U+00AE)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xFD, 0x01, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x01, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x49, 0x01, // Âŉ (U+00C2 U+0149)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x75, 0x01, // Âŵ (U+00C2 U+0175)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x01, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x02, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x02, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x02, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x02, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x02, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x02, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x77, 0x01, // Ãw (U+00C3 U+0077)
  0x00, 0xC3, 0x00, 0x79, 0x01, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xA9, 0x01, // Ã© (U+00C3 U+00A9)
  0x00, 0xC3, 0x00, 0xAE, 0x01, // Ã® (U+00C3 U+00AE)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xFD, 0x01, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x01, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x49, 0x01, // Ãŉ (U+00C3 U+0149)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x75, 0x01, // Ãŵ (U+00C3 U+0175)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x01, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x02, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x02, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x02, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x02, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x02, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x02, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x77, 0x01, // Äw (U+00C4 U+0077)
  0x00, 0xC4, 0x00, 0x79, 0x01, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xA9, 0x01, // Ä© (U+00C4 U+00A9)
  0x00, 0xC4, 0x00, 0xAE, 0x01, // Ä® (U+00C4 U+00AE)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xFD, 0x01, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x01, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x49, 0x01, // Äŉ (U+00C4 U+0149)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x75, 0x01, // Äŵ (U+00C4 U+0175)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x01, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x02, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x02, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x02, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x02, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x02, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x02, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x77, 0x01, // Åw (U+00C5 U+0077)
  0x00, 0xC5, 0x00, 0x79, 0x01, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xA9, 0x01, // Å© (U+00C5 U+00A9)
  0x00, 0xC5, 0x00, 0xAE, 0x01, // Å® (U+00C5 U+00AE)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xFD, 0x01, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x01, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x49, 0x01, // Åŉ (U+00C5 U+0149)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x75, 0x01, // Åŵ (U+00C5 U+0175)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x01, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x02, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x02, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x02, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x02, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x02, // Å™ (U+00C5 U+2122)
  0x00, 0xD0, 0x00, 0x22, 0x01, // Ð" (U+00D0 U+0022)
  0x00, 0xD0, 0x00, 0x27, 0x01, // Ð' (U+00D0 U+0027)
  0x00, 0xD0, 0x00, 0xC6, 0x01, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD2, 0x00, 0x22, 0x01, // Ò" (U+00D2 U+0022)
  0x00, 0xD2, 0x00, 0x27, 0x01, // Ò' (U+00D2 U+0027)
  0x00, 0xD2, 0x00, 0xC6, 0x01, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD3, 0x00, 0x22, 0x01, // Ó" (U+00D3 U+0022)
  0x00, 0xD3, 0x00, 0x27, 0x01, // Ó' (U+00D3 U+0027)
  0x00, 0xD3, 0x00, 0xC6, 0x01, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD4, 0x00, 0x22, 0x01, // Ô" (U+00D4 U+0022)
  0x00, 0xD4, 0x00, 0x27, 0x01, // Ô' (U+00D4 U+0027)
  0x00, 0xD4, 0x00, 0xC6, 0x01, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD5, 0x00, 0x22, 0x01, // Õ" (U+00D5 U+0022)
  0x00, 0xD5, 0x00, 0x27, 0x01, // Õ' (U+00D5 U+0027)
  0x00, 0xD5, 0x00, 0xC6, 0x01, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD6, 0x00, 0x22, 0x01, // Ö" (U+00D6 U+0022)
  0x00, 0xD6, 0x00, 0x27, 0x01, // Ö' (U+00D6 U+0027)
  0x00, 0xD6, 0x00, 0xC6, 0x01, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD8, 0x00, 0x22, 0x01, // Ø" (U+00D8 U+0022)
  0x00, 0xD8, 0x00, 0x27, 0x01, // Ø' (U+00D8 U+0027)
  0x00, 0xD8, 0x00, 0xC6, 0x01, // ØÆ (U+00D8 U+00C6)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x02, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x22, 0x01, // Þ" (U+00DE U+0022)
  0x00, 0xDE, 0x00, 0x27, 0x01, // Þ' (U+00DE U+0027)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDF, 0x00, 0x56, 0x01, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x01, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x74, 0x01, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x01, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x01, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x00, 0x56, 0x01, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x57, 0x01, // àW (U+00E0 U+0057)
  0x00, 0xE0, 0x00, 0x59, 0x01, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0xDD, 0x01, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x01, 0x74, 0x01, // àŴ (U+00E0 U+0174)
  0x00, 0xE0, 0x01, 0x76, 0x01, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x78, 0x01, // àŸ (U+00E0 U+0178)
  0x00, 0xE0, 0x20, 0x18, 0x01, // à‘ (U+00E0 U+2018)
  0x00, 0xE0, 0x20, 0x1C, 0x01, // à“ (U+00E0 U+201C)
  0x00, 0xE1, 0x00, 0x22, 0x01, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x01, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x00, 0x56, 0x01, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x57, 0x01, // áW (U+00E1 U+0057)
  0x00, 0xE1, 0x00, 0x59, 0x01, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0xDD, 0x01, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x01, 0x74, 0x01, // áŴ (U+00E1 U+0174)
  0x00, 0xE1, 0x01, 0x76, 0x01, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x78, 0x01, // áŸ (U+00E1 U+0178)
  0x00, 0xE1, 0x20, 0x18, 0x01, // á‘ (U+00E1 U+2018)
  0x00, 0xE1, 0x20, 0x1C, 0x01, // á“ (U+00E1 U+201C)
  0x00, 0xE2, 0x00, 0x22, 0x01, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x01, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x00, 0x56, 0x01, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x57, 0x01, // âW (U+00E2 U+0057)
  0x00, 0xE2, 0x00, 0x59, 0x01, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0xDD, 0x01, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x01, 0x74, 0x01, // âŴ (U+00E2 U+0174)
  0x00, 0xE2, 0x01, 0x76, 0x01, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x78, 0x01, // âŸ (U+00E2 U+0178)
  0x00, 0xE2, 0x20, 0x18, 0x01, // â‘ (U+00E2 U+2018)
  0x00, 0xE2, 0x20, 0x1C, 0x01, // â“ (U+00E2 U+201C)
  0x00, 0xE3, 0x00, 0x22, 0x01, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x01, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x00, 0x56, 0x01, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x57, 0x01, // ãW (U+00E3 U+0057)
  0x00, 0xE3, 0x00, 0x59, 0x01, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0xDD, 0x01, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x01, 0x74, 0x01, // ãŴ (U+00E3 U+0174)
  0x00, 0xE3, 0x01, 0x76, 0x01, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x78, 0x01, // ãŸ (U+00E3 U+0178)
  0x00, 0xE3, 0x20, 0x18, 0x01, // ã‘ (U+00E3 U+2018)
  0x00, 0xE3, 0x20, 0x1C, 0x01, // ã“ (U+00E3 U+201C)
  0x00, 0xE4, 0x00, 0x22, 0x01, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x01, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x00, 0x56, 0x01, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x57, 0x01, // äW (U+00E4 U+0057)
  0x00, 0xE4, 0x00, 0x59, 0x01, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0xDD, 0x01, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x01, 0x74, 0x01, // äŴ (U+00E4 U+0174)
  0x00, 0xE4, 0x01, 0x76, 0x01, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x78, 0x01, // äŸ (U+00E4 U+0178)
  0x00, 0xE4, 0x20, 0x18, 0x01, // ä‘ (U+00E4 U+2018)
  0x00, 0xE4, 0x20, 0x1C, 0x01, // ä“ (U+00E4 U+201C)
  0x00, 0xE5, 0x00, 0x22, 0x01, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x01, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x00, 0x56, 0x01, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x57, 0x01, // åW (U+00E5 U+0057)
  0x00, 0xE5, 0x00, 0x59, 0x01, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0xDD, 0x01, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x01, 0x74, 0x01, // åŴ (U+00E5 U+0174)
  0x00, 0xE5, 0x01, 0x76, 0x01, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x78, 0x01, // åŸ (U+00E5 U+0178)
  0x00, 0xE5, 0x20, 0x18, 0x01, // å‘ (U+00E5 U+2018)
  0x00, 0xE5, 0x20, 0x1C, 0x01, // å“ (U+00E5 U+201C)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE7, 0x00, 0x56, 0x01, // çV (U+00E7 U+0056)
  0x00, 0xE7, 0x00, 0x57, 0x01, // çW (U+00E7 U+0057)
  0x00, 0xE7, 0x00, 0x59, 0x01, // çY (U+00E7 U+0059)
  0x00, 0xE7, 0x00, 0xDD, 0x01, // çÝ (U+00E7 U+00DD)
  0x00, 0xE7, 0x01, 0x74, 0x01, // çŴ (U+00E7 U+0174)
  0x00, 0xE7, 0x01, 0x76, 0x01, // çŶ (U+00E7 U+0176)
  0x00, 0xE7, 0x01, 0x78, 0x01, // çŸ (U+00E7 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x54, 0x01, // ðT (U+00F0 U+0054)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x01, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x01, // ñ' (U+00F1 U+0027)
  0x00, 0xF1, 0x00, 0x56, 0x01, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x57, 0x01, // ñW (U+00F1 U+0057)
  0x00, 0xF1, 0x00, 0x59, 0x01, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0xDD, 0x01, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x01, 0x74, 0x01, // ñŴ (U+00F1 U+0174)
  0x00, 0xF1, 0x01, 0x76, 0x01, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x78, 0x01, // ñŸ (U+00F1 U+0178)
  0x00, 0xF1, 0x20, 0x18, 0x01, // ñ‘ (U+00F1 U+2018)
  0x00, 0xF1, 0x20, 0x1C, 0x01, // ñ“ (U+00F1 U+201C)
  0x00, 0xF2, 0x00, 0x54, 0x01, // òT (U+00F2 U+0054)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x54, 0x01, // óT (U+00F3 U+0054)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x54, 0x01, // ôT (U+00F4 U+0054)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x54, 0x01, // õT (U+00F5 U+0054)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x54, 0x01, // öT (U+00F6 U+0054)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x54, 0x01, // øT (U+00F8 U+0054)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xF9, 0x00, 0x22, 0x01, // ù" (U+00F9 U+0022)
  0x00, 0xF9, 0x00, 0x27, 0x01, // ù' (U+00F9 U+0027)
  0x00, 0xF9, 0x00, 0x56, 0x01, // ùV (U+00F9 U+0056)
  0x00, 0xF9, 0x00, 0x57, 0x01, // ùW (U+00F9 U+0057)
  0x00, 0xF9, 0x00, 0x59, 0x01, // ùY (U+00F9 U+0059)
  0x00, 0xF9, 0x00, 0xDD, 0x01, // ùÝ (U+00F9 U+00DD)
  0x00, 0xF9, 0x01, 0x74, 0x01, // ùŴ (U+00F9 U+0174)
  0x00, 0xF9, 0x01, 0x76, 0x01, // ùŶ (U+00F9 U+0176)
  0x00, 0xF9, 0x01, 0x78, 0x01, // ùŸ (U+00F9 U+0178)
  0x00, 0xF9, 0x20, 0x18, 0x01, // ù‘ (U+00F9 U+2018)
  0x00, 0xF9, 0x20, 0x1C, 0x01, // ù“ (U+00F9 U+201C)
  0x00, 0xFA, 0x00, 0x22, 0x01, // ú" (U+00FA U+0022)
  0x00, 0xFA, 0x00, 0x27, 0x01, // ú' (U+00FA U+0027)
  0x00, 0xFA, 0x00, 0x56, 0x01, // úV (U+00FA U+0056)
  0x00, 0xFA, 0x00, 0x57, 0x01, // úW (U+00FA U+0057)
  0x00, 0xFA, 0x00, 0x59, 0x01, // úY (U+00FA U+0059)
  0x00, 0xFA, 0x00, 0xDD, 0x01, // úÝ (U+00FA U+00DD)
  0x00, 0xFA, 0x01, 0x74, 0x01, // úŴ (U+00FA U+0174)
  0x00, 0xFA, 0x01, 0x76, 0x01, // úŶ (U+00FA U+0176)
  0x00, 0xFA, 0x01, 0x78, 0x01, // úŸ (U+00FA U+0178)
  0x00, 0xFA, 0x20, 0x18, 0x01, // ú‘ (U+00FA U+2018)
  0x00, 0xFA, 0x20, 0x1C, 0x01, // ú“ (U+00FA U+201C)
  0x00, 0xFB, 0x00, 0x22, 0x01, // û" (U+00FB U+0022)
  0x00, 0xFB, 0x00, 0x27, 0x01, // û' (U+00FB U+0027)
  0x00, 0xFB, 0x00, 0x56, 0x01, // ûV (U+00FB U+0056)
  0x00, 0xFB, 0x00, 0x57, 0x01, // ûW (U+00FB U+0057)
  0x00, 0xFB, 0x00, 0x59, 0x01, // ûY (U+00FB U+0059)
  0x00, 0xFB, 0x00, 0xDD, 0x01, // ûÝ (U+00FB U+00DD)
  0x00, 0xFB, 0x01, 0x74, 0x01, // ûŴ (U+00FB U+0174)
  0x00, 0xFB, 0x01, 0x76, 0x01, // ûŶ (U+00FB U+0176)
  0x00, 0xFB, 0x01, 0x78, 0x01, // ûŸ (U+00FB U+0178)
  0x00, 0xFB, 0x20, 0x18, 0x01, // û‘ (U+00FB U+2018)
  0x00, 0xFB, 0x20, 0x1C, 0x01, // û“ (U+00FB U+201C)
  0x00, 0xFC, 0x00, 0x22, 0x01, // ü" (U+00FC U+0022)
  0x00, 0xFC, 0x00, 0x27, 0x01, // ü' (U+00FC U+0027)
  0x00, 0xFC, 0x00, 0x56, 0x01, // üV (U+00FC U+0056)
  0x00, 0xFC, 0x00, 0x57, 0x01, // üW (U+00FC U+0057)
  0x00, 0xFC, 0x00, 0x59, 0x01, // üY (U+00FC U+0059)
  0x00, 0xFC, 0x00, 0xDD, 0x01, // üÝ (U+00FC U+00DD)
  0x00, 0xFC, 0x01, 0x74, 0x01, // üŴ (U+00FC U+0174)
  0x00, 0xFC, 0x01, 0x76, 0x01, // üŶ (U+00FC U+0176)
  0x00, 0xFC, 0x01, 0x78, 0x01, // üŸ (U+00FC U+0178)
  0x00, 0xFC, 0x20, 0x18, 0x01, // ü‘ (U+00FC U+2018)
  0x00, 0xFC, 0x20, 0x1C, 0x01, // ü“ (U+00FC U+201C)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x54, 0x01, // þT (U+00FE U+0054)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x02, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x76, 0x01, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x77, 0x01, // Āw (U+0100 U+0077)
  0x01, 0x00, 0x00, 0x79, 0x01, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xA9, 0x01, // Ā© (U+0100 U+00A9)
  0x01, 0x00, 0x00, 0xAE, 0x01, // Ā® (U+0100 U+00AE)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xFD, 0x01, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x01, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x49, 0x01, // Āŉ (U+0100 U+0149)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x75, 0x01, // Āŵ (U+0100 U+0175)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x01, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x02, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x02, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x02, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x02, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x02, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x22, 0x01, // ā" (U+0101 U+0022)
  0x01, 0x01, 0x00, 0x27, 0x01, // ā' (U+0101 U+0027)
  0x01, 0x01, 0x00, 0x56, 0x01, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x57, 0x01, // āW (U+0101 U+0057)
  0x01, 0x01, 0x00, 0x59, 0x01, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0xDD, 0x01, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x01, 0x74, 0x01, // āŴ (U+0101 U+0174)
  0x01, 0x01, 0x01, 0x76, 0x01, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x78, 0x01, // āŸ (U+0101 U+0178)
  0x01, 0x01, 0x20, 0x18, 0x01, // ā‘ (U+0101 U+2018)
  0x01, 0x01, 0x20, 0x1C, 0x01, // ā“ (U+0101 U+201C)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x02, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x77, 0x01, // Ăw (U+0102 U+0077)
  0x01, 0x02, 0x00, 0x79, 0x01, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xA9, 0x01, // Ă© (U+0102 U+00A9)
  0x01, 0x02, 0x00, 0xAE, 0x01, // Ă® (U+0102 U+00AE)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xFD, 0x01, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x01, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x49, 0x01, // Ăŉ (U+0102 U+0149)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x75, 0x01, // Ăŵ (U+0102 U+0175)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x01, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x02, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x02, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x02, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x02, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x02, // Ă™ (U+0102 U+2122)
  0x01, 0x03, 0x00, 0x22, 0x01, // ă" (U+0103 U+0022)
  0x01, 0x03, 0x00, 0x27, 0x01, // ă' (U+0103 U+0027)
  0x01, 0x03, 0x00, 0x56, 0x01, // ăV (U+0103 U+0056)
  0x01, 0x03, 0x00, 0x57, 0x01, // ăW (U+0103 U+0057)
  0x01, 0x03, 0x00, 0x59, 0x01, // ăY (U+0103 U+0059)
  0x01, 0x03, 0x00, 0xDD, 0x01, // ăÝ (U+0103 U+00DD)
  0x01, 0x03, 0x01, 0x74, 0x01, // ăŴ (U+0103 U+0174)
  0x01, 0x03, 0x01, 0x76, 0x01, // ăŶ (U+0103 U+0176)
  0x01, 0x03, 0x01, 0x78, 0x01, // ăŸ (U+0103 U+0178)
  0x01, 0x03, 0x20, 0x18, 0x01, // ă‘ (U+0103 U+2018)
  0x01, 0x03, 0x20, 0x1C, 0x01, // ă“ (U+0103 U+201C)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x02, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x77, 0x01, // Ąw (U+0104 U+0077)
  0x01, 0x04, 0x00, 0x79, 0x01, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xA9, 0x01, // Ą© (U+0104 U+00A9)
  0x01, 0x04, 0x00, 0xAE, 0x01, // Ą® (U+0104 U+00AE)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xFD, 0x01, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x01, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x49, 0x01, // Ąŉ (U+0104 U+0149)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x75, 0x01, // Ąŵ (U+0104 U+0175)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x01, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x02, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x02, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x02, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x02, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x02, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x22, 0x01, // ą" (U+0105 U+0022)
  0x01, 0x05, 0x00, 0x27, 0x01, // ą' (U+0105 U+0027)
  0x01, 0x05, 0x00, 0x56, 0x01, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x57, 0x01, // ąW (U+0105 U+0057)
  0x01, 0x05, 0x00, 0x59, 0x01, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0xDD, 0x01, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x01, 0x74, 0x01, // ąŴ (U+0105 U+0174)
  0x01, 0x05, 0x01, 0x76, 0x01, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x78, 0x01, // ąŸ (U+0105 U+0178)
  0x01, 0x05, 0x20, 0x18, 0x01, // ą‘ (U+0105 U+2018)
  0x01, 0x05, 0x20, 0x1C, 0x01, // ą“ (U+0105 U+201C)
  0x01, 0x07, 0x00, 0x56, 0x01, // ćV (U+0107 U+0056)
  0x01, 0x07, 0x00, 0x57, 0x01, // ćW (U+0107 U+0057)
  0x01, 0x07, 0x00, 0x59, 0x01, // ćY (U+0107 U+0059)
  0x01, 0x07, 0x00, 0xDD, 0x01, // ćÝ (U+0107 U+00DD)
  0x01, 0x07, 0x01, 0x74, 0x01, // ćŴ (U+0107 U+0174)
  0x01, 0x07, 0x01, 0x76, 0x01, // ćŶ (U+0107 U+0176)
  0x01, 0x07, 0x01, 0x78, 0x01, // ćŸ (U+0107 U+0178)
  0x01, 0x09, 0x00, 0x56, 0x01, // ĉV (U+0109 U+0056)
  0x01, 0x09, 0x00, 0x57, 0x01, // ĉW (U+0109 U+0057)
  0x01, 0x09, 0x00, 0x59, 0x01, // ĉY (U+0109 U+0059)
  0x01, 0x09, 0x00, 0xDD, 0x01, // ĉÝ (U+0109 U+00DD)
  0x01, 0x09, 0x01, 0x74, 0x01, // ĉŴ (U+0109 U+0174)
  0x01, 0x09, 0x01, 0x76, 0x01, // ĉŶ (U+0109 U+0176)
  0x01, 0x09, 0x01, 0x78, 0x01, // ĉŸ (U+0109 U+0178)
  0x01, 0x0B, 0x00, 0x56, 0x01, // ċV (U+010B U+0056)
  0x01, 0x0B, 0x00, 0x57, 0x01, // ċW (U+010B U+0057)
  0x01, 0x0B, 0x00, 0x59, 0x01, // ċY (U+010B U+0059)
  0x01, 0x0B, 0x00, 0xDD, 0x01, // ċÝ (U+010B U+00DD)
  0x01, 0x0B, 0x01, 0x74, 0x01, // ċŴ (U+010B U+0174)
  0x01, 0x0B, 0x01, 0x76, 0x01, // ċŶ (U+010B U+0176)
  0x01, 0x0B, 0x01, 0x78, 0x01, // ċŸ (U+010B U+0178)
  0x01, 0x0D, 0x00, 0x56, 0x01, // čV (U+010D U+0056)
  0x01, 0x0D, 0x00, 0x57, 0x01, // čW (U+010D U+0057)
  0x01, 0x0D, 0x00, 0x59, 0x01, // čY (U+010D U+0059)
  0x01, 0x0D, 0x00, 0xDD, 0x01, // čÝ (U+010D U+00DD)
  0x01, 0x0D, 0x01, 0x74, 0x01, // čŴ (U+010D U+0174)
  0x01, 0x0D, 0x01, 0x76, 0x01, // čŶ (U+010D U+0176)
  0x01, 0x0D, 0x01, 0x78, 0x01, // čŸ (U+010D U+0178)
  0x01, 0x0E, 0x00, 0x22, 0x01, // Ď" (U+010E U+0022)
  0x01, 0x0E, 0x00, 0x27, 0x01, // Ď' (U+010E U+0027)
  0x01, 0x0E, 0x00, 0xC6, 0x01, // ĎÆ (U+010E U+00C6)
  0x01, 0x10, 0x00, 0x22, 0x01, // Đ" (U+0110 U+0022)
  0x01, 0x10, 0x00, 0x27, 0x01, // Đ' (U+0110 U+0027)
  0x01, 0x10, 0x00, 0xC6, 0x01, // ĐÆ (U+0110 U+00C6)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x25, 0x00, 0x22, 0x01, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x01, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x00, 0x56, 0x01, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x57, 0x01, // ĥW (U+0125 U+0057)
  0x01, 0x25, 0x00, 0x59, 0x01, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0xDD, 0x01, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x01, 0x74, 0x01, // ĥŴ (U+0125 U+0174)
  0x01, 0x25, 0x01, 0x76, 0x01, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x78, 0x01, // ĥŸ (U+0125 U+0178)
  0x01, 0x25, 0x20, 0x18, 0x01, // ĥ‘ (U+0125 U+2018)
  0x01, 0x25, 0x20, 0x1C, 0x01, // ĥ“ (U+0125 U+201C)
  0x01, 0x27, 0x00, 0x22, 0x01, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x01, // ħ' (U+0127 U+0027)
  0x01, 0x27, 0x00, 0x56, 0x01, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x57, 0x01, // ħW (U+0127 U+0057)
  0x01, 0x27, 0x00, 0x59, 0x01, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0xDD, 0x01, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x01, 0x74, 0x01, // ħŴ (U+0127 U+0174)
  0x01, 0x27, 0x01, 0x76, 0x01, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x78, 0x01, // ħŸ (U+0127 U+0178)
  0x01, 0x27, 0x20, 0x18, 0x01, // ħ‘ (U+0127 U+2018)
  0x01, 0x27, 0x20, 0x1C, 0x01, // ħ“ (U+0127 U+201C)
  0x01, 0x36, 0x00, 0x77, 0x01, // Ķw (U+0136 U+0077)
  0x01, 0x36, 0x00, 0x79, 0x01, // Ķy (U+0136 U+0079)
  0x01, 0x36, 0x00, 0xFD, 0x01, // Ķý (U+0136 U+00FD)
  0x01, 0x36, 0x00, 0xFF, 0x01, // Ķÿ (U+0136 U+00FF)
  0x01, 0x36, 0x01, 0x75, 0x01, // Ķŵ (U+0136 U+0175)
  0x01, 0x36, 0x01, 0x77, 0x01, // Ķŷ (U+0136 U+0177)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0x76, 0x01, // Ĺv (U+0139 U+0076)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x02, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x02, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0x76, 0x01, // Ļv (U+013B U+0076)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x02, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x02, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x3D, 0x00, 0x2A, 0x01, // Ľ* (U+013D U+002A)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3D, 0x21, 0x22, 0x01, // Ľ™ (U+013D U+2122)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0x76, 0x01, // Łv (U+0141 U+0076)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x02, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x02, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x44, 0x00, 0x22, 0x01, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x01, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x00, 0x56, 0x01, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x57, 0x01, // ńW (U+0144 U+0057)
  0x01, 0x44, 0x00, 0x59, 0x01, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0xDD, 0x01, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x01, 0x74, 0x01, // ńŴ (U+0144 U+0174)
  0x01, 0x44, 0x01, 0x76, 0x01, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x78, 0x01, // ńŸ (U+0144 U+0178)
  0x01, 0x44, 0x20, 0x18, 0x01, // ń‘ (U+0144 U+2018)
  0x01, 0x44, 0x20, 0x1C, 0x01, // ń“ (U+0144 U+201C)
  0x01, 0x46, 0x00, 0x22, 0x01, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x01, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x00, 0x56, 0x01, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x57, 0x01, // ņW (U+0146 U+0057)
  0x01, 0x46, 0x00, 0x59, 0x01, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0xDD, 0x01, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x01, 0x74, 0x01, // ņŴ (U+0146 U+0174)
  0x01, 0x46, 0x01, 0x76, 0x01, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x78, 0x01, // ņŸ (U+0146 U+0178)
  0x01, 0x46, 0x20, 0x18, 0x01, // ņ‘ (U+0146 U+2018)
  0x01, 0x46, 0x20, 0x1C, 0x01, // ņ“ (U+0146 U+201C)
  0x01, 0x48, 0x00, 0x22, 0x01, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x01, // ň' (U+0148 U+0027)
  0x01, 0x48, 0x00, 0x56, 0x01, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x57, 0x01, // ňW (U+0148 U+0057)
  0x01, 0x48, 0x00, 0x59, 0x01, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0xDD, 0x01, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x01, 0x74, 0x01, // ňŴ (U+0148 U+0174)
  0x01, 0x48, 0x01, 0x76, 0x01, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x78, 0x01, // ňŸ (U+0148 U+0178)
  0x01, 0x48, 0x20, 0x18, 0x01, // ň‘ (U+0148 U+2018)
  0x01, 0x48, 0x20, 0x1C, 0x01, // ň“ (U+0148 U+201C)
  0x01, 0x49, 0x00, 0x22, 0x01, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x01, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x00, 0x56, 0x01, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x57, 0x01, // ŉW (U+0149 U+0057)
  0x01, 0x49, 0x00, 0x59, 0x01, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0xDD, 0x01, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x01, 0x74, 0x01, // ŉŴ (U+0149 U+0174)
  0x01, 0x49, 0x01, 0x76, 0x01, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x78, 0x01, // ŉŸ (U+0149 U+0178)
  0x01, 0x49, 0x20, 0x18, 0x01, // ŉ‘ (U+0149 U+2018)
  0x01, 0x49, 0x20, 0x1C, 0x01, // ŉ“ (U+0149 U+201C)
  0x01, 0x4B, 0x00, 0x22, 0x01, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x01, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x00, 0x56, 0x01, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x57, 0x01, // ŋW (U+014B U+0057)
  0x01, 0x4B, 0x00, 0x59, 0x01, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0xDD, 0x01, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x01, 0x74, 0x01, // ŋŴ (U+014B U+0174)
  0x01, 0x4B, 0x01, 0x76, 0x01, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x78, 0x01, // ŋŸ (U+014B U+0178)
  0x01, 0x4B, 0x20, 0x18, 0x01, // ŋ‘ (U+014B U+2018)
  0x01, 0x4B, 0x20, 0x1C, 0x01, // ŋ“ (U+014B U+201C)
  0x01, 0x4C, 0x00, 0x22, 0x01, // Ō" (U+014C U+0022)
  0x01, 0x4C, 0x00, 0x27, 0x01, // Ō' (U+014C U+0027)
  0x01, 0x4C, 0x00, 0xC6, 0x01, // ŌÆ (U+014C U+00C6)
  0x01, 0x4D, 0x00, 0x54, 0x01, // ōT (U+014D U+0054)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0x22, 0x01, // Ŏ" (U+014E U+0022)
  0x01, 0x4E, 0x00, 0x27, 0x01, // Ŏ' (U+014E U+0027)
  0x01, 0x4E, 0x00, 0xC6, 0x01, // ŎÆ (U+014E U+00C6)
  0x01, 0x4F, 0x00, 0x54, 0x01, // ŏT (U+014F U+0054)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0x22, 0x01, // Ő" (U+0150 U+0022)
  0x01, 0x50, 0x00, 0x27, 0x01, // Ő' (U+0150 U+0027)
  0x01, 0x50, 0x00, 0xC6, 0x01, // ŐÆ (U+0150 U+00C6)
  0x01, 0x51, 0x00, 0x54, 0x01, // őT (U+0151 U+0054)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x54, 0x00, 0x56, 0x01, // ŔV (U+0154 U+0056)
  0x01, 0x54, 0x00, 0x57, 0x01, // ŔW (U+0154 U+0057)
  0x01, 0x54, 0x00, 0x59, 0x01, // ŔY (U+0154 U+0059)
  0x01, 0x54, 0x00, 0xDD, 0x01, // ŔÝ (U+0154 U+00DD)
  0x01, 0x54, 0x01, 0x74, 0x01, // ŔŴ (U+0154 U+0174)
  0x01, 0x54, 0x01, 0x76, 0x01, // ŔŶ (U+0154 U+0176)
  0x01, 0x54, 0x01, 0x78, 0x01, // ŔŸ (U+0154 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x03, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x03, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x56, 0x01, // ŕV (U+0155 U+0056)
  0x01, 0x55, 0x00, 0x57, 0x01, // ŕW (U+0155 U+0057)
  0x01, 0x55, 0x00, 0x58, 0x01, // ŕX (U+0155 U+0058)
  0x01, 0x55, 0x00, 0x59, 0x01, // ŕY (U+0155 U+0059)
  0x01, 0x55, 0x00, 0xDD, 0x01, // ŕÝ (U+0155 U+00DD)
  0x01, 0x55, 0x01, 0x74, 0x01, // ŕŴ (U+0155 U+0174)
  0x01, 0x55, 0x01, 0x76, 0x01, // ŕŶ (U+0155 U+0176)
  0x01, 0x55, 0x01, 0x78, 0x01, // ŕŸ (U+0155 U+0178)
  0x01, 0x55, 0x20, 0x1A, 0x03, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x03, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x03, // ŕ… (U+0155 U+2026)
  0x01, 0x56, 0x00, 0x56, 0x01, // ŖV (U+0156 U+0056)
  0x01, 0x56, 0x00, 0x57, 0x01, // ŖW (U+0156 U+0057)
  0x01, 0x56, 0x00, 0x59, 0x01, // ŖY (U+0156 U+0059)
  0x01, 0x56, 0x00, 0xDD, 0x01, // ŖÝ (U+0156 U+00DD)
  0x01, 0x56, 0x01, 0x74, 0x01, // ŖŴ (U+0156 U+0174)
  0x01, 0x56, 0x01, 0x76, 0x01, // ŖŶ (U+0156 U+0176)
  0x01, 0x56, 0x01, 0x78, 0x01, // ŖŸ (U+0156 U+0178)
  0x01, 0x57, 0x00, 0x2C, 0x03, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x03, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x56, 0x01, // ŗV (U+0157 U+0056)
  0x01, 0x57, 0x00, 0x57, 0x01, // ŗW (U+0157 U+0057)
  0x01, 0x57, 0x00, 0x58, 0x01, // ŗX (U+0157 U+0058)
  0x01, 0x57, 0x00, 0x59, 0x01, // ŗY (U+0157 U+0059)
  0x01, 0x57, 0x00, 0xDD, 0x01, // ŗÝ (U+0157 U+00DD)
  0x01, 0x57, 0x01, 0x74, 0x01, // ŗŴ (U+0157 U+0174)
  0x01, 0x57, 0x01, 0x76, 0x01, // ŗŶ (U+0157 U+0176)
  0x01, 0x57, 0x01, 0x78, 0x01, // ŗŸ (U+0157 U+0178)
  0x01, 0x57, 0x20, 0x1A, 0x03, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x03, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x03, // ŗ… (U+0157 U+2026)
  0x01, 0x58, 0x00, 0x56, 0x01, // ŘV (U+0158 U+0056)
  0x01, 0x58, 0x00, 0x57, 0x01, // ŘW (U+0158 U+0057)
  0x01, 0x58, 0x00, 0x59, 0x01, // ŘY (U+0158 U+0059)
  0x01, 0x58, 0x00, 0xDD, 0x01, // ŘÝ (U+0158 U+00DD)
  0x01, 0x58, 0x01, 0x74, 0x01, // ŘŴ (U+0158 U+0174)
  0x01, 0x58, 0x01, 0x76, 0x01, // ŘŶ (U+0158 U+0176)
  0x01, 0x58, 0x01, 0x78, 0x01, // ŘŸ (U+0158 U+0178)
  0x01, 0x59, 0x00, 0x2C, 0x03, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x03, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x56, 0x01, // řV (U+0159 U+0056)
  0x01, 0x59, 0x00, 0x57, 0x01, // řW (U+0159 U+0057)
  0x01, 0x59, 0x00, 0x58, 0x01, // řX (U+0159 U+0058)
  0x01, 0x59, 0x00, 0x59, 0x01, // řY (U+0159 U+0059)
  0x01, 0x59, 0x00, 0xDD, 0x01, // řÝ (U+0159 U+00DD)
  0x01, 0x59, 0x01, 0x74, 0x01, // řŴ (U+0159 U+0174)
  0x01, 0x59, 0x01, 0x76, 0x01, // řŶ (U+0159 U+0176)
  0x01, 0x59, 0x01, 0x78, 0x01, // řŸ (U+0159 U+0178)
  0x01, 0x59, 0x20, 0x1A, 0x03, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x03, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x03, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x56, 0x01, // śV (U+015B U+0056)
  0x01, 0x5B, 0x00, 0x57, 0x01, // śW (U+015B U+0057)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x74, 0x01, // śŴ (U+015B U+0174)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x56, 0x01, // ŝV (U+015D U+0056)
  0x01, 0x5D, 0x00, 0x57, 0x01, // ŝW (U+015D U+0057)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x74, 0x01, // ŝŴ (U+015D U+0174)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x56, 0x01, // şV (U+015F U+0056)
  0x01, 0x5F, 0x00, 0x57, 0x01, // şW (U+015F U+0057)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x74, 0x01, // şŴ (U+015F U+0174)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x56, 0x01, // šV (U+0161 U+0056)
  0x01, 0x61, 0x00, 0x57, 0x01, // šW (U+0161 U+0057)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x74, 0x01, // šŴ (U+0161 U+0174)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x01, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x01, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x01, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x69, 0x00, 0x22, 0x01, // ũ" (U+0169 U+0022)
  0x01, 0x69, 0x00, 0x27, 0x01, // ũ' (U+0169 U+0027)
  0x01, 0x69, 0x00, 0x56, 0x01, // ũV (U+0169 U+0056)
  0x01, 0x69, 0x00, 0x57, 0x01, // ũW (U+0169 U+0057)
  0x01, 0x69, 0x00, 0x59, 0x01, // ũY (U+0169 U+0059)
  0x01, 0x69, 0x00, 0xDD, 0x01, // ũÝ (U+0169 U+00DD)
  0x01, 0x69, 0x01, 0x74, 0x01, // ũŴ (U+0169 U+0174)
  0x01, 0x69, 0x01, 0x76, 0x01, // ũŶ (U+0169 U+0176)
  0x01, 0x69, 0x01, 0x78, 0x01, // ũŸ (U+0169 U+0178)
  0x01, 0x69, 0x20, 0x18, 0x01, // ũ‘ (U+0169 U+2018)
  0x01, 0x69, 0x20, 0x1C, 0x01, // ũ“ (U+0169 U+201C)
  0x01, 0x6B, 0x00, 0x22, 0x01, // ū" (U+016B U+0022)
  0x01, 0x6B, 0x00, 0x27, 0x01, // ū' (U+016B U+0027)
  0x01, 0x6B, 0x00, 0x56, 0x01, // ūV (U+016B U+0056)
  0x01, 0x6B, 0x00, 0x57, 0x01, // ūW (U+016B U+0057)
  0x01, 0x6B, 0x00, 0x59, 0x01, // ūY (U+016B U+0059)
  0x01, 0x6B, 0x00, 0xDD, 0x01, // ūÝ (U+016B U+00DD)
  0x01, 0x6B, 0x01, 0x74, 0x01, // ūŴ (U+016B U+0174)
  0x01, 0x6B, 0x01, 0x76, 0x01, // ūŶ (U+016B U+0176)
  0x01, 0x6B, 0x01, 0x78, 0x01, // ūŸ (U+016B U+0178)
  0x01, 0x6B, 0x20, 0x18, 0x01, // ū‘ (U+016B U+2018)
  0x01, 0x6B, 0x20, 0x1C, 0x01, // ū“ (U+016B U+201C)
  0x01, 0x6D, 0x00, 0x22, 0x01, // ŭ" (U+016D U+0022)
  0x01, 0x6D, 0x00, 0x27, 0x01, // ŭ' (U+016D U+0027)
  0x01, 0x6D, 0x00, 0x56, 0x01, // ŭV (U+016D U+0056)
  0x01, 0x6D, 0x00, 0x57, 0x01, // ŭW (U+016D U+0057)
  0x01, 0x6D, 0x00, 0x59, 0x01, // ŭY (U+016D U+0059)
  0x01, 0x6D, 0x00, 0xDD, 0x01, // ŭÝ (U+016D U+00DD)
  0x01, 0x6D, 0x01, 0x74, 0x01, // ŭŴ (U+016D U+0174)
  0x01, 0x6D, 0x01, 0x76, 0x01, // ŭŶ (U+016D U+0176)
  0x01, 0x6D, 0x01, 0x78, 0x01, // ŭŸ (U+016D U+0178)
  0x01, 0x6D, 0x20, 0x18, 0x01, // ŭ‘ (U+016D U+2018)
  0x01, 0x6D, 0x20, 0x1C, 0x01, // ŭ“ (U+016D U+201C)
  0x01, 0x6F, 0x00, 0x22, 0x01, // ů" (U+016F U+0022)
  0x01, 0x6F, 0x00, 0x27, 0x01, // ů' (U+016F U+0027)
  0x01, 0x6F, 0x00, 0x56, 0x01, // ůV (U+016F U+0056)
  0x01, 0x6F, 0x00, 0x57, 0x01, // ůW (U+016F U+0057)
  0x01, 0x6F, 0x00, 0x59, 0x01, // ůY (U+016F U+0059)
  0x01, 0x6F, 0x00, 0xDD, 0x01, // ůÝ (U+016F U+00DD)
  0x01, 0x6F, 0x01, 0x74, 0x01, // ůŴ (U+016F U+0174)
  0x01, 0x6F, 0x01, 0x76, 0x01, // ůŶ (U+016F U+0176)
  0x01, 0x6F, 0x01, 0x78, 0x01, // ůŸ (U+016F U+0178)
  0x01, 0x6F, 0x20, 0x18, 0x01, // ů‘ (U+016F U+2018)
  0x01, 0x6F, 0x20, 0x1C, 0x01, // ů“ (U+016F U+201C)
  0x01, 0x71, 0x00, 0x22, 0x01, // ű" (U+0171 U+0022)
  0x01, 0x71, 0x00, 0x27, 0x01, // ű' (U+0171 U+0027)
  0x01, 0x71, 0x00, 0x56, 0x01, // űV (U+0171 U+0056)
  0x01, 0x71, 0x00, 0x57, 0x01, // űW (U+0171 U+0057)
  0x01, 0x71, 0x00, 0x59, 0x01, // űY (U+0171 U+0059)
  0x01, 0x71, 0x00, 0xDD, 0x01, // űÝ (U+0171 U+00DD)
  0x01, 0x71, 0x01, 0x74, 0x01, // űŴ (U+0171 U+0174)
  0x01, 0x71, 0x01, 0x76, 0x01, // űŶ (U+0171 U+0176)
  0x01, 0x71, 0x01, 0x78, 0x01, // űŸ (U+0171 U+0178)
  0x01, 0x71, 0x20, 0x18, 0x01, // ű‘ (U+0171 U+2018)
  0x01, 0x71, 0x20, 0x1C, 0x01, // ű“ (U+0171 U+201C)
  0x01, 0x73, 0x00, 0x22, 0x01, // ų" (U+0173 U+0022)
  0x01, 0x73, 0x00, 0x27, 0x01, // ų' (U+0173 U+0027)
  0x01, 0x73, 0x00, 0x56, 0x01, // ųV (U+0173 U+0056)
  0x01, 0x73, 0x00, 0x57, 0x01, // ųW (U+0173 U+0057)
  0x01, 0x73, 0x00, 0x59, 0x01, // ųY (U+0173 U+0059)
  0x01, 0x73, 0x00, 0xDD, 0x01, // ųÝ (U+0173 U+00DD)
  0x01, 0x73, 0x01, 0x74, 0x01, // ųŴ (U+0173 U+0174)
  0x01, 0x73, 0x01, 0x76, 0x01, // ųŶ (U+0173 U+0176)
  0x01, 0x73, 0x01, 0x78, 0x01, // ųŸ (U+0173 U+0178)
  0x01, 0x73, 0x20, 0x18, 0x01, // ų‘ (U+0173 U+2018)
  0x01, 0x73, 0x20, 0x1C, 0x01, // ų“ (U+0173 U+201C)
  0x01, 0x74, 0x00, 0x26, 0x01, // Ŵ& (U+0174 U+0026)
  0x01, 0x74, 0x00, 0x2C, 0x02, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x02, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x02, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x01, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x01, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x20, 0x1A, 0x02, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x02, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x02, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x00, 0x59, 0x01, // ŵY (U+0175 U+0059)
  0x01, 0x75, 0x00, 0xDD, 0x01, // ŵÝ (U+0175 U+00DD)
  0x01, 0x75, 0x01, 0x76, 0x01, // ŵŶ (U+0175 U+0176)
  0x01, 0x75, 0x01, 0x78, 0x01, // ŵŸ (U+0175 U+0178)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x02, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x02, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x7A, 0x00, 0x56, 0x01, // źV (U+017A U+0056)
  0x01, 0x7A, 0x00, 0x57, 0x01, // źW (U+017A U+0057)
  0x01, 0x7A, 0x00, 0x59, 0x01, // źY (U+017A U+0059)
  0x01, 0x7A, 0x00, 0xDD, 0x01, // źÝ (U+017A U+00DD)
  0x01, 0x7A, 0x01, 0x74, 0x01, // źŴ (U+017A U+0174)
  0x01, 0x7A, 0x01, 0x76, 0x01, // źŶ (U+017A U+0176)
  0x01, 0x7A, 0x01, 0x78, 0x01, // źŸ (U+017A U+0178)
  0x01, 0x7C, 0x00, 0x56, 0x01, // żV (U+017C U+0056)
  0x01, 0x7C, 0x00, 0x57, 0x01, // żW (U+017C U+0057)
  0x01, 0x7C, 0x00, 0x59, 0x01, // żY (U+017C U+0059)
  0x01, 0x7C, 0x00, 0xDD, 0x01, // żÝ (U+017C U+00DD)
  0x01, 0x7C, 0x01, 0x74, 0x01, // żŴ (U+017C U+0174)
  0x01, 0x7C, 0x01, 0x76, 0x01, // żŶ (U+017C U+0176)
  0x01, 0x7C, 0x01, 0x78, 0x01, // żŸ (U+017C U+0178)
  0x01, 0x7E, 0x00, 0x56, 0x01, // žV (U+017E U+0056)
  0x01, 0x7E, 0x00, 0x57, 0x01, // žW (U+017E U+0057)
  0x01, 0x7E, 0x00, 0x59, 0x01, // žY (U+017E U+0059)
  0x01, 0x7E, 0x00, 0xDD, 0x01, // žÝ (U+017E U+00DD)
  0x01, 0x7E, 0x01, 0x74, 0x01, // žŴ (U+017E U+0174)
  0x01, 0x7E, 0x01, 0x76, 0x01, // žŶ (U+017E U+0176)
  0x01, 0x7E, 0x01, 0x78, 0x01, // žŸ (U+017E U+0178)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x03, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x03, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x02, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x03, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x03, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x02, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x28, 0x19, 0xF4, 0x28, 0x1B, 0xF1, 0x20, 0xD0, 0xC3, 0x90, 0x82, 0x81, 0x3F, 0x32, 0x05, 0x0E,
  0x30, 0x70, 0xB3, 0x0A, 0x07, 0x30, 0xC0, 0x23, 0x05, 0x71, 0x0C, 0x0E, 0x30, 0x0C, 0x30,
  // """ (U+0022)
  0x6F, 0x46, 0xF3, 0x7D, 0x07, 0xD0, 0x98, 0x09, 0x80, 0xB2, 0x0B, 0x20,
  // "#" (U+0023)
  0x48, 0x3A, 0x40, 0x95, 0x40, 0xD2, 0x0D, 0x01, 0x38, 0x35, 0x90, 0x3B, 0x28, 0x65, 0xDF, 0xDD,
  0xFE, 0xB3, 0x0E, 0x20, 0xD0, 0x13, 0x83, 0x3B, 0x01, 0xD4, 0x83, 0x77, 0x05, 0x94, 0x83, 0xA3,
  0x08, 0x62, 0x86, 0x6D, 0xFD, 0xDF, 0xDB, 0x28, 0x34, 0xA0, 0x2C, 0x48, 0x38, 0x60, 0x68, 0x48,
  0x3C, 0x20, 0xA4, 0x40, 0xE2, 0x0D, 0x40,
  // "$" (U+0024)
  0x50, 0x10, 0xA6, 0x82, 0x59, 0xC5, 0x48, 0x4B, 0xDB, 0x9F, 0x72, 0x85, 0x6F, 0x2A, 0x1C, 0xA2,
  0x85, 0x9E, 0x0B, 0x05, 0x12, 0x82, 0x8F, 0x3A, 0x58, 0x23, 0xFE, 0x86, 0x82, 0x4E, 0xF7, 0x68,
  0x2B, 0xAF, 0x52, 0x06, 0x28, 0xA4, 0xB0, 0xE9, 0x05, 0xF0, 0x29, 0x0E, 0x90, 0x5F, 0x55, 0x65,
  0xF4, 0x28, 0x4C, 0xEC, 0xCE, 0x64, 0x82, 0x3D, 0x41, 0x60, 0xB7, 0x01, 0x04, 0x50,
  // "%" (U+0025)
  0x00, 0x9D, 0xC1, 0x00, 0x07, 0x90, 0x00, 0xAA, 0x0B, 0x80, 0x02, 0xD1, 0x00, 0x2F, 0x20, 0x9B,
  0x00, 0xB5, 0x00, 0x07, 0xD0, 0x0A, 0x90, 0x5B, 0x00, 0x00, 0xAA, 0x00, 0xE6, 0x1D, 0x20, 0x00,
  0x0A, 0x90, 0x3F, 0x19, 0x71, 0xAD, 0x90, 0x8B, 0x0C, 0x84, 0xD0, 0xD7, 0x0E, 0x41, 0xBD, 0x80,
  0xD3, 0x5E, 0x00, 0xD6, 0x00, 0x00, 0x89, 0x0B, 0x90, 0x0E, 0x50, 0x00, 0x2E, 0x10, 0xD6, 0x02,
  0xF3, 0x00, 0x0B, 0x50, 0x0E, 0x40, 0x7C, 0x00, 0x06, 0xB0, 0x00, 0xC6, 0x1E, 0x50, 0x01, 0xE2,
  0x00, 0x04, 0xDD, 0x60, 0x00,
  // "&" (U+0026)
  0x48, 0x35, 0xCD, 0xD7, 0x68, 0x54, 0xF6, 0x05, 0xF3, 0x50, 0x89, 0x28, 0x11, 0xF4, 0x50, 0x89,
  0x28, 0x15, 0xE1, 0x58, 0x45, 0xF3, 0x5C, 0x36, 0x82, 0x5F, 0xE5, 0x28, 0x94, 0xDE, 0xC0, 0x1B,
  0xD9, 0xF6, 0x02, 0xF5, 0x28, 0x7C, 0xE1, 0x0C, 0xE1, 0x6A, 0x28, 0x13, 0xF7, 0x28, 0x33, 0xF8,
  0xC3, 0x28, 0x15, 0xF4, 0x38, 0x1A, 0xFB, 0x38, 0x14, 0xF6, 0x38, 0x13, 0xFC, 0x48, 0x7D, 0xC1,
  0x03, 0xCA, 0xF7, 0x38, 0x90, 0x2B, 0xED, 0xA2, 0x0E, 0xFC, 0x10,
  // "'" (U+0027)
  0x6F, 0x38, 0xD0, 0x97, 0x0B, 0x20,
  // "(" (U+0028)
  0x50, 0x10, 0x54, 0x81, 0x4D, 0x43, 0x81, 0x4E, 0x33, 0x81, 0x2E, 0x74, 0x0A, 0x0D, 0x48, 0x12,
  0xF7, 0x48, 0x18, 0xF2, 0x40, 0xC0, 0xD5, 0x90, 0xA4, 0x81, 0x2F, 0x74, 0x81, 0x3F, 0x64, 0x81,
  0x3F, 0x54, 0x81, 0x1F, 0x65, 0x0C, 0x09, 0x50, 0x60, 0xD6, 0x09, 0x08, 0x60, 0x13,
  // ")" (U+0029)
  0x30, 0x26, 0x06, 0x0C, 0x60, 0xC0, 0x85, 0x07, 0x0E, 0x58, 0x15, 0xF2, 0x48, 0x14, 0xF4, 0x48,
  0x15, 0xF3, 0x48, 0x17, 0xF2, 0x40, 0xA9, 0x50, 0xD0, 0xC4, 0x81, 0x3F, 0x74, 0x81, 0x8F, 0x13,
  0x81, 0x1E, 0x94, 0x81, 0x9E, 0x13, 0x81, 0x4E, 0x33, 0x81, 0x5C, 0x24, 0x03, 0x60,
  // "*" (U+002A)
  0x00, 0x06, 0x50, 0x02, 0xC0, 0xA6, 0x00, 0x2C, 0xAA, 0x27, 0x62, 0x4C, 0xED, 0xB6, 0xCD, 0x9C,
  0xB2, 0x02, 0x07, 0x67, 0xE1, 0x00, 0xD6, 0x04, 0x00, 0x01, 0x10, 0x00,
  // "+" (U+002B)
  0x20, 0x20, 0xD5, 0x02, 0x0D, 0x50, 0x20, 0xD5, 0x02, 0x0D, 0x38, 0x5C, 0xDD, 0xFD, 0xD9, 0x20,
  0x20, 0xD5, 0x02, 0x0D, 0x50, 0x20, 0xD3,
  // "," (U+002C)
  0x06, 0xE3, 0x08, 0xF7, 0x00, 0xD5, 0x03, 0xC0, 0x49, 0x10,
  // "-" (U+002D)
  0x6D, 0xDD, 0x70,
  // "." (U+002E)
  0x01, 0x05, 0xF7, 0x5E, 0x40,
  // "/" (U+002F)
  0x70, 0xD0, 0x26, 0x04, 0x0B, 0x70, 0xB0, 0x46, 0x02, 0x0D, 0x70, 0x90, 0x66, 0x01, 0x0E, 0x70,
  0x70, 0x87, 0x0D, 0x02, 0x60, 0x50, 0xB7, 0x0B, 0x04, 0x60, 0x20, 0xD7, 0x09, 0x06, 0x60, 0x10,
  0xD7, 0x07, 0x08, 0x70, 0xD0, 0x26, 0x04, 0x0A, 0x70,
  // "0" (U+0030)
  0x00, 0x02, 0xAD, 0xD4, 0x00, 0x01, 0xD7, 0x06, 0xF2, 0x00, 0x9C, 0x00, 0x0F, 0x70, 0x1F, 0x60,
  0x00, 0xE9, 0x07, 0xF1, 0x00, 0x0F, 0x90, 0xBD, 0x00, 0x01, 0xF7, 0x0E, 0xA0, 0x00, 0x3F, 0x51,
  0xF8, 0x00, 0x06, 0xF2, 0x2F, 0x70, 0x00, 0xAD, 0x02, 0xF6, 0x00, 0x0E, 0x70, 0x0F, 0x70, 0x05,
  0xE1, 0x00, 0x9C, 0x02, 0xD6, 0x00, 0x01, 0xAE, 0xD5, 0x00, 0x00,
  // "1" (U+0031)
  0x50, 0x99, 0x38, 0x23, 0xBE, 0xC2, 0x83, 0xAD, 0x3F, 0x92, 0x83, 0x10, 0x4F, 0x64, 0x81, 0x7F,
  0x24, 0x0A, 0x0E, 0x50, 0xE0, 0xB4, 0x81, 0x1F, 0x84, 0x81, 0x5F, 0x54, 0x81, 0x8F, 0x14, 0x0B,
  0x0E, 0x48, 0x12, 0xFC, 0x20, 0x30, 0xDB, 0x0E, 0x07,
  // "2" (U+0032)
  0x38, 0x38, 0xDD, 0xD5, 0x38, 0x59, 0xE3, 0x09, 0xF2, 0x20, 0xE0, 0x82, 0x81, 0x5F, 0x52, 0x06,
  0x03, 0x28, 0x16, 0xF4, 0x60, 0xA0, 0xE6, 0x81, 0x3F, 0x65, 0x81, 0x1D, 0xA6, 0x0C, 0x0B, 0x60,
  0x0B, 0x60, 0xB0, 0xC6, 0x81, 0xBD, 0x12, 0x84, 0x42, 0x0A, 0xD1, 0x38, 0x90, 0xD1, 0x0F, 0xED,
  0xDD, 0xEB, 0x20,
  // "3" (U+0033)
  0x38, 0x37, 0xDD, 0xD5, 0x38, 0x58, 0xF3, 0x08, 0xF3, 0x20, 0xD0, 0xA2, 0x81, 0x4F, 0x62, 0x05,
  0x03, 0x28, 0x15, 0xF5, 0x60, 0xB0, 0xD5, 0x82, 0x19, 0xD3, 0x48, 0x2D, 0xFC, 0x26, 0x82, 0x2C,
  0xE1, 0x68, 0x15, 0xF6, 0x68, 0x44, 0xF6, 0x09, 0x63, 0x84, 0x8F, 0x20, 0xDC, 0x28, 0x14, 0xF9,
  0x28, 0x43, 0xCE, 0xDC, 0x53,
  // "4" (U+0034)
  0x68, 0x1B, 0xF2, 0x58, 0x17, 0xEE, 0x58, 0x24, 0xBD, 0xB4, 0x83, 0x1D, 0x3F, 0x84, 0x83, 0xC3,
  0x5F, 0x43, 0x84, 0x96, 0x08, 0xF1, 0x20, 0x50, 0x92, 0x0C, 0x0D, 0x20, 0x20, 0xB3, 0x90, 0x92,
  0x0C, 0x80, 0x0E, 0xA0, 0xE0, 0x44, 0x81, 0x6F, 0x36, 0x09, 0x96, 0x81, 0x1D, 0xE5, 0x0B, 0xB0,
  0xE0, 0x31,
  // "5" (U+0035)
  0x38, 0x49, 0xDD, 0xDE, 0xA3, 0x0A, 0x30, 0x50, 0x72, 0x03, 0x08, 0x30, 0x01, 0x20, 0x80, 0x47,
  0x0C, 0x78, 0x41, 0xEC, 0xDB, 0x33, 0x85, 0x13, 0x01, 0xCE, 0x16, 0x81, 0x5F, 0x66, 0x81, 0x3F,
  0x76, 0x84, 0x5F, 0x50, 0x88, 0x38, 0x91, 0x9E, 0x10, 0xAD, 0x10, 0x5F, 0x52, 0x84, 0x2B, 0xED,
  0xB4, 0x30,
  // "6" (U+0036)
  0x00, 0x03, 0xBD, 0xE7, 0x00, 0x5E, 0x40, 0x9F, 0x02, 0xF6, 0x00, 0x59, 0x0A, 0xD0, 0x00, 0x00,
  0x1F, 0x80, 0x00, 0x00, 0x6F, 0x7B, 0xDA, 0x10, 0xAF, 0x80, 0x2F, 0x90, 0xCD, 0x00, 0x0B, 0xD0,
  0xDA, 0x00, 0x0B, 0xD0, 0xDA, 0x00, 0x0D, 0xB0, 0xBB, 0x00, 0x2F, 0x70, 0x6F, 0x20, 0xBD, 0x00,
  0x08, 0xED, 0xA1, 0x00,
  // "7" (U+0037)
  0x18, 0x90, 0x9E, 0xDD, 0xDE, 0xF5, 0x0B, 0x48, 0x3D, 0xD0, 0x17, 0x38, 0x15, 0xF5, 0x60, 0xD0,
  0xC6, 0x81, 0x5F, 0x46, 0x0D, 0x0C, 0x68, 0x16, 0xF4, 0x60, 0xD0, 0xC6, 0x81, 0x6F, 0x46, 0x0D,
  0x0B, 0x68, 0x16, 0xF3, 0x60, 0xD0, 0xB6, 0x81, 0x6F, 0x36,
  // "8" (U+0038)
  0x00, 0x05, 0xCD, 0xD8, 0x00, 0x05, 0xF6, 0x02, 0xF7, 0x00, 0xCC, 0x00, 0x0C, 0xA0, 0x0E, 0xA0,
  0x00, 0xD8, 0x00, 0xCE, 0x00, 0x5E, 0x20, 0x04, 0xFB, 0x7C, 0x20, 0x00, 0x1C, 0xFF, 0x50, 0x00,
  0x6D, 0x41, 0xCF, 0x40, 0x4F, 0x40, 0x01, 0xFA, 0x09, 0xF0, 0x00, 0x0D, 0xB0, 0x9E, 0x00, 0x00,
  0xE9, 0x04, 0xF6, 0x00, 0x9E, 0x20, 0x05, 0xCD, 0xDA, 0x20, 0x00,
  // "9" (U+0039)
  0x38, 0x33, 0xBD, 0xD4, 0x38, 0x54, 0xF6, 0x07, 0xF1, 0x20, 0xE0, 0xB2, 0x85, 0x1F, 0x60, 0x5F,
  0x52, 0x85, 0x1F, 0x70, 0x7F, 0x22, 0x85, 0x2F, 0x60, 0x7F, 0x22, 0x89, 0x26, 0xF4, 0x03, 0xF7,
  0x04, 0xEF, 0x12, 0x84, 0x6D, 0xD7, 0xDC, 0x68, 0x12, 0xF7, 0x68, 0x48, 0xE1, 0x01, 0x72, 0x81,
  0x1E, 0x72, 0x84, 0x4E, 0x10, 0xAB, 0x48, 0x2B, 0xED, 0x84,
  // ":" (U+003A)
  0x28, 0x18, 0xE2, 0x28, 0x1B, 0xE1, 0x30, 0x17, 0x77, 0x10, 0x13, 0x81, 0x3F, 0x82, 0x81, 0x4E,
  0x52,
  // ";" (U+003B)
  0x38, 0x18, 0xE2, 0x38, 0x1B, 0xE1, 0x40, 0x17, 0x77, 0x58, 0x12, 0xC5, 0x38, 0x15, 0xFB, 0x40,
  0x0A, 0x40, 0xB0, 0x32, 0x81, 0x1B, 0x43,
  // "<" (U+003C)
  0x50, 0x20, 0x74, 0x81, 0x8E, 0x52, 0x87, 0x4D, 0xA1, 0x01, 0x9D, 0x43, 0x81, 0xDD, 0x14, 0x82,
  0x2B, 0xC3, 0x58, 0x16, 0xE8, 0x58, 0x21, 0xAD, 0x45, 0x04, 0x08,
  // "=" (U+003D)
  0x0C, 0x80, 0x1D, 0x09, 0x77, 0x70, 0xC8, 0x01, 0xD0, 0x90,
  // ">" (U+003E)
  0x08, 0x01, 0x58, 0x18, 0xE5, 0x58, 0x23, 0xCB, 0x25, 0x81, 0x7E, 0x75, 0x81, 0x3F, 0x93, 0x87,
  0x5E, 0x91, 0x01, 0xBC, 0x32, 0x81, 0x6E, 0x74, 0x0A, 0x02, 0x50,
  // "?" (U+003F)
  0x18, 0x95, 0x7D, 0xDD, 0x50, 0x7F, 0x30, 0x9F, 0x2B, 0xA2, 0x83, 0x4F, 0x52, 0x32, 0x81, 0x6F,
  0x54, 0x0B, 0x0E, 0x48, 0x18, 0xF4, 0x28, 0x23, 0xBC, 0x33, 0x0A, 0x08, 0x50, 0xC0, 0x35, 0x05,
  0x60, 0x15, 0x81, 0xBF, 0x14, 0x0B, 0x0C, 0x50,
  // "@" (U+0040)
  0x48, 0x53, 0xAD, 0xDD, 0xA3, 0x58, 0x19, 0xD5, 0x38, 0x15, 0xE5, 0x30, 0x0B, 0x68, 0x43, 0xE1,
  0x06, 0xD2, 0x8C, 0x57, 0xDD, 0xA9, 0x0B, 0x60, 0xE5, 0x09, 0xE2, 0x0E, 0x70, 0x89, 0x6D, 0x02,
  0xF5, 0x01, 0xF3, 0x07, 0xAA, 0x90, 0x8E, 0x28, 0x91, 0x4F, 0x10, 0x89, 0xC6, 0x0B, 0xB2, 0x07,
  0x0D, 0x28, 0x5A, 0x6E, 0x50, 0xCA, 0x20, 0x0B, 0x28, 0xB0, 0xE1, 0xD5, 0x09, 0xD1, 0x5B, 0xD0,
  0x99, 0x0C, 0x70, 0x1B, 0xE9, 0x09, 0xE9, 0x20, 0x70, 0xC7, 0x48, 0x11, 0xE5, 0x60, 0x24, 0x82,
  0x4E, 0x81, 0x28, 0x13, 0x99, 0x58, 0x52, 0x8C, 0xDD, 0x93, 0x40,
  // "A" (U+0041)
  0x78, 0x18, 0xF2, 0x71, 0x82, 0x1E, 0xF4, 0x71, 0x82, 0x89, 0xF6, 0x78, 0x31, 0xD3, 0xF7, 0x78,
  0x39, 0x71, 0xF9, 0x60, 0x20, 0xE2, 0x90, 0xA6, 0x0A, 0x07, 0x20, 0xE0, 0xC5, 0x03, 0x0E, 0x30,
  0x0D, 0x50, 0xB8, 0x00, 0xEA, 0x40, 0x40, 0xE4, 0x81, 0xAF, 0x13, 0x0C, 0x05, 0x48, 0x18, 0xF2,
  0x20, 0x69, 0x58, 0x3A, 0xF5, 0x0A, 0xA8, 0x3E, 0x10, 0x1E, 0xB0, 0x30,
  // "B" (U+0042)
  0x30, 0x9A, 0x83, 0xED, 0xD9, 0x14, 0x85, 0x8F, 0x30, 0x4F, 0xB4, 0x0A, 0x93, 0x0D, 0x94, 0x00,
  0xD3, 0x0D, 0x93, 0x81, 0x1F, 0xA2, 0x81, 0x1F, 0xB3, 0x86, 0x4F, 0x70, 0x1B, 0xD2, 0x38, 0x57,
  0xFE, 0xEF, 0xD1, 0x40, 0xB9, 0x28, 0x12, 0xEC, 0x40, 0xE0, 0xC3, 0x81, 0x9F, 0x32, 0x81, 0x2F,
  0x93, 0x81, 0xAF, 0x32, 0x81, 0x5F, 0x63, 0x0D, 0x0E, 0x38, 0x1B, 0xF2, 0x28, 0x39, 0xF7, 0x03,
  0xB8, 0x3D, 0xDE, 0xB4, 0x20,
  // "C" (U+0043)
  0x38, 0x41, 0x7C, 0xDE, 0x93, 0x89, 0x23, 0xDA, 0x10, 0x8F, 0x60, 0x1E, 0xB3, 0x85, 0x3F, 0x50,
  0xBF, 0x24, 0x83, 0x30, 0x3F, 0xA7, 0x81, 0x9F, 0x57, 0x81, 0xCF, 0x17, 0x90, 0xE7, 0x19, 0x0C,
  0x71, 0x0E, 0x0D, 0x71, 0x81, 0xBF, 0x14, 0x02, 0x28, 0x63, 0xFA, 0x10, 0x19, 0x53, 0x84, 0x3B,
  0xED, 0xC6, 0x30,
  // "D" (U+0044)
  0x30, 0x9A, 0x83, 0xED, 0xEB, 0x36, 0x86, 0x8F, 0x30, 0x1B, 0xF3, 0x50, 0xA9, 0x38, 0x11, 0xFB,
  0x50, 0xD0, 0xC4, 0x0D, 0x94, 0x81, 0x1F, 0x94, 0x81, 0xBF, 0x13, 0x81, 0x4F, 0x64, 0x81, 0xCF,
  0x13, 0x81, 0x7F, 0x34, 0x0D, 0x94, 0x0A, 0x94, 0x81, 0x1F, 0xC4, 0x0E, 0x0C, 0x48, 0x16, 0xF7,
  0x38, 0x11, 0xF8, 0x48, 0x1D, 0xE1, 0x38, 0x15, 0xF5, 0x38, 0x18, 0xF6, 0x48, 0x69, 0xF2, 0x01,
  0x9F, 0x73, 0x02, 0x0C, 0xA8, 0x3D, 0xEE, 0xA3, 0x40,
  // "E" (U+0045)
  0x30, 0x8A, 0x84, 0xCB, 0xBD, 0xF3, 0x48, 0x18, 0xF3, 0x20, 0x29, 0x50, 0xA9, 0x30, 0x10, 0xD5,
  0x00, 0xD4, 0x03, 0x48, 0x11, 0xFA, 0x72, 0x81, 0x4F, 0x77, 0x28, 0x17, 0xFE, 0x0F, 0xD6, 0x0B,
  0x97, 0x30, 0xE0, 0xC7, 0x28, 0x12, 0xF9, 0x72, 0x81, 0x5F, 0x63, 0x03, 0x0B, 0x48, 0x19, 0xF3,
  0x30, 0xB0, 0x72, 0x02, 0x0D, 0xA0, 0xFB, 0x81, 0xDF, 0x32,
  // "F" (U+0046)
  0x30, 0x9A, 0x81, 0xED, 0xDA, 0x03, 0x48, 0x18, 0xF3, 0x20, 0x39, 0x50, 0x99, 0x30, 0x10, 0xD5,
  0x0D, 0x0C, 0x40, 0x24, 0x81, 0x1F, 0x97, 0x28, 0x14, 0xF5, 0x72, 0x84, 0x7F, 0xDD, 0xDC, 0x60,
  0xB0, 0xE7, 0x30, 0xE0, 0xB7, 0x28, 0x12, 0xF8, 0x72, 0x81, 0x5F, 0x57, 0x28, 0x1B, 0xF4, 0x70,
  0x30, 0xEB, 0x09, 0x60,
  // "G" (U+0047)
  0x48, 0x47, 0xCD, 0xEC, 0x53, 0x89, 0x32, 0xDB, 0x20, 0x2E, 0xF1, 0x02, 0xEB, 0x48, 0x59, 0xE1,
  0x0B, 0xF2, 0x40, 0x12, 0x81, 0x3F, 0x97, 0x18, 0x19, 0xF4, 0x71, 0x0D, 0x97, 0x29, 0x0D, 0x38,
  0x63, 0xEE, 0xEE, 0x1F, 0xC4, 0x85, 0x2F, 0xC1, 0x0E, 0xD4, 0x81, 0x3F, 0x72, 0x81, 0xAF, 0x13,
  0x81, 0x6F, 0x42, 0x82, 0x3F, 0xB1, 0x20, 0xB9, 0x48, 0x53, 0xAE, 0xDD, 0xA5, 0x30,
  // "H" (U+0048)
  0x30, 0x9B, 0x82, 0xD0, 0x1E, 0xB0, 0x74, 0x81, 0x8F, 0x74, 0x81, 0xEE, 0x15, 0x81, 0xAF, 0x14,
  0x90, 0x96, 0x00, 0xD4, 0x81, 0x3F, 0x65, 0x81, 0x1F, 0xA4, 0x81, 0x7F, 0x35, 0x81, 0x4F, 0x74,
  0x0A, 0x96, 0x87, 0x7F, 0xED, 0xDD, 0xDF, 0xC6, 0x0B, 0x94, 0x81, 0x1F, 0x86, 0x0E, 0x0C, 0x48,
  0x14, 0xF5, 0x58, 0x12, 0xF9, 0x48, 0x18, 0xF2, 0x58, 0x15, 0xF5, 0x40, 0xB0, 0xE6, 0x81, 0xBF,
  0x33, 0x81, 0x2F, 0xC4, 0x03, 0x0E, 0xB8, 0x15, 0x09, 0xB0, 0xD3,
  // "I" (U+0049)
  0x30, 0x9B, 0x0D, 0x48, 0x18, 0xF6, 0x58, 0x19, 0xF1, 0x50, 0x0D, 0x58, 0x11, 0xF9, 0x58, 0x14,
  0xF6, 0x58, 0x17, 0xF3, 0x50, 0xB9, 0x60, 0xE0, 0xC5, 0x81, 0x2F, 0x85, 0x81, 0x5F, 0x55, 0x81,
  0xBF, 0x33, 0x03, 0x0E, 0xB0, 0x52,
  // "J" (U+004A)
  0x50, 0xAB, 0x0C, 0x68, 0x19, 0xF5, 0x70, 0xB9, 0x71, 0x0E, 0x0C, 0x78, 0x12, 0xF8, 0x78, 0x15,
  0xF5, 0x78, 0x19, 0xF2, 0x70, 0xC0, 0xE7, 0x19, 0x0A, 0x78, 0x13, 0xF7, 0x78, 0x17, 0xF4, 0x70,
  0xA9, 0x71, 0x0D, 0x0C, 0x78, 0x11, 0xF8, 0x78, 0x16, 0xF3, 0x68, 0x12, 0xEB, 0x58, 0x25, 0xDD,
  0x86,
  // "K" (U+004B)
  0x30, 0x9B, 0x81, 0xD0, 0x5B, 0x02, 0x48, 0x18, 0xF6, 0x38, 0x1D, 0xB1, 0x58, 0x19, 0xF1, 0x20,
  0x80, 0xB7, 0x00, 0xD2, 0x07, 0x0B, 0x78, 0x41, 0xF9, 0x06, 0xB7, 0x18, 0x34, 0xF6, 0x6D, 0x72,
  0x81, 0x7F, 0x8A, 0x01, 0x71, 0x84, 0xBF, 0x96, 0xF6, 0x71, 0x84, 0xEC, 0x01, 0xFC, 0x78, 0x12,
  0xF8, 0x28, 0x1B, 0xF1, 0x68, 0x15, 0xF5, 0x28, 0x16, 0xF7, 0x68, 0x1B, 0xF3, 0x28, 0x11, 0xFD,
  0x40, 0x30, 0xEB, 0x05, 0x28, 0x16, 0xED, 0x30,
  // "L" (U+004C)
  0x30, 0x9B, 0x0D, 0x68, 0x18, 0xF6, 0x70, 0x99, 0x71, 0x00, 0xD7, 0x81, 0x1F, 0x97, 0x81, 0x4F,
  0x67, 0x81, 0x7F, 0x37, 0x0B, 0x97, 0x10, 0xE0, 0xC7, 0x81, 0x2F, 0x94, 0x0C, 0x28, 0x15, 0xF5,
  0x30, 0x40, 0xA2, 0x81, 0xBF, 0x23, 0x82, 0xC6, 0x3E, 0xA0, 0xFD, 0x81, 0xEF, 0x30,
  // "M" (U+004D)
  0x30, 0x9B, 0x01, 0x40, 0x10, 0xEA, 0x0A, 0x48, 0x28, 0xEF, 0x24, 0x82, 0x8E, 0xF3, 0x58, 0x29,
  0xAF, 0x43, 0x82, 0x1D, 0xCD, 0x68, 0x2D, 0x5F, 0x53, 0x82, 0x96, 0xFA, 0x58, 0x31, 0xD2, 0xF7,
  0x28, 0x31, 0xD3, 0xF6, 0x58, 0x34, 0xA1, 0xF8, 0x28, 0x39, 0x56, 0xF3, 0x58, 0x90, 0x77, 0x0F,
  0x90, 0x2C, 0x09, 0x96, 0x89, 0x1B, 0x30, 0xDB, 0x09, 0x50, 0xDC, 0x60, 0xE2, 0x86, 0xCC, 0x2C,
  0x01, 0xF9, 0x50, 0x20, 0xC2, 0x86, 0xAE, 0xA4, 0x04, 0xF5, 0x50, 0x50, 0x92, 0x81, 0x9F, 0xC2,
  0x81, 0x7F, 0x25, 0x0A, 0x08, 0x28, 0x17, 0xF4, 0x20, 0xC9, 0x40, 0x30, 0xEA, 0x85, 0x80, 0x5B,
  0x01, 0xEA, 0x0E, 0x02, 0x20,
  // "N" (U+004E)
  0x30, 0x9A, 0x07, 0x30, 0x9A, 0x0E, 0x03, 0x48, 0x18, 0xFC, 0x40, 0x80, 0xB6, 0x82, 0x9D, 0xF2,
  0x30, 0xA0, 0x56, 0x82, 0xD4, 0xF7, 0x30, 0xD0, 0x25, 0x83, 0x1D, 0x0D, 0xC2, 0x01, 0x0E, 0x68,
  0x74, 0xA0, 0x8F, 0x20, 0x4B, 0x68, 0x77, 0x70, 0x2F, 0x70, 0x77, 0x60, 0xB0, 0x32, 0x83, 0xDD,
  0x0A, 0x46, 0x0E, 0x38, 0x37, 0xF2, 0xD1, 0x50, 0x20, 0xC3, 0x82, 0x2F, 0x9D, 0x60, 0x50, 0x94,
  0x81, 0xCF, 0xA6, 0x0B, 0x08, 0x48, 0x17, 0xF6, 0x40, 0x30, 0xEA, 0x08, 0x38, 0x11, 0xF3, 0x40,
  // "O" (U+004F)
  0x38, 0x41, 0x9D, 0xED, 0x64, 0x81, 0x3E, 0x92, 0x81, 0x5F, 0x72, 0x81, 0x1E, 0xA4, 0x85, 0xAF,
  0x10, 0xAF, 0x14, 0x84, 0x7F, 0x42, 0xFA, 0x58, 0x47, 0xF5, 0x8F, 0x55, 0x84, 0x8F, 0x5D, 0xF1,
  0x58, 0x3B, 0xF2, 0xFE, 0x68, 0x3E, 0xE0, 0xFC, 0x58, 0x44, 0xF8, 0x0E, 0xD5, 0x85, 0xBE, 0x10,
  0xAF, 0x13, 0x81, 0x4F, 0x62, 0x81, 0x2E, 0xA2, 0x81, 0x4E, 0x84, 0x84, 0x2B, 0xED, 0xB4, 0x40,
  // "P" (U+0050)
  0x30, 0x9A, 0x82, 0xEE, 0xD6, 0x58, 0x58, 0xF4, 0x06, 0xF6, 0x48, 0x19, 0xF1, 0x20, 0xE0, 0xC4,
  0x00, 0xD3, 0x00, 0xD3, 0x81, 0x1F, 0xA3, 0x0E, 0x0B, 0x38, 0x14, 0xF6, 0x28, 0x15, 0xF7, 0x38,
  0x57, 0xF3, 0x05, 0xEC, 0x48, 0x4B, 0xFD, 0xDC, 0x75, 0x0E, 0x0C, 0x71, 0x81, 0x2F, 0x87, 0x18,
  0x15, 0xF5, 0x71, 0x81, 0xBF, 0x36, 0x03, 0x0E, 0xB0, 0x95,
  // "Q" (U+0051)
  0x38, 0x41, 0x8D, 0xED, 0x64, 0x81, 0x3E, 0x92, 0x81, 0x5F, 0x72, 0x81, 0x1E, 0xA4, 0x0A, 0x92,
  0x81, 0xAF, 0x24, 0x84, 0x7F, 0x42, 0xFA, 0x58, 0x47, 0xF5, 0x7F, 0x55, 0x84, 0x8F, 0x4C, 0xF1,
  0x58, 0x3B, 0xF3, 0xFE, 0x68, 0x3E, 0xE0, 0xFC, 0x58, 0x44, 0xF9, 0x0E, 0xD5, 0x85, 0xBF, 0x20,
  0xBF, 0x13, 0x81, 0x3F, 0x82, 0x81, 0x3F, 0x92, 0x81, 0x3E, 0xB4, 0x84, 0x5D, 0xED, 0xE7, 0x70,
  0x0E, 0x72, 0x0B, 0x97, 0x28, 0x17, 0xF6, 0x72, 0x82, 0x9E, 0xD5, 0x30,
  // "R" (U+0052)
  0x30, 0x9A, 0x83, 0xED, 0xD9, 0x14, 0x85, 0x8F, 0x30, 0x3F, 0xB4, 0x09, 0x93, 0x0B, 0x94, 0x0D,
  0x0C, 0x30, 0xC9, 0x38, 0x11, 0xF8, 0x28, 0x11, 0xFB, 0x38, 0x64, 0xF5, 0x02, 0xBD, 0x23, 0x84,
  0x7F, 0xDE, 0xF7, 0x58, 0x4B, 0xE0, 0x6F, 0x55, 0x84, 0xEB, 0x03, 0xF8, 0x48, 0x12, 0xF8, 0x29,
  0x0C, 0x48, 0x15, 0xF5, 0x28, 0x1B, 0xF1, 0x38, 0x1A, 0xF3, 0x28, 0x47, 0xF7, 0x03, 0xEB, 0x09,
  0x28, 0x1A, 0xE5,
  // "S" (U+0053)
  0x38, 0x43, 0xBD, 0xEB, 0x32, 0x85, 0x3F, 0x70, 0x1D, 0xE2, 0x0A, 0x0D, 0x30, 0x80, 0xB2, 0x0D,
  0x0C, 0x78, 0x1B, 0xF2, 0x68, 0x25, 0xFE, 0x46, 0x06, 0xA0, 0x66, 0x82, 0x3D, 0xF4, 0x68, 0x42,
  0xFB, 0x05, 0x74, 0x83, 0xDC, 0x0B, 0xB4, 0x84, 0xE9, 0x08, 0xF5, 0x28, 0x18, 0xE2, 0x28, 0x47,
  0xDD, 0xDA, 0x22,
  // "T" (U+0054)
  0x18, 0xA3, 0xEF, 0xDE, 0xFE, 0xDF, 0xE2, 0xE1, 0x08, 0xF2, 0x06, 0xC6, 0x72, 0x0C, 0x0E, 0x20,
  0x40, 0x94, 0x90, 0xB7, 0x81, 0x3F, 0x87, 0x81, 0x6F, 0x47, 0x81, 0x9F, 0x17, 0x0C, 0x0D, 0x71,
  0x90, 0xA7, 0x81, 0x3F, 0x77, 0x81, 0x6F, 0x37, 0x81, 0xCF, 0x25, 0x06, 0xC0, 0x64,
  // "U" (U+0055)
  0x10, 0xEB, 0x82, 0x90, 0x2E, 0xA0, 0xA2, 0x81, 0xDF, 0x24, 0x90, 0x33, 0x0E, 0x0B, 0x40, 0x20,
  0xD3, 0x81, 0x2F, 0x84, 0x05, 0x09, 0x38, 0x15, 0xF5, 0x40, 0x80, 0x63, 0x81, 0x9F, 0x14, 0x0C,
  0x02, 0x30, 0xC0, 0xE5, 0x0E, 0x49, 0x0A, 0x40, 0x30, 0xB3, 0x81, 0x3F, 0x74, 0x06, 0x08, 0x38,
  0x15, 0xF5, 0x40, 0xA0, 0x43, 0x81, 0x5F, 0x43, 0x01, 0x0D, 0x48, 0x11, 0xEB, 0x28, 0x11, 0xB4,
  0x58, 0x43, 0xBE, 0xDC, 0x45,
  // "V" (U+0056)
  0x03, 0xB8, 0x2E, 0x10, 0x8A, 0x84, 0xE3, 0x05, 0xFA, 0x40, 0x80, 0xC3, 0x81, 0x3F, 0x84, 0x0C,
  0x04, 0x38, 0x11, 0xF9, 0x30, 0x40, 0xC5, 0x90, 0xA3, 0x0C, 0x04, 0x50, 0xE0, 0xB2, 0x04, 0x0C,
  0x60, 0xD0, 0xC2, 0x0C, 0x04, 0x68, 0x3B, 0xD0, 0x4B, 0x78, 0x3A, 0xF0, 0xC3, 0x78, 0x29, 0xF3,
  0xB7, 0x18, 0x27, 0xFA, 0x37, 0x18, 0x16, 0xFA, 0x72, 0x81, 0x5F, 0x37,
  // "W" (U+0057)
  0x02, 0xB0, 0xE0, 0x22, 0x00, 0xB3, 0x0D, 0xA8, 0x3B, 0x04, 0xFB, 0x38, 0x12, 0xFB, 0x40, 0xE0,
  0x62, 0x81, 0x2F, 0x93, 0x81, 0x9F, 0xC3, 0x02, 0x0D, 0x38, 0x11, 0xFA, 0x28, 0x21, 0xEC, 0xD3,
  0x09, 0x06, 0x49, 0x0A, 0x28, 0x27, 0x8B, 0xE2, 0x01, 0x0E, 0x59, 0x0B, 0x28, 0x2D, 0x2A, 0xE2,
  0x00, 0x85, 0x98, 0x4B, 0x05, 0xA0, 0x99, 0x20, 0xE0, 0x15, 0x89, 0x1E, 0xC0, 0xC3, 0x09, 0xF1,
  0x69, 0x68, 0x2D, 0xC3, 0xC2, 0x83, 0x8F, 0x1D, 0x26, 0x82, 0xDD, 0x95, 0x28, 0x27, 0xF6, 0xB7,
  0x81, 0xCD, 0xD3, 0x82, 0x6F, 0xC4, 0x78, 0x1B, 0xF7, 0x38, 0x16, 0xFC, 0x71, 0x81, 0xBE, 0x13,
  0x81, 0x5F, 0x56,
  // "X" (U+0058)
  0x30, 0xDA, 0x82, 0xE5, 0x0B, 0xA0, 0x94, 0x81, 0xBF, 0x42, 0x81, 0x2F, 0x55, 0x81, 0x5F, 0x72,
  0x0A, 0x06, 0x68, 0x41, 0xFC, 0x07, 0x97, 0x18, 0x2B, 0xF5, 0xB7, 0x28, 0x26, 0xFD, 0x17, 0x28,
  0x13, 0xFB, 0x73, 0x82, 0xCC, 0xF1, 0x71, 0x83, 0xA5, 0x5F, 0x67, 0x84, 0x88, 0x01, 0xFB, 0x60,
  0x50, 0xB3, 0x81, 0xBF, 0x14, 0x81, 0x4F, 0x43, 0x81, 0xAF, 0x73, 0x09, 0xA0, 0xE2, 0x0C, 0xB0,
  0x62,
  // "Y" (U+0059)
  0x04, 0xB8, 0x2D, 0x03, 0xEA, 0x83, 0x80, 0x7F, 0x83, 0x81, 0x1F, 0x52, 0x81, 0x2F, 0x93, 0x07,
  0x09, 0x40, 0x0D, 0x20, 0x20, 0xC5, 0x84, 0x9F, 0x20, 0xC3, 0x58, 0x34, 0xF6, 0x87, 0x79, 0x00,
  0xB7, 0x18, 0x1C, 0xF2, 0x71, 0x0E, 0x0C, 0x71, 0x81, 0x1F, 0x97, 0x18, 0x15, 0xF6, 0x71, 0x81,
  0xAF, 0x46, 0x05, 0x0E, 0xB0, 0x85,
  // "Z" (U+005A)
  0x30, 0x89, 0x80, 0x0D, 0xA0, 0x33, 0x0C, 0x06, 0x38, 0x16, 0xFA, 0x30, 0x10, 0xD3, 0x82, 0x2E,
  0xD1, 0x40, 0x13, 0x81, 0xCF, 0x37, 0x18, 0x18, 0xF8, 0x71, 0x81, 0x3F, 0xC7, 0x18, 0x21, 0xDE,
  0x27, 0x18, 0x1A, 0xF6, 0x71, 0x81, 0x5F, 0xA7, 0x18, 0x22, 0xED, 0x13, 0x01, 0x48, 0x1B, 0xF4,
  0x30, 0x30, 0xA3, 0x81, 0x7F, 0x84, 0x0A, 0x06, 0x20, 0x1A, 0x80, 0x0D, 0x81, 0xEF, 0x32,
  // "[" (U+005B)
  0x30, 0xAA, 0x0D, 0x38, 0x1D, 0xD1, 0x38, 0x11, 0xF9, 0x48, 0x14, 0xF6, 0x48, 0x17, 0xF2, 0x40,
  0xB0, 0xE5, 0x0E, 0x0B, 0x48, 0x12, 0xF7, 0x48, 0x15, 0xF4, 0x48, 0x19, 0xF1, 0x40, 0xC0, 0xD5,
  0x90, 0x94, 0x81, 0x3F, 0x64, 0x81, 0x6F, 0x34, 0x81, 0xAF, 0x24, 0x82, 0xCE, 0xE9, 0x30,
  // "\" (U+005C)
  0xE0, 0xE0, 0xE0, 0xD0, 0xD1, 0xC1, 0xB2, 0xB3, 0xA3, 0x94, 0x95, 0x85, 0x86, 0x77, 0x67, 0x68,
  // "]" (U+005D)
  0x30, 0x70, 0xEA, 0x50, 0x0D, 0x59, 0x09, 0x48, 0x13, 0xF6, 0x48, 0x16, 0xF3, 0x40, 0xA9, 0x50,
  0xD0, 0xB4, 0x81, 0x1F, 0x84, 0x81, 0x4F, 0x54, 0x81, 0x8F, 0x24, 0x0B, 0x0E, 0x50, 0xE0, 0xB4,
  0x81, 0x2F, 0x74, 0x81, 0x6F, 0x43, 0x82, 0x1B, 0xF1, 0x28, 0x29, 0xEE, 0xC3,
  // "^" (U+005E)
  0x00, 0x1C, 0x00, 0x00, 0x08, 0xE3, 0x00, 0x00, 0xD6, 0xA0, 0x00, 0x5A, 0x0D, 0x10, 0x0B, 0x40,
  0x87, 0x02, 0xD0, 0x02, 0xD0, 0x87, 0x00, 0x0B, 0x4E, 0x10, 0x00, 0x5A,
  // "_" (U+005F)
  0x5D, 0xDD, 0xDD, 0xDB,
  // "`" (U+0060)
  0x3F, 0x70, 0x08, 0xC0, 0x00, 0xB2,
  // "a" (U+0061)
  0x00, 0x04, 0xCD, 0xC8, 0x90, 0x04, 0xF6, 0x05, 0xF6, 0x00, 0xD9, 0x00, 0x6F, 0x30, 0x7F, 0x20,
  0x09, 0xF0, 0x0D, 0xD0, 0x00, 0xCC, 0x01, 0xF9, 0x00, 0x1F, 0x90, 0x3F, 0x70, 0x06, 0xF6, 0x03,
  0xF7, 0x00, 0xCF, 0x40, 0x1F, 0xA0, 0x97, 0xF3, 0x10, 0x6E, 0xB3, 0x2E, 0xD7,
  // "b" (U+0062)
  0x10, 0x1A, 0x0E, 0x68, 0x11, 0xFA, 0x68, 0x12, 0xF7, 0x68, 0x15, 0xF4, 0x68, 0x48, 0xF3, 0xAE,
  0x83, 0x85, 0xBC, 0x90, 0x7F, 0x32, 0x89, 0x1E, 0xE1, 0x04, 0xF5, 0x03, 0xF9, 0x28, 0x55, 0xF5,
  0x06, 0xF3, 0x28, 0x47, 0xF4, 0x09, 0xE3, 0x0A, 0x0E, 0x20, 0xC0, 0xB2, 0x81, 0x1E, 0xA2, 0x90,
  0x82, 0x89, 0x17, 0xF2, 0x03, 0xF8, 0x03, 0xE7, 0x28, 0x47, 0x9B, 0xDD, 0x53,
  // "c" (U+0063)
  0x38, 0x34, 0xCE, 0xD4, 0x28, 0x90, 0x6E, 0x30, 0xDD, 0x02, 0xF7, 0x28, 0x49, 0x80, 0x9F, 0x15,
  0x0E, 0x0C, 0x58, 0x12, 0xF9, 0x58, 0x13, 0xF7, 0x58, 0x11, 0xF9, 0x68, 0x4B, 0xE1, 0x05, 0x62,
  0x83, 0x1A, 0xED, 0x82,
  // "d" (U+0064)
  0x60, 0x7A, 0x07, 0x78, 0x17, 0xF4, 0x78, 0x18, 0xF1, 0x70, 0xB0, 0xD4, 0x84, 0x4C, 0xDC, 0xE9,
  0x38, 0x54, 0xF6, 0x05, 0xF6, 0x30, 0xE0, 0x92, 0x81, 0x6F, 0x32, 0x81, 0x7F, 0x22, 0x09, 0x93,
  0x00, 0xD3, 0x00, 0xC2, 0x81, 0x1F, 0x92, 0x81, 0x1F, 0x92, 0x81, 0x3F, 0x72, 0x81, 0x6F, 0x62,
  0x81, 0x3F, 0x72, 0x81, 0xCF, 0x42, 0x87, 0x1F, 0xA0, 0x98, 0xF4, 0x12, 0x86, 0x7E, 0xB3, 0x2E,
  0xD7, 0x10,
  // "e" (U+0065)
  0x00, 0x04, 0xBE, 0xC2, 0x00, 0x6F, 0x31, 0xF9, 0x02, 0xF8, 0x00, 0xFA, 0x09, 0xF1, 0x05, 0xF5,
  0x0E, 0xC0, 0x5E, 0x90, 0x2F, 0xED, 0xB5, 0x00, 0x3F, 0x70, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00,
  0x0B, 0xD1, 0x05, 0x60, 0x01, 0xAE, 0xD9, 0x00,
  // "f" (U+0066)
  0x78, 0x28, 0xDE, 0x97, 0x84, 0x7F, 0x16, 0xF1, 0x68, 0x3E, 0xA0, 0x13, 0x68, 0x13, 0xF7, 0x71,
  0x83, 0x8E, 0xFD, 0xD7, 0x10, 0x99, 0x73, 0x00, 0xC7, 0x39, 0x08, 0x72, 0x81, 0x3F, 0x57, 0x28,
  0x17, 0xF2, 0x72, 0x0A, 0x0E, 0x73, 0x0D, 0x0B, 0x72, 0x81, 0x1F, 0x87, 0x28, 0x14, 0xF4, 0x72,
  0x81, 0x8F, 0x17, 0x20, 0xD0, 0xB7, 0x28, 0x15, 0xF3, 0x78, 0x22, 0xDD, 0x57, 0x10,
  // "g" (U+0067)
  0x71, 0x81, 0x5D, 0x64, 0x85, 0x5C, 0xEF, 0xB5, 0x53, 0x84, 0x6E, 0x20, 0xDA, 0x50, 0xE0, 0x82,
  0x0C, 0x0A, 0x48, 0x53, 0xF4, 0x01, 0xF7, 0x48, 0x42, 0xF6, 0x09, 0xD6, 0x83, 0x8E, 0xD9, 0x15,
  0x04, 0x0B, 0x72, 0x82, 0xBB, 0x42, 0x70, 0x6B, 0x0E, 0x05, 0x48, 0x56, 0xB5, 0x58, 0xEE, 0x30,
  0x50, 0xE4, 0x07, 0x93, 0x09, 0x0B, 0x40, 0x80, 0xD3, 0x81, 0x7E, 0x22, 0x81, 0x4E, 0x54, 0x84,
  0x8D, 0xDD, 0xB4, 0x40,
  // "h" (U+0068)
  0x20, 0xDA, 0x01, 0x70, 0x0D, 0x71, 0x0E, 0x0A, 0x78, 0x12, 0xF6, 0x78, 0x55, 0xF3, 0x7D, 0xD1,
  0x38, 0x58, 0xF8, 0x23, 0xF7, 0x38, 0x5B, 0xF5, 0x03, 0xF7, 0x30, 0xE0, 0xC2, 0x81, 0x5F, 0x42,
  0x81, 0x2F, 0x72, 0x81, 0x9F, 0x12, 0x81, 0x5F, 0x22, 0x0C, 0x0D, 0x30, 0x99, 0x30, 0xE0, 0xA3,
  0x00, 0xC2, 0x81, 0x1F, 0x83, 0x90, 0x92, 0x86, 0x2F, 0x81, 0x03, 0xF5, 0x38, 0x2B, 0xE9, 0x10,
  // "i" (U+0069)
  0x00, 0xCA, 0x00, 0xDA, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF3, 0x0B, 0xF0, 0x0C, 0xC0, 0x0F, 0x90,
  0x3F, 0x60, 0x6F, 0x30, 0x9F, 0x00, 0xCC, 0x00, 0xCC, 0x01, 0x6E, 0xB3,
  // "j" (U+006A)
  0x60, 0xC0, 0xB6, 0x0D, 0x0B, 0x77, 0x60, 0x9A, 0x03, 0x50, 0xB9, 0x60, 0x0C, 0x69, 0x08, 0x58,
  0x13, 0xF5, 0x58, 0x16, 0xF2, 0x50, 0xA0, 0xE6, 0x0D, 0x0B, 0x58, 0x11, 0xF8, 0x58, 0x14, 0xF4,
  0x58, 0x18, 0xF1, 0x50, 0xC0, 0xB5, 0x81, 0x5F, 0x43, 0x82, 0x2D, 0xD5, 0x40,
  // "k" (U+006B)
  0x20, 0xDA, 0x01, 0x70, 0x0D, 0x71, 0x0E, 0x0A, 0x78, 0x12, 0xF7, 0x78, 0x35, 0xF3, 0x0C, 0xA0,
  0x92, 0x08, 0x92, 0x81, 0x5E, 0x43, 0x84, 0xBC, 0x02, 0xC3, 0x48, 0x3E, 0x92, 0xC2, 0x48, 0x32,
  0xF7, 0xDB, 0x58, 0x45, 0xFC, 0x9F, 0x14, 0x84, 0x9F, 0x13, 0xF7, 0x40, 0x0C, 0x20, 0xD0, 0xC4,
  0x90, 0x92, 0x81, 0x8F, 0x52, 0x81, 0x3F, 0x52, 0x82, 0x1B, 0xF4, 0x10,
  // "l" (U+006C)
  0x0E, 0xFF, 0x10, 0x0E, 0xD0, 0x00, 0xEA, 0x00, 0x2F, 0x60, 0x06, 0xF3, 0x00, 0x9F, 0x00, 0x0C,
  0xC0, 0x00, 0xF9, 0x00, 0x3F, 0x60, 0x06, 0xF2, 0x00, 0xAE, 0x00, 0x0C, 0xC0, 0x00, 0xDC, 0x01,
  0x07, 0xEB, 0x30,
  // "m" (U+006D)
  0x0B, 0xFF, 0x27, 0xDC, 0x12, 0xAE, 0x80, 0x00, 0xCF, 0x72, 0x4F, 0x78, 0x0A, 0xF0, 0x00, 0xCF,
  0x40, 0x3F, 0xC0, 0x09, 0xF0, 0x00, 0xFC, 0x00, 0x6F, 0x60, 0x0C, 0xD0, 0x03, 0xF6, 0x00, 0x9F,
  0x10, 0x0F, 0xA0, 0x06, 0xF2, 0x00, 0xCC, 0x00, 0x3F, 0x70, 0x0A, 0xE0, 0x00, 0xF9, 0x00, 0x6F,
  0x40, 0x0D, 0xB0, 0x03, 0xF6, 0x00, 0x8F, 0x10, 0x0F, 0x80, 0x05, 0xF4, 0x00, 0x8F, 0x11, 0x4F,
  0x50, 0x07, 0xF2, 0x00, 0x3E, 0xC6,
  // "n" (U+006E)
  0x0B, 0xFF, 0x28, 0xDD, 0x10, 0x0C, 0xE7, 0x24, 0xF6, 0x00, 0xCF, 0x50, 0x3F, 0x60, 0x0F, 0xC0,
  0x06, 0xF4, 0x03, 0xF6, 0x00, 0x9F, 0x10, 0x6F, 0x20, 0x0C, 0xD0, 0x0A, 0xE0, 0x00, 0xFA, 0x00,
  0xDB, 0x00, 0x2F, 0x70, 0x0F, 0x80, 0x02, 0xF7, 0x14, 0xF5, 0x00, 0x0B, 0xE9,
  // "o" (U+006F)
  0x00, 0x05, 0xCD, 0xD4, 0x00, 0x06, 0xE3, 0x09, 0xF1, 0x02, 0xF7, 0x00, 0x3F, 0x60, 0x9F, 0x10,
  0x03, 0xF7, 0x0E, 0xB0, 0x00, 0x4F, 0x62, 0xF8, 0x00, 0x07, 0xF3, 0x3F, 0x70, 0x00, 0xBE, 0x01,
  0xF8, 0x00, 0x2F, 0x60, 0x0C, 0xC0, 0x1C, 0xB0, 0x00, 0x1B, 0xED, 0x80, 0x00,
  // "p" (U+0070)
  0x20, 0xAA, 0x82, 0x19, 0xEB, 0x48, 0x5B, 0xE7, 0x23, 0xF6, 0x38, 0x1C, 0xF4, 0x29, 0x09, 0x39,
  0x0C, 0x28, 0x11, 0xF9, 0x28, 0x13, 0xF7, 0x28, 0x13, 0xF7, 0x28, 0x16, 0xF3, 0x28, 0x16, 0xF3,
  0x20, 0x99, 0x30, 0xC0, 0xD3, 0x0D, 0x0C, 0x28, 0x13, 0xF5, 0x39, 0x83, 0xB0, 0x1D, 0xA3, 0x84,
  0x4F, 0xCE, 0xD8, 0x48, 0x17, 0xF1, 0x70, 0xA0, 0xE7, 0x10, 0xD0, 0xC7, 0x01, 0xA0, 0xD6,
  // "q" (U+0071)
  0x38, 0x43, 0xCD, 0xC9, 0x92, 0x85, 0x4F, 0x60, 0x5F, 0x62, 0x0D, 0x0A, 0x28, 0x56, 0xF3, 0x07,
  0xF3, 0x20, 0x99, 0x20, 0x0D, 0x38, 0x4C, 0xC0, 0x1F, 0x92, 0x85, 0x1F, 0x80, 0x3F, 0x72, 0x85,
  0x6F, 0x50, 0x3F, 0x72, 0x81, 0xCF, 0x22, 0x84, 0xEA, 0x08, 0x9E, 0x38, 0x46, 0xEC, 0x2C, 0xB7,
  0x90, 0x76, 0x81, 0x3F, 0x46, 0x81, 0x6F, 0x36, 0x09, 0xA0, 0x31,
  // "r" (U+0072)
  0x10, 0xCA, 0x82, 0x1A, 0xE8, 0x28, 0x4B, 0xC8, 0x1A, 0xB2, 0x84, 0xCE, 0x40, 0x21, 0x20, 0xE0,
  0xD5, 0x81, 0x2F, 0x75, 0x81, 0x6F, 0x35, 0x09, 0x96, 0x00, 0xC6, 0x90, 0x95, 0x81, 0x3F, 0x65,
  // "s" (U+0073)
  0x00, 0x3C, 0xDD, 0x60, 0x1E, 0x50, 0x8F, 0x06, 0xF0, 0x03, 0xA0, 0x5F, 0x70, 0x00, 0x00, 0xCF,
  0xB2, 0x00, 0x00, 0x8F, 0xD0, 0x01, 0x00, 0x6F, 0x46, 0xA0, 0x02, 0xF4, 0x7E, 0x10, 0x8D, 0x00,
  0xAE, 0xDA, 0x20,
  // "t" (U+0074)
  0x00, 0x4A, 0x00, 0x4E, 0x70, 0x8E, 0xFD, 0xD0, 0xAF, 0x00, 0x0D, 0xC0, 0x00, 0xF9, 0x00, 0x3F,
  0x60, 0x07, 0xF3, 0x00, 0xAF, 0x00, 0x0C, 0xC0, 0x00, 0xCD, 0x01, 0x05, 0xED, 0x90,
  // "u" (U+0075)
  0xBF, 0xF3, 0x00, 0xBD, 0x00, 0xBF, 0x00, 0x0E, 0xA0, 0x0C, 0xC0, 0x02, 0xF7, 0x00, 0xF9, 0x00,
  0x5F, 0x40, 0x3F, 0x60, 0x08, 0xF1, 0x07, 0xF3, 0x00, 0xCD, 0x00, 0xAF, 0x00, 0x3F, 0xA0, 0x0C,
  0xD0, 0x0A, 0xF8, 0x00, 0xDD, 0x07, 0x6F, 0x81, 0x06, 0xEC, 0x40, 0xBE, 0x91,
  // "v" (U+0076)
  0x05, 0xA0, 0x22, 0x09, 0x0D, 0x28, 0x15, 0xF4, 0x28, 0x58, 0xF2, 0x02, 0xF5, 0x39, 0x83, 0x10,
  0x1F, 0x72, 0x02, 0x0D, 0x39, 0x09, 0x20, 0x60, 0x73, 0x0D, 0x0A, 0x20, 0xC0, 0x13, 0x83, 0xCC,
  0x06, 0x74, 0x82, 0xAD, 0x1B, 0x58, 0x28, 0xEB, 0x35, 0x81, 0x7F, 0x64,
  // "w" (U+0077)
  0xFF, 0x80, 0x02, 0xF6, 0x00, 0xB9, 0x2F, 0x70, 0x08, 0xF7, 0x00, 0x9B, 0x0F, 0x70, 0x0C, 0xE7,
  0x00, 0x79, 0x0F, 0x70, 0x57, 0xE7, 0x00, 0xA4, 0x0F, 0x70, 0xB1, 0xE7, 0x01, 0xC0, 0x1F, 0x63,
  0x90, 0xE7, 0x08, 0x40, 0x1F, 0x6A, 0x20, 0xE8, 0x1A, 0x00, 0x1F, 0x7A, 0x00, 0xE7, 0xA2, 0x00,
  0x1F, 0xD3, 0x00, 0xEC, 0x70, 0x00, 0x2F, 0xA0, 0x00, 0xFC, 0x00, 0x00,
  // "x" (U+0078)
  0x20, 0x4A, 0x83, 0x10, 0x2F, 0xE3, 0x84, 0x6F, 0x50, 0xA8, 0x48, 0x31, 0xF9, 0x3C, 0x68, 0x2B,
  0xDC, 0x26, 0x81, 0x5F, 0x77, 0x81, 0x8F, 0x86, 0x82, 0x4B, 0xBD, 0x58, 0x41, 0xD2, 0x7F, 0x34,
  0x84, 0xB8, 0x02, 0xF8, 0x28, 0x12, 0xED, 0x38, 0x1E, 0xF7, 0x10,
  // "y" (U+0079)
  0x38, 0x18, 0xFE, 0x30, 0xB0, 0xC5, 0x81, 0x9F, 0x22, 0x81, 0x8F, 0x14, 0x81, 0x5F, 0x52, 0x04,
  0x95, 0x81, 0x1F, 0x82, 0x06, 0x0B, 0x60, 0xD0, 0xB2, 0x0B, 0x05, 0x68, 0x3A, 0xE0, 0x2D, 0x78,
  0x37, 0xF2, 0x96, 0x78, 0x23, 0xF7, 0xC7, 0x2A, 0x04, 0x72, 0x0C, 0x0A, 0x72, 0x81, 0x3E, 0x17,
  0x18, 0x11, 0xD5, 0x71, 0x81, 0x5E, 0x76, 0x83, 0x6D, 0xDB, 0x47,
  // "z" (U+007A)
  0x00, 0xEE, 0xDE, 0xFA, 0x03, 0xB0, 0x0B, 0xF2, 0x03, 0x20, 0x6F, 0x70, 0x00, 0x01, 0xEC, 0x00,
  0x00, 0x0B, 0xF2, 0x00, 0x00, 0x5F, 0x70, 0x00, 0x01, 0xEC, 0x00, 0x00, 0x0A, 0xF2, 0x00, 0xA0,
  0x5F, 0x70, 0x04, 0xA0, 0xDF, 0xDD, 0xDF, 0x70,
  // "{" (U+007B)
  0x48, 0x19, 0xED, 0x38, 0x17, 0xF4, 0x40, 0xC0, 0xD5, 0x90, 0x94, 0x81, 0x4F, 0x64, 0x81, 0x7F,
  0x34, 0x0B, 0x0E, 0x48, 0x15, 0xF7, 0x38, 0x1D, 0xF7, 0x58, 0x1A, 0xF1, 0x48, 0x18, 0xF2, 0x40,
  0xB0, 0xE5, 0x0E, 0x0A, 0x48, 0x12, 0xF7, 0x48, 0x13, 0xF8, 0x58, 0x1A, 0xEA, 0x30,
  // "|" (U+007C)
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D,
  // "}" (U+007D)
  0x38, 0x27, 0xEB, 0x14, 0x81, 0x4F, 0x64, 0x81, 0x3F, 0x64, 0x81, 0x6F, 0x34, 0x09, 0x95, 0x0C,
  0x0D, 0x59, 0x0A, 0x58, 0x1D, 0xD1, 0x40, 0x50, 0xE9, 0x38, 0x16, 0xF7, 0x40, 0x0D, 0x48, 0x11,
  0xF8, 0x48, 0x15, 0xF5, 0x48, 0x19, 0xF1, 0x38, 0x12, 0xEB, 0x38, 0x2A, 0xEA, 0x13,
  // "~" (U+007E)
  0x4D, 0xB1, 0x01, 0xCC, 0x24, 0xD2, 0x69, 0xD0, 0x03, 0xCC, 0x10,
  // "¡" (U+00A1)
  0x00, 0x4E, 0x50, 0x07, 0xF5, 0x00, 0x01, 0x00, 0x03, 0x30, 0x00, 0xA3, 0x00, 0x0E, 0x10, 0x03,
  0xE0, 0x00, 0x7C, 0x00, 0x0B, 0x90, 0x01, 0xF7, 0x00, 0x5F, 0x50, 0x09, 0xF2, 0x00, 0x89, 0x00,
  0x00,
  // "¢" (U+00A2)
  0x50, 0xC5, 0x82, 0x28, 0xE6, 0x38, 0xB1, 0x6D, 0x7B, 0xF7, 0x03, 0xF5, 0x84, 0xE6, 0x0C, 0xD0,
  0xB1, 0x10, 0x2F, 0x80, 0xC3, 0x83, 0x6F, 0x52, 0xA3, 0x83, 0x8F, 0x35, 0x63, 0x83, 0x7F, 0x48,
  0x33, 0x85, 0x3F, 0xAB, 0x19, 0x32, 0x09, 0xA0, 0xC0, 0x54, 0x05, 0x09, 0x60, 0x50, 0x64,
  // "£" (U+00A3)
  0x48, 0x36, 0xDE, 0xD6, 0x48, 0x58, 0xD1, 0x0A, 0xF1, 0x28, 0x11, 0xF6, 0x20, 0x50, 0xD3, 0x81,
  0x4F, 0x37, 0x81, 0x5F, 0x27, 0x81, 0x4F, 0x36, 0x84, 0xAD, 0xFE, 0xDB, 0x58, 0x11, 0xF5, 0x78,
  0x11, 0xF4, 0x78, 0x15, 0xF1, 0x70, 0xD0, 0x77, 0x82, 0xAC, 0x95, 0x20, 0x72, 0x86, 0x89, 0x8A,
  0xDE, 0xA3, 0x20,
  // "¤" (U+00A4)
  0x10, 0x45, 0x8A, 0x25, 0x2E, 0x9D, 0xDC, 0xAC, 0x07, 0xD2, 0x04, 0xF3, 0x0B, 0x43, 0x83, 0x78,
  0x0D, 0x13, 0x83, 0x5A, 0x0B, 0x43, 0x8A, 0x28, 0x80, 0x7E, 0x20, 0x5F, 0x33, 0xE8, 0xCD, 0xB9,
  0xD0, 0x35, 0x04,
  // "¥" (U+00A5)
  0x02, 0xB8, 0x16, 0x0A, 0xA8, 0x36, 0x06, 0xF5, 0x39, 0x04, 0x28, 0x12, 0xF6, 0x20, 0x50, 0xA4,
  0x0E, 0x09, 0x20, 0xC0, 0x14, 0x83, 0xBC, 0x08, 0x65, 0x82, 0x8F, 0x2C, 0x68, 0x25, 0xFC, 0x34,
  0x85, 0x3D, 0xDF, 0xED, 0x95, 0x81, 0x4F, 0x55, 0x85, 0x9D, 0xEF, 0xDD, 0x35, 0x0B, 0x0D, 0x78,
  0x11, 0xFB, 0x60, 0xBB, 0x0E, 0x50,
  // "¦" (U+00A6)
  0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D,
  0x1D, 0x1D,
  // "§" (U+00A7)
  0x38, 0x31, 0x9D, 0xE9, 0x48, 0x4C, 0x70, 0x3F, 0x62, 0x03, 0x93, 0x0D, 0x04, 0x28, 0x14, 0xF1,
  0x68, 0x23, 0xFB, 0x15, 0x83, 0x7C, 0xFD, 0x33, 0x85, 0x3B, 0x08, 0xFE, 0x22, 0x06, 0x0C, 0x28,
  0x14, 0xF9, 0x28, 0x15, 0xF8, 0x20, 0x90, 0xA3, 0x84, 0xBF, 0xC1, 0xA5, 0x48, 0x29, 0xFE, 0x96,
  0x81, 0x6F, 0x63, 0x01, 0x30, 0xB0, 0x72, 0x08, 0x07, 0x30, 0xC0, 0x42, 0x84, 0x8D, 0x20, 0x6C,
  0x48, 0x29, 0xDD, 0x94,
  // "¨" (U+00A8)
  0x4C, 0x05, 0xC6, 0xC0, 0x6C,
  // "©" (U+00A9)
  0x38, 0x51, 0x8C, 0xDC, 0x81, 0x58, 0x72, 0xD7, 0x10, 0x16, 0xD2, 0x40, 0xC0, 0x35, 0x03, 0x0C,
  0x38, 0x91, 0x77, 0x02, 0xBD, 0xC5, 0x07, 0x72, 0x89, 0x1C, 0x10, 0xD5, 0x02, 0xE0, 0x1C, 0x28,
  0x2D, 0x05, 0xB3, 0x06, 0x28, 0x5D, 0x01, 0xC0, 0x87, 0x68, 0x5C, 0x11, 0xC0, 0x96, 0x68, 0x5C,
  0x10, 0xD0, 0x88, 0x60, 0xD2, 0x82, 0xC2, 0x5C, 0x38, 0x21, 0x01, 0xC2, 0x89, 0x16, 0x80, 0xD6,
  0x01, 0xC0, 0x77, 0x38, 0x7D, 0x32, 0xBD, 0xC4, 0x3C, 0x48, 0x72, 0xD7, 0x10, 0x16, 0xC2, 0x58,
  0x51, 0x8C, 0xDC, 0x81, 0x30,
  // "ª" (U+00AA)
  0x01, 0xBA, 0xC8, 0x0C, 0x70, 0xD5, 0x5E, 0x02, 0xF2, 0x9B, 0x07, 0xD0, 0xAB, 0x1B, 0xB0, 0x4E,
  0x93, 0xE6,
  // "«" (U+00AB)
  0x00, 0x3B, 0x05, 0x90, 0x3E, 0x24, 0xD1, 0x2E, 0x74, 0xF5, 0x0C, 0xD0, 0xEB, 0x00, 0x8E, 0x0B,
  0xC0, 0x01, 0xE3, 0x2F, 0x10, 0x07, 0x70, 0x95, 0x00,
  // "¬" (U+00AC)
  0x0C, 0x80, 0x1D, 0x09, 0x50, 0x50, 0xA5, 0x05, 0x0A, 0x50, 0x50, 0xA5, 0x05, 0x09,
  // "®" (U+00AE)
  0x00, 0x01, 0x8C, 0xDC, 0x81, 0x00, 0x00, 0x02, 0xD7, 0x10, 0x16, 0xD2, 0x00, 0x00, 0xC3, 0x00,
  0x00, 0x03, 0xC0, 0x00, 0x77, 0x3B, 0xB9, 0x91, 0x07, 0x70, 0x0C, 0x10, 0x6A, 0x05, 0xB0, 0x1C,
  0x00, 0xD0, 0x06, 0xA0, 0x2E, 0x00, 0xD0, 0x1C, 0x00, 0x6A, 0x06, 0xB0, 0x0C, 0x11, 0xC0, 0x06,
  0xEE, 0xD1, 0x00, 0xC1, 0x0D, 0x00, 0x6A, 0x1E, 0x20, 0x0D, 0x00, 0xC2, 0x06, 0xA0, 0x7B, 0x01,
  0xC0, 0x06, 0x82, 0xBB, 0x50, 0xB8, 0x77, 0x00, 0x0D, 0x30, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x2D,
  0x71, 0x01, 0x6C, 0x20, 0x00, 0x00, 0x18, 0xCD, 0xC8, 0x10, 0x00,
  // "¯" (U+00AF)
  0xCD, 0xDD, 0xDD, 0xD4,
  // "°" (U+00B0)
  0x09, 0xDA, 0x16, 0x90, 0x68, 0xA2, 0x00, 0xCA, 0x20, 0x0C, 0x69, 0x06, 0x90, 0x9D, 0xA1,
  // "±" (U+00B1)
  0x30, 0xE0, 0x15, 0x0E, 0x01, 0x50, 0xE0, 0x15, 0x0E, 0x01, 0x28, 0x59, 0xDD, 0xFD, 0xDB, 0x30,
  0xE0, 0x15, 0x0E, 0x01, 0x50, 0xE0, 0x17, 0x72, 0x09, 0x80, 0x1D, 0x0B,
  // "²" (U+00B2)
  0x00, 0x8B, 0xB2, 0x06, 0xC0, 0xAB, 0x03, 0x50, 0xAA, 0x00, 0x01, 0xE3, 0x00, 0x0C, 0x60, 0x01,
  0xC5, 0x00, 0x1C, 0x40, 0x72, 0xAC, 0xBB, 0xC0,
  // "³" (U+00B3)
  0x00, 0x9B, 0xC6, 0x06, 0xC0, 0x6F, 0x00, 0x00, 0xBA, 0x00, 0x9E, 0x80, 0x00, 0x03, 0xF4, 0x22,
  0x00, 0xE6, 0x89, 0x04, 0xF2, 0x2B, 0xCA, 0x30,
  // "´" (U+00B4)
  0x07, 0xF5, 0x1E, 0x60, 0xB5, 0x00,
  // "µ" (U+00B5)
  0x38, 0x16, 0xF3, 0x20, 0xA0, 0xE3, 0x09, 0x93, 0x0D, 0x0B, 0x30, 0xD0, 0xC2, 0x81, 0x1F, 0x83,
  0x90, 0x92, 0x81, 0x4F, 0x52, 0x81, 0x4F, 0x62, 0x81, 0x7F, 0x22, 0x81, 0x7F, 0x22, 0x0A, 0x0E,
  0x30, 0xA9, 0x30, 0xD0, 0xB3, 0x00, 0xE2, 0x81, 0x3F, 0x82, 0x02, 0xA8, 0x31, 0x1A, 0xF7, 0x28,
  0x92, 0x7A, 0xBE, 0xA1, 0xCD, 0x90, 0xB6, 0x71, 0x0E, 0x05, 0x78, 0x11, 0xFA, 0x71, 0x0D, 0x0A,
  0x70,
  // "¶" (U+00B6)
  0x81, 0x1A, 0xEA, 0x00, 0xEA, 0x09, 0x08, 0xC8, 0x43, 0x1F, 0x20, 0xDC, 0x03, 0x01, 0x92, 0x0D,
  0xC0, 0x30, 0x19, 0x20, 0xBC, 0x03, 0x01, 0x92, 0x06, 0xC0, 0x30, 0x19, 0x38, 0x47, 0xBC, 0xF3,
  0x19, 0x68, 0x1D, 0x31, 0x96, 0x81, 0xD3, 0x19, 0x68, 0x1D, 0x31, 0x96, 0x81, 0xD3, 0x19, 0x68,
  0x1D, 0x31, 0x96, 0x81, 0xD3, 0x19, 0x68, 0x1D, 0x31, 0x95, 0x84, 0x2F, 0x31, 0xF4, 0x38, 0x68,
  0xEE, 0x21, 0xEE, 0xA0,
  // "·" (U+00B7)
  0x01, 0x04, 0xF8, 0x4E, 0x50,
  // "¸" (U+00B8)
  0x00, 0x51, 0x00, 0xE4, 0x00, 0x5F, 0x00, 0x6E, 0x6E, 0xC4,
  // "¹" (U+00B9)
  0x00, 0x00, 0x20, 0x01, 0xAC, 0x05, 0xDD, 0x80, 0x11, 0xE5, 0x00, 0x2F, 0x20, 0x05, 0xE0, 0x00,
  0x8B, 0x00, 0x0C, 0x90, 0x39, 0xCB, 0x60,
  // "º" (U+00BA)
  0x01, 0xAB, 0xC3, 0x0C, 0x80, 0xAB, 0x4F, 0x10, 0xAC, 0x8D, 0x00, 0xE8, 0x7D, 0x05, 0xE1, 0x1B,
  0xBC, 0x30,
  // "»" (U+00BB)
  0x00, 0xD0, 0x2C, 0x00, 0x00, 0xB7, 0x0D, 0x50, 0x00, 0x7E, 0x19, 0xD0, 0x00, 0x5F, 0x47, 0xF2,
  0x00, 0xD9, 0x1E, 0x70, 0x09, 0x90, 0xB7, 0x00, 0x4A, 0x06, 0x80, 0x00,
  // "¼" (U+00BC)
  0x40, 0x27, 0x38, 0x11, 0xAC, 0x48, 0x12, 0xD1, 0x28, 0x25, 0xDD, 0x84, 0x0B, 0x05, 0x38, 0x21,
  0x1E, 0x53, 0x05, 0x0B, 0x58, 0x12, 0xF2, 0x28, 0x11, 0xD2, 0x50, 0x50, 0xE3, 0x09, 0x07, 0x20,
  0x13, 0x08, 0x0B, 0x20, 0x30, 0xC2, 0x81, 0x3F, 0x52, 0x0C, 0x09, 0x28, 0x94, 0xD3, 0x01, 0xCF,
  0x23, 0x9C, 0xB6, 0x89, 0x20, 0xA0, 0x79, 0x58, 0x62, 0xD1, 0x07, 0x68, 0xC5, 0x86, 0xB5, 0x03,
  0xA0, 0xB9, 0x40, 0x60, 0xB2, 0x84, 0xAC, 0xBF, 0xD9, 0x28, 0x11, 0xD2, 0x48, 0x13, 0xF2, 0x30,
  0xA0, 0x74, 0x82, 0x6D, 0xDA, 0x10,
  // "½" (U+00BD)
  0x40, 0x27, 0x38, 0x11, 0xAC, 0x48, 0x12, 0xD1, 0x28, 0x25, 0xDD, 0x84, 0x0B, 0x05, 0x38, 0x21,
  0x1E, 0x53, 0x05, 0x0B, 0x58, 0x12, 0xF2, 0x28, 0x11, 0xD2, 0x50, 0x50, 0xE3, 0x09, 0x07, 0x60,
  0x80, 0xB2, 0x85, 0x3C, 0x08, 0xBB, 0x22, 0x0C, 0x09, 0x28, 0xA2, 0xD3, 0x6C, 0x0A, 0xB3, 0x9C,
  0xB6, 0x89, 0x03, 0x50, 0xAA, 0x48, 0x12, 0xD1, 0x38, 0x11, 0xE3, 0x40, 0xB0, 0x54, 0x0C, 0x06,
  0x40, 0x60, 0xB3, 0x81, 0x1C, 0x54, 0x81, 0x1D, 0x22, 0x84, 0x1C, 0x40, 0x72, 0x20, 0xA0, 0x73,
  0x83, 0xAC, 0xBB, 0xC1,
  // "¾" (U+00BE)
  0x28, 0x29, 0xBC, 0x63, 0x81, 0x2D, 0x12, 0x82, 0x6C, 0x06, 0x93, 0x0B, 0x05, 0x60, 0xB0, 0xA2,
  0x05, 0x0B, 0x58, 0x19, 0xE8, 0x28, 0x11, 0xD2, 0x68, 0x43, 0xF4, 0x09, 0x72, 0x82, 0x10, 0x22,
  0x28, 0x2E, 0x63, 0xC2, 0x8A, 0x53, 0xF5, 0x89, 0x04, 0xF2, 0xD3, 0x01, 0xCF, 0x22, 0xBC, 0xA3,
  0x89, 0x20, 0xA0, 0x79, 0x58, 0x62, 0xD1, 0x07, 0x68, 0xC5, 0x86, 0xB5, 0x03, 0xA0, 0xB9, 0x40,
  0x60, 0xB2, 0x84, 0xAC, 0xBF, 0xD9, 0x28, 0x11, 0xD2, 0x48, 0x13, 0xF2, 0x30, 0xA0, 0x74, 0x82,
  0x6D, 0xDA, 0x10,
  // "¿" (U+00BF)
  0x48, 0x17, 0xE3, 0x48, 0x1A, 0xF2, 0x50, 0x15, 0x04, 0x02, 0x50, 0xC0, 0x34, 0x02, 0x93, 0x82,
  0x19, 0xD6, 0x28, 0x21, 0xCC, 0x13, 0x81, 0x9F, 0x24, 0x0E, 0x0C, 0x38, 0x25, 0x0E, 0xB2, 0x89,
  0x64, 0xF2, 0xAE, 0x20, 0xCD, 0x01, 0x9D, 0xD9, 0x11,
  // "À" (U+00C0)
  0x68, 0x13, 0xF7, 0x73, 0x08, 0x0C, 0x74, 0x0B, 0x02, 0x77, 0x78, 0x18, 0xF2, 0x71, 0x82, 0x1E,
  0xF4, 0x71, 0x82, 0x89, 0xF6, 0x78, 0x31, 0xD3, 0xF7, 0x78, 0x39, 0x71, 0xF9, 0x60, 0x20, 0xE2,
  0x90, 0xA6, 0x0A, 0x07, 0x20, 0xE0, 0xC5, 0x03, 0x0E, 0x30, 0x0D, 0x50, 0xB8, 0x00, 0xEA, 0x40,
  0x40, 0xE4, 0x81, 0xAF, 0x13, 0x0C, 0x05, 0x48, 0x18, 0xF2, 0x20, 0x69, 0x58, 0x3A, 0xF5, 0x0A,
  0xA8, 0x3E, 0x10, 0x1E, 0xB0, 0x30,
  // "Á" (U+00C1)
  0x72, 0x81, 0x7F, 0x57, 0x18, 0x11, 0xE6, 0x72, 0x0B, 0x05, 0x77, 0x78, 0x18, 0xF2, 0x71, 0x82,
  0x1E, 0xF4, 0x71, 0x82, 0x89, 0xF6, 0x78, 0x31, 0xD3, 0xF7, 0x78, 0x39, 0x71, 0xF9, 0x60, 0x20,
  0xE2, 0x90, 0xA6, 0x0A, 0x07, 0x20, 0xE0, 0xC5, 0x03, 0x0E, 0x30, 0x0D, 0x50, 0xB8, 0x00, 0xEA,
  0x40, 0x40, 0xE4, 0x81, 0xAF, 0x13, 0x0C, 0x05, 0x48, 0x18, 0xF2, 0x20, 0x69, 0x58, 0x3A, 0xF5,
  0x0A, 0xA8, 0x3E, 0x10, 0x1E, 0xB0, 0x30,
  // "Â" (U+00C2)
  0x78, 0x12, 0xFE, 0x72, 0x82, 0xD8, 0xE4, 0x78, 0x3A, 0x50, 0x4A, 0x77, 0x68, 0x18, 0xF2, 0x71,
  0x82, 0x1E, 0xF4, 0x71, 0x82, 0x89, 0xF6, 0x78, 0x31, 0xD3, 0xF7, 0x78, 0x39, 0x71, 0xF9, 0x60,
  0x20, 0xE2, 0x90, 0xA6, 0x0A, 0x07, 0x20, 0xE0, 0xC5, 0x03, 0x0E, 0x30, 0x0D, 0x50, 0xB8, 0x00,
  0xEA, 0x40, 0x40, 0xE4, 0x81, 0xAF, 0x13, 0x0C, 0x05, 0x48, 0x18, 0xF2, 0x20, 0x69, 0x58, 0x3A,
  0xF5, 0x0A, 0xA8, 0x3E, 0x10, 0x1E, 0xB0, 0x30,
  // "Ã" (U+00C3)
  0x68, 0x43, 0xCD, 0x50, 0x96, 0x84, 0x90, 0x4C, 0xC3, 0x77, 0x58, 0x18, 0xF2, 0x71, 0x82, 0x1E,
  0xF4, 0x71, 0x82, 0x89, 0xF6, 0x78, 0x31, 0xD3, 0xF7, 0x78, 0x39, 0x71, 0xF9, 0x60, 0x20, 0xE2,
  0x90, 0xA6, 0x0A, 0x07, 0x20, 0xE0, 0xC5, 0x03, 0x0E, 0x30, 0x0D, 0x50, 0xB8, 0x00, 0xEA, 0x40,
  0x40, 0xE4, 0x81, 0xAF, 0x13, 0x0C, 0x05, 0x48, 0x18, 0xF2, 0x20, 0x69, 0x58, 0x3A, 0xF5, 0x0A,
  0xA8, 0x3E, 0x10, 0x1E, 0xB0, 0x30,
  // "Ä" (U+00C4)
  0x68, 0x34, 0xC0, 0x5C, 0x78, 0x36, 0xC0, 0x6C, 0x77, 0x77, 0x48, 0x18, 0xF2, 0x71, 0x82, 0x1E,
  0xF4, 0x71, 0x82, 0x89, 0xF6, 0x78, 0x31, 0xD3, 0xF7, 0x78, 0x39, 0x71, 0xF9, 0x60, 0x20, 0xE2,
  0x90, 0xA6, 0x0A, 0x07, 0x20, 0xE0, 0xC5, 0x03, 0x0E, 0x30, 0x0D, 0x50, 0xB8, 0x00, 0xEA, 0x40,
  0x40, 0xE4, 0x81, 0xAF, 0x13, 0x0C, 0x05, 0x48, 0x18, 0xF2, 0x20, 0x69, 0x58, 0x3A, 0xF5, 0x0A,
  0xA8, 0x3E, 0x10, 0x1E, 0xB0, 0x30,
  // "Å" (U+00C5)
  0x68, 0x21, 0xBD, 0x77, 0x18, 0x27, 0x60, 0xD7, 0x18, 0x28, 0x60, 0xD7, 0x10, 0x1A, 0x09, 0x71,
  0x82, 0x1E, 0xF4, 0x71, 0x82, 0x89, 0xF6, 0x78, 0x31, 0xD3, 0xF7, 0x78, 0x39, 0x71, 0xF9, 0x60,
  0x20, 0xE2, 0x90, 0xA6, 0x0A, 0x07, 0x20, 0xE0, 0xC5, 0x03, 0x0E, 0x30, 0x0D, 0x50, 0xB8, 0x00,
  0xEA, 0x40, 0x40, 0xE4, 0x81, 0xAF, 0x13, 0x0C, 0x05, 0x48, 0x18, 0xF2, 0x20, 0x69, 0x58, 0x3A,
  0xF5, 0x0A, 0xA8, 0x3E, 0x10, 0x1E, 0xB0, 0x30,
  // "Æ" (U+00C6)
  0x78, 0x90, 0x6D, 0xEF, 0xED, 0xDE, 0xF4, 0x71, 0x82, 0xB7, 0xF6, 0x28, 0x11, 0xF2, 0x78, 0x36,
  0x98, 0xF2, 0x30, 0xE7, 0x82, 0x1D, 0x1B, 0x94, 0x04, 0x78, 0x3A, 0x60, 0xEC, 0x74, 0x84, 0x5C,
  0x02, 0xF9, 0x73, 0x89, 0x11, 0xD3, 0x05, 0xFE, 0xDD, 0xD1, 0x60, 0x09, 0x28, 0x18, 0xF2, 0x72,
  0x85, 0x4F, 0xDD, 0xDF, 0xE7, 0x30, 0xD0, 0x43, 0x0E, 0x0B, 0x72, 0x08, 0x09, 0x38, 0x13, 0xF8,
  0x30, 0x10, 0xC3, 0x81, 0x4F, 0x13, 0x81, 0x7F, 0x53, 0x00, 0x92, 0x08, 0xA8, 0x2C, 0x01, 0xCA,
  0x84, 0xCB, 0xBC, 0xF4, 0x20,
  // "Ç" (U+00C7)
  0x38, 0x41, 0x7C, 0xDE, 0x93, 0x89, 0x23, 0xDA, 0x10, 0x8F, 0x60, 0x1E, 0xB3, 0x85, 0x3F, 0x50,
  0xBF, 0x24, 0x83, 0x30, 0x3F, 0xA7, 0x81, 0x9F, 0x57, 0x81, 0xCF, 0x17, 0x90, 0xE7, 0x19, 0x0C,
  0x71, 0x0E, 0x0D, 0x71, 0x81, 0xBF, 0x14, 0x02, 0x28, 0x63, 0xFA, 0x10, 0x19, 0x53, 0x84, 0x3B,
  0xFE, 0xC6, 0x60, 0xE0, 0x47, 0x10, 0x59, 0x71, 0x06, 0x0E, 0x68, 0x26, 0xEC, 0x45,
  // "È" (U+00C8)
  0x58, 0x13, 0xF7, 0x73, 0x08, 0x0C, 0x74, 0x0B, 0x02, 0x77, 0x40, 0x8A, 0x84, 0xCB, 0xBD, 0xF3,
  0x48, 0x18, 0xF3, 0x20, 0x29, 0x50, 0xA9, 0x30, 0x10, 0xD5, 0x00, 0xD4, 0x03, 0x48, 0x11, 0xFA,
  0x72, 0x81, 0x4F, 0x77, 0x28, 0x17, 0xFE, 0x0F, 0xD6, 0x0B, 0x97, 0x30, 0xE0, 0xC7, 0x28, 0x12,
  0xF9, 0x72, 0x81, 0x5F, 0x63, 0x03, 0x0B, 0x48, 0x19, 0xF3, 0x30, 0xB0, 0x72, 0x02, 0x0D, 0xA0,
  0xFB, 0x81, 0xDF, 0x32,
  // "É" (U+00C9)
  0x71, 0x81, 0x7F, 0x57, 0x18, 0x11, 0xE6, 0x72, 0x0B, 0x05, 0x77, 0x40, 0x8A, 0x84, 0xCB, 0xBD,
  0xF3, 0x48, 0x18, 0xF3, 0x20, 0x29, 0x50, 0xA9, 0x30, 0x10, 0xD5, 0x00, 0xD4, 0x03, 0x48, 0x11,
  0xFA, 0x72, 0x81, 0x4F, 0x77, 0x28, 0x17, 0xFE, 0x0F, 0xD6, 0x0B, 0x97, 0x30, 0xE0, 0xC7, 0x28,
  0x12, 0xF9, 0x72, 0x81, 0x5F, 0x63, 0x03, 0x0B, 0x48, 0x19, 0xF3, 0x30, 0xB0, 0x72, 0x02, 0x0D,
  0xA0, 0xFB, 0x81, 0xDF, 0x32,
  // "Ê" (U+00CA)
  0x68, 0x12, 0xFE, 0x72, 0x82, 0xD8, 0xE4, 0x78, 0x3A, 0x50, 0x4A, 0x77, 0x30, 0x8A, 0x84, 0xCB,
  0xBD, 0xF3, 0x48, 0x18, 0xF3, 0x20, 0x29, 0x50, 0xA9, 0x30, 0x10, 0xD5, 0x00, 0xD4, 0x03, 0x48,
  0x11, 0xFA, 0x72, 0x81, 0x4F, 0x77, 0x28, 0x17, 0xFE, 0x0F, 0xD6, 0x0B, 0x97, 0x30, 0xE0, 0xC7,
  0x28, 0x12, 0xF9, 0x72, 0x81, 0x5F, 0x63, 0x03, 0x0B, 0x48, 0x19, 0xF3, 0x30, 0xB0, 0x72, 0x02,
  0x0D, 0xA0, 0xFB, 0x81, 0xDF, 0x32,
  // "Ë" (U+00CB)
  0x58, 0x34, 0xC0, 0x5C, 0x78, 0x36, 0xC0, 0x6C, 0x77, 0x77, 0x10, 0x8A, 0x84, 0xCB, 0xBD, 0xF3,
  0x48, 0x18, 0xF3, 0x20, 0x29, 0x50, 0xA9, 0x30, 0x10, 0xD5, 0x00, 0xD4, 0x03, 0x48, 0x11, 0xFA,
  0x72, 0x81, 0x4F, 0x77, 0x28, 0x17, 0xFE, 0x0F, 0xD6, 0x0B, 0x97, 0x30, 0xE0, 0xC7, 0x28, 0x12,
  0xF9, 0x72, 0x81, 0x5F, 0x63, 0x03, 0x0B, 0x48, 0x19, 0xF3, 0x30, 0xB0, 0x72, 0x02, 0x0D, 0xA0,
  0xFB, 0x81, 0xDF, 0x32,
  // "Ì" (U+00CC)
  0x38, 0x13, 0xF7, 0x60, 0x80, 0xC7, 0x0B, 0x02, 0x75, 0x09, 0xB0, 0xD4, 0x81, 0x8F, 0x65, 0x81,
  0x9F, 0x15, 0x00, 0xD5, 0x81, 0x1F, 0x95, 0x81, 0x4F, 0x65, 0x81, 0x7F, 0x35, 0x0B, 0x96, 0x0E,
  0x0C, 0x58, 0x12, 0xF8, 0x58, 0x15, 0xF5, 0x58, 0x1B, 0xF3, 0x30, 0x30, 0xEB, 0x05, 0x20,
  // "Í" (U+00CD)
  0x68, 0x17, 0xF5, 0x58, 0x11, 0xE6, 0x60, 0xB0, 0x57, 0x70, 0x9B, 0x0D, 0x58, 0x18, 0xF6, 0x68,
  0x19, 0xF1, 0x60, 0x0D, 0x68, 0x11, 0xF9, 0x68, 0x14, 0xF6, 0x68, 0x17, 0xF3, 0x60, 0xB9, 0x70,
  0xE0, 0xC6, 0x81, 0x2F, 0x86, 0x81, 0x5F, 0x56, 0x81, 0xBF, 0x34, 0x03, 0x0E, 0xB0, 0x53,
  // "Î" (U+00CE)
  0x48, 0x12, 0xFE, 0x58, 0x2D, 0x8E, 0x43, 0x83, 0xA5, 0x04, 0xA7, 0x40, 0x9B, 0x0D, 0x48, 0x18,
  0xF6, 0x58, 0x19, 0xF1, 0x50, 0x0D, 0x58, 0x11, 0xF9, 0x58, 0x14, 0xF6, 0x58, 0x17, 0xF3, 0x50,
  0xB9, 0x60, 0xE0, 0xC5, 0x81, 0x2F, 0x85, 0x81, 0x5F, 0x55, 0x81, 0xBF, 0x33, 0x03, 0x0E, 0xB0,
  0x52,
  // "Ï" (U+00CF)
  0x38, 0x34, 0xC0, 0x5C, 0x38, 0x36, 0xC0, 0x6C, 0x77, 0x50, 0x9B, 0x0D, 0x48, 0x18, 0xF6, 0x58,
  0x19, 0xF1, 0x50, 0x0D, 0x58, 0x11, 0xF9, 0x58, 0x14, 0xF6, 0x58, 0x17, 0xF3, 0x50, 0xB9, 0x60,
  0xE0, 0xC5, 0x81, 0x2F, 0x85, 0x81, 0x5F, 0x55, 0x81, 0xBF, 0x33, 0x03, 0x0E, 0xB0, 0x52,
  // "Ð" (U+00D0)
  0x30, 0x9A, 0x83, 0xED, 0xEB, 0x36, 0x86, 0x8F, 0x30, 0x1B, 0xF3, 0x50, 0x99, 0x38, 0x11, 0xFB,
  0x50, 0x0D, 0x40, 0xD9, 0x59, 0x0A, 0x48, 0x1B, 0xF1, 0x38, 0x13, 0xF7, 0x48, 0x1C, 0xF1, 0x28,
  0x4C, 0xEF, 0xED, 0xB2, 0x0D, 0x94, 0x0A, 0x94, 0x81, 0x1F, 0xC4, 0x0D, 0x0C, 0x48, 0x16, 0xF7,
  0x38, 0x11, 0xF9, 0x48, 0x1D, 0xE1, 0x38, 0x14, 0xF6, 0x38, 0x18, 0xF6, 0x48, 0x69, 0xF2, 0x01,
  0x9F, 0x73, 0x02, 0x0C, 0xA8, 0x3D, 0xEE, 0xA3, 0x40,
  // "Ñ" (U+00D1)
  0x68, 0x43, 0xCD, 0x50, 0x97, 0x28, 0x49, 0x04, 0xCC, 0x37, 0x77, 0x09, 0xA0, 0x73, 0x09, 0xA0,
  0xE0, 0x34, 0x81, 0x8F, 0xC4, 0x08, 0x0B, 0x68, 0x29, 0xDF, 0x23, 0x0A, 0x05, 0x68, 0x2D, 0x4F,
  0x73, 0x0D, 0x02, 0x58, 0x31, 0xD0, 0xDC, 0x20, 0x10, 0xE6, 0x87, 0x4A, 0x08, 0xF2, 0x04, 0xB6,
  0x87, 0x77, 0x02, 0xF7, 0x07, 0x76, 0x0B, 0x03, 0x28, 0x3D, 0xD0, 0xA4, 0x60, 0xE3, 0x83, 0x7F,
  0x2D, 0x15, 0x02, 0x0C, 0x38, 0x22, 0xF9, 0xD6, 0x05, 0x09, 0x48, 0x1C, 0xFA, 0x60, 0xB0, 0x84,
  0x81, 0x7F, 0x64, 0x03, 0x0E, 0xA0, 0x83, 0x81, 0x1F, 0x34,
  // "Ò" (U+00D2)
  0x48, 0x13, 0xF7, 0x72, 0x08, 0x0C, 0x73, 0x0B, 0x02, 0x77, 0x38, 0x41, 0x9D, 0xED, 0x64, 0x81,
  0x3E, 0x92, 0x81, 0x5F, 0x72, 0x81, 0x1E, 0xA4, 0x85, 0xAF, 0x10, 0xAF, 0x14, 0x84, 0x7F, 0x42,
  0xFA, 0x58, 0x47, 0xF5, 0x8F, 0x55, 0x84, 0x8F, 0x5D, 0xF1, 0x58, 0x3B, 0xF2, 0xFE, 0x68, 0x3E,
  0xE0, 0xFC, 0x58, 0x44, 0xF8, 0x0E, 0xD5, 0x85, 0xBE, 0x10, 0xAF, 0x13, 0x81, 0x4F, 0x62, 0x81,
  0x2E, 0xA2, 0x81, 0x4E, 0x84, 0x84, 0x2B, 0xED, 0xB4, 0x40,
  // "Ó" (U+00D3)
  0x78, 0x17, 0xF5, 0x78, 0x11, 0xE6, 0x71, 0x0B, 0x05, 0x77, 0x38, 0x41, 0x9D, 0xED, 0x64, 0x81,
  0x3E, 0x92, 0x81, 0x5F, 0x72, 0x81, 0x1E, 0xA4, 0x85, 0xAF, 0x10, 0xAF, 0x14, 0x84, 0x7F, 0x42,
  0xFA, 0x58, 0x47, 0xF5, 0x8F, 0x55, 0x84, 0x8F, 0x5D, 0xF1, 0x58, 0x3B, 0xF2, 0xFE, 0x68, 0x3E,
  0xE0, 0xFC, 0x58, 0x44, 0xF8, 0x0E, 0xD5, 0x85, 0xBE, 0x10, 0xAF, 0x13, 0x81, 0x4F, 0x62, 0x81,
  0x2E, 0xA2, 0x81, 0x4E, 0x84, 0x84, 0x2B, 0xED, 0xB4, 0x40,
  // "Ô" (U+00D4)
  0x58, 0x12, 0xFE, 0x71, 0x82, 0xD8, 0xE4, 0x68, 0x3A, 0x50, 0x4A, 0x77, 0x28, 0x41, 0x9D, 0xED,
  0x64, 0x81, 0x3E, 0x92, 0x81, 0x5F, 0x72, 0x81, 0x1E, 0xA4, 0x85, 0xAF, 0x10, 0xAF, 0x14, 0x84,
  0x7F, 0x42, 0xFA, 0x58, 0x47, 0xF5, 0x8F, 0x55, 0x84, 0x8F, 0x5D, 0xF1, 0x58, 0x3B, 0xF2, 0xFE,
  0x68, 0x3E, 0xE0, 0xFC, 0x58, 0x44, 0xF8, 0x0E, 0xD5, 0x85, 0xBE, 0x10, 0xAF, 0x13, 0x81, 0x4F,
  0x62, 0x81, 0x2E, 0xA2, 0x81, 0x4E, 0x84, 0x84, 0x2B, 0xED, 0xB4, 0x40,
  // "Õ" (U+00D5)
  0x48, 0x43, 0xCD, 0x50, 0x95, 0x84, 0x90, 0x4C, 0xC3, 0x77, 0x18, 0x41, 0x9D, 0xED, 0x64, 0x81,
  0x3E, 0x92, 0x81, 0x5F, 0x72, 0x81, 0x1E, 0xA4, 0x85, 0xAF, 0x10, 0xAF, 0x14, 0x84, 0x7F, 0x42,
  0xFA, 0x58, 0x47, 0xF5, 0x8F, 0x55, 0x84, 0x8F, 0x5D, 0xF1, 0x58, 0x3B, 0xF2, 0xFE, 0x68, 0x3E,
  0xE0, 0xFC, 0x58, 0x44, 0xF8, 0x0E, 0xD5, 0x85, 0xBE, 0x10, 0xAF, 0x13, 0x81, 0x4F, 0x62, 0x81,
  0x2E, 0xA2, 0x81, 0x4E, 0x84, 0x84, 0x2B, 0xED, 0xB4, 0x40,
  // "Ö" (U+00D6)
  0x48, 0x34, 0xC0, 0x5C, 0x68, 0x36, 0xC0, 0x6C, 0x77, 0x76, 0x84, 0x19, 0xDE, 0xD6, 0x48, 0x13,
  0xE9, 0x28, 0x15, 0xF7, 0x28, 0x11, 0xEA, 0x48, 0x5A, 0xF1, 0x0A, 0xF1, 0x48, 0x47, 0xF4, 0x2F,
  0xA5, 0x84, 0x7F, 0x58, 0xF5, 0x58, 0x48, 0xF5, 0xDF, 0x15, 0x83, 0xBF, 0x2F, 0xE6, 0x83, 0xEE,
  0x0F, 0xC5, 0x84, 0x4F, 0x80, 0xED, 0x58, 0x5B, 0xE1, 0x0A, 0xF1, 0x38, 0x14, 0xF6, 0x28, 0x12,
  0xEA, 0x28, 0x14, 0xE8, 0x48, 0x42, 0xBE, 0xDB, 0x44,
  // "×" (U+00D7)
  0x09, 0x07, 0x38, 0x6A, 0x61, 0xD5, 0x08, 0xC2, 0x83, 0x3E, 0x8D, 0x13, 0x81, 0x7F, 0x43, 0x82,
  0x2E, 0x9D, 0x38, 0x6D, 0x60, 0x9B, 0x09, 0x83, 0x81, 0xB6, 0x16,
  // "Ø" (U+00D8)
  0x72, 0x0B, 0x02, 0x38, 0x51, 0x9D, 0xED, 0x99, 0x38, 0x13, 0xE9, 0x28, 0x16, 0xF8, 0x28, 0x11,
  0xEA, 0x38, 0x68, 0xEE, 0x10, 0xAF, 0x22, 0x86, 0x3B, 0x7F, 0x42, 0xFA, 0x38, 0x6C, 0x17, 0xF6,
  0x8F, 0x52, 0x89, 0x28, 0x60, 0x8F, 0x5C, 0xF1, 0x03, 0xB2, 0x83, 0xBF, 0x2F, 0xE2, 0x0C, 0x02,
  0x28, 0x6E, 0xE0, 0xFC, 0x07, 0x62, 0x86, 0x4F, 0x80, 0xED, 0x2B, 0x38, 0x6B, 0xF1, 0x0A, 0xFC,
  0x22, 0x81, 0x4F, 0x62, 0x81, 0x2F, 0xB2, 0x81, 0x4E, 0x83, 0x85, 0x3C, 0xBE, 0xDB, 0x44, 0x05,
  0x01, 0x72,
  // "Ù" (U+00D9)
  0x48, 0x13, 0xF7, 0x73, 0x08, 0x0C, 0x74, 0x0B, 0x02, 0x77, 0x30, 0xEB, 0x82, 0x90, 0x2E, 0xA0,
  0xA2, 0x81, 0xDF, 0x24, 0x90, 0x33, 0x0E, 0x0B, 0x40, 0x20, 0xD3, 0x81, 0x2F, 0x84, 0x05, 0x09,
  0x38, 0x15, 0xF5, 0x40, 0x80, 0x63, 0x81, 0x9F, 0x14, 0x0C, 0x02, 0x30, 0xC0, 0xE5, 0x0E, 0x49,
  0x0A, 0x40, 0x30, 0xB3, 0x81, 0x3F, 0x74, 0x06, 0x08, 0x38, 0x15, 0xF5, 0x40, 0xA0, 0x43, 0x81,
  0x5F, 0x43, 0x01, 0x0D, 0x48, 0x11, 0xEB, 0x28, 0x11, 0xB4, 0x58, 0x43, 0xBE, 0xDC, 0x45,
  // "Ú" (U+00DA)
  0x78, 0x17, 0xF5, 0x71, 0x81, 0x1E, 0x67, 0x20, 0xB0, 0x57, 0x73, 0x0E, 0xB8, 0x29, 0x02, 0xEA,
  0x0A, 0x28, 0x1D, 0xF2, 0x49, 0x03, 0x30, 0xE0, 0xB4, 0x02, 0x0D, 0x38, 0x12, 0xF8, 0x40, 0x50,
  0x93, 0x81, 0x5F, 0x54, 0x08, 0x06, 0x38, 0x19, 0xF1, 0x40, 0xC0, 0x23, 0x0C, 0x0E, 0x50, 0xE4,
  0x90, 0xA4, 0x03, 0x0B, 0x38, 0x13, 0xF7, 0x40, 0x60, 0x83, 0x81, 0x5F, 0x54, 0x0A, 0x04, 0x38,
  0x15, 0xF4, 0x30, 0x10, 0xD4, 0x81, 0x1E, 0xB2, 0x81, 0x1B, 0x45, 0x84, 0x3B, 0xED, 0xC4, 0x50,
  // "Û" (U+00DB)
  0x68, 0x12, 0xFE, 0x72, 0x82, 0xD8, 0xE4, 0x78, 0x3A, 0x50, 0x4A, 0x77, 0x10, 0xEB, 0x82, 0x90,
  0x2E, 0xA0, 0xA2, 0x81, 0xDF, 0x24, 0x90, 0x33, 0x0E, 0x0B, 0x40, 0x20, 0xD3, 0x81, 0x2F, 0x84,
  0x05, 0x09, 0x38, 0x15, 0xF5, 0x40, 0x80, 0x63, 0x81, 0x9F, 0x14, 0x0C, 0x02, 0x30, 0xC0, 0xE5,
  0x0E, 0x49, 0x0A, 0x40, 0x30, 0xB3, 0x81, 0x3F, 0x74, 0x06, 0x08, 0x38, 0x15, 0xF5, 0x40, 0xA0,
  0x43, 0x81, 0x5F, 0x43, 0x01, 0x0D, 0x48, 0x11, 0xEB, 0x28, 0x11, 0xB4, 0x58, 0x43, 0xBE, 0xDC,
  0x45,
  // "Ü" (U+00DC)
  0x48, 0x34, 0xC0, 0x5C, 0x78, 0x36, 0xC0, 0x6C, 0x77, 0x77, 0x0E, 0xB8, 0x29, 0x02, 0xEA, 0x0A,
  0x28, 0x1D, 0xF2, 0x49, 0x03, 0x30, 0xE0, 0xB4, 0x02, 0x0D, 0x38, 0x12, 0xF8, 0x40, 0x50, 0x93,
  0x81, 0x5F, 0x54, 0x08, 0x06, 0x38, 0x19, 0xF1, 0x40, 0xC0, 0x23, 0x0C, 0x0E, 0x50, 0xE4, 0x90,
  0xA4, 0x03, 0x0B, 0x38, 0x13, 0xF7, 0x40, 0x60, 0x83, 0x81, 0x5F, 0x54, 0x0A, 0x04, 0x38, 0x15,
  0xF4, 0x30, 0x10, 0xD4, 0x81, 0x1E, 0xB2, 0x81, 0x1B, 0x45, 0x84, 0x3B, 0xED, 0xC4, 0x50,
  // "Ý" (U+00DD)
  0x68, 0x17, 0xF5, 0x78, 0x11, 0xE6, 0x71, 0x0B, 0x05, 0x77, 0x10, 0x4B, 0x82, 0xD0, 0x3E, 0xA8,
  0x38, 0x07, 0xF8, 0x38, 0x11, 0xF5, 0x28, 0x12, 0xF9, 0x30, 0x70, 0x94, 0x00, 0xD2, 0x02, 0x0C,
  0x58, 0x49, 0xF2, 0x0C, 0x35, 0x83, 0x4F, 0x68, 0x77, 0x90, 0x0B, 0x71, 0x81, 0xCF, 0x27, 0x10,
  0xE0, 0xC7, 0x18, 0x11, 0xF9, 0x71, 0x81, 0x5F, 0x67, 0x18, 0x1A, 0xF4, 0x60, 0x50, 0xEB, 0x08,
  0x50,
  // "Þ" (U+00DE)
  0x30, 0x9B, 0x0E, 0x01, 0x68, 0x18, 0xF5, 0x71, 0x84, 0x9F, 0xDD, 0x91, 0x58, 0x4D, 0xB0, 0x2D,
  0xD4, 0x81, 0x1F, 0x82, 0x81, 0x7F, 0x43, 0x81, 0x4F, 0x52, 0x81, 0x5F, 0x63, 0x81, 0x7F, 0x22,
  0x81, 0x7F, 0x43, 0x0B, 0x0E, 0x38, 0x1C, 0xE1, 0x38, 0x5E, 0xB0, 0x19, 0xF6, 0x38, 0x52, 0xFE,
  0xDD, 0xA3, 0x48, 0x15, 0xF4, 0x71, 0x81, 0xBF, 0x36, 0x03, 0x0E, 0xB0, 0x75,
  // "ß" (U+00DF)
  0x78, 0x33, 0xBD, 0xD9, 0x78, 0x54, 0xF7, 0x01, 0xE8, 0x60, 0x0C, 0x30, 0x0B, 0x58, 0x11, 0xF7,
  0x30, 0xC0, 0xB4, 0x87, 0x8E, 0xF4, 0x19, 0xDD, 0x75, 0x84, 0x9F, 0x1A, 0xC1, 0x78, 0x3C, 0xD0,
  0xE8, 0x71, 0x98, 0x29, 0x0E, 0xC7, 0x86, 0x3F, 0x60, 0x6F, 0xC1, 0x58, 0x16, 0xF3, 0x28, 0x16,
  0xFA, 0x50, 0xA9, 0x40, 0xA9, 0x58, 0x2D, 0xB2, 0xD2, 0x07, 0x94, 0x87, 0x1F, 0x84, 0xF3, 0x0C,
  0xA4, 0x87, 0x4F, 0x50, 0x9E, 0xD9, 0x14, 0x81, 0x7F, 0x17, 0x30, 0xC0, 0xB7, 0x38, 0x15, 0xF4,
  0x71, 0x82, 0x2D, 0xD5, 0x72,
  // "à" (U+00E0)
  0x38, 0x13, 0xF7, 0x70, 0x80, 0xC7, 0x10, 0xB0, 0x27, 0x78, 0x44, 0xCD, 0xC8, 0x92, 0x85, 0x4F,
  0x60, 0x5F, 0x62, 0x0D, 0x09, 0x28, 0x56, 0xF3, 0x07, 0xF2, 0x20, 0x99, 0x20, 0x0D, 0x38, 0x4C,
  0xC0, 0x1F, 0x92, 0x85, 0x1F, 0x90, 0x3F, 0x72, 0x85, 0x6F, 0x60, 0x3F, 0x72, 0x8A, 0x4C, 0xF4,
  0x01, 0xFA, 0x09, 0x7F, 0x31, 0x06, 0xEB, 0x32, 0xED, 0x70,
  // "á" (U+00E1)
  0x68, 0x17, 0xF5, 0x58, 0x11, 0xE6, 0x60, 0xB0, 0x57, 0x78, 0x44, 0xCD, 0xC8, 0x92, 0x85, 0x4F,
  0x60, 0x5F, 0x62, 0x0D, 0x09, 0x28, 0x56, 0xF3, 0x07, 0xF2, 0x20, 0x99, 0x20, 0x0D, 0x38, 0x4C,
  0xC0, 0x1F, 0x92, 0x85, 0x1F, 0x90, 0x3F, 0x72, 0x85, 0x6F, 0x60, 0x3F, 0x72, 0x8A, 0x4C, 0xF4,
  0x01, 0xFA, 0x09, 0x7F, 0x31, 0x06, 0xEB, 0x32, 0xED, 0x70,
  // "â" (U+00E2)
  0x48, 0x12, 0xFE, 0x68, 0x2D, 0x8E, 0x44, 0x83, 0xA5, 0x04, 0xA7, 0x68, 0x44, 0xCD, 0xC8, 0x92,
  0x85, 0x4F, 0x60, 0x5F, 0x62, 0x0D, 0x09, 0x28, 0x56, 0xF3, 0x07, 0xF2, 0x20, 0x99, 0x20, 0x0D,
  0x38, 0x4C, 0xC0, 0x1F, 0x92, 0x85, 0x1F, 0x90, 0x3F, 0x72, 0x85, 0x6F, 0x60, 0x3F, 0x72, 0x8A,
  0x4C, 0xF4, 0x01, 0xFA, 0x09, 0x7F, 0x31, 0x06, 0xEB, 0x32, 0xED, 0x70,
  // "ã" (U+00E3)
  0x38, 0x43, 0xCD, 0x50, 0x93, 0x84, 0x90, 0x4C, 0xC3, 0x75, 0x84, 0x4C, 0xDC, 0x89, 0x28, 0x54,
  0xF6, 0x05, 0xF6, 0x20, 0xD0, 0x92, 0x85, 0x6F, 0x30, 0x7F, 0x22, 0x09, 0x92, 0x00, 0xD3, 0x84,
  0xCC, 0x01, 0xF9, 0x28, 0x51, 0xF9, 0x03, 0xF7, 0x28, 0x56, 0xF6, 0x03, 0xF7, 0x28, 0xA4, 0xCF,
  0x40, 0x1F, 0xA0, 0x97, 0xF3, 0x10, 0x6E, 0xB3, 0x2E, 0xD7,
  // "ä" (U+00E4)
  0x38, 0x34, 0xC0, 0x5C, 0x48, 0x36, 0xC0, 0x6C, 0x77, 0x71, 0x84, 0x4C, 0xDC, 0x89, 0x28, 0x54,
  0xF6, 0x05, 0xF6, 0x20, 0xD0, 0x92, 0x85, 0x6F, 0x30, 0x7F, 0x22, 0x09, 0x92, 0x00, 0xD3, 0x84,
  0xCC, 0x01, 0xF9, 0x28, 0x51, 0xF9, 0x03, 0xF7, 0x28, 0x56, 0xF6, 0x03, 0xF7, 0x28, 0xA4, 0xCF,
  0x40, 0x1F, 0xA0, 0x97, 0xF3, 0x10, 0x6E, 0xB3, 0x2E, 0xD7,
  // "å" (U+00E5)
  0x48, 0x21, 0xBD, 0x75, 0x82, 0x76, 0x0D, 0x58, 0x28, 0x60, 0xD5, 0x82, 0x1C, 0xD6, 0x76, 0x84,
  0x4C, 0xDC, 0x89, 0x28, 0x54, 0xF6, 0x05, 0xF6, 0x20, 0xD0, 0x92, 0x85, 0x6F, 0x30, 0x7F, 0x22,
  0x09, 0x92, 0x00, 0xD3, 0x84, 0xCC, 0x01, 0xF9, 0x28, 0x51, 0xF9, 0x03, 0xF7, 0x28, 0x56, 0xF6,
  0x03, 0xF7, 0x28, 0xA4, 0xCF, 0x40, 0x1F, 0xA0, 0x97, 0xF3, 0x10, 0x6E, 0xB3, 0x2E, 0xD7,
  // "æ" (U+00E6)
  0x00, 0x05, 0xCD, 0xC3, 0x3B, 0xEC, 0x20, 0x06, 0xF5, 0x04, 0xEE, 0x31, 0xFA, 0x01, 0xE8, 0x00,
  0x1F, 0x80, 0x0F, 0xA0, 0x9F, 0x10, 0x07, 0xF2, 0x04, 0xF5, 0x0E, 0xC0, 0x00, 0xDD, 0x05, 0xE9,
  0x01, 0xF9, 0x00, 0x1F, 0xED, 0xB5, 0x00, 0x3F, 0x70, 0x05, 0xF7, 0x00, 0x00, 0x02, 0xF7, 0x00,
  0x9F, 0x80, 0x00, 0x00, 0x0E, 0xC0, 0x46, 0xBD, 0x10, 0x56, 0x00, 0x4D, 0xD7, 0x02, 0xBE, 0xD9,
  0x00,
  // "ç" (U+00E7)
  0x38, 0x34, 0xCE, 0xD4, 0x28, 0x90, 0x6E, 0x30, 0xDD, 0x02, 0xF7, 0x28, 0x49, 0x80, 0x9F, 0x15,
  0x0E, 0x0C, 0x58, 0x12, 0xF9, 0x58, 0x13, 0xF7, 0x58, 0x11, 0xF9, 0x68, 0x4B, 0xE1, 0x05, 0x62,
  0x83, 0x1A, 0xFE, 0x85, 0x0E, 0x04, 0x60, 0x59, 0x60, 0x60, 0xE4, 0x82, 0x6E, 0xC4, 0x30,
  // "è" (U+00E8)
  0x38, 0x13, 0xF7, 0x60, 0x80, 0xC7, 0x0B, 0x02, 0x75, 0x83, 0x4B, 0xEC, 0x22, 0x89, 0x06, 0xF3,
  0x1F, 0x90, 0x2F, 0x82, 0x98, 0xA5, 0xA0, 0x9F, 0x10, 0x5F, 0x50, 0xEC, 0x05, 0xE9, 0x02, 0xFE,
  0xDB, 0x52, 0x81, 0x3F, 0x75, 0x81, 0x1F, 0x86, 0x84, 0xBD, 0x10, 0x56, 0x28, 0x31, 0xAE, 0xD9,
  0x20,
  // "é" (U+00E9)
  0x68, 0x17, 0xF5, 0x58, 0x11, 0xE6, 0x60, 0xB0, 0x57, 0x78, 0x34, 0xBE, 0xC2, 0x38, 0x46, 0xF3,
  0x1F, 0x92, 0x81, 0x2F, 0x82, 0x90, 0xA2, 0x85, 0x9F, 0x10, 0x5F, 0x52, 0x84, 0xEC, 0x05, 0xE9,
  0x28, 0x42, 0xFE, 0xDB, 0x53, 0x81, 0x3F, 0x76, 0x81, 0x1F, 0x87, 0x84, 0xBD, 0x10, 0x56, 0x38,
  0x31, 0xAE, 0xD9, 0x30,
  // "ê" (U+00EA)
  0x48, 0x12, 0xFE, 0x58, 0x2D, 0x8E, 0x43, 0x83, 0xA5, 0x04, 0xA7, 0x48, 0x34, 0xBE, 0xC2, 0x28,
  0x90, 0x6F, 0x31, 0xF9, 0x02, 0xF8, 0x29, 0x8A, 0x5A, 0x09, 0xF1, 0x05, 0xF5, 0x0E, 0xC0, 0x5E,
  0x90, 0x2F, 0xED, 0xB5, 0x28, 0x13, 0xF7, 0x58, 0x11, 0xF8, 0x68, 0x4B, 0xD1, 0x05, 0x62, 0x83,
  0x1A, 0xED, 0x92,
  // "ë" (U+00EB)
  0x38, 0x34, 0xC0, 0x5C, 0x38, 0x36, 0xC0, 0x6C, 0x77, 0x58, 0x34, 0xBE, 0xC2, 0x28, 0x90, 0x6F,
  0x31, 0xF9, 0x02, 0xF8, 0x29, 0x8A, 0x5A, 0x09, 0xF1, 0x05, 0xF5, 0x0E, 0xC0, 0x5E, 0x90, 0x2F,
  0xED, 0xB5, 0x28, 0x13, 0xF7, 0x58, 0x11, 0xF8, 0x68, 0x4B, 0xD1, 0x05, 0x62, 0x83, 0x1A, 0xED,
  0x92,
  // "ì" (U+00EC)
  0x3F, 0x70, 0x08, 0xC0, 0x00, 0xB2, 0x00, 0x00, 0x9F, 0xF3, 0x0B, 0xF0, 0x0C, 0xC0, 0x0F, 0x90,
  0x3F, 0x50, 0x6F, 0x20, 0x9F, 0x00, 0xCC, 0x00, 0xCC, 0x01, 0x6E, 0xB3,
  // "í" (U+00ED)
  0x38, 0x17, 0xF5, 0x28, 0x11, 0xE6, 0x30, 0xB0, 0x57, 0x10, 0x9A, 0x03, 0x30, 0xB9, 0x40, 0x0C,
  0x49, 0x09, 0x38, 0x13, 0xF5, 0x38, 0x16, 0xF2, 0x30, 0x99, 0x40, 0x0C, 0x48, 0x2C, 0xC0, 0x12,
  0x82, 0x6E, 0xB3, 0x20,
  // "î" (U+00EE)
  0x02, 0xFE, 0x00, 0xD8, 0xE4, 0xA5, 0x04, 0xA0, 0x00, 0x00, 0x9F, 0xF3, 0x00, 0xBF, 0x00, 0x0C,
  0xC0, 0x00, 0xF9, 0x00, 0x3F, 0x50, 0x06, 0xF2, 0x00, 0x9F, 0x00, 0x0C, 0xC0, 0x00, 0xCC, 0x01,
  0x06, 0xEB, 0x30,
  // "ï" (U+00EF)
  0x89, 0x04, 0xC0, 0x5C, 0x6C, 0x06, 0xC7, 0x30, 0x9A, 0x03, 0x20, 0xB9, 0x30, 0x0C, 0x39, 0x09,
  0x28, 0x13, 0xF5, 0x28, 0x16, 0xF2, 0x20, 0x99, 0x30, 0x0C, 0x38, 0x7C, 0xC0, 0x10, 0x6E, 0xB3,
  0x10,
  // "ð" (U+00F0)
  0x00, 0x01, 0x50, 0x00, 0x30, 0x00, 0x1B, 0xC5, 0xC4, 0x00, 0x00, 0x2E, 0xF1, 0x00, 0x00, 0x3B,
  0x3D, 0x80, 0x00, 0x01, 0x00, 0x6E, 0x00, 0x00, 0x6C, 0xDB, 0xF4, 0x00, 0xAE, 0x30, 0xAF, 0x60,
  0x5F, 0x50, 0x04, 0xF7, 0x0C, 0xD0, 0x00, 0x4F, 0x51, 0xFA, 0x00, 0x06, 0xF3, 0x3F, 0x70, 0x00,
  0xAE, 0x02, 0xF7, 0x00, 0x1F, 0x80, 0x0C, 0xC0, 0x0B, 0xD1, 0x00, 0x2B, 0xDD, 0x91, 0x00,
  // "ñ" (U+00F1)
  0x00, 0x03, 0xCD, 0x50, 0x90, 0x00, 0x90, 0x4C, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF2,
  0x8D, 0xD1, 0x00, 0xCE, 0x72, 0x4F, 0x60, 0x0C, 0xF5, 0x03, 0xF6, 0x00, 0xFC, 0x00, 0x6F, 0x40,
  0x3F, 0x60, 0x09, 0xF1, 0x06, 0xF2, 0x00, 0xCD, 0x00, 0xAE, 0x00, 0x0F, 0xA0, 0x0D, 0xB0, 0x02,
  0xF7, 0x00, 0xF8, 0x00, 0x2F, 0x71, 0x4F, 0x50, 0x00, 0xBE, 0x90,
  // "ò" (U+00F2)
  0x38, 0x13, 0xF7, 0x70, 0x80, 0xC7, 0x10, 0xB0, 0x27, 0x78, 0x35, 0xCD, 0xD4, 0x38, 0x91, 0x6E,
  0x30, 0x9F, 0x10, 0x2F, 0x72, 0x85, 0x3F, 0x60, 0x9F, 0x12, 0x84, 0x3F, 0x70, 0xEB, 0x38, 0x44,
  0xF6, 0x2F, 0x83, 0x84, 0x7F, 0x33, 0xF7, 0x38, 0x4B, 0xE0, 0x1F, 0x82, 0x81, 0x2F, 0x62, 0x84,
  0xCC, 0x01, 0xCB, 0x38, 0x31, 0xBE, 0xD8, 0x30,
  // "ó" (U+00F3)
  0x68, 0x17, 0xF5, 0x58, 0x11, 0xE6, 0x60, 0xB0, 0x57, 0x78, 0x35, 0xCD, 0xD4, 0x38, 0x91, 0x6E,
  0x30, 0x9F, 0x10, 0x2F, 0x72, 0x85, 0x3F, 0x60, 0x9F, 0x12, 0x84, 0x3F, 0x70, 0xEB, 0x38, 0x44,
  0xF6, 0x2F, 0x83, 0x84, 0x7F, 0x33, 0xF7, 0x38, 0x4B, 0xE0, 0x1F, 0x82, 0x81, 0x2F, 0x62, 0x84,
  0xCC, 0x01, 0xCB, 0x38, 0x31, 0xBE, 0xD8, 0x30,
  // "ô" (U+00F4)
  0x48, 0x12, 0xFE, 0x68, 0x2D, 0x8E, 0x44, 0x83, 0xA5, 0x04, 0xA7, 0x68, 0x35, 0xCD, 0xD4, 0x38,
  0x91, 0x6E, 0x30, 0x9F, 0x10, 0x2F, 0x72, 0x85, 0x3F, 0x60, 0x9F, 0x12, 0x84, 0x3F, 0x70, 0xEB,
  0x38, 0x44, 0xF6, 0x2F, 0x83, 0x84, 0x7F, 0x33, 0xF7, 0x38, 0x4B, 0xE0, 0x1F, 0x82, 0x81, 0x2F,
  0x62, 0x84, 0xCC, 0x01, 0xCB, 0x38, 0x31, 0xBE, 0xD8, 0x30,
  // "õ" (U+00F5)
  0x38, 0x43, 0xCD, 0x50, 0x93, 0x84, 0x90, 0x4C, 0xC3, 0x75, 0x83, 0x5C, 0xDD, 0x43, 0x89, 0x16,
  0xE3, 0x09, 0xF1, 0x02, 0xF7, 0x28, 0x53, 0xF6, 0x09, 0xF1, 0x28, 0x43, 0xF7, 0x0E, 0xB3, 0x84,
  0x4F, 0x62, 0xF8, 0x38, 0x47, 0xF3, 0x3F, 0x73, 0x84, 0xBE, 0x01, 0xF8, 0x28, 0x12, 0xF6, 0x28,
  0x4C, 0xC0, 0x1C, 0xB3, 0x83, 0x1B, 0xED, 0x83,
  // "ö" (U+00F6)
  0x38, 0x34, 0xC0, 0x5C, 0x48, 0x36, 0xC0, 0x6C, 0x77, 0x71, 0x83, 0x5C, 0xDD, 0x43, 0x89, 0x16,
  0xE3, 0x09, 0xF1, 0x02, 0xF7, 0x28, 0x53, 0xF6, 0x09, 0xF1, 0x28, 0x43, 0xF7, 0x0E, 0xB3, 0x84,
  0x4F, 0x62, 0xF8, 0x38, 0x47, 0xF3, 0x3F, 0x73, 0x84, 0xBE, 0x01, 0xF8, 0x28, 0x12, 0xF6, 0x28,
  0x4C, 0xC0, 0x1C, 0xB3, 0x83, 0x1B, 0xED, 0x83,
  // "÷" (U+00F7)
  0x28, 0x14, 0xD1, 0x48, 0x14, 0xD1, 0x77, 0x20, 0xC8, 0x01, 0xD0, 0x97, 0x72, 0x81, 0x4D, 0x14,
  0x81, 0x4D, 0x12,
  // "ø" (U+00F8)
  0x70, 0x10, 0xC3, 0x84, 0x5C, 0xDD, 0xB4, 0x28, 0xF2, 0x6E, 0x30, 0x9F, 0x10, 0x2F, 0x70, 0x1D,
  0xF6, 0x09, 0xF1, 0x0B, 0x6F, 0x70, 0xEB, 0x07, 0x74, 0xF6, 0x2F, 0x83, 0xB0, 0x7F, 0x33, 0xF8,
  0xC1, 0x0B, 0xE0, 0x1F, 0xE5, 0x02, 0xF6, 0x28, 0x4C, 0xD0, 0x1C, 0xB2, 0x84, 0x2C, 0xBE, 0xD8,
  0x30, 0x50, 0x17,
  // "ù" (U+00F9)
  0x28, 0x13, 0xF7, 0x70, 0x80, 0xC7, 0x10, 0xB0, 0x27, 0x50, 0xBA, 0x03, 0x20, 0xB0, 0xD2, 0x0B,
  0x93, 0x0E, 0x0A, 0x20, 0x0C, 0x28, 0x12, 0xF7, 0x29, 0x09, 0x28, 0x55, 0xF4, 0x03, 0xF6, 0x28,
  0x58, 0xF1, 0x07, 0xF3, 0x20, 0xC0, 0xD2, 0x0A, 0x92, 0x81, 0x3F, 0xA2, 0x0C, 0x0D, 0x28, 0x1A,
  0xF8, 0x28, 0xA0, 0xDD, 0x07, 0x6F, 0x81, 0x06, 0xEC, 0x40, 0xBE, 0x91,
  // "ú" (U+00FA)
  0x58, 0x17, 0xF5, 0x58, 0x11, 0xE6, 0x60, 0xB0, 0x57, 0x50, 0xBA, 0x03, 0x20, 0xB0, 0xD2, 0x0B,
  0x93, 0x0E, 0x0A, 0x20, 0x0C, 0x28, 0x12, 0xF7, 0x29, 0x09, 0x28, 0x55, 0xF4, 0x03, 0xF6, 0x28,
  0x58, 0xF1, 0x07, 0xF3, 0x20, 0xC0, 0xD2, 0x0A, 0x92, 0x81, 0x3F, 0xA2, 0x0C, 0x0D, 0x28, 0x1A,
  0xF8, 0x28, 0xA0, 0xDD, 0x07, 0x6F, 0x81, 0x06, 0xEC, 0x40, 0xBE, 0x91,
  // "û" (U+00FB)
  0x48, 0x12, 0xFE, 0x68, 0x2D, 0x8E, 0x44, 0x83, 0xA5, 0x04, 0xA7, 0x30, 0xBA, 0x03, 0x20, 0xB0,
  0xD2, 0x0B, 0x93, 0x0E, 0x0A, 0x20, 0x0C, 0x28, 0x12, 0xF7, 0x29, 0x09, 0x28, 0x55, 0xF4, 0x03,
  0xF6, 0x28, 0x58, 0xF1, 0x07, 0xF3, 0x20, 0xC0, 0xD2, 0x0A, 0x92, 0x81, 0x3F, 0xA2, 0x0C, 0x0D,
  0x28, 0x1A, 0xF8, 0x28, 0xA0, 0xDD, 0x07, 0x6F, 0x81, 0x06, 0xEC, 0x40, 0xBE, 0x91,
  // "ü" (U+00FC)
  0x38, 0x34, 0xC0, 0x5C, 0x48, 0x36, 0xC0, 0x6C, 0x77, 0x50, 0xBA, 0x03, 0x20, 0xB0, 0xD2, 0x0B,
  0x93, 0x0E, 0x0A, 0x20, 0x0C, 0x28, 0x12, 0xF7, 0x29, 0x09, 0x28, 0x55, 0xF4, 0x03, 0xF6, 0x28,
  0x58, 0xF1, 0x07, 0xF3, 0x20, 0xC0, 0xD2, 0x0A, 0x92, 0x81, 0x3F, 0xA2, 0x0C, 0x0D, 0x28, 0x1A,
  0xF8, 0x28, 0xA0, 0xDD, 0x07, 0x6F, 0x81, 0x06, 0xEC, 0x40, 0xBE, 0x91,
  // "ý" (U+00FD)
  0x71, 0x81, 0x7F, 0x57, 0x18, 0x11, 0xE6, 0x72, 0x0B, 0x05, 0x77, 0x48, 0x18, 0xFE, 0x30, 0xB0,
  0xC5, 0x81, 0x9F, 0x22, 0x81, 0x8F, 0x14, 0x81, 0x5F, 0x52, 0x04, 0x95, 0x81, 0x1F, 0x82, 0x06,
  0x0B, 0x60, 0xD0, 0xB2, 0x0B, 0x05, 0x68, 0x3A, 0xE0, 0x2D, 0x78, 0x37, 0xF2, 0x96, 0x78, 0x23,
  0xF7, 0xC7, 0x2A, 0x04, 0x72, 0x0C, 0x0A, 0x72, 0x81, 0x3E, 0x17, 0x18, 0x11, 0xD5, 0x71, 0x81,
  0x5E, 0x76, 0x83, 0x6D, 0xDB, 0x47,
  // "þ" (U+00FE)
  0x20, 0x1A, 0x0C, 0x78, 0x11, 0xF9, 0x78, 0x13, 0xF6, 0x78, 0x16, 0xF3, 0x78, 0x49, 0xE1, 0xBE,
  0x84, 0x85, 0xDB, 0x80, 0x8F, 0x23, 0x98, 0x4D, 0x10, 0x5F, 0x52, 0x81, 0x4F, 0x82, 0x81, 0x5F,
  0x52, 0x81, 0x7F, 0x22, 0x81, 0x7F, 0x32, 0x0A, 0x0E, 0x30, 0xB0, 0xE3, 0x0E, 0x0B, 0x28, 0x11,
  0xF9, 0x28, 0x11, 0xF7, 0x28, 0x18, 0xF2, 0x28, 0x55, 0xF7, 0x04, 0xF6, 0x38, 0x48, 0xFB, 0xDC,
  0x54, 0x0B, 0x0D, 0x71, 0x0E, 0x09, 0x78, 0x12, 0xF8, 0x70, 0x6A, 0x09, 0x60,
  // "ÿ" (U+00FF)
  0x58, 0x34, 0xC0, 0x5C, 0x78, 0x36, 0xC0, 0x6C, 0x77, 0x77, 0x18, 0x18, 0xFE, 0x30, 0xB0, 0xC5,
  0x81, 0x9F, 0x22, 0x81, 0x8F, 0x14, 0x81, 0x5F, 0x52, 0x04, 0x95, 0x81, 0x1F, 0x82, 0x06, 0x0B,
  0x60, 0xD0, 0xB2, 0x0B, 0x05, 0x68, 0x3A, 0xE0, 0x2D, 0x78, 0x37, 0xF2, 0x96, 0x78, 0x23, 0xF7,
  0xC7, 0x2A, 0x04, 0x72, 0x0C, 0x0A, 0x72, 0x81, 0x3E, 0x17, 0x18, 0x11, 0xD5, 0x71, 0x81, 0x5E,
  0x76, 0x83, 0x6D, 0xDB, 0x47,
  // "Ā" (U+0100)
  0x68, 0x3B, 0xDD, 0xD8, 0x77, 0x68, 0x18, 0xF2, 0x71, 0x82, 0x1E, 0xF4, 0x71, 0x82, 0x89, 0xF6,
  0x78, 0x31, 0xD3, 0xF7, 0x78, 0x39, 0x71, 0xF9, 0x60, 0x20, 0xE2, 0x90, 0xA6, 0x0A, 0x07, 0x20,
  0xE0, 0xC5, 0x03, 0x0E, 0x30, 0x0D, 0x50, 0xB8, 0x00, 0xEA, 0x40, 0x40, 0xE4, 0x81, 0xAF, 0x13,
  0x0C, 0x05, 0x48, 0x18, 0xF2, 0x20, 0x69, 0x58, 0x3A, 0xF5, 0x0A, 0xA8, 0x3E, 0x10, 0x1E, 0xB0,
  0x30,
  // "ā" (U+0101)
  0x48, 0x3B, 0xDD, 0xD8, 0x75, 0x84, 0x4C, 0xDC, 0x89, 0x28, 0x54, 0xF6, 0x05, 0xF6, 0x20, 0xD0,
  0x92, 0x85, 0x6F, 0x30, 0x7F, 0x22, 0x09, 0x92, 0x00, 0xD3, 0x84, 0xCC, 0x01, 0xF9, 0x28, 0x51,
  0xF9, 0x03, 0xF7, 0x28, 0x56, 0xF6, 0x03, 0xF7, 0x28, 0xA4, 0xCF, 0x40, 0x1F, 0xA0, 0x97, 0xF3,
  0x10, 0x6E, 0xB3, 0x2E, 0xD7,
  // "Ă" (U+0102)
  0x60, 0x30, 0x22, 0x06, 0x78, 0x35, 0x90, 0x59, 0x71, 0x81, 0xAD, 0x97, 0x77, 0x81, 0x8F, 0x27,
  0x18, 0x21, 0xEF, 0x47, 0x18, 0x28, 0x9F, 0x67, 0x83, 0x1D, 0x3F, 0x77, 0x83, 0x97, 0x1F, 0x96,
  0x02, 0x0E, 0x29, 0x0A, 0x60, 0xA0, 0x72, 0x0E, 0x0C, 0x50, 0x30, 0xE3, 0x00, 0xD5, 0x0B, 0x80,
  0x0E, 0xA4, 0x04, 0x0E, 0x48, 0x1A, 0xF1, 0x30, 0xC0, 0x54, 0x81, 0x8F, 0x22, 0x06, 0x95, 0x83,
  0xAF, 0x50, 0xAA, 0x83, 0xE1, 0x01, 0xEB, 0x03,
  // "ă" (U+0103)
  0x30, 0x30, 0x22, 0x06, 0x48, 0x35, 0x90, 0x59, 0x58, 0x1A, 0xD9, 0x77, 0x84, 0x4C, 0xDC, 0x89,
  0x28, 0x54, 0xF6, 0x05, 0xF6, 0x20, 0xD0, 0x92, 0x85, 0x6F, 0x30, 0x7F, 0x22, 0x09, 0x92, 0x00,
  0xD3, 0x84, 0xCC, 0x01, 0xF9, 0x28, 0x51, 0xF9, 0x03, 0xF7, 0x28, 0x56, 0xF6, 0x03, 0xF7, 0x28,
  0xA4, 0xCF, 0x40, 0x1F, 0xA0, 0x97, 0xF3, 0x10, 0x6E, 0xB3, 0x2E, 0xD7,
  // "Ą" (U+0104)
  0x78, 0x18, 0xF2, 0x71, 0x82, 0x1E, 0xF4, 0x71, 0x82, 0x89, 0xF6, 0x78, 0x31, 0xD3, 0xF7, 0x78,
  0x39, 0x71, 0xF9, 0x60, 0x20, 0xE2, 0x90, 0xA6, 0x0A, 0x07, 0x20, 0xE0, 0xC5, 0x03, 0x0E, 0x30,
  0x0D, 0x50, 0xB8, 0x00, 0xEA, 0x40, 0x40, 0xE4, 0x81, 0xAF, 0x13, 0x0C, 0x05, 0x48, 0x18, 0xF2,
  0x20, 0x69, 0x58, 0x3A, 0xF5, 0x0A, 0xA8, 0x3E, 0x10, 0x1E, 0xB0, 0x37, 0x81, 0x1C, 0x47, 0x20,
  0x90, 0xA7, 0x30, 0x0B, 0x73, 0x82, 0x5F, 0xE4, 0x10,
  // "ą" (U+0105)
  0x38, 0x44, 0xCD, 0xC8, 0x92, 0x85, 0x4F, 0x60, 0x5F, 0x62, 0x0D, 0x09, 0x28, 0x56, 0xF3, 0x07,
  0xF2, 0x20, 0x99, 0x20, 0x0D, 0x38, 0x4C, 0xC0, 0x1F, 0x92, 0x85, 0x1F, 0x90, 0x3F, 0x72, 0x85,
  0x6F, 0x60, 0x3F, 0x72, 0x8A, 0x4C, 0xF4, 0x01, 0xFA, 0x09, 0x7F, 0x31, 0x06, 0xEB, 0x33, 0xFE,
  0x74, 0x81, 0x1C, 0x46, 0x09, 0x0A, 0x70, 0x0B, 0x78, 0x25, 0xFE, 0x41,
  // "Ć" (U+0106)
  0x78, 0x17, 0xF5, 0x68, 0x11, 0xE6, 0x70, 0xB0, 0x57, 0x71, 0x84, 0x17, 0xCD, 0xE9, 0x38, 0x92,
  0x3D, 0xA1, 0x08, 0xF6, 0x01, 0xEB, 0x38, 0x53, 0xF5, 0x0B, 0xF2, 0x48, 0x33, 0x03, 0xFA, 0x78,
  0x19, 0xF5, 0x78, 0x1C, 0xF1, 0x79, 0x0E, 0x71, 0x90, 0xC7, 0x10, 0xE0, 0xD7, 0x18, 0x1B, 0xF1,
  0x40, 0x22, 0x86, 0x3F, 0xA1, 0x01, 0x95, 0x38, 0x43, 0xBE, 0xDC, 0x63,
  // "ć" (U+0107)
  0x68, 0x17, 0xF5, 0x58, 0x11, 0xE6, 0x60, 0xB0, 0x57, 0x78, 0x34, 0xCE, 0xD4, 0x38, 0x46, 0xE3,
  0x0D, 0xD2, 0x81, 0x2F, 0x72, 0x09, 0x08, 0x28, 0x19, 0xF1, 0x60, 0xE0, 0xC6, 0x81, 0x2F, 0x96,
  0x81, 0x3F, 0x76, 0x81, 0x1F, 0x97, 0x84, 0xBE, 0x10, 0x56, 0x38, 0x31, 0xAE, 0xD8, 0x30,
  // "Ĉ" (U+0108)
  0x58, 0x12, 0xFE, 0x78, 0x2D, 0x8E, 0x45, 0x83, 0xA5, 0x04, 0xA7, 0x78, 0x41, 0x7C, 0xDE, 0x93,
  0x89, 0x23, 0xDA, 0x10, 0x8F, 0x60, 0x1E, 0xB3, 0x85, 0x3F, 0x50, 0xBF, 0x24, 0x83, 0x30, 0x3F,
  0xA7, 0x81, 0x9F, 0x57, 0x81, 0xCF, 0x17, 0x90, 0xE7, 0x19, 0x0C, 0x71, 0x0E, 0x0D, 0x71, 0x81,
  0xBF, 0x14, 0x02, 0x28, 0x63, 0xFA, 0x10, 0x19, 0x53, 0x84, 0x3B, 0xED, 0xC6, 0x30,
  // "ĉ" (U+0109)
  0x48, 0x12, 0xFE, 0x58, 0x2D, 0x8E, 0x43, 0x83, 0xA5, 0x04, 0xA7, 0x48, 0x34, 0xCE, 0xD4, 0x28,
  0x90, 0x6E, 0x30, 0xDD, 0x02, 0xF7, 0x28, 0x49, 0x80, 0x9F, 0x15, 0x0E, 0x0C, 0x58, 0x12, 0xF9,
  0x58, 0x13, 0xF7, 0x58, 0x11, 0xF9, 0x68, 0x4B, 0xE1, 0x05, 0x62, 0x83, 0x1A, 0xED, 0x82,
  // "Ċ" (U+010A)
  0x68, 0x16, 0xF3, 0x78, 0x16, 0xD2, 0x77, 0x73, 0x84, 0x17, 0xCD, 0xE9, 0x38, 0x92, 0x3D, 0xA1,
  0x08, 0xF6, 0x01, 0xEB, 0x38, 0x53, 0xF5, 0x0B, 0xF2, 0x48, 0x33, 0x03, 0xFA, 0x78, 0x19, 0xF5,
  0x78, 0x1C, 0xF1, 0x79, 0x0E, 0x71, 0x90, 0xC7, 0x10, 0xE0, 0xD7, 0x18, 0x1B, 0xF1, 0x40, 0x22,
  0x86, 0x3F, 0xA1, 0x01, 0x95, 0x38, 0x43, 0xBE, 0xDC, 0x63,
  // "ċ" (U+010B)
  0x58, 0x16, 0xF3, 0x58, 0x16, 0xD2, 0x77, 0x58, 0x34, 0xCE, 0xD4, 0x28, 0x90, 0x6E, 0x30, 0xDD,
  0x02, 0xF7, 0x28, 0x49, 0x80, 0x9F, 0x15, 0x0E, 0x0C, 0x58, 0x12, 0xF9, 0x58, 0x13, 0xF7, 0x58,
  0x11, 0xF9, 0x68, 0x4B, 0xE1, 0x05, 0x62, 0x83, 0x1A, 0xED, 0x82,
  // "Č" (U+010C)
  0x58, 0x44, 0x90, 0x2C, 0x26, 0x82, 0xD7, 0xE4, 0x78, 0x19, 0xF7, 0x77, 0x28, 0x41, 0x7C, 0xDE,
  0x94, 0x86, 0x3D, 0xA1, 0x08, 0xF6, 0x28, 0x11, 0xEB, 0x38, 0x13, 0xF5, 0x28, 0x1B, 0xF2, 0x40,
  0x32, 0x81, 0x3F, 0xA7, 0x18, 0x19, 0xF5, 0x71, 0x81, 0xCF, 0x17, 0x19, 0x0E, 0x72, 0x90, 0xC7,
  0x20, 0xE0, 0xD7, 0x28, 0x1B, 0xF1, 0x40, 0x23, 0x86, 0x3F, 0xA1, 0x01, 0x95, 0x48, 0x43, 0xBE,
  0xDC, 0x64,
  // "č" (U+010D)
  0x48, 0x44, 0x90, 0x2C, 0x25, 0x82, 0xD7, 0xE4, 0x68, 0x19, 0xF7, 0x77, 0x18, 0x34, 0xCE, 0xD4,
  0x48, 0x46, 0xE3, 0x0D, 0xD3, 0x81, 0x2F, 0x72, 0x09, 0x08, 0x38, 0x19, 0xF1, 0x70, 0xE0, 0xC7,
  0x81, 0x2F, 0x97, 0x81, 0x3F, 0x77, 0x81, 0x1F, 0x97, 0x18, 0x4B, 0xE1, 0x05, 0x64, 0x83, 0x1A,
  0xED, 0x84,
  // "Ď" (U+010E)
  0x68, 0x44, 0x90, 0x2C, 0x27, 0x18, 0x2D, 0x7E, 0x47, 0x28, 0x19, 0xF7, 0x77, 0x50, 0x9A, 0x83,
  0xED, 0xEB, 0x36, 0x86, 0x8F, 0x30, 0x1B, 0xF3, 0x50, 0xA9, 0x38, 0x11, 0xFB, 0x50, 0xD0, 0xC4,
  0x0D, 0x94, 0x81, 0x1F, 0x94, 0x81, 0xBF, 0x13, 0x81, 0x4F, 0x64, 0x81, 0xCF, 0x13, 0x81, 0x7F,
  0x34, 0x0D, 0x94, 0x0A, 0x94, 0x81, 0x1F, 0xC4, 0x0E, 0x0C, 0x48, 0x16, 0xF7, 0x38, 0x11, 0xF8,
  0x48, 0x1D, 0xE1, 0x38, 0x15, 0xF5, 0x38, 0x18, 0xF6, 0x48, 0x69, 0xF2, 0x01, 0x9F, 0x73, 0x02,
  0x0C, 0xA8, 0x3D, 0xEE, 0xA3, 0x40,
  // "ď" (U+010F)
  0x60, 0x7A, 0x82, 0x74, 0xF2, 0x78, 0x37, 0xF4, 0x97, 0x71, 0x82, 0x8F, 0x1B, 0x72, 0x0B, 0x0D,
  0x78, 0x44, 0xCD, 0xCE, 0x96, 0x85, 0x4F, 0x60, 0x5F, 0x66, 0x0E, 0x09, 0x28, 0x16, 0xF3, 0x58,
  0x17, 0xF2, 0x20, 0x99, 0x60, 0x0D, 0x30, 0x0C, 0x58, 0x11, 0xF9, 0x28, 0x11, 0xF9, 0x58, 0x13,
  0xF7, 0x28, 0x16, 0xF6, 0x58, 0x13, 0xF7, 0x28, 0x1C, 0xF4, 0x58, 0x71, 0xFA, 0x09, 0x8F, 0x41,
  0x58, 0x67, 0xEB, 0x32, 0xED, 0x74,
  // "Đ" (U+0110)
  0x30, 0x9A, 0x83, 0xED, 0xEB, 0x36, 0x86, 0x8F, 0x30, 0x1B, 0xF3, 0x50, 0x99, 0x38, 0x11, 0xFB,
  0x50, 0x0D, 0x40, 0xD9, 0x59, 0x0A, 0x48, 0x1B, 0xF1, 0x38, 0x13, 0xF7, 0x48, 0x1C, 0xF1, 0x28,
  0x4C, 0xEF, 0xED, 0xB2, 0x0D, 0x94, 0x0A, 0x94, 0x81, 0x1F, 0xC4, 0x0D, 0x0C, 0x48, 0x16, 0xF7,
  0x38, 0x11, 0xF9, 0x48, 0x1D, 0xE1, 0x38, 0x14, 0xF6, 0x38, 0x18, 0xF6, 0x48, 0x69, 0xF2, 0x01,
  0x9F, 0x73, 0x02, 0x0C, 0xA8, 0x3D, 0xEE, 0xA3, 0x40,
  // "đ" (U+0111)
  0x60, 0x7A, 0x06, 0x71, 0x81, 0x7F, 0x35, 0x85, 0x2D, 0xDE, 0xFD, 0x57, 0x00, 0xC5, 0x84, 0x4C,
  0xDB, 0xF9, 0x48, 0x55, 0xF5, 0x07, 0xF6, 0x38, 0x11, 0xE9, 0x28, 0x17, 0xF2, 0x38, 0x18, 0xF2,
  0x20, 0xA9, 0x40, 0xD0, 0xC3, 0x0D, 0x0C, 0x38, 0x12, 0xF9, 0x28, 0x12, 0xF9, 0x38, 0x13, 0xF7,
  0x28, 0x17, 0xF6, 0x38, 0x63, 0xF6, 0x01, 0xDF, 0x33, 0x87, 0x1F, 0x90, 0x97, 0xF3, 0x23, 0x86,
  0x6E, 0xB3, 0x2E, 0xD7, 0x20,
  // "Ē" (U+0112)
  0x68, 0x3B, 0xDD, 0xD8, 0x77, 0x20, 0x8A, 0x84, 0xCB, 0xBD, 0xF3, 0x48, 0x18, 0xF3, 0x20, 0x29,
  0x50, 0xA9, 0x30, 0x10, 0xD5, 0x00, 0xD4, 0x03, 0x48, 0x11, 0xFA, 0x72, 0x81, 0x4F, 0x77, 0x28,
  0x17, 0xFE, 0x0F, 0xD6, 0x0B, 0x97, 0x30, 0xE0, 0xC7, 0x28, 0x12, 0xF9, 0x72, 0x81, 0x5F, 0x63,
  0x03, 0x0B, 0x48, 0x19, 0xF3, 0x30, 0xB0, 0x72, 0x02, 0x0D, 0xA0, 0xFB, 0x81, 0xDF, 0x32,
  // "ē" (U+0113)
  0x38, 0x3B, 0xDD, 0xD8, 0x74, 0x83, 0x4B, 0xEC, 0x22, 0x89, 0x06, 0xF3, 0x1F, 0x90, 0x2F, 0x82,
  0x98, 0xA5, 0xA0, 0x9F, 0x10, 0x5F, 0x50, 0xEC, 0x05, 0xE9, 0x02, 0xFE, 0xDB, 0x52, 0x81, 0x3F,
  0x75, 0x81, 0x1F, 0x86, 0x84, 0xBD, 0x10, 0x56, 0x28, 0x31, 0xAE, 0xD9, 0x20,
  // "Ĕ" (U+0114)
  0x50, 0x30, 0x22, 0x06, 0x78, 0x35, 0x90, 0x59, 0x71, 0x81, 0xAD, 0x97, 0x74, 0x08, 0xA8, 0x4C,
  0xBB, 0xDF, 0x34, 0x81, 0x8F, 0x32, 0x02, 0x95, 0x0A, 0x93, 0x01, 0x0D, 0x50, 0x0D, 0x40, 0x34,
  0x81, 0x1F, 0xA7, 0x28, 0x14, 0xF7, 0x72, 0x81, 0x7F, 0xE0, 0xFD, 0x60, 0xB9, 0x73, 0x0E, 0x0C,
  0x72, 0x81, 0x2F, 0x97, 0x28, 0x15, 0xF6, 0x30, 0x30, 0xB4, 0x81, 0x9F, 0x33, 0x0B, 0x07, 0x20,
  0x20, 0xDA, 0x0F, 0xB8, 0x1D, 0xF3, 0x20,
  // "ĕ" (U+0115)
  0x30, 0x30, 0x22, 0x06, 0x38, 0x35, 0x90, 0x59, 0x48, 0x1A, 0xD9, 0x75, 0x83, 0x4B, 0xEC, 0x22,
  0x89, 0x06, 0xF3, 0x1F, 0x90, 0x2F, 0x82, 0x98, 0xA5, 0xA0, 0x9F, 0x10, 0x5F, 0x50, 0xEC, 0x05,
  0xE9, 0x02, 0xFE, 0xDB, 0x52, 0x81, 0x3F, 0x75, 0x81, 0x1F, 0x86, 0x84, 0xBD, 0x10, 0x56, 0x28,
  0x31, 0xAE, 0xD9, 0x20,
  // "Ė" (U+0116)
  0x78, 0x16, 0xF3, 0x72, 0x81, 0x6D, 0x27, 0x77, 0x71, 0x08, 0xA8, 0x4C, 0xBB, 0xDF, 0x34, 0x81,
  0x8F, 0x32, 0x02, 0x95, 0x0A, 0x93, 0x01, 0x0D, 0x50, 0x0D, 0x40, 0x34, 0x81, 0x1F, 0xA7, 0x28,
  0x14, 0xF7, 0x72, 0x81, 0x7F, 0xE0, 0xFD, 0x60, 0xB9, 0x73, 0x0E, 0x0C, 0x72, 0x81, 0x2F, 0x97,
  0x28, 0x15, 0xF6, 0x30, 0x30, 0xB4, 0x81, 0x9F, 0x33, 0x0B, 0x07, 0x20, 0x20, 0xDA, 0x0F, 0xB8,
  0x1D, 0xF3, 0x20,
  // "ė" (U+0117)
  0x58, 0x16, 0xF3, 0x58, 0x16, 0xD2, 0x77, 0x58, 0x34, 0xBE, 0xC2, 0x28, 0x90, 0x6F, 0x31, 0xF9,
  0x02, 0xF8, 0x29, 0x8A, 0x5A, 0x09, 0xF1, 0x05, 0xF5, 0x0E, 0xC0, 0x5E, 0x90, 0x2F, 0xED, 0xB5,
  0x28, 0x13, 0xF7, 0x58, 0x11, 0xF8, 0x68, 0x4B, 0xD1, 0x05, 0x62, 0x83, 0x1A, 0xED, 0x92,
  // "Ę" (U+0118)
  0x30, 0x8A, 0x84, 0xCB, 0xBD, 0xF3, 0x48, 0x18, 0xF3, 0x20, 0x29, 0x50, 0xA9, 0x30, 0x10, 0xD5,
  0x00, 0xD4, 0x03, 0x48, 0x11, 0xFA, 0x72, 0x81, 0x4F, 0x77, 0x28, 0x17, 0xFE, 0x0F, 0xD6, 0x0B,
  0x97, 0x30, 0xE0, 0xC7, 0x28, 0x12, 0xF9, 0x72, 0x81, 0x5F, 0x63, 0x03, 0x0B, 0x48, 0x19, 0xF3,
  0x30, 0xB0, 0x72, 0x02, 0x0D, 0xA0, 0xFB, 0xA0, 0x37, 0x81, 0x1C, 0x47, 0x20, 0x90, 0xA7, 0x30,
  0x0B, 0x73, 0x82, 0x5F, 0xE4, 0x30,
  // "ę" (U+0119)
  0x38, 0x34, 0xBE, 0xC2, 0x28, 0x90, 0x6F, 0x31, 0xF9, 0x02, 0xF8, 0x29, 0x8A, 0x5A, 0x09, 0xF1,
  0x05, 0xF5, 0x0E, 0xC0, 0x5E, 0x90, 0x2F, 0xED, 0xB5, 0x28, 0x13, 0xF7, 0x58, 0x11, 0xF8, 0x68,
  0x4B, 0xD1, 0x05, 0x62, 0x83, 0x1A, 0xEF, 0xA4, 0x81, 0x1C, 0x45, 0x09, 0x0A, 0x60, 0x0B, 0x68,
  0x25, 0xFE, 0x42,
  // "Ě" (U+011A)
  0x68, 0x44, 0x90, 0x2C, 0x27, 0x82, 0xD7, 0xE4, 0x71, 0x81, 0x9F, 0x77, 0x73, 0x08, 0xA8, 0x4C,
  0xBB, 0xDF, 0x34, 0x81, 0x8F, 0x32, 0x02, 0x95, 0x0A, 0x93, 0x01, 0x0D, 0x50, 0x0D, 0x40, 0x34,
  0x81, 0x1F, 0xA7, 0x28, 0x14, 0xF7, 0x72, 0x81, 0x7F, 0xE0, 0xFD, 0x60, 0xB9, 0x73, 0x0E, 0x0C,
  0x72, 0x81, 0x2F, 0x97, 0x28, 0x15, 0xF6, 0x30, 0x30, 0xB4, 0x81, 0x9F, 0x33, 0x0B, 0x07, 0x20,
  0x20, 0xDA, 0x0F, 0xB8, 0x1D, 0xF3, 0x20,
  // "ě" (U+011B)
  0x48, 0x44, 0x90, 0x2C, 0x25, 0x82, 0xD7, 0xE4, 0x68, 0x19, 0xF7, 0x77, 0x18, 0x34, 0xBE, 0xC2,
  0x48, 0x46, 0xF3, 0x1F, 0x93, 0x81, 0x2F, 0x82, 0x90, 0xA3, 0x85, 0x9F, 0x10, 0x5F, 0x53, 0x84,
  0xEC, 0x05, 0xE9, 0x38, 0x42, 0xFE, 0xDB, 0x54, 0x81, 0x3F, 0x77, 0x81, 0x1F, 0x87, 0x18, 0x4B,
  0xD1, 0x05, 0x64, 0x83, 0x1A, 0xED, 0x94,
  // "Ĝ" (U+011C)
  0x58, 0x12, 0xFE, 0x71, 0x82, 0xD8, 0xE4, 0x68, 0x3A, 0x50, 0x4A, 0x77, 0x38, 0x47, 0xCD, 0xEC,
  0x53, 0x89, 0x32, 0xDB, 0x20, 0x2E, 0xF1, 0x02, 0xEB, 0x48, 0x59, 0xE1, 0x0B, 0xF2, 0x40, 0x12,
  0x81, 0x3F, 0x97, 0x18, 0x19, 0xF4, 0x71, 0x0D, 0x97, 0x29, 0x0D, 0x38, 0x63, 0xEE, 0xEE, 0x1F,
  0xC4, 0x85, 0x2F, 0xC1, 0x0E, 0xD4, 0x81, 0x3F, 0x72, 0x81, 0xAF, 0x13, 0x81, 0x6F, 0x42, 0x82,
  0x3F, 0xB1, 0x20, 0xB9, 0x48, 0x53, 0xAE, 0xDD, 0xA5, 0x30,
  // "ĝ" (U+011D)
  0x58, 0x12, 0xFE, 0x71, 0x82, 0xD8, 0xE4, 0x68, 0x3A, 0x50, 0x4A, 0x73, 0x81, 0x5D, 0x64, 0x85,
  0x5C, 0xEF, 0xB5, 0x53, 0x84, 0x6E, 0x20, 0xDA, 0x50, 0xE0, 0x82, 0x0C, 0x0A, 0x48, 0x53, 0xF4,
  0x01, 0xF7, 0x48, 0x42, 0xF6, 0x09, 0xD6, 0x83, 0x8E, 0xD9, 0x15, 0x04, 0x0B, 0x72, 0x82, 0xBB,
  0x42, 0x70, 0x6B, 0x0E, 0x05, 0x48, 0x56, 0xB5, 0x58, 0xEE, 0x30, 0x50, 0xE4, 0x07, 0x93, 0x09,
  0x0B, 0x40, 0x80, 0xD3, 0x81, 0x7E, 0x22, 0x81, 0x4E, 0x54, 0x84, 0x8D, 0xDD, 0xB4, 0x40,
  // "Ğ" (U+011E)
  0x40, 0x30, 0x22, 0x06, 0x68, 0x35, 0x90, 0x59, 0x78, 0x1A, 0xD9, 0x77, 0x48, 0x47, 0xCD, 0xEC,
  0x53, 0x89, 0x32, 0xDB, 0x20, 0x2E, 0xF1, 0x02, 0xEB, 0x48, 0x59, 0xE1, 0x0B, 0xF2, 0x40, 0x12,
  0x81, 0x3F, 0x97, 0x18, 0x19, 0xF4, 0x71, 0x0D, 0x97, 0x29, 0x0D, 0x38, 0x63, 0xEE, 0xEE, 0x1F,
  0xC4, 0x85, 0x2F, 0xC1, 0x0E, 0xD4, 0x81, 0x3F, 0x72, 0x81, 0xAF, 0x13, 0x81, 0x6F, 0x42, 0x82,
  0x3F, 0xB1, 0x20, 0xB9, 0x48, 0x53, 0xAE, 0xDD, 0xA5, 0x30,
  // "ğ" (U+011F)
  0x40, 0x30, 0x22, 0x06, 0x68, 0x35, 0x90, 0x59, 0x78, 0x1A, 0xD9, 0x74, 0x81, 0x5D, 0x64, 0x85,
  0x5C, 0xEF, 0xB5, 0x53, 0x84, 0x6E, 0x20, 0xDA, 0x50, 0xE0, 0x82, 0x0C, 0x0A, 0x48, 0x53, 0xF4,
  0x01, 0xF7, 0x48, 0x42, 0xF6, 0x09, 0xD6, 0x83, 0x8E, 0xD9, 0x15, 0x04, 0x0B, 0x72, 0x82, 0xBB,
  0x42, 0x70, 0x6B, 0x0E, 0x05, 0x48, 0x56, 0xB5, 0x58, 0xEE, 0x30, 0x50, 0xE4, 0x07, 0x93, 0x09,
  0x0B, 0x40, 0x80, 0xD3, 0x81, 0x7E, 0x22, 0x81, 0x4E, 0x54, 0x84, 0x8D, 0xDD, 0xB4, 0x40,
  // "Ġ" (U+0120)
  0x68, 0x16, 0xF3, 0x71, 0x81, 0x6D, 0x27, 0x77, 0x78, 0x47, 0xCD, 0xEC, 0x53, 0x89, 0x32, 0xDB,
  0x20, 0x2E, 0xF1, 0x02, 0xEB, 0x48, 0x59, 0xE1, 0x0B, 0xF2, 0x40, 0x12, 0x81, 0x3F, 0x97, 0x18,
  0x19, 0xF4, 0x71, 0x0D, 0x97, 0x29, 0x0D, 0x38, 0x63, 0xEE, 0xEE, 0x1F, 0xC4, 0x85, 0x2F, 0xC1,
  0x0E, 0xD4, 0x81, 0x3F, 0x72, 0x81, 0xAF, 0x13, 0x81, 0x6F, 0x42, 0x82, 0x3F, 0xB1, 0x20, 0xB9,
  0x48, 0x53, 0xAE, 0xDD, 0xA5, 0x30,
  // "ġ" (U+0121)
  0x68, 0x16, 0xF3, 0x71, 0x81, 0x6D, 0x27, 0x77, 0x81, 0x5D, 0x64, 0x85, 0x5C, 0xEF, 0xB5, 0x53,
  0x84, 0x6E, 0x20, 0xDA, 0x50, 0xE0, 0x82, 0x0C, 0x0A, 0x48, 0x53, 0xF4, 0x01, 0xF7, 0x48, 0x42,
  0xF6, 0x09, 0xD6, 0x83, 0x8E, 0xD9, 0x15, 0x04, 0x0B, 0x72, 0x82, 0xBB, 0x42, 0x70, 0x6B, 0x0E,
  0x05, 0x48, 0x56, 0xB5, 0x58, 0xEE, 0x30, 0x50, 0xE4, 0x07, 0x93, 0x09, 0x0B, 0x40, 0x80, 0xD3,
  0x81, 0x7E, 0x22, 0x81, 0x4E, 0x54, 0x84, 0x8D, 0xDD, 0xB4, 0x40,
  // "Ģ" (U+0122)
  0x48, 0x47, 0xCD, 0xEC, 0x53, 0x89, 0x32, 0xDB, 0x20, 0x2E, 0xF1, 0x02, 0xEB, 0x48, 0x59, 0xE1,
  0x0B, 0xF2, 0x40, 0x12, 0x81, 0x3F, 0x97, 0x18, 0x19, 0xF4, 0x71, 0x0D, 0x97, 0x29, 0x0D, 0x38,
  0x63, 0xEE, 0xEE, 0x1F, 0xC4, 0x85, 0x2F, 0xC1, 0x0E, 0xD4, 0x81, 0x3F, 0x72, 0x81, 0xAF, 0x13,
  0x81, 0x6F, 0x42, 0x82, 0x3F, 0xB1, 0x20, 0xB9, 0x48, 0x53, 0xAE, 0xDD, 0xA5, 0x77, 0x39, 0x06,
  0x71, 0x05, 0x0C, 0x72, 0x0A, 0x02, 0x70,
  // "ģ" (U+0123)
  0x70, 0x70, 0x57, 0x10, 0x40, 0xE7, 0x20, 0x80, 0x77, 0x48, 0x15, 0xD6, 0x48, 0x55, 0xCE, 0xFB,
  0x55, 0x38, 0x46, 0xE2, 0x0D, 0xA5, 0x0E, 0x08, 0x20, 0xC0, 0xA4, 0x85, 0x3F, 0x40, 0x1F, 0x74,
  0x84, 0x2F, 0x60, 0x9D, 0x68, 0x38, 0xED, 0x91, 0x50, 0x40, 0xB7, 0x28, 0x2B, 0xB4, 0x27, 0x06,
  0xB0, 0xE0, 0x54, 0x85, 0x6B, 0x55, 0x8E, 0xE3, 0x05, 0x0E, 0x40, 0x79, 0x30, 0x90, 0xB4, 0x08,
  0x0D, 0x38, 0x17, 0xE2, 0x28, 0x14, 0xE5, 0x48, 0x48, 0xDD, 0xDB, 0x44,
  // "Ĥ" (U+0124)
  0x71, 0x81, 0x2F, 0xE7, 0x58, 0x2D, 0x8E, 0x47, 0x38, 0x3A, 0x50, 0x4A, 0x77, 0x70, 0x9B, 0x82,
  0xD0, 0x1E, 0xB0, 0x74, 0x81, 0x8F, 0x74, 0x81, 0xEE, 0x15, 0x81, 0xAF, 0x14, 0x90, 0x96, 0x00,
  0xD4, 0x81, 0x3F, 0x65, 0x81, 0x1F, 0xA4, 0x81, 0x7F, 0x35, 0x81, 0x4F, 0x74, 0x0A, 0x96, 0x87,
  0x7F, 0xED, 0xDD, 0xDF, 0xC6, 0x0B, 0x94, 0x81, 0x1F, 0x86, 0x0E, 0x0C, 0x48, 0x14, 0xF5, 0x58,
  0x12, 0xF9, 0x48, 0x18, 0xF2, 0x58, 0x15, 0xF5, 0x40, 0xB0, 0xE6, 0x81, 0xBF, 0x33, 0x81, 0x2F,
  0xC4, 0x03, 0x0E, 0xB8, 0x15, 0x09, 0xB0, 0xD3,
  // "ĥ" (U+0125)
  0x58, 0x12, 0xFE, 0x78, 0x2D, 0x8E, 0x45, 0x83, 0xA5, 0x04, 0xA3, 0x0D, 0xA0, 0x17, 0x00, 0xD7,
  0x10, 0xE0, 0xA7, 0x81, 0x2F, 0x67, 0x85, 0x5F, 0x37, 0xDD, 0x13, 0x85, 0x8F, 0x82, 0x3F, 0x73,
  0x85, 0xBF, 0x50, 0x3F, 0x73, 0x0E, 0x0C, 0x28, 0x15, 0xF4, 0x28, 0x12, 0xF7, 0x28, 0x19, 0xF1,
  0x28, 0x15, 0xF2, 0x20, 0xC0, 0xD3, 0x09, 0x93, 0x0E, 0x0A, 0x30, 0x0C, 0x28, 0x11, 0xF8, 0x39,
  0x09, 0x28, 0x62, 0xF8, 0x10, 0x3F, 0x53, 0x82, 0xBE, 0x91,
  // "Ħ" (U+0126)
  0x30, 0x9B, 0x82, 0xD0, 0x1E, 0xB0, 0x74, 0x81, 0x8F, 0x64, 0x81, 0xEE, 0x15, 0x0A, 0x94, 0x81,
  0x1F, 0x94, 0x05, 0x0D, 0xA8, 0x00, 0xD8, 0x2E, 0xFE, 0xC4, 0x81, 0x1F, 0x94, 0x81, 0x7F, 0x35,
  0x81, 0x4F, 0x74, 0x0A, 0x0E, 0x68, 0x77, 0xFE, 0xDD, 0xDD, 0xFB, 0x60, 0xB9, 0x48, 0x11, 0xF8,
  0x60, 0xE0, 0xC4, 0x81, 0x4F, 0x55, 0x81, 0x2F, 0x94, 0x81, 0x8F, 0x25, 0x81, 0x5F, 0x54, 0x0B,
  0x0E, 0x68, 0x1B, 0xF3, 0x38, 0x12, 0xFC, 0x40, 0x30, 0xEB, 0x81, 0x50, 0x9B, 0x0D, 0x30,
  // "ħ" (U+0127)
  0x00, 0xDF, 0xF0, 0x00, 0x00, 0x00, 0xEC, 0x00, 0x00, 0x05, 0xDF, 0xED, 0xD2, 0x00, 0x04, 0xF5,
  0x00, 0x00, 0x00, 0x7F, 0x29, 0xEC, 0x00, 0x0A, 0xD9, 0x15, 0xF4, 0x00, 0xDF, 0x30, 0x5F, 0x50,
  0x1F, 0xB0, 0x07, 0xF2, 0x04, 0xF5, 0x00, 0xBF, 0x00, 0x7F, 0x10, 0x0D, 0xC0, 0x0A, 0xD0, 0x01,
  0xF9, 0x00, 0xDA, 0x00, 0x3F, 0x70, 0x1F, 0x70, 0x02, 0xF7, 0x14, 0xF4, 0x00, 0x0B, 0xD9,
  // "Ĩ" (U+0128)
  0x38, 0x43, 0xCD, 0x50, 0x93, 0x84, 0x90, 0x4C, 0xC3, 0x75, 0x09, 0xB0, 0xD5, 0x81, 0x8F, 0x66,
  0x81, 0x9F, 0x16, 0x00, 0xD6, 0x81, 0x1F, 0x96, 0x81, 0x4F, 0x66, 0x81, 0x7F, 0x36, 0x0B, 0x97,
  0x0E, 0x0C, 0x68, 0x12, 0xF8, 0x68, 0x15, 0xF5, 0x68, 0x1B, 0xF3, 0x40, 0x30, 0xEB, 0x05, 0x30,
  // "ĩ" (U+0129)
  0x89, 0x23, 0xCD, 0x50, 0x99, 0x04, 0xCC, 0x36, 0x09, 0xA0, 0x33, 0x0B, 0x94, 0x00, 0xC4, 0x90,
  0x93, 0x81, 0x3F, 0x53, 0x81, 0x6F, 0x23, 0x09, 0x94, 0x00, 0xC4, 0x82, 0xCC, 0x01, 0x28, 0x26,
  0xEB, 0x32,
  // "Ī" (U+012A)
  0x48, 0x3B, 0xDD, 0xD8, 0x75, 0x09, 0xB0, 0xD5, 0x81, 0x8F, 0x66, 0x81, 0x9F, 0x16, 0x00, 0xD6,
  0x81, 0x1F, 0x96, 0x81, 0x4F, 0x66, 0x81, 0x7F, 0x36, 0x0B, 0x97, 0x0E, 0x0C, 0x68, 0x12, 0xF8,
  0x68, 0x15, 0xF5, 0x68, 0x1B, 0xF3, 0x40, 0x30, 0xEB, 0x05, 0x30,
  // "ī" (U+012B)
  0x83, 0xBD, 0xDD, 0x85, 0x09, 0xA0, 0x32, 0x0B, 0x93, 0x00, 0xC3, 0x90, 0x92, 0x81, 0x3F, 0x52,
  0x81, 0x6F, 0x22, 0x09, 0x93, 0x00, 0xC3, 0x87, 0xCC, 0x01, 0x06, 0xEB, 0x31,
  // "Ĭ" (U+012C)
  0x30, 0x30, 0x22, 0x06, 0x38, 0x35, 0x90, 0x59, 0x48, 0x1A, 0xD9, 0x75, 0x09, 0xB0, 0xD4, 0x81,
  0x8F, 0x65, 0x81, 0x9F, 0x15, 0x00, 0xD5, 0x81, 0x1F, 0x95, 0x81, 0x4F, 0x65, 0x81, 0x7F, 0x35,
  0x0B, 0x96, 0x0E, 0x0C, 0x58, 0x12, 0xF8, 0x58, 0x15, 0xF5, 0x58, 0x1B, 0xF3, 0x30, 0x30, 0xEB,
  0x05, 0x20,
  // "ĭ" (U+012D)
  0x32, 0x00, 0x65, 0x90, 0x59, 0x0A, 0xD9, 0x00, 0x00, 0x00, 0x9F, 0xF3, 0x00, 0xBF, 0x00, 0x0C,
  0xC0, 0x00, 0xF9, 0x00, 0x3F, 0x50, 0x06, 0xF2, 0x00, 0x9F, 0x00, 0x0C, 0xC0, 0x00, 0xCC, 0x01,
  0x06, 0xEB, 0x30,
  // "Į" (U+012E)
  0x30, 0x9B, 0x0D, 0x48, 0x18, 0xF6, 0x58, 0x19, 0xF1, 0x50, 0x0D, 0x58, 0x11, 0xF9, 0x58, 0x14,
  0xF6, 0x58, 0x17, 0xF3, 0x50, 0xB9, 0x60, 0xE0, 0xC5, 0x81, 0x2F, 0x85, 0x81, 0x5F, 0x55, 0x81,
  0xBF, 0x33, 0x03, 0x0E, 0xB0, 0x53, 0x81, 0x1C, 0x45, 0x09, 0x0A, 0x60, 0x0B, 0x68, 0x25, 0xFE,
  0x43,
  // "į" (U+012F)
  0x30, 0xC0, 0xA3, 0x0D, 0x0A, 0x74, 0x0A, 0xA0, 0x32, 0x0B, 0x93, 0x00, 0xC3, 0x90, 0x92, 0x81,
  0x3F, 0x62, 0x81, 0x6F, 0x32, 0x09, 0x93, 0x00, 0xC3, 0x89, 0x2C, 0xC0, 0x10, 0x7F, 0xC3, 0x1C,
  0x42, 0x09, 0x0A, 0x30, 0x0B, 0x38, 0x25, 0xFE, 0x41,
  // "İ" (U+0130)
  0x58, 0x16, 0xF3, 0x58, 0x16, 0xD2, 0x77, 0x50, 0x9B, 0x0D, 0x48, 0x18, 0xF6, 0x58, 0x19, 0xF1,
  0x50, 0x0D, 0x58, 0x11, 0xF9, 0x58, 0x14, 0xF6, 0x58, 0x17, 0xF3, 0x50, 0xB9, 0x60, 0xE0, 0xC5,
  0x81, 0x2F, 0x85, 0x81, 0x5F, 0x55, 0x81, 0xBF, 0x33, 0x03, 0x0E, 0xB0, 0x52,
  // "ı" (U+0131)
  0x9F, 0xF3, 0x0B, 0xF0, 0x0C, 0xC0, 0x0F, 0x90, 0x3F, 0x50, 0x6F, 0x20, 0x9F, 0x00, 0xCC, 0x00,
  0xCC, 0x01, 0x6E, 0xB3,
  // "Ĳ" (U+0132)
  0x30, 0x9B, 0x81, 0xD0, 0xAB, 0x0C, 0x48, 0x18, 0xF6, 0x38, 0x19, 0xF5, 0x58, 0x19, 0xF1, 0x30,
  0xB9, 0x60, 0x0D, 0x40, 0xE0, 0xC5, 0x81, 0x1F, 0x93, 0x81, 0x2F, 0x85, 0x81, 0x4F, 0x63, 0x81,
  0x5F, 0x55, 0x81, 0x7F, 0x33, 0x81, 0x9F, 0x25, 0x0B, 0x94, 0x0C, 0x0E, 0x60, 0xE0, 0xC4, 0x90,
  0xA5, 0x81, 0x2F, 0x83, 0x81, 0x3F, 0x75, 0x81, 0x5F, 0x53, 0x81, 0x7F, 0x45, 0x81, 0xBF, 0x33,
  0x0A, 0x94, 0x03, 0x0E, 0xB0, 0x52, 0x0D, 0x0C, 0x74, 0x81, 0x1F, 0x87, 0x48, 0x16, 0xF3, 0x73,
  0x81, 0x2E, 0xB7, 0x28, 0x25, 0xDD, 0x86,
  // "ĳ" (U+0133)
  0x20, 0xC0, 0xA3, 0x0C, 0x0B, 0x20, 0xD0, 0xA3, 0x0D, 0x0B, 0x77, 0x40, 0xAA, 0x81, 0x30, 0x9A,
  0x81, 0x30, 0xB9, 0x30, 0xB9, 0x20, 0x0C, 0x30, 0x0C, 0x29, 0x09, 0x39, 0x83, 0x80, 0x3F, 0x62,
  0x85, 0x3F, 0x50, 0x6F, 0x32, 0x83, 0x6F, 0x20, 0x99, 0x30, 0xA0, 0xE2, 0x00, 0xC3, 0x0D, 0x0B,
  0x28, 0x5C, 0xC0, 0x11, 0xF8, 0x28, 0x56, 0xEB, 0x34, 0xF4, 0x68, 0x18, 0xF1, 0x60, 0xC0, 0xB6,
  0x81, 0x5F, 0x44, 0x82, 0x2D, 0xD5, 0x40,
  // "Ĵ" (U+0134)
  0x68, 0x12, 0xFE, 0x78, 0x2D, 0x8E, 0x45, 0x83, 0xA5, 0x04, 0xA7, 0x71, 0x0A, 0xB0, 0xC6, 0x81,
  0x9F, 0x57, 0x0B, 0x97, 0x10, 0xE0, 0xC7, 0x81, 0x2F, 0x87, 0x81, 0x5F, 0x57, 0x81, 0x9F, 0x27,
  0x0C, 0x0E, 0x71, 0x90, 0xA7, 0x81, 0x3F, 0x77, 0x81, 0x7F, 0x47, 0x0A, 0x97, 0x10, 0xD0, 0xC7,
  0x81, 0x1F, 0x87, 0x81, 0x6F, 0x36, 0x81, 0x2E, 0xB5, 0x82, 0x5D, 0xD8, 0x60,
  // "ĵ" (U+0135)
  0x58, 0x12, 0xFE, 0x68, 0x2D, 0x8E, 0x44, 0x83, 0xA5, 0x04, 0xA7, 0x60, 0x9A, 0x03, 0x60, 0xB9,
  0x70, 0x0C, 0x79, 0x08, 0x68, 0x13, 0xF5, 0x68, 0x16, 0xF2, 0x60, 0xA0, 0xE7, 0x0D, 0x0B, 0x68,
  0x11, 0xF8, 0x68, 0x14, 0xF4, 0x68, 0x18, 0xF1, 0x60, 0xC0, 0xB6, 0x81, 0x5F, 0x44, 0x82, 0x2D,
  0xD5, 0x50,
  // "Ķ" (U+0136)
  0x30, 0x9B, 0x81, 0xD0, 0x5B, 0x02, 0x48, 0x18, 0xF6, 0x38, 0x1D, 0xB1, 0x58, 0x19, 0xF1, 0x20,
  0x80, 0xB7, 0x00, 0xD2, 0x07, 0x0B, 0x78, 0x41, 0xF9, 0x06, 0xB7, 0x18, 0x34, 0xF6, 0x6D, 0x72,
  0x81, 0x7F, 0x8A, 0x01, 0x71, 0x84, 0xBF, 0x96, 0xF6, 0x71, 0x84, 0xEC, 0x01, 0xFC, 0x78, 0x12,
  0xF8, 0x28, 0x1B, 0xF1, 0x68, 0x15, 0xF5, 0x28, 0x16, 0xF7, 0x68, 0x1B, 0xF3, 0x28, 0x11, 0xFD,
  0x40, 0x30, 0xEB, 0x05, 0x28, 0x16, 0xED, 0x77, 0x71, 0x90, 0x67, 0x40, 0x50, 0xC7, 0x50, 0xA0,
  0x27, 0x10,
  // "ķ" (U+0137)
  0x20, 0xDA, 0x01, 0x70, 0x0D, 0x71, 0x0E, 0x0A, 0x78, 0x12, 0xF7, 0x78, 0x35, 0xF3, 0x0C, 0xA0,
  0x92, 0x08, 0x92, 0x81, 0x5E, 0x43, 0x84, 0xBC, 0x02, 0xC3, 0x48, 0x3E, 0x92, 0xC2, 0x48, 0x32,
  0xF7, 0xDB, 0x58, 0x45, 0xFC, 0x9F, 0x14, 0x84, 0x9F, 0x13, 0xF7, 0x40, 0x0C, 0x20, 0xD0, 0xC4,
  0x90, 0x92, 0x81, 0x8F, 0x52, 0x81, 0x3F, 0x52, 0x82, 0x1B, 0xF4, 0x77, 0x90, 0x67, 0x05, 0x0C,
  0x71, 0x0A, 0x02, 0x60,
  // "ĸ" (U+0138)
  0x0B, 0xFF, 0x20, 0xDF, 0xF8, 0x00, 0xCF, 0x00, 0x6E, 0x40, 0x00, 0xCC, 0x02, 0xC2, 0x00, 0x00,
  0xF8, 0x2C, 0x20, 0x00, 0x03, 0xF7, 0xEB, 0x00, 0x00, 0x06, 0xFB, 0xAF, 0x10, 0x00, 0x09, 0xE0,
  0x4F, 0x60, 0x00, 0x0D, 0xB0, 0x0E, 0xB0, 0x00, 0x0F, 0x80, 0x09, 0xF4, 0x00, 0x4F, 0x50, 0x01,
  0xBF, 0x40,
  // "Ĺ" (U+0139)
  0x68, 0x17, 0xF5, 0x68, 0x11, 0xE6, 0x70, 0xB0, 0x57, 0x72, 0x09, 0xB0, 0xD6, 0x81, 0x8F, 0x67,
  0x09, 0x97, 0x10, 0x0D, 0x78, 0x11, 0xF9, 0x78, 0x14, 0xF6, 0x78, 0x17, 0xF3, 0x70, 0xB9, 0x71,
  0x0E, 0x0C, 0x78, 0x12, 0xF9, 0x40, 0xC2, 0x81, 0x5F, 0x53, 0x04, 0x0A, 0x28, 0x1B, 0xF2, 0x38,
  0x2C, 0x63, 0xEA, 0x0F, 0xD8, 0x1E, 0xF3,
  // "ĺ" (U+013A)
  0x48, 0x17, 0xF5, 0x38, 0x11, 0xE6, 0x40, 0xB0, 0x53, 0x0E, 0xA0, 0x14, 0x0E, 0x0D, 0x50, 0xE0,
  0xA4, 0x81, 0x2F, 0x64, 0x81, 0x6F, 0x34, 0x09, 0x95, 0x00, 0xC5, 0x90, 0x94, 0x81, 0x3F, 0x64,
  0x81, 0x6F, 0x24, 0x0A, 0x0E, 0x50, 0x0C, 0x58, 0x2D, 0xC0, 0x13, 0x82, 0x7E, 0xB3, 0x30,
  // "Ļ" (U+013B)
  0x30, 0x9B, 0x0D, 0x68, 0x18, 0xF6, 0x70, 0x99, 0x71, 0x00, 0xD7, 0x81, 0x1F, 0x97, 0x81, 0x4F,
  0x67, 0x81, 0x7F, 0x37, 0x0B, 0x97, 0x10, 0xE0, 0xC7, 0x81, 0x2F, 0x94, 0x0C, 0x28, 0x15, 0xF5,
  0x30, 0x40, 0xA2, 0x81, 0xBF, 0x23, 0x82, 0xC6, 0x3E, 0xA0, 0xFD, 0x81, 0xEF, 0x37, 0x79, 0x06,
  0x70, 0x50, 0xC7, 0x10, 0xA0, 0x25,
  // "ļ" (U+013C)
  0x20, 0xEA, 0x01, 0x30, 0xE0, 0xD4, 0x0E, 0x0A, 0x38, 0x12, 0xF6, 0x38, 0x16, 0xF3, 0x30, 0x99,
  0x40, 0x0C, 0x49, 0x09, 0x38, 0x13, 0xF6, 0x38, 0x16, 0xF2, 0x30, 0xA0, 0xE4, 0x00, 0xC4, 0x82,
  0xDC, 0x01, 0x28, 0x27, 0xEB, 0x37, 0x19, 0x06, 0x30, 0x50, 0xC4, 0x0A, 0x02, 0x40,
  // "Ľ" (U+013D)
  0x30, 0x9B, 0x82, 0xD0, 0xD8, 0x48, 0x48, 0xF6, 0x03, 0xD5, 0x09, 0x92, 0x08, 0x03, 0x50, 0x0D,
  0x71, 0x81, 0x1F, 0x97, 0x18, 0x14, 0xF6, 0x71, 0x81, 0x7F, 0x37, 0x10, 0xB9, 0x72, 0x0E, 0x0C,
  0x71, 0x81, 0x2F, 0x94, 0x0C, 0x38, 0x15, 0xF5, 0x30, 0x40, 0xA3, 0x81, 0xBF, 0x23, 0x83, 0xC6,
  0x03, 0xEA, 0x0F, 0xD8, 0x1E, 0xF3, 0x10,
  // "ľ" (U+013E)
  0x10, 0xEA, 0x81, 0x1B, 0x92, 0x83, 0xED, 0x1E, 0x12, 0x82, 0xEA, 0x76, 0x28, 0x12, 0xF6, 0x48,
  0x16, 0xF3, 0x40, 0x99, 0x50, 0x0C, 0x59, 0x09, 0x48, 0x13, 0xF6, 0x48, 0x16, 0xF2, 0x40, 0xA0,
  0xE5, 0x00, 0xC5, 0x82, 0xDC, 0x01, 0x38, 0x27, 0xEB, 0x33,
  // "Ŀ" (U+013F)
  0x30, 0x9B, 0x0D, 0x78, 0x18, 0xF6, 0x71, 0x09, 0x97, 0x20, 0x0D, 0x71, 0x81, 0x1F, 0x97, 0x18,
  0x14, 0xF6, 0x28, 0x16, 0xF3, 0x38, 0x17, 0xF3, 0x28, 0x16, 0xD2, 0x30, 0xB9, 0x72, 0x0E, 0x0C,
  0x71, 0x81, 0x2F, 0x94, 0x0C, 0x38, 0x15, 0xF5, 0x30, 0x40, 0xA3, 0x81, 0xBF, 0x23, 0x83, 0xC6,
  0x03, 0xEA, 0x0F, 0xD8, 0x1E, 0xF3, 0x10,
  // "ŀ" (U+0140)
  0x10, 0xEA, 0x01, 0x40, 0xE0, 0xD5, 0x0E, 0x0A, 0x48, 0x12, 0xF6, 0x48, 0x16, 0xF3, 0x40, 0x99,
  0x58, 0x96, 0xCC, 0x06, 0xF3, 0x0F, 0x90, 0x6D, 0x23, 0xF6, 0x48, 0x16, 0xF2, 0x40, 0xA0, 0xE5,
  0x00, 0xC5, 0x82, 0xDC, 0x01, 0x38, 0x27, 0xEB, 0x33,
  // "Ł" (U+0141)
  0x30, 0x9B, 0x0D, 0x68, 0x18, 0xF6, 0x70, 0x99, 0x71, 0x00, 0xD7, 0x83, 0x1F, 0x90, 0x55, 0x83,
  0x4F, 0xBD, 0x75, 0x82, 0x9F, 0x91, 0x48, 0x12, 0xCE, 0x96, 0x82, 0x21, 0xEC, 0x78, 0x12, 0xF9,
  0x40, 0xC2, 0x81, 0x5F, 0x53, 0x04, 0x0A, 0x28, 0x1B, 0xF2, 0x38, 0x2C, 0x63, 0xEA, 0x0F, 0xD8,
  0x1E, 0xF3,
  // "ł" (U+0142)
  0x20, 0xEA, 0x01, 0x30, 0xE0, 0xD4, 0x0E, 0x0A, 0x38, 0x12, 0xF6, 0x38, 0x15, 0xF3, 0x30, 0x99,
  0x48, 0x2C, 0xD6, 0x42, 0x98, 0x5E, 0x80, 0x4D, 0xF6, 0x28, 0x26, 0x8F, 0x23, 0x09, 0x94, 0x00,
  0xC4, 0x82, 0xDC, 0x01, 0x28, 0x27, 0xEB, 0x31,
  // "Ń" (U+0143)
  0x72, 0x81, 0x7F, 0x57, 0x48, 0x11, 0xE6, 0x75, 0x0B, 0x05, 0x77, 0x72, 0x09, 0xA0, 0x73, 0x09,
  0xA0, 0xE0, 0x34, 0x81, 0x8F, 0xC4, 0x08, 0x0B, 0x68, 0x29, 0xDF, 0x23, 0x0A, 0x05, 0x68, 0x2D,
  0x4F, 0x73, 0x0D, 0x02, 0x58, 0x31, 0xD0, 0xDC, 0x20, 0x10, 0xE6, 0x87, 0x4A, 0x08, 0xF2, 0x04,
  0xB6, 0x87, 0x77, 0x02, 0xF7, 0x07, 0x76, 0x0B, 0x03, 0x28, 0x3D, 0xD0, 0xA4, 0x60, 0xE3, 0x83,
  0x7F, 0x2D, 0x15, 0x02, 0x0C, 0x38, 0x22, 0xF9, 0xD6, 0x05, 0x09, 0x48, 0x1C, 0xFA, 0x60, 0xB0,
  0x84, 0x81, 0x7F, 0x64, 0x03, 0x0E, 0xA0, 0x83, 0x81, 0x1F, 0x34,
  // "ń" (U+0144)
  0x68, 0x17, 0xF5, 0x58, 0x11, 0xE6, 0x60, 0xB0, 0x57, 0x50, 0xBA, 0x83, 0x28, 0xDD, 0x12, 0x85,
  0xCE, 0x72, 0x4F, 0x62, 0x85, 0xCF, 0x50, 0x3F, 0x62, 0x90, 0xC2, 0x85, 0x6F, 0x40, 0x3F, 0x62,
  0x85, 0x9F, 0x10, 0x6F, 0x22, 0x0C, 0x0D, 0x20, 0xA0, 0xE3, 0x90, 0xA2, 0x0D, 0x0B, 0x28, 0x12,
  0xF7, 0x29, 0x08, 0x28, 0x52, 0xF7, 0x14, 0xF5, 0x38, 0x1B, 0xE9,
  // "Ņ" (U+0145)
  0x30, 0x9A, 0x07, 0x30, 0x9A, 0x0E, 0x03, 0x48, 0x18, 0xFC, 0x40, 0x80, 0xB6, 0x82, 0x9D, 0xF2,
  0x30, 0xA0, 0x56, 0x82, 0xD4, 0xF7, 0x30, 0xD0, 0x25, 0x83, 0x1D, 0x0D, 0xC2, 0x01, 0x0E, 0x68,
  0x74, 0xA0, 0x8F, 0x20, 0x4B, 0x68, 0x77, 0x70, 0x2F, 0x70, 0x77, 0x60, 0xB0, 0x32, 0x83, 0xDD,
  0x0A, 0x46, 0x0E, 0x38, 0x37, 0xF2, 0xD1, 0x50, 0x20, 0xC3, 0x82, 0x2F, 0x9D, 0x60, 0x50, 0x94,
  0x81, 0xCF, 0xA6, 0x0B, 0x08, 0x48, 0x17, 0xF6, 0x40, 0x30, 0xEA, 0x08, 0x38, 0x11, 0xF3, 0x77,
  0x73, 0x90, 0x67, 0x50, 0x50, 0xC7, 0x60, 0xA0, 0x27, 0x20,
  // "ņ" (U+0146)
  0x10, 0xBA, 0x83, 0x28, 0xDD, 0x12, 0x85, 0xCE, 0x72, 0x4F, 0x62, 0x85, 0xCF, 0x50, 0x3F, 0x62,
  0x90, 0xC2, 0x85, 0x6F, 0x40, 0x3F, 0x62, 0x85, 0x9F, 0x10, 0x6F, 0x22, 0x0C, 0x0D, 0x20, 0xA0,
  0xE3, 0x90, 0xA2, 0x0D, 0x0B, 0x28, 0x12, 0xF7, 0x29, 0x08, 0x28, 0x52, 0xF7, 0x14, 0xF5, 0x38,
  0x1B, 0xE9, 0x75, 0x90, 0x66, 0x05, 0x0C, 0x70, 0xA0, 0x25,
  // "Ň" (U+0147)
  0x78, 0x44, 0x90, 0x2C, 0x27, 0x38, 0x2D, 0x7E, 0x47, 0x48, 0x19, 0xF7, 0x77, 0x71, 0x09, 0xA0,
  0x73, 0x09, 0xA0, 0xE0, 0x34, 0x81, 0x8F, 0xC4, 0x08, 0x0B, 0x68, 0x29, 0xDF, 0x23, 0x0A, 0x05,
  0x68, 0x2D, 0x4F, 0x73, 0x0D, 0x02, 0x58, 0x31, 0xD0, 0xDC, 0x20, 0x10, 0xE6, 0x87, 0x4A, 0x08,
  0xF2, 0x04, 0xB6, 0x87, 0x77, 0x02, 0xF7, 0x07, 0x76, 0x0B, 0x03, 0x28, 0x3D, 0xD0, 0xA4, 0x60,
  0xE3, 0x83, 0x7F, 0x2D, 0x15, 0x02, 0x0C, 0x38, 0x22, 0xF9, 0xD6, 0x05, 0x09, 0x48, 0x1C, 0xFA,
  0x60, 0xB0, 0x84, 0x81, 0x7F, 0x64, 0x03, 0x0E, 0xA0, 0x83, 0x81, 0x1F, 0x34,
  // "ň" (U+0148)
  0x48, 0x44, 0x90, 0x2C, 0x25, 0x82, 0xD7, 0xE4, 0x68, 0x19, 0xF7, 0x76, 0x0B, 0xA8, 0x32, 0x8D,
  0xD1, 0x38, 0x5C, 0xE7, 0x24, 0xF6, 0x38, 0x5C, 0xF5, 0x03, 0xF6, 0x39, 0x0C, 0x28, 0x16, 0xF4,
  0x28, 0x13, 0xF6, 0x28, 0x19, 0xF1, 0x28, 0x16, 0xF2, 0x20, 0xC0, 0xD3, 0x0A, 0x0E, 0x39, 0x0A,
  0x30, 0xD0, 0xB2, 0x81, 0x2F, 0x73, 0x90, 0x82, 0x86, 0x2F, 0x71, 0x04, 0xF5, 0x38, 0x1B, 0xE9,
  0x10,
  // "ŉ" (U+0149)
  0x18, 0x16, 0xE3, 0x72, 0x81, 0x7F, 0x77, 0x30, 0xC0, 0x47, 0x28, 0x25, 0xA0, 0xBA, 0x85, 0x28,
  0xDD, 0x13, 0x63, 0x85, 0xCE, 0x72, 0x4F, 0x65, 0x85, 0xCF, 0x50, 0x3F, 0x65, 0x90, 0xC2, 0x81,
  0x6F, 0x44, 0x81, 0x3F, 0x62, 0x81, 0x9F, 0x14, 0x81, 0x6F, 0x22, 0x0C, 0x0D, 0x50, 0xA0, 0xE3,
  0x90, 0xA5, 0x0D, 0x0B, 0x28, 0x12, 0xF7, 0x59, 0x08, 0x28, 0x22, 0xF7, 0x13, 0x81, 0x4F, 0x53,
  0x81, 0xBE, 0x90,
  // "Ŋ" (U+014A)
  0x30, 0x9A, 0x07, 0x30, 0x9A, 0x0E, 0x03, 0x48, 0x18, 0xFC, 0x40, 0x80, 0xA6, 0x82, 0x9D, 0xF2,
  0x30, 0x90, 0x56, 0x82, 0xD4, 0xF7, 0x30, 0xD0, 0x15, 0x83, 0x1D, 0x0D, 0xC2, 0x01, 0x0D, 0x68,
  0x74, 0xA0, 0x8F, 0x20, 0x4A, 0x68, 0x77, 0x70, 0x2F, 0x70, 0x77, 0x60, 0xB0, 0x32, 0x83, 0xDD,
  0x0A, 0x46, 0x0E, 0x38, 0x27, 0xF2, 0xD6, 0x02, 0x0C, 0x38, 0x22, 0xF9, 0xC6, 0x05, 0x09, 0x48,
  0x1C, 0xF9, 0x60, 0xB0, 0x84, 0x81, 0x7F, 0x64, 0x03, 0x0E, 0xA0, 0x93, 0x81, 0x2F, 0x27, 0x60,
  0xE7, 0x60, 0x60, 0x97, 0x58, 0x14, 0xE2, 0x73, 0x82, 0x7D, 0xC3, 0x60,
  // "ŋ" (U+014B)
  0x10, 0xBA, 0x83, 0x28, 0xDD, 0x12, 0x85, 0xCE, 0x82, 0x4F, 0x62, 0x85, 0xCF, 0x50, 0x3F, 0x62,
  0x90, 0xC2, 0x85, 0x6F, 0x40, 0x3F, 0x62, 0x09, 0x92, 0x81, 0x6F, 0x22, 0x00, 0xC2, 0x0A, 0x0E,
  0x39, 0x09, 0x20, 0xD0, 0xB2, 0x81, 0x3F, 0x62, 0x90, 0x82, 0x85, 0x7F, 0x20, 0x4F, 0x52, 0x0A,
  0x0E, 0x70, 0xD0, 0xB6, 0x81, 0x3F, 0x66, 0x0B, 0x0D, 0x58, 0x27, 0xEC, 0x23,
  // "Ō" (U+014C)
  0x48, 0x3B, 0xDD, 0xD8, 0x77, 0x28, 0x41, 0x9D, 0xED, 0x64, 0x81, 0x3E, 0x92, 0x81, 0x5F, 0x72,
  0x81, 0x1E, 0xA4, 0x85, 0xAF, 0x10, 0xAF, 0x14, 0x84, 0x7F, 0x42, 0xFA, 0x58, 0x47, 0xF5, 0x8F,
  0x55, 0x84, 0x8F, 0x5D, 0xF1, 0x58, 0x3B, 0xF2, 0xFE, 0x68, 0x3E, 0xE0, 0xFC, 0x58, 0x44, 0xF8,
  0x0E, 0xD5, 0x85, 0xBE, 0x10, 0xAF, 0x13, 0x81, 0x4F, 0x62, 0x81, 0x2E, 0xA2, 0x81, 0x4E, 0x84,
  0x84, 0x2B, 0xED, 0xB4, 0x40,
  // "ō" (U+014D)
  0x38, 0x3B, 0xDD, 0xD8, 0x76, 0x83, 0x5C, 0xDD, 0x43, 0x89, 0x16, 0xE3, 0x09, 0xF1, 0x02, 0xF7,
  0x28, 0x53, 0xF6, 0x09, 0xF1, 0x28, 0x43, 0xF7, 0x0E, 0xB3, 0x84, 0x4F, 0x62, 0xF8, 0x38, 0x47,
  0xF3, 0x3F, 0x73, 0x84, 0xBE, 0x01, 0xF8, 0x28, 0x12, 0xF6, 0x28, 0x4C, 0xC0, 0x1C, 0xB3, 0x83,
  0x1B, 0xED, 0x83,
  // "Ŏ" (U+014E)
  0x40, 0x30, 0x22, 0x06, 0x68, 0x35, 0x90, 0x59, 0x78, 0x1A, 0xD9, 0x77, 0x38, 0x41, 0x9D, 0xED,
  0x64, 0x81, 0x3E, 0x92, 0x81, 0x5F, 0x72, 0x81, 0x1E, 0xA4, 0x85, 0xAF, 0x10, 0xAF, 0x14, 0x84,
  0x7F, 0x42, 0xFA, 0x58, 0x47, 0xF5, 0x8F, 0x55, 0x84, 0x8F, 0x5D, 0xF1, 0x58, 0x3B, 0xF2, 0xFE,
  0x68, 0x3E, 0xE0, 0xFC, 0x58, 0x44, 0xF8, 0x0E, 0xD5, 0x85, 0xBE, 0x10, 0xAF, 0x13, 0x81, 0x4F,
  0x62, 0x81, 0x2E, 0xA2, 0x81, 0x4E, 0x84, 0x84, 0x2B, 0xED, 0xB4, 0x40,
  // "ŏ" (U+014F)
  0x30, 0x30, 0x22, 0x06, 0x48, 0x35, 0x90, 0x59, 0x58, 0x1A, 0xD9, 0x77, 0x83, 0x5C, 0xDD, 0x43,
  0x89, 0x16, 0xE3, 0x09, 0xF1, 0x02, 0xF7, 0x28, 0x53, 0xF6, 0x09, 0xF1, 0x28, 0x43, 0xF7, 0x0E,
  0xB3, 0x84, 0x4F, 0x62, 0xF8, 0x38, 0x47, 0xF3, 0x3F, 0x73, 0x84, 0xBE, 0x01, 0xF8, 0x28, 0x12,
  0xF6, 0x28, 0x4C, 0xC0, 0x1C, 0xB3, 0x83, 0x1B, 0xED, 0x83,
  // "Ő" (U+0150)
  0x68, 0x46, 0xE3, 0x9D, 0x15, 0x84, 0x1E, 0x54, 0xE3, 0x68, 0x3B, 0x50, 0xC3, 0x77, 0x38, 0x41,
  0x9D, 0xED, 0x65, 0x81, 0x3E, 0x92, 0x81, 0x5F, 0x73, 0x81, 0x1E, 0xA4, 0x81, 0xAF, 0x12, 0x81,
  0xAF, 0x14, 0x85, 0x7F, 0x40, 0x2F, 0xA5, 0x85, 0x7F, 0x50, 0x8F, 0x55, 0x85, 0x8F, 0x50, 0xDF,
  0x15, 0x84, 0xBF, 0x20, 0xFE, 0x60, 0x0E, 0x29, 0x0C, 0x58, 0x14, 0xF8, 0x20, 0xE0, 0xD5, 0x81,
  0xBE, 0x12, 0x81, 0xAF, 0x13, 0x81, 0x4F, 0x63, 0x81, 0x2E, 0xA2, 0x81, 0x4E, 0x85, 0x84, 0x2B,
  0xED, 0xB4, 0x50,
  // "ő" (U+0151)
  0x58, 0x46, 0xE3, 0x9D, 0x14, 0x84, 0x1E, 0x54, 0xE3, 0x58, 0x3B, 0x50, 0xC3, 0x77, 0x28, 0x35,
  0xCD, 0xD4, 0x58, 0x56, 0xE3, 0x09, 0xF1, 0x38, 0x12, 0xF7, 0x28, 0x13, 0xF6, 0x38, 0x19, 0xF1,
  0x28, 0x13, 0xF7, 0x30, 0xE0, 0xB3, 0x81, 0x4F, 0x62, 0x81, 0x2F, 0x83, 0x81, 0x7F, 0x32, 0x81,
  0x3F, 0x73, 0x0B, 0x0E, 0x38, 0x11, 0xF8, 0x28, 0x12, 0xF6, 0x48, 0x4C, 0xC0, 0x1C, 0xB5, 0x83,
  0x1B, 0xED, 0x85,
  // "Œ" (U+0152)
  0x38, 0x11, 0x9D, 0xF9, 0x07, 0x28, 0x97, 0x3E, 0xB3, 0x15, 0xF9, 0x11, 0x2E, 0x40, 0x1E, 0xB3,
  0x81, 0x5F, 0x43, 0x84, 0xB1, 0x0A, 0xF2, 0x30, 0x89, 0x68, 0x12, 0xFA, 0x40, 0x0C, 0x68, 0x18,
  0xF5, 0x49, 0x83, 0xED, 0xDD, 0x32, 0x81, 0xDF, 0x13, 0x81, 0x3F, 0x56, 0x90, 0xD4, 0x81, 0x6F,
  0x26, 0x90, 0xC4, 0x09, 0x97, 0x0E, 0x0C, 0x40, 0xD0, 0xC4, 0x05, 0x28, 0x1A, 0xE1, 0x39, 0x09,
  0x30, 0x10, 0xD2, 0x81, 0x2E, 0x92, 0x81, 0x4F, 0x63, 0x09, 0x0A, 0x38, 0x22, 0xBE, 0xEA, 0x84,
  0xED, 0xDE, 0xF7, 0x20,
  // "œ" (U+0153)
  0x00, 0x05, 0xCD, 0xC3, 0x05, 0xCE, 0xA0, 0x00, 0x6E, 0x30, 0x9E, 0x8D, 0x15, 0xF5, 0x02, 0xF7,
  0x00, 0x4F, 0xF3, 0x04, 0xF5, 0x09, 0xF1, 0x00, 0x3F, 0xC0, 0x09, 0xF1, 0x0E, 0xC0, 0x00, 0x4F,
  0x81, 0x8F, 0x50, 0x2F, 0x90, 0x00, 0x7F, 0xED, 0x92, 0x00, 0x3F, 0x70, 0x00, 0xBF, 0x30, 0x00,
  0x00, 0x1F, 0x80, 0x02, 0xFF, 0x40, 0x00, 0x00, 0x0B, 0xD0, 0x1C, 0xDF, 0xA0, 0x08, 0x20, 0x01,
  0xBE, 0xD8, 0x04, 0xDE, 0xC6, 0x00,
  // "Ŕ" (U+0154)
  0x71, 0x81, 0x7F, 0x57, 0x81, 0x1E, 0x67, 0x10, 0xB0, 0x57, 0x72, 0x09, 0xA8, 0x3E, 0xDD, 0x91,
  0x48, 0x58, 0xF3, 0x03, 0xFB, 0x40, 0x99, 0x30, 0xB9, 0x40, 0xD0, 0xC3, 0x0C, 0x93, 0x81, 0x1F,
  0x82, 0x81, 0x1F, 0xB3, 0x86, 0x4F, 0x50, 0x2B, 0xD2, 0x38, 0x47, 0xFD, 0xEF, 0x75, 0x84, 0xBE,
  0x06, 0xF5, 0x58, 0x4E, 0xB0, 0x3F, 0x84, 0x81, 0x2F, 0x82, 0x90, 0xC4, 0x81, 0x5F, 0x52, 0x81,
  0xBF, 0x13, 0x81, 0xAF, 0x32, 0x84, 0x7F, 0x70, 0x3E, 0xB0, 0x92, 0x81, 0xAE, 0x50,
  // "ŕ" (U+0155)
  0x58, 0x17, 0xF5, 0x48, 0x11, 0xE6, 0x50, 0xB0, 0x57, 0x40, 0xCA, 0x82, 0x1A, 0xE8, 0x28, 0x4B,
  0xC8, 0x1A, 0xB2, 0x84, 0xCE, 0x40, 0x21, 0x20, 0xE0, 0xD5, 0x81, 0x2F, 0x75, 0x81, 0x6F, 0x35,
  0x09, 0x96, 0x00, 0xC6, 0x90, 0x95, 0x81, 0x3F, 0x65,
  // "Ŗ" (U+0156)
  0x30, 0x9A, 0x83, 0xED, 0xD9, 0x14, 0x85, 0x8F, 0x30, 0x3F, 0xB4, 0x09, 0x93, 0x0B, 0x94, 0x0D,
  0x0C, 0x30, 0xC9, 0x38, 0x11, 0xF8, 0x28, 0x11, 0xFB, 0x38, 0x64, 0xF5, 0x02, 0xBD, 0x23, 0x84,
  0x7F, 0xDE, 0xF7, 0x58, 0x4B, 0xE0, 0x6F, 0x55, 0x84, 0xEB, 0x03, 0xF8, 0x48, 0x12, 0xF8, 0x29,
  0x0C, 0x48, 0x15, 0xF5, 0x28, 0x1B, 0xF1, 0x38, 0x1A, 0xF3, 0x28, 0x47, 0xF7, 0x03, 0xEB, 0x09,
  0x28, 0x1A, 0xE5, 0x77, 0x29, 0x06, 0x71, 0x05, 0x0C, 0x72, 0x0A, 0x02, 0x50,
  // "ŗ" (U+0157)
  0x20, 0xCA, 0x82, 0x1A, 0xE8, 0x38, 0x4B, 0xC8, 0x1A, 0xB3, 0x84, 0xCE, 0x40, 0x21, 0x30, 0xE0,
  0xD6, 0x81, 0x2F, 0x76, 0x81, 0x6F, 0x36, 0x09, 0x97, 0x00, 0xC7, 0x90, 0x96, 0x81, 0x3F, 0x67,
  0x71, 0x90, 0x66, 0x05, 0x0C, 0x70, 0xA0, 0x27,
  // "Ř" (U+0158)
  0x68, 0x44, 0x90, 0x2C, 0x27, 0x82, 0xD7, 0xE4, 0x71, 0x81, 0x9F, 0x77, 0x73, 0x09, 0xA8, 0x3E,
  0xDD, 0x91, 0x58, 0x58, 0xF3, 0x03, 0xFB, 0x50, 0x99, 0x30, 0xB9, 0x50, 0xD0, 0xC3, 0x0C, 0x94,
  0x81, 0x1F, 0x82, 0x81, 0x1F, 0xB4, 0x86, 0x4F, 0x50, 0x2B, 0xD2, 0x48, 0x47, 0xFD, 0xEF, 0x76,
  0x84, 0xBE, 0x06, 0xF5, 0x68, 0x4E, 0xB0, 0x3F, 0x85, 0x81, 0x2F, 0x82, 0x90, 0xC5, 0x81, 0x5F,
  0x52, 0x81, 0xBF, 0x14, 0x81, 0xAF, 0x32, 0x81, 0x7F, 0x72, 0x03, 0x0E, 0xB0, 0x92, 0x81, 0xAE,
  0x51,
  // "ř" (U+0159)
  0x38, 0x44, 0x90, 0x2C, 0x24, 0x82, 0xD7, 0xE4, 0x58, 0x19, 0xF7, 0x75, 0x0C, 0xA8, 0x21, 0xAE,
  0x83, 0x84, 0xBC, 0x81, 0xAB, 0x38, 0x4C, 0xE4, 0x02, 0x13, 0x0E, 0x0D, 0x68, 0x12, 0xF7, 0x68,
  0x16, 0xF3, 0x60, 0x99, 0x70, 0x0C, 0x79, 0x09, 0x68, 0x13, 0xF6, 0x60,
  // "Ś" (U+015A)
  0x78, 0x17, 0xF5, 0x68, 0x11, 0xE6, 0x70, 0xB0, 0x57, 0x71, 0x84, 0x3B, 0xDE, 0xB3, 0x38, 0x53,
  0xF7, 0x01, 0xDE, 0x30, 0xA0, 0xD3, 0x08, 0x0B, 0x30, 0xD0, 0xC7, 0x18, 0x1B, 0xF2, 0x78, 0x25,
  0xFE, 0x47, 0x06, 0xA0, 0x67, 0x82, 0x3D, 0xF4, 0x78, 0x12, 0xFB, 0x20, 0x50, 0x74, 0x0D, 0x0C,
  0x20, 0x0B, 0x40, 0xE0, 0x92, 0x81, 0x8F, 0x52, 0x81, 0x8E, 0x23, 0x84, 0x7D, 0xDD, 0xA2, 0x30,
  // "ś" (U+015B)
  0x58, 0x17, 0xF5, 0x48, 0x11, 0xE6, 0x50, 0xB0, 0x57, 0x58, 0x33, 0xCD, 0xD6, 0x28, 0x31, 0xE5,
  0x08, 0x92, 0x06, 0x92, 0x03, 0x0A, 0x28, 0x15, 0xF7, 0x68, 0x2C, 0xFB, 0x25, 0x81, 0x8F, 0xD3,
  0x01, 0x28, 0x46, 0xF4, 0x06, 0xA2, 0x89, 0x02, 0xF4, 0x07, 0xE1, 0x08, 0xD3, 0x83, 0xAE, 0xDA,
  0x22,
  // "Ŝ" (U+015C)
  0x58, 0x12, 0xFE, 0x68, 0x2D, 0x8E, 0x44, 0x83, 0xA5, 0x04, 0xA7, 0x58, 0x43, 0xBD, 0xEB, 0x32,
  0x85, 0x3F, 0x70, 0x1D, 0xE2, 0x0A, 0x0D, 0x30, 0x80, 0xB2, 0x0D, 0x0C, 0x78, 0x1B, 0xF2, 0x68,
  0x25, 0xFE, 0x46, 0x06, 0xA0, 0x66, 0x82, 0x3D, 0xF4, 0x68, 0x42, 0xFB, 0x05, 0x74, 0x83, 0xDC,
  0x0B, 0xB4, 0x84, 0xE9, 0x08, 0xF5, 0x28, 0x18, 0xE2, 0x28, 0x47, 0xDD, 0xDA, 0x22,
  // "ŝ" (U+015D)
  0x48, 0x12, 0xFE, 0x58, 0x2D, 0x8E, 0x43, 0x83, 0xA5, 0x04, 0xA7, 0x38, 0x33, 0xCD, 0xD6, 0x28,
  0x31, 0xE5, 0x08, 0x92, 0x06, 0x92, 0x03, 0x0A, 0x28, 0x15, 0xF7, 0x68, 0x2C, 0xFB, 0x25, 0x81,
  0x8F, 0xD3, 0x01, 0x28, 0x46, 0xF4, 0x06, 0xA2, 0x89, 0x02, 0xF4, 0x07, 0xE1, 0x08, 0xD3, 0x83,
  0xAE, 0xDA, 0x22,
  // "Ş" (U+015E)
  0x38, 0x43, 0xBD, 0xEB, 0x32, 0x85, 0x3F, 0x70, 0x1D, 0xE2, 0x0A, 0x0D, 0x30, 0x80, 0xB2, 0x0D,
  0x0C, 0x78, 0x1B, 0xF2, 0x68, 0x25, 0xFE, 0x46, 0x06, 0xA0, 0x66, 0x82, 0x3D, 0xF4, 0x68, 0x42,
  0xFB, 0x05, 0x74, 0x83, 0xDC, 0x0B, 0xB4, 0x84, 0xE9, 0x08, 0xF5, 0x28, 0x18, 0xE2, 0x28, 0x47,
  0xDF, 0xEA, 0x25, 0x0E, 0x04, 0x70, 0x59, 0x70, 0x60, 0xE5, 0x82, 0x6E, 0xC4, 0x40,
  // "ş" (U+015F)
  0x28, 0x94, 0x3C, 0xDD, 0x60, 0x1E, 0x50, 0x8F, 0x06, 0x92, 0x84, 0x3A, 0x05, 0xF7, 0x58, 0x2C,
  0xFB, 0x24, 0x81, 0x8F, 0xD2, 0x01, 0x28, 0x36, 0xF4, 0x6A, 0x28, 0x72, 0xF4, 0x7E, 0x10, 0x8D,
  0x28, 0x3A, 0xFE, 0xA2, 0x30, 0xE0, 0x45, 0x05, 0x95, 0x06, 0x0E, 0x38, 0x26, 0xEC, 0x43,
  // "Š" (U+0160)
  0x48, 0x44, 0x90, 0x2C, 0x25, 0x82, 0xD7, 0xE4, 0x68, 0x19, 0xF7, 0x77, 0x18, 0x43, 0xBD, 0xEB,
  0x33, 0x85, 0x3F, 0x70, 0x1D, 0xE3, 0x0A, 0x0D, 0x30, 0x80, 0xB3, 0x0D, 0x0C, 0x71, 0x81, 0xBF,
  0x27, 0x82, 0x5F, 0xE4, 0x70, 0x6A, 0x06, 0x78, 0x23, 0xDF, 0x47, 0x81, 0x2F, 0xB2, 0x05, 0x07,
  0x40, 0xD0, 0xC2, 0x00, 0xB4, 0x0E, 0x09, 0x28, 0x18, 0xF5, 0x28, 0x18, 0xE2, 0x38, 0x47, 0xDD,
  0xDA, 0x23,
  // "š" (U+0161)
  0x38, 0x44, 0x90, 0x2C, 0x24, 0x82, 0xD7, 0xE4, 0x58, 0x19, 0xF7, 0x76, 0x83, 0x3C, 0xDD, 0x63,
  0x83, 0x1E, 0x50, 0x89, 0x30, 0x69, 0x20, 0x30, 0xA3, 0x81, 0x5F, 0x77, 0x82, 0xCF, 0xB2, 0x68,
  0x18, 0xFD, 0x40, 0x12, 0x81, 0x6F, 0x42, 0x06, 0x0A, 0x28, 0x12, 0xF4, 0x28, 0x47, 0xE1, 0x08,
  0xD4, 0x83, 0xAE, 0xDA, 0x23,
  // "Ţ" (U+0162)
  0x18, 0xA3, 0xEF, 0xDE, 0xFE, 0xDF, 0xE2, 0xE1, 0x08, 0xF2, 0x06, 0xC6, 0x72, 0x0C, 0x0E, 0x20,
  0x40, 0x94, 0x90, 0xB7, 0x81, 0x3F, 0x87, 0x81, 0x6F, 0x47, 0x81, 0x9F, 0x17, 0x0C, 0x0D, 0x71,
  0x90, 0xA7, 0x81, 0x3F, 0x77, 0x81, 0x6F, 0x37, 0x81, 0xCF, 0x25, 0x06, 0xC0, 0x66, 0x0E, 0x04,
  0x71, 0x05, 0x97, 0x10, 0x60, 0xE6, 0x82, 0x6E, 0xC4, 0x60,
  // "ţ" (U+0163)
  0x30, 0x40, 0xA3, 0x81, 0x4E, 0x72, 0x83, 0x8E, 0xFD, 0xD2, 0x0A, 0x94, 0x0D, 0x0C, 0x49, 0x09,
  0x38, 0x13, 0xF6, 0x38, 0x17, 0xF3, 0x30, 0xA9, 0x40, 0x0C, 0x48, 0x2C, 0xD0, 0x12, 0x82, 0x5F,
  0xE9, 0x30, 0xE0, 0x44, 0x05, 0x94, 0x06, 0x0E, 0x28, 0x26, 0xEC, 0x42,
  // "Ť" (U+0164)
  0x48, 0x44, 0x90, 0x2C, 0x25, 0x82, 0xD7, 0xE4, 0x68, 0x19, 0xF7, 0x76, 0x8A, 0x3E, 0xFD, 0xEF,
  0xED, 0xFE, 0x2E, 0x10, 0x8F, 0x20, 0x6C, 0x67, 0x20, 0xC0, 0xE2, 0x04, 0x09, 0x49, 0x0B, 0x78,
  0x13, 0xF8, 0x78, 0x16, 0xF4, 0x78, 0x19, 0xF1, 0x70, 0xC0, 0xD7, 0x19, 0x0A, 0x78, 0x13, 0xF7,
  0x78, 0x16, 0xF3, 0x78, 0x1C, 0xF2, 0x50, 0x6C, 0x06, 0x40,
  // "ť" (U+0165)
  0x50, 0x90, 0xB3, 0x82, 0x20, 0xE2, 0x28, 0x25, 0xA4, 0x52, 0x81, 0x5E, 0x73, 0x83, 0x8E, 0xFD,
  0xD3, 0x0A, 0x95, 0x0D, 0x0C, 0x59, 0x09, 0x48, 0x13, 0xF6, 0x48, 0x17, 0xF3, 0x40, 0xA9, 0x50,
  0x0C, 0x58, 0x2C, 0xD0, 0x13, 0x82, 0x5E, 0xD9, 0x30,
  // "Ŧ" (U+0166)
  0x18, 0xA3, 0xEF, 0xDE, 0xFE, 0xDF, 0xE2, 0xE1, 0x08, 0xF2, 0x06, 0xB6, 0x72, 0x0C, 0x0E, 0x20,
  0x40, 0x94, 0x90, 0xB7, 0x81, 0x3F, 0x87, 0x81, 0x6F, 0x44, 0x86, 0x2D, 0xDE, 0xFD, 0xDA, 0x50,
  0xC0, 0xD7, 0x19, 0x0A, 0x78, 0x13, 0xF7, 0x78, 0x16, 0xF4, 0x78, 0x1C, 0xF2, 0x50, 0x6C, 0x06,
  0x40,
  // "ŧ" (U+0167)
  0x00, 0x04, 0xA0, 0x00, 0x4E, 0x70, 0x08, 0xEF, 0xDD, 0x00, 0x9F, 0x00, 0x00, 0xCC, 0x00, 0x00,
  0xEA, 0x00, 0x3D, 0xFE, 0xD5, 0x05, 0xF4, 0x00, 0x09, 0xF1, 0x00, 0x0B, 0xD0, 0x00, 0x0C, 0xD0,
  0x10, 0x05, 0xED, 0x90,
  // "Ũ" (U+0168)
  0x48, 0x43, 0xCD, 0x50, 0x96, 0x84, 0x90, 0x4C, 0xC3, 0x77, 0x10, 0xEB, 0x82, 0x90, 0x2E, 0xA0,
  0xA2, 0x81, 0xDF, 0x24, 0x90, 0x33, 0x0E, 0x0B, 0x40, 0x20, 0xD3, 0x81, 0x2F, 0x84, 0x05, 0x09,
  0x38, 0x15, 0xF5, 0x40, 0x80, 0x63, 0x81, 0x9F, 0x14, 0x0C, 0x02, 0x30, 0xC0, 0xE5, 0x0E, 0x49,
  0x0A, 0x40, 0x30, 0xB3, 0x81, 0x3F, 0x74, 0x06, 0x08, 0x38, 0x15, 0xF5, 0x40, 0xA0, 0x43, 0x81,
  0x5F, 0x43, 0x01, 0x0D, 0x48, 0x11, 0xEB, 0x28, 0x11, 0xB4, 0x58, 0x43, 0xBE, 0xDC, 0x45,
  // "ũ" (U+0169)
  0x00, 0x3C, 0xD5, 0x09, 0x00, 0x09, 0x04, 0xCC, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0x30,
  0x0B, 0xD0, 0x0B, 0xF0, 0x00, 0xEA, 0x00, 0xCC, 0x00, 0x2F, 0x70, 0x0F, 0x90, 0x05, 0xF4, 0x03,
  0xF6, 0x00, 0x8F, 0x10, 0x7F, 0x30, 0x0C, 0xD0, 0x0A, 0xF0, 0x03, 0xFA, 0x00, 0xCD, 0x00, 0xAF,
  0x80, 0x0D, 0xD0, 0x76, 0xF8, 0x10, 0x6E, 0xC4, 0x0B, 0xE9, 0x10,
  // "Ū" (U+016A)
  0x58, 0x3B, 0xDD, 0xD8, 0x77, 0x10, 0xEB, 0x82, 0x90, 0x2E, 0xA0, 0xA2, 0x81, 0xDF, 0x24, 0x90,
  0x33, 0x0E, 0x0B, 0x40, 0x20, 0xD3, 0x81, 0x2F, 0x84, 0x05, 0x09, 0x38, 0x15, 0xF5, 0x40, 0x80,
  0x63, 0x81, 0x9F, 0x14, 0x0C, 0x02, 0x30, 0xC0, 0xE5, 0x0E, 0x49, 0x0A, 0x40, 0x30, 0xB3, 0x81,
  0x3F, 0x74, 0x06, 0x08, 0x38, 0x15, 0xF5, 0x40, 0xA0, 0x43, 0x81, 0x5F, 0x43, 0x01, 0x0D, 0x48,
  0x11, 0xEB, 0x28, 0x11, 0xB4, 0x58, 0x43, 0xBE, 0xDC, 0x45,
  // "ū" (U+016B)
  0x00, 0x0B, 0xDD, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF3, 0x00, 0xBD, 0x00, 0xBF, 0x00,
  0x0E, 0xA0, 0x0C, 0xC0, 0x02, 0xF7, 0x00, 0xF9, 0x00, 0x5F, 0x40, 0x3F, 0x60, 0x08, 0xF1, 0x07,
  0xF3, 0x00, 0xCD, 0x00, 0xAF, 0x00, 0x3F, 0xA0, 0x0C, 0xD0, 0x0A, 0xF8, 0x00, 0xDD, 0x07, 0x6F,
  0x81, 0x06, 0xEC, 0x40, 0xBE, 0x91,
  // "Ŭ" (U+016C)
  0x40, 0x30, 0x22, 0x06, 0x78, 0x35, 0x90, 0x59, 0x71, 0x81, 0xAD, 0x97, 0x73, 0x0E, 0xB8, 0x29,
  0x02, 0xEA, 0x0A, 0x28, 0x1D, 0xF2, 0x49, 0x03, 0x30, 0xE0, 0xB4, 0x02, 0x0D, 0x38, 0x12, 0xF8,
  0x40, 0x50, 0x93, 0x81, 0x5F, 0x54, 0x08, 0x06, 0x38, 0x19, 0xF1, 0x40, 0xC0, 0x23, 0x0C, 0x0E,
  0x50, 0xE4, 0x90, 0xA4, 0x03, 0x0B, 0x38, 0x13, 0xF7, 0x40, 0x60, 0x83, 0x81, 0x5F, 0x54, 0x0A,
  0x04, 0x38, 0x15, 0xF4, 0x30, 0x10, 0xD4, 0x81, 0x1E, 0xB2, 0x81, 0x1B, 0x45, 0x84, 0x3B, 0xED,
  0xC4, 0x50,
  // "ŭ" (U+016D)
  0x00, 0x03, 0x20, 0x06, 0x00, 0x00, 0x59, 0x05, 0x90, 0x00, 0x00, 0xAD, 0x90, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xF3, 0x00, 0xBD, 0x00, 0xBF, 0x00, 0x0E, 0xA0, 0x0C, 0xC0, 0x02, 0xF7, 0x00,
  0xF9, 0x00, 0x5F, 0x40, 0x3F, 0x60, 0x08, 0xF1, 0x07, 0xF3, 0x00, 0xCD, 0x00, 0xAF, 0x00, 0x3F,
  0xA0, 0x0C, 0xD0, 0x0A, 0xF8, 0x00, 0xDD, 0x07, 0x6F, 0x81, 0x06, 0xEC, 0x40, 0xBE, 0x91,
  // "Ů" (U+016E)
  0x58, 0x21, 0xBD, 0x77, 0x18, 0x27, 0x60, 0xD7, 0x18, 0x28, 0x60, 0xD7, 0x18, 0x21, 0xCD, 0x67,
  0x72, 0x0E, 0xB8, 0x29, 0x02, 0xEA, 0x0A, 0x28, 0x1D, 0xF2, 0x49, 0x03, 0x30, 0xE0, 0xB4, 0x02,
  0x0D, 0x38, 0x12, 0xF8, 0x40, 0x50, 0x93, 0x81, 0x5F, 0x54, 0x08, 0x06, 0x38, 0x19, 0xF1, 0x40,
  0xC0, 0x23, 0x0C, 0x0E, 0x50, 0xE4, 0x90, 0xA4, 0x03, 0x0B, 0x38, 0x13, 0xF7, 0x40, 0x60, 0x83,
  0x81, 0x5F, 0x54, 0x0A, 0x04, 0x38, 0x15, 0xF4, 0x30, 0x10, 0xD4, 0x81, 0x1E, 0xB2, 0x81, 0x1B,
  0x45, 0x84, 0x3B, 0xED, 0xC4, 0x50,
  // "ů" (U+016F)
  0x38, 0x21, 0xBD, 0x75, 0x82, 0x76, 0x0D, 0x58, 0x28, 0x60, 0xD5, 0x82, 0x1C, 0xD6, 0x74, 0x0B,
  0xA0, 0x32, 0x0B, 0x0D, 0x20, 0xB9, 0x30, 0xE0, 0xA2, 0x00, 0xC2, 0x81, 0x2F, 0x72, 0x90, 0x92,
  0x85, 0x5F, 0x40, 0x3F, 0x62, 0x85, 0x8F, 0x10, 0x7F, 0x32, 0x0C, 0x0D, 0x20, 0xA9, 0x28, 0x13,
  0xFA, 0x20, 0xC0, 0xD2, 0x81, 0xAF, 0x82, 0x8A, 0x0D, 0xD0, 0x76, 0xF8, 0x10, 0x6E, 0xC4, 0x0B,
  0xE9, 0x10,
  // "Ű" (U+0170)
  0x68, 0x46, 0xE3, 0x9D, 0x15, 0x84, 0x1E, 0x54, 0xE3, 0x68, 0x3B, 0x50, 0xC3, 0x77, 0x10, 0xEB,
  0x82, 0x90, 0x2E, 0xA0, 0xA2, 0x81, 0xDF, 0x24, 0x90, 0x33, 0x0E, 0x0B, 0x40, 0x20, 0xD3, 0x81,
  0x2F, 0x84, 0x05, 0x09, 0x38, 0x15, 0xF5, 0x40, 0x80, 0x63, 0x81, 0x9F, 0x14, 0x0C, 0x02, 0x30,
  0xC0, 0xE5, 0x0E, 0x49, 0x0A, 0x40, 0x30, 0xB3, 0x81, 0x3F, 0x74, 0x06, 0x08, 0x38, 0x15, 0xF5,
  0x40, 0xA0, 0x43, 0x81, 0x5F, 0x43, 0x01, 0x0D, 0x48, 0x11, 0xEB, 0x28, 0x11, 0xB4, 0x58, 0x43,
  0xBE, 0xDC, 0x45,
  // "ű" (U+0171)
  0x48, 0x46, 0xE3, 0x9D, 0x13, 0x84, 0x1E, 0x54, 0xE3, 0x48, 0x3B, 0x50, 0xC3, 0x75, 0x0B, 0xA0,
  0x32, 0x0B, 0x0D, 0x30, 0xB9, 0x30, 0xE0, 0xA3, 0x00, 0xC2, 0x81, 0x2F, 0x73, 0x90, 0x92, 0x81,
  0x5F, 0x42, 0x81, 0x3F, 0x62, 0x81, 0x8F, 0x12, 0x81, 0x7F, 0x32, 0x0C, 0x0D, 0x30, 0xA9, 0x28,
  0x13, 0xFA, 0x30, 0xC0, 0xD2, 0x81, 0xAF, 0x83, 0x86, 0xDD, 0x07, 0x6F, 0x81, 0x28, 0x76, 0xEC,
  0x40, 0xBE, 0x91, 0x10,
  // "Ų" (U+0172)
  0x10, 0xEB, 0x82, 0x90, 0x2E, 0xA0, 0xA2, 0x81, 0xDF, 0x24, 0x90, 0x33, 0x0E, 0x0B, 0x40, 0x20,
  0xD3, 0x81, 0x2F, 0x84, 0x05, 0x09, 0x38, 0x15, 0xF5, 0x40, 0x80, 0x63, 0x81, 0x9F, 0x14, 0x0C,
  0x02, 0x30, 0xC0, 0xE5, 0x0E, 0x49, 0x0A, 0x40, 0x30, 0xB3, 0x81, 0x3F, 0x74, 0x06, 0x08, 0x38,
  0x15, 0xF5, 0x40, 0xA0, 0x43, 0x81, 0x5F, 0x43, 0x01, 0x0D, 0x48, 0x11, 0xEB, 0x28, 0x11, 0xB4,
  0x58, 0x43, 0xBE, 0xFD, 0x47, 0x81, 0x1C, 0x47, 0x20, 0x90, 0xA7, 0x30, 0x0B, 0x73, 0x82, 0x5F,
  0xE4, 0x60,
  // "ų" (U+0173)
  0x0B, 0xA0, 0x32, 0x0B, 0x0D, 0x20, 0xB9, 0x30, 0xE0, 0xA2, 0x00, 0xC2, 0x81, 0x2F, 0x72, 0x90,
  0x92, 0x85, 0x5F, 0x40, 0x3F, 0x62, 0x85, 0x8F, 0x10, 0x7F, 0x32, 0x0C, 0x0D, 0x20, 0xA9, 0x28,
  0x13, 0xFA, 0x20, 0xC0, 0xD2, 0x81, 0xAF, 0x82, 0x8A, 0x0D, 0xD0, 0x76, 0xF8, 0x10, 0x6E, 0xC4,
  0x0C, 0xFA, 0x14, 0x81, 0x1C, 0x46, 0x09, 0x0A, 0x70, 0x0B, 0x78, 0x25, 0xFE, 0x41,
  // "Ŵ" (U+0174)
  0x71, 0x81, 0x2F, 0xE7, 0x78, 0x2D, 0x8E, 0x47, 0x58, 0x3A, 0x50, 0x4A, 0x77, 0x71, 0x02, 0xB0,
  0xE0, 0x22, 0x00, 0xB3, 0x0D, 0xA8, 0x3B, 0x04, 0xFB, 0x38, 0x12, 0xFB, 0x40, 0xE0, 0x62, 0x81,
  0x2F, 0x93, 0x81, 0x9F, 0xC3, 0x02, 0x0D, 0x38, 0x11, 0xFA, 0x28, 0x21, 0xEC, 0xD3, 0x09, 0x06,
  0x49, 0x0A, 0x28, 0x27, 0x8B, 0xE2, 0x01, 0x0E, 0x59, 0x0B, 0x28, 0x2D, 0x2A, 0xE2, 0x00, 0x85,
  0x98, 0x4B, 0x05, 0xA0, 0x99, 0x20, 0xE0, 0x15, 0x89, 0x1E, 0xC0, 0xC3, 0x09, 0xF1, 0x69, 0x68,
  0x2D, 0xC3, 0xC2, 0x83, 0x8F, 0x1D, 0x26, 0x82, 0xDD, 0x95, 0x28, 0x27, 0xF6, 0xB7, 0x81, 0xCD,
  0xD3, 0x82, 0x6F, 0xC4, 0x78, 0x1B, 0xF7, 0x38, 0x16, 0xFC, 0x71, 0x81, 0xBE, 0x13, 0x81, 0x5F,
  0x56,
  // "ŵ" (U+0175)
  0x68, 0x12, 0xFE, 0x72, 0x82, 0xD8, 0xE4, 0x78, 0x3A, 0x50, 0x4A, 0x77, 0xA0, 0x82, 0x81, 0x2F,
  0x62, 0x83, 0xB9, 0x2F, 0x72, 0x81, 0x8F, 0x72, 0x83, 0x9B, 0x0F, 0x72, 0x81, 0xCE, 0x72, 0x89,
  0x07, 0x90, 0xF7, 0x05, 0x7E, 0x72, 0x8C, 0x2A, 0x40, 0xF7, 0x0B, 0x1E, 0x70, 0x1C, 0x01, 0xF6,
  0x39, 0x0E, 0x70, 0x84, 0x01, 0xF6, 0xA2, 0x0E, 0x81, 0xA2, 0x82, 0x1F, 0x7A, 0x28, 0x2E, 0x7A,
  0x22, 0x82, 0x1F, 0xD3, 0x28, 0x1E, 0xC7, 0x38, 0x12, 0xFA, 0x39, 0x0C, 0x40,
  // "Ŷ" (U+0176)
  0x58, 0x12, 0xFE, 0x71, 0x82, 0xD8, 0xE4, 0x68, 0x3A, 0x50, 0x4A, 0x76, 0x04, 0xB8, 0x2D, 0x03,
  0xEA, 0x83, 0x80, 0x7F, 0x83, 0x81, 0x1F, 0x52, 0x81, 0x2F, 0x93, 0x07, 0x09, 0x40, 0x0D, 0x20,
  0x20, 0xC5, 0x84, 0x9F, 0x20, 0xC3, 0x58, 0x34, 0xF6, 0x87, 0x79, 0x00, 0xB7, 0x18, 0x1C, 0xF2,
  0x71, 0x0E, 0x0C, 0x71, 0x81, 0x1F, 0x97, 0x18, 0x15, 0xF6, 0x71, 0x81, 0xAF, 0x46, 0x05, 0x0E,
  0xB0, 0x85,
  // "ŷ" (U+0177)
  0x78, 0x12, 0xFE, 0x72, 0x82, 0xD8, 0xE4, 0x78, 0x3A, 0x50, 0x4A, 0x77, 0x28, 0x18, 0xFE, 0x30,
  0xB0, 0xC5, 0x81, 0x9F, 0x22, 0x81, 0x8F, 0x14, 0x81, 0x5F, 0x52, 0x04, 0x95, 0x81, 0x1F, 0x82,
  0x06, 0x0B, 0x60, 0xD0, 0xB2, 0x0B, 0x05, 0x68, 0x3A, 0xE0, 0x2D, 0x78, 0x37, 0xF2, 0x96, 0x78,
  0x23, 0xF7, 0xC7, 0x2A, 0x04, 0x72, 0x0C, 0x0A, 0x72, 0x81, 0x3E, 0x17, 0x18, 0x11, 0xD5, 0x71,
  0x81, 0x5E, 0x76, 0x83, 0x6D, 0xDB, 0x47,
  // "Ÿ" (U+0178)
  0x38, 0x34, 0xC0, 0x5C, 0x68, 0x36, 0xC0, 0x6C, 0x77, 0x74, 0x04, 0xB8, 0x2D, 0x03, 0xEA, 0x83,
  0x80, 0x7F, 0x83, 0x81, 0x1F, 0x52, 0x81, 0x2F, 0x93, 0x07, 0x09, 0x40, 0x0D, 0x20, 0x20, 0xC5,
  0x84, 0x9F, 0x20, 0xC3, 0x58, 0x34, 0xF6, 0x87, 0x79, 0x00, 0xB7, 0x18, 0x1C, 0xF2, 0x71, 0x0E,
  0x0C, 0x71, 0x81, 0x1F, 0x97, 0x18, 0x15, 0xF6, 0x71, 0x81, 0xAF, 0x46, 0x05, 0x0E, 0xB0, 0x85,
  // "Ź" (U+0179)
  0x71, 0x81, 0x7F, 0x57, 0x18, 0x11, 0xE6, 0x72, 0x0B, 0x05, 0x77, 0x40, 0x89, 0x80, 0x0D, 0xA0,
  0x33, 0x0C, 0x06, 0x38, 0x16, 0xFA, 0x30, 0x10, 0xD3, 0x82, 0x2E, 0xD1, 0x40, 0x13, 0x81, 0xCF,
  0x37, 0x18, 0x18, 0xF8, 0x71, 0x81, 0x3F, 0xC7, 0x18, 0x21, 0xDE, 0x27, 0x18, 0x1A, 0xF6, 0x71,
  0x81, 0x5F, 0xA7, 0x18, 0x22, 0xED, 0x13, 0x01, 0x48, 0x1B, 0xF4, 0x30, 0x30, 0xA3, 0x81, 0x7F,
  0x84, 0x0A, 0x06, 0x20, 0x1A, 0x80, 0x0D, 0x81, 0xEF, 0x32,
  // "ź" (U+017A)
  0x58, 0x17, 0xF5, 0x48, 0x11, 0xE6, 0x50, 0xB0, 0x57, 0x58, 0x7E, 0xED, 0xEF, 0xA0, 0x3B, 0x28,
  0x90, 0xBF, 0x20, 0x32, 0x06, 0xF7, 0x48, 0x11, 0xEC, 0x58, 0x1B, 0xF2, 0x48, 0x15, 0xF7, 0x48,
  0x11, 0xEC, 0x58, 0x1A, 0xF2, 0x28, 0x3A, 0x05, 0xF7, 0x28, 0x90, 0x4A, 0x0D, 0xFD, 0xDD, 0xF7,
  0x10,
  // "Ż" (U+017B)
  0x68, 0x16, 0xF3, 0x72, 0x81, 0x6D, 0x27, 0x77, 0x72, 0x08, 0x98, 0x00, 0xDA, 0x03, 0x30, 0xC0,
  0x63, 0x81, 0x6F, 0xA3, 0x01, 0x0D, 0x38, 0x22, 0xED, 0x14, 0x01, 0x38, 0x1C, 0xF3, 0x71, 0x81,
  0x8F, 0x87, 0x18, 0x13, 0xFC, 0x71, 0x82, 0x1D, 0xE2, 0x71, 0x81, 0xAF, 0x67, 0x18, 0x15, 0xFA,
  0x71, 0x82, 0x2E, 0xD1, 0x30, 0x14, 0x81, 0xBF, 0x43, 0x03, 0x0A, 0x38, 0x17, 0xF8, 0x40, 0xA0,
  0x62, 0x01, 0xA8, 0x00, 0xD8, 0x1E, 0xF3, 0x20,
  // "ż" (U+017C)
  0x48, 0x16, 0xF3, 0x58, 0x16, 0xD2, 0x77, 0x58, 0x7E, 0xED, 0xEF, 0xA0, 0x3B, 0x28, 0x90, 0xBF,
  0x20, 0x32, 0x06, 0xF7, 0x48, 0x11, 0xEC, 0x58, 0x1B, 0xF2, 0x48, 0x15, 0xF7, 0x48, 0x11, 0xEC,
  0x58, 0x1A, 0xF2, 0x28, 0x3A, 0x05, 0xF7, 0x28, 0x90, 0x4A, 0x0D, 0xFD, 0xDD, 0xF7, 0x10,
  // "Ž" (U+017D)
  0x58, 0x44, 0x90, 0x2C, 0x27, 0x82, 0xD7, 0xE4, 0x71, 0x81, 0x9F, 0x77, 0x74, 0x08, 0x98, 0x00,
  0xDA, 0x03, 0x30, 0xC0, 0x63, 0x81, 0x6F, 0xA3, 0x01, 0x0D, 0x38, 0x22, 0xED, 0x14, 0x01, 0x38,
  0x1C, 0xF3, 0x71, 0x81, 0x8F, 0x87, 0x18, 0x13, 0xFC, 0x71, 0x82, 0x1D, 0xE2, 0x71, 0x81, 0xAF,
  0x67, 0x18, 0x15, 0xFA, 0x71, 0x82, 0x2E, 0xD1, 0x30, 0x14, 0x81, 0xBF, 0x43, 0x03, 0x0A, 0x38,
  0x17, 0xF8, 0x40, 0xA0, 0x62, 0x01, 0xA8, 0x00, 0xD8, 0x1E, 0xF3, 0x20,
  // "ž" (U+017E)
  0x38, 0x44, 0x90, 0x2C, 0x24, 0x82, 0xD7, 0xE4, 0x58, 0x19, 0xF7, 0x76, 0x84, 0xEE, 0xDE, 0xFA,
  0x20, 0x30, 0xB2, 0x81, 0xBF, 0x22, 0x84, 0x32, 0x06, 0xF7, 0x58, 0x11, 0xEC, 0x68, 0x1B, 0xF2,
  0x58, 0x15, 0xF7, 0x58, 0x11, 0xEC, 0x68, 0x1A, 0xF2, 0x20, 0xA2, 0x81, 0x5F, 0x72, 0x04, 0x0A,
  0x28, 0x5D, 0xFD, 0xDD, 0xF7, 0x20,
  // "ſ" (U+017F)
  0x78, 0x27, 0xDE, 0x97, 0x84, 0x6F, 0x26, 0xF1, 0x68, 0x3D, 0xB0, 0x24, 0x68, 0x11, 0xF7, 0x72,
  0x81, 0x5F, 0x47, 0x28, 0x18, 0xF1, 0x72, 0x0C, 0x0D, 0x73, 0x90, 0x97, 0x28, 0x13, 0xF6, 0x72,
  0x81, 0x6F, 0x37, 0x20, 0x90, 0xE7, 0x30, 0xD0, 0xB7, 0x28, 0x11, 0xF8, 0x72, 0x81, 0x4F, 0x57,
  0x28, 0x18, 0xF1, 0x72, 0x0C, 0x0B, 0x72, 0x81, 0x5F, 0x47, 0x82, 0x2D, 0xC4, 0x71,
  // "Ω" (U+03A9)
  0x48, 0x54, 0xBD, 0xED, 0x91, 0x48, 0x19, 0xE5, 0x28, 0x13, 0xEC, 0x38, 0x17, 0xF5, 0x48, 0x17,
  0xF5, 0x20, 0xE0, 0xD5, 0x85, 0x4F, 0x80, 0x5F, 0x85, 0x85, 0x5F, 0x80, 0x7F, 0x65, 0x85, 0x7F,
  0x60, 0x7F, 0x55, 0x85, 0xCF, 0x10, 0x5F, 0x64, 0x81, 0x3F, 0x93, 0x0D, 0x0C, 0x38, 0x13, 0xDB,
  0x28, 0x94, 0x10, 0x2B, 0xE0, 0xBC, 0x60, 0x10, 0xC1, 0x28, 0x1C, 0x1B, 0x28, 0x94, 0x59, 0x0E,
  0x96, 0x79, 0x5B, 0x67, 0xE5, 0x1C, 0x06, 0x08, 0xC0, 0x11,
  // "μ" (U+03BC)
  0x38, 0x16, 0xF3, 0x20, 0xA0, 0xE3, 0x09, 0x93, 0x0D, 0x0B, 0x30, 0xD0, 0xC2, 0x81, 0x1F, 0x83,
  0x90, 0x92, 0x81, 0x4F, 0x52, 0x81, 0x4F, 0x62, 0x81, 0x7F, 0x22, 0x81, 0x7F, 0x22, 0x0A, 0x0E,
  0x30, 0xA9, 0x30, 0xD0, 0xB3, 0x00, 0xE2, 0x81, 0x3F, 0x82, 0x02, 0xA8, 0x31, 0x1A, 0xF7, 0x28,
  0x92, 0x7A, 0xBE, 0xA1, 0xCD, 0x90, 0xB6, 0x71, 0x0E, 0x05, 0x78, 0x11, 0xFA, 0x71, 0x0D, 0x0A,
  0x70,
  // "π" (U+03C0)
  0x04, 0xCE, 0xED, 0xDE, 0xED, 0x30, 0xB1, 0x86, 0x00, 0xB3, 0x00, 0x01, 0x0C, 0x20, 0x1E, 0x00,
  0x00, 0x01, 0xE0, 0x05, 0xB0, 0x00, 0x00, 0x6B, 0x00, 0x98, 0x00, 0x00, 0x0A, 0x70, 0x0C, 0x50,
  0x00, 0x00, 0xE4, 0x00, 0xF3, 0x00, 0x00, 0x5F, 0x00, 0x2F, 0x10, 0x00, 0x4D, 0xA0, 0x03, 0xF5,
  0x30, 0x0D, 0xD2, 0x00, 0x0D, 0xD5, 0x00,
  // "–" (U+2013)
  0x01, 0x80, 0x5D, 0x01,
  // "—" (U+2014)
  0x01, 0x80, 0x96, 0xD0, 0x10,
  // "€" (U+20AC)
  0x58, 0x38, 0xCE, 0xC2, 0x48, 0x4C, 0x90, 0x2F, 0x93, 0x09, 0x0D, 0x30, 0xA0, 0x42, 0x81, 0x2F,
  0x67, 0x81, 0x8F, 0x16, 0x0C, 0xA0, 0xFD, 0x48, 0x11, 0xF8, 0x68, 0x45, 0xEF, 0xED, 0xD5, 0x81,
  0x4F, 0x57, 0x81, 0x4F, 0x57, 0x81, 0x2F, 0x77, 0x18, 0x4C, 0xD1, 0x04, 0x54, 0x83, 0x2B, 0xED,
  0x83,
  // "₿" (U+20BF)
  0x68, 0x15, 0x14, 0x68, 0x21, 0xB5, 0x74, 0x0E, 0xA8, 0x1E, 0xE9, 0x59, 0x83, 0xC0, 0x9F, 0x53,
  0x85, 0x1F, 0x90, 0x3F, 0x93, 0x85, 0x5F, 0x60, 0x4F, 0x83, 0x85, 0x8F, 0x30, 0x7F, 0x53, 0x84,
  0xBF, 0x03, 0xEB, 0x48, 0x3E, 0xFE, 0xFC, 0x48, 0x52, 0xF9, 0x06, 0xF7, 0x38, 0x16, 0xF5, 0x29,
  0x0C, 0x38, 0x19, 0xF2, 0x29, 0x0B, 0x30, 0xC0, 0xE2, 0x81, 0x4F, 0x82, 0x89, 0x02, 0xFA, 0x01,
  0xCE, 0x10, 0x7A, 0x0F, 0xE0, 0x90, 0x15, 0x81, 0xB4, 0x76, 0x82, 0x14, 0x32, 0x40,
  // "‘" (U+2018)
  0x00, 0x68, 0x07, 0x70, 0x0E, 0x30, 0x1F, 0xE0, 0x0B, 0xC0,
  // "’" (U+2019)
  0x06, 0xE3, 0x07, 0xF7, 0x00, 0xC4, 0x05, 0xA0, 0x36, 0x00,
  // "‚" (U+201A)
  0x08, 0xE2, 0x09, 0xF6, 0x00, 0xE3, 0x04, 0xB0, 0x58, 0x00,
  // "‛" (U+201B)
  0x2D, 0x99, 0xF8, 0xA8, 0x07, 0x60, 0x0B, 0x30,
  // "“" (U+201C)
  0x00, 0x68, 0x05, 0xA0, 0x77, 0x05, 0x90, 0x0E, 0x30, 0xC6, 0x01, 0xFE, 0x0F, 0xE1, 0x0B, 0xC0,
  0xAD, 0x10,
  // "”" (U+201D)
  0x06, 0xE3, 0x5E, 0x50, 0x8F, 0x76, 0xF9, 0x00, 0xD5, 0x0B, 0x70, 0x2C, 0x01, 0xC1, 0x49, 0x13,
  0x91, 0x00,
  // "„" (U+201E)
  0x08, 0xE2, 0x6E, 0x30, 0x9F, 0x67, 0xF7, 0x00, 0xE3, 0x0D, 0x50, 0x4B, 0x03, 0xB0, 0x58, 0x04,
  0x81, 0x00,
  // "‟" (U+201F)
  0x2D, 0x92, 0xD9, 0x9F, 0x89, 0xF8, 0xA8, 0x0A, 0x80, 0x76, 0x07, 0x60, 0x0B, 0x30, 0xB3,
  // "†" (U+2020)
  0x38, 0x13, 0xF3, 0x40, 0x50, 0xD5, 0x07, 0x09, 0x50, 0x80, 0x42, 0x89, 0x44, 0xDB, 0xDA, 0xC8,
  0x35, 0x3D, 0x25, 0x32, 0x08, 0x95, 0x00, 0xD5, 0x0E, 0x08, 0x59, 0x03, 0x40, 0x20, 0xE5, 0x05,
  0x0A, 0x50, 0x70, 0x65, 0x0A, 0x02, 0x50, 0xB6, 0x0A, 0x50,
  // "‡" (U+2021)
  0x48, 0x14, 0xF2, 0x50, 0x50, 0xD6, 0x06, 0x08, 0x38, 0x95, 0x1C, 0xAB, 0xAA, 0xA0, 0x27, 0x4D,
  0x46, 0x53, 0x81, 0x5F, 0x25, 0x07, 0x0C, 0x60, 0x50, 0x46, 0x08, 0x01, 0x58, 0x12, 0xE3, 0x58,
  0x15, 0xF2, 0x38, 0x46, 0x46, 0xB3, 0x62, 0x84, 0xDB, 0xCB, 0xBD, 0x40, 0xB0, 0x35, 0x81, 0x1F,
  0x25, 0x81, 0x6F, 0x14,
  // "•" (U+2022)
  0x2C, 0xE8, 0x0A, 0xFF, 0xF2, 0xCF, 0xFF, 0x4B, 0xFF, 0xF2, 0x3D, 0xE7, 0x00,
  // "…" (U+2026)
  0x01, 0x00, 0x00, 0x10, 0x00, 0x10, 0x2F, 0xA0, 0x0A, 0xF2, 0x02, 0xFA, 0x2E, 0x80, 0x09, 0xD1,
  0x02, 0xE7,
  // "‰" (U+2030)
  0x28, 0x29, 0xDC, 0x13, 0x07, 0x09, 0x72, 0x83, 0xAA, 0x0B, 0x82, 0x81, 0x2D, 0x17, 0x18, 0x42,
  0xF2, 0x09, 0xB2, 0x0B, 0x05, 0x72, 0x07, 0x0D, 0x28, 0x3A, 0x90, 0x5B, 0x73, 0x00, 0xA2, 0x83,
  0xE6, 0x1D, 0x27, 0x38, 0x92, 0xA9, 0x03, 0xF1, 0x97, 0x1A, 0xD9, 0x28, 0xB7, 0x1A, 0xDA, 0x08,
  0xB0, 0xC8, 0x4D, 0x0D, 0x70, 0xE4, 0x0B, 0x90, 0xE5, 0x1B, 0xD8, 0x0D, 0x35, 0xE2, 0x82, 0xD6,
  0x4E, 0x20, 0xC0, 0x84, 0x83, 0x89, 0x0B, 0x92, 0x82, 0xE5, 0x9A, 0x20, 0xD0, 0x73, 0x89, 0x62,
  0xE1, 0x0D, 0x60, 0x2F, 0x3C, 0x70, 0x1F, 0x43, 0x0B, 0x05, 0x28, 0x91, 0xE4, 0x07, 0xC0, 0xD6,
  0x06, 0xE3, 0x06, 0x0B, 0x38, 0x91, 0xC6, 0x1E, 0x50, 0xB8, 0x1D, 0x62, 0x81, 0x1E, 0x23, 0x82,
  0x4D, 0xD6, 0x28, 0x23, 0xDD, 0x72,
  // "‹" (U+2039)
  0x00, 0x3A, 0x03, 0xE2, 0x2E, 0x60, 0xCD, 0x00, 0x8E, 0x00, 0x1E, 0x30, 0x07, 0x70,
  // "›" (U+203A)
  0x00, 0xD0, 0x00, 0x0B, 0x70, 0x00, 0x7E, 0x10, 0x05, 0xF4, 0x00, 0xD9, 0x00, 0x8A, 0x00, 0x3A,
  0x00, 0x00,
  // "⁄" (U+2044)
  0x78, 0x12, 0xD1, 0x70, 0xB0, 0x57, 0x05, 0x0B, 0x78, 0x11, 0xD2, 0x70, 0x90, 0x77, 0x03, 0x0C,
  0x71, 0x0D, 0x03, 0x70, 0x80, 0x97, 0x81, 0x2D, 0x17, 0x0B, 0x05, 0x70, 0x60, 0xB7, 0x81, 0x1D,
  0x27, 0x0A, 0x07, 0x71,
  // "™" (U+2122)
  0x0B, 0x9B, 0xA6, 0xA9, 0x00, 0x0C, 0x71, 0x54, 0xA0, 0x65, 0xE1, 0x05, 0xE1, 0x00, 0x4A, 0x00,
  0x5A, 0x60, 0x7D, 0x10, 0x04, 0xA0, 0x05, 0x5A, 0x06, 0xD1, 0x00, 0x4A, 0x00, 0x52, 0xD6, 0x1D,
  0x10, 0x04, 0xA0, 0x06, 0x28, 0xB0, 0xD1, 0x00, 0x9A, 0x30, 0x96, 0x35, 0x3B, 0x70,
  // "⅒" (U+2152)
  0x40, 0x27, 0x71, 0x81, 0x1A, 0xC4, 0x81, 0x2D, 0x17, 0x82, 0x5D, 0xD8, 0x40, 0xB0, 0x57, 0x18,
  0x21, 0x1E, 0x53, 0x05, 0x0B, 0x73, 0x81, 0x2F, 0x22, 0x81, 0x1D, 0x27, 0x30, 0x50, 0xE3, 0x09,
  0x07, 0x20, 0x27, 0x10, 0x80, 0xB2, 0x84, 0x3C, 0x01, 0xAC, 0x28, 0x26, 0xBB, 0x32, 0x0C, 0x09,
  0x28, 0xB3, 0xD3, 0x5D, 0xD8, 0x06, 0xC0, 0x6D, 0x39, 0xCB, 0x68, 0x90, 0x11, 0xE5, 0x0D, 0x50,
  0x59, 0x48, 0x12, 0xD1, 0x28, 0x72, 0xF2, 0x4F, 0x10, 0x6E, 0x40, 0xB0, 0x53, 0x83, 0x5E, 0x06,
  0xE2, 0x09, 0x0B, 0x30, 0x60, 0xB4, 0x83, 0x8B, 0x07, 0xC2, 0x0D, 0x05, 0x28, 0x11, 0xD2, 0x48,
  0x6C, 0x90, 0x5E, 0x06, 0xC3, 0x0A, 0x07, 0x38, 0x90, 0x39, 0xCB, 0x60, 0x8C, 0xA1, 0x10,
  // "ﬁ" (U+FB01)
  0x78, 0x36, 0xCD, 0xD6, 0x68, 0x45, 0xF3, 0x0B, 0xD6, 0x0D, 0x0B, 0x20, 0x30, 0x15, 0x81, 0x2F,
  0x77, 0x18, 0x68, 0xEF, 0xDD, 0xDF, 0x95, 0x09, 0x92, 0x81, 0x4F, 0x55, 0x00, 0xC2, 0x81, 0x7F,
  0x25, 0x90, 0x82, 0x0A, 0x0E, 0x58, 0x13, 0xF5, 0x20, 0xD0, 0xC5, 0x85, 0x7F, 0x20, 0x1F, 0x85,
  0x0A, 0x0E, 0x28, 0x14, 0xF5, 0x50, 0xD0, 0xB2, 0x81, 0x6F, 0x34, 0x81, 0x1F, 0x82, 0x82, 0x6F,
  0x32, 0x38, 0x14, 0xF4, 0x28, 0x22, 0xDD, 0x73, 0x81, 0x8F, 0x17, 0x20, 0xD0, 0xB7, 0x28, 0x15,
  0xF3, 0x78, 0x22, 0xDD, 0x57, 0x10,
  // "ﬂ" (U+FB02)
  0x78, 0x46, 0xDD, 0xDD, 0x76, 0x85, 0x6F, 0x30, 0xBF, 0x46, 0x0D, 0x0B, 0x28, 0x19, 0xF1, 0x58,
  0x12, 0xF7, 0x20, 0xB0, 0xD5, 0x86, 0x8E, 0xFD, 0xC0, 0xEA, 0x60, 0x99, 0x28, 0x12, 0xF6, 0x60,
  0x0C, 0x28, 0x16, 0xF3, 0x69, 0x08, 0x20, 0x99, 0x68, 0x13, 0xF5, 0x20, 0x0C, 0x68, 0x17, 0xF2,
  0x29, 0x09, 0x60, 0xA0, 0xE2, 0x81, 0x3F, 0x66, 0x0D, 0x0B, 0x28, 0x16, 0xF3, 0x58, 0x11, 0xF8,
  0x28, 0x26, 0xF3, 0x24, 0x81, 0x4F, 0x42, 0x82, 0x2D, 0xD7, 0x48, 0x18, 0xF1, 0x73, 0x0D, 0x0B,
  0x73, 0x81, 0x5F, 0x37, 0x18, 0x22, 0xDD, 0x57, 0x20,
};

const Font& font_NotoSerif_CondensedItalic_18() {
  static SmoothFont font(font_NotoSerif_CondensedItalic_18_data);
  return font;
}

}  // namespace roo_display
