#include "10.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-CondensedItalic (Noto Serif Condensed Italic)
// Generated on Wed Nov 19 19:11:52 CET 2025
static const uint8_t font_NotoSerif_CondensedItalic_10_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x05, 0x9A,
  0xFE, 0xFE, 0x0A, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0B, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x40, 0x01, 0x02, 0x08, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x41, 0x06, 0x03, 0x08, 0x04, 0x00, 0x0C, // """ (U+0022)
  0x00, 0x23, 0x40, 0x01, 0x04, 0x08, 0x05, 0x00, 0x11, // "#" (U+0023)
  0x00, 0x24, 0x40, 0x00, 0x04, 0x08, 0x05, 0x00, 0x25, // "$" (U+0024)
  0x00, 0x25, 0x40, 0x01, 0x07, 0x08, 0x08, 0x00, 0x3C, // "%" (U+0025)
  0x00, 0x26, 0x40, 0x01, 0x06, 0x08, 0x06, 0x00, 0x5C, // "&" (U+0026)
  0x00, 0x27, 0x41, 0x06, 0x02, 0x08, 0x02, 0x00, 0x78, // "'" (U+0027)
  0x00, 0x28, 0x40, 0x00, 0x03, 0x08, 0x03, 0x00, 0x7B, // "(" (U+0028)
  0x00, 0x29, 0xBF, 0xFF, 0x02, 0x08, 0x03, 0x00, 0x8D, // ")" (U+0029)
  0x00, 0x2A, 0x41, 0x04, 0x04, 0x08, 0x04, 0x00, 0xA1, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x04, 0x07, 0x05, 0x00, 0xAB, // "+" (U+002B)
  0x00, 0x2C, 0xBF, 0xFF, 0x01, 0x01, 0x02, 0x00, 0xB6, // "," (U+002C)
  0x00, 0x2D, 0x40, 0x03, 0x02, 0x03, 0x03, 0x00, 0xBB, // "-" (U+002D)
  0x00, 0x2E, 0x40, 0x01, 0x01, 0x02, 0x02, 0x00, 0xBD, // "." (U+002E)
  0x00, 0x2F, 0xFF, 0xFF, 0x03, 0x08, 0x02, 0x00, 0xBF, // "/" (U+002F)
  0x00, 0x30, 0x40, 0x01, 0x04, 0x08, 0x05, 0x00, 0xD5, // "0" (U+0030)
  0x00, 0x31, 0x40, 0x01, 0x03, 0x08, 0x05, 0x00, 0xE9, // "1" (U+0031)
  0x00, 0x32, 0x40, 0x01, 0x04, 0x08, 0x05, 0x00, 0xF9, // "2" (U+0032)
  0x00, 0x33, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x0D, // "3" (U+0033)
  0x00, 0x34, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x21, // "4" (U+0034)
  0x00, 0x35, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x35, // "5" (U+0035)
  0x00, 0x36, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x49, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x05, 0x08, 0x05, 0x01, 0x5D, // "7" (U+0037)
  0x00, 0x38, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x74, // "8" (U+0038)
  0x00, 0x39, 0x40, 0x01, 0x04, 0x08, 0x05, 0x01, 0x88, // "9" (U+0039)
  0x00, 0x3A, 0x40, 0x01, 0x02, 0x06, 0x03, 0x01, 0x9C, // ":" (U+003A)
  0x00, 0x3B, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x01, 0xA5, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x04, 0x06, 0x05, 0x01, 0xB1, // "<" (U+003C)
  0x00, 0x3D, 0x40, 0x03, 0x04, 0x05, 0x05, 0x01, 0xBD, // "=" (U+003D)
  0x00, 0x3E, 0x40, 0x02, 0x04, 0x06, 0x05, 0x01, 0xC5, // ">" (U+003E)
  0x00, 0x3F, 0x41, 0x01, 0x04, 0x08, 0x04, 0x01, 0xD2, // "?" (U+003F)
  0x00, 0x40, 0x40, 0xFF, 0x07, 0x08, 0x08, 0x01, 0xE2, // "@" (U+0040)
  0x00, 0x41, 0xFF, 0x01, 0x05, 0x08, 0x06, 0x02, 0x0A, // "A" (U+0041)
  0x00, 0x42, 0x40, 0x01, 0x05, 0x08, 0x06, 0x02, 0x25, // "B" (U+0042)
  0x00, 0x43, 0x40, 0x01, 0x05, 0x08, 0x05, 0x02, 0x3D, // "C" (U+0043)
  0x00, 0x44, 0x40, 0x01, 0x06, 0x08, 0x06, 0x02, 0x55, // "D" (U+0044)
  0x00, 0x45, 0x40, 0x01, 0x05, 0x08, 0x05, 0x02, 0x71, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x05, 0x08, 0x05, 0x02, 0x89, // "F" (U+0046)
  0x00, 0x47, 0x40, 0x01, 0x06, 0x08, 0x06, 0x02, 0xA0, // "G" (U+0047)
  0x00, 0x48, 0x40, 0x01, 0x07, 0x08, 0x07, 0x02, 0xBC, // "H" (U+0048)
  0x00, 0x49, 0x40, 0x01, 0x03, 0x08, 0x03, 0x02, 0xDC, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFE, 0x03, 0x08, 0x03, 0x02, 0xEC, // "J" (U+004A)
  0x00, 0x4B, 0x40, 0x01, 0x06, 0x08, 0x06, 0x03, 0x08, // "K" (U+004B)
  0x00, 0x4C, 0x40, 0x01, 0x04, 0x08, 0x05, 0x03, 0x24, // "L" (U+004C)
  0x00, 0x4D, 0x40, 0x01, 0x08, 0x08, 0x08, 0x03, 0x38, // "M" (U+004D)
  0x00, 0x4E, 0x40, 0x01, 0x07, 0x08, 0x07, 0x03, 0x5C, // "N" (U+004E)
  0x00, 0x4F, 0x40, 0x01, 0x06, 0x08, 0x06, 0x03, 0x7C, // "O" (U+004F)
  0x00, 0x50, 0x40, 0x01, 0x05, 0x08, 0x05, 0x03, 0x98, // "P" (U+0050)
  0x00, 0x51, 0x40, 0xFE, 0x06, 0x08, 0x06, 0x03, 0xB0, // "Q" (U+0051)
  0x00, 0x52, 0x40, 0x01, 0x05, 0x08, 0x06, 0x03, 0xD7, // "R" (U+0052)
  0x00, 0x53, 0x40, 0x01, 0x04, 0x08, 0x05, 0x03, 0xEF, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x06, 0x08, 0x05, 0x04, 0x03, // "T" (U+0054)
  0x00, 0x55, 0x40, 0x01, 0x06, 0x08, 0x06, 0x04, 0x1A, // "U" (U+0055)
  0x00, 0x56, 0x41, 0x01, 0x06, 0x08, 0x06, 0x04, 0x36, // "V" (U+0056)
  0x00, 0x57, 0x41, 0x01, 0x09, 0x08, 0x09, 0x04, 0x4E, // "W" (U+0057)
  0x00, 0x58, 0xFF, 0x01, 0x06, 0x08, 0x06, 0x04, 0x72, // "X" (U+0058)
  0x00, 0x59, 0x01, 0x01, 0x06, 0x08, 0x05, 0x04, 0x8F, // "Y" (U+0059)
  0x00, 0x5A, 0x40, 0x01, 0x05, 0x08, 0x05, 0x04, 0xA6, // "Z" (U+005A)
  0x00, 0x5B, 0x40, 0xFF, 0x03, 0x08, 0x03, 0x04, 0xBE, // "[" (U+005B)
  0x00, 0x5C, 0x01, 0xFF, 0x01, 0x08, 0x02, 0x04, 0xD2, // "\" (U+005C)
  0x00, 0x5D, 0xBF, 0xFF, 0x03, 0x08, 0x03, 0x04, 0xD5, // "]" (U+005D)
  0x00, 0x5E, 0x40, 0x04, 0x04, 0x08, 0x05, 0x04, 0xEE, // "^" (U+005E)
  0x00, 0x5F, 0xBF, 0xFF, 0x03, 0xFF, 0x04, 0x04, 0xFB, // "_" (U+005F)
  0x00, 0x60, 0x41, 0x08, 0x02, 0x09, 0x03, 0x04, 0xFE, // "`" (U+0060)
  0x00, 0x61, 0x40, 0x01, 0x04, 0x06, 0x05, 0x05, 0x00, // "a" (U+0061)
  0x00, 0x62, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0x0F, // "b" (U+0062)
  0x00, 0x63, 0x40, 0x01, 0x04, 0x06, 0x04, 0x05, 0x23, // "c" (U+0063)
  0x00, 0x64, 0x40, 0x01, 0x05, 0x08, 0x05, 0x05, 0x32, // "d" (U+0064)
  0x00, 0x65, 0x40, 0x01, 0x04, 0x06, 0x04, 0x05, 0x4A, // "e" (U+0065)
  0x00, 0x66, 0xFE, 0xFE, 0x04, 0x08, 0x03, 0x05, 0x59, // "f" (U+0066)
  0x00, 0x67, 0xBF, 0xFE, 0x05, 0x06, 0x05, 0x05, 0x76, // "g" (U+0067)
  0x00, 0x68, 0x40, 0x01, 0x04, 0x08, 0x05, 0x05, 0x96, // "h" (U+0068)
  0x00, 0x69, 0x40, 0x01, 0x02, 0x08, 0x03, 0x05, 0xAA, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFE, 0x02, 0x08, 0x03, 0x05, 0xB6, // "j" (U+006A)
  0x00, 0x6B, 0x40, 0x01, 0x05, 0x08, 0x05, 0x05, 0xD0, // "k" (U+006B)
  0x00, 0x6C, 0x40, 0x01, 0x02, 0x08, 0x03, 0x05, 0xE8, // "l" (U+006C)
  0x00, 0x6D, 0x40, 0x01, 0x07, 0x06, 0x08, 0x05, 0xF4, // "m" (U+006D)
  0x00, 0x6E, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x0C, // "n" (U+006E)
  0x00, 0x6F, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x1B, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x06, 0x2A, // "p" (U+0070)
  0x00, 0x71, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x06, 0x40, // "q" (U+0071)
  0x00, 0x72, 0x40, 0x01, 0x04, 0x06, 0x04, 0x06, 0x57, // "r" (U+0072)
  0x00, 0x73, 0x40, 0x01, 0x03, 0x06, 0x04, 0x06, 0x66, // "s" (U+0073)
  0x00, 0x74, 0x40, 0x01, 0x03, 0x08, 0x03, 0x06, 0x72, // "t" (U+0074)
  0x00, 0x75, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0x82, // "u" (U+0075)
  0x00, 0x76, 0x40, 0x00, 0x04, 0x06, 0x05, 0x06, 0x91, // "v" (U+0076)
  0x00, 0x77, 0x40, 0x01, 0x06, 0x06, 0x07, 0x06, 0xA3, // "w" (U+0077)
  0x00, 0x78, 0x40, 0x01, 0x04, 0x06, 0x05, 0x06, 0xB8, // "x" (U+0078)
  0x00, 0x79, 0xFE, 0xFE, 0x04, 0x06, 0x05, 0x06, 0xC7, // "y" (U+0079)
  0x00, 0x7A, 0x40, 0x01, 0x04, 0x06, 0x04, 0x06, 0xE4, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x04, 0x08, 0x04, 0x06, 0xF3, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x02, 0x08, 0x05, 0x07, 0x0B, // "|" (U+007C)
  0x00, 0x7D, 0xBF, 0xFF, 0x03, 0x08, 0x04, 0x07, 0x0D, // "}" (U+007D)
  0x00, 0x7E, 0x40, 0x04, 0x04, 0x05, 0x05, 0x07, 0x26, // "~" (U+007E)
  0x00, 0xA1, 0x40, 0xFF, 0x02, 0x06, 0x03, 0x07, 0x2B, // "¡" (U+00A1)
  0x00, 0xA2, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x37, // "¢" (U+00A2)
  0x00, 0xA3, 0x40, 0x01, 0x04, 0x08, 0x05, 0x07, 0x4B, // "£" (U+00A3)
  0x00, 0xA4, 0x41, 0x03, 0x04, 0x07, 0x06, 0x07, 0x5F, // "¤" (U+00A4)
  0x00, 0xA5, 0x40, 0x01, 0x05, 0x08, 0x05, 0x07, 0x69, // "¥" (U+00A5)
  0x00, 0xA6, 0x42, 0xFE, 0x02, 0x08, 0x05, 0x07, 0x81, // "¦" (U+00A6)
  0x00, 0xA7, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x07, 0x87, // "§" (U+00A7)
  0x00, 0xA8, 0x42, 0x08, 0x04, 0x08, 0x05, 0x07, 0xA0, // "¨" (U+00A8)
  0x00, 0xA9, 0x40, 0x01, 0x06, 0x09, 0x07, 0x07, 0xA2, // "©" (U+00A9)
  0x00, 0xAA, 0x40, 0x05, 0x03, 0x07, 0x03, 0x07, 0xC2, // "ª" (U+00AA)
  0x00, 0xAB, 0x40, 0x02, 0x04, 0x05, 0x04, 0x07, 0xC8, // "«" (U+00AB)
  0x00, 0xAC, 0x40, 0x01, 0x04, 0x04, 0x05, 0x07, 0xD2, // "¬" (U+00AC)
  0x00, 0xAE, 0x40, 0x01, 0x06, 0x09, 0x07, 0x07, 0xDC, // "®" (U+00AE)
  0x00, 0xAF, 0x41, 0x09, 0x05, 0x09, 0x04, 0x07, 0xFC, // "¯" (U+00AF)
  0x00, 0xB0, 0x41, 0x05, 0x03, 0x08, 0x03, 0x07, 0xFF, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x06, 0x05, 0x08, 0x05, // "±" (U+00B1)
  0x00, 0xB2, 0x40, 0x05, 0x03, 0x09, 0x03, 0x08, 0x13, // "²" (U+00B2)
  0x00, 0xB3, 0x40, 0x05, 0x03, 0x09, 0x03, 0x08, 0x1D, // "³" (U+00B3)
  0x00, 0xB4, 0x41, 0x08, 0x02, 0x09, 0x02, 0x08, 0x27, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x08, 0x29, // "µ" (U+00B5)
  0x00, 0xB6, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x08, 0x3E, // "¶" (U+00B6)
  0x00, 0xB7, 0x40, 0x04, 0x01, 0x05, 0x02, 0x08, 0x5C, // "·" (U+00B7)
  0x00, 0xB8, 0x40, 0xFE, 0x02, 0x00, 0x03, 0x08, 0x5E, // "¸" (U+00B8)
  0x00, 0xB9, 0x41, 0x05, 0x03, 0x09, 0x03, 0x08, 0x63, // "¹" (U+00B9)
  0x00, 0xBA, 0x40, 0x05, 0x03, 0x07, 0x04, 0x08, 0x6B, // "º" (U+00BA)
  0x00, 0xBB, 0x40, 0x02, 0x03, 0x05, 0x04, 0x08, 0x71, // "»" (U+00BB)
  0x00, 0xBC, 0x41, 0x01, 0x06, 0x08, 0x08, 0x08, 0x79, // "¼" (U+00BC)
  0x00, 0xBD, 0x41, 0x01, 0x06, 0x08, 0x08, 0x08, 0x91, // "½" (U+00BD)
  0x00, 0xBE, 0x40, 0x01, 0x06, 0x08, 0x08, 0x08, 0xA9, // "¾" (U+00BE)
  0x00, 0xBF, 0x40, 0xFF, 0x03, 0x06, 0x04, 0x08, 0xC5, // "¿" (U+00BF)
  0x00, 0xC0, 0xFF, 0x01, 0x05, 0x0B, 0x06, 0x08, 0xD5, // "À" (U+00C0)
  0x00, 0xC1, 0xFF, 0x01, 0x05, 0x0B, 0x06, 0x08, 0xF4, // "Á" (U+00C1)
  0x00, 0xC2, 0xFF, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x14, // "Â" (U+00C2)
  0x00, 0xC3, 0xFF, 0x01, 0x06, 0x0B, 0x06, 0x09, 0x35, // "Ã" (U+00C3)
  0x00, 0xC4, 0xFF, 0x01, 0x05, 0x0A, 0x06, 0x09, 0x58, // "Ä" (U+00C4)
  0x00, 0xC5, 0xFF, 0x01, 0x05, 0x0A, 0x06, 0x09, 0x76, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x08, 0x08, 0x08, 0x09, 0x97, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x05, 0x08, 0x05, 0x09, 0xBB, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x09, 0xDA, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x09, 0xF7, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x0A, 0x15, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x0A, 0x34, // "Ë" (U+00CB)
  0x00, 0xCC, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0x50, // "Ì" (U+00CC)
  0x00, 0xCD, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0x66, // "Í" (U+00CD)
  0x00, 0xCE, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0x7C, // "Î" (U+00CE)
  0x00, 0xCF, 0x40, 0x01, 0x04, 0x0A, 0x03, 0x0A, 0x92, // "Ï" (U+00CF)
  0x00, 0xD0, 0x40, 0x01, 0x06, 0x08, 0x06, 0x0A, 0xAB, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x0A, 0xC7, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0A, 0xF2, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0B, 0x16, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0B, 0x3B, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0B, 0x60, // "Õ" (U+00D5)
  0x00, 0xD6, 0x40, 0x01, 0x06, 0x0A, 0x06, 0x0B, 0x86, // "Ö" (U+00D6)
  0x00, 0xD7, 0x40, 0x02, 0x04, 0x06, 0x05, 0x0B, 0xA9, // "×" (U+00D7)
  0x00, 0xD8, 0x40, 0x00, 0x06, 0x08, 0x06, 0x0B, 0xB6, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0B, 0xD6, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0B, 0xF9, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x0C, 0x1D, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x0C, 0x42, // "Ü" (U+00DC)
  0x00, 0xDD, 0x01, 0x01, 0x06, 0x0B, 0x05, 0x0C, 0x64, // "Ý" (U+00DD)
  0x00, 0xDE, 0x40, 0x01, 0x05, 0x08, 0x05, 0x0C, 0x81, // "Þ" (U+00DE)
  0x00, 0xDF, 0xFE, 0xFE, 0x05, 0x08, 0x05, 0x0C, 0x99, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xBF, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xD4, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xEA, // "â" (U+00E2)
  0x00, 0xE3, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0D, 0x00, // "ã" (U+00E3)
  0x00, 0xE4, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x1B, // "ä" (U+00E4)
  0x00, 0xE5, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x2F, // "å" (U+00E5)
  0x00, 0xE6, 0x40, 0x01, 0x06, 0x06, 0x07, 0x0D, 0x46, // "æ" (U+00E6)
  0x00, 0xE7, 0x40, 0xFE, 0x04, 0x06, 0x04, 0x0D, 0x5B, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0D, 0x72, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0D, 0x87, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x09, 0x04, 0x0D, 0x9D, // "ê" (U+00EA)
  0x00, 0xEB, 0x40, 0x01, 0x04, 0x08, 0x04, 0x0D, 0xB3, // "ë" (U+00EB)
  0x00, 0xEC, 0x40, 0x01, 0x02, 0x09, 0x03, 0x0D, 0xC7, // "ì" (U+00EC)
  0x00, 0xED, 0x40, 0x01, 0x02, 0x09, 0x03, 0x0D, 0xD5, // "í" (U+00ED)
  0x00, 0xEE, 0x40, 0x01, 0x02, 0x09, 0x03, 0x0D, 0xE3, // "î" (U+00EE)
  0x00, 0xEF, 0x40, 0x01, 0x03, 0x08, 0x03, 0x0D, 0xF1, // "ï" (U+00EF)
  0x00, 0xF0, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x01, // "ð" (U+00F0)
  0x00, 0xF1, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0E, 0x18, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x33, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x48, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0x5E, // "ô" (U+00F4)
  0x00, 0xF5, 0x40, 0x01, 0x05, 0x09, 0x05, 0x0E, 0x74, // "õ" (U+00F5)
  0x00, 0xF6, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0E, 0x8F, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x01, 0x04, 0x06, 0x05, 0x0E, 0xA3, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x07, 0x05, 0x0E, 0xAE, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xC1, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xD6, // "ú" (U+00FA)
  0x00, 0xFB, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0E, 0xEC, // "û" (U+00FB)
  0x00, 0xFC, 0x40, 0x01, 0x04, 0x08, 0x05, 0x0F, 0x03, // "ü" (U+00FC)
  0x00, 0xFD, 0xFE, 0xFE, 0x04, 0x09, 0x05, 0x0F, 0x17, // "ý" (U+00FD)
  0x00, 0xFE, 0xFF, 0xFE, 0x04, 0x08, 0x05, 0x0F, 0x39, // "þ" (U+00FE)
  0x00, 0xFF, 0xFE, 0xFE, 0x04, 0x08, 0x05, 0x0F, 0x59, // "ÿ" (U+00FF)
  0x01, 0x00, 0xFF, 0x01, 0x05, 0x09, 0x06, 0x0F, 0x79, // "Ā" (U+0100)
  0x01, 0x01, 0x40, 0x01, 0x04, 0x07, 0x05, 0x0F, 0x97, // "ā" (U+0101)
  0x01, 0x02, 0xFF, 0x01, 0x05, 0x0B, 0x06, 0x0F, 0xA9, // "Ă" (U+0102)
  0x01, 0x03, 0x40, 0x01, 0x04, 0x09, 0x05, 0x0F, 0xCA, // "ă" (U+0103)
  0x01, 0x04, 0xFF, 0xFE, 0x05, 0x08, 0x06, 0x0F, 0xE1, // "Ą" (U+0104)
  0x01, 0x05, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x10, 0x02, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x10, 0x19, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x09, 0x04, 0x10, 0x37, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x10, 0x4D, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x09, 0x04, 0x10, 0x6B, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x10, 0x81, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x04, 0x08, 0x04, 0x10, 0x9C, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x10, 0xAF, // "Č" (U+010C)
  0x01, 0x0D, 0x40, 0x01, 0x04, 0x09, 0x04, 0x10, 0xCE, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x10, 0xE5, // "Ď" (U+010E)
  0x01, 0x0F, 0x40, 0x01, 0x06, 0x08, 0x05, 0x11, 0x0B, // "ď" (U+010F)
  0x01, 0x10, 0x40, 0x01, 0x06, 0x08, 0x06, 0x11, 0x27, // "Đ" (U+0110)
  0x01, 0x11, 0x40, 0x01, 0x05, 0x08, 0x05, 0x11, 0x43, // "đ" (U+0111)
  0x01, 0x12, 0x40, 0x01, 0x05, 0x09, 0x05, 0x11, 0x5B, // "Ē" (U+0112)
  0x01, 0x13, 0x40, 0x01, 0x04, 0x07, 0x04, 0x11, 0x76, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x11, 0x88, // "Ĕ" (U+0114)
  0x01, 0x15, 0x40, 0x01, 0x04, 0x09, 0x04, 0x11, 0xA7, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x11, 0xBE, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x08, 0x04, 0x11, 0xDA, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x05, 0x08, 0x05, 0x11, 0xED, // "Ę" (U+0118)
  0x01, 0x19, 0x40, 0xFE, 0x04, 0x06, 0x04, 0x12, 0x0C, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x12, 0x23, // "Ě" (U+011A)
  0x01, 0x1B, 0x40, 0x01, 0x04, 0x09, 0x04, 0x12, 0x42, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x12, 0x59, // "Ĝ" (U+011C)
  0x01, 0x1D, 0xFF, 0xFE, 0x05, 0x09, 0x05, 0x12, 0x7C, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x12, 0xA2, // "Ğ" (U+011E)
  0x01, 0x1F, 0xFF, 0xFE, 0x05, 0x09, 0x05, 0x12, 0xC6, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x12, 0xED, // "Ġ" (U+0120)
  0x01, 0x21, 0xFF, 0xFE, 0x05, 0x08, 0x05, 0x13, 0x0D, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x06, 0x08, 0x06, 0x13, 0x30, // "Ģ" (U+0122)
  0x01, 0x23, 0xFF, 0xFE, 0x05, 0x08, 0x05, 0x13, 0x51, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x13, 0x76, // "Ĥ" (U+0124)
  0x01, 0x25, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x13, 0xA1, // "ĥ" (U+0125)
  0x01, 0x26, 0x40, 0x01, 0x07, 0x08, 0x07, 0x13, 0xBC, // "Ħ" (U+0126)
  0x01, 0x27, 0x40, 0x01, 0x04, 0x08, 0x05, 0x13, 0xDC, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x04, 0x0B, 0x03, 0x13, 0xF0, // "Ĩ" (U+0128)
  0x01, 0x29, 0x40, 0x01, 0x03, 0x09, 0x03, 0x14, 0x0B, // "ĩ" (U+0129)
  0x01, 0x2A, 0x40, 0x01, 0x03, 0x09, 0x03, 0x14, 0x1D, // "Ī" (U+012A)
  0x01, 0x2B, 0x40, 0x01, 0x03, 0x07, 0x03, 0x14, 0x2F, // "ī" (U+012B)
  0x01, 0x2C, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x14, 0x3D, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x40, 0x01, 0x02, 0x09, 0x03, 0x14, 0x53, // "ĭ" (U+012D)
  0x01, 0x2E, 0x40, 0xFE, 0x03, 0x08, 0x03, 0x14, 0x61, // "Į" (U+012E)
  0x01, 0x2F, 0xBF, 0xFE, 0x02, 0x08, 0x03, 0x14, 0x77, // "į" (U+012F)
  0x01, 0x30, 0x40, 0x01, 0x03, 0x0A, 0x03, 0x14, 0x8D, // "İ" (U+0130)
  0x01, 0x31, 0x40, 0x01, 0x02, 0x06, 0x03, 0x14, 0xA1, // "ı" (U+0131)
  0x01, 0x32, 0x40, 0xFE, 0x06, 0x08, 0x06, 0x14, 0xAA, // "Ĳ" (U+0132)
  0x01, 0x33, 0x40, 0xFE, 0x05, 0x08, 0x05, 0x14, 0xD1, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFE, 0x03, 0x0B, 0x03, 0x14, 0xF2, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFE, 0x02, 0x09, 0x03, 0x15, 0x14, // "ĵ" (U+0135)
  0x01, 0x36, 0x40, 0xFF, 0x06, 0x08, 0x06, 0x15, 0x30, // "Ķ" (U+0136)
  0x01, 0x37, 0x40, 0xFF, 0x05, 0x08, 0x05, 0x15, 0x53, // "ķ" (U+0137)
  0x01, 0x38, 0x40, 0x01, 0x05, 0x06, 0x05, 0x15, 0x71, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x15, 0x83, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x40, 0x01, 0x03, 0x0B, 0x03, 0x15, 0x9E, // "ĺ" (U+013A)
  0x01, 0x3B, 0x40, 0xFF, 0x04, 0x08, 0x05, 0x15, 0xB4, // "Ļ" (U+013B)
  0x01, 0x3C, 0x40, 0xFF, 0x02, 0x08, 0x03, 0x15, 0xCD, // "ļ" (U+013C)
  0x01, 0x3D, 0x40, 0x01, 0x05, 0x08, 0x05, 0x15, 0xDC, // "Ľ" (U+013D)
  0x01, 0x3E, 0x40, 0x01, 0x04, 0x08, 0x03, 0x15, 0xF4, // "ľ" (U+013E)
  0x01, 0x3F, 0x40, 0x01, 0x05, 0x08, 0x05, 0x16, 0x08, // "Ŀ" (U+013F)
  0x01, 0x40, 0x40, 0x01, 0x03, 0x08, 0x03, 0x16, 0x20, // "ŀ" (U+0140)
  0x01, 0x41, 0x40, 0x01, 0x04, 0x08, 0x05, 0x16, 0x30, // "Ł" (U+0141)
  0x01, 0x42, 0x40, 0x01, 0x02, 0x08, 0x03, 0x16, 0x44, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x16, 0x50, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x09, 0x05, 0x16, 0x79, // "ń" (U+0144)
  0x01, 0x45, 0x40, 0xFF, 0x07, 0x08, 0x07, 0x16, 0x8F, // "Ņ" (U+0145)
  0x01, 0x46, 0x40, 0xFF, 0x04, 0x06, 0x05, 0x16, 0xB7, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x16, 0xCB, // "Ň" (U+0147)
  0x01, 0x48, 0x40, 0x01, 0x04, 0x09, 0x05, 0x16, 0xF5, // "ň" (U+0148)
  0x01, 0x49, 0x41, 0x01, 0x05, 0x08, 0x07, 0x17, 0x0C, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFE, 0x07, 0x08, 0x07, 0x17, 0x20, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x17, 0x4A, // "ŋ" (U+014B)
  0x01, 0x4C, 0x40, 0x01, 0x06, 0x09, 0x06, 0x17, 0x61, // "Ō" (U+014C)
  0x01, 0x4D, 0x40, 0x01, 0x04, 0x07, 0x05, 0x17, 0x81, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x17, 0x93, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x17, 0xB9, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x17, 0xD0, // "Ő" (U+0150)
  0x01, 0x51, 0x40, 0x01, 0x05, 0x09, 0x05, 0x17, 0xF6, // "ő" (U+0151)
  0x01, 0x52, 0x40, 0x01, 0x08, 0x08, 0x08, 0x18, 0x11, // "Œ" (U+0152)
  0x01, 0x53, 0x40, 0x01, 0x07, 0x06, 0x07, 0x18, 0x35, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x18, 0x4D, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x04, 0x09, 0x04, 0x18, 0x6D, // "ŕ" (U+0155)
  0x01, 0x56, 0x40, 0xFF, 0x05, 0x08, 0x06, 0x18, 0x83, // "Ŗ" (U+0156)
  0x01, 0x57, 0x40, 0xFF, 0x04, 0x06, 0x04, 0x18, 0xA1, // "ŗ" (U+0157)
  0x01, 0x58, 0x40, 0x01, 0x05, 0x0B, 0x06, 0x18, 0xB5, // "Ř" (U+0158)
  0x01, 0x59, 0x40, 0x01, 0x04, 0x09, 0x04, 0x18, 0xD6, // "ř" (U+0159)
  0x01, 0x5A, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x18, 0xED, // "Ś" (U+015A)
  0x01, 0x5B, 0x40, 0x01, 0x03, 0x09, 0x04, 0x19, 0x09, // "ś" (U+015B)
  0x01, 0x5C, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x19, 0x1B, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x40, 0x01, 0x03, 0x09, 0x04, 0x19, 0x37, // "ŝ" (U+015D)
  0x01, 0x5E, 0x40, 0xFE, 0x04, 0x08, 0x05, 0x19, 0x49, // "Ş" (U+015E)
  0x01, 0x5F, 0x40, 0xFE, 0x03, 0x06, 0x04, 0x19, 0x65, // "ş" (U+015F)
  0x01, 0x60, 0x40, 0x01, 0x04, 0x0B, 0x05, 0x19, 0x77, // "Š" (U+0160)
  0x01, 0x61, 0x40, 0x01, 0x03, 0x09, 0x04, 0x19, 0x93, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x06, 0x08, 0x05, 0x19, 0xA5, // "Ţ" (U+0162)
  0x01, 0x63, 0x40, 0xFE, 0x03, 0x08, 0x03, 0x19, 0xC2, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x06, 0x0B, 0x05, 0x19, 0xD8, // "Ť" (U+0164)
  0x01, 0x65, 0x40, 0x01, 0x04, 0x08, 0x03, 0x19, 0xF5, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x06, 0x08, 0x05, 0x1A, 0x09, // "Ŧ" (U+0166)
  0x01, 0x67, 0x40, 0x01, 0x03, 0x08, 0x03, 0x1A, 0x22, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x1A, 0x32, // "Ũ" (U+0168)
  0x01, 0x69, 0x40, 0x01, 0x05, 0x09, 0x05, 0x1A, 0x58, // "ũ" (U+0169)
  0x01, 0x6A, 0x40, 0x01, 0x06, 0x09, 0x06, 0x1A, 0x73, // "Ū" (U+016A)
  0x01, 0x6B, 0x40, 0x01, 0x04, 0x07, 0x05, 0x1A, 0x93, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x1A, 0xA5, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1A, 0xCA, // "ŭ" (U+016D)
  0x01, 0x6E, 0x40, 0x01, 0x06, 0x0B, 0x06, 0x1A, 0xE1, // "Ů" (U+016E)
  0x01, 0x6F, 0x40, 0x01, 0x04, 0x09, 0x05, 0x1B, 0x08, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x06, 0x0B, 0x06, 0x1B, 0x1F, // "Ű" (U+0170)
  0x01, 0x71, 0x40, 0x01, 0x05, 0x09, 0x05, 0x1B, 0x45, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x06, 0x08, 0x06, 0x1B, 0x60, // "Ų" (U+0172)
  0x01, 0x73, 0x40, 0xFE, 0x04, 0x06, 0x05, 0x1B, 0x85, // "ų" (U+0173)
  0x01, 0x74, 0x01, 0x01, 0x09, 0x0B, 0x09, 0x1B, 0x9C, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x06, 0x09, 0x07, 0x1B, 0xCA, // "ŵ" (U+0175)
  0x01, 0x76, 0x01, 0x01, 0x06, 0x0B, 0x05, 0x1B, 0xE8, // "Ŷ" (U+0176)
  0x01, 0x77, 0xFE, 0xFE, 0x04, 0x09, 0x05, 0x1C, 0x05, // "ŷ" (U+0177)
  0x01, 0x78, 0x01, 0x01, 0x06, 0x0A, 0x05, 0x1C, 0x28, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x05, 0x0B, 0x05, 0x1C, 0x42, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x04, 0x09, 0x04, 0x1C, 0x62, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x05, 0x0A, 0x05, 0x1C, 0x78, // "Ż" (U+017B)
  0x01, 0x7C, 0x40, 0x01, 0x04, 0x08, 0x04, 0x1C, 0x95, // "ż" (U+017C)
  0x01, 0x7D, 0x40, 0x01, 0x05, 0x0B, 0x05, 0x1C, 0xA9, // "Ž" (U+017D)
  0x01, 0x7E, 0x40, 0x01, 0x04, 0x09, 0x04, 0x1C, 0xCA, // "ž" (U+017E)
  0x01, 0x7F, 0xFE, 0xFE, 0x04, 0x08, 0x03, 0x1C, 0xE1, // "ſ" (U+017F)
  0x03, 0xA9, 0x40, 0x01, 0x06, 0x08, 0x07, 0x1C, 0xFD, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x1D, 0x19, // "μ" (U+03BC)
  0x03, 0xC0, 0x40, 0x01, 0x05, 0x06, 0x05, 0x1D, 0x2E, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x04, 0x03, 0x05, 0x1D, 0x40, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x09, 0x03, 0x0A, 0x1D, 0x42, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x05, 0x08, 0x05, 0x1D, 0x44, // "€" (U+20AC)
  0x20, 0xBF, 0xBF, 0x00, 0x04, 0x09, 0x05, 0x1D, 0x5A, // "₿" (U+20BF)
  0x20, 0x18, 0x41, 0x06, 0x02, 0x08, 0x02, 0x1D, 0x78, // "‘" (U+2018)
  0x20, 0x19, 0x41, 0x06, 0x02, 0x08, 0x02, 0x1D, 0x7B, // "’" (U+2019)
  0x20, 0x1A, 0xBF, 0xFF, 0x01, 0x01, 0x02, 0x1D, 0x7E, // "‚" (U+201A)
  0x20, 0x1B, 0x41, 0x06, 0x02, 0x08, 0x02, 0x1D, 0x83, // "‛" (U+201B)
  0x20, 0x1C, 0x41, 0x06, 0x04, 0x08, 0x04, 0x1D, 0x86, // "“" (U+201C)
  0x20, 0x1D, 0x41, 0x06, 0x04, 0x08, 0x04, 0x1D, 0x8C, // "”" (U+201D)
  0x20, 0x1E, 0xBF, 0xFF, 0x02, 0x01, 0x04, 0x1D, 0x92, // "„" (U+201E)
  0x20, 0x1F, 0x41, 0x06, 0x04, 0x08, 0x04, 0x1D, 0x98, // "‟" (U+201F)
  0x20, 0x20, 0x41, 0xFF, 0x04, 0x08, 0x04, 0x1D, 0x9E, // "†" (U+2020)
  0x20, 0x21, 0x00, 0xFF, 0x04, 0x08, 0x04, 0x1D, 0xB2, // "‡" (U+2021)
  0x20, 0x22, 0x40, 0x03, 0x02, 0x06, 0x03, 0x1D, 0xCA, // "•" (U+2022)
  0x20, 0x26, 0x40, 0x01, 0x06, 0x02, 0x07, 0x1D, 0xD0, // "…" (U+2026)
  0x20, 0x30, 0x40, 0x01, 0x0A, 0x08, 0x0B, 0x1D, 0xD7, // "‰" (U+2030)
  0x20, 0x39, 0x40, 0x02, 0x02, 0x05, 0x03, 0x1E, 0x03, // "‹" (U+2039)
  0x20, 0x3A, 0x40, 0x02, 0x02, 0x05, 0x03, 0x1E, 0x09, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x08, 0x01, 0x1E, 0x0F, // "⁄" (U+2044)
  0x21, 0x22, 0x41, 0x04, 0x07, 0x07, 0x07, 0x1E, 0x20, // "™" (U+2122)
  0x21, 0x52, 0x41, 0x00, 0x09, 0x08, 0x0B, 0x1E, 0x2E, // "⅒" (U+2152)
  0xFB, 0x01, 0xFE, 0xFE, 0x04, 0x08, 0x05, 0x1E, 0x57, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0xFE, 0xFE, 0x05, 0x08, 0x05, 0x1E, 0x7B, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x26, 0x00, 0x56, 0x01, // &V (U+0026 U+0056)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2A, 0x00, 0x2C, 0x01, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x01, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x01, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x01, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x01, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x01, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x01, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x01, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x01, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x01, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x01, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x01, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x01, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x01, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x01, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x01, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x76, 0x01, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x76, 0x01, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x01, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xA9, 0x01, // A© (U+0041 U+00A9)
  0x00, 0x41, 0x00, 0xAE, 0x01, // A® (U+0041 U+00AE)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x49, 0x01, // Aŉ (U+0041 U+0149)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x01, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x01, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x01, // A™ (U+0041 U+2122)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x01, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x01, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x01, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x01, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x01, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x01, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x01, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x01, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x01, 0x00, 0x01, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x01, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x01, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x01, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x01, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x01, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x01, // L™ (U+004C U+2122)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x01, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x61, 0x01, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x01, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x01, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x01, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x01, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x01, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x01, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xE0, 0x01, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x01, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x01, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x01, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x01, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x01, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x01, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x01, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x01, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x01, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x01, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x01, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x01, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x01, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x01, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x01, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x01, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x01, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x01, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x01, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x01, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x01, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x07, 0x01, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x09, 0x01, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0B, 0x01, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0D, 0x01, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x01, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x01, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x01, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x01, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x01, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x01, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x01, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4D, 0x01, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4F, 0x01, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x51, 0x01, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x53, 0x01, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x61, 0x01, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x01, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x01, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x01, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x01, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x01, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x01, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xE0, 0x01, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x01, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x01, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x01, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x01, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x01, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x01, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x01, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x01, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x01, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x01, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x01, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x01, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x01, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x01, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x01, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x01, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x01, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x01, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x01, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x01, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x01, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x07, 0x01, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x09, 0x01, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0B, 0x01, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0D, 0x01, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x01, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x01, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x01, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x01, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x01, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x01, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x01, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4D, 0x01, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4F, 0x01, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x51, 0x01, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x53, 0x01, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x79, 0x01, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xFD, 0x01, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x01, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x77, 0x01, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x01, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x01, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5D, 0x01, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x61, 0x01, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x56, 0x01, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x59, 0x01, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0xDD, 0x01, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x01, 0x76, 0x01, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x78, 0x01, // aŸ (U+0061 U+0178)
  0x00, 0x62, 0x00, 0x56, 0x01, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x01, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x01, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0xDD, 0x01, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x01, 0x74, 0x01, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x01, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x78, 0x01, // bŸ (U+0062 U+0178)
  0x00, 0x63, 0x00, 0x56, 0x01, // cV (U+0063 U+0056)
  0x00, 0x63, 0x00, 0x57, 0x01, // cW (U+0063 U+0057)
  0x00, 0x63, 0x00, 0x59, 0x01, // cY (U+0063 U+0059)
  0x00, 0x63, 0x00, 0xDD, 0x01, // cÝ (U+0063 U+00DD)
  0x00, 0x63, 0x01, 0x74, 0x01, // cŴ (U+0063 U+0174)
  0x00, 0x63, 0x01, 0x76, 0x01, // cŶ (U+0063 U+0176)
  0x00, 0x63, 0x01, 0x78, 0x01, // cŸ (U+0063 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x01, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x01, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x01, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x01, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x01, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x01, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x01, // eŸ (U+0065 U+0178)
  0x00, 0x68, 0x00, 0x56, 0x01, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x59, 0x01, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0xDD, 0x01, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x01, 0x76, 0x01, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x78, 0x01, // hŸ (U+0068 U+0178)
  0x00, 0x6D, 0x00, 0x56, 0x01, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x59, 0x01, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0xDD, 0x01, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x01, 0x76, 0x01, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x78, 0x01, // mŸ (U+006D U+0178)
  0x00, 0x6E, 0x00, 0x56, 0x01, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x59, 0x01, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0xDD, 0x01, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x01, 0x76, 0x01, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x78, 0x01, // nŸ (U+006E U+0178)
  0x00, 0x6F, 0x00, 0x56, 0x01, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x01, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x01, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0xDD, 0x01, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x01, 0x74, 0x01, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x01, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x78, 0x01, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x56, 0x01, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x01, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x01, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0xDD, 0x01, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x01, 0x74, 0x01, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x01, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x78, 0x01, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x58, 0x01, // rX (U+0072 U+0058)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x59, 0x01, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x01, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x76, 0x01, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x01, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x56, 0x01, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x01, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x76, 0x01, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0xA9, 0x01, // À© (U+00C0 U+00A9)
  0x00, 0xC0, 0x00, 0xAE, 0x01, // À® (U+00C0 U+00AE)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x49, 0x01, // Àŉ (U+00C0 U+0149)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x01, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x01, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x01, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x01, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x76, 0x01, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0xA9, 0x01, // Á© (U+00C1 U+00A9)
  0x00, 0xC1, 0x00, 0xAE, 0x01, // Á® (U+00C1 U+00AE)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x49, 0x01, // Áŉ (U+00C1 U+0149)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x01, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x01, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x01, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x01, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x76, 0x01, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0xA9, 0x01, // Â© (U+00C2 U+00A9)
  0x00, 0xC2, 0x00, 0xAE, 0x01, // Â® (U+00C2 U+00AE)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x49, 0x01, // Âŉ (U+00C2 U+0149)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x01, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x01, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x01, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x01, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x76, 0x01, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0xA9, 0x01, // Ã© (U+00C3 U+00A9)
  0x00, 0xC3, 0x00, 0xAE, 0x01, // Ã® (U+00C3 U+00AE)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x49, 0x01, // Ãŉ (U+00C3 U+0149)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x01, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x01, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x01, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x01, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x76, 0x01, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0xA9, 0x01, // Ä© (U+00C4 U+00A9)
  0x00, 0xC4, 0x00, 0xAE, 0x01, // Ä® (U+00C4 U+00AE)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x49, 0x01, // Äŉ (U+00C4 U+0149)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x01, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x01, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x01, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x01, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x76, 0x01, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0xA9, 0x01, // Å© (U+00C5 U+00A9)
  0x00, 0xC5, 0x00, 0xAE, 0x01, // Å® (U+00C5 U+00AE)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x49, 0x01, // Åŉ (U+00C5 U+0149)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x01, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x01, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x01, // Å™ (U+00C5 U+2122)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x01, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x01, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5D, 0x01, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x61, 0x01, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDF, 0x00, 0x59, 0x01, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0xDD, 0x01, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x01, 0x76, 0x01, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x78, 0x01, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x56, 0x01, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x59, 0x01, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0xDD, 0x01, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x01, 0x76, 0x01, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x78, 0x01, // àŸ (U+00E0 U+0178)
  0x00, 0xE1, 0x00, 0x56, 0x01, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x59, 0x01, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0xDD, 0x01, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x01, 0x76, 0x01, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x78, 0x01, // áŸ (U+00E1 U+0178)
  0x00, 0xE2, 0x00, 0x56, 0x01, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x59, 0x01, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0xDD, 0x01, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x01, 0x76, 0x01, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x78, 0x01, // âŸ (U+00E2 U+0178)
  0x00, 0xE3, 0x00, 0x56, 0x01, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x59, 0x01, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0xDD, 0x01, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x01, 0x76, 0x01, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x78, 0x01, // ãŸ (U+00E3 U+0178)
  0x00, 0xE4, 0x00, 0x56, 0x01, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x59, 0x01, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0xDD, 0x01, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x01, 0x76, 0x01, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x78, 0x01, // äŸ (U+00E4 U+0178)
  0x00, 0xE5, 0x00, 0x56, 0x01, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x59, 0x01, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0xDD, 0x01, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x01, 0x76, 0x01, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x78, 0x01, // åŸ (U+00E5 U+0178)
  0x00, 0xE6, 0x00, 0x56, 0x01, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x01, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x01, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x01, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x01, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x01, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x01, // æŸ (U+00E6 U+0178)
  0x00, 0xE7, 0x00, 0x56, 0x01, // çV (U+00E7 U+0056)
  0x00, 0xE7, 0x00, 0x57, 0x01, // çW (U+00E7 U+0057)
  0x00, 0xE7, 0x00, 0x59, 0x01, // çY (U+00E7 U+0059)
  0x00, 0xE7, 0x00, 0xDD, 0x01, // çÝ (U+00E7 U+00DD)
  0x00, 0xE7, 0x01, 0x74, 0x01, // çŴ (U+00E7 U+0174)
  0x00, 0xE7, 0x01, 0x76, 0x01, // çŶ (U+00E7 U+0176)
  0x00, 0xE7, 0x01, 0x78, 0x01, // çŸ (U+00E7 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x01, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x01, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x01, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x01, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x01, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x01, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x01, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x01, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x01, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x01, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x01, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x01, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x01, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x01, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x01, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x01, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x01, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x01, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x01, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x01, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x01, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x01, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x01, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x01, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x01, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x01, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x01, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x01, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x56, 0x01, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x01, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x01, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0xDD, 0x01, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x01, 0x74, 0x01, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x01, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x78, 0x01, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x56, 0x01, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x59, 0x01, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0xDD, 0x01, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x01, 0x76, 0x01, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x78, 0x01, // ñŸ (U+00F1 U+0178)
  0x00, 0xF2, 0x00, 0x56, 0x01, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x01, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x01, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0xDD, 0x01, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x01, 0x74, 0x01, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x01, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x78, 0x01, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x56, 0x01, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x01, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x01, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0xDD, 0x01, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x01, 0x74, 0x01, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x01, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x78, 0x01, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x56, 0x01, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x01, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x01, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0xDD, 0x01, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x01, 0x74, 0x01, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x01, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x78, 0x01, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x56, 0x01, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x01, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x01, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0xDD, 0x01, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x01, 0x74, 0x01, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x01, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x78, 0x01, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x56, 0x01, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x01, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x01, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0xDD, 0x01, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x01, 0x74, 0x01, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x01, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x78, 0x01, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x56, 0x01, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x01, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x01, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0xDD, 0x01, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x01, 0x74, 0x01, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x01, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x78, 0x01, // øŸ (U+00F8 U+0178)
  0x00, 0xF9, 0x00, 0x56, 0x01, // ùV (U+00F9 U+0056)
  0x00, 0xF9, 0x00, 0x59, 0x01, // ùY (U+00F9 U+0059)
  0x00, 0xF9, 0x00, 0xDD, 0x01, // ùÝ (U+00F9 U+00DD)
  0x00, 0xF9, 0x01, 0x76, 0x01, // ùŶ (U+00F9 U+0176)
  0x00, 0xF9, 0x01, 0x78, 0x01, // ùŸ (U+00F9 U+0178)
  0x00, 0xFA, 0x00, 0x56, 0x01, // úV (U+00FA U+0056)
  0x00, 0xFA, 0x00, 0x59, 0x01, // úY (U+00FA U+0059)
  0x00, 0xFA, 0x00, 0xDD, 0x01, // úÝ (U+00FA U+00DD)
  0x00, 0xFA, 0x01, 0x76, 0x01, // úŶ (U+00FA U+0176)
  0x00, 0xFA, 0x01, 0x78, 0x01, // úŸ (U+00FA U+0178)
  0x00, 0xFB, 0x00, 0x56, 0x01, // ûV (U+00FB U+0056)
  0x00, 0xFB, 0x00, 0x59, 0x01, // ûY (U+00FB U+0059)
  0x00, 0xFB, 0x00, 0xDD, 0x01, // ûÝ (U+00FB U+00DD)
  0x00, 0xFB, 0x01, 0x76, 0x01, // ûŶ (U+00FB U+0176)
  0x00, 0xFB, 0x01, 0x78, 0x01, // ûŸ (U+00FB U+0178)
  0x00, 0xFC, 0x00, 0x56, 0x01, // üV (U+00FC U+0056)
  0x00, 0xFC, 0x00, 0x59, 0x01, // üY (U+00FC U+0059)
  0x00, 0xFC, 0x00, 0xDD, 0x01, // üÝ (U+00FC U+00DD)
  0x00, 0xFC, 0x01, 0x76, 0x01, // üŶ (U+00FC U+0176)
  0x00, 0xFC, 0x01, 0x78, 0x01, // üŸ (U+00FC U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x56, 0x01, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x01, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x01, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0xDD, 0x01, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x01, 0x74, 0x01, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x01, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x78, 0x01, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x01, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xA9, 0x01, // Ā© (U+0100 U+00A9)
  0x01, 0x00, 0x00, 0xAE, 0x01, // Ā® (U+0100 U+00AE)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x49, 0x01, // Āŉ (U+0100 U+0149)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x01, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x01, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x01, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x56, 0x01, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x59, 0x01, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0xDD, 0x01, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x01, 0x76, 0x01, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x78, 0x01, // āŸ (U+0101 U+0178)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x01, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x76, 0x01, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0xA9, 0x01, // Ă© (U+0102 U+00A9)
  0x01, 0x02, 0x00, 0xAE, 0x01, // Ă® (U+0102 U+00AE)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x49, 0x01, // Ăŉ (U+0102 U+0149)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x01, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x01, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x01, // Ă™ (U+0102 U+2122)
  0x01, 0x03, 0x00, 0x56, 0x01, // ăV (U+0103 U+0056)
  0x01, 0x03, 0x00, 0x59, 0x01, // ăY (U+0103 U+0059)
  0x01, 0x03, 0x00, 0xDD, 0x01, // ăÝ (U+0103 U+00DD)
  0x01, 0x03, 0x01, 0x76, 0x01, // ăŶ (U+0103 U+0176)
  0x01, 0x03, 0x01, 0x78, 0x01, // ăŸ (U+0103 U+0178)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x01, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x76, 0x01, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0xA9, 0x01, // Ą© (U+0104 U+00A9)
  0x01, 0x04, 0x00, 0xAE, 0x01, // Ą® (U+0104 U+00AE)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x49, 0x01, // Ąŉ (U+0104 U+0149)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x01, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x01, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x01, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x56, 0x01, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x59, 0x01, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0xDD, 0x01, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x01, 0x76, 0x01, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x78, 0x01, // ąŸ (U+0105 U+0178)
  0x01, 0x07, 0x00, 0x56, 0x01, // ćV (U+0107 U+0056)
  0x01, 0x07, 0x00, 0x57, 0x01, // ćW (U+0107 U+0057)
  0x01, 0x07, 0x00, 0x59, 0x01, // ćY (U+0107 U+0059)
  0x01, 0x07, 0x00, 0xDD, 0x01, // ćÝ (U+0107 U+00DD)
  0x01, 0x07, 0x01, 0x74, 0x01, // ćŴ (U+0107 U+0174)
  0x01, 0x07, 0x01, 0x76, 0x01, // ćŶ (U+0107 U+0176)
  0x01, 0x07, 0x01, 0x78, 0x01, // ćŸ (U+0107 U+0178)
  0x01, 0x09, 0x00, 0x56, 0x01, // ĉV (U+0109 U+0056)
  0x01, 0x09, 0x00, 0x57, 0x01, // ĉW (U+0109 U+0057)
  0x01, 0x09, 0x00, 0x59, 0x01, // ĉY (U+0109 U+0059)
  0x01, 0x09, 0x00, 0xDD, 0x01, // ĉÝ (U+0109 U+00DD)
  0x01, 0x09, 0x01, 0x74, 0x01, // ĉŴ (U+0109 U+0174)
  0x01, 0x09, 0x01, 0x76, 0x01, // ĉŶ (U+0109 U+0176)
  0x01, 0x09, 0x01, 0x78, 0x01, // ĉŸ (U+0109 U+0178)
  0x01, 0x0B, 0x00, 0x56, 0x01, // ċV (U+010B U+0056)
  0x01, 0x0B, 0x00, 0x57, 0x01, // ċW (U+010B U+0057)
  0x01, 0x0B, 0x00, 0x59, 0x01, // ċY (U+010B U+0059)
  0x01, 0x0B, 0x00, 0xDD, 0x01, // ċÝ (U+010B U+00DD)
  0x01, 0x0B, 0x01, 0x74, 0x01, // ċŴ (U+010B U+0174)
  0x01, 0x0B, 0x01, 0x76, 0x01, // ċŶ (U+010B U+0176)
  0x01, 0x0B, 0x01, 0x78, 0x01, // ċŸ (U+010B U+0178)
  0x01, 0x0D, 0x00, 0x56, 0x01, // čV (U+010D U+0056)
  0x01, 0x0D, 0x00, 0x57, 0x01, // čW (U+010D U+0057)
  0x01, 0x0D, 0x00, 0x59, 0x01, // čY (U+010D U+0059)
  0x01, 0x0D, 0x00, 0xDD, 0x01, // čÝ (U+010D U+00DD)
  0x01, 0x0D, 0x01, 0x74, 0x01, // čŴ (U+010D U+0174)
  0x01, 0x0D, 0x01, 0x76, 0x01, // čŶ (U+010D U+0176)
  0x01, 0x0D, 0x01, 0x78, 0x01, // čŸ (U+010D U+0178)
  0x01, 0x13, 0x00, 0x56, 0x01, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x01, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x01, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x01, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x01, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x01, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x01, // ēŸ (U+0113 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x01, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x01, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x01, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x01, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x01, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x01, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x01, // ĕŸ (U+0115 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x01, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x01, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x01, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x01, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x01, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x01, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x01, // ėŸ (U+0117 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x01, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x01, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x01, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x01, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x01, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x01, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x01, // ęŸ (U+0119 U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x01, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x01, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x01, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x01, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x01, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x01, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x01, // ěŸ (U+011B U+0178)
  0x01, 0x25, 0x00, 0x56, 0x01, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x59, 0x01, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0xDD, 0x01, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x01, 0x76, 0x01, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x78, 0x01, // ĥŸ (U+0125 U+0178)
  0x01, 0x27, 0x00, 0x56, 0x01, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x59, 0x01, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0xDD, 0x01, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x01, 0x76, 0x01, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x78, 0x01, // ħŸ (U+0127 U+0178)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x01, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x01, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x01, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x01, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x01, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x01, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x01, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x01, // Ļ™ (U+013B U+2122)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x01, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x01, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x01, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x01, // Ł™ (U+0141 U+2122)
  0x01, 0x44, 0x00, 0x56, 0x01, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x59, 0x01, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0xDD, 0x01, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x01, 0x76, 0x01, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x78, 0x01, // ńŸ (U+0144 U+0178)
  0x01, 0x46, 0x00, 0x56, 0x01, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x59, 0x01, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0xDD, 0x01, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x01, 0x76, 0x01, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x78, 0x01, // ņŸ (U+0146 U+0178)
  0x01, 0x48, 0x00, 0x56, 0x01, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x59, 0x01, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0xDD, 0x01, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x01, 0x76, 0x01, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x78, 0x01, // ňŸ (U+0148 U+0178)
  0x01, 0x49, 0x00, 0x56, 0x01, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x59, 0x01, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0xDD, 0x01, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x01, 0x76, 0x01, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x78, 0x01, // ŉŸ (U+0149 U+0178)
  0x01, 0x4B, 0x00, 0x56, 0x01, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x59, 0x01, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0xDD, 0x01, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x01, 0x76, 0x01, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x78, 0x01, // ŋŸ (U+014B U+0178)
  0x01, 0x4D, 0x00, 0x56, 0x01, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x01, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x01, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0xDD, 0x01, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x01, 0x74, 0x01, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x01, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x78, 0x01, // ōŸ (U+014D U+0178)
  0x01, 0x4F, 0x00, 0x56, 0x01, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x01, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x01, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0xDD, 0x01, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x01, 0x74, 0x01, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x01, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x78, 0x01, // ŏŸ (U+014F U+0178)
  0x01, 0x51, 0x00, 0x56, 0x01, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x01, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x01, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0xDD, 0x01, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x01, 0x74, 0x01, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x01, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x78, 0x01, // őŸ (U+0151 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x01, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x01, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x01, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x01, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x01, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x01, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x01, // œŸ (U+0153 U+0178)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x58, 0x01, // ŕX (U+0155 U+0058)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x58, 0x01, // ŗX (U+0157 U+0058)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x58, 0x01, // řX (U+0159 U+0058)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x5B, 0x00, 0x59, 0x01, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x01, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x76, 0x01, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x01, // śŸ (U+015B U+0178)
  0x01, 0x5D, 0x00, 0x59, 0x01, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x01, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x76, 0x01, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x01, // ŝŸ (U+015D U+0178)
  0x01, 0x5F, 0x00, 0x59, 0x01, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x01, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x76, 0x01, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x01, // şŸ (U+015F U+0178)
  0x01, 0x61, 0x00, 0x59, 0x01, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x01, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x76, 0x01, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x01, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x01, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x01, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x01, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x69, 0x00, 0x56, 0x01, // ũV (U+0169 U+0056)
  0x01, 0x69, 0x00, 0x59, 0x01, // ũY (U+0169 U+0059)
  0x01, 0x69, 0x00, 0xDD, 0x01, // ũÝ (U+0169 U+00DD)
  0x01, 0x69, 0x01, 0x76, 0x01, // ũŶ (U+0169 U+0176)
  0x01, 0x69, 0x01, 0x78, 0x01, // ũŸ (U+0169 U+0178)
  0x01, 0x6B, 0x00, 0x56, 0x01, // ūV (U+016B U+0056)
  0x01, 0x6B, 0x00, 0x59, 0x01, // ūY (U+016B U+0059)
  0x01, 0x6B, 0x00, 0xDD, 0x01, // ūÝ (U+016B U+00DD)
  0x01, 0x6B, 0x01, 0x76, 0x01, // ūŶ (U+016B U+0176)
  0x01, 0x6B, 0x01, 0x78, 0x01, // ūŸ (U+016B U+0178)
  0x01, 0x6D, 0x00, 0x56, 0x01, // ŭV (U+016D U+0056)
  0x01, 0x6D, 0x00, 0x59, 0x01, // ŭY (U+016D U+0059)
  0x01, 0x6D, 0x00, 0xDD, 0x01, // ŭÝ (U+016D U+00DD)
  0x01, 0x6D, 0x01, 0x76, 0x01, // ŭŶ (U+016D U+0176)
  0x01, 0x6D, 0x01, 0x78, 0x01, // ŭŸ (U+016D U+0178)
  0x01, 0x6F, 0x00, 0x56, 0x01, // ůV (U+016F U+0056)
  0x01, 0x6F, 0x00, 0x59, 0x01, // ůY (U+016F U+0059)
  0x01, 0x6F, 0x00, 0xDD, 0x01, // ůÝ (U+016F U+00DD)
  0x01, 0x6F, 0x01, 0x76, 0x01, // ůŶ (U+016F U+0176)
  0x01, 0x6F, 0x01, 0x78, 0x01, // ůŸ (U+016F U+0178)
  0x01, 0x71, 0x00, 0x56, 0x01, // űV (U+0171 U+0056)
  0x01, 0x71, 0x00, 0x59, 0x01, // űY (U+0171 U+0059)
  0x01, 0x71, 0x00, 0xDD, 0x01, // űÝ (U+0171 U+00DD)
  0x01, 0x71, 0x01, 0x76, 0x01, // űŶ (U+0171 U+0176)
  0x01, 0x71, 0x01, 0x78, 0x01, // űŸ (U+0171 U+0178)
  0x01, 0x73, 0x00, 0x56, 0x01, // ųV (U+0173 U+0056)
  0x01, 0x73, 0x00, 0x59, 0x01, // ųY (U+0173 U+0059)
  0x01, 0x73, 0x00, 0xDD, 0x01, // ųÝ (U+0173 U+00DD)
  0x01, 0x73, 0x01, 0x76, 0x01, // ųŶ (U+0173 U+0176)
  0x01, 0x73, 0x01, 0x78, 0x01, // ųŸ (U+0173 U+0178)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x61, 0x01, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x01, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x01, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x01, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x01, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x01, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x01, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xE0, 0x01, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x01, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x01, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x01, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x01, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x01, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x01, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x01, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x01, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x01, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x01, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x01, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x01, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x01, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x01, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x01, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x01, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x01, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x01, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x01, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x01, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x01, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x07, 0x01, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x09, 0x01, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0B, 0x01, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0D, 0x01, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x01, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x01, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x01, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x01, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x01, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x01, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x01, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4D, 0x01, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4F, 0x01, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x51, 0x01, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x53, 0x01, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x01, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x01, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5D, 0x01, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x61, 0x01, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x01, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x01, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5D, 0x01, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x61, 0x01, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x01, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x01, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x76, 0x01, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x01, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x01, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x76, 0x01, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x02, 0xE0, 0x4A, 0x06, 0x60, 0x82, 0x09, 0x00, 0x50, 0x13, 0x05, 0x90,
  // """ (U+0022)
  0x84, 0xC9, 0x09, 0x40, 0x30,
  // "#" (U+0023)
  0x00, 0x80, 0x80, 0x07, 0x35, 0x1B, 0xBC, 0x90, 0x61, 0x80, 0x08, 0x08, 0x06, 0xCA, 0xC3, 0x25,
  0x61, 0x06, 0x18, 0x00,
  // "$" (U+0024)
  0x00, 0x08, 0x00, 0x4B, 0xAB, 0x0A, 0x64, 0x40, 0x8C, 0x10, 0x00, 0xBB, 0x03, 0x06, 0xA3, 0x94,
  0x6C, 0x12, 0xAB, 0x30, 0x05, 0x10, 0x00,
  // "%" (U+0025)
  0x05, 0x86, 0x04, 0x50, 0x0A, 0x0B, 0x09, 0x00, 0x37, 0x29, 0x63, 0x00, 0x37, 0x64, 0x84, 0x81,
  0x08, 0x67, 0x39, 0x46, 0x00, 0x27, 0x64, 0x56, 0x00, 0x90, 0x82, 0x81, 0x03, 0x60, 0x47, 0x60,
  // "&" (U+0026)
  0x00, 0x88, 0xB0, 0x00, 0x1C, 0x0A, 0x20, 0x00, 0xD5, 0xB0, 0x00, 0x2E, 0x90, 0xA4, 0x2B, 0x4C,
  0x27, 0x09, 0x50, 0xAB, 0x10, 0x85, 0x04, 0xD0, 0x02, 0xA6, 0x7A, 0xA0,
  // "'" (U+0027)
  0x94, 0x90, 0x40,
  // "(" (U+0028)
  0x00, 0x04, 0x00, 0xA2, 0x08, 0x40, 0x1D, 0x00, 0x58, 0x00, 0x76, 0x00, 0x84, 0x00, 0x66, 0x00,
  0x1A, 0x00,
  // ")" (U+0029)
  0x00, 0x30, 0x00, 0x56, 0x00, 0x0C, 0x00, 0x0D, 0x00, 0x1C, 0x00, 0x49, 0x00, 0x94, 0x01, 0xB0,
  0x1A, 0x10, 0x10, 0x00,
  // "*" (U+002A)
  0x10, 0x60, 0x58, 0x75, 0x8B, 0xC3, 0x08, 0x35, 0x02, 0x00,
  // "+" (U+002B)
  0x20, 0x64, 0x09, 0x28, 0x33, 0x9D, 0x92, 0x20, 0x94, 0x09, 0x20,
  // "," (U+002C)
  0x0A, 0x30, 0x64, 0x17, 0x00,
  // "-" (U+002D)
  0x9C, 0x60,
  // "." (U+002E)
  0x31, 0x94,
  // "/" (U+002F)
  0x30, 0x30, 0x53, 0x08, 0x30, 0x10, 0x73, 0x06, 0x02, 0x30, 0x83, 0x03, 0x04, 0x30, 0x83, 0x01,
  0x07, 0x30, 0x60, 0x13, 0x04, 0x40,
  // "0" (U+0030)
  0x01, 0x9A, 0x30, 0xA2, 0x2A, 0x1C, 0x01, 0xB5, 0x80, 0x2A, 0x76, 0x04, 0x88, 0x50, 0x84, 0x66,
  0x0B, 0x01, 0xA9, 0x30,
  // "1" (U+0031)
  0x00, 0x4C, 0x07, 0x8A, 0x00, 0x67, 0x00, 0x94, 0x00, 0xC1, 0x00, 0xD0, 0x02, 0xB0, 0x3B, 0xD4,
  // "2" (U+0032)
  0x04, 0xAB, 0x40, 0xB0, 0x59, 0x00, 0x06, 0x70, 0x00, 0xB0, 0x00, 0x83, 0x00, 0x64, 0x00, 0x55,
  0x06, 0x0E, 0xCC, 0xC0,
  // "3" (U+0033)
  0x04, 0xAB, 0x50, 0xA0, 0x49, 0x00, 0x0A, 0x40, 0x2C, 0x70, 0x00, 0x0E, 0x00, 0x00, 0xD1, 0xA0,
  0x1D, 0x09, 0xAA, 0x30,
  // "4" (U+0034)
  0x00, 0x09, 0x70, 0x04, 0xC5, 0x01, 0x8B, 0x20, 0x81, 0xD0, 0x44, 0x2B, 0x0A, 0x9B, 0xC5, 0x00,
  0x85, 0x00, 0x5D, 0xA0,
  // "5" (U+0035)
  0x02, 0xDD, 0xC0, 0x60, 0x04, 0x07, 0x00, 0x00, 0xB9, 0x50, 0x00, 0x0D, 0x10, 0x00, 0xC2, 0x70,
  0x1D, 0x08, 0x9A, 0x30,
  // "6" (U+0036)
  0x00, 0x79, 0xB0, 0x58, 0x07, 0x0D, 0x10, 0x02, 0xD7, 0x80, 0x4A, 0x09, 0x45, 0x70, 0x85, 0x48,
  0x0B, 0x10, 0x98, 0x60,
  // "7" (U+0037)
  0x18, 0x90, 0xAD, 0xDF, 0x10, 0x60, 0x2A, 0x40, 0xA0, 0x33, 0x02, 0x0B, 0x40, 0x90, 0x43, 0x01,
  0x0B, 0x40, 0x80, 0x53, 0x01, 0x0C, 0x40,
  // "8" (U+0038)
  0x03, 0x98, 0x60, 0xB1, 0x0C, 0x0C, 0x45, 0x90, 0x5E, 0xA0, 0x1A, 0x6D, 0x0A, 0x20, 0x94, 0xB1,
  0x0A, 0x24, 0x97, 0x60,
  // "9" (U+0039)
  0x03, 0xAA, 0x30, 0xC1, 0x3A, 0x2C, 0x02, 0xA2, 0xC0, 0x78, 0x08, 0x8B, 0x50, 0x00, 0xC1, 0x40,
  0x39, 0x06, 0x98, 0x00,
  // ":" (U+003A)
  0x09, 0x40, 0x41, 0x00, 0x00, 0x00, 0x22, 0x09, 0x50,
  // ";" (U+003B)
  0x09, 0x40, 0x41, 0x00, 0x00, 0x00, 0x32, 0x07, 0x70, 0x63, 0x03, 0x00,
  // "<" (U+003C)
  0x38, 0x78, 0x20, 0x49, 0x20, 0x3B, 0x48, 0x12, 0x93, 0x40, 0x60, 0x20,
  // "=" (U+003D)
  0x4A, 0xAA, 0x20, 0x00, 0x00, 0x4A, 0xAA, 0x20,
  // ">" (U+003E)
  0x47, 0x00, 0x00, 0x39, 0x30, 0x00, 0x1C, 0x20, 0x59, 0x10, 0x45, 0x00, 0x00,
  // "?" (U+003F)
  0x4A, 0xB4, 0xA1, 0x4A, 0x00, 0x78, 0x03, 0xB0, 0x19, 0x00, 0x23, 0x00, 0x41, 0x00, 0xB3, 0x00,
  // "@" (U+0040)
  0x00, 0x28, 0x89, 0x50, 0x02, 0xA0, 0x00, 0x83, 0x09, 0x18, 0x7B, 0x27, 0x19, 0x47, 0x0A, 0x08,
  0x46, 0x93, 0x37, 0x26, 0x54, 0xA3, 0x76, 0x62, 0x55, 0x3A, 0x49, 0x60, 0x28, 0x00, 0x00, 0x00,
  0x09, 0x20, 0x07, 0x10, 0x00, 0x78, 0x72, 0x00,
  // "A" (U+0041)
  0x40, 0x70, 0x85, 0x0B, 0x0A, 0x48, 0x16, 0x6B, 0x48, 0x1A, 0x1C, 0x38, 0x25, 0x50, 0xE3, 0x81,
  0xC8, 0x89, 0x20, 0x50, 0x62, 0x87, 0xD1, 0x3D, 0x60, 0x5F, 0x70,
  // "B" (U+0042)
  0x06, 0xE6, 0xB3, 0x02, 0xB0, 0x78, 0x05, 0x80, 0xA5, 0x08, 0xAB, 0x80, 0x0B, 0x20, 0xE0, 0x0D,
  0x00, 0xE1, 0x1D, 0x01, 0xD0, 0xAD, 0x69, 0x30,
  // "C" (U+0043)
  0x00, 0x59, 0xB7, 0x04, 0xA0, 0x2A, 0x0C, 0x20, 0x00, 0x3C, 0x00, 0x00, 0x69, 0x00, 0x00, 0x68,
  0x00, 0x00, 0x3C, 0x00, 0x30, 0x08, 0xBA, 0x40,
  // "D" (U+0044)
  0x06, 0xE7, 0x94, 0x00, 0x2C, 0x01, 0xD0, 0x05, 0x90, 0x0D, 0x20, 0x86, 0x00, 0xD1, 0x0B, 0x30,
  0x0E, 0x00, 0xD0, 0x05, 0xA0, 0x1D, 0x00, 0xC3, 0x0A, 0xD8, 0xB4, 0x00,
  // "E" (U+0045)
  0x06, 0xE6, 0x89, 0x02, 0xB0, 0x05, 0x05, 0x80, 0x00, 0x08, 0xA8, 0x30, 0x0B, 0x20, 0x00, 0x0D,
  0x00, 0x00, 0x1D, 0x00, 0x80, 0xAD, 0x68, 0x90,
  // "F" (U+0046)
  0x18, 0x66, 0xF6, 0x8A, 0x02, 0xC2, 0x82, 0x70, 0x5A, 0x40, 0x07, 0x48, 0x2A, 0xA8, 0x32, 0x0D,
  0x01, 0x30, 0x10, 0xD4, 0x81, 0xAE, 0x43,
  // "G" (U+0047)
  0x00, 0x59, 0x9B, 0x00, 0x5A, 0x00, 0xB1, 0x0D, 0x20, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x6A, 0x01,
  0xAA, 0x16, 0x80, 0x0A, 0x50, 0x3B, 0x00, 0xC1, 0x00, 0x79, 0x8A, 0x00,
  // "H" (U+0048)
  0x06, 0xF6, 0x0B, 0xD3, 0x02, 0xC0, 0x08, 0x70, 0x05, 0x80, 0x0B, 0x40, 0x08, 0xB8, 0x8F, 0x10,
  0x0B, 0x20, 0x1D, 0x00, 0x0D, 0x00, 0x4A, 0x00, 0x1D, 0x00, 0x68, 0x00, 0xAE, 0x33, 0xDB, 0x00,
  // "I" (U+0049)
  0x06, 0xF7, 0x02, 0xC0, 0x05, 0x90, 0x08, 0x60, 0x0B, 0x30, 0x0D, 0x10, 0x1D, 0x00, 0xAE, 0x30,
  // "J" (U+004A)
  0x38, 0x16, 0xF6, 0x30, 0x20, 0xC4, 0x05, 0x09, 0x40, 0x80, 0x64, 0x0B, 0x03, 0x40, 0xD4, 0x01,
  0x0D, 0x40, 0x40, 0xA4, 0x00, 0x74, 0x0B, 0x02, 0x28, 0x12, 0x87, 0x30,
  // "K" (U+004B)
  0x06, 0xF7, 0x1E, 0x60, 0x2C, 0x05, 0x60, 0x05, 0x92, 0x70, 0x00, 0x88, 0xB0, 0x00, 0x0B, 0xAE,
  0x10, 0x00, 0xD1, 0x95, 0x00, 0x1D, 0x05, 0xA0, 0x0A, 0xE3, 0x0C, 0x40,
  // "L" (U+004C)
  0x06, 0xF7, 0x00, 0x2C, 0x00, 0x05, 0x90, 0x00, 0x86, 0x00, 0x0B, 0x30, 0x00, 0xD1, 0x02, 0x1D,
  0x00, 0x8A, 0xD6, 0x79,
  // "M" (U+004D)
  0x06, 0xF5, 0x00, 0x6E, 0x50, 0x2C, 0x70, 0x0A, 0xA0, 0x05, 0x88, 0x05, 0x87, 0x00, 0x74, 0x90,
  0x79, 0x40, 0x08, 0x2B, 0x43, 0xC1, 0x00, 0x81, 0xC7, 0x0D, 0x00, 0x17, 0x0E, 0x42, 0xB0, 0x0A,
  0xA0, 0xB0, 0xAD, 0x20,
  // "N" (U+004E)
  0x06, 0xF1, 0x07, 0xC2, 0x02, 0xD6, 0x04, 0x40, 0x05, 0x6A, 0x06, 0x10, 0x07, 0x0D, 0x08, 0x00,
  0x08, 0x09, 0x48, 0x00, 0x08, 0x04, 0x97, 0x00, 0x17, 0x00, 0xE5, 0x00, 0xAA, 0x00, 0xA2, 0x00,
  // "O" (U+004F)
  0x00, 0x59, 0xA6, 0x00, 0x4A, 0x00, 0xD1, 0x0D, 0x20, 0x0B, 0x43, 0xC0, 0x00, 0xB4, 0x69, 0x00,
  0x0E, 0x16, 0x80, 0x04, 0xB0, 0x3B, 0x00, 0xB3, 0x00, 0x89, 0x94, 0x00,
  // "P" (U+0050)
  0x06, 0xF7, 0xA1, 0x02, 0xC0, 0x86, 0x05, 0x90, 0x86, 0x08, 0x60, 0xD2, 0x0A, 0x98, 0x30, 0x0D,
  0x00, 0x00, 0x1D, 0x00, 0x00, 0xAE, 0x40, 0x00,
  // "Q" (U+0051)
  0x00, 0x49, 0xA6, 0x00, 0x3B, 0x00, 0xD1, 0x0C, 0x30, 0x0B, 0x42, 0xD0, 0x00, 0xB4, 0x5A, 0x00,
  0x0D, 0x26, 0x80, 0x02, 0xD0, 0x59, 0x00, 0x87, 0x01, 0xD2, 0x4B, 0x00, 0x02, 0xD9, 0x00, 0x00,
  0x09, 0x50, 0x00, 0x00, 0x3B, 0x50, 0x00,
  // "R" (U+0052)
  0x06, 0xE7, 0xA2, 0x02, 0xC0, 0x78, 0x05, 0x90, 0x78, 0x08, 0x70, 0xB3, 0x0A, 0xAD, 0x40, 0x0D,
  0x1C, 0x20, 0x1D, 0x08, 0x60, 0xAE, 0x43, 0xC1,
  // "S" (U+0053)
  0x01, 0x99, 0x90, 0xA2, 0x09, 0x0C, 0x30, 0x00, 0x6D, 0x20, 0x00, 0x7E, 0x12, 0x00, 0xA4, 0xB0,
  0x0A, 0x25, 0xA8, 0x70,
  // "T" (U+0054)
  0x18, 0x92, 0xC8, 0xF8, 0xD1, 0x16, 0x1D, 0x07, 0x30, 0x40, 0xA5, 0x00, 0x75, 0x09, 0x04, 0x50,
  0xC0, 0x15, 0x0E, 0x58, 0x19, 0xE4, 0x30,
  // "U" (U+0055)
  0x08, 0xE5, 0x0B, 0x90, 0x49, 0x00, 0x80, 0x07, 0x60, 0x08, 0x00, 0xA3, 0x00, 0x80, 0x0D, 0x10,
  0x16, 0x01, 0xD0, 0x04, 0x30, 0x1D, 0x00, 0x90, 0x00, 0x8A, 0x94, 0x00,
  // "V" (U+0056)
  0xCC, 0x22, 0xD6, 0x78, 0x00, 0x90, 0x59, 0x05, 0x30, 0x4A, 0x09, 0x00, 0x3B, 0x35, 0x00, 0x2C,
  0x80, 0x00, 0x0D, 0x60, 0x00, 0x0E, 0x00, 0x00,
  // "W" (U+0057)
  0xBD, 0x30, 0xD0, 0x1C, 0x86, 0x80, 0x4F, 0x00, 0x90, 0x59, 0x08, 0xD0, 0x26, 0x05, 0x91, 0x6C,
  0x18, 0x00, 0x4A, 0x71, 0xB2, 0x80, 0x04, 0xA8, 0x0B, 0x83, 0x00, 0x3E, 0x40, 0xAA, 0x00, 0x02,
  0xD0, 0x0A, 0x60, 0x00,
  // "X" (U+0058)
  0x28, 0x48, 0xF3, 0x3D, 0x33, 0x82, 0xE1, 0x63, 0x48, 0x1A, 0x67, 0x50, 0x60, 0xC6, 0x07, 0x0D,
  0x58, 0x24, 0x4C, 0x23, 0x83, 0x17, 0x08, 0x72, 0x85, 0x2C, 0x70, 0xBD, 0x11,
  // "Y" (U+0059)
  0x89, 0x6C, 0xB2, 0x5E, 0x36, 0x90, 0x45, 0x02, 0xC0, 0x83, 0x81, 0xD7, 0x13, 0x0A, 0x07, 0x40,
  0xB0, 0x24, 0x0E, 0x48, 0x19, 0xF4, 0x30,
  // "Z" (U+005A)
  0x0A, 0x88, 0xD9, 0x07, 0x02, 0xE1, 0x00, 0x0C, 0x50, 0x00, 0x6B, 0x00, 0x01, 0xE1, 0x00, 0x0B,
  0x60, 0x00, 0x5B, 0x00, 0x70, 0xEA, 0x89, 0x90,
  // "[" (U+005B)
  0x02, 0xD6, 0x05, 0x80, 0x08, 0x50, 0x0B, 0x20, 0x0E, 0x00, 0x2B, 0x00, 0x58, 0x00, 0x85, 0x00,
  0xB3, 0x00, 0xA8, 0x00,
  // "\" (U+005C)
  0x80, 0x58, 0x03,
  // "]" (U+005D)
  0x00, 0x4D, 0x50, 0x00, 0xC2, 0x00, 0x0E, 0x00, 0x02, 0xB0, 0x00, 0x58, 0x00, 0x08, 0x50, 0x00,
  0xB2, 0x00, 0x0E, 0x00, 0x02, 0xC0, 0x02, 0x96, 0x00,
  // "^" (U+005E)
  0x00, 0xA0, 0x00, 0x4A, 0x10, 0x08, 0x17, 0x00, 0x80, 0x80, 0x53, 0x05, 0x30,
  // "_" (U+005F)
  0x8B, 0xBB, 0x30,
  // "`" (U+0060)
  0x58, 0x09,
  // "a" (U+0061)
  0x02, 0x99, 0x90, 0xC1, 0x58, 0x49, 0x08, 0x58, 0x60, 0xC2, 0x85, 0x3E, 0x04, 0xC5, 0xB7,
  // "b" (U+0062)
  0x0A, 0xA0, 0x00, 0x67, 0x00, 0x09, 0x8C, 0x50, 0xD4, 0x4A, 0x0D, 0x05, 0x93, 0x90, 0x86, 0x76,
  0x0C, 0x08, 0x99, 0x30,
  // "c" (U+0063)
  0x02, 0x9C, 0x30, 0xC0, 0x52, 0x59, 0x00, 0x08, 0x60, 0x00, 0x77, 0x01, 0x01, 0xB9, 0x30,
  // "d" (U+0064)
  0x00, 0x03, 0xE3, 0x00, 0x00, 0xD0, 0x02, 0x99, 0xC0, 0x0C, 0x15, 0x90, 0x49, 0x08, 0x60, 0x86,
  0x0C, 0x20, 0x85, 0x3E, 0x00, 0x4C, 0x5B, 0x70,
  // "e" (U+0065)
  0x02, 0x9C, 0x10, 0xC0, 0xB3, 0x5A, 0x2C, 0x08, 0xB8, 0x10, 0x77, 0x01, 0x01, 0xB9, 0x40,
  // "f" (U+0066)
  0x48, 0x1A, 0xA5, 0x38, 0x25, 0x82, 0x22, 0x82, 0x1B, 0xB3, 0x40, 0xB0, 0x25, 0x0D, 0x50, 0x20,
  0xB5, 0x04, 0x09, 0x50, 0x70, 0x65, 0x0A, 0x03, 0x50, 0xC4, 0x81, 0x19, 0x54,
  // "g" (U+0067)
  0x00, 0x18, 0xA7, 0x20, 0x0A, 0x18, 0x40, 0x00, 0xC0, 0x93, 0x00, 0x0C, 0x0B, 0x00, 0x00, 0xA9,
  0x20, 0x00, 0x39, 0x30, 0x00, 0x06, 0x8A, 0xB0, 0x04, 0x70, 0x0C, 0x00, 0x1A, 0x89, 0x30, 0x00,
  // "h" (U+0068)
  0x08, 0xC0, 0x00, 0x48, 0x00, 0x07, 0x8A, 0x70, 0xB6, 0x3A, 0x0D, 0x06, 0x81, 0xB0, 0x85, 0x58,
  0x0B, 0x28, 0x50, 0x9A,
  // "i" (U+0069)
  0x04, 0x90, 0x01, 0x2D, 0x40, 0xC1, 0x0D, 0x02, 0xB0, 0x59, 0x03, 0xC3,
  // "j" (U+006A)
  0x30, 0x30, 0x94, 0x01, 0x28, 0x11, 0xD4, 0x30, 0xC0, 0x23, 0x0D, 0x30, 0x20, 0xB3, 0x04, 0x09,
  0x30, 0x70, 0x63, 0x0A, 0x03, 0x30, 0xC2, 0x81, 0x19, 0x52,
  // "k" (U+006B)
  0x08, 0xC0, 0x00, 0x05, 0x80, 0x00, 0x08, 0x56, 0xC2, 0x0B, 0x28, 0x10, 0x0D, 0x93, 0x00, 0x1D,
  0x97, 0x00, 0x58, 0x2C, 0x00, 0x85, 0x0A, 0x50,
  // "l" (U+006C)
  0x09, 0xB0, 0x58, 0x08, 0x50, 0xB2, 0x0D, 0x02, 0xB0, 0x48, 0x03, 0xC3,
  // "m" (U+006D)
  0x2E, 0x7B, 0x76, 0xD1, 0x0C, 0x63, 0xD1, 0xA3, 0x0E, 0x06, 0x80, 0xC1, 0x2B, 0x09, 0x40, 0xD0,
  0x58, 0x0B, 0x22, 0xB0, 0x85, 0x0D, 0x01, 0xD4,
  // "n" (U+006E)
  0x2E, 0x7A, 0x70, 0xC6, 0x3A, 0x0E, 0x06, 0x72, 0xB0, 0x94, 0x58, 0x0B, 0x28, 0x50, 0x99,
  // "o" (U+006F)
  0x03, 0x9A, 0x30, 0xC0, 0x3A, 0x59, 0x03, 0xA8, 0x60, 0x68, 0x76, 0x0B, 0x21, 0xA8, 0x50,
  // "p" (U+0070)
  0x8B, 0x62, 0xD7, 0xB7, 0x0B, 0x62, 0xC0, 0xE0, 0x3B, 0x2B, 0x06, 0x84, 0x80, 0xB1, 0x7A, 0x95,
  0x0A, 0x23, 0x0D, 0x49, 0x05, 0x30,
  // "q" (U+0071)
  0x02, 0x99, 0xA0, 0xC1, 0x59, 0x49, 0x08, 0x67, 0x60, 0xC3, 0x86, 0x3E, 0x03, 0xC7, 0xD0, 0x00,
  0x3A, 0x00, 0x06, 0x70, 0x00, 0x8B, 0x00,
  // "r" (U+0072)
  0x2E, 0x6C, 0x30, 0xC6, 0x31, 0x0E, 0x10, 0x02, 0xB0, 0x00, 0x58, 0x00, 0x08, 0x50, 0x00,
  // "s" (U+0073)
  0x08, 0x89, 0x1B, 0x06, 0x0D, 0x70, 0x01, 0xC5, 0x80, 0x57, 0x79, 0x91,
  // "t" (U+0074)
  0x00, 0x30, 0x05, 0x70, 0x2D, 0xB3, 0x0C, 0x10, 0x0D, 0x00, 0x2B, 0x00, 0x59, 0x00, 0x2C, 0x60,
  // "u" (U+0075)
  0x2D, 0x40, 0xD0, 0xC1, 0x3B, 0x0D, 0x05, 0x82, 0xB0, 0xA5, 0x58, 0x2D, 0x22, 0xD6, 0x99,
  // "v" (U+0076)
  0x6C, 0x07, 0x60, 0xD0, 0x37, 0x0D, 0x04, 0x40, 0xC1, 0x70, 0x0B, 0x44, 0x00, 0x99, 0x00, 0x01,
  0x00, 0x00,
  // "w" (U+0077)
  0x3E, 0x04, 0xA0, 0xA0, 0xD0, 0x8A, 0x08, 0x0D, 0x07, 0xB0, 0x70, 0xD5, 0x2B, 0x42, 0x0C, 0x61,
  0xB6, 0x00, 0xD2, 0x1D, 0x10,
  // "x" (U+0078)
  0x0C, 0x44, 0x90, 0x58, 0x80, 0x00, 0xE2, 0x00, 0x3E, 0x20, 0x08, 0x76, 0x0A, 0x33, 0xD1,
  // "y" (U+0079)
  0x28, 0x38, 0xA0, 0x75, 0x28, 0x31, 0xD0, 0x46, 0x38, 0x2D, 0x07, 0x33, 0x81, 0xA3, 0x94, 0x81,
  0x78, 0x64, 0x04, 0x0D, 0x50, 0x05, 0x40, 0x20, 0xA3, 0x82, 0x39, 0xA1, 0x30,
  // "z" (U+007A)
  0x0C, 0x9F, 0x20, 0x36, 0x90, 0x01, 0xD0, 0x00, 0xA5, 0x00, 0x4B, 0x05, 0x0D, 0xB9, 0x90,
  // "{" (U+007B)
  0x28, 0x14, 0xA2, 0x20, 0xB0, 0x33, 0x0D, 0x30, 0x30, 0xA2, 0x81, 0x3C, 0x13, 0x09, 0x04, 0x30,
  0xB0, 0x33, 0x0D, 0x40, 0xE4, 0x08, 0x04, 0x20,
  // "|" (U+007C)
  0x80, 0x78,
  // "}" (U+007D)
  0x00, 0x4C, 0x00, 0x00, 0xD0, 0x00, 0x2B, 0x00, 0x04, 0x90, 0x00, 0x1C, 0x20, 0x09, 0x30, 0x00,
  0xD0, 0x00, 0x1C, 0x00, 0x05, 0x80, 0x03, 0x81, 0x00,
  // "~" (U+007E)
  0x19, 0x53, 0x45, 0x16, 0x90,
  // "¡" (U+00A1)
  0x08, 0x60, 0x32, 0x04, 0x00, 0x80, 0x19, 0x05, 0x70, 0x94, 0x0C, 0x20,
  // "¢" (U+00A2)
  0x00, 0x08, 0x00, 0x1C, 0xCA, 0x09, 0x66, 0x40, 0xE3, 0x30, 0x2C, 0x50, 0x01, 0xD7, 0x30, 0x09,
  0xD7, 0x00, 0x06, 0x00,
  // "£" (U+00A3)
  0x00, 0x88, 0xB0, 0x56, 0x06, 0x07, 0x40, 0x02, 0xBB, 0x60, 0x06, 0x60, 0x00, 0x83, 0x00, 0x1A,
  0x20, 0x18, 0x9D, 0xA1,
  // "¤" (U+00A4)
  0x10, 0x01, 0xA9, 0x9A, 0x90, 0x09, 0x90, 0x09, 0xA9, 0x9A,
  // "¥" (U+00A5)
  0x0C, 0xB0, 0xB7, 0x06, 0x70, 0x80, 0x03, 0xA4, 0x30, 0x00, 0xC7, 0x00, 0x07, 0xE9, 0x20, 0x28,
  0xE7, 0x00, 0x03, 0xA0, 0x00, 0x2B, 0xD2, 0x00,
  // "¦" (U+00A6)
  0x88, 0x88, 0x30, 0x38, 0x88, 0x80,
  // "§" (U+00A7)
  0x00, 0x79, 0x60, 0x53, 0x17, 0x07, 0x70, 0x00, 0x7D, 0x80, 0x19, 0x1C, 0x20, 0xE8, 0x82, 0x02,
  0xDA, 0x00, 0x02, 0x90, 0xA0, 0x35, 0x04, 0x86, 0x00,
  // "¨" (U+00A8)
  0x73, 0x40,
  // "©" (U+00A9)
  0x00, 0x67, 0x71, 0x00, 0x81, 0x00, 0x80, 0x24, 0x36, 0x61, 0x66, 0x08, 0x05, 0x07, 0x71, 0x70,
  0x00, 0x76, 0x17, 0x00, 0x07, 0x25, 0x90, 0x31, 0x60, 0x85, 0x76, 0x80, 0x00, 0x67, 0x71, 0x00,
  // "ª" (U+00AA)
  0x07, 0x78, 0x29, 0x65, 0x2B, 0x86,
  // "«" (U+00AB)
  0x02, 0x67, 0x21, 0xB6, 0x70, 0x39, 0x93, 0x00, 0x92, 0x70,
  // "¬" (U+00AC)
  0x39, 0x9A, 0x30, 0x00, 0x44, 0x00, 0x04, 0x40, 0x00, 0x11,
  // "®" (U+00AE)
  0x00, 0x67, 0x71, 0x00, 0x81, 0x00, 0x80, 0x24, 0x76, 0x51, 0x66, 0x06, 0x29, 0x07, 0x70, 0x69,
  0x60, 0x76, 0x06, 0x39, 0x07, 0x25, 0x75, 0x54, 0x60, 0x81, 0x00, 0x80, 0x00, 0x67, 0x71, 0x00,
  // "¯" (U+00AF)
  0x9B, 0xBB, 0x20,
  // "°" (U+00B0)
  0x27, 0x37, 0x07, 0x70, 0x72, 0x73,
  // "±" (U+00B1)
  0x20, 0x94, 0x09, 0x28, 0x32, 0x9D, 0x93, 0x20, 0x94, 0x06, 0x28, 0x32, 0x99, 0x93,
  // "²" (U+00B2)
  0x03, 0x75, 0x05, 0x1A, 0x00, 0x63, 0x05, 0x32, 0x2A, 0x83,
  // "³" (U+00B3)
  0x03, 0x86, 0x04, 0x1B, 0x01, 0xA3, 0x12, 0x48, 0x18, 0x81,
  // "´" (U+00B4)
  0x2C, 0x81,
  // "µ" (U+00B5)
  0x18, 0xB4, 0x94, 0x0D, 0x0C, 0x12, 0xB0, 0xD0, 0x58, 0x2B, 0x08, 0x55, 0x90, 0xD2, 0x7B, 0x89,
  0x89, 0x40, 0xC4, 0x0D, 0x40,
  // "¶" (U+00B6)
  0x1C, 0xFB, 0xC8, 0x5F, 0xF7, 0x90, 0x5F, 0xF7, 0x90, 0x1E, 0xF7, 0x90, 0x01, 0x57, 0x90, 0x00,
  0x27, 0x90, 0x00, 0x27, 0x90, 0x00, 0x27, 0x90, 0x00, 0x27, 0x90, 0x00, 0x95, 0x68,
  // "·" (U+00B7)
  0x05, 0x1D,
  // "¸" (U+00B8)
  0x05, 0x00, 0x93, 0x69, 0x00,
  // "¹" (U+00B9)
  0x08, 0x25, 0xC0, 0x0B, 0x01, 0x90, 0x68, 0x00,
  // "º" (U+00BA)
  0x07, 0x78, 0x2A, 0x1A, 0x1A, 0x82,
  // "»" (U+00BB)
  0x09, 0x35, 0x08, 0x4C, 0x0B, 0x59, 0x63, 0x80,
  // "¼" (U+00BC)
  0x08, 0x20, 0x08, 0x5C, 0x00, 0x72, 0x0B, 0x01, 0x70, 0x19, 0x08, 0x56, 0x68, 0x47, 0xB5, 0x00,
  0x97, 0x82, 0x05, 0x77, 0xC5, 0x09, 0x03, 0x91,
  // "½" (U+00BD)
  0x08, 0x20, 0x08, 0x5C, 0x00, 0x72, 0x0B, 0x01, 0x70, 0x19, 0x0B, 0x85, 0x68, 0x4B, 0x1A, 0x00,
  0x90, 0x63, 0x05, 0x45, 0x32, 0x09, 0x2A, 0x83,
  // "¾" (U+00BE)
  0x03, 0x86, 0x00, 0x80, 0x41, 0xB0, 0x72, 0x01, 0xA3, 0x17, 0x01, 0x24, 0x88, 0x56, 0x18, 0x85,
  0x7B, 0x50, 0x00, 0x97, 0x82, 0x00, 0x57, 0x7C, 0x50, 0x09, 0x03, 0x91,
  // "¿" (U+00BF)
  0x00, 0x76, 0x00, 0x32, 0x00, 0x50, 0x02, 0x90, 0x4A, 0x00, 0xD1, 0x00, 0xE0, 0x75, 0x59, 0x80,
  // "À" (U+00C0)
  0x40, 0x50, 0x86, 0x09, 0x75, 0x07, 0x08, 0x50, 0xB0, 0xA4, 0x81, 0x66, 0xB4, 0x81, 0xA1, 0xC3,
  0x82, 0x55, 0x0E, 0x38, 0x1C, 0x88, 0x92, 0x05, 0x06, 0x28, 0x7D, 0x13, 0xD6, 0x05, 0xF7,
  // "Á" (U+00C1)
  0x50, 0x20, 0xC5, 0x08, 0x01, 0x74, 0x07, 0x08, 0x50, 0xB0, 0xA4, 0x81, 0x66, 0xB4, 0x81, 0xA1,
  0xC3, 0x82, 0x55, 0x0E, 0x38, 0x1C, 0x88, 0x92, 0x05, 0x06, 0x28, 0x7D, 0x13, 0xD6, 0x05, 0xF7,
  // "Â" (U+00C2)
  0x50, 0xD0, 0x54, 0x81, 0x72, 0x87, 0x40, 0x70, 0x85, 0x0B, 0x0A, 0x48, 0x16, 0x6B, 0x48, 0x1A,
  0x1C, 0x38, 0x25, 0x50, 0xE3, 0x81, 0xC8, 0x89, 0x20, 0x50, 0x62, 0x87, 0xD1, 0x3D, 0x60, 0x5F,
  0x70,
  // "Ã" (U+00C3)
  0x48, 0x24, 0xA1, 0x34, 0x81, 0x44, 0xB7, 0x60, 0x70, 0x86, 0x0B, 0x0A, 0x58, 0x16, 0x6B, 0x58,
  0x1A, 0x1C, 0x48, 0x25, 0x50, 0xE4, 0x81, 0xC8, 0x89, 0x30, 0x50, 0x62, 0x89, 0x0D, 0x10, 0x3D,
  0x60, 0x5F, 0x71,
  // "Ä" (U+00C4)
  0x48, 0x17, 0x34, 0x74, 0x07, 0x08, 0x50, 0xB0, 0xA4, 0x81, 0x66, 0xB4, 0x81, 0xA1, 0xC3, 0x82,
  0x55, 0x0E, 0x38, 0x1C, 0x88, 0x92, 0x05, 0x06, 0x28, 0x7D, 0x13, 0xD6, 0x05, 0xF7,
  // "Å" (U+00C5)
  0x48, 0x13, 0x81, 0x48, 0x17, 0x25, 0x48, 0x1B, 0xF1, 0x40, 0xB0, 0xA4, 0x81, 0x66, 0xB4, 0x81,
  0xA1, 0xC3, 0x82, 0x55, 0x0E, 0x38, 0x1C, 0x88, 0x92, 0x05, 0x06, 0x28, 0x7D, 0x13, 0xD6, 0x05,
  0xF7,
  // "Æ" (U+00C6)
  0x48, 0x42, 0xCE, 0x8B, 0x74, 0x84, 0x48, 0x90, 0x23, 0x48, 0x19, 0x76, 0x68, 0x47, 0x49, 0x98,
  0x23, 0x82, 0x1A, 0x0C, 0x68, 0x29, 0x98, 0xD5, 0x83, 0x38, 0x02, 0xB2, 0x89, 0x15, 0x02, 0xD6,
  0x2B, 0xB6, 0x97, 0x10,
  // "Ç" (U+00C7)
  0x28, 0x93, 0x59, 0xB7, 0x04, 0xA0, 0x2A, 0x0C, 0x23, 0x03, 0x0C, 0x40, 0x60, 0x94, 0x06, 0x08,
  0x40, 0x30, 0xC2, 0x03, 0x28, 0x28, 0xBA, 0x43, 0x05, 0x50, 0x90, 0x33, 0x06, 0x09, 0x30,
  // "È" (U+00C8)
  0x20, 0x50, 0x85, 0x09, 0x72, 0x86, 0x6E, 0x68, 0x90, 0x2B, 0x28, 0x25, 0x05, 0x84, 0x82, 0x8A,
  0x83, 0x20, 0xB0, 0x24, 0x0D, 0x40, 0x10, 0xD2, 0x85, 0x80, 0xAD, 0x68, 0x91,
  // "É" (U+00C9)
  0x30, 0x20, 0xC4, 0x08, 0x01, 0x71, 0x86, 0x6E, 0x68, 0x90, 0x2B, 0x28, 0x25, 0x05, 0x84, 0x82,
  0x8A, 0x83, 0x20, 0xB0, 0x24, 0x0D, 0x40, 0x10, 0xD2, 0x85, 0x80, 0xAD, 0x68, 0x91,
  // "Ê" (U+00CA)
  0x30, 0xD0, 0x53, 0x81, 0x72, 0x87, 0x18, 0x66, 0xE6, 0x89, 0x02, 0xB2, 0x82, 0x50, 0x58, 0x48,
  0x28, 0xA8, 0x32, 0x0B, 0x02, 0x40, 0xD4, 0x01, 0x0D, 0x28, 0x58, 0x0A, 0xD6, 0x89, 0x10,
  // "Ë" (U+00CB)
  0x38, 0x17, 0x34, 0x78, 0x66, 0xE6, 0x89, 0x02, 0xB2, 0x82, 0x50, 0x58, 0x48, 0x28, 0xA8, 0x32,
  0x0B, 0x02, 0x40, 0xD4, 0x01, 0x0D, 0x28, 0x58, 0x0A, 0xD6, 0x89, 0x10,
  // "Ì" (U+00CC)
  0x05, 0x80, 0x00, 0x90, 0x00, 0x00, 0x06, 0xF7, 0x02, 0xC0, 0x05, 0x90, 0x08, 0x60, 0x0B, 0x30,
  0x0D, 0x10, 0x1D, 0x00, 0xAE, 0x30,
  // "Í" (U+00CD)
  0x00, 0x2C, 0x00, 0x81, 0x00, 0x00, 0x06, 0xF7, 0x02, 0xC0, 0x05, 0x90, 0x08, 0x60, 0x0B, 0x30,
  0x0D, 0x10, 0x1D, 0x00, 0xAE, 0x30,
  // "Î" (U+00CE)
  0x00, 0xD5, 0x07, 0x28, 0x00, 0x00, 0x06, 0xF7, 0x02, 0xC0, 0x05, 0x90, 0x08, 0x60, 0x0B, 0x30,
  0x0D, 0x10, 0x1D, 0x00, 0xAE, 0x30,
  // "Ï" (U+00CF)
  0x00, 0x73, 0x40, 0x00, 0x00, 0x06, 0xF7, 0x00, 0x2C, 0x00, 0x05, 0x90, 0x00, 0x86, 0x00, 0x0B,
  0x30, 0x00, 0xD1, 0x00, 0x1D, 0x00, 0x0A, 0xE3, 0x00,
  // "Ð" (U+00D0)
  0x06, 0xE7, 0x94, 0x00, 0x2B, 0x01, 0xD0, 0x05, 0x80, 0x0D, 0x23, 0xCB, 0x60, 0xD1, 0x0B, 0x20,
  0x0E, 0x00, 0xE0, 0x05, 0xA0, 0x1D, 0x00, 0xC3, 0x0A, 0xD8, 0xB4, 0x00,
  // "Ñ" (U+00D1)
  0x38, 0x24, 0xA1, 0x34, 0x81, 0x44, 0xB7, 0x48, 0x94, 0x6F, 0x10, 0x7C, 0x20, 0x2D, 0x60, 0x44,
  0x28, 0x45, 0x6A, 0x06, 0x12, 0x83, 0x70, 0xD0, 0x83, 0x83, 0x80, 0x94, 0x83, 0x83, 0x80, 0x49,
  0x72, 0x01, 0x07, 0x20, 0xE0, 0x52, 0x00, 0xA2, 0x0A, 0x02, 0x20,
  // "Ò" (U+00D2)
  0x30, 0x50, 0x86, 0x09, 0x74, 0x82, 0x59, 0xA6, 0x20, 0x40, 0xA2, 0x83, 0xD1, 0x0D, 0x22, 0x82,
  0xB4, 0x3C, 0x38, 0x2B, 0x46, 0x93, 0x82, 0xE1, 0x68, 0x28, 0x34, 0xB0, 0x3B, 0x20, 0xB0, 0x32,
  0x82, 0x89, 0x94, 0x20,
  // "Ó" (U+00D3)
  0x40, 0x20, 0xC5, 0x08, 0x01, 0x73, 0x82, 0x59, 0xA6, 0x20, 0x40, 0xA2, 0x83, 0xD1, 0x0D, 0x22,
  0x82, 0xB4, 0x3C, 0x38, 0x2B, 0x46, 0x93, 0x82, 0xE1, 0x68, 0x28, 0x34, 0xB0, 0x3B, 0x20, 0xB0,
  0x32, 0x82, 0x89, 0x94, 0x20,
  // "Ô" (U+00D4)
  0x40, 0xD0, 0x54, 0x81, 0x72, 0x87, 0x38, 0x25, 0x9A, 0x62, 0x04, 0x0A, 0x28, 0x3D, 0x10, 0xD2,
  0x28, 0x2B, 0x43, 0xC3, 0x82, 0xB4, 0x69, 0x38, 0x2E, 0x16, 0x82, 0x83, 0x4B, 0x03, 0xB2, 0x0B,
  0x03, 0x28, 0x28, 0x99, 0x42,
  // "Õ" (U+00D5)
  0x38, 0x24, 0xA1, 0x33, 0x81, 0x44, 0xB7, 0x38, 0x25, 0x9A, 0x62, 0x04, 0x0A, 0x28, 0x3D, 0x10,
  0xD2, 0x28, 0x2B, 0x43, 0xC3, 0x82, 0xB4, 0x69, 0x38, 0x2E, 0x16, 0x82, 0x83, 0x4B, 0x03, 0xB2,
  0x0B, 0x03, 0x28, 0x28, 0x99, 0x42,
  // "Ö" (U+00D6)
  0x00, 0x07, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0xA6, 0x00, 0x4A, 0x00, 0xD1, 0x0D, 0x20,
  0x0B, 0x43, 0xC0, 0x00, 0xB4, 0x69, 0x00, 0x0E, 0x16, 0x80, 0x04, 0xB0, 0x3B, 0x00, 0xB3, 0x00,
  0x89, 0x94, 0x00,
  // "×" (U+00D7)
  0x23, 0x04, 0x10, 0x95, 0x80, 0x02, 0xE1, 0x00, 0x92, 0x90, 0x11, 0x02, 0x00,
  // "Ø" (U+00D8)
  0x00, 0x59, 0xAB, 0x10, 0x4A, 0x04, 0xE1, 0x0D, 0x20, 0x7B, 0x43, 0xC0, 0x61, 0xB4, 0x69, 0x16,
  0x0E, 0x16, 0x87, 0x04, 0xB0, 0x3D, 0x40, 0xB3, 0x00, 0xC9, 0x94, 0x00, 0x21, 0x00, 0x00, 0x00,
  // "Ù" (U+00D9)
  0x30, 0x50, 0x86, 0x09, 0x73, 0x87, 0x8E, 0x50, 0xB9, 0x04, 0x92, 0x08, 0x20, 0x70, 0x62, 0x08,
  0x20, 0xA0, 0x32, 0x08, 0x28, 0x6D, 0x10, 0x16, 0x01, 0xD2, 0x83, 0x43, 0x01, 0xD2, 0x09, 0x38,
  0x28, 0xA9, 0x42,
  // "Ú" (U+00DA)
  0x40, 0x20, 0xC5, 0x08, 0x01, 0x72, 0x87, 0x8E, 0x50, 0xB9, 0x04, 0x92, 0x08, 0x20, 0x70, 0x62,
  0x08, 0x20, 0xA0, 0x32, 0x08, 0x28, 0x6D, 0x10, 0x16, 0x01, 0xD2, 0x83, 0x43, 0x01, 0xD2, 0x09,
  0x38, 0x28, 0xA9, 0x42,
  // "Û" (U+00DB)
  0x40, 0xD0, 0x54, 0x81, 0x72, 0x87, 0x28, 0x78, 0xE5, 0x0B, 0x90, 0x49, 0x20, 0x82, 0x07, 0x06,
  0x20, 0x82, 0x0A, 0x03, 0x20, 0x82, 0x86, 0xD1, 0x01, 0x60, 0x1D, 0x28, 0x34, 0x30, 0x1D, 0x20,
  0x93, 0x82, 0x8A, 0x94, 0x20,
  // "Ü" (U+00DC)
  0x38, 0x17, 0x34, 0x72, 0x87, 0x8E, 0x50, 0xB9, 0x04, 0x92, 0x08, 0x20, 0x70, 0x62, 0x08, 0x20,
  0xA0, 0x32, 0x08, 0x28, 0x6D, 0x10, 0x16, 0x01, 0xD2, 0x83, 0x43, 0x01, 0xD2, 0x09, 0x38, 0x28,
  0xA9, 0x42,
  // "Ý" (U+00DD)
  0x20, 0x20, 0xC4, 0x08, 0x01, 0x71, 0x89, 0x6C, 0xB2, 0x5E, 0x36, 0x90, 0x45, 0x02, 0xC0, 0x83,
  0x81, 0xD7, 0x13, 0x0A, 0x07, 0x40, 0xB0, 0x24, 0x0E, 0x48, 0x19, 0xF4, 0x30,
  // "Þ" (U+00DE)
  0x06, 0xF7, 0x00, 0x02, 0xD9, 0x40, 0x05, 0x90, 0xD1, 0x08, 0x60, 0xC3, 0x0B, 0x40, 0xD2, 0x0D,
  0x14, 0xB0, 0x1F, 0x88, 0x10, 0xAE, 0x30, 0x00,
  // "ß" (U+00DF)
  0x48, 0x28, 0x8B, 0x23, 0x83, 0x4A, 0x06, 0x62, 0x84, 0x2D, 0x69, 0x72, 0x38, 0x1B, 0x6A, 0x58,
  0x2E, 0x1D, 0x43, 0x83, 0x1D, 0x03, 0xD3, 0x83, 0x4A, 0x60, 0xC3, 0x83, 0x77, 0xA8, 0x73, 0x0A,
  0x03, 0x60, 0xD5, 0x81, 0x19, 0x55,
  // "à" (U+00E0)
  0x20, 0x50, 0x84, 0x09, 0x78, 0xB3, 0x29, 0x99, 0x0C, 0x15, 0x84, 0x90, 0x85, 0x86, 0x0C, 0x28,
  0x53, 0xE0, 0x4C, 0x5B, 0x70,
  // "á" (U+00E1)
  0x30, 0x20, 0xC3, 0x08, 0x01, 0x68, 0xB3, 0x29, 0x99, 0x0C, 0x15, 0x84, 0x90, 0x85, 0x86, 0x0C,
  0x28, 0x53, 0xE0, 0x4C, 0x5B, 0x70,
  // "â" (U+00E2)
  0x30, 0xD0, 0x52, 0x81, 0x72, 0x86, 0x8B, 0x32, 0x99, 0x90, 0xC1, 0x58, 0x49, 0x08, 0x58, 0x60,
  0xC2, 0x85, 0x3E, 0x04, 0xC5, 0xB7,
  // "ã" (U+00E3)
  0x00, 0x4A, 0x13, 0x00, 0x44, 0xB0, 0x00, 0x00, 0x00, 0x02, 0x99, 0x90, 0x0C, 0x15, 0x80, 0x49,
  0x08, 0x50, 0x86, 0x0C, 0x20, 0x85, 0x3E, 0x00, 0x4C, 0x5B, 0x70,
  // "ä" (U+00E4)
  0x00, 0x73, 0x40, 0x00, 0x00, 0x02, 0x99, 0x90, 0xC1, 0x58, 0x49, 0x08, 0x58, 0x60, 0xC2, 0x85,
  0x3E, 0x04, 0xC5, 0xB7,
  // "å" (U+00E5)
  0x00, 0x38, 0x10, 0x07, 0x25, 0x00, 0x48, 0x10, 0x29, 0x99, 0x0C, 0x15, 0x84, 0x90, 0x85, 0x86,
  0x0C, 0x28, 0x53, 0xE0, 0x4C, 0x5B, 0x70,
  // "æ" (U+00E6)
  0x03, 0xA8, 0x78, 0xB0, 0xC0, 0x2C, 0x0E, 0x59, 0x08, 0x64, 0xA8, 0x60, 0xC9, 0x70, 0x87, 0x1E,
  0x30, 0x03, 0xC8, 0x4C, 0x92,
  // "ç" (U+00E7)
  0x02, 0x9C, 0x30, 0xC0, 0x52, 0x59, 0x00, 0x08, 0x60, 0x00, 0x77, 0x01, 0x01, 0xB9, 0x30, 0x05,
  0x00, 0x00, 0x93, 0x00, 0x69, 0x00, 0x00,
  // "è" (U+00E8)
  0x20, 0x50, 0x84, 0x09, 0x78, 0xB2, 0x29, 0xC1, 0x0C, 0x0B, 0x35, 0xA2, 0xC0, 0x8B, 0x81, 0x07,
  0x70, 0x10, 0x1B, 0x94, 0x10,
  // "é" (U+00E9)
  0x30, 0x20, 0xC3, 0x08, 0x01, 0x68, 0xB2, 0x29, 0xC1, 0x0C, 0x0B, 0x35, 0xA2, 0xC0, 0x8B, 0x81,
  0x07, 0x70, 0x10, 0x1B, 0x94, 0x10,
  // "ê" (U+00EA)
  0x30, 0xD0, 0x52, 0x81, 0x72, 0x86, 0x8B, 0x22, 0x9C, 0x10, 0xC0, 0xB3, 0x5A, 0x2C, 0x08, 0xB8,
  0x10, 0x77, 0x01, 0x01, 0xB9, 0x41,
  // "ë" (U+00EB)
  0x00, 0x73, 0x40, 0x00, 0x00, 0x02, 0x9C, 0x10, 0xC0, 0xB3, 0x5A, 0x2C, 0x08, 0xB8, 0x10, 0x77,
  0x01, 0x01, 0xB9, 0x40,
  // "ì" (U+00EC)
  0x58, 0x00, 0x90, 0x00, 0x02, 0xD4, 0x0C, 0x10, 0xD0, 0x2B, 0x05, 0x80, 0x3C, 0x30,
  // "í" (U+00ED)
  0x02, 0xC0, 0x81, 0x00, 0x02, 0xD4, 0x0C, 0x10, 0xD0, 0x2B, 0x05, 0x80, 0x3C, 0x30,
  // "î" (U+00EE)
  0x0D, 0x57, 0x28, 0x00, 0x02, 0xD4, 0x0C, 0x10, 0xD0, 0x2B, 0x05, 0x80, 0x3C, 0x30,
  // "ï" (U+00EF)
  0x07, 0x34, 0x00, 0x00, 0x2D, 0x40, 0x0C, 0x10, 0x0D, 0x00, 0x2B, 0x00, 0x58, 0x00, 0x3C, 0x30,
  // "ð" (U+00F0)
  0x00, 0x50, 0x30, 0x06, 0xD3, 0x00, 0x68, 0x30, 0x29, 0xA8, 0x0C, 0x15, 0xA5, 0x90, 0x4A, 0x86,
  0x06, 0x77, 0x60, 0xB2, 0x1A, 0x95, 0x00,
  // "ñ" (U+00F1)
  0x00, 0x4A, 0x13, 0x00, 0x44, 0xB0, 0x00, 0x00, 0x00, 0x2E, 0x7A, 0x70, 0x0C, 0x63, 0xA0, 0x0E,
  0x06, 0x70, 0x2B, 0x09, 0x40, 0x58, 0x0B, 0x20, 0x85, 0x09, 0x90,
  // "ò" (U+00F2)
  0x20, 0x50, 0x84, 0x09, 0x78, 0xB2, 0x39, 0xA3, 0x0C, 0x03, 0xA5, 0x90, 0x3A, 0x86, 0x06, 0x87,
  0x60, 0xB2, 0x1A, 0x85, 0x10,
  // "ó" (U+00F3)
  0x30, 0x20, 0xC3, 0x08, 0x01, 0x68, 0xB2, 0x39, 0xA3, 0x0C, 0x03, 0xA5, 0x90, 0x3A, 0x86, 0x06,
  0x87, 0x60, 0xB2, 0x1A, 0x85, 0x10,
  // "ô" (U+00F4)
  0x30, 0xD0, 0x52, 0x81, 0x72, 0x86, 0x8B, 0x23, 0x9A, 0x30, 0xC0, 0x3A, 0x59, 0x03, 0xA8, 0x60,
  0x68, 0x76, 0x0B, 0x21, 0xA8, 0x51,
  // "õ" (U+00F5)
  0x00, 0x4A, 0x13, 0x00, 0x44, 0xB0, 0x00, 0x00, 0x00, 0x03, 0x9A, 0x30, 0x0C, 0x03, 0xA0, 0x59,
  0x03, 0xA0, 0x86, 0x06, 0x80, 0x76, 0x0B, 0x20, 0x1A, 0x85, 0x00,
  // "ö" (U+00F6)
  0x00, 0x73, 0x40, 0x00, 0x00, 0x03, 0x9A, 0x30, 0xC0, 0x3A, 0x59, 0x03, 0xA8, 0x60, 0x68, 0x76,
  0x0B, 0x21, 0xA8, 0x50,
  // "÷" (U+00F7)
  0x20, 0xB4, 0x01, 0x28, 0x33, 0x99, 0x92, 0x70, 0xB4, 0x01, 0x20,
  // "ø" (U+00F8)
  0x48, 0xB6, 0x30, 0x39, 0xA7, 0x0C, 0x0A, 0xA5, 0x86, 0x8A, 0x89, 0x95, 0x87, 0xD0, 0xB2, 0x5B,
  0x85, 0x03, 0x40,
  // "ù" (U+00F9)
  0x20, 0x50, 0x84, 0x09, 0x68, 0xB4, 0x2D, 0x40, 0xD0, 0xC1, 0x3B, 0x0D, 0x05, 0x82, 0xB0, 0xA5,
  0x58, 0x2D, 0x22, 0xD6, 0x99,
  // "ú" (U+00FA)
  0x30, 0x20, 0xC3, 0x08, 0x01, 0x58, 0xB4, 0x2D, 0x40, 0xD0, 0xC1, 0x3B, 0x0D, 0x05, 0x82, 0xB0,
  0xA5, 0x58, 0x2D, 0x22, 0xD6, 0x99,
  // "û" (U+00FB)
  0x00, 0x0D, 0x50, 0x07, 0x28, 0x00, 0x00, 0x02, 0xD4, 0x0D, 0x0C, 0x13, 0xB0, 0xD0, 0x58, 0x2B,
  0x0A, 0x55, 0x82, 0xD2, 0x2D, 0x69, 0x90,
  // "ü" (U+00FC)
  0x00, 0x73, 0x40, 0x00, 0x00, 0x2D, 0x40, 0xD0, 0xC1, 0x3B, 0x0D, 0x05, 0x82, 0xB0, 0xA5, 0x58,
  0x2D, 0x22, 0xD6, 0x99,
  // "ý" (U+00FD)
  0x40, 0x20, 0xC5, 0x08, 0x01, 0x73, 0x83, 0x8A, 0x07, 0x52, 0x83, 0x1D, 0x04, 0x63, 0x82, 0xD0,
  0x73, 0x38, 0x1A, 0x39, 0x48, 0x17, 0x86, 0x40, 0x40, 0xD5, 0x00, 0x54, 0x02, 0x0A, 0x38, 0x23,
  0x9A, 0x13,
  // "þ" (U+00FE)
  0x20, 0xB0, 0x94, 0x07, 0x06, 0x48, 0x29, 0x7B, 0x52, 0x82, 0xC3, 0x59, 0x28, 0x95, 0xD0, 0x59,
  0x03, 0x90, 0x85, 0x06, 0x60, 0xC2, 0x82, 0x99, 0xA3, 0x20, 0xC5, 0x0D, 0x48, 0x12, 0xE3, 0x30,
  // "ÿ" (U+00FF)
  0x48, 0x17, 0x34, 0x72, 0x83, 0x8A, 0x07, 0x52, 0x83, 0x1D, 0x04, 0x63, 0x82, 0xD0, 0x73, 0x38,
  0x1A, 0x39, 0x48, 0x17, 0x86, 0x40, 0x40, 0xD5, 0x00, 0x54, 0x02, 0x0A, 0x38, 0x23, 0x9A, 0x13,
  // "Ā" (U+0100)
  0x48, 0x19, 0xB7, 0x40, 0x70, 0x85, 0x0B, 0x0A, 0x48, 0x16, 0x6B, 0x48, 0x1A, 0x1C, 0x38, 0x25,
  0x50, 0xE3, 0x81, 0xC8, 0x89, 0x20, 0x50, 0x62, 0x87, 0xD1, 0x3D, 0x60, 0x5F, 0x70,
  // "ā" (U+0101)
  0x00, 0x9B, 0x70, 0x29, 0x99, 0x0C, 0x15, 0x84, 0x90, 0x85, 0x86, 0x0C, 0x28, 0x53, 0xE0, 0x4C,
  0x5B, 0x70,
  // "Ă" (U+0102)
  0x48, 0x14, 0x04, 0x48, 0x14, 0xC4, 0x74, 0x07, 0x08, 0x50, 0xB0, 0xA4, 0x81, 0x66, 0xB4, 0x81,
  0xA1, 0xC3, 0x82, 0x55, 0x0E, 0x38, 0x1C, 0x88, 0x92, 0x05, 0x06, 0x28, 0x7D, 0x13, 0xD6, 0x05,
  0xF7,
  // "ă" (U+0103)
  0x00, 0x40, 0x40, 0x04, 0xC4, 0x00, 0x00, 0x00, 0x29, 0x99, 0x0C, 0x15, 0x84, 0x90, 0x85, 0x86,
  0x0C, 0x28, 0x53, 0xE0, 0x4C, 0x5B, 0x70,
  // "Ą" (U+0104)
  0x40, 0x70, 0x85, 0x0B, 0x0A, 0x48, 0x16, 0x6B, 0x48, 0x1A, 0x1C, 0x38, 0x25, 0x50, 0xE3, 0x81,
  0xC8, 0x89, 0x20, 0x50, 0x62, 0x87, 0xD1, 0x3D, 0x60, 0x5F, 0x75, 0x05, 0x50, 0x05, 0x58, 0x12,
  0xA2,
  // "ą" (U+0105)
  0x02, 0x99, 0x90, 0xC1, 0x58, 0x49, 0x08, 0x58, 0x60, 0xC2, 0x85, 0x3E, 0x04, 0xC5, 0xB7, 0x00,
  0x05, 0x00, 0x05, 0x50, 0x00, 0x2A, 0x20,
  // "Ć" (U+0106)
  0x40, 0x20, 0xC4, 0x08, 0x01, 0x71, 0x89, 0x35, 0x9B, 0x70, 0x4A, 0x02, 0xA0, 0xC2, 0x30, 0x30,
  0xC4, 0x06, 0x09, 0x40, 0x60, 0x84, 0x03, 0x0C, 0x20, 0x32, 0x82, 0x8B, 0xA4, 0x10,
  // "ć" (U+0107)
  0x30, 0x20, 0xC3, 0x08, 0x01, 0x68, 0x91, 0x29, 0xC3, 0x0C, 0x05, 0x25, 0x93, 0x08, 0x06, 0x38,
  0x77, 0x70, 0x10, 0x1B, 0x93, 0x10,
  // "Ĉ" (U+0108)
  0x40, 0xD0, 0x53, 0x81, 0x72, 0x87, 0x18, 0x93, 0x59, 0xB7, 0x04, 0xA0, 0x2A, 0x0C, 0x23, 0x03,
  0x0C, 0x40, 0x60, 0x94, 0x06, 0x08, 0x40, 0x30, 0xC2, 0x03, 0x28, 0x28, 0xBA, 0x41,
  // "ĉ" (U+0109)
  0x30, 0xD0, 0x52, 0x81, 0x72, 0x86, 0x89, 0x12, 0x9C, 0x30, 0xC0, 0x52, 0x59, 0x30, 0x80, 0x63,
  0x87, 0x77, 0x01, 0x01, 0xB9, 0x31,
  // "Ċ" (U+010A)
  0x40, 0x60, 0x37, 0x18, 0x93, 0x59, 0xB7, 0x04, 0xA0, 0x2A, 0x0C, 0x23, 0x03, 0x0C, 0x40, 0x60,
  0x94, 0x06, 0x08, 0x40, 0x30, 0xC2, 0x03, 0x28, 0x28, 0xBA, 0x41,
  // "ċ" (U+010B)
  0x30, 0x60, 0x36, 0x89, 0x12, 0x9C, 0x30, 0xC0, 0x52, 0x59, 0x30, 0x80, 0x63, 0x87, 0x77, 0x01,
  0x01, 0xB9, 0x31,
  // "Č" (U+010C)
  0x38, 0x16, 0x39, 0x38, 0x12, 0xE2, 0x71, 0x89, 0x35, 0x9B, 0x70, 0x4A, 0x02, 0xA0, 0xC2, 0x30,
  0x30, 0xC4, 0x06, 0x09, 0x40, 0x60, 0x84, 0x03, 0x0C, 0x20, 0x32, 0x82, 0x8B, 0xA4, 0x10,
  // "č" (U+010D)
  0x00, 0x63, 0x90, 0x02, 0xE2, 0x00, 0x00, 0x00, 0x29, 0xC3, 0x0C, 0x05, 0x25, 0x90, 0x00, 0x86,
  0x00, 0x07, 0x70, 0x10, 0x1B, 0x93, 0x00,
  // "Ď" (U+010E)
  0x38, 0x16, 0x39, 0x48, 0x12, 0xE2, 0x72, 0x83, 0x6E, 0x79, 0x42, 0x83, 0x2C, 0x01, 0xD2, 0x05,
  0x09, 0x28, 0x3D, 0x20, 0x86, 0x28, 0x3D, 0x10, 0xB3, 0x20, 0xE2, 0x0D, 0x28, 0x35, 0xA0, 0x1D,
  0x28, 0x6C, 0x30, 0xAD, 0x8B, 0x42,
  // "ď" (U+010F)
  0x00, 0x03, 0xE5, 0x80, 0x00, 0x0D, 0x30, 0x02, 0x99, 0xC0, 0x00, 0xC1, 0x59, 0x00, 0x49, 0x08,
  0x60, 0x08, 0x60, 0xC2, 0x00, 0x85, 0x3E, 0x00, 0x04, 0xC5, 0xB7, 0x00,
  // "Đ" (U+0110)
  0x06, 0xE7, 0x94, 0x00, 0x2B, 0x01, 0xD0, 0x05, 0x80, 0x0D, 0x23, 0xCB, 0x60, 0xD1, 0x0B, 0x20,
  0x0E, 0x00, 0xE0, 0x05, 0xA0, 0x1D, 0x00, 0xC3, 0x0A, 0xD8, 0xB4, 0x00,
  // "đ" (U+0111)
  0x00, 0x03, 0xE3, 0x00, 0x27, 0xE6, 0x03, 0xA9, 0xC0, 0x0C, 0x05, 0x90, 0x59, 0x08, 0x60, 0x86,
  0x0C, 0x20, 0x85, 0x3E, 0x00, 0x4C, 0x5B, 0x70,
  // "Ē" (U+0112)
  0x00, 0x9B, 0x70, 0x06, 0xE6, 0x89, 0x02, 0xB0, 0x05, 0x05, 0x80, 0x00, 0x08, 0xA8, 0x30, 0x0B,
  0x20, 0x00, 0x0D, 0x00, 0x00, 0x1D, 0x00, 0x80, 0xAD, 0x68, 0x90,
  // "ē" (U+0113)
  0x00, 0x9B, 0x70, 0x29, 0xC1, 0x0C, 0x0B, 0x35, 0xA2, 0xC0, 0x8B, 0x81, 0x07, 0x70, 0x10, 0x1B,
  0x94, 0x00,
  // "Ĕ" (U+0114)
  0x28, 0x14, 0x04, 0x38, 0x14, 0xC4, 0x71, 0x86, 0x6E, 0x68, 0x90, 0x2B, 0x28, 0x25, 0x05, 0x84,
  0x82, 0x8A, 0x83, 0x20, 0xB0, 0x24, 0x0D, 0x40, 0x10, 0xD2, 0x85, 0x80, 0xAD, 0x68, 0x91,
  // "ĕ" (U+0115)
  0x00, 0x40, 0x40, 0x04, 0xC4, 0x00, 0x00, 0x00, 0x29, 0xC1, 0x0C, 0x0B, 0x35, 0xA2, 0xC0, 0x8B,
  0x81, 0x07, 0x70, 0x10, 0x1B, 0x94, 0x00,
  // "Ė" (U+0116)
  0x30, 0x60, 0x37, 0x18, 0x66, 0xE6, 0x89, 0x02, 0xB2, 0x82, 0x50, 0x58, 0x48, 0x28, 0xA8, 0x32,
  0x0B, 0x02, 0x40, 0xD4, 0x01, 0x0D, 0x28, 0x58, 0x0A, 0xD6, 0x89, 0x10,
  // "ė" (U+0117)
  0x20, 0x60, 0x37, 0x8B, 0x22, 0x9C, 0x10, 0xC0, 0xB3, 0x5A, 0x2C, 0x08, 0xB8, 0x10, 0x77, 0x01,
  0x01, 0xB9, 0x41,
  // "Ę" (U+0118)
  0x18, 0x66, 0xE6, 0x89, 0x02, 0xB2, 0x82, 0x50, 0x58, 0x48, 0x28, 0xA8, 0x32, 0x0B, 0x02, 0x40,
  0xD4, 0x01, 0x0D, 0x28, 0x58, 0x0A, 0xD6, 0x89, 0x40, 0x54, 0x00, 0x54, 0x81, 0x2A, 0x21,
  // "ę" (U+0119)
  0x02, 0x9C, 0x10, 0xC0, 0xB3, 0x5A, 0x2C, 0x08, 0xB8, 0x10, 0x77, 0x01, 0x01, 0xB9, 0x40, 0x00,
  0x50, 0x00, 0x55, 0x00, 0x02, 0xA2, 0x00,
  // "Ě" (U+011A)
  0x28, 0x16, 0x39, 0x38, 0x12, 0xE2, 0x71, 0x86, 0x6E, 0x68, 0x90, 0x2B, 0x28, 0x25, 0x05, 0x84,
  0x82, 0x8A, 0x83, 0x20, 0xB0, 0x24, 0x0D, 0x40, 0x10, 0xD2, 0x85, 0x80, 0xAD, 0x68, 0x91,
  // "ě" (U+011B)
  0x00, 0x63, 0x90, 0x02, 0xE2, 0x00, 0x00, 0x00, 0x29, 0xC1, 0x0C, 0x0B, 0x35, 0xA2, 0xC0, 0x8B,
  0x81, 0x07, 0x70, 0x10, 0x1B, 0x94, 0x00,
  // "Ĝ" (U+011C)
  0x40, 0xD0, 0x54, 0x81, 0x72, 0x87, 0x38, 0x25, 0x99, 0xB2, 0x05, 0x0A, 0x28, 0x3B, 0x10, 0xD2,
  0x40, 0x30, 0xC5, 0x87, 0x6A, 0x01, 0xAA, 0x16, 0x82, 0x83, 0xA5, 0x03, 0xB2, 0x0C, 0x01, 0x28,
  0x27, 0x98, 0xA2,
  // "ĝ" (U+011D)
  0x40, 0xD0, 0x54, 0x81, 0x72, 0x87, 0x38, 0x31, 0x8A, 0x72, 0x28, 0x2A, 0x18, 0x43, 0x82, 0xC0,
  0x93, 0x38, 0x1C, 0x0B, 0x48, 0x1A, 0x92, 0x38, 0x13, 0x93, 0x48, 0x26, 0x8A, 0xB2, 0x04, 0x07,
  0x20, 0xC2, 0x83, 0x1A, 0x89, 0x32,
  // "Ğ" (U+011E)
  0x38, 0x14, 0x04, 0x48, 0x14, 0xC4, 0x73, 0x82, 0x59, 0x9B, 0x20, 0x50, 0xA2, 0x83, 0xB1, 0x0D,
  0x24, 0x03, 0x0C, 0x58, 0x76, 0xA0, 0x1A, 0xA1, 0x68, 0x28, 0x3A, 0x50, 0x3B, 0x20, 0xC0, 0x12,
  0x82, 0x79, 0x8A, 0x20,
  // "ğ" (U+011F)
  0x38, 0x14, 0x04, 0x48, 0x14, 0xC4, 0x73, 0x83, 0x18, 0xA7, 0x22, 0x82, 0xA1, 0x84, 0x38, 0x2C,
  0x09, 0x33, 0x81, 0xC0, 0xB4, 0x81, 0xA9, 0x23, 0x81, 0x39, 0x34, 0x82, 0x68, 0xAB, 0x20, 0x40,
  0x72, 0x0C, 0x28, 0x31, 0xA8, 0x93, 0x20,
  // "Ġ" (U+0120)
  0x40, 0x60, 0x37, 0x38, 0x25, 0x99, 0xB2, 0x05, 0x0A, 0x28, 0x3B, 0x10, 0xD2, 0x40, 0x30, 0xC5,
  0x87, 0x6A, 0x01, 0xAA, 0x16, 0x82, 0x83, 0xA5, 0x03, 0xB2, 0x0C, 0x01, 0x28, 0x27, 0x98, 0xA2,
  // "ġ" (U+0121)
  0x40, 0x60, 0x37, 0x38, 0x31, 0x8A, 0x72, 0x28, 0x2A, 0x18, 0x43, 0x82, 0xC0, 0x93, 0x38, 0x1C,
  0x0B, 0x48, 0x1A, 0x92, 0x38, 0x13, 0x93, 0x48, 0x26, 0x8A, 0xB2, 0x04, 0x07, 0x20, 0xC2, 0x83,
  0x1A, 0x89, 0x32,
  // "Ģ" (U+0122)
  0x28, 0x25, 0x99, 0xB2, 0x05, 0x0A, 0x28, 0x3B, 0x10, 0xD2, 0x40, 0x30, 0xC5, 0x87, 0x6A, 0x01,
  0xAA, 0x16, 0x82, 0x83, 0xA5, 0x03, 0xB2, 0x0C, 0x01, 0x28, 0x27, 0x98, 0xA4, 0x0A, 0x01, 0x50,
  0x74,
  // "ģ" (U+0123)
  0x40, 0x70, 0x14, 0x01, 0x09, 0x48, 0x31, 0x8A, 0x72, 0x28, 0x2A, 0x18, 0x43, 0x82, 0xC0, 0x93,
  0x38, 0x1C, 0x0B, 0x48, 0x1A, 0x92, 0x38, 0x13, 0x93, 0x48, 0x26, 0x8A, 0xB2, 0x04, 0x07, 0x20,
  0xC2, 0x83, 0x1A, 0x89, 0x32,
  // "Ĥ" (U+0124)
  0x40, 0xD0, 0x55, 0x81, 0x72, 0x87, 0x48, 0x90, 0x6F, 0x60, 0xBD, 0x30, 0x2C, 0x20, 0x80, 0x72,
  0x05, 0x08, 0x20, 0xB0, 0x42, 0x84, 0x8B, 0x88, 0xF1, 0x28, 0x3B, 0x20, 0x1D, 0x30, 0xD2, 0x04,
  0x0A, 0x20, 0x10, 0xD2, 0x06, 0x08, 0x28, 0x4A, 0xE3, 0x3D, 0xB2,
  // "ĥ" (U+0125)
  0x30, 0xD0, 0x52, 0x81, 0x72, 0x86, 0x08, 0x0C, 0x30, 0x40, 0x83, 0x8B, 0x37, 0x8A, 0x70, 0xB6,
  0x3A, 0x0D, 0x06, 0x81, 0xB0, 0x85, 0x58, 0x0B, 0x28, 0x50, 0x9A,
  // "Ħ" (U+0126)
  0x06, 0xF7, 0x0B, 0xD3, 0x01, 0xC0, 0x07, 0x70, 0x0A, 0xC7, 0x7D, 0x91, 0x07, 0xA7, 0x7E, 0x10,
  0x0A, 0x20, 0x1E, 0x00, 0x0D, 0x00, 0x4B, 0x00, 0x1D, 0x00, 0x78, 0x00, 0xAE, 0x33, 0xDB, 0x00,
  // "ħ" (U+0127)
  0x09, 0xB0, 0x01, 0xAB, 0x70, 0x08, 0x8B, 0x60, 0xB5, 0x49, 0x0D, 0x07, 0x72, 0xA0, 0x94, 0x57,
  0x0B, 0x28, 0x50, 0x99,
  // "Ĩ" (U+0128)
  0x18, 0x64, 0xA1, 0x30, 0x44, 0xB7, 0x81, 0x6F, 0x72, 0x02, 0x0C, 0x30, 0x50, 0x93, 0x08, 0x06,
  0x30, 0xB0, 0x33, 0x0D, 0x01, 0x20, 0x10, 0xD3, 0x81, 0xAE, 0x32,
  // "ĩ" (U+0129)
  0x4A, 0x13, 0x44, 0xB0, 0x00, 0x00, 0x2D, 0x40, 0x0C, 0x10, 0x0D, 0x00, 0x2B, 0x00, 0x58, 0x00,
  0x3C, 0x30,
  // "Ī" (U+012A)
  0x09, 0xB7, 0x06, 0xF7, 0x02, 0xC0, 0x05, 0x90, 0x08, 0x60, 0x0B, 0x30, 0x0D, 0x10, 0x1D, 0x00,
  0xAE, 0x30,
  // "ī" (U+012B)
  0x09, 0xB7, 0x2D, 0x40, 0x0C, 0x10, 0x0D, 0x00, 0x2B, 0x00, 0x58, 0x00, 0x3C, 0x30,
  // "Ĭ" (U+012C)
  0x04, 0x04, 0x04, 0xC4, 0x00, 0x00, 0x06, 0xF7, 0x02, 0xC0, 0x05, 0x90, 0x08, 0x60, 0x0B, 0x30,
  0x0D, 0x10, 0x1D, 0x00, 0xAE, 0x30,
  // "ĭ" (U+012D)
  0x40, 0x44, 0xC4, 0x00, 0x02, 0xD4, 0x0C, 0x10, 0xD0, 0x2B, 0x05, 0x80, 0x3C, 0x30,
  // "Į" (U+012E)
  0x06, 0xF7, 0x02, 0xC0, 0x05, 0x90, 0x08, 0x60, 0x0B, 0x30, 0x0D, 0x10, 0x1D, 0x00, 0xAE, 0x30,
  0x05, 0x00, 0x55, 0x00, 0x2A, 0x20,
  // "į" (U+012F)
  0x00, 0x49, 0x00, 0x01, 0x02, 0xD4, 0x00, 0xC1, 0x00, 0xD0, 0x02, 0xB0, 0x05, 0x90, 0x03, 0xC3,
  0x05, 0x00, 0x55, 0x00, 0x2A, 0x20,
  // "İ" (U+0130)
  0x00, 0x63, 0x00, 0x00, 0x06, 0xF7, 0x02, 0xC0, 0x05, 0x90, 0x08, 0x60, 0x0B, 0x30, 0x0D, 0x10,
  0x1D, 0x00, 0xAE, 0x30,
  // "ı" (U+0131)
  0x2D, 0x40, 0xC1, 0x0D, 0x02, 0xB0, 0x58, 0x03, 0xC3,
  // "Ĳ" (U+0132)
  0x06, 0xF7, 0x6F, 0x60, 0x2C, 0x02, 0xC0, 0x05, 0x90, 0x59, 0x00, 0x86, 0x08, 0x60, 0x0B, 0x30,
  0xB3, 0x00, 0xD1, 0x0D, 0x00, 0x1D, 0x01, 0xD0, 0x0A, 0xE3, 0x4A, 0x00, 0x00, 0x07, 0x70, 0x00,
  0x00, 0xB2, 0x00, 0x02, 0x87, 0x00, 0x00,
  // "ĳ" (U+0133)
  0x04, 0x90, 0x39, 0x00, 0x10, 0x01, 0x2D, 0x41, 0xD4, 0x0C, 0x10, 0xC2, 0x0D, 0x00, 0xD0, 0x2B,
  0x02, 0xB0, 0x59, 0x04, 0x90, 0x3C, 0x37, 0x60, 0x00, 0x0A, 0x30, 0x00, 0x0C, 0x00, 0x01, 0x95,
  0x00,
  // "Ĵ" (U+0134)
  0x40, 0xD0, 0x53, 0x81, 0x72, 0x87, 0x28, 0x16, 0xF6, 0x30, 0x20, 0xC4, 0x05, 0x09, 0x40, 0x80,
  0x64, 0x0B, 0x03, 0x40, 0xD4, 0x01, 0x0D, 0x40, 0x40, 0xA4, 0x00, 0x74, 0x0B, 0x02, 0x28, 0x12,
  0x87, 0x30,
  // "ĵ" (U+0135)
  0x30, 0xD0, 0x52, 0x81, 0x72, 0x87, 0x81, 0x1D, 0x43, 0x0C, 0x02, 0x30, 0xD3, 0x02, 0x0B, 0x30,
  0x40, 0x93, 0x07, 0x06, 0x30, 0xA0, 0x33, 0x0C, 0x28, 0x11, 0x95, 0x20,
  // "Ķ" (U+0136)
  0x06, 0xF7, 0x1E, 0x60, 0x2C, 0x05, 0x60, 0x05, 0x92, 0x70, 0x00, 0x88, 0xB0, 0x00, 0x0B, 0xAE,
  0x10, 0x00, 0xD1, 0x95, 0x00, 0x1D, 0x05, 0xA0, 0x0A, 0xE3, 0x0C, 0x40, 0x00, 0xA1, 0x00, 0x00,
  0x07, 0x00, 0x00,
  // "ķ" (U+0137)
  0x08, 0xC0, 0x00, 0x05, 0x80, 0x00, 0x08, 0x56, 0xC2, 0x0B, 0x28, 0x10, 0x0D, 0x93, 0x00, 0x1D,
  0x97, 0x00, 0x58, 0x2C, 0x00, 0x85, 0x0A, 0x50, 0x0A, 0x10, 0x00, 0x07, 0x00, 0x00,
  // "ĸ" (U+0138)
  0x2D, 0x46, 0xC2, 0x0C, 0x18, 0x00, 0x0D, 0xA3, 0x00, 0x2D, 0x96, 0x00, 0x58, 0x3B, 0x00, 0x85,
  0x0B, 0x50,
  // "Ĺ" (U+0139)
  0x20, 0x20, 0xC3, 0x08, 0x01, 0x78, 0x16, 0xF7, 0x20, 0x20, 0xC3, 0x05, 0x09, 0x30, 0x80, 0x63,
  0x0B, 0x03, 0x38, 0x4D, 0x10, 0x21, 0xD2, 0x84, 0x8A, 0xD6, 0x79,
  // "ĺ" (U+013A)
  0x00, 0x2C, 0x00, 0x81, 0x00, 0x00, 0x09, 0xB0, 0x05, 0x80, 0x08, 0x50, 0x0B, 0x20, 0x0D, 0x00,
  0x2B, 0x00, 0x48, 0x00, 0x3C, 0x30,
  // "Ļ" (U+013B)
  0x06, 0xF7, 0x00, 0x2C, 0x00, 0x05, 0x90, 0x00, 0x86, 0x00, 0x0B, 0x30, 0x00, 0xD1, 0x02, 0x1D,
  0x00, 0x8A, 0xD6, 0x79, 0x0A, 0x10, 0x00, 0x70, 0x00,
  // "ļ" (U+013C)
  0x09, 0xB0, 0x58, 0x08, 0x50, 0xB2, 0x0D, 0x02, 0xB0, 0x48, 0x03, 0xC3, 0xA1, 0x07, 0x00,
  // "Ľ" (U+013D)
  0x06, 0xF7, 0x82, 0x02, 0xC0, 0x50, 0x05, 0x90, 0x00, 0x08, 0x60, 0x00, 0x0B, 0x30, 0x00, 0x0D,
  0x10, 0x20, 0x1D, 0x00, 0x80, 0xAD, 0x67, 0x90,
  // "ľ" (U+013E)
  0x09, 0xB8, 0x20, 0x58, 0x40, 0x08, 0x50, 0x00, 0xB2, 0x00, 0x0D, 0x00, 0x02, 0xB0, 0x00, 0x48,
  0x00, 0x03, 0xC3, 0x00,
  // "Ŀ" (U+013F)
  0x06, 0xF7, 0x00, 0x02, 0xC0, 0x00, 0x05, 0x90, 0x00, 0x08, 0x60, 0x63, 0x0B, 0x30, 0x00, 0x0D,
  0x10, 0x20, 0x1D, 0x00, 0x80, 0xAD, 0x67, 0x90,
  // "ŀ" (U+0140)
  0x09, 0xB0, 0x05, 0x80, 0x08, 0x50, 0x0B, 0x83, 0x0D, 0x00, 0x2B, 0x00, 0x48, 0x00, 0x3C, 0x30,
  // "Ł" (U+0141)
  0x06, 0xF7, 0x00, 0x2C, 0x00, 0x05, 0x91, 0x00, 0x7C, 0x60, 0x4D, 0x40, 0x01, 0xD1, 0x02, 0x1D,
  0x00, 0x8A, 0xD6, 0x79,
  // "ł" (U+0142)
  0x09, 0xB0, 0x58, 0x08, 0x50, 0xB6, 0x4D, 0x35, 0xB0, 0x48, 0x03, 0xC3,
  // "Ń" (U+0143)
  0x40, 0x20, 0xC6, 0x08, 0x01, 0x74, 0x89, 0x46, 0xF1, 0x07, 0xC2, 0x02, 0xD6, 0x04, 0x42, 0x84,
  0x56, 0xA0, 0x61, 0x28, 0x37, 0x0D, 0x08, 0x38, 0x38, 0x09, 0x48, 0x38, 0x38, 0x04, 0x97, 0x20,
  0x10, 0x72, 0x0E, 0x05, 0x20, 0x0A, 0x20, 0xA0, 0x22,
  // "ń" (U+0144)
  0x30, 0x20, 0xC3, 0x08, 0x01, 0x58, 0xB4, 0x2E, 0x7A, 0x70, 0xC6, 0x3A, 0x0E, 0x06, 0x72, 0xB0,
  0x94, 0x58, 0x0B, 0x28, 0x50, 0x99,
  // "Ņ" (U+0145)
  0x06, 0xF1, 0x07, 0xC2, 0x02, 0xD6, 0x04, 0x40, 0x05, 0x6A, 0x06, 0x10, 0x07, 0x0D, 0x08, 0x00,
  0x08, 0x09, 0x48, 0x00, 0x08, 0x04, 0x97, 0x00, 0x17, 0x00, 0xE5, 0x00, 0xAA, 0x00, 0xA2, 0x00,
  0x00, 0xA1, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
  // "ņ" (U+0146)
  0x2E, 0x7A, 0x70, 0xC6, 0x3A, 0x0E, 0x06, 0x72, 0xB0, 0x94, 0x58, 0x0B, 0x28, 0x50, 0x99, 0x0A,
  0x10, 0x00, 0x70, 0x00,
  // "Ň" (U+0147)
  0x38, 0x16, 0x39, 0x58, 0x12, 0xE2, 0x74, 0x89, 0x46, 0xF1, 0x07, 0xC2, 0x02, 0xD6, 0x04, 0x42,
  0x84, 0x56, 0xA0, 0x61, 0x28, 0x37, 0x0D, 0x08, 0x38, 0x38, 0x09, 0x48, 0x38, 0x38, 0x04, 0x97,
  0x20, 0x10, 0x72, 0x0E, 0x05, 0x20, 0x0A, 0x20, 0xA0, 0x22,
  // "ň" (U+0148)
  0x00, 0x63, 0x90, 0x02, 0xE2, 0x00, 0x00, 0x02, 0xE7, 0xA7, 0x0C, 0x63, 0xA0, 0xE0, 0x67, 0x2B,
  0x09, 0x45, 0x80, 0xB2, 0x85, 0x09, 0x90,
  // "ŉ" (U+0149)
  0x85, 0x00, 0x04, 0x50, 0x00, 0x8E, 0x7A, 0x70, 0xC6, 0x3A, 0x0E, 0x06, 0x72, 0xB0, 0x94, 0x58,
  0x0B, 0x28, 0x50, 0x99,
  // "Ŋ" (U+014A)
  0x18, 0x94, 0x6F, 0x10, 0x7C, 0x20, 0x2D, 0x60, 0x34, 0x28, 0x45, 0x6A, 0x06, 0x12, 0x83, 0x70,
  0xD0, 0x83, 0x83, 0x80, 0x94, 0x83, 0x83, 0x80, 0x49, 0x82, 0x01, 0x07, 0x20, 0xE0, 0x52, 0x00,
  0xA2, 0x0A, 0x03, 0x60, 0x87, 0x09, 0x58, 0x14, 0x92, 0x30,
  // "ŋ" (U+014B)
  0x2E, 0x7B, 0x70, 0xC6, 0x3A, 0x0E, 0x05, 0x82, 0xB0, 0x85, 0x58, 0x0B, 0x28, 0x50, 0xD0, 0x00,
  0x1C, 0x00, 0x05, 0x80, 0x05, 0xA1, 0x00,
  // "Ō" (U+014C)
  0x00, 0x09, 0xB7, 0x00, 0x05, 0x9A, 0x60, 0x04, 0xA0, 0x0D, 0x10, 0xD2, 0x00, 0xB4, 0x3C, 0x00,
  0x0B, 0x46, 0x90, 0x00, 0xE1, 0x68, 0x00, 0x4B, 0x03, 0xB0, 0x0B, 0x30, 0x08, 0x99, 0x40, 0x00,
  // "ō" (U+014D)
  0x00, 0x9B, 0x70, 0x39, 0xA3, 0x0C, 0x03, 0xA5, 0x90, 0x3A, 0x86, 0x06, 0x87, 0x60, 0xB2, 0x1A,
  0x85, 0x00,
  // "Ŏ" (U+014E)
  0x38, 0x14, 0x04, 0x48, 0x14, 0xC4, 0x73, 0x82, 0x59, 0xA6, 0x20, 0x40, 0xA2, 0x83, 0xD1, 0x0D,
  0x22, 0x82, 0xB4, 0x3C, 0x38, 0x2B, 0x46, 0x93, 0x82, 0xE1, 0x68, 0x28, 0x34, 0xB0, 0x3B, 0x20,
  0xB0, 0x32, 0x82, 0x89, 0x94, 0x20,
  // "ŏ" (U+014F)
  0x00, 0x40, 0x40, 0x04, 0xC4, 0x00, 0x00, 0x00, 0x39, 0xA3, 0x0C, 0x03, 0xA5, 0x90, 0x3A, 0x86,
  0x06, 0x87, 0x60, 0xB2, 0x1A, 0x85, 0x00,
  // "Ő" (U+0150)
  0x38, 0x21, 0xA7, 0x43, 0x81, 0x83, 0x87, 0x38, 0x25, 0x9A, 0x62, 0x04, 0x0A, 0x28, 0x3D, 0x10,
  0xD2, 0x28, 0x2B, 0x43, 0xC3, 0x82, 0xB4, 0x69, 0x38, 0x2E, 0x16, 0x82, 0x83, 0x4B, 0x03, 0xB2,
  0x0B, 0x03, 0x28, 0x28, 0x99, 0x42,
  // "ő" (U+0151)
  0x00, 0x1A, 0x74, 0x00, 0x83, 0x80, 0x00, 0x00, 0x00, 0x03, 0x9A, 0x30, 0x0C, 0x03, 0xA0, 0x59,
  0x03, 0xA0, 0x86, 0x06, 0x80, 0x76, 0x0B, 0x20, 0x1A, 0x85, 0x00,
  // "Œ" (U+0152)
  0x00, 0x5A, 0xAE, 0x9B, 0x80, 0x4A, 0x02, 0xB0, 0x15, 0x0D, 0x20, 0x58, 0x00, 0x03, 0xC0, 0x08,
  0xA8, 0x30, 0x69, 0x00, 0xB2, 0x00, 0x06, 0x80, 0x0E, 0x00, 0x00, 0x3B, 0x02, 0xC0, 0x08, 0x00,
  0x89, 0xBD, 0x8A, 0x80,
  // "œ" (U+0153)
  0x03, 0x9A, 0x38, 0xB3, 0x0C, 0x04, 0xF2, 0x86, 0x59, 0x04, 0xC0, 0xC1, 0x86, 0x06, 0xC9, 0x30,
  0x76, 0x0B, 0x90, 0x00, 0x1A, 0x86, 0xA9, 0x60,
  // "Ŕ" (U+0154)
  0x30, 0x20, 0xC4, 0x08, 0x01, 0x71, 0x8B, 0x26, 0xE7, 0xA2, 0x02, 0xC0, 0x78, 0x05, 0x90, 0x78,
  0x08, 0x70, 0xB3, 0x0A, 0xAD, 0x42, 0x89, 0x7D, 0x1C, 0x20, 0x1D, 0x08, 0x60, 0xAE, 0x43, 0xC1,
  // "ŕ" (U+0155)
  0x20, 0x20, 0xC3, 0x08, 0x01, 0x68, 0x93, 0x2E, 0x6C, 0x30, 0xC6, 0x31, 0x0E, 0x12, 0x02, 0x0B,
  0x30, 0x50, 0x83, 0x08, 0x05, 0x30,
  // "Ŗ" (U+0156)
  0x06, 0xE7, 0xA2, 0x02, 0xC0, 0x78, 0x05, 0x90, 0x78, 0x08, 0x70, 0xB3, 0x0A, 0xAD, 0x40, 0x0D,
  0x1C, 0x20, 0x1D, 0x08, 0x60, 0xAE, 0x43, 0xC1, 0x00, 0xA1, 0x00, 0x00, 0x70, 0x00,
  // "ŗ" (U+0157)
  0x2E, 0x6C, 0x30, 0xC6, 0x31, 0x0E, 0x10, 0x02, 0xB0, 0x00, 0x58, 0x00, 0x08, 0x50, 0x00, 0xA1,
  0x00, 0x07, 0x00, 0x00,
  // "Ř" (U+0158)
  0x00, 0x63, 0x90, 0x00, 0x2E, 0x20, 0x00, 0x00, 0x00, 0x06, 0xE7, 0xA2, 0x02, 0xC0, 0x78, 0x05,
  0x90, 0x78, 0x08, 0x70, 0xB3, 0x0A, 0xAD, 0x40, 0x0D, 0x1C, 0x20, 0x1D, 0x08, 0x60, 0xAE, 0x43,
  0xC1,
  // "ř" (U+0159)
  0x06, 0x39, 0x00, 0x2E, 0x20, 0x00, 0x00, 0x02, 0xE6, 0xC3, 0x0C, 0x63, 0x10, 0xE1, 0x00, 0x2B,
  0x00, 0x05, 0x80, 0x00, 0x85, 0x00, 0x00,
  // "Ś" (U+015A)
  0x00, 0x02, 0xC0, 0x00, 0x81, 0x00, 0x00, 0x00, 0x19, 0x99, 0x0A, 0x20, 0x90, 0xC3, 0x00, 0x06,
  0xD2, 0x00, 0x07, 0xE1, 0x20, 0x0A, 0x4B, 0x00, 0xA2, 0x5A, 0x87, 0x00,
  // "ś" (U+015B)
  0x00, 0x2C, 0x00, 0x81, 0x00, 0x00, 0x08, 0x89, 0x1B, 0x06, 0x0D, 0x70, 0x01, 0xC5, 0x80, 0x57,
  0x79, 0x91,
  // "Ŝ" (U+015C)
  0x00, 0x0D, 0x50, 0x07, 0x28, 0x00, 0x00, 0x00, 0x19, 0x99, 0x0A, 0x20, 0x90, 0xC3, 0x00, 0x06,
  0xD2, 0x00, 0x07, 0xE1, 0x20, 0x0A, 0x4B, 0x00, 0xA2, 0x5A, 0x87, 0x00,
  // "ŝ" (U+015D)
  0x00, 0xD5, 0x07, 0x28, 0x00, 0x00, 0x08, 0x89, 0x1B, 0x06, 0x0D, 0x70, 0x01, 0xC5, 0x80, 0x57,
  0x79, 0x91,
  // "Ş" (U+015E)
  0x01, 0x99, 0x90, 0xA2, 0x09, 0x0C, 0x30, 0x00, 0x6D, 0x20, 0x00, 0x7E, 0x12, 0x00, 0xA4, 0xB0,
  0x0A, 0x25, 0xA8, 0x70, 0x05, 0x00, 0x00, 0x93, 0x00, 0x69, 0x00, 0x00,
  // "ş" (U+015F)
  0x08, 0x89, 0x1B, 0x06, 0x0D, 0x70, 0x01, 0xC5, 0x80, 0x57, 0x79, 0x91, 0x05, 0x00, 0x09, 0x30,
  0x69, 0x00,
  // "Š" (U+0160)
  0x00, 0x63, 0x90, 0x02, 0xE2, 0x00, 0x00, 0x00, 0x19, 0x99, 0x0A, 0x20, 0x90, 0xC3, 0x00, 0x06,
  0xD2, 0x00, 0x07, 0xE1, 0x20, 0x0A, 0x4B, 0x00, 0xA2, 0x5A, 0x87, 0x00,
  // "š" (U+0161)
  0x06, 0x39, 0x02, 0xE2, 0x00, 0x00, 0x08, 0x89, 0x1B, 0x06, 0x0D, 0x70, 0x01, 0xC5, 0x80, 0x57,
  0x79, 0x91,
  // "Ţ" (U+0162)
  0x18, 0x92, 0xC8, 0xF8, 0xD1, 0x16, 0x1D, 0x07, 0x30, 0x40, 0xA5, 0x00, 0x75, 0x09, 0x04, 0x50,
  0xC0, 0x15, 0x0E, 0x58, 0x19, 0xE4, 0x50, 0x56, 0x09, 0x03, 0x40, 0x60, 0x94,
  // "ţ" (U+0163)
  0x00, 0x30, 0x05, 0x70, 0x2D, 0xB3, 0x0C, 0x10, 0x0D, 0x00, 0x2B, 0x00, 0x59, 0x00, 0x2C, 0x60,
  0x05, 0x00, 0x09, 0x30, 0x69, 0x00,
  // "Ť" (U+0164)
  0x28, 0x16, 0x39, 0x48, 0x12, 0xE2, 0x73, 0x89, 0x2C, 0x8F, 0x8D, 0x11, 0x61, 0xD0, 0x73, 0x04,
  0x0A, 0x50, 0x07, 0x50, 0x90, 0x45, 0x0C, 0x01, 0x50, 0xE5, 0x81, 0x9E, 0x43,
  // "ť" (U+0165)
  0x00, 0x08, 0x20, 0x47, 0x20, 0x2D, 0xB3, 0x00, 0xC1, 0x00, 0x0D, 0x00, 0x02, 0xB0, 0x00, 0x59,
  0x00, 0x02, 0xC6, 0x00,
  // "Ŧ" (U+0166)
  0x18, 0x92, 0xC8, 0xF8, 0xD1, 0x17, 0x1D, 0x08, 0x38, 0x23, 0xB0, 0x13, 0x06, 0x08, 0x48, 0x28,
  0xCB, 0x74, 0x0B, 0x02, 0x50, 0xE5, 0x81, 0x9E, 0x43,
  // "ŧ" (U+0167)
  0x00, 0x30, 0x05, 0x70, 0x2D, 0xB3, 0x0C, 0x10, 0x4E, 0x70, 0x2B, 0x00, 0x49, 0x00, 0x2C, 0x60,
  // "Ũ" (U+0168)
  0x38, 0x24, 0xA1, 0x33, 0x81, 0x44, 0xB7, 0x28, 0x78, 0xE5, 0x0B, 0x90, 0x49, 0x20, 0x82, 0x07,
  0x06, 0x20, 0x82, 0x0A, 0x03, 0x20, 0x82, 0x86, 0xD1, 0x01, 0x60, 0x1D, 0x28, 0x34, 0x30, 0x1D,
  0x20, 0x93, 0x82, 0x8A, 0x94, 0x20,
  // "ũ" (U+0169)
  0x00, 0x4A, 0x13, 0x00, 0x44, 0xB0, 0x00, 0x00, 0x00, 0x2D, 0x40, 0xD0, 0x0C, 0x13, 0xB0, 0x0D,
  0x05, 0x80, 0x2B, 0x0A, 0x50, 0x58, 0x2D, 0x20, 0x2D, 0x69, 0x90,
  // "Ū" (U+016A)
  0x00, 0x09, 0xB7, 0x00, 0x8E, 0x50, 0xB9, 0x04, 0x90, 0x08, 0x00, 0x76, 0x00, 0x80, 0x0A, 0x30,
  0x08, 0x00, 0xD1, 0x01, 0x60, 0x1D, 0x00, 0x43, 0x01, 0xD0, 0x09, 0x00, 0x08, 0xA9, 0x40, 0x00,
  // "ū" (U+016B)
  0x00, 0x9B, 0x72, 0xD4, 0x0D, 0x0C, 0x13, 0xB0, 0xD0, 0x58, 0x2B, 0x0A, 0x55, 0x82, 0xD2, 0x2D,
  0x69, 0x90,
  // "Ŭ" (U+016C)
  0x38, 0x14, 0x04, 0x48, 0x14, 0xC4, 0x72, 0x87, 0x8E, 0x50, 0xB9, 0x04, 0x92, 0x08, 0x20, 0x70,
  0x62, 0x08, 0x20, 0xA0, 0x32, 0x08, 0x28, 0x6D, 0x10, 0x16, 0x01, 0xD2, 0x83, 0x43, 0x01, 0xD2,
  0x09, 0x38, 0x28, 0xA9, 0x42,
  // "ŭ" (U+016D)
  0x00, 0x40, 0x40, 0x04, 0xC4, 0x00, 0x00, 0x02, 0xD4, 0x0D, 0x0C, 0x13, 0xB0, 0xD0, 0x58, 0x2B,
  0x0A, 0x55, 0x82, 0xD2, 0x2D, 0x69, 0x90,
  // "Ů" (U+016E)
  0x00, 0x03, 0x81, 0x00, 0x00, 0x72, 0x50, 0x00, 0x04, 0x81, 0x00, 0x8E, 0x50, 0xB9, 0x04, 0x90,
  0x08, 0x00, 0x76, 0x00, 0x80, 0x0A, 0x30, 0x08, 0x00, 0xD1, 0x01, 0x60, 0x1D, 0x00, 0x43, 0x01,
  0xD0, 0x09, 0x00, 0x08, 0xA9, 0x40, 0x00,
  // "ů" (U+016F)
  0x00, 0x38, 0x10, 0x07, 0x25, 0x00, 0x48, 0x12, 0xD4, 0x0D, 0x0C, 0x13, 0xB0, 0xD0, 0x58, 0x2B,
  0x0A, 0x55, 0x82, 0xD2, 0x2D, 0x69, 0x90,
  // "Ű" (U+0170)
  0x38, 0x21, 0xA7, 0x43, 0x81, 0x83, 0x87, 0x28, 0x78, 0xE5, 0x0B, 0x90, 0x49, 0x20, 0x82, 0x07,
  0x06, 0x20, 0x82, 0x0A, 0x03, 0x20, 0x82, 0x86, 0xD1, 0x01, 0x60, 0x1D, 0x28, 0x34, 0x30, 0x1D,
  0x20, 0x93, 0x82, 0x8A, 0x94, 0x20,
  // "ű" (U+0171)
  0x00, 0x1A, 0x74, 0x00, 0x83, 0x80, 0x00, 0x00, 0x00, 0x2D, 0x40, 0xD0, 0x0C, 0x13, 0xB0, 0x0D,
  0x05, 0x80, 0x2B, 0x0A, 0x50, 0x58, 0x2D, 0x20, 0x2D, 0x69, 0x90,
  // "Ų" (U+0172)
  0x18, 0x78, 0xE5, 0x0B, 0x90, 0x49, 0x20, 0x82, 0x07, 0x06, 0x20, 0x82, 0x0A, 0x03, 0x20, 0x82,
  0x86, 0xD1, 0x01, 0x60, 0x1D, 0x28, 0x34, 0x30, 0x1D, 0x20, 0x93, 0x82, 0x8A, 0x94, 0x40, 0x55,
  0x00, 0x55, 0x81, 0x2A, 0x23,
  // "ų" (U+0173)
  0x2D, 0x40, 0xD0, 0xC1, 0x3B, 0x0D, 0x05, 0x82, 0xB0, 0xA5, 0x58, 0x2D, 0x22, 0xD6, 0x99, 0x00,
  0x05, 0x00, 0x05, 0x50, 0x00, 0x2A, 0x20,
  // "Ŵ" (U+0174)
  0x40, 0xD0, 0x56, 0x81, 0x72, 0x87, 0x58, 0x93, 0xBD, 0x30, 0xD0, 0x1C, 0x86, 0x80, 0x49, 0x28,
  0xA0, 0x90, 0x59, 0x08, 0xD0, 0x26, 0x05, 0x91, 0x6C, 0x18, 0x28, 0x54, 0xA7, 0x1B, 0x28, 0x28,
  0x54, 0xA8, 0x0B, 0x83, 0x28, 0x43, 0xE4, 0x0A, 0xA3, 0x02, 0x0D, 0x20, 0xA0, 0x63,
  // "ŵ" (U+0175)
  0x40, 0xD0, 0x54, 0x81, 0x72, 0x87, 0x18, 0xC0, 0x3E, 0x04, 0xA0, 0xA0, 0xD0, 0x8A, 0x08, 0x0D,
  0x07, 0xB0, 0x70, 0xD5, 0x2B, 0x42, 0x0C, 0x61, 0xB6, 0x28, 0x3D, 0x21, 0xD1, 0x10,
  // "Ŷ" (U+0176)
  0x20, 0xD0, 0x53, 0x81, 0x72, 0x87, 0x18, 0x96, 0xCB, 0x25, 0xE3, 0x69, 0x04, 0x50, 0x2C, 0x08,
  0x38, 0x1D, 0x71, 0x30, 0xA0, 0x74, 0x0B, 0x02, 0x40, 0xE4, 0x81, 0x9F, 0x43,
  // "ŷ" (U+0177)
  0x40, 0xD0, 0x54, 0x81, 0x72, 0x87, 0x38, 0x38, 0xA0, 0x75, 0x28, 0x31, 0xD0, 0x46, 0x38, 0x2D,
  0x07, 0x33, 0x81, 0xA3, 0x94, 0x81, 0x78, 0x64, 0x04, 0x0D, 0x50, 0x05, 0x40, 0x20, 0xA3, 0x82,
  0x39, 0xA1, 0x30,
  // "Ÿ" (U+0178)
  0x28, 0x17, 0x34, 0x78, 0x96, 0xCB, 0x25, 0xE3, 0x69, 0x04, 0x50, 0x2C, 0x08, 0x38, 0x1D, 0x71,
  0x30, 0xA0, 0x74, 0x0B, 0x02, 0x40, 0xE4, 0x81, 0x9F, 0x43,
  // "Ź" (U+0179)
  0x30, 0x20, 0xC4, 0x08, 0x01, 0x71, 0x89, 0x1A, 0x88, 0xD9, 0x07, 0x02, 0xE1, 0x30, 0xC0, 0x53,
  0x06, 0x0B, 0x38, 0x11, 0xE1, 0x30, 0xB0, 0x63, 0x05, 0x0B, 0x28, 0x57, 0x0E, 0xA8, 0x99, 0x10,
  // "ź" (U+017A)
  0x20, 0x20, 0xC3, 0x08, 0x01, 0x78, 0x6C, 0x9F, 0x20, 0x36, 0x92, 0x01, 0x0D, 0x30, 0xA0, 0x52,
  0x87, 0x4B, 0x05, 0x0D, 0xB9, 0x91,
  // "Ż" (U+017B)
  0x30, 0x60, 0x37, 0x18, 0x91, 0xA8, 0x8D, 0x90, 0x70, 0x2E, 0x13, 0x0C, 0x05, 0x30, 0x60, 0xB3,
  0x81, 0x1E, 0x13, 0x0B, 0x06, 0x30, 0x50, 0xB2, 0x85, 0x70, 0xEA, 0x89, 0x91,
  // "ż" (U+017C)
  0x00, 0x63, 0x00, 0x00, 0x00, 0x0C, 0x9F, 0x20, 0x36, 0x90, 0x01, 0xD0, 0x00, 0xA5, 0x00, 0x4B,
  0x05, 0x0D, 0xB9, 0x90,
  // "Ž" (U+017D)
  0x00, 0x63, 0x90, 0x00, 0x2E, 0x20, 0x00, 0x00, 0x00, 0x0A, 0x88, 0xD9, 0x07, 0x02, 0xE1, 0x00,
  0x0C, 0x50, 0x00, 0x6B, 0x00, 0x01, 0xE1, 0x00, 0x0B, 0x60, 0x00, 0x5B, 0x00, 0x70, 0xEA, 0x89,
  0x90,
  // "ž" (U+017E)
  0x00, 0x63, 0x90, 0x02, 0xE2, 0x00, 0x00, 0x00, 0xC9, 0xF2, 0x03, 0x69, 0x00, 0x1D, 0x00, 0x0A,
  0x50, 0x04, 0xB0, 0x50, 0xDB, 0x99, 0x00,
  // "ſ" (U+017F)
  0x48, 0x19, 0xA5, 0x38, 0x23, 0x92, 0x23, 0x07, 0x06, 0x50, 0xA0, 0x35, 0x0D, 0x50, 0x10, 0xC5,
  0x04, 0x09, 0x50, 0x70, 0x65, 0x0A, 0x03, 0x50, 0xC4, 0x81, 0x19, 0x54,
  // "Ω" (U+03A9)
  0x00, 0x88, 0xA8, 0x00, 0x87, 0x00, 0xB3, 0x0E, 0x10, 0x09, 0x62, 0xD0, 0x00, 0xB4, 0x1E, 0x00,
  0x1D, 0x00, 0xA6, 0x3B, 0x30, 0x70, 0x77, 0x07, 0x0E, 0xD7, 0xDD, 0xA0,
  // "μ" (U+03BC)
  0x18, 0xB4, 0x94, 0x0D, 0x0C, 0x12, 0xB0, 0xD0, 0x58, 0x2B, 0x08, 0x55, 0x90, 0xD2, 0x7B, 0x89,
  0x89, 0x40, 0xC4, 0x0D, 0x40,
  // "π" (U+03C0)
  0x1C, 0xED, 0xE9, 0x33, 0x51, 0x70, 0x06, 0x25, 0x40, 0x0A, 0x08, 0x10, 0x1A, 0x0A, 0x00, 0xB4,
  0x0A, 0x60,
  // "–" (U+2013)
  0x80, 0x19,
  // "—" (U+2014)
  0x80, 0x69,
  // "€" (U+20AC)
  0x28, 0x93, 0x48, 0xC2, 0x01, 0xB0, 0x62, 0x07, 0x53, 0x82, 0x3E, 0x87, 0x28, 0x25, 0xE8, 0x23,
  0x0D, 0x50, 0xD5, 0x81, 0x6A, 0x82,
  // "₿" (U+20BF)
  0x00, 0x03, 0x72, 0x00, 0x9C, 0xB5, 0x00, 0x67, 0x3B, 0x00, 0x94, 0x69, 0x00, 0xCA, 0xD0, 0x00,
  0xD0, 0xB4, 0x02, 0xB0, 0xA4, 0x05, 0x90, 0xD1, 0x2C, 0xA8, 0x50, 0x00, 0x66, 0x00,
  // "‘" (U+2018)
  0x34, 0xA0, 0xC2,
  // "’" (U+2019)
  0x85, 0x45, 0x60,
  // "‚" (U+201A)
  0x0B, 0x30, 0x73, 0x26, 0x00,
  // "‛" (U+201B)
  0x78, 0x91, 0x43,
  // "“" (U+201C)
  0x34, 0x52, 0xA2, 0x90, 0xC4, 0xD0,
  // "”" (U+201D)
  0x95, 0xC1, 0x56, 0x92, 0x73, 0x60,
  // "„" (U+201E)
  0x0B, 0x4D, 0x07, 0x3A, 0x26, 0x44,
  // "‟" (U+201F)
  0x78, 0x78, 0x91, 0x91, 0x43, 0x43,
  // "†" (U+2020)
  0x05, 0x60, 0x07, 0x10, 0x7A, 0x71, 0x3A, 0x20, 0x3B, 0x00, 0x56, 0x00, 0x72, 0x00, 0x70, 0x00,
  0x60, 0x00, 0x30, 0x00,
  // "‡" (U+2021)
  0x20, 0x05, 0x30, 0x60, 0x12, 0x82, 0xAB, 0x93, 0x20, 0xC4, 0x06, 0x30, 0x40, 0x52, 0x81, 0x18,
  0x32, 0x82, 0x9B, 0x93, 0x20, 0x94, 0x05, 0x30,
  // "•" (U+2022)
  0x01, 0x02, 0xFB, 0x5F, 0xD2, 0xE8,
  // "…" (U+2026)
  0x22, 0x05, 0x02, 0x27, 0x60, 0xD0, 0x76,
  // "‰" (U+2030)
  0x05, 0x86, 0x04, 0x50, 0x00, 0x00, 0xA0, 0xB0, 0x90, 0x00, 0x00, 0x37, 0x29, 0x63, 0x00, 0x00,
  0x03, 0x76, 0x48, 0x48, 0x11, 0x75, 0x08, 0x67, 0x39, 0x46, 0xA0, 0xB0, 0x02, 0x76, 0x45, 0x7A,
  0x0B, 0x00, 0x90, 0x82, 0x84, 0x82, 0x70, 0x36, 0x04, 0x76, 0x09, 0x80,
  // "‹" (U+2039)
  0x02, 0x61, 0xB0, 0x39, 0x00, 0x90,
  // "›" (U+203A)
  0x09, 0x00, 0x84, 0x0A, 0x26, 0x30,
  // "⁄" (U+2044)
  0x40, 0x83, 0x07, 0x02, 0x20, 0x10, 0x73, 0x08, 0x30, 0x30, 0x63, 0x09, 0x30, 0x50, 0x43, 0x09,
  0x40,
  // "™" (U+2122)
  0x57, 0x58, 0x04, 0x41, 0x80, 0x93, 0x84, 0x08, 0x04, 0x96, 0x41, 0x70, 0x55, 0x44,
  // "⅒" (U+2152)
  0x08, 0x20, 0x08, 0x00, 0x05, 0xC0, 0x07, 0x20, 0x00, 0x0B, 0x01, 0x70, 0x00, 0x01, 0x90, 0x89,
  0x20, 0x00, 0x68, 0x4B, 0xC0, 0x17, 0x50, 0x09, 0x0B, 0x0A, 0x0B, 0x05, 0x41, 0x91, 0xA0, 0xB0,
  0x90, 0x68, 0x39, 0x37, 0x00, 0x00, 0x00, 0x76, 0x00,
  // "ﬁ" (U+FB01)
  0x48, 0x19, 0x8B, 0x38, 0x24, 0x80, 0x52, 0x01, 0x80, 0x0B, 0x38, 0x2B, 0x25, 0x83, 0x82, 0xD0,
  0x85, 0x28, 0x31, 0xB0, 0xB2, 0x28, 0x24, 0x90, 0xD3, 0x83, 0x76, 0x0B, 0x72, 0x0A, 0x03, 0x50,
  0xC4, 0x81, 0x19, 0x54,
  // "ﬂ" (U+FB02)
  0x48, 0x29, 0x9E, 0x33, 0x82, 0x48, 0x0E, 0x38, 0x31, 0xBB, 0x4C, 0x48, 0x2B, 0x24, 0x94, 0x82,
  0xD0, 0x76, 0x38, 0x31, 0xB0, 0xB2, 0x38, 0x24, 0x90, 0xD4, 0x83, 0x76, 0x0B, 0x73, 0x0A, 0x03,
  0x60, 0xC5, 0x81, 0x19, 0x55,
};

const Font& font_NotoSerif_CondensedItalic_10() {
  static SmoothFont font(font_NotoSerif_CondensedItalic_10_data);
  return font;
}

}  // namespace roo_display
