#include "90.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSerif-Condensed (Noto Serif Condensed)
// Generated on Wed Nov 19 19:11:49 CET 2025
static const uint8_t font_NotoSerif_Condensed_90_data[] PROGMEM = {
  
  // Header
  0x01, 0x02, 0x04, 0x02, 0x01, 0x03, 0x01, 0x01, 0x57, 0x16, 0xAC,
  0xF2, 0xEB, 0x60, 0x59, 0x44, 0xEB, 0x16, 0x05, 0x63, 0x15, 0x19, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x08, 0x00, 0x11, 0x40, 0x1A, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x04, 0x2C, 0x1C, 0x40, 0x21, 0x00, 0x00, 0xAA, // """ (U+0022)
  0x00, 0x23, 0x01, 0x01, 0x29, 0x40, 0x2B, 0x00, 0x01, 0x27, // "#" (U+0023)
  0x00, 0x24, 0x04, 0xF9, 0x25, 0x44, 0x2B, 0x00, 0x02, 0xE2, // "$" (U+0024)
  0x00, 0x25, 0x03, 0x00, 0x41, 0x41, 0x45, 0x00, 0x05, 0x13, // "%" (U+0025)
  0x00, 0x26, 0x02, 0x00, 0x39, 0x41, 0x3A, 0x00, 0x08, 0x34, // "&" (U+0026)
  0x00, 0x27, 0x04, 0x2C, 0x0D, 0x40, 0x12, 0x00, 0x0A, 0xB3, // "'" (U+0027)
  0x00, 0x28, 0x04, 0xF5, 0x18, 0x45, 0x1B, 0x00, 0x0A, 0xED, // "(" (U+0028)
  0x00, 0x29, 0x02, 0xF5, 0x16, 0x45, 0x1B, 0x00, 0x0C, 0x1C, // ")" (U+0029)
  0x00, 0x2A, 0x03, 0x22, 0x21, 0x44, 0x25, 0x00, 0x0D, 0x45, // "*" (U+002A)
  0x00, 0x2B, 0x04, 0x0E, 0x25, 0x34, 0x2A, 0x00, 0x0E, 0x50, // "+" (U+002B)
  0x00, 0x2C, 0x02, 0xF3, 0x0E, 0x0B, 0x14, 0x00, 0x0F, 0x05, // "," (U+002C)
  0x00, 0x2D, 0x02, 0x16, 0x15, 0x1C, 0x18, 0x00, 0x0F, 0x5F, // "-" (U+002D)
  0x00, 0x2E, 0x05, 0x00, 0x0E, 0x0A, 0x14, 0x00, 0x0F, 0x71, // "." (U+002E)
  0x00, 0x2F, 0x00, 0xF6, 0x15, 0x44, 0x16, 0x00, 0x0F, 0x93, // "/" (U+002F)
  0x00, 0x30, 0x03, 0x00, 0x27, 0x41, 0x2B, 0x00, 0x10, 0xC2, // "0" (U+0030)
  0x00, 0x31, 0x04, 0x01, 0x24, 0x40, 0x2B, 0x00, 0x12, 0x8F, // "1" (U+0031)
  0x00, 0x32, 0x04, 0x01, 0x26, 0x41, 0x2B, 0x00, 0x13, 0xD6, // "2" (U+0032)
  0x00, 0x33, 0x03, 0x00, 0x26, 0x41, 0x2B, 0x00, 0x15, 0x49, // "3" (U+0033)
  0x00, 0x34, 0x01, 0x01, 0x29, 0x40, 0x2B, 0x00, 0x16, 0xF2, // "4" (U+0034)
  0x00, 0x35, 0x04, 0x00, 0x25, 0x40, 0x2B, 0x00, 0x18, 0x90, // "5" (U+0035)
  0x00, 0x36, 0x04, 0x00, 0x27, 0x41, 0x2B, 0x00, 0x1A, 0x13, // "6" (U+0036)
  0x00, 0x37, 0x04, 0x01, 0x27, 0x40, 0x2B, 0x00, 0x1B, 0xDF, // "7" (U+0037)
  0x00, 0x38, 0x03, 0x00, 0x27, 0x41, 0x2B, 0x00, 0x1D, 0x16, // "8" (U+0038)
  0x00, 0x39, 0x03, 0x00, 0x26, 0x41, 0x2B, 0x00, 0x1E, 0xF5, // "9" (U+0039)
  0x00, 0x3A, 0x06, 0x00, 0x0F, 0x30, 0x16, 0x00, 0x20, 0xBE, // ":" (U+003A)
  0x00, 0x3B, 0x03, 0xF4, 0x0F, 0x30, 0x16, 0x00, 0x21, 0x06, // ";" (U+003B)
  0x00, 0x3C, 0x04, 0x0B, 0x25, 0x37, 0x2A, 0x00, 0x21, 0x85, // "<" (U+003C)
  0x00, 0x3D, 0x04, 0x16, 0x25, 0x2B, 0x2A, 0x00, 0x22, 0x8E, // "=" (U+003D)
  0x00, 0x3E, 0x04, 0x0B, 0x25, 0x37, 0x2A, 0x00, 0x22, 0xBE, // ">" (U+003E)
  0x00, 0x3F, 0x03, 0x00, 0x22, 0x41, 0x27, 0x00, 0x23, 0xC7, // "?" (U+003F)
  0x00, 0x40, 0x05, 0xF5, 0x42, 0x40, 0x47, 0x00, 0x25, 0x0A, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x36, 0x40, 0x37, 0x00, 0x28, 0x8F, // "A" (U+0041)
  0x00, 0x42, 0x02, 0x01, 0x2E, 0x40, 0x33, 0x00, 0x2A, 0x84, // "B" (U+0042)
  0x00, 0x43, 0x04, 0x00, 0x2D, 0x41, 0x30, 0x00, 0x2C, 0x8A, // "C" (U+0043)
  0x00, 0x44, 0x02, 0x01, 0x33, 0x40, 0x38, 0x00, 0x2E, 0x43, // "D" (U+0044)
  0x00, 0x45, 0x02, 0x01, 0x2D, 0x40, 0x30, 0x00, 0x30, 0x5E, // "E" (U+0045)
  0x00, 0x46, 0x02, 0x01, 0x2A, 0x40, 0x2E, 0x00, 0x31, 0xEA, // "F" (U+0046)
  0x00, 0x47, 0x04, 0x00, 0x35, 0x41, 0x38, 0x00, 0x33, 0x55, // "G" (U+0047)
  0x00, 0x48, 0x02, 0x01, 0x3A, 0x40, 0x3D, 0x00, 0x35, 0x5E, // "H" (U+0048)
  0x00, 0x49, 0x02, 0x01, 0x19, 0x40, 0x1D, 0x00, 0x37, 0x9D, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xEC, 0x1A, 0x40, 0x1C, 0x00, 0x38, 0xA3, // "J" (U+004A)
  0x00, 0x4B, 0x02, 0x01, 0x37, 0x40, 0x37, 0x00, 0x3A, 0x0E, // "K" (U+004B)
  0x00, 0x4C, 0x02, 0x01, 0x2D, 0x40, 0x30, 0x00, 0x3C, 0x51, // "L" (U+004C)
  0x00, 0x4D, 0x02, 0x01, 0x45, 0x40, 0x48, 0x00, 0x3D, 0xC4, // "M" (U+004D)
  0x00, 0x4E, 0x02, 0x01, 0x38, 0x40, 0x3B, 0x00, 0x40, 0xFE, // "N" (U+004E)
  0x00, 0x4F, 0x04, 0x00, 0x35, 0x41, 0x3A, 0x00, 0x43, 0x8A, // "O" (U+004F)
  0x00, 0x50, 0x02, 0x01, 0x2C, 0x40, 0x2F, 0x00, 0x45, 0xB5, // "P" (U+0050)
  0x00, 0x51, 0x04, 0xEC, 0x35, 0x41, 0x3A, 0x00, 0x47, 0x6F, // "Q" (U+0051)
  0x00, 0x52, 0x02, 0x01, 0x33, 0x40, 0x33, 0x00, 0x4A, 0x0F, // "R" (U+0052)
  0x00, 0x53, 0x03, 0x00, 0x26, 0x41, 0x2A, 0x00, 0x4C, 0x2B, // "S" (U+0053)
  0x00, 0x54, 0x01, 0x01, 0x2E, 0x40, 0x30, 0x00, 0x4D, 0xCC, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x00, 0x36, 0x40, 0x37, 0x00, 0x4F, 0x39, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x34, 0x40, 0x34, 0x00, 0x51, 0x3D, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x50, 0x40, 0x51, 0x00, 0x53, 0x2D, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x32, 0x40, 0x34, 0x00, 0x56, 0x80, // "X" (U+0058)
  0x00, 0x59, 0xFF, 0x01, 0x31, 0x40, 0x31, 0x00, 0x58, 0x8F, // "Y" (U+0059)
  0x00, 0x5A, 0x02, 0x01, 0x2B, 0x40, 0x2E, 0x00, 0x5A, 0x4E, // "Z" (U+005A)
  0x00, 0x5B, 0x07, 0xF5, 0x19, 0x44, 0x1C, 0x00, 0x5B, 0xEC, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0xF6, 0x15, 0x44, 0x16, 0x00, 0x5D, 0x0A, // "\" (U+005C)
  0x00, 0x5D, 0x02, 0xF5, 0x14, 0x44, 0x1C, 0x00, 0x5E, 0x3A, // "]" (U+005D)
  0x00, 0x5E, 0x03, 0x19, 0x26, 0x40, 0x2A, 0x00, 0x5F, 0x59, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xF4, 0x23, 0xF8, 0x23, 0x00, 0x60, 0x66, // "_" (U+005F)
  0x00, 0x60, 0x03, 0x37, 0x13, 0x45, 0x17, 0x00, 0x60, 0x7D, // "`" (U+0060)
  0x00, 0x61, 0x03, 0x00, 0x28, 0x31, 0x2C, 0x00, 0x60, 0xB6, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x00, 0x2B, 0x44, 0x30, 0x00, 0x62, 0x1F, // "b" (U+0062)
  0x00, 0x63, 0x04, 0x00, 0x23, 0x31, 0x26, 0x00, 0x64, 0x27, // "c" (U+0063)
  0x00, 0x64, 0x04, 0x00, 0x2E, 0x44, 0x30, 0x00, 0x65, 0x50, // "d" (U+0064)
  0x00, 0x65, 0x04, 0x00, 0x25, 0x31, 0x2A, 0x00, 0x67, 0x54, // "e" (U+0065)
  0x00, 0x66, 0x02, 0x01, 0x21, 0x46, 0x1D, 0x00, 0x68, 0x8B, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xEC, 0x28, 0x33, 0x2A, 0x00, 0x69, 0xE6, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x2F, 0x44, 0x31, 0x00, 0x6B, 0xF9, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x17, 0x44, 0x19, 0x00, 0x6D, 0xC2, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xEC, 0x11, 0x44, 0x18, 0x00, 0x6E, 0xA9, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x2D, 0x44, 0x2E, 0x00, 0x6F, 0xD7, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x17, 0x44, 0x18, 0x00, 0x71, 0xCE, // "l" (U+006C)
  0x00, 0x6D, 0x02, 0x01, 0x46, 0x31, 0x49, 0x00, 0x72, 0xC7, // "m" (U+006D)
  0x00, 0x6E, 0x02, 0x01, 0x2F, 0x31, 0x32, 0x00, 0x74, 0xEB, // "n" (U+006E)
  0x00, 0x6F, 0x04, 0x00, 0x28, 0x31, 0x2D, 0x00, 0x76, 0x72, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xEC, 0x2B, 0x31, 0x30, 0x00, 0x77, 0xD3, // "p" (U+0070)
  0x00, 0x71, 0x04, 0xEC, 0x2E, 0x31, 0x30, 0x00, 0x79, 0xD8, // "q" (U+0071)
  0x00, 0x72, 0x02, 0x01, 0x23, 0x31, 0x25, 0x00, 0x7B, 0xE2, // "r" (U+0072)
  0x00, 0x73, 0x03, 0x00, 0x1F, 0x31, 0x23, 0x00, 0x7C, 0xF7, // "s" (U+0073)
  0x00, 0x74, 0x01, 0x00, 0x1A, 0x3B, 0x1C, 0x00, 0x7E, 0x2B, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x00, 0x2F, 0x30, 0x31, 0x00, 0x7F, 0x32, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x2C, 0x30, 0x2D, 0x00, 0x80, 0x92, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x42, 0x30, 0x42, 0x00, 0x81, 0xF6, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x2C, 0x30, 0x2D, 0x00, 0x84, 0x44, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xEC, 0x2B, 0x30, 0x2C, 0x00, 0x85, 0xB7, // "y" (U+0079)
  0x00, 0x7A, 0x03, 0x01, 0x23, 0x30, 0x28, 0x00, 0x87, 0x8F, // "z" (U+007A)
  0x00, 0x7B, 0x03, 0xF5, 0x1D, 0x44, 0x21, 0x00, 0x88, 0xAB, // "{" (U+007B)
  0x00, 0x7C, 0x13, 0xEC, 0x17, 0x44, 0x2B, 0x00, 0x8A, 0x0C, // "|" (U+007C)
  0x00, 0x7D, 0x03, 0xF5, 0x1D, 0x44, 0x21, 0x00, 0x8A, 0x92, // "}" (U+007D)
  0x00, 0x7E, 0x03, 0x19, 0x26, 0x28, 0x2A, 0x00, 0x8B, 0xF1, // "~" (U+007E)
  0x00, 0xA1, 0x08, 0xF1, 0x11, 0x31, 0x1A, 0x00, 0x8C, 0x81, // "¡" (U+00A1)
  0x00, 0xA2, 0x05, 0x01, 0x26, 0x40, 0x2B, 0x00, 0x8D, 0x2C, // "¢" (U+00A2)
  0x00, 0xA3, 0x03, 0x00, 0x28, 0x41, 0x2B, 0x00, 0x8E, 0xC2, // "£" (U+00A3)
  0x00, 0xA4, 0x05, 0x0E, 0x25, 0x34, 0x2B, 0x00, 0x90, 0x65, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x2A, 0x40, 0x2B, 0x00, 0x91, 0x98, // "¥" (U+00A5)
  0x00, 0xA6, 0x13, 0xEC, 0x17, 0x44, 0x2B, 0x00, 0x93, 0x42, // "¦" (U+00A6)
  0x00, 0xA7, 0x05, 0xF6, 0x25, 0x44, 0x2A, 0x00, 0x93, 0xB1, // "§" (U+00A7)
  0x00, 0xA8, 0x0B, 0x3A, 0x21, 0x43, 0x2C, 0x00, 0x95, 0xC8, // "¨" (U+00A8)
  0x00, 0xA9, 0x04, 0x00, 0x3C, 0x41, 0x41, 0x00, 0x96, 0x0A, // "©" (U+00A9)
  0x00, 0xAA, 0x02, 0x23, 0x1C, 0x41, 0x1E, 0x00, 0x99, 0x0F, // "ª" (U+00AA)
  0x00, 0xAB, 0x06, 0x08, 0x21, 0x29, 0x28, 0x00, 0x99, 0xDD, // "«" (U+00AB)
  0x00, 0xAC, 0x04, 0x0C, 0x25, 0x23, 0x2A, 0x00, 0x9A, 0xC8, // "¬" (U+00AC)
  0x00, 0xAE, 0x04, 0x00, 0x3C, 0x41, 0x41, 0x00, 0x9B, 0x36, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x45, 0x23, 0x49, 0x23, 0x00, 0x9E, 0x4A, // "¯" (U+00AF)
  0x00, 0xB0, 0x03, 0x28, 0x1A, 0x42, 0x1F, 0x00, 0x9E, 0x61, // "°" (U+00B0)
  0x00, 0xB1, 0x04, 0x01, 0x25, 0x34, 0x2A, 0x00, 0x9F, 0x0C, // "±" (U+00B1)
  0x00, 0xB2, 0x03, 0x24, 0x1A, 0x4B, 0x1F, 0x00, 0x9F, 0xD9, // "²" (U+00B2)
  0x00, 0xB3, 0x02, 0x23, 0x1B, 0x4A, 0x1F, 0x00, 0xA0, 0xAE, // "³" (U+00B3)
  0x00, 0xB4, 0x03, 0x37, 0x13, 0x45, 0x17, 0x00, 0xA1, 0x9D, // "´" (U+00B4)
  0x00, 0xB5, 0x06, 0xEC, 0x2D, 0x30, 0x30, 0x00, 0xA1, 0xD5, // "µ" (U+00B5)
  0x00, 0xB6, 0x03, 0xF7, 0x2C, 0x44, 0x30, 0x00, 0xA3, 0xB8, // "¶" (U+00B6)
  0x00, 0xB7, 0x05, 0x1B, 0x0E, 0x25, 0x14, 0x00, 0xA5, 0xFB, // "·" (U+00B7)
  0x00, 0xB8, 0x04, 0xEC, 0x14, 0x01, 0x1A, 0x00, 0xA6, 0x1D, // "¸" (U+00B8)
  0x00, 0xB9, 0x03, 0x24, 0x1A, 0x4A, 0x1F, 0x00, 0xA6, 0x77, // "¹" (U+00B9)
  0x00, 0xBA, 0x03, 0x23, 0x1B, 0x41, 0x1F, 0x00, 0xA7, 0x2D, // "º" (U+00BA)
  0x00, 0xBB, 0x05, 0x08, 0x22, 0x29, 0x28, 0x00, 0xA7, 0xF0, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x3E, 0x41, 0x41, 0x00, 0xA8, 0xE0, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x3D, 0x41, 0x41, 0x00, 0xAB, 0x75, // "½" (U+00BD)
  0x00, 0xBE, 0x02, 0x01, 0x3E, 0x41, 0x41, 0x00, 0xAE, 0x29, // "¾" (U+00BE)
  0x00, 0xBF, 0x04, 0xF0, 0x23, 0x31, 0x27, 0x00, 0xB0, 0xE5, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x36, 0x54, 0x37, 0x00, 0xB2, 0x28, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x36, 0x54, 0x37, 0x00, 0xB4, 0x6E, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x36, 0x54, 0x37, 0x00, 0xB6, 0xB4, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x36, 0x50, 0x37, 0x00, 0xB9, 0x1C, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x36, 0x52, 0x37, 0x00, 0xBB, 0x7C, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x36, 0x50, 0x37, 0x00, 0xBD, 0xC9, // "Å" (U+00C5)
  0x00, 0xC6, 0xFF, 0x01, 0x46, 0x40, 0x4A, 0x00, 0xC0, 0x3F, // "Æ" (U+00C6)
  0x00, 0xC7, 0x04, 0xEB, 0x2D, 0x41, 0x30, 0x00, 0xC2, 0xC0, // "Ç" (U+00C7)
  0x00, 0xC8, 0x02, 0x01, 0x2D, 0x54, 0x30, 0x00, 0xC4, 0xF1, // "È" (U+00C8)
  0x00, 0xC9, 0x02, 0x01, 0x2D, 0x54, 0x30, 0x00, 0xC6, 0xCF, // "É" (U+00C9)
  0x00, 0xCA, 0x02, 0x01, 0x2D, 0x54, 0x30, 0x00, 0xC8, 0xAE, // "Ê" (U+00CA)
  0x00, 0xCB, 0x02, 0x01, 0x2D, 0x52, 0x30, 0x00, 0xCA, 0xA9, // "Ë" (U+00CB)
  0x00, 0xCC, 0x02, 0x01, 0x19, 0x54, 0x1D, 0x00, 0xCC, 0x88, // "Ì" (U+00CC)
  0x00, 0xCD, 0x02, 0x01, 0x19, 0x54, 0x1D, 0x00, 0xCD, 0xD1, // "Í" (U+00CD)
  0x00, 0xCE, 0x02, 0x01, 0x1A, 0x54, 0x1D, 0x00, 0xCF, 0x18, // "Î" (U+00CE)
  0x00, 0xCF, 0x02, 0x01, 0x19, 0x52, 0x1D, 0x00, 0xD0, 0x80, // "Ï" (U+00CF)
  0x00, 0xD0, 0x02, 0x01, 0x33, 0x40, 0x38, 0x00, 0xD1, 0xCD, // "Ð" (U+00D0)
  0x00, 0xD1, 0x02, 0x01, 0x38, 0x50, 0x3B, 0x00, 0xD3, 0xE4, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x04, 0x00, 0x35, 0x54, 0x3A, 0x00, 0xD6, 0xDE, // "Ò" (U+00D2)
  0x00, 0xD3, 0x04, 0x00, 0x35, 0x54, 0x3A, 0x00, 0xD9, 0x5A, // "Ó" (U+00D3)
  0x00, 0xD4, 0x04, 0x00, 0x35, 0x54, 0x3A, 0x00, 0xDB, 0xD7, // "Ô" (U+00D4)
  0x00, 0xD5, 0x04, 0x00, 0x35, 0x50, 0x3A, 0x00, 0xDE, 0x74, // "Õ" (U+00D5)
  0x00, 0xD6, 0x04, 0x00, 0x35, 0x52, 0x3A, 0x00, 0xE1, 0x09, // "Ö" (U+00D6)
  0x00, 0xD7, 0x04, 0x0E, 0x25, 0x33, 0x2A, 0x00, 0xE3, 0x89, // "×" (U+00D7)
  0x00, 0xD8, 0x04, 0xFD, 0x35, 0x44, 0x3A, 0x00, 0xE4, 0x9C, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x00, 0x36, 0x54, 0x37, 0x00, 0xE7, 0x57, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x00, 0x36, 0x54, 0x37, 0x00, 0xE9, 0xAE, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x00, 0x36, 0x54, 0x37, 0x00, 0xEC, 0x05, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x00, 0x36, 0x52, 0x37, 0x00, 0xEE, 0x7E, // "Ü" (U+00DC)
  0x00, 0xDD, 0xFF, 0x01, 0x31, 0x54, 0x31, 0x00, 0xF0, 0xDC, // "Ý" (U+00DD)
  0x00, 0xDE, 0x02, 0x01, 0x2B, 0x40, 0x2F, 0x00, 0xF2, 0xEE, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x00, 0x2F, 0x44, 0x33, 0x00, 0xF4, 0xA8, // "ß" (U+00DF)
  0x00, 0xE0, 0x03, 0x00, 0x28, 0x45, 0x2C, 0x00, 0xF6, 0xF7, // "à" (U+00E0)
  0x00, 0xE1, 0x03, 0x00, 0x28, 0x45, 0x2C, 0x00, 0xF8, 0xB0, // "á" (U+00E1)
  0x00, 0xE2, 0x03, 0x00, 0x28, 0x45, 0x2C, 0x00, 0xFA, 0x68, // "â" (U+00E2)
  0x00, 0xE3, 0x03, 0x00, 0x28, 0x41, 0x2C, 0x00, 0xFC, 0x39, // "ã" (U+00E3)
  0x00, 0xE4, 0x03, 0x00, 0x28, 0x43, 0x2C, 0x00, 0xFE, 0x02, // "ä" (U+00E4)
  0x00, 0xE5, 0x03, 0x00, 0x28, 0x4A, 0x2C, 0x00, 0xFF, 0xBB, // "å" (U+00E5)
  0x00, 0xE6, 0x03, 0x00, 0x3D, 0x31, 0x41, 0x01, 0x01, 0xB5, // "æ" (U+00E6)
  0x00, 0xE7, 0x04, 0xEC, 0x23, 0x31, 0x26, 0x01, 0x03, 0xD5, // "ç" (U+00E7)
  0x00, 0xE8, 0x04, 0x00, 0x25, 0x45, 0x2A, 0x01, 0x05, 0x66, // "è" (U+00E8)
  0x00, 0xE9, 0x04, 0x00, 0x25, 0x45, 0x2A, 0x01, 0x06, 0xE8, // "é" (U+00E9)
  0x00, 0xEA, 0x04, 0x00, 0x25, 0x45, 0x2A, 0x01, 0x08, 0x6A, // "ê" (U+00EA)
  0x00, 0xEB, 0x04, 0x00, 0x25, 0x43, 0x2A, 0x01, 0x0A, 0x06, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x17, 0x45, 0x19, 0x01, 0x0B, 0x88, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x18, 0x45, 0x19, 0x01, 0x0C, 0x90, // "í" (U+00ED)
  0x00, 0xEE, 0x00, 0x01, 0x18, 0x45, 0x19, 0x01, 0x0D, 0x97, // "î" (U+00EE)
  0x00, 0xEF, 0x01, 0x01, 0x17, 0x43, 0x19, 0x01, 0x0E, 0xBB, // "ï" (U+00EF)
  0x00, 0xF0, 0x04, 0x00, 0x28, 0x44, 0x2D, 0x01, 0x0F, 0xB2, // "ð" (U+00F0)
  0x00, 0xF1, 0x02, 0x01, 0x2F, 0x41, 0x32, 0x01, 0x11, 0xA3, // "ñ" (U+00F1)
  0x00, 0xF2, 0x04, 0x00, 0x28, 0x45, 0x2D, 0x01, 0x13, 0x8E, // "ò" (U+00F2)
  0x00, 0xF3, 0x04, 0x00, 0x28, 0x45, 0x2D, 0x01, 0x15, 0x3D, // "ó" (U+00F3)
  0x00, 0xF4, 0x04, 0x00, 0x28, 0x45, 0x2D, 0x01, 0x16, 0xEB, // "ô" (U+00F4)
  0x00, 0xF5, 0x04, 0x00, 0x28, 0x41, 0x2D, 0x01, 0x18, 0xB3, // "õ" (U+00F5)
  0x00, 0xF6, 0x04, 0x00, 0x28, 0x43, 0x2D, 0x01, 0x1A, 0x74, // "ö" (U+00F6)
  0x00, 0xF7, 0x04, 0x0B, 0x25, 0x36, 0x2A, 0x01, 0x1C, 0x22, // "÷" (U+00F7)
  0x00, 0xF8, 0x04, 0xFD, 0x28, 0x34, 0x2D, 0x01, 0x1C, 0x99, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x00, 0x2F, 0x45, 0x31, 0x01, 0x1E, 0x68, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x00, 0x2F, 0x45, 0x31, 0x01, 0x20, 0x1A, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x00, 0x2F, 0x45, 0x31, 0x01, 0x21, 0xCD, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x00, 0x2F, 0x43, 0x31, 0x01, 0x23, 0x9F, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xEC, 0x2B, 0x45, 0x2C, 0x01, 0x25, 0x54, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xEC, 0x2B, 0x44, 0x30, 0x01, 0x27, 0x7F, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xEC, 0x2B, 0x43, 0x2C, 0x01, 0x29, 0xEA, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x36, 0x4B, 0x37, 0x01, 0x2C, 0x15, // "Ā" (U+0100)
  0x01, 0x01, 0x03, 0x00, 0x28, 0x3C, 0x2C, 0x01, 0x2E, 0x29, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x36, 0x51, 0x37, 0x01, 0x2F, 0xAD, // "Ă" (U+0102)
  0x01, 0x03, 0x03, 0x00, 0x28, 0x42, 0x2C, 0x01, 0x32, 0x01, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xEC, 0x36, 0x40, 0x37, 0x01, 0x33, 0xC0, // "Ą" (U+0104)
  0x01, 0x05, 0x03, 0xEC, 0x28, 0x31, 0x2C, 0x01, 0x36, 0x34, // "ą" (U+0105)
  0x01, 0x06, 0x04, 0x00, 0x2D, 0x54, 0x30, 0x01, 0x38, 0x16, // "Ć" (U+0106)
  0x01, 0x07, 0x04, 0x00, 0x23, 0x45, 0x26, 0x01, 0x3A, 0x20, // "ć" (U+0107)
  0x01, 0x08, 0x04, 0x00, 0x2D, 0x54, 0x30, 0x01, 0x3B, 0x92, // "Ĉ" (U+0108)
  0x01, 0x09, 0x04, 0x00, 0x23, 0x45, 0x26, 0x01, 0x3D, 0xB7, // "ĉ" (U+0109)
  0x01, 0x0A, 0x04, 0x00, 0x2D, 0x53, 0x30, 0x01, 0x3F, 0x43, // "Ċ" (U+010A)
  0x01, 0x0B, 0x04, 0x00, 0x23, 0x44, 0x26, 0x01, 0x41, 0x3B, // "ċ" (U+010B)
  0x01, 0x0C, 0x04, 0x00, 0x2D, 0x54, 0x30, 0x01, 0x42, 0x9D, // "Č" (U+010C)
  0x01, 0x0D, 0x04, 0x00, 0x23, 0x45, 0x26, 0x01, 0x44, 0xC5, // "č" (U+010D)
  0x01, 0x0E, 0x02, 0x01, 0x33, 0x54, 0x38, 0x01, 0x46, 0x53, // "Ď" (U+010E)
  0x01, 0x0F, 0x04, 0x00, 0x35, 0x44, 0x30, 0x01, 0x48, 0xE4, // "ď" (U+010F)
  0x01, 0x10, 0x02, 0x01, 0x33, 0x40, 0x38, 0x01, 0x4B, 0x27, // "Đ" (U+0110)
  0x01, 0x11, 0x04, 0x00, 0x2E, 0x44, 0x30, 0x01, 0x4D, 0x3E, // "đ" (U+0111)
  0x01, 0x12, 0x02, 0x01, 0x2D, 0x4B, 0x30, 0x01, 0x4F, 0x3B, // "Ē" (U+0112)
  0x01, 0x13, 0x04, 0x00, 0x25, 0x3C, 0x2A, 0x01, 0x50, 0xE3, // "ē" (U+0113)
  0x01, 0x14, 0x02, 0x01, 0x2D, 0x51, 0x30, 0x01, 0x52, 0x33, // "Ĕ" (U+0114)
  0x01, 0x15, 0x04, 0x00, 0x25, 0x42, 0x2A, 0x01, 0x54, 0x1A, // "ĕ" (U+0115)
  0x01, 0x16, 0x02, 0x01, 0x2D, 0x52, 0x30, 0x01, 0x55, 0xA2, // "Ė" (U+0116)
  0x01, 0x17, 0x04, 0x00, 0x25, 0x44, 0x2A, 0x01, 0x57, 0x6E, // "ė" (U+0117)
  0x01, 0x18, 0x02, 0xEB, 0x2D, 0x40, 0x30, 0x01, 0x58, 0xDF, // "Ę" (U+0118)
  0x01, 0x19, 0x04, 0xEC, 0x25, 0x31, 0x2A, 0x01, 0x5A, 0xEA, // "ę" (U+0119)
  0x01, 0x1A, 0x02, 0x01, 0x2D, 0x54, 0x30, 0x01, 0x5C, 0x82, // "Ě" (U+011A)
  0x01, 0x1B, 0x04, 0x00, 0x25, 0x45, 0x2A, 0x01, 0x5E, 0x80, // "ě" (U+011B)
  0x01, 0x1C, 0x04, 0x00, 0x35, 0x54, 0x38, 0x01, 0x60, 0x1E, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xEC, 0x28, 0x45, 0x2A, 0x01, 0x62, 0x99, // "ĝ" (U+011D)
  0x01, 0x1E, 0x04, 0x00, 0x35, 0x51, 0x38, 0x01, 0x65, 0x15, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xEC, 0x28, 0x42, 0x2A, 0x01, 0x67, 0x7C, // "ğ" (U+011F)
  0x01, 0x20, 0x04, 0x00, 0x35, 0x53, 0x38, 0x01, 0x69, 0xE4, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xEC, 0x28, 0x44, 0x2A, 0x01, 0x6C, 0x2D, // "ġ" (U+0121)
  0x01, 0x22, 0x04, 0xED, 0x35, 0x41, 0x38, 0x01, 0x6E, 0x7E, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xEC, 0x28, 0x44, 0x2A, 0x01, 0x70, 0xCD, // "ģ" (U+0123)
  0x01, 0x24, 0x02, 0x01, 0x3A, 0x54, 0x3D, 0x01, 0x73, 0x24, // "Ĥ" (U+0124)
  0x01, 0x25, 0x01, 0x01, 0x2F, 0x56, 0x31, 0x01, 0x75, 0xD8, // "ĥ" (U+0125)
  0x01, 0x26, 0x02, 0x01, 0x3A, 0x40, 0x3D, 0x01, 0x78, 0x13, // "Ħ" (U+0126)
  0x01, 0x27, 0x01, 0x01, 0x2F, 0x44, 0x31, 0x01, 0x7A, 0x45, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x1C, 0x50, 0x1D, 0x01, 0x7C, 0x0D, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFE, 0x01, 0x1A, 0x41, 0x19, 0x01, 0x7D, 0x76, // "ĩ" (U+0129)
  0x01, 0x2A, 0x02, 0x01, 0x19, 0x4B, 0x1D, 0x01, 0x7E, 0x9A, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x17, 0x3C, 0x19, 0x01, 0x7F, 0xB8, // "ī" (U+012B)
  0x01, 0x2C, 0x02, 0x01, 0x19, 0x51, 0x1D, 0x01, 0x80, 0x95, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x17, 0x42, 0x19, 0x01, 0x81, 0xE7, // "ĭ" (U+012D)
  0x01, 0x2E, 0x02, 0xEB, 0x19, 0x40, 0x1D, 0x01, 0x82, 0xF7, // "Į" (U+012E)
  0x01, 0x2F, 0x01, 0xEB, 0x17, 0x44, 0x19, 0x01, 0x84, 0x65, // "į" (U+012F)
  0x01, 0x30, 0x02, 0x01, 0x19, 0x53, 0x1D, 0x01, 0x85, 0xB3, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x17, 0x30, 0x19, 0x01, 0x86, 0xED, // "ı" (U+0131)
  0x01, 0x32, 0x02, 0xEC, 0x36, 0x40, 0x39, 0x01, 0x87, 0xA0, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xEC, 0x2A, 0x44, 0x31, 0x01, 0x8A, 0x2B, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xEC, 0x1A, 0x54, 0x1C, 0x01, 0x8C, 0x71, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xEC, 0x16, 0x45, 0x18, 0x01, 0x8E, 0x3B, // "ĵ" (U+0135)
  0x01, 0x36, 0x02, 0xED, 0x37, 0x40, 0x37, 0x01, 0x8F, 0xB6, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xED, 0x2D, 0x44, 0x2E, 0x01, 0x92, 0x3F, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x2D, 0x30, 0x2E, 0x01, 0x94, 0x7C, // "ĸ" (U+0138)
  0x01, 0x39, 0x02, 0x01, 0x2D, 0x54, 0x30, 0x01, 0x96, 0x09, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x01, 0x01, 0x17, 0x56, 0x18, 0x01, 0x97, 0xCF, // "ĺ" (U+013A)
  0x01, 0x3B, 0x02, 0xED, 0x2D, 0x40, 0x30, 0x01, 0x99, 0x08, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xED, 0x17, 0x44, 0x18, 0x01, 0x9A, 0xC1, // "ļ" (U+013C)
  0x01, 0x3D, 0x02, 0x01, 0x2D, 0x40, 0x30, 0x01, 0x9B, 0xF2, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x1D, 0x44, 0x18, 0x01, 0x9D, 0x88, // "ľ" (U+013E)
  0x01, 0x3F, 0x02, 0x01, 0x2D, 0x40, 0x30, 0x01, 0x9E, 0xC3, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x20, 0x44, 0x19, 0x01, 0xA0, 0x57, // "ŀ" (U+0140)
  0x01, 0x41, 0x02, 0x01, 0x2D, 0x40, 0x30, 0x01, 0xA1, 0xAD, // "Ł" (U+0141)
  0x01, 0x42, 0x02, 0x01, 0x18, 0x44, 0x19, 0x01, 0xA3, 0x51, // "ł" (U+0142)
  0x01, 0x43, 0x02, 0x01, 0x38, 0x54, 0x3B, 0x01, 0xA4, 0x6D, // "Ń" (U+0143)
  0x01, 0x44, 0x02, 0x01, 0x2F, 0x45, 0x32, 0x01, 0xA7, 0x4D, // "ń" (U+0144)
  0x01, 0x45, 0x02, 0xED, 0x38, 0x40, 0x3B, 0x01, 0xA9, 0x25, // "Ņ" (U+0145)
  0x01, 0x46, 0x02, 0xED, 0x2F, 0x31, 0x32, 0x01, 0xAB, 0xF7, // "ņ" (U+0146)
  0x01, 0x47, 0x02, 0x01, 0x38, 0x54, 0x3B, 0x01, 0xAD, 0xC5, // "Ň" (U+0147)
  0x01, 0x48, 0x02, 0x01, 0x2F, 0x45, 0x32, 0x01, 0xB0, 0xC9, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x3B, 0x40, 0x3E, 0x01, 0xB2, 0xC2, // "ŉ" (U+0149)
  0x01, 0x4A, 0x02, 0xEC, 0x38, 0x40, 0x3B, 0x01, 0xB4, 0xEC, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x02, 0xEC, 0x29, 0x31, 0x31, 0x01, 0xB7, 0xE2, // "ŋ" (U+014B)
  0x01, 0x4C, 0x04, 0x00, 0x35, 0x4B, 0x3A, 0x01, 0xB9, 0xC0, // "Ō" (U+014C)
  0x01, 0x4D, 0x04, 0x00, 0x28, 0x3C, 0x2D, 0x01, 0xBC, 0x08, // "ō" (U+014D)
  0x01, 0x4E, 0x04, 0x00, 0x35, 0x51, 0x3A, 0x01, 0xBD, 0x82, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x04, 0x00, 0x28, 0x42, 0x2D, 0x01, 0xC0, 0x0A, // "ŏ" (U+014F)
  0x01, 0x50, 0x04, 0x00, 0x35, 0x53, 0x3A, 0x01, 0xC1, 0xBF, // "Ő" (U+0150)
  0x01, 0x51, 0x04, 0x00, 0x28, 0x44, 0x2D, 0x01, 0xC4, 0x60, // "ő" (U+0151)
  0x01, 0x52, 0x04, 0x00, 0x47, 0x41, 0x4B, 0x01, 0xC6, 0x2B, // "Œ" (U+0152)
  0x01, 0x53, 0x04, 0x00, 0x42, 0x31, 0x46, 0x01, 0xC8, 0xD1, // "œ" (U+0153)
  0x01, 0x54, 0x02, 0x01, 0x33, 0x54, 0x33, 0x01, 0xCB, 0x0A, // "Ŕ" (U+0154)
  0x01, 0x55, 0x02, 0x01, 0x23, 0x45, 0x25, 0x01, 0xCD, 0x79, // "ŕ" (U+0155)
  0x01, 0x56, 0x02, 0xED, 0x33, 0x40, 0x33, 0x01, 0xCE, 0xD8, // "Ŗ" (U+0156)
  0x01, 0x57, 0x02, 0xED, 0x23, 0x31, 0x25, 0x01, 0xD1, 0x3B, // "ŗ" (U+0157)
  0x01, 0x58, 0x02, 0x01, 0x33, 0x54, 0x33, 0x01, 0xD2, 0x90, // "Ř" (U+0158)
  0x01, 0x59, 0x02, 0x01, 0x23, 0x45, 0x25, 0x01, 0xD5, 0x22, // "ř" (U+0159)
  0x01, 0x5A, 0x03, 0x00, 0x26, 0x54, 0x2A, 0x01, 0xD6, 0x9E, // "Ś" (U+015A)
  0x01, 0x5B, 0x03, 0x00, 0x1F, 0x45, 0x23, 0x01, 0xD8, 0x8B, // "ś" (U+015B)
  0x01, 0x5C, 0x03, 0x00, 0x26, 0x54, 0x2A, 0x01, 0xDA, 0x04, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x03, 0x00, 0x1F, 0x45, 0x23, 0x01, 0xDC, 0x0B, // "ŝ" (U+015D)
  0x01, 0x5E, 0x03, 0xEC, 0x26, 0x41, 0x2A, 0x01, 0xDD, 0x9E, // "Ş" (U+015E)
  0x01, 0x5F, 0x03, 0xEC, 0x1F, 0x31, 0x23, 0x01, 0xDF, 0xAC, // "ş" (U+015F)
  0x01, 0x60, 0x03, 0x00, 0x26, 0x54, 0x2A, 0x01, 0xE1, 0x43, // "Š" (U+0160)
  0x01, 0x61, 0x03, 0x00, 0x1F, 0x45, 0x23, 0x01, 0xE3, 0x4D, // "š" (U+0161)
  0x01, 0x62, 0x01, 0xEB, 0x2E, 0x40, 0x30, 0x01, 0xE4, 0xE3, // "Ţ" (U+0162)
  0x01, 0x63, 0x01, 0xEB, 0x1A, 0x3B, 0x1C, 0x01, 0xE6, 0xD1, // "ţ" (U+0163)
  0x01, 0x64, 0x01, 0x01, 0x2E, 0x54, 0x30, 0x01, 0xE8, 0x3B, // "Ť" (U+0164)
  0x01, 0x65, 0x01, 0x00, 0x1D, 0x44, 0x1C, 0x01, 0xEA, 0x1C, // "ť" (U+0165)
  0x01, 0x66, 0x01, 0x01, 0x2E, 0x40, 0x30, 0x01, 0xEB, 0x59, // "Ŧ" (U+0166)
  0x01, 0x67, 0x01, 0x00, 0x1A, 0x3B, 0x1C, 0x01, 0xEC, 0xCE, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x00, 0x36, 0x50, 0x37, 0x01, 0xED, 0xD1, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x00, 0x2F, 0x41, 0x31, 0x01, 0xF0, 0x41, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x00, 0x36, 0x4B, 0x37, 0x01, 0xF2, 0x08, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x00, 0x2F, 0x3C, 0x31, 0x01, 0xF4, 0x2D, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x00, 0x36, 0x51, 0x37, 0x01, 0xF5, 0xAB, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x00, 0x2F, 0x42, 0x31, 0x01, 0xF8, 0x10, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x00, 0x36, 0x59, 0x37, 0x01, 0xF9, 0xCD, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x00, 0x2F, 0x4A, 0x31, 0x01, 0xFC, 0x73, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x00, 0x36, 0x53, 0x37, 0x01, 0xFE, 0x71, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x00, 0x2F, 0x44, 0x31, 0x02, 0x00, 0xF2, // "ű" (U+0171)
  0x01, 0x72, 0x02, 0xEB, 0x37, 0x40, 0x37, 0x02, 0x02, 0xC8, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xEC, 0x2F, 0x30, 0x31, 0x02, 0x05, 0x44, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x50, 0x54, 0x51, 0x02, 0x07, 0x1F, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x42, 0x45, 0x42, 0x02, 0x0A, 0xE9, // "ŵ" (U+0175)
  0x01, 0x76, 0xFF, 0x01, 0x31, 0x54, 0x31, 0x02, 0x0D, 0xAC, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xEC, 0x2B, 0x45, 0x2C, 0x02, 0x0F, 0xDE, // "ŷ" (U+0177)
  0x01, 0x78, 0xFF, 0x01, 0x31, 0x52, 0x31, 0x02, 0x12, 0x25, // "Ÿ" (U+0178)
  0x01, 0x79, 0x02, 0x01, 0x2B, 0x54, 0x2E, 0x02, 0x14, 0x3C, // "Ź" (U+0179)
  0x01, 0x7A, 0x03, 0x01, 0x23, 0x45, 0x28, 0x02, 0x16, 0x2D, // "ź" (U+017A)
  0x01, 0x7B, 0x02, 0x01, 0x2B, 0x53, 0x2E, 0x02, 0x17, 0x94, // "Ż" (U+017B)
  0x01, 0x7C, 0x03, 0x01, 0x23, 0x44, 0x28, 0x02, 0x19, 0x72, // "ż" (U+017C)
  0x01, 0x7D, 0x02, 0x01, 0x2B, 0x54, 0x2E, 0x02, 0x1A, 0xC9, // "Ž" (U+017D)
  0x01, 0x7E, 0x03, 0x01, 0x23, 0x45, 0x28, 0x02, 0x1C, 0xD7, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x21, 0x46, 0x1C, 0x02, 0x1E, 0x5A, // "ſ" (U+017F)
  0x03, 0xA9, 0x03, 0x01, 0x37, 0x41, 0x3B, 0x02, 0x1F, 0xBB, // "Ω" (U+03A9)
  0x03, 0xBC, 0x06, 0xEC, 0x2D, 0x30, 0x30, 0x02, 0x22, 0x30, // "μ" (U+03BC)
  0x03, 0xC0, 0x02, 0x00, 0x2E, 0x30, 0x31, 0x02, 0x24, 0x13, // "π" (U+03C0)
  0x20, 0x13, 0xFF, 0x17, 0x2D, 0x1B, 0x2D, 0x02, 0x25, 0x89, // "–" (U+2013)
  0x20, 0x14, 0xFF, 0x17, 0x5A, 0x1B, 0x5A, 0x02, 0x25, 0x9E, // "—" (U+2014)
  0x20, 0xAC, 0x02, 0x00, 0x28, 0x41, 0x2B, 0x02, 0x25, 0xB6, // "€" (U+20AC)
  0x20, 0xBF, 0x03, 0xFA, 0x27, 0x46, 0x2B, 0x02, 0x27, 0x47, // "₿" (U+20BF)
  0x20, 0x18, 0x04, 0x28, 0x11, 0x40, 0x14, 0x02, 0x29, 0x56, // "‘" (U+2018)
  0x20, 0x19, 0x02, 0x27, 0x0F, 0x40, 0x14, 0x02, 0x29, 0xB3, // "’" (U+2019)
  0x20, 0x1A, 0x02, 0xF2, 0x0F, 0x0B, 0x14, 0x02, 0x2A, 0x14, // "‚" (U+201A)
  0x20, 0x1B, 0x04, 0x28, 0x11, 0x40, 0x14, 0x02, 0x2A, 0x75, // "‛" (U+201B)
  0x20, 0x1C, 0x05, 0x28, 0x1F, 0x40, 0x23, 0x02, 0x2A, 0xD3, // "“" (U+201C)
  0x20, 0x1D, 0x03, 0x27, 0x1D, 0x40, 0x23, 0x02, 0x2B, 0x8B, // "”" (U+201D)
  0x20, 0x1E, 0x03, 0xF2, 0x1D, 0x0B, 0x23, 0x02, 0x2C, 0x49, // "„" (U+201E)
  0x20, 0x1F, 0x04, 0x27, 0x20, 0x40, 0x23, 0x02, 0x2D, 0x07, // "‟" (U+201F)
  0x20, 0x20, 0x02, 0xF7, 0x20, 0x44, 0x23, 0x02, 0x2D, 0xC8, // "†" (U+2020)
  0x20, 0x21, 0x02, 0xF7, 0x20, 0x44, 0x23, 0x02, 0x2F, 0x42, // "‡" (U+2021)
  0x20, 0x22, 0x03, 0x14, 0x18, 0x2D, 0x1C, 0x02, 0x30, 0xE8, // "•" (U+2022)
  0x20, 0x26, 0x08, 0x00, 0x3B, 0x0B, 0x43, 0x02, 0x31, 0x59, // "…" (U+2026)
  0x20, 0x30, 0x03, 0x00, 0x60, 0x41, 0x63, 0x02, 0x31, 0xD9, // "‰" (U+2030)
  0x20, 0x39, 0x05, 0x08, 0x14, 0x29, 0x1A, 0x02, 0x36, 0x00, // "‹" (U+2039)
  0x20, 0x3A, 0x05, 0x08, 0x14, 0x29, 0x1A, 0x02, 0x36, 0x7B, // "›" (U+203A)
  0x20, 0x44, 0xF2, 0x01, 0x12, 0x40, 0x05, 0x02, 0x36, 0xF4, // "⁄" (U+2044)
  0x21, 0x22, 0x01, 0x22, 0x3D, 0x40, 0x40, 0x02, 0x38, 0x18, // "™" (U+2122)
  0x21, 0x52, 0x03, 0x00, 0x57, 0x41, 0x5A, 0x02, 0x39, 0xF8, // "⅒" (U+2152)
  0xFB, 0x01, 0x02, 0x01, 0x32, 0x46, 0x34, 0x02, 0x3D, 0x88, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x02, 0x01, 0x32, 0x46, 0x34, 0x02, 0x3F, 0x77, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x07, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x02, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x02, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x02, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x04, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6F, 0x02, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x02, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x07, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x07, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x07, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x07, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x07, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x07, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x0B, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE7, 0x02, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x02, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x02, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x02, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x02, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF0, 0x02, // "ð (U+0022 U+00F0)
  0x00, 0x22, 0x00, 0xF2, 0x02, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x02, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x02, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x02, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x02, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x02, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x07, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x07, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x07, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x02, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x02, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x02, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x02, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x02, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x02, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x02, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x02, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x02, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x02, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x02, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x02, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x02, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x02, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x02, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x4D, 0x02, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x02, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x02, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x02, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x3F, 0x03, // &? (U+0026 U+003F)
  0x00, 0x26, 0x00, 0x54, 0x03, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x04, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x04, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x03, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x03, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x03, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x03, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x03, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x04, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x03, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x03, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x07, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x02, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x02, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x02, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x04, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6F, 0x02, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x02, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x07, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x07, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x07, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x07, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x07, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x07, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x0B, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE7, 0x02, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x02, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x02, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x02, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x02, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF0, 0x02, // 'ð (U+0027 U+00F0)
  0x00, 0x27, 0x00, 0xF2, 0x02, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x02, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x02, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x02, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x02, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x02, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x07, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x07, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x07, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x02, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x02, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x02, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x02, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x02, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x02, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x02, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x02, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x02, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x02, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x02, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x02, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x02, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x02, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x02, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x4D, 0x02, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x02, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x02, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x02, // 'œ (U+0027 U+0153)
  0x00, 0x2A, 0x00, 0x26, 0x01, // *& (U+002A U+0026)
  0x00, 0x2A, 0x00, 0x2C, 0x09, // *, (U+002A U+002C)
  0x00, 0x2A, 0x00, 0x2E, 0x09, // *. (U+002A U+002E)
  0x00, 0x2A, 0x00, 0x41, 0x05, // *A (U+002A U+0041)
  0x00, 0x2A, 0x00, 0xC0, 0x05, // *À (U+002A U+00C0)
  0x00, 0x2A, 0x00, 0xC1, 0x05, // *Á (U+002A U+00C1)
  0x00, 0x2A, 0x00, 0xC2, 0x05, // *Â (U+002A U+00C2)
  0x00, 0x2A, 0x00, 0xC3, 0x05, // *Ã (U+002A U+00C3)
  0x00, 0x2A, 0x00, 0xC4, 0x05, // *Ä (U+002A U+00C4)
  0x00, 0x2A, 0x00, 0xC5, 0x05, // *Å (U+002A U+00C5)
  0x00, 0x2A, 0x00, 0xC6, 0x07, // *Æ (U+002A U+00C6)
  0x00, 0x2A, 0x01, 0x00, 0x05, // *Ā (U+002A U+0100)
  0x00, 0x2A, 0x01, 0x02, 0x05, // *Ă (U+002A U+0102)
  0x00, 0x2A, 0x01, 0x04, 0x05, // *Ą (U+002A U+0104)
  0x00, 0x2A, 0x20, 0x1A, 0x09, // *‚ (U+002A U+201A)
  0x00, 0x2A, 0x20, 0x1E, 0x09, // *„ (U+002A U+201E)
  0x00, 0x2A, 0x20, 0x26, 0x09, // *… (U+002A U+2026)
  0x00, 0x2C, 0x00, 0x3F, 0x06, // ,? (U+002C U+003F)
  0x00, 0x2C, 0x00, 0x43, 0x02, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x02, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x02, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x02, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x06, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x55, 0x02, // ,U (U+002C U+0055)
  0x00, 0x2C, 0x00, 0x56, 0x09, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x07, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x06, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0x75, 0x01, // ,u (U+002C U+0075)
  0x00, 0x2C, 0x00, 0x76, 0x06, // ,v (U+002C U+0076)
  0x00, 0x2C, 0x00, 0x77, 0x05, // ,w (U+002C U+0077)
  0x00, 0x2C, 0x00, 0x79, 0x05, // ,y (U+002C U+0079)
  0x00, 0x2C, 0x00, 0xC7, 0x02, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x02, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x02, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x02, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x02, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x02, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x02, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xD9, 0x02, // ,Ù (U+002C U+00D9)
  0x00, 0x2C, 0x00, 0xDA, 0x02, // ,Ú (U+002C U+00DA)
  0x00, 0x2C, 0x00, 0xDB, 0x02, // ,Û (U+002C U+00DB)
  0x00, 0x2C, 0x00, 0xDC, 0x02, // ,Ü (U+002C U+00DC)
  0x00, 0x2C, 0x00, 0xDD, 0x06, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x00, 0xF9, 0x01, // ,ù (U+002C U+00F9)
  0x00, 0x2C, 0x00, 0xFA, 0x01, // ,ú (U+002C U+00FA)
  0x00, 0x2C, 0x00, 0xFB, 0x01, // ,û (U+002C U+00FB)
  0x00, 0x2C, 0x00, 0xFC, 0x01, // ,ü (U+002C U+00FC)
  0x00, 0x2C, 0x00, 0xFD, 0x05, // ,ý (U+002C U+00FD)
  0x00, 0x2C, 0x00, 0xFF, 0x05, // ,ÿ (U+002C U+00FF)
  0x00, 0x2C, 0x01, 0x06, 0x02, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x02, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x02, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x02, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x02, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x02, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x02, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x02, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x02, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x02, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x02, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x02, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x06, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x06, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x06, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x68, 0x02, // ,Ũ (U+002C U+0168)
  0x00, 0x2C, 0x01, 0x69, 0x01, // ,ũ (U+002C U+0169)
  0x00, 0x2C, 0x01, 0x6A, 0x02, // ,Ū (U+002C U+016A)
  0x00, 0x2C, 0x01, 0x6B, 0x01, // ,ū (U+002C U+016B)
  0x00, 0x2C, 0x01, 0x6C, 0x02, // ,Ŭ (U+002C U+016C)
  0x00, 0x2C, 0x01, 0x6D, 0x01, // ,ŭ (U+002C U+016D)
  0x00, 0x2C, 0x01, 0x6E, 0x02, // ,Ů (U+002C U+016E)
  0x00, 0x2C, 0x01, 0x6F, 0x01, // ,ů (U+002C U+016F)
  0x00, 0x2C, 0x01, 0x70, 0x02, // ,Ű (U+002C U+0170)
  0x00, 0x2C, 0x01, 0x71, 0x01, // ,ű (U+002C U+0171)
  0x00, 0x2C, 0x01, 0x72, 0x02, // ,Ų (U+002C U+0172)
  0x00, 0x2C, 0x01, 0x73, 0x01, // ,ų (U+002C U+0173)
  0x00, 0x2C, 0x01, 0x74, 0x07, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x75, 0x05, // ,ŵ (U+002C U+0175)
  0x00, 0x2C, 0x01, 0x76, 0x06, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x77, 0x05, // ,ŷ (U+002C U+0177)
  0x00, 0x2C, 0x01, 0x78, 0x06, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x3F, 0x06, // .? (U+002E U+003F)
  0x00, 0x2E, 0x00, 0x43, 0x02, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x02, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x02, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x02, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x06, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x55, 0x02, // .U (U+002E U+0055)
  0x00, 0x2E, 0x00, 0x56, 0x09, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x07, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x06, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0x75, 0x01, // .u (U+002E U+0075)
  0x00, 0x2E, 0x00, 0x76, 0x06, // .v (U+002E U+0076)
  0x00, 0x2E, 0x00, 0x77, 0x05, // .w (U+002E U+0077)
  0x00, 0x2E, 0x00, 0x79, 0x05, // .y (U+002E U+0079)
  0x00, 0x2E, 0x00, 0xC7, 0x02, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x02, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x02, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x02, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x02, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x02, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x02, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xD9, 0x02, // .Ù (U+002E U+00D9)
  0x00, 0x2E, 0x00, 0xDA, 0x02, // .Ú (U+002E U+00DA)
  0x00, 0x2E, 0x00, 0xDB, 0x02, // .Û (U+002E U+00DB)
  0x00, 0x2E, 0x00, 0xDC, 0x02, // .Ü (U+002E U+00DC)
  0x00, 0x2E, 0x00, 0xDD, 0x06, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x00, 0xF9, 0x01, // .ù (U+002E U+00F9)
  0x00, 0x2E, 0x00, 0xFA, 0x01, // .ú (U+002E U+00FA)
  0x00, 0x2E, 0x00, 0xFB, 0x01, // .û (U+002E U+00FB)
  0x00, 0x2E, 0x00, 0xFC, 0x01, // .ü (U+002E U+00FC)
  0x00, 0x2E, 0x00, 0xFD, 0x05, // .ý (U+002E U+00FD)
  0x00, 0x2E, 0x00, 0xFF, 0x05, // .ÿ (U+002E U+00FF)
  0x00, 0x2E, 0x01, 0x06, 0x02, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x02, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x02, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x02, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x02, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x02, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x02, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x02, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x02, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x02, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x02, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x02, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x06, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x06, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x06, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x68, 0x02, // .Ũ (U+002E U+0168)
  0x00, 0x2E, 0x01, 0x69, 0x01, // .ũ (U+002E U+0169)
  0x00, 0x2E, 0x01, 0x6A, 0x02, // .Ū (U+002E U+016A)
  0x00, 0x2E, 0x01, 0x6B, 0x01, // .ū (U+002E U+016B)
  0x00, 0x2E, 0x01, 0x6C, 0x02, // .Ŭ (U+002E U+016C)
  0x00, 0x2E, 0x01, 0x6D, 0x01, // .ŭ (U+002E U+016D)
  0x00, 0x2E, 0x01, 0x6E, 0x02, // .Ů (U+002E U+016E)
  0x00, 0x2E, 0x01, 0x6F, 0x01, // .ů (U+002E U+016F)
  0x00, 0x2E, 0x01, 0x70, 0x02, // .Ű (U+002E U+0170)
  0x00, 0x2E, 0x01, 0x71, 0x01, // .ű (U+002E U+0171)
  0x00, 0x2E, 0x01, 0x72, 0x02, // .Ų (U+002E U+0172)
  0x00, 0x2E, 0x01, 0x73, 0x01, // .ų (U+002E U+0173)
  0x00, 0x2E, 0x01, 0x74, 0x07, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x75, 0x05, // .ŵ (U+002E U+0175)
  0x00, 0x2E, 0x01, 0x76, 0x06, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x77, 0x05, // .ŷ (U+002E U+0177)
  0x00, 0x2E, 0x01, 0x78, 0x06, // .Ÿ (U+002E U+0178)
  0x00, 0x40, 0x00, 0x41, 0x03, // @A (U+0040 U+0041)
  0x00, 0x40, 0x00, 0x59, 0x01, // @Y (U+0040 U+0059)
  0x00, 0x40, 0x00, 0xC0, 0x03, // @À (U+0040 U+00C0)
  0x00, 0x40, 0x00, 0xC1, 0x03, // @Á (U+0040 U+00C1)
  0x00, 0x40, 0x00, 0xC2, 0x03, // @Â (U+0040 U+00C2)
  0x00, 0x40, 0x00, 0xC3, 0x03, // @Ã (U+0040 U+00C3)
  0x00, 0x40, 0x00, 0xC4, 0x03, // @Ä (U+0040 U+00C4)
  0x00, 0x40, 0x00, 0xC5, 0x03, // @Å (U+0040 U+00C5)
  0x00, 0x40, 0x00, 0xDD, 0x01, // @Ý (U+0040 U+00DD)
  0x00, 0x40, 0x01, 0x00, 0x03, // @Ā (U+0040 U+0100)
  0x00, 0x40, 0x01, 0x02, 0x03, // @Ă (U+0040 U+0102)
  0x00, 0x40, 0x01, 0x04, 0x03, // @Ą (U+0040 U+0104)
  0x00, 0x40, 0x01, 0x76, 0x01, // @Ŷ (U+0040 U+0176)
  0x00, 0x40, 0x01, 0x78, 0x01, // @Ÿ (U+0040 U+0178)
  0x00, 0x41, 0x00, 0x22, 0x07, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x07, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x2A, 0x06, // A* (U+0041 U+002A)
  0x00, 0x41, 0x00, 0x3F, 0x05, // A? (U+0041 U+003F)
  0x00, 0x41, 0x00, 0x43, 0x02, // AC (U+0041 U+0043)
  0x00, 0x41, 0x00, 0x47, 0x02, // AG (U+0041 U+0047)
  0x00, 0x41, 0x00, 0x4F, 0x02, // AO (U+0041 U+004F)
  0x00, 0x41, 0x00, 0x51, 0x02, // AQ (U+0041 U+0051)
  0x00, 0x41, 0x00, 0x54, 0x05, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x55, 0x02, // AU (U+0041 U+0055)
  0x00, 0x41, 0x00, 0x56, 0x06, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x05, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x04, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0x63, 0x02, // Ac (U+0041 U+0063)
  0x00, 0x41, 0x00, 0x64, 0x02, // Ad (U+0041 U+0064)
  0x00, 0x41, 0x00, 0x65, 0x02, // Ae (U+0041 U+0065)
  0x00, 0x41, 0x00, 0x67, 0x02, // Ag (U+0041 U+0067)
  0x00, 0x41, 0x00, 0x6F, 0x02, // Ao (U+0041 U+006F)
  0x00, 0x41, 0x00, 0x71, 0x02, // Aq (U+0041 U+0071)
  0x00, 0x41, 0x00, 0x75, 0x02, // Au (U+0041 U+0075)
  0x00, 0x41, 0x00, 0x76, 0x04, // Av (U+0041 U+0076)
  0x00, 0x41, 0x00, 0x77, 0x03, // Aw (U+0041 U+0077)
  0x00, 0x41, 0x00, 0x79, 0x05, // Ay (U+0041 U+0079)
  0x00, 0x41, 0x00, 0xC7, 0x02, // AÇ (U+0041 U+00C7)
  0x00, 0x41, 0x00, 0xD2, 0x02, // AÒ (U+0041 U+00D2)
  0x00, 0x41, 0x00, 0xD3, 0x02, // AÓ (U+0041 U+00D3)
  0x00, 0x41, 0x00, 0xD4, 0x02, // AÔ (U+0041 U+00D4)
  0x00, 0x41, 0x00, 0xD5, 0x02, // AÕ (U+0041 U+00D5)
  0x00, 0x41, 0x00, 0xD6, 0x02, // AÖ (U+0041 U+00D6)
  0x00, 0x41, 0x00, 0xD8, 0x02, // AØ (U+0041 U+00D8)
  0x00, 0x41, 0x00, 0xD9, 0x02, // AÙ (U+0041 U+00D9)
  0x00, 0x41, 0x00, 0xDA, 0x02, // AÚ (U+0041 U+00DA)
  0x00, 0x41, 0x00, 0xDB, 0x02, // AÛ (U+0041 U+00DB)
  0x00, 0x41, 0x00, 0xDC, 0x02, // AÜ (U+0041 U+00DC)
  0x00, 0x41, 0x00, 0xDD, 0x04, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x00, 0xE7, 0x02, // Aç (U+0041 U+00E7)
  0x00, 0x41, 0x00, 0xE8, 0x02, // Aè (U+0041 U+00E8)
  0x00, 0x41, 0x00, 0xE9, 0x02, // Aé (U+0041 U+00E9)
  0x00, 0x41, 0x00, 0xEA, 0x02, // Aê (U+0041 U+00EA)
  0x00, 0x41, 0x00, 0xEB, 0x02, // Aë (U+0041 U+00EB)
  0x00, 0x41, 0x00, 0xF0, 0x02, // Að (U+0041 U+00F0)
  0x00, 0x41, 0x00, 0xF2, 0x02, // Aò (U+0041 U+00F2)
  0x00, 0x41, 0x00, 0xF3, 0x02, // Aó (U+0041 U+00F3)
  0x00, 0x41, 0x00, 0xF4, 0x02, // Aô (U+0041 U+00F4)
  0x00, 0x41, 0x00, 0xF5, 0x02, // Aõ (U+0041 U+00F5)
  0x00, 0x41, 0x00, 0xF6, 0x02, // Aö (U+0041 U+00F6)
  0x00, 0x41, 0x00, 0xF8, 0x02, // Aø (U+0041 U+00F8)
  0x00, 0x41, 0x00, 0xF9, 0x02, // Aù (U+0041 U+00F9)
  0x00, 0x41, 0x00, 0xFA, 0x02, // Aú (U+0041 U+00FA)
  0x00, 0x41, 0x00, 0xFB, 0x02, // Aû (U+0041 U+00FB)
  0x00, 0x41, 0x00, 0xFC, 0x02, // Aü (U+0041 U+00FC)
  0x00, 0x41, 0x00, 0xFD, 0x05, // Aý (U+0041 U+00FD)
  0x00, 0x41, 0x00, 0xFF, 0x05, // Aÿ (U+0041 U+00FF)
  0x00, 0x41, 0x01, 0x06, 0x02, // AĆ (U+0041 U+0106)
  0x00, 0x41, 0x01, 0x07, 0x02, // Ać (U+0041 U+0107)
  0x00, 0x41, 0x01, 0x08, 0x02, // AĈ (U+0041 U+0108)
  0x00, 0x41, 0x01, 0x09, 0x02, // Aĉ (U+0041 U+0109)
  0x00, 0x41, 0x01, 0x0A, 0x02, // AĊ (U+0041 U+010A)
  0x00, 0x41, 0x01, 0x0B, 0x02, // Aċ (U+0041 U+010B)
  0x00, 0x41, 0x01, 0x0C, 0x02, // AČ (U+0041 U+010C)
  0x00, 0x41, 0x01, 0x0D, 0x02, // Ač (U+0041 U+010D)
  0x00, 0x41, 0x01, 0x0F, 0x02, // Aď (U+0041 U+010F)
  0x00, 0x41, 0x01, 0x11, 0x02, // Ađ (U+0041 U+0111)
  0x00, 0x41, 0x01, 0x13, 0x02, // Aē (U+0041 U+0113)
  0x00, 0x41, 0x01, 0x15, 0x02, // Aĕ (U+0041 U+0115)
  0x00, 0x41, 0x01, 0x17, 0x02, // Aė (U+0041 U+0117)
  0x00, 0x41, 0x01, 0x19, 0x02, // Aę (U+0041 U+0119)
  0x00, 0x41, 0x01, 0x1B, 0x02, // Aě (U+0041 U+011B)
  0x00, 0x41, 0x01, 0x1C, 0x02, // AĜ (U+0041 U+011C)
  0x00, 0x41, 0x01, 0x1D, 0x02, // Aĝ (U+0041 U+011D)
  0x00, 0x41, 0x01, 0x1E, 0x02, // AĞ (U+0041 U+011E)
  0x00, 0x41, 0x01, 0x1F, 0x02, // Ağ (U+0041 U+011F)
  0x00, 0x41, 0x01, 0x20, 0x02, // AĠ (U+0041 U+0120)
  0x00, 0x41, 0x01, 0x21, 0x02, // Aġ (U+0041 U+0121)
  0x00, 0x41, 0x01, 0x22, 0x02, // AĢ (U+0041 U+0122)
  0x00, 0x41, 0x01, 0x23, 0x02, // Aģ (U+0041 U+0123)
  0x00, 0x41, 0x01, 0x4C, 0x02, // AŌ (U+0041 U+014C)
  0x00, 0x41, 0x01, 0x4D, 0x02, // Aō (U+0041 U+014D)
  0x00, 0x41, 0x01, 0x4E, 0x02, // AŎ (U+0041 U+014E)
  0x00, 0x41, 0x01, 0x4F, 0x02, // Aŏ (U+0041 U+014F)
  0x00, 0x41, 0x01, 0x50, 0x02, // AŐ (U+0041 U+0150)
  0x00, 0x41, 0x01, 0x51, 0x02, // Aő (U+0041 U+0151)
  0x00, 0x41, 0x01, 0x52, 0x02, // AŒ (U+0041 U+0152)
  0x00, 0x41, 0x01, 0x53, 0x02, // Aœ (U+0041 U+0153)
  0x00, 0x41, 0x01, 0x62, 0x05, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x05, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x05, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x68, 0x02, // AŨ (U+0041 U+0168)
  0x00, 0x41, 0x01, 0x69, 0x02, // Aũ (U+0041 U+0169)
  0x00, 0x41, 0x01, 0x6A, 0x02, // AŪ (U+0041 U+016A)
  0x00, 0x41, 0x01, 0x6B, 0x02, // Aū (U+0041 U+016B)
  0x00, 0x41, 0x01, 0x6C, 0x02, // AŬ (U+0041 U+016C)
  0x00, 0x41, 0x01, 0x6D, 0x02, // Aŭ (U+0041 U+016D)
  0x00, 0x41, 0x01, 0x6E, 0x02, // AŮ (U+0041 U+016E)
  0x00, 0x41, 0x01, 0x6F, 0x02, // Aů (U+0041 U+016F)
  0x00, 0x41, 0x01, 0x70, 0x02, // AŰ (U+0041 U+0170)
  0x00, 0x41, 0x01, 0x71, 0x02, // Aű (U+0041 U+0171)
  0x00, 0x41, 0x01, 0x72, 0x02, // AŲ (U+0041 U+0172)
  0x00, 0x41, 0x01, 0x73, 0x02, // Aų (U+0041 U+0173)
  0x00, 0x41, 0x01, 0x74, 0x05, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x75, 0x03, // Aŵ (U+0041 U+0175)
  0x00, 0x41, 0x01, 0x76, 0x04, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x77, 0x05, // Aŷ (U+0041 U+0177)
  0x00, 0x41, 0x01, 0x78, 0x04, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x18, 0x06, // A‘ (U+0041 U+2018)
  0x00, 0x41, 0x20, 0x19, 0x06, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1C, 0x06, // A“ (U+0041 U+201C)
  0x00, 0x41, 0x20, 0x1D, 0x06, // A” (U+0041 U+201D)
  0x00, 0x41, 0x21, 0x22, 0x06, // A™ (U+0041 U+2122)
  0x00, 0x42, 0x00, 0x2A, 0x01, // B* (U+0042 U+002A)
  0x00, 0x42, 0x00, 0x3F, 0x01, // B? (U+0042 U+003F)
  0x00, 0x42, 0x00, 0x41, 0x01, // BA (U+0042 U+0041)
  0x00, 0x42, 0x00, 0x54, 0x01, // BT (U+0042 U+0054)
  0x00, 0x42, 0x00, 0x56, 0x03, // BV (U+0042 U+0056)
  0x00, 0x42, 0x00, 0x57, 0x02, // BW (U+0042 U+0057)
  0x00, 0x42, 0x00, 0x58, 0x01, // BX (U+0042 U+0058)
  0x00, 0x42, 0x00, 0x59, 0x03, // BY (U+0042 U+0059)
  0x00, 0x42, 0x00, 0x5A, 0x01, // BZ (U+0042 U+005A)
  0x00, 0x42, 0x00, 0x77, 0x01, // Bw (U+0042 U+0077)
  0x00, 0x42, 0x00, 0x79, 0x02, // By (U+0042 U+0079)
  0x00, 0x42, 0x00, 0xC0, 0x01, // BÀ (U+0042 U+00C0)
  0x00, 0x42, 0x00, 0xC1, 0x01, // BÁ (U+0042 U+00C1)
  0x00, 0x42, 0x00, 0xC2, 0x01, // BÂ (U+0042 U+00C2)
  0x00, 0x42, 0x00, 0xC3, 0x01, // BÃ (U+0042 U+00C3)
  0x00, 0x42, 0x00, 0xC4, 0x01, // BÄ (U+0042 U+00C4)
  0x00, 0x42, 0x00, 0xC5, 0x01, // BÅ (U+0042 U+00C5)
  0x00, 0x42, 0x00, 0xC6, 0x03, // BÆ (U+0042 U+00C6)
  0x00, 0x42, 0x00, 0xDD, 0x03, // BÝ (U+0042 U+00DD)
  0x00, 0x42, 0x00, 0xFD, 0x02, // Bý (U+0042 U+00FD)
  0x00, 0x42, 0x00, 0xFF, 0x02, // Bÿ (U+0042 U+00FF)
  0x00, 0x42, 0x01, 0x00, 0x01, // BĀ (U+0042 U+0100)
  0x00, 0x42, 0x01, 0x02, 0x01, // BĂ (U+0042 U+0102)
  0x00, 0x42, 0x01, 0x04, 0x01, // BĄ (U+0042 U+0104)
  0x00, 0x42, 0x01, 0x62, 0x01, // BŢ (U+0042 U+0162)
  0x00, 0x42, 0x01, 0x64, 0x01, // BŤ (U+0042 U+0164)
  0x00, 0x42, 0x01, 0x66, 0x01, // BŦ (U+0042 U+0166)
  0x00, 0x42, 0x01, 0x74, 0x02, // BŴ (U+0042 U+0174)
  0x00, 0x42, 0x01, 0x75, 0x01, // Bŵ (U+0042 U+0175)
  0x00, 0x42, 0x01, 0x76, 0x03, // BŶ (U+0042 U+0176)
  0x00, 0x42, 0x01, 0x77, 0x02, // Bŷ (U+0042 U+0177)
  0x00, 0x42, 0x01, 0x78, 0x03, // BŸ (U+0042 U+0178)
  0x00, 0x42, 0x01, 0x79, 0x01, // BŹ (U+0042 U+0179)
  0x00, 0x42, 0x01, 0x7B, 0x01, // BŻ (U+0042 U+017B)
  0x00, 0x42, 0x01, 0x7D, 0x01, // BŽ (U+0042 U+017D)
  0x00, 0x42, 0x20, 0x19, 0x01, // B’ (U+0042 U+2019)
  0x00, 0x42, 0x20, 0x1D, 0x01, // B” (U+0042 U+201D)
  0x00, 0x42, 0x21, 0x22, 0x01, // B™ (U+0042 U+2122)
  0x00, 0x43, 0x00, 0x43, 0x01, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x01, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x01, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x01, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xC7, 0x01, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x01, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x01, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x01, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x01, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x01, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x01, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x01, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x01, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x01, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x01, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x01, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x01, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x01, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x01, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x01, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x01, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x01, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x01, // CŒ (U+0043 U+0152)
  0x00, 0x44, 0x00, 0x2C, 0x02, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x02, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x3F, 0x02, // D? (U+0044 U+003F)
  0x00, 0x44, 0x00, 0x41, 0x02, // DA (U+0044 U+0041)
  0x00, 0x44, 0x00, 0x54, 0x02, // DT (U+0044 U+0054)
  0x00, 0x44, 0x00, 0x56, 0x02, // DV (U+0044 U+0056)
  0x00, 0x44, 0x00, 0x57, 0x02, // DW (U+0044 U+0057)
  0x00, 0x44, 0x00, 0x58, 0x02, // DX (U+0044 U+0058)
  0x00, 0x44, 0x00, 0x59, 0x03, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0xC0, 0x02, // DÀ (U+0044 U+00C0)
  0x00, 0x44, 0x00, 0xC1, 0x02, // DÁ (U+0044 U+00C1)
  0x00, 0x44, 0x00, 0xC2, 0x02, // DÂ (U+0044 U+00C2)
  0x00, 0x44, 0x00, 0xC3, 0x02, // DÃ (U+0044 U+00C3)
  0x00, 0x44, 0x00, 0xC4, 0x02, // DÄ (U+0044 U+00C4)
  0x00, 0x44, 0x00, 0xC5, 0x02, // DÅ (U+0044 U+00C5)
  0x00, 0x44, 0x00, 0xC6, 0x05, // DÆ (U+0044 U+00C6)
  0x00, 0x44, 0x00, 0xDD, 0x03, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x00, 0x02, // DĀ (U+0044 U+0100)
  0x00, 0x44, 0x01, 0x02, 0x02, // DĂ (U+0044 U+0102)
  0x00, 0x44, 0x01, 0x04, 0x02, // DĄ (U+0044 U+0104)
  0x00, 0x44, 0x01, 0x62, 0x02, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x02, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x02, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x01, 0x74, 0x02, // DŴ (U+0044 U+0174)
  0x00, 0x44, 0x01, 0x76, 0x03, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x03, // DŸ (U+0044 U+0178)
  0x00, 0x44, 0x20, 0x1A, 0x02, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x02, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x02, // D… (U+0044 U+2026)
  0x00, 0x45, 0x00, 0x56, 0x02, // EV (U+0045 U+0056)
  0x00, 0x45, 0x00, 0x57, 0x02, // EW (U+0045 U+0057)
  0x00, 0x45, 0x00, 0x59, 0x02, // EY (U+0045 U+0059)
  0x00, 0x45, 0x00, 0xDD, 0x02, // EÝ (U+0045 U+00DD)
  0x00, 0x45, 0x01, 0x74, 0x02, // EŴ (U+0045 U+0174)
  0x00, 0x45, 0x01, 0x76, 0x02, // EŶ (U+0045 U+0176)
  0x00, 0x45, 0x01, 0x78, 0x02, // EŸ (U+0045 U+0178)
  0x00, 0x46, 0x00, 0x26, 0x02, // F& (U+0046 U+0026)
  0x00, 0x46, 0x00, 0x2C, 0x09, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x09, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x40, 0x04, // F@ (U+0046 U+0040)
  0x00, 0x46, 0x00, 0x41, 0x06, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0x61, 0x04, // Fa (U+0046 U+0061)
  0x00, 0x46, 0x00, 0x63, 0x04, // Fc (U+0046 U+0063)
  0x00, 0x46, 0x00, 0x64, 0x04, // Fd (U+0046 U+0064)
  0x00, 0x46, 0x00, 0x65, 0x04, // Fe (U+0046 U+0065)
  0x00, 0x46, 0x00, 0x67, 0x04, // Fg (U+0046 U+0067)
  0x00, 0x46, 0x00, 0x6F, 0x04, // Fo (U+0046 U+006F)
  0x00, 0x46, 0x00, 0x71, 0x04, // Fq (U+0046 U+0071)
  0x00, 0x46, 0x00, 0xC0, 0x06, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x06, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x06, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x06, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x06, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x06, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x00, 0xC6, 0x0A, // FÆ (U+0046 U+00C6)
  0x00, 0x46, 0x00, 0xE0, 0x04, // Fà (U+0046 U+00E0)
  0x00, 0x46, 0x00, 0xE1, 0x04, // Fá (U+0046 U+00E1)
  0x00, 0x46, 0x00, 0xE2, 0x04, // Fâ (U+0046 U+00E2)
  0x00, 0x46, 0x00, 0xE3, 0x04, // Fã (U+0046 U+00E3)
  0x00, 0x46, 0x00, 0xE4, 0x04, // Fä (U+0046 U+00E4)
  0x00, 0x46, 0x00, 0xE5, 0x04, // Få (U+0046 U+00E5)
  0x00, 0x46, 0x00, 0xE6, 0x04, // Fæ (U+0046 U+00E6)
  0x00, 0x46, 0x00, 0xE7, 0x04, // Fç (U+0046 U+00E7)
  0x00, 0x46, 0x00, 0xE8, 0x04, // Fè (U+0046 U+00E8)
  0x00, 0x46, 0x00, 0xE9, 0x04, // Fé (U+0046 U+00E9)
  0x00, 0x46, 0x00, 0xEA, 0x04, // Fê (U+0046 U+00EA)
  0x00, 0x46, 0x00, 0xEB, 0x04, // Fë (U+0046 U+00EB)
  0x00, 0x46, 0x00, 0xF0, 0x04, // Fð (U+0046 U+00F0)
  0x00, 0x46, 0x00, 0xF2, 0x04, // Fò (U+0046 U+00F2)
  0x00, 0x46, 0x00, 0xF3, 0x04, // Fó (U+0046 U+00F3)
  0x00, 0x46, 0x00, 0xF4, 0x04, // Fô (U+0046 U+00F4)
  0x00, 0x46, 0x00, 0xF5, 0x04, // Fõ (U+0046 U+00F5)
  0x00, 0x46, 0x00, 0xF6, 0x04, // Fö (U+0046 U+00F6)
  0x00, 0x46, 0x00, 0xF8, 0x04, // Fø (U+0046 U+00F8)
  0x00, 0x46, 0x01, 0x00, 0x06, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x01, 0x04, // Fā (U+0046 U+0101)
  0x00, 0x46, 0x01, 0x02, 0x06, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x03, 0x04, // Fă (U+0046 U+0103)
  0x00, 0x46, 0x01, 0x04, 0x06, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x01, 0x05, 0x04, // Fą (U+0046 U+0105)
  0x00, 0x46, 0x01, 0x07, 0x04, // Fć (U+0046 U+0107)
  0x00, 0x46, 0x01, 0x09, 0x04, // Fĉ (U+0046 U+0109)
  0x00, 0x46, 0x01, 0x0B, 0x04, // Fċ (U+0046 U+010B)
  0x00, 0x46, 0x01, 0x0D, 0x04, // Fč (U+0046 U+010D)
  0x00, 0x46, 0x01, 0x0F, 0x04, // Fď (U+0046 U+010F)
  0x00, 0x46, 0x01, 0x11, 0x04, // Fđ (U+0046 U+0111)
  0x00, 0x46, 0x01, 0x13, 0x04, // Fē (U+0046 U+0113)
  0x00, 0x46, 0x01, 0x15, 0x04, // Fĕ (U+0046 U+0115)
  0x00, 0x46, 0x01, 0x17, 0x04, // Fė (U+0046 U+0117)
  0x00, 0x46, 0x01, 0x19, 0x04, // Fę (U+0046 U+0119)
  0x00, 0x46, 0x01, 0x1B, 0x04, // Fě (U+0046 U+011B)
  0x00, 0x46, 0x01, 0x1D, 0x04, // Fĝ (U+0046 U+011D)
  0x00, 0x46, 0x01, 0x1F, 0x04, // Fğ (U+0046 U+011F)
  0x00, 0x46, 0x01, 0x21, 0x04, // Fġ (U+0046 U+0121)
  0x00, 0x46, 0x01, 0x23, 0x04, // Fģ (U+0046 U+0123)
  0x00, 0x46, 0x01, 0x4D, 0x04, // Fō (U+0046 U+014D)
  0x00, 0x46, 0x01, 0x4F, 0x04, // Fŏ (U+0046 U+014F)
  0x00, 0x46, 0x01, 0x51, 0x04, // Fő (U+0046 U+0151)
  0x00, 0x46, 0x01, 0x53, 0x04, // Fœ (U+0046 U+0153)
  0x00, 0x46, 0x20, 0x1A, 0x09, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x09, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x09, // F… (U+0046 U+2026)
  0x00, 0x47, 0x00, 0x3F, 0x02, // G? (U+0047 U+003F)
  0x00, 0x47, 0x00, 0x54, 0x02, // GT (U+0047 U+0054)
  0x00, 0x47, 0x00, 0x56, 0x02, // GV (U+0047 U+0056)
  0x00, 0x47, 0x00, 0x57, 0x02, // GW (U+0047 U+0057)
  0x00, 0x47, 0x00, 0x59, 0x02, // GY (U+0047 U+0059)
  0x00, 0x47, 0x00, 0xC6, 0x02, // GÆ (U+0047 U+00C6)
  0x00, 0x47, 0x00, 0xDD, 0x02, // GÝ (U+0047 U+00DD)
  0x00, 0x47, 0x01, 0x62, 0x02, // GŢ (U+0047 U+0162)
  0x00, 0x47, 0x01, 0x64, 0x02, // GŤ (U+0047 U+0164)
  0x00, 0x47, 0x01, 0x66, 0x02, // GŦ (U+0047 U+0166)
  0x00, 0x47, 0x01, 0x74, 0x02, // GŴ (U+0047 U+0174)
  0x00, 0x47, 0x01, 0x76, 0x02, // GŶ (U+0047 U+0176)
  0x00, 0x47, 0x01, 0x78, 0x02, // GŸ (U+0047 U+0178)
  0x00, 0x4B, 0x00, 0x43, 0x02, // KC (U+004B U+0043)
  0x00, 0x4B, 0x00, 0x47, 0x02, // KG (U+004B U+0047)
  0x00, 0x4B, 0x00, 0x4F, 0x02, // KO (U+004B U+004F)
  0x00, 0x4B, 0x00, 0x51, 0x02, // KQ (U+004B U+0051)
  0x00, 0x4B, 0x00, 0x63, 0x02, // Kc (U+004B U+0063)
  0x00, 0x4B, 0x00, 0x64, 0x02, // Kd (U+004B U+0064)
  0x00, 0x4B, 0x00, 0x65, 0x02, // Ke (U+004B U+0065)
  0x00, 0x4B, 0x00, 0x67, 0x02, // Kg (U+004B U+0067)
  0x00, 0x4B, 0x00, 0x6F, 0x02, // Ko (U+004B U+006F)
  0x00, 0x4B, 0x00, 0x71, 0x02, // Kq (U+004B U+0071)
  0x00, 0x4B, 0x00, 0x75, 0x02, // Ku (U+004B U+0075)
  0x00, 0x4B, 0x00, 0x77, 0x03, // Kw (U+004B U+0077)
  0x00, 0x4B, 0x00, 0x79, 0x03, // Ky (U+004B U+0079)
  0x00, 0x4B, 0x00, 0xC7, 0x02, // KÇ (U+004B U+00C7)
  0x00, 0x4B, 0x00, 0xD2, 0x02, // KÒ (U+004B U+00D2)
  0x00, 0x4B, 0x00, 0xD3, 0x02, // KÓ (U+004B U+00D3)
  0x00, 0x4B, 0x00, 0xD4, 0x02, // KÔ (U+004B U+00D4)
  0x00, 0x4B, 0x00, 0xD5, 0x02, // KÕ (U+004B U+00D5)
  0x00, 0x4B, 0x00, 0xD6, 0x02, // KÖ (U+004B U+00D6)
  0x00, 0x4B, 0x00, 0xD8, 0x02, // KØ (U+004B U+00D8)
  0x00, 0x4B, 0x00, 0xE7, 0x02, // Kç (U+004B U+00E7)
  0x00, 0x4B, 0x00, 0xE8, 0x02, // Kè (U+004B U+00E8)
  0x00, 0x4B, 0x00, 0xE9, 0x02, // Ké (U+004B U+00E9)
  0x00, 0x4B, 0x00, 0xEA, 0x02, // Kê (U+004B U+00EA)
  0x00, 0x4B, 0x00, 0xEB, 0x02, // Kë (U+004B U+00EB)
  0x00, 0x4B, 0x00, 0xF0, 0x02, // Kð (U+004B U+00F0)
  0x00, 0x4B, 0x00, 0xF2, 0x02, // Kò (U+004B U+00F2)
  0x00, 0x4B, 0x00, 0xF3, 0x02, // Kó (U+004B U+00F3)
  0x00, 0x4B, 0x00, 0xF4, 0x02, // Kô (U+004B U+00F4)
  0x00, 0x4B, 0x00, 0xF5, 0x02, // Kõ (U+004B U+00F5)
  0x00, 0x4B, 0x00, 0xF6, 0x02, // Kö (U+004B U+00F6)
  0x00, 0x4B, 0x00, 0xF8, 0x02, // Kø (U+004B U+00F8)
  0x00, 0x4B, 0x00, 0xF9, 0x02, // Kù (U+004B U+00F9)
  0x00, 0x4B, 0x00, 0xFA, 0x02, // Kú (U+004B U+00FA)
  0x00, 0x4B, 0x00, 0xFB, 0x02, // Kû (U+004B U+00FB)
  0x00, 0x4B, 0x00, 0xFC, 0x02, // Kü (U+004B U+00FC)
  0x00, 0x4B, 0x00, 0xFD, 0x03, // Ký (U+004B U+00FD)
  0x00, 0x4B, 0x00, 0xFF, 0x03, // Kÿ (U+004B U+00FF)
  0x00, 0x4B, 0x01, 0x06, 0x02, // KĆ (U+004B U+0106)
  0x00, 0x4B, 0x01, 0x07, 0x02, // Kć (U+004B U+0107)
  0x00, 0x4B, 0x01, 0x08, 0x02, // KĈ (U+004B U+0108)
  0x00, 0x4B, 0x01, 0x09, 0x02, // Kĉ (U+004B U+0109)
  0x00, 0x4B, 0x01, 0x0A, 0x02, // KĊ (U+004B U+010A)
  0x00, 0x4B, 0x01, 0x0B, 0x02, // Kċ (U+004B U+010B)
  0x00, 0x4B, 0x01, 0x0C, 0x02, // KČ (U+004B U+010C)
  0x00, 0x4B, 0x01, 0x0D, 0x02, // Kč (U+004B U+010D)
  0x00, 0x4B, 0x01, 0x0F, 0x02, // Kď (U+004B U+010F)
  0x00, 0x4B, 0x01, 0x11, 0x02, // Kđ (U+004B U+0111)
  0x00, 0x4B, 0x01, 0x13, 0x02, // Kē (U+004B U+0113)
  0x00, 0x4B, 0x01, 0x15, 0x02, // Kĕ (U+004B U+0115)
  0x00, 0x4B, 0x01, 0x17, 0x02, // Kė (U+004B U+0117)
  0x00, 0x4B, 0x01, 0x19, 0x02, // Kę (U+004B U+0119)
  0x00, 0x4B, 0x01, 0x1B, 0x02, // Kě (U+004B U+011B)
  0x00, 0x4B, 0x01, 0x1C, 0x02, // KĜ (U+004B U+011C)
  0x00, 0x4B, 0x01, 0x1D, 0x02, // Kĝ (U+004B U+011D)
  0x00, 0x4B, 0x01, 0x1E, 0x02, // KĞ (U+004B U+011E)
  0x00, 0x4B, 0x01, 0x1F, 0x02, // Kğ (U+004B U+011F)
  0x00, 0x4B, 0x01, 0x20, 0x02, // KĠ (U+004B U+0120)
  0x00, 0x4B, 0x01, 0x21, 0x02, // Kġ (U+004B U+0121)
  0x00, 0x4B, 0x01, 0x22, 0x02, // KĢ (U+004B U+0122)
  0x00, 0x4B, 0x01, 0x23, 0x02, // Kģ (U+004B U+0123)
  0x00, 0x4B, 0x01, 0x4C, 0x02, // KŌ (U+004B U+014C)
  0x00, 0x4B, 0x01, 0x4D, 0x02, // Kō (U+004B U+014D)
  0x00, 0x4B, 0x01, 0x4E, 0x02, // KŎ (U+004B U+014E)
  0x00, 0x4B, 0x01, 0x4F, 0x02, // Kŏ (U+004B U+014F)
  0x00, 0x4B, 0x01, 0x50, 0x02, // KŐ (U+004B U+0150)
  0x00, 0x4B, 0x01, 0x51, 0x02, // Kő (U+004B U+0151)
  0x00, 0x4B, 0x01, 0x52, 0x02, // KŒ (U+004B U+0152)
  0x00, 0x4B, 0x01, 0x53, 0x02, // Kœ (U+004B U+0153)
  0x00, 0x4B, 0x01, 0x69, 0x02, // Kũ (U+004B U+0169)
  0x00, 0x4B, 0x01, 0x6B, 0x02, // Kū (U+004B U+016B)
  0x00, 0x4B, 0x01, 0x6D, 0x02, // Kŭ (U+004B U+016D)
  0x00, 0x4B, 0x01, 0x6F, 0x02, // Ků (U+004B U+016F)
  0x00, 0x4B, 0x01, 0x71, 0x02, // Kű (U+004B U+0171)
  0x00, 0x4B, 0x01, 0x73, 0x02, // Kų (U+004B U+0173)
  0x00, 0x4B, 0x01, 0x75, 0x03, // Kŵ (U+004B U+0175)
  0x00, 0x4B, 0x01, 0x77, 0x03, // Kŷ (U+004B U+0177)
  0x00, 0x4C, 0x00, 0x22, 0x07, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x07, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x2A, 0x07, // L* (U+004C U+002A)
  0x00, 0x4C, 0x00, 0x3F, 0x06, // L? (U+004C U+003F)
  0x00, 0x4C, 0x00, 0x54, 0x06, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x05, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x05, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x05, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0x76, 0x02, // Lv (U+004C U+0076)
  0x00, 0x4C, 0x00, 0x77, 0x01, // Lw (U+004C U+0077)
  0x00, 0x4C, 0x00, 0x79, 0x03, // Ly (U+004C U+0079)
  0x00, 0x4C, 0x00, 0xB7, 0x02, // L· (U+004C U+00B7)
  0x00, 0x4C, 0x00, 0xDD, 0x05, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x00, 0xFD, 0x03, // Lý (U+004C U+00FD)
  0x00, 0x4C, 0x00, 0xFF, 0x03, // Lÿ (U+004C U+00FF)
  0x00, 0x4C, 0x01, 0x62, 0x06, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x06, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x06, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x05, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x75, 0x01, // Lŵ (U+004C U+0175)
  0x00, 0x4C, 0x01, 0x76, 0x05, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x77, 0x03, // Lŷ (U+004C U+0177)
  0x00, 0x4C, 0x01, 0x78, 0x05, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x18, 0x07, // L‘ (U+004C U+2018)
  0x00, 0x4C, 0x20, 0x19, 0x07, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1C, 0x07, // L“ (U+004C U+201C)
  0x00, 0x4C, 0x20, 0x1D, 0x07, // L” (U+004C U+201D)
  0x00, 0x4C, 0x21, 0x22, 0x07, // L™ (U+004C U+2122)
  0x00, 0x4E, 0x00, 0x41, 0x01, // NA (U+004E U+0041)
  0x00, 0x4E, 0x00, 0xAB, 0x01, // N« (U+004E U+00AB)
  0x00, 0x4E, 0x00, 0xBB, 0x01, // N» (U+004E U+00BB)
  0x00, 0x4E, 0x00, 0xC0, 0x01, // NÀ (U+004E U+00C0)
  0x00, 0x4E, 0x00, 0xC1, 0x01, // NÁ (U+004E U+00C1)
  0x00, 0x4E, 0x00, 0xC2, 0x01, // NÂ (U+004E U+00C2)
  0x00, 0x4E, 0x00, 0xC3, 0x01, // NÃ (U+004E U+00C3)
  0x00, 0x4E, 0x00, 0xC4, 0x01, // NÄ (U+004E U+00C4)
  0x00, 0x4E, 0x00, 0xC5, 0x01, // NÅ (U+004E U+00C5)
  0x00, 0x4E, 0x01, 0x00, 0x01, // NĀ (U+004E U+0100)
  0x00, 0x4E, 0x01, 0x02, 0x01, // NĂ (U+004E U+0102)
  0x00, 0x4E, 0x01, 0x04, 0x01, // NĄ (U+004E U+0104)
  0x00, 0x4E, 0x20, 0x39, 0x01, // N‹ (U+004E U+2039)
  0x00, 0x4E, 0x20, 0x3A, 0x01, // N› (U+004E U+203A)
  0x00, 0x4F, 0x00, 0x2C, 0x02, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x02, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x3F, 0x02, // O? (U+004F U+003F)
  0x00, 0x4F, 0x00, 0x41, 0x02, // OA (U+004F U+0041)
  0x00, 0x4F, 0x00, 0x54, 0x02, // OT (U+004F U+0054)
  0x00, 0x4F, 0x00, 0x56, 0x02, // OV (U+004F U+0056)
  0x00, 0x4F, 0x00, 0x57, 0x02, // OW (U+004F U+0057)
  0x00, 0x4F, 0x00, 0x58, 0x02, // OX (U+004F U+0058)
  0x00, 0x4F, 0x00, 0x59, 0x03, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0xC0, 0x02, // OÀ (U+004F U+00C0)
  0x00, 0x4F, 0x00, 0xC1, 0x02, // OÁ (U+004F U+00C1)
  0x00, 0x4F, 0x00, 0xC2, 0x02, // OÂ (U+004F U+00C2)
  0x00, 0x4F, 0x00, 0xC3, 0x02, // OÃ (U+004F U+00C3)
  0x00, 0x4F, 0x00, 0xC4, 0x02, // OÄ (U+004F U+00C4)
  0x00, 0x4F, 0x00, 0xC5, 0x02, // OÅ (U+004F U+00C5)
  0x00, 0x4F, 0x00, 0xC6, 0x05, // OÆ (U+004F U+00C6)
  0x00, 0x4F, 0x00, 0xDD, 0x03, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x00, 0x02, // OĀ (U+004F U+0100)
  0x00, 0x4F, 0x01, 0x02, 0x02, // OĂ (U+004F U+0102)
  0x00, 0x4F, 0x01, 0x04, 0x02, // OĄ (U+004F U+0104)
  0x00, 0x4F, 0x01, 0x62, 0x02, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x02, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x02, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x01, 0x74, 0x02, // OŴ (U+004F U+0174)
  0x00, 0x4F, 0x01, 0x76, 0x03, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x03, // OŸ (U+004F U+0178)
  0x00, 0x4F, 0x20, 0x1A, 0x02, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x02, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x02, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x26, 0x01, // P& (U+0050 U+0026)
  0x00, 0x50, 0x00, 0x2C, 0x09, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x09, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x05, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x05, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x05, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x05, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x05, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x05, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x05, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x07, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x05, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x05, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x05, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x09, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x09, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x09, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x02, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x02, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x3F, 0x02, // Q? (U+0051 U+003F)
  0x00, 0x51, 0x00, 0x41, 0x02, // QA (U+0051 U+0041)
  0x00, 0x51, 0x00, 0x54, 0x02, // QT (U+0051 U+0054)
  0x00, 0x51, 0x00, 0x56, 0x02, // QV (U+0051 U+0056)
  0x00, 0x51, 0x00, 0x57, 0x02, // QW (U+0051 U+0057)
  0x00, 0x51, 0x00, 0x58, 0x02, // QX (U+0051 U+0058)
  0x00, 0x51, 0x00, 0x59, 0x03, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0xC0, 0x02, // QÀ (U+0051 U+00C0)
  0x00, 0x51, 0x00, 0xC1, 0x02, // QÁ (U+0051 U+00C1)
  0x00, 0x51, 0x00, 0xC2, 0x02, // QÂ (U+0051 U+00C2)
  0x00, 0x51, 0x00, 0xC3, 0x02, // QÃ (U+0051 U+00C3)
  0x00, 0x51, 0x00, 0xC4, 0x02, // QÄ (U+0051 U+00C4)
  0x00, 0x51, 0x00, 0xC5, 0x02, // QÅ (U+0051 U+00C5)
  0x00, 0x51, 0x00, 0xC6, 0x05, // QÆ (U+0051 U+00C6)
  0x00, 0x51, 0x00, 0xDD, 0x03, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x00, 0x02, // QĀ (U+0051 U+0100)
  0x00, 0x51, 0x01, 0x02, 0x02, // QĂ (U+0051 U+0102)
  0x00, 0x51, 0x01, 0x04, 0x02, // QĄ (U+0051 U+0104)
  0x00, 0x51, 0x01, 0x62, 0x02, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x02, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x02, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x01, 0x74, 0x02, // QŴ (U+0051 U+0174)
  0x00, 0x51, 0x01, 0x76, 0x03, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x03, // QŸ (U+0051 U+0178)
  0x00, 0x51, 0x20, 0x1A, 0x02, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x02, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x02, // Q… (U+0051 U+2026)
  0x00, 0x52, 0x00, 0x2A, 0x01, // R* (U+0052 U+002A)
  0x00, 0x52, 0x00, 0x3F, 0x01, // R? (U+0052 U+003F)
  0x00, 0x52, 0x00, 0x43, 0x01, // RC (U+0052 U+0043)
  0x00, 0x52, 0x00, 0x47, 0x01, // RG (U+0052 U+0047)
  0x00, 0x52, 0x00, 0x4F, 0x01, // RO (U+0052 U+004F)
  0x00, 0x52, 0x00, 0x51, 0x01, // RQ (U+0052 U+0051)
  0x00, 0x52, 0x00, 0x54, 0x01, // RT (U+0052 U+0054)
  0x00, 0x52, 0x00, 0x55, 0x01, // RU (U+0052 U+0055)
  0x00, 0x52, 0x00, 0x56, 0x02, // RV (U+0052 U+0056)
  0x00, 0x52, 0x00, 0x57, 0x02, // RW (U+0052 U+0057)
  0x00, 0x52, 0x00, 0x59, 0x02, // RY (U+0052 U+0059)
  0x00, 0x52, 0x00, 0x76, 0x01, // Rv (U+0052 U+0076)
  0x00, 0x52, 0x00, 0x77, 0x01, // Rw (U+0052 U+0077)
  0x00, 0x52, 0x00, 0x79, 0x02, // Ry (U+0052 U+0079)
  0x00, 0x52, 0x00, 0xC7, 0x01, // RÇ (U+0052 U+00C7)
  0x00, 0x52, 0x00, 0xD2, 0x01, // RÒ (U+0052 U+00D2)
  0x00, 0x52, 0x00, 0xD3, 0x01, // RÓ (U+0052 U+00D3)
  0x00, 0x52, 0x00, 0xD4, 0x01, // RÔ (U+0052 U+00D4)
  0x00, 0x52, 0x00, 0xD5, 0x01, // RÕ (U+0052 U+00D5)
  0x00, 0x52, 0x00, 0xD6, 0x01, // RÖ (U+0052 U+00D6)
  0x00, 0x52, 0x00, 0xD8, 0x01, // RØ (U+0052 U+00D8)
  0x00, 0x52, 0x00, 0xD9, 0x01, // RÙ (U+0052 U+00D9)
  0x00, 0x52, 0x00, 0xDA, 0x01, // RÚ (U+0052 U+00DA)
  0x00, 0x52, 0x00, 0xDB, 0x01, // RÛ (U+0052 U+00DB)
  0x00, 0x52, 0x00, 0xDC, 0x01, // RÜ (U+0052 U+00DC)
  0x00, 0x52, 0x00, 0xDD, 0x02, // RÝ (U+0052 U+00DD)
  0x00, 0x52, 0x00, 0xFD, 0x02, // Rý (U+0052 U+00FD)
  0x00, 0x52, 0x00, 0xFF, 0x02, // Rÿ (U+0052 U+00FF)
  0x00, 0x52, 0x01, 0x06, 0x01, // RĆ (U+0052 U+0106)
  0x00, 0x52, 0x01, 0x08, 0x01, // RĈ (U+0052 U+0108)
  0x00, 0x52, 0x01, 0x0A, 0x01, // RĊ (U+0052 U+010A)
  0x00, 0x52, 0x01, 0x0C, 0x01, // RČ (U+0052 U+010C)
  0x00, 0x52, 0x01, 0x1C, 0x01, // RĜ (U+0052 U+011C)
  0x00, 0x52, 0x01, 0x1E, 0x01, // RĞ (U+0052 U+011E)
  0x00, 0x52, 0x01, 0x20, 0x01, // RĠ (U+0052 U+0120)
  0x00, 0x52, 0x01, 0x22, 0x01, // RĢ (U+0052 U+0122)
  0x00, 0x52, 0x01, 0x4C, 0x01, // RŌ (U+0052 U+014C)
  0x00, 0x52, 0x01, 0x4E, 0x01, // RŎ (U+0052 U+014E)
  0x00, 0x52, 0x01, 0x50, 0x01, // RŐ (U+0052 U+0150)
  0x00, 0x52, 0x01, 0x52, 0x01, // RŒ (U+0052 U+0152)
  0x00, 0x52, 0x01, 0x62, 0x01, // RŢ (U+0052 U+0162)
  0x00, 0x52, 0x01, 0x64, 0x01, // RŤ (U+0052 U+0164)
  0x00, 0x52, 0x01, 0x66, 0x01, // RŦ (U+0052 U+0166)
  0x00, 0x52, 0x01, 0x68, 0x01, // RŨ (U+0052 U+0168)
  0x00, 0x52, 0x01, 0x6A, 0x01, // RŪ (U+0052 U+016A)
  0x00, 0x52, 0x01, 0x6C, 0x01, // RŬ (U+0052 U+016C)
  0x00, 0x52, 0x01, 0x6E, 0x01, // RŮ (U+0052 U+016E)
  0x00, 0x52, 0x01, 0x70, 0x01, // RŰ (U+0052 U+0170)
  0x00, 0x52, 0x01, 0x72, 0x01, // RŲ (U+0052 U+0172)
  0x00, 0x52, 0x01, 0x74, 0x02, // RŴ (U+0052 U+0174)
  0x00, 0x52, 0x01, 0x75, 0x01, // Rŵ (U+0052 U+0175)
  0x00, 0x52, 0x01, 0x76, 0x02, // RŶ (U+0052 U+0176)
  0x00, 0x52, 0x01, 0x77, 0x02, // Rŷ (U+0052 U+0177)
  0x00, 0x52, 0x01, 0x78, 0x02, // RŸ (U+0052 U+0178)
  0x00, 0x52, 0x20, 0x19, 0x01, // R’ (U+0052 U+2019)
  0x00, 0x52, 0x20, 0x1D, 0x01, // R” (U+0052 U+201D)
  0x00, 0x52, 0x21, 0x22, 0x01, // R™ (U+0052 U+2122)
  0x00, 0x53, 0x00, 0x3F, 0x01, // S? (U+0053 U+003F)
  0x00, 0x53, 0x00, 0x41, 0x01, // SA (U+0053 U+0041)
  0x00, 0x53, 0x00, 0x54, 0x01, // ST (U+0053 U+0054)
  0x00, 0x53, 0x00, 0x56, 0x02, // SV (U+0053 U+0056)
  0x00, 0x53, 0x00, 0x57, 0x02, // SW (U+0053 U+0057)
  0x00, 0x53, 0x00, 0x58, 0x01, // SX (U+0053 U+0058)
  0x00, 0x53, 0x00, 0x59, 0x01, // SY (U+0053 U+0059)
  0x00, 0x53, 0x00, 0x77, 0x01, // Sw (U+0053 U+0077)
  0x00, 0x53, 0x00, 0x79, 0x02, // Sy (U+0053 U+0079)
  0x00, 0x53, 0x00, 0xC0, 0x01, // SÀ (U+0053 U+00C0)
  0x00, 0x53, 0x00, 0xC1, 0x01, // SÁ (U+0053 U+00C1)
  0x00, 0x53, 0x00, 0xC2, 0x01, // SÂ (U+0053 U+00C2)
  0x00, 0x53, 0x00, 0xC3, 0x01, // SÃ (U+0053 U+00C3)
  0x00, 0x53, 0x00, 0xC4, 0x01, // SÄ (U+0053 U+00C4)
  0x00, 0x53, 0x00, 0xC5, 0x01, // SÅ (U+0053 U+00C5)
  0x00, 0x53, 0x00, 0xC6, 0x02, // SÆ (U+0053 U+00C6)
  0x00, 0x53, 0x00, 0xDD, 0x01, // SÝ (U+0053 U+00DD)
  0x00, 0x53, 0x00, 0xFD, 0x02, // Sý (U+0053 U+00FD)
  0x00, 0x53, 0x00, 0xFF, 0x02, // Sÿ (U+0053 U+00FF)
  0x00, 0x53, 0x01, 0x00, 0x01, // SĀ (U+0053 U+0100)
  0x00, 0x53, 0x01, 0x02, 0x01, // SĂ (U+0053 U+0102)
  0x00, 0x53, 0x01, 0x04, 0x01, // SĄ (U+0053 U+0104)
  0x00, 0x53, 0x01, 0x62, 0x01, // SŢ (U+0053 U+0162)
  0x00, 0x53, 0x01, 0x64, 0x01, // SŤ (U+0053 U+0164)
  0x00, 0x53, 0x01, 0x66, 0x01, // SŦ (U+0053 U+0166)
  0x00, 0x53, 0x01, 0x74, 0x02, // SŴ (U+0053 U+0174)
  0x00, 0x53, 0x01, 0x75, 0x01, // Sŵ (U+0053 U+0175)
  0x00, 0x53, 0x01, 0x76, 0x01, // SŶ (U+0053 U+0176)
  0x00, 0x53, 0x01, 0x77, 0x02, // Sŷ (U+0053 U+0177)
  0x00, 0x53, 0x01, 0x78, 0x01, // SŸ (U+0053 U+0178)
  0x00, 0x54, 0x00, 0x26, 0x01, // T& (U+0054 U+0026)
  0x00, 0x54, 0x00, 0x2C, 0x06, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x06, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x40, 0x03, // T@ (U+0054 U+0040)
  0x00, 0x54, 0x00, 0x41, 0x05, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x43, 0x02, // TC (U+0054 U+0043)
  0x00, 0x54, 0x00, 0x47, 0x02, // TG (U+0054 U+0047)
  0x00, 0x54, 0x00, 0x4F, 0x02, // TO (U+0054 U+004F)
  0x00, 0x54, 0x00, 0x51, 0x02, // TQ (U+0054 U+0051)
  0x00, 0x54, 0x00, 0x61, 0x03, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x04, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x04, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x04, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x04, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x04, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x04, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xC0, 0x05, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x05, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x05, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x05, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x05, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x05, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC6, 0x07, // TÆ (U+0054 U+00C6)
  0x00, 0x54, 0x00, 0xC7, 0x02, // TÇ (U+0054 U+00C7)
  0x00, 0x54, 0x00, 0xD2, 0x02, // TÒ (U+0054 U+00D2)
  0x00, 0x54, 0x00, 0xD3, 0x02, // TÓ (U+0054 U+00D3)
  0x00, 0x54, 0x00, 0xD4, 0x02, // TÔ (U+0054 U+00D4)
  0x00, 0x54, 0x00, 0xD5, 0x02, // TÕ (U+0054 U+00D5)
  0x00, 0x54, 0x00, 0xD6, 0x02, // TÖ (U+0054 U+00D6)
  0x00, 0x54, 0x00, 0xD8, 0x02, // TØ (U+0054 U+00D8)
  0x00, 0x54, 0x00, 0xE0, 0x03, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x03, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x03, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x03, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x03, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x03, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x03, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x04, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x04, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x04, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x04, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x04, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF0, 0x04, // Tð (U+0054 U+00F0)
  0x00, 0x54, 0x00, 0xF2, 0x04, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x04, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x04, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x04, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x04, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x04, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x00, 0x05, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x03, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x05, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x03, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x05, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x03, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x06, 0x02, // TĆ (U+0054 U+0106)
  0x00, 0x54, 0x01, 0x07, 0x04, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x08, 0x02, // TĈ (U+0054 U+0108)
  0x00, 0x54, 0x01, 0x09, 0x04, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0A, 0x02, // TĊ (U+0054 U+010A)
  0x00, 0x54, 0x01, 0x0B, 0x04, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0C, 0x02, // TČ (U+0054 U+010C)
  0x00, 0x54, 0x01, 0x0D, 0x04, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x04, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x04, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x04, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x04, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x04, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x04, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x04, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1C, 0x02, // TĜ (U+0054 U+011C)
  0x00, 0x54, 0x01, 0x1D, 0x04, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1E, 0x02, // TĞ (U+0054 U+011E)
  0x00, 0x54, 0x01, 0x1F, 0x04, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x20, 0x02, // TĠ (U+0054 U+0120)
  0x00, 0x54, 0x01, 0x21, 0x04, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x22, 0x02, // TĢ (U+0054 U+0122)
  0x00, 0x54, 0x01, 0x23, 0x04, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4C, 0x02, // TŌ (U+0054 U+014C)
  0x00, 0x54, 0x01, 0x4D, 0x04, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4E, 0x02, // TŎ (U+0054 U+014E)
  0x00, 0x54, 0x01, 0x4F, 0x04, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x50, 0x02, // TŐ (U+0054 U+0150)
  0x00, 0x54, 0x01, 0x51, 0x04, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x52, 0x02, // TŒ (U+0054 U+0152)
  0x00, 0x54, 0x01, 0x53, 0x04, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x20, 0x1A, 0x06, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x06, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x06, // T… (U+0054 U+2026)
  0x00, 0x55, 0x00, 0x2C, 0x02, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x02, // U. (U+0055 U+002E)
  0x00, 0x55, 0x00, 0x40, 0x01, // U@ (U+0055 U+0040)
  0x00, 0x55, 0x00, 0x41, 0x02, // UA (U+0055 U+0041)
  0x00, 0x55, 0x00, 0xC0, 0x02, // UÀ (U+0055 U+00C0)
  0x00, 0x55, 0x00, 0xC1, 0x02, // UÁ (U+0055 U+00C1)
  0x00, 0x55, 0x00, 0xC2, 0x02, // UÂ (U+0055 U+00C2)
  0x00, 0x55, 0x00, 0xC3, 0x02, // UÃ (U+0055 U+00C3)
  0x00, 0x55, 0x00, 0xC4, 0x02, // UÄ (U+0055 U+00C4)
  0x00, 0x55, 0x00, 0xC5, 0x02, // UÅ (U+0055 U+00C5)
  0x00, 0x55, 0x00, 0xC6, 0x04, // UÆ (U+0055 U+00C6)
  0x00, 0x55, 0x01, 0x00, 0x02, // UĀ (U+0055 U+0100)
  0x00, 0x55, 0x01, 0x02, 0x02, // UĂ (U+0055 U+0102)
  0x00, 0x55, 0x01, 0x04, 0x02, // UĄ (U+0055 U+0104)
  0x00, 0x55, 0x20, 0x1A, 0x02, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x02, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x02, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x26, 0x03, // V& (U+0056 U+0026)
  0x00, 0x56, 0x00, 0x2C, 0x09, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x09, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x40, 0x05, // V@ (U+0056 U+0040)
  0x00, 0x56, 0x00, 0x41, 0x06, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x43, 0x02, // VC (U+0056 U+0043)
  0x00, 0x56, 0x00, 0x47, 0x02, // VG (U+0056 U+0047)
  0x00, 0x56, 0x00, 0x4F, 0x02, // VO (U+0056 U+004F)
  0x00, 0x56, 0x00, 0x51, 0x02, // VQ (U+0056 U+0051)
  0x00, 0x56, 0x00, 0x61, 0x05, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x04, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x04, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x04, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x04, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6F, 0x04, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x71, 0x04, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x73, 0x04, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0xC0, 0x06, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x06, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x06, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x06, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x06, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x06, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC6, 0x0A, // VÆ (U+0056 U+00C6)
  0x00, 0x56, 0x00, 0xC7, 0x02, // VÇ (U+0056 U+00C7)
  0x00, 0x56, 0x00, 0xD2, 0x02, // VÒ (U+0056 U+00D2)
  0x00, 0x56, 0x00, 0xD3, 0x02, // VÓ (U+0056 U+00D3)
  0x00, 0x56, 0x00, 0xD4, 0x02, // VÔ (U+0056 U+00D4)
  0x00, 0x56, 0x00, 0xD5, 0x02, // VÕ (U+0056 U+00D5)
  0x00, 0x56, 0x00, 0xD6, 0x02, // VÖ (U+0056 U+00D6)
  0x00, 0x56, 0x00, 0xD8, 0x02, // VØ (U+0056 U+00D8)
  0x00, 0x56, 0x00, 0xE0, 0x05, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x05, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x05, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x05, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x05, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x05, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x05, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x04, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x04, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x04, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x04, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x04, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF0, 0x04, // Vð (U+0056 U+00F0)
  0x00, 0x56, 0x00, 0xF2, 0x04, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x04, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x04, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x04, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x04, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x04, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x01, 0x00, 0x06, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x05, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x06, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x05, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x06, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x05, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x06, 0x02, // VĆ (U+0056 U+0106)
  0x00, 0x56, 0x01, 0x07, 0x04, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x08, 0x02, // VĈ (U+0056 U+0108)
  0x00, 0x56, 0x01, 0x09, 0x04, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0A, 0x02, // VĊ (U+0056 U+010A)
  0x00, 0x56, 0x01, 0x0B, 0x04, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0C, 0x02, // VČ (U+0056 U+010C)
  0x00, 0x56, 0x01, 0x0D, 0x04, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x04, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x04, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x04, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x04, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x04, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x04, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x04, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1C, 0x02, // VĜ (U+0056 U+011C)
  0x00, 0x56, 0x01, 0x1D, 0x04, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1E, 0x02, // VĞ (U+0056 U+011E)
  0x00, 0x56, 0x01, 0x1F, 0x04, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x20, 0x02, // VĠ (U+0056 U+0120)
  0x00, 0x56, 0x01, 0x21, 0x04, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x22, 0x02, // VĢ (U+0056 U+0122)
  0x00, 0x56, 0x01, 0x23, 0x04, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x4C, 0x02, // VŌ (U+0056 U+014C)
  0x00, 0x56, 0x01, 0x4D, 0x04, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4E, 0x02, // VŎ (U+0056 U+014E)
  0x00, 0x56, 0x01, 0x4F, 0x04, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x50, 0x02, // VŐ (U+0056 U+0150)
  0x00, 0x56, 0x01, 0x51, 0x04, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x52, 0x02, // VŒ (U+0056 U+0152)
  0x00, 0x56, 0x01, 0x53, 0x04, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x5B, 0x04, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5D, 0x04, // Vŝ (U+0056 U+015D)
  0x00, 0x56, 0x01, 0x5F, 0x04, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x61, 0x04, // Vš (U+0056 U+0161)
  0x00, 0x56, 0x20, 0x1A, 0x09, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x09, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x09, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x07, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x07, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x40, 0x05, // W@ (U+0057 U+0040)
  0x00, 0x57, 0x00, 0x41, 0x05, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x43, 0x02, // WC (U+0057 U+0043)
  0x00, 0x57, 0x00, 0x47, 0x02, // WG (U+0057 U+0047)
  0x00, 0x57, 0x00, 0x4F, 0x02, // WO (U+0057 U+004F)
  0x00, 0x57, 0x00, 0x51, 0x02, // WQ (U+0057 U+0051)
  0x00, 0x57, 0x00, 0x61, 0x06, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x04, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x04, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x04, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x04, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6F, 0x04, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x71, 0x04, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x73, 0x04, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0x7A, 0x03, // Wz (U+0057 U+007A)
  0x00, 0x57, 0x00, 0xC0, 0x05, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x05, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x05, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x05, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x05, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x05, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC6, 0x09, // WÆ (U+0057 U+00C6)
  0x00, 0x57, 0x00, 0xC7, 0x02, // WÇ (U+0057 U+00C7)
  0x00, 0x57, 0x00, 0xD2, 0x02, // WÒ (U+0057 U+00D2)
  0x00, 0x57, 0x00, 0xD3, 0x02, // WÓ (U+0057 U+00D3)
  0x00, 0x57, 0x00, 0xD4, 0x02, // WÔ (U+0057 U+00D4)
  0x00, 0x57, 0x00, 0xD5, 0x02, // WÕ (U+0057 U+00D5)
  0x00, 0x57, 0x00, 0xD6, 0x02, // WÖ (U+0057 U+00D6)
  0x00, 0x57, 0x00, 0xD8, 0x02, // WØ (U+0057 U+00D8)
  0x00, 0x57, 0x00, 0xE0, 0x06, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x06, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x06, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x06, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x06, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x06, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x06, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x04, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x04, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x04, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x04, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x04, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF0, 0x04, // Wð (U+0057 U+00F0)
  0x00, 0x57, 0x00, 0xF2, 0x04, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x04, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x04, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x04, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x04, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x04, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x01, 0x00, 0x05, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x06, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x05, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x06, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x05, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x06, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x06, 0x02, // WĆ (U+0057 U+0106)
  0x00, 0x57, 0x01, 0x07, 0x04, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x08, 0x02, // WĈ (U+0057 U+0108)
  0x00, 0x57, 0x01, 0x09, 0x04, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0A, 0x02, // WĊ (U+0057 U+010A)
  0x00, 0x57, 0x01, 0x0B, 0x04, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0C, 0x02, // WČ (U+0057 U+010C)
  0x00, 0x57, 0x01, 0x0D, 0x04, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x04, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x04, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x04, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x04, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x04, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x04, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x04, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1C, 0x02, // WĜ (U+0057 U+011C)
  0x00, 0x57, 0x01, 0x1D, 0x04, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1E, 0x02, // WĞ (U+0057 U+011E)
  0x00, 0x57, 0x01, 0x1F, 0x04, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x20, 0x02, // WĠ (U+0057 U+0120)
  0x00, 0x57, 0x01, 0x21, 0x04, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x22, 0x02, // WĢ (U+0057 U+0122)
  0x00, 0x57, 0x01, 0x23, 0x04, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x4C, 0x02, // WŌ (U+0057 U+014C)
  0x00, 0x57, 0x01, 0x4D, 0x04, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4E, 0x02, // WŎ (U+0057 U+014E)
  0x00, 0x57, 0x01, 0x4F, 0x04, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x50, 0x02, // WŐ (U+0057 U+0150)
  0x00, 0x57, 0x01, 0x51, 0x04, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x52, 0x02, // WŒ (U+0057 U+0152)
  0x00, 0x57, 0x01, 0x53, 0x04, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x5B, 0x04, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5D, 0x04, // Wŝ (U+0057 U+015D)
  0x00, 0x57, 0x01, 0x5F, 0x04, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x61, 0x04, // Wš (U+0057 U+0161)
  0x00, 0x57, 0x01, 0x7A, 0x03, // Wź (U+0057 U+017A)
  0x00, 0x57, 0x01, 0x7C, 0x03, // Wż (U+0057 U+017C)
  0x00, 0x57, 0x01, 0x7E, 0x03, // Wž (U+0057 U+017E)
  0x00, 0x57, 0x20, 0x1A, 0x07, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x07, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x07, // W… (U+0057 U+2026)
  0x00, 0x58, 0x00, 0x43, 0x02, // XC (U+0058 U+0043)
  0x00, 0x58, 0x00, 0x47, 0x02, // XG (U+0058 U+0047)
  0x00, 0x58, 0x00, 0x4F, 0x02, // XO (U+0058 U+004F)
  0x00, 0x58, 0x00, 0x51, 0x02, // XQ (U+0058 U+0051)
  0x00, 0x58, 0x00, 0x53, 0x01, // XS (U+0058 U+0053)
  0x00, 0x58, 0x00, 0x77, 0x03, // Xw (U+0058 U+0077)
  0x00, 0x58, 0x00, 0x79, 0x05, // Xy (U+0058 U+0079)
  0x00, 0x58, 0x00, 0xC7, 0x02, // XÇ (U+0058 U+00C7)
  0x00, 0x58, 0x00, 0xD2, 0x02, // XÒ (U+0058 U+00D2)
  0x00, 0x58, 0x00, 0xD3, 0x02, // XÓ (U+0058 U+00D3)
  0x00, 0x58, 0x00, 0xD4, 0x02, // XÔ (U+0058 U+00D4)
  0x00, 0x58, 0x00, 0xD5, 0x02, // XÕ (U+0058 U+00D5)
  0x00, 0x58, 0x00, 0xD6, 0x02, // XÖ (U+0058 U+00D6)
  0x00, 0x58, 0x00, 0xD8, 0x02, // XØ (U+0058 U+00D8)
  0x00, 0x58, 0x00, 0xFD, 0x05, // Xý (U+0058 U+00FD)
  0x00, 0x58, 0x00, 0xFF, 0x05, // Xÿ (U+0058 U+00FF)
  0x00, 0x58, 0x01, 0x06, 0x02, // XĆ (U+0058 U+0106)
  0x00, 0x58, 0x01, 0x08, 0x02, // XĈ (U+0058 U+0108)
  0x00, 0x58, 0x01, 0x0A, 0x02, // XĊ (U+0058 U+010A)
  0x00, 0x58, 0x01, 0x0C, 0x02, // XČ (U+0058 U+010C)
  0x00, 0x58, 0x01, 0x1C, 0x02, // XĜ (U+0058 U+011C)
  0x00, 0x58, 0x01, 0x1E, 0x02, // XĞ (U+0058 U+011E)
  0x00, 0x58, 0x01, 0x20, 0x02, // XĠ (U+0058 U+0120)
  0x00, 0x58, 0x01, 0x22, 0x02, // XĢ (U+0058 U+0122)
  0x00, 0x58, 0x01, 0x4C, 0x02, // XŌ (U+0058 U+014C)
  0x00, 0x58, 0x01, 0x4E, 0x02, // XŎ (U+0058 U+014E)
  0x00, 0x58, 0x01, 0x50, 0x02, // XŐ (U+0058 U+0150)
  0x00, 0x58, 0x01, 0x52, 0x02, // XŒ (U+0058 U+0152)
  0x00, 0x58, 0x01, 0x5A, 0x01, // XŚ (U+0058 U+015A)
  0x00, 0x58, 0x01, 0x5C, 0x01, // XŜ (U+0058 U+015C)
  0x00, 0x58, 0x01, 0x5E, 0x01, // XŞ (U+0058 U+015E)
  0x00, 0x58, 0x01, 0x60, 0x01, // XŠ (U+0058 U+0160)
  0x00, 0x58, 0x01, 0x75, 0x03, // Xŵ (U+0058 U+0175)
  0x00, 0x58, 0x01, 0x77, 0x05, // Xŷ (U+0058 U+0177)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x06, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x06, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x40, 0x04, // Y@ (U+0059 U+0040)
  0x00, 0x59, 0x00, 0x41, 0x04, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x03, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x03, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x03, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x03, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x53, 0x01, // YS (U+0059 U+0053)
  0x00, 0x59, 0x00, 0x61, 0x05, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x04, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x04, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x04, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x04, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x04, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x04, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x04, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x7A, 0x02, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xC0, 0x04, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x04, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x04, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x04, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x04, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x04, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC6, 0x06, // YÆ (U+0059 U+00C6)
  0x00, 0x59, 0x00, 0xC7, 0x03, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x03, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x03, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x03, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x03, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x03, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x03, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x05, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x05, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x05, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x05, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x05, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x05, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x05, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x04, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x04, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x04, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x04, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x04, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF0, 0x04, // Yð (U+0059 U+00F0)
  0x00, 0x59, 0x00, 0xF2, 0x04, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x04, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x04, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x04, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x04, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x04, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x04, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x05, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x04, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x05, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x04, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x05, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x03, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x04, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x03, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x04, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x03, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x04, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x03, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x04, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x04, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x04, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x04, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x04, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x04, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x04, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x04, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x03, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x04, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x03, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x04, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x03, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x04, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x03, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x04, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4C, 0x03, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x04, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x03, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x04, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x03, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x04, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x03, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x04, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5A, 0x01, // YŚ (U+0059 U+015A)
  0x00, 0x59, 0x01, 0x5B, 0x04, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5C, 0x01, // YŜ (U+0059 U+015C)
  0x00, 0x59, 0x01, 0x5D, 0x04, // Yŝ (U+0059 U+015D)
  0x00, 0x59, 0x01, 0x5E, 0x01, // YŞ (U+0059 U+015E)
  0x00, 0x59, 0x01, 0x5F, 0x04, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x60, 0x01, // YŠ (U+0059 U+0160)
  0x00, 0x59, 0x01, 0x61, 0x04, // Yš (U+0059 U+0161)
  0x00, 0x59, 0x01, 0x7A, 0x02, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x02, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x02, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x06, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x06, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x06, // Y… (U+0059 U+2026)
  0x00, 0x61, 0x00, 0x22, 0x04, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x04, // a' (U+0061 U+0027)
  0x00, 0x61, 0x00, 0x3F, 0x02, // a? (U+0061 U+003F)
  0x00, 0x61, 0x00, 0x54, 0x02, // aT (U+0061 U+0054)
  0x00, 0x61, 0x00, 0x56, 0x03, // aV (U+0061 U+0056)
  0x00, 0x61, 0x00, 0x57, 0x03, // aW (U+0061 U+0057)
  0x00, 0x61, 0x00, 0x59, 0x03, // aY (U+0061 U+0059)
  0x00, 0x61, 0x00, 0x79, 0x02, // ay (U+0061 U+0079)
  0x00, 0x61, 0x00, 0xDD, 0x03, // aÝ (U+0061 U+00DD)
  0x00, 0x61, 0x00, 0xFD, 0x02, // aý (U+0061 U+00FD)
  0x00, 0x61, 0x00, 0xFF, 0x02, // aÿ (U+0061 U+00FF)
  0x00, 0x61, 0x01, 0x62, 0x02, // aŢ (U+0061 U+0162)
  0x00, 0x61, 0x01, 0x64, 0x02, // aŤ (U+0061 U+0164)
  0x00, 0x61, 0x01, 0x66, 0x02, // aŦ (U+0061 U+0166)
  0x00, 0x61, 0x01, 0x74, 0x03, // aŴ (U+0061 U+0174)
  0x00, 0x61, 0x01, 0x76, 0x03, // aŶ (U+0061 U+0176)
  0x00, 0x61, 0x01, 0x77, 0x02, // aŷ (U+0061 U+0177)
  0x00, 0x61, 0x01, 0x78, 0x03, // aŸ (U+0061 U+0178)
  0x00, 0x62, 0x00, 0x3F, 0x02, // b? (U+0062 U+003F)
  0x00, 0x62, 0x00, 0x41, 0x01, // bA (U+0062 U+0041)
  0x00, 0x62, 0x00, 0x54, 0x02, // bT (U+0062 U+0054)
  0x00, 0x62, 0x00, 0x56, 0x03, // bV (U+0062 U+0056)
  0x00, 0x62, 0x00, 0x57, 0x03, // bW (U+0062 U+0057)
  0x00, 0x62, 0x00, 0x59, 0x04, // bY (U+0062 U+0059)
  0x00, 0x62, 0x00, 0x79, 0x02, // by (U+0062 U+0079)
  0x00, 0x62, 0x00, 0xC0, 0x01, // bÀ (U+0062 U+00C0)
  0x00, 0x62, 0x00, 0xC1, 0x01, // bÁ (U+0062 U+00C1)
  0x00, 0x62, 0x00, 0xC2, 0x01, // bÂ (U+0062 U+00C2)
  0x00, 0x62, 0x00, 0xC3, 0x01, // bÃ (U+0062 U+00C3)
  0x00, 0x62, 0x00, 0xC4, 0x01, // bÄ (U+0062 U+00C4)
  0x00, 0x62, 0x00, 0xC5, 0x01, // bÅ (U+0062 U+00C5)
  0x00, 0x62, 0x00, 0xDD, 0x04, // bÝ (U+0062 U+00DD)
  0x00, 0x62, 0x00, 0xFD, 0x02, // bý (U+0062 U+00FD)
  0x00, 0x62, 0x00, 0xFF, 0x02, // bÿ (U+0062 U+00FF)
  0x00, 0x62, 0x01, 0x00, 0x01, // bĀ (U+0062 U+0100)
  0x00, 0x62, 0x01, 0x02, 0x01, // bĂ (U+0062 U+0102)
  0x00, 0x62, 0x01, 0x04, 0x01, // bĄ (U+0062 U+0104)
  0x00, 0x62, 0x01, 0x62, 0x02, // bŢ (U+0062 U+0162)
  0x00, 0x62, 0x01, 0x64, 0x02, // bŤ (U+0062 U+0164)
  0x00, 0x62, 0x01, 0x66, 0x02, // bŦ (U+0062 U+0166)
  0x00, 0x62, 0x01, 0x74, 0x03, // bŴ (U+0062 U+0174)
  0x00, 0x62, 0x01, 0x76, 0x04, // bŶ (U+0062 U+0176)
  0x00, 0x62, 0x01, 0x77, 0x02, // bŷ (U+0062 U+0177)
  0x00, 0x62, 0x01, 0x78, 0x04, // bŸ (U+0062 U+0178)
  0x00, 0x65, 0x00, 0x56, 0x04, // eV (U+0065 U+0056)
  0x00, 0x65, 0x00, 0x57, 0x04, // eW (U+0065 U+0057)
  0x00, 0x65, 0x00, 0x59, 0x04, // eY (U+0065 U+0059)
  0x00, 0x65, 0x00, 0xDD, 0x04, // eÝ (U+0065 U+00DD)
  0x00, 0x65, 0x01, 0x74, 0x04, // eŴ (U+0065 U+0174)
  0x00, 0x65, 0x01, 0x76, 0x04, // eŶ (U+0065 U+0176)
  0x00, 0x65, 0x01, 0x78, 0x04, // eŸ (U+0065 U+0178)
  0x00, 0x67, 0x00, 0x57, 0x02, // gW (U+0067 U+0057)
  0x00, 0x67, 0x00, 0x59, 0x01, // gY (U+0067 U+0059)
  0x00, 0x67, 0x00, 0xDD, 0x01, // gÝ (U+0067 U+00DD)
  0x00, 0x67, 0x01, 0x74, 0x02, // gŴ (U+0067 U+0174)
  0x00, 0x67, 0x01, 0x76, 0x01, // gŶ (U+0067 U+0176)
  0x00, 0x67, 0x01, 0x78, 0x01, // gŸ (U+0067 U+0178)
  0x00, 0x68, 0x00, 0x22, 0x04, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x04, // h' (U+0068 U+0027)
  0x00, 0x68, 0x00, 0x3F, 0x02, // h? (U+0068 U+003F)
  0x00, 0x68, 0x00, 0x54, 0x02, // hT (U+0068 U+0054)
  0x00, 0x68, 0x00, 0x56, 0x03, // hV (U+0068 U+0056)
  0x00, 0x68, 0x00, 0x57, 0x03, // hW (U+0068 U+0057)
  0x00, 0x68, 0x00, 0x59, 0x03, // hY (U+0068 U+0059)
  0x00, 0x68, 0x00, 0x79, 0x02, // hy (U+0068 U+0079)
  0x00, 0x68, 0x00, 0xDD, 0x03, // hÝ (U+0068 U+00DD)
  0x00, 0x68, 0x00, 0xFD, 0x02, // hý (U+0068 U+00FD)
  0x00, 0x68, 0x00, 0xFF, 0x02, // hÿ (U+0068 U+00FF)
  0x00, 0x68, 0x01, 0x62, 0x02, // hŢ (U+0068 U+0162)
  0x00, 0x68, 0x01, 0x64, 0x02, // hŤ (U+0068 U+0164)
  0x00, 0x68, 0x01, 0x66, 0x02, // hŦ (U+0068 U+0166)
  0x00, 0x68, 0x01, 0x74, 0x03, // hŴ (U+0068 U+0174)
  0x00, 0x68, 0x01, 0x76, 0x03, // hŶ (U+0068 U+0176)
  0x00, 0x68, 0x01, 0x77, 0x02, // hŷ (U+0068 U+0177)
  0x00, 0x68, 0x01, 0x78, 0x03, // hŸ (U+0068 U+0178)
  0x00, 0x6B, 0x00, 0x63, 0x01, // kc (U+006B U+0063)
  0x00, 0x6B, 0x00, 0x64, 0x01, // kd (U+006B U+0064)
  0x00, 0x6B, 0x00, 0x65, 0x01, // ke (U+006B U+0065)
  0x00, 0x6B, 0x00, 0x67, 0x01, // kg (U+006B U+0067)
  0x00, 0x6B, 0x00, 0x6F, 0x01, // ko (U+006B U+006F)
  0x00, 0x6B, 0x00, 0x71, 0x01, // kq (U+006B U+0071)
  0x00, 0x6B, 0x00, 0xE7, 0x01, // kç (U+006B U+00E7)
  0x00, 0x6B, 0x00, 0xE8, 0x01, // kè (U+006B U+00E8)
  0x00, 0x6B, 0x00, 0xE9, 0x01, // ké (U+006B U+00E9)
  0x00, 0x6B, 0x00, 0xEA, 0x01, // kê (U+006B U+00EA)
  0x00, 0x6B, 0x00, 0xEB, 0x01, // kë (U+006B U+00EB)
  0x00, 0x6B, 0x00, 0xF0, 0x01, // kð (U+006B U+00F0)
  0x00, 0x6B, 0x00, 0xF2, 0x01, // kò (U+006B U+00F2)
  0x00, 0x6B, 0x00, 0xF3, 0x01, // kó (U+006B U+00F3)
  0x00, 0x6B, 0x00, 0xF4, 0x01, // kô (U+006B U+00F4)
  0x00, 0x6B, 0x00, 0xF5, 0x01, // kõ (U+006B U+00F5)
  0x00, 0x6B, 0x00, 0xF6, 0x01, // kö (U+006B U+00F6)
  0x00, 0x6B, 0x00, 0xF8, 0x01, // kø (U+006B U+00F8)
  0x00, 0x6B, 0x01, 0x07, 0x01, // kć (U+006B U+0107)
  0x00, 0x6B, 0x01, 0x09, 0x01, // kĉ (U+006B U+0109)
  0x00, 0x6B, 0x01, 0x0B, 0x01, // kċ (U+006B U+010B)
  0x00, 0x6B, 0x01, 0x0D, 0x01, // kč (U+006B U+010D)
  0x00, 0x6B, 0x01, 0x0F, 0x01, // kď (U+006B U+010F)
  0x00, 0x6B, 0x01, 0x11, 0x01, // kđ (U+006B U+0111)
  0x00, 0x6B, 0x01, 0x13, 0x01, // kē (U+006B U+0113)
  0x00, 0x6B, 0x01, 0x15, 0x01, // kĕ (U+006B U+0115)
  0x00, 0x6B, 0x01, 0x17, 0x01, // kė (U+006B U+0117)
  0x00, 0x6B, 0x01, 0x19, 0x01, // kę (U+006B U+0119)
  0x00, 0x6B, 0x01, 0x1B, 0x01, // kě (U+006B U+011B)
  0x00, 0x6B, 0x01, 0x1D, 0x01, // kĝ (U+006B U+011D)
  0x00, 0x6B, 0x01, 0x1F, 0x01, // kğ (U+006B U+011F)
  0x00, 0x6B, 0x01, 0x21, 0x01, // kġ (U+006B U+0121)
  0x00, 0x6B, 0x01, 0x23, 0x01, // kģ (U+006B U+0123)
  0x00, 0x6B, 0x01, 0x4D, 0x01, // kō (U+006B U+014D)
  0x00, 0x6B, 0x01, 0x4F, 0x01, // kŏ (U+006B U+014F)
  0x00, 0x6B, 0x01, 0x51, 0x01, // kő (U+006B U+0151)
  0x00, 0x6B, 0x01, 0x53, 0x01, // kœ (U+006B U+0153)
  0x00, 0x6D, 0x00, 0x22, 0x04, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x04, // m' (U+006D U+0027)
  0x00, 0x6D, 0x00, 0x3F, 0x02, // m? (U+006D U+003F)
  0x00, 0x6D, 0x00, 0x54, 0x02, // mT (U+006D U+0054)
  0x00, 0x6D, 0x00, 0x56, 0x03, // mV (U+006D U+0056)
  0x00, 0x6D, 0x00, 0x57, 0x03, // mW (U+006D U+0057)
  0x00, 0x6D, 0x00, 0x59, 0x03, // mY (U+006D U+0059)
  0x00, 0x6D, 0x00, 0x79, 0x02, // my (U+006D U+0079)
  0x00, 0x6D, 0x00, 0xDD, 0x03, // mÝ (U+006D U+00DD)
  0x00, 0x6D, 0x00, 0xFD, 0x02, // mý (U+006D U+00FD)
  0x00, 0x6D, 0x00, 0xFF, 0x02, // mÿ (U+006D U+00FF)
  0x00, 0x6D, 0x01, 0x62, 0x02, // mŢ (U+006D U+0162)
  0x00, 0x6D, 0x01, 0x64, 0x02, // mŤ (U+006D U+0164)
  0x00, 0x6D, 0x01, 0x66, 0x02, // mŦ (U+006D U+0166)
  0x00, 0x6D, 0x01, 0x74, 0x03, // mŴ (U+006D U+0174)
  0x00, 0x6D, 0x01, 0x76, 0x03, // mŶ (U+006D U+0176)
  0x00, 0x6D, 0x01, 0x77, 0x02, // mŷ (U+006D U+0177)
  0x00, 0x6D, 0x01, 0x78, 0x03, // mŸ (U+006D U+0178)
  0x00, 0x6E, 0x00, 0x22, 0x04, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x04, // n' (U+006E U+0027)
  0x00, 0x6E, 0x00, 0x3F, 0x02, // n? (U+006E U+003F)
  0x00, 0x6E, 0x00, 0x54, 0x02, // nT (U+006E U+0054)
  0x00, 0x6E, 0x00, 0x56, 0x03, // nV (U+006E U+0056)
  0x00, 0x6E, 0x00, 0x57, 0x03, // nW (U+006E U+0057)
  0x00, 0x6E, 0x00, 0x59, 0x03, // nY (U+006E U+0059)
  0x00, 0x6E, 0x00, 0x79, 0x02, // ny (U+006E U+0079)
  0x00, 0x6E, 0x00, 0xDD, 0x03, // nÝ (U+006E U+00DD)
  0x00, 0x6E, 0x00, 0xFD, 0x02, // ný (U+006E U+00FD)
  0x00, 0x6E, 0x00, 0xFF, 0x02, // nÿ (U+006E U+00FF)
  0x00, 0x6E, 0x01, 0x62, 0x02, // nŢ (U+006E U+0162)
  0x00, 0x6E, 0x01, 0x64, 0x02, // nŤ (U+006E U+0164)
  0x00, 0x6E, 0x01, 0x66, 0x02, // nŦ (U+006E U+0166)
  0x00, 0x6E, 0x01, 0x74, 0x03, // nŴ (U+006E U+0174)
  0x00, 0x6E, 0x01, 0x76, 0x03, // nŶ (U+006E U+0176)
  0x00, 0x6E, 0x01, 0x77, 0x02, // nŷ (U+006E U+0177)
  0x00, 0x6E, 0x01, 0x78, 0x03, // nŸ (U+006E U+0178)
  0x00, 0x6F, 0x00, 0x3F, 0x02, // o? (U+006F U+003F)
  0x00, 0x6F, 0x00, 0x41, 0x01, // oA (U+006F U+0041)
  0x00, 0x6F, 0x00, 0x54, 0x02, // oT (U+006F U+0054)
  0x00, 0x6F, 0x00, 0x56, 0x03, // oV (U+006F U+0056)
  0x00, 0x6F, 0x00, 0x57, 0x03, // oW (U+006F U+0057)
  0x00, 0x6F, 0x00, 0x59, 0x04, // oY (U+006F U+0059)
  0x00, 0x6F, 0x00, 0x79, 0x02, // oy (U+006F U+0079)
  0x00, 0x6F, 0x00, 0xC0, 0x01, // oÀ (U+006F U+00C0)
  0x00, 0x6F, 0x00, 0xC1, 0x01, // oÁ (U+006F U+00C1)
  0x00, 0x6F, 0x00, 0xC2, 0x01, // oÂ (U+006F U+00C2)
  0x00, 0x6F, 0x00, 0xC3, 0x01, // oÃ (U+006F U+00C3)
  0x00, 0x6F, 0x00, 0xC4, 0x01, // oÄ (U+006F U+00C4)
  0x00, 0x6F, 0x00, 0xC5, 0x01, // oÅ (U+006F U+00C5)
  0x00, 0x6F, 0x00, 0xDD, 0x04, // oÝ (U+006F U+00DD)
  0x00, 0x6F, 0x00, 0xFD, 0x02, // oý (U+006F U+00FD)
  0x00, 0x6F, 0x00, 0xFF, 0x02, // oÿ (U+006F U+00FF)
  0x00, 0x6F, 0x01, 0x00, 0x01, // oĀ (U+006F U+0100)
  0x00, 0x6F, 0x01, 0x02, 0x01, // oĂ (U+006F U+0102)
  0x00, 0x6F, 0x01, 0x04, 0x01, // oĄ (U+006F U+0104)
  0x00, 0x6F, 0x01, 0x62, 0x02, // oŢ (U+006F U+0162)
  0x00, 0x6F, 0x01, 0x64, 0x02, // oŤ (U+006F U+0164)
  0x00, 0x6F, 0x01, 0x66, 0x02, // oŦ (U+006F U+0166)
  0x00, 0x6F, 0x01, 0x74, 0x03, // oŴ (U+006F U+0174)
  0x00, 0x6F, 0x01, 0x76, 0x04, // oŶ (U+006F U+0176)
  0x00, 0x6F, 0x01, 0x77, 0x02, // oŷ (U+006F U+0177)
  0x00, 0x6F, 0x01, 0x78, 0x04, // oŸ (U+006F U+0178)
  0x00, 0x70, 0x00, 0x3F, 0x02, // p? (U+0070 U+003F)
  0x00, 0x70, 0x00, 0x41, 0x01, // pA (U+0070 U+0041)
  0x00, 0x70, 0x00, 0x54, 0x02, // pT (U+0070 U+0054)
  0x00, 0x70, 0x00, 0x56, 0x03, // pV (U+0070 U+0056)
  0x00, 0x70, 0x00, 0x57, 0x03, // pW (U+0070 U+0057)
  0x00, 0x70, 0x00, 0x59, 0x04, // pY (U+0070 U+0059)
  0x00, 0x70, 0x00, 0x79, 0x02, // py (U+0070 U+0079)
  0x00, 0x70, 0x00, 0xC0, 0x01, // pÀ (U+0070 U+00C0)
  0x00, 0x70, 0x00, 0xC1, 0x01, // pÁ (U+0070 U+00C1)
  0x00, 0x70, 0x00, 0xC2, 0x01, // pÂ (U+0070 U+00C2)
  0x00, 0x70, 0x00, 0xC3, 0x01, // pÃ (U+0070 U+00C3)
  0x00, 0x70, 0x00, 0xC4, 0x01, // pÄ (U+0070 U+00C4)
  0x00, 0x70, 0x00, 0xC5, 0x01, // pÅ (U+0070 U+00C5)
  0x00, 0x70, 0x00, 0xDD, 0x04, // pÝ (U+0070 U+00DD)
  0x00, 0x70, 0x00, 0xFD, 0x02, // pý (U+0070 U+00FD)
  0x00, 0x70, 0x00, 0xFF, 0x02, // pÿ (U+0070 U+00FF)
  0x00, 0x70, 0x01, 0x00, 0x01, // pĀ (U+0070 U+0100)
  0x00, 0x70, 0x01, 0x02, 0x01, // pĂ (U+0070 U+0102)
  0x00, 0x70, 0x01, 0x04, 0x01, // pĄ (U+0070 U+0104)
  0x00, 0x70, 0x01, 0x62, 0x02, // pŢ (U+0070 U+0162)
  0x00, 0x70, 0x01, 0x64, 0x02, // pŤ (U+0070 U+0164)
  0x00, 0x70, 0x01, 0x66, 0x02, // pŦ (U+0070 U+0166)
  0x00, 0x70, 0x01, 0x74, 0x03, // pŴ (U+0070 U+0174)
  0x00, 0x70, 0x01, 0x76, 0x04, // pŶ (U+0070 U+0176)
  0x00, 0x70, 0x01, 0x77, 0x02, // pŷ (U+0070 U+0177)
  0x00, 0x70, 0x01, 0x78, 0x04, // pŸ (U+0070 U+0178)
  0x00, 0x72, 0x00, 0x2C, 0x0A, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x0A, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x41, 0x02, // rA (U+0072 U+0041)
  0x00, 0x72, 0x00, 0x58, 0x01, // rX (U+0072 U+0058)
  0x00, 0x72, 0x00, 0x61, 0x02, // ra (U+0072 U+0061)
  0x00, 0x72, 0x00, 0xC0, 0x02, // rÀ (U+0072 U+00C0)
  0x00, 0x72, 0x00, 0xC1, 0x02, // rÁ (U+0072 U+00C1)
  0x00, 0x72, 0x00, 0xC2, 0x02, // rÂ (U+0072 U+00C2)
  0x00, 0x72, 0x00, 0xC3, 0x02, // rÃ (U+0072 U+00C3)
  0x00, 0x72, 0x00, 0xC4, 0x02, // rÄ (U+0072 U+00C4)
  0x00, 0x72, 0x00, 0xC5, 0x02, // rÅ (U+0072 U+00C5)
  0x00, 0x72, 0x00, 0xE0, 0x02, // rà (U+0072 U+00E0)
  0x00, 0x72, 0x00, 0xE1, 0x02, // rá (U+0072 U+00E1)
  0x00, 0x72, 0x00, 0xE2, 0x02, // râ (U+0072 U+00E2)
  0x00, 0x72, 0x00, 0xE3, 0x02, // rã (U+0072 U+00E3)
  0x00, 0x72, 0x00, 0xE4, 0x02, // rä (U+0072 U+00E4)
  0x00, 0x72, 0x00, 0xE5, 0x02, // rå (U+0072 U+00E5)
  0x00, 0x72, 0x00, 0xE6, 0x02, // ræ (U+0072 U+00E6)
  0x00, 0x72, 0x01, 0x00, 0x02, // rĀ (U+0072 U+0100)
  0x00, 0x72, 0x01, 0x01, 0x02, // rā (U+0072 U+0101)
  0x00, 0x72, 0x01, 0x02, 0x02, // rĂ (U+0072 U+0102)
  0x00, 0x72, 0x01, 0x03, 0x02, // ră (U+0072 U+0103)
  0x00, 0x72, 0x01, 0x04, 0x02, // rĄ (U+0072 U+0104)
  0x00, 0x72, 0x01, 0x05, 0x02, // rą (U+0072 U+0105)
  0x00, 0x72, 0x20, 0x1A, 0x0A, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x0A, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x0A, // r… (U+0072 U+2026)
  0x00, 0x73, 0x00, 0x57, 0x01, // sW (U+0073 U+0057)
  0x00, 0x73, 0x00, 0x59, 0x04, // sY (U+0073 U+0059)
  0x00, 0x73, 0x00, 0xDD, 0x04, // sÝ (U+0073 U+00DD)
  0x00, 0x73, 0x01, 0x74, 0x01, // sŴ (U+0073 U+0174)
  0x00, 0x73, 0x01, 0x76, 0x04, // sŶ (U+0073 U+0176)
  0x00, 0x73, 0x01, 0x78, 0x04, // sŸ (U+0073 U+0178)
  0x00, 0x76, 0x00, 0x2C, 0x05, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x06, // v. (U+0076 U+002E)
  0x00, 0x76, 0x00, 0x41, 0x04, // vA (U+0076 U+0041)
  0x00, 0x76, 0x00, 0xC0, 0x04, // vÀ (U+0076 U+00C0)
  0x00, 0x76, 0x00, 0xC1, 0x04, // vÁ (U+0076 U+00C1)
  0x00, 0x76, 0x00, 0xC2, 0x04, // vÂ (U+0076 U+00C2)
  0x00, 0x76, 0x00, 0xC3, 0x04, // vÃ (U+0076 U+00C3)
  0x00, 0x76, 0x00, 0xC4, 0x04, // vÄ (U+0076 U+00C4)
  0x00, 0x76, 0x00, 0xC5, 0x04, // vÅ (U+0076 U+00C5)
  0x00, 0x76, 0x01, 0x00, 0x04, // vĀ (U+0076 U+0100)
  0x00, 0x76, 0x01, 0x02, 0x04, // vĂ (U+0076 U+0102)
  0x00, 0x76, 0x01, 0x04, 0x04, // vĄ (U+0076 U+0104)
  0x00, 0x76, 0x20, 0x1A, 0x06, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x06, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x06, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x05, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x05, // w. (U+0077 U+002E)
  0x00, 0x77, 0x00, 0x41, 0x03, // wA (U+0077 U+0041)
  0x00, 0x77, 0x00, 0xC0, 0x03, // wÀ (U+0077 U+00C0)
  0x00, 0x77, 0x00, 0xC1, 0x03, // wÁ (U+0077 U+00C1)
  0x00, 0x77, 0x00, 0xC2, 0x03, // wÂ (U+0077 U+00C2)
  0x00, 0x77, 0x00, 0xC3, 0x03, // wÃ (U+0077 U+00C3)
  0x00, 0x77, 0x00, 0xC4, 0x03, // wÄ (U+0077 U+00C4)
  0x00, 0x77, 0x00, 0xC5, 0x03, // wÅ (U+0077 U+00C5)
  0x00, 0x77, 0x01, 0x00, 0x03, // wĀ (U+0077 U+0100)
  0x00, 0x77, 0x01, 0x02, 0x03, // wĂ (U+0077 U+0102)
  0x00, 0x77, 0x01, 0x04, 0x03, // wĄ (U+0077 U+0104)
  0x00, 0x77, 0x20, 0x1A, 0x05, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x05, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x05, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x07, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x07, // y. (U+0079 U+002E)
  0x00, 0x79, 0x00, 0x41, 0x05, // yA (U+0079 U+0041)
  0x00, 0x79, 0x00, 0xC0, 0x05, // yÀ (U+0079 U+00C0)
  0x00, 0x79, 0x00, 0xC1, 0x05, // yÁ (U+0079 U+00C1)
  0x00, 0x79, 0x00, 0xC2, 0x05, // yÂ (U+0079 U+00C2)
  0x00, 0x79, 0x00, 0xC3, 0x05, // yÃ (U+0079 U+00C3)
  0x00, 0x79, 0x00, 0xC4, 0x05, // yÄ (U+0079 U+00C4)
  0x00, 0x79, 0x00, 0xC5, 0x05, // yÅ (U+0079 U+00C5)
  0x00, 0x79, 0x01, 0x00, 0x05, // yĀ (U+0079 U+0100)
  0x00, 0x79, 0x01, 0x02, 0x05, // yĂ (U+0079 U+0102)
  0x00, 0x79, 0x01, 0x04, 0x05, // yĄ (U+0079 U+0104)
  0x00, 0x79, 0x20, 0x1A, 0x07, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x07, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x07, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x3F, 0x01, // ¡? (U+00A1 U+003F)
  0x00, 0xA1, 0x00, 0x54, 0x01, // ¡T (U+00A1 U+0054)
  0x00, 0xA1, 0x00, 0x56, 0x03, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x57, 0x02, // ¡W (U+00A1 U+0057)
  0x00, 0xA1, 0x00, 0x59, 0x03, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x03, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x62, 0x01, // ¡Ţ (U+00A1 U+0162)
  0x00, 0xA1, 0x01, 0x64, 0x01, // ¡Ť (U+00A1 U+0164)
  0x00, 0xA1, 0x01, 0x66, 0x01, // ¡Ŧ (U+00A1 U+0166)
  0x00, 0xA1, 0x01, 0x74, 0x02, // ¡Ŵ (U+00A1 U+0174)
  0x00, 0xA1, 0x01, 0x76, 0x03, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x03, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xBF, 0x00, 0x3F, 0x02, // ¿? (U+00BF U+003F)
  0x00, 0xBF, 0x00, 0x54, 0x02, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x05, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x05, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x05, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x05, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x02, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x02, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x02, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x05, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x05, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x05, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x07, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x07, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x2A, 0x06, // À* (U+00C0 U+002A)
  0x00, 0xC0, 0x00, 0x3F, 0x05, // À? (U+00C0 U+003F)
  0x00, 0xC0, 0x00, 0x43, 0x02, // ÀC (U+00C0 U+0043)
  0x00, 0xC0, 0x00, 0x47, 0x02, // ÀG (U+00C0 U+0047)
  0x00, 0xC0, 0x00, 0x4F, 0x02, // ÀO (U+00C0 U+004F)
  0x00, 0xC0, 0x00, 0x51, 0x02, // ÀQ (U+00C0 U+0051)
  0x00, 0xC0, 0x00, 0x54, 0x05, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x55, 0x02, // ÀU (U+00C0 U+0055)
  0x00, 0xC0, 0x00, 0x56, 0x06, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x05, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x04, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0x63, 0x02, // Àc (U+00C0 U+0063)
  0x00, 0xC0, 0x00, 0x64, 0x02, // Àd (U+00C0 U+0064)
  0x00, 0xC0, 0x00, 0x65, 0x02, // Àe (U+00C0 U+0065)
  0x00, 0xC0, 0x00, 0x67, 0x02, // Àg (U+00C0 U+0067)
  0x00, 0xC0, 0x00, 0x6F, 0x02, // Ào (U+00C0 U+006F)
  0x00, 0xC0, 0x00, 0x71, 0x02, // Àq (U+00C0 U+0071)
  0x00, 0xC0, 0x00, 0x75, 0x02, // Àu (U+00C0 U+0075)
  0x00, 0xC0, 0x00, 0x76, 0x05, // Àv (U+00C0 U+0076)
  0x00, 0xC0, 0x00, 0x77, 0x03, // Àw (U+00C0 U+0077)
  0x00, 0xC0, 0x00, 0x79, 0x05, // Ày (U+00C0 U+0079)
  0x00, 0xC0, 0x00, 0xC7, 0x02, // ÀÇ (U+00C0 U+00C7)
  0x00, 0xC0, 0x00, 0xD2, 0x02, // ÀÒ (U+00C0 U+00D2)
  0x00, 0xC0, 0x00, 0xD3, 0x02, // ÀÓ (U+00C0 U+00D3)
  0x00, 0xC0, 0x00, 0xD4, 0x02, // ÀÔ (U+00C0 U+00D4)
  0x00, 0xC0, 0x00, 0xD5, 0x02, // ÀÕ (U+00C0 U+00D5)
  0x00, 0xC0, 0x00, 0xD6, 0x02, // ÀÖ (U+00C0 U+00D6)
  0x00, 0xC0, 0x00, 0xD8, 0x02, // ÀØ (U+00C0 U+00D8)
  0x00, 0xC0, 0x00, 0xD9, 0x02, // ÀÙ (U+00C0 U+00D9)
  0x00, 0xC0, 0x00, 0xDA, 0x02, // ÀÚ (U+00C0 U+00DA)
  0x00, 0xC0, 0x00, 0xDB, 0x02, // ÀÛ (U+00C0 U+00DB)
  0x00, 0xC0, 0x00, 0xDC, 0x02, // ÀÜ (U+00C0 U+00DC)
  0x00, 0xC0, 0x00, 0xDD, 0x04, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x00, 0xE7, 0x02, // Àç (U+00C0 U+00E7)
  0x00, 0xC0, 0x00, 0xE8, 0x02, // Àè (U+00C0 U+00E8)
  0x00, 0xC0, 0x00, 0xE9, 0x02, // Àé (U+00C0 U+00E9)
  0x00, 0xC0, 0x00, 0xEA, 0x02, // Àê (U+00C0 U+00EA)
  0x00, 0xC0, 0x00, 0xEB, 0x02, // Àë (U+00C0 U+00EB)
  0x00, 0xC0, 0x00, 0xF0, 0x02, // Àð (U+00C0 U+00F0)
  0x00, 0xC0, 0x00, 0xF2, 0x02, // Àò (U+00C0 U+00F2)
  0x00, 0xC0, 0x00, 0xF3, 0x02, // Àó (U+00C0 U+00F3)
  0x00, 0xC0, 0x00, 0xF4, 0x02, // Àô (U+00C0 U+00F4)
  0x00, 0xC0, 0x00, 0xF5, 0x02, // Àõ (U+00C0 U+00F5)
  0x00, 0xC0, 0x00, 0xF6, 0x02, // Àö (U+00C0 U+00F6)
  0x00, 0xC0, 0x00, 0xF8, 0x02, // Àø (U+00C0 U+00F8)
  0x00, 0xC0, 0x00, 0xF9, 0x02, // Àù (U+00C0 U+00F9)
  0x00, 0xC0, 0x00, 0xFA, 0x02, // Àú (U+00C0 U+00FA)
  0x00, 0xC0, 0x00, 0xFB, 0x02, // Àû (U+00C0 U+00FB)
  0x00, 0xC0, 0x00, 0xFC, 0x02, // Àü (U+00C0 U+00FC)
  0x00, 0xC0, 0x00, 0xFD, 0x05, // Àý (U+00C0 U+00FD)
  0x00, 0xC0, 0x00, 0xFF, 0x05, // Àÿ (U+00C0 U+00FF)
  0x00, 0xC0, 0x01, 0x06, 0x02, // ÀĆ (U+00C0 U+0106)
  0x00, 0xC0, 0x01, 0x07, 0x02, // Àć (U+00C0 U+0107)
  0x00, 0xC0, 0x01, 0x08, 0x02, // ÀĈ (U+00C0 U+0108)
  0x00, 0xC0, 0x01, 0x09, 0x02, // Àĉ (U+00C0 U+0109)
  0x00, 0xC0, 0x01, 0x0A, 0x02, // ÀĊ (U+00C0 U+010A)
  0x00, 0xC0, 0x01, 0x0B, 0x02, // Àċ (U+00C0 U+010B)
  0x00, 0xC0, 0x01, 0x0C, 0x02, // ÀČ (U+00C0 U+010C)
  0x00, 0xC0, 0x01, 0x0D, 0x02, // Àč (U+00C0 U+010D)
  0x00, 0xC0, 0x01, 0x0F, 0x02, // Àď (U+00C0 U+010F)
  0x00, 0xC0, 0x01, 0x11, 0x02, // Àđ (U+00C0 U+0111)
  0x00, 0xC0, 0x01, 0x13, 0x02, // Àē (U+00C0 U+0113)
  0x00, 0xC0, 0x01, 0x15, 0x02, // Àĕ (U+00C0 U+0115)
  0x00, 0xC0, 0x01, 0x17, 0x02, // Àė (U+00C0 U+0117)
  0x00, 0xC0, 0x01, 0x19, 0x02, // Àę (U+00C0 U+0119)
  0x00, 0xC0, 0x01, 0x1B, 0x02, // Àě (U+00C0 U+011B)
  0x00, 0xC0, 0x01, 0x1C, 0x02, // ÀĜ (U+00C0 U+011C)
  0x00, 0xC0, 0x01, 0x1D, 0x02, // Àĝ (U+00C0 U+011D)
  0x00, 0xC0, 0x01, 0x1E, 0x02, // ÀĞ (U+00C0 U+011E)
  0x00, 0xC0, 0x01, 0x1F, 0x02, // Àğ (U+00C0 U+011F)
  0x00, 0xC0, 0x01, 0x20, 0x02, // ÀĠ (U+00C0 U+0120)
  0x00, 0xC0, 0x01, 0x21, 0x02, // Àġ (U+00C0 U+0121)
  0x00, 0xC0, 0x01, 0x22, 0x02, // ÀĢ (U+00C0 U+0122)
  0x00, 0xC0, 0x01, 0x23, 0x02, // Àģ (U+00C0 U+0123)
  0x00, 0xC0, 0x01, 0x4C, 0x02, // ÀŌ (U+00C0 U+014C)
  0x00, 0xC0, 0x01, 0x4D, 0x02, // Àō (U+00C0 U+014D)
  0x00, 0xC0, 0x01, 0x4E, 0x02, // ÀŎ (U+00C0 U+014E)
  0x00, 0xC0, 0x01, 0x4F, 0x02, // Àŏ (U+00C0 U+014F)
  0x00, 0xC0, 0x01, 0x50, 0x02, // ÀŐ (U+00C0 U+0150)
  0x00, 0xC0, 0x01, 0x51, 0x02, // Àő (U+00C0 U+0151)
  0x00, 0xC0, 0x01, 0x52, 0x02, // ÀŒ (U+00C0 U+0152)
  0x00, 0xC0, 0x01, 0x53, 0x02, // Àœ (U+00C0 U+0153)
  0x00, 0xC0, 0x01, 0x62, 0x05, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x05, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x05, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x68, 0x02, // ÀŨ (U+00C0 U+0168)
  0x00, 0xC0, 0x01, 0x69, 0x02, // Àũ (U+00C0 U+0169)
  0x00, 0xC0, 0x01, 0x6A, 0x02, // ÀŪ (U+00C0 U+016A)
  0x00, 0xC0, 0x01, 0x6B, 0x02, // Àū (U+00C0 U+016B)
  0x00, 0xC0, 0x01, 0x6C, 0x02, // ÀŬ (U+00C0 U+016C)
  0x00, 0xC0, 0x01, 0x6D, 0x02, // Àŭ (U+00C0 U+016D)
  0x00, 0xC0, 0x01, 0x6E, 0x02, // ÀŮ (U+00C0 U+016E)
  0x00, 0xC0, 0x01, 0x6F, 0x02, // Àů (U+00C0 U+016F)
  0x00, 0xC0, 0x01, 0x70, 0x02, // ÀŰ (U+00C0 U+0170)
  0x00, 0xC0, 0x01, 0x71, 0x02, // Àű (U+00C0 U+0171)
  0x00, 0xC0, 0x01, 0x72, 0x02, // ÀŲ (U+00C0 U+0172)
  0x00, 0xC0, 0x01, 0x73, 0x02, // Àų (U+00C0 U+0173)
  0x00, 0xC0, 0x01, 0x74, 0x05, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x75, 0x03, // Àŵ (U+00C0 U+0175)
  0x00, 0xC0, 0x01, 0x76, 0x04, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x77, 0x05, // Àŷ (U+00C0 U+0177)
  0x00, 0xC0, 0x01, 0x78, 0x04, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x18, 0x06, // À‘ (U+00C0 U+2018)
  0x00, 0xC0, 0x20, 0x19, 0x06, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1C, 0x06, // À“ (U+00C0 U+201C)
  0x00, 0xC0, 0x20, 0x1D, 0x06, // À” (U+00C0 U+201D)
  0x00, 0xC0, 0x21, 0x22, 0x06, // À™ (U+00C0 U+2122)
  0x00, 0xC1, 0x00, 0x22, 0x07, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x07, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x2A, 0x06, // Á* (U+00C1 U+002A)
  0x00, 0xC1, 0x00, 0x3F, 0x05, // Á? (U+00C1 U+003F)
  0x00, 0xC1, 0x00, 0x43, 0x02, // ÁC (U+00C1 U+0043)
  0x00, 0xC1, 0x00, 0x47, 0x02, // ÁG (U+00C1 U+0047)
  0x00, 0xC1, 0x00, 0x4F, 0x02, // ÁO (U+00C1 U+004F)
  0x00, 0xC1, 0x00, 0x51, 0x02, // ÁQ (U+00C1 U+0051)
  0x00, 0xC1, 0x00, 0x54, 0x05, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x55, 0x02, // ÁU (U+00C1 U+0055)
  0x00, 0xC1, 0x00, 0x56, 0x06, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x05, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x04, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0x63, 0x02, // Ác (U+00C1 U+0063)
  0x00, 0xC1, 0x00, 0x64, 0x02, // Ád (U+00C1 U+0064)
  0x00, 0xC1, 0x00, 0x65, 0x02, // Áe (U+00C1 U+0065)
  0x00, 0xC1, 0x00, 0x67, 0x02, // Ág (U+00C1 U+0067)
  0x00, 0xC1, 0x00, 0x6F, 0x02, // Áo (U+00C1 U+006F)
  0x00, 0xC1, 0x00, 0x71, 0x02, // Áq (U+00C1 U+0071)
  0x00, 0xC1, 0x00, 0x75, 0x02, // Áu (U+00C1 U+0075)
  0x00, 0xC1, 0x00, 0x76, 0x05, // Áv (U+00C1 U+0076)
  0x00, 0xC1, 0x00, 0x77, 0x03, // Áw (U+00C1 U+0077)
  0x00, 0xC1, 0x00, 0x79, 0x05, // Áy (U+00C1 U+0079)
  0x00, 0xC1, 0x00, 0xC7, 0x02, // ÁÇ (U+00C1 U+00C7)
  0x00, 0xC1, 0x00, 0xD2, 0x02, // ÁÒ (U+00C1 U+00D2)
  0x00, 0xC1, 0x00, 0xD3, 0x02, // ÁÓ (U+00C1 U+00D3)
  0x00, 0xC1, 0x00, 0xD4, 0x02, // ÁÔ (U+00C1 U+00D4)
  0x00, 0xC1, 0x00, 0xD5, 0x02, // ÁÕ (U+00C1 U+00D5)
  0x00, 0xC1, 0x00, 0xD6, 0x02, // ÁÖ (U+00C1 U+00D6)
  0x00, 0xC1, 0x00, 0xD8, 0x02, // ÁØ (U+00C1 U+00D8)
  0x00, 0xC1, 0x00, 0xD9, 0x02, // ÁÙ (U+00C1 U+00D9)
  0x00, 0xC1, 0x00, 0xDA, 0x02, // ÁÚ (U+00C1 U+00DA)
  0x00, 0xC1, 0x00, 0xDB, 0x02, // ÁÛ (U+00C1 U+00DB)
  0x00, 0xC1, 0x00, 0xDC, 0x02, // ÁÜ (U+00C1 U+00DC)
  0x00, 0xC1, 0x00, 0xDD, 0x04, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x00, 0xE7, 0x02, // Áç (U+00C1 U+00E7)
  0x00, 0xC1, 0x00, 0xE8, 0x02, // Áè (U+00C1 U+00E8)
  0x00, 0xC1, 0x00, 0xE9, 0x02, // Áé (U+00C1 U+00E9)
  0x00, 0xC1, 0x00, 0xEA, 0x02, // Áê (U+00C1 U+00EA)
  0x00, 0xC1, 0x00, 0xEB, 0x02, // Áë (U+00C1 U+00EB)
  0x00, 0xC1, 0x00, 0xF0, 0x02, // Áð (U+00C1 U+00F0)
  0x00, 0xC1, 0x00, 0xF2, 0x02, // Áò (U+00C1 U+00F2)
  0x00, 0xC1, 0x00, 0xF3, 0x02, // Áó (U+00C1 U+00F3)
  0x00, 0xC1, 0x00, 0xF4, 0x02, // Áô (U+00C1 U+00F4)
  0x00, 0xC1, 0x00, 0xF5, 0x02, // Áõ (U+00C1 U+00F5)
  0x00, 0xC1, 0x00, 0xF6, 0x02, // Áö (U+00C1 U+00F6)
  0x00, 0xC1, 0x00, 0xF8, 0x02, // Áø (U+00C1 U+00F8)
  0x00, 0xC1, 0x00, 0xF9, 0x02, // Áù (U+00C1 U+00F9)
  0x00, 0xC1, 0x00, 0xFA, 0x02, // Áú (U+00C1 U+00FA)
  0x00, 0xC1, 0x00, 0xFB, 0x02, // Áû (U+00C1 U+00FB)
  0x00, 0xC1, 0x00, 0xFC, 0x02, // Áü (U+00C1 U+00FC)
  0x00, 0xC1, 0x00, 0xFD, 0x05, // Áý (U+00C1 U+00FD)
  0x00, 0xC1, 0x00, 0xFF, 0x05, // Áÿ (U+00C1 U+00FF)
  0x00, 0xC1, 0x01, 0x06, 0x02, // ÁĆ (U+00C1 U+0106)
  0x00, 0xC1, 0x01, 0x07, 0x02, // Áć (U+00C1 U+0107)
  0x00, 0xC1, 0x01, 0x08, 0x02, // ÁĈ (U+00C1 U+0108)
  0x00, 0xC1, 0x01, 0x09, 0x02, // Áĉ (U+00C1 U+0109)
  0x00, 0xC1, 0x01, 0x0A, 0x02, // ÁĊ (U+00C1 U+010A)
  0x00, 0xC1, 0x01, 0x0B, 0x02, // Áċ (U+00C1 U+010B)
  0x00, 0xC1, 0x01, 0x0C, 0x02, // ÁČ (U+00C1 U+010C)
  0x00, 0xC1, 0x01, 0x0D, 0x02, // Áč (U+00C1 U+010D)
  0x00, 0xC1, 0x01, 0x0F, 0x02, // Áď (U+00C1 U+010F)
  0x00, 0xC1, 0x01, 0x11, 0x02, // Áđ (U+00C1 U+0111)
  0x00, 0xC1, 0x01, 0x13, 0x02, // Áē (U+00C1 U+0113)
  0x00, 0xC1, 0x01, 0x15, 0x02, // Áĕ (U+00C1 U+0115)
  0x00, 0xC1, 0x01, 0x17, 0x02, // Áė (U+00C1 U+0117)
  0x00, 0xC1, 0x01, 0x19, 0x02, // Áę (U+00C1 U+0119)
  0x00, 0xC1, 0x01, 0x1B, 0x02, // Áě (U+00C1 U+011B)
  0x00, 0xC1, 0x01, 0x1C, 0x02, // ÁĜ (U+00C1 U+011C)
  0x00, 0xC1, 0x01, 0x1D, 0x02, // Áĝ (U+00C1 U+011D)
  0x00, 0xC1, 0x01, 0x1E, 0x02, // ÁĞ (U+00C1 U+011E)
  0x00, 0xC1, 0x01, 0x1F, 0x02, // Áğ (U+00C1 U+011F)
  0x00, 0xC1, 0x01, 0x20, 0x02, // ÁĠ (U+00C1 U+0120)
  0x00, 0xC1, 0x01, 0x21, 0x02, // Áġ (U+00C1 U+0121)
  0x00, 0xC1, 0x01, 0x22, 0x02, // ÁĢ (U+00C1 U+0122)
  0x00, 0xC1, 0x01, 0x23, 0x02, // Áģ (U+00C1 U+0123)
  0x00, 0xC1, 0x01, 0x4C, 0x02, // ÁŌ (U+00C1 U+014C)
  0x00, 0xC1, 0x01, 0x4D, 0x02, // Áō (U+00C1 U+014D)
  0x00, 0xC1, 0x01, 0x4E, 0x02, // ÁŎ (U+00C1 U+014E)
  0x00, 0xC1, 0x01, 0x4F, 0x02, // Áŏ (U+00C1 U+014F)
  0x00, 0xC1, 0x01, 0x50, 0x02, // ÁŐ (U+00C1 U+0150)
  0x00, 0xC1, 0x01, 0x51, 0x02, // Áő (U+00C1 U+0151)
  0x00, 0xC1, 0x01, 0x52, 0x02, // ÁŒ (U+00C1 U+0152)
  0x00, 0xC1, 0x01, 0x53, 0x02, // Áœ (U+00C1 U+0153)
  0x00, 0xC1, 0x01, 0x62, 0x05, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x05, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x05, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x68, 0x02, // ÁŨ (U+00C1 U+0168)
  0x00, 0xC1, 0x01, 0x69, 0x02, // Áũ (U+00C1 U+0169)
  0x00, 0xC1, 0x01, 0x6A, 0x02, // ÁŪ (U+00C1 U+016A)
  0x00, 0xC1, 0x01, 0x6B, 0x02, // Áū (U+00C1 U+016B)
  0x00, 0xC1, 0x01, 0x6C, 0x02, // ÁŬ (U+00C1 U+016C)
  0x00, 0xC1, 0x01, 0x6D, 0x02, // Áŭ (U+00C1 U+016D)
  0x00, 0xC1, 0x01, 0x6E, 0x02, // ÁŮ (U+00C1 U+016E)
  0x00, 0xC1, 0x01, 0x6F, 0x02, // Áů (U+00C1 U+016F)
  0x00, 0xC1, 0x01, 0x70, 0x02, // ÁŰ (U+00C1 U+0170)
  0x00, 0xC1, 0x01, 0x71, 0x02, // Áű (U+00C1 U+0171)
  0x00, 0xC1, 0x01, 0x72, 0x02, // ÁŲ (U+00C1 U+0172)
  0x00, 0xC1, 0x01, 0x73, 0x02, // Áų (U+00C1 U+0173)
  0x00, 0xC1, 0x01, 0x74, 0x05, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x75, 0x03, // Áŵ (U+00C1 U+0175)
  0x00, 0xC1, 0x01, 0x76, 0x04, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x77, 0x05, // Áŷ (U+00C1 U+0177)
  0x00, 0xC1, 0x01, 0x78, 0x04, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x18, 0x06, // Á‘ (U+00C1 U+2018)
  0x00, 0xC1, 0x20, 0x19, 0x06, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1C, 0x06, // Á“ (U+00C1 U+201C)
  0x00, 0xC1, 0x20, 0x1D, 0x06, // Á” (U+00C1 U+201D)
  0x00, 0xC1, 0x21, 0x22, 0x06, // Á™ (U+00C1 U+2122)
  0x00, 0xC2, 0x00, 0x22, 0x07, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x07, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x2A, 0x06, // Â* (U+00C2 U+002A)
  0x00, 0xC2, 0x00, 0x3F, 0x05, // Â? (U+00C2 U+003F)
  0x00, 0xC2, 0x00, 0x43, 0x02, // ÂC (U+00C2 U+0043)
  0x00, 0xC2, 0x00, 0x47, 0x02, // ÂG (U+00C2 U+0047)
  0x00, 0xC2, 0x00, 0x4F, 0x02, // ÂO (U+00C2 U+004F)
  0x00, 0xC2, 0x00, 0x51, 0x02, // ÂQ (U+00C2 U+0051)
  0x00, 0xC2, 0x00, 0x54, 0x05, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x55, 0x02, // ÂU (U+00C2 U+0055)
  0x00, 0xC2, 0x00, 0x56, 0x06, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x05, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x04, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0x63, 0x02, // Âc (U+00C2 U+0063)
  0x00, 0xC2, 0x00, 0x64, 0x02, // Âd (U+00C2 U+0064)
  0x00, 0xC2, 0x00, 0x65, 0x02, // Âe (U+00C2 U+0065)
  0x00, 0xC2, 0x00, 0x67, 0x02, // Âg (U+00C2 U+0067)
  0x00, 0xC2, 0x00, 0x6F, 0x02, // Âo (U+00C2 U+006F)
  0x00, 0xC2, 0x00, 0x71, 0x02, // Âq (U+00C2 U+0071)
  0x00, 0xC2, 0x00, 0x75, 0x02, // Âu (U+00C2 U+0075)
  0x00, 0xC2, 0x00, 0x76, 0x05, // Âv (U+00C2 U+0076)
  0x00, 0xC2, 0x00, 0x77, 0x03, // Âw (U+00C2 U+0077)
  0x00, 0xC2, 0x00, 0x79, 0x05, // Ây (U+00C2 U+0079)
  0x00, 0xC2, 0x00, 0xC7, 0x02, // ÂÇ (U+00C2 U+00C7)
  0x00, 0xC2, 0x00, 0xD2, 0x02, // ÂÒ (U+00C2 U+00D2)
  0x00, 0xC2, 0x00, 0xD3, 0x02, // ÂÓ (U+00C2 U+00D3)
  0x00, 0xC2, 0x00, 0xD4, 0x02, // ÂÔ (U+00C2 U+00D4)
  0x00, 0xC2, 0x00, 0xD5, 0x02, // ÂÕ (U+00C2 U+00D5)
  0x00, 0xC2, 0x00, 0xD6, 0x02, // ÂÖ (U+00C2 U+00D6)
  0x00, 0xC2, 0x00, 0xD8, 0x02, // ÂØ (U+00C2 U+00D8)
  0x00, 0xC2, 0x00, 0xD9, 0x02, // ÂÙ (U+00C2 U+00D9)
  0x00, 0xC2, 0x00, 0xDA, 0x02, // ÂÚ (U+00C2 U+00DA)
  0x00, 0xC2, 0x00, 0xDB, 0x02, // ÂÛ (U+00C2 U+00DB)
  0x00, 0xC2, 0x00, 0xDC, 0x02, // ÂÜ (U+00C2 U+00DC)
  0x00, 0xC2, 0x00, 0xDD, 0x04, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x00, 0xE7, 0x02, // Âç (U+00C2 U+00E7)
  0x00, 0xC2, 0x00, 0xE8, 0x02, // Âè (U+00C2 U+00E8)
  0x00, 0xC2, 0x00, 0xE9, 0x02, // Âé (U+00C2 U+00E9)
  0x00, 0xC2, 0x00, 0xEA, 0x02, // Âê (U+00C2 U+00EA)
  0x00, 0xC2, 0x00, 0xEB, 0x02, // Âë (U+00C2 U+00EB)
  0x00, 0xC2, 0x00, 0xF0, 0x02, // Âð (U+00C2 U+00F0)
  0x00, 0xC2, 0x00, 0xF2, 0x02, // Âò (U+00C2 U+00F2)
  0x00, 0xC2, 0x00, 0xF3, 0x02, // Âó (U+00C2 U+00F3)
  0x00, 0xC2, 0x00, 0xF4, 0x02, // Âô (U+00C2 U+00F4)
  0x00, 0xC2, 0x00, 0xF5, 0x02, // Âõ (U+00C2 U+00F5)
  0x00, 0xC2, 0x00, 0xF6, 0x02, // Âö (U+00C2 U+00F6)
  0x00, 0xC2, 0x00, 0xF8, 0x02, // Âø (U+00C2 U+00F8)
  0x00, 0xC2, 0x00, 0xF9, 0x02, // Âù (U+00C2 U+00F9)
  0x00, 0xC2, 0x00, 0xFA, 0x02, // Âú (U+00C2 U+00FA)
  0x00, 0xC2, 0x00, 0xFB, 0x02, // Âû (U+00C2 U+00FB)
  0x00, 0xC2, 0x00, 0xFC, 0x02, // Âü (U+00C2 U+00FC)
  0x00, 0xC2, 0x00, 0xFD, 0x05, // Âý (U+00C2 U+00FD)
  0x00, 0xC2, 0x00, 0xFF, 0x05, // Âÿ (U+00C2 U+00FF)
  0x00, 0xC2, 0x01, 0x06, 0x02, // ÂĆ (U+00C2 U+0106)
  0x00, 0xC2, 0x01, 0x07, 0x02, // Âć (U+00C2 U+0107)
  0x00, 0xC2, 0x01, 0x08, 0x02, // ÂĈ (U+00C2 U+0108)
  0x00, 0xC2, 0x01, 0x09, 0x02, // Âĉ (U+00C2 U+0109)
  0x00, 0xC2, 0x01, 0x0A, 0x02, // ÂĊ (U+00C2 U+010A)
  0x00, 0xC2, 0x01, 0x0B, 0x02, // Âċ (U+00C2 U+010B)
  0x00, 0xC2, 0x01, 0x0C, 0x02, // ÂČ (U+00C2 U+010C)
  0x00, 0xC2, 0x01, 0x0D, 0x02, // Âč (U+00C2 U+010D)
  0x00, 0xC2, 0x01, 0x0F, 0x02, // Âď (U+00C2 U+010F)
  0x00, 0xC2, 0x01, 0x11, 0x02, // Âđ (U+00C2 U+0111)
  0x00, 0xC2, 0x01, 0x13, 0x02, // Âē (U+00C2 U+0113)
  0x00, 0xC2, 0x01, 0x15, 0x02, // Âĕ (U+00C2 U+0115)
  0x00, 0xC2, 0x01, 0x17, 0x02, // Âė (U+00C2 U+0117)
  0x00, 0xC2, 0x01, 0x19, 0x02, // Âę (U+00C2 U+0119)
  0x00, 0xC2, 0x01, 0x1B, 0x02, // Âě (U+00C2 U+011B)
  0x00, 0xC2, 0x01, 0x1C, 0x02, // ÂĜ (U+00C2 U+011C)
  0x00, 0xC2, 0x01, 0x1D, 0x02, // Âĝ (U+00C2 U+011D)
  0x00, 0xC2, 0x01, 0x1E, 0x02, // ÂĞ (U+00C2 U+011E)
  0x00, 0xC2, 0x01, 0x1F, 0x02, // Âğ (U+00C2 U+011F)
  0x00, 0xC2, 0x01, 0x20, 0x02, // ÂĠ (U+00C2 U+0120)
  0x00, 0xC2, 0x01, 0x21, 0x02, // Âġ (U+00C2 U+0121)
  0x00, 0xC2, 0x01, 0x22, 0x02, // ÂĢ (U+00C2 U+0122)
  0x00, 0xC2, 0x01, 0x23, 0x02, // Âģ (U+00C2 U+0123)
  0x00, 0xC2, 0x01, 0x4C, 0x02, // ÂŌ (U+00C2 U+014C)
  0x00, 0xC2, 0x01, 0x4D, 0x02, // Âō (U+00C2 U+014D)
  0x00, 0xC2, 0x01, 0x4E, 0x02, // ÂŎ (U+00C2 U+014E)
  0x00, 0xC2, 0x01, 0x4F, 0x02, // Âŏ (U+00C2 U+014F)
  0x00, 0xC2, 0x01, 0x50, 0x02, // ÂŐ (U+00C2 U+0150)
  0x00, 0xC2, 0x01, 0x51, 0x02, // Âő (U+00C2 U+0151)
  0x00, 0xC2, 0x01, 0x52, 0x02, // ÂŒ (U+00C2 U+0152)
  0x00, 0xC2, 0x01, 0x53, 0x02, // Âœ (U+00C2 U+0153)
  0x00, 0xC2, 0x01, 0x62, 0x05, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x05, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x05, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x68, 0x02, // ÂŨ (U+00C2 U+0168)
  0x00, 0xC2, 0x01, 0x69, 0x02, // Âũ (U+00C2 U+0169)
  0x00, 0xC2, 0x01, 0x6A, 0x02, // ÂŪ (U+00C2 U+016A)
  0x00, 0xC2, 0x01, 0x6B, 0x02, // Âū (U+00C2 U+016B)
  0x00, 0xC2, 0x01, 0x6C, 0x02, // ÂŬ (U+00C2 U+016C)
  0x00, 0xC2, 0x01, 0x6D, 0x02, // Âŭ (U+00C2 U+016D)
  0x00, 0xC2, 0x01, 0x6E, 0x02, // ÂŮ (U+00C2 U+016E)
  0x00, 0xC2, 0x01, 0x6F, 0x02, // Âů (U+00C2 U+016F)
  0x00, 0xC2, 0x01, 0x70, 0x02, // ÂŰ (U+00C2 U+0170)
  0x00, 0xC2, 0x01, 0x71, 0x02, // Âű (U+00C2 U+0171)
  0x00, 0xC2, 0x01, 0x72, 0x02, // ÂŲ (U+00C2 U+0172)
  0x00, 0xC2, 0x01, 0x73, 0x02, // Âų (U+00C2 U+0173)
  0x00, 0xC2, 0x01, 0x74, 0x05, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x75, 0x03, // Âŵ (U+00C2 U+0175)
  0x00, 0xC2, 0x01, 0x76, 0x04, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x77, 0x05, // Âŷ (U+00C2 U+0177)
  0x00, 0xC2, 0x01, 0x78, 0x04, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x18, 0x06, // Â‘ (U+00C2 U+2018)
  0x00, 0xC2, 0x20, 0x19, 0x06, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1C, 0x06, // Â“ (U+00C2 U+201C)
  0x00, 0xC2, 0x20, 0x1D, 0x06, // Â” (U+00C2 U+201D)
  0x00, 0xC2, 0x21, 0x22, 0x06, // Â™ (U+00C2 U+2122)
  0x00, 0xC3, 0x00, 0x22, 0x07, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x07, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x2A, 0x06, // Ã* (U+00C3 U+002A)
  0x00, 0xC3, 0x00, 0x3F, 0x05, // Ã? (U+00C3 U+003F)
  0x00, 0xC3, 0x00, 0x43, 0x02, // ÃC (U+00C3 U+0043)
  0x00, 0xC3, 0x00, 0x47, 0x02, // ÃG (U+00C3 U+0047)
  0x00, 0xC3, 0x00, 0x4F, 0x02, // ÃO (U+00C3 U+004F)
  0x00, 0xC3, 0x00, 0x51, 0x02, // ÃQ (U+00C3 U+0051)
  0x00, 0xC3, 0x00, 0x54, 0x05, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x55, 0x02, // ÃU (U+00C3 U+0055)
  0x00, 0xC3, 0x00, 0x56, 0x06, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x05, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x04, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0x63, 0x02, // Ãc (U+00C3 U+0063)
  0x00, 0xC3, 0x00, 0x64, 0x02, // Ãd (U+00C3 U+0064)
  0x00, 0xC3, 0x00, 0x65, 0x02, // Ãe (U+00C3 U+0065)
  0x00, 0xC3, 0x00, 0x67, 0x02, // Ãg (U+00C3 U+0067)
  0x00, 0xC3, 0x00, 0x6F, 0x02, // Ão (U+00C3 U+006F)
  0x00, 0xC3, 0x00, 0x71, 0x02, // Ãq (U+00C3 U+0071)
  0x00, 0xC3, 0x00, 0x75, 0x02, // Ãu (U+00C3 U+0075)
  0x00, 0xC3, 0x00, 0x76, 0x05, // Ãv (U+00C3 U+0076)
  0x00, 0xC3, 0x00, 0x77, 0x03, // Ãw (U+00C3 U+0077)
  0x00, 0xC3, 0x00, 0x79, 0x05, // Ãy (U+00C3 U+0079)
  0x00, 0xC3, 0x00, 0xC7, 0x02, // ÃÇ (U+00C3 U+00C7)
  0x00, 0xC3, 0x00, 0xD2, 0x02, // ÃÒ (U+00C3 U+00D2)
  0x00, 0xC3, 0x00, 0xD3, 0x02, // ÃÓ (U+00C3 U+00D3)
  0x00, 0xC3, 0x00, 0xD4, 0x02, // ÃÔ (U+00C3 U+00D4)
  0x00, 0xC3, 0x00, 0xD5, 0x02, // ÃÕ (U+00C3 U+00D5)
  0x00, 0xC3, 0x00, 0xD6, 0x02, // ÃÖ (U+00C3 U+00D6)
  0x00, 0xC3, 0x00, 0xD8, 0x02, // ÃØ (U+00C3 U+00D8)
  0x00, 0xC3, 0x00, 0xD9, 0x02, // ÃÙ (U+00C3 U+00D9)
  0x00, 0xC3, 0x00, 0xDA, 0x02, // ÃÚ (U+00C3 U+00DA)
  0x00, 0xC3, 0x00, 0xDB, 0x02, // ÃÛ (U+00C3 U+00DB)
  0x00, 0xC3, 0x00, 0xDC, 0x02, // ÃÜ (U+00C3 U+00DC)
  0x00, 0xC3, 0x00, 0xDD, 0x04, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x00, 0xE7, 0x02, // Ãç (U+00C3 U+00E7)
  0x00, 0xC3, 0x00, 0xE8, 0x02, // Ãè (U+00C3 U+00E8)
  0x00, 0xC3, 0x00, 0xE9, 0x02, // Ãé (U+00C3 U+00E9)
  0x00, 0xC3, 0x00, 0xEA, 0x02, // Ãê (U+00C3 U+00EA)
  0x00, 0xC3, 0x00, 0xEB, 0x02, // Ãë (U+00C3 U+00EB)
  0x00, 0xC3, 0x00, 0xF0, 0x02, // Ãð (U+00C3 U+00F0)
  0x00, 0xC3, 0x00, 0xF2, 0x02, // Ãò (U+00C3 U+00F2)
  0x00, 0xC3, 0x00, 0xF3, 0x02, // Ãó (U+00C3 U+00F3)
  0x00, 0xC3, 0x00, 0xF4, 0x02, // Ãô (U+00C3 U+00F4)
  0x00, 0xC3, 0x00, 0xF5, 0x02, // Ãõ (U+00C3 U+00F5)
  0x00, 0xC3, 0x00, 0xF6, 0x02, // Ãö (U+00C3 U+00F6)
  0x00, 0xC3, 0x00, 0xF8, 0x02, // Ãø (U+00C3 U+00F8)
  0x00, 0xC3, 0x00, 0xF9, 0x02, // Ãù (U+00C3 U+00F9)
  0x00, 0xC3, 0x00, 0xFA, 0x02, // Ãú (U+00C3 U+00FA)
  0x00, 0xC3, 0x00, 0xFB, 0x02, // Ãû (U+00C3 U+00FB)
  0x00, 0xC3, 0x00, 0xFC, 0x02, // Ãü (U+00C3 U+00FC)
  0x00, 0xC3, 0x00, 0xFD, 0x05, // Ãý (U+00C3 U+00FD)
  0x00, 0xC3, 0x00, 0xFF, 0x05, // Ãÿ (U+00C3 U+00FF)
  0x00, 0xC3, 0x01, 0x06, 0x02, // ÃĆ (U+00C3 U+0106)
  0x00, 0xC3, 0x01, 0x07, 0x02, // Ãć (U+00C3 U+0107)
  0x00, 0xC3, 0x01, 0x08, 0x02, // ÃĈ (U+00C3 U+0108)
  0x00, 0xC3, 0x01, 0x09, 0x02, // Ãĉ (U+00C3 U+0109)
  0x00, 0xC3, 0x01, 0x0A, 0x02, // ÃĊ (U+00C3 U+010A)
  0x00, 0xC3, 0x01, 0x0B, 0x02, // Ãċ (U+00C3 U+010B)
  0x00, 0xC3, 0x01, 0x0C, 0x02, // ÃČ (U+00C3 U+010C)
  0x00, 0xC3, 0x01, 0x0D, 0x02, // Ãč (U+00C3 U+010D)
  0x00, 0xC3, 0x01, 0x0F, 0x02, // Ãď (U+00C3 U+010F)
  0x00, 0xC3, 0x01, 0x11, 0x02, // Ãđ (U+00C3 U+0111)
  0x00, 0xC3, 0x01, 0x13, 0x02, // Ãē (U+00C3 U+0113)
  0x00, 0xC3, 0x01, 0x15, 0x02, // Ãĕ (U+00C3 U+0115)
  0x00, 0xC3, 0x01, 0x17, 0x02, // Ãė (U+00C3 U+0117)
  0x00, 0xC3, 0x01, 0x19, 0x02, // Ãę (U+00C3 U+0119)
  0x00, 0xC3, 0x01, 0x1B, 0x02, // Ãě (U+00C3 U+011B)
  0x00, 0xC3, 0x01, 0x1C, 0x02, // ÃĜ (U+00C3 U+011C)
  0x00, 0xC3, 0x01, 0x1D, 0x02, // Ãĝ (U+00C3 U+011D)
  0x00, 0xC3, 0x01, 0x1E, 0x02, // ÃĞ (U+00C3 U+011E)
  0x00, 0xC3, 0x01, 0x1F, 0x02, // Ãğ (U+00C3 U+011F)
  0x00, 0xC3, 0x01, 0x20, 0x02, // ÃĠ (U+00C3 U+0120)
  0x00, 0xC3, 0x01, 0x21, 0x02, // Ãġ (U+00C3 U+0121)
  0x00, 0xC3, 0x01, 0x22, 0x02, // ÃĢ (U+00C3 U+0122)
  0x00, 0xC3, 0x01, 0x23, 0x02, // Ãģ (U+00C3 U+0123)
  0x00, 0xC3, 0x01, 0x4C, 0x02, // ÃŌ (U+00C3 U+014C)
  0x00, 0xC3, 0x01, 0x4D, 0x02, // Ãō (U+00C3 U+014D)
  0x00, 0xC3, 0x01, 0x4E, 0x02, // ÃŎ (U+00C3 U+014E)
  0x00, 0xC3, 0x01, 0x4F, 0x02, // Ãŏ (U+00C3 U+014F)
  0x00, 0xC3, 0x01, 0x50, 0x02, // ÃŐ (U+00C3 U+0150)
  0x00, 0xC3, 0x01, 0x51, 0x02, // Ãő (U+00C3 U+0151)
  0x00, 0xC3, 0x01, 0x52, 0x02, // ÃŒ (U+00C3 U+0152)
  0x00, 0xC3, 0x01, 0x53, 0x02, // Ãœ (U+00C3 U+0153)
  0x00, 0xC3, 0x01, 0x62, 0x05, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x05, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x05, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x68, 0x02, // ÃŨ (U+00C3 U+0168)
  0x00, 0xC3, 0x01, 0x69, 0x02, // Ãũ (U+00C3 U+0169)
  0x00, 0xC3, 0x01, 0x6A, 0x02, // ÃŪ (U+00C3 U+016A)
  0x00, 0xC3, 0x01, 0x6B, 0x02, // Ãū (U+00C3 U+016B)
  0x00, 0xC3, 0x01, 0x6C, 0x02, // ÃŬ (U+00C3 U+016C)
  0x00, 0xC3, 0x01, 0x6D, 0x02, // Ãŭ (U+00C3 U+016D)
  0x00, 0xC3, 0x01, 0x6E, 0x02, // ÃŮ (U+00C3 U+016E)
  0x00, 0xC3, 0x01, 0x6F, 0x02, // Ãů (U+00C3 U+016F)
  0x00, 0xC3, 0x01, 0x70, 0x02, // ÃŰ (U+00C3 U+0170)
  0x00, 0xC3, 0x01, 0x71, 0x02, // Ãű (U+00C3 U+0171)
  0x00, 0xC3, 0x01, 0x72, 0x02, // ÃŲ (U+00C3 U+0172)
  0x00, 0xC3, 0x01, 0x73, 0x02, // Ãų (U+00C3 U+0173)
  0x00, 0xC3, 0x01, 0x74, 0x05, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x75, 0x03, // Ãŵ (U+00C3 U+0175)
  0x00, 0xC3, 0x01, 0x76, 0x04, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x77, 0x05, // Ãŷ (U+00C3 U+0177)
  0x00, 0xC3, 0x01, 0x78, 0x04, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x18, 0x06, // Ã‘ (U+00C3 U+2018)
  0x00, 0xC3, 0x20, 0x19, 0x06, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1C, 0x06, // Ã“ (U+00C3 U+201C)
  0x00, 0xC3, 0x20, 0x1D, 0x06, // Ã” (U+00C3 U+201D)
  0x00, 0xC3, 0x21, 0x22, 0x06, // Ã™ (U+00C3 U+2122)
  0x00, 0xC4, 0x00, 0x22, 0x07, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x07, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x2A, 0x06, // Ä* (U+00C4 U+002A)
  0x00, 0xC4, 0x00, 0x3F, 0x05, // Ä? (U+00C4 U+003F)
  0x00, 0xC4, 0x00, 0x43, 0x02, // ÄC (U+00C4 U+0043)
  0x00, 0xC4, 0x00, 0x47, 0x02, // ÄG (U+00C4 U+0047)
  0x00, 0xC4, 0x00, 0x4F, 0x02, // ÄO (U+00C4 U+004F)
  0x00, 0xC4, 0x00, 0x51, 0x02, // ÄQ (U+00C4 U+0051)
  0x00, 0xC4, 0x00, 0x54, 0x05, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x55, 0x02, // ÄU (U+00C4 U+0055)
  0x00, 0xC4, 0x00, 0x56, 0x06, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x05, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x04, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0x63, 0x02, // Äc (U+00C4 U+0063)
  0x00, 0xC4, 0x00, 0x64, 0x02, // Äd (U+00C4 U+0064)
  0x00, 0xC4, 0x00, 0x65, 0x02, // Äe (U+00C4 U+0065)
  0x00, 0xC4, 0x00, 0x67, 0x02, // Äg (U+00C4 U+0067)
  0x00, 0xC4, 0x00, 0x6F, 0x02, // Äo (U+00C4 U+006F)
  0x00, 0xC4, 0x00, 0x71, 0x02, // Äq (U+00C4 U+0071)
  0x00, 0xC4, 0x00, 0x75, 0x02, // Äu (U+00C4 U+0075)
  0x00, 0xC4, 0x00, 0x76, 0x05, // Äv (U+00C4 U+0076)
  0x00, 0xC4, 0x00, 0x77, 0x03, // Äw (U+00C4 U+0077)
  0x00, 0xC4, 0x00, 0x79, 0x05, // Äy (U+00C4 U+0079)
  0x00, 0xC4, 0x00, 0xC7, 0x02, // ÄÇ (U+00C4 U+00C7)
  0x00, 0xC4, 0x00, 0xD2, 0x02, // ÄÒ (U+00C4 U+00D2)
  0x00, 0xC4, 0x00, 0xD3, 0x02, // ÄÓ (U+00C4 U+00D3)
  0x00, 0xC4, 0x00, 0xD4, 0x02, // ÄÔ (U+00C4 U+00D4)
  0x00, 0xC4, 0x00, 0xD5, 0x02, // ÄÕ (U+00C4 U+00D5)
  0x00, 0xC4, 0x00, 0xD6, 0x02, // ÄÖ (U+00C4 U+00D6)
  0x00, 0xC4, 0x00, 0xD8, 0x02, // ÄØ (U+00C4 U+00D8)
  0x00, 0xC4, 0x00, 0xD9, 0x02, // ÄÙ (U+00C4 U+00D9)
  0x00, 0xC4, 0x00, 0xDA, 0x02, // ÄÚ (U+00C4 U+00DA)
  0x00, 0xC4, 0x00, 0xDB, 0x02, // ÄÛ (U+00C4 U+00DB)
  0x00, 0xC4, 0x00, 0xDC, 0x02, // ÄÜ (U+00C4 U+00DC)
  0x00, 0xC4, 0x00, 0xDD, 0x04, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x00, 0xE7, 0x02, // Äç (U+00C4 U+00E7)
  0x00, 0xC4, 0x00, 0xE8, 0x02, // Äè (U+00C4 U+00E8)
  0x00, 0xC4, 0x00, 0xE9, 0x02, // Äé (U+00C4 U+00E9)
  0x00, 0xC4, 0x00, 0xEA, 0x02, // Äê (U+00C4 U+00EA)
  0x00, 0xC4, 0x00, 0xEB, 0x02, // Äë (U+00C4 U+00EB)
  0x00, 0xC4, 0x00, 0xF0, 0x02, // Äð (U+00C4 U+00F0)
  0x00, 0xC4, 0x00, 0xF2, 0x02, // Äò (U+00C4 U+00F2)
  0x00, 0xC4, 0x00, 0xF3, 0x02, // Äó (U+00C4 U+00F3)
  0x00, 0xC4, 0x00, 0xF4, 0x02, // Äô (U+00C4 U+00F4)
  0x00, 0xC4, 0x00, 0xF5, 0x02, // Äõ (U+00C4 U+00F5)
  0x00, 0xC4, 0x00, 0xF6, 0x02, // Äö (U+00C4 U+00F6)
  0x00, 0xC4, 0x00, 0xF8, 0x02, // Äø (U+00C4 U+00F8)
  0x00, 0xC4, 0x00, 0xF9, 0x02, // Äù (U+00C4 U+00F9)
  0x00, 0xC4, 0x00, 0xFA, 0x02, // Äú (U+00C4 U+00FA)
  0x00, 0xC4, 0x00, 0xFB, 0x02, // Äû (U+00C4 U+00FB)
  0x00, 0xC4, 0x00, 0xFC, 0x02, // Äü (U+00C4 U+00FC)
  0x00, 0xC4, 0x00, 0xFD, 0x05, // Äý (U+00C4 U+00FD)
  0x00, 0xC4, 0x00, 0xFF, 0x05, // Äÿ (U+00C4 U+00FF)
  0x00, 0xC4, 0x01, 0x06, 0x02, // ÄĆ (U+00C4 U+0106)
  0x00, 0xC4, 0x01, 0x07, 0x02, // Äć (U+00C4 U+0107)
  0x00, 0xC4, 0x01, 0x08, 0x02, // ÄĈ (U+00C4 U+0108)
  0x00, 0xC4, 0x01, 0x09, 0x02, // Äĉ (U+00C4 U+0109)
  0x00, 0xC4, 0x01, 0x0A, 0x02, // ÄĊ (U+00C4 U+010A)
  0x00, 0xC4, 0x01, 0x0B, 0x02, // Äċ (U+00C4 U+010B)
  0x00, 0xC4, 0x01, 0x0C, 0x02, // ÄČ (U+00C4 U+010C)
  0x00, 0xC4, 0x01, 0x0D, 0x02, // Äč (U+00C4 U+010D)
  0x00, 0xC4, 0x01, 0x0F, 0x02, // Äď (U+00C4 U+010F)
  0x00, 0xC4, 0x01, 0x11, 0x02, // Äđ (U+00C4 U+0111)
  0x00, 0xC4, 0x01, 0x13, 0x02, // Äē (U+00C4 U+0113)
  0x00, 0xC4, 0x01, 0x15, 0x02, // Äĕ (U+00C4 U+0115)
  0x00, 0xC4, 0x01, 0x17, 0x02, // Äė (U+00C4 U+0117)
  0x00, 0xC4, 0x01, 0x19, 0x02, // Äę (U+00C4 U+0119)
  0x00, 0xC4, 0x01, 0x1B, 0x02, // Äě (U+00C4 U+011B)
  0x00, 0xC4, 0x01, 0x1C, 0x02, // ÄĜ (U+00C4 U+011C)
  0x00, 0xC4, 0x01, 0x1D, 0x02, // Äĝ (U+00C4 U+011D)
  0x00, 0xC4, 0x01, 0x1E, 0x02, // ÄĞ (U+00C4 U+011E)
  0x00, 0xC4, 0x01, 0x1F, 0x02, // Äğ (U+00C4 U+011F)
  0x00, 0xC4, 0x01, 0x20, 0x02, // ÄĠ (U+00C4 U+0120)
  0x00, 0xC4, 0x01, 0x21, 0x02, // Äġ (U+00C4 U+0121)
  0x00, 0xC4, 0x01, 0x22, 0x02, // ÄĢ (U+00C4 U+0122)
  0x00, 0xC4, 0x01, 0x23, 0x02, // Äģ (U+00C4 U+0123)
  0x00, 0xC4, 0x01, 0x4C, 0x02, // ÄŌ (U+00C4 U+014C)
  0x00, 0xC4, 0x01, 0x4D, 0x02, // Äō (U+00C4 U+014D)
  0x00, 0xC4, 0x01, 0x4E, 0x02, // ÄŎ (U+00C4 U+014E)
  0x00, 0xC4, 0x01, 0x4F, 0x02, // Äŏ (U+00C4 U+014F)
  0x00, 0xC4, 0x01, 0x50, 0x02, // ÄŐ (U+00C4 U+0150)
  0x00, 0xC4, 0x01, 0x51, 0x02, // Äő (U+00C4 U+0151)
  0x00, 0xC4, 0x01, 0x52, 0x02, // ÄŒ (U+00C4 U+0152)
  0x00, 0xC4, 0x01, 0x53, 0x02, // Äœ (U+00C4 U+0153)
  0x00, 0xC4, 0x01, 0x62, 0x05, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x05, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x05, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x68, 0x02, // ÄŨ (U+00C4 U+0168)
  0x00, 0xC4, 0x01, 0x69, 0x02, // Äũ (U+00C4 U+0169)
  0x00, 0xC4, 0x01, 0x6A, 0x02, // ÄŪ (U+00C4 U+016A)
  0x00, 0xC4, 0x01, 0x6B, 0x02, // Äū (U+00C4 U+016B)
  0x00, 0xC4, 0x01, 0x6C, 0x02, // ÄŬ (U+00C4 U+016C)
  0x00, 0xC4, 0x01, 0x6D, 0x02, // Äŭ (U+00C4 U+016D)
  0x00, 0xC4, 0x01, 0x6E, 0x02, // ÄŮ (U+00C4 U+016E)
  0x00, 0xC4, 0x01, 0x6F, 0x02, // Äů (U+00C4 U+016F)
  0x00, 0xC4, 0x01, 0x70, 0x02, // ÄŰ (U+00C4 U+0170)
  0x00, 0xC4, 0x01, 0x71, 0x02, // Äű (U+00C4 U+0171)
  0x00, 0xC4, 0x01, 0x72, 0x02, // ÄŲ (U+00C4 U+0172)
  0x00, 0xC4, 0x01, 0x73, 0x02, // Äų (U+00C4 U+0173)
  0x00, 0xC4, 0x01, 0x74, 0x05, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x75, 0x03, // Äŵ (U+00C4 U+0175)
  0x00, 0xC4, 0x01, 0x76, 0x04, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x77, 0x05, // Äŷ (U+00C4 U+0177)
  0x00, 0xC4, 0x01, 0x78, 0x04, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x18, 0x06, // Ä‘ (U+00C4 U+2018)
  0x00, 0xC4, 0x20, 0x19, 0x06, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1C, 0x06, // Ä“ (U+00C4 U+201C)
  0x00, 0xC4, 0x20, 0x1D, 0x06, // Ä” (U+00C4 U+201D)
  0x00, 0xC4, 0x21, 0x22, 0x06, // Ä™ (U+00C4 U+2122)
  0x00, 0xC5, 0x00, 0x22, 0x07, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x07, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x2A, 0x06, // Å* (U+00C5 U+002A)
  0x00, 0xC5, 0x00, 0x3F, 0x05, // Å? (U+00C5 U+003F)
  0x00, 0xC5, 0x00, 0x43, 0x02, // ÅC (U+00C5 U+0043)
  0x00, 0xC5, 0x00, 0x47, 0x02, // ÅG (U+00C5 U+0047)
  0x00, 0xC5, 0x00, 0x4F, 0x02, // ÅO (U+00C5 U+004F)
  0x00, 0xC5, 0x00, 0x51, 0x02, // ÅQ (U+00C5 U+0051)
  0x00, 0xC5, 0x00, 0x54, 0x05, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x55, 0x02, // ÅU (U+00C5 U+0055)
  0x00, 0xC5, 0x00, 0x56, 0x06, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x05, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x04, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0x63, 0x02, // Åc (U+00C5 U+0063)
  0x00, 0xC5, 0x00, 0x64, 0x02, // Åd (U+00C5 U+0064)
  0x00, 0xC5, 0x00, 0x65, 0x02, // Åe (U+00C5 U+0065)
  0x00, 0xC5, 0x00, 0x67, 0x02, // Åg (U+00C5 U+0067)
  0x00, 0xC5, 0x00, 0x6F, 0x02, // Åo (U+00C5 U+006F)
  0x00, 0xC5, 0x00, 0x71, 0x02, // Åq (U+00C5 U+0071)
  0x00, 0xC5, 0x00, 0x75, 0x02, // Åu (U+00C5 U+0075)
  0x00, 0xC5, 0x00, 0x76, 0x05, // Åv (U+00C5 U+0076)
  0x00, 0xC5, 0x00, 0x77, 0x03, // Åw (U+00C5 U+0077)
  0x00, 0xC5, 0x00, 0x79, 0x05, // Åy (U+00C5 U+0079)
  0x00, 0xC5, 0x00, 0xC7, 0x02, // ÅÇ (U+00C5 U+00C7)
  0x00, 0xC5, 0x00, 0xD2, 0x02, // ÅÒ (U+00C5 U+00D2)
  0x00, 0xC5, 0x00, 0xD3, 0x02, // ÅÓ (U+00C5 U+00D3)
  0x00, 0xC5, 0x00, 0xD4, 0x02, // ÅÔ (U+00C5 U+00D4)
  0x00, 0xC5, 0x00, 0xD5, 0x02, // ÅÕ (U+00C5 U+00D5)
  0x00, 0xC5, 0x00, 0xD6, 0x02, // ÅÖ (U+00C5 U+00D6)
  0x00, 0xC5, 0x00, 0xD8, 0x02, // ÅØ (U+00C5 U+00D8)
  0x00, 0xC5, 0x00, 0xD9, 0x02, // ÅÙ (U+00C5 U+00D9)
  0x00, 0xC5, 0x00, 0xDA, 0x02, // ÅÚ (U+00C5 U+00DA)
  0x00, 0xC5, 0x00, 0xDB, 0x02, // ÅÛ (U+00C5 U+00DB)
  0x00, 0xC5, 0x00, 0xDC, 0x02, // ÅÜ (U+00C5 U+00DC)
  0x00, 0xC5, 0x00, 0xDD, 0x04, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x00, 0xE7, 0x02, // Åç (U+00C5 U+00E7)
  0x00, 0xC5, 0x00, 0xE8, 0x02, // Åè (U+00C5 U+00E8)
  0x00, 0xC5, 0x00, 0xE9, 0x02, // Åé (U+00C5 U+00E9)
  0x00, 0xC5, 0x00, 0xEA, 0x02, // Åê (U+00C5 U+00EA)
  0x00, 0xC5, 0x00, 0xEB, 0x02, // Åë (U+00C5 U+00EB)
  0x00, 0xC5, 0x00, 0xF0, 0x02, // Åð (U+00C5 U+00F0)
  0x00, 0xC5, 0x00, 0xF2, 0x02, // Åò (U+00C5 U+00F2)
  0x00, 0xC5, 0x00, 0xF3, 0x02, // Åó (U+00C5 U+00F3)
  0x00, 0xC5, 0x00, 0xF4, 0x02, // Åô (U+00C5 U+00F4)
  0x00, 0xC5, 0x00, 0xF5, 0x02, // Åõ (U+00C5 U+00F5)
  0x00, 0xC5, 0x00, 0xF6, 0x02, // Åö (U+00C5 U+00F6)
  0x00, 0xC5, 0x00, 0xF8, 0x02, // Åø (U+00C5 U+00F8)
  0x00, 0xC5, 0x00, 0xF9, 0x02, // Åù (U+00C5 U+00F9)
  0x00, 0xC5, 0x00, 0xFA, 0x02, // Åú (U+00C5 U+00FA)
  0x00, 0xC5, 0x00, 0xFB, 0x02, // Åû (U+00C5 U+00FB)
  0x00, 0xC5, 0x00, 0xFC, 0x02, // Åü (U+00C5 U+00FC)
  0x00, 0xC5, 0x00, 0xFD, 0x05, // Åý (U+00C5 U+00FD)
  0x00, 0xC5, 0x00, 0xFF, 0x05, // Åÿ (U+00C5 U+00FF)
  0x00, 0xC5, 0x01, 0x06, 0x02, // ÅĆ (U+00C5 U+0106)
  0x00, 0xC5, 0x01, 0x07, 0x02, // Åć (U+00C5 U+0107)
  0x00, 0xC5, 0x01, 0x08, 0x02, // ÅĈ (U+00C5 U+0108)
  0x00, 0xC5, 0x01, 0x09, 0x02, // Åĉ (U+00C5 U+0109)
  0x00, 0xC5, 0x01, 0x0A, 0x02, // ÅĊ (U+00C5 U+010A)
  0x00, 0xC5, 0x01, 0x0B, 0x02, // Åċ (U+00C5 U+010B)
  0x00, 0xC5, 0x01, 0x0C, 0x02, // ÅČ (U+00C5 U+010C)
  0x00, 0xC5, 0x01, 0x0D, 0x02, // Åč (U+00C5 U+010D)
  0x00, 0xC5, 0x01, 0x0F, 0x02, // Åď (U+00C5 U+010F)
  0x00, 0xC5, 0x01, 0x11, 0x02, // Åđ (U+00C5 U+0111)
  0x00, 0xC5, 0x01, 0x13, 0x02, // Åē (U+00C5 U+0113)
  0x00, 0xC5, 0x01, 0x15, 0x02, // Åĕ (U+00C5 U+0115)
  0x00, 0xC5, 0x01, 0x17, 0x02, // Åė (U+00C5 U+0117)
  0x00, 0xC5, 0x01, 0x19, 0x02, // Åę (U+00C5 U+0119)
  0x00, 0xC5, 0x01, 0x1B, 0x02, // Åě (U+00C5 U+011B)
  0x00, 0xC5, 0x01, 0x1C, 0x02, // ÅĜ (U+00C5 U+011C)
  0x00, 0xC5, 0x01, 0x1D, 0x02, // Åĝ (U+00C5 U+011D)
  0x00, 0xC5, 0x01, 0x1E, 0x02, // ÅĞ (U+00C5 U+011E)
  0x00, 0xC5, 0x01, 0x1F, 0x02, // Åğ (U+00C5 U+011F)
  0x00, 0xC5, 0x01, 0x20, 0x02, // ÅĠ (U+00C5 U+0120)
  0x00, 0xC5, 0x01, 0x21, 0x02, // Åġ (U+00C5 U+0121)
  0x00, 0xC5, 0x01, 0x22, 0x02, // ÅĢ (U+00C5 U+0122)
  0x00, 0xC5, 0x01, 0x23, 0x02, // Åģ (U+00C5 U+0123)
  0x00, 0xC5, 0x01, 0x4C, 0x02, // ÅŌ (U+00C5 U+014C)
  0x00, 0xC5, 0x01, 0x4D, 0x02, // Åō (U+00C5 U+014D)
  0x00, 0xC5, 0x01, 0x4E, 0x02, // ÅŎ (U+00C5 U+014E)
  0x00, 0xC5, 0x01, 0x4F, 0x02, // Åŏ (U+00C5 U+014F)
  0x00, 0xC5, 0x01, 0x50, 0x02, // ÅŐ (U+00C5 U+0150)
  0x00, 0xC5, 0x01, 0x51, 0x02, // Åő (U+00C5 U+0151)
  0x00, 0xC5, 0x01, 0x52, 0x02, // ÅŒ (U+00C5 U+0152)
  0x00, 0xC5, 0x01, 0x53, 0x02, // Åœ (U+00C5 U+0153)
  0x00, 0xC5, 0x01, 0x62, 0x05, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x05, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x05, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x68, 0x02, // ÅŨ (U+00C5 U+0168)
  0x00, 0xC5, 0x01, 0x69, 0x02, // Åũ (U+00C5 U+0169)
  0x00, 0xC5, 0x01, 0x6A, 0x02, // ÅŪ (U+00C5 U+016A)
  0x00, 0xC5, 0x01, 0x6B, 0x02, // Åū (U+00C5 U+016B)
  0x00, 0xC5, 0x01, 0x6C, 0x02, // ÅŬ (U+00C5 U+016C)
  0x00, 0xC5, 0x01, 0x6D, 0x02, // Åŭ (U+00C5 U+016D)
  0x00, 0xC5, 0x01, 0x6E, 0x02, // ÅŮ (U+00C5 U+016E)
  0x00, 0xC5, 0x01, 0x6F, 0x02, // Åů (U+00C5 U+016F)
  0x00, 0xC5, 0x01, 0x70, 0x02, // ÅŰ (U+00C5 U+0170)
  0x00, 0xC5, 0x01, 0x71, 0x02, // Åű (U+00C5 U+0171)
  0x00, 0xC5, 0x01, 0x72, 0x02, // ÅŲ (U+00C5 U+0172)
  0x00, 0xC5, 0x01, 0x73, 0x02, // Åų (U+00C5 U+0173)
  0x00, 0xC5, 0x01, 0x74, 0x05, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x75, 0x03, // Åŵ (U+00C5 U+0175)
  0x00, 0xC5, 0x01, 0x76, 0x04, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x77, 0x05, // Åŷ (U+00C5 U+0177)
  0x00, 0xC5, 0x01, 0x78, 0x04, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x18, 0x06, // Å‘ (U+00C5 U+2018)
  0x00, 0xC5, 0x20, 0x19, 0x06, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1C, 0x06, // Å“ (U+00C5 U+201C)
  0x00, 0xC5, 0x20, 0x1D, 0x06, // Å” (U+00C5 U+201D)
  0x00, 0xC5, 0x21, 0x22, 0x06, // Å™ (U+00C5 U+2122)
  0x00, 0xC6, 0x00, 0x56, 0x02, // ÆV (U+00C6 U+0056)
  0x00, 0xC6, 0x00, 0x57, 0x02, // ÆW (U+00C6 U+0057)
  0x00, 0xC6, 0x00, 0x59, 0x02, // ÆY (U+00C6 U+0059)
  0x00, 0xC6, 0x00, 0xDD, 0x02, // ÆÝ (U+00C6 U+00DD)
  0x00, 0xC6, 0x01, 0x74, 0x02, // ÆŴ (U+00C6 U+0174)
  0x00, 0xC6, 0x01, 0x76, 0x02, // ÆŶ (U+00C6 U+0176)
  0x00, 0xC6, 0x01, 0x78, 0x02, // ÆŸ (U+00C6 U+0178)
  0x00, 0xC7, 0x00, 0x43, 0x01, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x01, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x01, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x01, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xC7, 0x01, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x01, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x01, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x01, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x01, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x01, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x01, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x01, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x01, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x01, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x01, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x01, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x01, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x01, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x01, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x01, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x01, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x01, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x01, // ÇŒ (U+00C7 U+0152)
  0x00, 0xC8, 0x00, 0x56, 0x02, // ÈV (U+00C8 U+0056)
  0x00, 0xC8, 0x00, 0x57, 0x02, // ÈW (U+00C8 U+0057)
  0x00, 0xC8, 0x00, 0x59, 0x02, // ÈY (U+00C8 U+0059)
  0x00, 0xC8, 0x00, 0xDD, 0x02, // ÈÝ (U+00C8 U+00DD)
  0x00, 0xC8, 0x01, 0x74, 0x02, // ÈŴ (U+00C8 U+0174)
  0x00, 0xC8, 0x01, 0x76, 0x02, // ÈŶ (U+00C8 U+0176)
  0x00, 0xC8, 0x01, 0x78, 0x02, // ÈŸ (U+00C8 U+0178)
  0x00, 0xC9, 0x00, 0x56, 0x02, // ÉV (U+00C9 U+0056)
  0x00, 0xC9, 0x00, 0x57, 0x02, // ÉW (U+00C9 U+0057)
  0x00, 0xC9, 0x00, 0x59, 0x02, // ÉY (U+00C9 U+0059)
  0x00, 0xC9, 0x00, 0xDD, 0x02, // ÉÝ (U+00C9 U+00DD)
  0x00, 0xC9, 0x01, 0x74, 0x02, // ÉŴ (U+00C9 U+0174)
  0x00, 0xC9, 0x01, 0x76, 0x02, // ÉŶ (U+00C9 U+0176)
  0x00, 0xC9, 0x01, 0x78, 0x02, // ÉŸ (U+00C9 U+0178)
  0x00, 0xCA, 0x00, 0x56, 0x02, // ÊV (U+00CA U+0056)
  0x00, 0xCA, 0x00, 0x57, 0x02, // ÊW (U+00CA U+0057)
  0x00, 0xCA, 0x00, 0x59, 0x02, // ÊY (U+00CA U+0059)
  0x00, 0xCA, 0x00, 0xDD, 0x02, // ÊÝ (U+00CA U+00DD)
  0x00, 0xCA, 0x01, 0x74, 0x02, // ÊŴ (U+00CA U+0174)
  0x00, 0xCA, 0x01, 0x76, 0x02, // ÊŶ (U+00CA U+0176)
  0x00, 0xCA, 0x01, 0x78, 0x02, // ÊŸ (U+00CA U+0178)
  0x00, 0xCB, 0x00, 0x56, 0x02, // ËV (U+00CB U+0056)
  0x00, 0xCB, 0x00, 0x57, 0x02, // ËW (U+00CB U+0057)
  0x00, 0xCB, 0x00, 0x59, 0x02, // ËY (U+00CB U+0059)
  0x00, 0xCB, 0x00, 0xDD, 0x02, // ËÝ (U+00CB U+00DD)
  0x00, 0xCB, 0x01, 0x74, 0x02, // ËŴ (U+00CB U+0174)
  0x00, 0xCB, 0x01, 0x76, 0x02, // ËŶ (U+00CB U+0176)
  0x00, 0xCB, 0x01, 0x78, 0x02, // ËŸ (U+00CB U+0178)
  0x00, 0xD0, 0x00, 0x2C, 0x02, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x02, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x3F, 0x02, // Ð? (U+00D0 U+003F)
  0x00, 0xD0, 0x00, 0x41, 0x02, // ÐA (U+00D0 U+0041)
  0x00, 0xD0, 0x00, 0x54, 0x02, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x00, 0x56, 0x02, // ÐV (U+00D0 U+0056)
  0x00, 0xD0, 0x00, 0x57, 0x02, // ÐW (U+00D0 U+0057)
  0x00, 0xD0, 0x00, 0x58, 0x02, // ÐX (U+00D0 U+0058)
  0x00, 0xD0, 0x00, 0x59, 0x03, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0xC0, 0x02, // ÐÀ (U+00D0 U+00C0)
  0x00, 0xD0, 0x00, 0xC1, 0x02, // ÐÁ (U+00D0 U+00C1)
  0x00, 0xD0, 0x00, 0xC2, 0x02, // ÐÂ (U+00D0 U+00C2)
  0x00, 0xD0, 0x00, 0xC3, 0x02, // ÐÃ (U+00D0 U+00C3)
  0x00, 0xD0, 0x00, 0xC4, 0x02, // ÐÄ (U+00D0 U+00C4)
  0x00, 0xD0, 0x00, 0xC5, 0x02, // ÐÅ (U+00D0 U+00C5)
  0x00, 0xD0, 0x00, 0xC6, 0x05, // ÐÆ (U+00D0 U+00C6)
  0x00, 0xD0, 0x00, 0xDD, 0x03, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x00, 0x02, // ÐĀ (U+00D0 U+0100)
  0x00, 0xD0, 0x01, 0x02, 0x02, // ÐĂ (U+00D0 U+0102)
  0x00, 0xD0, 0x01, 0x04, 0x02, // ÐĄ (U+00D0 U+0104)
  0x00, 0xD0, 0x01, 0x62, 0x02, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x02, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x02, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x01, 0x74, 0x02, // ÐŴ (U+00D0 U+0174)
  0x00, 0xD0, 0x01, 0x76, 0x03, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x03, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD0, 0x20, 0x1A, 0x02, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x02, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x02, // Ð… (U+00D0 U+2026)
  0x00, 0xD1, 0x00, 0x41, 0x01, // ÑA (U+00D1 U+0041)
  0x00, 0xD1, 0x00, 0xAB, 0x01, // Ñ« (U+00D1 U+00AB)
  0x00, 0xD1, 0x00, 0xBB, 0x01, // Ñ» (U+00D1 U+00BB)
  0x00, 0xD1, 0x00, 0xC0, 0x01, // ÑÀ (U+00D1 U+00C0)
  0x00, 0xD1, 0x00, 0xC1, 0x01, // ÑÁ (U+00D1 U+00C1)
  0x00, 0xD1, 0x00, 0xC2, 0x01, // ÑÂ (U+00D1 U+00C2)
  0x00, 0xD1, 0x00, 0xC3, 0x01, // ÑÃ (U+00D1 U+00C3)
  0x00, 0xD1, 0x00, 0xC4, 0x01, // ÑÄ (U+00D1 U+00C4)
  0x00, 0xD1, 0x00, 0xC5, 0x01, // ÑÅ (U+00D1 U+00C5)
  0x00, 0xD1, 0x01, 0x00, 0x01, // ÑĀ (U+00D1 U+0100)
  0x00, 0xD1, 0x01, 0x02, 0x01, // ÑĂ (U+00D1 U+0102)
  0x00, 0xD1, 0x01, 0x04, 0x01, // ÑĄ (U+00D1 U+0104)
  0x00, 0xD1, 0x20, 0x39, 0x01, // Ñ‹ (U+00D1 U+2039)
  0x00, 0xD1, 0x20, 0x3A, 0x01, // Ñ› (U+00D1 U+203A)
  0x00, 0xD2, 0x00, 0x2C, 0x02, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x02, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x3F, 0x02, // Ò? (U+00D2 U+003F)
  0x00, 0xD2, 0x00, 0x41, 0x02, // ÒA (U+00D2 U+0041)
  0x00, 0xD2, 0x00, 0x54, 0x02, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x00, 0x56, 0x02, // ÒV (U+00D2 U+0056)
  0x00, 0xD2, 0x00, 0x57, 0x02, // ÒW (U+00D2 U+0057)
  0x00, 0xD2, 0x00, 0x58, 0x02, // ÒX (U+00D2 U+0058)
  0x00, 0xD2, 0x00, 0x59, 0x03, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0xC0, 0x02, // ÒÀ (U+00D2 U+00C0)
  0x00, 0xD2, 0x00, 0xC1, 0x02, // ÒÁ (U+00D2 U+00C1)
  0x00, 0xD2, 0x00, 0xC2, 0x02, // ÒÂ (U+00D2 U+00C2)
  0x00, 0xD2, 0x00, 0xC3, 0x02, // ÒÃ (U+00D2 U+00C3)
  0x00, 0xD2, 0x00, 0xC4, 0x02, // ÒÄ (U+00D2 U+00C4)
  0x00, 0xD2, 0x00, 0xC5, 0x02, // ÒÅ (U+00D2 U+00C5)
  0x00, 0xD2, 0x00, 0xC6, 0x05, // ÒÆ (U+00D2 U+00C6)
  0x00, 0xD2, 0x00, 0xDD, 0x03, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x00, 0x02, // ÒĀ (U+00D2 U+0100)
  0x00, 0xD2, 0x01, 0x02, 0x02, // ÒĂ (U+00D2 U+0102)
  0x00, 0xD2, 0x01, 0x04, 0x02, // ÒĄ (U+00D2 U+0104)
  0x00, 0xD2, 0x01, 0x62, 0x02, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x02, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x02, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x01, 0x74, 0x02, // ÒŴ (U+00D2 U+0174)
  0x00, 0xD2, 0x01, 0x76, 0x03, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x03, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD2, 0x20, 0x1A, 0x02, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x02, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x02, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x02, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x02, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x3F, 0x02, // Ó? (U+00D3 U+003F)
  0x00, 0xD3, 0x00, 0x41, 0x02, // ÓA (U+00D3 U+0041)
  0x00, 0xD3, 0x00, 0x54, 0x02, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x00, 0x56, 0x02, // ÓV (U+00D3 U+0056)
  0x00, 0xD3, 0x00, 0x57, 0x02, // ÓW (U+00D3 U+0057)
  0x00, 0xD3, 0x00, 0x58, 0x02, // ÓX (U+00D3 U+0058)
  0x00, 0xD3, 0x00, 0x59, 0x03, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0xC0, 0x02, // ÓÀ (U+00D3 U+00C0)
  0x00, 0xD3, 0x00, 0xC1, 0x02, // ÓÁ (U+00D3 U+00C1)
  0x00, 0xD3, 0x00, 0xC2, 0x02, // ÓÂ (U+00D3 U+00C2)
  0x00, 0xD3, 0x00, 0xC3, 0x02, // ÓÃ (U+00D3 U+00C3)
  0x00, 0xD3, 0x00, 0xC4, 0x02, // ÓÄ (U+00D3 U+00C4)
  0x00, 0xD3, 0x00, 0xC5, 0x02, // ÓÅ (U+00D3 U+00C5)
  0x00, 0xD3, 0x00, 0xC6, 0x05, // ÓÆ (U+00D3 U+00C6)
  0x00, 0xD3, 0x00, 0xDD, 0x03, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x00, 0x02, // ÓĀ (U+00D3 U+0100)
  0x00, 0xD3, 0x01, 0x02, 0x02, // ÓĂ (U+00D3 U+0102)
  0x00, 0xD3, 0x01, 0x04, 0x02, // ÓĄ (U+00D3 U+0104)
  0x00, 0xD3, 0x01, 0x62, 0x02, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x02, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x02, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x01, 0x74, 0x02, // ÓŴ (U+00D3 U+0174)
  0x00, 0xD3, 0x01, 0x76, 0x03, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x03, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD3, 0x20, 0x1A, 0x02, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x02, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x02, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x02, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x02, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x3F, 0x02, // Ô? (U+00D4 U+003F)
  0x00, 0xD4, 0x00, 0x41, 0x02, // ÔA (U+00D4 U+0041)
  0x00, 0xD4, 0x00, 0x54, 0x02, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x00, 0x56, 0x02, // ÔV (U+00D4 U+0056)
  0x00, 0xD4, 0x00, 0x57, 0x02, // ÔW (U+00D4 U+0057)
  0x00, 0xD4, 0x00, 0x58, 0x02, // ÔX (U+00D4 U+0058)
  0x00, 0xD4, 0x00, 0x59, 0x03, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0xC0, 0x02, // ÔÀ (U+00D4 U+00C0)
  0x00, 0xD4, 0x00, 0xC1, 0x02, // ÔÁ (U+00D4 U+00C1)
  0x00, 0xD4, 0x00, 0xC2, 0x02, // ÔÂ (U+00D4 U+00C2)
  0x00, 0xD4, 0x00, 0xC3, 0x02, // ÔÃ (U+00D4 U+00C3)
  0x00, 0xD4, 0x00, 0xC4, 0x02, // ÔÄ (U+00D4 U+00C4)
  0x00, 0xD4, 0x00, 0xC5, 0x02, // ÔÅ (U+00D4 U+00C5)
  0x00, 0xD4, 0x00, 0xC6, 0x05, // ÔÆ (U+00D4 U+00C6)
  0x00, 0xD4, 0x00, 0xDD, 0x03, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x00, 0x02, // ÔĀ (U+00D4 U+0100)
  0x00, 0xD4, 0x01, 0x02, 0x02, // ÔĂ (U+00D4 U+0102)
  0x00, 0xD4, 0x01, 0x04, 0x02, // ÔĄ (U+00D4 U+0104)
  0x00, 0xD4, 0x01, 0x62, 0x02, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x02, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x02, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x01, 0x74, 0x02, // ÔŴ (U+00D4 U+0174)
  0x00, 0xD4, 0x01, 0x76, 0x03, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x03, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD4, 0x20, 0x1A, 0x02, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x02, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x02, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x02, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x02, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x3F, 0x02, // Õ? (U+00D5 U+003F)
  0x00, 0xD5, 0x00, 0x41, 0x02, // ÕA (U+00D5 U+0041)
  0x00, 0xD5, 0x00, 0x54, 0x02, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x00, 0x56, 0x02, // ÕV (U+00D5 U+0056)
  0x00, 0xD5, 0x00, 0x57, 0x02, // ÕW (U+00D5 U+0057)
  0x00, 0xD5, 0x00, 0x58, 0x02, // ÕX (U+00D5 U+0058)
  0x00, 0xD5, 0x00, 0x59, 0x03, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0xC0, 0x02, // ÕÀ (U+00D5 U+00C0)
  0x00, 0xD5, 0x00, 0xC1, 0x02, // ÕÁ (U+00D5 U+00C1)
  0x00, 0xD5, 0x00, 0xC2, 0x02, // ÕÂ (U+00D5 U+00C2)
  0x00, 0xD5, 0x00, 0xC3, 0x02, // ÕÃ (U+00D5 U+00C3)
  0x00, 0xD5, 0x00, 0xC4, 0x02, // ÕÄ (U+00D5 U+00C4)
  0x00, 0xD5, 0x00, 0xC5, 0x02, // ÕÅ (U+00D5 U+00C5)
  0x00, 0xD5, 0x00, 0xC6, 0x05, // ÕÆ (U+00D5 U+00C6)
  0x00, 0xD5, 0x00, 0xDD, 0x03, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x00, 0x02, // ÕĀ (U+00D5 U+0100)
  0x00, 0xD5, 0x01, 0x02, 0x02, // ÕĂ (U+00D5 U+0102)
  0x00, 0xD5, 0x01, 0x04, 0x02, // ÕĄ (U+00D5 U+0104)
  0x00, 0xD5, 0x01, 0x62, 0x02, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x02, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x02, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x01, 0x74, 0x02, // ÕŴ (U+00D5 U+0174)
  0x00, 0xD5, 0x01, 0x76, 0x03, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x03, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD5, 0x20, 0x1A, 0x02, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x02, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x02, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x02, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x02, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x3F, 0x02, // Ö? (U+00D6 U+003F)
  0x00, 0xD6, 0x00, 0x41, 0x02, // ÖA (U+00D6 U+0041)
  0x00, 0xD6, 0x00, 0x54, 0x02, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x00, 0x56, 0x02, // ÖV (U+00D6 U+0056)
  0x00, 0xD6, 0x00, 0x57, 0x02, // ÖW (U+00D6 U+0057)
  0x00, 0xD6, 0x00, 0x58, 0x02, // ÖX (U+00D6 U+0058)
  0x00, 0xD6, 0x00, 0x59, 0x03, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0xC0, 0x02, // ÖÀ (U+00D6 U+00C0)
  0x00, 0xD6, 0x00, 0xC1, 0x02, // ÖÁ (U+00D6 U+00C1)
  0x00, 0xD6, 0x00, 0xC2, 0x02, // ÖÂ (U+00D6 U+00C2)
  0x00, 0xD6, 0x00, 0xC3, 0x02, // ÖÃ (U+00D6 U+00C3)
  0x00, 0xD6, 0x00, 0xC4, 0x02, // ÖÄ (U+00D6 U+00C4)
  0x00, 0xD6, 0x00, 0xC5, 0x02, // ÖÅ (U+00D6 U+00C5)
  0x00, 0xD6, 0x00, 0xC6, 0x05, // ÖÆ (U+00D6 U+00C6)
  0x00, 0xD6, 0x00, 0xDD, 0x03, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x00, 0x02, // ÖĀ (U+00D6 U+0100)
  0x00, 0xD6, 0x01, 0x02, 0x02, // ÖĂ (U+00D6 U+0102)
  0x00, 0xD6, 0x01, 0x04, 0x02, // ÖĄ (U+00D6 U+0104)
  0x00, 0xD6, 0x01, 0x62, 0x02, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x02, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x02, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x01, 0x74, 0x02, // ÖŴ (U+00D6 U+0174)
  0x00, 0xD6, 0x01, 0x76, 0x03, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x03, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD6, 0x20, 0x1A, 0x02, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x02, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x02, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x02, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x02, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x3F, 0x02, // Ø? (U+00D8 U+003F)
  0x00, 0xD8, 0x00, 0x41, 0x02, // ØA (U+00D8 U+0041)
  0x00, 0xD8, 0x00, 0x54, 0x02, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x00, 0x56, 0x02, // ØV (U+00D8 U+0056)
  0x00, 0xD8, 0x00, 0x57, 0x02, // ØW (U+00D8 U+0057)
  0x00, 0xD8, 0x00, 0x58, 0x02, // ØX (U+00D8 U+0058)
  0x00, 0xD8, 0x00, 0x59, 0x03, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0xC0, 0x02, // ØÀ (U+00D8 U+00C0)
  0x00, 0xD8, 0x00, 0xC1, 0x02, // ØÁ (U+00D8 U+00C1)
  0x00, 0xD8, 0x00, 0xC2, 0x02, // ØÂ (U+00D8 U+00C2)
  0x00, 0xD8, 0x00, 0xC3, 0x02, // ØÃ (U+00D8 U+00C3)
  0x00, 0xD8, 0x00, 0xC4, 0x02, // ØÄ (U+00D8 U+00C4)
  0x00, 0xD8, 0x00, 0xC5, 0x02, // ØÅ (U+00D8 U+00C5)
  0x00, 0xD8, 0x00, 0xC6, 0x05, // ØÆ (U+00D8 U+00C6)
  0x00, 0xD8, 0x00, 0xDD, 0x03, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x00, 0x02, // ØĀ (U+00D8 U+0100)
  0x00, 0xD8, 0x01, 0x02, 0x02, // ØĂ (U+00D8 U+0102)
  0x00, 0xD8, 0x01, 0x04, 0x02, // ØĄ (U+00D8 U+0104)
  0x00, 0xD8, 0x01, 0x62, 0x02, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x02, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x02, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x01, 0x74, 0x02, // ØŴ (U+00D8 U+0174)
  0x00, 0xD8, 0x01, 0x76, 0x03, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x03, // ØŸ (U+00D8 U+0178)
  0x00, 0xD8, 0x20, 0x1A, 0x02, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x02, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x02, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x2C, 0x02, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x02, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x00, 0x40, 0x01, // Ù@ (U+00D9 U+0040)
  0x00, 0xD9, 0x00, 0x41, 0x02, // ÙA (U+00D9 U+0041)
  0x00, 0xD9, 0x00, 0xC0, 0x02, // ÙÀ (U+00D9 U+00C0)
  0x00, 0xD9, 0x00, 0xC1, 0x02, // ÙÁ (U+00D9 U+00C1)
  0x00, 0xD9, 0x00, 0xC2, 0x02, // ÙÂ (U+00D9 U+00C2)
  0x00, 0xD9, 0x00, 0xC3, 0x02, // ÙÃ (U+00D9 U+00C3)
  0x00, 0xD9, 0x00, 0xC4, 0x02, // ÙÄ (U+00D9 U+00C4)
  0x00, 0xD9, 0x00, 0xC5, 0x02, // ÙÅ (U+00D9 U+00C5)
  0x00, 0xD9, 0x00, 0xC6, 0x04, // ÙÆ (U+00D9 U+00C6)
  0x00, 0xD9, 0x01, 0x00, 0x02, // ÙĀ (U+00D9 U+0100)
  0x00, 0xD9, 0x01, 0x02, 0x02, // ÙĂ (U+00D9 U+0102)
  0x00, 0xD9, 0x01, 0x04, 0x02, // ÙĄ (U+00D9 U+0104)
  0x00, 0xD9, 0x20, 0x1A, 0x02, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x02, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x02, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x2C, 0x02, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x02, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x00, 0x40, 0x01, // Ú@ (U+00DA U+0040)
  0x00, 0xDA, 0x00, 0x41, 0x02, // ÚA (U+00DA U+0041)
  0x00, 0xDA, 0x00, 0xC0, 0x02, // ÚÀ (U+00DA U+00C0)
  0x00, 0xDA, 0x00, 0xC1, 0x02, // ÚÁ (U+00DA U+00C1)
  0x00, 0xDA, 0x00, 0xC2, 0x02, // ÚÂ (U+00DA U+00C2)
  0x00, 0xDA, 0x00, 0xC3, 0x02, // ÚÃ (U+00DA U+00C3)
  0x00, 0xDA, 0x00, 0xC4, 0x02, // ÚÄ (U+00DA U+00C4)
  0x00, 0xDA, 0x00, 0xC5, 0x02, // ÚÅ (U+00DA U+00C5)
  0x00, 0xDA, 0x00, 0xC6, 0x04, // ÚÆ (U+00DA U+00C6)
  0x00, 0xDA, 0x01, 0x00, 0x02, // ÚĀ (U+00DA U+0100)
  0x00, 0xDA, 0x01, 0x02, 0x02, // ÚĂ (U+00DA U+0102)
  0x00, 0xDA, 0x01, 0x04, 0x02, // ÚĄ (U+00DA U+0104)
  0x00, 0xDA, 0x20, 0x1A, 0x02, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x02, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x02, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x2C, 0x02, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x02, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x00, 0x40, 0x01, // Û@ (U+00DB U+0040)
  0x00, 0xDB, 0x00, 0x41, 0x02, // ÛA (U+00DB U+0041)
  0x00, 0xDB, 0x00, 0xC0, 0x02, // ÛÀ (U+00DB U+00C0)
  0x00, 0xDB, 0x00, 0xC1, 0x02, // ÛÁ (U+00DB U+00C1)
  0x00, 0xDB, 0x00, 0xC2, 0x02, // ÛÂ (U+00DB U+00C2)
  0x00, 0xDB, 0x00, 0xC3, 0x02, // ÛÃ (U+00DB U+00C3)
  0x00, 0xDB, 0x00, 0xC4, 0x02, // ÛÄ (U+00DB U+00C4)
  0x00, 0xDB, 0x00, 0xC5, 0x02, // ÛÅ (U+00DB U+00C5)
  0x00, 0xDB, 0x00, 0xC6, 0x04, // ÛÆ (U+00DB U+00C6)
  0x00, 0xDB, 0x01, 0x00, 0x02, // ÛĀ (U+00DB U+0100)
  0x00, 0xDB, 0x01, 0x02, 0x02, // ÛĂ (U+00DB U+0102)
  0x00, 0xDB, 0x01, 0x04, 0x02, // ÛĄ (U+00DB U+0104)
  0x00, 0xDB, 0x20, 0x1A, 0x02, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x02, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x02, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x2C, 0x02, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x02, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x00, 0x40, 0x01, // Ü@ (U+00DC U+0040)
  0x00, 0xDC, 0x00, 0x41, 0x02, // ÜA (U+00DC U+0041)
  0x00, 0xDC, 0x00, 0xC0, 0x02, // ÜÀ (U+00DC U+00C0)
  0x00, 0xDC, 0x00, 0xC1, 0x02, // ÜÁ (U+00DC U+00C1)
  0x00, 0xDC, 0x00, 0xC2, 0x02, // ÜÂ (U+00DC U+00C2)
  0x00, 0xDC, 0x00, 0xC3, 0x02, // ÜÃ (U+00DC U+00C3)
  0x00, 0xDC, 0x00, 0xC4, 0x02, // ÜÄ (U+00DC U+00C4)
  0x00, 0xDC, 0x00, 0xC5, 0x02, // ÜÅ (U+00DC U+00C5)
  0x00, 0xDC, 0x00, 0xC6, 0x04, // ÜÆ (U+00DC U+00C6)
  0x00, 0xDC, 0x01, 0x00, 0x02, // ÜĀ (U+00DC U+0100)
  0x00, 0xDC, 0x01, 0x02, 0x02, // ÜĂ (U+00DC U+0102)
  0x00, 0xDC, 0x01, 0x04, 0x02, // ÜĄ (U+00DC U+0104)
  0x00, 0xDC, 0x20, 0x1A, 0x02, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x02, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x02, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x06, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x06, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x40, 0x04, // Ý@ (U+00DD U+0040)
  0x00, 0xDD, 0x00, 0x41, 0x04, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x03, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x03, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x03, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x03, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x53, 0x01, // ÝS (U+00DD U+0053)
  0x00, 0xDD, 0x00, 0x61, 0x05, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x04, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x04, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x04, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x04, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x04, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x04, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x04, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x7A, 0x02, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xC0, 0x04, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x04, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x04, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x04, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x04, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x04, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC6, 0x06, // ÝÆ (U+00DD U+00C6)
  0x00, 0xDD, 0x00, 0xC7, 0x03, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x03, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x03, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x03, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x03, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x03, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x03, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x05, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x05, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x05, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x05, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x05, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x05, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x05, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x04, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x04, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x04, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x04, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x04, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF0, 0x04, // Ýð (U+00DD U+00F0)
  0x00, 0xDD, 0x00, 0xF2, 0x04, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x04, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x04, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x04, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x04, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x04, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x04, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x05, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x04, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x05, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x04, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x05, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x03, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x04, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x03, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x04, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x03, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x04, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x03, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x04, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x04, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x04, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x04, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x04, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x04, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x04, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x04, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x03, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x04, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x03, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x04, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x03, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x04, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x03, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x04, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4C, 0x03, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x04, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x03, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x04, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x03, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x04, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x03, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x04, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5A, 0x01, // ÝŚ (U+00DD U+015A)
  0x00, 0xDD, 0x01, 0x5B, 0x04, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5C, 0x01, // ÝŜ (U+00DD U+015C)
  0x00, 0xDD, 0x01, 0x5D, 0x04, // Ýŝ (U+00DD U+015D)
  0x00, 0xDD, 0x01, 0x5E, 0x01, // ÝŞ (U+00DD U+015E)
  0x00, 0xDD, 0x01, 0x5F, 0x04, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x60, 0x01, // ÝŠ (U+00DD U+0160)
  0x00, 0xDD, 0x01, 0x61, 0x04, // Ýš (U+00DD U+0161)
  0x00, 0xDD, 0x01, 0x7A, 0x02, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x02, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x02, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x06, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x06, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x06, // Ý… (U+00DD U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x3F, 0x02, // Þ? (U+00DE U+003F)
  0x00, 0xDE, 0x00, 0x41, 0x02, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x54, 0x02, // ÞT (U+00DE U+0054)
  0x00, 0xDE, 0x00, 0x56, 0x02, // ÞV (U+00DE U+0056)
  0x00, 0xDE, 0x00, 0x57, 0x02, // ÞW (U+00DE U+0057)
  0x00, 0xDE, 0x00, 0x58, 0x02, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0x59, 0x03, // ÞY (U+00DE U+0059)
  0x00, 0xDE, 0x00, 0xC0, 0x02, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x02, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x02, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x02, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x02, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x02, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x05, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x00, 0xDD, 0x03, // ÞÝ (U+00DE U+00DD)
  0x00, 0xDE, 0x01, 0x00, 0x02, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x02, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x02, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x01, 0x62, 0x02, // ÞŢ (U+00DE U+0162)
  0x00, 0xDE, 0x01, 0x64, 0x02, // ÞŤ (U+00DE U+0164)
  0x00, 0xDE, 0x01, 0x66, 0x02, // ÞŦ (U+00DE U+0166)
  0x00, 0xDE, 0x01, 0x74, 0x02, // ÞŴ (U+00DE U+0174)
  0x00, 0xDE, 0x01, 0x76, 0x03, // ÞŶ (U+00DE U+0176)
  0x00, 0xDE, 0x01, 0x78, 0x03, // ÞŸ (U+00DE U+0178)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x00, 0xDF, 0x00, 0x3F, 0x02, // ß? (U+00DF U+003F)
  0x00, 0xDF, 0x00, 0x41, 0x01, // ßA (U+00DF U+0041)
  0x00, 0xDF, 0x00, 0x54, 0x02, // ßT (U+00DF U+0054)
  0x00, 0xDF, 0x00, 0x56, 0x03, // ßV (U+00DF U+0056)
  0x00, 0xDF, 0x00, 0x57, 0x03, // ßW (U+00DF U+0057)
  0x00, 0xDF, 0x00, 0x59, 0x04, // ßY (U+00DF U+0059)
  0x00, 0xDF, 0x00, 0x79, 0x02, // ßy (U+00DF U+0079)
  0x00, 0xDF, 0x00, 0xC0, 0x01, // ßÀ (U+00DF U+00C0)
  0x00, 0xDF, 0x00, 0xC1, 0x01, // ßÁ (U+00DF U+00C1)
  0x00, 0xDF, 0x00, 0xC2, 0x01, // ßÂ (U+00DF U+00C2)
  0x00, 0xDF, 0x00, 0xC3, 0x01, // ßÃ (U+00DF U+00C3)
  0x00, 0xDF, 0x00, 0xC4, 0x01, // ßÄ (U+00DF U+00C4)
  0x00, 0xDF, 0x00, 0xC5, 0x01, // ßÅ (U+00DF U+00C5)
  0x00, 0xDF, 0x00, 0xDD, 0x04, // ßÝ (U+00DF U+00DD)
  0x00, 0xDF, 0x00, 0xFD, 0x02, // ßý (U+00DF U+00FD)
  0x00, 0xDF, 0x00, 0xFF, 0x02, // ßÿ (U+00DF U+00FF)
  0x00, 0xDF, 0x01, 0x00, 0x01, // ßĀ (U+00DF U+0100)
  0x00, 0xDF, 0x01, 0x02, 0x01, // ßĂ (U+00DF U+0102)
  0x00, 0xDF, 0x01, 0x04, 0x01, // ßĄ (U+00DF U+0104)
  0x00, 0xDF, 0x01, 0x62, 0x02, // ßŢ (U+00DF U+0162)
  0x00, 0xDF, 0x01, 0x64, 0x02, // ßŤ (U+00DF U+0164)
  0x00, 0xDF, 0x01, 0x66, 0x02, // ßŦ (U+00DF U+0166)
  0x00, 0xDF, 0x01, 0x74, 0x03, // ßŴ (U+00DF U+0174)
  0x00, 0xDF, 0x01, 0x76, 0x04, // ßŶ (U+00DF U+0176)
  0x00, 0xDF, 0x01, 0x77, 0x02, // ßŷ (U+00DF U+0177)
  0x00, 0xDF, 0x01, 0x78, 0x04, // ßŸ (U+00DF U+0178)
  0x00, 0xE0, 0x00, 0x22, 0x04, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x04, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x00, 0x3F, 0x02, // à? (U+00E0 U+003F)
  0x00, 0xE0, 0x00, 0x54, 0x02, // àT (U+00E0 U+0054)
  0x00, 0xE0, 0x00, 0x56, 0x03, // àV (U+00E0 U+0056)
  0x00, 0xE0, 0x00, 0x57, 0x03, // àW (U+00E0 U+0057)
  0x00, 0xE0, 0x00, 0x59, 0x03, // àY (U+00E0 U+0059)
  0x00, 0xE0, 0x00, 0x79, 0x02, // ày (U+00E0 U+0079)
  0x00, 0xE0, 0x00, 0xDD, 0x03, // àÝ (U+00E0 U+00DD)
  0x00, 0xE0, 0x00, 0xFD, 0x02, // àý (U+00E0 U+00FD)
  0x00, 0xE0, 0x00, 0xFF, 0x02, // àÿ (U+00E0 U+00FF)
  0x00, 0xE0, 0x01, 0x62, 0x02, // àŢ (U+00E0 U+0162)
  0x00, 0xE0, 0x01, 0x64, 0x02, // àŤ (U+00E0 U+0164)
  0x00, 0xE0, 0x01, 0x66, 0x02, // àŦ (U+00E0 U+0166)
  0x00, 0xE0, 0x01, 0x74, 0x03, // àŴ (U+00E0 U+0174)
  0x00, 0xE0, 0x01, 0x76, 0x03, // àŶ (U+00E0 U+0176)
  0x00, 0xE0, 0x01, 0x77, 0x02, // àŷ (U+00E0 U+0177)
  0x00, 0xE0, 0x01, 0x78, 0x03, // àŸ (U+00E0 U+0178)
  0x00, 0xE1, 0x00, 0x22, 0x04, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x04, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x00, 0x3F, 0x02, // á? (U+00E1 U+003F)
  0x00, 0xE1, 0x00, 0x54, 0x02, // áT (U+00E1 U+0054)
  0x00, 0xE1, 0x00, 0x56, 0x03, // áV (U+00E1 U+0056)
  0x00, 0xE1, 0x00, 0x57, 0x03, // áW (U+00E1 U+0057)
  0x00, 0xE1, 0x00, 0x59, 0x03, // áY (U+00E1 U+0059)
  0x00, 0xE1, 0x00, 0x79, 0x02, // áy (U+00E1 U+0079)
  0x00, 0xE1, 0x00, 0xDD, 0x03, // áÝ (U+00E1 U+00DD)
  0x00, 0xE1, 0x00, 0xFD, 0x02, // áý (U+00E1 U+00FD)
  0x00, 0xE1, 0x00, 0xFF, 0x02, // áÿ (U+00E1 U+00FF)
  0x00, 0xE1, 0x01, 0x62, 0x02, // áŢ (U+00E1 U+0162)
  0x00, 0xE1, 0x01, 0x64, 0x02, // áŤ (U+00E1 U+0164)
  0x00, 0xE1, 0x01, 0x66, 0x02, // áŦ (U+00E1 U+0166)
  0x00, 0xE1, 0x01, 0x74, 0x03, // áŴ (U+00E1 U+0174)
  0x00, 0xE1, 0x01, 0x76, 0x03, // áŶ (U+00E1 U+0176)
  0x00, 0xE1, 0x01, 0x77, 0x02, // áŷ (U+00E1 U+0177)
  0x00, 0xE1, 0x01, 0x78, 0x03, // áŸ (U+00E1 U+0178)
  0x00, 0xE2, 0x00, 0x22, 0x04, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x04, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x00, 0x3F, 0x02, // â? (U+00E2 U+003F)
  0x00, 0xE2, 0x00, 0x54, 0x02, // âT (U+00E2 U+0054)
  0x00, 0xE2, 0x00, 0x56, 0x03, // âV (U+00E2 U+0056)
  0x00, 0xE2, 0x00, 0x57, 0x03, // âW (U+00E2 U+0057)
  0x00, 0xE2, 0x00, 0x59, 0x03, // âY (U+00E2 U+0059)
  0x00, 0xE2, 0x00, 0x79, 0x02, // ây (U+00E2 U+0079)
  0x00, 0xE2, 0x00, 0xDD, 0x03, // âÝ (U+00E2 U+00DD)
  0x00, 0xE2, 0x00, 0xFD, 0x02, // âý (U+00E2 U+00FD)
  0x00, 0xE2, 0x00, 0xFF, 0x02, // âÿ (U+00E2 U+00FF)
  0x00, 0xE2, 0x01, 0x62, 0x02, // âŢ (U+00E2 U+0162)
  0x00, 0xE2, 0x01, 0x64, 0x02, // âŤ (U+00E2 U+0164)
  0x00, 0xE2, 0x01, 0x66, 0x02, // âŦ (U+00E2 U+0166)
  0x00, 0xE2, 0x01, 0x74, 0x03, // âŴ (U+00E2 U+0174)
  0x00, 0xE2, 0x01, 0x76, 0x03, // âŶ (U+00E2 U+0176)
  0x00, 0xE2, 0x01, 0x77, 0x02, // âŷ (U+00E2 U+0177)
  0x00, 0xE2, 0x01, 0x78, 0x03, // âŸ (U+00E2 U+0178)
  0x00, 0xE3, 0x00, 0x22, 0x04, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x04, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x00, 0x3F, 0x02, // ã? (U+00E3 U+003F)
  0x00, 0xE3, 0x00, 0x54, 0x02, // ãT (U+00E3 U+0054)
  0x00, 0xE3, 0x00, 0x56, 0x03, // ãV (U+00E3 U+0056)
  0x00, 0xE3, 0x00, 0x57, 0x03, // ãW (U+00E3 U+0057)
  0x00, 0xE3, 0x00, 0x59, 0x03, // ãY (U+00E3 U+0059)
  0x00, 0xE3, 0x00, 0x79, 0x02, // ãy (U+00E3 U+0079)
  0x00, 0xE3, 0x00, 0xDD, 0x03, // ãÝ (U+00E3 U+00DD)
  0x00, 0xE3, 0x00, 0xFD, 0x02, // ãý (U+00E3 U+00FD)
  0x00, 0xE3, 0x00, 0xFF, 0x02, // ãÿ (U+00E3 U+00FF)
  0x00, 0xE3, 0x01, 0x62, 0x02, // ãŢ (U+00E3 U+0162)
  0x00, 0xE3, 0x01, 0x64, 0x02, // ãŤ (U+00E3 U+0164)
  0x00, 0xE3, 0x01, 0x66, 0x02, // ãŦ (U+00E3 U+0166)
  0x00, 0xE3, 0x01, 0x74, 0x03, // ãŴ (U+00E3 U+0174)
  0x00, 0xE3, 0x01, 0x76, 0x03, // ãŶ (U+00E3 U+0176)
  0x00, 0xE3, 0x01, 0x77, 0x02, // ãŷ (U+00E3 U+0177)
  0x00, 0xE3, 0x01, 0x78, 0x03, // ãŸ (U+00E3 U+0178)
  0x00, 0xE4, 0x00, 0x22, 0x04, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x04, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x00, 0x3F, 0x02, // ä? (U+00E4 U+003F)
  0x00, 0xE4, 0x00, 0x54, 0x02, // äT (U+00E4 U+0054)
  0x00, 0xE4, 0x00, 0x56, 0x03, // äV (U+00E4 U+0056)
  0x00, 0xE4, 0x00, 0x57, 0x03, // äW (U+00E4 U+0057)
  0x00, 0xE4, 0x00, 0x59, 0x03, // äY (U+00E4 U+0059)
  0x00, 0xE4, 0x00, 0x79, 0x02, // äy (U+00E4 U+0079)
  0x00, 0xE4, 0x00, 0xDD, 0x03, // äÝ (U+00E4 U+00DD)
  0x00, 0xE4, 0x00, 0xFD, 0x02, // äý (U+00E4 U+00FD)
  0x00, 0xE4, 0x00, 0xFF, 0x02, // äÿ (U+00E4 U+00FF)
  0x00, 0xE4, 0x01, 0x62, 0x02, // äŢ (U+00E4 U+0162)
  0x00, 0xE4, 0x01, 0x64, 0x02, // äŤ (U+00E4 U+0164)
  0x00, 0xE4, 0x01, 0x66, 0x02, // äŦ (U+00E4 U+0166)
  0x00, 0xE4, 0x01, 0x74, 0x03, // äŴ (U+00E4 U+0174)
  0x00, 0xE4, 0x01, 0x76, 0x03, // äŶ (U+00E4 U+0176)
  0x00, 0xE4, 0x01, 0x77, 0x02, // äŷ (U+00E4 U+0177)
  0x00, 0xE4, 0x01, 0x78, 0x03, // äŸ (U+00E4 U+0178)
  0x00, 0xE5, 0x00, 0x22, 0x04, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x04, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x00, 0x3F, 0x02, // å? (U+00E5 U+003F)
  0x00, 0xE5, 0x00, 0x54, 0x02, // åT (U+00E5 U+0054)
  0x00, 0xE5, 0x00, 0x56, 0x03, // åV (U+00E5 U+0056)
  0x00, 0xE5, 0x00, 0x57, 0x03, // åW (U+00E5 U+0057)
  0x00, 0xE5, 0x00, 0x59, 0x03, // åY (U+00E5 U+0059)
  0x00, 0xE5, 0x00, 0x79, 0x02, // åy (U+00E5 U+0079)
  0x00, 0xE5, 0x00, 0xDD, 0x03, // åÝ (U+00E5 U+00DD)
  0x00, 0xE5, 0x00, 0xFD, 0x02, // åý (U+00E5 U+00FD)
  0x00, 0xE5, 0x00, 0xFF, 0x02, // åÿ (U+00E5 U+00FF)
  0x00, 0xE5, 0x01, 0x62, 0x02, // åŢ (U+00E5 U+0162)
  0x00, 0xE5, 0x01, 0x64, 0x02, // åŤ (U+00E5 U+0164)
  0x00, 0xE5, 0x01, 0x66, 0x02, // åŦ (U+00E5 U+0166)
  0x00, 0xE5, 0x01, 0x74, 0x03, // åŴ (U+00E5 U+0174)
  0x00, 0xE5, 0x01, 0x76, 0x03, // åŶ (U+00E5 U+0176)
  0x00, 0xE5, 0x01, 0x77, 0x02, // åŷ (U+00E5 U+0177)
  0x00, 0xE5, 0x01, 0x78, 0x03, // åŸ (U+00E5 U+0178)
  0x00, 0xE6, 0x00, 0x56, 0x04, // æV (U+00E6 U+0056)
  0x00, 0xE6, 0x00, 0x57, 0x04, // æW (U+00E6 U+0057)
  0x00, 0xE6, 0x00, 0x59, 0x04, // æY (U+00E6 U+0059)
  0x00, 0xE6, 0x00, 0xDD, 0x04, // æÝ (U+00E6 U+00DD)
  0x00, 0xE6, 0x01, 0x74, 0x04, // æŴ (U+00E6 U+0174)
  0x00, 0xE6, 0x01, 0x76, 0x04, // æŶ (U+00E6 U+0176)
  0x00, 0xE6, 0x01, 0x78, 0x04, // æŸ (U+00E6 U+0178)
  0x00, 0xE8, 0x00, 0x56, 0x04, // èV (U+00E8 U+0056)
  0x00, 0xE8, 0x00, 0x57, 0x04, // èW (U+00E8 U+0057)
  0x00, 0xE8, 0x00, 0x59, 0x04, // èY (U+00E8 U+0059)
  0x00, 0xE8, 0x00, 0xDD, 0x04, // èÝ (U+00E8 U+00DD)
  0x00, 0xE8, 0x01, 0x74, 0x04, // èŴ (U+00E8 U+0174)
  0x00, 0xE8, 0x01, 0x76, 0x04, // èŶ (U+00E8 U+0176)
  0x00, 0xE8, 0x01, 0x78, 0x04, // èŸ (U+00E8 U+0178)
  0x00, 0xE9, 0x00, 0x56, 0x04, // éV (U+00E9 U+0056)
  0x00, 0xE9, 0x00, 0x57, 0x04, // éW (U+00E9 U+0057)
  0x00, 0xE9, 0x00, 0x59, 0x04, // éY (U+00E9 U+0059)
  0x00, 0xE9, 0x00, 0xDD, 0x04, // éÝ (U+00E9 U+00DD)
  0x00, 0xE9, 0x01, 0x74, 0x04, // éŴ (U+00E9 U+0174)
  0x00, 0xE9, 0x01, 0x76, 0x04, // éŶ (U+00E9 U+0176)
  0x00, 0xE9, 0x01, 0x78, 0x04, // éŸ (U+00E9 U+0178)
  0x00, 0xEA, 0x00, 0x56, 0x04, // êV (U+00EA U+0056)
  0x00, 0xEA, 0x00, 0x57, 0x04, // êW (U+00EA U+0057)
  0x00, 0xEA, 0x00, 0x59, 0x04, // êY (U+00EA U+0059)
  0x00, 0xEA, 0x00, 0xDD, 0x04, // êÝ (U+00EA U+00DD)
  0x00, 0xEA, 0x01, 0x74, 0x04, // êŴ (U+00EA U+0174)
  0x00, 0xEA, 0x01, 0x76, 0x04, // êŶ (U+00EA U+0176)
  0x00, 0xEA, 0x01, 0x78, 0x04, // êŸ (U+00EA U+0178)
  0x00, 0xEB, 0x00, 0x56, 0x04, // ëV (U+00EB U+0056)
  0x00, 0xEB, 0x00, 0x57, 0x04, // ëW (U+00EB U+0057)
  0x00, 0xEB, 0x00, 0x59, 0x04, // ëY (U+00EB U+0059)
  0x00, 0xEB, 0x00, 0xDD, 0x04, // ëÝ (U+00EB U+00DD)
  0x00, 0xEB, 0x01, 0x74, 0x04, // ëŴ (U+00EB U+0174)
  0x00, 0xEB, 0x01, 0x76, 0x04, // ëŶ (U+00EB U+0176)
  0x00, 0xEB, 0x01, 0x78, 0x04, // ëŸ (U+00EB U+0178)
  0x00, 0xF0, 0x00, 0x3F, 0x02, // ð? (U+00F0 U+003F)
  0x00, 0xF0, 0x00, 0x41, 0x01, // ðA (U+00F0 U+0041)
  0x00, 0xF0, 0x00, 0x54, 0x02, // ðT (U+00F0 U+0054)
  0x00, 0xF0, 0x00, 0x56, 0x03, // ðV (U+00F0 U+0056)
  0x00, 0xF0, 0x00, 0x57, 0x03, // ðW (U+00F0 U+0057)
  0x00, 0xF0, 0x00, 0x59, 0x04, // ðY (U+00F0 U+0059)
  0x00, 0xF0, 0x00, 0x79, 0x02, // ðy (U+00F0 U+0079)
  0x00, 0xF0, 0x00, 0xC0, 0x01, // ðÀ (U+00F0 U+00C0)
  0x00, 0xF0, 0x00, 0xC1, 0x01, // ðÁ (U+00F0 U+00C1)
  0x00, 0xF0, 0x00, 0xC2, 0x01, // ðÂ (U+00F0 U+00C2)
  0x00, 0xF0, 0x00, 0xC3, 0x01, // ðÃ (U+00F0 U+00C3)
  0x00, 0xF0, 0x00, 0xC4, 0x01, // ðÄ (U+00F0 U+00C4)
  0x00, 0xF0, 0x00, 0xC5, 0x01, // ðÅ (U+00F0 U+00C5)
  0x00, 0xF0, 0x00, 0xDD, 0x04, // ðÝ (U+00F0 U+00DD)
  0x00, 0xF0, 0x00, 0xFD, 0x02, // ðý (U+00F0 U+00FD)
  0x00, 0xF0, 0x00, 0xFF, 0x02, // ðÿ (U+00F0 U+00FF)
  0x00, 0xF0, 0x01, 0x00, 0x01, // ðĀ (U+00F0 U+0100)
  0x00, 0xF0, 0x01, 0x02, 0x01, // ðĂ (U+00F0 U+0102)
  0x00, 0xF0, 0x01, 0x04, 0x01, // ðĄ (U+00F0 U+0104)
  0x00, 0xF0, 0x01, 0x62, 0x02, // ðŢ (U+00F0 U+0162)
  0x00, 0xF0, 0x01, 0x64, 0x02, // ðŤ (U+00F0 U+0164)
  0x00, 0xF0, 0x01, 0x66, 0x02, // ðŦ (U+00F0 U+0166)
  0x00, 0xF0, 0x01, 0x74, 0x03, // ðŴ (U+00F0 U+0174)
  0x00, 0xF0, 0x01, 0x76, 0x04, // ðŶ (U+00F0 U+0176)
  0x00, 0xF0, 0x01, 0x77, 0x02, // ðŷ (U+00F0 U+0177)
  0x00, 0xF0, 0x01, 0x78, 0x04, // ðŸ (U+00F0 U+0178)
  0x00, 0xF1, 0x00, 0x22, 0x04, // ñ" (U+00F1 U+0022)
  0x00, 0xF1, 0x00, 0x27, 0x04, // ñ' (U+00F1 U+0027)
  0x00, 0xF1, 0x00, 0x3F, 0x02, // ñ? (U+00F1 U+003F)
  0x00, 0xF1, 0x00, 0x54, 0x02, // ñT (U+00F1 U+0054)
  0x00, 0xF1, 0x00, 0x56, 0x03, // ñV (U+00F1 U+0056)
  0x00, 0xF1, 0x00, 0x57, 0x03, // ñW (U+00F1 U+0057)
  0x00, 0xF1, 0x00, 0x59, 0x03, // ñY (U+00F1 U+0059)
  0x00, 0xF1, 0x00, 0x79, 0x02, // ñy (U+00F1 U+0079)
  0x00, 0xF1, 0x00, 0xDD, 0x03, // ñÝ (U+00F1 U+00DD)
  0x00, 0xF1, 0x00, 0xFD, 0x02, // ñý (U+00F1 U+00FD)
  0x00, 0xF1, 0x00, 0xFF, 0x02, // ñÿ (U+00F1 U+00FF)
  0x00, 0xF1, 0x01, 0x62, 0x02, // ñŢ (U+00F1 U+0162)
  0x00, 0xF1, 0x01, 0x64, 0x02, // ñŤ (U+00F1 U+0164)
  0x00, 0xF1, 0x01, 0x66, 0x02, // ñŦ (U+00F1 U+0166)
  0x00, 0xF1, 0x01, 0x74, 0x03, // ñŴ (U+00F1 U+0174)
  0x00, 0xF1, 0x01, 0x76, 0x03, // ñŶ (U+00F1 U+0176)
  0x00, 0xF1, 0x01, 0x77, 0x02, // ñŷ (U+00F1 U+0177)
  0x00, 0xF1, 0x01, 0x78, 0x03, // ñŸ (U+00F1 U+0178)
  0x00, 0xF2, 0x00, 0x3F, 0x02, // ò? (U+00F2 U+003F)
  0x00, 0xF2, 0x00, 0x41, 0x01, // òA (U+00F2 U+0041)
  0x00, 0xF2, 0x00, 0x54, 0x02, // òT (U+00F2 U+0054)
  0x00, 0xF2, 0x00, 0x56, 0x03, // òV (U+00F2 U+0056)
  0x00, 0xF2, 0x00, 0x57, 0x03, // òW (U+00F2 U+0057)
  0x00, 0xF2, 0x00, 0x59, 0x04, // òY (U+00F2 U+0059)
  0x00, 0xF2, 0x00, 0x79, 0x02, // òy (U+00F2 U+0079)
  0x00, 0xF2, 0x00, 0xC0, 0x01, // òÀ (U+00F2 U+00C0)
  0x00, 0xF2, 0x00, 0xC1, 0x01, // òÁ (U+00F2 U+00C1)
  0x00, 0xF2, 0x00, 0xC2, 0x01, // òÂ (U+00F2 U+00C2)
  0x00, 0xF2, 0x00, 0xC3, 0x01, // òÃ (U+00F2 U+00C3)
  0x00, 0xF2, 0x00, 0xC4, 0x01, // òÄ (U+00F2 U+00C4)
  0x00, 0xF2, 0x00, 0xC5, 0x01, // òÅ (U+00F2 U+00C5)
  0x00, 0xF2, 0x00, 0xDD, 0x04, // òÝ (U+00F2 U+00DD)
  0x00, 0xF2, 0x00, 0xFD, 0x02, // òý (U+00F2 U+00FD)
  0x00, 0xF2, 0x00, 0xFF, 0x02, // òÿ (U+00F2 U+00FF)
  0x00, 0xF2, 0x01, 0x00, 0x01, // òĀ (U+00F2 U+0100)
  0x00, 0xF2, 0x01, 0x02, 0x01, // òĂ (U+00F2 U+0102)
  0x00, 0xF2, 0x01, 0x04, 0x01, // òĄ (U+00F2 U+0104)
  0x00, 0xF2, 0x01, 0x62, 0x02, // òŢ (U+00F2 U+0162)
  0x00, 0xF2, 0x01, 0x64, 0x02, // òŤ (U+00F2 U+0164)
  0x00, 0xF2, 0x01, 0x66, 0x02, // òŦ (U+00F2 U+0166)
  0x00, 0xF2, 0x01, 0x74, 0x03, // òŴ (U+00F2 U+0174)
  0x00, 0xF2, 0x01, 0x76, 0x04, // òŶ (U+00F2 U+0176)
  0x00, 0xF2, 0x01, 0x77, 0x02, // òŷ (U+00F2 U+0177)
  0x00, 0xF2, 0x01, 0x78, 0x04, // òŸ (U+00F2 U+0178)
  0x00, 0xF3, 0x00, 0x3F, 0x02, // ó? (U+00F3 U+003F)
  0x00, 0xF3, 0x00, 0x41, 0x01, // óA (U+00F3 U+0041)
  0x00, 0xF3, 0x00, 0x54, 0x02, // óT (U+00F3 U+0054)
  0x00, 0xF3, 0x00, 0x56, 0x03, // óV (U+00F3 U+0056)
  0x00, 0xF3, 0x00, 0x57, 0x03, // óW (U+00F3 U+0057)
  0x00, 0xF3, 0x00, 0x59, 0x04, // óY (U+00F3 U+0059)
  0x00, 0xF3, 0x00, 0x79, 0x02, // óy (U+00F3 U+0079)
  0x00, 0xF3, 0x00, 0xC0, 0x01, // óÀ (U+00F3 U+00C0)
  0x00, 0xF3, 0x00, 0xC1, 0x01, // óÁ (U+00F3 U+00C1)
  0x00, 0xF3, 0x00, 0xC2, 0x01, // óÂ (U+00F3 U+00C2)
  0x00, 0xF3, 0x00, 0xC3, 0x01, // óÃ (U+00F3 U+00C3)
  0x00, 0xF3, 0x00, 0xC4, 0x01, // óÄ (U+00F3 U+00C4)
  0x00, 0xF3, 0x00, 0xC5, 0x01, // óÅ (U+00F3 U+00C5)
  0x00, 0xF3, 0x00, 0xDD, 0x04, // óÝ (U+00F3 U+00DD)
  0x00, 0xF3, 0x00, 0xFD, 0x02, // óý (U+00F3 U+00FD)
  0x00, 0xF3, 0x00, 0xFF, 0x02, // óÿ (U+00F3 U+00FF)
  0x00, 0xF3, 0x01, 0x00, 0x01, // óĀ (U+00F3 U+0100)
  0x00, 0xF3, 0x01, 0x02, 0x01, // óĂ (U+00F3 U+0102)
  0x00, 0xF3, 0x01, 0x04, 0x01, // óĄ (U+00F3 U+0104)
  0x00, 0xF3, 0x01, 0x62, 0x02, // óŢ (U+00F3 U+0162)
  0x00, 0xF3, 0x01, 0x64, 0x02, // óŤ (U+00F3 U+0164)
  0x00, 0xF3, 0x01, 0x66, 0x02, // óŦ (U+00F3 U+0166)
  0x00, 0xF3, 0x01, 0x74, 0x03, // óŴ (U+00F3 U+0174)
  0x00, 0xF3, 0x01, 0x76, 0x04, // óŶ (U+00F3 U+0176)
  0x00, 0xF3, 0x01, 0x77, 0x02, // óŷ (U+00F3 U+0177)
  0x00, 0xF3, 0x01, 0x78, 0x04, // óŸ (U+00F3 U+0178)
  0x00, 0xF4, 0x00, 0x3F, 0x02, // ô? (U+00F4 U+003F)
  0x00, 0xF4, 0x00, 0x41, 0x01, // ôA (U+00F4 U+0041)
  0x00, 0xF4, 0x00, 0x54, 0x02, // ôT (U+00F4 U+0054)
  0x00, 0xF4, 0x00, 0x56, 0x03, // ôV (U+00F4 U+0056)
  0x00, 0xF4, 0x00, 0x57, 0x03, // ôW (U+00F4 U+0057)
  0x00, 0xF4, 0x00, 0x59, 0x04, // ôY (U+00F4 U+0059)
  0x00, 0xF4, 0x00, 0x79, 0x02, // ôy (U+00F4 U+0079)
  0x00, 0xF4, 0x00, 0xC0, 0x01, // ôÀ (U+00F4 U+00C0)
  0x00, 0xF4, 0x00, 0xC1, 0x01, // ôÁ (U+00F4 U+00C1)
  0x00, 0xF4, 0x00, 0xC2, 0x01, // ôÂ (U+00F4 U+00C2)
  0x00, 0xF4, 0x00, 0xC3, 0x01, // ôÃ (U+00F4 U+00C3)
  0x00, 0xF4, 0x00, 0xC4, 0x01, // ôÄ (U+00F4 U+00C4)
  0x00, 0xF4, 0x00, 0xC5, 0x01, // ôÅ (U+00F4 U+00C5)
  0x00, 0xF4, 0x00, 0xDD, 0x04, // ôÝ (U+00F4 U+00DD)
  0x00, 0xF4, 0x00, 0xFD, 0x02, // ôý (U+00F4 U+00FD)
  0x00, 0xF4, 0x00, 0xFF, 0x02, // ôÿ (U+00F4 U+00FF)
  0x00, 0xF4, 0x01, 0x00, 0x01, // ôĀ (U+00F4 U+0100)
  0x00, 0xF4, 0x01, 0x02, 0x01, // ôĂ (U+00F4 U+0102)
  0x00, 0xF4, 0x01, 0x04, 0x01, // ôĄ (U+00F4 U+0104)
  0x00, 0xF4, 0x01, 0x62, 0x02, // ôŢ (U+00F4 U+0162)
  0x00, 0xF4, 0x01, 0x64, 0x02, // ôŤ (U+00F4 U+0164)
  0x00, 0xF4, 0x01, 0x66, 0x02, // ôŦ (U+00F4 U+0166)
  0x00, 0xF4, 0x01, 0x74, 0x03, // ôŴ (U+00F4 U+0174)
  0x00, 0xF4, 0x01, 0x76, 0x04, // ôŶ (U+00F4 U+0176)
  0x00, 0xF4, 0x01, 0x77, 0x02, // ôŷ (U+00F4 U+0177)
  0x00, 0xF4, 0x01, 0x78, 0x04, // ôŸ (U+00F4 U+0178)
  0x00, 0xF5, 0x00, 0x3F, 0x02, // õ? (U+00F5 U+003F)
  0x00, 0xF5, 0x00, 0x41, 0x01, // õA (U+00F5 U+0041)
  0x00, 0xF5, 0x00, 0x54, 0x02, // õT (U+00F5 U+0054)
  0x00, 0xF5, 0x00, 0x56, 0x03, // õV (U+00F5 U+0056)
  0x00, 0xF5, 0x00, 0x57, 0x03, // õW (U+00F5 U+0057)
  0x00, 0xF5, 0x00, 0x59, 0x04, // õY (U+00F5 U+0059)
  0x00, 0xF5, 0x00, 0x79, 0x02, // õy (U+00F5 U+0079)
  0x00, 0xF5, 0x00, 0xC0, 0x01, // õÀ (U+00F5 U+00C0)
  0x00, 0xF5, 0x00, 0xC1, 0x01, // õÁ (U+00F5 U+00C1)
  0x00, 0xF5, 0x00, 0xC2, 0x01, // õÂ (U+00F5 U+00C2)
  0x00, 0xF5, 0x00, 0xC3, 0x01, // õÃ (U+00F5 U+00C3)
  0x00, 0xF5, 0x00, 0xC4, 0x01, // õÄ (U+00F5 U+00C4)
  0x00, 0xF5, 0x00, 0xC5, 0x01, // õÅ (U+00F5 U+00C5)
  0x00, 0xF5, 0x00, 0xDD, 0x04, // õÝ (U+00F5 U+00DD)
  0x00, 0xF5, 0x00, 0xFD, 0x02, // õý (U+00F5 U+00FD)
  0x00, 0xF5, 0x00, 0xFF, 0x02, // õÿ (U+00F5 U+00FF)
  0x00, 0xF5, 0x01, 0x00, 0x01, // õĀ (U+00F5 U+0100)
  0x00, 0xF5, 0x01, 0x02, 0x01, // õĂ (U+00F5 U+0102)
  0x00, 0xF5, 0x01, 0x04, 0x01, // õĄ (U+00F5 U+0104)
  0x00, 0xF5, 0x01, 0x62, 0x02, // õŢ (U+00F5 U+0162)
  0x00, 0xF5, 0x01, 0x64, 0x02, // õŤ (U+00F5 U+0164)
  0x00, 0xF5, 0x01, 0x66, 0x02, // õŦ (U+00F5 U+0166)
  0x00, 0xF5, 0x01, 0x74, 0x03, // õŴ (U+00F5 U+0174)
  0x00, 0xF5, 0x01, 0x76, 0x04, // õŶ (U+00F5 U+0176)
  0x00, 0xF5, 0x01, 0x77, 0x02, // õŷ (U+00F5 U+0177)
  0x00, 0xF5, 0x01, 0x78, 0x04, // õŸ (U+00F5 U+0178)
  0x00, 0xF6, 0x00, 0x3F, 0x02, // ö? (U+00F6 U+003F)
  0x00, 0xF6, 0x00, 0x41, 0x01, // öA (U+00F6 U+0041)
  0x00, 0xF6, 0x00, 0x54, 0x02, // öT (U+00F6 U+0054)
  0x00, 0xF6, 0x00, 0x56, 0x03, // öV (U+00F6 U+0056)
  0x00, 0xF6, 0x00, 0x57, 0x03, // öW (U+00F6 U+0057)
  0x00, 0xF6, 0x00, 0x59, 0x04, // öY (U+00F6 U+0059)
  0x00, 0xF6, 0x00, 0x79, 0x02, // öy (U+00F6 U+0079)
  0x00, 0xF6, 0x00, 0xC0, 0x01, // öÀ (U+00F6 U+00C0)
  0x00, 0xF6, 0x00, 0xC1, 0x01, // öÁ (U+00F6 U+00C1)
  0x00, 0xF6, 0x00, 0xC2, 0x01, // öÂ (U+00F6 U+00C2)
  0x00, 0xF6, 0x00, 0xC3, 0x01, // öÃ (U+00F6 U+00C3)
  0x00, 0xF6, 0x00, 0xC4, 0x01, // öÄ (U+00F6 U+00C4)
  0x00, 0xF6, 0x00, 0xC5, 0x01, // öÅ (U+00F6 U+00C5)
  0x00, 0xF6, 0x00, 0xDD, 0x04, // öÝ (U+00F6 U+00DD)
  0x00, 0xF6, 0x00, 0xFD, 0x02, // öý (U+00F6 U+00FD)
  0x00, 0xF6, 0x00, 0xFF, 0x02, // öÿ (U+00F6 U+00FF)
  0x00, 0xF6, 0x01, 0x00, 0x01, // öĀ (U+00F6 U+0100)
  0x00, 0xF6, 0x01, 0x02, 0x01, // öĂ (U+00F6 U+0102)
  0x00, 0xF6, 0x01, 0x04, 0x01, // öĄ (U+00F6 U+0104)
  0x00, 0xF6, 0x01, 0x62, 0x02, // öŢ (U+00F6 U+0162)
  0x00, 0xF6, 0x01, 0x64, 0x02, // öŤ (U+00F6 U+0164)
  0x00, 0xF6, 0x01, 0x66, 0x02, // öŦ (U+00F6 U+0166)
  0x00, 0xF6, 0x01, 0x74, 0x03, // öŴ (U+00F6 U+0174)
  0x00, 0xF6, 0x01, 0x76, 0x04, // öŶ (U+00F6 U+0176)
  0x00, 0xF6, 0x01, 0x77, 0x02, // öŷ (U+00F6 U+0177)
  0x00, 0xF6, 0x01, 0x78, 0x04, // öŸ (U+00F6 U+0178)
  0x00, 0xF8, 0x00, 0x3F, 0x02, // ø? (U+00F8 U+003F)
  0x00, 0xF8, 0x00, 0x41, 0x01, // øA (U+00F8 U+0041)
  0x00, 0xF8, 0x00, 0x54, 0x02, // øT (U+00F8 U+0054)
  0x00, 0xF8, 0x00, 0x56, 0x03, // øV (U+00F8 U+0056)
  0x00, 0xF8, 0x00, 0x57, 0x03, // øW (U+00F8 U+0057)
  0x00, 0xF8, 0x00, 0x59, 0x04, // øY (U+00F8 U+0059)
  0x00, 0xF8, 0x00, 0x79, 0x02, // øy (U+00F8 U+0079)
  0x00, 0xF8, 0x00, 0xC0, 0x01, // øÀ (U+00F8 U+00C0)
  0x00, 0xF8, 0x00, 0xC1, 0x01, // øÁ (U+00F8 U+00C1)
  0x00, 0xF8, 0x00, 0xC2, 0x01, // øÂ (U+00F8 U+00C2)
  0x00, 0xF8, 0x00, 0xC3, 0x01, // øÃ (U+00F8 U+00C3)
  0x00, 0xF8, 0x00, 0xC4, 0x01, // øÄ (U+00F8 U+00C4)
  0x00, 0xF8, 0x00, 0xC5, 0x01, // øÅ (U+00F8 U+00C5)
  0x00, 0xF8, 0x00, 0xDD, 0x04, // øÝ (U+00F8 U+00DD)
  0x00, 0xF8, 0x00, 0xFD, 0x02, // øý (U+00F8 U+00FD)
  0x00, 0xF8, 0x00, 0xFF, 0x02, // øÿ (U+00F8 U+00FF)
  0x00, 0xF8, 0x01, 0x00, 0x01, // øĀ (U+00F8 U+0100)
  0x00, 0xF8, 0x01, 0x02, 0x01, // øĂ (U+00F8 U+0102)
  0x00, 0xF8, 0x01, 0x04, 0x01, // øĄ (U+00F8 U+0104)
  0x00, 0xF8, 0x01, 0x62, 0x02, // øŢ (U+00F8 U+0162)
  0x00, 0xF8, 0x01, 0x64, 0x02, // øŤ (U+00F8 U+0164)
  0x00, 0xF8, 0x01, 0x66, 0x02, // øŦ (U+00F8 U+0166)
  0x00, 0xF8, 0x01, 0x74, 0x03, // øŴ (U+00F8 U+0174)
  0x00, 0xF8, 0x01, 0x76, 0x04, // øŶ (U+00F8 U+0176)
  0x00, 0xF8, 0x01, 0x77, 0x02, // øŷ (U+00F8 U+0177)
  0x00, 0xF8, 0x01, 0x78, 0x04, // øŸ (U+00F8 U+0178)
  0x00, 0xFD, 0x00, 0x2C, 0x07, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x07, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x00, 0x41, 0x05, // ýA (U+00FD U+0041)
  0x00, 0xFD, 0x00, 0xC0, 0x05, // ýÀ (U+00FD U+00C0)
  0x00, 0xFD, 0x00, 0xC1, 0x05, // ýÁ (U+00FD U+00C1)
  0x00, 0xFD, 0x00, 0xC2, 0x05, // ýÂ (U+00FD U+00C2)
  0x00, 0xFD, 0x00, 0xC3, 0x05, // ýÃ (U+00FD U+00C3)
  0x00, 0xFD, 0x00, 0xC4, 0x05, // ýÄ (U+00FD U+00C4)
  0x00, 0xFD, 0x00, 0xC5, 0x05, // ýÅ (U+00FD U+00C5)
  0x00, 0xFD, 0x01, 0x00, 0x05, // ýĀ (U+00FD U+0100)
  0x00, 0xFD, 0x01, 0x02, 0x05, // ýĂ (U+00FD U+0102)
  0x00, 0xFD, 0x01, 0x04, 0x05, // ýĄ (U+00FD U+0104)
  0x00, 0xFD, 0x20, 0x1A, 0x07, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x07, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x07, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x3F, 0x02, // þ? (U+00FE U+003F)
  0x00, 0xFE, 0x00, 0x41, 0x01, // þA (U+00FE U+0041)
  0x00, 0xFE, 0x00, 0x54, 0x02, // þT (U+00FE U+0054)
  0x00, 0xFE, 0x00, 0x56, 0x03, // þV (U+00FE U+0056)
  0x00, 0xFE, 0x00, 0x57, 0x03, // þW (U+00FE U+0057)
  0x00, 0xFE, 0x00, 0x59, 0x04, // þY (U+00FE U+0059)
  0x00, 0xFE, 0x00, 0x79, 0x02, // þy (U+00FE U+0079)
  0x00, 0xFE, 0x00, 0xC0, 0x01, // þÀ (U+00FE U+00C0)
  0x00, 0xFE, 0x00, 0xC1, 0x01, // þÁ (U+00FE U+00C1)
  0x00, 0xFE, 0x00, 0xC2, 0x01, // þÂ (U+00FE U+00C2)
  0x00, 0xFE, 0x00, 0xC3, 0x01, // þÃ (U+00FE U+00C3)
  0x00, 0xFE, 0x00, 0xC4, 0x01, // þÄ (U+00FE U+00C4)
  0x00, 0xFE, 0x00, 0xC5, 0x01, // þÅ (U+00FE U+00C5)
  0x00, 0xFE, 0x00, 0xDD, 0x04, // þÝ (U+00FE U+00DD)
  0x00, 0xFE, 0x00, 0xFD, 0x02, // þý (U+00FE U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x02, // þÿ (U+00FE U+00FF)
  0x00, 0xFE, 0x01, 0x00, 0x01, // þĀ (U+00FE U+0100)
  0x00, 0xFE, 0x01, 0x02, 0x01, // þĂ (U+00FE U+0102)
  0x00, 0xFE, 0x01, 0x04, 0x01, // þĄ (U+00FE U+0104)
  0x00, 0xFE, 0x01, 0x62, 0x02, // þŢ (U+00FE U+0162)
  0x00, 0xFE, 0x01, 0x64, 0x02, // þŤ (U+00FE U+0164)
  0x00, 0xFE, 0x01, 0x66, 0x02, // þŦ (U+00FE U+0166)
  0x00, 0xFE, 0x01, 0x74, 0x03, // þŴ (U+00FE U+0174)
  0x00, 0xFE, 0x01, 0x76, 0x04, // þŶ (U+00FE U+0176)
  0x00, 0xFE, 0x01, 0x77, 0x02, // þŷ (U+00FE U+0177)
  0x00, 0xFE, 0x01, 0x78, 0x04, // þŸ (U+00FE U+0178)
  0x00, 0xFF, 0x00, 0x2C, 0x07, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x07, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x00, 0x41, 0x05, // ÿA (U+00FF U+0041)
  0x00, 0xFF, 0x00, 0xC0, 0x05, // ÿÀ (U+00FF U+00C0)
  0x00, 0xFF, 0x00, 0xC1, 0x05, // ÿÁ (U+00FF U+00C1)
  0x00, 0xFF, 0x00, 0xC2, 0x05, // ÿÂ (U+00FF U+00C2)
  0x00, 0xFF, 0x00, 0xC3, 0x05, // ÿÃ (U+00FF U+00C3)
  0x00, 0xFF, 0x00, 0xC4, 0x05, // ÿÄ (U+00FF U+00C4)
  0x00, 0xFF, 0x00, 0xC5, 0x05, // ÿÅ (U+00FF U+00C5)
  0x00, 0xFF, 0x01, 0x00, 0x05, // ÿĀ (U+00FF U+0100)
  0x00, 0xFF, 0x01, 0x02, 0x05, // ÿĂ (U+00FF U+0102)
  0x00, 0xFF, 0x01, 0x04, 0x05, // ÿĄ (U+00FF U+0104)
  0x00, 0xFF, 0x20, 0x1A, 0x07, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x07, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x07, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x07, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x07, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x2A, 0x06, // Ā* (U+0100 U+002A)
  0x01, 0x00, 0x00, 0x3F, 0x05, // Ā? (U+0100 U+003F)
  0x01, 0x00, 0x00, 0x43, 0x02, // ĀC (U+0100 U+0043)
  0x01, 0x00, 0x00, 0x47, 0x02, // ĀG (U+0100 U+0047)
  0x01, 0x00, 0x00, 0x4F, 0x02, // ĀO (U+0100 U+004F)
  0x01, 0x00, 0x00, 0x51, 0x02, // ĀQ (U+0100 U+0051)
  0x01, 0x00, 0x00, 0x54, 0x05, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x55, 0x02, // ĀU (U+0100 U+0055)
  0x01, 0x00, 0x00, 0x56, 0x06, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x05, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x04, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0x63, 0x02, // Āc (U+0100 U+0063)
  0x01, 0x00, 0x00, 0x64, 0x02, // Ād (U+0100 U+0064)
  0x01, 0x00, 0x00, 0x65, 0x02, // Āe (U+0100 U+0065)
  0x01, 0x00, 0x00, 0x67, 0x02, // Āg (U+0100 U+0067)
  0x01, 0x00, 0x00, 0x6F, 0x02, // Āo (U+0100 U+006F)
  0x01, 0x00, 0x00, 0x71, 0x02, // Āq (U+0100 U+0071)
  0x01, 0x00, 0x00, 0x75, 0x02, // Āu (U+0100 U+0075)
  0x01, 0x00, 0x00, 0x76, 0x04, // Āv (U+0100 U+0076)
  0x01, 0x00, 0x00, 0x77, 0x03, // Āw (U+0100 U+0077)
  0x01, 0x00, 0x00, 0x79, 0x05, // Āy (U+0100 U+0079)
  0x01, 0x00, 0x00, 0xC7, 0x02, // ĀÇ (U+0100 U+00C7)
  0x01, 0x00, 0x00, 0xD2, 0x02, // ĀÒ (U+0100 U+00D2)
  0x01, 0x00, 0x00, 0xD3, 0x02, // ĀÓ (U+0100 U+00D3)
  0x01, 0x00, 0x00, 0xD4, 0x02, // ĀÔ (U+0100 U+00D4)
  0x01, 0x00, 0x00, 0xD5, 0x02, // ĀÕ (U+0100 U+00D5)
  0x01, 0x00, 0x00, 0xD6, 0x02, // ĀÖ (U+0100 U+00D6)
  0x01, 0x00, 0x00, 0xD8, 0x02, // ĀØ (U+0100 U+00D8)
  0x01, 0x00, 0x00, 0xD9, 0x02, // ĀÙ (U+0100 U+00D9)
  0x01, 0x00, 0x00, 0xDA, 0x02, // ĀÚ (U+0100 U+00DA)
  0x01, 0x00, 0x00, 0xDB, 0x02, // ĀÛ (U+0100 U+00DB)
  0x01, 0x00, 0x00, 0xDC, 0x02, // ĀÜ (U+0100 U+00DC)
  0x01, 0x00, 0x00, 0xDD, 0x04, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x00, 0xE7, 0x02, // Āç (U+0100 U+00E7)
  0x01, 0x00, 0x00, 0xE8, 0x02, // Āè (U+0100 U+00E8)
  0x01, 0x00, 0x00, 0xE9, 0x02, // Āé (U+0100 U+00E9)
  0x01, 0x00, 0x00, 0xEA, 0x02, // Āê (U+0100 U+00EA)
  0x01, 0x00, 0x00, 0xEB, 0x02, // Āë (U+0100 U+00EB)
  0x01, 0x00, 0x00, 0xF0, 0x02, // Āð (U+0100 U+00F0)
  0x01, 0x00, 0x00, 0xF2, 0x02, // Āò (U+0100 U+00F2)
  0x01, 0x00, 0x00, 0xF3, 0x02, // Āó (U+0100 U+00F3)
  0x01, 0x00, 0x00, 0xF4, 0x02, // Āô (U+0100 U+00F4)
  0x01, 0x00, 0x00, 0xF5, 0x02, // Āõ (U+0100 U+00F5)
  0x01, 0x00, 0x00, 0xF6, 0x02, // Āö (U+0100 U+00F6)
  0x01, 0x00, 0x00, 0xF8, 0x02, // Āø (U+0100 U+00F8)
  0x01, 0x00, 0x00, 0xF9, 0x02, // Āù (U+0100 U+00F9)
  0x01, 0x00, 0x00, 0xFA, 0x02, // Āú (U+0100 U+00FA)
  0x01, 0x00, 0x00, 0xFB, 0x02, // Āû (U+0100 U+00FB)
  0x01, 0x00, 0x00, 0xFC, 0x02, // Āü (U+0100 U+00FC)
  0x01, 0x00, 0x00, 0xFD, 0x05, // Āý (U+0100 U+00FD)
  0x01, 0x00, 0x00, 0xFF, 0x05, // Āÿ (U+0100 U+00FF)
  0x01, 0x00, 0x01, 0x06, 0x02, // ĀĆ (U+0100 U+0106)
  0x01, 0x00, 0x01, 0x07, 0x02, // Āć (U+0100 U+0107)
  0x01, 0x00, 0x01, 0x08, 0x02, // ĀĈ (U+0100 U+0108)
  0x01, 0x00, 0x01, 0x09, 0x02, // Āĉ (U+0100 U+0109)
  0x01, 0x00, 0x01, 0x0A, 0x02, // ĀĊ (U+0100 U+010A)
  0x01, 0x00, 0x01, 0x0B, 0x02, // Āċ (U+0100 U+010B)
  0x01, 0x00, 0x01, 0x0C, 0x02, // ĀČ (U+0100 U+010C)
  0x01, 0x00, 0x01, 0x0D, 0x02, // Āč (U+0100 U+010D)
  0x01, 0x00, 0x01, 0x0F, 0x02, // Āď (U+0100 U+010F)
  0x01, 0x00, 0x01, 0x11, 0x02, // Āđ (U+0100 U+0111)
  0x01, 0x00, 0x01, 0x13, 0x02, // Āē (U+0100 U+0113)
  0x01, 0x00, 0x01, 0x15, 0x02, // Āĕ (U+0100 U+0115)
  0x01, 0x00, 0x01, 0x17, 0x02, // Āė (U+0100 U+0117)
  0x01, 0x00, 0x01, 0x19, 0x02, // Āę (U+0100 U+0119)
  0x01, 0x00, 0x01, 0x1B, 0x02, // Āě (U+0100 U+011B)
  0x01, 0x00, 0x01, 0x1C, 0x02, // ĀĜ (U+0100 U+011C)
  0x01, 0x00, 0x01, 0x1D, 0x02, // Āĝ (U+0100 U+011D)
  0x01, 0x00, 0x01, 0x1E, 0x02, // ĀĞ (U+0100 U+011E)
  0x01, 0x00, 0x01, 0x1F, 0x02, // Āğ (U+0100 U+011F)
  0x01, 0x00, 0x01, 0x20, 0x02, // ĀĠ (U+0100 U+0120)
  0x01, 0x00, 0x01, 0x21, 0x02, // Āġ (U+0100 U+0121)
  0x01, 0x00, 0x01, 0x22, 0x02, // ĀĢ (U+0100 U+0122)
  0x01, 0x00, 0x01, 0x23, 0x02, // Āģ (U+0100 U+0123)
  0x01, 0x00, 0x01, 0x4C, 0x02, // ĀŌ (U+0100 U+014C)
  0x01, 0x00, 0x01, 0x4D, 0x02, // Āō (U+0100 U+014D)
  0x01, 0x00, 0x01, 0x4E, 0x02, // ĀŎ (U+0100 U+014E)
  0x01, 0x00, 0x01, 0x4F, 0x02, // Āŏ (U+0100 U+014F)
  0x01, 0x00, 0x01, 0x50, 0x02, // ĀŐ (U+0100 U+0150)
  0x01, 0x00, 0x01, 0x51, 0x02, // Āő (U+0100 U+0151)
  0x01, 0x00, 0x01, 0x52, 0x02, // ĀŒ (U+0100 U+0152)
  0x01, 0x00, 0x01, 0x53, 0x02, // Āœ (U+0100 U+0153)
  0x01, 0x00, 0x01, 0x62, 0x05, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x05, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x05, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x68, 0x02, // ĀŨ (U+0100 U+0168)
  0x01, 0x00, 0x01, 0x69, 0x02, // Āũ (U+0100 U+0169)
  0x01, 0x00, 0x01, 0x6A, 0x02, // ĀŪ (U+0100 U+016A)
  0x01, 0x00, 0x01, 0x6B, 0x02, // Āū (U+0100 U+016B)
  0x01, 0x00, 0x01, 0x6C, 0x02, // ĀŬ (U+0100 U+016C)
  0x01, 0x00, 0x01, 0x6D, 0x02, // Āŭ (U+0100 U+016D)
  0x01, 0x00, 0x01, 0x6E, 0x02, // ĀŮ (U+0100 U+016E)
  0x01, 0x00, 0x01, 0x6F, 0x02, // Āů (U+0100 U+016F)
  0x01, 0x00, 0x01, 0x70, 0x02, // ĀŰ (U+0100 U+0170)
  0x01, 0x00, 0x01, 0x71, 0x02, // Āű (U+0100 U+0171)
  0x01, 0x00, 0x01, 0x72, 0x02, // ĀŲ (U+0100 U+0172)
  0x01, 0x00, 0x01, 0x73, 0x02, // Āų (U+0100 U+0173)
  0x01, 0x00, 0x01, 0x74, 0x05, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x75, 0x03, // Āŵ (U+0100 U+0175)
  0x01, 0x00, 0x01, 0x76, 0x04, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x77, 0x05, // Āŷ (U+0100 U+0177)
  0x01, 0x00, 0x01, 0x78, 0x04, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x18, 0x06, // Ā‘ (U+0100 U+2018)
  0x01, 0x00, 0x20, 0x19, 0x06, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1C, 0x06, // Ā“ (U+0100 U+201C)
  0x01, 0x00, 0x20, 0x1D, 0x06, // Ā” (U+0100 U+201D)
  0x01, 0x00, 0x21, 0x22, 0x06, // Ā™ (U+0100 U+2122)
  0x01, 0x01, 0x00, 0x56, 0x03, // āV (U+0101 U+0056)
  0x01, 0x01, 0x00, 0x57, 0x03, // āW (U+0101 U+0057)
  0x01, 0x01, 0x00, 0x59, 0x03, // āY (U+0101 U+0059)
  0x01, 0x01, 0x00, 0xDD, 0x03, // āÝ (U+0101 U+00DD)
  0x01, 0x01, 0x01, 0x74, 0x03, // āŴ (U+0101 U+0174)
  0x01, 0x01, 0x01, 0x76, 0x03, // āŶ (U+0101 U+0176)
  0x01, 0x01, 0x01, 0x78, 0x03, // āŸ (U+0101 U+0178)
  0x01, 0x02, 0x00, 0x22, 0x07, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x07, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x2A, 0x06, // Ă* (U+0102 U+002A)
  0x01, 0x02, 0x00, 0x3F, 0x05, // Ă? (U+0102 U+003F)
  0x01, 0x02, 0x00, 0x43, 0x02, // ĂC (U+0102 U+0043)
  0x01, 0x02, 0x00, 0x47, 0x02, // ĂG (U+0102 U+0047)
  0x01, 0x02, 0x00, 0x4F, 0x02, // ĂO (U+0102 U+004F)
  0x01, 0x02, 0x00, 0x51, 0x02, // ĂQ (U+0102 U+0051)
  0x01, 0x02, 0x00, 0x54, 0x05, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x55, 0x02, // ĂU (U+0102 U+0055)
  0x01, 0x02, 0x00, 0x56, 0x06, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x05, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x04, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0x63, 0x02, // Ăc (U+0102 U+0063)
  0x01, 0x02, 0x00, 0x64, 0x02, // Ăd (U+0102 U+0064)
  0x01, 0x02, 0x00, 0x65, 0x02, // Ăe (U+0102 U+0065)
  0x01, 0x02, 0x00, 0x67, 0x02, // Ăg (U+0102 U+0067)
  0x01, 0x02, 0x00, 0x6F, 0x02, // Ăo (U+0102 U+006F)
  0x01, 0x02, 0x00, 0x71, 0x02, // Ăq (U+0102 U+0071)
  0x01, 0x02, 0x00, 0x75, 0x02, // Ău (U+0102 U+0075)
  0x01, 0x02, 0x00, 0x76, 0x05, // Ăv (U+0102 U+0076)
  0x01, 0x02, 0x00, 0x77, 0x03, // Ăw (U+0102 U+0077)
  0x01, 0x02, 0x00, 0x79, 0x05, // Ăy (U+0102 U+0079)
  0x01, 0x02, 0x00, 0xC7, 0x02, // ĂÇ (U+0102 U+00C7)
  0x01, 0x02, 0x00, 0xD2, 0x02, // ĂÒ (U+0102 U+00D2)
  0x01, 0x02, 0x00, 0xD3, 0x02, // ĂÓ (U+0102 U+00D3)
  0x01, 0x02, 0x00, 0xD4, 0x02, // ĂÔ (U+0102 U+00D4)
  0x01, 0x02, 0x00, 0xD5, 0x02, // ĂÕ (U+0102 U+00D5)
  0x01, 0x02, 0x00, 0xD6, 0x02, // ĂÖ (U+0102 U+00D6)
  0x01, 0x02, 0x00, 0xD8, 0x02, // ĂØ (U+0102 U+00D8)
  0x01, 0x02, 0x00, 0xD9, 0x02, // ĂÙ (U+0102 U+00D9)
  0x01, 0x02, 0x00, 0xDA, 0x02, // ĂÚ (U+0102 U+00DA)
  0x01, 0x02, 0x00, 0xDB, 0x02, // ĂÛ (U+0102 U+00DB)
  0x01, 0x02, 0x00, 0xDC, 0x02, // ĂÜ (U+0102 U+00DC)
  0x01, 0x02, 0x00, 0xDD, 0x04, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x00, 0xE7, 0x02, // Ăç (U+0102 U+00E7)
  0x01, 0x02, 0x00, 0xE8, 0x02, // Ăè (U+0102 U+00E8)
  0x01, 0x02, 0x00, 0xE9, 0x02, // Ăé (U+0102 U+00E9)
  0x01, 0x02, 0x00, 0xEA, 0x02, // Ăê (U+0102 U+00EA)
  0x01, 0x02, 0x00, 0xEB, 0x02, // Ăë (U+0102 U+00EB)
  0x01, 0x02, 0x00, 0xF0, 0x02, // Ăð (U+0102 U+00F0)
  0x01, 0x02, 0x00, 0xF2, 0x02, // Ăò (U+0102 U+00F2)
  0x01, 0x02, 0x00, 0xF3, 0x02, // Ăó (U+0102 U+00F3)
  0x01, 0x02, 0x00, 0xF4, 0x02, // Ăô (U+0102 U+00F4)
  0x01, 0x02, 0x00, 0xF5, 0x02, // Ăõ (U+0102 U+00F5)
  0x01, 0x02, 0x00, 0xF6, 0x02, // Ăö (U+0102 U+00F6)
  0x01, 0x02, 0x00, 0xF8, 0x02, // Ăø (U+0102 U+00F8)
  0x01, 0x02, 0x00, 0xF9, 0x02, // Ăù (U+0102 U+00F9)
  0x01, 0x02, 0x00, 0xFA, 0x02, // Ăú (U+0102 U+00FA)
  0x01, 0x02, 0x00, 0xFB, 0x02, // Ăû (U+0102 U+00FB)
  0x01, 0x02, 0x00, 0xFC, 0x02, // Ăü (U+0102 U+00FC)
  0x01, 0x02, 0x00, 0xFD, 0x05, // Ăý (U+0102 U+00FD)
  0x01, 0x02, 0x00, 0xFF, 0x05, // Ăÿ (U+0102 U+00FF)
  0x01, 0x02, 0x01, 0x06, 0x02, // ĂĆ (U+0102 U+0106)
  0x01, 0x02, 0x01, 0x07, 0x02, // Ăć (U+0102 U+0107)
  0x01, 0x02, 0x01, 0x08, 0x02, // ĂĈ (U+0102 U+0108)
  0x01, 0x02, 0x01, 0x09, 0x02, // Ăĉ (U+0102 U+0109)
  0x01, 0x02, 0x01, 0x0A, 0x02, // ĂĊ (U+0102 U+010A)
  0x01, 0x02, 0x01, 0x0B, 0x02, // Ăċ (U+0102 U+010B)
  0x01, 0x02, 0x01, 0x0C, 0x02, // ĂČ (U+0102 U+010C)
  0x01, 0x02, 0x01, 0x0D, 0x02, // Ăč (U+0102 U+010D)
  0x01, 0x02, 0x01, 0x0F, 0x02, // Ăď (U+0102 U+010F)
  0x01, 0x02, 0x01, 0x11, 0x02, // Ăđ (U+0102 U+0111)
  0x01, 0x02, 0x01, 0x13, 0x02, // Ăē (U+0102 U+0113)
  0x01, 0x02, 0x01, 0x15, 0x02, // Ăĕ (U+0102 U+0115)
  0x01, 0x02, 0x01, 0x17, 0x02, // Ăė (U+0102 U+0117)
  0x01, 0x02, 0x01, 0x19, 0x02, // Ăę (U+0102 U+0119)
  0x01, 0x02, 0x01, 0x1B, 0x02, // Ăě (U+0102 U+011B)
  0x01, 0x02, 0x01, 0x1C, 0x02, // ĂĜ (U+0102 U+011C)
  0x01, 0x02, 0x01, 0x1D, 0x02, // Ăĝ (U+0102 U+011D)
  0x01, 0x02, 0x01, 0x1E, 0x02, // ĂĞ (U+0102 U+011E)
  0x01, 0x02, 0x01, 0x1F, 0x02, // Ăğ (U+0102 U+011F)
  0x01, 0x02, 0x01, 0x20, 0x02, // ĂĠ (U+0102 U+0120)
  0x01, 0x02, 0x01, 0x21, 0x02, // Ăġ (U+0102 U+0121)
  0x01, 0x02, 0x01, 0x22, 0x02, // ĂĢ (U+0102 U+0122)
  0x01, 0x02, 0x01, 0x23, 0x02, // Ăģ (U+0102 U+0123)
  0x01, 0x02, 0x01, 0x4C, 0x02, // ĂŌ (U+0102 U+014C)
  0x01, 0x02, 0x01, 0x4D, 0x02, // Ăō (U+0102 U+014D)
  0x01, 0x02, 0x01, 0x4E, 0x02, // ĂŎ (U+0102 U+014E)
  0x01, 0x02, 0x01, 0x4F, 0x02, // Ăŏ (U+0102 U+014F)
  0x01, 0x02, 0x01, 0x50, 0x02, // ĂŐ (U+0102 U+0150)
  0x01, 0x02, 0x01, 0x51, 0x02, // Ăő (U+0102 U+0151)
  0x01, 0x02, 0x01, 0x52, 0x02, // ĂŒ (U+0102 U+0152)
  0x01, 0x02, 0x01, 0x53, 0x02, // Ăœ (U+0102 U+0153)
  0x01, 0x02, 0x01, 0x62, 0x05, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x05, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x05, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x68, 0x02, // ĂŨ (U+0102 U+0168)
  0x01, 0x02, 0x01, 0x69, 0x02, // Ăũ (U+0102 U+0169)
  0x01, 0x02, 0x01, 0x6A, 0x02, // ĂŪ (U+0102 U+016A)
  0x01, 0x02, 0x01, 0x6B, 0x02, // Ăū (U+0102 U+016B)
  0x01, 0x02, 0x01, 0x6C, 0x02, // ĂŬ (U+0102 U+016C)
  0x01, 0x02, 0x01, 0x6D, 0x02, // Ăŭ (U+0102 U+016D)
  0x01, 0x02, 0x01, 0x6E, 0x02, // ĂŮ (U+0102 U+016E)
  0x01, 0x02, 0x01, 0x6F, 0x02, // Ăů (U+0102 U+016F)
  0x01, 0x02, 0x01, 0x70, 0x02, // ĂŰ (U+0102 U+0170)
  0x01, 0x02, 0x01, 0x71, 0x02, // Ăű (U+0102 U+0171)
  0x01, 0x02, 0x01, 0x72, 0x02, // ĂŲ (U+0102 U+0172)
  0x01, 0x02, 0x01, 0x73, 0x02, // Ăų (U+0102 U+0173)
  0x01, 0x02, 0x01, 0x74, 0x05, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x75, 0x03, // Ăŵ (U+0102 U+0175)
  0x01, 0x02, 0x01, 0x76, 0x04, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x77, 0x05, // Ăŷ (U+0102 U+0177)
  0x01, 0x02, 0x01, 0x78, 0x04, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x18, 0x06, // Ă‘ (U+0102 U+2018)
  0x01, 0x02, 0x20, 0x19, 0x06, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1C, 0x06, // Ă“ (U+0102 U+201C)
  0x01, 0x02, 0x20, 0x1D, 0x06, // Ă” (U+0102 U+201D)
  0x01, 0x02, 0x21, 0x22, 0x06, // Ă™ (U+0102 U+2122)
  0x01, 0x04, 0x00, 0x22, 0x07, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x07, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x2A, 0x06, // Ą* (U+0104 U+002A)
  0x01, 0x04, 0x00, 0x3F, 0x05, // Ą? (U+0104 U+003F)
  0x01, 0x04, 0x00, 0x43, 0x02, // ĄC (U+0104 U+0043)
  0x01, 0x04, 0x00, 0x47, 0x02, // ĄG (U+0104 U+0047)
  0x01, 0x04, 0x00, 0x4F, 0x02, // ĄO (U+0104 U+004F)
  0x01, 0x04, 0x00, 0x51, 0x02, // ĄQ (U+0104 U+0051)
  0x01, 0x04, 0x00, 0x54, 0x05, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x55, 0x02, // ĄU (U+0104 U+0055)
  0x01, 0x04, 0x00, 0x56, 0x06, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x05, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x04, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0x63, 0x02, // Ąc (U+0104 U+0063)
  0x01, 0x04, 0x00, 0x64, 0x02, // Ąd (U+0104 U+0064)
  0x01, 0x04, 0x00, 0x65, 0x02, // Ąe (U+0104 U+0065)
  0x01, 0x04, 0x00, 0x67, 0x02, // Ąg (U+0104 U+0067)
  0x01, 0x04, 0x00, 0x6F, 0x02, // Ąo (U+0104 U+006F)
  0x01, 0x04, 0x00, 0x71, 0x02, // Ąq (U+0104 U+0071)
  0x01, 0x04, 0x00, 0x75, 0x02, // Ąu (U+0104 U+0075)
  0x01, 0x04, 0x00, 0x76, 0x05, // Ąv (U+0104 U+0076)
  0x01, 0x04, 0x00, 0x77, 0x03, // Ąw (U+0104 U+0077)
  0x01, 0x04, 0x00, 0x79, 0x05, // Ąy (U+0104 U+0079)
  0x01, 0x04, 0x00, 0xC7, 0x02, // ĄÇ (U+0104 U+00C7)
  0x01, 0x04, 0x00, 0xD2, 0x02, // ĄÒ (U+0104 U+00D2)
  0x01, 0x04, 0x00, 0xD3, 0x02, // ĄÓ (U+0104 U+00D3)
  0x01, 0x04, 0x00, 0xD4, 0x02, // ĄÔ (U+0104 U+00D4)
  0x01, 0x04, 0x00, 0xD5, 0x02, // ĄÕ (U+0104 U+00D5)
  0x01, 0x04, 0x00, 0xD6, 0x02, // ĄÖ (U+0104 U+00D6)
  0x01, 0x04, 0x00, 0xD8, 0x02, // ĄØ (U+0104 U+00D8)
  0x01, 0x04, 0x00, 0xD9, 0x02, // ĄÙ (U+0104 U+00D9)
  0x01, 0x04, 0x00, 0xDA, 0x02, // ĄÚ (U+0104 U+00DA)
  0x01, 0x04, 0x00, 0xDB, 0x02, // ĄÛ (U+0104 U+00DB)
  0x01, 0x04, 0x00, 0xDC, 0x02, // ĄÜ (U+0104 U+00DC)
  0x01, 0x04, 0x00, 0xDD, 0x04, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x00, 0xE7, 0x02, // Ąç (U+0104 U+00E7)
  0x01, 0x04, 0x00, 0xE8, 0x02, // Ąè (U+0104 U+00E8)
  0x01, 0x04, 0x00, 0xE9, 0x02, // Ąé (U+0104 U+00E9)
  0x01, 0x04, 0x00, 0xEA, 0x02, // Ąê (U+0104 U+00EA)
  0x01, 0x04, 0x00, 0xEB, 0x02, // Ąë (U+0104 U+00EB)
  0x01, 0x04, 0x00, 0xF0, 0x02, // Ąð (U+0104 U+00F0)
  0x01, 0x04, 0x00, 0xF2, 0x02, // Ąò (U+0104 U+00F2)
  0x01, 0x04, 0x00, 0xF3, 0x02, // Ąó (U+0104 U+00F3)
  0x01, 0x04, 0x00, 0xF4, 0x02, // Ąô (U+0104 U+00F4)
  0x01, 0x04, 0x00, 0xF5, 0x02, // Ąõ (U+0104 U+00F5)
  0x01, 0x04, 0x00, 0xF6, 0x02, // Ąö (U+0104 U+00F6)
  0x01, 0x04, 0x00, 0xF8, 0x02, // Ąø (U+0104 U+00F8)
  0x01, 0x04, 0x00, 0xF9, 0x02, // Ąù (U+0104 U+00F9)
  0x01, 0x04, 0x00, 0xFA, 0x02, // Ąú (U+0104 U+00FA)
  0x01, 0x04, 0x00, 0xFB, 0x02, // Ąû (U+0104 U+00FB)
  0x01, 0x04, 0x00, 0xFC, 0x02, // Ąü (U+0104 U+00FC)
  0x01, 0x04, 0x00, 0xFD, 0x05, // Ąý (U+0104 U+00FD)
  0x01, 0x04, 0x00, 0xFF, 0x05, // Ąÿ (U+0104 U+00FF)
  0x01, 0x04, 0x01, 0x06, 0x02, // ĄĆ (U+0104 U+0106)
  0x01, 0x04, 0x01, 0x07, 0x02, // Ąć (U+0104 U+0107)
  0x01, 0x04, 0x01, 0x08, 0x02, // ĄĈ (U+0104 U+0108)
  0x01, 0x04, 0x01, 0x09, 0x02, // Ąĉ (U+0104 U+0109)
  0x01, 0x04, 0x01, 0x0A, 0x02, // ĄĊ (U+0104 U+010A)
  0x01, 0x04, 0x01, 0x0B, 0x02, // Ąċ (U+0104 U+010B)
  0x01, 0x04, 0x01, 0x0C, 0x02, // ĄČ (U+0104 U+010C)
  0x01, 0x04, 0x01, 0x0D, 0x02, // Ąč (U+0104 U+010D)
  0x01, 0x04, 0x01, 0x0F, 0x02, // Ąď (U+0104 U+010F)
  0x01, 0x04, 0x01, 0x11, 0x02, // Ąđ (U+0104 U+0111)
  0x01, 0x04, 0x01, 0x13, 0x02, // Ąē (U+0104 U+0113)
  0x01, 0x04, 0x01, 0x15, 0x02, // Ąĕ (U+0104 U+0115)
  0x01, 0x04, 0x01, 0x17, 0x02, // Ąė (U+0104 U+0117)
  0x01, 0x04, 0x01, 0x19, 0x02, // Ąę (U+0104 U+0119)
  0x01, 0x04, 0x01, 0x1B, 0x02, // Ąě (U+0104 U+011B)
  0x01, 0x04, 0x01, 0x1C, 0x02, // ĄĜ (U+0104 U+011C)
  0x01, 0x04, 0x01, 0x1D, 0x02, // Ąĝ (U+0104 U+011D)
  0x01, 0x04, 0x01, 0x1E, 0x02, // ĄĞ (U+0104 U+011E)
  0x01, 0x04, 0x01, 0x1F, 0x02, // Ąğ (U+0104 U+011F)
  0x01, 0x04, 0x01, 0x20, 0x02, // ĄĠ (U+0104 U+0120)
  0x01, 0x04, 0x01, 0x21, 0x02, // Ąġ (U+0104 U+0121)
  0x01, 0x04, 0x01, 0x22, 0x02, // ĄĢ (U+0104 U+0122)
  0x01, 0x04, 0x01, 0x23, 0x02, // Ąģ (U+0104 U+0123)
  0x01, 0x04, 0x01, 0x4C, 0x02, // ĄŌ (U+0104 U+014C)
  0x01, 0x04, 0x01, 0x4D, 0x02, // Ąō (U+0104 U+014D)
  0x01, 0x04, 0x01, 0x4E, 0x02, // ĄŎ (U+0104 U+014E)
  0x01, 0x04, 0x01, 0x4F, 0x02, // Ąŏ (U+0104 U+014F)
  0x01, 0x04, 0x01, 0x50, 0x02, // ĄŐ (U+0104 U+0150)
  0x01, 0x04, 0x01, 0x51, 0x02, // Ąő (U+0104 U+0151)
  0x01, 0x04, 0x01, 0x52, 0x02, // ĄŒ (U+0104 U+0152)
  0x01, 0x04, 0x01, 0x53, 0x02, // Ąœ (U+0104 U+0153)
  0x01, 0x04, 0x01, 0x62, 0x05, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x05, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x05, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x68, 0x02, // ĄŨ (U+0104 U+0168)
  0x01, 0x04, 0x01, 0x69, 0x02, // Ąũ (U+0104 U+0169)
  0x01, 0x04, 0x01, 0x6A, 0x02, // ĄŪ (U+0104 U+016A)
  0x01, 0x04, 0x01, 0x6B, 0x02, // Ąū (U+0104 U+016B)
  0x01, 0x04, 0x01, 0x6C, 0x02, // ĄŬ (U+0104 U+016C)
  0x01, 0x04, 0x01, 0x6D, 0x02, // Ąŭ (U+0104 U+016D)
  0x01, 0x04, 0x01, 0x6E, 0x02, // ĄŮ (U+0104 U+016E)
  0x01, 0x04, 0x01, 0x6F, 0x02, // Ąů (U+0104 U+016F)
  0x01, 0x04, 0x01, 0x70, 0x02, // ĄŰ (U+0104 U+0170)
  0x01, 0x04, 0x01, 0x71, 0x02, // Ąű (U+0104 U+0171)
  0x01, 0x04, 0x01, 0x72, 0x02, // ĄŲ (U+0104 U+0172)
  0x01, 0x04, 0x01, 0x73, 0x02, // Ąų (U+0104 U+0173)
  0x01, 0x04, 0x01, 0x74, 0x05, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x75, 0x03, // Ąŵ (U+0104 U+0175)
  0x01, 0x04, 0x01, 0x76, 0x04, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x77, 0x05, // Ąŷ (U+0104 U+0177)
  0x01, 0x04, 0x01, 0x78, 0x04, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x18, 0x06, // Ą‘ (U+0104 U+2018)
  0x01, 0x04, 0x20, 0x19, 0x06, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1C, 0x06, // Ą“ (U+0104 U+201C)
  0x01, 0x04, 0x20, 0x1D, 0x06, // Ą” (U+0104 U+201D)
  0x01, 0x04, 0x21, 0x22, 0x06, // Ą™ (U+0104 U+2122)
  0x01, 0x05, 0x00, 0x56, 0x03, // ąV (U+0105 U+0056)
  0x01, 0x05, 0x00, 0x57, 0x03, // ąW (U+0105 U+0057)
  0x01, 0x05, 0x00, 0x59, 0x03, // ąY (U+0105 U+0059)
  0x01, 0x05, 0x00, 0xDD, 0x03, // ąÝ (U+0105 U+00DD)
  0x01, 0x05, 0x01, 0x74, 0x03, // ąŴ (U+0105 U+0174)
  0x01, 0x05, 0x01, 0x76, 0x03, // ąŶ (U+0105 U+0176)
  0x01, 0x05, 0x01, 0x78, 0x03, // ąŸ (U+0105 U+0178)
  0x01, 0x06, 0x00, 0x43, 0x01, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x01, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x01, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x01, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xC7, 0x01, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x01, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x01, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x01, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x01, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x01, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x01, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x01, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x01, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x01, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x01, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x01, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x01, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x01, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x01, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x01, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x01, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x01, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x01, // ĆŒ (U+0106 U+0152)
  0x01, 0x08, 0x00, 0x43, 0x01, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x01, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x01, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x01, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xC7, 0x01, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x01, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x01, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x01, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x01, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x01, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x01, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x01, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x01, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x01, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x01, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x01, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x01, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x01, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x01, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x01, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x01, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x01, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x01, // ĈŒ (U+0108 U+0152)
  0x01, 0x0A, 0x00, 0x43, 0x01, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x01, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x01, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x01, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xC7, 0x01, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x01, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x01, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x01, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x01, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x01, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x01, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x01, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x01, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x01, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x01, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x01, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x01, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x01, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x01, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x01, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x01, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x01, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x01, // ĊŒ (U+010A U+0152)
  0x01, 0x0C, 0x00, 0x43, 0x01, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x01, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x01, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x01, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xC7, 0x01, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x01, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x01, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x01, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x01, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x01, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x01, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x01, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x01, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x01, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x01, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x01, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x01, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x01, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x01, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x01, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x01, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x01, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x01, // ČŒ (U+010C U+0152)
  0x01, 0x0E, 0x00, 0x2C, 0x02, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x02, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x3F, 0x02, // Ď? (U+010E U+003F)
  0x01, 0x0E, 0x00, 0x41, 0x02, // ĎA (U+010E U+0041)
  0x01, 0x0E, 0x00, 0x54, 0x02, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x00, 0x56, 0x02, // ĎV (U+010E U+0056)
  0x01, 0x0E, 0x00, 0x57, 0x02, // ĎW (U+010E U+0057)
  0x01, 0x0E, 0x00, 0x58, 0x02, // ĎX (U+010E U+0058)
  0x01, 0x0E, 0x00, 0x59, 0x03, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0xC0, 0x02, // ĎÀ (U+010E U+00C0)
  0x01, 0x0E, 0x00, 0xC1, 0x02, // ĎÁ (U+010E U+00C1)
  0x01, 0x0E, 0x00, 0xC2, 0x02, // ĎÂ (U+010E U+00C2)
  0x01, 0x0E, 0x00, 0xC3, 0x02, // ĎÃ (U+010E U+00C3)
  0x01, 0x0E, 0x00, 0xC4, 0x02, // ĎÄ (U+010E U+00C4)
  0x01, 0x0E, 0x00, 0xC5, 0x02, // ĎÅ (U+010E U+00C5)
  0x01, 0x0E, 0x00, 0xC6, 0x05, // ĎÆ (U+010E U+00C6)
  0x01, 0x0E, 0x00, 0xDD, 0x03, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x00, 0x02, // ĎĀ (U+010E U+0100)
  0x01, 0x0E, 0x01, 0x02, 0x02, // ĎĂ (U+010E U+0102)
  0x01, 0x0E, 0x01, 0x04, 0x02, // ĎĄ (U+010E U+0104)
  0x01, 0x0E, 0x01, 0x62, 0x02, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x02, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x02, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x01, 0x74, 0x02, // ĎŴ (U+010E U+0174)
  0x01, 0x0E, 0x01, 0x76, 0x03, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x03, // ĎŸ (U+010E U+0178)
  0x01, 0x0E, 0x20, 0x1A, 0x02, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x02, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x02, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x02, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x02, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x3F, 0x02, // Đ? (U+0110 U+003F)
  0x01, 0x10, 0x00, 0x41, 0x02, // ĐA (U+0110 U+0041)
  0x01, 0x10, 0x00, 0x54, 0x02, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x00, 0x56, 0x02, // ĐV (U+0110 U+0056)
  0x01, 0x10, 0x00, 0x57, 0x02, // ĐW (U+0110 U+0057)
  0x01, 0x10, 0x00, 0x58, 0x02, // ĐX (U+0110 U+0058)
  0x01, 0x10, 0x00, 0x59, 0x03, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0xC0, 0x02, // ĐÀ (U+0110 U+00C0)
  0x01, 0x10, 0x00, 0xC1, 0x02, // ĐÁ (U+0110 U+00C1)
  0x01, 0x10, 0x00, 0xC2, 0x02, // ĐÂ (U+0110 U+00C2)
  0x01, 0x10, 0x00, 0xC3, 0x02, // ĐÃ (U+0110 U+00C3)
  0x01, 0x10, 0x00, 0xC4, 0x02, // ĐÄ (U+0110 U+00C4)
  0x01, 0x10, 0x00, 0xC5, 0x02, // ĐÅ (U+0110 U+00C5)
  0x01, 0x10, 0x00, 0xC6, 0x05, // ĐÆ (U+0110 U+00C6)
  0x01, 0x10, 0x00, 0xDD, 0x03, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x00, 0x02, // ĐĀ (U+0110 U+0100)
  0x01, 0x10, 0x01, 0x02, 0x02, // ĐĂ (U+0110 U+0102)
  0x01, 0x10, 0x01, 0x04, 0x02, // ĐĄ (U+0110 U+0104)
  0x01, 0x10, 0x01, 0x62, 0x02, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x02, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x02, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x01, 0x74, 0x02, // ĐŴ (U+0110 U+0174)
  0x01, 0x10, 0x01, 0x76, 0x03, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x03, // ĐŸ (U+0110 U+0178)
  0x01, 0x10, 0x20, 0x1A, 0x02, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x02, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x02, // Đ… (U+0110 U+2026)
  0x01, 0x12, 0x00, 0x56, 0x02, // ĒV (U+0112 U+0056)
  0x01, 0x12, 0x00, 0x57, 0x02, // ĒW (U+0112 U+0057)
  0x01, 0x12, 0x00, 0x59, 0x02, // ĒY (U+0112 U+0059)
  0x01, 0x12, 0x00, 0xDD, 0x02, // ĒÝ (U+0112 U+00DD)
  0x01, 0x12, 0x01, 0x74, 0x02, // ĒŴ (U+0112 U+0174)
  0x01, 0x12, 0x01, 0x76, 0x02, // ĒŶ (U+0112 U+0176)
  0x01, 0x12, 0x01, 0x78, 0x02, // ĒŸ (U+0112 U+0178)
  0x01, 0x13, 0x00, 0x56, 0x04, // ēV (U+0113 U+0056)
  0x01, 0x13, 0x00, 0x57, 0x04, // ēW (U+0113 U+0057)
  0x01, 0x13, 0x00, 0x59, 0x04, // ēY (U+0113 U+0059)
  0x01, 0x13, 0x00, 0xDD, 0x04, // ēÝ (U+0113 U+00DD)
  0x01, 0x13, 0x01, 0x74, 0x04, // ēŴ (U+0113 U+0174)
  0x01, 0x13, 0x01, 0x76, 0x04, // ēŶ (U+0113 U+0176)
  0x01, 0x13, 0x01, 0x78, 0x04, // ēŸ (U+0113 U+0178)
  0x01, 0x14, 0x00, 0x56, 0x02, // ĔV (U+0114 U+0056)
  0x01, 0x14, 0x00, 0x57, 0x02, // ĔW (U+0114 U+0057)
  0x01, 0x14, 0x00, 0x59, 0x02, // ĔY (U+0114 U+0059)
  0x01, 0x14, 0x00, 0xDD, 0x02, // ĔÝ (U+0114 U+00DD)
  0x01, 0x14, 0x01, 0x74, 0x02, // ĔŴ (U+0114 U+0174)
  0x01, 0x14, 0x01, 0x76, 0x02, // ĔŶ (U+0114 U+0176)
  0x01, 0x14, 0x01, 0x78, 0x02, // ĔŸ (U+0114 U+0178)
  0x01, 0x15, 0x00, 0x56, 0x04, // ĕV (U+0115 U+0056)
  0x01, 0x15, 0x00, 0x57, 0x04, // ĕW (U+0115 U+0057)
  0x01, 0x15, 0x00, 0x59, 0x04, // ĕY (U+0115 U+0059)
  0x01, 0x15, 0x00, 0xDD, 0x04, // ĕÝ (U+0115 U+00DD)
  0x01, 0x15, 0x01, 0x74, 0x04, // ĕŴ (U+0115 U+0174)
  0x01, 0x15, 0x01, 0x76, 0x04, // ĕŶ (U+0115 U+0176)
  0x01, 0x15, 0x01, 0x78, 0x04, // ĕŸ (U+0115 U+0178)
  0x01, 0x16, 0x00, 0x56, 0x02, // ĖV (U+0116 U+0056)
  0x01, 0x16, 0x00, 0x57, 0x02, // ĖW (U+0116 U+0057)
  0x01, 0x16, 0x00, 0x59, 0x02, // ĖY (U+0116 U+0059)
  0x01, 0x16, 0x00, 0xDD, 0x02, // ĖÝ (U+0116 U+00DD)
  0x01, 0x16, 0x01, 0x74, 0x02, // ĖŴ (U+0116 U+0174)
  0x01, 0x16, 0x01, 0x76, 0x02, // ĖŶ (U+0116 U+0176)
  0x01, 0x16, 0x01, 0x78, 0x02, // ĖŸ (U+0116 U+0178)
  0x01, 0x17, 0x00, 0x56, 0x04, // ėV (U+0117 U+0056)
  0x01, 0x17, 0x00, 0x57, 0x04, // ėW (U+0117 U+0057)
  0x01, 0x17, 0x00, 0x59, 0x04, // ėY (U+0117 U+0059)
  0x01, 0x17, 0x00, 0xDD, 0x04, // ėÝ (U+0117 U+00DD)
  0x01, 0x17, 0x01, 0x74, 0x04, // ėŴ (U+0117 U+0174)
  0x01, 0x17, 0x01, 0x76, 0x04, // ėŶ (U+0117 U+0176)
  0x01, 0x17, 0x01, 0x78, 0x04, // ėŸ (U+0117 U+0178)
  0x01, 0x18, 0x00, 0x56, 0x02, // ĘV (U+0118 U+0056)
  0x01, 0x18, 0x00, 0x57, 0x02, // ĘW (U+0118 U+0057)
  0x01, 0x18, 0x00, 0x59, 0x02, // ĘY (U+0118 U+0059)
  0x01, 0x18, 0x00, 0xDD, 0x02, // ĘÝ (U+0118 U+00DD)
  0x01, 0x18, 0x01, 0x74, 0x02, // ĘŴ (U+0118 U+0174)
  0x01, 0x18, 0x01, 0x76, 0x02, // ĘŶ (U+0118 U+0176)
  0x01, 0x18, 0x01, 0x78, 0x02, // ĘŸ (U+0118 U+0178)
  0x01, 0x19, 0x00, 0x56, 0x04, // ęV (U+0119 U+0056)
  0x01, 0x19, 0x00, 0x57, 0x04, // ęW (U+0119 U+0057)
  0x01, 0x19, 0x00, 0x59, 0x04, // ęY (U+0119 U+0059)
  0x01, 0x19, 0x00, 0xDD, 0x04, // ęÝ (U+0119 U+00DD)
  0x01, 0x19, 0x01, 0x74, 0x04, // ęŴ (U+0119 U+0174)
  0x01, 0x19, 0x01, 0x76, 0x04, // ęŶ (U+0119 U+0176)
  0x01, 0x19, 0x01, 0x78, 0x04, // ęŸ (U+0119 U+0178)
  0x01, 0x1A, 0x00, 0x56, 0x02, // ĚV (U+011A U+0056)
  0x01, 0x1A, 0x00, 0x57, 0x02, // ĚW (U+011A U+0057)
  0x01, 0x1A, 0x00, 0x59, 0x02, // ĚY (U+011A U+0059)
  0x01, 0x1A, 0x00, 0xDD, 0x02, // ĚÝ (U+011A U+00DD)
  0x01, 0x1A, 0x01, 0x74, 0x02, // ĚŴ (U+011A U+0174)
  0x01, 0x1A, 0x01, 0x76, 0x02, // ĚŶ (U+011A U+0176)
  0x01, 0x1A, 0x01, 0x78, 0x02, // ĚŸ (U+011A U+0178)
  0x01, 0x1B, 0x00, 0x56, 0x04, // ěV (U+011B U+0056)
  0x01, 0x1B, 0x00, 0x57, 0x04, // ěW (U+011B U+0057)
  0x01, 0x1B, 0x00, 0x59, 0x04, // ěY (U+011B U+0059)
  0x01, 0x1B, 0x00, 0xDD, 0x04, // ěÝ (U+011B U+00DD)
  0x01, 0x1B, 0x01, 0x74, 0x04, // ěŴ (U+011B U+0174)
  0x01, 0x1B, 0x01, 0x76, 0x04, // ěŶ (U+011B U+0176)
  0x01, 0x1B, 0x01, 0x78, 0x04, // ěŸ (U+011B U+0178)
  0x01, 0x1C, 0x00, 0x3F, 0x02, // Ĝ? (U+011C U+003F)
  0x01, 0x1C, 0x00, 0x54, 0x02, // ĜT (U+011C U+0054)
  0x01, 0x1C, 0x00, 0x56, 0x02, // ĜV (U+011C U+0056)
  0x01, 0x1C, 0x00, 0x57, 0x02, // ĜW (U+011C U+0057)
  0x01, 0x1C, 0x00, 0x59, 0x02, // ĜY (U+011C U+0059)
  0x01, 0x1C, 0x00, 0xC6, 0x02, // ĜÆ (U+011C U+00C6)
  0x01, 0x1C, 0x00, 0xDD, 0x02, // ĜÝ (U+011C U+00DD)
  0x01, 0x1C, 0x01, 0x62, 0x02, // ĜŢ (U+011C U+0162)
  0x01, 0x1C, 0x01, 0x64, 0x02, // ĜŤ (U+011C U+0164)
  0x01, 0x1C, 0x01, 0x66, 0x02, // ĜŦ (U+011C U+0166)
  0x01, 0x1C, 0x01, 0x74, 0x02, // ĜŴ (U+011C U+0174)
  0x01, 0x1C, 0x01, 0x76, 0x02, // ĜŶ (U+011C U+0176)
  0x01, 0x1C, 0x01, 0x78, 0x02, // ĜŸ (U+011C U+0178)
  0x01, 0x1E, 0x00, 0x3F, 0x02, // Ğ? (U+011E U+003F)
  0x01, 0x1E, 0x00, 0x54, 0x02, // ĞT (U+011E U+0054)
  0x01, 0x1E, 0x00, 0x56, 0x02, // ĞV (U+011E U+0056)
  0x01, 0x1E, 0x00, 0x57, 0x02, // ĞW (U+011E U+0057)
  0x01, 0x1E, 0x00, 0x59, 0x02, // ĞY (U+011E U+0059)
  0x01, 0x1E, 0x00, 0xC6, 0x02, // ĞÆ (U+011E U+00C6)
  0x01, 0x1E, 0x00, 0xDD, 0x02, // ĞÝ (U+011E U+00DD)
  0x01, 0x1E, 0x01, 0x62, 0x02, // ĞŢ (U+011E U+0162)
  0x01, 0x1E, 0x01, 0x64, 0x02, // ĞŤ (U+011E U+0164)
  0x01, 0x1E, 0x01, 0x66, 0x02, // ĞŦ (U+011E U+0166)
  0x01, 0x1E, 0x01, 0x74, 0x02, // ĞŴ (U+011E U+0174)
  0x01, 0x1E, 0x01, 0x76, 0x02, // ĞŶ (U+011E U+0176)
  0x01, 0x1E, 0x01, 0x78, 0x02, // ĞŸ (U+011E U+0178)
  0x01, 0x20, 0x00, 0x3F, 0x02, // Ġ? (U+0120 U+003F)
  0x01, 0x20, 0x00, 0x54, 0x02, // ĠT (U+0120 U+0054)
  0x01, 0x20, 0x00, 0x56, 0x02, // ĠV (U+0120 U+0056)
  0x01, 0x20, 0x00, 0x57, 0x02, // ĠW (U+0120 U+0057)
  0x01, 0x20, 0x00, 0x59, 0x02, // ĠY (U+0120 U+0059)
  0x01, 0x20, 0x00, 0xC6, 0x02, // ĠÆ (U+0120 U+00C6)
  0x01, 0x20, 0x00, 0xDD, 0x02, // ĠÝ (U+0120 U+00DD)
  0x01, 0x20, 0x01, 0x62, 0x02, // ĠŢ (U+0120 U+0162)
  0x01, 0x20, 0x01, 0x64, 0x02, // ĠŤ (U+0120 U+0164)
  0x01, 0x20, 0x01, 0x66, 0x02, // ĠŦ (U+0120 U+0166)
  0x01, 0x20, 0x01, 0x74, 0x02, // ĠŴ (U+0120 U+0174)
  0x01, 0x20, 0x01, 0x76, 0x02, // ĠŶ (U+0120 U+0176)
  0x01, 0x20, 0x01, 0x78, 0x02, // ĠŸ (U+0120 U+0178)
  0x01, 0x22, 0x00, 0x3F, 0x02, // Ģ? (U+0122 U+003F)
  0x01, 0x22, 0x00, 0x54, 0x02, // ĢT (U+0122 U+0054)
  0x01, 0x22, 0x00, 0x56, 0x02, // ĢV (U+0122 U+0056)
  0x01, 0x22, 0x00, 0x57, 0x02, // ĢW (U+0122 U+0057)
  0x01, 0x22, 0x00, 0x59, 0x02, // ĢY (U+0122 U+0059)
  0x01, 0x22, 0x00, 0xC6, 0x02, // ĢÆ (U+0122 U+00C6)
  0x01, 0x22, 0x00, 0xDD, 0x02, // ĢÝ (U+0122 U+00DD)
  0x01, 0x22, 0x01, 0x62, 0x02, // ĢŢ (U+0122 U+0162)
  0x01, 0x22, 0x01, 0x64, 0x02, // ĢŤ (U+0122 U+0164)
  0x01, 0x22, 0x01, 0x66, 0x02, // ĢŦ (U+0122 U+0166)
  0x01, 0x22, 0x01, 0x74, 0x02, // ĢŴ (U+0122 U+0174)
  0x01, 0x22, 0x01, 0x76, 0x02, // ĢŶ (U+0122 U+0176)
  0x01, 0x22, 0x01, 0x78, 0x02, // ĢŸ (U+0122 U+0178)
  0x01, 0x25, 0x00, 0x22, 0x04, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x04, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x00, 0x3F, 0x02, // ĥ? (U+0125 U+003F)
  0x01, 0x25, 0x00, 0x54, 0x02, // ĥT (U+0125 U+0054)
  0x01, 0x25, 0x00, 0x56, 0x03, // ĥV (U+0125 U+0056)
  0x01, 0x25, 0x00, 0x57, 0x03, // ĥW (U+0125 U+0057)
  0x01, 0x25, 0x00, 0x59, 0x03, // ĥY (U+0125 U+0059)
  0x01, 0x25, 0x00, 0x79, 0x02, // ĥy (U+0125 U+0079)
  0x01, 0x25, 0x00, 0xDD, 0x03, // ĥÝ (U+0125 U+00DD)
  0x01, 0x25, 0x00, 0xFD, 0x02, // ĥý (U+0125 U+00FD)
  0x01, 0x25, 0x00, 0xFF, 0x02, // ĥÿ (U+0125 U+00FF)
  0x01, 0x25, 0x01, 0x62, 0x02, // ĥŢ (U+0125 U+0162)
  0x01, 0x25, 0x01, 0x64, 0x02, // ĥŤ (U+0125 U+0164)
  0x01, 0x25, 0x01, 0x66, 0x02, // ĥŦ (U+0125 U+0166)
  0x01, 0x25, 0x01, 0x74, 0x03, // ĥŴ (U+0125 U+0174)
  0x01, 0x25, 0x01, 0x76, 0x03, // ĥŶ (U+0125 U+0176)
  0x01, 0x25, 0x01, 0x77, 0x02, // ĥŷ (U+0125 U+0177)
  0x01, 0x25, 0x01, 0x78, 0x03, // ĥŸ (U+0125 U+0178)
  0x01, 0x27, 0x00, 0x22, 0x04, // ħ" (U+0127 U+0022)
  0x01, 0x27, 0x00, 0x27, 0x04, // ħ' (U+0127 U+0027)
  0x01, 0x27, 0x00, 0x3F, 0x02, // ħ? (U+0127 U+003F)
  0x01, 0x27, 0x00, 0x54, 0x02, // ħT (U+0127 U+0054)
  0x01, 0x27, 0x00, 0x56, 0x03, // ħV (U+0127 U+0056)
  0x01, 0x27, 0x00, 0x57, 0x03, // ħW (U+0127 U+0057)
  0x01, 0x27, 0x00, 0x59, 0x03, // ħY (U+0127 U+0059)
  0x01, 0x27, 0x00, 0x79, 0x02, // ħy (U+0127 U+0079)
  0x01, 0x27, 0x00, 0xDD, 0x03, // ħÝ (U+0127 U+00DD)
  0x01, 0x27, 0x00, 0xFD, 0x02, // ħý (U+0127 U+00FD)
  0x01, 0x27, 0x00, 0xFF, 0x02, // ħÿ (U+0127 U+00FF)
  0x01, 0x27, 0x01, 0x62, 0x02, // ħŢ (U+0127 U+0162)
  0x01, 0x27, 0x01, 0x64, 0x02, // ħŤ (U+0127 U+0164)
  0x01, 0x27, 0x01, 0x66, 0x02, // ħŦ (U+0127 U+0166)
  0x01, 0x27, 0x01, 0x74, 0x03, // ħŴ (U+0127 U+0174)
  0x01, 0x27, 0x01, 0x76, 0x03, // ħŶ (U+0127 U+0176)
  0x01, 0x27, 0x01, 0x77, 0x02, // ħŷ (U+0127 U+0177)
  0x01, 0x27, 0x01, 0x78, 0x03, // ħŸ (U+0127 U+0178)
  0x01, 0x36, 0x00, 0x43, 0x02, // ĶC (U+0136 U+0043)
  0x01, 0x36, 0x00, 0x47, 0x02, // ĶG (U+0136 U+0047)
  0x01, 0x36, 0x00, 0x4F, 0x02, // ĶO (U+0136 U+004F)
  0x01, 0x36, 0x00, 0x51, 0x02, // ĶQ (U+0136 U+0051)
  0x01, 0x36, 0x00, 0x63, 0x02, // Ķc (U+0136 U+0063)
  0x01, 0x36, 0x00, 0x64, 0x02, // Ķd (U+0136 U+0064)
  0x01, 0x36, 0x00, 0x65, 0x02, // Ķe (U+0136 U+0065)
  0x01, 0x36, 0x00, 0x67, 0x02, // Ķg (U+0136 U+0067)
  0x01, 0x36, 0x00, 0x6F, 0x02, // Ķo (U+0136 U+006F)
  0x01, 0x36, 0x00, 0x71, 0x02, // Ķq (U+0136 U+0071)
  0x01, 0x36, 0x00, 0x75, 0x02, // Ķu (U+0136 U+0075)
  0x01, 0x36, 0x00, 0x77, 0x03, // Ķw (U+0136 U+0077)
  0x01, 0x36, 0x00, 0x79, 0x03, // Ķy (U+0136 U+0079)
  0x01, 0x36, 0x00, 0xC7, 0x02, // ĶÇ (U+0136 U+00C7)
  0x01, 0x36, 0x00, 0xD2, 0x02, // ĶÒ (U+0136 U+00D2)
  0x01, 0x36, 0x00, 0xD3, 0x02, // ĶÓ (U+0136 U+00D3)
  0x01, 0x36, 0x00, 0xD4, 0x02, // ĶÔ (U+0136 U+00D4)
  0x01, 0x36, 0x00, 0xD5, 0x02, // ĶÕ (U+0136 U+00D5)
  0x01, 0x36, 0x00, 0xD6, 0x02, // ĶÖ (U+0136 U+00D6)
  0x01, 0x36, 0x00, 0xD8, 0x02, // ĶØ (U+0136 U+00D8)
  0x01, 0x36, 0x00, 0xE7, 0x02, // Ķç (U+0136 U+00E7)
  0x01, 0x36, 0x00, 0xE8, 0x02, // Ķè (U+0136 U+00E8)
  0x01, 0x36, 0x00, 0xE9, 0x02, // Ķé (U+0136 U+00E9)
  0x01, 0x36, 0x00, 0xEA, 0x02, // Ķê (U+0136 U+00EA)
  0x01, 0x36, 0x00, 0xEB, 0x02, // Ķë (U+0136 U+00EB)
  0x01, 0x36, 0x00, 0xF0, 0x02, // Ķð (U+0136 U+00F0)
  0x01, 0x36, 0x00, 0xF2, 0x02, // Ķò (U+0136 U+00F2)
  0x01, 0x36, 0x00, 0xF3, 0x02, // Ķó (U+0136 U+00F3)
  0x01, 0x36, 0x00, 0xF4, 0x02, // Ķô (U+0136 U+00F4)
  0x01, 0x36, 0x00, 0xF5, 0x02, // Ķõ (U+0136 U+00F5)
  0x01, 0x36, 0x00, 0xF6, 0x02, // Ķö (U+0136 U+00F6)
  0x01, 0x36, 0x00, 0xF8, 0x02, // Ķø (U+0136 U+00F8)
  0x01, 0x36, 0x00, 0xF9, 0x02, // Ķù (U+0136 U+00F9)
  0x01, 0x36, 0x00, 0xFA, 0x02, // Ķú (U+0136 U+00FA)
  0x01, 0x36, 0x00, 0xFB, 0x02, // Ķû (U+0136 U+00FB)
  0x01, 0x36, 0x00, 0xFC, 0x02, // Ķü (U+0136 U+00FC)
  0x01, 0x36, 0x00, 0xFD, 0x03, // Ķý (U+0136 U+00FD)
  0x01, 0x36, 0x00, 0xFF, 0x03, // Ķÿ (U+0136 U+00FF)
  0x01, 0x36, 0x01, 0x06, 0x02, // ĶĆ (U+0136 U+0106)
  0x01, 0x36, 0x01, 0x07, 0x02, // Ķć (U+0136 U+0107)
  0x01, 0x36, 0x01, 0x08, 0x02, // ĶĈ (U+0136 U+0108)
  0x01, 0x36, 0x01, 0x09, 0x02, // Ķĉ (U+0136 U+0109)
  0x01, 0x36, 0x01, 0x0A, 0x02, // ĶĊ (U+0136 U+010A)
  0x01, 0x36, 0x01, 0x0B, 0x02, // Ķċ (U+0136 U+010B)
  0x01, 0x36, 0x01, 0x0C, 0x02, // ĶČ (U+0136 U+010C)
  0x01, 0x36, 0x01, 0x0D, 0x02, // Ķč (U+0136 U+010D)
  0x01, 0x36, 0x01, 0x0F, 0x02, // Ķď (U+0136 U+010F)
  0x01, 0x36, 0x01, 0x11, 0x02, // Ķđ (U+0136 U+0111)
  0x01, 0x36, 0x01, 0x13, 0x02, // Ķē (U+0136 U+0113)
  0x01, 0x36, 0x01, 0x15, 0x02, // Ķĕ (U+0136 U+0115)
  0x01, 0x36, 0x01, 0x17, 0x02, // Ķė (U+0136 U+0117)
  0x01, 0x36, 0x01, 0x19, 0x02, // Ķę (U+0136 U+0119)
  0x01, 0x36, 0x01, 0x1B, 0x02, // Ķě (U+0136 U+011B)
  0x01, 0x36, 0x01, 0x1C, 0x02, // ĶĜ (U+0136 U+011C)
  0x01, 0x36, 0x01, 0x1D, 0x02, // Ķĝ (U+0136 U+011D)
  0x01, 0x36, 0x01, 0x1E, 0x02, // ĶĞ (U+0136 U+011E)
  0x01, 0x36, 0x01, 0x1F, 0x02, // Ķğ (U+0136 U+011F)
  0x01, 0x36, 0x01, 0x20, 0x02, // ĶĠ (U+0136 U+0120)
  0x01, 0x36, 0x01, 0x21, 0x02, // Ķġ (U+0136 U+0121)
  0x01, 0x36, 0x01, 0x22, 0x02, // ĶĢ (U+0136 U+0122)
  0x01, 0x36, 0x01, 0x23, 0x02, // Ķģ (U+0136 U+0123)
  0x01, 0x36, 0x01, 0x4C, 0x02, // ĶŌ (U+0136 U+014C)
  0x01, 0x36, 0x01, 0x4D, 0x02, // Ķō (U+0136 U+014D)
  0x01, 0x36, 0x01, 0x4E, 0x02, // ĶŎ (U+0136 U+014E)
  0x01, 0x36, 0x01, 0x4F, 0x02, // Ķŏ (U+0136 U+014F)
  0x01, 0x36, 0x01, 0x50, 0x02, // ĶŐ (U+0136 U+0150)
  0x01, 0x36, 0x01, 0x51, 0x02, // Ķő (U+0136 U+0151)
  0x01, 0x36, 0x01, 0x52, 0x02, // ĶŒ (U+0136 U+0152)
  0x01, 0x36, 0x01, 0x53, 0x02, // Ķœ (U+0136 U+0153)
  0x01, 0x36, 0x01, 0x69, 0x02, // Ķũ (U+0136 U+0169)
  0x01, 0x36, 0x01, 0x6B, 0x02, // Ķū (U+0136 U+016B)
  0x01, 0x36, 0x01, 0x6D, 0x02, // Ķŭ (U+0136 U+016D)
  0x01, 0x36, 0x01, 0x6F, 0x02, // Ķů (U+0136 U+016F)
  0x01, 0x36, 0x01, 0x71, 0x02, // Ķű (U+0136 U+0171)
  0x01, 0x36, 0x01, 0x73, 0x02, // Ķų (U+0136 U+0173)
  0x01, 0x36, 0x01, 0x75, 0x03, // Ķŵ (U+0136 U+0175)
  0x01, 0x36, 0x01, 0x77, 0x03, // Ķŷ (U+0136 U+0177)
  0x01, 0x37, 0x00, 0x63, 0x01, // ķc (U+0137 U+0063)
  0x01, 0x37, 0x00, 0x64, 0x01, // ķd (U+0137 U+0064)
  0x01, 0x37, 0x00, 0x65, 0x01, // ķe (U+0137 U+0065)
  0x01, 0x37, 0x00, 0x67, 0x01, // ķg (U+0137 U+0067)
  0x01, 0x37, 0x00, 0x6F, 0x01, // ķo (U+0137 U+006F)
  0x01, 0x37, 0x00, 0x71, 0x01, // ķq (U+0137 U+0071)
  0x01, 0x37, 0x00, 0xE7, 0x01, // ķç (U+0137 U+00E7)
  0x01, 0x37, 0x00, 0xE8, 0x01, // ķè (U+0137 U+00E8)
  0x01, 0x37, 0x00, 0xE9, 0x01, // ķé (U+0137 U+00E9)
  0x01, 0x37, 0x00, 0xEA, 0x01, // ķê (U+0137 U+00EA)
  0x01, 0x37, 0x00, 0xEB, 0x01, // ķë (U+0137 U+00EB)
  0x01, 0x37, 0x00, 0xF0, 0x01, // ķð (U+0137 U+00F0)
  0x01, 0x37, 0x00, 0xF2, 0x01, // ķò (U+0137 U+00F2)
  0x01, 0x37, 0x00, 0xF3, 0x01, // ķó (U+0137 U+00F3)
  0x01, 0x37, 0x00, 0xF4, 0x01, // ķô (U+0137 U+00F4)
  0x01, 0x37, 0x00, 0xF5, 0x01, // ķõ (U+0137 U+00F5)
  0x01, 0x37, 0x00, 0xF6, 0x01, // ķö (U+0137 U+00F6)
  0x01, 0x37, 0x00, 0xF8, 0x01, // ķø (U+0137 U+00F8)
  0x01, 0x37, 0x01, 0x07, 0x01, // ķć (U+0137 U+0107)
  0x01, 0x37, 0x01, 0x09, 0x01, // ķĉ (U+0137 U+0109)
  0x01, 0x37, 0x01, 0x0B, 0x01, // ķċ (U+0137 U+010B)
  0x01, 0x37, 0x01, 0x0D, 0x01, // ķč (U+0137 U+010D)
  0x01, 0x37, 0x01, 0x0F, 0x01, // ķď (U+0137 U+010F)
  0x01, 0x37, 0x01, 0x11, 0x01, // ķđ (U+0137 U+0111)
  0x01, 0x37, 0x01, 0x13, 0x01, // ķē (U+0137 U+0113)
  0x01, 0x37, 0x01, 0x15, 0x01, // ķĕ (U+0137 U+0115)
  0x01, 0x37, 0x01, 0x17, 0x01, // ķė (U+0137 U+0117)
  0x01, 0x37, 0x01, 0x19, 0x01, // ķę (U+0137 U+0119)
  0x01, 0x37, 0x01, 0x1B, 0x01, // ķě (U+0137 U+011B)
  0x01, 0x37, 0x01, 0x1D, 0x01, // ķĝ (U+0137 U+011D)
  0x01, 0x37, 0x01, 0x1F, 0x01, // ķğ (U+0137 U+011F)
  0x01, 0x37, 0x01, 0x21, 0x01, // ķġ (U+0137 U+0121)
  0x01, 0x37, 0x01, 0x23, 0x01, // ķģ (U+0137 U+0123)
  0x01, 0x37, 0x01, 0x4D, 0x01, // ķō (U+0137 U+014D)
  0x01, 0x37, 0x01, 0x4F, 0x01, // ķŏ (U+0137 U+014F)
  0x01, 0x37, 0x01, 0x51, 0x01, // ķő (U+0137 U+0151)
  0x01, 0x37, 0x01, 0x53, 0x01, // ķœ (U+0137 U+0153)
  0x01, 0x38, 0x00, 0x63, 0x01, // ĸc (U+0138 U+0063)
  0x01, 0x38, 0x00, 0x64, 0x01, // ĸd (U+0138 U+0064)
  0x01, 0x38, 0x00, 0x65, 0x01, // ĸe (U+0138 U+0065)
  0x01, 0x38, 0x00, 0x67, 0x01, // ĸg (U+0138 U+0067)
  0x01, 0x38, 0x00, 0x6F, 0x01, // ĸo (U+0138 U+006F)
  0x01, 0x38, 0x00, 0x71, 0x01, // ĸq (U+0138 U+0071)
  0x01, 0x38, 0x00, 0xE7, 0x01, // ĸç (U+0138 U+00E7)
  0x01, 0x38, 0x00, 0xE8, 0x01, // ĸè (U+0138 U+00E8)
  0x01, 0x38, 0x00, 0xE9, 0x01, // ĸé (U+0138 U+00E9)
  0x01, 0x38, 0x00, 0xEA, 0x01, // ĸê (U+0138 U+00EA)
  0x01, 0x38, 0x00, 0xEB, 0x01, // ĸë (U+0138 U+00EB)
  0x01, 0x38, 0x00, 0xF0, 0x01, // ĸð (U+0138 U+00F0)
  0x01, 0x38, 0x00, 0xF2, 0x01, // ĸò (U+0138 U+00F2)
  0x01, 0x38, 0x00, 0xF3, 0x01, // ĸó (U+0138 U+00F3)
  0x01, 0x38, 0x00, 0xF4, 0x01, // ĸô (U+0138 U+00F4)
  0x01, 0x38, 0x00, 0xF5, 0x01, // ĸõ (U+0138 U+00F5)
  0x01, 0x38, 0x00, 0xF6, 0x01, // ĸö (U+0138 U+00F6)
  0x01, 0x38, 0x00, 0xF8, 0x01, // ĸø (U+0138 U+00F8)
  0x01, 0x38, 0x01, 0x07, 0x01, // ĸć (U+0138 U+0107)
  0x01, 0x38, 0x01, 0x09, 0x01, // ĸĉ (U+0138 U+0109)
  0x01, 0x38, 0x01, 0x0B, 0x01, // ĸċ (U+0138 U+010B)
  0x01, 0x38, 0x01, 0x0D, 0x01, // ĸč (U+0138 U+010D)
  0x01, 0x38, 0x01, 0x0F, 0x01, // ĸď (U+0138 U+010F)
  0x01, 0x38, 0x01, 0x11, 0x01, // ĸđ (U+0138 U+0111)
  0x01, 0x38, 0x01, 0x13, 0x01, // ĸē (U+0138 U+0113)
  0x01, 0x38, 0x01, 0x15, 0x01, // ĸĕ (U+0138 U+0115)
  0x01, 0x38, 0x01, 0x17, 0x01, // ĸė (U+0138 U+0117)
  0x01, 0x38, 0x01, 0x19, 0x01, // ĸę (U+0138 U+0119)
  0x01, 0x38, 0x01, 0x1B, 0x01, // ĸě (U+0138 U+011B)
  0x01, 0x38, 0x01, 0x1D, 0x01, // ĸĝ (U+0138 U+011D)
  0x01, 0x38, 0x01, 0x1F, 0x01, // ĸğ (U+0138 U+011F)
  0x01, 0x38, 0x01, 0x21, 0x01, // ĸġ (U+0138 U+0121)
  0x01, 0x38, 0x01, 0x23, 0x01, // ĸģ (U+0138 U+0123)
  0x01, 0x38, 0x01, 0x4D, 0x01, // ĸō (U+0138 U+014D)
  0x01, 0x38, 0x01, 0x4F, 0x01, // ĸŏ (U+0138 U+014F)
  0x01, 0x38, 0x01, 0x51, 0x01, // ĸő (U+0138 U+0151)
  0x01, 0x38, 0x01, 0x53, 0x01, // ĸœ (U+0138 U+0153)
  0x01, 0x39, 0x00, 0x22, 0x07, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x07, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x2A, 0x07, // Ĺ* (U+0139 U+002A)
  0x01, 0x39, 0x00, 0x3F, 0x06, // Ĺ? (U+0139 U+003F)
  0x01, 0x39, 0x00, 0x54, 0x06, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x05, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x05, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x05, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0x76, 0x02, // Ĺv (U+0139 U+0076)
  0x01, 0x39, 0x00, 0x77, 0x01, // Ĺw (U+0139 U+0077)
  0x01, 0x39, 0x00, 0x79, 0x03, // Ĺy (U+0139 U+0079)
  0x01, 0x39, 0x00, 0xB7, 0x02, // Ĺ· (U+0139 U+00B7)
  0x01, 0x39, 0x00, 0xDD, 0x05, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x00, 0xFD, 0x03, // Ĺý (U+0139 U+00FD)
  0x01, 0x39, 0x00, 0xFF, 0x03, // Ĺÿ (U+0139 U+00FF)
  0x01, 0x39, 0x01, 0x62, 0x06, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x06, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x06, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x05, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x75, 0x01, // Ĺŵ (U+0139 U+0175)
  0x01, 0x39, 0x01, 0x76, 0x05, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x77, 0x03, // Ĺŷ (U+0139 U+0177)
  0x01, 0x39, 0x01, 0x78, 0x05, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x18, 0x07, // Ĺ‘ (U+0139 U+2018)
  0x01, 0x39, 0x20, 0x19, 0x07, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1C, 0x07, // Ĺ“ (U+0139 U+201C)
  0x01, 0x39, 0x20, 0x1D, 0x07, // Ĺ” (U+0139 U+201D)
  0x01, 0x39, 0x21, 0x22, 0x07, // Ĺ™ (U+0139 U+2122)
  0x01, 0x3B, 0x00, 0x22, 0x07, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x07, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x2A, 0x07, // Ļ* (U+013B U+002A)
  0x01, 0x3B, 0x00, 0x3F, 0x06, // Ļ? (U+013B U+003F)
  0x01, 0x3B, 0x00, 0x54, 0x06, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x05, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x05, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x05, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0x76, 0x02, // Ļv (U+013B U+0076)
  0x01, 0x3B, 0x00, 0x77, 0x01, // Ļw (U+013B U+0077)
  0x01, 0x3B, 0x00, 0x79, 0x03, // Ļy (U+013B U+0079)
  0x01, 0x3B, 0x00, 0xB7, 0x02, // Ļ· (U+013B U+00B7)
  0x01, 0x3B, 0x00, 0xDD, 0x05, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x00, 0xFD, 0x03, // Ļý (U+013B U+00FD)
  0x01, 0x3B, 0x00, 0xFF, 0x03, // Ļÿ (U+013B U+00FF)
  0x01, 0x3B, 0x01, 0x62, 0x06, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x06, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x06, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x05, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x75, 0x01, // Ļŵ (U+013B U+0175)
  0x01, 0x3B, 0x01, 0x76, 0x05, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x77, 0x03, // Ļŷ (U+013B U+0177)
  0x01, 0x3B, 0x01, 0x78, 0x05, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x18, 0x07, // Ļ‘ (U+013B U+2018)
  0x01, 0x3B, 0x20, 0x19, 0x07, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1C, 0x07, // Ļ“ (U+013B U+201C)
  0x01, 0x3B, 0x20, 0x1D, 0x07, // Ļ” (U+013B U+201D)
  0x01, 0x3B, 0x21, 0x22, 0x07, // Ļ™ (U+013B U+2122)
  0x01, 0x41, 0x00, 0x22, 0x07, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x07, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x2A, 0x07, // Ł* (U+0141 U+002A)
  0x01, 0x41, 0x00, 0x3F, 0x06, // Ł? (U+0141 U+003F)
  0x01, 0x41, 0x00, 0x54, 0x06, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x05, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x05, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x05, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0x76, 0x02, // Łv (U+0141 U+0076)
  0x01, 0x41, 0x00, 0x77, 0x01, // Łw (U+0141 U+0077)
  0x01, 0x41, 0x00, 0x79, 0x03, // Ły (U+0141 U+0079)
  0x01, 0x41, 0x00, 0xB7, 0x02, // Ł· (U+0141 U+00B7)
  0x01, 0x41, 0x00, 0xDD, 0x05, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x00, 0xFD, 0x03, // Łý (U+0141 U+00FD)
  0x01, 0x41, 0x00, 0xFF, 0x03, // Łÿ (U+0141 U+00FF)
  0x01, 0x41, 0x01, 0x62, 0x06, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x06, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x06, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x05, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x75, 0x01, // Łŵ (U+0141 U+0175)
  0x01, 0x41, 0x01, 0x76, 0x05, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x77, 0x03, // Łŷ (U+0141 U+0177)
  0x01, 0x41, 0x01, 0x78, 0x05, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x18, 0x07, // Ł‘ (U+0141 U+2018)
  0x01, 0x41, 0x20, 0x19, 0x07, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1C, 0x07, // Ł“ (U+0141 U+201C)
  0x01, 0x41, 0x20, 0x1D, 0x07, // Ł” (U+0141 U+201D)
  0x01, 0x41, 0x21, 0x22, 0x07, // Ł™ (U+0141 U+2122)
  0x01, 0x43, 0x00, 0x41, 0x01, // ŃA (U+0143 U+0041)
  0x01, 0x43, 0x00, 0xAB, 0x01, // Ń« (U+0143 U+00AB)
  0x01, 0x43, 0x00, 0xBB, 0x01, // Ń» (U+0143 U+00BB)
  0x01, 0x43, 0x00, 0xC0, 0x01, // ŃÀ (U+0143 U+00C0)
  0x01, 0x43, 0x00, 0xC1, 0x01, // ŃÁ (U+0143 U+00C1)
  0x01, 0x43, 0x00, 0xC2, 0x01, // ŃÂ (U+0143 U+00C2)
  0x01, 0x43, 0x00, 0xC3, 0x01, // ŃÃ (U+0143 U+00C3)
  0x01, 0x43, 0x00, 0xC4, 0x01, // ŃÄ (U+0143 U+00C4)
  0x01, 0x43, 0x00, 0xC5, 0x01, // ŃÅ (U+0143 U+00C5)
  0x01, 0x43, 0x01, 0x00, 0x01, // ŃĀ (U+0143 U+0100)
  0x01, 0x43, 0x01, 0x02, 0x01, // ŃĂ (U+0143 U+0102)
  0x01, 0x43, 0x01, 0x04, 0x01, // ŃĄ (U+0143 U+0104)
  0x01, 0x43, 0x20, 0x39, 0x01, // Ń‹ (U+0143 U+2039)
  0x01, 0x43, 0x20, 0x3A, 0x01, // Ń› (U+0143 U+203A)
  0x01, 0x44, 0x00, 0x22, 0x04, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x04, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x00, 0x3F, 0x02, // ń? (U+0144 U+003F)
  0x01, 0x44, 0x00, 0x54, 0x02, // ńT (U+0144 U+0054)
  0x01, 0x44, 0x00, 0x56, 0x03, // ńV (U+0144 U+0056)
  0x01, 0x44, 0x00, 0x57, 0x03, // ńW (U+0144 U+0057)
  0x01, 0x44, 0x00, 0x59, 0x03, // ńY (U+0144 U+0059)
  0x01, 0x44, 0x00, 0x79, 0x02, // ńy (U+0144 U+0079)
  0x01, 0x44, 0x00, 0xDD, 0x03, // ńÝ (U+0144 U+00DD)
  0x01, 0x44, 0x00, 0xFD, 0x02, // ńý (U+0144 U+00FD)
  0x01, 0x44, 0x00, 0xFF, 0x02, // ńÿ (U+0144 U+00FF)
  0x01, 0x44, 0x01, 0x62, 0x02, // ńŢ (U+0144 U+0162)
  0x01, 0x44, 0x01, 0x64, 0x02, // ńŤ (U+0144 U+0164)
  0x01, 0x44, 0x01, 0x66, 0x02, // ńŦ (U+0144 U+0166)
  0x01, 0x44, 0x01, 0x74, 0x03, // ńŴ (U+0144 U+0174)
  0x01, 0x44, 0x01, 0x76, 0x03, // ńŶ (U+0144 U+0176)
  0x01, 0x44, 0x01, 0x77, 0x02, // ńŷ (U+0144 U+0177)
  0x01, 0x44, 0x01, 0x78, 0x03, // ńŸ (U+0144 U+0178)
  0x01, 0x45, 0x00, 0x41, 0x01, // ŅA (U+0145 U+0041)
  0x01, 0x45, 0x00, 0xAB, 0x01, // Ņ« (U+0145 U+00AB)
  0x01, 0x45, 0x00, 0xBB, 0x01, // Ņ» (U+0145 U+00BB)
  0x01, 0x45, 0x00, 0xC0, 0x01, // ŅÀ (U+0145 U+00C0)
  0x01, 0x45, 0x00, 0xC1, 0x01, // ŅÁ (U+0145 U+00C1)
  0x01, 0x45, 0x00, 0xC2, 0x01, // ŅÂ (U+0145 U+00C2)
  0x01, 0x45, 0x00, 0xC3, 0x01, // ŅÃ (U+0145 U+00C3)
  0x01, 0x45, 0x00, 0xC4, 0x01, // ŅÄ (U+0145 U+00C4)
  0x01, 0x45, 0x00, 0xC5, 0x01, // ŅÅ (U+0145 U+00C5)
  0x01, 0x45, 0x01, 0x00, 0x01, // ŅĀ (U+0145 U+0100)
  0x01, 0x45, 0x01, 0x02, 0x01, // ŅĂ (U+0145 U+0102)
  0x01, 0x45, 0x01, 0x04, 0x01, // ŅĄ (U+0145 U+0104)
  0x01, 0x45, 0x20, 0x39, 0x01, // Ņ‹ (U+0145 U+2039)
  0x01, 0x45, 0x20, 0x3A, 0x01, // Ņ› (U+0145 U+203A)
  0x01, 0x46, 0x00, 0x22, 0x04, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x04, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x00, 0x3F, 0x02, // ņ? (U+0146 U+003F)
  0x01, 0x46, 0x00, 0x54, 0x02, // ņT (U+0146 U+0054)
  0x01, 0x46, 0x00, 0x56, 0x03, // ņV (U+0146 U+0056)
  0x01, 0x46, 0x00, 0x57, 0x03, // ņW (U+0146 U+0057)
  0x01, 0x46, 0x00, 0x59, 0x03, // ņY (U+0146 U+0059)
  0x01, 0x46, 0x00, 0x79, 0x02, // ņy (U+0146 U+0079)
  0x01, 0x46, 0x00, 0xDD, 0x03, // ņÝ (U+0146 U+00DD)
  0x01, 0x46, 0x00, 0xFD, 0x02, // ņý (U+0146 U+00FD)
  0x01, 0x46, 0x00, 0xFF, 0x02, // ņÿ (U+0146 U+00FF)
  0x01, 0x46, 0x01, 0x62, 0x02, // ņŢ (U+0146 U+0162)
  0x01, 0x46, 0x01, 0x64, 0x02, // ņŤ (U+0146 U+0164)
  0x01, 0x46, 0x01, 0x66, 0x02, // ņŦ (U+0146 U+0166)
  0x01, 0x46, 0x01, 0x74, 0x03, // ņŴ (U+0146 U+0174)
  0x01, 0x46, 0x01, 0x76, 0x03, // ņŶ (U+0146 U+0176)
  0x01, 0x46, 0x01, 0x77, 0x02, // ņŷ (U+0146 U+0177)
  0x01, 0x46, 0x01, 0x78, 0x03, // ņŸ (U+0146 U+0178)
  0x01, 0x47, 0x00, 0x41, 0x01, // ŇA (U+0147 U+0041)
  0x01, 0x47, 0x00, 0xAB, 0x01, // Ň« (U+0147 U+00AB)
  0x01, 0x47, 0x00, 0xBB, 0x01, // Ň» (U+0147 U+00BB)
  0x01, 0x47, 0x00, 0xC0, 0x01, // ŇÀ (U+0147 U+00C0)
  0x01, 0x47, 0x00, 0xC1, 0x01, // ŇÁ (U+0147 U+00C1)
  0x01, 0x47, 0x00, 0xC2, 0x01, // ŇÂ (U+0147 U+00C2)
  0x01, 0x47, 0x00, 0xC3, 0x01, // ŇÃ (U+0147 U+00C3)
  0x01, 0x47, 0x00, 0xC4, 0x01, // ŇÄ (U+0147 U+00C4)
  0x01, 0x47, 0x00, 0xC5, 0x01, // ŇÅ (U+0147 U+00C5)
  0x01, 0x47, 0x01, 0x00, 0x01, // ŇĀ (U+0147 U+0100)
  0x01, 0x47, 0x01, 0x02, 0x01, // ŇĂ (U+0147 U+0102)
  0x01, 0x47, 0x01, 0x04, 0x01, // ŇĄ (U+0147 U+0104)
  0x01, 0x47, 0x20, 0x39, 0x01, // Ň‹ (U+0147 U+2039)
  0x01, 0x47, 0x20, 0x3A, 0x01, // Ň› (U+0147 U+203A)
  0x01, 0x48, 0x00, 0x22, 0x04, // ň" (U+0148 U+0022)
  0x01, 0x48, 0x00, 0x27, 0x04, // ň' (U+0148 U+0027)
  0x01, 0x48, 0x00, 0x3F, 0x02, // ň? (U+0148 U+003F)
  0x01, 0x48, 0x00, 0x54, 0x02, // ňT (U+0148 U+0054)
  0x01, 0x48, 0x00, 0x56, 0x03, // ňV (U+0148 U+0056)
  0x01, 0x48, 0x00, 0x57, 0x03, // ňW (U+0148 U+0057)
  0x01, 0x48, 0x00, 0x59, 0x03, // ňY (U+0148 U+0059)
  0x01, 0x48, 0x00, 0x79, 0x02, // ňy (U+0148 U+0079)
  0x01, 0x48, 0x00, 0xDD, 0x03, // ňÝ (U+0148 U+00DD)
  0x01, 0x48, 0x00, 0xFD, 0x02, // ňý (U+0148 U+00FD)
  0x01, 0x48, 0x00, 0xFF, 0x02, // ňÿ (U+0148 U+00FF)
  0x01, 0x48, 0x01, 0x62, 0x02, // ňŢ (U+0148 U+0162)
  0x01, 0x48, 0x01, 0x64, 0x02, // ňŤ (U+0148 U+0164)
  0x01, 0x48, 0x01, 0x66, 0x02, // ňŦ (U+0148 U+0166)
  0x01, 0x48, 0x01, 0x74, 0x03, // ňŴ (U+0148 U+0174)
  0x01, 0x48, 0x01, 0x76, 0x03, // ňŶ (U+0148 U+0176)
  0x01, 0x48, 0x01, 0x77, 0x02, // ňŷ (U+0148 U+0177)
  0x01, 0x48, 0x01, 0x78, 0x03, // ňŸ (U+0148 U+0178)
  0x01, 0x49, 0x00, 0x22, 0x04, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x04, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x00, 0x3F, 0x02, // ŉ? (U+0149 U+003F)
  0x01, 0x49, 0x00, 0x54, 0x02, // ŉT (U+0149 U+0054)
  0x01, 0x49, 0x00, 0x56, 0x03, // ŉV (U+0149 U+0056)
  0x01, 0x49, 0x00, 0x57, 0x03, // ŉW (U+0149 U+0057)
  0x01, 0x49, 0x00, 0x59, 0x03, // ŉY (U+0149 U+0059)
  0x01, 0x49, 0x00, 0x79, 0x02, // ŉy (U+0149 U+0079)
  0x01, 0x49, 0x00, 0xDD, 0x03, // ŉÝ (U+0149 U+00DD)
  0x01, 0x49, 0x00, 0xFD, 0x02, // ŉý (U+0149 U+00FD)
  0x01, 0x49, 0x00, 0xFF, 0x02, // ŉÿ (U+0149 U+00FF)
  0x01, 0x49, 0x01, 0x62, 0x02, // ŉŢ (U+0149 U+0162)
  0x01, 0x49, 0x01, 0x64, 0x02, // ŉŤ (U+0149 U+0164)
  0x01, 0x49, 0x01, 0x66, 0x02, // ŉŦ (U+0149 U+0166)
  0x01, 0x49, 0x01, 0x74, 0x03, // ŉŴ (U+0149 U+0174)
  0x01, 0x49, 0x01, 0x76, 0x03, // ŉŶ (U+0149 U+0176)
  0x01, 0x49, 0x01, 0x77, 0x02, // ŉŷ (U+0149 U+0177)
  0x01, 0x49, 0x01, 0x78, 0x03, // ŉŸ (U+0149 U+0178)
  0x01, 0x4B, 0x00, 0x22, 0x04, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x04, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x00, 0x3F, 0x02, // ŋ? (U+014B U+003F)
  0x01, 0x4B, 0x00, 0x54, 0x02, // ŋT (U+014B U+0054)
  0x01, 0x4B, 0x00, 0x56, 0x03, // ŋV (U+014B U+0056)
  0x01, 0x4B, 0x00, 0x57, 0x03, // ŋW (U+014B U+0057)
  0x01, 0x4B, 0x00, 0x59, 0x03, // ŋY (U+014B U+0059)
  0x01, 0x4B, 0x00, 0x79, 0x02, // ŋy (U+014B U+0079)
  0x01, 0x4B, 0x00, 0xDD, 0x03, // ŋÝ (U+014B U+00DD)
  0x01, 0x4B, 0x00, 0xFD, 0x02, // ŋý (U+014B U+00FD)
  0x01, 0x4B, 0x00, 0xFF, 0x02, // ŋÿ (U+014B U+00FF)
  0x01, 0x4B, 0x01, 0x62, 0x02, // ŋŢ (U+014B U+0162)
  0x01, 0x4B, 0x01, 0x64, 0x02, // ŋŤ (U+014B U+0164)
  0x01, 0x4B, 0x01, 0x66, 0x02, // ŋŦ (U+014B U+0166)
  0x01, 0x4B, 0x01, 0x74, 0x03, // ŋŴ (U+014B U+0174)
  0x01, 0x4B, 0x01, 0x76, 0x03, // ŋŶ (U+014B U+0176)
  0x01, 0x4B, 0x01, 0x77, 0x02, // ŋŷ (U+014B U+0177)
  0x01, 0x4B, 0x01, 0x78, 0x03, // ŋŸ (U+014B U+0178)
  0x01, 0x4C, 0x00, 0x2C, 0x02, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x02, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x3F, 0x02, // Ō? (U+014C U+003F)
  0x01, 0x4C, 0x00, 0x41, 0x02, // ŌA (U+014C U+0041)
  0x01, 0x4C, 0x00, 0x54, 0x02, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x00, 0x56, 0x02, // ŌV (U+014C U+0056)
  0x01, 0x4C, 0x00, 0x57, 0x02, // ŌW (U+014C U+0057)
  0x01, 0x4C, 0x00, 0x58, 0x02, // ŌX (U+014C U+0058)
  0x01, 0x4C, 0x00, 0x59, 0x03, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0xC0, 0x02, // ŌÀ (U+014C U+00C0)
  0x01, 0x4C, 0x00, 0xC1, 0x02, // ŌÁ (U+014C U+00C1)
  0x01, 0x4C, 0x00, 0xC2, 0x02, // ŌÂ (U+014C U+00C2)
  0x01, 0x4C, 0x00, 0xC3, 0x02, // ŌÃ (U+014C U+00C3)
  0x01, 0x4C, 0x00, 0xC4, 0x02, // ŌÄ (U+014C U+00C4)
  0x01, 0x4C, 0x00, 0xC5, 0x02, // ŌÅ (U+014C U+00C5)
  0x01, 0x4C, 0x00, 0xC6, 0x05, // ŌÆ (U+014C U+00C6)
  0x01, 0x4C, 0x00, 0xDD, 0x03, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x00, 0x02, // ŌĀ (U+014C U+0100)
  0x01, 0x4C, 0x01, 0x02, 0x02, // ŌĂ (U+014C U+0102)
  0x01, 0x4C, 0x01, 0x04, 0x02, // ŌĄ (U+014C U+0104)
  0x01, 0x4C, 0x01, 0x62, 0x02, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x02, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x02, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x01, 0x74, 0x02, // ŌŴ (U+014C U+0174)
  0x01, 0x4C, 0x01, 0x76, 0x03, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x03, // ŌŸ (U+014C U+0178)
  0x01, 0x4C, 0x20, 0x1A, 0x02, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x02, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x02, // Ō… (U+014C U+2026)
  0x01, 0x4D, 0x00, 0x3F, 0x02, // ō? (U+014D U+003F)
  0x01, 0x4D, 0x00, 0x41, 0x01, // ōA (U+014D U+0041)
  0x01, 0x4D, 0x00, 0x54, 0x02, // ōT (U+014D U+0054)
  0x01, 0x4D, 0x00, 0x56, 0x03, // ōV (U+014D U+0056)
  0x01, 0x4D, 0x00, 0x57, 0x03, // ōW (U+014D U+0057)
  0x01, 0x4D, 0x00, 0x59, 0x04, // ōY (U+014D U+0059)
  0x01, 0x4D, 0x00, 0x79, 0x02, // ōy (U+014D U+0079)
  0x01, 0x4D, 0x00, 0xC0, 0x01, // ōÀ (U+014D U+00C0)
  0x01, 0x4D, 0x00, 0xC1, 0x01, // ōÁ (U+014D U+00C1)
  0x01, 0x4D, 0x00, 0xC2, 0x01, // ōÂ (U+014D U+00C2)
  0x01, 0x4D, 0x00, 0xC3, 0x01, // ōÃ (U+014D U+00C3)
  0x01, 0x4D, 0x00, 0xC4, 0x01, // ōÄ (U+014D U+00C4)
  0x01, 0x4D, 0x00, 0xC5, 0x01, // ōÅ (U+014D U+00C5)
  0x01, 0x4D, 0x00, 0xDD, 0x04, // ōÝ (U+014D U+00DD)
  0x01, 0x4D, 0x00, 0xFD, 0x02, // ōý (U+014D U+00FD)
  0x01, 0x4D, 0x00, 0xFF, 0x02, // ōÿ (U+014D U+00FF)
  0x01, 0x4D, 0x01, 0x00, 0x01, // ōĀ (U+014D U+0100)
  0x01, 0x4D, 0x01, 0x02, 0x01, // ōĂ (U+014D U+0102)
  0x01, 0x4D, 0x01, 0x04, 0x01, // ōĄ (U+014D U+0104)
  0x01, 0x4D, 0x01, 0x62, 0x02, // ōŢ (U+014D U+0162)
  0x01, 0x4D, 0x01, 0x64, 0x02, // ōŤ (U+014D U+0164)
  0x01, 0x4D, 0x01, 0x66, 0x02, // ōŦ (U+014D U+0166)
  0x01, 0x4D, 0x01, 0x74, 0x03, // ōŴ (U+014D U+0174)
  0x01, 0x4D, 0x01, 0x76, 0x04, // ōŶ (U+014D U+0176)
  0x01, 0x4D, 0x01, 0x77, 0x02, // ōŷ (U+014D U+0177)
  0x01, 0x4D, 0x01, 0x78, 0x04, // ōŸ (U+014D U+0178)
  0x01, 0x4E, 0x00, 0x2C, 0x02, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x02, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x3F, 0x02, // Ŏ? (U+014E U+003F)
  0x01, 0x4E, 0x00, 0x41, 0x02, // ŎA (U+014E U+0041)
  0x01, 0x4E, 0x00, 0x54, 0x02, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x00, 0x56, 0x02, // ŎV (U+014E U+0056)
  0x01, 0x4E, 0x00, 0x57, 0x02, // ŎW (U+014E U+0057)
  0x01, 0x4E, 0x00, 0x58, 0x02, // ŎX (U+014E U+0058)
  0x01, 0x4E, 0x00, 0x59, 0x03, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0xC0, 0x02, // ŎÀ (U+014E U+00C0)
  0x01, 0x4E, 0x00, 0xC1, 0x02, // ŎÁ (U+014E U+00C1)
  0x01, 0x4E, 0x00, 0xC2, 0x02, // ŎÂ (U+014E U+00C2)
  0x01, 0x4E, 0x00, 0xC3, 0x02, // ŎÃ (U+014E U+00C3)
  0x01, 0x4E, 0x00, 0xC4, 0x02, // ŎÄ (U+014E U+00C4)
  0x01, 0x4E, 0x00, 0xC5, 0x02, // ŎÅ (U+014E U+00C5)
  0x01, 0x4E, 0x00, 0xC6, 0x05, // ŎÆ (U+014E U+00C6)
  0x01, 0x4E, 0x00, 0xDD, 0x03, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x00, 0x02, // ŎĀ (U+014E U+0100)
  0x01, 0x4E, 0x01, 0x02, 0x02, // ŎĂ (U+014E U+0102)
  0x01, 0x4E, 0x01, 0x04, 0x02, // ŎĄ (U+014E U+0104)
  0x01, 0x4E, 0x01, 0x62, 0x02, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x02, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x02, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x01, 0x74, 0x02, // ŎŴ (U+014E U+0174)
  0x01, 0x4E, 0x01, 0x76, 0x03, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x03, // ŎŸ (U+014E U+0178)
  0x01, 0x4E, 0x20, 0x1A, 0x02, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x02, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x02, // Ŏ… (U+014E U+2026)
  0x01, 0x4F, 0x00, 0x3F, 0x02, // ŏ? (U+014F U+003F)
  0x01, 0x4F, 0x00, 0x41, 0x01, // ŏA (U+014F U+0041)
  0x01, 0x4F, 0x00, 0x54, 0x02, // ŏT (U+014F U+0054)
  0x01, 0x4F, 0x00, 0x56, 0x03, // ŏV (U+014F U+0056)
  0x01, 0x4F, 0x00, 0x57, 0x03, // ŏW (U+014F U+0057)
  0x01, 0x4F, 0x00, 0x59, 0x04, // ŏY (U+014F U+0059)
  0x01, 0x4F, 0x00, 0x79, 0x02, // ŏy (U+014F U+0079)
  0x01, 0x4F, 0x00, 0xC0, 0x01, // ŏÀ (U+014F U+00C0)
  0x01, 0x4F, 0x00, 0xC1, 0x01, // ŏÁ (U+014F U+00C1)
  0x01, 0x4F, 0x00, 0xC2, 0x01, // ŏÂ (U+014F U+00C2)
  0x01, 0x4F, 0x00, 0xC3, 0x01, // ŏÃ (U+014F U+00C3)
  0x01, 0x4F, 0x00, 0xC4, 0x01, // ŏÄ (U+014F U+00C4)
  0x01, 0x4F, 0x00, 0xC5, 0x01, // ŏÅ (U+014F U+00C5)
  0x01, 0x4F, 0x00, 0xDD, 0x04, // ŏÝ (U+014F U+00DD)
  0x01, 0x4F, 0x00, 0xFD, 0x02, // ŏý (U+014F U+00FD)
  0x01, 0x4F, 0x00, 0xFF, 0x02, // ŏÿ (U+014F U+00FF)
  0x01, 0x4F, 0x01, 0x00, 0x01, // ŏĀ (U+014F U+0100)
  0x01, 0x4F, 0x01, 0x02, 0x01, // ŏĂ (U+014F U+0102)
  0x01, 0x4F, 0x01, 0x04, 0x01, // ŏĄ (U+014F U+0104)
  0x01, 0x4F, 0x01, 0x62, 0x02, // ŏŢ (U+014F U+0162)
  0x01, 0x4F, 0x01, 0x64, 0x02, // ŏŤ (U+014F U+0164)
  0x01, 0x4F, 0x01, 0x66, 0x02, // ŏŦ (U+014F U+0166)
  0x01, 0x4F, 0x01, 0x74, 0x03, // ŏŴ (U+014F U+0174)
  0x01, 0x4F, 0x01, 0x76, 0x04, // ŏŶ (U+014F U+0176)
  0x01, 0x4F, 0x01, 0x77, 0x02, // ŏŷ (U+014F U+0177)
  0x01, 0x4F, 0x01, 0x78, 0x04, // ŏŸ (U+014F U+0178)
  0x01, 0x50, 0x00, 0x2C, 0x02, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x02, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x3F, 0x02, // Ő? (U+0150 U+003F)
  0x01, 0x50, 0x00, 0x41, 0x02, // ŐA (U+0150 U+0041)
  0x01, 0x50, 0x00, 0x54, 0x02, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x00, 0x56, 0x02, // ŐV (U+0150 U+0056)
  0x01, 0x50, 0x00, 0x57, 0x02, // ŐW (U+0150 U+0057)
  0x01, 0x50, 0x00, 0x58, 0x02, // ŐX (U+0150 U+0058)
  0x01, 0x50, 0x00, 0x59, 0x03, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0xC0, 0x02, // ŐÀ (U+0150 U+00C0)
  0x01, 0x50, 0x00, 0xC1, 0x02, // ŐÁ (U+0150 U+00C1)
  0x01, 0x50, 0x00, 0xC2, 0x02, // ŐÂ (U+0150 U+00C2)
  0x01, 0x50, 0x00, 0xC3, 0x02, // ŐÃ (U+0150 U+00C3)
  0x01, 0x50, 0x00, 0xC4, 0x02, // ŐÄ (U+0150 U+00C4)
  0x01, 0x50, 0x00, 0xC5, 0x02, // ŐÅ (U+0150 U+00C5)
  0x01, 0x50, 0x00, 0xC6, 0x05, // ŐÆ (U+0150 U+00C6)
  0x01, 0x50, 0x00, 0xDD, 0x03, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x00, 0x02, // ŐĀ (U+0150 U+0100)
  0x01, 0x50, 0x01, 0x02, 0x02, // ŐĂ (U+0150 U+0102)
  0x01, 0x50, 0x01, 0x04, 0x02, // ŐĄ (U+0150 U+0104)
  0x01, 0x50, 0x01, 0x62, 0x02, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x02, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x02, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x01, 0x74, 0x02, // ŐŴ (U+0150 U+0174)
  0x01, 0x50, 0x01, 0x76, 0x03, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x03, // ŐŸ (U+0150 U+0178)
  0x01, 0x50, 0x20, 0x1A, 0x02, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x02, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x02, // Ő… (U+0150 U+2026)
  0x01, 0x51, 0x00, 0x3F, 0x02, // ő? (U+0151 U+003F)
  0x01, 0x51, 0x00, 0x41, 0x01, // őA (U+0151 U+0041)
  0x01, 0x51, 0x00, 0x54, 0x02, // őT (U+0151 U+0054)
  0x01, 0x51, 0x00, 0x56, 0x03, // őV (U+0151 U+0056)
  0x01, 0x51, 0x00, 0x57, 0x03, // őW (U+0151 U+0057)
  0x01, 0x51, 0x00, 0x59, 0x04, // őY (U+0151 U+0059)
  0x01, 0x51, 0x00, 0x79, 0x02, // őy (U+0151 U+0079)
  0x01, 0x51, 0x00, 0xC0, 0x01, // őÀ (U+0151 U+00C0)
  0x01, 0x51, 0x00, 0xC1, 0x01, // őÁ (U+0151 U+00C1)
  0x01, 0x51, 0x00, 0xC2, 0x01, // őÂ (U+0151 U+00C2)
  0x01, 0x51, 0x00, 0xC3, 0x01, // őÃ (U+0151 U+00C3)
  0x01, 0x51, 0x00, 0xC4, 0x01, // őÄ (U+0151 U+00C4)
  0x01, 0x51, 0x00, 0xC5, 0x01, // őÅ (U+0151 U+00C5)
  0x01, 0x51, 0x00, 0xDD, 0x04, // őÝ (U+0151 U+00DD)
  0x01, 0x51, 0x00, 0xFD, 0x02, // őý (U+0151 U+00FD)
  0x01, 0x51, 0x00, 0xFF, 0x02, // őÿ (U+0151 U+00FF)
  0x01, 0x51, 0x01, 0x00, 0x01, // őĀ (U+0151 U+0100)
  0x01, 0x51, 0x01, 0x02, 0x01, // őĂ (U+0151 U+0102)
  0x01, 0x51, 0x01, 0x04, 0x01, // őĄ (U+0151 U+0104)
  0x01, 0x51, 0x01, 0x62, 0x02, // őŢ (U+0151 U+0162)
  0x01, 0x51, 0x01, 0x64, 0x02, // őŤ (U+0151 U+0164)
  0x01, 0x51, 0x01, 0x66, 0x02, // őŦ (U+0151 U+0166)
  0x01, 0x51, 0x01, 0x74, 0x03, // őŴ (U+0151 U+0174)
  0x01, 0x51, 0x01, 0x76, 0x04, // őŶ (U+0151 U+0176)
  0x01, 0x51, 0x01, 0x77, 0x02, // őŷ (U+0151 U+0177)
  0x01, 0x51, 0x01, 0x78, 0x04, // őŸ (U+0151 U+0178)
  0x01, 0x52, 0x00, 0x56, 0x02, // ŒV (U+0152 U+0056)
  0x01, 0x52, 0x00, 0x57, 0x02, // ŒW (U+0152 U+0057)
  0x01, 0x52, 0x00, 0x59, 0x02, // ŒY (U+0152 U+0059)
  0x01, 0x52, 0x00, 0xDD, 0x02, // ŒÝ (U+0152 U+00DD)
  0x01, 0x52, 0x01, 0x74, 0x02, // ŒŴ (U+0152 U+0174)
  0x01, 0x52, 0x01, 0x76, 0x02, // ŒŶ (U+0152 U+0176)
  0x01, 0x52, 0x01, 0x78, 0x02, // ŒŸ (U+0152 U+0178)
  0x01, 0x53, 0x00, 0x56, 0x04, // œV (U+0153 U+0056)
  0x01, 0x53, 0x00, 0x57, 0x04, // œW (U+0153 U+0057)
  0x01, 0x53, 0x00, 0x59, 0x04, // œY (U+0153 U+0059)
  0x01, 0x53, 0x00, 0xDD, 0x04, // œÝ (U+0153 U+00DD)
  0x01, 0x53, 0x01, 0x74, 0x04, // œŴ (U+0153 U+0174)
  0x01, 0x53, 0x01, 0x76, 0x04, // œŶ (U+0153 U+0176)
  0x01, 0x53, 0x01, 0x78, 0x04, // œŸ (U+0153 U+0178)
  0x01, 0x54, 0x00, 0x2A, 0x01, // Ŕ* (U+0154 U+002A)
  0x01, 0x54, 0x00, 0x3F, 0x01, // Ŕ? (U+0154 U+003F)
  0x01, 0x54, 0x00, 0x43, 0x01, // ŔC (U+0154 U+0043)
  0x01, 0x54, 0x00, 0x47, 0x01, // ŔG (U+0154 U+0047)
  0x01, 0x54, 0x00, 0x4F, 0x01, // ŔO (U+0154 U+004F)
  0x01, 0x54, 0x00, 0x51, 0x01, // ŔQ (U+0154 U+0051)
  0x01, 0x54, 0x00, 0x54, 0x01, // ŔT (U+0154 U+0054)
  0x01, 0x54, 0x00, 0x55, 0x01, // ŔU (U+0154 U+0055)
  0x01, 0x54, 0x00, 0x56, 0x02, // ŔV (U+0154 U+0056)
  0x01, 0x54, 0x00, 0x57, 0x02, // ŔW (U+0154 U+0057)
  0x01, 0x54, 0x00, 0x59, 0x02, // ŔY (U+0154 U+0059)
  0x01, 0x54, 0x00, 0x76, 0x01, // Ŕv (U+0154 U+0076)
  0x01, 0x54, 0x00, 0x77, 0x01, // Ŕw (U+0154 U+0077)
  0x01, 0x54, 0x00, 0x79, 0x02, // Ŕy (U+0154 U+0079)
  0x01, 0x54, 0x00, 0xC7, 0x01, // ŔÇ (U+0154 U+00C7)
  0x01, 0x54, 0x00, 0xD2, 0x01, // ŔÒ (U+0154 U+00D2)
  0x01, 0x54, 0x00, 0xD3, 0x01, // ŔÓ (U+0154 U+00D3)
  0x01, 0x54, 0x00, 0xD4, 0x01, // ŔÔ (U+0154 U+00D4)
  0x01, 0x54, 0x00, 0xD5, 0x01, // ŔÕ (U+0154 U+00D5)
  0x01, 0x54, 0x00, 0xD6, 0x01, // ŔÖ (U+0154 U+00D6)
  0x01, 0x54, 0x00, 0xD8, 0x01, // ŔØ (U+0154 U+00D8)
  0x01, 0x54, 0x00, 0xD9, 0x01, // ŔÙ (U+0154 U+00D9)
  0x01, 0x54, 0x00, 0xDA, 0x01, // ŔÚ (U+0154 U+00DA)
  0x01, 0x54, 0x00, 0xDB, 0x01, // ŔÛ (U+0154 U+00DB)
  0x01, 0x54, 0x00, 0xDC, 0x01, // ŔÜ (U+0154 U+00DC)
  0x01, 0x54, 0x00, 0xDD, 0x02, // ŔÝ (U+0154 U+00DD)
  0x01, 0x54, 0x00, 0xFD, 0x02, // Ŕý (U+0154 U+00FD)
  0x01, 0x54, 0x00, 0xFF, 0x02, // Ŕÿ (U+0154 U+00FF)
  0x01, 0x54, 0x01, 0x06, 0x01, // ŔĆ (U+0154 U+0106)
  0x01, 0x54, 0x01, 0x08, 0x01, // ŔĈ (U+0154 U+0108)
  0x01, 0x54, 0x01, 0x0A, 0x01, // ŔĊ (U+0154 U+010A)
  0x01, 0x54, 0x01, 0x0C, 0x01, // ŔČ (U+0154 U+010C)
  0x01, 0x54, 0x01, 0x1C, 0x01, // ŔĜ (U+0154 U+011C)
  0x01, 0x54, 0x01, 0x1E, 0x01, // ŔĞ (U+0154 U+011E)
  0x01, 0x54, 0x01, 0x20, 0x01, // ŔĠ (U+0154 U+0120)
  0x01, 0x54, 0x01, 0x22, 0x01, // ŔĢ (U+0154 U+0122)
  0x01, 0x54, 0x01, 0x4C, 0x01, // ŔŌ (U+0154 U+014C)
  0x01, 0x54, 0x01, 0x4E, 0x01, // ŔŎ (U+0154 U+014E)
  0x01, 0x54, 0x01, 0x50, 0x01, // ŔŐ (U+0154 U+0150)
  0x01, 0x54, 0x01, 0x52, 0x01, // ŔŒ (U+0154 U+0152)
  0x01, 0x54, 0x01, 0x62, 0x01, // ŔŢ (U+0154 U+0162)
  0x01, 0x54, 0x01, 0x64, 0x01, // ŔŤ (U+0154 U+0164)
  0x01, 0x54, 0x01, 0x66, 0x01, // ŔŦ (U+0154 U+0166)
  0x01, 0x54, 0x01, 0x68, 0x01, // ŔŨ (U+0154 U+0168)
  0x01, 0x54, 0x01, 0x6A, 0x01, // ŔŪ (U+0154 U+016A)
  0x01, 0x54, 0x01, 0x6C, 0x01, // ŔŬ (U+0154 U+016C)
  0x01, 0x54, 0x01, 0x6E, 0x01, // ŔŮ (U+0154 U+016E)
  0x01, 0x54, 0x01, 0x70, 0x01, // ŔŰ (U+0154 U+0170)
  0x01, 0x54, 0x01, 0x72, 0x01, // ŔŲ (U+0154 U+0172)
  0x01, 0x54, 0x01, 0x74, 0x02, // ŔŴ (U+0154 U+0174)
  0x01, 0x54, 0x01, 0x75, 0x01, // Ŕŵ (U+0154 U+0175)
  0x01, 0x54, 0x01, 0x76, 0x02, // ŔŶ (U+0154 U+0176)
  0x01, 0x54, 0x01, 0x77, 0x02, // Ŕŷ (U+0154 U+0177)
  0x01, 0x54, 0x01, 0x78, 0x02, // ŔŸ (U+0154 U+0178)
  0x01, 0x54, 0x20, 0x19, 0x01, // Ŕ’ (U+0154 U+2019)
  0x01, 0x54, 0x20, 0x1D, 0x01, // Ŕ” (U+0154 U+201D)
  0x01, 0x54, 0x21, 0x22, 0x01, // Ŕ™ (U+0154 U+2122)
  0x01, 0x55, 0x00, 0x2C, 0x0A, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x0A, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x41, 0x02, // ŕA (U+0155 U+0041)
  0x01, 0x55, 0x00, 0x58, 0x01, // ŕX (U+0155 U+0058)
  0x01, 0x55, 0x00, 0x61, 0x02, // ŕa (U+0155 U+0061)
  0x01, 0x55, 0x00, 0xC0, 0x02, // ŕÀ (U+0155 U+00C0)
  0x01, 0x55, 0x00, 0xC1, 0x02, // ŕÁ (U+0155 U+00C1)
  0x01, 0x55, 0x00, 0xC2, 0x02, // ŕÂ (U+0155 U+00C2)
  0x01, 0x55, 0x00, 0xC3, 0x02, // ŕÃ (U+0155 U+00C3)
  0x01, 0x55, 0x00, 0xC4, 0x02, // ŕÄ (U+0155 U+00C4)
  0x01, 0x55, 0x00, 0xC5, 0x02, // ŕÅ (U+0155 U+00C5)
  0x01, 0x55, 0x00, 0xE0, 0x02, // ŕà (U+0155 U+00E0)
  0x01, 0x55, 0x00, 0xE1, 0x02, // ŕá (U+0155 U+00E1)
  0x01, 0x55, 0x00, 0xE2, 0x02, // ŕâ (U+0155 U+00E2)
  0x01, 0x55, 0x00, 0xE3, 0x02, // ŕã (U+0155 U+00E3)
  0x01, 0x55, 0x00, 0xE4, 0x02, // ŕä (U+0155 U+00E4)
  0x01, 0x55, 0x00, 0xE5, 0x02, // ŕå (U+0155 U+00E5)
  0x01, 0x55, 0x00, 0xE6, 0x02, // ŕæ (U+0155 U+00E6)
  0x01, 0x55, 0x01, 0x00, 0x02, // ŕĀ (U+0155 U+0100)
  0x01, 0x55, 0x01, 0x01, 0x02, // ŕā (U+0155 U+0101)
  0x01, 0x55, 0x01, 0x02, 0x02, // ŕĂ (U+0155 U+0102)
  0x01, 0x55, 0x01, 0x03, 0x02, // ŕă (U+0155 U+0103)
  0x01, 0x55, 0x01, 0x04, 0x02, // ŕĄ (U+0155 U+0104)
  0x01, 0x55, 0x01, 0x05, 0x02, // ŕą (U+0155 U+0105)
  0x01, 0x55, 0x20, 0x1A, 0x0A, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x0A, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x0A, // ŕ… (U+0155 U+2026)
  0x01, 0x56, 0x00, 0x2A, 0x01, // Ŗ* (U+0156 U+002A)
  0x01, 0x56, 0x00, 0x3F, 0x01, // Ŗ? (U+0156 U+003F)
  0x01, 0x56, 0x00, 0x43, 0x01, // ŖC (U+0156 U+0043)
  0x01, 0x56, 0x00, 0x47, 0x01, // ŖG (U+0156 U+0047)
  0x01, 0x56, 0x00, 0x4F, 0x01, // ŖO (U+0156 U+004F)
  0x01, 0x56, 0x00, 0x51, 0x01, // ŖQ (U+0156 U+0051)
  0x01, 0x56, 0x00, 0x54, 0x01, // ŖT (U+0156 U+0054)
  0x01, 0x56, 0x00, 0x55, 0x01, // ŖU (U+0156 U+0055)
  0x01, 0x56, 0x00, 0x56, 0x02, // ŖV (U+0156 U+0056)
  0x01, 0x56, 0x00, 0x57, 0x02, // ŖW (U+0156 U+0057)
  0x01, 0x56, 0x00, 0x59, 0x02, // ŖY (U+0156 U+0059)
  0x01, 0x56, 0x00, 0x76, 0x01, // Ŗv (U+0156 U+0076)
  0x01, 0x56, 0x00, 0x77, 0x01, // Ŗw (U+0156 U+0077)
  0x01, 0x56, 0x00, 0x79, 0x02, // Ŗy (U+0156 U+0079)
  0x01, 0x56, 0x00, 0xC7, 0x01, // ŖÇ (U+0156 U+00C7)
  0x01, 0x56, 0x00, 0xD2, 0x01, // ŖÒ (U+0156 U+00D2)
  0x01, 0x56, 0x00, 0xD3, 0x01, // ŖÓ (U+0156 U+00D3)
  0x01, 0x56, 0x00, 0xD4, 0x01, // ŖÔ (U+0156 U+00D4)
  0x01, 0x56, 0x00, 0xD5, 0x01, // ŖÕ (U+0156 U+00D5)
  0x01, 0x56, 0x00, 0xD6, 0x01, // ŖÖ (U+0156 U+00D6)
  0x01, 0x56, 0x00, 0xD8, 0x01, // ŖØ (U+0156 U+00D8)
  0x01, 0x56, 0x00, 0xD9, 0x01, // ŖÙ (U+0156 U+00D9)
  0x01, 0x56, 0x00, 0xDA, 0x01, // ŖÚ (U+0156 U+00DA)
  0x01, 0x56, 0x00, 0xDB, 0x01, // ŖÛ (U+0156 U+00DB)
  0x01, 0x56, 0x00, 0xDC, 0x01, // ŖÜ (U+0156 U+00DC)
  0x01, 0x56, 0x00, 0xDD, 0x02, // ŖÝ (U+0156 U+00DD)
  0x01, 0x56, 0x00, 0xFD, 0x02, // Ŗý (U+0156 U+00FD)
  0x01, 0x56, 0x00, 0xFF, 0x02, // Ŗÿ (U+0156 U+00FF)
  0x01, 0x56, 0x01, 0x06, 0x01, // ŖĆ (U+0156 U+0106)
  0x01, 0x56, 0x01, 0x08, 0x01, // ŖĈ (U+0156 U+0108)
  0x01, 0x56, 0x01, 0x0A, 0x01, // ŖĊ (U+0156 U+010A)
  0x01, 0x56, 0x01, 0x0C, 0x01, // ŖČ (U+0156 U+010C)
  0x01, 0x56, 0x01, 0x1C, 0x01, // ŖĜ (U+0156 U+011C)
  0x01, 0x56, 0x01, 0x1E, 0x01, // ŖĞ (U+0156 U+011E)
  0x01, 0x56, 0x01, 0x20, 0x01, // ŖĠ (U+0156 U+0120)
  0x01, 0x56, 0x01, 0x22, 0x01, // ŖĢ (U+0156 U+0122)
  0x01, 0x56, 0x01, 0x4C, 0x01, // ŖŌ (U+0156 U+014C)
  0x01, 0x56, 0x01, 0x4E, 0x01, // ŖŎ (U+0156 U+014E)
  0x01, 0x56, 0x01, 0x50, 0x01, // ŖŐ (U+0156 U+0150)
  0x01, 0x56, 0x01, 0x52, 0x01, // ŖŒ (U+0156 U+0152)
  0x01, 0x56, 0x01, 0x62, 0x01, // ŖŢ (U+0156 U+0162)
  0x01, 0x56, 0x01, 0x64, 0x01, // ŖŤ (U+0156 U+0164)
  0x01, 0x56, 0x01, 0x66, 0x01, // ŖŦ (U+0156 U+0166)
  0x01, 0x56, 0x01, 0x68, 0x01, // ŖŨ (U+0156 U+0168)
  0x01, 0x56, 0x01, 0x6A, 0x01, // ŖŪ (U+0156 U+016A)
  0x01, 0x56, 0x01, 0x6C, 0x01, // ŖŬ (U+0156 U+016C)
  0x01, 0x56, 0x01, 0x6E, 0x01, // ŖŮ (U+0156 U+016E)
  0x01, 0x56, 0x01, 0x70, 0x01, // ŖŰ (U+0156 U+0170)
  0x01, 0x56, 0x01, 0x72, 0x01, // ŖŲ (U+0156 U+0172)
  0x01, 0x56, 0x01, 0x74, 0x02, // ŖŴ (U+0156 U+0174)
  0x01, 0x56, 0x01, 0x75, 0x01, // Ŗŵ (U+0156 U+0175)
  0x01, 0x56, 0x01, 0x76, 0x02, // ŖŶ (U+0156 U+0176)
  0x01, 0x56, 0x01, 0x77, 0x02, // Ŗŷ (U+0156 U+0177)
  0x01, 0x56, 0x01, 0x78, 0x02, // ŖŸ (U+0156 U+0178)
  0x01, 0x56, 0x20, 0x19, 0x01, // Ŗ’ (U+0156 U+2019)
  0x01, 0x56, 0x20, 0x1D, 0x01, // Ŗ” (U+0156 U+201D)
  0x01, 0x56, 0x21, 0x22, 0x01, // Ŗ™ (U+0156 U+2122)
  0x01, 0x57, 0x00, 0x2C, 0x0A, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x0A, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x41, 0x02, // ŗA (U+0157 U+0041)
  0x01, 0x57, 0x00, 0x58, 0x01, // ŗX (U+0157 U+0058)
  0x01, 0x57, 0x00, 0x61, 0x02, // ŗa (U+0157 U+0061)
  0x01, 0x57, 0x00, 0xC0, 0x02, // ŗÀ (U+0157 U+00C0)
  0x01, 0x57, 0x00, 0xC1, 0x02, // ŗÁ (U+0157 U+00C1)
  0x01, 0x57, 0x00, 0xC2, 0x02, // ŗÂ (U+0157 U+00C2)
  0x01, 0x57, 0x00, 0xC3, 0x02, // ŗÃ (U+0157 U+00C3)
  0x01, 0x57, 0x00, 0xC4, 0x02, // ŗÄ (U+0157 U+00C4)
  0x01, 0x57, 0x00, 0xC5, 0x02, // ŗÅ (U+0157 U+00C5)
  0x01, 0x57, 0x00, 0xE0, 0x02, // ŗà (U+0157 U+00E0)
  0x01, 0x57, 0x00, 0xE1, 0x02, // ŗá (U+0157 U+00E1)
  0x01, 0x57, 0x00, 0xE2, 0x02, // ŗâ (U+0157 U+00E2)
  0x01, 0x57, 0x00, 0xE3, 0x02, // ŗã (U+0157 U+00E3)
  0x01, 0x57, 0x00, 0xE4, 0x02, // ŗä (U+0157 U+00E4)
  0x01, 0x57, 0x00, 0xE5, 0x02, // ŗå (U+0157 U+00E5)
  0x01, 0x57, 0x00, 0xE6, 0x02, // ŗæ (U+0157 U+00E6)
  0x01, 0x57, 0x01, 0x00, 0x02, // ŗĀ (U+0157 U+0100)
  0x01, 0x57, 0x01, 0x01, 0x02, // ŗā (U+0157 U+0101)
  0x01, 0x57, 0x01, 0x02, 0x02, // ŗĂ (U+0157 U+0102)
  0x01, 0x57, 0x01, 0x03, 0x02, // ŗă (U+0157 U+0103)
  0x01, 0x57, 0x01, 0x04, 0x02, // ŗĄ (U+0157 U+0104)
  0x01, 0x57, 0x01, 0x05, 0x02, // ŗą (U+0157 U+0105)
  0x01, 0x57, 0x20, 0x1A, 0x0A, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x0A, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x0A, // ŗ… (U+0157 U+2026)
  0x01, 0x58, 0x00, 0x2A, 0x01, // Ř* (U+0158 U+002A)
  0x01, 0x58, 0x00, 0x3F, 0x01, // Ř? (U+0158 U+003F)
  0x01, 0x58, 0x00, 0x43, 0x01, // ŘC (U+0158 U+0043)
  0x01, 0x58, 0x00, 0x47, 0x01, // ŘG (U+0158 U+0047)
  0x01, 0x58, 0x00, 0x4F, 0x01, // ŘO (U+0158 U+004F)
  0x01, 0x58, 0x00, 0x51, 0x01, // ŘQ (U+0158 U+0051)
  0x01, 0x58, 0x00, 0x54, 0x01, // ŘT (U+0158 U+0054)
  0x01, 0x58, 0x00, 0x55, 0x01, // ŘU (U+0158 U+0055)
  0x01, 0x58, 0x00, 0x56, 0x02, // ŘV (U+0158 U+0056)
  0x01, 0x58, 0x00, 0x57, 0x02, // ŘW (U+0158 U+0057)
  0x01, 0x58, 0x00, 0x59, 0x02, // ŘY (U+0158 U+0059)
  0x01, 0x58, 0x00, 0x76, 0x01, // Řv (U+0158 U+0076)
  0x01, 0x58, 0x00, 0x77, 0x01, // Řw (U+0158 U+0077)
  0x01, 0x58, 0x00, 0x79, 0x02, // Řy (U+0158 U+0079)
  0x01, 0x58, 0x00, 0xC7, 0x01, // ŘÇ (U+0158 U+00C7)
  0x01, 0x58, 0x00, 0xD2, 0x01, // ŘÒ (U+0158 U+00D2)
  0x01, 0x58, 0x00, 0xD3, 0x01, // ŘÓ (U+0158 U+00D3)
  0x01, 0x58, 0x00, 0xD4, 0x01, // ŘÔ (U+0158 U+00D4)
  0x01, 0x58, 0x00, 0xD5, 0x01, // ŘÕ (U+0158 U+00D5)
  0x01, 0x58, 0x00, 0xD6, 0x01, // ŘÖ (U+0158 U+00D6)
  0x01, 0x58, 0x00, 0xD8, 0x01, // ŘØ (U+0158 U+00D8)
  0x01, 0x58, 0x00, 0xD9, 0x01, // ŘÙ (U+0158 U+00D9)
  0x01, 0x58, 0x00, 0xDA, 0x01, // ŘÚ (U+0158 U+00DA)
  0x01, 0x58, 0x00, 0xDB, 0x01, // ŘÛ (U+0158 U+00DB)
  0x01, 0x58, 0x00, 0xDC, 0x01, // ŘÜ (U+0158 U+00DC)
  0x01, 0x58, 0x00, 0xDD, 0x02, // ŘÝ (U+0158 U+00DD)
  0x01, 0x58, 0x00, 0xFD, 0x02, // Řý (U+0158 U+00FD)
  0x01, 0x58, 0x00, 0xFF, 0x02, // Řÿ (U+0158 U+00FF)
  0x01, 0x58, 0x01, 0x06, 0x01, // ŘĆ (U+0158 U+0106)
  0x01, 0x58, 0x01, 0x08, 0x01, // ŘĈ (U+0158 U+0108)
  0x01, 0x58, 0x01, 0x0A, 0x01, // ŘĊ (U+0158 U+010A)
  0x01, 0x58, 0x01, 0x0C, 0x01, // ŘČ (U+0158 U+010C)
  0x01, 0x58, 0x01, 0x1C, 0x01, // ŘĜ (U+0158 U+011C)
  0x01, 0x58, 0x01, 0x1E, 0x01, // ŘĞ (U+0158 U+011E)
  0x01, 0x58, 0x01, 0x20, 0x01, // ŘĠ (U+0158 U+0120)
  0x01, 0x58, 0x01, 0x22, 0x01, // ŘĢ (U+0158 U+0122)
  0x01, 0x58, 0x01, 0x4C, 0x01, // ŘŌ (U+0158 U+014C)
  0x01, 0x58, 0x01, 0x4E, 0x01, // ŘŎ (U+0158 U+014E)
  0x01, 0x58, 0x01, 0x50, 0x01, // ŘŐ (U+0158 U+0150)
  0x01, 0x58, 0x01, 0x52, 0x01, // ŘŒ (U+0158 U+0152)
  0x01, 0x58, 0x01, 0x62, 0x01, // ŘŢ (U+0158 U+0162)
  0x01, 0x58, 0x01, 0x64, 0x01, // ŘŤ (U+0158 U+0164)
  0x01, 0x58, 0x01, 0x66, 0x01, // ŘŦ (U+0158 U+0166)
  0x01, 0x58, 0x01, 0x68, 0x01, // ŘŨ (U+0158 U+0168)
  0x01, 0x58, 0x01, 0x6A, 0x01, // ŘŪ (U+0158 U+016A)
  0x01, 0x58, 0x01, 0x6C, 0x01, // ŘŬ (U+0158 U+016C)
  0x01, 0x58, 0x01, 0x6E, 0x01, // ŘŮ (U+0158 U+016E)
  0x01, 0x58, 0x01, 0x70, 0x01, // ŘŰ (U+0158 U+0170)
  0x01, 0x58, 0x01, 0x72, 0x01, // ŘŲ (U+0158 U+0172)
  0x01, 0x58, 0x01, 0x74, 0x02, // ŘŴ (U+0158 U+0174)
  0x01, 0x58, 0x01, 0x75, 0x01, // Řŵ (U+0158 U+0175)
  0x01, 0x58, 0x01, 0x76, 0x02, // ŘŶ (U+0158 U+0176)
  0x01, 0x58, 0x01, 0x77, 0x02, // Řŷ (U+0158 U+0177)
  0x01, 0x58, 0x01, 0x78, 0x02, // ŘŸ (U+0158 U+0178)
  0x01, 0x58, 0x20, 0x19, 0x01, // Ř’ (U+0158 U+2019)
  0x01, 0x58, 0x20, 0x1D, 0x01, // Ř” (U+0158 U+201D)
  0x01, 0x58, 0x21, 0x22, 0x01, // Ř™ (U+0158 U+2122)
  0x01, 0x59, 0x00, 0x2C, 0x0A, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x0A, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x41, 0x02, // řA (U+0159 U+0041)
  0x01, 0x59, 0x00, 0x58, 0x01, // řX (U+0159 U+0058)
  0x01, 0x59, 0x00, 0x61, 0x02, // řa (U+0159 U+0061)
  0x01, 0x59, 0x00, 0xC0, 0x02, // řÀ (U+0159 U+00C0)
  0x01, 0x59, 0x00, 0xC1, 0x02, // řÁ (U+0159 U+00C1)
  0x01, 0x59, 0x00, 0xC2, 0x02, // řÂ (U+0159 U+00C2)
  0x01, 0x59, 0x00, 0xC3, 0x02, // řÃ (U+0159 U+00C3)
  0x01, 0x59, 0x00, 0xC4, 0x02, // řÄ (U+0159 U+00C4)
  0x01, 0x59, 0x00, 0xC5, 0x02, // řÅ (U+0159 U+00C5)
  0x01, 0x59, 0x00, 0xE0, 0x02, // řà (U+0159 U+00E0)
  0x01, 0x59, 0x00, 0xE1, 0x02, // řá (U+0159 U+00E1)
  0x01, 0x59, 0x00, 0xE2, 0x02, // řâ (U+0159 U+00E2)
  0x01, 0x59, 0x00, 0xE3, 0x02, // řã (U+0159 U+00E3)
  0x01, 0x59, 0x00, 0xE4, 0x02, // řä (U+0159 U+00E4)
  0x01, 0x59, 0x00, 0xE5, 0x02, // řå (U+0159 U+00E5)
  0x01, 0x59, 0x00, 0xE6, 0x02, // řæ (U+0159 U+00E6)
  0x01, 0x59, 0x01, 0x00, 0x02, // řĀ (U+0159 U+0100)
  0x01, 0x59, 0x01, 0x01, 0x02, // řā (U+0159 U+0101)
  0x01, 0x59, 0x01, 0x02, 0x02, // řĂ (U+0159 U+0102)
  0x01, 0x59, 0x01, 0x03, 0x02, // řă (U+0159 U+0103)
  0x01, 0x59, 0x01, 0x04, 0x02, // řĄ (U+0159 U+0104)
  0x01, 0x59, 0x01, 0x05, 0x02, // řą (U+0159 U+0105)
  0x01, 0x59, 0x20, 0x1A, 0x0A, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x0A, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x0A, // ř… (U+0159 U+2026)
  0x01, 0x5A, 0x00, 0x3F, 0x01, // Ś? (U+015A U+003F)
  0x01, 0x5A, 0x00, 0x41, 0x01, // ŚA (U+015A U+0041)
  0x01, 0x5A, 0x00, 0x54, 0x01, // ŚT (U+015A U+0054)
  0x01, 0x5A, 0x00, 0x56, 0x02, // ŚV (U+015A U+0056)
  0x01, 0x5A, 0x00, 0x57, 0x02, // ŚW (U+015A U+0057)
  0x01, 0x5A, 0x00, 0x58, 0x01, // ŚX (U+015A U+0058)
  0x01, 0x5A, 0x00, 0x59, 0x01, // ŚY (U+015A U+0059)
  0x01, 0x5A, 0x00, 0x77, 0x01, // Św (U+015A U+0077)
  0x01, 0x5A, 0x00, 0x79, 0x02, // Śy (U+015A U+0079)
  0x01, 0x5A, 0x00, 0xC0, 0x01, // ŚÀ (U+015A U+00C0)
  0x01, 0x5A, 0x00, 0xC1, 0x01, // ŚÁ (U+015A U+00C1)
  0x01, 0x5A, 0x00, 0xC2, 0x01, // ŚÂ (U+015A U+00C2)
  0x01, 0x5A, 0x00, 0xC3, 0x01, // ŚÃ (U+015A U+00C3)
  0x01, 0x5A, 0x00, 0xC4, 0x01, // ŚÄ (U+015A U+00C4)
  0x01, 0x5A, 0x00, 0xC5, 0x01, // ŚÅ (U+015A U+00C5)
  0x01, 0x5A, 0x00, 0xC6, 0x02, // ŚÆ (U+015A U+00C6)
  0x01, 0x5A, 0x00, 0xDD, 0x01, // ŚÝ (U+015A U+00DD)
  0x01, 0x5A, 0x00, 0xFD, 0x02, // Śý (U+015A U+00FD)
  0x01, 0x5A, 0x00, 0xFF, 0x02, // Śÿ (U+015A U+00FF)
  0x01, 0x5A, 0x01, 0x00, 0x01, // ŚĀ (U+015A U+0100)
  0x01, 0x5A, 0x01, 0x02, 0x01, // ŚĂ (U+015A U+0102)
  0x01, 0x5A, 0x01, 0x04, 0x01, // ŚĄ (U+015A U+0104)
  0x01, 0x5A, 0x01, 0x62, 0x01, // ŚŢ (U+015A U+0162)
  0x01, 0x5A, 0x01, 0x64, 0x01, // ŚŤ (U+015A U+0164)
  0x01, 0x5A, 0x01, 0x66, 0x01, // ŚŦ (U+015A U+0166)
  0x01, 0x5A, 0x01, 0x74, 0x02, // ŚŴ (U+015A U+0174)
  0x01, 0x5A, 0x01, 0x75, 0x01, // Śŵ (U+015A U+0175)
  0x01, 0x5A, 0x01, 0x76, 0x01, // ŚŶ (U+015A U+0176)
  0x01, 0x5A, 0x01, 0x77, 0x02, // Śŷ (U+015A U+0177)
  0x01, 0x5A, 0x01, 0x78, 0x01, // ŚŸ (U+015A U+0178)
  0x01, 0x5B, 0x00, 0x57, 0x01, // śW (U+015B U+0057)
  0x01, 0x5B, 0x00, 0x59, 0x04, // śY (U+015B U+0059)
  0x01, 0x5B, 0x00, 0xDD, 0x04, // śÝ (U+015B U+00DD)
  0x01, 0x5B, 0x01, 0x74, 0x01, // śŴ (U+015B U+0174)
  0x01, 0x5B, 0x01, 0x76, 0x04, // śŶ (U+015B U+0176)
  0x01, 0x5B, 0x01, 0x78, 0x04, // śŸ (U+015B U+0178)
  0x01, 0x5C, 0x00, 0x3F, 0x01, // Ŝ? (U+015C U+003F)
  0x01, 0x5C, 0x00, 0x41, 0x01, // ŜA (U+015C U+0041)
  0x01, 0x5C, 0x00, 0x54, 0x01, // ŜT (U+015C U+0054)
  0x01, 0x5C, 0x00, 0x56, 0x02, // ŜV (U+015C U+0056)
  0x01, 0x5C, 0x00, 0x57, 0x02, // ŜW (U+015C U+0057)
  0x01, 0x5C, 0x00, 0x58, 0x01, // ŜX (U+015C U+0058)
  0x01, 0x5C, 0x00, 0x59, 0x01, // ŜY (U+015C U+0059)
  0x01, 0x5C, 0x00, 0x77, 0x01, // Ŝw (U+015C U+0077)
  0x01, 0x5C, 0x00, 0x79, 0x02, // Ŝy (U+015C U+0079)
  0x01, 0x5C, 0x00, 0xC0, 0x01, // ŜÀ (U+015C U+00C0)
  0x01, 0x5C, 0x00, 0xC1, 0x01, // ŜÁ (U+015C U+00C1)
  0x01, 0x5C, 0x00, 0xC2, 0x01, // ŜÂ (U+015C U+00C2)
  0x01, 0x5C, 0x00, 0xC3, 0x01, // ŜÃ (U+015C U+00C3)
  0x01, 0x5C, 0x00, 0xC4, 0x01, // ŜÄ (U+015C U+00C4)
  0x01, 0x5C, 0x00, 0xC5, 0x01, // ŜÅ (U+015C U+00C5)
  0x01, 0x5C, 0x00, 0xC6, 0x02, // ŜÆ (U+015C U+00C6)
  0x01, 0x5C, 0x00, 0xDD, 0x01, // ŜÝ (U+015C U+00DD)
  0x01, 0x5C, 0x00, 0xFD, 0x02, // Ŝý (U+015C U+00FD)
  0x01, 0x5C, 0x00, 0xFF, 0x02, // Ŝÿ (U+015C U+00FF)
  0x01, 0x5C, 0x01, 0x00, 0x01, // ŜĀ (U+015C U+0100)
  0x01, 0x5C, 0x01, 0x02, 0x01, // ŜĂ (U+015C U+0102)
  0x01, 0x5C, 0x01, 0x04, 0x01, // ŜĄ (U+015C U+0104)
  0x01, 0x5C, 0x01, 0x62, 0x01, // ŜŢ (U+015C U+0162)
  0x01, 0x5C, 0x01, 0x64, 0x01, // ŜŤ (U+015C U+0164)
  0x01, 0x5C, 0x01, 0x66, 0x01, // ŜŦ (U+015C U+0166)
  0x01, 0x5C, 0x01, 0x74, 0x02, // ŜŴ (U+015C U+0174)
  0x01, 0x5C, 0x01, 0x75, 0x01, // Ŝŵ (U+015C U+0175)
  0x01, 0x5C, 0x01, 0x76, 0x01, // ŜŶ (U+015C U+0176)
  0x01, 0x5C, 0x01, 0x77, 0x02, // Ŝŷ (U+015C U+0177)
  0x01, 0x5C, 0x01, 0x78, 0x01, // ŜŸ (U+015C U+0178)
  0x01, 0x5D, 0x00, 0x57, 0x01, // ŝW (U+015D U+0057)
  0x01, 0x5D, 0x00, 0x59, 0x04, // ŝY (U+015D U+0059)
  0x01, 0x5D, 0x00, 0xDD, 0x04, // ŝÝ (U+015D U+00DD)
  0x01, 0x5D, 0x01, 0x74, 0x01, // ŝŴ (U+015D U+0174)
  0x01, 0x5D, 0x01, 0x76, 0x04, // ŝŶ (U+015D U+0176)
  0x01, 0x5D, 0x01, 0x78, 0x04, // ŝŸ (U+015D U+0178)
  0x01, 0x5E, 0x00, 0x3F, 0x01, // Ş? (U+015E U+003F)
  0x01, 0x5E, 0x00, 0x41, 0x01, // ŞA (U+015E U+0041)
  0x01, 0x5E, 0x00, 0x54, 0x01, // ŞT (U+015E U+0054)
  0x01, 0x5E, 0x00, 0x56, 0x02, // ŞV (U+015E U+0056)
  0x01, 0x5E, 0x00, 0x57, 0x02, // ŞW (U+015E U+0057)
  0x01, 0x5E, 0x00, 0x58, 0x01, // ŞX (U+015E U+0058)
  0x01, 0x5E, 0x00, 0x59, 0x01, // ŞY (U+015E U+0059)
  0x01, 0x5E, 0x00, 0x77, 0x01, // Şw (U+015E U+0077)
  0x01, 0x5E, 0x00, 0x79, 0x02, // Şy (U+015E U+0079)
  0x01, 0x5E, 0x00, 0xC0, 0x01, // ŞÀ (U+015E U+00C0)
  0x01, 0x5E, 0x00, 0xC1, 0x01, // ŞÁ (U+015E U+00C1)
  0x01, 0x5E, 0x00, 0xC2, 0x01, // ŞÂ (U+015E U+00C2)
  0x01, 0x5E, 0x00, 0xC3, 0x01, // ŞÃ (U+015E U+00C3)
  0x01, 0x5E, 0x00, 0xC4, 0x01, // ŞÄ (U+015E U+00C4)
  0x01, 0x5E, 0x00, 0xC5, 0x01, // ŞÅ (U+015E U+00C5)
  0x01, 0x5E, 0x00, 0xC6, 0x02, // ŞÆ (U+015E U+00C6)
  0x01, 0x5E, 0x00, 0xDD, 0x01, // ŞÝ (U+015E U+00DD)
  0x01, 0x5E, 0x00, 0xFD, 0x02, // Şý (U+015E U+00FD)
  0x01, 0x5E, 0x00, 0xFF, 0x02, // Şÿ (U+015E U+00FF)
  0x01, 0x5E, 0x01, 0x00, 0x01, // ŞĀ (U+015E U+0100)
  0x01, 0x5E, 0x01, 0x02, 0x01, // ŞĂ (U+015E U+0102)
  0x01, 0x5E, 0x01, 0x04, 0x01, // ŞĄ (U+015E U+0104)
  0x01, 0x5E, 0x01, 0x62, 0x01, // ŞŢ (U+015E U+0162)
  0x01, 0x5E, 0x01, 0x64, 0x01, // ŞŤ (U+015E U+0164)
  0x01, 0x5E, 0x01, 0x66, 0x01, // ŞŦ (U+015E U+0166)
  0x01, 0x5E, 0x01, 0x74, 0x02, // ŞŴ (U+015E U+0174)
  0x01, 0x5E, 0x01, 0x75, 0x01, // Şŵ (U+015E U+0175)
  0x01, 0x5E, 0x01, 0x76, 0x01, // ŞŶ (U+015E U+0176)
  0x01, 0x5E, 0x01, 0x77, 0x02, // Şŷ (U+015E U+0177)
  0x01, 0x5E, 0x01, 0x78, 0x01, // ŞŸ (U+015E U+0178)
  0x01, 0x5F, 0x00, 0x57, 0x01, // şW (U+015F U+0057)
  0x01, 0x5F, 0x00, 0x59, 0x04, // şY (U+015F U+0059)
  0x01, 0x5F, 0x00, 0xDD, 0x04, // şÝ (U+015F U+00DD)
  0x01, 0x5F, 0x01, 0x74, 0x01, // şŴ (U+015F U+0174)
  0x01, 0x5F, 0x01, 0x76, 0x04, // şŶ (U+015F U+0176)
  0x01, 0x5F, 0x01, 0x78, 0x04, // şŸ (U+015F U+0178)
  0x01, 0x60, 0x00, 0x3F, 0x01, // Š? (U+0160 U+003F)
  0x01, 0x60, 0x00, 0x41, 0x01, // ŠA (U+0160 U+0041)
  0x01, 0x60, 0x00, 0x54, 0x01, // ŠT (U+0160 U+0054)
  0x01, 0x60, 0x00, 0x56, 0x02, // ŠV (U+0160 U+0056)
  0x01, 0x60, 0x00, 0x57, 0x02, // ŠW (U+0160 U+0057)
  0x01, 0x60, 0x00, 0x58, 0x01, // ŠX (U+0160 U+0058)
  0x01, 0x60, 0x00, 0x59, 0x01, // ŠY (U+0160 U+0059)
  0x01, 0x60, 0x00, 0x77, 0x01, // Šw (U+0160 U+0077)
  0x01, 0x60, 0x00, 0x79, 0x02, // Šy (U+0160 U+0079)
  0x01, 0x60, 0x00, 0xC0, 0x01, // ŠÀ (U+0160 U+00C0)
  0x01, 0x60, 0x00, 0xC1, 0x01, // ŠÁ (U+0160 U+00C1)
  0x01, 0x60, 0x00, 0xC2, 0x01, // ŠÂ (U+0160 U+00C2)
  0x01, 0x60, 0x00, 0xC3, 0x01, // ŠÃ (U+0160 U+00C3)
  0x01, 0x60, 0x00, 0xC4, 0x01, // ŠÄ (U+0160 U+00C4)
  0x01, 0x60, 0x00, 0xC5, 0x01, // ŠÅ (U+0160 U+00C5)
  0x01, 0x60, 0x00, 0xC6, 0x02, // ŠÆ (U+0160 U+00C6)
  0x01, 0x60, 0x00, 0xDD, 0x01, // ŠÝ (U+0160 U+00DD)
  0x01, 0x60, 0x00, 0xFD, 0x02, // Šý (U+0160 U+00FD)
  0x01, 0x60, 0x00, 0xFF, 0x02, // Šÿ (U+0160 U+00FF)
  0x01, 0x60, 0x01, 0x00, 0x01, // ŠĀ (U+0160 U+0100)
  0x01, 0x60, 0x01, 0x02, 0x01, // ŠĂ (U+0160 U+0102)
  0x01, 0x60, 0x01, 0x04, 0x01, // ŠĄ (U+0160 U+0104)
  0x01, 0x60, 0x01, 0x62, 0x01, // ŠŢ (U+0160 U+0162)
  0x01, 0x60, 0x01, 0x64, 0x01, // ŠŤ (U+0160 U+0164)
  0x01, 0x60, 0x01, 0x66, 0x01, // ŠŦ (U+0160 U+0166)
  0x01, 0x60, 0x01, 0x74, 0x02, // ŠŴ (U+0160 U+0174)
  0x01, 0x60, 0x01, 0x75, 0x01, // Šŵ (U+0160 U+0175)
  0x01, 0x60, 0x01, 0x76, 0x01, // ŠŶ (U+0160 U+0176)
  0x01, 0x60, 0x01, 0x77, 0x02, // Šŷ (U+0160 U+0177)
  0x01, 0x60, 0x01, 0x78, 0x01, // ŠŸ (U+0160 U+0178)
  0x01, 0x61, 0x00, 0x57, 0x01, // šW (U+0161 U+0057)
  0x01, 0x61, 0x00, 0x59, 0x04, // šY (U+0161 U+0059)
  0x01, 0x61, 0x00, 0xDD, 0x04, // šÝ (U+0161 U+00DD)
  0x01, 0x61, 0x01, 0x74, 0x01, // šŴ (U+0161 U+0174)
  0x01, 0x61, 0x01, 0x76, 0x04, // šŶ (U+0161 U+0176)
  0x01, 0x61, 0x01, 0x78, 0x04, // šŸ (U+0161 U+0178)
  0x01, 0x62, 0x00, 0x26, 0x01, // Ţ& (U+0162 U+0026)
  0x01, 0x62, 0x00, 0x2C, 0x06, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x06, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x40, 0x03, // Ţ@ (U+0162 U+0040)
  0x01, 0x62, 0x00, 0x41, 0x05, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x43, 0x02, // ŢC (U+0162 U+0043)
  0x01, 0x62, 0x00, 0x47, 0x02, // ŢG (U+0162 U+0047)
  0x01, 0x62, 0x00, 0x4F, 0x02, // ŢO (U+0162 U+004F)
  0x01, 0x62, 0x00, 0x51, 0x02, // ŢQ (U+0162 U+0051)
  0x01, 0x62, 0x00, 0x61, 0x03, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x04, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x04, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x04, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x04, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x04, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x04, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xC0, 0x05, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x05, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x05, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x05, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x05, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x05, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC6, 0x07, // ŢÆ (U+0162 U+00C6)
  0x01, 0x62, 0x00, 0xC7, 0x02, // ŢÇ (U+0162 U+00C7)
  0x01, 0x62, 0x00, 0xD2, 0x02, // ŢÒ (U+0162 U+00D2)
  0x01, 0x62, 0x00, 0xD3, 0x02, // ŢÓ (U+0162 U+00D3)
  0x01, 0x62, 0x00, 0xD4, 0x02, // ŢÔ (U+0162 U+00D4)
  0x01, 0x62, 0x00, 0xD5, 0x02, // ŢÕ (U+0162 U+00D5)
  0x01, 0x62, 0x00, 0xD6, 0x02, // ŢÖ (U+0162 U+00D6)
  0x01, 0x62, 0x00, 0xD8, 0x02, // ŢØ (U+0162 U+00D8)
  0x01, 0x62, 0x00, 0xE0, 0x03, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x03, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x03, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x03, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x03, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x03, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x03, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x04, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x04, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x04, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x04, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x04, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF0, 0x04, // Ţð (U+0162 U+00F0)
  0x01, 0x62, 0x00, 0xF2, 0x04, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x04, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x04, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x04, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x04, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x04, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x00, 0x05, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x03, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x05, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x03, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x05, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x03, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x06, 0x02, // ŢĆ (U+0162 U+0106)
  0x01, 0x62, 0x01, 0x07, 0x04, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x08, 0x02, // ŢĈ (U+0162 U+0108)
  0x01, 0x62, 0x01, 0x09, 0x04, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0A, 0x02, // ŢĊ (U+0162 U+010A)
  0x01, 0x62, 0x01, 0x0B, 0x04, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0C, 0x02, // ŢČ (U+0162 U+010C)
  0x01, 0x62, 0x01, 0x0D, 0x04, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x04, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x04, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x04, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x04, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x04, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x04, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x04, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1C, 0x02, // ŢĜ (U+0162 U+011C)
  0x01, 0x62, 0x01, 0x1D, 0x04, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1E, 0x02, // ŢĞ (U+0162 U+011E)
  0x01, 0x62, 0x01, 0x1F, 0x04, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x20, 0x02, // ŢĠ (U+0162 U+0120)
  0x01, 0x62, 0x01, 0x21, 0x04, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x22, 0x02, // ŢĢ (U+0162 U+0122)
  0x01, 0x62, 0x01, 0x23, 0x04, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4C, 0x02, // ŢŌ (U+0162 U+014C)
  0x01, 0x62, 0x01, 0x4D, 0x04, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4E, 0x02, // ŢŎ (U+0162 U+014E)
  0x01, 0x62, 0x01, 0x4F, 0x04, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x50, 0x02, // ŢŐ (U+0162 U+0150)
  0x01, 0x62, 0x01, 0x51, 0x04, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x52, 0x02, // ŢŒ (U+0162 U+0152)
  0x01, 0x62, 0x01, 0x53, 0x04, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x20, 0x1A, 0x06, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x06, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x06, // Ţ… (U+0162 U+2026)
  0x01, 0x64, 0x00, 0x26, 0x01, // Ť& (U+0164 U+0026)
  0x01, 0x64, 0x00, 0x2C, 0x06, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x06, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x40, 0x03, // Ť@ (U+0164 U+0040)
  0x01, 0x64, 0x00, 0x41, 0x05, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x43, 0x02, // ŤC (U+0164 U+0043)
  0x01, 0x64, 0x00, 0x47, 0x02, // ŤG (U+0164 U+0047)
  0x01, 0x64, 0x00, 0x4F, 0x02, // ŤO (U+0164 U+004F)
  0x01, 0x64, 0x00, 0x51, 0x02, // ŤQ (U+0164 U+0051)
  0x01, 0x64, 0x00, 0x61, 0x03, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x04, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x04, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x04, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x04, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x04, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x04, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xC0, 0x05, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x05, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x05, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x05, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x05, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x05, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC6, 0x07, // ŤÆ (U+0164 U+00C6)
  0x01, 0x64, 0x00, 0xC7, 0x02, // ŤÇ (U+0164 U+00C7)
  0x01, 0x64, 0x00, 0xD2, 0x02, // ŤÒ (U+0164 U+00D2)
  0x01, 0x64, 0x00, 0xD3, 0x02, // ŤÓ (U+0164 U+00D3)
  0x01, 0x64, 0x00, 0xD4, 0x02, // ŤÔ (U+0164 U+00D4)
  0x01, 0x64, 0x00, 0xD5, 0x02, // ŤÕ (U+0164 U+00D5)
  0x01, 0x64, 0x00, 0xD6, 0x02, // ŤÖ (U+0164 U+00D6)
  0x01, 0x64, 0x00, 0xD8, 0x02, // ŤØ (U+0164 U+00D8)
  0x01, 0x64, 0x00, 0xE0, 0x03, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x03, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x03, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x03, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x03, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x03, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x03, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x04, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x04, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x04, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x04, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x04, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF0, 0x04, // Ťð (U+0164 U+00F0)
  0x01, 0x64, 0x00, 0xF2, 0x04, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x04, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x04, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x04, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x04, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x04, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x00, 0x05, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x03, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x05, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x03, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x05, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x03, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x06, 0x02, // ŤĆ (U+0164 U+0106)
  0x01, 0x64, 0x01, 0x07, 0x04, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x08, 0x02, // ŤĈ (U+0164 U+0108)
  0x01, 0x64, 0x01, 0x09, 0x04, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0A, 0x02, // ŤĊ (U+0164 U+010A)
  0x01, 0x64, 0x01, 0x0B, 0x04, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0C, 0x02, // ŤČ (U+0164 U+010C)
  0x01, 0x64, 0x01, 0x0D, 0x04, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x04, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x04, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x04, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x04, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x04, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x04, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x04, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1C, 0x02, // ŤĜ (U+0164 U+011C)
  0x01, 0x64, 0x01, 0x1D, 0x04, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1E, 0x02, // ŤĞ (U+0164 U+011E)
  0x01, 0x64, 0x01, 0x1F, 0x04, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x20, 0x02, // ŤĠ (U+0164 U+0120)
  0x01, 0x64, 0x01, 0x21, 0x04, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x22, 0x02, // ŤĢ (U+0164 U+0122)
  0x01, 0x64, 0x01, 0x23, 0x04, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4C, 0x02, // ŤŌ (U+0164 U+014C)
  0x01, 0x64, 0x01, 0x4D, 0x04, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4E, 0x02, // ŤŎ (U+0164 U+014E)
  0x01, 0x64, 0x01, 0x4F, 0x04, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x50, 0x02, // ŤŐ (U+0164 U+0150)
  0x01, 0x64, 0x01, 0x51, 0x04, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x52, 0x02, // ŤŒ (U+0164 U+0152)
  0x01, 0x64, 0x01, 0x53, 0x04, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x20, 0x1A, 0x06, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x06, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x06, // Ť… (U+0164 U+2026)
  0x01, 0x66, 0x00, 0x26, 0x01, // Ŧ& (U+0166 U+0026)
  0x01, 0x66, 0x00, 0x2C, 0x06, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x06, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x40, 0x03, // Ŧ@ (U+0166 U+0040)
  0x01, 0x66, 0x00, 0x41, 0x05, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x43, 0x02, // ŦC (U+0166 U+0043)
  0x01, 0x66, 0x00, 0x47, 0x02, // ŦG (U+0166 U+0047)
  0x01, 0x66, 0x00, 0x4F, 0x02, // ŦO (U+0166 U+004F)
  0x01, 0x66, 0x00, 0x51, 0x02, // ŦQ (U+0166 U+0051)
  0x01, 0x66, 0x00, 0x61, 0x03, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x04, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x04, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x04, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x04, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x04, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x04, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xC0, 0x05, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x05, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x05, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x05, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x05, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x05, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC6, 0x07, // ŦÆ (U+0166 U+00C6)
  0x01, 0x66, 0x00, 0xC7, 0x02, // ŦÇ (U+0166 U+00C7)
  0x01, 0x66, 0x00, 0xD2, 0x02, // ŦÒ (U+0166 U+00D2)
  0x01, 0x66, 0x00, 0xD3, 0x02, // ŦÓ (U+0166 U+00D3)
  0x01, 0x66, 0x00, 0xD4, 0x02, // ŦÔ (U+0166 U+00D4)
  0x01, 0x66, 0x00, 0xD5, 0x02, // ŦÕ (U+0166 U+00D5)
  0x01, 0x66, 0x00, 0xD6, 0x02, // ŦÖ (U+0166 U+00D6)
  0x01, 0x66, 0x00, 0xD8, 0x02, // ŦØ (U+0166 U+00D8)
  0x01, 0x66, 0x00, 0xE0, 0x03, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x03, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x03, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x03, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x03, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x03, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x03, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x04, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x04, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x04, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x04, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x04, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF0, 0x04, // Ŧð (U+0166 U+00F0)
  0x01, 0x66, 0x00, 0xF2, 0x04, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x04, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x04, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x04, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x04, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x04, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x00, 0x05, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x03, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x05, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x03, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x05, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x03, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x06, 0x02, // ŦĆ (U+0166 U+0106)
  0x01, 0x66, 0x01, 0x07, 0x04, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x08, 0x02, // ŦĈ (U+0166 U+0108)
  0x01, 0x66, 0x01, 0x09, 0x04, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0A, 0x02, // ŦĊ (U+0166 U+010A)
  0x01, 0x66, 0x01, 0x0B, 0x04, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0C, 0x02, // ŦČ (U+0166 U+010C)
  0x01, 0x66, 0x01, 0x0D, 0x04, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x04, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x04, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x04, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x04, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x04, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x04, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x04, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1C, 0x02, // ŦĜ (U+0166 U+011C)
  0x01, 0x66, 0x01, 0x1D, 0x04, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1E, 0x02, // ŦĞ (U+0166 U+011E)
  0x01, 0x66, 0x01, 0x1F, 0x04, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x20, 0x02, // ŦĠ (U+0166 U+0120)
  0x01, 0x66, 0x01, 0x21, 0x04, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x22, 0x02, // ŦĢ (U+0166 U+0122)
  0x01, 0x66, 0x01, 0x23, 0x04, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4C, 0x02, // ŦŌ (U+0166 U+014C)
  0x01, 0x66, 0x01, 0x4D, 0x04, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4E, 0x02, // ŦŎ (U+0166 U+014E)
  0x01, 0x66, 0x01, 0x4F, 0x04, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x50, 0x02, // ŦŐ (U+0166 U+0150)
  0x01, 0x66, 0x01, 0x51, 0x04, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x52, 0x02, // ŦŒ (U+0166 U+0152)
  0x01, 0x66, 0x01, 0x53, 0x04, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x20, 0x1A, 0x06, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x06, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x06, // Ŧ… (U+0166 U+2026)
  0x01, 0x68, 0x00, 0x2C, 0x02, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x02, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x00, 0x40, 0x01, // Ũ@ (U+0168 U+0040)
  0x01, 0x68, 0x00, 0x41, 0x02, // ŨA (U+0168 U+0041)
  0x01, 0x68, 0x00, 0xC0, 0x02, // ŨÀ (U+0168 U+00C0)
  0x01, 0x68, 0x00, 0xC1, 0x02, // ŨÁ (U+0168 U+00C1)
  0x01, 0x68, 0x00, 0xC2, 0x02, // ŨÂ (U+0168 U+00C2)
  0x01, 0x68, 0x00, 0xC3, 0x02, // ŨÃ (U+0168 U+00C3)
  0x01, 0x68, 0x00, 0xC4, 0x02, // ŨÄ (U+0168 U+00C4)
  0x01, 0x68, 0x00, 0xC5, 0x02, // ŨÅ (U+0168 U+00C5)
  0x01, 0x68, 0x00, 0xC6, 0x04, // ŨÆ (U+0168 U+00C6)
  0x01, 0x68, 0x01, 0x00, 0x02, // ŨĀ (U+0168 U+0100)
  0x01, 0x68, 0x01, 0x02, 0x02, // ŨĂ (U+0168 U+0102)
  0x01, 0x68, 0x01, 0x04, 0x02, // ŨĄ (U+0168 U+0104)
  0x01, 0x68, 0x20, 0x1A, 0x02, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x02, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x02, // Ũ… (U+0168 U+2026)
  0x01, 0x6A, 0x00, 0x2C, 0x02, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x02, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x00, 0x40, 0x01, // Ū@ (U+016A U+0040)
  0x01, 0x6A, 0x00, 0x41, 0x02, // ŪA (U+016A U+0041)
  0x01, 0x6A, 0x00, 0xC0, 0x02, // ŪÀ (U+016A U+00C0)
  0x01, 0x6A, 0x00, 0xC1, 0x02, // ŪÁ (U+016A U+00C1)
  0x01, 0x6A, 0x00, 0xC2, 0x02, // ŪÂ (U+016A U+00C2)
  0x01, 0x6A, 0x00, 0xC3, 0x02, // ŪÃ (U+016A U+00C3)
  0x01, 0x6A, 0x00, 0xC4, 0x02, // ŪÄ (U+016A U+00C4)
  0x01, 0x6A, 0x00, 0xC5, 0x02, // ŪÅ (U+016A U+00C5)
  0x01, 0x6A, 0x00, 0xC6, 0x04, // ŪÆ (U+016A U+00C6)
  0x01, 0x6A, 0x01, 0x00, 0x02, // ŪĀ (U+016A U+0100)
  0x01, 0x6A, 0x01, 0x02, 0x02, // ŪĂ (U+016A U+0102)
  0x01, 0x6A, 0x01, 0x04, 0x02, // ŪĄ (U+016A U+0104)
  0x01, 0x6A, 0x20, 0x1A, 0x02, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x02, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x02, // Ū… (U+016A U+2026)
  0x01, 0x6C, 0x00, 0x2C, 0x02, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x02, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x00, 0x40, 0x01, // Ŭ@ (U+016C U+0040)
  0x01, 0x6C, 0x00, 0x41, 0x02, // ŬA (U+016C U+0041)
  0x01, 0x6C, 0x00, 0xC0, 0x02, // ŬÀ (U+016C U+00C0)
  0x01, 0x6C, 0x00, 0xC1, 0x02, // ŬÁ (U+016C U+00C1)
  0x01, 0x6C, 0x00, 0xC2, 0x02, // ŬÂ (U+016C U+00C2)
  0x01, 0x6C, 0x00, 0xC3, 0x02, // ŬÃ (U+016C U+00C3)
  0x01, 0x6C, 0x00, 0xC4, 0x02, // ŬÄ (U+016C U+00C4)
  0x01, 0x6C, 0x00, 0xC5, 0x02, // ŬÅ (U+016C U+00C5)
  0x01, 0x6C, 0x00, 0xC6, 0x04, // ŬÆ (U+016C U+00C6)
  0x01, 0x6C, 0x01, 0x00, 0x02, // ŬĀ (U+016C U+0100)
  0x01, 0x6C, 0x01, 0x02, 0x02, // ŬĂ (U+016C U+0102)
  0x01, 0x6C, 0x01, 0x04, 0x02, // ŬĄ (U+016C U+0104)
  0x01, 0x6C, 0x20, 0x1A, 0x02, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x02, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x02, // Ŭ… (U+016C U+2026)
  0x01, 0x6E, 0x00, 0x2C, 0x02, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x02, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x00, 0x40, 0x01, // Ů@ (U+016E U+0040)
  0x01, 0x6E, 0x00, 0x41, 0x02, // ŮA (U+016E U+0041)
  0x01, 0x6E, 0x00, 0xC0, 0x02, // ŮÀ (U+016E U+00C0)
  0x01, 0x6E, 0x00, 0xC1, 0x02, // ŮÁ (U+016E U+00C1)
  0x01, 0x6E, 0x00, 0xC2, 0x02, // ŮÂ (U+016E U+00C2)
  0x01, 0x6E, 0x00, 0xC3, 0x02, // ŮÃ (U+016E U+00C3)
  0x01, 0x6E, 0x00, 0xC4, 0x02, // ŮÄ (U+016E U+00C4)
  0x01, 0x6E, 0x00, 0xC5, 0x02, // ŮÅ (U+016E U+00C5)
  0x01, 0x6E, 0x00, 0xC6, 0x04, // ŮÆ (U+016E U+00C6)
  0x01, 0x6E, 0x01, 0x00, 0x02, // ŮĀ (U+016E U+0100)
  0x01, 0x6E, 0x01, 0x02, 0x02, // ŮĂ (U+016E U+0102)
  0x01, 0x6E, 0x01, 0x04, 0x02, // ŮĄ (U+016E U+0104)
  0x01, 0x6E, 0x20, 0x1A, 0x02, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x02, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x02, // Ů… (U+016E U+2026)
  0x01, 0x70, 0x00, 0x2C, 0x02, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x02, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x00, 0x40, 0x01, // Ű@ (U+0170 U+0040)
  0x01, 0x70, 0x00, 0x41, 0x02, // ŰA (U+0170 U+0041)
  0x01, 0x70, 0x00, 0xC0, 0x02, // ŰÀ (U+0170 U+00C0)
  0x01, 0x70, 0x00, 0xC1, 0x02, // ŰÁ (U+0170 U+00C1)
  0x01, 0x70, 0x00, 0xC2, 0x02, // ŰÂ (U+0170 U+00C2)
  0x01, 0x70, 0x00, 0xC3, 0x02, // ŰÃ (U+0170 U+00C3)
  0x01, 0x70, 0x00, 0xC4, 0x02, // ŰÄ (U+0170 U+00C4)
  0x01, 0x70, 0x00, 0xC5, 0x02, // ŰÅ (U+0170 U+00C5)
  0x01, 0x70, 0x00, 0xC6, 0x04, // ŰÆ (U+0170 U+00C6)
  0x01, 0x70, 0x01, 0x00, 0x02, // ŰĀ (U+0170 U+0100)
  0x01, 0x70, 0x01, 0x02, 0x02, // ŰĂ (U+0170 U+0102)
  0x01, 0x70, 0x01, 0x04, 0x02, // ŰĄ (U+0170 U+0104)
  0x01, 0x70, 0x20, 0x1A, 0x02, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x02, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x02, // Ű… (U+0170 U+2026)
  0x01, 0x72, 0x00, 0x2C, 0x02, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x02, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x00, 0x40, 0x01, // Ų@ (U+0172 U+0040)
  0x01, 0x72, 0x00, 0x41, 0x02, // ŲA (U+0172 U+0041)
  0x01, 0x72, 0x00, 0xC0, 0x02, // ŲÀ (U+0172 U+00C0)
  0x01, 0x72, 0x00, 0xC1, 0x02, // ŲÁ (U+0172 U+00C1)
  0x01, 0x72, 0x00, 0xC2, 0x02, // ŲÂ (U+0172 U+00C2)
  0x01, 0x72, 0x00, 0xC3, 0x02, // ŲÃ (U+0172 U+00C3)
  0x01, 0x72, 0x00, 0xC4, 0x02, // ŲÄ (U+0172 U+00C4)
  0x01, 0x72, 0x00, 0xC5, 0x02, // ŲÅ (U+0172 U+00C5)
  0x01, 0x72, 0x00, 0xC6, 0x04, // ŲÆ (U+0172 U+00C6)
  0x01, 0x72, 0x01, 0x00, 0x02, // ŲĀ (U+0172 U+0100)
  0x01, 0x72, 0x01, 0x02, 0x02, // ŲĂ (U+0172 U+0102)
  0x01, 0x72, 0x01, 0x04, 0x02, // ŲĄ (U+0172 U+0104)
  0x01, 0x72, 0x20, 0x1A, 0x02, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x02, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x02, // Ų… (U+0172 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x07, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x07, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x40, 0x05, // Ŵ@ (U+0174 U+0040)
  0x01, 0x74, 0x00, 0x41, 0x05, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x43, 0x02, // ŴC (U+0174 U+0043)
  0x01, 0x74, 0x00, 0x47, 0x02, // ŴG (U+0174 U+0047)
  0x01, 0x74, 0x00, 0x4F, 0x02, // ŴO (U+0174 U+004F)
  0x01, 0x74, 0x00, 0x51, 0x02, // ŴQ (U+0174 U+0051)
  0x01, 0x74, 0x00, 0x61, 0x06, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x04, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x04, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x04, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x04, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6F, 0x04, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x71, 0x04, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x73, 0x04, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0x7A, 0x03, // Ŵz (U+0174 U+007A)
  0x01, 0x74, 0x00, 0xC0, 0x05, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x05, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x05, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x05, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x05, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x05, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC6, 0x09, // ŴÆ (U+0174 U+00C6)
  0x01, 0x74, 0x00, 0xC7, 0x02, // ŴÇ (U+0174 U+00C7)
  0x01, 0x74, 0x00, 0xD2, 0x02, // ŴÒ (U+0174 U+00D2)
  0x01, 0x74, 0x00, 0xD3, 0x02, // ŴÓ (U+0174 U+00D3)
  0x01, 0x74, 0x00, 0xD4, 0x02, // ŴÔ (U+0174 U+00D4)
  0x01, 0x74, 0x00, 0xD5, 0x02, // ŴÕ (U+0174 U+00D5)
  0x01, 0x74, 0x00, 0xD6, 0x02, // ŴÖ (U+0174 U+00D6)
  0x01, 0x74, 0x00, 0xD8, 0x02, // ŴØ (U+0174 U+00D8)
  0x01, 0x74, 0x00, 0xE0, 0x06, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x06, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x06, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x06, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x06, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x06, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x06, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x04, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x04, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x04, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x04, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x04, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF0, 0x04, // Ŵð (U+0174 U+00F0)
  0x01, 0x74, 0x00, 0xF2, 0x04, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x04, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x04, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x04, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x04, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x04, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x01, 0x00, 0x05, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x06, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x05, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x06, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x05, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x06, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x06, 0x02, // ŴĆ (U+0174 U+0106)
  0x01, 0x74, 0x01, 0x07, 0x04, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x08, 0x02, // ŴĈ (U+0174 U+0108)
  0x01, 0x74, 0x01, 0x09, 0x04, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0A, 0x02, // ŴĊ (U+0174 U+010A)
  0x01, 0x74, 0x01, 0x0B, 0x04, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0C, 0x02, // ŴČ (U+0174 U+010C)
  0x01, 0x74, 0x01, 0x0D, 0x04, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x04, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x04, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x04, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x04, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x04, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x04, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x04, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1C, 0x02, // ŴĜ (U+0174 U+011C)
  0x01, 0x74, 0x01, 0x1D, 0x04, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1E, 0x02, // ŴĞ (U+0174 U+011E)
  0x01, 0x74, 0x01, 0x1F, 0x04, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x20, 0x02, // ŴĠ (U+0174 U+0120)
  0x01, 0x74, 0x01, 0x21, 0x04, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x22, 0x02, // ŴĢ (U+0174 U+0122)
  0x01, 0x74, 0x01, 0x23, 0x04, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x4C, 0x02, // ŴŌ (U+0174 U+014C)
  0x01, 0x74, 0x01, 0x4D, 0x04, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4E, 0x02, // ŴŎ (U+0174 U+014E)
  0x01, 0x74, 0x01, 0x4F, 0x04, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x50, 0x02, // ŴŐ (U+0174 U+0150)
  0x01, 0x74, 0x01, 0x51, 0x04, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x52, 0x02, // ŴŒ (U+0174 U+0152)
  0x01, 0x74, 0x01, 0x53, 0x04, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x5B, 0x04, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5D, 0x04, // Ŵŝ (U+0174 U+015D)
  0x01, 0x74, 0x01, 0x5F, 0x04, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x61, 0x04, // Ŵš (U+0174 U+0161)
  0x01, 0x74, 0x01, 0x7A, 0x03, // Ŵź (U+0174 U+017A)
  0x01, 0x74, 0x01, 0x7C, 0x03, // Ŵż (U+0174 U+017C)
  0x01, 0x74, 0x01, 0x7E, 0x03, // Ŵž (U+0174 U+017E)
  0x01, 0x74, 0x20, 0x1A, 0x07, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x07, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x07, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x05, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x05, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x00, 0x41, 0x03, // ŵA (U+0175 U+0041)
  0x01, 0x75, 0x00, 0xC0, 0x03, // ŵÀ (U+0175 U+00C0)
  0x01, 0x75, 0x00, 0xC1, 0x03, // ŵÁ (U+0175 U+00C1)
  0x01, 0x75, 0x00, 0xC2, 0x03, // ŵÂ (U+0175 U+00C2)
  0x01, 0x75, 0x00, 0xC3, 0x03, // ŵÃ (U+0175 U+00C3)
  0x01, 0x75, 0x00, 0xC4, 0x03, // ŵÄ (U+0175 U+00C4)
  0x01, 0x75, 0x00, 0xC5, 0x03, // ŵÅ (U+0175 U+00C5)
  0x01, 0x75, 0x01, 0x00, 0x03, // ŵĀ (U+0175 U+0100)
  0x01, 0x75, 0x01, 0x02, 0x03, // ŵĂ (U+0175 U+0102)
  0x01, 0x75, 0x01, 0x04, 0x03, // ŵĄ (U+0175 U+0104)
  0x01, 0x75, 0x20, 0x1A, 0x05, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x05, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x05, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x06, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x06, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x40, 0x04, // Ŷ@ (U+0176 U+0040)
  0x01, 0x76, 0x00, 0x41, 0x04, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x03, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x03, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x03, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x03, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x53, 0x01, // ŶS (U+0176 U+0053)
  0x01, 0x76, 0x00, 0x61, 0x05, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x04, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x04, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x04, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x04, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x04, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x04, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x04, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x7A, 0x02, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xC0, 0x04, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x04, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x04, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x04, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x04, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x04, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC6, 0x06, // ŶÆ (U+0176 U+00C6)
  0x01, 0x76, 0x00, 0xC7, 0x03, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x03, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x03, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x03, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x03, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x03, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x03, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x05, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x05, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x05, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x05, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x05, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x05, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x05, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x04, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x04, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x04, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x04, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x04, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF0, 0x04, // Ŷð (U+0176 U+00F0)
  0x01, 0x76, 0x00, 0xF2, 0x04, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x04, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x04, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x04, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x04, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x04, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x04, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x05, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x04, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x05, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x04, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x05, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x03, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x04, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x03, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x04, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x03, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x04, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x03, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x04, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x04, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x04, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x04, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x04, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x04, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x04, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x04, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x03, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x04, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x03, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x04, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x03, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x04, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x03, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x04, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4C, 0x03, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x04, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x03, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x04, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x03, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x04, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x03, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x04, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5A, 0x01, // ŶŚ (U+0176 U+015A)
  0x01, 0x76, 0x01, 0x5B, 0x04, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5C, 0x01, // ŶŜ (U+0176 U+015C)
  0x01, 0x76, 0x01, 0x5D, 0x04, // Ŷŝ (U+0176 U+015D)
  0x01, 0x76, 0x01, 0x5E, 0x01, // ŶŞ (U+0176 U+015E)
  0x01, 0x76, 0x01, 0x5F, 0x04, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x60, 0x01, // ŶŠ (U+0176 U+0160)
  0x01, 0x76, 0x01, 0x61, 0x04, // Ŷš (U+0176 U+0161)
  0x01, 0x76, 0x01, 0x7A, 0x02, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x02, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x02, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x06, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x06, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x06, // Ŷ… (U+0176 U+2026)
  0x01, 0x77, 0x00, 0x2C, 0x07, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x07, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x00, 0x41, 0x05, // ŷA (U+0177 U+0041)
  0x01, 0x77, 0x00, 0xC0, 0x05, // ŷÀ (U+0177 U+00C0)
  0x01, 0x77, 0x00, 0xC1, 0x05, // ŷÁ (U+0177 U+00C1)
  0x01, 0x77, 0x00, 0xC2, 0x05, // ŷÂ (U+0177 U+00C2)
  0x01, 0x77, 0x00, 0xC3, 0x05, // ŷÃ (U+0177 U+00C3)
  0x01, 0x77, 0x00, 0xC4, 0x05, // ŷÄ (U+0177 U+00C4)
  0x01, 0x77, 0x00, 0xC5, 0x05, // ŷÅ (U+0177 U+00C5)
  0x01, 0x77, 0x01, 0x00, 0x05, // ŷĀ (U+0177 U+0100)
  0x01, 0x77, 0x01, 0x02, 0x05, // ŷĂ (U+0177 U+0102)
  0x01, 0x77, 0x01, 0x04, 0x05, // ŷĄ (U+0177 U+0104)
  0x01, 0x77, 0x20, 0x1A, 0x07, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x07, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x07, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x06, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x06, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x40, 0x04, // Ÿ@ (U+0178 U+0040)
  0x01, 0x78, 0x00, 0x41, 0x04, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x03, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x03, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x03, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x03, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x53, 0x01, // ŸS (U+0178 U+0053)
  0x01, 0x78, 0x00, 0x61, 0x05, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x04, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x04, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x04, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x04, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x04, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x04, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x04, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x7A, 0x02, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xC0, 0x04, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x04, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x04, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x04, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x04, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x04, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC6, 0x06, // ŸÆ (U+0178 U+00C6)
  0x01, 0x78, 0x00, 0xC7, 0x03, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x03, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x03, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x03, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x03, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x03, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x03, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x05, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x05, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x05, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x05, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x05, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x05, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x05, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x04, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x04, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x04, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x04, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x04, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF0, 0x04, // Ÿð (U+0178 U+00F0)
  0x01, 0x78, 0x00, 0xF2, 0x04, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x04, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x04, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x04, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x04, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x04, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x04, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x05, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x04, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x05, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x04, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x05, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x03, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x04, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x03, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x04, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x03, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x04, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x03, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x04, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x04, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x04, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x04, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x04, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x04, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x04, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x04, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x03, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x04, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x03, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x04, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x03, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x04, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x03, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x04, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4C, 0x03, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x04, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x03, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x04, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x03, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x04, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x03, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x04, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5A, 0x01, // ŸŚ (U+0178 U+015A)
  0x01, 0x78, 0x01, 0x5B, 0x04, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5C, 0x01, // ŸŜ (U+0178 U+015C)
  0x01, 0x78, 0x01, 0x5D, 0x04, // Ÿŝ (U+0178 U+015D)
  0x01, 0x78, 0x01, 0x5E, 0x01, // ŸŞ (U+0178 U+015E)
  0x01, 0x78, 0x01, 0x5F, 0x04, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x60, 0x01, // ŸŠ (U+0178 U+0160)
  0x01, 0x78, 0x01, 0x61, 0x04, // Ÿš (U+0178 U+0161)
  0x01, 0x78, 0x01, 0x7A, 0x02, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x02, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x02, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x06, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x06, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x06, // Ÿ… (U+0178 U+2026)
  0x20, 0x18, 0x00, 0x41, 0x06, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x06, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x06, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x06, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x06, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x06, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x06, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x0B, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x06, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x06, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x06, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x09, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x43, 0x02, // ’C (U+2019 U+0043)
  0x20, 0x19, 0x00, 0x47, 0x02, // ’G (U+2019 U+0047)
  0x20, 0x19, 0x00, 0x4F, 0x02, // ’O (U+2019 U+004F)
  0x20, 0x19, 0x00, 0x51, 0x02, // ’Q (U+2019 U+0051)
  0x20, 0x19, 0x00, 0x61, 0x03, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x04, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x04, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x04, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x04, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6F, 0x04, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x04, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x73, 0x05, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0xC0, 0x09, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x09, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x09, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x09, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x09, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x09, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x08, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xC7, 0x02, // ’Ç (U+2019 U+00C7)
  0x20, 0x19, 0x00, 0xD2, 0x02, // ’Ò (U+2019 U+00D2)
  0x20, 0x19, 0x00, 0xD3, 0x02, // ’Ó (U+2019 U+00D3)
  0x20, 0x19, 0x00, 0xD4, 0x02, // ’Ô (U+2019 U+00D4)
  0x20, 0x19, 0x00, 0xD5, 0x02, // ’Õ (U+2019 U+00D5)
  0x20, 0x19, 0x00, 0xD6, 0x02, // ’Ö (U+2019 U+00D6)
  0x20, 0x19, 0x00, 0xD8, 0x02, // ’Ø (U+2019 U+00D8)
  0x20, 0x19, 0x00, 0xE0, 0x03, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x03, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x03, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x03, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x03, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x03, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x03, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x04, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x04, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x04, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x04, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x04, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF0, 0x04, // ’ð (U+2019 U+00F0)
  0x20, 0x19, 0x00, 0xF2, 0x04, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x04, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x04, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x04, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x04, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x04, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x09, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x03, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x09, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x03, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x09, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x03, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x06, 0x02, // ’Ć (U+2019 U+0106)
  0x20, 0x19, 0x01, 0x07, 0x04, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x08, 0x02, // ’Ĉ (U+2019 U+0108)
  0x20, 0x19, 0x01, 0x09, 0x04, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0A, 0x02, // ’Ċ (U+2019 U+010A)
  0x20, 0x19, 0x01, 0x0B, 0x04, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0C, 0x02, // ’Č (U+2019 U+010C)
  0x20, 0x19, 0x01, 0x0D, 0x04, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x04, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x04, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x04, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x04, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x04, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x04, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x04, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1C, 0x02, // ’Ĝ (U+2019 U+011C)
  0x20, 0x19, 0x01, 0x1D, 0x04, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1E, 0x02, // ’Ğ (U+2019 U+011E)
  0x20, 0x19, 0x01, 0x1F, 0x04, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x20, 0x02, // ’Ġ (U+2019 U+0120)
  0x20, 0x19, 0x01, 0x21, 0x04, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x22, 0x02, // ’Ģ (U+2019 U+0122)
  0x20, 0x19, 0x01, 0x23, 0x04, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x4C, 0x02, // ’Ō (U+2019 U+014C)
  0x20, 0x19, 0x01, 0x4D, 0x04, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4E, 0x02, // ’Ŏ (U+2019 U+014E)
  0x20, 0x19, 0x01, 0x4F, 0x04, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x50, 0x02, // ’Ő (U+2019 U+0150)
  0x20, 0x19, 0x01, 0x51, 0x04, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x52, 0x02, // ’Œ (U+2019 U+0152)
  0x20, 0x19, 0x01, 0x53, 0x04, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x5B, 0x05, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5D, 0x05, // ’ŝ (U+2019 U+015D)
  0x20, 0x19, 0x01, 0x5F, 0x05, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x61, 0x05, // ’š (U+2019 U+0161)
  0x20, 0x1A, 0x00, 0x3F, 0x06, // ‚? (U+201A U+003F)
  0x20, 0x1A, 0x00, 0x43, 0x02, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x02, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x02, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x02, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x06, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x55, 0x02, // ‚U (U+201A U+0055)
  0x20, 0x1A, 0x00, 0x56, 0x09, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x07, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x06, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0x75, 0x01, // ‚u (U+201A U+0075)
  0x20, 0x1A, 0x00, 0x76, 0x06, // ‚v (U+201A U+0076)
  0x20, 0x1A, 0x00, 0x77, 0x05, // ‚w (U+201A U+0077)
  0x20, 0x1A, 0x00, 0x79, 0x05, // ‚y (U+201A U+0079)
  0x20, 0x1A, 0x00, 0xC7, 0x02, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x02, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x02, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x02, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x02, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x02, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x02, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xD9, 0x02, // ‚Ù (U+201A U+00D9)
  0x20, 0x1A, 0x00, 0xDA, 0x02, // ‚Ú (U+201A U+00DA)
  0x20, 0x1A, 0x00, 0xDB, 0x02, // ‚Û (U+201A U+00DB)
  0x20, 0x1A, 0x00, 0xDC, 0x02, // ‚Ü (U+201A U+00DC)
  0x20, 0x1A, 0x00, 0xDD, 0x06, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x00, 0xF9, 0x01, // ‚ù (U+201A U+00F9)
  0x20, 0x1A, 0x00, 0xFA, 0x01, // ‚ú (U+201A U+00FA)
  0x20, 0x1A, 0x00, 0xFB, 0x01, // ‚û (U+201A U+00FB)
  0x20, 0x1A, 0x00, 0xFC, 0x01, // ‚ü (U+201A U+00FC)
  0x20, 0x1A, 0x00, 0xFD, 0x05, // ‚ý (U+201A U+00FD)
  0x20, 0x1A, 0x00, 0xFF, 0x05, // ‚ÿ (U+201A U+00FF)
  0x20, 0x1A, 0x01, 0x06, 0x02, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x02, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x02, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x02, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x02, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x02, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x02, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x02, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x02, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x02, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x02, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x02, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x06, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x06, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x06, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x68, 0x02, // ‚Ũ (U+201A U+0168)
  0x20, 0x1A, 0x01, 0x69, 0x01, // ‚ũ (U+201A U+0169)
  0x20, 0x1A, 0x01, 0x6A, 0x02, // ‚Ū (U+201A U+016A)
  0x20, 0x1A, 0x01, 0x6B, 0x01, // ‚ū (U+201A U+016B)
  0x20, 0x1A, 0x01, 0x6C, 0x02, // ‚Ŭ (U+201A U+016C)
  0x20, 0x1A, 0x01, 0x6D, 0x01, // ‚ŭ (U+201A U+016D)
  0x20, 0x1A, 0x01, 0x6E, 0x02, // ‚Ů (U+201A U+016E)
  0x20, 0x1A, 0x01, 0x6F, 0x01, // ‚ů (U+201A U+016F)
  0x20, 0x1A, 0x01, 0x70, 0x02, // ‚Ű (U+201A U+0170)
  0x20, 0x1A, 0x01, 0x71, 0x01, // ‚ű (U+201A U+0171)
  0x20, 0x1A, 0x01, 0x72, 0x02, // ‚Ų (U+201A U+0172)
  0x20, 0x1A, 0x01, 0x73, 0x01, // ‚ų (U+201A U+0173)
  0x20, 0x1A, 0x01, 0x74, 0x07, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x75, 0x05, // ‚ŵ (U+201A U+0175)
  0x20, 0x1A, 0x01, 0x76, 0x06, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x77, 0x05, // ‚ŷ (U+201A U+0177)
  0x20, 0x1A, 0x01, 0x78, 0x06, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x06, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x06, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x06, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x06, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x06, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x06, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x06, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x0B, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x06, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x06, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x06, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x09, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x43, 0x02, // ”C (U+201D U+0043)
  0x20, 0x1D, 0x00, 0x47, 0x02, // ”G (U+201D U+0047)
  0x20, 0x1D, 0x00, 0x4F, 0x02, // ”O (U+201D U+004F)
  0x20, 0x1D, 0x00, 0x51, 0x02, // ”Q (U+201D U+0051)
  0x20, 0x1D, 0x00, 0x61, 0x03, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x04, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x04, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x04, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x04, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6F, 0x04, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x04, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x73, 0x05, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0xC0, 0x09, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x09, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x09, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x09, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x09, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x09, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x08, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xC7, 0x02, // ”Ç (U+201D U+00C7)
  0x20, 0x1D, 0x00, 0xD2, 0x02, // ”Ò (U+201D U+00D2)
  0x20, 0x1D, 0x00, 0xD3, 0x02, // ”Ó (U+201D U+00D3)
  0x20, 0x1D, 0x00, 0xD4, 0x02, // ”Ô (U+201D U+00D4)
  0x20, 0x1D, 0x00, 0xD5, 0x02, // ”Õ (U+201D U+00D5)
  0x20, 0x1D, 0x00, 0xD6, 0x02, // ”Ö (U+201D U+00D6)
  0x20, 0x1D, 0x00, 0xD8, 0x02, // ”Ø (U+201D U+00D8)
  0x20, 0x1D, 0x00, 0xE0, 0x03, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x03, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x03, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x03, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x03, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x03, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x03, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x04, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x04, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x04, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x04, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x04, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF0, 0x04, // ”ð (U+201D U+00F0)
  0x20, 0x1D, 0x00, 0xF2, 0x04, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x04, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x04, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x04, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x04, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x04, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x09, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x03, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x09, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x03, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x09, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x03, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x06, 0x02, // ”Ć (U+201D U+0106)
  0x20, 0x1D, 0x01, 0x07, 0x04, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x08, 0x02, // ”Ĉ (U+201D U+0108)
  0x20, 0x1D, 0x01, 0x09, 0x04, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0A, 0x02, // ”Ċ (U+201D U+010A)
  0x20, 0x1D, 0x01, 0x0B, 0x04, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0C, 0x02, // ”Č (U+201D U+010C)
  0x20, 0x1D, 0x01, 0x0D, 0x04, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x04, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x04, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x04, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x04, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x04, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x04, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x04, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1C, 0x02, // ”Ĝ (U+201D U+011C)
  0x20, 0x1D, 0x01, 0x1D, 0x04, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1E, 0x02, // ”Ğ (U+201D U+011E)
  0x20, 0x1D, 0x01, 0x1F, 0x04, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x20, 0x02, // ”Ġ (U+201D U+0120)
  0x20, 0x1D, 0x01, 0x21, 0x04, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x22, 0x02, // ”Ģ (U+201D U+0122)
  0x20, 0x1D, 0x01, 0x23, 0x04, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x4C, 0x02, // ”Ō (U+201D U+014C)
  0x20, 0x1D, 0x01, 0x4D, 0x04, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4E, 0x02, // ”Ŏ (U+201D U+014E)
  0x20, 0x1D, 0x01, 0x4F, 0x04, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x50, 0x02, // ”Ő (U+201D U+0150)
  0x20, 0x1D, 0x01, 0x51, 0x04, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x52, 0x02, // ”Œ (U+201D U+0152)
  0x20, 0x1D, 0x01, 0x53, 0x04, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x5B, 0x05, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5D, 0x05, // ”ŝ (U+201D U+015D)
  0x20, 0x1D, 0x01, 0x5F, 0x05, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x61, 0x05, // ”š (U+201D U+0161)
  0x20, 0x1E, 0x00, 0x3F, 0x06, // „? (U+201E U+003F)
  0x20, 0x1E, 0x00, 0x43, 0x02, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x02, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x02, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x02, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x06, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x55, 0x02, // „U (U+201E U+0055)
  0x20, 0x1E, 0x00, 0x56, 0x09, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x07, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x06, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0x75, 0x01, // „u (U+201E U+0075)
  0x20, 0x1E, 0x00, 0x76, 0x06, // „v (U+201E U+0076)
  0x20, 0x1E, 0x00, 0x77, 0x05, // „w (U+201E U+0077)
  0x20, 0x1E, 0x00, 0x79, 0x05, // „y (U+201E U+0079)
  0x20, 0x1E, 0x00, 0xC7, 0x02, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x02, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x02, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x02, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x02, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x02, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x02, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xD9, 0x02, // „Ù (U+201E U+00D9)
  0x20, 0x1E, 0x00, 0xDA, 0x02, // „Ú (U+201E U+00DA)
  0x20, 0x1E, 0x00, 0xDB, 0x02, // „Û (U+201E U+00DB)
  0x20, 0x1E, 0x00, 0xDC, 0x02, // „Ü (U+201E U+00DC)
  0x20, 0x1E, 0x00, 0xDD, 0x06, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x00, 0xF9, 0x01, // „ù (U+201E U+00F9)
  0x20, 0x1E, 0x00, 0xFA, 0x01, // „ú (U+201E U+00FA)
  0x20, 0x1E, 0x00, 0xFB, 0x01, // „û (U+201E U+00FB)
  0x20, 0x1E, 0x00, 0xFC, 0x01, // „ü (U+201E U+00FC)
  0x20, 0x1E, 0x00, 0xFD, 0x05, // „ý (U+201E U+00FD)
  0x20, 0x1E, 0x00, 0xFF, 0x05, // „ÿ (U+201E U+00FF)
  0x20, 0x1E, 0x01, 0x06, 0x02, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x02, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x02, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x02, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x02, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x02, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x02, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x02, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x02, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x02, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x02, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x02, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x06, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x06, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x06, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x68, 0x02, // „Ũ (U+201E U+0168)
  0x20, 0x1E, 0x01, 0x69, 0x01, // „ũ (U+201E U+0169)
  0x20, 0x1E, 0x01, 0x6A, 0x02, // „Ū (U+201E U+016A)
  0x20, 0x1E, 0x01, 0x6B, 0x01, // „ū (U+201E U+016B)
  0x20, 0x1E, 0x01, 0x6C, 0x02, // „Ŭ (U+201E U+016C)
  0x20, 0x1E, 0x01, 0x6D, 0x01, // „ŭ (U+201E U+016D)
  0x20, 0x1E, 0x01, 0x6E, 0x02, // „Ů (U+201E U+016E)
  0x20, 0x1E, 0x01, 0x6F, 0x01, // „ů (U+201E U+016F)
  0x20, 0x1E, 0x01, 0x70, 0x02, // „Ű (U+201E U+0170)
  0x20, 0x1E, 0x01, 0x71, 0x01, // „ű (U+201E U+0171)
  0x20, 0x1E, 0x01, 0x72, 0x02, // „Ų (U+201E U+0172)
  0x20, 0x1E, 0x01, 0x73, 0x01, // „ų (U+201E U+0173)
  0x20, 0x1E, 0x01, 0x74, 0x07, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x75, 0x05, // „ŵ (U+201E U+0175)
  0x20, 0x1E, 0x01, 0x76, 0x06, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x77, 0x05, // „ŷ (U+201E U+0177)
  0x20, 0x1E, 0x01, 0x78, 0x06, // „Ÿ (U+201E U+0178)
  0x20, 0x26, 0x00, 0x3F, 0x06, // …? (U+2026 U+003F)
  0x20, 0x26, 0x00, 0x43, 0x02, // …C (U+2026 U+0043)
  0x20, 0x26, 0x00, 0x47, 0x02, // …G (U+2026 U+0047)
  0x20, 0x26, 0x00, 0x4F, 0x02, // …O (U+2026 U+004F)
  0x20, 0x26, 0x00, 0x51, 0x02, // …Q (U+2026 U+0051)
  0x20, 0x26, 0x00, 0x54, 0x06, // …T (U+2026 U+0054)
  0x20, 0x26, 0x00, 0x55, 0x02, // …U (U+2026 U+0055)
  0x20, 0x26, 0x00, 0x56, 0x09, // …V (U+2026 U+0056)
  0x20, 0x26, 0x00, 0x57, 0x07, // …W (U+2026 U+0057)
  0x20, 0x26, 0x00, 0x59, 0x06, // …Y (U+2026 U+0059)
  0x20, 0x26, 0x00, 0x75, 0x01, // …u (U+2026 U+0075)
  0x20, 0x26, 0x00, 0x76, 0x06, // …v (U+2026 U+0076)
  0x20, 0x26, 0x00, 0x77, 0x05, // …w (U+2026 U+0077)
  0x20, 0x26, 0x00, 0x79, 0x05, // …y (U+2026 U+0079)
  0x20, 0x26, 0x00, 0xC7, 0x02, // …Ç (U+2026 U+00C7)
  0x20, 0x26, 0x00, 0xD2, 0x02, // …Ò (U+2026 U+00D2)
  0x20, 0x26, 0x00, 0xD3, 0x02, // …Ó (U+2026 U+00D3)
  0x20, 0x26, 0x00, 0xD4, 0x02, // …Ô (U+2026 U+00D4)
  0x20, 0x26, 0x00, 0xD5, 0x02, // …Õ (U+2026 U+00D5)
  0x20, 0x26, 0x00, 0xD6, 0x02, // …Ö (U+2026 U+00D6)
  0x20, 0x26, 0x00, 0xD8, 0x02, // …Ø (U+2026 U+00D8)
  0x20, 0x26, 0x00, 0xD9, 0x02, // …Ù (U+2026 U+00D9)
  0x20, 0x26, 0x00, 0xDA, 0x02, // …Ú (U+2026 U+00DA)
  0x20, 0x26, 0x00, 0xDB, 0x02, // …Û (U+2026 U+00DB)
  0x20, 0x26, 0x00, 0xDC, 0x02, // …Ü (U+2026 U+00DC)
  0x20, 0x26, 0x00, 0xDD, 0x06, // …Ý (U+2026 U+00DD)
  0x20, 0x26, 0x00, 0xF9, 0x01, // …ù (U+2026 U+00F9)
  0x20, 0x26, 0x00, 0xFA, 0x01, // …ú (U+2026 U+00FA)
  0x20, 0x26, 0x00, 0xFB, 0x01, // …û (U+2026 U+00FB)
  0x20, 0x26, 0x00, 0xFC, 0x01, // …ü (U+2026 U+00FC)
  0x20, 0x26, 0x00, 0xFD, 0x05, // …ý (U+2026 U+00FD)
  0x20, 0x26, 0x00, 0xFF, 0x05, // …ÿ (U+2026 U+00FF)
  0x20, 0x26, 0x01, 0x06, 0x02, // …Ć (U+2026 U+0106)
  0x20, 0x26, 0x01, 0x08, 0x02, // …Ĉ (U+2026 U+0108)
  0x20, 0x26, 0x01, 0x0A, 0x02, // …Ċ (U+2026 U+010A)
  0x20, 0x26, 0x01, 0x0C, 0x02, // …Č (U+2026 U+010C)
  0x20, 0x26, 0x01, 0x1C, 0x02, // …Ĝ (U+2026 U+011C)
  0x20, 0x26, 0x01, 0x1E, 0x02, // …Ğ (U+2026 U+011E)
  0x20, 0x26, 0x01, 0x20, 0x02, // …Ġ (U+2026 U+0120)
  0x20, 0x26, 0x01, 0x22, 0x02, // …Ģ (U+2026 U+0122)
  0x20, 0x26, 0x01, 0x4C, 0x02, // …Ō (U+2026 U+014C)
  0x20, 0x26, 0x01, 0x4E, 0x02, // …Ŏ (U+2026 U+014E)
  0x20, 0x26, 0x01, 0x50, 0x02, // …Ő (U+2026 U+0150)
  0x20, 0x26, 0x01, 0x52, 0x02, // …Œ (U+2026 U+0152)
  0x20, 0x26, 0x01, 0x62, 0x06, // …Ţ (U+2026 U+0162)
  0x20, 0x26, 0x01, 0x64, 0x06, // …Ť (U+2026 U+0164)
  0x20, 0x26, 0x01, 0x66, 0x06, // …Ŧ (U+2026 U+0166)
  0x20, 0x26, 0x01, 0x68, 0x02, // …Ũ (U+2026 U+0168)
  0x20, 0x26, 0x01, 0x69, 0x01, // …ũ (U+2026 U+0169)
  0x20, 0x26, 0x01, 0x6A, 0x02, // …Ū (U+2026 U+016A)
  0x20, 0x26, 0x01, 0x6B, 0x01, // …ū (U+2026 U+016B)
  0x20, 0x26, 0x01, 0x6C, 0x02, // …Ŭ (U+2026 U+016C)
  0x20, 0x26, 0x01, 0x6D, 0x01, // …ŭ (U+2026 U+016D)
  0x20, 0x26, 0x01, 0x6E, 0x02, // …Ů (U+2026 U+016E)
  0x20, 0x26, 0x01, 0x6F, 0x01, // …ů (U+2026 U+016F)
  0x20, 0x26, 0x01, 0x70, 0x02, // …Ű (U+2026 U+0170)
  0x20, 0x26, 0x01, 0x71, 0x01, // …ű (U+2026 U+0171)
  0x20, 0x26, 0x01, 0x72, 0x02, // …Ų (U+2026 U+0172)
  0x20, 0x26, 0x01, 0x73, 0x01, // …ų (U+2026 U+0173)
  0x20, 0x26, 0x01, 0x74, 0x07, // …Ŵ (U+2026 U+0174)
  0x20, 0x26, 0x01, 0x75, 0x05, // …ŵ (U+2026 U+0175)
  0x20, 0x26, 0x01, 0x76, 0x06, // …Ŷ (U+2026 U+0176)
  0x20, 0x26, 0x01, 0x77, 0x05, // …ŷ (U+2026 U+0177)
  0x20, 0x26, 0x01, 0x78, 0x06, // …Ÿ (U+2026 U+0178)
  
  // Glyph data
  // "!" (U+0021)
  0x0A, 0xF9, 0x0D, 0x09, 0xF9, 0x0C, 0x09, 0xF9, 0x0B, 0x08, 0xF9, 0x0A, 0x07, 0xF9, 0x0A, 0x06,
  0xF9, 0x09, 0x05, 0xF9, 0x08, 0x04, 0xF9, 0x07, 0x03, 0xF9, 0x06, 0x02, 0xF9, 0x05, 0x01, 0xF9,
  0x04, 0x01, 0xF9, 0x03, 0x1F, 0x98, 0x13, 0x0E, 0xF8, 0x12, 0x0D, 0xF8, 0x11, 0x0D, 0xF2, 0x0C,
  0xF2, 0x0B, 0xE0, 0xE2, 0x0A, 0xE0, 0xD2, 0x09, 0xE0, 0xC2, 0x08, 0xE0, 0xB2, 0x07, 0xE0, 0xA2,
  0x06, 0xE0, 0x92, 0x06, 0xE0, 0x82, 0x05, 0xE0, 0x72, 0x04, 0xE0, 0x72, 0x03, 0xE0, 0x62, 0x02,
  0xE0, 0x52, 0x01, 0xE0, 0x43, 0xE0, 0x33, 0xE0, 0x23, 0x0E, 0xD0, 0x13, 0x0D, 0xD4, 0x0C, 0xD4,
  0x0B, 0xC0, 0xE4, 0x0B, 0xC0, 0xD4, 0x0A, 0xC0, 0xC4, 0x09, 0xC0, 0xC4, 0x08, 0xC0, 0xB4, 0x07,
  0xC0, 0xA4, 0x06, 0xC0, 0x94, 0x05, 0xC0, 0x84, 0x04, 0xC0, 0x74, 0x03, 0xC0, 0x64, 0x03, 0xC0,
  0x54, 0x02, 0xC0, 0x58, 0x09, 0xA0, 0x08, 0x45, 0xBE, 0xFC, 0x73, 0x09, 0xE8, 0x1B, 0x04, 0xF9,
  0x07, 0x09, 0xF9, 0x0C, 0x0B, 0xF9, 0x0E, 0x0C, 0xFA, 0x0B, 0xF9, 0x0E, 0x09, 0xF9, 0x0C, 0x04,
  0xF9, 0x81, 0x70, 0x9E, 0x0B, 0x38, 0x45, 0xBE, 0xFC, 0x72,
  // """ (U+0022)
  0x05, 0xF9, 0x03, 0x50, 0x9F, 0x90, 0x10, 0x3F, 0x90, 0x25, 0x07, 0xF9, 0x10, 0x1F, 0x96, 0x05,
  0xF0, 0xD2, 0xF0, 0xD6, 0x03, 0xF0, 0xB2, 0x0D, 0xE0, 0xB6, 0x01, 0xF0, 0x92, 0x0B, 0xE0, 0xA7,
  0xF0, 0x72, 0x09, 0xE0, 0x87, 0x0D, 0xE0, 0x62, 0x07, 0xE0, 0x67, 0x0B, 0xE0, 0x42, 0x06, 0xE0,
  0x47, 0x09, 0xE0, 0x22, 0x04, 0xE0, 0x27, 0x07, 0xE3, 0x02, 0xE7, 0x10, 0x6D, 0x0E, 0x4D, 0x0E,
  0x71, 0x04, 0xD0, 0xC4, 0x0E, 0xC0, 0xC7, 0x10, 0x2D, 0x0A, 0x40, 0xCC, 0x0A, 0x72, 0xD0, 0x84,
  0x0A, 0xC0, 0x87, 0x20, 0xEC, 0x06, 0x40, 0x8C, 0x07, 0x72, 0x0C, 0xC0, 0x44, 0x06, 0xC0, 0x57,
  0x20, 0xAC, 0x03, 0x40, 0x4C, 0x03, 0x72, 0x08, 0xC0, 0x14, 0x03, 0xC0, 0x17, 0x20, 0x6B, 0x0E,
  0x50, 0x1C, 0x73, 0x04, 0xB0, 0xC6, 0x0E, 0xA0, 0xD7, 0x30, 0x2B, 0x0B, 0x30,
  // "#" (U+0023)
  0x77, 0x10, 0x1D, 0x73, 0x0A, 0xC0, 0x67, 0x75, 0x04, 0xC0, 0xD7, 0x30, 0xDC, 0x03, 0x77, 0x50,
  0x7C, 0x0A, 0x73, 0xD7, 0x76, 0x09, 0xC0, 0x77, 0x20, 0x3C, 0x0D, 0x77, 0x60, 0xCC, 0x04, 0x72,
  0x06, 0xC0, 0xA7, 0x76, 0xD0, 0x17, 0x20, 0x9C, 0x07, 0x77, 0x50, 0x2C, 0x0E, 0x73, 0x0C, 0xC0,
  0x47, 0x75, 0x05, 0xC0, 0xB7, 0x3D, 0x01, 0x77, 0x50, 0x8C, 0x08, 0x72, 0x02, 0xC0, 0xE7, 0x76,
  0x0B, 0xC0, 0x57, 0x20, 0x5C, 0x0B, 0x77, 0x60, 0xEC, 0x02, 0x72, 0x08, 0xC0, 0x87, 0x75, 0x01,
  0xC0, 0xE7, 0x30, 0xBC, 0x05, 0x77, 0x50, 0x4C, 0x0B, 0x73, 0x0E, 0xC0, 0x27, 0x75, 0x07, 0xC0,
  0x87, 0x20, 0x1C, 0x0E, 0x77, 0x60, 0xAC, 0x05, 0x72, 0x04, 0xC0, 0xB7, 0x76, 0x0D, 0xC0, 0x37,
  0x20, 0x7C, 0x09, 0x77, 0x6D, 0x73, 0x0A, 0xC0, 0x67, 0x75, 0x03, 0xC0, 0xC7, 0x30, 0xDC, 0x03,
  0x73, 0x80, 0xC1, 0xF0, 0xD3, 0x80, 0xC1, 0xF0, 0xD3, 0x80, 0xC1, 0xF0, 0xD3, 0x80, 0xC1, 0xF0,
  0xD3, 0x80, 0x49, 0x0B, 0xC0, 0xE8, 0x06, 0x90, 0xEC, 0x0A, 0x80, 0x39, 0x07, 0x74, 0x07, 0xC0,
  0x97, 0x3D, 0x77, 0x60, 0xAC, 0x07, 0x72, 0x02, 0xC0, 0xD7, 0x76, 0x0D, 0xC0, 0x47, 0x20, 0x5C,
  0x0A, 0x77, 0x6D, 0x01, 0x72, 0x08, 0xC0, 0x77, 0x75, 0x03, 0xC0, 0xE7, 0x30, 0xBC, 0x04, 0x77,
  0x50, 0x5C, 0x0B, 0x73, 0x0E, 0xC0, 0x17, 0x75, 0x08, 0xC0, 0x87, 0x20, 0x1C, 0x0E, 0x77, 0x60,
  0xBC, 0x05, 0x72, 0x04, 0xC0, 0xB7, 0x76, 0x0E, 0xC0, 0x27, 0x20, 0x7C, 0x08, 0x77, 0x50, 0x1D,
  0x73, 0x0A, 0xC0, 0x57, 0x75, 0x04, 0xC0, 0xC7, 0x30, 0xDC, 0x02, 0x77, 0x50, 0x7C, 0x09, 0x73,
  0xD7, 0x76, 0x0A, 0xC0, 0x67, 0x20, 0x3C, 0x0C, 0x77, 0x60, 0xCC, 0x03, 0x72, 0x06, 0xC0, 0x97,
  0x76, 0xD7, 0x30, 0x9C, 0x06, 0x77, 0x50, 0x3C, 0x0D, 0x73, 0x0C, 0xC0, 0x47, 0x75, 0x05, 0xC0,
  0xA7, 0x30, 0xEC, 0x01, 0x77, 0x50, 0x8C, 0x07, 0x72, 0x02, 0xC0, 0xD7, 0x50, 0xE8, 0x0C, 0x1F,
  0x30, 0xE8, 0x0C, 0x1F, 0x30, 0xE8, 0x0C, 0x1F, 0x30, 0xE8, 0x0C, 0x1F, 0x30, 0x88, 0x02, 0x90,
  0xDC, 0x0C, 0x80, 0x59, 0x0A, 0xC0, 0xE8, 0x05, 0x90, 0x87, 0x30, 0xCC, 0x05, 0x72, 0x06, 0xC0,
  0xB7, 0x76, 0xD0, 0x27, 0x20, 0x9C, 0x08, 0x77, 0x50, 0x2C, 0x0E, 0x73, 0x0C, 0xC0, 0x57, 0x75,
  0x05, 0xC0, 0xB7, 0x30, 0xEC, 0x02, 0x77, 0x50, 0x8C, 0x08, 0x72, 0x02, 0xC0, 0xE7, 0x76, 0x0B,
  0xC0, 0x57, 0x20, 0x5C, 0x0B, 0x77, 0x60, 0xEC, 0x02, 0x72, 0x08, 0xC0, 0x87, 0x75, 0x01, 0xD7,
  0x30, 0xBC, 0x05, 0x77, 0x50, 0x4C, 0x0C, 0x73, 0x0D, 0xC0, 0x27, 0x75, 0x07, 0xC0, 0x97, 0x20,
  0x1D, 0x77, 0x60, 0xAC, 0x06, 0x72, 0x04, 0xC0, 0xC7, 0x76, 0x0D, 0xC0, 0x37, 0x20, 0x7C, 0x09,
  0x77, 0x6D, 0x73, 0x09, 0xC0, 0x67, 0x75, 0x03, 0xC0, 0xD7, 0x30, 0xCC, 0x03, 0x77, 0x50, 0x6C,
  0x0A, 0x73, 0xD7, 0x76, 0x09, 0xC0, 0x77, 0x20, 0x3C, 0x0D, 0x77, 0x60, 0xBC, 0x04, 0x72, 0x05,
  0xC0, 0xA7, 0x76, 0x0E, 0xC0, 0x17, 0x20, 0x8C, 0x07, 0x77, 0x20,
  // "$" (U+0024)
  0x77, 0x10, 0x5B, 0x06, 0x77, 0x77, 0x10, 0x5B, 0x06, 0x77, 0x77, 0x10, 0x5B, 0x06, 0x77, 0x77,
  0x10, 0x5B, 0x06, 0x77, 0x77, 0x10, 0x5B, 0x06, 0x77, 0x77, 0x10, 0x5B, 0x06, 0x77, 0x77, 0x10,
  0x6B, 0x07, 0x77, 0x75, 0x81, 0x6A, 0xDF, 0x82, 0xDB, 0x73, 0x77, 0x30, 0x20, 0xAF, 0xF9, 0x0C,
  0x05, 0x77, 0x08, 0xFF, 0xD0, 0xA7, 0x40, 0x20, 0xCE, 0x0E, 0x0D, 0xB0, 0xC0, 0xDF, 0x90, 0xB7,
  0x20, 0x20, 0xED, 0x82, 0xE7, 0x05, 0xB8, 0x26, 0x02, 0xBF, 0x09, 0x70, 0x10, 0xDD, 0x0D, 0x02,
  0x20, 0x5B, 0x06, 0x30, 0xBF, 0x03, 0x60, 0xAD, 0x0E, 0x02, 0x30, 0x5B, 0x06, 0x30, 0x10, 0xEE,
  0x0A, 0x50, 0x3E, 0x07, 0x40, 0x5B, 0x06, 0x40, 0x7E, 0x0E, 0x50, 0xBD, 0x0E, 0x50, 0x5B, 0x06,
  0x40, 0x1F, 0x02, 0x4E, 0x0A, 0x50, 0x5B, 0x06, 0x50, 0xCE, 0x03, 0x30, 0x4E, 0x06, 0x50, 0x5B,
  0x06, 0x50, 0x8E, 0x02, 0x30, 0x7E, 0x04, 0x50, 0x5B, 0x06, 0x50, 0x5D, 0x0E, 0x40, 0x9E, 0x03,
  0x50, 0x5B, 0x06, 0x50, 0x3D, 0x08, 0x40, 0xAE, 0x04, 0x50, 0x5B, 0x06, 0x50, 0x2C, 0x0C, 0x50,
  0xAE, 0x05, 0x50, 0x5B, 0x06, 0x50, 0x1A, 0x0E, 0x08, 0x60, 0x9E, 0x07, 0x50, 0x5B, 0x06, 0x60,
  0x40, 0x37, 0x10, 0x8E, 0x0B, 0x50, 0x5B, 0x06, 0x77, 0x20, 0x5F, 0x01, 0x40, 0x5B, 0x06, 0x77,
  0x20, 0x2F, 0x08, 0x40, 0x5B, 0x06, 0x77, 0x30, 0xEF, 0x04, 0x30, 0x5B, 0x06, 0x77, 0x30, 0x8F,
  0x0E, 0x03, 0x20, 0x5B, 0x06, 0x77, 0x30, 0x2F, 0x98, 0x2E, 0x50, 0x5B, 0x06, 0x77, 0x40, 0x8F,
  0xA0, 0xA0, 0x7B, 0x06, 0x77, 0x50, 0xDF, 0xE0, 0x67, 0x75, 0x02, 0x0E, 0xFD, 0x06, 0x77, 0x60,
  0x30, 0xEF, 0xC0, 0xE0, 0x67, 0x76, 0x02, 0x0D, 0xFD, 0x0D, 0x05, 0x77, 0x50, 0x10, 0xAF, 0xE0,
  0xB0, 0x17, 0x75, 0x05, 0x0E, 0xFD, 0x0E, 0x06, 0x77, 0x50, 0x10, 0x9F, 0xE0, 0xA7, 0x76, 0x02,
  0x0A, 0xFD, 0x0D, 0x02, 0x77, 0x60, 0x6F, 0xD0, 0xD0, 0x27, 0x75, 0x05, 0xFE, 0x0D, 0x02, 0x77,
  0x40, 0x5B, 0x08, 0x0B, 0xFA, 0x0C, 0x77, 0x40, 0x5B, 0x81, 0x60, 0x6F, 0xA0, 0x87, 0x73, 0x05,
  0xB0, 0x62, 0x03, 0x0E, 0xF9, 0x02, 0x77, 0x20, 0x5B, 0x06, 0x30, 0x20, 0xEF, 0x09, 0x77, 0x20,
  0x5B, 0x06, 0x40, 0x3F, 0x0E, 0x77, 0x20, 0x5B, 0x06, 0x50, 0x9F, 0x03, 0x40, 0x10, 0x37, 0x20,
  0x5B, 0x06, 0x50, 0x1F, 0x07, 0x20, 0x20, 0xBA, 0x04, 0x71, 0x05, 0xB0, 0x66, 0x0B, 0xE8, 0x29,
  0x02, 0xEB, 0x06, 0x71, 0x05, 0xB0, 0x66, 0x07, 0xE8, 0x1B, 0x0C, 0xC0, 0x87, 0x10, 0x5B, 0x06,
  0x60, 0x5E, 0x0C, 0x04, 0xD0, 0xB7, 0x10, 0x5B, 0x06, 0x60, 0x4E, 0x0B, 0x07, 0xD0, 0xE7, 0x10,
  0x5B, 0x06, 0x60, 0x3E, 0x09, 0x08, 0xE0, 0x27, 0x05, 0xB0, 0x66, 0x04, 0xE0, 0x80, 0x7E, 0x07,
  0x70, 0x5B, 0x06, 0x60, 0x7E, 0x04, 0x06, 0xE0, 0xC7, 0x05, 0xB0, 0x66, 0x0A, 0xE1, 0x03, 0xF0,
  0x36, 0x05, 0xB0, 0x65, 0x01, 0x0E, 0xD0, 0xB2, 0x0E, 0xE0, 0xB6, 0x05, 0xB0, 0x65, 0x07, 0xE0,
  0x32, 0x09, 0xF0, 0x55, 0x05, 0xB0, 0x64, 0x02, 0xE0, 0xB3, 0x01, 0x0E, 0xE0, 0xE0, 0x44, 0x05,
  0xB0, 0x63, 0x02, 0x0D, 0xD0, 0xE0, 0x14, 0x06, 0xF9, 0x07, 0x30, 0x5B, 0x06, 0x20, 0x50, 0xEE,
  0x03, 0x60, 0x7F, 0x98, 0x2E, 0x84, 0x7B, 0x81, 0x98, 0xDE, 0x0E, 0x03, 0x71, 0x07, 0xFF, 0xF9,
  0x0B, 0x01, 0x73, 0x02, 0x0B, 0xFF, 0xC0, 0xD0, 0x57, 0x78, 0x13, 0x9E, 0xFD, 0x81, 0xE9, 0x47,
  0x75, 0x84, 0x14, 0x78, 0x9C, 0xB8, 0x1B, 0x62, 0x77, 0x76, 0x05, 0xB0, 0x67, 0x77, 0x71, 0x05,
  0xB0, 0x67, 0x77, 0x71, 0x05, 0xB0, 0x67, 0x77, 0x71, 0x05, 0xB0, 0x67, 0x77, 0x71, 0x05, 0xB0,
  0x67, 0x77, 0x71, 0x05, 0xB0, 0x67, 0x77, 0x71, 0x05, 0xB0, 0x67, 0x77, 0x71, 0x05, 0xB0, 0x67,
  0x77, 0x71, 0x05, 0xB0, 0x67, 0x77, 0x71, 0x05, 0xB0, 0x67, 0x77, 0x71, 0x83, 0x27, 0x77, 0x37,
  0x70,
  // "%" (U+0025)
  0x71, 0x89, 0x02, 0x7B, 0xDE, 0xFE, 0xC8, 0x38, 0x0D, 0x70, 0x02, 0x0B, 0xFB, 0x0C, 0x03, 0x77,
  0x71, 0x0B, 0xC0, 0x57, 0x76, 0x05, 0xFF, 0x05, 0x77, 0x60, 0x2C, 0x0E, 0x77, 0x60, 0x4D, 0x84,
  0xD5, 0x10, 0x3B, 0xD0, 0x57, 0x75, 0x09, 0xC0, 0x77, 0x75, 0x01, 0x0E, 0xC0, 0xD0, 0x15, 0x09,
  0xD0, 0x37, 0x73, 0x01, 0xD0, 0x17, 0x75, 0x0A, 0xD0, 0x37, 0x0E, 0xC0, 0xC7, 0x73, 0x07, 0xC0,
  0xA7, 0x75, 0x02, 0xD0, 0xB7, 0x10, 0x7D, 0x04, 0x77, 0x20, 0xDC, 0x03, 0x77, 0x50, 0x9D, 0x06,
  0x71, 0x02, 0xD0, 0xC7, 0x71, 0x05, 0xC0, 0xC7, 0x76, 0xE0, 0x27, 0x20, 0xED, 0x03, 0x77, 0x0B,
  0xC0, 0x67, 0x75, 0x04, 0xD0, 0xE7, 0x30, 0xAD, 0x08, 0x76, 0x02, 0xC0, 0xE7, 0x76, 0x08, 0xD0,
  0xB7, 0x30, 0x7D, 0x0C, 0x76, 0x09, 0xC0, 0x87, 0x76, 0x0D, 0xD0, 0x97, 0x30, 0x5E, 0x01, 0x74,
  0x01, 0x0E, 0xC0, 0x27, 0x76, 0xE0, 0x77, 0x30, 0x3E, 0x04, 0x74, 0x07, 0xC0, 0xA7, 0x76, 0x02,
  0xE0, 0x57, 0x30, 0x2E, 0x07, 0x74, 0x0D, 0xC0, 0x47, 0x76, 0x05, 0xE0, 0x47, 0x30, 0x1E, 0x09,
  0x73, 0x05, 0xC0, 0xD7, 0x77, 0x07, 0xE0, 0x37, 0x4E, 0x0B, 0x73, 0x0B, 0xC0, 0x67, 0x77, 0x08,
  0xE0, 0x27, 0x40, 0xED, 0x0C, 0x72, 0x02, 0xC0, 0xE7, 0x77, 0x10, 0x8E, 0x02, 0x74, 0x0E, 0xD0,
  0xD7, 0x20, 0x9C, 0x08, 0x77, 0x71, 0x09, 0xE0, 0x17, 0x40, 0xDD, 0x0E, 0x71, 0x01, 0x0E, 0xC0,
  0x27, 0x77, 0x10, 0xAE, 0x01, 0x74, 0x0D, 0xD0, 0xE7, 0x10, 0x7C, 0x0B, 0x77, 0x72, 0x0A, 0xE0,
  0x17, 0x40, 0xDD, 0x0E, 0x71, 0x0D, 0xC0, 0x47, 0x77, 0x20, 0x9E, 0x01, 0x74, 0x0D, 0xD0, 0xE7,
  0x04, 0xC0, 0xD7, 0x77, 0x30, 0x8E, 0x02, 0x74, 0x0E, 0xD0, 0xD7, 0x0B, 0xC0, 0x67, 0x77, 0x30,
  0x8E, 0x02, 0x74, 0x0E, 0xD0, 0xC6, 0x02, 0xC0, 0xE0, 0x17, 0x77, 0x30, 0x6E, 0x03, 0x74, 0xE0,
  0xB6, 0x09, 0xC0, 0x97, 0x77, 0x40, 0x4E, 0x04, 0x73, 0x01, 0xE0, 0x95, 0x01, 0x0E, 0xC0, 0x27,
  0x77, 0x40, 0x2E, 0x05, 0x73, 0x02, 0xE0, 0x65, 0x07, 0xC0, 0xB7, 0x18, 0x24, 0x9C, 0xEA, 0x82,
  0xDB, 0x72, 0x72, 0xE0, 0x77, 0x30, 0x3E, 0x04, 0x50, 0xDC, 0x05, 0x60, 0x40, 0xDF, 0xB0, 0x90,
  0x17, 0x0C, 0xD0, 0x97, 0x30, 0x5E, 0x01, 0x40, 0x4C, 0x0D, 0x60, 0x8F, 0xE0, 0xD0, 0x26, 0x08,
  0xD0, 0xB7, 0x30, 0x8D, 0x0B, 0x50, 0xBC, 0x07, 0x50, 0x9D, 0x84, 0xB3, 0x01, 0x5D, 0xC0, 0xE0,
  0x25, 0x03, 0xD0, 0xE7, 0x30, 0xAD, 0x07, 0x40, 0x2D, 0x01, 0x40, 0x5D, 0x0A, 0x50, 0x10, 0xDC,
  0x0D, 0x60, 0xED, 0x02, 0x72, 0x0E, 0xD0, 0x24, 0x09, 0xC0, 0x95, 0x0E, 0xC0, 0xE7, 0x03, 0xD0,
  0x85, 0x08, 0xD0, 0x67, 0x10, 0x2D, 0x0A, 0x50, 0xEC, 0x03, 0x40, 0x6D, 0x07, 0x71, 0x0C, 0xC0,
  0xE0, 0x14, 0x01, 0xD0, 0xB7, 0x10, 0x7D, 0x03, 0x40, 0x6C, 0x0C, 0x50, 0xDD, 0x02, 0x71, 0x07,
  0xD0, 0x75, 0x09, 0xD0, 0x37, 0x0E, 0xC0, 0xB5, 0x0D, 0xC0, 0x54, 0x04, 0xD0, 0xD7, 0x20, 0x3D,
  0x0E, 0x50, 0x10, 0xEC, 0x0D, 0x01, 0x50, 0xAC, 0x0E, 0x02, 0x40, 0x4C, 0x0E, 0x50, 0x9D, 0x09,
  0x73, 0x0E, 0xD0, 0x35, 0x04, 0xD0, 0xD0, 0x52, 0x03, 0x0B, 0xD0, 0x45, 0x0B, 0xC0, 0x75, 0x0D,
  0xD0, 0x77, 0x30, 0xCD, 0x08, 0x60, 0x40, 0xEF, 0xE0, 0x55, 0x02, 0xD0, 0x14, 0x02, 0xE0, 0x47,
  0x30, 0xAD, 0x0C, 0x70, 0x20, 0xBF, 0xB0, 0xB0, 0x26, 0x09, 0xC0, 0xA5, 0x04, 0xE0, 0x27, 0x30,
  0x7E, 0x72, 0x82, 0x27, 0xBE, 0xA8, 0x2E, 0xB8, 0x37, 0x10, 0xEC, 0x03, 0x50, 0x7E, 0x01, 0x73,
  0x06, 0xE0, 0x27, 0x77, 0x40, 0x6C, 0x0C, 0x60, 0x9E, 0x74, 0x05, 0xE0, 0x57, 0x77, 0x40, 0xDC,
  0x05, 0x60, 0xBD, 0x0E, 0x74, 0x04, 0xE0, 0x77, 0x77, 0x30, 0x4C, 0x0E, 0x70, 0xCD, 0x0D, 0x74,
  0x03, 0xE0, 0x87, 0x77, 0x30, 0xBC, 0x08, 0x70, 0xDD, 0x0D, 0x74, 0x03, 0xE0, 0x97, 0x77, 0x20,
  0x2D, 0x01, 0x70, 0xDD, 0x0C, 0x74, 0x02, 0xE0, 0x97, 0x77, 0x20, 0x8C, 0x0A, 0x71, 0x0E, 0xD0,
  0xC7, 0x40, 0x2E, 0x0A, 0x77, 0x72, 0x0E, 0xC0, 0x47, 0x10, 0xED, 0x0C, 0x74, 0x02, 0xE0, 0xA7,
  0x77, 0x10, 0x6C, 0x0C, 0x72, 0x0D, 0xD0, 0xC7, 0x40, 0x2E, 0x09, 0x77, 0x71, 0x0D, 0xC0, 0x67,
  0x20, 0xDD, 0x0D, 0x74, 0x03, 0xE0, 0x97, 0x77, 0x04, 0xC0, 0xE7, 0x30, 0xCD, 0x0D, 0x74, 0x03,
  0xE0, 0x87, 0x77, 0x0B, 0xC0, 0x87, 0x30, 0xBD, 0x0E, 0x74, 0x04, 0xE0, 0x77, 0x76, 0x02, 0xD0,
  0x27, 0x30, 0x8E, 0x74, 0x05, 0xE0, 0x47, 0x76, 0x08, 0xC0, 0xB7, 0x40, 0x6E, 0x01, 0x73, 0x06,
  0xE0, 0x27, 0x76, 0x0E, 0xC0, 0x47, 0x40, 0x4E, 0x02, 0x73, 0x08, 0xE7, 0x76, 0x06, 0xC0, 0xD7,
  0x50, 0x1E, 0x04, 0x73, 0x0A, 0xD0, 0xB7, 0x76, 0x0D, 0xC0, 0x67, 0x60, 0xCD, 0x07, 0x73, 0x0C,
  0xD0, 0x77, 0x75, 0x04, 0xC0, 0xE7, 0x70, 0x8D, 0x09, 0x73, 0x0E, 0xD0, 0x27, 0x75, 0x0A, 0xC0,
  0x97, 0x70, 0x3D, 0x0D, 0x72, 0x03, 0xD0, 0xD7, 0x75, 0x02, 0xD0, 0x27, 0x71, 0x0C, 0xD0, 0x27,
  0x10, 0x7D, 0x06, 0x77, 0x50, 0x8C, 0x0B, 0x77, 0x20, 0x5D, 0x07, 0x71, 0x0C, 0xC0, 0xE7, 0x76,
  0x0E, 0xC0, 0x47, 0x73, 0x0D, 0xC0, 0xE7, 0x03, 0xD0, 0x77, 0x75, 0x06, 0xC0, 0xD7, 0x74, 0x04,
  0xD0, 0xA5, 0x01, 0x0D, 0xC0, 0xC7, 0x76, 0x0C, 0xC0, 0x77, 0x75, 0x08, 0xD8, 0x4B, 0x30, 0x15,
  0xDC, 0x0E, 0x01, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x60, 0x8F, 0xE0, 0xD0, 0x27, 0x76, 0x0A, 0xC0,
  0x97, 0x77, 0x10, 0x40, 0xDF, 0xB0, 0x98, 0x0E, 0x00, 0x82, 0x49, 0xCE, 0xA8, 0x2D, 0xB7, 0x17,
  0x10,
  // "&" (U+0026)
  0x77, 0x28, 0x92, 0x47, 0xBC, 0xDE, 0xFE, 0xDB, 0x84, 0x80, 0xC5, 0x08, 0x11, 0x8E, 0xFD, 0x0E,
  0x07, 0x80, 0xC2, 0x00, 0x6F, 0xFB, 0x0D, 0x04, 0x77, 0x77, 0x70, 0x8F, 0xFE, 0x05, 0x77, 0x77,
  0x50, 0x7F, 0xA8, 0x3C, 0xA9, 0xBE, 0xF9, 0x04, 0x77, 0x77, 0x30, 0x3F, 0x90, 0x90, 0x15, 0x04,
  0x0D, 0xE0, 0xE7, 0x77, 0x73, 0x0C, 0xF0, 0x57, 0x10, 0x10, 0xDE, 0x07, 0x77, 0x77, 0x10, 0x4F,
  0x08, 0x73, 0x03, 0xE0, 0xE7, 0x77, 0x71, 0x0A, 0xE0, 0xE7, 0x50, 0xAE, 0x04, 0x77, 0x77, 0x0E,
  0xE0, 0x97, 0x50, 0x5E, 0x08, 0x77, 0x76, 0x02, 0xF0, 0x57, 0x50, 0x1E, 0x0A, 0x77, 0x76, 0x04,
  0xF0, 0x27, 0x60, 0xDD, 0x0C, 0x77, 0x76, 0x05, 0xF0, 0x17, 0x60, 0xCD, 0x0D, 0x77, 0x76, 0x06,
  0xF7, 0x70, 0xCD, 0x0D, 0x77, 0x76, 0x06, 0xF0, 0x17, 0x60, 0xDD, 0x0B, 0x77, 0x76, 0x05, 0xF0,
  0x27, 0x60, 0xED, 0x0A, 0x77, 0x76, 0x03, 0xF0, 0x47, 0x50, 0x1E, 0x07, 0x77, 0x76, 0x01, 0xF0,
  0x87, 0x50, 0x4E, 0x03, 0x77, 0x77, 0x0E, 0xE0, 0xD7, 0x50, 0x9D, 0x0D, 0x77, 0x77, 0x10, 0xAF,
  0x03, 0x74, 0x0E, 0xD0, 0x77, 0x77, 0x71, 0x05, 0xF0, 0xA7, 0x30, 0x7D, 0x0E, 0x01, 0x77, 0x77,
  0x20, 0xEF, 0x03, 0x71, 0x02, 0x0E, 0xD0, 0x57, 0x77, 0x73, 0x07, 0xF0, 0xC7, 0x01, 0x0D, 0xD0,
  0x97, 0x77, 0x75, 0x0D, 0xF0, 0x65, 0x02, 0x0D, 0xD0, 0x97, 0x77, 0x76, 0x05, 0xF0, 0xE0, 0x23,
  0x05, 0x0E, 0xD0, 0x88, 0x0C, 0x00, 0x0B, 0xF8, 0x2C, 0x01, 0xAD, 0x0E, 0x05, 0x80, 0xC1, 0x00,
  0x20, 0xEF, 0x0B, 0xE0, 0xA0, 0x18, 0x0C, 0x30, 0x05, 0xFD, 0x0D, 0x05, 0x74, 0x07, 0xFE, 0x09,
  0x77, 0x20, 0xCF, 0xA0, 0xD0, 0x67, 0x60, 0x7F, 0xE0, 0x97, 0x70, 0x30, 0xBF, 0xB0, 0x87, 0x70,
  0x7F, 0xE0, 0x97, 0x50, 0x10, 0x9F, 0xE0, 0x47, 0x60, 0x7F, 0xE0, 0x97, 0x40, 0x40, 0xEF, 0xF0,
  0xE0, 0x27, 0x50, 0x8F, 0x98, 0x2A, 0x52, 0x17, 0x50, 0x8F, 0x0B, 0x08, 0xF9, 0x0C, 0x75, 0x08,
  0xE0, 0xE0, 0x47, 0x71, 0x0B, 0xF0, 0x82, 0x0A, 0xF9, 0x09, 0x74, 0x09, 0xE0, 0x37, 0x71, 0x0B,
  0xF0, 0x74, 0x0D, 0xF9, 0x06, 0x73, 0x09, 0xD0, 0xA7, 0x71, 0x09, 0xF0, 0x85, 0x02, 0x0E, 0xF9,
  0x03, 0x72, 0x0B, 0xD0, 0x47, 0x70, 0x4F, 0x0C, 0x70, 0x5F, 0x90, 0xD0, 0x17, 0x10, 0xCC, 0x0E,
  0x77, 0x10, 0xDF, 0x02, 0x71, 0x08, 0xF9, 0x0B, 0x71, 0x0D, 0xC0, 0xB7, 0x70, 0x7F, 0x09, 0x73,
  0x0B, 0xF9, 0x08, 0x70, 0xEC, 0x07, 0x77, 0x0D, 0xF0, 0x27, 0x30, 0x10, 0xDF, 0x90, 0x45, 0x01,
  0xD0, 0x47, 0x60, 0x4F, 0x0D, 0x75, 0x02, 0x0E, 0xF0, 0xE0, 0x24, 0x03, 0xD7, 0x70, 0x8F, 0x08,
  0x76, 0x05, 0xF9, 0x0C, 0x40, 0x5C, 0x0C, 0x77, 0x0C, 0xF0, 0x57, 0x70, 0x8F, 0x90, 0x93, 0x08,
  0xC0, 0x87, 0x70, 0xEF, 0x03, 0x77, 0x10, 0xBF, 0x90, 0x62, 0x0B, 0xC0, 0x37, 0x60, 0x1F, 0x90,
  0x17, 0x71, 0x01, 0x0D, 0xF9, 0x81, 0x30, 0xEB, 0x0E, 0x77, 0x02, 0xF9, 0x77, 0x30, 0x3F, 0x90,
  0xD0, 0x4C, 0x0A, 0x77, 0x02, 0xF9, 0x77, 0x40, 0x6F, 0x90, 0xEC, 0x05, 0x77, 0x02, 0xF9, 0x77,
  0x50, 0x9F, 0xC0, 0xE7, 0x71, 0x02, 0xF9, 0x77, 0x60, 0xCF, 0xB0, 0x97, 0x71, 0x01, 0xF9, 0x01,
  0x77, 0x50, 0x10, 0xEF, 0xA0, 0x37, 0x72, 0xF9, 0x03, 0x77, 0x60, 0x3F, 0xA0, 0x67, 0x72, 0x0D,
  0xF0, 0x67, 0x77, 0x06, 0xFA, 0x04, 0x77, 0x10, 0xAF, 0x09, 0x77, 0x71, 0x09, 0xF9, 0x0E, 0x02,
  0x77, 0x06, 0xF0, 0xD7, 0x77, 0x10, 0x1F, 0xA0, 0xD0, 0x17, 0x60, 0x1F, 0x90, 0x47, 0x77, 0x0A,
  0xFB, 0x0C, 0x77, 0x0B, 0xF0, 0xB7, 0x76, 0x07, 0xFD, 0x0A, 0x76, 0x05, 0xF9, 0x05, 0x77, 0x40,
  0x6C, 0x0E, 0xFA, 0x08, 0x76, 0x0C, 0xF0, 0xE0, 0x27, 0x72, 0x07, 0xD0, 0x40, 0x7F, 0xA0, 0x57,
  0x50, 0x3F, 0x90, 0xE0, 0x37, 0x60, 0x10, 0xAD, 0x07, 0x20, 0xBF, 0xA0, 0x47, 0x50, 0x8F, 0xA0,
  0x80, 0x17, 0x30, 0x60, 0xED, 0x09, 0x30, 0x10, 0xDF, 0xA0, 0x47, 0x50, 0xBF, 0xA8, 0x91, 0xE9,
  0x52, 0x10, 0x12, 0x59, 0xEE, 0x09, 0x50, 0x3F, 0xB8, 0x2B, 0x52, 0x17, 0x20, 0xBF, 0xFF, 0xB0,
  0x77, 0x07, 0xFF, 0x90, 0x17, 0x09, 0xFF, 0xF0, 0xE0, 0x47, 0x20, 0xAF, 0xF0, 0x17, 0x10, 0x40,
  0xDF, 0xFC, 0x09, 0x01, 0x73, 0x01, 0x0D, 0xFE, 0x01, 0x73, 0x05, 0x0C, 0xFE, 0x81, 0xE9, 0x37,
  0x60, 0x3F, 0xE0, 0x17, 0x58, 0x41, 0x59, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x57, 0x77, 0x73,
  // "'" (U+0027)
  0x05, 0xF9, 0x00, 0x3F, 0x90, 0x20, 0x1F, 0x92, 0xF0, 0xD2, 0x0D, 0xE0, 0xB2, 0x0B, 0xE0, 0xA2,
  0x09, 0xE0, 0x82, 0x07, 0xE0, 0x62, 0x06, 0xE0, 0x42, 0x04, 0xE0, 0x22, 0x02, 0xE4, 0xD0, 0xE4,
  0x0E, 0xC0, 0xC4, 0x0C, 0xC0, 0xA4, 0x0A, 0xC0, 0x84, 0x08, 0xC0, 0x74, 0x06, 0xC0, 0x54, 0x04,
  0xC0, 0x34, 0x03, 0xC0, 0x14, 0x01, 0xC6, 0x0E, 0xA0, 0xD3,
  // "(" (U+0028)
  0x77, 0x60, 0x17, 0x74, 0x81, 0x29, 0xC7, 0x72, 0x01, 0x09, 0xA0, 0xD7, 0x71, 0x06, 0x0E, 0xB0,
  0xD7, 0x60, 0x10, 0xBD, 0x0B, 0x75, 0x03, 0x0E, 0xD0, 0xA7, 0x50, 0x6E, 0x08, 0x75, 0x06, 0xE0,
  0x87, 0x50, 0x6E, 0x0A, 0x75, 0x05, 0xE0, 0xD7, 0x50, 0x20, 0xEE, 0x03, 0x75, 0x0D, 0xE0, 0x77,
  0x50, 0x8E, 0x0E, 0x75, 0x02, 0xF0, 0x77, 0x50, 0xBE, 0x0E, 0x75, 0x03, 0xF0, 0x97, 0x50, 0xAF,
  0x03, 0x74, 0x01, 0xF0, 0xD7, 0x50, 0x7F, 0x08, 0x75, 0x0C, 0xF0, 0x37, 0x40, 0x2F, 0x97, 0x50,
  0x7F, 0x0B, 0x75, 0x0B, 0xF0, 0x87, 0x50, 0xEF, 0x05, 0x74, 0x02, 0xF9, 0x03, 0x74, 0x05, 0xF9,
  0x75, 0x08, 0xF0, 0xE7, 0x50, 0xAF, 0x0C, 0x75, 0x0C, 0xF0, 0xB7, 0x50, 0xEF, 0x0A, 0x74, 0x01,
  0xF9, 0x08, 0x74, 0x02, 0xF9, 0x07, 0x74, 0x04, 0xF9, 0x06, 0x74, 0x05, 0xF9, 0x05, 0x74, 0x06,
  0xF9, 0x04, 0x74, 0x07, 0xF9, 0x04, 0x74, 0x07, 0xF9, 0x03, 0x74, 0x08, 0xF9, 0x03, 0x74, 0x08,
  0xF9, 0x03, 0x74, 0x08, 0xF9, 0x02, 0x74, 0x09, 0xF9, 0x02, 0x74, 0x08, 0xF9, 0x02, 0x74, 0x08,
  0xF9, 0x03, 0x74, 0x08, 0xF9, 0x03, 0x74, 0x07, 0xF9, 0x03, 0x74, 0x07, 0xF9, 0x04, 0x74, 0x06,
  0xF9, 0x04, 0x74, 0x05, 0xF9, 0x05, 0x74, 0x04, 0xF9, 0x06, 0x74, 0x02, 0xF9, 0x07, 0x74, 0x01,
  0xF9, 0x08, 0x75, 0x0E, 0xF0, 0xA7, 0x50, 0xCF, 0x0B, 0x75, 0x0A, 0xF0, 0xC7, 0x50, 0x8F, 0x0E,
  0x75, 0x05, 0xF9, 0x75, 0x02, 0xF9, 0x03, 0x75, 0x0E, 0xF0, 0x57, 0x50, 0xBF, 0x08, 0x75, 0x07,
  0xF0, 0xB7, 0x50, 0x2F, 0x97, 0x60, 0xDF, 0x03, 0x75, 0x07, 0xF0, 0x87, 0x50, 0x2F, 0x0D, 0x76,
  0x0A, 0xF0, 0x27, 0x50, 0x3F, 0x09, 0x76, 0x0B, 0xE0, 0xE7, 0x60, 0x2F, 0x06, 0x76, 0x09, 0xE0,
  0xE7, 0x60, 0x10, 0xDE, 0x07, 0x76, 0x03, 0xF0, 0x27, 0x60, 0x6E, 0x0C, 0x77, 0x08, 0xE0, 0x97,
  0x70, 0x8E, 0x08, 0x77, 0x08, 0xE0, 0x77, 0x70, 0x50, 0xED, 0x09, 0x77, 0x02, 0x0D, 0xD0, 0xA7,
  0x71, 0x08, 0xC0, 0xD7, 0x72, 0x02, 0x0B, 0xA0, 0xD7, 0x74, 0x81, 0x4B, 0xD7, 0x76, 0x03,
  // ")" (U+0029)
  0x01, 0x77, 0x68, 0x18, 0xC4, 0x77, 0x40, 0x8A, 0x0C, 0x03, 0x77, 0x20, 0x8C, 0x09, 0x01, 0x77,
  0x06, 0xD0, 0xE0, 0x47, 0x70, 0x6E, 0x07, 0x77, 0x04, 0x0E, 0xD0, 0xA7, 0x70, 0x4E, 0x0B, 0x77,
  0x05, 0xE0, 0xB7, 0x70, 0x8E, 0x0A, 0x77, 0x0C, 0xE0, 0x67, 0x60, 0x3F, 0x03, 0x76, 0x0A, 0xE0,
  0xC7, 0x60, 0x2F, 0x06, 0x76, 0x0A, 0xE0, 0xE0, 0x17, 0x50, 0x4F, 0x07, 0x76, 0x0D, 0xE0, 0xE7,
  0x60, 0x8F, 0x05, 0x75, 0x04, 0xF0, 0xC7, 0x60, 0xEF, 0x01, 0x75, 0x0A, 0xF0, 0x67, 0x50, 0x7F,
  0x0B, 0x75, 0x03, 0xF9, 0x76, 0xF9, 0x03, 0x75, 0x0D, 0xF0, 0x77, 0x50, 0xBF, 0x0A, 0x75, 0x09,
  0xF0, 0xD7, 0x50, 0x7F, 0x97, 0x50, 0x6F, 0x90, 0x27, 0x40, 0x5F, 0x90, 0x47, 0x40, 0x3F, 0x90,
  0x67, 0x40, 0x2F, 0x90, 0x87, 0x40, 0x1F, 0x90, 0x97, 0x5F, 0x90, 0xA7, 0x50, 0xEF, 0x0B, 0x75,
  0x0E, 0xF0, 0xC7, 0x50, 0xDF, 0x0D, 0x75, 0x0D, 0xF0, 0xD7, 0x50, 0xDF, 0x0D, 0x75, 0x0C, 0xF0,
  0xE7, 0x50, 0xCF, 0x0E, 0x75, 0x0C, 0xF0, 0xE7, 0x50, 0xDF, 0x0D, 0x75, 0x0D, 0xF0, 0xD7, 0x50,
  0xDF, 0x0D, 0x75, 0x0E, 0xF0, 0xC7, 0x50, 0xEF, 0x0B, 0x75, 0xF9, 0x0A, 0x74, 0x01, 0xF9, 0x09,
  0x74, 0x02, 0xF9, 0x08, 0x74, 0x03, 0xF9, 0x06, 0x74, 0x05, 0xF9, 0x04, 0x74, 0x06, 0xF9, 0x02,
  0x74, 0x07, 0xF9, 0x75, 0x09, 0xF0, 0xD7, 0x50, 0xBF, 0x0A, 0x75, 0x0E, 0xF0, 0x77, 0x5F, 0x90,
  0x37, 0x40, 0x3F, 0x97, 0x50, 0x7F, 0x0B, 0x75, 0x0A, 0xF0, 0x67, 0x50, 0xEF, 0x01, 0x74, 0x04,
  0xF0, 0xC7, 0x50, 0x8F, 0x06, 0x75, 0x0D, 0xE0, 0xE7, 0x50, 0x4F, 0x08, 0x75, 0x0A, 0xE0, 0xE0,
  0x17, 0x40, 0x2F, 0x07, 0x75, 0x09, 0xE0, 0xD7, 0x50, 0x2F, 0x03, 0x75, 0x0C, 0xE0, 0x77, 0x50,
  0x8E, 0x0B, 0x75, 0x04, 0xE0, 0xC7, 0x50, 0x3E, 0x0C, 0x01, 0x74, 0x03, 0x0E, 0xD0, 0xC0, 0x17,
  0x40, 0x6E, 0x09, 0x75, 0x06, 0xD0, 0xE0, 0x67, 0x60, 0x8C, 0x0B, 0x02, 0x77, 0x08, 0xA0, 0xD0,
  0x57, 0x72, 0x81, 0x8D, 0x67, 0x74, 0x02, 0x77, 0x60,
  // "*" (U+002A)
  0x75, 0x0C, 0xD0, 0xD7, 0x77, 0x30, 0xAD, 0x0B, 0x77, 0x73, 0x08, 0xD0, 0x97, 0x77, 0x30, 0x6D,
  0x07, 0x77, 0x73, 0x04, 0xD0, 0x47, 0x77, 0x30, 0x2D, 0x02, 0x77, 0x02, 0x01, 0x72, 0xD7, 0x30,
  0x14, 0x81, 0x9E, 0x47, 0x10, 0xDB, 0x0D, 0x71, 0x81, 0x2C, 0x94, 0x0E, 0xA0, 0x77, 0x0B, 0xB0,
  0xB7, 0x82, 0x5E, 0xFE, 0x30, 0x6C, 0x0A, 0x01, 0x50, 0x9B, 0x09, 0x60, 0x8C, 0x06, 0x20, 0xDD,
  0x0D, 0x03, 0x40, 0x7B, 0x07, 0x40, 0x20, 0xCD, 0x81, 0xC0, 0x4F, 0x90, 0x53, 0x05, 0xB0, 0x43,
  0x05, 0x0E, 0xF0, 0x30, 0xAF, 0xA0, 0x92, 0x02, 0xB0, 0x22, 0x09, 0xFA, 0x82, 0xA4, 0x9E, 0xF9,
  0x0C, 0x01, 0x1B, 0x10, 0x20, 0xCF, 0xA0, 0xB0, 0x53, 0x05, 0x0B, 0xF8, 0x5E, 0x4E, 0xFD, 0x5E,
  0xF8, 0x1C, 0x71, 0x78, 0x11, 0x7D, 0xFF, 0x98, 0x1D, 0x82, 0x76, 0x81, 0x39, 0xEF, 0xA8, 0x1E,
  0xA4, 0x77, 0x50, 0x50, 0xED, 0x0E, 0x06, 0x77, 0x68, 0x13, 0x9E, 0xF8, 0x1E, 0xA4, 0x77, 0x18,
  0x11, 0x7D, 0xFE, 0x81, 0xD8, 0x27, 0x30, 0x50, 0xBF, 0x83, 0xBE, 0xFD, 0xBF, 0x81, 0xC6, 0x14,
  0x81, 0x38, 0xEF, 0x90, 0x71, 0xB1, 0x07, 0xFA, 0x82, 0xA4, 0x0A, 0xFA, 0x82, 0xE4, 0x02, 0xB8,
  0x22, 0x03, 0xDF, 0xA0, 0xB0, 0x7F, 0x90, 0xC0, 0x12, 0x04, 0xB0, 0x42, 0x01, 0x0B, 0xF9, 0x81,
  0x61, 0xEE, 0x09, 0x40, 0x6B, 0x06, 0x40, 0x7E, 0x0E, 0x20, 0x9C, 0x0E, 0x05, 0x50, 0x8B, 0x08,
  0x50, 0x30, 0xEC, 0x09, 0x20, 0x3B, 0x0D, 0x02, 0x60, 0xAB, 0x0B, 0x60, 0x10, 0xBB, 0x02, 0x38,
  0x2C, 0xFA, 0x17, 0x0C, 0xB0, 0xD7, 0x18, 0x17, 0xFC, 0x40, 0x50, 0x77, 0x2D, 0x72, 0x00, 0x47,
  0x70, 0x1D, 0x02, 0x77, 0x73, 0x03, 0xD0, 0x47, 0x77, 0x30, 0x6D, 0x06, 0x77, 0x73, 0x08, 0xD0,
  0x97, 0x77, 0x30, 0xAD, 0x0B, 0x77, 0x73, 0x0C, 0xD0, 0xD7, 0x50,
  // "+" (U+002B)
  0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC,
  0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77,
  0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0,
  0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77,
  0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x70, 0x48, 0x09, 0x19,
  0x0E, 0xC0, 0xC8, 0x09, 0x19, 0x04, 0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06, 0x07,
  0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07,
  0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70,
  0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77,
  0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C,
  0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77,
  0x77, 0x0C, 0xC0, 0x77, 0x70,
  // "," (U+002C)
  0x48, 0x43, 0xAE, 0xEC, 0x66, 0x05, 0xE0, 0xB4, 0x01, 0x0E, 0xF0, 0x93, 0x06, 0xFA, 0x02, 0x20,
  0x8F, 0xA0, 0x82, 0x08, 0xFA, 0x0C, 0x20, 0x5F, 0xA0, 0xE3, 0x0E, 0xFA, 0x30, 0x4F, 0xA4, 0x03,
  0x0E, 0xE0, 0xE5, 0x01, 0x0C, 0xD0, 0xD7, 0x0D, 0xC0, 0xA7, 0x07, 0xC0, 0x77, 0x06, 0xC0, 0x37,
  0x08, 0xB0, 0xD7, 0x10, 0xCB, 0x07, 0x70, 0x4B, 0x0E, 0x01, 0x70, 0xDB, 0x07, 0x70, 0xBB, 0x0C,
  0x60, 0x20, 0xCB, 0x0E, 0x01, 0x40, 0x10, 0x8C, 0x0E, 0x03, 0x40, 0x2D, 0x0C, 0x01, 0x50, 0x3B,
  0x0E, 0x07, 0x78, 0x33, 0xFE, 0x91, 0x71, 0x02, 0x06, 0x74,
  // "-" (U+002D)
  0xFF, 0xD0, 0xEF, 0xFD, 0x0E, 0xFF, 0xD0, 0xEF, 0xFD, 0x0E, 0xFF, 0xD0, 0xEF, 0xFD, 0x0E, 0xFF,
  0xD0, 0xE0,
  // "." (U+002E)
  0x28, 0x47, 0xCF, 0xEB, 0x53, 0x0C, 0xE8, 0x19, 0x07, 0xF9, 0x04, 0x0C, 0xF9, 0x09, 0xFA, 0x0C,
  0xFA, 0x0C, 0xFA, 0x00, 0xCF, 0x90, 0x90, 0x7F, 0x98, 0x14, 0x0C, 0xE0, 0x93, 0x84, 0x7C, 0xFE,
  0xB5, 0x20,
  // "/" (U+002F)
  0x77, 0x30, 0x8C, 0x77, 0x30, 0xCB, 0x0C, 0x77, 0x3C, 0x09, 0x77, 0x20, 0x3C, 0x05, 0x77, 0x20,
  0x7C, 0x02, 0x77, 0x20, 0xAB, 0x0E, 0x77, 0x30, 0xDB, 0x0B, 0x77, 0x20, 0x1C, 0x07, 0x77, 0x20,
  0x5C, 0x04, 0x77, 0x20, 0x8C, 0x77, 0x30, 0xCB, 0x0C, 0x77, 0x3C, 0x09, 0x77, 0x20, 0x3C, 0x06,
  0x77, 0x20, 0x7C, 0x02, 0x77, 0x20, 0xAB, 0x0E, 0x77, 0x30, 0xDB, 0x0B, 0x77, 0x20, 0x1C, 0x07,
  0x77, 0x20, 0x5C, 0x04, 0x77, 0x20, 0x8C, 0x01, 0x77, 0x20, 0xCB, 0x0D, 0x77, 0x3C, 0x09, 0x77,
  0x20, 0x3C, 0x06, 0x77, 0x20, 0x7C, 0x02, 0x77, 0x20, 0xAB, 0x0E, 0x77, 0x30, 0xDB, 0x0B, 0x77,
  0x20, 0x1C, 0x08, 0x77, 0x20, 0x5C, 0x04, 0x77, 0x20, 0x8C, 0x01, 0x77, 0x20, 0xCB, 0x0D, 0x77,
  0x3C, 0x0A, 0x77, 0x20, 0x3C, 0x06, 0x77, 0x20, 0x7C, 0x03, 0x77, 0x20, 0xAC, 0x77, 0x30, 0xDB,
  0x0B, 0x77, 0x20, 0x1C, 0x08, 0x77, 0x20, 0x5C, 0x05, 0x77, 0x20, 0x8C, 0x01, 0x77, 0x20, 0xCB,
  0x0D, 0x77, 0x3C, 0x0A, 0x77, 0x20, 0x3C, 0x07, 0x77, 0x20, 0x7C, 0x03, 0x77, 0x20, 0xAC, 0x77,
  0x30, 0xDB, 0x0C, 0x77, 0x20, 0x1C, 0x08, 0x77, 0x20, 0x5C, 0x05, 0x77, 0x20, 0x8C, 0x02, 0x77,
  0x20, 0xCB, 0x0E, 0x77, 0x3C, 0x0A, 0x77, 0x20, 0x3C, 0x07, 0x77, 0x20, 0x7C, 0x03, 0x77, 0x20,
  0xAC, 0x77, 0x30, 0xDB, 0x0C, 0x77, 0x20, 0x1C, 0x09, 0x77, 0x20, 0x5C, 0x05, 0x77, 0x20, 0x8C,
  0x02, 0x77, 0x20, 0xCB, 0x0E, 0x77, 0x3C, 0x0B, 0x77, 0x20, 0x3C, 0x07, 0x77, 0x20, 0x7C, 0x04,
  0x77, 0x20, 0xAC, 0x77, 0x30, 0xDB, 0x0C, 0x77, 0x20, 0x1C, 0x09, 0x77, 0x20, 0x5C, 0x06, 0x77,
  0x20, 0x8C, 0x02, 0x77, 0x20, 0xCB, 0x0E, 0x77, 0x3C, 0x0B, 0x77, 0x20, 0x3C, 0x07, 0x77, 0x20,
  0x7C, 0x04, 0x77, 0x20, 0xAC, 0x01, 0x77, 0x20, 0xDB, 0x0D, 0x77, 0x20, 0x1C, 0x09, 0x77, 0x20,
  0x5C, 0x06, 0x77, 0x20, 0x8C, 0x03, 0x77, 0x20, 0xCB, 0x0E, 0x77, 0x3C, 0x0B, 0x77, 0x20, 0x3C,
  0x08, 0x77, 0x20, 0x7C, 0x04, 0x77, 0x20, 0xAC, 0x01, 0x77, 0x20, 0xDB, 0x0D, 0x77, 0x30,
  // "0" (U+0030)
  0x76, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x84, 0x77, 0x72, 0x81, 0x17, 0xEF, 0xC0, 0xE0, 0x77,
  0x76, 0x05, 0x0E, 0xFF, 0x90, 0xE0, 0x47, 0x73, 0x08, 0xFF, 0xD0, 0x77, 0x71, 0x09, 0xF9, 0x83,
  0xEA, 0x9A, 0xDF, 0x90, 0x77, 0x60, 0x7F, 0x0D, 0x05, 0x50, 0x40, 0xDF, 0x05, 0x74, 0x03, 0xF0,
  0xC0, 0x17, 0x10, 0xBE, 0x0E, 0x01, 0x73, 0x0C, 0xE0, 0xE0, 0x17, 0x20, 0x10, 0xDE, 0x0A, 0x72,
  0x06, 0xF0, 0x57, 0x40, 0x5F, 0x03, 0x71, 0x0D, 0xE0, 0xD7, 0x60, 0xDE, 0x0A, 0x70, 0x5F, 0x06,
  0x76, 0x06, 0xF0, 0x26, 0x0B, 0xF0, 0x17, 0x60, 0x1F, 0x08, 0x50, 0x1F, 0x0C, 0x77, 0x10, 0xCE,
  0x0D, 0x50, 0x6F, 0x08, 0x77, 0x10, 0x8F, 0x03, 0x40, 0xAF, 0x05, 0x77, 0x10, 0x5F, 0x07, 0x40,
  0xEF, 0x02, 0x77, 0x10, 0x2F, 0x0B, 0x30, 0x2F, 0x0E, 0x77, 0x30, 0xEF, 0x30, 0x5F, 0x0C, 0x77,
  0x30, 0xCF, 0x03, 0x20, 0x8F, 0x0A, 0x77, 0x30, 0xAF, 0x06, 0x20, 0xBF, 0x08, 0x77, 0x30, 0x8F,
  0x09, 0x20, 0xDF, 0x06, 0x77, 0x30, 0x6F, 0x0B, 0x2F, 0x90, 0x57, 0x73, 0x05, 0xF8, 0x1D, 0x01,
  0xF9, 0x04, 0x77, 0x30, 0x3F, 0x91, 0x03, 0xF9, 0x02, 0x77, 0x30, 0x2F, 0x90, 0x10, 0x4F, 0x90,
  0x17, 0x73, 0x01, 0xF9, 0x03, 0x06, 0xF9, 0x77, 0x5F, 0x90, 0x40, 0x7F, 0x97, 0x75, 0xF9, 0x05,
  0x08, 0xF9, 0x77, 0x5F, 0x90, 0x60, 0x9F, 0x0E, 0x77, 0x50, 0xEF, 0x07, 0x09, 0xF0, 0xE7, 0x75,
  0x0D, 0xF0, 0x80, 0x9F, 0x0D, 0x77, 0x50, 0xDF, 0x08, 0x0A, 0xF0, 0xD7, 0x75, 0x0D, 0xF0, 0x80,
  0xAF, 0x0D, 0x77, 0x50, 0xDF, 0x09, 0x0A, 0xF0, 0xD7, 0x75, 0x0D, 0xF0, 0x90, 0xAF, 0x0D, 0x77,
  0x50, 0xDF, 0x08, 0x09, 0xF0, 0xD7, 0x75, 0x0D, 0xF0, 0x80, 0x9F, 0x0E, 0x77, 0x50, 0xEF, 0x00,
  0x8F, 0x0E, 0x77, 0x50, 0xEF, 0x00, 0x7F, 0x97, 0x75, 0xF9, 0x06, 0x07, 0xF9, 0x77, 0x5F, 0x90,
  0x05, 0xF9, 0x01, 0x77, 0x30, 0x1F, 0x90, 0x04, 0xF9, 0x01, 0x77, 0x30, 0x1F, 0x90, 0x20, 0x3F,
  0x90, 0x27, 0x73, 0x02, 0xF9, 0x00, 0x1F, 0x90, 0x47, 0x73, 0x04, 0xF9, 0x20, 0xEF, 0x05, 0x77,
  0x30, 0x5F, 0x0D, 0x20, 0xCF, 0x07, 0x77, 0x30, 0x7F, 0x0A, 0x20, 0xAF, 0x08, 0x77, 0x30, 0x9F,
  0x08, 0x20, 0x7F, 0x0A, 0x77, 0x30, 0xAF, 0x05, 0x20, 0x4F, 0x0D, 0x77, 0x30, 0xDF, 0x02, 0x20,
  0x1F, 0x97, 0x73, 0xF0, 0xE4, 0x0D, 0xF0, 0x27, 0x71, 0x03, 0xF0, 0xA4, 0x09, 0xF0, 0x57, 0x71,
  0x06, 0xF0, 0x54, 0x04, 0xF0, 0x97, 0x71, 0x09, 0xF0, 0x15, 0x0E, 0xE0, 0xD7, 0x71, 0x0D, 0xE0,
  0xB6, 0x09, 0xF0, 0x27, 0x60, 0x2F, 0x06, 0x60, 0x3F, 0x07, 0x76, 0x08, 0xE0, 0xE7, 0x10, 0xCE,
  0x0D, 0x76, 0x0E, 0xE0, 0x87, 0x10, 0x5F, 0x05, 0x74, 0x06, 0xE0, 0xE0, 0x17, 0x20, 0xCE, 0x0E,
  0x01, 0x72, 0x02, 0x0E, 0xE0, 0x77, 0x30, 0x3F, 0x0C, 0x01, 0x70, 0x10, 0xCE, 0x0D, 0x75, 0x07,
  0xF0, 0xD0, 0x45, 0x05, 0x0D, 0xF0, 0x27, 0x60, 0x9F, 0x98, 0x3E, 0xA9, 0xAE, 0xF9, 0x04, 0x77,
  0x10, 0x9F, 0xFC, 0x0E, 0x05, 0x77, 0x30, 0x50, 0xEF, 0xF9, 0x0C, 0x02, 0x77, 0x58, 0x11, 0x8E,
  0xFC, 0x0D, 0x06, 0x77, 0x73, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x83, 0x76,
  // "1" (U+0031)
  0x77, 0x20, 0x30, 0xDC, 0x09, 0x77, 0x74, 0x04, 0x0E, 0xD0, 0x97, 0x77, 0x30, 0x7F, 0x09, 0x77,
  0x72, 0x09, 0xF9, 0x09, 0x77, 0x70, 0x10, 0xBF, 0xA0, 0x97, 0x76, 0x02, 0x0D, 0xFB, 0x09, 0x77,
  0x50, 0x50, 0xEF, 0xC0, 0x97, 0x74, 0x09, 0xD0, 0x9F, 0x09, 0x77, 0x20, 0x40, 0xDD, 0x06, 0x05,
  0xF0, 0x97, 0x70, 0x20, 0xAE, 0x81, 0xA0, 0x5F, 0x09, 0x75, 0x04, 0x0A, 0xF0, 0xC2, 0x05, 0xF0,
  0x97, 0x30, 0x20, 0xDF, 0x90, 0xD0, 0x12, 0x05, 0xF0, 0x97, 0x30, 0x1F, 0x90, 0xE0, 0x23, 0x05,
  0xF0, 0x97, 0x40, 0xCE, 0x0E, 0x03, 0x40, 0x5F, 0x09, 0x74, 0x03, 0xD0, 0xD0, 0x35, 0x05, 0xF0,
  0x97, 0x58, 0x33, 0xAC, 0xB6, 0x70, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F,
  0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77,
  0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0,
  0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73,
  0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09,
  0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30,
  0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97,
  0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05,
  0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77,
  0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F,
  0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77, 0x30, 0x5F, 0x09, 0x77, 0x73, 0x05, 0xF0, 0x97, 0x77,
  0x30, 0x5F, 0x09, 0x77, 0x73, 0x06, 0xF0, 0xA7, 0x77, 0x30, 0x7F, 0x0C, 0x77, 0x73, 0x0B, 0xF9,
  0x77, 0x72, 0x01, 0x0E, 0xF9, 0x05, 0x77, 0x71, 0x0B, 0xFA, 0x0E, 0x03, 0x77, 0x38, 0x21, 0x37,
  0xDF, 0xD8, 0x1A, 0x41, 0x71, 0x06, 0xFF, 0xFF, 0x08, 0x30, 0x6F, 0xFF, 0xF0, 0x83, 0x06, 0xFF,
  0xFF, 0x08, 0x30, 0x6F, 0xFF, 0xF0, 0x80,
  // "2" (U+0032)
  0x72, 0x89, 0x41, 0x58, 0xBC, 0xDE, 0xFE, 0xEC, 0x96, 0x27, 0x75, 0x04, 0x0B, 0xFF, 0x0C, 0x06,
  0x77, 0x10, 0x20, 0xCF, 0xFC, 0x0D, 0x04, 0x75, 0x05, 0xFF, 0xF9, 0x07, 0x73, 0x05, 0xFB, 0x83,
  0xCA, 0x9B, 0xDF, 0xA0, 0x97, 0x10, 0x3F, 0x90, 0xE0, 0x66, 0x03, 0x0C, 0xF9, 0x07, 0x70, 0xCF,
  0x0D, 0x02, 0x72, 0x0B, 0xF9, 0x03, 0x50, 0x5F, 0x90, 0x37, 0x30, 0x10, 0xDF, 0x0C, 0x50, 0xAF,
  0x08, 0x75, 0x05, 0xF9, 0x04, 0x4F, 0x90, 0x17, 0x60, 0xDF, 0x0A, 0x30, 0x1F, 0x0B, 0x77, 0x09,
  0xF9, 0x30, 0x3F, 0x07, 0x77, 0x04, 0xF9, 0x03, 0x20, 0x2F, 0x04, 0x77, 0x02, 0xF9, 0x06, 0x3F,
  0x01, 0x77, 0x1F, 0x90, 0x83, 0x0B, 0xE7, 0x72, 0x0E, 0xF0, 0x93, 0x02, 0x0E, 0xC0, 0xE7, 0x72,
  0x0D, 0xF0, 0x94, 0x02, 0x0A, 0xB0, 0xD7, 0x72, 0x0D, 0xF0, 0x86, 0x82, 0x15, 0x87, 0x77, 0x20,
  0xEF, 0x07, 0x77, 0x75, 0xF9, 0x06, 0x77, 0x75, 0xF9, 0x03, 0x77, 0x74, 0x02, 0xF9, 0x77, 0x75,
  0x05, 0xF0, 0xC7, 0x77, 0x50, 0x8F, 0x07, 0x77, 0x75, 0x0B, 0xF0, 0x27, 0x77, 0x50, 0xEE, 0x0C,
  0x77, 0x75, 0x04, 0xF0, 0x57, 0x77, 0x50, 0x9E, 0x0D, 0x77, 0x75, 0x01, 0x0E, 0xE0, 0x57, 0x77,
  0x50, 0x7E, 0x0C, 0x77, 0x76, 0x0E, 0xE0, 0x37, 0x77, 0x50, 0x7E, 0x08, 0x77, 0x75, 0x01, 0x0E,
  0xD0, 0xD7, 0x77, 0x60, 0x8E, 0x03, 0x77, 0x75, 0x03, 0xE0, 0x87, 0x77, 0x60, 0xCD, 0x0C, 0x77,
  0x76, 0x07, 0xD0, 0xE0, 0x27, 0x77, 0x50, 0x2E, 0x05, 0x77, 0x76, 0x0C, 0xD0, 0x97, 0x77, 0x60,
  0x8D, 0x0C, 0x77, 0x76, 0x04, 0xD0, 0xE0, 0x17, 0x77, 0x50, 0x10, 0xED, 0x04, 0x77, 0x76, 0x0B,
  0xD0, 0x77, 0x77, 0x60, 0x8D, 0x0A, 0x77, 0x76, 0x04, 0xD0, 0xC7, 0x77, 0x60, 0x20, 0xEC, 0x0E,
  0x02, 0x77, 0x76, 0x0C, 0xD0, 0x47, 0x77, 0x60, 0x9D, 0x07, 0x77, 0x76, 0x05, 0xD0, 0xA7, 0x77,
  0x60, 0x20, 0xEC, 0x0C, 0x77, 0x77, 0x0D, 0xC0, 0xE0, 0x27, 0x73, 0x0F, 0x50, 0x26, 0x0A, 0xD0,
  0x47, 0x73, 0x04, 0xB0, 0x65, 0x06, 0xD0, 0x77, 0x74, 0x07, 0xB0, 0x64, 0x03, 0xD0, 0xA7, 0x75,
  0x0B, 0xB0, 0x53, 0x01, 0x0D, 0xC0, 0xC7, 0x75, 0x01, 0xC0, 0x53, 0x0B, 0xC0, 0xE0, 0x27, 0x75,
  0x06, 0xC0, 0x52, 0x07, 0xD0, 0x47, 0x76, 0x0E, 0xC8, 0x15, 0x04, 0xD0, 0x77, 0x76, 0x0A, 0xD8,
  0x14, 0x1E, 0xC0, 0xA7, 0x74, 0x81, 0x25, 0xCE, 0x04, 0x0C, 0xFF, 0xFF, 0xD0, 0x4F, 0xFF, 0xFE,
  0x03, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 0xFE, 0x02, 0xFF,
  0xFF, 0xE0, 0x20,
  // "3" (U+0033)
  0x74, 0x89, 0x33, 0x69, 0xCD, 0xEF, 0xED, 0xCA, 0x73, 0x77, 0x68, 0x11, 0x7D, 0xFE, 0x81, 0xE8,
  0x17, 0x72, 0x07, 0xFF, 0xD0, 0x87, 0x60, 0x10, 0xCF, 0xFF, 0x0C, 0x02, 0x74, 0x0C, 0xFA, 0x83,
  0xCA, 0x9A, 0xDF, 0xA0, 0xE0, 0x37, 0x20, 0xBF, 0x90, 0x80, 0x15, 0x02, 0x0A, 0xF9, 0x0E, 0x01,
  0x70, 0x5F, 0x90, 0x47, 0x20, 0x7F, 0x90, 0xB7, 0x0D, 0xF0, 0x57, 0x40, 0x9F, 0x90, 0x55, 0x04,
  0xF0, 0xB7, 0x50, 0x10, 0xEF, 0x0C, 0x50, 0x9F, 0x04, 0x76, 0x08, 0xF9, 0x02, 0x40, 0xBE, 0x0D,
  0x77, 0x03, 0xF9, 0x06, 0x40, 0xCE, 0x0A, 0x77, 0x1F, 0x90, 0x94, 0x0C, 0xE0, 0x77, 0x71, 0x0C,
  0xF0, 0xC4, 0x0A, 0xE0, 0x47, 0x71, 0x0A, 0xF0, 0xD4, 0x05, 0xE0, 0x27, 0x71, 0x09, 0xF0, 0xD5,
  0x0A, 0xD0, 0x17, 0x71, 0x09, 0xF0, 0xD6, 0x06, 0x0D, 0xB7, 0x72, 0x09, 0xF0, 0xB7, 0x18, 0x12,
  0x56, 0x77, 0x20, 0xAF, 0x0A, 0x77, 0x76, 0x0B, 0xF0, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x75,
  0x02, 0xF0, 0xE7, 0x77, 0x60, 0x5F, 0x08, 0x77, 0x76, 0x0B, 0xF0, 0x27, 0x77, 0x50, 0x2F, 0x08,
  0x77, 0x76, 0x0B, 0xE0, 0xD7, 0x77, 0x60, 0x6E, 0x0E, 0x03, 0x77, 0x75, 0x05, 0xF0, 0x47, 0x77,
  0x50, 0x7E, 0x0E, 0x04, 0x77, 0x73, 0x81, 0x16, 0xDE, 0x0D, 0x02, 0x77, 0x58, 0x00, 0x90, 0xB0,
  0xCF, 0x0E, 0x07, 0x77, 0x7F, 0xC8, 0x1C, 0x61, 0x77, 0x71, 0xFC, 0x82, 0xEB, 0x72, 0x77, 0x7F,
  0xF9, 0x0B, 0x04, 0x77, 0x5F, 0xFB, 0x0C, 0x03, 0x77, 0x78, 0x31, 0x24, 0x8C, 0xFB, 0x07, 0x77,
  0x74, 0x03, 0x0A, 0xFA, 0x08, 0x77, 0x75, 0x04, 0x0E, 0xF9, 0x07, 0x77, 0x75, 0x02, 0x0E, 0xF9,
  0x03, 0x77, 0x75, 0x04, 0xF9, 0x0D, 0x77, 0x76, 0x09, 0xF9, 0x05, 0x77, 0x75, 0x01, 0xF9, 0x0B,
  0x77, 0x76, 0x09, 0xF9, 0x01, 0x77, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x75, 0x01, 0xF9, 0x07, 0x77,
  0x76, 0x0D, 0xF0, 0xA7, 0x77, 0x60, 0xCF, 0x0B, 0x77, 0x76, 0x0B, 0xF0, 0xB7, 0x77, 0x60, 0xAF,
  0x0C, 0x77, 0x76, 0x0B, 0xF0, 0xB7, 0x77, 0x60, 0xBF, 0x0A, 0x48, 0x13, 0x76, 0x77, 0x60, 0xDF,
  0x09, 0x20, 0x10, 0xBA, 0x0C, 0x77, 0x6F, 0x98, 0x27, 0x01, 0xDB, 0x0D, 0x77, 0x50, 0x2F, 0x98,
  0x14, 0x09, 0xD0, 0x17, 0x74, 0x06, 0xF9, 0x20, 0xED, 0x04, 0x77, 0x40, 0xBF, 0x81, 0xB0, 0x1E,
  0x0A, 0x77, 0x30, 0x2F, 0x98, 0x15, 0x01, 0xF0, 0x27, 0x72, 0x0A, 0xF0, 0xD3, 0x0E, 0xE0, 0xB7,
  0x71, 0x04, 0xF9, 0x05, 0x30, 0xAF, 0x08, 0x76, 0x03, 0x0E, 0xF0, 0xB4, 0x04, 0xF9, 0x08, 0x74,
  0x05, 0x0E, 0xF0, 0xD0, 0x15, 0x0B, 0xF9, 0x81, 0xD5, 0x16, 0x04, 0x0B, 0xF9, 0x0E, 0x02, 0x60,
  0x10, 0xDF, 0xB8, 0x4C, 0xA9, 0x9B, 0xEF, 0xA0, 0xD0, 0x27, 0x10, 0x10, 0xDF, 0xFF, 0xA0, 0x90,
  0x17, 0x30, 0x10, 0xAF, 0xFE, 0x0C, 0x03, 0x77, 0x81, 0x39, 0xEF, 0xF8, 0x1E, 0xA3, 0x77, 0x58,
  0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xCA, 0x63, 0x76,
  // "4" (U+0034)
  0x77, 0x72, 0x0B, 0xF0, 0x97, 0x77, 0x73, 0x03, 0xF9, 0x09, 0x77, 0x77, 0x30, 0xCF, 0x90, 0x97,
  0x77, 0x72, 0x05, 0xFA, 0x09, 0x77, 0x77, 0x20, 0xDF, 0xA0, 0x97, 0x77, 0x71, 0x06, 0xFB, 0x09,
  0x77, 0x77, 0x10, 0xEF, 0xB0, 0x97, 0x77, 0x70, 0x8B, 0x0C, 0x0D, 0xE0, 0x97, 0x77, 0x60, 0x10,
  0xEB, 0x05, 0x0E, 0xE0, 0x97, 0x77, 0x60, 0x9B, 0x0C, 0x1F, 0x09, 0x77, 0x75, 0x02, 0xC0, 0x51,
  0xF0, 0x97, 0x77, 0x50, 0xAB, 0x81, 0xD0, 0x1F, 0x09, 0x77, 0x74, 0x03, 0xC8, 0x15, 0x02, 0xF0,
  0x97, 0x77, 0x40, 0xCB, 0x0D, 0x20, 0x2F, 0x09, 0x77, 0x73, 0x05, 0xC0, 0x52, 0x03, 0xF0, 0x97,
  0x77, 0x30, 0xDB, 0x0D, 0x30, 0x3F, 0x09, 0x77, 0x72, 0x06, 0xC0, 0x53, 0x04, 0xF0, 0x97, 0x77,
  0x20, 0xEB, 0x0C, 0x40, 0x4F, 0x09, 0x77, 0x71, 0x08, 0xC0, 0x44, 0x04, 0xF0, 0x97, 0x77, 0x01,
  0x0E, 0xB0, 0xC5, 0x04, 0xF0, 0x97, 0x77, 0x09, 0xC0, 0x45, 0x04, 0xF0, 0x97, 0x76, 0x02, 0xC0,
  0xB6, 0x05, 0xF0, 0x97, 0x76, 0x0A, 0xC0, 0x26, 0x05, 0xF0, 0x97, 0x75, 0x03, 0xC0, 0x97, 0x05,
  0xF0, 0x97, 0x75, 0x0C, 0xC0, 0x17, 0x05, 0xF0, 0x97, 0x74, 0x05, 0xC0, 0x87, 0x10, 0x5F, 0x09,
  0x77, 0x40, 0xDB, 0x0E, 0x72, 0x05, 0xF0, 0x97, 0x73, 0x06, 0xC0, 0x67, 0x20, 0x5F, 0x09, 0x77,
  0x30, 0xEB, 0x0D, 0x73, 0x05, 0xF0, 0x97, 0x72, 0x07, 0xC0, 0x57, 0x30, 0x5F, 0x09, 0x77, 0x10,
  0x10, 0xEB, 0x0C, 0x74, 0x05, 0xF0, 0x97, 0x71, 0x09, 0xC0, 0x37, 0x40, 0x5F, 0x09, 0x77, 0x02,
  0xC0, 0xB7, 0x50, 0x5F, 0x09, 0x77, 0x0A, 0xC0, 0x27, 0x50, 0x5F, 0x09, 0x76, 0x03, 0xC0, 0x97,
  0x60, 0x5F, 0x09, 0x76, 0x0C, 0xB0, 0xE0, 0x17, 0x60, 0x5F, 0x09, 0x75, 0x05, 0xC0, 0x87, 0x70,
  0x5F, 0x09, 0x75, 0x0D, 0xB0, 0xE7, 0x71, 0x05, 0xF0, 0x97, 0x40, 0x6C, 0x06, 0x77, 0x10, 0x5F,
  0x09, 0x74, 0x0E, 0xB0, 0xD7, 0x72, 0x05, 0xF0, 0x97, 0x30, 0x7C, 0x05, 0x77, 0x20, 0x5F, 0x09,
  0x72, 0x01, 0x0E, 0xC8, 0x09, 0x59, 0x0B, 0xF0, 0xC8, 0x04, 0x90, 0x70, 0x88, 0x0C, 0x3F, 0x00,
  0xB8, 0x0C, 0x3F, 0x00, 0xB8, 0x0C, 0x3F, 0x00, 0xB8, 0x0C, 0x3F, 0x0B, 0x77, 0x72, 0x05, 0xF0,
  0x97, 0x77, 0x74, 0x05, 0xF0, 0x97, 0x77, 0x74, 0x05, 0xF0, 0x97, 0x77, 0x74, 0x05, 0xF0, 0x97,
  0x77, 0x74, 0x05, 0xF0, 0x97, 0x77, 0x74, 0x05, 0xF0, 0x97, 0x77, 0x74, 0x05, 0xF0, 0x97, 0x77,
  0x74, 0x05, 0xF0, 0x97, 0x77, 0x74, 0x06, 0xF0, 0x97, 0x77, 0x74, 0x07, 0xF0, 0xB7, 0x77, 0x74,
  0x0A, 0xF0, 0xE7, 0x77, 0x73, 0x01, 0xFA, 0x04, 0x77, 0x77, 0x20, 0xBF, 0xA0, 0xD0, 0x27, 0x77,
  0x48, 0x21, 0x38, 0xEF, 0xD8, 0x19, 0x41, 0x77, 0x50, 0xCF, 0xFF, 0x90, 0xD7, 0x73, 0x0C, 0xFF,
  0xF9, 0x0D, 0x77, 0x30, 0xCF, 0xFF, 0x90, 0xD7, 0x73, 0x0C, 0xFF, 0xF9, 0x0D, 0x20,
  // "5" (U+0035)
  0x40, 0x3F, 0xFF, 0xD7, 0x04, 0xFF, 0xFD, 0x70, 0x6F, 0xFF, 0xD0, 0x16, 0x07, 0xFF, 0xFD, 0x01,
  0x60, 0x8F, 0xFF, 0xD0, 0x16, 0x09, 0xFF, 0xFD, 0x01, 0x60, 0xAF, 0xFF, 0xD0, 0x26, 0x0C, 0xB0,
  0x47, 0x71, 0x01, 0x06, 0xD0, 0x26, 0x0D, 0xB0, 0x37, 0x73, 0x08, 0xC0, 0x26, 0x0E, 0xB0, 0x17,
  0x73, 0x02, 0xC0, 0x36, 0xC7, 0x75, 0x0D, 0xB0, 0x35, 0x01, 0xB0, 0xE7, 0x75, 0x09, 0xB0, 0x35,
  0x02, 0xB0, 0xD7, 0x75, 0x06, 0xB0, 0x45, 0x04, 0xB0, 0xC7, 0x75, 0x83, 0x14, 0x44, 0x15, 0x05,
  0xB0, 0xB7, 0x77, 0x71, 0x06, 0xB0, 0x97, 0x77, 0x71, 0x07, 0xB0, 0x87, 0x77, 0x71, 0x08, 0xB0,
  0x77, 0x77, 0x71, 0x0A, 0xB0, 0x67, 0x77, 0x71, 0x0B, 0xB0, 0x47, 0x77, 0x71, 0x0C, 0xB0, 0x37,
  0x77, 0x71, 0x0D, 0xB0, 0x27, 0x77, 0x71, 0xC7, 0x77, 0x72, 0xC7, 0x77, 0x71, 0x01, 0xB0, 0xD7,
  0x77, 0x71, 0x03, 0xB0, 0xC3, 0x89, 0x01, 0x46, 0x78, 0x98, 0x75, 0x37, 0x72, 0x04, 0xB8, 0x2C,
  0x5A, 0xDF, 0xC8, 0x1B, 0x61, 0x75, 0x05, 0xFF, 0xE8, 0x1E, 0x81, 0x73, 0x06, 0xFF, 0xF9, 0x0E,
  0x05, 0x72, 0x08, 0xFF, 0xFB, 0x09, 0x71, 0x09, 0xC8, 0x3E, 0xA6, 0x31, 0x28, 0x31, 0x25, 0xAE,
  0xFA, 0x0A, 0x70, 0x9A, 0x81, 0xD7, 0x17, 0x30, 0x10, 0x9F, 0xA0, 0x97, 0x05, 0x06, 0x77, 0x10,
  0x40, 0xEF, 0x90, 0x67, 0x77, 0x30, 0x3F, 0x90, 0xE0, 0x17, 0x77, 0x30, 0x7F, 0x90, 0x87, 0x77,
  0x40, 0xCF, 0x0E, 0x77, 0x74, 0x05, 0xF9, 0x05, 0x77, 0x74, 0x0E, 0xF0, 0xA7, 0x77, 0x40, 0xAF,
  0x0E, 0x77, 0x74, 0x07, 0xF9, 0x01, 0x77, 0x73, 0x03, 0xF9, 0x04, 0x77, 0x73, 0x01, 0xF9, 0x05,
  0x77, 0x74, 0xF9, 0x07, 0x77, 0x74, 0xF9, 0x07, 0x77, 0x74, 0x0E, 0xF0, 0x87, 0x77, 0x4F, 0x90,
  0x77, 0x77, 0x4F, 0x90, 0x67, 0x77, 0x4F, 0x90, 0x57, 0x77, 0x30, 0x2F, 0x90, 0x37, 0x77, 0x30,
  0x4F, 0x93, 0x82, 0x17, 0x91, 0x77, 0x40, 0x6F, 0x0D, 0x20, 0x40, 0xEA, 0x02, 0x77, 0x40, 0x9F,
  0x82, 0x80, 0x2E, 0xB0, 0x47, 0x74, 0x0D, 0xF8, 0x14, 0x08, 0xC0, 0x77, 0x73, 0x03, 0xF0, 0xD2,
  0x0C, 0xC0, 0xC7, 0x73, 0x09, 0xF0, 0x72, 0x0E, 0xD0, 0x37, 0x71, 0x02, 0xF0, 0xE3, 0x0D, 0xD0,
  0xB7, 0x71, 0x0C, 0xF0, 0x53, 0x0A, 0xE0, 0x77, 0x60, 0x9F, 0x0B, 0x40, 0x5F, 0x06, 0x74, 0x0A,
  0xF0, 0xD0, 0x15, 0x0D, 0xF0, 0xB0, 0x46, 0x81, 0x17, 0xEF, 0x0E, 0x02, 0x60, 0x4F, 0xA8, 0x4E,
  0xBA, 0x9A, 0xCF, 0xA0, 0xE0, 0x27, 0x10, 0x5F, 0xFF, 0x90, 0xB0, 0x17, 0x30, 0x30, 0xCF, 0xFC,
  0x0E, 0x06, 0x77, 0x05, 0x0C, 0xFF, 0x0D, 0x07, 0x77, 0x48, 0x94, 0x25, 0x9B, 0xDE, 0xEF, 0xED,
  0xC9, 0x72, 0x76,
  // "6" (U+0036)
  0x77, 0x18, 0x92, 0x58, 0xBD, 0xEF, 0xED, 0xC9, 0x62, 0x77, 0x78, 0x12, 0x9E, 0xFD, 0x0B, 0x04,
  0x77, 0x40, 0x8F, 0xFB, 0x0A, 0x01, 0x77, 0x01, 0x0C, 0xFF, 0xD0, 0xC0, 0x17, 0x50, 0x10, 0xDF,
  0x98, 0x3C, 0xA9, 0xBE, 0xF9, 0x0C, 0x75, 0x0C, 0xF0, 0x90, 0x25, 0x05, 0x0E, 0xF0, 0x77, 0x30,
  0xBE, 0x0E, 0x04, 0x71, 0x01, 0x0E, 0xE0, 0xE7, 0x20, 0x6F, 0x04, 0x73, 0x05, 0xF0, 0x57, 0x01,
  0x0E, 0xE0, 0x77, 0x50, 0xCE, 0x07, 0x70, 0xAE, 0x0D, 0x76, 0x07, 0xE0, 0x96, 0x02, 0xF0, 0x57,
  0x60, 0x2E, 0x08, 0x60, 0x9E, 0x0D, 0x77, 0x10, 0xED, 0x04, 0x50, 0x1F, 0x08, 0x77, 0x10, 0xCC,
  0x0C, 0x60, 0x6F, 0x02, 0x77, 0x10, 0xBB, 0x0C, 0x01, 0x60, 0xCE, 0x0D, 0x77, 0x28, 0x28, 0xA8,
  0x47, 0x01, 0xF0, 0x97, 0x77, 0x60, 0x6F, 0x05, 0x77, 0x76, 0x0A, 0xF0, 0x27, 0x77, 0x60, 0xDF,
  0x77, 0x76, 0x02, 0xF0, 0xC7, 0x77, 0x60, 0x5F, 0x0A, 0x77, 0x76, 0x07, 0xF0, 0x87, 0x77, 0x60,
  0xAF, 0x06, 0x77, 0x76, 0x0C, 0xF0, 0x47, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x76, 0xF9, 0x02, 0x77,
  0x75, 0x02, 0xF9, 0x01, 0x58, 0x25, 0x9C, 0xEA, 0x82, 0xEC, 0x95, 0x74, 0x03, 0xF9, 0x40, 0x70,
  0xEF, 0xB8, 0x1E, 0x91, 0x71, 0x04, 0xF0, 0xE2, 0x02, 0x0C, 0xFF, 0x0E, 0x06, 0x70, 0x5F, 0x81,
  0xE0, 0x6F, 0xFC, 0x09, 0x60, 0x6F, 0x0D, 0x07, 0xD8, 0x4E, 0xBA, 0x9B, 0xDF, 0xA0, 0x95, 0x06,
  0xFD, 0x0C, 0x05, 0x60, 0x40, 0xCF, 0x90, 0x74, 0x07, 0xFC, 0x06, 0x73, 0x09, 0xF9, 0x03, 0x30,
  0x7F, 0xA0, 0xE0, 0x47, 0x50, 0xBF, 0x0C, 0x30, 0x7F, 0x90, 0xE0, 0x27, 0x60, 0x10, 0xEF, 0x04,
  0x20, 0x7F, 0x0E, 0x03, 0x77, 0x10, 0x8F, 0x0B, 0x20, 0x6F, 0x0C, 0x77, 0x20, 0x3F, 0x98, 0x11,
  0x06, 0xF0, 0xC7, 0x73, 0x0D, 0xF8, 0x15, 0x05, 0xF0, 0xD7, 0x73, 0x0A, 0xF8, 0x19, 0x05, 0xF0,
  0xD7, 0x73, 0x07, 0xF8, 0x1C, 0x03, 0xF0, 0xE7, 0x73, 0x05, 0xF9, 0x10, 0x2F, 0x97, 0x73, 0x03,
  0xF9, 0x00, 0x1F, 0x97, 0x73, 0x02, 0xF9, 0x02, 0x1F, 0x90, 0x27, 0x72, 0x01, 0xF9, 0x81, 0x30,
  0xDF, 0x03, 0x77, 0x20, 0x1F, 0x98, 0x13, 0x0A, 0xF0, 0x57, 0x73, 0xF9, 0x81, 0x20, 0x7F, 0x07,
  0x77, 0x20, 0x1F, 0x98, 0x12, 0x05, 0xF0, 0x97, 0x72, 0x01, 0xF9, 0x81, 0x10, 0x2F, 0x0C, 0x77,
  0x20, 0x2F, 0x93, 0x0D, 0xE0, 0xE7, 0x72, 0x03, 0xF0, 0xD3, 0x09, 0xF0, 0x27, 0x71, 0x04, 0xF0,
  0xA3, 0x05, 0xF0, 0x67, 0x71, 0x06, 0xF0, 0x73, 0x01, 0xF0, 0xA7, 0x71, 0x08, 0xF0, 0x34, 0x0A,
  0xE0, 0xE7, 0x71, 0x0B, 0xE0, 0xE5, 0x04, 0xF0, 0x57, 0x70, 0xEE, 0x09, 0x60, 0xDE, 0x0B, 0x76,
  0x04, 0xF0, 0x46, 0x05, 0xF0, 0x37, 0x50, 0xAE, 0x0C, 0x71, 0x0D, 0xE0, 0xC7, 0x40, 0x2F, 0x05,
  0x71, 0x04, 0xF0, 0x77, 0x30, 0xCE, 0x0B, 0x73, 0x09, 0xF0, 0x57, 0x10, 0x9F, 0x02, 0x74, 0x0C,
  0xF0, 0x90, 0x14, 0x03, 0x0B, 0xF0, 0x57, 0x50, 0x10, 0xCF, 0x98, 0x2B, 0x9A, 0xCF, 0x90, 0x77,
  0x70, 0x10, 0xCF, 0xFC, 0x06, 0x77, 0x30, 0x8F, 0xF9, 0x0D, 0x04, 0x77, 0x50, 0x20, 0xAF, 0xC0,
  0xD0, 0x77, 0x77, 0x28, 0x91, 0x16, 0xAD, 0xEF, 0xED, 0xB8, 0x47, 0x50,
  // "7" (U+0037)
  0x06, 0xFF, 0xFF, 0xE0, 0x20, 0x7F, 0xFF, 0xFE, 0x02, 0x07, 0xFF, 0xFF, 0xE0, 0x10, 0x7F, 0xFF,
  0xFD, 0x81, 0xD0, 0x8F, 0xFF, 0xFD, 0x81, 0x80, 0x8F, 0xFF, 0xFD, 0x81, 0x30, 0x9F, 0xFF, 0xFC,
  0x0D, 0x20, 0x9D, 0x08, 0x02, 0x77, 0x40, 0x3E, 0x09, 0x20, 0xAC, 0x05, 0x77, 0x60, 0x8E, 0x04,
  0x20, 0xAB, 0x0C, 0x77, 0x70, 0xDD, 0x0E, 0x30, 0xAB, 0x07, 0x77, 0x60, 0x3E, 0x09, 0x30, 0xBB,
  0x04, 0x77, 0x60, 0x8E, 0x04, 0x30, 0xBB, 0x03, 0x77, 0x60, 0xDD, 0x0E, 0x40, 0xCB, 0x02, 0x77,
  0x50, 0x3E, 0x0A, 0x40, 0xCB, 0x77, 0x60, 0x9E, 0x05, 0x40, 0xDA, 0x0E, 0x77, 0x60, 0xEE, 0x77,
  0x77, 0x04, 0xE0, 0xB7, 0x77, 0x70, 0x9E, 0x06, 0x77, 0x77, 0x0E, 0xE0, 0x17, 0x77, 0x60, 0x4E,
  0x0B, 0x77, 0x77, 0x09, 0xE0, 0x67, 0x77, 0x70, 0xEE, 0x01, 0x77, 0x76, 0x04, 0xE0, 0xC7, 0x77,
  0x70, 0x9E, 0x07, 0x77, 0x77, 0x0E, 0xE0, 0x27, 0x77, 0x60, 0x4E, 0x0C, 0x77, 0x77, 0x09, 0xE0,
  0x77, 0x77, 0x70, 0xEE, 0x03, 0x77, 0x76, 0x04, 0xE0, 0xD7, 0x77, 0x70, 0xAE, 0x08, 0x77, 0x77,
  0x0E, 0xE0, 0x37, 0x77, 0x60, 0x5E, 0x0E, 0x77, 0x77, 0x0A, 0xE0, 0x97, 0x77, 0x70, 0xEE, 0x04,
  0x77, 0x76, 0x05, 0xE0, 0xE7, 0x77, 0x70, 0xAE, 0x09, 0x77, 0x77, 0x0E, 0xE0, 0x47, 0x77, 0x60,
  0x5E, 0x0E, 0x77, 0x77, 0x0A, 0xE0, 0xA7, 0x77, 0x7F, 0x05, 0x77, 0x76, 0x05, 0xF7, 0x77, 0x70,
  0xAE, 0x0B, 0x77, 0x76, 0x01, 0xF0, 0x67, 0x77, 0x60, 0x5F, 0x01, 0x77, 0x76, 0x0B, 0xE0, 0xB7,
  0x77, 0x60, 0x1F, 0x06, 0x77, 0x76, 0x06, 0xF0, 0x17, 0x77, 0x60, 0xBE, 0x0C, 0x77, 0x76, 0x01,
  0xF0, 0x77, 0x77, 0x60, 0x6F, 0x02, 0x77, 0x76, 0x0B, 0xE0, 0xD7, 0x77, 0x60, 0x1F, 0x08, 0x77,
  0x76, 0x06, 0xF0, 0x37, 0x77, 0x60, 0xBE, 0x0D, 0x77, 0x76, 0x01, 0xF0, 0x87, 0x77, 0x60, 0x6F,
  0x03, 0x77, 0x76, 0x0B, 0xE0, 0xE7, 0x77, 0x60, 0x1F, 0x09, 0x77, 0x76, 0x06, 0xF0, 0x47, 0x77,
  0x60, 0xCE, 0x0E, 0x77, 0x76, 0x01, 0xF0, 0xA7, 0x77, 0x60, 0x7F, 0x05, 0x77, 0x76, 0x0C, 0xE0,
  0xE7, 0x77, 0x60, 0x2F, 0x0A, 0x77, 0x60,
  // "8" (U+0038)
  0x75, 0x84, 0x26, 0x9C, 0xDE, 0xA8, 0x3E, 0xCA, 0x73, 0x77, 0x71, 0x06, 0x0C, 0xFE, 0x0D, 0x06,
  0x77, 0x40, 0x40, 0xDF, 0xFB, 0x0D, 0x04, 0x77, 0x10, 0x8F, 0xFF, 0x07, 0x76, 0x09, 0xFA, 0x83,
  0xCA, 0x9A, 0xCF, 0xA0, 0x77, 0x40, 0x7F, 0x90, 0x80, 0x15, 0x01, 0x08, 0xF9, 0x04, 0x72, 0x03,
  0xF0, 0xE0, 0x37, 0x20, 0x40, 0xEE, 0x0E, 0x01, 0x71, 0x0C, 0xF0, 0x37, 0x40, 0x4F, 0x08, 0x70,
  0x5F, 0x08, 0x76, 0x09, 0xE0, 0xE0, 0x16, 0x0B, 0xF0, 0x17, 0x60, 0x1F, 0x06, 0x50, 0x1F, 0x0A,
  0x77, 0x10, 0xBE, 0x0A, 0x50, 0x5F, 0x05, 0x77, 0x10, 0x7E, 0x0E, 0x50, 0x8F, 0x02, 0x77, 0x10,
  0x3F, 0x01, 0x40, 0xAF, 0x77, 0x20, 0x1F, 0x03, 0x40, 0xCF, 0x77, 0x3F, 0x04, 0x40, 0xDF, 0x77,
  0x30, 0xEE, 0x05, 0x40, 0xDF, 0x77, 0x3F, 0x04, 0x40, 0xCF, 0x01, 0x77, 0x2F, 0x03, 0x40, 0xBF,
  0x05, 0x77, 0x10, 0x2F, 0x01, 0x40, 0x9F, 0x08, 0x77, 0x10, 0x4E, 0x0D, 0x50, 0x5F, 0x0E, 0x77,
  0x10, 0x7E, 0x0A, 0x50, 0x2F, 0x90, 0x57, 0x70, 0xBE, 0x05, 0x60, 0xCF, 0x0E, 0x01, 0x75, 0x01,
  0xE0, 0xE7, 0x06, 0xF9, 0x0B, 0x75, 0x06, 0xE0, 0x77, 0x10, 0xDF, 0x90, 0xB7, 0x30, 0x10, 0xED,
  0x0D, 0x72, 0x04, 0xFA, 0x0B, 0x01, 0x71, 0x0A, 0xD0, 0xE0, 0x27, 0x30, 0x8F, 0xA0, 0xD0, 0x36,
  0x07, 0xE0, 0x47, 0x50, 0xAF, 0xB0, 0x84, 0x07, 0xD0, 0xE0, 0x47, 0x70, 0xBF, 0xB8, 0x2D, 0x41,
  0xAD, 0x0D, 0x03, 0x77, 0x20, 0xAF, 0xC0, 0xED, 0x0B, 0x01, 0x77, 0x40, 0x8F, 0xF0, 0xD0, 0x57,
  0x77, 0x04, 0x0E, 0xFD, 0x09, 0x01, 0x77, 0x71, 0x04, 0xFE, 0x0E, 0x06, 0x77, 0x50, 0x10, 0x9F,
  0xFA, 0x0B, 0x01, 0x77, 0x20, 0x40, 0xED, 0x0C, 0x0E, 0xFC, 0x0E, 0x05, 0x77, 0x08, 0xE8, 0x28,
  0x01, 0x9F, 0xD0, 0x77, 0x50, 0xAE, 0x06, 0x40, 0x30, 0xCF, 0xC0, 0x97, 0x30, 0xBE, 0x06, 0x70,
  0x7F, 0xC0, 0x87, 0x10, 0xBE, 0x09, 0x72, 0x02, 0x0D, 0xFB, 0x06, 0x60, 0x9E, 0x0D, 0x75, 0x0A,
  0xFA, 0x0E, 0x02, 0x40, 0x4F, 0x04, 0x76, 0x08, 0xFA, 0x0B, 0x40, 0xDE, 0x0C, 0x77, 0x10, 0x8F,
  0xA0, 0x22, 0x04, 0xF0, 0x57, 0x72, 0x0B, 0xF9, 0x09, 0x20, 0xAF, 0x01, 0x77, 0x20, 0x10, 0xEF,
  0x0D, 0x20, 0xEE, 0x0C, 0x77, 0x40, 0x8F, 0x90, 0x10, 0x2F, 0x09, 0x77, 0x40, 0x1F, 0x90, 0x05,
  0xF0, 0x67, 0x75, 0x0B, 0xF0, 0x06, 0xF0, 0x57, 0x75, 0x07, 0xF0, 0x07, 0xF0, 0x47, 0x75, 0x05,
  0xF0, 0x08, 0xF0, 0x47, 0x75, 0x04, 0xF0, 0x08, 0xF0, 0x57, 0x75, 0x04, 0xF0, 0x80, 0x7F, 0x05,
  0x77, 0x50, 0x5F, 0x06, 0x05, 0xF0, 0x87, 0x75, 0x06, 0xF0, 0x40, 0x2F, 0x0B, 0x77, 0x50, 0xAF,
  0x81, 0x10, 0xDE, 0x0E, 0x77, 0x50, 0xDE, 0x0D, 0x20, 0x9F, 0x05, 0x77, 0x30, 0x4F, 0x08, 0x20,
  0x3F, 0x0C, 0x77, 0x30, 0xBF, 0x02, 0x30, 0xCF, 0x06, 0x77, 0x10, 0x6F, 0x0A, 0x40, 0x3F, 0x0E,
  0x03, 0x76, 0x04, 0xF9, 0x02, 0x50, 0x9F, 0x0E, 0x04, 0x74, 0x06, 0xF9, 0x06, 0x70, 0xBF, 0x90,
  0xA0, 0x37, 0x05, 0x0C, 0xF9, 0x08, 0x71, 0x01, 0x0B, 0xFA, 0x84, 0xEB, 0xA9, 0xAC, 0xFB, 0x08,
  0x74, 0x09, 0xFF, 0xF9, 0x0E, 0x05, 0x76, 0x04, 0x0D, 0xFF, 0xD0, 0xA0, 0x17, 0x72, 0x05, 0x0C,
  0xFF, 0x81, 0xE9, 0x27, 0x76, 0x84, 0x15, 0x9B, 0xDE, 0xA8, 0x4E, 0xDC, 0xA7, 0x37, 0x50,
  // "9" (U+0039)
  0x75, 0x89, 0x15, 0x8C, 0xDE, 0xFD, 0xC9, 0x51, 0x77, 0x71, 0x81, 0x18, 0xEF, 0xC0, 0x90, 0x27,
  0x75, 0x05, 0x0E, 0xFF, 0x90, 0x87, 0x73, 0x08, 0xFF, 0xC0, 0xD0, 0x27, 0x70, 0x9F, 0x98, 0x3D,
  0xA9, 0xAE, 0xF0, 0xE0, 0x37, 0x50, 0x7F, 0x0D, 0x04, 0x50, 0x60, 0xEE, 0x0E, 0x01, 0x73, 0x03,
  0xF0, 0xD0, 0x17, 0x02, 0x0D, 0xE0, 0xC7, 0x30, 0xDE, 0x0E, 0x02, 0x72, 0x02, 0x0E, 0xE0, 0x87,
  0x10, 0x7F, 0x07, 0x74, 0x07, 0xF0, 0x27, 0x0D, 0xE0, 0xE7, 0x60, 0xDE, 0x0A, 0x60, 0x5F, 0x09,
  0x76, 0x06, 0xF0, 0x25, 0x0B, 0xF0, 0x37, 0x70, 0xEE, 0x08, 0x40, 0x1F, 0x97, 0x71, 0x0A, 0xE0,
  0xE4, 0x05, 0xF0, 0xB7, 0x71, 0x05, 0xF0, 0x43, 0x08, 0xF0, 0x87, 0x71, 0x01, 0xF0, 0x93, 0x0B,
  0xF0, 0x67, 0x72, 0x0D, 0xE0, 0xD3, 0x0E, 0xF0, 0x57, 0x72, 0x0A, 0xF0, 0x22, 0xF9, 0x03, 0x77,
  0x20, 0x8F, 0x81, 0x50, 0x2F, 0x90, 0x27, 0x72, 0x05, 0xF8, 0x18, 0x03, 0xF9, 0x01, 0x77, 0x20,
  0x3F, 0x81, 0xB0, 0x4F, 0x90, 0x17, 0x72, 0x02, 0xF8, 0x1E, 0x04, 0xF9, 0x01, 0x77, 0x3F, 0x91,
  0x04, 0xF9, 0x01, 0x77, 0x30, 0xEF, 0x01, 0x04, 0xF9, 0x02, 0x77, 0x30, 0xDF, 0x03, 0x02, 0xF9,
  0x02, 0x77, 0x30, 0xCF, 0x04, 0x01, 0xF9, 0x04, 0x77, 0x30, 0xBF, 0x81, 0x50, 0xEF, 0x06, 0x77,
  0x30, 0xBF, 0x81, 0x60, 0xBF, 0x09, 0x77, 0x30, 0xBF, 0x81, 0x60, 0x8F, 0x0D, 0x77, 0x30, 0xAF,
  0x81, 0x70, 0x4F, 0x90, 0x27, 0x71, 0x01, 0x0E, 0xF0, 0x72, 0x0E, 0xF0, 0x77, 0x71, 0x09, 0xF9,
  0x07, 0x20, 0x7F, 0x0E, 0x77, 0x05, 0xFA, 0x07, 0x20, 0x10, 0xEF, 0x0A, 0x75, 0x04, 0xFB, 0x07,
  0x30, 0x6F, 0x90, 0x87, 0x30, 0x6F, 0xC0, 0x64, 0x0B, 0xF9, 0x0B, 0x04, 0x60, 0x30, 0xBB, 0x00,
  0xDF, 0x06, 0x50, 0xCF, 0xA8, 0x4D, 0xB9, 0x9B, 0xEC, 0x81, 0xD2, 0xCF, 0x05, 0x50, 0x10, 0xBF,
  0xFB, 0x82, 0xC2, 0x0D, 0xF0, 0x47, 0x08, 0xFF, 0x90, 0x93, 0x0E, 0xF0, 0x27, 0x10, 0x20, 0xAF,
  0xC0, 0xC0, 0x44, 0xF9, 0x01, 0x73, 0x83, 0x16, 0xAC, 0xEA, 0x82, 0xDB, 0x83, 0x6F, 0x97, 0x77,
  0x60, 0x2F, 0x0D, 0x77, 0x76, 0x03, 0xF0, 0xB7, 0x77, 0x60, 0x5F, 0x09, 0x77, 0x76, 0x06, 0xF0,
  0x77, 0x77, 0x60, 0x9F, 0x04, 0x77, 0x76, 0x0B, 0xF0, 0x17, 0x77, 0x60, 0xDE, 0x0D, 0x77, 0x77,
  0xF0, 0x97, 0x77, 0x60, 0x3F, 0x06, 0x77, 0x76, 0x07, 0xF0, 0x17, 0x77, 0x60, 0xBE, 0x0B, 0x77,
  0x77, 0x0E, 0xE0, 0x77, 0x77, 0x60, 0x4F, 0x01, 0x77, 0x76, 0x09, 0xE0, 0xA7, 0x10, 0x10, 0x77,
  0x74, 0x0E, 0xE0, 0x37, 0x82, 0x1D, 0xF5, 0x77, 0x20, 0x7E, 0x0B, 0x71, 0x08, 0xA0, 0xC7, 0x71,
  0x01, 0x0E, 0xE0, 0x37, 0x10, 0xDB, 0x07, 0x77, 0x0A, 0xE0, 0x87, 0x20, 0xEC, 0x04, 0x75, 0x07,
  0xE0, 0xD7, 0x30, 0xDC, 0x0E, 0x03, 0x73, 0x08, 0xE0, 0xE0, 0x27, 0x30, 0x9E, 0x08, 0x02, 0x60,
  0x40, 0xCF, 0x04, 0x74, 0x03, 0xF9, 0x84, 0xDA, 0x99, 0xBE, 0xF9, 0x06, 0x76, 0x08, 0xFF, 0xD0,
  0xE0, 0x47, 0x71, 0x09, 0xFF, 0xB0, 0xA0, 0x17, 0x73, 0x05, 0x0D, 0xFE, 0x0A, 0x03, 0x77, 0x78,
  0x93, 0x37, 0xAD, 0xEE, 0xFE, 0xDC, 0x95, 0x17, 0x71,
  // ":" (U+003A)
  0x28, 0x48, 0xDF, 0xEB, 0x42, 0x01, 0x0D, 0xE8, 0x18, 0x08, 0xF9, 0x03, 0x0D, 0xF9, 0x08, 0xFA,
  0x0A, 0xFA, 0x0B, 0xFA, 0x0A, 0x0D, 0xF9, 0x00, 0x8F, 0x98, 0x13, 0x1D, 0xE0, 0x82, 0x85, 0x18,
  0xDF, 0xEB, 0x48, 0x0C, 0x96, 0x08, 0x47, 0xDF, 0xEB, 0x42, 0x01, 0x0D, 0xE8, 0x18, 0x08, 0xF9,
  0x03, 0x0D, 0xF9, 0x08, 0xFA, 0x0A, 0xFA, 0x0B, 0xFA, 0x0A, 0x0D, 0xF9, 0x00, 0x8F, 0x98, 0x13,
  0x1D, 0xE0, 0x83, 0x84, 0x8D, 0xFE, 0xB4, 0x20,
  // ";" (U+003B)
  0x58, 0x48, 0xDF, 0xEB, 0x55, 0x01, 0x0D, 0xE0, 0x84, 0x08, 0xF9, 0x03, 0x30, 0xDF, 0x90, 0x83,
  0xFA, 0x0A, 0x3F, 0xA0, 0xB3, 0xFA, 0x0A, 0x30, 0xDF, 0x90, 0x83, 0x08, 0xF9, 0x03, 0x30, 0x10,
  0xDE, 0x09, 0x58, 0x51, 0x8D, 0xFE, 0xB5, 0x80, 0xD9, 0x00, 0x82, 0x37, 0x74, 0x70, 0x10, 0xBC,
  0x0D, 0x04, 0x50, 0xBF, 0x03, 0x30, 0x4F, 0x90, 0xD3, 0x07, 0xFA, 0x05, 0x20, 0x8F, 0xA0, 0xA2,
  0x07, 0xFA, 0x0D, 0x20, 0x3F, 0xA0, 0xE3, 0x0A, 0xFA, 0x40, 0xAF, 0x0E, 0x50, 0x7E, 0x0D, 0x60,
  0x4D, 0x0C, 0x70, 0x8C, 0x08, 0x70, 0x5C, 0x05, 0x70, 0x5C, 0x01, 0x70, 0x9B, 0x0A, 0x71, 0x0E,
  0xB0, 0x37, 0x08, 0xB0, 0xB7, 0x04, 0xC0, 0x26, 0x05, 0xC0, 0x65, 0x01, 0x0A, 0xC0, 0x94, 0x01,
  0x09, 0xD0, 0x75, 0x03, 0xC0, 0xD0, 0x56, 0x03, 0xB0, 0x87, 0x18, 0x23, 0xD7, 0x17, 0x20,
  // "<" (U+003C)
  0x77, 0x77, 0x50, 0x27, 0x77, 0x73, 0x81, 0x3D, 0x67, 0x77, 0x71, 0x01, 0x09, 0xA0, 0x67, 0x77,
  0x70, 0x50, 0xEB, 0x06, 0x77, 0x75, 0x02, 0x0B, 0xD0, 0x67, 0x77, 0x40, 0x70, 0xEE, 0x06, 0x77,
  0x72, 0x03, 0x0C, 0xF0, 0xE0, 0x37, 0x77, 0x10, 0x8F, 0x90, 0x90, 0x17, 0x77, 0x04, 0x0D, 0xF0,
  0xD0, 0x47, 0x77, 0x01, 0x0A, 0xF9, 0x08, 0x77, 0x71, 0x06, 0x0E, 0xF0, 0xC0, 0x37, 0x77, 0x03,
  0x0C, 0xF9, 0x07, 0x77, 0x71, 0x08, 0xF9, 0x0B, 0x02, 0x77, 0x70, 0x40, 0xDF, 0x0E, 0x06, 0x77,
  0x70, 0x10, 0xAF, 0x90, 0xA0, 0x17, 0x77, 0x06, 0x0E, 0xF0, 0xE0, 0x57, 0x77, 0x02, 0x0B, 0xF9,
  0x09, 0x01, 0x77, 0x70, 0x8F, 0x90, 0xD0, 0x47, 0x77, 0x04, 0x0D, 0xF9, 0x08, 0x77, 0x70, 0x10,
  0x9F, 0x90, 0xC0, 0x37, 0x77, 0x05, 0x0E, 0xF9, 0x07, 0x77, 0x71, 0x07, 0xF9, 0x0B, 0x02, 0x77,
  0x72, 0x07, 0xF0, 0x67, 0x77, 0x40, 0x7F, 0x0A, 0x01, 0x77, 0x73, 0x04, 0x0E, 0xF0, 0xE0, 0x67,
  0x77, 0x30, 0x10, 0xAF, 0x90, 0xC0, 0x27, 0x77, 0x30, 0x40, 0xDF, 0x90, 0x87, 0x77, 0x40, 0x8F,
  0x90, 0xD0, 0x47, 0x77, 0x30, 0x20, 0xCF, 0x90, 0x90, 0x17, 0x77, 0x30, 0x60, 0xEF, 0x0E, 0x05,
  0x77, 0x73, 0x01, 0x0A, 0xF9, 0x0B, 0x02, 0x77, 0x73, 0x04, 0x0D, 0xF0, 0xE0, 0x77, 0x77, 0x40,
  0x8F, 0x90, 0xC0, 0x37, 0x77, 0x30, 0x20, 0xCF, 0x90, 0x87, 0x77, 0x40, 0x60, 0xEF, 0x0D, 0x04,
  0x77, 0x73, 0x01, 0x0A, 0xF9, 0x0A, 0x01, 0x77, 0x73, 0x04, 0x0D, 0xF0, 0xE0, 0x67, 0x77, 0x40,
  0x8F, 0x90, 0xB0, 0x27, 0x77, 0x30, 0x20, 0xCF, 0x90, 0x77, 0x77, 0x40, 0x60, 0xEF, 0x06, 0x77,
  0x74, 0x01, 0x0A, 0xE0, 0x67, 0x77, 0x60, 0x40, 0xDC, 0x06, 0x77, 0x77, 0x10, 0x8B, 0x06, 0x77,
  0x77, 0x28, 0x23, 0xCF, 0x67, 0x77, 0x74, 0x06, 0x05,
  // "=" (U+003D)
  0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06, 0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF,
  0xFC, 0x06, 0x04, 0x80, 0xB4, 0x90, 0x48, 0x0E, 0xA4, 0x00, 0x48, 0x0B, 0x49, 0x04, 0x07, 0xFF,
  0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06, 0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06,
  // ">" (U+003E)
  0x02, 0x77, 0x77, 0x58, 0x17, 0xC3, 0x77, 0x77, 0x30, 0x7A, 0x08, 0x77, 0x77, 0x20, 0x7B, 0x0D,
  0x04, 0x77, 0x77, 0x07, 0xD0, 0xA0, 0x17, 0x77, 0x50, 0x7E, 0x0E, 0x06, 0x77, 0x74, 0x04, 0x0E,
  0xF0, 0xC0, 0x27, 0x77, 0x30, 0x10, 0xAF, 0x90, 0x87, 0x77, 0x40, 0x50, 0xEF, 0x0D, 0x04, 0x77,
  0x73, 0x01, 0x09, 0xF9, 0x0A, 0x01, 0x77, 0x73, 0x04, 0x0D, 0xF0, 0xE0, 0x67, 0x77, 0x40, 0x8F,
  0x90, 0xB0, 0x27, 0x77, 0x30, 0x30, 0xCF, 0x90, 0x77, 0x77, 0x40, 0x7F, 0x90, 0xD0, 0x37, 0x77,
  0x30, 0x20, 0xBF, 0x90, 0x90, 0x17, 0x77, 0x30, 0x60, 0xEF, 0x0E, 0x05, 0x77, 0x73, 0x01, 0x0B,
  0xF9, 0x0B, 0x02, 0x77, 0x73, 0x05, 0x0E, 0xF9, 0x07, 0x77, 0x73, 0x01, 0x0A, 0xF9, 0x0C, 0x03,
  0x77, 0x73, 0x04, 0x0D, 0xF9, 0x09, 0x01, 0x77, 0x73, 0x09, 0xF9, 0x0E, 0x05, 0x77, 0x73, 0x03,
  0x0D, 0xF9, 0x06, 0x77, 0x74, 0x08, 0xF0, 0x67, 0x77, 0x30, 0x20, 0xBF, 0x06, 0x77, 0x72, 0x07,
  0xF9, 0x0E, 0x03, 0x77, 0x70, 0x30, 0xDF, 0x90, 0x90, 0x17, 0x76, 0x01, 0x09, 0xF9, 0x0D, 0x03,
  0x77, 0x70, 0x50, 0xDF, 0x90, 0x77, 0x77, 0x01, 0x0A, 0xF9, 0x0B, 0x02, 0x77, 0x70, 0x60, 0xEF,
  0x0E, 0x05, 0x77, 0x70, 0x20, 0xCF, 0x90, 0x90, 0x17, 0x77, 0x08, 0xF9, 0x0D, 0x03, 0x77, 0x70,
  0x40, 0xDF, 0x90, 0x77, 0x77, 0x01, 0x09, 0xF9, 0x0B, 0x02, 0x77, 0x70, 0x50, 0xEF, 0x0E, 0x05,
  0x77, 0x70, 0x20, 0xBF, 0x90, 0x90, 0x17, 0x77, 0x07, 0x0E, 0xF0, 0xD0, 0x47, 0x77, 0x03, 0x0C,
  0xF9, 0x07, 0x77, 0x71, 0x08, 0xF9, 0x0B, 0x02, 0x77, 0x71, 0x07, 0xF0, 0xE0, 0x67, 0x77, 0x30,
  0x7E, 0x09, 0x01, 0x77, 0x74, 0x07, 0xC0, 0xD0, 0x47, 0x77, 0x60, 0x7B, 0x08, 0x77, 0x77, 0x18,
  0x27, 0xFB, 0x27, 0x77, 0x72, 0x00, 0x67, 0x77, 0x74,
  // "?" (U+003F)
  0x71, 0x84, 0x36, 0x9C, 0xDE, 0xA8, 0x3E, 0xDB, 0x85, 0x77, 0x28, 0x11, 0x7D, 0xFF, 0x0A, 0x03,
  0x75, 0x05, 0x0E, 0xFF, 0xC0, 0xA0, 0x17, 0x20, 0x9F, 0xFF, 0x0E, 0x04, 0x70, 0x9F, 0xA8, 0x4E,
  0xBA, 0x9B, 0xEF, 0xA0, 0x55, 0x05, 0xF9, 0x0D, 0x05, 0x60, 0x40, 0xCF, 0x90, 0x44, 0x0E, 0xF0,
  0xC0, 0x17, 0x20, 0xAF, 0x0E, 0x01, 0x20, 0x6F, 0x0E, 0x01, 0x74, 0x0C, 0xF0, 0xA2, 0x0B, 0xF0,
  0x77, 0x50, 0x3F, 0x98, 0x12, 0x0D, 0xF0, 0x17, 0x60, 0xBF, 0x81, 0x90, 0xEE, 0x0B, 0x77, 0x05,
  0xF8, 0x1E, 0x0D, 0xE0, 0x67, 0x70, 0x1F, 0x90, 0x30, 0x9E, 0x04, 0x77, 0x10, 0xDF, 0x06, 0x02,
  0xE0, 0x17, 0x71, 0x0A, 0xF8, 0x28, 0x03, 0xDC, 0x77, 0x20, 0x9F, 0x0A, 0x38, 0x26, 0xAD, 0xE7,
  0x72, 0x08, 0xF0, 0xA7, 0x77, 0x20, 0x9F, 0x0B, 0x77, 0x72, 0x09, 0xF0, 0xA7, 0x77, 0x20, 0xAF,
  0x09, 0x77, 0x72, 0x0C, 0xF0, 0x87, 0x77, 0x2F, 0x90, 0x67, 0x77, 0x10, 0x3F, 0x90, 0x27, 0x77,
  0x10, 0x7F, 0x0E, 0x77, 0x72, 0x0C, 0xF0, 0xB7, 0x77, 0x10, 0x2F, 0x90, 0x57, 0x77, 0x10, 0x9F,
  0x0E, 0x77, 0x71, 0x01, 0xF9, 0x07, 0x77, 0x71, 0x0A, 0xF0, 0xD7, 0x77, 0x10, 0x5F, 0x90, 0x37,
  0x77, 0x03, 0xF9, 0x06, 0x77, 0x70, 0x30, 0xEF, 0x08, 0x77, 0x70, 0x5F, 0x90, 0x87, 0x76, 0x01,
  0x0A, 0xF9, 0x06, 0x77, 0x60, 0x50, 0xEF, 0x0D, 0x04, 0x77, 0x50, 0x10, 0xCF, 0x90, 0xA0, 0x17,
  0x76, 0x02, 0xF0, 0xC0, 0x47, 0x77, 0x10, 0x2D, 0x0D, 0x06, 0x77, 0x73, 0x01, 0xD0, 0x37, 0x77,
  0x5D, 0x02, 0x77, 0x75, 0xD0, 0x17, 0x77, 0x50, 0xEC, 0x77, 0x76, 0x0D, 0xC7, 0x77, 0x60, 0xDB,
  0x0E, 0x77, 0x76, 0x0C, 0xB0, 0xD7, 0x77, 0x60, 0xBB, 0x0C, 0x77, 0x76, 0x0A, 0xB0, 0xB7, 0x77,
  0x60, 0xAB, 0x0A, 0x77, 0x76, 0x83, 0x13, 0x33, 0x18, 0x0B, 0xE6, 0x08, 0x52, 0xAE, 0xFD, 0x91,
  0x77, 0x73, 0x04, 0xE0, 0xE0, 0x37, 0x77, 0x20, 0xDF, 0x0D, 0x77, 0x71, 0x03, 0xFA, 0x02, 0x77,
  0x70, 0x5F, 0xA0, 0x57, 0x77, 0x06, 0xFA, 0x06, 0x77, 0x70, 0x5F, 0xA0, 0x57, 0x77, 0x03, 0xFA,
  0x02, 0x77, 0x71, 0x0D, 0xF0, 0xD7, 0x77, 0x20, 0x4E, 0x0E, 0x03, 0x77, 0x73, 0x85, 0x2A, 0xEF,
  0xD9, 0x17, 0x70,
  // "@" (U+0040)
  0x77, 0x77, 0x89, 0x53, 0x58, 0xBC, 0xDE, 0xFE, 0xDC, 0xB9, 0x63, 0x80, 0xD0, 0x08, 0x15, 0x9E,
  0xFF, 0xA0, 0xA0, 0x58, 0x0C, 0x20, 0x81, 0x28, 0xEF, 0xFF, 0x0E, 0x07, 0x77, 0x77, 0x60, 0x20,
  0xAF, 0xFF, 0xD0, 0xE0, 0x67, 0x77, 0x72, 0x01, 0x08, 0xFA, 0x83, 0xB8, 0x52, 0x12, 0x84, 0x12,
  0x36, 0x9C, 0xF9, 0x0B, 0x01, 0x77, 0x76, 0x04, 0x0D, 0xF8, 0x1B, 0x51, 0x76, 0x81, 0x27, 0xDE,
  0x0E, 0x04, 0x77, 0x74, 0x08, 0xF0, 0xA0, 0x37, 0x75, 0x05, 0x0D, 0xE0, 0x47, 0x77, 0x10, 0x10,
  0xBE, 0x0C, 0x03, 0x77, 0x72, 0x08, 0xE0, 0x47, 0x76, 0x01, 0x0C, 0xE0, 0x77, 0x77, 0x50, 0x30,
  0xED, 0x03, 0x77, 0x40, 0x20, 0xDD, 0x0E, 0x03, 0x77, 0x77, 0x02, 0x0D, 0xC0, 0xD0, 0x17, 0x72,
  0x01, 0x0D, 0xD0, 0xC0, 0x17, 0x77, 0x72, 0x01, 0x0D, 0xC0, 0xA7, 0x71, 0x01, 0x0C, 0xD0, 0xC0,
  0x17, 0x77, 0x74, 0x03, 0xD0, 0x57, 0x70, 0xBD, 0x0B, 0x77, 0x77, 0x70, 0x6C, 0x0D, 0x76, 0x07,
  0xD0, 0xD0, 0x18, 0x0C, 0x00, 0x0B, 0xC0, 0x67, 0x40, 0x3D, 0x0E, 0x02, 0x80, 0xC1, 0x00, 0x2C,
  0x0D, 0x73, 0x01, 0x0D, 0xD0, 0x48, 0x0C, 0x30, 0x09, 0xC0, 0x47, 0x20, 0x9D, 0x09, 0x77, 0x18,
  0x90, 0x38, 0xBD, 0xEF, 0xEC, 0x95, 0x60, 0x40, 0x37, 0x03, 0xC0, 0xA7, 0x10, 0x2D, 0x0D, 0x77,
  0x07, 0x0D, 0xFB, 0x0E, 0x07, 0x28, 0x26, 0xEF, 0xB7, 0x10, 0xCC, 0x71, 0x0C, 0xD0, 0x47, 0x50,
  0x50, 0xEF, 0xF0, 0x0D, 0xB0, 0x87, 0x10, 0x6C, 0x04, 0x60, 0x4D, 0x0A, 0x75, 0x09, 0xE8, 0x59,
  0x41, 0x02, 0x6D, 0xF9, 0x05, 0x71, 0x01, 0xC0, 0x86, 0x0C, 0xD0, 0x27, 0x40, 0xBD, 0x0B, 0x01,
  0x70, 0xBF, 0x03, 0x72, 0x0D, 0xB0, 0xC5, 0x04, 0xD0, 0x97, 0x40, 0xCD, 0x0A, 0x73, 0x0D, 0xE7,
  0x30, 0x9C, 0x50, 0xBD, 0x02, 0x73, 0x0A, 0xD0, 0xB7, 0x40, 0x9D, 0x0D, 0x73, 0x06, 0xC0, 0x23,
  0x02, 0xD0, 0xA7, 0x30, 0x7D, 0x0E, 0x01, 0x74, 0x0C, 0xD0, 0xA7, 0x30, 0x4C, 0x05, 0x30, 0x7D,
  0x04, 0x72, 0x03, 0xE0, 0x57, 0x50, 0xED, 0x07, 0x73, 0x02, 0xC0, 0x73, 0x0D, 0xC0, 0xD7, 0x30,
  0xCD, 0x0C, 0x75, 0x01, 0xE0, 0x57, 0x4C, 0x08, 0x20, 0x3D, 0x08, 0x72, 0x05, 0xE0, 0x57, 0x50,
  0x4E, 0x02, 0x74, 0xC0, 0x92, 0x08, 0xD0, 0x27, 0x20, 0xDD, 0x0D, 0x76, 0x07, 0xE7, 0x5C, 0x09,
  0x20, 0xCC, 0x0D, 0x72, 0x05, 0xE0, 0x87, 0x60, 0x9D, 0x0C, 0x75, 0x0E, 0xB8, 0x1A, 0x01, 0xD0,
  0x97, 0x20, 0xBE, 0x02, 0x76, 0x0C, 0xD0, 0xA7, 0x50, 0xEB, 0x81, 0xA0, 0x6D, 0x04, 0x71, 0x02,
  0xE0, 0xD7, 0x7E, 0x07, 0x75, 0x0E, 0xB8, 0x19, 0x09, 0xD7, 0x20, 0x7E, 0x08, 0x76, 0x02, 0xE0,
  0x47, 0x5C, 0x81, 0x90, 0xCC, 0x0D, 0x72, 0x0B, 0xE0, 0x47, 0x60, 0x5E, 0x02, 0x75, 0xC0, 0x81,
  0xD0, 0xA7, 0x2F, 0x01, 0x76, 0x07, 0xD0, 0xE7, 0x50, 0x1C, 0x07, 0x02, 0xD0, 0x77, 0x10, 0x3E,
  0x0D, 0x77, 0x0A, 0xD0, 0xC7, 0x50, 0x3C, 0x00, 0x5D, 0x04, 0x71, 0x07, 0xE0, 0xA7, 0x70, 0xDD,
  0x09, 0x75, 0x04, 0xC0, 0x30, 0x6D, 0x02, 0x71, 0x09, 0xE0, 0x77, 0x7E, 0x06, 0x75, 0x07, 0xC0,
  0x10, 0x8D, 0x01, 0x71, 0x0B, 0xE0, 0x57, 0x60, 0x2E, 0x04, 0x75, 0x0A, 0xB8, 0x1E, 0x0A, 0xD7,
  0x20, 0xDE, 0x03, 0x76, 0x05, 0xE0, 0x17, 0x50, 0xCB, 0x81, 0xB0, 0xBC, 0x0D, 0x72, 0x0E, 0xE0,
  0x27, 0x60, 0x8D, 0x0E, 0x75, 0x01, 0xC8, 0x18, 0x0C, 0xC0, 0xC7, 0x2F, 0x01, 0x76, 0x0A, 0xD0,
  0xD7, 0x50, 0x5C, 0x81, 0x40, 0xDC, 0x0C, 0x72, 0xF7, 0x70, 0xDD, 0x0B, 0x75, 0x09, 0xB0, 0xE2,
  0x0D, 0xC0, 0xB7, 0x20, 0xEE, 0x76, 0x01, 0xE0, 0x97, 0x50, 0xEB, 0x0A, 0x20, 0xEC, 0x0B, 0x72,
  0x0D, 0xE7, 0x60, 0x5E, 0x08, 0x74, 0x04, 0xC0, 0x52, 0x0E, 0xC0, 0xB7, 0x20, 0xCE, 0x01, 0x75,
  0x0A, 0xE0, 0x77, 0x40, 0xBB, 0x0E, 0x30, 0xEC, 0x0B, 0x72, 0x0A, 0xE0, 0x37, 0x40, 0x1F, 0x06,
  0x73, 0x02, 0xC0, 0x83, 0x0D, 0xC0, 0xC7, 0x20, 0x7E, 0x06, 0x74, 0x07, 0xF0, 0x77, 0x30, 0xAC,
  0x01, 0x30, 0xCC, 0x0D, 0x72, 0x04, 0xE0, 0xA7, 0x40, 0xEA, 0x0D, 0xC0, 0x97, 0x20, 0x3C, 0x08,
  0x40, 0xBC, 0x0D, 0x73, 0x0E, 0xD0, 0xE0, 0x17, 0x20, 0x7A, 0x0A, 0x06, 0xC0, 0xD7, 0x10, 0x10,
  0xDB, 0x0E, 0x01, 0x40, 0xBD, 0x73, 0x08, 0xE0, 0x97, 0x10, 0x4B, 0x02, 0x01, 0xD0, 0x37, 0x0B,
  0xC0, 0x65, 0x09, 0xD0, 0x27, 0x20, 0x2F, 0x06, 0x60, 0x30, 0xEA, 0x08, 0x20, 0xBC, 0x0D, 0x01,
  0x50, 0xAC, 0x0B, 0x60, 0x6D, 0x04, 0x73, 0x08, 0xF0, 0xA0, 0x32, 0x03, 0x08, 0xB0, 0xD3, 0x05,
  0xD8, 0x4D, 0x50, 0x15, 0xDC, 0x0D, 0x01, 0x60, 0x4D, 0x06, 0x74, 0x0C, 0xFF, 0x90, 0x34, 0x0C,
  0xFE, 0x0E, 0x02, 0x70, 0x2D, 0x09, 0x74, 0x01, 0x0C, 0xFE, 0x05, 0x50, 0x20, 0xEF, 0xC0, 0xE0,
  0x37, 0x20, 0xEC, 0x0D, 0x76, 0x0A, 0xFB, 0x0E, 0x05, 0x70, 0x30, 0xEF, 0xA0, 0xC0, 0x27, 0x30,
  0xAD, 0x02, 0x76, 0x04, 0x0C, 0xF0, 0xA0, 0x27, 0x20, 0x20, 0xAE, 0x0E, 0x06, 0x75, 0x06, 0xD0,
  0x67, 0x71, 0x85, 0x26, 0x78, 0x75, 0x17, 0x68, 0x41, 0x68, 0x87, 0x47, 0x70, 0x1D, 0x0C, 0x80,
  0xE4, 0x00, 0xCD, 0x03, 0x80, 0xE3, 0x00, 0x6D, 0x09, 0x80, 0xE4, 0x00, 0xED, 0x02, 0x80, 0xE3,
  0x00, 0x8D, 0x0B, 0x80, 0xE3, 0x00, 0x10, 0xED, 0x05, 0x80, 0xE3, 0x00, 0x6D, 0x0E, 0x02, 0x80,
  0xE3, 0x00, 0xCD, 0x0D, 0x01, 0x77, 0x77, 0x70, 0x77, 0x74, 0x02, 0x0E, 0xD0, 0xC0, 0x17, 0x77,
  0x74, 0x82, 0x2C, 0xF8, 0x77, 0x40, 0x5E, 0x0D, 0x01, 0x77, 0x77, 0x20, 0x8C, 0x03, 0x77, 0x40,
  0x7E, 0x0E, 0x05, 0x77, 0x76, 0x05, 0x0D, 0xC0, 0xE0, 0x37, 0x75, 0x08, 0xF0, 0xB0, 0x27, 0x77,
  0x20, 0x50, 0xCD, 0x0B, 0x01, 0x77, 0x70, 0x7F, 0x90, 0xB0, 0x47, 0x74, 0x81, 0x17, 0xDE, 0x07,
  0x77, 0x73, 0x05, 0x0E, 0xF9, 0x82, 0xE9, 0x52, 0x73, 0x82, 0x13, 0x7B, 0xF0, 0xB0, 0x27, 0x77,
  0x50, 0x10, 0xAF, 0xD8, 0x7C, 0xBA, 0x99, 0xAA, 0xCE, 0xFA, 0x0E, 0x05, 0x77, 0x77, 0x20, 0x50,
  0xDF, 0xFF, 0xD0, 0xE0, 0x77, 0x77, 0x76, 0x05, 0x0C, 0xFF, 0xF9, 0x81, 0xE8, 0x18, 0x0C, 0x10,
  0x81, 0x27, 0xCF, 0xFA, 0x81, 0xEA, 0x58, 0x0C, 0x70, 0x89, 0x61, 0x47, 0x9C, 0xDE, 0xEF, 0xED,
  0xDB, 0x96, 0x37, 0x77, 0x50,
  // "A" (U+0041)
  0x77, 0x73, 0x0D, 0xE0, 0x38, 0x0D, 0x20, 0x02, 0xF0, 0x78, 0x0D, 0x20, 0x07, 0xF0, 0xC8, 0x0D,
  0x20, 0x0C, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x2F, 0xA0, 0x78, 0x0D, 0x00, 0x07, 0xFA, 0x0B, 0x80,
  0xD0, 0x00, 0xCF, 0xB0, 0x18, 0x0C, 0x60, 0x01, 0xFC, 0x05, 0x80, 0xC6, 0x00, 0x6B, 0x0E, 0xF0,
  0xA8, 0x0C, 0x60, 0x0B, 0xB0, 0x90, 0xEF, 0x80, 0xC5, 0x00, 0x1C, 0x06, 0x0A, 0xF0, 0x58, 0x0C,
  0x40, 0x05, 0xC0, 0x20, 0x6F, 0x09, 0x80, 0xC4, 0x00, 0xAB, 0x81, 0xE0, 0x2F, 0x0E, 0x80, 0xC4,
  0x0C, 0x0A, 0x20, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0x5C, 0x06, 0x20, 0x9F, 0x08, 0x80, 0xC2, 0x00,
  0xAC, 0x01, 0x20, 0x5F, 0x0D, 0x80, 0xC2, 0x00, 0xEB, 0x0C, 0x4F, 0x90, 0x38, 0x0C, 0x00, 0x04,
  0xC0, 0x84, 0x0B, 0xF0, 0x78, 0x0C, 0x00, 0x09, 0xC0, 0x34, 0x07, 0xF0, 0xC8, 0x0C, 0x00, 0x0E,
  0xB0, 0xE5, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x3C, 0x0A, 0x60, 0xDF, 0x06, 0x77, 0x77, 0x60,
  0x8C, 0x05, 0x60, 0x9F, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x70, 0x4F, 0x90, 0x17, 0x77, 0x74, 0x03,
  0xC0, 0xB7, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0x8C, 0x06, 0x71, 0x0A, 0xF0, 0xA7, 0x77, 0x74,
  0x0D, 0xC0, 0x17, 0x10, 0x6F, 0x0E, 0x77, 0x77, 0x30, 0x2C, 0x0C, 0x72, 0x01, 0xF9, 0x04, 0x77,
  0x77, 0x20, 0x7C, 0x07, 0x73, 0x0C, 0xF0, 0x97, 0x77, 0x72, 0x0C, 0xC0, 0x37, 0x30, 0x8F, 0x0E,
  0x77, 0x77, 0x10, 0x1C, 0x0D, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x06, 0xC0, 0x97, 0x50, 0xEF,
  0x08, 0x77, 0x77, 0x0B, 0xC0, 0x47, 0x50, 0x9F, 0x0D, 0x77, 0x76, 0x01, 0xC0, 0xE7, 0x60, 0x5F,
  0x90, 0x27, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0xF9, 0x07, 0x77, 0x75, 0x0B, 0xC0, 0x57, 0x70, 0xBF,
  0x0C, 0x77, 0x75, 0xD0, 0x17, 0x70, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x5C, 0x0B, 0x77, 0x10, 0x2F,
  0x90, 0x67, 0x77, 0x30, 0xAC, 0x06, 0x77, 0x20, 0xDF, 0x0B, 0x77, 0x73, 0x0E, 0xFF, 0xFF, 0xA0,
  0x17, 0x77, 0x10, 0x4F, 0xFF, 0xFB, 0x05, 0x77, 0x71, 0x09, 0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x10,
  0xEF, 0xFF, 0xFB, 0x0E, 0x77, 0x70, 0x4C, 0x0D, 0x80, 0x97, 0x90, 0xBF, 0x90, 0x47, 0x76, 0x09,
  0xC0, 0x77, 0x75, 0x01, 0xF9, 0x09, 0x77, 0x60, 0xDC, 0x02, 0x77, 0x60, 0xCF, 0x0E, 0x77, 0x50,
  0x3C, 0x0D, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x74, 0x08, 0xC0, 0x87, 0x77, 0x02, 0xF9, 0x08, 0x77,
  0x40, 0xDC, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD7, 0x73, 0x02, 0xC0, 0xE7, 0x77, 0x20, 0x8F, 0x90,
  0x27, 0x72, 0x07, 0xC0, 0xA7, 0x77, 0x20, 0x4F, 0x90, 0x77, 0x72, 0x0C, 0xC0, 0x57, 0x77, 0x30,
  0xEF, 0x0C, 0x77, 0x10, 0x2D, 0x77, 0x74, 0x0A, 0xF9, 0x01, 0x77, 0x07, 0xC0, 0xB7, 0x77, 0x40,
  0x6F, 0x90, 0x67, 0x70, 0xCC, 0x07, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x76, 0x02, 0xD0, 0x47, 0x77,
  0x50, 0xEF, 0x97, 0x60, 0x8D, 0x02, 0x77, 0x75, 0x0B, 0xF9, 0x05, 0x75, 0x0E, 0xD0, 0x37, 0x77,
  0x50, 0xAF, 0x90, 0xA7, 0x40, 0x7E, 0x06, 0x77, 0x75, 0x0D, 0xFA, 0x02, 0x72, 0x02, 0x0E, 0xE0,
  0xD0, 0x17, 0x77, 0x30, 0x4F, 0xB0, 0xB7, 0x81, 0x16, 0xEF, 0x98, 0x1D, 0x62, 0x77, 0x60, 0x20,
  0x8F, 0xD8, 0x1C, 0x51, 0x20, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01,
  0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01,
  0x75, 0x01, 0xFF, 0xF0, 0xC0,
  // "B" (U+0042)
  0x03, 0xFF, 0xFA, 0x85, 0xED, 0xCA, 0x85, 0x27, 0x70, 0x3F, 0xFF, 0xFA, 0x81, 0xD9, 0x37, 0x40,
  0x3F, 0xFF, 0xFD, 0x0C, 0x04, 0x72, 0x81, 0x2D, 0xEF, 0xFF, 0xFD, 0x0A, 0x01, 0x74, 0x81, 0x27,
  0xEF, 0xA0, 0xC8, 0x01, 0x98, 0x2A, 0xAB, 0xEF, 0xC0, 0xD0, 0x27, 0x50, 0x20, 0xEF, 0x90, 0x87,
  0x28, 0x12, 0x6C, 0xFA, 0x0E, 0x02, 0x75, 0x07, 0xF9, 0x08, 0x75, 0x05, 0x0E, 0xF9, 0x0C, 0x75,
  0x02, 0xF9, 0x08, 0x76, 0x02, 0x0E, 0xF9, 0x06, 0x75, 0xF9, 0x08, 0x77, 0x04, 0xF9, 0x0E, 0x75,
  0x0E, 0xF0, 0x87, 0x71, 0x0C, 0xF9, 0x05, 0x74, 0x0E, 0xF0, 0x87, 0x71, 0x06, 0xF9, 0x09, 0x74,
  0x0E, 0xF0, 0x87, 0x71, 0x02, 0xF9, 0x0D, 0x74, 0x0E, 0xF0, 0x87, 0x72, 0xFA, 0x74, 0x0E, 0xF0,
  0x87, 0x72, 0x0D, 0xF9, 0x02, 0x73, 0x0E, 0xF0, 0x87, 0x72, 0x0B, 0xF9, 0x03, 0x73, 0x0E, 0xF0,
  0x87, 0x72, 0x0B, 0xF9, 0x04, 0x73, 0x0E, 0xF0, 0x87, 0x72, 0x0B, 0xF9, 0x03, 0x73, 0x0E, 0xF0,
  0x87, 0x72, 0x0C, 0xF9, 0x02, 0x73, 0x0E, 0xF0, 0x87, 0x72, 0x0D, 0xF9, 0x01, 0x73, 0x0E, 0xF0,
  0x87, 0x72, 0xF9, 0x0D, 0x74, 0x0E, 0xF0, 0x87, 0x71, 0x03, 0xF9, 0x09, 0x74, 0x0E, 0xF0, 0x87,
  0x71, 0x06, 0xF9, 0x04, 0x74, 0x0E, 0xF0, 0x87, 0x71, 0x0C, 0xF0, 0xD7, 0x50, 0xEF, 0x08, 0x77,
  0x03, 0xF9, 0x05, 0x75, 0x0E, 0xF0, 0x87, 0x70, 0xDF, 0x09, 0x76, 0x0E, 0xF0, 0x87, 0x60, 0xBF,
  0x0B, 0x77, 0x0E, 0xF0, 0x87, 0x40, 0x40, 0xDF, 0x0B, 0x77, 0x10, 0xEF, 0x08, 0x68, 0x31, 0x25,
  0x9D, 0xF9, 0x07, 0x77, 0x20, 0xEF, 0xFF, 0xC0, 0xB0, 0x27, 0x73, 0x0E, 0xFF, 0xFA, 0x0A, 0x02,
  0x77, 0x50, 0xEF, 0xFF, 0xA8, 0x1C, 0x73, 0x77, 0x40, 0xEF, 0xFF, 0xD0, 0xD0, 0x67, 0x72, 0x0E,
  0xF0, 0xC8, 0x04, 0x98, 0x1B, 0xCE, 0xFA, 0x0D, 0x03, 0x77, 0x0E, 0xF0, 0x87, 0x48, 0x13, 0x7E,
  0xF9, 0x06, 0x76, 0x0E, 0xF0, 0x87, 0x60, 0x10, 0x9F, 0x90, 0x77, 0x50, 0xEF, 0x08, 0x77, 0x10,
  0x8F, 0x90, 0x57, 0x40, 0xEF, 0x08, 0x77, 0x20, 0xBF, 0x0E, 0x01, 0x73, 0x0E, 0xF0, 0x87, 0x72,
  0x02, 0xF9, 0x09, 0x73, 0x0E, 0xF0, 0x87, 0x73, 0x0B, 0xF9, 0x01, 0x72, 0x0E, 0xF0, 0x87, 0x73,
  0x05, 0xF9, 0x06, 0x72, 0x0E, 0xF0, 0x87, 0x73, 0x01, 0xF9, 0x0B, 0x72, 0x0E, 0xF0, 0x87, 0x74,
  0x0D, 0xF0, 0xE7, 0x20, 0xEF, 0x08, 0x77, 0x40, 0xBF, 0x90, 0x27, 0x10, 0xEF, 0x08, 0x77, 0x40,
  0x9F, 0x90, 0x57, 0x10, 0xEF, 0x08, 0x77, 0x40, 0x8F, 0x90, 0x67, 0x10, 0xEF, 0x08, 0x77, 0x40,
  0x7F, 0x90, 0x77, 0x10, 0xEF, 0x08, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x10, 0xEF, 0x08, 0x77, 0x40,
  0x7F, 0x90, 0x77, 0x10, 0xEF, 0x08, 0x77, 0x40, 0x8F, 0x90, 0x77, 0x10, 0xEF, 0x08, 0x77, 0x40,
  0x9F, 0x90, 0x57, 0x10, 0xEF, 0x08, 0x77, 0x40, 0xBF, 0x90, 0x37, 0x10, 0xEF, 0x08, 0x77, 0x40,
  0xEF, 0x97, 0x20, 0xEF, 0x08, 0x77, 0x30, 0x2F, 0x90, 0xC7, 0x20, 0xEF, 0x08, 0x77, 0x30, 0x7F,
  0x90, 0x77, 0x2F, 0x90, 0x87, 0x73, 0x0D, 0xF9, 0x02, 0x72, 0xF9, 0x08, 0x77, 0x20, 0x7F, 0x90,
  0xA7, 0x20, 0x3F, 0x90, 0x87, 0x71, 0x05, 0xFA, 0x02, 0x72, 0x08, 0xF9, 0x08, 0x77, 0x07, 0xFA,
  0x07, 0x72, 0x02, 0x0E, 0xF9, 0x08, 0x74, 0x81, 0x27, 0xEF, 0xA0, 0xA7, 0x18, 0x12, 0x7E, 0xFA,
  0x0C, 0x80, 0x49, 0x81, 0xAC, 0xEF, 0xC0, 0x95, 0x82, 0x2D, 0xDE, 0xFF, 0xFF, 0xD0, 0xE0, 0x66,
  0x03, 0xFF, 0xFF, 0xF0, 0x90, 0x17, 0x03, 0xFF, 0xFF, 0xC8, 0x1C, 0x71, 0x72, 0x03, 0xFF, 0xFC,
  0x85, 0xED, 0xCA, 0x75, 0x17, 0x50,
  // "C" (U+0043)
  0x77, 0x48, 0x42, 0x69, 0xBD, 0xEA, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x77, 0x38, 0x12, 0x8E, 0xFF,
  0x90, 0xB0, 0x67, 0x76, 0x03, 0x0B, 0xFF, 0xE0, 0xD0, 0x47, 0x73, 0x09, 0xFF, 0xFB, 0x09, 0x77,
  0x02, 0x0D, 0xFA, 0x85, 0xEB, 0xA9, 0xAB, 0xEF, 0xB0, 0xB7, 0x50, 0x30, 0xEF, 0x81, 0xE8, 0x27,
  0x05, 0x0C, 0xFA, 0x09, 0x73, 0x03, 0x0E, 0xF0, 0x90, 0x17, 0x40, 0x8F, 0xA0, 0x37, 0x10, 0x20,
  0xEF, 0x06, 0x77, 0x08, 0xF9, 0x0A, 0x70, 0x10, 0xDF, 0x06, 0x77, 0x20, 0xCF, 0x97, 0x0A, 0xF0,
  0x97, 0x73, 0x03, 0xF9, 0x02, 0x50, 0x4F, 0x0D, 0x77, 0x50, 0xCF, 0x02, 0x50, 0xDF, 0x06, 0x77,
  0x50, 0x8F, 0x50, 0x7F, 0x0D, 0x77, 0x60, 0x4E, 0x0B, 0x50, 0xEF, 0x07, 0x77, 0x60, 0x1E, 0x03,
  0x40, 0x5F, 0x90, 0x17, 0x77, 0xC0, 0xE0, 0x55, 0x0C, 0xF0, 0xC7, 0x77, 0x18, 0x3D, 0xFD, 0x91,
  0x50, 0x2F, 0x90, 0x77, 0x77, 0x10, 0x20, 0x17, 0x10, 0x7F, 0x90, 0x37, 0x77, 0x74, 0x0C, 0xF0,
  0xE7, 0x77, 0x74, 0x01, 0xF9, 0x0C, 0x77, 0x77, 0x40, 0x5F, 0x90, 0x97, 0x77, 0x74, 0x08, 0xF9,
  0x06, 0x77, 0x77, 0x40, 0xBF, 0x90, 0x47, 0x77, 0x74, 0x0E, 0xF9, 0x01, 0x77, 0x77, 0x30, 0x1F,
  0xA7, 0x77, 0x74, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0x5F, 0x90, 0xC7, 0x77, 0x74, 0x06, 0xF9,
  0x0B, 0x77, 0x77, 0x40, 0x8F, 0x90, 0xB7, 0x77, 0x74, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x40, 0x9F,
  0x90, 0x97, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40, 0xAF, 0x90, 0x97, 0x77, 0x74, 0x0A,
  0xF9, 0x09, 0x77, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40,
  0x8F, 0x90, 0xA7, 0x77, 0x74, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x6F, 0x90, 0xC7, 0x77, 0x74,
  0x05, 0xF9, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xE7, 0x77, 0x74, 0x01, 0xFA, 0x01, 0x77, 0x77,
  0x40, 0xEF, 0x90, 0x37, 0x77, 0x74, 0x0B, 0xF9, 0x05, 0x77, 0x77, 0x40, 0x8F, 0x90, 0x77, 0x77,
  0x74, 0x05, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x2F, 0x90, 0xE7, 0x77, 0x75, 0x0D, 0xF9, 0x02, 0x77,
  0x77, 0x40, 0x8F, 0x90, 0x67, 0x77, 0x74, 0x03, 0xF9, 0x0B, 0x77, 0x77, 0x50, 0xDF, 0x90, 0x17,
  0x77, 0x74, 0x07, 0xF9, 0x07, 0x77, 0x77, 0x40, 0x1F, 0x90, 0xD7, 0x77, 0x75, 0x09, 0xF9, 0x05,
  0x77, 0x74, 0x0B, 0x03, 0x50, 0x10, 0xEF, 0x0D, 0x77, 0x73, 0x81, 0x9F, 0xB6, 0x07, 0xF9, 0x08,
  0x77, 0x71, 0x06, 0xA0, 0xE7, 0x0D, 0xF9, 0x04, 0x77, 0x60, 0x5B, 0x0E, 0x70, 0x3F, 0x90, 0xE0,
  0x37, 0x74, 0x07, 0xC0, 0xC7, 0x10, 0x5F, 0xA0, 0x67, 0x72, 0x09, 0xD0, 0x67, 0x20, 0x8F, 0xA0,
  0xB0, 0x37, 0x50, 0x50, 0xDD, 0x0D, 0x74, 0x07, 0xFB, 0x82, 0xC7, 0x41, 0x38, 0x31, 0x36, 0x9E,
  0xF0, 0x37, 0x50, 0x6F, 0xFF, 0xE0, 0x47, 0x70, 0x30, 0xDF, 0xFF, 0xA0, 0xD0, 0x37, 0x73, 0x08,
  0x0E, 0xFF, 0xD0, 0xE0, 0x77, 0x76, 0x81, 0x17, 0xCF, 0xF9, 0x81, 0xC7, 0x17, 0x77, 0x38, 0x42,
  0x69, 0xBD, 0xEA, 0x85, 0xEE, 0xCB, 0x85, 0x27, 0x30,
  // "D" (U+0044)
  0x03, 0xFF, 0xFB, 0x85, 0xEE, 0xDB, 0x96, 0x27, 0x74, 0x03, 0xFF, 0xFF, 0xB8, 0x1E, 0x93, 0x77,
  0x10, 0x3F, 0xFF, 0xFE, 0x0C, 0x04, 0x76, 0x81, 0x2D, 0xEF, 0xFF, 0xFE, 0x0B, 0x01, 0x77, 0x10,
  0x30, 0x8F, 0xB0, 0xD8, 0x03, 0x98, 0x1A, 0xCE, 0xFC, 0x0E, 0x05, 0x77, 0x20, 0x30, 0xEF, 0x90,
  0x97, 0x38, 0x12, 0x7C, 0xFB, 0x07, 0x77, 0x20, 0x7F, 0x90, 0x97, 0x60, 0x40, 0xCF, 0xA0, 0x97,
  0x71, 0x03, 0xF9, 0x09, 0x77, 0x10, 0x8F, 0xA0, 0x77, 0x71, 0xF9, 0x09, 0x77, 0x20, 0x5F, 0xA0,
  0x57, 0x70, 0xEF, 0x09, 0x77, 0x30, 0x5F, 0x90, 0xE0, 0x27, 0x60, 0xEF, 0x09, 0x77, 0x40, 0x8F,
  0x90, 0xC7, 0x60, 0xEF, 0x09, 0x77, 0x50, 0xCF, 0x90, 0x67, 0x50, 0xEF, 0x09, 0x77, 0x50, 0x3F,
  0x90, 0xE7, 0x50, 0xEF, 0x09, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x60, 0x3F,
  0x90, 0xD7, 0x40, 0xEF, 0x09, 0x77, 0x70, 0xCF, 0x90, 0x57, 0x30, 0xEF, 0x09, 0x77, 0x70, 0x7F,
  0x90, 0xA7, 0x30, 0xEF, 0x09, 0x77, 0x70, 0x1F, 0xA7, 0x30, 0xEF, 0x09, 0x77, 0x71, 0x0C, 0xF9,
  0x05, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x8F, 0x90, 0x97, 0x20, 0xEF, 0x09, 0x77, 0x71, 0x05,
  0xF9, 0x0C, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x2F, 0xA7, 0x20, 0xEF, 0x09, 0x77, 0x72, 0x0E,
  0xF9, 0x03, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0xCF, 0x90, 0x57, 0x10, 0xEF, 0x09, 0x77, 0x72,
  0x0A, 0xF9, 0x08, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x8F, 0x90, 0xA7, 0x10, 0xEF, 0x09, 0x77,
  0x72, 0x07, 0xF9, 0x0B, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x6F, 0x90, 0xD7, 0x10, 0xEF, 0x09,
  0x77, 0x72, 0x05, 0xF9, 0x0E, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x4F, 0x90, 0xE7, 0x10, 0xEF,
  0x09, 0x77, 0x72, 0x04, 0xFA, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x4F, 0xA7, 0x10, 0xEF, 0x09,
  0x77, 0x72, 0x04, 0xFA, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x4F, 0x90, 0xE7, 0x10, 0xEF, 0x09,
  0x77, 0x72, 0x04, 0xF9, 0x0E, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0xD7, 0x10, 0xEF,
  0x09, 0x77, 0x72, 0x06, 0xF9, 0x0D, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x7F, 0x90, 0xB7, 0x10,
  0xEF, 0x09, 0x77, 0x72, 0x08, 0xF9, 0x09, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0xAF, 0x90, 0x77,
  0x10, 0xEF, 0x09, 0x77, 0x72, 0x0C, 0xF9, 0x05, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0xEF, 0x90,
  0x37, 0x10, 0xEF, 0x09, 0x77, 0x71, 0x02, 0xFA, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x4F, 0x90,
  0xC7, 0x20, 0xEF, 0x09, 0x77, 0x71, 0x08, 0xF9, 0x09, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0xCF,
  0x90, 0x57, 0x20, 0xEF, 0x09, 0x77, 0x70, 0x1F, 0x90, 0xE7, 0x30, 0xEF, 0x09, 0x77, 0x70, 0x6F,
  0x90, 0xA7, 0x30, 0xEF, 0x09, 0x77, 0x70, 0xCF, 0x90, 0x57, 0x30, 0xEF, 0x09, 0x77, 0x60, 0x3F,
  0x90, 0xE7, 0x40, 0xEF, 0x09, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x50, 0x3F,
  0x90, 0xE0, 0x17, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xCF, 0x90, 0x77, 0x50, 0xEF, 0x09, 0x77, 0x40,
  0x8F, 0x90, 0xD7, 0x60, 0xEF, 0x09, 0x77, 0x30, 0x5F, 0xA0, 0x37, 0x6F, 0x90, 0x97, 0x72, 0x05,
  0xFA, 0x08, 0x76, 0x03, 0xF9, 0x09, 0x77, 0x10, 0x7F, 0xA0, 0xA7, 0x70, 0x7F, 0x90, 0x97, 0x60,
  0x40, 0xCF, 0xA0, 0xB7, 0x70, 0x20, 0xEF, 0x90, 0x97, 0x38, 0x12, 0x7C, 0xFB, 0x0A, 0x76, 0x81,
  0x16, 0xEF, 0xA0, 0xD8, 0x03, 0x98, 0x1A, 0xCE, 0xFD, 0x07, 0x73, 0x82, 0x2C, 0xCD, 0xFF, 0xFF,
  0xD0, 0xC0, 0x37, 0x40, 0x3F, 0xFF, 0xFE, 0x0D, 0x05, 0x76, 0x03, 0xFF, 0xFF, 0xB8, 0x1E, 0x94,
  0x77, 0x10, 0x3F, 0xFF, 0xB8, 0x5E, 0xDC, 0xB9, 0x63, 0x77, 0x40,
  // "E" (U+0045)
  0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0, 0x43, 0x81,
  0x2D, 0xE8, 0x0C, 0x1F, 0x04, 0x70, 0x30, 0x8F, 0xB0, 0xD8, 0x09, 0x19, 0x0B, 0x0E, 0xF9, 0x05,
  0x72, 0x03, 0x0E, 0xF9, 0x09, 0x77, 0x10, 0x50, 0xEE, 0x05, 0x73, 0x08, 0xF9, 0x09, 0x77, 0x20,
  0x20, 0xED, 0x06, 0x73, 0x03, 0xF9, 0x09, 0x77, 0x30, 0x6D, 0x06, 0x74, 0xF9, 0x09, 0x77, 0x40,
  0xDC, 0x07, 0x74, 0xF9, 0x09, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x0E, 0xF0, 0x97, 0x74, 0x04, 0xC0,
  0x77, 0x40, 0xEF, 0x09, 0x77, 0x40, 0x2C, 0x08, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0xC0, 0x87, 0x40,
  0xEF, 0x09, 0x77, 0x50, 0xEB, 0x09, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0x0C, 0xB0, 0x97, 0x40, 0xEF,
  0x09, 0x77, 0x58, 0x35, 0x88, 0x85, 0x74, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD, 0x77,
  0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xF0, 0xD8, 0x09, 0x69, 0x77, 0x30, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x78, 0x42, 0xBB, 0xBB, 0x17, 0x10,
  0xEF, 0x09, 0x77, 0x70, 0x4C, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC0, 0x17, 0x10, 0xEF,
  0x09, 0x77, 0x70, 0x8C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x0A, 0xC7, 0x20, 0xEF, 0x09, 0x77,
  0x70, 0xEC, 0x72, 0x0E, 0xF0, 0x97, 0x76, 0x03, 0xD7, 0x2F, 0x90, 0x97, 0x76, 0x0A, 0xC0, 0xE7,
  0x10, 0x2F, 0x90, 0x97, 0x75, 0x03, 0xD0, 0xD7, 0x10, 0x6F, 0x90, 0x97, 0x74, 0x01, 0x0D, 0xD0,
  0xD7, 0x01, 0x0D, 0xF9, 0x09, 0x77, 0x30, 0x50, 0xDE, 0x0C, 0x58, 0x12, 0x7E, 0xFA, 0x0D, 0x80,
  0x93, 0x90, 0xB0, 0xEF, 0x98, 0x4C, 0x02, 0xDD, 0xE8, 0x0C, 0x2F, 0x81, 0xB0, 0x38, 0x0C, 0x5F,
  0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xA0, 0x38, 0x0C, 0x5F, 0x0A, 0x10,
  // "F" (U+0046)
  0x03, 0x80, 0xC3, 0xF0, 0x03, 0x80, 0xC3, 0xF0, 0x03, 0x80, 0xC3, 0xF8, 0x24, 0x2D, 0xE8, 0x0C,
  0x1F, 0x04, 0x48, 0x12, 0x8E, 0xFA, 0x0D, 0x80, 0x91, 0x90, 0xB0, 0xEF, 0x90, 0x56, 0x02, 0x0E,
  0xF9, 0x09, 0x77, 0x10, 0x60, 0xEE, 0x05, 0x70, 0x7F, 0x90, 0x97, 0x72, 0x03, 0xE0, 0x67, 0x02,
  0xF9, 0x09, 0x77, 0x30, 0x7D, 0x06, 0x71, 0xF9, 0x09, 0x77, 0x40, 0xEC, 0x06, 0x71, 0x0E, 0xF0,
  0x97, 0x74, 0x09, 0xC0, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x40, 0x5C, 0x07, 0x71, 0x0E, 0xF0, 0x97,
  0x74, 0x02, 0xC0, 0x87, 0x10, 0xEF, 0x09, 0x77, 0x5C, 0x08, 0x71, 0x0E, 0xF0, 0x97, 0x75, 0x0E,
  0xB0, 0x97, 0x10, 0xEF, 0x09, 0x77, 0x50, 0xCB, 0x09, 0x71, 0x0E, 0xF0, 0x97, 0x75, 0x83, 0x7A,
  0xAA, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77,
  0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77,
  0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40,
  0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF,
  0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x0D, 0x80, 0x96, 0x97, 0x70, 0xEF,
  0xFF, 0xD0, 0x17, 0x60, 0xEF, 0xFF, 0xD0, 0x17, 0x60, 0xEF, 0xFF, 0xD0, 0x17, 0x60, 0xEF, 0xFF,
  0xD0, 0x17, 0x60, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77,
  0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77,
  0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40,
  0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF,
  0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09,
  0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x77,
  0x77, 0x40, 0xEF, 0x0A, 0x77, 0x77, 0x4F, 0x90, 0xB7, 0x77, 0x73, 0x02, 0xF9, 0x0E, 0x77, 0x77,
  0x30, 0x7F, 0xA0, 0x47, 0x77, 0x71, 0x03, 0x0E, 0xFA, 0x0D, 0x02, 0x77, 0x74, 0x81, 0x14, 0x9F,
  0xE8, 0x19, 0x41, 0x77, 0x50, 0x3F, 0xFF, 0xB0, 0x57, 0x71, 0x03, 0xFF, 0xFB, 0x05, 0x77, 0x10,
  0x3F, 0xFF, 0xB0, 0x57, 0x71, 0x03, 0xFF, 0xFB, 0x05, 0x77, 0x10,
  // "G" (U+0047)
  0x77, 0x68, 0x43, 0x79, 0xBD, 0xEA, 0x86, 0xEE, 0xDC, 0xA7, 0x52, 0x77, 0x77, 0x30, 0x50, 0xAF,
  0xFB, 0x81, 0xC8, 0x27, 0x77, 0x48, 0x11, 0x8E, 0xFF, 0xF9, 0x09, 0x02, 0x77, 0x71, 0x06, 0x0E,
  0xFF, 0xFC, 0x0E, 0x05, 0x77, 0x50, 0x10, 0xBF, 0xB8, 0x5E, 0xCA, 0x99, 0xAC, 0xFD, 0x07, 0x77,
  0x30, 0x30, 0xDF, 0x98, 0x1C, 0x72, 0x71, 0x05, 0x0C, 0xFB, 0x06, 0x77, 0x10, 0x5F, 0x90, 0xC0,
  0x47, 0x60, 0x7F, 0xA0, 0xE0, 0x17, 0x60, 0x4F, 0x90, 0x87, 0x72, 0x06, 0xFA, 0x07, 0x75, 0x03,
  0x0E, 0xF0, 0x57, 0x74, 0x09, 0xF9, 0x0B, 0x74, 0x01, 0x0E, 0xF0, 0x67, 0x76, 0x0D, 0xF0, 0xD7,
  0x40, 0xAF, 0x09, 0x77, 0x70, 0x7F, 0x0C, 0x73, 0x05, 0xF0, 0xE0, 0x17, 0x77, 0x01, 0xF0, 0xA7,
  0x20, 0x10, 0xEF, 0x06, 0x77, 0x72, 0x0C, 0xE0, 0x47, 0x20, 0x7F, 0x0D, 0x77, 0x73, 0x08, 0xD0,
  0xA7, 0x30, 0xEF, 0x07, 0x77, 0x73, 0x06, 0xC0, 0x97, 0x30, 0x7F, 0x90, 0x17, 0x77, 0x38, 0x35,
  0xEC, 0x93, 0x74, 0x0D, 0xF0, 0xC8, 0x0C, 0x40, 0x03, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0x8F, 0x90,
  0x38, 0x0C, 0x40, 0x0E, 0xF0, 0xE8, 0x0C, 0x40, 0x02, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x6F, 0x90,
  0x88, 0x0C, 0x40, 0x09, 0xF9, 0x06, 0x80, 0xC4, 0x00, 0xDF, 0x90, 0x48, 0x0C, 0x40, 0xFA, 0x02,
  0x80, 0xC3, 0x00, 0x2F, 0xA8, 0x0C, 0x40, 0x04, 0xF9, 0x0E, 0x80, 0xC4, 0x00, 0x6F, 0x90, 0xD8,
  0x0C, 0x40, 0x07, 0xF9, 0x0C, 0x80, 0xC4, 0x00, 0x8F, 0x90, 0xB8, 0x0C, 0x40, 0x09, 0xF9, 0x0B,
  0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB8, 0x0C, 0x40, 0x0A, 0xF9, 0x0A, 0x80, 0xC4, 0x00, 0xAF, 0x90,
  0xA8, 0x0C, 0x40, 0x09, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB7, 0x75, 0x09, 0xFF, 0xD0,
  0xC0, 0x8F, 0x90, 0xB7, 0x75, 0x09, 0xFF, 0xD0, 0xC0, 0x7F, 0x90, 0xC7, 0x75, 0x09, 0xFF, 0xD0,
  0xC0, 0x6F, 0x90, 0xD7, 0x75, 0x09, 0xFF, 0xD0, 0xC0, 0x4F, 0x90, 0xE7, 0x77, 0x81, 0x14, 0xAF,
  0xD0, 0x90, 0x32, 0x02, 0xFA, 0x77, 0x73, 0x05, 0xFB, 0x06, 0x5F, 0xA0, 0x27, 0x77, 0x30, 0xAF,
  0x90, 0xE6, 0x0D, 0xF9, 0x04, 0x77, 0x73, 0x06, 0xF9, 0x0A, 0x60, 0xAF, 0x90, 0x77, 0x77, 0x30,
  0x3F, 0x90, 0x86, 0x07, 0xF9, 0x09, 0x77, 0x73, 0x02, 0xF9, 0x07, 0x60, 0x3F, 0x90, 0xC7, 0x77,
  0x30, 0x1F, 0x90, 0x67, 0xFA, 0x77, 0x73, 0x01, 0xF9, 0x06, 0x70, 0xAF, 0x90, 0x47, 0x77, 0x20,
  0x1F, 0x90, 0x67, 0x05, 0xF9, 0x08, 0x77, 0x72, 0x01, 0xF9, 0x06, 0x71, 0xF9, 0x0D, 0x77, 0x72,
  0x01, 0xF9, 0x06, 0x71, 0x0A, 0xF9, 0x03, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x71, 0x03, 0xF9, 0x09,
  0x77, 0x71, 0x01, 0xF9, 0x06, 0x72, 0x0B, 0xF0, 0xE0, 0x17, 0x77, 0x01, 0xF9, 0x06, 0x72, 0x04,
  0xF9, 0x08, 0x77, 0x70, 0x1F, 0x90, 0x67, 0x30, 0xAF, 0x90, 0x27, 0x76, 0x01, 0xF9, 0x06, 0x73,
  0x01, 0x0E, 0xF0, 0xC7, 0x76, 0x01, 0xF9, 0x06, 0x74, 0x05, 0xF9, 0x09, 0x77, 0x50, 0x1F, 0x90,
  0x67, 0x50, 0x8F, 0x90, 0x97, 0x74, 0x01, 0xF9, 0x06, 0x76, 0x0A, 0xF9, 0x0B, 0x01, 0x77, 0x20,
  0x1F, 0x90, 0x67, 0x70, 0xBF, 0x98, 0x1E, 0x71, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x8F, 0xA8,
  0x2E, 0x95, 0x17, 0x28, 0x11, 0x5A, 0xF9, 0x06, 0x77, 0x20, 0x5F, 0xD8, 0x7E, 0xBA, 0x99, 0x9A,
  0xBD, 0xFC, 0x06, 0x77, 0x30, 0x20, 0xBF, 0xFF, 0xF8, 0x1E, 0x91, 0x77, 0x50, 0x40, 0xBF, 0xFF,
  0xB0, 0xC0, 0x67, 0x77, 0x38, 0x12, 0x8D, 0xFF, 0xB8, 0x2E, 0xA6, 0x17, 0x77, 0x71, 0x85, 0x15,
  0x8A, 0xCD, 0xEA, 0x86, 0xED, 0xCC, 0xA7, 0x52, 0x77,
  // "H" (U+0048)
  0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF,
  0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72,
  0x02, 0xFF, 0xF9, 0x07, 0x38, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37, 0x71, 0x81, 0x25, 0xCF, 0xD8,
  0x1C, 0x52, 0x72, 0x04, 0xFB, 0x0C, 0x01, 0x77, 0x60, 0x9F, 0xB0, 0x77, 0x60, 0x8F, 0xA0, 0x37,
  0x77, 0x10, 0xEF, 0x90, 0xD7, 0x70, 0x3F, 0x90, 0xE7, 0x77, 0x20, 0x9F, 0x90, 0x77, 0x71, 0xF9,
  0x0B, 0x77, 0x72, 0x07, 0xF9, 0x04, 0x77, 0x10, 0xEF, 0x0A, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77,
  0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9,
  0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72,
  0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09,
  0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03,
  0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05,
  0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77,
  0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77,
  0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9,
  0x03, 0x77, 0x10, 0xE8, 0x0C, 0x4F, 0x03, 0x77, 0x10, 0xE8, 0x0C, 0x4F, 0x03, 0x77, 0x10, 0xE8,
  0x0C, 0x4F, 0x03, 0x77, 0x10, 0xE8, 0x0C, 0x4F, 0x03, 0x77, 0x10, 0xEF, 0x0D, 0x80, 0xA3, 0x90,
  0xBF, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97,
  0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E,
  0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37,
  0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F,
  0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0,
  0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71,
  0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90,
  0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20,
  0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97,
  0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E,
  0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37,
  0x71, 0xF9, 0x0A, 0x77, 0x72, 0x06, 0xF9, 0x03, 0x77, 0x1F, 0x90, 0xB7, 0x77, 0x20, 0x7F, 0x90,
  0x47, 0x70, 0x3F, 0x90, 0xE7, 0x77, 0x20, 0xAF, 0x90, 0x77, 0x70, 0x8F, 0xA0, 0x37, 0x77, 0x10,
  0xEF, 0x90, 0xC7, 0x60, 0x3F, 0xB0, 0xC0, 0x17, 0x76, 0x09, 0xFB, 0x07, 0x72, 0x81, 0x14, 0x9F,
  0xD8, 0x1E, 0x73, 0x77, 0x18, 0x12, 0x5C, 0xFD, 0x81, 0xB5, 0x23, 0x03, 0xFF, 0xF9, 0x08, 0x72,
  0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9,
  0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07,
  // "I" (U+0049)
  0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E,
  0x38, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37, 0x20, 0x4F, 0xB0, 0xD0, 0x17, 0x50, 0x9F, 0xA0, 0x47,
  0x60, 0x3F, 0x90, 0xE7, 0x71, 0xF9, 0x0B, 0x77, 0x1F, 0x90, 0xA7, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0xF9, 0x0A, 0x77, 0x1F,
  0x90, 0xB7, 0x70, 0x3F, 0x90, 0xE7, 0x70, 0x8F, 0xA0, 0x47, 0x50, 0x4F, 0xB0, 0xC0, 0x17, 0x18,
  0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x33, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF,
  0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E,
  // "J" (U+004A)
  0x40, 0xDF, 0xFF, 0x90, 0x24, 0x0D, 0xFF, 0xF9, 0x02, 0x40, 0xDF, 0xFF, 0x90, 0x24, 0x0D, 0xFF,
  0xF9, 0x02, 0x68, 0x21, 0x38, 0xEF, 0xD8, 0x1A, 0x41, 0x75, 0x01, 0x0D, 0xFB, 0x04, 0x77, 0x20,
  0x4F, 0xA0, 0x87, 0x74, 0x0E, 0xF9, 0x03, 0x77, 0x40, 0xBF, 0x97, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75,
  0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xD7, 0x75, 0x0A, 0xF0, 0xD7, 0x75,
  0x0B, 0xF0, 0xC7, 0x75, 0x0C, 0xF0, 0xC7, 0x75, 0x0D, 0xF0, 0xB7, 0x75, 0x0E, 0xF0, 0x87, 0x74,
  0x01, 0xF9, 0x06, 0x77, 0x40, 0x4F, 0x90, 0x47, 0x74, 0x08, 0xF9, 0x77, 0x50, 0xCF, 0x0B, 0x77,
  0x40, 0x2F, 0x90, 0x77, 0x74, 0x09, 0xF0, 0xE0, 0x17, 0x73, 0x03, 0xF9, 0x09, 0x77, 0x30, 0x10,
  0xDF, 0x0E, 0x01, 0x77, 0x20, 0x20, 0xCF, 0x90, 0x57, 0x71, 0x81, 0x28, 0xEF, 0x90, 0x97, 0x58,
  0x26, 0x9A, 0xDF, 0xB0, 0xA7, 0x60, 0xBF, 0xD0, 0x87, 0x70, 0xBF, 0xB0, 0xC0, 0x47, 0x71, 0x0B,
  0xF9, 0x0A, 0x05, 0x77, 0x30, 0xBA, 0x83, 0xED, 0xB8, 0x47, 0x76,
  // "K" (U+004B)
  0x03, 0xFF, 0xF9, 0x08, 0x71, 0x05, 0xFF, 0xB0, 0x13, 0x03, 0xFF, 0xF9, 0x08, 0x71, 0x05, 0xFF,
  0xB0, 0x13, 0x03, 0xFF, 0xF9, 0x08, 0x71, 0x05, 0xFF, 0xB0, 0x13, 0x03, 0xFF, 0xF9, 0x08, 0x71,
  0x05, 0xFF, 0xB0, 0x16, 0x81, 0x14, 0x9F, 0xD8, 0x1E, 0x73, 0x75, 0x82, 0x12, 0x7E, 0xFB, 0x81,
  0x83, 0x17, 0x30, 0x30, 0xEF, 0xA0, 0xD0, 0x17, 0x73, 0x06, 0xF9, 0x0B, 0x01, 0x77, 0x08, 0xFA,
  0x04, 0x77, 0x40, 0x5F, 0x0A, 0x77, 0x20, 0x3F, 0x90, 0xE7, 0x75, 0x09, 0xE0, 0xA7, 0x74, 0xF9,
  0x0B, 0x77, 0x40, 0x10, 0xED, 0x0B, 0x77, 0x50, 0xEF, 0x0A, 0x77, 0x40, 0x9D, 0x0C, 0x77, 0x60,
  0xEF, 0x09, 0x77, 0x30, 0x3D, 0x0E, 0x01, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x30, 0xCD, 0x04, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x20, 0x7D, 0x07, 0x77, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x03, 0xD0, 0xB7,
  0x77, 0x20, 0xEF, 0x09, 0x77, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x72, 0x0E, 0xF0, 0x97, 0x70, 0x9D,
  0x03, 0x77, 0x73, 0x0E, 0xF0, 0x97, 0x60, 0x5D, 0x07, 0x77, 0x74, 0x0E, 0xF0, 0x97, 0x50, 0x10,
  0xEC, 0x0A, 0x77, 0x75, 0x0E, 0xF0, 0x97, 0x50, 0xBC, 0x0D, 0x01, 0x77, 0x75, 0x0E, 0xF0, 0x97,
  0x40, 0x7D, 0x03, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x30, 0x3D, 0x06, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x30, 0xDC, 0x0A, 0x77, 0x77, 0x10, 0xEF, 0x09, 0x72, 0x09, 0xC0, 0xD7, 0x77, 0x72, 0x0E, 0xF0,
  0x97, 0x10, 0x5C, 0x0E, 0x02, 0x77, 0x77, 0x20, 0xEF, 0x09, 0x70, 0x10, 0xEC, 0x06, 0x77, 0x77,
  0x30, 0xEF, 0x09, 0x70, 0xBC, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x60, 0x7C, 0x0C, 0x77, 0x77,
  0x50, 0xEF, 0x09, 0x50, 0x2D, 0x0C, 0x77, 0x77, 0x50, 0xEF, 0x09, 0x50, 0xDE, 0x07, 0x77, 0x77,
  0x40, 0xEF, 0x09, 0x40, 0x9F, 0x90, 0x27, 0x77, 0x73, 0x0E, 0xF0, 0x93, 0x04, 0xFA, 0x0B, 0x77,
  0x77, 0x30, 0xEF, 0x09, 0x20, 0x10, 0xEF, 0xB0, 0x67, 0x77, 0x72, 0x0E, 0xF0, 0x92, 0x0B, 0xFC,
  0x0E, 0x01, 0x77, 0x77, 0x10, 0xEF, 0x81, 0x90, 0x6B, 0x0C, 0x0E, 0xF9, 0x0A, 0x77, 0x77, 0x10,
  0xEF, 0x09, 0x02, 0xB8, 0x1E, 0x16, 0xFA, 0x04, 0x77, 0x77, 0x0E, 0xF0, 0xA0, 0xCB, 0x03, 0x20,
  0xCF, 0x90, 0xD7, 0x77, 0x70, 0xEF, 0xC0, 0x63, 0x03, 0xFA, 0x09, 0x77, 0x76, 0x0E, 0xFB, 0x09,
  0x50, 0x9F, 0xA0, 0x37, 0x77, 0x50, 0xEF, 0xA0, 0xC6, 0x01, 0x0E, 0xF9, 0x0C, 0x77, 0x75, 0x0E,
  0xF9, 0x0D, 0x01, 0x70, 0x6F, 0xA0, 0x77, 0x77, 0x40, 0xEF, 0x90, 0x37, 0x20, 0xCF, 0xA0, 0x27,
  0x77, 0x30, 0xEF, 0x09, 0x73, 0x03, 0xFA, 0x0B, 0x77, 0x73, 0x0E, 0xF0, 0x97, 0x40, 0x9F, 0xA0,
  0x67, 0x77, 0x20, 0xEF, 0x09, 0x74, 0x01, 0x0E, 0xF9, 0x0E, 0x01, 0x77, 0x71, 0x0E, 0xF0, 0x97,
  0x50, 0x6F, 0xA0, 0xA7, 0x77, 0x10, 0xEF, 0x09, 0x76, 0x0C, 0xFA, 0x04, 0x77, 0x70, 0xEF, 0x09,
  0x76, 0x03, 0xFA, 0x0D, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x0A, 0xFA, 0x09, 0x77, 0x60, 0xEF, 0x09,
  0x77, 0x01, 0x0E, 0xFA, 0x03, 0x77, 0x50, 0xEF, 0x09, 0x77, 0x10, 0x7F, 0xA0, 0xC7, 0x75, 0x0E,
  0xF0, 0x97, 0x72, 0x0D, 0xFA, 0x07, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x20, 0x4F, 0xB0, 0x27, 0x73,
  0x0E, 0xF0, 0x97, 0x73, 0x0A, 0xFA, 0x0B, 0x77, 0x30, 0xEF, 0x09, 0x77, 0x30, 0x10, 0xEF, 0xA0,
  0x67, 0x72, 0x0E, 0xF0, 0xA7, 0x74, 0x07, 0xFA, 0x0E, 0x02, 0x77, 0x1F, 0x90, 0xB7, 0x75, 0x0D,
  0xFA, 0x0C, 0x77, 0x03, 0xF9, 0x0E, 0x77, 0x50, 0x4F, 0xB0, 0xA7, 0x60, 0x8F, 0xA0, 0x47, 0x75,
  0x0A, 0xFB, 0x08, 0x74, 0x03, 0x0E, 0xFA, 0x0D, 0x01, 0x77, 0x40, 0x10, 0xDF, 0xB0, 0x97, 0x81,
  0x14, 0x9F, 0xD8, 0x2E, 0x83, 0x17, 0x72, 0x03, 0xFC, 0x83, 0xD5, 0x10, 0x3F, 0xFF, 0x90, 0x87,
  0x71, 0x06, 0xFE, 0x09, 0x03, 0xFF, 0xF9, 0x08, 0x77, 0x20, 0x50, 0xEF, 0xC0, 0x90, 0x3F, 0xFF,
  0x90, 0x87, 0x73, 0x02, 0x0A, 0xFB, 0x09, 0x03, 0xFF, 0xF9, 0x08, 0x77, 0x58, 0x51, 0x58, 0xBD,
  0xEE, 0xB0, 0x90,
  // "L" (U+004C)
  0x03, 0xFF, 0xF9, 0x0E, 0x77, 0x60, 0x3F, 0xFF, 0x90, 0xE7, 0x76, 0x03, 0xFF, 0xF9, 0x0E, 0x77,
  0x60, 0x3F, 0xFF, 0x90, 0xE7, 0x77, 0x28, 0x11, 0x5A, 0xFD, 0x81, 0xD7, 0x37, 0x77, 0x71, 0x05,
  0xFB, 0x0C, 0x77, 0x77, 0x50, 0x9F, 0xA0, 0x37, 0x77, 0x75, 0x03, 0xF9, 0x0D, 0x77, 0x77, 0x7F,
  0x90, 0xB7, 0x77, 0x77, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x71, 0x02, 0x0F, 0x47, 0x20, 0xEF, 0x09, 0x77, 0x71, 0x0C,
  0xB0, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x71, 0x0E, 0xB0, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x71, 0xC0,
  0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x2C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x04, 0xC7, 0x20,
  0xEF, 0x09, 0x77, 0x70, 0x6C, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x08, 0xC7, 0x20, 0xEF, 0x09, 0x77,
  0x70, 0xAC, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x0E, 0xB0, 0xE7, 0x20, 0xEF, 0x09, 0x77, 0x60, 0x3C,
  0x0E, 0x72, 0xF9, 0x09, 0x77, 0x60, 0x9C, 0x0D, 0x71, 0x03, 0xF9, 0x09, 0x77, 0x50, 0x2D, 0x0D,
  0x71, 0x08, 0xF9, 0x09, 0x77, 0x50, 0xCD, 0x0C, 0x70, 0x30, 0xEF, 0x90, 0x97, 0x73, 0x03, 0x0C,
  0xE0, 0xC5, 0x81, 0x28, 0xEF, 0xA0, 0xD8, 0x09, 0x39, 0x0A, 0x0D, 0xF9, 0x84, 0xB0, 0x2D, 0xDE,
  0x80, 0xC2, 0xF8, 0x1B, 0x03, 0x80, 0xC5, 0xF8, 0x1B, 0x03, 0x80, 0xC5, 0xF8, 0x1A, 0x03, 0x80,
  0xC5, 0xF0, 0xA1,
  // "M" (U+004D)
  0x03, 0xFF, 0xC0, 0x37, 0x77, 0x71, 0x0B, 0xFF, 0xB0, 0x70, 0x3F, 0xFC, 0x07, 0x77, 0x77, 0x01,
  0xFF, 0xC0, 0x70, 0x3F, 0xFC, 0x0C, 0x77, 0x77, 0x05, 0xFF, 0xC0, 0x70, 0x3F, 0xFD, 0x01, 0x77,
  0x76, 0x09, 0xFF, 0xC0, 0x73, 0x81, 0x14, 0xAF, 0xF0, 0x57, 0x77, 0x60, 0xEF, 0xE8, 0x1C, 0x52,
  0x72, 0x04, 0xFE, 0x0A, 0x77, 0x75, 0x03, 0xFE, 0x08, 0x76, 0x08, 0xFD, 0x0E, 0x77, 0x75, 0x08,
  0xFD, 0x0D, 0x77, 0x03, 0xC0, 0x0E, 0xF0, 0x47, 0x77, 0x40, 0xCB, 0x00, 0xEF, 0x08, 0x77, 0x1C,
  0x0E, 0x0A, 0xF0, 0x87, 0x77, 0x30, 0x1C, 0x0A, 0x0E, 0xF0, 0x67, 0x71, 0x0E, 0xB0, 0xE0, 0x5F,
  0x0D, 0x77, 0x73, 0x06, 0xC0, 0x50, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x01, 0xF9, 0x02, 0x77,
  0x72, 0x0A, 0xC0, 0x10, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x81, 0xE0, 0xBF, 0x06, 0x77, 0x72, 0x0E,
  0xB8, 0x1B, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB8, 0x1E, 0x06, 0xF0, 0xB7, 0x77, 0x10, 0x4C, 0x81,
  0x70, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x81, 0xE0, 0x2F, 0x97, 0x77, 0x10, 0x8C, 0x81, 0x20, 0xEF,
  0x04, 0x77, 0x10, 0xEB, 0x0E, 0x20, 0xDF, 0x05, 0x77, 0x70, 0xDB, 0x0D, 0x20, 0xEF, 0x04, 0x77,
  0x10, 0xEB, 0x0E, 0x20, 0x8F, 0x09, 0x77, 0x60, 0x2C, 0x08, 0x20, 0xEF, 0x04, 0x77, 0x10, 0xEB,
  0x0E, 0x20, 0x3F, 0x0E, 0x77, 0x60, 0x6C, 0x03, 0x20, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x30,
  0xEF, 0x03, 0x77, 0x50, 0xBB, 0x0E, 0x30, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x30, 0x9F, 0x07,
  0x77, 0x5C, 0x0A, 0x30, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x30, 0x4F, 0x0C, 0x77, 0x40, 0x5C,
  0x05, 0x30, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x4F, 0x90, 0x17, 0x73, 0x09, 0xC0, 0x13, 0x0E,
  0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE4, 0x0B, 0xF0, 0x67, 0x73, 0x0E, 0xB0, 0xB4, 0x0E, 0xF0, 0x47,
  0x71, 0x0E, 0xB0, 0xE4, 0x06, 0xF0, 0xA7, 0x72, 0x03, 0xC0, 0x74, 0x0E, 0xF0, 0x47, 0x71, 0x0E,
  0xB0, 0xE4, 0x01, 0xF0, 0xE7, 0x72, 0x07, 0xC0, 0x24, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE5,
  0x0C, 0xF0, 0x47, 0x71, 0x0C, 0xB0, 0xD5, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE5, 0x07, 0xF0,
  0x87, 0x70, 0x1C, 0x08, 0x50, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x50, 0x2F, 0x0D, 0x77, 0x05,
  0xC0, 0x45, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE6, 0x0D, 0xF0, 0x27, 0x60, 0xAB, 0x0E, 0x60,
  0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x60, 0x9F, 0x07, 0x76, 0x0E, 0xB0, 0xA6, 0x0E, 0xF0, 0x47,
  0x71, 0x0E, 0xB0, 0xE6, 0x04, 0xF0, 0xB7, 0x50, 0x3C, 0x05, 0x60, 0xEF, 0x04, 0x77, 0x10, 0xEB,
  0x0E, 0x70, 0xEF, 0x75, 0x08, 0xC0, 0x16, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x0A, 0xF0,
  0x57, 0x40, 0xDB, 0x0C, 0x70, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x70, 0x5F, 0x09, 0x73, 0x02,
  0xC0, 0x77, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x01, 0xF0, 0xE7, 0x30, 0x6C, 0x02, 0x70,
  0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x71, 0x0B, 0xF0, 0x37, 0x20, 0xBB, 0x0D, 0x71, 0x0E, 0xF0,
  0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x10, 0x7F, 0x08, 0x72, 0xC0, 0x97, 0x10, 0xEF, 0x04, 0x77, 0x10,
  0xEB, 0x0E, 0x71, 0x02, 0xF0, 0xC7, 0x10, 0x4C, 0x04, 0x71, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0,
  0xE7, 0x20, 0xDF, 0x01, 0x70, 0x9B, 0x0E, 0x72, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x20,
  0x8F, 0x06, 0x70, 0xDB, 0x0A, 0x72, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x20, 0x3F, 0x0A,
  0x60, 0x2C, 0x06, 0x72, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x30, 0xEE, 0x0E, 0x60, 0x7C,
  0x01, 0x72, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x30, 0x9F, 0x04, 0x50, 0xBB, 0x0C, 0x73,
  0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x30, 0x5F, 0x08, 0x40, 0x1C, 0x07, 0x73, 0x0E, 0xF0,
  0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x4F, 0x0D, 0x40, 0x5C, 0x03, 0x73, 0x0E, 0xF0, 0x47, 0x71, 0x0E,
  0xB0, 0xE7, 0x40, 0xBF, 0x02, 0x30, 0xAB, 0x0D, 0x74, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7,
  0x40, 0x6F, 0x07, 0x30, 0xEB, 0x09, 0x74, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x40, 0x1F,
  0x0B, 0x20, 0x3C, 0x04, 0x74, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x50, 0xCF, 0x81, 0x10,
  0x8B, 0x0E, 0x75, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x50, 0x7F, 0x81, 0x50, 0xCB, 0x0A,
  0x75, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x50, 0x3F, 0x09, 0x01, 0xC0, 0x67, 0x50, 0xEF,
  0x04, 0x77, 0x10, 0xEB, 0x0E, 0x76, 0x0D, 0xE0, 0xE0, 0x6C, 0x01, 0x75, 0x0E, 0xF0, 0x47, 0x71,
  0x0E, 0xB0, 0xE7, 0x60, 0x9F, 0x0D, 0xB0, 0xC7, 0x60, 0xEF, 0x04, 0x77, 0x10, 0xEB, 0x0E, 0x76,
  0x04, 0xFC, 0x07, 0x76, 0x0E, 0xF0, 0x47, 0x71, 0x0E, 0xB0, 0xE7, 0x70, 0xEF, 0xB0, 0x37, 0x60,
  0xEF, 0x04, 0x77, 0x10, 0xEC, 0x77, 0x0A, 0xFA, 0x0E, 0x77, 0x0E, 0xF0, 0x47, 0x71, 0xD7, 0x70,
  0x5F, 0xA0, 0x97, 0x7F, 0x90, 0x67, 0x70, 0x3D, 0x03, 0x76, 0x01, 0xFA, 0x04, 0x76, 0x02, 0xF9,
  0x08, 0x77, 0x08, 0xD0, 0x77, 0x70, 0xBF, 0x97, 0x70, 0x6F, 0x90, 0xD7, 0x60, 0x40, 0xED, 0x0E,
  0x02, 0x76, 0x07, 0xF0, 0xB7, 0x60, 0x10, 0xDF, 0xA0, 0x87, 0x28, 0x11, 0x5A, 0xF9, 0x81, 0xE8,
  0x37, 0x40, 0x2F, 0x06, 0x74, 0x81, 0x27, 0xEF, 0xC8, 0x1C, 0x62, 0x30, 0x3F, 0xFC, 0x02, 0x72,
  0x0D, 0xE0, 0x17, 0x10, 0x4F, 0xFF, 0x07, 0x03, 0xFF, 0xC0, 0x27, 0x20, 0x8D, 0x0C, 0x72, 0x04,
  0xFF, 0xF0, 0x70, 0x3F, 0xFC, 0x02, 0x72, 0x03, 0xD0, 0x87, 0x20, 0x4F, 0xFF, 0x07, 0x03, 0xFF,
  0xC0, 0x27, 0x30, 0xEC, 0x03, 0x72, 0x04, 0xFF, 0xF0, 0x70,
  // "N" (U+004E)
  0x03, 0xFF, 0x0E, 0x01, 0x77, 0x40, 0x5F, 0xFD, 0x03, 0xFF, 0x90, 0x87, 0x74, 0x05, 0xFF, 0xD0,
  0x3F, 0xFA, 0x01, 0x77, 0x30, 0x5F, 0xFD, 0x03, 0xFF, 0xA0, 0x97, 0x73, 0x05, 0xFF, 0xD3, 0x81,
  0x14, 0x9F, 0xD0, 0x27, 0x75, 0x81, 0x26, 0xCF, 0x98, 0x2E, 0x83, 0x17, 0x10, 0x30, 0xEF, 0xB0,
  0xA7, 0x77, 0x10, 0x7E, 0x0D, 0x02, 0x75, 0x08, 0xFC, 0x03, 0x77, 0x71, 0x0C, 0xD0, 0x57, 0x60,
  0x3F, 0xC0, 0xC7, 0x77, 0x10, 0x7D, 0x77, 0x1F, 0xD0, 0x57, 0x77, 0x04, 0xC0, 0xC7, 0x71, 0x0E,
  0xFC, 0x0D, 0x77, 0x70, 0x3C, 0x0B, 0x77, 0x10, 0xEF, 0xD0, 0x67, 0x76, 0x02, 0xC0, 0xA7, 0x71,
  0x0E, 0xFD, 0x0E, 0x77, 0x60, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x08, 0xF9, 0x07, 0x77, 0x50,
  0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x81, 0xE1, 0xEF, 0x0E, 0x01, 0x77, 0x40, 0x2C, 0x0A, 0x77, 0x10,
  0xEB, 0x81, 0xE0, 0x7F, 0x90, 0x87, 0x74, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE2, 0x0D, 0xF9,
  0x02, 0x77, 0x30, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x20, 0x5F, 0x90, 0xA7, 0x73, 0x02, 0xC0,
  0xA7, 0x71, 0x0E, 0xB0, 0xE3, 0x0C, 0xF9, 0x03, 0x77, 0x20, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E,
  0x30, 0x4F, 0x90, 0xB7, 0x72, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE4, 0x0B, 0xF9, 0x04, 0x77,
  0x10, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x40, 0x2F, 0x90, 0xC7, 0x71, 0x02, 0xC0, 0xA7, 0x71,
  0x0E, 0xB0, 0xE5, 0x09, 0xF9, 0x05, 0x77, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE5, 0x01, 0x0E,
  0xF0, 0xD7, 0x70, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x60, 0x8F, 0x90, 0x67, 0x60, 0x2C, 0x0A,
  0x77, 0x10, 0xEB, 0x0E, 0x70, 0xEF, 0x0E, 0x76, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x06,
  0xF9, 0x07, 0x75, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x10, 0xDF, 0x0E, 0x01, 0x74, 0x02,
  0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x10, 0x4F, 0x90, 0x97, 0x40, 0x2C, 0x0A, 0x77, 0x10, 0xEB,
  0x0E, 0x72, 0x0B, 0xF9, 0x02, 0x73, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x20, 0x3F, 0x90,
  0xA7, 0x30, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x73, 0x0A, 0xF9, 0x03, 0x72, 0x02, 0xC0, 0xA7,
  0x71, 0x0E, 0xB0, 0xE7, 0x30, 0x2F, 0x90, 0xB7, 0x20, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x74,
  0x08, 0xF9, 0x04, 0x71, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x40, 0x10, 0xEF, 0x0C, 0x71,
  0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x50, 0x7F, 0x90, 0x57, 0x02, 0xC0, 0xA7, 0x71, 0x0E,
  0xB0, 0xE7, 0x60, 0xDF, 0x0D, 0x70, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x76, 0x05, 0xF9, 0x07,
  0x60, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x0C, 0xF0, 0xE0, 0x15, 0x02, 0xC0, 0xA7, 0x71,
  0x0E, 0xB0, 0xE7, 0x70, 0x4F, 0x90, 0x85, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x71, 0x0B,
  0xF9, 0x01, 0x40, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x10, 0x2F, 0x90, 0x94, 0x02, 0xC0,
  0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x72, 0x09, 0xF9, 0x02, 0x30, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E,
  0x77, 0x20, 0x1F, 0x90, 0xA3, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x73, 0x08, 0xF9, 0x03,
  0x20, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x40, 0xEF, 0x0C, 0x20, 0x2C, 0x0A, 0x77, 0x10,
  0xEB, 0x0E, 0x77, 0x40, 0x6F, 0x98, 0x15, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x75, 0x0D,
  0xF8, 0x1D, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x75, 0x05, 0xF9, 0x06, 0x02, 0xC0, 0xA7,
  0x71, 0x0E, 0xB0, 0xE7, 0x76, 0x0C, 0xF0, 0xD0, 0x3C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x60,
  0x3F, 0x90, 0xAC, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x70, 0xAF, 0xD0, 0xA7, 0x71, 0x0E, 0xB0,
  0xE7, 0x77, 0x02, 0xFD, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x71, 0x09, 0xFC, 0x0A, 0x77, 0x10,
  0xEB, 0x0E, 0x77, 0x71, 0x01, 0x0E, 0xFB, 0x0A, 0x77, 0x1D, 0x77, 0x72, 0x07, 0xFB, 0x0A, 0x77,
  0x1D, 0x77, 0x73, 0x0D, 0xFA, 0x0A, 0x77, 0x03, 0xD0, 0x37, 0x77, 0x20, 0x6F, 0xA0, 0xA7, 0x70,
  0x9D, 0x08, 0x77, 0x73, 0x0C, 0xF9, 0x0A, 0x76, 0x04, 0xE0, 0xE0, 0x37, 0x77, 0x20, 0x4F, 0x90,
  0xA7, 0x38, 0x11, 0x5A, 0xFA, 0x81, 0x94, 0x17, 0x77, 0x0B, 0xF0, 0xA7, 0x03, 0xFF, 0xD0, 0x37,
  0x74, 0x03, 0xF0, 0xA7, 0x03, 0xFF, 0xD0, 0x37, 0x75, 0x09, 0xE0, 0xA7, 0x03, 0xFF, 0xD0, 0x37,
  0x75, 0x01, 0xE0, 0xA7, 0x03, 0xFF, 0xD0, 0x37, 0x76, 0x08, 0xD0, 0xA7,
  // "O" (U+004F)
  0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x50, 0x50, 0xAF, 0xF9,
  0x81, 0xD7, 0x17, 0x77, 0x70, 0x60, 0xDF, 0xFE, 0x08, 0x01, 0x77, 0x73, 0x02, 0x0C, 0xFF, 0xFA,
  0x0E, 0x05, 0x77, 0x71, 0x05, 0xFC, 0x84, 0xCA, 0x99, 0xAC, 0xFB, 0x09, 0x77, 0x60, 0x7F, 0xA0,
  0x90, 0x47, 0x10, 0x40, 0xAF, 0x90, 0xB7, 0x74, 0x08, 0xF9, 0x0B, 0x02, 0x75, 0x03, 0x0C, 0xF0,
  0xC7, 0x72, 0x06, 0xF9, 0x07, 0x77, 0x20, 0x9F, 0x0A, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x40, 0x9F,
  0x08, 0x75, 0x01, 0x0E, 0xF0, 0xA7, 0x76, 0x0C, 0xF0, 0x47, 0x40, 0x9F, 0x0E, 0x01, 0x77, 0x60,
  0x3F, 0x0D, 0x73, 0x03, 0xF9, 0x06, 0x77, 0x71, 0x0A, 0xF0, 0x77, 0x20, 0xBF, 0x0E, 0x77, 0x72,
  0x02, 0xF0, 0xE0, 0x17, 0x02, 0xF9, 0x08, 0x77, 0x73, 0x0C, 0xF0, 0x77, 0x09, 0xF9, 0x02, 0x77,
  0x73, 0x06, 0xF0, 0xE7, 0x0E, 0xF0, 0xC7, 0x77, 0x40, 0x1F, 0x90, 0x65, 0x05, 0xF9, 0x07, 0x77,
  0x75, 0x0C, 0xF0, 0xB5, 0x09, 0xF9, 0x03, 0x77, 0x75, 0x08, 0xF9, 0x01, 0x40, 0xEF, 0x0E, 0x77,
  0x76, 0x04, 0xF9, 0x05, 0x30, 0x3F, 0x90, 0xC7, 0x77, 0x60, 0x1F, 0x90, 0xA3, 0x06, 0xF9, 0x09,
  0x77, 0x77, 0x0E, 0xF0, 0xE3, 0x09, 0xF9, 0x06, 0x77, 0x77, 0x0B, 0xF9, 0x01, 0x20, 0xCF, 0x90,
  0x47, 0x77, 0x70, 0x9F, 0x90, 0x52, 0xFA, 0x01, 0x77, 0x77, 0x07, 0xF9, 0x81, 0x80, 0x2F, 0xA7,
  0x77, 0x71, 0x06, 0xF9, 0x81, 0xA0, 0x3F, 0x90, 0xE7, 0x77, 0x71, 0x04, 0xF9, 0x81, 0xC0, 0x5F,
  0x90, 0xC7, 0x77, 0x71, 0x03, 0xF9, 0x81, 0xE0, 0x7F, 0x90, 0xB7, 0x77, 0x71, 0x02, 0xFA, 0x10,
  0x8F, 0x90, 0xB7, 0x77, 0x71, 0x01, 0xFA, 0x01, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x2F, 0xA0, 0x20,
  0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x02, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x30, 0xAF,
  0x90, 0x97, 0x77, 0x72, 0xFA, 0x04, 0x0A, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x40, 0x9F, 0x90,
  0x97, 0x77, 0x72, 0xFA, 0x03, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x8F, 0x90, 0xA7,
  0x77, 0x72, 0xFA, 0x02, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x10, 0x6F, 0x90, 0xB7,
  0x77, 0x71, 0x02, 0xFA, 0x10, 0x5F, 0x90, 0xC7, 0x77, 0x71, 0x03, 0xF9, 0x81, 0xD0, 0x3F, 0x90,
  0xE7, 0x77, 0x71, 0x04, 0xF9, 0x81, 0xC0, 0x1F, 0xA7, 0x77, 0x71, 0x06, 0xF9, 0x0A, 0x20, 0xEF,
  0x90, 0x27, 0x77, 0x70, 0x8F, 0x90, 0x82, 0x0B, 0xF9, 0x04, 0x77, 0x77, 0x0A, 0xF9, 0x04, 0x20,
  0x8F, 0x90, 0x67, 0x77, 0x70, 0xCF, 0x90, 0x12, 0x05, 0xF9, 0x09, 0x77, 0x77, 0x0E, 0xF0, 0xD3,
  0x02, 0xF9, 0x0C, 0x77, 0x76, 0x02, 0xF9, 0x0A, 0x40, 0xDF, 0x97, 0x77, 0x60, 0x5F, 0x90, 0x54,
  0x08, 0xF9, 0x04, 0x77, 0x75, 0x09, 0xF9, 0x50, 0x4F, 0x90, 0x87, 0x77, 0x50, 0xDF, 0x0A, 0x60,
  0xEF, 0x0D, 0x77, 0x74, 0x02, 0xF9, 0x05, 0x60, 0x7F, 0x90, 0x27, 0x77, 0x30, 0x7F, 0x0D, 0x70,
  0x1F, 0x90, 0x87, 0x77, 0x30, 0xDF, 0x07, 0x71, 0x0A, 0xF0, 0xE7, 0x77, 0x20, 0x3F, 0x0E, 0x72,
  0x02, 0xF9, 0x07, 0x77, 0x71, 0x0B, 0xF0, 0x67, 0x30, 0x8F, 0x0E, 0x01, 0x77, 0x60, 0x4F, 0x0C,
  0x75, 0x0D, 0xF0, 0xB7, 0x75, 0x01, 0x0D, 0xF0, 0x37, 0x50, 0x3F, 0x90, 0x87, 0x74, 0x0B, 0xF0,
  0x77, 0x70, 0x5F, 0x90, 0x87, 0x72, 0x0A, 0xF0, 0x97, 0x72, 0x08, 0xF9, 0x0B, 0x02, 0x75, 0x03,
  0x0D, 0xF0, 0xB7, 0x74, 0x07, 0xFA, 0x09, 0x03, 0x71, 0x05, 0x0B, 0xF9, 0x0A, 0x77, 0x60, 0x5F,
  0xB8, 0x5E, 0xCA, 0x99, 0xAD, 0xFB, 0x08, 0x77, 0x71, 0x03, 0x0C, 0xFF, 0xFA, 0x0D, 0x04, 0x77,
  0x74, 0x06, 0x0D, 0xFF, 0xD0, 0xE0, 0x87, 0x77, 0x71, 0x05, 0x0B, 0xFF, 0x90, 0xC0, 0x67, 0x77,
  0x76, 0x84, 0x47, 0xAC, 0xEE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x74,
  // "P" (U+0050)
  0x03, 0xFF, 0xFA, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x50, 0x3F, 0xFF, 0xFA, 0x0C, 0x06, 0x73, 0x03,
  0xFF, 0xFF, 0xC0, 0xE0, 0x77, 0x10, 0x3F, 0xFF, 0xFE, 0x0C, 0x02, 0x78, 0x31, 0x12, 0x6B, 0xFB,
  0x0D, 0x80, 0x19, 0x81, 0xAB, 0xCF, 0xC0, 0xE0, 0x37, 0x40, 0x5F, 0xA0, 0x97, 0x18, 0x11, 0x5B,
  0xFA, 0x0E, 0x02, 0x74, 0x09, 0xF9, 0x09, 0x74, 0x04, 0x0D, 0xF9, 0x0D, 0x74, 0x03, 0xF9, 0x09,
  0x75, 0x01, 0x0D, 0xF9, 0x09, 0x74, 0xF9, 0x09, 0x76, 0x02, 0xFA, 0x02, 0x73, 0x0E, 0xF0, 0x97,
  0x70, 0x8F, 0x90, 0xA7, 0x30, 0xEF, 0x09, 0x77, 0x1F, 0xA0, 0x17, 0x20, 0xEF, 0x09, 0x77, 0x10,
  0xAF, 0x90, 0x57, 0x20, 0xEF, 0x09, 0x77, 0x10, 0x5F, 0x90, 0xA7, 0x20, 0xEF, 0x09, 0x77, 0x10,
  0x2F, 0x90, 0xD7, 0x20, 0xEF, 0x09, 0x77, 0x2F, 0xA0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xCF,
  0x90, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xBF, 0x90, 0x47, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xAF,
  0x90, 0x57, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xAF, 0x90, 0x57, 0x10, 0xEF, 0x09, 0x77, 0x20, 0x9F,
  0x90, 0x57, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xAF, 0x90, 0x47, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xBF,
  0x90, 0x37, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xCF, 0x90, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x0E, 0x72, 0x0E, 0xF0, 0x97, 0x72, 0xF9, 0x0B, 0x72, 0x0E, 0xF0, 0x97, 0x71, 0x03, 0xF9, 0x06,
  0x72, 0x0E, 0xF0, 0x97, 0x71, 0x07, 0xF9, 0x02, 0x72, 0x0E, 0xF0, 0x97, 0x71, 0x0C, 0xF0, 0xC7,
  0x30, 0xEF, 0x09, 0x77, 0x03, 0xF9, 0x06, 0x73, 0x0E, 0xF0, 0x97, 0x70, 0xAF, 0x0D, 0x74, 0x0E,
  0xF0, 0x97, 0x60, 0x5F, 0x90, 0x67, 0x40, 0xEF, 0x09, 0x75, 0x05, 0xF9, 0x0B, 0x75, 0x0E, 0xF0,
  0x97, 0x30, 0x10, 0x8F, 0x90, 0xD0, 0x17, 0x50, 0xEF, 0x09, 0x71, 0x81, 0x38, 0xEF, 0x90, 0xD0,
  0x27, 0x60, 0xEF, 0x86, 0xD9, 0x99, 0x9A, 0xBC, 0xFC, 0x0D, 0x01, 0x77, 0x0E, 0xFF, 0xFC, 0x09,
  0x77, 0x20, 0xEF, 0xFF, 0xA0, 0xB0, 0x47, 0x73, 0x0E, 0xFF, 0xE8, 0x1E, 0x93, 0x77, 0x50, 0xEF,
  0xE8, 0x5E, 0xDD, 0xB8, 0x63, 0x77, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77,
  0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76,
  0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E,
  0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0,
  0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x76, 0x0E, 0xF0, 0x97,
  0x77, 0x76, 0xF9, 0x0A, 0x77, 0x77, 0x6F, 0x90, 0xB7, 0x77, 0x75, 0x03, 0xF9, 0x0D, 0x77, 0x77,
  0x50, 0x9F, 0xA0, 0x37, 0x77, 0x73, 0x04, 0xFB, 0x0C, 0x01, 0x77, 0x76, 0x81, 0x14, 0xAF, 0xD8,
  0x2E, 0x84, 0x17, 0x77, 0x03, 0xFF, 0xFB, 0x01, 0x77, 0x30, 0x3F, 0xFF, 0xB0, 0x17, 0x73, 0x03,
  0xFF, 0xFB, 0x01, 0x77, 0x30, 0x3F, 0xFF, 0xB0, 0x17, 0x73,
  // "Q" (U+0051)
  0x77, 0x48, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x50, 0x50, 0xAF, 0xF9,
  0x81, 0xD7, 0x17, 0x77, 0x70, 0x60, 0xDF, 0xFE, 0x08, 0x01, 0x77, 0x73, 0x02, 0x0C, 0xFF, 0xFA,
  0x0E, 0x05, 0x77, 0x71, 0x05, 0xFB, 0x85, 0xEC, 0xA9, 0x9A, 0xCF, 0xB0, 0x97, 0x76, 0x07, 0xFA,
  0x09, 0x03, 0x71, 0x04, 0x0A, 0xF9, 0x0B, 0x77, 0x40, 0x8F, 0x90, 0xA0, 0x17, 0x50, 0x20, 0xCF,
  0x0C, 0x77, 0x20, 0x6F, 0x90, 0x67, 0x72, 0x09, 0xF0, 0xA7, 0x70, 0x4F, 0x90, 0x67, 0x74, 0x09,
  0xF0, 0x87, 0x50, 0x10, 0xEF, 0x09, 0x77, 0x60, 0xCF, 0x04, 0x74, 0x09, 0xF0, 0xD7, 0x77, 0x02,
  0xF0, 0xD7, 0x30, 0x3F, 0x90, 0x57, 0x77, 0x10, 0x9F, 0x07, 0x72, 0x0B, 0xF0, 0xD7, 0x77, 0x20,
  0x2F, 0x0E, 0x01, 0x70, 0x2F, 0x90, 0x77, 0x77, 0x30, 0xBF, 0x07, 0x70, 0x9F, 0x90, 0x17, 0x77,
  0x30, 0x6F, 0x0E, 0x70, 0xEF, 0x0B, 0x77, 0x74, 0x01, 0xF9, 0x06, 0x50, 0x5F, 0x90, 0x77, 0x77,
  0x50, 0xCF, 0x0B, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x50, 0x8F, 0x90, 0x14, 0x0E, 0xF0, 0xE7, 0x77,
  0x60, 0x4F, 0x90, 0x53, 0x03, 0xF9, 0x0B, 0x77, 0x76, 0x01, 0xF9, 0x0A, 0x30, 0x6F, 0x90, 0x87,
  0x77, 0x70, 0xEF, 0x0E, 0x30, 0x9F, 0x90, 0x67, 0x77, 0x70, 0xBF, 0x90, 0x12, 0x0C, 0xF9, 0x03,
  0x77, 0x77, 0x09, 0xF9, 0x05, 0x2F, 0xA0, 0x17, 0x77, 0x70, 0x7F, 0x98, 0x18, 0x02, 0xFA, 0x77,
  0x77, 0x10, 0x5F, 0x98, 0x1A, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0x98, 0x1C, 0x05, 0xF9,
  0x0C, 0x77, 0x77, 0x10, 0x3F, 0x98, 0x1E, 0x07, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x2F, 0xA1, 0x08,
  0xF9, 0x0A, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x10, 0x8F, 0x90, 0xA7, 0x77, 0x72, 0xFA, 0x02, 0x09,
  0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x03, 0x0A, 0xF9,
  0x09, 0x77, 0x77, 0x2F, 0xA0, 0x40, 0xAF, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x04, 0x09, 0xF9, 0x09,
  0x77, 0x77, 0x2F, 0xA0, 0x30, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x03, 0x09, 0xF9, 0x0A, 0x77,
  0x77, 0x2F, 0xA0, 0x20, 0x8F, 0x90, 0xB7, 0x77, 0x71, 0x01, 0xFA, 0x01, 0x06, 0xF9, 0x0C, 0x77,
  0x77, 0x10, 0x2F, 0xA1, 0x05, 0xF9, 0x0D, 0x77, 0x77, 0x10, 0x3F, 0x98, 0x1E, 0x03, 0xF9, 0x0E,
  0x77, 0x77, 0x10, 0x5F, 0x98, 0x1C, 0x02, 0xFA, 0x77, 0x77, 0x10, 0x6F, 0x90, 0xA2, 0x0E, 0xF9,
  0x02, 0x77, 0x77, 0x08, 0xF9, 0x08, 0x20, 0xCF, 0x90, 0x47, 0x77, 0x70, 0xAF, 0x90, 0x52, 0x09,
  0xF9, 0x06, 0x77, 0x77, 0x0C, 0xF9, 0x02, 0x20, 0x6F, 0x90, 0x97, 0x77, 0x7F, 0x90, 0xE3, 0x02,
  0xF9, 0x0C, 0x77, 0x76, 0x02, 0xF9, 0x0A, 0x40, 0xEF, 0x97, 0x77, 0x60, 0x6F, 0x90, 0x64, 0x0A,
  0xF9, 0x04, 0x77, 0x75, 0x0A, 0xF9, 0x01, 0x40, 0x5F, 0x90, 0x87, 0x77, 0x50, 0xDF, 0x0B, 0x60,
  0xEF, 0x0D, 0x77, 0x74, 0x03, 0xF9, 0x06, 0x60, 0x9F, 0x90, 0x27, 0x77, 0x30, 0x8F, 0x0E, 0x70,
  0x3F, 0x90, 0x87, 0x77, 0x30, 0xEF, 0x08, 0x71, 0x0B, 0xF0, 0xE7, 0x77, 0x20, 0x5F, 0x90, 0x17,
  0x10, 0x3F, 0x90, 0x77, 0x77, 0x10, 0xCF, 0x08, 0x73, 0x0A, 0xF0, 0xE0, 0x17, 0x76, 0x06, 0xF0,
  0xE0, 0x17, 0x30, 0x10, 0xEF, 0x0B, 0x77, 0x50, 0x20, 0xEF, 0x05, 0x75, 0x04, 0xF9, 0x09, 0x77,
  0x30, 0x10, 0xDF, 0x09, 0x77, 0x08, 0xF9, 0x09, 0x77, 0x10, 0x20, 0xDF, 0x0C, 0x77, 0x20, 0xAF,
  0x90, 0xD0, 0x47, 0x50, 0x70, 0xEF, 0x0D, 0x01, 0x77, 0x30, 0xAF, 0xA8, 0x1C, 0x73, 0x58, 0x21,
  0x49, 0xEF, 0x90, 0xD0, 0x27, 0x75, 0x08, 0xFD, 0x82, 0xED, 0xDE, 0xFC, 0x0B, 0x01, 0x77, 0x70,
  0x40, 0xEF, 0xFF, 0xB0, 0x77, 0x77, 0x40, 0x70, 0xEF, 0xFE, 0x0A, 0x02, 0x77, 0x76, 0x81, 0x16,
  0xCF, 0xF9, 0x81, 0xE8, 0x27, 0x77, 0x74, 0x82, 0x25, 0x9C, 0xFA, 0x09, 0x03, 0x80, 0xC3, 0x00,
  0xCF, 0x90, 0x68, 0x0C, 0x40, 0x0B, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0x9F, 0x90, 0x98, 0x0C, 0x40,
  0x08, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x5F, 0x90, 0xE8, 0x0C, 0x40, 0x01, 0xFA, 0x02, 0x80, 0xC4,
  0x00, 0xEF, 0x90, 0x68, 0x0C, 0x40, 0x09, 0xF9, 0x0A, 0x80, 0xC4, 0x00, 0x4F, 0xA0, 0x18, 0x0C,
  0x40, 0x0E, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0x7F, 0x90, 0xE0, 0x18, 0x0C, 0x40, 0x0E, 0xF9, 0x0A,
  0x80, 0xC4, 0x00, 0x5F, 0xA0, 0x78, 0x0C, 0x40, 0x09, 0xFA, 0x08, 0x80, 0xC4, 0x00, 0xBF, 0xA8,
  0x1D, 0x61, 0x80, 0xC2, 0x00, 0xCF, 0xC8, 0x2C, 0xA9, 0x97, 0x77, 0x77, 0x09, 0xFF, 0x80, 0xC0,
  0x00, 0x50, 0xDF, 0xD8, 0x0C, 0x20, 0x05, 0x0B, 0xFB, 0x80, 0xC4, 0x08, 0x31, 0x69, 0xCE, 0xD7,
  // "R" (U+0052)
  0x03, 0xFF, 0xF9, 0x86, 0xEE, 0xDC, 0xA8, 0x52, 0x77, 0x50, 0x3F, 0xFF, 0xFA, 0x81, 0xD8, 0x37,
  0x72, 0x03, 0xFF, 0xFF, 0xD0, 0xC0, 0x37, 0x70, 0x3F, 0xFF, 0xFF, 0x09, 0x77, 0x83, 0x11, 0x36,
  0xBF, 0xB0, 0xD8, 0x01, 0x98, 0x1A, 0xBC, 0xFD, 0x0C, 0x01, 0x77, 0x30, 0x5F, 0xA0, 0x97, 0x20,
  0x30, 0x9F, 0xB0, 0xC7, 0x74, 0x09, 0xF9, 0x09, 0x74, 0x01, 0x0B, 0xFA, 0x09, 0x77, 0x30, 0x3F,
  0x90, 0x97, 0x60, 0x9F, 0xA0, 0x37, 0x73, 0xF9, 0x09, 0x77, 0x0C, 0xF9, 0x0B, 0x77, 0x30, 0xEF,
  0x09, 0x77, 0x03, 0xFA, 0x02, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x10, 0xCF, 0x90, 0x77, 0x72, 0x0E,
  0xF0, 0x97, 0x71, 0x06, 0xF9, 0x0C, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x10, 0x2F, 0xA7, 0x72, 0x0E,
  0xF0, 0x97, 0x72, 0x0E, 0xF9, 0x02, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xCF, 0x90, 0x37, 0x71,
  0x0E, 0xF0, 0x97, 0x72, 0x0B, 0xF9, 0x05, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xAF, 0x90, 0x57,
  0x71, 0x0E, 0xF0, 0x97, 0x72, 0x09, 0xF9, 0x05, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xAF, 0x90,
  0x47, 0x71, 0x0E, 0xF0, 0x97, 0x72, 0x0B, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x20, 0xCF,
  0x90, 0x17, 0x71, 0x0E, 0xF0, 0x97, 0x72, 0x0E, 0xF0, 0xE7, 0x72, 0x0E, 0xF0, 0x97, 0x71, 0x02,
  0xF9, 0x0B, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x10, 0x5F, 0x90, 0x67, 0x72, 0x0E, 0xF0, 0x97, 0x71,
  0x0B, 0xF9, 0x01, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x01, 0xF9, 0x09, 0x77, 0x30, 0xEF, 0x09, 0x77,
  0x0A, 0xF0, 0xE0, 0x17, 0x73, 0x0E, 0xF0, 0x97, 0x60, 0x4F, 0x90, 0x67, 0x74, 0x0E, 0xF0, 0x97,
  0x50, 0x30, 0xEF, 0x0A, 0x77, 0x50, 0xEF, 0x09, 0x74, 0x06, 0x0E, 0xF0, 0xB7, 0x76, 0x0E, 0xF0,
  0x97, 0x18, 0x12, 0x6D, 0xF9, 0x0A, 0x77, 0x70, 0xEF, 0x0D, 0x80, 0x19, 0x81, 0xAB, 0xDF, 0xA0,
  0xE0, 0x57, 0x77, 0x10, 0xEF, 0xFF, 0xB0, 0xA0, 0x17, 0x77, 0x20, 0xEF, 0xFF, 0x90, 0x90, 0x27,
  0x77, 0x40, 0xEF, 0xFF, 0x90, 0x67, 0x77, 0x50, 0xEF, 0xFF, 0x90, 0xE7, 0x77, 0x50, 0xEF, 0x09,
  0x60, 0xBF, 0x90, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x60, 0x3F, 0x90, 0xE0, 0x17, 0x77, 0x30, 0xEF,
  0x09, 0x70, 0xBF, 0x90, 0x87, 0x77, 0x30, 0xEF, 0x09, 0x70, 0x3F, 0xA0, 0x27, 0x77, 0x20, 0xEF,
  0x09, 0x71, 0x0A, 0xF9, 0x0A, 0x77, 0x72, 0x0E, 0xF0, 0x97, 0x10, 0x3F, 0xA0, 0x37, 0x77, 0x10,
  0xEF, 0x09, 0x72, 0x0A, 0xF9, 0x0B, 0x77, 0x71, 0x0E, 0xF0, 0x97, 0x20, 0x2F, 0xA0, 0x47, 0x77,
  0x0E, 0xF0, 0x97, 0x30, 0xAF, 0x90, 0xC7, 0x77, 0x0E, 0xF0, 0x97, 0x30, 0x2F, 0xA0, 0x57, 0x76,
  0x0E, 0xF0, 0x97, 0x40, 0xAF, 0x90, 0xD7, 0x76, 0x0E, 0xF0, 0x97, 0x40, 0x2F, 0xA0, 0x67, 0x75,
  0x0E, 0xF0, 0x97, 0x50, 0x9F, 0x90, 0xE7, 0x75, 0x0E, 0xF0, 0x97, 0x50, 0x2F, 0xA0, 0x87, 0x74,
  0x0E, 0xF0, 0x97, 0x60, 0x9F, 0x90, 0xE0, 0x17, 0x73, 0x0E, 0xF0, 0x97, 0x60, 0x1F, 0xA0, 0x97,
  0x73, 0x0E, 0xF0, 0x97, 0x70, 0x9F, 0xA0, 0x27, 0x72, 0x0E, 0xF0, 0x97, 0x70, 0x1F, 0xA0, 0xB7,
  0x72, 0x0E, 0xF0, 0xA7, 0x71, 0x09, 0xFA, 0x04, 0x77, 0x1F, 0x90, 0xB7, 0x71, 0x01, 0xFA, 0x0D,
  0x77, 0x03, 0xF9, 0x0D, 0x77, 0x20, 0x8F, 0xA0, 0xA7, 0x60, 0x8F, 0xA0, 0x27, 0x71, 0x01, 0x0E,
  0xFA, 0x07, 0x74, 0x03, 0x0E, 0xFA, 0x0B, 0x77, 0x20, 0x5F, 0xB0, 0x77, 0x81, 0x14, 0xAF, 0xD8,
  0x2E, 0x83, 0x17, 0x60, 0xAF, 0xB8, 0x3B, 0x41, 0x03, 0xFF, 0xF9, 0x08, 0x75, 0x0C, 0xFD, 0x08,
  0x03, 0xFF, 0xF9, 0x08, 0x76, 0x0A, 0xFC, 0x08, 0x03, 0xFF, 0xF9, 0x08, 0x77, 0x05, 0x0C, 0xFA,
  0x08, 0x03, 0xFF, 0xF9, 0x08, 0x77, 0x28, 0x42, 0x69, 0xBD, 0xEB, 0x08,
  // "S" (U+0053)
  0x76, 0x83, 0x38, 0xAD, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x68, 0x12, 0x8E, 0xFE, 0x0A, 0x03,
  0x77, 0x20, 0x10, 0x8F, 0xFC, 0x0B, 0x01, 0x76, 0x03, 0x0D, 0xFF, 0xE0, 0xE0, 0x47, 0x40, 0x5F,
  0x98, 0x4E, 0xBA, 0x9A, 0xDF, 0xB0, 0x47, 0x20, 0x4F, 0x0C, 0x04, 0x60, 0x20, 0x9F, 0x90, 0xE0,
  0x17, 0x02, 0x0E, 0xE0, 0x87, 0x30, 0x5F, 0x90, 0xA7, 0x0C, 0xE0, 0x97, 0x50, 0x5F, 0x90, 0x25,
  0x05, 0xE0, 0xD7, 0x70, 0x9F, 0x07, 0x50, 0xCE, 0x06, 0x77, 0x01, 0xF0, 0xA4, 0x03, 0xE0, 0xE7,
  0x72, 0x0A, 0xE0, 0xA4, 0x07, 0xE0, 0xB7, 0x72, 0x06, 0xE0, 0x94, 0x0B, 0xE0, 0x87, 0x72, 0x02,
  0xE0, 0x54, 0x0D, 0xE0, 0x67, 0x73, 0xD0, 0xD5, 0xF0, 0x57, 0x73, 0x0D, 0xB0, 0xD0, 0x25, 0xF0,
  0x57, 0x73, 0x82, 0xAC, 0xA5, 0x7F, 0x06, 0x77, 0x77, 0x0E, 0xE0, 0x77, 0x77, 0x70, 0xDE, 0x0A,
  0x77, 0x77, 0x0C, 0xE0, 0xE7, 0x77, 0x70, 0x9F, 0x04, 0x77, 0x76, 0x06, 0xF0, 0xC7, 0x77, 0x60,
  0x2F, 0x90, 0x77, 0x77, 0x60, 0xCF, 0x90, 0x57, 0x77, 0x50, 0x6F, 0xA0, 0x67, 0x77, 0x50, 0xDF,
  0xA0, 0x97, 0x77, 0x40, 0x5F, 0xB0, 0xD0, 0x47, 0x77, 0x30, 0xAF, 0xC0, 0xA0, 0x27, 0x77, 0x20,
  0xCF, 0xD0, 0x90, 0x17, 0x77, 0x01, 0x0D, 0xFD, 0x81, 0xE8, 0x17, 0x76, 0x01, 0x0C, 0xFE, 0x0E,
  0x06, 0x77, 0x70, 0xAF, 0xF0, 0xD0, 0x37, 0x76, 0x06, 0xFF, 0x90, 0x97, 0x76, 0x02, 0x0C, 0xFF,
  0x0D, 0x02, 0x77, 0x60, 0x60, 0xDF, 0xE0, 0xE0, 0x57, 0x77, 0x07, 0x0E, 0xFE, 0x06, 0x77, 0x70,
  0x10, 0x8F, 0xE0, 0x67, 0x77, 0x10, 0x10, 0xAF, 0xD0, 0x47, 0x77, 0x20, 0x40, 0xDF, 0xB0, 0xE0,
  0x17, 0x77, 0x30, 0x9F, 0xB0, 0x97, 0x77, 0x40, 0x6F, 0xB0, 0x17, 0x77, 0x40, 0x4F, 0xA0, 0x77,
  0x77, 0x50, 0x6F, 0x90, 0xC7, 0x77, 0x60, 0xAF, 0x97, 0x77, 0x60, 0x1F, 0x90, 0x47, 0x77, 0x60,
  0xAF, 0x06, 0x77, 0x76, 0x05, 0xF0, 0x74, 0x81, 0x69, 0x77, 0x76, 0x01, 0xF0, 0x82, 0x04, 0x0E,
  0xA0, 0xB7, 0x77, 0x0E, 0xE8, 0x19, 0x03, 0xC0, 0xD7, 0x77, 0x0D, 0xE8, 0x18, 0x0C, 0xD7, 0x77,
  0x0D, 0xE0, 0x70, 0x2E, 0x03, 0x77, 0x60, 0xEE, 0x00, 0x5E, 0x06, 0x77, 0x6F, 0x03, 0x05, 0xE0,
  0xB7, 0x75, 0x03, 0xF1, 0x04, 0xF0, 0x27, 0x74, 0x06, 0xE8, 0x1B, 0x03, 0xF0, 0x97, 0x74, 0x0C,
  0xE0, 0x62, 0xF9, 0x02, 0x77, 0x20, 0x3E, 0x0E, 0x30, 0xBF, 0x0B, 0x77, 0x20, 0xCE, 0x08, 0x30,
  0x5F, 0x90, 0xA7, 0x70, 0xAE, 0x0D, 0x50, 0xCF, 0x90, 0xA0, 0x17, 0x30, 0x10, 0xBF, 0x03, 0x50,
  0x3F, 0xA8, 0x1E, 0x71, 0x68, 0x12, 0x8E, 0xF0, 0x57, 0x05, 0xFC, 0x84, 0xCB, 0x9A, 0xBD, 0xFA,
  0x05, 0x72, 0x06, 0xFF, 0xFA, 0x0D, 0x03, 0x74, 0x03, 0x0C, 0xFF, 0xD0, 0xE0, 0x77, 0x71, 0x04,
  0x0B, 0xFF, 0x98, 0x1D, 0x71, 0x77, 0x48, 0x51, 0x48, 0xAC, 0xEE, 0xA8, 0x4E, 0xDC, 0x96, 0x27,
  0x50,
  // "T" (U+0054)
  0x03, 0x80, 0xC7, 0xF8, 0x1C, 0x03, 0x80, 0xC7, 0xF8, 0x1D, 0x04, 0x80, 0xC7, 0xF8, 0x1D, 0x04,
  0x80, 0xC7, 0xF8, 0x1D, 0x04, 0xF9, 0x0C, 0x0A, 0x80, 0x39, 0x0C, 0xF9, 0x80, 0x49, 0x0B, 0x0E,
  0xF8, 0x1E, 0x05, 0xE0, 0xB0, 0x27, 0x20, 0x7F, 0x97, 0x30, 0x50, 0xED, 0x81, 0xE0, 0x5D, 0x0C,
  0x74, 0x07, 0xF9, 0x74, 0x04, 0xD8, 0x1E, 0x05, 0xD0, 0x37, 0x40, 0x7F, 0x97, 0x50, 0xAD, 0x10,
  0x6C, 0x0C, 0x75, 0x07, 0xF9, 0x75, 0x03, 0xD1, 0x06, 0xC0, 0x77, 0x50, 0x7F, 0x97, 0x60, 0xDC,
  0x10, 0x6C, 0x03, 0x75, 0x07, 0xF9, 0x76, 0x0A, 0xC1, 0x07, 0xC0, 0x17, 0x50, 0x7F, 0x97, 0x60,
  0x6C, 0x01, 0x07, 0xB0, 0xE7, 0x60, 0x7F, 0x97, 0x60, 0x4C, 0x01, 0x08, 0xB0, 0xD7, 0x60, 0x7F,
  0x97, 0x60, 0x2C, 0x01, 0x08, 0xB0, 0xB7, 0x60, 0x7F, 0x97, 0x7C, 0x84, 0x25, 0xAA, 0xA6, 0x76,
  0x07, 0xF9, 0x77, 0x83, 0x9A, 0xAA, 0x17, 0x74, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C,
  0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F,
  0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1,
  0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9,
  0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10,
  0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98,
  0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00,
  0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80,
  0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07,
  0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C,
  0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F, 0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x7F,
  0x98, 0x0C, 0x10, 0x07, 0xF9, 0x80, 0xC1, 0x00, 0x8F, 0x90, 0x18, 0x0C, 0x00, 0x0C, 0xF9, 0x05,
  0x77, 0x77, 0x70, 0x2F, 0xA0, 0xB7, 0x77, 0x76, 0x01, 0x0C, 0xFB, 0x07, 0x77, 0x77, 0x28, 0x21,
  0x49, 0xEF, 0xD8, 0x1C, 0x62, 0x77, 0x73, 0x0A, 0xFF, 0xFB, 0x01, 0x77, 0x60, 0xAF, 0xFF, 0xB0,
  0x17, 0x76, 0x0A, 0xFF, 0xFB, 0x01, 0x77, 0x60, 0xAF, 0xFF, 0xB0, 0x17, 0x30,
  // "U" (U+0055)
  0x0C, 0xFF, 0xF9, 0x03, 0x72, 0x01, 0xFF, 0xD0, 0x40, 0xCF, 0xFF, 0x90, 0x37, 0x20, 0x1F, 0xFD,
  0x04, 0x0C, 0xFF, 0xF9, 0x03, 0x72, 0x01, 0xFF, 0xD0, 0x40, 0xCF, 0xFF, 0x90, 0x37, 0x20, 0x1F,
  0xFD, 0x04, 0x28, 0x21, 0x38, 0xEF, 0xD8, 0x1B, 0x52, 0x77, 0x18, 0x11, 0x5A, 0xFA, 0x81, 0xB5,
  0x27, 0x10, 0x10, 0xCF, 0xB0, 0x67, 0x77, 0x03, 0x0E, 0xE0, 0x67, 0x50, 0x3F, 0xA0, 0xA7, 0x77,
  0x20, 0x7D, 0x0A, 0x77, 0x0D, 0xF9, 0x05, 0x77, 0x72, 0x02, 0xD0, 0x57, 0x70, 0xAF, 0x90, 0x27,
  0x77, 0x3D, 0x01, 0x77, 0x09, 0xF9, 0x01, 0x77, 0x73, 0x0E, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71,
  0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9,
  0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71,
  0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9,
  0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x07, 0xF9, 0x77, 0x74, 0x0E, 0xB0, 0xE7, 0x71,
  0x07, 0xF9, 0x01, 0x77, 0x73, 0xC0, 0xE7, 0x71, 0x05, 0xF9, 0x02, 0x77, 0x72, 0x01, 0xC0, 0xD7,
  0x71, 0x04, 0xF9, 0x04, 0x77, 0x72, 0x03, 0xC0, 0xB7, 0x71, 0x01, 0xF9, 0x07, 0x77, 0x72, 0x07,
  0xC0, 0x97, 0x72, 0x0E, 0xF0, 0xA7, 0x77, 0x20, 0xBC, 0x05, 0x77, 0x20, 0xBF, 0x0E, 0x77, 0x71,
  0x01, 0xD0, 0x27, 0x72, 0x06, 0xF9, 0x05, 0x77, 0x70, 0x8C, 0x0D, 0x77, 0x30, 0x1F, 0x90, 0xC7,
  0x76, 0x02, 0x0E, 0xC0, 0x77, 0x74, 0x0B, 0xF9, 0x07, 0x77, 0x50, 0xBC, 0x0E, 0x01, 0x77, 0x40,
  0x3F, 0xA0, 0x57, 0x73, 0x07, 0xD0, 0x87, 0x76, 0x0A, 0xFA, 0x07, 0x77, 0x10, 0x8D, 0x0D, 0x77,
  0x70, 0x10, 0xEF, 0xA0, 0xC0, 0x47, 0x40, 0x30, 0xCE, 0x04, 0x77, 0x71, 0x03, 0x0E, 0xFB, 0x83,
  0xD8, 0x42, 0x12, 0x82, 0x14, 0x7C, 0xF0, 0x67, 0x77, 0x30, 0x30, 0xEF, 0xFF, 0xD0, 0x77, 0x77,
  0x50, 0x10, 0xBF, 0xFF, 0xA0, 0xE0, 0x57, 0x77, 0x71, 0x05, 0x0D, 0xFF, 0xE0, 0x90, 0x17, 0x77,
  0x74, 0x05, 0x0B, 0xFF, 0x98, 0x1E, 0x82, 0x80, 0xC1, 0x08, 0x44, 0x7A, 0xCE, 0xEA, 0x84, 0xED,
  0xC9, 0x63, 0x77, 0x60,
  // "V" (U+0056)
  0xFF, 0xF0, 0xA7, 0x40, 0x8F, 0xFC, 0x01, 0xFF, 0xF0, 0xA7, 0x40, 0x8F, 0xFC, 0x01, 0xFF, 0xF0,
  0xA7, 0x40, 0x8F, 0xFC, 0x01, 0xFF, 0xF0, 0xA7, 0x40, 0x8F, 0xFC, 0x01, 0x28, 0x11, 0x6D, 0xFC,
  0x81, 0xD5, 0x17, 0x73, 0x81, 0x14, 0xAF, 0x98, 0x1E, 0x72, 0x70, 0x10, 0xEF, 0xA0, 0xE0, 0x17,
  0x77, 0x10, 0x7F, 0x03, 0x73, 0x05, 0xFA, 0x08, 0x77, 0x73, 0x0E, 0xD0, 0x87, 0x50, 0xEF, 0x90,
  0x67, 0x77, 0x30, 0xCD, 0x01, 0x75, 0x09, 0xF9, 0x07, 0x77, 0x73, 0x0C, 0xC0, 0xA7, 0x60, 0x4F,
  0x90, 0x97, 0x77, 0x30, 0xEC, 0x04, 0x77, 0x0E, 0xF0, 0xD7, 0x77, 0x20, 0x3C, 0x0E, 0x77, 0x10,
  0xAF, 0x90, 0x27, 0x77, 0x10, 0x6C, 0x0A, 0x77, 0x10, 0x6F, 0x90, 0x67, 0x77, 0x10, 0xAC, 0x05,
  0x77, 0x10, 0x1F, 0x90, 0xA7, 0x77, 0x10, 0xEC, 0x01, 0x77, 0x20, 0xCF, 0x0E, 0x77, 0x70, 0x4C,
  0x0B, 0x77, 0x30, 0x8F, 0x90, 0x37, 0x76, 0x08, 0xC0, 0x77, 0x73, 0x03, 0xF9, 0x07, 0x77, 0x60,
  0xDC, 0x02, 0x77, 0x40, 0xEF, 0x0C, 0x77, 0x50, 0x2C, 0x0D, 0x77, 0x50, 0xAF, 0x97, 0x75, 0x06,
  0xC0, 0x97, 0x75, 0x05, 0xF9, 0x05, 0x77, 0x40, 0xBC, 0x04, 0x77, 0x50, 0x1F, 0x90, 0x97, 0x74,
  0xD7, 0x77, 0x0B, 0xF0, 0xD7, 0x73, 0x04, 0xC0, 0xB7, 0x77, 0x07, 0xF9, 0x02, 0x77, 0x20, 0x9C,
  0x06, 0x77, 0x70, 0x2F, 0x90, 0x67, 0x72, 0x0D, 0xC0, 0x27, 0x77, 0x10, 0xDF, 0x0A, 0x77, 0x10,
  0x2C, 0x0D, 0x77, 0x72, 0x09, 0xF0, 0xE7, 0x71, 0x06, 0xC0, 0x87, 0x77, 0x20, 0x4F, 0x90, 0x37,
  0x70, 0xBC, 0x03, 0x77, 0x73, 0xF9, 0x07, 0x77, 0xC0, 0xE7, 0x77, 0x40, 0xBF, 0x0C, 0x76, 0x04,
  0xC0, 0xA7, 0x77, 0x40, 0x6F, 0x90, 0x17, 0x50, 0x9C, 0x05, 0x77, 0x74, 0x02, 0xF9, 0x05, 0x75,
  0x0D, 0xC0, 0x17, 0x77, 0x50, 0xDF, 0x09, 0x74, 0x02, 0xC0, 0xC7, 0x77, 0x60, 0x8F, 0x0D, 0x74,
  0x07, 0xC0, 0x77, 0x77, 0x60, 0x3F, 0x90, 0x27, 0x30, 0xBC, 0x03, 0x77, 0x77, 0x0E, 0xF0, 0x67,
  0x3C, 0x0D, 0x77, 0x77, 0x10, 0xAF, 0x0A, 0x72, 0x04, 0xC0, 0x97, 0x77, 0x71, 0x05, 0xF0, 0xE7,
  0x20, 0x9C, 0x04, 0x77, 0x77, 0x10, 0x1F, 0x90, 0x37, 0x10, 0xDC, 0x77, 0x77, 0x30, 0xCF, 0x08,
  0x70, 0x2C, 0x0B, 0x77, 0x77, 0x30, 0x7F, 0x0C, 0x70, 0x7C, 0x06, 0x77, 0x77, 0x30, 0x3F, 0x90,
  0x16, 0x0B, 0xC0, 0x27, 0x77, 0x74, 0x0E, 0xF0, 0x56, 0xC0, 0xD7, 0x77, 0x75, 0x09, 0xF0, 0x95,
  0x05, 0xC0, 0x87, 0x77, 0x75, 0x05, 0xF0, 0xD5, 0x09, 0xC0, 0x47, 0x77, 0x76, 0xF9, 0x02, 0x40,
  0xDB, 0x0E, 0x77, 0x77, 0x70, 0xBF, 0x06, 0x30, 0x2C, 0x0A, 0x77, 0x77, 0x70, 0x6F, 0x0A, 0x30,
  0x6C, 0x05, 0x77, 0x77, 0x70, 0x2F, 0x0E, 0x30, 0xAC, 0x01, 0x80, 0xC0, 0x00, 0xDF, 0x03, 0x20,
  0xEB, 0x0C, 0x80, 0xC1, 0x00, 0x8F, 0x81, 0x60, 0x2C, 0x07, 0x80, 0xC1, 0x00, 0x4F, 0x81, 0xA0,
  0x6C, 0x03, 0x80, 0xC2, 0x00, 0xEE, 0x81, 0xD0, 0x9B, 0x0E, 0x80, 0xC3, 0x00, 0xAF, 0x01, 0x0D,
  0xB0, 0x98, 0x0C, 0x30, 0x06, 0xF0, 0x5C, 0x05, 0x80, 0xC3, 0x00, 0x1F, 0x0C, 0xC8, 0x0C, 0x50,
  0x0C, 0xFB, 0x0B, 0x80, 0xC5, 0x00, 0x7F, 0xB0, 0x68, 0x0C, 0x50, 0x03, 0xFB, 0x02, 0x80, 0xC6,
  0x00, 0xEF, 0x90, 0xD8, 0x0C, 0x70, 0x09, 0xF9, 0x08, 0x80, 0xC7, 0x00, 0x5F, 0x90, 0x48, 0x0C,
  0x70, 0x01, 0xF0, 0xE8, 0x0D, 0x10, 0x0B, 0xE0, 0xA8, 0x0D, 0x10, 0x07, 0xE0, 0x67, 0x77, 0x20,
  // "W" (U+0057)
  0x05, 0xFF, 0xF0, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x71, 0x0C, 0xFF, 0xC0, 0x20, 0x5F, 0xFF, 0x07,
  0x77, 0x10, 0x6E, 0x0C, 0x77, 0x10, 0xCF, 0xFC, 0x02, 0x05, 0xFF, 0xF0, 0x77, 0x71, 0x09, 0xF7,
  0x71, 0x0C, 0xFF, 0xC0, 0x20, 0x5F, 0xFF, 0x07, 0x77, 0x10, 0xDF, 0x03, 0x77, 0x0C, 0xFF, 0xC0,
  0x22, 0x81, 0x13, 0xAF, 0xD8, 0x1B, 0x41, 0x77, 0x30, 0x1F, 0x90, 0x77, 0x73, 0x81, 0x14, 0xAF,
  0x98, 0x1E, 0x61, 0x71, 0x05, 0xFB, 0x0A, 0x77, 0x60, 0x5F, 0x90, 0xA7, 0x76, 0x08, 0xE0, 0xE0,
  0x17, 0x40, 0xBF, 0xA0, 0x37, 0x76, 0x09, 0xF9, 0x0E, 0x77, 0x60, 0x1E, 0x05, 0x75, 0x05, 0xFA,
  0x02, 0x77, 0x60, 0xDF, 0xA0, 0x27, 0x76, 0xD0, 0xD7, 0x7F, 0xA0, 0x37, 0x75, 0x01, 0xFB, 0x05,
  0x77, 0x6D, 0x08, 0x77, 0x0C, 0xF9, 0x04, 0x77, 0x50, 0x5F, 0xB0, 0x97, 0x75, 0x02, 0xD0, 0x37,
  0x70, 0x8F, 0x90, 0x87, 0x75, 0x08, 0xFB, 0x0C, 0x77, 0x50, 0x5C, 0x0E, 0x77, 0x10, 0x4F, 0x90,
  0xB7, 0x75, 0x0C, 0xFC, 0x77, 0x50, 0x8C, 0x0A, 0x77, 0x10, 0x1F, 0x90, 0xE7, 0x75, 0xFD, 0x04,
  0x77, 0x40, 0xBC, 0x06, 0x77, 0x20, 0xCF, 0x90, 0x27, 0x73, 0x04, 0xFD, 0x07, 0x77, 0x40, 0xEC,
  0x03, 0x77, 0x20, 0x9F, 0x90, 0x67, 0x73, 0x08, 0xC0, 0xAF, 0x0B, 0x77, 0x30, 0x3C, 0x0E, 0x77,
  0x30, 0x5F, 0x90, 0x97, 0x73, 0x0B, 0xC0, 0x3F, 0x0E, 0x77, 0x30, 0x6C, 0x0B, 0x77, 0x30, 0x1F,
  0x90, 0xD7, 0x73, 0xC8, 0x1D, 0x0D, 0xF0, 0x27, 0x72, 0x0A, 0xC0, 0x77, 0x74, 0x0D, 0xF9, 0x01,
  0x77, 0x10, 0x3C, 0x81, 0x90, 0xAF, 0x05, 0x77, 0x20, 0xEC, 0x03, 0x77, 0x40, 0x9F, 0x90, 0x47,
  0x71, 0x07, 0xC8, 0x15, 0x06, 0xF0, 0x97, 0x71, 0x02, 0xD7, 0x75, 0x06, 0xF9, 0x08, 0x77, 0x10,
  0xBC, 0x81, 0x20, 0x2F, 0x0C, 0x77, 0x10, 0x6C, 0x0B, 0x77, 0x50, 0x2F, 0x90, 0xB7, 0x71, 0x0E,
  0xB0, 0xD3, 0x0E, 0xF0, 0x17, 0x70, 0x9C, 0x08, 0x77, 0x60, 0xEF, 0x0E, 0x77, 0x03, 0xC0, 0xA3,
  0x0B, 0xF0, 0x47, 0x70, 0xDC, 0x04, 0x77, 0x60, 0xAF, 0x90, 0x37, 0x60, 0x7C, 0x06, 0x30, 0x7F,
  0x07, 0x76, 0x01, 0xD7, 0x77, 0x06, 0xF9, 0x06, 0x76, 0x0A, 0xC0, 0x23, 0x04, 0xF0, 0xB7, 0x60,
  0x5C, 0x0C, 0x77, 0x70, 0x2F, 0x90, 0xA7, 0x60, 0xEB, 0x0E, 0x5F, 0x0E, 0x76, 0x08, 0xC0, 0x87,
  0x77, 0x10, 0xEF, 0x0D, 0x75, 0x02, 0xC0, 0xA5, 0x0C, 0xF0, 0x27, 0x50, 0xCC, 0x05, 0x77, 0x71,
  0x0A, 0xF9, 0x01, 0x74, 0x06, 0xC0, 0x75, 0x08, 0xF0, 0x67, 0x5D, 0x01, 0x77, 0x71, 0x07, 0xF9,
  0x05, 0x74, 0x0A, 0xC0, 0x35, 0x05, 0xF0, 0x97, 0x40, 0x4C, 0x0D, 0x77, 0x72, 0x03, 0xF9, 0x08,
  0x74, 0x0D, 0xB0, 0xE6, 0x01, 0xF0, 0xD7, 0x40, 0x8C, 0x09, 0x77, 0x73, 0x0E, 0xF0, 0xC7, 0x30,
  0x2C, 0x0B, 0x70, 0xDF, 0x01, 0x73, 0x0B, 0xC0, 0x57, 0x77, 0x30, 0xBF, 0x97, 0x30, 0x6C, 0x07,
  0x70, 0x9F, 0x04, 0x73, 0x0E, 0xC0, 0x27, 0x77, 0x30, 0x7F, 0x90, 0x37, 0x20, 0x9C, 0x03, 0x70,
  0x6F, 0x08, 0x72, 0x03, 0xC0, 0xD7, 0x77, 0x40, 0x3F, 0x90, 0x77, 0x20, 0xDC, 0x71, 0x02, 0xF0,
  0xB7, 0x20, 0x7C, 0x0A, 0x77, 0x75, 0xF9, 0x0A, 0x71, 0x01, 0xC0, 0xB7, 0x20, 0xEE, 0x0E, 0x72,
  0x0A, 0xC0, 0x67, 0x77, 0x50, 0xBF, 0x0E, 0x71, 0x05, 0xC0, 0x87, 0x20, 0xBF, 0x03, 0x71, 0x0E,
  0xC0, 0x27, 0x77, 0x50, 0x8F, 0x90, 0x27, 0x09, 0xC0, 0x47, 0x20, 0x7F, 0x06, 0x70, 0x2C, 0x0E,
  0x77, 0x76, 0x04, 0xF9, 0x05, 0x70, 0xCC, 0x73, 0x03, 0xF0, 0xA7, 0x06, 0xC0, 0xA7, 0x77, 0x7F,
  0x90, 0x96, 0x01, 0xC0, 0xC7, 0x4F, 0x0D, 0x70, 0xAC, 0x07, 0x77, 0x77, 0x0C, 0xF0, 0xC6, 0x04,
  0xC0, 0x87, 0x40, 0xCF, 0x01, 0x60, 0xDC, 0x03, 0x77, 0x77, 0x08, 0xF9, 0x60, 0x8C, 0x05, 0x74,
  0x08, 0xF0, 0x55, 0x01, 0xC0, 0xE7, 0x77, 0x71, 0x05, 0xF9, 0x04, 0x50, 0xBC, 0x01, 0x74, 0x05,
  0xF0, 0x85, 0x05, 0xC0, 0xB7, 0x77, 0x71, 0x01, 0xF9, 0x07, 0x5C, 0x0D, 0x75, 0x01, 0xF0, 0xC5,
  0x09, 0xC0, 0x77, 0x77, 0x72, 0x0D, 0xF0, 0xA4, 0x03, 0xC0, 0x97, 0x60, 0xDF, 0x50, 0xCC, 0x04,
  0x77, 0x77, 0x20, 0x9F, 0x0E, 0x40, 0x6C, 0x05, 0x76, 0x09, 0xF0, 0x34, 0xD7, 0x77, 0x73, 0x05,
  0xF9, 0x02, 0x30, 0xAC, 0x01, 0x76, 0x06, 0xF0, 0x73, 0x04, 0xC0, 0xC7, 0x77, 0x73, 0x01, 0xF9,
  0x05, 0x30, 0xDB, 0x0D, 0x77, 0x02, 0xF0, 0xA3, 0x07, 0xC0, 0x87, 0x77, 0x74, 0x0D, 0xF0, 0x82,
  0x01, 0xC0, 0x97, 0x71, 0x0E, 0xE0, 0xD3, 0x0A, 0xC0, 0x47, 0x77, 0x74, 0x09, 0xF0, 0xC2, 0x04,
  0xC0, 0x67, 0x71, 0x0B, 0xF0, 0x12, 0x0E, 0xC0, 0x17, 0x77, 0x74, 0x06, 0xF9, 0x20, 0x7C, 0x02,
  0x77, 0x10, 0x7F, 0x81, 0x50, 0x1C, 0x0C, 0x77, 0x77, 0x50, 0x2F, 0x98, 0x13, 0x0A, 0xB0, 0xE7,
  0x72, 0x03, 0xF8, 0x18, 0x04, 0xC0, 0x97, 0x77, 0x76, 0x0E, 0xF8, 0x16, 0x0E, 0xB0, 0xA7, 0x73,
  0xF8, 0x1B, 0x07, 0xC0, 0x57, 0x77, 0x76, 0x0A, 0xF0, 0x90, 0x1C, 0x06, 0x77, 0x30, 0xCE, 0x81,
  0xE0, 0xAC, 0x01, 0x77, 0x77, 0x60, 0x6F, 0x0C, 0x04, 0xC0, 0x37, 0x73, 0x08, 0xF0, 0x10, 0xDB,
  0x0D, 0x77, 0x77, 0x70, 0x2F, 0x0E, 0x06, 0xB0, 0xE7, 0x74, 0x05, 0xF0, 0x5C, 0x09, 0x80, 0xC0,
  0x00, 0xEF, 0x0B, 0xB0, 0xB7, 0x74, 0x01, 0xF0, 0xAC, 0x06, 0x80, 0xC0, 0x00, 0xBF, 0xC0, 0x77,
  0x75, 0x0D, 0xFC, 0x02, 0x80, 0xC0, 0x00, 0x7F, 0xC0, 0x37, 0x75, 0x09, 0xFB, 0x0E, 0x80, 0xC1,
  0x00, 0x3F, 0xC7, 0x76, 0x06, 0xFB, 0x0A, 0x80, 0xC2, 0x00, 0xEF, 0xA0, 0xB7, 0x76, 0x02, 0xFB,
  0x06, 0x80, 0xC2, 0x00, 0xBF, 0xA0, 0x87, 0x77, 0x0E, 0xFA, 0x03, 0x80, 0xC2, 0x00, 0x7F, 0xA0,
  0x47, 0x77, 0x0A, 0xF9, 0x0E, 0x80, 0xC3, 0x00, 0x4F, 0xA7, 0x77, 0x10, 0x7F, 0x90, 0xB8, 0x0C,
  0x40, 0xF9, 0x0C, 0x77, 0x71, 0x03, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0xCF, 0x08, 0x77, 0x72, 0xF9,
  0x03, 0x77, 0x60,
  // "X" (U+0058)
  0x10, 0x3F, 0xFF, 0x04, 0x71, 0x0C, 0xFF, 0xA0, 0x22, 0x03, 0xFF, 0xF0, 0x47, 0x10, 0xCF, 0xFA,
  0x02, 0x20, 0x3F, 0xFF, 0x04, 0x71, 0x0C, 0xFF, 0xA0, 0x22, 0x03, 0xFF, 0xF0, 0x47, 0x10, 0xCF,
  0xFA, 0x02, 0x50, 0x30, 0x9F, 0xE8, 0x1C, 0x41, 0x74, 0x81, 0x13, 0x9F, 0xA8, 0x1B, 0x41, 0x72,
  0x03, 0x0E, 0xFB, 0x0E, 0x01, 0x77, 0x20, 0x9F, 0x07, 0x76, 0x02, 0x0E, 0xFA, 0x0B, 0x77, 0x30,
  0x6E, 0x07, 0x77, 0x10, 0x6F, 0xA0, 0xC7, 0x73, 0x07, 0xD0, 0xB7, 0x73, 0x0D, 0xFA, 0x01, 0x77,
  0x20, 0xBC, 0x0E, 0x01, 0x77, 0x30, 0x4F, 0xA0, 0x77, 0x71, 0x01, 0xD0, 0x67, 0x75, 0x0B, 0xF9,
  0x0D, 0x77, 0x10, 0x7C, 0x0C, 0x77, 0x60, 0x3F, 0xA0, 0x67, 0x60, 0x10, 0xEC, 0x03, 0x77, 0x70,
  0xAF, 0x90, 0xE7, 0x60, 0x8C, 0x0A, 0x77, 0x71, 0x02, 0xFA, 0x07, 0x74, 0x01, 0x0E, 0xC0, 0x17,
  0x77, 0x20, 0x9F, 0x90, 0xE7, 0x40, 0x9C, 0x08, 0x77, 0x73, 0x01, 0xFA, 0x07, 0x72, 0x02, 0xC0,
  0xD7, 0x77, 0x50, 0x8F, 0x90, 0xE7, 0x20, 0xAC, 0x05, 0x77, 0x75, 0x01, 0x0E, 0xF9, 0x07, 0x70,
  0x3C, 0x0C, 0x77, 0x77, 0x07, 0xF9, 0x0E, 0x70, 0xBC, 0x03, 0x77, 0x77, 0x10, 0xEF, 0x90, 0x75,
  0x04, 0xC0, 0xA7, 0x77, 0x72, 0x06, 0xF9, 0x0E, 0x01, 0x40, 0xCB, 0x0E, 0x01, 0x77, 0x77, 0x30,
  0xDF, 0x90, 0x83, 0x05, 0xC0, 0x77, 0x77, 0x74, 0x05, 0xF9, 0x0E, 0x01, 0x20, 0xDB, 0x0D, 0x77,
  0x77, 0x60, 0xCF, 0x98, 0x18, 0x06, 0xC0, 0x57, 0x77, 0x76, 0x04, 0xF9, 0x81, 0xE2, 0xDB, 0x0C,
  0x80, 0xC0, 0x00, 0xBF, 0x90, 0xDC, 0x03, 0x80, 0xC0, 0x00, 0x3F, 0xD0, 0xA8, 0x0C, 0x20, 0x0A,
  0xFB, 0x0E, 0x01, 0x80, 0xC2, 0x00, 0x2F, 0xB0, 0x78, 0x0C, 0x40, 0x09, 0xFA, 0x80, 0xC5, 0x00,
  0x10, 0xEF, 0x90, 0x58, 0x0C, 0x50, 0x08, 0xF9, 0x0D, 0x80, 0xC5, 0x00, 0x4F, 0xA0, 0x68, 0x0C,
  0x40, 0x0D, 0xFA, 0x0E, 0x80, 0xC3, 0x00, 0x7F, 0xC0, 0x88, 0x0C, 0x10, 0x01, 0x0E, 0xFC, 0x0E,
  0x01, 0x80, 0xC0, 0x00, 0xAC, 0x0C, 0xF9, 0x09, 0x77, 0x77, 0x70, 0x3C, 0x0A, 0x02, 0xFA, 0x02,
  0x77, 0x77, 0x60, 0xCC, 0x81, 0x20, 0x9F, 0x90, 0xA7, 0x77, 0x75, 0x06, 0xC0, 0x82, 0x01, 0xFA,
  0x03, 0x77, 0x77, 0x30, 0x10, 0xEB, 0x0E, 0x01, 0x30, 0x8F, 0x90, 0xC7, 0x77, 0x73, 0x09, 0xC0,
  0x64, 0x01, 0x0E, 0xF9, 0x05, 0x77, 0x77, 0x10, 0x3C, 0x0D, 0x60, 0x7F, 0x90, 0xD7, 0x77, 0x71,
  0x0C, 0xC0, 0x47, 0x0E, 0xF9, 0x06, 0x77, 0x76, 0x06, 0xC0, 0xB7, 0x10, 0x7F, 0x90, 0xE7, 0x77,
  0x50, 0x10, 0xEC, 0x03, 0x72, 0x0D, 0xF9, 0x07, 0x77, 0x74, 0x08, 0xC0, 0x97, 0x30, 0x6F, 0x90,
  0xE0, 0x17, 0x77, 0x20, 0x2C, 0x0E, 0x01, 0x74, 0x0D, 0xF9, 0x09, 0x77, 0x72, 0x0B, 0xC0, 0x77,
  0x50, 0x5F, 0xA0, 0x27, 0x77, 0x05, 0xC0, 0xD7, 0x70, 0xCF, 0x90, 0xA7, 0x77, 0x0D, 0xC0, 0x57,
  0x70, 0x4F, 0xA0, 0x37, 0x75, 0x08, 0xC0, 0xD7, 0x72, 0x0C, 0xF9, 0x0B, 0x77, 0x40, 0x2D, 0x06,
  0x77, 0x20, 0x4F, 0xA0, 0x47, 0x73, 0x0B, 0xC0, 0xE7, 0x74, 0x0B, 0xF9, 0x0C, 0x77, 0x20, 0x5D,
  0x08, 0x77, 0x40, 0x3F, 0xA0, 0x57, 0x70, 0x10, 0xDD, 0x03, 0x77, 0x50, 0xDF, 0x90, 0xD7, 0x70,
  0xAE, 0x77, 0x60, 0x9F, 0xA0, 0x97, 0x50, 0x6F, 0x77, 0x60, 0x9F, 0xB0, 0x67, 0x30, 0x6F, 0x90,
  0x57, 0x75, 0x0D, 0xFC, 0x06, 0x68, 0x11, 0x5B, 0xFB, 0x81, 0x83, 0x17, 0x68, 0x11, 0x5D, 0xFE,
  0x0B, 0x04, 0x20, 0x5F, 0xFC, 0x01, 0x72, 0x07, 0xFF, 0xF0, 0x5F, 0xFC, 0x01, 0x72, 0x07, 0xFF,
  0xF0, 0x5F, 0xFC, 0x01, 0x72, 0x07, 0xFF, 0xF0, 0x5F, 0xFC, 0x01, 0x72, 0x07, 0xFF, 0xF0,
  // "Y" (U+0059)
  0x05, 0xFF, 0xF0, 0x37, 0x10, 0x7F, 0xFC, 0x02, 0x05, 0xFF, 0xF0, 0x37, 0x10, 0x7F, 0xFC, 0x02,
  0x05, 0xFF, 0xF0, 0x37, 0x10, 0x7F, 0xFC, 0x02, 0x05, 0xFF, 0xF0, 0x37, 0x10, 0x7F, 0xFC, 0x02,
  0x28, 0x11, 0x4C, 0xFD, 0x08, 0x02, 0x77, 0x18, 0x11, 0x4A, 0xFB, 0x07, 0x01, 0x70, 0xCF, 0xB0,
  0xB7, 0x76, 0x05, 0xF9, 0x03, 0x72, 0x02, 0x0E, 0xFA, 0x06, 0x77, 0x70, 0xDE, 0x06, 0x74, 0x07,
  0xFA, 0x07, 0x77, 0x70, 0xBD, 0x0B, 0x76, 0x0D, 0xF9, 0x0A, 0x77, 0x70, 0xCD, 0x02, 0x76, 0x06,
  0xF9, 0x0E, 0x77, 0x7D, 0x09, 0x77, 0x10, 0xDF, 0x90, 0x57, 0x75, 0x04, 0xC0, 0xE0, 0x17, 0x71,
  0x06, 0xF9, 0x0B, 0x77, 0x50, 0x9C, 0x08, 0x77, 0x30, 0xDF, 0x90, 0x37, 0x73, 0x01, 0x0E, 0xB0,
  0xE0, 0x17, 0x73, 0x06, 0xF9, 0x0B, 0x77, 0x30, 0x7C, 0x08, 0x77, 0x50, 0xDF, 0x90, 0x37, 0x72,
  0x0E, 0xB0, 0xE0, 0x17, 0x75, 0x05, 0xF9, 0x0B, 0x77, 0x10, 0x7C, 0x08, 0x77, 0x70, 0xDF, 0x90,
  0x37, 0x70, 0xEB, 0x0E, 0x01, 0x77, 0x70, 0x5F, 0x90, 0xA7, 0x60, 0x7C, 0x08, 0x77, 0x72, 0x0D,
  0xF9, 0x02, 0x75, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x20, 0x5F, 0x90, 0xA7, 0x40, 0x7C, 0x08, 0x77,
  0x74, 0x0D, 0xF9, 0x02, 0x73, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x40, 0x5F, 0x90, 0xA7, 0x20, 0x7C,
  0x08, 0x77, 0x76, 0x0D, 0xF9, 0x02, 0x71, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x60, 0x5F, 0x90, 0x97,
  0x06, 0xC0, 0x87, 0x77, 0x71, 0x0D, 0xF9, 0x01, 0x60, 0xDC, 0x01, 0x77, 0x77, 0x10, 0x5F, 0x90,
  0x85, 0x05, 0xC0, 0x87, 0x77, 0x73, 0x0D, 0xF0, 0xE5, 0x0C, 0xC0, 0x17, 0x77, 0x73, 0x05, 0xF9,
  0x06, 0x30, 0x4C, 0x08, 0x77, 0x77, 0x50, 0xDF, 0x0C, 0x30, 0xBC, 0x01, 0x77, 0x77, 0x50, 0x5F,
  0x98, 0x13, 0x02, 0xC0, 0x87, 0x77, 0x77, 0x0D, 0xF8, 0x19, 0x09, 0xC0, 0x17, 0x77, 0x77, 0x05,
  0xF0, 0xE0, 0x1C, 0x08, 0x80, 0xC1, 0x00, 0xDF, 0x0B, 0xC0, 0x18, 0x0C, 0x10, 0x05, 0xFC, 0x08,
  0x80, 0xC3, 0x00, 0xCF, 0xB0, 0x18, 0x0C, 0x30, 0x05, 0xFA, 0x08, 0x80, 0xC5, 0x00, 0xCF, 0x90,
  0x18, 0x0C, 0x50, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8,
  0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C,
  0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60,
  0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A,
  0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0,
  0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0xE8, 0x0C, 0x60, 0x0C, 0xF9, 0x80,
  0xC6, 0x00, 0xEF, 0x90, 0x48, 0x0C, 0x40, 0x05, 0xFA, 0x0A, 0x80, 0xC3, 0x00, 0x30, 0xEF, 0xB0,
  0x77, 0x77, 0x77, 0x81, 0x25, 0xAF, 0xE8, 0x1C, 0x62, 0x77, 0x77, 0x10, 0xAF, 0xFF, 0xB7, 0x77,
  0x50, 0xAF, 0xFF, 0xB7, 0x77, 0x50, 0xAF, 0xFF, 0xB7, 0x77, 0x50, 0xAF, 0xFF, 0xB7, 0x60,
  // "Z" (U+005A)
  0x20, 0x58, 0x0C, 0x0F, 0x0D, 0x40, 0x58, 0x0C, 0x0F, 0x0D, 0x40, 0x58, 0x0C, 0x0F, 0x0D, 0x40,
  0x68, 0x0C, 0x0F, 0x0C, 0x40, 0x6F, 0x90, 0xC0, 0xA8, 0x09, 0x49, 0x0A, 0xFA, 0x07, 0x40, 0x6E,
  0x0A, 0x01, 0x77, 0x40, 0x8F, 0x90, 0xD5, 0x07, 0xD0, 0xB7, 0x75, 0x01, 0x0E, 0xF9, 0x06, 0x50,
  0x7D, 0x02, 0x77, 0x50, 0x8F, 0x90, 0xD6, 0x08, 0xC0, 0xA7, 0x75, 0x01, 0xFA, 0x05, 0x60, 0x8C,
  0x05, 0x77, 0x50, 0x9F, 0x90, 0xC7, 0x08, 0xC0, 0x17, 0x74, 0x02, 0xFA, 0x04, 0x70, 0x9B, 0x0E,
  0x77, 0x50, 0xAF, 0x90, 0xC7, 0x10, 0x9B, 0x0D, 0x77, 0x40, 0x2F, 0xA0, 0x47, 0x10, 0x9B, 0x0B,
  0x77, 0x40, 0xAF, 0x90, 0xB7, 0x20, 0xAB, 0x0A, 0x77, 0x30, 0x3F, 0xA0, 0x37, 0x28, 0x36, 0x99,
  0x95, 0x77, 0x30, 0xBF, 0x90, 0xA7, 0x77, 0x73, 0x04, 0xFA, 0x02, 0x77, 0x77, 0x30, 0xCF, 0x90,
  0xA7, 0x77, 0x73, 0x04, 0xFA, 0x02, 0x77, 0x77, 0x30, 0xCF, 0x90, 0x97, 0x77, 0x73, 0x05, 0xFA,
  0x01, 0x77, 0x77, 0x30, 0xDF, 0x90, 0x87, 0x77, 0x73, 0x06, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x30,
  0xDF, 0x90, 0x77, 0x77, 0x73, 0x07, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0xEF, 0x90, 0x77, 0x77, 0x73,
  0x07, 0xF9, 0x0D, 0x77, 0x77, 0x30, 0x10, 0xEF, 0x90, 0x67, 0x77, 0x73, 0x08, 0xF9, 0x0D, 0x77,
  0x77, 0x30, 0x10, 0xEF, 0x90, 0x57, 0x77, 0x73, 0x09, 0xF9, 0x0C, 0x77, 0x77, 0x30, 0x2F, 0xA0,
  0x47, 0x77, 0x73, 0x09, 0xF9, 0x0C, 0x77, 0x77, 0x30, 0x2F, 0xA0, 0x47, 0x77, 0x73, 0x0A, 0xF9,
  0x0B, 0x77, 0x77, 0x30, 0x3F, 0xA0, 0x37, 0x77, 0x73, 0x0B, 0xF9, 0x0A, 0x77, 0x77, 0x30, 0x3F,
  0xA0, 0x27, 0x77, 0x73, 0x0B, 0xF9, 0x09, 0x77, 0x77, 0x30, 0x4F, 0xA0, 0x27, 0x77, 0x73, 0x0C,
  0xF9, 0x09, 0x77, 0x77, 0x30, 0x5F, 0x90, 0xE0, 0x17, 0x77, 0x73, 0x0D, 0xF9, 0x08, 0x77, 0x77,
  0x30, 0x5F, 0x90, 0xE0, 0x17, 0x77, 0x73, 0x0D, 0xF9, 0x07, 0x77, 0x77, 0x30, 0x6F, 0x90, 0xE7,
  0x77, 0x74, 0x0E, 0xF9, 0x07, 0x77, 0x77, 0x30, 0x7F, 0x90, 0xD7, 0x77, 0x73, 0x01, 0x0E, 0xF9,
  0x06, 0x77, 0x58, 0x41, 0x99, 0x99, 0x16, 0x08, 0xF9, 0x0D, 0x77, 0x60, 0x3C, 0x01, 0x50, 0x10,
  0xEF, 0x90, 0x57, 0x76, 0x04, 0xC0, 0x15, 0x08, 0xF9, 0x0C, 0x77, 0x70, 0x5C, 0x50, 0x1F, 0xA0,
  0x47, 0x77, 0x07, 0xC5, 0x09, 0xF9, 0x0C, 0x77, 0x71, 0x0A, 0xC4, 0x02, 0xFA, 0x04, 0x77, 0x71,
  0x0E, 0xC4, 0x0A, 0xF9, 0x0B, 0x77, 0x71, 0x04, 0xD3, 0x02, 0xFA, 0x03, 0x77, 0x71, 0x0B, 0xD3,
  0x0A, 0xF9, 0x0A, 0x77, 0x71, 0x04, 0xD0, 0xE2, 0x03, 0xFA, 0x02, 0x77, 0x70, 0x60, 0xED, 0x0E,
  0x20, 0xBF, 0x90, 0xE8, 0x0A, 0x09, 0x0B, 0x0E, 0xF8, 0x1E, 0x02, 0x80, 0xC3, 0xF8, 0x1E, 0x03,
  0x80, 0xC3, 0xF8, 0x1D, 0x03, 0x80, 0xC3, 0xF8, 0x1D, 0x03, 0x80, 0xC3, 0xF0, 0xD1,
  // "[" (U+005B)
  0x05, 0xFF, 0xB0, 0x80, 0x5F, 0xFB, 0x08, 0x05, 0xFF, 0xB0, 0x80, 0x5F, 0xFB, 0x08, 0x05, 0xFB,
  0x81, 0xC6, 0x25, 0x05, 0xFA, 0x06, 0x71, 0x05, 0xF9, 0x0A, 0x72, 0x05, 0xF9, 0x04, 0x72, 0x05,
  0xF9, 0x01, 0x72, 0x05, 0xF9, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7,
  0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F,
  0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73,
  0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0,
  0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30,
  0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E,
  0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05,
  0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7,
  0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F,
  0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73,
  0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0,
  0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30,
  0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E,
  0x73, 0x05, 0xF0, 0xE7, 0x30, 0x5F, 0x0E, 0x73, 0x05, 0xF9, 0x73, 0x05, 0xF9, 0x01, 0x72, 0x05,
  0xF9, 0x04, 0x72, 0x05, 0xF9, 0x0A, 0x72, 0x05, 0xFA, 0x06, 0x71, 0x05, 0xFB, 0x81, 0xB6, 0x25,
  0x05, 0xFF, 0xB0, 0x80, 0x5F, 0xFB, 0x08, 0x05, 0xFF, 0xB0, 0x80, 0x5F, 0xFB, 0x08,
  // "\" (U+005C)
  0x0D, 0xB0, 0xC7, 0x73, 0x0A, 0xC7, 0x73, 0x07, 0xC0, 0x37, 0x72, 0x03, 0xC0, 0x77, 0x73, 0xC0,
  0xA7, 0x73, 0x0C, 0xB0, 0xD7, 0x73, 0x08, 0xC0, 0x17, 0x72, 0x05, 0xC0, 0x57, 0x72, 0x01, 0xC0,
  0x87, 0x73, 0x0D, 0xB0, 0xC7, 0x73, 0x0A, 0xC7, 0x73, 0x07, 0xC0, 0x37, 0x72, 0x03, 0xC0, 0x67,
  0x73, 0xC0, 0xA7, 0x73, 0x0C, 0xB0, 0xD7, 0x73, 0x08, 0xC0, 0x17, 0x72, 0x05, 0xC0, 0x57, 0x72,
  0x02, 0xC0, 0x87, 0x73, 0x0E, 0xB0, 0xC7, 0x73, 0x0A, 0xC7, 0x73, 0x07, 0xC0, 0x37, 0x72, 0x03,
  0xC0, 0x67, 0x73, 0xC0, 0xA7, 0x73, 0x0C, 0xB0, 0xD7, 0x73, 0x09, 0xC0, 0x17, 0x72, 0x05, 0xC0,
  0x57, 0x72, 0x02, 0xC0, 0x87, 0x73, 0x0E, 0xB0, 0xB7, 0x73, 0x0A, 0xB0, 0xE7, 0x73, 0x07, 0xC0,
  0x37, 0x72, 0x04, 0xC0, 0x67, 0x73, 0xC0, 0xA7, 0x73, 0x0C, 0xB0, 0xD7, 0x73, 0x09, 0xC0, 0x17,
  0x72, 0x05, 0xC0, 0x47, 0x72, 0x02, 0xC0, 0x87, 0x73, 0x0E, 0xB0, 0xB7, 0x73, 0x0B, 0xB0, 0xE7,
  0x73, 0x07, 0xC0, 0x37, 0x72, 0x04, 0xC0, 0x67, 0x73, 0xC0, 0x97, 0x73, 0x0C, 0xB0, 0xD7, 0x73,
  0x09, 0xC0, 0x17, 0x72, 0x06, 0xC0, 0x47, 0x72, 0x02, 0xC0, 0x87, 0x73, 0x0E, 0xB0, 0xB7, 0x73,
  0x0B, 0xB0, 0xE7, 0x73, 0x07, 0xC0, 0x27, 0x72, 0x04, 0xC0, 0x67, 0x72, 0x01, 0xC0, 0x97, 0x73,
  0x0D, 0xB0, 0xD7, 0x73, 0x09, 0xC0, 0x17, 0x72, 0x06, 0xC0, 0x47, 0x72, 0x02, 0xC0, 0x77, 0x73,
  0x0E, 0xB0, 0xB7, 0x73, 0x0B, 0xB0, 0xE7, 0x73, 0x08, 0xC0, 0x27, 0x72, 0x04, 0xC0, 0x67, 0x72,
  0x01, 0xC0, 0x97, 0x73, 0x0D, 0xB0, 0xC7, 0x73, 0x09, 0xC7, 0x73, 0x06, 0xC0, 0x47, 0x72, 0x03,
  0xC0, 0x77, 0x73, 0x0E, 0xB0, 0xB7, 0x73, 0x0B, 0xB0, 0xE7, 0x73, 0x08, 0xC0, 0x27, 0x72, 0x04,
  0xC0, 0x57, 0x72, 0x01, 0xC0, 0x97, 0x73, 0x0D, 0xB0, 0xC7, 0x73, 0x0A, 0xC7, 0x73, 0x06, 0xC0,
  0x47, 0x72, 0x03, 0xC0, 0x77, 0x73, 0x0E, 0xB0, 0xA7, 0x73, 0x0B, 0xB0, 0xE7, 0x73, 0x08, 0xC0,
  0x27, 0x72, 0x04, 0xC0, 0x57, 0x72, 0x01, 0xC0, 0x97, 0x73, 0x0D, 0xB0, 0xC7, 0x73, 0x0A, 0xC0,
  // "]" (U+005D)
  0x01, 0xFF, 0xB0, 0xA0, 0x1F, 0xFB, 0x0A, 0x01, 0xFF, 0xB0, 0xA0, 0x1F, 0xFB, 0x0A, 0x58, 0x11,
  0x49, 0xFB, 0x0A, 0x71, 0x02, 0x0D, 0xF9, 0x0A, 0x72, 0x04, 0xF9, 0x0A, 0x73, 0x0E, 0xF0, 0xA7,
  0x30, 0xBF, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F,
  0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73,
  0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0,
  0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30,
  0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A,
  0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09,
  0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7,
  0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F,
  0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73,
  0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0,
  0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30,
  0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A,
  0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09,
  0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x09, 0xF0, 0xA7, 0x30, 0x9F, 0x0A, 0x73, 0x0B, 0xF0, 0xA7,
  0x30, 0xEF, 0x0A, 0x72, 0x04, 0xF9, 0x0A, 0x71, 0x02, 0x0D, 0xF9, 0x0A, 0x58, 0x11, 0x49, 0xFB,
  0x0A, 0x01, 0xFF, 0xB0, 0xA0, 0x1F, 0xFB, 0x0A, 0x01, 0xFF, 0xB0, 0xA0, 0x1F, 0xFB, 0x0A,
  // "^" (U+005E)
  0x77, 0x20, 0xBA, 0x06, 0x77, 0x77, 0x30, 0x2B, 0x0D, 0x77, 0x77, 0x30, 0x9C, 0x03, 0x77, 0x77,
  0x20, 0xEC, 0x0A, 0x77, 0x77, 0x10, 0x6E, 0x01, 0x77, 0x77, 0x0C, 0xE0, 0x77, 0x77, 0x60, 0x3F,
  0x0D, 0x77, 0x76, 0x09, 0xF9, 0x04, 0x77, 0x75, 0x0E, 0xB0, 0xEC, 0x0A, 0x77, 0x74, 0x06, 0xC0,
  0x60, 0xCC, 0x01, 0x77, 0x73, 0x0C, 0xC0, 0x10, 0x6C, 0x07, 0x77, 0x72, 0x03, 0xC8, 0x1A, 0x01,
  0xC0, 0xD7, 0x77, 0x20, 0x9C, 0x04, 0x20, 0xAC, 0x05, 0x77, 0x70, 0x10, 0xEB, 0x0D, 0x30, 0x3C,
  0x0B, 0x77, 0x70, 0x6C, 0x07, 0x40, 0xDC, 0x02, 0x77, 0x60, 0xDC, 0x01, 0x40, 0x7C, 0x08, 0x77,
  0x50, 0x3C, 0x0A, 0x50, 0x1C, 0x0E, 0x77, 0x50, 0xAC, 0x04, 0x60, 0xAC, 0x05, 0x77, 0x30, 0x1C,
  0x0E, 0x70, 0x4C, 0x0B, 0x77, 0x30, 0x7C, 0x08, 0x71, 0x0D, 0xC0, 0x27, 0x72, 0x0D, 0xC0, 0x27,
  0x10, 0x7C, 0x08, 0x77, 0x10, 0x4C, 0x0B, 0x72, 0x01, 0xC0, 0xE7, 0x71, 0x0A, 0xC0, 0x57, 0x30,
  0xAC, 0x06, 0x76, 0x01, 0xC0, 0xE7, 0x40, 0x4C, 0x0C, 0x76, 0x07, 0xC0, 0x97, 0x50, 0xDC, 0x03,
  0x75, 0x0D, 0xC0, 0x37, 0x50, 0x8C, 0x09, 0x74, 0x04, 0xC0, 0xC7, 0x60, 0x2C, 0x0E, 0x74, 0x0A,
  0xC0, 0x67, 0x70, 0xBC, 0x06, 0x72, 0x01, 0xC0, 0xE0, 0x17, 0x70, 0x5C, 0x0C, 0x72, 0x08, 0xC0,
  0x97, 0x72, 0x0E, 0xC0, 0x37, 0x10, 0xDC, 0x03, 0x77, 0x20, 0x8C, 0x0A, 0x70, 0x5C, 0x0D, 0x77,
  0x30, 0x2D, 0x01, 0x60, 0xBC, 0x07, 0x77, 0x40, 0xBC, 0x07, 0x50, 0x2D, 0x01, 0x77, 0x40, 0x5C,
  0x0D, 0x50, 0x8C, 0x0A, 0x77, 0x60, 0xEC, 0x04, 0x40, 0xEC, 0x04, 0x77, 0x60, 0x8C, 0x0A, 0x30,
  0x5C, 0x0D, 0x77, 0x70, 0x2D, 0x01, 0x20, 0xBC, 0x08, 0x77, 0x71, 0x0C, 0xC8, 0x17, 0x02, 0xD0,
  0x27, 0x77, 0x10, 0x6C, 0x81, 0xD0, 0x8C, 0x0B, 0x77, 0x73, 0x0E, 0xC0, 0x40,
  // "_" (U+005F)
  0x05, 0xFF, 0xFF, 0xF0, 0x80, 0x5F, 0xFF, 0xFF, 0x08, 0x05, 0xFF, 0xFF, 0xF0, 0x80, 0x5F, 0xFF,
  0xFF, 0x08, 0x05, 0xFF, 0xFF, 0xF0, 0x80,
  // "`" (U+0060)
  0x03, 0x80, 0x47, 0x04, 0x70, 0x5F, 0x90, 0xD7, 0x10, 0xBF, 0x90, 0x57, 0x01, 0x0D, 0xF0, 0xC7,
  0x10, 0x3F, 0x90, 0x47, 0x10, 0x5F, 0x0C, 0x72, 0x07, 0xF0, 0x57, 0x20, 0x8E, 0x0D, 0x73, 0x0A,
  0xE0, 0x67, 0x30, 0xAD, 0x0E, 0x01, 0x73, 0x0A, 0xD0, 0x97, 0x40, 0xAD, 0x03, 0x74, 0x09, 0xC0,
  0xC7, 0x50, 0x7C, 0x06, 0x75, 0x05, 0x0E, 0xA0, 0x90,
  // "a" (U+0061)
  0x74, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x81, 0x17, 0xDF, 0xF0, 0xA0,
  0x37, 0x74, 0x07, 0xFF, 0xD0, 0x97, 0x72, 0x0C, 0xFF, 0xF0, 0xC0, 0x17, 0x60, 0xBF, 0xA8, 0x3D,
  0xA9, 0xAC, 0xFA, 0x0C, 0x75, 0x05, 0xF9, 0x0B, 0x02, 0x50, 0x10, 0x8F, 0x90, 0x87, 0x40, 0xBF,
  0x0B, 0x72, 0x05, 0xF0, 0xE0, 0x17, 0x30, 0xEF, 0x01, 0x73, 0x0B, 0xF0, 0x77, 0x3F, 0x0B, 0x74,
  0x05, 0xF0, 0xC7, 0x3F, 0x07, 0x74, 0x01, 0xF9, 0x73, 0x0B, 0xE0, 0x37, 0x50, 0xDF, 0x03, 0x72,
  0x05, 0xE0, 0x17, 0x50, 0xBF, 0x06, 0x73, 0x07, 0xD7, 0x60, 0x9F, 0x07, 0x74, 0x81, 0x39, 0xDA,
  0x76, 0x08, 0xF0, 0x87, 0x71, 0x01, 0x76, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77,
  0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71,
  0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x71, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xF9, 0x09,
  0x75, 0x81, 0x16, 0xCF, 0xFF, 0x90, 0x97, 0x40, 0x70, 0xEF, 0xFF, 0xB0, 0x97, 0x20, 0x10, 0xCF,
  0xFF, 0xD0, 0x97, 0x10, 0x10, 0xDF, 0xA8, 0x3D, 0x85, 0x21, 0x50, 0x5F, 0x09, 0x71, 0x0C, 0xF9,
  0x0D, 0x04, 0x73, 0x05, 0xF0, 0x97, 0x06, 0xF9, 0x0C, 0x01, 0x74, 0x05, 0xF0, 0x97, 0x0E, 0xF0,
  0xE0, 0x17, 0x50, 0x5F, 0x09, 0x60, 0x5F, 0x90, 0x67, 0x60, 0x5F, 0x09, 0x60, 0x9F, 0x0E, 0x77,
  0x05, 0xF0, 0x96, 0x0D, 0xF0, 0x97, 0x70, 0x5F, 0x09, 0x6F, 0x90, 0x67, 0x70, 0x6F, 0x09, 0x50,
  0x2F, 0x90, 0x37, 0x70, 0x7F, 0x09, 0x50, 0x3F, 0x90, 0x27, 0x70, 0x8F, 0x09, 0x50, 0x3F, 0x90,
  0x17, 0x70, 0xAF, 0x09, 0x50, 0x2F, 0x90, 0x17, 0x70, 0xDF, 0x09, 0x50, 0x1F, 0x90, 0x17, 0x60,
  0x1F, 0x90, 0x96, 0xF9, 0x03, 0x76, 0x07, 0xF9, 0x09, 0x60, 0xDF, 0x05, 0x76, 0x0D, 0xF9, 0x0A,
  0x60, 0xAF, 0x09, 0x75, 0x07, 0xFA, 0x0B, 0x60, 0x6F, 0x0E, 0x74, 0x83, 0x2E, 0xF6, 0xAE, 0x0D,
  0x60, 0x1F, 0x90, 0x67, 0x28, 0x41, 0xDF, 0xB0, 0x7F, 0x01, 0x60, 0xAF, 0x0E, 0x03, 0x78, 0x54,
  0xDF, 0xE1, 0x05, 0xF0, 0x96, 0x03, 0xFA, 0x08, 0x02, 0x28, 0x12, 0x5B, 0xB0, 0x52, 0x03, 0xF9,
  0x0A, 0x03, 0x50, 0x7F, 0xFB, 0x09, 0x4F, 0xC0, 0x94, 0x0A, 0xFF, 0x90, 0xA5, 0x0D, 0xFB, 0x09,
  0x50, 0x8F, 0xE0, 0xA6, 0x0B, 0xFB, 0x09, 0x60, 0x40, 0xCF, 0xA0, 0xE0, 0x67, 0x08, 0xFB, 0x09,
  0x71, 0x89, 0x04, 0x8C, 0xEF, 0xED, 0xA6, 0x17, 0x76,
  // "b" (U+0062)
  0x0A, 0xFF, 0x03, 0x77, 0x76, 0x0A, 0xFF, 0x03, 0x77, 0x76, 0x0A, 0xFF, 0x03, 0x77, 0x76, 0x0A,
  0xFF, 0x03, 0x77, 0x77, 0x18, 0x11, 0x5A, 0xFB, 0x03, 0x77, 0x77, 0x40, 0x30, 0xEF, 0x90, 0x37,
  0x77, 0x75, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x1F, 0x90, 0x37, 0x77, 0x76, 0x0E, 0xF0, 0x37,
  0x77, 0x76, 0x0D, 0xF0, 0x37, 0x77, 0x76, 0x0C, 0xF0, 0x37, 0x77, 0x76, 0x0C, 0xF0, 0x37, 0x77,
  0x76, 0x0C, 0xF0, 0x37, 0x77, 0x76, 0x0C, 0xF0, 0x37, 0x77, 0x76, 0x0C, 0xF0, 0x37, 0x77, 0x76,
  0x0C, 0xF0, 0x37, 0x77, 0x76, 0x0C, 0xF0, 0x37, 0x77, 0x76, 0x0C, 0xF0, 0x37, 0x77, 0x76, 0x0C,
  0xF0, 0x27, 0x77, 0x76, 0x0C, 0xF0, 0x26, 0x89, 0x12, 0x7B, 0xDE, 0xFE, 0xC9, 0x51, 0x77, 0x30,
  0xCF, 0x02, 0x40, 0x10, 0xAF, 0xB8, 0x1E, 0x91, 0x77, 0x10, 0xCF, 0x02, 0x30, 0x40, 0xEF, 0xE0,
  0xE0, 0x47, 0x70, 0xCF, 0x01, 0x20, 0x4F, 0xFB, 0x06, 0x76, 0x0C, 0xF8, 0x21, 0x02, 0xEB, 0x84,
  0xEB, 0x99, 0xBE, 0xFA, 0x05, 0x75, 0x0C, 0xF8, 0x11, 0x0C, 0xA0, 0xC0, 0x46, 0x05, 0x0D, 0xF0,
  0xE0, 0x27, 0x40, 0xCF, 0x10, 0x7A, 0x09, 0x72, 0x01, 0x0C, 0xF0, 0xC7, 0x40, 0xCF, 0x82, 0x1E,
  0xFA, 0x74, 0x01, 0x0E, 0xF0, 0x57, 0x30, 0xCF, 0x82, 0x6F, 0xE1, 0x75, 0x06, 0xF0, 0xC7, 0x30,
  0xCF, 0x81, 0xEF, 0x77, 0x70, 0xDF, 0x03, 0x72, 0x0C, 0xFA, 0x01, 0x77, 0x07, 0xF0, 0x97, 0x20,
  0xCF, 0x90, 0xB7, 0x71, 0x02, 0xF0, 0xE7, 0x20, 0xCF, 0x90, 0x67, 0x72, 0x0D, 0xF0, 0x27, 0x10,
  0xCF, 0x90, 0x37, 0x72, 0x0A, 0xF0, 0x67, 0x10, 0xCF, 0x97, 0x73, 0x07, 0xF0, 0x97, 0x10, 0xCF,
  0x0D, 0x77, 0x30, 0x4F, 0x0C, 0x71, 0x0C, 0xF0, 0xA7, 0x73, 0x02, 0xF0, 0xE7, 0x10, 0xCF, 0x08,
  0x77, 0x30, 0x1F, 0x97, 0x10, 0xCF, 0x07, 0x77, 0x4F, 0x90, 0x27, 0x0C, 0xF0, 0x67, 0x74, 0x0D,
  0xF0, 0x47, 0x0C, 0xF0, 0x57, 0x74, 0x0C, 0xF0, 0x57, 0x0C, 0xF0, 0x47, 0x74, 0x0C, 0xF0, 0x67,
  0x0C, 0xF0, 0x37, 0x74, 0x0B, 0xF0, 0x67, 0x0C, 0xF0, 0x37, 0x74, 0x0B, 0xF0, 0x67, 0x0C, 0xF0,
  0x37, 0x74, 0x0B, 0xF0, 0x77, 0x0C, 0xF0, 0x37, 0x74, 0x0B, 0xF0, 0x77, 0x0C, 0xF0, 0x37, 0x74,
  0x0B, 0xF0, 0x67, 0x0C, 0xF0, 0x37, 0x74, 0x0B, 0xF0, 0x67, 0x0C, 0xF0, 0x47, 0x74, 0x0C, 0xF0,
  0x57, 0x0C, 0xF0, 0x57, 0x74, 0x0D, 0xF0, 0x47, 0x0C, 0xF0, 0x67, 0x74, 0x0E, 0xF0, 0x37, 0x0C,
  0xF0, 0x77, 0x74, 0xF9, 0x02, 0x70, 0xCF, 0x09, 0x77, 0x30, 0x1F, 0x97, 0x10, 0xCF, 0x0B, 0x77,
  0x30, 0x3F, 0x0E, 0x71, 0x0C, 0xF0, 0xD7, 0x73, 0x05, 0xF0, 0xB7, 0x10, 0xCF, 0x97, 0x73, 0x08,
  0xF0, 0x87, 0x10, 0xCF, 0x90, 0x47, 0x72, 0x0B, 0xF0, 0x57, 0x10, 0xCF, 0x90, 0x77, 0x72, 0x0E,
  0xF0, 0x17, 0x10, 0xCF, 0x90, 0xC7, 0x71, 0x04, 0xF0, 0xD7, 0x20, 0xDF, 0xA0, 0x17, 0x70, 0x9F,
  0x08, 0x72, 0x0E, 0xFA, 0x08, 0x77, 0x0E, 0xF0, 0x27, 0x10, 0x2F, 0xB0, 0xE0, 0x17, 0x50, 0x7F,
  0x0B, 0x72, 0x08, 0xF0, 0xD0, 0xEA, 0x0B, 0x74, 0x02, 0x0E, 0xF0, 0x37, 0x10, 0x40, 0xEF, 0x05,
  0x06, 0xB0, 0xA7, 0x20, 0x10, 0xDF, 0x0A, 0x68, 0x11, 0x5A, 0xFA, 0x81, 0x10, 0xCB, 0x0D, 0x05,
  0x60, 0x50, 0xDF, 0x0D, 0x01, 0x40, 0xAF, 0xD0, 0xD2, 0x01, 0x0E, 0xC8, 0x4E, 0xB9, 0x9A, 0xEF,
  0x90, 0xE0, 0x35, 0x0A, 0xFD, 0x09, 0x30, 0x30, 0xEF, 0xFA, 0x0E, 0x04, 0x60, 0xAF, 0xD0, 0x64,
  0x02, 0x0D, 0xFF, 0x0C, 0x02, 0x70, 0xAF, 0xD0, 0x26, 0x08, 0x0E, 0xFB, 0x0D, 0x07, 0x77, 0x77,
  0x38, 0x25, 0x9C, 0xEA, 0x82, 0xEC, 0x94, 0x74,
  // "c" (U+0063)
  0x75, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x73, 0x81, 0x19, 0xEF, 0xD8, 0x1D, 0x81,
  0x76, 0x08, 0xFF, 0xB0, 0xE0, 0x77, 0x30, 0x20, 0xCF, 0xFE, 0x0B, 0x71, 0x01, 0x0D, 0xF9, 0x83,
  0xEA, 0x9A, 0xDF, 0xA0, 0xA7, 0x0D, 0xF0, 0xC0, 0x45, 0x04, 0x0D, 0xF9, 0x05, 0x50, 0x9F, 0x0A,
  0x71, 0x01, 0x0E, 0xF0, 0xB4, 0x03, 0xF0, 0xB7, 0x30, 0x7F, 0x90, 0x13, 0x0B, 0xF0, 0x27, 0x30,
  0x1F, 0x90, 0x22, 0x04, 0xF0, 0x97, 0x50, 0xBF, 0x03, 0x20, 0xAF, 0x02, 0x75, 0x08, 0xF8, 0x12,
  0x01, 0xF0, 0xD7, 0x60, 0x5E, 0x0E, 0x20, 0x5F, 0x08, 0x76, 0x03, 0xE0, 0x82, 0x0A, 0xF0, 0x57,
  0x60, 0x2D, 0x0A, 0x30, 0xDF, 0x02, 0x76, 0x84, 0x1E, 0xDB, 0x83, 0x30, 0x1F, 0x0E, 0x77, 0x72,
  0x03, 0xF0, 0xC7, 0x77, 0x20, 0x6F, 0x0A, 0x77, 0x72, 0x08, 0xF0, 0x97, 0x77, 0x20, 0x9F, 0x08,
  0x77, 0x72, 0x0A, 0xF0, 0x77, 0x77, 0x20, 0xBF, 0x06, 0x77, 0x72, 0x0C, 0xF0, 0x57, 0x77, 0x20,
  0xDF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x05, 0x77, 0x72, 0x0C, 0xF0, 0x57,
  0x77, 0x20, 0xCF, 0x05, 0x77, 0x72, 0x0B, 0xF0, 0x67, 0x77, 0x20, 0xAF, 0x07, 0x77, 0x72, 0x09,
  0xF0, 0x87, 0x77, 0x20, 0x7F, 0x09, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x3F, 0x0D, 0x77,
  0x73, 0xF9, 0x77, 0x73, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0x9F, 0x07, 0x77, 0x72, 0x04, 0xF0, 0xC7,
  0x77, 0x30, 0xEF, 0x02, 0x77, 0x40, 0x20, 0x13, 0x09, 0xF0, 0x87, 0x74, 0x0B, 0x0A, 0x30, 0x2F,
  0x0E, 0x01, 0x77, 0x20, 0x7A, 0x02, 0x30, 0xAF, 0x09, 0x77, 0x10, 0x4B, 0x03, 0x30, 0x20, 0xEF,
  0x06, 0x76, 0x04, 0x0E, 0xB0, 0x24, 0x06, 0xF9, 0x07, 0x74, 0x07, 0xC0, 0xE6, 0x0A, 0xF9, 0x0B,
  0x04, 0x70, 0x60, 0xCD, 0x07, 0x70, 0xBF, 0xA8, 0x4E, 0xB9, 0x9A, 0xCF, 0x0C, 0x72, 0x09, 0xFF,
  0xE0, 0xD0, 0x17, 0x30, 0x50, 0xDF, 0xFB, 0x0A, 0x01, 0x76, 0x06, 0x0D, 0xFE, 0x0B, 0x03, 0x77,
  0x38, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  // "d" (U+0064)
  0x77, 0x60, 0x6F, 0xF0, 0x67, 0x77, 0x60, 0x6F, 0xF0, 0x67, 0x77, 0x60, 0x6F, 0xF0, 0x67, 0x77,
  0x60, 0x6F, 0xF0, 0x67, 0x77, 0x71, 0x82, 0x14, 0x8E, 0xFA, 0x06, 0x77, 0x77, 0x40, 0x10, 0xCF,
  0x90, 0x67, 0x77, 0x75, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x60, 0xCF, 0x06, 0x77, 0x77, 0x60, 0x9F,
  0x06, 0x77, 0x77, 0x60, 0x8F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06,
  0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77,
  0x77, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x77,
  0x60, 0x7F, 0x06, 0x77, 0x38, 0x91, 0x16, 0xAC, 0xEF, 0xED, 0xB8, 0x36, 0x07, 0xF0, 0x67, 0x71,
  0x02, 0x0A, 0xFC, 0x0C, 0x03, 0x40, 0x7F, 0x06, 0x77, 0x07, 0xFF, 0x90, 0x73, 0x07, 0xF0, 0x67,
  0x60, 0xAF, 0xFB, 0x08, 0x20, 0x6F, 0x06, 0x75, 0x0A, 0xFA, 0x83, 0xCA, 0x9A, 0xCD, 0x81, 0x60,
  0x6F, 0x06, 0x74, 0x07, 0xF9, 0x0B, 0x02, 0x50, 0x10, 0x8C, 0x02, 0x05, 0xF0, 0x67, 0x30, 0x3F,
  0x90, 0x87, 0x20, 0x30, 0xDA, 0x0C, 0x04, 0xF0, 0x67, 0x30, 0xBF, 0x0A, 0x74, 0x02, 0x0E, 0xA0,
  0xBF, 0x06, 0x72, 0x03, 0xF0, 0xE0, 0x17, 0x50, 0x6F, 0xB0, 0x67, 0x20, 0xAF, 0x08, 0x77, 0x0D,
  0xFA, 0x06, 0x72, 0xF9, 0x02, 0x77, 0x07, 0xFA, 0x06, 0x71, 0x05, 0xF0, 0xD7, 0x71, 0x02, 0xFA,
  0x06, 0x71, 0x09, 0xF0, 0x87, 0x72, 0x0D, 0xF9, 0x06, 0x71, 0x0D, 0xF0, 0x57, 0x72, 0x09, 0xF9,
  0x06, 0x70, 0x1F, 0x90, 0x27, 0x72, 0x05, 0xF9, 0x06, 0x70, 0x3F, 0x97, 0x73, 0x03, 0xF9, 0x06,
  0x70, 0x6F, 0x0C, 0x77, 0x4F, 0x90, 0x67, 0x08, 0xF0, 0xB7, 0x74, 0x0E, 0xF0, 0x67, 0x0A, 0xF0,
  0x97, 0x74, 0x0C, 0xF0, 0x67, 0x0B, 0xF0, 0x87, 0x74, 0x0B, 0xF0, 0x67, 0x0C, 0xF0, 0x77, 0x74,
  0x09, 0xF0, 0x67, 0x0D, 0xF0, 0x67, 0x74, 0x09, 0xF0, 0x67, 0x0E, 0xF0, 0x57, 0x74, 0x08, 0xF0,
  0x67, 0x0E, 0xF0, 0x57, 0x74, 0x08, 0xF0, 0x67, 0x0E, 0xF0, 0x57, 0x74, 0x07, 0xF0, 0x67, 0x0E,
  0xF0, 0x57, 0x74, 0x07, 0xF0, 0x67, 0x0E, 0xF0, 0x57, 0x74, 0x08, 0xF0, 0x67, 0x0E, 0xF0, 0x57,
  0x74, 0x08, 0xF0, 0x67, 0x0D, 0xF0, 0x67, 0x74, 0x09, 0xF0, 0x67, 0x0C, 0xF0, 0x67, 0x74, 0x09,
  0xF0, 0x67, 0x0B, 0xF0, 0x77, 0x74, 0x0B, 0xF0, 0x67, 0x0A, 0xF0, 0x87, 0x74, 0x0C, 0xF0, 0x67,
  0x08, 0xF0, 0xA7, 0x74, 0x0E, 0xF0, 0x67, 0x06, 0xF0, 0xC7, 0x73, 0x01, 0xF9, 0x06, 0x70, 0x4F,
  0x0E, 0x77, 0x30, 0x3F, 0x90, 0x67, 0x01, 0xF9, 0x01, 0x77, 0x20, 0x6F, 0x90, 0x67, 0x10, 0xDF,
  0x04, 0x77, 0x20, 0xAF, 0x90, 0x67, 0x10, 0xAF, 0x07, 0x77, 0x20, 0xEF, 0x90, 0x67, 0x10, 0x6F,
  0x0C, 0x77, 0x10, 0x3F, 0xA0, 0x67, 0x10, 0x1F, 0x90, 0x17, 0x70, 0x9F, 0xA0, 0x77, 0x20, 0xBF,
  0x07, 0x76, 0x01, 0x0E, 0xFA, 0x08, 0x72, 0x04, 0xF0, 0xE7, 0x60, 0x8A, 0x0B, 0xF0, 0xB7, 0x30,
  0xCF, 0x09, 0x74, 0x04, 0xA0, 0xE0, 0x1F, 0x90, 0x17, 0x20, 0x4F, 0x90, 0x77, 0x20, 0x40, 0xEA,
  0x81, 0x70, 0xDF, 0x0B, 0x73, 0x09, 0xF9, 0x0A, 0x02, 0x50, 0x20, 0x9B, 0x0C, 0x20, 0xCF, 0x98,
  0x1D, 0x73, 0x71, 0x0C, 0xFA, 0x83, 0xCA, 0x9A, 0xCC, 0x0E, 0x02, 0x20, 0xAF, 0xE0, 0x45, 0x01,
  0x0C, 0xFF, 0xA0, 0xE0, 0x33, 0x08, 0xFE, 0x04, 0x70, 0x9F, 0xF0, 0xE0, 0x34, 0x06, 0xFE, 0x04,
  0x71, 0x03, 0x0B, 0xFC, 0x0A, 0x01, 0x50, 0x4F, 0xE0, 0x47, 0x38, 0x91, 0x27, 0xAD, 0xEF, 0xED,
  0xA7, 0x17, 0x77, 0x10,
  // "e" (U+0065)
  0x75, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x84, 0x77, 0x68, 0x11, 0x8E, 0xFC, 0x0E, 0x07, 0x77,
  0x30, 0x60, 0xEF, 0xF9, 0x0E, 0x04, 0x77, 0x0A, 0xFF, 0xD0, 0x87, 0x50, 0xBF, 0x98, 0x3D, 0xA9,
  0xAD, 0xF9, 0x08, 0x73, 0x09, 0xF0, 0xD0, 0x45, 0x03, 0x0C, 0xF0, 0x67, 0x10, 0x6F, 0x0B, 0x72,
  0x0B, 0xF0, 0x26, 0x01, 0x0E, 0xE0, 0xC7, 0x30, 0x10, 0xEE, 0x0C, 0x60, 0x9F, 0x03, 0x74, 0x06,
  0xF0, 0x54, 0x01, 0xF0, 0xA7, 0x6F, 0x0C, 0x40, 0x8F, 0x04, 0x76, 0x0A, 0xF0, 0x23, 0x0D, 0xE0,
  0xD7, 0x70, 0x5F, 0x07, 0x20, 0x3F, 0x09, 0x77, 0x02, 0xF0, 0xC2, 0x07, 0xF0, 0x57, 0x71, 0x0E,
  0xF2, 0x0B, 0xF0, 0x17, 0x71, 0x0B, 0xF8, 0x14, 0x0E, 0xE0, 0xE7, 0x72, 0x09, 0xF0, 0x60, 0x2F,
  0x0C, 0x77, 0x20, 0x8F, 0x08, 0x05, 0xF0, 0xA7, 0x72, 0x06, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x20,
  0x5F, 0x0B, 0x09, 0xF0, 0x87, 0x72, 0x05, 0xF0, 0xC0, 0xAF, 0x07, 0x77, 0x20, 0x4F, 0x0D, 0x0B,
  0xFF, 0xFF, 0xC0, 0xD0, 0xCF, 0xFF, 0xFC, 0x0D, 0x0C, 0xFF, 0xFF, 0xC0, 0x0D, 0xFF, 0xFF, 0xC0,
  0x0D, 0xF0, 0xB8, 0x0A, 0x49, 0x08, 0x0C, 0xF0, 0x57, 0x77, 0x40, 0xCF, 0x05, 0x77, 0x74, 0x0B,
  0xF0, 0x67, 0x77, 0x40, 0xAF, 0x07, 0x77, 0x74, 0x09, 0xF0, 0x87, 0x77, 0x40, 0x7F, 0x0A, 0x77,
  0x74, 0x05, 0xF0, 0xC7, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0E, 0xF0, 0x27, 0x77, 0x40, 0xBF,
  0x05, 0x77, 0x74, 0x07, 0xF0, 0x97, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0C, 0xF0, 0x57, 0x75,
  0x04, 0x01, 0x40, 0x6F, 0x0B, 0x77, 0x48, 0x11, 0xEC, 0x50, 0xDF, 0x04, 0x77, 0x30, 0xBA, 0x03,
  0x40, 0x6F, 0x0D, 0x01, 0x77, 0x10, 0x9B, 0x05, 0x50, 0xCF, 0x0B, 0x77, 0x09, 0xC0, 0x25, 0x02,
  0x0E, 0xF0, 0xC0, 0x17, 0x30, 0x10, 0xBC, 0x0C, 0x70, 0x5F, 0x98, 0x1E, 0x81, 0x68, 0x12, 0x8E,
  0xD0, 0x37, 0x10, 0x6F, 0xB8, 0x4D, 0xA9, 0x9B, 0xDF, 0x07, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0x77,
  0x50, 0x20, 0xBF, 0xFB, 0x0D, 0x04, 0x77, 0x10, 0x50, 0xBF, 0xE0, 0xD0, 0x67, 0x75, 0x83, 0x26,
  0x9C, 0xEA, 0x84, 0xEE, 0xCA, 0x73, 0x72,
  // "f" (U+0066)
  0x77, 0x38, 0x90, 0x25, 0x78, 0x98, 0x76, 0x41, 0x77, 0x58, 0x11, 0x7D, 0xFB, 0x0C, 0x06, 0x77,
  0x20, 0x70, 0xEF, 0xF0, 0xC0, 0x17, 0x60, 0xBF, 0xFB, 0x0D, 0x75, 0x0B, 0xFF, 0xD0, 0x87, 0x30,
  0x8F, 0x84, 0xA3, 0x01, 0x4B, 0xF0, 0xD7, 0x20, 0x3F, 0x07, 0x60, 0xCF, 0x72, 0x0C, 0xE0, 0xC7,
  0x04, 0xF7, 0x10, 0x3F, 0x05, 0x71, 0x0E, 0xD0, 0xD7, 0x10, 0x9F, 0x01, 0x71, 0x0A, 0xD0, 0x77,
  0x10, 0xEE, 0x0C, 0x72, 0x08, 0xC0, 0xB7, 0x10, 0x1F, 0x09, 0x72, 0x06, 0xA0, 0xD0, 0x77, 0x20,
  0x4F, 0x07, 0x72, 0x81, 0x13, 0x17, 0x40, 0x7F, 0x06, 0x77, 0x72, 0x08, 0xF0, 0x57, 0x77, 0x20,
  0x9F, 0x04, 0x77, 0x72, 0x0A, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47,
  0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x20, 0xBF,
  0xFF, 0xC0, 0x15, 0x0B, 0xFF, 0xFC, 0x01, 0x50, 0xBF, 0xFF, 0xC0, 0x15, 0x0B, 0xFF, 0xFC, 0x01,
  0x50, 0x68, 0x02, 0x90, 0xDF, 0x0B, 0x80, 0x69, 0x76, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04,
  0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20,
  0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47,
  0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B,
  0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77,
  0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF,
  0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77,
  0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0,
  0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72,
  0x0B, 0xF0, 0x47, 0x77, 0x20, 0xBF, 0x04, 0x77, 0x72, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0xCF, 0x05,
  0x77, 0x72, 0x0D, 0xF0, 0x67, 0x77, 0x10, 0x1F, 0x90, 0x97, 0x77, 0x10, 0x7F, 0x90, 0xE7, 0x77,
  0x03, 0x0E, 0xFA, 0x09, 0x77, 0x38, 0x11, 0x5A, 0xFD, 0x81, 0xD7, 0x27, 0x5F, 0xFF, 0xB0, 0x57,
  0xFF, 0xFB, 0x05, 0x7F, 0xFF, 0xB0, 0x57, 0xFF, 0xFB, 0x05, 0x70,
  // "g" (U+0067)
  0x77, 0x77, 0x48, 0x43, 0xAD, 0xFD, 0x87, 0x77, 0x75, 0x09, 0xE0, 0xB7, 0x78, 0x91, 0x58, 0xBD,
  0xEF, 0xED, 0xB7, 0x35, 0x01, 0x0C, 0xF9, 0x05, 0x73, 0x02, 0x09, 0xFD, 0x0C, 0x05, 0x20, 0x10,
  0xCF, 0xA0, 0x97, 0x20, 0x7F, 0xFA, 0x81, 0xB1, 0xCF, 0xB0, 0xB7, 0x10, 0xAF, 0xFF, 0xFA, 0x0A,
  0x70, 0x9F, 0x85, 0x94, 0x10, 0x14, 0xAF, 0x98, 0x3C, 0x40, 0x18, 0xC0, 0x76, 0x04, 0xE0, 0xE0,
  0x47, 0x04, 0x0E, 0xD0, 0xE5, 0x0D, 0xA0, 0xE7, 0x0D, 0xE0, 0x57, 0x20, 0x5E, 0x08, 0x48, 0x27,
  0xFE, 0x46, 0x07, 0xE0, 0xB7, 0x40, 0xCE, 0x02, 0x30, 0x20, 0x47, 0x10, 0xDE, 0x05, 0x74, 0x06,
  0xE0, 0x97, 0x50, 0x4F, 0x75, 0x01, 0xF0, 0x17, 0x40, 0x7E, 0x0C, 0x76, 0x0D, 0xE0, 0x67, 0x40,
  0xBE, 0x09, 0x76, 0x0B, 0xE0, 0xA7, 0x40, 0xEE, 0x07, 0x76, 0x09, 0xE0, 0xD7, 0x4F, 0x06, 0x76,
  0x08, 0xE0, 0xE7, 0x30, 0x1F, 0x05, 0x76, 0x07, 0xF7, 0x30, 0x2F, 0x05, 0x76, 0x07, 0xF0, 0x17,
  0x20, 0x3F, 0x05, 0x76, 0x07, 0xF0, 0x17, 0x20, 0x2F, 0x06, 0x76, 0x08, 0xF7, 0x30, 0x1F, 0x06,
  0x76, 0x08, 0xE0, 0xE7, 0x40, 0xEE, 0x08, 0x76, 0x0A, 0xE0, 0xD7, 0x40, 0xBE, 0x0B, 0x76, 0x0C,
  0xE0, 0x97, 0x40, 0x7E, 0x0E, 0x76, 0xF0, 0x67, 0x40, 0x2F, 0x03, 0x74, 0x04, 0xF0, 0x17, 0x50,
  0xBE, 0x0A, 0x74, 0x0A, 0xE0, 0xA7, 0x60, 0x4F, 0x03, 0x72, 0x03, 0xF0, 0x47, 0x70, 0xAE, 0x0E,
  0x03, 0x70, 0x20, 0xDE, 0x0A, 0x77, 0x10, 0x10, 0xDF, 0x85, 0x94, 0x10, 0x13, 0x8F, 0x0E, 0x01,
  0x77, 0x20, 0x20, 0xEF, 0xFE, 0x04, 0x77, 0x40, 0x10, 0xCF, 0xFC, 0x05, 0x77, 0x70, 0x7F, 0xF9,
  0x0C, 0x02, 0x77, 0x70, 0x10, 0xBF, 0xE0, 0xA0, 0x47, 0x77, 0x10, 0x30, 0xEB, 0x89, 0x09, 0x14,
  0x78, 0x98, 0x76, 0x37, 0x77, 0x30, 0x30, 0xEB, 0x09, 0x77, 0x77, 0x50, 0x10, 0xEB, 0x0D, 0x77,
  0x77, 0x60, 0x9C, 0x06, 0x77, 0x77, 0x50, 0x1D, 0x02, 0x77, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x77,
  0x50, 0x6D, 0x03, 0x77, 0x77, 0x50, 0x6D, 0x0B, 0x77, 0x77, 0x50, 0x4E, 0x81, 0xC5, 0x27, 0x77,
  0x73, 0x0E, 0xFF, 0xC8, 0x3E, 0xDB, 0x94, 0x77, 0x20, 0x7F, 0xFF, 0xA0, 0xE0, 0x77, 0x71, 0x09,
  0xFF, 0xFB, 0x0D, 0x02, 0x77, 0x07, 0xFF, 0xFB, 0x0E, 0x03, 0x77, 0x06, 0xFF, 0xFB, 0x0D, 0x01,
  0x73, 0x81, 0x17, 0xEF, 0xFF, 0xD0, 0xA7, 0x20, 0x50, 0xEF, 0xFF, 0xF9, 0x02, 0x70, 0x8E, 0x82,
  0xC7, 0x31, 0x72, 0x82, 0x13, 0x7C, 0xF9, 0x08, 0x60, 0x9D, 0x0E, 0x05, 0x77, 0x30, 0x6F, 0x0D,
  0x50, 0x7D, 0x0E, 0x03, 0x77, 0x50, 0x7F, 0x02, 0x30, 0x1E, 0x06, 0x77, 0x70, 0xEE, 0x04, 0x30,
  0x8D, 0x0D, 0x77, 0x71, 0x0A, 0xE0, 0x63, 0x0D, 0xD0, 0x87, 0x77, 0x10, 0x6E, 0x07, 0x20, 0x2E,
  0x05, 0x77, 0x71, 0x05, 0xE0, 0x72, 0x04, 0xE0, 0x37, 0x77, 0x10, 0x5E, 0x07, 0x20, 0x6E, 0x03,
  0x77, 0x71, 0x05, 0xE0, 0x52, 0x06, 0xE0, 0x37, 0x77, 0x10, 0x7E, 0x03, 0x20, 0x6E, 0x04, 0x77,
  0x71, 0x0A, 0xE3, 0x04, 0xE0, 0x77, 0x77, 0x10, 0xED, 0x0C, 0x30, 0x3E, 0x0B, 0x77, 0x70, 0x5E,
  0x07, 0x40, 0xEE, 0x01, 0x77, 0x60, 0xDD, 0x0E, 0x01, 0x40, 0xAE, 0x09, 0x77, 0x50, 0x9E, 0x08,
  0x50, 0x5F, 0x04, 0x77, 0x30, 0x9E, 0x0D, 0x70, 0xCF, 0x04, 0x77, 0x03, 0x0C, 0xF0, 0x37, 0x03,
  0xF9, 0x0B, 0x04, 0x72, 0x81, 0x26, 0xBF, 0x90, 0x57, 0x20, 0x5F, 0xB8, 0x6C, 0xA9, 0x9A, 0xAC,
  0xEF, 0xB0, 0x57, 0x40, 0x5F, 0xFF, 0xC0, 0xD0, 0x37, 0x60, 0x30, 0xCF, 0xFF, 0x0D, 0x06, 0x77,
  0x30, 0x40, 0xBF, 0xFA, 0x81, 0xEA, 0x57, 0x77, 0x84, 0x15, 0x8A, 0xCE, 0xB8, 0x5E, 0xEC, 0xB9,
  0x63, 0x77, 0x10,
  // "h" (U+0068)
  0x0A, 0xFF, 0x03, 0x77, 0x77, 0x30, 0xAF, 0xF0, 0x37, 0x77, 0x73, 0x0A, 0xFF, 0x03, 0x77, 0x77,
  0x30, 0xAF, 0xF0, 0x37, 0x77, 0x75, 0x81, 0x15, 0xAF, 0xB0, 0x38, 0x0C, 0x00, 0x04, 0x0E, 0xF9,
  0x03, 0x80, 0xC1, 0x00, 0x7F, 0x90, 0x38, 0x0C, 0x10, 0x01, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0xEF,
  0x03, 0x80, 0xC2, 0x00, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03,
  0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80,
  0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2,
  0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x68, 0x90, 0x27, 0xBD, 0xEF, 0xEC, 0x95, 0x77,
  0x71, 0x0C, 0xF0, 0x34, 0x01, 0x0A, 0xFB, 0x0E, 0x07, 0x77, 0x60, 0xCF, 0x02, 0x30, 0x40, 0xEF,
  0xE0, 0xD0, 0x27, 0x74, 0x0C, 0xF0, 0x22, 0x04, 0xFF, 0xA0, 0xE0, 0x27, 0x73, 0x0C, 0xF8, 0x21,
  0x02, 0xEF, 0xFB, 0x0D, 0x77, 0x30, 0xCF, 0x20, 0xCF, 0xFD, 0x08, 0x77, 0x20, 0xCF, 0x10, 0x7B,
  0x81, 0xC5, 0x22, 0x81, 0x25, 0xAF, 0xB0, 0x17, 0x71, 0x0C, 0xE8, 0x1E, 0x1E, 0xA0, 0x57, 0x10,
  0x40, 0xEF, 0x90, 0x87, 0x71, 0x0C, 0xE0, 0xD0, 0x8A, 0x04, 0x73, 0x04, 0xF9, 0x0D, 0x77, 0x10,
  0xCF, 0xA0, 0x87, 0x50, 0x9F, 0x90, 0x27, 0x70, 0xCF, 0x90, 0xE7, 0x60, 0x2F, 0x90, 0x67, 0x70,
  0xCF, 0x90, 0x87, 0x70, 0xCF, 0x09, 0x77, 0x0C, 0xF9, 0x03, 0x77, 0x08, 0xF0, 0xB7, 0x70, 0xCF,
  0x0E, 0x77, 0x10, 0x5F, 0x0D, 0x77, 0x0C, 0xF0, 0xB7, 0x71, 0x03, 0xF0, 0xE7, 0x70, 0xCF, 0x08,
  0x77, 0x10, 0x1F, 0x97, 0x70, 0xCF, 0x06, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x05, 0x77, 0x2F, 0x97,
  0x70, 0xCF, 0x04, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77,
  0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF,
  0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97,
  0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77,
  0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF,
  0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97,
  0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77,
  0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xDF,
  0x03, 0x77, 0x2F, 0x90, 0x17, 0x60, 0xEF, 0x04, 0x77, 0x2F, 0x90, 0x27, 0x50, 0x2F, 0x90, 0x77,
  0x72, 0xF9, 0x05, 0x75, 0x08, 0xF9, 0x0C, 0x77, 0x2F, 0x90, 0xA7, 0x40, 0x40, 0xEF, 0xA0, 0x67,
  0x71, 0xFA, 0x04, 0x78, 0x11, 0x5A, 0xFD, 0x81, 0xB5, 0x27, 0x5F, 0xB8, 0x1A, 0x41, 0x20, 0xAF,
  0xFE, 0x07, 0x73, 0xFF, 0x01, 0x0A, 0xFF, 0xE0, 0x77, 0x3F, 0xF0, 0x10, 0xAF, 0xFE, 0x07, 0x73,
  0xFF, 0x01, 0x0A, 0xFF, 0xE0, 0x77, 0x3F, 0xF0, 0x10,
  // "i" (U+0069)
  0x71, 0x85, 0x19, 0xDF, 0xD9, 0x17, 0x71, 0x02, 0x0E, 0xD0, 0xE0, 0x27, 0x70, 0xAF, 0x0B, 0x77,
  0x0E, 0xF9, 0x01, 0x75, 0x01, 0xFA, 0x03, 0x75, 0x02, 0xFA, 0x04, 0x75, 0x01, 0xFA, 0x03, 0x76,
  0x0E, 0xF9, 0x01, 0x76, 0x0A, 0xF0, 0xB7, 0x70, 0x20, 0xED, 0x0E, 0x02, 0x77, 0x18, 0x51, 0x9D,
  0xFD, 0x91, 0x80, 0xBA, 0x40, 0x0B, 0xFE, 0x0C, 0x71, 0x0B, 0xFE, 0x0C, 0x71, 0x0B, 0xFE, 0x0C,
  0x71, 0x0B, 0xFE, 0x0C, 0x73, 0x81, 0x15, 0xBF, 0xA0, 0xC7, 0x60, 0x6F, 0x90, 0xC7, 0x70, 0xCF,
  0x0C, 0x77, 0x07, 0xF0, 0xC7, 0x70, 0x4F, 0x0C, 0x77, 0x03, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77,
  0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0,
  0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70,
  0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C,
  0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02,
  0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7,
  0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xD7, 0x70, 0x3F,
  0x0D, 0x77, 0x04, 0xF0, 0xE7, 0x70, 0x7F, 0x90, 0x27, 0x60, 0xCF, 0x90, 0x87, 0x50, 0x6F, 0xA0,
  0xE0, 0x37, 0x18, 0x12, 0x5B, 0xFD, 0x81, 0xA4, 0x12, 0x04, 0xFF, 0xF0, 0xE0, 0x4F, 0xFF, 0x0E,
  0x04, 0xFF, 0xF0, 0xE0, 0x4F, 0xFF, 0x0E,
  // "j" (U+006A)
  0x73, 0x85, 0x2A, 0xEF, 0xD8, 0x17, 0x40, 0x4E, 0x0D, 0x01, 0x73, 0x0D, 0xF0, 0x97, 0x20, 0x3F,
  0x90, 0xE7, 0x20, 0x5F, 0xA0, 0x17, 0x10, 0x6F, 0xA0, 0x27, 0x10, 0x5F, 0xA0, 0x17, 0x10, 0x3F,
  0x90, 0xE7, 0x30, 0xDF, 0x09, 0x73, 0x04, 0xE0, 0xD0, 0x17, 0x48, 0x53, 0xAE, 0xFD, 0x81, 0x80,
  0xAD, 0x40, 0x0D, 0xFE, 0x0A, 0x40, 0xDF, 0xE0, 0xA4, 0x0D, 0xFE, 0x0A, 0x40, 0xDF, 0xE0, 0xA6,
  0x81, 0x26, 0xCF, 0xA0, 0xA7, 0x20, 0x8F, 0x90, 0xA7, 0x30, 0xDF, 0x0A, 0x73, 0x08, 0xF0, 0xA7,
  0x30, 0x5F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F,
  0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73,
  0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0,
  0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30,
  0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A,
  0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04,
  0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7,
  0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F,
  0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73, 0x04, 0xF0, 0xA7, 0x30, 0x4F, 0x0A, 0x73,
  0x04, 0xF0, 0x97, 0x30, 0x4F, 0x09, 0x73, 0x05, 0xF0, 0x87, 0x30, 0x6F, 0x07, 0x73, 0x07, 0xF0,
  0x57, 0x30, 0x9F, 0x03, 0x73, 0x0B, 0xF0, 0x17, 0x30, 0xEE, 0x0E, 0x73, 0x03, 0xF0, 0xA7, 0x30,
  0x7F, 0x06, 0x73, 0x0D, 0xF0, 0x17, 0x20, 0x5F, 0x0B, 0x73, 0x0D, 0xF0, 0x47, 0x20, 0xBF, 0x0B,
  0x71, 0x05, 0x0D, 0xF0, 0xE0, 0x24, 0x82, 0x59, 0xBE, 0xFA, 0x05, 0x50, 0x8F, 0xC0, 0x56, 0x08,
  0xFA, 0x0D, 0x03, 0x70, 0x8F, 0x0C, 0x06, 0x72, 0x86, 0x8F, 0xEE, 0xCA, 0x62, 0x74,
  // "k" (U+006B)
  0x0A, 0xFF, 0x03, 0x77, 0x77, 0x10, 0xAF, 0xF0, 0x37, 0x77, 0x71, 0x0A, 0xFF, 0x03, 0x77, 0x77,
  0x10, 0xAF, 0xF0, 0x37, 0x77, 0x73, 0x81, 0x15, 0xAF, 0xB0, 0x37, 0x77, 0x76, 0x04, 0x0E, 0xF9,
  0x03, 0x77, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x77, 0x77, 0x01, 0xF9, 0x03, 0x80, 0xC0, 0x00, 0xEF,
  0x03, 0x80, 0xC0, 0x00, 0xDF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03,
  0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80,
  0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0,
  0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x71, 0x02, 0xFF,
  0xA0, 0xE7, 0x30, 0xCF, 0x03, 0x71, 0x02, 0xFF, 0xA0, 0xE7, 0x30, 0xCF, 0x03, 0x71, 0x02, 0xFF,
  0xA0, 0xE7, 0x30, 0xCF, 0x03, 0x71, 0x02, 0xFF, 0xA0, 0xE7, 0x30, 0xCF, 0x03, 0x73, 0x02, 0x07,
  0xFB, 0x81, 0xE7, 0x27, 0x40, 0xCF, 0x03, 0x75, 0x08, 0xF9, 0x09, 0x77, 0x0C, 0xF0, 0x37, 0x50,
  0x7F, 0x06, 0x77, 0x10, 0xCF, 0x03, 0x75, 0x0A, 0xE0, 0x57, 0x72, 0x0C, 0xF0, 0x37, 0x40, 0x1E,
  0x06, 0x77, 0x30, 0xCF, 0x03, 0x74, 0x07, 0xD0, 0x77, 0x74, 0x0C, 0xF0, 0x37, 0x30, 0x10, 0xEC,
  0x0A, 0x77, 0x50, 0xCF, 0x03, 0x73, 0x0B, 0xC0, 0xC7, 0x76, 0x0C, 0xF0, 0x37, 0x20, 0x7C, 0x0E,
  0x02, 0x77, 0x60, 0xCF, 0x03, 0x71, 0x03, 0xD0, 0x57, 0x77, 0x0C, 0xF0, 0x37, 0x01, 0x0E, 0xC0,
  0x97, 0x77, 0x10, 0xCF, 0x03, 0x70, 0xBC, 0x0C, 0x77, 0x72, 0x0C, 0xF0, 0x26, 0x08, 0xC0, 0xE0,
  0x27, 0x77, 0x20, 0xCF, 0x02, 0x50, 0x4D, 0x05, 0x77, 0x73, 0x0C, 0xF0, 0x24, 0x02, 0x0E, 0xC0,
  0x97, 0x77, 0x40, 0xCF, 0x01, 0x40, 0xCD, 0x04, 0x77, 0x74, 0x0C, 0xF0, 0x13, 0x09, 0xE0, 0xC7,
  0x77, 0x40, 0xCF, 0x01, 0x20, 0x5F, 0x90, 0x67, 0x77, 0x30, 0xCF, 0x20, 0x2F, 0xA0, 0xE0, 0x17,
  0x77, 0x20, 0xCF, 0x20, 0xDF, 0xB0, 0x87, 0x77, 0x20, 0xCE, 0x81, 0xE0, 0xAF, 0xD0, 0x27, 0x77,
  0x10, 0xCE, 0x0D, 0x07, 0xB0, 0xC0, 0x3F, 0x90, 0xB7, 0x77, 0x10, 0xCE, 0x0E, 0xB8, 0x2D, 0x10,
  0x9F, 0x90, 0x47, 0x77, 0x0C, 0xFA, 0x0E, 0x02, 0x20, 0x10, 0xEF, 0x0D, 0x77, 0x70, 0xCF, 0x90,
  0xE0, 0x34, 0x08, 0xF9, 0x06, 0x77, 0x60, 0xCF, 0x90, 0x45, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x75,
  0x0C, 0xF0, 0x67, 0x07, 0xF9, 0x09, 0x77, 0x50, 0xCF, 0x03, 0x71, 0x0D, 0xF9, 0x02, 0x77, 0x40,
  0xCF, 0x03, 0x71, 0x06, 0xF9, 0x0B, 0x77, 0x40, 0xCF, 0x03, 0x72, 0x0D, 0xF9, 0x05, 0x77, 0x30,
  0xCF, 0x03, 0x72, 0x05, 0xF9, 0x0D, 0x77, 0x30, 0xCF, 0x03, 0x73, 0x0C, 0xF9, 0x07, 0x77, 0x20,
  0xCF, 0x03, 0x73, 0x04, 0xF9, 0x0E, 0x01, 0x77, 0x10, 0xCF, 0x03, 0x74, 0x0B, 0xF9, 0x0A, 0x77,
  0x10, 0xDF, 0x03, 0x74, 0x03, 0xFA, 0x04, 0x77, 0x0E, 0xF0, 0x47, 0x50, 0xAF, 0x90, 0xE0, 0x17,
  0x50, 0x2F, 0x90, 0x77, 0x50, 0x2F, 0xA0, 0xB7, 0x50, 0x8F, 0x90, 0xC7, 0x60, 0x8F, 0xA0, 0x87,
  0x30, 0x40, 0xEF, 0xA0, 0x77, 0x60, 0xDF, 0xA0, 0x86, 0x81, 0x15, 0xAF, 0xD8, 0x2D, 0x73, 0x17,
  0x20, 0x3F, 0xB8, 0x3C, 0x51, 0x0A, 0xFF, 0xE0, 0xA7, 0x20, 0x5F, 0xD0, 0xB0, 0xAF, 0xFE, 0x0A,
  0x73, 0x06, 0xFC, 0x0B, 0x0A, 0xFF, 0xE0, 0xA7, 0x40, 0x30, 0xCF, 0xA0, 0xB0, 0xAF, 0xFE, 0x0A,
  0x76, 0x84, 0x37, 0xAC, 0xDE, 0xB0, 0xB0,
  // "l" (U+006C)
  0x0E, 0xFF, 0x03, 0x70, 0xEF, 0xF0, 0x37, 0x0E, 0xFF, 0x03, 0x70, 0xEF, 0xF0, 0x37, 0x28, 0x11,
  0x5A, 0xFB, 0x03, 0x75, 0x04, 0x0E, 0xF9, 0x03, 0x76, 0x07, 0xF9, 0x03, 0x76, 0x01, 0xF9, 0x03,
  0x77, 0x0E, 0xF0, 0x37, 0x70, 0xDF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C,
  0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37,
  0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF,
  0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77,
  0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0,
  0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70,
  0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03,
  0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C,
  0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37,
  0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF,
  0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77,
  0x0D, 0xF0, 0x47, 0x70, 0xEF, 0x05, 0x76, 0x02, 0xF9, 0x08, 0x76, 0x07, 0xF9, 0x0D, 0x75, 0x03,
  0x0E, 0xFA, 0x08, 0x71, 0x81, 0x14, 0x9F, 0xD8, 0x1C, 0x62, 0x30, 0xEF, 0xFF, 0x04, 0x0E, 0xFF,
  0xF0, 0x40, 0xEF, 0xFF, 0x04, 0x0E, 0xFF, 0xF0, 0x40,
  // "m" (U+006D)
  0x77, 0x71, 0x87, 0x59, 0xCE, 0xFE, 0xDA, 0x57, 0x78, 0x90, 0x16, 0xAD, 0xEF, 0xEC, 0xA5, 0x77,
  0x03, 0xFD, 0x08, 0x60, 0x70, 0xEF, 0xA0, 0xE0, 0x77, 0x30, 0x20, 0xAF, 0xB0, 0xE0, 0x77, 0x50,
  0x3F, 0xD0, 0xA4, 0x01, 0x0B, 0xFE, 0x0C, 0x01, 0x70, 0x50, 0xEF, 0xE0, 0xC0, 0x17, 0x30, 0x3F,
  0xD0, 0xC4, 0x0C, 0xFF, 0x90, 0xD6, 0x05, 0xFF, 0xA0, 0xD0, 0x17, 0x20, 0x3F, 0xD0, 0xE3, 0x09,
  0xFF, 0xB0, 0xA4, 0x03, 0xFF, 0xC0, 0xC7, 0x48, 0x11, 0x5A, 0xFA, 0x81, 0x10, 0x4F, 0xFD, 0x04,
  0x30, 0xCF, 0xFD, 0x07, 0x76, 0x06, 0xF9, 0x81, 0x30, 0xCB, 0x86, 0x94, 0x10, 0x13, 0x8E, 0xF9,
  0x0B, 0x20, 0x6B, 0x86, 0xE8, 0x31, 0x01, 0x49, 0xFA, 0x0E, 0x01, 0x76, 0x0B, 0xF0, 0x50, 0x4A,
  0x0D, 0x03, 0x70, 0x20, 0xCF, 0x98, 0x13, 0x0E, 0xA0, 0xC0, 0x17, 0x03, 0x0E, 0xF9, 0x07, 0x76,
  0x07, 0xF8, 0x37, 0xBF, 0xE2, 0x72, 0x02, 0x0E, 0xF0, 0x80, 0x5A, 0x0D, 0x01, 0x72, 0x03, 0xF9,
  0x0C, 0x76, 0x04, 0xF0, 0xEA, 0x05, 0x74, 0x07, 0xF0, 0xE0, 0xDA, 0x03, 0x74, 0x09, 0xF9, 0x01,
  0x75, 0x03, 0xFA, 0x0C, 0x75, 0x01, 0x0E, 0xFA, 0x09, 0x75, 0x02, 0xF9, 0x05, 0x75, 0x02, 0xFA,
  0x05, 0x76, 0x0A, 0xFA, 0x03, 0x76, 0x0D, 0xF0, 0x87, 0x50, 0x2F, 0x90, 0xE7, 0x70, 0x6F, 0x90,
  0xD7, 0x70, 0x9F, 0x0A, 0x75, 0x02, 0xF9, 0x0B, 0x77, 0x03, 0xF9, 0x0A, 0x77, 0x06, 0xF0, 0xC7,
  0x50, 0x2F, 0x90, 0x87, 0x70, 0x1F, 0x90, 0x77, 0x70, 0x4F, 0x0D, 0x75, 0x02, 0xF9, 0x05, 0x77,
  0x1F, 0x90, 0x47, 0x70, 0x2F, 0x0E, 0x75, 0x02, 0xF9, 0x02, 0x77, 0x10, 0xEF, 0x03, 0x77, 0x01,
  0xF0, 0xE7, 0x50, 0x2F, 0x90, 0x17, 0x71, 0x0E, 0xF0, 0x27, 0x70, 0x1F, 0x97, 0x50, 0x2F, 0x97,
  0x72, 0x0D, 0xF0, 0x17, 0x71, 0xF9, 0x75, 0x02, 0xF9, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50,
  0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F,
  0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF,
  0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77,
  0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F,
  0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97,
  0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77,
  0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20,
  0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E,
  0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50,
  0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F,
  0x97, 0x50, 0x2F, 0x0E, 0x77, 0x20, 0xDF, 0x77, 0x2F, 0x97, 0x50, 0x3F, 0x0E, 0x77, 0x20, 0xDF,
  0x01, 0x77, 0x1F, 0x97, 0x50, 0x4F, 0x97, 0x72, 0x0D, 0xF0, 0x27, 0x71, 0xF9, 0x01, 0x74, 0x07,
  0xF9, 0x02, 0x77, 0x10, 0xDF, 0x05, 0x77, 0x1F, 0x90, 0x47, 0x40, 0xCF, 0x90, 0x77, 0x71, 0x0D,
  0xF0, 0xA7, 0x71, 0xF9, 0x09, 0x73, 0x06, 0xFA, 0x0E, 0x03, 0x77, 0x0D, 0xF9, 0x04, 0x77, 0xFA,
  0x04, 0x68, 0x11, 0x4A, 0xFD, 0x81, 0x94, 0x17, 0x40, 0xDF, 0xA8, 0x1A, 0x41, 0x74, 0xFB, 0x81,
  0x94, 0x11, 0xFF, 0xF0, 0x37, 0x20, 0xDF, 0xE0, 0x17, 0x2F, 0xFF, 0xFF, 0x03, 0x72, 0x0D, 0xFE,
  0x01, 0x72, 0xFF, 0xFF, 0xF0, 0x37, 0x20, 0xDF, 0xE0, 0x17, 0x2F, 0xFF, 0xFF, 0x03, 0x72, 0x0D,
  0xFE, 0x01, 0x72, 0xFF,
  // "n" (U+006E)
  0x77, 0x71, 0x82, 0x49, 0xCE, 0xA8, 0x2E, 0xB8, 0x37, 0x70, 0x8F, 0xD0, 0x96, 0x06, 0x0D, 0xFB,
  0x0C, 0x04, 0x75, 0x08, 0xFD, 0x0B, 0x50, 0xBF, 0xF0, 0x87, 0x40, 0x8F, 0xD0, 0xD4, 0x0C, 0xFF,
  0xA0, 0xA7, 0x30, 0x8F, 0xE3, 0x09, 0xFF, 0xC0, 0x77, 0x48, 0x12, 0x5C, 0xFA, 0x81, 0x10, 0x4F,
  0xFE, 0x02, 0x76, 0x07, 0xF9, 0x81, 0x30, 0xDB, 0x86, 0xA5, 0x10, 0x12, 0x6C, 0xFA, 0x0B, 0x77,
  0x0C, 0xF0, 0x05, 0xA0, 0xD0, 0x37, 0x10, 0x7F, 0xA0, 0x27, 0x60, 0x7F, 0x83, 0x7C, 0xFE, 0x27,
  0x30, 0x9F, 0x90, 0x77, 0x60, 0x4F, 0x0E, 0xA0, 0x47, 0x50, 0xEF, 0x0C, 0x76, 0x03, 0xFA, 0x0A,
  0x76, 0x08, 0xF9, 0x76, 0x02, 0xFA, 0x03, 0x76, 0x02, 0xF9, 0x03, 0x75, 0x02, 0xF9, 0x0D, 0x77,
  0x10, 0xEF, 0x05, 0x75, 0x02, 0xF9, 0x09, 0x77, 0x10, 0xBF, 0x07, 0x75, 0x02, 0xF9, 0x06, 0x77,
  0x10, 0x9F, 0x08, 0x75, 0x02, 0xF9, 0x03, 0x77, 0x10, 0x7F, 0x09, 0x75, 0x02, 0xF9, 0x01, 0x77,
  0x10, 0x6F, 0x0A, 0x75, 0x02, 0xF9, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xE7, 0x72, 0x05,
  0xF0, 0xA7, 0x50, 0x2F, 0x0D, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0,
  0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7,
  0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50,
  0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F,
  0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C,
  0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C, 0x77,
  0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20,
  0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F,
  0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A,
  0x75, 0x03, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x3F, 0x0D, 0x77, 0x20, 0x5F, 0x0B, 0x75,
  0x04, 0xF0, 0xE7, 0x72, 0x05, 0xF0, 0xC7, 0x50, 0x7F, 0x90, 0x17, 0x71, 0x05, 0xF0, 0xE7, 0x50,
  0xDF, 0x90, 0x57, 0x71, 0x05, 0xF9, 0x04, 0x73, 0x08, 0xFA, 0x0D, 0x02, 0x77, 0x05, 0xF9, 0x0C,
  0x78, 0x12, 0x6C, 0xFC, 0x82, 0xE8, 0x31, 0x74, 0x05, 0xFA, 0x81, 0xD7, 0x22, 0xFF, 0xF0, 0x37,
  0x20, 0x5F, 0xE0, 0xAF, 0xFF, 0x03, 0x72, 0x05, 0xFE, 0x0A, 0xFF, 0xF0, 0x37, 0x20, 0x5F, 0xE0,
  0xAF, 0xFF, 0x03, 0x72, 0x05, 0xFE, 0x0A,
  // "o" (U+006F)
  0x75, 0x89, 0x32, 0x69, 0xCD, 0xEF, 0xED, 0xB9, 0x51, 0x77, 0x71, 0x06, 0x0C, 0xFE, 0x0A, 0x03,
  0x77, 0x40, 0x50, 0xDF, 0xFB, 0x0A, 0x01, 0x77, 0x10, 0x9F, 0xFE, 0x0E, 0x03, 0x76, 0x0B, 0xFA,
  0x83, 0xCA, 0x9A, 0xCF, 0xA0, 0x57, 0x40, 0xAF, 0x0E, 0x06, 0x68, 0x11, 0x8E, 0xF0, 0x37, 0x20,
  0x7F, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xE0, 0xE0, 0x17, 0x02, 0xF0, 0xD7, 0x50, 0x20, 0xEE, 0x0B,
  0x70, 0xAF, 0x03, 0x76, 0x06, 0xF0, 0x55, 0x02, 0xF0, 0xA7, 0x71, 0x0D, 0xE0, 0xD5, 0x09, 0xF0,
  0x47, 0x71, 0x07, 0xF0, 0x44, 0x0E, 0xE0, 0xE7, 0x72, 0x01, 0xF0, 0xA3, 0x04, 0xF0, 0x97, 0x73,
  0x0C, 0xF3, 0x09, 0xF0, 0x57, 0x73, 0x08, 0xF0, 0x52, 0x0C, 0xF0, 0x27, 0x73, 0x05, 0xF0, 0x92,
  0xF9, 0x77, 0x40, 0x2F, 0x81, 0xC0, 0x3F, 0x0C, 0x77, 0x5F, 0x91, 0x05, 0xF0, 0xA7, 0x75, 0x0D,
  0xF0, 0x20, 0x7F, 0x09, 0x77, 0x50, 0xCF, 0x04, 0x09, 0xF0, 0x87, 0x75, 0x0B, 0xF0, 0x60, 0xAF,
  0x07, 0x77, 0x50, 0x9F, 0x07, 0x0B, 0xF0, 0x67, 0x75, 0x09, 0xF0, 0x90, 0xCF, 0x05, 0x77, 0x50,
  0x8F, 0x09, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x50, 0x8F, 0x0A, 0x0D,
  0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xCF, 0x05, 0x77, 0x50, 0x8F, 0x0A, 0x0C, 0xF0, 0x57, 0x75,
  0x08, 0xF0, 0x90, 0xBF, 0x06, 0x77, 0x50, 0x9F, 0x08, 0x0A, 0xF0, 0x77, 0x75, 0x0A, 0xF0, 0x70,
  0x9F, 0x08, 0x77, 0x50, 0xBF, 0x06, 0x07, 0xF0, 0x97, 0x75, 0x0C, 0xF0, 0x40, 0x5F, 0x0B, 0x77,
  0x50, 0xEF, 0x00, 0x2F, 0x0D, 0x77, 0x5F, 0x92, 0x0E, 0xF7, 0x74, 0x03, 0xF0, 0xC2, 0x0B, 0xF0,
  0x37, 0x73, 0x05, 0xF0, 0x92, 0x07, 0xF0, 0x67, 0x73, 0x09, 0xF0, 0x52, 0x02, 0xF0, 0xA7, 0x73,
  0x0D, 0xF0, 0x13, 0x0D, 0xE0, 0xE7, 0x72, 0x02, 0xF0, 0xB4, 0x07, 0xF0, 0x57, 0x71, 0x07, 0xF0,
  0x54, 0x01, 0x0E, 0xE0, 0xC7, 0x71, 0x0D, 0xE0, 0xE6, 0x07, 0xF0, 0x57, 0x60, 0x7F, 0x06, 0x70,
  0xDE, 0x0E, 0x01, 0x74, 0x02, 0x0E, 0xE0, 0xC7, 0x10, 0x3F, 0x0D, 0x02, 0x72, 0x03, 0x0D, 0xF0,
  0x37, 0x20, 0x6F, 0x81, 0xE7, 0x15, 0x01, 0x08, 0xF9, 0x06, 0x74, 0x07, 0xFA, 0x83, 0xCA, 0x9A,
  0xCF, 0xA0, 0x77, 0x60, 0x50, 0xEF, 0xFE, 0x06, 0x77, 0x10, 0x20, 0xBF, 0xFB, 0x0C, 0x02, 0x77,
  0x40, 0x40, 0xBF, 0xE0, 0xB0, 0x47, 0x77, 0x18, 0x31, 0x69, 0xCE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  0x50,
  // "p" (U+0070)
  0x77, 0x71, 0x89, 0x04, 0x8C, 0xEF, 0xEE, 0xB9, 0x47, 0x40, 0xEF, 0xD0, 0xD6, 0x04, 0x0D, 0xFB,
  0x0E, 0x07, 0x72, 0x0E, 0xFE, 0x50, 0x8F, 0xF0, 0xD0, 0x37, 0x0E, 0xFE, 0x02, 0x30, 0x9F, 0xFB,
  0x05, 0x60, 0xEF, 0xE0, 0x32, 0x07, 0xC8, 0x4E, 0xB9, 0x9B, 0xEF, 0xA0, 0x47, 0x81, 0x14, 0xAF,
  0xA8, 0x15, 0x03, 0xB0, 0xC0, 0x46, 0x06, 0x0E, 0xF0, 0xE0, 0x27, 0x20, 0x30, 0xEF, 0x81, 0x70,
  0xCA, 0x08, 0x72, 0x01, 0x0D, 0xF0, 0xB7, 0x30, 0x8F, 0x09, 0x06, 0xA0, 0x97, 0x40, 0x20, 0xEF,
  0x04, 0x72, 0x02, 0xF8, 0x2C, 0xDF, 0xD7, 0x60, 0x7F, 0x0C, 0x73, 0xFB, 0x06, 0x77, 0x0E, 0xF0,
  0x37, 0x20, 0xEF, 0xA0, 0x17, 0x70, 0x9F, 0x08, 0x72, 0x0E, 0xF9, 0x0B, 0x77, 0x10, 0x4F, 0x0D,
  0x72, 0x0E, 0xF9, 0x06, 0x77, 0x2F, 0x90, 0x27, 0x10, 0xEF, 0x90, 0x37, 0x72, 0x0B, 0xF0, 0x67,
  0x10, 0xEF, 0x97, 0x73, 0x08, 0xF0, 0x97, 0x10, 0xEF, 0x0C, 0x77, 0x30, 0x6F, 0x0C, 0x71, 0x0E,
  0xF0, 0xA7, 0x73, 0x04, 0xF0, 0xE7, 0x10, 0xEF, 0x08, 0x77, 0x30, 0x2F, 0x97, 0x10, 0xEF, 0x07,
  0x77, 0x4F, 0x90, 0x27, 0x0E, 0xF0, 0x57, 0x74, 0xF9, 0x03, 0x70, 0xEF, 0x04, 0x77, 0x40, 0xEF,
  0x05, 0x70, 0xEF, 0x04, 0x77, 0x40, 0xDF, 0x05, 0x70, 0xEF, 0x03, 0x77, 0x40, 0xDF, 0x06, 0x70,
  0xEF, 0x03, 0x77, 0x40, 0xCF, 0x06, 0x70, 0xEF, 0x03, 0x77, 0x40, 0xCF, 0x07, 0x70, 0xEF, 0x03,
  0x77, 0x40, 0xCF, 0x07, 0x70, 0xEF, 0x03, 0x77, 0x40, 0xDF, 0x06, 0x70, 0xEF, 0x03, 0x77, 0x40,
  0xDF, 0x06, 0x70, 0xEF, 0x04, 0x77, 0x40, 0xEF, 0x05, 0x70, 0xEF, 0x05, 0x77, 0x40, 0xEF, 0x04,
  0x70, 0xEF, 0x06, 0x77, 0x4F, 0x90, 0x37, 0x0E, 0xF0, 0x77, 0x73, 0x01, 0xF9, 0x02, 0x70, 0xEF,
  0x09, 0x77, 0x30, 0x3F, 0x97, 0x10, 0xEF, 0x0B, 0x77, 0x30, 0x5F, 0x0E, 0x71, 0x0E, 0xF0, 0xD7,
  0x73, 0x07, 0xF0, 0xB7, 0x10, 0xEF, 0x97, 0x73, 0x0A, 0xF0, 0x87, 0x10, 0xEF, 0x90, 0x37, 0x72,
  0x0D, 0xF0, 0x57, 0x10, 0xEF, 0x90, 0x77, 0x71, 0x01, 0xF9, 0x01, 0x71, 0x0E, 0xF9, 0x0B, 0x77,
  0x10, 0x6F, 0x0D, 0x72, 0x0E, 0xFA, 0x01, 0x77, 0x0B, 0xF0, 0x87, 0x20, 0xEF, 0xA0, 0x77, 0x60,
  0x1F, 0x90, 0x27, 0x20, 0xEF, 0xA0, 0xE0, 0x17, 0x50, 0x9F, 0x0B, 0x73, 0x0E, 0xF0, 0xCA, 0x0A,
  0x74, 0x03, 0xF9, 0x03, 0x73, 0x0E, 0xF0, 0x3B, 0x09, 0x72, 0x02, 0x0D, 0xF0, 0xA7, 0x40, 0xEF,
  0x10, 0x9B, 0x0C, 0x04, 0x60, 0x60, 0xEF, 0x0E, 0x01, 0x74, 0x0E, 0xF8, 0x11, 0x0C, 0xC8, 0x4E,
  0xB9, 0x9B, 0xEF, 0x90, 0xE0, 0x37, 0x50, 0xEF, 0x82, 0x10, 0x1D, 0xFF, 0xA0, 0xE0, 0x47, 0x60,
  0xEF, 0x02, 0x20, 0x10, 0xCF, 0xF0, 0xC0, 0x27, 0x70, 0xEF, 0x02, 0x40, 0x70, 0xEF, 0xB0, 0xD0,
  0x67, 0x72, 0x0E, 0xF0, 0x26, 0x89, 0x05, 0x9D, 0xEF, 0xED, 0xB8, 0x47, 0x74, 0x0E, 0xF0, 0x27,
  0x77, 0x76, 0x0E, 0xF0, 0x37, 0x77, 0x76, 0x0E, 0xF0, 0x37, 0x77, 0x76, 0x0E, 0xF0, 0x37, 0x77,
  0x76, 0x0E, 0xF0, 0x37, 0x77, 0x76, 0x0E, 0xF0, 0x37, 0x77, 0x76, 0x0E, 0xF0, 0x37, 0x77, 0x76,
  0x0E, 0xF0, 0x37, 0x77, 0x76, 0x0E, 0xF0, 0x37, 0x77, 0x76, 0x0E, 0xF0, 0x37, 0x77, 0x76, 0x0E,
  0xF0, 0x37, 0x77, 0x76, 0xF9, 0x04, 0x77, 0x77, 0x50, 0x3F, 0x90, 0x77, 0x77, 0x75, 0x09, 0xF9,
  0x0B, 0x77, 0x77, 0x40, 0x5F, 0xB0, 0x77, 0x77, 0x78, 0x12, 0x5B, 0xFD, 0x82, 0xC6, 0x31, 0x77,
  0x71, 0x0A, 0xFF, 0xF0, 0x67, 0x76, 0x0A, 0xFF, 0xF0, 0x67, 0x76, 0x0A, 0xFF, 0xF0, 0x67, 0x76,
  0x0A, 0xFF, 0xF0, 0x67, 0x76,
  // "q" (U+0071)
  0x73, 0x83, 0x15, 0x9C, 0xEA, 0x82, 0xDB, 0x83, 0x77, 0x77, 0x20, 0x20, 0x9F, 0xC0, 0xD0, 0x46,
  0x09, 0xFD, 0x04, 0x70, 0x7F, 0xF9, 0x09, 0x50, 0xDF, 0xD0, 0x46, 0x0A, 0xFF, 0xB0, 0xB3, 0x01,
  0xFE, 0x04, 0x50, 0xAF, 0xA8, 0x3C, 0xA9, 0xAC, 0xD0, 0xA2, 0x04, 0xFE, 0x04, 0x40, 0x7F, 0x90,
  0xA0, 0x25, 0x01, 0x08, 0xC8, 0x17, 0x08, 0xF9, 0x82, 0xE8, 0x31, 0x50, 0x2F, 0x90, 0x77, 0x20,
  0x30, 0xDB, 0x02, 0x0B, 0xF0, 0xC0, 0x17, 0x10, 0xBF, 0x09, 0x74, 0x02, 0x0E, 0xA0, 0xC0, 0xEF,
  0x02, 0x71, 0x03, 0xF0, 0xE7, 0x60, 0x6F, 0xB0, 0xB7, 0x20, 0xAF, 0x07, 0x77, 0x0D, 0xFA, 0x08,
  0x72, 0x0E, 0xF0, 0x17, 0x70, 0x7F, 0xA0, 0x77, 0x10, 0x5F, 0x0C, 0x77, 0x10, 0x2F, 0xA0, 0x67,
  0x10, 0x9F, 0x07, 0x77, 0x20, 0xDF, 0x90, 0x67, 0x10, 0xDF, 0x04, 0x77, 0x20, 0x9F, 0x90, 0x67,
  0x1F, 0x90, 0x17, 0x72, 0x05, 0xF9, 0x06, 0x70, 0x3F, 0x0E, 0x77, 0x30, 0x3F, 0x90, 0x67, 0x06,
  0xF0, 0xC7, 0x74, 0xF9, 0x06, 0x70, 0x8F, 0x0A, 0x77, 0x40, 0xEF, 0x06, 0x70, 0x9F, 0x09, 0x77,
  0x40, 0xCF, 0x06, 0x70, 0xBF, 0x08, 0x77, 0x40, 0xBF, 0x06, 0x70, 0xCF, 0x07, 0x77, 0x40, 0x9F,
  0x06, 0x70, 0xDF, 0x06, 0x77, 0x40, 0x9F, 0x06, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x8F, 0x06, 0x70,
  0xEF, 0x05, 0x77, 0x40, 0x8F, 0x06, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x7F, 0x06, 0x70, 0xEF, 0x05,
  0x77, 0x40, 0x7F, 0x06, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x8F, 0x06, 0x70, 0xEF, 0x05, 0x77, 0x40,
  0x8F, 0x06, 0x70, 0xDF, 0x06, 0x77, 0x40, 0x9F, 0x06, 0x70, 0xCF, 0x06, 0x77, 0x40, 0x9F, 0x06,
  0x70, 0xBF, 0x07, 0x77, 0x40, 0xAF, 0x06, 0x70, 0xAF, 0x08, 0x77, 0x40, 0xCF, 0x06, 0x70, 0x8F,
  0x0A, 0x77, 0x40, 0xDF, 0x06, 0x70, 0x6F, 0x0C, 0x77, 0x4F, 0x90, 0x67, 0x04, 0xF0, 0xE7, 0x73,
  0x02, 0xF9, 0x06, 0x70, 0x1F, 0x90, 0x17, 0x72, 0x05, 0xF9, 0x06, 0x71, 0x0D, 0xF0, 0x47, 0x72,
  0x08, 0xF9, 0x06, 0x71, 0x0A, 0xF0, 0x77, 0x72, 0x0C, 0xF9, 0x06, 0x71, 0x06, 0xF0, 0xC7, 0x71,
  0x02, 0xFA, 0x06, 0x71, 0x01, 0xF9, 0x01, 0x77, 0x07, 0xFA, 0x06, 0x72, 0x0B, 0xF0, 0x77, 0x70,
  0xDF, 0xA0, 0x67, 0x20, 0x4F, 0x0E, 0x76, 0x07, 0xA0, 0xBF, 0x06, 0x73, 0x0C, 0xF0, 0x97, 0x40,
  0x3A, 0x0E, 0x05, 0xF0, 0x67, 0x30, 0x4F, 0x90, 0x77, 0x20, 0x30, 0xEA, 0x06, 0x05, 0xF0, 0x67,
  0x40, 0x9F, 0x90, 0xA0, 0x25, 0x01, 0x08, 0xB8, 0x1B, 0x06, 0xF0, 0x67, 0x50, 0xCF, 0xA8, 0x3C,
  0xA9, 0xAC, 0xC8, 0x2D, 0x10, 0x6F, 0x06, 0x75, 0x01, 0x0C, 0xFF, 0xA0, 0xE0, 0x32, 0x07, 0xF0,
  0x67, 0x70, 0x9F, 0xF0, 0xE0, 0x33, 0x07, 0xF0, 0x67, 0x71, 0x03, 0x0B, 0xFC, 0x09, 0x01, 0x40,
  0x7F, 0x06, 0x77, 0x38, 0x91, 0x27, 0xBD, 0xEF, 0xED, 0xA7, 0x16, 0x07, 0xF0, 0x67, 0x77, 0x76,
  0x07, 0xF0, 0x67, 0x77, 0x76, 0x07, 0xF0, 0x67, 0x77, 0x76, 0x07, 0xF0, 0x67, 0x77, 0x76, 0x07,
  0xF0, 0x67, 0x77, 0x76, 0x07, 0xF0, 0x67, 0x77, 0x76, 0x07, 0xF0, 0x67, 0x77, 0x76, 0x07, 0xF0,
  0x67, 0x77, 0x76, 0x07, 0xF0, 0x67, 0x77, 0x76, 0x07, 0xF0, 0x67, 0x77, 0x76, 0x07, 0xF0, 0x67,
  0x77, 0x76, 0x08, 0xF0, 0x77, 0x77, 0x76, 0x09, 0xF0, 0x87, 0x77, 0x76, 0x0C, 0xF0, 0xB7, 0x77,
  0x75, 0x03, 0xFA, 0x01, 0x77, 0x77, 0x30, 0x10, 0xCF, 0xA0, 0xB7, 0x77, 0x78, 0x21, 0x48, 0xEF,
  0xC8, 0x2E, 0x83, 0x17, 0x77, 0x0E, 0xFF, 0xF9, 0x01, 0x77, 0x50, 0xEF, 0xFF, 0x90, 0x17, 0x75,
  0x0E, 0xFF, 0xF9, 0x01, 0x77, 0x50, 0xEF, 0xFF, 0x90, 0x10,
  // "r" (U+0072)
  0x77, 0x78, 0x90, 0x27, 0xBE, 0xFE, 0xDB, 0x61, 0x30, 0x8F, 0xD0, 0x16, 0x08, 0xFA, 0x0E, 0x05,
  0x20, 0x8F, 0xD0, 0x35, 0x0B, 0xFD, 0x81, 0x50, 0x8F, 0xD0, 0x54, 0x0B, 0xFE, 0x81, 0xE1, 0x8F,
  0xD0, 0x83, 0x06, 0xFF, 0x90, 0x62, 0x81, 0x26, 0xCF, 0x90, 0xA2, 0x01, 0x0E, 0xFF, 0x90, 0x95,
  0x07, 0xF0, 0xC2, 0x08, 0xA8, 0x4E, 0x61, 0x03, 0xAF, 0x90, 0xB6, 0x0C, 0xE8, 0x5E, 0x01, 0xEF,
  0xE2, 0x50, 0xCF, 0x0A, 0x60, 0x7F, 0x01, 0x07, 0xA0, 0x56, 0x05, 0xF0, 0x76, 0x04, 0xF8, 0x23,
  0xEF, 0xB7, 0x01, 0xF0, 0x26, 0x03, 0xF0, 0xCA, 0x04, 0x71, 0x0E, 0xD0, 0x87, 0x02, 0xFA, 0x0D,
  0x72, 0x0D, 0xC0, 0x87, 0x10, 0x2F, 0xA0, 0x87, 0x28, 0x3B, 0xCA, 0x71, 0x72, 0x02, 0xFA, 0x04,
  0x77, 0x72, 0x02, 0xFA, 0x77, 0x73, 0x02, 0xF9, 0x0C, 0x77, 0x73, 0x02, 0xF9, 0x09, 0x77, 0x73,
  0x02, 0xF9, 0x07, 0x77, 0x73, 0x02, 0xF9, 0x04, 0x77, 0x73, 0x02, 0xF9, 0x03, 0x77, 0x73, 0x02,
  0xF9, 0x01, 0x77, 0x73, 0x02, 0xF9, 0x77, 0x74, 0x02, 0xF9, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77,
  0x40, 0x2F, 0x0E, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x74, 0x02, 0xF0,
  0xE7, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x74,
  0x02, 0xF0, 0xE7, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x40, 0x2F, 0x0E,
  0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x40,
  0x3F, 0x0E, 0x77, 0x74, 0x03, 0xF0, 0xE7, 0x77, 0x40, 0x4F, 0x97, 0x77, 0x40, 0x8F, 0x90, 0x27,
  0x77, 0x30, 0xDF, 0x90, 0x77, 0x77, 0x20, 0x8F, 0xA0, 0xE0, 0x37, 0x75, 0x81, 0x26, 0xCF, 0xD8,
  0x19, 0x41, 0x77, 0x0A, 0xFF, 0xF0, 0xE7, 0x40, 0xAF, 0xFF, 0x0E, 0x74, 0x0A, 0xFF, 0xF0, 0xE7,
  0x40, 0xAF, 0xFF, 0x0E, 0x74,
  // "s" (U+0073)
  0x72, 0x89, 0x32, 0x69, 0xCD, 0xEF, 0xED, 0xC9, 0x61, 0x77, 0x04, 0x0B, 0xFE, 0x0A, 0x01, 0x73,
  0x01, 0x0B, 0xFF, 0xA0, 0xE0, 0x57, 0x10, 0x30, 0xEF, 0xFD, 0x06, 0x60, 0x30, 0xED, 0x87, 0xE8,
  0x31, 0x01, 0x37, 0xEF, 0x02, 0x50, 0xDD, 0x0C, 0x01, 0x70, 0x10, 0xBE, 0x0A, 0x40, 0x7D, 0x0E,
  0x01, 0x73, 0x0D, 0xE0, 0x13, 0x0E, 0xD0, 0x77, 0x40, 0x4E, 0x03, 0x20, 0x4E, 0x01, 0x75, 0x0D,
  0xD0, 0x42, 0x08, 0xD0, 0xD7, 0x60, 0x9D, 0x03, 0x20, 0xAD, 0x0B, 0x76, 0x06, 0xC0, 0xD3, 0x0C,
  0xD0, 0xB7, 0x60, 0x4C, 0x05, 0x30, 0xDD, 0x0C, 0x76, 0x03, 0xA0, 0xE0, 0x54, 0x0C, 0xE7, 0x68,
  0x11, 0x74, 0x60, 0xBE, 0x05, 0x77, 0x70, 0x9E, 0x0C, 0x77, 0x70, 0x6F, 0x0A, 0x77, 0x60, 0x2F,
  0x90, 0xB0, 0x17, 0x75, 0x0B, 0xF9, 0x0E, 0x05, 0x77, 0x40, 0x3F, 0xB0, 0xB0, 0x37, 0x73, 0x08,
  0xFC, 0x0A, 0x02, 0x77, 0x20, 0xBF, 0xD0, 0xA0, 0x27, 0x71, 0x0A, 0xFE, 0x09, 0x01, 0x77, 0x07,
  0xFE, 0x0E, 0x06, 0x77, 0x03, 0x0D, 0xFE, 0x0B, 0x01, 0x77, 0x07, 0x0E, 0xFD, 0x0D, 0x03, 0x77,
  0x01, 0x09, 0xFD, 0x0E, 0x03, 0x77, 0x10, 0x20, 0xAF, 0xC0, 0xE0, 0x27, 0x72, 0x03, 0x0B, 0xFB,
  0x0C, 0x77, 0x40, 0x50, 0xEF, 0xA0, 0x57, 0x74, 0x01, 0x0A, 0xF9, 0x0C, 0x77, 0x60, 0x7F, 0x90,
  0x27, 0x76, 0x08, 0xF0, 0x57, 0x77, 0x0D, 0xE0, 0x83, 0x81, 0x38, 0x37, 0x71, 0x06, 0xE8, 0x2A,
  0x01, 0xBA, 0x06, 0x77, 0x10, 0x2E, 0x81, 0xB0, 0xDB, 0x07, 0x77, 0x2E, 0x0B, 0x06, 0xC0, 0xA7,
  0x72, 0xE0, 0x0A, 0xC0, 0xD7, 0x71, 0x01, 0xE0, 0x80, 0xCD, 0x02, 0x77, 0x03, 0xE0, 0x60, 0xCD,
  0x07, 0x77, 0x07, 0xE0, 0x20, 0xBD, 0x0E, 0x01, 0x76, 0x0D, 0xD8, 0x1D, 0x09, 0xE0, 0x97, 0x50,
  0x7E, 0x81, 0x70, 0x4F, 0x07, 0x73, 0x05, 0xE0, 0xD3, 0x0E, 0xF0, 0xB0, 0x36, 0x02, 0x0A, 0xF0,
  0x53, 0x05, 0xFA, 0x84, 0xDB, 0x99, 0xBE, 0xF9, 0x07, 0x50, 0x7F, 0xFF, 0x07, 0x70, 0x50, 0xEF,
  0xFB, 0x0D, 0x03, 0x72, 0x81, 0x18, 0xDF, 0xE0, 0xC0, 0x67, 0x78, 0x93, 0x37, 0xAC, 0xDE, 0xFE,
  0xDC, 0x96, 0x27, 0x20,
  // "t" (U+0074)
  0x73, 0x0E, 0xB0, 0x47, 0x76, 0x01, 0xC0, 0x47, 0x76, 0x04, 0xC0, 0x47, 0x76, 0x07, 0xC0, 0x47,
  0x76, 0x0C, 0xC0, 0x47, 0x75, 0x01, 0xD0, 0x47, 0x75, 0x08, 0xD0, 0x47, 0x74, 0x01, 0x0E, 0xD0,
  0x47, 0x74, 0x0A, 0xE0, 0x47, 0x73, 0x07, 0xF0, 0x47, 0x72, 0x08, 0xF9, 0x04, 0x77, 0x05, 0x0D,
  0xFF, 0xD8, 0x35, 0x04, 0xBE, 0xFF, 0xF8, 0x15, 0x08, 0xFF, 0xFA, 0x81, 0x50, 0x8F, 0xFF, 0xA8,
  0x15, 0x05, 0x80, 0x19, 0x0D, 0xF0, 0xB8, 0x05, 0x90, 0x37, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0,
  0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0,
  0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0,
  0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0,
  0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0,
  0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0,
  0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0,
  0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0,
  0x47, 0x73, 0x09, 0xF0, 0x47, 0x73, 0x09, 0xF0, 0x57, 0x73, 0x08, 0xF0, 0x57, 0x73, 0x07, 0xF0,
  0x77, 0x73, 0x05, 0xF0, 0xA7, 0x73, 0x03, 0xF0, 0xE7, 0x74, 0xF9, 0x04, 0x77, 0x30, 0xBF, 0x0C,
  0x77, 0x30, 0x5F, 0x90, 0xB0, 0x26, 0x02, 0x72, 0x0D, 0xFA, 0x86, 0xB9, 0x9A, 0xBE, 0xF1, 0x71,
  0x04, 0xFF, 0xA0, 0x17, 0x20, 0x5F, 0xF9, 0x01, 0x73, 0x03, 0x0B, 0xFD, 0x0D, 0x01, 0x75, 0x89,
  0x23, 0x7B, 0xDE, 0xFE, 0xDC, 0x96, 0x22,
  // "u" (U+0075)
  0x04, 0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x70, 0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7, 0x04, 0xFF, 0x73,
  0x04, 0xFE, 0x0E, 0x70, 0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7, 0x28, 0x11, 0x5A, 0xFB, 0x75, 0x81,
  0x25, 0xBF, 0xA0, 0xE7, 0x50, 0x4F, 0xA7, 0x71, 0x06, 0xF9, 0x0E, 0x76, 0x09, 0xF9, 0x77, 0x20,
  0xBF, 0x0E, 0x76, 0x04, 0xF9, 0x77, 0x20, 0x6F, 0x0E, 0x76, 0x01, 0xF9, 0x77, 0x20, 0x3F, 0x0E,
  0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20,
  0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9,
  0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E,
  0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20,
  0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9,
  0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E,
  0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20,
  0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9,
  0x77, 0x20, 0x2F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x3F, 0x0E, 0x77, 0xF9, 0x01, 0x77, 0x10, 0x4F,
  0x0E, 0x77, 0x0E, 0xF0, 0x17, 0x71, 0x07, 0xF0, 0xE7, 0x70, 0xDF, 0x03, 0x77, 0x10, 0x9F, 0x0E,
  0x77, 0x0C, 0xF0, 0x57, 0x71, 0x0D, 0xF0, 0xE7, 0x70, 0xAF, 0x08, 0x77, 0x02, 0xF9, 0x0E, 0x77,
  0x08, 0xF0, 0xB7, 0x70, 0x8F, 0x90, 0xE7, 0x70, 0x5F, 0x90, 0x17, 0x60, 0xEF, 0xA7, 0x70, 0x2F,
  0x90, 0x77, 0x50, 0x8F, 0xB7, 0x71, 0x0D, 0xF0, 0xE0, 0x27, 0x30, 0x4B, 0x0A, 0xF0, 0x37, 0x70,
  0x8F, 0x90, 0xC0, 0x27, 0x10, 0x6B, 0x08, 0x05, 0xF0, 0x87, 0x70, 0x2F, 0xA8, 0x7E, 0x94, 0x10,
  0x12, 0x6C, 0xB8, 0x1E, 0x13, 0xF9, 0x04, 0x77, 0x09, 0xFF, 0xE8, 0x16, 0x01, 0xFA, 0x81, 0xA5,
  0x17, 0x40, 0x10, 0xEF, 0xFC, 0x0B, 0x30, 0xEF, 0xD0, 0x67, 0x30, 0x30, 0xEF, 0xFA, 0x0C, 0x40,
  0xCF, 0xD0, 0x67, 0x40, 0x30, 0xDF, 0xF0, 0xB0, 0x14, 0x0A, 0xFD, 0x06, 0x75, 0x01, 0x08, 0xFC,
  0x0D, 0x05, 0x60, 0x7F, 0xD0, 0x67, 0x78, 0x31, 0x6A, 0xCE, 0xA8, 0x2E, 0xB8, 0x37, 0x77, 0x10,
  // "v" (U+0076)
  0x08, 0xFF, 0xD0, 0x17, 0x05, 0xFF, 0x90, 0x90, 0x8F, 0xFD, 0x01, 0x70, 0x5F, 0xF9, 0x09, 0x08,
  0xFF, 0xD0, 0x17, 0x05, 0xFF, 0x90, 0x90, 0x8F, 0xFD, 0x01, 0x70, 0x5F, 0xF9, 0x83, 0x90, 0x13,
  0x9F, 0xC8, 0x1E, 0x72, 0x75, 0x81, 0x14, 0xBF, 0x81, 0xE7, 0x26, 0x05, 0xFB, 0x05, 0x77, 0x30,
  0xBE, 0x04, 0x72, 0x09, 0xF9, 0x0D, 0x77, 0x40, 0x4D, 0x0B, 0x73, 0x02, 0xF9, 0x0C, 0x77, 0x40,
  0x2D, 0x04, 0x74, 0x0C, 0xF0, 0xD7, 0x74, 0x03, 0xC0, 0xD7, 0x50, 0x7F, 0x0E, 0x77, 0x40, 0x5C,
  0x08, 0x75, 0x02, 0xF9, 0x02, 0x77, 0x30, 0x8C, 0x03, 0x76, 0x0D, 0xF0, 0x57, 0x73, 0x0C, 0xB0,
  0xD7, 0x70, 0x8F, 0x0A, 0x77, 0x20, 0x1C, 0x08, 0x77, 0x03, 0xF0, 0xE7, 0x72, 0x05, 0xC0, 0x37,
  0x71, 0x0D, 0xF0, 0x47, 0x71, 0x0A, 0xB0, 0xE7, 0x72, 0x09, 0xF0, 0x87, 0x71, 0x0E, 0xB0, 0x97,
  0x72, 0x04, 0xF0, 0xD7, 0x70, 0x4C, 0x04, 0x77, 0x30, 0xEF, 0x02, 0x76, 0x09, 0xB0, 0xE7, 0x74,
  0x0A, 0xF0, 0x77, 0x60, 0xEB, 0x09, 0x77, 0x40, 0x5F, 0x0C, 0x75, 0x03, 0xC0, 0x47, 0x75, 0xF9,
  0x01, 0x74, 0x08, 0xB0, 0xE7, 0x76, 0x0B, 0xF0, 0x67, 0x40, 0xDB, 0x0A, 0x77, 0x60, 0x6F, 0x0A,
  0x73, 0x02, 0xC0, 0x57, 0x76, 0x01, 0xF0, 0xE7, 0x30, 0x7B, 0x0E, 0x77, 0x71, 0x0C, 0xF0, 0x47,
  0x20, 0xCB, 0x0A, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x10, 0x1C, 0x05, 0x77, 0x71, 0x02, 0xF0, 0xE7,
  0x10, 0x6C, 0x77, 0x73, 0x0D, 0xF0, 0x37, 0x0B, 0xB0, 0xB7, 0x77, 0x30, 0x8F, 0x08, 0x60, 0x1C,
  0x06, 0x77, 0x73, 0x03, 0xF0, 0xC6, 0x05, 0xC0, 0x17, 0x77, 0x40, 0xEF, 0x02, 0x50, 0xAB, 0x0B,
  0x77, 0x75, 0x09, 0xF0, 0x65, 0x0E, 0xB0, 0x67, 0x77, 0x50, 0x4F, 0x0B, 0x40, 0x4C, 0x01, 0x77,
  0x76, 0x0E, 0xE0, 0xE4, 0x09, 0xB0, 0xC7, 0x77, 0x70, 0xAF, 0x03, 0x30, 0xDB, 0x07, 0x77, 0x77,
  0x05, 0xF0, 0x72, 0x03, 0xC0, 0x27, 0x77, 0x70, 0x1F, 0x0B, 0x20, 0x7B, 0x0C, 0x77, 0x77, 0x20,
  0xBE, 0x0E, 0x20, 0xCB, 0x07, 0x77, 0x77, 0x20, 0x6F, 0x03, 0x01, 0xC0, 0x27, 0x77, 0x72, 0x01,
  0xF0, 0x70, 0x5B, 0x0D, 0x77, 0x77, 0x40, 0xCE, 0x0B, 0x0A, 0xB0, 0x77, 0x77, 0x74, 0x07, 0xE0,
  0x0E, 0xB0, 0x37, 0x77, 0x74, 0x02, 0xFB, 0x0D, 0x77, 0x77, 0x60, 0xDF, 0xA0, 0x87, 0x77, 0x76,
  0x08, 0xFA, 0x03, 0x77, 0x77, 0x60, 0x3F, 0x90, 0xD8, 0x0C, 0x00, 0x0E, 0xF0, 0x88, 0x0C, 0x00,
  0x09, 0xF0, 0x37, 0x74,
  // "w" (U+0077)
  0x0E, 0xFF, 0xC0, 0x47, 0x5D, 0x75, 0x03, 0xFF, 0xA0, 0x20, 0xEF, 0xFC, 0x04, 0x74, 0x04, 0xD0,
  0x57, 0x40, 0x3F, 0xFA, 0x02, 0x0E, 0xFF, 0xC0, 0x47, 0x40, 0x9D, 0x09, 0x74, 0x03, 0xFF, 0xA0,
  0x20, 0xEF, 0xFC, 0x04, 0x74, 0x0D, 0xD0, 0xD7, 0x40, 0x3F, 0xFA, 0x83, 0x20, 0x25, 0xCF, 0xC8,
  0x19, 0x31, 0x75, 0x03, 0xF0, 0x27, 0x58, 0x11, 0x5C, 0xF9, 0x0A, 0x03, 0x70, 0xAF, 0xA0, 0x87,
  0x71, 0x07, 0xF0, 0x67, 0x71, 0x0B, 0xE0, 0x87, 0x20, 0x10, 0xEF, 0x90, 0x17, 0x71, 0x0C, 0xF0,
  0xB7, 0x71, 0x03, 0xD0, 0xE7, 0x40, 0x8F, 0x97, 0x71, 0x01, 0xFA, 0x77, 0x2D, 0x07, 0x74, 0x03,
  0xF9, 0x77, 0x10, 0x5F, 0xA0, 0x47, 0x71, 0x0E, 0xC0, 0x27, 0x50, 0xEF, 0x02, 0x77, 0x0A, 0xFA,
  0x08, 0x77, 0x1C, 0x0C, 0x76, 0x0A, 0xF0, 0x67, 0x70, 0xEA, 0x0E, 0xE0, 0xD7, 0x70, 0x2C, 0x08,
  0x76, 0x06, 0xF0, 0xA7, 0x60, 0x3B, 0x07, 0x0E, 0xE0, 0x17, 0x60, 0x5C, 0x03, 0x76, 0x02, 0xF0,
  0xD7, 0x60, 0x8B, 0x03, 0x0A, 0xE0, 0x67, 0x60, 0x9B, 0x0E, 0x77, 0x10, 0xEF, 0x01, 0x75, 0x0C,
  0xA8, 0x1E, 0x06, 0xE0, 0xA7, 0x60, 0xCB, 0x0B, 0x77, 0x10, 0xAF, 0x05, 0x74, 0x01, 0xB8, 0x1A,
  0x02, 0xE0, 0xE7, 0x50, 0x1C, 0x07, 0x77, 0x10, 0x6F, 0x08, 0x74, 0x06, 0xB0, 0x52, 0x0D, 0xE0,
  0x37, 0x40, 0x5C, 0x02, 0x77, 0x10, 0x2F, 0x0C, 0x74, 0x0A, 0xB0, 0x12, 0x09, 0xE0, 0x77, 0x40,
  0x9B, 0x0E, 0x77, 0x30, 0xDF, 0x74, 0x0E, 0xA0, 0xC3, 0x05, 0xE0, 0xC7, 0x40, 0xDB, 0x0A, 0x77,
  0x30, 0xAF, 0x03, 0x72, 0x04, 0xB0, 0x83, 0x01, 0xF0, 0x17, 0x20, 0x1C, 0x05, 0x77, 0x30, 0x6F,
  0x07, 0x72, 0x08, 0xB0, 0x34, 0x0C, 0xE0, 0x57, 0x20, 0x6C, 0x01, 0x77, 0x30, 0x2F, 0x0A, 0x72,
  0x0D, 0xA0, 0xE5, 0x08, 0xE0, 0x97, 0x20, 0xAB, 0x0D, 0x77, 0x50, 0xDE, 0x0E, 0x71, 0x02, 0xB0,
  0xA5, 0x04, 0xE0, 0xE7, 0x20, 0xEB, 0x09, 0x77, 0x50, 0x9F, 0x02, 0x70, 0x6B, 0x06, 0x60, 0xEE,
  0x02, 0x70, 0x2C, 0x04, 0x77, 0x50, 0x5F, 0x05, 0x70, 0xBB, 0x01, 0x60, 0xBE, 0x07, 0x70, 0x6C,
  0x77, 0x60, 0x1F, 0x09, 0x7B, 0x0D, 0x70, 0x6E, 0x0B, 0x70, 0xAB, 0x0C, 0x77, 0x70, 0xDE, 0x0C,
  0x60, 0x5B, 0x08, 0x70, 0x2F, 0x70, 0xEB, 0x07, 0x77, 0x70, 0x9F, 0x60, 0x9B, 0x04, 0x71, 0x0D,
  0xE0, 0x45, 0x03, 0xC0, 0x37, 0x77, 0x05, 0xF0, 0x35, 0x0D, 0xA0, 0xE7, 0x20, 0x9E, 0x09, 0x50,
  0x7B, 0x0E, 0x77, 0x71, 0x01, 0xF0, 0x74, 0x03, 0xB0, 0xB7, 0x20, 0x5E, 0x0D, 0x50, 0xBB, 0x0B,
  0x77, 0x72, 0x0C, 0xE0, 0xA4, 0x07, 0xB0, 0x67, 0x20, 0x1F, 0x02, 0x40, 0xEB, 0x06, 0x77, 0x72,
  0x08, 0xE0, 0xD4, 0x0B, 0xB0, 0x27, 0x30, 0xCE, 0x06, 0x30, 0x3C, 0x02, 0x77, 0x72, 0x04, 0xF0,
  0x13, 0xB0, 0xD7, 0x40, 0x8E, 0x0A, 0x30, 0x7B, 0x0E, 0x77, 0x74, 0xF0, 0x42, 0x04, 0xB0, 0x97,
  0x40, 0x4E, 0x0D, 0x30, 0xAB, 0x09, 0x77, 0x74, 0x0C, 0xE0, 0x72, 0x08, 0xB0, 0x47, 0x5F, 0x01,
  0x20, 0xEB, 0x05, 0x77, 0x74, 0x08, 0xE0, 0xA2, 0x0B, 0xB7, 0x60, 0xBE, 0x81, 0x50, 0x2C, 0x01,
  0x77, 0x74, 0x04, 0xE0, 0xD2, 0xB0, 0xB7, 0x60, 0x7E, 0x81, 0x80, 0x5B, 0x0D, 0x77, 0x76, 0xF1,
  0x04, 0xB0, 0x77, 0x60, 0x2E, 0x81, 0xC0, 0x8B, 0x08, 0x77, 0x76, 0x0B, 0xE0, 0x30, 0x7B, 0x02,
  0x77, 0x0E, 0xE1, 0x0B, 0xB0, 0x47, 0x77, 0x60, 0x7E, 0x06, 0x0A, 0xA0, 0xD7, 0x71, 0x09, 0xE0,
  0x30, 0xEB, 0x77, 0x77, 0x03, 0xE0, 0x80, 0xDA, 0x09, 0x77, 0x10, 0x5E, 0x07, 0xB0, 0xB7, 0x77,
  0x71, 0x0E, 0xD0, 0xDB, 0x05, 0x77, 0x10, 0x1E, 0x0D, 0xB0, 0x77, 0x77, 0x71, 0x0B, 0xFA, 0x01,
  0x77, 0x20, 0xCF, 0xA0, 0x37, 0x77, 0x71, 0x07, 0xF9, 0x0C, 0x77, 0x30, 0x8F, 0x90, 0xE7, 0x77,
  0x72, 0x03, 0xF9, 0x07, 0x77, 0x30, 0x4F, 0x90, 0xA7, 0x77, 0x73, 0x0E, 0xF0, 0x37, 0x74, 0xF9,
  0x06, 0x77, 0x77, 0x30, 0xBE, 0x0E, 0x77, 0x50, 0xBF, 0x02, 0x77, 0x77, 0x30, 0x7E, 0x0A, 0x77,
  0x50, 0x7E, 0x0D, 0x77, 0x77, 0x40, 0x3E, 0x05, 0x77, 0x50, 0x3E, 0x09, 0x77, 0x30,
  // "x" (U+0078)
  0x10, 0x1F, 0xFE, 0x30, 0x2F, 0xFA, 0x0B, 0x30, 0x1F, 0xFE, 0x30, 0x2F, 0xFA, 0x0B, 0x30, 0x1F,
  0xFE, 0x30, 0x2F, 0xFA, 0x0B, 0x30, 0x1F, 0xFE, 0x30, 0x2F, 0xFA, 0x0B, 0x60, 0x40, 0xAF, 0xD8,
  0x1B, 0x41, 0x68, 0x11, 0x5C, 0xF9, 0x81, 0xD7, 0x27, 0x30, 0x5F, 0xB0, 0xE7, 0x50, 0xEE, 0x0A,
  0x77, 0x04, 0xFA, 0x0A, 0x75, 0x0C, 0xD0, 0xB7, 0x72, 0x06, 0xF9, 0x0B, 0x75, 0x0D, 0xC0, 0xD0,
  0x17, 0x73, 0x09, 0xF9, 0x01, 0x73, 0x02, 0xD0, 0x37, 0x74, 0x01, 0x0E, 0xF0, 0x87, 0x30, 0x8C,
  0x08, 0x77, 0x60, 0x5F, 0x90, 0x37, 0x20, 0xEB, 0x0D, 0x77, 0x71, 0x0B, 0xF0, 0xC7, 0x10, 0x7C,
  0x04, 0x77, 0x71, 0x02, 0xF9, 0x05, 0x60, 0x10, 0xEB, 0x0A, 0x77, 0x73, 0x07, 0xF0, 0xD6, 0x09,
  0xB0, 0xE0, 0x17, 0x77, 0x40, 0xCF, 0x08, 0x40, 0x2C, 0x06, 0x77, 0x75, 0x03, 0xF9, 0x02, 0x30,
  0xAB, 0x0B, 0x77, 0x77, 0x09, 0xF0, 0xA2, 0x03, 0xC0, 0x27, 0x77, 0x70, 0x10, 0xEF, 0x81, 0x40,
  0xBB, 0x08, 0x77, 0x77, 0x20, 0x5F, 0x0D, 0x05, 0xB0, 0xD7, 0x77, 0x74, 0x0B, 0xFC, 0x04, 0x77,
  0x77, 0x40, 0x2F, 0xB0, 0xA7, 0x77, 0x76, 0x07, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x70, 0xCF, 0x0B,
  0x80, 0xC0, 0x00, 0x3F, 0x90, 0x57, 0x77, 0x77, 0x03, 0xF9, 0x0E, 0x01, 0x77, 0x77, 0x60, 0xDF,
  0xA0, 0xA7, 0x77, 0x75, 0x08, 0xFC, 0x04, 0x77, 0x77, 0x30, 0x3B, 0x0E, 0x07, 0xF0, 0xD7, 0x77,
  0x73, 0x0D, 0xB8, 0x16, 0x0C, 0xF0, 0x97, 0x77, 0x71, 0x08, 0xB0, 0xC2, 0x02, 0xF9, 0x04, 0x77,
  0x76, 0x03, 0xC0, 0x33, 0x08, 0xF0, 0xD7, 0x77, 0x60, 0xDB, 0x09, 0x50, 0xDF, 0x08, 0x77, 0x74,
  0x08, 0xB0, 0xE0, 0x15, 0x05, 0xF9, 0x03, 0x77, 0x72, 0x03, 0xC0, 0x57, 0x0B, 0xF0, 0xD7, 0x77,
  0x20, 0xCB, 0x0B, 0x71, 0x02, 0xF9, 0x07, 0x77, 0x70, 0x8C, 0x02, 0x72, 0x07, 0xF9, 0x02, 0x77,
  0x50, 0x3C, 0x09, 0x74, 0x0C, 0xF0, 0xC7, 0x75, 0x0C, 0xC0, 0x17, 0x40, 0x3F, 0x90, 0x77, 0x73,
  0x07, 0xC0, 0x97, 0x60, 0x9F, 0x90, 0x27, 0x71, 0x03, 0xD0, 0x37, 0x60, 0x2F, 0x90, 0xB7, 0x70,
  0x20, 0xED, 0x77, 0x10, 0xDF, 0x90, 0x87, 0x50, 0x10, 0xDE, 0x77, 0x10, 0xCF, 0xA0, 0x57, 0x30,
  0x20, 0xDF, 0x04, 0x76, 0x02, 0xFC, 0x06, 0x68, 0x11, 0x49, 0xFA, 0x81, 0xE7, 0x37, 0x28, 0x12,
  0x6E, 0xFD, 0x0B, 0x04, 0x20, 0x8F, 0xFB, 0x0E, 0x50, 0xAF, 0xFD, 0x0C, 0x08, 0xFF, 0xB0, 0xE5,
  0x0A, 0xFF, 0xD0, 0xC0, 0x8F, 0xFB, 0x0E, 0x50, 0xAF, 0xFD, 0x0C, 0x08, 0xFF, 0xB0, 0xE5, 0x0A,
  0xFF, 0xD0, 0xC0,
  // "y" (U+0079)
  0x0B, 0xFF, 0xC0, 0x47, 0x04, 0xFF, 0x90, 0xA0, 0xBF, 0xFC, 0x04, 0x70, 0x4F, 0xF9, 0x0A, 0x0B,
  0xFF, 0xC0, 0x47, 0x04, 0xFF, 0x90, 0xA0, 0xBF, 0xFC, 0x04, 0x70, 0x4F, 0xF9, 0x83, 0xA0, 0x14,
  0xBF, 0xC8, 0x1C, 0x51, 0x74, 0x81, 0x14, 0xBF, 0x98, 0x1B, 0x41, 0x50, 0xAF, 0xA0, 0xC7, 0x73,
  0x0A, 0xE0, 0xA7, 0x10, 0x10, 0xEF, 0x90, 0x67, 0x73, 0x04, 0xD0, 0xE0, 0x17, 0x20, 0x8F, 0x90,
  0x57, 0x73, 0x02, 0xD0, 0x97, 0x30, 0x2F, 0x90, 0x67, 0x73, 0x04, 0xD0, 0x27, 0x40, 0xCF, 0x09,
  0x77, 0x30, 0x5C, 0x0C, 0x75, 0x06, 0xF0, 0xD7, 0x73, 0x09, 0xC0, 0x77, 0x50, 0x1F, 0x90, 0x27,
  0x72, 0x0D, 0xC0, 0x27, 0x60, 0xAF, 0x07, 0x77, 0x10, 0x2C, 0x0D, 0x77, 0x05, 0xF0, 0xC7, 0x71,
  0x06, 0xC0, 0x87, 0x71, 0x0E, 0xF0, 0x27, 0x70, 0xBC, 0x03, 0x77, 0x10, 0x9F, 0x07, 0x77, 0xC0,
  0xE7, 0x72, 0x04, 0xF0, 0xC7, 0x60, 0x4C, 0x09, 0x77, 0x30, 0xDF, 0x02, 0x75, 0x08, 0xC0, 0x47,
  0x73, 0x08, 0xF0, 0x77, 0x50, 0xDB, 0x0E, 0x77, 0x40, 0x3F, 0x0D, 0x74, 0x02, 0xC0, 0xA7, 0x75,
  0x0C, 0xF0, 0x27, 0x30, 0x6C, 0x05, 0x77, 0x50, 0x7F, 0x08, 0x73, 0x0A, 0xC7, 0x76, 0x01, 0xF0,
  0xD7, 0x30, 0xEB, 0x0A, 0x77, 0x70, 0xBF, 0x03, 0x71, 0x04, 0xC0, 0x67, 0x77, 0x06, 0xF0, 0x87,
  0x10, 0x8C, 0x01, 0x77, 0x70, 0x1F, 0x0D, 0x71, 0x0C, 0xB0, 0xB7, 0x77, 0x20, 0xAF, 0x03, 0x60,
  0x1C, 0x06, 0x77, 0x72, 0x05, 0xF0, 0x86, 0x06, 0xC0, 0x27, 0x77, 0x30, 0xEE, 0x0D, 0x60, 0xAB,
  0x0C, 0x77, 0x74, 0x09, 0xF0, 0x25, 0x0E, 0xB0, 0x77, 0x77, 0x40, 0x3F, 0x07, 0x40, 0x3C, 0x02,
  0x77, 0x75, 0x0D, 0xE0, 0xC4, 0x08, 0xB0, 0xD7, 0x77, 0x60, 0x8F, 0x01, 0x30, 0xCB, 0x08, 0x77,
  0x76, 0x02, 0xF0, 0x52, 0x01, 0xC0, 0x37, 0x77, 0x70, 0xCE, 0x0A, 0x20, 0x5B, 0x0E, 0x77, 0x77,
  0x10, 0x7E, 0x0E, 0x20, 0x9B, 0x09, 0x77, 0x77, 0x10, 0x1F, 0x81, 0x30, 0xDB, 0x04, 0x77, 0x77,
  0x20, 0xBE, 0x07, 0x01, 0xB0, 0xE7, 0x77, 0x73, 0x06, 0xE0, 0xA0, 0x5B, 0x0A, 0x77, 0x77, 0x4E,
  0x0E, 0x09, 0xB0, 0x57, 0x77, 0x74, 0x0A, 0xE0, 0xEB, 0x77, 0x77, 0x50, 0x4F, 0xA0, 0xB7, 0x77,
  0x76, 0x0E, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x77, 0x76, 0x03, 0xF0, 0xB8, 0x0C,
  0x00, 0x0D, 0xE0, 0x78, 0x0C, 0x00, 0x08, 0xE0, 0x28, 0x0C, 0x00, 0x02, 0xD0, 0xC8, 0x0C, 0x10,
  0x03, 0xD0, 0x78, 0x0C, 0x10, 0x08, 0xD0, 0x28, 0x0C, 0x10, 0x0D, 0xC0, 0xD8, 0x0C, 0x10, 0x03,
  0xD0, 0x88, 0x0C, 0x10, 0x09, 0xD0, 0x38, 0x0C, 0x10, 0x0E, 0xC0, 0xD8, 0x0C, 0x10, 0x06, 0xD0,
  0x78, 0x0C, 0x10, 0x0D, 0xD0, 0x18, 0x0C, 0x00, 0x07, 0xD0, 0xB8, 0x0C, 0x00, 0x01, 0x0E, 0xD0,
  0x58, 0x0C, 0x00, 0x0A, 0xD0, 0xD8, 0x0C, 0x00, 0x07, 0xE0, 0x67, 0x77, 0x77, 0x07, 0xE0, 0xD7,
  0x77, 0x77, 0x09, 0xF0, 0x57, 0x77, 0x75, 0x04, 0x0C, 0xF0, 0xB7, 0x77, 0x73, 0x81, 0x26, 0xCF,
  0x90, 0xE0, 0x17, 0x77, 0x58, 0x31, 0x9A, 0xBE, 0xFC, 0x03, 0x77, 0x76, 0x03, 0xFE, 0x0E, 0x04,
  0x77, 0x77, 0x03, 0xFD, 0x0B, 0x02, 0x77, 0x77, 0x10, 0x3F, 0xB0, 0xA0, 0x47, 0x77, 0x73, 0x03,
  0xA8, 0x5E, 0xED, 0xB9, 0x74, 0x77, 0x77, 0x40,
  // "z" (U+007A)
  0x10, 0x1F, 0xFF, 0xFA, 0x20, 0x2F, 0xFF, 0xFA, 0x20, 0x3F, 0xFF, 0xFA, 0x20, 0x4F, 0xFF, 0xFA,
  0x20, 0x5F, 0x0C, 0x0A, 0x80, 0x79, 0x0C, 0xF9, 0x0A, 0x20, 0x6D, 0x0B, 0x02, 0x76, 0x0D, 0xF0,
  0xE0, 0x12, 0x07, 0xC0, 0xC7, 0x70, 0x6F, 0x90, 0x73, 0x08, 0xC0, 0x47, 0x60, 0x10, 0xEF, 0x0D,
  0x40, 0x9B, 0x0D, 0x77, 0x09, 0xF9, 0x05, 0x40, 0xAB, 0x08, 0x76, 0x02, 0xF9, 0x0B, 0x50, 0xBB,
  0x03, 0x76, 0x0B, 0xF9, 0x03, 0x50, 0xCA, 0x0E, 0x76, 0x04, 0xF9, 0x09, 0x68, 0x28, 0xAA, 0x77,
  0x60, 0xDF, 0x0E, 0x01, 0x77, 0x71, 0x06, 0xF9, 0x07, 0x77, 0x71, 0x01, 0x0E, 0xF0, 0xD7, 0x77,
  0x20, 0x9F, 0x90, 0x47, 0x77, 0x10, 0x2F, 0x90, 0xB7, 0x77, 0x20, 0xBF, 0x90, 0x27, 0x77, 0x10,
  0x4F, 0x90, 0x97, 0x77, 0x20, 0xDF, 0x0E, 0x01, 0x77, 0x71, 0x06, 0xF9, 0x06, 0x77, 0x71, 0x01,
  0x0E, 0xF0, 0xD7, 0x77, 0x20, 0x9F, 0x90, 0x47, 0x77, 0x10, 0x2F, 0x90, 0xA7, 0x77, 0x20, 0xBF,
  0x90, 0x27, 0x77, 0x10, 0x4F, 0x90, 0x87, 0x77, 0x20, 0xDF, 0x0E, 0x77, 0x72, 0x06, 0xF9, 0x06,
  0x77, 0x71, 0x01, 0x0E, 0xF0, 0xC7, 0x77, 0x20, 0x9F, 0x90, 0x37, 0x77, 0x10, 0x2F, 0x90, 0xA7,
  0x77, 0x20, 0xBF, 0x90, 0x17, 0x77, 0x10, 0x4F, 0x90, 0x87, 0x77, 0x20, 0xDF, 0x0D, 0x77, 0x82,
  0x78, 0x84, 0x50, 0x6F, 0x90, 0x57, 0x60, 0x1B, 0x08, 0x40, 0x10, 0xEF, 0x0C, 0x77, 0x03, 0xB0,
  0x74, 0x09, 0xF9, 0x03, 0x77, 0x06, 0xB0, 0x73, 0x02, 0xF9, 0x09, 0x77, 0x10, 0xAB, 0x06, 0x30,
  0xBF, 0x0E, 0x01, 0x77, 0x10, 0xEB, 0x06, 0x20, 0x4F, 0x90, 0x77, 0x71, 0x04, 0xC0, 0x62, 0x0D,
  0xF0, 0xD7, 0x72, 0x0A, 0xC8, 0x15, 0x06, 0xF9, 0x05, 0x77, 0x10, 0x4D, 0x81, 0x51, 0xEF, 0x0B,
  0x77, 0x10, 0x40, 0xED, 0x05, 0x09, 0xF9, 0x0B, 0x80, 0x91, 0x90, 0xA0, 0xDF, 0x04, 0xFF, 0xFF,
  0xC0, 0x4F, 0xFF, 0xFC, 0x03, 0xFF, 0xFF, 0xC0, 0x3F, 0xFF, 0xFC, 0x03,
  // "{" (U+007B)
  0x77, 0x28, 0x33, 0x8C, 0xDE, 0xD0, 0x87, 0x70, 0x40, 0xCF, 0xB0, 0x87, 0x60, 0x7F, 0xD0, 0x87,
  0x50, 0x8F, 0xE0, 0x87, 0x40, 0x3F, 0xA8, 0x18, 0x31, 0x77, 0x0D, 0xF0, 0xE0, 0x27, 0x72, 0x04,
  0xF9, 0x05, 0x77, 0x30, 0xAF, 0x0C, 0x77, 0x40, 0xDF, 0x07, 0x77, 0x30, 0x1F, 0x90, 0x37, 0x73,
  0x03, 0xF9, 0x01, 0x77, 0x30, 0x5F, 0x97, 0x74, 0x05, 0xF0, 0xE7, 0x74, 0x06, 0xF0, 0xD7, 0x74,
  0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74,
  0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74,
  0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74,
  0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74, 0x06, 0xF0, 0xD7, 0x74, 0x07, 0xF0, 0xD7, 0x74,
  0x08, 0xF0, 0xC7, 0x74, 0x0A, 0xF0, 0xA7, 0x74, 0x0D, 0xF0, 0x77, 0x73, 0x02, 0xF9, 0x03, 0x77,
  0x30, 0xAF, 0x0D, 0x77, 0x30, 0x7F, 0x90, 0x67, 0x71, 0x01, 0x09, 0xF9, 0x0C, 0x76, 0x82, 0x15,
  0x9E, 0xF9, 0x0D, 0x01, 0x74, 0x06, 0xFD, 0x0B, 0x01, 0x75, 0x06, 0xFB, 0x0B, 0x05, 0x77, 0x06,
  0xF9, 0x0D, 0x05, 0x77, 0x20, 0x6F, 0xB8, 0x1E, 0x81, 0x76, 0x83, 0x14, 0x6A, 0xEF, 0x90, 0xE0,
  0x47, 0x73, 0x07, 0x0E, 0xF9, 0x04, 0x77, 0x30, 0x10, 0xCF, 0x0E, 0x01, 0x77, 0x30, 0x10, 0xDF,
  0x09, 0x77, 0x40, 0x6F, 0x0E, 0x77, 0x50, 0xEF, 0x05, 0x77, 0x40, 0xBF, 0x08, 0x77, 0x40, 0x8F,
  0x0B, 0x77, 0x40, 0x7F, 0x0C, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F,
  0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F,
  0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F,
  0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x6F,
  0x0D, 0x77, 0x40, 0x6F, 0x0D, 0x77, 0x40, 0x5F, 0x0E, 0x77, 0x40, 0x5F, 0x0E, 0x77, 0x40, 0x4F,
  0x97, 0x74, 0x01, 0xF9, 0x03, 0x77, 0x40, 0xDF, 0x07, 0x77, 0x40, 0xAF, 0x0C, 0x77, 0x40, 0x4F,
  0x90, 0x47, 0x74, 0x0C, 0xF0, 0xE0, 0x27, 0x73, 0x03, 0xF9, 0x81, 0xE7, 0x27, 0x72, 0x07, 0xFE,
  0x08, 0x76, 0x07, 0xFD, 0x08, 0x77, 0x04, 0x0C, 0xFB, 0x08, 0x77, 0x28, 0x33, 0x8C, 0xDE, 0xD0,
  0x80,
  // "|" (U+007C)
  0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0,
  0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC,
  0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D,
  0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0,
  0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC,
  0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D,
  0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0,
  0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC,
  0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xD0,
  // "}" (U+007D)
  0x06, 0xD8, 0x3E, 0xDC, 0x84, 0x77, 0x20, 0x6F, 0xB0, 0xD0, 0x57, 0x70, 0x6F, 0xD0, 0x87, 0x60,
  0x6F, 0xE0, 0x97, 0x72, 0x81, 0x27, 0xEF, 0x90, 0x47, 0x73, 0x01, 0x0D, 0xF0, 0xD7, 0x74, 0x03,
  0xF9, 0x04, 0x77, 0x40, 0xBF, 0x0A, 0x77, 0x40, 0x6F, 0x0E, 0x77, 0x40, 0x3F, 0x90, 0x27, 0x74,
  0xF9, 0x04, 0x77, 0x40, 0xEF, 0x05, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40,
  0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40,
  0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40,
  0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40,
  0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xDF, 0x06, 0x77, 0x40, 0xCF, 0x07, 0x77, 0x40,
  0xBF, 0x08, 0x77, 0x40, 0xAF, 0x0A, 0x77, 0x40, 0x7F, 0x0E, 0x77, 0x40, 0x3F, 0x90, 0x37, 0x74,
  0x0D, 0xF0, 0xB7, 0x74, 0x05, 0xF9, 0x07, 0x77, 0x40, 0xBF, 0x90, 0xA0, 0x17, 0x72, 0x01, 0x0D,
  0xFA, 0x81, 0xA5, 0x27, 0x70, 0x10, 0xBF, 0xD0, 0x77, 0x70, 0x40, 0xBF, 0xB0, 0x87, 0x72, 0x05,
  0x0C, 0xF9, 0x08, 0x76, 0x81, 0x18, 0xEF, 0xB0, 0x87, 0x50, 0x40, 0xEF, 0x98, 0x3E, 0xA6, 0x41,
  0x74, 0x03, 0xF9, 0x0E, 0x06, 0x77, 0x10, 0x10, 0xEF, 0x0C, 0x01, 0x77, 0x20, 0x8F, 0x0E, 0x01,
  0x77, 0x30, 0xEF, 0x06, 0x77, 0x30, 0x5F, 0x97, 0x74, 0x08, 0xF0, 0xB7, 0x74, 0x0B, 0xF0, 0x97,
  0x74, 0x0C, 0xF0, 0x77, 0x74, 0x0D, 0xF0, 0x77, 0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67,
  0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67,
  0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67,
  0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67,
  0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0D, 0xF0, 0x67, 0x74, 0x0E, 0xF0, 0x57, 0x74, 0xF9, 0x04, 0x77,
  0x30, 0x2F, 0x90, 0x27, 0x73, 0x06, 0xF0, 0xE7, 0x74, 0x0B, 0xF0, 0xA7, 0x73, 0x02, 0xF9, 0x04,
  0x77, 0x20, 0x10, 0xCF, 0x0D, 0x77, 0x18, 0x12, 0x6E, 0xF9, 0x04, 0x74, 0x06, 0xFE, 0x08, 0x75,
  0x06, 0xFD, 0x08, 0x76, 0x06, 0xFB, 0x0D, 0x04, 0x77, 0x06, 0xE8, 0x2D, 0xC8, 0x47, 0x72,
  // "~" (U+007E)
  0x78, 0x43, 0x78, 0x86, 0x27, 0x73, 0x84, 0x39, 0x99, 0x96, 0x50, 0x30, 0xCE, 0x0C, 0x03, 0x77,
  0x10, 0x7C, 0x08, 0x40, 0x5F, 0xB0, 0x67, 0x70, 0x8C, 0x06, 0x30, 0x2F, 0xD0, 0x87, 0x60, 0xAC,
  0x04, 0x30, 0xCF, 0xE0, 0x97, 0x50, 0xDC, 0x01, 0x20, 0x5D, 0x83, 0x81, 0x03, 0xBD, 0x0A, 0x74,
  0xC0, 0xD3, 0x0B, 0xC0, 0x85, 0x09, 0xD0, 0x97, 0x20, 0x3C, 0x0A, 0x20, 0x1C, 0x0E, 0x70, 0x9D,
  0x08, 0x71, 0x07, 0xC0, 0x72, 0x06, 0xC0, 0x97, 0x10, 0xBD, 0x07, 0x70, 0xCC, 0x03, 0x20, 0xAC,
  0x04, 0x72, 0x0C, 0xD0, 0x75, 0x03, 0xC0, 0xD3, 0x0D, 0xC7, 0x30, 0x10, 0xDD, 0x08, 0x30, 0x10,
  0xDC, 0x07, 0x20, 0x1C, 0x0D, 0x74, 0x02, 0x0E, 0xD8, 0x2D, 0xAA, 0xEC, 0x0E, 0x01, 0x20, 0x4C,
  0x0A, 0x75, 0x02, 0x0E, 0xFD, 0x06, 0x30, 0x5C, 0x08, 0x76, 0x02, 0x0D, 0xFB, 0x0A, 0x40, 0x7C,
  0x06, 0x77, 0x01, 0x0A, 0xF9, 0x09, 0x50, 0x9C, 0x05, 0x77, 0x28, 0x62, 0x8C, 0xEF, 0xD9, 0x36,
  // "¡" (U+00A1)
  0x28, 0x47, 0xCF, 0xEB, 0x53, 0x0B, 0xE8, 0x19, 0x07, 0xF9, 0x04, 0x0C, 0xF9, 0x09, 0x0E, 0xF9,
  0x0B, 0xFA, 0x0C, 0x0E, 0xF9, 0x0B, 0x0C, 0xF9, 0x09, 0x07, 0xF9, 0x81, 0x40, 0xCE, 0x09, 0x38,
  0x47, 0xCF, 0xEB, 0x58, 0x09, 0xA0, 0x00, 0x5C, 0x02, 0x40, 0x5C, 0x03, 0x40, 0x6C, 0x03, 0x40,
  0x7C, 0x04, 0x40, 0x8C, 0x05, 0x40, 0x9C, 0x06, 0x40, 0xAC, 0x07, 0x40, 0xBC, 0x08, 0x40, 0xCC,
  0x09, 0x40, 0xDC, 0x0A, 0x40, 0xDC, 0x0A, 0x40, 0xEC, 0x0B, 0x4D, 0x0C, 0x30, 0x1D, 0x0D, 0x30,
  0x1D, 0x0E, 0x30, 0x2E, 0x30, 0x3E, 0x30, 0x4E, 0x01, 0x20, 0x5E, 0x02, 0x20, 0x6E, 0x03, 0x20,
  0x7E, 0x04, 0x20, 0x8E, 0x05, 0x20, 0x8E, 0x05, 0x20, 0x9E, 0x06, 0x20, 0xAE, 0x07, 0x20, 0xBE,
  0x08, 0x20, 0xCE, 0x09, 0x20, 0xDE, 0x0A, 0x20, 0xEE, 0x0B, 0x2F, 0x0C, 0x2F, 0x81, 0xD0, 0x1F,
  0x81, 0xD0, 0x2F, 0x81, 0xE0, 0x3F, 0x91, 0x03, 0xF9, 0x01, 0x04, 0xF9, 0x01, 0x05, 0xF9, 0x02,
  0x06, 0xF9, 0x03, 0x07, 0xF9, 0x04, 0x08, 0xF9, 0x05, 0x09, 0xF9, 0x06, 0x0A, 0xF9, 0x07, 0x0B,
  0xF9, 0x08, 0x0B, 0xF9, 0x08, 0x0C, 0xF9, 0x09, 0x0D, 0xF9, 0x0A,
  // "¢" (U+00A2)
  0x77, 0x3B, 0x0C, 0x77, 0x77, 0x2B, 0x0C, 0x77, 0x77, 0x2B, 0x0C, 0x77, 0x77, 0x2B, 0x0C, 0x77,
  0x77, 0x2B, 0x0C, 0x77, 0x77, 0x2B, 0x0C, 0x77, 0x77, 0x03, 0x06, 0xB8, 0x2D, 0x32, 0x17, 0x77,
  0x10, 0x60, 0xBF, 0xB8, 0x2E, 0xB6, 0x17, 0x72, 0x08, 0x0E, 0xFF, 0xA0, 0x90, 0x17, 0x50, 0x40,
  0xDF, 0xFE, 0x05, 0x73, 0x07, 0xFF, 0xFA, 0x07, 0x71, 0x07, 0xF9, 0x0B, 0x06, 0xB8, 0x1D, 0x7D,
  0xFA, 0x04, 0x60, 0x5F, 0x0E, 0x04, 0x2B, 0x0C, 0x20, 0x9F, 0x90, 0xC5, 0x01, 0x0E, 0xE0, 0xD0,
  0x23, 0xB0, 0xC3, 0x0A, 0xF9, 0x02, 0x40, 0xAF, 0x03, 0x4B, 0x0C, 0x30, 0x10, 0xEF, 0x05, 0x30,
  0x3F, 0x09, 0x5B, 0x0C, 0x40, 0x9F, 0x06, 0x30, 0xAF, 0x02, 0x5B, 0x0C, 0x40, 0x4F, 0x05, 0x20,
  0x2F, 0x0B, 0x6B, 0x0C, 0x5F, 0x02, 0x20, 0x7F, 0x06, 0x6B, 0x0C, 0x50, 0xDD, 0x0A, 0x30, 0xCF,
  0x01, 0x6B, 0x0C, 0x50, 0xBC, 0x0C, 0x01, 0x20, 0x1F, 0x0D, 0x7B, 0x0C, 0x58, 0x3B, 0xFD, 0xA5,
  0x40, 0x4F, 0x0A, 0x7B, 0x0C, 0x77, 0x07, 0xF0, 0x77, 0xB0, 0xC7, 0x70, 0xAF, 0x06, 0x7B, 0x0C,
  0x77, 0x0C, 0xF0, 0x47, 0xB0, 0xC7, 0x70, 0xDF, 0x02, 0x7B, 0x0C, 0x77, 0xF9, 0x01, 0x7B, 0x0C,
  0x76, 0x01, 0xF9, 0x71, 0xB0, 0xC7, 0x60, 0x2F, 0x97, 0x1B, 0x0C, 0x76, 0x02, 0xF9, 0x71, 0xB0,
  0xC7, 0x60, 0x3F, 0x97, 0x1B, 0x0C, 0x76, 0x03, 0xF0, 0xE7, 0x1B, 0x0C, 0x76, 0x03, 0xF9, 0x71,
  0xB0, 0xC7, 0x60, 0x2F, 0x97, 0x1B, 0x0C, 0x76, 0x02, 0xF9, 0x71, 0xB0, 0xC7, 0x60, 0x1F, 0x90,
  0x17, 0xB0, 0xC7, 0x7F, 0x90, 0x27, 0xB0, 0xC7, 0x70, 0xEF, 0x04, 0x7B, 0x0C, 0x77, 0x0C, 0xF0,
  0x67, 0xB0, 0xC7, 0x70, 0xAF, 0x08, 0x7B, 0x0C, 0x77, 0x07, 0xF0, 0xB7, 0xB0, 0xC7, 0x70, 0x4F,
  0x0E, 0x7B, 0x0C, 0x77, 0x01, 0xF9, 0x03, 0x6B, 0x0C, 0x77, 0x10, 0xBF, 0x08, 0x6B, 0x0C, 0x77,
  0x10, 0x6F, 0x0D, 0x6B, 0x0C, 0x73, 0x08, 0x01, 0x30, 0x1F, 0x90, 0x55, 0xB0, 0xC7, 0x28, 0x14,
  0xF8, 0x40, 0x9F, 0x0D, 0x5B, 0x0C, 0x71, 0x82, 0x1E, 0xFD, 0x40, 0x2F, 0x90, 0x84, 0xB0, 0xC7,
  0x01, 0x0D, 0xA0, 0xE5, 0x08, 0xF9, 0x06, 0x3B, 0x0C, 0x60, 0x20, 0xDB, 0x0D, 0x60, 0xDF, 0x90,
  0x82, 0xB0, 0xC5, 0x06, 0x0E, 0xC0, 0x96, 0x02, 0x0E, 0xF9, 0x0E, 0x07, 0xB0, 0xC2, 0x81, 0x26,
  0xDE, 0x03, 0x70, 0x40, 0xEF, 0xE0, 0xD0, 0xEF, 0x90, 0x97, 0x20, 0x30, 0xEF, 0xFF, 0x0B, 0x74,
  0x01, 0x09, 0xFF, 0xD0, 0xA7, 0x70, 0x30, 0xAF, 0xF9, 0x0D, 0x05, 0x77, 0x38, 0x21, 0x6B, 0xEF,
  0x98, 0x1D, 0x94, 0x77, 0x72, 0x02, 0xB8, 0x2D, 0x53, 0x17, 0x77, 0x6B, 0x0C, 0x77, 0x77, 0x2B,
  0x0C, 0x77, 0x77, 0x2B, 0x0C, 0x77, 0x77, 0x2B, 0x0C, 0x77, 0x77, 0x2B, 0x0C, 0x77, 0x77, 0x2B,
  0x0C, 0x77, 0x77, 0x2B, 0x0C, 0x76,
  // "£" (U+00A3)
  0x77, 0x89, 0x41, 0x59, 0xBD, 0xEF, 0xED, 0xDB, 0x85, 0x17, 0x77, 0x10, 0x30, 0xAF, 0xF0, 0xA0,
  0x47, 0x74, 0x01, 0x09, 0xFF, 0xC0, 0x97, 0x72, 0x02, 0x0D, 0xFF, 0xE0, 0xC7, 0x70, 0x20, 0xEF,
  0x98, 0x3C, 0xA9, 0xAD, 0xFA, 0x0B, 0x75, 0x01, 0x0D, 0xF0, 0x70, 0x15, 0x03, 0x0C, 0xF9, 0x06,
  0x74, 0x0A, 0xE0, 0xE0, 0x37, 0x20, 0xAF, 0x0D, 0x73, 0x03, 0xF0, 0x47, 0x40, 0xDF, 0x03, 0x72,
  0x0B, 0xE0, 0xB7, 0x50, 0x6F, 0x07, 0x71, 0x02, 0xF0, 0x47, 0x60, 0xEE, 0x08, 0x71, 0x07, 0xE0,
  0xE7, 0x70, 0xBE, 0x09, 0x71, 0x0B, 0xE0, 0xA7, 0x70, 0x8E, 0x07, 0x71, 0x0E, 0xE0, 0x77, 0x70,
  0x5E, 0x03, 0x70, 0x1F, 0x05, 0x77, 0x03, 0xD0, 0xA7, 0x10, 0x2F, 0x04, 0x77, 0x03, 0xC0, 0xA7,
  0x20, 0x3F, 0x03, 0x77, 0x83, 0x1C, 0xB8, 0x37, 0x30, 0x3F, 0x03, 0x77, 0x77, 0x10, 0x3F, 0x04,
  0x77, 0x77, 0x10, 0x2F, 0x05, 0x77, 0x77, 0x10, 0x1F, 0x06, 0x77, 0x77, 0x2F, 0x07, 0x77, 0x77,
  0x20, 0xCE, 0x0A, 0x77, 0x77, 0x20, 0x9E, 0x0D, 0x77, 0x77, 0x20, 0x7F, 0x77, 0x77, 0x20, 0x3F,
  0x03, 0x77, 0x77, 0x2F, 0x07, 0x77, 0x77, 0x20, 0xBE, 0x0B, 0x77, 0x77, 0x20, 0x7F, 0x77, 0x77,
  0x20, 0x3F, 0x04, 0x77, 0x77, 0x20, 0xEE, 0x09, 0x77, 0x77, 0x20, 0x9E, 0x0E, 0x77, 0x72, 0x07,
  0xFF, 0xFE, 0x02, 0x72, 0x07, 0xFF, 0xFE, 0x02, 0x72, 0x07, 0xFF, 0xFE, 0x02, 0x72, 0x07, 0xFF,
  0xFE, 0x02, 0x72, 0x04, 0x80, 0x49, 0xF0, 0xB8, 0x07, 0x90, 0x17, 0x74, 0x0C, 0xE0, 0x77, 0x77,
  0x72, 0x08, 0xE0, 0xB7, 0x77, 0x72, 0x04, 0xE0, 0xE7, 0x77, 0x73, 0xF0, 0x37, 0x77, 0x72, 0x0C,
  0xE0, 0x57, 0x77, 0x72, 0x09, 0xE0, 0x87, 0x77, 0x72, 0x07, 0xE0, 0x97, 0x77, 0x72, 0x05, 0xE0,
  0xA7, 0x77, 0x72, 0x04, 0xE0, 0xA7, 0x77, 0x72, 0x03, 0xE0, 0x97, 0x77, 0x72, 0x04, 0xE0, 0x87,
  0x77, 0x72, 0x05, 0xE0, 0x47, 0x77, 0x72, 0x07, 0xE7, 0x77, 0x73, 0x0A, 0xD0, 0xA7, 0x77, 0x73,
  0x0D, 0xD0, 0x27, 0x77, 0x72, 0x03, 0xD0, 0x97, 0x77, 0x73, 0x09, 0xC0, 0xE0, 0x17, 0x77, 0x72,
  0x01, 0xD0, 0x47, 0x77, 0x73, 0x0A, 0xC0, 0x67, 0x77, 0x20, 0x27, 0x05, 0xC8, 0x57, 0x02, 0x56,
  0x53, 0x77, 0x30, 0x20, 0xC6, 0x02, 0x0E, 0xB8, 0x17, 0x7D, 0xD8, 0x2E, 0xA5, 0x17, 0x58, 0x13,
  0xDD, 0x50, 0x10, 0xDB, 0x0E, 0x0D, 0xFC, 0x81, 0xB6, 0x17, 0x18, 0x25, 0xEF, 0xD4, 0x02, 0x0D,
  0xFF, 0xE8, 0x6B, 0x63, 0x10, 0x15, 0xBB, 0x0D, 0x30, 0x40, 0xEF, 0xFF, 0xFC, 0x0C, 0x20, 0x8F,
  0xFF, 0xFE, 0x81, 0x30, 0x2F, 0x98, 0x2E, 0xDD, 0xEF, 0xFF, 0x90, 0x52, 0x02, 0xC8, 0x2E, 0x95,
  0x14, 0x82, 0x15, 0x9E, 0xFF, 0xB0, 0x63, 0x02, 0xA0, 0xD0, 0x67, 0x50, 0x50, 0xCF, 0xF0, 0x64,
  0x81, 0x2E, 0x67, 0x72, 0x81, 0x28, 0xDF, 0xA0, 0xD0, 0x36, 0x01, 0x77, 0x68, 0x73, 0x7B, 0xDE,
  0xFD, 0xA5, 0x60,
  // "¤" (U+00A4)
  0x20, 0x10, 0x67, 0x77, 0x40, 0x85, 0x81, 0xCF, 0x57, 0x77, 0x28, 0x19, 0xFB, 0x30, 0xBB, 0x03,
  0x77, 0x70, 0x7B, 0x81, 0xA0, 0xAC, 0x0E, 0x02, 0x58, 0x75, 0x9C, 0xEF, 0xDC, 0x84, 0x50, 0x5D,
  0x00, 0x8D, 0x0D, 0x01, 0x20, 0x70, 0xEF, 0xA0, 0xC0, 0x52, 0x03, 0xE8, 0x15, 0x0A, 0xD8, 0x1B,
  0x3D, 0xFE, 0x81, 0xA3, 0xED, 0x08, 0x30, 0xCF, 0xFF, 0xE0, 0xA4, 0x01, 0x0E, 0xFB, 0x83, 0xDA,
  0x9B, 0xDF, 0xB0, 0xC6, 0x03, 0xF9, 0x09, 0x02, 0x50, 0x30, 0xAF, 0x0D, 0x01, 0x70, 0x6D, 0x0E,
  0x03, 0x72, 0x05, 0x0E, 0xD0, 0x27, 0x10, 0x7C, 0x0E, 0x02, 0x74, 0x04, 0x0E, 0xC0, 0x57, 0x10,
  0xEC, 0x04, 0x76, 0x06, 0xC0, 0xD7, 0x06, 0xC0, 0x97, 0x71, 0x0B, 0xC0, 0x46, 0x0C, 0xC0, 0x17,
  0x71, 0x03, 0xC0, 0x95, 0x01, 0xC0, 0xA7, 0x73, 0x0C, 0xB0, 0xE5, 0x04, 0xC0, 0x57, 0x73, 0x07,
  0xC0, 0x24, 0x07, 0xC0, 0x17, 0x73, 0x03, 0xC0, 0x54, 0x09, 0xB0, 0xE7, 0x74, 0x01, 0xC0, 0x64,
  0x0A, 0xB0, 0xD7, 0x75, 0xC0, 0x74, 0x0A, 0xB0, 0xC7, 0x75, 0xC0, 0x84, 0x09, 0xB0, 0xD7, 0x75,
  0xC0, 0x74, 0x09, 0xB0, 0xE7, 0x74, 0x02, 0xC0, 0x64, 0x07, 0xC0, 0x27, 0x73, 0x04, 0xC0, 0x44,
  0x04, 0xC0, 0x67, 0x73, 0x09, 0xC0, 0x14, 0x01, 0xC0, 0xC7, 0x73, 0x0E, 0xB0, 0xD6, 0x0B, 0xC0,
  0x47, 0x71, 0x06, 0xC0, 0x86, 0x06, 0xC0, 0xC7, 0x70, 0x10, 0xDC, 0x03, 0x70, 0xEC, 0x09, 0x76,
  0x0A, 0xC0, 0xC7, 0x10, 0x7D, 0x07, 0x74, 0x09, 0xD0, 0x47, 0x10, 0x8E, 0x0A, 0x01, 0x70, 0x10,
  0xBE, 0x04, 0x70, 0x5F, 0x98, 0x7E, 0x83, 0x10, 0x14, 0x9E, 0xF0, 0xE0, 0x25, 0x03, 0xFF, 0xFD,
  0x0D, 0x01, 0x30, 0x20, 0xED, 0x0E, 0xFF, 0x90, 0xDD, 0x0C, 0x20, 0x10, 0xDD, 0x81, 0x90, 0x8F,
  0xD8, 0x2E, 0x60, 0xAD, 0x81, 0xB0, 0xBD, 0x0B, 0x38, 0x12, 0x9E, 0xF8, 0x1D, 0x71, 0x30, 0xCD,
  0x08, 0x07, 0xC0, 0xD0, 0x16, 0x85, 0x36, 0x88, 0x76, 0x26, 0x01, 0x0D, 0xC8, 0x14, 0x08, 0xA0,
  0xE0, 0x27, 0x77, 0x02, 0x0E, 0xA0, 0x53, 0x81, 0xAE, 0x37, 0x77, 0x28, 0x14, 0xF7, 0x50, 0x37,
  0x77, 0x40, 0x33,
  // "¥" (U+00A5)
  0x09, 0xFF, 0xC0, 0x57, 0x08, 0xFF, 0x07, 0x09, 0xFF, 0xC0, 0x57, 0x08, 0xFF, 0x07, 0x09, 0xFF,
  0xC0, 0x57, 0x08, 0xFF, 0x07, 0x09, 0xFF, 0xC0, 0x57, 0x08, 0xFF, 0x83, 0x70, 0x14, 0xCF, 0xC8,
  0x1B, 0x41, 0x74, 0x81, 0x27, 0xEF, 0x0C, 0x04, 0x60, 0xDF, 0xA0, 0xC7, 0x72, 0x03, 0xE0, 0xD0,
  0x17, 0x03, 0xFA, 0x07, 0x77, 0x30, 0xCD, 0x05, 0x72, 0x0A, 0xF9, 0x06, 0x77, 0x30, 0xBC, 0x0C,
  0x73, 0x03, 0xF9, 0x08, 0x77, 0x30, 0xCC, 0x05, 0x74, 0x0C, 0xF0, 0xC7, 0x73, 0xC0, 0xD7, 0x50,
  0x5F, 0x90, 0x27, 0x71, 0x04, 0xC0, 0x77, 0x60, 0xEF, 0x07, 0x77, 0x10, 0xAB, 0x0E, 0x01, 0x76,
  0x07, 0xF0, 0xC7, 0x71, 0x0E, 0xB0, 0x97, 0x70, 0x1F, 0x90, 0x37, 0x60, 0x5C, 0x02, 0x77, 0x10,
  0xAF, 0x09, 0x76, 0x0B, 0xB0, 0xB7, 0x72, 0x03, 0xF0, 0xE7, 0x50, 0x1C, 0x04, 0x77, 0x30, 0xCF,
  0x05, 0x74, 0x07, 0xB0, 0xD7, 0x74, 0x06, 0xF0, 0xB7, 0x40, 0xDB, 0x07, 0x77, 0x50, 0xEF, 0x02,
  0x72, 0x05, 0xB0, 0xE0, 0x17, 0x75, 0x08, 0xF0, 0x87, 0x20, 0xBB, 0x09, 0x77, 0x60, 0x1F, 0x0E,
  0x71, 0x02, 0xC0, 0x27, 0x77, 0x0A, 0xF0, 0x57, 0x08, 0xB0, 0xB7, 0x77, 0x10, 0x4F, 0x0A, 0x70,
  0xEB, 0x04, 0x77, 0x72, 0x0C, 0xF0, 0x15, 0x05, 0xB0, 0xD7, 0x77, 0x30, 0x6F, 0x06, 0x50, 0xBB,
  0x07, 0x77, 0x74, 0x0E, 0xE0, 0xB4, 0x02, 0xB0, 0xE0, 0x17, 0x77, 0x40, 0x8F, 0x02, 0x30, 0x9B,
  0x09, 0x77, 0x75, 0x02, 0xF0, 0x73, 0x0E, 0xB0, 0x27, 0x77, 0x60, 0xBE, 0x0C, 0x20, 0x6B, 0x0B,
  0x77, 0x77, 0x04, 0xF8, 0x12, 0x0D, 0xB0, 0x47, 0x77, 0x71, 0x0D, 0xE0, 0x60, 0x3B, 0x0D, 0x77,
  0x77, 0x20, 0x6E, 0x0B, 0x09, 0xB0, 0x77, 0x77, 0x73, 0x0E, 0xE0, 0xEA, 0x0E, 0x01, 0x77, 0x70,
  0x1F, 0xFF, 0xF9, 0x09, 0x75, 0x01, 0xFF, 0xFF, 0x90, 0x97, 0x50, 0x1F, 0xFF, 0xF9, 0x09, 0x75,
  0x01, 0xFF, 0xFF, 0x90, 0x97, 0x68, 0x06, 0x90, 0xBF, 0x0E, 0x80, 0x69, 0x05, 0x77, 0x72, 0x05,
  0xF0, 0xC7, 0x77, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x76, 0x05, 0xF0,
  0xC7, 0x77, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x20, 0x1F, 0xFF, 0xF9,
  0x09, 0x75, 0x01, 0xFF, 0xFF, 0x90, 0x97, 0x50, 0x1F, 0xFF, 0xF9, 0x09, 0x75, 0x01, 0xFF, 0xFF,
  0x90, 0x97, 0x68, 0x06, 0x90, 0xBF, 0x0E, 0x80, 0x69, 0x05, 0x77, 0x72, 0x05, 0xF0, 0xC7, 0x77,
  0x76, 0x05, 0xF0, 0xC7, 0x77, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x76,
  0x05, 0xF0, 0xC7, 0x77, 0x76, 0x06, 0xF0, 0xD7, 0x77, 0x76, 0x07, 0xF0, 0xE7, 0x77, 0x76, 0x0A,
  0xF9, 0x02, 0x77, 0x77, 0x40, 0x10, 0xEF, 0x90, 0x77, 0x77, 0x74, 0x0B, 0xFB, 0x04, 0x77, 0x77,
  0x81, 0x27, 0xDF, 0xD8, 0x1A, 0x41, 0x77, 0x71, 0xFF, 0xFA, 0x07, 0x77, 0x5F, 0xFF, 0xA0, 0x77,
  0x75, 0xFF, 0xFA, 0x07, 0x77, 0x5F, 0xFF, 0xA0, 0x77, 0x20,
  // "¦" (U+00A6)
  0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0,
  0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC,
  0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D,
  0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0x80, 0x9A, 0x10, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0,
  0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC,
  0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D,
  0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D, 0xC0, 0xDC, 0x0D,
  // "§" (U+00A7)
  0x74, 0x89, 0x22, 0x6A, 0xCD, 0xFE, 0xDD, 0xA7, 0x37, 0x75, 0x03, 0x0B, 0xFD, 0x0D, 0x06, 0x77,
  0x20, 0xAF, 0xFA, 0x0B, 0x01, 0x75, 0x02, 0x0D, 0xFF, 0xC0, 0xD0, 0x17, 0x30, 0x10, 0xEF, 0x83,
  0xCA, 0x9A, 0xDF, 0x90, 0xC7, 0x30, 0xCD, 0x81, 0xE8, 0x15, 0x03, 0x0B, 0xF0, 0x77, 0x10, 0x8D,
  0x0D, 0x02, 0x72, 0x0A, 0xE0, 0xE7, 0x01, 0x0E, 0xC0, 0xE0, 0x27, 0x40, 0xDE, 0x03, 0x60, 0x7D,
  0x07, 0x75, 0x05, 0xE0, 0x56, 0x0C, 0xC0, 0xE7, 0x70, 0xED, 0x06, 0x6D, 0x0A, 0x77, 0x09, 0xD0,
  0x55, 0x04, 0xD0, 0x77, 0x70, 0x5D, 0x02, 0x50, 0x5D, 0x05, 0x77, 0x02, 0xC0, 0xA6, 0x06, 0xD0,
  0x57, 0x70, 0x1B, 0x0B, 0x01, 0x60, 0x7D, 0x05, 0x77, 0x18, 0x1A, 0x84, 0x71, 0x07, 0xD0, 0x77,
  0x77, 0x50, 0x6D, 0x0A, 0x77, 0x75, 0x05, 0xD0, 0xE7, 0x77, 0x50, 0x2E, 0x06, 0x77, 0x75, 0x0E,
  0xD0, 0xE0, 0x17, 0x77, 0x40, 0xAE, 0x0C, 0x77, 0x74, 0x04, 0xF0, 0xC0, 0x17, 0x77, 0x30, 0xDF,
  0x0E, 0x04, 0x77, 0x72, 0x05, 0xFA, 0x09, 0x01, 0x77, 0x71, 0x0D, 0xFA, 0x0E, 0x06, 0x77, 0x60,
  0x6F, 0xD0, 0xC0, 0x47, 0x73, 0x06, 0xFF, 0x90, 0xA0, 0x27, 0x70, 0x20, 0xEB, 0x00, 0x9F, 0xC0,
  0xE0, 0x77, 0x60, 0xBB, 0x0E, 0x20, 0x6F, 0xD0, 0xD0, 0x37, 0x30, 0x3C, 0x08, 0x30, 0x20, 0xCF,
  0xD0, 0x87, 0x20, 0x9C, 0x03, 0x50, 0x8F, 0xD0, 0xC0, 0x17, 0x0E, 0xC0, 0x16, 0x02, 0x0B, 0xFC,
  0x0E, 0x03, 0x50, 0x1D, 0x72, 0x05, 0x0E, 0xFC, 0x04, 0x40, 0x2D, 0x73, 0x01, 0x09, 0xFC, 0x04,
  0x30, 0x3D, 0x02, 0x74, 0x03, 0x0C, 0xFA, 0x0E, 0x02, 0x20, 0x3D, 0x05, 0x76, 0x07, 0xFA, 0x0C,
  0x20, 0x1D, 0x0B, 0x77, 0x03, 0x0D, 0xF9, 0x06, 0x2E, 0x03, 0x77, 0x01, 0x0C, 0xF0, 0xD2, 0x0B,
  0xD0, 0xD0, 0x17, 0x71, 0x0C, 0xF8, 0x13, 0x07, 0xE0, 0xC7, 0x71, 0x01, 0x0D, 0xE8, 0x17, 0x01,
  0xF0, 0xC0, 0x17, 0x70, 0x4E, 0x09, 0x20, 0x9F, 0x0E, 0x04, 0x77, 0x0B, 0xD0, 0xB2, 0x01, 0x0E,
  0xF9, 0x09, 0x76, 0x06, 0xD0, 0xC3, 0x03, 0xFA, 0x0D, 0x04, 0x74, 0x02, 0xD0, 0xB4, 0x05, 0xFB,
  0x0A, 0x01, 0x73, 0xD0, 0xA5, 0x05, 0xFB, 0x0E, 0x07, 0x72, 0xD0, 0x76, 0x03, 0x0E, 0xFB, 0x0C,
  0x02, 0x7D, 0x03, 0x70, 0x10, 0xBF, 0xC0, 0x65, 0x01, 0xC0, 0xE7, 0x30, 0x7F, 0xC0, 0xA0, 0x13,
  0x04, 0xC0, 0x87, 0x40, 0x20, 0xCF, 0xB0, 0xD0, 0x32, 0x07, 0xB0, 0xE0, 0x17, 0x60, 0x60, 0xEF,
  0xB8, 0x15, 0x0C, 0xB0, 0x77, 0x71, 0x01, 0x09, 0xFB, 0x09, 0xB0, 0xD7, 0x74, 0x03, 0x0C, 0xFD,
  0x04, 0x77, 0x60, 0x7F, 0xB0, 0x87, 0x77, 0x10, 0x20, 0xCF, 0x90, 0xA7, 0x77, 0x30, 0x9F, 0x90,
  0x37, 0x77, 0x30, 0x7F, 0x0A, 0x77, 0x74, 0x06, 0xF0, 0x17, 0x77, 0x40, 0x7E, 0x06, 0x77, 0x75,
  0x0B, 0xD0, 0x97, 0x77, 0x50, 0x3D, 0x0B, 0x77, 0x76, 0x0D, 0xC0, 0xD7, 0x81, 0x7C, 0x67, 0x73,
  0x09, 0xC0, 0xD5, 0x02, 0x0D, 0xA0, 0x87, 0x73, 0x07, 0xC0, 0xD5, 0x0D, 0xB0, 0x97, 0x73, 0x05,
  0xC0, 0xD4, 0x04, 0xC0, 0xC7, 0x73, 0x05, 0xC0, 0xB4, 0x08, 0xD7, 0x73, 0x06, 0xC0, 0x94, 0x0A,
  0xD0, 0x47, 0x72, 0x09, 0xC0, 0x64, 0x0A, 0xD0, 0x97, 0x72, 0x0C, 0xC0, 0x24, 0x09, 0xE0, 0x17,
  0x70, 0x3C, 0x0D, 0x50, 0x7E, 0x0A, 0x77, 0x0A, 0xC0, 0x75, 0x03, 0xF0, 0x67, 0x50, 0x6C, 0x0E,
  0x01, 0x60, 0xEF, 0x05, 0x73, 0x05, 0xD0, 0x77, 0x06, 0xF9, 0x0A, 0x03, 0x60, 0x30, 0xBD, 0x0C,
  0x72, 0x0C, 0xFA, 0x84, 0xDA, 0x99, 0xBE, 0xE0, 0xD0, 0x27, 0x20, 0x10, 0xCF, 0xFD, 0x0D, 0x02,
  0x74, 0x01, 0x09, 0xFF, 0xB0, 0xB0, 0x17, 0x70, 0x40, 0xAF, 0xE0, 0xC0, 0x47, 0x74, 0x89, 0x31,
  0x58, 0xBD, 0xEE, 0xFE, 0xDA, 0x72, 0x74,
  // "¨" (U+00A8)
  0x18, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x42, 0x01, 0x0E, 0xD0, 0x37, 0x0D, 0xD8,
  0x15, 0x08, 0xE0, 0xB6, 0x06, 0xE8, 0x1D, 0x0C, 0xF6, 0x0A, 0xF0, 0x20, 0xEF, 0x02, 0x50, 0xBF,
  0x04, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x40, 0xCF, 0x60, 0xAF, 0x02, 0x09, 0xE0, 0xC6, 0x07, 0xE8,
  0x2E, 0x02, 0xED, 0x04, 0x60, 0x10, 0xDD, 0x06, 0x28, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E,
  0xFC, 0x52,
  // "©" (U+00A9)
  0x77, 0x78, 0x52, 0x69, 0xBD, 0xEE, 0xA8, 0x4E, 0xDB, 0x96, 0x38, 0x0C, 0x30, 0x81, 0x49, 0xEF,
  0xF9, 0x81, 0xEA, 0x47, 0x77, 0x76, 0x06, 0x0D, 0xFF, 0xF0, 0xD0, 0x77, 0x77, 0x72, 0x04, 0x0D,
  0xFF, 0xFC, 0x0E, 0x05, 0x77, 0x76, 0x0A, 0xFB, 0x87, 0xEC, 0xBA, 0x9A, 0xBC, 0xDF, 0xB0, 0xB0,
  0x17, 0x77, 0x20, 0x20, 0xDF, 0x82, 0xE9, 0x52, 0x72, 0x82, 0x14, 0x8D, 0xF0, 0xD0, 0x37, 0x77,
  0x04, 0x0E, 0xE0, 0xB0, 0x57, 0x73, 0x03, 0x0A, 0xF0, 0x57, 0x75, 0x04, 0xE0, 0xC0, 0x47, 0x77,
  0x03, 0x0B, 0xE0, 0x57, 0x73, 0x04, 0xE0, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x10, 0x30, 0xEC,
  0x0E, 0x04, 0x77, 0x76, 0x03, 0x0D, 0xD0, 0x37, 0x70, 0xDC, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x10,
  0xCC, 0x0D, 0x01, 0x75, 0x09, 0xC0, 0xD0, 0x27, 0x38, 0x93, 0x15, 0x9B, 0xDE, 0xFE, 0xDC, 0x96,
  0x17, 0x10, 0x10, 0xDC, 0x0A, 0x74, 0x05, 0xC0, 0xE0, 0x27, 0x20, 0x20, 0xAF, 0xE0, 0xA0, 0x27,
  0x01, 0x0E, 0xC0, 0x57, 0x30, 0xDC, 0x05, 0x72, 0x08, 0xFF, 0xA0, 0xE0, 0x57, 0x04, 0xC0, 0xE7,
  0x20, 0x7C, 0x09, 0x71, 0x01, 0x0C, 0xFF, 0xD0, 0x57, 0x09, 0xC0, 0x77, 0x01, 0x0E, 0xB0, 0xE7,
  0x10, 0x10, 0xDE, 0x81, 0xA5, 0x23, 0x81, 0x26, 0xCE, 0x02, 0x70, 0xEB, 0x0E, 0x01, 0x60, 0x7C,
  0x06, 0x71, 0x0B, 0xD0, 0xA0, 0x17, 0x20, 0x6D, 0x0B, 0x70, 0x6C, 0x07, 0x60, 0xDB, 0x0D, 0x71,
  0x07, 0xD0, 0x77, 0x50, 0x6D, 0x02, 0x70, 0xDB, 0x0D, 0x50, 0x4C, 0x06, 0x70, 0x1D, 0x09, 0x77,
  0x0C, 0xC0, 0x67, 0x06, 0xC0, 0x44, 0x0A, 0xC0, 0x17, 0x09, 0xC0, 0xD7, 0x71, 0x05, 0xC0, 0x87,
  0x01, 0xC0, 0xA4, 0x0E, 0xB0, 0xA7, 0x01, 0xD0, 0x67, 0x71, 0x01, 0xC0, 0x77, 0x10, 0xAB, 0x0E,
  0x30, 0x3C, 0x04, 0x70, 0x7C, 0x0E, 0x77, 0x30, 0xCB, 0x02, 0x71, 0x04, 0xC0, 0x32, 0x07, 0xC7,
  0x10, 0xCC, 0x08, 0x77, 0x30, 0xBA, 0x08, 0x73, 0xC0, 0x72, 0x0B, 0xB0, 0xB7, 0x01, 0xD0, 0x47,
  0x73, 0x81, 0x8B, 0x57, 0x40, 0xCB, 0x0B, 0x2C, 0x07, 0x70, 0x5C, 0x0E, 0x77, 0x77, 0x40, 0x8B,
  0x81, 0xE0, 0x1C, 0x04, 0x70, 0x8C, 0x0B, 0x77, 0x77, 0x40, 0x5C, 0x01, 0x04, 0xC0, 0x27, 0x0B,
  0xC0, 0x97, 0x77, 0x74, 0x02, 0xC0, 0x40, 0x6C, 0x71, 0x0D, 0xC0, 0x77, 0x77, 0x75, 0xC0, 0x60,
  0x8B, 0x0D, 0x71, 0xD0, 0x57, 0x77, 0x75, 0x0D, 0xB0, 0x80, 0x9B, 0x0C, 0x71, 0xD0, 0x47, 0x77,
  0x75, 0x0C, 0xB0, 0x90, 0xAB, 0x0B, 0x70, 0x1D, 0x03, 0x77, 0x77, 0x50, 0xBB, 0x09, 0x0A, 0xB0,
  0xA7, 0x02, 0xD0, 0x27, 0x77, 0x75, 0x0B, 0xB0, 0xA0, 0xBB, 0x0A, 0x70, 0x2D, 0x02, 0x77, 0x77,
  0x50, 0xAB, 0x00, 0xBB, 0x0A, 0x70, 0x2D, 0x02, 0x77, 0x77, 0x50, 0xAB, 0x0B, 0x0A, 0xB0, 0xB7,
  0x01, 0xD0, 0x27, 0x77, 0x75, 0x0B, 0xB0, 0x0A, 0xB0, 0xB7, 0x01, 0xD0, 0x37, 0x77, 0x75, 0x0B,
  0xB0, 0x09, 0xB0, 0xC7, 0x1D, 0x04, 0x77, 0x77, 0x50, 0xCB, 0x09, 0x08, 0xB0, 0xD7, 0x10, 0xEC,
  0x06, 0x77, 0x77, 0x50, 0xEB, 0x08, 0x06, 0xC7, 0x10, 0xCC, 0x08, 0x77, 0x77, 0x5C, 0x06, 0x04,
  0xC0, 0x27, 0x09, 0xC0, 0xB7, 0x77, 0x74, 0x02, 0xC0, 0x30, 0x1C, 0x05, 0x70, 0x7C, 0x0E, 0x77,
  0x77, 0x40, 0x5C, 0x81, 0x10, 0xEB, 0x08, 0x70, 0x3D, 0x02, 0x77, 0x77, 0x30, 0x8B, 0x0E, 0x20,
  0xBB, 0x0C, 0x71, 0x0E, 0xC0, 0x77, 0x77, 0x73, 0x0C, 0xB0, 0xB2, 0x07, 0xC0, 0x17, 0x0A, 0xC0,
  0xC7, 0x75, 0x01, 0x74, 0xC0, 0x72, 0x03, 0xC0, 0x57, 0x05, 0xD0, 0x37, 0x74, 0x0E, 0x07, 0x72,
  0x04, 0xC0, 0x33, 0x0E, 0xB0, 0xB7, 0x10, 0xEC, 0x0B, 0x77, 0x30, 0x8A, 0x01, 0x71, 0x0A, 0xB0,
  0xE4, 0x09, 0xC0, 0x17, 0x07, 0xD0, 0x57, 0x71, 0x02, 0xB0, 0x27, 0x01, 0xC0, 0xA4, 0x03, 0xC0,
  0x77, 0x10, 0xEC, 0x0E, 0x02, 0x77, 0x0D, 0xB7, 0x10, 0x6C, 0x04, 0x50, 0xDB, 0x0E, 0x71, 0x05,
  0xD0, 0xD0, 0x27, 0x50, 0xBB, 0x0B, 0x71, 0x0D, 0xB0, 0xD6, 0x07, 0xC0, 0x87, 0x10, 0x9D, 0x0E,
  0x05, 0x72, 0x03, 0x0D, 0xC0, 0x47, 0x06, 0xC0, 0x77, 0x0E, 0xB0, 0xE0, 0x17, 0x10, 0xBE, 0x87,
  0xC7, 0x31, 0x01, 0x26, 0xBD, 0x09, 0x71, 0x0D, 0xB0, 0xE0, 0x17, 0x07, 0xC0, 0xB7, 0x20, 0xBF,
  0xFC, 0x0B, 0x71, 0x09, 0xC0, 0x77, 0x20, 0xDC, 0x06, 0x72, 0x07, 0xFF, 0xA0, 0x87, 0x10, 0x4C,
  0x0E, 0x73, 0x05, 0xD0, 0x37, 0x20, 0x20, 0xAF, 0xD0, 0xB0, 0x37, 0x10, 0x10, 0xEC, 0x05, 0x74,
  0x0A, 0xC0, 0xE0, 0x27, 0x38, 0x31, 0x69, 0xCE, 0xA8, 0x3E, 0xDA, 0x72, 0x72, 0x01, 0x0D, 0xC0,
  0xA7, 0x60, 0xDC, 0x0E, 0x02, 0x77, 0x77, 0x10, 0x10, 0xCC, 0x0D, 0x01, 0x76, 0x03, 0xD0, 0xE0,
  0x47, 0x77, 0x60, 0x20, 0xDD, 0x03, 0x77, 0x10, 0x4E, 0x08, 0x77, 0x74, 0x05, 0x0E, 0xD0, 0x57,
  0x73, 0x05, 0xE0, 0xD0, 0x57, 0x77, 0x02, 0x0B, 0xE0, 0x57, 0x75, 0x05, 0x0E, 0xE0, 0xB0, 0x57,
  0x73, 0x03, 0x09, 0xF0, 0x57, 0x77, 0x02, 0x0D, 0xF8, 0x2E, 0x95, 0x27, 0x28, 0x21, 0x47, 0xDF,
  0x0D, 0x03, 0x77, 0x72, 0x01, 0x0A, 0xFB, 0x87, 0xEC, 0xBA, 0x99, 0xAB, 0xDF, 0xB0, 0xB0, 0x17,
  0x77, 0x50, 0x50, 0xDF, 0xFF, 0xC0, 0xD0, 0x57, 0x77, 0x72, 0x06, 0x0D, 0xFF, 0xF0, 0xD0, 0x67,
  0x77, 0x76, 0x81, 0x49, 0xEF, 0xF9, 0x81, 0xE9, 0x48, 0x0C, 0x30, 0x84, 0x36, 0x9B, 0xDE, 0xB8,
  0x4E, 0xDB, 0x96, 0x37, 0x77,
  // "ª" (U+00AA)
  0x78, 0x91, 0x15, 0x8A, 0xBB, 0xBA, 0x85, 0x17, 0x70, 0x40, 0xBF, 0xC0, 0xA0, 0x27, 0x40, 0xAF,
  0xF9, 0x06, 0x72, 0x09, 0xD8, 0x4E, 0x51, 0x01, 0x7E, 0x04, 0x70, 0x1E, 0x03, 0x50, 0x5D, 0x0D,
  0x70, 0x4D, 0x0C, 0x70, 0xED, 0x04, 0x60, 0x3D, 0x08, 0x70, 0x9D, 0x08, 0x70, 0xCC, 0x06, 0x70,
  0x6D, 0x0B, 0x78, 0x11, 0x8D, 0xA0, 0x47, 0x05, 0xD0, 0xC7, 0x40, 0x17, 0x10, 0x4D, 0x0D, 0x77,
  0x60, 0x4D, 0x0E, 0x77, 0x60, 0x4D, 0x0E, 0x74, 0x89, 0x03, 0x68, 0xAB, 0xBC, 0xCC, 0xDD, 0x0E,
  0x71, 0x81, 0x18, 0xDF, 0xF9, 0x0E, 0x70, 0x50, 0xEF, 0xFB, 0x0E, 0x60, 0x6E, 0x82, 0xE8, 0x41,
  0x30, 0x4D, 0x0E, 0x50, 0x2E, 0x0C, 0x01, 0x60, 0x4D, 0x0E, 0x50, 0xAD, 0x0E, 0x01, 0x70, 0x4D,
  0x0E, 0x50, 0xED, 0x09, 0x71, 0x04, 0xD0, 0xE4, 0x03, 0xE0, 0x57, 0x10, 0x4D, 0x0E, 0x40, 0x4E,
  0x02, 0x71, 0x05, 0xD0, 0xE4, 0x05, 0xE0, 0x17, 0x10, 0x7D, 0x0E, 0x40, 0x5E, 0x01, 0x71, 0x0A,
  0xD0, 0xE4, 0x03, 0xE0, 0x37, 0x10, 0xED, 0x0E, 0x5E, 0x06, 0x70, 0x7F, 0x50, 0xBD, 0x0C, 0x68,
  0x23, 0xEF, 0xBD, 0x02, 0x40, 0x5E, 0x09, 0x01, 0x38, 0x36, 0xEF, 0x63, 0xD0, 0xB0, 0x14, 0x0B,
  0xF0, 0xC0, 0xDB, 0x08, 0x20, 0xEE, 0x0C, 0x03, 0x20, 0x10, 0xCF, 0xB0, 0x63, 0x09, 0xF0, 0x44,
  0x07, 0x0E, 0xE0, 0xB0, 0x34, 0x05, 0xF0, 0x46, 0x84, 0x46, 0x76, 0x41, 0x77, 0x10,
  // "«" (U+00AB)
  0x74, 0x07, 0xB0, 0x77, 0x03, 0xB0, 0x97, 0x30, 0x3B, 0x0E, 0x70, 0x10, 0xDB, 0x02, 0x72, 0x01,
  0x0D, 0xB0, 0x77, 0x0B, 0xB0, 0xA7, 0x30, 0xAB, 0x0E, 0x01, 0x60, 0x7C, 0x03, 0x72, 0x07, 0xC0,
  0x86, 0x04, 0xC0, 0xB7, 0x20, 0x3D, 0x01, 0x50, 0x10, 0xEC, 0x03, 0x71, 0x01, 0x0D, 0xC0, 0x96,
  0x0B, 0xC0, 0xC7, 0x20, 0xAD, 0x02, 0x50, 0x8D, 0x04, 0x71, 0x06, 0xD0, 0xA5, 0x04, 0xD0, 0xD7,
  0x10, 0x3E, 0x03, 0x40, 0x10, 0xED, 0x05, 0x71, 0x0D, 0xD0, 0xB5, 0x0C, 0xD0, 0xD7, 0x10, 0xAE,
  0x04, 0x40, 0x8E, 0x06, 0x70, 0x6E, 0x0C, 0x40, 0x5E, 0x0E, 0x70, 0x3F, 0x05, 0x30, 0x20, 0xEE,
  0x07, 0x70, 0xDE, 0x0D, 0x40, 0xCE, 0x0E, 0x01, 0x60, 0x9F, 0x06, 0x30, 0x8F, 0x08, 0x70, 0xCE,
  0x0E, 0x40, 0xBF, 0x01, 0x70, 0xCE, 0x0D, 0x40, 0xBE, 0x0E, 0x01, 0x70, 0xAF, 0x05, 0x30, 0x9F,
  0x07, 0x70, 0x10, 0xDE, 0x0C, 0x40, 0xDE, 0x0E, 0x71, 0x03, 0xF0, 0x43, 0x02, 0x0E, 0xE0, 0x77,
  0x10, 0x7E, 0x0C, 0x40, 0x5E, 0x0E, 0x72, 0x0B, 0xE0, 0x44, 0x09, 0xE0, 0x67, 0x10, 0x10, 0xDD,
  0x0B, 0x50, 0xCD, 0x0D, 0x72, 0x03, 0xE0, 0x34, 0x02, 0x0E, 0xD0, 0x57, 0x20, 0x7D, 0x0A, 0x50,
  0x5D, 0x0C, 0x73, 0x0B, 0xD0, 0x25, 0x08, 0xD0, 0x47, 0x20, 0x10, 0xDC, 0x09, 0x60, 0xCC, 0x0B,
  0x73, 0x03, 0xD0, 0x15, 0x01, 0x0E, 0xC0, 0x37, 0x30, 0x7C, 0x08, 0x60, 0x4C, 0x0B, 0x74, 0x0B,
  0xB0, 0xE0, 0x16, 0x07, 0xC0, 0x27, 0x30, 0x10, 0xDB, 0x07, 0x70, 0xBB, 0x0A, 0x74, 0x03, 0xB0,
  0xE7, 0x01, 0x0D, 0xB0, 0x27, 0x40, 0x7B, 0x07, 0x70, 0x3B, 0x09,
  // "¬" (U+00AC)
  0x04, 0x80, 0xB4, 0x90, 0x40, 0x7F, 0xFF, 0xFC, 0x06, 0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF,
  0xFC, 0x06, 0x07, 0xFF, 0xFF, 0xC0, 0x67, 0x77, 0x70, 0xCC, 0x06, 0x77, 0x77, 0x0C, 0xC0, 0x67,
  0x77, 0x70, 0xCC, 0x06, 0x77, 0x77, 0x0C, 0xC0, 0x67, 0x77, 0x70, 0xCC, 0x06, 0x77, 0x77, 0x0C,
  0xC0, 0x67, 0x77, 0x70, 0xCC, 0x06, 0x77, 0x77, 0x0C, 0xC0, 0x67, 0x77, 0x70, 0xCC, 0x06, 0x77,
  0x77, 0x0C, 0xC0, 0x67, 0x77, 0x70, 0xCC, 0x06, 0x77, 0x77, 0x0C, 0xC0, 0x67, 0x77, 0x70, 0xCC,
  0x06, 0x77, 0x77, 0x0C, 0xC0, 0x67, 0x77, 0x70, 0xCC, 0x06, 0x77, 0x77, 0x0C, 0xC0, 0x67, 0x77,
  0x70, 0xCC, 0x06, 0x77, 0x77, 0x0C, 0xC0, 0x67, 0x77, 0x78, 0x45, 0x77, 0x77, 0x30,
  // "®" (U+00AE)
  0x77, 0x78, 0x52, 0x69, 0xBD, 0xEE, 0xA8, 0x4E, 0xDB, 0x96, 0x38, 0x0C, 0x30, 0x81, 0x49, 0xEF,
  0xF9, 0x81, 0xEA, 0x47, 0x77, 0x76, 0x06, 0x0D, 0xFF, 0xF0, 0xD0, 0x77, 0x77, 0x72, 0x04, 0x0D,
  0xFF, 0xFC, 0x0E, 0x05, 0x77, 0x76, 0x0A, 0xFB, 0x87, 0xEC, 0xBA, 0x9A, 0xBC, 0xDF, 0xB0, 0xB0,
  0x17, 0x77, 0x20, 0x20, 0xDF, 0x82, 0xE9, 0x52, 0x72, 0x82, 0x14, 0x8D, 0xF0, 0xD0, 0x37, 0x77,
  0x04, 0x0E, 0xE0, 0xB0, 0x57, 0x73, 0x03, 0x0A, 0xF0, 0x57, 0x75, 0x04, 0xE0, 0xC0, 0x47, 0x77,
  0x03, 0x0B, 0xE0, 0x57, 0x73, 0x04, 0xE0, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x10, 0x30, 0xEC,
  0x0E, 0x04, 0x77, 0x76, 0x03, 0x0D, 0xD0, 0x37, 0x70, 0xDC, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x10,
  0xCC, 0x0D, 0x01, 0x75, 0x09, 0xC0, 0xD0, 0x27, 0x77, 0x73, 0x01, 0x0D, 0xC0, 0xA7, 0x40, 0x5C,
  0x0E, 0x02, 0x77, 0x77, 0x50, 0x10, 0xEC, 0x05, 0x73, 0x0D, 0xC0, 0x57, 0x77, 0x77, 0x04, 0xC0,
  0xE7, 0x20, 0x7C, 0x09, 0x40, 0x9F, 0xE8, 0x4E, 0xED, 0xB8, 0x57, 0x60, 0x9C, 0x07, 0x70, 0x10,
  0xEB, 0x0E, 0x50, 0x9F, 0xFD, 0x81, 0xE9, 0x27, 0x40, 0xEB, 0x0E, 0x01, 0x60, 0x7C, 0x06, 0x58,
  0x25, 0x8A, 0xEF, 0xFD, 0x07, 0x73, 0x06, 0xC0, 0x76, 0x0D, 0xB0, 0xD7, 0x30, 0x9D, 0x05, 0x48,
  0x22, 0x48, 0xED, 0x08, 0x73, 0x0D, 0xB0, 0xD5, 0x04, 0xC0, 0x67, 0x30, 0x1D, 0x05, 0x71, 0x09,
  0xD0, 0x57, 0x20, 0x6C, 0x04, 0x40, 0xAC, 0x01, 0x74, 0xD0, 0x57, 0x20, 0xBC, 0x0D, 0x72, 0x01,
  0xC0, 0xA4, 0x0E, 0xB0, 0xA7, 0x50, 0xEC, 0x05, 0x72, 0x03, 0xD0, 0x47, 0x20, 0xAB, 0x0E, 0x30,
  0x3C, 0x04, 0x75, 0x0E, 0xC0, 0x57, 0x30, 0xEC, 0x09, 0x72, 0x04, 0xC0, 0x32, 0x07, 0xC7, 0x60,
  0xEC, 0x05, 0x73, 0x0B, 0xC0, 0xB7, 0x3C, 0x07, 0x20, 0xBB, 0x0B, 0x76, 0x0E, 0xC0, 0x57, 0x30,
  0x9C, 0x0D, 0x73, 0x0C, 0xB0, 0xB2, 0xC0, 0x77, 0x60, 0xEC, 0x05, 0x73, 0x09, 0xC0, 0xD7, 0x30,
  0x8B, 0x81, 0xE0, 0x1C, 0x04, 0x76, 0x0E, 0xC0, 0x57, 0x30, 0x9C, 0x0C, 0x73, 0x05, 0xC0, 0x10,
  0x4C, 0x02, 0x76, 0x0E, 0xC0, 0x57, 0x30, 0xBC, 0x0A, 0x73, 0x02, 0xC0, 0x40, 0x6C, 0x77, 0x0E,
  0xC0, 0x57, 0x30, 0xEC, 0x07, 0x74, 0xC0, 0x60, 0x8B, 0x0D, 0x77, 0x0E, 0xC0, 0x57, 0x20, 0x4D,
  0x02, 0x74, 0x0D, 0xB0, 0x80, 0x9B, 0x0C, 0x77, 0x0E, 0xC0, 0x57, 0x20, 0xBC, 0x09, 0x75, 0x0C,
  0xB0, 0x90, 0xAB, 0x0B, 0x77, 0x0E, 0xC0, 0x57, 0x10, 0x9C, 0x0D, 0x76, 0x0B, 0xB0, 0x90, 0xAB,
  0x0A, 0x77, 0x0E, 0xC0, 0x54, 0x82, 0x14, 0x8D, 0xC0, 0xC0, 0x17, 0x60, 0xBB, 0x0A, 0x0B, 0xB0,
  0xA7, 0x70, 0xEF, 0xFA, 0x08, 0x77, 0x10, 0xAB, 0x00, 0xBB, 0x0A, 0x77, 0x0E, 0xFF, 0x09, 0x02,
  0x77, 0x20, 0xAB, 0x0B, 0x0A, 0xB0, 0xB7, 0x70, 0xEF, 0xF0, 0x37, 0x73, 0x0B, 0xB0, 0x0A, 0xB0,
  0xB7, 0x70, 0xEC, 0x05, 0x40, 0xCC, 0x0A, 0x77, 0x30, 0xBB, 0x00, 0x9B, 0x0C, 0x77, 0x0E, 0xC0,
  0x54, 0x05, 0xD0, 0x37, 0x72, 0x0C, 0xB0, 0x90, 0x8B, 0x0D, 0x77, 0x0E, 0xC0, 0x55, 0x0D, 0xC0,
  0xB7, 0x72, 0x0E, 0xB0, 0x80, 0x6C, 0x77, 0x0E, 0xC0, 0x55, 0x06, 0xD0, 0x37, 0x71, 0xC0, 0x60,
  0x4C, 0x02, 0x76, 0x0E, 0xC0, 0x56, 0x0D, 0xC0, 0xB7, 0x70, 0x2C, 0x03, 0x01, 0xC0, 0x57, 0x60,
  0xEC, 0x05, 0x60, 0x7D, 0x03, 0x76, 0x05, 0xC8, 0x11, 0x0E, 0xB0, 0x87, 0x60, 0xEC, 0x05, 0x70,
  0xEC, 0x0B, 0x76, 0x08, 0xB0, 0xE2, 0x0B, 0xB0, 0xC7, 0x60, 0xEC, 0x05, 0x70, 0x7D, 0x03, 0x75,
  0x0C, 0xB0, 0xB2, 0x07, 0xC0, 0x17, 0x50, 0xEC, 0x05, 0x70, 0x10, 0xEC, 0x0B, 0x75, 0xC0, 0x72,
  0x03, 0xC0, 0x57, 0x50, 0xEC, 0x05, 0x71, 0x08, 0xD0, 0x37, 0x30, 0x4C, 0x03, 0x30, 0xEB, 0x0B,
  0x75, 0x0E, 0xC0, 0x57, 0x10, 0x1D, 0x0B, 0x73, 0x0A, 0xB0, 0xE4, 0x09, 0xC0, 0x17, 0x40, 0xEC,
  0x05, 0x72, 0x09, 0xD0, 0x37, 0x10, 0x1C, 0x0A, 0x40, 0x3C, 0x07, 0x74, 0xD0, 0x67, 0x20, 0x2D,
  0x0B, 0x71, 0x06, 0xC0, 0x45, 0x0D, 0xB0, 0xE7, 0x30, 0x4D, 0x0A, 0x73, 0x0A, 0xD0, 0x57, 0x0D,
  0xB0, 0xD6, 0x07, 0xC0, 0x87, 0x81, 0x16, 0xDE, 0x09, 0x03, 0x71, 0x02, 0xD8, 0x1E, 0x61, 0x40,
  0x6C, 0x07, 0x70, 0xEB, 0x0E, 0x01, 0x40, 0x9F, 0xF0, 0x36, 0x0B, 0xF9, 0x30, 0xDB, 0x0E, 0x01,
  0x70, 0x7C, 0x0B, 0x40, 0x9F, 0xF0, 0x36, 0x03, 0xF9, 0x20, 0x9C, 0x07, 0x72, 0x0D, 0xC0, 0x63,
  0x08, 0x80, 0x92, 0xD0, 0x27, 0x0A, 0x80, 0x3D, 0x10, 0x4C, 0x0E, 0x73, 0x05, 0xD0, 0x37, 0x77,
  0x75, 0x01, 0x0E, 0xC0, 0x57, 0x40, 0xAC, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x10, 0xDC, 0x0A, 0x76,
  0x0D, 0xC0, 0xE0, 0x27, 0x77, 0x71, 0x01, 0x0C, 0xC0, 0xD0, 0x17, 0x60, 0x3D, 0x0E, 0x04, 0x77,
  0x76, 0x02, 0x0D, 0xD0, 0x37, 0x71, 0x04, 0xE0, 0x87, 0x77, 0x40, 0x50, 0xED, 0x05, 0x77, 0x30,
  0x5E, 0x0D, 0x05, 0x77, 0x70, 0x20, 0xBE, 0x05, 0x77, 0x50, 0x50, 0xEE, 0x0B, 0x05, 0x77, 0x30,
  0x30, 0x9F, 0x05, 0x77, 0x70, 0x20, 0xDF, 0x82, 0xE9, 0x52, 0x72, 0x82, 0x14, 0x7D, 0xF0, 0xD0,
  0x37, 0x77, 0x20, 0x10, 0xAF, 0xB8, 0x7E, 0xCB, 0xA9, 0x9A, 0xBD, 0xFB, 0x0B, 0x01, 0x77, 0x75,
  0x05, 0x0D, 0xFF, 0xFC, 0x0D, 0x05, 0x77, 0x77, 0x20, 0x60, 0xDF, 0xFF, 0x0D, 0x06, 0x77, 0x77,
  0x68, 0x14, 0x9E, 0xFF, 0x98, 0x1E, 0x94, 0x80, 0xC3, 0x08, 0x43, 0x69, 0xBD, 0xEB, 0x84, 0xED,
  0xB9, 0x63, 0x77, 0x70,
  // "¯" (U+00AF)
  0x05, 0xFF, 0xFF, 0xF0, 0x80, 0x5F, 0xFF, 0xFF, 0x08, 0x05, 0xFF, 0xFF, 0xF0, 0x80, 0x5F, 0xFF,
  0xFF, 0x08, 0x05, 0xFF, 0xFF, 0xF0, 0x80,
  // "°" (U+00B0)
  0x78, 0x90, 0x15, 0xAC, 0xEF, 0xDC, 0x83, 0x76, 0x06, 0x0E, 0xFA, 0x0C, 0x03, 0x73, 0x0B, 0xFE,
  0x06, 0x71, 0x0C, 0xFF, 0x90, 0x66, 0x09, 0xD8, 0x59, 0x31, 0x01, 0x5B, 0xD0, 0x34, 0x04, 0xC0,
  0xD0, 0x27, 0x05, 0xC0, 0xD4, 0x0B, 0xB0, 0xE0, 0x27, 0x20, 0x5C, 0x06, 0x20, 0x2C, 0x06, 0x74,
  0x0A, 0xB0, 0xC2, 0x08, 0xB0, 0xE7, 0x50, 0x3C, 0x81, 0x30, 0xBB, 0x09, 0x76, 0x0D, 0xB8, 0x16,
  0x0E, 0xB0, 0x67, 0x60, 0x9B, 0x0A, 0x01, 0xC0, 0x37, 0x60, 0x6B, 0x0B, 0x02, 0xC0, 0x27, 0x60,
  0x5B, 0x0C, 0x03, 0xC0, 0x17, 0x60, 0x5B, 0x0D, 0x02, 0xC0, 0x27, 0x60, 0x5B, 0x0D, 0x01, 0xC0,
  0x37, 0x60, 0x7B, 0x0B, 0x1C, 0x06, 0x76, 0x09, 0xB8, 0x1A, 0x0C, 0xB0, 0x97, 0x60, 0xDB, 0x81,
  0x70, 0x8B, 0x0E, 0x75, 0x03, 0xC8, 0x13, 0x03, 0xC0, 0x77, 0x40, 0xBB, 0x0D, 0x30, 0xCB, 0x0E,
  0x02, 0x72, 0x05, 0xC0, 0x63, 0x04, 0xC0, 0xD0, 0x27, 0x05, 0xC0, 0xD5, 0x0A, 0xD8, 0x59, 0x31,
  0x01, 0x4B, 0xD0, 0x45, 0x01, 0x0C, 0xFF, 0x90, 0x77, 0x01, 0x0C, 0xFE, 0x07, 0x73, 0x07, 0x0E,
  0xFA, 0x0C, 0x03, 0x75, 0x89, 0x01, 0x5A, 0xDE, 0xFD, 0xC8, 0x37,
  // "±" (U+00B1)
  0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC,
  0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77,
  0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0,
  0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77,
  0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x70, 0x48, 0x09, 0x19,
  0x0E, 0xC0, 0xC8, 0x09, 0x19, 0x04, 0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06, 0x07,
  0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07,
  0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70,
  0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77,
  0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C,
  0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0xCC, 0x07, 0x77,
  0x77, 0x0C, 0xC0, 0x78, 0x0C, 0xB2, 0x00, 0x7F, 0xFF, 0xFC, 0x06, 0x07, 0xFF, 0xFF, 0xC0, 0x60,
  0x7F, 0xFF, 0xFC, 0x06, 0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06,
  // "²" (U+00B2)
  0x71, 0x85, 0x24, 0x56, 0x54, 0x27, 0x70, 0x50, 0xBF, 0x98, 0x1E, 0xA4, 0x72, 0x03, 0x0D, 0xFE,
  0x0C, 0x02, 0x60, 0x5F, 0xFA, 0x0E, 0x03, 0x40, 0x2E, 0x84, 0xB4, 0x10, 0x29, 0xE0, 0xE0, 0x23,
  0x0B, 0xD0, 0x96, 0x06, 0xE0, 0xA2, 0x01, 0xD0, 0xE7, 0x10, 0xCE, 0x81, 0x20, 0x4D, 0x08, 0x71,
  0x05, 0xE8, 0x17, 0x05, 0xD0, 0x47, 0x10, 0x1E, 0x81, 0xB0, 0x3D, 0x01, 0x72, 0x0E, 0xD0, 0xC2,
  0x0B, 0xC7, 0x30, 0xDD, 0x0D, 0x38, 0x28, 0xDF, 0xE7, 0x30, 0xDD, 0x0D, 0x50, 0x10, 0x27, 0x30,
  0xDD, 0x0C, 0x77, 0x3E, 0x0A, 0x77, 0x20, 0x2E, 0x07, 0x77, 0x20, 0x5E, 0x02, 0x77, 0x20, 0x9D,
  0x0C, 0x77, 0x30, 0xED, 0x05, 0x77, 0x20, 0x5D, 0x0B, 0x77, 0x30, 0xDD, 0x02, 0x77, 0x20, 0x7D,
  0x06, 0x77, 0x20, 0x20, 0xEC, 0x09, 0x77, 0x30, 0xBC, 0x0A, 0x77, 0x30, 0x8C, 0x0B, 0x77, 0x30,
  0x5C, 0x0C, 0x77, 0x30, 0x30, 0xEB, 0x0B, 0x77, 0x30, 0x20, 0xEB, 0x0B, 0x77, 0x30, 0x10, 0xDB,
  0x0B, 0x77, 0x30, 0x10, 0xCB, 0x0B, 0x77, 0x40, 0xBB, 0x0C, 0x73, 0x81, 0x49, 0x85, 0x0A, 0xB0,
  0xC0, 0x17, 0x38, 0x1A, 0xFD, 0x40, 0x9B, 0x0C, 0x01, 0x74, 0x81, 0xDF, 0xD3, 0x08, 0xB0, 0xD0,
  0x17, 0x40, 0x1A, 0x0C, 0x20, 0x6B, 0x0D, 0x01, 0x75, 0x07, 0xA8, 0x1C, 0x05, 0xB0, 0xD0, 0x27,
  0x50, 0x50, 0xEA, 0x0C, 0x04, 0xFF, 0xF9, 0x0B, 0x0E, 0xFF, 0xF9, 0x0B, 0xFF, 0xFA, 0x0A, 0xFF,
  0xFA, 0x0A, 0xFF, 0xFA, 0x0A,
  // "³" (U+00B3)
  0x78, 0x91, 0x59, 0xCD, 0xEF, 0xED, 0xB8, 0x57, 0x60, 0x80, 0xEF, 0xC0, 0xE0, 0x77, 0x20, 0x20,
  0xDF, 0xF9, 0x0D, 0x02, 0x60, 0x10, 0xDD, 0x84, 0xE9, 0x77, 0x9E, 0xE0, 0xD0, 0x15, 0x0A, 0xD0,
  0x96, 0x0A, 0xE0, 0xB4, 0x02, 0xD0, 0xC7, 0x10, 0xDE, 0x03, 0x30, 0x6D, 0x05, 0x71, 0x06, 0xE0,
  0x83, 0x08, 0xD7, 0x20, 0x2E, 0x0C, 0x30, 0x7C, 0x0C, 0x73, 0xE0, 0xD3, 0x03, 0xC0, 0xA7, 0x30,
  0xED, 0x0D, 0x40, 0x70, 0xEA, 0x09, 0x73, 0xE0, 0xC5, 0x82, 0x14, 0x74, 0x72, 0x01, 0xE0, 0x97,
  0x74, 0x04, 0xE0, 0x57, 0x74, 0x0A, 0xD0, 0xD7, 0x74, 0x02, 0xE0, 0x47, 0x73, 0x01, 0x0C, 0xD0,
  0x67, 0x73, 0x04, 0x0D, 0xC0, 0xE0, 0x57, 0x58, 0x44, 0x66, 0x78, 0xCD, 0x0B, 0x02, 0x76, 0x09,
  0xF9, 0x0A, 0x03, 0x77, 0x10, 0x9F, 0x98, 0x1C, 0x84, 0x77, 0x09, 0xFC, 0x0D, 0x07, 0x77, 0x28,
  0x21, 0x37, 0xDE, 0x0C, 0x02, 0x77, 0x40, 0x6E, 0x0E, 0x02, 0x77, 0x40, 0x5E, 0x0D, 0x77, 0x50,
  0xAE, 0x07, 0x77, 0x40, 0x3E, 0x0C, 0x77, 0x50, 0xEE, 0x77, 0x50, 0xCE, 0x02, 0x30, 0x05, 0x76,
  0x0B, 0xE8, 0x42, 0x03, 0xEF, 0xB7, 0x60, 0xCE, 0x81, 0x10, 0xDA, 0x0D, 0x76, 0x0D, 0xE1, 0x02,
  0xC0, 0x17, 0x40, 0x1E, 0x81, 0xC0, 0x4C, 0x06, 0x74, 0x05, 0xE8, 0x18, 0x03, 0xC0, 0xD7, 0x40,
  0xCE, 0x02, 0x2D, 0x07, 0x72, 0x08, 0xE0, 0x93, 0x0A, 0xD0, 0x76, 0x01, 0x0A, 0xE0, 0xD0, 0x13,
  0x01, 0x0E, 0xD8, 0x4E, 0x97, 0x68, 0xBF, 0x0C, 0x01, 0x50, 0x30, 0xEF, 0xFA, 0x09, 0x01, 0x70,
  0x10, 0x9F, 0xE0, 0xA0, 0x37, 0x48, 0x93, 0x16, 0x9C, 0xDE, 0xFE, 0xDC, 0x95, 0x17, 0x10,
  // "´" (U+00B4)
  0x70, 0x38, 0x04, 0x70, 0x47, 0x0B, 0xF9, 0x08, 0x60, 0x2F, 0x90, 0xD0, 0x16, 0x09, 0xF9, 0x03,
  0x60, 0x1F, 0x90, 0x57, 0x09, 0xF0, 0x87, 0x02, 0xF0, 0xA7, 0x10, 0xAE, 0x0B, 0x71, 0x04, 0xE0,
  0xB7, 0x20, 0xCD, 0x0C, 0x72, 0x06, 0xD0, 0xC7, 0x20, 0x10, 0xEC, 0x0B, 0x73, 0x09, 0xC0, 0xA7,
  0x30, 0x3C, 0x09, 0x74, 0x06, 0xB0, 0x67, 0x50,
  // "µ" (U+00B5)
  0x10, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F,
  0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77,
  0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F,
  0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70,
  0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07,
  0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10,
  0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A,
  0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F,
  0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77,
  0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F,
  0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70,
  0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07,
  0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x4F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10,
  0x5F, 0x0A, 0x70, 0x8F, 0x07, 0x77, 0x10, 0x6F, 0x0A, 0x70, 0x9F, 0x07, 0x77, 0x10, 0x7F, 0x0A,
  0x70, 0x9F, 0x08, 0x77, 0x10, 0x9F, 0x0A, 0x70, 0x9F, 0x09, 0x77, 0x10, 0xBF, 0x0A, 0x70, 0x9F,
  0x0B, 0x77, 0x10, 0xEF, 0x0A, 0x70, 0xAF, 0x0D, 0x77, 0x03, 0xF9, 0x0A, 0x70, 0xAF, 0x97, 0x70,
  0x8F, 0x90, 0xA7, 0x0A, 0xF9, 0x04, 0x76, 0x0E, 0xF9, 0x0B, 0x70, 0xBF, 0x90, 0x97, 0x50, 0x6F,
  0xA0, 0xB7, 0x0B, 0xFA, 0x01, 0x73, 0x01, 0x0E, 0xA0, 0xDE, 0x0E, 0x70, 0xCF, 0xA0, 0xA7, 0x30,
  0xCA, 0x09, 0x06, 0xF0, 0x26, 0x0C, 0xFB, 0x08, 0x70, 0x10, 0xCB, 0x00, 0x2F, 0x08, 0x60, 0xDF,
  0xC8, 0x6C, 0x62, 0x01, 0x38, 0xEB, 0x09, 0x20, 0xCF, 0x03, 0x50, 0xEB, 0x09, 0xFF, 0xB0, 0xD0,
  0x12, 0x05, 0xF8, 0x1E, 0x82, 0x30, 0xEB, 0x07, 0x08, 0xFF, 0xA0, 0x44, 0x0C, 0xFB, 0x04, 0x1C,
  0x81, 0x70, 0xCF, 0xF0, 0x75, 0x01, 0x0D, 0xFA, 0x04, 0x1C, 0x07, 0x20, 0xBF, 0xD0, 0x87, 0x01,
  0x0B, 0xF9, 0x04, 0x01, 0xC0, 0x83, 0x07, 0x0E, 0xF9, 0x0E, 0x05, 0x73, 0x82, 0x49, 0xDE, 0xC0,
  0x40, 0x2C, 0x08, 0x48, 0x71, 0x6A, 0xDE, 0xFD, 0xB6, 0x77, 0x70, 0x3C, 0x09, 0x77, 0x77, 0x60,
  0x3C, 0x0A, 0x77, 0x77, 0x60, 0x4C, 0x0C, 0x77, 0x77, 0x60, 0x5C, 0x0D, 0x77, 0x77, 0x60, 0x5D,
  0x77, 0x77, 0x60, 0x5D, 0x02, 0x77, 0x77, 0x50, 0x6D, 0x05, 0x77, 0x77, 0x50, 0x6D, 0x08, 0x77,
  0x77, 0x50, 0x6D, 0x0D, 0x77, 0x77, 0x50, 0x6E, 0x03, 0x77, 0x77, 0x40, 0x6E, 0x0B, 0x77, 0x77,
  0x40, 0x5F, 0x06, 0x77, 0x77, 0x30, 0x4F, 0x90, 0x77, 0x77, 0x72, 0x01, 0xFA, 0x81, 0xC6, 0x17,
  0x77, 0x70, 0xEF, 0xB0, 0x97, 0x77, 0x70, 0x9F, 0xB0, 0x67, 0x77, 0x70, 0x3F, 0xB0, 0x27, 0x77,
  0x71, 0x09, 0xF9, 0x0A, 0x77, 0x77, 0x30, 0xAE, 0x0C, 0x01, 0x77, 0x77, 0x48, 0x45, 0xBE, 0xEC,
  0x77, 0x77, 0x72,
  // "¶" (U+00B6)
  0x78, 0x24, 0x9C, 0xEF, 0xFF, 0xFA, 0x05, 0x50, 0x50, 0xDF, 0xFF, 0xFE, 0x05, 0x40, 0x98, 0x0C,
  0x0F, 0x05, 0x30, 0x9F, 0xFF, 0xFF, 0x81, 0xDC, 0x42, 0x04, 0xFF, 0xD8, 0x03, 0x90, 0xEE, 0x09,
  0x03, 0x60, 0xCF, 0xFD, 0x01, 0x60, 0xCD, 0x04, 0x70, 0x4F, 0xFE, 0x01, 0x60, 0xCC, 0x0A, 0x71,
  0x0A, 0xFF, 0xE0, 0x16, 0x0C, 0xC0, 0x57, 0x10, 0xEF, 0xFE, 0x01, 0x60, 0xCC, 0x02, 0x70, 0x3F,
  0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70, 0x6F, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70, 0x9F, 0xFF, 0x01,
  0x60, 0xCC, 0x01, 0x70, 0xBF, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70, 0xCF, 0xFF, 0x01, 0x60, 0xCC,
  0x01, 0x70, 0xDF, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70, 0xEF, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70,
  0xEF, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70, 0xDF, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70, 0xDF, 0xFF,
  0x01, 0x60, 0xCC, 0x01, 0x70, 0xBF, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70, 0xAF, 0xFF, 0x01, 0x60,
  0xCC, 0x01, 0x70, 0x7F, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x70, 0x5F, 0xFF, 0x01, 0x60, 0xCC, 0x01,
  0x70, 0x1F, 0xFF, 0x01, 0x60, 0xCC, 0x01, 0x71, 0x0D, 0xFF, 0xE0, 0x16, 0x0C, 0xC0, 0x17, 0x10,
  0x8F, 0xFE, 0x01, 0x60, 0xCC, 0x01, 0x71, 0x02, 0xFF, 0xE0, 0x16, 0x0C, 0xC0, 0x17, 0x20, 0xBF,
  0xFD, 0x01, 0x60, 0xCC, 0x01, 0x72, 0x02, 0xFF, 0xD0, 0x16, 0x0C, 0xC0, 0x17, 0x30, 0x7F, 0xFC,
  0x01, 0x60, 0xCC, 0x01, 0x74, 0x0A, 0xFF, 0xB0, 0x16, 0x0C, 0xC0, 0x17, 0x50, 0x8F, 0xFA, 0x01,
  0x60, 0xCC, 0x01, 0x76, 0x81, 0x3A, 0xEF, 0xE0, 0x16, 0x0C, 0xC0, 0x17, 0x72, 0x03, 0x05, 0x80,
  0x26, 0x0C, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73,
  0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A,
  0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0,
  0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16,
  0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C,
  0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0,
  0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17,
  0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77,
  0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30,
  0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC,
  0x01, 0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01,
  0x60, 0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60,
  0xCC, 0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC,
  0x01, 0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01,
  0x77, 0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77,
  0x73, 0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xAC, 0x01, 0x60, 0xCC, 0x01, 0x77, 0x73,
  0x0A, 0xC0, 0x16, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0xBC, 0x01, 0x60, 0xCC, 0x02, 0x77, 0x73, 0x0C,
  0xC0, 0x16, 0x0C, 0xC0, 0x37, 0x77, 0x3D, 0x01, 0x60, 0xCC, 0x06, 0x77, 0x72, 0x05, 0xD0, 0x16,
  0x0C, 0xC0, 0xC7, 0x77, 0x10, 0x30, 0xED, 0x01, 0x60, 0xCD, 0x07, 0x77, 0x48, 0x11, 0x5A, 0xF0,
  0x16, 0x0C, 0xE8, 0x1C, 0x62, 0x76, 0x0E, 0xFC, 0x01, 0x60, 0xCF, 0xC0, 0x57, 0x30, 0xEF, 0xC0,
  0x16, 0x0C, 0xFC, 0x05, 0x73, 0x0E, 0xFC, 0x01, 0x60, 0xCF, 0xC0, 0x57, 0x30, 0xEF, 0xC0, 0x16,
  0x0C, 0xFC, 0x05,
  // "·" (U+00B7)
  0x28, 0x47, 0xCF, 0xEB, 0x53, 0x0C, 0xE8, 0x19, 0x07, 0xF9, 0x04, 0x0C, 0xF9, 0x09, 0xFA, 0x0C,
  0xFA, 0x0C, 0xFA, 0x00, 0xCF, 0x90, 0x90, 0x7F, 0x98, 0x14, 0x0C, 0xE0, 0x93, 0x84, 0x7C, 0xFE,
  0xB5, 0x20,
  // "¸" (U+00B8)
  0x60, 0xEA, 0x0A, 0x75, 0x02, 0xB0, 0x77, 0x50, 0x5B, 0x04, 0x75, 0x09, 0xB0, 0x17, 0x50, 0xCB,
  0x81, 0xC9, 0x47, 0x3F, 0x0C, 0x03, 0x70, 0x3F, 0xA0, 0x57, 0x81, 0x48, 0xDF, 0x02, 0x72, 0x05,
  0x0E, 0xD0, 0xB7, 0x30, 0x3E, 0x01, 0x73, 0x0B, 0xD0, 0x57, 0x30, 0x7D, 0x07, 0x73, 0x06, 0xD0,
  0x77, 0x30, 0x8D, 0x06, 0x73, 0x0B, 0xD0, 0x57, 0x20, 0x3E, 0x0F, 0x16, 0x05, 0x0E, 0xD8, 0x90,
  0xC0, 0x7F, 0xDB, 0xA9, 0xAD, 0xF8, 0x15, 0x07, 0xFE, 0x0A, 0x20, 0x7F, 0xD0, 0xB3, 0x07, 0xFB,
  0x0E, 0x07, 0x58, 0x90, 0x58, 0xBD, 0xEF, 0xED, 0x95, 0x60,
  // "¹" (U+00B9)
  0x73, 0x01, 0x0A, 0xC0, 0x17, 0x72, 0x03, 0x0E, 0xD0, 0x17, 0x71, 0x05, 0xF0, 0x17, 0x70, 0x8F,
  0x90, 0x17, 0x50, 0x20, 0xBF, 0xA0, 0x17, 0x38, 0x11, 0x7E, 0xFB, 0x01, 0x78, 0x21, 0x59, 0xEC,
  0x0D, 0x08, 0xE0, 0x17, 0x0A, 0xE8, 0x1D, 0x17, 0xE0, 0x17, 0x07, 0xD8, 0x2C, 0x10, 0x7E, 0x01,
  0x71, 0x0C, 0xB0, 0xB0, 0x12, 0x07, 0xE0, 0x17, 0x28, 0x15, 0x73, 0x40, 0x7E, 0x01, 0x77, 0x20,
  0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20,
  0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20,
  0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20,
  0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20,
  0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20,
  0x7E, 0x01, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x20, 0x9E, 0x03, 0x77, 0x10, 0x20, 0xEE, 0x0A, 0x72,
  0x80, 0x06, 0x81, 0x79, 0xEF, 0x98, 0x7D, 0x86, 0x66, 0x61, 0x02, 0xFF, 0xF8, 0x12, 0x02, 0xFF,
  0xF8, 0x12, 0x02, 0xFF, 0xF0, 0x20,
  // "º" (U+00BA)
  0x78, 0x91, 0x26, 0xBC, 0xEF, 0xEC, 0xA6, 0x17, 0x50, 0x20, 0xBF, 0xC0, 0xA0, 0x17, 0x20, 0x6E,
  0x81, 0xDC, 0xEE, 0x05, 0x70, 0x7D, 0x0A, 0x02, 0x30, 0x30, 0xBD, 0x06, 0x50, 0x4D, 0x0A, 0x70,
  0xAD, 0x03, 0x40, 0xDC, 0x0E, 0x01, 0x70, 0x10, 0xEC, 0x0D, 0x30, 0x6D, 0x09, 0x72, 0x09, 0xD0,
  0x62, 0x0B, 0xD0, 0x47, 0x20, 0x3D, 0x81, 0xD0, 0x1E, 0x74, 0xE0, 0x30, 0x5D, 0x0D, 0x74, 0x0C,
  0xD0, 0x60, 0x8D, 0x0B, 0x74, 0x0A, 0xD0, 0xA0, 0xBD, 0x09, 0x74, 0x09, 0xD0, 0xD0, 0xCD, 0x08,
  0x74, 0x07, 0xD0, 0xE0, 0xDD, 0x07, 0x74, 0x07, 0xE0, 0xED, 0x07, 0x74, 0x06, 0xE0, 0xED, 0x07,
  0x74, 0x06, 0xE0, 0xDD, 0x07, 0x74, 0x06, 0xE0, 0xCD, 0x08, 0x74, 0x07, 0xD0, 0xE0, 0xBD, 0x08,
  0x74, 0x08, 0xD0, 0xD0, 0x9D, 0x0A, 0x74, 0x09, 0xD0, 0xB0, 0x6D, 0x0C, 0x74, 0x0B, 0xD0, 0x80,
  0x3D, 0x0E, 0x74, 0x0E, 0xD8, 0x15, 0x0D, 0xD0, 0x27, 0x20, 0x1E, 0x81, 0x10, 0x8D, 0x06, 0x72,
  0x06, 0xD0, 0xA2, 0x02, 0xD0, 0xC7, 0x20, 0xBD, 0x03, 0x30, 0x7D, 0x05, 0x70, 0x4D, 0x09, 0x50,
  0xCC, 0x0E, 0x03, 0x50, 0x30, 0xEC, 0x0D, 0x60, 0x10, 0xBD, 0x83, 0xA6, 0x46, 0xAD, 0x0D, 0x01,
  0x71, 0x09, 0xFE, 0x0A, 0x01, 0x73, 0x81, 0x29, 0xEF, 0x81, 0xE9, 0x37, 0x71, 0x85, 0x35, 0x67,
  0x65, 0x37, 0x20,
  // "»" (U+00BB)
  0x09, 0xB0, 0x47, 0x20, 0x6B, 0x07, 0x74, 0x02, 0xB0, 0xE0, 0x17, 0x20, 0xEB, 0x03, 0x74, 0x0A,
  0xB0, 0xB7, 0x20, 0x7B, 0x0D, 0x01, 0x73, 0x03, 0xC0, 0x87, 0x10, 0x10, 0xEB, 0x0B, 0x74, 0x0B,
  0xC0, 0x47, 0x10, 0x8C, 0x07, 0x73, 0x04, 0xC0, 0xE0, 0x17, 0x01, 0xD0, 0x37, 0x30, 0xCC, 0x0C,
  0x71, 0x09, 0xC0, 0xD0, 0x17, 0x20, 0x5D, 0x08, 0x70, 0x2D, 0x0B, 0x73, 0x0D, 0xD0, 0x47, 0x0A,
  0xD0, 0x77, 0x20, 0x6D, 0x0E, 0x01, 0x60, 0x3E, 0x03, 0x72, 0x0E, 0xD0, 0xC7, 0x0B, 0xD0, 0xD0,
  0x17, 0x10, 0x7E, 0x08, 0x60, 0x3E, 0x0A, 0x72, 0x0E, 0xE0, 0x46, 0x0C, 0xE0, 0x67, 0x10, 0x8E,
  0x0E, 0x01, 0x50, 0x4F, 0x03, 0x70, 0x1F, 0x0C, 0x60, 0xCE, 0x0D, 0x01, 0x70, 0x9F, 0x08, 0x50,
  0x5F, 0x0A, 0x70, 0x2F, 0x0A, 0x60, 0xDE, 0x0C, 0x70, 0x1F, 0x0A, 0x60, 0xDE, 0x0C, 0x70, 0x8F,
  0x08, 0x50, 0x5F, 0x0A, 0x60, 0x10, 0xEE, 0x0C, 0x60, 0xCE, 0x0E, 0x01, 0x60, 0x7E, 0x0E, 0x02,
  0x50, 0x4F, 0x04, 0x70, 0xEE, 0x05, 0x60, 0xBE, 0x07, 0x70, 0x6E, 0x09, 0x60, 0x3E, 0x0B, 0x71,
  0x0D, 0xD0, 0xC7, 0x0A, 0xD0, 0xE0, 0x17, 0x05, 0xD0, 0xE0, 0x26, 0x02, 0xE0, 0x47, 0x10, 0xDD,
  0x05, 0x70, 0x9D, 0x07, 0x71, 0x05, 0xD0, 0x87, 0x01, 0xD0, 0xB7, 0x20, 0xCC, 0x0C, 0x71, 0x09,
  0xC0, 0xE0, 0x17, 0x10, 0x4C, 0x0E, 0x01, 0x70, 0x1D, 0x04, 0x72, 0x0B, 0xC0, 0x47, 0x10, 0x8C,
  0x07, 0x72, 0x03, 0xC0, 0x87, 0x20, 0xEB, 0x0B, 0x73, 0x0A, 0xB0, 0xC7, 0x20, 0x7B, 0x0E, 0x01,
  0x72, 0x02, 0xB0, 0xE0, 0x17, 0x20, 0xEB, 0x04, 0x73, 0x09, 0xB0, 0x47, 0x20, 0x6B, 0x07, 0x74,
  // "¼" (U+00BC)
  0x73, 0x01, 0x0A, 0xC0, 0x18, 0x0E, 0x30, 0x03, 0x0E, 0xD0, 0x17, 0x77, 0x50, 0xCC, 0x03, 0x77,
  0x71, 0x05, 0xF0, 0x17, 0x77, 0x40, 0x3C, 0x0C, 0x77, 0x71, 0x08, 0xF9, 0x01, 0x77, 0x74, 0x0A,
  0xC0, 0x67, 0x76, 0x02, 0x0B, 0xFA, 0x01, 0x77, 0x73, 0x01, 0xC0, 0xE7, 0x75, 0x81, 0x17, 0xEF,
  0xB0, 0x17, 0x77, 0x30, 0x7C, 0x08, 0x77, 0x28, 0x21, 0x59, 0xEC, 0x0D, 0x08, 0xE0, 0x17, 0x77,
  0x30, 0xDC, 0x02, 0x77, 0x20, 0xAE, 0x81, 0xD1, 0x7E, 0x01, 0x77, 0x72, 0x05, 0xC0, 0xA7, 0x73,
  0x07, 0xD8, 0x2C, 0x10, 0x7E, 0x01, 0x77, 0x72, 0x0B, 0xC0, 0x47, 0x74, 0x0C, 0xB0, 0xB0, 0x12,
  0x07, 0xE0, 0x17, 0x77, 0x10, 0x3C, 0x0D, 0x77, 0x68, 0x15, 0x73, 0x40, 0x7E, 0x01, 0x77, 0x71,
  0x09, 0xC0, 0x67, 0x77, 0x60, 0x7E, 0x01, 0x77, 0x70, 0x10, 0xEB, 0x0E, 0x77, 0x77, 0x07, 0xE0,
  0x17, 0x77, 0x07, 0xC0, 0x97, 0x77, 0x70, 0x7E, 0x01, 0x77, 0x70, 0xDC, 0x02, 0x77, 0x77, 0x07,
  0xE0, 0x17, 0x76, 0x04, 0xC0, 0xB7, 0x77, 0x71, 0x07, 0xE0, 0x17, 0x76, 0x0B, 0xC0, 0x47, 0x77,
  0x71, 0x07, 0xE0, 0x17, 0x75, 0x02, 0xC0, 0xD7, 0x77, 0x72, 0x07, 0xE0, 0x17, 0x75, 0x09, 0xC0,
  0x77, 0x77, 0x72, 0x07, 0xE0, 0x17, 0x75, 0x0E, 0xC0, 0x17, 0x77, 0x72, 0x07, 0xE0, 0x17, 0x74,
  0x06, 0xC0, 0x97, 0x77, 0x73, 0x07, 0xE0, 0x17, 0x74, 0x0D, 0xC0, 0x37, 0x77, 0x73, 0x07, 0xE0,
  0x17, 0x73, 0x04, 0xC0, 0xC7, 0x77, 0x74, 0x07, 0xE0, 0x17, 0x73, 0x0A, 0xC0, 0x57, 0x77, 0x74,
  0x07, 0xE0, 0x17, 0x72, 0x02, 0xC0, 0xE7, 0x77, 0x75, 0x07, 0xE0, 0x17, 0x72, 0x08, 0xC0, 0x77,
  0x77, 0x75, 0x07, 0xE0, 0x17, 0x72, 0x0E, 0xC0, 0x17, 0x77, 0x75, 0x07, 0xE0, 0x17, 0x71, 0x06,
  0xC0, 0xA7, 0x40, 0x2E, 0x77, 0x20, 0x7E, 0x01, 0x77, 0x10, 0xCC, 0x03, 0x74, 0x0A, 0xE7, 0x72,
  0x07, 0xE0, 0x17, 0x70, 0x3C, 0x0C, 0x74, 0x04, 0xF7, 0x72, 0x07, 0xE0, 0x17, 0x70, 0xAC, 0x06,
  0x74, 0x0D, 0xF7, 0x72, 0x07, 0xE0, 0x17, 0x60, 0x1C, 0x0E, 0x74, 0x07, 0xF9, 0x77, 0x20, 0x7E,
  0x01, 0x76, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xEF, 0x97, 0x72, 0x07, 0xE0, 0x17, 0x60, 0xEC, 0x01,
  0x73, 0x0A, 0xA0, 0xAE, 0x77, 0x20, 0x9E, 0x03, 0x75, 0x05, 0xC0, 0xA7, 0x30, 0x4B, 0x04, 0xE7,
  0x71, 0x02, 0x0E, 0xE0, 0xA7, 0x50, 0xCC, 0x04, 0x73, 0x0D, 0xA0, 0xA0, 0x2E, 0x72, 0x80, 0x06,
  0x81, 0x79, 0xEF, 0x98, 0x5D, 0x86, 0x66, 0x61, 0x40, 0x3C, 0x0D, 0x73, 0x07, 0xB0, 0x20, 0x3E,
  0x71, 0x02, 0xFF, 0xF0, 0x24, 0x09, 0xC0, 0x67, 0x20, 0x10, 0xEA, 0x81, 0x80, 0x3E, 0x71, 0x02,
  0xFF, 0xF0, 0x23, 0x01, 0xC0, 0xE7, 0x30, 0xAA, 0x0D, 0x20, 0x3E, 0x71, 0x02, 0xFF, 0xF0, 0x23,
  0x07, 0xC0, 0x87, 0x20, 0x4B, 0x05, 0x20, 0x3E, 0x77, 0x77, 0x60, 0xDC, 0x02, 0x72, 0x0D, 0xA0,
  0xB3, 0x03, 0xE7, 0x77, 0x75, 0x04, 0xC0, 0xB7, 0x20, 0x7B, 0x02, 0x30, 0x3E, 0x77, 0x77, 0x50,
  0xBC, 0x04, 0x71, 0x01, 0x0E, 0xA0, 0x94, 0x03, 0xE7, 0x77, 0x74, 0x02, 0xC0, 0xD7, 0x20, 0xAA,
  0x0E, 0x01, 0x40, 0x3E, 0x77, 0x77, 0x40, 0x9C, 0x07, 0x71, 0x04, 0xB0, 0x65, 0x03, 0xE7, 0x77,
  0x74, 0x0E, 0xB0, 0xE0, 0x17, 0x10, 0xDA, 0x0C, 0x60, 0x3E, 0x77, 0x77, 0x30, 0x6C, 0x09, 0x71,
  0x07, 0xB0, 0x36, 0x03, 0xE7, 0x77, 0x73, 0x0D, 0xC0, 0x37, 0x01, 0x0E, 0xA0, 0xA7, 0x03, 0xE7,
  0x77, 0x72, 0x04, 0xC0, 0xB7, 0x10, 0xAA, 0x0E, 0x01, 0x70, 0x3E, 0x77, 0x77, 0x20, 0xAC, 0x05,
  0x70, 0x3B, 0x07, 0x71, 0x03, 0xE7, 0x77, 0x71, 0x02, 0xC0, 0xD7, 0x10, 0xCB, 0x07, 0x80, 0x46,
  0x08, 0xE8, 0x02, 0x60, 0x47, 0x77, 0x10, 0x8C, 0x07, 0x70, 0x6F, 0xFF, 0xD0, 0xA7, 0x77, 0x10,
  0xEC, 0x01, 0x70, 0x8F, 0xFF, 0xD0, 0xA7, 0x77, 0x06, 0xC0, 0xA7, 0x10, 0x8F, 0xFF, 0xD0, 0xA7,
  0x77, 0x0C, 0xC0, 0x37, 0x77, 0x10, 0x3E, 0x77, 0x76, 0x03, 0xC0, 0xC7, 0x77, 0x20, 0x3E, 0x77,
  0x76, 0x0A, 0xC0, 0x57, 0x77, 0x20, 0x3E, 0x77, 0x75, 0x01, 0xC0, 0xE7, 0x77, 0x30, 0x3E, 0x77,
  0x75, 0x08, 0xC0, 0x87, 0x77, 0x30, 0x3E, 0x77, 0x75, 0x0E, 0xC0, 0x17, 0x77, 0x30, 0x4E, 0x77,
  0x74, 0x05, 0xC0, 0xA7, 0x77, 0x40, 0x5E, 0x02, 0x77, 0x73, 0x0C, 0xC0, 0x47, 0x77, 0x40, 0xBE,
  0x08, 0x77, 0x72, 0x03, 0xC0, 0xD7, 0x77, 0x0F, 0x60, 0x80, 0xDF, 0x98, 0x2B, 0x76, 0x67, 0x75,
  0x09, 0xC0, 0x67, 0x77, 0xFF, 0xB7, 0x74, 0x01, 0xC0, 0xE7, 0x77, 0x1F, 0xFB, 0x77, 0x40, 0x7C,
  0x08, 0x77, 0x71, 0xFF, 0xB2,
  // "½" (U+00BD)
  0x73, 0x01, 0x0A, 0xC0, 0x18, 0x0E, 0x20, 0x03, 0x0E, 0xD0, 0x17, 0x77, 0x40, 0xCC, 0x03, 0x77,
  0x71, 0x05, 0xF0, 0x17, 0x77, 0x30, 0x3C, 0x0C, 0x77, 0x71, 0x08, 0xF9, 0x01, 0x77, 0x73, 0x0A,
  0xC0, 0x67, 0x76, 0x02, 0x0B, 0xFA, 0x01, 0x77, 0x72, 0x01, 0xC0, 0xE7, 0x75, 0x81, 0x17, 0xEF,
  0xB0, 0x17, 0x77, 0x20, 0x7C, 0x08, 0x77, 0x28, 0x21, 0x59, 0xEC, 0x0D, 0x08, 0xE0, 0x17, 0x77,
  0x20, 0xDC, 0x02, 0x77, 0x20, 0xAE, 0x81, 0xD1, 0x7E, 0x01, 0x77, 0x71, 0x05, 0xC0, 0xA7, 0x73,
  0x07, 0xD8, 0x2C, 0x10, 0x7E, 0x01, 0x77, 0x71, 0x0B, 0xC0, 0x47, 0x74, 0x0C, 0xB0, 0xB0, 0x12,
  0x07, 0xE0, 0x17, 0x77, 0x03, 0xC0, 0xD7, 0x76, 0x81, 0x57, 0x34, 0x07, 0xE0, 0x17, 0x77, 0x09,
  0xC0, 0x67, 0x77, 0x60, 0x7E, 0x01, 0x77, 0x60, 0x10, 0xEB, 0x0E, 0x77, 0x77, 0x07, 0xE0, 0x17,
  0x76, 0x07, 0xC0, 0x97, 0x77, 0x70, 0x7E, 0x01, 0x77, 0x60, 0xDC, 0x02, 0x77, 0x77, 0x07, 0xE0,
  0x17, 0x75, 0x04, 0xC0, 0xB7, 0x77, 0x71, 0x07, 0xE0, 0x17, 0x75, 0x0B, 0xC0, 0x47, 0x77, 0x71,
  0x07, 0xE0, 0x17, 0x74, 0x02, 0xC0, 0xD7, 0x77, 0x72, 0x07, 0xE0, 0x17, 0x74, 0x09, 0xC0, 0x77,
  0x77, 0x72, 0x07, 0xE0, 0x17, 0x74, 0x0E, 0xC0, 0x17, 0x77, 0x72, 0x07, 0xE0, 0x17, 0x73, 0x06,
  0xC0, 0x97, 0x77, 0x73, 0x07, 0xE0, 0x17, 0x73, 0x0D, 0xC0, 0x37, 0x77, 0x73, 0x07, 0xE0, 0x17,
  0x72, 0x04, 0xC0, 0xC7, 0x77, 0x74, 0x07, 0xE0, 0x17, 0x72, 0x0A, 0xC0, 0x57, 0x77, 0x74, 0x07,
  0xE0, 0x17, 0x71, 0x02, 0xC0, 0xE7, 0x77, 0x75, 0x07, 0xE0, 0x17, 0x71, 0x08, 0xC0, 0x77, 0x77,
  0x75, 0x07, 0xE0, 0x17, 0x71, 0x0E, 0xC0, 0x17, 0x18, 0x52, 0x45, 0x65, 0x42, 0x77, 0x40, 0x7E,
  0x01, 0x77, 0x06, 0xC0, 0xA6, 0x05, 0x0B, 0xF9, 0x81, 0xEA, 0x47, 0x71, 0x07, 0xE0, 0x17, 0x70,
  0xCC, 0x03, 0x40, 0x30, 0xDF, 0xE0, 0xC0, 0x27, 0x60, 0x7E, 0x01, 0x76, 0x03, 0xC0, 0xC4, 0x05,
  0xFF, 0xA0, 0xE0, 0x37, 0x50, 0x7E, 0x01, 0x76, 0x0A, 0xC0, 0x63, 0x02, 0xE8, 0x4B, 0x41, 0x02,
  0x9E, 0x0E, 0x02, 0x74, 0x07, 0xE0, 0x17, 0x50, 0x1C, 0x0E, 0x40, 0xBD, 0x09, 0x60, 0x6E, 0x0A,
  0x74, 0x07, 0xE0, 0x17, 0x50, 0x7C, 0x08, 0x30, 0x1D, 0x0E, 0x71, 0x0C, 0xE0, 0x27, 0x30, 0x7E,
  0x01, 0x75, 0x0E, 0xC0, 0x13, 0x04, 0xD0, 0x87, 0x10, 0x5E, 0x07, 0x73, 0x09, 0xE0, 0x37, 0x40,
  0x5C, 0x0A, 0x40, 0x5D, 0x04, 0x71, 0x01, 0xE0, 0xB7, 0x20, 0x20, 0xEE, 0x0A, 0x74, 0x0C, 0xC0,
  0x44, 0x03, 0xD0, 0x17, 0x20, 0xED, 0x0C, 0x38, 0x00, 0x68, 0x17, 0x9E, 0xF9, 0x85, 0xD8, 0x66,
  0x66, 0x13, 0x03, 0xC0, 0xD6, 0x0B, 0xC7, 0x30, 0xDD, 0x0D, 0x20, 0x2F, 0xFF, 0x02, 0x30, 0x9C,
  0x06, 0x78, 0x28, 0xDF, 0xE7, 0x30, 0xDD, 0x0D, 0x20, 0x2F, 0xFF, 0x02, 0x20, 0x1C, 0x0E, 0x73,
  0x01, 0x02, 0x73, 0x0D, 0xD0, 0xC2, 0x02, 0xFF, 0xF0, 0x22, 0x07, 0xC0, 0x87, 0x77, 0x1E, 0x0A,
  0x77, 0x76, 0x0D, 0xC0, 0x27, 0x77, 0x02, 0xE0, 0x77, 0x77, 0x50, 0x4C, 0x0B, 0x77, 0x71, 0x05,
  0xE0, 0x27, 0x77, 0x50, 0xBC, 0x04, 0x77, 0x71, 0x09, 0xD0, 0xC7, 0x77, 0x50, 0x2C, 0x0D, 0x77,
  0x72, 0x0E, 0xD0, 0x57, 0x77, 0x50, 0x9C, 0x07, 0x77, 0x71, 0x05, 0xD0, 0xB7, 0x77, 0x60, 0xEB,
  0x0E, 0x01, 0x77, 0x71, 0x0D, 0xD0, 0x27, 0x77, 0x50, 0x6C, 0x09, 0x77, 0x71, 0x07, 0xD0, 0x67,
  0x77, 0x60, 0xDC, 0x03, 0x77, 0x70, 0x20, 0xEC, 0x09, 0x77, 0x76, 0x04, 0xC0, 0xB7, 0x77, 0x10,
  0xBC, 0x0A, 0x77, 0x77, 0x0A, 0xC0, 0x57, 0x77, 0x08, 0xC0, 0xB7, 0x77, 0x70, 0x2C, 0x0D, 0x77,
  0x70, 0x5C, 0x0C, 0x77, 0x77, 0x10, 0x8C, 0x07, 0x77, 0x60, 0x30, 0xEB, 0x0B, 0x77, 0x77, 0x20,
  0xEC, 0x01, 0x77, 0x50, 0x20, 0xEB, 0x0B, 0x77, 0x77, 0x20, 0x6C, 0x0A, 0x77, 0x50, 0x10, 0xDB,
  0x0B, 0x77, 0x77, 0x30, 0xCC, 0x03, 0x77, 0x40, 0x10, 0xCB, 0x0B, 0x77, 0x77, 0x30, 0x3C, 0x0C,
  0x77, 0x50, 0xBB, 0x0C, 0x73, 0x81, 0x49, 0x87, 0x75, 0x0A, 0xC0, 0x57, 0x74, 0x0A, 0xB0, 0xC0,
  0x17, 0x38, 0x1A, 0xFD, 0x77, 0x40, 0x1C, 0x0E, 0x77, 0x40, 0x9B, 0x0C, 0x01, 0x74, 0x81, 0xDF,
  0xD7, 0x74, 0x08, 0xC0, 0x87, 0x73, 0x08, 0xB0, 0xD0, 0x17, 0x40, 0x1A, 0x0C, 0x77, 0x40, 0xEC,
  0x01, 0x77, 0x20, 0x6B, 0x0D, 0x01, 0x75, 0x07, 0xA0, 0xC7, 0x73, 0x05, 0xC0, 0xA7, 0x72, 0x05,
  0xB0, 0xD0, 0x27, 0x50, 0x50, 0xEA, 0x0C, 0x77, 0x30, 0xCC, 0x04, 0x77, 0x10, 0x4F, 0xFF, 0x90,
  0xB7, 0x72, 0x03, 0xC0, 0xD7, 0x72, 0x0E, 0xFF, 0xF9, 0x0B, 0x77, 0x20, 0x9C, 0x06, 0x77, 0x2F,
  0xFF, 0xA0, 0xA7, 0x71, 0x01, 0xC0, 0xE7, 0x73, 0xFF, 0xFA, 0x0A, 0x77, 0x10, 0x7C, 0x08, 0x77,
  0x3F, 0xFF, 0xA0, 0xA0,
  // "¾" (U+00BE)
  0x78, 0x91, 0x59, 0xCD, 0xEF, 0xED, 0xB8, 0x58, 0x0D, 0x40, 0x08, 0x0E, 0xFC, 0x0E, 0x07, 0x77,
  0x72, 0x0C, 0xC0, 0x37, 0x71, 0x02, 0x0D, 0xFF, 0x90, 0xD0, 0x27, 0x76, 0x03, 0xC0, 0xC7, 0x71,
  0x01, 0x0D, 0xD8, 0x4E, 0x97, 0x79, 0xEE, 0x0D, 0x01, 0x77, 0x50, 0xAC, 0x06, 0x77, 0x10, 0xAD,
  0x09, 0x60, 0xAE, 0x0B, 0x77, 0x40, 0x1C, 0x0E, 0x77, 0x10, 0x2D, 0x0C, 0x71, 0x0D, 0xE0, 0x37,
  0x73, 0x07, 0xC0, 0x87, 0x71, 0x06, 0xD0, 0x57, 0x10, 0x6E, 0x08, 0x77, 0x30, 0xDC, 0x02, 0x77,
  0x10, 0x8D, 0x72, 0x02, 0xE0, 0xC7, 0x72, 0x05, 0xC0, 0xA7, 0x72, 0x07, 0xC0, 0xC7, 0x3E, 0x0D,
  0x77, 0x20, 0xBC, 0x04, 0x77, 0x20, 0x3C, 0x0A, 0x73, 0x0E, 0xD0, 0xD7, 0x71, 0x03, 0xC0, 0xD7,
  0x74, 0x07, 0x0E, 0xA0, 0x97, 0x3E, 0x0C, 0x77, 0x10, 0x9C, 0x06, 0x77, 0x58, 0x21, 0x47, 0x47,
  0x20, 0x1E, 0x09, 0x77, 0x01, 0x0E, 0xB0, 0xE7, 0x77, 0x75, 0x04, 0xE0, 0x57, 0x70, 0x7C, 0x09,
  0x77, 0x77, 0x50, 0xAD, 0x0D, 0x77, 0x10, 0xDC, 0x02, 0x77, 0x77, 0x40, 0x2E, 0x04, 0x77, 0x04,
  0xC0, 0xB7, 0x77, 0x74, 0x01, 0x0C, 0xD0, 0x67, 0x71, 0x0B, 0xC0, 0x47, 0x77, 0x73, 0x04, 0x0D,
  0xC0, 0xE0, 0x57, 0x71, 0x02, 0xC0, 0xD7, 0x77, 0x58, 0x44, 0x66, 0x78, 0xCD, 0x0B, 0x02, 0x77,
  0x20, 0x9C, 0x07, 0x77, 0x75, 0x09, 0xF9, 0x0A, 0x03, 0x77, 0x40, 0xEC, 0x01, 0x77, 0x75, 0x09,
  0xF9, 0x81, 0xC8, 0x47, 0x72, 0x06, 0xC0, 0x97, 0x77, 0x60, 0x9F, 0xC0, 0xD0, 0x77, 0x70, 0xDC,
  0x03, 0x77, 0x77, 0x38, 0x21, 0x37, 0xDE, 0x0C, 0x02, 0x74, 0x04, 0xC0, 0xC8, 0x0C, 0x00, 0x06,
  0xE0, 0xE0, 0x27, 0x30, 0xAC, 0x05, 0x80, 0xC1, 0x00, 0x5E, 0x0D, 0x72, 0x02, 0xC0, 0xE8, 0x0C,
  0x30, 0x0A, 0xE0, 0x77, 0x10, 0x8C, 0x07, 0x80, 0xC3, 0x00, 0x3E, 0x0C, 0x71, 0x0E, 0xC0, 0x18,
  0x0C, 0x40, 0x0E, 0xE7, 0x06, 0xC0, 0xA7, 0x20, 0x2E, 0x77, 0x74, 0x0C, 0xE0, 0x26, 0x0C, 0xC0,
  0x37, 0x20, 0xAE, 0x73, 0x00, 0x57, 0x60, 0xBE, 0x02, 0x50, 0x3C, 0x0C, 0x72, 0x04, 0xF7, 0x18,
  0x23, 0xEF, 0xB7, 0x60, 0xCE, 0x01, 0x50, 0xAC, 0x06, 0x72, 0x0D, 0xF7, 0x10, 0xDA, 0x0D, 0x76,
  0x0D, 0xE5, 0x01, 0xC0, 0xE7, 0x20, 0x7F, 0x97, 0x02, 0xC0, 0x17, 0x40, 0x1E, 0x0C, 0x50, 0x7C,
  0x08, 0x71, 0x01, 0x0E, 0xF9, 0x70, 0x4C, 0x06, 0x74, 0x05, 0xE0, 0x85, 0x0E, 0xC0, 0x17, 0x10,
  0xAA, 0x0A, 0xE7, 0x03, 0xC0, 0xD7, 0x40, 0xCE, 0x02, 0x40, 0x5C, 0x0A, 0x71, 0x04, 0xB0, 0x4E,
  0x71, 0xD0, 0x77, 0x20, 0x8E, 0x09, 0x50, 0xCC, 0x04, 0x71, 0x0D, 0xA0, 0xA0, 0x2E, 0x71, 0x0A,
  0xD0, 0x76, 0x01, 0x0A, 0xE0, 0xD0, 0x14, 0x03, 0xC0, 0xD7, 0x10, 0x7B, 0x02, 0x03, 0xE7, 0x10,
  0x10, 0xED, 0x84, 0xE9, 0x76, 0x8B, 0xF0, 0xC0, 0x15, 0x09, 0xC0, 0x67, 0x01, 0x0E, 0xA8, 0x18,
  0x03, 0xE7, 0x20, 0x30, 0xEF, 0xFA, 0x09, 0x01, 0x50, 0x1C, 0x0E, 0x71, 0x0A, 0xA0, 0xD2, 0x03,
  0xE7, 0x30, 0x10, 0x9F, 0xE0, 0xA0, 0x37, 0x07, 0xC0, 0x87, 0x04, 0xB0, 0x52, 0x03, 0xE7, 0x58,
  0x93, 0x16, 0x9C, 0xDE, 0xFE, 0xDC, 0x95, 0x17, 0x20, 0xDC, 0x02, 0x70, 0xDA, 0x0B, 0x30, 0x3E,
  0x77, 0x77, 0x50, 0x4C, 0x0B, 0x70, 0x7B, 0x02, 0x30, 0x3E, 0x77, 0x77, 0x50, 0xBC, 0x04, 0x60,
  0x10, 0xEA, 0x09, 0x40, 0x3E, 0x77, 0x77, 0x40, 0x2C, 0x0D, 0x70, 0xAA, 0x0E, 0x01, 0x40, 0x3E,
  0x77, 0x77, 0x40, 0x9C, 0x07, 0x60, 0x4B, 0x06, 0x50, 0x3E, 0x77, 0x77, 0x40, 0xEB, 0x0E, 0x01,
  0x60, 0xDA, 0x0C, 0x60, 0x3E, 0x77, 0x77, 0x30, 0x6C, 0x09, 0x60, 0x7B, 0x03, 0x60, 0x3E, 0x77,
  0x77, 0x30, 0xDC, 0x03, 0x50, 0x10, 0xEA, 0x0A, 0x70, 0x3E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x60,
  0xAA, 0x0E, 0x01, 0x70, 0x3E, 0x77, 0x77, 0x20, 0xAC, 0x05, 0x50, 0x3B, 0x07, 0x71, 0x03, 0xE7,
  0x77, 0x71, 0x02, 0xC0, 0xD6, 0x0C, 0xB0, 0x78, 0x04, 0x60, 0x8E, 0x80, 0x26, 0x04, 0x77, 0x71,
  0x08, 0xC0, 0x75, 0x06, 0xFF, 0xFD, 0x0A, 0x77, 0x71, 0x0E, 0xC0, 0x15, 0x08, 0xFF, 0xFD, 0x0A,
  0x77, 0x70, 0x6C, 0x0A, 0x60, 0x8F, 0xFF, 0xD0, 0xA7, 0x77, 0x0C, 0xC0, 0x37, 0x76, 0x03, 0xE7,
  0x77, 0x60, 0x3C, 0x0C, 0x77, 0x70, 0x3E, 0x77, 0x76, 0x0A, 0xC0, 0x57, 0x77, 0x03, 0xE7, 0x77,
  0x50, 0x1C, 0x0E, 0x77, 0x71, 0x03, 0xE7, 0x77, 0x50, 0x8C, 0x08, 0x77, 0x71, 0x03, 0xE7, 0x77,
  0x50, 0xEC, 0x01, 0x77, 0x71, 0x04, 0xE7, 0x77, 0x40, 0x5C, 0x0A, 0x77, 0x72, 0x05, 0xE0, 0x27,
  0x77, 0x30, 0xCC, 0x04, 0x77, 0x72, 0x0B, 0xE0, 0x87, 0x77, 0x20, 0x3C, 0x0D, 0x77, 0x50, 0xF6,
  0x08, 0x0D, 0xF9, 0x82, 0xB7, 0x66, 0x77, 0x50, 0x9C, 0x06, 0x77, 0x5F, 0xFB, 0x77, 0x40, 0x1C,
  0x0E, 0x77, 0x6F, 0xFB, 0x77, 0x40, 0x7C, 0x08, 0x77, 0x6F, 0xFB, 0x20,
  // "¿" (U+00BF)
  0x77, 0x85, 0x19, 0xDF, 0xEA, 0x27, 0x77, 0x30, 0x30, 0xEE, 0x04, 0x77, 0x72, 0x0D, 0xF0, 0xD7,
  0x77, 0x10, 0x2F, 0xA0, 0x27, 0x77, 0x05, 0xFA, 0x05, 0x77, 0x70, 0x6F, 0xA0, 0x67, 0x77, 0x05,
  0xFA, 0x05, 0x77, 0x70, 0x2F, 0xA0, 0x27, 0x77, 0x10, 0xDF, 0x0D, 0x77, 0x72, 0x03, 0x0E, 0xE0,
  0x47, 0x77, 0x38, 0x52, 0x9D, 0xFE, 0xA2, 0x80, 0xBE, 0x60, 0x83, 0x13, 0x33, 0x17, 0x77, 0x60,
  0xAB, 0x09, 0x77, 0x76, 0x0B, 0xB0, 0xA7, 0x77, 0x60, 0xCB, 0x0B, 0x77, 0x76, 0x0D, 0xB0, 0xC7,
  0x77, 0x60, 0xEB, 0x0D, 0x77, 0x76, 0xC0, 0xD7, 0x77, 0x6C, 0x0E, 0x77, 0x75, 0x01, 0xD7, 0x77,
  0x50, 0x2D, 0x77, 0x75, 0x03, 0xD0, 0x17, 0x77, 0x30, 0x50, 0xDD, 0x02, 0x77, 0x71, 0x04, 0x0C,
  0xF0, 0x27, 0x76, 0x01, 0x09, 0xF9, 0x0C, 0x01, 0x77, 0x50, 0x40, 0xDF, 0x0E, 0x05, 0x77, 0x60,
  0x6F, 0x90, 0xA0, 0x17, 0x76, 0x08, 0xF9, 0x05, 0x77, 0x70, 0x8F, 0x0E, 0x03, 0x77, 0x70, 0x6F,
  0x90, 0x37, 0x77, 0x03, 0xF9, 0x05, 0x77, 0x71, 0x0D, 0xF0, 0xA7, 0x77, 0x10, 0x7F, 0x90, 0x17,
  0x77, 0x10, 0xEF, 0x09, 0x77, 0x71, 0x05, 0xF9, 0x02, 0x77, 0x71, 0x0B, 0xF0, 0xC7, 0x77, 0x20,
  0xEF, 0x07, 0x77, 0x71, 0x02, 0xF9, 0x03, 0x77, 0x71, 0x06, 0xF9, 0x77, 0x72, 0x08, 0xF0, 0xC7,
  0x77, 0x20, 0x9F, 0x0A, 0x77, 0x72, 0x0A, 0xF0, 0x97, 0x77, 0x20, 0xBF, 0x09, 0x77, 0x72, 0x0A,
  0xF0, 0x87, 0x72, 0x82, 0xED, 0xA5, 0x30, 0xAF, 0x09, 0x77, 0x2C, 0x82, 0xD3, 0x08, 0xF0, 0xA7,
  0x71, 0x01, 0xD8, 0x1E, 0x26, 0xF0, 0xD7, 0x71, 0x04, 0xE0, 0x90, 0x3F, 0x90, 0x17, 0x70, 0x6E,
  0x81, 0xC0, 0xEF, 0x05, 0x77, 0x0B, 0xE8, 0x1E, 0x09, 0xF0, 0xB7, 0x60, 0x1F, 0x81, 0xC0, 0x2F,
  0x90, 0x37, 0x50, 0x7F, 0x0A, 0x20, 0xAF, 0x0C, 0x74, 0x01, 0x0E, 0xF0, 0x62, 0x01, 0x0E, 0xF0,
  0xA7, 0x20, 0x10, 0xCF, 0x0E, 0x40, 0x4F, 0x90, 0xC0, 0x46, 0x05, 0x0D, 0xF9, 0x05, 0x50, 0x5F,
  0xA8, 0x4E, 0xB9, 0xAB, 0xEF, 0xA0, 0x97, 0x04, 0x0E, 0xFF, 0xF0, 0x97, 0x20, 0x10, 0xAF, 0xFC,
  0x0E, 0x05, 0x75, 0x03, 0x0A, 0xFF, 0x81, 0xD7, 0x17, 0x72, 0x83, 0x58, 0xBD, 0xEA, 0x84, 0xED,
  0xC9, 0x63, 0x71,
  // "À" (U+00C0)
  0x77, 0x10, 0x38, 0x04, 0x70, 0x48, 0x0D, 0x10, 0x05, 0xF9, 0x0D, 0x80, 0xD2, 0x00, 0xBF, 0x90,
  0x58, 0x0D, 0x10, 0x01, 0x0D, 0xF0, 0xC8, 0x0D, 0x20, 0x03, 0xF9, 0x04, 0x80, 0xD2, 0x00, 0x5F,
  0x0C, 0x80, 0xD3, 0x00, 0x7F, 0x05, 0x80, 0xD3, 0x00, 0x8E, 0x0D, 0x80, 0xD4, 0x00, 0xAE, 0x06,
  0x80, 0xD4, 0x00, 0xAD, 0x0E, 0x01, 0x80, 0xD4, 0x00, 0xAD, 0x09, 0x80, 0xD5, 0x00, 0xAD, 0x03,
  0x80, 0xD5, 0x00, 0x9C, 0x0C, 0x80, 0xD6, 0x00, 0x7C, 0x06, 0x80, 0xD6, 0x00, 0x50, 0xEA, 0x09,
  0x80, 0xCF, 0x60, 0x0D, 0xE0, 0x38, 0x0D, 0x20, 0x02, 0xF0, 0x78, 0x0D, 0x20, 0x07, 0xF0, 0xC8,
  0x0D, 0x20, 0x0C, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x2F, 0xA0, 0x78, 0x0D, 0x00, 0x07, 0xFA, 0x0B,
  0x80, 0xD0, 0x00, 0xCF, 0xB0, 0x18, 0x0C, 0x60, 0x01, 0xFC, 0x05, 0x80, 0xC6, 0x00, 0x6B, 0x0E,
  0xF0, 0xA8, 0x0C, 0x60, 0x0B, 0xB0, 0x90, 0xEF, 0x80, 0xC5, 0x00, 0x1C, 0x06, 0x0A, 0xF0, 0x58,
  0x0C, 0x40, 0x05, 0xC0, 0x20, 0x6F, 0x09, 0x80, 0xC4, 0x00, 0xAB, 0x81, 0xE0, 0x2F, 0x0E, 0x80,
  0xC4, 0x0C, 0x0A, 0x20, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0x5C, 0x06, 0x20, 0x9F, 0x08, 0x80, 0xC2,
  0x00, 0xAC, 0x01, 0x20, 0x5F, 0x0D, 0x80, 0xC2, 0x00, 0xEB, 0x0C, 0x4F, 0x90, 0x38, 0x0C, 0x00,
  0x04, 0xC0, 0x84, 0x0B, 0xF0, 0x78, 0x0C, 0x00, 0x09, 0xC0, 0x34, 0x07, 0xF0, 0xC8, 0x0C, 0x00,
  0x0E, 0xB0, 0xE5, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x3C, 0x0A, 0x60, 0xDF, 0x06, 0x77, 0x77,
  0x60, 0x8C, 0x05, 0x60, 0x9F, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x70, 0x4F, 0x90, 0x17, 0x77, 0x74,
  0x03, 0xC0, 0xB7, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0x8C, 0x06, 0x71, 0x0A, 0xF0, 0xA7, 0x77,
  0x74, 0x0D, 0xC0, 0x17, 0x10, 0x6F, 0x0E, 0x77, 0x77, 0x30, 0x2C, 0x0C, 0x72, 0x01, 0xF9, 0x04,
  0x77, 0x77, 0x20, 0x7C, 0x07, 0x73, 0x0C, 0xF0, 0x97, 0x77, 0x72, 0x0C, 0xC0, 0x37, 0x30, 0x8F,
  0x0E, 0x77, 0x77, 0x10, 0x1C, 0x0D, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x06, 0xC0, 0x97, 0x50,
  0xEF, 0x08, 0x77, 0x77, 0x0B, 0xC0, 0x47, 0x50, 0x9F, 0x0D, 0x77, 0x76, 0x01, 0xC0, 0xE7, 0x60,
  0x5F, 0x90, 0x27, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0xF9, 0x07, 0x77, 0x75, 0x0B, 0xC0, 0x57, 0x70,
  0xBF, 0x0C, 0x77, 0x75, 0xD0, 0x17, 0x70, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x5C, 0x0B, 0x77, 0x10,
  0x2F, 0x90, 0x67, 0x77, 0x30, 0xAC, 0x06, 0x77, 0x20, 0xDF, 0x0B, 0x77, 0x73, 0x0E, 0xFF, 0xFF,
  0xA0, 0x17, 0x77, 0x10, 0x4F, 0xFF, 0xFB, 0x05, 0x77, 0x71, 0x09, 0xFF, 0xFF, 0xB0, 0xA7, 0x77,
  0x10, 0xEF, 0xFF, 0xFB, 0x0E, 0x77, 0x70, 0x4C, 0x0D, 0x80, 0x97, 0x90, 0xBF, 0x90, 0x47, 0x76,
  0x09, 0xC0, 0x77, 0x75, 0x01, 0xF9, 0x09, 0x77, 0x60, 0xDC, 0x02, 0x77, 0x60, 0xCF, 0x0E, 0x77,
  0x50, 0x3C, 0x0D, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x74, 0x08, 0xC0, 0x87, 0x77, 0x02, 0xF9, 0x08,
  0x77, 0x40, 0xDC, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD7, 0x73, 0x02, 0xC0, 0xE7, 0x77, 0x20, 0x8F,
  0x90, 0x27, 0x72, 0x07, 0xC0, 0xA7, 0x77, 0x20, 0x4F, 0x90, 0x77, 0x72, 0x0C, 0xC0, 0x57, 0x77,
  0x30, 0xEF, 0x0C, 0x77, 0x10, 0x2D, 0x77, 0x74, 0x0A, 0xF9, 0x01, 0x77, 0x07, 0xC0, 0xB7, 0x77,
  0x40, 0x6F, 0x90, 0x67, 0x70, 0xCC, 0x07, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x76, 0x02, 0xD0, 0x47,
  0x77, 0x50, 0xEF, 0x97, 0x60, 0x8D, 0x02, 0x77, 0x75, 0x0B, 0xF9, 0x05, 0x75, 0x0E, 0xD0, 0x37,
  0x77, 0x50, 0xAF, 0x90, 0xA7, 0x40, 0x7E, 0x06, 0x77, 0x75, 0x0D, 0xFA, 0x02, 0x72, 0x02, 0x0E,
  0xE0, 0xD0, 0x17, 0x77, 0x30, 0x4F, 0xB0, 0xB7, 0x81, 0x16, 0xEF, 0x98, 0x1D, 0x62, 0x77, 0x60,
  0x20, 0x8F, 0xD8, 0x1C, 0x51, 0x20, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC,
  0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC,
  0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0,
  // "Á" (U+00C1)
  0x77, 0x77, 0x20, 0x38, 0x04, 0x70, 0x48, 0x0D, 0x10, 0x0B, 0xF9, 0x08, 0x80, 0xD0, 0x00, 0x2F,
  0x90, 0xD0, 0x18, 0x0D, 0x00, 0x09, 0xF9, 0x03, 0x80, 0xD0, 0x00, 0x1F, 0x90, 0x58, 0x0D, 0x10,
  0x09, 0xF0, 0x88, 0x0D, 0x10, 0x02, 0xF0, 0xA8, 0x0D, 0x20, 0x0A, 0xE0, 0xB8, 0x0D, 0x20, 0x04,
  0xE0, 0xB8, 0x0D, 0x30, 0x0C, 0xD0, 0xC8, 0x0D, 0x30, 0x06, 0xD0, 0xC8, 0x0D, 0x30, 0x01, 0x0E,
  0xC0, 0xB8, 0x0D, 0x40, 0x09, 0xC0, 0xA8, 0x0D, 0x40, 0x03, 0xC0, 0x98, 0x0D, 0x50, 0x06, 0xB0,
  0x68, 0x0D, 0x82, 0x00, 0xDE, 0x03, 0x80, 0xD2, 0x00, 0x2F, 0x07, 0x80, 0xD2, 0x00, 0x7F, 0x0C,
  0x80, 0xD2, 0x00, 0xCF, 0x90, 0x28, 0x0D, 0x00, 0x02, 0xFA, 0x07, 0x80, 0xD0, 0x00, 0x7F, 0xA0,
  0xB8, 0x0D, 0x00, 0x0C, 0xFB, 0x01, 0x80, 0xC6, 0x00, 0x1F, 0xC0, 0x58, 0x0C, 0x60, 0x06, 0xB0,
  0xEF, 0x0A, 0x80, 0xC6, 0x00, 0xBB, 0x09, 0x0E, 0xF8, 0x0C, 0x50, 0x01, 0xC0, 0x60, 0xAF, 0x05,
  0x80, 0xC4, 0x00, 0x5C, 0x02, 0x06, 0xF0, 0x98, 0x0C, 0x40, 0x0A, 0xB8, 0x1E, 0x02, 0xF0, 0xE8,
  0x0C, 0x40, 0xC0, 0xA2, 0x0D, 0xF0, 0x38, 0x0C, 0x20, 0x05, 0xC0, 0x62, 0x09, 0xF0, 0x88, 0x0C,
  0x20, 0x0A, 0xC0, 0x12, 0x05, 0xF0, 0xD8, 0x0C, 0x20, 0x0E, 0xB0, 0xC4, 0xF9, 0x03, 0x80, 0xC0,
  0x00, 0x4C, 0x08, 0x40, 0xBF, 0x07, 0x80, 0xC0, 0x00, 0x9C, 0x03, 0x40, 0x7F, 0x0C, 0x80, 0xC0,
  0x00, 0xEB, 0x0E, 0x50, 0x2F, 0x90, 0x17, 0x77, 0x76, 0x03, 0xC0, 0xA6, 0x0D, 0xF0, 0x67, 0x77,
  0x76, 0x08, 0xC0, 0x56, 0x09, 0xF0, 0xB7, 0x77, 0x76, 0x0D, 0xC7, 0x04, 0xF9, 0x01, 0x77, 0x77,
  0x40, 0x3C, 0x0B, 0x71, 0x0E, 0xF0, 0x57, 0x77, 0x74, 0x08, 0xC0, 0x67, 0x10, 0xAF, 0x0A, 0x77,
  0x77, 0x40, 0xDC, 0x01, 0x71, 0x06, 0xF0, 0xE7, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x20, 0x1F, 0x90,
  0x47, 0x77, 0x72, 0x07, 0xC0, 0x77, 0x30, 0xCF, 0x09, 0x77, 0x77, 0x20, 0xCC, 0x03, 0x73, 0x08,
  0xF0, 0xE7, 0x77, 0x71, 0x01, 0xC0, 0xD7, 0x40, 0x3F, 0x90, 0x37, 0x77, 0x70, 0x6C, 0x09, 0x75,
  0x0E, 0xF0, 0x87, 0x77, 0x70, 0xBC, 0x04, 0x75, 0x09, 0xF0, 0xD7, 0x77, 0x60, 0x1C, 0x0E, 0x76,
  0x05, 0xF9, 0x02, 0x77, 0x75, 0x06, 0xC0, 0xA7, 0x7F, 0x90, 0x77, 0x77, 0x50, 0xBC, 0x05, 0x77,
  0x0B, 0xF0, 0xC7, 0x77, 0x5D, 0x01, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x73, 0x05, 0xC0, 0xB7, 0x71,
  0x02, 0xF9, 0x06, 0x77, 0x73, 0x0A, 0xC0, 0x67, 0x72, 0x0D, 0xF0, 0xB7, 0x77, 0x30, 0xEF, 0xFF,
  0xFA, 0x01, 0x77, 0x71, 0x04, 0xFF, 0xFF, 0xB0, 0x57, 0x77, 0x10, 0x9F, 0xFF, 0xFB, 0x0A, 0x77,
  0x71, 0x0E, 0xFF, 0xFF, 0xB0, 0xE7, 0x77, 0x04, 0xC0, 0xD8, 0x09, 0x79, 0x0B, 0xF9, 0x04, 0x77,
  0x60, 0x9C, 0x07, 0x77, 0x50, 0x1F, 0x90, 0x97, 0x76, 0x0D, 0xC0, 0x27, 0x76, 0x0C, 0xF0, 0xE7,
  0x75, 0x03, 0xC0, 0xD7, 0x77, 0x07, 0xF9, 0x03, 0x77, 0x40, 0x8C, 0x08, 0x77, 0x70, 0x2F, 0x90,
  0x87, 0x74, 0x0D, 0xC0, 0x37, 0x77, 0x10, 0xDF, 0x0D, 0x77, 0x30, 0x2C, 0x0E, 0x77, 0x72, 0x08,
  0xF9, 0x02, 0x77, 0x20, 0x7C, 0x0A, 0x77, 0x72, 0x04, 0xF9, 0x07, 0x77, 0x20, 0xCC, 0x05, 0x77,
  0x73, 0x0E, 0xF0, 0xC7, 0x71, 0x02, 0xD7, 0x77, 0x40, 0xAF, 0x90, 0x17, 0x70, 0x7C, 0x0B, 0x77,
  0x74, 0x06, 0xF9, 0x06, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x40, 0x2F, 0x90, 0xB7, 0x60, 0x2D, 0x04,
  0x77, 0x75, 0x0E, 0xF9, 0x76, 0x08, 0xD0, 0x27, 0x77, 0x50, 0xBF, 0x90, 0x57, 0x50, 0xED, 0x03,
  0x77, 0x75, 0x0A, 0xF9, 0x0A, 0x74, 0x07, 0xE0, 0x67, 0x77, 0x50, 0xDF, 0xA0, 0x27, 0x20, 0x20,
  0xEE, 0x0D, 0x01, 0x77, 0x73, 0x04, 0xFB, 0x0B, 0x78, 0x11, 0x6E, 0xF9, 0x81, 0xD6, 0x27, 0x76,
  0x02, 0x08, 0xFD, 0x81, 0xC5, 0x12, 0x0E, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C, 0x0E, 0xFF,
  0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C, 0x0E, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C, 0x0E, 0xFF,
  0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C,
  // "Â" (U+00C2)
  0x77, 0x72, 0x05, 0x80, 0x37, 0x02, 0x80, 0xD1, 0x00, 0x10, 0xEF, 0x0B, 0x80, 0xD1, 0x00, 0x7F,
  0xA0, 0x28, 0x0C, 0x70, 0x01, 0x0E, 0xFA, 0x0A, 0x80, 0xC7, 0x00, 0x8F, 0xC0, 0x38, 0x0C, 0x50,
  0x02, 0xFD, 0x0C, 0x80, 0xC5, 0x00, 0xBD, 0x0C, 0x05, 0xE0, 0x58, 0x0C, 0x30, 0x05, 0xD8, 0x2E,
  0x20, 0x7D, 0x0E, 0x01, 0x80, 0xC2, 0x00, 0xDD, 0x05, 0x30, 0xAD, 0x09, 0x80, 0xC1, 0x00, 0x8D,
  0x06, 0x50, 0xBD, 0x03, 0x77, 0x77, 0x70, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x77, 0x77, 0x70, 0xCC,
  0x08, 0x71, 0x01, 0x0C, 0xC0, 0x77, 0x77, 0x75, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x02, 0x77,
  0x77, 0x30, 0x2C, 0x08, 0x75, 0x01, 0x0C, 0xB0, 0xC7, 0x77, 0x73, 0x06, 0xB0, 0x87, 0x70, 0x10,
  0xCB, 0x01, 0x80, 0xCE, 0x60, 0x0D, 0xE0, 0x38, 0x0D, 0x20, 0x02, 0xF0, 0x78, 0x0D, 0x20, 0x07,
  0xF0, 0xC8, 0x0D, 0x20, 0x0C, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x2F, 0xA0, 0x78, 0x0D, 0x00, 0x07,
  0xFA, 0x0B, 0x80, 0xD0, 0x00, 0xCF, 0xB0, 0x18, 0x0C, 0x60, 0x01, 0xFC, 0x05, 0x80, 0xC6, 0x00,
  0x6B, 0x0E, 0xF0, 0xA8, 0x0C, 0x60, 0x0B, 0xB0, 0x90, 0xEF, 0x80, 0xC5, 0x00, 0x1C, 0x06, 0x0A,
  0xF0, 0x58, 0x0C, 0x40, 0x05, 0xC0, 0x20, 0x6F, 0x09, 0x80, 0xC4, 0x00, 0xAB, 0x81, 0xE0, 0x2F,
  0x0E, 0x80, 0xC4, 0x0C, 0x0A, 0x20, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0x5C, 0x06, 0x20, 0x9F, 0x08,
  0x80, 0xC2, 0x00, 0xAC, 0x01, 0x20, 0x5F, 0x0D, 0x80, 0xC2, 0x00, 0xEB, 0x0C, 0x4F, 0x90, 0x38,
  0x0C, 0x00, 0x04, 0xC0, 0x84, 0x0B, 0xF0, 0x78, 0x0C, 0x00, 0x09, 0xC0, 0x34, 0x07, 0xF0, 0xC8,
  0x0C, 0x00, 0x0E, 0xB0, 0xE5, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x3C, 0x0A, 0x60, 0xDF, 0x06,
  0x77, 0x77, 0x60, 0x8C, 0x05, 0x60, 0x9F, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x70, 0x4F, 0x90, 0x17,
  0x77, 0x74, 0x03, 0xC0, 0xB7, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0x8C, 0x06, 0x71, 0x0A, 0xF0,
  0xA7, 0x77, 0x74, 0x0D, 0xC0, 0x17, 0x10, 0x6F, 0x0E, 0x77, 0x77, 0x30, 0x2C, 0x0C, 0x72, 0x01,
  0xF9, 0x04, 0x77, 0x77, 0x20, 0x7C, 0x07, 0x73, 0x0C, 0xF0, 0x97, 0x77, 0x72, 0x0C, 0xC0, 0x37,
  0x30, 0x8F, 0x0E, 0x77, 0x77, 0x10, 0x1C, 0x0D, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x06, 0xC0,
  0x97, 0x50, 0xEF, 0x08, 0x77, 0x77, 0x0B, 0xC0, 0x47, 0x50, 0x9F, 0x0D, 0x77, 0x76, 0x01, 0xC0,
  0xE7, 0x60, 0x5F, 0x90, 0x27, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0xF9, 0x07, 0x77, 0x75, 0x0B, 0xC0,
  0x57, 0x70, 0xBF, 0x0C, 0x77, 0x75, 0xD0, 0x17, 0x70, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x5C, 0x0B,
  0x77, 0x10, 0x2F, 0x90, 0x67, 0x77, 0x30, 0xAC, 0x06, 0x77, 0x20, 0xDF, 0x0B, 0x77, 0x73, 0x0E,
  0xFF, 0xFF, 0xA0, 0x17, 0x77, 0x10, 0x4F, 0xFF, 0xFB, 0x05, 0x77, 0x71, 0x09, 0xFF, 0xFF, 0xB0,
  0xA7, 0x77, 0x10, 0xEF, 0xFF, 0xFB, 0x0E, 0x77, 0x70, 0x4C, 0x0D, 0x80, 0x97, 0x90, 0xBF, 0x90,
  0x47, 0x76, 0x09, 0xC0, 0x77, 0x75, 0x01, 0xF9, 0x09, 0x77, 0x60, 0xDC, 0x02, 0x77, 0x60, 0xCF,
  0x0E, 0x77, 0x50, 0x3C, 0x0D, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x74, 0x08, 0xC0, 0x87, 0x77, 0x02,
  0xF9, 0x08, 0x77, 0x40, 0xDC, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD7, 0x73, 0x02, 0xC0, 0xE7, 0x77,
  0x20, 0x8F, 0x90, 0x27, 0x72, 0x07, 0xC0, 0xA7, 0x77, 0x20, 0x4F, 0x90, 0x77, 0x72, 0x0C, 0xC0,
  0x57, 0x77, 0x30, 0xEF, 0x0C, 0x77, 0x10, 0x2D, 0x77, 0x74, 0x0A, 0xF9, 0x01, 0x77, 0x07, 0xC0,
  0xB7, 0x77, 0x40, 0x6F, 0x90, 0x67, 0x70, 0xCC, 0x07, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x76, 0x02,
  0xD0, 0x47, 0x77, 0x50, 0xEF, 0x97, 0x60, 0x8D, 0x02, 0x77, 0x75, 0x0B, 0xF9, 0x05, 0x75, 0x0E,
  0xD0, 0x37, 0x77, 0x50, 0xAF, 0x90, 0xA7, 0x40, 0x7E, 0x06, 0x77, 0x75, 0x0D, 0xFA, 0x02, 0x72,
  0x02, 0x0E, 0xE0, 0xD0, 0x17, 0x77, 0x30, 0x4F, 0xB0, 0xB7, 0x81, 0x16, 0xEF, 0x98, 0x1D, 0x62,
  0x77, 0x60, 0x20, 0x8F, 0xD8, 0x1C, 0x51, 0x20, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0,
  0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0,
  0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0,
  // "Ã" (U+00C3)
  0x77, 0x48, 0x62, 0x9D, 0xEE, 0xD9, 0x47, 0x50, 0xF3, 0x02, 0x77, 0x77, 0x20, 0x7F, 0x90, 0xC0,
  0x47, 0x20, 0x5B, 0x07, 0x77, 0x77, 0x10, 0x7F, 0xC0, 0xA0, 0x17, 0x09, 0xB0, 0x57, 0x77, 0x70,
  0x4F, 0xE0, 0xE0, 0x55, 0x02, 0xC0, 0x27, 0x77, 0x70, 0xDF, 0xF9, 0x84, 0xB4, 0x10, 0x4D, 0xB0,
  0xD7, 0x77, 0x70, 0x5B, 0x84, 0xE6, 0x11, 0x4C, 0xFF, 0xA0, 0x77, 0x77, 0x70, 0xAB, 0x06, 0x50,
  0x7F, 0xF0, 0xE0, 0x17, 0x77, 0x70, 0xEA, 0x0E, 0x70, 0x30, 0xEF, 0xD0, 0x77, 0x77, 0x70, 0x2B,
  0x0A, 0x71, 0x01, 0x0B, 0xFB, 0x0B, 0x77, 0x77, 0x10, 0x4B, 0x07, 0x73, 0x07, 0x0E, 0xF0, 0xA0,
  0x17, 0x77, 0x72, 0x0F, 0x17, 0x58, 0x61, 0x7C, 0xEF, 0xDA, 0x48, 0x0C, 0xF1, 0x00, 0xDE, 0x03,
  0x80, 0xD2, 0x00, 0x2F, 0x07, 0x80, 0xD2, 0x00, 0x7F, 0x0C, 0x80, 0xD2, 0x00, 0xCF, 0x90, 0x28,
  0x0D, 0x00, 0x02, 0xFA, 0x07, 0x80, 0xD0, 0x00, 0x7F, 0xA0, 0xB8, 0x0D, 0x00, 0x0C, 0xFB, 0x01,
  0x80, 0xC6, 0x00, 0x1F, 0xC0, 0x58, 0x0C, 0x60, 0x06, 0xB0, 0xEF, 0x0A, 0x80, 0xC6, 0x00, 0xBB,
  0x09, 0x0E, 0xF8, 0x0C, 0x50, 0x01, 0xC0, 0x60, 0xAF, 0x05, 0x80, 0xC4, 0x00, 0x5C, 0x02, 0x06,
  0xF0, 0x98, 0x0C, 0x40, 0x0A, 0xB8, 0x1E, 0x02, 0xF0, 0xE8, 0x0C, 0x40, 0xC0, 0xA2, 0x0D, 0xF0,
  0x38, 0x0C, 0x20, 0x05, 0xC0, 0x62, 0x09, 0xF0, 0x88, 0x0C, 0x20, 0x0A, 0xC0, 0x12, 0x05, 0xF0,
  0xD8, 0x0C, 0x20, 0x0E, 0xB0, 0xC4, 0xF9, 0x03, 0x80, 0xC0, 0x00, 0x4C, 0x08, 0x40, 0xBF, 0x07,
  0x80, 0xC0, 0x00, 0x9C, 0x03, 0x40, 0x7F, 0x0C, 0x80, 0xC0, 0x00, 0xEB, 0x0E, 0x50, 0x2F, 0x90,
  0x17, 0x77, 0x76, 0x03, 0xC0, 0xA6, 0x0D, 0xF0, 0x67, 0x77, 0x76, 0x08, 0xC0, 0x56, 0x09, 0xF0,
  0xB7, 0x77, 0x76, 0x0D, 0xC7, 0x04, 0xF9, 0x01, 0x77, 0x77, 0x40, 0x3C, 0x0B, 0x71, 0x0E, 0xF0,
  0x57, 0x77, 0x74, 0x08, 0xC0, 0x67, 0x10, 0xAF, 0x0A, 0x77, 0x77, 0x40, 0xDC, 0x01, 0x71, 0x06,
  0xF0, 0xE7, 0x77, 0x73, 0x02, 0xC0, 0xC7, 0x20, 0x1F, 0x90, 0x47, 0x77, 0x72, 0x07, 0xC0, 0x77,
  0x30, 0xCF, 0x09, 0x77, 0x77, 0x20, 0xCC, 0x03, 0x73, 0x08, 0xF0, 0xE7, 0x77, 0x71, 0x01, 0xC0,
  0xD7, 0x40, 0x3F, 0x90, 0x37, 0x77, 0x70, 0x6C, 0x09, 0x75, 0x0E, 0xF0, 0x87, 0x77, 0x70, 0xBC,
  0x04, 0x75, 0x09, 0xF0, 0xD7, 0x77, 0x60, 0x1C, 0x0E, 0x76, 0x05, 0xF9, 0x02, 0x77, 0x75, 0x06,
  0xC0, 0xA7, 0x7F, 0x90, 0x77, 0x77, 0x50, 0xBC, 0x05, 0x77, 0x0B, 0xF0, 0xC7, 0x77, 0x5D, 0x01,
  0x77, 0x06, 0xF9, 0x01, 0x77, 0x73, 0x05, 0xC0, 0xB7, 0x71, 0x02, 0xF9, 0x06, 0x77, 0x73, 0x0A,
  0xC0, 0x67, 0x72, 0x0D, 0xF0, 0xB7, 0x77, 0x30, 0xEF, 0xFF, 0xFA, 0x01, 0x77, 0x71, 0x04, 0xFF,
  0xFF, 0xB0, 0x57, 0x77, 0x10, 0x9F, 0xFF, 0xFB, 0x0A, 0x77, 0x71, 0x0E, 0xFF, 0xFF, 0xB0, 0xE7,
  0x77, 0x04, 0xC0, 0xD8, 0x09, 0x79, 0x0B, 0xF9, 0x04, 0x77, 0x60, 0x9C, 0x07, 0x77, 0x50, 0x1F,
  0x90, 0x97, 0x76, 0x0D, 0xC0, 0x27, 0x76, 0x0C, 0xF0, 0xE7, 0x75, 0x03, 0xC0, 0xD7, 0x77, 0x07,
  0xF9, 0x03, 0x77, 0x40, 0x8C, 0x08, 0x77, 0x70, 0x2F, 0x90, 0x87, 0x74, 0x0D, 0xC0, 0x37, 0x77,
  0x10, 0xDF, 0x0D, 0x77, 0x30, 0x2C, 0x0E, 0x77, 0x72, 0x08, 0xF9, 0x02, 0x77, 0x20, 0x7C, 0x0A,
  0x77, 0x72, 0x04, 0xF9, 0x07, 0x77, 0x20, 0xCC, 0x05, 0x77, 0x73, 0x0E, 0xF0, 0xC7, 0x71, 0x02,
  0xD7, 0x77, 0x40, 0xAF, 0x90, 0x17, 0x70, 0x7C, 0x0B, 0x77, 0x74, 0x06, 0xF9, 0x06, 0x77, 0x0C,
  0xC0, 0x77, 0x77, 0x40, 0x2F, 0x90, 0xB7, 0x60, 0x2D, 0x04, 0x77, 0x75, 0x0E, 0xF9, 0x76, 0x08,
  0xD0, 0x27, 0x77, 0x50, 0xBF, 0x90, 0x57, 0x50, 0xED, 0x03, 0x77, 0x75, 0x0A, 0xF9, 0x0A, 0x74,
  0x07, 0xE0, 0x67, 0x77, 0x50, 0xDF, 0xA0, 0x27, 0x20, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x73, 0x04,
  0xFB, 0x0B, 0x78, 0x11, 0x6E, 0xF9, 0x81, 0xD6, 0x27, 0x76, 0x02, 0x08, 0xFD, 0x81, 0xC5, 0x12,
  0x0E, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C, 0x0E, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C,
  0x0E, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C, 0x0E, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C,
  // "Ä" (U+00C4)
  0x77, 0x38, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x47, 0x77, 0x76, 0x01, 0x0E, 0xD0,
  0x37, 0x0D, 0xD0, 0x57, 0x77, 0x75, 0x08, 0xE0, 0xB6, 0x06, 0xE0, 0xD7, 0x77, 0x75, 0x0C, 0xF6,
  0x0A, 0xF0, 0x27, 0x77, 0x74, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47, 0x77, 0x74, 0x0E, 0xF0, 0x25,
  0x0B, 0xF0, 0x47, 0x77, 0x74, 0x0C, 0xF6, 0x0A, 0xF0, 0x27, 0x77, 0x74, 0x09, 0xE0, 0xC6, 0x07,
  0xE0, 0xE7, 0x77, 0x75, 0x02, 0x0E, 0xD0, 0x46, 0x01, 0x0D, 0xD0, 0x67, 0x77, 0x76, 0x84, 0x2A,
  0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC5, 0x80, 0xFB, 0x60, 0x0D, 0xE0, 0x38, 0x0D, 0x20, 0x02,
  0xF0, 0x78, 0x0D, 0x20, 0x07, 0xF0, 0xC8, 0x0D, 0x20, 0x0C, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x2F,
  0xA0, 0x78, 0x0D, 0x00, 0x07, 0xFA, 0x0B, 0x80, 0xD0, 0x00, 0xCF, 0xB0, 0x18, 0x0C, 0x60, 0x01,
  0xFC, 0x05, 0x80, 0xC6, 0x00, 0x6B, 0x0E, 0xF0, 0xA8, 0x0C, 0x60, 0x0B, 0xB0, 0x90, 0xEF, 0x80,
  0xC5, 0x00, 0x1C, 0x06, 0x0A, 0xF0, 0x58, 0x0C, 0x40, 0x05, 0xC0, 0x20, 0x6F, 0x09, 0x80, 0xC4,
  0x00, 0xAB, 0x81, 0xE0, 0x2F, 0x0E, 0x80, 0xC4, 0x0C, 0x0A, 0x20, 0xDF, 0x03, 0x80, 0xC2, 0x00,
  0x5C, 0x06, 0x20, 0x9F, 0x08, 0x80, 0xC2, 0x00, 0xAC, 0x01, 0x20, 0x5F, 0x0D, 0x80, 0xC2, 0x00,
  0xEB, 0x0C, 0x4F, 0x90, 0x38, 0x0C, 0x00, 0x04, 0xC0, 0x84, 0x0B, 0xF0, 0x78, 0x0C, 0x00, 0x09,
  0xC0, 0x34, 0x07, 0xF0, 0xC8, 0x0C, 0x00, 0x0E, 0xB0, 0xE5, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x60,
  0x3C, 0x0A, 0x60, 0xDF, 0x06, 0x77, 0x77, 0x60, 0x8C, 0x05, 0x60, 0x9F, 0x0B, 0x77, 0x77, 0x60,
  0xDC, 0x70, 0x4F, 0x90, 0x17, 0x77, 0x74, 0x03, 0xC0, 0xB7, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40,
  0x8C, 0x06, 0x71, 0x0A, 0xF0, 0xA7, 0x77, 0x74, 0x0D, 0xC0, 0x17, 0x10, 0x6F, 0x0E, 0x77, 0x77,
  0x30, 0x2C, 0x0C, 0x72, 0x01, 0xF9, 0x04, 0x77, 0x77, 0x20, 0x7C, 0x07, 0x73, 0x0C, 0xF0, 0x97,
  0x77, 0x72, 0x0C, 0xC0, 0x37, 0x30, 0x8F, 0x0E, 0x77, 0x77, 0x10, 0x1C, 0x0D, 0x74, 0x03, 0xF9,
  0x03, 0x77, 0x77, 0x06, 0xC0, 0x97, 0x50, 0xEF, 0x08, 0x77, 0x77, 0x0B, 0xC0, 0x47, 0x50, 0x9F,
  0x0D, 0x77, 0x76, 0x01, 0xC0, 0xE7, 0x60, 0x5F, 0x90, 0x27, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0xF9,
  0x07, 0x77, 0x75, 0x0B, 0xC0, 0x57, 0x70, 0xBF, 0x0C, 0x77, 0x75, 0xD0, 0x17, 0x70, 0x6F, 0x90,
  0x17, 0x77, 0x30, 0x5C, 0x0B, 0x77, 0x10, 0x2F, 0x90, 0x67, 0x77, 0x30, 0xAC, 0x06, 0x77, 0x20,
  0xDF, 0x0B, 0x77, 0x73, 0x0E, 0xFF, 0xFF, 0xA0, 0x17, 0x77, 0x10, 0x4F, 0xFF, 0xFB, 0x05, 0x77,
  0x71, 0x09, 0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x10, 0xEF, 0xFF, 0xFB, 0x0E, 0x77, 0x70, 0x4C, 0x0D,
  0x80, 0x97, 0x90, 0xBF, 0x90, 0x47, 0x76, 0x09, 0xC0, 0x77, 0x75, 0x01, 0xF9, 0x09, 0x77, 0x60,
  0xDC, 0x02, 0x77, 0x60, 0xCF, 0x0E, 0x77, 0x50, 0x3C, 0x0D, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x74,
  0x08, 0xC0, 0x87, 0x77, 0x02, 0xF9, 0x08, 0x77, 0x40, 0xDC, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD7,
  0x73, 0x02, 0xC0, 0xE7, 0x77, 0x20, 0x8F, 0x90, 0x27, 0x72, 0x07, 0xC0, 0xA7, 0x77, 0x20, 0x4F,
  0x90, 0x77, 0x72, 0x0C, 0xC0, 0x57, 0x77, 0x30, 0xEF, 0x0C, 0x77, 0x10, 0x2D, 0x77, 0x74, 0x0A,
  0xF9, 0x01, 0x77, 0x07, 0xC0, 0xB7, 0x77, 0x40, 0x6F, 0x90, 0x67, 0x70, 0xCC, 0x07, 0x77, 0x74,
  0x02, 0xF9, 0x0B, 0x76, 0x02, 0xD0, 0x47, 0x77, 0x50, 0xEF, 0x97, 0x60, 0x8D, 0x02, 0x77, 0x75,
  0x0B, 0xF9, 0x05, 0x75, 0x0E, 0xD0, 0x37, 0x77, 0x50, 0xAF, 0x90, 0xA7, 0x40, 0x7E, 0x06, 0x77,
  0x75, 0x0D, 0xFA, 0x02, 0x72, 0x02, 0x0E, 0xE0, 0xD0, 0x17, 0x77, 0x30, 0x4F, 0xB0, 0xB7, 0x81,
  0x16, 0xEF, 0x98, 0x1D, 0x62, 0x77, 0x60, 0x20, 0x8F, 0xD8, 0x1C, 0x51, 0x20, 0xEF, 0xFC, 0x01,
  0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01,
  0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0,
  // "Å" (U+00C5)
  0x77, 0x73, 0x85, 0x15, 0x78, 0x76, 0x18, 0x0D, 0x20, 0x03, 0x0B, 0xF0, 0xB0, 0x38, 0x0C, 0x70,
  0x06, 0xFC, 0x08, 0x80, 0xC5, 0x00, 0x6F, 0xE0, 0x88, 0x0C, 0x30, 0x03, 0xFF, 0x90, 0x58, 0x0C,
  0x20, 0x0B, 0xC8, 0x5C, 0x51, 0x01, 0x4B, 0xC0, 0xD8, 0x0C, 0x10, 0x01, 0xC0, 0xA7, 0x08, 0xC0,
  0x38, 0x0C, 0x00, 0x05, 0xB0, 0xE7, 0x20, 0xCB, 0x07, 0x80, 0xC0, 0x00, 0x7B, 0x09, 0x72, 0x07,
  0xB0, 0xA8, 0x0C, 0x00, 0x09, 0xB0, 0x77, 0x20, 0x4B, 0x0B, 0x80, 0xC0, 0x00, 0x9B, 0x06, 0x72,
  0x03, 0xB0, 0xC8, 0x0C, 0x00, 0x09, 0xB0, 0x77, 0x20, 0x4B, 0x0B, 0x80, 0xC0, 0x00, 0x7B, 0x09,
  0x72, 0x07, 0xB0, 0x98, 0x0C, 0x00, 0x04, 0xB0, 0xE7, 0x20, 0xDB, 0x07, 0x80, 0xC1, 0x0C, 0x09,
  0x70, 0x8C, 0x02, 0x80, 0xC1, 0x00, 0x9C, 0x85, 0xC5, 0x10, 0x14, 0xBC, 0x0B, 0x80, 0xC2, 0x00,
  0x20, 0xEF, 0xF0, 0x38, 0x0C, 0x30, 0x05, 0xFE, 0x06, 0x80, 0xC5, 0x00, 0x40, 0xDF, 0xA0, 0xE0,
  0x58, 0x0D, 0x00, 0x0C, 0xF9, 0x04, 0x80, 0xD0, 0x00, 0x1F, 0xA0, 0x78, 0x0D, 0x00, 0x06, 0xFA,
  0x0C, 0x80, 0xD0, 0x00, 0xBF, 0xB0, 0x18, 0x0C, 0x70, 0xFC, 0x06, 0x80, 0xC6, 0x00, 0x5B, 0x0C,
  0xF0, 0xB8, 0x0C, 0x60, 0x0A, 0xB0, 0x70, 0xCF, 0x01, 0x80, 0xC5, 0x00, 0xEB, 0x04, 0x08, 0xF0,
  0x58, 0x0C, 0x40, 0x05, 0xC1, 0x03, 0xF0, 0xA8, 0x0C, 0x40, 0x0A, 0xB0, 0xB2, 0x0E, 0xE0, 0xE8,
  0x0C, 0x40, 0x0E, 0xB0, 0x72, 0x0A, 0xF0, 0x48, 0x0C, 0x20, 0x04, 0xC0, 0x32, 0x06, 0xF0, 0x98,
  0x0C, 0x20, 0x09, 0xB0, 0xE3, 0x01, 0xF0, 0xD8, 0x0C, 0x20, 0x0E, 0xB0, 0x94, 0x0C, 0xF0, 0x38,
  0x0C, 0x00, 0x03, 0xC0, 0x54, 0x08, 0xF0, 0x88, 0x0C, 0x00, 0x08, 0xC5, 0x03, 0xF0, 0xC8, 0x0C,
  0x00, 0x0D, 0xB0, 0xB6, 0x0E, 0xF0, 0x27, 0x77, 0x76, 0x03, 0xC0, 0x66, 0x0A, 0xF0, 0x77, 0x77,
  0x76, 0x08, 0xC0, 0x16, 0x05, 0xF0, 0xB7, 0x77, 0x76, 0x0D, 0xB0, 0xC7, 0x01, 0xF9, 0x01, 0x77,
  0x77, 0x40, 0x2C, 0x08, 0x71, 0x0C, 0xF0, 0x57, 0x77, 0x74, 0x07, 0xC0, 0x37, 0x10, 0x8F, 0x0A,
  0x77, 0x77, 0x40, 0xCB, 0x0E, 0x72, 0x03, 0xF0, 0xE7, 0x77, 0x73, 0x01, 0xC0, 0xA7, 0x30, 0xEF,
  0x04, 0x77, 0x77, 0x20, 0x7C, 0x05, 0x73, 0x0A, 0xF0, 0x97, 0x77, 0x72, 0x0B, 0xC0, 0x17, 0x30,
  0x6F, 0x0E, 0x77, 0x77, 0x10, 0x1C, 0x0C, 0x74, 0x01, 0xF9, 0x03, 0x77, 0x77, 0x06, 0xC0, 0x77,
  0x50, 0xCF, 0x08, 0x77, 0x77, 0x0B, 0xC0, 0x27, 0x50, 0x8F, 0x0D, 0x77, 0x76, 0x01, 0xC0, 0xD7,
  0x60, 0x4F, 0x90, 0x27, 0x77, 0x50, 0x5C, 0x09, 0x77, 0x0E, 0xF0, 0x77, 0x77, 0x50, 0xAC, 0x04,
  0x77, 0x0A, 0xF0, 0xC7, 0x77, 0x5D, 0x77, 0x10, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x5C, 0x0B, 0x77,
  0x10, 0x1F, 0x90, 0x67, 0x77, 0x30, 0xAC, 0x06, 0x77, 0x20, 0xDF, 0x0B, 0x77, 0x73, 0x0E, 0xFF,
  0xFF, 0xA7, 0x77, 0x20, 0x4F, 0xFF, 0xFB, 0x05, 0x77, 0x71, 0x09, 0xFF, 0xFF, 0xB0, 0x97, 0x77,
  0x10, 0xEF, 0xFF, 0xFB, 0x0E, 0x77, 0x70, 0x3C, 0x0D, 0x80, 0x97, 0x90, 0xBF, 0x90, 0x37, 0x76,
  0x08, 0xC0, 0x77, 0x75, 0x01, 0xF9, 0x08, 0x77, 0x60, 0xDC, 0x02, 0x77, 0x60, 0xCF, 0x0D, 0x77,
  0x50, 0x3C, 0x0D, 0x77, 0x70, 0x7F, 0x90, 0x27, 0x74, 0x08, 0xC0, 0x87, 0x77, 0x02, 0xF9, 0x07,
  0x77, 0x40, 0xDC, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xC7, 0x73, 0x02, 0xC0, 0xE7, 0x77, 0x20, 0x8F,
  0x90, 0x17, 0x72, 0x07, 0xC0, 0xA7, 0x77, 0x20, 0x4F, 0x90, 0x67, 0x72, 0x0C, 0xC0, 0x57, 0x77,
  0x30, 0xEF, 0x0B, 0x77, 0x10, 0x2D, 0x77, 0x74, 0x0A, 0xF9, 0x77, 0x10, 0x7C, 0x0B, 0x77, 0x74,
  0x06, 0xF9, 0x05, 0x77, 0x0C, 0xC0, 0x77, 0x77, 0x40, 0x2F, 0x90, 0xA7, 0x60, 0x2D, 0x04, 0x77,
  0x75, 0x0E, 0xF0, 0xE7, 0x60, 0x8D, 0x02, 0x77, 0x75, 0x0B, 0xF9, 0x04, 0x75, 0x0E, 0xD0, 0x37,
  0x77, 0x50, 0xAF, 0x90, 0xA7, 0x40, 0x7E, 0x06, 0x77, 0x75, 0x0D, 0xFA, 0x02, 0x72, 0x02, 0x0E,
  0xE0, 0xD0, 0x17, 0x77, 0x30, 0x4F, 0xB0, 0xC7, 0x81, 0x16, 0xEF, 0x98, 0x1D, 0x62, 0x77, 0x68,
  0x12, 0x7E, 0xFC, 0x81, 0xD5, 0x22, 0x0E, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C, 0x0E, 0xFF,
  0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C, 0x0E, 0xFF, 0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C, 0x0E, 0xFF,
  0xC0, 0x17, 0x50, 0x1F, 0xFF, 0x0C,
  // "Æ" (U+00C6)
  0x77, 0x74, 0x0D, 0x80, 0xC6, 0xF0, 0x77, 0x77, 0x70, 0xD8, 0x0C, 0x6F, 0x08, 0x77, 0x77, 0x0D,
  0x80, 0xC6, 0xF0, 0x87, 0x77, 0x70, 0xB0, 0xE8, 0x0C, 0x5F, 0x09, 0x77, 0x77, 0x38, 0x11, 0x26,
  0xC0, 0xB0, 0xDF, 0x0E, 0x80, 0x91, 0x90, 0xA0, 0xDF, 0x90, 0x97, 0x77, 0x75, 0x0A, 0xC0, 0x10,
  0x9F, 0x0C, 0x77, 0x10, 0x30, 0xCE, 0x09, 0x77, 0x77, 0x40, 0x2C, 0x81, 0x90, 0x9F, 0x0C, 0x77,
  0x30, 0xBD, 0x0A, 0x77, 0x77, 0x40, 0x9C, 0x81, 0x30, 0x9F, 0x0C, 0x77, 0x30, 0x10, 0xEC, 0x0A,
  0x77, 0x77, 0x30, 0x10, 0xEB, 0x0B, 0x20, 0x9F, 0x0C, 0x77, 0x40, 0x9C, 0x0A, 0x77, 0x77, 0x30,
  0x7C, 0x04, 0x20, 0x9F, 0x0C, 0x77, 0x40, 0x3C, 0x0B, 0x77, 0x77, 0x30, 0xEB, 0x0D, 0x30, 0x9F,
  0x0C, 0x77, 0x50, 0xEB, 0x0B, 0x77, 0x77, 0x20, 0x6C, 0x06, 0x30, 0x9F, 0x0C, 0x77, 0x50, 0xCB,
  0x0B, 0x77, 0x77, 0x20, 0xCB, 0x0E, 0x40, 0x9F, 0x0C, 0x77, 0x50, 0xAB, 0x0C, 0x77, 0x77, 0x10,
  0x4C, 0x08, 0x40, 0x9F, 0x0C, 0x77, 0x50, 0x8B, 0x0C, 0x77, 0x77, 0x10, 0xBC, 0x02, 0x40, 0x9F,
  0x0C, 0x77, 0x50, 0x7B, 0x0C, 0x77, 0x77, 0x02, 0xC0, 0xA5, 0x09, 0xF0, 0xC7, 0x75, 0x83, 0x38,
  0x88, 0x67, 0x77, 0x70, 0x9C, 0x03, 0x50, 0x9F, 0x0C, 0x80, 0xD7, 0x00, 0x1C, 0x0C, 0x60, 0x9F,
  0x0C, 0x80, 0xD7, 0x00, 0x8C, 0x05, 0x60, 0x9F, 0x0C, 0x80, 0xD7, 0x00, 0xEB, 0x0D, 0x70, 0x9F,
  0x0C, 0x80, 0xD6, 0x00, 0x6C, 0x07, 0x70, 0x9F, 0x0C, 0x80, 0xD6, 0x00, 0xDB, 0x0E, 0x01, 0x70,
  0x9F, 0x0C, 0x80, 0xD5, 0x00, 0x5C, 0x09, 0x71, 0x09, 0xF0, 0xC8, 0x0D, 0x50, 0x0C, 0xC0, 0x27,
  0x10, 0x9F, 0x0C, 0x80, 0xD4, 0x00, 0x3C, 0x0B, 0x72, 0x09, 0xF0, 0xC8, 0x0D, 0x40, 0x0A, 0xC0,
  0x47, 0x20, 0x9F, 0x0C, 0x80, 0xD3, 0x00, 0x2C, 0x0D, 0x73, 0x09, 0xF0, 0xC8, 0x0D, 0x30, 0x09,
  0xC0, 0x67, 0x30, 0x9F, 0x0C, 0x80, 0xD2, 0x00, 0x10, 0xEB, 0x0E, 0x74, 0x09, 0xFF, 0xFD, 0x05,
  0x77, 0x76, 0x07, 0xC0, 0x87, 0x40, 0x9F, 0xFF, 0xD0, 0x57, 0x77, 0x60, 0xEC, 0x01, 0x74, 0x09,
  0xFF, 0xFD, 0x05, 0x77, 0x75, 0x05, 0xC0, 0xA7, 0x50, 0x9F, 0xFF, 0xD0, 0x57, 0x77, 0x50, 0xCC,
  0x03, 0x75, 0x09, 0xF0, 0xE8, 0x09, 0x69, 0x03, 0x77, 0x74, 0x04, 0xC0, 0xB7, 0x60, 0x9F, 0x0C,
  0x80, 0xD0, 0x00, 0xBC, 0x05, 0x76, 0x09, 0xF0, 0xC8, 0x0C, 0x70, 0x02, 0xC0, 0xD7, 0x70, 0x9F,
  0x0C, 0x80, 0xC7, 0x00, 0x9C, 0x07, 0x77, 0x09, 0xF0, 0xC8, 0x0C, 0x60, 0x01, 0xC0, 0xE0, 0x17,
  0x70, 0x9F, 0x0C, 0x80, 0xC6, 0x00, 0x8F, 0xFF, 0xF0, 0xC8, 0x0C, 0x60, 0x0E, 0xFF, 0xFF, 0x0C,
  0x80, 0xC5, 0x00, 0x6F, 0xFF, 0xF9, 0x0C, 0x80, 0xC5, 0x00, 0xDF, 0xFF, 0xF9, 0x0C, 0x80, 0xC4,
  0x00, 0x5C, 0x0D, 0x80, 0x95, 0x90, 0xDF, 0x0C, 0x80, 0xC4, 0x00, 0xCC, 0x05, 0x77, 0x30, 0x9F,
  0x0C, 0x80, 0xC3, 0x00, 0x3C, 0x0D, 0x77, 0x40, 0x9F, 0x0C, 0x80, 0xC3, 0x00, 0xAC, 0x07, 0x77,
  0x40, 0x9F, 0x0C, 0x80, 0xC2, 0x00, 0x2D, 0x01, 0x77, 0x40, 0x9F, 0x0C, 0x80, 0xC2, 0x00, 0x9C,
  0x09, 0x77, 0x50, 0x9F, 0x0C, 0x80, 0xC1, 0x00, 0x10, 0xEC, 0x02, 0x77, 0x50, 0x9F, 0x0C, 0x77,
  0x71, 0x83, 0x79, 0x99, 0x47, 0x30, 0x7C, 0x0B, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x71, 0x0E, 0xB0,
  0x67, 0x30, 0xDC, 0x04, 0x77, 0x60, 0x9F, 0x0C, 0x77, 0x70, 0x1C, 0x06, 0x72, 0x05, 0xC0, 0xD7,
  0x77, 0x09, 0xF0, 0xC7, 0x77, 0x03, 0xC0, 0x57, 0x20, 0xCC, 0x07, 0x77, 0x70, 0x9F, 0x0C, 0x77,
  0x70, 0x5C, 0x05, 0x71, 0x04, 0xD0, 0x17, 0x77, 0x09, 0xF0, 0xC7, 0x77, 0x09, 0xC0, 0x47, 0x10,
  0xCC, 0x0C, 0x77, 0x71, 0x0A, 0xF0, 0xC7, 0x77, 0x0D, 0xC0, 0x47, 0x05, 0xD0, 0x87, 0x77, 0x10,
  0xBF, 0x0C, 0x77, 0x60, 0x5D, 0x03, 0x70, 0xDD, 0x06, 0x77, 0x71, 0x0E, 0xF0, 0xC7, 0x76, 0x0D,
  0xD0, 0x26, 0x09, 0xE0, 0x87, 0x77, 0x03, 0xF9, 0x0C, 0x77, 0x50, 0xAE, 0x02, 0x50, 0x7F, 0x0E,
  0x01, 0x77, 0x50, 0x10, 0xDF, 0x90, 0xC7, 0x73, 0x03, 0x0B, 0xF0, 0x13, 0x03, 0x0A, 0xFA, 0x81,
  0xD5, 0x17, 0x78, 0x21, 0x38, 0xEF, 0xA0, 0xE8, 0x09, 0x39, 0x0A, 0x0D, 0xFA, 0x00, 0x1F, 0xFC,
  0x0B, 0x72, 0x0E, 0x80, 0xC5, 0xF1, 0x01, 0xFF, 0xC0, 0xB7, 0x20, 0xE8, 0x0C, 0x5F, 0x10, 0x1F,
  0xFC, 0x0B, 0x72, 0x0E, 0x80, 0xC5, 0xF1, 0x01, 0xFF, 0xC0, 0xB7, 0x20, 0xE8, 0x0C, 0x4F, 0x0E,
  0x10,
  // "Ç" (U+00C7)
  0x77, 0x48, 0x42, 0x69, 0xBD, 0xEA, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x77, 0x38, 0x12, 0x8E, 0xFF,
  0x90, 0xB0, 0x67, 0x76, 0x03, 0x0B, 0xFF, 0xE0, 0xD0, 0x47, 0x73, 0x09, 0xFF, 0xFB, 0x09, 0x77,
  0x02, 0x0D, 0xFA, 0x85, 0xEB, 0xA9, 0xAB, 0xEF, 0xB0, 0xB7, 0x50, 0x30, 0xEF, 0x81, 0xE8, 0x27,
  0x05, 0x0C, 0xFA, 0x09, 0x73, 0x03, 0x0E, 0xF0, 0x90, 0x17, 0x40, 0x8F, 0xA0, 0x37, 0x10, 0x20,
  0xEF, 0x06, 0x77, 0x08, 0xF9, 0x0A, 0x70, 0x10, 0xDF, 0x06, 0x77, 0x20, 0xCF, 0x97, 0x0A, 0xF0,
  0x97, 0x73, 0x03, 0xF9, 0x02, 0x50, 0x4F, 0x0D, 0x77, 0x50, 0xCF, 0x02, 0x50, 0xDF, 0x06, 0x77,
  0x50, 0x8F, 0x50, 0x7F, 0x0D, 0x77, 0x60, 0x4E, 0x0B, 0x50, 0xEF, 0x07, 0x77, 0x60, 0x1E, 0x03,
  0x40, 0x5F, 0x90, 0x17, 0x77, 0xC0, 0xE0, 0x55, 0x0C, 0xF0, 0xC7, 0x77, 0x18, 0x3D, 0xFD, 0x91,
  0x50, 0x2F, 0x90, 0x77, 0x77, 0x10, 0x20, 0x17, 0x10, 0x7F, 0x90, 0x37, 0x77, 0x74, 0x0C, 0xF0,
  0xE7, 0x77, 0x74, 0x01, 0xF9, 0x0C, 0x77, 0x77, 0x40, 0x5F, 0x90, 0x97, 0x77, 0x74, 0x08, 0xF9,
  0x06, 0x77, 0x77, 0x40, 0xBF, 0x90, 0x47, 0x77, 0x74, 0x0E, 0xF9, 0x01, 0x77, 0x77, 0x30, 0x1F,
  0xA7, 0x77, 0x74, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0x5F, 0x90, 0xC7, 0x77, 0x74, 0x06, 0xF9,
  0x0B, 0x77, 0x77, 0x40, 0x8F, 0x90, 0xB7, 0x77, 0x74, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x40, 0x9F,
  0x90, 0x97, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40, 0xAF, 0x90, 0x97, 0x77, 0x74, 0x0A,
  0xF9, 0x09, 0x77, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40,
  0x8F, 0x90, 0xA7, 0x77, 0x74, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x6F, 0x90, 0xC7, 0x77, 0x74,
  0x05, 0xF9, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xE7, 0x77, 0x74, 0x01, 0xFA, 0x01, 0x77, 0x77,
  0x40, 0xEF, 0x90, 0x37, 0x77, 0x74, 0x0B, 0xF9, 0x05, 0x77, 0x77, 0x40, 0x8F, 0x90, 0x77, 0x77,
  0x74, 0x05, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x2F, 0x90, 0xE7, 0x77, 0x75, 0x0D, 0xF9, 0x02, 0x77,
  0x77, 0x40, 0x8F, 0x90, 0x67, 0x77, 0x74, 0x03, 0xF9, 0x0B, 0x77, 0x77, 0x50, 0xDF, 0x90, 0x17,
  0x77, 0x74, 0x07, 0xF9, 0x07, 0x77, 0x77, 0x40, 0x1F, 0x90, 0xD7, 0x77, 0x75, 0x09, 0xF9, 0x05,
  0x77, 0x74, 0x0B, 0x03, 0x50, 0x10, 0xEF, 0x0D, 0x77, 0x73, 0x81, 0x9F, 0xB6, 0x07, 0xF9, 0x08,
  0x77, 0x71, 0x06, 0xA0, 0xE7, 0x0D, 0xF9, 0x04, 0x77, 0x60, 0x5B, 0x0E, 0x70, 0x3F, 0x90, 0xE0,
  0x37, 0x74, 0x07, 0xC0, 0xC7, 0x10, 0x5F, 0xA0, 0x67, 0x72, 0x09, 0xD0, 0x67, 0x20, 0x8F, 0xA0,
  0xB0, 0x37, 0x50, 0x50, 0xDD, 0x0D, 0x74, 0x07, 0xFB, 0x82, 0xC7, 0x41, 0x38, 0x31, 0x36, 0x9E,
  0xF0, 0x37, 0x50, 0x6F, 0xFF, 0xE0, 0x47, 0x70, 0x30, 0xDF, 0xFF, 0xA0, 0xD0, 0x37, 0x73, 0x08,
  0x0E, 0xFF, 0xD0, 0xE0, 0x77, 0x76, 0x81, 0x17, 0xCF, 0xF9, 0x81, 0xC7, 0x17, 0x77, 0x38, 0x22,
  0x69, 0xBD, 0x84, 0xEC, 0xB8, 0x52, 0x77, 0x77, 0x30, 0xBB, 0x80, 0xC2, 0x00, 0xEA, 0x0C, 0x80,
  0xC1, 0x00, 0x3B, 0x81, 0xC5, 0x27, 0x77, 0x77, 0x07, 0xE0, 0xD0, 0x57, 0x77, 0x75, 0x0A, 0xF9,
  0x0A, 0x77, 0x77, 0x40, 0x90, 0xDF, 0x90, 0xA7, 0x77, 0x75, 0x03, 0x0B, 0xF0, 0x47, 0x77, 0x76,
  0x08, 0xE0, 0xA7, 0x77, 0x77, 0x0C, 0xD0, 0xE7, 0x77, 0x77, 0x06, 0xE0, 0x17, 0x77, 0x76, 0x04,
  0xE0, 0x27, 0x77, 0x76, 0x03, 0xE0, 0x27, 0x77, 0x76, 0x05, 0xE7, 0x77, 0x77, 0x09, 0xD0, 0xD7,
  0x77, 0x76, 0x02, 0xE0, 0xA7, 0x77, 0x50, 0x26, 0x03, 0x0D, 0xE0, 0x47, 0x77, 0x40, 0x1A, 0x83,
  0xCB, 0x99, 0xCF, 0x0C, 0x77, 0x75, 0x01, 0xFE, 0x0E, 0x02, 0x77, 0x75, 0x01, 0xFD, 0x0E, 0x04,
  0x77, 0x76, 0x01, 0xFC, 0x0B, 0x02, 0x77, 0x77, 0x18, 0x91, 0x37, 0xAC, 0xEF, 0xED, 0xB8, 0x37,
  0x71,
  // "È" (U+00C8)
  0x73, 0x03, 0x80, 0x47, 0x04, 0x77, 0x77, 0x60, 0x5F, 0x90, 0xD7, 0x77, 0x77, 0x0B, 0xF9, 0x05,
  0x77, 0x77, 0x60, 0x10, 0xDF, 0x0C, 0x77, 0x77, 0x70, 0x3F, 0x90, 0x47, 0x77, 0x77, 0x05, 0xF0,
  0xC8, 0x0C, 0x00, 0x07, 0xF0, 0x58, 0x0C, 0x00, 0x08, 0xE0, 0xD8, 0x0C, 0x10, 0x0A, 0xE0, 0x68,
  0x0C, 0x10, 0x0A, 0xD0, 0xE0, 0x18, 0x0C, 0x10, 0x0A, 0xD0, 0x98, 0x0C, 0x20, 0x0A, 0xD0, 0x38,
  0x0C, 0x20, 0x09, 0xC0, 0xC8, 0x0C, 0x30, 0x07, 0xC0, 0x68, 0x0C, 0x30, 0x05, 0x0E, 0xA0, 0x98,
  0x0B, 0xD1, 0x00, 0x38, 0x0C, 0x3F, 0x03, 0x30, 0x38, 0x0C, 0x3F, 0x03, 0x30, 0x38, 0x0C, 0x3F,
  0x04, 0x38, 0x12, 0xDE, 0x80, 0xC1, 0xF0, 0x47, 0x03, 0x08, 0xFB, 0x0D, 0x80, 0x91, 0x90, 0xB0,
  0xEF, 0x90, 0x57, 0x20, 0x30, 0xEF, 0x90, 0x97, 0x71, 0x05, 0x0E, 0xE0, 0x57, 0x30, 0x8F, 0x90,
  0x97, 0x72, 0x02, 0x0E, 0xD0, 0x67, 0x30, 0x3F, 0x90, 0x97, 0x73, 0x06, 0xD0, 0x67, 0x4F, 0x90,
  0x97, 0x74, 0x0D, 0xC0, 0x77, 0x4F, 0x90, 0x97, 0x74, 0x08, 0xC0, 0x77, 0x40, 0xEF, 0x09, 0x77,
  0x40, 0x4C, 0x07, 0x74, 0x0E, 0xF0, 0x97, 0x74, 0x02, 0xC0, 0x87, 0x40, 0xEF, 0x09, 0x77, 0x5C,
  0x08, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0x0E, 0xB0, 0x97, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xCB, 0x09,
  0x74, 0x0E, 0xF0, 0x97, 0x75, 0x83, 0x58, 0x88, 0x57, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF,
  0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0x0D, 0x80, 0x96, 0x97, 0x73, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x84, 0x2B, 0xBB,
  0xB1, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x04, 0xC0, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x6C, 0x01,
  0x71, 0x0E, 0xF0, 0x97, 0x77, 0x08, 0xC0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0xAC, 0x72, 0x0E,
  0xF0, 0x97, 0x77, 0x0E, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x60, 0x3D, 0x72, 0xF9, 0x09, 0x77, 0x60,
  0xAC, 0x0E, 0x71, 0x02, 0xF9, 0x09, 0x77, 0x50, 0x3D, 0x0D, 0x71, 0x06, 0xF9, 0x09, 0x77, 0x40,
  0x10, 0xDD, 0x0D, 0x70, 0x10, 0xDF, 0x90, 0x97, 0x73, 0x05, 0x0D, 0xE0, 0xC5, 0x81, 0x27, 0xEF,
  0xA0, 0xD8, 0x09, 0x39, 0x0B, 0x0E, 0xF9, 0x84, 0xC0, 0x2D, 0xDE, 0x80, 0xC2, 0xF8, 0x1B, 0x03,
  0x80, 0xC5, 0xF8, 0x1B, 0x03, 0x80, 0xC5, 0xF8, 0x1A, 0x03, 0x80, 0xC5, 0xF0, 0xA1,
  // "É" (U+00C9)
  0x77, 0x73, 0x03, 0x80, 0x47, 0x04, 0x77, 0x77, 0x60, 0xBF, 0x90, 0x87, 0x77, 0x75, 0x02, 0xF9,
  0x0D, 0x01, 0x77, 0x77, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x75, 0x01, 0xF9, 0x05, 0x77, 0x77, 0x60,
  0x9F, 0x08, 0x77, 0x77, 0x60, 0x2F, 0x0A, 0x77, 0x77, 0x70, 0xAE, 0x0B, 0x77, 0x77, 0x70, 0x4E,
  0x0B, 0x80, 0xC0, 0x00, 0xCD, 0x0C, 0x80, 0xC0, 0x00, 0x6D, 0x0C, 0x80, 0xC0, 0x00, 0x10, 0xEC,
  0x0B, 0x80, 0xC1, 0x00, 0x9C, 0x0A, 0x80, 0xC1, 0x00, 0x3C, 0x09, 0x80, 0xC2, 0x00, 0x6B, 0x06,
  0x80, 0xBD, 0x60, 0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3,
  0xF0, 0x43, 0x81, 0x2D, 0xE8, 0x0C, 0x1F, 0x04, 0x70, 0x30, 0x8F, 0xB0, 0xD8, 0x09, 0x19, 0x0B,
  0x0E, 0xF9, 0x05, 0x72, 0x03, 0x0E, 0xF9, 0x09, 0x77, 0x10, 0x50, 0xEE, 0x05, 0x73, 0x08, 0xF9,
  0x09, 0x77, 0x20, 0x20, 0xED, 0x06, 0x73, 0x03, 0xF9, 0x09, 0x77, 0x30, 0x6D, 0x06, 0x74, 0xF9,
  0x09, 0x77, 0x40, 0xDC, 0x07, 0x74, 0xF9, 0x09, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x0E, 0xF0, 0x97,
  0x74, 0x04, 0xC0, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x40, 0x2C, 0x08, 0x74, 0x0E, 0xF0, 0x97, 0x75,
  0xC0, 0x87, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xEB, 0x09, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0x0C, 0xB0,
  0x97, 0x40, 0xEF, 0x09, 0x77, 0x58, 0x35, 0x88, 0x85, 0x74, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E,
  0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xF0, 0xD8, 0x09, 0x69, 0x77, 0x30, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x78, 0x42, 0xBB,
  0xBB, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x4C, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC0,
  0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x8C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x0A, 0xC7, 0x20,
  0xEF, 0x09, 0x77, 0x70, 0xEC, 0x72, 0x0E, 0xF0, 0x97, 0x76, 0x03, 0xD7, 0x2F, 0x90, 0x97, 0x76,
  0x0A, 0xC0, 0xE7, 0x10, 0x2F, 0x90, 0x97, 0x75, 0x03, 0xD0, 0xD7, 0x10, 0x6F, 0x90, 0x97, 0x74,
  0x01, 0x0D, 0xD0, 0xD7, 0x01, 0x0D, 0xF9, 0x09, 0x77, 0x30, 0x50, 0xDE, 0x0C, 0x58, 0x12, 0x7E,
  0xFA, 0x0D, 0x80, 0x93, 0x90, 0xB0, 0xEF, 0x98, 0x4C, 0x02, 0xDD, 0xE8, 0x0C, 0x2F, 0x81, 0xB0,
  0x38, 0x0C, 0x5F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xA0, 0x38, 0x0C, 0x5F, 0x0A, 0x10,
  // "Ê" (U+00CA)
  0x77, 0x40, 0x58, 0x03, 0x70, 0x27, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0xB7, 0x77, 0x76, 0x07, 0xFA,
  0x02, 0x77, 0x77, 0x40, 0x10, 0xEF, 0xA0, 0xA7, 0x77, 0x74, 0x08, 0xFC, 0x03, 0x77, 0x77, 0x20,
  0x2F, 0xD0, 0xC7, 0x77, 0x72, 0x0B, 0xD0, 0xC0, 0x5E, 0x05, 0x77, 0x77, 0x05, 0xD8, 0x2E, 0x20,
  0x7D, 0x0E, 0x01, 0x77, 0x76, 0x0D, 0xD0, 0x53, 0x0A, 0xD0, 0x97, 0x77, 0x50, 0x8D, 0x06, 0x50,
  0xBD, 0x03, 0x77, 0x73, 0x03, 0xD0, 0x87, 0x0C, 0xC0, 0xC7, 0x77, 0x30, 0xCC, 0x08, 0x71, 0x01,
  0x0C, 0xC0, 0x77, 0x77, 0x10, 0x7C, 0x08, 0x73, 0x01, 0x0C, 0xC0, 0x27, 0x76, 0x02, 0xC0, 0x87,
  0x50, 0x10, 0xCB, 0x0C, 0x77, 0x60, 0x6B, 0x08, 0x77, 0x01, 0x0C, 0xB0, 0x18, 0x0B, 0xC1, 0x00,
  0x38, 0x0C, 0x3F, 0x03, 0x30, 0x38, 0x0C, 0x3F, 0x03, 0x30, 0x38, 0x0C, 0x3F, 0x04, 0x38, 0x12,
  0xDE, 0x80, 0xC1, 0xF0, 0x47, 0x03, 0x08, 0xFB, 0x0D, 0x80, 0x91, 0x90, 0xB0, 0xEF, 0x90, 0x57,
  0x20, 0x30, 0xEF, 0x90, 0x97, 0x71, 0x05, 0x0E, 0xE0, 0x57, 0x30, 0x8F, 0x90, 0x97, 0x72, 0x02,
  0x0E, 0xD0, 0x67, 0x30, 0x3F, 0x90, 0x97, 0x73, 0x06, 0xD0, 0x67, 0x4F, 0x90, 0x97, 0x74, 0x0D,
  0xC0, 0x77, 0x4F, 0x90, 0x97, 0x74, 0x08, 0xC0, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x40, 0x4C, 0x07,
  0x74, 0x0E, 0xF0, 0x97, 0x74, 0x02, 0xC0, 0x87, 0x40, 0xEF, 0x09, 0x77, 0x5C, 0x08, 0x74, 0x0E,
  0xF0, 0x97, 0x75, 0x0E, 0xB0, 0x97, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xCB, 0x09, 0x74, 0x0E, 0xF0,
  0x97, 0x75, 0x83, 0x58, 0x88, 0x57, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73,
  0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0x0D, 0x80, 0x96, 0x97, 0x73, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x84, 0x2B, 0xBB, 0xB1, 0x71, 0x0E,
  0xF0, 0x97, 0x77, 0x04, 0xC0, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x6C, 0x01, 0x71, 0x0E, 0xF0,
  0x97, 0x77, 0x08, 0xC0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0xAC, 0x72, 0x0E, 0xF0, 0x97, 0x77,
  0x0E, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x60, 0x3D, 0x72, 0xF9, 0x09, 0x77, 0x60, 0xAC, 0x0E, 0x71,
  0x02, 0xF9, 0x09, 0x77, 0x50, 0x3D, 0x0D, 0x71, 0x06, 0xF9, 0x09, 0x77, 0x40, 0x10, 0xDD, 0x0D,
  0x70, 0x10, 0xDF, 0x90, 0x97, 0x73, 0x05, 0x0D, 0xE0, 0xC5, 0x81, 0x27, 0xEF, 0xA0, 0xD8, 0x09,
  0x39, 0x0B, 0x0E, 0xF9, 0x84, 0xC0, 0x2D, 0xDE, 0x80, 0xC2, 0xF8, 0x1B, 0x03, 0x80, 0xC5, 0xF8,
  0x1B, 0x03, 0x80, 0xC5, 0xF8, 0x1A, 0x03, 0x80, 0xC5, 0xF0, 0xA1,
  // "Ë" (U+00CB)
  0x75, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC4, 0x77, 0x72, 0x01, 0x0E, 0xD0, 0x37,
  0x0D, 0xD0, 0x57, 0x77, 0x10, 0x8E, 0x0B, 0x60, 0x6E, 0x0D, 0x77, 0x71, 0x0C, 0xF6, 0x0A, 0xF0,
  0x27, 0x77, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47, 0x77, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47, 0x77,
  0x0C, 0xF6, 0x0A, 0xF0, 0x27, 0x77, 0x09, 0xE0, 0xC6, 0x07, 0xE0, 0xE7, 0x77, 0x10, 0x20, 0xED,
  0x04, 0x60, 0x10, 0xDD, 0x06, 0x77, 0x72, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC5,
  0x80, 0xDD, 0x00, 0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3,
  0xF0, 0x43, 0x81, 0x2D, 0xE8, 0x0C, 0x1F, 0x04, 0x70, 0x30, 0x8F, 0xB0, 0xD8, 0x09, 0x19, 0x0B,
  0x0E, 0xF9, 0x05, 0x72, 0x03, 0x0E, 0xF9, 0x09, 0x77, 0x10, 0x50, 0xEE, 0x05, 0x73, 0x08, 0xF9,
  0x09, 0x77, 0x20, 0x20, 0xED, 0x06, 0x73, 0x03, 0xF9, 0x09, 0x77, 0x30, 0x6D, 0x06, 0x74, 0xF9,
  0x09, 0x77, 0x40, 0xDC, 0x07, 0x74, 0xF9, 0x09, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x0E, 0xF0, 0x97,
  0x74, 0x04, 0xC0, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x40, 0x2C, 0x08, 0x74, 0x0E, 0xF0, 0x97, 0x75,
  0xC0, 0x87, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xEB, 0x09, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0x0C, 0xB0,
  0x97, 0x40, 0xEF, 0x09, 0x77, 0x58, 0x35, 0x88, 0x85, 0x74, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E,
  0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xF0, 0xD8, 0x09, 0x69, 0x77, 0x30, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x78, 0x42, 0xBB,
  0xBB, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x4C, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC0,
  0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x8C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x0A, 0xC7, 0x20,
  0xEF, 0x09, 0x77, 0x70, 0xEC, 0x72, 0x0E, 0xF0, 0x97, 0x76, 0x03, 0xD7, 0x2F, 0x90, 0x97, 0x76,
  0x0A, 0xC0, 0xE7, 0x10, 0x2F, 0x90, 0x97, 0x75, 0x03, 0xD0, 0xD7, 0x10, 0x6F, 0x90, 0x97, 0x74,
  0x01, 0x0D, 0xD0, 0xD7, 0x01, 0x0D, 0xF9, 0x09, 0x77, 0x30, 0x50, 0xDE, 0x0C, 0x58, 0x12, 0x7E,
  0xFA, 0x0D, 0x80, 0x93, 0x90, 0xB0, 0xEF, 0x98, 0x4C, 0x02, 0xDD, 0xE8, 0x0C, 0x2F, 0x81, 0xB0,
  0x38, 0x0C, 0x5F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xA0, 0x38, 0x0C, 0x5F, 0x0A, 0x10,
  // "Ì" (U+00CC)
  0x03, 0x80, 0x47, 0x04, 0x77, 0x05, 0xF9, 0x0D, 0x77, 0x10, 0xBF, 0x90, 0x57, 0x70, 0x10, 0xDF,
  0x0C, 0x77, 0x10, 0x3F, 0x90, 0x47, 0x71, 0x05, 0xF0, 0xC7, 0x72, 0x07, 0xF0, 0x57, 0x72, 0x08,
  0xE0, 0xD7, 0x73, 0x0A, 0xE0, 0x67, 0x73, 0x0A, 0xD0, 0xE0, 0x17, 0x73, 0x0A, 0xD0, 0x97, 0x74,
  0x0A, 0xD0, 0x37, 0x74, 0x09, 0xC0, 0xC7, 0x75, 0x07, 0xC0, 0x67, 0x75, 0x05, 0x0E, 0xA0, 0x98,
  0x09, 0xF3, 0x00, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0, 0x3F,
  0xFF, 0x90, 0xE3, 0x81, 0x14, 0xAF, 0xD8, 0x1E, 0x73, 0x72, 0x04, 0xFB, 0x0D, 0x01, 0x75, 0x09,
  0xFA, 0x04, 0x76, 0x03, 0xF9, 0x0E, 0x77, 0x1F, 0x90, 0xB7, 0x71, 0xF9, 0x0A, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x1F, 0x90,
  0xA7, 0x71, 0xF9, 0x0B, 0x77, 0x03, 0xF9, 0x0E, 0x77, 0x08, 0xFA, 0x04, 0x75, 0x04, 0xFB, 0x0C,
  0x01, 0x71, 0x81, 0x14, 0xAF, 0xD8, 0x1E, 0x73, 0x30, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90,
  0xE0, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0,
  // "Í" (U+00CD)
  0x77, 0x03, 0x80, 0x47, 0x04, 0x77, 0x0B, 0xF9, 0x08, 0x76, 0x02, 0xF9, 0x0D, 0x01, 0x76, 0x09,
  0xF9, 0x03, 0x76, 0x01, 0xF9, 0x05, 0x77, 0x09, 0xF0, 0x87, 0x70, 0x2F, 0x0A, 0x77, 0x10, 0xAE,
  0x0B, 0x77, 0x10, 0x4E, 0x0B, 0x77, 0x20, 0xCD, 0x0C, 0x77, 0x20, 0x6D, 0x0C, 0x77, 0x20, 0x10,
  0xEC, 0x0B, 0x77, 0x30, 0x9C, 0x0A, 0x77, 0x30, 0x3C, 0x09, 0x77, 0x40, 0x6B, 0x06, 0x80, 0xA8,
  0x00, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9,
  0x0E, 0x38, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37, 0x20, 0x4F, 0xB0, 0xD0, 0x17, 0x50, 0x9F, 0xA0,
  0x47, 0x60, 0x3F, 0x90, 0xE7, 0x71, 0xF9, 0x0B, 0x77, 0x1F, 0x90, 0xA7, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97,
  0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0xF9, 0x0A, 0x77,
  0x1F, 0x90, 0xB7, 0x70, 0x3F, 0x90, 0xE7, 0x70, 0x8F, 0xA0, 0x47, 0x50, 0x4F, 0xB0, 0xC0, 0x17,
  0x18, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x33, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03,
  0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E,
  // "Î" (U+00CE)
  0x71, 0x05, 0x80, 0x37, 0x02, 0x77, 0x10, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0x7F, 0xA0, 0x27, 0x60,
  0x10, 0xEF, 0xA0, 0xA7, 0x60, 0x8F, 0xC0, 0x37, 0x40, 0x2F, 0xD0, 0xC7, 0x40, 0xBD, 0x0C, 0x05,
  0xE0, 0x57, 0x20, 0x5D, 0x82, 0xE2, 0x07, 0xD0, 0xE0, 0x17, 0x10, 0xDD, 0x05, 0x30, 0xAD, 0x09,
  0x70, 0x8D, 0x06, 0x50, 0xBD, 0x03, 0x50, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x50, 0xCC, 0x08, 0x71,
  0x01, 0x0C, 0xC0, 0x73, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x81, 0x20, 0x2C, 0x08, 0x75, 0x01,
  0x0C, 0xB8, 0x1C, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB, 0x01, 0x80, 0x9F, 0x10, 0x03, 0xFF, 0xF9,
  0x81, 0xE0, 0x3F, 0xFF, 0x98, 0x1E, 0x03, 0xFF, 0xF9, 0x81, 0xE0, 0x3F, 0xFF, 0x90, 0xE4, 0x81,
  0x14, 0xAF, 0xD8, 0x1E, 0x73, 0x73, 0x04, 0xFB, 0x0D, 0x01, 0x76, 0x09, 0xFA, 0x04, 0x77, 0x03,
  0xF9, 0x0E, 0x77, 0x2F, 0x90, 0xB7, 0x72, 0xF9, 0x0A, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF,
  0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x2F, 0x90, 0xA7, 0x72, 0xF9, 0x0B,
  0x77, 0x10, 0x3F, 0x90, 0xE7, 0x71, 0x08, 0xFA, 0x04, 0x76, 0x04, 0xFB, 0x0C, 0x01, 0x72, 0x81,
  0x14, 0xAF, 0xD8, 0x1E, 0x73, 0x40, 0x3F, 0xFF, 0x98, 0x1E, 0x03, 0xFF, 0xF9, 0x81, 0xE0, 0x3F,
  0xFF, 0x98, 0x1E, 0x03, 0xFF, 0xF9, 0x0E, 0x10,
  // "Ï" (U+00CF)
  0x28, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x43, 0x01, 0x0E, 0xD0, 0x37, 0x0D, 0xD0,
  0x52, 0x08, 0xE0, 0xB6, 0x06, 0xE0, 0xD2, 0x0C, 0xF6, 0x0A, 0xF8, 0x12, 0x0E, 0xF0, 0x25, 0x0B,
  0xF8, 0x14, 0x0E, 0xF0, 0x25, 0x0B, 0xF8, 0x14, 0x0C, 0xF6, 0x0A, 0xF8, 0x12, 0x09, 0xE0, 0xC6,
  0x07, 0xE0, 0xE2, 0x02, 0x0E, 0xD0, 0x46, 0x01, 0x0D, 0xD0, 0x63, 0x84, 0x2A, 0xEE, 0xB3, 0x71,
  0x84, 0x19, 0xEF, 0xC5, 0x80, 0xAF, 0x60, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03,
  0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x38, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37, 0x20, 0x4F,
  0xB0, 0xD0, 0x17, 0x50, 0x9F, 0xA0, 0x47, 0x60, 0x3F, 0x90, 0xE7, 0x71, 0xF9, 0x0B, 0x77, 0x1F,
  0x90, 0xA7, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E,
  0xF0, 0x97, 0x71, 0xF9, 0x0A, 0x77, 0x1F, 0x90, 0xB7, 0x70, 0x3F, 0x90, 0xE7, 0x70, 0x8F, 0xA0,
  0x47, 0x50, 0x4F, 0xB0, 0xC0, 0x17, 0x18, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x33, 0x03, 0xFF, 0xF9,
  0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E,
  // "Ð" (U+00D0)
  0x03, 0xFF, 0xFB, 0x85, 0xEE, 0xDB, 0x96, 0x27, 0x74, 0x03, 0xFF, 0xFF, 0xB8, 0x1E, 0x93, 0x77,
  0x10, 0x3F, 0xFF, 0xFE, 0x0C, 0x04, 0x76, 0x81, 0x2D, 0xEF, 0xFF, 0xFE, 0x0B, 0x02, 0x77, 0x18,
  0x13, 0x8E, 0xFA, 0x0D, 0x80, 0x39, 0x81, 0xAC, 0xEF, 0xC0, 0xE0, 0x67, 0x72, 0x02, 0x0E, 0xF9,
  0x09, 0x73, 0x81, 0x27, 0xCF, 0xB0, 0x87, 0x72, 0x06, 0xF9, 0x09, 0x76, 0x04, 0x0C, 0xFA, 0x0A,
  0x77, 0x10, 0x1F, 0x90, 0x97, 0x71, 0x08, 0xFA, 0x08, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x20, 0x5F,
  0xA0, 0x67, 0x70, 0xDF, 0x09, 0x77, 0x30, 0x5F, 0xA0, 0x27, 0x60, 0xCF, 0x09, 0x77, 0x40, 0x8F,
  0x90, 0xC7, 0x60, 0xCF, 0x09, 0x77, 0x50, 0xCF, 0x90, 0x67, 0x50, 0xCF, 0x09, 0x77, 0x50, 0x3F,
  0x90, 0xE7, 0x50, 0xCF, 0x09, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x40, 0xCF, 0x09, 0x77, 0x60, 0x3F,
  0x90, 0xD7, 0x40, 0xCF, 0x09, 0x77, 0x70, 0xCF, 0x90, 0x57, 0x30, 0xCF, 0x09, 0x77, 0x70, 0x7F,
  0x90, 0xA7, 0x30, 0xCF, 0x09, 0x77, 0x70, 0x1F, 0xA7, 0x30, 0xCF, 0x09, 0x77, 0x71, 0x0C, 0xF9,
  0x05, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0x8F, 0x90, 0x97, 0x20, 0xCF, 0x09, 0x77, 0x71, 0x05,
  0xF9, 0x0C, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0x2F, 0xA0, 0x17, 0x10, 0xCF, 0x09, 0x77, 0x72,
  0x0E, 0xF9, 0x03, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xCF, 0x90, 0x67, 0x10, 0xCF, 0x09, 0x77,
  0x72, 0x0A, 0xF9, 0x08, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x8F, 0x90, 0xA7, 0x10, 0xCF, 0x09,
  0x77, 0x72, 0x07, 0xF9, 0x0B, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x6F, 0x90, 0xD1, 0xFF, 0xFF,
  0x74, 0x05, 0xF9, 0x0E, 0x1F, 0xFF, 0xF7, 0x40, 0x4F, 0x90, 0xE1, 0xFF, 0xFF, 0x74, 0x04, 0xFA,
  0x1F, 0xFF, 0xF7, 0x40, 0x4F, 0xA1, 0x80, 0x39, 0x0E, 0xF0, 0xD8, 0x09, 0x09, 0x74, 0x04, 0xFA,
  0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x4F, 0x90, 0xE7, 0x10, 0xCF, 0x09, 0x77, 0x72, 0x04, 0xF9,
  0x0E, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0xD7, 0x10, 0xCF, 0x09, 0x77, 0x72, 0x06,
  0xF9, 0x0D, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x7F, 0x90, 0xB7, 0x10, 0xCF, 0x09, 0x77, 0x72,
  0x08, 0xF9, 0x09, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xAF, 0x90, 0x77, 0x10, 0xCF, 0x09, 0x77,
  0x72, 0x0C, 0xF9, 0x05, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xEF, 0x90, 0x37, 0x10, 0xCF, 0x09,
  0x77, 0x71, 0x02, 0xFA, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0x4F, 0x90, 0xC7, 0x20, 0xCF, 0x09,
  0x77, 0x71, 0x08, 0xF9, 0x09, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0xCF, 0x90, 0x57, 0x20, 0xCF,
  0x09, 0x77, 0x70, 0x1F, 0x90, 0xE7, 0x30, 0xCF, 0x09, 0x77, 0x70, 0x6F, 0x90, 0xA7, 0x30, 0xCF,
  0x09, 0x77, 0x70, 0xCF, 0x90, 0x57, 0x30, 0xCF, 0x09, 0x77, 0x60, 0x3F, 0x90, 0xE7, 0x40, 0xCF,
  0x09, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x40, 0xCF, 0x09, 0x77, 0x50, 0x3F, 0x90, 0xE0, 0x17, 0x40,
  0xCF, 0x09, 0x77, 0x50, 0xCF, 0x90, 0x77, 0x50, 0xCF, 0x09, 0x77, 0x40, 0x7F, 0x90, 0xD7, 0x60,
  0xDF, 0x09, 0x77, 0x30, 0x5F, 0xA0, 0x37, 0x60, 0xEF, 0x09, 0x77, 0x20, 0x5F, 0xA0, 0x87, 0x60,
  0x1F, 0x90, 0x97, 0x71, 0x07, 0xFA, 0x0A, 0x77, 0x06, 0xF9, 0x09, 0x76, 0x03, 0x0C, 0xFA, 0x0B,
  0x77, 0x01, 0x0E, 0xF9, 0x09, 0x73, 0x81, 0x26, 0xCF, 0xB0, 0xA7, 0x68, 0x11, 0x6E, 0xFA, 0x0D,
  0x80, 0x39, 0x81, 0xAB, 0xEF, 0xD0, 0x77, 0x38, 0x22, 0xCC, 0xDF, 0xFF, 0xFD, 0x0C, 0x03, 0x74,
  0x03, 0xFF, 0xFF, 0xE0, 0xD0, 0x57, 0x60, 0x3F, 0xFF, 0xFB, 0x81, 0xE9, 0x47, 0x71, 0x03, 0xFF,
  0xFB, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x74,
  // "Ñ" (U+00D1)
  0x77, 0x58, 0x62, 0x9D, 0xEE, 0xD9, 0x47, 0x50, 0xF3, 0x02, 0x77, 0x77, 0x20, 0x7F, 0x90, 0xC0,
  0x47, 0x20, 0x5B, 0x07, 0x77, 0x77, 0x10, 0x7F, 0xC0, 0xA0, 0x17, 0x09, 0xB0, 0x57, 0x77, 0x70,
  0x4F, 0xE0, 0xE0, 0x55, 0x02, 0xC0, 0x27, 0x77, 0x70, 0xDF, 0xF9, 0x84, 0xB4, 0x10, 0x4D, 0xB0,
  0xD7, 0x77, 0x70, 0x5B, 0x84, 0xE6, 0x11, 0x4C, 0xFF, 0xA0, 0x77, 0x77, 0x70, 0xAB, 0x06, 0x50,
  0x7F, 0xF0, 0xE0, 0x17, 0x77, 0x70, 0xEA, 0x0E, 0x70, 0x30, 0xEF, 0xD0, 0x77, 0x77, 0x70, 0x2B,
  0x0A, 0x71, 0x01, 0x0B, 0xFB, 0x0B, 0x77, 0x77, 0x10, 0x4B, 0x07, 0x73, 0x07, 0x0E, 0xF0, 0xA0,
  0x17, 0x77, 0x72, 0x0F, 0x17, 0x58, 0x61, 0x7C, 0xEF, 0xDA, 0x48, 0x0C, 0xC0, 0x00, 0x3F, 0xF0,
  0xE0, 0x17, 0x74, 0x05, 0xFF, 0xD0, 0x3F, 0xF9, 0x08, 0x77, 0x40, 0x5F, 0xFD, 0x03, 0xFF, 0xA0,
  0x17, 0x73, 0x05, 0xFF, 0xD0, 0x3F, 0xFA, 0x09, 0x77, 0x30, 0x5F, 0xFD, 0x38, 0x11, 0x49, 0xFD,
  0x02, 0x77, 0x58, 0x12, 0x6C, 0xF9, 0x82, 0xE8, 0x31, 0x71, 0x03, 0x0E, 0xFB, 0x0A, 0x77, 0x71,
  0x07, 0xE0, 0xD0, 0x27, 0x50, 0x8F, 0xC0, 0x37, 0x77, 0x10, 0xCD, 0x05, 0x76, 0x03, 0xFC, 0x0C,
  0x77, 0x71, 0x07, 0xD7, 0x71, 0xFD, 0x05, 0x77, 0x70, 0x4C, 0x0C, 0x77, 0x10, 0xEF, 0xC0, 0xD7,
  0x77, 0x03, 0xC0, 0xB7, 0x71, 0x0E, 0xFD, 0x06, 0x77, 0x60, 0x2C, 0x0A, 0x77, 0x10, 0xEF, 0xD0,
  0xE7, 0x76, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE0, 0x8F, 0x90, 0x77, 0x75, 0x02, 0xC0, 0xA7,
  0x71, 0x0E, 0xB8, 0x1E, 0x1E, 0xF0, 0xE0, 0x17, 0x74, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB8, 0x1E,
  0x07, 0xF9, 0x08, 0x77, 0x40, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x20, 0xDF, 0x90, 0x27, 0x73,
  0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE2, 0x05, 0xF9, 0x0A, 0x77, 0x30, 0x2C, 0x0A, 0x77, 0x10,
  0xEB, 0x0E, 0x30, 0xCF, 0x90, 0x37, 0x72, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE3, 0x04, 0xF9,
  0x0B, 0x77, 0x20, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x40, 0xBF, 0x90, 0x47, 0x71, 0x02, 0xC0,
  0xA7, 0x71, 0x0E, 0xB0, 0xE4, 0x02, 0xF9, 0x0C, 0x77, 0x10, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E,
  0x50, 0x9F, 0x90, 0x57, 0x70, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x50, 0x10, 0xEF, 0x0D, 0x77,
  0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE6, 0x08, 0xF9, 0x06, 0x76, 0x02, 0xC0, 0xA7, 0x71, 0x0E,
  0xB0, 0xE7, 0x0E, 0xF0, 0xE7, 0x60, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x70, 0x6F, 0x90, 0x77,
  0x50, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x71, 0x0D, 0xF0, 0xE0, 0x17, 0x40, 0x2C, 0x0A, 0x77,
  0x10, 0xEB, 0x0E, 0x71, 0x04, 0xF9, 0x09, 0x74, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x20,
  0xBF, 0x90, 0x27, 0x30, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x72, 0x03, 0xF9, 0x0A, 0x73, 0x02,
  0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x30, 0xAF, 0x90, 0x37, 0x20, 0x2C, 0x0A, 0x77, 0x10, 0xEB,
  0x0E, 0x73, 0x02, 0xF9, 0x0B, 0x72, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x40, 0x8F, 0x90,
  0x47, 0x10, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x74, 0x01, 0x0E, 0xF0, 0xC7, 0x10, 0x2C, 0x0A,
  0x77, 0x10, 0xEB, 0x0E, 0x75, 0x07, 0xF9, 0x05, 0x70, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x76,
  0x0D, 0xF0, 0xD7, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x60, 0x5F, 0x90, 0x76, 0x02, 0xC0,
  0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x70, 0xCF, 0x0E, 0x01, 0x50, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E,
  0x77, 0x04, 0xF9, 0x08, 0x50, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x10, 0xBF, 0x90, 0x14,
  0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x71, 0x02, 0xF9, 0x09, 0x40, 0x2C, 0x0A, 0x77, 0x10,
  0xEB, 0x0E, 0x77, 0x20, 0x9F, 0x90, 0x23, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x72, 0x01,
  0xF9, 0x0A, 0x30, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x30, 0x8F, 0x90, 0x32, 0x02, 0xC0,
  0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x74, 0x0E, 0xF0, 0xC2, 0x02, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7,
  0x74, 0x06, 0xF9, 0x81, 0x50, 0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x50, 0xDF, 0x81, 0xD0,
  0x2C, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x50, 0x5F, 0x90, 0x60, 0x2C, 0x0A, 0x77, 0x10, 0xEB,
  0x0E, 0x77, 0x60, 0xCF, 0x0D, 0x03, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x76, 0x03, 0xF9, 0x0A,
  0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x77, 0x0A, 0xFD, 0x0A, 0x77, 0x10, 0xEB, 0x0E, 0x77, 0x70,
  0x2F, 0xD0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7, 0x77, 0x10, 0x9F, 0xC0, 0xA7, 0x71, 0x0E, 0xB0, 0xE7,
  0x77, 0x10, 0x10, 0xEF, 0xB0, 0xA7, 0x71, 0xD7, 0x77, 0x20, 0x7F, 0xB0, 0xA7, 0x71, 0xD7, 0x77,
  0x30, 0xDF, 0xA0, 0xA7, 0x70, 0x3D, 0x03, 0x77, 0x72, 0x06, 0xFA, 0x0A, 0x77, 0x09, 0xD0, 0x87,
  0x77, 0x30, 0xCF, 0x90, 0xA7, 0x60, 0x4E, 0x0E, 0x03, 0x77, 0x72, 0x04, 0xF9, 0x0A, 0x73, 0x81,
  0x15, 0xAF, 0xA8, 0x19, 0x41, 0x77, 0x70, 0xBF, 0x0A, 0x70, 0x3F, 0xFD, 0x03, 0x77, 0x40, 0x3F,
  0x0A, 0x70, 0x3F, 0xFD, 0x03, 0x77, 0x50, 0x9E, 0x0A, 0x70, 0x3F, 0xFD, 0x03, 0x77, 0x50, 0x1E,
  0x0A, 0x70, 0x3F, 0xFD, 0x03, 0x77, 0x60, 0x8D, 0x0A, 0x70,
  // "Ò" (U+00D2)
  0x76, 0x03, 0x80, 0x47, 0x04, 0x80, 0xC4, 0x00, 0x5F, 0x90, 0xD8, 0x0C, 0x50, 0x0B, 0xF9, 0x05,
  0x80, 0xC4, 0x00, 0x10, 0xDF, 0x0C, 0x80, 0xC5, 0x00, 0x3F, 0x90, 0x48, 0x0C, 0x50, 0x05, 0xF0,
  0xC8, 0x0C, 0x60, 0x07, 0xF0, 0x58, 0x0C, 0x60, 0x08, 0xE0, 0xD8, 0x0C, 0x70, 0x0A, 0xE0, 0x68,
  0x0C, 0x70, 0x0A, 0xD0, 0xE0, 0x18, 0x0C, 0x70, 0x0A, 0xD0, 0x98, 0x0D, 0x00, 0x0A, 0xD0, 0x38,
  0x0D, 0x00, 0x09, 0xC0, 0xC8, 0x0D, 0x10, 0x07, 0xC0, 0x68, 0x0D, 0x10, 0x05, 0x0E, 0xA0, 0x98,
  0x0B, 0xD2, 0x08, 0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x50, 0x50, 0xAF,
  0xF9, 0x81, 0xD7, 0x17, 0x77, 0x70, 0x60, 0xDF, 0xFE, 0x08, 0x01, 0x77, 0x73, 0x02, 0x0C, 0xFF,
  0xFA, 0x0E, 0x05, 0x77, 0x71, 0x05, 0xFC, 0x84, 0xCA, 0x99, 0xAC, 0xFB, 0x09, 0x77, 0x60, 0x7F,
  0xA0, 0x90, 0x47, 0x10, 0x40, 0xAF, 0x90, 0xB7, 0x74, 0x08, 0xF9, 0x0B, 0x02, 0x75, 0x03, 0x0C,
  0xF0, 0xC7, 0x72, 0x06, 0xF9, 0x07, 0x77, 0x20, 0x9F, 0x0A, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x40,
  0x9F, 0x08, 0x75, 0x01, 0x0E, 0xF0, 0xA7, 0x76, 0x0C, 0xF0, 0x47, 0x40, 0x9F, 0x0E, 0x01, 0x77,
  0x60, 0x3F, 0x0D, 0x73, 0x03, 0xF9, 0x06, 0x77, 0x71, 0x0A, 0xF0, 0x77, 0x20, 0xBF, 0x0E, 0x77,
  0x72, 0x02, 0xF0, 0xE0, 0x17, 0x02, 0xF9, 0x08, 0x77, 0x73, 0x0C, 0xF0, 0x77, 0x09, 0xF9, 0x02,
  0x77, 0x73, 0x06, 0xF0, 0xE7, 0x0E, 0xF0, 0xC7, 0x77, 0x40, 0x1F, 0x90, 0x65, 0x05, 0xF9, 0x07,
  0x77, 0x75, 0x0C, 0xF0, 0xB5, 0x09, 0xF9, 0x03, 0x77, 0x75, 0x08, 0xF9, 0x01, 0x40, 0xEF, 0x0E,
  0x77, 0x76, 0x04, 0xF9, 0x05, 0x30, 0x3F, 0x90, 0xC7, 0x77, 0x60, 0x1F, 0x90, 0xA3, 0x06, 0xF9,
  0x09, 0x77, 0x77, 0x0E, 0xF0, 0xE3, 0x09, 0xF9, 0x06, 0x77, 0x77, 0x0B, 0xF9, 0x01, 0x20, 0xCF,
  0x90, 0x47, 0x77, 0x70, 0x9F, 0x90, 0x52, 0xFA, 0x01, 0x77, 0x77, 0x07, 0xF9, 0x81, 0x80, 0x2F,
  0xA7, 0x77, 0x71, 0x06, 0xF9, 0x81, 0xA0, 0x3F, 0x90, 0xE7, 0x77, 0x71, 0x04, 0xF9, 0x81, 0xC0,
  0x5F, 0x90, 0xC7, 0x77, 0x71, 0x03, 0xF9, 0x81, 0xE0, 0x7F, 0x90, 0xB7, 0x77, 0x71, 0x02, 0xFA,
  0x10, 0x8F, 0x90, 0xB7, 0x77, 0x71, 0x01, 0xFA, 0x01, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x2F, 0xA0,
  0x20, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x02, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x30,
  0xAF, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x04, 0x0A, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x40, 0x9F,
  0x90, 0x97, 0x77, 0x72, 0xFA, 0x03, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x8F, 0x90,
  0xA7, 0x77, 0x72, 0xFA, 0x02, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x10, 0x6F, 0x90,
  0xB7, 0x77, 0x71, 0x02, 0xFA, 0x10, 0x5F, 0x90, 0xC7, 0x77, 0x71, 0x03, 0xF9, 0x81, 0xD0, 0x3F,
  0x90, 0xE7, 0x77, 0x71, 0x04, 0xF9, 0x81, 0xC0, 0x1F, 0xA7, 0x77, 0x71, 0x06, 0xF9, 0x0A, 0x20,
  0xEF, 0x90, 0x27, 0x77, 0x70, 0x8F, 0x90, 0x82, 0x0B, 0xF9, 0x04, 0x77, 0x77, 0x0A, 0xF9, 0x04,
  0x20, 0x8F, 0x90, 0x67, 0x77, 0x70, 0xCF, 0x90, 0x12, 0x05, 0xF9, 0x09, 0x77, 0x77, 0x0E, 0xF0,
  0xD3, 0x02, 0xF9, 0x0C, 0x77, 0x76, 0x02, 0xF9, 0x0A, 0x40, 0xDF, 0x97, 0x77, 0x60, 0x5F, 0x90,
  0x54, 0x08, 0xF9, 0x04, 0x77, 0x75, 0x09, 0xF9, 0x50, 0x4F, 0x90, 0x87, 0x77, 0x50, 0xDF, 0x0A,
  0x60, 0xEF, 0x0D, 0x77, 0x74, 0x02, 0xF9, 0x05, 0x60, 0x7F, 0x90, 0x27, 0x77, 0x30, 0x7F, 0x0D,
  0x70, 0x1F, 0x90, 0x87, 0x77, 0x30, 0xDF, 0x07, 0x71, 0x0A, 0xF0, 0xE7, 0x77, 0x20, 0x3F, 0x0E,
  0x72, 0x02, 0xF9, 0x07, 0x77, 0x71, 0x0B, 0xF0, 0x67, 0x30, 0x8F, 0x0E, 0x01, 0x77, 0x60, 0x4F,
  0x0C, 0x75, 0x0D, 0xF0, 0xB7, 0x75, 0x01, 0x0D, 0xF0, 0x37, 0x50, 0x3F, 0x90, 0x87, 0x74, 0x0B,
  0xF0, 0x77, 0x70, 0x5F, 0x90, 0x87, 0x72, 0x0A, 0xF0, 0x97, 0x72, 0x08, 0xF9, 0x0B, 0x02, 0x75,
  0x03, 0x0D, 0xF0, 0xB7, 0x74, 0x07, 0xFA, 0x09, 0x03, 0x71, 0x05, 0x0B, 0xF9, 0x0A, 0x77, 0x60,
  0x5F, 0xB8, 0x5E, 0xCA, 0x99, 0xAD, 0xFB, 0x08, 0x77, 0x71, 0x03, 0x0C, 0xFF, 0xFA, 0x0D, 0x04,
  0x77, 0x74, 0x06, 0x0D, 0xFF, 0xD0, 0xE0, 0x87, 0x77, 0x71, 0x05, 0x0B, 0xFF, 0x90, 0xC0, 0x67,
  0x77, 0x76, 0x84, 0x47, 0xAC, 0xEE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x74,
  // "Ó" (U+00D3)
  0x77, 0x76, 0x03, 0x80, 0x47, 0x04, 0x80, 0xC4, 0x00, 0xBF, 0x90, 0x88, 0x0C, 0x30, 0x02, 0xF9,
  0x0D, 0x01, 0x80, 0xC3, 0x00, 0x9F, 0x90, 0x38, 0x0C, 0x30, 0x01, 0xF9, 0x05, 0x80, 0xC4, 0x00,
  0x9F, 0x08, 0x80, 0xC4, 0x00, 0x2F, 0x0A, 0x80, 0xC5, 0x00, 0xAE, 0x0B, 0x80, 0xC5, 0x00, 0x4E,
  0x0B, 0x80, 0xC6, 0x00, 0xCD, 0x0C, 0x80, 0xC6, 0x00, 0x6D, 0x0C, 0x80, 0xC6, 0x00, 0x10, 0xEC,
  0x0B, 0x80, 0xC7, 0x00, 0x9C, 0x0A, 0x80, 0xC7, 0x00, 0x3C, 0x09, 0x80, 0xD0, 0x00, 0x6B, 0x06,
  0x80, 0xBD, 0x70, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77, 0x75, 0x05, 0x0A,
  0xFF, 0x98, 0x1D, 0x71, 0x77, 0x77, 0x06, 0x0D, 0xFF, 0xE0, 0x80, 0x17, 0x77, 0x30, 0x20, 0xCF,
  0xFF, 0xA0, 0xE0, 0x57, 0x77, 0x10, 0x5F, 0xC8, 0x4C, 0xA9, 0x9A, 0xCF, 0xB0, 0x97, 0x76, 0x07,
  0xFA, 0x09, 0x04, 0x71, 0x04, 0x0A, 0xF9, 0x0B, 0x77, 0x40, 0x8F, 0x90, 0xB0, 0x27, 0x50, 0x30,
  0xCF, 0x0C, 0x77, 0x20, 0x6F, 0x90, 0x77, 0x72, 0x09, 0xF0, 0xA7, 0x70, 0x4F, 0x90, 0x77, 0x74,
  0x09, 0xF0, 0x87, 0x50, 0x10, 0xEF, 0x0A, 0x77, 0x60, 0xCF, 0x04, 0x74, 0x09, 0xF0, 0xE0, 0x17,
  0x76, 0x03, 0xF0, 0xD7, 0x30, 0x3F, 0x90, 0x67, 0x77, 0x10, 0xAF, 0x07, 0x72, 0x0B, 0xF0, 0xE7,
  0x77, 0x20, 0x2F, 0x0E, 0x01, 0x70, 0x2F, 0x90, 0x87, 0x77, 0x30, 0xCF, 0x07, 0x70, 0x9F, 0x90,
  0x27, 0x77, 0x30, 0x6F, 0x0E, 0x70, 0xEF, 0x0C, 0x77, 0x74, 0x01, 0xF9, 0x06, 0x50, 0x5F, 0x90,
  0x77, 0x77, 0x50, 0xCF, 0x0B, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x50, 0x8F, 0x90, 0x14, 0x0E, 0xF0,
  0xE7, 0x77, 0x60, 0x4F, 0x90, 0x53, 0x03, 0xF9, 0x0C, 0x77, 0x76, 0x01, 0xF9, 0x0A, 0x30, 0x6F,
  0x90, 0x97, 0x77, 0x70, 0xEF, 0x0E, 0x30, 0x9F, 0x90, 0x67, 0x77, 0x70, 0xBF, 0x90, 0x12, 0x0C,
  0xF9, 0x04, 0x77, 0x77, 0x09, 0xF9, 0x05, 0x2F, 0xA0, 0x17, 0x77, 0x70, 0x7F, 0x98, 0x18, 0x02,
  0xFA, 0x77, 0x77, 0x10, 0x6F, 0x98, 0x1A, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0x98, 0x1C,
  0x05, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x98, 0x1E, 0x07, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x2F,
  0xA1, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x10, 0x8F, 0x90, 0xA7, 0x77, 0x72, 0xFA,
  0x02, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x03,
  0x0A, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x40, 0xAF, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x04, 0x09,
  0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x30, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x02, 0x08, 0xF9,
  0x0A, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x8F, 0x90, 0xB7, 0x77, 0x71, 0x01, 0xFA, 0x01, 0x06, 0xF9,
  0x0B, 0x77, 0x77, 0x10, 0x2F, 0xA1, 0x05, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x98, 0x1D, 0x03,
  0xF9, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0x98, 0x1C, 0x01, 0xFA, 0x77, 0x77, 0x10, 0x6F, 0x90, 0xA2,
  0x0E, 0xF9, 0x02, 0x77, 0x77, 0x08, 0xF9, 0x08, 0x20, 0xBF, 0x90, 0x47, 0x77, 0x70, 0xAF, 0x90,
  0x42, 0x08, 0xF9, 0x06, 0x77, 0x77, 0x0C, 0xF9, 0x01, 0x20, 0x5F, 0x90, 0x97, 0x77, 0x70, 0xEF,
  0x0D, 0x30, 0x2F, 0x90, 0xC7, 0x77, 0x60, 0x2F, 0x90, 0xA4, 0x0D, 0xF9, 0x77, 0x76, 0x05, 0xF9,
  0x05, 0x40, 0x8F, 0x90, 0x47, 0x77, 0x50, 0x9F, 0x95, 0x04, 0xF9, 0x08, 0x77, 0x75, 0x0D, 0xF0,
  0xA6, 0x0E, 0xF0, 0xD7, 0x77, 0x40, 0x2F, 0x90, 0x56, 0x07, 0xF9, 0x02, 0x77, 0x73, 0x07, 0xF0,
  0xD7, 0x01, 0xF9, 0x08, 0x77, 0x73, 0x0D, 0xF0, 0x77, 0x10, 0xAF, 0x0E, 0x77, 0x72, 0x03, 0xF0,
  0xE7, 0x20, 0x2F, 0x90, 0x77, 0x77, 0x10, 0xBF, 0x06, 0x73, 0x08, 0xF0, 0xE0, 0x17, 0x76, 0x04,
  0xF0, 0xC7, 0x50, 0xDF, 0x0B, 0x77, 0x50, 0x10, 0xDF, 0x03, 0x75, 0x03, 0xF9, 0x08, 0x77, 0x40,
  0xBF, 0x07, 0x77, 0x05, 0xF9, 0x08, 0x77, 0x20, 0xAF, 0x09, 0x77, 0x20, 0x8F, 0x90, 0xB0, 0x27,
  0x50, 0x30, 0xDF, 0x0B, 0x77, 0x40, 0x7F, 0xA0, 0x90, 0x37, 0x10, 0x50, 0xBF, 0x90, 0xA7, 0x76,
  0x05, 0xFB, 0x85, 0xEC, 0xA9, 0x9A, 0xDF, 0xB0, 0x87, 0x77, 0x10, 0x30, 0xCF, 0xFF, 0xA0, 0xD0,
  0x47, 0x77, 0x40, 0x60, 0xDF, 0xFD, 0x0E, 0x08, 0x77, 0x77, 0x10, 0x50, 0xBF, 0xF9, 0x0C, 0x06,
  0x77, 0x77, 0x68, 0x44, 0x7A, 0xCE, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x40,
  // "Ô" (U+00D4)
  0x77, 0x70, 0x58, 0x03, 0x70, 0x28, 0x0C, 0x40, 0x01, 0x0E, 0xF0, 0xB8, 0x0C, 0x40, 0x07, 0xFA,
  0x02, 0x80, 0xC2, 0x00, 0x10, 0xEF, 0xA0, 0xA8, 0x0C, 0x20, 0x08, 0xFC, 0x03, 0x80, 0xC0, 0x00,
  0x2F, 0xD0, 0xC8, 0x0C, 0x00, 0x0B, 0xD0, 0xC0, 0x5E, 0x05, 0x77, 0x77, 0x60, 0x5D, 0x82, 0xE2,
  0x07, 0xD0, 0xE0, 0x17, 0x77, 0x75, 0x0D, 0xD0, 0x53, 0x0A, 0xD0, 0x97, 0x77, 0x74, 0x08, 0xD0,
  0x65, 0x0B, 0xD0, 0x37, 0x77, 0x72, 0x03, 0xD0, 0x87, 0x0C, 0xC0, 0xC7, 0x77, 0x72, 0x0C, 0xC0,
  0x87, 0x10, 0x10, 0xCC, 0x07, 0x77, 0x77, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x02, 0x77, 0x75,
  0x02, 0xC0, 0x87, 0x50, 0x10, 0xCB, 0x0C, 0x77, 0x75, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB, 0x01,
  0x80, 0xBC, 0x20, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77, 0x75, 0x05, 0x0A,
  0xFF, 0x98, 0x1D, 0x71, 0x77, 0x77, 0x06, 0x0D, 0xFF, 0xE0, 0x80, 0x17, 0x77, 0x30, 0x20, 0xCF,
  0xFF, 0xA0, 0xE0, 0x57, 0x77, 0x10, 0x5F, 0xC8, 0x4C, 0xA9, 0x9A, 0xCF, 0xB0, 0x97, 0x76, 0x07,
  0xFA, 0x09, 0x04, 0x71, 0x04, 0x0A, 0xF9, 0x0B, 0x77, 0x40, 0x8F, 0x90, 0xB0, 0x27, 0x50, 0x30,
  0xCF, 0x0C, 0x77, 0x20, 0x6F, 0x90, 0x77, 0x72, 0x09, 0xF0, 0xA7, 0x70, 0x4F, 0x90, 0x77, 0x74,
  0x09, 0xF0, 0x87, 0x50, 0x10, 0xEF, 0x0A, 0x77, 0x60, 0xCF, 0x04, 0x74, 0x09, 0xF0, 0xE0, 0x17,
  0x76, 0x03, 0xF0, 0xD7, 0x30, 0x3F, 0x90, 0x67, 0x77, 0x10, 0xAF, 0x07, 0x72, 0x0B, 0xF0, 0xE7,
  0x77, 0x20, 0x2F, 0x0E, 0x01, 0x70, 0x2F, 0x90, 0x87, 0x77, 0x30, 0xCF, 0x07, 0x70, 0x9F, 0x90,
  0x27, 0x77, 0x30, 0x6F, 0x0E, 0x70, 0xEF, 0x0C, 0x77, 0x74, 0x01, 0xF9, 0x06, 0x50, 0x5F, 0x90,
  0x77, 0x77, 0x50, 0xCF, 0x0B, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x50, 0x8F, 0x90, 0x14, 0x0E, 0xF0,
  0xE7, 0x77, 0x60, 0x4F, 0x90, 0x53, 0x03, 0xF9, 0x0C, 0x77, 0x76, 0x01, 0xF9, 0x0A, 0x30, 0x6F,
  0x90, 0x97, 0x77, 0x70, 0xEF, 0x0E, 0x30, 0x9F, 0x90, 0x67, 0x77, 0x70, 0xBF, 0x90, 0x12, 0x0C,
  0xF9, 0x04, 0x77, 0x77, 0x09, 0xF9, 0x05, 0x2F, 0xA0, 0x17, 0x77, 0x70, 0x7F, 0x98, 0x18, 0x02,
  0xFA, 0x77, 0x77, 0x10, 0x6F, 0x98, 0x1A, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0x98, 0x1C,
  0x05, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x98, 0x1E, 0x07, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x2F,
  0xA1, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x10, 0x8F, 0x90, 0xA7, 0x77, 0x72, 0xFA,
  0x02, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x03,
  0x0A, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x40, 0xAF, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x04, 0x09,
  0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x30, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x02, 0x08, 0xF9,
  0x0A, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x8F, 0x90, 0xB7, 0x77, 0x71, 0x01, 0xFA, 0x01, 0x06, 0xF9,
  0x0B, 0x77, 0x77, 0x10, 0x2F, 0xA1, 0x05, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x98, 0x1D, 0x03,
  0xF9, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0x98, 0x1C, 0x01, 0xFA, 0x77, 0x77, 0x10, 0x6F, 0x90, 0xA2,
  0x0E, 0xF9, 0x02, 0x77, 0x77, 0x08, 0xF9, 0x08, 0x20, 0xBF, 0x90, 0x47, 0x77, 0x70, 0xAF, 0x90,
  0x42, 0x08, 0xF9, 0x06, 0x77, 0x77, 0x0C, 0xF9, 0x01, 0x20, 0x5F, 0x90, 0x97, 0x77, 0x70, 0xEF,
  0x0D, 0x30, 0x2F, 0x90, 0xC7, 0x77, 0x60, 0x2F, 0x90, 0xA4, 0x0D, 0xF9, 0x77, 0x76, 0x05, 0xF9,
  0x05, 0x40, 0x8F, 0x90, 0x47, 0x77, 0x50, 0x9F, 0x95, 0x04, 0xF9, 0x08, 0x77, 0x75, 0x0D, 0xF0,
  0xA6, 0x0E, 0xF0, 0xD7, 0x77, 0x40, 0x2F, 0x90, 0x56, 0x07, 0xF9, 0x02, 0x77, 0x73, 0x07, 0xF0,
  0xD7, 0x01, 0xF9, 0x08, 0x77, 0x73, 0x0D, 0xF0, 0x77, 0x10, 0xAF, 0x0E, 0x77, 0x72, 0x03, 0xF0,
  0xE7, 0x20, 0x2F, 0x90, 0x77, 0x77, 0x10, 0xBF, 0x06, 0x73, 0x08, 0xF0, 0xE0, 0x17, 0x76, 0x04,
  0xF0, 0xC7, 0x50, 0xDF, 0x0B, 0x77, 0x50, 0x10, 0xDF, 0x03, 0x75, 0x03, 0xF9, 0x08, 0x77, 0x40,
  0xBF, 0x07, 0x77, 0x05, 0xF9, 0x08, 0x77, 0x20, 0xAF, 0x09, 0x77, 0x20, 0x8F, 0x90, 0xB0, 0x27,
  0x50, 0x30, 0xDF, 0x0B, 0x77, 0x40, 0x7F, 0xA0, 0x90, 0x37, 0x10, 0x50, 0xBF, 0x90, 0xA7, 0x76,
  0x05, 0xFB, 0x85, 0xEC, 0xA9, 0x9A, 0xDF, 0xB0, 0x87, 0x77, 0x10, 0x30, 0xCF, 0xFF, 0xA0, 0xD0,
  0x47, 0x77, 0x40, 0x60, 0xDF, 0xFD, 0x0E, 0x08, 0x77, 0x77, 0x10, 0x50, 0xBF, 0xF9, 0x0C, 0x06,
  0x77, 0x77, 0x68, 0x44, 0x7A, 0xCE, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x40,
  // "Õ" (U+00D5)
  0x77, 0x18, 0x62, 0x9D, 0xEE, 0xD9, 0x47, 0x50, 0xF3, 0x02, 0x77, 0x74, 0x07, 0xF9, 0x0C, 0x04,
  0x72, 0x05, 0xB0, 0x77, 0x77, 0x30, 0x7F, 0xC0, 0xA0, 0x17, 0x09, 0xB0, 0x57, 0x77, 0x20, 0x4F,
  0xE0, 0xE0, 0x55, 0x02, 0xC0, 0x27, 0x77, 0x20, 0xDF, 0xF9, 0x84, 0xB4, 0x10, 0x4D, 0xB0, 0xD7,
  0x77, 0x20, 0x5B, 0x84, 0xE6, 0x11, 0x4C, 0xFF, 0xA0, 0x77, 0x77, 0x20, 0xAB, 0x06, 0x50, 0x7F,
  0xF0, 0xE0, 0x17, 0x77, 0x20, 0xEA, 0x0E, 0x70, 0x30, 0xEF, 0xD0, 0x77, 0x77, 0x20, 0x2B, 0x0A,
  0x71, 0x01, 0x0B, 0xFB, 0x0B, 0x77, 0x73, 0x04, 0xB0, 0x77, 0x30, 0x70, 0xEF, 0x0A, 0x01, 0x77,
  0x74, 0x0F, 0x17, 0x58, 0x61, 0x7C, 0xEF, 0xDA, 0x48, 0x0B, 0xC6, 0x08, 0x44, 0x7A, 0xCD, 0xEA,
  0x84, 0xED, 0xB9, 0x62, 0x77, 0x77, 0x50, 0x50, 0xAF, 0xF9, 0x81, 0xD7, 0x17, 0x77, 0x70, 0x60,
  0xDF, 0xFE, 0x08, 0x01, 0x77, 0x73, 0x02, 0x0C, 0xFF, 0xFA, 0x0E, 0x05, 0x77, 0x71, 0x05, 0xFC,
  0x84, 0xCA, 0x99, 0xAC, 0xFB, 0x09, 0x77, 0x60, 0x7F, 0xA0, 0x90, 0x47, 0x10, 0x40, 0xAF, 0x90,
  0xB7, 0x74, 0x08, 0xF9, 0x0B, 0x02, 0x75, 0x03, 0x0C, 0xF0, 0xC7, 0x72, 0x06, 0xF9, 0x07, 0x77,
  0x20, 0x9F, 0x0A, 0x77, 0x04, 0xF9, 0x07, 0x77, 0x40, 0x9F, 0x08, 0x75, 0x01, 0x0E, 0xF0, 0xA7,
  0x76, 0x0C, 0xF0, 0x47, 0x40, 0x9F, 0x0E, 0x01, 0x77, 0x60, 0x3F, 0x0D, 0x73, 0x03, 0xF9, 0x06,
  0x77, 0x71, 0x0A, 0xF0, 0x77, 0x20, 0xBF, 0x0E, 0x77, 0x72, 0x02, 0xF0, 0xE0, 0x17, 0x02, 0xF9,
  0x08, 0x77, 0x73, 0x0C, 0xF0, 0x77, 0x09, 0xF9, 0x02, 0x77, 0x73, 0x06, 0xF0, 0xE7, 0x0E, 0xF0,
  0xC7, 0x77, 0x40, 0x1F, 0x90, 0x65, 0x05, 0xF9, 0x07, 0x77, 0x75, 0x0C, 0xF0, 0xB5, 0x09, 0xF9,
  0x03, 0x77, 0x75, 0x08, 0xF9, 0x01, 0x40, 0xEF, 0x0E, 0x77, 0x76, 0x04, 0xF9, 0x05, 0x30, 0x3F,
  0x90, 0xC7, 0x77, 0x60, 0x1F, 0x90, 0xA3, 0x06, 0xF9, 0x09, 0x77, 0x77, 0x0E, 0xF0, 0xE3, 0x09,
  0xF9, 0x06, 0x77, 0x77, 0x0B, 0xF9, 0x01, 0x20, 0xCF, 0x90, 0x47, 0x77, 0x70, 0x9F, 0x90, 0x52,
  0xFA, 0x01, 0x77, 0x77, 0x07, 0xF9, 0x81, 0x80, 0x2F, 0xA7, 0x77, 0x71, 0x06, 0xF9, 0x81, 0xA0,
  0x3F, 0x90, 0xE7, 0x77, 0x71, 0x04, 0xF9, 0x81, 0xC0, 0x5F, 0x90, 0xC7, 0x77, 0x71, 0x03, 0xF9,
  0x81, 0xE0, 0x7F, 0x90, 0xB7, 0x77, 0x71, 0x02, 0xFA, 0x10, 0x8F, 0x90, 0xB7, 0x77, 0x71, 0x01,
  0xFA, 0x01, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA,
  0x02, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x30, 0xAF, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x04,
  0x0A, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA, 0x03, 0x09,
  0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x8F, 0x90, 0xA7, 0x77, 0x72, 0xFA, 0x02, 0x08, 0xF9,
  0x0B, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x10, 0x6F, 0x90, 0xB7, 0x77, 0x71, 0x02, 0xFA, 0x10, 0x5F,
  0x90, 0xC7, 0x77, 0x71, 0x03, 0xF9, 0x81, 0xD0, 0x3F, 0x90, 0xE7, 0x77, 0x71, 0x04, 0xF9, 0x81,
  0xC0, 0x1F, 0xA7, 0x77, 0x71, 0x06, 0xF9, 0x0A, 0x20, 0xEF, 0x90, 0x27, 0x77, 0x70, 0x8F, 0x90,
  0x82, 0x0B, 0xF9, 0x04, 0x77, 0x77, 0x0A, 0xF9, 0x04, 0x20, 0x8F, 0x90, 0x67, 0x77, 0x70, 0xCF,
  0x90, 0x12, 0x05, 0xF9, 0x09, 0x77, 0x77, 0x0E, 0xF0, 0xD3, 0x02, 0xF9, 0x0C, 0x77, 0x76, 0x02,
  0xF9, 0x0A, 0x40, 0xDF, 0x97, 0x77, 0x60, 0x5F, 0x90, 0x54, 0x08, 0xF9, 0x04, 0x77, 0x75, 0x09,
  0xF9, 0x50, 0x4F, 0x90, 0x87, 0x77, 0x50, 0xDF, 0x0A, 0x60, 0xEF, 0x0D, 0x77, 0x74, 0x02, 0xF9,
  0x05, 0x60, 0x7F, 0x90, 0x27, 0x77, 0x30, 0x7F, 0x0D, 0x70, 0x1F, 0x90, 0x87, 0x77, 0x30, 0xDF,
  0x07, 0x71, 0x0A, 0xF0, 0xE7, 0x77, 0x20, 0x3F, 0x0E, 0x72, 0x02, 0xF9, 0x07, 0x77, 0x71, 0x0B,
  0xF0, 0x67, 0x30, 0x8F, 0x0E, 0x01, 0x77, 0x60, 0x4F, 0x0C, 0x75, 0x0D, 0xF0, 0xB7, 0x75, 0x01,
  0x0D, 0xF0, 0x37, 0x50, 0x3F, 0x90, 0x87, 0x74, 0x0B, 0xF0, 0x77, 0x70, 0x5F, 0x90, 0x87, 0x72,
  0x0A, 0xF0, 0x97, 0x72, 0x08, 0xF9, 0x0B, 0x02, 0x75, 0x03, 0x0D, 0xF0, 0xB7, 0x74, 0x07, 0xFA,
  0x09, 0x03, 0x71, 0x05, 0x0B, 0xF9, 0x0A, 0x77, 0x60, 0x5F, 0xB8, 0x5E, 0xCA, 0x99, 0xAD, 0xFB,
  0x08, 0x77, 0x71, 0x03, 0x0C, 0xFF, 0xFA, 0x0D, 0x04, 0x77, 0x74, 0x06, 0x0D, 0xFF, 0xD0, 0xE0,
  0x87, 0x77, 0x71, 0x05, 0x0B, 0xFF, 0x90, 0xC0, 0x67, 0x77, 0x76, 0x84, 0x47, 0xAC, 0xEE, 0xA8,
  0x4E, 0xDB, 0x85, 0x17, 0x74,
  // "Ö" (U+00D6)
  0x77, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC4, 0x77, 0x77, 0x10, 0x10, 0xED, 0x03,
  0x70, 0xDD, 0x05, 0x77, 0x77, 0x08, 0xE0, 0xB6, 0x06, 0xE0, 0xD7, 0x77, 0x70, 0xCF, 0x60, 0xAF,
  0x02, 0x77, 0x76, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47, 0x77, 0x60, 0xEF, 0x02, 0x50, 0xBF, 0x04,
  0x77, 0x76, 0x0C, 0xF6, 0x0A, 0xF0, 0x27, 0x77, 0x60, 0x9E, 0x0C, 0x60, 0x7E, 0x0E, 0x77, 0x77,
  0x02, 0x0E, 0xD0, 0x46, 0x01, 0x0D, 0xD0, 0x67, 0x77, 0x71, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84,
  0x19, 0xEF, 0xC5, 0x80, 0xDF, 0x40, 0x84, 0x47, 0xAC, 0xDE, 0xA8, 0x4E, 0xDB, 0x96, 0x27, 0x77,
  0x75, 0x05, 0x0A, 0xFF, 0x98, 0x1D, 0x71, 0x77, 0x77, 0x06, 0x0D, 0xFF, 0xE0, 0x80, 0x17, 0x77,
  0x30, 0x20, 0xCF, 0xFF, 0xA0, 0xE0, 0x57, 0x77, 0x10, 0x5F, 0xC8, 0x4C, 0xA9, 0x9A, 0xCF, 0xB0,
  0x97, 0x76, 0x07, 0xFA, 0x09, 0x04, 0x71, 0x04, 0x0A, 0xF9, 0x0B, 0x77, 0x40, 0x8F, 0x90, 0xB0,
  0x27, 0x50, 0x30, 0xCF, 0x0C, 0x77, 0x20, 0x6F, 0x90, 0x77, 0x72, 0x09, 0xF0, 0xA7, 0x70, 0x4F,
  0x90, 0x77, 0x74, 0x09, 0xF0, 0x87, 0x50, 0x10, 0xEF, 0x0A, 0x77, 0x60, 0xCF, 0x04, 0x74, 0x09,
  0xF0, 0xE0, 0x17, 0x76, 0x03, 0xF0, 0xD7, 0x30, 0x3F, 0x90, 0x67, 0x77, 0x10, 0xAF, 0x07, 0x72,
  0x0B, 0xF0, 0xE7, 0x77, 0x20, 0x2F, 0x0E, 0x01, 0x70, 0x2F, 0x90, 0x87, 0x77, 0x30, 0xCF, 0x07,
  0x70, 0x9F, 0x90, 0x27, 0x77, 0x30, 0x6F, 0x0E, 0x70, 0xEF, 0x0C, 0x77, 0x74, 0x01, 0xF9, 0x06,
  0x50, 0x5F, 0x90, 0x77, 0x77, 0x50, 0xCF, 0x0B, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x50, 0x8F, 0x90,
  0x14, 0x0E, 0xF0, 0xE7, 0x77, 0x60, 0x4F, 0x90, 0x53, 0x03, 0xF9, 0x0C, 0x77, 0x76, 0x01, 0xF9,
  0x0A, 0x30, 0x6F, 0x90, 0x97, 0x77, 0x70, 0xEF, 0x0E, 0x30, 0x9F, 0x90, 0x67, 0x77, 0x70, 0xBF,
  0x90, 0x12, 0x0C, 0xF9, 0x04, 0x77, 0x77, 0x09, 0xF9, 0x05, 0x2F, 0xA0, 0x17, 0x77, 0x70, 0x7F,
  0x98, 0x18, 0x02, 0xFA, 0x77, 0x77, 0x10, 0x6F, 0x98, 0x1A, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x10,
  0x4F, 0x98, 0x1C, 0x05, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x3F, 0x98, 0x1E, 0x07, 0xF9, 0x0B, 0x77,
  0x77, 0x10, 0x2F, 0xA1, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x1F, 0xA0, 0x10, 0x8F, 0x90, 0xA7,
  0x77, 0x72, 0xFA, 0x02, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x9F, 0x90, 0x97, 0x77,
  0x72, 0xFA, 0x03, 0x0A, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x40, 0xAF, 0x90, 0x97, 0x77, 0x72,
  0xFA, 0x04, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x2F, 0xA0, 0x30, 0x9F, 0x90, 0x97, 0x77, 0x72, 0xFA,
  0x02, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x2F, 0xA0, 0x20, 0x8F, 0x90, 0xB7, 0x77, 0x71, 0x01, 0xFA,
  0x01, 0x06, 0xF9, 0x0B, 0x77, 0x77, 0x10, 0x2F, 0xA1, 0x05, 0xF9, 0x0C, 0x77, 0x77, 0x10, 0x3F,
  0x98, 0x1D, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x10, 0x4F, 0x98, 0x1C, 0x01, 0xFA, 0x77, 0x77, 0x10,
  0x6F, 0x90, 0xA2, 0x0E, 0xF9, 0x02, 0x77, 0x77, 0x08, 0xF9, 0x08, 0x20, 0xBF, 0x90, 0x47, 0x77,
  0x70, 0xAF, 0x90, 0x42, 0x08, 0xF9, 0x06, 0x77, 0x77, 0x0C, 0xF9, 0x01, 0x20, 0x5F, 0x90, 0x97,
  0x77, 0x70, 0xEF, 0x0D, 0x30, 0x2F, 0x90, 0xC7, 0x77, 0x60, 0x2F, 0x90, 0xA4, 0x0D, 0xF9, 0x77,
  0x76, 0x05, 0xF9, 0x05, 0x40, 0x8F, 0x90, 0x47, 0x77, 0x50, 0x9F, 0x95, 0x04, 0xF9, 0x08, 0x77,
  0x75, 0x0D, 0xF0, 0xA6, 0x0E, 0xF0, 0xD7, 0x77, 0x40, 0x2F, 0x90, 0x56, 0x07, 0xF9, 0x02, 0x77,
  0x73, 0x07, 0xF0, 0xD7, 0x01, 0xF9, 0x08, 0x77, 0x73, 0x0D, 0xF0, 0x77, 0x10, 0xAF, 0x0E, 0x77,
  0x72, 0x03, 0xF0, 0xE7, 0x20, 0x2F, 0x90, 0x77, 0x77, 0x10, 0xBF, 0x06, 0x73, 0x08, 0xF0, 0xE0,
  0x17, 0x76, 0x04, 0xF0, 0xC7, 0x50, 0xDF, 0x0B, 0x77, 0x50, 0x10, 0xDF, 0x03, 0x75, 0x03, 0xF9,
  0x08, 0x77, 0x40, 0xBF, 0x07, 0x77, 0x05, 0xF9, 0x08, 0x77, 0x20, 0xAF, 0x09, 0x77, 0x20, 0x8F,
  0x90, 0xB0, 0x27, 0x50, 0x30, 0xDF, 0x0B, 0x77, 0x40, 0x7F, 0xA0, 0x90, 0x37, 0x10, 0x50, 0xBF,
  0x90, 0xA7, 0x76, 0x05, 0xFB, 0x85, 0xEC, 0xA9, 0x9A, 0xDF, 0xB0, 0x87, 0x77, 0x10, 0x30, 0xCF,
  0xFF, 0xA0, 0xD0, 0x47, 0x77, 0x40, 0x60, 0xDF, 0xFD, 0x0E, 0x08, 0x77, 0x77, 0x10, 0x50, 0xBF,
  0xF9, 0x0C, 0x06, 0x77, 0x77, 0x68, 0x44, 0x7A, 0xCE, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x40,
  // "×" (U+00D7)
  0x40, 0x90, 0x17, 0x77, 0x20, 0x80, 0x25, 0x82, 0x1C, 0xFB, 0x77, 0x71, 0x82, 0x7F, 0xE3, 0x30,
  0x30, 0xEB, 0x09, 0x77, 0x60, 0x5C, 0x82, 0x50, 0x1E, 0xD0, 0x77, 0x74, 0x03, 0xE8, 0x13, 0x07,
  0xE0, 0x57, 0x72, 0x02, 0x0E, 0xD0, 0x83, 0x09, 0xD0, 0xE0, 0x37, 0x70, 0x10, 0xDD, 0x0B, 0x50,
  0xBD, 0x0D, 0x01, 0x76, 0x0B, 0xD0, 0xC7, 0x0C, 0xD0, 0xC7, 0x50, 0x9D, 0x0E, 0x01, 0x70, 0x10,
  0xED, 0x0A, 0x73, 0x07, 0xE0, 0x37, 0x20, 0x3E, 0x08, 0x71, 0x05, 0xE0, 0x57, 0x40, 0x5E, 0x06,
  0x60, 0x3E, 0x07, 0x76, 0x07, 0xE0, 0x44, 0x02, 0x0E, 0xD0, 0xA7, 0x71, 0x09, 0xD0, 0xE0, 0x22,
  0x01, 0x0D, 0xD0, 0xB7, 0x73, 0x0B, 0xD8, 0x2D, 0x10, 0xBD, 0x0D, 0x01, 0x77, 0x30, 0x10, 0xDD,
  0x0B, 0x0A, 0xD0, 0xE0, 0x27, 0x75, 0x02, 0x0E, 0xFC, 0x04, 0x77, 0x70, 0x3F, 0xB0, 0x67, 0x77,
  0x20, 0x5F, 0x90, 0x87, 0x77, 0x40, 0x8E, 0x0B, 0x77, 0x75, 0x0C, 0xE0, 0xE0, 0x27, 0x77, 0x30,
  0xBF, 0x90, 0xD0, 0x17, 0x77, 0x10, 0x8F, 0xB0, 0xB7, 0x77, 0x06, 0xE0, 0xED, 0x09, 0x77, 0x50,
  0x4E, 0x05, 0x03, 0xE0, 0x77, 0x73, 0x02, 0x0E, 0xD0, 0x72, 0x05, 0xE0, 0x57, 0x71, 0x01, 0x0D,
  0xD0, 0xA4, 0x07, 0xD0, 0xE0, 0x37, 0x70, 0xCD, 0x0B, 0x60, 0xAD, 0x0E, 0x01, 0x75, 0x0A, 0xD0,
  0xD0, 0x17, 0x0B, 0xD0, 0xC7, 0x40, 0x7D, 0x0E, 0x02, 0x71, 0x01, 0x0D, 0xD0, 0xA7, 0x20, 0x5E,
  0x04, 0x73, 0x02, 0x0E, 0xD0, 0x87, 0x03, 0xE0, 0x67, 0x50, 0x4E, 0x06, 0x50, 0x20, 0xED, 0x08,
  0x77, 0x06, 0xE0, 0x44, 0x0C, 0xD0, 0xA7, 0x72, 0x08, 0xD0, 0xE0, 0x22, 0x0B, 0xD0, 0xC7, 0x74,
  0x0A, 0xD8, 0x2D, 0x11, 0xCC, 0x0D, 0x01, 0x77, 0x50, 0xCC, 0x0C, 0x01, 0x20, 0xAA, 0x0E, 0x03,
  0x77, 0x60, 0x10, 0xDA, 0x0B, 0x01, 0x48, 0x18, 0xF5, 0x77, 0x71, 0x81, 0x2E, 0xA7, 0x02, 0x77,
  0x73, 0x02, 0x40,
  // "Ø" (U+00D8)
  0x80, 0xC3, 0x00, 0xDB, 0x0B, 0x80, 0xD0, 0x00, 0x4C, 0x04, 0x80, 0xD0, 0x00, 0xBB, 0x0D, 0x77,
  0x74, 0x89, 0x44, 0x7A, 0xCD, 0xEF, 0xED, 0xDB, 0x85, 0x15, 0x03, 0xC0, 0x67, 0x77, 0x10, 0x50,
  0xAF, 0xF9, 0x0B, 0x06, 0x30, 0xAB, 0x0E, 0x77, 0x70, 0x60, 0xDF, 0xFD, 0x81, 0xE7, 0x3C, 0x08,
  0x77, 0x50, 0x30, 0xCF, 0xFF, 0xF0, 0x27, 0x74, 0x06, 0xFC, 0x84, 0xCA, 0x9A, 0xBD, 0xFD, 0x0A,
  0x77, 0x40, 0x8F, 0xA0, 0x90, 0x47, 0x81, 0x16, 0xCF, 0xA0, 0x47, 0x73, 0x09, 0xF9, 0x0B, 0x02,
  0x75, 0x05, 0x0E, 0xF0, 0xA7, 0x72, 0x07, 0xF9, 0x07, 0x77, 0x10, 0x10, 0xCF, 0x09, 0x77, 0x04,
  0xF9, 0x07, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x50, 0x10, 0xEF, 0x0A, 0x77, 0x40, 0x7F, 0xA0, 0x27,
  0x40, 0x9F, 0x0E, 0x01, 0x77, 0x40, 0xDF, 0xA0, 0xC7, 0x30, 0x3F, 0x90, 0x67, 0x74, 0x06, 0xFC,
  0x06, 0x72, 0x0B, 0xF0, 0xE7, 0x75, 0x0D, 0xFC, 0x0E, 0x71, 0x02, 0xF9, 0x08, 0x77, 0x40, 0x5C,
  0x08, 0xF9, 0x07, 0x70, 0x9F, 0x90, 0x27, 0x74, 0x0C, 0xB8, 0x1E, 0x0A, 0xF0, 0xD7, 0x0E, 0xF0,
  0xC7, 0x74, 0x03, 0xC8, 0x17, 0x04, 0xF9, 0x04, 0x50, 0x5F, 0x90, 0x77, 0x74, 0x0B, 0xB0, 0xE0,
  0x12, 0x0E, 0xF0, 0xA5, 0x0A, 0xF9, 0x03, 0x77, 0x30, 0x2C, 0x08, 0x30, 0xAF, 0x90, 0x14, 0x0E,
  0xF0, 0xE7, 0x74, 0x0A, 0xC0, 0x13, 0x06, 0xF9, 0x05, 0x30, 0x3F, 0x90, 0xC7, 0x73, 0x02, 0xC0,
  0x94, 0x03, 0xF9, 0x09, 0x30, 0x6F, 0x90, 0x97, 0x73, 0x09, 0xC0, 0x25, 0xF9, 0x0D, 0x30, 0x9F,
  0x90, 0x67, 0x72, 0x01, 0xC0, 0xA6, 0x0C, 0xF9, 0x01, 0x20, 0xCF, 0x90, 0x47, 0x72, 0x08, 0xC0,
  0x36, 0x0A, 0xF9, 0x04, 0x2F, 0xA0, 0x17, 0x72, 0x0E, 0xB0, 0xB7, 0x08, 0xF9, 0x81, 0x70, 0x2F,
  0xA7, 0x72, 0x07, 0xC0, 0x47, 0x06, 0xF9, 0x81, 0xA0, 0x3F, 0x90, 0xE7, 0x72, 0x0D, 0xB0, 0xC7,
  0x10, 0x5F, 0x98, 0x1C, 0x05, 0xF9, 0x0C, 0x77, 0x10, 0x6C, 0x05, 0x71, 0x03, 0xF9, 0x81, 0xD0,
  0x7F, 0x90, 0xB7, 0x71, 0x0D, 0xB0, 0xD7, 0x20, 0x2F, 0xA1, 0x08, 0xF9, 0x0B, 0x77, 0x05, 0xC0,
  0x57, 0x20, 0x1F, 0xA0, 0x10, 0x9F, 0x90, 0xA7, 0x70, 0xCB, 0x0D, 0x73, 0x01, 0xFA, 0x02, 0x09,
  0xF9, 0x09, 0x76, 0x03, 0xC0, 0x67, 0x4F, 0xA0, 0x30, 0xAF, 0x90, 0x97, 0x60, 0xBB, 0x0E, 0x75,
  0xFA, 0x03, 0x0A, 0xF9, 0x09, 0x75, 0x02, 0xC0, 0x77, 0x5F, 0xA0, 0x40, 0xAF, 0x90, 0x97, 0x50,
  0xAB, 0x0E, 0x01, 0x75, 0xFA, 0x04, 0x09, 0xF9, 0x09, 0x74, 0x02, 0xC0, 0x87, 0x6F, 0xA0, 0x30,
  0x9F, 0x90, 0x97, 0x40, 0x9C, 0x01, 0x76, 0xFA, 0x02, 0x08, 0xF9, 0x0A, 0x73, 0x01, 0x0E, 0xB0,
  0x97, 0x7F, 0xA0, 0x20, 0x8F, 0x90, 0xA7, 0x30, 0x8C, 0x02, 0x76, 0x01, 0xFA, 0x01, 0x06, 0xF9,
  0x0B, 0x73, 0x0E, 0xB0, 0xA7, 0x70, 0x2F, 0xA1, 0x04, 0xF9, 0x0C, 0x72, 0x07, 0xC0, 0x37, 0x70,
  0x3F, 0x98, 0x1E, 0x03, 0xF9, 0x0E, 0x72, 0x0D, 0xB0, 0xB7, 0x71, 0x04, 0xF9, 0x81, 0xC0, 0x1F,
  0xA7, 0x10, 0x5C, 0x04, 0x77, 0x10, 0x6F, 0x90, 0xA2, 0x0E, 0xF9, 0x01, 0x70, 0xDB, 0x0C, 0x77,
  0x20, 0x7F, 0x90, 0x82, 0x0B, 0xF9, 0x03, 0x60, 0x4C, 0x05, 0x77, 0x20, 0x9F, 0x90, 0x52, 0x08,
  0xF9, 0x05, 0x60, 0xCB, 0x0D, 0x77, 0x30, 0xCF, 0x90, 0x12, 0x05, 0xF9, 0x08, 0x50, 0x3C, 0x06,
  0x77, 0x30, 0xEF, 0x0D, 0x30, 0x1F, 0x90, 0xB5, 0x0B, 0xB0, 0xE7, 0x73, 0x02, 0xF9, 0x0A, 0x40,
  0xCF, 0x0E, 0x40, 0x2C, 0x07, 0x77, 0x30, 0x5F, 0x90, 0x54, 0x08, 0xF9, 0x03, 0x30, 0xAB, 0x0E,
  0x77, 0x40, 0x9F, 0x90, 0x14, 0x03, 0xF9, 0x07, 0x20, 0x2C, 0x08, 0x77, 0x40, 0xCF, 0x0B, 0x60,
  0xCF, 0x0D, 0x20, 0x9C, 0x01, 0x77, 0x30, 0x2F, 0x90, 0x56, 0x06, 0xF9, 0x81, 0x31, 0xEB, 0x09,
  0x77, 0x40, 0x7F, 0x0E, 0x70, 0x10, 0xEF, 0x0A, 0x07, 0xC0, 0x27, 0x74, 0x0C, 0xF0, 0x77, 0x10,
  0x7F, 0x90, 0xEB, 0x0A, 0x77, 0x40, 0x3F, 0x0E, 0x01, 0x72, 0x0E, 0xFC, 0x02, 0x77, 0x40, 0xBF,
  0x07, 0x73, 0x06, 0xFB, 0x0B, 0x77, 0x40, 0x3F, 0x0C, 0x75, 0x0A, 0xFA, 0x03, 0x77, 0x40, 0xDF,
  0x03, 0x75, 0x01, 0x0D, 0xF0, 0xD7, 0x74, 0x0A, 0xF0, 0x77, 0x70, 0x30, 0xEF, 0x0A, 0x77, 0x20,
  0xAF, 0x09, 0x77, 0x20, 0x30, 0xEF, 0x0C, 0x03, 0x75, 0x03, 0x0D, 0xF0, 0xB7, 0x74, 0x08, 0xFA,
  0x0A, 0x04, 0x71, 0x05, 0x0B, 0xF9, 0x0A, 0x77, 0x50, 0xEF, 0xD8, 0x4C, 0xA9, 0x9A, 0xDF, 0xB0,
  0x87, 0x75, 0x06, 0xFF, 0xFE, 0x0E, 0x04, 0x77, 0x60, 0xDB, 0x81, 0xD6, 0xDF, 0xFD, 0x0E, 0x08,
  0x77, 0x70, 0x6C, 0x05, 0x28, 0x15, 0xAE, 0xFF, 0x81, 0xC7, 0x17, 0x77, 0x10, 0xDB, 0x0D, 0x68,
  0x44, 0x7A, 0xCD, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x77, 0x73, 0x05, 0xC0, 0x58, 0x0D, 0x00, 0x0C,
  0xB0, 0xD8, 0x0D, 0x00, 0x84, 0x17, 0x77, 0x73, 0x80, 0xC3, 0x00,
  // "Ù" (U+00D9)
  0x77, 0x10, 0x38, 0x04, 0x70, 0x48, 0x0D, 0x00, 0x05, 0xF9, 0x0D, 0x80, 0xD1, 0x00, 0xBF, 0x90,
  0x58, 0x0D, 0x00, 0x01, 0x0D, 0xF0, 0xC8, 0x0D, 0x10, 0x03, 0xF9, 0x04, 0x80, 0xD1, 0x00, 0x5F,
  0x0C, 0x80, 0xD2, 0x00, 0x7F, 0x05, 0x80, 0xD2, 0x00, 0x8E, 0x0D, 0x80, 0xD3, 0x00, 0xAE, 0x06,
  0x80, 0xD3, 0x00, 0xAD, 0x0E, 0x01, 0x80, 0xD3, 0x00, 0xAD, 0x09, 0x80, 0xD4, 0x00, 0xAD, 0x03,
  0x80, 0xD4, 0x00, 0x9C, 0x0C, 0x80, 0xD5, 0x00, 0x7C, 0x06, 0x80, 0xD5, 0x00, 0x50, 0xEA, 0x09,
  0x80, 0xCC, 0x00, 0x0C, 0xFF, 0xF9, 0x03, 0x72, 0x01, 0xFF, 0xD0, 0x40, 0xCF, 0xFF, 0x90, 0x37,
  0x20, 0x1F, 0xFD, 0x04, 0x0C, 0xFF, 0xF9, 0x03, 0x72, 0x01, 0xFF, 0xD0, 0x40, 0xCF, 0xFF, 0x90,
  0x37, 0x20, 0x1F, 0xFD, 0x04, 0x28, 0x21, 0x38, 0xEF, 0xD8, 0x1B, 0x52, 0x77, 0x18, 0x11, 0x5A,
  0xFA, 0x81, 0xB5, 0x27, 0x10, 0x10, 0xCF, 0xB0, 0x67, 0x77, 0x03, 0x0E, 0xE0, 0x67, 0x50, 0x3F,
  0xA0, 0xA7, 0x77, 0x20, 0x7D, 0x0A, 0x77, 0x0D, 0xF9, 0x05, 0x77, 0x72, 0x02, 0xD0, 0x57, 0x70,
  0xAF, 0x90, 0x27, 0x77, 0x3D, 0x01, 0x77, 0x09, 0xF9, 0x01, 0x77, 0x73, 0x0E, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71,
  0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9,
  0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71,
  0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9,
  0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x07, 0xF9, 0x77, 0x74, 0x0E,
  0xB0, 0xE7, 0x71, 0x07, 0xF9, 0x01, 0x77, 0x73, 0xC0, 0xE7, 0x71, 0x05, 0xF9, 0x02, 0x77, 0x72,
  0x01, 0xC0, 0xD7, 0x71, 0x04, 0xF9, 0x04, 0x77, 0x72, 0x03, 0xC0, 0xB7, 0x71, 0x01, 0xF9, 0x07,
  0x77, 0x72, 0x07, 0xC0, 0x97, 0x72, 0x0E, 0xF0, 0xA7, 0x77, 0x20, 0xBC, 0x05, 0x77, 0x20, 0xBF,
  0x0E, 0x77, 0x71, 0x01, 0xD0, 0x27, 0x72, 0x06, 0xF9, 0x05, 0x77, 0x70, 0x8C, 0x0D, 0x77, 0x30,
  0x1F, 0x90, 0xC7, 0x76, 0x02, 0x0E, 0xC0, 0x77, 0x74, 0x0B, 0xF9, 0x07, 0x77, 0x50, 0xBC, 0x0E,
  0x01, 0x77, 0x40, 0x3F, 0xA0, 0x57, 0x73, 0x07, 0xD0, 0x87, 0x76, 0x0A, 0xFA, 0x07, 0x77, 0x10,
  0x8D, 0x0D, 0x77, 0x70, 0x10, 0xEF, 0xA0, 0xC0, 0x47, 0x40, 0x30, 0xCE, 0x04, 0x77, 0x71, 0x03,
  0x0E, 0xFB, 0x83, 0xD8, 0x42, 0x12, 0x82, 0x14, 0x7C, 0xF0, 0x67, 0x77, 0x30, 0x30, 0xEF, 0xFF,
  0xD0, 0x77, 0x77, 0x50, 0x10, 0xBF, 0xFF, 0xA0, 0xE0, 0x57, 0x77, 0x71, 0x05, 0x0D, 0xFF, 0xE0,
  0x90, 0x17, 0x77, 0x74, 0x05, 0x0B, 0xFF, 0x98, 0x1E, 0x82, 0x80, 0xC1, 0x08, 0x44, 0x7A, 0xCE,
  0xEA, 0x84, 0xED, 0xC9, 0x63, 0x77, 0x60,
  // "Ú" (U+00DA)
  0x77, 0x77, 0x10, 0x38, 0x04, 0x70, 0x48, 0x0D, 0x00, 0x0B, 0xF9, 0x08, 0x80, 0xC7, 0x00, 0x2F,
  0x90, 0xD0, 0x18, 0x0C, 0x70, 0x09, 0xF9, 0x03, 0x80, 0xC7, 0x00, 0x1F, 0x90, 0x58, 0x0D, 0x00,
  0x09, 0xF0, 0x88, 0x0D, 0x00, 0x02, 0xF0, 0xA8, 0x0D, 0x10, 0x0A, 0xE0, 0xB8, 0x0D, 0x10, 0x04,
  0xE0, 0xB8, 0x0D, 0x20, 0x0C, 0xD0, 0xC8, 0x0D, 0x20, 0x06, 0xD0, 0xC8, 0x0D, 0x20, 0x01, 0x0E,
  0xC0, 0xB8, 0x0D, 0x30, 0x09, 0xC0, 0xA8, 0x0D, 0x30, 0x03, 0xC0, 0x98, 0x0D, 0x40, 0x06, 0xB0,
  0x68, 0x0C, 0xC5, 0x00, 0xCF, 0xFF, 0x90, 0x37, 0x20, 0x1F, 0xFD, 0x04, 0x0C, 0xFF, 0xF9, 0x03,
  0x72, 0x01, 0xFF, 0xD0, 0x40, 0xCF, 0xFF, 0x90, 0x37, 0x20, 0x1F, 0xFD, 0x04, 0x0C, 0xFF, 0xF9,
  0x03, 0x72, 0x01, 0xFF, 0xD0, 0x42, 0x82, 0x13, 0x8E, 0xFD, 0x81, 0xB5, 0x27, 0x71, 0x81, 0x15,
  0xAF, 0xA8, 0x1B, 0x52, 0x71, 0x01, 0x0C, 0xFB, 0x06, 0x77, 0x70, 0x30, 0xEE, 0x06, 0x75, 0x03,
  0xFA, 0x0A, 0x77, 0x72, 0x07, 0xD0, 0xA7, 0x70, 0xDF, 0x90, 0x57, 0x77, 0x20, 0x2D, 0x05, 0x77,
  0x0A, 0xF9, 0x02, 0x77, 0x73, 0xD0, 0x17, 0x70, 0x9F, 0x90, 0x17, 0x77, 0x30, 0xEC, 0x77, 0x10,
  0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97,
  0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40,
  0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77,
  0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F,
  0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77,
  0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC,
  0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10,
  0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97,
  0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40,
  0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77,
  0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F,
  0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77,
  0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC,
  0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10,
  0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97,
  0x77, 0x40, 0xDC, 0x77, 0x10, 0x8F, 0x97, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x7F, 0x97, 0x77, 0x40,
  0xEB, 0x0E, 0x77, 0x10, 0x7F, 0x90, 0x17, 0x77, 0x3C, 0x0E, 0x77, 0x10, 0x5F, 0x90, 0x27, 0x77,
  0x20, 0x1C, 0x0D, 0x77, 0x10, 0x4F, 0x90, 0x47, 0x77, 0x20, 0x3C, 0x0B, 0x77, 0x10, 0x1F, 0x90,
  0x77, 0x77, 0x20, 0x7C, 0x09, 0x77, 0x20, 0xEF, 0x0A, 0x77, 0x72, 0x0B, 0xC0, 0x57, 0x72, 0x0B,
  0xF0, 0xE7, 0x77, 0x10, 0x1D, 0x02, 0x77, 0x20, 0x6F, 0x90, 0x57, 0x77, 0x08, 0xC0, 0xD7, 0x73,
  0x01, 0xF9, 0x0C, 0x77, 0x60, 0x20, 0xEC, 0x07, 0x77, 0x40, 0xBF, 0x90, 0x77, 0x75, 0x0B, 0xC0,
  0xE0, 0x17, 0x74, 0x03, 0xFA, 0x05, 0x77, 0x30, 0x7D, 0x08, 0x77, 0x60, 0xAF, 0xA0, 0x77, 0x71,
  0x08, 0xD0, 0xD7, 0x77, 0x01, 0x0E, 0xFA, 0x0C, 0x04, 0x74, 0x03, 0x0C, 0xE0, 0x47, 0x77, 0x10,
  0x30, 0xEF, 0xB8, 0x3D, 0x84, 0x21, 0x28, 0x21, 0x47, 0xCF, 0x06, 0x77, 0x73, 0x03, 0x0E, 0xFF,
  0xFD, 0x07, 0x77, 0x75, 0x01, 0x0B, 0xFF, 0xFA, 0x0E, 0x05, 0x77, 0x77, 0x10, 0x50, 0xDF, 0xFE,
  0x09, 0x01, 0x77, 0x77, 0x40, 0x50, 0xBF, 0xF9, 0x81, 0xE8, 0x28, 0x0C, 0x10, 0x84, 0x47, 0xAC,
  0xEE, 0xA8, 0x4E, 0xDC, 0x96, 0x37, 0x76,
  // "Û" (U+00DB)
  0x77, 0x73, 0x05, 0x80, 0x37, 0x02, 0x80, 0xD0, 0x00, 0x10, 0xEF, 0x0B, 0x80, 0xD0, 0x00, 0x7F,
  0xA0, 0x28, 0x0C, 0x60, 0x01, 0x0E, 0xFA, 0x0A, 0x80, 0xC6, 0x00, 0x8F, 0xC0, 0x38, 0x0C, 0x40,
  0x02, 0xFD, 0x0C, 0x80, 0xC4, 0x00, 0xBD, 0x0C, 0x05, 0xE0, 0x58, 0x0C, 0x20, 0x05, 0xD8, 0x2E,
  0x20, 0x7D, 0x0E, 0x01, 0x80, 0xC1, 0x00, 0xDD, 0x05, 0x30, 0xAD, 0x09, 0x80, 0xC0, 0x00, 0x8D,
  0x06, 0x50, 0xBD, 0x03, 0x77, 0x77, 0x60, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x77, 0x77, 0x60, 0xCC,
  0x08, 0x71, 0x01, 0x0C, 0xC0, 0x77, 0x77, 0x74, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x02, 0x77,
  0x77, 0x20, 0x2C, 0x08, 0x75, 0x01, 0x0C, 0xB0, 0xC7, 0x77, 0x72, 0x06, 0xB0, 0x87, 0x70, 0x10,
  0xCB, 0x01, 0x80, 0xCA, 0x70, 0x0C, 0xFF, 0xF9, 0x03, 0x72, 0x01, 0xFF, 0xD0, 0x40, 0xCF, 0xFF,
  0x90, 0x37, 0x20, 0x1F, 0xFD, 0x04, 0x0C, 0xFF, 0xF9, 0x03, 0x72, 0x01, 0xFF, 0xD0, 0x40, 0xCF,
  0xFF, 0x90, 0x37, 0x20, 0x1F, 0xFD, 0x04, 0x28, 0x21, 0x38, 0xEF, 0xD8, 0x1B, 0x52, 0x77, 0x18,
  0x11, 0x5A, 0xFA, 0x81, 0xB5, 0x27, 0x10, 0x10, 0xCF, 0xB0, 0x67, 0x77, 0x03, 0x0E, 0xE0, 0x67,
  0x50, 0x3F, 0xA0, 0xA7, 0x77, 0x20, 0x7D, 0x0A, 0x77, 0x0D, 0xF9, 0x05, 0x77, 0x72, 0x02, 0xD0,
  0x57, 0x70, 0xAF, 0x90, 0x27, 0x77, 0x3D, 0x01, 0x77, 0x09, 0xF9, 0x01, 0x77, 0x73, 0x0E, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71,
  0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9,
  0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71,
  0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9,
  0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x07, 0xF9, 0x77,
  0x74, 0x0E, 0xB0, 0xE7, 0x71, 0x07, 0xF9, 0x01, 0x77, 0x73, 0xC0, 0xE7, 0x71, 0x05, 0xF9, 0x02,
  0x77, 0x72, 0x01, 0xC0, 0xD7, 0x71, 0x04, 0xF9, 0x04, 0x77, 0x72, 0x03, 0xC0, 0xB7, 0x71, 0x01,
  0xF9, 0x07, 0x77, 0x72, 0x07, 0xC0, 0x97, 0x72, 0x0E, 0xF0, 0xA7, 0x77, 0x20, 0xBC, 0x05, 0x77,
  0x20, 0xBF, 0x0E, 0x77, 0x71, 0x01, 0xD0, 0x27, 0x72, 0x06, 0xF9, 0x05, 0x77, 0x70, 0x8C, 0x0D,
  0x77, 0x30, 0x1F, 0x90, 0xC7, 0x76, 0x02, 0x0E, 0xC0, 0x77, 0x74, 0x0B, 0xF9, 0x07, 0x77, 0x50,
  0xBC, 0x0E, 0x01, 0x77, 0x40, 0x3F, 0xA0, 0x57, 0x73, 0x07, 0xD0, 0x87, 0x76, 0x0A, 0xFA, 0x07,
  0x77, 0x10, 0x8D, 0x0D, 0x77, 0x70, 0x10, 0xEF, 0xA0, 0xC0, 0x47, 0x40, 0x30, 0xCE, 0x04, 0x77,
  0x71, 0x03, 0x0E, 0xFB, 0x83, 0xD8, 0x42, 0x12, 0x82, 0x14, 0x7C, 0xF0, 0x67, 0x77, 0x30, 0x30,
  0xEF, 0xFF, 0xD0, 0x77, 0x77, 0x50, 0x10, 0xBF, 0xFF, 0xA0, 0xE0, 0x57, 0x77, 0x71, 0x05, 0x0D,
  0xFF, 0xE0, 0x90, 0x17, 0x77, 0x74, 0x05, 0x0B, 0xFF, 0x98, 0x1E, 0x82, 0x80, 0xC1, 0x08, 0x44,
  0x7A, 0xCE, 0xEA, 0x84, 0xED, 0xC9, 0x63, 0x77, 0x60,
  // "Ü" (U+00DC)
  0x77, 0x48, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x47, 0x77, 0x75, 0x01, 0x0E, 0xD0,
  0x37, 0x0D, 0xD0, 0x57, 0x77, 0x74, 0x08, 0xE0, 0xB6, 0x06, 0xE0, 0xD7, 0x77, 0x74, 0x0C, 0xF6,
  0x0A, 0xF0, 0x27, 0x77, 0x73, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47, 0x77, 0x73, 0x0E, 0xF0, 0x25,
  0x0B, 0xF0, 0x47, 0x77, 0x73, 0x0C, 0xF6, 0x0A, 0xF0, 0x27, 0x77, 0x73, 0x09, 0xE0, 0xC6, 0x07,
  0xE0, 0xE7, 0x77, 0x74, 0x02, 0x0E, 0xD0, 0x46, 0x01, 0x0D, 0xD0, 0x67, 0x77, 0x75, 0x84, 0x2A,
  0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC5, 0x80, 0xEF, 0x40, 0x0C, 0xFF, 0xF9, 0x03, 0x72, 0x01,
  0xFF, 0xD0, 0x40, 0xCF, 0xFF, 0x90, 0x37, 0x20, 0x1F, 0xFD, 0x04, 0x0C, 0xFF, 0xF9, 0x03, 0x72,
  0x01, 0xFF, 0xD0, 0x40, 0xCF, 0xFF, 0x90, 0x37, 0x20, 0x1F, 0xFD, 0x04, 0x28, 0x21, 0x38, 0xEF,
  0xD8, 0x1B, 0x52, 0x77, 0x18, 0x11, 0x5A, 0xFA, 0x81, 0xB5, 0x27, 0x10, 0x10, 0xCF, 0xB0, 0x67,
  0x77, 0x03, 0x0E, 0xE0, 0x67, 0x50, 0x3F, 0xA0, 0xA7, 0x77, 0x20, 0x7D, 0x0A, 0x77, 0x0D, 0xF9,
  0x05, 0x77, 0x72, 0x02, 0xD0, 0x57, 0x70, 0xAF, 0x90, 0x27, 0x77, 0x3D, 0x01, 0x77, 0x09, 0xF9,
  0x01, 0x77, 0x73, 0x0E, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71,
  0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9,
  0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71,
  0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9,
  0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74,
  0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7,
  0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08,
  0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77,
  0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D, 0xC7, 0x71, 0x08, 0xF9, 0x77, 0x74, 0x0D,
  0xC7, 0x71, 0x07, 0xF9, 0x77, 0x74, 0x0E, 0xB0, 0xE7, 0x71, 0x07, 0xF9, 0x01, 0x77, 0x73, 0xC0,
  0xE7, 0x71, 0x05, 0xF9, 0x02, 0x77, 0x72, 0x01, 0xC0, 0xD7, 0x71, 0x04, 0xF9, 0x04, 0x77, 0x72,
  0x03, 0xC0, 0xB7, 0x71, 0x01, 0xF9, 0x07, 0x77, 0x72, 0x07, 0xC0, 0x97, 0x72, 0x0E, 0xF0, 0xA7,
  0x77, 0x20, 0xBC, 0x05, 0x77, 0x20, 0xBF, 0x0E, 0x77, 0x71, 0x01, 0xD0, 0x27, 0x72, 0x06, 0xF9,
  0x05, 0x77, 0x70, 0x8C, 0x0D, 0x77, 0x30, 0x1F, 0x90, 0xC7, 0x76, 0x02, 0x0E, 0xC0, 0x77, 0x74,
  0x0B, 0xF9, 0x07, 0x77, 0x50, 0xBC, 0x0E, 0x01, 0x77, 0x40, 0x3F, 0xA0, 0x57, 0x73, 0x07, 0xD0,
  0x87, 0x76, 0x0A, 0xFA, 0x07, 0x77, 0x10, 0x8D, 0x0D, 0x77, 0x70, 0x10, 0xEF, 0xA0, 0xC0, 0x47,
  0x40, 0x30, 0xCE, 0x04, 0x77, 0x71, 0x03, 0x0E, 0xFB, 0x83, 0xD8, 0x42, 0x12, 0x82, 0x14, 0x7C,
  0xF0, 0x67, 0x77, 0x30, 0x30, 0xEF, 0xFF, 0xD0, 0x77, 0x77, 0x50, 0x10, 0xBF, 0xFF, 0xA0, 0xE0,
  0x57, 0x77, 0x71, 0x05, 0x0D, 0xFF, 0xE0, 0x90, 0x17, 0x77, 0x74, 0x05, 0x0B, 0xFF, 0x98, 0x1E,
  0x82, 0x80, 0xC1, 0x08, 0x44, 0x7A, 0xCE, 0xEA, 0x84, 0xED, 0xC9, 0x63, 0x77, 0x60,
  // "Ý" (U+00DD)
  0x77, 0x77, 0x10, 0x38, 0x04, 0x70, 0x48, 0x0C, 0x50, 0x0B, 0xF9, 0x08, 0x80, 0xC4, 0x00, 0x2F,
  0x90, 0xD0, 0x18, 0x0C, 0x40, 0x09, 0xF9, 0x03, 0x80, 0xC4, 0x00, 0x1F, 0x90, 0x58, 0x0C, 0x50,
  0x09, 0xF0, 0x88, 0x0C, 0x50, 0x02, 0xF0, 0xA8, 0x0C, 0x60, 0x0A, 0xE0, 0xB8, 0x0C, 0x60, 0x04,
  0xE0, 0xB8, 0x0C, 0x70, 0x0C, 0xD0, 0xC8, 0x0C, 0x70, 0x06, 0xD0, 0xC8, 0x0C, 0x70, 0x01, 0x0E,
  0xC0, 0xB8, 0x0D, 0x00, 0x09, 0xC0, 0xA8, 0x0D, 0x00, 0x03, 0xC0, 0x98, 0x0D, 0x10, 0x06, 0xB0,
  0x68, 0x0C, 0xA3, 0x00, 0x5F, 0xFF, 0x03, 0x71, 0x07, 0xFF, 0xC0, 0x20, 0x5F, 0xFF, 0x03, 0x71,
  0x07, 0xFF, 0xC0, 0x20, 0x5F, 0xFF, 0x03, 0x71, 0x07, 0xFF, 0xC0, 0x20, 0x5F, 0xFF, 0x03, 0x71,
  0x07, 0xFF, 0xC0, 0x22, 0x81, 0x14, 0xCF, 0xD0, 0x80, 0x27, 0x71, 0x81, 0x14, 0xAF, 0xB0, 0x70,
  0x17, 0x0C, 0xFB, 0x0B, 0x77, 0x60, 0x5F, 0x90, 0x37, 0x20, 0x20, 0xEF, 0xA0, 0x67, 0x77, 0x0D,
  0xE0, 0x67, 0x40, 0x7F, 0xA0, 0x77, 0x77, 0x0B, 0xD0, 0xB7, 0x60, 0xDF, 0x90, 0xA7, 0x77, 0x0C,
  0xD0, 0x27, 0x60, 0x6F, 0x90, 0xE7, 0x77, 0xD0, 0x97, 0x71, 0x0D, 0xF9, 0x05, 0x77, 0x50, 0x4C,
  0x0E, 0x01, 0x77, 0x10, 0x6F, 0x90, 0xB7, 0x75, 0x09, 0xC0, 0x87, 0x73, 0x0D, 0xF9, 0x03, 0x77,
  0x30, 0x10, 0xEB, 0x0E, 0x01, 0x77, 0x30, 0x6F, 0x90, 0xB7, 0x73, 0x07, 0xC0, 0x87, 0x75, 0x0D,
  0xF9, 0x03, 0x77, 0x20, 0xEB, 0x0E, 0x01, 0x77, 0x50, 0x5F, 0x90, 0xB7, 0x71, 0x07, 0xC0, 0x87,
  0x77, 0x0D, 0xF9, 0x03, 0x77, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x05, 0xF9, 0x0A, 0x76, 0x07, 0xC0,
  0x87, 0x77, 0x20, 0xDF, 0x90, 0x27, 0x50, 0xEB, 0x0E, 0x01, 0x77, 0x72, 0x05, 0xF9, 0x0A, 0x74,
  0x07, 0xC0, 0x87, 0x77, 0x40, 0xDF, 0x90, 0x27, 0x30, 0xEB, 0x0E, 0x01, 0x77, 0x74, 0x05, 0xF9,
  0x0A, 0x72, 0x07, 0xC0, 0x87, 0x77, 0x60, 0xDF, 0x90, 0x27, 0x10, 0xEB, 0x0E, 0x01, 0x77, 0x76,
  0x05, 0xF9, 0x09, 0x70, 0x6C, 0x08, 0x77, 0x77, 0x10, 0xDF, 0x90, 0x16, 0x0D, 0xC0, 0x17, 0x77,
  0x71, 0x05, 0xF9, 0x08, 0x50, 0x5C, 0x08, 0x77, 0x77, 0x30, 0xDF, 0x0E, 0x50, 0xCC, 0x01, 0x77,
  0x77, 0x30, 0x5F, 0x90, 0x63, 0x04, 0xC0, 0x87, 0x77, 0x75, 0x0D, 0xF0, 0xC3, 0x0B, 0xC0, 0x17,
  0x77, 0x75, 0x05, 0xF9, 0x81, 0x30, 0x2C, 0x08, 0x77, 0x77, 0x70, 0xDF, 0x81, 0x90, 0x9C, 0x01,
  0x77, 0x77, 0x70, 0x5F, 0x0E, 0x01, 0xC0, 0x88, 0x0C, 0x10, 0x0D, 0xF0, 0xBC, 0x01, 0x80, 0xC1,
  0x00, 0x5F, 0xC0, 0x88, 0x0C, 0x30, 0x0C, 0xFB, 0x01, 0x80, 0xC3, 0x00, 0x5F, 0xA0, 0x88, 0x0C,
  0x50, 0x0C, 0xF9, 0x01, 0x80, 0xC5, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6,
  0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00,
  0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF,
  0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D,
  0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80,
  0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0D, 0x80, 0xC6, 0x00, 0xAF, 0x0E, 0x80, 0xC6,
  0x00, 0xCF, 0x98, 0x0C, 0x60, 0x0E, 0xF9, 0x04, 0x80, 0xC4, 0x00, 0x5F, 0xA0, 0xA8, 0x0C, 0x30,
  0x03, 0x0E, 0xFB, 0x07, 0x77, 0x77, 0x78, 0x12, 0x5A, 0xFE, 0x81, 0xC6, 0x27, 0x77, 0x71, 0x0A,
  0xFF, 0xFB, 0x77, 0x75, 0x0A, 0xFF, 0xFB, 0x77, 0x75, 0x0A, 0xFF, 0xFB, 0x77, 0x75, 0x0A, 0xFF,
  0xFB, 0x76,
  // "Þ" (U+00DE)
  0x03, 0xFF, 0xFA, 0x09, 0x77, 0x30, 0x3F, 0xFF, 0xA0, 0x97, 0x73, 0x03, 0xFF, 0xFA, 0x09, 0x77,
  0x30, 0x3F, 0xFF, 0xA0, 0x97, 0x76, 0x81, 0x14, 0xAF, 0xD8, 0x2E, 0x84, 0x17, 0x77, 0x50, 0x4F,
  0xB0, 0xD0, 0x27, 0x77, 0x72, 0x09, 0xFA, 0x04, 0x77, 0x77, 0x30, 0x3F, 0x90, 0xE7, 0x77, 0x75,
  0xF9, 0x0B, 0x77, 0x77, 0x5F, 0x90, 0xA7, 0x77, 0x75, 0x0E, 0xF0, 0x97, 0x77, 0x75, 0x0E, 0xF0,
  0x97, 0x77, 0x75, 0x0E, 0xF0, 0x97, 0x77, 0x75, 0x0E, 0xFF, 0x98, 0x5E, 0xDC, 0xA7, 0x41, 0x77,
  0x50, 0xEF, 0xFF, 0x90, 0xB0, 0x67, 0x73, 0x0E, 0xFF, 0xFB, 0x0E, 0x07, 0x77, 0x10, 0xEF, 0xFF,
  0xD0, 0xC0, 0x27, 0x60, 0xEF, 0x0D, 0x80, 0x19, 0x81, 0xAB, 0xDF, 0xC0, 0xE0, 0x37, 0x50, 0xEF,
  0x09, 0x71, 0x81, 0x14, 0xBF, 0xA0, 0xE0, 0x37, 0x40, 0xEF, 0x09, 0x74, 0x03, 0x0D, 0xF9, 0x0D,
  0x74, 0x0E, 0xF0, 0x97, 0x50, 0x10, 0xDF, 0x90, 0x87, 0x30, 0xEF, 0x09, 0x76, 0x02, 0xFA, 0x02,
  0x72, 0x0E, 0xF0, 0x97, 0x70, 0x9F, 0x90, 0x87, 0x20, 0xEF, 0x09, 0x77, 0x02, 0xF9, 0x0E, 0x72,
  0x0E, 0xF0, 0x97, 0x71, 0x0D, 0xF9, 0x03, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x09, 0xF9, 0x07, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x06, 0xF9, 0x0A, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x04, 0xF9, 0x0C, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x03, 0xF9, 0x0E, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x02, 0xF9, 0x0E, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x01, 0xFA, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x01, 0xFA, 0x71, 0x0E, 0xF0,
  0x97, 0x71, 0x01, 0xF9, 0x0E, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x02, 0xF9, 0x0D, 0x71, 0x0E, 0xF0,
  0x97, 0x71, 0x03, 0xF9, 0x0B, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x04, 0xF9, 0x09, 0x71, 0x0E, 0xF0,
  0x97, 0x71, 0x06, 0xF9, 0x06, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x09, 0xF9, 0x02, 0x71, 0x0E, 0xF0,
  0x97, 0x71, 0x0D, 0xF0, 0xD7, 0x20, 0xEF, 0x09, 0x77, 0x02, 0xF9, 0x07, 0x72, 0x0E, 0xF0, 0x97,
  0x70, 0x8F, 0x90, 0x17, 0x20, 0xEF, 0x09, 0x76, 0x01, 0x0E, 0xF0, 0x97, 0x30, 0xEF, 0x09, 0x76,
  0x0B, 0xF0, 0xE0, 0x17, 0x30, 0xEF, 0x09, 0x74, 0x01, 0x0B, 0xF9, 0x05, 0x74, 0x0E, 0xF0, 0x97,
  0x30, 0x60, 0xDF, 0x90, 0x87, 0x50, 0xEF, 0x09, 0x48, 0x41, 0x13, 0x69, 0xEF, 0xA0, 0x87, 0x60,
  0xEF, 0xFF, 0xD0, 0x67, 0x70, 0xEF, 0xFF, 0xB0, 0xC0, 0x27, 0x71, 0x0E, 0xFF, 0xF9, 0x0C, 0x05,
  0x77, 0x30, 0xEF, 0xFD, 0x81, 0xC7, 0x37, 0x75, 0x0E, 0xF8, 0x91, 0xD9, 0x99, 0x98, 0x87, 0x64,
  0x27, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x77, 0x50, 0xEF, 0x09, 0x77, 0x77, 0x50, 0xEF, 0x09, 0x77,
  0x77, 0x5F, 0x90, 0xA7, 0x77, 0x75, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xE7, 0x77, 0x74,
  0x08, 0xFA, 0x04, 0x77, 0x77, 0x20, 0x4F, 0xB0, 0xD0, 0x17, 0x77, 0x58, 0x11, 0x4A, 0xFD, 0x82,
  0xE8, 0x31, 0x77, 0x60, 0x3F, 0xFF, 0xA0, 0x97, 0x73, 0x03, 0xFF, 0xFA, 0x09, 0x77, 0x30, 0x3F,
  0xFF, 0xA0, 0x97, 0x73, 0x03, 0xFF, 0xFA, 0x09, 0x77, 0x30,
  // "ß" (U+00DF)
  0x77, 0x48, 0x42, 0x59, 0xBD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x77, 0x30, 0x70, 0xCF, 0xF0,
  0xB0, 0x47, 0x77, 0x60, 0x70, 0xEF, 0xFC, 0x0A, 0x01, 0x77, 0x72, 0x01, 0x0B, 0xFF, 0xF0, 0xE0,
  0x37, 0x77, 0x01, 0x0D, 0xF9, 0x86, 0xA4, 0x20, 0x12, 0x5A, 0xF0, 0xE0, 0x37, 0x76, 0x0C, 0xF0,
  0xC0, 0x27, 0x10, 0x20, 0xCE, 0x0D, 0x01, 0x77, 0x40, 0x8F, 0x0C, 0x75, 0x0C, 0xE0, 0xA7, 0x73,
  0x02, 0xF0, 0xE0, 0x17, 0x50, 0x10, 0xEE, 0x03, 0x77, 0x20, 0xAF, 0x07, 0x77, 0x07, 0xE0, 0xB7,
  0x71, 0x01, 0xF0, 0xE7, 0x71, 0x01, 0xF0, 0x17, 0x70, 0x5F, 0x0A, 0x77, 0x20, 0xAE, 0x07, 0x77,
  0x09, 0xF0, 0x57, 0x72, 0x07, 0xE0, 0xB7, 0x70, 0xCF, 0x02, 0x77, 0x20, 0x3F, 0x77, 0x0E, 0xF7,
  0x74, 0xF0, 0x37, 0x50, 0x1F, 0x0E, 0x77, 0x40, 0xEE, 0x06, 0x75, 0x01, 0xF0, 0xD7, 0x74, 0x0C,
  0xE0, 0x97, 0x50, 0x2F, 0x0C, 0x77, 0x40, 0xAE, 0x0B, 0x75, 0x02, 0xF0, 0xC7, 0x74, 0x09, 0xE0,
  0xD7, 0x50, 0x2F, 0x0C, 0x77, 0x40, 0x9F, 0x75, 0x02, 0xF0, 0xC7, 0x74, 0x08, 0xF0, 0x15, 0x0B,
  0xFE, 0x0C, 0x76, 0x83, 0x48, 0xBD, 0xEF, 0x90, 0x25, 0x0B, 0xFE, 0x0C, 0x74, 0x07, 0x0E, 0xFE,
  0x03, 0x50, 0xBF, 0xE0, 0xC7, 0x20, 0x20, 0xDF, 0xF9, 0x03, 0x50, 0xBF, 0xE0, 0xC7, 0x10, 0x30,
  0xEF, 0xFA, 0x04, 0x50, 0x68, 0x01, 0x90, 0xAF, 0x0C, 0x70, 0x10, 0xDF, 0x82, 0xD7, 0x41, 0x77,
  0x40, 0x2F, 0x0C, 0x70, 0x9F, 0x07, 0x77, 0x71, 0x02, 0xF0, 0xC6, 0x02, 0xF0, 0x57, 0x77, 0x20,
  0x2F, 0x0C, 0x60, 0x8E, 0x0B, 0x77, 0x73, 0x02, 0xF0, 0xC6, 0x0C, 0xE0, 0x47, 0x77, 0x30, 0x2F,
  0x0C, 0x6F, 0x77, 0x74, 0x02, 0xF0, 0xC5, 0x01, 0xE0, 0xD7, 0x77, 0x40, 0x2F, 0x0C, 0x50, 0x3E,
  0x0C, 0x77, 0x74, 0x02, 0xF0, 0xC5, 0x03, 0xE0, 0xD7, 0x77, 0x40, 0x2F, 0x0C, 0x50, 0x2F, 0x01,
  0x77, 0x73, 0x02, 0xF0, 0xC5, 0x01, 0xF0, 0x67, 0x77, 0x30, 0x2F, 0x0C, 0x60, 0xDE, 0x0E, 0x01,
  0x77, 0x72, 0x02, 0xF0, 0xC6, 0x0A, 0xF0, 0xB7, 0x77, 0x20, 0x2F, 0x0C, 0x60, 0x4F, 0x90, 0xC0,
  0x17, 0x77, 0x02, 0xF0, 0xC7, 0x0D, 0xF9, 0x0E, 0x04, 0x77, 0x60, 0x2F, 0x0C, 0x70, 0x3F, 0xB0,
  0x97, 0x75, 0x02, 0xF0, 0xC7, 0x10, 0x7F, 0xB0, 0xE0, 0x57, 0x73, 0x02, 0xF0, 0xC7, 0x20, 0x7F,
  0xC0, 0xB0, 0x17, 0x71, 0x02, 0xF0, 0xC7, 0x30, 0x5F, 0xC0, 0xE0, 0x57, 0x70, 0x2F, 0x0C, 0x74,
  0x03, 0x0D, 0xFC, 0x08, 0x76, 0x02, 0xF0, 0xC7, 0x60, 0x9F, 0xC0, 0x97, 0x50, 0x2F, 0x0C, 0x77,
  0x03, 0x0C, 0xFB, 0x09, 0x74, 0x02, 0xF0, 0xC7, 0x72, 0x06, 0x0E, 0xFA, 0x05, 0x73, 0x02, 0xF0,
  0xC7, 0x73, 0x01, 0x0C, 0xF9, 0x0E, 0x01, 0x72, 0x02, 0xF0, 0xC7, 0x75, 0x09, 0xF9, 0x09, 0x72,
  0x02, 0xF0, 0xC7, 0x76, 0x08, 0xF9, 0x01, 0x71, 0x02, 0xF0, 0xC7, 0x77, 0x0B, 0xF0, 0x67, 0x10,
  0x2F, 0x0C, 0x77, 0x70, 0x2F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x77, 0x10, 0xBE, 0x0D, 0x71, 0x02,
  0xF0, 0xC6, 0x82, 0x18, 0xC1, 0x75, 0x05, 0xF7, 0x10, 0x2F, 0x0C, 0x50, 0x30, 0xEA, 0x03, 0x75,
  0x02, 0xF0, 0x17, 0x02, 0xF0, 0xC5, 0x0D, 0xB0, 0x57, 0x50, 0x1F, 0x02, 0x70, 0x2F, 0x0C, 0x40,
  0x3C, 0x08, 0x75, 0x01, 0xF0, 0x17, 0x02, 0xF0, 0xC4, 0x06, 0xC0, 0xB7, 0x50, 0x1F, 0x71, 0x03,
  0xF0, 0xC4, 0x07, 0xD7, 0x50, 0x3E, 0x0D, 0x71, 0x04, 0xF0, 0xC4, 0x06, 0xD0, 0x57, 0x40, 0x6E,
  0x0A, 0x71, 0x07, 0xF0, 0xC4, 0x05, 0xD0, 0xC7, 0x40, 0xBE, 0x06, 0x71, 0x0B, 0xF0, 0xC4, 0x02,
  0xE0, 0x47, 0x20, 0x3F, 0x01, 0x70, 0x5F, 0x90, 0xC5, 0x0C, 0xD0, 0xE0, 0x27, 0x01, 0x0C, 0xE0,
  0x95, 0x81, 0x14, 0xAF, 0xA0, 0xC5, 0x06, 0xE0, 0xE0, 0x65, 0x03, 0x0C, 0xF0, 0x22, 0x07, 0xFF,
  0x0C, 0x60, 0xBF, 0x83, 0xEB, 0x9A, 0xCF, 0x90, 0x53, 0x07, 0xFF, 0x0C, 0x60, 0x10, 0xCF, 0xFC,
  0x08, 0x40, 0x7F, 0xF0, 0xC7, 0x01, 0x0A, 0xFF, 0x90, 0xE0, 0x55, 0x07, 0xFF, 0x0C, 0x72, 0x04,
  0x0C, 0xFD, 0x09, 0x01, 0x77, 0x77, 0x58, 0x92, 0x27, 0xAD, 0xEF, 0xED, 0xC9, 0x51, 0x71,
  // "à" (U+00E0)
  0x60, 0x38, 0x04, 0x70, 0x47, 0x77, 0x70, 0x5F, 0x90, 0xD7, 0x77, 0x71, 0x0B, 0xF9, 0x05, 0x77,
  0x77, 0x01, 0x0D, 0xF0, 0xC7, 0x77, 0x71, 0x03, 0xF9, 0x04, 0x77, 0x77, 0x10, 0x5F, 0x0C, 0x77,
  0x77, 0x20, 0x7F, 0x05, 0x77, 0x77, 0x20, 0x8E, 0x0D, 0x77, 0x77, 0x30, 0xAE, 0x06, 0x77, 0x77,
  0x30, 0xAD, 0x0E, 0x01, 0x77, 0x77, 0x30, 0xAD, 0x09, 0x77, 0x77, 0x40, 0xAD, 0x03, 0x77, 0x77,
  0x40, 0x9C, 0x0C, 0x77, 0x77, 0x50, 0x7C, 0x06, 0x77, 0x77, 0x50, 0x50, 0xEA, 0x09, 0x80, 0xBA,
  0x40, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x81, 0x17, 0xDF, 0xF0, 0xA0,
  0x37, 0x74, 0x07, 0xFF, 0xD0, 0x97, 0x72, 0x0C, 0xFF, 0xF0, 0xC0, 0x17, 0x60, 0xBF, 0xA8, 0x3D,
  0xA9, 0xAC, 0xFA, 0x0C, 0x75, 0x05, 0xF9, 0x0B, 0x02, 0x50, 0x10, 0x8F, 0x90, 0x87, 0x40, 0xBF,
  0x0B, 0x72, 0x05, 0xF0, 0xE0, 0x17, 0x30, 0xEF, 0x01, 0x73, 0x0B, 0xF0, 0x77, 0x3F, 0x0B, 0x74,
  0x05, 0xF0, 0xC7, 0x3F, 0x07, 0x74, 0x01, 0xF9, 0x73, 0x0B, 0xE0, 0x37, 0x50, 0xDF, 0x03, 0x72,
  0x05, 0xE0, 0x17, 0x50, 0xBF, 0x06, 0x73, 0x07, 0xD7, 0x60, 0x9F, 0x07, 0x74, 0x81, 0x39, 0xDA,
  0x76, 0x08, 0xF0, 0x87, 0x71, 0x01, 0x76, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77,
  0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71,
  0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x71, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xF9, 0x09,
  0x75, 0x81, 0x16, 0xCF, 0xFF, 0x90, 0x97, 0x40, 0x70, 0xEF, 0xFF, 0xB0, 0x97, 0x20, 0x10, 0xCF,
  0xFF, 0xD0, 0x97, 0x10, 0x10, 0xDF, 0xA8, 0x3D, 0x85, 0x21, 0x50, 0x5F, 0x09, 0x71, 0x0C, 0xF9,
  0x0D, 0x04, 0x73, 0x05, 0xF0, 0x97, 0x06, 0xF9, 0x0C, 0x01, 0x74, 0x05, 0xF0, 0x97, 0x0E, 0xF0,
  0xE0, 0x17, 0x50, 0x5F, 0x09, 0x60, 0x5F, 0x90, 0x67, 0x60, 0x5F, 0x09, 0x60, 0x9F, 0x0E, 0x77,
  0x05, 0xF0, 0x96, 0x0D, 0xF0, 0x97, 0x70, 0x5F, 0x09, 0x6F, 0x90, 0x67, 0x70, 0x6F, 0x09, 0x50,
  0x2F, 0x90, 0x37, 0x70, 0x7F, 0x09, 0x50, 0x3F, 0x90, 0x27, 0x70, 0x8F, 0x09, 0x50, 0x3F, 0x90,
  0x17, 0x70, 0xAF, 0x09, 0x50, 0x2F, 0x90, 0x17, 0x70, 0xDF, 0x09, 0x50, 0x1F, 0x90, 0x17, 0x60,
  0x1F, 0x90, 0x96, 0xF9, 0x03, 0x76, 0x07, 0xF9, 0x09, 0x60, 0xDF, 0x05, 0x76, 0x0D, 0xF9, 0x0A,
  0x60, 0xAF, 0x09, 0x75, 0x07, 0xFA, 0x0B, 0x60, 0x6F, 0x0E, 0x74, 0x83, 0x2E, 0xF6, 0xAE, 0x0D,
  0x60, 0x1F, 0x90, 0x67, 0x28, 0x41, 0xDF, 0xB0, 0x7F, 0x01, 0x60, 0xAF, 0x0E, 0x03, 0x78, 0x54,
  0xDF, 0xE1, 0x05, 0xF0, 0x96, 0x03, 0xFA, 0x08, 0x02, 0x28, 0x12, 0x5B, 0xB0, 0x52, 0x03, 0xF9,
  0x0A, 0x03, 0x50, 0x7F, 0xFB, 0x09, 0x4F, 0xC0, 0x94, 0x0A, 0xFF, 0x90, 0xA5, 0x0D, 0xFB, 0x09,
  0x50, 0x8F, 0xE0, 0xA6, 0x0B, 0xFB, 0x09, 0x60, 0x40, 0xCF, 0xA0, 0xE0, 0x67, 0x08, 0xFB, 0x09,
  0x71, 0x89, 0x04, 0x8C, 0xEF, 0xED, 0xA6, 0x17, 0x76,
  // "á" (U+00E1)
  0x77, 0x70, 0x38, 0x04, 0x70, 0x47, 0x77, 0x70, 0xBF, 0x90, 0x87, 0x77, 0x60, 0x2F, 0x90, 0xD0,
  0x17, 0x77, 0x60, 0x9F, 0x90, 0x37, 0x77, 0x60, 0x1F, 0x90, 0x57, 0x77, 0x70, 0x9F, 0x08, 0x77,
  0x77, 0x02, 0xF0, 0xA7, 0x77, 0x71, 0x0A, 0xE0, 0xB7, 0x77, 0x71, 0x04, 0xE0, 0xB7, 0x77, 0x72,
  0x0C, 0xD0, 0xC7, 0x77, 0x72, 0x06, 0xD0, 0xC7, 0x77, 0x72, 0x01, 0x0E, 0xC0, 0xB7, 0x77, 0x73,
  0x09, 0xC0, 0xA7, 0x77, 0x73, 0x03, 0xC0, 0x97, 0x77, 0x74, 0x06, 0xB0, 0x68, 0x0B, 0xB0, 0x08,
  0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x78, 0x11, 0x7D, 0xFF, 0x0A, 0x03, 0x77,
  0x40, 0x7F, 0xFD, 0x09, 0x77, 0x20, 0xCF, 0xFF, 0x0C, 0x01, 0x76, 0x0B, 0xFA, 0x83, 0xDA, 0x9A,
  0xCF, 0xA0, 0xC7, 0x50, 0x5F, 0x90, 0xB0, 0x25, 0x01, 0x08, 0xF9, 0x08, 0x74, 0x0B, 0xF0, 0xB7,
  0x20, 0x5F, 0x0E, 0x01, 0x73, 0x0E, 0xF0, 0x17, 0x30, 0xBF, 0x07, 0x73, 0xF0, 0xB7, 0x40, 0x5F,
  0x0C, 0x73, 0xF0, 0x77, 0x40, 0x1F, 0x97, 0x30, 0xBE, 0x03, 0x75, 0x0D, 0xF0, 0x37, 0x20, 0x5E,
  0x01, 0x75, 0x0B, 0xF0, 0x67, 0x30, 0x7D, 0x76, 0x09, 0xF0, 0x77, 0x48, 0x13, 0x9D, 0xA7, 0x60,
  0x8F, 0x08, 0x77, 0x10, 0x17, 0x60, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10,
  0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F,
  0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x18, 0x51, 0x58, 0xAC, 0xDE, 0xFF, 0x90, 0x97, 0x58,
  0x11, 0x6C, 0xFF, 0xF9, 0x09, 0x74, 0x07, 0x0E, 0xFF, 0xFB, 0x09, 0x72, 0x01, 0x0C, 0xFF, 0xFD,
  0x09, 0x71, 0x01, 0x0D, 0xFA, 0x83, 0xD8, 0x52, 0x15, 0x05, 0xF0, 0x97, 0x10, 0xCF, 0x90, 0xD0,
  0x47, 0x30, 0x5F, 0x09, 0x70, 0x6F, 0x90, 0xC0, 0x17, 0x40, 0x5F, 0x09, 0x70, 0xEF, 0x0E, 0x01,
  0x75, 0x05, 0xF0, 0x96, 0x05, 0xF9, 0x06, 0x76, 0x05, 0xF0, 0x96, 0x09, 0xF0, 0xE7, 0x70, 0x5F,
  0x09, 0x60, 0xDF, 0x09, 0x77, 0x05, 0xF0, 0x96, 0xF9, 0x06, 0x77, 0x06, 0xF0, 0x95, 0x02, 0xF9,
  0x03, 0x77, 0x07, 0xF0, 0x95, 0x03, 0xF9, 0x02, 0x77, 0x08, 0xF0, 0x95, 0x03, 0xF9, 0x01, 0x77,
  0x0A, 0xF0, 0x95, 0x02, 0xF9, 0x01, 0x77, 0x0D, 0xF0, 0x95, 0x01, 0xF9, 0x01, 0x76, 0x01, 0xF9,
  0x09, 0x6F, 0x90, 0x37, 0x60, 0x7F, 0x90, 0x96, 0x0D, 0xF0, 0x57, 0x60, 0xDF, 0x90, 0xA6, 0x0A,
  0xF0, 0x97, 0x50, 0x7F, 0xA0, 0xB6, 0x06, 0xF0, 0xE7, 0x48, 0x32, 0xEF, 0x6A, 0xE0, 0xD6, 0x01,
  0xF9, 0x06, 0x72, 0x84, 0x1D, 0xFB, 0x07, 0xF0, 0x16, 0x0A, 0xF0, 0xE0, 0x37, 0x85, 0x4D, 0xFE,
  0x10, 0x5F, 0x09, 0x60, 0x3F, 0xA0, 0x80, 0x22, 0x81, 0x25, 0xBB, 0x05, 0x20, 0x3F, 0x90, 0xA0,
  0x35, 0x07, 0xFF, 0xB0, 0x94, 0xFC, 0x09, 0x40, 0xAF, 0xF9, 0x0A, 0x50, 0xDF, 0xB0, 0x95, 0x08,
  0xFE, 0x0A, 0x60, 0xBF, 0xB0, 0x96, 0x04, 0x0C, 0xFA, 0x0E, 0x06, 0x70, 0x8F, 0xB0, 0x97, 0x18,
  0x90, 0x48, 0xCE, 0xFE, 0xDA, 0x61, 0x77, 0x60,
  // "â" (U+00E2)
  0x77, 0x05, 0x80, 0x37, 0x02, 0x77, 0x77, 0x01, 0x0E, 0xF0, 0xB7, 0x77, 0x70, 0x7F, 0xA0, 0x27,
  0x77, 0x50, 0x10, 0xEF, 0xA0, 0xA7, 0x77, 0x50, 0x8F, 0xC0, 0x37, 0x77, 0x30, 0x2F, 0xD0, 0xC7,
  0x77, 0x30, 0xBD, 0x0C, 0x05, 0xE0, 0x57, 0x77, 0x10, 0x5D, 0x82, 0xE2, 0x07, 0xD0, 0xE0, 0x17,
  0x77, 0x0D, 0xD0, 0x53, 0x0A, 0xD0, 0x97, 0x76, 0x08, 0xD0, 0x65, 0x0B, 0xD0, 0x37, 0x74, 0x03,
  0xD0, 0x87, 0x0C, 0xC0, 0xC7, 0x74, 0x0C, 0xC0, 0x87, 0x10, 0x10, 0xCC, 0x07, 0x77, 0x20, 0x7C,
  0x08, 0x73, 0x01, 0x0C, 0xC0, 0x27, 0x70, 0x2C, 0x08, 0x75, 0x01, 0x0C, 0xB0, 0xC7, 0x70, 0x6B,
  0x08, 0x77, 0x01, 0x0C, 0xB0, 0x18, 0x0B, 0x94, 0x08, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB8,
  0x51, 0x77, 0x78, 0x11, 0x7D, 0xFF, 0x0A, 0x03, 0x77, 0x40, 0x7F, 0xFD, 0x09, 0x77, 0x20, 0xCF,
  0xFF, 0x0C, 0x01, 0x76, 0x0B, 0xFA, 0x83, 0xDA, 0x9A, 0xCF, 0xA0, 0xC7, 0x50, 0x5F, 0x90, 0xB0,
  0x25, 0x01, 0x08, 0xF9, 0x08, 0x74, 0x0B, 0xF0, 0xB7, 0x20, 0x5F, 0x0E, 0x01, 0x73, 0x0E, 0xF0,
  0x17, 0x30, 0xBF, 0x07, 0x73, 0xF0, 0xB7, 0x40, 0x5F, 0x0C, 0x73, 0xF0, 0x77, 0x40, 0x1F, 0x97,
  0x30, 0xBE, 0x03, 0x75, 0x0D, 0xF0, 0x37, 0x20, 0x5E, 0x01, 0x75, 0x0B, 0xF0, 0x67, 0x30, 0x7D,
  0x76, 0x09, 0xF0, 0x77, 0x48, 0x13, 0x9D, 0xA7, 0x60, 0x8F, 0x08, 0x77, 0x10, 0x17, 0x60, 0x7F,
  0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09,
  0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77,
  0x18, 0x51, 0x58, 0xAC, 0xDE, 0xFF, 0x90, 0x97, 0x58, 0x11, 0x6C, 0xFF, 0xF9, 0x09, 0x74, 0x07,
  0x0E, 0xFF, 0xFB, 0x09, 0x72, 0x01, 0x0C, 0xFF, 0xFD, 0x09, 0x71, 0x01, 0x0D, 0xFA, 0x83, 0xD8,
  0x52, 0x15, 0x05, 0xF0, 0x97, 0x10, 0xCF, 0x90, 0xD0, 0x47, 0x30, 0x5F, 0x09, 0x70, 0x6F, 0x90,
  0xC0, 0x17, 0x40, 0x5F, 0x09, 0x70, 0xEF, 0x0E, 0x01, 0x75, 0x05, 0xF0, 0x96, 0x05, 0xF9, 0x06,
  0x76, 0x05, 0xF0, 0x96, 0x09, 0xF0, 0xE7, 0x70, 0x5F, 0x09, 0x60, 0xDF, 0x09, 0x77, 0x05, 0xF0,
  0x96, 0xF9, 0x06, 0x77, 0x06, 0xF0, 0x95, 0x02, 0xF9, 0x03, 0x77, 0x07, 0xF0, 0x95, 0x03, 0xF9,
  0x02, 0x77, 0x08, 0xF0, 0x95, 0x03, 0xF9, 0x01, 0x77, 0x0A, 0xF0, 0x95, 0x02, 0xF9, 0x01, 0x77,
  0x0D, 0xF0, 0x95, 0x01, 0xF9, 0x01, 0x76, 0x01, 0xF9, 0x09, 0x6F, 0x90, 0x37, 0x60, 0x7F, 0x90,
  0x96, 0x0D, 0xF0, 0x57, 0x60, 0xDF, 0x90, 0xA6, 0x0A, 0xF0, 0x97, 0x50, 0x7F, 0xA0, 0xB6, 0x06,
  0xF0, 0xE7, 0x48, 0x32, 0xEF, 0x6A, 0xE0, 0xD6, 0x01, 0xF9, 0x06, 0x72, 0x84, 0x1D, 0xFB, 0x07,
  0xF0, 0x16, 0x0A, 0xF0, 0xE0, 0x37, 0x85, 0x4D, 0xFE, 0x10, 0x5F, 0x09, 0x60, 0x3F, 0xA0, 0x80,
  0x22, 0x81, 0x25, 0xBB, 0x05, 0x20, 0x3F, 0x90, 0xA0, 0x35, 0x07, 0xFF, 0xB0, 0x94, 0xFC, 0x09,
  0x40, 0xAF, 0xF9, 0x0A, 0x50, 0xDF, 0xB0, 0x95, 0x08, 0xFE, 0x0A, 0x60, 0xBF, 0xB0, 0x96, 0x04,
  0x0C, 0xFA, 0x0E, 0x06, 0x70, 0x8F, 0xB0, 0x97, 0x18, 0x90, 0x48, 0xCE, 0xFE, 0xDA, 0x61, 0x77,
  0x60,
  // "ã" (U+00E3)
  0x72, 0x86, 0x29, 0xDE, 0xED, 0x94, 0x75, 0x0F, 0x30, 0x27, 0x60, 0x7F, 0x90, 0xC0, 0x47, 0x20,
  0x5B, 0x07, 0x75, 0x07, 0xFC, 0x0A, 0x01, 0x70, 0x9B, 0x05, 0x74, 0x04, 0xFE, 0x0E, 0x05, 0x50,
  0x2C, 0x02, 0x74, 0x0D, 0xFF, 0x98, 0x4B, 0x41, 0x04, 0xDB, 0x0D, 0x74, 0x05, 0xB8, 0x4E, 0x61,
  0x14, 0xCF, 0xFA, 0x07, 0x74, 0x0A, 0xB0, 0x65, 0x07, 0xFF, 0x0E, 0x01, 0x74, 0x0E, 0xA0, 0xE7,
  0x03, 0x0E, 0xFD, 0x07, 0x74, 0x02, 0xB0, 0xA7, 0x10, 0x10, 0xBF, 0xB0, 0xB7, 0x50, 0x4B, 0x07,
  0x73, 0x07, 0x0E, 0xF0, 0xA0, 0x17, 0x60, 0xF1, 0x75, 0x86, 0x17, 0xCE, 0xFD, 0xA4, 0x80, 0xB9,
  0x70, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x81, 0x17, 0xDF, 0xF0, 0xA0,
  0x37, 0x74, 0x07, 0xFF, 0xD0, 0x97, 0x72, 0x0C, 0xFF, 0xF0, 0xC0, 0x17, 0x60, 0xBF, 0xA8, 0x3D,
  0xA9, 0xAC, 0xFA, 0x0C, 0x75, 0x05, 0xF9, 0x0B, 0x02, 0x50, 0x10, 0x8F, 0x90, 0x87, 0x40, 0xBF,
  0x0B, 0x72, 0x05, 0xF0, 0xE0, 0x17, 0x30, 0xEF, 0x01, 0x73, 0x0B, 0xF0, 0x77, 0x3F, 0x0B, 0x74,
  0x05, 0xF0, 0xC7, 0x3F, 0x07, 0x74, 0x01, 0xF9, 0x73, 0x0B, 0xE0, 0x37, 0x50, 0xDF, 0x03, 0x72,
  0x05, 0xE0, 0x17, 0x50, 0xBF, 0x06, 0x73, 0x07, 0xD7, 0x60, 0x9F, 0x07, 0x74, 0x81, 0x39, 0xDA,
  0x76, 0x08, 0xF0, 0x87, 0x71, 0x01, 0x76, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77,
  0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71,
  0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x71, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xF9, 0x09,
  0x75, 0x81, 0x16, 0xCF, 0xFF, 0x90, 0x97, 0x40, 0x70, 0xEF, 0xFF, 0xB0, 0x97, 0x20, 0x10, 0xCF,
  0xFF, 0xD0, 0x97, 0x10, 0x10, 0xDF, 0xA8, 0x3D, 0x85, 0x21, 0x50, 0x5F, 0x09, 0x71, 0x0C, 0xF9,
  0x0D, 0x04, 0x73, 0x05, 0xF0, 0x97, 0x06, 0xF9, 0x0C, 0x01, 0x74, 0x05, 0xF0, 0x97, 0x0E, 0xF0,
  0xE0, 0x17, 0x50, 0x5F, 0x09, 0x60, 0x5F, 0x90, 0x67, 0x60, 0x5F, 0x09, 0x60, 0x9F, 0x0E, 0x77,
  0x05, 0xF0, 0x96, 0x0D, 0xF0, 0x97, 0x70, 0x5F, 0x09, 0x6F, 0x90, 0x67, 0x70, 0x6F, 0x09, 0x50,
  0x2F, 0x90, 0x37, 0x70, 0x7F, 0x09, 0x50, 0x3F, 0x90, 0x27, 0x70, 0x8F, 0x09, 0x50, 0x3F, 0x90,
  0x17, 0x70, 0xAF, 0x09, 0x50, 0x2F, 0x90, 0x17, 0x70, 0xDF, 0x09, 0x50, 0x1F, 0x90, 0x17, 0x60,
  0x1F, 0x90, 0x96, 0xF9, 0x03, 0x76, 0x07, 0xF9, 0x09, 0x60, 0xDF, 0x05, 0x76, 0x0D, 0xF9, 0x0A,
  0x60, 0xAF, 0x09, 0x75, 0x07, 0xFA, 0x0B, 0x60, 0x6F, 0x0E, 0x74, 0x83, 0x2E, 0xF6, 0xAE, 0x0D,
  0x60, 0x1F, 0x90, 0x67, 0x28, 0x41, 0xDF, 0xB0, 0x7F, 0x01, 0x60, 0xAF, 0x0E, 0x03, 0x78, 0x54,
  0xDF, 0xE1, 0x05, 0xF0, 0x96, 0x03, 0xFA, 0x08, 0x02, 0x28, 0x12, 0x5B, 0xB0, 0x52, 0x03, 0xF9,
  0x0A, 0x03, 0x50, 0x7F, 0xFB, 0x09, 0x4F, 0xC0, 0x94, 0x0A, 0xFF, 0x90, 0xA5, 0x0D, 0xFB, 0x09,
  0x50, 0x8F, 0xE0, 0xA6, 0x0B, 0xFB, 0x09, 0x60, 0x40, 0xCF, 0xA0, 0xE0, 0x67, 0x08, 0xFB, 0x09,
  0x71, 0x89, 0x04, 0x8C, 0xEF, 0xED, 0xA6, 0x17, 0x76,
  // "ä" (U+00E4)
  0x71, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC4, 0x77, 0x30, 0x10, 0xED, 0x03, 0x70,
  0xDD, 0x05, 0x77, 0x20, 0x8E, 0x0B, 0x60, 0x6E, 0x0D, 0x77, 0x20, 0xCF, 0x60, 0xAF, 0x02, 0x77,
  0x10, 0xEF, 0x02, 0x50, 0xBF, 0x04, 0x77, 0x10, 0xEF, 0x02, 0x50, 0xBF, 0x04, 0x77, 0x10, 0xCF,
  0x60, 0xAF, 0x02, 0x77, 0x10, 0x9E, 0x0C, 0x60, 0x7E, 0x0E, 0x77, 0x20, 0x20, 0xED, 0x04, 0x60,
  0x10, 0xDD, 0x06, 0x77, 0x38, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x58, 0x0D, 0x81,
  0x08, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77, 0x78, 0x11, 0x7D, 0xFF, 0x0A, 0x03,
  0x77, 0x40, 0x7F, 0xFD, 0x09, 0x77, 0x20, 0xCF, 0xFF, 0x0C, 0x01, 0x76, 0x0B, 0xFA, 0x83, 0xDA,
  0x9A, 0xCF, 0xA0, 0xC7, 0x50, 0x5F, 0x90, 0xB0, 0x25, 0x01, 0x08, 0xF9, 0x08, 0x74, 0x0B, 0xF0,
  0xB7, 0x20, 0x5F, 0x0E, 0x01, 0x73, 0x0E, 0xF0, 0x17, 0x30, 0xBF, 0x07, 0x73, 0xF0, 0xB7, 0x40,
  0x5F, 0x0C, 0x73, 0xF0, 0x77, 0x40, 0x1F, 0x97, 0x30, 0xBE, 0x03, 0x75, 0x0D, 0xF0, 0x37, 0x20,
  0x5E, 0x01, 0x75, 0x0B, 0xF0, 0x67, 0x30, 0x7D, 0x76, 0x09, 0xF0, 0x77, 0x48, 0x13, 0x9D, 0xA7,
  0x60, 0x8F, 0x08, 0x77, 0x10, 0x17, 0x60, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77,
  0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10,
  0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x18, 0x51, 0x58, 0xAC, 0xDE, 0xFF, 0x90, 0x97,
  0x58, 0x11, 0x6C, 0xFF, 0xF9, 0x09, 0x74, 0x07, 0x0E, 0xFF, 0xFB, 0x09, 0x72, 0x01, 0x0C, 0xFF,
  0xFD, 0x09, 0x71, 0x01, 0x0D, 0xFA, 0x83, 0xD8, 0x52, 0x15, 0x05, 0xF0, 0x97, 0x10, 0xCF, 0x90,
  0xD0, 0x47, 0x30, 0x5F, 0x09, 0x70, 0x6F, 0x90, 0xC0, 0x17, 0x40, 0x5F, 0x09, 0x70, 0xEF, 0x0E,
  0x01, 0x75, 0x05, 0xF0, 0x96, 0x05, 0xF9, 0x06, 0x76, 0x05, 0xF0, 0x96, 0x09, 0xF0, 0xE7, 0x70,
  0x5F, 0x09, 0x60, 0xDF, 0x09, 0x77, 0x05, 0xF0, 0x96, 0xF9, 0x06, 0x77, 0x06, 0xF0, 0x95, 0x02,
  0xF9, 0x03, 0x77, 0x07, 0xF0, 0x95, 0x03, 0xF9, 0x02, 0x77, 0x08, 0xF0, 0x95, 0x03, 0xF9, 0x01,
  0x77, 0x0A, 0xF0, 0x95, 0x02, 0xF9, 0x01, 0x77, 0x0D, 0xF0, 0x95, 0x01, 0xF9, 0x01, 0x76, 0x01,
  0xF9, 0x09, 0x6F, 0x90, 0x37, 0x60, 0x7F, 0x90, 0x96, 0x0D, 0xF0, 0x57, 0x60, 0xDF, 0x90, 0xA6,
  0x0A, 0xF0, 0x97, 0x50, 0x7F, 0xA0, 0xB6, 0x06, 0xF0, 0xE7, 0x48, 0x32, 0xEF, 0x6A, 0xE0, 0xD6,
  0x01, 0xF9, 0x06, 0x72, 0x84, 0x1D, 0xFB, 0x07, 0xF0, 0x16, 0x0A, 0xF0, 0xE0, 0x37, 0x85, 0x4D,
  0xFE, 0x10, 0x5F, 0x09, 0x60, 0x3F, 0xA0, 0x80, 0x22, 0x81, 0x25, 0xBB, 0x05, 0x20, 0x3F, 0x90,
  0xA0, 0x35, 0x07, 0xFF, 0xB0, 0x94, 0xFC, 0x09, 0x40, 0xAF, 0xF9, 0x0A, 0x50, 0xDF, 0xB0, 0x95,
  0x08, 0xFE, 0x0A, 0x60, 0xBF, 0xB0, 0x96, 0x04, 0x0C, 0xFA, 0x0E, 0x06, 0x70, 0x8F, 0xB0, 0x97,
  0x18, 0x90, 0x48, 0xCE, 0xFE, 0xDA, 0x61, 0x77, 0x60,
  // "å" (U+00E5)
  0x77, 0x18, 0x66, 0xBD, 0xFE, 0xC9, 0x37, 0x77, 0x70, 0x60, 0xEF, 0x90, 0xB0, 0x17, 0x77, 0x40,
  0xAF, 0xC0, 0xE0, 0x37, 0x77, 0x20, 0x8F, 0xE0, 0xD0, 0x17, 0x77, 0x03, 0xD8, 0x3E, 0xB9, 0xAD,
  0xD0, 0xA7, 0x77, 0x0A, 0xC0, 0x80, 0x14, 0x04, 0x0D, 0xC0, 0x27, 0x76, 0xC0, 0x77, 0x01, 0x0D,
  0xB0, 0x77, 0x75, 0x03, 0xB0, 0xE7, 0x20, 0x6B, 0x0B, 0x77, 0x50, 0x5B, 0x0A, 0x72, 0x02, 0xB0,
  0xD7, 0x75, 0x07, 0xB0, 0x97, 0x3B, 0x0E, 0x77, 0x50, 0x7B, 0x09, 0x73, 0xB0, 0xE7, 0x75, 0x05,
  0xB0, 0xA7, 0x20, 0x2B, 0x0D, 0x77, 0x50, 0x3B, 0x0E, 0x72, 0x06, 0xB0, 0xB7, 0x76, 0xC0, 0x77,
  0x01, 0x0D, 0xB0, 0x77, 0x76, 0x0A, 0xC0, 0x80, 0x14, 0x03, 0x0D, 0xC0, 0x27, 0x76, 0x03, 0xD8,
  0x3E, 0xB9, 0xAD, 0xD0, 0xA7, 0x77, 0x10, 0x8F, 0xE0, 0xE0, 0x17, 0x77, 0x20, 0xAF, 0xC0, 0xE0,
  0x37, 0x77, 0x40, 0x60, 0xEF, 0x90, 0xB0, 0x17, 0x77, 0x68, 0x71, 0x6B, 0xDF, 0xEC, 0x93, 0x80,
  0xBA, 0x40, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x81, 0x17, 0xDF, 0xF0,
  0xA0, 0x37, 0x74, 0x07, 0xFF, 0xD0, 0x97, 0x72, 0x0C, 0xFF, 0xF0, 0xC0, 0x17, 0x60, 0xBF, 0xA8,
  0x3D, 0xA9, 0xAC, 0xFA, 0x0C, 0x75, 0x05, 0xF9, 0x0B, 0x02, 0x50, 0x10, 0x8F, 0x90, 0x87, 0x40,
  0xBF, 0x0B, 0x72, 0x05, 0xF0, 0xE0, 0x17, 0x30, 0xEF, 0x01, 0x73, 0x0B, 0xF0, 0x77, 0x3F, 0x0B,
  0x74, 0x05, 0xF0, 0xC7, 0x3F, 0x07, 0x74, 0x01, 0xF9, 0x73, 0x0B, 0xE0, 0x37, 0x50, 0xDF, 0x03,
  0x72, 0x05, 0xE0, 0x17, 0x50, 0xBF, 0x06, 0x73, 0x07, 0xD7, 0x60, 0x9F, 0x07, 0x74, 0x81, 0x39,
  0xDA, 0x76, 0x08, 0xF0, 0x87, 0x71, 0x01, 0x76, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97,
  0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77,
  0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x71, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xF9,
  0x09, 0x75, 0x81, 0x16, 0xCF, 0xFF, 0x90, 0x97, 0x40, 0x70, 0xEF, 0xFF, 0xB0, 0x97, 0x20, 0x10,
  0xCF, 0xFF, 0xD0, 0x97, 0x10, 0x10, 0xDF, 0xA8, 0x3D, 0x85, 0x21, 0x50, 0x5F, 0x09, 0x71, 0x0C,
  0xF9, 0x0D, 0x04, 0x73, 0x05, 0xF0, 0x97, 0x06, 0xF9, 0x0C, 0x01, 0x74, 0x05, 0xF0, 0x97, 0x0E,
  0xF0, 0xE0, 0x17, 0x50, 0x5F, 0x09, 0x60, 0x5F, 0x90, 0x67, 0x60, 0x5F, 0x09, 0x60, 0x9F, 0x0E,
  0x77, 0x05, 0xF0, 0x96, 0x0D, 0xF0, 0x97, 0x70, 0x5F, 0x09, 0x6F, 0x90, 0x67, 0x70, 0x6F, 0x09,
  0x50, 0x2F, 0x90, 0x37, 0x70, 0x7F, 0x09, 0x50, 0x3F, 0x90, 0x27, 0x70, 0x8F, 0x09, 0x50, 0x3F,
  0x90, 0x17, 0x70, 0xAF, 0x09, 0x50, 0x2F, 0x90, 0x17, 0x70, 0xDF, 0x09, 0x50, 0x1F, 0x90, 0x17,
  0x60, 0x1F, 0x90, 0x96, 0xF9, 0x03, 0x76, 0x07, 0xF9, 0x09, 0x60, 0xDF, 0x05, 0x76, 0x0D, 0xF9,
  0x0A, 0x60, 0xAF, 0x09, 0x75, 0x07, 0xFA, 0x0B, 0x60, 0x6F, 0x0E, 0x74, 0x83, 0x2E, 0xF6, 0xAE,
  0x0D, 0x60, 0x1F, 0x90, 0x67, 0x28, 0x41, 0xDF, 0xB0, 0x7F, 0x01, 0x60, 0xAF, 0x0E, 0x03, 0x78,
  0x54, 0xDF, 0xE1, 0x05, 0xF0, 0x96, 0x03, 0xFA, 0x08, 0x02, 0x28, 0x12, 0x5B, 0xB0, 0x52, 0x03,
  0xF9, 0x0A, 0x03, 0x50, 0x7F, 0xFB, 0x09, 0x4F, 0xC0, 0x94, 0x0A, 0xFF, 0x90, 0xA5, 0x0D, 0xFB,
  0x09, 0x50, 0x8F, 0xE0, 0xA6, 0x0B, 0xFB, 0x09, 0x60, 0x40, 0xCF, 0xA0, 0xE0, 0x67, 0x08, 0xFB,
  0x09, 0x71, 0x89, 0x04, 0x8C, 0xEF, 0xED, 0xA6, 0x17, 0x76,
  // "æ" (U+00E6)
  0x74, 0x84, 0x36, 0x9C, 0xDE, 0xA8, 0x3E, 0xCA, 0x61, 0x76, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDA,
  0x62, 0x77, 0x58, 0x12, 0x9E, 0xFE, 0x0A, 0x03, 0x72, 0x06, 0x0D, 0xFC, 0x0B, 0x03, 0x77, 0x20,
  0x8F, 0xFC, 0x08, 0x60, 0x20, 0xCF, 0xF9, 0x09, 0x76, 0x01, 0x0B, 0xFF, 0xE0, 0xA4, 0x04, 0x0E,
  0xFF, 0xB0, 0xD0, 0x17, 0x40, 0xBF, 0xA8, 0x3D, 0xA9, 0xAB, 0xF9, 0x09, 0x20, 0x4F, 0x83, 0xEB,
  0x99, 0xCF, 0x90, 0xD0, 0x17, 0x20, 0x5F, 0x90, 0xB0, 0x25, 0x01, 0x07, 0xF8, 0x15, 0x2E, 0xD0,
  0xE0, 0x65, 0x01, 0x09, 0xF0, 0xC7, 0x20, 0xBF, 0x0B, 0x72, 0x05, 0xE0, 0xD0, 0xCD, 0x0D, 0x02,
  0x71, 0x06, 0xF0, 0x87, 0x10, 0xEF, 0x02, 0x73, 0x0B, 0xFC, 0x0E, 0x02, 0x73, 0x0A, 0xF0, 0x27,
  0xF0, 0xB7, 0x40, 0x5F, 0xC0, 0x67, 0x40, 0x1F, 0x0A, 0x7F, 0x07, 0x74, 0x01, 0xFB, 0x0D, 0x76,
  0x0A, 0xF0, 0x16, 0x0C, 0xE0, 0x47, 0x50, 0xDF, 0xA0, 0x77, 0x60, 0x5F, 0x08, 0x60, 0x6E, 0x02,
  0x75, 0x0B, 0xFA, 0x02, 0x77, 0xF0, 0xD7, 0x0B, 0xD7, 0x60, 0x9F, 0x90, 0xD7, 0x71, 0x0C, 0xF0,
  0x27, 0x06, 0x0D, 0xB7, 0x60, 0x8F, 0x90, 0x97, 0x71, 0x09, 0xF0, 0x57, 0x28, 0x11, 0x45, 0x76,
  0x07, 0xF9, 0x06, 0x77, 0x10, 0x6F, 0x09, 0x77, 0x74, 0x07, 0xF9, 0x04, 0x77, 0x10, 0x4F, 0x0B,
  0x77, 0x74, 0x07, 0xF9, 0x02, 0x77, 0x10, 0x3F, 0x0D, 0x77, 0x74, 0x07, 0xF9, 0x77, 0x20, 0x1F,
  0x97, 0x77, 0x40, 0x7F, 0x0E, 0x77, 0x20, 0x1F, 0x90, 0x17, 0x77, 0x30, 0x7F, 0x0D, 0x77, 0x3F,
  0x90, 0x27, 0x77, 0x30, 0x7F, 0x0C, 0x77, 0x3F, 0x90, 0x27, 0x38, 0x51, 0x58, 0xAC, 0xDE, 0x80,
  0xC5, 0xF0, 0x37, 0x81, 0x16, 0xC8, 0x0D, 0x4F, 0x03, 0x60, 0x70, 0xE8, 0x0D, 0x6F, 0x03, 0x40,
  0x10, 0xC8, 0x0E, 0x0F, 0x03, 0x30, 0x10, 0xDF, 0xA8, 0x3D, 0x85, 0x21, 0x50, 0x5F, 0x0D, 0x80,
  0xA5, 0x90, 0x13, 0x0C, 0xF9, 0x0D, 0x05, 0x73, 0x05, 0xF0, 0xA7, 0x77, 0x70, 0x6F, 0x90, 0xC0,
  0x17, 0x40, 0x5F, 0x0A, 0x77, 0x77, 0x0E, 0xF0, 0xE0, 0x17, 0x50, 0x5F, 0x0B, 0x77, 0x76, 0x05,
  0xF9, 0x06, 0x76, 0x05, 0xF0, 0xC7, 0x77, 0x60, 0x9F, 0x0E, 0x77, 0x05, 0xF0, 0xD7, 0x77, 0x60,
  0xDF, 0x0A, 0x77, 0x05, 0xF9, 0x77, 0x76, 0xF9, 0x06, 0x77, 0x06, 0xF9, 0x01, 0x77, 0x74, 0x02,
  0xF9, 0x03, 0x77, 0x07, 0xF9, 0x04, 0x77, 0x74, 0x03, 0xF9, 0x02, 0x77, 0x07, 0xF9, 0x07, 0x77,
  0x74, 0x03, 0xF9, 0x01, 0x77, 0x09, 0xF9, 0x0A, 0x77, 0x74, 0x02, 0xF9, 0x01, 0x77, 0x0C, 0xF9,
  0x0E, 0x77, 0x74, 0x01, 0xF9, 0x01, 0x77, 0xFB, 0x04, 0x77, 0x74, 0xF9, 0x02, 0x76, 0x05, 0xFB,
  0x0A, 0x77, 0x50, 0x10, 0x34, 0x0D, 0xF0, 0x47, 0x60, 0xBB, 0x0D, 0xF0, 0x17, 0x74, 0x81, 0xAE,
  0x23, 0x0A, 0xF0, 0x77, 0x50, 0x4B, 0x0C, 0x03, 0xF0, 0xA7, 0x73, 0x05, 0xA0, 0x83, 0x06, 0xF0,
  0xC7, 0x50, 0xDB, 0x81, 0x50, 0xBF, 0x04, 0x77, 0x10, 0x30, 0xEA, 0x09, 0x30, 0x1F, 0x90, 0x37,
  0x30, 0xAB, 0x0B, 0x20, 0x3F, 0x0E, 0x03, 0x76, 0x03, 0x0E, 0xB0, 0x74, 0x0A, 0xF0, 0xC7, 0x20,
  0xAB, 0x0E, 0x01, 0x30, 0x8F, 0x0E, 0x05, 0x74, 0x06, 0xD0, 0x24, 0x03, 0xF9, 0x0C, 0x02, 0x50,
  0x50, 0xDC, 0x05, 0x50, 0xCF, 0x90, 0xB0, 0x47, 0x06, 0x0C, 0xD0, 0x96, 0x07, 0xFA, 0x83, 0xC9,
  0xAB, 0xED, 0x05, 0x60, 0x10, 0xDF, 0xA8, 0x4E, 0xB9, 0x9A, 0xCF, 0x0C, 0x71, 0x09, 0xFF, 0xB0,
  0x67, 0x10, 0x10, 0xBF, 0xFE, 0x0C, 0x01, 0x72, 0x07, 0xFF, 0x0C, 0x03, 0x74, 0x08, 0xFF, 0xC0,
  0x87, 0x50, 0x30, 0xBF, 0xB0, 0xE0, 0x77, 0x78, 0x11, 0x9E, 0xFD, 0x81, 0xE9, 0x27, 0x71, 0x89,
  0x03, 0x7B, 0xDE, 0xFE, 0xC9, 0x57, 0x75, 0x83, 0x48, 0xBD, 0xEA, 0x83, 0xED, 0xB8, 0x47, 0x30,
  // "ç" (U+00E7)
  0x75, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x73, 0x81, 0x19, 0xEF, 0xD8, 0x1D, 0x81,
  0x76, 0x08, 0xFF, 0xB0, 0xE0, 0x77, 0x30, 0x20, 0xCF, 0xFE, 0x0B, 0x71, 0x01, 0x0D, 0xF9, 0x83,
  0xEA, 0x9A, 0xDF, 0xA0, 0xA7, 0x0D, 0xF0, 0xC0, 0x45, 0x04, 0x0D, 0xF9, 0x05, 0x50, 0x9F, 0x0A,
  0x71, 0x01, 0x0E, 0xF0, 0xB4, 0x03, 0xF0, 0xB7, 0x30, 0x7F, 0x90, 0x13, 0x0B, 0xF0, 0x27, 0x30,
  0x1F, 0x90, 0x22, 0x04, 0xF0, 0x97, 0x50, 0xBF, 0x03, 0x20, 0xAF, 0x02, 0x75, 0x08, 0xF8, 0x12,
  0x01, 0xF0, 0xD7, 0x60, 0x5E, 0x0E, 0x20, 0x5F, 0x08, 0x76, 0x03, 0xE0, 0x82, 0x0A, 0xF0, 0x57,
  0x60, 0x2D, 0x0A, 0x30, 0xDF, 0x02, 0x76, 0x84, 0x1E, 0xDB, 0x83, 0x30, 0x1F, 0x0E, 0x77, 0x72,
  0x03, 0xF0, 0xC7, 0x77, 0x20, 0x6F, 0x0A, 0x77, 0x72, 0x08, 0xF0, 0x97, 0x77, 0x20, 0x9F, 0x08,
  0x77, 0x72, 0x0A, 0xF0, 0x77, 0x77, 0x20, 0xBF, 0x06, 0x77, 0x72, 0x0C, 0xF0, 0x57, 0x77, 0x20,
  0xDF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x05, 0x77, 0x72, 0x0C, 0xF0, 0x57,
  0x77, 0x20, 0xCF, 0x05, 0x77, 0x72, 0x0B, 0xF0, 0x67, 0x77, 0x20, 0xAF, 0x07, 0x77, 0x72, 0x09,
  0xF0, 0x87, 0x77, 0x20, 0x7F, 0x09, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x3F, 0x0D, 0x77,
  0x73, 0xF9, 0x77, 0x73, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0x9F, 0x07, 0x77, 0x72, 0x04, 0xF0, 0xC7,
  0x77, 0x30, 0xEF, 0x02, 0x77, 0x40, 0x20, 0x13, 0x09, 0xF0, 0x87, 0x74, 0x0B, 0x0A, 0x30, 0x2F,
  0x0E, 0x01, 0x77, 0x20, 0x7A, 0x02, 0x30, 0xAF, 0x09, 0x77, 0x10, 0x4B, 0x03, 0x30, 0x20, 0xEF,
  0x06, 0x76, 0x04, 0x0E, 0xB0, 0x24, 0x06, 0xF9, 0x07, 0x74, 0x07, 0xC0, 0xE6, 0x0A, 0xF9, 0x0B,
  0x04, 0x70, 0x60, 0xCD, 0x07, 0x70, 0xBF, 0xA8, 0x4E, 0xB9, 0x9A, 0xCF, 0x0C, 0x72, 0x09, 0xFF,
  0xE0, 0xD0, 0x17, 0x30, 0x50, 0xDF, 0xFB, 0x0A, 0x01, 0x76, 0x06, 0x0D, 0xFE, 0x0B, 0x03, 0x77,
  0x38, 0x12, 0x7C, 0xC8, 0x4E, 0xDB, 0x95, 0x17, 0x77, 0x05, 0xB0, 0x47, 0x77, 0x60, 0x9B, 0x01,
  0x77, 0x76, 0x0C, 0xB8, 0x1C, 0x94, 0x77, 0x74, 0xF0, 0xC0, 0x37, 0x77, 0x10, 0x3F, 0xA0, 0x57,
  0x77, 0x18, 0x14, 0x8D, 0xF0, 0x27, 0x77, 0x30, 0x50, 0xED, 0x0B, 0x77, 0x74, 0x03, 0xE0, 0x17,
  0x77, 0x40, 0xBD, 0x05, 0x77, 0x74, 0x07, 0xD0, 0x77, 0x77, 0x40, 0x6D, 0x07, 0x77, 0x74, 0x08,
  0xD0, 0x67, 0x77, 0x40, 0xBD, 0x05, 0x77, 0x73, 0x03, 0xE0, 0x17, 0x71, 0x00, 0x16, 0x05, 0x0E,
  0xD0, 0xC7, 0x72, 0x86, 0x7F, 0xDB, 0xA9, 0xAD, 0xF0, 0x57, 0x72, 0x07, 0xFE, 0x0A, 0x77, 0x30,
  0x7F, 0xD0, 0xB7, 0x74, 0x07, 0xFB, 0x0E, 0x07, 0x77, 0x68, 0x90, 0x58, 0xBD, 0xEF, 0xED, 0x95,
  0x75,
  // "è" (U+00E8)
  0x60, 0x38, 0x04, 0x70, 0x47, 0x77, 0x30, 0x5F, 0x90, 0xD7, 0x77, 0x40, 0xBF, 0x90, 0x57, 0x77,
  0x30, 0x10, 0xDF, 0x0C, 0x77, 0x74, 0x03, 0xF9, 0x04, 0x77, 0x74, 0x05, 0xF0, 0xC7, 0x77, 0x50,
  0x7F, 0x05, 0x77, 0x75, 0x08, 0xE0, 0xD7, 0x77, 0x60, 0xAE, 0x06, 0x77, 0x76, 0x0A, 0xD0, 0xE0,
  0x17, 0x77, 0x60, 0xAD, 0x09, 0x77, 0x77, 0x0A, 0xD0, 0x37, 0x77, 0x70, 0x9C, 0x0C, 0x77, 0x77,
  0x10, 0x7C, 0x06, 0x77, 0x77, 0x10, 0x50, 0xEA, 0x09, 0x80, 0xAF, 0x50, 0x89, 0x14, 0x8B, 0xDE,
  0xFE, 0xDB, 0x84, 0x77, 0x68, 0x11, 0x8E, 0xFC, 0x0E, 0x07, 0x77, 0x30, 0x60, 0xEF, 0xF9, 0x0E,
  0x04, 0x77, 0x0A, 0xFF, 0xD0, 0x87, 0x50, 0xBF, 0x98, 0x3D, 0xA9, 0xAD, 0xF9, 0x08, 0x73, 0x09,
  0xF0, 0xD0, 0x45, 0x03, 0x0C, 0xF0, 0x67, 0x10, 0x6F, 0x0B, 0x72, 0x0B, 0xF0, 0x26, 0x01, 0x0E,
  0xE0, 0xC7, 0x30, 0x10, 0xEE, 0x0C, 0x60, 0x9F, 0x03, 0x74, 0x06, 0xF0, 0x54, 0x01, 0xF0, 0xA7,
  0x6F, 0x0C, 0x40, 0x8F, 0x04, 0x76, 0x0A, 0xF0, 0x23, 0x0D, 0xE0, 0xD7, 0x70, 0x5F, 0x07, 0x20,
  0x3F, 0x09, 0x77, 0x02, 0xF0, 0xC2, 0x07, 0xF0, 0x57, 0x71, 0x0E, 0xF2, 0x0B, 0xF0, 0x17, 0x71,
  0x0B, 0xF8, 0x14, 0x0E, 0xE0, 0xE7, 0x72, 0x09, 0xF0, 0x60, 0x2F, 0x0C, 0x77, 0x20, 0x8F, 0x08,
  0x05, 0xF0, 0xA7, 0x72, 0x06, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x20, 0x5F, 0x0B, 0x09, 0xF0, 0x87,
  0x72, 0x05, 0xF0, 0xC0, 0xAF, 0x07, 0x77, 0x20, 0x4F, 0x0D, 0x0B, 0xFF, 0xFF, 0xC0, 0xD0, 0xCF,
  0xFF, 0xFC, 0x0D, 0x0C, 0xFF, 0xFF, 0xC0, 0x0D, 0xFF, 0xFF, 0xC0, 0x0D, 0xF0, 0xB8, 0x0A, 0x49,
  0x08, 0x0C, 0xF0, 0x57, 0x77, 0x40, 0xCF, 0x05, 0x77, 0x74, 0x0B, 0xF0, 0x67, 0x77, 0x40, 0xAF,
  0x07, 0x77, 0x74, 0x09, 0xF0, 0x87, 0x77, 0x40, 0x7F, 0x0A, 0x77, 0x74, 0x05, 0xF0, 0xC7, 0x77,
  0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0E, 0xF0, 0x27, 0x77, 0x40, 0xBF, 0x05, 0x77, 0x74, 0x07, 0xF0,
  0x97, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0C, 0xF0, 0x57, 0x75, 0x04, 0x01, 0x40, 0x6F, 0x0B,
  0x77, 0x48, 0x11, 0xEC, 0x50, 0xDF, 0x04, 0x77, 0x30, 0xBA, 0x03, 0x40, 0x6F, 0x0D, 0x01, 0x77,
  0x10, 0x9B, 0x05, 0x50, 0xCF, 0x0B, 0x77, 0x09, 0xC0, 0x25, 0x02, 0x0E, 0xF0, 0xC0, 0x17, 0x30,
  0x10, 0xBC, 0x0C, 0x70, 0x5F, 0x98, 0x1E, 0x81, 0x68, 0x12, 0x8E, 0xD0, 0x37, 0x10, 0x6F, 0xB8,
  0x4D, 0xA9, 0x9B, 0xDF, 0x07, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0x77, 0x50, 0x20, 0xBF, 0xFB, 0x0D,
  0x04, 0x77, 0x10, 0x50, 0xBF, 0xE0, 0xD0, 0x67, 0x75, 0x83, 0x26, 0x9C, 0xEA, 0x84, 0xEE, 0xCA,
  0x73, 0x72,
  // "é" (U+00E9)
  0x77, 0x60, 0x38, 0x04, 0x70, 0x47, 0x77, 0x30, 0xBF, 0x90, 0x87, 0x77, 0x20, 0x2F, 0x90, 0xD0,
  0x17, 0x77, 0x20, 0x9F, 0x90, 0x37, 0x77, 0x20, 0x1F, 0x90, 0x57, 0x77, 0x30, 0x9F, 0x08, 0x77,
  0x73, 0x02, 0xF0, 0xA7, 0x77, 0x40, 0xAE, 0x0B, 0x77, 0x74, 0x04, 0xE0, 0xB7, 0x77, 0x50, 0xCD,
  0x0C, 0x77, 0x75, 0x06, 0xD0, 0xC7, 0x77, 0x50, 0x10, 0xEC, 0x0B, 0x77, 0x76, 0x09, 0xC0, 0xA7,
  0x77, 0x60, 0x3C, 0x09, 0x77, 0x77, 0x06, 0xB0, 0x68, 0x0B, 0x82, 0x08, 0x91, 0x48, 0xBD, 0xEF,
  0xED, 0xB8, 0x47, 0x76, 0x81, 0x18, 0xEF, 0xC0, 0xE0, 0x77, 0x73, 0x06, 0x0E, 0xFF, 0x90, 0xE0,
  0x47, 0x70, 0xAF, 0xFD, 0x08, 0x75, 0x0B, 0xF9, 0x83, 0xDA, 0x9A, 0xDF, 0x90, 0x87, 0x30, 0x9F,
  0x0D, 0x04, 0x50, 0x30, 0xCF, 0x06, 0x71, 0x06, 0xF0, 0xB7, 0x20, 0xBF, 0x02, 0x60, 0x10, 0xEE,
  0x0C, 0x73, 0x01, 0x0E, 0xE0, 0xC6, 0x09, 0xF0, 0x37, 0x40, 0x6F, 0x05, 0x40, 0x1F, 0x0A, 0x76,
  0xF0, 0xC4, 0x08, 0xF0, 0x47, 0x60, 0xAF, 0x02, 0x30, 0xDE, 0x0D, 0x77, 0x05, 0xF0, 0x72, 0x03,
  0xF0, 0x97, 0x70, 0x2F, 0x0C, 0x20, 0x7F, 0x05, 0x77, 0x10, 0xEF, 0x20, 0xBF, 0x01, 0x77, 0x10,
  0xBF, 0x81, 0x40, 0xEE, 0x0E, 0x77, 0x20, 0x9F, 0x06, 0x02, 0xF0, 0xC7, 0x72, 0x08, 0xF0, 0x80,
  0x5F, 0x0A, 0x77, 0x20, 0x6F, 0x0A, 0x07, 0xF0, 0x97, 0x72, 0x05, 0xF0, 0xB0, 0x9F, 0x08, 0x77,
  0x20, 0x5F, 0x0C, 0x0A, 0xF0, 0x77, 0x72, 0x04, 0xF0, 0xD0, 0xBF, 0xFF, 0xFC, 0x0D, 0x0C, 0xFF,
  0xFF, 0xC0, 0xD0, 0xCF, 0xFF, 0xFC, 0x00, 0xDF, 0xFF, 0xFC, 0x00, 0xDF, 0x0B, 0x80, 0xA4, 0x90,
  0x80, 0xCF, 0x05, 0x77, 0x74, 0x0C, 0xF0, 0x57, 0x77, 0x40, 0xBF, 0x06, 0x77, 0x74, 0x0A, 0xF0,
  0x77, 0x77, 0x40, 0x9F, 0x08, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x40, 0x5F, 0x0C, 0x77, 0x74,
  0x02, 0xF0, 0xE7, 0x77, 0x50, 0xEF, 0x02, 0x77, 0x74, 0x0B, 0xF0, 0x57, 0x77, 0x40, 0x7F, 0x09,
  0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x50, 0xCF, 0x05, 0x77, 0x50, 0x40, 0x14, 0x06, 0xF0, 0xB7,
  0x74, 0x81, 0x1E, 0xC5, 0x0D, 0xF0, 0x47, 0x73, 0x0B, 0xA0, 0x34, 0x06, 0xF0, 0xD0, 0x17, 0x71,
  0x09, 0xB0, 0x55, 0x0C, 0xF0, 0xB7, 0x70, 0x9C, 0x02, 0x50, 0x20, 0xEF, 0x0C, 0x01, 0x73, 0x01,
  0x0B, 0xC0, 0xC7, 0x05, 0xF9, 0x81, 0xE8, 0x16, 0x81, 0x28, 0xED, 0x03, 0x71, 0x06, 0xFB, 0x84,
  0xDA, 0x99, 0xBD, 0xF0, 0x77, 0x30, 0x50, 0xEF, 0xFE, 0x07, 0x75, 0x02, 0x0B, 0xFF, 0xB0, 0xD0,
  0x47, 0x71, 0x05, 0x0B, 0xFE, 0x0D, 0x06, 0x77, 0x58, 0x32, 0x69, 0xCE, 0xA8, 0x4E, 0xEC, 0xA7,
  0x37, 0x20,
  // "ê" (U+00EA)
  0x76, 0x05, 0x80, 0x37, 0x02, 0x77, 0x73, 0x01, 0x0E, 0xF0, 0xB7, 0x77, 0x30, 0x7F, 0xA0, 0x27,
  0x77, 0x10, 0x10, 0xEF, 0xA0, 0xA7, 0x77, 0x10, 0x8F, 0xC0, 0x37, 0x76, 0x02, 0xFD, 0x0C, 0x77,
  0x60, 0xBD, 0x0C, 0x05, 0xE0, 0x57, 0x74, 0x05, 0xD8, 0x2E, 0x20, 0x7D, 0x0E, 0x01, 0x77, 0x30,
  0xDD, 0x05, 0x30, 0xAD, 0x09, 0x77, 0x20, 0x8D, 0x06, 0x50, 0xBD, 0x03, 0x77, 0x03, 0xD0, 0x87,
  0x0C, 0xC0, 0xC7, 0x70, 0xCC, 0x08, 0x71, 0x01, 0x0C, 0xC0, 0x77, 0x50, 0x7C, 0x08, 0x73, 0x01,
  0x0C, 0xC0, 0x27, 0x30, 0x2C, 0x08, 0x75, 0x01, 0x0C, 0xB0, 0xC7, 0x30, 0x6B, 0x08, 0x77, 0x01,
  0x0C, 0xB0, 0x18, 0x0A, 0xE6, 0x08, 0x91, 0x48, 0xBD, 0xEF, 0xED, 0xB8, 0x47, 0x76, 0x81, 0x18,
  0xEF, 0xC0, 0xE0, 0x77, 0x73, 0x06, 0x0E, 0xFF, 0x90, 0xE0, 0x47, 0x70, 0xAF, 0xFD, 0x08, 0x75,
  0x0B, 0xF9, 0x83, 0xDA, 0x9A, 0xDF, 0x90, 0x87, 0x30, 0x9F, 0x0D, 0x04, 0x50, 0x30, 0xCF, 0x06,
  0x71, 0x06, 0xF0, 0xB7, 0x20, 0xBF, 0x02, 0x60, 0x10, 0xEE, 0x0C, 0x73, 0x01, 0x0E, 0xE0, 0xC6,
  0x09, 0xF0, 0x37, 0x40, 0x6F, 0x05, 0x40, 0x1F, 0x0A, 0x76, 0xF0, 0xC4, 0x08, 0xF0, 0x47, 0x60,
  0xAF, 0x02, 0x30, 0xDE, 0x0D, 0x77, 0x05, 0xF0, 0x72, 0x03, 0xF0, 0x97, 0x70, 0x2F, 0x0C, 0x20,
  0x7F, 0x05, 0x77, 0x10, 0xEF, 0x20, 0xBF, 0x01, 0x77, 0x10, 0xBF, 0x81, 0x40, 0xEE, 0x0E, 0x77,
  0x20, 0x9F, 0x06, 0x02, 0xF0, 0xC7, 0x72, 0x08, 0xF0, 0x80, 0x5F, 0x0A, 0x77, 0x20, 0x6F, 0x0A,
  0x07, 0xF0, 0x97, 0x72, 0x05, 0xF0, 0xB0, 0x9F, 0x08, 0x77, 0x20, 0x5F, 0x0C, 0x0A, 0xF0, 0x77,
  0x72, 0x04, 0xF0, 0xD0, 0xBF, 0xFF, 0xFC, 0x0D, 0x0C, 0xFF, 0xFF, 0xC0, 0xD0, 0xCF, 0xFF, 0xFC,
  0x00, 0xDF, 0xFF, 0xFC, 0x00, 0xDF, 0x0B, 0x80, 0xA4, 0x90, 0x80, 0xCF, 0x05, 0x77, 0x74, 0x0C,
  0xF0, 0x57, 0x77, 0x40, 0xBF, 0x06, 0x77, 0x74, 0x0A, 0xF0, 0x77, 0x77, 0x40, 0x9F, 0x08, 0x77,
  0x74, 0x07, 0xF0, 0xA7, 0x77, 0x40, 0x5F, 0x0C, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x50, 0xEF,
  0x02, 0x77, 0x74, 0x0B, 0xF0, 0x57, 0x77, 0x40, 0x7F, 0x09, 0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77,
  0x50, 0xCF, 0x05, 0x77, 0x50, 0x40, 0x14, 0x06, 0xF0, 0xB7, 0x74, 0x81, 0x1E, 0xC5, 0x0D, 0xF0,
  0x47, 0x73, 0x0B, 0xA0, 0x34, 0x06, 0xF0, 0xD0, 0x17, 0x71, 0x09, 0xB0, 0x55, 0x0C, 0xF0, 0xB7,
  0x70, 0x9C, 0x02, 0x50, 0x20, 0xEF, 0x0C, 0x01, 0x73, 0x01, 0x0B, 0xC0, 0xC7, 0x05, 0xF9, 0x81,
  0xE8, 0x16, 0x81, 0x28, 0xED, 0x03, 0x71, 0x06, 0xFB, 0x84, 0xDA, 0x99, 0xBD, 0xF0, 0x77, 0x30,
  0x50, 0xEF, 0xFE, 0x07, 0x75, 0x02, 0x0B, 0xFF, 0xB0, 0xD0, 0x47, 0x71, 0x05, 0x0B, 0xFE, 0x0D,
  0x06, 0x77, 0x58, 0x32, 0x69, 0xCE, 0xA8, 0x4E, 0xEC, 0xA7, 0x37, 0x20,
  // "ë" (U+00EB)
  0x78, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x47, 0x60, 0x10, 0xED, 0x03, 0x70, 0xDD,
  0x05, 0x75, 0x08, 0xE0, 0xB6, 0x06, 0xE0, 0xD7, 0x50, 0xCF, 0x60, 0xAF, 0x02, 0x74, 0x0E, 0xF0,
  0x25, 0x0B, 0xF0, 0x47, 0x40, 0xEF, 0x02, 0x50, 0xBF, 0x04, 0x74, 0x0C, 0xF6, 0x0A, 0xF0, 0x27,
  0x40, 0x9E, 0x0C, 0x60, 0x7E, 0x0E, 0x75, 0x02, 0x0E, 0xD0, 0x46, 0x01, 0x0D, 0xD0, 0x67, 0x68,
  0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x58, 0x0C, 0xB7, 0x08, 0x91, 0x48, 0xBD, 0xEF,
  0xED, 0xB8, 0x47, 0x76, 0x81, 0x18, 0xEF, 0xC0, 0xE0, 0x77, 0x73, 0x06, 0x0E, 0xFF, 0x90, 0xE0,
  0x47, 0x70, 0xAF, 0xFD, 0x08, 0x75, 0x0B, 0xF9, 0x83, 0xDA, 0x9A, 0xDF, 0x90, 0x87, 0x30, 0x9F,
  0x0D, 0x04, 0x50, 0x30, 0xCF, 0x06, 0x71, 0x06, 0xF0, 0xB7, 0x20, 0xBF, 0x02, 0x60, 0x10, 0xEE,
  0x0C, 0x73, 0x01, 0x0E, 0xE0, 0xC6, 0x09, 0xF0, 0x37, 0x40, 0x6F, 0x05, 0x40, 0x1F, 0x0A, 0x76,
  0xF0, 0xC4, 0x08, 0xF0, 0x47, 0x60, 0xAF, 0x02, 0x30, 0xDE, 0x0D, 0x77, 0x05, 0xF0, 0x72, 0x03,
  0xF0, 0x97, 0x70, 0x2F, 0x0C, 0x20, 0x7F, 0x05, 0x77, 0x10, 0xEF, 0x20, 0xBF, 0x01, 0x77, 0x10,
  0xBF, 0x81, 0x40, 0xEE, 0x0E, 0x77, 0x20, 0x9F, 0x06, 0x02, 0xF0, 0xC7, 0x72, 0x08, 0xF0, 0x80,
  0x5F, 0x0A, 0x77, 0x20, 0x6F, 0x0A, 0x07, 0xF0, 0x97, 0x72, 0x05, 0xF0, 0xB0, 0x9F, 0x08, 0x77,
  0x20, 0x5F, 0x0C, 0x0A, 0xF0, 0x77, 0x72, 0x04, 0xF0, 0xD0, 0xBF, 0xFF, 0xFC, 0x0D, 0x0C, 0xFF,
  0xFF, 0xC0, 0xD0, 0xCF, 0xFF, 0xFC, 0x00, 0xDF, 0xFF, 0xFC, 0x00, 0xDF, 0x0B, 0x80, 0xA4, 0x90,
  0x80, 0xCF, 0x05, 0x77, 0x74, 0x0C, 0xF0, 0x57, 0x77, 0x40, 0xBF, 0x06, 0x77, 0x74, 0x0A, 0xF0,
  0x77, 0x77, 0x40, 0x9F, 0x08, 0x77, 0x74, 0x07, 0xF0, 0xA7, 0x77, 0x40, 0x5F, 0x0C, 0x77, 0x74,
  0x02, 0xF0, 0xE7, 0x77, 0x50, 0xEF, 0x02, 0x77, 0x74, 0x0B, 0xF0, 0x57, 0x77, 0x40, 0x7F, 0x09,
  0x77, 0x74, 0x02, 0xF0, 0xE7, 0x77, 0x50, 0xCF, 0x05, 0x77, 0x50, 0x40, 0x14, 0x06, 0xF0, 0xB7,
  0x74, 0x81, 0x1E, 0xC5, 0x0D, 0xF0, 0x47, 0x73, 0x0B, 0xA0, 0x34, 0x06, 0xF0, 0xD0, 0x17, 0x71,
  0x09, 0xB0, 0x55, 0x0C, 0xF0, 0xB7, 0x70, 0x9C, 0x02, 0x50, 0x20, 0xEF, 0x0C, 0x01, 0x73, 0x01,
  0x0B, 0xC0, 0xC7, 0x05, 0xF9, 0x81, 0xE8, 0x16, 0x81, 0x28, 0xED, 0x03, 0x71, 0x06, 0xFB, 0x84,
  0xDA, 0x99, 0xBD, 0xF0, 0x77, 0x30, 0x50, 0xEF, 0xFE, 0x07, 0x75, 0x02, 0x0B, 0xFF, 0xB0, 0xD0,
  0x47, 0x71, 0x05, 0x0B, 0xFE, 0x0D, 0x06, 0x77, 0x58, 0x32, 0x69, 0xCE, 0xA8, 0x4E, 0xEC, 0xA7,
  0x37, 0x20,
  // "ì" (U+00EC)
  0x03, 0x80, 0x47, 0x04, 0x77, 0x05, 0xF9, 0x0D, 0x77, 0x10, 0xBF, 0x90, 0x57, 0x70, 0x10, 0xDF,
  0x0C, 0x77, 0x10, 0x3F, 0x90, 0x47, 0x71, 0x05, 0xF0, 0xC7, 0x72, 0x07, 0xF0, 0x57, 0x72, 0x08,
  0xE0, 0xD7, 0x73, 0x0A, 0xE0, 0x67, 0x73, 0x0A, 0xD0, 0xE0, 0x17, 0x73, 0x0A, 0xD0, 0x97, 0x74,
  0x0A, 0xD0, 0x37, 0x74, 0x09, 0xC0, 0xC7, 0x75, 0x07, 0xC0, 0x67, 0x75, 0x05, 0x0E, 0xA0, 0x98,
  0x0A, 0xA5, 0x00, 0xBF, 0xE0, 0xC7, 0x20, 0xBF, 0xE0, 0xC7, 0x20, 0xBF, 0xE0, 0xC7, 0x20, 0xBF,
  0xE0, 0xC7, 0x48, 0x11, 0x5B, 0xFA, 0x0C, 0x77, 0x06, 0xF9, 0x0C, 0x77, 0x10, 0xCF, 0x0C, 0x77,
  0x10, 0x7F, 0x0C, 0x77, 0x10, 0x4F, 0x0C, 0x77, 0x10, 0x3F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77,
  0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77,
  0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77,
  0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77,
  0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77,
  0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77,
  0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77,
  0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0D, 0x77, 0x10, 0x3F, 0x0D, 0x77,
  0x10, 0x4F, 0x0E, 0x77, 0x10, 0x7F, 0x90, 0x27, 0x70, 0xCF, 0x90, 0x87, 0x60, 0x6F, 0xA0, 0xE0,
  0x37, 0x28, 0x12, 0x5B, 0xFD, 0x81, 0xA4, 0x13, 0x04, 0xFF, 0xF8, 0x1E, 0x04, 0xFF, 0xF8, 0x1E,
  0x04, 0xFF, 0xF8, 0x1E, 0x04, 0xFF, 0xF0, 0xE0,
  // "í" (U+00ED)
  0x77, 0x03, 0x80, 0x47, 0x04, 0x77, 0x0B, 0xF9, 0x08, 0x76, 0x02, 0xF9, 0x0D, 0x01, 0x76, 0x09,
  0xF9, 0x03, 0x76, 0x01, 0xF9, 0x05, 0x77, 0x09, 0xF0, 0x87, 0x70, 0x2F, 0x0A, 0x77, 0x10, 0xAE,
  0x0B, 0x77, 0x10, 0x4E, 0x0B, 0x77, 0x20, 0xCD, 0x0C, 0x77, 0x20, 0x6D, 0x0C, 0x77, 0x20, 0x10,
  0xEC, 0x0B, 0x77, 0x30, 0x9C, 0x0A, 0x77, 0x30, 0x3C, 0x09, 0x77, 0x40, 0x6B, 0x06, 0x80, 0xAB,
  0x10, 0x0B, 0xFE, 0x0C, 0x72, 0x0B, 0xFE, 0x0C, 0x72, 0x0B, 0xFE, 0x0C, 0x72, 0x0B, 0xFE, 0x0C,
  0x74, 0x81, 0x15, 0xBF, 0xA0, 0xC7, 0x70, 0x6F, 0x90, 0xC7, 0x71, 0x0C, 0xF0, 0xC7, 0x71, 0x07,
  0xF0, 0xC7, 0x71, 0x04, 0xF0, 0xC7, 0x71, 0x03, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02,
  0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02,
  0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02,
  0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02,
  0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02,
  0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02,
  0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02,
  0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xD7, 0x71, 0x03, 0xF0, 0xD7, 0x71, 0x04,
  0xF0, 0xE7, 0x71, 0x07, 0xF9, 0x02, 0x77, 0x0C, 0xF9, 0x08, 0x76, 0x06, 0xFA, 0x0E, 0x03, 0x72,
  0x81, 0x25, 0xBF, 0xD8, 0x1A, 0x41, 0x30, 0x4F, 0xFF, 0x81, 0xE0, 0x4F, 0xFF, 0x81, 0xE0, 0x4F,
  0xFF, 0x81, 0xE0, 0x4F, 0xFF, 0x0E, 0x10,
  // "î" (U+00EE)
  0x71, 0x05, 0x80, 0x37, 0x02, 0x77, 0x10, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0x7F, 0xA0, 0x27, 0x60,
  0x10, 0xEF, 0xA0, 0xA7, 0x60, 0x8F, 0xC0, 0x37, 0x40, 0x2F, 0xD0, 0xC7, 0x40, 0xBD, 0x0C, 0x05,
  0xE0, 0x57, 0x20, 0x5D, 0x82, 0xE2, 0x07, 0xD0, 0xE0, 0x17, 0x10, 0xDD, 0x05, 0x30, 0xAD, 0x09,
  0x70, 0x8D, 0x06, 0x50, 0xBD, 0x03, 0x50, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x50, 0xCC, 0x08, 0x71,
  0x01, 0x0C, 0xC0, 0x73, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x81, 0x20, 0x2C, 0x08, 0x75, 0x01,
  0x0C, 0xB8, 0x1C, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB, 0x01, 0x80, 0xAA, 0x40, 0x0B, 0xFE, 0x0C,
  0x73, 0x0B, 0xFE, 0x0C, 0x73, 0x0B, 0xFE, 0x0C, 0x73, 0x0B, 0xFE, 0x0C, 0x75, 0x81, 0x15, 0xBF,
  0xA0, 0xC7, 0x71, 0x06, 0xF9, 0x0C, 0x77, 0x20, 0xCF, 0x0C, 0x77, 0x20, 0x7F, 0x0C, 0x77, 0x20,
  0x4F, 0x0C, 0x77, 0x20, 0x3F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20,
  0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20,
  0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20,
  0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20,
  0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20,
  0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20,
  0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0C, 0x77, 0x20,
  0x2F, 0x0C, 0x77, 0x20, 0x2F, 0x0D, 0x77, 0x20, 0x3F, 0x0D, 0x77, 0x20, 0x4F, 0x0E, 0x77, 0x20,
  0x7F, 0x90, 0x27, 0x71, 0x0C, 0xF9, 0x08, 0x77, 0x06, 0xFA, 0x0E, 0x03, 0x73, 0x81, 0x25, 0xBF,
  0xD8, 0x1A, 0x41, 0x40, 0x4F, 0xFF, 0x0E, 0x20, 0x4F, 0xFF, 0x0E, 0x20, 0x4F, 0xFF, 0x0E, 0x20,
  0x4F, 0xFF, 0x0E, 0x10,
  // "ï" (U+00EF)
  0x18, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x42, 0x01, 0x0E, 0xD0, 0x37, 0x0D, 0xD8,
  0x15, 0x08, 0xE0, 0xB6, 0x06, 0xE8, 0x1D, 0x0C, 0xF6, 0x0A, 0xF0, 0x20, 0xEF, 0x02, 0x50, 0xBF,
  0x04, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x40, 0xCF, 0x60, 0xAF, 0x02, 0x09, 0xE0, 0xC6, 0x07, 0xE8,
  0x2E, 0x02, 0xED, 0x04, 0x60, 0x10, 0xDD, 0x06, 0x28, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E,
  0xFC, 0x58, 0x0B, 0x96, 0x00, 0xBF, 0xE0, 0xC7, 0x10, 0xBF, 0xE0, 0xC7, 0x10, 0xBF, 0xE0, 0xC7,
  0x10, 0xBF, 0xE0, 0xC7, 0x38, 0x11, 0x5B, 0xFA, 0x0C, 0x76, 0x06, 0xF9, 0x0C, 0x77, 0x0C, 0xF0,
  0xC7, 0x70, 0x7F, 0x0C, 0x77, 0x04, 0xF0, 0xC7, 0x70, 0x3F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70,
  0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C,
  0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02,
  0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7,
  0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F,
  0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77,
  0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0D, 0x77, 0x03, 0xF0,
  0xD7, 0x70, 0x4F, 0x0E, 0x77, 0x07, 0xF9, 0x02, 0x76, 0x0C, 0xF9, 0x08, 0x75, 0x06, 0xFA, 0x0E,
  0x03, 0x71, 0x81, 0x25, 0xBF, 0xD8, 0x1A, 0x41, 0x20, 0x4F, 0xFF, 0x0E, 0x04, 0xFF, 0xF0, 0xE0,
  0x4F, 0xFF, 0x0E, 0x04, 0xFF, 0xF0, 0xE0,
  // "ð" (U+00F0)
  0x78, 0x16, 0x93, 0x77, 0x50, 0x20, 0xA7, 0x60, 0x7A, 0x81, 0xD7, 0x17, 0x71, 0x81, 0x6E, 0xE7,
  0x60, 0x7C, 0x81, 0xE9, 0x27, 0x40, 0x10, 0xAA, 0x0E, 0x76, 0x07, 0xF0, 0x90, 0x17, 0x10, 0x50,
  0xEB, 0x0E, 0x76, 0x06, 0xFA, 0x08, 0x60, 0x9D, 0x0E, 0x77, 0x03, 0x0A, 0xF9, 0x0D, 0x03, 0x20,
  0x40, 0xDD, 0x0D, 0x04, 0x77, 0x20, 0x30, 0xBF, 0x90, 0x08, 0xE0, 0xA0, 0x17, 0x75, 0x05, 0x0E,
  0xFD, 0x0E, 0x05, 0x77, 0x71, 0x01, 0x0A, 0xFB, 0x0B, 0x02, 0x77, 0x74, 0x07, 0xF9, 0x0B, 0x77,
  0x75, 0x03, 0x0D, 0xFA, 0x05, 0x77, 0x73, 0x07, 0xFD, 0x04, 0x77, 0x70, 0x20, 0xCE, 0x0D, 0xE0,
  0xE0, 0x37, 0x75, 0x06, 0xE8, 0x2D, 0x31, 0xDE, 0x0D, 0x77, 0x40, 0x4E, 0x08, 0x30, 0x20, 0xEE,
  0x09, 0x77, 0x30, 0x4C, 0x0D, 0x03, 0x50, 0x4F, 0x05, 0x77, 0x20, 0x4B, 0x08, 0x71, 0x08, 0xE0,
  0xE7, 0x72, 0x82, 0x4F, 0xC3, 0x73, 0x0D, 0xE0, 0x87, 0x71, 0x04, 0x08, 0x75, 0x04, 0xF0, 0x27,
  0x77, 0x71, 0x0B, 0xE0, 0xA7, 0x77, 0x71, 0x03, 0xF0, 0x17, 0x77, 0x71, 0x0B, 0xE0, 0x87, 0x77,
  0x71, 0x04, 0xE0, 0xE7, 0x71, 0x89, 0x21, 0x59, 0xBD, 0xEF, 0xED, 0xB7, 0x23, 0x0E, 0xE0, 0x67,
  0x50, 0x30, 0xAF, 0xD8, 0x2B, 0x40, 0x9E, 0x0B, 0x73, 0x01, 0x0A, 0xFF, 0xA0, 0xB0, 0x5F, 0x01,
  0x71, 0x04, 0x0E, 0xFF, 0xC0, 0xEF, 0x06, 0x70, 0x4F, 0xA8, 0x4E, 0xBA, 0x9A, 0xCF, 0xE0, 0xB6,
  0x03, 0xF9, 0x0D, 0x05, 0x68, 0x11, 0x6E, 0xFC, 0x60, 0xDF, 0x09, 0x73, 0x01, 0x0B, 0xFB, 0x03,
  0x40, 0x9F, 0x0A, 0x76, 0x0C, 0xFA, 0x06, 0x30, 0x2F, 0x0E, 0x77, 0x02, 0xFA, 0x0A, 0x30, 0x9F,
  0x07, 0x77, 0x10, 0x9F, 0x90, 0xD3, 0x0E, 0xF0, 0x17, 0x71, 0x03, 0xFA, 0x20, 0x5F, 0x0A, 0x77,
  0x30, 0xDF, 0x98, 0x11, 0x09, 0xF0, 0x67, 0x73, 0x09, 0xF9, 0x81, 0x30, 0xDF, 0x02, 0x77, 0x30,
  0x5F, 0x90, 0x50, 0x1F, 0x0E, 0x77, 0x40, 0x2F, 0x90, 0x70, 0x4F, 0x0C, 0x77, 0x5F, 0x90, 0x80,
  0x6F, 0x0A, 0x77, 0x50, 0xDF, 0x00, 0x8F, 0x08, 0x77, 0x50, 0xBF, 0x09, 0x0A, 0xF0, 0x77, 0x75,
  0x0A, 0xF0, 0x90, 0xBF, 0x06, 0x77, 0x50, 0x9F, 0x0A, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0,
  0xCF, 0x05, 0x77, 0x50, 0x8F, 0x09, 0x0D, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0x90, 0xDF, 0x05, 0x77,
  0x50, 0x8F, 0x08, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0x70, 0xCF, 0x06, 0x77, 0x50, 0x9F, 0x06,
  0x0B, 0xF0, 0x67, 0x75, 0x09, 0xF0, 0x40, 0x9F, 0x07, 0x77, 0x50, 0xAF, 0x02, 0x08, 0xF0, 0x97,
  0x75, 0x0C, 0xF1, 0x05, 0xF0, 0xB7, 0x75, 0x0E, 0xE8, 0x1D, 0x03, 0xF0, 0xD7, 0x75, 0xF0, 0xA2,
  0x0E, 0xF7, 0x74, 0x03, 0xF0, 0x72, 0x0B, 0xF0, 0x37, 0x73, 0x06, 0xF0, 0x32, 0x07, 0xF0, 0x77,
  0x73, 0x0A, 0xE0, 0xE3, 0x02, 0xF0, 0xC7, 0x73, 0x0E, 0xE0, 0x84, 0x0B, 0xF0, 0x27, 0x71, 0x05,
  0xF0, 0x34, 0x04, 0xF0, 0x97, 0x71, 0x0B, 0xE0, 0xB6, 0x0C, 0xF0, 0x27, 0x60, 0x4F, 0x04, 0x60,
  0x3F, 0x0C, 0x75, 0x01, 0x0E, 0xE0, 0xA7, 0x10, 0x8F, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xE0, 0xE0,
  0x17, 0x20, 0xBF, 0x81, 0xE6, 0x15, 0x81, 0x17, 0xEF, 0x04, 0x74, 0x0C, 0xFA, 0x83, 0xCA, 0x9A,
  0xCF, 0xA0, 0x57, 0x60, 0xAF, 0xFE, 0x0E, 0x04, 0x77, 0x10, 0x50, 0xEF, 0xFB, 0x0B, 0x01, 0x77,
  0x40, 0x70, 0xDF, 0xE0, 0xA0, 0x37, 0x77, 0x18, 0x33, 0x7A, 0xCE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  0x50,
  // "ñ" (U+00F1)
  0x76, 0x86, 0x29, 0xDE, 0xED, 0x94, 0x75, 0x0F, 0x30, 0x27, 0x77, 0x07, 0xF9, 0x0C, 0x04, 0x72,
  0x05, 0xB0, 0x77, 0x76, 0x07, 0xFC, 0x0A, 0x01, 0x70, 0x9B, 0x05, 0x77, 0x50, 0x4F, 0xE0, 0xE0,
  0x55, 0x02, 0xC0, 0x27, 0x75, 0x0D, 0xFF, 0x98, 0x4B, 0x41, 0x04, 0xDB, 0x0D, 0x77, 0x50, 0x5B,
  0x84, 0xE6, 0x11, 0x4C, 0xFF, 0xA0, 0x77, 0x75, 0x0A, 0xB0, 0x65, 0x07, 0xFF, 0x0E, 0x01, 0x77,
  0x50, 0xEA, 0x0E, 0x70, 0x30, 0xEF, 0xD0, 0x77, 0x75, 0x02, 0xB0, 0xA7, 0x10, 0x10, 0xBF, 0xB0,
  0xB7, 0x76, 0x04, 0xB0, 0x77, 0x30, 0x70, 0xEF, 0x0A, 0x01, 0x77, 0x70, 0xF1, 0x75, 0x86, 0x17,
  0xCE, 0xFD, 0xA4, 0x80, 0xC8, 0x60, 0x82, 0x49, 0xCE, 0xA8, 0x2E, 0xB8, 0x37, 0x70, 0x8F, 0xD0,
  0x96, 0x06, 0x0D, 0xFB, 0x0C, 0x04, 0x75, 0x08, 0xFD, 0x0B, 0x50, 0xBF, 0xF0, 0x87, 0x40, 0x8F,
  0xD0, 0xD4, 0x0C, 0xFF, 0xA0, 0xA7, 0x30, 0x8F, 0xE3, 0x09, 0xFF, 0xC0, 0x77, 0x48, 0x12, 0x5C,
  0xFA, 0x81, 0x10, 0x4F, 0xFE, 0x02, 0x76, 0x07, 0xF9, 0x81, 0x30, 0xDB, 0x86, 0xA5, 0x10, 0x12,
  0x6C, 0xFA, 0x0B, 0x77, 0x0C, 0xF0, 0x05, 0xA0, 0xD0, 0x37, 0x10, 0x7F, 0xA0, 0x27, 0x60, 0x7F,
  0x83, 0x7C, 0xFE, 0x27, 0x30, 0x9F, 0x90, 0x77, 0x60, 0x4F, 0x0E, 0xA0, 0x47, 0x50, 0xEF, 0x0C,
  0x76, 0x03, 0xFA, 0x0A, 0x76, 0x08, 0xF9, 0x76, 0x02, 0xFA, 0x03, 0x76, 0x02, 0xF9, 0x03, 0x75,
  0x02, 0xF9, 0x0D, 0x77, 0x10, 0xEF, 0x05, 0x75, 0x02, 0xF9, 0x09, 0x77, 0x10, 0xBF, 0x07, 0x75,
  0x02, 0xF9, 0x06, 0x77, 0x10, 0x9F, 0x08, 0x75, 0x02, 0xF9, 0x03, 0x77, 0x10, 0x7F, 0x09, 0x75,
  0x02, 0xF9, 0x01, 0x77, 0x10, 0x6F, 0x0A, 0x75, 0x02, 0xF9, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02,
  0xF0, 0xE7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0D, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0,
  0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7,
  0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72,
  0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05,
  0xF0, 0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0,
  0xA7, 0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7,
  0x50, 0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50,
  0x2F, 0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F,
  0x0C, 0x77, 0x20, 0x5F, 0x0A, 0x75, 0x02, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x2F, 0x0C,
  0x77, 0x20, 0x5F, 0x0A, 0x75, 0x03, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x50, 0x3F, 0x0D, 0x77,
  0x20, 0x5F, 0x0B, 0x75, 0x04, 0xF0, 0xE7, 0x72, 0x05, 0xF0, 0xC7, 0x50, 0x7F, 0x90, 0x17, 0x71,
  0x05, 0xF0, 0xE7, 0x50, 0xDF, 0x90, 0x57, 0x71, 0x05, 0xF9, 0x04, 0x73, 0x08, 0xFA, 0x0D, 0x02,
  0x77, 0x05, 0xF9, 0x0C, 0x78, 0x12, 0x6C, 0xFC, 0x82, 0xE8, 0x31, 0x74, 0x05, 0xFA, 0x81, 0xD7,
  0x22, 0xFF, 0xF0, 0x37, 0x20, 0x5F, 0xE0, 0xAF, 0xFF, 0x03, 0x72, 0x05, 0xFE, 0x0A, 0xFF, 0xF0,
  0x37, 0x20, 0x5F, 0xE0, 0xAF, 0xFF, 0x03, 0x72, 0x05, 0xFE, 0x0A,
  // "ò" (U+00F2)
  0x60, 0x38, 0x04, 0x70, 0x47, 0x77, 0x60, 0x5F, 0x90, 0xD7, 0x77, 0x70, 0xBF, 0x90, 0x57, 0x77,
  0x60, 0x10, 0xDF, 0x0C, 0x77, 0x77, 0x03, 0xF9, 0x04, 0x77, 0x77, 0x05, 0xF0, 0xC7, 0x77, 0x71,
  0x07, 0xF0, 0x57, 0x77, 0x71, 0x08, 0xE0, 0xD7, 0x77, 0x72, 0x0A, 0xE0, 0x67, 0x77, 0x72, 0x0A,
  0xD0, 0xE0, 0x17, 0x77, 0x72, 0x0A, 0xD0, 0x97, 0x77, 0x73, 0x0A, 0xD0, 0x37, 0x77, 0x73, 0x09,
  0xC0, 0xC7, 0x77, 0x74, 0x07, 0xC0, 0x67, 0x77, 0x74, 0x05, 0x0E, 0xA0, 0x98, 0x0B, 0x97, 0x08,
  0x93, 0x26, 0x9C, 0xDE, 0xFE, 0xDB, 0x95, 0x17, 0x77, 0x10, 0x60, 0xCF, 0xE0, 0xA0, 0x37, 0x74,
  0x05, 0x0D, 0xFF, 0xB0, 0xA0, 0x17, 0x71, 0x09, 0xFF, 0xE0, 0xE0, 0x37, 0x60, 0xBF, 0xA8, 0x3C,
  0xA9, 0xAC, 0xFA, 0x05, 0x74, 0x0A, 0xF0, 0xE0, 0x66, 0x81, 0x18, 0xEF, 0x03, 0x72, 0x07, 0xF0,
  0xC0, 0x17, 0x20, 0x20, 0xDE, 0x0E, 0x01, 0x70, 0x2F, 0x0D, 0x75, 0x02, 0x0E, 0xE0, 0xB7, 0x0A,
  0xF0, 0x37, 0x60, 0x6F, 0x05, 0x50, 0x2F, 0x0A, 0x77, 0x10, 0xDE, 0x0D, 0x50, 0x9F, 0x04, 0x77,
  0x10, 0x7F, 0x04, 0x40, 0xEE, 0x0E, 0x77, 0x20, 0x1F, 0x0A, 0x30, 0x4F, 0x09, 0x77, 0x30, 0xCF,
  0x30, 0x9F, 0x05, 0x77, 0x30, 0x8F, 0x05, 0x20, 0xCF, 0x02, 0x77, 0x30, 0x5F, 0x09, 0x2F, 0x97,
  0x74, 0x02, 0xF8, 0x1C, 0x03, 0xF0, 0xC7, 0x75, 0xF9, 0x10, 0x5F, 0x0A, 0x77, 0x50, 0xDF, 0x02,
  0x07, 0xF0, 0x97, 0x75, 0x0C, 0xF0, 0x40, 0x9F, 0x08, 0x77, 0x50, 0xBF, 0x06, 0x0A, 0xF0, 0x77,
  0x75, 0x09, 0xF0, 0x70, 0xBF, 0x06, 0x77, 0x50, 0x9F, 0x09, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0,
  0x90, 0xCF, 0x05, 0x77, 0x50, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xDF, 0x05,
  0x77, 0x50, 0x8F, 0x0A, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xCF, 0x05, 0x77, 0x50, 0x8F,
  0x09, 0x0B, 0xF0, 0x67, 0x75, 0x09, 0xF0, 0x80, 0xAF, 0x07, 0x77, 0x50, 0xAF, 0x07, 0x09, 0xF0,
  0x87, 0x75, 0x0B, 0xF0, 0x60, 0x7F, 0x09, 0x77, 0x50, 0xCF, 0x04, 0x05, 0xF0, 0xB7, 0x75, 0x0E,
  0xF0, 0x02, 0xF0, 0xD7, 0x75, 0xF9, 0x20, 0xEF, 0x77, 0x40, 0x3F, 0x0C, 0x20, 0xBF, 0x03, 0x77,
  0x30, 0x5F, 0x09, 0x20, 0x7F, 0x06, 0x77, 0x30, 0x9F, 0x05, 0x20, 0x2F, 0x0A, 0x77, 0x30, 0xDF,
  0x01, 0x30, 0xDE, 0x0E, 0x77, 0x20, 0x2F, 0x0B, 0x40, 0x7F, 0x05, 0x77, 0x10, 0x7F, 0x05, 0x40,
  0x10, 0xEE, 0x0C, 0x77, 0x10, 0xDE, 0x0E, 0x60, 0x7F, 0x05, 0x76, 0x07, 0xF0, 0x67, 0x0D, 0xE0,
  0xE0, 0x17, 0x40, 0x20, 0xEE, 0x0C, 0x71, 0x03, 0xF0, 0xD0, 0x27, 0x20, 0x30, 0xDF, 0x03, 0x72,
  0x06, 0xF8, 0x1E, 0x71, 0x50, 0x10, 0x8F, 0x90, 0x67, 0x40, 0x7F, 0xA8, 0x3C, 0xA9, 0xAC, 0xFA,
  0x07, 0x76, 0x05, 0x0E, 0xFF, 0xE0, 0x67, 0x71, 0x02, 0x0B, 0xFF, 0xB0, 0xC0, 0x27, 0x74, 0x04,
  0x0B, 0xFE, 0x0B, 0x04, 0x77, 0x71, 0x83, 0x16, 0x9C, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x75,
  // "ó" (U+00F3)
  0x77, 0x70, 0x38, 0x04, 0x70, 0x47, 0x77, 0x60, 0xBF, 0x90, 0x87, 0x77, 0x50, 0x2F, 0x90, 0xD0,
  0x17, 0x77, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x50, 0x1F, 0x90, 0x57, 0x77, 0x60, 0x9F, 0x08, 0x77,
  0x76, 0x02, 0xF0, 0xA7, 0x77, 0x70, 0xAE, 0x0B, 0x77, 0x77, 0x04, 0xE0, 0xB7, 0x77, 0x71, 0x0C,
  0xD0, 0xC7, 0x77, 0x71, 0x06, 0xD0, 0xC7, 0x77, 0x71, 0x01, 0x0E, 0xC0, 0xB7, 0x77, 0x72, 0x09,
  0xC0, 0xA7, 0x77, 0x72, 0x03, 0xC0, 0x97, 0x77, 0x73, 0x06, 0xB0, 0x68, 0x0B, 0xA3, 0x08, 0x93,
  0x26, 0x9C, 0xDE, 0xFE, 0xDB, 0x95, 0x17, 0x77, 0x10, 0x60, 0xCF, 0xE0, 0xA0, 0x37, 0x74, 0x05,
  0x0D, 0xFF, 0xB0, 0xA0, 0x17, 0x71, 0x09, 0xFF, 0xE0, 0xE0, 0x37, 0x60, 0xBF, 0xA8, 0x3C, 0xA9,
  0xAC, 0xFA, 0x05, 0x74, 0x0A, 0xF0, 0xE0, 0x66, 0x81, 0x18, 0xEF, 0x03, 0x72, 0x07, 0xF0, 0xC0,
  0x17, 0x20, 0x20, 0xDE, 0x0E, 0x01, 0x70, 0x2F, 0x0D, 0x75, 0x02, 0x0E, 0xE0, 0xB7, 0x0A, 0xF0,
  0x37, 0x60, 0x6F, 0x05, 0x50, 0x2F, 0x0A, 0x77, 0x10, 0xDE, 0x0D, 0x50, 0x9F, 0x04, 0x77, 0x10,
  0x7F, 0x04, 0x40, 0xEE, 0x0E, 0x77, 0x20, 0x1F, 0x0A, 0x30, 0x4F, 0x09, 0x77, 0x30, 0xCF, 0x30,
  0x9F, 0x05, 0x77, 0x30, 0x8F, 0x05, 0x20, 0xCF, 0x02, 0x77, 0x30, 0x5F, 0x09, 0x2F, 0x97, 0x74,
  0x02, 0xF8, 0x1C, 0x03, 0xF0, 0xC7, 0x75, 0xF9, 0x10, 0x5F, 0x0A, 0x77, 0x50, 0xDF, 0x02, 0x07,
  0xF0, 0x97, 0x75, 0x0C, 0xF0, 0x40, 0x9F, 0x08, 0x77, 0x50, 0xBF, 0x06, 0x0A, 0xF0, 0x77, 0x75,
  0x09, 0xF0, 0x70, 0xBF, 0x06, 0x77, 0x50, 0x9F, 0x09, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0x90,
  0xCF, 0x05, 0x77, 0x50, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77,
  0x50, 0x8F, 0x0A, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xCF, 0x05, 0x77, 0x50, 0x8F, 0x09,
  0x0B, 0xF0, 0x67, 0x75, 0x09, 0xF0, 0x80, 0xAF, 0x07, 0x77, 0x50, 0xAF, 0x07, 0x09, 0xF0, 0x87,
  0x75, 0x0B, 0xF0, 0x60, 0x7F, 0x09, 0x77, 0x50, 0xCF, 0x04, 0x05, 0xF0, 0xB7, 0x75, 0x0E, 0xF0,
  0x02, 0xF0, 0xD7, 0x75, 0xF9, 0x20, 0xEF, 0x77, 0x40, 0x3F, 0x0C, 0x20, 0xBF, 0x03, 0x77, 0x30,
  0x5F, 0x09, 0x20, 0x7F, 0x06, 0x77, 0x30, 0x9F, 0x05, 0x20, 0x2F, 0x0A, 0x77, 0x30, 0xDF, 0x01,
  0x30, 0xDE, 0x0E, 0x77, 0x20, 0x2F, 0x0B, 0x40, 0x7F, 0x05, 0x77, 0x10, 0x7F, 0x05, 0x40, 0x10,
  0xEE, 0x0C, 0x77, 0x10, 0xDE, 0x0E, 0x60, 0x7F, 0x05, 0x76, 0x07, 0xF0, 0x67, 0x0D, 0xE0, 0xE0,
  0x17, 0x40, 0x20, 0xEE, 0x0C, 0x71, 0x03, 0xF0, 0xD0, 0x27, 0x20, 0x30, 0xDF, 0x03, 0x72, 0x06,
  0xF8, 0x1E, 0x71, 0x50, 0x10, 0x8F, 0x90, 0x67, 0x40, 0x7F, 0xA8, 0x3C, 0xA9, 0xAC, 0xFA, 0x07,
  0x76, 0x05, 0x0E, 0xFF, 0xE0, 0x67, 0x71, 0x02, 0x0B, 0xFF, 0xB0, 0xC0, 0x27, 0x74, 0x04, 0x0B,
  0xFE, 0x0B, 0x04, 0x77, 0x71, 0x83, 0x16, 0x9C, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x75,
  // "ô" (U+00F4)
  0x77, 0x05, 0x80, 0x37, 0x02, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0xB7, 0x77, 0x60, 0x7F, 0xA0, 0x27,
  0x77, 0x40, 0x10, 0xEF, 0xA0, 0xA7, 0x77, 0x40, 0x8F, 0xC0, 0x37, 0x77, 0x20, 0x2F, 0xD0, 0xC7,
  0x77, 0x20, 0xBD, 0x0C, 0x05, 0xE0, 0x57, 0x77, 0x05, 0xD8, 0x2E, 0x20, 0x7D, 0x0E, 0x01, 0x77,
  0x60, 0xDD, 0x05, 0x30, 0xAD, 0x09, 0x77, 0x50, 0x8D, 0x06, 0x50, 0xBD, 0x03, 0x77, 0x30, 0x3D,
  0x08, 0x70, 0xCC, 0x0C, 0x77, 0x30, 0xCC, 0x08, 0x71, 0x01, 0x0C, 0xC0, 0x77, 0x71, 0x07, 0xC0,
  0x87, 0x30, 0x10, 0xCC, 0x02, 0x76, 0x02, 0xC0, 0x87, 0x50, 0x10, 0xCB, 0x0C, 0x76, 0x06, 0xB0,
  0x87, 0x70, 0x10, 0xCB, 0x01, 0x80, 0xB8, 0x70, 0x89, 0x32, 0x69, 0xCD, 0xEF, 0xED, 0xB9, 0x51,
  0x77, 0x71, 0x06, 0x0C, 0xFE, 0x0A, 0x03, 0x77, 0x40, 0x50, 0xDF, 0xFB, 0x0A, 0x01, 0x77, 0x10,
  0x9F, 0xFE, 0x0E, 0x03, 0x76, 0x0B, 0xFA, 0x83, 0xCA, 0x9A, 0xCF, 0xA0, 0x57, 0x40, 0xAF, 0x0E,
  0x06, 0x68, 0x11, 0x8E, 0xF0, 0x37, 0x20, 0x7F, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xE0, 0xE0, 0x17,
  0x02, 0xF0, 0xD7, 0x50, 0x20, 0xEE, 0x0B, 0x70, 0xAF, 0x03, 0x76, 0x06, 0xF0, 0x55, 0x02, 0xF0,
  0xA7, 0x71, 0x0D, 0xE0, 0xD5, 0x09, 0xF0, 0x47, 0x71, 0x07, 0xF0, 0x44, 0x0E, 0xE0, 0xE7, 0x72,
  0x01, 0xF0, 0xA3, 0x04, 0xF0, 0x97, 0x73, 0x0C, 0xF3, 0x09, 0xF0, 0x57, 0x73, 0x08, 0xF0, 0x52,
  0x0C, 0xF0, 0x27, 0x73, 0x05, 0xF0, 0x92, 0xF9, 0x77, 0x40, 0x2F, 0x81, 0xC0, 0x3F, 0x0C, 0x77,
  0x5F, 0x91, 0x05, 0xF0, 0xA7, 0x75, 0x0D, 0xF0, 0x20, 0x7F, 0x09, 0x77, 0x50, 0xCF, 0x04, 0x09,
  0xF0, 0x87, 0x75, 0x0B, 0xF0, 0x60, 0xAF, 0x07, 0x77, 0x50, 0x9F, 0x07, 0x0B, 0xF0, 0x67, 0x75,
  0x09, 0xF0, 0x90, 0xCF, 0x05, 0x77, 0x50, 0x8F, 0x09, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0,
  0xDF, 0x05, 0x77, 0x50, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xCF, 0x05, 0x77,
  0x50, 0x8F, 0x0A, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0x90, 0xBF, 0x06, 0x77, 0x50, 0x9F, 0x08,
  0x0A, 0xF0, 0x77, 0x75, 0x0A, 0xF0, 0x70, 0x9F, 0x08, 0x77, 0x50, 0xBF, 0x06, 0x07, 0xF0, 0x97,
  0x75, 0x0C, 0xF0, 0x40, 0x5F, 0x0B, 0x77, 0x50, 0xEF, 0x00, 0x2F, 0x0D, 0x77, 0x5F, 0x92, 0x0E,
  0xF7, 0x74, 0x03, 0xF0, 0xC2, 0x0B, 0xF0, 0x37, 0x73, 0x05, 0xF0, 0x92, 0x07, 0xF0, 0x67, 0x73,
  0x09, 0xF0, 0x52, 0x02, 0xF0, 0xA7, 0x73, 0x0D, 0xF0, 0x13, 0x0D, 0xE0, 0xE7, 0x72, 0x02, 0xF0,
  0xB4, 0x07, 0xF0, 0x57, 0x71, 0x07, 0xF0, 0x54, 0x01, 0x0E, 0xE0, 0xC7, 0x71, 0x0D, 0xE0, 0xE6,
  0x07, 0xF0, 0x57, 0x60, 0x7F, 0x06, 0x70, 0xDE, 0x0E, 0x01, 0x74, 0x02, 0x0E, 0xE0, 0xC7, 0x10,
  0x3F, 0x0D, 0x02, 0x72, 0x03, 0x0D, 0xF0, 0x37, 0x20, 0x6F, 0x81, 0xE7, 0x15, 0x01, 0x08, 0xF9,
  0x06, 0x74, 0x07, 0xFA, 0x83, 0xCA, 0x9A, 0xCF, 0xA0, 0x77, 0x60, 0x50, 0xEF, 0xFE, 0x06, 0x77,
  0x10, 0x20, 0xBF, 0xFB, 0x0C, 0x02, 0x77, 0x40, 0x40, 0xBF, 0xE0, 0xB0, 0x47, 0x77, 0x18, 0x31,
  0x69, 0xCE, 0xA8, 0x4E, 0xDB, 0x95, 0x17, 0x50,
  // "õ" (U+00F5)
  0x72, 0x86, 0x29, 0xDE, 0xED, 0x94, 0x75, 0x0F, 0x30, 0x27, 0x50, 0x7F, 0x90, 0xC0, 0x47, 0x20,
  0x5B, 0x07, 0x74, 0x07, 0xFC, 0x0A, 0x01, 0x70, 0x9B, 0x05, 0x73, 0x04, 0xFE, 0x0E, 0x05, 0x50,
  0x2C, 0x02, 0x73, 0x0D, 0xFF, 0x98, 0x4B, 0x41, 0x04, 0xDB, 0x0D, 0x73, 0x05, 0xB8, 0x4E, 0x61,
  0x14, 0xCF, 0xFA, 0x07, 0x73, 0x0A, 0xB0, 0x65, 0x07, 0xFF, 0x0E, 0x01, 0x73, 0x0E, 0xA0, 0xE7,
  0x03, 0x0E, 0xFD, 0x07, 0x73, 0x02, 0xB0, 0xA7, 0x10, 0x10, 0xBF, 0xB0, 0xB7, 0x40, 0x4B, 0x07,
  0x73, 0x07, 0x0E, 0xF0, 0xA0, 0x17, 0x50, 0xF1, 0x75, 0x86, 0x17, 0xCE, 0xFD, 0xA4, 0x80, 0xB9,
  0x20, 0x89, 0x32, 0x69, 0xCD, 0xEF, 0xED, 0xB9, 0x51, 0x77, 0x71, 0x06, 0x0C, 0xFE, 0x0A, 0x03,
  0x77, 0x40, 0x50, 0xDF, 0xFB, 0x0A, 0x01, 0x77, 0x10, 0x9F, 0xFE, 0x0E, 0x03, 0x76, 0x0B, 0xFA,
  0x83, 0xCA, 0x9A, 0xCF, 0xA0, 0x57, 0x40, 0xAF, 0x0E, 0x06, 0x68, 0x11, 0x8E, 0xF0, 0x37, 0x20,
  0x7F, 0x0C, 0x01, 0x72, 0x02, 0x0D, 0xE0, 0xE0, 0x17, 0x02, 0xF0, 0xD7, 0x50, 0x20, 0xEE, 0x0B,
  0x70, 0xAF, 0x03, 0x76, 0x06, 0xF0, 0x55, 0x02, 0xF0, 0xA7, 0x71, 0x0D, 0xE0, 0xD5, 0x09, 0xF0,
  0x47, 0x71, 0x07, 0xF0, 0x44, 0x0E, 0xE0, 0xE7, 0x72, 0x01, 0xF0, 0xA3, 0x04, 0xF0, 0x97, 0x73,
  0x0C, 0xF3, 0x09, 0xF0, 0x57, 0x73, 0x08, 0xF0, 0x52, 0x0C, 0xF0, 0x27, 0x73, 0x05, 0xF0, 0x92,
  0xF9, 0x77, 0x40, 0x2F, 0x81, 0xC0, 0x3F, 0x0C, 0x77, 0x5F, 0x91, 0x05, 0xF0, 0xA7, 0x75, 0x0D,
  0xF0, 0x20, 0x7F, 0x09, 0x77, 0x50, 0xCF, 0x04, 0x09, 0xF0, 0x87, 0x75, 0x0B, 0xF0, 0x60, 0xAF,
  0x07, 0x77, 0x50, 0x9F, 0x07, 0x0B, 0xF0, 0x67, 0x75, 0x09, 0xF0, 0x90, 0xCF, 0x05, 0x77, 0x50,
  0x8F, 0x09, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77, 0x50, 0x8F, 0x0A, 0x0D,
  0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xCF, 0x05, 0x77, 0x50, 0x8F, 0x0A, 0x0C, 0xF0, 0x57, 0x75,
  0x08, 0xF0, 0x90, 0xBF, 0x06, 0x77, 0x50, 0x9F, 0x08, 0x0A, 0xF0, 0x77, 0x75, 0x0A, 0xF0, 0x70,
  0x9F, 0x08, 0x77, 0x50, 0xBF, 0x06, 0x07, 0xF0, 0x97, 0x75, 0x0C, 0xF0, 0x40, 0x5F, 0x0B, 0x77,
  0x50, 0xEF, 0x00, 0x2F, 0x0D, 0x77, 0x5F, 0x92, 0x0E, 0xF7, 0x74, 0x03, 0xF0, 0xC2, 0x0B, 0xF0,
  0x37, 0x73, 0x05, 0xF0, 0x92, 0x07, 0xF0, 0x67, 0x73, 0x09, 0xF0, 0x52, 0x02, 0xF0, 0xA7, 0x73,
  0x0D, 0xF0, 0x13, 0x0D, 0xE0, 0xE7, 0x72, 0x02, 0xF0, 0xB4, 0x07, 0xF0, 0x57, 0x71, 0x07, 0xF0,
  0x54, 0x01, 0x0E, 0xE0, 0xC7, 0x71, 0x0D, 0xE0, 0xE6, 0x07, 0xF0, 0x57, 0x60, 0x7F, 0x06, 0x70,
  0xDE, 0x0E, 0x01, 0x74, 0x02, 0x0E, 0xE0, 0xC7, 0x10, 0x3F, 0x0D, 0x02, 0x72, 0x03, 0x0D, 0xF0,
  0x37, 0x20, 0x6F, 0x81, 0xE7, 0x15, 0x01, 0x08, 0xF9, 0x06, 0x74, 0x07, 0xFA, 0x83, 0xCA, 0x9A,
  0xCF, 0xA0, 0x77, 0x60, 0x50, 0xEF, 0xFE, 0x06, 0x77, 0x10, 0x20, 0xBF, 0xFB, 0x0C, 0x02, 0x77,
  0x40, 0x40, 0xBF, 0xE0, 0xB0, 0x47, 0x77, 0x18, 0x31, 0x69, 0xCE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  0x50,
  // "ö" (U+00F6)
  0x71, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC4, 0x77, 0x20, 0x10, 0xED, 0x03, 0x70,
  0xDD, 0x05, 0x77, 0x10, 0x8E, 0x0B, 0x60, 0x6E, 0x0D, 0x77, 0x10, 0xCF, 0x60, 0xAF, 0x02, 0x77,
  0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47, 0x70, 0xEF, 0x02, 0x50, 0xBF, 0x04, 0x77, 0x0C, 0xF6, 0x0A,
  0xF0, 0x27, 0x70, 0x9E, 0x0C, 0x60, 0x7E, 0x0E, 0x77, 0x10, 0x20, 0xED, 0x04, 0x60, 0x10, 0xDD,
  0x06, 0x77, 0x28, 0x42, 0xAE, 0xEB, 0x37, 0x18, 0x41, 0x9E, 0xFC, 0x58, 0x0C, 0xF1, 0x08, 0x93,
  0x26, 0x9C, 0xDE, 0xFE, 0xDB, 0x95, 0x17, 0x77, 0x10, 0x60, 0xCF, 0xE0, 0xA0, 0x37, 0x74, 0x05,
  0x0D, 0xFF, 0xB0, 0xA0, 0x17, 0x71, 0x09, 0xFF, 0xE0, 0xE0, 0x37, 0x60, 0xBF, 0xA8, 0x3C, 0xA9,
  0xAC, 0xFA, 0x05, 0x74, 0x0A, 0xF0, 0xE0, 0x66, 0x81, 0x18, 0xEF, 0x03, 0x72, 0x07, 0xF0, 0xC0,
  0x17, 0x20, 0x20, 0xDE, 0x0E, 0x01, 0x70, 0x2F, 0x0D, 0x75, 0x02, 0x0E, 0xE0, 0xB7, 0x0A, 0xF0,
  0x37, 0x60, 0x6F, 0x05, 0x50, 0x2F, 0x0A, 0x77, 0x10, 0xDE, 0x0D, 0x50, 0x9F, 0x04, 0x77, 0x10,
  0x7F, 0x04, 0x40, 0xEE, 0x0E, 0x77, 0x20, 0x1F, 0x0A, 0x30, 0x4F, 0x09, 0x77, 0x30, 0xCF, 0x30,
  0x9F, 0x05, 0x77, 0x30, 0x8F, 0x05, 0x20, 0xCF, 0x02, 0x77, 0x30, 0x5F, 0x09, 0x2F, 0x97, 0x74,
  0x02, 0xF8, 0x1C, 0x03, 0xF0, 0xC7, 0x75, 0xF9, 0x10, 0x5F, 0x0A, 0x77, 0x50, 0xDF, 0x02, 0x07,
  0xF0, 0x97, 0x75, 0x0C, 0xF0, 0x40, 0x9F, 0x08, 0x77, 0x50, 0xBF, 0x06, 0x0A, 0xF0, 0x77, 0x75,
  0x09, 0xF0, 0x70, 0xBF, 0x06, 0x77, 0x50, 0x9F, 0x09, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0x90,
  0xCF, 0x05, 0x77, 0x50, 0x8F, 0x0A, 0x0D, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x77,
  0x50, 0x8F, 0x0A, 0x0C, 0xF0, 0x57, 0x75, 0x08, 0xF0, 0xA0, 0xCF, 0x05, 0x77, 0x50, 0x8F, 0x09,
  0x0B, 0xF0, 0x67, 0x75, 0x09, 0xF0, 0x80, 0xAF, 0x07, 0x77, 0x50, 0xAF, 0x07, 0x09, 0xF0, 0x87,
  0x75, 0x0B, 0xF0, 0x60, 0x7F, 0x09, 0x77, 0x50, 0xCF, 0x04, 0x05, 0xF0, 0xB7, 0x75, 0x0E, 0xF0,
  0x02, 0xF0, 0xD7, 0x75, 0xF9, 0x20, 0xEF, 0x77, 0x40, 0x3F, 0x0C, 0x20, 0xBF, 0x03, 0x77, 0x30,
  0x5F, 0x09, 0x20, 0x7F, 0x06, 0x77, 0x30, 0x9F, 0x05, 0x20, 0x2F, 0x0A, 0x77, 0x30, 0xDF, 0x01,
  0x30, 0xDE, 0x0E, 0x77, 0x20, 0x2F, 0x0B, 0x40, 0x7F, 0x05, 0x77, 0x10, 0x7F, 0x05, 0x40, 0x10,
  0xEE, 0x0C, 0x77, 0x10, 0xDE, 0x0E, 0x60, 0x7F, 0x05, 0x76, 0x07, 0xF0, 0x67, 0x0D, 0xE0, 0xE0,
  0x17, 0x40, 0x20, 0xEE, 0x0C, 0x71, 0x03, 0xF0, 0xD0, 0x27, 0x20, 0x30, 0xDF, 0x03, 0x72, 0x06,
  0xF8, 0x1E, 0x71, 0x50, 0x10, 0x8F, 0x90, 0x67, 0x40, 0x7F, 0xA8, 0x3C, 0xA9, 0xAC, 0xFA, 0x07,
  0x76, 0x05, 0x0E, 0xFF, 0xE0, 0x67, 0x71, 0x02, 0x0B, 0xFF, 0xB0, 0xC0, 0x27, 0x74, 0x04, 0x0B,
  0xFE, 0x0B, 0x04, 0x77, 0x71, 0x83, 0x16, 0x9C, 0xEA, 0x84, 0xED, 0xB9, 0x51, 0x75,
  // "÷" (U+00F7)
  0x77, 0x84, 0x4B, 0xEE, 0xB3, 0x77, 0x76, 0x05, 0xE0, 0x37, 0x77, 0x50, 0xCE, 0x0B, 0x77, 0x75,
  0xF9, 0x77, 0x74, 0x02, 0xF9, 0x01, 0x77, 0x73, 0x02, 0xF9, 0x01, 0x77, 0x74, 0xF9, 0x77, 0x75,
  0x0C, 0xE0, 0xB7, 0x77, 0x50, 0x4E, 0x03, 0x77, 0x76, 0x84, 0x4B, 0xEE, 0xB3, 0x80, 0xDB, 0x60,
  0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF, 0xFC, 0x06, 0x07, 0xFF, 0xFF, 0xC0, 0x60, 0x7F, 0xFF,
  0xFC, 0x06, 0x04, 0x80, 0xB4, 0x90, 0x48, 0x0C, 0xF4, 0x08, 0x44, 0xBE, 0xEB, 0x37, 0x77, 0x60,
  0x5E, 0x03, 0x77, 0x75, 0x0C, 0xE0, 0xB7, 0x77, 0x5F, 0x97, 0x77, 0x40, 0x2F, 0x90, 0x17, 0x77,
  0x30, 0x2F, 0x90, 0x17, 0x77, 0x4F, 0x97, 0x77, 0x50, 0xCE, 0x0B, 0x77, 0x75, 0x04, 0xE0, 0x37,
  0x77, 0x68, 0x44, 0xBE, 0xEB, 0x37, 0x70,
  // "ø" (U+00F8)
  0x77, 0x77, 0x28, 0x41, 0x77, 0x77, 0x37, 0x77, 0x73, 0x09, 0xB0, 0xE0, 0x17, 0x77, 0x72, 0x02,
  0xC0, 0x77, 0x78, 0x92, 0x26, 0x9C, 0xDE, 0xFE, 0xDB, 0x85, 0x50, 0xAB, 0x0E, 0x76, 0x06, 0x0C,
  0xFD, 0x83, 0xE9, 0x10, 0x3C, 0x07, 0x74, 0x05, 0x0D, 0xFF, 0xA8, 0x1E, 0x7B, 0xB0, 0xE7, 0x40,
  0x9F, 0xFF, 0xB0, 0x67, 0x30, 0xBF, 0xA8, 0x3C, 0xA9, 0xAC, 0xFB, 0x0D, 0x73, 0x0A, 0xF0, 0xE0,
  0x66, 0x02, 0x08, 0xF9, 0x06, 0x72, 0x07, 0xF0, 0xC0, 0x17, 0x20, 0x30, 0xEE, 0x0C, 0x71, 0x02,
  0xF0, 0xD7, 0x50, 0x3F, 0x08, 0x70, 0xAF, 0x03, 0x75, 0x02, 0xF9, 0x02, 0x50, 0x3F, 0x0A, 0x76,
  0x0A, 0xF9, 0x0A, 0x50, 0x9F, 0x04, 0x75, 0x02, 0xFB, 0x02, 0x40, 0xEE, 0x0E, 0x76, 0x0A, 0xFB,
  0x08, 0x30, 0x4F, 0x09, 0x75, 0x02, 0xB0, 0xE0, 0xDE, 0x0D, 0x30, 0x9F, 0x05, 0x75, 0x0A, 0xB0,
  0x80, 0x9F, 0x03, 0x20, 0xDF, 0x02, 0x74, 0x02, 0xB8, 0x1E, 0x15, 0xF0, 0x72, 0xF9, 0x75, 0x0A,
  0xB8, 0x18, 0x03, 0xF8, 0x1B, 0x03, 0xF0, 0xC7, 0x40, 0x2B, 0x82, 0xE1, 0x01, 0xF8, 0x1E, 0x05,
  0xF0, 0xB7, 0x40, 0xAB, 0x08, 0x30, 0xEF, 0x01, 0x07, 0xF0, 0x97, 0x30, 0x2B, 0x0E, 0x01, 0x30,
  0xCF, 0x04, 0x09, 0xF0, 0x87, 0x30, 0xAB, 0x07, 0x40, 0xBF, 0x06, 0x0A, 0xF0, 0x77, 0x20, 0x2B,
  0x0E, 0x01, 0x40, 0xAF, 0x07, 0x0B, 0xF0, 0x67, 0x20, 0xAB, 0x07, 0x50, 0x9F, 0x08, 0x0C, 0xF0,
  0x57, 0x10, 0x2B, 0x0E, 0x01, 0x50, 0x9F, 0x09, 0x0C, 0xF0, 0x57, 0x10, 0xAB, 0x07, 0x60, 0x8F,
  0x0A, 0x0D, 0xF0, 0x57, 0x02, 0xB0, 0xE0, 0x16, 0x08, 0xF0, 0xA0, 0xDF, 0x05, 0x70, 0xAB, 0x07,
  0x70, 0x8F, 0x0A, 0x0C, 0xF0, 0x56, 0x02, 0xB0, 0xE7, 0x10, 0x8F, 0x0A, 0x0C, 0xF0, 0x56, 0x0A,
  0xB0, 0x77, 0x10, 0x8F, 0x09, 0x0B, 0xF0, 0x65, 0x02, 0xB0, 0xE7, 0x20, 0x9F, 0x08, 0x0A, 0xF0,
  0x75, 0x0A, 0xB0, 0x77, 0x20, 0xAF, 0x07, 0x08, 0xF0, 0x84, 0x02, 0xB0, 0xE7, 0x30, 0xBF, 0x00,
  0x6F, 0x09, 0x40, 0xAB, 0x07, 0x73, 0x0C, 0xF0, 0x04, 0xF0, 0xA3, 0x02, 0xB0, 0xE7, 0x40, 0xEF,
  0x02, 0x01, 0xF0, 0xD3, 0x0A, 0xB0, 0x77, 0x4F, 0x92, 0x0E, 0xF2, 0x02, 0xB0, 0xE7, 0x40, 0x3F,
  0x0C, 0x20, 0xAF, 0x81, 0x20, 0xAB, 0x07, 0x74, 0x05, 0xF0, 0x92, 0x06, 0xF0, 0x50, 0x2B, 0x0E,
  0x75, 0x09, 0xF0, 0x52, 0x01, 0xF0, 0x90, 0xAB, 0x07, 0x75, 0x0D, 0xF0, 0x13, 0x0B, 0xE0, 0xEB,
  0x0E, 0x75, 0x02, 0xF0, 0xB4, 0x04, 0xFB, 0x07, 0x75, 0x07, 0xF0, 0x55, 0x0D, 0xF9, 0x0E, 0x76,
  0x0D, 0xE0, 0xE6, 0x04, 0xF9, 0x07, 0x75, 0x06, 0xF0, 0x67, 0x0A, 0xF0, 0x17, 0x40, 0x20, 0xEE,
  0x0D, 0x71, 0x01, 0x0D, 0xE0, 0xC0, 0x17, 0x20, 0x30, 0xDF, 0x03, 0x72, 0x05, 0xF8, 0x1E, 0x61,
  0x50, 0x10, 0x8F, 0x90, 0x67, 0x30, 0xAF, 0xB8, 0x3C, 0xA9, 0xAC, 0xFA, 0x07, 0x73, 0x03, 0xFF,
  0xFB, 0x06, 0x74, 0x0A, 0xC0, 0x9F, 0xFB, 0x0C, 0x02, 0x74, 0x03, 0xC8, 0x28, 0x02, 0xAF, 0xE0,
  0xB0, 0x47, 0x60, 0xBB, 0x0E, 0x01, 0x38, 0x93, 0x15, 0x9C, 0xDE, 0xFE, 0xDB, 0x95, 0x17, 0x70,
  0x3C, 0x07, 0x77, 0x77, 0x30, 0xBB, 0x0E, 0x77, 0x77, 0x48, 0x00, 0x70, 0x47, 0x77, 0x72,
  // "ù" (U+00F9)
  0x73, 0x03, 0x80, 0x47, 0x04, 0x80, 0xC1, 0x00, 0x5F, 0x90, 0xD8, 0x0C, 0x20, 0x0B, 0xF9, 0x05,
  0x80, 0xC1, 0x00, 0x10, 0xDF, 0x0C, 0x80, 0xC2, 0x00, 0x3F, 0x90, 0x48, 0x0C, 0x20, 0x05, 0xF0,
  0xC8, 0x0C, 0x30, 0x07, 0xF0, 0x58, 0x0C, 0x30, 0x08, 0xE0, 0xD8, 0x0C, 0x40, 0x0A, 0xE0, 0x68,
  0x0C, 0x40, 0x0A, 0xD0, 0xE0, 0x18, 0x0C, 0x40, 0x0A, 0xD0, 0x98, 0x0C, 0x50, 0x0A, 0xD0, 0x38,
  0x0C, 0x50, 0x09, 0xC0, 0xC8, 0x0C, 0x60, 0x07, 0xC0, 0x68, 0x0C, 0x60, 0x05, 0x0E, 0xA0, 0x98,
  0x0C, 0xD2, 0x00, 0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7, 0x04, 0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x70,
  0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7, 0x04, 0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x72, 0x81, 0x15, 0xAF,
  0xB7, 0x58, 0x12, 0x5B, 0xFA, 0x0E, 0x75, 0x04, 0xFA, 0x77, 0x10, 0x6F, 0x90, 0xE7, 0x60, 0x9F,
  0x97, 0x72, 0x0B, 0xF0, 0xE7, 0x60, 0x4F, 0x97, 0x72, 0x06, 0xF0, 0xE7, 0x60, 0x1F, 0x97, 0x72,
  0x03, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F,
  0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0,
  0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72,
  0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F,
  0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0,
  0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72,
  0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F,
  0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x01, 0xF0,
  0xE7, 0x7F, 0x97, 0x72, 0x02, 0xF0, 0xE7, 0x7F, 0x97, 0x72, 0x03, 0xF0, 0xE7, 0x7F, 0x90, 0x17,
  0x71, 0x04, 0xF0, 0xE7, 0x70, 0xEF, 0x01, 0x77, 0x10, 0x7F, 0x0E, 0x77, 0x0D, 0xF0, 0x37, 0x71,
  0x09, 0xF0, 0xE7, 0x70, 0xCF, 0x05, 0x77, 0x10, 0xDF, 0x0E, 0x77, 0x0A, 0xF0, 0x87, 0x70, 0x2F,
  0x90, 0xE7, 0x70, 0x8F, 0x0B, 0x77, 0x08, 0xF9, 0x0E, 0x77, 0x05, 0xF9, 0x01, 0x76, 0x0E, 0xFA,
  0x77, 0x02, 0xF9, 0x07, 0x75, 0x08, 0xFB, 0x77, 0x10, 0xDF, 0x0E, 0x02, 0x73, 0x04, 0xB0, 0xAF,
  0x03, 0x77, 0x08, 0xF9, 0x0C, 0x02, 0x71, 0x06, 0xB0, 0x80, 0x5F, 0x08, 0x77, 0x02, 0xFA, 0x87,
  0xE9, 0x41, 0x01, 0x26, 0xCB, 0x81, 0xE1, 0x3F, 0x90, 0x47, 0x70, 0x9F, 0xFE, 0x81, 0x60, 0x1F,
  0xA8, 0x1A, 0x51, 0x74, 0x01, 0x0E, 0xFF, 0xC0, 0xB3, 0x0E, 0xFD, 0x06, 0x73, 0x03, 0x0E, 0xFF,
  0xA0, 0xC4, 0x0C, 0xFD, 0x06, 0x74, 0x03, 0x0D, 0xFF, 0x0B, 0x01, 0x40, 0xAF, 0xD0, 0x67, 0x50,
  0x10, 0x8F, 0xC0, 0xD0, 0x56, 0x07, 0xFD, 0x06, 0x77, 0x83, 0x16, 0xAC, 0xEA, 0x82, 0xEB, 0x83,
  0x77, 0x71,
  // "ú" (U+00FA)
  0x77, 0x74, 0x03, 0x80, 0x47, 0x04, 0x80, 0xC1, 0x00, 0xBF, 0x90, 0x88, 0x0C, 0x00, 0x02, 0xF9,
  0x0D, 0x01, 0x80, 0xC0, 0x00, 0x9F, 0x90, 0x38, 0x0C, 0x00, 0x01, 0xF9, 0x05, 0x80, 0xC1, 0x00,
  0x9F, 0x08, 0x80, 0xC1, 0x00, 0x2F, 0x0A, 0x80, 0xC2, 0x00, 0xAE, 0x0B, 0x80, 0xC2, 0x00, 0x4E,
  0x0B, 0x80, 0xC3, 0x00, 0xCD, 0x0C, 0x80, 0xC3, 0x00, 0x6D, 0x0C, 0x80, 0xC3, 0x00, 0x10, 0xEC,
  0x0B, 0x80, 0xC4, 0x00, 0x9C, 0x0A, 0x80, 0xC4, 0x00, 0x3C, 0x09, 0x80, 0xC5, 0x00, 0x6B, 0x06,
  0x80, 0xCD, 0x60, 0x04, 0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x70, 0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7,
  0x04, 0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x70, 0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7, 0x28, 0x11, 0x5A,
  0xFB, 0x75, 0x81, 0x25, 0xBF, 0xA0, 0xE7, 0x50, 0x4F, 0xA7, 0x71, 0x06, 0xF9, 0x0E, 0x76, 0x09,
  0xF9, 0x77, 0x20, 0xBF, 0x0E, 0x76, 0x04, 0xF9, 0x77, 0x20, 0x6F, 0x0E, 0x76, 0x01, 0xF9, 0x77,
  0x20, 0x3F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77,
  0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F,
  0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77,
  0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77,
  0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F,
  0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77,
  0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77,
  0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F,
  0x0E, 0x77, 0xF9, 0x77, 0x20, 0x2F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x3F, 0x0E, 0x77, 0xF9, 0x01,
  0x77, 0x10, 0x4F, 0x0E, 0x77, 0x0E, 0xF0, 0x17, 0x71, 0x07, 0xF0, 0xE7, 0x70, 0xDF, 0x03, 0x77,
  0x10, 0x9F, 0x0E, 0x77, 0x0C, 0xF0, 0x57, 0x71, 0x0D, 0xF0, 0xE7, 0x70, 0xAF, 0x08, 0x77, 0x02,
  0xF9, 0x0E, 0x77, 0x08, 0xF0, 0xB7, 0x70, 0x8F, 0x90, 0xE7, 0x70, 0x5F, 0x90, 0x17, 0x60, 0xEF,
  0xA7, 0x70, 0x2F, 0x90, 0x77, 0x50, 0x8F, 0xB7, 0x71, 0x0D, 0xF0, 0xE0, 0x27, 0x30, 0x4B, 0x0A,
  0xF0, 0x37, 0x70, 0x8F, 0x90, 0xC0, 0x27, 0x10, 0x6B, 0x08, 0x05, 0xF0, 0x87, 0x70, 0x2F, 0xA8,
  0x7E, 0x94, 0x10, 0x12, 0x6C, 0xB8, 0x1E, 0x13, 0xF9, 0x04, 0x77, 0x09, 0xFF, 0xE8, 0x16, 0x01,
  0xFA, 0x81, 0xA5, 0x17, 0x40, 0x10, 0xEF, 0xFC, 0x0B, 0x30, 0xEF, 0xD0, 0x67, 0x30, 0x30, 0xEF,
  0xFA, 0x0C, 0x40, 0xCF, 0xD0, 0x67, 0x40, 0x30, 0xDF, 0xF0, 0xB0, 0x14, 0x0A, 0xFD, 0x06, 0x75,
  0x01, 0x08, 0xFC, 0x0D, 0x05, 0x60, 0x7F, 0xD0, 0x67, 0x78, 0x31, 0x6A, 0xCE, 0xA8, 0x2E, 0xB8,
  0x37, 0x77, 0x10,
  // "û" (U+00FB)
  0x77, 0x50, 0x58, 0x03, 0x70, 0x28, 0x0C, 0x10, 0x01, 0x0E, 0xF0, 0xB8, 0x0C, 0x10, 0x07, 0xFA,
  0x02, 0x77, 0x77, 0x70, 0x10, 0xEF, 0xA0, 0xA7, 0x77, 0x77, 0x08, 0xFC, 0x03, 0x77, 0x77, 0x50,
  0x2F, 0xD0, 0xC7, 0x77, 0x75, 0x0B, 0xD0, 0xC0, 0x5E, 0x05, 0x77, 0x77, 0x30, 0x5D, 0x82, 0xE2,
  0x07, 0xD0, 0xE0, 0x17, 0x77, 0x72, 0x0D, 0xD0, 0x53, 0x0A, 0xD0, 0x97, 0x77, 0x71, 0x08, 0xD0,
  0x65, 0x0B, 0xD0, 0x37, 0x77, 0x60, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x77, 0x76, 0x0C, 0xC0, 0x87,
  0x10, 0x10, 0xCC, 0x07, 0x77, 0x74, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x02, 0x77, 0x72, 0x02,
  0xC0, 0x87, 0x50, 0x10, 0xCB, 0x0C, 0x77, 0x72, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB, 0x01, 0x80,
  0xCC, 0x10, 0x04, 0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x70, 0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7, 0x04,
  0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x70, 0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7, 0x28, 0x11, 0x5A, 0xFB,
  0x75, 0x81, 0x25, 0xBF, 0xA0, 0xE7, 0x50, 0x4F, 0xA7, 0x71, 0x06, 0xF9, 0x0E, 0x76, 0x09, 0xF9,
  0x77, 0x20, 0xBF, 0x0E, 0x76, 0x04, 0xF9, 0x77, 0x20, 0x6F, 0x0E, 0x76, 0x01, 0xF9, 0x77, 0x20,
  0x3F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9,
  0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E,
  0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20,
  0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9,
  0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E,
  0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20,
  0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9,
  0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E,
  0x77, 0xF9, 0x77, 0x20, 0x2F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x3F, 0x0E, 0x77, 0xF9, 0x01, 0x77,
  0x10, 0x4F, 0x0E, 0x77, 0x0E, 0xF0, 0x17, 0x71, 0x07, 0xF0, 0xE7, 0x70, 0xDF, 0x03, 0x77, 0x10,
  0x9F, 0x0E, 0x77, 0x0C, 0xF0, 0x57, 0x71, 0x0D, 0xF0, 0xE7, 0x70, 0xAF, 0x08, 0x77, 0x02, 0xF9,
  0x0E, 0x77, 0x08, 0xF0, 0xB7, 0x70, 0x8F, 0x90, 0xE7, 0x70, 0x5F, 0x90, 0x17, 0x60, 0xEF, 0xA7,
  0x70, 0x2F, 0x90, 0x77, 0x50, 0x8F, 0xB7, 0x71, 0x0D, 0xF0, 0xE0, 0x27, 0x30, 0x4B, 0x0A, 0xF0,
  0x37, 0x70, 0x8F, 0x90, 0xC0, 0x27, 0x10, 0x6B, 0x08, 0x05, 0xF0, 0x87, 0x70, 0x2F, 0xA8, 0x7E,
  0x94, 0x10, 0x12, 0x6C, 0xB8, 0x1E, 0x13, 0xF9, 0x04, 0x77, 0x09, 0xFF, 0xE8, 0x16, 0x01, 0xFA,
  0x81, 0xA5, 0x17, 0x40, 0x10, 0xEF, 0xFC, 0x0B, 0x30, 0xEF, 0xD0, 0x67, 0x30, 0x30, 0xEF, 0xFA,
  0x0C, 0x40, 0xCF, 0xD0, 0x67, 0x40, 0x30, 0xDF, 0xF0, 0xB0, 0x14, 0x0A, 0xFD, 0x06, 0x75, 0x01,
  0x08, 0xFC, 0x0D, 0x05, 0x60, 0x7F, 0xD0, 0x67, 0x78, 0x31, 0x6A, 0xCE, 0xA8, 0x2E, 0xB8, 0x37,
  0x77, 0x10,
  // "ü" (U+00FC)
  0x76, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC4, 0x77, 0x75, 0x01, 0x0E, 0xD0, 0x37,
  0x0D, 0xD0, 0x57, 0x77, 0x40, 0x8E, 0x0B, 0x60, 0x6E, 0x0D, 0x77, 0x74, 0x0C, 0xF6, 0x0A, 0xF0,
  0x27, 0x77, 0x30, 0xEF, 0x02, 0x50, 0xBF, 0x04, 0x77, 0x73, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47,
  0x77, 0x30, 0xCF, 0x60, 0xAF, 0x02, 0x77, 0x73, 0x09, 0xE0, 0xC6, 0x07, 0xE0, 0xE7, 0x77, 0x40,
  0x20, 0xED, 0x04, 0x60, 0x10, 0xDD, 0x06, 0x77, 0x75, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19,
  0xEF, 0xC5, 0x80, 0xEE, 0x10, 0x04, 0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x70, 0x4F, 0xF7, 0x30, 0x4F,
  0xE0, 0xE7, 0x04, 0xFF, 0x73, 0x04, 0xFE, 0x0E, 0x70, 0x4F, 0xF7, 0x30, 0x4F, 0xE0, 0xE7, 0x28,
  0x11, 0x5A, 0xFB, 0x75, 0x81, 0x25, 0xBF, 0xA0, 0xE7, 0x50, 0x4F, 0xA7, 0x71, 0x06, 0xF9, 0x0E,
  0x76, 0x09, 0xF9, 0x77, 0x20, 0xBF, 0x0E, 0x76, 0x04, 0xF9, 0x77, 0x20, 0x6F, 0x0E, 0x76, 0x01,
  0xF9, 0x77, 0x20, 0x3F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F,
  0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77,
  0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77,
  0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F,
  0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77,
  0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77,
  0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F,
  0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77,
  0x20, 0x1F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x2F, 0x0E, 0x77, 0xF9, 0x77, 0x20, 0x3F, 0x0E, 0x77,
  0xF9, 0x01, 0x77, 0x10, 0x4F, 0x0E, 0x77, 0x0E, 0xF0, 0x17, 0x71, 0x07, 0xF0, 0xE7, 0x70, 0xDF,
  0x03, 0x77, 0x10, 0x9F, 0x0E, 0x77, 0x0C, 0xF0, 0x57, 0x71, 0x0D, 0xF0, 0xE7, 0x70, 0xAF, 0x08,
  0x77, 0x02, 0xF9, 0x0E, 0x77, 0x08, 0xF0, 0xB7, 0x70, 0x8F, 0x90, 0xE7, 0x70, 0x5F, 0x90, 0x17,
  0x60, 0xEF, 0xA7, 0x70, 0x2F, 0x90, 0x77, 0x50, 0x8F, 0xB7, 0x71, 0x0D, 0xF0, 0xE0, 0x27, 0x30,
  0x4B, 0x0A, 0xF0, 0x37, 0x70, 0x8F, 0x90, 0xC0, 0x27, 0x10, 0x6B, 0x08, 0x05, 0xF0, 0x87, 0x70,
  0x2F, 0xA8, 0x7E, 0x94, 0x10, 0x12, 0x6C, 0xB8, 0x1E, 0x13, 0xF9, 0x04, 0x77, 0x09, 0xFF, 0xE8,
  0x16, 0x01, 0xFA, 0x81, 0xA5, 0x17, 0x40, 0x10, 0xEF, 0xFC, 0x0B, 0x30, 0xEF, 0xD0, 0x67, 0x30,
  0x30, 0xEF, 0xFA, 0x0C, 0x40, 0xCF, 0xD0, 0x67, 0x40, 0x30, 0xDF, 0xF0, 0xB0, 0x14, 0x0A, 0xFD,
  0x06, 0x75, 0x01, 0x08, 0xFC, 0x0D, 0x05, 0x60, 0x7F, 0xD0, 0x67, 0x78, 0x31, 0x6A, 0xCE, 0xA8,
  0x2E, 0xB8, 0x37, 0x77, 0x10,
  // "ý" (U+00FD)
  0x77, 0x74, 0x03, 0x80, 0x47, 0x04, 0x77, 0x77, 0x60, 0xBF, 0x90, 0x87, 0x77, 0x75, 0x02, 0xF9,
  0x0D, 0x01, 0x77, 0x77, 0x50, 0x9F, 0x90, 0x37, 0x77, 0x75, 0x01, 0xF9, 0x05, 0x77, 0x77, 0x60,
  0x9F, 0x08, 0x77, 0x77, 0x60, 0x2F, 0x0A, 0x77, 0x77, 0x70, 0xAE, 0x0B, 0x77, 0x77, 0x70, 0x4E,
  0x0B, 0x80, 0xC0, 0x00, 0xCD, 0x0C, 0x80, 0xC0, 0x00, 0x6D, 0x0C, 0x80, 0xC0, 0x00, 0x10, 0xEC,
  0x0B, 0x80, 0xC1, 0x00, 0x9C, 0x0A, 0x80, 0xC1, 0x00, 0x3C, 0x09, 0x80, 0xC2, 0x00, 0x6B, 0x06,
  0x80, 0xCB, 0x10, 0x0B, 0xFF, 0xC0, 0x47, 0x04, 0xFF, 0x90, 0xA0, 0xBF, 0xFC, 0x04, 0x70, 0x4F,
  0xF9, 0x0A, 0x0B, 0xFF, 0xC0, 0x47, 0x04, 0xFF, 0x90, 0xA0, 0xBF, 0xFC, 0x04, 0x70, 0x4F, 0xF9,
  0x83, 0xA0, 0x14, 0xBF, 0xC8, 0x1C, 0x51, 0x74, 0x81, 0x14, 0xBF, 0x98, 0x1B, 0x41, 0x50, 0xAF,
  0xA0, 0xC7, 0x73, 0x0A, 0xE0, 0xA7, 0x10, 0x10, 0xEF, 0x90, 0x67, 0x73, 0x04, 0xD0, 0xE0, 0x17,
  0x20, 0x8F, 0x90, 0x57, 0x73, 0x02, 0xD0, 0x97, 0x30, 0x2F, 0x90, 0x67, 0x73, 0x04, 0xD0, 0x27,
  0x40, 0xCF, 0x09, 0x77, 0x30, 0x5C, 0x0C, 0x75, 0x06, 0xF0, 0xD7, 0x73, 0x09, 0xC0, 0x77, 0x50,
  0x1F, 0x90, 0x27, 0x72, 0x0D, 0xC0, 0x27, 0x60, 0xAF, 0x07, 0x77, 0x10, 0x2C, 0x0D, 0x77, 0x05,
  0xF0, 0xC7, 0x71, 0x06, 0xC0, 0x87, 0x71, 0x0E, 0xF0, 0x27, 0x70, 0xBC, 0x03, 0x77, 0x10, 0x9F,
  0x07, 0x77, 0xC0, 0xE7, 0x72, 0x04, 0xF0, 0xC7, 0x60, 0x4C, 0x09, 0x77, 0x30, 0xDF, 0x02, 0x75,
  0x08, 0xC0, 0x47, 0x73, 0x08, 0xF0, 0x77, 0x50, 0xDB, 0x0E, 0x77, 0x40, 0x3F, 0x0D, 0x74, 0x02,
  0xC0, 0xA7, 0x75, 0x0C, 0xF0, 0x27, 0x30, 0x6C, 0x05, 0x77, 0x50, 0x7F, 0x08, 0x73, 0x0A, 0xC7,
  0x76, 0x01, 0xF0, 0xD7, 0x30, 0xEB, 0x0A, 0x77, 0x70, 0xBF, 0x03, 0x71, 0x04, 0xC0, 0x67, 0x77,
  0x06, 0xF0, 0x87, 0x10, 0x8C, 0x01, 0x77, 0x70, 0x1F, 0x0D, 0x71, 0x0C, 0xB0, 0xB7, 0x77, 0x20,
  0xAF, 0x03, 0x60, 0x1C, 0x06, 0x77, 0x72, 0x05, 0xF0, 0x86, 0x06, 0xC0, 0x27, 0x77, 0x30, 0xEE,
  0x0D, 0x60, 0xAB, 0x0C, 0x77, 0x74, 0x09, 0xF0, 0x25, 0x0E, 0xB0, 0x77, 0x77, 0x40, 0x3F, 0x07,
  0x40, 0x3C, 0x02, 0x77, 0x75, 0x0D, 0xE0, 0xC4, 0x08, 0xB0, 0xD7, 0x77, 0x60, 0x8F, 0x01, 0x30,
  0xCB, 0x08, 0x77, 0x76, 0x02, 0xF0, 0x52, 0x01, 0xC0, 0x37, 0x77, 0x70, 0xCE, 0x0A, 0x20, 0x5B,
  0x0E, 0x77, 0x77, 0x10, 0x7E, 0x0E, 0x20, 0x9B, 0x09, 0x77, 0x77, 0x10, 0x1F, 0x81, 0x30, 0xDB,
  0x04, 0x77, 0x77, 0x20, 0xBE, 0x07, 0x01, 0xB0, 0xE7, 0x77, 0x73, 0x06, 0xE0, 0xA0, 0x5B, 0x0A,
  0x77, 0x77, 0x4E, 0x0E, 0x09, 0xB0, 0x57, 0x77, 0x74, 0x0A, 0xE0, 0xEB, 0x77, 0x77, 0x50, 0x4F,
  0xA0, 0xB7, 0x77, 0x76, 0x0E, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x77, 0x76, 0x03,
  0xF0, 0xB8, 0x0C, 0x00, 0x0D, 0xE0, 0x78, 0x0C, 0x00, 0x08, 0xE0, 0x28, 0x0C, 0x00, 0x02, 0xD0,
  0xC8, 0x0C, 0x10, 0x03, 0xD0, 0x78, 0x0C, 0x10, 0x08, 0xD0, 0x28, 0x0C, 0x10, 0x0D, 0xC0, 0xD8,
  0x0C, 0x10, 0x03, 0xD0, 0x88, 0x0C, 0x10, 0x09, 0xD0, 0x38, 0x0C, 0x10, 0x0E, 0xC0, 0xD8, 0x0C,
  0x10, 0x06, 0xD0, 0x78, 0x0C, 0x10, 0x0D, 0xD0, 0x18, 0x0C, 0x00, 0x07, 0xD0, 0xB8, 0x0C, 0x00,
  0x01, 0x0E, 0xD0, 0x58, 0x0C, 0x00, 0x0A, 0xD0, 0xD8, 0x0C, 0x00, 0x07, 0xE0, 0x67, 0x77, 0x77,
  0x07, 0xE0, 0xD7, 0x77, 0x77, 0x09, 0xF0, 0x57, 0x77, 0x75, 0x04, 0x0C, 0xF0, 0xB7, 0x77, 0x73,
  0x81, 0x26, 0xCF, 0x90, 0xE0, 0x17, 0x77, 0x58, 0x31, 0x9A, 0xBE, 0xFC, 0x03, 0x77, 0x76, 0x03,
  0xFE, 0x0E, 0x04, 0x77, 0x77, 0x03, 0xFD, 0x0B, 0x02, 0x77, 0x77, 0x10, 0x3F, 0xB0, 0xA0, 0x47,
  0x77, 0x73, 0x03, 0xA8, 0x5E, 0xED, 0xB9, 0x74, 0x77, 0x77, 0x40,
  // "þ" (U+00FE)
  0x05, 0xFF, 0x03, 0x77, 0x76, 0x05, 0xFF, 0x03, 0x77, 0x76, 0x05, 0xFF, 0x03, 0x77, 0x76, 0x05,
  0xFF, 0x03, 0x77, 0x77, 0x18, 0x11, 0x49, 0xFB, 0x03, 0x77, 0x77, 0x40, 0x30, 0xEF, 0x90, 0x37,
  0x77, 0x75, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x3F, 0x90, 0x37, 0x77, 0x76, 0xF9, 0x03, 0x77,
  0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77,
  0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60,
  0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF,
  0x02, 0x77, 0x77, 0x60, 0xEF, 0x02, 0x68, 0x90, 0x38, 0xCD, 0xFE, 0xEB, 0x94, 0x77, 0x40, 0xEF,
  0x02, 0x40, 0x30, 0xCF, 0xB0, 0xE0, 0x77, 0x72, 0x0E, 0xF0, 0x13, 0x07, 0xFF, 0x0D, 0x03, 0x77,
  0x0E, 0xF0, 0x12, 0x07, 0xFF, 0xB0, 0x57, 0x60, 0xEF, 0x20, 0x5C, 0x84, 0xEB, 0x99, 0xBE, 0xFA,
  0x04, 0x75, 0x0E, 0xF1, 0x01, 0x0E, 0xA0, 0xC0, 0x46, 0x05, 0x0E, 0xF0, 0xE0, 0x27, 0x40, 0xEE,
  0x81, 0xE0, 0xAA, 0x09, 0x72, 0x01, 0x0D, 0xF0, 0xB7, 0x40, 0xEE, 0x0D, 0x03, 0xA0, 0xA7, 0x40,
  0x10, 0xEF, 0x04, 0x73, 0x0E, 0xE8, 0x3D, 0xAF, 0xE1, 0x75, 0x06, 0xF0, 0xC7, 0x30, 0xEE, 0x0E,
  0xA0, 0x77, 0x70, 0xEF, 0x03, 0x72, 0x0E, 0xFA, 0x01, 0x77, 0x08, 0xF0, 0x87, 0x20, 0xEF, 0x90,
  0xB7, 0x71, 0x03, 0xF0, 0xD7, 0x20, 0xEF, 0x90, 0x77, 0x72, 0x0E, 0xF0, 0x27, 0x10, 0xEF, 0x90,
  0x37, 0x72, 0x0A, 0xF0, 0x67, 0x10, 0xEF, 0x97, 0x73, 0x07, 0xF0, 0x97, 0x10, 0xEF, 0x0D, 0x77,
  0x30, 0x5F, 0x0C, 0x71, 0x0E, 0xF0, 0xA7, 0x73, 0x02, 0xF0, 0xE7, 0x10, 0xEF, 0x08, 0x77, 0x30,
  0x1F, 0x97, 0x10, 0xEF, 0x07, 0x77, 0x4F, 0x90, 0x27, 0x0E, 0xF0, 0x57, 0x74, 0x0D, 0xF0, 0x37,
  0x0E, 0xF0, 0x47, 0x74, 0x0C, 0xF0, 0x57, 0x0E, 0xF0, 0x47, 0x74, 0x0C, 0xF0, 0x57, 0x0E, 0xF0,
  0x37, 0x74, 0x0B, 0xF0, 0x67, 0x0E, 0xF0, 0x37, 0x74, 0x0B, 0xF0, 0x67, 0x0E, 0xF0, 0x37, 0x74,
  0x0B, 0xF0, 0x77, 0x0E, 0xF0, 0x37, 0x74, 0x0B, 0xF0, 0x77, 0x0E, 0xF0, 0x37, 0x74, 0x0B, 0xF0,
  0x67, 0x0E, 0xF0, 0x37, 0x74, 0x0C, 0xF0, 0x67, 0x0E, 0xF0, 0x47, 0x74, 0x0C, 0xF0, 0x57, 0x0E,
  0xF0, 0x57, 0x74, 0x0D, 0xF0, 0x47, 0x0E, 0xF0, 0x67, 0x74, 0x0E, 0xF0, 0x37, 0x0E, 0xF0, 0x77,
  0x74, 0xF9, 0x02, 0x70, 0xEF, 0x09, 0x77, 0x30, 0x2F, 0x97, 0x10, 0xEF, 0x0B, 0x77, 0x30, 0x4F,
  0x0E, 0x71, 0x0E, 0xF0, 0xD7, 0x73, 0x06, 0xF0, 0xB7, 0x10, 0xEF, 0x90, 0x17, 0x72, 0x09, 0xF0,
  0x87, 0x10, 0xEF, 0x90, 0x47, 0x72, 0x0C, 0xF0, 0x57, 0x10, 0xEF, 0x90, 0x77, 0x72, 0xF9, 0x01,
  0x71, 0x0E, 0xF9, 0x0C, 0x77, 0x10, 0x5F, 0x0D, 0x72, 0x0E, 0xFA, 0x02, 0x77, 0x0A, 0xF0, 0x87,
  0x20, 0xEF, 0xA0, 0x87, 0x60, 0x1F, 0x90, 0x27, 0x20, 0xEF, 0xA0, 0xE0, 0x17, 0x50, 0x8F, 0x0B,
  0x73, 0x0E, 0xE0, 0xE0, 0xAA, 0x0B, 0x74, 0x03, 0xF9, 0x03, 0x73, 0x0E, 0xE0, 0xE0, 0x2B, 0x09,
  0x72, 0x02, 0x0D, 0xF0, 0xA7, 0x40, 0xEF, 0x10, 0x8B, 0x0D, 0x05, 0x60, 0x60, 0xEF, 0x0E, 0x01,
  0x74, 0x0E, 0xF2, 0x0C, 0xC8, 0x4E, 0xB9, 0x9B, 0xEF, 0x90, 0xE0, 0x37, 0x50, 0xEF, 0x20, 0x10,
  0xDF, 0xFA, 0x0E, 0x04, 0x76, 0x0E, 0xF0, 0x12, 0x01, 0x0C, 0xFF, 0x0D, 0x02, 0x77, 0x0E, 0xF0,
  0x14, 0x07, 0x0E, 0xFB, 0x0D, 0x07, 0x77, 0x20, 0xEF, 0x02, 0x68, 0x25, 0x9C, 0xEA, 0x82, 0xEB,
  0x84, 0x77, 0x40, 0xEF, 0x02, 0x77, 0x77, 0x60, 0xEF, 0x02, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77,
  0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77,
  0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x60,
  0xEF, 0x03, 0x77, 0x77, 0x60, 0xEF, 0x03, 0x77, 0x77, 0x6F, 0x90, 0x47, 0x77, 0x75, 0x03, 0xF9,
  0x06, 0x77, 0x77, 0x50, 0x9F, 0x90, 0xB7, 0x77, 0x74, 0x04, 0xFB, 0x05, 0x77, 0x77, 0x81, 0x15,
  0xAF, 0xD8, 0x2B, 0x52, 0x17, 0x77, 0x10, 0xAF, 0xFF, 0x03, 0x77, 0x60, 0xAF, 0xFF, 0x03, 0x77,
  0x60, 0xAF, 0xFF, 0x03, 0x77, 0x60, 0xAF, 0xFF, 0x03, 0x77, 0x60,
  // "ÿ" (U+00FF)
  0x76, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC4, 0x77, 0x72, 0x01, 0x0E, 0xD0, 0x37,
  0x0D, 0xD0, 0x57, 0x77, 0x10, 0x8E, 0x0B, 0x60, 0x6E, 0x0D, 0x77, 0x71, 0x0C, 0xF6, 0x0A, 0xF0,
  0x27, 0x77, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47, 0x77, 0x0E, 0xF0, 0x25, 0x0B, 0xF0, 0x47, 0x77,
  0x0C, 0xF6, 0x0A, 0xF0, 0x27, 0x77, 0x09, 0xE0, 0xC6, 0x07, 0xE0, 0xE7, 0x77, 0x10, 0x20, 0xED,
  0x04, 0x60, 0x10, 0xDD, 0x06, 0x77, 0x72, 0x84, 0x2A, 0xEE, 0xB3, 0x71, 0x84, 0x19, 0xEF, 0xC5,
  0x80, 0xEA, 0x30, 0x0B, 0xFF, 0xC0, 0x47, 0x04, 0xFF, 0x90, 0xA0, 0xBF, 0xFC, 0x04, 0x70, 0x4F,
  0xF9, 0x0A, 0x0B, 0xFF, 0xC0, 0x47, 0x04, 0xFF, 0x90, 0xA0, 0xBF, 0xFC, 0x04, 0x70, 0x4F, 0xF9,
  0x83, 0xA0, 0x14, 0xBF, 0xC8, 0x1C, 0x51, 0x74, 0x81, 0x14, 0xBF, 0x98, 0x1B, 0x41, 0x50, 0xAF,
  0xA0, 0xC7, 0x73, 0x0A, 0xE0, 0xA7, 0x10, 0x10, 0xEF, 0x90, 0x67, 0x73, 0x04, 0xD0, 0xE0, 0x17,
  0x20, 0x8F, 0x90, 0x57, 0x73, 0x02, 0xD0, 0x97, 0x30, 0x2F, 0x90, 0x67, 0x73, 0x04, 0xD0, 0x27,
  0x40, 0xCF, 0x09, 0x77, 0x30, 0x5C, 0x0C, 0x75, 0x06, 0xF0, 0xD7, 0x73, 0x09, 0xC0, 0x77, 0x50,
  0x1F, 0x90, 0x27, 0x72, 0x0D, 0xC0, 0x27, 0x60, 0xAF, 0x07, 0x77, 0x10, 0x2C, 0x0D, 0x77, 0x05,
  0xF0, 0xC7, 0x71, 0x06, 0xC0, 0x87, 0x71, 0x0E, 0xF0, 0x27, 0x70, 0xBC, 0x03, 0x77, 0x10, 0x9F,
  0x07, 0x77, 0xC0, 0xE7, 0x72, 0x04, 0xF0, 0xC7, 0x60, 0x4C, 0x09, 0x77, 0x30, 0xDF, 0x02, 0x75,
  0x08, 0xC0, 0x47, 0x73, 0x08, 0xF0, 0x77, 0x50, 0xDB, 0x0E, 0x77, 0x40, 0x3F, 0x0D, 0x74, 0x02,
  0xC0, 0xA7, 0x75, 0x0C, 0xF0, 0x27, 0x30, 0x6C, 0x05, 0x77, 0x50, 0x7F, 0x08, 0x73, 0x0A, 0xC7,
  0x76, 0x01, 0xF0, 0xD7, 0x30, 0xEB, 0x0A, 0x77, 0x70, 0xBF, 0x03, 0x71, 0x04, 0xC0, 0x67, 0x77,
  0x06, 0xF0, 0x87, 0x10, 0x8C, 0x01, 0x77, 0x70, 0x1F, 0x0D, 0x71, 0x0C, 0xB0, 0xB7, 0x77, 0x20,
  0xAF, 0x03, 0x60, 0x1C, 0x06, 0x77, 0x72, 0x05, 0xF0, 0x86, 0x06, 0xC0, 0x27, 0x77, 0x30, 0xEE,
  0x0D, 0x60, 0xAB, 0x0C, 0x77, 0x74, 0x09, 0xF0, 0x25, 0x0E, 0xB0, 0x77, 0x77, 0x40, 0x3F, 0x07,
  0x40, 0x3C, 0x02, 0x77, 0x75, 0x0D, 0xE0, 0xC4, 0x08, 0xB0, 0xD7, 0x77, 0x60, 0x8F, 0x01, 0x30,
  0xCB, 0x08, 0x77, 0x76, 0x02, 0xF0, 0x52, 0x01, 0xC0, 0x37, 0x77, 0x70, 0xCE, 0x0A, 0x20, 0x5B,
  0x0E, 0x77, 0x77, 0x10, 0x7E, 0x0E, 0x20, 0x9B, 0x09, 0x77, 0x77, 0x10, 0x1F, 0x81, 0x30, 0xDB,
  0x04, 0x77, 0x77, 0x20, 0xBE, 0x07, 0x01, 0xB0, 0xE7, 0x77, 0x73, 0x06, 0xE0, 0xA0, 0x5B, 0x0A,
  0x77, 0x77, 0x4E, 0x0E, 0x09, 0xB0, 0x57, 0x77, 0x74, 0x0A, 0xE0, 0xEB, 0x77, 0x77, 0x50, 0x4F,
  0xA0, 0xB7, 0x77, 0x76, 0x0E, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x9F, 0x90, 0x17, 0x77, 0x76, 0x03,
  0xF0, 0xB8, 0x0C, 0x00, 0x0D, 0xE0, 0x78, 0x0C, 0x00, 0x08, 0xE0, 0x28, 0x0C, 0x00, 0x02, 0xD0,
  0xC8, 0x0C, 0x10, 0x03, 0xD0, 0x78, 0x0C, 0x10, 0x08, 0xD0, 0x28, 0x0C, 0x10, 0x0D, 0xC0, 0xD8,
  0x0C, 0x10, 0x03, 0xD0, 0x88, 0x0C, 0x10, 0x09, 0xD0, 0x38, 0x0C, 0x10, 0x0E, 0xC0, 0xD8, 0x0C,
  0x10, 0x06, 0xD0, 0x78, 0x0C, 0x10, 0x0D, 0xD0, 0x18, 0x0C, 0x00, 0x07, 0xD0, 0xB8, 0x0C, 0x00,
  0x01, 0x0E, 0xD0, 0x58, 0x0C, 0x00, 0x0A, 0xD0, 0xD8, 0x0C, 0x00, 0x07, 0xE0, 0x67, 0x77, 0x77,
  0x07, 0xE0, 0xD7, 0x77, 0x77, 0x09, 0xF0, 0x57, 0x77, 0x75, 0x04, 0x0C, 0xF0, 0xB7, 0x77, 0x73,
  0x81, 0x26, 0xCF, 0x90, 0xE0, 0x17, 0x77, 0x58, 0x31, 0x9A, 0xBE, 0xFC, 0x03, 0x77, 0x76, 0x03,
  0xFE, 0x0E, 0x04, 0x77, 0x77, 0x03, 0xFD, 0x0B, 0x02, 0x77, 0x77, 0x10, 0x3F, 0xB0, 0xA0, 0x47,
  0x77, 0x73, 0x03, 0xA8, 0x5E, 0xED, 0xB9, 0x74, 0x77, 0x77, 0x40,
  // "Ā" (U+0100)
  0x77, 0x20, 0x38, 0x0A, 0x19, 0x07, 0x77, 0x77, 0x40, 0x6F, 0xFF, 0x0C, 0x77, 0x77, 0x40, 0x6F,
  0xFF, 0x0C, 0x77, 0x77, 0x40, 0x6F, 0xFF, 0x0C, 0x77, 0x77, 0x40, 0x6F, 0xFF, 0x0C, 0x80, 0xDD,
  0x60, 0x0D, 0xE0, 0x38, 0x0D, 0x20, 0x02, 0xF0, 0x78, 0x0D, 0x20, 0x07, 0xF0, 0xC8, 0x0D, 0x20,
  0x0C, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x2F, 0xA0, 0x78, 0x0D, 0x00, 0x07, 0xFA, 0x0B, 0x80, 0xD0,
  0x00, 0xCF, 0xB0, 0x18, 0x0C, 0x60, 0x01, 0xFC, 0x05, 0x80, 0xC6, 0x00, 0x6B, 0x0E, 0xF0, 0xA8,
  0x0C, 0x60, 0x0B, 0xB0, 0x90, 0xEF, 0x80, 0xC5, 0x00, 0x1C, 0x06, 0x0A, 0xF0, 0x58, 0x0C, 0x40,
  0x05, 0xC0, 0x20, 0x6F, 0x09, 0x80, 0xC4, 0x00, 0xAB, 0x81, 0xE0, 0x2F, 0x0E, 0x80, 0xC4, 0x0C,
  0x0A, 0x20, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0x5C, 0x06, 0x20, 0x9F, 0x08, 0x80, 0xC2, 0x00, 0xAC,
  0x01, 0x20, 0x5F, 0x0D, 0x80, 0xC2, 0x00, 0xEB, 0x0C, 0x4F, 0x90, 0x38, 0x0C, 0x00, 0x04, 0xC0,
  0x84, 0x0B, 0xF0, 0x78, 0x0C, 0x00, 0x09, 0xC0, 0x34, 0x07, 0xF0, 0xC8, 0x0C, 0x00, 0x0E, 0xB0,
  0xE5, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x3C, 0x0A, 0x60, 0xDF, 0x06, 0x77, 0x77, 0x60, 0x8C,
  0x05, 0x60, 0x9F, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x70, 0x4F, 0x90, 0x17, 0x77, 0x74, 0x03, 0xC0,
  0xB7, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0x8C, 0x06, 0x71, 0x0A, 0xF0, 0xA7, 0x77, 0x74, 0x0D,
  0xC0, 0x17, 0x10, 0x6F, 0x0E, 0x77, 0x77, 0x30, 0x2C, 0x0C, 0x72, 0x01, 0xF9, 0x04, 0x77, 0x77,
  0x20, 0x7C, 0x07, 0x73, 0x0C, 0xF0, 0x97, 0x77, 0x72, 0x0C, 0xC0, 0x37, 0x30, 0x8F, 0x0E, 0x77,
  0x77, 0x10, 0x1C, 0x0D, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x06, 0xC0, 0x97, 0x50, 0xEF, 0x08,
  0x77, 0x77, 0x0B, 0xC0, 0x47, 0x50, 0x9F, 0x0D, 0x77, 0x76, 0x01, 0xC0, 0xE7, 0x60, 0x5F, 0x90,
  0x27, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0xF9, 0x07, 0x77, 0x75, 0x0B, 0xC0, 0x57, 0x70, 0xBF, 0x0C,
  0x77, 0x75, 0xD0, 0x17, 0x70, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x5C, 0x0B, 0x77, 0x10, 0x2F, 0x90,
  0x67, 0x77, 0x30, 0xAC, 0x06, 0x77, 0x20, 0xDF, 0x0B, 0x77, 0x73, 0x0E, 0xFF, 0xFF, 0xA0, 0x17,
  0x77, 0x10, 0x4F, 0xFF, 0xFB, 0x05, 0x77, 0x71, 0x09, 0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x10, 0xEF,
  0xFF, 0xFB, 0x0E, 0x77, 0x70, 0x4C, 0x0D, 0x80, 0x97, 0x90, 0xBF, 0x90, 0x47, 0x76, 0x09, 0xC0,
  0x77, 0x75, 0x01, 0xF9, 0x09, 0x77, 0x60, 0xDC, 0x02, 0x77, 0x60, 0xCF, 0x0E, 0x77, 0x50, 0x3C,
  0x0D, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x74, 0x08, 0xC0, 0x87, 0x77, 0x02, 0xF9, 0x08, 0x77, 0x40,
  0xDC, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD7, 0x73, 0x02, 0xC0, 0xE7, 0x77, 0x20, 0x8F, 0x90, 0x27,
  0x72, 0x07, 0xC0, 0xA7, 0x77, 0x20, 0x4F, 0x90, 0x77, 0x72, 0x0C, 0xC0, 0x57, 0x77, 0x30, 0xEF,
  0x0C, 0x77, 0x10, 0x2D, 0x77, 0x74, 0x0A, 0xF9, 0x01, 0x77, 0x07, 0xC0, 0xB7, 0x77, 0x40, 0x6F,
  0x90, 0x67, 0x70, 0xCC, 0x07, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x76, 0x02, 0xD0, 0x47, 0x77, 0x50,
  0xEF, 0x97, 0x60, 0x8D, 0x02, 0x77, 0x75, 0x0B, 0xF9, 0x05, 0x75, 0x0E, 0xD0, 0x37, 0x77, 0x50,
  0xAF, 0x90, 0xA7, 0x40, 0x7E, 0x06, 0x77, 0x75, 0x0D, 0xFA, 0x02, 0x72, 0x02, 0x0E, 0xE0, 0xD0,
  0x17, 0x77, 0x30, 0x4F, 0xB0, 0xB7, 0x81, 0x16, 0xEF, 0x98, 0x1D, 0x62, 0x77, 0x60, 0x20, 0x8F,
  0xD8, 0x1C, 0x51, 0x20, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75,
  0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75,
  0x01, 0xFF, 0xF0, 0xC0,
  // "ā" (U+0101)
  0x70, 0x38, 0x0A, 0x19, 0x07, 0x77, 0x10, 0x6F, 0xFF, 0x0C, 0x77, 0x10, 0x6F, 0xFF, 0x0C, 0x77,
  0x10, 0x6F, 0xFF, 0x0C, 0x77, 0x10, 0x6F, 0xFF, 0x0C, 0x80, 0xBE, 0x30, 0x84, 0x26, 0x9B, 0xDE,
  0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x81, 0x17, 0xDF, 0xF0, 0xA0, 0x37, 0x74, 0x07, 0xFF, 0xD0,
  0x97, 0x72, 0x0C, 0xFF, 0xF0, 0xC0, 0x17, 0x60, 0xBF, 0xA8, 0x3D, 0xA9, 0xAC, 0xFA, 0x0C, 0x75,
  0x05, 0xF9, 0x0B, 0x02, 0x50, 0x10, 0x8F, 0x90, 0x87, 0x40, 0xBF, 0x0B, 0x72, 0x05, 0xF0, 0xE0,
  0x17, 0x30, 0xEF, 0x01, 0x73, 0x0B, 0xF0, 0x77, 0x3F, 0x0B, 0x74, 0x05, 0xF0, 0xC7, 0x3F, 0x07,
  0x74, 0x01, 0xF9, 0x73, 0x0B, 0xE0, 0x37, 0x50, 0xDF, 0x03, 0x72, 0x05, 0xE0, 0x17, 0x50, 0xBF,
  0x06, 0x73, 0x07, 0xD7, 0x60, 0x9F, 0x07, 0x74, 0x81, 0x39, 0xDA, 0x76, 0x08, 0xF0, 0x87, 0x71,
  0x01, 0x76, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77,
  0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71,
  0x07, 0xF0, 0x97, 0x71, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xF9, 0x09, 0x75, 0x81, 0x16, 0xCF, 0xFF,
  0x90, 0x97, 0x40, 0x70, 0xEF, 0xFF, 0xB0, 0x97, 0x20, 0x10, 0xCF, 0xFF, 0xD0, 0x97, 0x10, 0x10,
  0xDF, 0xA8, 0x3D, 0x85, 0x21, 0x50, 0x5F, 0x09, 0x71, 0x0C, 0xF9, 0x0D, 0x04, 0x73, 0x05, 0xF0,
  0x97, 0x06, 0xF9, 0x0C, 0x01, 0x74, 0x05, 0xF0, 0x97, 0x0E, 0xF0, 0xE0, 0x17, 0x50, 0x5F, 0x09,
  0x60, 0x5F, 0x90, 0x67, 0x60, 0x5F, 0x09, 0x60, 0x9F, 0x0E, 0x77, 0x05, 0xF0, 0x96, 0x0D, 0xF0,
  0x97, 0x70, 0x5F, 0x09, 0x6F, 0x90, 0x67, 0x70, 0x6F, 0x09, 0x50, 0x2F, 0x90, 0x37, 0x70, 0x7F,
  0x09, 0x50, 0x3F, 0x90, 0x27, 0x70, 0x8F, 0x09, 0x50, 0x3F, 0x90, 0x17, 0x70, 0xAF, 0x09, 0x50,
  0x2F, 0x90, 0x17, 0x70, 0xDF, 0x09, 0x50, 0x1F, 0x90, 0x17, 0x60, 0x1F, 0x90, 0x96, 0xF9, 0x03,
  0x76, 0x07, 0xF9, 0x09, 0x60, 0xDF, 0x05, 0x76, 0x0D, 0xF9, 0x0A, 0x60, 0xAF, 0x09, 0x75, 0x07,
  0xFA, 0x0B, 0x60, 0x6F, 0x0E, 0x74, 0x83, 0x2E, 0xF6, 0xAE, 0x0D, 0x60, 0x1F, 0x90, 0x67, 0x28,
  0x41, 0xDF, 0xB0, 0x7F, 0x01, 0x60, 0xAF, 0x0E, 0x03, 0x78, 0x54, 0xDF, 0xE1, 0x05, 0xF0, 0x96,
  0x03, 0xFA, 0x08, 0x02, 0x28, 0x12, 0x5B, 0xB0, 0x52, 0x03, 0xF9, 0x0A, 0x03, 0x50, 0x7F, 0xFB,
  0x09, 0x4F, 0xC0, 0x94, 0x0A, 0xFF, 0x90, 0xA5, 0x0D, 0xFB, 0x09, 0x50, 0x8F, 0xE0, 0xA6, 0x0B,
  0xFB, 0x09, 0x60, 0x40, 0xCF, 0xA0, 0xE0, 0x67, 0x08, 0xFB, 0x09, 0x71, 0x89, 0x04, 0x8C, 0xEF,
  0xED, 0xA6, 0x17, 0x76,
  // "Ă" (U+0102)
  0x77, 0x20, 0x5B, 0x09, 0x76, 0x04, 0xB0, 0x97, 0x77, 0x74, 0x04, 0xB0, 0xD7, 0x60, 0x8B, 0x08,
  0x77, 0x77, 0x40, 0x2C, 0x04, 0x75, 0x0E, 0xB0, 0x67, 0x77, 0x75, 0x0E, 0xB0, 0xD7, 0x40, 0x9C,
  0x02, 0x77, 0x77, 0x50, 0xAC, 0x0B, 0x01, 0x71, 0x09, 0xC0, 0xE7, 0x77, 0x76, 0x04, 0xD8, 0x2E,
  0x84, 0x12, 0x81, 0x37, 0xDD, 0x08, 0x77, 0x77, 0x70, 0xDF, 0xFC, 0x02, 0x77, 0x77, 0x70, 0x4F,
  0xFB, 0x08, 0x80, 0xC1, 0x00, 0x8F, 0xF9, 0x0C, 0x80, 0xC3, 0x00, 0x9F, 0xE0, 0xC0, 0x18, 0x0C,
  0x40, 0x05, 0x0D, 0xFB, 0x08, 0x80, 0xD0, 0x08, 0x90, 0x59, 0xCE, 0xFE, 0xDB, 0x61, 0x80, 0xCF,
  0x50, 0x0D, 0xE0, 0x38, 0x0D, 0x20, 0x02, 0xF0, 0x78, 0x0D, 0x20, 0x07, 0xF0, 0xC8, 0x0D, 0x20,
  0x0C, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x2F, 0xA0, 0x78, 0x0D, 0x00, 0x07, 0xFA, 0x0B, 0x80, 0xD0,
  0x00, 0xCF, 0xB0, 0x18, 0x0C, 0x60, 0x01, 0xFC, 0x05, 0x80, 0xC6, 0x00, 0x6B, 0x0E, 0xF0, 0xA8,
  0x0C, 0x60, 0x0B, 0xB0, 0x90, 0xEF, 0x80, 0xC5, 0x00, 0x1C, 0x06, 0x0A, 0xF0, 0x58, 0x0C, 0x40,
  0x05, 0xC0, 0x20, 0x6F, 0x09, 0x80, 0xC4, 0x00, 0xAB, 0x81, 0xE0, 0x2F, 0x0E, 0x80, 0xC4, 0x0C,
  0x0A, 0x20, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0x5C, 0x06, 0x20, 0x9F, 0x08, 0x80, 0xC2, 0x00, 0xAC,
  0x01, 0x20, 0x5F, 0x0D, 0x80, 0xC2, 0x00, 0xEB, 0x0C, 0x4F, 0x90, 0x38, 0x0C, 0x00, 0x04, 0xC0,
  0x84, 0x0B, 0xF0, 0x78, 0x0C, 0x00, 0x09, 0xC0, 0x34, 0x07, 0xF0, 0xC8, 0x0C, 0x00, 0x0E, 0xB0,
  0xE5, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x3C, 0x0A, 0x60, 0xDF, 0x06, 0x77, 0x77, 0x60, 0x8C,
  0x05, 0x60, 0x9F, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x70, 0x4F, 0x90, 0x17, 0x77, 0x74, 0x03, 0xC0,
  0xB7, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0x8C, 0x06, 0x71, 0x0A, 0xF0, 0xA7, 0x77, 0x74, 0x0D,
  0xC0, 0x17, 0x10, 0x6F, 0x0E, 0x77, 0x77, 0x30, 0x2C, 0x0C, 0x72, 0x01, 0xF9, 0x04, 0x77, 0x77,
  0x20, 0x7C, 0x07, 0x73, 0x0C, 0xF0, 0x97, 0x77, 0x72, 0x0C, 0xC0, 0x37, 0x30, 0x8F, 0x0E, 0x77,
  0x77, 0x10, 0x1C, 0x0D, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x06, 0xC0, 0x97, 0x50, 0xEF, 0x08,
  0x77, 0x77, 0x0B, 0xC0, 0x47, 0x50, 0x9F, 0x0D, 0x77, 0x76, 0x01, 0xC0, 0xE7, 0x60, 0x5F, 0x90,
  0x27, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0xF9, 0x07, 0x77, 0x75, 0x0B, 0xC0, 0x57, 0x70, 0xBF, 0x0C,
  0x77, 0x75, 0xD0, 0x17, 0x70, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x5C, 0x0B, 0x77, 0x10, 0x2F, 0x90,
  0x67, 0x77, 0x30, 0xAC, 0x06, 0x77, 0x20, 0xDF, 0x0B, 0x77, 0x73, 0x0E, 0xFF, 0xFF, 0xA0, 0x17,
  0x77, 0x10, 0x4F, 0xFF, 0xFB, 0x05, 0x77, 0x71, 0x09, 0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x10, 0xEF,
  0xFF, 0xFB, 0x0E, 0x77, 0x70, 0x4C, 0x0D, 0x80, 0x97, 0x90, 0xBF, 0x90, 0x47, 0x76, 0x09, 0xC0,
  0x77, 0x75, 0x01, 0xF9, 0x09, 0x77, 0x60, 0xDC, 0x02, 0x77, 0x60, 0xCF, 0x0E, 0x77, 0x50, 0x3C,
  0x0D, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x74, 0x08, 0xC0, 0x87, 0x77, 0x02, 0xF9, 0x08, 0x77, 0x40,
  0xDC, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD7, 0x73, 0x02, 0xC0, 0xE7, 0x77, 0x20, 0x8F, 0x90, 0x27,
  0x72, 0x07, 0xC0, 0xA7, 0x77, 0x20, 0x4F, 0x90, 0x77, 0x72, 0x0C, 0xC0, 0x57, 0x77, 0x30, 0xEF,
  0x0C, 0x77, 0x10, 0x2D, 0x77, 0x74, 0x0A, 0xF9, 0x01, 0x77, 0x07, 0xC0, 0xB7, 0x77, 0x40, 0x6F,
  0x90, 0x67, 0x70, 0xCC, 0x07, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x76, 0x02, 0xD0, 0x47, 0x77, 0x50,
  0xEF, 0x97, 0x60, 0x8D, 0x02, 0x77, 0x75, 0x0B, 0xF9, 0x05, 0x75, 0x0E, 0xD0, 0x37, 0x77, 0x50,
  0xAF, 0x90, 0xA7, 0x40, 0x7E, 0x06, 0x77, 0x75, 0x0D, 0xFA, 0x02, 0x72, 0x02, 0x0E, 0xE0, 0xD0,
  0x17, 0x77, 0x30, 0x4F, 0xB0, 0xB7, 0x81, 0x16, 0xEF, 0x98, 0x1D, 0x62, 0x77, 0x60, 0x20, 0x8F,
  0xD8, 0x1C, 0x51, 0x20, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75,
  0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75,
  0x01, 0xFF, 0xF0, 0xC0,
  // "ă" (U+0103)
  0x70, 0x5B, 0x09, 0x76, 0x04, 0xB0, 0x97, 0x71, 0x04, 0xB0, 0xD7, 0x60, 0x8B, 0x08, 0x77, 0x10,
  0x2C, 0x04, 0x75, 0x0E, 0xB0, 0x67, 0x72, 0x0E, 0xB0, 0xD7, 0x40, 0x9C, 0x02, 0x77, 0x20, 0xAC,
  0x0B, 0x01, 0x71, 0x09, 0xC0, 0xE7, 0x73, 0x04, 0xD8, 0x2E, 0x84, 0x12, 0x81, 0x37, 0xDD, 0x08,
  0x77, 0x40, 0xDF, 0xFC, 0x02, 0x77, 0x40, 0x4F, 0xFB, 0x08, 0x77, 0x60, 0x8F, 0xF9, 0x0C, 0x77,
  0x71, 0x09, 0xFE, 0x0C, 0x01, 0x77, 0x72, 0x05, 0x0D, 0xFB, 0x08, 0x77, 0x76, 0x89, 0x05, 0x9C,
  0xEF, 0xED, 0xB6, 0x18, 0x0B, 0xA3, 0x08, 0x42, 0x69, 0xBD, 0xEA, 0x84, 0xED, 0xB8, 0x51, 0x77,
  0x78, 0x11, 0x7D, 0xFF, 0x0A, 0x03, 0x77, 0x40, 0x7F, 0xFD, 0x09, 0x77, 0x20, 0xCF, 0xFF, 0x0C,
  0x01, 0x76, 0x0B, 0xFA, 0x83, 0xDA, 0x9A, 0xCF, 0xA0, 0xC7, 0x50, 0x5F, 0x90, 0xB0, 0x25, 0x01,
  0x08, 0xF9, 0x08, 0x74, 0x0B, 0xF0, 0xB7, 0x20, 0x5F, 0x0E, 0x01, 0x73, 0x0E, 0xF0, 0x17, 0x30,
  0xBF, 0x07, 0x73, 0xF0, 0xB7, 0x40, 0x5F, 0x0C, 0x73, 0xF0, 0x77, 0x40, 0x1F, 0x97, 0x30, 0xBE,
  0x03, 0x75, 0x0D, 0xF0, 0x37, 0x20, 0x5E, 0x01, 0x75, 0x0B, 0xF0, 0x67, 0x30, 0x7D, 0x76, 0x09,
  0xF0, 0x77, 0x48, 0x13, 0x9D, 0xA7, 0x60, 0x8F, 0x08, 0x77, 0x10, 0x17, 0x60, 0x7F, 0x09, 0x77,
  0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77,
  0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x77, 0x10, 0x7F, 0x09, 0x77, 0x18, 0x51,
  0x58, 0xAC, 0xDE, 0xFF, 0x90, 0x97, 0x58, 0x11, 0x6C, 0xFF, 0xF9, 0x09, 0x74, 0x07, 0x0E, 0xFF,
  0xFB, 0x09, 0x72, 0x01, 0x0C, 0xFF, 0xFD, 0x09, 0x71, 0x01, 0x0D, 0xFA, 0x83, 0xD8, 0x52, 0x15,
  0x05, 0xF0, 0x97, 0x10, 0xCF, 0x90, 0xD0, 0x47, 0x30, 0x5F, 0x09, 0x70, 0x6F, 0x90, 0xC0, 0x17,
  0x40, 0x5F, 0x09, 0x70, 0xEF, 0x0E, 0x01, 0x75, 0x05, 0xF0, 0x96, 0x05, 0xF9, 0x06, 0x76, 0x05,
  0xF0, 0x96, 0x09, 0xF0, 0xE7, 0x70, 0x5F, 0x09, 0x60, 0xDF, 0x09, 0x77, 0x05, 0xF0, 0x96, 0xF9,
  0x06, 0x77, 0x06, 0xF0, 0x95, 0x02, 0xF9, 0x03, 0x77, 0x07, 0xF0, 0x95, 0x03, 0xF9, 0x02, 0x77,
  0x08, 0xF0, 0x95, 0x03, 0xF9, 0x01, 0x77, 0x0A, 0xF0, 0x95, 0x02, 0xF9, 0x01, 0x77, 0x0D, 0xF0,
  0x95, 0x01, 0xF9, 0x01, 0x76, 0x01, 0xF9, 0x09, 0x6F, 0x90, 0x37, 0x60, 0x7F, 0x90, 0x96, 0x0D,
  0xF0, 0x57, 0x60, 0xDF, 0x90, 0xA6, 0x0A, 0xF0, 0x97, 0x50, 0x7F, 0xA0, 0xB6, 0x06, 0xF0, 0xE7,
  0x48, 0x32, 0xEF, 0x6A, 0xE0, 0xD6, 0x01, 0xF9, 0x06, 0x72, 0x84, 0x1D, 0xFB, 0x07, 0xF0, 0x16,
  0x0A, 0xF0, 0xE0, 0x37, 0x85, 0x4D, 0xFE, 0x10, 0x5F, 0x09, 0x60, 0x3F, 0xA0, 0x80, 0x22, 0x81,
  0x25, 0xBB, 0x05, 0x20, 0x3F, 0x90, 0xA0, 0x35, 0x07, 0xFF, 0xB0, 0x94, 0xFC, 0x09, 0x40, 0xAF,
  0xF9, 0x0A, 0x50, 0xDF, 0xB0, 0x95, 0x08, 0xFE, 0x0A, 0x60, 0xBF, 0xB0, 0x96, 0x04, 0x0C, 0xFA,
  0x0E, 0x06, 0x70, 0x8F, 0xB0, 0x97, 0x18, 0x90, 0x48, 0xCE, 0xFE, 0xDA, 0x61, 0x77, 0x60,
  // "Ą" (U+0104)
  0x77, 0x73, 0x0D, 0xE0, 0x38, 0x0D, 0x20, 0x02, 0xF0, 0x78, 0x0D, 0x20, 0x07, 0xF0, 0xC8, 0x0D,
  0x20, 0x0C, 0xF9, 0x02, 0x80, 0xD0, 0x00, 0x2F, 0xA0, 0x78, 0x0D, 0x00, 0x07, 0xFA, 0x0B, 0x80,
  0xD0, 0x00, 0xCF, 0xB0, 0x18, 0x0C, 0x60, 0x01, 0xFC, 0x05, 0x80, 0xC6, 0x00, 0x6B, 0x0E, 0xF0,
  0xA8, 0x0C, 0x60, 0x0B, 0xB0, 0x90, 0xEF, 0x80, 0xC5, 0x00, 0x1C, 0x06, 0x0A, 0xF0, 0x58, 0x0C,
  0x40, 0x05, 0xC0, 0x20, 0x6F, 0x09, 0x80, 0xC4, 0x00, 0xAB, 0x81, 0xE0, 0x2F, 0x0E, 0x80, 0xC4,
  0x0C, 0x0A, 0x20, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0x5C, 0x06, 0x20, 0x9F, 0x08, 0x80, 0xC2, 0x00,
  0xAC, 0x01, 0x20, 0x5F, 0x0D, 0x80, 0xC2, 0x00, 0xEB, 0x0C, 0x4F, 0x90, 0x38, 0x0C, 0x00, 0x04,
  0xC0, 0x84, 0x0B, 0xF0, 0x78, 0x0C, 0x00, 0x09, 0xC0, 0x34, 0x07, 0xF0, 0xC8, 0x0C, 0x00, 0x0E,
  0xB0, 0xE5, 0x02, 0xF9, 0x01, 0x77, 0x77, 0x60, 0x3C, 0x0A, 0x60, 0xDF, 0x06, 0x77, 0x77, 0x60,
  0x8C, 0x05, 0x60, 0x9F, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x70, 0x4F, 0x90, 0x17, 0x77, 0x74, 0x03,
  0xC0, 0xB7, 0x10, 0xEF, 0x05, 0x77, 0x77, 0x40, 0x8C, 0x06, 0x71, 0x0A, 0xF0, 0xA7, 0x77, 0x74,
  0x0D, 0xC0, 0x17, 0x10, 0x6F, 0x0E, 0x77, 0x77, 0x30, 0x2C, 0x0C, 0x72, 0x01, 0xF9, 0x04, 0x77,
  0x77, 0x20, 0x7C, 0x07, 0x73, 0x0C, 0xF0, 0x97, 0x77, 0x72, 0x0C, 0xC0, 0x37, 0x30, 0x8F, 0x0E,
  0x77, 0x77, 0x10, 0x1C, 0x0D, 0x74, 0x03, 0xF9, 0x03, 0x77, 0x77, 0x06, 0xC0, 0x97, 0x50, 0xEF,
  0x08, 0x77, 0x77, 0x0B, 0xC0, 0x47, 0x50, 0x9F, 0x0D, 0x77, 0x76, 0x01, 0xC0, 0xE7, 0x60, 0x5F,
  0x90, 0x27, 0x77, 0x50, 0x6C, 0x0A, 0x77, 0xF9, 0x07, 0x77, 0x75, 0x0B, 0xC0, 0x57, 0x70, 0xBF,
  0x0C, 0x77, 0x75, 0xD0, 0x17, 0x70, 0x6F, 0x90, 0x17, 0x77, 0x30, 0x5C, 0x0B, 0x77, 0x10, 0x2F,
  0x90, 0x67, 0x77, 0x30, 0xAC, 0x06, 0x77, 0x20, 0xDF, 0x0B, 0x77, 0x73, 0x0E, 0xFF, 0xFF, 0xA0,
  0x17, 0x77, 0x10, 0x4F, 0xFF, 0xFB, 0x05, 0x77, 0x71, 0x09, 0xFF, 0xFF, 0xB0, 0xA7, 0x77, 0x10,
  0xEF, 0xFF, 0xFB, 0x0E, 0x77, 0x70, 0x4C, 0x0D, 0x80, 0x97, 0x90, 0xBF, 0x90, 0x47, 0x76, 0x09,
  0xC0, 0x77, 0x75, 0x01, 0xF9, 0x09, 0x77, 0x60, 0xDC, 0x02, 0x77, 0x60, 0xCF, 0x0E, 0x77, 0x50,
  0x3C, 0x0D, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x74, 0x08, 0xC0, 0x87, 0x77, 0x02, 0xF9, 0x08, 0x77,
  0x40, 0xDC, 0x03, 0x77, 0x71, 0x0D, 0xF0, 0xD7, 0x73, 0x02, 0xC0, 0xE7, 0x77, 0x20, 0x8F, 0x90,
  0x27, 0x72, 0x07, 0xC0, 0xA7, 0x77, 0x20, 0x4F, 0x90, 0x77, 0x72, 0x0C, 0xC0, 0x57, 0x77, 0x30,
  0xEF, 0x0C, 0x77, 0x10, 0x2D, 0x77, 0x74, 0x0A, 0xF9, 0x01, 0x77, 0x07, 0xC0, 0xB7, 0x77, 0x40,
  0x6F, 0x90, 0x67, 0x70, 0xCC, 0x07, 0x77, 0x74, 0x02, 0xF9, 0x0B, 0x76, 0x02, 0xD0, 0x47, 0x77,
  0x50, 0xEF, 0x97, 0x60, 0x8D, 0x02, 0x77, 0x75, 0x0B, 0xF9, 0x05, 0x75, 0x0E, 0xD0, 0x37, 0x77,
  0x50, 0xAF, 0x90, 0xA7, 0x40, 0x7E, 0x06, 0x77, 0x75, 0x0D, 0xFA, 0x02, 0x72, 0x02, 0x0E, 0xE0,
  0xD0, 0x17, 0x77, 0x30, 0x4F, 0xB0, 0xB7, 0x81, 0x16, 0xEF, 0x98, 0x1D, 0x62, 0x77, 0x60, 0x20,
  0x8F, 0xD8, 0x1C, 0x51, 0x20, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01,
  0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01, 0x75, 0x01, 0xFF, 0xF0, 0xC0, 0xEF, 0xFC, 0x01,
  0x75, 0x01, 0xFF, 0xF0, 0xC8, 0x0C, 0x70, 0x07, 0x0D, 0xB0, 0x80, 0x18, 0x0D, 0x20, 0x04, 0x0D,
  0xB0, 0xD0, 0x28, 0x0D, 0x30, 0x06, 0xC0, 0xC0, 0x18, 0x0D, 0x30, 0x06, 0xC0, 0xD0, 0x18, 0x0D,
  0x30, 0x04, 0xD0, 0x38, 0x0D, 0x30, 0x01, 0x0E, 0xC0, 0x98, 0x0D, 0x40, 0x08, 0xD0, 0x38, 0x0D,
  0x40, 0x0E, 0xC0, 0xD8, 0x0D, 0x40, 0x03, 0xD0, 0xA8, 0x0D, 0x40, 0x07, 0xD0, 0x88, 0x0D, 0x40,
  0x09, 0xD0, 0x78, 0x0D, 0x40, 0x0A, 0xD0, 0x78, 0x0D, 0x40, 0x09, 0xD0, 0x98, 0x0D, 0x40, 0x08,
  0xD0, 0xD8, 0x0D, 0x40, 0x05, 0xE0, 0x68, 0x0D, 0x30, 0x01, 0xF0, 0x66, 0x04, 0x03, 0x80, 0xC3,
  0x00, 0xBF, 0x86, 0xEA, 0x9A, 0xCE, 0xF6, 0x80, 0xC3, 0x00, 0x20, 0xEF, 0xE0, 0x68, 0x0C, 0x40,
  0x04, 0xFE, 0x06, 0x80, 0xC5, 0x00, 0x20, 0xBF, 0xC0, 0x58, 0x0C, 0x70, 0x89, 0x12, 0x7B, 0xDE,
  0xFE, 0xCA, 0x61, 0x30,
  // "ą" (U+0105)
  0x74, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x4E, 0xDB, 0x85, 0x17, 0x77, 0x81, 0x17, 0xDF, 0xF0, 0xA0,
  0x37, 0x74, 0x07, 0xFF, 0xD0, 0x97, 0x72, 0x0C, 0xFF, 0xF0, 0xC0, 0x17, 0x60, 0xBF, 0xA8, 0x3D,
  0xA9, 0xAC, 0xFA, 0x0C, 0x75, 0x05, 0xF9, 0x0B, 0x02, 0x50, 0x10, 0x8F, 0x90, 0x87, 0x40, 0xBF,
  0x0B, 0x72, 0x05, 0xF0, 0xE0, 0x17, 0x30, 0xEF, 0x01, 0x73, 0x0B, 0xF0, 0x77, 0x3F, 0x0B, 0x74,
  0x05, 0xF0, 0xC7, 0x3F, 0x07, 0x74, 0x01, 0xF9, 0x73, 0x0B, 0xE0, 0x37, 0x50, 0xDF, 0x03, 0x72,
  0x05, 0xE0, 0x17, 0x50, 0xBF, 0x06, 0x73, 0x07, 0xD7, 0x60, 0x9F, 0x07, 0x74, 0x81, 0x39, 0xDA,
  0x76, 0x08, 0xF0, 0x87, 0x71, 0x01, 0x76, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77,
  0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x77, 0x71,
  0x07, 0xF0, 0x97, 0x77, 0x71, 0x07, 0xF0, 0x97, 0x71, 0x85, 0x15, 0x8A, 0xCD, 0xEF, 0xF9, 0x09,
  0x75, 0x81, 0x16, 0xCF, 0xFF, 0x90, 0x97, 0x40, 0x70, 0xEF, 0xFF, 0xB0, 0x97, 0x20, 0x10, 0xCF,
  0xFF, 0xD0, 0x97, 0x10, 0x10, 0xDF, 0xA8, 0x3D, 0x85, 0x21, 0x50, 0x5F, 0x09, 0x71, 0x0C, 0xF9,
  0x0D, 0x04, 0x73, 0x05, 0xF0, 0x97, 0x06, 0xF9, 0x0C, 0x01, 0x74, 0x05, 0xF0, 0x97, 0x0E, 0xF0,
  0xE0, 0x17, 0x50, 0x5F, 0x09, 0x60, 0x5F, 0x90, 0x67, 0x60, 0x5F, 0x09, 0x60, 0x9F, 0x0E, 0x77,
  0x05, 0xF0, 0x96, 0x0D, 0xF0, 0x97, 0x70, 0x5F, 0x09, 0x6F, 0x90, 0x67, 0x70, 0x6F, 0x09, 0x50,
  0x2F, 0x90, 0x37, 0x70, 0x7F, 0x09, 0x50, 0x3F, 0x90, 0x27, 0x70, 0x8F, 0x09, 0x50, 0x3F, 0x90,
  0x17, 0x70, 0xAF, 0x09, 0x50, 0x2F, 0x90, 0x17, 0x70, 0xDF, 0x09, 0x50, 0x1F, 0x90, 0x17, 0x60,
  0x1F, 0x90, 0x96, 0xF9, 0x03, 0x76, 0x07, 0xF9, 0x09, 0x60, 0xDF, 0x05, 0x76, 0x0D, 0xF9, 0x0A,
  0x60, 0xAF, 0x09, 0x75, 0x07, 0xFA, 0x0B, 0x60, 0x6F, 0x0E, 0x74, 0x83, 0x2E, 0xF6, 0xAE, 0x0D,
  0x60, 0x1F, 0x90, 0x67, 0x28, 0x41, 0xDF, 0xB0, 0x7F, 0x01, 0x60, 0xAF, 0x0E, 0x03, 0x78, 0x54,
  0xDF, 0xE1, 0x05, 0xF0, 0x96, 0x03, 0xFA, 0x08, 0x02, 0x28, 0x12, 0x5B, 0xB0, 0x52, 0x03, 0xF9,
  0x0A, 0x03, 0x50, 0x7F, 0xFB, 0x09, 0x4F, 0xC0, 0x94, 0x0A, 0xFF, 0x90, 0xA5, 0x0D, 0xFB, 0x09,
  0x50, 0x8F, 0xE0, 0xA6, 0x0B, 0xFB, 0x09, 0x60, 0x40, 0xCF, 0xA0, 0xE0, 0x67, 0x08, 0xFB, 0x09,
  0x71, 0x89, 0x04, 0x8C, 0xEF, 0xED, 0xA6, 0x17, 0x07, 0x0D, 0xB0, 0x80, 0x17, 0x77, 0x71, 0x04,
  0x0D, 0xB0, 0xD0, 0x27, 0x77, 0x72, 0x06, 0xC0, 0xC0, 0x17, 0x77, 0x72, 0x06, 0xC0, 0xD0, 0x17,
  0x77, 0x72, 0x04, 0xD0, 0x37, 0x77, 0x72, 0x01, 0x0E, 0xC0, 0x97, 0x77, 0x73, 0x08, 0xD0, 0x37,
  0x77, 0x73, 0x0E, 0xC0, 0xD7, 0x77, 0x73, 0x03, 0xD0, 0xA7, 0x77, 0x73, 0x07, 0xD0, 0x87, 0x77,
  0x73, 0x09, 0xD0, 0x77, 0x77, 0x73, 0x0A, 0xD0, 0x77, 0x77, 0x73, 0x09, 0xD0, 0x97, 0x77, 0x73,
  0x08, 0xD0, 0xD7, 0x77, 0x73, 0x05, 0xE0, 0x67, 0x77, 0x72, 0x01, 0xF0, 0x66, 0x04, 0x03, 0x77,
  0x71, 0x0B, 0xF8, 0x6E, 0xA9, 0xAC, 0xEF, 0x67, 0x77, 0x10, 0x20, 0xEF, 0xE0, 0x67, 0x77, 0x20,
  0x4F, 0xE0, 0x67, 0x77, 0x30, 0x20, 0xBF, 0xC0, 0x57, 0x77, 0x58, 0x91, 0x27, 0xBD, 0xEF, 0xEC,
  0xA6, 0x14,
  // "Ć" (U+0106)
  0x77, 0x76, 0x03, 0x80, 0x47, 0x04, 0x77, 0x77, 0x40, 0xBF, 0x90, 0x87, 0x77, 0x73, 0x02, 0xF9,
  0x0D, 0x01, 0x77, 0x77, 0x30, 0x9F, 0x90, 0x37, 0x77, 0x73, 0x01, 0xF9, 0x05, 0x77, 0x77, 0x40,
  0x9F, 0x08, 0x77, 0x77, 0x40, 0x2F, 0x0A, 0x77, 0x77, 0x50, 0xAE, 0x0B, 0x77, 0x77, 0x50, 0x4E,
  0x0B, 0x77, 0x77, 0x60, 0xCD, 0x0C, 0x77, 0x77, 0x60, 0x6D, 0x0C, 0x77, 0x77, 0x60, 0x10, 0xEC,
  0x0B, 0x77, 0x77, 0x70, 0x9C, 0x0A, 0x77, 0x77, 0x70, 0x3C, 0x09, 0x80, 0xC0, 0x00, 0x6B, 0x06,
  0x80, 0xB8, 0x70, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x73, 0x81, 0x28,
  0xEF, 0xF9, 0x0B, 0x06, 0x77, 0x60, 0x30, 0xBF, 0xFE, 0x0D, 0x04, 0x77, 0x30, 0x9F, 0xFF, 0xB0,
  0x97, 0x70, 0x20, 0xDF, 0xA8, 0x5E, 0xBA, 0x9A, 0xBE, 0xFB, 0x0B, 0x75, 0x03, 0x0E, 0xF8, 0x1E,
  0x82, 0x70, 0x50, 0xCF, 0xA0, 0x97, 0x30, 0x30, 0xEF, 0x09, 0x01, 0x74, 0x08, 0xFA, 0x03, 0x71,
  0x02, 0x0E, 0xF0, 0x67, 0x70, 0x8F, 0x90, 0xA7, 0x01, 0x0D, 0xF0, 0x67, 0x72, 0x0C, 0xF9, 0x70,
  0xAF, 0x09, 0x77, 0x30, 0x3F, 0x90, 0x25, 0x04, 0xF0, 0xD7, 0x75, 0x0C, 0xF0, 0x25, 0x0D, 0xF0,
  0x67, 0x75, 0x08, 0xF5, 0x07, 0xF0, 0xD7, 0x76, 0x04, 0xE0, 0xB5, 0x0E, 0xF0, 0x77, 0x76, 0x01,
  0xE0, 0x34, 0x05, 0xF9, 0x01, 0x77, 0x7C, 0x0E, 0x05, 0x50, 0xCF, 0x0C, 0x77, 0x71, 0x83, 0xDF,
  0xD9, 0x15, 0x02, 0xF9, 0x07, 0x77, 0x71, 0x02, 0x01, 0x71, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x40,
  0xCF, 0x0E, 0x77, 0x77, 0x40, 0x1F, 0x90, 0xC7, 0x77, 0x74, 0x05, 0xF9, 0x09, 0x77, 0x77, 0x40,
  0x8F, 0x90, 0x67, 0x77, 0x74, 0x0B, 0xF9, 0x04, 0x77, 0x77, 0x40, 0xEF, 0x90, 0x17, 0x77, 0x73,
  0x01, 0xFA, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xE7, 0x77, 0x74, 0x05, 0xF9, 0x0C, 0x77, 0x77, 0x40,
  0x6F, 0x90, 0xB7, 0x77, 0x74, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x8F, 0x90, 0xA7, 0x77, 0x74,
  0x09, 0xF9, 0x09, 0x77, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x0A, 0xF9, 0x09, 0x77, 0x77,
  0x40, 0xAF, 0x90, 0x97, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x77,
  0x74, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x40, 0x8F, 0x90, 0xB7, 0x77, 0x74, 0x06, 0xF9, 0x0C, 0x77,
  0x77, 0x40, 0x5F, 0x90, 0xD7, 0x77, 0x74, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0x1F, 0xA0, 0x17,
  0x77, 0x74, 0x0E, 0xF9, 0x03, 0x77, 0x77, 0x40, 0xBF, 0x90, 0x57, 0x77, 0x74, 0x08, 0xF9, 0x07,
  0x77, 0x77, 0x40, 0x5F, 0x90, 0xB7, 0x77, 0x74, 0x02, 0xF9, 0x0E, 0x77, 0x77, 0x50, 0xDF, 0x90,
  0x27, 0x77, 0x74, 0x08, 0xF9, 0x06, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xB7, 0x77, 0x75, 0x0D, 0xF9,
  0x01, 0x77, 0x77, 0x40, 0x7F, 0x90, 0x77, 0x77, 0x74, 0x01, 0xF9, 0x0D, 0x77, 0x77, 0x50, 0x9F,
  0x90, 0x57, 0x77, 0x40, 0xB0, 0x35, 0x01, 0x0E, 0xF0, 0xD7, 0x77, 0x38, 0x19, 0xFB, 0x60, 0x7F,
  0x90, 0x87, 0x77, 0x10, 0x6A, 0x0E, 0x70, 0xDF, 0x90, 0x47, 0x76, 0x05, 0xB0, 0xE7, 0x03, 0xF9,
  0x0E, 0x03, 0x77, 0x40, 0x7C, 0x0C, 0x71, 0x05, 0xFA, 0x06, 0x77, 0x20, 0x9D, 0x06, 0x72, 0x08,
  0xFA, 0x0B, 0x03, 0x75, 0x05, 0x0D, 0xD0, 0xD7, 0x40, 0x7F, 0xB8, 0x2C, 0x74, 0x13, 0x83, 0x13,
  0x69, 0xEF, 0x03, 0x75, 0x06, 0xFF, 0xFE, 0x04, 0x77, 0x03, 0x0D, 0xFF, 0xFA, 0x0D, 0x03, 0x77,
  0x30, 0x80, 0xEF, 0xFD, 0x0E, 0x07, 0x77, 0x68, 0x11, 0x7C, 0xFF, 0x98, 0x1C, 0x71, 0x77, 0x73,
  0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x5E, 0xEC, 0xB8, 0x52, 0x73,
  // "ć" (U+0107)
  0x77, 0x50, 0x38, 0x04, 0x70, 0x47, 0x77, 0x10, 0xBF, 0x90, 0x87, 0x77, 0x02, 0xF9, 0x0D, 0x01,
  0x77, 0x70, 0x9F, 0x90, 0x37, 0x77, 0x01, 0xF9, 0x05, 0x77, 0x71, 0x09, 0xF0, 0x87, 0x77, 0x10,
  0x2F, 0x0A, 0x77, 0x72, 0x0A, 0xE0, 0xB7, 0x77, 0x20, 0x4E, 0x0B, 0x77, 0x73, 0x0C, 0xD0, 0xC7,
  0x77, 0x30, 0x6D, 0x0C, 0x77, 0x73, 0x01, 0x0E, 0xC0, 0xB7, 0x77, 0x40, 0x9C, 0x0A, 0x77, 0x74,
  0x03, 0xC0, 0x97, 0x77, 0x50, 0x6B, 0x06, 0x80, 0xAE, 0x70, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC,
  0xA7, 0x37, 0x73, 0x81, 0x19, 0xEF, 0xD8, 0x1D, 0x81, 0x76, 0x08, 0xFF, 0xB0, 0xE0, 0x77, 0x30,
  0x20, 0xCF, 0xFE, 0x0B, 0x71, 0x01, 0x0D, 0xF9, 0x83, 0xEA, 0x9A, 0xDF, 0xA0, 0xA7, 0x0D, 0xF0,
  0xC0, 0x45, 0x04, 0x0D, 0xF9, 0x05, 0x50, 0x9F, 0x0A, 0x71, 0x01, 0x0E, 0xF0, 0xB4, 0x03, 0xF0,
  0xB7, 0x30, 0x7F, 0x90, 0x13, 0x0B, 0xF0, 0x27, 0x30, 0x1F, 0x90, 0x22, 0x04, 0xF0, 0x97, 0x50,
  0xBF, 0x03, 0x20, 0xAF, 0x02, 0x75, 0x08, 0xF8, 0x12, 0x01, 0xF0, 0xD7, 0x60, 0x5E, 0x0E, 0x20,
  0x5F, 0x08, 0x76, 0x03, 0xE0, 0x82, 0x0A, 0xF0, 0x57, 0x60, 0x2D, 0x0A, 0x30, 0xDF, 0x02, 0x76,
  0x84, 0x1E, 0xDB, 0x83, 0x30, 0x1F, 0x0E, 0x77, 0x72, 0x03, 0xF0, 0xC7, 0x77, 0x20, 0x6F, 0x0A,
  0x77, 0x72, 0x08, 0xF0, 0x97, 0x77, 0x20, 0x9F, 0x08, 0x77, 0x72, 0x0A, 0xF0, 0x77, 0x77, 0x20,
  0xBF, 0x06, 0x77, 0x72, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x57,
  0x77, 0x20, 0xDF, 0x05, 0x77, 0x72, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0xCF, 0x05, 0x77, 0x72, 0x0B,
  0xF0, 0x67, 0x77, 0x20, 0xAF, 0x07, 0x77, 0x72, 0x09, 0xF0, 0x87, 0x77, 0x20, 0x7F, 0x09, 0x77,
  0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x3F, 0x0D, 0x77, 0x73, 0xF9, 0x77, 0x73, 0x0C, 0xF0, 0x37,
  0x77, 0x20, 0x9F, 0x07, 0x77, 0x72, 0x04, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x02, 0x77, 0x40, 0x20,
  0x13, 0x09, 0xF0, 0x87, 0x74, 0x0B, 0x0A, 0x30, 0x2F, 0x0E, 0x01, 0x77, 0x20, 0x7A, 0x02, 0x30,
  0xAF, 0x09, 0x77, 0x10, 0x4B, 0x03, 0x30, 0x20, 0xEF, 0x06, 0x76, 0x04, 0x0E, 0xB0, 0x24, 0x06,
  0xF9, 0x07, 0x74, 0x07, 0xC0, 0xE6, 0x0A, 0xF9, 0x0B, 0x04, 0x70, 0x60, 0xCD, 0x07, 0x70, 0xBF,
  0xA8, 0x4E, 0xB9, 0x9A, 0xCF, 0x0C, 0x72, 0x09, 0xFF, 0xE0, 0xD0, 0x17, 0x30, 0x50, 0xDF, 0xFB,
  0x0A, 0x01, 0x76, 0x06, 0x0D, 0xFE, 0x0B, 0x03, 0x77, 0x38, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xDB,
  0x95, 0x17,
  // "Ĉ" (U+0108)
  0x77, 0x60, 0x58, 0x03, 0x70, 0x27, 0x77, 0x74, 0x01, 0x0E, 0xF0, 0xB7, 0x77, 0x74, 0x07, 0xFA,
  0x02, 0x77, 0x77, 0x20, 0x10, 0xEF, 0xA0, 0xA7, 0x77, 0x72, 0x08, 0xFC, 0x03, 0x77, 0x77, 0x02,
  0xFD, 0x0C, 0x77, 0x77, 0x0B, 0xD0, 0xC0, 0x5E, 0x05, 0x77, 0x75, 0x05, 0xD8, 0x2E, 0x20, 0x7D,
  0x0E, 0x01, 0x77, 0x74, 0x0D, 0xD0, 0x53, 0x0A, 0xD0, 0x97, 0x77, 0x30, 0x8D, 0x06, 0x50, 0xBD,
  0x03, 0x77, 0x71, 0x03, 0xD0, 0x87, 0x0C, 0xC0, 0xC7, 0x77, 0x10, 0xCC, 0x08, 0x71, 0x01, 0x0C,
  0xC0, 0x77, 0x76, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x02, 0x77, 0x40, 0x2C, 0x08, 0x75, 0x01,
  0x0C, 0xB0, 0xC7, 0x74, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB, 0x01, 0x80, 0xAF, 0x30, 0x84, 0x26,
  0x9B, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x73, 0x81, 0x28, 0xEF, 0xF9, 0x0B, 0x06, 0x77,
  0x60, 0x30, 0xBF, 0xFE, 0x0D, 0x04, 0x77, 0x30, 0x9F, 0xFF, 0xB0, 0x97, 0x70, 0x20, 0xDF, 0xA8,
  0x5E, 0xBA, 0x9A, 0xBE, 0xFB, 0x0B, 0x75, 0x03, 0x0E, 0xF8, 0x1E, 0x82, 0x70, 0x50, 0xCF, 0xA0,
  0x97, 0x30, 0x30, 0xEF, 0x09, 0x01, 0x74, 0x08, 0xFA, 0x03, 0x71, 0x02, 0x0E, 0xF0, 0x67, 0x70,
  0x8F, 0x90, 0xA7, 0x01, 0x0D, 0xF0, 0x67, 0x72, 0x0C, 0xF9, 0x70, 0xAF, 0x09, 0x77, 0x30, 0x3F,
  0x90, 0x25, 0x04, 0xF0, 0xD7, 0x75, 0x0C, 0xF0, 0x25, 0x0D, 0xF0, 0x67, 0x75, 0x08, 0xF5, 0x07,
  0xF0, 0xD7, 0x76, 0x04, 0xE0, 0xB5, 0x0E, 0xF0, 0x77, 0x76, 0x01, 0xE0, 0x34, 0x05, 0xF9, 0x01,
  0x77, 0x7C, 0x0E, 0x05, 0x50, 0xCF, 0x0C, 0x77, 0x71, 0x83, 0xDF, 0xD9, 0x15, 0x02, 0xF9, 0x07,
  0x77, 0x71, 0x02, 0x01, 0x71, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x40, 0xCF, 0x0E, 0x77, 0x77, 0x40,
  0x1F, 0x90, 0xC7, 0x77, 0x74, 0x05, 0xF9, 0x09, 0x77, 0x77, 0x40, 0x8F, 0x90, 0x67, 0x77, 0x74,
  0x0B, 0xF9, 0x04, 0x77, 0x77, 0x40, 0xEF, 0x90, 0x17, 0x77, 0x73, 0x01, 0xFA, 0x77, 0x77, 0x40,
  0x3F, 0x90, 0xE7, 0x77, 0x74, 0x05, 0xF9, 0x0C, 0x77, 0x77, 0x40, 0x6F, 0x90, 0xB7, 0x77, 0x74,
  0x08, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x8F, 0x90, 0xA7, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77,
  0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x0A, 0xF9, 0x09, 0x77, 0x77, 0x40, 0xAF, 0x90, 0x97, 0x77,
  0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x08, 0xF9, 0x0A, 0x77,
  0x77, 0x40, 0x8F, 0x90, 0xB7, 0x77, 0x74, 0x06, 0xF9, 0x0C, 0x77, 0x77, 0x40, 0x5F, 0x90, 0xD7,
  0x77, 0x74, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0x1F, 0xA0, 0x17, 0x77, 0x74, 0x0E, 0xF9, 0x03,
  0x77, 0x77, 0x40, 0xBF, 0x90, 0x57, 0x77, 0x74, 0x08, 0xF9, 0x07, 0x77, 0x77, 0x40, 0x5F, 0x90,
  0xB7, 0x77, 0x74, 0x02, 0xF9, 0x0E, 0x77, 0x77, 0x50, 0xDF, 0x90, 0x27, 0x77, 0x74, 0x08, 0xF9,
  0x06, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xB7, 0x77, 0x75, 0x0D, 0xF9, 0x01, 0x77, 0x77, 0x40, 0x7F,
  0x90, 0x77, 0x77, 0x74, 0x01, 0xF9, 0x0D, 0x77, 0x77, 0x50, 0x9F, 0x90, 0x57, 0x77, 0x40, 0xB0,
  0x35, 0x01, 0x0E, 0xF0, 0xD7, 0x77, 0x38, 0x19, 0xFB, 0x60, 0x7F, 0x90, 0x87, 0x77, 0x10, 0x6A,
  0x0E, 0x70, 0xDF, 0x90, 0x47, 0x76, 0x05, 0xB0, 0xE7, 0x03, 0xF9, 0x0E, 0x03, 0x77, 0x40, 0x7C,
  0x0C, 0x71, 0x05, 0xFA, 0x06, 0x77, 0x20, 0x9D, 0x06, 0x72, 0x08, 0xFA, 0x0B, 0x03, 0x75, 0x05,
  0x0D, 0xD0, 0xD7, 0x40, 0x7F, 0xB8, 0x2C, 0x74, 0x13, 0x83, 0x13, 0x69, 0xEF, 0x03, 0x75, 0x06,
  0xFF, 0xFE, 0x04, 0x77, 0x03, 0x0D, 0xFF, 0xFA, 0x0D, 0x03, 0x77, 0x30, 0x80, 0xEF, 0xFD, 0x0E,
  0x07, 0x77, 0x68, 0x11, 0x7C, 0xFF, 0x98, 0x1C, 0x71, 0x77, 0x73, 0x84, 0x26, 0x9B, 0xDE, 0xA8,
  0x5E, 0xEC, 0xB8, 0x52, 0x73,
  // "ĉ" (U+0109)
  0x76, 0x05, 0x80, 0x37, 0x02, 0x77, 0x71, 0x01, 0x0E, 0xF0, 0xB7, 0x77, 0x10, 0x7F, 0xA0, 0x27,
  0x76, 0x01, 0x0E, 0xFA, 0x0A, 0x77, 0x60, 0x8F, 0xC0, 0x37, 0x74, 0x02, 0xFD, 0x0C, 0x77, 0x40,
  0xBD, 0x0C, 0x05, 0xE0, 0x57, 0x72, 0x05, 0xD8, 0x2E, 0x20, 0x7D, 0x0E, 0x01, 0x77, 0x10, 0xDD,
  0x05, 0x30, 0xAD, 0x09, 0x77, 0x08, 0xD0, 0x65, 0x0B, 0xD0, 0x37, 0x50, 0x3D, 0x08, 0x70, 0xCC,
  0x0C, 0x75, 0x0C, 0xC0, 0x87, 0x10, 0x10, 0xCC, 0x07, 0x73, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC,
  0x02, 0x71, 0x02, 0xC0, 0x87, 0x50, 0x10, 0xCB, 0x0C, 0x71, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB,
  0x01, 0x80, 0xAD, 0x20, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x73, 0x81, 0x19, 0xEF,
  0xD8, 0x1D, 0x81, 0x76, 0x08, 0xFF, 0xB0, 0xE0, 0x77, 0x30, 0x20, 0xCF, 0xFE, 0x0B, 0x71, 0x01,
  0x0D, 0xF9, 0x83, 0xEA, 0x9A, 0xDF, 0xA0, 0xA7, 0x0D, 0xF0, 0xC0, 0x45, 0x04, 0x0D, 0xF9, 0x05,
  0x50, 0x9F, 0x0A, 0x71, 0x01, 0x0E, 0xF0, 0xB4, 0x03, 0xF0, 0xB7, 0x30, 0x7F, 0x90, 0x13, 0x0B,
  0xF0, 0x27, 0x30, 0x1F, 0x90, 0x22, 0x04, 0xF0, 0x97, 0x50, 0xBF, 0x03, 0x20, 0xAF, 0x02, 0x75,
  0x08, 0xF8, 0x12, 0x01, 0xF0, 0xD7, 0x60, 0x5E, 0x0E, 0x20, 0x5F, 0x08, 0x76, 0x03, 0xE0, 0x82,
  0x0A, 0xF0, 0x57, 0x60, 0x2D, 0x0A, 0x30, 0xDF, 0x02, 0x76, 0x84, 0x1E, 0xDB, 0x83, 0x30, 0x1F,
  0x0E, 0x77, 0x72, 0x03, 0xF0, 0xC7, 0x77, 0x20, 0x6F, 0x0A, 0x77, 0x72, 0x08, 0xF0, 0x97, 0x77,
  0x20, 0x9F, 0x08, 0x77, 0x72, 0x0A, 0xF0, 0x77, 0x77, 0x20, 0xBF, 0x06, 0x77, 0x72, 0x0C, 0xF0,
  0x57, 0x77, 0x20, 0xDF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x05, 0x77, 0x72,
  0x0C, 0xF0, 0x57, 0x77, 0x20, 0xCF, 0x05, 0x77, 0x72, 0x0B, 0xF0, 0x67, 0x77, 0x20, 0xAF, 0x07,
  0x77, 0x72, 0x09, 0xF0, 0x87, 0x77, 0x20, 0x7F, 0x09, 0x77, 0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20,
  0x3F, 0x0D, 0x77, 0x73, 0xF9, 0x77, 0x73, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0x9F, 0x07, 0x77, 0x72,
  0x04, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x02, 0x77, 0x40, 0x20, 0x13, 0x09, 0xF0, 0x87, 0x74, 0x0B,
  0x0A, 0x30, 0x2F, 0x0E, 0x01, 0x77, 0x20, 0x7A, 0x02, 0x30, 0xAF, 0x09, 0x77, 0x10, 0x4B, 0x03,
  0x30, 0x20, 0xEF, 0x06, 0x76, 0x04, 0x0E, 0xB0, 0x24, 0x06, 0xF9, 0x07, 0x74, 0x07, 0xC0, 0xE6,
  0x0A, 0xF9, 0x0B, 0x04, 0x70, 0x60, 0xCD, 0x07, 0x70, 0xBF, 0xA8, 0x4E, 0xB9, 0x9A, 0xCF, 0x0C,
  0x72, 0x09, 0xFF, 0xE0, 0xD0, 0x17, 0x30, 0x50, 0xDF, 0xFB, 0x0A, 0x01, 0x76, 0x06, 0x0D, 0xFE,
  0x0B, 0x03, 0x77, 0x38, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  // "Ċ" (U+010A)
  0x77, 0x71, 0x84, 0x3A, 0xEF, 0xD8, 0x77, 0x77, 0x70, 0x4E, 0x0D, 0x01, 0x77, 0x77, 0x50, 0xDF,
  0x09, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xE7, 0x77, 0x74, 0x05, 0xFA, 0x01, 0x77, 0x77, 0x30, 0x6F,
  0xA0, 0x17, 0x77, 0x73, 0x05, 0xFA, 0x01, 0x77, 0x77, 0x30, 0x3F, 0x90, 0xE7, 0x77, 0x75, 0x0D,
  0xF0, 0x97, 0x77, 0x75, 0x04, 0xE0, 0xD0, 0x17, 0x77, 0x76, 0x84, 0x3A, 0xEF, 0xD8, 0x80, 0xD8,
  0x20, 0x84, 0x26, 0x9B, 0xDE, 0xA8, 0x5E, 0xDC, 0xA8, 0x51, 0x77, 0x73, 0x81, 0x28, 0xEF, 0xF9,
  0x0B, 0x06, 0x77, 0x60, 0x30, 0xBF, 0xFE, 0x0D, 0x04, 0x77, 0x30, 0x9F, 0xFF, 0xB0, 0x97, 0x70,
  0x20, 0xDF, 0xA8, 0x5E, 0xBA, 0x9A, 0xBE, 0xFB, 0x0B, 0x75, 0x03, 0x0E, 0xF8, 0x1E, 0x82, 0x70,
  0x50, 0xCF, 0xA0, 0x97, 0x30, 0x30, 0xEF, 0x09, 0x01, 0x74, 0x08, 0xFA, 0x03, 0x71, 0x02, 0x0E,
  0xF0, 0x67, 0x70, 0x8F, 0x90, 0xA7, 0x01, 0x0D, 0xF0, 0x67, 0x72, 0x0C, 0xF9, 0x70, 0xAF, 0x09,
  0x77, 0x30, 0x3F, 0x90, 0x25, 0x04, 0xF0, 0xD7, 0x75, 0x0C, 0xF0, 0x25, 0x0D, 0xF0, 0x67, 0x75,
  0x08, 0xF5, 0x07, 0xF0, 0xD7, 0x76, 0x04, 0xE0, 0xB5, 0x0E, 0xF0, 0x77, 0x76, 0x01, 0xE0, 0x34,
  0x05, 0xF9, 0x01, 0x77, 0x7C, 0x0E, 0x05, 0x50, 0xCF, 0x0C, 0x77, 0x71, 0x83, 0xDF, 0xD9, 0x15,
  0x02, 0xF9, 0x07, 0x77, 0x71, 0x02, 0x01, 0x71, 0x07, 0xF9, 0x03, 0x77, 0x77, 0x40, 0xCF, 0x0E,
  0x77, 0x77, 0x40, 0x1F, 0x90, 0xC7, 0x77, 0x74, 0x05, 0xF9, 0x09, 0x77, 0x77, 0x40, 0x8F, 0x90,
  0x67, 0x77, 0x74, 0x0B, 0xF9, 0x04, 0x77, 0x77, 0x40, 0xEF, 0x90, 0x17, 0x77, 0x73, 0x01, 0xFA,
  0x77, 0x77, 0x40, 0x3F, 0x90, 0xE7, 0x77, 0x74, 0x05, 0xF9, 0x0C, 0x77, 0x77, 0x40, 0x6F, 0x90,
  0xB7, 0x77, 0x74, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x8F, 0x90, 0xA7, 0x77, 0x74, 0x09, 0xF9,
  0x09, 0x77, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x0A, 0xF9, 0x09, 0x77, 0x77, 0x40, 0xAF,
  0x90, 0x97, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x08,
  0xF9, 0x0A, 0x77, 0x77, 0x40, 0x8F, 0x90, 0xB7, 0x77, 0x74, 0x06, 0xF9, 0x0C, 0x77, 0x77, 0x40,
  0x5F, 0x90, 0xD7, 0x77, 0x74, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0x1F, 0xA0, 0x17, 0x77, 0x74,
  0x0E, 0xF9, 0x03, 0x77, 0x77, 0x40, 0xBF, 0x90, 0x57, 0x77, 0x74, 0x08, 0xF9, 0x07, 0x77, 0x77,
  0x40, 0x5F, 0x90, 0xB7, 0x77, 0x74, 0x02, 0xF9, 0x0E, 0x77, 0x77, 0x50, 0xDF, 0x90, 0x27, 0x77,
  0x74, 0x08, 0xF9, 0x06, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xB7, 0x77, 0x75, 0x0D, 0xF9, 0x01, 0x77,
  0x77, 0x40, 0x7F, 0x90, 0x77, 0x77, 0x74, 0x01, 0xF9, 0x0D, 0x77, 0x77, 0x50, 0x9F, 0x90, 0x57,
  0x77, 0x40, 0xB0, 0x35, 0x01, 0x0E, 0xF0, 0xD7, 0x77, 0x38, 0x19, 0xFB, 0x60, 0x7F, 0x90, 0x87,
  0x77, 0x10, 0x6A, 0x0E, 0x70, 0xDF, 0x90, 0x47, 0x76, 0x05, 0xB0, 0xE7, 0x03, 0xF9, 0x0E, 0x03,
  0x77, 0x40, 0x7C, 0x0C, 0x71, 0x05, 0xFA, 0x06, 0x77, 0x20, 0x9D, 0x06, 0x72, 0x08, 0xFA, 0x0B,
  0x03, 0x75, 0x05, 0x0D, 0xD0, 0xD7, 0x40, 0x7F, 0xB8, 0x2C, 0x74, 0x13, 0x83, 0x13, 0x69, 0xEF,
  0x03, 0x75, 0x06, 0xFF, 0xFE, 0x04, 0x77, 0x03, 0x0D, 0xFF, 0xFA, 0x0D, 0x03, 0x77, 0x30, 0x80,
  0xEF, 0xFD, 0x0E, 0x07, 0x77, 0x68, 0x11, 0x7C, 0xFF, 0x98, 0x1C, 0x71, 0x77, 0x73, 0x84, 0x26,
  0x9B, 0xDE, 0xA8, 0x5E, 0xEC, 0xB8, 0x52, 0x73,
  // "ċ" (U+010B)
  0x77, 0x18, 0x43, 0xAE, 0xFD, 0x87, 0x77, 0x40, 0x4E, 0x0D, 0x01, 0x77, 0x72, 0x0D, 0xF0, 0x97,
  0x77, 0x10, 0x3F, 0x90, 0xE7, 0x77, 0x10, 0x5F, 0xA0, 0x17, 0x77, 0x06, 0xFA, 0x01, 0x77, 0x70,
  0x5F, 0xA0, 0x17, 0x77, 0x03, 0xF9, 0x0E, 0x77, 0x72, 0x0D, 0xF0, 0x97, 0x77, 0x20, 0x4E, 0x0D,
  0x01, 0x77, 0x73, 0x84, 0x3A, 0xEF, 0xD8, 0x80, 0xCA, 0x30, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC,
  0xA7, 0x37, 0x73, 0x81, 0x19, 0xEF, 0xD8, 0x1D, 0x81, 0x76, 0x08, 0xFF, 0xB0, 0xE0, 0x77, 0x30,
  0x20, 0xCF, 0xFE, 0x0B, 0x71, 0x01, 0x0D, 0xF9, 0x83, 0xEA, 0x9A, 0xDF, 0xA0, 0xA7, 0x0D, 0xF0,
  0xC0, 0x45, 0x04, 0x0D, 0xF9, 0x05, 0x50, 0x9F, 0x0A, 0x71, 0x01, 0x0E, 0xF0, 0xB4, 0x03, 0xF0,
  0xB7, 0x30, 0x7F, 0x90, 0x13, 0x0B, 0xF0, 0x27, 0x30, 0x1F, 0x90, 0x22, 0x04, 0xF0, 0x97, 0x50,
  0xBF, 0x03, 0x20, 0xAF, 0x02, 0x75, 0x08, 0xF8, 0x12, 0x01, 0xF0, 0xD7, 0x60, 0x5E, 0x0E, 0x20,
  0x5F, 0x08, 0x76, 0x03, 0xE0, 0x82, 0x0A, 0xF0, 0x57, 0x60, 0x2D, 0x0A, 0x30, 0xDF, 0x02, 0x76,
  0x84, 0x1E, 0xDB, 0x83, 0x30, 0x1F, 0x0E, 0x77, 0x72, 0x03, 0xF0, 0xC7, 0x77, 0x20, 0x6F, 0x0A,
  0x77, 0x72, 0x08, 0xF0, 0x97, 0x77, 0x20, 0x9F, 0x08, 0x77, 0x72, 0x0A, 0xF0, 0x77, 0x77, 0x20,
  0xBF, 0x06, 0x77, 0x72, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x57,
  0x77, 0x20, 0xDF, 0x05, 0x77, 0x72, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0xCF, 0x05, 0x77, 0x72, 0x0B,
  0xF0, 0x67, 0x77, 0x20, 0xAF, 0x07, 0x77, 0x72, 0x09, 0xF0, 0x87, 0x77, 0x20, 0x7F, 0x09, 0x77,
  0x72, 0x05, 0xF0, 0xB7, 0x77, 0x20, 0x3F, 0x0D, 0x77, 0x73, 0xF9, 0x77, 0x73, 0x0C, 0xF0, 0x37,
  0x77, 0x20, 0x9F, 0x07, 0x77, 0x72, 0x04, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x02, 0x77, 0x40, 0x20,
  0x13, 0x09, 0xF0, 0x87, 0x74, 0x0B, 0x0A, 0x30, 0x2F, 0x0E, 0x01, 0x77, 0x20, 0x7A, 0x02, 0x30,
  0xAF, 0x09, 0x77, 0x10, 0x4B, 0x03, 0x30, 0x20, 0xEF, 0x06, 0x76, 0x04, 0x0E, 0xB0, 0x24, 0x06,
  0xF9, 0x07, 0x74, 0x07, 0xC0, 0xE6, 0x0A, 0xF9, 0x0B, 0x04, 0x70, 0x60, 0xCD, 0x07, 0x70, 0xBF,
  0xA8, 0x4E, 0xB9, 0x9A, 0xCF, 0x0C, 0x72, 0x09, 0xFF, 0xE0, 0xD0, 0x17, 0x30, 0x50, 0xDF, 0xFB,
  0x0A, 0x01, 0x76, 0x06, 0x0D, 0xFE, 0x0B, 0x03, 0x77, 0x38, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xDB,
  0x95, 0x17,
  // "Č" (U+010C)
  0x75, 0x83, 0x37, 0x77, 0x27, 0x71, 0x04, 0x0F, 0x77, 0x74, 0x06, 0xB0, 0xD0, 0x27, 0x60, 0x5C,
  0x01, 0x77, 0x30, 0x10, 0xDB, 0x0D, 0x02, 0x74, 0x05, 0xC0, 0x97, 0x75, 0x04, 0xC0, 0xD0, 0x17,
  0x20, 0x5C, 0x0D, 0x77, 0x70, 0x9C, 0x0D, 0x01, 0x70, 0x4D, 0x03, 0x77, 0x71, 0x0D, 0xC0, 0xC6,
  0x03, 0xD0, 0x97, 0x77, 0x20, 0x4D, 0x0B, 0x40, 0x20, 0xEC, 0x0D, 0x77, 0x74, 0x0A, 0xD0, 0x92,
  0x01, 0x0D, 0xD0, 0x57, 0x77, 0x40, 0x10, 0xED, 0x81, 0x50, 0xBD, 0x0B, 0x77, 0x76, 0x06, 0xD0,
  0xE0, 0x9E, 0x02, 0x77, 0x77, 0x0C, 0xFC, 0x07, 0x77, 0x77, 0x10, 0x4F, 0xB0, 0xD7, 0x77, 0x73,
  0x0B, 0xFA, 0x06, 0x77, 0x77, 0x30, 0x3F, 0x90, 0xE7, 0x77, 0x75, 0x0C, 0xF0, 0x78, 0x0B, 0x83,
  0x08, 0x42, 0x69, 0xBD, 0xEA, 0x85, 0xED, 0xCA, 0x85, 0x17, 0x77, 0x38, 0x12, 0x8E, 0xFF, 0x90,
  0xB0, 0x67, 0x76, 0x03, 0x0B, 0xFF, 0xE0, 0xD0, 0x47, 0x73, 0x09, 0xFF, 0xFB, 0x09, 0x77, 0x02,
  0x0D, 0xFA, 0x85, 0xEB, 0xA9, 0xAB, 0xEF, 0xB0, 0xB7, 0x50, 0x30, 0xEF, 0x81, 0xE8, 0x27, 0x05,
  0x0C, 0xFA, 0x09, 0x73, 0x03, 0x0E, 0xF0, 0x90, 0x17, 0x40, 0x8F, 0xA0, 0x37, 0x10, 0x20, 0xEF,
  0x06, 0x77, 0x08, 0xF9, 0x0A, 0x70, 0x10, 0xDF, 0x06, 0x77, 0x20, 0xCF, 0x97, 0x0A, 0xF0, 0x97,
  0x73, 0x03, 0xF9, 0x02, 0x50, 0x4F, 0x0D, 0x77, 0x50, 0xCF, 0x02, 0x50, 0xDF, 0x06, 0x77, 0x50,
  0x8F, 0x50, 0x7F, 0x0D, 0x77, 0x60, 0x4E, 0x0B, 0x50, 0xEF, 0x07, 0x77, 0x60, 0x1E, 0x03, 0x40,
  0x5F, 0x90, 0x17, 0x77, 0xC0, 0xE0, 0x55, 0x0C, 0xF0, 0xC7, 0x77, 0x18, 0x3D, 0xFD, 0x91, 0x50,
  0x2F, 0x90, 0x77, 0x77, 0x10, 0x20, 0x17, 0x10, 0x7F, 0x90, 0x37, 0x77, 0x74, 0x0C, 0xF0, 0xE7,
  0x77, 0x74, 0x01, 0xF9, 0x0C, 0x77, 0x77, 0x40, 0x5F, 0x90, 0x97, 0x77, 0x74, 0x08, 0xF9, 0x06,
  0x77, 0x77, 0x40, 0xBF, 0x90, 0x47, 0x77, 0x74, 0x0E, 0xF9, 0x01, 0x77, 0x77, 0x30, 0x1F, 0xA7,
  0x77, 0x74, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x40, 0x5F, 0x90, 0xC7, 0x77, 0x74, 0x06, 0xF9, 0x0B,
  0x77, 0x77, 0x40, 0x8F, 0x90, 0xB7, 0x77, 0x74, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x40, 0x9F, 0x90,
  0x97, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40, 0xAF, 0x90, 0x97, 0x77, 0x74, 0x0A, 0xF9,
  0x09, 0x77, 0x77, 0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x09, 0xF9, 0x09, 0x77, 0x77, 0x40, 0x8F,
  0x90, 0xA7, 0x77, 0x74, 0x08, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x6F, 0x90, 0xC7, 0x77, 0x74, 0x05,
  0xF9, 0x0D, 0x77, 0x77, 0x40, 0x3F, 0x90, 0xE7, 0x77, 0x74, 0x01, 0xFA, 0x01, 0x77, 0x77, 0x40,
  0xEF, 0x90, 0x37, 0x77, 0x74, 0x0B, 0xF9, 0x05, 0x77, 0x77, 0x40, 0x8F, 0x90, 0x77, 0x77, 0x74,
  0x05, 0xF9, 0x0B, 0x77, 0x77, 0x40, 0x2F, 0x90, 0xE7, 0x77, 0x75, 0x0D, 0xF9, 0x02, 0x77, 0x77,
  0x40, 0x8F, 0x90, 0x67, 0x77, 0x74, 0x03, 0xF9, 0x0B, 0x77, 0x77, 0x50, 0xDF, 0x90, 0x17, 0x77,
  0x74, 0x07, 0xF9, 0x07, 0x77, 0x77, 0x40, 0x1F, 0x90, 0xD7, 0x77, 0x75, 0x09, 0xF9, 0x05, 0x77,
  0x74, 0x0B, 0x03, 0x50, 0x10, 0xEF, 0x0D, 0x77, 0x73, 0x81, 0x9F, 0xB6, 0x07, 0xF9, 0x08, 0x77,
  0x71, 0x06, 0xA0, 0xE7, 0x0D, 0xF9, 0x04, 0x77, 0x60, 0x5B, 0x0E, 0x70, 0x3F, 0x90, 0xE0, 0x37,
  0x74, 0x07, 0xC0, 0xC7, 0x10, 0x5F, 0xA0, 0x67, 0x72, 0x09, 0xD0, 0x67, 0x20, 0x8F, 0xA0, 0xB0,
  0x37, 0x50, 0x50, 0xDD, 0x0D, 0x74, 0x07, 0xFB, 0x82, 0xC7, 0x41, 0x38, 0x31, 0x36, 0x9E, 0xF0,
  0x37, 0x50, 0x6F, 0xFF, 0xE0, 0x47, 0x70, 0x30, 0xDF, 0xFF, 0xA0, 0xD0, 0x37, 0x73, 0x08, 0x0E,
  0xFF, 0xD0, 0xE0, 0x77, 0x76, 0x81, 0x17, 0xCF, 0xF9, 0x81, 0xC7, 0x17, 0x77, 0x38, 0x42, 0x69,
  0xBD, 0xEA, 0x85, 0xEE, 0xCB, 0x85, 0x27, 0x30,
  // "č" (U+010D)
  0x58, 0x33, 0x77, 0x72, 0x77, 0x10, 0x40, 0xF7, 0x71, 0x06, 0xB0, 0xD0, 0x27, 0x60, 0x5C, 0x01,
  0x70, 0x10, 0xDB, 0x0D, 0x02, 0x74, 0x05, 0xC0, 0x97, 0x20, 0x4C, 0x0D, 0x01, 0x72, 0x05, 0xC0,
  0xD7, 0x40, 0x9C, 0x0D, 0x01, 0x70, 0x4D, 0x03, 0x75, 0x0D, 0xC0, 0xC6, 0x03, 0xD0, 0x97, 0x60,
  0x4D, 0x0B, 0x40, 0x20, 0xEC, 0x0D, 0x77, 0x10, 0xAD, 0x09, 0x20, 0x10, 0xDD, 0x05, 0x77, 0x10,
  0x10, 0xED, 0x81, 0x50, 0xBD, 0x0B, 0x77, 0x30, 0x6D, 0x0E, 0x09, 0xE0, 0x27, 0x74, 0x0C, 0xFC,
  0x07, 0x77, 0x50, 0x4F, 0xB0, 0xD7, 0x77, 0x0B, 0xFA, 0x06, 0x77, 0x70, 0x3F, 0x90, 0xE7, 0x77,
  0x20, 0xCF, 0x07, 0x80, 0xAE, 0x20, 0x89, 0x24, 0x8B, 0xDE, 0xFE, 0xDC, 0xA7, 0x37, 0x73, 0x81,
  0x19, 0xEF, 0xD8, 0x1D, 0x81, 0x76, 0x08, 0xFF, 0xB0, 0xE0, 0x77, 0x30, 0x20, 0xCF, 0xFE, 0x0B,
  0x71, 0x01, 0x0D, 0xF9, 0x83, 0xEA, 0x9A, 0xDF, 0xA0, 0xA7, 0x0D, 0xF0, 0xC0, 0x45, 0x04, 0x0D,
  0xF9, 0x05, 0x50, 0x9F, 0x0A, 0x71, 0x01, 0x0E, 0xF0, 0xB4, 0x03, 0xF0, 0xB7, 0x30, 0x7F, 0x90,
  0x13, 0x0B, 0xF0, 0x27, 0x30, 0x1F, 0x90, 0x22, 0x04, 0xF0, 0x97, 0x50, 0xBF, 0x03, 0x20, 0xAF,
  0x02, 0x75, 0x08, 0xF8, 0x12, 0x01, 0xF0, 0xD7, 0x60, 0x5E, 0x0E, 0x20, 0x5F, 0x08, 0x76, 0x03,
  0xE0, 0x82, 0x0A, 0xF0, 0x57, 0x60, 0x2D, 0x0A, 0x30, 0xDF, 0x02, 0x76, 0x84, 0x1E, 0xDB, 0x83,
  0x30, 0x1F, 0x0E, 0x77, 0x72, 0x03, 0xF0, 0xC7, 0x77, 0x20, 0x6F, 0x0A, 0x77, 0x72, 0x08, 0xF0,
  0x97, 0x77, 0x20, 0x9F, 0x08, 0x77, 0x72, 0x0A, 0xF0, 0x77, 0x77, 0x20, 0xBF, 0x06, 0x77, 0x72,
  0x0C, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x05, 0x77, 0x72, 0x0D, 0xF0, 0x57, 0x77, 0x20, 0xDF, 0x05,
  0x77, 0x72, 0x0C, 0xF0, 0x57, 0x77, 0x20, 0xCF, 0x05, 0x77, 0x72, 0x0B, 0xF0, 0x67, 0x77, 0x20,
  0xAF, 0x07, 0x77, 0x72, 0x09, 0xF0, 0x87, 0x77, 0x20, 0x7F, 0x09, 0x77, 0x72, 0x05, 0xF0, 0xB7,
  0x77, 0x20, 0x3F, 0x0D, 0x77, 0x73, 0xF9, 0x77, 0x73, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0x9F, 0x07,
  0x77, 0x72, 0x04, 0xF0, 0xC7, 0x77, 0x30, 0xEF, 0x02, 0x77, 0x40, 0x20, 0x13, 0x09, 0xF0, 0x87,
  0x74, 0x0B, 0x0A, 0x30, 0x2F, 0x0E, 0x01, 0x77, 0x20, 0x7A, 0x02, 0x30, 0xAF, 0x09, 0x77, 0x10,
  0x4B, 0x03, 0x30, 0x20, 0xEF, 0x06, 0x76, 0x04, 0x0E, 0xB0, 0x24, 0x06, 0xF9, 0x07, 0x74, 0x07,
  0xC0, 0xE6, 0x0A, 0xF9, 0x0B, 0x04, 0x70, 0x60, 0xCD, 0x07, 0x70, 0xBF, 0xA8, 0x4E, 0xB9, 0x9A,
  0xCF, 0x0C, 0x72, 0x09, 0xFF, 0xE0, 0xD0, 0x17, 0x30, 0x50, 0xDF, 0xFB, 0x0A, 0x01, 0x76, 0x06,
  0x0D, 0xFE, 0x0B, 0x03, 0x77, 0x38, 0x32, 0x7A, 0xDE, 0xA8, 0x4E, 0xDB, 0x95, 0x17,
  // "Ď" (U+010E)
  0x75, 0x83, 0x37, 0x77, 0x27, 0x71, 0x04, 0x0F, 0x77, 0x77, 0x50, 0x6B, 0x0D, 0x02, 0x76, 0x05,
  0xC0, 0x17, 0x77, 0x40, 0x10, 0xDB, 0x0D, 0x02, 0x74, 0x05, 0xC0, 0x97, 0x77, 0x60, 0x4C, 0x0D,
  0x01, 0x72, 0x05, 0xC0, 0xD7, 0x77, 0x71, 0x09, 0xC0, 0xD0, 0x17, 0x04, 0xD0, 0x37, 0x77, 0x72,
  0x0D, 0xC0, 0xC6, 0x03, 0xD0, 0x97, 0x77, 0x73, 0x04, 0xD0, 0xB4, 0x02, 0x0E, 0xC0, 0xD7, 0x77,
  0x75, 0x0A, 0xD0, 0x92, 0x01, 0x0D, 0xD0, 0x57, 0x77, 0x75, 0x01, 0x0E, 0xD8, 0x15, 0x0B, 0xD0,
  0xB7, 0x77, 0x77, 0x06, 0xD0, 0xE0, 0x9E, 0x02, 0x80, 0xC0, 0x00, 0xCF, 0xC0, 0x78, 0x0C, 0x10,
  0x04, 0xFB, 0x0D, 0x80, 0xC3, 0x00, 0xBF, 0xA0, 0x68, 0x0C, 0x30, 0x03, 0xF9, 0x0E, 0x80, 0xC5,
  0x00, 0xCF, 0x07, 0x80, 0xC9, 0x30, 0x03, 0xFF, 0xFB, 0x85, 0xEE, 0xDB, 0x96, 0x27, 0x74, 0x03,
  0xFF, 0xFF, 0xB8, 0x1E, 0x93, 0x77, 0x10, 0x3F, 0xFF, 0xFE, 0x0C, 0x04, 0x76, 0x81, 0x2D, 0xEF,
  0xFF, 0xFE, 0x0B, 0x01, 0x77, 0x10, 0x30, 0x8F, 0xB0, 0xD8, 0x03, 0x98, 0x1A, 0xCE, 0xFC, 0x0E,
  0x05, 0x77, 0x20, 0x30, 0xEF, 0x90, 0x97, 0x38, 0x12, 0x7C, 0xFB, 0x07, 0x77, 0x20, 0x7F, 0x90,
  0x97, 0x60, 0x40, 0xCF, 0xA0, 0x97, 0x71, 0x03, 0xF9, 0x09, 0x77, 0x10, 0x8F, 0xA0, 0x77, 0x71,
  0xF9, 0x09, 0x77, 0x20, 0x5F, 0xA0, 0x57, 0x70, 0xEF, 0x09, 0x77, 0x30, 0x5F, 0x90, 0xE0, 0x27,
  0x60, 0xEF, 0x09, 0x77, 0x40, 0x8F, 0x90, 0xC7, 0x60, 0xEF, 0x09, 0x77, 0x50, 0xCF, 0x90, 0x67,
  0x50, 0xEF, 0x09, 0x77, 0x50, 0x3F, 0x90, 0xE7, 0x50, 0xEF, 0x09, 0x77, 0x60, 0xAF, 0x90, 0x77,
  0x40, 0xEF, 0x09, 0x77, 0x60, 0x3F, 0x90, 0xD7, 0x40, 0xEF, 0x09, 0x77, 0x70, 0xCF, 0x90, 0x57,
  0x30, 0xEF, 0x09, 0x77, 0x70, 0x7F, 0x90, 0xA7, 0x30, 0xEF, 0x09, 0x77, 0x70, 0x1F, 0xA7, 0x30,
  0xEF, 0x09, 0x77, 0x71, 0x0C, 0xF9, 0x05, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x8F, 0x90, 0x97,
  0x20, 0xEF, 0x09, 0x77, 0x71, 0x05, 0xF9, 0x0C, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x2F, 0xA7,
  0x20, 0xEF, 0x09, 0x77, 0x72, 0x0E, 0xF9, 0x03, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0xCF, 0x90,
  0x57, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x0A, 0xF9, 0x08, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x8F,
  0x90, 0xA7, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x07, 0xF9, 0x0B, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20,
  0x6F, 0x90, 0xD7, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x0E, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x20, 0x4F, 0x90, 0xE7, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x04, 0xFA, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x20, 0x4F, 0xA7, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x04, 0xFA, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20,
  0x4F, 0x90, 0xE7, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x04, 0xF9, 0x0E, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x20, 0x5F, 0x90, 0xD7, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x06, 0xF9, 0x0D, 0x71, 0x0E, 0xF0, 0x97,
  0x77, 0x20, 0x7F, 0x90, 0xB7, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x08, 0xF9, 0x09, 0x71, 0x0E, 0xF0,
  0x97, 0x77, 0x20, 0xAF, 0x90, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x0C, 0xF9, 0x05, 0x71, 0x0E,
  0xF0, 0x97, 0x77, 0x20, 0xEF, 0x90, 0x37, 0x10, 0xEF, 0x09, 0x77, 0x71, 0x02, 0xFA, 0x72, 0x0E,
  0xF0, 0x97, 0x77, 0x10, 0x4F, 0x90, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x71, 0x08, 0xF9, 0x09, 0x72,
  0x0E, 0xF0, 0x97, 0x77, 0x10, 0xCF, 0x90, 0x57, 0x20, 0xEF, 0x09, 0x77, 0x70, 0x1F, 0x90, 0xE7,
  0x30, 0xEF, 0x09, 0x77, 0x70, 0x6F, 0x90, 0xA7, 0x30, 0xEF, 0x09, 0x77, 0x70, 0xCF, 0x90, 0x57,
  0x30, 0xEF, 0x09, 0x77, 0x60, 0x3F, 0x90, 0xE7, 0x40, 0xEF, 0x09, 0x77, 0x60, 0xAF, 0x90, 0x77,
  0x40, 0xEF, 0x09, 0x77, 0x50, 0x3F, 0x90, 0xE0, 0x17, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xCF, 0x90,
  0x77, 0x50, 0xEF, 0x09, 0x77, 0x40, 0x8F, 0x90, 0xD7, 0x60, 0xEF, 0x09, 0x77, 0x30, 0x5F, 0xA0,
  0x37, 0x6F, 0x90, 0x97, 0x72, 0x05, 0xFA, 0x08, 0x76, 0x03, 0xF9, 0x09, 0x77, 0x10, 0x7F, 0xA0,
  0xA7, 0x70, 0x7F, 0x90, 0x97, 0x60, 0x40, 0xCF, 0xA0, 0xB7, 0x70, 0x20, 0xEF, 0x90, 0x97, 0x38,
  0x12, 0x7C, 0xFB, 0x0A, 0x76, 0x81, 0x16, 0xEF, 0xA0, 0xD8, 0x03, 0x98, 0x1A, 0xCE, 0xFD, 0x07,
  0x73, 0x82, 0x2C, 0xCD, 0xFF, 0xFF, 0xD0, 0xC0, 0x37, 0x40, 0x3F, 0xFF, 0xFE, 0x0D, 0x05, 0x76,
  0x03, 0xFF, 0xFF, 0xB8, 0x1E, 0x94, 0x77, 0x10, 0x3F, 0xFF, 0xB8, 0x5E, 0xDC, 0xB9, 0x63, 0x77,
  0x40,
  // "ď" (U+010F)
  0x77, 0x60, 0x6F, 0xF0, 0x66, 0x0E, 0xE0, 0x27, 0x76, 0x06, 0xFF, 0x06, 0x50, 0x1E, 0x0E, 0x77,
  0x70, 0x6F, 0xF0, 0x65, 0x04, 0xE0, 0x87, 0x77, 0x06, 0xFF, 0x06, 0x50, 0x7E, 0x01, 0x77, 0x72,
  0x82, 0x14, 0x8E, 0xFA, 0x06, 0x50, 0xAD, 0x0A, 0x77, 0x76, 0x01, 0x0C, 0xF9, 0x06, 0x50, 0xDD,
  0x02, 0x77, 0x77, 0x02, 0xF9, 0x06, 0x5D, 0x0A, 0x77, 0x77, 0x20, 0xCF, 0x06, 0x40, 0x3D, 0x02,
  0x77, 0x77, 0x20, 0x9F, 0x06, 0x40, 0x6C, 0x09, 0x77, 0x77, 0x30, 0x8F, 0x06, 0x40, 0x9C, 0x02,
  0x77, 0x77, 0x30, 0x7F, 0x06, 0x40, 0xDB, 0x09, 0x77, 0x77, 0x40, 0x7F, 0x06, 0x4B, 0x0E, 0x01,
  0x77, 0x77, 0x40, 0x7F, 0x06, 0x30, 0x3B, 0x07, 0x77, 0x77, 0x50, 0x7F, 0x06, 0x30, 0x5A, 0x0D,
  0x77, 0x77, 0x60, 0x7F, 0x06, 0x80, 0xC5, 0x00, 0x7F, 0x06, 0x80, 0xC5, 0x00, 0x7F, 0x06, 0x80,
  0xC5, 0x00, 0x7F, 0x06, 0x80, 0xC5, 0x00, 0x7F, 0x06, 0x77, 0x73, 0x89, 0x11, 0x6A, 0xCE, 0xFE,
  0xDB, 0x83, 0x60, 0x7F, 0x06, 0x77, 0x71, 0x02, 0x0A, 0xFC, 0x0C, 0x03, 0x40, 0x7F, 0x06, 0x77,
  0x70, 0x7F, 0xF9, 0x07, 0x30, 0x7F, 0x06, 0x77, 0x60, 0xAF, 0xFB, 0x08, 0x20, 0x6F, 0x06, 0x77,
  0x50, 0xAF, 0xA8, 0x3C, 0xA9, 0xAC, 0xD8, 0x16, 0x06, 0xF0, 0x67, 0x74, 0x07, 0xF9, 0x0B, 0x02,
  0x50, 0x10, 0x8C, 0x02, 0x05, 0xF0, 0x67, 0x73, 0x03, 0xF9, 0x08, 0x72, 0x03, 0x0D, 0xA0, 0xC0,
  0x4F, 0x06, 0x77, 0x30, 0xBF, 0x0A, 0x74, 0x02, 0x0E, 0xA0, 0xBF, 0x06, 0x77, 0x20, 0x3F, 0x0E,
  0x01, 0x75, 0x06, 0xFB, 0x06, 0x77, 0x20, 0xAF, 0x08, 0x77, 0x0D, 0xFA, 0x06, 0x77, 0x2F, 0x90,
  0x27, 0x70, 0x7F, 0xA0, 0x67, 0x71, 0x05, 0xF0, 0xD7, 0x71, 0x02, 0xFA, 0x06, 0x77, 0x10, 0x9F,
  0x08, 0x77, 0x20, 0xDF, 0x90, 0x67, 0x71, 0x0D, 0xF0, 0x57, 0x72, 0x09, 0xF9, 0x06, 0x77, 0x01,
  0xF9, 0x02, 0x77, 0x20, 0x5F, 0x90, 0x67, 0x70, 0x3F, 0x97, 0x73, 0x03, 0xF9, 0x06, 0x77, 0x06,
  0xF0, 0xC7, 0x74, 0xF9, 0x06, 0x77, 0x08, 0xF0, 0xB7, 0x74, 0x0E, 0xF0, 0x67, 0x70, 0xAF, 0x09,
  0x77, 0x40, 0xCF, 0x06, 0x77, 0x0B, 0xF0, 0x87, 0x74, 0x0B, 0xF0, 0x67, 0x70, 0xCF, 0x07, 0x77,
  0x40, 0x9F, 0x06, 0x77, 0x0D, 0xF0, 0x67, 0x74, 0x09, 0xF0, 0x67, 0x70, 0xEF, 0x05, 0x77, 0x40,
  0x8F, 0x06, 0x77, 0x0E, 0xF0, 0x57, 0x74, 0x08, 0xF0, 0x67, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x7F,
  0x06, 0x77, 0x0E, 0xF0, 0x57, 0x74, 0x07, 0xF0, 0x67, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x8F, 0x06,
  0x77, 0x0E, 0xF0, 0x57, 0x74, 0x08, 0xF0, 0x67, 0x70, 0xDF, 0x06, 0x77, 0x40, 0x9F, 0x06, 0x77,
  0x0C, 0xF0, 0x67, 0x74, 0x09, 0xF0, 0x67, 0x70, 0xBF, 0x07, 0x77, 0x40, 0xBF, 0x06, 0x77, 0x0A,
  0xF0, 0x87, 0x74, 0x0C, 0xF0, 0x67, 0x70, 0x8F, 0x0A, 0x77, 0x40, 0xEF, 0x06, 0x77, 0x06, 0xF0,
  0xC7, 0x73, 0x01, 0xF9, 0x06, 0x77, 0x04, 0xF0, 0xE7, 0x73, 0x03, 0xF9, 0x06, 0x77, 0x01, 0xF9,
  0x01, 0x77, 0x20, 0x6F, 0x90, 0x67, 0x71, 0x0D, 0xF0, 0x47, 0x72, 0x0A, 0xF9, 0x06, 0x77, 0x10,
  0xAF, 0x07, 0x77, 0x20, 0xEF, 0x90, 0x67, 0x71, 0x06, 0xF0, 0xC7, 0x71, 0x03, 0xFA, 0x06, 0x77,
  0x10, 0x1F, 0x90, 0x17, 0x70, 0x9F, 0xA0, 0x77, 0x72, 0x0B, 0xF0, 0x77, 0x60, 0x10, 0xEF, 0xA0,
  0x87, 0x72, 0x04, 0xF0, 0xE7, 0x60, 0x8A, 0x0B, 0xF0, 0xB7, 0x73, 0x0C, 0xF0, 0x97, 0x40, 0x4A,
  0x0E, 0x01, 0xF9, 0x01, 0x77, 0x20, 0x4F, 0x90, 0x77, 0x20, 0x40, 0xEA, 0x81, 0x70, 0xDF, 0x0B,
  0x77, 0x30, 0x9F, 0x90, 0xA0, 0x25, 0x02, 0x09, 0xB0, 0xC2, 0x0C, 0xF9, 0x81, 0xD7, 0x37, 0x71,
  0x0C, 0xFA, 0x83, 0xCA, 0x9A, 0xCC, 0x0E, 0x02, 0x20, 0xAF, 0xE0, 0x47, 0x50, 0x10, 0xCF, 0xFA,
  0x0E, 0x03, 0x30, 0x8F, 0xE0, 0x47, 0x70, 0x9F, 0xF0, 0xE0, 0x34, 0x06, 0xFE, 0x04, 0x77, 0x10,
  0x30, 0xBF, 0xC0, 0xA0, 0x15, 0x04, 0xFE, 0x04, 0x77, 0x38, 0x91, 0x27, 0xAD, 0xEF, 0xED, 0xA7,
  0x17, 0x77, 0x71,
  // "Đ" (U+0110)
  0x03, 0xFF, 0xFB, 0x85, 0xEE, 0xDB, 0x96, 0x27, 0x74, 0x03, 0xFF, 0xFF, 0xB8, 0x1E, 0x93, 0x77,
  0x10, 0x3F, 0xFF, 0xFE, 0x0C, 0x04, 0x76, 0x81, 0x2D, 0xEF, 0xFF, 0xFE, 0x0B, 0x02, 0x77, 0x18,
  0x13, 0x8E, 0xFA, 0x0D, 0x80, 0x39, 0x81, 0xAC, 0xEF, 0xC0, 0xE0, 0x67, 0x72, 0x02, 0x0E, 0xF9,
  0x09, 0x73, 0x81, 0x27, 0xCF, 0xB0, 0x87, 0x72, 0x06, 0xF9, 0x09, 0x76, 0x04, 0x0C, 0xFA, 0x0A,
  0x77, 0x10, 0x1F, 0x90, 0x97, 0x71, 0x08, 0xFA, 0x08, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x20, 0x5F,
  0xA0, 0x67, 0x70, 0xDF, 0x09, 0x77, 0x30, 0x5F, 0xA0, 0x27, 0x60, 0xCF, 0x09, 0x77, 0x40, 0x8F,
  0x90, 0xC7, 0x60, 0xCF, 0x09, 0x77, 0x50, 0xCF, 0x90, 0x67, 0x50, 0xCF, 0x09, 0x77, 0x50, 0x3F,
  0x90, 0xE7, 0x50, 0xCF, 0x09, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x40, 0xCF, 0x09, 0x77, 0x60, 0x3F,
  0x90, 0xD7, 0x40, 0xCF, 0x09, 0x77, 0x70, 0xCF, 0x90, 0x57, 0x30, 0xCF, 0x09, 0x77, 0x70, 0x7F,
  0x90, 0xA7, 0x30, 0xCF, 0x09, 0x77, 0x70, 0x1F, 0xA7, 0x30, 0xCF, 0x09, 0x77, 0x71, 0x0C, 0xF9,
  0x05, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0x8F, 0x90, 0x97, 0x20, 0xCF, 0x09, 0x77, 0x71, 0x05,
  0xF9, 0x0C, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0x2F, 0xA0, 0x17, 0x10, 0xCF, 0x09, 0x77, 0x72,
  0x0E, 0xF9, 0x03, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xCF, 0x90, 0x67, 0x10, 0xCF, 0x09, 0x77,
  0x72, 0x0A, 0xF9, 0x08, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x8F, 0x90, 0xA7, 0x10, 0xCF, 0x09,
  0x77, 0x72, 0x07, 0xF9, 0x0B, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x6F, 0x90, 0xD1, 0xFF, 0xFF,
  0x74, 0x05, 0xF9, 0x0E, 0x1F, 0xFF, 0xF7, 0x40, 0x4F, 0x90, 0xE1, 0xFF, 0xFF, 0x74, 0x04, 0xFA,
  0x1F, 0xFF, 0xF7, 0x40, 0x4F, 0xA1, 0x80, 0x39, 0x0E, 0xF0, 0xD8, 0x09, 0x09, 0x74, 0x04, 0xFA,
  0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x4F, 0x90, 0xE7, 0x10, 0xCF, 0x09, 0x77, 0x72, 0x04, 0xF9,
  0x0E, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0xD7, 0x10, 0xCF, 0x09, 0x77, 0x72, 0x06,
  0xF9, 0x0D, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0x7F, 0x90, 0xB7, 0x10, 0xCF, 0x09, 0x77, 0x72,
  0x08, 0xF9, 0x09, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xAF, 0x90, 0x77, 0x10, 0xCF, 0x09, 0x77,
  0x72, 0x0C, 0xF9, 0x05, 0x71, 0x0C, 0xF0, 0x97, 0x77, 0x20, 0xEF, 0x90, 0x37, 0x10, 0xCF, 0x09,
  0x77, 0x71, 0x02, 0xFA, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0x4F, 0x90, 0xC7, 0x20, 0xCF, 0x09,
  0x77, 0x71, 0x08, 0xF9, 0x09, 0x72, 0x0C, 0xF0, 0x97, 0x77, 0x10, 0xCF, 0x90, 0x57, 0x20, 0xCF,
  0x09, 0x77, 0x70, 0x1F, 0x90, 0xE7, 0x30, 0xCF, 0x09, 0x77, 0x70, 0x6F, 0x90, 0xA7, 0x30, 0xCF,
  0x09, 0x77, 0x70, 0xCF, 0x90, 0x57, 0x30, 0xCF, 0x09, 0x77, 0x60, 0x3F, 0x90, 0xE7, 0x40, 0xCF,
  0x09, 0x77, 0x60, 0xAF, 0x90, 0x77, 0x40, 0xCF, 0x09, 0x77, 0x50, 0x3F, 0x90, 0xE0, 0x17, 0x40,
  0xCF, 0x09, 0x77, 0x50, 0xCF, 0x90, 0x77, 0x50, 0xCF, 0x09, 0x77, 0x40, 0x7F, 0x90, 0xD7, 0x60,
  0xDF, 0x09, 0x77, 0x30, 0x5F, 0xA0, 0x37, 0x60, 0xEF, 0x09, 0x77, 0x20, 0x5F, 0xA0, 0x87, 0x60,
  0x1F, 0x90, 0x97, 0x71, 0x07, 0xFA, 0x0A, 0x77, 0x06, 0xF9, 0x09, 0x76, 0x03, 0x0C, 0xFA, 0x0B,
  0x77, 0x01, 0x0E, 0xF9, 0x09, 0x73, 0x81, 0x26, 0xCF, 0xB0, 0xA7, 0x68, 0x11, 0x6E, 0xFA, 0x0D,
  0x80, 0x39, 0x81, 0xAB, 0xEF, 0xD0, 0x77, 0x38, 0x22, 0xCC, 0xDF, 0xFF, 0xFD, 0x0C, 0x03, 0x74,
  0x03, 0xFF, 0xFF, 0xE0, 0xD0, 0x57, 0x60, 0x3F, 0xFF, 0xFB, 0x81, 0xE9, 0x47, 0x71, 0x03, 0xFF,
  0xFB, 0x85, 0xED, 0xCB, 0x96, 0x37, 0x74,
  // "đ" (U+0111)
  0x77, 0x60, 0x6F, 0xF0, 0x67, 0x77, 0x60, 0x6F, 0xF0, 0x67, 0x77, 0x60, 0x6F, 0xF0, 0x67, 0x77,
  0x60, 0x6F, 0xF0, 0x67, 0x77, 0x71, 0x82, 0x14, 0x9E, 0xFA, 0x06, 0x77, 0x77, 0x40, 0x10, 0xCF,
  0x90, 0x67, 0x77, 0x75, 0x02, 0xF9, 0x06, 0x77, 0x77, 0x60, 0xCF, 0x06, 0x77, 0x77, 0x60, 0x9F,
  0x06, 0x77, 0x77, 0x60, 0x8F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x70, 0x7F, 0xFF, 0xE0,
  0x47, 0x70, 0x7F, 0xFF, 0xE0, 0x47, 0x70, 0x7F, 0xFF, 0xE0, 0x47, 0x70, 0x7F, 0xFF, 0xE0, 0x47,
  0x77, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x77,
  0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0x7F, 0x06, 0x77, 0x38, 0x91,
  0x26, 0xAD, 0xEF, 0xED, 0xB8, 0x26, 0x07, 0xF0, 0x67, 0x71, 0x03, 0x0B, 0xFC, 0x0B, 0x02, 0x40,
  0x7F, 0x06, 0x77, 0x09, 0xFF, 0x90, 0x53, 0x06, 0xF0, 0x67, 0x50, 0x10, 0xCF, 0xFB, 0x06, 0x20,
  0x6F, 0x06, 0x75, 0x0C, 0xFA, 0x83, 0xCA, 0x9A, 0xCD, 0x81, 0x40, 0x5F, 0x06, 0x74, 0x0A, 0xF9,
  0x0A, 0x02, 0x58, 0x11, 0x8E, 0xA8, 0x1E, 0x15, 0xF0, 0x67, 0x30, 0x4F, 0x90, 0x67, 0x20, 0x20,
  0xDA, 0x09, 0x04, 0xF0, 0x67, 0x30, 0xDF, 0x08, 0x74, 0x02, 0x0E, 0xA0, 0x8F, 0x06, 0x72, 0x05,
  0xF0, 0xD7, 0x60, 0x5F, 0xB0, 0x67, 0x20, 0xCF, 0x07, 0x77, 0x0D, 0xFA, 0x06, 0x71, 0x02, 0xF9,
  0x01, 0x77, 0x07, 0xFA, 0x06, 0x71, 0x07, 0xF0, 0xB7, 0x71, 0x02, 0xFA, 0x06, 0x71, 0x0B, 0xF0,
  0x77, 0x72, 0x0C, 0xF9, 0x06, 0x71, 0x0E, 0xF0, 0x37, 0x72, 0x08, 0xF9, 0x06, 0x70, 0x2F, 0x97,
  0x73, 0x05, 0xF9, 0x06, 0x70, 0x5F, 0x0D, 0x77, 0x30, 0x2F, 0x90, 0x67, 0x07, 0xF0, 0xB7, 0x74,
  0xF9, 0x06, 0x70, 0x9F, 0x09, 0x77, 0x40, 0xDF, 0x06, 0x70, 0xBF, 0x08, 0x77, 0x40, 0xCF, 0x06,
  0x70, 0xCF, 0x07, 0x77, 0x40, 0xAF, 0x06, 0x70, 0xDF, 0x06, 0x77, 0x40, 0x9F, 0x06, 0x70, 0xDF,
  0x05, 0x77, 0x40, 0x9F, 0x06, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x8F, 0x06, 0x70, 0xEF, 0x05, 0x77,
  0x40, 0x8F, 0x06, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x7F, 0x06, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x8F,
  0x06, 0x70, 0xEF, 0x05, 0x77, 0x40, 0x9F, 0x06, 0x70, 0xDF, 0x06, 0x77, 0x40, 0x9F, 0x06, 0x70,
  0xCF, 0x06, 0x77, 0x40, 0xAF, 0x06, 0x70, 0xBF, 0x07, 0x77, 0x40, 0xBF, 0x06, 0x70, 0x9F, 0x09,
  0x77, 0x40, 0xDF, 0x06, 0x70, 0x7F, 0x0B, 0x77, 0x4F, 0x90, 0x67, 0x05, 0xF0, 0xD7, 0x73, 0x01,
  0xF9, 0x06, 0x70, 0x2F, 0x97, 0x73, 0x04, 0xF9, 0x06, 0x71, 0xF9, 0x02, 0x77, 0x20, 0x8F, 0x90,
  0x67, 0x10, 0xBF, 0x06, 0x77, 0x20, 0xBF, 0x90, 0x67, 0x10, 0x7F, 0x0A, 0x77, 0x10, 0x1F, 0xA0,
  0x67, 0x10, 0x2F, 0x0E, 0x77, 0x10, 0x6F, 0xA0, 0x77, 0x20, 0xCF, 0x06, 0x77, 0x0C, 0xFA, 0x08,
  0x72, 0x06, 0xF0, 0xD7, 0x60, 0x4A, 0x0C, 0xF0, 0xB7, 0x30, 0xEF, 0x08, 0x74, 0x83, 0x1D, 0xFE,
  0x1F, 0x90, 0x17, 0x20, 0x5F, 0x90, 0x67, 0x20, 0x10, 0xCA, 0x81, 0x70, 0xDF, 0x0B, 0x73, 0x0A,
  0xF9, 0x0A, 0x02, 0x58, 0x11, 0x7E, 0xA0, 0xC2, 0x0C, 0xF9, 0x81, 0xD7, 0x37, 0x10, 0xCF, 0xA8,
  0x3C, 0xA9, 0xAC, 0xC0, 0xE0, 0x22, 0x0A, 0xFE, 0x04, 0x50, 0x10, 0xCF, 0xFB, 0x04, 0x30, 0x8F,
  0xE0, 0x47, 0x09, 0xFF, 0x0E, 0x03, 0x40, 0x6F, 0xE0, 0x47, 0x10, 0x30, 0xBF, 0xC0, 0xA0, 0x15,
  0x04, 0xFE, 0x04, 0x73, 0x89, 0x12, 0x7A, 0xDE, 0xFE, 0xDB, 0x72, 0x77, 0x71,
  // "Ē" (U+0112)
  0x74, 0x03, 0x80, 0xA1, 0x90, 0x77, 0x77, 0x06, 0xFF, 0xF0, 0xC7, 0x77, 0x06, 0xFF, 0xF0, 0xC7,
  0x77, 0x06, 0xFF, 0xF0, 0xC7, 0x77, 0x06, 0xFF, 0xF0, 0xC8, 0x0C, 0x96, 0x00, 0x38, 0x0C, 0x3F,
  0x03, 0x30, 0x38, 0x0C, 0x3F, 0x03, 0x30, 0x38, 0x0C, 0x3F, 0x04, 0x38, 0x12, 0xDE, 0x80, 0xC1,
  0xF0, 0x47, 0x03, 0x08, 0xFB, 0x0D, 0x80, 0x91, 0x90, 0xB0, 0xEF, 0x90, 0x57, 0x20, 0x30, 0xEF,
  0x90, 0x97, 0x71, 0x05, 0x0E, 0xE0, 0x57, 0x30, 0x8F, 0x90, 0x97, 0x72, 0x02, 0x0E, 0xD0, 0x67,
  0x30, 0x3F, 0x90, 0x97, 0x73, 0x06, 0xD0, 0x67, 0x4F, 0x90, 0x97, 0x74, 0x0D, 0xC0, 0x77, 0x4F,
  0x90, 0x97, 0x74, 0x08, 0xC0, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x40, 0x4C, 0x07, 0x74, 0x0E, 0xF0,
  0x97, 0x74, 0x02, 0xC0, 0x87, 0x40, 0xEF, 0x09, 0x77, 0x5C, 0x08, 0x74, 0x0E, 0xF0, 0x97, 0x75,
  0x0E, 0xB0, 0x97, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xCB, 0x09, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0x83,
  0x58, 0x88, 0x57, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD,
  0x77, 0x30, 0xEF, 0x0D, 0x80, 0x96, 0x97, 0x73, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x84, 0x2B, 0xBB, 0xB1, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x04, 0xC0, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x6C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x08,
  0xC0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0xAC, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x0E, 0xC7, 0x20,
  0xEF, 0x09, 0x77, 0x60, 0x3D, 0x72, 0xF9, 0x09, 0x77, 0x60, 0xAC, 0x0E, 0x71, 0x02, 0xF9, 0x09,
  0x77, 0x50, 0x3D, 0x0D, 0x71, 0x06, 0xF9, 0x09, 0x77, 0x40, 0x10, 0xDD, 0x0D, 0x70, 0x10, 0xDF,
  0x90, 0x97, 0x73, 0x05, 0x0D, 0xE0, 0xC5, 0x81, 0x27, 0xEF, 0xA0, 0xD8, 0x09, 0x39, 0x0B, 0x0E,
  0xF9, 0x84, 0xC0, 0x2D, 0xDE, 0x80, 0xC2, 0xF8, 0x1B, 0x03, 0x80, 0xC5, 0xF8, 0x1B, 0x03, 0x80,
  0xC5, 0xF8, 0x1A, 0x03, 0x80, 0xC5, 0xF0, 0xA1,
  // "ē" (U+0113)
  0x60, 0x38, 0x0A, 0x19, 0x07, 0x74, 0x06, 0xFF, 0xF0, 0xC7, 0x40, 0x6F, 0xFF, 0x0C, 0x74, 0x06,
  0xFF, 0xF0, 0xC7, 0x40, 0x6F, 0xFF, 0x0C, 0x80, 0xBB, 0x10, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB,
  0x84, 0x77, 0x68, 0x11, 0x8E, 0xFC, 0x0E, 0x07, 0x77, 0x30, 0x60, 0xEF, 0xF9, 0x0E, 0x04, 0x77,
  0x0A, 0xFF, 0xD0, 0x87, 0x50, 0xBF, 0x98, 0x3D, 0xA9, 0xAD, 0xF9, 0x08, 0x73, 0x09, 0xF0, 0xD0,
  0x45, 0x03, 0x0C, 0xF0, 0x67, 0x10, 0x6F, 0x0B, 0x72, 0x0B, 0xF0, 0x26, 0x01, 0x0E, 0xE0, 0xC7,
  0x30, 0x10, 0xEE, 0x0C, 0x60, 0x9F, 0x03, 0x74, 0x06, 0xF0, 0x54, 0x01, 0xF0, 0xA7, 0x6F, 0x0C,
  0x40, 0x8F, 0x04, 0x76, 0x0A, 0xF0, 0x23, 0x0D, 0xE0, 0xD7, 0x70, 0x5F, 0x07, 0x20, 0x3F, 0x09,
  0x77, 0x02, 0xF0, 0xC2, 0x07, 0xF0, 0x57, 0x71, 0x0E, 0xF2, 0x0B, 0xF0, 0x17, 0x71, 0x0B, 0xF8,
  0x14, 0x0E, 0xE0, 0xE7, 0x72, 0x09, 0xF0, 0x60, 0x2F, 0x0C, 0x77, 0x20, 0x8F, 0x08, 0x05, 0xF0,
  0xA7, 0x72, 0x06, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x20, 0x5F, 0x0B, 0x09, 0xF0, 0x87, 0x72, 0x05,
  0xF0, 0xC0, 0xAF, 0x07, 0x77, 0x20, 0x4F, 0x0D, 0x0B, 0xFF, 0xFF, 0xC0, 0xD0, 0xCF, 0xFF, 0xFC,
  0x0D, 0x0C, 0xFF, 0xFF, 0xC0, 0x0D, 0xFF, 0xFF, 0xC0, 0x0D, 0xF0, 0xB8, 0x0A, 0x49, 0x08, 0x0C,
  0xF0, 0x57, 0x77, 0x40, 0xCF, 0x05, 0x77, 0x74, 0x0B, 0xF0, 0x67, 0x77, 0x40, 0xAF, 0x07, 0x77,
  0x74, 0x09, 0xF0, 0x87, 0x77, 0x40, 0x7F, 0x0A, 0x77, 0x74, 0x05, 0xF0, 0xC7, 0x77, 0x40, 0x2F,
  0x0E, 0x77, 0x75, 0x0E, 0xF0, 0x27, 0x77, 0x40, 0xBF, 0x05, 0x77, 0x74, 0x07, 0xF0, 0x97, 0x77,
  0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0C, 0xF0, 0x57, 0x75, 0x04, 0x01, 0x40, 0x6F, 0x0B, 0x77, 0x48,
  0x11, 0xEC, 0x50, 0xDF, 0x04, 0x77, 0x30, 0xBA, 0x03, 0x40, 0x6F, 0x0D, 0x01, 0x77, 0x10, 0x9B,
  0x05, 0x50, 0xCF, 0x0B, 0x77, 0x09, 0xC0, 0x25, 0x02, 0x0E, 0xF0, 0xC0, 0x17, 0x30, 0x10, 0xBC,
  0x0C, 0x70, 0x5F, 0x98, 0x1E, 0x81, 0x68, 0x12, 0x8E, 0xD0, 0x37, 0x10, 0x6F, 0xB8, 0x4D, 0xA9,
  0x9B, 0xDF, 0x07, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0x77, 0x50, 0x20, 0xBF, 0xFB, 0x0D, 0x04, 0x77,
  0x10, 0x50, 0xBF, 0xE0, 0xD0, 0x67, 0x75, 0x83, 0x26, 0x9C, 0xEA, 0x84, 0xEE, 0xCA, 0x73, 0x72,
  // "Ĕ" (U+0114)
  0x74, 0x05, 0xB0, 0x97, 0x60, 0x4B, 0x09, 0x77, 0x70, 0x4B, 0x0D, 0x76, 0x08, 0xB0, 0x87, 0x77,
  0x02, 0xC0, 0x47, 0x50, 0xEB, 0x06, 0x77, 0x71, 0x0E, 0xB0, 0xD7, 0x40, 0x9C, 0x02, 0x77, 0x71,
  0x0A, 0xC0, 0xB0, 0x17, 0x10, 0x9C, 0x0E, 0x77, 0x72, 0x04, 0xD8, 0x2E, 0x84, 0x12, 0x81, 0x37,
  0xDD, 0x08, 0x77, 0x73, 0x0D, 0xFF, 0xC0, 0x27, 0x77, 0x30, 0x4F, 0xFB, 0x08, 0x77, 0x75, 0x08,
  0xFF, 0x90, 0xC7, 0x77, 0x70, 0x9F, 0xE0, 0xC0, 0x17, 0x77, 0x71, 0x05, 0x0D, 0xFB, 0x08, 0x77,
  0x77, 0x58, 0x90, 0x59, 0xCE, 0xFE, 0xDB, 0x61, 0x80, 0xBD, 0x00, 0x03, 0x80, 0xC3, 0xF0, 0x33,
  0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0, 0x43, 0x81, 0x2D, 0xE8, 0x0C, 0x1F, 0x04,
  0x70, 0x30, 0x8F, 0xB0, 0xD8, 0x09, 0x19, 0x0B, 0x0E, 0xF9, 0x05, 0x72, 0x03, 0x0E, 0xF9, 0x09,
  0x77, 0x10, 0x50, 0xEE, 0x05, 0x73, 0x08, 0xF9, 0x09, 0x77, 0x20, 0x20, 0xED, 0x06, 0x73, 0x03,
  0xF9, 0x09, 0x77, 0x30, 0x6D, 0x06, 0x74, 0xF9, 0x09, 0x77, 0x40, 0xDC, 0x07, 0x74, 0xF9, 0x09,
  0x77, 0x40, 0x8C, 0x07, 0x74, 0x0E, 0xF0, 0x97, 0x74, 0x04, 0xC0, 0x77, 0x40, 0xEF, 0x09, 0x77,
  0x40, 0x2C, 0x08, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0xC0, 0x87, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xEB,
  0x09, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0x0C, 0xB0, 0x97, 0x40, 0xEF, 0x09, 0x77, 0x58, 0x35, 0x88,
  0x85, 0x74, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xFF,
  0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73,
  0x0E, 0xF0, 0xD8, 0x09, 0x69, 0x77, 0x30, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x78, 0x42, 0xBB, 0xBB, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x4C,
  0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x8C, 0x01,
  0x71, 0x0E, 0xF0, 0x97, 0x77, 0x0A, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x70, 0xEC, 0x72, 0x0E, 0xF0,
  0x97, 0x76, 0x03, 0xD7, 0x2F, 0x90, 0x97, 0x76, 0x0A, 0xC0, 0xE7, 0x10, 0x2F, 0x90, 0x97, 0x75,
  0x03, 0xD0, 0xD7, 0x10, 0x6F, 0x90, 0x97, 0x74, 0x01, 0x0D, 0xD0, 0xD7, 0x01, 0x0D, 0xF9, 0x09,
  0x77, 0x30, 0x50, 0xDE, 0x0C, 0x58, 0x12, 0x7E, 0xFA, 0x0D, 0x80, 0x93, 0x90, 0xB0, 0xEF, 0x98,
  0x4C, 0x02, 0xDD, 0xE8, 0x0C, 0x2F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xB0, 0x38, 0x0C, 0x5F,
  0x81, 0xA0, 0x38, 0x0C, 0x5F, 0x0A, 0x10,
  // "ĕ" (U+0115)
  0x60, 0x5B, 0x09, 0x76, 0x04, 0xB0, 0x97, 0x40, 0x4B, 0x0D, 0x76, 0x08, 0xB0, 0x87, 0x40, 0x2C,
  0x04, 0x75, 0x0E, 0xB0, 0x67, 0x50, 0xEB, 0x0D, 0x74, 0x09, 0xC0, 0x27, 0x50, 0xAC, 0x0B, 0x01,
  0x71, 0x09, 0xC0, 0xE7, 0x60, 0x4D, 0x82, 0xE8, 0x41, 0x28, 0x13, 0x7D, 0xD0, 0x87, 0x70, 0xDF,
  0xFC, 0x02, 0x77, 0x04, 0xFF, 0xB0, 0x87, 0x72, 0x08, 0xFF, 0x90, 0xC7, 0x74, 0x09, 0xFE, 0x0C,
  0x01, 0x77, 0x50, 0x50, 0xDF, 0xB0, 0x87, 0x77, 0x28, 0x90, 0x59, 0xCE, 0xFE, 0xDB, 0x61, 0x80,
  0xAF, 0x50, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x84, 0x77, 0x68, 0x11, 0x8E, 0xFC, 0x0E, 0x07,
  0x77, 0x30, 0x60, 0xEF, 0xF9, 0x0E, 0x04, 0x77, 0x0A, 0xFF, 0xD0, 0x87, 0x50, 0xBF, 0x98, 0x3D,
  0xA9, 0xAD, 0xF9, 0x08, 0x73, 0x09, 0xF0, 0xD0, 0x45, 0x03, 0x0C, 0xF0, 0x67, 0x10, 0x6F, 0x0B,
  0x72, 0x0B, 0xF0, 0x26, 0x01, 0x0E, 0xE0, 0xC7, 0x30, 0x10, 0xEE, 0x0C, 0x60, 0x9F, 0x03, 0x74,
  0x06, 0xF0, 0x54, 0x01, 0xF0, 0xA7, 0x6F, 0x0C, 0x40, 0x8F, 0x04, 0x76, 0x0A, 0xF0, 0x23, 0x0D,
  0xE0, 0xD7, 0x70, 0x5F, 0x07, 0x20, 0x3F, 0x09, 0x77, 0x02, 0xF0, 0xC2, 0x07, 0xF0, 0x57, 0x71,
  0x0E, 0xF2, 0x0B, 0xF0, 0x17, 0x71, 0x0B, 0xF8, 0x14, 0x0E, 0xE0, 0xE7, 0x72, 0x09, 0xF0, 0x60,
  0x2F, 0x0C, 0x77, 0x20, 0x8F, 0x08, 0x05, 0xF0, 0xA7, 0x72, 0x06, 0xF0, 0xA0, 0x7F, 0x09, 0x77,
  0x20, 0x5F, 0x0B, 0x09, 0xF0, 0x87, 0x72, 0x05, 0xF0, 0xC0, 0xAF, 0x07, 0x77, 0x20, 0x4F, 0x0D,
  0x0B, 0xFF, 0xFF, 0xC0, 0xD0, 0xCF, 0xFF, 0xFC, 0x0D, 0x0C, 0xFF, 0xFF, 0xC0, 0x0D, 0xFF, 0xFF,
  0xC0, 0x0D, 0xF0, 0xB8, 0x0A, 0x49, 0x08, 0x0C, 0xF0, 0x57, 0x77, 0x40, 0xCF, 0x05, 0x77, 0x74,
  0x0B, 0xF0, 0x67, 0x77, 0x40, 0xAF, 0x07, 0x77, 0x74, 0x09, 0xF0, 0x87, 0x77, 0x40, 0x7F, 0x0A,
  0x77, 0x74, 0x05, 0xF0, 0xC7, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0E, 0xF0, 0x27, 0x77, 0x40,
  0xBF, 0x05, 0x77, 0x74, 0x07, 0xF0, 0x97, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0C, 0xF0, 0x57,
  0x75, 0x04, 0x01, 0x40, 0x6F, 0x0B, 0x77, 0x48, 0x11, 0xEC, 0x50, 0xDF, 0x04, 0x77, 0x30, 0xBA,
  0x03, 0x40, 0x6F, 0x0D, 0x01, 0x77, 0x10, 0x9B, 0x05, 0x50, 0xCF, 0x0B, 0x77, 0x09, 0xC0, 0x25,
  0x02, 0x0E, 0xF0, 0xC0, 0x17, 0x30, 0x10, 0xBC, 0x0C, 0x70, 0x5F, 0x98, 0x1E, 0x81, 0x68, 0x12,
  0x8E, 0xD0, 0x37, 0x10, 0x6F, 0xB8, 0x4D, 0xA9, 0x9B, 0xDF, 0x07, 0x73, 0x05, 0x0E, 0xFF, 0xE0,
  0x77, 0x50, 0x20, 0xBF, 0xFB, 0x0D, 0x04, 0x77, 0x10, 0x50, 0xBF, 0xE0, 0xD0, 0x67, 0x75, 0x83,
  0x26, 0x9C, 0xEA, 0x84, 0xEE, 0xCA, 0x73, 0x72,
  // "Ė" (U+0116)
  0x77, 0x68, 0x43, 0xAE, 0xFD, 0x88, 0x0C, 0x10, 0x04, 0xE0, 0xD0, 0x17, 0x77, 0x77, 0x0D, 0xF0,
  0x97, 0x77, 0x76, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x60, 0x5F, 0xA0, 0x17, 0x77, 0x75, 0x06, 0xFA,
  0x01, 0x77, 0x77, 0x50, 0x5F, 0xA0, 0x17, 0x77, 0x75, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xDF,
  0x09, 0x77, 0x77, 0x70, 0x4E, 0x0D, 0x01, 0x80, 0xC0, 0x08, 0x43, 0xAE, 0xFD, 0x88, 0x0D, 0x82,
  0x00, 0x38, 0x0C, 0x3F, 0x03, 0x30, 0x38, 0x0C, 0x3F, 0x03, 0x30, 0x38, 0x0C, 0x3F, 0x04, 0x38,
  0x12, 0xDE, 0x80, 0xC1, 0xF0, 0x47, 0x03, 0x08, 0xFB, 0x0D, 0x80, 0x91, 0x90, 0xB0, 0xEF, 0x90,
  0x57, 0x20, 0x30, 0xEF, 0x90, 0x97, 0x71, 0x05, 0x0E, 0xE0, 0x57, 0x30, 0x8F, 0x90, 0x97, 0x72,
  0x02, 0x0E, 0xD0, 0x67, 0x30, 0x3F, 0x90, 0x97, 0x73, 0x06, 0xD0, 0x67, 0x4F, 0x90, 0x97, 0x74,
  0x0D, 0xC0, 0x77, 0x4F, 0x90, 0x97, 0x74, 0x08, 0xC0, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x40, 0x4C,
  0x07, 0x74, 0x0E, 0xF0, 0x97, 0x74, 0x02, 0xC0, 0x87, 0x40, 0xEF, 0x09, 0x77, 0x5C, 0x08, 0x74,
  0x0E, 0xF0, 0x97, 0x75, 0x0E, 0xB0, 0x97, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xCB, 0x09, 0x74, 0x0E,
  0xF0, 0x97, 0x75, 0x83, 0x58, 0x88, 0x57, 0x40, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7,
  0x73, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0x0D, 0x80, 0x96, 0x97, 0x73, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x84, 0x2B, 0xBB, 0xB1, 0x71,
  0x0E, 0xF0, 0x97, 0x77, 0x04, 0xC0, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x6C, 0x01, 0x71, 0x0E,
  0xF0, 0x97, 0x77, 0x08, 0xC0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0xAC, 0x72, 0x0E, 0xF0, 0x97,
  0x77, 0x0E, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x60, 0x3D, 0x72, 0xF9, 0x09, 0x77, 0x60, 0xAC, 0x0E,
  0x71, 0x02, 0xF9, 0x09, 0x77, 0x50, 0x3D, 0x0D, 0x71, 0x06, 0xF9, 0x09, 0x77, 0x40, 0x10, 0xDD,
  0x0D, 0x70, 0x10, 0xDF, 0x90, 0x97, 0x73, 0x05, 0x0D, 0xE0, 0xC5, 0x81, 0x27, 0xEF, 0xA0, 0xD8,
  0x09, 0x39, 0x0B, 0x0E, 0xF9, 0x84, 0xC0, 0x2D, 0xDE, 0x80, 0xC2, 0xF8, 0x1B, 0x03, 0x80, 0xC5,
  0xF8, 0x1B, 0x03, 0x80, 0xC5, 0xF8, 0x1A, 0x03, 0x80, 0xC5, 0xF0, 0xA1,
  // "ė" (U+0117)
  0x77, 0x84, 0x3A, 0xEF, 0xD8, 0x77, 0x76, 0x04, 0xE0, 0xD0, 0x17, 0x77, 0x40, 0xDF, 0x09, 0x77,
  0x73, 0x03, 0xF9, 0x0E, 0x77, 0x73, 0x05, 0xFA, 0x01, 0x77, 0x72, 0x06, 0xFA, 0x01, 0x77, 0x72,
  0x05, 0xFA, 0x01, 0x77, 0x72, 0x03, 0xF9, 0x0E, 0x77, 0x74, 0x0D, 0xF0, 0x97, 0x77, 0x40, 0x4E,
  0x0D, 0x01, 0x77, 0x75, 0x84, 0x3A, 0xEF, 0xD8, 0x80, 0xCC, 0x60, 0x89, 0x14, 0x8B, 0xDE, 0xFE,
  0xDB, 0x84, 0x77, 0x68, 0x11, 0x8E, 0xFC, 0x0E, 0x07, 0x77, 0x30, 0x60, 0xEF, 0xF9, 0x0E, 0x04,
  0x77, 0x0A, 0xFF, 0xD0, 0x87, 0x50, 0xBF, 0x98, 0x3D, 0xA9, 0xAD, 0xF9, 0x08, 0x73, 0x09, 0xF0,
  0xD0, 0x45, 0x03, 0x0C, 0xF0, 0x67, 0x10, 0x6F, 0x0B, 0x72, 0x0B, 0xF0, 0x26, 0x01, 0x0E, 0xE0,
  0xC7, 0x30, 0x10, 0xEE, 0x0C, 0x60, 0x9F, 0x03, 0x74, 0x06, 0xF0, 0x54, 0x01, 0xF0, 0xA7, 0x6F,
  0x0C, 0x40, 0x8F, 0x04, 0x76, 0x0A, 0xF0, 0x23, 0x0D, 0xE0, 0xD7, 0x70, 0x5F, 0x07, 0x20, 0x3F,
  0x09, 0x77, 0x02, 0xF0, 0xC2, 0x07, 0xF0, 0x57, 0x71, 0x0E, 0xF2, 0x0B, 0xF0, 0x17, 0x71, 0x0B,
  0xF8, 0x14, 0x0E, 0xE0, 0xE7, 0x72, 0x09, 0xF0, 0x60, 0x2F, 0x0C, 0x77, 0x20, 0x8F, 0x08, 0x05,
  0xF0, 0xA7, 0x72, 0x06, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x20, 0x5F, 0x0B, 0x09, 0xF0, 0x87, 0x72,
  0x05, 0xF0, 0xC0, 0xAF, 0x07, 0x77, 0x20, 0x4F, 0x0D, 0x0B, 0xFF, 0xFF, 0xC0, 0xD0, 0xCF, 0xFF,
  0xFC, 0x0D, 0x0C, 0xFF, 0xFF, 0xC0, 0x0D, 0xFF, 0xFF, 0xC0, 0x0D, 0xF0, 0xB8, 0x0A, 0x49, 0x08,
  0x0C, 0xF0, 0x57, 0x77, 0x40, 0xCF, 0x05, 0x77, 0x74, 0x0B, 0xF0, 0x67, 0x77, 0x40, 0xAF, 0x07,
  0x77, 0x74, 0x09, 0xF0, 0x87, 0x77, 0x40, 0x7F, 0x0A, 0x77, 0x74, 0x05, 0xF0, 0xC7, 0x77, 0x40,
  0x2F, 0x0E, 0x77, 0x75, 0x0E, 0xF0, 0x27, 0x77, 0x40, 0xBF, 0x05, 0x77, 0x74, 0x07, 0xF0, 0x97,
  0x77, 0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0C, 0xF0, 0x57, 0x75, 0x04, 0x01, 0x40, 0x6F, 0x0B, 0x77,
  0x48, 0x11, 0xEC, 0x50, 0xDF, 0x04, 0x77, 0x30, 0xBA, 0x03, 0x40, 0x6F, 0x0D, 0x01, 0x77, 0x10,
  0x9B, 0x05, 0x50, 0xCF, 0x0B, 0x77, 0x09, 0xC0, 0x25, 0x02, 0x0E, 0xF0, 0xC0, 0x17, 0x30, 0x10,
  0xBC, 0x0C, 0x70, 0x5F, 0x98, 0x1E, 0x81, 0x68, 0x12, 0x8E, 0xD0, 0x37, 0x10, 0x6F, 0xB8, 0x4D,
  0xA9, 0x9B, 0xDF, 0x07, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0x77, 0x50, 0x20, 0xBF, 0xFB, 0x0D, 0x04,
  0x77, 0x10, 0x50, 0xBF, 0xE0, 0xD0, 0x67, 0x75, 0x83, 0x26, 0x9C, 0xEA, 0x84, 0xEE, 0xCA, 0x73,
  0x72,
  // "Ę" (U+0118)
  0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0, 0x43, 0x81,
  0x2D, 0xE8, 0x0C, 0x1F, 0x04, 0x70, 0x30, 0x8F, 0xB0, 0xD8, 0x09, 0x19, 0x0B, 0x0E, 0xF9, 0x05,
  0x72, 0x03, 0x0E, 0xF9, 0x09, 0x77, 0x10, 0x50, 0xEE, 0x05, 0x73, 0x08, 0xF9, 0x09, 0x77, 0x20,
  0x20, 0xED, 0x06, 0x73, 0x03, 0xF9, 0x09, 0x77, 0x30, 0x6D, 0x06, 0x74, 0xF9, 0x09, 0x77, 0x40,
  0xDC, 0x07, 0x74, 0xF9, 0x09, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x0E, 0xF0, 0x97, 0x74, 0x04, 0xC0,
  0x77, 0x40, 0xEF, 0x09, 0x77, 0x40, 0x2C, 0x08, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0xC0, 0x87, 0x40,
  0xEF, 0x09, 0x77, 0x50, 0xEB, 0x09, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0x0C, 0xB0, 0x97, 0x40, 0xEF,
  0x09, 0x77, 0x58, 0x35, 0x88, 0x85, 0x74, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF, 0xFD, 0x77,
  0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xF0, 0xD8, 0x09, 0x69, 0x77, 0x30, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x78, 0x42, 0xBB, 0xBB, 0x17, 0x10,
  0xEF, 0x09, 0x77, 0x70, 0x4C, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC0, 0x17, 0x10, 0xEF,
  0x09, 0x77, 0x70, 0x8C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x0A, 0xC7, 0x20, 0xEF, 0x09, 0x77,
  0x70, 0xEC, 0x72, 0x0E, 0xF0, 0x97, 0x76, 0x03, 0xD7, 0x2F, 0x90, 0x97, 0x76, 0x0A, 0xC0, 0xE7,
  0x10, 0x2F, 0x90, 0x97, 0x75, 0x03, 0xD0, 0xD7, 0x10, 0x6F, 0x90, 0x97, 0x74, 0x01, 0x0D, 0xD0,
  0xD7, 0x01, 0x0D, 0xF9, 0x09, 0x77, 0x30, 0x50, 0xDE, 0x0C, 0x58, 0x12, 0x7E, 0xFA, 0x0D, 0x80,
  0x93, 0x90, 0xB0, 0xEF, 0x98, 0x4C, 0x02, 0xDD, 0xE8, 0x0C, 0x2F, 0x81, 0xB0, 0x38, 0x0C, 0x5F,
  0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xA0, 0x38, 0x0C, 0x5F, 0x0A, 0x77, 0x77, 0x48, 0x41, 0x67,
  0x77, 0x68, 0x0C, 0x00, 0x01, 0x09, 0xC0, 0x88, 0x0C, 0x00, 0x04, 0x0E, 0xB0, 0xE0, 0x48, 0x0C,
  0x00, 0x06, 0xC0, 0xE0, 0x38, 0x0C, 0x00, 0x05, 0xD0, 0x48, 0x0C, 0x00, 0x02, 0xD0, 0x98, 0x0C,
  0x10, 0x0C, 0xD0, 0x18, 0x0C, 0x00, 0x04, 0xD0, 0xB8, 0x0C, 0x10, 0x0A, 0xD0, 0x78, 0x0C, 0x10,
  0x0E, 0xD0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0x38, 0x0C, 0x00, 0x03, 0xE0, 0x38, 0x0C, 0x00, 0x03,
  0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0x88, 0x0C, 0x00, 0x01, 0xE0, 0xD8, 0x0C, 0x10, 0x0D, 0xE0,
  0x98, 0x0C, 0x00, 0x09, 0xF8, 0x1C, 0x51, 0x28, 0x22, 0x58, 0x37, 0x77, 0x60, 0x2F, 0xF9, 0x05,
  0x77, 0x77, 0x07, 0xFF, 0x05, 0x77, 0x77, 0x10, 0x8F, 0xE0, 0x57, 0x77, 0x72, 0x04, 0x0D, 0xFC,
  0x04, 0x77, 0x77, 0x48, 0x91, 0x48, 0xBD, 0xEF, 0xEC, 0x95, 0x14,
  // "ę" (U+0119)
  0x75, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x84, 0x77, 0x68, 0x11, 0x8E, 0xFC, 0x0E, 0x07, 0x77,
  0x30, 0x60, 0xEF, 0xF9, 0x0E, 0x04, 0x77, 0x0A, 0xFF, 0xD0, 0x87, 0x50, 0xBF, 0x98, 0x3D, 0xA9,
  0xAD, 0xF9, 0x08, 0x73, 0x09, 0xF0, 0xD0, 0x45, 0x03, 0x0C, 0xF0, 0x67, 0x10, 0x6F, 0x0B, 0x72,
  0x0B, 0xF0, 0x26, 0x01, 0x0E, 0xE0, 0xC7, 0x30, 0x10, 0xEE, 0x0C, 0x60, 0x9F, 0x03, 0x74, 0x06,
  0xF0, 0x54, 0x01, 0xF0, 0xA7, 0x6F, 0x0C, 0x40, 0x8F, 0x04, 0x76, 0x0A, 0xF0, 0x23, 0x0D, 0xE0,
  0xD7, 0x70, 0x5F, 0x07, 0x20, 0x3F, 0x09, 0x77, 0x02, 0xF0, 0xC2, 0x07, 0xF0, 0x57, 0x71, 0x0E,
  0xF2, 0x0B, 0xF0, 0x17, 0x71, 0x0B, 0xF8, 0x14, 0x0E, 0xE0, 0xE7, 0x72, 0x09, 0xF0, 0x60, 0x2F,
  0x0C, 0x77, 0x20, 0x8F, 0x08, 0x05, 0xF0, 0xA7, 0x72, 0x06, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x20,
  0x5F, 0x0B, 0x09, 0xF0, 0x87, 0x72, 0x05, 0xF0, 0xC0, 0xAF, 0x07, 0x77, 0x20, 0x4F, 0x0D, 0x0B,
  0xFF, 0xFF, 0xC0, 0xD0, 0xCF, 0xFF, 0xFC, 0x0D, 0x0C, 0xFF, 0xFF, 0xC0, 0x0D, 0xFF, 0xFF, 0xC0,
  0x0D, 0xF0, 0xB8, 0x0A, 0x49, 0x08, 0x0C, 0xF0, 0x57, 0x77, 0x40, 0xCF, 0x05, 0x77, 0x74, 0x0B,
  0xF0, 0x67, 0x77, 0x40, 0xAF, 0x07, 0x77, 0x74, 0x09, 0xF0, 0x87, 0x77, 0x40, 0x7F, 0x0A, 0x77,
  0x74, 0x05, 0xF0, 0xC7, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0E, 0xF0, 0x27, 0x77, 0x40, 0xBF,
  0x05, 0x77, 0x74, 0x07, 0xF0, 0x97, 0x77, 0x40, 0x2F, 0x0E, 0x77, 0x75, 0x0C, 0xF0, 0x57, 0x75,
  0x04, 0x50, 0x6F, 0x0B, 0x77, 0x48, 0x11, 0xEB, 0x50, 0xDF, 0x04, 0x77, 0x30, 0xBA, 0x03, 0x40,
  0x6F, 0x0D, 0x01, 0x77, 0x10, 0x9B, 0x05, 0x50, 0xCF, 0x0B, 0x77, 0x09, 0xC0, 0x35, 0x02, 0x0E,
  0xF0, 0xC0, 0x17, 0x30, 0x10, 0xBC, 0x0D, 0x70, 0x5F, 0x98, 0x1E, 0x81, 0x68, 0x12, 0x8E, 0xD0,
  0x57, 0x10, 0x6F, 0xB8, 0x4D, 0xA9, 0x9B, 0xDF, 0x09, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0x97, 0x50,
  0x20, 0xBF, 0xFB, 0x0E, 0x06, 0x77, 0x10, 0x50, 0xBF, 0xF0, 0xA0, 0x17, 0x74, 0x83, 0x26, 0x9C,
  0xEF, 0x90, 0x67, 0x77, 0x60, 0x5C, 0x05, 0x77, 0x76, 0x07, 0xC0, 0x77, 0x77, 0x60, 0x5C, 0x0B,
  0x77, 0x76, 0x02, 0xD0, 0x27, 0x77, 0x60, 0xCC, 0x09, 0x77, 0x76, 0x05, 0xD0, 0x37, 0x77, 0x60,
  0xBC, 0x0E, 0x77, 0x76, 0x01, 0xD0, 0xB7, 0x77, 0x60, 0x4D, 0x09, 0x77, 0x76, 0x06, 0xD0, 0x97,
  0x77, 0x60, 0x6D, 0x09, 0x77, 0x76, 0x05, 0xD0, 0xB7, 0x77, 0x60, 0x4D, 0x0E, 0x77, 0x76, 0x01,
  0xE0, 0x77, 0x77, 0x60, 0xDE, 0x07, 0x60, 0x03, 0x77, 0x40, 0x6F, 0x86, 0xEB, 0x9A, 0xBE, 0xF7,
  0x77, 0x50, 0xCF, 0xE0, 0x77, 0x75, 0x01, 0x0D, 0xFD, 0x07, 0x77, 0x70, 0x8F, 0xC0, 0x67, 0x77,
  0x18, 0x91, 0x16, 0xAD, 0xEF, 0xED, 0xB7, 0x34,
  // "Ě" (U+011A)
  0x73, 0x83, 0x37, 0x77, 0x27, 0x71, 0x04, 0x0F, 0x77, 0x76, 0x06, 0xB0, 0xD0, 0x27, 0x60, 0x5C,
  0x01, 0x77, 0x50, 0x10, 0xDB, 0x0D, 0x02, 0x74, 0x05, 0xC0, 0x97, 0x77, 0x04, 0xC0, 0xD0, 0x17,
  0x20, 0x5C, 0x0D, 0x77, 0x72, 0x09, 0xC0, 0xD0, 0x17, 0x04, 0xD0, 0x37, 0x77, 0x30, 0xDC, 0x0C,
  0x60, 0x3D, 0x09, 0x77, 0x74, 0x04, 0xD0, 0xB4, 0x02, 0x0E, 0xC0, 0xD7, 0x77, 0x60, 0xAD, 0x09,
  0x20, 0x10, 0xDD, 0x05, 0x77, 0x76, 0x01, 0x0E, 0xD8, 0x15, 0x0B, 0xD0, 0xB7, 0x77, 0x71, 0x06,
  0xD0, 0xE0, 0x9E, 0x02, 0x77, 0x77, 0x20, 0xCF, 0xC0, 0x77, 0x77, 0x73, 0x04, 0xFB, 0x0D, 0x77,
  0x77, 0x50, 0xBF, 0xA0, 0x67, 0x77, 0x75, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x70, 0xCF, 0x07, 0x80,
  0xBD, 0x10, 0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0, 0x33, 0x03, 0x80, 0xC3, 0xF0,
  0x43, 0x81, 0x2D, 0xE8, 0x0C, 0x1F, 0x04, 0x70, 0x30, 0x8F, 0xB0, 0xD8, 0x09, 0x19, 0x0B, 0x0E,
  0xF9, 0x05, 0x72, 0x03, 0x0E, 0xF9, 0x09, 0x77, 0x10, 0x50, 0xEE, 0x05, 0x73, 0x08, 0xF9, 0x09,
  0x77, 0x20, 0x20, 0xED, 0x06, 0x73, 0x03, 0xF9, 0x09, 0x77, 0x30, 0x6D, 0x06, 0x74, 0xF9, 0x09,
  0x77, 0x40, 0xDC, 0x07, 0x74, 0xF9, 0x09, 0x77, 0x40, 0x8C, 0x07, 0x74, 0x0E, 0xF0, 0x97, 0x74,
  0x04, 0xC0, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x40, 0x2C, 0x08, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0xC0,
  0x87, 0x40, 0xEF, 0x09, 0x77, 0x50, 0xEB, 0x09, 0x74, 0x0E, 0xF0, 0x97, 0x75, 0x0C, 0xB0, 0x97,
  0x40, 0xEF, 0x09, 0x77, 0x58, 0x35, 0x88, 0x85, 0x74, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xFF, 0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xFF,
  0xFD, 0x77, 0x30, 0xEF, 0xFF, 0xD7, 0x73, 0x0E, 0xF0, 0xD8, 0x09, 0x69, 0x77, 0x30, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x78, 0x42, 0xBB, 0xBB,
  0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x4C, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC0, 0x17,
  0x10, 0xEF, 0x09, 0x77, 0x70, 0x8C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x0A, 0xC7, 0x20, 0xEF,
  0x09, 0x77, 0x70, 0xEC, 0x72, 0x0E, 0xF0, 0x97, 0x76, 0x03, 0xD7, 0x2F, 0x90, 0x97, 0x76, 0x0A,
  0xC0, 0xE7, 0x10, 0x2F, 0x90, 0x97, 0x75, 0x03, 0xD0, 0xD7, 0x10, 0x6F, 0x90, 0x97, 0x74, 0x01,
  0x0D, 0xD0, 0xD7, 0x01, 0x0D, 0xF9, 0x09, 0x77, 0x30, 0x50, 0xDE, 0x0C, 0x58, 0x12, 0x7E, 0xFA,
  0x0D, 0x80, 0x93, 0x90, 0xB0, 0xEF, 0x98, 0x4C, 0x02, 0xDD, 0xE8, 0x0C, 0x2F, 0x81, 0xB0, 0x38,
  0x0C, 0x5F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xA0, 0x38, 0x0C, 0x5F, 0x0A, 0x10,
  // "ě" (U+011B)
  0x58, 0x33, 0x77, 0x72, 0x77, 0x10, 0x40, 0xF7, 0x73, 0x06, 0xB0, 0xD0, 0x27, 0x60, 0x5C, 0x01,
  0x72, 0x01, 0x0D, 0xB0, 0xD0, 0x27, 0x40, 0x5C, 0x09, 0x74, 0x04, 0xC0, 0xD0, 0x17, 0x20, 0x5C,
  0x0D, 0x76, 0x09, 0xC0, 0xD0, 0x17, 0x04, 0xD0, 0x37, 0x70, 0xDC, 0x0C, 0x60, 0x3D, 0x09, 0x77,
  0x10, 0x4D, 0x0B, 0x40, 0x20, 0xEC, 0x0D, 0x77, 0x30, 0xAD, 0x09, 0x20, 0x10, 0xDD, 0x05, 0x77,
  0x30, 0x10, 0xED, 0x81, 0x50, 0xBD, 0x0B, 0x77, 0x50, 0x6D, 0x0E, 0x09, 0xE0, 0x27, 0x76, 0x0C,
  0xFC, 0x07, 0x77, 0x70, 0x4F, 0xB0, 0xD7, 0x77, 0x20, 0xBF, 0xA0, 0x67, 0x77, 0x20, 0x3F, 0x90,
  0xE7, 0x77, 0x40, 0xCF, 0x07, 0x80, 0xAF, 0x60, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xDB, 0x84, 0x77,
  0x68, 0x11, 0x8E, 0xFC, 0x0E, 0x07, 0x77, 0x30, 0x60, 0xEF, 0xF9, 0x0E, 0x04, 0x77, 0x0A, 0xFF,
  0xD0, 0x87, 0x50, 0xBF, 0x98, 0x3D, 0xA9, 0xAD, 0xF9, 0x08, 0x73, 0x09, 0xF0, 0xD0, 0x45, 0x03,
  0x0C, 0xF0, 0x67, 0x10, 0x6F, 0x0B, 0x72, 0x0B, 0xF0, 0x26, 0x01, 0x0E, 0xE0, 0xC7, 0x30, 0x10,
  0xEE, 0x0C, 0x60, 0x9F, 0x03, 0x74, 0x06, 0xF0, 0x54, 0x01, 0xF0, 0xA7, 0x6F, 0x0C, 0x40, 0x8F,
  0x04, 0x76, 0x0A, 0xF0, 0x23, 0x0D, 0xE0, 0xD7, 0x70, 0x5F, 0x07, 0x20, 0x3F, 0x09, 0x77, 0x02,
  0xF0, 0xC2, 0x07, 0xF0, 0x57, 0x71, 0x0E, 0xF2, 0x0B, 0xF0, 0x17, 0x71, 0x0B, 0xF8, 0x14, 0x0E,
  0xE0, 0xE7, 0x72, 0x09, 0xF0, 0x60, 0x2F, 0x0C, 0x77, 0x20, 0x8F, 0x08, 0x05, 0xF0, 0xA7, 0x72,
  0x06, 0xF0, 0xA0, 0x7F, 0x09, 0x77, 0x20, 0x5F, 0x0B, 0x09, 0xF0, 0x87, 0x72, 0x05, 0xF0, 0xC0,
  0xAF, 0x07, 0x77, 0x20, 0x4F, 0x0D, 0x0B, 0xFF, 0xFF, 0xC0, 0xD0, 0xCF, 0xFF, 0xFC, 0x0D, 0x0C,
  0xFF, 0xFF, 0xC0, 0x0D, 0xFF, 0xFF, 0xC0, 0x0D, 0xF0, 0xB8, 0x0A, 0x49, 0x08, 0x0C, 0xF0, 0x57,
  0x77, 0x40, 0xCF, 0x05, 0x77, 0x74, 0x0B, 0xF0, 0x67, 0x77, 0x40, 0xAF, 0x07, 0x77, 0x74, 0x09,
  0xF0, 0x87, 0x77, 0x40, 0x7F, 0x0A, 0x77, 0x74, 0x05, 0xF0, 0xC7, 0x77, 0x40, 0x2F, 0x0E, 0x77,
  0x75, 0x0E, 0xF0, 0x27, 0x77, 0x40, 0xBF, 0x05, 0x77, 0x74, 0x07, 0xF0, 0x97, 0x77, 0x40, 0x2F,
  0x0E, 0x77, 0x75, 0x0C, 0xF0, 0x57, 0x75, 0x04, 0x01, 0x40, 0x6F, 0x0B, 0x77, 0x48, 0x11, 0xEC,
  0x50, 0xDF, 0x04, 0x77, 0x30, 0xBA, 0x03, 0x40, 0x6F, 0x0D, 0x01, 0x77, 0x10, 0x9B, 0x05, 0x50,
  0xCF, 0x0B, 0x77, 0x09, 0xC0, 0x25, 0x02, 0x0E, 0xF0, 0xC0, 0x17, 0x30, 0x10, 0xBC, 0x0C, 0x70,
  0x5F, 0x98, 0x1E, 0x81, 0x68, 0x12, 0x8E, 0xD0, 0x37, 0x10, 0x6F, 0xB8, 0x4D, 0xA9, 0x9B, 0xDF,
  0x07, 0x73, 0x05, 0x0E, 0xFF, 0xE0, 0x77, 0x50, 0x20, 0xBF, 0xFB, 0x0D, 0x04, 0x77, 0x10, 0x50,
  0xBF, 0xE0, 0xD0, 0x67, 0x75, 0x83, 0x26, 0x9C, 0xEA, 0x84, 0xEE, 0xCA, 0x73, 0x72,
  // "Ĝ" (U+011C)
  0x77, 0x71, 0x05, 0x80, 0x37, 0x02, 0x80, 0xC4, 0x00, 0x10, 0xEF, 0x0B, 0x80, 0xC4, 0x00, 0x7F,
  0xA0, 0x28, 0x0C, 0x20, 0x01, 0x0E, 0xFA, 0x0A, 0x80, 0xC2, 0x00, 0x8F, 0xC0, 0x38, 0x0C, 0x00,
  0x02, 0xFD, 0x0C, 0x80, 0xC0, 0x00, 0xBD, 0x0C, 0x05, 0xE0, 0x57, 0x77, 0x76, 0x05, 0xD8, 0x2E,
  0x20, 0x7D, 0x0E, 0x01, 0x77, 0x77, 0x50, 0xDD, 0x05, 0x30, 0xAD, 0x09, 0x77, 0x77, 0x40, 0x8D,
  0x06, 0x50, 0xBD, 0x03, 0x77, 0x77, 0x20, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x77, 0x77, 0x20, 0xCC,
  0x08, 0x71, 0x01, 0x0C, 0xC0, 0x77, 0x77, 0x70, 0x7C, 0x08, 0x73, 0x01, 0x0C, 0xC0, 0x27, 0x77,
  0x50, 0x2C, 0x08, 0x75, 0x01, 0x0C, 0xB0, 0xC7, 0x77, 0x50, 0x6B, 0x08, 0x77, 0x01, 0x0C, 0xB0,
  0x18, 0x0B, 0xC3, 0x08, 0x43, 0x79, 0xBD, 0xEA, 0x86, 0xEE, 0xDC, 0xA7, 0x52, 0x77, 0x77, 0x30,
  0x50, 0xAF, 0xFB, 0x81, 0xC8, 0x27, 0x77, 0x48, 0x11, 0x8E, 0xFF, 0xF9, 0x09, 0x02, 0x77, 0x71,
  0x06, 0x0E, 0xFF, 0xFC, 0x0E, 0x05, 0x77, 0x50, 0x10, 0xBF, 0xB8, 0x5E, 0xCA, 0x99, 0xAC, 0xFD,
  0x07, 0x77, 0x30, 0x30, 0xDF, 0x98, 0x1C, 0x72, 0x71, 0x05, 0x0C, 0xFB, 0x06, 0x77, 0x10, 0x5F,
  0x90, 0xC0, 0x47, 0x60, 0x7F, 0xA0, 0xE0, 0x17, 0x60, 0x4F, 0x90, 0x87, 0x72, 0x06, 0xFA, 0x07,
  0x75, 0x03, 0x0E, 0xF0, 0x57, 0x74, 0x09, 0xF9, 0x0B, 0x74, 0x01, 0x0E, 0xF0, 0x67, 0x76, 0x0D,
  0xF0, 0xD7, 0x40, 0xAF, 0x09, 0x77, 0x70, 0x7F, 0x0C, 0x73, 0x05, 0xF0, 0xE0, 0x17, 0x77, 0x01,
  0xF0, 0xA7, 0x20, 0x10, 0xEF, 0x06, 0x77, 0x72, 0x0C, 0xE0, 0x47, 0x20, 0x7F, 0x0D, 0x77, 0x73,
  0x08, 0xD0, 0xA7, 0x30, 0xEF, 0x07, 0x77, 0x73, 0x06, 0xC0, 0x97, 0x30, 0x7F, 0x90, 0x17, 0x77,
  0x38, 0x35, 0xEC, 0x93, 0x74, 0x0D, 0xF0, 0xC8, 0x0C, 0x40, 0x03, 0xF9, 0x07, 0x80, 0xC4, 0x00,
  0x8F, 0x90, 0x38, 0x0C, 0x40, 0x0E, 0xF0, 0xE8, 0x0C, 0x40, 0x02, 0xF9, 0x0B, 0x80, 0xC4, 0x00,
  0x6F, 0x90, 0x88, 0x0C, 0x40, 0x09, 0xF9, 0x06, 0x80, 0xC4, 0x00, 0xDF, 0x90, 0x48, 0x0C, 0x40,
  0xFA, 0x02, 0x80, 0xC3, 0x00, 0x2F, 0xA8, 0x0C, 0x40, 0x04, 0xF9, 0x0E, 0x80, 0xC4, 0x00, 0x6F,
  0x90, 0xD8, 0x0C, 0x40, 0x07, 0xF9, 0x0C, 0x80, 0xC4, 0x00, 0x8F, 0x90, 0xB8, 0x0C, 0x40, 0x09,
  0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB8, 0x0C, 0x40, 0x0A, 0xF9, 0x0A, 0x80, 0xC4, 0x00,
  0xAF, 0x90, 0xA8, 0x0C, 0x40, 0x09, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB7, 0x75, 0x09,
  0xFF, 0xD0, 0xC0, 0x8F, 0x90, 0xB7, 0x75, 0x09, 0xFF, 0xD0, 0xC0, 0x7F, 0x90, 0xC7, 0x75, 0x09,
  0xFF, 0xD0, 0xC0, 0x6F, 0x90, 0xD7, 0x75, 0x09, 0xFF, 0xD0, 0xC0, 0x4F, 0x90, 0xE7, 0x77, 0x81,
  0x14, 0xAF, 0xD0, 0x90, 0x32, 0x02, 0xFA, 0x77, 0x73, 0x05, 0xFB, 0x06, 0x5F, 0xA0, 0x27, 0x77,
  0x30, 0xAF, 0x90, 0xE6, 0x0D, 0xF9, 0x04, 0x77, 0x73, 0x06, 0xF9, 0x0A, 0x60, 0xAF, 0x90, 0x77,
  0x77, 0x30, 0x3F, 0x90, 0x86, 0x07, 0xF9, 0x09, 0x77, 0x73, 0x02, 0xF9, 0x07, 0x60, 0x3F, 0x90,
  0xC7, 0x77, 0x30, 0x1F, 0x90, 0x67, 0xFA, 0x77, 0x73, 0x01, 0xF9, 0x06, 0x70, 0xAF, 0x90, 0x47,
  0x77, 0x20, 0x1F, 0x90, 0x67, 0x05, 0xF9, 0x08, 0x77, 0x72, 0x01, 0xF9, 0x06, 0x71, 0xF9, 0x0D,
  0x77, 0x72, 0x01, 0xF9, 0x06, 0x71, 0x0A, 0xF9, 0x03, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x71, 0x03,
  0xF9, 0x09, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x72, 0x0B, 0xF0, 0xE0, 0x17, 0x77, 0x01, 0xF9, 0x06,
  0x72, 0x04, 0xF9, 0x08, 0x77, 0x70, 0x1F, 0x90, 0x67, 0x30, 0xAF, 0x90, 0x27, 0x76, 0x01, 0xF9,
  0x06, 0x73, 0x01, 0x0E, 0xF0, 0xC7, 0x76, 0x01, 0xF9, 0x06, 0x74, 0x05, 0xF9, 0x09, 0x77, 0x50,
  0x1F, 0x90, 0x67, 0x50, 0x8F, 0x90, 0x97, 0x74, 0x01, 0xF9, 0x06, 0x76, 0x0A, 0xF9, 0x0B, 0x01,
  0x77, 0x20, 0x1F, 0x90, 0x67, 0x70, 0xBF, 0x98, 0x1E, 0x71, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x10,
  0x8F, 0xA8, 0x2E, 0x95, 0x17, 0x28, 0x11, 0x5A, 0xF9, 0x06, 0x77, 0x20, 0x5F, 0xD8, 0x7E, 0xBA,
  0x99, 0x9A, 0xBD, 0xFC, 0x06, 0x77, 0x30, 0x20, 0xBF, 0xFF, 0xF8, 0x1E, 0x91, 0x77, 0x50, 0x40,
  0xBF, 0xFF, 0xB0, 0xC0, 0x67, 0x77, 0x38, 0x12, 0x8D, 0xFF, 0xB8, 0x2E, 0xA6, 0x17, 0x77, 0x71,
  0x85, 0x15, 0x8A, 0xCD, 0xEA, 0x86, 0xED, 0xCC, 0xA7, 0x52, 0x77,
  // "ĝ" (U+011D)
  0x77, 0x10, 0x58, 0x03, 0x70, 0x27, 0x77, 0x72, 0x01, 0x0E, 0xF0, 0xB7, 0x77, 0x72, 0x07, 0xFA,
  0x02, 0x77, 0x77, 0x01, 0x0E, 0xFA, 0x0A, 0x77, 0x77, 0x08, 0xFC, 0x03, 0x77, 0x75, 0x02, 0xFD,
  0x0C, 0x77, 0x75, 0x0B, 0xD0, 0xC0, 0x5E, 0x05, 0x77, 0x73, 0x05, 0xD8, 0x2E, 0x20, 0x7D, 0x0E,
  0x01, 0x77, 0x72, 0x0D, 0xD0, 0x53, 0x0A, 0xD0, 0x97, 0x77, 0x10, 0x8D, 0x06, 0x50, 0xBD, 0x03,
  0x77, 0x60, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x77, 0x60, 0xCC, 0x08, 0x71, 0x01, 0x0C, 0xC0, 0x77,
  0x74, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x02, 0x77, 0x20, 0x2C, 0x08, 0x75, 0x01, 0x0C, 0xB0,
  0xC7, 0x72, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB, 0x01, 0x80, 0xAB, 0x40, 0x84, 0x3A, 0xDF, 0xD8,
  0x77, 0x77, 0x50, 0x9E, 0x0B, 0x77, 0x89, 0x15, 0x8B, 0xDE, 0xFE, 0xDB, 0x73, 0x50, 0x10, 0xCF,
  0x90, 0x57, 0x30, 0x20, 0x9F, 0xD0, 0xC0, 0x52, 0x01, 0x0C, 0xFA, 0x09, 0x72, 0x07, 0xFF, 0xA8,
  0x1B, 0x1C, 0xFB, 0x0B, 0x71, 0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x09, 0xF8, 0x59, 0x41, 0x01, 0x4A,
  0xF9, 0x83, 0xC4, 0x01, 0x8C, 0x07, 0x60, 0x4E, 0x0E, 0x04, 0x70, 0x40, 0xED, 0x0E, 0x50, 0xDA,
  0x0E, 0x70, 0xDE, 0x05, 0x72, 0x05, 0xE0, 0x84, 0x82, 0x7F, 0xE4, 0x60, 0x7E, 0x0B, 0x74, 0x0C,
  0xE0, 0x23, 0x02, 0x04, 0x71, 0x0D, 0xE0, 0x57, 0x40, 0x6E, 0x09, 0x75, 0x04, 0xF7, 0x50, 0x1F,
  0x01, 0x74, 0x07, 0xE0, 0xC7, 0x60, 0xDE, 0x06, 0x74, 0x0B, 0xE0, 0x97, 0x60, 0xBE, 0x0A, 0x74,
  0x0E, 0xE0, 0x77, 0x60, 0x9E, 0x0D, 0x74, 0xF0, 0x67, 0x60, 0x8E, 0x0E, 0x73, 0x01, 0xF0, 0x57,
  0x60, 0x7F, 0x73, 0x02, 0xF0, 0x57, 0x60, 0x7F, 0x01, 0x72, 0x03, 0xF0, 0x57, 0x60, 0x7F, 0x01,
  0x72, 0x02, 0xF0, 0x67, 0x60, 0x8F, 0x73, 0x01, 0xF0, 0x67, 0x60, 0x8E, 0x0E, 0x74, 0x0E, 0xE0,
  0x87, 0x60, 0xAE, 0x0D, 0x74, 0x0B, 0xE0, 0xB7, 0x60, 0xCE, 0x09, 0x74, 0x07, 0xE0, 0xE7, 0x6F,
  0x06, 0x74, 0x02, 0xF0, 0x37, 0x40, 0x4F, 0x01, 0x75, 0x0B, 0xE0, 0xA7, 0x40, 0xAE, 0x0A, 0x76,
  0x04, 0xF0, 0x37, 0x20, 0x3F, 0x04, 0x77, 0x0A, 0xE0, 0xE0, 0x37, 0x02, 0x0D, 0xE0, 0xA7, 0x71,
  0x01, 0x0D, 0xF8, 0x59, 0x41, 0x01, 0x38, 0xF0, 0xE0, 0x17, 0x72, 0x02, 0x0E, 0xFF, 0xE0, 0x47,
  0x74, 0x01, 0x0C, 0xFF, 0xC0, 0x57, 0x77, 0x07, 0xFF, 0x90, 0xC0, 0x27, 0x77, 0x01, 0x0B, 0xFE,
  0x0A, 0x04, 0x77, 0x71, 0x03, 0x0E, 0xB8, 0x90, 0x91, 0x47, 0x89, 0x87, 0x63, 0x77, 0x73, 0x03,
  0x0E, 0xB0, 0x97, 0x77, 0x75, 0x01, 0x0E, 0xB0, 0xD7, 0x77, 0x76, 0x09, 0xC0, 0x67, 0x77, 0x75,
  0x01, 0xD0, 0x27, 0x77, 0x75, 0x04, 0xD0, 0x17, 0x77, 0x75, 0x06, 0xD0, 0x37, 0x77, 0x75, 0x06,
  0xD0, 0xB7, 0x77, 0x75, 0x04, 0xE8, 0x1C, 0x52, 0x77, 0x77, 0x30, 0xEF, 0xFC, 0x83, 0xED, 0xB9,
  0x47, 0x72, 0x07, 0xFF, 0xFA, 0x0E, 0x07, 0x77, 0x10, 0x9F, 0xFF, 0xB0, 0xD0, 0x27, 0x70, 0x7F,
  0xFF, 0xB0, 0xE0, 0x37, 0x70, 0x6F, 0xFF, 0xB0, 0xD0, 0x17, 0x38, 0x11, 0x7E, 0xFF, 0xFD, 0x0A,
  0x72, 0x05, 0x0E, 0xFF, 0xFF, 0x90, 0x27, 0x08, 0xE8, 0x2C, 0x73, 0x17, 0x28, 0x21, 0x37, 0xCF,
  0x90, 0x86, 0x09, 0xD0, 0xE0, 0x57, 0x73, 0x06, 0xF0, 0xD5, 0x07, 0xD0, 0xE0, 0x37, 0x75, 0x07,
  0xF0, 0x23, 0x01, 0xE0, 0x67, 0x77, 0x0E, 0xE0, 0x43, 0x08, 0xD0, 0xD7, 0x77, 0x10, 0xAE, 0x06,
  0x30, 0xDD, 0x08, 0x77, 0x71, 0x06, 0xE0, 0x72, 0x02, 0xE0, 0x57, 0x77, 0x10, 0x5E, 0x07, 0x20,
  0x4E, 0x03, 0x77, 0x71, 0x05, 0xE0, 0x72, 0x06, 0xE0, 0x37, 0x77, 0x10, 0x5E, 0x05, 0x20, 0x6E,
  0x03, 0x77, 0x71, 0x07, 0xE0, 0x32, 0x06, 0xE0, 0x47, 0x77, 0x10, 0xAE, 0x30, 0x4E, 0x07, 0x77,
  0x71, 0x0E, 0xD0, 0xC3, 0x03, 0xE0, 0xB7, 0x77, 0x05, 0xE0, 0x74, 0x0E, 0xE0, 0x17, 0x76, 0x0D,
  0xD0, 0xE0, 0x14, 0x0A, 0xE0, 0x97, 0x75, 0x09, 0xE0, 0x85, 0x05, 0xF0, 0x47, 0x73, 0x09, 0xE0,
  0xD7, 0x0C, 0xF0, 0x47, 0x70, 0x30, 0xCF, 0x03, 0x70, 0x3F, 0x90, 0xB0, 0x47, 0x28, 0x12, 0x6B,
  0xF9, 0x05, 0x72, 0x05, 0xFB, 0x86, 0xCA, 0x99, 0xAA, 0xCE, 0xFB, 0x05, 0x74, 0x05, 0xFF, 0xFC,
  0x0D, 0x03, 0x76, 0x03, 0x0C, 0xFF, 0xF0, 0xD0, 0x67, 0x73, 0x04, 0x0B, 0xFF, 0xA8, 0x1E, 0xA5,
  0x77, 0x78, 0x41, 0x58, 0xAC, 0xEB, 0x85, 0xEE, 0xCB, 0x96, 0x37, 0x71,
  // "Ğ" (U+011E)
  0x77, 0x10, 0x5B, 0x09, 0x76, 0x04, 0xB0, 0x97, 0x77, 0x60, 0x4B, 0x0D, 0x76, 0x08, 0xB0, 0x87,
  0x77, 0x60, 0x2C, 0x04, 0x75, 0x0E, 0xB0, 0x67, 0x77, 0x70, 0xEB, 0x0D, 0x74, 0x09, 0xC0, 0x27,
  0x77, 0x70, 0xAC, 0x0B, 0x01, 0x71, 0x09, 0xC0, 0xE7, 0x77, 0x71, 0x04, 0xD8, 0x2E, 0x84, 0x12,
  0x81, 0x37, 0xDD, 0x08, 0x77, 0x77, 0x20, 0xDF, 0xFC, 0x02, 0x77, 0x77, 0x20, 0x4F, 0xFB, 0x08,
  0x77, 0x77, 0x40, 0x8F, 0xF9, 0x0C, 0x77, 0x77, 0x60, 0x9F, 0xE0, 0xC0, 0x17, 0x77, 0x77, 0x05,
  0x0D, 0xFB, 0x08, 0x80, 0xC3, 0x08, 0x90, 0x59, 0xCE, 0xFE, 0xDB, 0x61, 0x80, 0xBD, 0x20, 0x84,
  0x37, 0x9B, 0xDE, 0xA8, 0x6E, 0xED, 0xCA, 0x75, 0x27, 0x77, 0x73, 0x05, 0x0A, 0xFF, 0xB8, 0x1C,
  0x82, 0x77, 0x74, 0x81, 0x18, 0xEF, 0xFF, 0x90, 0x90, 0x27, 0x77, 0x10, 0x60, 0xEF, 0xFF, 0xC0,
  0xE0, 0x57, 0x75, 0x01, 0x0B, 0xFB, 0x85, 0xEC, 0xA9, 0x9A, 0xCF, 0xD0, 0x77, 0x73, 0x03, 0x0D,
  0xF9, 0x81, 0xC7, 0x27, 0x10, 0x50, 0xCF, 0xB0, 0x67, 0x71, 0x05, 0xF9, 0x0C, 0x04, 0x76, 0x07,
  0xFA, 0x0E, 0x01, 0x76, 0x04, 0xF9, 0x08, 0x77, 0x20, 0x6F, 0xA0, 0x77, 0x50, 0x30, 0xEF, 0x05,
  0x77, 0x40, 0x9F, 0x90, 0xB7, 0x40, 0x10, 0xEF, 0x06, 0x77, 0x60, 0xDF, 0x0D, 0x74, 0x0A, 0xF0,
  0x97, 0x77, 0x07, 0xF0, 0xC7, 0x30, 0x5F, 0x0E, 0x01, 0x77, 0x70, 0x1F, 0x0A, 0x72, 0x01, 0x0E,
  0xF0, 0x67, 0x77, 0x20, 0xCE, 0x04, 0x72, 0x07, 0xF0, 0xD7, 0x77, 0x30, 0x8D, 0x0A, 0x73, 0x0E,
  0xF0, 0x77, 0x77, 0x30, 0x6C, 0x09, 0x73, 0x07, 0xF9, 0x01, 0x77, 0x73, 0x83, 0x5E, 0xC9, 0x37,
  0x40, 0xDF, 0x0C, 0x80, 0xC4, 0x00, 0x3F, 0x90, 0x78, 0x0C, 0x40, 0x08, 0xF9, 0x03, 0x80, 0xC4,
  0x00, 0xEF, 0x0E, 0x80, 0xC4, 0x00, 0x2F, 0x90, 0xB8, 0x0C, 0x40, 0x06, 0xF9, 0x08, 0x80, 0xC4,
  0x00, 0x9F, 0x90, 0x68, 0x0C, 0x40, 0x0D, 0xF9, 0x04, 0x80, 0xC4, 0x0F, 0xA0, 0x28, 0x0C, 0x30,
  0x02, 0xFA, 0x80, 0xC4, 0x00, 0x4F, 0x90, 0xE8, 0x0C, 0x40, 0x06, 0xF9, 0x0D, 0x80, 0xC4, 0x00,
  0x7F, 0x90, 0xC8, 0x0C, 0x40, 0x08, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB8, 0x0C, 0x40,
  0x09, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0xAF, 0x90, 0xA8, 0x0C, 0x40, 0x0A, 0xF9, 0x0A, 0x80, 0xC4,
  0x00, 0x9F, 0x90, 0xB8, 0x0C, 0x40, 0x09, 0xF9, 0x0B, 0x77, 0x50, 0x9F, 0xFD, 0x0C, 0x08, 0xF9,
  0x0B, 0x77, 0x50, 0x9F, 0xFD, 0x0C, 0x07, 0xF9, 0x0C, 0x77, 0x50, 0x9F, 0xFD, 0x0C, 0x06, 0xF9,
  0x0D, 0x77, 0x50, 0x9F, 0xFD, 0x0C, 0x04, 0xF9, 0x0E, 0x77, 0x78, 0x11, 0x4A, 0xFD, 0x09, 0x03,
  0x20, 0x2F, 0xA7, 0x77, 0x30, 0x5F, 0xB0, 0x65, 0xFA, 0x02, 0x77, 0x73, 0x0A, 0xF9, 0x0E, 0x60,
  0xDF, 0x90, 0x47, 0x77, 0x30, 0x6F, 0x90, 0xA6, 0x0A, 0xF9, 0x07, 0x77, 0x73, 0x03, 0xF9, 0x08,
  0x60, 0x7F, 0x90, 0x97, 0x77, 0x30, 0x2F, 0x90, 0x76, 0x03, 0xF9, 0x0C, 0x77, 0x73, 0x01, 0xF9,
  0x06, 0x7F, 0xA7, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x0A, 0xF9, 0x04, 0x77, 0x72, 0x01, 0xF9, 0x06,
  0x70, 0x5F, 0x90, 0x87, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x1F, 0x90, 0xD7, 0x77, 0x20, 0x1F, 0x90,
  0x67, 0x10, 0xAF, 0x90, 0x37, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x10, 0x3F, 0x90, 0x97, 0x77, 0x10,
  0x1F, 0x90, 0x67, 0x20, 0xBF, 0x0E, 0x01, 0x77, 0x70, 0x1F, 0x90, 0x67, 0x20, 0x4F, 0x90, 0x87,
  0x77, 0x01, 0xF9, 0x06, 0x73, 0x0A, 0xF9, 0x02, 0x77, 0x60, 0x1F, 0x90, 0x67, 0x30, 0x10, 0xEF,
  0x0C, 0x77, 0x60, 0x1F, 0x90, 0x67, 0x40, 0x5F, 0x90, 0x97, 0x75, 0x01, 0xF9, 0x06, 0x75, 0x08,
  0xF9, 0x09, 0x77, 0x40, 0x1F, 0x90, 0x67, 0x60, 0xAF, 0x90, 0xB0, 0x17, 0x72, 0x01, 0xF9, 0x06,
  0x77, 0x0B, 0xF9, 0x81, 0xE7, 0x17, 0x70, 0x1F, 0x90, 0x67, 0x71, 0x08, 0xFA, 0x82, 0xE9, 0x51,
  0x72, 0x81, 0x15, 0xAF, 0x90, 0x67, 0x72, 0x05, 0xFD, 0x87, 0xEB, 0xA9, 0x99, 0xAB, 0xDF, 0xC0,
  0x67, 0x73, 0x02, 0x0B, 0xFF, 0xFF, 0x81, 0xE9, 0x17, 0x75, 0x04, 0x0B, 0xFF, 0xFB, 0x0C, 0x06,
  0x77, 0x73, 0x81, 0x28, 0xDF, 0xFB, 0x82, 0xEA, 0x61, 0x77, 0x77, 0x18, 0x51, 0x58, 0xAC, 0xDE,
  0xA8, 0x6E, 0xDC, 0xCA, 0x75, 0x27, 0x70,
  // "ğ" (U+011F)
  0x70, 0x5B, 0x09, 0x76, 0x04, 0xB0, 0x97, 0x73, 0x04, 0xB0, 0xD7, 0x60, 0x8B, 0x08, 0x77, 0x30,
  0x2C, 0x04, 0x75, 0x0E, 0xB0, 0x67, 0x74, 0x0E, 0xB0, 0xD7, 0x40, 0x9C, 0x02, 0x77, 0x40, 0xAC,
  0x0B, 0x01, 0x71, 0x09, 0xC0, 0xE7, 0x75, 0x04, 0xD8, 0x2E, 0x84, 0x12, 0x81, 0x37, 0xDD, 0x08,
  0x77, 0x60, 0xDF, 0xFC, 0x02, 0x77, 0x60, 0x4F, 0xFB, 0x08, 0x77, 0x71, 0x08, 0xFF, 0x90, 0xC7,
  0x77, 0x30, 0x9F, 0xE0, 0xC0, 0x17, 0x77, 0x40, 0x50, 0xDF, 0xB0, 0x87, 0x77, 0x71, 0x89, 0x05,
  0x9C, 0xEF, 0xED, 0xB6, 0x18, 0x0A, 0xC4, 0x08, 0x43, 0xAD, 0xFD, 0x87, 0x77, 0x75, 0x09, 0xE0,
  0xB7, 0x78, 0x91, 0x58, 0xBD, 0xEF, 0xED, 0xB7, 0x35, 0x01, 0x0C, 0xF9, 0x05, 0x73, 0x02, 0x09,
  0xFD, 0x0C, 0x05, 0x20, 0x10, 0xCF, 0xA0, 0x97, 0x20, 0x7F, 0xFA, 0x81, 0xB1, 0xCF, 0xB0, 0xB7,
  0x10, 0xAF, 0xFF, 0xFA, 0x0A, 0x70, 0x9F, 0x85, 0x94, 0x10, 0x14, 0xAF, 0x98, 0x3C, 0x40, 0x18,
  0xC0, 0x76, 0x04, 0xE0, 0xE0, 0x47, 0x04, 0x0E, 0xD0, 0xE5, 0x0D, 0xA0, 0xE7, 0x0D, 0xE0, 0x57,
  0x20, 0x5E, 0x08, 0x48, 0x27, 0xFE, 0x46, 0x07, 0xE0, 0xB7, 0x40, 0xCE, 0x02, 0x30, 0x20, 0x47,
  0x10, 0xDE, 0x05, 0x74, 0x06, 0xE0, 0x97, 0x50, 0x4F, 0x75, 0x01, 0xF0, 0x17, 0x40, 0x7E, 0x0C,
  0x76, 0x0D, 0xE0, 0x67, 0x40, 0xBE, 0x09, 0x76, 0x0B, 0xE0, 0xA7, 0x40, 0xEE, 0x07, 0x76, 0x09,
  0xE0, 0xD7, 0x4F, 0x06, 0x76, 0x08, 0xE0, 0xE7, 0x30, 0x1F, 0x05, 0x76, 0x07, 0xF7, 0x30, 0x2F,
  0x05, 0x76, 0x07, 0xF0, 0x17, 0x20, 0x3F, 0x05, 0x76, 0x07, 0xF0, 0x17, 0x20, 0x2F, 0x06, 0x76,
  0x08, 0xF7, 0x30, 0x1F, 0x06, 0x76, 0x08, 0xE0, 0xE7, 0x40, 0xEE, 0x08, 0x76, 0x0A, 0xE0, 0xD7,
  0x40, 0xBE, 0x0B, 0x76, 0x0C, 0xE0, 0x97, 0x40, 0x7E, 0x0E, 0x76, 0xF0, 0x67, 0x40, 0x2F, 0x03,
  0x74, 0x04, 0xF0, 0x17, 0x50, 0xBE, 0x0A, 0x74, 0x0A, 0xE0, 0xA7, 0x60, 0x4F, 0x03, 0x72, 0x03,
  0xF0, 0x47, 0x70, 0xAE, 0x0E, 0x03, 0x70, 0x20, 0xDE, 0x0A, 0x77, 0x10, 0x10, 0xDF, 0x85, 0x94,
  0x10, 0x13, 0x8F, 0x0E, 0x01, 0x77, 0x20, 0x20, 0xEF, 0xFE, 0x04, 0x77, 0x40, 0x10, 0xCF, 0xFC,
  0x05, 0x77, 0x70, 0x7F, 0xF9, 0x0C, 0x02, 0x77, 0x70, 0x10, 0xBF, 0xE0, 0xA0, 0x47, 0x77, 0x10,
  0x30, 0xEB, 0x89, 0x09, 0x14, 0x78, 0x98, 0x76, 0x37, 0x77, 0x30, 0x30, 0xEB, 0x09, 0x77, 0x77,
  0x50, 0x10, 0xEB, 0x0D, 0x77, 0x77, 0x60, 0x9C, 0x06, 0x77, 0x77, 0x50, 0x1D, 0x02, 0x77, 0x77,
  0x50, 0x4D, 0x01, 0x77, 0x77, 0x50, 0x6D, 0x03, 0x77, 0x77, 0x50, 0x6D, 0x0B, 0x77, 0x77, 0x50,
  0x4E, 0x81, 0xC5, 0x27, 0x77, 0x73, 0x0E, 0xFF, 0xC8, 0x3E, 0xDB, 0x94, 0x77, 0x20, 0x7F, 0xFF,
  0xA0, 0xE0, 0x77, 0x71, 0x09, 0xFF, 0xFB, 0x0D, 0x02, 0x77, 0x07, 0xFF, 0xFB, 0x0E, 0x03, 0x77,
  0x06, 0xFF, 0xFB, 0x0D, 0x01, 0x73, 0x81, 0x17, 0xEF, 0xFF, 0xD0, 0xA7, 0x20, 0x50, 0xEF, 0xFF,
  0xF9, 0x02, 0x70, 0x8E, 0x82, 0xC7, 0x31, 0x72, 0x82, 0x13, 0x7C, 0xF9, 0x08, 0x60, 0x9D, 0x0E,
  0x05, 0x77, 0x30, 0x6F, 0x0D, 0x50, 0x7D, 0x0E, 0x03, 0x77, 0x50, 0x7F, 0x02, 0x30, 0x1E, 0x06,
  0x77, 0x70, 0xEE, 0x04, 0x30, 0x8D, 0x0D, 0x77, 0x71, 0x0A, 0xE0, 0x63, 0x0D, 0xD0, 0x87, 0x77,
  0x10, 0x6E, 0x07, 0x20, 0x2E, 0x05, 0x77, 0x71, 0x05, 0xE0, 0x72, 0x04, 0xE0, 0x37, 0x77, 0x10,
  0x5E, 0x07, 0x20, 0x6E, 0x03, 0x77, 0x71, 0x05, 0xE0, 0x52, 0x06, 0xE0, 0x37, 0x77, 0x10, 0x7E,
  0x03, 0x20, 0x6E, 0x04, 0x77, 0x71, 0x0A, 0xE3, 0x04, 0xE0, 0x77, 0x77, 0x10, 0xED, 0x0C, 0x30,
  0x3E, 0x0B, 0x77, 0x70, 0x5E, 0x07, 0x40, 0xEE, 0x01, 0x77, 0x60, 0xDD, 0x0E, 0x01, 0x40, 0xAE,
  0x09, 0x77, 0x50, 0x9E, 0x08, 0x50, 0x5F, 0x04, 0x77, 0x30, 0x9E, 0x0D, 0x70, 0xCF, 0x04, 0x77,
  0x03, 0x0C, 0xF0, 0x37, 0x03, 0xF9, 0x0B, 0x04, 0x72, 0x81, 0x26, 0xBF, 0x90, 0x57, 0x20, 0x5F,
  0xB8, 0x6C, 0xA9, 0x9A, 0xAC, 0xEF, 0xB0, 0x57, 0x40, 0x5F, 0xFF, 0xC0, 0xD0, 0x37, 0x60, 0x30,
  0xCF, 0xFF, 0x0D, 0x06, 0x77, 0x30, 0x40, 0xBF, 0xFA, 0x81, 0xEA, 0x57, 0x77, 0x84, 0x15, 0x8A,
  0xCE, 0xB8, 0x5E, 0xEC, 0xB9, 0x63, 0x77, 0x10,
  // "Ġ" (U+0120)
  0x77, 0x73, 0x84, 0x3A, 0xEF, 0xD8, 0x80, 0xC7, 0x00, 0x4E, 0x0D, 0x01, 0x80, 0xC5, 0x00, 0xDF,
  0x09, 0x80, 0xC4, 0x00, 0x3F, 0x90, 0xE8, 0x0C, 0x40, 0x05, 0xFA, 0x01, 0x80, 0xC3, 0x00, 0x6F,
  0xA0, 0x18, 0x0C, 0x30, 0x05, 0xFA, 0x01, 0x80, 0xC3, 0x00, 0x3F, 0x90, 0xE8, 0x0C, 0x50, 0x0D,
  0xF0, 0x98, 0x0C, 0x50, 0x04, 0xE0, 0xD0, 0x18, 0x0C, 0x60, 0x84, 0x3A, 0xEF, 0xD8, 0x80, 0xE8,
  0x20, 0x84, 0x37, 0x9B, 0xDE, 0xA8, 0x6E, 0xED, 0xCA, 0x75, 0x27, 0x77, 0x73, 0x05, 0x0A, 0xFF,
  0xB8, 0x1C, 0x82, 0x77, 0x74, 0x81, 0x18, 0xEF, 0xFF, 0x90, 0x90, 0x27, 0x77, 0x10, 0x60, 0xEF,
  0xFF, 0xC0, 0xE0, 0x57, 0x75, 0x01, 0x0B, 0xFB, 0x85, 0xEC, 0xA9, 0x9A, 0xCF, 0xD0, 0x77, 0x73,
  0x03, 0x0D, 0xF9, 0x81, 0xC7, 0x27, 0x10, 0x50, 0xCF, 0xB0, 0x67, 0x71, 0x05, 0xF9, 0x0C, 0x04,
  0x76, 0x07, 0xFA, 0x0E, 0x01, 0x76, 0x04, 0xF9, 0x08, 0x77, 0x20, 0x6F, 0xA0, 0x77, 0x50, 0x30,
  0xEF, 0x05, 0x77, 0x40, 0x9F, 0x90, 0xB7, 0x40, 0x10, 0xEF, 0x06, 0x77, 0x60, 0xDF, 0x0D, 0x74,
  0x0A, 0xF0, 0x97, 0x77, 0x07, 0xF0, 0xC7, 0x30, 0x5F, 0x0E, 0x01, 0x77, 0x70, 0x1F, 0x0A, 0x72,
  0x01, 0x0E, 0xF0, 0x67, 0x77, 0x20, 0xCE, 0x04, 0x72, 0x07, 0xF0, 0xD7, 0x77, 0x30, 0x8D, 0x0A,
  0x73, 0x0E, 0xF0, 0x77, 0x77, 0x30, 0x6C, 0x09, 0x73, 0x07, 0xF9, 0x01, 0x77, 0x73, 0x83, 0x5E,
  0xC9, 0x37, 0x40, 0xDF, 0x0C, 0x80, 0xC4, 0x00, 0x3F, 0x90, 0x78, 0x0C, 0x40, 0x08, 0xF9, 0x03,
  0x80, 0xC4, 0x00, 0xEF, 0x0E, 0x80, 0xC4, 0x00, 0x2F, 0x90, 0xB8, 0x0C, 0x40, 0x06, 0xF9, 0x08,
  0x80, 0xC4, 0x00, 0x9F, 0x90, 0x68, 0x0C, 0x40, 0x0D, 0xF9, 0x04, 0x80, 0xC4, 0x0F, 0xA0, 0x28,
  0x0C, 0x30, 0x02, 0xFA, 0x80, 0xC4, 0x00, 0x4F, 0x90, 0xE8, 0x0C, 0x40, 0x06, 0xF9, 0x0D, 0x80,
  0xC4, 0x00, 0x7F, 0x90, 0xC8, 0x0C, 0x40, 0x08, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB8,
  0x0C, 0x40, 0x09, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0xAF, 0x90, 0xA8, 0x0C, 0x40, 0x0A, 0xF9, 0x0A,
  0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB8, 0x0C, 0x40, 0x09, 0xF9, 0x0B, 0x77, 0x50, 0x9F, 0xFD, 0x0C,
  0x08, 0xF9, 0x0B, 0x77, 0x50, 0x9F, 0xFD, 0x0C, 0x07, 0xF9, 0x0C, 0x77, 0x50, 0x9F, 0xFD, 0x0C,
  0x06, 0xF9, 0x0D, 0x77, 0x50, 0x9F, 0xFD, 0x0C, 0x04, 0xF9, 0x0E, 0x77, 0x78, 0x11, 0x4A, 0xFD,
  0x09, 0x03, 0x20, 0x2F, 0xA7, 0x77, 0x30, 0x5F, 0xB0, 0x65, 0xFA, 0x02, 0x77, 0x73, 0x0A, 0xF9,
  0x0E, 0x60, 0xDF, 0x90, 0x47, 0x77, 0x30, 0x6F, 0x90, 0xA6, 0x0A, 0xF9, 0x07, 0x77, 0x73, 0x03,
  0xF9, 0x08, 0x60, 0x7F, 0x90, 0x97, 0x77, 0x30, 0x2F, 0x90, 0x76, 0x03, 0xF9, 0x0C, 0x77, 0x73,
  0x01, 0xF9, 0x06, 0x7F, 0xA7, 0x77, 0x30, 0x1F, 0x90, 0x67, 0x0A, 0xF9, 0x04, 0x77, 0x72, 0x01,
  0xF9, 0x06, 0x70, 0x5F, 0x90, 0x87, 0x77, 0x20, 0x1F, 0x90, 0x67, 0x1F, 0x90, 0xD7, 0x77, 0x20,
  0x1F, 0x90, 0x67, 0x10, 0xAF, 0x90, 0x37, 0x77, 0x10, 0x1F, 0x90, 0x67, 0x10, 0x3F, 0x90, 0x97,
  0x77, 0x10, 0x1F, 0x90, 0x67, 0x20, 0xBF, 0x0E, 0x01, 0x77, 0x70, 0x1F, 0x90, 0x67, 0x20, 0x4F,
  0x90, 0x87, 0x77, 0x01, 0xF9, 0x06, 0x73, 0x0A, 0xF9, 0x02, 0x77, 0x60, 0x1F, 0x90, 0x67, 0x30,
  0x10, 0xEF, 0x0C, 0x77, 0x60, 0x1F, 0x90, 0x67, 0x40, 0x5F, 0x90, 0x97, 0x75, 0x01, 0xF9, 0x06,
  0x75, 0x08, 0xF9, 0x09, 0x77, 0x40, 0x1F, 0x90, 0x67, 0x60, 0xAF, 0x90, 0xB0, 0x17, 0x72, 0x01,
  0xF9, 0x06, 0x77, 0x0B, 0xF9, 0x81, 0xE7, 0x17, 0x70, 0x1F, 0x90, 0x67, 0x71, 0x08, 0xFA, 0x82,
  0xE9, 0x51, 0x72, 0x81, 0x15, 0xAF, 0x90, 0x67, 0x72, 0x05, 0xFD, 0x87, 0xEB, 0xA9, 0x99, 0xAB,
  0xDF, 0xC0, 0x67, 0x73, 0x02, 0x0B, 0xFF, 0xFF, 0x81, 0xE9, 0x17, 0x75, 0x04, 0x0B, 0xFF, 0xFB,
  0x0C, 0x06, 0x77, 0x73, 0x81, 0x28, 0xDF, 0xFB, 0x82, 0xEA, 0x61, 0x77, 0x77, 0x18, 0x51, 0x58,
  0xAC, 0xDE, 0xA8, 0x6E, 0xDC, 0xCA, 0x75, 0x27, 0x70,
  // "ġ" (U+0121)
  0x77, 0x18, 0x43, 0xAE, 0xFD, 0x87, 0x77, 0x75, 0x04, 0xE0, 0xD0, 0x17, 0x77, 0x73, 0x0D, 0xF0,
  0x97, 0x77, 0x72, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0xA0, 0x17, 0x77, 0x71, 0x06, 0xFA,
  0x01, 0x77, 0x77, 0x10, 0x5F, 0xA0, 0x17, 0x77, 0x71, 0x03, 0xF9, 0x0E, 0x77, 0x77, 0x30, 0xDF,
  0x09, 0x77, 0x77, 0x30, 0x4E, 0x0D, 0x01, 0x77, 0x77, 0x48, 0x43, 0xAE, 0xFD, 0x88, 0x0C, 0xB7,
  0x08, 0x43, 0xAD, 0xFD, 0x87, 0x77, 0x75, 0x09, 0xE0, 0xB7, 0x78, 0x91, 0x58, 0xBD, 0xEF, 0xED,
  0xB7, 0x35, 0x01, 0x0C, 0xF9, 0x05, 0x73, 0x02, 0x09, 0xFD, 0x0C, 0x05, 0x20, 0x10, 0xCF, 0xA0,
  0x97, 0x20, 0x7F, 0xFA, 0x81, 0xB1, 0xCF, 0xB0, 0xB7, 0x10, 0xAF, 0xFF, 0xFA, 0x0A, 0x70, 0x9F,
  0x85, 0x94, 0x10, 0x14, 0xAF, 0x98, 0x3C, 0x40, 0x18, 0xC0, 0x76, 0x04, 0xE0, 0xE0, 0x47, 0x04,
  0x0E, 0xD0, 0xE5, 0x0D, 0xA0, 0xE7, 0x0D, 0xE0, 0x57, 0x20, 0x5E, 0x08, 0x48, 0x27, 0xFE, 0x46,
  0x07, 0xE0, 0xB7, 0x40, 0xCE, 0x02, 0x30, 0x20, 0x47, 0x10, 0xDE, 0x05, 0x74, 0x06, 0xE0, 0x97,
  0x50, 0x4F, 0x75, 0x01, 0xF0, 0x17, 0x40, 0x7E, 0x0C, 0x76, 0x0D, 0xE0, 0x67, 0x40, 0xBE, 0x09,
  0x76, 0x0B, 0xE0, 0xA7, 0x40, 0xEE, 0x07, 0x76, 0x09, 0xE0, 0xD7, 0x4F, 0x06, 0x76, 0x08, 0xE0,
  0xE7, 0x30, 0x1F, 0x05, 0x76, 0x07, 0xF7, 0x30, 0x2F, 0x05, 0x76, 0x07, 0xF0, 0x17, 0x20, 0x3F,
  0x05, 0x76, 0x07, 0xF0, 0x17, 0x20, 0x2F, 0x06, 0x76, 0x08, 0xF7, 0x30, 0x1F, 0x06, 0x76, 0x08,
  0xE0, 0xE7, 0x40, 0xEE, 0x08, 0x76, 0x0A, 0xE0, 0xD7, 0x40, 0xBE, 0x0B, 0x76, 0x0C, 0xE0, 0x97,
  0x40, 0x7E, 0x0E, 0x76, 0xF0, 0x67, 0x40, 0x2F, 0x03, 0x74, 0x04, 0xF0, 0x17, 0x50, 0xBE, 0x0A,
  0x74, 0x0A, 0xE0, 0xA7, 0x60, 0x4F, 0x03, 0x72, 0x03, 0xF0, 0x47, 0x70, 0xAE, 0x0E, 0x03, 0x70,
  0x20, 0xDE, 0x0A, 0x77, 0x10, 0x10, 0xDF, 0x85, 0x94, 0x10, 0x13, 0x8F, 0x0E, 0x01, 0x77, 0x20,
  0x20, 0xEF, 0xFE, 0x04, 0x77, 0x40, 0x10, 0xCF, 0xFC, 0x05, 0x77, 0x70, 0x7F, 0xF9, 0x0C, 0x02,
  0x77, 0x70, 0x10, 0xBF, 0xE0, 0xA0, 0x47, 0x77, 0x10, 0x30, 0xEB, 0x89, 0x09, 0x14, 0x78, 0x98,
  0x76, 0x37, 0x77, 0x30, 0x30, 0xEB, 0x09, 0x77, 0x77, 0x50, 0x10, 0xEB, 0x0D, 0x77, 0x77, 0x60,
  0x9C, 0x06, 0x77, 0x77, 0x50, 0x1D, 0x02, 0x77, 0x77, 0x50, 0x4D, 0x01, 0x77, 0x77, 0x50, 0x6D,
  0x03, 0x77, 0x77, 0x50, 0x6D, 0x0B, 0x77, 0x77, 0x50, 0x4E, 0x81, 0xC5, 0x27, 0x77, 0x73, 0x0E,
  0xFF, 0xC8, 0x3E, 0xDB, 0x94, 0x77, 0x20, 0x7F, 0xFF, 0xA0, 0xE0, 0x77, 0x71, 0x09, 0xFF, 0xFB,
  0x0D, 0x02, 0x77, 0x07, 0xFF, 0xFB, 0x0E, 0x03, 0x77, 0x06, 0xFF, 0xFB, 0x0D, 0x01, 0x73, 0x81,
  0x17, 0xEF, 0xFF, 0xD0, 0xA7, 0x20, 0x50, 0xEF, 0xFF, 0xF9, 0x02, 0x70, 0x8E, 0x82, 0xC7, 0x31,
  0x72, 0x82, 0x13, 0x7C, 0xF9, 0x08, 0x60, 0x9D, 0x0E, 0x05, 0x77, 0x30, 0x6F, 0x0D, 0x50, 0x7D,
  0x0E, 0x03, 0x77, 0x50, 0x7F, 0x02, 0x30, 0x1E, 0x06, 0x77, 0x70, 0xEE, 0x04, 0x30, 0x8D, 0x0D,
  0x77, 0x71, 0x0A, 0xE0, 0x63, 0x0D, 0xD0, 0x87, 0x77, 0x10, 0x6E, 0x07, 0x20, 0x2E, 0x05, 0x77,
  0x71, 0x05, 0xE0, 0x72, 0x04, 0xE0, 0x37, 0x77, 0x10, 0x5E, 0x07, 0x20, 0x6E, 0x03, 0x77, 0x71,
  0x05, 0xE0, 0x52, 0x06, 0xE0, 0x37, 0x77, 0x10, 0x7E, 0x03, 0x20, 0x6E, 0x04, 0x77, 0x71, 0x0A,
  0xE3, 0x04, 0xE0, 0x77, 0x77, 0x10, 0xED, 0x0C, 0x30, 0x3E, 0x0B, 0x77, 0x70, 0x5E, 0x07, 0x40,
  0xEE, 0x01, 0x77, 0x60, 0xDD, 0x0E, 0x01, 0x40, 0xAE, 0x09, 0x77, 0x50, 0x9E, 0x08, 0x50, 0x5F,
  0x04, 0x77, 0x30, 0x9E, 0x0D, 0x70, 0xCF, 0x04, 0x77, 0x03, 0x0C, 0xF0, 0x37, 0x03, 0xF9, 0x0B,
  0x04, 0x72, 0x81, 0x26, 0xBF, 0x90, 0x57, 0x20, 0x5F, 0xB8, 0x6C, 0xA9, 0x9A, 0xAC, 0xEF, 0xB0,
  0x57, 0x40, 0x5F, 0xFF, 0xC0, 0xD0, 0x37, 0x60, 0x30, 0xCF, 0xFF, 0x0D, 0x06, 0x77, 0x30, 0x40,
  0xBF, 0xFA, 0x81, 0xEA, 0x57, 0x77, 0x84, 0x15, 0x8A, 0xCE, 0xB8, 0x5E, 0xEC, 0xB9, 0x63, 0x77,
  0x10,
  // "Ģ" (U+0122)
  0x77, 0x68, 0x43, 0x79, 0xBD, 0xEA, 0x86, 0xEE, 0xDC, 0xA7, 0x52, 0x77, 0x77, 0x30, 0x50, 0xAF,
  0xFB, 0x81, 0xC8, 0x27, 0x77, 0x48, 0x11, 0x8E, 0xFF, 0xF9, 0x09, 0x02, 0x77, 0x71, 0x06, 0x0E,
  0xFF, 0xFC, 0x0E, 0x05, 0x77, 0x50, 0x10, 0xBF, 0xB8, 0x5E, 0xCA, 0x99, 0xAC, 0xFD, 0x07, 0x77,
  0x30, 0x30, 0xDF, 0x98, 0x1C, 0x72, 0x71, 0x05, 0x0C, 0xFB, 0x06, 0x77, 0x10, 0x5F, 0x90, 0xC0,
  0x47, 0x60, 0x7F, 0xA0, 0xE0, 0x17, 0x60, 0x4F, 0x90, 0x87, 0x72, 0x06, 0xFA, 0x07, 0x75, 0x03,
  0x0E, 0xF0, 0x57, 0x74, 0x09, 0xF9, 0x0B, 0x74, 0x01, 0x0E, 0xF0, 0x67, 0x76, 0x0D, 0xF0, 0xD7,
  0x40, 0xAF, 0x09, 0x77, 0x70, 0x7F, 0x0C, 0x73, 0x05, 0xF0, 0xE0, 0x17, 0x77, 0x01, 0xF0, 0xA7,
  0x20, 0x10, 0xEF, 0x06, 0x77, 0x72, 0x0C, 0xE0, 0x47, 0x20, 0x7F, 0x0D, 0x77, 0x73, 0x08, 0xD0,
  0xA7, 0x30, 0xEF, 0x07, 0x77, 0x73, 0x06, 0xC0, 0x97, 0x30, 0x7F, 0x90, 0x17, 0x77, 0x38, 0x35,
  0xEC, 0x93, 0x74, 0x0D, 0xF0, 0xC8, 0x0C, 0x40, 0x03, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0x8F, 0x90,
  0x38, 0x0C, 0x40, 0x0E, 0xF0, 0xE8, 0x0C, 0x40, 0x02, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x6F, 0x90,
  0x88, 0x0C, 0x40, 0x09, 0xF9, 0x06, 0x80, 0xC4, 0x00, 0xDF, 0x90, 0x48, 0x0C, 0x40, 0xFA, 0x02,
  0x80, 0xC3, 0x00, 0x2F, 0xA8, 0x0C, 0x40, 0x04, 0xF9, 0x0E, 0x80, 0xC4, 0x00, 0x6F, 0x90, 0xD8,
  0x0C, 0x40, 0x07, 0xF9, 0x0C, 0x80, 0xC4, 0x00, 0x8F, 0x90, 0xB8, 0x0C, 0x40, 0x09, 0xF9, 0x0B,
  0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB8, 0x0C, 0x40, 0x0A, 0xF9, 0x0A, 0x80, 0xC4, 0x00, 0xAF, 0x90,
  0xA8, 0x0C, 0x40, 0x09, 0xF9, 0x0B, 0x80, 0xC4, 0x00, 0x9F, 0x90, 0xB7, 0x75, 0x09, 0xFF, 0xD0,
  0xC0, 0x8F, 0x90, 0xB7, 0x75, 0x09, 0xFF, 0xD0, 0xC0, 0x7F, 0x90, 0xC7, 0x75, 0x09, 0xFF, 0xD0,
  0xC0, 0x6F, 0x90, 0xD7, 0x75, 0x09, 0xFF, 0xD0, 0xC0, 0x4F, 0x90, 0xE7, 0x77, 0x81, 0x14, 0xAF,
  0xD0, 0x90, 0x32, 0x02, 0xFA, 0x77, 0x73, 0x05, 0xFB, 0x06, 0x5F, 0xA0, 0x27, 0x77, 0x30, 0xAF,
  0x90, 0xE6, 0x0D, 0xF9, 0x04, 0x77, 0x73, 0x06, 0xF9, 0x0A, 0x60, 0xAF, 0x90, 0x77, 0x77, 0x30,
  0x3F, 0x90, 0x86, 0x07, 0xF9, 0x09, 0x77, 0x73, 0x02, 0xF9, 0x07, 0x60, 0x3F, 0x90, 0xC7, 0x77,
  0x30, 0x1F, 0x90, 0x67, 0xFA, 0x77, 0x73, 0x01, 0xF9, 0x06, 0x70, 0xAF, 0x90, 0x47, 0x77, 0x20,
  0x1F, 0x90, 0x67, 0x05, 0xF9, 0x08, 0x77, 0x72, 0x01, 0xF9, 0x06, 0x71, 0xF9, 0x0D, 0x77, 0x72,
  0x01, 0xF9, 0x06, 0x71, 0x0A, 0xF9, 0x03, 0x77, 0x71, 0x01, 0xF9, 0x06, 0x71, 0x03, 0xF9, 0x09,
  0x77, 0x71, 0x01, 0xF9, 0x06, 0x72, 0x0B, 0xF0, 0xE0, 0x17, 0x77, 0x01, 0xF9, 0x06, 0x72, 0x04,
  0xF9, 0x08, 0x77, 0x70, 0x1F, 0x90, 0x67, 0x30, 0xAF, 0x90, 0x27, 0x76, 0x01, 0xF9, 0x06, 0x73,
  0x01, 0x0E, 0xF0, 0xC7, 0x76, 0x01, 0xF9, 0x06, 0x74, 0x05, 0xF9, 0x09, 0x77, 0x50, 0x1F, 0x90,
  0x67, 0x50, 0x8F, 0x90, 0x97, 0x74, 0x01, 0xF9, 0x06, 0x76, 0x0A, 0xF9, 0x0B, 0x01, 0x77, 0x20,
  0x1F, 0x90, 0x67, 0x70, 0xBF, 0x98, 0x1E, 0x71, 0x77, 0x01, 0xF9, 0x06, 0x77, 0x10, 0x8F, 0xA8,
  0x2E, 0x95, 0x17, 0x28, 0x11, 0x5A, 0xF9, 0x06, 0x77, 0x20, 0x5F, 0xD8, 0x7E, 0xBA, 0x99, 0x9A,
  0xBD, 0xFC, 0x06, 0x77, 0x30, 0x20, 0xBF, 0xFF, 0xF8, 0x1E, 0x91, 0x77, 0x50, 0x40, 0xBF, 0xFF,
  0xB0, 0xC0, 0x67, 0x77, 0x38, 0x12, 0x8D, 0xFF, 0xB8, 0x2E, 0xA6, 0x17, 0x77, 0x71, 0x85, 0x15,
  0x8A, 0xCD, 0xEA, 0x86, 0xED, 0xCC, 0xA7, 0x52, 0x80, 0xCB, 0x30, 0x09, 0xE0, 0xD8, 0x0C, 0x60,
  0x0B, 0xE0, 0x98, 0x0C, 0x60, 0x0D, 0xE0, 0x38, 0x0C, 0x60, 0xE0, 0xC8, 0x0C, 0x60, 0x03, 0xE0,
  0x58, 0x0C, 0x60, 0x06, 0xD0, 0xD8, 0x0C, 0x70, 0x09, 0xD0, 0x58, 0x0C, 0x70, 0x0C, 0xC0, 0xD8,
  0x0D, 0x00, 0xD0, 0x58, 0x0C, 0x70, 0x03, 0xC0, 0xD8, 0x0D, 0x00, 0x06, 0xC0, 0x58, 0x0D, 0x00,
  0x0A, 0xB0, 0xC8, 0x0D, 0x10, 0x0D, 0xB0, 0x38, 0x0D, 0x10, 0x0E, 0xA0, 0x97, 0x77, 0x40,
  // "ģ" (U+0123)
  0x77, 0x70, 0xAB, 0x02, 0x77, 0x77, 0x60, 0x4C, 0x01, 0x77, 0x77, 0x60, 0xCB, 0x0E, 0x77, 0x77,
  0x60, 0x5C, 0x0B, 0x77, 0x77, 0x60, 0xDC, 0x07, 0x77, 0x77, 0x50, 0x6D, 0x04, 0x77, 0x77, 0x50,
  0xDD, 0x01, 0x77, 0x77, 0x40, 0x6D, 0x0D, 0x77, 0x77, 0x50, 0xDD, 0x0A, 0x77, 0x77, 0x40, 0x6E,
  0x08, 0x77, 0x77, 0x40, 0xCE, 0x05, 0x77, 0x77, 0x30, 0x4F, 0x02, 0x77, 0x77, 0x30, 0x9F, 0x77,
  0x77, 0x40, 0xDE, 0x0D, 0x80, 0xAC, 0x50, 0x84, 0x3A, 0xDF, 0xD8, 0x77, 0x77, 0x50, 0x9E, 0x0B,
  0x77, 0x89, 0x15, 0x8B, 0xDE, 0xFE, 0xDB, 0x73, 0x50, 0x10, 0xCF, 0x90, 0x57, 0x30, 0x20, 0x9F,
  0xD0, 0xC0, 0x52, 0x01, 0x0C, 0xFA, 0x09, 0x72, 0x07, 0xFF, 0xA8, 0x1B, 0x1C, 0xFB, 0x0B, 0x71,
  0x0A, 0xFF, 0xFF, 0xA0, 0xA7, 0x09, 0xF8, 0x59, 0x41, 0x01, 0x4A, 0xF9, 0x83, 0xC4, 0x01, 0x8C,
  0x07, 0x60, 0x4E, 0x0E, 0x04, 0x70, 0x40, 0xED, 0x0E, 0x50, 0xDA, 0x0E, 0x70, 0xDE, 0x05, 0x72,
  0x05, 0xE0, 0x84, 0x82, 0x7F, 0xE4, 0x60, 0x7E, 0x0B, 0x74, 0x0C, 0xE0, 0x23, 0x02, 0x04, 0x71,
  0x0D, 0xE0, 0x57, 0x40, 0x6E, 0x09, 0x75, 0x04, 0xF7, 0x50, 0x1F, 0x01, 0x74, 0x07, 0xE0, 0xC7,
  0x60, 0xDE, 0x06, 0x74, 0x0B, 0xE0, 0x97, 0x60, 0xBE, 0x0A, 0x74, 0x0E, 0xE0, 0x77, 0x60, 0x9E,
  0x0D, 0x74, 0xF0, 0x67, 0x60, 0x8E, 0x0E, 0x73, 0x01, 0xF0, 0x57, 0x60, 0x7F, 0x73, 0x02, 0xF0,
  0x57, 0x60, 0x7F, 0x01, 0x72, 0x03, 0xF0, 0x57, 0x60, 0x7F, 0x01, 0x72, 0x02, 0xF0, 0x67, 0x60,
  0x8F, 0x73, 0x01, 0xF0, 0x67, 0x60, 0x8E, 0x0E, 0x74, 0x0E, 0xE0, 0x87, 0x60, 0xAE, 0x0D, 0x74,
  0x0B, 0xE0, 0xB7, 0x60, 0xCE, 0x09, 0x74, 0x07, 0xE0, 0xE7, 0x6F, 0x06, 0x74, 0x02, 0xF0, 0x37,
  0x40, 0x4F, 0x01, 0x75, 0x0B, 0xE0, 0xA7, 0x40, 0xAE, 0x0A, 0x76, 0x04, 0xF0, 0x37, 0x20, 0x3F,
  0x04, 0x77, 0x0A, 0xE0, 0xE0, 0x37, 0x02, 0x0D, 0xE0, 0xA7, 0x71, 0x01, 0x0D, 0xF8, 0x59, 0x41,
  0x01, 0x38, 0xF0, 0xE0, 0x17, 0x72, 0x02, 0x0E, 0xFF, 0xE0, 0x47, 0x74, 0x01, 0x0C, 0xFF, 0xC0,
  0x57, 0x77, 0x07, 0xFF, 0x90, 0xC0, 0x27, 0x77, 0x01, 0x0B, 0xFE, 0x0A, 0x04, 0x77, 0x71, 0x03,
  0x0E, 0xB8, 0x90, 0x91, 0x47, 0x89, 0x87, 0x63, 0x77, 0x73, 0x03, 0x0E, 0xB0, 0x97, 0x77, 0x75,
  0x01, 0x0E, 0xB0, 0xD7, 0x77, 0x76, 0x09, 0xC0, 0x67, 0x77, 0x75, 0x01, 0xD0, 0x27, 0x77, 0x75,
  0x04, 0xD0, 0x17, 0x77, 0x75, 0x06, 0xD0, 0x37, 0x77, 0x75, 0x06, 0xD0, 0xB7, 0x77, 0x75, 0x04,
  0xE8, 0x1C, 0x52, 0x77, 0x77, 0x30, 0xEF, 0xFC, 0x83, 0xED, 0xB9, 0x47, 0x72, 0x07, 0xFF, 0xFA,
  0x0E, 0x07, 0x77, 0x10, 0x9F, 0xFF, 0xB0, 0xD0, 0x27, 0x70, 0x7F, 0xFF, 0xB0, 0xE0, 0x37, 0x70,
  0x6F, 0xFF, 0xB0, 0xD0, 0x17, 0x38, 0x11, 0x7E, 0xFF, 0xFD, 0x0A, 0x72, 0x05, 0x0E, 0xFF, 0xFF,
  0x90, 0x27, 0x08, 0xE8, 0x2C, 0x73, 0x17, 0x28, 0x21, 0x37, 0xCF, 0x90, 0x86, 0x09, 0xD0, 0xE0,
  0x57, 0x73, 0x06, 0xF0, 0xD5, 0x07, 0xD0, 0xE0, 0x37, 0x75, 0x07, 0xF0, 0x23, 0x01, 0xE0, 0x67,
  0x77, 0x0E, 0xE0, 0x43, 0x08, 0xD0, 0xD7, 0x77, 0x10, 0xAE, 0x06, 0x30, 0xDD, 0x08, 0x77, 0x71,
  0x06, 0xE0, 0x72, 0x02, 0xE0, 0x57, 0x77, 0x10, 0x5E, 0x07, 0x20, 0x4E, 0x03, 0x77, 0x71, 0x05,
  0xE0, 0x72, 0x06, 0xE0, 0x37, 0x77, 0x10, 0x5E, 0x05, 0x20, 0x6E, 0x03, 0x77, 0x71, 0x07, 0xE0,
  0x32, 0x06, 0xE0, 0x47, 0x77, 0x10, 0xAE, 0x30, 0x4E, 0x07, 0x77, 0x71, 0x0E, 0xD0, 0xC3, 0x03,
  0xE0, 0xB7, 0x77, 0x05, 0xE0, 0x74, 0x0E, 0xE0, 0x17, 0x76, 0x0D, 0xD0, 0xE0, 0x14, 0x0A, 0xE0,
  0x97, 0x75, 0x09, 0xE0, 0x85, 0x05, 0xF0, 0x47, 0x73, 0x09, 0xE0, 0xD7, 0x0C, 0xF0, 0x47, 0x70,
  0x30, 0xCF, 0x03, 0x70, 0x3F, 0x90, 0xB0, 0x47, 0x28, 0x12, 0x6B, 0xF9, 0x05, 0x72, 0x05, 0xFB,
  0x86, 0xCA, 0x99, 0xAA, 0xCE, 0xFB, 0x05, 0x74, 0x05, 0xFF, 0xFC, 0x0D, 0x03, 0x76, 0x03, 0x0C,
  0xFF, 0xF0, 0xD0, 0x67, 0x73, 0x04, 0x0B, 0xFF, 0xA8, 0x1E, 0xA5, 0x77, 0x78, 0x41, 0x58, 0xAC,
  0xEB, 0x85, 0xEE, 0xCB, 0x96, 0x37, 0x71,
  // "Ĥ" (U+0124)
  0x77, 0x73, 0x05, 0x80, 0x37, 0x02, 0x80, 0xD3, 0x00, 0x10, 0xEF, 0x0B, 0x80, 0xD3, 0x00, 0x7F,
  0xA0, 0x28, 0x0D, 0x10, 0x01, 0x0E, 0xFA, 0x0A, 0x80, 0xD1, 0x00, 0x8F, 0xC0, 0x38, 0x0C, 0x70,
  0x02, 0xFD, 0x0C, 0x80, 0xC7, 0x00, 0xBD, 0x0C, 0x05, 0xE0, 0x58, 0x0C, 0x50, 0x05, 0xD8, 0x2E,
  0x20, 0x7D, 0x0E, 0x01, 0x80, 0xC4, 0x00, 0xDD, 0x05, 0x30, 0xAD, 0x09, 0x80, 0xC3, 0x00, 0x8D,
  0x06, 0x50, 0xBD, 0x03, 0x80, 0xC1, 0x00, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x80, 0xC1, 0x00, 0xCC,
  0x08, 0x71, 0x01, 0x0C, 0xC0, 0x77, 0x77, 0x77, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x02, 0x77,
  0x77, 0x50, 0x2C, 0x08, 0x75, 0x01, 0x0C, 0xB0, 0xC7, 0x77, 0x75, 0x06, 0xB0, 0x87, 0x70, 0x10,
  0xCB, 0x01, 0x80, 0xCD, 0x10, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF,
  0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07,
  0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x38, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37,
  0x71, 0x81, 0x25, 0xCF, 0xD8, 0x1C, 0x52, 0x72, 0x04, 0xFB, 0x0C, 0x01, 0x77, 0x60, 0x9F, 0xB0,
  0x77, 0x60, 0x8F, 0xA0, 0x37, 0x77, 0x10, 0xEF, 0x90, 0xD7, 0x70, 0x3F, 0x90, 0xE7, 0x77, 0x20,
  0x9F, 0x90, 0x77, 0x71, 0xF9, 0x0B, 0x77, 0x72, 0x07, 0xF9, 0x04, 0x77, 0x10, 0xEF, 0x0A, 0x77,
  0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77,
  0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9,
  0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72,
  0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09,
  0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03,
  0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05,
  0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77,
  0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xE8, 0x0C, 0x4F, 0x03, 0x77, 0x10, 0xE8, 0x0C,
  0x4F, 0x03, 0x77, 0x10, 0xE8, 0x0C, 0x4F, 0x03, 0x77, 0x10, 0xE8, 0x0C, 0x4F, 0x03, 0x77, 0x10,
  0xEF, 0x0D, 0x80, 0xA3, 0x90, 0xBF, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90,
  0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20,
  0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97,
  0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E,
  0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37,
  0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F,
  0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0,
  0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71,
  0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90,
  0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20,
  0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97,
  0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0xF9, 0x0A, 0x77, 0x72, 0x06, 0xF9, 0x03, 0x77, 0x1F, 0x90,
  0xB7, 0x77, 0x20, 0x7F, 0x90, 0x47, 0x70, 0x3F, 0x90, 0xE7, 0x77, 0x20, 0xAF, 0x90, 0x77, 0x70,
  0x8F, 0xA0, 0x37, 0x77, 0x10, 0xEF, 0x90, 0xC7, 0x60, 0x3F, 0xB0, 0xC0, 0x17, 0x76, 0x09, 0xFB,
  0x07, 0x72, 0x81, 0x14, 0x9F, 0xD8, 0x1E, 0x73, 0x77, 0x18, 0x12, 0x5C, 0xFD, 0x81, 0xB5, 0x23,
  0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF,
  0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72,
  0x02, 0xFF, 0xF9, 0x07,
  // "ĥ" (U+0125)
  0x77, 0x10, 0x58, 0x03, 0x70, 0x28, 0x0C, 0x10, 0x01, 0x0E, 0xF0, 0xB8, 0x0C, 0x10, 0x07, 0xFA,
  0x02, 0x77, 0x77, 0x70, 0x10, 0xEF, 0xA0, 0xA7, 0x77, 0x77, 0x08, 0xFC, 0x03, 0x77, 0x77, 0x50,
  0x2F, 0xD0, 0xC7, 0x77, 0x75, 0x0B, 0xD0, 0xC0, 0x5E, 0x05, 0x77, 0x77, 0x30, 0x5D, 0x82, 0xE2,
  0x07, 0xD0, 0xE0, 0x17, 0x77, 0x72, 0x0D, 0xD0, 0x53, 0x0A, 0xD0, 0x97, 0x77, 0x71, 0x08, 0xD0,
  0x65, 0x0B, 0xD0, 0x37, 0x77, 0x60, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x77, 0x76, 0x0C, 0xC0, 0x87,
  0x10, 0x10, 0xCC, 0x07, 0x77, 0x74, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x02, 0x77, 0x72, 0x02,
  0xC0, 0x87, 0x50, 0x10, 0xCB, 0x0C, 0x77, 0x72, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB, 0x01, 0x80,
  0xAB, 0x00, 0x0A, 0xFF, 0x03, 0x77, 0x77, 0x30, 0xAF, 0xF0, 0x37, 0x77, 0x73, 0x0A, 0xFF, 0x03,
  0x77, 0x77, 0x30, 0xAF, 0xF0, 0x37, 0x77, 0x75, 0x81, 0x15, 0xAF, 0xB0, 0x38, 0x0C, 0x00, 0x04,
  0x0E, 0xF9, 0x03, 0x80, 0xC1, 0x00, 0x7F, 0x90, 0x38, 0x0C, 0x10, 0x01, 0xF9, 0x03, 0x80, 0xC2,
  0x00, 0xEF, 0x03, 0x80, 0xC2, 0x00, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00,
  0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF,
  0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03,
  0x80, 0xC2, 0x00, 0xCF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x68, 0x90, 0x27, 0xBD, 0xEF, 0xEC,
  0x95, 0x77, 0x71, 0x0C, 0xF0, 0x34, 0x01, 0x0A, 0xFB, 0x0E, 0x07, 0x77, 0x60, 0xCF, 0x02, 0x30,
  0x40, 0xEF, 0xE0, 0xD0, 0x27, 0x74, 0x0C, 0xF0, 0x22, 0x04, 0xFF, 0xA0, 0xE0, 0x27, 0x73, 0x0C,
  0xF8, 0x21, 0x02, 0xEF, 0xFB, 0x0D, 0x77, 0x30, 0xCF, 0x20, 0xCF, 0xFD, 0x08, 0x77, 0x20, 0xCF,
  0x10, 0x7B, 0x81, 0xC5, 0x22, 0x81, 0x25, 0xAF, 0xB0, 0x17, 0x71, 0x0C, 0xE8, 0x1E, 0x1E, 0xA0,
  0x57, 0x10, 0x40, 0xEF, 0x90, 0x87, 0x71, 0x0C, 0xE0, 0xD0, 0x8A, 0x04, 0x73, 0x04, 0xF9, 0x0D,
  0x77, 0x10, 0xCF, 0xA0, 0x87, 0x50, 0x9F, 0x90, 0x27, 0x70, 0xCF, 0x90, 0xE7, 0x60, 0x2F, 0x90,
  0x67, 0x70, 0xCF, 0x90, 0x87, 0x70, 0xCF, 0x09, 0x77, 0x0C, 0xF9, 0x03, 0x77, 0x08, 0xF0, 0xB7,
  0x70, 0xCF, 0x0E, 0x77, 0x10, 0x5F, 0x0D, 0x77, 0x0C, 0xF0, 0xB7, 0x71, 0x03, 0xF0, 0xE7, 0x70,
  0xCF, 0x08, 0x77, 0x10, 0x1F, 0x97, 0x70, 0xCF, 0x06, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x05, 0x77,
  0x2F, 0x97, 0x70, 0xCF, 0x04, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF,
  0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97,
  0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77,
  0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF,
  0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97,
  0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77,
  0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF,
  0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97, 0x70, 0xCF, 0x03, 0x77, 0x2F, 0x97,
  0x70, 0xDF, 0x03, 0x77, 0x2F, 0x90, 0x17, 0x60, 0xEF, 0x04, 0x77, 0x2F, 0x90, 0x27, 0x50, 0x2F,
  0x90, 0x77, 0x72, 0xF9, 0x05, 0x75, 0x08, 0xF9, 0x0C, 0x77, 0x2F, 0x90, 0xA7, 0x40, 0x40, 0xEF,
  0xA0, 0x67, 0x71, 0xFA, 0x04, 0x78, 0x11, 0x5A, 0xFD, 0x81, 0xB5, 0x27, 0x5F, 0xB8, 0x1A, 0x41,
  0x20, 0xAF, 0xFE, 0x07, 0x73, 0xFF, 0x01, 0x0A, 0xFF, 0xE0, 0x77, 0x3F, 0xF0, 0x10, 0xAF, 0xFE,
  0x07, 0x73, 0xFF, 0x01, 0x0A, 0xFF, 0xE0, 0x77, 0x3F, 0xF0, 0x10,
  // "Ħ" (U+0126)
  0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF,
  0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72, 0x02, 0xFF, 0xF9, 0x07, 0x03, 0xFF, 0xF9, 0x08, 0x72,
  0x02, 0xFF, 0xF9, 0x07, 0x38, 0x11, 0x49, 0xFD, 0x81, 0xD7, 0x27, 0x71, 0x81, 0x25, 0xBF, 0xD8,
  0x1B, 0x52, 0x72, 0x03, 0x0E, 0xFA, 0x0B, 0x77, 0x70, 0x8F, 0xB0, 0x67, 0x60, 0x7F, 0xA0, 0x27,
  0x77, 0x10, 0xDF, 0x90, 0xB7, 0x70, 0x2F, 0x90, 0xD7, 0x77, 0x20, 0x9F, 0x90, 0x77, 0x71, 0xF9,
  0x0A, 0x77, 0x72, 0x06, 0xF9, 0x04, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77,
  0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9,
  0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72,
  0x05, 0xF9, 0x03, 0x70, 0x28, 0x03, 0x9F, 0x90, 0xD8, 0x0A, 0x39, 0x0B, 0xF9, 0x0A, 0x80, 0x29,
  0x05, 0x04, 0x80, 0xE3, 0xF0, 0x90, 0x48, 0x0E, 0x3F, 0x09, 0x04, 0x80, 0xE3, 0xF0, 0x90, 0x48,
  0x0E, 0x3F, 0x09, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97,
  0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E,
  0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37,
  0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F,
  0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x20, 0x5F, 0x90, 0x37, 0x71, 0x0E, 0x80, 0xC4, 0xF0, 0x37, 0x71, 0x0E, 0x80, 0xC4, 0xF0, 0x37,
  0x71, 0x0E, 0x80, 0xC4, 0xF0, 0x37, 0x71, 0x0E, 0x80, 0xC4, 0xF0, 0x37, 0x71, 0x0E, 0xF0, 0xD8,
  0x0A, 0x39, 0x0B, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03,
  0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05,
  0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77,
  0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF,
  0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77,
  0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9,
  0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72,
  0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09,
  0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03,
  0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05, 0xF9, 0x03, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x72, 0x05,
  0xF9, 0x03, 0x77, 0x1F, 0x90, 0xA7, 0x77, 0x20, 0x6F, 0x90, 0x37, 0x71, 0xF9, 0x0B, 0x77, 0x72,
  0x07, 0xF9, 0x04, 0x77, 0x03, 0xF9, 0x0E, 0x77, 0x72, 0x0A, 0xF9, 0x07, 0x77, 0x08, 0xFA, 0x03,
  0x77, 0x71, 0x0E, 0xF9, 0x0C, 0x76, 0x04, 0xFB, 0x0C, 0x01, 0x77, 0x60, 0x9F, 0xB0, 0x77, 0x28,
  0x11, 0x49, 0xFD, 0x81, 0xE7, 0x37, 0x71, 0x81, 0x25, 0xCF, 0xD8, 0x1B, 0x52, 0x30, 0x3F, 0xFF,
  0x90, 0x87, 0x20, 0x2F, 0xFF, 0x90, 0x70, 0x3F, 0xFF, 0x90, 0x87, 0x20, 0x2F, 0xFF, 0x90, 0x70,
  0x3F, 0xFF, 0x90, 0x87, 0x20, 0x2F, 0xFF, 0x90, 0x70, 0x3F, 0xFF, 0x90, 0x87, 0x20, 0x2F, 0xFF,
  0x90, 0x70,
  // "ħ" (U+0127)
  0x0A, 0xFF, 0x03, 0x77, 0x77, 0x30, 0xAF, 0xF0, 0x37, 0x77, 0x73, 0x0A, 0xFF, 0x03, 0x77, 0x77,
  0x30, 0xAF, 0xF0, 0x37, 0x77, 0x75, 0x81, 0x14, 0xAF, 0xB0, 0x38, 0x0C, 0x00, 0x03, 0x0E, 0xF9,
  0x03, 0x80, 0xC1, 0x00, 0x6F, 0x90, 0x38, 0x0C, 0x10, 0x01, 0xF9, 0x03, 0x80, 0xC2, 0x00, 0xEF,
  0x03, 0x80, 0xC2, 0x00, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0xCF, 0x03, 0x77, 0x77, 0x30, 0xBF, 0xFF,
  0xE0, 0x17, 0x74, 0x0B, 0xFF, 0xFE, 0x01, 0x77, 0x40, 0xBF, 0xFF, 0xE0, 0x17, 0x74, 0x0B, 0xFF,
  0xFE, 0x01, 0x77, 0x74, 0x0C, 0xF0, 0x38, 0x0C, 0x20, 0x0C, 0xF0, 0x38, 0x0C, 0x20, 0x0C, 0xF0,
  0x38, 0x0C, 0x20, 0x0C, 0xF0, 0x38, 0x0C, 0x20, 0x0C, 0xF0, 0x38, 0x0C, 0x20, 0x0C, 0xF0, 0x38,
  0x0C, 0x20, 0x0C, 0xF0, 0x36, 0x82, 0x38, 0xBD, 0xA8, 0x2E, 0xC9, 0x57, 0x77, 0x10, 0xCF, 0x03,
  0x40, 0x20, 0xBF, 0xB0, 0xE0, 0x77, 0x76, 0x0C, 0xF0, 0x23, 0x06, 0xFF, 0x0D, 0x02, 0x77, 0x40,
  0xCF, 0x02, 0x20, 0x7F, 0xFA, 0x0E, 0x02, 0x77, 0x30, 0xCF, 0x81, 0x20, 0x5F, 0xFC, 0x0D, 0x77,
  0x30, 0xCF, 0x01, 0x02, 0xFF, 0xE0, 0x97, 0x72, 0x0C, 0xF0, 0x10, 0xCB, 0x81, 0xB5, 0x22, 0x81,
  0x25, 0xAF, 0xB0, 0x27, 0x71, 0x0C, 0xF0, 0x5A, 0x0E, 0x05, 0x71, 0x04, 0x0E, 0xF9, 0x08, 0x77,
  0x10, 0xCF, 0x0D, 0xA0, 0x37, 0x30, 0x4F, 0x90, 0xD7, 0x71, 0x0C, 0xFA, 0x08, 0x75, 0x09, 0xF9,
  0x03, 0x77, 0x0C, 0xF9, 0x0E, 0x76, 0x02, 0xF9, 0x06, 0x77, 0x0C, 0xF9, 0x08, 0x77, 0x0C, 0xF0,
  0x97, 0x70, 0xCF, 0x90, 0x37, 0x70, 0x8F, 0x0B, 0x77, 0x0C, 0xF0, 0xE7, 0x71, 0x05, 0xF0, 0xD7,
  0x70, 0xCF, 0x0B, 0x77, 0x10, 0x3F, 0x0E, 0x77, 0x0C, 0xF0, 0x87, 0x71, 0x01, 0xF9, 0x77, 0x0C,
  0xF0, 0x67, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x47, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x47, 0x72, 0xF9,
  0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37,
  0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C,
  0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9,
  0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37,
  0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C,
  0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9,
  0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0C, 0xF0, 0x37, 0x72, 0xF9, 0x77, 0x0D, 0xF0, 0x37,
  0x72, 0xF9, 0x01, 0x76, 0x0E, 0xF0, 0x47, 0x72, 0xF9, 0x02, 0x75, 0x02, 0xF9, 0x07, 0x77, 0x2F,
  0x90, 0x57, 0x50, 0x7F, 0x90, 0xC7, 0x72, 0xF9, 0x0A, 0x74, 0x04, 0x0E, 0xFA, 0x07, 0x77, 0x1F,
  0xA0, 0x47, 0x81, 0x15, 0xAF, 0xD8, 0x2C, 0x63, 0x17, 0x4F, 0xB8, 0x19, 0x41, 0x20, 0xAF, 0xFE,
  0x09, 0x73, 0xFF, 0x01, 0x0A, 0xFF, 0xE0, 0x97, 0x3F, 0xF0, 0x10, 0xAF, 0xFE, 0x09, 0x73, 0xFF,
  0x01, 0x0A, 0xFF, 0xE0, 0x97, 0x3F, 0xF0, 0x10,
  // "Ĩ" (U+0128)
  0x58, 0x62, 0x9D, 0xEE, 0xD9, 0x47, 0x50, 0xF3, 0x02, 0x40, 0x7F, 0x90, 0xC0, 0x47, 0x20, 0x5B,
  0x07, 0x30, 0x7F, 0xC0, 0xA0, 0x17, 0x09, 0xB0, 0x52, 0x04, 0xFE, 0x0E, 0x05, 0x50, 0x2C, 0x02,
  0x20, 0xDF, 0xF9, 0x84, 0xB4, 0x10, 0x4D, 0xB0, 0xD2, 0x05, 0xB8, 0x4E, 0x61, 0x14, 0xCF, 0xFA,
  0x07, 0x20, 0xAB, 0x06, 0x50, 0x7F, 0xF0, 0xE0, 0x12, 0x0E, 0xA0, 0xE7, 0x03, 0x0E, 0xFD, 0x07,
  0x20, 0x2B, 0x0A, 0x71, 0x01, 0x0B, 0xFB, 0x0B, 0x30, 0x4B, 0x07, 0x73, 0x07, 0x0E, 0xF0, 0xA0,
  0x14, 0x0F, 0x17, 0x58, 0x61, 0x7C, 0xEF, 0xDA, 0x48, 0x0A, 0xA4, 0x00, 0x3F, 0xFF, 0x90, 0xE5,
  0x03, 0xFF, 0xF9, 0x0E, 0x50, 0x3F, 0xFF, 0x90, 0xE5, 0x03, 0xFF, 0xF9, 0x0E, 0x71, 0x81, 0x14,
  0xAF, 0xD8, 0x1E, 0x73, 0x77, 0x04, 0xFB, 0x0D, 0x01, 0x77, 0x30, 0x9F, 0xA0, 0x47, 0x74, 0x03,
  0xF9, 0x0E, 0x77, 0x6F, 0x90, 0xB7, 0x76, 0xF9, 0x0A, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF,
  0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x6F, 0x90, 0xA7, 0x76, 0xF9, 0x0B,
  0x77, 0x50, 0x3F, 0x90, 0xE7, 0x75, 0x08, 0xFA, 0x04, 0x77, 0x30, 0x4F, 0xB0, 0xC0, 0x17, 0x68,
  0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37, 0x10, 0x3F, 0xFF, 0x90, 0xE5, 0x03, 0xFF, 0xF9, 0x0E, 0x50,
  0x3F, 0xFF, 0x90, 0xE5, 0x03, 0xFF, 0xF9, 0x0E, 0x30,
  // "ĩ" (U+0129)
  0x58, 0x62, 0x9D, 0xEE, 0xD9, 0x47, 0x50, 0xF3, 0x02, 0x40, 0x7F, 0x90, 0xC0, 0x47, 0x20, 0x5B,
  0x07, 0x30, 0x7F, 0xC0, 0xA0, 0x17, 0x09, 0xB0, 0x52, 0x04, 0xFE, 0x0E, 0x05, 0x50, 0x2C, 0x02,
  0x20, 0xDF, 0xF9, 0x84, 0xB4, 0x10, 0x4D, 0xB0, 0xD2, 0x05, 0xB8, 0x4E, 0x61, 0x14, 0xCF, 0xFA,
  0x07, 0x20, 0xAB, 0x06, 0x50, 0x7F, 0xF0, 0xE0, 0x12, 0x0E, 0xA0, 0xE7, 0x03, 0x0E, 0xFD, 0x07,
  0x20, 0x2B, 0x0A, 0x71, 0x01, 0x0B, 0xFB, 0x0B, 0x30, 0x4B, 0x07, 0x73, 0x07, 0x0E, 0xF0, 0xA0,
  0x14, 0x0F, 0x17, 0x58, 0x61, 0x7C, 0xEF, 0xDA, 0x48, 0x0A, 0xE3, 0x00, 0xBF, 0xE0, 0xC7, 0x70,
  0xBF, 0xE0, 0xC7, 0x70, 0xBF, 0xE0, 0xC7, 0x70, 0xBF, 0xE0, 0xC7, 0x72, 0x81, 0x15, 0xBF, 0xA0,
  0xC7, 0x75, 0x06, 0xF9, 0x0C, 0x77, 0x60, 0xCF, 0x0C, 0x77, 0x60, 0x7F, 0x0C, 0x77, 0x60, 0x4F,
  0x0C, 0x77, 0x60, 0x3F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F,
  0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F,
  0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F,
  0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F,
  0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F,
  0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F,
  0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F, 0x0C, 0x77, 0x60, 0x2F,
  0x0C, 0x77, 0x60, 0x2F, 0x0D, 0x77, 0x60, 0x3F, 0x0D, 0x77, 0x60, 0x4F, 0x0E, 0x77, 0x60, 0x7F,
  0x90, 0x27, 0x75, 0x0C, 0xF9, 0x08, 0x77, 0x40, 0x6F, 0xA0, 0xE0, 0x37, 0x78, 0x12, 0x5B, 0xFD,
  0x81, 0xA4, 0x17, 0x10, 0x4F, 0xFF, 0x0E, 0x60, 0x4F, 0xFF, 0x0E, 0x60, 0x4F, 0xFF, 0x0E, 0x60,
  0x4F, 0xFF, 0x0E, 0x30,
  // "Ī" (U+012A)
  0x10, 0x38, 0x0A, 0x19, 0x81, 0x70, 0x6F, 0xFF, 0x81, 0xC0, 0x6F, 0xFF, 0x81, 0xC0, 0x6F, 0xFF,
  0x81, 0xC0, 0x6F, 0xFF, 0x0C, 0x80, 0xA9, 0x40, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E,
  0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x38, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37, 0x20,
  0x4F, 0xB0, 0xD0, 0x17, 0x50, 0x9F, 0xA0, 0x47, 0x60, 0x3F, 0x90, 0xE7, 0x71, 0xF9, 0x0B, 0x77,
  0x1F, 0x90, 0xA7, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0xF9, 0x0A, 0x77, 0x1F, 0x90, 0xB7, 0x70, 0x3F, 0x90, 0xE7, 0x70, 0x8F,
  0xA0, 0x47, 0x50, 0x4F, 0xB0, 0xC0, 0x17, 0x18, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x33, 0x03, 0xFF,
  0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E,
  // "ī" (U+012B)
  0x03, 0x80, 0xA1, 0x98, 0x17, 0x06, 0xFF, 0xF8, 0x1C, 0x06, 0xFF, 0xF8, 0x1C, 0x06, 0xFF, 0xF8,
  0x1C, 0x06, 0xFF, 0xF0, 0xC8, 0x0A, 0xC7, 0x00, 0xBF, 0xE0, 0xC7, 0x20, 0xBF, 0xE0, 0xC7, 0x20,
  0xBF, 0xE0, 0xC7, 0x20, 0xBF, 0xE0, 0xC7, 0x48, 0x11, 0x5B, 0xFA, 0x0C, 0x77, 0x06, 0xF9, 0x0C,
  0x77, 0x10, 0xCF, 0x0C, 0x77, 0x10, 0x7F, 0x0C, 0x77, 0x10, 0x4F, 0x0C, 0x77, 0x10, 0x3F, 0x0C,
  0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C,
  0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C,
  0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C,
  0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C,
  0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C,
  0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C,
  0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0C, 0x77, 0x10, 0x2F, 0x0D,
  0x77, 0x10, 0x3F, 0x0D, 0x77, 0x10, 0x4F, 0x0E, 0x77, 0x10, 0x7F, 0x90, 0x27, 0x70, 0xCF, 0x90,
  0x87, 0x60, 0x6F, 0xA0, 0xE0, 0x37, 0x28, 0x12, 0x5B, 0xFD, 0x81, 0xA4, 0x13, 0x04, 0xFF, 0xF8,
  0x1E, 0x04, 0xFF, 0xF8, 0x1E, 0x04, 0xFF, 0xF8, 0x1E, 0x04, 0xFF, 0xF0, 0xE0,
  // "Ĭ" (U+012C)
  0x10, 0x5B, 0x09, 0x76, 0x04, 0xB8, 0x19, 0x04, 0xB0, 0xD7, 0x60, 0x8B, 0x81, 0x80, 0x2C, 0x04,
  0x75, 0x0E, 0xB0, 0x62, 0x0E, 0xB0, 0xD7, 0x40, 0x9C, 0x02, 0x20, 0xAC, 0x0B, 0x01, 0x71, 0x09,
  0xC0, 0xE3, 0x04, 0xD8, 0x2E, 0x84, 0x12, 0x81, 0x37, 0xDD, 0x08, 0x40, 0xDF, 0xFC, 0x02, 0x40,
  0x4F, 0xFB, 0x08, 0x60, 0x8F, 0xF9, 0x0C, 0x71, 0x09, 0xFE, 0x0C, 0x01, 0x72, 0x05, 0x0D, 0xFB,
  0x08, 0x76, 0x89, 0x05, 0x9C, 0xEF, 0xED, 0xB6, 0x18, 0x09, 0xF2, 0x00, 0x3F, 0xFF, 0x90, 0xE0,
  0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE3, 0x81, 0x14, 0xAF, 0xD8,
  0x1E, 0x73, 0x72, 0x04, 0xFB, 0x0D, 0x01, 0x75, 0x09, 0xFA, 0x04, 0x76, 0x03, 0xF9, 0x0E, 0x77,
  0x1F, 0x90, 0xB7, 0x71, 0xF9, 0x0A, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x1F, 0x90, 0xA7, 0x71, 0xF9, 0x0B, 0x77, 0x03, 0xF9,
  0x0E, 0x77, 0x08, 0xFA, 0x04, 0x75, 0x04, 0xFB, 0x0C, 0x01, 0x71, 0x81, 0x14, 0xAF, 0xD8, 0x1E,
  0x73, 0x30, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF,
  0x90, 0xE0,
  // "ĭ" (U+012D)
  0x05, 0xB0, 0x97, 0x60, 0x4B, 0x81, 0x90, 0x4B, 0x0D, 0x76, 0x08, 0xB8, 0x18, 0x02, 0xC0, 0x47,
  0x50, 0xEB, 0x06, 0x20, 0xEB, 0x0D, 0x74, 0x09, 0xC0, 0x22, 0x0A, 0xC0, 0xB0, 0x17, 0x10, 0x9C,
  0x0E, 0x30, 0x4D, 0x82, 0xE8, 0x41, 0x28, 0x13, 0x7D, 0xD0, 0x84, 0x0D, 0xFF, 0xC0, 0x24, 0x04,
  0xFF, 0xB0, 0x86, 0x08, 0xFF, 0x90, 0xC7, 0x10, 0x9F, 0xE0, 0xC0, 0x17, 0x20, 0x50, 0xDF, 0xB0,
  0x87, 0x68, 0x90, 0x59, 0xCE, 0xFE, 0xDB, 0x61, 0x80, 0xAA, 0x50, 0x0B, 0xFE, 0x0C, 0x72, 0x0B,
  0xFE, 0x0C, 0x72, 0x0B, 0xFE, 0x0C, 0x72, 0x0B, 0xFE, 0x0C, 0x74, 0x81, 0x15, 0xBF, 0xA0, 0xC7,
  0x70, 0x6F, 0x90, 0xC7, 0x71, 0x0C, 0xF0, 0xC7, 0x71, 0x07, 0xF0, 0xC7, 0x71, 0x04, 0xF0, 0xC7,
  0x71, 0x03, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7,
  0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7,
  0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7,
  0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7,
  0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7,
  0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7,
  0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7, 0x71, 0x02, 0xF0, 0xC7,
  0x71, 0x02, 0xF0, 0xD7, 0x71, 0x03, 0xF0, 0xD7, 0x71, 0x04, 0xF0, 0xE7, 0x71, 0x07, 0xF9, 0x02,
  0x77, 0x0C, 0xF9, 0x08, 0x76, 0x06, 0xFA, 0x0E, 0x03, 0x72, 0x81, 0x25, 0xBF, 0xD8, 0x1A, 0x41,
  0x30, 0x4F, 0xFF, 0x81, 0xE0, 0x4F, 0xFF, 0x81, 0xE0, 0x4F, 0xFF, 0x81, 0xE0, 0x4F, 0xFF, 0x0E,
  // "Į" (U+012E)
  0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E,
  0x38, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37, 0x20, 0x4F, 0xB0, 0xD0, 0x17, 0x50, 0x9F, 0xA0, 0x47,
  0x60, 0x3F, 0x90, 0xE7, 0x71, 0xF9, 0x0B, 0x77, 0x1F, 0x90, 0xA7, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71,
  0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0xF9, 0x0A, 0x77, 0x1F,
  0x90, 0xB7, 0x70, 0x3F, 0x90, 0xE7, 0x70, 0x8F, 0xA0, 0x47, 0x50, 0x4F, 0xB0, 0xC0, 0x17, 0x18,
  0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x33, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x03, 0xFF,
  0xF9, 0x0E, 0x03, 0xFF, 0xF9, 0x0E, 0x75, 0x84, 0x16, 0x77, 0x76, 0x77, 0x20, 0x10, 0x9C, 0x08,
  0x77, 0x20, 0x40, 0xEB, 0x0E, 0x04, 0x77, 0x20, 0x6C, 0x0E, 0x03, 0x77, 0x20, 0x5D, 0x04, 0x77,
  0x20, 0x2D, 0x09, 0x77, 0x30, 0xCD, 0x01, 0x77, 0x20, 0x4D, 0x0B, 0x77, 0x30, 0xAD, 0x07, 0x77,
  0x30, 0xED, 0x04, 0x77, 0x20, 0x2E, 0x03, 0x77, 0x20, 0x3E, 0x03, 0x77, 0x20, 0x3E, 0x04, 0x77,
  0x20, 0x2E, 0x08, 0x77, 0x20, 0x1E, 0x0D, 0x77, 0x30, 0xDE, 0x09, 0x77, 0x20, 0x9F, 0x81, 0xC5,
  0x12, 0x82, 0x25, 0x83, 0x70, 0x2F, 0xF9, 0x05, 0x71, 0x07, 0xFF, 0x05, 0x72, 0x08, 0xFE, 0x05,
  0x73, 0x04, 0x0D, 0xFC, 0x04, 0x75, 0x89, 0x14, 0x8B, 0xDE, 0xFE, 0xC9, 0x51, 0x30,
  // "į" (U+012F)
  0x71, 0x85, 0x19, 0xDF, 0xD9, 0x17, 0x71, 0x02, 0x0E, 0xD0, 0xE0, 0x27, 0x70, 0xAF, 0x0B, 0x77,
  0x0E, 0xF9, 0x01, 0x75, 0x01, 0xFA, 0x03, 0x75, 0x02, 0xFA, 0x04, 0x75, 0x01, 0xFA, 0x03, 0x76,
  0x0E, 0xF9, 0x01, 0x76, 0x0A, 0xF0, 0xB7, 0x70, 0x20, 0xED, 0x0E, 0x02, 0x77, 0x18, 0x51, 0x9D,
  0xFD, 0x91, 0x80, 0xBA, 0x40, 0x0B, 0xFE, 0x0C, 0x71, 0x0B, 0xFE, 0x0C, 0x71, 0x0B, 0xFE, 0x0C,
  0x71, 0x0B, 0xFE, 0x0C, 0x73, 0x81, 0x15, 0xBF, 0xA0, 0xC7, 0x60, 0x6F, 0x90, 0xC7, 0x70, 0xCF,
  0x0C, 0x77, 0x07, 0xF0, 0xC7, 0x70, 0x4F, 0x0C, 0x77, 0x03, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77,
  0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0,
  0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70,
  0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C,
  0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02,
  0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7,
  0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xD7, 0x70, 0x3F,
  0x0D, 0x77, 0x04, 0xF0, 0xE7, 0x70, 0x7F, 0x90, 0x27, 0x60, 0xCF, 0x90, 0x87, 0x50, 0x6F, 0xA0,
  0xE0, 0x37, 0x18, 0x12, 0x5B, 0xFD, 0x81, 0xA4, 0x12, 0x04, 0xFF, 0xF0, 0xE0, 0x4F, 0xFF, 0x0E,
  0x04, 0xFF, 0xF0, 0xE0, 0x4F, 0xFF, 0x0E, 0x74, 0x84, 0x16, 0x77, 0x76, 0x77, 0x10, 0x10, 0x9C,
  0x08, 0x77, 0x10, 0x40, 0xEB, 0x0E, 0x04, 0x77, 0x10, 0x6C, 0x0E, 0x03, 0x77, 0x10, 0x5D, 0x04,
  0x77, 0x10, 0x2D, 0x09, 0x77, 0x20, 0xCD, 0x01, 0x77, 0x10, 0x4D, 0x0B, 0x77, 0x20, 0xAD, 0x07,
  0x77, 0x20, 0xED, 0x04, 0x77, 0x10, 0x2E, 0x03, 0x77, 0x10, 0x3E, 0x03, 0x77, 0x10, 0x3E, 0x04,
  0x77, 0x10, 0x2E, 0x08, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x20, 0xDE, 0x09, 0x77, 0x10, 0x9F, 0x81,
  0xC5, 0x12, 0x82, 0x25, 0x83, 0x60, 0x2F, 0xF9, 0x05, 0x70, 0x7F, 0xF0, 0x57, 0x10, 0x8F, 0xE0,
  0x57, 0x20, 0x40, 0xDF, 0xC0, 0x47, 0x48, 0x91, 0x48, 0xBD, 0xEF, 0xEC, 0x95, 0x13,
  // "İ" (U+0130)
  0x72, 0x84, 0x3A, 0xEF, 0xD8, 0x77, 0x30, 0x4E, 0x0D, 0x01, 0x77, 0x10, 0xDF, 0x09, 0x77, 0x03,
  0xF9, 0x0E, 0x77, 0x05, 0xFA, 0x01, 0x76, 0x06, 0xFA, 0x01, 0x76, 0x05, 0xFA, 0x01, 0x76, 0x03,
  0xF9, 0x0E, 0x77, 0x10, 0xDF, 0x09, 0x77, 0x10, 0x4E, 0x0D, 0x01, 0x77, 0x28, 0x43, 0xAE, 0xFD,
  0x88, 0x0B, 0x85, 0x00, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0,
  0x3F, 0xFF, 0x90, 0xE3, 0x81, 0x14, 0xAF, 0xD8, 0x1E, 0x73, 0x72, 0x04, 0xFB, 0x0D, 0x01, 0x75,
  0x09, 0xFA, 0x04, 0x76, 0x03, 0xF9, 0x0E, 0x77, 0x1F, 0x90, 0xB7, 0x71, 0xF9, 0x0A, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10,
  0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x10, 0xEF, 0x09, 0x77, 0x1F,
  0x90, 0xA7, 0x71, 0xF9, 0x0B, 0x77, 0x03, 0xF9, 0x0E, 0x77, 0x08, 0xFA, 0x04, 0x75, 0x04, 0xFB,
  0x0C, 0x01, 0x71, 0x81, 0x14, 0xAF, 0xD8, 0x1E, 0x73, 0x30, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF,
  0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0, 0x3F, 0xFF, 0x90, 0xE0,
  // "ı" (U+0131)
  0x10, 0xBF, 0xE0, 0xC7, 0x10, 0xBF, 0xE0, 0xC7, 0x10, 0xBF, 0xE0, 0xC7, 0x10, 0xBF, 0xE0, 0xC7,
  0x38, 0x11, 0x5B, 0xFA, 0x0C, 0x76, 0x06, 0xF9, 0x0C, 0x77, 0x0C, 0xF0, 0xC7, 0x70, 0x7F, 0x0C,
  0x77, 0x04, 0xF0, 0xC7, 0x70, 0x3F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02,
  0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7,
  0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F,
  0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77,
  0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0,
  0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70,
  0x2F, 0x0C, 0x77, 0x02, 0xF0, 0xC7, 0x70, 0x2F, 0x0D, 0x77, 0x03, 0xF0, 0xD7, 0x70, 0x4F, 0x0E,
  0x77, 0x07, 0xF9, 0x02, 0x76, 0x0C, 0xF9, 0x08, 0x75, 0x06, 0xFA, 0x0E, 0x03, 0x71, 0x81, 0x25,
  0xBF, 0xD8, 0x1A, 0x41, 0x20, 0x4F, 0xFF, 0x0E, 0x04, 0xFF, 0xF0, 0xE0, 0x4F, 0xFF, 0x0E, 0x04,
  0xFF, 0xF0, 0xE0,
  // "Ĳ" (U+0132)
  0x03, 0xFF, 0xF9, 0x0E, 0x50, 0xDF, 0xFF, 0x90, 0x20, 0x3F, 0xFF, 0x90, 0xE5, 0x0D, 0xFF, 0xF9,
  0x02, 0x03, 0xFF, 0xF9, 0x0E, 0x50, 0xDF, 0xFF, 0x90, 0x20, 0x3F, 0xFF, 0x90, 0xE5, 0x0D, 0xFF,
  0xF9, 0x02, 0x38, 0x11, 0x4A, 0xFD, 0x81, 0xE7, 0x37, 0x38, 0x21, 0x38, 0xEF, 0xD8, 0x1A, 0x41,
  0x72, 0x04, 0xFB, 0x0D, 0x01, 0x77, 0x10, 0x10, 0xDF, 0xB0, 0x47, 0x60, 0x9F, 0xA0, 0x47, 0x73,
  0x04, 0xFA, 0x08, 0x77, 0x03, 0xF9, 0x0E, 0x77, 0x50, 0xEF, 0x90, 0x37, 0x71, 0xF9, 0x0B, 0x77,
  0x50, 0xBF, 0x97, 0x72, 0xF9, 0x0A, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50,
  0xAF, 0x0E, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x2F, 0x90, 0xA7, 0x75, 0x0A,
  0xF0, 0xE7, 0x72, 0xF9, 0x0B, 0x77, 0x50, 0xAF, 0x0E, 0x77, 0x10, 0x3F, 0x90, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x71, 0x08, 0xFA, 0x04, 0x77, 0x40, 0xAF, 0x0E, 0x77, 0x04, 0xFB, 0x0C, 0x01, 0x77,
  0x30, 0xAF, 0x0E, 0x74, 0x81, 0x14, 0xAF, 0xD8, 0x1E, 0x73, 0x77, 0x10, 0xAF, 0x0E, 0x71, 0x03,
  0xFF, 0xF9, 0x0E, 0x75, 0x0A, 0xF0, 0xE7, 0x10, 0x3F, 0xFF, 0x90, 0xE7, 0x50, 0xAF, 0x0E, 0x71,
  0x03, 0xFF, 0xF9, 0x0E, 0x75, 0x0A, 0xF0, 0xE7, 0x10, 0x3F, 0xFF, 0x90, 0xE7, 0x50, 0xAF, 0x0E,
  0x80, 0xD0, 0x00, 0xAF, 0x0D, 0x80, 0xD0, 0x00, 0xAF, 0x0D, 0x80, 0xD0, 0x00, 0xBF, 0x0C, 0x80,
  0xD0, 0x00, 0xCF, 0x0C, 0x80, 0xD0, 0x00, 0xDF, 0x0B, 0x80, 0xD0, 0x00, 0xEF, 0x08, 0x80, 0xC7,
  0x00, 0x1F, 0x90, 0x68, 0x0C, 0x70, 0x04, 0xF9, 0x04, 0x80, 0xC7, 0x00, 0x8F, 0x98, 0x0D, 0x00,
  0x0C, 0xF0, 0xB8, 0x0C, 0x70, 0x02, 0xF9, 0x07, 0x80, 0xC7, 0x00, 0x9F, 0x0E, 0x01, 0x80, 0xC6,
  0x00, 0x3F, 0x90, 0x98, 0x0C, 0x60, 0x01, 0x0D, 0xF0, 0xE0, 0x18, 0x0C, 0x50, 0x02, 0x0C, 0xF9,
  0x05, 0x80, 0xC4, 0x08, 0x12, 0x8E, 0xF9, 0x09, 0x80, 0xC1, 0x08, 0x26, 0x9A, 0xDF, 0xB0, 0xA8,
  0x0C, 0x20, 0x0B, 0xFD, 0x08, 0x80, 0xC3, 0x00, 0xBF, 0xB0, 0xC0, 0x48, 0x0C, 0x40, 0x0B, 0xF9,
  0x0A, 0x05, 0x80, 0xC6, 0x00, 0xBA, 0x83, 0xED, 0xB8, 0x47, 0x76,
  // "ĳ" (U+0133)
  0x71, 0x85, 0x19, 0xDF, 0xD9, 0x17, 0x74, 0x85, 0x2A, 0xEF, 0xD8, 0x17, 0x20, 0x20, 0xED, 0x0E,
  0x02, 0x77, 0x20, 0x4E, 0x0D, 0x01, 0x71, 0x0A, 0xF0, 0xB7, 0x72, 0x0D, 0xF0, 0x97, 0x10, 0xEF,
  0x90, 0x17, 0x70, 0x3F, 0x90, 0xE7, 0x01, 0xFA, 0x03, 0x77, 0x05, 0xFA, 0x01, 0x60, 0x2F, 0xA0,
  0x47, 0x70, 0x6F, 0xA0, 0x26, 0x01, 0xFA, 0x03, 0x77, 0x05, 0xFA, 0x01, 0x70, 0xEF, 0x90, 0x17,
  0x70, 0x3F, 0x90, 0xE7, 0x10, 0xAF, 0x0B, 0x77, 0x20, 0xDF, 0x09, 0x71, 0x02, 0x0E, 0xD0, 0xE0,
  0x27, 0x72, 0x04, 0xE0, 0xD0, 0x17, 0x28, 0x51, 0x9D, 0xFD, 0x91, 0x77, 0x48, 0x53, 0xAE, 0xFD,
  0x81, 0x80, 0xDF, 0x10, 0x0B, 0xFE, 0x0C, 0x73, 0x0D, 0xFE, 0x0A, 0x20, 0xBF, 0xE0, 0xC7, 0x30,
  0xDF, 0xE0, 0xA2, 0x0B, 0xFE, 0x0C, 0x73, 0x0D, 0xFE, 0x0A, 0x20, 0xBF, 0xE0, 0xC7, 0x30, 0xDF,
  0xE0, 0xA4, 0x81, 0x15, 0xBF, 0xA0, 0xC7, 0x58, 0x12, 0x6C, 0xFA, 0x0A, 0x70, 0x6F, 0x90, 0xC7,
  0x71, 0x08, 0xF9, 0x0A, 0x71, 0x0C, 0xF0, 0xC7, 0x72, 0x0D, 0xF0, 0xA7, 0x10, 0x7F, 0x0C, 0x77,
  0x20, 0x8F, 0x0A, 0x71, 0x04, 0xF0, 0xC7, 0x72, 0x05, 0xF0, 0xA7, 0x10, 0x3F, 0x0C, 0x77, 0x20,
  0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F,
  0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A,
  0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71,
  0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02,
  0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0,
  0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7,
  0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72,
  0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04,
  0xF0, 0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0,
  0xA7, 0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7,
  0x10, 0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10,
  0x2F, 0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F,
  0x0C, 0x77, 0x20, 0x4F, 0x0A, 0x71, 0x02, 0xF0, 0xC7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x2F, 0x0D,
  0x77, 0x20, 0x4F, 0x0A, 0x71, 0x03, 0xF0, 0xD7, 0x72, 0x04, 0xF0, 0xA7, 0x10, 0x4F, 0x0E, 0x77,
  0x20, 0x4F, 0x0A, 0x71, 0x07, 0xF9, 0x02, 0x77, 0x10, 0x4F, 0x0A, 0x71, 0x0C, 0xF9, 0x08, 0x77,
  0x10, 0x4F, 0x0A, 0x70, 0x6F, 0xA0, 0xE0, 0x37, 0x70, 0x4F, 0x0A, 0x48, 0x12, 0x5B, 0xFD, 0x81,
  0xA4, 0x17, 0x40, 0x4F, 0x81, 0xA0, 0x4F, 0xFF, 0x0E, 0x72, 0x04, 0xF8, 0x1A, 0x04, 0xFF, 0xF0,
  0xE7, 0x20, 0x4F, 0x81, 0xA0, 0x4F, 0xFF, 0x0E, 0x72, 0x04, 0xF8, 0x1A, 0x04, 0xFF, 0xF0, 0xE7,
  0x20, 0x4F, 0x0A, 0x77, 0x77, 0x50, 0x4F, 0x0A, 0x77, 0x77, 0x50, 0x4F, 0x09, 0x77, 0x77, 0x50,
  0x4F, 0x09, 0x77, 0x77, 0x50, 0x5F, 0x08, 0x77, 0x77, 0x50, 0x6F, 0x07, 0x77, 0x77, 0x50, 0x7F,
  0x05, 0x77, 0x77, 0x50, 0x9F, 0x03, 0x77, 0x77, 0x50, 0xBF, 0x01, 0x77, 0x77, 0x50, 0xEE, 0x0E,
  0x77, 0x77, 0x50, 0x3F, 0x0A, 0x77, 0x77, 0x50, 0x7F, 0x06, 0x77, 0x77, 0x50, 0xDF, 0x01, 0x77,
  0x77, 0x40, 0x5F, 0x0B, 0x77, 0x77, 0x50, 0xDF, 0x04, 0x77, 0x77, 0x40, 0xBF, 0x0B, 0x77, 0x77,
  0x30, 0x50, 0xDF, 0x0E, 0x02, 0x77, 0x76, 0x82, 0x59, 0xBE, 0xFA, 0x05, 0x77, 0x77, 0x08, 0xFC,
  0x05, 0x77, 0x77, 0x10, 0x8F, 0xA0, 0xD0, 0x37, 0x77, 0x72, 0x08, 0xF0, 0xC0, 0x67, 0x77, 0x74,
  0x86, 0x8F, 0xEE, 0xCA, 0x62, 0x74,
  // "Ĵ" (U+0134)
  0x74, 0x05, 0x80, 0x37, 0x02, 0x77, 0x40, 0x10, 0xEF, 0x0B, 0x77, 0x40, 0x7F, 0xA0, 0x27, 0x72,
  0x01, 0x0E, 0xFA, 0x0A, 0x77, 0x20, 0x8F, 0xC0, 0x37, 0x70, 0x2F, 0xD0, 0xC7, 0x70, 0xBD, 0x0C,
  0x05, 0xE0, 0x57, 0x50, 0x5D, 0x82, 0xE2, 0x07, 0xD0, 0xE0, 0x17, 0x40, 0xDD, 0x05, 0x30, 0xAD,
  0x09, 0x73, 0x08, 0xD0, 0x65, 0x0B, 0xD0, 0x37, 0x10, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x71, 0x0C,
  0xC0, 0x87, 0x10, 0x10, 0xCC, 0x07, 0x60, 0x7C, 0x08, 0x73, 0x01, 0x0C, 0xC0, 0x24, 0x02, 0xC0,
  0x87, 0x50, 0x10, 0xCB, 0x0C, 0x40, 0x6B, 0x08, 0x77, 0x01, 0x0C, 0xB0, 0x18, 0x0A, 0x94, 0x00,
  0xDF, 0xFF, 0x90, 0x24, 0x0D, 0xFF, 0xF9, 0x02, 0x40, 0xDF, 0xFF, 0x90, 0x24, 0x0D, 0xFF, 0xF9,
  0x02, 0x68, 0x21, 0x38, 0xEF, 0xD8, 0x1A, 0x41, 0x75, 0x01, 0x0D, 0xFB, 0x04, 0x77, 0x20, 0x4F,
  0xA0, 0x87, 0x74, 0x0E, 0xF9, 0x03, 0x77, 0x40, 0xBF, 0x97, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A,
  0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xE7, 0x75, 0x0A, 0xF0, 0xD7, 0x75, 0x0A, 0xF0, 0xD7, 0x75, 0x0B,
  0xF0, 0xC7, 0x75, 0x0C, 0xF0, 0xC7, 0x75, 0x0D, 0xF0, 0xB7, 0x75, 0x0E, 0xF0, 0x87, 0x74, 0x01,
  0xF9, 0x06, 0x77, 0x40, 0x4F, 0x90, 0x47, 0x74, 0x08, 0xF9, 0x77, 0x50, 0xCF, 0x0B, 0x77, 0x40,
  0x2F, 0x90, 0x77, 0x74, 0x09, 0xF0, 0xE0, 0x17, 0x73, 0x03, 0xF9, 0x09, 0x77, 0x30, 0x10, 0xDF,
  0x0E, 0x01, 0x77, 0x20, 0x20, 0xCF, 0x90, 0x57, 0x71, 0x81, 0x28, 0xEF, 0x90, 0x97, 0x58, 0x26,
  0x9A, 0xDF, 0xB0, 0xA7, 0x60, 0xBF, 0xD0, 0x87, 0x70, 0xBF, 0xB0, 0xC0, 0x47, 0x71, 0x0B, 0xF9,
  0x0A, 0x05, 0x77, 0x30, 0xBA, 0x83, 0xED, 0xB8, 0x47, 0x76,
  // "ĵ" (U+0135)
  0x71, 0x05, 0x80, 0x37, 0x02, 0x77, 0x10, 0x10, 0xEF, 0x0B, 0x77, 0x10, 0x7F, 0xA0, 0x27, 0x60,
  0x10, 0xEF, 0xA0, 0xA7, 0x60, 0x8F, 0xC0, 0x37, 0x40, 0x2F, 0xD0, 0xC7, 0x40, 0xBD, 0x0C, 0x05,
  0xE0, 0x57, 0x20, 0x5D, 0x82, 0xE2, 0x07, 0xD0, 0xE0, 0x17, 0x10, 0xDD, 0x05, 0x30, 0xAD, 0x09,
  0x70, 0x8D, 0x06, 0x50, 0xBD, 0x03, 0x50, 0x3D, 0x08, 0x70, 0xCC, 0x0C, 0x50, 0xCC, 0x08, 0x71,
  0x01, 0x0C, 0xC0, 0x73, 0x07, 0xC0, 0x87, 0x30, 0x10, 0xCC, 0x81, 0x20, 0x2C, 0x08, 0x75, 0x01,
  0x0C, 0xB8, 0x1C, 0x06, 0xB0, 0x87, 0x70, 0x10, 0xCB, 0x01, 0x80, 0xAA, 0x60, 0x0D, 0xFE, 0x0A,
  0x73, 0x0D, 0xFE, 0x0A, 0x73, 0x0D, 0xFE, 0x0A, 0x73, 0x0D, 0xFE, 0x0A, 0x75, 0x81, 0x26, 0xCF,
  0xA0, 0xA7, 0x71, 0x08, 0xF9, 0x0A, 0x77, 0x20, 0xDF, 0x0A, 0x77, 0x20, 0x8F, 0x0A, 0x77, 0x20,
  0x5F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x0A, 0x77, 0x20,
  0x4F, 0x0A, 0x77, 0x20, 0x4F, 0x09, 0x77, 0x20, 0x4F, 0x09, 0x77, 0x20, 0x5F, 0x08, 0x77, 0x20,
  0x6F, 0x07, 0x77, 0x20, 0x7F, 0x05, 0x77, 0x20, 0x9F, 0x03, 0x77, 0x20, 0xBF, 0x01, 0x77, 0x20,
  0xEE, 0x0E, 0x77, 0x20, 0x3F, 0x0A, 0x77, 0x20, 0x7F, 0x06, 0x77, 0x20, 0xDF, 0x01, 0x77, 0x10,
  0x5F, 0x0B, 0x77, 0x20, 0xDF, 0x04, 0x77, 0x10, 0xBF, 0x0B, 0x77, 0x05, 0x0D, 0xF0, 0xE0, 0x27,
  0x38, 0x25, 0x9B, 0xEF, 0xA0, 0x57, 0x40, 0x8F, 0xC0, 0x57, 0x50, 0x8F, 0xA0, 0xD0, 0x37, 0x60,
  0x8F, 0x0C, 0x06, 0x77, 0x18, 0x68, 0xFE, 0xEC, 0xA6, 0x27, 0x72,
  // "Ķ" (U+0136)
  0x03, 0xFF, 0xF9, 0x08, 0x71, 0x05, 0xFF, 0xB0, 0x13, 0x03, 0xFF, 0xF9, 0x08, 0x71, 0x05, 0xFF,
  0xB0, 0x13, 0x03, 0xFF, 0xF9, 0x08, 0x71, 0x05, 0xFF, 0xB0, 0x13, 0x03, 0xFF, 0xF9, 0x08, 0x71,
  0x05, 0xFF, 0xB0, 0x16, 0x81, 0x14, 0x9F, 0xD8, 0x1E, 0x73, 0x75, 0x82, 0x12, 0x7E, 0xFB, 0x81,
  0x83, 0x17, 0x30, 0x30, 0xEF, 0xA0, 0xD0, 0x17, 0x73, 0x06, 0xF9, 0x0B, 0x01, 0x77, 0x08, 0xFA,
  0x04, 0x77, 0x40, 0x5F, 0x0A, 0x77, 0x20, 0x3F, 0x90, 0xE7, 0x75, 0x09, 0xE0, 0xA7, 0x74, 0xF9,
  0x0B, 0x77, 0x40, 0x10, 0xED, 0x0B, 0x77, 0x50, 0xEF, 0x0A, 0x77, 0x40, 0x9D, 0x0C, 0x77, 0x60,
  0xEF, 0x09, 0x77, 0x30, 0x3D, 0x0E, 0x01, 0x77, 0x60, 0xEF, 0x09, 0x77, 0x30, 0xCD, 0x04, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x20, 0x7D, 0x07, 0x77, 0x71, 0x0E, 0xF0, 0x97, 0x71, 0x03, 0xD0, 0xB7,
  0x77, 0x20, 0xEF, 0x09, 0x77, 0x10, 0xDC, 0x0D, 0x01, 0x77, 0x72, 0x0E, 0xF0, 0x97, 0x70, 0x9D,
  0x03, 0x77, 0x73, 0x0E, 0xF0, 0x97, 0x60, 0x5D, 0x07, 0x77, 0x74, 0x0E, 0xF0, 0x97, 0x50, 0x10,
  0xEC, 0x0A, 0x77, 0x75, 0x0E, 0xF0, 0x97, 0x50, 0xBC, 0x0D, 0x01, 0x77, 0x75, 0x0E, 0xF0, 0x97,
  0x40, 0x7D, 0x03, 0x77, 0x76, 0x0E, 0xF0, 0x97, 0x30, 0x3D, 0x06, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x30, 0xDC, 0x0A, 0x77, 0x77, 0x10, 0xEF, 0x09, 0x72, 0x09, 0xC0, 0xD7, 0x77, 0x72, 0x0E, 0xF0,
  0x97, 0x10, 0x5C, 0x0E, 0x02, 0x77, 0x77, 0x20, 0xEF, 0x09, 0x70, 0x10, 0xEC, 0x06, 0x77, 0x77,
  0x30, 0xEF, 0x09, 0x70, 0xBC, 0x09, 0x77, 0x77, 0x40, 0xEF, 0x09, 0x60, 0x7C, 0x0C, 0x77, 0x77,
  0x50, 0xEF, 0x09, 0x50, 0x2D, 0x0C, 0x77, 0x77, 0x50, 0xEF, 0x09, 0x50, 0xDE, 0x07, 0x77, 0x77,
  0x40, 0xEF, 0x09, 0x40, 0x9F, 0x90, 0x27, 0x77, 0x73, 0x0E, 0xF0, 0x93, 0x04, 0xFA, 0x0B, 0x77,
  0x77, 0x30, 0xEF, 0x09, 0x20, 0x10, 0xEF, 0xB0, 0x67, 0x77, 0x72, 0x0E, 0xF0, 0x92, 0x0B, 0xFC,
  0x0E, 0x01, 0x77, 0x77, 0x10, 0xEF, 0x81, 0x90, 0x6B, 0x0C, 0x0E, 0xF9, 0x0A, 0x77, 0x77, 0x10,
  0xEF, 0x09, 0x02, 0xB8, 0x1E, 0x16, 0xFA, 0x04, 0x77, 0x77, 0x0E, 0xF0, 0xA0, 0xCB, 0x03, 0x20,
  0xCF, 0x90, 0xD7, 0x77, 0x70, 0xEF, 0xC0, 0x63, 0x03, 0xFA, 0x09, 0x77, 0x76, 0x0E, 0xFB, 0x09,
  0x50, 0x9F, 0xA0, 0x37, 0x77, 0x50, 0xEF, 0xA0, 0xC6, 0x01, 0x0E, 0xF9, 0x0C, 0x77, 0x75, 0x0E,
  0xF9, 0x0D, 0x01, 0x70, 0x6F, 0xA0, 0x77, 0x77, 0x40, 0xEF, 0x90, 0x37, 0x20, 0xCF, 0xA0, 0x27,
  0x77, 0x30, 0xEF, 0x09, 0x73, 0x03, 0xFA, 0x0B, 0x77, 0x73, 0x0E, 0xF0, 0x97, 0x40, 0x9F, 0xA0,
  0x67, 0x77, 0x20, 0xEF, 0x09, 0x74, 0x01, 0x0E, 0xF9, 0x0E, 0x01, 0x77, 0x71, 0x0E, 0xF0, 0x97,
  0x50, 0x6F, 0xA0, 0xA7, 0x77, 0x10, 0xEF, 0x09, 0x76, 0x0C, 0xFA, 0x04, 0x77, 0x70, 0xEF, 0x09,
  0x76, 0x03, 0xFA, 0x0D, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x0A, 0xFA, 0x09, 0x77, 0x60, 0xEF, 0x09,
  0x77, 0x01, 0x0E, 0xFA, 0x03, 0x77, 0x50, 0xEF, 0x09, 0x77, 0x10, 0x7F, 0xA0, 0xC7, 0x75, 0x0E,
  0xF0, 0x97, 0x72, 0x0D, 0xFA, 0x07, 0x77, 0x40, 0xEF, 0x09, 0x77, 0x20, 0x4F, 0xB0, 0x27, 0x73,
  0x0E, 0xF0, 0x97, 0x73, 0x0A, 0xFA, 0x0B, 0x77, 0x30, 0xEF, 0x09, 0x77, 0x30, 0x10, 0xEF, 0xA0,
  0x67, 0x72, 0x0E, 0xF0, 0xA7, 0x74, 0x07, 0xFA, 0x0E, 0x02, 0x77, 0x1F, 0x90, 0xB7, 0x75, 0x0D,
  0xFA, 0x0C, 0x77, 0x03, 0xF9, 0x0E, 0x77, 0x50, 0x4F, 0xB0, 0xA7, 0x60, 0x8F, 0xA0, 0x47, 0x75,
  0x0A, 0xFB, 0x08, 0x74, 0x03, 0x0E, 0xFA, 0x0D, 0x01, 0x77, 0x40, 0x10, 0xDF, 0xB0, 0x97, 0x81,
  0x14, 0x9F, 0xD8, 0x2E, 0x83, 0x17, 0x72, 0x03, 0xFC, 0x83, 0xD5, 0x10, 0x3F, 0xFF, 0x90, 0x87,
  0x71, 0x06, 0xFE, 0x09, 0x03, 0xFF, 0xF9, 0x08, 0x77, 0x20, 0x50, 0xEF, 0xC0, 0x90, 0x3F, 0xFF,
  0x90, 0x87, 0x73, 0x02, 0x0A, 0xFB, 0x09, 0x03, 0xFF, 0xF9, 0x08, 0x77, 0x58, 0x51, 0x58, 0xBD,
  0xEE, 0xB0, 0x98, 0x0D, 0xB0, 0x00, 0x9E, 0x0D, 0x80, 0xD2, 0x00, 0xBE, 0x09, 0x80, 0xD2, 0x00,
  0xDE, 0x03, 0x80, 0xD2, 0x0E, 0x0C, 0x80, 0xD2, 0x00, 0x3E, 0x05, 0x80, 0xD2, 0x00, 0x6D, 0x0D,
  0x80, 0xD3, 0x00, 0x9D, 0x05, 0x80, 0xD3, 0x00, 0xCC, 0x0D, 0x80, 0xD4, 0x0D, 0x05, 0x80, 0xD3,
  0x00, 0x3C, 0x0D, 0x80, 0xD4, 0x00, 0x6C, 0x05, 0x80, 0xD4, 0x00, 0xAB, 0x0C, 0x80, 0xD5, 0x00,
  0xDB, 0x03, 0x80, 0xD5, 0x00, 0xEA, 0x09, 0x77, 0x77,
  // "ķ" (U+0137)
  0x0A, 0xFF, 0x03, 0x77, 0x77, 0x10, 0xAF, 0xF0, 0x37, 0x77, 0x71, 0x0A, 0xFF, 0x03, 0x77, 0x77,
  0x10, 0xAF, 0xF0, 0x37, 0x77, 0x73, 0x81, 0x15, 0xAF, 0xB0, 0x37, 0x77, 0x76, 0x04, 0x0E, 0xF9,
  0x03, 0x77, 0x77, 0x70, 0x7F, 0x90, 0x37, 0x77, 0x77, 0x01, 0xF9, 0x03, 0x80, 0xC0, 0x00, 0xEF,
  0x03, 0x80, 0xC0, 0x00, 0xDF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03,
  0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80,
  0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0,
  0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x80, 0xC0, 0x00, 0xCF, 0x03, 0x71, 0x02, 0xFF,
  0xA0, 0xE7, 0x30, 0xCF, 0x03, 0x71, 0x02, 0xFF, 0xA0, 0xE7, 0x30, 0xCF, 0x03, 0x71, 0x02, 0xFF,
  0xA0, 0xE7, 0x30, 0xCF, 0x03, 0x71, 0x02, 0xFF, 0xA0, 0xE7, 0x30, 0xCF, 0x03, 0x73, 0x02, 0x07,
  0xFB, 0x81, 0xE7, 0x27, 0x40, 0xCF, 0x03, 0x75, 0x08, 0xF9, 0x09, 0x77, 0x0C, 0xF0, 0x37, 0x50,
  0x7F, 0x06, 0x77, 0x10, 0xCF, 0x03, 0x75, 0x0A, 0xE0, 0x57, 0x72, 0x0C, 0xF0, 0x37, 0x40, 0x1E,
  0x06, 0x77, 0x30, 0xCF, 0x03, 0x74, 0x07, 0xD0, 0x77, 0x74, 0x0C, 0xF0, 0x37, 0x30, 0x10, 0xEC,
  0x0A, 0x77, 0x50, 0xCF, 0x03, 0x73, 0x0B, 0xC0, 0xC7, 0x76, 0x0C, 0xF0, 0x37, 0x20, 0x7C, 0x0E,
  0x02, 0x77, 0x60, 0xCF, 0x03, 0x71, 0x03, 0xD0, 0x57, 0x77, 0x0C, 0xF0, 0x37, 0x01, 0x0E, 0xC0,
  0x97, 0x77, 0x10, 0xCF, 0x03, 0x70, 0xBC, 0x0C, 0x77, 0x72, 0x0C, 0xF0, 0x26, 0x08, 0xC0, 0xE0,
  0x27, 0x77, 0x20, 0xCF, 0x02, 0x50, 0x4D, 0x05, 0x77, 0x73, 0x0C, 0xF0, 0x24, 0x02, 0x0E, 0xC0,
  0x97, 0x77, 0x40, 0xCF, 0x01, 0x40, 0xCD, 0x04, 0x77, 0x74, 0x0C, 0xF0, 0x13, 0x09, 0xE0, 0xC7,
  0x77, 0x40, 0xCF, 0x01, 0x20, 0x5F, 0x90, 0x67, 0x77, 0x30, 0xCF, 0x20, 0x2F, 0xA0, 0xE0, 0x17,
  0x77, 0x20, 0xCF, 0x20, 0xDF, 0xB0, 0x87, 0x77, 0x20, 0xCE, 0x81, 0xE0, 0xAF, 0xD0, 0x27, 0x77,
  0x10, 0xCE, 0x0D, 0x07, 0xB0, 0xC0, 0x3F, 0x90, 0xB7, 0x77, 0x10, 0xCE, 0x0E, 0xB8, 0x2D, 0x10,
  0x9F, 0x90, 0x47, 0x77, 0x0C, 0xFA, 0x0E, 0x02, 0x20, 0x10, 0xEF, 0x0D, 0x77, 0x70, 0xCF, 0x90,
  0xE0, 0x34, 0x08, 0xF9, 0x06, 0x77, 0x60, 0xCF, 0x90, 0x45, 0x01, 0x0E, 0xF0, 0xE0, 0x17, 0x75,
  0x0C, 0xF0, 0x67, 0x07, 0xF9, 0x09, 0x77, 0x50, 0xCF, 0x03, 0x71, 0x0D, 0xF9, 0x02, 0x77, 0x40,
  0xCF, 0x03, 0x71, 0x06, 0xF9, 0x0B, 0x77, 0x40, 0xCF, 0x03, 0x72, 0x0D, 0xF9, 0x05, 0x77, 0x30,
  0xCF, 0x03, 0x72, 0x05, 0xF9, 0x0D, 0x77, 0x30, 0xCF, 0x03, 0x73, 0x0C, 0xF9, 0x07, 0x77, 0x20,
  0xCF, 0x03, 0x73, 0x04, 0xF9, 0x0E, 0x01, 0x77, 0x10, 0xCF, 0x03, 0x74, 0x0B, 0xF9, 0x0A, 0x77,
  0x10, 0xDF, 0x03, 0x74, 0x03, 0xFA, 0x04, 0x77, 0x0E, 0xF0, 0x47, 0x50, 0xAF, 0x90, 0xE0, 0x17,
  0x50, 0x2F, 0x90, 0x77, 0x50, 0x2F, 0xA0, 0xB7, 0x50, 0x8F, 0x90, 0xC7, 0x60, 0x8F, 0xA0, 0x87,
  0x30, 0x40, 0xEF, 0xA0, 0x77, 0x60, 0xDF, 0xA0, 0x86, 0x81, 0x15, 0xAF, 0xD8, 0x2D, 0x73, 0x17,
  0x20, 0x3F, 0xB8, 0x3C, 0x51, 0x0A, 0xFF, 0xE0, 0xA7, 0x20, 0x5F, 0xD0, 0xB0, 0xAF, 0xFE, 0x0A,
  0x73, 0x06, 0xFC, 0x0B, 0x0A, 0xFF, 0xE0, 0xA7, 0x40, 0x30, 0xCF, 0xA0, 0xB0, 0xAF, 0xFE, 0x0A,
  0x76, 0x84, 0x37, 0xAC, 0xDE, 0xB0, 0xB8, 0x0C, 0xB6, 0x00, 0x9E, 0x0D, 0x80, 0xC1, 0x00, 0xBE,
  0x09, 0x80, 0xC1, 0x00, 0xDE, 0x03, 0x80, 0xC1, 0x0E, 0x0C, 0x80, 0xC1, 0x00, 0x3E, 0x05, 0x80,
  0xC1, 0x00, 0x6D, 0x0D, 0x80, 0xC2, 0x00, 0x9D, 0x05, 0x80, 0xC2, 0x00, 0xCC, 0x0D, 0x80, 0xC3,
  0x0D, 0x05, 0x80, 0xC2, 0x00, 0x3C, 0x0D, 0x80, 0xC3, 0x00, 0x6C, 0x05, 0x80, 0xC3, 0x00, 0xAB,
  0x0C, 0x80, 0xC4, 0x00, 0xDB, 0x03, 0x80, 0xC4, 0x00, 0xEA, 0x09, 0x77, 0x72,
  // "ĸ" (U+0138)
  0x0A, 0xFF, 0x03, 0x71, 0x02, 0xFF, 0xA0, 0xE3, 0x0A, 0xFF, 0x03, 0x71, 0x02, 0xFF, 0xA0, 0xE3,
  0x0A, 0xFF, 0x03, 0x71, 0x02, 0xFF, 0xA0, 0xE3, 0x0A, 0xFF, 0x03, 0x71, 0x02, 0xFF, 0xA0, 0xE5,
  0x81, 0x15, 0xAF, 0xB0, 0x37, 0x30, 0x20, 0x7F, 0xB8, 0x1E, 0x72, 0x72, 0x04, 0x0E, 0xF9, 0x03,
  0x75, 0x08, 0xF9, 0x09, 0x76, 0x07, 0xF9, 0x03, 0x75, 0x07, 0xF0, 0x67, 0x70, 0x1F, 0x90, 0x37,
  0x50, 0xAE, 0x05, 0x77, 0x20, 0xEF, 0x03, 0x74, 0x01, 0xE0, 0x67, 0x73, 0x0D, 0xF0, 0x37, 0x40,
  0x7D, 0x07, 0x77, 0x40, 0xCF, 0x03, 0x73, 0x01, 0x0E, 0xC0, 0xA7, 0x75, 0x0C, 0xF0, 0x37, 0x30,
  0xBC, 0x0C, 0x77, 0x60, 0xCF, 0x03, 0x72, 0x07, 0xC0, 0xE0, 0x27, 0x76, 0x0C, 0xF0, 0x37, 0x10,
  0x3D, 0x05, 0x77, 0x70, 0xCF, 0x03, 0x70, 0x10, 0xEC, 0x08, 0x77, 0x71, 0x0C, 0xF0, 0x37, 0x0B,
  0xC0, 0xC7, 0x77, 0x20, 0xCF, 0x02, 0x60, 0x8C, 0x0E, 0x01, 0x77, 0x72, 0x0C, 0xF0, 0x25, 0x04,
  0xD0, 0x47, 0x77, 0x30, 0xCF, 0x02, 0x40, 0x20, 0xEC, 0x07, 0x77, 0x74, 0x0C, 0xF0, 0x14, 0x0C,
  0xC0, 0xE7, 0x77, 0x50, 0xCF, 0x01, 0x30, 0x9E, 0x07, 0x77, 0x74, 0x0C, 0xF0, 0x12, 0x05, 0xF0,
  0xE0, 0x17, 0x77, 0x30, 0xCF, 0x20, 0x2F, 0xA0, 0x97, 0x77, 0x30, 0xCF, 0x20, 0xDF, 0xB0, 0x37,
  0x77, 0x20, 0xCE, 0x81, 0xE0, 0xAF, 0xC0, 0xC7, 0x77, 0x20, 0xCE, 0x0D, 0x07, 0xB0, 0xC0, 0x8F,
  0x90, 0x67, 0x77, 0x10, 0xCE, 0x0E, 0xB8, 0x2D, 0x10, 0xEF, 0x0E, 0x01, 0x77, 0x70, 0xCF, 0xA0,
  0xE0, 0x22, 0x06, 0xF9, 0x09, 0x77, 0x70, 0xCF, 0x90, 0xE0, 0x34, 0x0D, 0xF9, 0x03, 0x77, 0x60,
  0xCF, 0x90, 0x45, 0x05, 0xF9, 0x0B, 0x77, 0x60, 0xCF, 0x06, 0x70, 0xCF, 0x90, 0x57, 0x75, 0x0C,
  0xF0, 0x37, 0x04, 0xF9, 0x0E, 0x77, 0x50, 0xCF, 0x03, 0x71, 0x0B, 0xF9, 0x08, 0x77, 0x40, 0xCF,
  0x03, 0x71, 0x02, 0xFA, 0x02, 0x77, 0x30, 0xCF, 0x03, 0x72, 0x09, 0xF9, 0x0B, 0x77, 0x30, 0xCF,
  0x03, 0x72, 0x01, 0xFA, 0x04, 0x77, 0x20, 0xCF, 0x03, 0x73, 0x08, 0xF9, 0x0D, 0x77, 0x20, 0xCF,
  0x03, 0x73, 0x01, 0x0E, 0xF9, 0x07, 0x77, 0x10, 0xDF, 0x03, 0x74, 0x07, 0xFA, 0x02, 0x77, 0x0E,
  0xF0, 0x47, 0x50, 0xDF, 0x90, 0xC7, 0x60, 0x2F, 0x90, 0x77, 0x50, 0x5F, 0xA0, 0x87, 0x50, 0x7F,
  0x90, 0xC7, 0x60, 0xBF, 0xA0, 0x67, 0x30, 0x40, 0xEF, 0xA0, 0x77, 0x50, 0x2F, 0xB0, 0x76, 0x81,
  0x15, 0xAF, 0xD8, 0x2D, 0x73, 0x17, 0x20, 0x6F, 0xB8, 0x3C, 0x51, 0x0A, 0xFF, 0xE0, 0xA7, 0x20,
  0xAF, 0xD0, 0xB0, 0xAF, 0xFE, 0x0A, 0x73, 0x0A, 0xFC, 0x0B, 0x0A, 0xFF, 0xE0, 0xA7, 0x40, 0x50,
  0xDF, 0xA0, 0xB0, 0xAF, 0xFE, 0x0A, 0x76, 0x84, 0x37, 0xAC, 0xDE, 0xB0, 0xB0,
  // "Ĺ" (U+0139)
  0x77, 0x20, 0x38, 0x04, 0x70, 0x47, 0x77, 0x76, 0x0B, 0xF9, 0x08, 0x77, 0x77, 0x50, 0x2F, 0x90,
  0xD0, 0x17, 0x77, 0x75, 0x09, 0xF9, 0x03, 0x77, 0x77, 0x50, 0x1F, 0x90, 0x57, 0x77, 0x76, 0x09,
  0xF0, 0x87, 0x77, 0x76, 0x02, 0xF0, 0xA7, 0x77, 0x77, 0x0A, 0xE0, 0xB7, 0x77, 0x77, 0x04, 0xE0,
  0xB8, 0x0C, 0x00, 0x0C, 0xD0, 0xC8, 0x0C, 0x00, 0x06, 0xD0, 0xC8, 0x0C, 0x00, 0x01, 0x0E, 0xC0,
  0xB8, 0x0C, 0x10, 0x09, 0xC0, 0xA8, 0x0C, 0x10, 0x03, 0xC0, 0x98, 0x0C, 0x20, 0x06, 0xB0, 0x68,
  0x0B, 0xE6, 0x00, 0x3F, 0xFF, 0x90, 0xE7, 0x76, 0x03, 0xFF, 0xF9, 0x0E, 0x77, 0x60, 0x3F, 0xFF,
  0x90, 0xE7, 0x76, 0x03, 0xFF, 0xF9, 0x0E, 0x77, 0x72, 0x81, 0x15, 0xAF, 0xD8, 0x1D, 0x73, 0x77,
  0x77, 0x10, 0x5F, 0xB0, 0xC7, 0x77, 0x75, 0x09, 0xFA, 0x03, 0x77, 0x77, 0x50, 0x3F, 0x90, 0xD7,
  0x77, 0x77, 0xF9, 0x0B, 0x77, 0x77, 0x7F, 0x90, 0xA7, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x20, 0xF4, 0x72, 0x0E, 0xF0, 0x97,
  0x77, 0x10, 0xCB, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0xEB, 0x02, 0x71, 0x0E, 0xF0, 0x97,
  0x77, 0x1C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x02, 0xC0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70,
  0x4C, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x70, 0x8C, 0x72, 0x0E,
  0xF0, 0x97, 0x77, 0x0A, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x70, 0xEB, 0x0E, 0x72, 0x0E, 0xF0, 0x97,
  0x76, 0x03, 0xC0, 0xE7, 0x2F, 0x90, 0x97, 0x76, 0x09, 0xC0, 0xD7, 0x10, 0x3F, 0x90, 0x97, 0x75,
  0x02, 0xD0, 0xD7, 0x10, 0x8F, 0x90, 0x97, 0x75, 0x0C, 0xD0, 0xC7, 0x03, 0x0E, 0xF9, 0x09, 0x77,
  0x30, 0x30, 0xCE, 0x0C, 0x58, 0x12, 0x8E, 0xFA, 0x0D, 0x80, 0x93, 0x90, 0xA0, 0xDF, 0x98, 0x4B,
  0x02, 0xDD, 0xE8, 0x0C, 0x2F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81,
  0xA0, 0x38, 0x0C, 0x5F, 0x0A, 0x10,
  // "ĺ" (U+013A)
  0x76, 0x03, 0x80, 0x47, 0x04, 0x76, 0x0B, 0xF9, 0x08, 0x75, 0x02, 0xF9, 0x0D, 0x01, 0x75, 0x09,
  0xF9, 0x03, 0x75, 0x01, 0xF9, 0x05, 0x76, 0x09, 0xF0, 0x87, 0x60, 0x2F, 0x0A, 0x77, 0x0A, 0xE0,
  0xB7, 0x70, 0x4E, 0x0B, 0x77, 0x10, 0xCD, 0x0C, 0x77, 0x10, 0x6D, 0x0C, 0x77, 0x10, 0x10, 0xEC,
  0x0B, 0x77, 0x20, 0x9C, 0x0A, 0x77, 0x20, 0x3C, 0x09, 0x77, 0x30, 0x6B, 0x06, 0x80, 0x99, 0x50,
  0x0E, 0xFF, 0x03, 0x70, 0xEF, 0xF0, 0x37, 0x0E, 0xFF, 0x03, 0x70, 0xEF, 0xF0, 0x37, 0x28, 0x11,
  0x5A, 0xFB, 0x03, 0x75, 0x04, 0x0E, 0xF9, 0x03, 0x76, 0x07, 0xF9, 0x03, 0x76, 0x01, 0xF9, 0x03,
  0x77, 0x0E, 0xF0, 0x37, 0x70, 0xDF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C,
  0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37,
  0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF,
  0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77,
  0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0,
  0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70,
  0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03,
  0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C,
  0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37,
  0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF,
  0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77,
  0x0D, 0xF0, 0x47, 0x70, 0xEF, 0x05, 0x76, 0x02, 0xF9, 0x08, 0x76, 0x07, 0xF9, 0x0D, 0x75, 0x03,
  0x0E, 0xFA, 0x08, 0x71, 0x81, 0x14, 0x9F, 0xD8, 0x1C, 0x62, 0x30, 0xEF, 0xFF, 0x04, 0x0E, 0xFF,
  0xF0, 0x40, 0xEF, 0xFF, 0x04, 0x0E, 0xFF, 0xF0, 0x40,
  // "Ļ" (U+013B)
  0x03, 0xFF, 0xF9, 0x0E, 0x77, 0x60, 0x3F, 0xFF, 0x90, 0xE7, 0x76, 0x03, 0xFF, 0xF9, 0x0E, 0x77,
  0x60, 0x3F, 0xFF, 0x90, 0xE7, 0x77, 0x28, 0x11, 0x5A, 0xFD, 0x81, 0xD7, 0x37, 0x77, 0x71, 0x05,
  0xFB, 0x0C, 0x77, 0x77, 0x50, 0x9F, 0xA0, 0x37, 0x77, 0x75, 0x03, 0xF9, 0x0D, 0x77, 0x77, 0x7F,
  0x90, 0xB7, 0x77, 0x77, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x71, 0x02, 0x0F, 0x47, 0x20, 0xEF, 0x09, 0x77, 0x71, 0x0C,
  0xB0, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x71, 0x0E, 0xB0, 0x27, 0x10, 0xEF, 0x09, 0x77, 0x71, 0xC0,
  0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x2C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x04, 0xC7, 0x20,
  0xEF, 0x09, 0x77, 0x70, 0x6C, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x08, 0xC7, 0x20, 0xEF, 0x09, 0x77,
  0x70, 0xAC, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x0E, 0xB0, 0xE7, 0x20, 0xEF, 0x09, 0x77, 0x60, 0x3C,
  0x0E, 0x72, 0xF9, 0x09, 0x77, 0x60, 0x9C, 0x0D, 0x71, 0x03, 0xF9, 0x09, 0x77, 0x50, 0x2D, 0x0D,
  0x71, 0x08, 0xF9, 0x09, 0x77, 0x50, 0xCD, 0x0C, 0x70, 0x30, 0xEF, 0x90, 0x97, 0x73, 0x03, 0x0C,
  0xE0, 0xC5, 0x81, 0x28, 0xEF, 0xA0, 0xD8, 0x09, 0x39, 0x0A, 0x0D, 0xF9, 0x84, 0xB0, 0x2D, 0xDE,
  0x80, 0xC2, 0xF8, 0x1B, 0x03, 0x80, 0xC5, 0xF8, 0x1B, 0x03, 0x80, 0xC5, 0xF8, 0x1A, 0x03, 0x80,
  0xC5, 0xF0, 0xA8, 0x0C, 0xB1, 0x00, 0x9E, 0x0D, 0x80, 0xC0, 0x00, 0xBE, 0x09, 0x80, 0xC0, 0x00,
  0xDE, 0x03, 0x80, 0xC0, 0x0E, 0x0C, 0x80, 0xC0, 0x00, 0x3E, 0x05, 0x80, 0xC0, 0x00, 0x6D, 0x0D,
  0x80, 0xC1, 0x00, 0x9D, 0x05, 0x80, 0xC1, 0x00, 0xCC, 0x0D, 0x80, 0xC2, 0x0D, 0x05, 0x80, 0xC1,
  0x00, 0x3C, 0x0D, 0x80, 0xC2, 0x00, 0x6C, 0x05, 0x80, 0xC2, 0x00, 0xAB, 0x0C, 0x80, 0xC3, 0x00,
  0xDB, 0x03, 0x80, 0xC3, 0x00, 0xEA, 0x09, 0x77, 0x71,
  // "ļ" (U+013C)
  0x0E, 0xFF, 0x03, 0x70, 0xEF, 0xF0, 0x37, 0x0E, 0xFF, 0x03, 0x70, 0xEF, 0xF0, 0x37, 0x28, 0x11,
  0x5A, 0xFB, 0x03, 0x75, 0x04, 0x0E, 0xF9, 0x03, 0x76, 0x07, 0xF9, 0x03, 0x76, 0x01, 0xF9, 0x03,
  0x77, 0x0E, 0xF0, 0x37, 0x70, 0xDF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C,
  0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37,
  0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF,
  0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77,
  0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0,
  0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70,
  0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03,
  0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C,
  0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37,
  0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF,
  0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77, 0x0C, 0xF0, 0x37, 0x70, 0xCF, 0x03, 0x77,
  0x0D, 0xF0, 0x47, 0x70, 0xEF, 0x05, 0x76, 0x02, 0xF9, 0x08, 0x76, 0x07, 0xF9, 0x0D, 0x75, 0x03,
  0x0E, 0xFA, 0x08, 0x71, 0x81, 0x14, 0x9F, 0xD8, 0x1C, 0x62, 0x30, 0xEF, 0xFF, 0x04, 0x0E, 0xFF,
  0xF0, 0x40, 0xEF, 0xFF, 0x04, 0x0E, 0xFF, 0xF0, 0x48, 0x0A, 0x95, 0x00, 0x9E, 0x0D, 0x77, 0x10,
  0xBE, 0x09, 0x77, 0x10, 0xDE, 0x03, 0x77, 0x1E, 0x0C, 0x77, 0x10, 0x3E, 0x05, 0x77, 0x10, 0x6D,
  0x0D, 0x77, 0x20, 0x9D, 0x05, 0x77, 0x20, 0xCC, 0x0D, 0x77, 0x3D, 0x05, 0x77, 0x20, 0x3C, 0x0D,
  0x77, 0x30, 0x6C, 0x05, 0x77, 0x30, 0xAB, 0x0C, 0x77, 0x40, 0xDB, 0x03, 0x77, 0x40, 0xEA, 0x09,
  0x77,
  // "Ľ" (U+013D)
  0x03, 0xFF, 0xF9, 0x0E, 0x72, 0x0C, 0xE0, 0x43, 0x03, 0xFF, 0xF9, 0x0E, 0x72, 0xF0, 0x13, 0x03,
  0xFF, 0xF9, 0x0E, 0x71, 0x02, 0xE0, 0xA4, 0x03, 0xFF, 0xF9, 0x0E, 0x71, 0x05, 0xE0, 0x37, 0x81,
  0x15, 0xAF, 0xD8, 0x1D, 0x73, 0x74, 0x08, 0xD0, 0xB7, 0x40, 0x5F, 0xB0, 0xC7, 0x70, 0xAD, 0x04,
  0x75, 0x09, 0xFA, 0x03, 0x77, 0x0D, 0xC0, 0xB7, 0x60, 0x3F, 0x90, 0xD7, 0x70, 0x1D, 0x03, 0x77,
  0xF9, 0x0B, 0x77, 0x04, 0xC0, 0xB7, 0x71, 0xF9, 0x0A, 0x77, 0x07, 0xC0, 0x37, 0x71, 0x0E, 0xF0,
  0x97, 0x70, 0xAB, 0x0A, 0x77, 0x20, 0xEF, 0x09, 0x77, 0x0E, 0xB0, 0x27, 0x72, 0x0E, 0xF0, 0x97,
  0x60, 0x2B, 0x09, 0x77, 0x30, 0xEF, 0x09, 0x76, 0x03, 0xA0, 0xE0, 0x17, 0x73, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97,
  0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77,
  0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x18, 0x34, 0x66, 0x61, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x10, 0xCB, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0xEB, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77,
  0x1C, 0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x02, 0xC0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x4C,
  0x72, 0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x70, 0x8C, 0x72, 0x0E, 0xF0,
  0x97, 0x77, 0x0B, 0xB0, 0xE7, 0x20, 0xEF, 0x09, 0x77, 0x70, 0xEB, 0x0E, 0x72, 0x0E, 0xF0, 0x97,
  0x76, 0x03, 0xC0, 0xE7, 0x2F, 0x90, 0x97, 0x76, 0x0A, 0xC0, 0xD7, 0x10, 0x3F, 0x90, 0x97, 0x75,
  0x02, 0xD0, 0xD7, 0x10, 0x8F, 0x90, 0x97, 0x75, 0x0C, 0xD0, 0xC7, 0x03, 0x0E, 0xF9, 0x09, 0x77,
  0x30, 0x30, 0xCE, 0x0C, 0x58, 0x12, 0x8E, 0xFA, 0x0D, 0x80, 0x93, 0x90, 0xA0, 0xDF, 0x98, 0x4B,
  0x02, 0xDD, 0xE8, 0x0C, 0x2F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81,
  0xA0, 0x38, 0x0C, 0x5F, 0x0A, 0x10,
  // "ľ" (U+013E)
  0x0E, 0xFF, 0x03, 0x50, 0x3E, 0x0D, 0x0E, 0xFF, 0x03, 0x50, 0x6E, 0x0A, 0x0E, 0xFF, 0x03, 0x50,
  0x8E, 0x03, 0x0E, 0xFF, 0x03, 0x50, 0xBD, 0x0C, 0x38, 0x11, 0x5A, 0xFB, 0x03, 0x50, 0xED, 0x05,
  0x60, 0x40, 0xEF, 0x90, 0x34, 0x01, 0xD0, 0xD7, 0x10, 0x7F, 0x90, 0x34, 0x03, 0xD0, 0x67, 0x10,
  0x1F, 0x90, 0x34, 0x07, 0xC0, 0xD7, 0x30, 0xEF, 0x03, 0x40, 0xAC, 0x06, 0x73, 0x0D, 0xF0, 0x34,
  0x0D, 0xB0, 0xD7, 0x40, 0xCF, 0x03, 0x30, 0x1C, 0x05, 0x74, 0x0C, 0xF0, 0x33, 0x05, 0xB0, 0xC7,
  0x50, 0xCF, 0x03, 0x30, 0x8B, 0x04, 0x75, 0x0C, 0xF0, 0x33, 0x0A, 0xA0, 0xA7, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03,
  0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xCF, 0x03, 0x77, 0x60, 0xDF, 0x04,
  0x77, 0x60, 0xEF, 0x05, 0x77, 0x50, 0x2F, 0x90, 0x87, 0x75, 0x07, 0xF9, 0x0D, 0x77, 0x40, 0x30,
  0xEF, 0xA0, 0x87, 0x78, 0x11, 0x49, 0xFD, 0x81, 0xC6, 0x27, 0x20, 0xEF, 0xFF, 0x04, 0x60, 0xEF,
  0xFF, 0x04, 0x60, 0xEF, 0xFF, 0x04, 0x60, 0xEF, 0xFF, 0x04, 0x60,
  // "Ŀ" (U+013F)
  0x03, 0xFF, 0xF9, 0x0E, 0x77, 0x60, 0x3F, 0xFF, 0x90, 0xE7, 0x76, 0x03, 0xFF, 0xF9, 0x0E, 0x77,
  0x60, 0x3F, 0xFF, 0x90, 0xE7, 0x77, 0x28, 0x11, 0x5A, 0xFD, 0x81, 0xD7, 0x37, 0x77, 0x71, 0x05,
  0xFB, 0x0C, 0x77, 0x77, 0x50, 0x9F, 0xA0, 0x37, 0x77, 0x75, 0x03, 0xF9, 0x0D, 0x77, 0x77, 0x7F,
  0x90, 0xB7, 0x77, 0x77, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09,
  0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77,
  0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77,
  0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70,
  0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF, 0x09, 0x77, 0x77, 0x70, 0xEF,
  0x09, 0x77, 0x28, 0x43, 0xAE, 0xFD, 0x87, 0x60, 0xEF, 0x09, 0x77, 0x10, 0x4E, 0x0D, 0x01, 0x74,
  0x0E, 0xF0, 0x97, 0x71, 0x0D, 0xF0, 0x97, 0x40, 0xEF, 0x09, 0x77, 0x03, 0xF9, 0x0E, 0x74, 0x0E,
  0xF0, 0x97, 0x70, 0x5F, 0xA0, 0x17, 0x30, 0xEF, 0x09, 0x77, 0x06, 0xFA, 0x01, 0x73, 0x0E, 0xF0,
  0x97, 0x70, 0x5F, 0xA0, 0x17, 0x30, 0xEF, 0x09, 0x77, 0x03, 0xF9, 0x0E, 0x74, 0x0E, 0xF0, 0x97,
  0x71, 0x0D, 0xF0, 0x97, 0x40, 0xEF, 0x09, 0x77, 0x10, 0x4E, 0x0D, 0x01, 0x74, 0x0E, 0xF0, 0x97,
  0x72, 0x84, 0x3A, 0xEF, 0xD8, 0x76, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77,
  0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E,
  0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x77, 0x0E, 0xF0,
  0x97, 0x77, 0x77, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0x20, 0xF4, 0x72, 0x0E, 0xF0, 0x97, 0x77, 0x10,
  0xCB, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x10, 0xEB, 0x02, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x1C,
  0x01, 0x71, 0x0E, 0xF0, 0x97, 0x77, 0x02, 0xC0, 0x17, 0x10, 0xEF, 0x09, 0x77, 0x70, 0x4C, 0x72,
  0x0E, 0xF0, 0x97, 0x77, 0x06, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x70, 0x8C, 0x72, 0x0E, 0xF0, 0x97,
  0x77, 0x0A, 0xC7, 0x20, 0xEF, 0x09, 0x77, 0x70, 0xEB, 0x0E, 0x72, 0x0E, 0xF0, 0x97, 0x76, 0x03,
  0xC0, 0xE7, 0x2F, 0x90, 0x97, 0x76, 0x09, 0xC0, 0xD7, 0x10, 0x3F, 0x90, 0x97, 0x75, 0x02, 0xD0,
  0xD7, 0x10, 0x8F, 0x90, 0x97, 0x75, 0x0C, 0xD0, 0xC7, 0x03, 0x0E, 0xF9, 0x09, 0x77, 0x30, 0x30,
  0xCE, 0x0C, 0x58, 0x12, 0x8E, 0xFA, 0x0D, 0x80, 0x93, 0x90, 0xA0, 0xDF, 0x98, 0x4B, 0x02, 0xDD,
  0xE8, 0x0C, 0x2F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xB0, 0x38, 0x0C, 0x5F, 0x81, 0xA0, 0x38,
  0x0C, 0x5F, 0x0A, 0x10,
  // "ŀ" (U+0140)
  0x0E, 0xFF, 0x03, 0x77, 0x20, 0xEF, 0xF0, 0x37, 0x72, 0x0E, 0xFF, 0x03, 0x77, 0x20, 0xEF, 0xF0,
  0x37, 0x74, 0x81, 0x15, 0xAF, 0xB0, 0x37, 0x77, 0x04, 0x0E, 0xF9, 0x03, 0x77, 0x71, 0x07, 0xF9,
  0x03, 0x77, 0x71, 0x01, 0xF9, 0x03, 0x77, 0x72, 0x0E, 0xF0, 0x37, 0x77, 0x20, 0xDF, 0x03, 0x77,
  0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF,
  0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77,
  0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0,
  0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72,
  0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03,
  0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20,
  0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x78, 0x43, 0xAE, 0xFD, 0x87,
  0x30, 0xCF, 0x03, 0x60, 0x4E, 0x0D, 0x01, 0x71, 0x0C, 0xF0, 0x36, 0x0D, 0xF0, 0x97, 0x10, 0xCF,
  0x03, 0x50, 0x3F, 0x90, 0xE7, 0x10, 0xCF, 0x03, 0x50, 0x5F, 0xA0, 0x17, 0x0C, 0xF0, 0x35, 0x06,
  0xFA, 0x01, 0x70, 0xCF, 0x03, 0x50, 0x5F, 0xA0, 0x17, 0x0C, 0xF0, 0x35, 0x03, 0xF9, 0x0E, 0x71,
  0x0C, 0xF0, 0x36, 0x0D, 0xF0, 0x97, 0x10, 0xCF, 0x03, 0x60, 0x4E, 0x0D, 0x01, 0x71, 0x0C, 0xF0,
  0x37, 0x84, 0x3A, 0xEF, 0xD8, 0x73, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C,
  0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77,
  0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF, 0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37, 0x77, 0x20, 0xCF,
  0x03, 0x77, 0x72, 0x0C, 0xF0, 0x37